﻿USE sofia;
DROP TABLE IF EXISTS sofia.xsm_vpl;
CREATE TABLE xsm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xsm_vpl WRITE;
INSERT INTO xsm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Zezi Krisi nabaara bam kuri na puli te tɩn mʋ tɩntʋ: Zezi Krisi yɩ Davidi dwi tu mʋ, Davidi dɩ maa yɩ Abraham dwi tu. ");
INSERT INTO xsm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ma lʋ Yizakɩ. Yizakɩ ma lʋ Zakɔbɩ. Zakɔbɩ ma lʋ Zuda dɩ o zɩmbaara dɩ o nyaana. ");
INSERT INTO xsm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda dɩ Tamaarɩ ma lʋ Farɛsɩ dɩ Zara. Farɛsɩ ma lʋ Esrɔm. Esrɔm ma lʋ Aram. ");
INSERT INTO xsm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ma lʋ Amɩnadabɩ. Amɩnadabɩ ma lʋ Naasɔn. Naasɔn ma lʋ Salɩmɔn. ");
INSERT INTO xsm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salɩmɔn dɩ o kaanɩ Rahabɩ ma lʋ Bʋazɩ. Bʋazɩ dɩ o kaanɩ Ruuti ma lʋ Obɛdɩ. Obɛdɩ ma lʋ Zese. ");
INSERT INTO xsm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese ma lʋ Davidi wʋlʋ na jigi pɛ tɩn. Davidi dɛɛn di kadǝm wʋlʋ na yɩ Yuri kaanɩ tɩn, yɩ ba lʋ Salɔmɔn. ");
INSERT INTO xsm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salɔmɔn ma lʋ Robʋam. Robʋam ma lʋ Abɩa. Abɩa ma lʋ Aza. ");
INSERT INTO xsm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza ma lʋ Zʋzafatɩ. Zʋzafatɩ ma lʋ Zʋram. Zʋram ma lʋ Yozɩasɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yozɩasɩ ma lʋ Zʋatam. Zʋatam ma lʋ Asasɩ. Asasɩ ma lʋ Ezekɩasɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekɩasɩ ma lʋ Manasɩ. Manasɩ ma lʋ Amɔn. Amɔn ma lʋ Zʋzɩasɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zʋzɩasɩ ma lʋ Yɩkonɩa dɩ o nyaana. Yɩkonɩa mɩmaŋa kam nɩ mʋ ba jaanɩ Yisɩrayɛlɩ tiinǝ bam ba vu ba yagɩ Babilɔnɩ tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yisɩrayɛlɩ tiinǝ bam viirim dɩm kwaga nɩ mʋ Yɩkonɩa lʋgɩ Salatɩyɛlɩ. Salatɩyɛlɩ ma lʋ Zorobabɛlɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛlɩ ma lʋ Abidu. Abidu ma lʋ Eliyakɩm. Eliyakɩm ma lʋ Azori. ");
INSERT INTO xsm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori ma lʋ Sadoki. Sadoki ma lʋ Akimi. Akimi ma lʋ Eliyudi. ");
INSERT INTO xsm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudi ma lʋ Eleyazaarɩ. Eleyazaarɩ ma lʋ Matan. Matan ma lʋ Zakɔbɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔbɩ ma lʋ Zʋzɛfʋ, wʋntʋ mʋ jigi Mari barʋ. Mari dɛɛn ma ba o lʋ Zezi wʋlʋ ba na bǝŋi nɩ Krisi. ");
INSERT INTO xsm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kʋntʋ maa brɩ nɩ, kʋ na zɩgɩ Abraham nɩ kʋ vu kʋ yi Davidi tɩn, ba dwi dɩm yɩ kuni fugǝ-bɩna mʋ. Kʋ na zɩgɩ Davidi nɩ kʋ vu kʋ yi Yisɩrayɛlɩ tiinǝ bam viirim dɩm maŋa kam nɩ tɩn, bantʋ dɩ dwi dɩm yɩ kuni fugǝ-bɩna mʋ. Kʋ na zɩgɩ maŋa kam kʋntʋ nɩ sɩ kʋ vu kʋ yi ba na lʋgɩ Zezi Krisi maŋa kalʋ tɩn, bantʋ dɩ dwi dɩm maa yɩ kuni fugǝ-bɩna. ");
INSERT INTO xsm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ba na lʋgɩ Zezi Krisi te tɩn mʋ tɩntʋ. O nu Mari dɩ Zʋzɛfʋ tiinǝ maama dɛɛn ya sɛ sɩ ba pa ba zʋ daanɩ, yɩ Mari daa ta wʋ ve o barʋ wʋm te. Maŋa kam kʋntʋ nɩ o ma ba o ja pugǝ dɩ Wɛ Joro dam. ");
INSERT INTO xsm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zʋzɛfʋ wʋlʋ o na lagɩ o zʋ tɩn maa yɩ nɔn-ŋʋm. O maa ba lagɩ sɩ o pa cavɩɩra ja o kaanɩ wʋm nɔɔna maama yigǝ nɩ. O ma bʋŋɩ sɩ o daanɩ o yag-o, sɩ nɔɔna yɩ zaŋɩ ba lwarɩ. ");
INSERT INTO xsm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","O na bʋŋɩ kʋntʋ tɩn, Baŋa-Wɛ malɛka ma ba o te o dɩndwɩa wʋnɩ, yɩ ka ta dɩd-o ka wɩ: «Zʋzɛfʋ, Pɛ Davidi dwi tu, yɩ pa n wʋ cɔgɩ sɩ n joŋi Mari n ma n ji n kaanɩ. Bɛŋwaanɩ, o na jɩgɩ pugǝ kam tɩn, kʋ yɩ Wɛ Joro kʋm dam ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O lagɩ o lʋ bǝkǝrǝ mʋ, sɩ n pa o yɩrɩ nɩ Zezi, bɛŋwaanɩ oó ba o vrɩ o nɔɔna ba lwarɩm wʋnɩ o yagɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Zezi lʋra kam dɛɛn sɩɩnɩ ka tɔgɩ kʋntʋ doŋ mʋ, sɩ kʋ pa Baŋa-Wɛ dɛɛn na tagɩ kʋlʋ tɩn sɩɩnɩ kʋ kɩ. Faŋa faŋa tɩn, DƖ nijoŋnu wʋdoŋ dɛɛn tɔɔlɩ DƖ kwǝrǝ kam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Bukɔ wʋlʋ ta na yǝri baarʋ tɩn wʋ́ ba o ja pugǝ o lʋ bǝkǝrǝ, yɩ baá bǝŋi bu wʋm yɩrɩ nɩ Emanuyɛlɩ.» O yɩrɩ dɩm kʋntʋ kuri mʋ yɩ Wɛ wʋra dɩdaanɩ dɩbam. ");
INSERT INTO xsm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zʋzɛfʋ na dɔ o zaŋɩ tɩn, o ma sɛ o kɩ Baŋa-Wɛ malɛka kam na tagɩ nɩ o kɩ te tɩn. O ma sɛ o joŋi Mari o ja vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","O ma wʋ pǝni dɩd-o sɩ kʋ vu kʋ yi o na lʋgɩ bu wʋm maŋa kalʋ tɩn. O laan ma pa o yɩrɩ nɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ba dɛɛn lʋgɩ Zezi Zude tɩʋ kʋdoŋ nɩ mʋ, kʋ yɩrɩ mʋ Betelɩhɛm. Kʋ maa yɩ maŋa kalʋ Erɔdɩ dɛɛn na yɩ pɛ tɩn. Yiyǝn-yeenǝ badaara dɛɛn ma nuŋi wa-puli seeni ba ba ba yi Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ba laan ma bwe nɔɔna ba wɩ: «Bu wʋm ba na lʋgɩ sɩ o ji Zwifǝ pɛ tɩn wʋ yǝn mʋ? Bɛŋwaanɩ dɩbam nɛ calɩcʋa kalʋ na brɩ o lʋra kam tɩn na nuŋi bri-kwaga seeni, yɩ dɩbam ba sɩ dɩ́ zul-o.» ");
INSERT INTO xsm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pɛ Erɔdɩ dɛɛn na ni kʋntʋ tɩn, liǝ maa jɩg-o dɩ nɔɔna balʋ maama na zʋʋrɩ Zeruzalɛm nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O laan ma bǝŋi Zwifǝ kaanɩm yigǝ tiinǝ bam maama, dɩdaanɩ Wɛ cullu karanyɩna tiinǝ bam, yɩ ba la daanɩ. O ma bwe-ba o wɩ: «Yǝn mʋ ba maŋɩ sɩ ba lʋ Krisi wʋm?» ");
INSERT INTO xsm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ba ma lǝr-o ba wɩ: «Kʋʋ́ ta yɩ Betelɩhɛm nɩ mʋ, Zude tɩʋ nɩ. Bɛŋwaanɩ faŋa faŋa Wɛ nijoŋnu wʋdoŋ pʋpʋnɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Betelɩhɛm, tɩʋ kʋlʋ na yɩ balaŋa Zude tɩɩnɩ dɩm wʋnɩ tɩn, daɩ tɩʋ kʋlʋ na muri tɩn. Bɛŋwaanɩ nmʋ wʋnɩ mʋ baá lʋ dɩdɛɛrʋ wʋlʋ na wʋ́ ta nii a nɔɔna balʋ na yɩ Yisɩrayɛlɩ dwi tiinǝ tɩn baŋa nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erɔdɩ na ni kʋntʋ tɩn, o ma daanɩ o bǝŋi yiyǝn-yeenǝ bam sɩ ba ba o te. O ma kwaanɩ o bwe-ba, sɩ o lwarɩ dɛ dɩm calɩcʋa kam na puli ka nuŋi tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","O laan ma tʋŋɩ-ba sɩ ba vu Betelɩhɛm, yɩ o wɩ: «Ve-na á kwaanɩ á beeri bu wʋm jǝgǝ, sɩ á na nɛ-o, sɩ á joori á ba á ta á brɩ-nɩ, sɩ a dɩ vu a zul-o.» ");
INSERT INTO xsm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pɛ wʋm na tagɩ kʋntʋ dɩ ba tɩn, ba laan ma zaŋɩ ba maa kɛa. Ba na maa kɛ tɩn, ba ma da ba na calɩcʋa kalʋ ba ya na maŋɩ ba na wa-puli seeni tɩn. Ka laan maa wʋ ba yigǝ nɩ wɛyuu nɩ ka veǝ, yɩ ka vu ka zɩgɩ ka maŋɩ dɩ bu wʋm na wʋ mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kʋ ma pa ba tiini ba jɩgɩ wʋpolo lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ba ma vu ba zʋ sɔŋɔ kʋm wʋ. Ba ma na bu wʋm dɩ o nu Mari. Ba ma kuni doonǝ ba zul-o. Ba laan ma bwǝli ba zɩla ba lɩ pɛɛra ba pa-o. Ba pɛɛra yam yɩ sǝbu-sɩŋa, dɩ wǝǝnu tɩlʋ ba na zwɛ yɩ tɩ lwǝm ywǝmmǝ tɩn, dɩ tralɩ nugǝ kalʋ yɩrɩ na yɩ Miiri tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wɛ ma pa ba lwarɩ ba dɩndwɩa wʋnɩ, nɩ ba daa yɩ joori ba da Erɔdɩ te. Ba laan ma tɔgɩ cwǝ-gaa ba joori ba vu ba tɩʋ kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yiyǝn-yeenǝ bam na kɛ ba daarɩ kʋntʋ tɩn, Baŋa-Wɛ malɛka ma da ka ba Zʋzɛfʋ te o dɩndwɩa wʋnɩ, yɩ ka wɩ: «Zaŋɩ n ja bu wʋm dɩ o nu n ja n duri n vu Ezipi tɩʋ, sɩ á taá zʋʋrɩ da, sɩ kʋ yi maŋa kam a na wʋ́ pa abam ni sɩ á nuŋi Ezipi á joori á ba tɩn. Bɛŋwaanɩ Erɔdɩ mʋ lagɩ o zaŋɩ o beeri bu wʋm sɩ o gʋ-o.» ");
INSERT INTO xsm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zʋzɛfʋ na ni kʋntʋ tɩn, o ma sɩɩnɩ o zaŋɩ o ja bu wʋm dɩ o nu wʋm, o nuŋi tɩtɩɩ dɩm kʋntʋ nɩ o vu Ezipi. ");
INSERT INTO xsm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ba ma zʋʋrɩ da taan, sɩ kʋ vu kʋ yi maŋa kalʋ Erɔdɩ na tɩgɩ tɩn. Kʋ dɛɛn kɩ kʋntʋ mʋ, sɩ kʋ pa Baŋa-Wɛ dɛɛn na tagɩ kʋlʋ tɩn sɩɩnɩ kʋ kɩ. Faŋa faŋa tɩn, DƖ dɛɛn pɛ DƖ nijoŋnu wʋdoŋ tɔɔlɩ DƖ kwǝrǝ o wɩ: «Amʋ Wɛ bǝŋi a bu wʋm sɩ o nuŋi Ezipi nɩ mʋ o ba.» ");
INSERT INTO xsm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erɔdɩ dɛɛn na tu o lwarɩ nɩ yiyǝn-yeenǝ bam lʋʋrɩ o yigǝ nɩ ba viiri tɩn, o bam ma tiini dɩ zaŋɩ. O ma pa ni sɩ o nɔɔna vu Betelɩhɛm dɩ kʋ tɩ-balwa bam maama wʋnɩ, ba gʋ bǝkǝri-balɛ sɩlʋ na yi bɩna yale dɩ balʋ na muri bɩna yale tɩn maama. O nan kɩ kʋntʋ, sɩ kʋ maŋɩ dɩ yiyǝn-yeenǝ bam na pɛ o lwarɩ maŋa kalʋ calɩcʋa kam na nuŋi tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Biǝ bam gʋm dɩm ma pa Wɛ nijoŋnu Zeremi na tagɩ Wɛ kwǝrǝ kalʋ faŋa faŋa tɩn sɩɩnɩ kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","O dɛɛn tagɩ o wɩ: «Sɔɔ mʋ zaŋɩ Rama tɩʋ wʋnɩ. Nɔɔna mʋ wʋra ba keerǝ, yɩ ba coosǝ zanzan. Rasɛɛlɩ mʋ tiini o keerǝ o biǝ ŋwaanɩ, o maa ba sɛ sɩ nɔɔn-nɔɔnʋ gan-o, o biǝ bam na tɩga tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erɔdɩ dɛɛn ma ba o tɩ, yɩ Zʋzɛfʋ daa ta wʋ Ezipi nɩ. Baŋa-Wɛ malɛka ma daa ba Zʋzɛfʋ te o dɩndwɩa wʋnɩ, yɩ ka wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Zaŋɩ n ja bu wʋm dɩ o nu n joori n vu Yisɩrayɛlɩ tɩʋ. Bɛŋwaanɩ wʋlʋ ya na lagɩ sɩ o gʋ bu wʋm tɩn laan tɩga.» ");
INSERT INTO xsm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zʋzɛfʋ na ni kʋntʋ tɩn, o ma sɩɩnɩ o zaŋɩ o ja bu wʋm dɩ o nu o joori o vu Yisɩrayɛlɩ tɩʋ kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","O laan ma ba o lwarɩ nɩ Erɔdɩ bu Arɩsɩla mʋ lǝni o ko wʋm yuu nɩ o di paarɩ Zude tɩɩnɩ dɩm baŋa nɩ. Kʋ ma pa o kwarɩ fʋʋnɩ sɩ o joori o vu jǝgǝ kam kʋntʋ. O dɩndwɩa wʋnɩ Wɛ ma pa o lwarɩ kʋlʋ o na maŋɩ sɩ o kɩ tɩn, kʋ pa o lɛɛrɩ o vu Galile tɩʋ. ");
INSERT INTO xsm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","O laan ma vu o yi tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Nazarɛtɩ, yɩ o zʋʋrɩ da. Kʋ laan ma pa Wɛ nijoŋnǝ bam dɛɛn na tɔɔlɩ DƖ kwǝrǝ faŋa faŋa te tɩn sɩɩnɩ kʋ kɩ. Ba dɛɛn tagɩ ba wɩ: «Baá bǝŋ-o nɩ Nazarɛtɩ tu.» ");
INSERT INTO xsm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Zan. Wʋntʋ mʋ yɩ wʋlʋ na miisi nɔɔna na wʋnɩ tɩn. O dɛɛn ma ba o wʋ Zude nɩ o beeri kagʋa wʋnɩ, yɩ o tɔɔlɩ Wɛ kwǝrǝ. ");
INSERT INTO xsm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","O maa yǝni o ta o brɩ-ba sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, sɩ maŋa kam laan yiǝ Wɛ paarɩ dɩm na lagɩ dɩ ba nɔɔna tɩtarɩ nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zan yɩ wʋlʋ Wɛ nijoŋnu Ezayi na maŋɩ o ŋɔɔnɩ o taanɩ faŋa faŋa tɩn o wɩ: «Nɔɔnʋ mʋ wʋ kagʋa wʋnɩ o tɔɔlɩ o kwǝrǝ o wɩ: ‹Zaŋɩ-na á fɔgɩ á kwɛ dɩ́ Yuutu wʋm cwǝŋǝ kam, o na lagɩ o ba o tɔgɩ da tɩn. Pa-na cwe sɩlʋ o na lagɩ o ba o tɔgɩ tɩn fɔgɩ sɩ yɔɔrɩ lanyɩranɩ.› » ");
INSERT INTO xsm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zan dɛɛn zʋʋrɩ gɔrɔ kʋlʋ ba na sɔgɩ dɩ yogondi kʋrʋ tɩn mʋ. O maa maɩ kilǝ o ma ja o tǝŋǝ. O wʋdiu mʋ yɩ kayɩra dɩ tʋʋrʋ. ");
INSERT INTO xsm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nɔɔna zanzan maa yǝni ba nuŋi Zeruzalɛm, dɩ Zude tɩɩnɩ dɩm maama, dɩ Zʋrdɛn bugǝ ni je sɩm, ba ve o te. ");
INSERT INTO xsm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ba maa tɛ ba brɩ kʋlʋ ba na kɩ ba cɔgɩ tɩn. O laan maa paɩ ba tu Zʋrdɛn bugǝ kam wʋnɩ, yɩ o miisi-ba na wʋnɩ Wɛ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zan na wʋra o miisi nɔɔna na wʋnɩ tɩn, o nɛ nɩ Farizɩan tiinǝ dɩ Sadusɩan tiinǝ zanzan tui o te. O ma ta dɩ ba o wɩ: «Abam nyɩ dɩ bɩsankwɩ-dwǝ mʋ. Wɔɔ mʋ brɩ abam sɩ á kwaanɩ á lu cam dɩlʋ Wɛ na lagɩ DƖ pa nabiinǝ na tɩn wʋnɩ? ");
INSERT INTO xsm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Abam nan maŋɩ sɩ á taá kɩ kǝnǝ yalʋ na wʋ́ brɩ nɩ á sɩɩnɩ á lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Abam yɩ taá bʋŋa á pa á tɩtɩ nɩ, á na yɩ Abraham dwi tiinǝ tɩn, á daa wʋ maŋɩ sɩ á lǝni á wʋrʋ. Wɛ na laga, DƖ wʋ́ wanɩ DƖ pa kandwa yantʋ lǝni ya ji Abraham dwi tiinǝ. ");
INSERT INTO xsm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nɔɔnʋ nan maŋɩ o jɩgɩ dooru o jɩŋa nɩ, sɩ o ta maa goni tweeru tɩm o dɩ tɩga nɩ. Tiu kʋlʋ maama na ba lǝri bu-ŋʋna tɩn, o maŋɩ sɩ o go-kʋ mʋ o dɩ mini wʋnɩ sɩ kʋ di. Mʋ Wɛ dɩ na lagɩ DƖ kɩ nɔɔna balʋ na wʋ lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Amʋ nan miisi abam na wʋnɩ mʋ, sɩ kʋ brɩ nɩ abam lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩm. Kʋ daarɩ wʋlʋ na lagɩ o saŋɩ amʋ kwaga o ba tɩn tiini o dwe amʋ. A wʋ maŋɩ sɩ a zeeri o nɛ natra dɩ. Wʋntʋ nan wʋ́ miisi abam Wɛ Joro dɩ mini wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wʋntʋ nan ze zʋŋ-kɔgɔ mʋ sɩ o ma caarɩ o mɩna o pɛ o kɩ o tulǝ nɩ, sɩ o daarɩ mɩn-swaanʋ tɩm o zwɛ dɩ mini dɩlʋ na ba di dɩ dwe tɩn. Mʋ Wɛ na lagɩ DƖ pɔɔrɩ nɔɔna daanɩ DƖ kɩ-ba te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Zan dɛɛn na wʋ Zʋrdɛn bugǝ kam ni nɩ tɩn, Zezi ma nuŋi Galile tɩʋ nɩ o vu o te sɩ o miis-o na wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zan dɛɛn ya wʋ sɛ, yɩ o ta dɩd-o o wɩ: «Amʋ mʋ maŋɩ sɩ a ba nmʋ te sɩ n miisi-nɩ na wʋnɩ, sɩ kʋ daɩ nmʋ mʋ wʋ́ ba amʋ te sɩ a miisi-m na wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Zezi ma lǝr-o o wɩ: «Yagɩ sɩ kʋ kɩ kʋntʋ lele, sɩ kʋ maŋɩ sɩ dɩ́ kɩ kʋntʋ mʋ, sɩ dɩ́ wanɩ dɩ́ kɩ kʋlʋ maama na yɩ Wɛ wʋbʋŋa tɩn.» O laan ma sɛ. ");
INSERT INTO xsm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zezi na miisi na kʋntʋ tɩn, o ma da o nuŋi na bam wʋnɩ. O laan ma na wɛyuu na pʋrɩ o baŋa nɩ, yɩ o na Wɛ Joro kʋm na dɛ da kʋ tu o baŋa, yɩ kʋ nyɩ dɩ kunkwǝŋǝ te. ");
INSERT INTO xsm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kwǝrǝ laan ma ŋɔɔnɩ wɛyuu nɩ ka wɩ: «Wʋntʋ mʋ yɩ amʋ bu-dʋa a na so-o dɩ a wʋ maama. O ma yǝni o pa a wʋ poli zanzan.» ");
INSERT INTO xsm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wɛ Joro kʋm dɛɛn na tu Zezi te kʋntʋ tɩn, kʋ laan ma ja-o kʋ vu kagʋa wʋnɩ, sɩ sʋtaanɩ maŋ-o dɩ nii. ");
INSERT INTO xsm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zezi dɛɛn maa wʋra taan da fiinna, yɩ o ba di wʋdiu wɩa dɩ tɩtɩɩ maama. Kana maa jɩg-o. ");
INSERT INTO xsm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sʋtaanɩ laan ma ba o te, yɩ dɩ ta dɩd-o dɩ wɩ: «Nmʋ na sɩɩnɩ n yɩ Baŋa-Wɛ Bu, sɩ n ta dɩ kandwa yantʋ sɩ ya ji wʋdiu sɩ n di.» ");
INSERT INTO xsm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Zezi ma lǝri o wɩ: «Kʋ nan pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kʋ daɩ wʋdiu yɩranɩ mʋ paɩ nabiinu ŋwɩ, kʋ yɩ Wɛ ni-taanɩ dɩm maama mʋ paɩ nabiinu ŋwɩa.› » ");
INSERT INTO xsm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sʋtaanɩ laan ma ja-o dɩ ja vu dɩ zʋ Wɛ tɩtɩ tɩʋ Zeruzalɛm wʋ. Dɩ ma ja-o dɩ vu dɩ di Wɛ-di-kamunu kʋm yuu mɛ na dwara tɩn dɩ zɩg-o da, ");
INSERT INTO xsm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yɩ dɩ wɩ: «Nmʋ na yɩ Wɛ Bu, sɩ n faŋɩ n cu tɩga nɩ sɩ dɩ́ nii. Bɛŋwaanɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Wɛ wʋ́ pa DƖ malɛsɩ ba nmʋ ŋwaanɩ, sɩ lwǝri-m dɩ sɩ jɩa, sɩ n yɩ tʋ tɩga nɩ n magɩ n naga dɩ kandwɛ.› » ");
INSERT INTO xsm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zezi ma lǝri o wɩ: «Kʋ ta pʋpʋnɩ kʋ wɩ: ‹Yɩ zaŋɩ n maŋɩ n Yuutu Baŋa-Wɛ n nii.› » ");
INSERT INTO xsm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sʋtaanɩ daa ma ja-o dɩ ja vu dɩ di piu kʋlʋ na tiini kʋ dwara tɩn yuu. Dɩ laan ma brɩ-o lʋgʋ baŋa tɩɩnɩ dɩm maama dɩ wo-laarʋ tɩlʋ maama na wʋra tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dɩ ma ta dɩd-o dɩ wɩ: «Nmʋ na sɛ n kuni doonǝ n zuli amʋ, aá pa n ta n te wǝǝnu tɩntʋ maama.» ");
INSERT INTO xsm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zezi laan ma ta dɩ-dɩ o wɩ: «Sʋtaanɩ, ve daa a tee nɩ! Sɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kʋ yɩ n Yuutu Baŋa-Wɛ yɩranɩ mʋ n maŋɩ sɩ n kuni doonǝ n zuli, sɩ n kɩ DƖ wʋbʋŋa na lagɩ te tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sʋtaanɩ laan ma viiri dɩ daar-o. Wɛ malɛsɩ laan ma ba Zezi te sɩ zǝn-o. ");
INSERT INTO xsm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zezi dɛɛn na lwarɩ nɩ ba jaanɩ Zan ba kɩ pɩɩna digǝ nɩ tɩn, o ma joori o vu Galile. ");
INSERT INTO xsm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O maa daa wʋ maŋɩ Nazarɛtɩ nɩ, yɩ o kɛ o vu Galile tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Kapɛrnawum, o zʋʋrɩ da. Tɩʋ kʋm kʋntʋ wʋ nɩnɩʋ ni nɩ mʋ, dɩ je sɩlʋ Zabulɔn dwi tiinǝ dɩ Nɛfitali dwi tiinǝ ya na zʋʋrɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","O na zʋʋrɩ da kʋntʋ tɩn, kʋ dɛɛn ma pa Wɛ nijoŋnu Ezayi na maŋɩ o tɔɔlɩ Wɛ kwǝrǝ faŋa faŋa te tɩn sɩɩnɩ kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","O dɛɛn tagɩ o wɩ: «Kʋ na yɩ Zabulɔn dɩ Nɛfitali tɩɩnɩ dɩm, dɩ je sɩlʋ na wʋ nɩnɩʋ kʋm seeni tɩn, dɩ je sɩlʋ na wʋ Zʋrdɛn bugǝ kam bubɛ dɩdoŋ dɩm kwaga nɩ tɩn, dɩ Galile je sɩlʋ dwi-gɛ tiinǝ na zʋʋrɩ da tɩn, ");
INSERT INTO xsm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jǝgǝ kantʋ tiinǝ bam dɛɛn ya wʋ lim wʋnɩ mʋ, yɩ ba laan ba ba na pooni zanzan. Balʋ na zʋʋrɩ da tɩn ya ba jɩgɩ tɩɩna dɩ Wɛ, tʋʋnɩ mʋ ya te-ba. Pooni laan ma zǝŋi ba baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Zezi na joori o vu Galile tɩn, kʋ zɩgɩ maŋa kantʋ nɩ mʋ o puli o tɔɔlɩ Wɛ kwǝrǝ, o brɩ nɔɔna nɩ ba maŋɩ sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, bɛŋwaanɩ maŋa kam laan yiǝ Wɛ paarɩ dɩm na lagɩ dɩ ba nɔɔna tɩtarɩ nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zezi dɛɛn maa wʋ Galile nɩnɩʋ kʋm ni nɩ o veǝ. O ma na nɔɔna bale, ba yɩ cʋrʋ mʋ. Ba dɩdʋa yɩrɩ mʋ Simɔn, o yɩrɩ dɩdoŋ maa yɩ Pɩyɛɛrɩ. Wʋdoŋ wʋm maa yɩ o nyaanɩ, o yɩrɩ mʋ Andre. Ba yɩ kalǝŋ-jara mʋ, yɩ ba wʋ na bam wʋnɩ ba dʋlɩ bʋrɩ ba ma jaanɩ kale. ");
INSERT INTO xsm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zezi laan ma ta dɩ ba o wɩ: «Zaŋɩ-na á ba á taá tɔgɩ-nɩ. Aá pa á taá beeri nɔɔna mʋ á pa-nɩ sɩ ba da amʋ kwaga, nɩ á na yǝni á jaanɩ kale te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","O na tagɩ kʋntʋ tɩn, ba ma zaŋɩ lɩla ba yagɩ ba bʋrɩ sɩm, yɩ ba vu ba tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zezi na ve o maa kɛ tɩn, o daa ma na nɔɔna bale, ba dɩ yɩ cʋrʋ mʋ. Ba ko yɩrɩ mʋ Zebede. Ba dɩdʋa yɩrɩ mʋ Zakɩ. Wʋdoŋ wʋm maa yɩ o nyaanɩ, o yɩrɩ mʋ Zan. Bantʋ bale dɩ ba ko Zebede maa wʋ naboro wʋnɩ ba kwɛ ba bʋrɩ, sɩ ba ma ja kale. O ma bǝŋi biǝ bam sɩ ba ba ba taa tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","O na bǝŋi-ba kʋntʋ tɩn, ba ma zaŋɩ lɩla ba yagɩ ba ko wʋm dɩ naboro kʋm, yɩ ba vu ba tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zezi dɛɛn maa tʋlɩ Galile tɩɩnɩ dɩm maama. O maa yǝni o ve Zwifǝ bam Wɛ-di sɩm sɩ o taa brɩ nɔɔna Wɛ cɩga kam. O maa tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam dɩ Wɛ na lagɩ DƖ di paarɩ nɔɔna tɩtarɩ nɩ te tɩn. O maa kwǝri o pa yawɩɩna na yazurǝ dɩ yawɩɩrʋ tɩlʋ dwi maama na jɩgɩ-ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɔɔna ma ba ba ni o ŋwa je sɩm kʋntʋ nɩ, dɩ Siiri tɩʋ kʋm maama wʋnɩ. Ba maa yǝni ba jaanɩ yawɩɩna dwi dwi ba tu o te, balʋ yɩra na tiini ya wɔɛ tɩn, kʋ wǝli dɩ balʋ ciciri na yaarɩ-ba tɩn, dɩ balʋ na saɩ kɔɔrʋ tɩn, dɩ kwaarʋ. Ba na tu Zezi te kʋntʋ tɩn, o maa yǝni o pa ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɔn-kɔgɔ zanzan dɛɛn ma nuŋi Galile tɩɩnɩ dɩm, dɩ je sɩlʋ ba na bǝ nɩ Tɩɩnɩ Fugǝ tɩn, dɩ Zeruzalɛm, dɩ Zude maama, dɩ je sɩlʋ na wʋ Zʋrdɛn bugǝ kam bubɛ dɩdoŋ dɩm nɩ tɩn ba tɔgɩ dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Zezi dɛɛn na nɛ nɔn-kɔgɔ na tɔg-o tɩn, o ma vu o di piu kʋdoŋ yuu o jǝni da. O na je tɩn, o karabiǝ bam ma ba o te. ");
INSERT INTO xsm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","O laan ma puli o brɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Balʋ na ye nɩ ba yɩ yinigǝ tiinǝ Wɛ yigǝ nɩ tɩn mʋ jɩgɩ yu-yoŋo, ba na wʋ́ tɔgɩ ba di Wɛ paarɩ dɩm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Balʋ wʋrʋ na cɔgɩ tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ pa-ba wʋ-zuru tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Balʋ na jɩgɩ ban-pʋnʋ tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ pa ba taa te lʋgʋ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Balʋ na paɩ Wɛ cɩga kam tɔgɩm jɩgɩ fra dɩ ba tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ pa ba bɩcara pǝni tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Balʋ na jɩgɩ nɔɔna ŋwaŋa tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ duri ba dɩ ŋwaŋa tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Balʋ na yɩ wʋ-poŋo tiinǝ tɩn mʋ jɩgɩ yu-yoŋo, ba na wʋ́ ba ba na Wɛ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Balʋ na paɩ nɔɔna jɩgɩ ywǝǝni daanɩ tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ ta bǝ-ba nɩ DƖ biǝ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Balʋ na tɔgɩ Wɛ cɩga kam yɩ nɔɔna bɛɛsɩ-ba tɩn mʋ jɩgɩ yu-yoŋo, ba na wʋ́ tɔgɩ ba di Wɛ paarɩ dɩm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nɔɔna na twɩ abam yɩ ba bɛɛsɩ abam, yɩ ba fɔ vwan ba tɛ wo-balwaarʋ dwi maama ba pa abam amʋ yɩrɩ ŋwaanɩ tɩn, á jɩgɩ yu-yoŋo. ");
INSERT INTO xsm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Á taá jɩgɩ wʋpolo lanyɩranɩ sɩ Wɛ wʋ́ pa á na nyɔɔrɩ zanzan DƖ tee nɩ. Kʋ na yɩ Wɛ nijoŋnǝ balʋ dɛɛn na loori abam yigǝ ba ba tɩn, nɔɔna dɛɛn maŋɩ ba bɛɛsɩ-ba kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yɛ na paɩ wʋdiu ywǝnǝ te tɩn, abam dɩ nan maŋɩ sɩ á taá paɩ ywǝǝni taa wʋ nabiinǝ tee nɩ. Yɛ ywǝǝni nan na ti, n daa n bá wanɩ n pa dɩ joori dɩ ja ywǝǝni. Dɩ daa ba jɩgɩ kuri. Baá dɩ-dɩ ba yagɩ mʋ, sɩ nɔɔna taa nwanɩ dɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Abam nyɩ dɩ lʋgʋ baŋa pooni mʋ nabiinǝ tɩtarɩ nɩ. Tɩʋ kʋlʋ ba na lɔgɩ piu yuu nɩ tɩn bá wanɩ kʋ sǝgi, kʋ naɩ mʋ jaja. ");
INSERT INTO xsm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nɔɔn-nɔɔnʋ bá sɛ o tarɩgɩ kanɩa o pu tɩtɔgɔ kuri nɩ. Oó kwe-ka o palɩ wɛɛnɩ mʋ, sɩ ka pooni dɩm taa naɩ dɩ paɩ nɔɔna balʋ maama na wʋ digǝ kam wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Abam dɩ nan maŋɩ sɩ á zǝŋi á pooni dɩm kʋntʋ mʋ nɔɔna tɩtarɩ nɩ. Ba laan wʋ́ na wo-laarʋ tɩlʋ á na kɩ tɩn, yɩ ba zuli á Ko Wɛ wʋlʋ na wʋ wɛyuu nɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Abam nan yɩ taá bʋŋɩ nɩ amʋ tu sɩ a pa Wɛ tɔnɔ kʋm na brɩ kʋlʋ tɩn ji kafɛ, kʋ na yɩ Wɛ cullu tɩlʋ DƖ dɛɛn na pɛ Moyisi, dɩ DƖ nijoŋnǝ bam na brɩ kʋlʋ faŋa faŋa tɩn dɩ. Amʋ tu sɩ a pa tɩ tiini tɩ taa jɩgɩ kuri mʋ lanyɩranɩ, sɩ kʋ daɩ nɩ a lagɩ a cɔgɩ-tɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A lagɩ a ta cɩga mʋ dɩ abam sɩ, lʋgʋ baŋa dɩ wɛyuu na wʋ́ daanɩ sɩ kʋ taa ve maŋa kalʋ tɩn, kʋlʋkʋlʋ bá wanɩ kʋ lɩ Wɛ cullu tɩm wʋnɩ dɩ fɩnfɩɩn dɩ. Tɩ nan wʋ́ ta wʋra kʋntʋ mʋ taan, sɩ kʋ ba kʋ yi maŋa kalʋ Wɛ na wʋ́ pa woŋo maama kɩ kʋ ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nɔɔnʋ wʋlʋ maama na wʋ sɛ Wɛ niǝ yam dɩdʋa yɩ o daarɩ o brɩ o donnǝ sɩ ba dɩ yɩ sɛ-dɩ tɩn, dɩ na maŋɩ dɩ yɩ mɩmɩɩ dɩ, kʋntʋ tu wʋ́ ba ji balaŋa Wɛ paarɩ dɩm wʋnɩ. Kʋ daarɩ, wʋlʋ maama na sɛ Wɛ niǝ yam yɩ o daarɩ o brɩ o donnǝ sɩ ba dɩ sɛ tɩn, kʋntʋ tu wʋ́ ba ji kamunu Wɛ paarɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Á nan taá ye nɩ, abam na wʋ sɛ Wɛ cɩga kam á dwǝni á cullu karanyɩna tiinǝ bam dɩ Farizɩan tiinǝ bam, á bá wanɩ á na cwǝŋǝ sɩ á tɔgɩ á zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Abam ye nɩ ba dɛɛn brɩ dɩbam kwǝ bam ba wɩ: ‹Yɩ zaŋɩ n gʋ nɔɔnʋ. Wʋlʋ nan na gʋ nɔɔnʋ, ba maŋɩ sɩ ba di o taanɩ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kʋ daarɩ, a nan lagɩ a ta dɩ abam nɩ, nɔɔnʋ wʋlʋ na jɩgɩ ban-zɔŋɔ dɩ o ko-bu, kʋ maŋɩ sɩ ba di kʋntʋ tu dɩ taanɩ mʋ. Wʋlʋ na tagɩ dɩ o ko-bu o wɩ, o ba jɩgɩ wʋbʋŋa, kʋ maŋɩ sɩ dɩbam sarɩya-dirǝ nakwa bam mʋ di kʋntʋ tu taanɩ. Nɔɔnʋ wʋlʋ dɩ na tagɩ dɩ o ko-bu o wɩ, o yɩ joro, kʋ maŋɩ sɩ kʋntʋ tu zʋ min-tɩʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kʋntʋ ŋwaanɩ, nmʋ na lagɩ n kwe n pɛɛrɩ n pa Wɛ, yɩ n laan na guli nɩ n ko-bu jɩgɩ n ban-zɔŋɔ, ");
INSERT INTO xsm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sɩ n tiŋi n pɛɛrɩ dɩm, sɩ n joori n vu n ko-bu wʋm te sɩ á fɔgɩ daanɩ. Nmʋ na kɩ kʋntʋ, sɩ n laan joori n ba n kwe n pɛɛrɩ dɩm n pa Wɛ. ");
INSERT INTO xsm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kʋ daarɩ, nɔɔnʋ nan na jaanɩ-m o vu o saŋɩ, sɩ n kɩ lɩla n pa á fɔgɩ daanɩ yɩ á daa ta wʋ yi sarɩya yam dim jǝgǝ kam. Kʋ na daɩ kʋntʋ, o laan wʋ́ kɩ nmʋ sarɩya-diru wʋm jɩŋa nɩ, sɩ o pa n na cam. Wʋntʋ dɩ laan wʋ́ kɩ-m o tɩntʋŋnʋ jɩŋa nɩ, sɩ o ja-m o vu o kɩ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A lagɩ a ta cɩga dɩ nmʋ sɩ, nń ta n wʋra taan. Nmʋ na wʋ ŋwɩ jɩnɩ dɩm maama n ti, ba bá yagɩ-m.» ");
INSERT INTO xsm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Abam nan ye nɩ ba maŋɩ ba ta ba wɩ: ‹Yɩ zaŋɩ n pǝni dɩ n doŋ kaanɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amʋ nan lagɩ a ta abam nɩ, nɔɔnʋ wʋlʋ na nii kaanɩ dɩ fra tɩn, kʋ nyɩ dɩ o maŋɩ o pǝni dɩd-o mʋ o wʋbʋŋa na lag-o tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kʋntʋ tɩn, nmʋ jazɩm yi na paɩ n kɩ lwarɩm, sɩ n lɩ-dɩ n yagɩ. Nmʋ yɩra daa dɩdʋa na cɔgɩ, kʋʋ́ ta lana kʋ pa-m kʋ dwe n yɩra yam maama na wʋra yɩ ba dɩ-ya min-tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nmʋ jazɩm mʋ na paɩ n kɩ lwarɩm, sɩ n go-dɩ n yagɩ. Nmʋ yɩra daa dɩdʋa na cɔgɩ, kʋʋ́ ta lana kʋ pa-m kʋ dwe n yɩra yam maama na zʋ min-tɩʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ba maŋɩ ba ta ba wɩ: ‹Nɔɔnʋ wʋlʋ na yagɩ o kaanɩ, kʋntʋ tu maŋɩ sɩ o pa-o tɔnɔ kʋlʋ na wʋ́ brɩ nɩ ba yagɩ daanɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amʋ nan lagɩ a ta abam nɩ, nɔɔnʋ wʋlʋ na yagɩ o kaanɩ yɩ kʋ daɩ nɩ o cɔgɩ dɩ baarʋ tɩn, kʋntʋ tu pɛ kaanɩ wʋm kɩ bwǝŋǝ mʋ, dɩ o daa na zʋ barʋ wʋdoŋ tɩn. Nɔɔnʋ wʋlʋ maama nan na di kaanɩ wʋm kʋntʋ tɩn, kʋntʋ tu dɩ kɩ bwǝŋǝ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Abam maŋɩ á ye nɩ ba dɛɛn brɩ dɩbam kwǝ bam ba wɩ: ‹Yɩ zaŋɩ n kwanɩ n ni, dɩ nmʋ na dugǝ n wɩ nń kɩ kʋlʋ n pa n Yuutu Baŋa-Wɛ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amʋ nan lagɩ a ta a brɩ abam sɩ á yɩ zaŋɩ á du dɩ kʋlʋkʋlʋ. Yɩ zaŋɩ á du durǝ dɩ Wɛ-sɔŋɔ, bɛŋwaanɩ dáanɩ mʋ yɩ Wɛ jǝŋǝ je. ");
INSERT INTO xsm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yɩ du-na dɩ tɩga baŋa dɩ, ka na yɩ Wɛ nɛ cwiim jǝgǝ tɩn ŋwaanɩ. Nan yɩ du-na dɩ Zeruzalɛm dɩ, sɩ kʋntʋ yɩ Wɛ pa-farʋ wʋm tɩʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nan yɩ zaŋɩ á du dɩ á tɩtɩ yuu dɩ, bɛŋwaanɩ á bá wanɩ á pa á yuuyuǝ dɩdʋa tɩtɩ lǝni ka ji napoŋo naa nazono. ");
INSERT INTO xsm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nan pa-na abam ‹ɛɛn› ji ‹ɛɛn›, sɩ abam ‹awo› ji ‹awo›, sɩ á daa yɩ wǝli kʋlʋkʋlʋ da. Woŋo na wǝli da, kʋntʋ yɩ sʋtaanɩ nyɩm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Abam maŋɩ á ni sɩ ba tagɩ ba wɩ: ‹Nɔɔnʋ na pi n yi, sɩ ba pi kʋntʋ tu dɩ yi. Nɔɔnʋ nan na guri n yǝli, sɩ ba guri kʋntʋ tu dɩ yǝli.› ");
INSERT INTO xsm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amʋ nan lagɩ a ta a brɩ abam nɩ, nɔɔnʋ na kɩ-m lwarɩm, sɩ n dɩ daa yɩ kɩ-o lwarɩm n ma n ŋwɩ. Nɔɔnʋ nan na lɔgɩ n jazɩm pʋpɔŋɔ, sɩ n guni kʋdoŋ kʋm dɩ, sɩ o lɔ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nɔɔnʋ nan na saŋɩ-m sɩ o joŋi n gwar-bu o jɩnɩ ŋwaanɩ, sɩ n pa o kwe n gwar-bwǝrǝ dɩ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dɩdɛɛrʋ nan na fɩ-m sɩ n zɩŋɩ o zɩla n vu nabaa yi mʋrʋ, sɩ n zɩŋɩ n vu nabaa yi mʋrr-tɩle. ");
INSERT INTO xsm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nɔɔnʋ nan na loori-m woŋo, sɩ n kwaanɩ n pa-o-kʋ. Nɔɔnʋ nan na lagɩ sɩ o jɩnɩ woŋo n tee nɩ, sɩ n yɩ van-o.» ");
INSERT INTO xsm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Abam maŋɩ á ni sɩ ba tagɩ ba wɩ: ‹N maŋɩ sɩ n ta n soe n donnǝ mʋ, sɩ n daarɩ n ta n culi n dʋna.› ");
INSERT INTO xsm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amʋ nan lagɩ a ta abam nɩ, á taá soe á dʋna, sɩ á daarɩ á taá loori Wɛ á pa balʋ na jɩgɩ abam ba bɛɛsɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Á na kɩ kʋntʋ doŋ, kʋʋ́ brɩ nɩ abam yɩ Baŋa-Wɛ biǝ mʋ. Bɛŋwaanɩ dɩntʋ ba pɔɔrɩ nɔɔna daanɩ, DƖ paɩ wɩa nyɩ nɔn-balwaarʋ dɩ nɔn-ŋʋna maama baŋa nɩ. DƖ ta kwǝri DƖ paɩ dʋa nɩ ka paɩ balʋ na kɩ lanyɩranɩ dɩ balʋ na kɩ balɔrɔ tɩn maama. ");
INSERT INTO xsm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Abam nan na soe balʋ dɩ na soe abam tɩn yɩranɩ, bɛɛ nyɔɔrɩ mʋ á wʋ́ na Wɛ tee nɩ? Lampo-joŋnǝ dɩ yǝni ba kɩ kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Abam nan na zuli á cʋrrʋ yɩranɩ mʋ, abam kɩ á dwe á donnǝ bam na? Balʋ na yǝri Wɛ tɩn dɩ nan yǝni ba kɩ kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Abam nan maŋɩ sɩ á taá yɩ lanyɩranɩ dɩ cɩga tiinǝ, nɩ á Ko Baŋa-Wɛ na yɩ lanyɩranɩ dɩ cɩga tu te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Á taá yɩrɩ á tɩtɩ, sɩ á yɩ taá brɩ kǝm-laarʋ tɩlʋ á na kɩ tɩn nɔɔna yigǝ nɩ. Á na kɩ kʋntʋ doŋ, kʋ bá pa á na nyɔɔrɩ á Ko Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kʋntʋ tɩn, á na kwe woŋo á pa yinigǝ tu, á yɩ zaŋɩ á pa nɔɔna lwarɩ abam na kɩ kʋlʋ tɩn ni nɩ, nɩ pipiri-nyɩna bam na yǝni ba brɩ ba na kɩ kʋlʋ tɩn ba Wɛ-di sɩm wʋnɩ, dɩ ba tɩʋ kʋm pooni yigǝ nɩ, sɩ kʋ ta pa nɔɔna zuli-ba te tɩn. A lagɩ a ta cɩga mʋ dɩ abam sɩ, bantʋ maŋɩ ba na ba ŋwɩɩrʋ. ");
INSERT INTO xsm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nmʋ nan na lagɩ n wǝli yinigǝ tu, sɩ n yɩ pa nɔɔn-nɔɔnʋ lwarɩ kʋ ni nɩ, nɩnɛɛnɩ nɔɔnʋ na kwe woŋo o pa dɩ o jazɩm yɩ o jagwiǝ yǝri kʋ ni nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","N Ko Wɛ nan naɩ kʋlʋ n na sǝgi n kɩ tɩn. DƖ laan wʋ́ pa n na nyɔɔrɩ kʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Abam na yǝni á lagɩ á warɩ Wɛ, sɩ á yɩ zaŋɩ á taá brɩ á tɩtɩ nɩ pipiri-nyɩna bam na kɩ te tɩn. Bantʋ soe sɩ ba taa zaŋɩ wɛɛnɩ mʋ ba warɩ Wɛ ba Wɛ-di sɩm wʋnɩ dɩ pooni yigǝ nɩ, sɩ nɔɔna maama taa na-ba. A lagɩ a ta cɩga mʋ dɩ abam sɩ, bantʋ maŋɩ ba na ba ŋwɩɩrʋ ba ti. ");
INSERT INTO xsm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nmʋ nan na lagɩ n warɩ Wɛ, zʋ digǝ wʋ n ja ka ni n pɩ, sɩ n laan warɩ n Ko Wɛ dɩlʋ na wʋ jǝgǝ kalʋ na sǝgi tɩn nɩ. Dɩntʋ nan naɩ kʋlʋ n na sǝgi n kɩ tɩn. DƖ laan wʋ́ pa n na nyɔɔrɩ kʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Abam na wʋra á warɩ Wɛ, á yɩ taá tiini á ŋɔɔnɩ bɩtar-yɔɔrʋ nɩnɛɛnɩ balʋ na yǝri Wɛ tɩn na yǝni ba ŋɔɔnɩ te tɩn. Bantʋ yǝni ba bʋŋɩ nɩ, ba na tiini ba ŋɔɔnɩ ta-farɩ mʋ, Wɛ wʋ́ lǝri ba loro. ");
INSERT INTO xsm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Abam nan yɩ zaŋɩ á kɩ nɩ bantʋ na kɩ te tɩn. Bɛŋwaanɩ á Ko Wɛ maŋɩ DƖ ye kʋlʋ abam na lagɩ tɩn, yɩ á ta wʋ loori-DƖ kʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Abam nan maŋɩ sɩ á taá warɩ Wɛ tɩntʋ doŋ mʋ: ‹Dɩbam Ko wʋlʋ na wʋ wɛɛnɩ tɩn, sɩ nmʋ yɩrɩ na tiǝ dɩ zulǝ, ");
INSERT INTO xsm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","sɩ nmʋ paarɩ ba, sɩ nmʋ wʋbʋŋa kɩ lʋgʋ baŋa nɩ, nɩ kʋ na kɩ n sɔŋɔ nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pa dɩbam wʋdiu zɩm sɩ kʋ maŋɩ dɩbam. ");
INSERT INTO xsm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yagɩ dɩ́ lwarɩm n ma n cɛ dɩbam, nɩ dɩbam dɩ na yagɩ dɩ́ ma cɛ dɩ́ donnǝ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yɩ pa dɩ́ na maŋɩm dɩlʋ na wʋ́ pa dɩ́ tʋ tɩn. Nan vrɩ dɩbam wo-lwaanʋ tu jɩŋa nɩ. (Nmʋ te paarɩ dɩ dam dɩ tiǝ sɩ kʋ taa ve maŋa kalʋ na ba ti tɩn. Amina.)› ");
INSERT INTO xsm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Abam na yagɩ á ma cɛ nɔɔna balʋ na kɩ abam lwarɩm tɩn, á Ko Wɛ dɩ wʋ́ yagɩ abam lwarɩm DƖ ma cɛ abam. ");
INSERT INTO xsm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kʋ daarɩ, abam na wʋ yagɩ á ma cɛ balʋ na kɩ abam lwarɩm tɩn, á Ko Wɛ dɩ bá yagɩ abam lwarɩm DƖ ma cɛ abam. ");
INSERT INTO xsm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Abam nan na vɔgɩ ni, sɩ á yɩ nywanɩ á yigǝ, nɩ pipiri-nyɩna bam na yǝni ba kɩ te tɩn. Bantʋ yǝni ba pa ba yibiyǝ lǝni sɩ kʋ pa nɔɔna lwarɩ nɩ ba vɔgɩ ni mʋ. A lagɩ a ta cɩga mʋ dɩ abam sɩ, bantʋ maŋɩ ba na ba ŋwɩɩrʋ. ");
INSERT INTO xsm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nmʋ nan na vɔgɩ ni, sɩ n su n yiǝ sɩ n daarɩ n lɩ n yuu lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kʋntʋ mʋ wʋ́ pa nɔɔn-nɔɔnʋ bá lwarɩ nɩ n vɔgɩ ni. N Ko Wɛ dɩlʋ na wʋ jǝgǝ kalʋ na sǝgi nɩ tɩn yɩranɩ mʋ ye. Dɩntʋ nan naɩ kʋlʋ n na sǝgi n kɩ tɩn. DƖ laan wʋ́ pa n na nyɔɔrɩ kʋ ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Nan yɩ zaŋɩ á kwaanɩ sɩ á na jɩjɩgɩrʋ zanzan lʋgʋ kʋntʋ baŋa nɩ. Á na tiŋi jɩjɩgɩrʋ lʋgʋ baŋa yo, tɩ wʋ́ ba tɩ cɔgɩ. Tʋa wʋ́ mu-tɩ, yɩ tɩ wʋ́ sʋŋɩ tɩ cɔgɩ. Ŋwɩɩna dɩ ma wʋ́ bwǝri sɔŋɔ kʋm ba zʋ ba ŋɔ-tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Abam nan maŋɩ sɩ á tiŋi á jɩjɩgɩrʋ zanzan Wɛ-sɔŋɔ nɩ mʋ. Dáanɩ mʋ tʋa daa bá wanɩ ka mu-tɩ, yɩ tɩ bá sʋŋɩ tɩ cɔgɩ, yɩ ŋwɩɩna dɩ bá wanɩ ba ŋɔ-tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bɛŋwaanɩ, abam jɩjɩgɩrʋ na tigi mɛ tɩn, á bɩcara dɩ tigi dáanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nɔɔnʋ yiǝ mʋ nyɩ nɩnɛɛnɩ kanɩa kalʋ na paɩ o yɩra jɩgɩ pooni te tɩn. Kʋntʋ tɩn, nmʋ yiǝ na lana, kʋ paɩ n yɩra maama wʋ pooni wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nmʋ yiǝ nan na ba lana, kʋ paɩ n yɩra maama wʋ lim wʋnɩ mʋ. Kʋntʋ tɩn, nmʋ yiǝ ya na maŋɩ sɩ ya taa yɩ pooni tɩn nan na yɩ lim, kʋ laan wʋ́ ta tiini kʋ yɩ lim kʋ ja gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nɔɔn-nɔɔnʋ bá wanɩ o lɩ wʋbʋŋ-dɩdwɩ, sɩ o ma tʋŋɩ o pa o yuutiinǝ bale. Oó ta culi dɩdʋ wʋm yɩ o daarɩ o soe wʋdoŋ wʋm, naa oó ta nɩgɩ dɩdʋ wʋm yɩ o daarɩ o gooni wʋdoŋ wʋm. Kʋntʋ ŋwaanɩ abam bá wanɩ á pa sɩ Wɛ taa yɩ á yuutu, sɩ á daarɩ á pa sǝbu dɩ taa yɩ á yuutu. ");
INSERT INTO xsm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kʋntʋ ŋwaanɩ mʋ a lagɩ a ta abam, sɩ á yɩ taá liǝ dɩ lʋgʋ baŋa kʋlʋkʋlʋ, kʋ na yɩ á ni-wʋdiu, naa á na wʋ́ zʋ gwaarʋ tɩlʋ tɩn. Bɛŋwaanɩ á ŋwɩa garɩ wʋdiu. Yɩra yalʋ Wɛ na pɛ abam tɩn dɩ maa garɩ gwaarʋ. ");
INSERT INTO xsm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nan maanɩ-na á nii zunǝ na yɩ te tɩn. Bantʋ ba duǝ, yɩ ba ba zagɩ mɩna ba kɩ tuli nɩ. Kʋ nan yɩ á Ko Wɛ mʋ nii ba baŋa nɩ dɩ ba ni-wʋdiu. Abam nan ba jɩgɩ kuri á dwe zunǝ bam na? ");
INSERT INTO xsm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Abam wʋlʋwʋlʋ bá wanɩ o toŋi o ŋwɩa dɩ fɩnfɩɩn dɩ, o na maŋɩ o li te dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Bɛɛ nan mʋ yɩ á kɩ liǝ dɩ gwaarʋ woŋo? Maanɩ-na á nii ga-punnu tɩm lam na yɩ te tɩn. Tɩntʋ nan warɩ tɩ tʋŋɩ yɩ tɩ warɩ gwaarʋ tɩ sɔ. ");
INSERT INTO xsm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nan taá ye-na nɩ, tɩntʋ jɩgɩ lam tɩ dwe Pɛ Salɔmɔn dɛɛn na maŋɩ o zʋʋrɩ gwar-ŋʋnnʋ tɩlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kʋ nan na yɩ gaarʋ tɩm kʋntʋ, tɩntʋ ba jɩgɩ dɛ dɩ nɔɔna na zwɛ-tɩ. Dɩ kʋntʋ dɩ Wɛ ta mʋ paɩ tɩ jɩgɩ lam kʋntʋ doŋ. Kʋntʋ ŋwaanɩ, kʋ na yɩ abam, Wɛ bá nii abam baŋa nɩ cɩga? Bɛɛ nan yɩ á ba kɩ á wʋ-dɩdʋa dɩ Wɛ? ");
INSERT INTO xsm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kʋntʋ ŋwaanɩ, á yɩ taá liǝ dɩ á na wʋ́ di woŋo kʋlʋ naa á na wʋ́ zʋ woŋo kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Balʋ na yǝri Wɛ tɩn mʋ tiini ba bʋŋɩ wǝǝnu tɩm kʋntʋ maama wʋbʋŋa. Abam Ko Wɛ nan maŋɩ DƖ ye woŋo kʋlʋ na maŋɩ dɩ abam tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Abam maŋɩ sɩ á da yigǝ á beeri Baŋa-Wɛ paarɩ dɩm dɩ ŋwɩa kalʋ na tɔgɩ Wɛ wʋbʋŋa tɩn. Á na kɩ kʋntʋ, Wɛ laan wʋ́ wǝli abam wǝǝnu tɩlʋ na daarɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dɛ maama tui dɩ dɩ tɩtɩ cam mʋ. Á nan yɩ taá pa liǝ jɩgɩ abam dɩ jwa woŋo. Yagɩ-na sɩ jwa dɛ dɩm tɩtɩ wʋ́ nii dɩ tɩtɩ woŋo.» ");
INSERT INTO xsm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Abam yɩ taá ŋɔɔnɩ á donnǝ wǝǝnu, sɩ Wɛ yɩ ŋɔɔnɩ abam dɩ wǝǝnu. ");
INSERT INTO xsm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bɛŋwaanɩ, abam na ŋɔɔnɩ á donnǝ wǝǝnu te tɩn, Wɛ wʋ́ tɔgɩ kʋntʋ doŋ mʋ DƖ ma di á sarɩya. Abam na maɩ bwaŋa kalʋ á maŋɩ á pa á donnǝ tɩn, Wɛ dɩ wʋ́ maɩ bwaŋa kantʋ mʋ DƖ maŋɩ DƖ pa abam sɩ kʋ taa maɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Abam nyɩ dɩ nɔɔnʋ na nii o doŋ yi nɩ o na ga-balaŋa da, yɩ o daarɩ o ba lagɩ sɩ o lwarɩ nɩ o tɩtɩ yi jɩgɩ daa tɩn. Kʋ maŋɩ sɩ kʋ taa yɩ kʋntʋ doŋ na? ");
INSERT INTO xsm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Daa na wʋ nmʋ yi nɩ tɩn, nń kɩ ta mʋ n ta dɩ n doŋ nɩ o pa n lɩ gaa o yi nɩ n yagɩ? ");
INSERT INTO xsm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nmʋ yɩ pipiri-nyɩm dɩ nmʋ na kɩ n doŋ te tɩn. Nmʋ nan maŋɩ sɩ n lɩ n tɩtɩ yi daa kam mʋ, sɩ n laan wanɩ n nii lanyɩranɩ sɩ n lɩ n doŋ yi gaa kam. ");
INSERT INTO xsm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yɩ zaŋɩ á kwe wǝǝnu tɩlʋ na yɩ wo-kamunǝ Wɛ yigǝ nɩ á pa balʋ na vɩn Wɛ tɩn. Á na kɩ kʋntʋ, baá cɔgɩ-tɩ, yɩ ba daarɩ ba cɔgɩ abam tɩtɩ dɩ ba wǝli da.» ");
INSERT INTO xsm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Á taá loori Wɛ, sɩ DƖ wʋ́ pa abam kʋlʋ á na lagɩ tɩn. Beeri-na kʋlʋ á na lagɩ tɩn, sɩ á wʋ́ na. Magɩ-na boro, sɩ baá pʋrɩ ba pa abam. ");
INSERT INTO xsm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bɛŋwaanɩ wʋlʋ maama na loori Wɛ sɩ DƖ pa-o woŋo tɩn wʋ́ joŋi. Wʋlʋ maama na beeri woŋo tɩn wʋ́ na-kʋ. Baá pʋrɩ ba pa wʋlʋ maama na magɩ boro tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Abam wʋlʋ na jɩgɩ bu yɩ o na loori-m wʋdiu, nmʋ wʋ́ sɛ n kwe kandwɛ n pa-o na? ");
INSERT INTO xsm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa o na loori-m kalǝŋǝ, nń sɛ n pa-o bɩsankwɩa na? ");
INSERT INTO xsm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Awo. Abam wʋrʋ na ba lana yɩ á ta ye sɩ á taá paɩ á biǝ wo-laarʋ tɩlʋ ba na lagɩ tɩn, á Ko Wɛ na lamma DƖ dwe abam tɩn bá kwe wo-laarʋ DƖ pa balʋ na loori-DƖ tɩn na? ");
INSERT INTO xsm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Á taá kɩ á donnǝ lanyɩranɩ, sɩ kʋ maŋɩ dɩ á na lagɩ sɩ bantʋ taa kɩ abam te tɩn. Kʋntʋ mʋ yɩ cɩga kalʋ Moyisi dɩ Wɛ nijoŋnǝ bam zaasɩm dɩm na maŋɩ dɩ brɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Á taá cʋ á tɩtɩ, sɩ á wanɩ á tɔgɩ cwǝ-mɩmɩna kam á vu á na ŋwɩa Wɛ tee nɩ. Kʋ daarɩ cwǝŋǝ kalʋ ni na yalma yɩ ka vǝŋǝ yɩ mwalɩ mwalɩ tɩn maa ve ka kweeli cɔgɩm jǝgǝ nɩ mʋ, yɩ nɔɔna zanzan mʋ tɔgɩ cwǝŋǝ kantʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kʋ daarɩ cwǝŋǝ kalʋ nmʋ na wʋ́ da sɩ n vu n joŋi ŋwɩa Wɛ tee nɩ tɩn ni yɩ mɩmɩna mʋ, yɩ ka pɩɩnɩ. Nɔɔna fɩnfɩɩn yɩranɩ mʋ tɔgɩ cwǝŋǝ kam kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Á taá yɩrɩ á tɩtɩ dɩ balʋ na paɩ ba yɩ Wɛ nijoŋnǝ yɩ ba daɩ tɩn. Bantʋ yǝni ba kɩ ba yibiyǝ nɩ ba yɩ nɔn-ŋʋna mʋ te abam yigǝ nɩ, yɩ ba nan lagɩ ba cɔgɩ abam nɩ nywǝnkuri na lagɩ sɩ cɔgɩ peeni te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ba tɩtʋŋa nan mʋ wʋ́ pa á lwarɩ ba na yɩ balʋ tɩn. Bɛŋwaanɩ tiu tǝrǝ kʋ na wʋ́ wanɩ kʋ lǝ kʋ doŋ biǝ. N bá na swan sabara yuu nɩ naa mɔɔla kaligoŋo yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tu-ŋʋŋʋ mʋ lǝri bu-ŋʋna. Tu-balɔrɔ dɩ maa lǝri bu-balwaarʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tu-ŋʋŋʋ tǝrǝ kʋ na wʋ́ lǝ bu-balwaarʋ. Tu-balɔrɔ dɩ nan tǝrǝ kʋ na wʋ́ lǝ bu-ŋʋna. ");
INSERT INTO xsm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tiu kʋlʋ maama na ba lǝri bu-ŋʋna tɩn, baá go-kʋ ba dɩ mini nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kʋntʋ tɩn, ba tɩtʋŋa mʋ wʋ́ pa á lwarɩ ba na yɩ balʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kʋ daɩ nɩ balʋ maama na bǝ amʋ nɩ ‹Yuutu, Yuutu› tɩn mʋ wʋ́ tɔgɩ ba zʋ Wɛ paarɩ dɩm wʋnɩ. Kʋ nan yɩ balʋ na sɩɩnɩ ba tɔgɩ amʋ Ko Wɛ wʋbʋŋa tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Sarɩya dɛ dɩm na yiǝ, nɔɔna zanzan wʋ́ ta dɩ amʋ ba wɩ: ‹Dɩ́ Yuutu, dɩbam dɛɛn tɔgɩ nmʋ yɩrɩ dɩm ŋwaanɩ mʋ dɩ́ ŋɔɔnɩ Wɛ yiyiu-ŋwɛ, yɩ dɩ́ ma nmʋ yɩrɩ dɩm dɩ́ zǝli ciciri nɔɔna yɩra nɩ, yɩ dɩ́ daarɩ dɩ́ ma dɩ́ kɩ wo-kɩnkagɩla zanzan.› ");
INSERT INTO xsm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A laan wʋ́ ta dɩ ba a wɩ: ‹A maŋɩ a yǝri abam. Ve-na daa nɩ, abam kǝm-balwaarʋ tiinǝ-ba.› » ");
INSERT INTO xsm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Kʋntʋ ŋwaanɩ, wʋlʋ maama na cǝgi a taanɩ dɩm yɩ o kɩ a na tagɩ kʋlʋ tɩn, kʋntʋ tu nyɩ dɩ wʋbʋŋa tu wʋlʋ na cwi o sɔŋɔ kuri pulɔrɔ baŋa nɩ yɩ o laan lɔ-kʋ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dʋa ma ba ka nɩ ka pa bwi su sɩ pɛɛlɩ. Vu-dɩʋ dɩ ma ba kʋ magɩ sɔŋɔ kʋm, yɩ kʋ wʋ tʋ, kʋ kuri na cwi pulɔrɔ kʋm baŋa nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kʋ daarɩ wʋlʋ maama nan na cǝgi a taanɩ dɩm yɩ o ba kɩ a na tagɩ kʋlʋ tɩn nyɩ dɩ nɔn-joro na lɔgɩ kʋ sɔŋɔ kasʋlʋ baŋa nɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dʋa ma ba ka nɩ ka pa bwi su sɩ pɛɛlɩ, yɩ vu-dɩʋ dɩ magɩ sɔŋɔ kʋm, kʋ pa kʋ tiini kʋ tʋ tɩga nɩ buri buri.» ");
INSERT INTO xsm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zezi dɛɛn na tagɩ wǝǝnu tɩntʋ maama o ti tɩn, nɔn-kɔgɔ kʋlʋ na wʋra tɩn ma tiini ba yɩ yǝǝu dɩ o zaasɩm dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bɛŋwaanɩ o ni-taanɩ dɩm jɩgɩ dam dɩ dwe ba tɩtɩ cullu karanyɩna tiinǝ bam taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zezi laan ma zaŋɩ o tu piu kʋm yuu nɩ o maa kɛa, yɩ kɔ-fɔrɔ tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","O na maa kɛ tɩn, nanyɔŋɔ kʋdoŋ ma vu o te, yɩ kʋ kuni doonǝ o yigǝ nɩ kʋ loor-o kʋ wɩ: «Amʋ tu, nmʋ na laga, nń wanɩ n pa a na yazurǝ a ji lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Zezi ma sɛ. O ma twɩ o jɩŋa o dwe-o, yɩ o wɩ: «Ɛɛn, a laga. Zaŋɩ dɩ yazurǝ sɩ n ji lanyɩranɩ.» O na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ nɔɔnʋ wʋm nanywaanʋ tɩm dɛ tɩ je yɩ o yɩra ji lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Zezi laan ma ta dɩd-o o wɩ: «Yɩ zaŋɩ n ta kʋlʋ na kɩ tɩn n brɩ nɔɔna. Nan yɔɔrɩ n vu Wɛ kaanɩm tu wʋm te sɩ n pa o nii n yɩra yam, sɩ n daarɩ n ja pɛɛra yalʋ Moyisi cullu tɩm na brɩ nɩ ya maŋɩ tɩn n vu n pa-o, sɩ o ma kaanɩ Baŋa-Wɛ. Kʋntʋ mʋ wʋ́ brɩ nɔɔna maama nɩ n yawɩʋ kʋm sɩɩnɩ kʋ je.» ");
INSERT INTO xsm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zezi laan ma vu o yi tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Kapɛrnawum. Pamaŋna yigǝ tu wʋdoŋ ma ba o te, ");
INSERT INTO xsm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","yɩ o loor-o o wɩ: «Amʋ tu, a jɩgɩ a tɩntʋŋnʋ mʋ o tigi sɔŋɔ nɩ yɩ o wɔɛ, kʋ tiini kʋ cana o yɩra nɩ. O ma gwarɩgɩ yɩ o warɩ o zaŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zezi ma lǝr-o o wɩ: «Aá da a vu sɩ a pa o na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pamaŋna yigǝ tu wʋm ma lǝri o wɩ: «Amʋ tu, a wʋ maŋɩ sɩ n ba n zʋ amʋ sɔŋɔ. Nan weeni n ta dɩ n ni nɩ a tɩntʋŋnʋ wʋm zaŋɩ. N na tagɩ kʋntʋ, oó na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bɛŋwaanɩ, amʋ dɩ yɩ nɔɔnʋ wʋlʋ nɔɔna badonnǝ na jɩgɩ dam amʋ baŋa nɩ tɩn, yɩ a dɩ daa ta jɩgɩ dam pamaŋna badaara baŋa nɩ. A na tagɩ a wɩ, nɔɔnʋ wʋlʋ ve, o maŋɩ sɩ o vu mʋ. A nan daa na wɩ, nɔɔnʋ wʋlʋ ba, o dɩ wʋ́ ba mʋ. Kʋ daa zɩ yɩ a tɩntʋŋnʋ, a na wɩ o kɩ woŋo, oó kɩ mʋ. Kʋntʋ, a ye sɩ, nmʋ na tagɩ kʋlʋ maama kʋʋ́ kɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zezi na ni kʋntʋ tɩn, kʋ ma tiini kʋ sʋ-o. O ma ta dɩ balʋ na tɔgɩ ba wʋra tɩn o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, a wʋ nɛ nɔɔn-nɔɔnʋ o na jɩgɩ wʋ-dɩdʋa dɩ amʋ nɩnɛɛnɩ nɔɔnʋ wʋntʋ na jɩgɩ wʋ-dɩdʋa te tɩn, kʋ na maŋɩ kʋ yɩ Yisɩrayɛlɩ dwi tiinǝ bam wʋnɩ dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A lagɩ a ta abam sɩ, nɔɔna zanzan wʋ́ nuŋi lʋgʋ baŋa je maama nɩ, ba ba ba zʋ Wɛ paarɩ dɩm wʋ. Dáanɩ mʋ ba laan wʋ́ jǝni dɩ dɩbam nabaara Abraham dɩ Yizakɩ dɩ Zakɔbɩ, yɩ ba di ywǝǝni daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kʋ daarɩ, Yisɩrayɛlɩ dwi tiinǝ balʋ ya na maŋɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ tɩn, bantʋ daa bá na cwǝŋǝ sɩ ba zʋ. Wɛ wʋ́ zǝli-ba DƖ yagɩ lim je nɩ, mɛ nɔɔna na yaara yɩ ba keerǝ yɩ ba dʋnɩ ba nwa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zezi laan ma ta dɩ pamaŋna yigǝ tu wʋm o wɩ: «Nan ve. Nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ sɩ a kɩ kʋlʋ tɩn, Wɛ wʋ́ pa kʋ kɩ.» Maŋa kam kʋntʋ nɩ nɔ́ɔ mʋ o tɩntʋŋnʋ wʋm sɩɩnɩ o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Zezi laan ma vu Pɩyɛɛrɩ-ba sɔŋɔ. O ma na Pɩyɛɛrɩ tɩnkaanɩ na tigǝ o ba jɩgɩ yazurǝ. Kʋ yɩ paa mʋ jɩg-o. ");
INSERT INTO xsm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zezi ma vu o ja o jɩŋa, yɩ paa kam nuŋi o yɩra nɩ. Kaanɩ wʋm laan ma zaŋɩ o kɩ wʋdiu o pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tɩga na tu ka wʋra ka yi tɩn, nɔɔna maa jaanɩ ciciri na jɩgɩ balʋ tɩn zanzan ba tui Zezi te. O maa yǝni o ma o ni-taanɩ o zǝli ciciri sɩm, yɩ o daarɩ o pa yawɩɩna bam maama na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O kɩ kʋntʋ, sɩ kʋ pa Wɛ nijoŋnu Ezayi na maŋɩ o ta kʋlʋ faŋa faŋa tɩn mʋ sɩɩnɩ kʋ kɩ, nɩ o dɛɛn na tagɩ o wɩ: «Wʋntʋ mʋ joŋi dɩbam cam dɩ dɩ́ yawɩɩrʋ maama o zɩŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zezi dɛɛn na nɛ nɩ kɔ-fɔrɔ tiini kʋ wʋ o tee nɩ tɩn, o ma pa o karabiǝ bam ni sɩ ba bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ba daa ta na wʋ kɛ tɩn, Wɛ cullu karanyɩna tu wʋdoŋ ma vu o te, yɩ o ta dɩd-o o wɩ: «Karanyɩna, nmʋ na lagɩ n vu je sɩlʋ maama tɩn, amʋ wʋ́ tɔgɩ a vu.» ");
INSERT INTO xsm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Zezi ma lǝr-o o wɩ: «Kʋ na yɩ yirǝ, bantʋ jɩgɩ bɔɔna ba tigi da. Zunǝ dɩ jɩgɩ pwǝru ba tigi da. Kʋ daarɩ amʋ Nabiin-bu wʋm ba jɩgɩ jǝgǝ sɩ a pǝni da a sin.» ");
INSERT INTO xsm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nɔɔnʋ wʋdoŋ dɩ na yɩ o karabiǝ bam wʋ nɔɔnʋ dɩdʋa tɩn ma ta dɩd-o o wɩ: «Amʋ tu, yagɩ sɩ a vu a kɩ a ko luǝ, sɩ a laan ba a tɔgɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zezi ma lǝr-o o wɩ: «Ta n tɔgɩ-nɩ, sɩ n yagɩ sɩ balʋ na ba jɩgɩ ŋwɩa Wɛ tee nɩ tɩn taa kɩ ba lwi.» ");
INSERT INTO xsm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Zezi dɩ o karabiǝ bam laan ma vu ba zʋ naboro wʋ sɩ ba kɛ. ");
INSERT INTO xsm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vu-fɔrɔ ma da kʋ zaŋɩ kʋ magɩ boro kʋm, yɩ kʋ wʋra kʋ miisi na bam kuri nɩ, dɩ Zezi ya tigi o dɔa. ");
INSERT INTO xsm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","O karabiǝ bam ma vu ba zaŋ-o ba wɩ: «Dɩ́ Yuutu, vrɩ dɩbam n yagɩ, sɩ dɩ́ lagɩ dɩ́ tɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O ma ta dɩ ba o wɩ: «Bɛŋwaanɩ mʋ yɩ fʋʋnɩ jɩgɩ abam? Abam ba jɩgɩ wʋ-dɩdʋa dɩ amʋ na?» O laan ma zaŋɩ wɛɛnɩ, yɩ o bagɩ viu kʋm dɩ na bam, yɩ tɩ maŋɩ da cɩmm. ");
INSERT INTO xsm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kʋ ma tiini kʋ kɩ nɔɔna bam yǝǝu, yɩ ba tɛ ba wɩ: «Nɔɔnʋ wʋntʋ yɩ wɔɔ mʋ, yɩ viu dɩ na dɩ ta sɛ o ni?» ");
INSERT INTO xsm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ba laan ma vu ba bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm, mɛ Gadara tiinǝ na zʋʋrɩ da tɩn. Nɔɔna bale maa wʋra ciciri na jɩgɩ-ba sɩ yaara. Bantʋ tigi yibeelǝ je nɩ mʋ, yɩ ba jɩgɩ fʋʋnɩ, kʋ paɩ nɔɔn-nɔɔnʋ warɩ o tɔgɩ cwǝŋǝ kam kʋntʋ o kɛ. Ba laan ma nuŋi yibeelǝ je sɩm nɩ ba vu ba jeeri Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ba ma kaasɩ baŋa baŋa ba wɩ: «Baŋa-Wɛ Bu, nmʋ tu dɩbam te sɩ n kɩ bɛɛ mʋ? Nmʋ tu sɩ n yaarɩ dɩbam yɩ Wɛ sarɩya dɛ dɩm ta wʋ yi mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Je sɩm kʋntʋ nɩ tǝrǝ zanzan mʋ ya wʋra ba beeri ba di. ");
INSERT INTO xsm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ciciri sɩm ma loori Zezi sɩ wɩ: «Nmʋ na lagɩ n zǝli dɩbam, sɩ n pa dɩ́ vu dɩ́ zʋ tǝrǝ bantʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O ma ta o wɩ, sɩ ve. Sɩ ma sɩɩnɩ sɩ nuŋi nɔɔna bam yɩra nɩ sɩ vu sɩ zʋ tǝrǝ bam. Tǝrǝ bam maama ma duri ba tu ba tʋ nɩnɩʋ kʋm wʋnɩ ba li na ba tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nɔɔna balʋ ya na nii tǝrǝ bam tɩn ma duri ba vu tɩʋ kʋm wʋ. Ba ma ta kʋlʋ maama na kɩ tɩn, dɩ Zezi na zǝli ciciri sɩm nɔɔna bale bam yɩra nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kʋ ma pa tɩʋ kʋm nɔɔna bam maama nuŋi ba vu sɩ ba jeeri Zezi. Ba na nɛ-o tɩn, ba ma loor-o sɩ o nuŋi ba tɩʋ kʋm wʋnɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zezi laan ma joori o vu o zʋ naboro kʋm. O ma bɛ nɩnɩʋ kʋm o vu o yi o tɩtɩ tɩʋ Kapɛrnawum. ");
INSERT INTO xsm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","O na wʋra tɩn, nɔɔna badonnǝ ma zɩŋɩ kɔrɔ dɩ gungolo ba ba o te. Zezi ma lwarɩ ba na tiini ba kɩ ba wʋ-dɩdʋa dɩd-o te tɩn. O ma ta dɩ kɔrɔ kʋm o wɩ: «A bu, kɩ pu-dɩa, sɩ nmʋ lwarɩm dɩm ti.» ");
INSERT INTO xsm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wɛ cullu karanyɩna tiinǝ badonnǝ maa wʋra, yɩ ba bwɛ ba tɩtɩ nɩ ba wɩ: «Nɔɔnʋ wʋntʋ ŋɔɔnɩ o twɩ Wɛ mʋ o paɩ o dɩ Wɛ yɩ bɩdwɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zezi ma lwarɩ ba na bʋŋɩ kʋlʋ tɩn. O ma bwe-ba o wɩ: «Bɛɛ mʋ yɩ á jɩgɩ wʋbʋŋ-balwaarʋ tɩntʋ á wʋnɩ? ");
INSERT INTO xsm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kɔɔ mʋ yɩ mwalɩ kʋ dwe, a na tagɩ dɩ kɔrɔ kʋm a wɩ: ‹Nmʋ lwarɩm dɩm ti› mʋ yɩ mwalɩ, naa a na tagɩ a wɩ: ‹Zaŋɩ n ta n veǝ› mʋ yɩ mwalɩ? ");
INSERT INTO xsm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amʋ nan wʋ́ pa abam lwarɩ nɩ, amʋ na yɩ Nabiin-bu wʋm tɩn jɩgɩ dam lʋgʋ baŋa nɩ, sɩ a yagɩ nɔɔna lwarɩm a ma cɛ-ba.» O laan ma ta dɩ kɔrɔ kʋm o wɩ: «Zaŋɩ wɛɛnɩ sɩ n kwe n gungolo kʋm n ja n vu sɔŋɔ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","O na tagɩ kʋntʋ tɩn, nɔɔnʋ wʋm ma sɩɩnɩ o zaŋɩ o vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nɔn-kɔgɔ kʋm maama na nɛ kʋntʋ tɩn, fʋʋnɩ ma zʋ-ba. Ba ma zuli Wɛ dɩ DƖ na pɛ dam dɩntʋ doŋ wʋ nabiinǝ tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zezi laan ma nuŋi o maa kɛa. O ma na nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Matiyu. O dɛɛn je mɛ seeni o na yǝni o joŋi lampoo tɩn mʋ. Zezi ma ta dɩd-o o wɩ: «Zaŋɩ n ta n tɔgɩ-nɩ.» O ma sɩɩnɩ o zaŋɩ o tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Zezi dɛɛn ma vu Matiyu sɔŋɔ sɩ o di wʋdiu, o dɩ o karabiǝ bam. Lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ zanzan dɩ maa tɔgɩ ba wʋra ba di wʋdiu kʋm dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farizɩan tiinǝ dɩ maa tɔgɩ ba wʋra. Bantʋ na nɛ Zezi na kɩ te tɩn, ba ma vu ba ta dɩ o karabiǝ bam ba wɩ: «Bɛɛ mʋ kɩ yɩ á karanyɩna kam di wʋdiu dɩdaanɩ lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ tɩm kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zezi ma ni ba na tagɩ kʋlʋ tɩn. O laan ma ta o wɩ: «Kʋ na yɩ balʋ na jɩgɩ yazurǝ tɩn, bantʋ wʋ maŋɩ sɩ ba vu dɔgɩta tu te sɩ o sooni-ba. Kʋ daarɩ balʋ na ba jɩgɩ yazurǝ tɩn mʋ maŋɩ sɩ ba vu sɩ ba na soonim. ");
INSERT INTO xsm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wɛ tɩtɩ maŋɩ DƖ ta DƖ wɩ: ‹A lagɩ sɩ nabiinǝ taa jɩgɩ da-ŋwaŋa mʋ, sɩ kʋ daɩ nɩ ba taa maɩ ba wǝǝnu mʋ ba kaanɩ-nɩ.› Ve-na á zaasɩ taanɩ dɩm kʋntʋ kuri cɩga. Amʋ na tu lʋgʋ baŋa tɩn, kʋ daɩ sɩ a bǝŋi balʋ na maŋɩ ba yɩ nɔn-ŋʋna tɩn, amʋ nan tu sɩ a bǝŋi nɔn-balwaarʋ mʋ sɩ ba ba amʋ te.» ");
INSERT INTO xsm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zan karabiǝ dɛɛn ma vu Zezi te, yɩ ba bwe-o ba wɩ: «Dɩbam dɩ Farizɩan tiinǝ bam yǝni dɩ́ vɔ ni maŋa zanzan. Bɛɛ mʋ yɩ nmʋ karabiǝ bam ba vɔ ni kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Zezi ma lǝri-ba o wɩ: «Nɔɔnʋ na di kaanɩ yɩ o kɩ candiǝ, yɩ o cilonnǝ na wʋra sɩ ba tɔgɩ ba di, bantʋ wʋ́ wanɩ ba nywanɩ ba yigǝ sɩ ba yɩ di wʋdiu yɩ kan-barʋ wʋm ta wʋ ba tee nɩ na? Ba bá sɛ ba kɩ kʋntʋ. Kʋ nan wʋ́ ba kʋ yi maŋa kam ba laan na wʋ́ ja kan-barʋ wʋm ba viiri tɩn. Maŋa kam kʋntʋ nɩ yɩ o daa na ba ta wʋ ba tee nɩ tɩn, mʋ o cilonnǝ bam laan wʋ́ vɔ ni. ");
INSERT INTO xsm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nɔɔn-nɔɔnʋ dɩ nan bá sɛ o kwe garyi-dʋʋrɩ o ma fǝri gwar-doŋo kʋlʋ na kaarɩ tɩn. O na kɩ kʋntʋ, kʋ fǝrim dɩm laan wʋ́ vuuri gɔrɔ kʋm kʋ pa kʋ tiini kʋ cɔgɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nɔɔn-nɔɔnʋ dɩ nan bá sɛ o kwe sa-dʋŋa o lo o kɩ lɔ-doŋo wʋnɩ. O na kɩ kʋntʋ yɩ sana kam na keeri, kaá pa lɔɔ kʋm bagɩ mʋ. Kʋntʋ ŋwaanɩ sana kam wʋ́ lo, yɩ lɔɔ kʋm dɩ cɔgɩ. Nɔɔnʋ nan maŋɩ sɩ o kwe sa-dʋŋa o kɩ lɔ-dʋŋʋ wʋnɩ mʋ, sɩ tɩ maama maŋɩ daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zezi dɛɛn na wʋra o ŋɔɔnɩ kʋntʋ tɩn, Zwifǝ yigǝ tu wʋdoŋ ma ba o te. O kuni doonǝ o yigǝ nɩ yɩ o wɩ: «Amʋ bukɔ mʋ tɩga lele kʋntʋ. Nan ba sɩ n ma n jɩŋa n dwe-o, sɩ o joori o na ŋwɩa.» ");
INSERT INTO xsm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zezi ma zaŋɩ o tɔg-o, dɩ o karabiǝ bam maama. ");
INSERT INTO xsm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ba na maa kɛ kʋntʋ tɩn, kaanɩ wʋdoŋ dɩ ya tɔgɩ o wʋra, o na tiini o wɔɛ ka-wʋ taan bɩna fugǝ-yale. O maa bʋŋɩ o wʋnɩ o wɩ: «A na maŋɩ a dwe o gɔrɔ kʋm yɩranɩ dɩ, aá na yazurǝ.» O ma kɛ Zezi kwaga o dwe o gɔrɔ kʋm ni. ");
INSERT INTO xsm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O na dwe-o kʋntʋ tɩn, o ma pipiri o nii-o yɩ o wɩ: «A bukɔ, kɩ pu-dɩa. Nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ te tɩn mʋ pɛ n na yazurǝ.» Maŋa kam kʋntʋ nɩ nɔ́ɔ mʋ kaanɩ wʋm sɩɩnɩ o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zezi laan ma vu o zʋ Zwifǝ yigǝ tu wʋm sɔŋɔ. O ma zʋ o na balʋ na maŋɩ ba wu wi yɩ ba kwe nɔɔna ba kɩ tɩn na ti ba yigǝ sɩ ba kɩ-o, dɩ nɔɔna zanzan na keeri yɩ ba frɩ ba tɩtɩ. ");
INSERT INTO xsm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","O ma ta dɩ ba o wɩ: «Zaŋɩ-na á nuŋi, sɩ bu wʋm wʋ tɩgɩ, o tigi o dɔ mʋ.» O na tagɩ kʋntʋ tɩn, nɔɔna bam maa jɩg-o ba mwana. ");
INSERT INTO xsm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba na pɛ kɔgɔ kʋm maama nuŋi tɩn, Zezi laan ma vu o zʋ digǝ kam bu wʋm na wʋra tɩn. O ma ja o jɩŋa o pa o bi o zaŋɩ wɛɛnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","O kǝm dɩm kʋntʋ ma jagɩ dɩ yi tɩʋ kʋm je sɩm maama. ");
INSERT INTO xsm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zezi dɛɛn ma zaŋɩ o maa kɛa. O na maa ve tɩn, lilwǝ bale ma zaŋɩ ba tɔgɩ o kwaga, yɩ ba tɛ dɩ kwǝr-dɩa ba wɩ: «Pɛ Davidi dwi tu! Duri dɩbam yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","O ma vu o zʋ sɔŋɔ kʋdoŋ. Lilwǝ bale bam ma tɔgɩ ba zʋ da. O laan ma bwe-ba o wɩ: «Abam bʋŋɩ sɩ aá wanɩ a kɩ á na lagɩ kʋlʋ tɩn a pa abam na?» Ba ma lǝr-o ba wɩ: «Dɩbam tu, ɛɛn, nń wanɩ n kɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","O laan ma dwe ba yiǝ yam yɩ o wɩ: «Abam na kɩ á wʋ-dɩdʋa dɩ amʋ sɩ a kɩ kʋlʋ a pa abam tɩn, Wɛ wʋ́ pa kʋ kɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","O na tagɩ kʋntʋ tɩn, ba yiǝ yam ma sɩɩnɩ ya joori ya puri. O ma kaanɩ-ba sɩ ba yɩ pa nɔɔn-nɔɔnʋ lwarɩ kʋ ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","O na kaanɩ-ba kʋntʋ tɩn, ba ta zaŋɩ ba karɩ ba ŋɔɔnɩ o taanɩ je sɩm maama nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Maŋa kalʋ ba na maa kɛ tɩn, nɔɔna badonnǝ ma ja mɩmaa ba ba Zezi te. Kʋ yɩ cicirǝ mʋ tɔg-o ka pa o warɩ o ŋɔɔnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Zezi ma zǝli cicirǝ kam o yɩra nɩ, yɩ nɔɔnʋ wʋm laan waɩ o ŋɔɔna. Kʋ ma sʋ nɔn-kɔgɔ kʋm maama, yɩ ba tɛ ba wɩ: «Dɩbam maŋɩ dɩ́ wʋ nɛ wo-kɩnkagɩlɩ dɩntʋ doŋ Yisɩrayɛlɩ tɩʋ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kʋ daarɩ Farizɩan tiinǝ bam dɛɛn wʋ sɛ, yɩ ba wɩ: «Wʋntʋ na waɩ o zǝli sʋtaana tɩn, kʋ yɩ sʋtaana-pɛ dam ŋwaanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zezi dɛɛn maa kaagɩ tɩ-kamunǝ dɩ tɩ-balɛ sɩm maama wʋnɩ. O maa yǝni o zʋʋrɩ Zwifǝ bam Wɛ-di sɩm o brɩ-ba Wɛ kwǝr-ywǝŋǝ kam, dɩ Wɛ na lagɩ DƖ di paarɩ nɔɔna tɩtarɩ nɩ te tɩn. O maa paɩ nɔɔna na yazurǝ dɩ ba yawɩɩrʋ dwi dwi. ");
INSERT INTO xsm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","O dɛɛn na nɛ nɔn-kɔgɔ kʋm yaara yam na yɩ te tɩn, ba ŋwaŋa ma zʋ-o lanyɩranɩ, bɛŋwaanɩ ba tiini ba bwǝni yɩ ba dam dɩ ti. Ba nyɩ dɩ peeni sɩlʋ na ba jɩgɩ nayɩrʋ sɩ o taa nii sɩ baŋa nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","O laan ma ta dɩ o karabiǝ bam o wɩ: «Kʋ nyɩ dɩ faa na kɩ lanyɩranɩ yɩ tɩntʋŋna fɩnfɩɩn yɩranɩ mʋ wʋra sɩ ba kɩ-kʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nan loori-na faa kʋm tu sɩ o tʋŋɩ nɔɔna zanzan, sɩ ba vu ba kɩ o faa kʋm ba pa-o.» ");
INSERT INTO xsm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zezi dɛɛn ma bǝŋi o karabiǝ fugǝ-bale bam sɩ ba ba o te. O ma pa-ba dam sɩ ba wanɩ ciciri ba zǝli nɔɔna yɩra nɩ, sɩ ba daarɩ ba pa nɔɔna na yazurǝ dɩ ba yawɩɩrʋ dwi maama. ");
INSERT INTO xsm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","O karabiǝ fugǝ-bale bam yɩra mʋ tɩntʋ: O ma da yigǝ o bǝŋi Simɔn wʋlʋ yɩrɩ dɩdoŋ na yɩ Pɩyɛɛrɩ tɩn, dɩ Andre wʋlʋ na yɩ Simɔn nyaanɩ tɩn, dɩ Zakɩ, dɩ o nyaanɩ Zan balʋ na yɩ Zebede biǝ tɩn, ");
INSERT INTO xsm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi dɩ Batelemi, Toma dɩ Matiyu wʋlʋ ya na yɩ lampo-joŋnu tɩn, Zakɩ wʋlʋ na yɩ Alɩfɩ bu tɩn, dɩ Tadɩ, ");
INSERT INTO xsm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔn wʋlʋ na yɩ Zelɔtɩ nɔɔna bam wʋ nɔɔnʋ tɩn, dɩ Zudasɩ Yiskarɩyo wʋlʋ na wʋ́ ba o yǝgi Zezi o pa nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Zezi laan ma tʋŋɩ bantʋ fugǝ-bale bam sɩ ba nuŋi ba vu ba tɔɔlɩ Wɛ kwǝrǝ kam. Ba na lagɩ ba kɛ tɩn, o ma pa-ba ni o wɩ: «Yɩ zaŋɩ á vu dwi-gɛ tiinǝ na zʋʋrɩ mɛ tɩn, naa á vu Samari tiinǝ tɩʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Á nan maŋɩ sɩ á vu Yisɩrayɛlɩ dwi tiinǝ bam te, bɛŋwaanɩ bantʋ nyɩ dɩ peeni sɩlʋ na je tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nan ve-na á brɩ-ba nɩ maŋa kam yiǝ, Wɛ paarɩ dɩm lagɩ dɩ ba nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ve-na á taá pa yawɩɩna na yazurǝ, sɩ á daarɩ á taá bi balʋ na tɩgɩ tɩn, sɩ á pa nanywaanʋ joori tɩ na yazurǝ tɩ ji lanyɩranɩ, sɩ á daarɩ á taá zǝli ciciri nɔɔna yɩra nɩ. Á nan maŋɩ sɩ á zǝni nɔɔna zaanɩ mʋ, nɩ abam dɩ na joŋi Wɛ dam dɩm zaanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Á na maa ve, sɩ á yɩ zaŋɩ á kwe sǝbu-sɩŋa naa sǝbu á kɩ á gwar-fwɛɛla nɩ á wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nan yɩ kwe-na tampɔgɔ kʋlʋ ba na kɩ wʋdiu da tɩn. Á nan yɩ kwe gwaarʋ tɩle tɩle naa natra naa nacǝgǝ á wǝli da. Bɛŋwaanɩ tɩntʋŋnʋ maŋɩ dɩ o ni-wʋdiu mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Abam nan na ve á yi tɩʋ kʋlʋ maama, sɩ á lagɩ nɔɔnʋ wʋlʋ na wʋ́ jeeri abam dɩ wʋpolo tɩn, á vu o sɔŋɔ á taá wʋra sɩ kʋ ba kʋ yi á viirim. ");
INSERT INTO xsm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Á nan na ve á zʋ sɔŋɔ kʋlʋ, sɩ á jɔɔnɩ-ba á ta nɩ: ‹Wɛ wʋ́ pa abam yazurǝ.› ");
INSERT INTO xsm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sɔŋɔ kʋm tiinǝ nan na jeeri abam lanyɩranɩ, yazurǝ yam wʋ́ ta wʋra dɩ ba. Kʋ daarɩ, ba na wʋ jeeri abam lanyɩranɩ, yazurǝ yam wʋ́ joori ya ba abam te. ");
INSERT INTO xsm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Abam nan na ve sɔŋɔ kʋlʋ naa tɩʋ kʋlʋ, yɩ ba na wʋ sɛ sɩ ba jeeri abam naa ba cǝgi abam taanɩ, sɩ á nuŋi je sɩm kʋntʋ nɩ. Á na maa viirǝ, sɩ á pɩɩsɩ á nɛ fogo kʋm á yagɩ da. ");
INSERT INTO xsm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A nan lagɩ a ta cɩga mʋ dɩ abam sɩ, Wɛ sarɩya dɛ dɩm na yiǝ, Sodɔm dɩ Gomɔɔrɩ tiinǝ bá tiini ba na lɛɛrʋ nɩ tɩʋ kʋm kʋntʋ nɔɔna te. ");
INSERT INTO xsm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cǝgi-na, a lagɩ a tʋŋɩ abam nɩnɛɛnɩ peeni na maa ve sɩ sɩ gwaanɩ nywǝnkuri wʋnɩ te tɩn mʋ. Kʋntʋ ŋwaanɩ á maŋɩ sɩ á taá cʋ á tɩtɩ, sɩ á taá jɩgɩ swan nɩ bɩsankwɩ te, sɩ á daarɩ á pa á wʋrʋ taa lana nɩ kunkwǝnǝ na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Á taá cʋ á tɩtɩ, sɩ nɔɔna wʋ́ ja abam ba vu ba saŋɩ sarɩya-dirǝ nakwa bam tee nɩ, yɩ ba daarɩ ba magɩ abam ba Wɛ-di sɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Abam na tɔgɩ amʋ tɩn ŋwaanɩ, baá ja abam ba vu ba saŋɩ dɩdɛɛra dɩ pwa tee nɩ. Kʋntʋ mʋ á wʋ́ wanɩ á brɩ-ba Wɛ cɩga kam, yɩ á daarɩ á brɩ dwi-gɛ tiinǝ bam dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ba nan na jaanɩ abam ba vu ba saŋɩ, sɩ á yɩ taá liǝ dɩ á na wʋ́ ta kʋlʋ tɩn naa á na wʋ́ ta te tɩn. Á na wʋ́ taá zɩgɩ ba yigǝ nɩ maŋa kalʋ tɩn, Wɛ wʋ́ pa á lwarɩ á na wʋ́ ta kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kʋ daɩ abam tɩtɩ mʋ wʋ́ ŋɔɔnɩ, kʋ yɩ á Ko Wɛ Joro kʋm mʋ wʋ́ pa abam taanɩ dɩlʋ á na wʋ́ ŋɔɔnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nɔɔna badonnǝ wʋ́ ja ba tɩtɩ cʋrrʋ ba kɩ nɔɔna jɩa nɩ sɩ ba gʋ-ba. Kwǝ dɩ wʋ́ kɩ ba biǝ kʋntʋ doŋ. Biǝ dɩ wʋ́ zaŋɩ ba pa ba ja ba niinǝ dɩ ba kwǝ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nɔɔna maama wʋ́ ta culi abam, á na yɩ amʋ nɔɔna tɩn ŋwaanɩ. Wʋlʋ maama nan na tiini o zɩgɩ kǝŋkǝŋ sɩ kʋ vu kʋ yi yaara yam tiim tɩn, Wɛ wʋ́ vrɩ kʋntʋ tu ŋwɩa. ");
INSERT INTO xsm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ba nan na bɛɛsɩ abam tɩʋ kʋlʋ nɩ, sɩ á duri á vu kʋdoŋ. A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam bá wanɩ á tʋlɩ tɩɩnɩ dɩlʋ maama na wʋ Yisɩrayɛlɩ nɩ tɩn á ti, yɩ amʋ Nabiin-bu wʋm daa ta wʋ joori a ba. ");
INSERT INTO xsm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Karabu nan tǝrǝ o na dwe o karanyɩna. Tɩntʋŋnʋ dɩ nan tǝrǝ o na dwe o yuutu. ");
INSERT INTO xsm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Karabu nan na tu o yɩ nɩ o karanyɩna te, kʋ maŋɩ kʋntʋ. Tɩntʋŋnʋ dɩ nan na tu o yɩ nɩ o yuutu te, kʋ maŋɩ kʋntʋ. Ba na jɩgɩ sɔŋɔ tu ba bǝ ba wɩ ‹Sʋtaana-pɛ Belizebuli› tɩn, ba laan wʋ́ tiini ba twɩ o sɔŋɔ tiinǝ bam sɩ kʋ dwǝni kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Á nan yɩ taá fʋna dɩ nabiinǝ. Woŋo kʋlʋ maama na sǝgi nɔɔna tee nɩ tɩn jwa wʋ́ ba kʋ lwarɩ jaja. Woŋo kʋlʋ na pugi tɩn jwa wʋ́ ba kʋ puri. ");
INSERT INTO xsm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A na sǝgi a brɩ abam cɩga kalʋ maama tɩn, á maŋɩ sɩ á pa ka nuŋi pooni mʋ. A na waasɩ kʋlʋ dɩ abam tɩn, á maŋɩ sɩ á di nayuu mʋ á tɔɔlɩ-kʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Abam yɩ taá kwarɩ fʋʋnɩ dɩ nɔɔna balʋ na wʋ́ wanɩ ba gʋ á yɩra yam yɩ ba bá wanɩ á jwǝǝru ba gʋ tɩn. Á nan maŋɩ sɩ á taá kwarɩ Wɛ mʋ, bɛŋwaanɩ dɩntʋ mʋ wʋ́ wanɩ DƖ pa á yɩra dɩ á jwǝǝru maama cɔgɩ min-tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kʋ na yɩ kabǝmbǝli, sɩntʋ yǝlo yɩ mwalɩ mwalɩ mʋ. Á Ko Wɛ nan nii sɩ baŋa nɩ, yɩ sɩ dɩdʋa bá wanɩ ka tʋ tɩga nɩ ka tɩ dɩ Wɛ na wʋ sɛ. ");
INSERT INTO xsm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kʋ nan na yɩ abam, Wɛ ye abam yuuywe sɩm ni na maɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kʋntʋ ŋwaanɩ, á yɩ taá kwarɩ fʋʋnɩ, sɩ abam dɩdʋa dɩdʋa tiini á jɩgɩ kuri á dwe kabǝmbǝli zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nɔɔnʋ wʋlʋ maama na zɩgɩ nabiinǝ yigǝ nɩ o brɩ jaja nɩ wʋntʋ yɩ amʋ nɔɔnʋ tɩn, amʋ dɩ nan wʋ́ zɩgɩ kʋntʋ tu kwaga nɩ a brɩ nɩ o yɩ a nɔɔnʋ a Ko Wɛ yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kʋ daarɩ, nɔɔnʋ wʋlʋ maama na vɩn amʋ nabiinǝ yigǝ nɩ tɩn, amʋ dɩ wʋ́ vɩn kʋntʋ tu a Ko Wɛ yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A na tu lʋgʋ baŋa tɩn, á yɩ taá bʋŋɩ nɩ, kʋ yɩ sɩ a pa nɔɔna mʋ na ywǝǝni daanɩ. A nan tu sɩ a pa nabiinǝ mʋ pɔɔrɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A tu sɩ a pa nɔɔna dɩ ba kwǝ mʋ pɔɔrɩ daanɩ, sɩ a daarɩ a pa bukwa dɩ ba niinǝ dɩ pɔɔrɩ daanɩ, kʋ daarɩ sɩ kaana dɩ ba banna niinǝ dɩ pɔɔrɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kʋ ma wʋ́ pa nɔɔnʋ dɩ o tɩtɩ sɔŋɔ tiinǝ taa culi daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wʋlʋ na soe o nu dɩ o ko o dwe amʋ tɩn, kʋntʋ tu wʋ maŋɩ sɩ o taa yɩ a nɔɔnʋ. Wʋlʋ maama na soe o biǝ o dwe amʋ tɩn, kʋntʋ tu wʋ maŋɩ sɩ o taa yɩ a nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wʋlʋ maama na wʋ sɛ sɩ o tɔgɩ amʋ kwaga, sɩ o na yaara nɩ wʋlʋ na zɩŋɩ tʋʋn-dagara o maa ve o tʋʋnɩ jǝgǝ te tɩn, kʋntʋ tu wʋ maŋɩ sɩ o taa yɩ amʋ nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wʋlʋ maama nan na lagɩ sɩ o yɩrɩ o tɩtɩ ŋwɩa tɩn, oó ga-ka mʋ. Kʋ daarɩ, wʋlʋ na sɛ sɩ o ga o ŋwɩa amʋ ŋwaanɩ tɩn, oó na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nɔɔnʋ wʋlʋ na jeeri abam lanyɩranɩ tɩn, kʋ tu jeeri amʋ mʋ. Nɔɔnʋ wʋlʋ na jeeri amʋ lanyɩranɩ tɩn, kʋ tu jeeri Baŋa-Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nɔɔnʋ wʋlʋ maama na jeeri Wɛ nijoŋnu lanyɩranɩ tɩn, dɩ Wɛ na tʋŋ-o tɩn ŋwaanɩ, Wɛ wʋ́ pa kʋntʋ tu dɩ tɔgɩ o na nyɔɔrɩ nɩ DƖ nijoŋnu wʋm te. Kʋ daarɩ, nɔɔnʋ wʋlʋ na jeeri nɔn-ŋʋm lanyɩranɩ o nɔn-ŋʋnɩm dɩm ŋwaanɩ tɩn, Wɛ wʋ́ pa kʋntʋ tu dɩ tɔgɩ o na nyɔɔrɩ dɩlʋ DƖ na wʋ́ pa nɔn-ŋʋm wʋm tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ na maŋɩ o kɩ na-zurǝ fɩnfɩɩn dɩ o pa amʋ nɔɔna bam wʋ dɩdʋa, o na yɩ a karabu tɩn ŋwaanɩ, kʋ tu wʋ́ na nyɔɔrɩ Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zezi dɛɛn na brɩ o karabiǝ fugǝ-bale bam ba na maŋɩ sɩ ba kɩ te o ti tɩn, o laan ma kɛ o vu je sɩm kʋntʋ tɩɩnɩ dɩm wʋnɩ sɩ o taa brɩ nɔɔna, yɩ o tɔɔlɩ Wɛ kwǝrǝ kam dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn dɛɛn maa wʋ pɩɩna digǝ nɩ. O ma ni wǝǝnu tɩlʋ Zezi Krisi na kɩ tɩn. O ma tʋŋɩ o karabiǝ badonnǝ sɩ ba vu o te, ");
INSERT INTO xsm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","sɩ ba bwe-o ba nii: «Nmʋ mʋ yɩ wʋlʋ Wɛ na tagɩ dɩ dɩbam nɩ nń ba tɩn na, naa dɩ́ ta wʋ́ ta cǝgi nɔɔnʋ wʋdoŋ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ba na bwe Zezi kʋntʋ tɩn, o ma lǝri-ba o wɩ, ba ve ba ta dɩ Zan kʋlʋ maama ba na niǝ yɩ ba kwǝri ba na tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","«Á taá brɩ-o nɩ lilwǝ yiǝ puri, kwaarʋ dɩ waɩ tɩ veǝ, nanywaanʋ yɩra dɩ joori ya kwɛ lanyɩranɩ, zwa-kwarʋ dɩ zwa ni, twa dɩ joori ba bi. Kʋlʋ na wǝli da tɩn, yinigǝ tiinǝ dɩ maa ni Wɛ kwǝr-ywǝŋǝ kam. ");
INSERT INTO xsm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wʋlʋ maama na ba joori amʋ kwaga nɩ tɩn mʋ yɩ yu-yoŋo tu.» ");
INSERT INTO xsm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zan karabiǝ bam na ma viiri tɩn, Zezi laan ma ta Zan taanɩ o brɩ nɔn-kɔgɔ kʋm o wɩ: «Abam dɛɛn na ve Zan te kagʋa wʋnɩ tɩn, á bʋŋɩ nɩ á wʋ́ na bɛɛ mʋ? Á ve sɩ á nii miu kʋlʋ viu na jɩgɩ kʋ zuuli tɩn mʋ na? ");
INSERT INTO xsm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aye, kʋ daɩ kʋntʋ. Sɩ bɛɛ mʋ? Á ve sɩ á nii nɔɔnʋ wʋlʋ na zʋ gwar-ŋʋnnʋ tɩn mʋ na? Aye, kʋ daɩ kʋntʋ. Nɔɔna balʋ na zʋ gwar-ŋʋnnʋ tɩn zʋʋrɩ sɔ-ŋʋnnʋ wʋnɩ mʋ, sɩ kʋ daɩ kagʋa wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bɛɛ nan mʋ á ve sɩ á nii? Á ve sɩ á na Wɛ nijoŋnu mʋ na? Ɛɛn, kʋ yɩ kʋntʋ mʋ. Á nan na nɛ wʋlʋ tɩn tiini o dwe faŋa faŋa Wɛ nijoŋnǝ bam na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bɛŋwaanɩ Wɛ tɔnɔ kʋm maŋɩ kʋ ta wʋntʋ taanɩ kʋ wɩ: ‹Nii, amʋ Wɛ lagɩ a tʋŋɩ a nijoŋnu mʋ, sɩ o da nmʋ yigǝ o vu o kwɛ cwǝŋǝ kalʋ nmʋ na wʋ́ ba n tɔgɩ da tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nabiinǝ balʋ maama ba na maŋɩ ba lʋ tɩn wʋnɩ nɔɔn-nɔɔnʋ tǝrǝ o na dwe Zan. Kʋ daarɩ lele kʋntʋ, nɔn-nabwǝm wʋlʋ maama na zʋ Wɛ paarɩ dɩm wʋnɩ tɩn laan tu o dwe Zan. ");
INSERT INTO xsm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kʋ na zɩgɩ maŋa kalʋ Zan na miisi nɔɔna na wʋnɩ sɩ kʋ ba kʋ yi zɩm tɩn, Wɛ paarɩ dɩm laan jagɩ dɩ vu yigǝ dɩ dam, yɩ nɔn-balwaarʋ dɩ kwaanɩ sɩ ba cɩ-dɩ dɩ dam. ");
INSERT INTO xsm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Faŋa faŋa Wɛ nijoŋnǝ bam dɩ Moyisi cullu tɩm dɛɛn maŋɩ tɩ brɩ Wɛ paarɩ dɩm cɩga kam, sɩ kʋ ba kʋ yi maŋa kalʋ Zan laan na tu tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Abam na sɛ á joŋi ba na brɩ cɩga kalʋ tɩn, á wʋ́ lwarɩ nɩ Zan na tu o wʋra tɩn, wʋntʋ mʋ yɩ Eli wʋlʋ ba dɛɛn na tagɩ o taanɩ nɩ oó ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Abam nan fɔgɩ á cǝgi amʋ taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","A ma bɛɛ mʋ a maŋɩ zɩm nɔɔna bam kǝm na yɩ te tɩn? Ba nyɩ dɩ biǝ na je yaga kaporo nɩ ba kwɛɛra te tɩn mʋ. Ba maa tɛ dɩ ba yuu donnǝ ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Dɩ́ magɩ gullu mʋ sɩ á sa, yɩ á wʋ sagɩ. Dɩ́ ma daarɩ dɩ́ leeni luǝ le, yɩ á yigǝ wʋ nywanɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bɛŋwaanɩ Zan na tu tɩn, o pɩɩnɩ o kana mʋ yɩ o ba nyɔ sana. Nɔɔna na nɛ-o tɩn, ba maa jɩg-o ba yáala ba wɩ, kʋ yɩ cicirǝ mʋ tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kʋ daarɩ, amʋ Nabiin-bu wʋm nan na tu tɩn, a wʋ vɔgɩ ni. Nɔɔna daa ta maa yáalɩ amʋ dɩ, yɩ ba wɩ, a yɩ nɔn-kolo mʋ, yɩ a yɩ sa-nyɔrʋ dɩ. Ba daa ta maa wɩ, a yɩ lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ ciloŋ mʋ. ‹Wʋbʋŋa tu tɩtʋŋa mʋ brɩ nɩ o jɩgɩ wʋbʋŋa.› » ");
INSERT INTO xsm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Zezi na tagɩ kʋntʋ o ti tɩn, o laan maa jɩgɩ balʋ na nɛ o wo-kɩnkagɩla yam yɩ ba ta wʋ sɛ sɩ ba lǝni ba wʋrʋ tɩn taanɩ o ŋɔɔna. O ma kaanɩ balʋ na zʋʋrɩ tɩɩnɩ dɩlʋ o na kɩ wo-kɩnkagɩla zanzan da tɩn o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Abam Korazin tiinǝ, á wʋ́ na lɛɛrʋ! Kʋ wǝli dɩ abam Betisayida tiinǝ dɩ wʋ́ na lɛɛrʋ! Bɛŋwaanɩ, wo-kɩnkagɩla yalʋ maama a na kɩ abam tee nɩ tɩn, yadonnǝ ya na kɩ Tiiri dɩ Sidɔn tiinǝ tee nɩ, bantʋ ya wʋ́ kɩ lɩla ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, yɩ ba ya wʋ́ zʋ gwar-zɩnzwara ba lo puru ba yuu nɩ, sɩ kʋ brɩ nɩ ba wʋrʋ mʋ tiini tɩ cɔgɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taá ye-na nɩ, Wɛ sarɩya dɛ dɩm na yiǝ, Tiiri dɩ Sidɔn tiinǝ bá tiini ba na lɛɛrʋ nɩ abam na wʋ́ na lɛɛrʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Abam Kapɛrnawum tiinǝ, á ga bʋŋɩ nɩ Wɛ lagɩ DƖ zǝŋi abam wɛyuu nɩ mʋ na? Aye. Abam nan lagɩ á tʋ tɩga nɩ mʋ, á tu á kwaarɩ curu goŋ-luŋu kʋm kuri. Bɛŋwaanɩ, wo-kɩnkagɩla yalʋ maama a na kɩ abam tee nɩ tɩn, yadonnǝ ya na kɩ Sodɔm tiinǝ tee nɩ, ba ya wʋ́ lǝni ba wʋrʋ yɩ Wɛ ya daa bá cɔgɩ ba tɩʋ kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Á taá ye nɩ, Wɛ sarɩya dɛ dɩm na yiǝ, Sodɔm tiinǝ bá tiini ba na lɛɛrʋ nɩ abam na wʋ́ na lɛɛrʋ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Maŋa kantʋ nɩ, Zezi laan ma kɩ o Ko Baŋa-Wɛ le yɩ o wɩ: «A Ko, nmʋ yɩ wʋlʋ na te wɛyuu dɩ tɩga baŋa maama tɩn. Nmʋ nan mʋ pɛ n cɩga kam sǝgi swan tiinǝ dɩ yiyiu tiinǝ tee nɩ, yɩ n daarɩ n pa balʋ na nyɩ dɩ bu-balɛ te tɩn lwarɩ ka kuri. ");
INSERT INTO xsm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A Ko, a kɩ nmʋ le. Nmʋ na kɩ kʋntʋ tɩn, kʋ yɩ n wʋbʋŋa na lagɩ kʋlʋ tɩn ŋwaanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","O laan ma ŋɔɔnɩ dɩ nɔɔna bam o wɩ: «A Ko Wɛ nan kwe woŋo maama o kɩ a jɩŋa nɩ. Nɔɔn-nɔɔnʋ bá wanɩ o lwarɩ Wɛ Bu wʋm, kʋ na daɩ o Ko yɩranɩ. Nɔɔn-nɔɔnʋ dɩ nan bá wanɩ o lwarɩ a Ko Wɛ, kʋ na daɩ amʋ wʋlʋ na yɩ o Bu tɩn yɩranɩ, kʋ wǝli dɩ amʋ na lagɩ sɩ a pa nɔɔnʋ wʋlʋ maama lwar-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Á ba-na amʋ te, abam balʋ bam maama á na bwǝni yɩ á zɩŋɩ zɩla yalʋ na dunǝ tɩn, sɩ amʋ wʋ́ pa á na siun. ");
INSERT INTO xsm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Á sɛ-na sɩ á tʋŋɩ á pa amʋ, sɩ á zaasɩ kʋlʋ a na lagɩ a brɩ abam tɩn. Bɛŋwaanɩ a yɩ wʋ-bono tu mʋ yɩ a yɩ tu-n-tɩtɩ tu. Aá pa á wʋbʋŋa taa tigi jǝgǝ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bɛŋwaanɩ amʋ tɩtʋŋa yam ba cana, yɩ a na lagɩ sɩ á kɩ kʋlʋ tɩn yɩ mwalɩ mwalɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Da yam kʋntʋ ni nɩ Zezi dɛɛn ma tɔgɩ karɩ wʋ o maa kɛa. Kʋ dɛɛn yɩ Zwifǝ bam siun dɛ nɩ mʋ. O karabiǝ bam dɩ maa tɔgɩ ba wʋra, yɩ kana jɩgɩ-ba. Ba ma bwǝri mɩna ba yu ba dʋna. ");
INSERT INTO xsm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farizɩan tiinǝ dɩ ma tɔgɩ ba wʋra. Ba ma na ba na kɩ kʋlʋ tɩn. Ba laan ma ta dɩ Zezi ba wɩ: «Nii nmʋ karabiǝ bam na kɩ kʋlʋ. Ba tʋŋɩ tɩtʋŋɩ dɩlʋ na cɔgɩ dɩbam siun dɛ cullu tɩm tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zezi ma lǝri-ba o wɩ: «Abam ta wʋ fɔgɩ á karɩmɩ Wɛ tɔnɔ kʋm na brɩ Pɛ Davidi taanɩ te tɩn na? Kʋ brɩ sɩ kana dɛɛn mʋ jaanɩ wʋntʋ dɩ o nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O ma vu o zʋ Wɛ digǝ, yɩ o kwe culu dɩpɛ dɩlʋ na tigi da Wɛ ŋwaanɩ tɩn o pa o dɩ o nɔɔna bam di. Kʋ nan ya culǝ sɩ bantʋ di dɩpɛ dɩm. Kʋ yɩ Wɛ kaanɩm tiinǝ yɩranɩ mʋ jɩgɩ cwǝŋǝ sɩ ba di-dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naa, abam ta wʋ fɔgɩ á karɩmɩ Wɛ tɔnɔ kʋm na brɩ nɩ, Wɛ kaanɩm tiinǝ bam yǝni ba cɔgɩ siun dɛ culu kʋm dɩ ba na tʋŋɩ DƖ digǝ kam tɩtʋŋa siun dɛ maama wʋnɩ tɩn? Ba nan na yǝni ba tʋŋɩ kʋntʋ tɩn, ba ta jɩgɩ bʋra kʋ wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kʋ daarɩ lele kʋntʋ, wʋlʋ na dwe Wɛ-di-kamunu kʋm tɩn nan mʋ wʋ yo. ");
INSERT INTO xsm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wɛ tagɩ DƖ wɩ: ‹Amʋ lagɩ sɩ nabiinǝ taa jɩgɩ da-ŋwaŋa mʋ, sɩ kʋ daɩ nɩ a lagɩ sɩ ba taa maɩ ba wǝǝnu mʋ ba kaanɩ-nɩ.› Abam ya na lwarɩ taanɩ dɩntʋ kuri, á ya bá di balʋ na jɩgɩ bʋra tɩn taanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bɛŋwaanɩ amʋ Nabiin-bu wʋm jɩgɩ ni siun dɛ cullu tɩm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zezi laan ma nuŋi jǝgǝ kantʋ nɩ o vu o zʋ Zwifǝ bam Wɛ-digǝ. ");
INSERT INTO xsm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɔɔnʋ maa wʋra o jɩŋa dɩdʋa na tɩga. Farizɩan tiinǝ badonnǝ dɩ maa tɔgɩ ba wʋra ba na lagɩ cwǝŋǝ sɩ ba brɩ nɩ Zezi kɩ o tusi. Ba ma bwe-o ba wɩ: «Nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o pa o doŋ na yazurǝ siun dɛ dɩm nɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zezi ma lǝri-ba o wɩ: «Abam wʋlʋ na jɩgɩ piǝ, yɩ ka na tʋ vʋl-kɔgɔ wʋnɩ siun dɛ dɩm nɩ, á bá nii ka baŋa nɩ sɩ á lɩ-ka na? ");
INSERT INTO xsm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nabiinu nan tiini o jɩgɩ kuri o dwe piǝ. Kʋntʋ ŋwaanɩ nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o kɩ o doŋ lanyɩranɩ siun dɛ dɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","O na tagɩ kʋntʋ tɩn, o laan ma ta dɩ nɔɔnʋ wʋlʋ jɩŋa kam na tɩgɩ tɩn o wɩ: «Twɩ n jɩŋa kam.» Nɔɔnʋ wʋm ma sɩɩnɩ o twɩ-ka. O jɩŋa kam ma joori ka ji lanyɩranɩ nɩ o jɩ-ŋʋŋa kam te. ");
INSERT INTO xsm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farizɩan tiinǝ bam na nɛ kʋntʋ tɩn, ba ma nuŋi ba vu ba banɩ daanɩ sɩ ba lagɩ cwǝŋǝ ba gʋ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Zezi dɛɛn ma lwarɩ ba na lagɩ ba kɩ-o te tɩn. O ma nuŋi jǝgǝ kam kʋntʋ nɩ. Nɔn-kɔgɔ zanzan dɛɛn maa tɔg-o. O ma pa ba maama na yazurǝ dɩ ba yawɩɩrʋ. ");
INSERT INTO xsm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","O ma daarɩ o kaanɩ-ba o wɩ, ba yɩ zaŋɩ ba pa nɔɔna lwarɩ o ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zezi na kɩ kʋntʋ tɩn, kʋ yɩ sɩ kʋ pa Wɛ nijoŋnu Ezayi na maŋɩ o ta kʋlʋ faŋa faŋa tɩn mʋ sɩɩnɩ kʋ kɩ. O dɛɛn tagɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nii, wʋntʋ mʋ yɩ amʋ Wɛ tɩntʋŋnʋ wʋlʋ a na kuri tɩn. Wʋntʋ mʋ yɩ wʋlʋ a na so-o yɩ o yǝni o paɩ a wʋ poli zanzan tɩn. Aá pa a Joro kʋm taa wʋ o tee nɩ. O ma wʋ́ pa dwi maama tiinǝ ba ba lwarɩ amʋ cɩga kam na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wʋntʋ nan bá ta magɩ kantɔgɔ naa o taa kɩ sɔɔ. O nan bá ta paɩ o kwǝrǝ zaŋa cwe jeerǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wʋntʋ bá cɔgɩ nɔɔna balʋ na tiini ba bwǝnǝ tɩn, oó ta jɩgɩ ba ŋwaŋa, nɩnɛɛnɩ nɔɔnʋ wʋlʋ na bá bwǝri miu kʋlʋ na tiiri tɩn, yɩ o bá dwe kanɩa kalʋ mini na ba dana tɩn. Oó ta kɩ kʋntʋ mʋ, sɩ kʋ vu kʋ yi maŋa kalʋ o na wʋ́ pa amʋ Wɛ cɩga kam ba ka taa jɩgɩ dam nɔɔna tɩtarɩ nɩ, yɩ lanyɩranɩ wanɩ balɔrɔ. ");
INSERT INTO xsm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wʋntʋ yɩrɩ ŋwaanɩ mʋ dwi maama wʋ́ ta jɩgɩ tɩɩna amʋ Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nɔɔna badonnǝ dɛɛn ma ja lilwe, yɩ o kwǝri o yɩ mɩmaa ba ba Zezi te. Bɛŋwaanɩ cicirǝ dɛɛn mʋ jɩg-o ka yaara. Zezi ma pa nɔɔnʋ wʋm na yazurǝ. O yiǝ ma joori ya naɩ, yɩ o daarɩ o waɩ o ŋɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kʋ ma sʋ nɔn-kɔgɔ kʋm maama, yɩ ba tɛ ba wɩ: «Nɔɔnʋ wʋntʋ mʋ yɩ Pɛ Davidi dwi tu wʋlʋ Wɛ na lagɩ DƖ tʋŋɩ tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farizɩan tiinǝ bam na ni kʋntʋ tɩn, ba ma ta ba wɩ: «Wʋntʋ na waɩ o zǝli sʋtaana tɩn, kʋ yɩ sʋtaana-pɛ Belizebuli dam mʋ o ma o zǝli-ya.» ");
INSERT INTO xsm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zezi na lwarɩ ba wʋbʋŋa na yɩ te tɩn, o ma ta dɩ ba o wɩ: «Tɩʋ kʋlʋ paarɩ na pɔɔrɩ kuni bɩle yɩ ba jɩgɩ daanɩ tɩn, kʋ bá daanɩ kʋ cɔgɩ. Tɩʋ kʋlʋ maama naa sɔŋɔ kʋlʋ maama na pɔɔrɩ kʋ tɩtɩ wʋnɩ kuni bɩle tɩn, kʋʋ́ tʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kʋ ya na sɩɩnɩ kʋ yɩ cɩga nɩ a maɩ sʋtaana-pɛ dam mʋ a ma a zǝli sʋtaana nɔɔna tee nɩ, kʋntʋ ya wʋ́ brɩ nɩ sʋtaana-pɛ dam dɩm pɔɔrɩ kuni bɩle mʋ, yɩ o paarɩ dɩm bá daanɩ dɩ cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kʋ na sɩɩnɩ kʋ yɩ amʋ jɩgɩ Belizebuli dam mʋ a ma a zǝli sʋtaana, abam nɔɔna bam dɩ nan maɩ dam dɩm kʋntʋ mʋ ba maa zǝli-ya na? Abam tɩtɩ nɔɔna bam na kɩ te tɩn mʋ brɩ nɩ cɩga tǝri á tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kʋ nan yɩ Wɛ Joro kʋm dam mʋ a ma a zǝli sʋtaana. Kʋntʋ maa brɩ nɩ Wɛ maŋɩ DƖ ba abam te, sɩ DƖ di paarɩ nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sʋtaana-pɛ nan nyɩ dɩ nɔn-dɩdɛɛrʋ na yɩrɩ o sɔŋɔ te tɩn mʋ. Nɔɔnʋ na lagɩ sɩ o vu nɔn-dɩdɛɛrʋ wʋm sɔŋɔ o ŋɔ, o maŋɩ sɩ o da yigǝ o ja nɔn-dɩdɛɛrʋ wʋm o vɔ mʋ. O na vɔg-o o ti tɩn, mʋ o laan wʋ́ wanɩ o wǝǝnu tɩm maama o kwalɩmɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nɔɔnʋ wʋlʋ maama nan na daɩ a nɔɔnʋ tɩn, o yɩ a dʋm mʋ. Nɔɔnʋ wʋlʋ maama nan na ba tɔgɩ o laɩ amʋ nɔɔna o kɩ jǝgǝ dɩdʋa tɩn, o jagɩ-ba mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Á taá ye nɩ, kǝm-balwaarʋ tɩlʋ maama nɔɔna na kɩ tɩn, naa ta-balwaarʋ tɩlʋ maama ba na ŋɔɔnɩ tɩn, Wɛ waɩ DƖ yagɩ-tɩ DƖ ma cɛ-ba. Kʋ daarɩ, nɔɔnʋ wʋlʋ nan na ŋɔɔnɩ o twɩ Wɛ Joro kʋm tɩn, Wɛ bá sɛ sɩ DƖ ma cɛ kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nɔɔnʋ wʋlʋ na ŋɔɔnɩ ta-balwaarʋ o pa amʋ Nabiin-bu wʋm tɩn, Wɛ wʋ́ sɛ sɩ DƖ ma cɛ kʋ tu. Nɔɔnʋ wʋlʋ nan na ŋɔɔnɩ o twɩ Wɛ Joro kʋm tɩn, Wɛ bá sɛ sɩ DƖ ma cɛ kʋntʋ tu maŋa dɩ maŋa. ");
INSERT INTO xsm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Á na wɩ, tiu yɩ tu-ŋʋŋʋ, kʋ biǝ dɩ yɩ bu-ŋʋna mʋ. Á na wɩ, tiu yɩ tu-balɔrɔ, kʋ biǝ dɩ yɩ bu-balwaarʋ mʋ. Ba lwarɩ tiu kʋ biǝ lǝrim nɩ mʋ. Kʋntʋ tɩn, abam na sɛ nɩ amʋ kǝm dɩm lana, á maŋɩ sɩ á sɛ nɩ amʋ dam dɩm nuŋi Wɛ Joro kʋm te mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Abam nyɩ dɩ bɩsankwɩ-dwǝ mʋ. Abam na yɩ nɔn-balwaarʋ tɩn, á bá wanɩ á ŋɔɔnɩ wo-ŋʋnnʋ. Woŋo kʋlʋ maama na wʋ nɔɔnʋ wʋbʋŋa nɩ tɩn mʋ tɔgɩ o ni kʋ nuŋǝ. ");
INSERT INTO xsm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nɔn-ŋʋm ŋɔɔnɩ wo-ŋʋnnʋ tɩlʋ na wʋ o wʋbʋŋa nɩ tɩn mʋ, yɩ nɔn-balɔrɔ dɩ ŋɔɔnɩ wo-balwaarʋ tɩlʋ na wʋ o wʋbʋŋa nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Á taá ye nɩ, Wɛ sarɩya dɛ dɩm nɩ DƖ wʋ́ bwe nɔɔnʋ maama sɩ o ma o ni o ta bɩtar-yɔɔrʋ tɩlʋ maama o na tagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bɛŋwaanɩ abam tɩtɩ ni-taanɩ mʋ wʋ́ brɩ nɩ á jɩgɩ bʋra naa á ba jɩgɩ bʋra.» ");
INSERT INTO xsm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wɛ cullu karanyɩna tiinǝ dɩ Farizɩan tiinǝ badonnǝ dɛɛn ma zaŋɩ ba ta dɩ Zezi ba wɩ: «Karanyɩna, dɩbam lagɩ sɩ n kɩ wo-kɩnkagɩlɩ mʋ, sɩ kʋ brɩ dɩbam nɩ n nuŋi Wɛ te mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O ma lǝri-ba o wɩ: «Zɩm nɔɔna bantʋ yɩ nɔn-balwaarʋ mʋ, ba ba tɔgɩ Wɛ dɩ cɩga, yɩ ba lagɩ sɩ a kɩ wo-kɩnkagɩlɩ a brɩ-ba. Ba nan bá na, kʋ na daɩ wo-kɩnkagɩlɩ dɩlʋ na maŋɩ dɩ kɩ dɩ Wɛ nijoŋnu Zonasɩ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wʋntʋ dɛɛn kɩ da yatɔ mʋ wɩa dɩ tɩtɩɩ maama kalǝŋ-kamunu wʋnɩ. Kʋ nan maŋɩ sɩ kʋ kɩ amʋ Nabiin-bu wʋm kʋntʋ doŋ mʋ, amʋ dɩ wʋ́ kɩ da yatɔ mʋ wɩa dɩ tɩtɩɩ maama yibeeli wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Zonasɩ dɛɛn na ve Niniivi tiinǝ te o tɔɔlɩ Wɛ kwǝrǝ kam dɩ ba tɩn, bantʋ lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ. Wʋlʋ na dwe Zonasɩ tɩn nan wʋ abam tee nɩ yɩ á wʋ sɛ kʋ tu. Kʋntʋ ŋwaanɩ, Wɛ sarɩya dɛ dɩm na yiǝ, Niniivi tiinǝ laan wʋ́ zaŋɩ ba brɩ nɩ abam ba jɩgɩ bʋra. ");
INSERT INTO xsm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pa-kana kalʋ dɛɛn na te Saba tɩʋ tɩn dɩ wʋ́ zaŋɩ o di abam sarɩya, yɩ o vɩn abam bʋra. Bɛŋwaanɩ wʋntʋ dɛɛn zaŋɩ o tɩtɩ tɩʋ kʋlʋ na tiini kʋ yɩ yigǝ yigǝ tɩn nɩ, o ba pɛ Salɔmɔn te sɩ o cǝgi o swan taanɩ dɩm. Wʋlʋ nan na dwe Salɔmɔn tɩn mʋ wʋ abam tee nɩ, yɩ á ba lagɩ sɩ á cǝg-o.» ");
INSERT INTO xsm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Cicirǝ na nuŋi nɔɔnʋ yɩra nɩ, ka laan wʋ́ vu ka beeri kapwǝrǝ yigǝ mʋ sɩ ka lagɩ jǝgǝ ka sin da. Ka na beeri ka ga tɩn, ");
INSERT INTO xsm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka laan maa wɩ: ‹Aá joori a vu a na nuŋi mɛ tɩn mʋ a taa wʋra.› Ka ma joori ka vu nɔɔnʋ wʋm te, yɩ ka na nɩ ka jǝgǝ kam fɔgɩ ka kwɛ lanyɩranɩ, yɩ kʋlʋkʋlʋ wʋ zʋ da. ");
INSERT INTO xsm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ka laan ma joori ka vu ka lagɩ ciciri sɩrpɛ sɩlʋ na tiini sɩ yɩ balwaarʋ sɩ dwe ka tɩtɩ tɩn. Sɩ ma tɔgɩ daanɩ sɩ vu sɩ zʋʋrɩ da. Kʋntʋ, nɔɔnʋ wʋm laan wʋ́ tiini o na cam kʋ dwǝni faŋa. Mʋ kʋ na lagɩ kʋ kɩ zɩm nɔn-balwaarʋ tɩm dɩ te.» ");
INSERT INTO xsm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zezi dɛɛn ta na wʋra o ŋɔɔnɩ dɩ nɔn-kɔgɔ kʋm kʋntʋ tɩn, o nu dɩ o nyaana ma ba ba zɩgɩ sɔŋɔ kʋm mancoŋo nɩ, yɩ ba lagɩ sɩ ba ŋɔɔnɩ dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɔɔnʋ wʋdoŋ ma ta dɩ Zezi o wɩ: «N nu dɩ n nyaana tu ba wʋ cicwǝŋǝ nɩ, yɩ ba lagɩ sɩ ba na-m.» ");
INSERT INTO xsm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zezi ma ta dɩ nɔɔnʋ wʋm o wɩ: «Wɔɔ mʋ yɩ a nu, bran yɩ a nyaana?» ");
INSERT INTO xsm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O laan ma nii o karabiǝ bam seeni yɩ o wɩ: «A nu dɩ a nyaana mʋ tɩntʋ. ");
INSERT INTO xsm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bɛŋwaanɩ wʋlʋ maama na kɩ a Ko Wɛ wʋbʋŋa na lagɩ te tɩn mʋ yɩ a nyaanɩ dɩ a nakɔ dɩ a nu.» ");
INSERT INTO xsm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dɛ dɩm kʋntʋ nɩ Zezi ma nuŋi sɔŋɔ kʋm nɩ o vu nɩnɩʋ kʋm ni. O ma jǝni tɩga nɩ sɩ o brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nɔn-kɔgɔ ma ba kʋ gilim-o. Kʋntʋ ŋwaanɩ o ma zaŋɩ o vu o zʋ naboro wʋ o je da, yɩ kɔgɔ kʋm laan zɩgɩ na bam ni nɩ sɩ ba taa cǝgi o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O ma maŋɩ mɩmaŋa o brɩ-ba wǝǝnu zanzan o wɩ: «Valʋ dɛɛn mʋ wʋra. O ma zaŋɩ o vu kara sɩ o du. ");
INSERT INTO xsm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","O ma karɩ o dʋlɩ o wo-duuru tɩm. Tɩdonnǝ ma tʋ cwǝŋǝ ni nɩ. Zunǝ ma ba ba twɛ-tɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tɩdonnǝ ma tʋ kandwa jǝgǝ nɩ valɩm na ba daga mɛ tɩn. Tɩ ma wʋ daanɩ tɩ puli, valɩm dɩm na ba lirǝ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Wɩa ma ba ka baanɩ tɩ maama. Tɩ bʋnnʋ na wʋ zʋ tɩga tɩn, tɩ ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kʋ daarɩ wo-duuru tɩdonnǝ ma tʋ sabarɩ wʋnɩ. Tɩ na puli tɩn, sabarɩ sɩm laan ma zaŋɩ sɩ li-tɩ sɩ gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kʋ daarɩ tɩdonnǝ ma tʋ tɩ-ywǝŋǝ jǝgǝ nɩ. Tɩ ma nuŋi tɩ kɩ biǝ lanyɩranɩ. Tɩdaara kɩ nɩnɛɛnɩ biǝ bi bi. Tɩdaara ma kɩ nɩnɛɛnɩ biǝ fusɩrdʋ fusɩrdʋ. Tɩdaara dɩ ma kɩ nɩnɛɛnɩ biǝ fiintɔ fiintɔ. ");
INSERT INTO xsm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Abam nan fɔgɩ á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zezi na maŋɩ mɩmaŋɩ dɩm kʋntʋ o ti tɩn, o karabiǝ bam laan ma vu o te, yɩ ba bwe-o ba wɩ: «Bɛɛ mʋ yɩ nmʋ yǝni n maŋɩ mɩmaŋa n brɩ nɔɔna bam?» ");
INSERT INTO xsm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","O ma lǝri-ba o wɩ: «Wɛ paarɩ dɩm kuri ya sǝgi mʋ. Kʋ nan na yɩ abam, Wɛ maŋɩ DƖ pa á lwarɩ DƖ paarɩ dɩm kuri na yɩ te tɩn. Kʋ daarɩ nɔɔna badaara bam, Wɛ wʋ pɛ ba lwarɩ DƖ paarɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mɩmaŋa yam na maŋɩ sɩ ya zǝni nɔɔna wʋbʋŋa te tɩn nyɩ dɩ nɔɔnʋ na maŋɩ o jɩgɩ woŋo, o ta wʋ́ joŋi kʋdoŋ o wǝli da sɩ kʋ taa daga. Nɔɔnʋ wʋlʋ nan na maŋɩ o ba jɩgɩ kʋlʋkʋlʋ tɩn laan wʋ́ ba o ga kʋlʋ fɩnfɩɩn o ya na jɩgɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kʋntʋ, a maɩ mɩmaŋa mʋ a brɩ-ba, bɛŋwaanɩ bantʋ yiǝ mʋ naɩ a na kɩ wǝǝnu tɩlʋ tɩn, yɩ ba ba ni tɩ kuri. Ba ta maa ni a zaasɩm dɩm, yɩ ba ba lwarɩ dɩ kuri. ");
INSERT INTO xsm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kʋntʋ mʋ brɩ nɩ Wɛ nijoŋnu Ezayi dɛɛn na tagɩ kʋlʋ faŋa faŋa tɩn sɩɩnɩ kʋ kɩ bantʋ tee nɩ. O dɛɛn tagɩ o wɩ: ‹Abam wʋ́ fɔgɩ á cǝgi Wɛ taanɩ dɩm dɩ á zwa, yɩ á bá ni dɩ kuri. Abam wʋ́ fɔgɩ á nii dɩ á yiǝ, yɩ á bá na. ");
INSERT INTO xsm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bɛŋwaanɩ nɔɔna bam kʋntʋ wʋbʋŋa tɩgɩ mʋ. Ba zwa dɩ ma kwarɩmɩ, yɩ ba daarɩ ba pu ba yiǝ, sɩ ba yiǝ yɩ zaŋɩ ya na, sɩ ba zwa yɩ zaŋɩ ya ni, sɩ ba wʋbʋŋa yɩ zaŋɩ ya lwarɩ Wɛ taanɩ dɩm kuri. Kʋ na daɩ kʋntʋ, ba ya wʋ́ pipiri ba sɛ amʋ Wɛ, yɩ aá pa-ba yazurǝ.› » ");
INSERT INTO xsm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Zezi laan ma ta dɩ o karabiǝ bam o wɩ: «Kʋ nan na yɩ abam, á jɩgɩ yu-yoŋo, bɛŋwaanɩ abam yiǝ naɩ yɩ á zwa dɩ ni. ");
INSERT INTO xsm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A lagɩ a ta cɩga mʋ dɩ abam sɩ, faŋa faŋa Wɛ nijoŋnǝ bam dɩ nɔn-ŋʋna zanzan dɛɛn jɩgɩ tɩɩna sɩ ba ya na kʋlʋ abam na naɩ lele tɩn, yɩ ba wʋ wanɩ ba na. Ba dɛɛn ta jɩgɩ tɩɩna sɩ ba ya ni Wɛ taanɩ dɩlʋ abam na ni tɩn, yɩ ba wʋ wanɩ ba ni-dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nan cǝgi-na, sɩ a maŋɩ valʋ wʋm mɩmaŋɩ dɩm kuri a brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wo-duuru tɩlʋ na tʋ cwǝŋǝ kam ni nɩ tɩn nyɩ dɩ nɔɔna balʋ na ni Wɛ paarɩ dɩm taanɩ yɩ ba wʋ lwarɩ dɩ kuri tɩn. Wo-lwaanʋ tu sʋtaanɩ laan ma ba o lɩ-dɩ, yɩ dɩ wʋ zʋ ba wʋbʋŋa. ");
INSERT INTO xsm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wo-duuru tɩlʋ na tʋ kandwa jǝgǝ nɩ tɩn dɩ maa nyɩ dɩ nɔɔna balʋ na ni Wɛ taanɩ dɩm yɩ ba joŋi-dɩ lɩla dɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Taanɩ dɩm ma wʋ tiini dɩ zʋ ba wʋbʋŋa, ba ma wʋ zɩgɩ kǝŋkǝŋ. Yaara na yi-ba yɩ ba na bɛɛsɩ-ba Wɛ taanɩ dɩm ŋwaanɩ, baá da ba kwe ba yagɩ mʋ lɩla. ");
INSERT INTO xsm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wo-duuru tɩlʋ na tʋ sabarɩ sɩm wʋnɩ tɩn maa nyɩ dɩ nɔɔna balʋ na ni Wɛ taanɩ dɩm yɩ ba ta jɩgɩ liǝ dɩ lʋgʋ baŋa wǝǝnu tɩn. Sǝbu-lagɩ ma cɔgɩ ba wʋbʋŋa, nɩ sabarɩ sɩm na ligi wo-duuru tɩm te tɩn. Kʋ ma pa ba kwe Wɛ taanɩ dɩm ba yagɩ, yɩ dɩ wʋ jaanɩ kuri dɩ pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kʋ daarɩ wo-duuru tɩlʋ na tʋ tɩ-ywǝŋǝ jǝgǝ kam nɩ tɩn maa nyɩ dɩ balʋ na ni Wɛ taanɩ dɩm yɩ ba pa dɩ tiini dɩ zʋ ba wʋbʋŋa tɩn. Kʋntʋ ma pa Wɛ taanɩ dɩm ja kuri dɩ pa-ba, nɩnɛɛnɩ wo-duuru na kɩ biǝ lanyɩranɩ te tɩn. Tɩdaara kɩ biǝ bi bi, tɩdonnǝ ma kɩ biǝ fusɩrdʋ fusɩrdʋ, tɩtɩm ma kɩ biǝ fiintɔ fiintɔ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Zezi dɛɛn ma maŋɩ mɩmaŋɩ dɩdoŋ o brɩ-ba o wɩ: «A lagɩ a brɩ abam Wɛ paarɩ dɩm na wʋ nɔɔna tɩtarɩ nɩ te tɩn mʋ. Kʋ nyɩ dɩ valʋ na kwe mɩn-ŋʋna o ja vu o kara o du. ");
INSERT INTO xsm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","O na dugi-ya kʋntʋ tɩn, o dʋm ma zaŋɩ pǝn-dʋa maŋa nɩ o ja mɩn-puurǝ o vu o du o gwaanɩ valʋ wʋm kara mɩn-ŋʋna yam wʋnɩ, yɩ o daarɩ o joori o vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mɩn-ŋʋna yam ma ba nuŋi ya ji mɩn-kwɩɩrʋ. O dʋm wʋm na dugi yalʋ tɩn ma nuŋi ya ji mɩn-kayalɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sɔŋɔ tu wʋm tɩntʋŋna laan ma vu ba ta dɩd-o ba wɩ: ‹Dɩbam yuutu, nmʋ na dugi n kara kam tɩn, kʋ daɩ mɩn-ŋʋna yɩranɩ mʋ n dugi na? Bɛɛ mʋ yɩ mɩn-kayalɩ laan nuŋi sɩ gwaanɩ da?› ");
INSERT INTO xsm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O ma lǝri-ba o wɩ: ‹Kʋ yɩ a dʋm mʋ kɩ kʋntʋ.› Ba laan ma bwe-o ba wɩ: ‹Dɩ́ nan ve dɩ́ gɔ mɩn-kayalɩ sɩm dɩ́ yagɩ na?› ");
INSERT INTO xsm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","O ma wʋ sɛ, yɩ o ta dɩ ba o wɩ: ‹Abam na kɩ kʋntʋ, á wʋ́ kɛ á gɔ mɩn-ŋʋna yam dɩ mʋ á wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nan yagɩ-na sɩ ya maama taa wʋra sɩ kʋ ba kʋ yi zagɩm maŋa. Kantʋ maŋa kam nɩ, a laan wʋ́ ta dɩ mɩn-zagɩna bam, sɩ ba da yigǝ ba pɔɔrɩ mɩn-kayalɩ sɩm ba zagɩ ba kɩ daanɩ ba zwɛ, sɩ ba daarɩ ba zagɩ mɩn-ŋʋna yam ba pɛ ba kɩ a tulǝ nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zezi daa ta ma maŋɩ mɩmaŋɩ dɩdoŋ o brɩ-ba o wɩ: «Wɛ paarɩ dɩm nyɩ dɩ nɔɔnʋ na kwe wo-duu na yɩ mɩmɩɩnʋ o vu o du o kara nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wo-duu kʋm kʋntʋ mʋ tiini kʋ yɩ mɩmɩɩnʋ wo-dwǝ maama wʋnɩ. Kʋ ma nuŋi, yɩ kʋ ji kamunu kʋ dwǝni dwǝ balʋ maama na wʋ o kara kam nɩ tɩn. Kʋ laan maa ji tu-kamunu, yɩ zunǝ tui ba sɔ ba pwǝru da.» ");
INSERT INTO xsm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zezi daa ta ma maŋɩ mɩmaŋɩ dɩdoŋ o brɩ-ba o wɩ: «Wɛ paarɩ dɩm nyɩ dɩ kaanɩ na kwe dabɩlɩ o gwaanɩ dɩ dɩpɛ muni zwɩ-zɛ sɩtɔ te tɩn mʋ. Dɩ laan ma pa dɩpɛ muni dɩm maama tiini dɩ fʋlɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Wǝǝnu tɩm kʋntʋ maama Zezi dɛɛn na brɩ nɔn-kɔgɔ kʋm tɩn yɩ mɩmaŋa yɩranɩ mʋ o ma brɩ-ba. O wʋ ŋɔɔnɩ wo-woŋo dɩ ba yɩ kʋ wʋ dɛ dɩ mɩmaŋa. ");
INSERT INTO xsm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","O nan kɩ kʋntʋ, sɩ kʋ pa Wɛ nijoŋnu wʋdoŋ taanɩ mʋ sɩɩnɩ dɩ kɩ. O dɛɛn tagɩ o wɩ: «Amʋ na lagɩ a ŋɔɔnɩ a brɩ-ba, aá ta maɩ mɩmaŋa mʋ a ma brɩ-ba. Aá pa ba lwarɩ Wɛ cɩga kalʋ na sǝgi lʋgʋ pulim maŋa nɩ sɩ kʋ ba kʋ yi zɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Zezi dɛɛn ma zaŋɩ o yagɩ nɔn-kɔgɔ kʋm, yɩ o daarɩ o joori o vu sɔŋɔ. O karabiǝ bam ma ba o te yɩ ba wɩ: «Brɩ dɩbam mɩn-kayalɩ sɩm mɩmaŋɩ dɩm kuri.» ");
INSERT INTO xsm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O ma lǝri-ba o wɩ: «Nɔɔnʋ wʋlʋ na dugi mɩn-ŋʋna yam tɩn brɩ amʋ Nabiin-bu wʋm na kɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kara kam maa nyɩ dɩ lʋgʋ baŋa. Mɩn-ŋʋna yam maa nyɩ dɩ nɔɔna balʋ na yɩ Wɛ paarɩ dɩm nɔɔna tɩn. Kʋ daarɩ mɩn-kayalɩ sɩm maa nyɩ dɩ balʋ na yɩ sʋtaanɩ nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dʋm wʋlʋ na dugi mɩn-kayalɩ sɩm tɩn maa nyɩ dɩ sʋtaanɩ dɩm tɩtɩ. Zagɩm maŋa kam maa nyɩ dɩ lʋgʋ na wʋ́ ba kʋ ti te tɩn. Mɩn-zagɩna bam maa nyɩ dɩ Wɛ malɛsɩ sɩm. ");
INSERT INTO xsm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nɩ mɩn-zagɩna bam na zagɩ mɩn-kayalɩ sɩm ba zwɛ te tɩn, kʋntʋ doŋ mʋ wʋ́ kɩ lʋgʋ tiim maŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kʋ na wʋ́ kɩ te tɩn, amʋ Nabiin-bu wʋm wʋ́ tʋŋɩ a malɛsɩ tiinǝ bam sɩ ba vu ba lɩ kʋlʋ maama na paɩ nɔɔna tusi tɩn dɩ wo-lwaan-kǝrǝ bam maama Wɛ paarɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ba laan wʋ́ zǝli-ba ba yagɩ min-lɔŋɔ wʋnɩ sɩ dɩ di-ba. Dáanɩ mʋ ba laan wʋ́ ta wʋra ba keerǝ yɩ ba dʋnɩ ba nwa. ");
INSERT INTO xsm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kʋ daarɩ balʋ maama na sɛ Wɛ yɩ ba kɩ lanyɩranɩ tɩn laan wʋ́ ta tiini ba nyɩɩna ba Ko Wɛ paarɩ dɩm wʋnɩ, nɩ wɩa na nyɩ te tɩn. Fɔgɩ-na á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Wɛ paarɩ dɩm daa ta nyɩ dɩ wo-ŋʋnnʋ tɩlʋ na yɩ lʋnnɩ nyɩm tɩn na sǝgi kara wʋnɩ. Nɔɔnʋ wʋdoŋ laan ma na-tɩ. O ma joori o fɔgɩ o sǝgi-tɩ. O wʋ na tiini kʋ poli tɩn, o ma vu o kwe o wǝǝnu maama o yǝgi sǝbu, sɩ o vu o yǝgi kara kantʋ, sɩ wo-ŋʋnnʋ tɩm taa yɩ o nyɩm.» ");
INSERT INTO xsm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Wɛ paarɩ dɩm daa ta nyɩ dɩ pipimpiinu na beeri o lagɩ kandwa-ŋʋna sɩ o yǝgi te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","O ma ba o na kandwɛ dɩlʋ na tiini dɩ jɩgɩ lam yɩ dɩ sǝbu daga tɩn. O laan ma joori o vu o kwe o wǝǝnu maama o yǝgi, o ma yǝgi kandwɛ dɩm kʋntʋ yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Wɛ paarɩ dɩm daa ta nyɩ dɩ nɔɔna na kwe bʋra ba dɩ bugǝ nɩ sɩ ba ma ja kale te tɩn. Ba na dɩ-ka da tɩn, ba ma ja kale dwi dwi. ");
INSERT INTO xsm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ka ma ba ka su lanyɩranɩ. Nɔɔna bam laan ma vaŋɩ-ka ba tuuri ba ja bɛ. Ba laan ma jǝni tɩga nɩ ba kuri kalǝŋ-ŋwɩ sɩm ba kɩ ba tampwarʋ wʋnɩ. Ba ma daarɩ ba kwe sɩlʋ na ba lana tɩn ba dʋlɩ ba yagɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kʋ nan wʋ́ ba kɩ kʋntʋ mʋ lʋgʋ tiim maŋa nɩ. Wɛ malɛsɩ wʋ́ ba sɩ pɔɔrɩ nɔn-balwaarʋ dɩ balʋ na sɛ Wɛ yɩ ba kɩ lanyɩranɩ tɩn daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sɩ laan wʋ́ daarɩ sɩ zǝli nɔn-balwaarʋ tɩm sɩ yagɩ min-lɔŋɔ kʋm wʋnɩ sɩ dɩ di-ba. Dáanɩ mʋ ba laan wʋ́ ta wʋra ba keerǝ yɩ ba dʋnɩ ba nwa.» ");
INSERT INTO xsm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zezi na ŋɔɔnɩ o ti tɩn, o laan ma bwe o karabiǝ bam o wɩ: «Abam ni wǝǝnu tɩm maama kuri na?» Ba ma lǝr-o ba wɩ: «Ɛɛn, dɩ́ niǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","O ma ta dɩ ba o wɩ: «Kʋntʋ tɩn, Wɛ cullu karanyɩna wʋlʋ maama na tu o zaasɩ Wɛ paarɩ dɩm cɩga kam tɩn nyɩ dɩ sɔŋɔ tu wʋlʋ na lɩ wo-dʋnnʋ dɩ wo-dwǝǝnu o jɩjɩgɩrʋ wʋnɩ o paɩ nɔɔna te tɩn mʋ. Kʋntʋ tu laan waɩ o lɩ zaasɩm-dʋʋrɩ o wǝli dɩ zaasɩm-doori dɩm sɩ o ma brɩ o nɔɔna bam.» ");
INSERT INTO xsm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zezi dɛɛn na maŋɩ mɩmaŋa yam kʋntʋ o ti tɩn, o laan ma nuŋi jǝgǝ kam kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","O ma joori o vu o tɩtɩ tɩʋ o na bɩgɩ mɛ tɩn. O ma zʋ Zwifǝ Wɛ-digǝ kam sɩ o brɩ-ba. O na brɩ-ba te tɩn, kʋ dɛɛn sʋ-ba lanyɩranɩ. Ba ma ta ba wɩ: «Nɔɔnʋ wʋntʋ kɩ ta mʋ o jɩgɩ swan yam kʋntʋ doŋ? O nan kɩ ta mʋ o na dam o ma kɩ wo-kɩnkagɩla yantʋ? ");
INSERT INTO xsm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wʋm mʋ daɩ da-lwarʋ wʋm bu wʋm na? O nu mʋ daɩ Mari na? Kʋ daɩ o nyaana mʋ yɩ Zakɩ dɩ Zʋzɛfʋ dɩ Simɔn dɩ Zudasɩ na? ");
INSERT INTO xsm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kʋ daɩ o nakwa bam maama mʋ wʋra dɩdaanɩ dɩbam tɩn na? Wʋntʋ nan nɛ dam dɩm kʋntʋ maama yǝn mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kʋntʋ ŋwaanɩ ba dɛɛn wʋ sɛ nɩ Zezi sɩɩnɩ o nuŋi Wɛ te. Zezi ma ta dɩ ba o wɩ: «Nɔɔnʋ na yɩ Wɛ nijoŋnu, nɔɔna pa-o zulǝ lanyɩranɩ, kʋ daarɩ o tɩtɩ tɩʋ tiinǝ dɩ o sɔŋɔ tiinǝ nan bá nɩg-o.» ");
INSERT INTO xsm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ba dɛɛn na wʋ kɩ ba wʋ-dɩdʋa sɩ ba sɛ-o tɩn mʋ pɛ o wʋ tiini o kɩ wo-kɩnkagɩla ba tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kantʋ maŋa kam nɩ, Galile Pɛ Erɔdɩ dɛɛn ma ba o ni Zezi ŋwa. ");
INSERT INTO xsm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O ma ta dɩ o tɩntʋŋna o wɩ: «Wʋntʋ wʋ́ ta yɩ Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn mʋ. Wʋntʋ mʋ joori o bi o yagɩ tʋʋnɩ. Kʋntʋ ŋwaanɩ mʋ o jɩgɩ dam yɩ o waɩ wo-kɩnkagɩla o kɩa.» ");
INSERT INTO xsm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Erɔdɩ dɛɛn tagɩ kʋntʋ doŋ, bɛŋwaanɩ o dɛɛn ya wʋ kɩ Zan lanyɩranɩ, yɩ o ta pa ba gʋ-o. O dɛɛn di kaanɩ wʋdoŋ mʋ, o yɩrɩ mʋ Erɔdɩadɩ. Kaanɩ wʋm dɛɛn yɩ o zɩmbaarʋ Filipi kaanɩ mʋ. Zan ma ta o brɩ-o o wɩ, kʋ culǝ sɩ o di o zɩmbaarʋ kaanɩ yɩ o ta ŋwɩ. Zan na kaan-o kʋntʋ tɩn, o ma pa ba ja-o ba vɔ ba kɩ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","O ya maa bʋŋɩ sɩ o gʋ-o, yɩ o laan kwarɩ tɩʋ kʋm nɔɔna bam, bɛŋwaanɩ ba dɛɛn nii Zan nɩ o yɩ Wɛ nijoŋnu mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erɔdɩ lʋra maŋa laan ma ba ka yi. O ma bǝŋi nɔɔna zanzan sɩ ba ba ba tɔgɩ ba di candiǝ. Erɔdɩadɩ bukɔ ma zaŋɩ o vu vǝrǝ bam yigǝ o sa o brɩ-ba. O sɛ dɩm na lana kʋntʋ tɩn, kʋ ma pa Erɔdɩ wʋ poli. ");
INSERT INTO xsm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","O wʋ na poli tɩn, o ma ta o du o wɩ, woŋo kʋlʋ maama bukɔ wʋm na lagɩ tɩn, oó pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bukɔ wʋm nu ma ta o brɩ-o, o na wʋ́ loori kʋlʋ tɩn. O laan ma vu Erɔdɩ te o wɩ: «Woŋo kʋlʋ a na lagɩ tɩn, kʋ yɩ Zan yuu mʋ. Nmʋ na goni-kʋ, sɩ n kɩ zʋŋ-tanlaŋa wʋnɩ n pa-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pɛ Erɔdɩ na ni kʋntʋ tɩn, o wʋ ma tiini kʋ cɔgɩ. O nan na tagɩ o du yɩ o vǝrǝ bam ni tɩn, o ma pa ni sɩ ba kɩ kʋntʋ ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","O ma tʋŋɩ nɔɔna sɩ ba vu pɩɩna digǝ kam ba go Zan yuu kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba ma sɩɩnɩ ba go o yuu kʋm ba kɩ zʋŋ-tanlaŋa wʋnɩ ba ja nuŋi ba pa bukɔ wʋm. O laan ma kwe-kʋ o ja vu o pa o nu Erɔdɩadɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zan karabiǝ bam ma zaŋɩ ba vu ba kwe o yɩra yam ba ja vu ba kɩ. Ba laan ma vu ba ta dɩ Zezi kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zezi dɛɛn na ni ba na kɩ Zan te tɩn, o ma zaŋɩ o vu o zʋ naboro o nuŋi jǝgǝ kam kʋntʋ nɩ. O ya lagɩ sɩ o bɛ nɩnɩʋ kʋm ni o vu jǝgǝ kalʋ na yɩ gaa wʋ tɩn o yɩranɩ. Nɔɔna zanzan ma ba ba lwarɩ o na maa ve jǝgǝ kalʋ tɩn. Ba ma zaŋɩ ba nuŋi ba tɩɩnɩ dɩm nɩ, yɩ ba vu tɩga nɩ ba vu o te. ");
INSERT INTO xsm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zezi ma nuŋi naboro kʋm wʋnɩ. O laan ma na nɔn-kɔgɔ kʋm na tu kʋ wʋra. Ba ŋwaŋa ma zʋ-o lanyɩranɩ, yɩ o pa balʋ na ba jɩgɩ yazurǝ tɩn na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tɩga na wʋra ka yi tɩn, o karabiǝ bam laan ma vu ba ta dɩd-o ba wɩ: «Maŋa kam wʋra ka kɛa, yɩ jǝgǝ kalʋ dɩbam na wʋra tɩn yɩ gaa wʋ mʋ. Wʋdiu tǝri yo. Kʋntʋ ŋwaanɩ, pa nɔɔna bam vu sam wʋ ba yǝgi wʋdiu ba di.» ");
INSERT INTO xsm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Zezi ma lǝri-ba o wɩ: «Ba wʋ maŋɩ sɩ ba viiri. Abam tɩtɩ pa-ba wʋdiu sɩ ba di.» ");
INSERT INTO xsm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ba ma ta ba wɩ: «Dɩbam na jɩgɩ kʋlʋ tɩn yɩ dɩpwa yanu dɩ kale sɩle yɩranɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zezi ma ta dɩ ba o wɩ, ba ja ba ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O laan ma ta dɩ nɔɔna bam maama sɩ ba jǝni tɩga nɩ. O ma kwe dɩpwa yanu yam dɩ kale sɩle sɩm, yɩ o kwǝni o yuu wɛɛnɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma fɔ fɔ dɩpwa yam o maŋɩ o pa o karabiǝ bam, yɩ bantʋ dɩ laan joŋi-ya ba pa nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nɔɔna bam maama ma di ba su ba daarɩ. Ba ma pɛ cicwǝǝru tɩlʋ na daarɩ tɩn ba su tɩtwarʋ fugǝ-tɩle. ");
INSERT INTO xsm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nɔɔna balʋ dɛɛn na di kʋntʋ tɩn yɩ nɩnɛɛnɩ baara mʋrr-tɩnu mʋ (5.000), kʋ wǝli dɩ kaana dɩ biǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kʋntʋ kwaga nɩ Zezi ma da o pa o karabiǝ bam vu ba zʋ naboro kʋm, sɩ ba da yigǝ ba bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm. Ba na maa kɛ tɩn, o ma pa kɔgɔ kʋm viiri. ");
INSERT INTO xsm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","O na pɛ ba viiri tɩn, o ma vu o di piu yuu o yɩranɩ sɩ o warɩ Wɛ. Tɩga ma ba ka yi, yɩ o ta wʋra o yɩranɩ ");
INSERT INTO xsm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","dɩ o karabiǝ bam maŋɩ ba ja naboro kʋm ba kɛ nɩnɩʋ kʋm tɩtarɩ yigǝ yigǝ. Vu-dɩʋ ma ba kʋ jeeri-ba, yɩ na-ŋʋm tiini sɩ dana kʋ pa na bam pɔgɩlɩ ba magɩ naboro kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tɩga na wʋra ka pʋʋrɩ tɩn, Zezi laan ma zaŋɩ o ve na bam baŋa nɩ o maa ve o karabiǝ bam te. ");
INSERT INTO xsm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ba na nɛ-o tɩn, fʋʋnɩ ma tiini dɩ ja-ba, dɩ o na wʋ na bam baŋa nɩ o ve tɩn. Ba ma ta ba wɩ: «Kʋʋ́ ta yɩ ciru mʋ!» Fʋʋnɩ na zʋ-ba kʋntʋ tɩn, ba ma kaasɩ baŋa baŋa. ");
INSERT INTO xsm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","O laan ma ŋɔɔnɩ dɩ ba o wɩ: «Pa-na á wʋrʋ kɩ dam, sɩ kʋ yɩ amʋ mʋ. Yɩ pa-na fʋʋnɩ taa jɩgɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pɩyɛɛrɩ ma lǝr-o o wɩ: «A Yuutu, kʋ na sɩɩnɩ kʋ yɩ nmʋ, sɩ n pa-nɩ ni sɩ a dɩ vu na bam baŋa nɩ a ba nmʋ te.» ");
INSERT INTO xsm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Zezi maa wɩ, o ba. Pɩyɛɛrɩ laan ma nuŋi naboro kʋm wʋnɩ o tu na bam baŋa nɩ o ve o maa jeeri Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","O na nɛ viu kʋm na tiini kʋ dana te tɩn, fʋʋnɩ ma zʋ-o, yɩ o laan wʋra o miisi na bam kuri nɩ. O na wʋra o miisi tɩn, o ma loori Zezi dɩ kwǝr-dɩa o wɩ: «A Yuutu, vrɩ a ŋwɩa!» ");
INSERT INTO xsm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Zezi laan ma da o twɩ o jɩŋa o ja-o, yɩ o ta dɩd-o o wɩ: «Bɛɛ mʋ yɩ n ba jɩgɩ wʋ-dɩdʋa dɩ amʋ? Bɛŋwaanɩ mʋ n jɩgɩ bʋbwɛa dɩ amʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba laan ma vu ba zʋ naboro kʋm wʋ. Viu kʋm ma da kʋ zɩgɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɔɔna balʋ na wʋ naboro kʋm wʋnɩ tɩn ma kuni doonǝ ba zuli Zezi, yɩ ba ta ba wɩ: «N sɩɩnɩ n yɩ Baŋa-Wɛ Bu cɩga cɩga.» ");
INSERT INTO xsm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ba ma vu ba bɛ ba yi bubɛ dɩdɩm dɩm. Ba na yi jǝgǝ kalʋ tɩn yɩrɩ mʋ Zenezarɛtɩ. ");
INSERT INTO xsm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tɩʋ kʋm kʋntʋ tiinǝ bam ma ba ba lwarɩ Zezi. Ba na lwar-o tɩn, ba ma tʋŋɩ ni ba pa nawurǝ yam maama, yɩ ba ja balʋ na ba jɩgɩ yazurǝ tɩn ba ba o te, sɩ o pa ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ba ma loor-o sɩ o na sɛ, sɩ o yagɩ sɩ yawɩɩna bam dwe o gɔrɔ kʋm ni má. Balʋ maama na dwe o gɔrɔ kʋm kʋntʋ tɩn dɛɛn sɩɩnɩ ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farizɩan tiinǝ badaara dɩ Wɛ cullu karanyɩna tiinǝ badonnǝ dɛɛn ma nuŋi Zeruzalɛm nɩ ba vu Zezi te, ba ma bwe-o ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Bɛɛ mʋ yɩ n karabiǝ bam yǝni ba cɔgɩ cullu tɩlʋ dɩ́ nabaara bam na pɛ dɩbam tɩn? Ba na lagɩ ba di wʋdiu, ba yǝni ba ba sanɩ ba jɩa sɩ kʋ tɔgɩ dɩ́ cullu tɩm na brɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zezi ma lǝri-ba o wɩ: «Bɛŋwaanɩ mʋ abam yǝni á tɔgɩ á tɩtɩ wʋbʋŋa cullu, yɩ á daarɩ á vɩn Wɛ ni dɩm na brɩ te tɩn? ");
INSERT INTO xsm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wɛ tagɩ DƖ wɩ: ‹Nɔɔnʋ maŋɩ sɩ o taa zuli o nu dɩ o ko.› Wɛ daa ta brɩ nɩ, nɔɔnʋ na ŋɔɔnɩ ta-balɔrɔ dɩ o ko naa o nu, kʋntʋ tu maŋɩ sɩ ba gʋ-o mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kʋ daarɩ abam nan yǝni á ja Wɛ taanɩ dɩm á gugwǝli yɩ á wɩ: ‹Nɔɔnʋ na jɩgɩ woŋo kʋlʋ o ya na wʋ́ ma o zǝni o nu dɩ o ko tɩn, yɩ o na wɩ, woŋo kʋntʋ yɩ Wɛ nyɩm, ");
INSERT INTO xsm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","wʋntʋ daa wʋ maŋɩ sɩ o kwe-kʋ o ma zǝni o ko.› Á na kɩ te tɩn brɩ nɩ á paɩ Wɛ taanɩ dɩm daa ba jɩgɩ kuri dɩ abam, yɩ á daarɩ á tɔgɩ á tɩtɩ cwe mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Abam yɩ pipiri-nyɩna mʋ. Ezayi dɛɛn jɩgɩ bʋra dɩ o na maŋɩ o ta abam taanɩ faŋa faŋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","O dɛɛn tagɩ o wɩ: ‹Nɔɔna bantʋ zuli amʋ Wɛ dɩ ba niǝ mʋ, yɩ ba wʋbʋŋa baŋwɛ dɩ amʋ. ");
INSERT INTO xsm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ba na paɩ amʋ zulǝ yalʋ maama tɩn yɩ kafɛ mʋ. Ba yǝni ba brɩ nabiinǝ wʋbʋŋa cullu, yɩ ba paɩ tɩ yɩ amʋ zaasɩm dɩm mʋ.› » ");
INSERT INTO xsm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zezi laan ma bǝŋi nɔn-kɔgɔ kʋm o pa ba ba o te, yɩ o ta dɩ ba o wɩ: «Cǝgi-na lanyɩranɩ sɩ á ni a taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kʋ daɩ woŋo kʋlʋ na tɔgɩ nɔɔnʋ ni kʋ zʋ o wʋ tɩn mʋ cɔg-o. Kʋ yɩ woŋo kʋlʋ na tɔgɩ nɔɔnʋ ni kʋ nuŋi tɩn mʋ cɔg-o.» ");
INSERT INTO xsm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zezi karabiǝ bam laan ma vu o te, yɩ ba ta dɩd-o ba wɩ: «Nmʋ wʋ lwarɩ nɩ Farizɩan tiinǝ bam wʋrʋ cɔgɩ dɩ nmʋ taanɩ dɩm na?» ");
INSERT INTO xsm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zezi ma lǝri-ba o wɩ: «Á nan yɩ taá nii bantʋ. A Ko Wɛ na wʋ jǝri tiu kʋlʋ maama tɩn maŋɩ sɩ kʋ gɔ kʋ yagɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yǝn-na-ba sɩ bantʋ nyɩ dɩ lilwe vaŋɩna balʋ dɩ na ba naɩ tɩn mʋ. Lilwe nan na lagɩ o vaŋɩ o doŋ, ba maama wʋ́ vu ba tʋ goŋo wʋnɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pɩyɛɛrɩ laan ma ta dɩ Zezi, sɩ o brɩ-ba taanɩ dɩm kuri na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","O ma ta dɩ ba o wɩ: «Abam dɩ ta ba jɩgɩ wʋbʋŋa na? ");
INSERT INTO xsm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Á maŋɩ sɩ á taá ye nɩ, woŋo kʋlʋ maama na yǝni kʋ zʋ nɔɔnʋ ni tɩn mʋ yǝni kʋ tu o kana, yɩ o laan daarɩ o tɔ-kʋ o yagɩ. ");
INSERT INTO xsm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kʋ daarɩ kʋlʋ na nuŋi nɔɔnʋ ni nɩ tɩn yǝni kʋ zɩgɩ o wʋbʋŋa nɩ mʋ kʋ nuŋi. Kʋ nan yɩ wǝǝnu tɩm kʋntʋ mʋ yǝni tɩ cɔgɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nɔɔnʋ wʋbʋŋa mʋ paɩ o lagɩ wo-balwaarʋ kǝm, tɩ na yɩ nɔn-gʋra dɩ boorim wo-zɔɔna dwi maama, dɩ ŋwɩɩnɩ, vwa-fɔra, bɩbara dɩ nɔn-tʋra. ");
INSERT INTO xsm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kʋ nan yɩ wǝǝnu tɩm kʋntʋ mʋ cɔgɩ nɔɔna. Kʋ daarɩ, nɔɔnʋ na di wʋdiu yɩ o wʋ sanɩ o jɩa, kʋntʋ warɩ kʋ cɔg-o.» ");
INSERT INTO xsm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zezi dɛɛn ma zaŋɩ o nuŋi jǝgǝ kam kʋntʋ nɩ, yɩ o vu Tiiri dɩ Sidɔn tɩɩnɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kaanɩ wʋdoŋ maa zʋʋrɩ je sɩm kʋntʋ nɩ, o yɩ dwi-gɛ tu mʋ. O ma vu Zezi te, yɩ o kaasɩ dɩ kwǝr-dɩa o ta dɩd-o o wɩ: «Amʋ tu, Pɛ Davidi dwi tu, popo duri a yibwǝnǝ. Cicirǝ mʋ jɩgɩ a bukɔ, yɩ ka tiini ka jɩg-o ka yaara.» ");
INSERT INTO xsm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Zezi maa cɩm. O karabiǝ bam ma vu o te, ba loor-o sɩ o zǝni kaanɩ wʋm sɩ o viiri, o na tɔgɩ-ba yɩ o kɩ sɔɔ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zezi ma lǝri-ba o wɩ: «Wɛ tʋŋɩ amʋ sɩ a ba a zǝni DƖ tɩtɩ nɔɔna Yisɩrayɛlɩ dwi tiinǝ bam mʋ, bɛŋwaanɩ bantʋ nyɩ dɩ peeni sɩlʋ na je tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kaanɩ wʋm laan ma vu o kuni doonǝ o yigǝ nɩ, yɩ o loor-o o wɩ: «Amʋ tu, zǝni-nɩ!» ");
INSERT INTO xsm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zezi ma lǝr-o o wɩ: «Kʋ wʋ maŋɩ sɩ nɔɔnʋ joŋi o biǝ wʋdiu o dʋlɩ o pa kakuri.» ");
INSERT INTO xsm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kaanɩ wʋm ma lǝri o wɩ: «Amʋ tu, n tagɩ cɩga. Kakuri nan waɩ sɩ twɛ wʋdiu kʋlʋ sɩ tu wʋm na di yɩ kʋ siiri tɩga nɩ tɩn sɩ di.» ");
INSERT INTO xsm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zezi laan ma lǝr-o o wɩ: «Kaanɩ, n cɩga sɩɩnɩ n kɩ n wʋ-dɩdʋa dɩ amʋ. Kʋntʋ tɩn, nmʋ na lagɩ kʋlʋ tɩn, Wɛ wʋ́ kɩ DƖ pa-m.» Maŋa kam kʋntʋ nɩ nɔ́ɔ mʋ o bukɔ wʋm nɛ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zezi laan ma kɛ o vu o tɔgɩ Galile nɩnɩʋ kʋm ni, yɩ o daarɩ o vu o di piu yuu o jǝni da. ");
INSERT INTO xsm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","O na je da kʋntʋ tɩn, kɔ-fɔrɔ maa tui o te, yɩ ba jaanɩ yawɩɩna zanzan ba wǝli da ba tui. Badaara dɛɛn yɩ gwanɩ, badonnǝ maa yɩ lilwǝ dɩ kwaarʋ dɩ mɩmaarʋ, kʋ wǝli dɩ balʋ yawɩɩrʋ dwi dwi na jɩgɩ-ba tɩn. Ba maa jaanɩ-ba ba ve ba tiŋi Zezi yigǝ nɩ, yɩ o pa ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kʋ dɛɛn ma sʋ nɔn-kɔgɔ kʋm dɩ ba na nɛ mɩmaarʋ joori tɩ ŋɔɔna, yɩ gwanɩ dɩ na yazurǝ, yɩ kwaarʋ dɩ waɩ tɩ veǝ, yɩ lilwǝ yiǝ dɩ joori ya naɩ tɩn. Ba na nɛ wo-kɩnkagɩla yam tɩn, kʋ ma pa ba zuli Baŋa-Wɛ dɩlʋ na yɩ Yisɩrayɛlɩ tiinǝ bam Yuutu tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zezi laan ma bǝŋi o karabiǝ bam, yɩ o ta dɩ ba o wɩ: «A jɩgɩ nɔɔna bantʋ ŋwaŋa, dɩ ba na tu ba wʋ a tee nɩ zɩm da yatɔ yɩ ba daa ba jɩgɩ wʋdiu sɩ ba di tɩn. A ba lagɩ sɩ a pa ba viiri yɩ ba wʋ di kʋlʋkʋlʋ. Ba na lagɩ ba viiri kʋntʋ, kana wʋ́ pa ba bǝri cwǝŋǝ nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","O karabiǝ bam ma bwe-o ba wɩ: «Dɩbam wʋ́ kɩ ta mʋ dɩ́ na wʋdiu gaa kʋntʋ wʋnɩ dɩ́ pa kɔ-fɔrɔ kʋntʋ di?» ");
INSERT INTO xsm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O ma bwe-ba o wɩ: «Abam jɩgɩ dɩpwa yagra mʋ?» Ba ma lǝr-o ba wɩ: «Dɩpwa yarpɛ mʋ wʋra, dɩ kalǝŋ-balɛ sɩgratʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Zezi laan ma ta dɩ nɔn-kɔgɔ kʋm sɩ ba maama jǝni tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O ma daarɩ o kwe dɩpwa yarpɛ yam dɩ kale sɩm, yɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma ja-tɩ o fɔ fɔ o pa o karabiǝ bam, yɩ bantʋ dɩ laan joŋi ba pa nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nɔɔna bam maama dɛɛn ma di ba su ba daarɩ. Ba laan ma twɛ cicwǝǝru tɩlʋ na daarɩ tɩn ba su tɩtwarʋ tɩrpɛ. ");
INSERT INTO xsm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nɔɔna balʋ dɛɛn na di kʋntʋ tɩn yi nɩ baara mʋrr-tɩna (4.000), kʋ wǝli dɩ kaana dɩ biǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Zezi laan ma banɩ kɔgɔ kʋm o pa kʋ viiri. O ma daarɩ o vu o zʋ naboro o bɛ o vu o yi tɩʋ kʋdoŋ kʋ yɩrɩ mʋ Magadan. ");
INSERT INTO xsm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farizɩan tiinǝ badaara dɩ Sadusɩan tiinǝ dɛɛn ma zaŋɩ ba vu Zezi te, sɩ ba maŋ-o ba nii. Ba ma ta dɩd-o ba wɩ, o kɩ wo-kɩnkagɩlɩ dɩlʋ na wʋ́ brɩ-ba nɩ o dam dɩm sɩɩnɩ dɩ nuŋi Wɛ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zezi ma lǝri-ba o wɩ: «Kʋ na yɩ dɩdaan-ni nɩ yɩ wɛyuu na yɩ nasʋŋʋ, á yǝni á tɛ á wɩ, tɩga wʋ́ pʋʋrɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kʋ nan na yɩ zɩzɩnzɩŋa yɩ wɛyuu na yɩ liirǝ liirǝ, á yǝni á tɛ á wɩ, dʋa mʋ lagɩ ka nɩ. Abam yǝni á waɩ á nii wɛyuu nɩ á lwarɩ tɩga kam yibiyǝ na wʋ́ ta yɩ te tɩn. Bɛɛ nan mʋ yɩ á warɩ á lwarɩ nɩ wǝǝnu tɩlʋ na wʋra tɩ kɩ lele tɩn brɩ Wɛ na lagɩ DƖ kɩ wo-kamunnu tɩlʋ tɩn? ");
INSERT INTO xsm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Zɩm nɔɔna bam yɩ nɔn-balwaarʋ mʋ, ba yigǝ tǝrǝ dɩ Wɛ, yɩ ba laan lagɩ sɩ a kɩ wo-kɩnkagɩlɩ a brɩ-ba. Ba nan bá na, kʋ na daɩ wo-kɩnkagɩlɩ dɩlʋ na maŋɩ dɩ kɩ dɩ Wɛ nijoŋnu Zonasɩ faŋa faŋa tɩn.» O na tagɩ dɩ ba kʋntʋ tɩn, o laan ma yagɩ-ba yɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Zezi karabiǝ bam dɛɛn na ve ba bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm tɩn, ba ya swe sɩ ba ja dɩpɛ ba wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zezi ma ta dɩ ba o wɩ: «Fɔgɩ-na á cɩ á tɩtɩ sɩ á yɩ pa Farizɩan tiinǝ bam dɩ Sadusɩan tiinǝ bam dɩ abam ba dabɩlɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","O na tagɩ kʋntʋ tɩn, ba ma banɩ daanɩ ba wɩ: «Dɩbam na wʋ jaanɩ dɩpɛ dɩ́ wǝli da tɩn mʋ te o ŋɔɔnɩ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zezi ma lwarɩ ba na jɩgɩ kʋlʋ ba ŋɔɔnɩ tɩn, yɩ o wɩ: «Bɛɛ mʋ yɩ á ŋɔɔnɩ daanɩ á wɩ, á na ba jɩgɩ dɩpɛ tɩn mʋ te a ŋɔɔnɩ kʋntʋ? Bɛɛ nan yɩ á ba kɩ á wʋ-dɩdʋa dɩ Wɛ? ");
INSERT INTO xsm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Abam ta wʋ lwarɩ Wɛ na jɩgɩ dam te tɩn na? Á nan swe nɩ a dɛɛn kwe dɩpwa yanu mʋ a fɔ fɔ a pa baara mʋrr-tɩnu di ba su ba daarɩ na? Á wʋ guli tɩtwarʋ tɩm ni á dɛɛn na twɛ wʋdiu kʋlʋ na daarɩ á kɩ da tɩn na? ");
INSERT INTO xsm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Á nan wʋ guli nɩ a dɛɛn kwe dɩpwa yarpɛ mʋ a pa baara mʋrr-tɩna di ba su ba daarɩ na? Á wʋ guli tɩtwarʋ tɩm ni á dɛɛn na twɛ á su tɩn na? ");
INSERT INTO xsm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bɛɛ mʋ nan yɩ á wʋ lwarɩ nɩ kʋ daɩ dɩpɛ taanɩ mʋ a ya tɛa? Á nan fɔgɩ á cɩ á tɩtɩ, sɩ á yɩ pa Farizɩan tiinǝ bam dɩ Sadusɩan tiinǝ bam dɩ abam ba dabɩlɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","O karabiǝ bam laan ma lwarɩ nɩ, kʋ ya daɩ dabɩlɩ dɩlʋ ba na kɩ dɩpɛ nɩ tɩn taanɩ mʋ o ŋɔɔnɩ dɩ ba. Kʋ nan yɩ sɩ ba yɩ pa Farizɩan tiinǝ dɩ Sadusɩan tiinǝ zaasɩm dɩm mʋ cɔgɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zezi dɛɛn ma vu o yi Sezaarɩ kʋlʋ na yɩ Filipi tɩʋ tɩn. O ma bwe o karabiǝ bam o wɩ: «Nɔɔna yǝni ba tɛ amʋ Nabiin-bu wʋm taanɩ ba wɩ amʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ba ma lǝr-o ba wɩ: «Badaara tɛ ba wɩ, nmʋ yɩ Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn mʋ. Badaara dɩ maa tɛ ba wɩ, nmʋ yɩ Eli mʋ. Badaara dɩ maa tɛ ba wɩ, nmʋ yɩ Zeremi naa faŋa faŋa Wɛ nijoŋnu wʋdoŋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O laan ma bwe-ba o wɩ: «Kʋ nan na yɩ abam, abam bʋŋɩ nɩ amʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simɔn Pɩyɛɛrɩ ma lǝr-o o wɩ: «Nmʋ yɩ Krisi mʋ, Ŋwɩa Tu Baŋa-Wɛ Bu wʋlʋ DƖ na tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zezi ma lǝr-o o wɩ: «Simɔn, Zonasɩ bu, nmʋ yɩ yu-yoŋo tu. Bɛŋwaanɩ, kʋ daɩ nabiinu yiyiu mʋ pɛ n lwarɩ cɩga kam kʋntʋ, kʋ yɩ a Ko Wɛ mʋ pɛ n lwarɩ-ka. ");
INSERT INTO xsm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A nan wʋ́ ta a brɩ-m nɩ nmʋ yɩrɩ mʋ Pɩyɛɛrɩ, kʋ na lagɩ kʋ ta nɩ pulɔrɔ. Pulɔrɔ kʋm kʋntʋ yuu nɩ mʋ a lagɩ a puli a kɔgɔ kʋm kuri da, nɩnɛɛnɩ nɔɔnʋ na cwi sɔŋɔ kuri pulɔrɔ yuu nɩ te tɩn. Yɩ tʋʋnɩ dɩ dɩ dam maama bá wanɩ-kʋ dɩ cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A nan wʋ́ kwe Wɛ paarɩ dɩm borbiǝ a kɩ nmʋ jɩŋa nɩ, sɩ n wanɩ n ma n pʋrɩ cwǝŋǝ n pa nɔɔna taa tɔgɩ da ba zʋʋrɩ Wɛ paarɩ dɩm wʋ. Nɔɔnʋ wʋlʋ maama nmʋ na pɛ ni sɩ o zʋ tɩn, Wɛ wʋ́ zɩgɩ nmʋ kwaga nɩ dɩ kʋntʋ. Wʋlʋ maama nmʋ nan na wɩ o bá zʋ tɩn, Wɛ daa ta wʋ́ zɩgɩ nmʋ kwaga nɩ dɩ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Zezi laan ma kaanɩ o karabiǝ bam, sɩ ba yɩ pa nɔɔn-nɔɔnʋ lwarɩ nɩ wʋm mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kʋ na zɩgɩ kantʋ maŋa kam nɩ tɩn, Zezi ma ŋɔɔnɩ jaja dɩ o karabiǝ bam o wɩ: «A maŋɩ sɩ a vu Zeruzalɛm a na yaara zanzan Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam tee nɩ. Baá gʋ-nɩ, yɩ a laan wʋ́ joori a bi a yagɩ tʋʋnɩ da yatɔ dɛ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Zezi na tagɩ kʋntʋ tɩn, Pɩyɛɛrɩ ma ja-o o nuŋi daa, yɩ o kaan-o o wɩ: «A Yuutu, yɩ ta n tɛ kʋntʋ! Wɛ bá sɛ sɩ kʋntʋ woŋo kɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zezi ma guni o nii Pɩyɛɛrɩ, yɩ o ta dɩd-o o wɩ: «Sʋtaanɩ, ve daa a tee nɩ! Nmʋ lagɩ n pa a tusi mʋ. Nmʋ wʋbʋŋa yam yɩ nabiinǝ nyɩm mʋ, ya ba tɔgɩ Wɛ na lagɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zezi laan ma ta dɩ o karabiǝ bam o wɩ: «Nɔɔnʋ wʋlʋ maama na lagɩ sɩ o taa tɔgɩ amʋ kwaga tɩn, kʋntʋ tu maŋɩ sɩ o vɩn o tɩtɩ wʋbʋŋa, sɩ o sɛ yaara nɩ wʋlʋ na zɩŋɩ tʋʋn-dagara o maa ve o tʋʋnɩ jǝgǝ te tɩn mʋ, sɩ o laan taa tɔgɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wʋlʋ maama nan na lagɩ sɩ o yɩrɩ o ŋwɩa tɩn, kʋntʋ tu wʋ́ ga-ka mʋ. Kʋ daarɩ, wʋlʋ maama na sɛ sɩ o ga o ŋwɩa amʋ ŋwaanɩ tɩn, kʋntʋ tu wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nɔɔnʋ nan na nɛ lʋgʋ baŋa wǝǝnu tɩm maama, yɩ o laan na gɛ ŋwɩa Wɛ tee nɩ, bɛɛ nyɔɔrɩ mʋ o nɛa? Kʋlʋkʋlʋ nan tǝrǝ nɔɔnʋ na wʋ́ wanɩ o ma lǝni o ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amʋ Nabiin-bu wʋm nan wʋ́ ba dɩ paarɩ-zulǝ nɩ a Ko Wɛ na jɩgɩ te tɩn, yɩ DƖ malɛsɩ sɩm dɩ wʋ́ tɔgɩ-nɩ. Kantʋ maŋa kam nɩ, a laan wʋ́ pa nɔɔnʋ maama joŋi ŋwɩɩrʋ tɩlʋ na maŋɩ dɩ o tɩtʋŋa na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔna balʋ zɩm na wʋ yo seeni tɩn badaara bá tɩ, yɩ baá na amʋ Nabiin-bu wʋm na maa bɩɩnɩ dɩ a paarɩ dɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Da yardʋ na kɛ tɩn, Zezi laan ma ja Pɩyɛɛrɩ dɩ Zakɩ dɩ o nyaanɩ Zan, ba tɔgɩ daanɩ ba vu ba di pu-kamunu yuu, ba wʋra ba yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba na wʋra kʋntʋ tɩn, Zezi yibiyǝ ma lǝni ba yigǝ nɩ. O yibiyǝ kam maa nyɩ dɩ wɩa na nyɩɩnɩ te tɩn. O gwaarʋ tɩm ma ji napwǝǝnu nɩ pooni te. ");
INSERT INTO xsm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yɩ ba laan na Moyisi dɩ Eli na wʋ Zezi tee nɩ, yɩ ba ŋɔɔnɩ dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pɩyɛɛrɩ ma ta dɩ Zezi o wɩ: «A Yuutu, dɩ́ na wʋ yo seeni tɩn, kʋ tiini kʋ lana kʋ pa dɩbam. Nmʋ nan na sɛ, sɩ n pa a pu vwǝ yatɔ yo, sɩ nmʋ dɩ Moyisi dɩ Eli taa zʋʋrɩ da.» ");
INSERT INTO xsm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pɩyɛɛrɩ na wʋra o ŋɔɔnɩ kʋntʋ tɩn, kunkwǝǝnu tɩlʋ na nyɩɩnɩ tɩn ma ba tɩ kwǝli-ba. Ba laan ma ni kwǝrǝ na ŋɔɔnɩ tɩ wʋnɩ ka wɩ: «Wʋntʋ mʋ yɩ amʋ bu-dʋa a na soe dɩ a wʋ maama, yɩ o yǝni o pa a jɩgɩ wʋpolo. Á nan taá cǝgi o taanɩ lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Zezi karabiǝ bam na ni kwǝrǝ kam kʋntʋ tɩn, ba ma vi ba yigǝ tɩga nɩ, fʋʋnɩ na tiini dɩ zʋ-ba tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zezi laan ma vu ba te o dwe-ba yɩ o wɩ: «Zaŋɩ-na, sɩ á yɩ pa fʋʋnɩ taa jɩgɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba laan ma kwǝni ba yum wɛɛnɩ, yɩ ba daa wʋ nɛ nɔɔn-nɔɔnʋ, kʋ na daɩ Zezi yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ba ma zaŋɩ piu kʋm yuu nɩ ba maa tuǝ. Zezi laan ma kaanɩ-ba o wɩ: «Yɩ pa-na nɔɔn-nɔɔnʋ lwarɩ á na nɛ kʋlʋ tɩn, sɩ kʋ taa ve maŋa kalʋ amʋ Nabiin-bu wʋm na wʋ́ ba a bi a yagɩ tʋʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","O karabiǝ bam laan ma bwe-o ba wɩ: «Wɛ cullu karanyɩna tiinǝ bam yǝni ba tɛ ba wɩ, Eli mʋ maŋɩ sɩ o da yigǝ o ba, sɩ wʋlʋ Wɛ na tʋŋɩ tɩn laan da kwaga. Kʋ yɩ cɩga naa vwan mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zezi ma lǝri-ba o wɩ: «Kʋ yɩ cɩga mʋ. Eli maŋɩ sɩ o da yigǝ o ba o kwɛ woŋo maama, sɩ wʋlʋ Wɛ na tʋŋɩ tɩn laan ba. ");
INSERT INTO xsm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Á nan taá ye nɩ, Eli maŋɩ o ba yɩ nɔɔna wʋ lwar-o. Ba ma tiini ba bɛɛs-o nɩ ba na lagɩ te tɩn. Kʋ nan na yɩ amʋ Nabiin-bu wʋm, ba daa ta wʋ́ bɛɛsɩ amʋ dɩ kʋntʋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","O karabiǝ bam laan ma lwarɩ nɩ, kʋ yɩ Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn taanɩ mʋ o ŋɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Zezi dɩ o karabiǝ batɔ bam laan ma joori ba vu ba yi nɔn-kɔgɔ kʋm te. Nɔɔnʋ wʋdoŋ ma vu o kuni doonǝ Zezi yigǝ nɩ o ta dɩd-o o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Amʋ tu, duri a bu yibwǝnǝ. O saɩ kɔɔrʋ mʋ yɩ kʋ tiini kʋ cana o yɩra nɩ, yɩ o yǝni o tʋɩ mini dɩ na wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amʋ nan jaan-o a ba nmʋ karabiǝ bam te mʋ, sɩ ba pa o na yazurǝ, yɩ ba wʋ wanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zezi na ni kʋntʋ tɩn, o ma ta o wɩ: «Abam zɩm nɔɔna bam brɩ á ba jɩgɩ wʋ-dɩdʋa dɩ amʋ, yɩ á ba kɩ lanyɩranɩ. Amʋ wʋ́ daanɩ abam tɩtarɩ nɩ sɩ kʋ taa ve maŋa kɔɔ? Amʋ wʋ́ kɩ wʋ-zuru dɩ abam sɩ kʋ taa ve maŋa kɔɔ? Ja-na bu wʋm á ba yo seeni.» ");
INSERT INTO xsm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zezi laan ma bagɩ cicirǝ kalʋ na jɩgɩ bu wʋm tɩn, o pa ka nuŋi ka yag-o. O ma da o na yazurǝ maŋa kam kʋntʋ nɩ nɔ́ɔ. ");
INSERT INTO xsm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nɔn-kɔgɔ kʋm dɛɛn na viiri maama tɩn, Zezi karabiǝ bam laan ma vu o te ba bwe-o ba wɩ: «Bɛɛ mʋ yɩ dɩbam warɩ cicirǝ kam dɩ́ zǝli?» ");
INSERT INTO xsm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","O ma lǝri-ba o wɩ: «Kʋ yɩ abam na ba tiini á jɩgɩ wʋ-dɩdʋa dɩ amʋ tɩn ŋwaanɩ mʋ. A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam na jɩgɩ wʋ-dɩdʋa dɩ amʋ, yɩ kʋ na maŋɩ kʋ yɩ fɩnfɩɩn yɩranɩ nɩ nyasaŋ-bu na yɩ mɩmɩɩnʋ te tɩn, á wʋ́ wanɩ á ta dɩ pu-kamunu kʋntʋ sɩ kʋ zaŋɩ kʋ vu kʋ jǝni je-gɛ, yɩ kʋʋ́ sɩɩnɩ kʋ kɩ. Abam na jɩgɩ wʋ-dɩdʋa dɩ amʋ, kʋlʋkʋlʋ tǝrǝ á na bá wanɩ á kɩ.  ");
INSERT INTO xsm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ciciri sɩntʋ dwi warɩ sɩ zǝli kʋ na daɩ Wɛ-loro dɩ ni-vɔrɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zezi karabiǝ bam dɛɛn ma ba ba wʋ daanɩ Galile nɩ. Zezi ma ta dɩ ba o wɩ: «Baá ja amʋ Nabiin-bu wʋm ba kɩ nɔɔna jɩa nɩ, ");
INSERT INTO xsm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","yɩ ba laan wʋ́ gʋ-nɩ. Da yatɔ dɛ nɩ a nan wʋ́ joori a bi a yagɩ tʋʋnɩ.» O taanɩ dɩm kʋntʋ ma tiini dɩ cɔgɩ ba wʋrʋ. ");
INSERT INTO xsm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ba dɛɛn ma vu ba yi Kapɛrnawum. Nɔɔna balʋ na yǝni ba joŋi lampoo Zwifǝ bam Wɛ-di-kamunu kʋm ŋwaanɩ tɩn ma vu Pɩyɛɛrɩ te, yɩ ba bwe-o ba wɩ: «Abam karanyɩna ba ŋwɩ lampoo na?» ");
INSERT INTO xsm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pɩyɛɛrɩ ma lǝri o wɩ: «O ŋwɩa.» O laan ma joori o vu o zʋ sɔŋɔ kʋlʋ ba na wʋra tɩn. Zezi ma da yigǝ o bwe-o o wɩ: «Simɔn, nmʋ wʋbʋŋa yɩ tɩta mʋ? Lʋgʋ baŋa pwa bam yǝni ba joŋi lampoo nɔɔna bra tee nɩ mʋ? Ba yǝni ba joŋi-kʋ ba tɩtɩ tɩʋ biǝ tee nɩ mʋ naa nɔɔna badonnǝ tee nɩ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pɩyɛɛrɩ ma lǝr-o o wɩ: «Kʋ yɩ nɔɔna badonnǝ tee nɩ mʋ.» Zezi laan ma ta o wɩ: «Kʋ nan brɩ nɩ, dɩ́ na yɩ Wɛ biǝ tɩn, dɩ́ wʋ maŋɩ sɩ dɩ́ ŋwɩ. ");
INSERT INTO xsm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dɩ́ nan ba lagɩ sɩ dɩ́ pa lampo-joŋnǝ bam wʋbʋŋa cɔgɩ. Kʋntʋ ŋwaanɩ, zaŋɩ n vu nɩnɩʋ kʋm ni, sɩ n dɩ gwǝlǝ n ma n ja kalǝŋǝ. Nmʋ na wʋ́ da yigǝ n ja kalǝŋǝ kalʋ tɩn, sɩ n kǝŋi ka ni, sɩ n na sǝbu-dalɩ da. Sǝbu-dalɩ dɩm kʋntʋ wʋ́ wanɩ dɩ yi Wɛ-digǝ kam lampoo kʋm kuni bɩle ŋwɩɩm. N na lɩ-dɩ, sɩ n ja n ba n ma n ŋwɩ n pa amʋ dɩ n tɩtɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kantʋ maŋa kam nɩ Zezi karabiǝ bam ma vu o te, yɩ ba bwe-o ba wɩ: «Wɔɔ mʋ wʋ́ ta yɩ nɔn-kamunu o dwe maama Wɛ paarɩ dɩm wʋnɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zezi laan ma bǝŋi bu-balaŋa o pa o ba o zɩgɩ ba maama tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","O ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam na wʋ lǝni á wʋbʋŋa á ji nɩ bu-balwa te, á bá na cwǝŋǝ sɩ á zʋ Wɛ paarɩ dɩm wʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wʋlʋ na dwe maama Wɛ paarɩ dɩm wʋnɩ tɩn mʋ yɩ wʋlʋ na tu o tɩtɩ o ji nɩnɛɛnɩ bu-balaŋa kantʋ doŋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kʋlʋ na wǝli da tɩn, wʋlʋ maama na nɩgɩ bu wʋntʋ doŋ lanyɩranɩ amʋ yɩrɩ ŋwaanɩ tɩn, kʋntʋ tu nɩgɩ amʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Balʋ na kɩ ba wʋ-dɩdʋa dɩ amʋ tɩn, ba na maŋɩ ba muri nɩ bu-balwa te dɩ, nɔɔnʋ wʋlʋ na pɛ ba dɩdʋa yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn, ba na lǝgi kandwɛ kamunu mʋ kʋntʋ tu ba nɩ ba dɩ-o nɩnɩʋ wʋnɩ yɩ o tɩ, kʋʋ́ ta garɩ cam dɩlʋ o na wʋ́ ba na Wɛ tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kʋ yɩ lɛɛrʋ lʋgʋ baŋa nɩ dɩ nabiinǝ balʋ na ganɩ nɔɔna sɩ ba yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn. Gana yam kʋntʋ warɩ sɩ ya yɩ ba. Kʋ nan na yɩ nɔɔnʋ wʋlʋ maama na ganɩ nɔɔna sɩ ba yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn, lɛɛrʋ wʋ o yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nmʋ jɩŋa naa n naga na wʋ́ pa n yagɩ Wɛ cwǝŋǝ tɔgɩm, kʋ maŋɩ sɩ n go-ka mʋ n yagɩ. N na gɛ n jɩŋa naa n naga, yɩ n daarɩ n na ŋwɩa Wɛ tee nɩ, kʋntʋ garɩ n na jɩgɩ n yɩra yam maama, yɩ ba laan dɩ-m ba yagɩ mini dɩlʋ na bá ti tɩn wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nmʋ yi nan na wʋ́ pa n yagɩ Wɛ cwǝŋǝ tɔgɩm, kʋ maŋɩ sɩ n lɩ-dɩ n dʋlɩ n yagɩ. N na jɩgɩ yi dɩdʋa yɩ n na Wɛ ŋwɩa kam, kʋ garɩ n na jɩgɩ yiǝ yale, yɩ ba laan dɩ-m ba yagɩ mini dɩlʋ na bá dwe tɩn wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Á taá ye sɩ á yɩ gooni wʋlʋ maama na muri amʋ nɔɔna bam wʋnɩ tɩn. Nan lwarɩ-na nɩ, Wɛ malɛsɩ sɩlʋ na nii bantʋ baŋa nɩ tɩn zɩgɩ amʋ Ko Wɛ tee nɩ DƖ sɔŋɔ nɩ mʋ maŋa maama.  ");
INSERT INTO xsm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Amʋ Nabiin-bu wʋm na tu lʋgʋ baŋa tɩn, kʋ yɩ sɩ a beeri balʋ na je tɩn mʋ, sɩ a vrɩ-ba lwarɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kʋntʋ tɩn, nɔɔnʋ na jɩgɩ peeni bi (100), yɩ piǝ dɩdʋa na je, abam bʋŋɩ nɩ oó kɩ ta mʋ? O nan maŋɩ sɩ o yagɩ peeni funʋgʋ nʋgʋ kʋm (99) kaporo nɩ mʋ piu yuu nɩ, sɩ o daarɩ o vu o beeri pi-jiǝ kam. ");
INSERT INTO xsm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A lagɩ a ta cɩga mʋ dɩ abam sɩ, o nan na beeri o na-ka, o laan wʋ́ na wʋpolo zanzan kantʋ ŋwaanɩ kʋ dwǝni peeni sɩlʋ na daarɩ yɩ sɩ wʋ je tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kʋ nan yɩ bɩdwɩ mʋ dɩ abam Ko Wɛ na ba lagɩ sɩ DƖ nɔɔna balʋ na muri tɩn dɩdʋa dɩ je.» ");
INSERT INTO xsm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Nmʋ ko-bu na kɩ-m lwarɩm, sɩ n vu n kaan-o dɩ o na kɩ kʋlʋ tɩn, sɩ kʋ taa yɩ abam yɩranɩ taanɩ, sɩ nɔɔn-nɔɔnʋ ta tɔgɩ o tǝrǝ. O nan na sɛ nmʋ na tagɩ kʋlʋ tɩn, kʋ brɩ nɩ n joori n dɩ-o Wɛ cwǝŋǝ kam wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","O nan na wʋ sɛ sɩ o cǝgi nmʋ taanɩ dɩm, sɩ n lagɩ nɔɔnʋ dɩdʋa naa nɔɔna bale sɩ á tɔgɩ daanɩ á vu o te, sɩ ba bwe-o ba nii, sɩ Wɛ tɔnɔ kʋm tagɩ kʋ wɩ: ‹Nɔɔnʋ na jɩgɩ taanɩ dɩ o doŋ, kʋ maŋɩ sɩ nɔɔna bale naa batɔ mʋ taa yɩ o maana tiinǝ.› ");
INSERT INTO xsm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nɔɔnʋ wʋm nan ta na wʋ sɛ sɩ o cǝgi bantʋ dɩ, sɩ n laan vu n ta dɩ Wɛ-digǝ kɔgɔ kʋm kʋ na yɩ te tɩn. O nan daa ta na wʋ sɛ sɩ o cǝgi á Wɛ-digǝ kɔgɔ kʋm taanɩ dɩm, sɩ n laan ta n nii-o nɩnɛɛnɩ o yɩ nɔn-balɔrɔ kʋlʋ na maŋɩ kʋ yǝri Wɛ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ maama abam na pɛ ni sɩ o zʋ Wɛ kɔgɔ kʋm wʋnɩ tɩn, Wɛ wʋ́ zɩgɩ abam kwaga nɩ dɩ kʋntʋ. Yɩ abam na wɩ o bá zʋ, Wɛ daa ta wʋ́ zɩgɩ abam kwaga nɩ dɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kʋ wǝli da, abam nɔɔna bale na kɩ ni daanɩ lʋgʋ baŋa nɩ, sɩ á loori woŋo kʋlʋ maama amʋ Ko Wɛ tee nɩ, dɩntʋ wʋ́ kɩ DƖ pa abam. ");
INSERT INTO xsm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bɛŋwaanɩ, jǝgǝ kalʋ maama nɔɔna bale naa batɔ na lagɩ daanɩ amʋ yɩrɩ ŋwaanɩ tɩn, amʋ wʋ ba tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pɩyɛɛrɩ laan ma vu Zezi te, yɩ o bwe-o o wɩ: «A Yuutu, amʋ ko-bu na kɩ-nɩ lwarɩm, kuni bɩgra mʋ a maŋɩ sɩ a yagɩ a ma cɛ-o? Kʋ maŋɩ sɩ kʋ yi kuni bɩrpɛ mʋ naa?» ");
INSERT INTO xsm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Zezi ma lǝr-o o wɩ: «Awo, kʋ daɩ kuni bɩrpɛ yɩranɩ, kʋ maŋɩ sɩ kʋ taa yɩ fusɩrpɛ kuni bɩrpɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bɛŋwaanɩ Wɛ paarɩ dɩm nyɩ nɩnɛɛnɩ pɛ wʋdoŋ na lagɩ o jeeli o sǝbu o tɩntʋŋna tee nɩ o nii te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","O na puli sɩ o jeeli-kʋ tɩn, ba laan ma ja o tɩntʋŋnʋ wʋdoŋ na jɩgɩ o jɩnɩ zanzan nɩnɛɛnɩ sǝbu-dala mʋrr-fugǝ te tɩn (10.000) ba ba o te. ");
INSERT INTO xsm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nɔɔnʋ wʋm kʋntʋ maa warɩ o ŋwɩ o jɩnɩ dɩm. Pɛ wʋm laan ma pa ni sɩ ba ja nɔɔnʋ wʋm dɩ o kaanɩ dɩ o biǝ ba yǝgi, kʋ wǝli dɩ o wǝǝnu maama, sɩ ba ma sǝbu kʋm kʋntʋ ba ŋwɩ jɩnɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tɩntʋŋnʋ wʋm na ni kʋntʋ tɩn, o ma vu o kuni doonǝ pɛ wʋm yigǝ nɩ o loor-o o wɩ: ‹Amʋ tu, popo ja n banɩ dɩ amʋ, sɩ amʋ wʋ́ ŋwɩ n jɩnɩ dɩm maama a pa-m.› ");
INSERT INTO xsm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pɛ wʋm ma duri o ŋwaŋa yɩ o yagɩ jɩnɩ dɩm o ma cɛ-o, yɩ o daa wʋ kɩ-o kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nɔɔnʋ wʋm kʋntʋ laan ma nuŋi o vu o jeeri tɩntʋŋnʋ wʋdoŋ na jɩgɩ o jɩnɩ fɩnfɩɩn nɩnɛɛnɩ sǝbu-dalɩ dɩdʋa te tɩn. O laan ma sɔ nɔɔnʋ wʋm ba, yɩ o fɩ-o sɩ o ŋwɩ o jɩnɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nɔɔnʋ wʋm ma kuni doonǝ o doŋ tɩntʋŋnʋ wʋm yigǝ nɩ o loor-o o wɩ: ‹Popo ja n banɩ dɩ amʋ, sɩ amʋ wʋ́ ŋwɩ n jɩnɩ dɩm a pa-m.› ");
INSERT INTO xsm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","O ma wʋ sɛ, yɩ o ja nɔɔnʋ wʋm o vu o kɩ pɩɩna digǝ nɩ, sɩ kʋ vu kʋ yi maŋa kam o na wʋ́ ŋwɩ o jɩnɩ dɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pɛ wʋm tɩntʋŋna badonnǝ na nɛ kʋntʋ tɩn, kʋ ma pa ba wʋrʋ tiini tɩ cɔgɩ. Ba laan ma vu ba ta ba brɩ pɛ wʋm kʋlʋ maama na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pɛ wʋm laan ma bǝŋi o tɩntʋŋnʋ wʋm kʋntʋ o ta dɩd-o o wɩ: ‹Nmʋ yɩ nɔn-balɔrɔ mʋ. Amʋ yagɩ nmʋ jɩ-farɩ dɩm maama mʋ a ma cɛ-m, nmʋ na loori-nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kʋ ya maŋɩ sɩ nmʋ dɩ duri n doŋ wʋm ŋwaŋa, nɩnɛɛnɩ a na duri nmʋ ŋwaŋa te tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pɛ wʋm banɩ ma tiini dɩ zaŋɩ zanzan dɩ o tɩntʋŋnʋ wʋm. O ma kɩ-o o tɩntʋŋna bam jɩŋa nɩ, sɩ ba pa o na cam, sɩ kʋ vu kʋ yi maŋa kalʋ o na wʋ́ ŋwɩ o jɩnɩ dɩm maama tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kʋntʋ tɩn, abam wʋlʋ maama na wʋ yagɩ o ma cɛ o ko-bu dɩ o wʋ maama tɩn, amʋ Ko Wɛ dɩ wʋ́ pa abam na cam kʋntʋ doŋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zezi dɛɛn na brɩ-ba wǝǝnu tɩm kʋntʋ maama o ti tɩn, o laan ma zaŋɩ Galile nɩ o vu o yi Zude tɩ-niǝ yam, Zʋrdɛn bugǝ kam ni dɩdoŋ dɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nɔn-kɔgɔ ma tɔg-o kʋ vu, yɩ o pa ba yawɩɩna na yazurǝ je sɩm kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farizɩan tiinǝ badaara dɛɛn ma zaŋɩ ba vu Zezi te. Ba maa lagɩ sɩ ba maŋ-o ba nii, yɩ ba bwe-o ba wɩ: «Nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o vɩn o kaanɩ, kʋ na maŋɩ kʋ yɩ kʋlʋ maama ŋwaanɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Zezi ma lǝri-ba o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Pulim nɩ, Wɛ na kɩ nabiinǝ tɩn, DƖ kɩ-ba sɩ ba taa yɩ baarʋ dɩ kaanɩ mʋ.› Abam nan ta wʋ karɩmɩ kʋntʋ na? ");
INSERT INTO xsm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kʋntʋ ŋwaanɩ, nɔɔnʋ na di kaanɩ, o maŋɩ sɩ o pɔɔrɩ o tɩtɩ o nu dɩ o ko tee nɩ, sɩ o daarɩ o pa o dɩ o kaanɩ wʋm jǝni daanɩ. Kʋntʋ wʋ́ pa ba laan ji nɔɔnʋ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kʋntʋ tɩn, ba daa daɩ nɔɔna bale, ba laan yɩ nɔɔnʋ dɩdʋa mʋ. Wɛ na kɩ nɔɔna balʋ daanɩ tɩn, nɔɔn-nɔɔnʋ daa wʋ maŋɩ sɩ o pɔɔrɩ-ba daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farizɩan tiinǝ bam daa ma bwe-o ba wɩ: «Bɛɛ nan mʋ yɩ Moyisi dɛɛn pa ni, nɩ nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o pʋpʋnɩ tɔnɔ o pa o kaanɩ, sɩ kʋ brɩ nɩ o vɩ-o?» ");
INSERT INTO xsm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zezi ma lǝri-ba o wɩ: «Abam wʋrʋ na dana tɩn ŋwaanɩ mʋ pɛ Moyisi dɩ sɛ sɩ á vɩn á kaana. Kʋ na zɩgɩ pulim maŋa nɩ tɩn, kʋ ya wʋ maŋɩ sɩ nɔɔna vɩn ba kaana. ");
INSERT INTO xsm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A nan lagɩ a ta abam sɩ, nɔɔnʋ na vɩn o kaanɩ, yɩ kʋ na daɩ nɩ o cɔgɩ dɩ baara, yɩ o daarɩ o di kaanɩ wʋdoŋ, kʋntʋ tu kǝm dɩm yɩ balɔrɔ nɩnɛɛnɩ o na pǝni dɩ o doŋ kaanɩ te tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zezi na tagɩ kʋntʋ tɩn, o karabiǝ bam ma ta dɩd-o ba wɩ: «Kʋ na sɩɩnɩ kʋ yɩ kʋntʋ mʋ baarʋ dɩ o kaanɩ laŋa nɩ, kʋ ya lamma dɩ nɔɔnʋ na maŋɩ o wʋ di kaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","O ma lǝri-ba o wɩ: «Kʋ nan daɩ nɔɔna maama mʋ wʋ́ wanɩ ba ni taanɩ dɩntʋ kuri, kʋ yɩ balʋ yɩranɩ Wɛ na zǝni-ba sɩ ba wanɩ ba joŋi-dɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nɔɔna badaara wʋra ba na ba bʋŋɩ sɩ ba di kaana, bɛŋwaanɩ ba maŋɩ ba lʋ bantʋ bakanɩ mʋ. Badaara dɩ maa wʋra ba na ba bʋŋɩ sɩ ba di kaana, yɩ kʋ yɩ nɔɔna mʋ jaanɩ-ba ba lwɩ. Kʋ daarɩ badaara wʋra ba tɩtɩ na vɩn sɩ ba di kaana, yɩ kʋ yɩ ba na lagɩ sɩ ba tʋŋɩ Wɛ paarɩ dɩm tɩtʋŋa yam tɩn ŋwaanɩ mʋ. Nɔɔnʋ wʋlʋ na wʋ́ wanɩ o ni zaasɩm dɩntʋ kuri tɩn, sɩ o sɛ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɔɔna badonnǝ dɛɛn ma ja bu-balwa ba vu Zezi te, sɩ o daŋɩ o jɩa ba yuu nɩ sɩ o warɩ Wɛ o pa-ba. O karabiǝ bam ma zaŋɩ ba kaanɩ-ba sɩ ba yɩ taa kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zezi laan ma ta dɩ ba o wɩ: «Yagɩ-na sɩ biǝ bam taa tui a te, sɩ á yɩ zaŋɩ á cɩ-ba. Bɛŋwaanɩ balʋ na nyɩ nɩ bu-balwa te tɩn mʋ maŋɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O na tagɩ kʋntʋ tɩn, o laan ma daŋɩ o jɩa ba yuu nɩ o warɩ Wɛ o pa-ba, yɩ o daarɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dɛ dɩdwɩ nɔn-dʋŋʋ kʋdoŋ dɛɛn ma zaŋɩ o vu Zezi te. O ma bwe-o o wɩ: «Karanyɩna, kǝm-laa kɔɔ mʋ a maŋɩ sɩ a kɩ, sɩ a ma na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zezi ma lǝr-o o wɩ: «Kʋ yɩ ta mʋ yɩ n bwe amʋ sɩ n lwarɩ woŋo kʋlʋ na lana tɩn sɩ n kɩ? Wɛ yɩranɩ mʋ lana. Nmʋ na lagɩ sɩ n na ŋwɩa DƖ tee nɩ, kʋ maŋɩ sɩ n ta n tɔgɩ DƖ cullu tɩm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nɔɔnʋ wʋm ma bwe-o o wɩ: «DƖ cullu tɔɔ mʋ kʋntʋ?» Zezi ma lǝr-o o wɩ: «Yɩ zaŋɩ n gʋ nɔɔnʋ. Yɩ zaŋɩ n pǝni dɩ n doŋ kaanɩ. Yɩ zaŋɩ n ŋɔ. Yɩ fɔ vwan n pa n doŋ. ");
INSERT INTO xsm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ta n zuli n nu dɩ n ko. Ta n soe n doŋ nɩ n tɩtɩ te.» ");
INSERT INTO xsm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɔn-dʋŋʋ kʋm laan ma ta o wɩ: «A maŋɩ a tɔgɩ cullu tɩntʋ maama. Kʋ nan ta gɛ bɛɛ mʋ sɩ a kɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zezi ma ta dɩd-o o wɩ: «Nmʋ na lagɩ sɩ n maŋɩ dɩ Wɛ cwǝŋǝ kam fasɩ, kʋ maŋɩ sɩ n kwe kʋlʋ maama n na jɩgɩ tɩn n yǝgi, sɩ n laan ma tɩ sǝbu kʋm n ma n zǝni yinigǝ tiinǝ. Kʋntʋ wʋ́ pa n ta n jɩgɩ jɩjɩgɩrʋ Wɛ-sɔŋɔ nɩ. Nmʋ na kɩ kʋntʋ, sɩ n laan ba n ta n tɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nɔn-dʋŋʋ kʋm na ni kʋntʋ tɩn, kʋ ma pa o wʋ cɔgɩ zanzan, o jɩjɩgɩrʋ tɩm na tiini tɩ daga tɩn ŋwaanɩ. O ma viiri Zezi tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zezi laan ma ta dɩ o karabiǝ bam o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nadum na lagɩ sɩ o zʋ Wɛ paarɩ dɩm wʋnɩ, kʋʋ́ ta tiini kʋ cana kʋ pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A nan ta lagɩ a ta dɩ abam nɩ, kʋʋ́ ta yɩ mwalɩ sɩ yogondi da gar-lwe bɔɔnɩ dɩ nuŋi kʋ dwe nadum na lagɩ sɩ o zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","O karabiǝ bam na ni kʋntʋ tɩn, kʋ ma tiini kʋ sʋ-ba. Ba maa tɛ ba wɩ: «Kʋ nan na yɩ kʋntʋ, wɔɔ mʋ wʋ́ wanɩ o na ŋwɩa Wɛ tee nɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zezi ma nii-ba yɩ o wɩ: «Nabiinǝ mʋ bá wanɩ ba kɩ, sɩ Wɛ waɩ woŋo maama DƖ kɩa.» ");
INSERT INTO xsm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pɩyɛɛrɩ laan ma ta o wɩ: «Nii. Dɩbam yagɩ dɩ́ woŋo maama mʋ, yɩ dɩ́ daarɩ dɩ́ tɔgɩ nmʋ. Bɛɛ mʋ dɩbam lagɩ dɩ́ na Wɛ tee nɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zezi ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam balʋ na tɔgɩ amʋ tɩn wʋ́ ba á tɔgɩ á di paarɩ, maŋa kalʋ Wɛ na wʋ́ kɩ wǝǝnu maama sɩ tɩ taa yɩ nadʋnnʋ tɩn. Maŋa kam kʋntʋ nɩ amʋ Nabiin-bu wʋm wʋ́ ba a jǝni a paarɩ jangɔŋɔ kʋm baŋa nɩ, yɩ abam dɩ wʋ́ jǝni paarɩ jangwaanʋ fugǝ-tɩle baŋa nɩ, sɩ á tɔgɩ á di Yisɩrayɛlɩ dwi tiinǝ kuri fugǝ-bɩle dɩm taanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɔɔnʋ wʋlʋ maama na yagɩ o sɔŋɔ dɩ o nu-biǝ dɩ o nu dɩ o ko dɩ o biǝ dɩ o karɩ amʋ yɩrɩ dɩm ŋwaanɩ tɩn, kʋntʋ tu wʋ́ ba o na kʋlʋ maama o na yagɩ tɩn kuni bi mʋ, yɩ o daarɩ o na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Balʋ na maŋɩ ba yɩ yigǝ tiinǝ tɩn zanzan wʋ́ joori ba ji kwaga tiinǝ. Kʋ daarɩ balʋ dɩ na maŋɩ ba yɩ kwaga tiinǝ tɩn zanzan wʋ́ ba ba ji yigǝ tiinǝ Wɛ paarɩ dɩm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zezi daa ma daarɩ o wɩ: «Wɛ paarɩ dɩm nyɩ dɩ nɔɔnʋ wʋdoŋ na jɩgɩ o kara. O ma zaŋɩ o nuŋi zɩzɩŋa nɩ o vu sɩ o lagɩ nɔɔna balʋ na varɩ ba joŋi sǝbu tɩn, sɩ ba vu ba tʋŋɩ o kara kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O ma sɛ sɩ o ŋwɩ-ba sǝbu kʋlʋ ba na maŋɩ sɩ ba joŋi dɛ wʋnɩ tɩn. Kʋ yɩ sǝbu-dalɩ dɩdʋa mʋ. Ba na ŋɔɔnɩ ba maŋɩ daanɩ kʋntʋ tɩn, o ma tʋŋɩ-ba sɩ ba vu o kara kam ba taa tʋŋa. ");
INSERT INTO xsm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wɩa na bɩgɩ fɩnfɩɩn nɩnɛɛnɩ luu nʋgʋ maŋa nɩ te tɩn, o daa ma vu yaga o na nɔɔna badonnǝ na wʋra, yɩ ba ba jɩgɩ tɩtʋŋa. ");
INSERT INTO xsm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O ma ta dɩ ba o wɩ: ‹Abam dɩ ba á tɔgɩ á tʋŋɩ a kara kam nɩ, sɩ amʋ wʋ́ ŋwɩ abam te na maŋɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ba ma sɛ ba vu. Wɩa tɩtarɩ nɩ o daa ma joori o vu o lagɩ nɔɔna badonnǝ o wǝli da. Wɛ-gunim maŋa nɩ o daa ta ma vu o lagɩ nɔɔna badonnǝ dɩ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dɩdaan-ni nɩ o daa ma vu yaga o na nɔɔna badonnǝ ta na zɩgɩ da. O ma bwe-ba o wɩ: ‹Bɛɛ mʋ yɩ abam zɩgɩ yo seeni dɛ dɩm wʋnɩ maama, yɩ á ba kɩ kʋlʋkʋlʋ?› ");
INSERT INTO xsm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ba ma lǝr-o ba wɩ: ‹Nɔɔn-nɔɔnʋ wʋ kwe dɩbam sɩ dɩ́ tʋŋɩ dɩ́ pa-o.› O ma ta dɩ bantʋ dɩ, sɩ ba vu ba tɔgɩ ba tʋŋɩ o kara kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tɩga na lagɩ ka yi tɩn, o laan ma ta dɩ o tɩtʋŋa yigǝ tu wʋm sɩ o ta dɩ tɩntʋŋna bam, sɩ ba zaŋɩ ba ba ba joŋi ba ŋwɩɩrʋ. O ma ta dɩd-o sɩ o puli o ŋwɩ tɩntʋŋna balʋ na tu ba kweeli tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nɔɔna balʋ na tu ba sɩŋɩ tɩtʋŋa dɩdaan-ni nɩ tɩn ma ba sɩ ba joŋi ba ŋwɩɩrʋ. Ba ma ŋwɩ-ba sǝbu-dalɩ dɩdʋa dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kʋ daarɩ balʋ na puli ba tʋŋɩ tɩtɩɩtɩ tɩn dɩ laan ma ba sɩ ba joŋi ba ŋwɩɩrʋ. Ba maa bʋŋɩ nɩ baá joŋi ŋwɩɩrʋ kʋ dwe bantʋ nyɩm tɩm. Ba dɩ nan joŋi sǝbu-dalɩ dɩdʋa dɩdʋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ba ma joŋi ba sǝbu, yɩ ba daarɩ ba pʋʋna dɩ kara kam tu wʋm ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Balʋ na tu kwaga tɩn tʋŋɩ fɩnfɩɩn yɩranɩ mʋ, nɩnɛɛnɩ luu dɩdʋa te. Dɩbam nan tu dɩ́ tʋŋɩ tɩtɩɩtɩ mʋ, kʋ cɛ dɩ́ yɩra wɩa yigǝ nɩ dɛ dɩm maama wʋnɩ, yɩ nmʋ pa bantʋ ŋwɩʋ maɩ dɩ dɩbam na joŋi te tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kara kam tu wʋm ma lǝri ba dɩdʋa o wɩ: ‹A ciloŋ, nii yo. A wʋ kɩ nmʋ kampinǝ, bɛŋwaanɩ nmʋ sɛ sɩ n tʋŋɩ n joŋi sǝbu-dalɩ dɩdʋa mʋ dɛ wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nan ja n sǝbu kʋm n viiri, sɩ taanɩ tǝrǝ. Amʋ laga, yɩ a ŋwɩ nɔɔnʋ wʋlʋ na tu kwaga o tʋŋɩ tɩn, sɩ kʋ maŋɩ dɩ nmʋ na joŋi te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A nan ba jɩgɩ cwǝŋǝ sɩ a ma a sǝbu kʋm a kɩ kʋlʋ a na lagɩ tɩn na? Nmʋ nan jɩgɩ wʋ-gʋʋ dɩ a na jɩgɩ wʋ-yoŋo tɩn mʋ na?› ");
INSERT INTO xsm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mʋ kʋ kuri, balʋ na wʋ kwaga nɩ tɩn wʋ́ ba ba ji yigǝ tiinǝ, yɩ balʋ na wʋ yigǝ nɩ tɩn wʋ́ joori ba ji kwaga tiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zezi dɩ o karabiǝ dɛɛn ma zaŋɩ ba maa kɛ Zeruzalɛm. Ba na wʋ cwǝŋǝ nɩ tɩn, o ma pɔɔrɩ o karabiǝ fugǝ-bale bam kɔgɔ kʋm wʋnɩ o pa ba tɔgɩ dɩd-o ba veǝ. ");
INSERT INTO xsm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","O ma ta dɩ ba o wɩ: «Taá ye-na, dɩ́ na maa ve Zeruzalɛm tɩn, dáanɩ mʋ ba laan wʋ́ ja amʋ Nabiin-bu wʋm ba kɩ kaanɩm yigǝ tiinǝ bam dɩ cullu karanyɩna tiinǝ bam jɩŋa nɩ. Nɔɔna bam kʋntʋ wʋ́ di a taanɩ sɩ kʋ brɩ nɩ a maŋɩ sɩ a tɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ba laan wʋ́ daarɩ ba kɩ-nɩ dwi-gɛ tiinǝ bam jɩŋa nɩ. Bantʋ dɩ wʋ́ mwanɩ amʋ, yɩ ba daarɩ ba magɩ-nɩ dɩ balaara. Ba laan wʋ́ ja-nɩ ba pa tʋʋn-dagara baŋa nɩ ba gʋ. Da yatɔ dɛ nɩ, a laan wʋ́ joori a bi a yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebede biǝ bam nu dɛɛn ma vu Zezi te dɩ o biǝ bale bam. O ma kuni doonǝ o yigǝ nɩ sɩ o loor-o. ");
INSERT INTO xsm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zezi ma bwe-o o wɩ: «Bɛɛ mʋ n laga?» O ma lǝr-o o wɩ: «Popo, pa ni sɩ n na tu n di n paarɩ dɩm, sɩ n pa a biǝ bale bantʋ jǝni nmʋ tee nɩ, n jazɩm nɩ dɩ n jagwiǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Zezi ma ta dɩ ba o wɩ: «Abam tɩtɩ yǝri á na loori kʋlʋ tɩn. Abam wʋ́ wanɩ á tɔgɩ á yaarɩ nɩ a na lagɩ a ba a na yaara yalʋ tɩn na?» Ba ma lǝr-o ba wɩ: «Ɛɛn, dɩ́ wʋ́ wanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zezi laan ma ta dɩ ba o wɩ: «Abam wʋ́ sɩɩnɩ á tɔgɩ á yaarɩ amʋ yaara yam doŋ. Kʋ daarɩ wʋlʋ na wʋ́ jǝni a jazɩm nɩ naa a jagwiǝ nɩ amʋ paarɩ dɩm wʋnɩ tɩn, a ba jɩgɩ cwǝŋǝ sɩ a kuri nɔɔna sɩ ba jǝni da. A Ko Wɛ mʋ maŋɩ o tiŋi je sɩm kʋntʋ, sɩ o pa balʋ na wʋ́ ba ba jǝni da tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","O karabiǝ fugǝ kam na lwarɩ ba donnǝ bale bam na loori kʋlʋ Zezi tee nɩ tɩn, ba bana ma tiini ya zaŋɩ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zezi laan ma bǝŋi ba maama, yɩ o ta dɩ ba o wɩ: «Abam maŋɩ á ye lʋgʋ baŋa pwa na yǝni ba jɩgɩ ba nɔɔna ba bɛɛsɩ te tɩn, yɩ ba dɩdɛɛra mʋ di dam ba baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kʋ nan na yɩ abam, kʋ wʋ maŋɩ sɩ kʋ taa yɩ kʋntʋ doŋ abam tɩtarɩ nɩ. Bɛŋwaanɩ, abam wʋlʋ na lagɩ sɩ o ji nɔn-kamunu á wʋnɩ tɩn, kʋntʋ tu maŋɩ sɩ o ji abam maama tɩntʋŋnʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wʋlʋ na lagɩ sɩ o ji abam yigǝ tu tɩn, kʋntʋ tu maŋɩ sɩ o ji á gambaa mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kʋ yɩ kʋntʋ doŋ mʋ, amʋ Nabiin-bu wʋm wʋ tu sɩ nɔɔna tʋŋɩ ba pa-nɩ. Amʋ nan tu sɩ a tʋŋɩ a pa nabiinǝ mʋ, sɩ a daarɩ a kwe a ŋwɩa a ma lǝni nɔɔna zanzan ŋwɩa Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zezi dɩ o karabiǝ bam dɛɛn ma nuŋi Zeriko nɩ ba maa kɛa. Ba na maa kɛ tɩn, nɔn-kɔgɔ maa tɔgɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lilwǝ bale dɛɛn ma je cwǝŋǝ kam ni nɩ. Ba na lwarɩ nɩ Zezi mʋ tɔgɩ dáanɩ o maa kɛ tɩn, ba laan ma kaasɩ baŋa baŋa dɩ kwǝr-dɩa ba wɩ: «Dɩ́ Yuutu! Pɛ Davidi dwi tu! Duri dɩbam yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɔn-kɔgɔ kʋm ma kaanɩ-ba sɩ ba pu ba niǝ. Ba laan ma tiini ba kaasɩ ba wɩ: «Dɩbam Yuutu! Pɛ Davidi dwi tu! Duri dɩbam yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zezi na ni kʋntʋ tɩn, o ma zɩgɩ yɩ o bǝŋi-ba o bwe o wɩ: «Abam lagɩ sɩ a kɩ bɛɛ mʋ a pa abam?» ");
INSERT INTO xsm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ba ma lǝri ba wɩ: «Dɩ́ Yuutu, dɩbam lagɩ sɩ n pa dɩ́ yiǝ mʋ joori ya taa naɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Zezi ma duri ba ŋwaŋa. O ma twɩ o jɩŋa o dwe ba yiǝ yam, yɩ ya joori ya naɩ bɩdwɩ baŋa nɩ. Ba laan ma zaŋɩ ba tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zezi dɩ o karabiǝ bam dɛɛn ma vu ba twɛ Zeruzalɛm. Ba ma vu ba yi tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Betifaazɩ. Kʋ wʋ Olivi piu kʋm saŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Zezi laan ma lɩ o karabiǝ bale yɩ o wɩ: «Ve-na á vu á zʋ tɩʋ kʋlʋ na wʋ abam yigǝ nɩ tɩn. Á na yi da, á wʋ́ na bɩnaga na lǝgi da, yɩ bɩna-pɔla dɩ tɔgɩ ka wʋra. Á na nɛa, sɩ á bwǝli-sɩ á ja ba á pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nɔɔnʋ na bwe abam sɩ woŋo, sɩ á ta dɩd-o nɩ, kʋ yɩ dɩ́ Yuutu wʋm mʋ lagɩ-sɩ. Kʋ tu wʋ́ sɛ o yagɩ o pa abam, yɩ á ja á ba.» ");
INSERT INTO xsm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kʋ kɩ kʋntʋ, sɩ kʋ pa Wɛ nijoŋnu wʋdoŋ dɛɛn na tagɩ kʋlʋ faŋa faŋa tɩn mʋ sɩɩnɩ kʋ kɩ. O dɛɛn tagɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ve-na á ta dɩ Siyɔn tiinǝ bam nɩ: ‹Nii-na á pɛ wʋm, o maa bɩɩnɩ á te. Wʋntʋ tu o tɩtɩ mʋ, yɩ o di bɩnaga o maa bɩɩna. Ka yɩ bɩna-pɔla mʋ o diinǝ, yɩ ka nu mɩ zɩla zɩŋɩm.› » ");
INSERT INTO xsm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Zezi karabiǝ bale bam ma sɩɩnɩ ba tɔgɩ yigǝ, ba vu ba kɩ kʋlʋ o na tagɩ sɩ ba kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ba ma ja bɩna-kwɩʋn kʋm dɩ bɩna-pɔla kam ba ba, yɩ ba lɩ ba gwaarʋ ba daŋɩ sɩ baŋa nɩ. Zezi laan ma di bɩna-pɔla kam, yɩ ba ve ba maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ba na maa kɛ tɩn, kɔ-fɔrɔ maa tɔgɩ-ba, yɩ ba zanzan lɩ ba gwaarʋ ba lwarɩ cwǝŋǝ kam yuu nɩ, sɩ Zezi tɔgɩ tɩ baŋa o kɛ. Badaara dɩ ma goni vɔɔrʋ ba dɩ cwǝŋǝ kam yuu nɩ, sɩ o tɔgɩ tɩ baŋa o kɛ. ");
INSERT INTO xsm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɔn-kɔgɔ kʋlʋ na wʋ o yigǝ nɩ dɩ o kwaga nɩ ba ve tɩn maa kaasa, yɩ ba tɛ ba wɩ: «Ozaana! Zulǝ taa wʋ Pɛ Davidi dwi tu wʋm tee nɩ! Zuli-na wʋlʋ na tu dɩ́ Yuutu Wɛ yɩrɩ ŋwaanɩ tɩn. Ozaana! Zulǝ taa wʋ Baŋa-Wɛ tee nɩ!» ");
INSERT INTO xsm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ba dɛɛn ma vu ba maa yi Zeruzalɛm tɩʋ kʋm ni. Tɩʋ kʋm tiinǝ bam maama ma zaŋɩ ba yɩ zulimaa ba sirigi je sɩm maama. Ba maa bwe ba wɩ: «Nɔɔnʋ wɔɔ mʋ tɩntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nɔn-kɔgɔ kʋlʋ na tɔgɩ Zezi tɩn maa tɛ ba wɩ: «Wʋntʋ yɩ Wɛ nijoŋnu Zezi mʋ, o na nuŋi Galile tɩʋ Nazarɛtɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zezi dɛɛn ma vu o zʋ Wɛ-di-kamunu kʋm wʋ. O ma na nɔɔna na wʋ ka kʋnkɔlɔ kʋm nɩ ba pipiǝ. O ma zǝli-ba o pa ba nuŋi. O ma vu o ja sǝbu-lǝnnǝ bam taabʋllʋ tɩm o pipiri o pu tɩga nɩ, o pa ba sǝbiǝ bam jagɩ. O ma daarɩ o yigi yitunnu tɩlʋ nɔɔna badonnǝ na je da ba yǝgi kunkwǝn-pulǝ tɩn o dɩ tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","O na wʋra o zǝli-ba kʋntʋ tɩn, o ma ta dɩ ba o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ, nɩ Wɛ mʋ wɩ: ‹Amʋ digǝ kantʋ maŋɩ sɩ ka taa yɩ jǝgǝ kalʋ nɔɔna na wʋ́ ta tui ba warɩ amʋ da tɩn mʋ.› Abam nan pɛ kʋ ji ŋwɩɩna joro je.» ");
INSERT INTO xsm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lilwǝ dɩ kwaarʋ dɛɛn ma ba Zezi te Wɛ-di-kamunu kʋm wʋnɩ, yɩ o pa ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam ma na wo-kɩnkagɩla yalʋ o na kɩ tɩn, yɩ ba daarɩ ba na biǝ na zɩgɩ Wɛ-digǝ kam kʋnkɔlɔ kʋm nɩ ba kaasɩ ba wɩ: «Ozaana! Zulǝ taa wʋ Pɛ Davidi dwi tu wʋm tee nɩ!» Ba na nɛ kʋntʋ tɩn, ba bana ma zaŋɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ba ma ta dɩ Zezi ba wɩ: «Nmʋ ba ni biǝ bam na tɛ nmʋ taanɩ te? N bá cɩ-ba sɩ ba yɩ taa tɛ kʋntʋ na?» Zezi ma lǝri-ba o wɩ: «A ye ba na tɛ kʋlʋ tɩn. Kʋ nan pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Nmʋ Wɛ mʋ pɛ biǝ dɩ bu-sɩsɩn zuli nmʋ dɩ ba niǝ.› Abam maŋɩ á wʋ karɩmɩ kʋntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","O laan ma zaŋɩ ba tee nɩ o viiri. O ma nuŋi tɩʋ kʋm nɩ o vu Betani, yɩ o pǝni dáanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tɩga na pʋʋrɩ tɩtɩɩtɩ tɩn, o ma zaŋɩ sɩ o joori o vu Zeruzalɛm. O na wʋ cwǝŋǝ nɩ tɩn, o kana maa wɔɛ. ");
INSERT INTO xsm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O ma na kapʋrʋ na zɩgɩ cwǝŋǝ kam daa nɩ. O ma vu sɩ o nii, yɩ o piini dɩ vɔɔrʋ yɩranɩ mʋ wʋra, yɩ mɔɔla tǝrǝ sɩ o di. O ma ta dɩ kapʋrʋ kʋm o wɩ: «N daa n bá joori n lǝ biǝ maŋa dɩ maŋa.» O na tagɩ kʋntʋ tɩn, kapʋrʋ kʋm ma da kʋ kwaarɩ bɩdwɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zezi karabiǝ bam na nɛ kʋntʋ tɩn, kʋ ma sʋ-ba. Ba ma bwɛ ba wɩ: «Kʋ kɩ ta mʋ yɩ kapʋrʋ kʋm da kʋ kwaarɩ lɩla kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zezi ma lǝri-ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, á na kɩ á wʋ-dɩdʋa dɩ amʋ yɩ á ba jɩgɩ bʋbwɛa, abam dɩ wʋ́ wanɩ á kɩ kʋlʋ na kɩ kapʋrʋ kʋm tɩn doŋ. Kʋ nan daɩ kʋntʋ yɩranɩ má. Á wʋ́ wanɩ á ta dɩ pu-kamunu kʋntʋ nɩ, kʋ gɔ kʋ na wʋ mɛ tɩn kʋ vu kʋ tʋ nɩnɩʋ kʋm wʋnɩ, yɩ Wɛ nan wʋ́ pa kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kʋlʋ na wǝli da tɩn, abam na loori woŋo kʋlʋ maama Wɛ tee nɩ, yɩ á na kɩ wʋ-dɩdʋa nɩ á wʋ́ na, Wɛ wʋ́ pa á sɩɩnɩ á na-kʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zezi dɛɛn ma joori o vu o zʋ Wɛ-di-kamunu kʋm wʋ. O maa wʋra o brɩ nɔɔna bam. Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam ma vu o te ba bwe-o ba wɩ: «Wɔɔ dam mʋ n ma n kɩ wǝǝnu tɩlʋ maama n na kɩ tɩn? Wɔɔ mʋ pɛ nmʋ ni sɩ n ta n kɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","O ma lǝri-ba o wɩ: «A dɩ jɩgɩ bwiǝ a lagɩ a bwe abam. Á na lǝri á pa-nɩ, sɩ a laan brɩ abam wʋlʋ na pɛ amʋ ni sɩ a tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A lagɩ a bwe abam a nii, Zan na miisi nɔɔna na wʋnɩ tɩn, kʋ yɩ Wɛ mʋ pɛ-o cwǝŋǝ naa nabiinǝ mʋ?» O na bwe-ba kʋntʋ tɩn, ba maa wʋra ba bwɛ daanɩ sɩ ba nii, ba na wʋ́ lǝr-o te tɩn. Ba maa wɩ: «Dɩbam na lǝri dɩ́ wɩ, kʋ yɩ Wɛ mʋ, o laan wʋ́ bwe dɩbam o nii, bɛɛ mʋ yɩ dɩ́ nan wʋ sɛ Zan taanɩ dɩm? ");
INSERT INTO xsm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kʋ daarɩ, dɩ́ na wɩ kʋ yɩ nabiinǝ mʋ pɛ-o cwǝŋǝ, nɔn-kɔgɔ kʋm wʋ́ ja dɩ dɩbam, dɩ ba maama na paɩ Zan yɩ Wɛ nijoŋnu tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ba na banɩ daanɩ ba ga kʋlʋ ba na wʋ́ ta tɩn, ba ma lǝri Zezi ba wɩ: «Dɩ́ yǝri wʋlʋ na pɛ Zan cwǝŋǝ tɩn.» Zezi dɩ ma ta dɩ ba o wɩ: «Kʋ na yɩ kʋntʋ, amʋ dɩ nan bá ta wʋlʋ na pɛ amʋ ni sɩ a taa tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zezi laan ma ta o wɩ: «A lagɩ a maŋɩ mɩmaŋɩ dɩdoŋ a brɩ abam, sɩ á bʋŋɩ á nii. Nɔɔnʋ mʋ wʋra dɩ o biǝ bale. O ma ta dɩ bu-kwɩan kam o wɩ: ‹Ve n tʋŋɩ a kara nɩ zɩm dɛ dɩm nɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bu wʋm ma lǝr-o o wɩ: ‹A bá vu.› Kʋ na kɩ fɩɩn tɩn, o ma joori o lǝni o wʋbʋŋa yɩ o vu o tʋŋɩ. ");
INSERT INTO xsm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nɔɔnʋ wʋm daa ma ta dɩ o bu wʋdoŋ wʋm sɩ o dɩ vu o kara kam o tʋŋɩ. Wʋntʋ ma lǝri o wɩ: ‹A ko, aá vu.› Yɩ o laan daarɩ o wʋ ve. ");
INSERT INTO xsm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kʋntʋ tɩn, biǝ bam kʋntʋ bale wʋnɩ, wɔɔ mʋ sɩɩnɩ o kɩ ba ko wʋm na lagɩ kʋlʋ tɩn?» Ba ma lǝr-o ba wɩ: «Kʋ yɩ bu nakwɩ wʋm mʋ.» Ba na lǝri kʋntʋ tɩn, Zezi laan ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔn-cɩcɔgɩrʋ, kʋ na yɩ lampo-joŋnǝ dɩ ka-bwǝǝru, wʋ́ zʋ Wɛ paarɩ dɩm wʋnɩ ba daarɩ abam. ");
INSERT INTO xsm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bɛŋwaanɩ, Zan na tu abam te tɩn, o dɛɛn brɩ abam cwǝŋǝ kalʋ á na wʋ́ da sɩ á na cɩga Wɛ tee nɩ tɩn, yɩ á wʋ sɛ o taanɩ dɩm. Nɔn-cɩcɔgɩrʋ tɩm nan sɛ-o yɩ tɩ lǝni tɩ wʋrʋ tɩ yagɩ kǝm-balwaarʋ tɩm. Abam nan nɛ bantʋ na kɩ te tɩn, yɩ á daa ta wʋ sɛ sɩ á lǝni á wʋbʋŋa sɩ á sɛ o taanɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zezi daa ma ta dɩ ba o wɩ: «Cǝgi-na, sɩ a daa maŋɩ mɩmaŋɩ dɩdoŋ a brɩ abam. Sɔŋɔ tu wʋdoŋ mʋ wʋra. O ma zaŋɩ o cɩ gaarɩ, yɩ o daarɩ o jǝri tweeru tɩlʋ yɩrɩ na yɩ vinyǝ tɩn dɩ wʋnɩ. O ma daarɩ o kʋ goŋo tɩ-dɩa je nɩ, sɩ o na gwǝri tweeru tɩm biǝ bam, sɩ o kɩ dáanɩ o nɔ o ka tɩ na bam. O ma daarɩ o cwi dapala sɩ nɔɔnʋ taa je da o yɩrɩ gaarɩ dɩm. O na fɔgɩ o cɩ-dɩ kʋntʋ tɩn, o laan ma kwe nɔɔna o yagɩ da sɩ ba taa tʋŋa, yɩ o daarɩ o beeri o vu tɩʋ kʋdoŋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kʋ na yi tweeru tɩm biǝ bam gwǝrim maŋa tɩn, o ma tʋŋɩ o tɩntʋŋna, sɩ ba vu nɔɔna balʋ na nii o gaarɩ dɩm baŋa nɩ tɩn te, sɩ ba joŋi tweeru tɩm biǝ bam ba ja ba ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","O tɩntʋŋna bam na tu tɩn, nɔɔna bam ma ja-ba, ba magɩ dɩdʋa lanyɩranɩ, ba gʋ wʋdoŋ, yɩ ba daarɩ ba dʋlɩ dɩdʋa dɩ kandwa ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Gaarɩ dɩm tu wʋm ta ma joori o tʋŋɩ o tɩntʋŋna badonnǝ nɔɔna bam tee nɩ. Bantʋ kɔgɔ dwe dayigǝ nɔɔna bam. Nɔɔna bam daa ta ma kɩ bantʋ dɩ kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kʋ kweelim nɩ tɩn, o laan ma tʋŋɩ o tɩtɩ bu nɔɔna bam tee nɩ, yɩ o bʋŋɩ nɩ, baá nɩgɩ wʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","O bu wʋm na maa ve yɩ nɔɔna bam na-o tɩn, ba maa ŋɔɔnɩ daanɩ ba wɩ: ‹Mʋ gaarɩ dɩm tu bu, wʋntʋ mʋ lagɩ o ba o taa te o ko wʋm wǝǝnu tɩm. Nan pa-na dɩ́ gʋ-o, sɩ dɩ́ daarɩ dɩ́ taa te o wǝǝnu tɩm.› ");
INSERT INTO xsm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba laan ma ja-o ba vaŋɩ ba ja nuŋi gaarɩ dɩm wʋnɩ, ba mag-o ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kʋntʋ tɩn, gaarɩ dɩm tu wʋm laan na tuǝ, oó kɩ nɔɔna bam kʋntʋ tɩta mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Zezi na bwe-ba kʋntʋ tɩn, ba laan ma lǝri ba wɩ: «O maŋɩ sɩ o gʋ nɔn-balwaarʋ tɩm kʋntʋ mʋ, sɩ o daarɩ o kwe gaarɩ dɩm o pa nɔɔna badonnǝ sɩ ba taa nii-dɩ, sɩ tweeru tɩm biǝ bam gwǝrim maŋa na yiǝ, sɩ ba taa pa-o o tweeru tɩm biǝ bam.» ");
INSERT INTO xsm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Zezi daa ma ta dɩ ba o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kandwɛ dɩlʋ lwara na vɩn tɩn laan mʋ joori dɩ ba dɩ ji kandwɛ dɩlʋ na paɩ sɔŋɔ kʋm dana tɩn. Kʋntʋ yɩ Baŋa-Wɛ mʋ kɩa, yɩ kʋ yɩ wo-kamunu kʋ pa dɩbam.› Abam maŋɩ á wʋ karɩmɩ kʋntʋ na? ");
INSERT INTO xsm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kʋ brɩ nɩ Wɛ laan wʋ́ joŋi DƖ paarɩ dɩm abam tee nɩ, yɩ DƖ daarɩ DƖ pa balʋ na sɛ DƖ ni tɩn na cwǝŋǝ ba zʋ DƖ paarɩ dɩm wʋ.  ");
INSERT INTO xsm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kʋ na yɩ kandwɛ dɩlʋ Wɛ na kuri tɩn, nɔɔnʋ wʋlʋ maama na tʋ dɩntʋ baŋa nɩ tɩn, kʋntʋ tu wʋ́ tiini o cʋcʋgɩ o tɩtɩ mʋ. Kʋ daarɩ, wʋlʋ maama kandwɛ dɩm na tʋ o baŋa nɩ tɩn, dɩ wʋ́ mɩɩrɩ kʋntʋ tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Zezi dɛɛn na maŋɩ mɩmaŋa yam kʋntʋ maama tɩn, kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam ma lwarɩ nɩ kʋ yɩ bantʋ taanɩ mʋ o tɛa. ");
INSERT INTO xsm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ba maa kwaanɩ ba lagɩ cwǝŋǝ sɩ ba ja-o, yɩ ba kwarɩ fʋʋnɩ dɩ nɔn-kɔgɔ kʋm, bantʋ na pɛ o yɩ Wɛ nijoŋnu tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zezi dɛɛn ma maŋɩ mɩmaŋɩ dɩdoŋ o brɩ nɔɔna bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Wɛ paarɩ dɩm nyɩ dɩ pɛ wʋdoŋ na lagɩ sɩ o kɩ kadiri candiǝ o pa o bu te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pɛ wʋm ya tagɩ dɩ nɔɔna badonnǝ mʋ sɩ ba ba ba tɔgɩ ba di kadiri candiǝ kam. Dɛ dɩm na tu dɩ yi tɩn, o ma tʋŋɩ o tɩntʋŋna sɩ ba vu ba bǝŋi nɔɔna bam kʋntʋ sɩ ba ba. Ba ma wʋ sɛ sɩ ba ba. ");
INSERT INTO xsm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O laan ma joori o tʋŋɩ o tɩntʋŋna badonnǝ, sɩ ba vu nɔɔna bam te ba ta dɩ ba nɩ: ‹Ba-na, sɩ amʋ ti woŋo maama yɩ a pa ba gʋ na-paala dɩ varɩ-nunuguru. Nan ba-na sɩ dɩ́ di candiǝ kam.› ");
INSERT INTO xsm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nɔɔna balʋ ba na bǝŋi kʋntʋ tɩn ma zaŋɩ ba vu ba wʋbʋŋa je, ba na ba nɩgɩ o beeri dɩm tɩn ŋwaanɩ. Ba dɩdʋa ve o kara mʋ. Dɩdʋa ma vu sɩ o kɩ o pipiu. ");
INSERT INTO xsm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nɔɔna balʋ na daarɩ tɩn ma ja pɛ wʋm tɩntʋŋna bam, ba bɛɛsɩ-ba ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pɛ wʋm banɩ ma tiini dɩ zaŋɩ. O ma tʋŋɩ o pamaŋna sɩ ba vu ba gʋ nɔn-gʋra bam kʋntʋ, sɩ ba daarɩ ba zwɛ ba tɩʋ kʋm maama. ");
INSERT INTO xsm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","O laan ma ta dɩ o tɩntʋŋna bam o wɩ: ‹Kadiri dɩm woŋo maama ti kʋ yigǝ sɩ dɩ́ di. A nan na bǝŋi balʋ sɩ dɩ́ di candiǝ kam tɩn ya wʋ maŋɩ dɩ ka. ");
INSERT INTO xsm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nan nuŋi-na á vu tɩʋ kʋm je sɩm maama nɩ, á nii cwe sɩm niǝ nɩ. Á na nɛ nɔɔnʋ wʋlʋ maama tɩn, sɩ á bǝŋ-o sɩ o ba o tɔgɩ o di.› ");
INSERT INTO xsm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","O tɩntʋŋna bam ma nuŋi ba beeri tɩʋ kʋm maama, ba la nɔɔna balʋ maama ba na nɛ tɩn, kʋ na yɩ nɔn-ŋʋna dɩ nɔn-balwaarʋ dɩ. Pɛ wʋm sɔŋɔ kʋm ma tiini kʋ su dɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pɛ wʋm laan ma nuŋi sɩ o zaanɩ nɔɔna bam. O ma na nɔɔnʋ dɩdʋa na wʋra o na wʋ zʋ gwar-ŋʋŋʋ kʋlʋ na maŋɩ dɩ kadiri dim tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pɛ wʋm ma bwe-o o wɩ: ‹A ciloŋ, nmʋ kɩ ta mʋ n tɔgɩ n zʋ yo seeni, yɩ nmʋ wʋ zʋ gɔrɔ kʋlʋ na lana tɩn?› Nɔɔnʋ wʋm ma ga ka lǝrǝ je. ");
INSERT INTO xsm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pɛ wʋm laan ma ta dɩ o tɩntʋŋna bam o wɩ: ‹Ja-na nɔɔnʋ wʋntʋ á vɔ o jɩa dɩ o nɛ, sɩ á ja-o á nuŋi á dɩ lim wʋnɩ, yaara na wʋ mɛ yɩ nɔɔna keerǝ yɩ ba dʋnɩ ba nwa tɩn.› ");
INSERT INTO xsm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kʋntʋ brɩ nɩ, Wɛ bǝŋi nɔɔna zanzan mʋ, yɩ DƖ daarɩ DƖ kuri ba fɩnfɩɩn yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farizɩan tiinǝ bam laan ma zaŋɩ ba vu sɩ ba banɩ ba nii, ba na wʋ́ kɩ te ba pa Zezi ŋɔɔnɩ o tusi sɩ ba ja-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ba ma lɩ ba karabiǝ badonnǝ, sɩ ba tɔgɩ dɩ Pɛ Erɔdɩ kwaga nɔɔna badonnǝ ba vu Zezi te. Ba ma vu ba ta dɩd-o ba wɩ: «Karanyɩna, dɩbam ye nɩ nmʋ yɩ cɩga tu mʋ, yɩ n yǝni n brɩ nɔɔna Wɛ cwǝŋǝ kam cɩga. Nmʋ yigǝ tǝrǝ dɩ nɔɔna na bʋŋɩ kʋlʋ ba pa nmʋ tɩn, nmʋ nan ba kuri nɔɔna daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dɩ́ nan lagɩ sɩ dɩ́ bwe nmʋ dɩ́ nii, nmʋ wʋbʋŋa yɩ tɩta mʋ? Dɩbam Zwifǝ bam cullu pɛ ni sɩ dɩ́ ŋwɩ lampoo dɩ́ pa lʋgʋ kʋm pa-farʋ wʋm na? Mʋ na kʋ wʋ maŋɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Zezi na lwarɩ ba na jɩgɩ wʋbʋŋ-balwaarʋ tɩlʋ tɩn, o ma lǝri-ba o wɩ: «Abam yɩ pipiri-nyɩna mʋ. Bɛɛ nan mʋ yɩ á lagɩ sɩ á maŋɩ-nɩ á nii? ");
INSERT INTO xsm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nan brɩ-na-nɩ sǝbu-dalɩ dɩlʋ dɩ́ na yǝni dɩ́ ma ŋwɩ lampoo tɩn.» Ba ma lɩ sǝbu-dalɩ dɩm ba brɩ-o. ");
INSERT INTO xsm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O ma bwe-ba o wɩ: «Wɔɔ nyɩnyʋgʋ dɩ o yɩrɩ mʋ pʋpʋnɩ dɩ baŋa nɩ?» ");
INSERT INTO xsm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ba ma lǝr-o ba wɩ: «Kʋ yɩ pa-farʋ wʋm mʋ.» O laan ma ta dɩ ba o wɩ: «Kʋ lamma. Nan taá ŋwɩ-na kʋlʋ na yɩ pa-farʋ wʋm nyɩm tɩn á pa-o, sɩ á daarɩ á taá paɩ Wɛ kʋlʋ dɩ na yɩ DƖ nyɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","O na lǝri-ba kʋntʋ tɩn, kʋ ma sʋ-ba zanzan. Ba laan ma yag-o yɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dɛ dɩm kʋntʋ nɩ, Sadusɩan tiinǝ badonnǝ dɛɛn ma zaŋɩ ba vu Zezi te. Bantʋ mʋ brɩ nɩ, nɔɔnʋ na tɩga o daa bá joori o bi tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ba ma vu ba ta dɩ Zezi ba wɩ: «Karanyɩna, Moyisi dɛɛn brɩ nɩ, nɔɔnʋ na tɩga, yɩ o dɩ o kaanɩ na ba jɩgɩ biǝ daanɩ, o nu-bu mʋ maŋɩ sɩ o di kadǝm wʋm sɩ ba lʋ biǝ o cʋrʋ kʋlʋ na tɩgɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kʋntʋ, nu-pugǝ-biǝ barpɛ mʋ ya wʋ dɩbam tɩtarɩ nɩ. Ba dɩdʋa ma di kaanɩ yɩ o tɩ o daar-o, yɩ o wʋ lʋgɩ bu dɩd-o. Wʋlʋ na saŋɩ tɩn dɩ daa ma lǝri o di kaanɩ wʋm. ");
INSERT INTO xsm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","O dɩ ma tɩ o daar-o. Batɔ tu wʋm dɩ daa ma di-o. Kʋ kɩ kʋntʋ doŋ mʋ dɩ ba maama barpɛ, yɩ ba wʋ lʋgɩ bu dɩ kaanɩ wʋm. ");
INSERT INTO xsm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ba maama na tɩgɩ tɩn, kaanɩ wʋm dɩ laan ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dɩ́ nan lagɩ dɩ́ bwe dɩ́ nii, ba maama na di kaanɩ wʋm tɩn, ba laan na tu ba bi ba yagɩ tʋʋnɩ, bantʋ wɔɔ mʋ wʋ́ ta te kaanɩ wʋm?» ");
INSERT INTO xsm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zezi ma lǝri-ba o wɩ: «Abam tiini á tusi mʋ. Abam nan wʋ ni Wɛ tɔnɔ kʋm zaasɩm dɩm kuri dɩ, yɩ á yǝri Wɛ dam dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bɛŋwaanɩ, nɔɔna na tu ba bi ba yagɩ tʋʋnɩ, baá ta nyɩ dɩ Wɛ malɛsɩ sɩm na yɩ te tɩn mʋ, baara daa bá di kaana, kaana dɩ nan daa bá zʋ banna dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kʋ nan na yɩ twa biim dɩm dɩ, abam maŋɩ á wʋ karɩmɩ kʋlʋ Wɛ na tagɩ DƖ brɩ abam yɩ kʋ pʋpʋnɩ DƖ tɔnɔ kʋm wʋnɩ tɩn na? ");
INSERT INTO xsm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","DƖ tagɩ DƖ wɩ: ‹Amʋ yɩ Abraham Wɛ, dɩ Yizakɩ Wɛ, dɩ Zakɔbɩ Wɛ mʋ.› Kʋ brɩ nɩ bantʋ daa ta jɩgɩ ŋwɩa mʋ DƖ tee nɩ, bɛŋwaanɩ Baŋa-Wɛ yɩ naŋʋna Wɛ mʋ sɩ DƖ daɩ twa Wɛ.» ");
INSERT INTO xsm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nɔn-kɔgɔ kʋm na ni Zezi zaasɩm dɩm na yɩ te tɩn, kʋ ma tiini kʋ sʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farizɩan tiinǝ bam dɛɛn ma lwarɩ Zezi na lǝri Sadusɩan tiinǝ bam te tɩn, kʋ pa ba daa warɩ taanɩ ba ta. Ba laan ma kikili daanɩ sɩ ba lagɩ cwǝŋǝ ba ma ja-o. ");
INSERT INTO xsm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ba wʋ dɩdʋa na yɩ Wɛ cullu tɩm karanyɩna tɩn ma zaŋɩ sɩ o maŋ-o o nii o swan na yɩ te tɩn, o ma bwe-o o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Karanyɩna, Wɛ niǝ yam maama wʋnɩ dɔɔ mʋ yɩ kamunu dɩ dwe?» ");
INSERT INTO xsm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zezi ma lǝr-o o wɩ: «Ta n soe n Yuutu Baŋa-Wɛ dɩ n bɩcarɩ maama, dɩ n wʋ maama, dɩ n wʋbʋŋa maama. ");
INSERT INTO xsm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dɩntʋ nan mʋ yɩ Wɛ dayigǝ ni yɩ dɩ yɩ kamunu. ");
INSERT INTO xsm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dɩlʋ na saŋɩ tɩn dɩ nyɩ dɩ dɩntʋ mʋ, dɩ tagɩ dɩ wɩ, ta n soe n doŋ nɩ n tɩtɩ te. ");
INSERT INTO xsm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moyisi zaasɩm dɩm dɩ faŋa faŋa Wɛ nijoŋnǝ bam zaasɩm dɩm maama yɔɔrɩ dɩ puli niǝ yantʋ yale baŋa nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farizɩan tiinǝ badonnǝ dɛɛn ma ba ba kikili daanɩ. Zezi ma zaŋɩ o bwe-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kʋ na yɩ Krisi wʋm Wɛ na lagɩ DƖ tʋŋɩ tɩn, abam bʋŋɩ nɩ oó ta yɩ wɔɔ dwi tu mʋ?» Ba ma lǝr-o ba wɩ: «Oó ta yɩ Pɛ Davidi dwi tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zezi laan ma ta dɩ ba o wɩ: «Kʋ nan wʋ́ kɩ ta mʋ kʋ taa yɩ kʋntʋ? Wɛ Joro kʋm dɛɛn pɛ Davidi ŋɔɔnɩ o woŋo, yɩ o bǝŋ-o nɩ o Yuutu. Faŋa faŋa tɩn Davidi tagɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Yuutu Baŋa-Wɛ tagɩ dɩ a Yuutu DƖ wɩ: Ba n jǝni a jazɩm nɩ, sɩ aá kɩ nmʋ dʋna maama n nɛ kuri nɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davidi nan na sɩɩnɩ o bǝŋi Krisi wʋm o wɩ o Yuutu tɩn, o nan daa wʋ́ kɩ ta mʋ o taa yɩ Davidi naa daga?» ");
INSERT INTO xsm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Zezi na tagɩ kʋntʋ tɩn, nɔɔn-nɔɔnʋ daa maa warɩ sɩ o lǝri kʋlʋkʋlʋ. Kʋ na zɩgɩ dɛ dɩm kʋntʋ nɩ tɩn, nɔɔna bam maama maa kwarɩ sɩ ba daa bwe-o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Zezi laan ma ŋɔɔnɩ dɩ o karabiǝ bam dɩ nɔn-kɔgɔ kʋm maama. ");
INSERT INTO xsm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","O ma ta dɩ ba o wɩ: «Kʋ na yɩ Farizɩan tiinǝ bam dɩ Wɛ cullu karanyɩna tiinǝ bam, bantʋ mʋ tu ba lǝni Moyisi yuu nɩ, sɩ ba pa nɔɔna lwarɩ o zaasɩm dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kʋntʋ ŋwaanɩ á maŋɩ sɩ á taá tɔgɩ kʋlʋ maama ba na brɩ abam tɩn. Á nan yɩ zaŋɩ á lwǝni ba na kɩ kʋlʋ maama tɩn, bɛŋwaanɩ ba tɩtɩ ba tɔgɩ kʋlʋ ba na brɩ nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ba na kɩ te tɩn, ba yǝni ba yaarɩ nɔɔna mʋ dɩ cul-dɛɛrʋ sɩ ba taa tɔgɩ-tɩ. Kʋ maa nyɩ dɩ ba na fɩ-ba sɩ ba zɩŋɩ zɩla yalʋ duuni na dwe ba zɩŋɩm tɩn, yɩ ba tɩtɩ yigǝ tǝrǝ sɩ ba twǝri zɩla yam fɩnfɩɩn dɩ ba zɩŋɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kʋlʋ na wǝli da tɩn, ba yǝni ba brɩ ba kǝm-laarʋ tɩm jaja mʋ sɩ nɔɔna maama taa naɩ. Ba yǝni ba brɩ ba tɩtɩ nɔɔna yigǝ nɩ, nɩ ba jɩgɩ Wɛ tɔnɔ kʋm sono, dɩ ba na tiini ba vɔ-tɩ ba yɩra nɩ jaja tɩn. Ba ma kɩ zala zanzan ba gwaarʋ yɩra nɩ, sɩ kʋ pa nɔɔna taa zuli-ba. ");
INSERT INTO xsm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ba na yǝni ba vu nɔɔnʋ sɔŋɔ sɩ ba di candiǝ, kʋ yɩ je-ŋʋŋa je nɩ mʋ ba lagɩ sɩ ba taa je da. Ba na zʋ ba Wɛ-di sɩm, ba daa ta lagɩ je-kamunnu mʋ sɩ ba taa je yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ba na ve yaga, ba lagɩ sɩ nɔɔna maama taa tui ba zuli-ba mʋ, yɩ ba ta lagɩ sɩ nɔɔna taa bǝ-ba nɩ ‹Karanyɩna›. ");
INSERT INTO xsm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kʋ nan na yɩ abam, á yɩ taá lagɩ sɩ ba taa bǝ abam nɩ ‹Karanyɩna›, bɛŋwaanɩ á maama yɩ nu-biǝ mʋ daanɩ, yɩ á jɩgɩ Karanyɩna dɩdʋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Á yɩ zaŋɩ á ma nɔɔn-nɔɔnʋ á ma bǝŋi nɩ á ‹Ko› lʋgʋ baŋa yo, Wɛ cwǝŋǝ kam tɔgɩm ŋwaanɩ. Bɛŋwaanɩ abam maama jɩgɩ Ko dɩdʋa mʋ, wʋntʋ mʋ yɩ Baŋa-Wɛ. ");
INSERT INTO xsm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kʋlʋ na wǝli da tɩn, á nan yɩ taá lagɩ sɩ nɔɔna taa bǝ abam nɩ ‹Yigǝ tiinǝ›, bɛŋwaanɩ á Yigǝ Tu yɩ dɩdʋa mʋ. Wʋntʋ mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Abam nɔn-kamunu mʋ yɩ wʋlʋ na yɩ tɩntʋŋnʋ á wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bɛŋwaanɩ, wʋlʋ na zǝŋi o tɩtɩ tɩn, Wɛ wʋ́ tu kʋntʋ tu. Wʋlʋ nan na tu o tɩtɩ tɩn, Wɛ wʋ́ zǝŋi kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Á yǝni á cɩ cwǝŋǝ á pa nɔɔna warɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋnɩ. Abam tɩtɩ ba lagɩ sɩ á zʋ, yɩ á daarɩ á cɩ balʋ maama na lagɩ sɩ ba zʋ tɩn cwǝŋǝ.  ");
INSERT INTO xsm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Á yǝni á ganɩ kadǝnǝ á joŋi ba wǝǝnu. Á kwǝri á kɩ Wɛ-lor-dɩdwaarʋ sɩ kʋ taa nyɩ nɩ á yɩ nɔn-ŋʋna mʋ te. Kʋntʋ ŋwaanɩ Wɛ wʋ́ tiini DƖ pa abam na cam kʋ ja gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Á yǝni á beeri lʋgʋ baŋa je maama mʋ sɩ á nii, á wʋ́ wanɩ á pa dwi-gɛ tu dɩdʋa ba o tɔgɩ cullu tɩlʋ Wɛ na pɛ dɩbam Zwifǝ bam tɩn na. Bantʋ dɩdʋa nan na tu o sɛ Wɛ, á laan wʋ́ brɩ-o á tɩtɩ cullu mʋ, sɩ á pa o tiini o ji min-tɩʋ nɔɔnʋ kʋ dwǝni abam tɩtɩ na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lɛɛrʋ wʋ á yuu nɩ. Abam nyɩ dɩ lilwǝ na vaŋɩ ba donnǝ lilwǝ te tɩn mʋ. Abam yǝni á brɩ nɔɔna á wɩ, nɔɔnʋ na dugi durǝ dɩ Wɛ-di-kamunu kʋm, kʋntʋ daɩ kʋlʋkʋlʋ. Á ma daarɩ á brɩ á wɩ, nɔɔnʋ nan na dugi dɩ sǝbu-sɩŋa kalʋ na wʋ Wɛ-digǝ kam wʋnɩ tɩn, kʋ yɩ fɩfɩʋn mʋ sɩ kʋntʋ tu kɩ kʋlʋ o na dugi dɩ kʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Abam yɩ jwǝǝru yɩ á kwǝri á nyɩ dɩ lilwǝ mʋ. Kʋ yɩ digǝ kam na yɩ Wɛ nyɩm tɩn ŋwaanɩ mʋ pɛ sǝbu-sɩŋa kam dɩ yɩ Wɛ nyɩm. Kʋntʋ tɩn, tɩntʋ wʋnɩ kɔɔ mʋ jɩgɩ kuri kʋ dwe kʋdoŋ? ");
INSERT INTO xsm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Abam daa ta brɩ nɩ, nɔɔnʋ na dugi dɩ Wɛ kaanɩm bimbim dɩm, kʋntʋ daɩ kʋlʋkʋlʋ. Á ma daarɩ á brɩ nɩ, nɔɔnʋ na dugi dɩ kaanɩm wǝǝnu tɩlʋ maama na tigi bimbim dɩm baŋa nɩ tɩn, kʋ yɩ fɩfɩʋn mʋ sɩ kʋntʋ tu kɩ kʋlʋ o na dugi dɩ kʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Abam nyɩ dɩ lilwǝ mʋ yɩ á ba naɩ kʋlʋ na yɩ cɩga tɩn. Kʋ yɩ bimbim dɩm na yɩ Wɛ nyɩm tɩn mʋ pɛ kaanɩm wǝǝnu tɩm dɩ yɩ Wɛ nyɩm. Kʋntʋ tɩn, tɩntʋ wʋnɩ kɔɔ mʋ jɩgɩ kuri kʋ dwe kʋdoŋ? ");
INSERT INTO xsm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kʋntʋ, nɔɔnʋ wʋlʋ na dugi dɩ kaanɩm bimbim dɩm tɩn, kʋ brɩ nɩ kʋntʋ tu dugi dɩ bimbim dɩm tɩtɩ kʋ wǝli dɩ woŋo kʋlʋ maama na tigi dɩ baŋa nɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wʋlʋ dɩ na dugi dɩ Wɛ-digǝ kam tɩn, kʋ brɩ nɩ kʋntʋ tu dugi dɩ Wɛ mʋ, Wɛ na wʋ ka wʋnɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nɔɔnʋ wʋlʋ dɩ nan na dugi dɩ Wɛ-sɔŋɔ kʋm tɩn, kʋ brɩ nɩ kʋntʋ tu dugi dɩ Wɛ paarɩ jangɔŋɔ kʋm mʋ, kʋ brɩ nɩ kʋntʋ tu dugi dɩ Baŋa-Wɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Kʋ na maŋɩ kʋ yɩ dwǝ dwi maama, ba zɩ ba daga dɩ, á yǝni á lɩ Wɛ tǝri á pa-DƖ. Kʋ lana. Kʋ daarɩ á yigǝ tǝrǝ dɩ Wɛ niǝ yadaara yalʋ na tiini ya yɩ kamunǝ tɩn, nɩnɛɛnɩ cɩga tɔgɩm dɩ yibwǝn-durǝ dɩ wʋ-dɩdʋa kǝm. Kʋ ya maŋɩ sɩ á taá kɩ wǝǝnu tɩm kʋntʋ mʋ sɩ á yɩ yagɩ Wɛ niǝ yadaara yam. ");
INSERT INTO xsm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Abam sɩɩnɩ á nyɩ dɩ lilwǝ balʋ na vaɩ ba donnǝ lilwǝ tɩn mʋ. Abam nyɩ dɩ nɔɔna balʋ na lagɩ ba nyɔ na, yɩ ba yǝni ba leeri-ba, sɩ kalisi na wʋra sɩ ba lɩ-dɩ ba yagɩ, yɩ ba yigǝ nan tǝrǝ dɩ wo-kamunu kʋlʋ ba na liri tɩn, kʋ na maŋɩ kʋ ma dɩ yogondi dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Abam ŋwɩa kam nyɩ dɩ ba na sɩn zwɩ dɩ kabǝli kwɛ sɩ kʋ tɔgɩ cullu na brɩ te yɩ sɩ wʋ su dɩ digiru te tɩn mʋ. Abam wʋrʋ su dɩ kampinǝ dɩ pu-sɩŋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizɩan tu, nmʋ nyɩ dɩ lilwe mʋ te. Nmʋ maŋɩ sɩ n da yigǝ n sɩn n zwɩ wʋ mʋ, sɩ sɩ kwɛ dɩ daa yɩ taa jɩgɩ digiru. ");
INSERT INTO xsm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Abam nyɩ dɩ yibeelǝ yalʋ ba na fɔgɩ ya kwaga sɩ ya taa lana nɔɔna yibiyǝ nɩ tɩn mʋ. Yibeelǝ yam kʋntʋ wʋ ma su dɩ twa kwi, yɩ ya tiini ya yɩ digiru yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Abam dɩ nan yɩ kʋntʋ mʋ. Á paɩ á jɩgɩ cɩga mʋ nɔɔna yibiyǝ nɩ, yɩ á wʋrʋ laan su dɩ lwarɩm yɩranɩ, dɩdaanɩ pipirǝ kikiǝ. ");
INSERT INTO xsm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Wɛ cullu karanyɩna tiinǝ-ba dɩ Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Abam yɩ pipiri-nyɩna mʋ. Abam yǝni á fɔgɩ á kɩ faŋa faŋa Wɛ nijoŋnǝ bam yibeelǝ, yɩ á daarɩ á kwɛ Wɛ nɔn-ŋʋna bam yibeelǝ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Á ma daarɩ á tɛ á wɩ, abam dɛɛn ya na wʋra á kwǝ nakwa bam maŋa kam nɩ, á ya bá sɛ á wǝli dɩ ba á gʋ Wɛ nijoŋnǝ bam. ");
INSERT INTO xsm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Abam tɩtɩ ni-taanɩ nan mʋ brɩ nɩ á yɩ balʋ na gʋ Wɛ nijoŋnǝ bam tɩn biǝ. ");
INSERT INTO xsm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kʋntʋ, nan kwaanɩ-na á tʋŋɩ á kwǝ nakwa bam na kɩ wo-lwaanʋ tɩlʋ ba daarɩ tɩn sɩ kʋ vu kʋ ti. ");
INSERT INTO xsm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Abam dɩ á kwǝ bam maama nyɩ dɩ bɩsankwɩ-dwǝ mʋ. Á brɩ á bá lu min-tɩʋ cam dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kʋntʋ ŋwaanɩ a lagɩ a tʋŋɩ a nijoŋnǝ abam tee nɩ, dɩ yiyiu tiinǝ dɩ Wɛ tɔnɔ karanyɩna tiinǝ dɩ. Abam wʋ́ ja badaara á gʋ, yɩ á daarɩ á pa badaara tʋʋn-dagara baŋa nɩ á gʋ. Á ma wʋ́ ja badaara á Wɛ-di sɩm wʋnɩ á magɩ, yɩ á daarɩ á taá tɔgɩ ba nɛ tɩʋ dɩ tɩʋ á bɛɛsɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kʋntʋ ŋwaanɩ Wɛ wʋ́ pa abam na cam nɩnɛɛnɩ kʋ yɩ abam tɩtɩ mʋ gʋ nɔn-ŋʋna balʋ maama ba na maŋɩ ba gʋ lʋgʋ pulim nɩ sɩ kʋ ba kʋ yi zɩm tɩn. Kʋ na puli dɩ Abɛlɩ wʋlʋ na yɩ nɔn-ŋʋm tɩn, sɩ kʋ ba kʋ kweeli dɩ Barasɩ bu Zakari wʋlʋ abam kwǝ na gʋ Wɛ di-laa kʋm dɩ Wɛ kaanɩm bimbim dɩm tɩtarɩ nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔna bantʋ maama caa wʋ́ ta tɔgɩ zɩm nɔɔna bam.» ");
INSERT INTO xsm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Hǝii! Zeruzalɛm tiinǝ-ba, á yǝni á gʋɩ Wɛ nijoŋnǝ, yɩ á dʋlɩ nɔɔna balʋ Wɛ na tʋŋɩ abam tee nɩ tɩn dɩ kandwa. Kuni zanzan mʋ a ya lagɩ sɩ a la abam nɔn-biǝ a kɩ daanɩ, sɩ a taa nii á baŋa nɩ, nɩnɛɛnɩ coro na kukwǝri kʋ biǝ kʋ kɩ kʋ vwana kuri nɩ te tɩn. Abam maa ba sɛa. ");
INSERT INTO xsm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kʋntʋ ŋwaanɩ abam tɩʋ kʋm laan wʋ́ ba kʋ ji di-dwǝǝnu. ");
INSERT INTO xsm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nan taá ye-na nɩ, á daa bá na-nɩ sɩ kʋ taa ve maŋa kalʋ á na wʋ́ ta á wɩ: ‹Zuli-na wʋlʋ na bɩɩnɩ dɩ́ Yuutu Wɛ yɩrɩ ŋwaanɩ tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zezi laan ma nuŋi Wɛ-di-kamunu kʋm nɩ sɩ o viiri. O na maa kɛ tɩn, o karabiǝ bam ma ba o te, sɩ ba pa o maanɩ Wɛ-digǝ kam lɔɔm dɩm na lana te. ");
INSERT INTO xsm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","O ma ta dɩ ba o wɩ: «Abam wʋ nɛ ka na yɩ te tɩn na? A lagɩ a ta cɩga mʋ dɩ abam sɩ, ka maama wʋ́ ba ka tʋ tɩga nɩ ka cɔgɩ maama. Kandwɛ daa bá daŋɩ dɩ doŋ baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zezi dɛɛn ma vu o jǝni Olivi piu kʋm yuu nɩ. O karabiǝ bam yɩranɩ ma vu o te, yɩ ba bwe-o ba wɩ: «Maŋa kɔɔ mʋ Wɛ-digǝ kam wʋ́ ba ka tʋ kʋntʋ? Bɛɛ mʋ lagɩ kʋ kɩ maana kʋ brɩ dɩbam nɩ maŋa kam yi sɩ nmʋ joori n ba lʋgʋ baŋa, sɩ lʋgʋ tiim mɩmaŋa laan yi?» ");
INSERT INTO xsm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zezi ma lǝri-ba o wɩ: «Á fɔgɩ á cɩ á tɩtɩ, sɩ á yɩ pa nɔɔn-nɔɔnʋ ganɩ abam. ");
INSERT INTO xsm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bɛŋwaanɩ nɔɔna zanzan wʋ́ ba abam te, yɩ baá ma amʋ yɩrɩ ba ma ganɩ abam ba wɩ, bam dɩdʋa dɩdʋa mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. Kʋntʋ doŋ mʋ baá ganɩ nɔɔna zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Á wʋ́ ba á na tigurǝ na wʋ abam je sɩm nɩ, yɩ á kwǝri á ni ka ŋwa tɩɩnɩ dɩlʋ na baŋwɛ tɩn nɩ. Nan yɩ pa-na fʋʋnɩ zʋ abam, bɛŋwaanɩ wǝǝnu tɩm kʋntʋ maama maŋɩ sɩ tɩ kɩ mʋ, yɩ kʋ ta daɩ lʋgʋ tiim maŋa. ");
INSERT INTO xsm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dwi wʋ́ zaŋɩ dɩ kɩ jara dɩ dwi dɩdoŋ, yɩ tɩʋ dɩ kʋ doŋ wʋ́ zaŋɩ tɩ magɩ jara. Kana dɩ wʋ́ ba ka taa wʋ je zanzan nɩ, yɩ tɩga dɩ wʋ́ sisiŋi je sɩdonnǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wǝǝnu tɩm kʋntʋ maama nan nyɩ dɩ kaanɩ na sɩŋɩ o vri pugǝ yɩ ka wɔɛ te tɩn mʋ, yɩ cam daa ta wʋ kwaga nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kantʋ maŋa kam nɩ nɔɔna wʋ́ ja abam ba kɩ dɩdɛɛra jɩa nɩ sɩ ba bɛɛsɩ abam, yɩ ba daarɩ ba gʋ abam. Abam na yɩ amʋ nɔɔna tɩn ŋwaanɩ, lʋgʋ baŋa nɔɔna maama wʋ́ ta culi abam. ");
INSERT INTO xsm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kantʋ maŋa nɩ nɔɔna zanzan wʋ́ ba ba yagɩ amʋ kwaga tɔgɩm. Nɔɔna badaara wʋ́ kʋ da-kurǝ ba brɩ daanɩ, yɩ badonnǝ dɩ wʋ́ ta culi daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nɔɔna zanzan wʋ́ ba ba brɩ nɩ ba yɩ Wɛ nijoŋnǝ mʋ yɩ ba daɩ, yɩ baá ganɩ nɔɔna zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wo-balwaarʋ tɩm na wʋ́ ba tɩ tiini tɩ gaalɩ tɩn, kʋʋ́ pa nɔɔna zanzan sono ti. ");
INSERT INTO xsm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wʋlʋ maama nan na kɩ pu-dɩa o zɩgɩ kǝŋkǝŋ sɩ kʋ vu kʋ yi kweelim tɩn, Wɛ wʋ́ vrɩ kʋntʋ tu ŋwɩa. ");
INSERT INTO xsm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nɔɔna dɩ wʋ́ beeri lʋgʋ baŋa je maama ba tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam nɩ Wɛ lagɩ DƖ di paarɩ nɔɔna tɩtarɩ nɩ, sɩ kʋ taa yɩ maana nabiinǝ maama tee nɩ, sɩ lʋgʋ tiim laan yi. ");
INSERT INTO xsm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Abam nan wʋ́ ba á na wo-lɔŋɔ kʋlʋ na yɩ cɔgɩnʋ tɩn na wʋ́ ba kʋ zʋ kʋ zɩgɩ Wɛ tɩtɩ di-kamunu kʋm wʋnɩ kʋ cɔgɩ-ka. Wɛ nijoŋnu Daniyɛlɩ maŋɩ o ta wo-lɔŋɔ kʋm kʋntʋ taanɩ. (A lagɩ a ta dɩ abam sɩ wʋlʋ na karɩmɩ tɩn, sɩ o kwaanɩ o ni kʋ kuri lanyɩranɩ.) ");
INSERT INTO xsm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Abam na nɛ wo-lɔŋɔ kʋm kʋntʋ, sɩ abam balʋ na zʋʋrɩ Zude nɩ tɩn kɩ lɩla á nuŋi á duri á vu pweeru yuu á sǝgi da. ");
INSERT INTO xsm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nɔɔnʋ nan na wʋ nayuu nɩ, o daa yɩ tu o zʋ digǝ sɩ o kwe kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nɔɔnʋ wʋlʋ nan na wʋ kara nɩ tɩn, o dɩ yɩ joori sɔŋɔ sɩ o kwe o gɔrɔ o zʋ. ");
INSERT INTO xsm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kantʋ maŋa kam nɩ kʋʋ́ tiini kʋ taa yɩ lɛɛrʋ dɩ kaana balʋ na jɩgɩ pwi tɩn, dɩ balʋ na jɩgɩ biǝ yɩ ba ŋɔgɩ yɩlɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nan taá loori-na Wɛ, sɩ cam durim dɩm kʋntʋ yɩ zaŋɩ dɩ ba taa yɩ waarʋ mɩmaŋa nɩ naa siun dɛ dɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bɛŋwaanɩ yaara yalʋ na lagɩ ya ba maŋa kam kʋntʋ nɩ tɩn wʋ́ ta tiini ya camma ya dwe yalʋ na maŋɩ ya kɩ lʋgʋ pulim maŋa nɩ sɩ kʋ ba kʋ yi zɩm tɩn. Yaara yantʋ nan na kɛ, yaara yadonnǝ daa bá ba nɩnɛɛnɩ yantʋ te. ");
INSERT INTO xsm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Baŋa-Wɛ na wʋ pɛ yaara yam da yam tri, nɔɔn-nɔɔnʋ bá wǝri. Kʋ nan yɩ Wɛ tɩtɩ nɔɔna bam DƖ na kuri tɩn ŋwaanɩ mʋ DƖ wʋ́ pa yaara yam da yam tri. ");
INSERT INTO xsm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kantʋ maŋa kam nɩ, nɔɔnʋ wʋlʋ maama na tagɩ dɩ abam o wɩ: ‹Nii-na Krisi wʋm Wɛ na tʋŋɩ tɩn wʋ yo seeni› naa: ‹O wʋ jǝgǝ kadoŋ nɩ›, sɩ á yɩ sɛ kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nɔɔna badaara wʋ́ zaŋɩ ba brɩ nɩ bam dɩdʋa dɩdʋa yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn mʋ, yɩ ba yagɩ ba daɩ. Badonnǝ dɩ wʋ́ brɩ nɩ bantʋ yɩ Wɛ nijoŋnǝ mʋ, yɩ ba yagɩ ba daɩ. Ba ma wʋ́ kɩ wo-kɩnkagɩla yalʋ na wʋ́ sʋ nɔɔna tɩn, sɩ ba ya na waɩ, sɩ ba sʋgɩ Wɛ tɩtɩ nɔɔna balʋ DƖ na kuri tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nii-na, amʋ nan wuuri a ta a brɩ abam mʋ, yɩ ka maŋa kam ta wʋ yi. ");
INSERT INTO xsm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Woŋo kʋlʋ na wǝli da tɩn, nɔɔna na tagɩ dɩ abam ba wɩ: ‹Nii-na Krisi tu o wʋ kagʋa wʋnɩ›, sɩ á yɩ zaŋɩ á vu da. Naa ba na tagɩ ba wɩ: ‹Nii-na, sɩ o wʋ sɔŋɔ kʋntʋ nɩ›, sɩ á yɩ sɛ. ");
INSERT INTO xsm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bɛŋwaanɩ, dɛ dɩm amʋ Nabiin-bu wʋm na lagɩ a ba lʋgʋ baŋa tɩn na yiǝ, kʋʋ́ ta nyɩ dɩ dʋa na pɩpɩlɩ wɛyuu nɩ ka zɩgɩ bri-kwaga nɩ ka vu ka yi mancoŋo te tɩn mʋ, ");
INSERT INTO xsm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","nɩ bɩtar-dɩndɩa na tagɩ ka wɩ: ‹Wo-tʋʋ na wʋ mɛ tɩn, duurǝ dɩ gilimi da mʋ.› » ");
INSERT INTO xsm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Yaara yam kʋntʋ maŋa kam na tu ka kɛ, kʋ bá daanɩ, yɩ wɩa kam laan ji nazono tim tim. Cana dɩ daa bá fuŋi sɩ pooni taa wʋra. Wɛyuu wʋ́ sisiŋi yɩ calɩcwɩ sɩm wʋ́ kwǝri sɩ tʋ tɩga nɩ, yɩ wǝǝnu tɩlʋ maama na wʋ wɛyuu nɩ tɩn wʋ́ vugimi daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nɔɔna laan wʋ́ na wo-kɩnkagɩlɩ wɛyuu nɩ, sɩ kʋ brɩ nɩ Nabiin-bu wʋm maa bɩɩna. Lʋgʋ baŋa dwi tiinǝ maama wʋ́ ta keerǝ, dɩ ba na nɛ Nabiin-bu wʋm na maa bɩɩnɩ tɩn. Oó ta wʋ wɛyuu nɩ kunkwǝǝnu baŋa nɩ o bɩɩna dɩ dam, yɩ Wɛ paarɩ-zulǝ zanzan wʋ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nabɔn-zɔŋɔ wʋ́ tiini kʋ taa wu wɛyuu nɩ, yɩ Nabiin-bu wʋm laan wʋ́ pa o malɛsɩ sɩm nuŋi sɩ jagɩ sɩ vu lʋgʋ baŋa je maama, kʋ na yɩ wa-puli dɩ wa-zʋʋrɩ, jazɩm dɩ jagwiǝ, sɩ la o nɔɔna balʋ Wɛ na kuri tɩn je maama sɩ kɩ daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Nan maanɩ-na á nii kapʋrʋ na yɩ te tɩn. Kʋntʋ na yǝni kʋ wʋra kʋ kwi vɔɔrʋ, á yǝni á lwarɩ nɩ kʋ twɛ yadɛ. ");
INSERT INTO xsm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kʋ nan yɩ bɩdwɩ mʋ dɩ á na nɛ wǝǝnu tɩlʋ maama a na tagɩ a brɩ abam tɩn na wʋra tɩ kɩa, sɩ á lwarɩ nɩ Nabiin-bu wʋm tum dɩm laan twɛ dɩ ti mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wǝǝnu tɩm kʋntʋ maama wʋ́ ba tɩ wʋra tɩ kɩa, yɩ zɩm nɔɔna bam ta wʋ tɩgɩ ba ti. ");
INSERT INTO xsm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wɛyuu dɩ tɩga baŋa maama wʋ́ ba tɩ kɛ, yɩ amʋ taanɩ dɩm bá kɛ maŋa dɩ maŋa.» ");
INSERT INTO xsm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Nɔɔn-nɔɔnʋ yǝri dɛ dɩlʋ Nabiin-bu wʋm na lagɩ o joori o ba tɩn, nɔɔn-nɔɔnʋ yǝri dɛ dɩm wʋnɩ maŋa kam o na wʋ́ ba tɩn, kʋ na maŋɩ kʋ yɩ Wɛ malɛsɩ sɩm dɩ DƖ Bu wʋm tɩtɩ dɩ. Kʋ nan yɩ a Ko Baŋa-Wɛ yɩranɩ mʋ ye. ");
INSERT INTO xsm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nabiin-bu wʋm na wʋ́ joori o ba maŋa kalʋ tɩn, kʋʋ́ ta nyɩ nɩnɛɛnɩ kʋ dɛɛn na kɩ Nowe maŋa kam nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kʋ na wʋ́ loori dʋ-fara kam nɩnɩm tɩn, nɔɔna dɛɛn di ba wʋdiiru, yɩ ba daarɩ ba di kaana, yɩ kaana dɩ zʋʋrɩ banna, sɩ kʋ vu kʋ yi dɛ dɩm Nowe na zʋ naboro kamunu kʋm wʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba dɛɛn wʋ lwarɩ woŋo kʋlʋ na lagɩ kʋ ba kʋ kɩ tɩn, sɩ kʋ vu kʋ yi maŋa kalʋ dʋ-fara kam na bam na tu ba li nɔɔna bam maama tɩn. Nabiin-bu wʋm dɩ lagɩ o ba kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kantʋ maŋa kam nɩ, nɔɔna bale na wʋ kara nɩ ba tʋŋa, Wɛ wʋ́ lɩ ba dɩdʋa DƖ daarɩ wʋdoŋ wʋm. ");
INSERT INTO xsm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaana bale dɩ na wʋra ba cʋɩ muni nɔŋɔ nɩ, Wɛ wʋ́ lɩ ba dɩdʋa DƖ daarɩ wʋdoŋ wʋm. ");
INSERT INTO xsm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kʋntʋ ŋwaanɩ, á fɔgɩ á cɩ á tɩtɩ, sɩ á yǝri dɛ dɩm á Yuutu wʋm na wʋ́ joori o ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lwarɩ-na sɩ, sɔŋɔ tu ya na lwarɩ maŋa kalʋ ŋwɩɩnʋ na lagɩ o ba tɩtɩɩ nɩ o ŋɔ tɩn, o ya wʋ́ yɩrɩ o sɔŋɔ kʋm, sɩ ŋwɩɩnʋ wʋm yɩ na cwǝŋǝ o zʋ o ŋɔ. ");
INSERT INTO xsm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kʋntʋ tɩn, abam maŋɩ sɩ á cɩ á tɩtɩ mʋ, bɛŋwaanɩ amʋ Nabiin-bu wʋm lagɩ a ba maŋa kalʋ abam na ba bʋŋɩ nɩ aá ba tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wɔɔ mʋ yɩ tɩntʋŋ-ŋʋm wʋlʋ na jɩgɩ wʋbʋŋa tɩn? O nyɩ nɩnɛɛnɩ tɩntʋŋnʋ wʋlʋ o yuutu na yagɩ o tɩtʋŋa o pa-o yɩ o daarɩ o vu cwǝŋǝ tɩn. O yuutu wʋm ma lɩ-o sɩ o taa nii o donnǝ tɩntʋŋna bam baŋa nɩ, sɩ o daarɩ o taa pa-ba ba ni-wʋdiu maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","O yuutu wʋm na joori o ba, yɩ o piini dɩ o kɩ kʋlʋ maama o na wɩ o kɩ tɩn, tɩntʋŋnʋ wʋm kʋntʋ laan wʋ́ na yu-yoŋo. ");
INSERT INTO xsm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A lagɩ a ta cɩga mʋ dɩ abam sɩ, o yuutu wʋm laan wʋ́ pa o taa nii o jɩjɩgɩrʋ tɩm maama baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","O nan na yɩ tɩntʋŋ-balɔrɔ yɩ o bʋŋɩ nɩ, o yuutu wʋm daanɩ zanzan yɩ o ba tui, ");
INSERT INTO xsm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yɩ o na jɩgɩ o donnǝ tɩntʋŋna bam o maga, yɩ o daarɩ o tɔgɩ dɩ sa-nyɔra o di yɩ o nyɔ sana dɩ ba, ");
INSERT INTO xsm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tɩntʋŋnʋ wʋm kʋntʋ yuutu wʋm laan wʋ́ joori o ba dɛ dɩm tɩntʋŋnʋ wʋm na ba bʋŋɩ nɩ oó ba tɩn, dɩ maŋa kalʋ o na wʋ́ ba o zʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","O yuutu wʋm nan na tu o pɩɩr-o kʋntʋ, o laan wʋ́ pa o na cam, yɩ o daarɩ o pa o tɔgɩ dɩ pipiri-nyɩna o na yaara zanzan, jǝgǝ kalʋ nɩ ba na wʋ́ ta keerǝ yɩ ba dʋnɩ ba nwa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Kantʋ maŋa kam nɩ Wɛ paarɩ dɩm wʋ́ ta nyɩ dɩ bukwa fugǝ na zaŋɩ ba vu sɩ ba jeeri kan-bar-dʋʋrʋ te tɩn. Ba ma kwe ba min-zwǝǝnu ba ja wǝli da ba vu. ");
INSERT INTO xsm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bukwa bam banu maa yɩ jwǝǝru, yɩ banu bam yɩ swan tiinǝ. ");
INSERT INTO xsm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Balʋ na ba jɩgɩ swan tɩn ma wʋ kɩ nugǝ ba wǝli da, sɩ ba taa kɩ ba min-zwǝǝnu tɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kʋ daarɩ swan tiinǝ bam ma kɩ nugǝ wǝǝnu wʋnɩ ba ziǝ. ");
INSERT INTO xsm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kan-barʋ wʋm na tiini o daanɩ yɩ o ba tui tɩn, kʋ ma pa ba maama tigi ba dɔa. ");
INSERT INTO xsm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tɩga na tu ka kwɩɩrɩ tɩn, nɔɔna maa tɔɔlɩ ba wɩ: ‹Kan-barʋ wʋm maa bɩɩna! Zaŋɩ-na á nuŋi á jeer-o.› ");
INSERT INTO xsm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bukwa bam ma zaŋɩ ba tarɩgɩ ba min-zwǝǝnu tɩm. ");
INSERT INTO xsm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bukwa balʋ na ba jɩgɩ swan tɩn min-zwǝǝnu tɩm maa lagɩ tɩ dwe. Ba ma ta dɩ ba donnǝ swan tiinǝ bam sɩ ba kɩ nugǝ ba pa-ba, sɩ ba min-zwǝǝnu tɩm lagɩ tɩ dwe. ");
INSERT INTO xsm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Swan tiinǝ bam ma lǝri ba wɩ: ‹Aye, nugǝ kam ba daga sɩ ka yi dɩbam maama. Kʋntʋ ŋwaanɩ, abam dɩ ve balʋ na jɩgɩ nugǝ ba yǝgi tɩn te á yǝgi.› ");
INSERT INTO xsm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ba laan ma kɛ sɩ ba yǝgi. Ba na kɛ ba daarɩ tɩn, mʋ kan-barʋ wʋm yiǝ. Badaara bam na maŋɩ ba ti ba yigǝ tɩn, ba ma tɔgɩ dɩ kan-barʋ wʋm ba vu ba zʋ kadiri dim sɔŋɔ kʋm. Ba ma pɩ mancoŋo kʋm ni. ");
INSERT INTO xsm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kʋ na kɩ fɩnfɩɩn tɩn, mʋ bukwa banu balʋ na ba jɩgɩ swan tɩn laan tuǝ, yɩ ba bǝŋi kan-barʋ wʋm ba wɩ: ‹Dɩ́ yuutu, dɩ́ yuutu, pʋrɩ sɩ dɩ́ zʋ!› ");
INSERT INTO xsm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","O ma lǝri-ba o wɩ: ‹A lagɩ a ta cɩga mʋ dɩ abam sɩ, a yǝri abam.› ");
INSERT INTO xsm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kʋntʋ ŋwaanɩ á maŋɩ sɩ á taá cʋ á tɩtɩ, bɛŋwaanɩ á yǝri dɛ dɩlʋ naa maŋa kalʋ amʋ Nabiin-bu wʋm na wʋ́ joori a ba tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Wɛ paarɩ dɩm daa ta nyɩ dɩ sɔŋɔ tu wʋdoŋ na lagɩ o nuŋi o vu cwǝŋǝ. O ma bǝŋi o tɩntʋŋna, yɩ o kwe o wǝǝnu o pa-ba sɩ ba taa niǝ. ");
INSERT INTO xsm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O ma cɛ sǝbu-dala mʋrr-tɩnu (5.000) o pa ba dɩdʋa, yɩ o daarɩ o pa dɩdʋa sǝbu-dala mʋrr-tɩle (2.000). O ma pa dɩdʋa kam dɩ sǝbu-dala mʋrʋ dɩdʋa (1.000). O nan pɛ-ba sǝbu kʋm, sɩ kʋ maŋɩ ba dɩdʋa dɩdʋa dam na maɩ te tɩn mʋ. O laan ma daarɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tɩntʋŋnʋ wʋlʋ na joŋi sǝbu-dala mʋrr-tɩnu tɩm tɩn ma kɩ lɩla o kwe sǝbu kʋm o ma kɩ pipiu, yɩ o na sǝbu-dala mʋrr-tɩnu nyɔɔrɩ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sǝbu-dala mʋrr-tɩle tu wʋm dɩ ma na sǝbu-dala mʋrr-tɩle nyɔɔrɩ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kʋ daarɩ sǝbu-dala mʋrʋ dɩdʋa kam tu wʋm ma kwe sǝbu kʋlʋ o tu wʋm na pɛ-o tɩn o kʋ goŋo o suli da. ");
INSERT INTO xsm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kʋ na daanɩ tɩn, sɔŋɔ tu wʋm laan ma joori. O ma bǝŋi o tɩntʋŋna bam sɩ ba ba ba jeeli o sǝbu kʋm ba nii. ");
INSERT INTO xsm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sǝbu-dala mʋrr-tɩnu tɩm tu wʋm ma ja sǝbu-dala mʋrr-tɩnu nyɔɔrɩ dɩlʋ o na nɛ tɩn o wǝli da o vu o pa-o. O ma ta dɩ o tu wʋm o wɩ: ‹Amʋ yuutu, nii. Nmʋ ya n pɛ-nɩ sǝbu-dala mʋrr-tɩnu mʋ, yɩ a laan kɩ pipiu a na sǝbu-dala mʋrr-tɩnu nyɔɔrɩ a wǝli da.› ");
INSERT INTO xsm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","O tu wʋm ma lǝr-o o wɩ: ‹Nmʋ kɩ cɩga, n jɩgɩ yawala, n yɩ tɩntʋŋ-ŋʋm. Nmʋ sɩɩnɩ n kɩ cɩga dɩ n na nii kʋlʋ fɩnfɩɩn a na kɩ n jɩŋa nɩ tɩn baŋa nɩ. Kʋntʋ, a laan wʋ́ pa n ta n nii a wǝǝnu zanzan baŋa nɩ. Nan ba sɩ dɩ́ kɩ wʋpolo daanɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sǝbu-dala mʋrr-tɩle tu wʋm dɩ ma vu o te, yɩ o ta dɩd-o o wɩ: ‹A yuutu, nmʋ ya n pɛ-nɩ sǝbu-dala mʋrr-tɩle mʋ, yɩ a laan kɩ pipiu a na sǝbu-dala mʋrr-tɩle a wǝli da.› ");
INSERT INTO xsm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","O tu wʋm ma lǝr-o o wɩ: ‹Nmʋ kɩ cɩga, n jɩgɩ yawala, n yɩ tɩntʋŋ-ŋʋm. Nmʋ sɩɩnɩ n kɩ cɩga dɩ n na nii kʋlʋ fɩnfɩɩn a na kɩ n jɩŋa nɩ tɩn baŋa nɩ. Kʋntʋ, a laan wʋ́ pa n ta n nii a wǝǝnu zanzan baŋa nɩ. Nan ba sɩ dɩ́ kɩ wʋpolo daanɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sǝbu-dala mʋrʋ dɩdʋa kam tu wʋm laan ma vu o ta dɩ o tu wʋm o wɩ: ‹Amʋ yuutu, a ye nɩ nmʋ laŋa dana. N yǝni n zagɩ mɩna yalʋ n tɩtɩ na wʋ dugi tɩn, yɩ n daarɩ n joŋi nyɔɔrɩ dɩlʋ na daɩ nmʋ tɩtʋŋa nyɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kʋntʋ ŋwaanɩ a kwarɩ fʋʋnɩ dɩ nmʋ, yɩ a kwe nmʋ sǝbu kʋm a vu a suli tɩga nɩ. Nan joori n joŋi n sǝbu kʋm.› ");
INSERT INTO xsm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","O tu wʋm ma ta dɩd-o o wɩ: ‹Nmʋ yɩ tɩntʋŋ-balɔrɔ mʋ, yɩ n jɩgɩ yawɔrɔ zanzan. Nmʋ na ye nɩ amʋ laŋa dana, yɩ a yǝni a zagɩ mɩna yalʋ a tɩtɩ na wʋ dugi tɩn, yɩ a lagɩ nyɔɔrɩ dɩlʋ na daɩ a tɩtʋŋa nyɩm tɩn, ");
INSERT INTO xsm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kʋ ya maŋɩ sɩ nmʋ kwe a sǝbu kʋm n tiŋi bankɩ nɩ. Nmʋ ya na kɩ kʋntʋ, a ya wʋ́ ba a joŋi-kʋ dɩ nyɔɔrɩ. ");
INSERT INTO xsm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kʋntʋ tɩn, joŋi-na sǝbu-dala mʋrʋ dɩdʋa kam o tee nɩ á pa wʋlʋ na jɩgɩ sǝbu-dala mʋrr-fugǝ kam tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bɛŋwaanɩ, nɔɔnʋ na maŋɩ o jɩgɩ woŋo, o ta wʋ́ joŋi kʋdoŋ o wǝli da sɩ kʋ tiini kʋ taa daga. Nɔɔnʋ wʋlʋ nan na maŋɩ o ba jɩgɩ kʋlʋkʋlʋ tɩn laan wʋ́ ba o ga kʋlʋ fɩnfɩɩn o ya na jɩgɩ tɩn dɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kʋ nan na yɩ tɩntʋŋ-kayaa kantʋ, ja-o-na á nuŋi á dɩ á yagɩ lim jǝgǝ nɩ, mɛ yaara na tiini ya wʋra yɩ nɔɔna keerǝ yɩ ba dʋnɩ ba nwa tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Nabiin-bu wʋm nan na joori o ba dɩ o paarɩ-zulǝ yam, yɩ Wɛ malɛsɩ sɩm maama tɔgɩ sɩ wʋ o tee nɩ, o laan wʋ́ ba o jǝni o paarɩ jangɔŋɔ kʋm baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lʋgʋ baŋa dwi tiinǝ maama wʋ́ ba ba la daanɩ o yigǝ nɩ. O laan wʋ́ pɔɔrɩ-ba kuni bɩle, nɩ nayɩrʋ na pɔɔrɩ o peeni dɩ o bʋnɩ daanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oó pɔɔrɩ peeni sɩm o pa sɩ taa wʋ o jazɩm nɩ, yɩ o daarɩ o yagɩ bʋnɩ dɩm o jagwiǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nabiin-bu wʋm na yɩ pɛ kʋntʋ tɩn, o laan wʋ́ ta dɩ balʋ na wʋ o jazɩm nɩ tɩn o wɩ: ‹Abam balʋ a Ko Wɛ na kɩ lanyɩranɩ tɩn, á ba-na á tɔgɩ á di paarɩ dɩlʋ DƖ na maŋɩ DƖ tiŋi DƖ pa abam, kʋ na sɩŋɩ lʋgʋ pulim nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bɛŋwaanɩ, kana dɛɛn jaanɩ amʋ, yɩ á pa-nɩ wʋdiu yɩ a di. Na-nyɔm dɛɛn jaanɩ-nɩ, yɩ á pa-nɩ na yɩ a nyɔ. A dɛɛn tu abam sam, yɩ á kɩ-nɩ voro lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A dɛɛn ba jɩgɩ gɔrɔ sɩ a zʋ, yɩ á pa-nɩ gɔrɔ. A dɛɛn ba jɩgɩ yazurǝ, yɩ á ba á nii-nɩ. Ba dɛɛn kɩ-nɩ pɩɩna digǝ nɩ, yɩ á ba á nii-nɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wɛ nɔn-ŋʋna bam laan wʋ́ zaŋɩ ba bwe-o ba nii: ‹Dɩ́ Yuutu, maŋa kɔɔ mʋ dɩbam nɛ kana jɩgɩ nmʋ yɩ dɩ́ pa-m wʋdiu yɩ n di, naa na-nyɔm jɩgɩ-m yɩ dɩ́ pa-m na yɩ n nyɔ? ");
INSERT INTO xsm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Maŋa kɔɔ mʋ nmʋ tu dɩbam sam yɩ dɩ́ kɩ nmʋ voro, naa maŋa kɔɔ mʋ n ba jɩgɩ gɔrɔ yɩ dɩ́ pa-m gɔrɔ, ");
INSERT INTO xsm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","naa maŋa kɔɔ mʋ nmʋ ba jɩgɩ yazurǝ naa n wʋ pɩɩna digǝ nɩ yɩ dɩ́ ba dɩ́ nii-m?› ");
INSERT INTO xsm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pɛ wʋm laan wʋ́ lǝri o ta dɩ ba o wɩ: ‹A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam nan na kɩ kʋntʋ doŋ á ma á wǝli a nɔɔna bam tɩn, kʋ na maŋɩ kʋ yɩ wʋlʋ na tiini o muri ba maama wʋnɩ tɩn dɩ, kʋ yɩ amʋ mʋ á kɩ kʋntʋ.› ");
INSERT INTO xsm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","O laan ma wʋ́ daarɩ o ta dɩ balʋ na wʋ o jagwiǝ nɩ tɩn o wɩ: ‹Á ve daa a tee nɩ, sɩ abam mʋ yɩ balʋ Wɛ sɔɔla na wʋ á yuu nɩ tɩn. Kɛ-na á vu á zʋ mini dɩlʋ na ba dwe tɩn wʋ, Wɛ na maŋɩ DƖ tiŋi sɩ DƖ pa sʋtaanɩ dɩ dɩ malɛsɩ sɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bɛŋwaanɩ, kana dɛɛn jaanɩ amʋ, yɩ á wʋ pɛ-nɩ wʋdiu sɩ a di. Na-nyɔm dɩ ma ja-nɩ, yɩ á wʋ pɛ-nɩ na sɩ a nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A dɛɛn tu abam sam, yɩ á wʋ kɩ-nɩ voro. A dɛɛn ba jɩgɩ gɔrɔ, yɩ á wʋ pɛ-nɩ gɔrɔ sɩ a zʋ. A dɛɛn ba jɩgɩ yazurǝ, yɩ ba ta kwǝri ba kɩ-nɩ pɩɩna digǝ nɩ, yɩ á wʋ tu sɩ á nii-nɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ba ma wʋ́ lǝri ba bwe-o ba wɩ: ‹Dɩ́ Yuutu, maŋa kɔɔ mʋ dɩbam kɩ nmʋ kʋntʋ? Maŋa kɔɔ mʋ dɩ́ nɛ kana dɩ na-nyɔm na jɩgɩ nmʋ, naa n na yɩ vǝru, naa n ba jɩgɩ gɔrɔ, naa n ba jɩgɩ yazurǝ, naa ba kɩ-m pɩɩna digǝ nɩ, yɩ dɩbam wʋ zǝni-m?› ");
INSERT INTO xsm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","O ma wʋ́ ta dɩ ba o wɩ: ‹A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam na vɩn sɩ á wǝli amʋ nɔɔna bam tɩn, kʋ na maŋɩ kʋ yɩ wʋlʋ na tiini o muri ba maama wʋnɩ tɩn dɩ, kʋ yɩ amʋ mʋ á vɩn sɩ á wǝli.› ");
INSERT INTO xsm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bantʋ laan wʋ́ kɛ ba vu cam dɩlʋ na bá fɔgɩ dɩ ti tɩn wʋnɩ. Kʋ daarɩ Wɛ nɔn-ŋʋna bam ma wʋ́ zʋ DƖ te ba na ŋwɩa kalʋ na ba ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zezi dɛɛn na tagɩ wǝǝnu tɩm kʋntʋ maama o ti tɩn, o laan ma ta dɩ o karabiǝ bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Abam ye sɩ kʋ daarɩ da yale mʋ sɩ Pakɩ candiǝ kam yi, yɩ ba laan wʋ́ ja amʋ Nabiin-bu wʋm ba kɩ dɩdɛɛra jɩa nɩ, sɩ ba pa-nɩ tʋʋn-dagara baŋa nɩ ba gʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam ma kikili daanɩ Kayifu sɔŋɔ nɩ. Wʋntʋ mʋ yɩ ba kaanɩm yuutu. ");
INSERT INTO xsm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ba ma banɩ daanɩ sɩ ba nii, ba na wʋ́ kɩ swan yalʋ ba ma ja Zezi ba gʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba na wʋra ba bwɛ kʋntʋ tɩn, ba ma ta ba wɩ: «Dɩ́ nan wʋ maŋɩ sɩ dɩ́ ja-o candiǝ kam maŋa nɩ, sɩ kʋʋ́ pa vuvugǝ jǝni nɔɔna bam tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zezi dɛɛn maa wʋ Betani nɩ nɔɔnʋ wʋdoŋ sɔŋɔ nɩ, o yɩrɩ mʋ Simɔn. Wʋntʋ dɛɛn ya yɩ nanyɔŋɔ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Zezi na wʋra o di wʋdiu maŋa kalʋ tɩn, mʋ kaanɩ wʋdoŋ tu o te. O maa jɩgɩ kunkwǝlǝ ka na su dɩ tralɩ nugǝ kalʋ sǝbu na daga tɩn. O ma vu o lo nugǝ kam Zezi yuu nɩ sɩ o ma zul-o. ");
INSERT INTO xsm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zezi karabiǝ bam na nɛ kʋntʋ tɩn, ba maa ba jɩgɩ wʋpolo. Ba maa tɛ ba wɩ: «Bɛɛ mʋ yɩ o ja nugǝ kam o cɔgɩ tɩntʋ? ");
INSERT INTO xsm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Dɩ́ ya wʋ́ wanɩ dɩ́ kwe-ka dɩ́ yǝgi sǝbu zanzan dɩ́ ma wǝli yinigǝ tiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zezi ma lwarɩ ba na tɛ kʋlʋ tɩn, yɩ o ta dɩ ba o wɩ: «Bɛɛ mʋ yɩ á jɩgɩ kaanɩ wʋm á yaara? O na kɩ-nɩ zulǝ yalʋ tɩn yɩ kǝm-laa mʋ o kɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kʋ nan na yɩ yinigǝ tiinǝ, bantʋ wʋra mʋ dɩ abam maŋa maama sɩ á taá zǝni-ba. Kʋ daarɩ amʋ nan bá ta wʋra dɩ abam maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kaanɩ wʋm na logi nugǝ kam a yɩra nɩ tɩn, kʋ brɩ nɩ o wuuri o turi a yɩra yam mʋ, sɩ ba laan kwe-nɩ ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A lagɩ a ta cɩga mʋ dɩ abam sɩ, ba na wʋ́ tɔɔlɩ amʋ kwǝr-ywǝŋǝ kam lʋgʋ baŋa je maama nɩ tɩn, baá ta kaanɩ wʋm kʋntʋ dɩ taanɩ sɩ ba taa guli o gulǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kʋntʋ kwaga nɩ, Zudasɩ Yiskarɩyo wʋlʋ na yɩ Zezi karabiǝ fugǝ-bale bam wʋ dɩdʋa tɩn laan ma zaŋɩ o vu Zwifǝ bam kaanɩm yigǝ tiinǝ bam te. ");
INSERT INTO xsm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","O ma bwe-ba o wɩ: «Abam wʋ́ pa amʋ bɛɛ mʋ, sɩ a brɩ abam cwǝŋǝ sɩ á ja Zezi?» Ba na ni kʋntʋ tɩn, ba ma sɛ sɩ ba pa-o sǝbu-dala fiintɔ. ");
INSERT INTO xsm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kʋ na puli maŋa kam kʋntʋ nɩ tɩn, o laan ma kwaanɩ o beeri cwǝŋǝ sɩ o ja Zezi o kɩ ba jɩa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kʋ ma ba kʋ yi dɛ dɩlʋ ba na puli sɩ ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ dɩ wʋnɩ tɩn. Zezi karabiǝ bam ma vu ba bwe-o ba wɩ: «Nmʋ lagɩ sɩ dɩ́ di Pakɩ candiǝ kam jǝgǝ kɔɔ nɩ mʋ, sɩ dɩ́ vu dɩ́ ti woŋo maama yigǝ dɩ́ pa-m?» ");
INSERT INTO xsm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O ma lǝri-ba o wɩ: «Zaŋɩ-na á vu tɩʋ kʋm wʋ nɔɔnʋ doŋ te, sɩ á ta dɩd-o nɩ: ‹Karanyɩna mʋ wɩ, o maŋa kam yiǝ. O nan lagɩ o tɔgɩ dɩ o karabiǝ bam o ba nmʋ sɔŋɔ mʋ, sɩ ba di Pakɩ candiǝ kam wʋdiu da.› » ");
INSERT INTO xsm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","O karabiǝ bam ma vu ba kɩ o na tagɩ kʋlʋ tɩn, yɩ ba kwɛ candiǝ kam wǝǝnu tɩm ba ti. ");
INSERT INTO xsm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tɩga ma ba ka yi. Zezi dɩ o karabiǝ fugǝ-bale bam laan ma jǝni sɩ ba di wʋdiu kʋm. ");
INSERT INTO xsm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ba na wʋra ba di tɩn, Zezi laan ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam wʋ nɔɔnʋ dɩdʋa mʋ lagɩ o yǝgi amʋ o pa nɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ba na ni kʋntʋ tɩn, ba wʋrʋ ma tiini tɩ cɔgɩ zanzan, yɩ ba puli sɩ ba taa bwe-o dɩdʋa dɩdʋa ba wɩ: «Amʋ Yuutu, kʋ yɩ amʋ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O ma lǝri-ba o wɩ: «Nɔɔnʋ wʋlʋ na tɔgɩ dɩ amʋ o lu zʋŋa dɩdʋa wʋnɩ tɩn mʋ lagɩ o yǝgi amʋ o pa nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kʋ nan maŋɩ sɩ amʋ Nabiin-bu wʋm vu a tɩ, nɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ brɩ a taanɩ te tɩn. Kʋ nan za wʋ́ ta yɩ lɛɛrʋ mʋ kʋ pa nɔɔnʋ wʋlʋ na wʋ́ yǝgi amʋ Nabiin-bu wʋm o pa tɩn. Ba ya na maŋɩ ba wʋ lʋgɩ nɔɔnʋ wʋm kʋntʋ, kʋ ya wʋ́ ta gara.» ");
INSERT INTO xsm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudasɩ wʋlʋ na lagɩ o yǝg-o o pa tɩn laan ma bwe-o o wɩ: «Karanyɩna, kʋ yɩ amʋ mʋ na?» Zezi ma lǝr-o o wɩ: «Mʋ ka da n taga.» ");
INSERT INTO xsm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ba na wʋra ba di maŋa kalʋ tɩn, Zezi ma kwe dɩpɛ yɩ o kɩ Wɛ le dɩ ŋwaanɩ. O ma daarɩ o fɔ-dɩ o pa o karabiǝ bam yɩ o wɩ: «Joŋi-na á di, sɩ dɩntʋ yɩ a yɩra mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","O daa ma kwe tweeru biǝ sana dɩ zʋŋa, yɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma kwe o pa-ba yɩ o wɩ: «Abam maama joŋi-na á nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wo-nyɔɔrʋ tɩntʋ mʋ yɩ a jana kalʋ na lagɩ ka nuŋi ka duri sɩ ka ma vrɩ nɔɔna zanzan ba lwarɩm wʋnɩ tɩn. Kʋ maa brɩ nɩ Wɛ goni ni sɩ DƖ yagɩ nɔɔna lwarɩm DƖ ma cɛ-ba amʋ jana kam ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Taá ye-na nɩ, a daa bá nyɔ wo-nyɔɔrʋ tɩntʋ, sɩ kʋ taa ve maŋa kam abam na wʋ́ tɔgɩ dɩ amʋ á jǝni amʋ Ko Wɛ paarɩ dɩm wʋnɩ, sɩ dɩ́ daa nyɔ daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ba laan ma leeni ba zuli Wɛ, yɩ ba daarɩ ba nuŋi ba vu Olivi piu yuu. ");
INSERT INTO xsm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zezi laan ma ta dɩ ba o wɩ: «Tɩtɩɩ dɩntʋ tɩtɩ nɔ́ɔ mʋ abam maama wʋ́ joori amʋ kwaga nɩ, nɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ brɩ te tɩn. Wɛ dɛɛn tagɩ DƖ wɩ: ‹Aá pa ba gʋ nayɩrʋ wʋm, yɩ o peeni sɩm maama jagɩ.› ");
INSERT INTO xsm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kʋ daarɩ, Wɛ na joori DƖ bi-nɩ, aá da yigǝ a vu a taa cǝgi abam Galile nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Zezi na tagɩ kʋntʋ tɩn, Pɩyɛɛrɩ ma ta dɩd-o o wɩ: «Nɔɔna bam maama na maŋɩ ba joori nmʋ kwaga nɩ, amʋ bá fɔgɩ a joori nmʋ kwaga nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Zezi ma ta lǝr-o o wɩ: «A lagɩ a ta cɩga mʋ dɩ nmʋ sɩ, tɩtɩɩ dɩntʋ tɩtɩ nɔ́ɔ mʋ, kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pɩyɛɛrɩ laan ma ta dɩd-o o wɩ: «A brɩ a bá fʋ nɩ a yǝri nmʋ, kʋ na maŋɩ kʋ yɩ ba na lagɩ ba gʋ amʋ dɩ nmʋ maama dɩ.» Zezi karabiǝ bam maama dɩ ma ta kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zezi laan ma zaŋɩ o tɔgɩ dɩ o karabiǝ bam o vu jǝgǝ kadoŋ, gaarɩ na wʋra yɩ ba bǝ-ka nɩ Jesemanɩ tɩn. O ma ta dɩ ba o wɩ: «Á taá je yo, sɩ a vu daa a warɩ Wɛ sɩ a ba.» ");
INSERT INTO xsm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O ma pa Pɩyɛɛrɩ dɩ Zebede biǝ bale bam tɔg-o ba vu. O wʋ ma tiini kʋ cɔgɩ yɩ o bɩcarɩ di. ");
INSERT INTO xsm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","O ma ta dɩ ba o wɩ: «A wʋ mʋ tiini kʋ cɔgɩ sɩ kʋ yi a tʋʋnɩ. Á nan zɩgɩ-na yo, á taá kogili-nɩ sɩ á warɩ Wɛ, sɩ á yɩ zaŋɩ á dɔ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O laan ma fʋfɔ o vu daa. O ma vi o yigǝ tɩga nɩ o wʋra o loori Wɛ yɩ o wɩ: «Amʋ Ko, kʋ na waɩ, sɩ n pa cam dɩlʋ na lagɩ dɩ ba amʋ baŋa nɩ tɩn kɛ. Nmʋ nan kɩ te na yi nmʋ wʋbʋŋa tɩn, sɩ n yɩ kɩ amʋ wʋbʋŋa na lagɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O na loori Wɛ o ti tɩn, o ma joori o vu o karabiǝ batɔ bam te. O ma na nɩ ba tigi ba dɔa. O ma zaŋɩ-ba, yɩ o ta dɩ Pɩyɛɛrɩ o wɩ: «Bɛɛ mʋ yɩ abam warɩ sɩ á kogili amʋ, sɩ á yɩ zaŋɩ á dɔ sɩ kʋ yi mɩmaŋa fɩnfɩɩn dɩ? ");
INSERT INTO xsm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fɔgɩ-na á yɩrɩ á tɩtɩ sɩ á taá loori Wɛ, sɩ á yɩ tʋ maŋɩm dɩm maŋa nɩ. Bɛŋwaanɩ nanzwǝnǝ wʋbʋŋa lagɩ sɩ ya sɛ Baŋa-Wɛ, yɩ o yɩra laan bwǝnǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zezi daa ma joori o vu daa, yɩ o loori Wɛ o wɩ: «Amʋ Ko, cam dɩntʋ na bá wanɩ dɩ lɩ amʋ baŋa nɩ dɩ yagɩ, yɩ a na maŋɩ sɩ a zʋ dɩ wʋ mʋ, amʋ ta sɛ sɩ kʋ kɩ nmʋ wʋbʋŋa na lagɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O daa ma joori o vu o na nɩ ba ta tigi ba dɔa, dɔɔm na tiini dɩ waɩ-ba tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O ma yagɩ-ba, yɩ o joori o vu daa o daa ta loori Wɛ o kɩ kuni bɩtɔ, nɩ o ya na maŋɩ o ta kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","O daa ma joori o vu o karabiǝ bam te, yɩ o ta dɩ ba o wɩ: «Á ta tigi á dɔ mʋ na? Nii-na! Maŋa kam yiǝ, sɩ ba ja amʋ Nabiin-bu wʋm ba kɩ nɔn-balwaarʋ jɩa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Zaŋɩ-na sɩ dɩ́ vu. Nɔɔnʋ wʋlʋ na lagɩ o yǝgi-nɩ o pa tɩn maa bɩɩna.» ");
INSERT INTO xsm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zezi ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, mʋ Zudasɩ wʋlʋ na yɩ o karabiǝ fugǝ-bale bam wʋ dɩdʋa tɩn tu o yi o te, yɩ nɔn-kɔgɔ zanzan tɔgɩ dɩd-o kʋ ba, yɩ ba ze sʋ-lwaanʋ dɩ da-lwaanʋ. Kʋ yɩ Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam mʋ tʋŋɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudasɩ ya maŋɩ o pa kɔgɔ kʋm lwarɩ nɩ, o na ve o kukwǝri nɔɔnʋ wʋlʋ tɩn, sɩ ba ja kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","O laan ma yɔɔrɩ o yi Zezi te o jɔɔn-o yɩ o wɩ: «Karanyɩna, dɩnle», yɩ o daarɩ o kukwǝr-o. ");
INSERT INTO xsm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zezi ma ta dɩd-o o wɩ: «Amʋ ciloŋ, nmʋ na tu sɩ n kɩ kʋlʋ tɩn, kɩ-kʋ lɩla.» Nɔɔna bam laan ma yi ba ja Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nɔɔna balʋ na maŋɩ ba wʋ Zezi tee nɩ tɩn dɩdʋa ma lɩ o sʋgʋ o ma zagɩ kaanɩm yuutu wʋm tɩntʋŋnʋ zwɛ o go. ");
INSERT INTO xsm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zezi ma ta dɩd-o o wɩ: «Joori n sɩn n sʋgʋ kʋm kʋ polo nɩ, sɩ nɔɔnʋ wʋlʋ maama na soe jara dɩ sʋgʋ tɩn, sʋgʋ mʋ wʋ́ gʋ kʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nmʋ yǝri nɩ, a ya na lagɩ zǝnǝ, a ya wʋ́ ta dɩ a Ko Wɛ, yɩ o da o tʋŋɩ malɛsɩ kɔgɔ kuni fugǝ-bɩle, sɩ sɩ ba sɩ wǝli-nɩ na? ");
INSERT INTO xsm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amʋ nan ya na kɩ kʋntʋ, Wɛ tɔnɔ kʋm na brɩ nɩ kʋ maŋɩ sɩ kʋ kɩ amʋ te tɩn daa wʋ́ wanɩ kʋ kɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zezi laan ma bwe kɔgɔ kʋm o wɩ: «Abam na kwe sʋ-lwaanʋ dɩ da-lwaanʋ á ba sɩ á ja amʋ tɩn, a yɩ ŋwɩɩnʋ mʋ na? Dɛ maama a yǝni a je Wɛ-di-kamunu kʋm wʋnɩ a brɩ nɔɔna, yɩ á wʋ jaanɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kʋntʋ maama nan kɩ, sɩ kʋ pa faŋa faŋa Wɛ nijoŋnǝ bam na pʋpʋnɩ kʋlʋ Wɛ tɔnɔ kʋm wʋnɩ tɩn mʋ ba kʋ sɩɩnɩ kʋ kɩ.» Zezi karabiǝ bam na ni kʋntʋ tɩn, ba ma duri ba viiri ba daar-o. ");
INSERT INTO xsm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nɔɔna balʋ na tu ba ja Zezi tɩn ma ja-o ba vu ba kaanɩm yuutu Kayifu sɔŋɔ, mɛ Zwifǝ cullu karanyɩna tiinǝ dɩ ba nakwa bam na maŋɩ ba kikili da tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɩyɛɛrɩ ma dalɩ o tɔgɩ ba kwaga, o da o vu o yi kaanɩm yuutu wʋm sɔŋɔ. O ma zʋ o jǝni sɔŋɔ kʋm tɩntʋŋna bam tee nɩ, sɩ o nii kʋlʋ na lagɩ kʋ kɩ Zezi tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba sarɩya-dirǝ nakwa bam maama maa kwaanɩ sɩ ba na nɔɔna balʋ na wʋ́ fɔ vwan ba pa Zezi tɩn, sɩ kʋ brɩ nɩ kʋ maŋɩ sɩ ba gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nɔɔna zanzan ma zaŋɩ ba fɔ vwan ba pa-o, yɩ ba daa ta wʋ wanɩ ba na kʋlʋ na brɩ nɩ kʋ maŋɩ sɩ ba gʋ-o tɩn. Kʋ kwaga seeni mʋ nɔɔna bale zaŋɩ ba ba, yɩ ba ta ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Nɔɔnʋ wʋntʋ tagɩ o wɩ, wʋm wʋ́ wanɩ o magɩ dɩbam Wɛ-di-kamunu kʋm maama o dɩ tɩga nɩ, yɩ o joori o ma da yatɔ o lɔ-ka.» ");
INSERT INTO xsm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kaanɩm yuutu wʋm na ni kʋntʋ tɩn, o laan ma zaŋɩ o bwe Zezi o wɩ: «Nɔɔna bantʋ na tagɩ kʋlʋ ba pa nmʋ tɩn, nmʋ ba jɩgɩ taanɩ sɩ n lǝri na?» ");
INSERT INTO xsm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Zezi maa cɩm. Kaanɩm yuutu wʋm laan ma ta dɩd-o o wɩ: «Kwarɩ Ŋwɩa Tu Baŋa-Wɛ fʋʋnɩ, sɩ n ta n brɩ dɩbam, nmʋ yɩ Wɛ Bu Krisi wʋm DƖ na tʋŋɩ tɩn mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zezi ma lǝr-o o wɩ: «Mʋ ka da n taga. Amʋ nan lagɩ a ta dɩ abam nɩ, abam wʋ́ ba á na Nabiin-bu wʋm o na je Dam-fɔrɔ Tu Baŋa-Wɛ jazɩm nɩ, yɩ á ta wʋ́ daarɩ á na-o o na nuŋi Wɛ-sɔŋɔ nɩ o maa bɩɩnɩ kunkwǝǝnu wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kaanɩm yuutu wʋm na ni kʋntʋ tɩn, o ma zaŋɩ o kaarɩ o tɩtɩ gɔrɔ, sɩ kʋ brɩ nɩ o wʋ tiini kʋ cɔgɩ dɩ Zezi taanɩ dɩm. O ma ta o wɩ: «Nii-na, o ŋɔɔnɩ o twɩ Wɛ mʋ, o paɩ o dɩ Wɛ ma daanɩ mʋ. Dɩ́ daa ba lagɩ maana tiinǝ sɩ ba ŋɔɔnɩ o taanɩ dɩm. Abam maama maŋɩ á ni, o na ŋɔɔnɩ o twɩ Wɛ te. ");
INSERT INTO xsm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kʋntʋ tɩn, abam wɩ bɛɛ mʋ?» Ba ma lǝr-o ba wɩ: «O maŋɩ sɩ ba gʋ-o mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba laan ma twɩ lileeru ba yagɩ o yiǝ nɩ, yɩ ba mag-o lanyɩranɩ. Badaara ma lɔ o pʋpwaanʋ, ");
INSERT INTO xsm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","yɩ ba wɩ: «Nmʋ na yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, sɩ n lwarɩ n brɩ dɩbam wʋlʋ na magɩ-m tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kantʋ maŋa kam nɩ Pɩyɛɛrɩ maa je kʋnkɔlɔ kʋm wʋnɩ. Kaanɩm yuutu wʋm sɔŋɔ tɩntʋŋ-kana ma vu o te, yɩ o ta dɩd-o o wɩ: «Nmʋ dɩ tɔgɩ dɩ Zezi, Galile tu wʋm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pɩyɛɛrɩ ma fʋ ba maama yigǝ nɩ o wɩ: «A yǝri woŋo kʋlʋ nmʋ na tɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","O ma zaŋɩ o nuŋi mancoŋo ni. Tɩntʋŋ-kana kadoŋ dɩ daa ma na-o, yɩ o ta dɩ nɔɔna balʋ na wʋra tɩn o wɩ: «Nɔɔnʋ wʋntʋ tɔgɩ dɩ Nazarɛtɩ tu Zezi mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pɩyɛɛrɩ ma du durǝ, yɩ o ta fʋ o wɩ: «A brɩ a yǝri nɔɔnʋ wʋm kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kʋ na kɩ fɩɩn tɩn, nɔɔna badonnǝ ma vu ba ta dɩ Pɩyɛɛrɩ ba wɩ: «Nmʋ sɩɩnɩ n yɩ ba kɔgɔ kʋm wʋ nɔɔnʋ dɩdʋa mʋ. Nmʋ ŋwaŋa kam mʋ brɩ nɩ n sɩɩnɩ n nuŋi dáanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","O laan ma sɔɔlɩ o pa o tɩtɩ, sɩ kʋ brɩ nɩ o taanɩ dɩm yɩ cɩga, yɩ o wɩ: «A brɩ a yǝri nɔɔnʋ wʋm kʋntʋ.» O na tagɩ kʋntʋ tɩn, cɩbwɩʋ laan ma da kʋ keeri. ");
INSERT INTO xsm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pɩyɛɛrɩ laan ma guli Zezi ya na tagɩ kʋlʋ dɩd-o o wɩ: «Kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» O na guli kʋntʋ tɩn, o laan ma nuŋi, yɩ o tiini o keeri zanzan. ");
INSERT INTO xsm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tɩga na tu ka pʋʋrɩ tɩtɩɩtɩ tɩn, Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba tɩʋ kʋm nakwa bam maama ma kɩ ni daanɩ, sɩ ba pa ba gʋ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba ma ja-o ba vɔ, yɩ ba ja-o ba vu ba kɩ gʋvɩrma tu Pilatɩ jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudasɩ wʋlʋ na yǝgi Zezi o pa nɔɔna bam tɩn na lwarɩ nɩ ba di o sarɩya yɩ ba lagɩ ba gʋ-o tɩn, o wʋ laan ma cɔgɩ dɩ o na kɩ kʋlʋ tɩn, yɩ o joori o kwe sǝbu-dala fiintɔ kʋm, sɩ o pa kaanɩm yigǝ tiinǝ bam dɩ nakwa bam. ");
INSERT INTO xsm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","O ma ta dɩ ba o wɩ: «Amʋ kɩ wo-balɔrɔ, dɩ a na yǝgi nɔɔnʋ wʋlʋ na wʋ kɩ kʋlʋkʋlʋ tɩn a pa abam yɩ ba lagɩ ba gʋ-o tɩn.» Ba ma lǝr-o ba wɩ: «Dɩbam yigǝ tǝrǝ, kʋ tɔgɩ dɩ n tɩtɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","O laan ma kwe sǝbu kʋm o vu o dɩ o yagɩ Wɛ-di-kamunu kʋm wʋnɩ, yɩ o daarɩ o vu o kuuri ŋʋna o tɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kaanɩm yigǝ tiinǝ bam dɛɛn ma kwe sǝbu kʋm yɩ ba wɩ: «Sǝbu kʋntʋ yɩ jana nyɩm mʋ, kʋ culǝ sɩ dɩ́ gwaanɩ-kʋ Wɛ-digǝ sǝbiǝ bam wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ba ma bwɛ daanɩ, yɩ ba ma-kʋ ba yǝgi tɩga kadoŋ, ka yɩrɩ mʋ Kamɔ-mɔrʋ tɩga, yɩ ba ma kɩ vǝrǝ yibeelǝ jǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kʋntʋ ŋwaanɩ mʋ nɔɔna jɩgɩ jǝgǝ kam kʋntʋ ba ma bǝ nɩ Jana tɩga, sɩ kʋ ba kʋ yi zɩm. ");
INSERT INTO xsm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Kʋntʋ ma pa Wɛ nijoŋnu Zeremi dɛɛn na tagɩ kʋlʋ faŋa faŋa tɩn ba sɩɩnɩ kʋ kɩ. O dɛɛn tagɩ o wɩ: «Ba kwe sǝbu-dala fiintɔ mʋ, ba ma yǝgi kamɔ-mɔrʋ tɩga kam, nɩ Baŋa-Wɛ dɛɛn na pɛ-nɩ ni, sɩ a ta te tɩn. Kʋ maa yɩ sǝbu kʋlʋ Yisɩrayɛlɩ dwi tiinǝ bam na sɛ sɩ ba ma yǝgi nɔɔnʋ wʋm tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Zezi ma zaŋɩ o zɩgɩ gʋvɩrma tu Pilatɩ yigǝ nɩ. Gʋvɩrma tu wʋm ma bwe-o o wɩ: «Nmʋ mʋ yɩ Zwifǝ bam pɛ wʋm na?» Zezi ma lǝr-o o wɩ: «Mʋ ka da n taga.» ");
INSERT INTO xsm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kʋ daarɩ Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba nakwa bam na ŋɔɔnɩ taanɩ dɩlʋ maama ba pa-o tɩn, o wʋ lǝri kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatɩ ma ta dɩd-o o wɩ: «Nmʋ wʋ ni ba na ŋɔɔnɩ kʋlʋ maama ba pa nmʋ tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Zezi ma wʋ sɛ sɩ o lǝri ba taanɩ dɩm dɩlʋdɩlʋ. Kʋ ma pa gʋvɩrma tu wʋm tiini o yɩ yǝǝu dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɩm maama Pakɩ candiǝ kam maŋa na yǝni ka yi, gʋvɩrma tu wʋm yǝni o lɩ pɩɩnʋ dɩdʋa mʋ o pa nɔn-kɔgɔ kʋm, nɩnɛɛnɩ bantʋ na lagɩ wʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kantʋ maŋa kam nɩ pɩɩnʋ wʋdoŋ maa wʋra, o yɩrɩ mʋ Barabasɩ. Nɔɔna maama dɛɛn ye o kǝm-balwaarʋ tɩm ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nɔɔna bam na tu ba la daanɩ tɩn, Pilatɩ ma bwe-ba o wɩ: «Abam lagɩ sɩ a yagɩ bantʋ wɔɔ mʋ a pa abam? Kʋ yɩ Barabasɩ mʋ naa Zezi wʋlʋ ba na bǝ-o nɩ Krisi tɩn mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","O dɛɛn bwe-ba kʋntʋ, bɛŋwaanɩ o ye nɩ, kʋ yɩ wʋ-gʋrʋ ŋwaanɩ mʋ ba jaanɩ Zezi ba kɩ o jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatɩ na je sarɩya dim jǝgǝ kam nɩ tɩn, o kaanɩ ma tʋŋɩ ni o pa-o o wɩ: «Yɩ zaŋɩ n kɩ nɔɔnʋ wʋm kʋntʋ kʋlʋkʋlʋ, o na jɩgɩ cɩga tɩn ŋwaanɩ. Bɛŋwaanɩ tɩtɩɩ dɩntʋ nɩ amʋ tiini a na yaara zanzan dɩ nɔɔnʋ wʋm kʋntʋ dɩndwɩa wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba nakwa bam ma sʋgɩ nɔn-kɔgɔ kʋm, sɩ ba ta dɩ Pilatɩ nɩ, o yagɩ Barabasɩ o pa-ba, sɩ o daarɩ o pa ba gʋ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatɩ daa ma joori o bwe-ba o wɩ: «Nɔɔna bantʋ bale wʋnɩ, abam lagɩ sɩ a yagɩ wɔɔ mʋ a pa abam?» Ba ma lǝr-o ba wɩ: «Barabasɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatɩ laan ma bwe-ba o wɩ: «Sɩ kʋ na yɩ Zezi wʋlʋ ba na bǝ-o nɩ Krisi tɩn, abam wɩ a kɩ-o ta mʋ?» Ba maama ma ta dɩd-o ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","O ma joori o bwe-ba o wɩ: «Wʋntʋ kɩ bɛɛ mʋ o cɔgɩ?» Ba laan ma tiini ba kaasɩ baŋa baŋa ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatɩ ma lwarɩ nɩ kʋ ba jɩgɩ kuri sɩ o taa ŋɔɔnɩ taan taan, kʋ na lagɩ kʋ ja bʋbwaka kʋ ba tɩn ŋwaanɩ. O ma joŋi na o ma san o jɩa nɔn-kɔgɔ kʋm maama yigǝ nɩ, yɩ o wɩ: «A yigǝ tɔgɩ ka tǝri nɔɔnʋ wʋntʋ tʋʋnɩ dɩm wʋnɩ. Kʋ yɩ abam yigǝ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɔn-kɔgɔ kʋm maama ma lǝr-o ba wɩ: «Yagɩ sɩ o tʋʋnɩ dɩm caa taa tɔgɩ dɩbam dɩ dɩ́ biǝ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","O laan ma yagɩ Barabasɩ o pa-ba. O ma daarɩ o pa ba magɩ Zezi, yɩ o pa-ba cwǝŋǝ sɩ ba ja-o ba vu ba pa tʋʋn-dagara baŋa nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gʋvɩrma tu wʋm pamaŋna bam laan ma ja Zezi ba vu ba zʋ o sɔŋɔ kʋm kʋnkɔlɔ. Pamaŋna kɔgɔ kʋm maama ma gilim-o da. ");
INSERT INTO xsm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ba ma lɩ o gwaarʋ tɩm, yɩ ba daarɩ ba zʋ-o gwar-sʋŋʋ. ");
INSERT INTO xsm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ba ma sɔ sabarɩ yipugǝ ba pu o yuu nɩ. Ba ma kwe miu ba ma ji nacǝgǝ ba kɩ o jazɩm nɩ. Ba laan ma yáal-o ba mwana, yɩ ba ve ba kuni doonǝ o yigǝ nɩ, yɩ ba tɛ ba wɩ: «Zwifǝ bam pɛ, dɩnle.» ");
INSERT INTO xsm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba ma daarɩ ba twɩ lileeru ba yagɩ o yɩra nɩ, yɩ ba jɩgɩ miu kʋm ba lɔɛ o yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ba na mwan-o ba ti tɩn, ba laan ma lɩ gwar-sʋŋʋ kʋm, yɩ ba daarɩ ba joori ba zʋ-o o tɩtɩ gwaarʋ tɩm. Ba laan ma ja-o ba nuŋi ba vu sɩ ba pa-o tʋʋn-dagara baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ba na jɩg-o ba maa kɛ tɩn, ba ma jeeri nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Simɔn o nuŋi Sirɛɛnɩ mʋ. Pamaŋna bam ma fɩ-o ba pa o joŋi tʋʋn-dagara kam o zɩŋɩ sɩ ba vu. ");
INSERT INTO xsm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ba maama ma vu ba yi jǝgǝ kadoŋ ba na bǝ sɩ Goligota tɩn. Yɩrɩ dɩm kʋntʋ kuri mʋ Yukol-pʋa piu. ");
INSERT INTO xsm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ba na yi da tɩn, ba ma kɩ sana ba gwaanɩ dɩ liri sɩlʋ ni na cana tɩn ba pa Zezi sɩ o nyɔ. O ma laŋɩ o nii, yɩ o wʋ sɛ sɩ o nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ba laan ma ja-o ba pa tʋʋn-dagara kam baŋa nɩ. Ba na pag-o kʋntʋ tɩn, ba ma kwe o gwaarʋ tɩm sɩ ba maŋɩ-tɩ ba pa daanɩ. Ba ma ta jɔrɔ sɩ ba nii, wɔɔ mʋ wʋ́ twǝri kʋlʋ o na lagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ba laan ma je da ba yɩr-o. ");
INSERT INTO xsm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ba dɛɛn ma tanɩ tɔnɔ dagara kam yɩra nɩ Zezi yuu baŋa nɩ, sɩ kʋ brɩ kʋlʋ o na kɩ o cɔgɩ yɩ ba gʋ-o tɩn. Ba dɛɛn pʋpʋnɩ ba wɩ: «Wʋntʋ yɩ Zezi wʋlʋ na yɩ Zwifǝ bam pɛ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ba ma daarɩ ba ja ŋwɩɩna bale ba pa dagarɩ sɩdonnǝ baŋa nɩ. Ba ma cwi dɩdʋa Zezi jazɩm nɩ. Wʋwʋm maa wʋ o jagwiǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nɔɔna balʋ na tɔgɩ da ba kɛ tɩn maa niǝ, yɩ ba gɔgɩsɩ ba yuni yɩ ba twɩ-o. Ba maa yáal-o, ");
INSERT INTO xsm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yɩ ba wɩ: «Nmʋ ya na bʋŋɩ sɩ n cɔgɩ Wɛ-di-kamunu kʋm n dɩ tɩga nɩ sɩ n daarɩ n ma da yatɔ n joori n fɔgɩ n lɔ-ka tɩn, nmʋ na sɩɩnɩ n yɩ Baŋa-Wɛ Bu, sɩ n laan vrɩ n tɩtɩ, n tu dagara kam yuu nɩ sɩ dɩ́ nii.» ");
INSERT INTO xsm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ dɩ ba cullu karanyɩna tiinǝ bam dɩ maa twɩ-o ba mwana, yɩ ba tɛ daanɩ ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«O yǝni o vrɩ nɔɔna badonnǝ ŋwɩa, yɩ o laan warɩ o tɩtɩ ŋwɩa o vrɩ. O maa brɩ nɩ o yɩ Yisɩrayɛlɩ dwi tiinǝ pɛ mʋ. O laan nan tu dagara kam yuu nɩ lele sɩ dɩ́ nii, sɩ dɩ́ wʋ́ ba dɩ́ sɩɩnɩ dɩ́ sɛ-o. ");
INSERT INTO xsm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O ta brɩ nɩ o tɩɩgɩ Wɛ, yɩ o tɛ sɩ o yɩ Wɛ Bu mʋ. Kʋntʋ, Wɛ na sɩɩnɩ DƖ lag-o, sɩ DƖ laan joŋ-o DƖ yagɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ŋwɩɩna balʋ ba na pagɩ dagarɩ sɩm baŋa nɩ ba wǝli da tɩn dɩ maa jɩg-o ba twɩ kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kʋ ma vu kʋ yi maŋa kam wɛ na tu dɩ yi yuparɩ baŋa nɩ tɩn. Lʋgʋ kʋm maama ma ba kʋ ji lim kʋ vu kʋ yi wɛ-gunim maŋa nɩ, ");
INSERT INTO xsm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","kʋ kɩ nɩnɛɛnɩ luu batɔ mʋ te. Maŋa kam kʋntʋ nɩ Zezi laan ma kaasɩ baŋa baŋa dɩ kwǝr-dɩa o wɩ: «Eli, Eli, lɛma sabakɩtani?» Taanɩ dɩntʋ kuri mʋ: «Amʋ Wɛ, amʋ Wɛ, bɛɛ mʋ kɩ yɩ n yagɩ amʋ?» ");
INSERT INTO xsm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nɔɔna balʋ na zɩgɩ da yɩ ba ni taanɩ dɩm tɩn ma bʋŋɩ nɩ, o bǝ Eli mʋ sɩ o ba. ");
INSERT INTO xsm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba dɩdʋa ma kɩ lɩla o duri o vu o kwe sɩpɔɔ. O ma dɩ-kʋ sa-nywana wʋnɩ, yɩ o daarɩ o kɩ-kʋ miu ni nɩ, o vu o te o pa Zezi sɩ o nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nɔɔna badaara bam na nɛ kʋntʋ tɩn, ba maa wɩ: «Yagɩ sɩ dɩ́ cǝgi dɩ́ nii, Eli wʋ́ ba o joŋ-o o yagɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zezi daa ma joori o kaasɩ dɩ kwǝr-dɩa baŋa baŋa. O laan ma pa o siun ti. ");
INSERT INTO xsm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Zezi na tɩgɩ kʋntʋ tɩn, gɔrɔ kʋlʋ ba na lǝgi ba ma cɩ Wɛ-di-laa kʋm tɩn ma kaarɩ bɩle, kʋ zɩgɩ baŋa nɩ kʋ tu kʋ kwaarɩ kʋ kuri. Tɩga kam maa sisiŋǝ, yɩ pulwaarʋ bagɩ tɩ yarɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yibeelǝ yam ma puri. Kʋ daarɩ Wɛ nɔn-ŋʋna balʋ ya na tɩgɩ tɩn zanzan ma joori ba bi ba yagɩ tʋʋnɩ, ");
INSERT INTO xsm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","yɩ ba nuŋi ba yibeelǝ wʋnɩ, maŋa kalʋ Zezi tɩtɩ na tu o bi o yagɩ tʋʋnɩ tɩn kwaga nɩ. Bantʋ laan ma vu ba zʋ Wɛ tɩtɩ tɩʋ Zeruzalɛm wʋ ba pa nɔɔna zanzan na-ba. ");
INSERT INTO xsm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pamaŋna bam yigǝ tu wʋm dɩ o nɔɔna balʋ na wʋra ba yɩrɩ Zezi tɩn ma na tɩga kam sisiŋim dɩm, dɩ kʋlʋ maama na kɩ tɩn. Fʋʋnɩ ma tiini dɩ zʋ-ba, yɩ ba tɛ ba wɩ: «Nɔɔnʋ wʋntʋ ya sɩɩnɩ o yɩ Baŋa-Wɛ Bu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kaana zanzan dɩ tɔgɩ ba wʋra, ba ma zɩgɩ yigǝ yigǝ yɩ ba niǝ. Bantʋ dɛɛn ya tɔgɩ dɩ Zezi mʋ ba nuŋi Galile ba ba, yɩ ba yǝni ba tɔgɩ ba zǝn-o. ");
INSERT INTO xsm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mari wʋlʋ na nuŋi Magɩdala tɩn dɛɛn tɔgɩ o wʋ kaana bam kʋntʋ wʋnɩ, dɩdaanɩ Mari wʋlʋ na yɩ Zakɩ dɩ Zʋzɛfʋ nu tɩn, kʋ wǝli dɩ Zebede biǝ bam nu. ");
INSERT INTO xsm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Zʋzɛfʋ, o na nuŋi Arimatɩ, yɩ o kwǝri o yɩ nadum. Wʋntʋ dɩ dɛɛn yɩ Zezi karabu mʋ. Tɩga dɛɛn na lagɩ ka yi tɩn, ");
INSERT INTO xsm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","o ma zaŋɩ o vu Pilatɩ te, sɩ o loor-o cwǝŋǝ sɩ o vu o kwe Zezi yɩra yam o kɩ. Pilatɩ ma sɛ, yɩ o pa ni sɩ ba kwe Zezi yɩra yam ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zʋzɛfʋ laan ma vu o kwe Zezi yɩra yam o pipiri-ya dɩ gar-jalɩ dɩlʋ na lana tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ba ma daarɩ ba kwe-ya ba ja vu ba tiŋi piu bɔɔnɩ wʋnɩ. Dɩntʋ maŋɩ dɩ yɩ o tɩtɩ nyɩm mʋ, ba dɛɛn lugi-dɩ piu yɩra nɩ mʋ. Dɩ yɩ bɔn-dʋʋrɩ mʋ. Ba na tiŋi Zezi yɩra yam da tɩn, ba laan ma bibili kandwɛ-pulɔgɔ kamunu ba ma pɩ bɔɔnɩ dɩm ni, yɩ ba daarɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ba na wʋra ba kɩ-o kʋntʋ tɩn, Mari wʋlʋ na nuŋi Magɩdala tɩn dɩ Mari wʋdoŋ wʋm maa je yibeeli dɩm yigǝ nɩ ba niǝ. ");
INSERT INTO xsm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dɛ dɩm Zwifǝ bam na yǝni ba ti ba yigǝ sɩ ba siun dɛ dɩm laan yi tɩn ma kɛ. Tɩga na pʋʋrɩ yɩ kʋ yɩ ba siun dɛ dɩm tɩn, Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam laan ma zaŋɩ ba vu Pilatɩ te. ");
INSERT INTO xsm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ba ma ta dɩd-o ba wɩ: «Dɩbam tu, dɩ́ guli nɩ, vwan nyɩm wʋm ya na wʋra maŋa kalʋ tɩn, o dɛɛn tagɩ o wɩ, wʋm wʋ́ joori o bi da yatɔ dɛ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kʋntʋ ŋwaanɩ, nan pa ni sɩ nɔɔna wuuri ba vu ba fǝri yibeeli dɩm ni, sɩ ba fɔgɩ ba taa yɩrɩ-dɩ sɩ kʋ vu kʋ yi da yatɔ yam. Kʋ na daɩ kʋntʋ, o karabiǝ bam wʋ́ wanɩ ba vu ba kwe-o ba ja viiri, yɩ ba daarɩ ba ta dɩ nɔɔna ba wɩ, o bi o yagɩ tʋʋnɩ mʋ. Kʋntʋ ma wʋ́ pa ba vwan yam laan tiini ya ji cɩga kʋ dwǝni pulim dɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatɩ ma sɛ yɩ o wɩ: «Abam jɩgɩ nɔɔna. Nan pa-na ba vu sɩ ba kwaanɩ ba taa yɩrɩ-dɩ, sɩ kʋ maŋɩ dɩ abam na lagɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ba ma zaŋɩ ba vu yibeeli dɩm jǝgǝ kam, ba fǝri dɩ ni kandwɛ kamunu kʋm na pɩ tɩn. Ba ma daarɩ ba yagɩ nɔɔna da sɩ ba taa yɩrɩ-dɩ. ");
INSERT INTO xsm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ba siun dɛ dɩm na kɛ tɩn, tɩ-bra-pʋra nɩ Mari wʋlʋ na nuŋi Magɩdala tɩn dɩ Mari wʋdoŋ wʋm ma zaŋɩ ba vu yibeeli dɩm jǝgǝ kam sɩ ba nii. ");
INSERT INTO xsm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tɩga ma da ka sisiŋi zanzan. Baŋa-Wɛ malɛka ma nuŋi wɛyuu nɩ, ka tu ka ba ka bibili kandwɛ kamunu kʋm ka yagɩ daa nɩ, yɩ ka daarɩ ka jǝni dɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ka yibiyǝ maa tiini ka nyɩɩna nɩ dʋa na pɩpɩlɩ te tɩn, yɩ ka gwaarʋ tɩm dɩ tiini tɩ pɩɩrɩ parɩ parɩ. ");
INSERT INTO xsm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nɔɔna balʋ na wʋra ba yɩrɩ yibeeli dɩm tɩn ma bǝri dɩ fʋʋnɩ nɩnɛɛnɩ ba tɩgɩ mʋ te. ");
INSERT INTO xsm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malɛka kam laan ma ta dɩ kaana bam ka wɩ: «Á yɩ taá kwarɩ fʋʋnɩ. Amʋ ye nɩ abam lagɩ sɩ á na Zezi wʋlʋ ba na jaanɩ ba pa tʋʋn-dagara kam baŋa nɩ ba gʋ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O nan tǝri yo. O joori o bi o yagɩ tʋʋnɩ, nɩnɛɛnɩ o ya na maŋɩ o ta kʋlʋ dɩ abam tɩn. Nan ba-na á nii o yɩra yam ya na tigi mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Abam nan kɩ lɩla á vu á ta dɩ o karabiǝ bam nɩ, Wɛ pɛ o joori o bi o yagɩ tʋʋnɩ, yɩ o laan wʋ́ da yigǝ o vu o taa cǝgi abam Galile nɩ. Dáanɩ mʋ á wʋ́ vu á na-o. Mʋ kʋlʋ a na lagɩ a ta a brɩ abam tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Malɛka kam na tagɩ kʋntʋ tɩn, kaana bam ma kɩ lɩla ba nuŋi yibeeli dɩm jǝgǝ kam nɩ ba maa kɛa, yɩ fʋʋnɩ dɩ wʋpolo kamunu jɩgɩ-ba. Ba ma duri ba vu sɩ ba ta dɩ Zezi karabiǝ bam kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ba na maa kɛ tɩn, Zezi ma da o jeeri-ba, yɩ o kɩ-ba le. Ba ma vu ba yi o te, ba kuni doonǝ ba ja o nɛ yɩ ba zul-o. ");
INSERT INTO xsm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Zezi ma ta dɩ ba o wɩ: «Á yɩ taá kwarɩ fʋʋnɩ. Ve-na a ko-biǝ bam te, sɩ á ta dɩ ba sɩ ba vu Galile, sɩ dáanɩ mʋ baá na amʋ.» ");
INSERT INTO xsm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kaana bam na nuŋi yibeeli dɩm jǝgǝ kam nɩ kʋntʋ tɩn, nɔɔna balʋ na wʋra ba yɩrɩ-dɩ tɩn badaara ma zaŋɩ ba joori ba vu tɩʋ kʋm wʋ, yɩ ba ta kʋlʋ maama na kɩ tɩn ba brɩ Zwifǝ kaanɩm yigǝ tiinǝ bam. ");
INSERT INTO xsm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kaanɩm yigǝ tiinǝ bam laan ma vu ba ŋɔɔnɩ dɩ tɩʋ kʋm nakwa bam. Ba ma kɩ ni daanɩ yɩ ba kwe sǝbu-fɔrɔ ba pa pamaŋna bam, ");
INSERT INTO xsm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yɩ ba wɩ: «Abam maŋɩ sɩ á ta nɩ, Zezi karabiǝ bam mʋ tu tɩtɩɩ nɩ, ba ŋɔ o yɩra yam ba kwe ba ja viiri, yɩ abam tigi á dɔa. ");
INSERT INTO xsm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gʋvɩrma tu wʋm nan na tu o lwarɩ kʋ ni nɩ, yɩ kʋ na jɩgɩ taanɩ, dɩbam wʋ́ ŋɔɔnɩ dɩ́ joŋi abam dɩ́ yagɩ, sɩ liǝ yɩ taa jɩgɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pamaŋna bam ma joŋi sǝbu kʋm, yɩ ba sɩɩnɩ ba kɩ kʋlʋ ba na tagɩ-ba sɩ ba kɩ tɩn. Mʋ taanɩ dɩntʋ mʋ Zwifǝ bam jɩgɩ ba tɛa, kʋ ba kʋ yi zɩm maama. ");
INSERT INTO xsm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zezi karabiǝ fugǝ-dɩdʋa kam laan ma zaŋɩ ba vu Galile, piu kʋlʋ yuu nɩ o na maŋɩ o ta dɩ ba sɩ ba vu tɩn. ");
INSERT INTO xsm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ba ma sɩɩnɩ ba vu ba na-o, yɩ ba kuni doonǝ ba zul-o. Badaara maa ta jɩgɩ bʋbwɛa dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Zezi laan ma vu o yi ba te, yɩ o ta dɩ ba o wɩ: «Wɛ pɛ-nɩ dam sɩ a taa te wɛyuu dɩ tɩga baŋa wǝǝnu maama. ");
INSERT INTO xsm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kʋntʋ ŋwaanɩ, nan ve-na lʋgʋ baŋa dwi tiinǝ maama te, sɩ á pa ba ji amʋ karabiǝ, sɩ á daarɩ á miisi-ba na wʋnɩ dɩ amʋ Ko Wɛ yɩrɩ, dɩ amʋ na yɩ DƖ Bu tɩn yɩrɩ, dɩ DƖ Joro kʋm yɩrɩ ŋwaanɩ, ");
INSERT INTO xsm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","sɩ á daarɩ á brɩ-ba sɩ ba sɛ woŋo kʋlʋ maama amʋ na pɛ abam ni sɩ á kɩ tɩn. Nan taá ye-na nɩ, amʋ wʋ́ ta wʋra dɩ abam maŋa maama, sɩ kʋ vu kʋ yi lʋgʋ tiim maŋa.»");
INSERT INTO xsm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Baŋa-Wɛ Bu Zezi Krisi kwǝr-ywǝŋǝ kam na puli te tɩn mʋ tɩntʋ: ");
INSERT INTO xsm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kʋ kɩ nɩ Wɛ nijoŋnu Ezayi na maŋɩ o pʋpʋnɩ kʋlʋ faŋa faŋa yɩ o tɔɔlɩ Wɛ kwǝrǝ o wɩ: «Nii, amʋ Wɛ lagɩ a tʋŋɩ a nɔɔnʋ mʋ, sɩ o da nmʋ yigǝ o vu o kwɛ cwǝŋǝ kalʋ nmʋ na wʋ́ ba n tɔgɩ da tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","«Nɔɔnʋ mʋ wʋ kagʋa wʋnɩ o tɔɔlɩ kwǝrǝ o wɩ: ‹Zaŋɩ-na á fɔgɩ á kwɛ dɩ́ Yuutu wʋm cwǝŋǝ kam, o na lagɩ o ba o tɔgɩ da tɩn. Pa-na cwe sɩlʋ o na lagɩ o ba o tɔgɩ tɩn fɔgɩ sɩ yɔɔrɩ lanyɩranɩ.› » ");
INSERT INTO xsm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kʋ dɛɛn sɩɩnɩ kʋ kɩ kʋntʋ doŋ mʋ. Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Zan. O maa wʋ kagʋa wʋnɩ, yɩ o miisi nɔɔna na wʋnɩ Wɛ ŋwaanɩ. O maa yǝni o tɔɔlɩ Wɛ kwǝrǝ, o brɩ nɔɔna nɩ ba maŋɩ sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, sɩ ba daarɩ ba pa o miisi-ba na wʋnɩ, sɩ Wɛ laan wʋ́ yagɩ ba lwarɩm DƖ ma cɛ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nɔɔna zanzan maa yǝni ba nuŋi Zude tɩ-biǝ bam maama dɩ Zeruzalɛm ba ve o te. Ba na ve o te kʋntʋ tɩn, ba maa tɛ ba brɩ kʋlʋ ba na kɩ ba cɔgɩ tɩn. O laan maa paɩ ba tu Zʋrdɛn bugǝ kam wʋnɩ, yɩ o miisi-ba na wʋnɩ Wɛ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zan dɛɛn zʋʋrɩ gɔrɔ kʋlʋ ba na sɔgɩ dɩ yogondi kʋrʋ tɩn mʋ. O maa maɩ kilǝ o ja o tǝŋǝ. O wʋdiu mʋ yɩ kayɩra dɩ tʋʋrʋ. ");
INSERT INTO xsm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O maa tɔɔlɩ Wɛ kwǝrǝ dɩ nɔɔna bam o wɩ: «Nɔɔnʋ wʋdoŋ wʋ́ saŋɩ amʋ kwaga o ba, wʋntʋ tiini o dwe amʋ. A wʋ maŋɩ sɩ a tiiri a lɩ o nɛ natra a pa-o. ");
INSERT INTO xsm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Amʋ miisi abam na wʋnɩ mʋ. Wʋntʋ nan na tuǝ, oó miisi abam Wɛ Joro kʋm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Maŋa kam kʋntʋ nɩ, Zezi dɛɛn ma nuŋi Galile tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Nazarɛtɩ. O ma vu o yi Zan te, yɩ o tu Zʋrdɛn bugǝ kam wʋ yɩ Zan miis-o na wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zezi na maa nuŋi na bam wʋnɩ tɩn, o ma na wɛyuu na pʋrɩ yɩ Wɛ Joro kʋm tɔgɩ da kʋ tu o baŋa, yɩ kʋ nyɩ dɩ kunkwǝŋǝ te. ");
INSERT INTO xsm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","O ma ni kwǝrǝ laan na ŋɔɔnɩ wɛyuu nɩ ka wɩ: «Nmʋ mʋ yɩ amʋ bu-dʋa a na soe dɩ a wʋ maama. A tiini a jɩgɩ wʋpolo zanzan dɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kʋ na-niǝ da mʋ Wɛ Joro kʋm dɛ kʋ pa o vu kagʋa wʋ. ");
INSERT INTO xsm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O maa wʋ kagʋa kam wʋnɩ taan da fiinna. O na wʋra tɩn, sʋtaanɩ laan ma tui o te, sɩ dɩ gan-o sɩ o ya kɩ o cɔgɩ. O maa zʋʋrɩ dɩ kagʋ-vara, yɩ Wɛ malɛsɩ dɩ tui o te sɩ zǝn-o. ");
INSERT INTO xsm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ba dɛɛn ma ja Zan ba kɩ pɩɩna digǝ nɩ. Kʋntʋ kwaga nɩ Zezi ma joori o vu Galile. O maa wʋra o tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam o brɩ nɔɔna, ");
INSERT INTO xsm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","yɩ o wɩ: «Maŋa kam laan yiǝ, Wɛ paarɩ dɩm na lagɩ dɩ ba nɔɔna tɩtarɩ nɩ tɩn. Kʋntʋ ŋwaanɩ, lǝni-na á wʋrʋ á yagɩ kǝm-balwaarʋ tɩm, sɩ á daarɩ á sɛ Wɛ kwǝr-ywǝŋǝ kam.» ");
INSERT INTO xsm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Zezi dɛɛn maa wʋ Galile nɩnɩʋ kʋm ni nɩ o veǝ. O ma na nɔɔna bale, ba na yɩ cʋrʋ. Ba dɩdʋa yɩrɩ mʋ Simɔn. O nyaanɩ yɩrɩ mʋ Andre. Ba yɩ kalǝŋ-jara mʋ. Ba maa wʋ na bam wʋnɩ ba dʋlɩ bʋrɩ sɩ ba ma ja kale. ");
INSERT INTO xsm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zezi ma ta dɩ ba o wɩ: «Zaŋɩ-na á ba á taá tɔgɩ amʋ. Aá pa á taá beeri nɔɔna mʋ á pa-nɩ, sɩ ba taa tɔgɩ-nɩ, nɩ á na yǝni á jaanɩ kale te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","O na tagɩ kʋntʋ tɩn, ba ma zaŋɩ lɩla ba yagɩ ba bʋrɩ sɩm, yɩ ba vu ba tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zezi na ve yigǝ fɩnfɩɩn tɩn, o daa ma na nɔɔna bale. Ba dɩdʋa yɩrɩ mʋ Zakɩ. O nyaanɩ dɩ maa wʋra, o yɩrɩ mʋ Zan. Ba ko yɩrɩ mʋ Zebede. Ba maa wʋ naboro wʋnɩ ba kwɛ ba bʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","O laan ma bǝŋi-ba. O na bǝŋi-ba kʋntʋ tɩn, ba ma zaŋɩ lɩla ba yagɩ ba ko wʋm dɩ o tɩntʋŋna bam naboro kʋm wʋnɩ, yɩ ba vu ba tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zezi dɩ o karabiǝ ma tɔgɩ daanɩ ba vu ba zʋ tɩʋ kʋdoŋ wʋ, kʋ yɩrɩ mʋ Kapɛrnawum. Zwifǝ bam siun dɛ na yi tɩn, Zezi ma vu o zʋ ba Wɛ-digǝ kam sɩ o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","O na brɩ-ba tɩn, nɔɔna balʋ na wʋra tɩn maa tiini ba yɩ yǝǝu dɩ o zaasɩm dɩm, bɛŋwaanɩ o ni-taanɩ dɩm jɩgɩ dam dɩ dwe ba tɩtɩ cullu karanyɩna tiinǝ bam taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɔɔnʋ wʋdoŋ dɛɛn maa wʋ ba Wɛ-digǝ kam wʋnɩ, yɩ cicirǝ jɩg-o. O ma kaasɩ dɩ kwǝr-dɩa o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Zezi, Nazarɛtɩ tu, bɛɛ mʋ n lagɩ dɩbam tee nɩ? Nmʋ tu sɩ n cɔgɩ dɩbam dwi mʋ na? A ye nmʋ na yɩ wʋlʋ. Nmʋ yɩ Wʋ-poŋo Tu wʋlʋ Wɛ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zezi ma kaanɩ cicirǝ kam o wɩ: «Cǝgi sɔɔ, sɩ n nuŋi n daarɩ baarʋ wʋm.» ");
INSERT INTO xsm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","O na tagɩ kʋntʋ tɩn, cicirǝ kam ma tiini ka ja nɔɔnʋ wʋm ka su. Ka ma kaasɩ dɩ kwǝr-dɩa yɩ ka nuŋi ka daarɩ nɔɔnʋ wʋm. ");
INSERT INTO xsm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nɔɔna bam na nɛ kʋntʋ tɩn, kʋ ma sʋ ba maama lanyɩranɩ, yɩ ba bwe daanɩ ba wɩ: «Bɛɛ mʋ kʋntʋ? O brɩ cwǝ-dʋŋa mʋ yɩ o zaasɩm dɩm jɩgɩ dam. Nii, o na tɛ ciciri nɩ sɩ viiri, yɩ sɩ sɛ o ni.» ");
INSERT INTO xsm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɔɔna balʋ maama na zʋʋrɩ Galile je sɩm nɩ tɩn dɛɛn ma ni Zezi ŋwa lɩla. ");
INSERT INTO xsm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zezi dɩ o nɔɔna bam ma nuŋi Wɛ-digǝ kam nɩ, ba tɔgɩ dɩ Zakɩ dɩ Zan ba vu ba yi Simɔn dɩ Andre-ba sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Paa maa jɩgɩ Simɔn tɩnkaanɩ yɩ o tigǝ. Ba ma ta dɩ Zezi kʋ na kɩ-o te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","O ma vu kaanɩ wʋm te, o ja o jɩŋa o pa o zaŋɩ wɛɛnɩ. Paa kam ma da ka yag-o. O ma zaŋɩ o kɩ wʋdiu o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wɛ na zʋ yɩ tɩga wʋra ka yi tɩn, nɔɔna maa jaanɩ balʋ maama na yɩ yawɩɩna dɩ ciciri na jɩgɩ balʋ maama tɩn ba tui Zezi te. ");
INSERT INTO xsm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tɩʋ kʋm nɔɔna bam maama ma vu ba gilimi Simɔn-ba sɔŋɔ ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zezi ma pa nɔɔna zanzan na yazurǝ dɩ ba yawɩɩrʋ dwi dwi, yɩ o daarɩ o zǝli ciciri zanzan nɔɔna yɩra nɩ. O ma wʋ sɛ sɩ ciciri sɩm ŋɔɔnɩ kʋlʋkʋlʋ, sɩ na maŋɩ sɩ ye o na yɩ wʋlʋ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tɩga na pʋʋrɩ tɩtɩɩtɩ yɩ wɛ daa ta wʋ puli tɩn, Zezi ma zaŋɩ o nuŋi o vu jǝgǝ kalʋ nɔɔn-nɔɔnʋ na tǝrǝ tɩn. O wʋra o warɩ Wɛ o yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔn-ba laan ma zaŋɩ ba nuŋi sɩ ba beeri o jǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ba na nɛ-o tɩn, ba ma ta dɩd-o ba wɩ: «Nɔɔna bam maama lagɩ sɩ ba na nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Zezi ma lǝri-ba o wɩ: «Zaŋɩ-na sɩ dɩ́ kɛ dɩ́ vu je sɩdonnǝ. A maŋɩ sɩ a vu tɩ-balwa balʋ na wʋ yoba seeni tɩn a tɔɔlɩ Wɛ kwǝrǝ kam. Kʋ yɩ kʋntʋ ŋwaanɩ mʋ a nuŋi Wɛ te a ba.» ");
INSERT INTO xsm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","O laan ma beeri o tɔgɩ Galile wʋ maama. O maa yǝni o zʋʋrɩ Zwifǝ bam Wɛ-di sɩm. O maa brɩ nɔɔna Wɛ cɩga kam, yɩ o zǝli ciciri nɔɔna yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o na yɩ nanyɔŋɔ. O ma zaŋɩ o vu Zezi te, o kuni doonǝ o yigǝ nɩ o loor-o o wɩ: «Nmʋ na laga, nń wanɩ n pa a na yazurǝ a ji lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","O ŋwaŋa ma zʋ Zezi. O ma twɩ o jɩŋa o dwe-o, yɩ o wɩ: «Ɛɛn. A laga. Zaŋɩ dɩ yazurǝ sɩ n ji lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","O na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ yawɩʋ kʋm yagɩ nɔɔnʋ wʋm, yɩ o yɩra yam ji lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Zezi ma daa ta dɩd-o o wɩ, o ve, yɩ o daarɩ o kaan-o o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Yɩ zaŋɩ n ta kʋlʋ na kɩ tɩn n brɩ nɔɔn-nɔɔnʋ. Nan yɔɔrɩ n vu Wɛ kaanɩm tu wʋm te, sɩ n pa o nii n yɩra yam, sɩ n daarɩ n kwe wǝǝnu tɩlʋ Moyisi cullu tɩm na brɩ nɩ tɩ maŋɩ tɩn n pa-o, sɩ o ma o kaanɩ Baŋa-Wɛ. Kʋntʋ wʋ́ brɩ nɔɔna maama nɩ n yawɩʋ kʋm sɩɩnɩ kʋ je.» ");
INSERT INTO xsm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Zezi na tagɩ kʋntʋ tɩn, nɔɔnʋ wʋm ma nuŋi yɩ o karɩ o ŋɔɔnɩ kʋlʋ na kɩ tɩn o pa nɔɔna maama lwarɩ kʋ ni nɩ. Kʋntʋ ŋwaanɩ Zezi daa warɩ o zʋ tɩʋ dɩ tɩʋ wʋ yɩ o wʋ sǝgi o tɩtɩ. O ma lɛɛrɩ o maŋɩ gaa wʋnɩ nɔɔna na tǝrǝ mɛ tɩn. Nɔɔna maa yǝni ba nuŋi je maama ba ve o te. ");
INSERT INTO xsm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Da fɩnfɩɩn na kɛ tɩn, Zezi ma joori o vu Kapɛrnawum. Tɩʋ kʋm nɔɔna bam ma lwarɩ nɩ o tu o wʋ sɔŋɔ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ba zanzan ma ba ba la daanɩ sɔŋɔ kʋm nɩ, yɩ laŋa daa tǝrǝ kʋ ni nɩ dɩ fɩnfɩɩn dɩ. O maa wʋra o ŋɔɔnɩ Wɛ taanɩ o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","O na wʋra o brɩ-ba kʋntʋ tɩn, nɔɔna badonnǝ ya jɩgɩ kɔrɔ ba bɩɩnɩ o te, yɩ nɔɔna bana zɩŋ-o dɩ gungolo. ");
INSERT INTO xsm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ba na yi jǝgǝ kam tɩn, ba maa warɩ ba ja-o ba yi Zezi te, kɔgɔ kʋm na daga tɩn ŋwaanɩ. Ba ma ja-o ba di digǝ kalʋ Zezi na wʋ ka wʋnɩ tɩn nayuu, ba zagɩ ba puri bɔɔnɩ ba maŋɩ dɩ Zezi na wʋ mɛ tɩn. Ba ma daarɩ ba pa gungolo kʋm kɔrɔ kʋm na tigi kʋ baŋa nɩ tɩn tɔgɩ da kʋ tu digǝ kam wʋ. ");
INSERT INTO xsm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zezi ma lwarɩ nɩ ba kɩ ba wʋ-dɩdʋa dɩd-o. O ma ta dɩ kɔrɔ kʋm o wɩ: «A bu, nmʋ lwarɩm dɩm ti.» ");
INSERT INTO xsm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wɛ cullu karanyɩna tiinǝ badaara ya tɔgɩ ba wʋra. Ba maa je ba bwɛ ba wʋnɩ ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Bɛɛ mʋ yɩ o ŋɔɔnɩ kʋntʋ doŋ? O paɩ o dɩ Wɛ yɩ bɩdwɩ mʋ. O ŋɔɔnɩ o twɩ Wɛ mʋ. Nɔɔn-nɔɔnʋ bá wanɩ o yagɩ nɔɔnʋ lwarɩm o ma cɛ-o, kʋ na daɩ Wɛ DƖ yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zezi ma lwarɩ ba na jɩgɩ wʋbʋŋa yalʋ ba wʋnɩ tɩn. O ma ta dɩ ba o wɩ: «Bɛŋwaanɩ mʋ á bʋŋɩ kʋntʋ doŋ? ");
INSERT INTO xsm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kɔɔ mʋ yɩ mwalɩ kʋ dwe, a na tagɩ dɩ kɔrɔ kʋm a wɩ: ‹Nmʋ lwarɩm dɩm ti› mʋ yɩ mwalɩ, naa a na tagɩ a wɩ: ‹Zaŋɩ wɛɛnɩ n kwe n gungolo kʋm n ta n veǝ› mʋ yɩ mwalɩ? ");
INSERT INTO xsm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A nan wʋ́ pa abam lwarɩ nɩ, amʋ wʋlʋ na yɩ Nabiin-bu wʋm tɩn jɩgɩ dam lʋgʋ baŋa nɩ, sɩ a yagɩ nɔɔna lwarɩm a ma cɛ-ba.» O laan ma ta dɩ kɔrɔ kʋm o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«A lagɩ a ta dɩ nmʋ, zaŋɩ wɛɛnɩ sɩ n kwe n gungolo kʋm n ja n vu sɔŋɔ.» ");
INSERT INTO xsm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zezi na tagɩ kʋntʋ tɩn, bɩdwɩ baŋa nɩ mʋ nɔɔnʋ wʋm zaŋɩ ba maama yigǝ nɩ o kwe o gungolo kʋm o nuŋi o viiri. Ba na nɛ kʋntʋ tɩn, kʋ ma kɩ ba maama yǝǝu. Ba ma zuli Wɛ yɩ ba wɩ: «Dɩ́ daa ta wʋ fɔgɩ dɩ́ na kǝm dɩntʋ doŋ.» ");
INSERT INTO xsm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zezi daa ma nuŋi o vu o wʋ Galile nɩnɩʋ kʋm ni nɩ. Kɔgɔ zanzan ma ba o te kʋ gilim-o. O maa wʋra o brɩ-ba Wɛ cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","O daa ma zaŋɩ o maa kɛa. O na maa kɛ tɩn, o ma na nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Leevi. O ko yɩrɩ mʋ Alɩfɩ. O dɛɛn je mɛ seeni o na yǝni o je o joŋi lampoo tɩn mʋ. Zezi ma ta dɩd-o o wɩ: «Zaŋɩ n ta n tɔgɩ-nɩ.» O ma sɩɩnɩ o zaŋɩ o tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Zezi dɛɛn ma vu Leevi sɔŋɔ sɩ o di wʋdiu dɩ o karabiǝ bam. Lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ zanzan dɩ maa tɔgɩ ba wʋra ba di wʋdiu kʋm dɩ ba, bɛŋwaanɩ balʋ dɛɛn na tɔg-o tɩn daga. ");
INSERT INTO xsm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wɛ cullu karanyɩna tiinǝ badaara na nuŋi Farizɩan tiinǝ kɔgɔ kʋm wʋ tɩn maa tɔgɩ ba wʋra. Ba na nɛ Zezi na je o di wʋdiu dɩ nɔn-cɩcɔgɩrʋ dɩ lampo-joŋnǝ kʋntʋ tɩn, ba ma bwe o karabiǝ bam ba wɩ: «Bɛɛ mʋ kɩ yɩ o di wʋdiu dɩdaanɩ lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ tɩm kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zezi ma ni ba na tagɩ kʋlʋ tɩn. O laan ma ta dɩ ba o wɩ: «Kʋ na yɩ balʋ na jɩgɩ yazurǝ tɩn, bantʋ wʋ maŋɩ sɩ ba vu dɔgɩta tu te sɩ o sooni-ba. Kʋ daarɩ balʋ na ba jɩgɩ yazurǝ tɩn mʋ maŋɩ sɩ ba vu sɩ ba na soonim. A na tu lʋgʋ baŋa tɩn, kʋ daɩ sɩ a bǝŋi balʋ na maŋɩ ba yɩ nɔn-ŋʋna tɩn, amʋ nan tuǝ, sɩ a bǝŋi nɔn-balwaarʋ mʋ sɩ ba ba amʋ te.» ");
INSERT INTO xsm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Zan karabiǝ bam dɩ Farizɩan tiinǝ bam dɛɛn yǝni ba vɔ ni. Nɔɔna badonnǝ ma vu Zezi te ba bwe-o ba wɩ: «Bɛŋwaanɩ mʋ Zan karabiǝ bam dɩ Farizɩan tiinǝ bam yǝni ba vɔ ni, yɩ nmʋ karabiǝ bam ba vɔa?» ");
INSERT INTO xsm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zezi ma lǝri-ba o wɩ: «Nɔɔnʋ na di kaanɩ yɩ o kɩ candiǝ, yɩ o cilonnǝ na wʋra sɩ ba tɔgɩ ba di, bantʋ wʋ́ wanɩ ba vɔ ni yɩ kan-barʋ wʋm ta wʋ ba tee nɩ na? Ba bá sɛ ba vɔ ni maŋa kalʋ kan-barʋ wʋm ta na wʋ ba tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kʋ nan wʋ́ ba kʋ yi maŋa kam ba na wʋ́ ja kan-barʋ wʋm ba viiri tɩn. Maŋa kam kʋntʋ nɩ o daa na tǝri ba tee nɩ tɩn, mʋ ba laan wʋ́ vɔ ni. ");
INSERT INTO xsm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nɔɔn-nɔɔnʋ bá sɛ o kwe garyi-dʋʋrɩ o ma fǝri gwar-doŋo kʋlʋ na kaarɩ tɩn. O nan na kɩ kʋntʋ, garyi-dʋʋrɩ dɩm laan wʋ́ vuuri gwar-doŋo kʋm dɩ pa kʋ tiini kʋ cɔgɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nɔɔn-nɔɔnʋ dɩ nan bá sɛ o kwe sa-dʋŋa o lo o kɩ lɔ-doŋo wʋnɩ. O na kɩ kʋntʋ, yɩ sana kam na keeri, kaá pa lɔɔ kʋm bagɩ mʋ. Lɔɔ kʋm wʋ́ cɔgɩ yɩ sana kam dɩ lo. Kʋntʋ ŋwaanɩ nɔɔnʋ maŋɩ sɩ o kwe sa-dʋŋa o kɩ lɔ-dʋŋʋ wʋnɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zwifǝ bam siun dɛ dɩdoŋ na yi tɩn, Zezi dɛɛn ma tɔgɩ karɩ wʋ o maa kɛa. O karabiǝ bam dɩ maa tɔgɩ ba veǝ, yɩ ba bwǝri mɩna ba yu ba dʋna. ");
INSERT INTO xsm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farizɩan tiinǝ bam na nɛ ba na kɩ te tɩn, ba ma ta dɩ Zezi ba wɩ: «Nii ba na kɩ te tɩn. Bɛɛ mʋ yɩ ba tʋŋɩ tɩtʋŋɩ dɩlʋ na cɔgɩ siun dɛ cullu tɩm tɩn?» ");
INSERT INTO xsm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zezi ma lǝri-ba o wɩ: «Abam ta wʋ fɔgɩ á karɩmɩ Wɛ tɔnɔ kʋm na brɩ Pɛ Davidi taanɩ te tɩn na? Kʋ brɩ nɩ maŋa kalʋ Abɩata dɛɛn na yɩ Wɛ kaanɩm yuutu tɩn, kana dɛɛn jɩgɩ Davidi dɩ o nɔɔna bam, yɩ ba ba jɩgɩ wʋdiu sɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O ma vu o zʋ Wɛ digǝ, yɩ o kwe dɩpwa yalʋ na tigi da Wɛ ŋwaanɩ tɩn o di. Dɩpɛ dɩm kʋntʋ culǝ sɩ nɔn-gaa di-dɩ, kʋ na daɩ Wɛ kaanɩm tiinǝ yɩranɩ. Davidi dɛɛn di dɩpɛ dɩm, yɩ o daarɩ o pa o nɔɔna bam dɩ tɔgɩ ba di.» ");
INSERT INTO xsm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","O daa ma ta dɩ ba o wɩ: «Wɛ na kɩ nabiinǝ DƖ yagɩ lʋgʋ baŋa nɩ tɩn, DƖ tiŋi siun dɛ da yarpɛ maama wʋnɩ, sɩ kʋ taa jɩgɩ zǝnǝ mʋ kʋ pa-ba, sɩ kʋ daɩ nɩ Wɛ kɩ nabiinǝ siun dɛ cullu tɩm tɔgɩm ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kʋntʋ ŋwaanɩ amʋ Nabiin-bu wʋm jɩgɩ ni siun dɛ cullu tɩm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Zezi daa ma joori o vu o zʋ ba Wɛ-digǝ kam. Nɔɔnʋ maa wʋra o jɩŋa dɩdʋa na tɩga. ");
INSERT INTO xsm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farizɩan tiinǝ badonnǝ maa lagɩ cwǝŋǝ sɩ ba brɩ nɩ Zezi kɩ o cɔgɩ. Kʋntʋ ŋwaanɩ ba ma je ba yɩrɩ Zezi sɩ ba nii, oó sɛ o pa nɔɔnʋ wʋm na yazurǝ siun dɛ dɩm nɩ naa o bá sɛ. ");
INSERT INTO xsm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zezi ma ta dɩ nɔɔnʋ wʋm o wɩ: «Zaŋɩ n zɩgɩ nɔɔna bam maama tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","O laan ma bwe ba maama o wɩ: «Culu brɩ bɛɛ mʋ? Kɔɔ mʋ maŋɩ dɩ culu kʋm, nɔɔnʋ na kɩ o doŋ lanyɩranɩ siun dɛ nɩ mʋ maŋɩ naa o na kɩ-o lwarɩm mʋ gara? Nɔɔnʋ na vrɩ o doŋ ŋwɩa siun dɛ nɩ mʋ maŋɩ naa o na gʋ-o mʋ gara?» O na bwe-ba kʋntʋ tɩn, ba maa cɩm. ");
INSERT INTO xsm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","O ma nii ba maama yɩ o banɩ zaŋɩ. O wʋ ma cɔgɩ zanzan ba wʋbʋŋa na tɩgɩ tɩn ŋwaanɩ. O laan ma ta dɩ nɔɔnʋ wʋm o wɩ: «Twɩ n jɩŋa kam.» O ma twɩ-ka, yɩ ka joori ka ji lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizɩan tiinǝ bam na nɛ o na kɩ te tɩn, ba ma nuŋi ba vu ba banɩ dɩ Pɛ Erɔdɩ kwaga nɔɔna bam, sɩ ba lagɩ cwǝŋǝ ba gʋ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zezi dɩ o karabiǝ bam ma zaŋɩ ba kɛ. Ba ma vu ba yi nɩnɩʋ kʋm ni. Kɔgɔ zanzan ma nuŋi Galile je sɩm nɩ ba tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nɔɔna badonnǝ dɩ ma nuŋi Zeruzalɛm dɩ Zude maama, dɩ Yidume je sɩm nɩ. Badaara dɩ ma nuŋi je sɩlʋ na wʋ Zʋrdɛn bugǝ kam bubɛ dɩdoŋ dɩm nɩ tɩn, dɩ Tiiri dɩ Sidɔn tɩ-niǝ yam maama wʋnɩ. Kɔ-fɔrɔ zanzan ma vu Zezi te, ba na lwarɩ o na kɩ kʋlʋ maama tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ba kɔgɔ kʋm na daga yɩ ba tiini ba pɩɩn-o zanzan tɩn, o ma ta dɩ o karabiǝ bam sɩ ba ja naboro ba ba ba zɩgɩ da, sɩ o wanɩ o zʋ kʋ wʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","O na maŋɩ o pa nɔɔna zanzan na yazurǝ tɩn, kʋ ma pa yawɩɩna bam maama yigi ba pɩɩn-o, yɩ ba kwaanɩ sɩ ba dwe o yɩra. ");
INSERT INTO xsm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maŋa kalʋ maama ciciri sɩm na yǝni sɩ na-o, sɩ wʋ́ tʋ o yigǝ nɩ mʋ, yɩ sɩ kaasɩ sɩ wɩ: «Nmʋ mʋ yɩ Wɛ Bu wʋm.» ");
INSERT INTO xsm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ciciri sɩm na yǝni sɩ tɛ kʋntʋ doŋ, o yǝni o kaanɩ-sɩ mʋ, sɩ sɩ yɩ pa nɔɔn-nɔɔnʋ lwarɩ o na yɩ wʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zezi laan ma zaŋɩ o vu o di piu kʋdoŋ yuu. O ma bǝŋi balʋ o na lagɩ tɩn sɩ ba ba o te. ");
INSERT INTO xsm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ba na tu tɩn, o ma kuri nɔɔna fugǝ-bale sɩ ba taa wʋ o tee nɩ, sɩ o taa tʋŋɩ-ba sɩ ba taa ve ba tɔɔla Wɛ kwǝrǝ kam dɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","O ma daarɩ o pa-ba dam sɩ ba wanɩ ciciri ba zǝli nɔɔna yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nɔɔna fugǝ-bale bam o na kuri tɩn yɩra mʋ tɩntʋ: Simɔn wʋlʋ Zezi na pɛ o yɩrɩ nɩ Pɩyɛɛrɩ tɩn, ");
INSERT INTO xsm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","dɩ Zakɩ wʋlʋ na yɩ Zebede bu tɩn, dɩ o nyaanɩ Zan. Zezi ma pa bantʋ yɩrɩ nɩ Bʋanɛrgɛsɩ, kʋ kuri mʋ Dʋ-baka biǝ. ");
INSERT INTO xsm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Dɩ Andre, dɩ Filipi, dɩ Batelemi, dɩ Matiyu, dɩ Toma, dɩ Zakɩ wʋlʋ na yɩ Alɩfɩ bu tɩn, dɩ Tadɩ, dɩ Simɔn wʋlʋ na yɩ Zelɔtɩ nɔɔna bam wʋ nɔɔnʋ tɩn, ");
INSERT INTO xsm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","dɩdaanɩ Zudasɩ Yiskarɩyo wʋlʋ na wʋ́ ba o yǝgi Zezi o pa nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Zezi ma joori o vu sɔŋɔ. Kɔgɔ zanzan daa ta ma ba kʋ gilimi sɔŋɔ kʋm. Kʋ ma pa Zezi dɩ o karabiǝ bam daa warɩ ba na laŋa sɩ ba di wʋdiu dɩ. ");
INSERT INTO xsm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","O sɔŋɔ tiinǝ na ni kʋntʋ tɩn, ba ma zaŋɩ ba nuŋi sɩ ba vu ba ja-o ba viiri, bɛŋwaanɩ nɔɔna tɛ ba wɩ, o co mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wɛ cullu karanyɩna tiinǝ ya nuŋi Zeruzalɛm ba ba sɩ ba nii-o. Ba maa tɛ ba wɩ: «Sʋtaana-pɛ Belizebuli mʋ jɩg-o. Kʋ yɩ wʋntʋ dam mʋ o ma o zǝli sʋtaana.» ");
INSERT INTO xsm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zezi laan ma bǝŋi-ba sɩ ba ba o te, yɩ o daarɩ o maŋɩ mɩmaŋa o brɩ-ba o wɩ: «Nɔɔnʋ wʋ́ wanɩ o ma sʋtaana-pɛ dam o ma zǝli sʋtaana na? ");
INSERT INTO xsm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tɩʋ kʋlʋ paarɩ na pɔɔrɩ kuni bɩle yɩ ba jɩgɩ daanɩ tɩn, kʋʋ́ tʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sɔŋɔ kʋlʋ maama na pɔɔrɩ kʋ tɩtɩ wʋnɩ tɩn, kʋ dɩ wʋ́ tʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sʋtaana-pɛ na joori o jɩgɩ dɩ o tɩtɩ, kʋ brɩ nɩ o paarɩ dɩm pɔɔrɩ bɩle mʋ yɩ o dam ti. Oó tʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kʋ nan na yɩ te tɩn, sʋtaana-pɛ nyɩ dɩ nɔn-dɩdɛɛrʋ na yɩrɩ o sɔŋɔ te tɩn mʋ. Nɔɔnʋ na lagɩ sɩ o zʋ dɩdɛɛrʋ wʋm sɔŋɔ o ŋɔ, o maŋɩ sɩ o da yigǝ o ja dɩdɛɛrʋ wʋm o vɔ mʋ. O na dɛ yigǝ o vɔ-o, o laan wʋ́ wanɩ o zʋ o kwalɩmɩ o jɩjɩgɩrʋ tɩm maama o ja viiri. ");
INSERT INTO xsm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A lagɩ a ta cɩga mʋ dɩ abam sɩ, kǝm-balwaarʋ tɩlʋ maama nɔɔna na kɩ tɩn, naa ta-balwaarʋ tɩlʋ ba na ŋɔɔnɩ tɩn, Wɛ waɩ DƖ yagɩ-tɩ DƖ ma cɛ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kʋ daarɩ, wʋlʋ maama na ŋɔɔnɩ o twɩ Wɛ Joro kʋm tɩn, Wɛ bá sɛ sɩ DƖ ma cɛ kʋntʋ tu maŋa dɩ maŋa. Lwarɩm dɩm kʋntʋ wʋ́ ta tɔgɩ kʋntʋ tu sɩ kʋ taa ve maŋa kalʋ na ba ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ba na tagɩ ba wɩ, cicirǝ mʋ jɩg-o tɩn, mʋ o tagɩ kʋntʋ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zezi nu dɩ o nyaana ma ba o na wʋ mɛ tɩn, ba zɩgɩ sɔŋɔ kʋm mancoŋo nɩ, yɩ ba pa ni sɩ ba bǝŋ-o. ");
INSERT INTO xsm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kɔgɔ zanzan maa je ba gilim-o. Ba ma ta dɩd-o ba wɩ: «N nu dɩ n nyaana tu ba wʋ mancoŋo nɩ, yɩ ba lagɩ-m.» ");
INSERT INTO xsm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","O ma lǝri-ba o wɩ: «Wɔɔ mʋ yɩ a nu, bran yɩ a nyaana?» ");
INSERT INTO xsm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","O laan ma nii balʋ na je ba gilim-o tɩn seeni yɩ o wɩ: «Amʋ nu dɩ a nyaana mʋ tɩntʋ. ");
INSERT INTO xsm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bɛŋwaanɩ wʋlʋ maama na kɩ Wɛ wʋbʋŋa na lagɩ te tɩn mʋ yɩ a nyaanɩ dɩ a nakɔ dɩ a nu.» ");
INSERT INTO xsm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Zezi dɛɛn maa wʋ nɩnɩʋ kʋm ni nɩ o brɩ nɔɔna bam. Nɔɔna zanzan ma ba ba gilim-o. Ba kɔgɔ kʋm na daga tɩn, o ma zaŋɩ o di naboro kʋ na wʋ na bam wʋnɩ tɩn, yɩ o jǝni sɩ o brɩ-ba. Nɔɔna bam maama ma maŋɩ na bam ni nɩ, sɩ ba taa cǝgi o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O maa maɩ mɩmaŋa o brɩ-ba wǝǝnu zanzan, yɩ o zaasɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Cǝgi-na. Valʋ dɛɛn mʋ wʋra. O ma zaŋɩ o vu o kara sɩ o du. ");
INSERT INTO xsm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","O ma karɩ o dʋlɩ o wo-duuru tɩm. Tɩdonnǝ ma tʋ cwǝŋǝ ni nɩ. Zunǝ ma ba ba twɛ-tɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tɩdonnǝ ma tʋ kandwa jǝgǝ nɩ valɩm na ba daga mɛ tɩn. Tɩ ma wʋ daanɩ tɩ puli, valɩm dɩm na ba lirǝ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Wɩa ma ba ka baanɩ tɩ maama. Tɩ bʋnnʋ na wʋ zʋ tɩga tɩn, tɩ ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kʋ daarɩ wo-duuru tɩdonnǝ ma tʋ sabarɩ wʋnɩ. Tɩ na puli tɩn, sabarɩ sɩm laan ma zaŋɩ sɩ li-tɩ sɩ gʋ, yɩ tɩ daa wʋ kɩ biǝ. ");
INSERT INTO xsm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kʋ daarɩ tɩdonnǝ ma tʋ tɩ-ywǝŋǝ jǝgǝ nɩ, tɩ ma puli tɩ nuŋi tɩ kɩ biǝ lanyɩranɩ. Tɩdonnǝ kɩ nɩnɛɛnɩ biǝ fiintɔ fiintɔ. Tɩdaara kɩ nɩnɛɛnɩ biǝ fusɩrdʋ fusɩrdʋ. Tɩtɩm dɩ maa kɩ nɩnɛɛnɩ biǝ bi bi.» ");
INSERT INTO xsm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zezi laan ma ta o wɩ: «Á nan fɔgɩ á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kɔgɔ kʋm na viiri kʋ daarɩ Zezi o yɩranɩ tɩn, nɔɔna balʋ ya na wʋ o tee nɩ tɩn badaara ma tɔgɩ dɩ o karabiǝ fugǝ-bale bam, ba vu ba bwe-o mɩmaŋa yam kuri. ");
INSERT INTO xsm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O ma lǝri-ba o wɩ: «Kʋ na yɩ abam, Wɛ maŋɩ DƖ pa á lwarɩ DƖ paarɩ dɩm kuri na yɩ te tɩn, yɩ cɩga kam kʋntʋ ya maŋɩ ka sǝgi mʋ. Kʋ daarɩ, balʋ na daɩ amʋ kɔgɔ kʋm wʋ nɔɔna tɩn, a maɩ mɩmaŋa yɩranɩ mʋ a brɩ-ba Wɛ cɩga kam, ");
INSERT INTO xsm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sɩ ‹ba na niǝ, sɩ ba yɩ taa naɩ lanyɩranɩ, ba na cǝgǝ, sɩ ba yɩ taa ni ka kuri. Kʋ na daɩ kʋntʋ, ba ya wʋ́ pipiri ba sɛ Wɛ, yɩ DƖ wʋ́ yagɩ ba lwarɩm DƖ ma cɛ-ba.› » ");
INSERT INTO xsm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zezi laan ma bwe-ba o wɩ: «Á wʋ ni mɩmaŋɩ dɩntʋ kuri na? Kʋntʋ tɩn, á nan wʋ́ kɩ ta mʋ á ni mɩmaŋa yadonnǝ yam kuri? ");
INSERT INTO xsm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mɩmaŋɩ dɩm kuri mʋ tɩntʋ: Wo-duuru tɩlʋ valʋ wʋm na jɩgɩ o du tɩn mʋ brɩ Wɛ taanɩ dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nɔɔna badonnǝ nyɩ dɩ cwǝŋǝ kam ni wo-duuru tɩm na tʋ mɛ tɩn mʋ. Bantʋ na ni Wɛ taanɩ dɩm tɩn, sʋtaanɩ ma da dɩ ba dɩ lɩ-dɩ, yɩ dɩ wʋ zʋ ba wʋbʋŋa. ");
INSERT INTO xsm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nɔɔna badonnǝ nyɩ dɩ kandwa jǝgǝ kalʋ wo-duuru tɩm na tʋ da tɩn mʋ. Bantʋ na ni Wɛ taanɩ dɩm tɩn, ba joŋi-dɩ lɩla dɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Taanɩ dɩm ma wʋ tiini dɩ zʋ ba wʋbʋŋa. Yaara na yi-ba, yɩ ba na bɛɛsɩ-ba Wɛ taanɩ dɩm ŋwaanɩ, baá da ba kwe-dɩ ba yagɩ mʋ lɩla. ");
INSERT INTO xsm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nɔɔna badaara nyɩ dɩ sabarɩ sɩm jǝgǝ kam wo-duuru tɩm na tʋ da tɩn mʋ. Bantʋ mʋ yɩ balʋ na ni Wɛ taanɩ dɩm, ");
INSERT INTO xsm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yɩ ba ta jɩgɩ liǝ dɩ lʋgʋ baŋa wǝǝnu tɩm. Sǝbu-lagɩ ma cɔgɩ ba wʋbʋŋa yɩ wo-yɔɔrʋ fra jɩgɩ-ba, kʋ pa ba kwe Wɛ taanɩ dɩm ba yagɩ, yɩ dɩ wʋ jaanɩ kuri dɩ pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kʋ daarɩ nɔɔna badaara nyɩ dɩ tɩ-ywǝŋǝ jǝgǝ kam wo-duuru tɩm na tʋ da tɩn mʋ. Bantʋ mʋ yɩ balʋ na ni Wɛ taanɩ dɩm yɩ ba sɛ-dɩ lanyɩranɩ tɩn. Kʋntʋ ma pa Wɛ taanɩ dɩm ja kuri dɩ pa-ba, nɩnɛɛnɩ wo-duuru na kɩ biǝ lanyɩranɩ, sɩ kʋ maŋɩ dɩ biǝ fiintɔ fiintɔ, yɩ tɩdaara dɩ kɩ biǝ fusɩrdʋ fusɩrdʋ, yɩ tɩdonnǝ dɩ kɩ biǝ bi bi tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Zezi daa ma maŋɩ o brɩ-ba o wɩ: «Nɔɔnʋ na tarɩgɩ kanɩa, oó sɛ o kwe-ka o pu tɩtɔgɔ kuri nɩ, naa o zɩgɩ-ka gadogo kuri nɩ na? Aye. Oó kwe-ka o palɩ wɛɛnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kʋlʋ maama na sǝgi zɩm nɔɔna tee nɩ tɩn wʋ́ ba kʋ kwɩn. Kʋlʋ maama na pugi zɩm tɩn wʋ́ ba kʋ puri sɩ nɔɔna maama lwarɩ-kʋ. ");
INSERT INTO xsm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Á nan fɔgɩ á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O daa ma ta o wɩ: «Kwaanɩ-na á pa á na ni kʋlʋ tɩn zʋ á wʋbʋŋa. Abam na maɩ bwaŋa kalʋ á maŋɩ á pa á donnǝ tɩn, Wɛ dɩ wʋ́ ma bwaŋa kantʋ mʋ DƖ maŋɩ DƖ pɛɛlɩ DƖ pa abam. ");
INSERT INTO xsm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bɛŋwaanɩ, nɔɔnʋ wʋlʋ na maŋɩ o jɩgɩ woŋo tɩn, o ta wʋ́ joŋi kʋdoŋ o wǝli da, yɩ nɔɔnʋ wʋlʋ nan na maŋɩ o ba jɩgɩ kʋlʋkʋlʋ tɩn wʋ́ ba o ga kʋlʋ fɩnfɩɩn o ya na jɩgɩ tɩn dɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zezi daa ma ta o wɩ: «Wɛ paarɩ dɩm nyɩ dɩ nɔɔnʋ na kwe wo-duuru o du o kara wʋnɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tɩtɩɩ nɩ o maa tigi o dɔa. Wɩa nɩ o maa yǝni o zaŋɩ. Wɩa dɩ tɩtɩɩ maama wo-vaalʋ tɩm maa pulǝ yɩ tɩ bɩra, yɩ valʋ wʋm yǝri tɩ na kɩ te tɩ puli. ");
INSERT INTO xsm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɩga kam nɩ mʋ wǝǝnu tɩm tɩtɩ yǝni tɩ puli tɩ nuŋi tɩ da yigǝ tɩ kɩ vɔɔrʋ. Tɩ laan ja pugǝ yɩ tɩ daarɩ tɩ kɩ biǝ. ");
INSERT INTO xsm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wo-vaalʋ tɩm na bɩgɩ tɩ ti, valʋ wʋm laan wʋ́ kwe o sʋgʋ o vu o zagɩ-tɩ, faa maŋa kam na yi tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zezi daa ta ma ta o wɩ: «Amʋ wʋ́ ma bɛɛ mʋ a maa maŋɩ a brɩ abam Wɛ paarɩ dɩm na nyɩ te tɩn? Aá ma mɩmaŋa mʋ a brɩ abam sɩ á lwarɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wɛ paarɩ dɩm nyɩ dɩ nɔɔnʋ na kwe wo-duu na yɩ mɩmɩɩnʋ o du tɩga nɩ, yɩ wo-duu kʋm kʋntʋ mʋ tiini kʋ yɩ mɩmɩɩnʋ wo-dwǝ maama wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","O na dugi-kʋ tɩn, kʋ laan ma nuŋi kʋ ji kamunu kʋ dwǝni dwǝ balʋ maama na wʋ o kara kam nɩ tɩn. Kʋ ma ta nɛ kamunǝ kamunǝ, yɩ zunǝ tui ba sɔ ba pwǝru kʋ yuu nɩ, kʋ na jɩgɩ woro tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zezi maa maɩ mɩmaŋa yantʋ dwi zanzan mʋ o maŋɩ Wɛ taanɩ dɩm o brɩ nɔɔna bam. O maa yǝni o brɩ-ba nɩnɛɛnɩ ba na wʋ́ wanɩ ba ni dɩ kuri te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O maa maɩ mɩmaŋa yɩranɩ mʋ o brɩ nɔɔna bam. Kʋ na yǝni kʋ yɩ wʋntʋ dɩ o karabiǝ bam yɩranɩ, o yǝni o tɛ wǝǝnu tɩm maama kuri o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dɛ dɩm kʋntʋ wa-zʋʋrɩ maŋa nɩ, Zezi ma ta dɩ o karabiǝ bam o wɩ: «Pa-na dɩ́ kwe naboro dɩ́ vu dɩ́ bɛ bubɛ dɩdoŋ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","O na je naboro kʋm wʋnɩ kʋntʋ tɩn, ba ma kwe-o ba ja viiri yɩ ba daarɩ kɔgɔ kʋm. Nabwǝǝru tɩdonnǝ dɩ maa tɔgɩ-ba tɩ veǝ. ");
INSERT INTO xsm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Vu-fɔrɔ laan ma zaŋɩ kʋ magɩ boro kʋm. Na bam ma pɔgɩlɩ zanzan ba wʋra ba sui boro kʋm, yɩ kʋ lagɩ kʋ miisi na bam kuri nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zezi maa wʋ naboro kʋm kwaga kam nɩ o tigi pɔlɔ baŋa nɩ o dɔa. O karabiǝ bam ma vu ba zaŋ-o, yɩ ba ta dɩd-o ba wɩ: «Karanyɩna, dɩ́ na lagɩ dɩ́ tɩ tɩn, kʋ daɩ kʋlʋkʋlʋ dɩ nmʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O laan ma zaŋɩ wɛɛnɩ, yɩ o bagɩ vu-fɔrɔ kʋm o wɩ, kʋ kwǝri, yɩ o daarɩ o ta dɩ na bam o wɩ, ba yagɩ sɔɔ! O na tagɩ kʋntʋ tɩn, viu kʋm ma sɩɩnɩ kʋ ja, yɩ na bam dɩ maŋɩ da cɩmm. ");
INSERT INTO xsm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","O ma ta dɩ o karabiǝ bam o wɩ: «Bɛɛ mʋ yɩ á fʋmma kʋntʋ? Abam ta wʋ kɩ á wʋ-dɩdʋa dɩ amʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Fʋʋnɩ ma tiini dɩ ja-ba. Ba ma bwe daanɩ ba wɩ: «Nɔɔnʋ wʋntʋ yɩ wɔɔ mʋ, yɩ viu dɩ na dɩ ta sɛ o ni?» ");
INSERT INTO xsm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ba ma vu ba bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm mɛ Zeraaza tiinǝ na zʋʋrɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zezi ma nuŋi naboro kʋm wʋnɩ. Nɔɔnʋ wʋdoŋ ma da o nuŋi yibeelǝ je nɩ o ba o jeer-o. Cicirǝ mʋ jɩg-o ka yaara. ");
INSERT INTO xsm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","O dɛɛn tigi yibeelǝ je nɩ mʋ. Kuni zanzan ba yǝni ba maɩ capʋnnʋ mʋ ba ma vɔ o jɩa dɩ o nɛ. O maa yǝni o vaŋɩ capʋnnʋ tɩlʋ na wʋ o jɩa nɩ tɩn o kɔ. O ma daarɩ o magɩ luguru tɩlʋ ba na kɩ o nɛ sɩm nɩ tɩn o cɔgɩ. O na tiini o dana tɩn, nɔɔn-nɔɔnʋ daa warɩ o ja-o o vɔ, naa o ja-o o pa o jǝni cɩm. ");
INSERT INTO xsm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Maŋa maama wɩa dɩ tɩtɩɩ o beeri yibeelǝ je sɩm nɩ dɩ pweeru yuu nɩ mʋ, yɩ o kaasa. O maa yǝni o magɩ o tɩtɩ dɩ kandwa o fwǝlǝ. ");
INSERT INTO xsm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","O na tʋlɩ o na Zezi yigǝ yigǝ tɩn, o ma nuŋi yibeelǝ yam wʋnɩ o duri o vu o jeer-o. O na yi o te tɩn, o ma kuni doonǝ o yigǝ nɩ, ");
INSERT INTO xsm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","yɩ o kaasɩ dɩ kwǝr-dɩa o wɩ: «Zezi, Yuutu Baŋa-Wɛ Bu, n tu amʋ te sɩ n kɩ bɛɛ mʋ? A loori-m dɩ Wɛ yɩrɩ, sɩ n yɩ zaŋɩ n yaarɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","O tagɩ kʋntʋ, bɛŋwaanɩ Zezi maŋɩ o wʋra o tɛ dɩ cicirǝ kam sɩ ka nuŋi o yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zezi laan ma bwe-o o wɩ: «N yɩrɩ mʋ bɛɛ?» O ma lǝri o wɩ: «A yɩrɩ mʋ Kɔgɔ, bɛŋwaanɩ dɩ́ yɩ ciciri zanzan mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ciciri sɩm ma pa nɔɔnʋ wʋm tiini o loori Zezi, sɩ o yɩ pa sɩ nuŋi je sɩntʋ nɩ sɩ viiri. ");
INSERT INTO xsm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tǝrǝ zanzan dɛɛn ma wʋ je sɩm kʋntʋ nɩ ba beeri piu kʋm tǝŋǝ nɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ciciri sɩm ma loori Zezi sɩ wɩ: «Pa dɩbam cwǝŋǝ sɩ dɩ́ vu dɩ́ zʋ tǝrǝ bam.» ");
INSERT INTO xsm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O ma sɛ. Ciciri sɩm laan ma yagɩ nɔɔnʋ wʋm yɩra yɩ sɩ zʋ tǝrǝ bam. Tǝrǝ bam kɔgɔ kʋm maama laan ma duri ba tu ba tʋ bugǝ kam wʋnɩ ba li na ba tɩ. Ba dɛɛn yɩ nɩnɛɛnɩ tǝrǝ mʋrr-tɩle (2.000) mʋ te. ");
INSERT INTO xsm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nɔɔna balʋ ya na nii tǝrǝ bam baŋa nɩ tɩn ma duri ba vu tɩʋ kʋm wʋ dɩ dɛ sɩm maama nɩ, ba ta dɩ nɔɔna bam kʋlʋ na kɩ tɩn. Nɔɔna bam ma nuŋi ba vu sɩ ba nii kʋ na kɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ba ma vu ba yi Zezi te. Ba ma na nɔɔnʋ wʋlʋ ciciri kɔgɔ kʋm ya na jɩg-o tɩn. O maa je yɩ o wʋbʋŋa joori ya ba o tɩtɩ yɩ o zʋ gwaarʋ. Ba na nɛ-o kʋntʋ tɩn, fʋʋnɩ ma zʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Balʋ yiǝ na nɛ kǝm dɩm tɩn ma ta ba brɩ nɔɔna bam kʋ na kɩ nɔɔnʋ wʋm te tɩn, dɩ kʋlʋ na kɩ tǝrǝ bam dɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tɩʋ kʋm nɔɔna bam laan ma loori Zezi sɩ o nuŋi ba tɩʋ kʋm nɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zezi ma vu sɩ o joori o zʋ naboro kʋm wʋ. Nɔɔnʋ wʋlʋ ciciri sɩm ya na jɩgɩ sɩ yaarɩ tɩn ma loor-o, sɩ o na sɛ, sɩ o taa tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","O ma wʋ sɛ. O ma ta dɩd-o o wɩ: «Ve sɔŋɔ, sɩ n ta dɩ n sɔŋɔ tiinǝ n Yuutu Baŋa-Wɛ na duri nmʋ ŋwaŋa dɩ DƖ na kɩ woŋo kʋlʋ maama DƖ pa-m tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nɔɔnʋ wʋm laan ma kɛ o vu je sɩlʋ ba na bǝ nɩ Tɩɩnɩ Fugǝ tɩn, yɩ o tɛ o brɩ nɔɔna bam Zezi na kɩ kʋlʋ o pa-o tɩn. Balʋ maama na ni o taanɩ dɩm tɩn, kʋ ma sʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zezi dɛɛn ma joori o da nɩnɩʋ kʋm wʋ dɩ naboro o bɛ bubɛ dɩdoŋ dɩm. O na zɩgɩ nɩnɩʋ kʋm ni nɩ tɩn, nɔn-kɔgɔ ma ba o te ba gilim-o. ");
INSERT INTO xsm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nɔɔnʋ wʋdoŋ maa tɔgɩ o wʋra, o yɩrɩ mʋ Zayirusi. O yɩ Wɛ-digǝ kam yigǝ tiinǝ wʋ dɩdʋa mʋ. O na nɛ Zezi tɩn, o ma kuni doonǝ o yigǝ nɩ, ");
INSERT INTO xsm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yɩ o tiini o loor-o o wɩ: «Amʋ bukɔ balaŋa mʋ lagɩ o tɩ. Popo, a loori-m sɩ n ba n daŋɩ n jɩa o baŋa nɩ, sɩ kʋʋ́ pa o yawɩʋ kʋm je sɩ o joori o na ŋwɩa.» ");
INSERT INTO xsm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zezi ma sɛ yɩ o tɔgɩ dɩd-o o ma ve. Kɔ-fɔrɔ dɩ maa tɔg-o, yɩ ba pɩɩn-o zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kaanɩ wʋdoŋ maa tɔgɩ o wʋra, o na wɔɛ ka-wʋ taan bɩna fugǝ-yale. ");
INSERT INTO xsm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O dɛɛn tiini o yaarɩ dɔgɩta tiinǝ zanzan tee nɩ. O dɛɛn cɔgɩ o sǝbu maama o yawɩʋ kʋm baŋa nɩ, yɩ kʋ ta ba garɩ kʋ pa-o, kʋ fɔgɩ kʋ jiri lɛɛrʋ mʋ o yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","O laan na ni Zezi ŋwa tɩn, o ma tɔgɩ kɔgɔ kʋm wʋ o kɛ o kwaga o vu o dwe o gɔrɔ. ");
INSERT INTO xsm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","O maa bʋŋɩ o wɩ: «A na maŋɩ a dwe o gɔrɔ kʋm má dɩ, aá na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","O na dwe-o kʋntʋ tɩn, jana kam ma da ka kɔ. O ma lwarɩ nɩ o yawɩʋ kʋm sɩɩnɩ kʋ je o yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bɩdwɩ baŋa nɩ mʋ Zezi maanɩ nɩ dam nuŋi o yɩra nɩ. O maa zɩgɩ kɔgɔ kʋm wʋnɩ o pipiri o nii, yɩ o bwe o wɩ: «Wɔɔ mʋ dwe a gɔrɔ?» ");
INSERT INTO xsm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","O karabiǝ bam ma ta dɩd-o ba wɩ: «Nmʋ wʋ nɛ nɔɔna bam maama na yigi ba pɩɩnɩ nmʋ te tɩn na? Bɛɛ mʋ yɩ n bwe nɩ, wɔɔ mʋ dwe-m?» ");
INSERT INTO xsm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","O daa ta maa fɔgɩ o nii kɔgɔ kʋm wʋnɩ sɩ o lwarɩ wʋlʋ na dwe-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fʋʋnɩ laan maa jɩgɩ kaanɩ wʋm yɩ o yɩra saɩ, o na ye kʋlʋ na kɩ-o yɩ o na yazurǝ tɩn ŋwaanɩ. O ma vu Zezi te o kuni doonǝ o yigǝ nɩ, yɩ o ta o cɩga maama dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zezi ma ta dɩd-o o wɩ: «A bukɔ, nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ te tɩn mʋ pɛ n na yazurǝ. Ve sɩ Wɛ wʋ́ wǝli-m, sɩ n sin dɩ n yawɩʋ kʋm.» ");
INSERT INTO xsm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zezi ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, nɔɔna badonnǝ ma nuŋi Zayirusi sɔŋɔ ba ba, ba ta dɩd-o ba wɩ: «N bukɔ wʋm tɩga. Daa n yɩ ta n jɩgɩ karanyɩna kam n yaara.» ");
INSERT INTO xsm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zezi maa cɩm, yɩ o ta dɩ Zayirusi o wɩ: «Yɩ pa fʋʋnɩ ja-m. Za n weeni n kɩ n wʋ-dɩdʋa dɩ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Zezi ma wʋ sɛ sɩ nɔɔna tɔgɩ dɩd-o ba vu Zayirusi sɔŋɔ kʋm, kʋ na daɩ Pɩyɛɛrɩ dɩ Zakɩ dɩ o nyaanɩ Zan yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ba ma vu ba yi sɔŋɔ kʋm. Zezi ma ni nɩ sɔɔ yɩranɩ mʋ wʋra bɔgɩ bɔgɩ, yɩ nɔɔna keerǝ yɩ ba coosǝ. ");
INSERT INTO xsm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","O ma zʋ sɔŋɔ kʋm, yɩ o ta dɩ nɔɔna bam o wɩ: «Bɛŋwaanɩ mʋ yɩ á kɩ sɔɔ yɩ á keerǝ? Bu wʋm wʋ tɩgɩ, o dɔ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","O na tagɩ kʋntʋ tɩn, ba ma mwan-o. O ma pa ba maama nuŋi. O ma daarɩ o ja bu wʋm nu dɩ o ko dɩ o tɩtɩ karabiǝ batɔ bam o vu o zʋ digǝ kalʋ bu wʋm na tigi da tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O ma ja bu wʋm jɩŋa, yɩ o ta dɩd-o o wɩ: «Talita kumi.» Taanɩ dɩntʋ kuri mʋ: «Bɩsankana, a lagɩ a ta nmʋ, zaŋɩ wɛɛnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","O na tagɩ kʋntʋ tɩn, bɩsankana kam ma da ka zaŋɩ wɛɛnɩ ka veǝ. O bɩna dɛɛn yɩ fugǝ-yale mʋ. Ba na nɛ kʋntʋ tɩn, kʋ ma sʋ-ba lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Zezi laan ma kaanɩ-ba o wɩ, ba yɩ zaŋɩ ba pa nɔɔn-nɔɔnʋ lwarɩ kʋlʋ na kɩ tɩn. O ma daarɩ o ta dɩ ba o wɩ, ba kɩ wʋdiu ba pa bu wʋm sɩ o di. ");
INSERT INTO xsm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zezi dɛɛn ma nuŋi jǝgǝ kam kʋntʋ nɩ, yɩ o joori o vu o tɩtɩ tɩʋ. O karabiǝ bam dɩ tɔg-o ba vu. ");
INSERT INTO xsm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Zwifǝ bam siun dɛ na yi tɩn, o ma vu o zʋ ba Wɛ-digǝ kam yɩ o puli sɩ o brɩ-ba Wɛ taanɩ. Nɔɔna zanzan maa wʋra yɩ ba cǝgi o zaasɩm dɩm. Ba na ni tɩn, kʋ ma sʋ-ba lanyɩranɩ. Ba maa tɛ ba wɩ: «Nɔɔnʋ wʋntʋ kɩ ta mʋ o lwarɩ wǝǝnu tɩntʋ doŋ? O kɩ ta mʋ o jɩgɩ swan tɩntʋ, yɩ o jɩgɩ dam o ma kɩ wo-kɩnkagɩla yantʋ? ");
INSERT INTO xsm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kʋ daɩ wʋm mʋ yɩ da-lwarʋ wʋm na? Wʋm mʋ daɩ Mari bu wʋm na? Kʋ daɩ wʋm nyaana mʋ yɩ Zakɩ dɩ Zʋzɛfʋ dɩ Zudasɩ dɩ Simɔn na? Kʋ daɩ wʋm nakwa mʋ wʋ dɩbam tɩtarɩ nɩ tɩn na?» Kʋntʋ ŋwaanɩ mʋ ba dɛɛn wʋ sɛ nɩ Zezi sɩɩnɩ o nuŋi Wɛ te. ");
INSERT INTO xsm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","O laan ma ta dɩ ba o wɩ: «Nɔɔnʋ na yɩ Wɛ nijoŋnu, nɔɔna yǝni ba pa-o zulǝ lanyɩranɩ, kʋ daarɩ o tɩtɩ tɩʋ tiinǝ dɩ o sɔŋɔ tiinǝ dɩ o cʋrrʋ nan bá nɩg-o.» ");
INSERT INTO xsm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","O dɛɛn ma wʋ kɩ wo-kɩnkagɩla ba tee nɩ. Kʋ na daɩ o na kwe o jɩŋa o daŋɩ yawɩɩna fɩnfɩɩn baŋa nɩ o pa ba na yazurǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kʋ ma sʋ Zezi dɩ ba na wʋ kɩ ba wʋ-dɩdʋa dɩd-o tɩn. Zezi dɛɛn maa tʋlɩ tɩ-balwa bam o karɩ o brɩ nɔɔna Wɛ cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","O laan ma bǝŋi o karabiǝ fugǝ-bale bam sɩ ba ba o te. O ma lɩ-ba bale bale sɩ o tʋŋɩ-ba, yɩ o pa-ba dam sɩ ba wanɩ ba zǝli ciciri nɔɔna yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","O ma ta dɩ ba o wɩ: «Á na maa ve, á yɩ zaŋɩ á kwe kʋlʋkʋlʋ á wǝli da á ja á vu, kʋ na daɩ nacǝgǝ yɩranɩ. Á nan yɩ kwe wʋdiu naa tampɔgɔ. Á yɩ kwe sǝbu á kɩ gwar-fwɛɛla nɩ á wǝli da. ");
INSERT INTO xsm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Zʋ-na natra, sɩ á yɩ kwe gwaarʋ tɩle tɩle. ");
INSERT INTO xsm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Á na ve á zʋ sɔŋɔ kʋlʋ á pǝni da, sɩ á taá zʋʋrɩ daanɩ sɩ kʋ ba kʋ yi á viirim maŋa. ");
INSERT INTO xsm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kʋ daarɩ, á na yi tɩʋ kʋlʋ yɩ ba na wʋ sɛ sɩ ba jeeri abam lanyɩranɩ, naa ba na wʋ cǝgi abam taanɩ, sɩ á nuŋi tɩʋ kʋm kʋntʋ nɩ. Á na maa viirǝ, sɩ á pɩɩsɩ á nɛ fogo á yagɩ da, sɩ kʋ pa nɔɔna bam lwarɩ nɩ ba wʋ kɩ lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","O na tagɩ kʋntʋ dɩ ba o ti tɩn, ba laan ma nuŋi ba vu ba tɔɔlɩ Wɛ kwǝrǝ, ba brɩ nɔɔna nɩ ba maŋɩ sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ tɩm. ");
INSERT INTO xsm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ba ma zǝli ciciri zanzan nɔɔna yɩra nɩ. Ba ma kwǝri ba kwe nugǝ ba ma dwe yawɩɩna zanzan, yɩ ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pɛ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Erɔdɩ. O ma ba o ni Zezi ŋwa, nɔɔna zanzan na jɩgɩ o taanɩ ba ŋɔɔnɩ tɩn ŋwaanɩ. Nɔɔna badonnǝ maa tɛ ba wɩ: «Kʋ yɩ Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn mʋ joori o bi o yagɩ tʋʋnɩ. Kʋntʋ ŋwaanɩ mʋ o jɩgɩ dam yɩ o waɩ wo-kɩnkagɩla o kɩa.» ");
INSERT INTO xsm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nɔɔna badaara maa wɩ: «Kʋ yɩ Wɛ nijoŋnu Eli mʋ tuǝ.» Badaara dɩ ta maa wɩ: «O yɩ Wɛ nijoŋnu mʋ, nɩnɛɛnɩ balʋ na tɔɔlɩ Wɛ kwǝrǝ faŋa faŋa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kʋ daarɩ, Pɛ Erɔdɩ na ni Zezi ŋwa tɩn, o ma ta o wɩ: «Kʋʋ́ ta yɩ Zan wʋlʋ amʋ na pɛ ba go o yuu tɩn mʋ joori o bi o yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","O dɛɛn tagɩ kʋntʋ, bɛŋwaanɩ o ya wʋ kɩ Zan lanyɩranɩ. O pɛ ba ja Zan ba vɔ ba kɩ pɩɩna digǝ nɩ. Kʋ dɛɛn kɩ tɩntʋ doŋ mʋ: Erɔdɩ ya di kaanɩ wʋdoŋ, o yɩrɩ mʋ Erɔdɩadɩ. Kaanɩ wʋm dɛɛn yɩ o zɩmbaarʋ Filipi kaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Zan dɛɛn ma ta dɩd-o nɩ, kʋ culǝ sɩ o di o zɩmbaarʋ kaanɩ yɩ o ta ŋwɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kʋntʋ ŋwaanɩ mʋ Erɔdɩadɩ culi Zan. O maa lagɩ sɩ ba gʋ-o, yɩ o wʋ nɛ cwǝŋǝ, ");
INSERT INTO xsm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bɛŋwaanɩ Erɔdɩ dɛɛn kwarɩ Zan. O maa ye nɩ Zan yɩ wʋ-poŋo tu yɩ o tɛ cɩga. Kʋntʋ ŋwaanɩ Erɔdɩ ma fɔg-o o nii lanyɩranɩ, sɩ kʋlʋkʋlʋ yɩ kɩ-o. O maa yǝni o cǝgi o taanɩ dɩ wʋpolo, yɩ kʋ pa o wʋbʋŋa vugimi. ");
INSERT INTO xsm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Erɔdɩadɩ dɛɛn laan ma ba o na cwǝŋǝ sɩ ba gʋ Zan. Pɛ Erɔdɩ lʋra maŋa na tu ka yi tɩn, o ma kɩ candiǝ yɩ o bǝŋi o tɩʋ kʋm dɩdɛɛra bam dɩ pamaŋna yigǝ tiinǝ, dɩ nadunǝ balʋ na zʋʋrɩ Galile nɩ tɩn, sɩ ba tɔgɩ ba di candiǝ kam. ");
INSERT INTO xsm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ba na wʋra ba di candiǝ kʋntʋ tɩn, Erɔdɩadɩ bukɔ laan ma zaŋɩ o zʋ o sa o brɩ vǝrǝ bam. Kʋ ma pa pɛ wʋm dɩ o vǝrǝ bam wʋ poli lanyɩranɩ. Pɛ wʋm ma ta dɩ bukɔ wʋm o wɩ: «Woŋo kʋlʋ maama nmʋ na lagɩ tɩn, amʋ wʋ́ pa-m.» ");
INSERT INTO xsm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O ta ma ta o du o wɩ: «Aá pa-m woŋo kʋlʋ maama n na wʋ́ loori a tee nɩ tɩn. Kʋ na maŋɩ kʋ yɩ a tɩʋ kʋm cicoro dɩ, a ta wʋ́ pa-m.» ");
INSERT INTO xsm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bukɔ wʋm na ni kʋntʋ tɩn, o ma nuŋi o vu o nu te o bwe-o o wɩ: «Bɛɛ woŋo mʋ amʋ wʋ́ loori?» O ma lǝri o wɩ: «Ve n ta nɩ n lagɩ sɩ o go Zan yuu mʋ o pa-m.» ");
INSERT INTO xsm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bukɔ wʋm ma kɩ lɩla o joori o zʋ pɛ wʋm te, yɩ o ta dɩd-o o wɩ: «A lagɩ sɩ n go Zan yuu mʋ n kɩ zʋŋ-tanlaŋa wʋnɩ n pa-nɩ lele.» ");
INSERT INTO xsm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pɛ Erɔdɩ na ni kʋntʋ tɩn, o wʋ ma tiini kʋ cɔgɩ zanzan. O nan na tagɩ o du vǝrǝ bam yigǝ nɩ tɩn, o maa ba lagɩ sɩ o vɩn. ");
INSERT INTO xsm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","O ma kɩ lɩla o tʋŋɩ o pamaŋnʋ dɩdʋa sɩ o vu o go Zan yuu kʋm o ja ba. Nɔɔnʋ wʋm ma vu pɩɩna digǝ kam o go Zan yuu kʋm. ");
INSERT INTO xsm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","O ma kwe-kʋ o kɩ zʋŋ-tanlaŋa wʋnɩ o ja ba o pa bukɔ wʋm. O ma joŋi o ja vu o pa o nu. ");
INSERT INTO xsm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zan karabiǝ bam na lwarɩ kʋlʋ na kɩ tɩn, ba ma zaŋɩ ba vu ba kwe o yɩra yam ba ja vu ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zezi karabiǝ fugǝ-bale bam ma joori ba ba o te. Ba ma ta ba brɩ-o kʋlʋ maama ba na kɩa, dɩ ba na brɩ nɔɔna Wɛ cɩga kam te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nɔɔna zanzan maa yǝni ba tui Zezi te, yɩ ba joori ba viirǝ. Ba na daga kʋntʋ tɩn, Zezi dɩ o karabiǝ bam daa warɩ ba na pwǝlǝ sɩ ba di wʋdiu dɩ. Kʋntʋ ŋwaanɩ o ma ta dɩ ba o wɩ: «Abam nan ba á yɩranɩ, sɩ dɩ́ vu gaa wʋ sɩ á wanɩ á sin fɩnfɩɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ba laan ma vu ba zʋ naboro, sɩ ba vu je sɩlʋ na yɩ gaa wʋ tɩn ba yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ba na maa kɛ tɩn, nɔɔna zanzan ma na-ba yɩ ba lwarɩ-ba. Ba ma zaŋɩ ba nuŋi ba tɩɩnɩ dɩm maama nɩ, ba duri dɩ nɛ ba vu ba loori-ba jǝgǝ kalʋ ba na maa ve tɩn nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zezi ma nuŋi naboro kʋm wʋnɩ. O laan ma na nɔn-kɔgɔ kʋm na tu kʋ wʋra. Ba ŋwaŋa ma zʋ-o lanyɩranɩ, bɛŋwaanɩ ba nyɩ dɩ peeni sɩlʋ na ba jɩgɩ nayɩrʋ sɩ o taa nii sɩ baŋa nɩ tɩn. O laan ma puli o wʋra o brɩ-ba wǝǝnu zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kʋ na tiini kʋ daanɩ yɩ wɛ ba wʋra dɩ zʋʋrɩ tɩn, o karabiǝ bam ma vu ba ta dɩd-o ba wɩ: «Maŋa kam wʋra ka kɛa, yɩ jǝgǝ kalʋ dɩbam na wʋra tɩn yɩ gaa wʋ mʋ. Wʋdiu tǝri yo. ");
INSERT INTO xsm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kʋntʋ ŋwaanɩ, pa nɔɔna bam vu sam wʋnɩ ba yǝgi wʋdiu ba di.» ");
INSERT INTO xsm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O ma lǝri-ba o wɩ: «Abam tɩtɩ pa-ba wʋdiu sɩ ba di.» Ba ma ta ba wɩ: «Dɩ́ na lagɩ dɩ́ yǝgi dɩpɛ sɩ dɩ yi ba maama dim, kʋʋ́ yi nɩnɛɛnɩ sǝbu-dala biǝ yale mʋ (200). Dɩ́ wʋ́ wanɩ dɩ́ yǝgi kʋntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","O laan ma bwe-ba o wɩ: «Abam jɩgɩ dɩpwa yagra mʋ? Ve-na á nii.» Ba na ve ba nii tɩn, ba ma joori ba ba, ba ta dɩd-o ba wɩ: «Ya yɩ dɩpwa yanu dɩ kale sɩle yɩranɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Zezi laan ma pa o karabiǝ bam ni, sɩ ba pa nɔɔna bam pɔɔrɩ kɔgɔ kɔgɔ ba jǝni tɩga nɩ ga-lɩʋ kʋm baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ba maama ma pɔɔrɩ yɩ ba jǝni, badaara kɔgɔ bi bi, badaara kɔgɔ fiinnu fiinnu. ");
INSERT INTO xsm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zezi laan ma kwe dɩpwa yanu yam dɩ kale sɩle sɩm, yɩ o kwǝni o yuu wɛɛnɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma fɔ fɔ dɩpwa yam o maŋɩ o pa o karabiǝ bam, sɩ ba laan joŋi-ya ba ja vu ba maŋɩ ba pa nɔɔna bam. O ma daarɩ o maŋɩ kale sɩle sɩm dɩ o pa ba maama sɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nɔɔna bam maama ma di ba su ba daarɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Zezi karabiǝ bam ma pɛ dɩpwa dɩ kale cicwǝǝru tɩlʋ na daarɩ tɩn ba su tɩtwarʋ fugǝ-tɩle. ");
INSERT INTO xsm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nɔɔna balʋ dɛɛn na di kʋntʋ tɩn yɩ baara mʋrr-tɩnu mʋ (5.000), kʋ wǝli dɩ kaana dɩ biǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kʋntʋ kwaga nɩ Zezi ma da o pa o karabiǝ bam vu ba zʋ naboro kʋm, sɩ ba da yigǝ ba bɛ nɩnɩʋ kʋm ba vu ba yi Betisayida. Ba na maa kɛ tɩn, o ma pa kɔgɔ kʋm viiri. ");
INSERT INTO xsm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","O na pɛ ba viiri tɩn, o ma vu o di piu yuu sɩ o warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tɩga ma ba ka yi. Naboro kʋm maa wʋ nɩnɩʋ kʋm tɩtarɩ nɩ, yɩ Zezi ta wʋ buburu kʋm nɩ o yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O ma na o karabiǝ bam na tiini ba kwaanɩ ba yɛ yɩ kʋ cɛ ba yɩra nɩ, vu-fɔrɔ na zaŋɩ kʋ jeeri-ba tɩn ŋwaanɩ. Tɩga na wʋra ka pʋʋrɩ tɩn, Zezi ma zaŋɩ o ve na bam baŋa nɩ o maa ve ba te. O ma vu o lagɩ o gaalɩ-ba o kɛ. ");
INSERT INTO xsm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba na nɛ-o o ve na bam baŋa nɩ tɩn, ba ya bʋŋɩ nɩ kʋ yɩ ciru mʋ. Ba ma kaasɩ baŋa baŋa, ");
INSERT INTO xsm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bɛŋwaanɩ ba maama nɛ-o yɩ fʋʋnɩ zʋ-ba zanzan. Zezi laan ma ŋɔɔnɩ dɩ ba o wɩ: «Pa-na á wʋrʋ kɩ dam, sɩ kʋ yɩ amʋ mʋ. Á yɩ pa fʋʋnɩ taa jɩgɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O laan ma vu o zʋ naboro kʋm wʋ. O na yi ba te kʋntʋ tɩn, viu kʋm ma da kʋ kwǝri. Kʋ ma tiini kʋ sʋ-ba, ");
INSERT INTO xsm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","bɛŋwaanɩ Zezi na maŋɩ dɩpɛ dɩm o pa nɔn-kɔgɔ kʋm yɩ ba di tɩn, ba wʋ ni wo-kɩnkagɩlɩ dɩm kʋntʋ kuri, Wɛ cɩga kam na wʋ wanɩ ka zʋ ba wʋbʋŋa tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ba ma vu ba bɛ ba yi bubɛ dɩdɩm dɩm. Ba ma ja naboro kʋm ba ja nuŋi ba zɩgɩ da. Ba na yi je sɩlʋ tɩn yɩrɩ mʋ Zenezarɛtɩ. ");
INSERT INTO xsm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ba na nuŋi naboro kʋm wʋnɩ tɩn, nɔɔna bam ma lwarɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ba laan ma duri je sɩm kʋntʋ maama nɩ, ba vu ba ta ba pa nɔɔna lwarɩ. Mɛ maama ba na lwarɩ nɩ o tu da tɩn, ba ma kwe balʋ na ba jɩgɩ yazurǝ tɩn ba zɩŋɩ gungwǝǝlu wʋnɩ ba ja vu o te. ");
INSERT INTO xsm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","O na yǝni o ve je sɩlʋ maama tɩn, kʋ na yɩ tɩ-balɛ naa tɩ-kamunǝ, nɔɔna yǝni ba ja yawɩɩna mʋ ba nuŋi ba jeer-o yaga ni nɩ, yɩ ba loor-o sɩ o pa-ba cwǝŋǝ sɩ ba dwe o gɔrɔ kʋm ni má. Balʋ maama na dwe o gɔrɔ kʋm kʋntʋ tɩn dɛɛn nɛ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farizɩan tiinǝ badaara dɩ Wɛ cullu karanyɩna tiinǝ badonnǝ dɛɛn ya nuŋi Zeruzalɛm ba ba, ba gilimi Zezi tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba ma na o karabiǝ badonnǝ na je ba di wʋdiu, yɩ ba wʋ sanɩ ba jɩa sɩ kʋ tɔgɩ bantʋ cullu tɩm cwǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bɛŋwaanɩ Farizɩan tiinǝ bam dɩ Zwifǝ bam maama ba fɔgɩ ba di wʋdiu, yɩ ba wʋ sanɩ ba jɩa sɩ kʋ tɔgɩ cullu tɩlʋ ba nabaara bam na pɛ-ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ba na yǝni ba zɩgɩ yaga nɩ ba ba sɔŋɔ, baá kɩ na mʋ ba ma zarɩ ba tɩtɩ sɩ ba ji lanyɩranɩ, yɩ ba laan daarɩ ba di wʋdiu. Ba ta jɩgɩ cullu tɩdonnǝ zanzan ba na tɔgɩ-tɩ ba wǝli da. Ba yǝni ba fɔgɩ ba sɩn ba zwɩ dɩ ba kɔɔra dɩ ba luu-kambi, yɩ ba laan daarɩ ba kɩ wʋdiu da. ");
INSERT INTO xsm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kʋ yɩ kʋntʋ ŋwaanɩ mʋ Farizɩan tiinǝ bam dɩ Wɛ cullu karanyɩna tiinǝ bam dɛɛn bwe Zezi ba wɩ: «Bɛɛ mʋ yɩ n karabiǝ bam yǝni ba di wʋdiu, yɩ ba wʋ sanɩ ba jɩa nɩ dɩbam nabaara bam na pɛ dɩbam cullu tɩlʋ tɩn?» ");
INSERT INTO xsm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","O ma lǝri-ba o wɩ: «Abam yɩ pipiri-nyɩna mʋ. Wɛ nijoŋnu Ezayi dɛɛn jɩgɩ bʋra dɩ o na maŋɩ o ta abam taanɩ faŋa faŋa te tɩn. Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Nɔɔna bantʋ zuli amʋ Wɛ dɩ ba niǝ mʋ, yɩ ba wʋbʋŋa baŋwɛ dɩ amʋ. ");
INSERT INTO xsm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ba na paɩ amʋ zulǝ yalʋ maama tɩn yɩ kafɛ mʋ. Ba yǝni ba brɩ nabiinǝ wʋbʋŋa cullu, yɩ ba paɩ tɩ yɩ amʋ zaasɩm dɩm mʋ.› ");
INSERT INTO xsm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kʋntʋ, abam kwe Wɛ niǝ yam na brɩ te tɩn á yagɩ mʋ, yɩ á daarɩ á tɔgɩ nabiinǝ cullu.» ");
INSERT INTO xsm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","O daa ta ma ta dɩ ba o wɩ: «Abam yǝni á vɩn Wɛ niǝ yam, yɩ á daarɩ á jɩgɩ á tɩtɩ wʋbʋŋa cullu mʋ á tɔga. ");
INSERT INTO xsm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Faŋa faŋa tɩn, Moyisi dɛɛn brɩ Wɛ ni dɩm o wɩ, nɔɔnʋ maŋɩ sɩ o taa zuli o nu dɩ o ko. O daa ta brɩ nɩ, nɔɔnʋ na ŋɔɔnɩ ta-balɔrɔ dɩ o nu naa o ko, kʋntʋ tu maŋɩ sɩ ba gʋ-o mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kʋ daarɩ abam nan yǝni á ja Wɛ taanɩ dɩm á gugwǝli mʋ yɩ á wɩ, nɔɔnʋ na jɩgɩ woŋo kʋlʋ o ya na wʋ́ ma o zǝni o nu dɩ o ko tɩn, yɩ o na tagɩ dɩ ba o wɩ, woŋo kʋm kʋntʋ yɩ ‹Kɔrɩban› mʋ (kʋ kuri mʋ kʋ yɩ Wɛ nyɩm), ");
INSERT INTO xsm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kʋ brɩ nɩ kʋntʋ tu daa wʋ maŋɩ sɩ o kwe woŋo kʋm o ma zǝni o nu dɩ o ko. ");
INSERT INTO xsm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Abam na brɩ nɔɔna sɩ ba taa tɔgɩ á tɩtɩ cullu tɩn paɩ Wɛ taanɩ dɩm daa ba jɩgɩ kuri abam tee nɩ. Abam nan ta yǝni á kɩ wo-balwaarʋ tɩntʋ donnǝ zanzan á wǝli da.» ");
INSERT INTO xsm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zezi daa ta ma bǝŋi nɔn-kɔgɔ kʋm sɩ ba ba o te, yɩ o ta dɩ ba o wɩ: «Abam maama cǝgi lanyɩranɩ sɩ á ni a taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kʋ daɩ woŋo kʋlʋ na tɔgɩ nɔɔnʋ ni kʋ zʋ o wʋ tɩn mʋ wʋ́ wanɩ kʋ cɔg-o. Kʋ yɩ woŋo kʋlʋ na tɔgɩ nɔɔnʋ ni kʋ nuŋi tɩn mʋ wʋ́ cɔg-o.  ");
INSERT INTO xsm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Á nan fɔgɩ á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","O laan ma vu o zʋ sɔŋɔ o daarɩ nɔn-kɔgɔ kʋm pooni nɩ. O karabiǝ bam ma bwe-o taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O ma ta dɩ ba o wɩ: «Abam dɩ ba jɩgɩ wʋbʋŋa na? Á maŋɩ sɩ á taá ye nɩ, woŋo kʋlʋ maama nɔɔnʋ na wʋ́ kwe o pa kʋ tɔgɩ o ni kʋ zʋ o wʋ tɩn bá wanɩ kʋ cɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bɛŋwaanɩ kʋ bá wanɩ kʋ zʋ o wʋbʋŋa. Kʋ nan wʋ́ tu o kana yɩranɩ mʋ, yɩ o laan daarɩ o tɔ-kʋ o yagɩ.» Zezi dɛɛn na tagɩ cɩga kam kʋntʋ tɩn, o brɩ nɩ wʋdiiru maama maŋɩ sɩ nɔɔna taa di-tɩ. ");
INSERT INTO xsm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O daa ta ma ta o wɩ: «Kʋ yɩ kʋlʋ na maŋɩ kʋ wʋ nɔɔnʋ wʋnɩ yɩ kʋ laan nuŋi tɩn mʋ cɔg-o. ");
INSERT INTO xsm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bɛŋwaanɩ kʋ yɩ nɔɔnʋ wʋbʋŋa mʋ paɩ o lagɩ wo-balwaarʋ kǝm, kʋ na yɩ boorim wo-zɔɔna dwi maama, dɩ ŋwɩɩnɩ, dɩ nɔn-gʋra, ");
INSERT INTO xsm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","dɩ wo-swǝnǝ zanzan, dɩ pu-sɩŋa, dɩ kampinǝ, dɩ wo-digiru kikiǝ, dɩ wʋ-gʋrʋ, dɩ bɩbara dɩ nɔn-tʋra, dɩ kamunni, dɩ jwǝrim. ");
INSERT INTO xsm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wo-balwaarʋ tɩntʋ maama nuŋi nɔɔnʋ wʋnɩ mʋ yɩ tɩ cɔg-o.» ");
INSERT INTO xsm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zezi dɛɛn ma nuŋi je sɩm kʋntʋ nɩ o vu Tiiri nawurǝ yam seeni. O maa vu o zʋ sɔŋɔ kʋdoŋ. O ma ba lagɩ sɩ nɔɔna lwarɩ nɩ o wʋra, yɩ o wʋ wanɩ o sǝgi o tɩtɩ dɩ nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kaanɩ wʋdoŋ maa wʋra, o na yɩ dwi-gɛ tu. Ba ya lʋg-o Siiri nɩ mʋ, je sɩlʋ yɩrɩ na yɩ Fenisi tɩn. Cicirǝ maa jɩgɩ o bukɔ ka yaara. O maa na ni Zezi ŋwa tɩn, o ma kɩ lɩla o vu o te, yɩ o kuni doonǝ o yigǝ nɩ o loor-o, sɩ o zǝli cicirǝ kam o pa ka yagɩ o bukɔ wʋm yɩra. ");
INSERT INTO xsm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zezi ma ta dɩd-o o wɩ: «Biǝ bam mʋ maŋɩ sɩ ba da yigǝ ba di ba daarɩ. Kʋ wʋ maŋɩ sɩ nɔɔnʋ joŋi o biǝ wʋdiu o dɩ kakuri yigǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kaanɩ wʋm maa lǝri o wɩ: «Amʋ tu, n tagɩ cɩga. Kakuri sɩlʋ nan na tigi taabʋlʋ kuri nɩ tɩn waɩ sɩ twɛ wʋdiu kʋlʋ biǝ bam na di yɩ kʋ siiri tɩga nɩ tɩn sɩ di.» ");
INSERT INTO xsm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","O laan ma ta dɩ kaanɩ wʋm o wɩ: «Nmʋ lǝrǝ yam na lana tɩn ŋwaanɩ, a sɛ n loro kʋm. Joori n vu sɔŋɔ. Cicirǝ kam maŋɩ ka yagɩ n bukɔ wʋm yɩra.» ");
INSERT INTO xsm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kaanɩ wʋm ma sɩɩnɩ o joori o vu sɔŋɔ. O ma na o bukɔ wʋm o tigi o tigǝ je nɩ, dɩ cicirǝ kam nuŋi ka daar-o. ");
INSERT INTO xsm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zezi laan ma zaŋɩ o nuŋi Tiiri nawurǝ yam nɩ o da Sidɔn o kɛ. O laan ma tɔgɩ je sɩlʋ ba na bǝ nɩ Tɩɩnɩ Fugǝ tɩn o vu o yi Galile nɩnɩʋ kʋm je sɩm. ");
INSERT INTO xsm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nɔɔnʋ ma wʋra o na yɩ zwa-kɔgɔ yɩ o warɩ o ŋɔɔnɩ lanyɩranɩ. Ba ma ja-o ba vu Zezi te. Ba ma loor-o sɩ o kwe o jɩŋa o daŋɩ nɔɔnʋ wʋm baŋa nɩ sɩ o pa o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zezi ma ja-o o vu daa o yɩranɩ o daarɩ kɔgɔ kʋm. O ma kwe o nwa o tʋrɩ nɔɔnʋ wʋm zwa nɩ, yɩ o daarɩ o twɩ lileeru o kɩ o nʋa nɩ o ma dwe o dindǝlimi. ");
INSERT INTO xsm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","O ma kwǝni o yuu o nii wɛɛnɩ, yɩ o suuri. O ma ta dɩ nɔɔnʋ wʋm o wɩ: «Efata», kʋ kuri mʋ Pʋrɩ! ");
INSERT INTO xsm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","O na tagɩ kʋntʋ tɩn, o zwa yam ma sɩɩnɩ ya pʋrɩ, yɩ o dindǝlimi dɩ waɩ dɩ pipirǝ. O maa waɩ o ŋɔɔnɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zezi ma kaanɩ nɔɔna bam maama, sɩ ba yɩ ta kʋlʋ na kɩ tɩn ba brɩ nɔɔn-nɔɔnʋ. O na kaanɩ-ba kʋntʋ tɩn, mʋ ba laan fɔgɩ ba tɛ dɩ nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kʋ ma tiini kʋ sʋ balʋ maama na ni tɩn zanzan. Ba maa wɩ: «Woŋo kʋlʋ maama o na kɩ tɩn yɩ lanyɩranɩ mʋ. O paɩ zwa-kwarʋ joori tɩ ni, yɩ mɩmaarʋ dɩ waɩ tɩ ŋɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kantʋ maŋa kam nɩ kɔgɔ zanzan daa ma joori kʋ gilimi daanɩ Zezi tee nɩ. Ba maa ba jɩgɩ kʋlʋkʋlʋ sɩ ba di. Zezi ma bǝŋi o karabiǝ bam yɩ ba ba o te. O ma ta dɩ ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nɔɔna bantʋ ŋwaŋa jɩgɩ-nɩ, dɩ ba na tu ba wʋ a tee nɩ zɩm da yatɔ yɩ ba daa ba jɩgɩ wʋdiu sɩ ba di tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A na pɛ ba viiri yɩ ba wʋ di kʋlʋkʋlʋ, kana wʋ́ pa ba bǝri cwǝŋǝ nɩ, bɛŋwaanɩ ba badaara nuŋi yigǝ yigǝ mʋ ba ba amʋ te.» ");
INSERT INTO xsm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","O karabiǝ bam ma lǝr-o ba wɩ: «Dɩ́ nan wʋ́ kɩ ta mʋ dɩ́ na wʋdiu gaa kʋntʋ wʋnɩ sɩ kʋ yi ba maama dim?» ");
INSERT INTO xsm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","O ma bwe-ba o wɩ: «Abam jɩgɩ dɩpwa yagra mʋ?» Ba ma lǝri ba wɩ: «Ya yɩ yarpɛ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Zezi laan ma ta dɩ kɔgɔ kʋm sɩ ba maama jǝni tɩga nɩ. O ma kwe dɩpwa yarpɛ yam yɩ o kɩ Wɛ le ya ŋwaanɩ. O ma ja-ya o fɔ fɔ o pa o karabiǝ bam, yɩ bantʋ dɩ laan joŋi ba ja vu ba pa nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ba dɛɛn jɩgɩ kalǝŋ-balɛ fɩnfɩɩn ba wǝli da. Zezi ma kwe-sɩ o kɩ Wɛ le, yɩ o daarɩ o ta dɩ o karabiǝ bam sɩ ba kwe sɩntʋ dɩ ba maŋɩ ba pa nɔɔna bam maama. ");
INSERT INTO xsm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ba maama ma di ba su ba daarɩ. Ba laan ma twɛ cicwǝǝru tɩlʋ na daarɩ tɩn ba su tɩtwarʋ tɩrpɛ. ");
INSERT INTO xsm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Balʋ dɛɛn na di kʋntʋ tɩn yɩ baara mʋrr-tɩna mʋ (4.000), kʋ wǝli dɩ kaana dɩ biǝ dɩ. Zezi laan ma pa kɔgɔ kʋm viiri. ");
INSERT INTO xsm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","O ma daarɩ o vu o zʋ naboro dɩ o karabiǝ bam. Ba ma vu ba yi jǝgǝ kalʋ yɩrɩ na yɩ Dalɩmanuta tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farizɩan tiinǝ badonnǝ dɛɛn ma ba Zezi te ba ma puli ba magɩ kantɔgɔ dɩd-o, yɩ ba lagɩ sɩ ba maŋ-o ba nii. Ba ma ta dɩd-o, sɩ o kɩ wo-kɩnkagɩlɩ dɩlʋ na wʋ́ brɩ-ba nɩ o dam dɩm nuŋi Wɛ tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","O ma tiini o suuri o wʋnɩ, yɩ o ta o wɩ: «Bɛɛ mʋ yɩ zɩm nɔɔna bam lagɩ sɩ a kɩ wo-kɩnkagɩlɩ a brɩ-ba? A lagɩ a ta cɩga mʋ dɩ abam sɩ, a bá kɩ wo-kɩnkagɩlɩ a brɩ-ba.» ");
INSERT INTO xsm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","O na tagɩ kʋntʋ tɩn, o ma yagɩ ba te, yɩ o joori o vu o zʋ naboro kʋm sɩ ba vu ba bɛ bubɛ dɩdɩm dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ba dɛɛn na wʋ naboro kʋm wʋnɩ ba maa ve ba bɛ tɩn, Zezi karabiǝ bam ya swe sɩ ba ja dɩpɛ ba wǝli da, dɩpɛ dɩdʋa yɩranɩ mʋ ba ya jɩga. ");
INSERT INTO xsm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Zezi ma ta dɩ ba o wɩ: «Fɔgɩ-na á cɩ á tɩtɩ sɩ á yɩ pa Farizɩan tiinǝ bam dɩ Pɛ Erɔdɩ dɩ abam ba dabɩlɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","O na tagɩ dɩ ba kʋntʋ tɩn, ba ma ŋɔɔnɩ daanɩ ba wɩ: «Kʋ yɩ dɩpɛ taanɩ mʋ o tɛa, dɩ́ na ba jɩgɩ tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zezi ma lwarɩ ba na jɩgɩ kʋlʋ ba ŋɔɔnɩ tɩn, yɩ o wɩ: «Bɛɛ mʋ yɩ á ŋɔɔnɩ daanɩ á wɩ, á na ba jɩgɩ dɩpɛ tɩn mʋ te a ŋɔɔnɩ kʋntʋ? Abam ta wʋ lwarɩ Wɛ na jɩgɩ dam te tɩn na? Á wʋbʋŋa tɩgɩ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Abam jɩgɩ yiǝ yɩ ya ba naɩ Wɛ cɩga kam. Á jɩgɩ zwa yɩ á ba ni Wɛ taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Abam maŋɩ á swe a dɛɛn na kwe dɩpwa yanu mʋ a fɔ fɔ a pa baara mʋrr-tɩnu tɩm yɩ ba di na? Ba na di ba ti tɩn, abam twɛ cicwǝǝru tɩm á su tɩtwarʋ tɩgra mʋ?» Ba ma lǝr-o ba wɩ: «Tɩtwarʋ fugǝ-tɩle.» ");
INSERT INTO xsm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","O daa ma bwe-ba o wɩ: «A daa ta na kwe dɩpwa yarpɛ yam a fɔ fɔ a pa baara mʋrr-tɩna tɩm yɩ ba di tɩn, á twɛ cicwǝǝru tɩm á su tɩtwarʋ tɩgra mʋ?» Ba ma lǝr-o ba wɩ: «Tɩtwarʋ tɩrpɛ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","O laan ma ta dɩ ba o wɩ: «Abam nan daa ta ba ni kʋ kuri mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ba dɛɛn ma vu ba yi Betisayida. Nɔɔna badonnǝ ma ja lilwe ba ja vu Zezi te, yɩ ba loor-o sɩ o ma o jɩŋa o dwe-o, sɩ o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O ma ja lilwe wʋm jɩŋa o vaŋɩ o ja nuŋi tɩʋ kʋm daa. O ma twɩ lileeru o kɩ o yiǝ nɩ, yɩ o daŋɩ o jɩa lilwe wʋm baŋa nɩ. O laan ma bwe-o o wɩ: «Nmʋ naɩ woŋo na?» ");
INSERT INTO xsm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lilwe wʋm ma puri o yiǝ o nii, yɩ o wɩ: «A naɩ nɔɔna mʋ. Ba nan nyɩ dɩ tweeru mʋ te yɩ ba veǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zezi daa ma daŋɩ o jɩa nɔɔnʋ wʋm yiǝ nɩ. O laan ma fin o yiǝ yam, yɩ ya joori ya naɩ. O maa waɩ o naɩ woŋo maama lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zezi laan ma ta dɩd-o o wɩ, o yɔɔrɩ o vu sɔŋɔ, sɩ o daa yɩ joori o zʋ tɩʋ kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zezi dɩ o karabiǝ bam daa ma kɛ, ba vu ba yi Sezaarɩ kʋlʋ na yɩ Filipi tɩʋ tɩn. Ba na maa ve tɩn, o ma bwe-ba o wɩ: «Nɔɔna yǝni ba tɛ ba wɩ, amʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ba ma lǝri ba wɩ: «Badaara tɛ ba wɩ, nmʋ yɩ Zan wʋlʋ dɛɛn na miisi nɔɔna na wʋnɩ tɩn mʋ. Babam dɩ maa tɛ ba wɩ, nmʋ yɩ Wɛ nijoŋnu Eli mʋ. Badonnǝ dɩ maa tɛ ba wɩ, nmʋ yɩ faŋa faŋa Wɛ nijoŋnǝ bam dɩdʋa mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O laan ma bwe-ba o wɩ: «Kʋ nan na yɩ abam, abam bʋŋɩ sɩ amʋ yɩ wɔɔ mʋ?» Pɩyɛɛrɩ ma lǝr-o o wɩ: «Nmʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zezi laan ma kaanɩ-ba sɩ ba yɩ ta kʋntʋ ba brɩ nɔɔn-nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kʋ na zɩgɩ kantʋ maŋa kam nɩ, Zezi ma ŋɔɔnɩ o brɩ-ba o wɩ: «Amʋ Nabiin-bu wʋm maŋɩ sɩ a na yaara zanzan. Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam mʋ wʋ́ culi amʋ. Baá gʋ-nɩ, yɩ da yatɔ dɛ nɩ a laan wʋ́ joori a bi.» ");
INSERT INTO xsm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O maa ŋɔɔnɩ kʋntʋ jaja o brɩ-ba. Pɩyɛɛrɩ ma ja-o o vu daa, yɩ o kaan-o o wɩ, o yɩ taa ŋɔɔnɩ kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Zezi ma guni o nii o karabiǝ bam seeni, yɩ o bagɩ Pɩyɛɛrɩ o wɩ: «Sʋtaanɩ, ve daa a tee nɩ! Nmʋ wʋbʋŋa yam yɩ nabiinǝ nyɩm mʋ, sɩ ya ba tɔgɩ Wɛ na lagɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Zezi laan ma bǝŋi nɔn-kɔgɔ kʋm maama dɩ o karabiǝ bam sɩ ba ba o te. O ma ta dɩ ba o wɩ: «Nɔɔnʋ wʋlʋ maama na lagɩ sɩ o taa tɔgɩ amʋ kwaga tɩn, kʋntʋ tu maŋɩ sɩ o vɩn o tɩtɩ wʋbʋŋa sɩ o sɛ yaara nɩ wʋlʋ na zɩŋɩ tʋʋn-dagara o maa ve o tʋʋnɩ jǝgǝ te tɩn, sɩ o laan taa tɔgɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wʋlʋ maama nan na lagɩ sɩ o yɩrɩ o ŋwɩa tɩn, kʋntʋ tu wʋ́ ga-ka mʋ. Kʋ daarɩ, wʋlʋ maama na sɛ sɩ o ga o ŋwɩa amʋ ŋwaanɩ dɩ Wɛ kwǝr-ywǝŋǝ kam ŋwaanɩ, kʋntʋ tu wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nɔɔnʋ nan na nɛ lʋgʋ baŋa wǝǝnu tɩm maama, yɩ o laan na gɛ ŋwɩa Wɛ tee nɩ, bɛɛ nyɔɔrɩ mʋ o nɛa? ");
INSERT INTO xsm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kʋlʋkʋlʋ nan tǝrǝ nɔɔnʋ na wʋ́ wanɩ o ma lǝni o ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kʋntʋ tɩn, nɔɔnʋ wʋlʋ maama na kwarɩ cavɩɩra amʋ ŋwaanɩ dɩ amʋ taanɩ dɩm ŋwaanɩ zɩm nɔɔna bam tɩtarɩ nɩ, ba na yɩ nɔn-balwaarʋ yɩ ba yigǝ tǝrǝ dɩ Wɛ tɩn, amʋ Nabiin-bu wʋm dɩ wʋ́ kwarɩ kʋntʋ tu cavɩɩra, maŋa kam a na wʋ́ joori a ba lʋgʋ baŋa dɩ a Ko Wɛ paarɩ-zulǝ dɩ DƖ malɛsɩ sɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O daa ta ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔna balʋ zɩm na wʋ yo seeni tɩn badaara bá tɩ, yɩ baá na Wɛ paarɩ dɩm na wʋ́ ba nɔɔna tɩtarɩ nɩ dɩ dam te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Da yardʋ dɛɛn na kɛ tɩn, Zezi laan ma ja Pɩyɛɛrɩ dɩ Zakɩ dɩ Zan o pa ba tɔgɩ daanɩ ba vu ba di pu-kamunu yuu. Ba wʋra ba yɩranɩ. Ba na wʋra kʋntʋ tɩn, Zezi yibiyǝ ma lǝni ba yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","O gwaarʋ tɩm ma tiini tɩ pɩɩrɩ parɩ parɩ yɩ tɩ nyɩɩna. Tɩ pɩɩrɩ tɩ gaalɩ nabiinu na wʋ́ wanɩ o zarɩ o gwaarʋ o pa tɩ pɩɩrɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eli dɩ Moyisi ma da ba nuŋi ba yigǝ nɩ, yɩ ba ŋɔɔnɩ dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pɩyɛɛrɩ laan ma ta dɩ Zezi o wɩ: «Karanyɩna, dɩ́ na wʋ yo seeni tɩn, kʋ tiini kʋ lana kʋ pa dɩbam. Nan pa dɩ́ pu vwǝ yatɔ yo seeni, sɩ nmʋ dɩ Moyisi dɩ Eli taa zʋʋrɩ da.» ");
INSERT INTO xsm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Fʋʋnɩ dɛɛn zʋ-ba zanzan. Kʋntʋ ŋwaanɩ mʋ o garɩ o ŋɔɔnɩ kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kunkwǝǝnu laan ma ba tɩ kwǝli-ba. Ba ma ni kwǝrǝ na ŋɔɔnɩ tɩ wʋnɩ ka wɩ: «Wʋntʋ mʋ yɩ amʋ bu-dʋa a na so-o dɩ a wʋ maama. Á nan taá cǝgi o taanɩ lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ba ma da kwǝni ba nii jǝgǝ maama, yɩ ba daa wʋ nɛ nɔɔn-nɔɔnʋ, kʋ na daɩ Zezi yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ba ma zaŋɩ piu kʋm yuu nɩ ba maa tuǝ. Zezi laan ma kaanɩ-ba o wɩ: «Yɩ pa-na nɔɔn-nɔɔnʋ lwarɩ á na nɛ kʋlʋ tɩn, sɩ kʋ taa ve maŋa kalʋ amʋ Nabiin-bu wʋm na wʋ́ ba a bi a yagɩ tʋʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ba ma sɛ yɩ ba ŋɔɔnɩ ba yɩranɩ ba bwɛ ba nii, ka bi ka yagɩ tʋʋnɩ taanɩ dɩm kuri mʋ bɛɛ. ");
INSERT INTO xsm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ba laan ma bwe-o ba wɩ: «Wɛ cullu karanyɩna tiinǝ bam yǝni ba tɛ ba wɩ: Eli mʋ maŋɩ sɩ o da yigǝ o ba, sɩ Krisi wʋm laan da kwaga. Kʋ yɩ cɩga mʋ naa vwan mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zezi ma lǝri-ba o wɩ: «Kʋ yɩ cɩga mʋ. Eli maŋɩ sɩ o da yigǝ o ba o kwɛ woŋo maama, sɩ Krisi wʋm laan ba. Bɛɛ nan mʋ yɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ, Nabiin-bu wʋm maŋɩ sɩ o yaarɩ zanzan sɩ nɔɔna cul-o? ");
INSERT INTO xsm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Á nan taá ye-na nɩ, Eli maŋɩ o ba, yɩ nɔɔna tiini ba bɛɛs-o nɩ ba wʋbʋŋa na lagɩ te tɩn, nɩ kʋ na maŋɩ kʋ pʋpʋnɩ o woŋo Wɛ tɔnɔ kʋm wʋnɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zezi dɩ o karabiǝ batɔ bam laan ma joori ba vu ba yi o karabiǝ babam bam te. Ba ma na kɔgɔ zanzan na gilimi-ba. Wɛ cullu karanyɩna tiinǝ badonnǝ maa wʋra ba magɩ kantɔgɔ dɩdaanɩ ba. ");
INSERT INTO xsm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kɔgɔ kʋm na nɛ Zezi tɩn, ba ma tiini ba yɩ yǝǝu, yɩ ba duri ba vu o te ba jɔɔn-o. ");
INSERT INTO xsm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O ma bwe-ba o wɩ: «Bɛɛ ŋwaanɩ mʋ á zɩgɩ á magɩ kantɔgɔ dɩ ba?» ");
INSERT INTO xsm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nɔɔnʋ wʋdoŋ maa wʋ kɔgɔ kʋm wʋnɩ, o ma lǝr-o o wɩ: «Karanyɩna, a ya jaanɩ a bu mʋ a ba nmʋ te, sɩ n pa o na yazurǝ. Cicirǝ mʋ jɩg-o ka yaara, ka pa o warɩ o ŋɔɔnɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maŋa kalʋ ka na yǝni ka ja-o tɩn, ka yǝni ka dʋl-o ka dɩ tɩga nɩ mʋ. Lile-puŋǝ ma nuŋi o ni nɩ yɩ o dʋnɩ o yǝlǝ. O yɩra yam maama maa yǝni ya kʋ. A ma loori nmʋ karabiǝ bam sɩ ba zǝli cicirǝ kam sɩ ka yag-o, yɩ ba wʋ wanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zezi na ni kʋntʋ tɩn, o ma ta o wɩ: «Abam zɩm nɔɔna bam brɩ á ba jɩgɩ wʋ-dɩdʋa dɩ amʋ. Amʋ wʋ́ daanɩ abam tɩtarɩ nɩ a kɩ wʋ-zuru dɩ abam sɩ kʋ taa ve maŋa kɔɔ? Ja-na bu wʋm á ba.» ");
INSERT INTO xsm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ba ma ja-o ba vu o te. Cicirǝ kam na nɛ Zezi tɩn, ka ma su bu wʋm ka pa o yɩra saɩ pɔgɩ pɔgɩ. O ma tʋ tɩga nɩ o bibilǝ. Lile-puŋǝ maa nuŋi o ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zezi ma bwe bu wʋm ko o wɩ: «Maŋa kɔɔ mʋ kʋ puli kʋ kɩ-o kʋntʋ?» O ma lǝr-o o wɩ: «O biini nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kuni zanzan cicirǝ kam yǝni ka dʋl-o ka dɩ mini wʋnɩ dɩ na wʋnɩ mʋ, sɩ ka gʋ-o. Nmʋ nan na wʋ́ wanɩ, sɩ n duri dɩbam yibwǝnǝ n zǝni dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zezi ma lǝr-o o wɩ: «Nmʋ tagɩ n wɩ, amʋ na wʋ́ wanɩ mʋ. Wʋlʋ maama nan na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn, kʋlʋkʋlʋ tǝrǝ Wɛ na bá wanɩ DƖ kɩ DƖ pa kʋntʋ tu.» ");
INSERT INTO xsm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bu wʋm ko laan ma kaasɩ o wɩ: «A sɩɩnɩ a jɩgɩ wʋ-dɩdʋa dɩ nmʋ. Nan wǝli-nɩ sɩ a taa fɔgɩ a jɩga.» ");
INSERT INTO xsm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zezi ma na nɔn-kɔgɔ zanzan na durǝ kʋ maa bɩɩnɩ ba te. O laan ma bagɩ cicirǝ kam, yɩ o ta dɩ ka o wɩ: «Nmʋ wʋlʋ na paɩ nɔɔna jiri mɩmaarʋ dɩ zwa-kwarʋ tɩn, a tɛ dɩ nmʋ sɩ n nuŋi bu wʋm yɩra nɩ n viiri, sɩ n daa yɩ joori n yaar-o.» ");
INSERT INTO xsm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zezi na tagɩ kʋntʋ tɩn, cicirǝ kam ma kaasɩ, yɩ ka tiini ka su bu wʋm ka pa o yɩra saɩ pɔgɩ pɔgɩ, yɩ ka nuŋi ka daar-o. Ka na yag-o tɩn, o ma bǝri. Nɔɔna zanzan maa tɛ ba wɩ: «O tɩgɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Zezi laan ma ja o jɩŋa o pa o zaŋɩ wɛɛnɩ o zɩgɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zezi na joori o zʋ digǝ tɩn, o karabiǝ bam ma vu o te ba yɩranɩ, yɩ ba bwe-o ba wɩ: «Bɛŋwaanɩ mʋ dɩbam wʋ wanɩ dɩ́ zǝli cicirǝ kam?» ");
INSERT INTO xsm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O ma lǝri-ba o wɩ: «Cicirǝ kantʋ doŋ zǝlim cana. Cicirǝ kantʋ dwi warɩ ka zǝli kʋ na daɩ dɩ Wɛ-loro dam.» ");
INSERT INTO xsm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ba dɛɛn ma nuŋi jǝgǝ kam kʋntʋ nɩ ba vu ba tɔgɩ Galile wʋ ba kɛ. Zezi maa ba lagɩ sɩ nɔɔn-nɔɔnʋ lwarɩ ba je, ");
INSERT INTO xsm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","o na jɩgɩ o karabiǝ bam o brɩ tɩn ŋwaanɩ. O maa brɩ-ba o wɩ: «Baá ja amʋ Nabiin-bu wʋm ba kɩ nɔɔna jɩŋa nɩ yɩ ba gʋ-nɩ. Ba nan na gʋ-nɩ, da yatɔ dɛ nɩ a laan wʋ́ joori a bi a yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","O karabiǝ bam ma wʋ ni o taanɩ dɩm kuri, yɩ ba kwarɩ sɩ ba bwe-o ba nii. ");
INSERT INTO xsm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ba ma vu ba yi Kapɛrnawum. Ba ma zʋ sɔŋɔ. Zezi ma bwe o karabiǝ bam o wɩ: «Dɩ́ na wʋ cwǝŋǝ nɩ dɩ́ maa bɩɩnɩ tɩn, á ya magɩ kantɔgɔ bɛɛ ŋwaanɩ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba maa cɩm. Bɛŋwaanɩ, ba ya na maa bɩɩnɩ tɩn, ba ya magɩ kantɔgɔ daanɩ sɩ ba nii, bantʋ wʋnɩ wɔɔ mʋ yɩ kamunu o dwe ba maama. ");
INSERT INTO xsm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zezi ma jǝni tɩga nɩ. O ma bǝŋi o karabiǝ fugǝ-bale bam sɩ ba ba o te. O ma ta dɩ ba o wɩ: «Wʋlʋ na lagɩ sɩ o taa yɩ yigǝ tu tɩn, kʋntʋ tu maŋɩ sɩ o ji ba maama kwaga tu mʋ, sɩ o taa tʋŋɩ o pa ba maama.» ");
INSERT INTO xsm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","O ma ja bu balaŋa o pa o zɩgɩ ba maama tɩtarɩ nɩ. O ma kwe-o o kɩ o ja-kukoro nɩ, yɩ o ta dɩ ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wʋlʋ maama na nɩgɩ bu balaŋa kantʋ doŋ lanyɩranɩ amʋ yɩrɩ ŋwaanɩ tɩn, kʋntʋ tu nɩgɩ amʋ mʋ. Wʋlʋ maama nan na nɩgɩ amʋ tɩn, kʋ daɩ amʋ yɩranɩ mʋ o nɩga, kʋ yɩ o nɩgɩ Baŋa-Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn dɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zan ma ta dɩ Zezi o wɩ: «Karanyɩna, dɩ́ ya nɛ nɔɔnʋ wʋdoŋ na zǝli ciciri nɔɔna yɩra nɩ dɩ nmʋ yɩrɩ. O nan na daɩ dɩbam kɔgɔ kʋm wʋ nɔɔnʋ tɩn, dɩ́ ma kwaanɩ sɩ dɩ́ cɩ-o, sɩ o daa yɩ taa kɩ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Zezi ma lǝri o wɩ: «Á ya wʋ maŋɩ sɩ á cɩ-o. Nɔɔnʋ wʋlʋ maama na tɔgɩ amʋ yɩrɩ ŋwaanɩ o kɩ wo-kɩnkagɩlɩ tɩn bá wanɩ o pipiri lɩla o ŋɔɔnɩ ta-balɔrɔ o pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Bɛŋwaanɩ wʋlʋ maama na ba culi dɩbam tɩn yɩ dɩbam nɔɔnʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ na kwe na o pa abam sɩ á nyɔ, á na yɩ amʋ Zezi Krisi nɔɔna tɩn ŋwaanɩ, kʋntʋ tu wʋ́ na pɛɛrɩ Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kʋ na yɩ balʋ na kɩ ba wʋ-dɩdʋa dɩ amʋ tɩn, ba na maŋɩ ba muri nɩ bu-balwa te dɩ, nɔɔnʋ wʋlʋ na pɛ ba dɩdʋa yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn, ba na lǝgi kandwɛ kamunu mʋ kʋntʋ tu ba nɩ ba dɩ-o nɩnɩʋ wʋnɩ yɩ o tɩ, kʋʋ́ ta garɩ cam dɩlʋ o na wʋ́ ba o na Wɛ tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nmʋ jɩŋa na lagɩ ka pa n kɩ lwarɩm, kʋ maŋɩ sɩ n go-ka mʋ n yagɩ. N na gɛ n jɩŋa, yɩ n daarɩ n na ŋwɩa Wɛ tee nɩ, kʋntʋ garɩ nmʋ na jɩgɩ n jɩa maama yɩ n vu min-tɩʋ, mɛ na yɩ mini dɩlʋ na bá dwe maŋa dɩ maŋa tɩn.  ");
INSERT INTO xsm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jǝgǝ kam kʋntʋ nɩ, ‹kanzwa wʋ́ ta di ba yɩra, yɩ ya ba fɔgɩ ya tʋa. Mini wʋ́ ta di-ba, yɩ dɩ ba fɔgɩ dɩ dweǝ.› ");
INSERT INTO xsm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nmʋ naga na lagɩ ka pa n kɩ lwarɩm, kʋ maŋɩ sɩ n go-ka mʋ n yagɩ. Nmʋ na yɩ na-dʋa yɩ n na ŋwɩa Wɛ tee nɩ, kʋntʋ garɩ nmʋ na jɩgɩ n nɛ sɩm maama, yɩ ba laan dɩ-m ba yagɩ min-tɩʋ nɩ.  ");
INSERT INTO xsm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jǝgǝ kam kʋntʋ nɩ, ‹kanzwa wʋ́ ta di ba yɩra, yɩ ya ba fɔgɩ ya tʋa. Mini wʋ́ ta di-ba, yɩ dɩ ba fɔgɩ dɩ dweǝ.› ");
INSERT INTO xsm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nmʋ yi nan na lagɩ dɩ pa n kɩ lwarɩm, kʋ maŋɩ sɩ n lɩ-dɩ n dʋlɩ n yagɩ mʋ. N na jɩgɩ yi dɩdʋa yɩ n zʋ Wɛ paarɩ dɩm wʋnɩ, kʋntʋ garɩ nmʋ na jɩgɩ yiǝ yale, yɩ ba laan dɩ-m ba yagɩ min-tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jǝgǝ kam kʋntʋ nɩ, ‹kanzwa wʋ́ ta di ba yɩra, yɩ ya ba fɔgɩ ya tʋa. Mini wʋ́ ta di-ba, yɩ dɩ ba fɔgɩ dɩ dweǝ.› ");
INSERT INTO xsm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nɔɔnʋ maama maŋɩ sɩ Wɛ kwe mini mʋ DƖ ma maŋ-o DƖ nii, sɩ DƖ pa o bɩcarɩ fɔgɩ dɩ kwɛ, nɩ yɛ na kwɛ wʋdiu te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yɛ ywǝnǝ yɩ dɩ waɩ dɩ kwɛ wʋdiu. Yɛ ywǝǝni nan na ti, n daa n bá wanɩ n pa dɩ joori dɩ ja ywǝǝni. Pa-na á wʋrʋ taa ywǝmmǝ da-ŋwaanɩ, sɩ á jǝni dɩ yazurǝ, nɩ yɛ na paɩ wʋdiu ywǝmmǝ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zezi laan ma zaŋɩ o nuŋi je sɩm kʋntʋ nɩ o vu o da Zude tɩ-niǝ yam. O ma vu o bɛ Zʋrdɛn bugǝ kam ni dɩdoŋ dɩm nɩ. Nɔn-kɔgɔ zanzan daa ma ba ba gilim-o. O ma ta brɩ-ba Wɛ cɩga kam, nɩ o na yǝni o kɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farizɩan tiinǝ badaara dɛɛn ma zaŋɩ ba vu o te sɩ ba maŋ-o ba nii. Ba ma bwe-o ba wɩ: «Nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o vɩn o kaanɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Zezi ma lǝri-ba o wɩ: «Moyisi dɛɛn pɛ abam culu kʋm o wɩ bɛɛ?» ");
INSERT INTO xsm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ba ma lǝr-o ba wɩ: «Moyisi pɛ ni, nɩ nɔɔnʋ jɩgɩ cwǝŋǝ sɩ o pʋpʋnɩ tɔnɔ o pa o kaanɩ, sɩ kʋ brɩ nɩ o vɩ-o mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zezi ma lǝri-ba o wɩ: «Moyisi dɛɛn pʋpʋnɩ kʋntʋ o pa abam, á wʋrʋ na dana tɩn ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kʋ daarɩ, pulim nɩ Wɛ na kɩ nabiinǝ tɩn, DƖ kɩ-ba sɩ ba taa yɩ baarʋ dɩ kaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kʋntʋ ŋwaanɩ, nɔɔnʋ na di kaanɩ, o maŋɩ sɩ o pɔɔrɩ o tɩtɩ o nu dɩ o ko tee nɩ, sɩ o daarɩ o pa o dɩ o kaanɩ wʋm jǝni daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kʋntʋ wʋ́ pa ba laan ji nɔɔnʋ dɩdʋa. Ba daa daɩ nɔɔna bale, ba laan yɩ nɔɔnʋ dɩdʋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wɛ na kɩ nɔɔna balʋ daanɩ tɩn, nɔɔn-nɔɔnʋ daa wʋ maŋɩ sɩ o pɔɔrɩ-ba daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Zezi dɩ o karabiǝ bam laan ma joori ba vu sɔŋɔ. Ba na zʋ tɩn, ba ma bwe-o o taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O ma ta dɩ ba o wɩ: «Nɔɔnʋ na vɩn o kaanɩ yɩ o daarɩ o di kaanɩ wʋdoŋ, kʋntʋ tu kǝm dɩm dɩ ka-bwǝŋǝ yɩ bɩdwɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaanɩ dɩ na vɩn o barʋ yɩ o vu o zʋ barʋ wʋdoŋ, o dɩ kǝm dɩm dɩ bwǝŋǝ yɩ bɩdwɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nɔɔna badonnǝ maa jaanɩ biǝ ba tui Zezi te sɩ o daŋɩ o jɩa ba baŋa nɩ. O karabiǝ bam ma zaŋɩ ba bagɩ-ba sɩ ba yɩ taa kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zezi na nɛ ba na kɩ te tɩn, o banɩ ma zaŋɩ yɩ o ta dɩ ba o wɩ: «Yagɩ-na sɩ biǝ bam taa tui amʋ te, sɩ á yɩ zaŋɩ á taá cʋ-ba. Bɛŋwaanɩ balʋ na nyɩ nɩ bu-balwa te tɩn mʋ maŋɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ na wʋ sɛ sɩ Wɛ taa te-o nɩ bu-balaŋa te, o bá na cwǝŋǝ o zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Zezi na tagɩ kʋntʋ tɩn, o laan ma ja ja biǝ bam o kɩ o ja-kukoro nɩ. O ma daŋɩ o jɩa ba baŋa nɩ o warɩ Wɛ o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zezi ma zaŋɩ o maa kɛa. Nɔɔnʋ wʋdoŋ ma duri o vu o yi o te. O ma kuni doonǝ o yigǝ nɩ yɩ o wɩ: «Karanyɩna, n yɩ nɔn-ŋʋm. Nan brɩ-nɩ kʋlʋ a na wʋ́ kɩ, sɩ a wanɩ a na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zezi ma ta dɩd-o o wɩ: «Bɛŋwaanɩ mʋ n bǝŋi-nɩ nɩ nɔn-ŋʋm? Nɔɔn-nɔɔnʋ tǝrǝ o na yɩ nɔn-ŋʋm, kʋ na daɩ Wɛ DƖ yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nmʋ maŋɩ n ye Wɛ cullu tɩm na brɩ kʋlʋ tɩn. Yɩ zaŋɩ n gʋ nɔɔnʋ. Yɩ zaŋɩ n pǝni dɩ n doŋ kaanɩ. Yɩ ŋɔnɩ. Yɩ zaŋɩ n fɔ vwan n pa n doŋ. Yɩ pini n doŋ. Ta n zuli n nu dɩ n ko.» ");
INSERT INTO xsm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nɔɔnʋ wʋm ma ta dɩd-o o wɩ: «Karanyɩna, kʋ na sɩŋɩ a biini nɩ tɩn, a maŋɩ a sɛ cullu tɩntʋ maama.» ");
INSERT INTO xsm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zezi ma nii-o dɩ sono, yɩ o ta dɩd-o o wɩ: «Kʋ nan ta gɛ woŋo dɩdʋa mʋ sɩ n kɩ. Ve sɔŋɔ n kwe woŋo kʋlʋ maama n na jɩgɩ tɩn n yǝgi, sɩ n laan kwe tɩ sǝbu kʋm n ma n wǝli yinigǝ tiinǝ. Kʋntʋ wʋ́ pa n ta n jɩgɩ jɩjɩgɩrʋ zanzan Wɛ-sɔŋɔ nɩ. Nmʋ na kɩ kʋntʋ, sɩ n laan ba n ta n tɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nɔɔnʋ wʋm na ni kʋntʋ tɩn, o wʋ ma cɔgɩ zanzan yɩ o yigǝ nywanɩ, o jɩjɩgɩrʋ tɩm na tiini tɩ daga tɩn ŋwaanɩ. O ma yagɩ Zezi yɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zezi laan ma pipiri o nii o karabiǝ bam seeni, yɩ o ta dɩ ba o wɩ: «Nadunǝ na lagɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ, kʋʋ́ ta tiini kʋ cana kʋ pa-ba.» ");
INSERT INTO xsm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","O karabiǝ bam na ni kʋntʋ tɩn, kʋ ma sʋ-ba. Zezi daa ta ma ta dɩ ba o wɩ: «A biǝ-ba, nɔɔna na lagɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ, kʋʋ́ ta tiini kʋ cana kʋ pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kʋʋ́ ta yɩ mwalɩ sɩ yogondi da gar-lwe bɔɔnɩ dɩ nuŋi kʋ dwe nadum na lagɩ sɩ o zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Zezi na tagɩ kʋntʋ tɩn, kʋ ma tiini kʋ sʋ o karabiǝ bam zanzan, yɩ ba tɛ daanɩ ba wɩ: «Kʋ nan na yɩ kʋntʋ, wɔɔ mʋ wʋ́ wanɩ o na ŋwɩa Wɛ tee nɩ?» ");
INSERT INTO xsm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zezi ma nii-ba yɩ o wɩ: «Nabiinǝ mʋ bá wanɩ ba kɩ, sɩ Wɛ waɩ DƖ kɩa. Bɛŋwaanɩ Wɛ waɩ woŋo maama DƖ kɩa.» ");
INSERT INTO xsm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pɩyɛɛrɩ laan ma ta dɩd-o o wɩ: «Nii. Dɩbam yagɩ dɩ́ woŋo maama mʋ, yɩ dɩ́ daarɩ dɩ́ tɔgɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zezi ma lǝri o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ maama na tagɩ amʋ ŋwaanɩ dɩ Wɛ kwǝr-ywǝŋǝ kam ŋwaanɩ, o yagɩ o sɔŋɔ naa o nu-biǝ naa o nu dɩ o ko naa o biǝ naa o karɩ dɩ tɩn, ");
INSERT INTO xsm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kʋntʋ tu wʋ́ ba o na kʋlʋ maama o na yagɩ tɩn kuni bi mʋ lʋgʋ kʋntʋ baŋa nɩ. Oó na sam dɩ nu-biǝ dɩ niinǝ dɩ biǝ dɩ karɩ, yɩ oó na yaara dɩ o wǝli da. Kʋ daarɩ maŋa kalʋ na wʋ́ ba tɩn, kʋntʋ tu wʋ́ na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Balʋ na maŋɩ ba yɩ yigǝ tiinǝ tɩn zanzan wʋ́ joori ba ji kwaga tiinǝ. Kʋ daarɩ balʋ dɩ na maŋɩ ba yɩ kwaga tiinǝ tɩn zanzan wʋ́ ba ba ji yigǝ tiinǝ Wɛ paarɩ dɩm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zezi dɩ nɔɔna zanzan maa zaŋɩ ba wʋ cwǝŋǝ nɩ ba maa ve Zeruzalɛm. Zezi maa wʋ ba yigǝ nɩ o veǝ. O karabiǝ bam maa yɩ yǝǝu. Nɔɔna balʋ dɩ na tɔgɩ ba kwaga tɩn maa fʋmma. Zezi ma bǝŋi o karabiǝ fugǝ-bale bam daa nɩ, yɩ o ta o brɩ-ba kʋlʋ na lagɩ kʋ kɩ-o Zeruzalɛm nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O maa ta dɩ ba o wɩ: «Taá ye-na, dɩ́ na maa ve Zeruzalɛm tɩn, dáanɩ mʋ ba laan wʋ́ ja amʋ Nabiin-bu wʋm ba kɩ Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam jɩŋa nɩ. Nɔɔna bam kʋntʋ wʋ́ di a taanɩ ba wɩ, kʋ maŋɩ sɩ a tɩ mʋ, yɩ ba daarɩ ba kɩ-nɩ dwi-gɛ tiinǝ bam jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Baá yáalɩ-nɩ ba mwanɩ, yɩ ba daarɩ ba twɩ lileeru ba yagɩ a yɩra nɩ. Baá magɩ-nɩ dɩ balaara, yɩ ba laan daarɩ ba gʋ-nɩ. Da yatɔ dɛ nɩ a nan wʋ́ joori a bi a yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zakɩ dɩ Zan balʋ na yɩ Zebede biǝ tɩn dɛɛn ma vu Zezi te ba ta dɩd-o ba wɩ: «Karanyɩna, popo, kɩ woŋo kʋlʋ dɩ́ na lagɩ tɩn n pa dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zezi ma bwe-ba o wɩ: «Á lagɩ sɩ a kɩ bɛɛ mʋ a pa abam?» ");
INSERT INTO xsm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ba ma lǝr-o ba wɩ: «Nmʋ na tu n ba n di n paarɩ dɩm, sɩ n pa dɩbam dɩdʋa jǝni n jazɩm nɩ sɩ dɩdʋa jǝni n jagwiǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zezi ma ta dɩ ba o wɩ: «Abam tɩtɩ yǝri á na loori kʋlʋ tɩn. Abam wʋ́ wanɩ á tɔgɩ á yaarɩ, nɩ amʋ na lagɩ a ba a na yaara yalʋ tɩn na? Á wʋ́ wanɩ á yaarɩ á tɩ, nɩ a na lagɩ a yaarɩ a tɩ te tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ba ma lǝr-o ba wɩ: «Ɛɛn, dɩ́ wʋ́ wanɩ.» Zezi laan ma ta dɩ ba o wɩ: «Kʋ yɩ cɩga, abam nan wʋ́ sɩɩnɩ á tɔgɩ á yaarɩ amʋ yaara yam doŋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kʋ nan daɩ amʋ mʋ maŋɩ sɩ a kuri wʋlʋ na wʋ́ jǝni a jazɩm nɩ naa a jagwiǝ nɩ tɩn. Kʋ yɩ Baŋa-Wɛ mʋ maŋɩ DƖ tiŋi je sɩm kʋntʋ, sɩ DƖ pa balʋ na wʋ́ jǝni da tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","O karabiǝ fugǝ kam na tu ba lwarɩ ba donnǝ bale bam na loori kʋlʋ Zezi tee nɩ tɩn, ba bana ma tiini ya zaŋɩ dɩ Zakɩ dɩ Zan. ");
INSERT INTO xsm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zezi laan ma bǝŋi ba maama, yɩ o ta dɩ ba o wɩ: «Abam nan maŋɩ á ye nɩ lʋgʋ baŋa pwa kɩ dam mʋ dɩ ba nɔɔna, yɩ ba dɩdɛɛra di dam ba baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kʋ nan na yɩ abam, kʋ wʋ maŋɩ sɩ kʋ taa yɩ kʋntʋ doŋ abam tɩtarɩ nɩ. Bɛŋwaanɩ, abam wʋlʋ na lagɩ sɩ o ji nɔn-kamunu á wʋnɩ tɩn, kʋntʋ tu maŋɩ sɩ o ji abam maama tɩntʋŋnʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Wʋlʋ na lagɩ sɩ o ji abam yigǝ tu tɩn, kʋntʋ tu maŋɩ sɩ o ji abam maama gambaa. ");
INSERT INTO xsm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bɛŋwaanɩ amʋ Nabiin-bu wʋm wʋ tu sɩ nɔɔna tʋŋɩ ba pa-nɩ. Amʋ nan tu sɩ a tʋŋɩ a pa nɔɔna mʋ, sɩ a daarɩ a kwe a ŋwɩa a ma lǝni nɔɔna zanzan ŋwɩa Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zezi dɩ o karabiǝ bam ma vu ba yi tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Zeriko. Ba ma tɔgɩ da ba nuŋi ba maa kɛa. Ba na maa kɛ tɩn, nɔn-kɔgɔ maa tɔgɩ-ba. Nɔɔnʋ wʋdoŋ maa wʋra o na yɩ lilwe. O yɩrɩ mʋ Batime, o ko mʋ yɩ Time. O maa je cwǝŋǝ kam ni nɩ yɩ o loorǝ. ");
INSERT INTO xsm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","O ma lwarɩ nɩ kʋ yɩ Nazarɛtɩ tu Zezi mʋ tɔgɩ dáanɩ o maa kɛa. O laan ma puli o kaasɩ baŋa baŋa o wɩ: «Zezi, Pɛ Davidi dwi tu, duri a yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nɔɔna zanzan ma bag-o sɩ o pu o ni. O laan ma tiini o kaasɩ zanzan yɩ o wɩ: «Pɛ Davidi dwi tu, duri a yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Zezi laan ma zɩgɩ yɩ o ta o wɩ, ba bǝŋ-o sɩ o ba. Ba ma bǝŋ-o, yɩ ba ta dɩd-o ba wɩ: «Kɩ wʋpolo, sɩ n zaŋɩ wɛɛnɩ, sɩ o bǝ-m o wɩ n ba.» ");
INSERT INTO xsm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lilwe wʋm ma da pɩɩsɩ o gɔrɔ o yagɩ, yɩ o zaŋɩ lɩla o vu o yi Zezi te. ");
INSERT INTO xsm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Zezi ma bwe-o o wɩ: «Nmʋ lagɩ sɩ a kɩ bɛɛ mʋ a pa-m?» O ma lǝri o wɩ: «Karanyɩna, a lagɩ sɩ a joori a taa naɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zezi ma ta dɩd-o o wɩ: «Nan ve, nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ te tɩn mʋ pɛ n na yazurǝ.» Zezi na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ lilwe wʋm yiǝ joori ya naɩ. O maa tɔgɩ Zezi kwaga cwǝŋǝ kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zezi dɩ o karabiǝ bam dɛɛn ma vu ba twɛ Zeruzalɛm. Ba ma vu ba yi tɩ-balwa bale, ba yɩrɩ mʋ Betifaazɩ dɩ Betani. Je sɩm kʋntʋ wʋ Olivi piu kʋm saŋa nɩ mʋ. Zezi ma lɩ o karabiǝ bam bale o tʋŋɩ, ");
INSERT INTO xsm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yɩ o ta dɩ ba o wɩ: «Ve-na á vu á zʋ tɩʋ kʋlʋ na wʋ abam yigǝ nɩ tɩn. Á na zʋ tɩʋ kʋm wʋnɩ, á wʋ́ na bɩna-pɔla na lǝgi da, yɩ nɔɔn-nɔɔnʋ daa ta wʋ diini ka baŋa. Ve-na á bwǝli-ka á ja ba á pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɔɔnʋ na bwe abam nɩ: ‹Bɛɛ mʋ yɩ á bwǝli-ka?›, sɩ á ta dɩd-o nɩ: ‹Kʋ yɩ dɩ́ Yuutu wʋm mʋ laga. Oó joori o pa ka ba lele.› » ");
INSERT INTO xsm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ba ma zaŋɩ ba vu sɩ ba nii. Ba na yi tɩʋ kʋm wʋ tɩn, ba ma sɩɩnɩ ba na bɩna-pɔla cwǝŋǝ ni nɩ. Ka lǝgi sɔŋɔ kʋdoŋ ni nɩ. Ba ma vu ba bwǝli-ka. ");
INSERT INTO xsm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nɔɔna badonnǝ maa zɩgɩ da. Ba ma bwe Zezi karabiǝ bam ba wɩ: «Bɛɛ mʋ yɩ á lagɩ á bwǝli bɩna-pɔla kam?» ");
INSERT INTO xsm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ba ma lǝri-ba nɩ Zezi na maŋɩ o ta te tɩn. Nɔɔna bam ma sɛ. ");
INSERT INTO xsm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ba ma ja bɩna-pɔla kam ba ja vu ba yi Zezi te. Ba laan ma kwe ba gwaarʋ ba daŋɩ ka baŋa nɩ. Zezi ma di ka baŋa, yɩ ba ve ba maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ba na maa kɛ tɩn, nɔɔna zanzan ma zul-o ba kwe ba gwaarʋ ba lwarɩ cwǝŋǝ kam yuu nɩ, sɩ Zezi ba o tɔgɩ tɩ baŋa o kɛ. Nɔɔna badaara ma vu ba go tweeru nɛ dɩ vɔɔrʋ ba dɩ cwǝŋǝ yuu nɩ, sɩ o tɔgɩ tɩ baŋa o kɛ. ");
INSERT INTO xsm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nɔɔna balʋ na wʋ o yigǝ nɩ dɩ o kwaga nɩ ba ve tɩn maa tɔɔlɩ ba wɩ: «Ozaana! Zulǝ taa wʋ Wɛ tee nɩ! Zuli-na wʋlʋ na tu dɩ́ Yuutu Wɛ yɩrɩ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Zuli-na wʋlʋ na wʋ́ ta te o nɔɔna, nɩnɛɛnɩ dɩbam ko Davidi dɛɛn na jɩgɩ paarɩ te tɩn. Ozaana! Zulǝ taa wʋ Baŋa-Wɛ tee nɩ!» ");
INSERT INTO xsm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zezi ma vu o zʋ Zeruzalɛm tɩʋ kʋm wʋ. O ma vu o yi Wɛ-di-kamunu kʋm o zʋ kʋ wʋ. O ma kaagɩ o nii wǝǝnu tɩm maama na yɩ te. Wɛ na lagɩ dɩ zʋ tɩn, o ma joori o nuŋi tɩʋ kʋm wʋnɩ, o tɔgɩ dɩ o karabiǝ fugǝ-bale bam o vu Betani. ");
INSERT INTO xsm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tɩga na pʋʋrɩ tɩn, ba ma zaŋɩ Betani nɩ sɩ ba joori Zeruzalɛm. Kana maa jɩgɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ba na maa ve tɩn, o ma tʋlɩ o na kapʋrʋ. Kʋ dɛɛn li dɩ vɔɔrʋ mʋ. O ma vu sɩ o nii mɔɔla wʋra na sɩ o di. O na yi da tɩn, o ma wʋ nɛ kʋlʋkʋlʋ, kʋ na wʋ yi kʋ lǝrim maŋa tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O laan ma ta dɩ kapʋrʋ kʋm o wɩ: «Nɔɔn-nɔɔnʋ daa bá na mɔɔla nmʋ yuu nɩ o di.» O karabiǝ bam ma ni o na tagɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ba ma vu ba yi Zeruzalɛm. Zezi ma vu o zʋ Wɛ-di-kamunu kʋm wʋ. O ma na nɔɔna na wʋ ka kʋnkɔlɔ kʋm nɩ ba pipiǝ. O ma zǝli-ba o pa ba nuŋi. O ma vu o ja sǝbu-lǝnnǝ bam taabʋllʋ tɩm o pipiri o pu tɩga nɩ, o pa ba sǝbiǝ bam jagɩ. O ma daarɩ o yigi yitunnu tɩlʋ nɔɔna badonnǝ na je da ba yǝgi kunkwǝn-pulǝ tɩn o dɩ tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O ma wʋ sɛ sɩ nɔɔna taa zɩŋɩ ba zɩla ba tɔgɩ kʋnkɔlɔ kʋm wʋ ba kɛa. ");
INSERT INTO xsm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O ma brɩ nɔɔna bam o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ nɩ, Wɛ mʋ wɩ: ‹Amʋ digǝ kantʋ maŋɩ sɩ ka taa yɩ jǝgǝ kalʋ lʋgʋ baŋa dwi tiinǝ maama na wʋ́ ta tui ba warɩ amʋ da tɩn mʋ.› Abam nan pɛ ka ji ŋwɩɩna joro jǝgǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam ma ni Zezi na tagɩ kʋlʋ tɩn. Ba laan ma beeri cwǝŋǝ sɩ ba gʋ-o. Ba ma kwarɩ fʋʋnɩ dɩd-o, o zaasɩm dɩm na sʋ nɔn-kɔgɔ kʋm maama tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tɩga na lagɩ ka yi tɩn, Zezi dɩ o karabiǝ bam ma nuŋi tɩʋ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tɩga na pʋʋrɩ tɩn, ba ma daa zaŋɩ ba maa kɛa. Ba ma na kapʋrʋ kʋm na kʋga, dɩ kʋ bʋnnʋ maama. ");
INSERT INTO xsm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pɩyɛɛrɩ ma guli Zezi ya na tagɩ te tɩn. O ma ta dɩ Zezi o wɩ: «Karanyɩna, nii kapʋrʋ kʋm nmʋ diin na sɔɔlɩ tɩn, kʋ kʋga.» ");
INSERT INTO xsm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Zezi ma ta dɩ ba o wɩ: «Fɔgɩ-na á kɩ á wʋ-dɩdʋa dɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam wʋlʋ na tagɩ dɩ piu kamunu kʋntʋ nɩ, kʋ gɔ kʋ na zɩgɩ mɛ tɩn kʋ vu kʋ tʋ nɩnɩʋ kʋm wʋnɩ, Wɛ wʋ́ pa kʋ kɩ. Nmʋ na jɩgɩ wʋ-dɩdʋa nɩ nmʋ na tagɩ kʋlʋ tɩn wʋ́ sɩɩnɩ kʋ kɩ, yɩ n ba jɩgɩ bʋbwɛa, Wɛ wʋ́ pa kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kʋntʋ ŋwaanɩ a lagɩ a ta dɩ abam nɩ, woŋo kʋlʋ maama á na wʋ́ loori Wɛ tee nɩ tɩn, sɩ á taá jɩgɩ wʋ-dɩdʋa nɩ á wʋ́ sɩɩnɩ á na-kʋ, yɩ Wɛ wʋ́ pa á na-kʋ. ");
INSERT INTO xsm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Maŋa maama abam na wʋra á warɩ Wɛ, yɩ taanɩ na wʋ abam dɩ nɔɔnʋ wʋdoŋ laŋa nɩ, sɩ á yagɩ á ma cɛ-o. Á Ko Wɛ laan wʋ́ yagɩ abam dɩ lwarɩm DƖ ma cɛ abam.  ");
INSERT INTO xsm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kʋ daarɩ, abam na wʋ sɛ sɩ á yagɩ nɔɔna lwarɩm á ma cɛ-ba, á Ko Wɛ bá yagɩ abam dɩ lwarɩm DƖ ma cɛ abam.» ");
INSERT INTO xsm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ba daa ma vu ba yi Zeruzalɛm. Zezi ma vu o zʋ Wɛ-di-kamunu kʋm wʋ, o karɩ ka wʋnɩ o beerǝ. Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam dɩ ba nakwa bam ma vu o te, ");
INSERT INTO xsm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ba bwe-o ba wɩ: «Wɔɔ dam mʋ n ma n kɩ wǝǝnu tɩlʋ maama n na kɩ tɩn? Wɔɔ mʋ pɛ nmʋ ni sɩ n ta n kɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","O ma lǝri-ba o wɩ: «A dɩ jɩgɩ bwiǝ a lagɩ a bwe abam, sɩ á na lǝri-ya á pa-nɩ, sɩ a laan brɩ abam wʋlʋ na pɛ amʋ ni sɩ a tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A lagɩ a bwe abam a nii, Zan na miisi nɔɔna na wʋnɩ tɩn, kʋ yɩ Wɛ mʋ pɛ-o cwǝŋǝ naa nabiinǝ mʋ pɛ-o?» ");
INSERT INTO xsm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","O na bwe-ba kʋntʋ tɩn, ba maa wʋra ba bwɛ daanɩ sɩ ba nii ba na wʋ́ lǝri te tɩn. Ba maa wɩ: «Dɩbam na lǝri dɩ́ wɩ, kʋ yɩ Wɛ mʋ, o laan wʋ́ bwe dɩbam nɩ, bɛɛ mʋ yɩ dɩ́ nan wʋ sɛ Zan taanɩ dɩm? ");
INSERT INTO xsm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kʋ daarɩ, dɩ́ bá wanɩ dɩ́ ta nɩ kʋ yɩ nabiinǝ mʋ pɛ-o cwǝŋǝ.» Ba tagɩ kʋntʋ, bɛŋwaanɩ ba kwarɩ fʋʋnɩ dɩ nɔɔna bam, dɩ ba maama na sɛ nɩ Zan sɩɩnɩ o yɩ Wɛ nijoŋnu tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kʋntʋ ŋwaanɩ mʋ ba lǝri Zezi ba wɩ: «Dɩ́ yǝri wʋlʋ na pɛ Zan cwǝŋǝ tɩn.» Zezi dɩ ma ta dɩ ba o wɩ: «Kʋ na yɩ kʋntʋ, amʋ dɩ nan bá ta wʋlʋ na pɛ amʋ ni sɩ a taa tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zezi ma maŋɩ mɩmaŋa o brɩ nɔɔna bam o wɩ: «Nɔɔnʋ wʋdoŋ mʋ wʋra. O ma zaŋɩ o cɩ gaarɩ, yɩ o daarɩ o jǝri tweeru tɩlʋ yɩrɩ na yɩ vinyǝ tɩn dɩ wʋnɩ. O ma daarɩ o kʋ goŋo tɩ-dɩa je nɩ, sɩ o na gwǝri tweeru biǝ bam, sɩ o kɩ dáanɩ o nɔ o kan tɩ na bam. O ma daarɩ o cwi dapala sɩ nɔɔnʋ taa je da o yɩrɩ gaarɩ dɩm. O na fɔgɩ o cɩ-dɩ kʋntʋ tɩn, o laan ma kwe nɔɔna o yagɩ da sɩ ba taa tʋŋa, yɩ o daarɩ o nuŋi o vu cwǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tweeru biǝ bam gwǝrim maŋa na yi tɩn, o ma tʋŋɩ o tɩntʋŋnʋ sɩ o vu nɔɔna balʋ na nii o gaarɩ dɩm baŋa nɩ tɩn te, sɩ ba cɛ o tǝri ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tɩntʋŋnʋ wʋm na yi ba te tɩn, ba ma ja-o ba magɩ, yɩ ba daarɩ ba pa o viiri dɩ jɩ-kʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nɔɔnʋ wʋm daa ma tʋŋɩ o tɩntʋŋnʋ wʋdoŋ. O na yi ba te tɩn, ba ma magɩ o yuu ba kaarɩ yɩ ba twɩ-o. ");
INSERT INTO xsm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","O daa ta ma tʋŋɩ o tɩntʋŋnʋ wʋdoŋ o wǝli da. Wʋntʋ na yi ba te tɩn, ba ma mag-o ba gʋ. Nɔɔnʋ wʋm ta ma tʋŋɩ o tɩntʋŋna zanzan nɔɔna bam tee nɩ, yɩ ba magɩ ba badonnǝ, ba daarɩ ba gʋ ba badaara. ");
INSERT INTO xsm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kʋ laan ma daarɩ o tɩtɩ bu wʋlʋ o na so-o zanzan tɩn yɩranɩ. O ma tʋŋ-o ba tee nɩ o ma kweeli, yɩ o bʋŋɩ sɩ, baá nɩgɩ wʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nɔɔna bam na nɛ-o tɩn, ba maa ŋɔɔnɩ daanɩ ba wɩ: ‹Mʋ gaarɩ dɩm tu bu, wʋntʋ mʋ lagɩ o ba o taa te o ko wʋm wǝǝnu tɩm. Nan pa-na dɩ́ gʋ-o, sɩ dɩ́ daarɩ dɩ́ taá te o wǝǝnu tɩm.› ");
INSERT INTO xsm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ba laan ma gʋ-o, yɩ ba daarɩ ba vaŋ-o ba ja nuŋi gaarɩ dɩm wʋnɩ ba yagɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kʋntʋ tɩn, gaarɩ dɩm tu wʋm laan wʋ́ kɩ nɔɔna bam kʋntʋ tɩta mʋ? O maŋɩ sɩ o ba o gʋ-ba mʋ, sɩ o daarɩ gaarɩ dɩm o pa nɔɔna badonnǝ sɩ ba taa niǝ. ");
INSERT INTO xsm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kandwɛ dɩlʋ lwara na vɩn tɩn laan mʋ joori dɩ ba dɩ ji kandwɛ dɩlʋ na paɩ sɔŋɔ kʋm dana tɩn. Baŋa-Wɛ na kɩ te tɩn mʋ kʋntʋ, yɩ kʋ yɩ wo-kamunu kʋ pa dɩbam.› Abam maŋɩ á wʋ karɩmɩ kʋntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zwifǝ yigǝ tiinǝ bam na ni kʋntʋ tɩn, ba ma lwarɩ nɩ o maŋɩ mɩmaŋɩ dɩm bantʋ ŋwaanɩ mʋ. Ba laan maa beeri cwǝŋǝ sɩ ba ja-o. Ba maa warɩ, ba na kwarɩ fʋʋnɩ dɩ nɔn-kɔgɔ kʋm tɩn ŋwaanɩ. Ba ma yag-o, yɩ ba daarɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Zwifǝ bam dɛɛn ma lɩ Farizɩan tiinǝ badonnǝ dɩ Pɛ Erɔdɩ kwaga nɔɔna badonnǝ sɩ ba vu Zezi te. Ba maa lagɩ sɩ ba pa o ŋɔɔnɩ o tusi, sɩ ba wanɩ ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba ma yi o te, yɩ ba ta dɩd-o ba wɩ: «Karanyɩna, dɩ́ ye nɩ nmʋ yɩ cɩga tu mʋ. Nmʋ yigǝ tǝrǝ dɩ nɔɔna na bʋŋɩ kʋlʋ ba pa nmʋ tɩn, nmʋ nan ba kuri nɔɔna daanɩ. Nmʋ nan yǝni n brɩ nɔɔna Wɛ cwǝŋǝ dɩ cɩga mʋ. Dɩ́ lagɩ dɩ́ bwe dɩ́ nii, dɩbam Zwifǝ bam culu pɛ ni sɩ dɩ́ ŋwɩ lampoo dɩ́ pa lʋgʋ kʋm pa-farʋ wʋm naa kʋ wʋ maŋɩ? Dɩ́ maŋɩ sɩ dɩ́ ŋwɩ naa dɩ́ wʋ maŋɩ sɩ dɩ́ ŋwɩ?» ");
INSERT INTO xsm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Zezi nan maŋɩ o ye ba na yɩ pipiri-nyɩna te tɩn. O ma ta dɩ ba o wɩ: «Bɛɛ nan mʋ yɩ á lagɩ sɩ á maŋɩ-nɩ á nii? Ja-na sǝbu-dalɩ dɩdʋa á ba sɩ a nii.» ");
INSERT INTO xsm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ba ma lɩ sǝbu-dalɩ dɩm ba brɩ-o. O ma nii yɩ o bwe-ba o wɩ: «Wɔɔ nyɩnyʋgʋ dɩ o yɩrɩ mʋ pʋpʋnɩ dɩ baŋa nɩ?» Ba ma lǝr-o ba wɩ: «Kʋ yɩ pa-farʋ wʋm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zezi laan ma ta dɩ ba o wɩ: «Kʋ lamma. Á nan taá ŋwɩ kʋlʋ na yɩ pa-farʋ wʋm nyɩm tɩn á pa-o, sɩ á daarɩ á taá paɩ Wɛ kʋlʋ dɩ na yɩ DƖ nyɩm tɩn.» O na lǝri-ba kʋntʋ tɩn, kʋ ma sʋ-ba zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusɩan tiinǝ badonnǝ dɛɛn ma zaŋɩ ba vu Zezi te. Bantʋ mʋ brɩ ba wɩ, nɔɔnʋ na tɩga, o daa bá joori o bi. ");
INSERT INTO xsm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ba ma vu ba ta dɩ Zezi ba wɩ: «Karanyɩna, Moyisi dɛɛn na pʋpʋnɩ kʋlʋ o tiŋi o pa dɩbam tɩn, kʋ brɩ nɩ, nɔɔnʋ nu-bu na tɩga yɩ o daarɩ o kaanɩ, ba na wʋ lʋgɩ biǝ daanɩ, tʋ wʋm cʋrʋ mʋ maŋɩ sɩ o di kaanɩ wʋm sɩ ba wanɩ ba lʋ biǝ o nu-bu wʋlʋ na tɩgɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kʋntʋ, nu-biǝ barpɛ ya mʋ wʋra. Ba dɩdʋa ma di kaanɩ, yɩ o tɩ o daar-o, yɩ o wʋ lʋgɩ bu. ");
INSERT INTO xsm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wʋlʋ na saŋɩ tɩn laan ma di kadǝm wʋm. O dɩ ma tɩ o daarɩ kaanɩ wʋm, yɩ ba dɩ wʋ lʋgɩ bu. Batɔ tu wʋm dɩ daa ma di-o. ");
INSERT INTO xsm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ba maama barpɛ di kaanɩ wʋm, yɩ ba wʋ lʋgɩ bu dɩd-o. Ba maama na tɩgɩ tɩn, kaanɩ wʋm dɩ laan ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ba maama barpɛ na di kaanɩ wʋm tɩn, ba laan na tu ba bi ba yagɩ tʋʋnɩ, bantʋ wɔɔ mʋ wʋ́ ta te kaanɩ wʋm?» ");
INSERT INTO xsm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zezi ma lǝri-ba o wɩ: «Abam tiini á tusi mʋ. Abam wʋ lwarɩ Wɛ tɔnɔ kʋm zaasɩm dɩm kuri, yɩ á ta yǝri Wɛ dam dɩm na yɩ te tɩn. Á wʋ tusi cɩga na? ");
INSERT INTO xsm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nɔɔna na tu ba bi ba yagɩ tʋʋnɩ, ba lagɩ ba taa nyɩ dɩ Wɛ malɛsɩ sɩm na yɩ te tɩn mʋ, ba ba di kaana, kaana dɩ nan ba zʋʋrɩ banna dɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kʋ nan na yɩ twa biim dɩm dɩ, Moyisi na pʋpʋnɩ kʋlʋ tɩn brɩ nɩ nɔɔna wʋ́ sɩɩnɩ ba bi. Abam maŋɩ á wʋ karɩmɩ kʋlʋ Wɛ na tagɩ dɩ Moyisi DƖ na brɩ DƖ tɩtɩ dɩd-o sabarɩ puŋu kʋm wʋnɩ maŋa kalʋ tɩn na? Wɛ dɛɛn tagɩ DƖ wɩ: ‹Amʋ yɩ Abraham Wɛ, dɩ Yizakɩ Wɛ, dɩ Zakɔbɩ Wɛ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kʋ brɩ nɩ bantʋ daa ta jɩgɩ ŋwɩa mʋ Wɛ tee nɩ, bɛŋwaanɩ Baŋa-Wɛ yɩ naŋʋna Wɛ mʋ, sɩ DƖ daɩ twa Wɛ. Mʋ kʋ kuri á tiini á tusi dɩ á na bʋŋɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ba na wʋra ba ŋɔɔnɩ kʋntʋ tɩn, Wɛ cullu karanyɩna tu wʋdoŋ ma yi ba te, yɩ o ni ba taanɩ dɩm. O ma lwarɩ nɩ Zezi tiini o kwaanɩ dɩ o na lǝri Sadusɩan tiinǝ bam te tɩn. O laan ma twɛ Zezi te, yɩ o bwe o wɩ: «Wɛ niǝ yam maama wʋnɩ dɔɔ mʋ yɩ kamunu dɩ dwe?» ");
INSERT INTO xsm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zezi ma lǝr-o o wɩ: «Wɛ ni dɩlʋ na yɩ kamunu dɩ dwe ya maama tɩn mʋ tɩntʋ: ‹Yisɩrayɛlɩ tiinǝ-ba, cǝgi-na. Yuutu Baŋa-Wɛ mʋ yɩ dɩbam Yuutu dɩdʋa má. ");
INSERT INTO xsm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ta n soe n Yuutu Baŋa-Wɛ dɩ n bɩcarɩ maama, dɩ n wʋ maama, dɩ n wʋbʋŋa maama, dɩ n dam maama.› ");
INSERT INTO xsm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wɛ ni dɩlʋ na saŋɩ tɩn mʋ tɩntʋ: ‹Ta n soe n doŋ nɩ n tɩtɩ te.› Wɛ ni dɩdoŋ daa tǝrǝ dɩ na yɩ kamunu dɩ dwe niǝ yantʋ yale.» ");
INSERT INTO xsm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wɛ cullu karanyɩna tu wʋm ma ta dɩ Zezi o wɩ: «Karanyɩna, n tagɩ cɩga. Nmʋ na tagɩ n wɩ, Wɛ dɩdʋa yɩranɩ mʋ wʋra yɩ DƖ doŋ daa tǝrǝ tɩn, kʋ yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kʋ maŋɩ sɩ dɩ́ taá soe Wɛ dɩ dɩ́ wʋ maama, dɩ dɩ́ wʋbʋŋa maama, dɩ dɩ́ dam maama, sɩ dɩ́ daarɩ dɩ́ taá soe dɩ́ donnǝ nɩ dɩ́ tɩtɩ te. Dɩ́ na kɩ kʋntʋ, dɩ́ kɩ lanyɩranɩ kʋ dwe dɩ́ na mɛ vara naa woŋo kʋlʋ maama dɩ́ ma kaanɩ-DƖ.» ");
INSERT INTO xsm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zezi na nɛ nɩ o lǝri taanɩ dɩm lanyɩranɩ dɩ wʋbʋŋ-ŋʋna tɩn, o ma ta dɩd-o o wɩ: «Nmʋ batwarɩ dɩ Wɛ paarɩ dɩm.» Kʋ na zɩgɩ maŋa kam kʋntʋ nɩ, nɔɔn-nɔɔnʋ daa maa kwarɩ sɩ o bwe-o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zezi dɛɛn maa wʋ Wɛ-di-kamunu kʋm nɩ o brɩ nɔɔna, yɩ o ta o wɩ: «Wɛ cullu karanyɩna tiinǝ bam yǝni ba brɩ nɩ, Krisi wʋm Wɛ na tʋŋɩ tɩn yɩ Pɛ Davidi dwi tu mʋ. Kʋ nan wʋ́ wanɩ kʋ taa yɩ kʋntʋ na? ");
INSERT INTO xsm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wɛ Joro kʋm dɛɛn pɛ Davidi tɩtɩ ta o wɩ: ‹Yuutu Baŋa-Wɛ tagɩ dɩ a Yuutu DƖ wɩ: Ba n jǝni amʋ jazɩm nɩ, sɩ a laan kɩ nmʋ dʋna maama n nɛ kuri nɩ.› ");
INSERT INTO xsm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davidi tɩtɩ nan na sɩɩnɩ o bǝŋi Krisi wʋm o wɩ o Yuutu tɩn, dɩbam nan daa wʋ́ kɩ ta mʋ dɩ́ bǝŋ-o nɩ Davidi naa daga?» Zezi na brɩ Wɛ cɩga kam kʋntʋ tɩn, kʋ ma pa nɔn-kɔgɔ kʋlʋ na je kʋ cǝgi tɩn wʋ poli zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","O daa ta ma brɩ-ba yɩ o wɩ: «Taá yɩrɩ-na á tɩtɩ dɩ cullu karanyɩna tiinǝ bam. Bantʋ soe sɩ ba taa zʋʋrɩ gwar-dɩdwaarʋ, sɩ ba taa beerǝ yɩ nɔɔna nii-ba. Ba na ve yaga, ba lagɩ sɩ nɔɔna maama taa tui ba zuli-ba mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ba na yǝni ba zʋ ba Wɛ-di sɩm, ba lagɩ je-kamunnu mʋ sɩ ba taa je yigǝ nɩ. Ba na ve nɔɔnʋ sɔŋɔ sɩ ba di candiǝ, kʋ yɩ je-ŋʋŋa jǝgǝ nɩ mʋ ba lagɩ sɩ ba taa je da. ");
INSERT INTO xsm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ba maa yǝni ba ganɩ kadǝnǝ ba joŋi kʋlʋ maama ba na jɩgɩ tɩn, yɩ ba kwǝri ba loori Wɛ dɩ bɩtar-dɩdwaarʋ, sɩ kʋ taa nyɩ nɩ ba yɩ nɔn-ŋʋna mʋ te. Wɛ wʋ́ tiini DƖ pa bantʋ na cam kʋ ja gaalɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zezi ma vu o jǝni Wɛ-di-kamunu kʋm wʋnɩ, jǝgǝ kalʋ daka na zɩgɩ da yɩ nɔɔna dɩ Wɛ pɛɛra ka wʋnɩ tɩn tɩkǝri nɩ. O maa je o nii nɔɔna bam na ve ba dɩ ba sǝbiǝ ka wʋnɩ te tɩn. Nadunǝ zanzan ma ba ba dɩ sǝbu zanzan ka wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kadǝm wʋdoŋ na yɩ yinigǝ tu tɩn ma ja sǝbu-dal-balwa bale, o ja vu o dɩ da. ");
INSERT INTO xsm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zezi na nɛ kʋntʋ tɩn, o ma bǝŋi o karabiǝ bam, yɩ o ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, kadǝm wʋntʋ na yɩ yinigǝ tu tɩn, o dɩ sǝbu kʋ dwǝni nɔɔna balʋ maama na dɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bantʋ maama lɩ ba daarɩ sǝbiǝ mʋ tata. Kadǝm wʋm nan yɩ yinigǝ tu mʋ, yɩ o kwe woŋo kʋlʋ maama o na jɩgɩ sɩ o ma yǝgi o ni-wʋdiu tɩn o dɩ da.» ");
INSERT INTO xsm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zezi laan ma zaŋɩ o nuŋi Wɛ-di-kamunu kʋm wʋnɩ. O na maa kɛ tɩn, o karabiǝ bam dɩdʋa ma ta dɩd-o o wɩ: «Karanyɩna, nii kandwa yantʋ ba na mɛ ba lɔ digǝ kam tɩn na lana te. Nii ka lɔɔm dɩm na dana te.» ");
INSERT INTO xsm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zezi ma lǝr-o o wɩ: «Nmʋ wʋ nɛ ka na daga te tɩn na? Ka maama nan wʋ́ ba ka tʋ tɩga nɩ ka cɔgɩ. Kandwɛ daa bá daŋɩ dɩ doŋ baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zezi dɛɛn ma vu o jǝni Olivi piu kʋm yuu nɩ, yɩ o tʋlɩ o na Wɛ-di-kamunu kʋm o yigǝ nɩ. O na je kʋntʋ tɩn, Pɩyɛɛrɩ dɩ Zakɩ dɩ Zan dɩ Andre yɩranɩ ma vu o te, yɩ ba bwe-o ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Maŋa kɔɔ mʋ Wɛ-digǝ kam wʋ́ ba ka cɔgɩ kʋntʋ? Bɛɛ mʋ lagɩ kʋ kɩ maana kʋ brɩ dɩbam, sɩ dɩ́ lwarɩ nɩ wǝǝnu tɩntʋ maama lagɩ tɩ kɩ?» ");
INSERT INTO xsm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Zezi ma lǝri-ba o wɩ: «Á fɔgɩ á cɩ á tɩtɩ, sɩ á yɩ pa nɔɔn-nɔɔnʋ ganɩ abam. ");
INSERT INTO xsm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bɛŋwaanɩ nɔɔna zanzan wʋ́ ba abam te, yɩ baá ma amʋ yɩrɩ ba ma ganɩ abam ba wɩ, bantʋ dɩdʋa dɩdʋa mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, yɩ baá ganɩ nɔɔna zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Á wʋ́ ba á na tigurǝ na wʋ abam tɩɩnɩ dɩm nɩ, yɩ á kwǝri á ni ka ŋwa tɩɩnɩ dɩlʋ na baŋwɛ tɩn nɩ. Á nan na ni kʋntʋ, sɩ á yɩ pa fʋʋnɩ zʋ abam. Wǝǝnu tɩm kʋntʋ maŋɩ sɩ tɩ kɩ mʋ, yɩ kʋ ta daɩ lʋgʋ tiim maŋa. ");
INSERT INTO xsm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dwi wʋ́ zaŋɩ dɩ kɩ jara dɩ dwi dɩdoŋ, yɩ tɩʋ dɩ kʋ doŋ wʋ́ zaŋɩ tɩ magɩ jara. Tɩga dɩ wʋ́ sisiŋi je sɩdonnǝ nɩ, yɩ kana dɩ wʋ́ ba ka taa wʋ je zanzan nɩ. Yaara yam kʋntʋ maama nan nyɩ dɩ kaanɩ na sɩŋɩ o vri pugǝ yɩ ka wɔɛ yɩ cam daa ta wʋ kwaga nɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Á fɔgɩ á cɩ á tɩtɩ, sɩ nɔɔna wʋ́ ja abam ba vu ba saŋɩ sarɩya-dirǝ nakwa tee nɩ. Ba ta wʋ́ ja abam ba magɩ ba Wɛ-di sɩm wʋnɩ. Baá ja abam ba vu ba saŋɩ dɩdɛɛra dɩ pwa tee nɩ, abam na tɔgɩ amʋ tɩn ŋwaanɩ. Kʋntʋ mʋ wʋ́ pa á wanɩ á brɩ-ba Wɛ cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kʋ nan fɩn mʋ sɩ ba da yigǝ ba tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam ba brɩ dwi maama tiinǝ, sɩ woŋo maama tiim laan yi. ");
INSERT INTO xsm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba na jaanɩ abam ba vu ba saŋɩ, sɩ á yɩ taá liǝ dɩ á na wʋ́ ta kʋlʋ tɩn. Á na wʋ́ taá zɩgɩ ba yigǝ nɩ maŋa kalʋ tɩn, sɩ á laan ŋɔɔnɩ kʋlʋ Wɛ na wʋ́ pa abam tɩn. Kʋ daɩ abam tɩtɩ mʋ wʋ́ ŋɔɔnɩ, kʋ yɩ Wɛ Joro kʋm mʋ wʋ́ pa abam kʋlʋ á na wʋ́ ŋɔɔnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nɔɔna badonnǝ wʋ́ ja ba tɩtɩ cʋrrʋ ba kɩ nɔɔna jɩa nɩ sɩ ba gʋ-ba. Kwǝ dɩ wʋ́ kɩ ba biǝ kʋntʋ doŋ. Biǝ dɩ wʋ́ zaŋɩ ba pa ba ja ba niinǝ dɩ ba kwǝ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nɔɔna maama wʋ́ ta culi abam, á na yɩ a nɔɔna tɩn ŋwaanɩ. Wʋlʋ maama nan na kɩ pu-dɩa o zɩgɩ kǝŋkǝŋ sɩ kʋ vu kʋ yi kweelim tɩn, Wɛ wʋ́ vrɩ kʋntʋ tu ŋwɩa. ");
INSERT INTO xsm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Abam nan wʋ́ ba á na wo-lɔŋɔ kʋlʋ na yɩ cɔgɩnʋ tɩn na wʋ́ ba kʋ zɩgɩ jǝgǝ kalʋ na wʋ maŋɩ sɩ kʋ taa zɩgɩ da tɩn.» (A tɛ abam sɩ wʋlʋ na karɩmɩ tɩn, sɩ o kwaanɩ o ni kʋ kuri lanyɩranɩ.) «Abam na nɛ wo-lɔŋɔ kʋm kʋntʋ, sɩ abam balʋ na zʋʋrɩ Zude nɩ tɩn kɩ lɩla á nuŋi á duri á vu pweeru yum á sǝgi da. ");
INSERT INTO xsm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nɔɔnʋ nan na wʋ nayuu nɩ, o daa yɩ tu o zʋ digǝ sɩ o kwe kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nɔɔnʋ wʋlʋ nan na wʋ kara nɩ tɩn, o daa yɩ joori sɔŋɔ sɩ o kwe o gɔrɔ o zʋ. ");
INSERT INTO xsm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kantʋ maŋa kam nɩ kʋʋ́ ta tiini kʋ yɩ lɛɛrʋ dɩ kaana balʋ na jɩgɩ pwi tɩn, dɩ balʋ na jɩgɩ biǝ yɩ ba ŋɔgɩ yɩlɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nan taá loori-na Wɛ, sɩ cam dɩm kʋntʋ yɩ ba waarʋ mɩmaŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bɛŋwaanɩ yaara yalʋ na lagɩ ya ba da yam kʋntʋ nɩ tɩn wʋ́ ta tiini ya camma ya dwe yalʋ na maŋɩ ya kɩ pulim nɩ Wɛ na kɩ lʋgʋ sɩ kʋ ba kʋ yi zɩm tɩn. Yaara yantʋ nan na kɛ, yadonnǝ daa bá ba nɩnɛɛnɩ yantʋ te. ");
INSERT INTO xsm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Baŋa-Wɛ nan na wʋ pɛ yaara yam da yam tri, nɔɔn-nɔɔnʋ bá wǝri. Kʋ nan yɩ Wɛ tɩtɩ nɔɔna balʋ DƖ na kuri tɩn ŋwaanɩ mʋ, DƖ wʋ́ pa yaara yam da yam tri. ");
INSERT INTO xsm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kantʋ maŋa kam nɩ, nɔɔnʋ wʋlʋ maama na tagɩ dɩ abam o wɩ: ‹Nii Krisi wʋm Wɛ na tʋŋɩ tɩn, o wʋ yo seeni› naa ‹o wʋ jǝgǝ kantʋ nɩ›, sɩ á yɩ sɛ kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nɔɔna badaara wʋ́ zaŋɩ ba brɩ nɩ bantʋ dɩdʋa dɩdʋa mʋ yɩ Krisi wʋm, yɩ ba yagɩ ba daɩ. Badonnǝ dɩ wʋ́ brɩ nɩ bantʋ mʋ yɩ Wɛ nijoŋnǝ, yɩ ba yagɩ ba daɩ. Baá kɩ wo-kɩnkagɩla yalʋ na wʋ́ sʋ nɔɔna tɩn, sɩ ba ya na waɩ, sɩ ba sʋgɩ Wɛ tɩtɩ nɔɔna balʋ DƖ na kuri tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Á taá cʋ á tɩtɩ, sɩ a wuuri a ta a brɩ abam mʋ yɩ wǝǝnu tɩm maŋa daa ta wʋ yi.» ");
INSERT INTO xsm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Yaara yam kʋntʋ maŋa na tu ka kɛ, da yantʋ wʋnɩ ‹wɩa kam laan wʋ́ ji nazono tim tim, cana dɩ daa bá fuŋi sɩ pooni taa wʋra. ");
INSERT INTO xsm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wɛyuu wʋ́ sisiŋi yɩ calɩcwɩ sɩm kwǝri sɩ tʋ tɩga nɩ, yɩ wǝǝnu tɩlʋ maama na wʋ wɛyuu nɩ tɩn wʋ́ vugimi daanɩ.› ");
INSERT INTO xsm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Maŋa kam kʋntʋ nɩ nɔɔna wʋ́ na Nabiin-bu wʋm na maa bɩɩnɩ lʋgʋ baŋa. Oó ta wʋ kunkwǝǝnu wʋnɩ o bɩɩnɩ dɩ dam, yɩ Wɛ paarɩ-zulǝ wʋ o tee nɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O laan wʋ́ pa o malɛsɩ sɩm nuŋi sɩ jagɩ sɩ vu lʋgʋ baŋa je maama, kʋ na yɩ wa-puli dɩ wa-zʋʋrɩ, jazɩm dɩ jagwiǝ, sɩ la o nɔɔna balʋ Wɛ na kuri tɩn je maama sɩ kɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nan maanɩ-na á nii kapʋrʋ na yɩ te tɩn. Kʋntʋ na yǝni kʋ wʋra kʋ kwi vɔɔrʋ, á yǝni á lwarɩ nɩ kʋ twɛ yadɛ. ");
INSERT INTO xsm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kʋ nan yɩ bɩdwɩ mʋ dɩ á na tu á na wǝǝnu tɩlʋ a na tagɩ a brɩ abam tɩn na wʋra tɩ kɩa, sɩ á lwarɩ nɩ maŋa kam laan twɛ ka ti. ");
INSERT INTO xsm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wǝǝnu tɩm kʋntʋ maama wʋ́ ba tɩ wʋra tɩ kɩa, yɩ zɩm nɔɔna bam ta wʋ tɩgɩ ba ti. ");
INSERT INTO xsm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wɛyuu dɩ tɩga baŋa maama wʋ́ ba tɩ kɛ, yɩ amʋ taanɩ dɩm bá kɛ maŋa dɩ maŋa. ");
INSERT INTO xsm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nɔɔn-nɔɔnʋ nan yǝri dɛ dɩlʋ Nabiin-bu wʋm na lagɩ o joori o ba tɩn, yɩ nɔɔn-nɔɔnʋ yǝri dɛ dɩm wʋnɩ maŋa kam o na wʋ́ ba tɩn, kʋ na maŋɩ kʋ yɩ Wɛ malɛsɩ sɩm naa DƖ Bu wʋm tɩtɩ dɩ. Kʋ yɩ a Ko Baŋa-Wɛ yɩranɩ mʋ ye. ");
INSERT INTO xsm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Á taá fɔgɩ á cʋ á tɩtɩ, sɩ á yǝri maŋa kam o na wʋ́ joori o ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kʋʋ́ ta nyɩ dɩ sɔŋɔ tu na nuŋi sɩ o beeri o vu yigǝ yigǝ te tɩn. O ma pa o tɩntʋŋna bam ni sɩ ba taa nii o sɔŋɔ kʋm baŋa nɩ. O ma pa ba nɔɔnʋ maama o tɩtʋŋɩ. O ma ta dɩ ba dɩdʋa, sɩ o taa yɩrɩ o mancoŋo kʋm lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Abam dɩ maŋɩ sɩ á fɔgɩ á taá yɩrɩ kʋntʋ doŋ mʋ. Bɛŋwaanɩ á yǝri maŋa kalʋ sɔŋɔ tu wʋm na wʋ́ joori o ba tɩn. O waɩ o tui dɩdaan-ni nɩ naa tɩtɩɩ kʋnkʋrʋ nɩ, naa tɩ-bra-pʋra nɩ naa wa-puli maŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kʋntʋ tɩn, o na tu bɩdwɩ baŋa nɩ, sɩ o yɩ darɩ abam dɩ á tigi á dɔa. ");
INSERT INTO xsm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","A lagɩ a ta dɩ abam dɩ nɔɔna bam maama nɩ, á maŋɩ sɩ á taá cʋ á tɩtɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kʋ dɛɛn daarɩ da yale mʋ sɩ Pakɩ candiǝ kam yi. Candiǝ kam kʋntʋ nɩ mʋ Zwifǝ bam yǝni ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ tɩn. Zwifǝ bam kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam maa kwaanɩ ba lagɩ cwǝŋǝ, sɩ ba kɩ swan ba ma ja Zezi ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ba ma ta ba wɩ: «Dɩ́ nan wʋ maŋɩ sɩ dɩ́ ja-o candiǝ kam maŋa nɩ, sɩ kʋʋ́ pa vuvugǝ jǝni nɔɔna bam tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zezi dɛɛn maa wʋ Betani nɩ nɔɔnʋ wʋdoŋ sɔŋɔ nɩ, o yɩrɩ mʋ Simɔn. Wʋntʋ dɛɛn ya yɩ nanyɔŋɔ mʋ. Zezi na wʋra o di wʋdiu maŋa kalʋ tɩn, mʋ kaanɩ wʋdoŋ tu o te. O maa jɩgɩ kunkwǝlǝ ka na su dɩ tralɩ nugǝ kalʋ yɩrɩ na yɩ naadɩ tɩn. Nugǝ kam lana yɩ ka yǝlo cana zanzan. O ma puri kunkwǝlǝ kam ni, o lo nugǝ kam Zezi yuu nɩ o ma kɩ-o zulǝ. ");
INSERT INTO xsm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Balʋ na tɔgɩ ba wʋra yɩ ba na tɩn badonnǝ maa ba jɩgɩ wʋpolo, yɩ ba tɛ daanɩ ba wɩ: «Bɛɛ mʋ yɩ o cɔgɩ nugǝ kam kʋntʋ? ");
INSERT INTO xsm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dɩ́ ya waɩ dɩ́ yǝgi-ka dɩ́ na sǝbu zanzan, kʋ dwe sǝbu-dala biǝ yatɔ, yɩ dɩ́ ma wǝli yinigǝ tiinǝ.» Ba ma tiini ba jɩgɩ kaanɩ wʋm ba ŋɔɔna dɩ o kǝm dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zezi ma ta dɩ ba o wɩ: «Á yag-o. Bɛɛ mʋ yɩ á jɩg-o á yaara? O na kɩ amʋ zulǝ yalʋ tɩn yɩ kǝm-laa mʋ o kɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kʋ nan na yɩ yinigǝ tiinǝ, bantʋ wʋra mʋ dɩ abam maŋa maama, yɩ á wʋ́ wanɩ á zǝni-ba maŋa kalʋ á na lagɩ tɩn. Kʋ daarɩ amʋ nan bá ta wʋra dɩ abam maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kaanɩ wʋntʋ kɩ kʋlʋ o na waɩ tɩn mʋ. O na logi nugǝ kam a yɩra nɩ tɩn, kʋ brɩ nɩ o wuuri o turi a yɩra yam mʋ, sɩ ba laan kwe-nɩ ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A lagɩ a ta cɩga mʋ dɩ abam sɩ, ba na wʋ́ tɔɔlɩ amʋ kwǝr-ywǝŋǝ kam lʋgʋ baŋa je sɩm maama nɩ tɩn, baá ta kaanɩ wʋm kʋntʋ dɩ taanɩ sɩ ba taa guli o gulǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zudasɩ Yiskarɩyo wʋlʋ na yɩ Zezi karabiǝ fugǝ-bale bam wʋ dɩdʋa tɩn laan ma zaŋɩ o nuŋi. O ma vu Zwifǝ kaanɩm yigǝ tiinǝ bam te, sɩ o brɩ-ba cwǝŋǝ sɩ ba wanɩ ba ja Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ba na ni o na tagɩ kʋlʋ tɩn, ba wʋ ma poli zanzan. Ba ma go ni nɩ baá pa-o sǝbu. O laan maa kwaanɩ o beeri cwǝŋǝ sɩ o ja Zezi o kɩ ba jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kʋ ma ba kʋ yi dɛ dɩlʋ ba na puli sɩ ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ dɩ wʋnɩ tɩn. Dɛ dɩm kʋntʋ nɩ Zwifǝ bam yǝni ba gʋɩ pibalɩ mʋ, ba ma di Pakɩ candiǝ kam. Zezi karabiǝ bam ma vu ba bwe-o ba wɩ: «Nmʋ lagɩ sɩ dɩ́ di Pakɩ candiǝ kam jǝgǝ kɔɔ nɩ mʋ, sɩ dɩ́ vu dɩ́ ti woŋo maama yigǝ dɩ́ pa-m?» ");
INSERT INTO xsm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","O ma tʋŋɩ o karabiǝ bam bale, yɩ o ta dɩ ba o wɩ: «Zaŋɩ-na á vu tɩʋ kʋm wʋ. Á na yi da, nɔɔnʋ wʋdoŋ wʋ́ jeeri abam o na zɩŋɩ kɔɔrʋ dɩ na. Sɩ á da-na o kwaga á vu. ");
INSERT INTO xsm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","O na zʋ sɔŋɔ kʋlʋ tɩn, sɩ á dɩ zʋ á ta dɩ kʋ tu nɩ: ‹Dɩ́ Karanyɩna mʋ wɩ, dɩ́ ba dɩ́ bwe dɩ́ nii, digǝ kalʋ wʋm na wʋ́ jǝni da dɩ o karabiǝ bam sɩ ba di Pakɩ candiǝ kam wʋdiu tɩn wʋ yǝn mʋ?› ");
INSERT INTO xsm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Á na bwe-o kʋntʋ, o laan wʋ́ brɩ abam wɛyuu digǝ. Kaá ta daga lanyɩranɩ, yɩ ka jɩgɩ woŋo kʋlʋ maama dɩ́ na lagɩ tɩn ka wʋnɩ. Ve-na á kwɛ candiǝ kam wǝǝnu tɩm á ti, sɩ dɩ́ laan ba.» ");
INSERT INTO xsm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","O karabiǝ bale bam ma zaŋɩ ba vu tɩʋ kʋm wʋ. Ba ma sɩɩnɩ ba na woŋo maama nɩ Zezi na maŋɩ o ta te tɩn. Ba ma kwɛ Pakɩ candiǝ kam wʋdiu kʋm ba ti. ");
INSERT INTO xsm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɩga ma ba ka yi. Zezi ma ba o zʋ digǝ kam dɩ o karabiǝ fugǝ-bale bam. ");
INSERT INTO xsm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ba ma jǝni sɩ ba di wʋdiu kʋm. Ba na wʋra ba di tɩn, Zezi laan ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam balʋ na je á tɔgɩ á di dɩ amʋ tɩn wʋ nɔɔnʋ dɩdʋa mʋ lagɩ o yǝgi amʋ o pa nɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ba na ni kʋntʋ tɩn, kʋ ma pa ba wʋ cɔgɩ zanzan. Ba maa bwe-o dɩdʋa dɩdʋa ba wɩ: «Kʋ yɩ amʋ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","O ma lǝri-ba o wɩ: «Kʋ yɩ abam fugǝ-bale bam wʋ dɩdʋa mʋ. Kʋ yɩ wʋlʋ na tɔgɩ dɩ amʋ o lu zʋŋa dɩdʋa wʋnɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kʋ nan maŋɩ sɩ amʋ Nabiin-bu wʋm vu a tɩ, nɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ brɩ a taanɩ te tɩn mʋ. Kʋ nan za wʋ́ ta yɩ lɛɛrʋ mʋ kʋ pa nɔɔnʋ wʋlʋ na wʋ́ yǝgi amʋ Nabiin-bu wʋm o pa tɩn. Ba ya na maŋɩ ba wʋ lʋgɩ nɔɔnʋ wʋm kʋntʋ, kʋ ya wʋ́ ta gara.» ");
INSERT INTO xsm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba na wʋra ba di maŋa kalʋ tɩn, Zezi ma kwe dɩpɛ yɩ o kɩ Wɛ le dɩ ŋwaanɩ. O ma daarɩ o fɔ-dɩ o pa o karabiǝ bam yɩ o wɩ: «Joŋi-na, sɩ dɩntʋ yɩ a yɩra mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","O daa ma kwe tweeru biǝ sana dɩ zʋŋa, yɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma kwe o pa-ba, yɩ ba maama nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O maa wɩ: «Wo-nyɔɔrʋ tɩntʋ mʋ yɩ a jana kalʋ na lagɩ ka nuŋi ka duri sɩ ka ma vrɩ nɔɔna zanzan ba lwarɩm wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A lagɩ a ta cɩga mʋ dɩ abam sɩ, a daa bá nyɔ wo-nyɔɔrʋ tɩntʋ, sɩ kʋ taa ve maŋa kam a na wʋ́ jǝni Wɛ paarɩ dɩm wʋnɩ a daa nyɔ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ba laan ma leeni ba zuli Wɛ, yɩ ba daarɩ ba nuŋi ba vu Olivi piu kʋm yuu. ");
INSERT INTO xsm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zezi ma ta dɩ ba o wɩ: «Abam maama wʋ́ ba á joori amʋ kwaga nɩ, nɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ brɩ te tɩn. Wɛ dɛɛn tagɩ DƖ wɩ: ‹Aá pa ba gʋ nayɩrʋ wʋm, yɩ o peeni sɩm maama jagɩ.› ");
INSERT INTO xsm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kʋ daarɩ, Wɛ na joori DƖ bi-nɩ, aá da yigǝ a vu a taa cǝgi abam Galile nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Zezi na tagɩ kʋntʋ tɩn, Pɩyɛɛrɩ ma ta o wɩ: «Nɔɔna bam maama na maŋɩ ba joori nmʋ kwaga nɩ, amʋ bá fɔgɩ a joori nmʋ kwaga nɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zezi ma lǝr-o o wɩ: «A lagɩ a ta cɩga mʋ dɩ nmʋ sɩ, zɩm tɩtɩɩ dɩntʋ kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri kuni bɩle tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pɩyɛɛrɩ laan ma fɔgɩ o ta dɩ baarɩ o wɩ: «A brɩ a bá fʋ nɩ a yǝri nmʋ, kʋ na maŋɩ kʋ yɩ ba na lagɩ ba gʋ amʋ dɩ nmʋ maama mʋ dɩ.» Zezi karabiǝ bam maama dɩ ma ta kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ba laan ma zaŋɩ ba vu jǝgǝ kadoŋ gaarɩ na wʋra yɩ ba bǝ-ka nɩ Jesemanɩ tɩn. Zezi ma ta dɩ o karabiǝ bam o wɩ: «Á taá je yo, sɩ a vu a warɩ Wɛ sɩ a ba.» ");
INSERT INTO xsm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O ma pa Pɩyɛɛrɩ dɩ Zakɩ dɩ Zan tɔgɩ dɩd-o ba vu. O wʋ ma tiini kʋ cɔgɩ zanzan, yɩ o bɩcarɩ di. ");
INSERT INTO xsm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","O ma ta dɩ ba o wɩ: «A wʋ mʋ tiini kʋ cɔgɩ sɩ kʋ yi a tʋʋnɩ. Á nan taá zɩgɩ yo, sɩ á warɩ Wɛ sɩ á yɩ zaŋɩ á dɔ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O laan ma fʋfɔ o vu daa. O ma vi o yigǝ tɩga nɩ o loori Wɛ o wɩ, kʋ na waɩ sɩ cam dɩm kɛ dɩ daar-o. ");
INSERT INTO xsm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O ma loori Wɛ o wɩ: «Amʋ Ko Baba, nmʋ waɩ woŋo maama n kɩa. Nan pa cam dɩlʋ na lagɩ dɩ ba amʋ baŋa tɩn kɛ. Nan kɩ te na yi nmʋ wʋbʋŋa tɩn, sɩ n yɩ kɩ amʋ wʋbʋŋa na lagɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","O na loori Wɛ o ti tɩn, o ma joori o vu o karabiǝ batɔ bam te. O piini ba tigi ba dɔa. O ma ta dɩ Pɩyɛɛrɩ o wɩ: «Simɔn, n tigi n dɔ mʋ na? Bɛɛ mʋ yɩ n warɩ n ta n niǝ, sɩ n yɩ zaŋɩ n dɔ, sɩ kʋ yi maŋa fɩnfɩɩn dɩ? ");
INSERT INTO xsm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Fɔgɩ-na á yɩrɩ á tɩtɩ sɩ á taá loori Wɛ, sɩ á yɩ tʋ maŋɩm dɩm maŋa nɩ. Bɛŋwaanɩ nanzwǝnǝ wʋbʋŋa lagɩ sɩ ya sɛ Baŋa-Wɛ, yɩ o yɩra laan bwǝnǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O ma yagɩ-ba, yɩ o joori o vu o loori Wɛ, nɩ o ya na maŋɩ o loori te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O daa ta ma joori o vu o piini ba tigi ba dɔa, dɔɔm na tiini dɩ waɩ-ba tɩn ŋwaanɩ. Ba maa yǝri ba daa na wʋ́ ta kʋlʋ dɩd-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","O daa ma vu o loori Wɛ o kɩ kuni bɩtɔ, yɩ o joori o ba ba te. O laan ma ta dɩ ba o wɩ: «Á ta tigi á dɔa mʋ na? Kʋ maŋɩ. Nii-na! Maŋa kam yiǝ, sɩ ba ja amʋ Nabiin-bu wʋm ba kɩ nɔn-balwaarʋ jɩa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Zaŋɩ-na sɩ dɩ́ vu. Nɔɔnʋ wʋlʋ na lagɩ o yǝgi-nɩ o pa tɩn maa bɩɩna.» ");
INSERT INTO xsm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zezi ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, mʋ Zudasɩ wʋlʋ na yɩ o karabiǝ fugǝ-bale bam wʋ dɩdʋa tɩn tu o yi o te, yɩ nɔn-kɔgɔ zanzan tɔgɩ dɩd-o kʋ ba, yɩ ba ze sʋ-lwaanʋ dɩ da-lwaanʋ. Kʋ yɩ Zwifǝ bam kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam dɩ ba nakwa bam mʋ tʋŋɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudasɩ ya maŋɩ o pa kɔgɔ kʋm lwarɩ nɩ, o na ve o kukwǝri nɔɔnʋ wʋlʋ tɩn, sɩ ba vu ba ja kʋntʋ tu, sɩ ba fɔgɩ ba ja-o lanyɩranɩ ba ja viiri. ");
INSERT INTO xsm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","O laan ma yɔɔrɩ o vu o yi Zezi te yɩ o wɩ: «Karanyɩna.» O ma daarɩ o kukwǝr-o. ");
INSERT INTO xsm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nɔɔna bam laan ma yi ba ja Zezi. ");
INSERT INTO xsm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nɔɔna balʋ na tɔgɩ ba wʋ Zezi tee nɩ tɩn dɩdʋa ma lɩ o sʋgʋ o ma zagɩ kaanɩm yuutu wʋm tɩntʋŋnʋ zwɛ o go. ");
INSERT INTO xsm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zezi laan ma bwe kɔgɔ kʋm o wɩ: «Abam na kwe sʋ-lwaanʋ dɩ da-lwaanʋ á ba sɩ á ja amʋ tɩn, a yɩ ŋwɩɩnʋ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dɛ maama a yǝni a wʋ abam tee nɩ a brɩ nɔɔna Wɛ-di-kamunu kʋm wʋnɩ, yɩ á ba jaanɩ-nɩ. Kʋ nan maŋɩ sɩ kʋ kɩ kʋntʋ mʋ, sɩ kʋ pa kʋlʋ na maŋɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn sɩɩnɩ kʋ kɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","O karabiǝ bam maama na nɛ kʋntʋ tɩn, ba ma duri ba viiri ba daar-o. ");
INSERT INTO xsm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nɔn-dʋŋʋ kʋdoŋ ya wʋra, o na tɔgɩ Zezi. O ya kukwǝri gar-jalɩ yɩranɩ mʋ. Ba ma kwaanɩ sɩ ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","O ma vrɩ o tɩtɩ o daarɩ o gɔrɔ kʋm o yagɩ o pa-ba, yɩ o duri kalambolo o viiri. ");
INSERT INTO xsm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ba ma ja Zezi ba vu kaanɩm yuutu wʋm sɔŋɔ. Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ dɩ ba tɩʋ kʋm nakwa bam maama ma gilimi daanɩ jǝgǝ kam kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɩyɛɛrɩ ma dalɩ o tɔgɩ ba kwaga o da o vu o yi kaanɩm yuutu wʋm sɔŋɔ. O ma zʋ o jǝni dɩ sɔŋɔ kʋm tɩntʋŋna bam o tɔgɩ o weeri mini. ");
INSERT INTO xsm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Zwifǝ bam kaanɩm yigǝ tiinǝ bam dɩ ba sarɩya-dirǝ nakwa kɔgɔ kʋm maama maa kwaanɩ sɩ ba na cwǝŋǝ kalʋ ba na wʋ́ da da ba ma saŋɩ Zezi sɩ ba laan pa ba gʋ-o tɩn. Ba ma kwaanɩ taan ba ga. ");
INSERT INTO xsm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nɔɔna zanzan ma zaŋɩ ba fɔ vwan ba pa-o, yɩ ba na tɛ ba wɩ o kɩ wǝǝnu tɩlʋ tɩn ba tɔgɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nɔɔna badonnǝ dɩ daa ma zaŋɩ ba fɔ vwan ba pa Zezi ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Dɩbam ni nɔɔnʋ wʋntʋ na tagɩ o wɩ, oó magɩ Wɛ-di-kamunu kʋntʋ nabiinǝ na lɔgɩ tɩn o dɩ tɩga nɩ, yɩ o joori o ma da yatɔ o lɔ kadoŋ, yɩ kʋ daɩ nabiinǝ mʋ wʋ́ lɔ-ka.» ");
INSERT INTO xsm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nan dɩ nɔɔna bam na maŋɩ ba tɛ kʋntʋ dɩ tɩn, ba niǝ daa ta ba tɔgɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kaanɩm yuutu wʋm laan ma zaŋɩ ba maama tɩtarɩ nɩ, yɩ o bwe Zezi o wɩ: «Nɔɔna bantʋ na tagɩ kʋlʋ ba pa nmʋ tɩn, nmʋ ba jɩgɩ taanɩ sɩ n lǝri na?» ");
INSERT INTO xsm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Zezi maa cɩm yɩ o wʋ lǝri kʋlʋkʋlʋ. Kaanɩm yuutu wʋm ma joori o bwe-o o wɩ: «Nmʋ mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn na? Nmʋ mʋ yɩ Baŋa-Wɛ dɩlʋ dɩbam na zuli tɩn Bu wʋm na?» ");
INSERT INTO xsm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Zezi ma lǝri o wɩ: «Ɛɛn, amʋ mʋ kʋntʋ. Nan taá ye-na nɩ, á wʋ́ ba á na Nabiin-bu wʋm na je Dam-fɔrɔ Tu Baŋa-Wɛ jazɩm nɩ, yɩ á ta wʋ́ na-o o na nuŋi wɛyuu nɩ o maa bɩɩnɩ kunkwǝǝnu wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kaanɩm yuutu wʋm na ni kʋntʋ tɩn, o ma zaŋɩ o kaarɩ o tɩtɩ gɔrɔ, sɩ kʋ brɩ nɩ o wʋ tiini kʋ cɔgɩ dɩ Zezi taanɩ dɩm. O ma ta o wɩ: «Dɩ́ daa ba lagɩ maana tiinǝ sɩ ba ŋɔɔnɩ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Abam maama maŋɩ á ni o na ŋɔɔnɩ o twɩ Wɛ, o paɩ o dɩ Wɛ ma daanɩ mʋ. Kʋntʋ tɩn, abam wɩ bɛɛ mʋ?» Ba maama ma lǝri ba wɩ, o maŋɩ sɩ o tɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ba badaara ma twɩ lileeru ba yagɩ o yɩra nɩ. Ba ma kwe gɔrɔ ba ma pu o yiǝ, yɩ ba daarɩ ba mag-o dɩ jagulǝ yɩ ba wɩ: «Lwarɩ n brɩ dɩbam wʋlʋ na magɩ-m tɩn.» Pamaŋna bam ma jɩg-o ba maga. ");
INSERT INTO xsm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pɩyɛɛrɩ ya daa ta tɔgɩ o je kʋnkɔlɔ kʋm nɩ. Kaanɩm yuutu wʋm sɔŋɔ tɩntʋŋ-kana ma ba ka tɔgɩ da ka maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","O ma na Pɩyɛɛrɩ na je o weeri mini. O ma fɔgɩ o nii-o lanyɩranɩ, yɩ o wɩ: «Nmʋ dɩ tɔgɩ dɩ Nazarɛtɩ tu Zezi mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","O ma fʋ o wɩ: «A yǝri woŋo kʋlʋ n na tɛ tɩn. A ba ni kʋ kuri.» O ma zaŋɩ o nuŋi o vu mancoŋo ni. Cɩbwɩʋ ma da kʋ keeri. ");
INSERT INTO xsm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tɩntʋŋ-kana kam daa ma na-o. O daa ta ma ta dɩ nɔɔna balʋ na zɩgɩ da tɩn o wɩ: «Nɔɔnʋ wʋntʋ tɔgɩ o yɩ Zezi kɔgɔ kʋm wʋ dɩdʋa mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","O daa ma fʋ o wɩ, o daɩ ba wʋ nɔɔnʋ. Kʋ na kɩ fɩɩn tɩn, nɔɔna balʋ na zɩgɩ da tɩn ma ta dɩ Pɩyɛɛrɩ ba wɩ: «Nmʋ sɩɩnɩ n yɩ ba wʋ dɩdʋa mʋ. Nmʋ dɩ yɩ Galile tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","O laan ma sɔɔlɩ o pa o tɩtɩ, sɩ kʋ taa yɩ nɩ cɩga mʋ o taga, yɩ o wɩ: «A brɩ a yǝri nɔɔnʋ wʋlʋ á na tɛ o taanɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","O na tagɩ kʋntʋ tɩn, cɩbwɩʋ laan ma da kʋ keeri kʋ kɩ kuni bɩle. Pɩyɛɛrɩ laan ma guli Zezi ya na tagɩ kʋlʋ dɩd-o o wɩ: «Kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri kuni bɩle tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» O na guli kʋntʋ tɩn, o wʋ ma tiini kʋ cɔgɩ zanzan, o ma zaŋɩ o nuŋi yɩ o keerǝ. ");
INSERT INTO xsm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tɩga na tu ka pʋʋrɩ tɩtɩɩtɩ tɩn, Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba tɩʋ kʋm nakwa bam, dɩ ba karanyɩna tiinǝ bam dɩ ba sarɩya-dirǝ nakwa kɔgɔ kʋm maama ma ba ba kɩ ni daanɩ. Ba ma pa ba ja Zezi ba vɔ, yɩ ba ja-o ba vu ba kɩ gʋvɩrma tu Pilatɩ jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatɩ ma bwe-o o wɩ: «Nmʋ mʋ yɩ Zwifǝ bam pɛ wʋm na?» Zezi ma lǝr-o o wɩ: «Mʋ ka da n taga.» ");
INSERT INTO xsm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Zwifǝ kaanɩm yigǝ tiinǝ bam ma tiini ba maŋɩ wǝǝnu zanzan ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatɩ ta ma joori o bwe-o o wɩ: «Nmʋ ba lagɩ n lǝri ba taanɩ dɩm na? Nmʋ wʋ ni ba na ŋɔɔnɩ kʋlʋ maama ba pa nmʋ tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Zezi daa ta ma wʋ lǝri ba taanɩ dɩm dɩlʋdɩlʋ. Kʋ ma pa Pilatɩ tiini o yɩ yǝǝu dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɩnɩ maama Pakɩ candiǝ kam maŋa na yǝni ka yi, gʋvɩrma tu yǝni o lɩ pɩɩnʋ dɩdʋa mʋ o pa nɔɔna bam, nɩnɛɛnɩ bantʋ na lagɩ wʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pɩɩnʋ wʋdoŋ dɛɛn maa wʋra, o yɩrɩ mʋ Barabasɩ. Ba dɛɛn ya pɩ-o dɩ balʋ na wǝli daanɩ ba kɩ jara dɩ ba tɩʋ kʋm yigǝ tiinǝ yɩ ba gʋ nɔɔnʋ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nɔɔna bam ma ba ba la kɔgɔ, yɩ ba ta dɩ Pilatɩ sɩ o lɩ pɩɩnʋ dɩdʋa o pa-ba, nɩ o na yǝni o kɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatɩ ma bwe-ba o wɩ: «Á lagɩ sɩ a lɩ Zwifǝ bam pɛ wʋm mʋ a pa abam na?» ");
INSERT INTO xsm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","O dɛɛn bwe-ba kʋntʋ, bɛŋwaanɩ o ye nɩ kʋ yɩ wʋ-gʋrʋ ŋwaanɩ mʋ kaanɩm yigǝ tiinǝ bam ya jaanɩ Zezi ba kɩ o jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kaanɩm yigǝ tiinǝ bam ma sʋgɩ nɔn-kɔgɔ kʋm, ba pa ba ta dɩ Pilatɩ nɩ ba lagɩ sɩ o yagɩ Barabasɩ mʋ o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatɩ laan ma bwe-ba o wɩ: «Sɩ wʋlʋ á na bǝ-o nɩ Zwifǝ bam pɛ tɩn, abam lagɩ sɩ a kɩ-o ta mʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ba ma kaasɩ baŋa baŋa ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","O ma joori o bwe-ba o wɩ: «Wʋntʋ cɔgɩ bɛɛ mʋ?» Ba laan ma tiini ba kaasɩ baŋa baŋa ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatɩ maa lagɩ sɩ o pa kɔgɔ kʋm wʋ poli. Kʋntʋ ŋwaanɩ o ma pa ba pʋrɩ Barabasɩ ba yagɩ. O daarɩ o pa ba magɩ Zezi dɩ balaara, yɩ o pa-ba cwǝŋǝ sɩ ba ja-o ba vu ba pa tʋʋn-dagara baŋa nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pamaŋna bam laan ma ja Zezi ba vu ba zʋ gʋvɩrma tu Pilatɩ sɔŋɔ kʋm kʋnkɔlɔ. Ba ma pa pamaŋna bam kɔgɔ kʋm maama gilimi da, ");
INSERT INTO xsm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","yɩ ba pa o zʋ gwar-sʋŋʋ. Ba ma daarɩ ba kwe sabarɩ ba ma sɔ yipugǝ ba pu o yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ba laan maa kɩ nɩ ba zul-o mʋ te yɩ ba wɩ: «Zwifǝ bam pɛ, dɩnle.» ");
INSERT INTO xsm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ba maa jɩgɩ miu ba lɔɛ o yuu nɩ, yɩ ba twɩ lileeru ba yagɩ o yɩra nɩ. Ba ma kuni doonǝ o yigǝ nɩ, yɩ ba kɩ nɩ ba zul-o mʋ te. ");
INSERT INTO xsm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ba na yaalɩ yaal-o ba ti tɩn, ba ma lɩ gwar-sʋŋʋ kʋm, yɩ ba joori ba zʋ-o o tɩtɩ gɔrɔ kʋm. Ba laan ma ja-o ba nuŋi ba vu sɩ ba pa tʋʋn-dagara baŋa nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ba na maa kɛ tɩn, ba ma na nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Simɔn. O nuŋi Sirɛɛnɩ mʋ. Wʋntʋ mʋ yɩ Alɛsandrɩ dɩ Rufusi ko. O dɛɛn ya nuŋi kara mʋ o ba o yi tɩʋ wʋ o maa kɛa. Pamaŋna bam na nɛ-o tɩn, ba ma fɩ-o sɩ o kwe tʋʋn-dagara kam o zɩŋɩ sɩ ba vu. ");
INSERT INTO xsm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ba ma ja Zezi ba vu ba yi jǝgǝ kalʋ ba na bǝ nɩ Goligota tɩn. Yɩrɩ dɩm kʋntʋ kuri mʋ Yukol-pʋa piu. ");
INSERT INTO xsm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ba na yi da tɩn, ba ma kɩ sana kalʋ na gwaanɩ dɩ liri sɩlʋ yɩrɩ na yɩ Miiri tɩn, ba pa Zezi sɩ o nyɔ. O ma wʋ sɛ o nyɔ. ");
INSERT INTO xsm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ba laan ma ja-o ba pa dagara kam baŋa nɩ. Ba ma kwe o gwaarʋ tɩm sɩ ba maŋɩ ba pa daanɩ. Ba ma ta jɔrɔ sɩ ba nii, wɔɔ mʋ wʋ́ twǝri kʋlʋ o na lagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ba na pag-o maŋa kalʋ tɩn yɩ tɩtɩɩtɩ luu nʋgʋ maŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ba ma pʋpʋnɩ tɔnɔ, sɩ kʋ brɩ kʋlʋ o na cɔgɩ yɩ ba gʋ-o tɩn, ba tanɩ tʋʋn-dagara kam yuu nɩ. Ba pʋpʋnɩ ba wɩ: «Wʋntʋ yɩ Zwifǝ bam pɛ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ba ma ja ŋwɩɩna bale dɩ ba pa dagarɩ sɩdonnǝ baŋa nɩ. Ba ma cwi dɩdʋa Zezi jazɩm nɩ. Wʋwʋm maa wʋ o jagwiǝ nɩ.  ");
INSERT INTO xsm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kʋntʋ ma pa kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn sɩɩnɩ kʋ kɩ, nɩ kʋ na wɩ: «Ba wǝl-o dɩ nɔn-balwaarʋ mʋ, kʋ ma pa nɔɔna nii-o nɩ nɔn-balɔrɔ te.» ");
INSERT INTO xsm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nɔɔna balʋ na tɔgɩ da ba kɛ tɩn maa niǝ, yɩ ba gɔgɩsɩ ba yuni ba twɩ-o. Ba ma yáal-o yɩ ba wɩ: «Nii. Nmʋ ya na bʋŋɩ sɩ n cɩcʋgɩ Wɛ-di-kamunu kʋm mʋ n dɩ tɩga nɩ, sɩ n daarɩ n ma da yatɔ n joori n fɔgɩ n lɔ-ka tɩn, ");
INSERT INTO xsm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","laan nan vrɩ n tɩtɩ n tu dagara kam yuu nɩ sɩ dɩ́ nii.» ");
INSERT INTO xsm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam dɩ maa twɩ-o ba brɩ daanɩ ba mwana. Ba maa tɛ daanɩ ba wɩ: «O yǝni o vrɩ nɔɔna badonnǝ ŋwɩa, yɩ o laan warɩ o tɩtɩ ŋwɩa o vrɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","O brɩ o tɩtɩ nɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, dɩ Yisɩrayɛlɩ dwi tiinǝ pɛ. O nan tu dagara kam yuu nɩ lele sɩ dɩ́ nii. Dɩ́ na nɛ kʋntʋ, dɩ́ laan wʋ́ sɛ-o.» Nɔɔna balʋ ba na pagɩ dagarɩ sɩm baŋa nɩ ba wǝli da tɩn dɩ maa jɩg-o ba twɩa. ");
INSERT INTO xsm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kʋ ma vu kʋ yi maŋa kam wɛ na tu dɩ yi yuparɩ baŋa nɩ tɩn. Lʋgʋ kʋm maama ma ba kʋ ji lim kʋ vu kʋ yi wɛ-guni maŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kʋ na kɩ nɩnɛɛnɩ luu batɔ te tɩn, Zezi laan ma kaasɩ baŋa baŋa dɩ kwǝr-dɩa o wɩ: «Eli, Eli, lɛma sabakɩtani?» Taanɩ dɩntʋ kuri mʋ: «Amʋ Wɛ, amʋ Wɛ, bɛɛ mʋ kɩ yɩ n yagɩ amʋ?» ");
INSERT INTO xsm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nɔɔna balʋ na zɩgɩ da yɩ ba ni taanɩ dɩm tɩn badaara maa wɩ: «Cǝgi-na. O lagɩ o bǝŋi Eli mʋ sɩ o ba.» ");
INSERT INTO xsm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ba dɩdʋa laan ma duri o vu o kwe sɩpɔɔ o dɩ sa-nywana wʋnɩ, o kɩ-kʋ miu ni nɩ o vu o te o pa Zezi sɩ o nyɔ. O daarɩ o wɩ: «Yagɩ sɩ dɩ́ cǝgi dɩ́ nii, Eli wʋ́ ba o pa o tu dagara kam yuu nɩ na?» ");
INSERT INTO xsm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Zezi laan ma kaasɩ baŋa baŋa, yɩ o daarɩ o pa o siun ti. ");
INSERT INTO xsm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Zezi na tɩgɩ kʋntʋ tɩn, gɔrɔ kʋlʋ ba na lǝgi ba ma cɩ Wɛ-di-laa kʋm tɩn ma kaarɩ bɩle, kʋ zɩgɩ baŋa nɩ kʋ tu kʋ kwaarɩ tɩga. ");
INSERT INTO xsm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pamaŋna bam yigǝ tu wʋlʋ na zɩgɩ Zezi yigǝ nɩ tɩn ma na o na kaasɩ yɩ o daarɩ o tɩ te tɩn. O na nɛ kʋntʋ tɩn, o maa wɩ: «Nɔɔnʋ wʋntʋ ya sɩɩnɩ o yɩ Baŋa-Wɛ Bu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kaana badonnǝ maa tɔgɩ ba wʋra, ba ma zɩgɩ yigǝ yigǝ ba niǝ. Mari wʋlʋ na nuŋi Magɩdala tɩn maa wʋ ba wʋnɩ, dɩdaanɩ Mari wʋlʋ na yɩ Zakɩ kukulǝ dɩ Zʋzɛsɩ nu tɩn. Salomɩ dɩ maa tɔgɩ o wʋra. ");
INSERT INTO xsm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kaana bantʋ dɛɛn ya tɔgɩ dɩ Zezi Galile nɩ mʋ, yɩ ba yǝni ba tʋŋɩ ba zǝn-o. Kaana badaara zanzan dɩ maa wʋra, ba ya na tɔgɩ dɩd-o ba ba Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Zʋzɛfʋ, o na nuŋi Arimatɩ. O yɩ Zwifǝ bam nakwa kɔgɔ kʋm yigǝ tu dɩdʋa, yɩ nɔɔna pa-o zulǝ. O maa jɩgɩ tɩɩna nɩ Wɛ paarɩ dɩm wʋ́ ba nɔɔna tɩtarɩ nɩ. Dɛ dɩm ba na gʋ Zezi tɩn maa yɩ dɛ dɩlʋ Zwifǝ bam na maŋɩ sɩ ba ti ba yigǝ ba siun dɛ dɩm ŋwaanɩ tɩn. Tɩga na yi, mʋ ba siun dɛ dɩm pulim. Kʋntʋ ŋwaanɩ Zʋzɛfʋ ma kɩ pu-dɩa, yɩ o zaŋɩ o vu Pilatɩ te o loor-o cwǝŋǝ, sɩ o kwe Zezi yɩra yam o kɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatɩ na lwarɩ nɩ Zezi maŋɩ o tɩ tɩn, mʋ kʋ sʋ-o lanyɩranɩ. O ma tʋŋɩ nɔɔna sɩ ba vu ba bǝŋi pamaŋna bam yigǝ tu wʋm sɩ o ba. O na tu tɩn, o ma bwe-o sɩ o nii, Zezi sɩɩnɩ o tɩ mʋ na. ");
INSERT INTO xsm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","O na lwarɩ nɩ o tɩgɩ tɩn, o ma sɛ sɩ Zʋzɛfʋ vu o kwe o yɩra yam o kɩ. ");
INSERT INTO xsm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zʋzɛfʋ ma nuŋi o vu o yǝgi gar-jalɩ dɩlʋ na lana tɩn. O ma vu o parɩ Zezi yɩra yam dagara kam yuu nɩ. O ma kwe gɔrɔ kʋm o ma pipir-o, yɩ o daarɩ o ja vu o tiŋi piu bɔɔnɩ wʋnɩ. Dɩntʋ yɩ yibeeli dɩlʋ ba dɛɛn na lugi-dɩ piu yɩra nɩ tɩn mʋ. O laan ma bibili kandwɛ-pulɔgɔ o ma pɩ bɔɔnɩ dɩm ni. ");
INSERT INTO xsm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari wʋlʋ na nuŋi Magɩdala dɩ Mari wʋlʋ na yɩ Zʋzɛsɩ nu tɩn maa zɩgɩ ba nii o na tiŋi Zezi yɩra yam mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ba siun dɛ dɩm ma ba dɩ kɛ. Mari wʋlʋ na nuŋi Magɩdala dɩ Mari wʋlʋ na yɩ Zakɩ nu tɩn dɩ Salomɩ ma zaŋɩ ba nuŋi ba vu ba yǝgi tralɩ nugǝ, sɩ ba ma turi Zezi yɩra yam. ");
INSERT INTO xsm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dɛ dɩlʋ na saŋɩ siun dɛ dɩm tɩn, ba maa zaŋɩ ba go tɩga dɩ wɛ wʋra dɩ pulǝ, ba vu yibeeli dɩm jǝgǝ kam. ");
INSERT INTO xsm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ba na maa ve tɩn, ba ma bwɛ daanɩ ba wɩ: «Wɔɔ mʋ wʋ́ bibili kandwɛ dɩlʋ na pɩ yibeeli dɩm ni tɩn o yagɩ daa nɩ o pa dɩbam?» ");
INSERT INTO xsm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kandwɛ dɩm na yɩ kamunu tɩn mʋ te ba ŋɔɔnɩ kʋntʋ. Ba na yi jǝgǝ kam tɩn, ba ma fɔgɩ ba nii ba na dɩdaanɩ kandwɛ dɩm bibili dɩ tigi daa nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba ma vu ba zʋ bɔɔnɩ dɩm wʋ. Ba na zʋ tɩn, ba ma na nɔn-dʋŋʋ, kʋ na je ba jazɩm seeni. O zʋ gwar-poŋo dɩdɔrɔ mʋ. Ba na nɛ-o tɩn, kʋ ma pa ba yɩra sɔɔrɩ. ");
INSERT INTO xsm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O ma ta dɩ ba o wɩ: «Á yɩ taá kwarɩ fʋʋnɩ. Abam lagɩ sɩ á na Nazarɛtɩ tu Zezi wʋlʋ ba na jaanɩ ba pa tʋʋn-dagara kam baŋa nɩ ba gʋ tɩn mʋ. O nan tǝri yo. O joori o bi. Nii-na ba ya na tiŋi o yɩra yam mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nan ve-na á ta dɩ Pɩyɛɛrɩ dɩ Zezi karabiǝ bam maama nɩ, o lagɩ o da yigǝ o vu o taa cǝgi abam Galile nɩ. Dáanɩ mʋ abam wʋ́ vu á na-o. Kʋʋ́ kɩ nɩ o na maŋɩ o ta kʋlʋ o brɩ abam tɩn.» ");
INSERT INTO xsm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kaana bam na ni kʋntʋ tɩn, fʋʋnɩ maa pa ba yɩra saɩ, yɩ ba wʋbʋŋa vugimi. Ba ma nuŋi bɔɔnɩ dɩm wʋnɩ ba duri ba kɛ. Fʋʋnɩ na jɩgɩ-ba kʋntʋ yɩ ba maa ve tɩn, ba ma wʋ tagɩ kʋlʋ na kɩ tɩn ba brɩ nɔɔn-nɔɔnʋ.  ");
INSERT INTO xsm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Dɛ dɩm Zezi na bi tɩtɩɩtɩ tɩn maa yɩ dɛ dɩlʋ na saŋɩ Zwifǝ bam siun dɛ dɩm tɩn. O na bi tɩn, o ma puli o brɩ o tɩtɩ Mari wʋlʋ na nuŋi Magɩdala tɩn tee nɩ. Wʋntʋ mʋ yɩ kaanɩ wʋlʋ o ya na zǝli ciciri sɩrpɛ o yɩra nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari laan ma vu o ta o brɩ balʋ ya na tɔgɩ dɩ Zezi tɩn. O yi ba te dɩ ba wʋrʋ cɔgɩ zanzan yɩ ba keerǝ. ");
INSERT INTO xsm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ba na ni nɩ Mari wɩ, Zezi joori o bi o ŋwɩ yɩ wʋm na-o tɩn, ba wʋ sɛ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kʋ kwaga seeni, Zezi ma lǝni o yibiyǝ yɩ o brɩ o tɩtɩ o karabiǝ bale. Ba ya nuŋi Zeruzalɛm mʋ ba maa ve tɩ-balaŋa kadoŋ. ");
INSERT INTO xsm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba na nɛ-o tɩn, ba ma joori ba vu Zeruzalɛm ba ta ba brɩ ba donnǝ karabiǝ bam. Ba maa daa ta wʋ sɛ nɩ kʋ yɩ cɩga. ");
INSERT INTO xsm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kʋntʋ kwaga nɩ, Zezi laan ma ba o brɩ o tɩtɩ o karabiǝ fugǝ-dɩdʋa kam, ba na wʋra ba di wʋdiu maŋa kalʋ tɩn. O ma kaanɩ-ba dɩ ba wʋbʋŋa na muri yɩ ba wʋ sɛ Wɛ cɩga kam tɩn, bɛŋwaanɩ ba vɩn sɩ ba sɛ balʋ na tagɩ ba brɩ-ba nɩ wʋntʋ joori o bi yɩ ba na-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","O laan ma ta dɩ ba o wɩ: «Zaŋɩ-na á vu lʋgʋ baŋa je maama, sɩ á tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam á brɩ nabiinǝ maama. ");
INSERT INTO xsm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩ amʋ yɩ o daarɩ o pa ba miis-o na wʋnɩ Wɛ ŋwaanɩ tɩn, Wɛ wʋ́ vrɩ kʋntʋ tu ŋwɩa. Kʋ daarɩ balʋ maama na wʋ sɛ tɩn wʋ́ ga bʋra yɩ ba na cam Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Balʋ na sɛ amʋ tɩn wʋ́ wanɩ ba taa kɩ wo-kɩnkagɩla yalʋ na brɩ Wɛ dam tɩn. Baá da amʋ yɩrɩ ŋwaanɩ ba zǝli ciciri nɔɔna yɩra nɩ. Baá ta ŋɔɔnɩ ta-gɛ. ");
INSERT INTO xsm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ba na jaanɩ bɩsankwɩ dɩ ba jɩa, sɩ bá kɩ-ba kʋlʋkʋlʋ. Ba na nyɔgɩ coŋo, kʋ bá kɩ-ba kʋlʋkʋlʋ. Ba na daŋɩ ba jɩa yawɩɩna baŋa nɩ, baá na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dɩ́ Yuutu Zezi na ŋɔɔnɩ o brɩ-ba kʋntʋ tɩn, Wɛ laan ma pa o zaŋɩ o di DƖ sɔŋɔ. O ma vu o jǝni Baŋa-Wɛ jazɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","O na diini Wɛ-sɔŋɔ kʋntʋ tɩn, o karabiǝ bam ma nuŋi ba vu ba beeri je maama nɩ ba tɔɔlɩ Wɛ kwǝrǝ kam ba brɩ nɔɔna. Dɩ́ Yuutu wʋm maa wʋ ba tee nɩ o tʋŋa. O ma pa-ba dam sɩ ba taa kɩ wo-kɩnkagɩla, sɩ kʋ brɩ nɩ o taanɩ dɩlʋ ba na brɩ tɩn sɩɩnɩ dɩ yɩ cɩga.");
INSERT INTO xsm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","A ciloŋ Teofili, a bʋŋɩ sɩ kʋ lana sɩ a pʋpʋnɩ tɔnɔ kʋntʋ a pa nmʋ, sɩ n wanɩ n lwarɩ kʋlʋ na yɩ cɩga tɩn. Nmʋ maŋɩ n ye wo-kamunnu tɩlʋ na kɩ dɩbam tee nɩ tɩn ni nɩ. Nɔɔna badonnǝ dɛɛn mʋ wʋra wo-kamunnu tɩntʋ pulim nɩ. Ba nɛ kʋlʋ maama na kɩ tɩn, yɩ ba brɩ Wɛ kwǝrǝ kam. Ba ma daarɩ ba pa dɩbam lwarɩ kʋlʋ na kɩ tɩn. Nɔɔna zanzan ma kwaanɩ sɩ ba pʋpʋnɩ wǝǝnu tɩntʋ ba tiŋi. Mʋ kʋ kuri a bʋŋɩ sɩ kʋʋ́ ta lamma sɩ a dɩ pʋpʋnɩ-tɩ lanyɩranɩ a pa nmʋ. A kwaanɩ a zaasɩ wǝǝnu tɩm tɩ pulim nɩ mʋ, yɩ a lwarɩ tɩ kuri cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kʋntʋ tɩn, aá wanɩ a pʋpʋnɩ wǝǝnu tɩntʋ na kɩ te tɩn, sɩ n wanɩ n lwarɩ lanyɩranɩ nɩ, wǝǝnu tɩlʋ ba na tagɩ ba brɩ nmʋ tɩn sɩɩnɩ tɩ yɩ cɩga. ");
INSERT INTO xsm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Maŋa kam Erɔdɩ dɛɛn na yɩ Zude pɛ tɩn, nɔɔnʋ wʋdoŋ mʋ wʋra, o yɩrɩ mʋ Zakari. Wʋntʋ mʋ yɩ Wɛ kaanɩm tu. O nuŋi Abɩa dwi tiinǝ wʋnɩ mʋ. O kaanɩ yɩrɩ mʋ Elizabɛtɩ. Wʋntʋ dɩ dɛɛn nuŋi kaanɩm tu Aarɔn dwi dɩm wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bantʋ maama kɩ lanyɩranɩ Wɛ yigǝ nɩ, yɩ ba sɛ Wɛ niǝ yam dɩ DƖ cullu tɩm maama. ");
INSERT INTO xsm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elizabɛtɩ dɛɛn yɩ ka-dʋgʋ mʋ yɩ o ba jɩgɩ bu. Ba maama dɛɛn kwɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Maŋa ma ba yi sɩ Abɩa dwi tiinǝ bam zʋ Wɛ-di-kamunu kʋm ba taa tʋŋɩ ba pa Wɛ. Zakari maa tɔgɩ o wʋra o tʋŋa. ");
INSERT INTO xsm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Wɛ kaanɩm tiinǝ bam yǝni ba ta jɔrɔ mʋ sɩ ba nii, ba wʋnɩ wɔɔ mʋ wʋ́ zʋ Wɛ-di-laa kʋm wʋnɩ o zwɛ wǝǝnu tɩlʋ lwǝm na ywǝmmǝ tɩn o pa Wɛ. Ba ma ta jɔrɔ yɩ Zakari di. ");
INSERT INTO xsm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","O ma sɩɩnɩ o zʋ sɩ o zwɛ wǝǝnu tɩm o pa Wɛ. Maŋa kam o na wʋ digǝ kam wʋnɩ tɩn, nɔn-kɔgɔ zanzan dɛɛn ma wʋ kʋnkɔlɔ kʋm nɩ ba zɩgɩ ba warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Baŋa-Wɛ malɛka laan ma da ka ba o te, ka zɩgɩ wǝǝnu zwɛɛm bimbim dɩm jazɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari na nɛ-ka tɩn, o maa yɩ yǝǝu yɩ fʋʋnɩ zʋ-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malɛka kam ma ta dɩd-o ka wɩ: «Zakari, yɩ ta n kwarɩ fʋʋnɩ, sɩ Wɛ ni nmʋ na loori-DƖ kʋlʋ tɩn. Nmʋ kaanɩ wʋm laan wʋ́ ja pugǝ o lʋ bu o pa-m, sɩ n pa o yɩrɩ nɩ Zan. ");
INSERT INTO xsm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","O lʋra kam wʋ́ pa n na wʋpolo zanzan. Nɔɔna zanzan dɩ wʋ́ tiini ba taa jɩgɩ wʋpolo dɩ o lʋra kam. ");
INSERT INTO xsm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Oó ta yɩ nɔn-kamunu Baŋa-Wɛ tee nɩ. O nan yɩ zaŋɩ o nyɔ sana naa woŋo kʋlʋ na kɩkarɩ yiǝ tɩn. Wɛ Joro kʋm wʋ́ ta wʋ o tee nɩ maŋa maama, kʋ na wʋ́ sɩŋɩ o lʋra kam maŋa nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O nan wʋ́ pa Yisɩrayɛlɩ dwi tiinǝ zanzan wʋbʋŋa joori ya taa tɔgɩ ba Yuutu Baŋa-Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Oó tɔgɩ dɩ́ Yuutu wʋm yigǝ, yɩ Wɛ Joro kʋm dam wʋ́ ta wʋ o tee nɩ, nɩnɛɛnɩ Wɛ nijoŋnu Eli dɛɛn na yɩ te tɩn. Oó pa kwǝ joori ba taa soe ba biǝ, yɩ o kwǝri o pa vɩnvɩɩna joori ba taa jɩgɩ nɔn-ŋʋna wʋbʋŋa, sɩ o fɔgɩ o kwɛ dɩ́ Yuutu wʋm nɔɔna bam yigǝ o pa-o.» ");
INSERT INTO xsm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakari laan ma bwe malɛka kam o wɩ: «A yɩ nankwɩan mʋ, yɩ a kaanɩ dɩ kwɩn. Bɛɛ mʋ wʋ́ pa a lwarɩ nɩ nmʋ taanɩ dɩm yɩ cɩga?» ");
INSERT INTO xsm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malɛka kam ma lǝr-o ka wɩ: «Amʋ nan yɩ Gabrɩyɛlɩ mʋ, wʋlʋ na zɩgɩ Wɛ tee nɩ tɩn. DƖ tʋŋɩ-nɩ sɩ a ba a ŋɔɔnɩ dɩ nmʋ, sɩ a ta ta-ŋʋm dɩm a brɩ-m. ");
INSERT INTO xsm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nmʋ nan na wʋ sɛ a taanɩ dɩm tɩn, Wɛ wʋ́ pa n ni mǝǝri. Maŋa kam na yiǝ, wǝǝnu tɩlʋ a na tagɩ a brɩ-m tɩn wʋ́ sɩɩnɩ tɩ kɩ. Nan ta n ye sɩ nmʋ bá wanɩ n ŋɔɔnɩ, sɩ kʋ taa ve maŋa kam wǝǝnu tɩm na wʋ́ kɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kʋntʋ maama na wʋra kʋ kɩ tɩn, nɔn-kɔgɔ kʋm maa zɩgɩ ba cǝgi Zakari sɩ o nuŋi Wɛ-di-laa kʋm wʋnɩ. Ba ma cǝg-o taan ba ga. Kʋ ma kɩ-ba yǝǝu dɩ o na daanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","O laan ma ba nuŋi, yɩ o warɩ o ŋɔɔnɩ dɩ ba. O ni na mǝǝri tɩn, o maa maɩ o jɩa o maŋɩ o brɩ-ba. Ba ma maanɩ sɩ o nɛ wo-kɩnkagɩlɩ mʋ Wɛ-di-laa kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Da yalʋ o na maŋɩ sɩ o taa tʋŋɩ Wɛ-di-kamunu kʋm wʋnɩ tɩn ma ba ya ti. O ma joori o vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Da yantʋ na kɛ tɩn, o kaanɩ wʋm laan ma ja pugǝ. O maa wʋ sɔŋɔ nɩ taan, canɩ sɩnu. ");
INSERT INTO xsm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","O na wʋra kʋntʋ tɩn, o maa wɩ: «Mʋ woŋo kʋlʋ Yuutu Baŋa-Wɛ na kɩ DƖ pa-nɩ tɩn. DƖ lɩ woŋo kʋlʋ ya na yɩ a cavɩɩra nɔɔna tɩtarɩ nɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Bɩsankana kadoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Mari. O ta yǝri baarʋ. O sɔŋɔ tiinǝ wʋbʋŋa dɛɛn ya yɩ sɩ o zʋ nɔɔnʋ wʋdoŋ mʋ, yɩ o daa ta wʋ zʋ-o. Nɔɔnʋ wʋm yɩrɩ mʋ Zʋzɛfʋ. O yɩ faŋa faŋa Pɛ Davidi dwi tu mʋ. Mari dɛɛn zʋʋrɩ Galile tɩʋ kʋdoŋ nɩ mʋ, kʋ yɩrɩ mʋ Nazarɛtɩ. Maŋa kam Zakari kaanɩ Elizabɛtɩ pugǝ kam na yi nɩnɛɛnɩ canɩ sɩrdʋ tɩn, Baŋa-Wɛ daa ma tʋŋɩ malɛka Gabrɩyɛlɩ sɩ ka vu Mari te. ");
INSERT INTO xsm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka ma zʋ o te ka jɔɔn-o yɩ ka wɩ: «Kɩ wʋpolo, n Yuutu Baŋa-Wɛ wʋ nmʋ tee nɩ sɩ DƖ zǝni-m lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari na ni ka na tagɩ kʋlʋ tɩn, o bɩcarɩ ma di. O ma bʋŋɩ o wɩ: «Taanɩ dɩntʋ kuri mʋ bɛɛ?» ");
INSERT INTO xsm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malɛka kam laan ma ta ka wɩ: «Mari, yɩ ta n kwarɩ fʋʋnɩ, sɩ Baŋa-Wɛ kɩ nmʋ yu-yoŋo. ");
INSERT INTO xsm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nmʋ wʋ́ ba n ja pugǝ n lʋ bǝkǝrǝ, sɩ n pa o yɩrɩ nɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wʋntʋ wʋ́ ta yɩ nɔn-kamunu. Baá ta bǝ-o ba wɩ, Baŋa-Wɛ Bu. Dɩ́ Yuutu Wɛ wʋ́ pa o di paarɩ nɩ o ko-nakwɩ Davidi dɛɛn na di paarɩ faŋa faŋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O ma wʋ́ ta yɩ Zakɔbɩ dwi tiinǝ bam pɛ maŋa maama. O paarɩ dɩm daa bá ti maŋa dɩ maŋa.» ");
INSERT INTO xsm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari ma lǝri malɛka kam o wɩ: «Kʋntʋ wʋ́ kɩ tɩta mʋ kʋ kɩ, yɩ a ta wʋ zʋ barʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malɛka kam ma lǝri ka wɩ: «Kʋ na wʋ́ kɩ te tɩn, Wɛ Joro kʋm wʋ́ ba nmʋ te, yɩ Baŋa-Wɛ tɩtɩ dam-fɔrɔ kʋm wʋ́ ba kʋ kwǝli nmʋ. Kʋntʋ ŋwaanɩ bu wʋlʋ n na wʋ́ lʋ tɩn wʋ́ ta yɩ Wɛ tɩtɩ nyɩm, yɩ ba taa bǝ-o nɩ Baŋa-Wɛ Bu. ");
INSERT INTO xsm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maanɩ n nii nmʋ cʋrʋ Elizabɛtɩ na yɩ te. Wʋntʋ jaanɩ pugǝ mʋ sɩ o lʋ bu, yɩ o maŋɩ o kwɩn. Nɔɔna ya bʋŋɩ sɩ o yɩ ka-dʋgʋ mʋ, yɩ o laan jɩgɩ pugǝ ka yi nɩnɛɛnɩ canɩ sɩrdʋ. ");
INSERT INTO xsm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kʋlʋkʋlʋ tǝrǝ Baŋa-Wɛ na bá wanɩ DƖ kɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari ma ta o wɩ: «Amʋ yɩ dɩ́ Yuutu Wɛ tɩntʋŋ-kana mʋ. Wɛ nan pa kʋ kɩ nɩ n na tagɩ te dɩ amʋ tɩn.» Malɛka kam laan ma viiri. ");
INSERT INTO xsm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Da yam kʋntʋ ni nɩ Mari ma zaŋɩ o kɩ lɩla o maa diini Zude tɩʋ kʋdoŋ na wʋ pweeru tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","O ma vu o yi Zakari sɔŋɔ. O ma zʋ o na o kaanɩ Elizabɛtɩ. O ma kɩ o pwǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maŋa kam Elizabɛtɩ na ni Mari na jɔɔn-o tɩn, o bu wʋm na tigi o wʋnɩ tɩn ma pipiri. Wɛ Joro kʋm ma ba Elizabɛtɩ te, ");
INSERT INTO xsm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","yɩ o ŋɔɔnɩ baŋa baŋa dɩ kwǝr-dɩa o wɩ: «Wɛ tiini DƖ kɩ nmʋ yu-yoŋo DƖ dwǝni kaana maama. Kʋ na yɩ bu wʋlʋ na wʋ n wʋnɩ tɩn, Wɛ kɩ-o yu-yoŋo lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Amʋ yɩ wɔɔ mʋ sɩ a Yuutu nu ba amʋ te? ");
INSERT INTO xsm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","N jɔɔnɩm dɩm na tu dɩ tʋ a zwɛ nɩ tɩn, bu wʋm na wʋ a wʋnɩ tɩn tigi o pipiri mʋ, o na jɩgɩ wʋpolo tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nmʋ na sɛ nɩ Baŋa-Wɛ jɩgɩ cɩga tɩn, nmʋ yɩ yu-yoŋo tu. Kʋlʋ maama Wɛ na tagɩ DƖ brɩ-m tɩn wʋ́ sɩɩnɩ kʋ kɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari laan ma ta o wɩ: «Aá pa a Yuutu Baŋa-Wɛ zulǝ dɩ a bɩcarɩ maama. ");
INSERT INTO xsm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wʋntʋ na yɩ a Vɩrnʋ tɩn mʋ pɛ a na wʋpolo dɩ a wʋ maama. ");
INSERT INTO xsm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bɛŋwaanɩ amʋ yɩ Wɛ tɩntʋŋ-kana balaŋa mʋ, yɩ DƖ nii amʋ baŋa nɩ. Kʋ na zɩgɩ zɩm kʋ ta maa ve, nɔɔna maama wʋ́ ta wɩ, a yɩ yu-yoŋo tu, ");
INSERT INTO xsm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","dɩdaanɩ Dam-fɔrɔ Tu Baŋa-Wɛ na kɩ kʋlʋ DƖ pa-nɩ tɩn ŋwaanɩ. Dɩntʋ mʋ yɩ wʋ-poŋo tu cɩga. ");
INSERT INTO xsm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Balʋ maama na kwarɩ-DƖ tɩn, DƖ jɩgɩ ba ŋwaŋa lanyɩranɩ maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wɛ kwe DƖ jɩŋa mʋ DƖ ma kɩ wo-kɩnkagɩla. DƖ ma pa banɩ-nyɩna jagɩ da-yigǝ nɩ dɩ ba wʋbʋŋ-yɔɔrʋ tɩm. ");
INSERT INTO xsm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","DƖ joŋi balʋ na yɩ pwa tɩn paarɩ, yɩ DƖ paɩ balʋ na yɩ nabwǝnǝ tɩn na zulǝ. ");
INSERT INTO xsm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","DƖ maa paɩ balʋ yinigǝ na jɩgɩ-ba tɩn wo-laarʋ zanzan, yɩ DƖ daarɩ DƖ pa nadunǝ viiri dɩ jɩ-kʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yisɩrayɛlɩ dwi tiinǝ yɩ DƖ tɩtɩ nɔɔna mʋ. DƖ guli ba gulǝ, DƖ duri ba ŋwaŋa yɩ DƖ zǝni-ba, ");
INSERT INTO xsm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nɩ DƖ na goni ni dɩdaanɩ dɩbam kwǝ-nakwa tɩn, dɩdaanɩ Abraham dɩ o dwi tiinǝ bam maama, sɩ kʋ taa ve maŋa kalʋ na ba ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari dɛɛn ma maŋɩ Elizabɛtɩ tee nɩ nɩnɛɛnɩ canɩ sɩtɔ. O laan ma joori sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Maŋa kam dɛɛn ma yi sɩ Elizabɛtɩ lʋ. O ma sɩɩnɩ o lʋ bǝkǝrǝ. ");
INSERT INTO xsm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","O tɩʋ kʋm tiinǝ dɩ o cʋrrʋ dɩ ma ni, Baŋa-Wɛ na tiini DƖ duri o ŋwaŋa yɩ DƖ kɩ kʋlʋ DƖ pa-o tɩn. Ba maama dɩ ma jɩgɩ wʋpolo zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bu wʋm da na yi nana tɩn, ba ma pa ba go-o, nɩ Moyisi cullu tɩm na brɩ sɩ ba taa goni ba bǝkǝri te tɩn. Ba ma lagɩ sɩ ba pa o yɩrɩ nɩ Zakari, nɩ o ko yɩrɩ na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","O nu wʋm ma wʋ sɛ yɩ o wɩ: «Awo, á pa o yɩrɩ nɩ Zan.» ");
INSERT INTO xsm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba ma lǝr-o ba wɩ: «Bɛŋwaanɩ mʋ yɩ n ta kʋntʋ? Nɔɔnʋ maŋɩ o tǝri á sɔŋɔ nɩ o yɩrɩ na yɩ Zan.» ");
INSERT INTO xsm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ba ma daarɩ ba ma ba jɩa ba maŋɩ ba brɩ o ko wʋm sɩ ba nii, o na lagɩ sɩ ba pa o bu wʋm yɩrɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O ma pa ba kwe tɔnɔ ba pa-o, sɩ o pʋpʋnɩ o brɩ-ba. O ma pʋpʋnɩ tɔnɔ kʋm wʋnɩ o wɩ, o yɩrɩ mʋ Zan. Kʋ ma sʋ-ba dɩ o na pʋpʋnɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","O na pʋpʋnɩ kʋntʋ tɩn, o ni ma puri bɩdwɩ baŋa nɩ, yɩ o dindǝlimi joori dɩ pipiri. O maa ŋɔɔnɩ o zuli Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Fʋʋnɩ dɛɛn ma ja ba tɩʋ kʋm nɔɔna bam maama. Balʋ maama dɛɛn na zʋʋrɩ Zude pweeru tɩm je sɩm nɩ tɩn dɩ dɛɛn ma ni wǝǝnu tɩlʋ na kɩ tɩn, yɩ ba jɩgɩ tɩ taanɩ ba ŋɔɔna. ");
INSERT INTO xsm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ba maa jɩgɩ kʋlʋ ba na ni tɩn ba wʋrʋ nɩ, yɩ ba tɛ ba wɩ: «Bu wʋntʋ nan lagɩ o ji wɔɔ mʋ?» Bɛŋwaanɩ Baŋa-Wɛ dam dɛɛn wʋ bu wʋm tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wɛ Joro kʋm dɛɛn ma ba bu wʋm ko Zakari te, yɩ kʋ pa o ŋɔɔnɩ Wɛ yiyiu-ŋwɛ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Pa-na dɩ́ zuli Baŋa-Wɛ dɩlʋ na te Yisɩrayɛlɩ tiinǝ tɩn, bɛŋwaanɩ DƖ tu DƖ nɔɔna bam te, sɩ DƖ vrɩ-ba lwarɩm wʋnɩ DƖ yagɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","DƖ ma pa wʋlʋ na yɩ faŋa faŋa Wɛ tɩntʋŋnʋ Davidi dwi tu tɩn zaŋɩ dɩ́ wʋnɩ, sɩ o ba o ji dɩbam vɩrnʋ. ");
INSERT INTO xsm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kʋ ma sɩɩnɩ kʋ kɩ nɩ Baŋa-Wɛ na pɛ DƖ nijoŋnǝ bam maŋɩ ba ta kʋlʋ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ba dɛɛn tagɩ ba wɩ, Wɛ wʋ́ vrɩ dɩbam dɩ́ dʋna jɩa nɩ, dɩ balʋ maama na culi dɩbam tɩn jɩa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","DƖ daa ta duri dɩbam kwǝ-nakwa yibwǝnǝ, ");
INSERT INTO xsm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","yɩ DƖ guli DƖ ni-ŋʋm dɩlʋ DƖ dɛɛn na goni dɩ dɩbam ko-nakwɩ Abraham tɩn woŋo. ");
INSERT INTO xsm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Wɛ dɛɛn wɩ, DƖ wʋ́ joŋi dɩbam dɩ́ dʋna jɩa nɩ DƖ yagɩ, yɩ dɩ́ daa bá kwarɩ fʋʋnɩ, sɩ dɩ́ taá tʋŋa nɩ DƖ wʋbʋŋa na lagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","DƖ maa wɩ, dɩ́ wʋ́ ta tɔgɩ-DƖ dɩ wʋ-poŋo, sɩ dɩ́ taá kɩ lanyɩranɩ DƖ yigǝ nɩ dɩbam ŋwɩa maama wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A bu, kʋ na yɩ nmʋ, baá bǝŋi nmʋ nɩ Baŋa-Wɛ nijoŋnu, bɛŋwaanɩ nmʋ wʋ́ da dɩ́ Yuutu wʋm yigǝ, sɩ n fɔgɩ n kwɛ o cwǝŋǝ kam, o na lagɩ o ba o da da tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nmʋ ta wʋ́ pa Wɛ nɔɔna bam lwarɩ sɩ DƖ wʋ́ vrɩ-ba, dɩ DƖ na wʋ́ yagɩ ba lwarɩm DƖ ma cɛ-ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wɛ maa jɩgɩ dɩbam ŋwaŋa lanyɩranɩ. DƖ ma wʋ́ pa pooni nuŋi wɛyuu dɩ ba dɩbam te dɩ nyɩɩna, nɩ wɩa na puli tɩtɩɩtɩ te tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sɩ dɩ pa nɔɔna balʋ na wʋ lim wʋnɩ tɩn dɩ balʋ na kwarɩ tʋʋnɩ tɩn na pooni, sɩ dɩ pa dɩ́ da yazurǝ cwǝŋǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakari bu Zan dɛɛn ma kɩ nɔɔnʋ yɩ o wʋbʋŋa bɩ lanyɩranɩ. O dɛɛn ma zʋʋrɩ kagʋa nɩ taan, sɩ kʋ vu kʋ yi dɛ dɩm o na wʋ́ nuŋi Yisɩrayɛlɩ tiinǝ bam tɩtarɩ nɩ o brɩ-ba Wɛ kwǝrǝ kam tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Maŋa kam kʋntʋ nɩ lʋgʋ kʋm pa-farʋ wʋlʋ yɩrɩ na yɩ Ogusi tɩn dɛɛn ma pa ni, sɩ ba ga o tɩʋ kʋm maama nɔn-biǝ bam sɩ o lwarɩ ba ni. ");
INSERT INTO xsm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Garɩm dɩntʋ maa yɩ pulim garɩm, yɩ dɩ kɩ maŋa kalʋ Kwirini dɩ dɛɛn na yɩ Siiri tɩɩnɩ dɩm yuutu tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Garɩm dɩm maŋa na yi tɩn, nɔɔnʋ maama ma vu o tɩtɩ tɩʋ sɩ ba ga-o. ");
INSERT INTO xsm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zʋzɛfʋ dɩ dɛɛn ma zaŋɩ o nuŋi Nazarɛtɩ kʋ na yɩ Galile tɩʋ tɩn. O ma vu Zude tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Betelɩhɛm, ba na lʋgɩ faŋa faŋa Pɛ Davidi mɛ tɩn. O dɛɛn ve daanɩ, o na yɩ Davidi dwi tu tɩn ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mari wʋlʋ ba na sɛ sɩ o taa yɩ Zʋzɛfʋ kaanɩ tɩn dɩ ma tɔgɩ dɩd-o o vu sɩ ba ga-ba. O dɛɛn jɩgɩ pugǝ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ba na wʋ Betelɩhɛm nɩ kʋntʋ tɩn, kʋ ma yi sɩ o lʋ bu wʋm. ");
INSERT INTO xsm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","O ma lʋ bǝkǝrǝ. Mʋ o dayigǝ bu. O ma kwe bu wʋm o ma gwaarʋ o kukwǝr-o o tiŋi vara wʋdiu dim jǝgǝ nɩ. Ba dɛɛn tigi vara digǝ nɩ mʋ, bɛŋwaanɩ vǝrǝ mʋ su tɩʋ kʋm maama, yɩ ba wʋ nɛ digǝ sɩ ba zʋ. ");
INSERT INTO xsm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nayɩra dɩ dɛɛn mʋ wʋ je sɩm kʋntʋ nɩ, gaa kʋm wʋnɩ, ba yɩrɩ ba vara tɩtɩɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Baŋa-Wɛ malɛka ma nuŋi ba yigǝ nɩ, yɩ Wɛ zǝŋi DƖ paarɩ-zulǝ yam pooni ba baŋa nɩ, yɩ dɩ nyɩɩnɩ dɩ gilimi-ba. Fʋʋnɩ ma tiini dɩ zʋ-ba zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Malɛka kam laan ma ta dɩ ba ka wɩ: «Á yɩ taá kwarɩ fʋʋnɩ. Kʋ yɩ wʋpolo taanɩ mʋ a tu sɩ a ta a brɩ abam, yɩ dɩ lagɩ dɩ pa nɔɔna maama wʋ mʋ poli zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bɛŋwaanɩ zɩm dɛ dɩm nɩ ba lʋgɩ abam Vɩrnʋ wʋm Davidi tɩʋ Betelɩhɛm nɩ. Wʋntʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn mʋ. Wʋm mʋ yɩ abam Yuutu. ");
INSERT INTO xsm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Á na ve á nii, á wʋ́ na bu-sɩsɩŋa ba na kukwǝri dɩ gwaarʋ ba tiŋi vara wʋdiu dim jǝgǝ nɩ. Mʋ kʋlʋ na wʋ́ brɩ abam nɩ kʋ yɩ cɩga mʋ a taga.» ");
INSERT INTO xsm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Malɛka kam na tagɩ kʋntʋ tɩn, Wɛ malɛsɩ kɔgɔ zanzan ma da sɩ nuŋi sɩ wǝli dɩ ka. Sɩ maama ma tee Wɛ sɩ wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Wɛ maŋɩ dɩ zulǝ wɛyuu nɩ. Kʋ daarɩ tɩga baŋa nɩ, balʋ na tigi Wɛ bɩcarɩ nɩ tɩn wʋ́ ta zʋʋrɩ lanyɩranɩ dɩ wʋ-zuru.» ");
INSERT INTO xsm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Malɛsɩ sɩm laan ma joori Wɛ-sɔŋɔ. Sɩ na kɛ tɩn, nayɩra bam ma ta daanɩ ba wɩ: «Ba-na dɩ́ vu Betelɩhɛm dɩ́ nii kʋlʋ na kɩ da yɩ Wɛ pa dɩ́ lwarɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ba ma zaŋɩ lɩla ba kɛ tɩʋ kʋm wʋ. Ba ma vu ba na Mari dɩdaanɩ Zʋzɛfʋ. Ba ma na bu wʋm na tigi vara wʋdiu dim jǝgǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ba na nɛ-o kʋntʋ tɩn, ba laan ma ta malɛka kam na maŋɩ ka ta bu wʋm taanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Balʋ maama na ni nayɩra bam na tagɩ kʋlʋ tɩn, kʋ ma sʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari dɩ na ni wǝǝnu tɩlʋ na kɩ tɩn, o maa bʋŋɩ-tɩ o wʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nayɩra bam ma joori ba viiri yɩ ba zuli Wɛ, yɩ ba tee-DƖ dɩ kʋlʋ ba na ni yɩ ba ta kwǝri ba na tɩn. Kʋ dɛɛn sɩɩnɩ kʋ kɩ nɩnɛɛnɩ malɛka kam na tagɩ ka brɩ-ba te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bu wʋm na yi da nana tɩn, ba ma pa sɩ ba go-o, nɩ Moyisi cullu tɩm na brɩ sɩ ba taa goni ba bǝkǝri te tɩn. Ba ma pa o yɩrɩ ba wɩ Zezi. Mʋ yɩrɩ dɩlʋ malɛka kam na maŋɩ ka pa-o, yɩ ba ta wʋ jaanɩ o pugǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maŋa kam laan ma yi sɩ Mari zarɩ o digiru tɩm sɩ o kwɛ o tɩtɩ dɩ Wɛ, sɩ kʋ tɔgɩ Wɛ cullu tɩlʋ DƖ na kɩ Moyisi jɩŋa nɩ na brɩ te tɩn. Zʋzɛfʋ dɩ Mari ma zaŋɩ ba ja bu wʋm ba vu Zeruzalɛm, sɩ ba vu ba zʋ Wɛ-di-kamunu kʋm wʋ, sɩ ba pa-o ba Yuutu Baŋa-Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ba kɩ kʋntʋ, bɛŋwaanɩ Wɛ ni dɩm na brɩ te tɩn mʋ kʋntʋ: «Bǝkǝrǝ kalʋ maama na yɩ o nu dayigǝ bu tɩn maŋɩ sɩ o taa yɩ Baŋa-Wɛ nyɩm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ba ma vu sɩ ba kaanɩ Baŋa-Wɛ, nɩ DƖ ni dɩm na brɩ te tɩn. Ba maŋɩ sɩ ba kwe kunkwǝnǝ bale mʋ ba ma kaanɩ-DƖ, naa kunkwǝn-puli sɩle ba ma kaanɩ-DƖ. ");
INSERT INTO xsm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nɔɔnʋ wʋdoŋ dɛɛn maa zʋʋrɩ Zeruzalɛm tɩʋ kʋm wʋnɩ, o yɩrɩ mʋ Simeyon. O yɩ nɔn-ŋʋm mʋ, yɩ o kwarɩ Wɛ lanyɩranɩ. O maa yɔɔrɩ o cǝgi dɛ dɩm Wɛ na wʋ́ ba DƖ joŋi Yisɩrayɛlɩ dwi tiinǝ bam tɩn. Wɛ Joro kʋm maa wʋ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kʋ dɛɛn ya pɛ o lwarɩ sɩ o bá tɩ, yɩ oó na Krisi wʋm dɩ́ Yuutu Baŋa-Wɛ na lagɩ DƖ tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wɛ Joro kʋm dɛɛn ma pa Simeyon zaŋɩ o vu o zʋ Wɛ-di-kamunu kʋm wʋ. O na wʋra kʋntʋ tɩn, Zezi nu dɩ o ko ma ja-o ba vu ba zʋ, sɩ ba kɩ kʋlʋ Wɛ ni dɩm na brɩ sɩ ba kɩ o ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ba na jaanɩ bu wʋm ba vu ba zʋ kʋntʋ tɩn, Simeyon ma vu o kwe-o o ziǝ, yɩ o daarɩ o zuli Wɛ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«A Yuutu Baŋa-Wɛ, lele kʋntʋ a nɛ kʋlʋ nmʋ dɛɛn na tagɩ nɩ aá na tɩn. A laan jɩgɩ wʋ-zuru. Kʋntʋ ŋwaanɩ nmʋ laan waɩ n paɩ amʋ na yɩ nmʋ tɩntʋŋnʋ tɩn na cwǝŋǝ, sɩ a yagɩ lʋgʋ baŋa sɩ a ba nmʋ te. ");
INSERT INTO xsm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Amʋ yi nɛ Vɩrnʋ wʋm nmʋ na tʋŋɩ sɩ o vrɩ nɔɔna lwarɩm wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nabiinǝ maama lʋgʋ baŋa nɩ wʋ́ lwarɩ nmʋ vrɩm dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kʋʋ́ ta nyɩ nɩ wɩa pooni mʋ te, sɩ kʋ pa dwi maama lwarɩ nmʋ cwǝŋǝ kam. Kʋʋ́ pa nmʋ tɩtɩ nɔɔna Yisɩrayɛlɩ dwi dɩm na zulǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeyon na tagɩ bu wʋm taanɩ kʋntʋ tɩn, o nu dɩ o ko maa yɩ yǝǝu dɩ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon daa ta ma ta dɩ ba o wɩ, Wɛ wʋ́ kɩ-ba lanyɩranɩ. O ma daarɩ o ta dɩ bu wʋm nu Mari o wɩ: «Nii, Wɛ sɩɩnɩ DƖ tʋŋɩ bu wʋm sɩ o ba o pa Yisɩrayɛlɩ tiinǝ zanzan mʋ tʋ tɩga nɩ, ba na tusi tɩn ŋwaanɩ. O nan daa ta wʋ́ pa ba zanzan zaŋɩ wɛɛnɩ. Wɛ wʋ́ pa o brɩ nɔɔna cɩga, yɩ ba zanzan ta wʋ́ vɩ-o. ");
INSERT INTO xsm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mʋ kʋ kuri nɔɔna zanzan wʋbʋŋa ya na sǝgi tɩn wʋ́ ba ya lwarɩ jaja. Kʋ daarɩ, kʋ na yɩ nmʋ tɩtɩ, n wʋ wʋ́ di nɩ sʋ-zɔɔ na zɔgɩ nɔɔnʋ bɩcɔŋɔ nɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Kaanɩ wʋdoŋ dɩ dɛɛn mʋ wʋra, o yɩrɩ mʋ Annɩ. O ko yɩrɩ mʋ Fanuyɛlɩ, o yɩ Asɛɛrɩ dwi tu mʋ. Annɩ dɛɛn ya zʋ barʋ. Ba maa wʋra daanɩ bɩna yarpɛ, yɩ o barʋ wʋm tɩ o daar-o. O daa ma wʋ zʋ barʋ. O kwɩn zanzan yɩ o jɩgɩ bɩna funɔnɔ-yana (84). O ma yɩ Wɛ nijoŋnu. O maa zʋʋrɩ Wɛ-di-kamunu kʋm wʋnɩ maŋa maama. Wɩa dɩ tɩtɩɩ maama o ma zuli Wɛ dɩ ni-vɔɔm dɩ Wɛ-loro. ");
INSERT INTO xsm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Maŋa kam kʋntʋ nɩ nɔ́ɔ, mʋ o ve o yi bu wʋm na wʋ mɛ tɩn. O ma kɩ Wɛ le, yɩ o wʋra o ŋɔɔnɩ bu wʋm woŋo o brɩ balʋ maama na wʋra yɩ ba cǝgi maŋa kalʋ Wɛ na wʋ́ ba DƖ vrɩ Yisɩrayɛlɩ tiinǝ bam lwarɩm wʋnɩ DƖ yagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zezi nu dɩ o ko dɛɛn ma kɩ kʋlʋ maama Baŋa-Wɛ cullu tɩm na brɩ sɩ ba kɩ tɩn. Ba na kɩ ba ti tɩn, ba ma joori ba vu Nazarɛtɩ na yɩ ba tɩtɩ tɩʋ yɩ kʋ wʋ Galile nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ba na joori ba vu ba wʋra tɩn, bu wʋm ma kɩ nɔɔnʋ dɩ ya-dɛɛra. O yiǝ ma pʋʋrɩ, Wɛ na kɩ-o yu-yoŋo tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Zwifǝ bam candiǝ kalʋ yɩrɩ na yɩ Pakɩ tɩn ma yi. Bɩnɩ maama wuu, Zezi nu dɩ o ko dɛɛn yǝni ba vu Zeruzalɛm mʋ, sɩ ba di candiǝ kam kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zezi dɛɛn na yi bɩna fugǝ-yale tɩn, o ma da dɩ ba o vu candiǝ kam, nɩnɛɛnɩ ba na yǝni ba ve ba di-ka te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba na di candiǝ kam ba ti tɩn, ba ma zaŋɩ ba maa joori sɔŋɔ. Zezi ma maŋɩ Zeruzalɛm nɩ, yɩ o nu dɩ o ko yǝri kʋ ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba ma vu taan dɛ dɩdwɩ, yɩ ba bʋŋɩ sɩ oó ta wʋ ba kɔgɔ kʋm wʋnɩ mʋ. Ba na wʋ nɛ-o ba tee nɩ tɩn, ba laan ma puli sɩ ba beeri o je ba nu-biǝ bam dɩ ba badonnǝ bam tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba ma wʋ nɛ-o. Ba ma joori ba vu Zeruzalɛm tɩʋ kʋm wʋ sɩ ba beer-o. ");
INSERT INTO xsm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ba ma beer-o taan da yatɔ, yɩ ba laan vu ba na-o Wɛ-di-kamunu kʋm wʋnɩ, o je karanyɩna tiinǝ bam tɩtarɩ nɩ. O na je da kʋntʋ tɩn, o maa cǝgi ba na brɩ te tɩn, yɩ o bwe-ba wǝǝnu zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Balʋ maama na je ba cǝgi o taanɩ dɩm tɩn maa yɩ yǝǝu, dɩ o na jɩgɩ yǝno dɩ taanɩ dɩm lǝrim te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zezi nu dɩ o ko na nɛ-o kʋntʋ tɩn, kʋ ma sɔɔrɩ-ba. O nu wʋm ma ta dɩd-o o wɩ: «A bu, bɛɛ mʋ yɩ n kɩ kʋntʋ dɩdaanɩ dɩbam? Ta n nii, amʋ dɩ nmʋ ko na tiini dɩ́ beeri nmʋ taan, yɩ liǝ dɩ wʋ-cɔgɔ jɩgɩ dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Zezi ma lǝri-ba o wɩ: «Bɛɛ mʋ yɩ abam karɩ á beeri amʋ je? Amʋ maŋɩ sɩ a taa wʋ a Ko sɔŋɔ kʋm nɩ mʋ. Abam yǝri kʋntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","O na tagɩ kʋntʋ tɩn, ba ma wʋ ni o taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zezi dɛɛn ma tɔgɩ dɩ ba o joori Nazarɛtɩ, yɩ o sɛ ba ni. O nu wʋm maa jɩgɩ wǝǝnu tɩm kʋntʋ maama o wʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zezi dɛɛn bɩra o yɩra wʋnɩ, yɩ o yǝno dɩ bɩra kʋ wǝli da, yɩ Baŋa-Wɛ dɩ nabiinǝ dɛɛn so-o. ");
INSERT INTO xsm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Kʋ dɛɛn na kɛ yɩ Tibɛɛrɩ yɩ lʋgʋ kʋm pa-farʋ kʋ maŋɩ dɩ bɩna fugǝ-yanu tɩn, mʋ Wɛ kwǝrǝ dɛɛn tu Zakari bu Zan te. Kantʋ maŋa kam nɩ Pɔnsɩ Pilatɩ mʋ yɩ Zude tɩɩnɩ dɩm gʋvɩrma tu. Erɔdɩ maa yɩ Galile tɩʋ kʋm yuutu, yɩ o zɩmbaarʋ Filipi dɩ yɩ Yituri dɩ Tɩrakoni tɩɩnɩ dɩm yuutu. Lizanɩa dɩ maa yɩ Abɩlɛnɩ tɩʋ yuutu. Kʋ daarɩ Annɩ dɩ Kayifu dɛɛn maa yɩ Wɛ kaanɩm yigǝ tiinǝ. Maŋa kam Wɛ kwǝrǝ kam na tu Zan te kʋntʋ tɩn, o wʋ kagʋa wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","O ma zaŋɩ o tʋlɩ Zʋrdɛn bugǝ ni tɩɩnɩ dɩm maama nɩ, yɩ o tɔɔlɩ Wɛ kwǝrǝ kam o brɩ nɔɔna o wɩ, ba maŋɩ sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, sɩ ba daarɩ ba pa o miisi-ba na wʋnɩ, sɩ Wɛ laan wʋ́ yagɩ ba lwarɩm DƖ ma cɛ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zan na tɔɔlɩ Wɛ kwǝrǝ kam kʋntʋ tɩn, kʋ sɩɩnɩ kʋ kɩ nɩnɛɛnɩ Wɛ nijoŋnu Ezayi dɛɛn na pʋpʋnɩ o tɔnɔ kʋm nɩ o ta te tɩn. Faŋa faŋa tɩn, o dɛɛn tagɩ o wɩ: «Nɔɔnʋ mʋ wʋ kagʋa wʋnɩ o tɔɔlɩ kwǝrǝ o wɩ: ‹Zaŋɩ-na á fɔgɩ á kwɛ dɩ́ Yuutu wʋm cwǝŋǝ kam, o na lagɩ o ba o tɔgɩ da tɩn. Pa-na cwe sɩlʋ o na lagɩ o da tɩn fɔgɩ sɩ yɔɔrɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Je sɩlʋ maama na jɩgɩ gwǝǝnu tɩn maŋɩ sɩ tɩ suuri mʋ, dɩ je sɩlʋ maama na jɩgɩ zwǝǝnu dɩ pweeru tɩn maŋɩ sɩ tɩ guri mʋ tɩ daarɩ cwǝŋǝ kam. Cwe sɩlʋ maama na gugwǝli tɩn maŋɩ sɩ sɩ fɔgɩ sɩ yɔɔrɩ mʋ. Cwe sɩlʋ maama na ba lana tɩn maŋɩ sɩ sɩ fɔgɩ sɩ kwɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nabiinǝ maama laan wʋ́ na Wɛ na wʋ́ vrɩ nɔɔna lwarɩm wʋnɩ te tɩn.› » Mʋ Ezayi na ŋɔɔnɩ Zan taanɩ faŋa faŋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɔɔna zanzan dɛɛn ma zaŋɩ ba vu Zan te ba pa o miisi-ba na wʋnɩ Wɛ ŋwaanɩ. Ba na tu o te kʋntʋ tɩn, o ma ta dɩ ba o wɩ: «Abam nyɩ dɩ bɩsankwɩ-dwǝ. Wɔɔ mʋ brɩ abam sɩ á kwaanɩ á lu cam dɩlʋ Wɛ na lagɩ DƖ pa nabiinǝ na tɩn wʋnɩ? ");
INSERT INTO xsm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Abam nan maŋɩ sɩ á kɩ kǝnǝ yalʋ na wʋ́ brɩ nɩ á lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩn mʋ. Abam nan yɩ garɩ á bʋŋɩ á pa á tɩtɩ nɩ, abam na yɩ Abraham dwi tiinǝ tɩn, á daa wʋ maŋɩ sɩ á lǝni á wʋrʋ. Wɛ na laga, DƖ wʋ́ wanɩ DƖ pa kandwa yantʋ lǝni ya ji Abraham dwi tiinǝ. ");
INSERT INTO xsm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nɔɔnʋ nan maŋɩ o jɩgɩ dooru o jɩŋa nɩ, sɩ o ta maa goni tweeru tɩm o dɩ tɩga nɩ. Tiu kʋlʋ maama na ba lǝri bu-ŋʋna tɩn, o maŋɩ sɩ o go-kʋ mʋ o dɩ mini nɩ sɩ kʋ di. Mʋ Wɛ dɩ na lagɩ DƖ kɩ nɔn-balwaarʋ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zan na tagɩ kʋntʋ tɩn, nɔn-kɔgɔ kʋm ma bwe-o ba wɩ: «Dɩ́ nan wʋ́ kɩ bɛɛ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O ma lǝri-ba o wɩ: «Abam balʋ na jɩgɩ gwaarʋ tɩle tɩle tɩn, á maŋɩ sɩ á kwe dɩdʋa mʋ á pa balʋ na ba jɩgɩ kʋlʋkʋlʋ tɩn. Kʋ daarɩ, abam balʋ na jɩgɩ wʋdiiru tɩn, á dɩ maŋɩ sɩ á kwe-tɩ á maŋɩ á pa nɔɔna balʋ na ba jɩgɩ ba di tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lampo-joŋnǝ dɩ dɛɛn ma ba sɩ Zan miisi-ba na wʋnɩ. Ba ma bwe-o ba wɩ: «Karanyɩna, bɛɛ mʋ dɩbam nan wʋ́ kɩ?» ");
INSERT INTO xsm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O ma lǝri-ba o wɩ: «Á wʋ maŋɩ sɩ á la nɔɔnʋ yuu, sɩ kʋ dwǝni á na wʋ́ joŋ-o te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pamaŋna dɩ daa ma ba ba bwe-o ba wɩ: «Dɩbam nan wʋ́ kɩ bɛɛ mʋ?» O ma lǝri-ba o wɩ: «Abam wʋ maŋɩ sɩ á vrɩ nɔɔn-nɔɔnʋ sǝbu dɩ dam naa á ganɩ-ba á joŋi. Kʋ daarɩ, á taá jɩgɩ wʋpolo dɩ á ŋwɩɩrʋ tɩm na maŋɩ tɩ yɩ te dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nɔɔna dɛɛn maa jɩgɩ tɩɩna dɩ Wɛ lanyɩranɩ, yɩ ba maama ma bwɛ ba wʋnɩ sɩ ba lwarɩ Zan na yɩ wʋlʋ tɩn. Ba maa wɩ: «Wʋntʋ mʋ wʋ́ ta yɩ Krisi wʋm Wɛ na lagɩ DƖ tʋŋ-o sɩ o ba tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ba maama na bʋŋɩ kʋntʋ tɩn, Zan ma ta dɩ ba o wɩ: «Kʋ na yɩ amʋ, a miisi abam na wʋnɩ mʋ. Kʋ daarɩ wʋlʋ na tiini o dwe amʋ tɩn lagɩ o saŋɩ amʋ kwaga o ba. A wʋ maŋɩ sɩ a bwǝli o nɛ natra a pa-o. Wʋntʋ nan wʋ́ miisi abam Wɛ Joro dɩ mini wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wʋntʋ nan ze zʋŋ-kɔgɔ mʋ sɩ o ma caarɩ o mɩna o pɛ o kɩ o tulǝ nɩ, sɩ o daarɩ mɩn-swaanʋ tɩm o zwɛ dɩ mini dɩlʋ na ba di dɩ dwe tɩn. Mʋ o na lagɩ o pɔɔrɩ nɔɔna daanɩ o kɩ-ba te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mʋ tɩntʋ wǝǝnu tɩm dɩ wǝǝnu dwi tǝri tǝri mʋ Zan dɛɛn ma o brɩ nɔn-kɔgɔ kʋm Wɛ kwǝr-ywǝŋǝ kam. ");
INSERT INTO xsm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","O dɛɛn ma ta dɩ Erɔdɩ wʋlʋ na yɩ Galile yuutu tɩn, nɩ o kɩ kʋlʋ na wʋ maŋɩ tɩn dɩ o zɩmbaarʋ kaanɩ Erɔdɩadɩ. O daa ta ma kaan-o dɩ wo-balwaarʋ tɩlʋ maama o na maŋɩ o kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erɔdɩ ma ja Zan o kɩ pɩɩna digǝ nɩ. Kʋntʋ tɩn, o daa ta kɩ wo-balɔrɔ mʋ o wǝli da. ");
INSERT INTO xsm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nɔn-kɔgɔ kʋm dɛɛn na tu Zan te sɩ o miisi-ba na wʋnɩ tɩn, Zezi dɩ dɛɛn ma ba o te, sɩ o pa Zan miis-o dɩ. Zezi na miisi na kʋntʋ tɩn, o maa wʋra o warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wɛyuu laan ma puri, yɩ Wɛ Joro kʋm tɔgɩ da kʋ tu o baŋa, yɩ kʋ nyɩ dɩ kunkwǝŋǝ te. Kwǝrǝ laan ma ŋɔɔnɩ wɛyuu nɩ ka wɩ: «Nmʋ mʋ yɩ amʋ bu-dʋa a na soe dɩ a wʋ maama. Amʋ tiini a jɩgɩ wʋpolo dɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Maŋa kam Zezi na puli sɩ o brɩ nɔɔna Wɛ cwǝŋǝ kam tɩn, o dɛɛn yɩ nɩnɛɛnɩ bɩna fiintɔ mʋ te. Nɔɔna dɛɛn bʋŋɩ ba wɩ, o yɩ Zʋzɛfʋ bu mʋ. Zʋzɛfʋ ko dɛɛn mʋ yɩ Eli. ");
INSERT INTO xsm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ko dɛɛn mʋ yɩ Matatɩ. Matatɩ ko dɛɛn maa yɩ Leevi. Leevi ko dɛɛn maa yɩ Meliki. Meliki ko dɛɛn maa yɩ Zanayi. Zanayi ko dɛɛn maa yɩ Zʋzɛfʋ. ");
INSERT INTO xsm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zʋzɛfʋ ko dɛɛn maa yɩ Matatɩa. Matatɩa ko dɛɛn maa yɩ Amɔsɩ. Amɔsɩ ko dɛɛn maa yɩ Nawum. Nawum ko dɛɛn maa yɩ Esili. Esili ko dɛɛn maa yɩ Nagayi. ");
INSERT INTO xsm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi ko dɛɛn maa yɩ Maatɩ. Maatɩ ko dɛɛn maa yɩ Matatɩa. Matatɩa ko dɛɛn maa yɩ Semeyi. Semeyi ko dɛɛn maa yɩ Zozeki. Zozeki ko dɛɛn maa yɩ Zoda. ");
INSERT INTO xsm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda ko dɛɛn maa yɩ Zʋanan. Zʋanan ko dɛɛn maa yɩ Risa. Risa ko dɛɛn maa yɩ Zorobabɛlɩ. Zorobabɛlɩ ko dɛɛn maa yɩ Salatɩyɛlɩ. Salatɩyɛlɩ ko dɛɛn maa yɩ Neri. ");
INSERT INTO xsm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ko dɛɛn maa yɩ Meliki. Meliki ko dɛɛn maa yɩ Adi. Adi ko dɛɛn maa yɩ Kosam. Kosam ko dɛɛn maa yɩ Elimadam. Elimadam ko dɛɛn maa yɩ Eri. ");
INSERT INTO xsm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ko dɛɛn maa yɩ Zozwe. Zozwe ko dɛɛn maa yɩ Elizɛɛrɩ. Elizɛɛrɩ ko dɛɛn maa yɩ Zorim. Zorim ko dɛɛn maa yɩ Matatɩ. Matatɩ ko dɛɛn maa yɩ Leevi. ");
INSERT INTO xsm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leevi ko dɛɛn maa yɩ Simeyon. Simeyon ko dɛɛn maa yɩ Zuda. Zuda ko dɛɛn maa yɩ Zʋzɛfʋ. Zʋzɛfʋ ko dɛɛn maa yɩ Zʋnam. Zʋnam ko dɛɛn maa yɩ Eliyakɩm. ");
INSERT INTO xsm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakɩm ko dɛɛn maa yɩ Mɩlɩa. Mɩlɩa ko dɛɛn maa yɩ Mɩnna. Mɩnna ko dɛɛn maa yɩ Matata. Matata ko dɛɛn maa yɩ Natan. Natan ko dɛɛn maa yɩ Davidi. ");
INSERT INTO xsm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi ko dɛɛn maa yɩ Zese. Zese ko dɛɛn maa yɩ Zʋbɛdɩ. Zʋbɛdɩ ko dɛɛn maa yɩ Bʋazɩ. Bʋazɩ ko dɛɛn maa yɩ Sala. Sala ko dɛɛn maa yɩ Naasɔn. ");
INSERT INTO xsm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasɔn ko dɛɛn maa yɩ Amɩnadabɩ. Amɩnadabɩ ko dɛɛn maa yɩ Adɩmɩnɩ. Adɩmɩnɩ ko dɛɛn maa yɩ Arnɩ. Arnɩ ko dɛɛn maa yɩ Esrɔm. Esrɔm ko dɛɛn maa yɩ Farɛsɩ. Farɛsɩ ko dɛɛn maa yɩ Zuda. ");
INSERT INTO xsm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda ko dɛɛn maa yɩ Zakɔbɩ. Zakɔbɩ ko dɛɛn maa yɩ Yizakɩ. Yizakɩ ko dɛɛn maa yɩ Abraham. Abraham ko dɛɛn maa yɩ Tara. Tara ko dɛɛn maa yɩ Nakɔɔrɩ. ");
INSERT INTO xsm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔɔrɩ ko dɛɛn maa yɩ Seruki. Seruki ko dɛɛn maa yɩ Rago. Rago ko dɛɛn maa yɩ Falɛkɩ. Falɛkɩ ko dɛɛn maa yɩ Ebɛɛrɩ. Ebɛɛrɩ ko dɛɛn maa yɩ Sala. ");
INSERT INTO xsm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ko dɛɛn maa yɩ Kayɩnam. Kayɩnam ko dɛɛn maa yɩ Arɩfasadɩ. Arɩfasadɩ ko dɛɛn maa yɩ Sɛm. Sɛm ko dɛɛn maa yɩ Nowe. Nowe ko dɛɛn maa yɩ Lamɛkɩ. ");
INSERT INTO xsm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛkɩ ko dɛɛn maa yɩ Matusala. Matusala ko dɛɛn maa yɩ Enɔkɩ. Enɔkɩ ko dɛɛn maa yɩ Zarɛdɩ. Zarɛdɩ ko dɛɛn maa yɩ Malɩlɩyɛlɩ. Malɩlɩyɛlɩ ko dɛɛn maa yɩ Kayɩnan. ");
INSERT INTO xsm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayɩnan ko dɛɛn maa yɩ Enɔsɩ. Enɔsɩ ko dɛɛn maa yɩ Sɛtɩ. Sɛtɩ ko dɛɛn maa yɩ Adam. Adam maa yɩ wʋlʋ Wɛ na mɔɔnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zezi dɛɛn ma nuŋi Zʋrdɛn bugǝ kam ni nɩ o maa kɛa. Wɛ Joro kʋm maa tɔg-o dɩ dam. Kʋ ma ja-o kʋ vu kagʋa wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","O maa wʋra taan da fiinna. O na wʋra tɩn mʋ sʋtaanɩ tu o te, sɩ dɩ sʋg-o sɩ o ya kɩ o cɔgɩ. Maŋa kam kʋntʋ nɩ o ya ba di kʋlʋkʋlʋ. Da fiinna yam na kɛ tɩn, kana maa jɩg-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sʋtaanɩ laan ma ba dɩ ta dɩd-o dɩ wɩ: «Nmʋ na sɩɩnɩ n yɩ Baŋa-Wɛ Bu, sɩ n ta dɩ kandwɛ dɩntʋ sɩ dɩ ji wʋdiu sɩ n di.» ");
INSERT INTO xsm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zezi ma lǝri-dɩ o wɩ: «Kʋ nan pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kʋ daɩ wʋdiu yɩranɩ mʋ paɩ nabiinu ŋwɩ.› » ");
INSERT INTO xsm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sʋtaanɩ daa ma ja-o dɩ ja vu dɩ di piu kʋlʋ na dwara tɩn yuu. Dɩ laan ma brɩ-o lʋgʋ baŋa tɩɩnɩ dɩm maama yibʋgɩsa wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dɩ daa ma ta dɩ wɩ: «Wo-laarʋ tɩntʋ maama yɩ amʋ nyɩm mʋ. A nan wʋ́ wanɩ a kwe-tɩ a pa wʋlʋ maama a na lagɩ tɩn. Amʋ wʋ́ pa n di dam tɩ maama baŋa nɩ, sɩ n ta n te zulǝ nɔɔna maama tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nmʋ na sɛ n kuni doonǝ n zuli-nɩ, wǝǝnu tɩntʋ maama wʋ́ ta yɩ nmʋ nyɩm.» ");
INSERT INTO xsm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Zezi ma lǝri-dɩ o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kʋ yɩ n Yuutu Baŋa-Wɛ yɩranɩ mʋ n maŋɩ sɩ n kuni doonǝ n zuli, sɩ n kɩ DƖ wʋbʋŋa na lagɩ te tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sʋtaanɩ daa ma kwe-o dɩ ja vu Zeruzalɛm. Dɩ ma ja-o dɩ ja vu dɩ di Wɛ-di-kamunu kʋm yuu mɛ na dwara tɩn dɩ zɩg-o da, yɩ dɩ wɩ: «Nmʋ na yɩ Baŋa-Wɛ Bu, sɩ n faŋɩ n cu tɩga nɩ sɩ dɩ́ nii, ");
INSERT INTO xsm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Wɛ wʋ́ ta DƖ malɛsɩ, sɩ sɩ taa nii nmʋ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","DƖ wʋ́ pa sɩ ba sɩ ma sɩ jɩa sɩ lwǝri-m, sɩ n yɩ tʋ tɩga nɩ n magɩ n naga dɩ kandwɛ.› » ");
INSERT INTO xsm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Zezi laan ma lǝri o wɩ: «Kʋ ta pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Yɩ zaŋɩ n maŋɩ n Yuutu Baŋa-Wɛ n nii.› » ");
INSERT INTO xsm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sʋtaanɩ laan na maŋɩ Zezi wǝǝnu maama wʋnɩ dɩ ga tɩn, dɩ ma yag-o sɩ dɩ daa beeri maŋa kadoŋ. ");
INSERT INTO xsm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Zezi laan ma joori o vu Galile, yɩ Wɛ Joro kʋm dam wʋ o tee nɩ. Nɔɔna balʋ maama na zʋʋrɩ je sɩm kʋntʋ nɩ tɩn ma ni o ŋwa. ");
INSERT INTO xsm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O maa yǝni o zʋ Zwifǝ bam Wɛ-di sɩm o brɩ-ba Wɛ taanɩ. Nɔɔna maama ma zul-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zezi dɛɛn ma vu o yi Nazarɛtɩ, mʋ tɩʋ kʋlʋ o na kɩ nɔɔnʋ da tɩn. Zwifǝ bam siun dɛ maama, o dɛɛn maa zʋʋrɩ ba Wɛ-digǝ kam. Ba siun dɛ dɩdʋa na yi tɩn, o ma vu da. O na zʋ da tɩn, o ma zaŋɩ wɛɛnɩ sɩ o karɩmɩ Wɛ tɔnɔ o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ba ma kwe tɔnɔ kʋlʋ Wɛ nijoŋnu Ezayi na pʋpʋnɩ faŋa faŋa tɩn ba pa-o. O ma puri-kʋ o karɩma, yɩ o na mɛ seeni kʋ na pʋpʋnɩ kʋ wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Yuutu Baŋa-Wɛ Joro kʋm wʋ amʋ tee nɩ. DƖ ma kuri-nɩ yɩ DƖ pa-nɩ dam, sɩ a tɔɔlɩ DƖ kwǝr-ywǝŋǝ kam a brɩ yinigǝ tiinǝ. DƖ tʋŋɩ amʋ sɩ a ganɩ nɔɔna balʋ wʋrʋ na cɔgɩ tɩn. Sɩ a tɔɔlɩ DƖ kwǝrǝ kam dɩ balʋ na wʋ gambɛɛm wʋnɩ tɩn, sɩ ba na vrɩm, sɩ a daarɩ a brɩ lilwǝ nɩ ba yiǝ wʋ́ ba ya puri. DƖ daa ta ma tʋŋɩ-nɩ sɩ a vrɩ nɔɔna balʋ ba na bɛɛsɩ tɩn, sɩ ba na siun, ");
INSERT INTO xsm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","sɩ a daarɩ a pa nɔɔna lwarɩ sɩ maŋa kam yiǝ, sɩ Baŋa-Wɛ laan ba DƖ vrɩ DƖ nɔɔna bam lwarɩm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zezi na karɩmɩ o ti tɩn, o laan ma pu tɔnɔ kʋm, yɩ o kwe o pa ba Wɛ-digǝ kam tɩntʋŋnʋ. O ma jǝni sɩ o brɩ-ba. Nɔɔna bam maama ma lo yiǝ o baŋa nɩ yɩ ba cǝg-o. ");
INSERT INTO xsm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","O ma ta o wɩ: «Zɩm dɛ dɩm nɩ abam na ni Wɛ tɔnɔ kʋm na brɩ kʋlʋ tɩn kɩ á yibiyǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ba maama ma zul-o yɩ ba wɩ: «O taanɩ dɩm lamma.» O kwǝrǝ kam na ywǝmmǝ tɩn, kʋ kɩ-ba yǝǝu. Ba daa ta ma wɩ: «Kʋ daɩ Zʋzɛfʋ bu mʋ tɩntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","O ma ta dɩ ba o wɩ: «A nan maŋɩ a ye nɩ abam wʋ́ ŋɔɔnɩ sɩsɩɩna dɩ amʋ nɩnɛɛnɩ: ‹Nmʋ wʋlʋ na pɛ nɔɔna na yazurǝ tɩn, sɩ n zǝni n tɩtɩ!› Abam daa ta wʋ́ ta á wɩ: ‹Dɩ́ ni wǝǝnu tɩlʋ nmʋ na kɩ Kapɛrnawum nɩ tɩn ŋwa. Nan daa n kɩ kʋntʋ doŋ n tɩtɩ tɩʋ kʋm nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","O daa ta ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, Baŋa-Wɛ nijoŋnu bá na zulǝ o tɩtɩ tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kʋ sɩɩnɩ kʋ yɩ cɩga mʋ, sɩ maŋa kalʋ Wɛ nijoŋnu Eli dɛɛn na wʋra tɩn, dʋa dɛɛn tu ka zɩgɩ ka wʋ nɩgɩ taan bɩna yatɔ dɩ canɩ sɩrdʋ mʋ. Kʋntʋ ŋwaanɩ kana dɛɛn maa jɩgɩ lʋgʋ kʋm maama. Kadǝnǝ maa daga zanzan Yisɩrayɛlɩ tiinǝ bam wʋnɩ, ");
INSERT INTO xsm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","yɩ Wɛ nan wʋ tʋŋɩ Eli sɩ o vu ba wʋlʋwʋlʋ te. Wɛ dɛɛn tʋŋ-o kadǝm wʋdoŋ tee nɩ mʋ, o na zʋʋrɩ Sarɛpɩta tɩʋ wʋnɩ, kʋ na yɩ Sidɔn tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Woŋo kʋlʋ ta na wǝli da tɩn, maŋa kalʋ Wɛ nijoŋnu Elize dɛɛn na wʋra tɩn, nanywaanʋ zanzan dɛɛn wʋ Yisɩrayɛlɩ tɩʋ kʋm nɩ. Ba wʋlʋwʋlʋ dɩ dɛɛn nan wʋ nɛ yazurǝ ba wʋnɩ. Elize dɛɛn pɛ Naaman yɩranɩ mʋ na yazurǝ, yɩ wʋntʋ nuŋi Siiri tɩʋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nɔɔna balʋ maama na wʋ Wɛ-digǝ kam nɩ tɩn na ni Zezi na tagɩ-ba te tɩn, ba bana ma zaŋɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ba ma zaŋɩ ba zǝl-o ba pa o nuŋi tɩʋ kʋm wʋnɩ. Tɩʋ kʋm wʋ piu yuu nɩ mʋ. Ba ma ja-o ba vu jǝgǝ kalʋ na luunǝ dɩ tɩga tɩn, sɩ ba yig-o ba dɩ tɩga nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba maa warɩ. Zezi ma pipiri o vu o tɔgɩ ba tɩtarɩ o nuŋi o maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zezi dɛɛn ma vu Galile tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Kapɛrnawum. Zwifǝ bam siun dɛ ma yi. O ma vu o zʋ ba Wɛ-digǝ kam sɩ o brɩ nɔɔna bam Wɛ taanɩ da. ");
INSERT INTO xsm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","O na brɩ-ba tɩn, ba maa tiini ba yɩ yǝǝu dɩ o zaasɩm dɩm, o ni-taanɩ dɩm na jɩgɩ dam tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nɔɔnʋ wʋdoŋ dɛɛn maa wʋ ba Wɛ-digǝ kam wʋnɩ yɩ cicirǝ jɩg-o. ");
INSERT INTO xsm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","O ma kaasɩ dɩ kwǝr-dɩa yɩ o wɩ: «Aa, Zezi, Nazarɛtɩ tu, bɛɛ mʋ n lagɩ dɩbam tee nɩ? Nmʋ tu sɩ n cɔgɩ dɩbam dwi mʋ na? A ye nmʋ na yɩ wʋlʋ. Nmʋ yɩ Wʋ-poŋo Tu wʋlʋ Wɛ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Zezi ma kaanɩ cicirǝ kam o wɩ: «Cǝgi sɔɔ, sɩ n nuŋi n daarɩ baarʋ wʋm.» Cicirǝ kam na ni kʋntʋ tɩn, ka ma yigi nɔɔnʋ wʋm ka dɩ tɩga nɩ. Ka laan ma yag-o yɩ ka wʋ kɩ-o kʋlʋkʋlʋ. Kʋntʋ kɩ nɔɔna bam maama yiǝ nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kʋ ma sʋ-ba lanyɩranɩ. Ba maama ma ŋɔɔnɩ daanɩ ba wɩ: «Bɩtara kantʋ yɩ bɩtarɩ dwi dɔɔ mʋ? Nii o na maɩ o dam o tɛ dɩ ciciri sɩm, yɩ sɩ sɛ o ni yɩ sɩ viirǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɔɔna balʋ maama na zʋʋrɩ je sɩm kʋntʋ nɩ tɩn laan ma ni Zezi ŋwa. ");
INSERT INTO xsm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Zezi dɛɛn ma nuŋi Wɛ-digǝ kam wʋnɩ. O ma vu Simɔn-ba sɔŋɔ. O na yi da tɩn dɩ paa magɩ Simɔn tɩnkaanɩ kʋ cana. Ba ma loori Zezi sɩ o zǝni kaanɩ wʋm sɩ o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O ma vu o tiiri kaanɩ wʋm baŋa nɩ. O ma ta dɩ paa kam o wɩ, ka yag-o. Ka ma sɩɩnɩ ka yag-o. O laan ma zaŋɩ lɩla, yɩ o kɩ wʋdiu o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kʋ na tu kʋ yi wa-zʋʋrɩ maŋa nɩ tɩn, ba ma ja nɔɔna dɩ ba yawɩɩrʋ dwi tǝri tǝri ba ba Zezi te, sɩ o pa ba na yazurǝ. O ma daŋɩ o jɩa ba dɩdʋa dɩdʋa baŋa nɩ o pa ba maama na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kʋlʋ na wǝli da tɩn, ciciri dɩ ma nuŋi sɩ yagɩ nɔɔna zanzan sɩ ya na jɩgɩ sɩ yaara tɩn yɩra. Sɩ maa yǝni sɩ kaasa sɩ wɩ: «Nmʋ yɩ Baŋa-Wɛ Bu mʋ.» Sɩ na ye nɩ o sɩɩnɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, o ma kaanɩ-sɩ, sɩ sɩ yɩ taa ŋɔɔnɩ o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tɩga na pʋʋrɩ tɩtɩɩtɩ tɩn, Zezi daa ma nuŋi o vu je sɩlʋ nɔɔn-nɔɔnʋ na tǝrǝ tɩn. Tɩʋ kʋm nɔɔna bam ma zaŋɩ ba nuŋi sɩ ba beeri o je. Ba laan ma na-o yɩ ba vu o te. Ba ma kwaanɩ sɩ ba ja-o, sɩ o yɩ viiri o yagɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","O ma ta dɩ ba o wɩ: «A nan maŋɩ sɩ a vu a tʋlɩ tɩɩnɩ dɩdɩm dɩm mʋ, a tɔɔlɩ kwǝr-ywǝŋǝ kam a brɩ-ba Wɛ na lagɩ DƖ di paarɩ tɩte nɔɔna tɩtarɩ nɩ tɩn. Kʋ yɩ kʋntʋ ŋwaanɩ mʋ Wɛ tʋŋɩ-nɩ nabiinǝ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","O laan ma tʋlɩ Zwifǝ bam tɩɩnɩ dɩm nɩ. O maa yǝni o zʋ ba Wɛ-di sɩm sɩ o taa tɔɔlɩ Wɛ kwǝrǝ kam. ");
INSERT INTO xsm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dɛ dɩdwɩ mʋ Zezi dɛɛn ve o zɩgɩ nɩnɩʋ kʋdoŋ ni nɩ, kʋ yɩrɩ mʋ Zenezarɛtɩ. O na zɩgɩ da kʋntʋ tɩn, nɔɔna ma ba o te sɩ ba taa cǝgi Wɛ kwǝrǝ kam. Ba ma yigi daanɩ sɩ ba twɛ Zezi. ");
INSERT INTO xsm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O ma na nabwǝǝru tɩle tɩ tigi nɩnɩʋ kʋm ni nɩ, kalǝŋ-jara na yagɩ-tɩ yɩ ba wʋra ba zarɩ ba bʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Naboro dɩdʋ kʋm yɩ Simɔn nyɩm mʋ. Zezi ma zʋ kʋ wʋnɩ. O ma ta dɩdaanɩ Simɔn o wɩ: «Co boro kʋm n ja n vu yigǝ fɩnfɩɩn n pa-nɩ.» O na cogǝ o ja o yi yigǝ tɩn, Zezi laan ma je naboro kʋm wʋnɩ o tɔɔlɩ Wɛ kwǝrǝ o brɩ nɔn-kɔgɔ kʋm. ");
INSERT INTO xsm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","O na brɩ-ba o ti tɩn, o ma ta dɩ Simɔn o wɩ: «Co boro kʋm n ja n vu na-luŋǝ kam je, sɩ abam dɩ á bʋrɩ sɩm na bam kuri nɩ á ma ja kale.» ");
INSERT INTO xsm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","O ma lǝr-o o wɩ: «A Yuutu, dɩbam maŋɩ dɩ́ dɩ bʋrɩ sɩm taan dɩ́ pʋʋrɩ tɩga, yɩ dɩ́ wʋ nɛ kʋlʋkʋlʋ. Nmʋ nan na wɩ, dɩ́ daa joori dɩ́ dɩ tɩn, dɩ́ wʋ́ dɩ-sɩ sɩ dɩ́ nii.» ");
INSERT INTO xsm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ba ma vu ba yi na bam tɩtarɩ, yɩ ba dɩ bʋrɩ sɩm da ba ja kale zanzan. Kale sɩm maa tiini sɩ daga zanzan, yɩ kʋ pa bʋrɩ sɩm lagɩ sɩ kaarɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ba ma yɩgɩsɩ jɩa ba bǝŋi ba donnǝ bam naboro kʋkʋm kʋm wʋnɩ, sɩ ba ba ba wǝli-ba. Bantʋ dɩ ma ja ba boro kʋm ba vu ba zǝni-ba. Bwǝǝru tɩm tɩle maama ma su dɩ kale. Tɩ ma ga fɩnfɩɩn sɩ tɩ miisi na bam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔn wʋlʋ yɩrɩ dɩdoŋ na yɩ Pɩyɛɛrɩ tɩn na nɛ kʋlʋ na kɩ tɩn, o ma vu o kuni doonǝ Zezi yigǝ nɩ yɩ o wɩ: «A Yuutu, fɔɔrɩ a tee nɩ, sɩ a yɩ lwarɩm tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ba na jaanɩ kale zanzan tɩn ŋwaanɩ mʋ fʋʋnɩ zʋ Simɔn dɩdaanɩ nɔɔna balʋ na wʋ o tee nɩ tɩn. Kʋntʋ mʋ te Simɔn tagɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Fʋʋnɩ dɩm dɩ dɛɛn zʋ Zebede biǝ balʋ na tɔgɩ ba wʋra tɩn. Ba dɩdʋa yɩrɩ mʋ Zakɩ, o nyaanɩ yɩrɩ mʋ Zan. Bantʋ dɛɛn yǝni ba tɔgɩ dɩ Simɔn mʋ ba tʋŋa. Zezi daa ma ta dɩ Simɔn o wɩ: «Yɩ ta n kwarɩ fʋʋnɩ. Kʋ na zɩgɩ zɩm dɛ dɩm nɩ sɩ kʋ taa ve tɩn, nmʋ laan wʋ́ ta n beeri nɔɔna mʋ n pa-nɩ sɩ ba da amʋ kwaga, nɩ nmʋ ya na yǝni n jaanɩ kale te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ba ma joori ba ja nabwǝǝru tɩm ba nuŋi ba tiŋi buburu kʋm ni nɩ. Ba na kɩ kʋntʋ ba ti tɩn, ba yagɩ ba wǝǝnu maama, yɩ ba laan daarɩ ba tɔgɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dɛ dɩdwɩ mʋ Zezi ve tɩʋ kʋdoŋ. Baarʋ wʋdoŋ mʋ wʋra o na yɩ nanyɔŋɔ. O yawɩʋ kʋm dɛɛn zʋ o yɩra zanzan. O na nɛ Zezi tɩn, o ma vu o te o tʋ o yigǝ nɩ, yɩ o loor-o o wɩ: «Amʋ tu, nmʋ na laga, nmʋ wʋ́ wanɩ n pa a na yazurǝ a ji lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zezi ma sɛ. O ma twɩ o jɩŋa o dwe-o o wɩ: «Ɛɛn, a laga. Zaŋɩ dɩ yazurǝ sɩ n ji lanyɩranɩ.» O na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ yawɩʋ kʋm je nɔɔnʋ wʋm yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zezi ma kaan-o o wɩ: «Yɩ zaŋɩ n ta kʋlʋ na kɩ tɩn n brɩ nɔɔn-nɔɔnʋ. Nan yɔɔrɩ n vu kaanɩm tu wʋm te, sɩ n pa o nii n yɩra yam, sɩ n daarɩ n kwe wǝǝnu tɩlʋ Moyisi cullu tɩm na brɩ nɩ tɩ maŋɩ tɩn n pa-o, sɩ o ma kaanɩ Baŋa-Wɛ. Kʋntʋ mʋ wʋ́ brɩ nɔɔna nɩ n yawɩʋ kʋm sɩɩnɩ kʋ je.» ");
INSERT INTO xsm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nan dɩ kʋ dɩ, nɔɔna zanzan dɛɛn ni Zezi ŋwa je maama. Kʋntʋ ŋwaanɩ mʋ nɔn-kɔgɔ zanzan maa ve o te sɩ ba taa cǝgi o ni-taanɩ dɩm, sɩ ba daarɩ ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","O dɛɛn yǝni o ve mɛ seeni nɔɔn-nɔɔnʋ na tǝrǝ tɩn mʋ o warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dɛ dɩdʋa mʋ Zezi dɛɛn wʋra o brɩ nɔɔna Wɛ taanɩ. Ba badaara yɩ Farizɩan tiinǝ mʋ dɩdaanɩ Wɛ cullu karanyɩna tiinǝ. Ba dɛɛn nuŋi tɩɩnɩ dwi tǝri tǝri mʋ ba ba. Kʋ na yɩ Zeruzalɛm dɩ tɩɩnɩ dɩlʋ maama na wʋ Galile nɩ dɩ Zude nɩ tɩn. Ba jǝni ba kaagɩ Zezi, yɩ o jɩgɩ Wɛ dam o ma pa yawɩɩna na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","O na wʋra o brɩ-ba kʋntʋ tɩn, nɔɔna badonnǝ ya zɩŋɩ kɔrɔ dɩ gungolo ba jɩgɩ ba bɩɩna. Ba na yi da tɩn, mʋ ba kwaanɩ sɩ ba ja-o ba ja zʋ digǝ kam wʋ ba zʋʋrɩ ba tiŋi Zezi yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba maa warɩ, kɔgɔ kʋm na daga tɩn ŋwaanɩ. Ba ma wʋ nɛ cwǝŋǝ sɩ ba zʋ. Ba ma ja-o ba di nayuu. Ba ma puri bɔɔnɩ yɩ ba daarɩ ba pa gungolo kʋm tɔgɩ da kʋ tu digǝ kam wʋnɩ. Kʋ pǝni nɔɔna bam tɩtarɩ nɩ Zezi yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zezi ma lwarɩ nɩ ba kɩ ba wʋ-dɩdʋa dɩd-o. O ma ta o wɩ: «A badoŋ, nmʋ lwarɩm dɩm ti.» ");
INSERT INTO xsm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","O na tagɩ kʋntʋ tɩn, Wɛ cullu karanyɩna tiinǝ bam dɩ Farizɩan tiinǝ bam ma bwɛ ba wʋnɩ ba wɩ: «O brɩ o tɩtɩ nɩ o yɩ wɔɔ mʋ, yɩ o paɩ o dɩ Wɛ yɩ bɩdwɩ? O ŋɔɔnɩ o twɩ Wɛ mʋ. Nɔɔn-nɔɔnʋ nan ba jɩgɩ cwǝŋǝ sɩ o yagɩ nɔɔna lwarɩm o ma cɛ-ba, kʋ na daɩ Wɛ DƖ yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zezi ma lwarɩ ba na bwɛ te tɩn, yɩ o ta-ba o wɩ: «Bɛŋwaanɩ mʋ á bʋŋɩ kʋntʋ á wʋnɩ? ");
INSERT INTO xsm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kɔɔ mʋ yɩ mwalɩ kʋ dwe, amʋ na tagɩ dɩ kɔrɔ kʋm a wɩ: ‹Nmʋ lwarɩm dɩm ti› mʋ yɩ mwalɩ, naa a na tagɩ a wɩ: ‹Zaŋɩ n ta n veǝ› mʋ yɩ mwalɩ? ");
INSERT INTO xsm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amʋ nan wʋ́ pa abam lwarɩ sɩ a na yɩ Nabiin-bu wʋm tɩn jɩgɩ dam lʋgʋ baŋa nɩ, sɩ a yagɩ nɔɔna lwarɩm a ma cɛ-ba.» O laan ma ta dɩ kɔrɔ kʋm o wɩ: «A lagɩ a ta nmʋ, zaŋɩ wɛɛnɩ sɩ n kwe n gungolo kʋm n ja n vu sɔŋɔ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zezi na tagɩ kʋntʋ tɩn, bɩdwɩ baŋa nɩ mʋ nɔɔnʋ wʋm zaŋɩ ba maama yigǝ nɩ, yɩ o kwe o gungolo kʋm o ya na tigi kʋ baŋa nɩ tɩn o zɩŋɩ o maa ve sɔŋɔ, yɩ o zuli Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nɔɔna bam maama na nɛ kʋlʋ na kɩ tɩn, mʋ kʋ kɩ-ba yǝǝu. Fʋʋnɩ ma ja-ba. Ba ma zuli Wɛ, yɩ ba tɛ ba wɩ: «Dɩ́ zɩm nɛ wo-kɩnkagɩla!» ");
INSERT INTO xsm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kʋntʋ maama na kɛ tɩn, Zezi ma zaŋɩ o nuŋi o maa kɛa. O na maa kɛ tɩn mʋ o nɛ lampo-joŋnu wʋdoŋ, o yɩrɩ mʋ Leevi. O dɛɛn je mɛ seeni o na yǝni o jǝni o joŋi lampoo tɩn. Zezi ma ta dɩd-o o wɩ: «Zaŋɩ n ta n tɔgɩ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leevi ma zaŋɩ o yagɩ o woŋo maama yɩ o tɔgɩ o kwaga. ");
INSERT INTO xsm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","O ma vu sɔŋɔ o kɩ wʋdiiru zanzan o ma kɩ candiǝ o pa Zezi. Lampo-joŋnǝ zanzan dɩ nɔɔna badonnǝ ma ba ba tɔgɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizɩan tiinǝ dɩ ba cullu karanyɩna tiinǝ bam na nɛ kʋntʋ tɩn, ba ma vu Zezi karabiǝ bam te ba ŋɔɔna yɩ ba pʋʋna ba wɩ: «Bɛɛ mʋ kɩ yɩ abam di wʋdiu dɩdaanɩ lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ tɩm kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zezi ma lǝri-ba o wɩ: «Kʋ na yɩ balʋ na jɩgɩ yazurǝ tɩn, bantʋ wʋ maŋɩ sɩ ba vu dɔgɩta tu te sɩ o sooni-ba. Kʋ daarɩ balʋ na ba jɩgɩ yazurǝ tɩn mʋ maŋɩ sɩ ba vu ba na soonim. ");
INSERT INTO xsm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amʋ na tu lʋgʋ baŋa tɩn, kʋ daɩ sɩ a bǝŋi balʋ na maŋɩ ba yɩ nɔn-ŋʋna tɩn, a nan tu sɩ a bǝŋi nɔn-balwaarʋ mʋ, sɩ ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ba daa ta ma ta dɩ Zezi ba wɩ: «Zan karabiǝ bam yǝni ba vɔ ni mʋ maŋa zanzan yɩ ba daarɩ ba warɩ Wɛ. Farizɩan karabiǝ bam dɩ yǝni ba kɩ kʋntʋ doŋ mʋ. Bɛɛ mʋ yɩ nmʋ karabiǝ bam ba vɔ ni kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","O ma lǝri-ba o wɩ: «Nɔɔnʋ na di kaanɩ yɩ o kɩ candiǝ, yɩ o cilonnǝ na wʋra sɩ ba tɔgɩ ba di, n sɛ n pa ba vɔ ni yɩ kan-barʋ wʋm ta wʋ ba tee nɩ na? ");
INSERT INTO xsm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Maŋa nan wʋ́ ba yi, yɩ ba ja kan-barʋ wʋm ba viiri. Maŋa kam kʋntʋ nɩ yɩ o daa na ba ta wʋ ba tee nɩ tɩn, mʋ ba laan wʋ́ vɔ ni.» ");
INSERT INTO xsm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Zezi daa ma maŋɩ mɩmaŋɩ dɩdoŋ o brɩ-ba o wɩ: «Nɔɔn-nɔɔnʋ bá sɛ o kwe gwar-dʋŋʋ o kaarɩ sɩ o ma fǝri gwar-doŋo. O nan na kɩ kʋntʋ oó kaarɩ gwar-dʋŋʋ kʋm o cɔgɩ mʋ, yɩ kʋ bá wanɩ kʋ maŋɩ dɩ gwar-doŋo kʋm. ");
INSERT INTO xsm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nɔɔn-nɔɔnʋ dɩ nan bá sɛ o kwe sa-dʋŋa o lo o kɩ lɔ-doŋo wʋnɩ. O na kɩ kʋntʋ, yɩ sana kam na keeri, kaá pa lɔɔ kʋm bagɩ mʋ. Kʋntʋ ŋwaanɩ sana kam wʋ́ lo, yɩ lɔɔ kʋm dɩ cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sa-dʋŋa nan maŋɩ sɩ n lo n kɩ lɔ-dʋŋʋ wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɔɔnʋ nan na nyɔgɩ sa-doŋǝ o mɩ, o daa bá lagɩ sɩ o nyɔ sa-dʋŋa. Oó ta wɩ: ‹Sa-doŋǝ kam tiini ka lamma›.» ");
INSERT INTO xsm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Zwifǝ bam siun dɛ dɩdoŋ daa ma yi. Zezi dɩ o karabiǝ bam dɛɛn ma tɔgɩ daanɩ ba da karɩ wʋ ba maa kɛa. Ba na maa kɛ tɩn, o karabiǝ bam maa bwǝri mɩna ba yu ba dʋna. ");
INSERT INTO xsm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farizɩan tiinǝ badonnǝ na nɛ kʋntʋ tɩn, ba ma bwe ba wɩ: «Bɛɛ mʋ yɩ abam tʋŋɩ tɩtʋŋɩ dɩlʋ na cɔgɩ dɩbam siun dɛ cullu tɩm tɩn?» ");
INSERT INTO xsm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zezi ma lǝri-ba o wɩ: «Abam ta wʋ fɔgɩ á karɩmɩ Wɛ tɔnɔ kʋm na brɩ Pɛ Davidi taanɩ te tɩn na? Kʋ brɩ sɩ kana dɛɛn jaan-o dɩ o nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O ma vu o zʋ Wɛ digǝ, yɩ o kwe culu dɩpɛ dɩlʋ na tigi da Wɛ ŋwaanɩ tɩn. Dɩpɛ dɩntʋ ya culǝ sɩ nɔn-gaa di-dɩ, kʋ na daɩ Wɛ kaanɩm tiinǝ bam yɩranɩ. Yɩ Davidi dɛɛn di dɩpɛ dɩm, yɩ o daarɩ o pa o nɔɔna bam dɩ tɔgɩ ba di». ");
INSERT INTO xsm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zezi daa ta ma ta dɩ ba o wɩ: «Kʋntʋ tɩn, amʋ Nabiin-bu wʋm jɩgɩ ni siun dɛ cullu tɩm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kʋntʋ na kɛ tɩn, siun dɛ dɩdɩm daa ma yi. Zezi ma vu o zʋ Zwifǝ bam Wɛ-digǝ. O maa wʋra o brɩ-ba Wɛ taanɩ. Nɔɔnʋ wʋdoŋ maa tɔgɩ o wʋra, o jazɩm jɩŋa na tɩga. ");
INSERT INTO xsm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wɛ cullu karanyɩna tiinǝ dɩ Farizɩan tiinǝ dɩ maa wʋra. Bantʋ maa kwaanɩ ba lagɩ cwǝŋǝ sɩ ba brɩ nɩ Zezi kɩ o tusi. Kʋntʋ ŋwaanɩ ba dɛɛn je ba yɩr-o sɩ ba nii, oó sɛ o pa nɔɔnʋ na yazurǝ siun dɛ dɩm nɩ naa o bá sɛ. ");
INSERT INTO xsm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Zezi ma lwarɩ ba na bʋŋɩ te tɩn. O ma ta dɩ jɩ-tɩga kam tu o wɩ: «Zaŋɩ wɛɛnɩ n ba n zɩgɩ nɔɔna bam maama tɩtarɩ nɩ.» O ma zaŋɩ o nuŋi o zɩgɩ da. ");
INSERT INTO xsm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Zezi ma bwe-ba o wɩ: «Cullu brɩ sɩ bɛɛ mʋ? Kɔɔ mʋ maŋɩ dɩ culu kʋm, nɔɔnʋ na kɩ o doŋ lanyɩranɩ siun dɛ nɩ mʋ maŋɩ naa o na kɩ-o lwarɩm mʋ gara? Nɔɔnʋ na vrɩ o doŋ ŋwɩa siun dɛ nɩ mʋ maŋɩ naa o na gʋ-o mʋ gara?» ");
INSERT INTO xsm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","O na tagɩ kʋntʋ tɩn, o ma nii ba maama, yɩ o daarɩ o ŋɔɔnɩ dɩ jɩ-tɩga kam tu o wɩ: «Twɩ n jɩŋa kam!» O na twɩ o jɩŋa kam tɩn, ka ma joori ka ji lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba na nɛ kʋntʋ tɩn, ba ma fʋlɩ dɩdaanɩ Zezi, yɩ ba banɩ daanɩ sɩ ba nii ba na wʋ́ wanɩ ba kɩ-o te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Da yantʋ ni nɩ, Zezi ma vu o di piu kʋdoŋ yuu sɩ o warɩ Wɛ. Tɩtɩɩ dɩm kʋntʋ maama o warɩ Wɛ taan, sɩ kʋ yi tɩ-pʋra. ");
INSERT INTO xsm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tɩga na pʋʋrɩ ka ti tɩn, o ma bǝŋi o karabiǝ bam sɩ ba ba o te. O laan ma lɩ nɔɔna fugǝ-bale ba wʋnɩ, sɩ ba taa yɩ nɔɔna balʋ o na wʋ́ tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ba yɩra mʋ tɩntʋ: Simɔn wʋlʋ Zezi na pɛ o yɩrɩ o wɩ Pɩyɛɛrɩ tɩn, Andre wʋlʋ na yɩ Simɔn nyaanɩ tɩn, Zakɩ, Zan, Filipi, Batelemi, ");
INSERT INTO xsm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Toma, Zakɩ wʋlʋ na yɩ Alɩfɩ bu tɩn, Simɔn wʋlʋ na yɩ Zelɔtɩ nɔɔna bam wʋ nɔɔnʋ tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zudasɩ wʋlʋ na yɩ Zakɩ bu tɩn, dɩdaanɩ Zudasɩ Yiskarɩyo wʋlʋ na wʋ́ ba o yǝgi Zezi o pa nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zezi dɛ dɩ ba o zɩgɩ piu kʋm yuu nɩ o tu pɔgɔ-tɩga. O ma zɩgɩ da dɩdaanɩ o karabiǝ zanzan, dɩ nɔn-kɔgɔ zanzan maŋɩ kʋ gilimi kʋ su jǝgǝ kam maama. Bantʋ dɛɛn nuŋi je dwi tǝri tǝri mʋ Zwifǝ bam tɩɩnɩ dɩm maama wʋnɩ. Badonnǝ nuŋi Zeruzalɛm. Badonnǝ dɩ ma nuŋi Tiiri dɩ Sidɔn je sɩlʋ na wʋ nɩnɩʋ kʋm ni nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ba dɛɛn tu Zezi te sɩ ba cǝgi o taanɩ dɩm, sɩ ba kwǝri ba na yazurǝ dɩ ba yawɩɩrʋ. Nɔɔna badaara wʋra ciciri na jɩgɩ-ba sɩ yaara, yɩ ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nɔɔna bam maama maa kwaanɩ sɩ ba dwe-o, bɛŋwaanɩ dam nuŋi o yɩra nɩ dɩ pa ba na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zezi ma kwǝni o yiǝ o nii o karabiǝ bam seeni yɩ o wɩ: «Yinigǝ na jɩgɩ abam balʋ tɩn mʋ jɩgɩ yu-yoŋo, á na wʋ́ da á di Wɛ paarɩ dɩm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kana na jɩgɩ abam balʋ lele tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ pa abam kʋ daga tɩn ŋwaanɩ. Abam balʋ wʋrʋ na cɔgɩ lele tɩn mʋ jɩgɩ yu-yoŋo, Wɛ na wʋ́ pa abam wʋpolo tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nɔɔna na culi abam, yɩ ba na vaɩ abam, naa ba na twɩ abam, naa ba na jɩgɩ abam ba goonǝ, á na tɔgɩ amʋ na yɩ Nabiin-bu wʋm tɩn ŋwaanɩ, á jɩgɩ yu-yoŋo mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Maŋa kalʋ ba na kɩ abam kʋntʋ tɩn, taá faŋɩ-na á caka dɩ wʋpolo, á ŋwɩɩrʋ na yɩ zanzan Wɛ tee nɩ tɩn ŋwaanɩ. Taá ye-na sɩ ba kwǝ-nakwa dɩ dɛɛn kɩ faŋa faŋa Wɛ nijoŋnǝ bam kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kʋ daarɩ abam balʋ na yɩ nadunǝ tɩn, kʋ yɩ lɛɛrʋ dɩ abam, á na maŋɩ á na wo-laarʋ tɩm yɩ á daa bá na-tɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Abam balʋ na jɩgɩ wʋ-fwaarʋ á di lele tɩn, kʋ yɩ lɛɛrʋ dɩ abam, á na wʋ́ ba á yaarɩ dɩ kana tɩn ŋwaanɩ. Abam balʋ na jɩgɩ wʋpolo lele tɩn, kʋ yɩ lɛɛrʋ dɩ abam, á na wʋ́ ba á keeri yɩ á yi-na lu tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nɔɔna maama na jɩgɩ abam ba zulǝ, kʋ yɩ lɛɛrʋ dɩ abam. Á taá ye-na sɩ ba kwǝ-nakwa dɩ dɛɛn zuli balʋ na paɩ ba yɩ Wɛ nijoŋnǝ yɩ ba yagɩ ba daɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Zezi daa ma ta o wɩ: «Abam balʋ na cǝgi a taanɩ tɩn nan cǝgi-na lanyɩranɩ. Taá soe á dʋna. Taá kɩ balʋ na culi abam tɩn lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kʋ na yɩ balʋ na sɔɔlɩ sɩ kʋ cɔgɩ abam tɩn, sɩ á loori-na Wɛ sɩ DƖ kɩ-ba lanyɩranɩ. Loori-na Wɛ á pa balʋ na jɩgɩ abam ba bɛɛsɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɔɔnʋ na lɔgɩ n pʋpɔŋɔ, sɩ n guni kʋdoŋ kʋm sɩ o lɔ o wǝli da. Nɔɔnʋ na vrɩ n gwar-bwǝrǝ, yɩ cʋ-o sɩ o vrɩ n gwar-bu dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nɔɔnʋ wʋlʋ maama na loori woŋo nmʋ tee nɩ tɩn, sɩ n pa-o. Nɔɔnʋ na kwe nmʋ woŋo o ja viiri, yɩ bwe kʋ bwiǝ sɩ n joŋi. ");
INSERT INTO xsm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nan taá kɩ-na á donnǝ lanyɩranɩ, sɩ kʋ maŋɩ dɩ abam na lagɩ sɩ bantʋ taa kɩ abam te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Abam nan na soe balʋ dɩ na soe abam tɩn yɩranɩ, á wʋ́ na pɛɛrɩ na? Nɔɔna balʋ na ba tɔgɩ Wɛ tɩn dɩ soe balʋ na soe-ba tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Abam na kɩ lanyɩranɩ dɩ balʋ na kɩ abam lanyɩranɩ tɩn yɩranɩ, á wʋ́ na pɛɛrɩ na? Nɔɔna balʋ na ba tɔgɩ Wɛ tɩn dɩ maŋɩ ba kɩ kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Abam na jɩnɩ balʋ abam na bʋŋɩ sɩ baá wanɩ ba joori ba ŋwɩ abam tɩn yɩranɩ, á wʋ́ na pɛɛrɩ na? Nɔɔna balʋ na ba tɔgɩ Wɛ tɩn dɩ yǝni ba paɩ ba donnǝ jɩna, sɩ ba joori ba joŋi kʋ ni nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Abam nan maŋɩ sɩ á taá soe á dʋna sɩ á taá kɩ-ba lanyɩranɩ. Pa-na jɩna, nan yɩ taá tɩɩna sɩ á joori á joŋi. Á na kɩ kʋntʋ doŋ, á wʋ́ na pɛɛrɩ zanzan Wɛ tee nɩ, yɩ kʋʋ́ brɩ sɩ á yɩ Yuutu Baŋa-Wɛ biǝ mʋ, bɛŋwaanɩ Wɛ yǝni DƖ zǝni banɩ-nyɩna dɩ nɔn-balwaarʋ dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Á taá jɩgɩ nɔɔna ŋwaŋa, nɩ á Ko Wɛ na jɩgɩ nɔɔna ŋwaŋa te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Abam yɩ taá ŋɔɔna á donnǝ wǝǝnu, sɩ Wɛ yɩ ŋɔɔnɩ abam dɩ wǝǝnu. Yɩ taá lwɛ-na nɔɔna, sɩ Wɛ yɩ zaŋɩ DƖ ba DƖ lwɛ abam dɩ. Nan yagɩ-na á donnǝ lwarɩm á ma cɛ-ba, sɩ Wɛ wʋ́ yagɩ abam lwarɩm DƖ ma cɛ abam dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pa-na á donnǝ woŋo kʋlʋ na maŋɩ sɩ á pa-ba tɩn, sɩ Wɛ dɩ wʋ́ pa abam woŋo kʋlʋ na maŋɩ sɩ DƖ pa abam tɩn. Wɛ wʋ́ pa abam lanyɩranɩ nɩnɛɛnɩ ba na kwe bwaŋ-kamunu ba maŋɩ ba vuuri ka ni yɩ kʋ siiri te tɩn. Bwaŋa kalʋ abam na ma á maŋɩ á pa nɔɔna tɩn, Wɛ dɩ wʋ́ ma kantʋ mʋ DƖ maŋɩ DƖ pa abam dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zezi laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: «Lilwe wʋ́ wanɩ o vaŋɩ o doŋ lilwe na? Ba na vaŋɩ daanɩ, ba maama bá tʋ goŋo wʋnɩ na? ");
INSERT INTO xsm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Karabu bá wanɩ o dwǝni o karanyɩna. Karabu nan na zaasɩ o ti maama, o dɩ o karanyɩna kam maɩ daanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Abam nyɩ dɩ nɔɔnʋ na nii o doŋ yi nɩ o na gaa balaŋa da, yɩ o ba lagɩ sɩ o lwarɩ nɩ o tɩtɩ yi jɩgɩ daa tɩn. Kʋ maŋɩ sɩ kʋ taa yɩ kʋntʋ doŋ na? ");
INSERT INTO xsm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nmʋ na wʋ nɛ daa na wʋ nmʋ yi nɩ tɩn, nmʋ wʋ́ kɩ ta n ta n doŋ nɩ o ba sɩ n lɩ gaa o yi nɩ? Nmʋ yɩ pipiri-nyɩm dɩ nmʋ na kɩ n doŋ te tɩn. Nmʋ nan maŋɩ sɩ n lɩ n tɩtɩ yi daa kam mʋ, sɩ n laan wanɩ n nii lanyɩranɩ sɩ n lɩ n doŋ yi gaa kam.» ");
INSERT INTO xsm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Tu-ŋʋŋʋ bá wanɩ kʋ lǝ bu-balwaarʋ. Tu-balɔrɔ dɩ nan bá wanɩ kʋ lǝ bu-ŋʋna. ");
INSERT INTO xsm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abam na lagɩ sɩ á lwarɩ tiu maama na yɩ kʋlʋ tɩn, á wʋ́ ma kʋ biǝ mʋ á lwarɩ. Nmʋ bá na mɔɔla sabara yuu nɩ, asawɛ n na swan kaligoŋo kuri nɩ n twɛ. ");
INSERT INTO xsm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nɔn-ŋʋm ŋɔɔnɩ wo-ŋʋnnʋ tɩlʋ na wʋ o wʋbʋŋa nɩ tɩn mʋ. Nɔn-balɔrɔ dɩ ma ŋɔɔnɩ wo-balwaarʋ tɩlʋ na wʋ o wʋbʋŋa nɩ tɩn. Woŋo kʋlʋ maama na wʋ nɔɔnʋ wʋbʋŋa nɩ tɩn mʋ tɔgɩ o ni kʋ nuŋǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Bɛŋwaanɩ mʋ yɩ á bǝ amʋ sɩ ‹Yuutu, Yuutu›, yɩ á ba kɩ a na wɩ á kɩ te tɩn? ");
INSERT INTO xsm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wʋlʋ maama na tu amʋ te o cǝgi a taanɩ dɩm yɩ o kɩ a na wɩ te tɩn, amʋ wʋ́ brɩ abam kʋntʋ tu na nyɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʋntʋ nyɩ dɩ nɔɔnʋ wʋlʋ na lagɩ o lɔ o sɔŋɔ yɩ o kʋ goŋo o yi pulɔrɔ yɩ o laan cwi sɔŋɔ kʋm kuri pulɔrɔ kʋm baŋa nɩ tɩn mʋ. Dʋ-na na daga yɩ ba magɩ sɔŋɔ kʋm, ba bá wanɩ ba coori-kʋ, o na lɔgɩ-kʋ lanyɩranɩ yɩ kʋ dana tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kʋ daarɩ wʋlʋ maama nan na cǝgi amʋ taanɩ dɩm yɩ o ba kɩ a na wɩ te tɩn, kʋntʋ tu nyɩ dɩ nɔɔnʋ wʋlʋ na lɔgɩ o sɔŋɔ kasʋlʋ baŋa nɩ yɩ o wʋ kʋgɩ goŋo sɩ o ma cwi-kʋ tɩn mʋ. Dʋ-na na daga, baá magɩ sɔŋɔ kʋm ba guri yɩ ba coori kʋ maama.» ");
INSERT INTO xsm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zezi dɛɛn na brɩ nɔn-kɔgɔ kʋm o zaasɩm dɩm o ti tɩn, o ma vu Kapɛrnawum. ");
INSERT INTO xsm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pamaŋna yigǝ tu wʋdoŋ dɛɛn mʋ wʋra, o na jɩgɩ tɩntʋŋnʋ. O maa so-o lanyɩranɩ. O tɩntʋŋnʋ wʋm dɛɛn ba jɩgɩ yazurǝ, kʋ gɛ fɩɩn sɩ o tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pamaŋnʋ wʋm ma ba o ni Zezi ŋwa. O ma tʋŋɩ Zwifǝ bam nakwa o tee nɩ sɩ ba vu ba loor-o, sɩ o ba o pa o tɩntʋŋnʋ wʋm na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ba ma vu Zezi te ba tiini ba loor-o, sɩ o ba o pa ba dɩdɛɛrʋ wʋm tɩntʋŋnʋ wʋm na yazurǝ. Ba ma ta dɩd-o ba wɩ: «O yɩ nɔn-ŋʋm. ");
INSERT INTO xsm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","O soe dɩbam balʋ na yɩ Zwifǝ tɩn zanzan, yɩ o lɔ Wɛ-digǝ o pa dɩbam. Kʋntʋ ŋwaanɩ, kwaanɩ sɩ n duri o yibwǝnǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zezi ma sɛ. O ma tɔgɩ dɩdaanɩ ba o maa ve pamaŋnʋ wʋm sɔŋɔ. O na ma twɛ sɔŋɔ kʋm tɩn, dɩdaanɩ pamaŋnʋ wʋm daa tʋŋɩ o cilonnǝ o tee nɩ o wɩ: «Amʋ tu, yɩ yaarɩ n tɩtɩ n ba. A wʋ maŋɩ sɩ n ba n zʋ amʋ sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kʋntʋ mʋ pɛ a bʋŋɩ sɩ kʋ wʋ maŋɩ sɩ a tɩtɩ ba nmʋ te. Nan weeni n ta dɩ n ni nɩ a tɩntʋŋnʋ wʋm zaŋɩ. N na tagɩ kʋntʋ, oó na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bɛŋwaanɩ, amʋ dɩ yɩ nɔɔnʋ wʋlʋ nɔɔna badonnǝ na jɩgɩ dam a baŋa nɩ tɩn, yɩ amʋ dɩ ta jɩgɩ dam pamaŋna badaara baŋa nɩ. A na tagɩ a wɩ, nɔɔnʋ wʋlʋ ve, o maŋɩ sɩ o vu mʋ. A nan daa na wɩ, nɔɔnʋ wʋlʋ ba, o dɩ wʋ́ ba mʋ. Kʋ daa zɩ yɩ a tɩntʋŋnʋ, a na wɩ o kɩ woŋo, oó kɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zezi na ni kʋntʋ tɩn, kʋ ma sʋ-o. O ma pipiri o nii kɔgɔ kʋlʋ na tɔg-o tɩn, yɩ o ta o wɩ: «A lagɩ a ta abam sɩ, amʋ wʋ nɛ nɔɔn-nɔɔnʋ o na jɩgɩ wʋ-dɩdʋa dɩ amʋ nɩnɛɛnɩ wʋntʋ na jɩgɩ wʋ-dɩdʋa te tɩn, kʋ na maŋɩ kʋ yɩ Yisɩrayɛlɩ dwi tiinǝ bam wʋnɩ dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pamaŋnʋ wʋm cilonnǝ bam o na tʋŋɩ tɩn laan ma joori sɔŋɔ. Ba na yi da tɩn, ba nɛ dɩ o tɩntʋŋnʋ wʋm jɩgɩ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kʋntʋ na kɛ tɩn, Zezi daa ma zaŋɩ o vu tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Nayim. O na maa ve tɩn, o karabiǝ bam dɩdaanɩ kɔ-fɔrɔ mʋ tɔg-o ba veǝ. ");
INSERT INTO xsm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","O na yi tɩʋ kʋm ni tɩn, o ma jeeri nɔɔna na zɩŋɩ tʋ dɩ gandwa ba ma nuŋǝ. Tʋ wʋm nu yɩ kadǝm mʋ. Mʋ o bu dɩdʋa. Tɩʋ kʋm kɔ-fɔrɔ dɩ maa tɔgɩ tʋ wʋm kwaga. ");
INSERT INTO xsm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dɩ́ Yuutu Zezi na nɛ kadǝm wʋm tɩn, o ŋwaŋa ma zʋ-o. O ma ta dɩd-o o wɩ: «Yɩ ta n keerǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","O ma vu o dwe gandwa yam. O na dwe-ya tɩn, balʋ na zɩŋɩ tʋ wʋm tɩn ma zɩgɩ. Zezi ma ta dɩ tʋ wʋm o wɩ: «Bu-dʋŋʋ, a tɛ dɩ nmʋ: Zaŋɩ wɛɛnɩ!» ");
INSERT INTO xsm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","O na tagɩ kʋntʋ tɩn, tʋ wʋm ma sɩɩnɩ o zaŋɩ yɩ o sɩŋɩ o ŋɔɔna. Zezi ma joŋ-o o pa o nu wʋm. ");
INSERT INTO xsm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɔɔna bam maama na nɛ kʋntʋ tɩn, fʋʋnɩ jaanɩ-ba lanyɩranɩ. Ba ma tee Wɛ ba wɩ: «Wɛ nijoŋnu kamunu mʋ tu dɩbam tɩtarɩ nɩ. Wɛ tu sɩ DƖ zǝni DƖ nɔɔna bam.» ");
INSERT INTO xsm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ba laan ma ni Zezi ŋwa Zude tɩɩnɩ dɩm maama wʋnɩ dɩ je sɩm maama nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zan dɩ dɛɛn ma ni Zezi ŋwa. O karabiǝ bam ma ta ba brɩ-o Zezi na kɩ kʋlʋ maama tɩn. O laan ma lɩ o karabiǝ bam bale, ");
INSERT INTO xsm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yɩ o tʋŋɩ-ba dɩ́ Yuutu Zezi tee nɩ, sɩ ba vu ba bwe-o ba nii, wʋntʋ mʋ yɩ wʋlʋ Wɛ na brɩ-ba sɩ oó ba tɩn naa ba ta wʋ́ ta cǝgi nɔɔnʋ wʋdoŋ mʋ? ");
INSERT INTO xsm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nɔɔna bam ma vu Zezi te ba ta dɩd-o ba wɩ: «Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn mʋ tʋŋɩ dɩbam nmʋ tee nɩ, sɩ dɩ́ ba dɩ́ bwe dɩ́ nii, nmʋ mʋ yɩ wʋlʋ Wɛ na brɩ dɩbam sɩ n ba tɩn naa dɩ́ ta wʋ́ ta cǝgi nɔɔnʋ wʋdoŋ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kantʋ maŋa kam nɩ nɔ́ɔ, mʋ Zezi dɛɛn pɛ nɔɔna zanzan na yazurǝ dɩ ba yawɩɩrʋ dwi dwi. O ma zǝli ciciri sɩlʋ na yaarɩ nɔɔna tɩn, yɩ o daarɩ o pa lilwǝ zanzan yiǝ puri. ");
INSERT INTO xsm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","O laan ma lǝri Zan karabiǝ bam o wɩ: «Ve-na á ta dɩ Zan kʋlʋ maama á na nɛ tɩn yɩ á kwǝri á ni tɩn. Á ta á brɩ-o nɩ lilwǝ yiǝ puri, kwaarʋ dɩ waɩ tɩ veǝ, nanywaanʋ yɩra dɩ kwɛ lanyɩranɩ, zwa-kwarʋ dɩ zwa ni, twa dɩ joori ba bi. Kʋlʋ na wǝli da tɩn, yinigǝ tiinǝ dɩ maa ni Wɛ kwǝr-ywǝŋǝ kam. ");
INSERT INTO xsm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wʋlʋ maama na ba joori amʋ kwaga nɩ tɩn mʋ yɩ yu-yoŋo tu.» ");
INSERT INTO xsm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zan karabiǝ bam ma joori ba viiri. Zezi laan ma ta Zan taanɩ o brɩ nɔn-kɔgɔ kʋm o wɩ: «Abam dɛɛn na ve Zan te kagʋa kam wʋnɩ tɩn, á bʋŋɩ sɩ á wʋ́ na bɛɛ mʋ? Á ve sɩ á nii miu kʋlʋ viu na jɩgɩ kʋ zuuli tɩn mʋ na? Aye, kʋ daɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Sɩ bɛɛ mʋ? Á ve sɩ á nii nɔɔnʋ wʋlʋ na zʋ gwar-ŋʋnnʋ tɩn mʋ na? Aye, kʋ daɩ kʋntʋ. Nɔɔna balʋ na zʋ gwar-ŋʋnnʋ yɩ ba ŋwɩa ywǝnǝ tɩn zʋʋrɩ sɔ-ŋʋnnʋ wʋnɩ mʋ, sɩ kʋ daɩ kagʋa wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɛɛ nan mʋ á ve sɩ á nii? Á ve sɩ á na Wɛ nijoŋnu mʋ na? Ɛɛn, kʋ yɩ kʋntʋ mʋ. Á nan na nɛ wʋlʋ tɩn tiini o dwe faŋa faŋa Wɛ nijoŋnǝ bam na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wɛ tɔnɔ kʋm nan maŋɩ kʋ ta wʋntʋ taanɩ kʋ wɩ: ‹Nii, amʋ Wɛ lagɩ a tʋŋɩ a tɩntʋŋnʋ mʋ, sɩ o da nmʋ yigǝ o vu o kwɛ cwǝŋǝ kalʋ nmʋ na wʋ́ ba n tɔgɩ da tɩn.› ");
INSERT INTO xsm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A lagɩ a ta abam sɩ, nabiinǝ balʋ maama ba na maŋɩ ba lʋ tɩn wʋnɩ nɔɔn-nɔɔnʋ tǝrǝ o na dwe Zan na yɩ te tɩn. Kʋ daarɩ lele kʋntʋ, nɔn-nabwǝm wʋlʋ maama na zʋ Baŋa-Wɛ paarɩ dɩm wʋnɩ tɩn laan tu o dwe Zan. ");
INSERT INTO xsm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɔɔna bam maama dɩdaanɩ lampo-joŋnǝ bam dɛɛn dɩ na ni Zan taanɩ tɩn, ba ma sɛ sɩ Wɛ jɩgɩ cɩga dɩ ba na maŋɩ ba pa Zan miisi-ba na wʋnɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kʋ daarɩ Farizɩan tiinǝ bam dɩ cullu karanyɩna tiinǝ bam dɛɛn wʋ sɛ sɩ Zan miisi-ba na wʋnɩ, yɩ ba vɩn Wɛ na bʋŋɩ kʋlʋ sɩ DƖ kɩ DƖ pa-ba tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zezi daa ma ta o wɩ: «Amʋ nan wʋ́ kɩ ta mʋ a maŋɩ zɩm nɔɔna bam kǝm na yɩ te tɩn? Ba nyɩ dɩ bɛɛ mʋ? ");
INSERT INTO xsm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zɩm nɔɔna bam nyɩ nɩnɛɛnɩ biǝ na je yaga kaporo nɩ ba kwɛɛrɩ te tɩn mʋ. Ba maa tɛ daanɩ ba wɩ: ‹Dɩ́ magɩ gullu mʋ sɩ á sa, yɩ á wʋ sagɩ. Dɩ́ ma daarɩ dɩ́ leeni luǝ le, yɩ á yigǝ wʋ nywanɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zɩm nɔɔna bam dɩ yɩ kʋntʋ mʋ. Bɛŋwaanɩ, Zan na tu tɩn, o dɛɛn pɩɩnɩ o kana mʋ yɩ o kwǝri o ba nyɔ sana. Abam na nɛ-o tɩn, á maa jɩg-o á yáala sɩ kʋ yɩ cicirǝ mʋ tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kʋ daarɩ, amʋ Nabiin-bu wʋm nan na tu tɩn, a wʋ vɔgɩ ni. Abam daa ta ma yáalɩ amʋ dɩ á wɩ, a yɩ nɔn-kolo mʋ, yɩ a yɩ sa-nyɔrʋ dɩ. Á daa ta maa wɩ, a yɩ lampo-joŋnǝ dɩ nɔn-balwaarʋ ciloŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Balʋ maama nan na tɔgɩ Wɛ cwǝŋǝ tɩn mʋ lwarɩ nɩ Wɛ jɩgɩ cɩga.» ");
INSERT INTO xsm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farizɩan tu dɩdʋa dɛɛn mʋ wʋra, o yɩrɩ mʋ Simɔn. O ma bǝŋi Zezi sɩ o ba o vu o sɔŋɔ o di wʋdiu. Zezi ma vu o zʋ o sɔŋɔ kʋm o jǝni sɩ o di. ");
INSERT INTO xsm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka-cɩcwaka dɛɛn mʋ wʋ tɩʋ kʋm kʋntʋ nɩ. O ma lwarɩ sɩ Zezi wʋ Farizɩan tu wʋm sɔŋɔ nɩ o di wʋdiu. O ma kwe kunkwǝlǝ na su dɩ tralɩ nugǝ tɩn o ja vu Zezi te. ");
INSERT INTO xsm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","O ma vu o zɩgɩ Zezi nɛ ni nɩ, yɩ o keerǝ. O yi-na maa lurǝ ba bugi Zezi nɛ. O ma tiiri o ma o yuuywe o guguni o yi-na bam Zezi nɛ nɩ, yɩ o kukwǝri Zezi nɛ sɩm. O ma daarɩ o pwǝri tralɩ nugǝ kam o ma turi o nɛ sɩm. ");
INSERT INTO xsm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farizɩan tu wʋlʋ na bǝŋi Zezi o sɔŋɔ nɩ tɩn na nɛ kʋntʋ tɩn, o laan ma bʋŋɩ o wʋnɩ o wɩ: «Nɔɔnʋ wʋntʋ ya na yɩ Wɛ nijoŋnu, o ya wʋ́ lwarɩ kaanɩ wʋntʋ kǝm na yɩ te tɩn, yɩ o ya wʋ́ lwarɩ nɩ kaanɩ wʋlʋ na dwe-o tɩn yɩ ka-cɩcwaka mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zezi ma ta dɩd-o o wɩ: «Simɔn a lagɩ a bwe nmʋ woŋo.» O maa wɩ: «Karanyɩna, nan bwe.» ");
INSERT INTO xsm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zezi laan ma maŋɩ mɩmaŋa o wɩ: «Nɔɔna bale mʋ jɩnɩ sǝbu nɔɔnʋ tee nɩ, dɩdʋa jɩnɩ mʋrr-fiinnu, wʋdoŋ wʋm ma jɩnɩ mʋrr-tɩnu. ");
INSERT INTO xsm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba maa warɩ ba ŋwɩ jɩnɩ dɩm, yɩ o yagɩ o ma cɛ ba maama. Kʋntʋ tɩn, bantʋ wʋnɩ wɔɔ mʋ wʋ́ ta so-o o dwe?» ");
INSERT INTO xsm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔn ma lǝr-o o wɩ: «A bʋŋɩ sɩ wʋlʋ jɩnɩ na daga yɩ o yagɩ o ma cɛ-o tɩn mʋ wʋ́ taa so-o o dwe.» Zezi maa wɩ: «N sɩɩnɩ n ta cɩga.» ");
INSERT INTO xsm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","O laan ma pipiri kaanɩ wʋm seeni, yɩ o ta dɩ Simɔn o wɩ: «Nmʋ nɛ kaanɩ wʋntʋ na kɩ te tɩn na? A na tu a zʋ n sɔŋɔ kʋm tɩn, nmʋ wʋ pɛ-nɩ na sɩ a ma sɩn a nɛ. Kaanɩ wʋntʋ nan bugi a nɛ dɩdaanɩ o yi-na mʋ, yɩ o daarɩ o guguni-sɩ dɩdaanɩ o yuuywe. ");
INSERT INTO xsm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A na tu tɩn, nmʋ wʋ kukwǝri-nɩ sɩ kʋ brɩ nɩ n jeeri-nɩ lanyɩranɩ. Kaanɩ wʋntʋ nan kukwǝri a nɛ mʋ taan, kʋ na puli dɩ maŋa kam a na tu nmʋ sɔŋɔ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A na tu nmʋ te tɩn, nmʋ wʋ kɩ nugǝ a yuu nɩ sɩ kʋ pa-nɩ zulǝ. Kaanɩ wʋntʋ nan kwe tralɩ nugǝ mʋ o lo o ma turi a nɛ. ");
INSERT INTO xsm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kʋntʋ ŋwaanɩ a lagɩ a ta nmʋ sɩ, o sono kamunu kʋm mʋ brɩ nɩ Wɛ yagɩ o lwarma yam zanzan DƖ ma cɛ-o. Kʋ daarɩ wʋlʋ Wɛ na yagɩ o lwarɩm fɩnfɩɩn DƖ ma cɛ-o tɩn jɩgɩ sono fɩnfɩɩn yɩranɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zezi laan ma daarɩ o ta dɩ kaanɩ wʋm o wɩ: «N lwarɩm dɩm ti.» ");
INSERT INTO xsm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","O na tagɩ kʋntʋ tɩn, nɔɔna balʋ dɩ na tɔgɩ ba wʋra tɩn ma ŋɔɔnɩ daanɩ ba wɩ: «Wʋntʋ nan brɩ o tɩtɩ nɩ o yɩ wɔɔ mʋ, yɩ o yagɩ nɔɔnʋ lwarɩm o ma cɛ-o?» ");
INSERT INTO xsm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","O laan ma ta dɩ kaanɩ wʋm o wɩ: «Nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ tɩn mʋ pɛ n na vrɩm. Ve dɩ yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kʋntʋ kwaga nɩ, Zezi dɛɛn ma beeri o tʋlɩ tɩ-kamunnu dɩ tɩ-balwa bam maama, yɩ o tɔɔlɩ kwǝr-ywǝŋǝ kam o brɩ Wɛ na lagɩ DƖ di paarɩ tɩte nɔɔna tɩtarɩ nɩ tɩn. O karabiǝ fugǝ-bale bam dɩ dɛɛn maa tɔgɩ dɩd-o ba beerǝ. ");
INSERT INTO xsm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kaana badonnǝ dɩ tɔgɩ ba wʋ o tee nɩ. Bantʋ yɩ balʋ ciciri dɩ yawɩɩrʋ dwi dwi dɛɛn na yaarɩ-ba yɩ Zezi pa ba na yazurǝ tɩn. Ba dɩdʋa yɩrɩ mʋ Mari wʋlʋ na nuŋi Magɩdala tɩn. Wʋntʋ mʋ Zezi ya zǝli ciciri sɩrpɛ yɩ sɩ nuŋi sɩ daar-o. ");
INSERT INTO xsm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wʋdoŋ yɩrɩ mʋ Zannɩ. Wʋntʋ mʋ yɩ Zuuza wʋlʋ na nii Erɔdɩ sɔŋɔ baŋa nɩ tɩn kaanɩ. Wʋdoŋ dɩ yɩrɩ mʋ Suzaanɩ. Kaana zanzan dɩ tɔgɩ ba wʋra. Kaana bantʋ maama dɛɛn yǝni ba lɩ ba jɩjɩgɩrʋ ba ma zǝni Zezi dɩ o karabiǝ bam. ");
INSERT INTO xsm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nɔɔna zanzan dɛɛn nuŋi tɩɩnɩ tǝri tǝri ba ba Zezi te. Kɔ-fɔrɔ na gilim-o kʋntʋ tɩn, o laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Valʋ dɛɛn mʋ wʋra. O ma zaŋɩ o vu o kara duum maŋa nɩ. O ma karɩ o dʋlɩ o wo-duuru tɩm kara kam wʋnɩ. Wo-duuru tɩdonnǝ ma tʋ cwǝŋǝ ni nɩ. Nɔɔna ma nɔna tɩ baŋa nɩ ba kɛa. Zunǝ ma na-tɩ ba twɛ ba di. ");
INSERT INTO xsm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tɩdaara ma tʋ kandwa jǝgǝ nɩ. Tɩ ma nuŋi yɩ tɩ kwaarɩ tɩ tɩ lɩla, tɩga kam na ba zurǝ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tɩdaara ma tʋ sabarɩ jǝgǝ nɩ. Tɩ na puli tɩ zaŋɩ tɩn, sabarɩ sɩm ma tɔgɩ sɩ zaŋɩ sɩ li-tɩ sɩ gʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kʋ daarɩ tɩdaara ma tʋ tɩ-ywǝŋǝ jǝgǝ nɩ. Tɩ ma nuŋi tɩ kɩ biǝ lanyɩranɩ nɩnɛɛnɩ biǝ bi bi te.» Zezi na tagɩ kʋntʋ o ti tɩn, o laan ma ta dɩ kwǝr-dɩa o wɩ: «Abam nan fɔgɩ á cǝgi a taanɩ dɩm lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Zezi karabiǝ bam laan ma bwe-o ba wɩ: «Mɩmaŋɩ dɩntʋ kuri mʋ bɛɛ?» ");
INSERT INTO xsm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O ma lǝri-ba o wɩ: «Wɛ paarɩ dɩm kuri ya sǝgi mʋ. Kʋ nan na yɩ abam, Wɛ maŋɩ DƖ pa á lwarɩ DƖ paarɩ dɩm kuri na yɩ te tɩn. Kʋ na yɩ nɔɔna badaara, a yǝni a maŋɩ mɩmaŋa mʋ a brɩ-ba, sɩ ‹ba na niǝ, sɩ ba yɩ taa naɩ, ba na cǝgǝ, sɩ ba yɩ taa ni kʋ kuri.› ");
INSERT INTO xsm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mɩmaŋɩ dɩm kuri mʋ tɩntʋ: Wo-duuru tɩm brɩ Wɛ taanɩ dɩm na yɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Cwǝŋǝ kam wo-duuru tɩm na tʋ da tɩn maa maŋɩ nɔɔna balʋ na ni Wɛ taanɩ dɩm yɩ sʋtaanɩ laan ba dɩ lɩ-dɩ yɩ dɩ wʋ zʋ ba wʋbʋŋa tɩn mʋ. Dɩ kɩ kʋntʋ sɩ ba yɩ kɩ ba wʋ-dɩdʋa mʋ dɩ Wɛ, sɩ Wɛ yɩ vrɩ-ba lwarɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kandwa yam jǝgǝ kam maa maŋɩ balʋ na ni Wɛ taanɩ dɩm yɩ ba joŋi-dɩ dɩ wʋpolo tɩn mʋ. Taanɩ dɩm ma wʋ tiini dɩ zʋ ba wʋbʋŋa, yɩ kʋ na kɩ fɩnfɩɩn, ba daa ba sɛa. Cam maŋa na yiǝ, baá da kwe ba yagɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sabarɩ sɩm jǝgǝ kam wo-duuru tɩm na tʋ da tɩn maa maŋɩ balʋ na ni Wɛ taanɩ dɩm yɩ ba zaŋɩ ba ta jɩgɩ liǝ dɩ ba ŋwɩa wǝǝnu, yɩ sǝbu-laga dɩ lʋgʋ baŋa ywǝǝni cɔgɩ ba wʋbʋŋa nɩ sabarɩ sɩm na ligi wo-duuru tɩm te tɩn. Bantʋ wʋbʋŋa daa bá bɩ dɩ Wɛ cwǝŋǝ kam tɔgɩm. ");
INSERT INTO xsm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tɩ-ywǝŋǝ jǝgǝ kam wo-duuru tɩm na tʋ da tɩn maa maŋɩ balʋ na ni Wɛ taanɩ dɩm yɩ ba joŋi-dɩ lanyɩranɩ ba kɩ ba bɩcarɩ nɩ tɩn mʋ. Bantʋ mʋ jɩgɩ wʋbʋŋ-ŋʋna, yɩ ba vɔ ba wʋ dɩ Wɛ cwǝŋǝ kam tɔgɩm. Wɛ taanɩ dɩm ma ja kuri dɩ pa-ba nɩ wo-duuru tɩlʋ na kɩ biǝ zanzan tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zezi daa ma ta o wɩ: «Nɔɔnʋ na jɩgɩ kanɩa, o bá sɛ sɩ o tarɩgɩ-ka o pu tɩtɔgɔ kuri nɩ, naa o zɩgɩ-ka gadogo kuri nɩ. Oó kwe-ka o palɩ wɛɛnɩ mʋ, sɩ ka taa jɩgɩ pooni ka paɩ balʋ na lagɩ ba zʋ digǝ kam wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kʋlʋ maama zɩm na sǝgi nɔɔna tee nɩ tɩn wʋ́ ba kwɩn. Kʋlʋ maama na pugi tɩn wʋ́ ba kʋ puri mʋ, sɩ nɔɔna lwarɩ kʋ kuri na yɩ te. ");
INSERT INTO xsm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kwaanɩ-na á pa á na ni kʋlʋ tɩn zʋ á wʋbʋŋa. Bɛŋwaanɩ, nɔɔnʋ wʋlʋ na maŋɩ o jɩgɩ woŋo tɩn, o ta wʋ́ joŋi kʋdoŋ o wǝli da, yɩ nɔɔnʋ wʋlʋ na maŋɩ o ba jɩgɩ tɩn wʋ́ ba ga kʋlʋ fɩnfɩɩn o na bʋŋɩ sɩ o jɩgɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zezi nu dɩ o nyaana ma ba o te sɩ ba na-o. Ba ma warɩ ba yi o te, kɔgɔ kʋm na daga tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɔɔnʋ wʋdoŋ ma ta dɩ Zezi o wɩ: «N nu dɩ n nyaana mʋ tu ba zɩgɩ cicwǝŋǝ nɩ, yɩ ba lagɩ sɩ ba na-m.» ");
INSERT INTO xsm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","O ma lǝri-ba o wɩ: «Balʋ maama na ni Wɛ taanɩ dɩm yɩ ba sɛ-dɩ tɩn mʋ yɩ a nu dɩ a nyaana.» ");
INSERT INTO xsm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dɛ dɩdwɩ Zezi dɩ o karabiǝ bam ma zʋ naboro. O ma ta dɩ ba o wɩ: «Pa-na dɩ́ bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm.» Ba ma sɩŋɩ ba yɛ ba maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ba na maa kɛ tɩn, Zezi ma tʋ dɔɔm nɩ. Vu-fɔrɔ ma da kʋ zaŋɩ nɩnɩʋ kʋm baŋa nɩ, kʋ magɩ boro kʋm kʋ pa kʋ wʋra kʋ miisǝ na bam kuri nɩ. Ba dɛɛn maa wʋ cam wʋnɩ ba lagɩ ba tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ba ma vu ba zaŋɩ Zezi dɔɔm nɩ, yɩ ba wɩ: «Dɩ́ Yuutu, zaŋɩ sɩ dɩ́ lagɩ dɩ́ li na dɩ́ tɩ.» O laan ma zaŋɩ wɛɛnɩ. O ma bagɩ viu kʋm dɩ na bam sɩ tɩ yagɩ. Viu kʋm laan ma yagɩ, yɩ na bam dɩ maŋɩ da cɩmm. ");
INSERT INTO xsm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","O ma bwe o karabiǝ bam o wɩ: «Bɛɛ mʋ yɩ á ba jɩgɩ wʋ-dɩdʋa dɩ amʋ?» Fʋʋnɩ ma ja-ba, yɩ kʋ kɩ-ba yǝǝu. Ba ma bwe daanɩ ba wɩ: «Wʋntʋ yɩ wɔɔ mʋ, yɩ o ta wanɩ o bagɩ viu dɩdaanɩ na, yɩ tɩ sɛ o ni?» ");
INSERT INTO xsm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ba ma yɛ ba vu ba bɛ nɩnɩʋ kʋm. Ba ma yi Zeraaza tiinǝ na zʋʋrɩ mɛ tɩn. Nɩnɩʋ kʋm tigi je sɩm kʋntʋ dɩ Galile laŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zezi ma nuŋi naboro kʋm wʋnɩ. Tɩʋ kʋm nɔɔnʋ dɩdʋa ma ba o jeer-o. Ciciri mʋ jɩg-o sɩ yaara. Kʋ tiini kʋ daanɩ o na wʋ zʋ kʋlʋkʋlʋ yɩ o ba zʋʋrɩ sɔŋɔ nɩ. O yǝni o tigi yibeelǝ je nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","O na nɛ Zezi tɩn, o ma sɩŋɩ o kaasɩ wɛwɛ. O ma vu o tʋ Zezi yigǝ nɩ, yɩ o kaasɩ dɩ kwǝr-dɩa o wɩ: «Zezi, Yuutu Baŋa-Wɛ Bu, nmʋ tu amʋ tee nɩ sɩ n kɩ bɛɛ mʋ? Popo, yɩ zaŋɩ n yaarɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","O tagɩ kʋntʋ, bɛŋwaanɩ Zezi maŋɩ o pa cicirǝ kam ni sɩ ka nuŋi ka yagɩ nɔɔnʋ wʋm. Kʋ daanɩ cicirǝ kam na maŋɩ ka jɩg-o. Kʋntʋ mʋ paɩ ba yǝni ba kwe capʋnnʋ ba ma vɔ o jɩa dɩ o nɛ, sɩ ba taa yɩr-o. Ba na yǝni ba vɔ-o kʋntʋ, o yǝni o kɔ-tɩ mʋ. Cicirǝ kam laan ma zǝl-o ka pa o duri o vu kagʋa wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zezi laan ma bwe-o o wɩ: «N yɩrɩ mʋ bɛɛ?» O ma lǝri o wɩ: «A yɩrɩ mʋ Kɔgɔ», bɛŋwaanɩ ciciri zanzan mʋ tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ciciri sɩm ma loori Zezi, sɩ o yɩ zǝli-sɩ o pa sɩ zʋ curu goŋ-luŋu kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tǝrǝ kɔgɔ zanzan dɛɛn ma wʋ je sɩm nɩ ba beeri piu yuu nɩ ba di. Ciciri sɩm ma loori Zezi, sɩ o pa-sɩ cwǝŋǝ sɩ sɩ vu sɩ zʋ tǝrǝ bam wʋ. O ma sɛ. ");
INSERT INTO xsm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ciciri sɩm laan ma yagɩ nɔɔnʋ wʋm yɩra, yɩ sɩ vu sɩ zʋ tǝrǝ bam. Tǝrǝ bam maama ma duri ba tu ba tʋ nɩnɩʋ kʋm wʋnɩ ba li na ba tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nɔɔna balʋ ya na nii tǝrǝ bam baŋa nɩ tɩn na nɛ kʋntʋ tɩn, ba ma duri ba vu ba ta kʋlʋ na kɩ tɩn tɩʋ wʋnɩ dɩdaanɩ dɛ sɩm maama ba brɩ nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɔɔna bam ma nuŋi ba vu sɩ ba nii kʋ na kɩ te tɩn. Ba ma vu ba yi Zezi te. Ba ma na nɔɔnʋ wʋlʋ cicirǝ kam na yag-o tɩn. O maa je Zezi tee nɩ dɩdaanɩ o swan joori ya ba, yɩ o zʋ gwaarʋ. Ba na nɛ-o kʋntʋ tɩn, fʋʋnɩ ma zʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Balʋ yiǝ na nɛ kʋ maama tɩn ma ta ba brɩ nɔɔna bam kʋ na kɩ te yɩ ciciri sɩm nuŋi sɩ yagɩ nɔɔnʋ wʋm tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zeraaza tɩʋ kʋm dɩ kʋ nawurǝ yam maama nɔɔna bam ma loori Zezi sɩ o viiri, bɛŋwaanɩ fʋʋnɩ tiini dɩ jɩgɩ-ba. Zezi laan ma joori o vu o zʋ naboro kʋm sɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","O na maa viiri tɩn, nɔɔnʋ wʋlʋ ciciri sɩm na yag-o tɩn ma loor-o sɩ o pa o da o vu. Zezi ma wʋ sɛ. ");
INSERT INTO xsm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","O ma ta dɩ nɔɔnʋ wʋm o wɩ: «Joori n vu n sɔŋɔ tiinǝ te, sɩ n ta kʋlʋ Wɛ na kɩ DƖ pa nmʋ tɩn n brɩ-ba.» Nɔɔnʋ wʋm ma vu o tʋlɩ tɩʋ kʋm maama wʋnɩ o tɔɔlɩ kʋlʋ maama Zezi na kɩ o pa-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zezi dɛɛn ma joori o bɛ nɩnɩʋ kʋm ni dɩdoŋ dɩm dɩdaanɩ kɔgɔ zanzan mʋ maŋɩ kʋ gilimi daanɩ kʋ cǝg-o. Ba na nɛ-o tɩn, ba ma jeer-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Nɔɔnʋ wʋdoŋ maa tɔgɩ o wʋra, o yɩrɩ mʋ Zayirusi. O yɩ Zwifǝ Wɛ-digǝ kam yigǝ tu. O ma vu Zezi te, o kuni doonǝ o yigǝ nɩ o loor-o o wɩ: «Popo, ba dɩbam sɔŋɔ n joŋi a bu n yagɩ, sɩ o wɔɛ o lagɩ o tɩ.» Mʋ o bu dɩdʋa yɩranɩ, o yɩ bɩsankana mʋ, o yi nɩ bɩna fugǝ-yale te. Zezi ma sɛ sɩ o vu. O na maa kɛ tɩn, kɔgɔ kʋm tiini kʋ pɩɩn-o. ");
INSERT INTO xsm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kaanɩ wʋdoŋ dɩ maa wʋra o na wɔɛ ka-wʋ taan bɩna fugǝ-yale. O ya kwe o jɩjɩgɩrʋ maama o pa liri tiinǝ sɩ ba soon-o, yɩ nɔɔnʋ dɩ dɩdʋa wʋ wanɩ o soon-o. ");
INSERT INTO xsm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","O ma kɛ Zezi kwaga o vu o laarɩ o dwe o gɔrɔ kʋm ni. O na dwe-o kʋntʋ tɩn, jana bam ma kɔ bɩdwɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zezi ma bwe o wɩ: «Wɔɔ mʋ dwe amʋ?» Ba maama ma fʋ ba wɩ, ba wʋ dwe-o. Pɩyɛɛrɩ dɩ balʋ na wʋ o tee nɩ tɩn ma ta ba wɩ: «Dɩ́ Yuutu, nmʋ wʋ nɛ nɔɔna bam na tiini ba daga yɩ ba pɩɩnɩ nmʋ te tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Zezi ma lǝri o wɩ: «Kʋ yɩ nɔɔnʋ mʋ dwe-nɩ. Amʋ ye sɩ dam nuŋi a yɩra nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kaanɩ wʋm ma lwarɩ sɩ o bá wanɩ o sǝgi dɩ kʋlʋ na kɩ tɩn. Fʋʋnɩ maa jɩg-o yɩ o yɩra saɩ. O ma vu o tʋ Zezi yigǝ nɩ. O ma ta dɩd-o kʋlʋ maama na pɛ o dwe-o kʋntʋ tɩn, dɩ o na nɛ yazurǝ bɩdwɩ baŋa nɩ te tɩn. Kɔgɔ kʋm maama ma ni o na tagɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Zezi laan ma ta dɩd-o o wɩ: «A bukɔ, nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ te tɩn mʋ pɛ n na yazurǝ. Ve sɩ Wɛ wʋ́ wǝli-m.» ");
INSERT INTO xsm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zezi ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, nɔɔnʋ wʋdoŋ ma nuŋi Zayirusi sɔŋɔ o ba o ta dɩd-o o wɩ: «N bukɔ wʋm tɩga. Daa yɩ ta n yaarɩ karanyɩna kam.» ");
INSERT INTO xsm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zezi na ni kʋntʋ tɩn, o ma ta dɩ Zayirusi o wɩ: «Yɩ ta n fʋna. Za n weeni n kɩ n wʋ-dɩdʋa dɩ amʋ, sɩ oó na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ba ma vu ba yi sɔŋɔ kʋm. Zezi ma zʋ. O ma wʋ sɛ sɩ nɔɔna da-o ba zʋ, kʋ na daɩ Pɩyɛɛrɩ dɩ Zan dɩ Zakɩ, dɩ bu wʋm nu dɩ o ko yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Balʋ maama na maŋɩ ba wʋ sɔŋɔ kʋm wʋnɩ tɩn maa keerǝ ba coosǝ bɩsankana kam ŋwaanɩ. Zezi ma ta dɩ ba o wɩ: «Á yɩ taá keerǝ, sɩ o wʋ tɩgɩ, o dɔ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","O na tagɩ kʋntʋ tɩn, ba maama ma mwan-o, bɛŋwaanɩ ba ye nɩ bu wʋm sɩɩnɩ o tɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Zezi laan ma vu o ja bɩsankana kam jɩŋa, yɩ o ta dɩd-o o wɩ: «A bu, zaŋɩ wɛɛnɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","O na tagɩ kʋntʋ tɩn, o ŋwɩa ma joori. O ma zaŋɩ wɛɛnɩ bɩdwɩ baŋa nɩ. Zezi ma ta dɩ ba sɩ ba kɩ wʋdiu ba pa bu wʋm sɩ o di. ");
INSERT INTO xsm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kʋ ma sʋ bu wʋm nu dɩ o ko lanyɩranɩ. Zezi ma kaanɩ-ba o wɩ, ba yɩ zaŋɩ ba ta ba brɩ nɔɔn-nɔɔnʋ woŋo kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zezi dɛɛn ma bǝŋi o karabiǝ fugǝ-bale bam sɩ ba la daanɩ jǝgǝ dɩdʋa. O ma pa-ba dam sɩ ba wanɩ ciciri maama ba zǝli nɔɔna yɩra nɩ, sɩ ba daarɩ ba pa nɔɔna na yazurǝ ba yawɩɩrʋ wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O ma tʋŋɩ-ba sɩ ba vu ba tɔɔlɩ Wɛ kwǝrǝ kam ba brɩ DƖ na lagɩ DƖ di paarɩ tɩte nɔɔna tɩtarɩ nɩ tɩn, sɩ ba daarɩ ba pa yawɩɩna na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O ma ta dɩ ba o wɩ: «Á na maa ve, á yɩ zaŋɩ á kwe kʋlʋkʋlʋ á wǝli da á ja vu. Á yɩ kwe nacǝgǝ naa tampɔgɔ naa wʋdiu naa sǝbu. Á yɩ kwe gwaarʋ tɩle tɩle á wǝli da. ");
INSERT INTO xsm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Á na ve á zʋ sɔŋɔ kʋlʋ maama á pǝni da, sɩ á taá zʋʋrɩ dáanɩ sɩ kʋ ba kʋ yi á viirim mɩmaŋa. ");
INSERT INTO xsm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ba nan daa na wʋ sɛ sɩ ba jeeri abam lanyɩranɩ, sɩ á nuŋi tɩʋ kʋm kʋntʋ nɩ. Á na maa viirǝ, sɩ á pɩɩsɩ á nɛ fogo kʋm á yagɩ da, sɩ kʋ pa nɔɔna bam lwarɩ nɩ ba wʋ kɩ lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Zezi na tagɩ kʋntʋ dɩ ba o ti tɩn, ba laan ma nuŋi ba tʋlɩ tɩ-balɛ sɩm maama. Je sɩlʋ maama ba na ve tɩn, ba ma tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam, yɩ ba pa nɔɔna yawɩɩrʋ je. ");
INSERT INTO xsm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galile Pɛ Erɔdɩ dɛɛn ni kʋlʋ maama Zezi dɩ o karabiǝ bam na wʋra ba kɩ tɩn. Kʋ ma pa o wʋbʋŋa vugimi daanɩ, bɛŋwaanɩ nɔɔna badaara tɛ Zezi woŋo ba wɩ, Zan mʋ joori o bi o yagɩ tʋʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Babam maa tɛ ba wɩ, Wɛ nijoŋnu Eli mʋ joori o ba lʋgʋ baŋa. Badonnǝ dɩ maa tɛ ba wɩ, kʋ yɩ faŋa faŋa Wɛ nijoŋnǝ bam dɩdʋa mʋ joori o bi. ");
INSERT INTO xsm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erɔdɩ ma ta o wɩ: «Kʋ nan na yɩ Zan, a maŋɩ a pa ba go o yuu. Nɔɔnʋ wʋntʋ nan yɩ nɔɔnʋ wɔɔ mʋ, yɩ o kɩ wo-kɩnkagɩla yalʋ maama a na ni ya ŋwa tɩn?» O maa tiini o kwaana, sɩ o na wʋlʋ na kɩ wǝǝnu tɩntʋ maama tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zezi karabiǝ bam dɛɛn ma joori ba vu o te. Ba ma ta ba brɩ-o ba na kɩ kʋlʋ maama tɩn. O ma pa ba tɔgɩ dɩd-o ba vu jǝgǝ kadoŋ ba yɩranɩ, yɩ ba daarɩ nɔn-kɔgɔ kʋm. Jǝgǝ kam ba na ve tɩn batwarɩ dɩ tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Betisayida. ");
INSERT INTO xsm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nɔn-kɔgɔ kʋm ma lwarɩ Zezi dɩ o karabiǝ bam na ve mɛ tɩn. Ba laan ma tɔgɩ ba kwaga. Ba ma vu ba yi Zezi te. O ma jeeri-ba lanyɩranɩ. O ma ŋɔɔnɩ o brɩ-ba Wɛ paarɩ dɩm na yɩ te tɩn, yɩ o daarɩ o pa balʋ maama na lagɩ yazurǝ tɩn na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Maŋa kalʋ wɛ na wʋra dɩ zʋʋrɩ tɩn, Zezi karabiǝ fugǝ-bale bam ma ba o te ba wɩ: «Pa nɔɔna bam vu sam wʋnɩ ba lagɩ wʋdiu ba di, dɩ pwǝgǝ je ba pǝni, bɛŋwaanɩ jǝgǝ kalʋ dɩbam na wʋra tɩn yɩ gaa wʋ mʋ. Wʋdiu tǝri yo.» ");
INSERT INTO xsm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","O ma lǝri-ba o wɩ: «Abam tɩtɩ mʋ wʋ́ pa-ba wʋdiu sɩ ba di.» Ba ma lǝr-o ba wɩ: «Dɩ́ jɩgɩ dɩpwa yanu dɩ kale sɩle má má mʋ, kʋ na daɩ sɩ dɩ́ vu dɩ́ yǝgi wʋdiu dɩ́ ja ba dɩ́ pa nɔn-kɔgɔ kʋntʋ maama.» ");
INSERT INTO xsm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kɔgɔ kʋm dɛɛn yɩ nɩnɛɛnɩ baara mʋrr-tɩnu mʋ (5.000), kʋ wǝli dɩ kaana dɩ biǝ dɩ. Zezi ma ta dɩ o karabiǝ bam o wɩ, ba pa nɔɔna bam pɔɔrɩ fiinnu fiinnu ba jǝni tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ba ma kɩ kʋntʋ. Nɔɔna bam maama ma jǝni tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Zezi laan ma kwe dɩpwa yanu yam dɩ kale sɩle sɩm, yɩ o kwǝni o yuu wɛɛnɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma fɔ fɔ wʋdiiru tɩm o maŋɩ o pa o karabiǝ bam, sɩ ba ja vu ba pa nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nɔɔna bam maama ma di ba su ba daarɩ. Ba na di ba daarɩ kʋlʋ tɩn, ba ma pɛ cicwǝǝru tɩlʋ na daarɩ tɩn ba su tɩtwarʋ fugǝ-tɩle. ");
INSERT INTO xsm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dɛ dɩdwɩ mʋ Zezi dɛɛn wʋra o warɩ Wɛ o yɩranɩ. O karabiǝ bam dɩ maa wʋ jǝgǝ kam kʋntʋ nɩ. O ma bwe-ba o wɩ: «Nɔɔna yǝni ba tɛ ba wɩ, amʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ba ma lǝr-o ba wɩ: «Badaara tɛ ba wɩ, nmʋ yɩ Zan wʋlʋ dɛɛn na miisi nɔɔna na wʋnɩ Wɛ ŋwaanɩ tɩn mʋ. Babam dɩ maa tɛ ba wɩ, nmʋ yɩ Wɛ nijoŋnu Eli mʋ. Badonnǝ dɩ maa tɛ ba wɩ, nmʋ yɩ faŋa faŋa Wɛ nijoŋnǝ bam dɩdʋa mʋ n joori n bi n yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O laan ma bwe-ba o wɩ: «Kʋ nan na yɩ abam, á bʋŋɩ sɩ amʋ yɩ wɔɔ mʋ?» Pɩyɛɛrɩ ma lǝr-o o wɩ: «Nmʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Zezi laan ma tiini o kaanɩ-ba, sɩ ba yɩ ta woŋo kʋntʋ ba brɩ nɔɔn-nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","O daa ma ta o wɩ: «Kʋ fɩn mʋ sɩ amʋ Nabiin-bu wʋm na yaara zanzan. Zwifǝ nakwa bam dɩ ba kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ bam mʋ wʋ́ culi amʋ. Baá gʋ-nɩ, yɩ a laan wʋ́ joori a bi da yatɔ dɛ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Zezi laan ma ta dɩ nɔɔna bam maama o wɩ: «Nɔɔnʋ wʋlʋ maama na lagɩ sɩ o taa tɔgɩ amʋ kwaga tɩn, kʋntʋ tu maŋɩ sɩ o vɩn o tɩtɩ wʋbʋŋa, sɩ o sɛ yaara dɛ maama, nɩ wʋlʋ na zɩŋɩ dagara o maa ve o tʋʋnɩ jǝgǝ te tɩn, sɩ o laan taa tɔgɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wʋlʋ maama nan na lagɩ sɩ o yɩrɩ o ŋwɩa tɩn, kʋntʋ tu wʋ́ ga-ka mʋ. Kʋ daarɩ, wʋlʋ maama na sɛ sɩ o ga o ŋwɩa amʋ ŋwaanɩ tɩn, kʋntʋ tu wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nɔɔnʋ nan na nɛ lʋgʋ baŋa wǝǝnu tɩm maama, yɩ o laan na gɛ ŋwɩa Wɛ tee nɩ, kʋ jɩgɩ bɛɛ nyɔɔrɩ mʋ kʋ pa-o? ");
INSERT INTO xsm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wʋlʋ maama na kwarɩ cavɩɩra amʋ ŋwaanɩ dɩ a taanɩ dɩm ŋwaanɩ tɩn, cavɩɩra wʋ́ ta jɩgɩ amʋ Nabiin-bu wʋm kʋntʋ tu ŋwaanɩ, maŋa kam a na wʋ́ joori a ba lʋgʋ baŋa dɩ paarɩ-zulǝ, nɩ a Ko Wɛ dɩ DƖ malɛsɩ sɩm na jɩgɩ paarɩ-zulǝ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔna balʋ zɩm na wʋ yo seeni tɩn badaara bá tɩ, yɩ baá na nɩ Wɛ paarɩ dɩm tu nɔɔna tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Zezi na tagɩ kʋntʋ tɩn, kʋ maŋɩ dɩ da nana na kɛ tɩn, o laan ma ja Pɩyɛɛrɩ dɩ Zan dɩ Zakɩ o vu o di piu yuu sɩ o warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Maŋa kam o na wʋra o warɩ Wɛ tɩn, o yibiyǝ ma lǝni. O gwaarʋ tɩm dɩ maa pɩɩrɩ parɩ parɩ, yɩ tɩ nyɩɩna. ");
INSERT INTO xsm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Nɔɔna bale ma da ba nuŋi ba yigǝ nɩ, ba na tiini ba jɩgɩ Wɛ paarɩ-zulǝ pooni lanyɩranɩ. Bantʋ yɩ Moyisi dɩ Eli mʋ. Ba ma zɩgɩ ba ŋɔɔnɩ dɩ Zezi. Ba maa wʋra ba tɛ o na wʋ́ vu o tɩ Zeruzalɛm nɩ, sɩ o ma ti kʋlʋ o na tu sɩ o tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɩyɛɛrɩ dɩ o donnǝ bam ma cɛ dɩ dɔɔnɩ. Ba laan na dɔ ba zaŋɩ tɩn, mʋ ba nɛ Zezi na jɩgɩ Wɛ paarɩ-zulǝ pooni kʋ gaalɩ te. Ba ma daarɩ ba na nɔɔna bale bam na zɩgɩ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Maŋa kam nɔɔna bale bam na lagɩ ba viiri tɩn, Pɩyɛɛrɩ ma ta dɩ Zezi o wɩ: «Dɩ́ Yuutu, dɩ́ na wʋ yo seeni tɩn, kʋ tiini kʋ lana kʋ pa dɩbam. Nan pa dɩ́ pu vwǝ yatɔ yo seeni, sɩ nmʋ dɩ Moyisi dɩ Eli taa zʋʋrɩ da.» O dɛɛn garɩ o ŋɔɔnɩ mʋ, sɩ o yǝri kʋlʋ o na jɩgɩ o tɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","O na wʋra o ŋɔɔnɩ kʋntʋ tɩn mʋ kunkwǝǝnu tu tɩ ba tɩ kwǝli-ba. Tɩ na kwǝli-ba tɩn, fʋʋnɩ ma ja Zezi karabiǝ bam lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ba ma ni kwǝrǝ na ŋɔɔnɩ kunkwǝǝnu tɩm wʋnɩ ka wɩ: «Wʋntʋ mʋ yɩ amʋ Bu wʋm a na kuri tɩn. Á nan taá cǝgi o taanɩ lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kwǝrǝ kam na ŋɔɔnɩ ka ti tɩn, ba ma daa wʋ nɛ nɔɔn-nɔɔnʋ ba wǝli Zezi nɩ. Da yam kʋntʋ ni nɩ ba ma cɩm, yɩ ba wʋ tagɩ kʋlʋ ba na nɛ tɩn ba brɩ nɔɔn-nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tɩga na pʋʋrɩ tɩn, Zezi ma tu piu kʋm yuu nɩ dɩ o karabiǝ bam. Nɔn-kɔgɔ zanzan ma jeer-o. ");
INSERT INTO xsm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nɔɔnʋ wʋdoŋ maa tɔgɩ o wʋ kɔgɔ kʋm wʋnɩ. O ma ta dɩ kwǝr-dɩa o wɩ: «Karanyɩna, popo, ba n nii a bu baŋa nɩ. Mʋ amʋ bu dɩdʋa, yɩ cicirǝ laan jɩg-o. ");
INSERT INTO xsm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maŋa kam cicirǝ kam na yǝni ka zaŋ-o tɩn, o da o kaasɩ mʋ, yɩ o yɩra saɩ pɔgɩ pɔgɩ, yɩ lile-puŋǝ tɔgɩ o ni ka nuŋǝ. Ka ma tiini ka yaar-o maŋa maama, yɩ ka na yǝni ka zaŋ-o, ka ba nuŋi o yɩra nɩ mwalɩ mwalɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kʋntʋ ŋwaanɩ mʋ a loori nmʋ karabiǝ bam sɩ ba zǝli-ka o yɩra nɩ, yɩ ba wʋ wanɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zezi ma lǝri o wɩ: «Abam zɩm nɔɔna bam brɩ á ba jɩgɩ wʋ-dɩdʋa dɩ amʋ, yɩ á ba kɩ lanyɩranɩ. Amʋ wʋ́ daanɩ abam tɩtarɩ nɩ a kɩ wʋ-zuru dɩ abam sɩ kʋ taa ve maŋa kɔɔ?» O laan ma ta dɩ nɔɔnʋ wʋm o wɩ: «Ja n bu wʋm n ba.» ");
INSERT INTO xsm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bu wʋm na maa ve o te kʋntʋ tɩn, cicirǝ kam daa ta ma dʋl-o ka dɩ tɩga nɩ, yɩ ka paɩ o yɩra saɩ pɔgɩ pɔgɩ. Zezi ma bagɩ cicirǝ kam o pa ka yag-o. O ma pa bu wʋm na yazurǝ. O laan ma joori o kɩ-o o ko wʋm jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nɔɔna bam maama ma na Wɛ dam dɩm na gaalɩ te, yɩ kʋ sʋ-ba zanzan. Nɔɔna maama dɛɛn yɩ yǝǝu dɩ kʋlʋ maama Zezi na kɩ tɩn. O laan ma ta dɩ o karabiǝ bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Cǝgi-na taanɩ dɩlʋ a na lagɩ a ta dɩ abam tɩn, sɩ á joŋi-dɩ lanyɩranɩ. Baá ja amʋ Nabiin-bu wʋm ba kɩ nɔɔna jɩŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba ma wʋ ni o taanɩ dɩm kuri. Dɩ kuri dɩm sǝgi mʋ dɩ ba, yɩ ba wʋ wanɩ ba joŋi-dɩ. Ba ma kwarɩ sɩ ba bwe-o ba nii. ");
INSERT INTO xsm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kantɔgɔ dɛɛn ma ba Zezi karabiǝ bam wʋ. Ba dɛɛn lagɩ sɩ ba lwarɩ, bantʋ wʋnɩ wɔɔ mʋ wʋ́ ta yɩ nɔn-kamunu o dwe ba maama. ");
INSERT INTO xsm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zezi ma lwarɩ ba na jɩgɩ kʋlʋ ba wʋbʋŋa nɩ tɩn. O ma ja bu balaŋa o pa o zɩgɩ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","O laan ma ta dɩ ba o wɩ: «Wʋlʋ maama na nɩgɩ bu wʋntʋ doŋ amʋ yɩrɩ ŋwaanɩ tɩn, kʋntʋ tu nɩgɩ amʋ mʋ. Wʋlʋ maama nan na nɩgɩ amʋ tɩn, kʋ yɩ o nɩgɩ Baŋa-Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn dɩ mʋ. Wʋlʋ nan na yɩ balaŋa abam maama wʋnɩ tɩn mʋ yɩ nɔn-kamunu cɩga cɩga.» ");
INSERT INTO xsm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zan ma ta o wɩ: «Dɩ́ Yuutu, dɩ́ ya nɛ nɔɔnʋ na zǝli ciciri nɔɔna yɩra nɩ dɩ nmʋ yɩrɩ. O nan na daɩ dɩbam kɔgɔ kʋm wʋ nɔɔnʋ tɩn, dɩ́ ma kwaanɩ sɩ dɩ́ cɩ-o, sɩ o daa yɩ taa kɩ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Zezi ma lǝri o wɩ: «Á ya wʋ maŋɩ sɩ á cɩ-o. Wʋlʋ maama na ba culi abam tɩn yɩ abam nɔɔnʋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Maŋa kam dɛɛn ma ba ka twɛ sɩ Wɛ kwe Zezi DƖ ja di DƖ sɔŋɔ. Zezi ma lɩ bʋŋa sɩ o yɔɔrɩ o kwe cwǝŋǝ o vu Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","O ma tʋŋɩ nɔɔna sɩ ba da o yigǝ ba vu. Ba ma vu ba yi Samari tiinǝ tɩʋ kʋdoŋ, sɩ ba ti wǝǝnu maama yigǝ sɩ o laan ba. ");
INSERT INTO xsm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tɩʋ kʋm nɔɔna bam ma wʋ sɛ sɩ ba jeer-o, ba na lwarɩ dɩ o maa ve Zeruzalɛm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","O karabiǝ bam bale Zakɩ dɩ Zan na ni kʋntʋ tɩn, ba ma ta ba wɩ: «Dɩ́ Yuutu, n lagɩ sɩ dɩ́ pa mini nuŋi wɛyuu nɩ dɩ ba dɩ cɔgɩ-ba na?» ");
INSERT INTO xsm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Zezi ma pipiri o nii-ba, yɩ o bagɩ-ba o wɩ: «Abam yǝri joro kʋlʋ na jɩgɩ abam tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Amʋ Nabiin-bu wʋm wʋ tu sɩ a cɔgɩ nɔɔna ŋwɩa, a tu sɩ a vrɩ-ba lwarɩm wʋnɩ mʋ.» Ba daa ma yɔɔrɩ tɩʋ kʋdoŋ ba vu. ");
INSERT INTO xsm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dɛ dɩdwɩ ba na wʋ cwǝŋǝ nɩ ba maa kɛ tɩn, nɔɔnʋ wʋdoŋ ma ta dɩ Zezi o wɩ: «Nmʋ na lagɩ n vu je sɩlʋ maama tɩn, aá da a vu.» ");
INSERT INTO xsm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zezi ma lǝr-o o wɩ: «Kʋ na yɩ yirǝ, bantʋ jɩgɩ bɔɔna ba tigi da. Zunǝ dɩ jɩgɩ pwǝru ba tigi da. Kʋ daarɩ amʋ Nabiin-bu wʋm ba jɩgɩ jǝgǝ sɩ a pǝni da a sin.» ");
INSERT INTO xsm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Zezi daa ma ta dɩ nɔɔnʋ wʋdoŋ o wɩ: «Zaŋɩ n ta n tɔgɩ-nɩ.» Nɔɔnʋ wʋm ma ta o wɩ: «A Yuutu, yagɩ sɩ a vu a kɩ a ko luǝ, sɩ a laan ba a tɔgɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Zezi ma lǝri o wɩ: «Nan yagɩ, sɩ balʋ na ba jɩgɩ ŋwɩa Wɛ tee nɩ tɩn taa kɩ ba lwi, sɩ nmʋ daarɩ n vu n tɔɔlɩ Wɛ kwǝrǝ kam n brɩ DƖ na lagɩ DƖ di paarɩ tɩte nɔɔna tɩtarɩ nɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nɔɔnʋ wʋdoŋ dɩ ma ta dɩd-o o wɩ: «A Yuutu, aá ba a taa tɔgɩ nmʋ. Nan pa-nɩ cwǝŋǝ sɩ a vu a banɩ a sɔŋɔ tiinǝ, sɩ a laan joori a ba.» ");
INSERT INTO xsm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zezi ma ta dɩd-o o wɩ: «Nɔɔnʋ wʋlʋ na jɩgɩ naan-vɔrɔ o maa vara yɩ o pipiri o nii o kwaga nɩ tɩn, kʋ brɩ sɩ kʋntʋ tu wʋbʋŋa pɔɔrɩ bɩle mʋ. Nɔɔnʋ wʋntʋ doŋ bá wanɩ Wɛ paarɩ dɩm tɩtʋŋa o tʋŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kʋntʋ kwaga nɩ dɩ́ Yuutu Zezi daa ta ma lɩ nɔɔna fusɩrpɛ (70), sɩ o tʋŋɩ-ba bale bale, sɩ ba da yigǝ ba vu mɛ maama o na lagɩ o vu tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O na lagɩ o tʋŋɩ-ba kʋntʋ tɩn, mʋ o tagɩ dɩ ba o wɩ: «Kʋ nyɩ dɩ faa na kɩ lanyɩranɩ, yɩ tɩntʋŋna fɩnfɩɩn yɩranɩ mʋ wʋra sɩ ba kɩ-kʋ te tɩn. Nan loori-na faa kʋm tu, sɩ o tʋŋɩ nɔɔna zanzan, sɩ ba vu ba kɩ o faa kʋm ba pa-o.» ");
INSERT INTO xsm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","O ma daarɩ o wɩ: «Ve-na! A na tʋŋɩ abam je sɩm kʋntʋ nɩ tɩn, abam nyɩ dɩ pǝlbiǝ na maa ve sɩ ba gwaanɩ nywǝnkuri wʋnɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Á na maa ve, yɩ kwe-na sǝbiǝ gan-lɔgɔdɩ, nan yɩ kwe-na tampɔgɔ, naa á taá jɩgɩ natra á wǝli da. Yɩ zɩgɩ-na cwǝŋǝ nɩ á daanɩ nɔɔn-nɔɔnʋ pwǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Á nan na yi sɔŋɔ kʋlʋ maama á na lagɩ á zʋ tɩn, sɩ á ta dɩ sɔŋɔ kʋm tiinǝ nɩ: ‹Wɛ wʋ́ pa abam yazurǝ.› ");
INSERT INTO xsm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɔɔnʋ na wʋra yɩ o soe wʋ-zuru, á yazurǝ yam wʋ́ ta wʋra dɩd-o. Wʋ-zuru-nyɩm nan na tǝrǝ, á yazurǝ yam wʋ́ joori ya ba á tɩtɩ te mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Taá zʋʋrɩ-na sɔŋɔ kʋm kʋntʋ wʋnɩ. Wʋdiu kʋlʋ maama ba na kɩ ba pa abam tɩn, sɩ á taá di kʋntʋ. Tɩntʋŋnʋ maŋɩ sɩ o taa joŋi o ŋwɩɩrʋ mʋ. Á yɩ zaŋɩ á tʋlɩ sam dɩdonnǝ. Á taá zʋʋrɩ dáanɩ, sɩ kʋ taa ve maŋa kalʋ á na wʋ́ ba á viiri tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Á na zʋ tɩʋ kʋlʋ maama, yɩ ba na jeeri abam lanyɩranɩ, sɩ á taá di wʋdiu kʋlʋ maama ba na kɩ ba pa abam tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","sɩ á pa yawɩɩna na yazurǝ, á daarɩ á ta dɩ ba nɩ: ‹Maŋa twɛ sɩ Baŋa-Wɛ di paarɩ á tɩtarɩ nɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kʋ daarɩ, á na zʋ tɩʋ kʋlʋ maama yɩ ba na wʋ sɛ sɩ ba jeeri abam, sɩ á nuŋi tɩʋ kʋm cwe wʋnɩ á ta dɩ ba nɩ: ");
INSERT INTO xsm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Abam tɩʋ kʋm fogo na taagɩ dɩbam nɛ sɩm tɩn, nii-na dɩ́ pɩɩsɩ-kʋ dɩ́ joori dɩ́ yagɩ da, sɩ kʋ brɩ nɩ abam wʋ kɩ lanyɩranɩ. Nan taá ye-na sɩ maŋa twɛ sɩ Baŋa-Wɛ di paarɩ nɔɔna tɩtarɩ nɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A nan lagɩ a ta abam sɩ, Wɛ sarɩya dɛ dɩm na yiǝ, Sodɔm tiinǝ bá tiini ba na lɛɛrʋ nɩ tɩʋ kʋntʋ tiinǝ na wʋ́ na lɛɛrʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Abam Korazin tiinǝ, á wʋ́ na lɛɛrʋ! Kʋ wǝli dɩ abam Betisayida tiinǝ dɩ wʋ́ na lɛɛrʋ! Bɛŋwaanɩ, wo-kɩnkagɩla yalʋ maama a na kɩ abam tee nɩ tɩn, yadonnǝ ya na kɩ Tiiri dɩ Sidɔn tiinǝ tee nɩ, bantʋ ya wʋ́ kɩ lɩla ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, yɩ ba ya wʋ́ zʋ gwar-zɩnzwara ba lo puru ba yuu nɩ, sɩ kʋ brɩ nɩ ba wʋrʋ tiini tɩ cɔgɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wɛ sarɩya dɛ dɩm na yiǝ, Tiiri dɩ Sidɔn tiinǝ bá tiini ba na lɛɛrʋ nɩ abam na wʋ́ na lɛɛrʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Abam Kapɛrnawum tiinǝ, á ga bʋŋɩ nɩ Wɛ lagɩ DƖ zǝŋi abam wɛyuu nɩ mʋ na? Aye. Abam nan lagɩ á tʋ tɩga nɩ mʋ á tu á kwaarɩ curu.» ");
INSERT INTO xsm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zezi daa ma ta dɩ o karabiǝ bam o wɩ: «Wʋlʋ maama na joŋi abam taanɩ tɩn, kʋntʋ tu joŋi amʋ taanɩ mʋ. Wʋlʋ maama nan na wʋ joŋi abam taanɩ tɩn, kʋ tu wʋ joŋi amʋ taanɩ mʋ. Wʋlʋ maama na wʋ joŋi amʋ taanɩ tɩn wʋ joŋi Baŋa-Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn taanɩ mʋ.» (Zezi na tagɩ kʋntʋ tɩn, o laan ma tʋŋɩ-ba yɩ ba vu.) ");
INSERT INTO xsm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kʋ na kɩ fɩɩn tɩn nɔɔna fusɩrpɛ bam ma joori ba ba Zezi te dɩ wʋpolo. Ba ma ta dɩd-o ba wɩ: «Dɩ́ Yuutu, ciciri tɩtɩ dɩ dɛ nmʋ yɩrɩ kɔrɔ ŋwaanɩ sɩ sɛ dɩbam ni.» ");
INSERT INTO xsm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","O ma lǝri-ba o wɩ: «A nɛ sʋtaanɩ na zɩgɩ wɛyuu nɩ dɩ tʋ tɩga nɩ, nɩ dʋa na pɩpɩla ka baga ka tu ka kwaarɩ tɩga te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nii-na, a pɛ abam dam sɩ á nɔ bɩsankwɩ dɩ nwaanʋ baŋa nɩ, sɩ á wanɩ sʋtaanɩ dɩ dɩ dam maama, yɩ tɩ tɩlʋtɩlʋ bá wanɩ abam woŋo tɩ kɩ. ");
INSERT INTO xsm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Á nan yɩ kɩ wʋpolo dɩ ciciri na sɛ abam ni tɩn ŋwaanɩ. Nan za á kɩ-na wʋpolo dɩ á yɩra na pʋpʋnɩ Wɛ-sɔŋɔ ŋwɩa tɔnɔ kʋm wʋnɩ tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maŋa kam kʋntʋ nɩ, Wɛ Joro kʋm dɛɛn pɛ Zezi na wʋpolo lanyɩranɩ. O laan ma kɩ o Ko Baŋa-Wɛ le o wɩ: «A Ko, nmʋ yɩ wʋlʋ na te wɛyuu dɩ tɩga baŋa maama tɩn. Nmʋ nan mʋ pɛ n cɩga kam sǝgi swan tiinǝ dɩ yiyiu tiinǝ tee nɩ, yɩ n daarɩ n pa balʋ na nyɩ dɩ bu-balɛ te tɩn lwarɩ ka kuri. A Ko, a kɩ nmʋ le. Nmʋ na kɩ kʋntʋ tɩn, kʋ yɩ n wʋbʋŋa na lagɩ kʋlʋ tɩn ŋwaanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«A Ko nan pɛ-nɩ dam wǝǝnu maama baŋa nɩ. Nɔɔn-nɔɔnʋ bá wanɩ o lwarɩ Wɛ Bu wʋm na yɩ wʋlʋ, kʋ na daɩ o Ko yɩranɩ. Nɔɔn-nɔɔnʋ dɩ nan bá wanɩ o lwarɩ a Ko Wɛ na yɩ wʋlʋ, kʋ na daɩ amʋ wʋlʋ na yɩ DƖ Bu wʋm tɩn yɩranɩ, kʋ wǝli dɩ amʋ na lagɩ sɩ a pa nɔɔnʋ wʋlʋ maama lwarɩ DƖ na yɩ wʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","O laan ma pipiri o nii o karabiǝ bam seeni, yɩ o ŋɔɔnɩ dɩ bantʋ ba yɩranɩ o wɩ: «Á jɩgɩ yu-yoŋo dɩ á yiǝ na naɩ wo-kamunnu tɩlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lwarɩ-na sɩ, faŋa faŋa Wɛ nijoŋnǝ zanzan dɩ pwa zanzan dɛɛn jɩgɩ tɩɩna sɩ ba ya na kʋlʋ maama abam na naɩ lele tɩn, yɩ ba wʋ wanɩ ba na. Ba dɛɛn jɩgɩ tɩɩna sɩ ba ya ni Wɛ taanɩ dɩlʋ abam na ni tɩn, yɩ ba wʋ wanɩ ba ni-dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wɛ cullu karanyɩna dɩdʋa dɛɛn tu Zezi te, sɩ o maŋ-o o nii o swan na yɩ te tɩn. O ma zaŋɩ o bwe-o o wɩ: «Karanyɩna, amʋ nan wʋ́ kɩ ta mʋ sɩ a joŋi ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ?» ");
INSERT INTO xsm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zezi ma ta dɩd-o o wɩ: «Bɛɛ mʋ pʋpʋnɩ Wɛ cullu tɔnɔ kʋm wʋnɩ? Bɛɛ mʋ n yǝni n karɩmɩ da?» ");
INSERT INTO xsm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nɔɔnʋ wʋm ma lǝri o wɩ: «Kʋ pʋpʋnɩ kʋ wɩ, ta n soe n Yuutu Baŋa-Wɛ dɩ n bɩcarɩ maama, dɩ n wʋ maama, dɩ n dam maama, dɩ n wʋbʋŋa maama, sɩ n kwǝri n ta n soe n doŋ nɩ n tɩtɩ te.» ");
INSERT INTO xsm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zezi ma lǝri o wɩ: «N tagɩ cɩga. Nan ta n kɩ kʋntʋ, sɩ nń na ŋwɩa Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nɔɔnʋ wʋm ma lagɩ sɩ o pa o tɩtɩ bʋra. O ma daa bwe Zezi o wɩ: «Amʋ doŋ mʋ wɔɔ?» ");
INSERT INTO xsm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zezi dɛɛn ma maŋɩ mɩmaŋa o ma lǝr-o o wɩ: «Nɔɔnʋ wʋdoŋ mʋ zɩgɩ Zeruzalɛm nɩ o nuŋi o maa ve tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Zeriko. O ma vu o maŋɩ dɩ nɔn-vɩrna. Nɔn-vɩrna bam ma zi-o ba vrɩ o gwaarʋ dɩ o wǝǝnu maama. Ba ma mag-o ba bǝri, yɩ ba daarɩ ba duri ba viiri. ");
INSERT INTO xsm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","O na tigi da kʋntʋ tɩn, Wɛ kaanɩm tu dɩdʋa dɩ ya wʋ cwǝŋǝ kam kʋntʋ nɩ o maa ve. O na maa ve tɩn, o ma na nɔɔnʋ wʋm na tigi o yigǝ nɩ. O ma ywǝri o tɔgɩ daa o kɛ. ");
INSERT INTO xsm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wɛ-digǝ tɩntʋŋnʋ wʋlʋ na yɩ Leviti tu tɩn dɩ maa tɔgɩ da o maa kɛa. O na yi jǝgǝ kam tɩn, o ma na nɔɔnʋ wʋm na tigǝ. O dɩ daa ma ywǝri o tɔgɩ daa o kɛ. ");
INSERT INTO xsm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samari tu wʋdoŋ dɩ dɛɛn maa wʋ bǝrǝ nɩ. O ma vu o yi nɔɔnʋ wʋm na tigi mɛ tɩn. O na nɛ-o tɩn, o ŋwaŋa ma zʋ-o. ");
INSERT INTO xsm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","O ma vu o te. O ma kwe nugǝ dɩ sana o ma zarɩ o fufwǝlǝ yam, yɩ o daarɩ o vɔ-ya. O laan ma kwe-o o daŋɩ o tɩtɩ bɩnaga baŋa nɩ o ja vu nɔɔnʋ wʋdoŋ vǝrǝ-digǝ. Ba na yi da tɩn, o maa jɩg-o o nii lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tɩga na pʋʋrɩ tɩn, Samari tu wʋm ma zaŋɩ sɩ o kɛ. O ma lɩ sǝbu-dala yale o pa wʋlʋ na te vǝrǝ-digǝ kam tɩn. O ma ta dɩd-o o wɩ: ‹Ta n nii nɔɔnʋ wʋm baŋa nɩ n pa-nɩ. Sǝbu kʋm na wʋ yi, maŋa kalʋ a na wʋ́ joori a ba tɩn, aá ŋwɩ kʋlʋ maama n na wʋ́ kɩ n wǝli da tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Zezi laan ma bwe-o o wɩ: «Kʋntʋ tɩn, bantʋ batɔ wʋnɩ, wɔɔ mʋ yɩ nɔɔnʋ wʋlʋ nɔn-vɩrna bam na vrɩ tɩn doŋ cɩga cɩga?» ");
INSERT INTO xsm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Karanyɩna kam ma lǝri o wɩ: «Wʋlʋ wʋm na jaanɩ o ŋwaŋa tɩn.» Zezi laan ma ta dɩd-o o wɩ: «Nan ve sɩ n dɩ ta n kɩ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zezi dɩ o karabiǝ bam daa maa wʋ cwǝŋǝ nɩ ba veǝ. O ma vu o yi tɩʋ kʋdoŋ. Kaanɩ wʋdoŋ maa wʋra, o yɩrɩ mʋ Marɩtɩ. O ma jeeri Zezi lanyɩranɩ ba sɔŋɔ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marɩtɩ nyaanɩ dɩ maa wʋra, o yɩrɩ mʋ Mari. O ma jǝni tɩga nɩ Zezi tee nɩ, yɩ o cǝgi o taanɩ dɩm maama. ");
INSERT INTO xsm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mari na je kʋntʋ tɩn, Marɩtɩ ma tiini o cɛ tɩtʋŋa nɩ yɩ o liǝ. O ma vu Zezi te o wɩ: «A Yuutu, nii amʋ na zɩgɩ a tʋŋa a yɩranɩ, yɩ a nyaanɩ wʋm cɩm. Nmʋ yigǝ tǝrǝ na? Ta dɩd-o sɩ o zaŋɩ o wǝli-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dɩ́ Yuutu Zezi ma lǝr-o o wɩ: «Marɩtɩ, Marɩtɩ, nmʋ na li zanzan tɩn mʋ jɩgɩ-m kʋ yaara. ");
INSERT INTO xsm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Woŋo kʋdoŋ yɩranɩ mʋ daarɩ. Mari mʋ lɩ kʋlʋ na lana tɩn sɩ o kɩ, yɩ nɔɔn-nɔɔnʋ bá wanɩ o cɩ-kʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dɛ dɩdwɩ mʋ Zezi dɛɛn ve jǝgǝ kadoŋ sɩ o warɩ Wɛ. O na warɩ Wɛ o ti tɩn, o karabiǝ bam dɩdʋa ma ta dɩd-o o wɩ: «Dɩ́ Yuutu, brɩ dɩbam dɩ́ na wʋ́ ta warɩ Wɛ te tɩn, nɩ Zan dɩ na brɩ o karabiǝ bam sɩ ba taa warɩ Wɛ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Zezi ma ta dɩ ba o wɩ: «Abam na lagɩ á warɩ Wɛ, sɩ á taá warɩ tɩntʋ doŋ: ‹Dɩbam Ko, sɩ nmʋ yɩrɩ na tiǝ dɩ zulǝ, sɩ n paarɩ ba. ");
INSERT INTO xsm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ta n pa dɩbam wʋdiu dɛ maama sɩ kʋ maŋɩ dɩbam. ");
INSERT INTO xsm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yagɩ dɩ́ lwarɩm n ma n cɛ dɩbam, nɩ dɩbam dɩ na yagɩ dɩ́ cɛ balʋ na kɩ dɩbam lwarɩm tɩn. Yɩ pa dɩ́ na maŋɩm dɩlʋ na wʋ́ pa dɩ́ tʋ tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zezi daa ma ta dɩ o karabiǝ bam o wɩ: «Wɛ-loro nyɩ dɩ nmʋ na jɩgɩ n ciloŋ yɩ n zaŋɩ n vu o te tɩtɩɩ kʋrʋ nɩ n ta dɩd-o n wɩ: ‹A ciloŋ, popo a loori-m sɩ n pa-nɩ dɩpwa yatɔ, ");
INSERT INTO xsm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sɩ vǝru mʋ nuŋi yigǝ yigǝ o ba a te, yɩ a ba jɩgɩ kʋlʋkʋlʋ sɩ a pa-o sɩ o di.› ");
INSERT INTO xsm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nmʋ ciloŋ wʋm maa zɩgɩ digǝ kam wʋnɩ o ta dɩ nmʋ o wɩ: ‹Yɩ ta n jɩgɩ-nɩ n yaara, sɩ mancoŋo pɩ yɩ amʋ dɩ a biǝ maama nan tigi dɩ́ dɔ mʋ. A bá wanɩ a zaŋɩ a wǝli-m.› ");
INSERT INTO xsm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N ciloŋ wʋm wʋ́ wanɩ o ta kʋntʋ doŋ na? A nan lagɩ a ta abam sɩ, o ya zɩ wʋ zaŋɩ o pa nmʋ wʋdiu kʋm á ciloŋo kʋm ŋwaanɩ dɩ, nmʋ na zɩgɩ da taan n loor-o dɩ baarɩ tɩn, o laan wʋ́ sɛ o zaŋɩ o pa-m kʋlʋ maama n na lagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","A nan lagɩ a ta abam sɩ á loori-na Wɛ, sɩ DƖ wʋ́ pa abam kʋlʋ á na lagɩ tɩn. Beeri-na kʋlʋ á na lagɩ tɩn, sɩ á wʋ́ na. Magɩ-na boro, sɩ baá pʋrɩ ba pa abam. ");
INSERT INTO xsm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bɛŋwaanɩ wʋlʋ maama na loori Wɛ sɩ DƖ pa-o woŋo tɩn wʋ́ joŋi. Wʋlʋ maama na beeri woŋo Wɛ tee nɩ tɩn wʋ́ na-kʋ. Baá pʋrɩ ba pa wʋlʋ maama na magɩ boro tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Abam wʋlʋ na jɩgɩ bu yɩ o na loori-m kalǝŋǝ, nmʋ wʋ́ sɛ n pa-o bɩsankwɩa na? ");
INSERT INTO xsm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O na loori cɩcarɩ, nń sɛ n kwe nɔŋɔ n pa-o na? ");
INSERT INTO xsm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aye. Abam wʋrʋ na ba lana yɩ á ta ye sɩ á pa á biǝ wo-laarʋ tɩlʋ ba na lagɩ tɩn, dɩ́ Ko Wɛ dɩlʋ na wʋ wɛyuu nɩ yɩ DƖ lana DƖ dwe abam tɩn bá pa nɔɔna balʋ na loori-DƖ DƖ Joro kʋm tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dɛ dɩdʋa mʋ Zezi dɛɛn zǝli cicirǝ nɔɔnʋ wʋdoŋ yɩra nɩ. Cicirǝ kam ya pɛ nɔɔnʋ wʋm ji mɩmaa mʋ. Ka na yagɩ o yɩra tɩn, o laan maa ŋɔɔna. Kʋ ma sʋ nɔn-kɔgɔ kʋm lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nɔɔna badaara na nɛ tɩn ba maa wɩ: «O na waɩ o zǝli sʋtaana tɩn, kʋ yɩ sʋtaana-pɛ Belizebuli dam ŋwaanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ba badaara maa kwaanɩ sɩ ba maŋɩ o dam dɩm ba nii, yɩ ba wɩ, o maŋɩ sɩ o kɩ wo-kɩnkagɩlɩ dɩlʋ na wʋ́ brɩ-ba nɩ o dam dɩm sɩɩnɩ dɩ nuŋi Wɛ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zezi ma lwarɩ ba wʋbʋŋa na yɩ te tɩn. O ma ta dɩ ba o wɩ: «Tɩʋ kʋlʋ paarɩ na pɔɔrɩ kuni bɩle yɩ ba jɩgɩ daanɩ tɩn, kʋ bá daanɩ kʋ cɔgɩ. Kampwara na zʋ sɔŋɔ kʋlʋ wʋ tɩn, kʋʋ́ tʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sʋtaana-pɛ dam dɩm na sɩɩnɩ dɩ pɔɔrɩ bɩle, dɩ paarɩ dɩm bá daanɩ dɩ cɔgɩ. Abam na tɛ á wɩ, kʋ yɩ Belizebuli dam ŋwaanɩ mʋ a waɩ a zǝli sʋtaana tɩn, mʋ pɛ a ta kʋntʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kʋ na sɩɩnɩ kʋ yɩ amʋ jɩgɩ Belizebuli dam mʋ a maa zǝli sʋtaana, abam nɔɔna bam dɩ nan maɩ dam dɩm kʋntʋ mʋ ba maa zǝli-ya na? Abam tɩtɩ nɔɔna bam na kɩ te tɩn mʋ brɩ sɩ cɩga tǝri á tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kʋ nan yɩ Wɛ tɩtɩ dam mʋ a maɩ a zǝli sʋtaana. Kʋ maa brɩ nɩ Wɛ maŋɩ DƖ ba abam te DƖ di paarɩ nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sʋtaana-pɛ nan nyɩ dɩ nɔn-dɩdɛɛrʋ na jɩgɩ taŋa dɩ cɩna o maa yɩrɩ o sɔŋɔ te tɩn. O na yɩrɩ-kʋ tɩn, o jɩjɩgɩrʋ tɩm bá je. ");
INSERT INTO xsm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nɔɔnʋ wʋdoŋ nan na tuǝ, yɩ o dam na dwe nɔn-dɩdɛɛrʋ wʋm, kʋntʋ tu wʋ́ wanɩ nɔn-dɩdɛɛrʋ wʋm. O laan wʋ́ vrɩ o taŋa dɩ o cɩna yalʋ o na tɩɩgɩ tɩn maama. O daarɩ o kwalɩmɩ o jɩjɩgɩrʋ tɩm maama o maŋɩ o pa nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nɔɔnʋ wʋlʋ maama nan na daɩ a nɔɔnʋ tɩn yɩ a dʋm mʋ. Nɔɔnʋ wʋlʋ maama nan na ba tɔgɩ o laɩ a nɔɔna o kɩ jǝgǝ dɩdʋa tɩn, o jagɩ-ba mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Cicirǝ na nuŋi nɔɔnʋ yɩra nɩ, ka laan wʋ́ vu ka beeri kapwǝrǝ yigǝ mʋ, sɩ ka lagɩ je ka sin da. Ka nan na beeri ka ga, ka laan wʋ́ ta ka wɩ: ‹Aá joori a vu a na nuŋi mɛ tɩn mʋ, a taa wʋra.› ");
INSERT INTO xsm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka na joori ka vu nɔɔnʋ wʋm te yɩ ka na sɩ jǝgǝ kam fɔgɩ ka kwɛ lanyɩranɩ, ");
INSERT INTO xsm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ka laan wʋ́ joori ka vu ka lagɩ ciciri sɩrpɛ sɩlʋ na tiini sɩ yɩ balwaarʋ sɩ dwe ka tɩtɩ tɩn. Sɩ ma tɔgɩ daanɩ sɩ vu sɩ zʋʋrɩ da. Kʋntʋ, nɔɔnʋ wʋm laan wʋ́ tiini o na cam kʋ dwǝni faŋa.» ");
INSERT INTO xsm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zezi na zɩgɩ o ŋɔɔnɩ kʋntʋ tɩn, kaanɩ wʋdoŋ tɔgɩ o wʋ kɔgɔ kʋm wʋnɩ, o ma ta dɩ kwǝr-dɩa o wɩ: «Kaanɩ wʋlʋ na lʋgɩ-m yɩ n ŋɔgɩ o yɩlɩ tɩn mʋ yɩ yu-yoŋo tu.» ");
INSERT INTO xsm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zezi ma lǝri o wɩ: «Balʋ na ni Wɛ kwǝrǝ yɩ ba sɛ tɩn mʋ jɩgɩ yu-yoŋo ba dwe dɩdɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nɔn-kɔgɔ kʋm ma tiini kʋ pɩɩnɩ daanɩ. Zezi daa ma ta o wɩ: «Zɩm nɔɔna yɩ nɔn-balwaarʋ mʋ. Ba lagɩ sɩ a kɩ wo-kɩnkagɩlɩ mʋ a brɩ-ba, sɩ kʋ taa yɩ maana kʋ pa-ba. Ba nan bá na, kʋ na daɩ wo-kɩnkagɩlɩ dɩlʋ na maŋɩ dɩ kɩ Wɛ nijoŋnu Zonasɩ tee nɩ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wʋntʋ dɛɛn brɩ Wɛ dam Niniivi tiinǝ tee nɩ, sɩ kʋ taa yɩ maana kʋ pa-ba. Amʋ Nabiin-bu wʋm dɩ wʋ́ ji maana zɩm nɔɔna bam ŋwaanɩ, nɩ kʋ dɛɛn na kɩ Zonasɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wɛ sarɩya dɛ dɩm na yiǝ, pa-kana kalʋ dɛɛn na te Saba tɩʋ faŋa faŋa tɩn wʋ́ zaŋɩ o di zɩm nɔɔna bantʋ sarɩya, yɩ o vɩ-ba bʋra. Wʋntʋ dɛɛn zaŋɩ o tɩtɩ tɩʋ kʋlʋ na tiini kʋ yɩ yigǝ yigǝ nɩ tɩn o ba Pɛ Salɔmɔn te, sɩ o cǝgi o swan taanɩ dɩm. Wʋlʋ nan na dwe Salɔmɔn tɩn wʋ abam tee nɩ, yɩ á ba lagɩ sɩ á cǝg-o. ");
INSERT INTO xsm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniivi tiinǝ dɩ wʋ́ zaŋɩ dɛ dɩm kʋntʋ nɩ ba di zɩm nɔɔna bantʋ sarɩya, bɛŋwaanɩ Zonasɩ na ve ba te o tɔɔlɩ-ba Wɛ kwǝrǝ kam tɩn, ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ. Wʋlʋ na dwe Zonasɩ tɩn nan wʋ abam tee nɩ, yɩ á wʋ sɛ-o.» ");
INSERT INTO xsm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Nɔɔnʋ na jɩgɩ kanɩa, o bá sɛ o tarɩgɩ-ka o zɩgɩ gugoro nɩ, naa o pu-ka tɩtɔgɔ kuri nɩ. O nan wʋ́ kwe-ka o palɩ wɛɛnɩ mʋ, sɩ balʋ na zʋ digǝ kam wʋ tɩn taa naɩ pooni dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nmʋ yiǝ mʋ nyɩ nɩnɛɛnɩ kanɩa kalʋ na paɩ n yɩra jɩgɩ pooni te tɩn. Kʋntʋ tɩn, n yiǝ na lana, kʋ paɩ n yɩra maama wʋ pooni wʋnɩ mʋ. N yiǝ nan na ba lana, kʋ paɩ n yɩra maama wʋ lim wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kʋntʋ ŋwaanɩ, ta n yɩrɩ n tɩtɩ sɩ pooni dɩlʋ na wʋ nmʋ wʋnɩ tɩn daa yɩ zaŋɩ dɩ ji lim. ");
INSERT INTO xsm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nmʋ yɩra maama na jɩgɩ pooni yɩ lim dɩ fɩnfɩɩn tǝrǝ, kʋʋ́ pa n yɩra maama wʋ pooni wʋnɩ mʋ, nɩnɛɛnɩ kanɩa na paɩ pooni wʋra te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zezi dɛɛn na ŋɔɔnɩ wǝǝnu tɩm kʋntʋ o ti tɩn, Farizɩan tu dɩdʋa ma bǝŋ-o, sɩ o da o vu o sɔŋɔ o di wʋdiu. O ma vu o zʋ sɔŋɔ kʋm o jǝni sɩ o di. ");
INSERT INTO xsm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farizɩan tu wʋm ma na sɩ Zezi wʋ sanɩ o jɩa sɩ kʋ tɔgɩ ba cullu tɩm cwǝŋǝ. Kʋ ma sʋ-o. ");
INSERT INTO xsm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dɩ́ Yuutu Zezi ma ta dɩd-o o wɩ: «Ei! Abam Farizɩan tiinǝ na lagɩ á di wʋdiu, á yǝni á fɔgɩ á sɩn á zwɩ dɩ á kabǝli kwɛ lanyɩranɩ. Kʋ daarɩ abam tɩtɩ nan su dɩ digiru mʋ. Á wʋrʋ su dɩ ŋwɩɩnɩ dɩ wo-balwaarʋ kǝm. ");
INSERT INTO xsm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Abam yɩ jwǝǝru mʋ. Wɛ nan mʋ wʋ kɩ wǝǝnu maama wʋrʋ dɩ tɩ kwɛ na? ");
INSERT INTO xsm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Á nan maŋɩ sɩ á kwe á na jɩgɩ kʋlʋ tɩn á pa yinigǝ tiinǝ dɩ á wʋrʋ maama. Á na kɩ kʋntʋ, á kʋlʋkʋlʋ daa bá ta jɩgɩ digiru. ");
INSERT INTO xsm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Abam Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Bɛŋwaanɩ, kʋ na maŋɩ kʋ yɩ dwǝ dwi maama ba zɩ ba daga dɩ, á yǝni á lɩ kʋlʋ na yɩ Wɛ nyɩm tɩn á pa-DƖ. Kʋ lana. Kʋ daarɩ abam yigǝ tǝrǝ dɩ cɩga tɔgɩm dɩ Wɛ sono. Kʋ ya maŋɩ sɩ á taá kɩ tɩntʋ wǝǝnu tɩm mʋ, sɩ á yɩ yagɩ Wɛ niǝ yadaara yam. ");
INSERT INTO xsm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Abam Farizɩan tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Bɛŋwaanɩ, á na zʋ á Wɛ-di sɩm, á lagɩ je-kamunnu mʋ sɩ á taá je yigǝ nɩ. Á na ve yaga, á lagɩ sɩ nɔɔna maama taa tui ba zuli abam. ");
INSERT INTO xsm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Lɛɛrʋ wʋ á yuu nɩ. Bɛŋwaanɩ á nyɩ dɩ yibeelǝ yalʋ na saarɩ ya daarɩ tɩga yɩ nɔɔna tɔgɩ ya baŋa ba kɛa yɩ ba yǝri ya ni nɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wɛ cullu karanyɩna dɩdʋa ma lǝri Zezi taanɩ dɩm o wɩ: «Karanyɩna, nmʋ na jɩgɩ wǝǝnu tɩlʋ n ŋɔɔnɩ tɩn, n twɩ dɩbam dɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Zezi ma lǝri o wɩ: «Abam balʋ na yɩ Wɛ cullu karanyɩna tiinǝ tɩn, lɛɛrʋ wʋ á dɩ yuu nɩ. Bɛŋwaanɩ abam yǝni á yaarɩ nɔɔna dɩ wo-dɛɛrʋ sɩ ba taa tɔga. Kʋ maa nyɩ dɩ á na pa ba zɩŋɩ zɩla yalʋ na dunǝ ya dwe ba zɩŋɩm tɩn, yɩ abam tɩtɩ ba sɛ sɩ á twǝri zɩla yam fɩnfɩɩn dɩ á zǝŋi. ");
INSERT INTO xsm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Lɛɛrʋ wʋ á yuu nɩ. Bɛŋwaanɩ abam yǝni á fɔgɩ á kɩ faŋa faŋa Wɛ nijoŋnǝ bam yibeelǝ. Kʋ nan yɩ á kwǝ-nakwa mʋ gʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Á kǝm dɩm brɩ nɩ á sɛ kǝm-balwaarʋ tɩlʋ á kwǝ-nakwa bam na kɩ tɩn. Bantʋ dɛɛn gʋ Wɛ nijoŋnǝ bam, yɩ abam tɩtɩ laan fɔgɩ á kwɛ ba yibeelǝ yam. ");
INSERT INTO xsm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Abam na tɔgɩ á kwǝ kǝnǝ kʋntʋ tɩn, Wɛ dɩlʋ na maŋɩ DƖ ye wǝǝnu maama tɩn tagɩ abam ŋwaanɩ DƖ wɩ: ‹Aá tʋŋɩ a nijoŋnǝ dɩ a tɩntʋŋna ba tee nɩ. Ba ma wʋ́ ja ba badaara ba gʋ, yɩ baá yaarɩ badaara.› ");
INSERT INTO xsm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kʋntʋ ŋwaanɩ Wɛ wʋ́ pa á na cam zanzan, nɩ kʋ yɩ abam tɩtɩ mʋ gʋ Wɛ nijoŋnǝ balʋ maama ba na gʋ lʋgʋ pulim nɩ sɩ kʋ ba kʋ yi zɩm tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kʋ na puli Abɛlɩ nɩ sɩ kʋ ba kʋ kweeli dɩ Zakari wʋlʋ ba na gʋ Wɛ kaanɩm bimbim dɩm dɩ DƖ di-laa kʋm tɩtarɩ nɩ tɩn. A lagɩ a ta cɩga mʋ dɩ abam sɩ, kǝm-balwaarʋ tɩm kʋntʋ maama caa wʋ́ ta wʋ zɩm nɔɔna bam yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Wɛ cullu karanyɩna tiinǝ-ba, lɛɛrʋ wʋ á yuu nɩ. Bɛŋwaanɩ á yǝni á cɩ nɔɔna sɩ ba yɩ lwarɩ Wɛ cɩga kam. Abam tɩtɩ wʋ sɛ sɩ á joŋi-ka, yɩ á daarɩ á wʋ pɛ balʋ na lagɩ ba joŋi-ka tɩn cwǝŋǝ sɩ ba joŋi.» ");
INSERT INTO xsm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Zezi laan ma nuŋi jǝgǝ kam kʋntʋ nɩ o viiri. Wɛ cullu karanyɩna tiinǝ bam dɩ Farizɩan tiinǝ bam maa ba lagɩ o taanɩ dɩ fɩnfɩɩn dɩ. Ba ma yaar-o dɩ bwiǝ zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ba maa lagɩ sɩ ba pa o ŋɔɔnɩ o tusi, sɩ ba wanɩ ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Maŋa kam kʋntʋ nɩ kɔ-fɔrɔ zanzan ya lagɩ daanɩ Zezi tee nɩ. Ba dɛɛn yi nɔɔna mʋrrʋ mʋrrʋ mʋ. Ba tiini ba pɩɩnɩ daanɩ yɩ ba nɔnɩ daanɩ. Zezi ma puli o ta dɩ o karabiǝ bam o wɩ: «Á fɔgɩ á cɩ á tɩtɩ, sɩ á yɩ pa Farizɩan tiinǝ bam dɩ abam ba dabɩlɩ dɩm, dɩ ba na yɩ pipiri-nyɩna yɩ ba sǝgi ba kɩ wo-balwaarʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kʋlʋ maama na sǝgi nɔɔna tee nɩ tɩn, kʋ jwa wʋ́ ba kʋ lwarɩ jaja. ");
INSERT INTO xsm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kʋntʋ tɩn, abam na sǝgi á ta kʋlʋ maama tɩn wʋ́ nuŋi pooni mʋ sɩ nɔɔna maama ni. Abam na waasɩ woŋo kʋlʋ digǝ wʋnɩ tɩn, nɔɔna wʋ́ di nayuu ba tɔɔlɩ-kʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","A cilonnǝ-ba, a lagɩ a ta abam sɩ á yɩ taá kwarɩ fʋʋnɩ dɩ balʋ na waɩ ba gʋɩ á yɩra yam yɩ ba daa warɩ ba kɩ abam kʋlʋkʋlʋ ba wǝli da tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A nan wʋ́ brɩ abam á na maŋɩ sɩ á taá kwarɩ wʋlʋ tɩn. Á maŋɩ sɩ á taá kwarɩ Wɛ mʋ, bɛŋwaanɩ dɩntʋ jɩgɩ dam sɩ DƖ gʋ abam sɩ DƖ daarɩ DƖ dɩ abam min-tɩʋ nɩ. A lagɩ a ta abam sɩ dɩntʋ mʋ á maŋɩ sɩ á taá kwarɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kʋ na yɩ kabǝmbǝli, ba yǝni ba yǝgi sɩntʋ mwalɩ mwalɩ mʋ. Wɛ nan ba swe sɩ dɩdʋa dɩdʋa ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wɛ maŋɩ DƖ ye abam yuuywe sɩm ni na maɩ te tɩn. Á yɩ taá kwarɩ fʋʋnɩ, sɩ abam dɩdʋa dɩdʋa jɩgɩ kuri á dwe kabǝmbǝli zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","A lagɩ a ta abam sɩ nɔɔnʋ wʋlʋ maama na zɩgɩ nabiinǝ yigǝ nɩ o brɩ jaja sɩ o yɩ a nɔɔnʋ tɩn, amʋ Nabiin-bu wʋm dɩ wʋ́ zɩgɩ kʋntʋ tu kwaga nɩ a brɩ nɩ o yɩ a nɔɔnʋ Wɛ malɛsɩ sɩm yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kʋ daarɩ, wʋlʋ maama na vɩn amʋ nabiinǝ yigǝ nɩ tɩn, amʋ dɩ wʋ́ vɩn kʋntʋ tu Wɛ malɛsɩ sɩm yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wʋlʋ maama na ŋɔɔnɩ wo-balwaarʋ o pa amʋ Nabiin-bu wʋm tɩn, Wɛ wʋ́ sɛ sɩ DƖ ma cɛ kʋntʋ tu. Wʋlʋ nan na ŋɔɔnɩ o twɩ Wɛ Joro kʋm tɩn, Wɛ bá sɛ sɩ DƖ ma cɛ-o. ");
INSERT INTO xsm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nɔɔna wʋ́ ja abam ba vu ba saŋɩ Zwifǝ nakwa tee nɩ dɩ tɩʋ kʋm yigǝ tiinǝ tee nɩ dɩ dɩdɛɛra tee nɩ. Ba na kɩ abam kʋntʋ, sɩ á yɩ taá liǝ dɩ á na wʋ́ ŋɔɔnɩ kʋlʋ sɩ á ma vrɩ á tɩtɩ, naa á na wʋ́ tʋlɩ taanɩ dɩm te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kantʋ maŋa kam nɩ Wɛ Joro kʋm wʋ́ pa á lwarɩ á na maŋɩ sɩ á ta kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nɔɔnʋ dɩdʋa mʋ tɔgɩ o wʋ kɔgɔ kʋm wʋnɩ, o ma ta dɩ Zezi o wɩ: «Karanyɩna, a loori-m sɩ n ta a zɩmbaarʋ wʋm, sɩ o kwe wǝǝnu tɩlʋ dɩbam ko na tɩgɩ o daarɩ tɩn o maŋɩ amʋ nyɩm o pa-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Zezi ma lǝr-o o wɩ: «A ciloŋ. Wɔɔ mʋ tiŋi amʋ sɩ a di abam taanɩ naa sɩ a maŋɩ á jɩjɩgɩrʋ a pa abam?» ");
INSERT INTO xsm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","O laan ma ta dɩ ba maama o wɩ: «Á taá yɩrɩ á tɩtɩ dɩ wo-swǝnǝ zanzan. Nɔɔnʋ jɩjɩgɩrʋ na daga te, tɩ bá wanɩ o ŋwɩa tɩ yɩrɩ, o na maŋɩ o yɩ nadum te dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Zezi laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: «Nadum wʋdoŋ mʋ wʋra. O maa jɩgɩ karɩ sɩ na kɩ wʋdiiru zanzan sɩ pa-o. ");
INSERT INTO xsm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","O ma bʋŋɩ o wɩ: A nan wʋ́ kɩ ta mʋ? Je daa tǝrǝ sɩ a kɩ a wʋdiiru tɩm maama da.» ");
INSERT INTO xsm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","O laan ma bʋŋɩ o wɩ: «A na wʋ́ kɩ te tɩn, aá magɩ a tuli sɩm maama mʋ a dɩ tɩga nɩ, sɩ a daarɩ a lɔ tuli-zɛ, sɩ a wanɩ a pɛ a wo-vaalʋ tɩm dɩ a wǝǝnu tɩm maama a kɩ da.» ");
INSERT INTO xsm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A laan wʋ́ ta a wʋnɩ a wɩ: «A jɩgɩ wǝǝnu tɩlʋ maama a na lagɩ tɩn sɩ kʋ taa ve bɩna kɔgɔ kɔgɔ. Liǝ daa bá ja-nɩ. Aá ta kɩ a wʋbʋŋa na lagɩ te tɩn, a di yɩ a nyɔa yɩ a kɩ wʋpolo.» ");
INSERT INTO xsm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wɛ ma ta dɩd-o DƖ wɩ: «Nmʋ yɩ joro mʋ. Tɩtɩɩ dɩntʋ wʋnɩ aá joŋi n ŋwɩa. Kʋntʋ tɩn, wɔɔ mʋ wʋ́ ta te wǝǝnu tɩlʋ maama n ya na jɩgɩ tɩn?» ");
INSERT INTO xsm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Kʋ yɩ kʋntʋ doŋ mʋ dɩ wʋlʋ maama na tiŋi jɩjɩgɩrʋ zanzan o pa o tɩtɩ yɩ o ba jɩgɩ kʋlʋkʋlʋ Wɛ tee nɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zezi ma ta dɩ o karabiǝ bam o wɩ: «Kʋntʋ ŋwaanɩ mʋ a lagɩ a ta abam sɩ á yɩ taá jɩgɩ liǝ dɩ lʋgʋ baŋa kʋlʋkʋlʋ, kʋ na yɩ á ni-wʋdiu, naa á na wʋ́ zʋ gwaarʋ tɩlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bɛŋwaanɩ á ŋwɩa garɩ wʋdiiru. Yɩra yalʋ Wɛ na pɛ abam tɩn dɩ maa garɩ gwaarʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nan maanɩ-na á nii bacangaarʋ na yɩ te tɩn. Tɩ ba duǝ, yɩ tɩ ba zagɩ mɩna. Tɩ ba jɩgɩ tuli dɩ tikǝri sɩ tɩ kɩ wʋdiiru da. Kʋ nan yɩ Wɛ mʋ nii tɩ baŋa nɩ dɩ tɩ ni-wʋdiu. Abam nan tiini á jɩgɩ kuri á dwe zunǝ bam. ");
INSERT INTO xsm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Abam wʋlʋwʋlʋ bá wanɩ o toŋi o ŋwɩa dɩ fɩnfɩɩn dɩ, o na maŋɩ o li te dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Á bá wanɩ kʋ fɩnfɩɩn dɩ á kɩ, bɛɛ nan mʋ yɩ á jɩgɩ liǝ dɩ wǝǝnu tɩlʋ maama na daarɩ tɩn? ");
INSERT INTO xsm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Maanɩ-na á nii ga-punnu tɩm lam na yɩ te tɩn. Tɩntʋ nan warɩ tɩ tʋŋɩ, yɩ tɩ warɩ gwaarʋ tɩ sɔ. Nan taá ye-na nɩ, tɩntʋ jɩgɩ lam tɩ dwe Pɛ Salɔmɔn dɛɛn na maŋɩ o zʋʋrɩ gwar-ŋʋnnʋ tɩlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kʋ nan na yɩ gaarʋ tɩm kʋntʋ, tɩntʋ ba jɩgɩ dɛ dɩ nɔɔna na zwɛ-tɩ. Dɩ kʋntʋ dɩ, Wɛ ta mʋ paɩ tɩ jɩgɩ lam kʋntʋ doŋ. Kʋntʋ ŋwaanɩ, kʋ na yɩ abam, Wɛ tiini DƖ nii abam baŋa nɩ. Bɛɛ mʋ yɩ á ba kɩ á wʋ-dɩdʋa dɩ Wɛ? ");
INSERT INTO xsm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Á yɩ taá jɩgɩ wʋbʋŋ-fara dɩ á na wʋ́ kɩ te sɩ á na wʋdiu á di tɩn. Á yɩ taá kɩ liǝ dɩ kʋntʋ woŋo. ");
INSERT INTO xsm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Lʋgʋ baŋa nɔɔna balʋ na yǝri Wɛ tɩn mʋ tiini ba bʋŋɩ wǝǝnu tɩm kʋntʋ maama wʋbʋŋa. Abam Ko Wɛ nan maŋɩ DƖ ye nɩ abam maŋɩ sɩ á taá jɩgɩ wǝǝnu tɩm kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Abam maŋɩ sɩ á pa á wʋbʋŋa taa tɔgɩ Wɛ paarɩ dɩm mʋ. Á na kɩ kʋntʋ, Wɛ laan wʋ́ wǝli abam woŋo kʋlʋ na daarɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","A nɔɔna bam á na ba daga tɩn, yɩ pa-na fʋʋnɩ taa jɩgɩ abam. Abam Ko Wɛ wʋbʋŋa mʋ lagɩ sɩ DƖ pa abam tɔgɩ á di DƖ paarɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kwe-na á jɩjɩgɩrʋ tɩm á yǝgi, sɩ á daarɩ á maŋɩ tɩ sǝbu kʋm á ma wǝli yinigǝ tiinǝ. Kʋntʋ mʋ á kwe á jɩjɩgɩrʋ á tiŋi Wɛ-sɔŋɔ nɩ, sǝbiǝ gan-lɔgɔdɩ na bá cɔgɩ mɛ tɩn. Á na tiŋi jɩjɩgɩrʋ Wɛ tee nɩ, tɩ daa bá je. Ŋwɩɩna daa bá wanɩ ba ŋɔ-tɩ, yɩ tʋa bá wanɩ ka mu-tɩ ka cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bɛŋwaanɩ, abam jɩjɩgɩrʋ na tigi mɛ tɩn, á bɩcara dɩ tigi dáanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Zezi ta ma ta o wɩ: «Á taá fɔgɩ á cʋ á tɩtɩ, nɩ nɔɔna balʋ yuutu na nuŋi o vu sɩ o di kadiri candiǝ yɩ ba jɩgɩ tɩɩna sɩ o joori o ba tɩn. Ba ma fɔgɩ ba vɔ ba gwaarʋ dɩ vwɩ, yɩ ba tarɩgɩ ba min-zwǝǝnu ba zɩgɩ ba tee nɩ. Ba yuutu wʋm na tu o yi manco-pɩɩna o magɩ boro, ba laan wʋ́ wanɩ ba zaŋɩ lɩla ba pʋrɩ ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ba yuutu wʋm na joori o ba, yɩ tɩntʋŋna balʋ na zɩgɩ ba niǝ yɩ ba ba dɔ tɩn, kʋʋ́ ji wʋpolo dɩ ba. A lagɩ a ta cɩga mʋ dɩ abam sɩ, ba yuutu wʋm laan wʋ́ pa ba jǝni ba di wʋdiu. O ma wʋ́ vɔ o gɔrɔ dɩ vʋa, sɩ o kwe wʋdiu kʋm o vu o zɩgɩ sɩ ba di. ");
INSERT INTO xsm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","O nan na joori o ba tɩtɩɩ kʋrʋ nɩ dɩ, yɩ o tɩntʋŋna bam ta na zɩgɩ ba niǝ yɩ ba ba dɔa, kʋʋ́ ji wʋpolo dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Á taá ye sɩ, sɔŋɔ tu ya na lwarɩ maŋa kalʋ ŋwɩɩnʋ na lagɩ o ba tɩn, o ya bá pa ŋwɩɩnʋ wʋm na cwǝŋǝ o zʋ o ŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kʋntʋ ŋwaanɩ abam maŋɩ sɩ á cɩ á tɩtɩ mʋ, sɩ amʋ Nabiin-bu wʋm lagɩ a ba maŋa kalʋ abam na ba tɩɩna nɩ aá ba tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pɩyɛɛrɩ ma bwe Zezi o wɩ: «Dɩ́ Yuutu, nmʋ na maŋɩ mɩmaŋa yantʋ tɩn, kʋ yɩ dɩbam yɩranɩ ŋwaanɩ mʋ naa nɔɔna maama ŋwaanɩ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dɩ́ Yuutu Zezi ma lǝri o wɩ: «Wɔɔ mʋ yɩ tɩntʋŋ-ŋʋm wʋlʋ na jɩgɩ wʋbʋŋa tɩn? O nyɩ nɩnɛɛnɩ tɩntʋŋnʋ wʋlʋ o yuutu na yagɩ o tɩtʋŋa o pa-o yɩ o daarɩ o vu cwǝŋǝ tɩn. O yuutu wʋm ma lɩ-o sɩ o taa nii o donnǝ tɩntʋŋna bam baŋa nɩ, sɩ o daarɩ o taa pa-ba ba ni-wʋdiu dɛ maama. ");
INSERT INTO xsm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","O sɔŋɔ tu wʋm na joori o ba, yɩ o na piini dɩ o kɩ kʋlʋ maama o na pɛ-o sɩ o kɩ tɩn, tɩntʋŋnʋ wʋm kʋntʋ laan wʋ́ na wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A lagɩ a ta cɩga mʋ dɩ abam sɩ, o yuutu wʋm laan wʋ́ pa o taa nii o jɩjɩgɩrʋ maama baŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tɩntʋŋnʋ wʋm nan na bʋŋɩ o wɩ, o yuutu wʋm daanɩ zanzan yɩ o ba tui, yɩ o na jɩgɩ o donnǝ tɩntʋŋ-baara dɩ tɩntʋŋ-kaana bam o maga, o di o gaala, yɩ o nyɔ sana o bugǝ, ");
INSERT INTO xsm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tɩntʋŋnʋ wʋm kʋntʋ yuutu wʋm laan wʋ́ joori o ba, dɛ dɩm tɩntʋŋnʋ wʋm na ba jɩgɩ tɩɩna dɩ maŋa kalʋ o na wʋ́ ba tɩn. O yuutu wʋm na tu o pɩɩr-o kʋntʋ, o laan wʋ́ pa o na cam, yɩ o daarɩ o pa o da dɩ balʋ na vɩn Wɛ cɩga kam tɩn o na yaara zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tɩntʋŋnʋ wʋlʋ maama na lwarɩ o yuutu wʋbʋŋa na lagɩ sɩ o kɩ kʋlʋ tɩn, yɩ o na wʋ sɛ sɩ o ja o tɩtɩ o kɩ-kʋ, kʋntʋ tu wʋ́ na magɩrʋ zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kʋ daarɩ, wʋlʋ na yǝri o yuutu na lagɩ sɩ o kɩ kʋlʋ tɩn, yɩ o na kɩ kʋlʋ na maŋɩ sɩ ba mag-o tɩn, kʋntʋ tu wʋ́ na magɩrʋ fɩnfɩɩn mʋ. Wʋlʋ maama ba na pɛ wǝǝnu zanzan tɩn, baá bwe-o wǝǝnu zanzan bwiǝ. Nɔɔnʋ wʋlʋ na joŋi wǝǝnu zanzan sɩ o taa nii-tɩ tɩn, Wɛ wʋ́ bwe-o wǝǝnu zanzan kʋ ja gaalɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zezi daa ta ma ta o wɩ: «Amʋ tu lʋgʋ baŋa sɩ a tarɩgɩ mini mʋ a ma zwɛ-kʋ. A nan ya lagɩ dɩ a wʋ maama sɩ mini dɩm na maŋɩ dɩ ya tarɩgɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amʋ nan maŋɩ sɩ a zʋ yaara wʋ, nɩnɛɛnɩ a na wʋ́ miisi na wʋnɩ te tɩn mʋ. A nan wʋ wʋ-cɔgɔ wʋnɩ mʋ, sɩ kʋ taa ve maŋa kam kʋ na wʋ́ kɩ kʋ ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amʋ na tu lʋgʋ baŋa tɩn, á bʋŋɩ sɩ kʋ yɩ sɩ a pa nɔɔna fɔgɩ daanɩ mʋ na? Aye. A tu sɩ a pa nɔɔna pɔɔrɩ daanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kʋ na puli zɩm kʋ maa ve, sɔŋɔ dɩdʋa wʋnɩ nɔɔna banu na wʋra, baá pɔɔrɩ daanɩ batɔ dɩ bale. ");
INSERT INTO xsm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ko dɩ o bu wʋ́ pɔɔrɩ daanɩ. Nu dɩ o bukɔ dɩ wʋ́ pɔɔrɩ daanɩ. Kaanɩ dɩ o barʋ nu dɩ wʋ́ pɔɔrɩ daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zezi laan ma ta dɩ nɔn-kɔgɔ kʋm o wɩ: «Á na nɛ kunkwǝǝnu na wʋra tɩ zaŋa mɛ seeni dʋa na zɩgɩ da ka nɩ tɩn, á yǝni á ta lɩla sɩ dʋa lagɩ ka nɩ, yɩ kaá sɩɩnɩ ka nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kʋ daarɩ gungun-kʋrrʋ viu na wʋra kʋ fulǝ, á yǝni á wɩ lʋn-wɩa maa bɩɩna, yɩ kʋʋ́ sɩɩnɩ kʋ kɩ kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Abam yɩ pipiri-nyɩna mʋ. Abam waɩ á nii wɛyuu dɩ tɩga baŋa á ma lwarɩ tɩga kam yibiyǝ na wʋ́ ta yɩ te tɩn. Bɛɛ nan mʋ yɩ á warɩ á lwarɩ wǝǝnu tɩlʋ na wʋra tɩ kɩ lele tɩn kuri? ");
INSERT INTO xsm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bɛŋwaanɩ mʋ yɩ abam ba bʋŋa, sɩ á lwarɩ kʋlʋ na lana tɩn sɩ á taá kɩa? ");
INSERT INTO xsm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kʋ nyɩ dɩ nɔɔnʋ na jaanɩ-m o vu o saŋɩ sarɩya jǝgǝ nɩ te tɩn. Abam ta na wʋ cwǝŋǝ nɩ á maa ve tɩn, sɩ n kwaanɩ n pa á fɔgɩ daanɩ. Kʋ na daɩ kʋntʋ, o laan wʋ́ ja nmʋ o kɩ sarɩya-diru wʋm jɩŋa nɩ. Wʋntʋ dɩ laan ma wʋ́ kɩ nmʋ o tɩntʋŋnʋ jɩŋa nɩ, sɩ o kɩ nmʋ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A lagɩ a ta nmʋ sɩ nń ta n wʋra taan. N na wʋ ŋwɩ jɩnɩ dɩm maama n ti, ba bá yagɩ-m.» ");
INSERT INTO xsm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kantʋ maŋa kam nɩ nɔɔna badonnǝ maa ba Zezi te, yɩ ba ta dɩd-o Galile tiinǝ badonnǝ taanɩ. Gʋvɩrma tu Pilatɩ dɛɛn jaanɩ bantʋ o gʋ maŋa kalʋ ba na wʋra ba kaanɩ Baŋa-Wɛ tɩn, o pa ba jana nuŋi ka gwaanɩ dɩ vara jana. ");
INSERT INTO xsm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Zezi ma lǝri nɔɔna bam o wɩ: «Galile tiinǝ bantʋ na tiini ba na cam kʋntʋ doŋ tɩn, á bʋŋɩ sɩ kʋ yɩ ba na tiini ba yɩ nɔn-balwaarʋ ba dwe ba donnǝ bam tɩn ŋwaanɩ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aye, kʋ daɩ kʋntʋ. Abam tɩtɩ dɩ na wʋ lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩm, abam maama dɩ wʋ́ cɔgɩ kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kʋ ta na yɩ nɔɔna fugǝ-nana balʋ ya na tɩgɩ Silʋa nɩ maŋa kam wɛyuu digǝ na tʋ ba baŋa nɩ tɩn, á bʋŋɩ nɩ kʋ yɩ ba na maŋɩ sɩ ba na cɔgɩm kʋ dwǝni Zeruzalɛm tiinǝ badonnǝ bam tɩn ŋwaanɩ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aye, kʋ daɩ kʋntʋ. Abam tɩtɩ na wʋ lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩm, abam maama dɩ wʋ́ cɔgɩ kʋntʋ doŋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Zezi laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: «Nɔɔnʋ mʋ wʋra. O ma jǝri kapʋrʋ o kara wʋnɩ. O ma vu sɩ o nii, oó na kʋ biǝ o gwǝri na. O ma wʋ nɛ. ");
INSERT INTO xsm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kʋ na ba lǝri biǝ tɩn, o ma ta dɩ o tɩntʋŋnʋ wʋm o wɩ: ‹Nii, dɔɔn jɩgɩ bɩna yatɔ mʋ a na tui a laga kʋ biǝ yɩ a ba naɩ kʋlʋkʋlʋ. Nan goni-kʋ n dɩ tɩga nɩ, sɩ kʋ zɩgɩ da kafɛ mʋ›. ");
INSERT INTO xsm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tɩntʋŋnʋ wʋm ma lǝr-o o wɩ: ‹A yuutu, yagɩ sɩ kʋ daa kɩ bɩnɩ dɩdʋa kʋ wǝli da. Aá kʋ goŋo a kaagɩ kʋ maama yɩ a kɩ pʋpɔnɔ da. ");
INSERT INTO xsm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bɩnɩ daa na yiǝ yɩ kʋ na lǝgi biǝ, kʋ lana. Kʋ nan daa ta na wʋ lǝgi, dɩ́ laan wʋ́ go-kʋ dɩ́ dɩ tɩga nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zwifǝ bam siun dɛ dɩdoŋ dɛɛn ma yi. Zezi maa wʋ ba Wɛ-digǝ kam nɩ o brɩ-ba Wɛ taanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kaanɩ wʋdoŋ maa tɔgɩ o wʋra, cicirǝ na jɩg-o ka yaara dɩ yawɩʋ taan bɩna fugǝ-nana, ka pa o tii mʋ, o warɩ o kwǝni wɛɛnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zezi na nɛ-o tɩn, o ma ta dɩd-o sɩ o ba o te. O laan ma ta dɩd-o o wɩ: «Kaanɩ, n nɛ bwǝlim, n sin dɩ n yaara yam.» ");
INSERT INTO xsm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","O na tagɩ kʋntʋ tɩn, o ma zi o jɩa o baŋa nɩ. Bɩdwɩ baŋa nɩ mʋ kaanɩ wʋm kwǝni wɛɛnɩ. O na kwǝni wɛɛnɩ tɩn, o ma tee Baŋa-Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Zwifǝ Wɛ-digǝ kam yuutu wʋm na nɛ Zezi na kɩ te ba siun dɛ dɩm nɩ yɩ o pa kaanɩ wʋm na yazurǝ tɩn, o bam ma zaŋɩ. O ma ta dɩ kɔgɔ kʋm o wɩ: «Wɛ pɛ dɩbam da yardʋ mʋ sɩ dɩ́ ta maa tʋŋɩ dɩ́ tɩtʋŋa. Kʋntʋ tɩn, á maŋɩ sɩ á taá tui da yam kʋntʋ nɩ mʋ sɩ á na yazurǝ, sɩ kʋ daɩ siun dɛ dɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dɩ́ Yuutu Zezi ma lǝr-o o wɩ: «Abam yɩ pipiri-nyɩna mʋ. Abam wɔɔ mʋ wʋ́ ta jɩgɩ o nabɩa naa o bɩnaga yɩ o ba bwǝli-ka o ja vu sɩ ka nyɔ na siun dɛ dɩm nɩ? ");
INSERT INTO xsm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kʋntʋ tɩn, kaanɩ wʋntʋ na yɩ Abraham dwi tu yɩ sʋtaanɩ ya vɔ-o dɩ yawɩʋ bɩna fugǝ-nana tɩn, kʋ culi sɩ a bwǝl-o a yagɩ siun dɛ dɩm nɩ sɩ o sin dɩ o yawɩʋ kʋm na?» ");
INSERT INTO xsm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","O na tagɩ kʋntʋ tɩn, kʋ ma pa balʋ na vɩ-o tɩn na cavɩɩra. Kʋ daarɩ nɔn-kɔgɔ kʋm maama maa jɩgɩ wʋpolo zanzan dɩ wo-kɩnkagɩla yalʋ maama o na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zezi daa ma ta o wɩ: «Wɛ paarɩ dɩm nyɩ dɩ bɛɛ? A ma bɛɛ mʋ a maŋɩ-dɩ a brɩ abam? ");
INSERT INTO xsm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wɛ paarɩ dɩm nyɩ dɩ nɔɔnʋ na kwe wo-duu na yɩ mɩmɩɩnʋ o vu o du o kadugǝ nɩ. Wo-duu kʋm kʋntʋ ma nuŋi, yɩ kʋ tiini kʋ ji tu-kamunu. Zunǝ laan ma ba ba sɔ ba pwǝru tiu kʋm yuu nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zezi daa ma ta o wɩ: «A ta wʋ́ ma bɛɛ mʋ a maŋɩ Wɛ paarɩ dɩm na nyɩ te tɩn a brɩ abam? ");
INSERT INTO xsm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dɩ nyɩ dɩ kaanɩ na kwe dabɩlɩ o gwaanɩ dɩ dɩpɛ muni zwɩ-zɛ sɩtɔ te tɩn. Dɩ laan ma pa dɩpɛ muni dɩm maama fʋlɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zezi dɛɛn wʋ cwǝŋǝ nɩ o maa ve Zeruzalɛm. O na maa ve tɩn, o tʋlɩ tɩɩnɩ dɩm maama yɩ o brɩ-ba Wɛ taanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɔɔnʋ wʋdoŋ ma bwe-o o wɩ: «A Yuutu, nɔɔna fɩnfɩɩn yɩranɩ mʋ wʋ́ na vrɩm na?» Zezi ma ta dɩ nɔɔna bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Á taá cʋ á tɩtɩ sɩ á kwaanɩ á da ni dɩlʋ na pɩɩnɩ tɩn á zʋ Wɛ paarɩ dɩm wʋ. A lagɩ a ta abam sɩ nɔɔna zanzan wʋ́ ba ba beeri sɩ ba zʋ, yɩ ba bá wanɩ ba na cwǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Maŋa kam na yiǝ, yɩ sɔŋɔ tu zaŋɩ o pɩ o mancoŋo, abam laan wʋ́ ba á zɩgɩ pooni nɩ á magɩ boro, yɩ á loori á wɩ: ‹Dɩ́ Yuutu, popo, pʋrɩ sɩ dɩ́ zʋ.› O laan wʋ́ lǝri o wɩ: ‹A yǝri abam na nuŋi mɛ.› ");
INSERT INTO xsm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Abam laan wʋ́ ta wɩ: ‹Dɩbam ya tɔgɩ dɩ nmʋ dɩ́ jǝni dɩ́ di wʋdiu. Kʋ yɩ dɩbam tɩʋ kʋm cwe sɩm wʋnɩ mʋ n zɩgɩ da n brɩ Wɛ taanɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","O nan ta wʋ́ lǝri abam o wɩ: ‹A yǝri abam. Joori-na daa nɩ, abam kǝm-balwaarʋ tiinǝ bam.› ");
INSERT INTO xsm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kʋ na kɩ abam kʋntʋ, á wʋ́ na Abraham dɩ Yizakɩ dɩ Zakɔbɩ na je Wɛ paarɩ dɩm wʋnɩ, kʋ wǝli dɩ Wɛ nijoŋnǝ bam maama. Abam tɩtɩ nan bá na cwǝŋǝ sɩ á zʋ. Abam wʋ́ maŋɩ mɛ yaara na wʋra yɩ nɔɔna keerǝ yɩ ba dʋnɩ ba nwa tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nɔɔna wʋ́ nuŋi lʋgʋ baŋa je maama nɩ ba ba ba zʋ Wɛ paarɩ dɩm wʋ, yɩ ba jǝni ba di ywǝǝni daanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Á taá ye nɩ, nɔɔna badaara zɩm na yɩ kwaga tiinǝ tɩn wʋ́ ba ba ji yigǝ tiinǝ. Badaara dɩ na maŋɩ ba yɩ yigǝ tiinǝ tɩn wʋ́ joori ba ji kwaga tiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Maŋa kam kʋntʋ nɩ mʋ Farizɩan badonnǝ tu Zezi te, yɩ ba ta dɩd-o ba wɩ: «Yagɩ yo seeni sɩ n vu jǝgǝ kadoŋ. Bɛŋwaanɩ Pɛ Erɔdɩ lagɩ sɩ o pa ba gʋ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O ma lǝri-ba o wɩ: «Ve-na á ta á brɩ nasɩa kam nɩ, zɩm da yantʋ nɩ a maŋɩ sɩ a taa zǝli sʋtaana, sɩ a kwǝri a pa nɔɔna na yazurǝ. Da yatɔ dɛ nɩ, a laan wʋ́ yi a kweelim jǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","A nan maŋɩ sɩ a daa kwe a cwǝŋǝ a taa kɛa zɩm dɩ jwaanɩ dɩ jwa yigǝ nɩ, bɛŋwaanɩ kʋ bá wanɩ sɩ wʋlʋ na yɩ Wɛ nijoŋnu tɩn ga o ŋwɩa yɩ kʋ daɩ Zeruzalɛm nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hǝii! Zeruzalɛm tiinǝ-ba, á yǝni á gʋ Wɛ nijoŋnǝ yɩ á dʋlɩ nɔɔna balʋ Wɛ na tʋŋɩ abam tee nɩ tɩn dɩ kandwa. Kuni zanzan mʋ a ya lagɩ sɩ a la abam nɔn-biǝ a kɩ daanɩ sɩ a taa nii á baŋa nɩ, nɩnɛɛnɩ coro na kukwǝri kʋ biǝ kʋ kɩ kʋ vwana kuri nɩ te tɩn, yɩ abam wʋ sɛ. ");
INSERT INTO xsm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kʋntʋ tɩn, Wɛ laan wʋ́ dwanɩ DƖ jɩa abam tɩʋ kʋm baŋa nɩ sɩ kʋ ji di-dwǝǝnu. Á taá ye nɩ, á daa bá na-nɩ sɩ kʋ taa ve maŋa kalʋ á na wʋ́ ta wɩ: ‹Zuli-na wʋlʋ na tu dɩ́ Yuutu Wɛ yɩrɩ ŋwaanɩ tɩn.› » ");
INSERT INTO xsm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Siun dɛ dɩdoŋ dɛɛn ma yi. Zezi ma vu Farizɩan yigǝ tu dɩdʋa sɔŋɔ o zʋ sɩ o di wʋdiu. O na wʋra tɩn, ba maa kwaanɩ ba yɩr-o, sɩ ba nii o na wʋ́ kɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ya-fʋla tu ma ba o zɩgɩ Zezi yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zezi na nɛ-o tɩn, o ma bwe Wɛ cullu karanyɩna tiinǝ dɩ Farizɩan tiinǝ bam o wɩ: «Dɩbam cullu paɩ cwǝŋǝ sɩ dɩ́ pa nɔɔnʋ na yazurǝ siun dɛ dɩm nɩ naa kʋ culǝ?» ");
INSERT INTO xsm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba maa cɩm. O ma dwe nɔɔnʋ wʋm o pa o na yazurǝ, yɩ o yag-o o wɩ, o ve. ");
INSERT INTO xsm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","O laan ma bwe-ba o wɩ: «Abam wʋlʋ bu na tʋ vʋlɩ wʋnɩ siun dɛ nɩ, n bá kɩ lɩla n vu n vaŋ-o n lɩ na? Kʋ na yɩ n nabɩa dɩ, n bá vu n lɩ-ka na?» ");
INSERT INTO xsm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba maa warɩ ba lǝr-o kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nɔɔna balʋ na tu sɩ ba tɔgɩ ba di wʋdiu Farizɩan tu wʋm sɔŋɔ nɩ tɩn maa lagɩ jǝŋǝ je sɩ ba jǝni. Zezi ma na nɩ ba lagɩ je-laarʋ je mʋ sɩ ba jǝni da. O na nɛ kʋntʋ tɩn, o ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Nɔɔnʋ na kɩ kadiri candiǝ yɩ o bǝŋi-m sɩ n ba n di, yɩ kwaanɩ sɩ n jǝni nɔn-kamunu jǝŋǝ je nɩ. Nmʋ na kɩ kʋntʋ, yɩ nɔn-kɔrɔ na tuǝ, ");
INSERT INTO xsm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","sɔŋɔ tu wʋlʋ na bǝŋi abam tɩn wʋ́ ba o ta dɩ nmʋ o wɩ: ‹Zaŋɩ sɩ n daarɩ jǝgǝ kam n pa nɔɔnʋ wʋntʋ.› Nmʋ laan wʋ́ zaŋɩ n vu n jǝni kwaga kwaga mʋ dɩ cavɩɩra. ");
INSERT INTO xsm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kʋ daarɩ, ba na bǝŋi-m sɩ n vu n tɔgɩ n di candiǝ, ve n jǝni kwaga kwaga. Nmʋ na kɩ kʋntʋ, yɩ sɔŋɔ tu wʋm na tu o na-m, o laan wʋ́ ta o wɩ: ‹A ciloŋ, zaŋɩ n ba yigǝ n jǝni.› Kʋntʋ wʋ́ pa n na zulǝ nɔɔna bam maama yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bɛŋwaanɩ, wʋlʋ na zǝŋi o tɩtɩ tɩn, Wɛ wʋ́ tu kʋntʋ tu. Wʋlʋ nan na tu o tɩtɩ tɩn, Wɛ wʋ́ zǝŋi kʋntʋ tu.» ");
INSERT INTO xsm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Zezi laan ma ta dɩ sɔŋɔ tu wʋm o wɩ: «Nmʋ na lagɩ n kɩ wʋdi-fɔrɔ n pa nɔɔna, kʋ na yɩ wɩa nɩ naa dɩdaanɩ, sɩ n yɩ bǝŋi n cilonnǝ dɩ n cʋrrʋ dɩ n donnǝ nadunǝ. Nmʋ na kɩ kʋntʋ, bantʋ wʋ́ wanɩ ba joori ba dɩ kɩ-m kʋntʋ doŋ ba ma ŋwɩ jɩnɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nmʋ nan na lagɩ n kɩ candiǝ, sɩ n bǝŋi balʋ na yɩ yinigǝ tiinǝ dɩ kwaarʋ dɩ gwanɩ dɩ lilwǝ tɩn, sɩ ba ba ba di. ");
INSERT INTO xsm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nmʋ na kɩ kʋntʋ, nmʋ wʋ́ ta n jɩgɩ yu-yoŋo. Nɔɔna bantʋ doŋ bá wanɩ ba joori ba ŋwɩ jɩnɩ dɩm. Maŋa kam Wɛ na wʋ́ pa nɔn-ŋʋna bi ba yagɩ tʋʋnɩ tɩn, nmʋ laan wʋ́ joŋi n kǝm dɩm kwǝrǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nɔɔnʋ wʋdoŋ wʋlʋ na tɔgɩ o je Zezi tee nɩ o di wʋdiu tɩn ma ni o na tagɩ kʋlʋ tɩn. O ma ta dɩd-o o wɩ: «Nɔɔnʋ wʋlʋ maama na zʋ Wɛ paarɩ dɩm wʋ o jǝni o di ywǝǝni dáanɩ tɩn mʋ yɩ yu-yoŋo tu.» ");
INSERT INTO xsm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zezi ma maŋɩ mɩmaŋa o ma lǝri o wɩ: «Nɔɔnʋ wʋdoŋ mʋ ya wʋra o ma lagɩ o kɩ wʋdi-fɔrɔ sɩ o pa nɔɔna. O ma bǝŋi nɔɔna zanzan sɩ ba ba ba di. ");
INSERT INTO xsm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Candiǝ kam maŋa na yi tɩn, o ma tʋŋɩ o tɩntʋŋnʋ sɩ o vu o ta dɩ balʋ o na bǝŋi tɩn nɩ, ba ba sɩ woŋo maama ti kʋ yigǝ. ");
INSERT INTO xsm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nɔɔna bam na ni kʋntʋ tɩn, ba maama ma wʋra ba loori cwǝŋǝ o tee nɩ. Ba dɩdʋa ma wɩ: ‹Popo, pa-nɩ cwǝŋǝ, sɩ a joŋi kar-dʋŋa mʋ, kʋ yɩ fɩfɩʋn sɩ a vu a nii ka baŋa nɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nɔɔnʋ wʋdoŋ dɩ ma wɩ: ‹Popo, pa-nɩ cwǝŋǝ, sɩ a yǝgi nabɛ fugǝ mʋ lele kʋntʋ sɩ a ma va. A maa ve sɩ a kɩ a nii, sɩ wʋ́ sɛ sɩ va na?› ");
INSERT INTO xsm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nɔɔnʋ wʋdoŋ dɩ ma ta o wɩ: ‹A di kaanɩ mʋ lele kʋntʋ. Amʋ daa bá wanɩ a ba.› ");
INSERT INTO xsm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tɩntʋŋnʋ wʋm laan ma joori sɔŋɔ o vu o ta dɩ o tu wʋm ba na lǝri te tɩn. Sɔŋɔ tu wʋm na ni tɩn, o bam ma zaŋɩ. O ma ta dɩ tɩntʋŋnʋ wʋm o wɩ: ‹Nuŋi lɩla n vu tɩʋ kʋm cwe sɩm yum maama n la yinigǝ tiinǝ dɩ kwaarʋ dɩ lilwǝ dɩ gwanɩ n pa ba ba ba di.› ");
INSERT INTO xsm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tɩntʋŋnʋ wʋm ma kɩ kʋntʋ, yɩ o daa ta o wɩ: ‹Amʋ tu, a kɩ tɩte maama nmʋ na tagɩ tɩn, yɩ jǝgǝ daa ta daarɩ sɩ nɔɔna jǝni da.› ");
INSERT INTO xsm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sɔŋɔ tu wʋm daa ma ta dɩd-o o wɩ: ‹Nuŋi tɩʋ kʋm wʋ n vu n beeri cwǝ-bim sɩm maama niǝ nɩ, sɩ n pa balʋ na wʋra tɩn ba ba zʋ a sɔŋɔ kʋm sɩ kʋ su.› ");
INSERT INTO xsm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A lagɩ a ta abam sɩ, kʋ na yɩ nɔɔna balʋ a ya na bǝŋi yɩ ba vɩn tɩn, bantʋ wʋlʋwʋlʋ daa ba jɩgɩ ni sɩ ba tɔgɩ ba di a wʋdiu kʋm.» ");
INSERT INTO xsm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zezi na wʋ cwǝŋǝ nɩ o maa ve tɩn, nɔn-kɔgɔ zanzan maa tɔgɩ o kwaga. O ma pipiri o nii ba seeni yɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nɔɔnʋ wʋlʋ na tu amʋ te yɩ o wʋ vɩn o ko dɩ o nu, dɩ o kaanɩ dɩ o biǝ, dɩ o zɩmbaara dɩ o nyaana dɩ o nakwa, yɩ o na wʋ vɩn o tɩtɩ ŋwɩa dɩ, kʋntʋ tu bá wanɩ o ji amʋ karabu. ");
INSERT INTO xsm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wʋlʋ maama na wʋ sɛ sɩ o tɔgɩ amʋ kwaga, sɩ o na yaara nɩ wʋlʋ na zɩŋɩ dagara o maa ve o tʋʋnɩ je te tɩn, kʋntʋ tu bá wanɩ o ji a karabu. ");
INSERT INTO xsm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Abam wʋlʋ na bʋŋɩ sɩ o lɔ wɛyuu di-kamunu, n maŋɩ sɩ n da yigǝ n jǝni n jeeli n nii, sǝbu kʋm wʋ́ wanɩ digǝ kam kʋ lɔ kʋ ti naa kʋ bá wanɩ. Kʋ daɩ kʋntʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","N na wʋ kɩ kʋntʋ, yɩ n na cwi digǝ kam kuri yɩ ka daa warɩ ka guri, balʋ maama na lwarɩ tɩn wʋ́ ta mwanɩ nmʋ, ");
INSERT INTO xsm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yɩ ba wɩ: ‹Nɔɔnʋ wʋntʋ puli digǝ lɔɔm, yɩ o daa warɩ-ka o guri.› ");
INSERT INTO xsm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Asawɛ, pɛ na lagɩ o kɩ jara dɩ pɛ wʋdoŋ, o maŋɩ sɩ o da yigǝ o jǝni o bwɛ o nii, nɔɔna mʋrr-fugǝ (10.000) kalʋ na wʋ o kwaga nɩ tɩn wʋ́ wanɩ ba jeeri nɔɔna mʋrr-fiinle (20.000) kalʋ na wʋ pɛ wʋdoŋ wʋm kwaga nɩ tɩn naa ba bá wanɩ. Kʋ daɩ cɩga na? ");
INSERT INTO xsm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","O nan na bá wanɩ, pɛ wʋdoŋ wʋm ta na wʋ yigǝ yigǝ o bɩɩnɩ tɩn, oó da yigǝ o tʋŋɩ tɩntʋŋna mʋ o tee nɩ, sɩ ba koor-o sɩ o yagɩ jara yam sɩ ya ti. ");
INSERT INTO xsm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kʋntʋ tɩn, kʋ yɩ bɩdwɩ mʋ dɩ abam wʋlʋ maama na wʋ kwe o woŋo maama o yagɩ daa nɩ, o bá wanɩ o ji amʋ karabu. ");
INSERT INTO xsm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yɛ ywǝnǝ yɩ dɩ waɩ dɩ kwɛ wʋdiu. Yɛ ywǝǝni nan na ti, n daa n bá wanɩ n pa dɩ joori dɩ ja ywǝǝni. ");
INSERT INTO xsm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dɩntʋ daa ba jɩgɩ kuri. N bá wanɩ n kɩ-dɩ n kadugǝ nɩ, naa n ma n kɩ pʋpɔnɔ. N maŋɩ sɩ n lo-dɩ n yagɩ mʋ. Abam nan fɔgɩ á cǝgi amʋ taanɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Dɛ dɩdwɩ lampo-joŋnǝ dɩ nɔn-cɩcɔgɩrʋ zanzan ma fɔɔrɩ ba yi Zezi te, sɩ ba taa cǝgi o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizɩan tiinǝ dɩ Wɛ cullu karanyɩna tiinǝ na nɛ kʋntʋ tɩn, ba maa pʋʋna ba wɩ: «Taá nii nɔɔnʋ wʋntʋ na je dɩ nɔn-cɩcɔgɩrʋ, yɩ o ta kwǝri o di wʋdiu dɩ ba.» ");
INSERT INTO xsm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zezi laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Abam wʋlʋ na jɩgɩ peeni bi (100), yɩ sɩ dɩdʋa na je, o bá yagɩ peeni funʋgʋ-nʋgʋ kʋm (99) gaa nɩ, yɩ o daarɩ o vu o beeri pi-jiǝ kam na? ");
INSERT INTO xsm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O nan na beeri o na-ka, o laan wʋ́ kwe-ka o daŋɩ o bakala baŋa nɩ dɩ wʋpolo o ja vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","O na tu o yi sɔŋɔ, oó bǝŋi o cilonnǝ dɩ o sɔŋɔ tiinǝ maama, yɩ o ta dɩ ba o wɩ: ‹Á kɩ wʋpolo dɩ amʋ, a na nɛ piǝ kalʋ ya na je tɩn ŋwaanɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kʋntʋ tɩn, a lagɩ a ta abam sɩ, kʋ yɩ bɩdwɩ mʋ dɩ nɔn-cɩcɔgɔ dɩdʋa na lǝni o wʋ o yagɩ kǝm-balwaarʋ, kʋʋ́ pa wʋpolo taa daga Wɛ-sɔŋɔ nɩ. Baá ta jɩgɩ wʋpolo zanzan dɩd-o kʋ dwe nɔn-ŋʋna funʋgʋ-nʋgʋ na ba bʋŋɩ sɩ ba maŋɩ sɩ ba lǝni ba wʋrʋ Wɛ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Asawɛ, kaanɩ na jɩgɩ sǝbu-dala fugǝ, yɩ dɩdʋa na je, o bá tarɩgɩ kanɩa o zuri o yɩra o zwarɩ digǝ kam wʋ maama, sɩ o nii oó na-dɩ na? ");
INSERT INTO xsm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","O nan na nɛ-dɩ, o laan wʋ́ bǝŋi o cilonnǝ dɩ o sɔŋɔ tiinǝ maama, yɩ o ta dɩ ba o wɩ: ‹Á kɩ wʋpolo dɩ amʋ, a na nɛ sǝbu-dalɩ dɩlʋ ya na je tɩn ŋwaanɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kʋntʋ tɩn, a lagɩ a ta abam sɩ, kʋ yɩ bɩdwɩ mʋ dɩ nɔn-cɩcɔgɔ dɩdʋa na lǝni o wʋ o yagɩ kǝm-balwaarʋ, kʋʋ́ pa wʋpolo kʋntʋ doŋ taa wʋ Wɛ malɛsɩ sɩm tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zezi daa ta ma ta o wɩ: «Nɔɔnʋ mʋ wʋra o na jɩgɩ bǝkǝri sɩle. ");
INSERT INTO xsm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dɛ dɩdwɩ nyaanɩ wʋm ma zaŋɩ o ta dɩ o ko o wɩ: ‹A ko, a loori-m sɩ n maŋɩ a tǝri nmʋ wǝǝnu tɩm wʋnɩ n pa-nɩ›. O ko ma sɛ. O ma maŋɩ o jɩjɩgɩrʋ tɩm o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Da fɩnfɩɩn na kɛ tɩn, nyaanɩ wʋm ma zaŋɩ o kwalɩmɩ o wǝǝnu maama o ja nuŋi o vu tɩʋ kʋdoŋ yigǝ yigǝ. O maa zʋʋrɩ da, yɩ o kɩ paweeni yɩranɩ. O maa jɩgɩ o wǝǝnu tɩm o cɔgɩ yɔɔ yɔɔ. ");
INSERT INTO xsm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","O laan ma ba o cɔgɩ o wǝǝnu tɩm o ti maama. Kana ma tiini ka zʋ tɩʋ kʋm, yɩ o daa ba jɩgɩ kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O ma vu tɩʋ kʋm nɔɔnʋ dɩdʋa te, o loor-o sɩ o wǝl-o. Nɔɔnʋ wʋm ma pa o vu o tɔgɩ o tǝrǝ gaa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kana na tiini ka cɛ o yɩra nɩ tɩn, o ma bʋŋɩ sɩ o tɔgɩ o di tǝrǝ yam wʋdiu kʋm, yɩ nɔɔn-nɔɔnʋ ba pa-o-kʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","O wʋbʋŋa laan ma joori. O ma bwɛ o tɩtɩ nɩ o wɩ: A ko yǝni o paɩ o tɩntʋŋna wʋdiu zanzan yɩ ba ba di ba tiǝ, yɩ a laan wʋ yo seeni kana lagɩ ka gʋ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aá zaŋɩ a joori a vu a ko wʋm te mʋ, sɩ a ta dɩd-o nɩ: A ko, a kɩ a cɔgɩ Wɛ yigǝ, yɩ a kɩ a cɔgɩ nmʋ dɩ wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kʋntʋ tɩn, kʋ daa wʋ maŋɩ sɩ n kɩ-nɩ nɩ nmʋ bu te. Nan pa a taa tɔgɩ a yɩ nmʋ tɩntʋŋna bam dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","O na bʋŋɩ kʋntʋ tɩn, o laan ma zaŋɩ o maa ve o ko wʋm te. O ta na wʋ yigǝ yigǝ tɩn, mʋ o ko wʋm tʋlɩ o na-o. O na nɛ-o tɩn, o ŋwaŋa ma zʋ-o. O ma zaŋɩ o duri o vu o jeeri o bu wʋm, o kukwǝr-o dɩ wʋpolo zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bu wʋm laan ma ta dɩd-o o wɩ: A ko, a kɩ a cɔgɩ Wɛ yigǝ, yɩ a kɩ a cɔgɩ nmʋ dɩ wʋ. Kʋntʋ tɩn, kʋ daa wʋ maŋɩ sɩ n kɩ-nɩ nɩ n bu te. ");
INSERT INTO xsm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","O ko wʋm ma ta dɩ o tɩntʋŋna bam o wɩ: Á kɩ lɩla á zʋ á kwe gɔrɔ kʋlʋ na lana kʋ dwe tɩ maama tɩn, á ja ba á zʋ-o. Kwe-na jafʋlɩ á kɩ o jɩŋa nɩ, sɩ á kwe natra á pa o zʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ve-na á ja na-paalɩ kamunu kʋm á ja ba á gʋ, sɩ dɩ́ ma kɩ wʋdiu dɩ́ di candiǝ dɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bɛŋwaanɩ a bu wʋntʋ ya tɩgɩ mʋ, yɩ o joori o bi. O ya je mʋ, yɩ a joori a na-o. Ba ma puli wʋdiiru tɩm dim yɩ ba kwɛɛra dɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Maŋa kalʋ nyaanɩ wʋm na tu o yi sɔŋɔ tɩn, o zɩmbaarʋ wʋm ya wʋ kara nɩ mʋ o vara. O na nuŋi kara kam nɩ o maa bɩɩnɩ sɔŋɔ tɩn, mʋ o ni ba na magɩ wǝǝnu yɩ ba saɩ. ");
INSERT INTO xsm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","O ma bǝŋi o ko tɩntʋŋna bam dɩdʋa o bwe-o woŋo kʋlʋ na kɩ yɩ ba kwɛɛrɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tɩntʋŋnʋ wʋm ma lǝr-o o wɩ: ‹Nmʋ nyaanɩ wʋm mʋ tuǝ. Nmʋ ko ma ja na-paalɩ kamunu kʋm o gʋ sɩ ba di candiǝ, o na nɛ-o yɩ o jɩgɩ yazurǝ tɩn ŋwaanɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Bu-kwɩan kam na ni kʋntʋ tɩn, o bam ma zaŋɩ. O ma ba lagɩ sɩ o zʋ digǝ. O ko wʋm ma nuŋi o vu o koor-o sɩ o zʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O ma ta dɩ o ko wʋm o wɩ: ‹Ta n niǝ, bɩna yantʋ maama amʋ tiini a tʋŋɩ zanzan a pa nmʋ. A yǝni a sɛ nmʋ ni maŋa maama. Nmʋ nan wʋ pɛ amʋ dɩ bʋbala dɩ sɩ a gʋ, sɩ amʋ dɩ a cilonnǝ ma kɩ candiǝ. ");
INSERT INTO xsm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kʋ daarɩ nmʋ bu wʋntʋ na tu tɩn, n jaanɩ na-paalɩ kamunu kʋm n gʋ n pa-o, yɩ o yɩ wʋlʋ na kwe nmʋ jɩjɩgɩrʋ o vu o cɔgɩ ka-bwǝǝru kwaga nɩ yɩ o laan joori o ba tɩn.› ");
INSERT INTO xsm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","O ko wʋm ma lǝr-o o wɩ: ‹A bu, nmʋ wʋ amʋ tee nɩ mʋ maŋa maama. Wǝǝnu tɩlʋ maama amʋ na jɩgɩ tɩn yɩ nmʋ nyɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Dɩ́ nan maŋɩ sɩ dɩ́ kɩ wʋpolo candiǝ mʋ zɩm, bɛŋwaanɩ nmʋ nyaanɩ wʋm ya tɩgɩ mʋ, yɩ o joori o bi. O ya je mʋ, yɩ dɩ́ joori dɩ́ na-o.› » ");
INSERT INTO xsm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zezi daa ta ma ta dɩ o karabiǝ bam o wɩ: «Nadum mʋ wʋra o na jɩgɩ tɩntʋŋnʋ. O tɩntʋŋnʋ wʋm mʋ nii o wǝǝnu maama baŋa nɩ. Nɔɔna badonnǝ ma vu ba ta dɩ nadum wʋm ba wɩ, o tɩntʋŋnʋ wʋm jɩgɩ o wǝǝnu tɩm o cɔga mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O ma bǝŋi o tɩntʋŋnʋ wʋm, yɩ o ta dɩd-o o wɩ: ‹A ni nmʋ na kɩ te tɩn. Kɔɔ mʋ n nan wʋ́ ta dɩ amʋ? Nan ve n jeeli nmʋ na kɩ te dɩ a wǝǝnu tɩm tɩn, sɩ n ba n ta n brɩ-nɩ. Nmʋ daa n bá wanɩ n ta n yɩ a tɩntʋŋnʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tɩntʋŋnʋ wʋm ma bwɛ o tɩtɩ nɩ o wɩ: ‹Amʋ nan wʋ́ kɩ ta mʋ? A tu wʋm lagɩ o lɩ-nɩ o tɩtʋŋa yam nɩ. Amʋ ba dana sɩ a wanɩ a va. Cavɩɩra maa jɩgɩ-nɩ sɩ a taa tʋlɩ a loorǝ. ");
INSERT INTO xsm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A nan ye a na wʋ́ kɩ te, sɩ o na lɩ-nɩ o tɩtʋŋɩ dɩm nɩ, sɩ nɔɔna taa joŋi-nɩ lanyɩranɩ ba sam nɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","O na bʋŋɩ kʋntʋ tɩn, o ma bǝŋi balʋ na jɩgɩ o tu wʋm jɩna tɩn dɩdʋa dɩdʋa o pa ba ba o te. O ma bwe dayigǝ tu wʋm o wɩ: ‹Nmʋ jɩgɩ a tu wʋm jɩnɩ kʋ maɩ tɩta mʋ?› ");
INSERT INTO xsm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nɔɔnʋ wʋm ma lǝri o wɩ: ‹Kʋ yɩ nugǝ kʋnkwaanʋ bi (100) mʋ.› Tɩntʋŋnʋ wʋm ma ta-o o wɩ: ‹Nii tɔnɔ kʋlʋ nmʋ jɩnɩ dɩm na pʋpʋnɩ da tɩn. Nan kɩ lɩla n kwe n ja n vu n jǝni n pʋpʋnɩ nɩ kʋnkwaanʋ fiinnu (50).› ");
INSERT INTO xsm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","O daa ta ma bwe nɔɔnʋ wʋdoŋ o wɩ: ‹Nmʋ jɩgɩ a tu wʋm jɩnɩ kʋ maɩ tɩta mʋ?› O ma lǝri o wɩ: ‹Kʋ yɩ mɩna ywǝǝlu bi (100) mʋ.› Tɩntʋŋnʋ wʋm ma ta dɩd-o o wɩ: ‹Kwe tɔnɔ kʋm n pʋpʋnɩ nɩ ywǝǝlu funɔnɔ (80).› ");
INSERT INTO xsm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nadum wʋm na lwarɩ kʋntʋ tɩn, o ta tee tɩtʋŋ-balɔrɔ kʋm dɩ o na kɩ te tɩn, bɛŋwaanɩ lʋgʋ baŋa tiinǝ jɩgɩ swan ba ye ba na wʋ́ kɩ te sɩ ba ma wǝli daanɩ ba dwe balʋ na lwarɩ Wɛ pooni dɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A lagɩ a ta abam sɩ, á maŋɩ sɩ á kwe lʋgʋ baŋa sǝbu á ma wǝli nɔɔna sɩ kʋ pa á di ciloŋo daanɩ. Á na kɩ kʋntʋ, yɩ sǝbu kʋm na ti, ba jwa wʋ́ jeeri abam lanyɩranɩ Wɛ-sɔŋɔ nɩ, sɩ á taá wʋra maŋa kalʋ na bá ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","«Nɔɔnʋ wʋlʋ na tɔgɩ cɩga dɩ wo-balaŋa tɩn wʋ́ ta tɔgɩ cɩga dɩ wo-kamunu dɩ. Kʋ daarɩ wʋlʋ na ba tɔgɩ cɩga dɩ wo-balaŋa tɩn bá wanɩ o tɔgɩ cɩga dɩ wo-kamunu dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kʋntʋ tɩn, abam na warɩ á tɔgɩ cɩga dɩ lʋgʋ baŋa sǝbu, Wɛ bá sɛ sɩ DƖ kwe jɩjɩgɩrʋ cɩga cɩga DƖ kɩ abam jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Abam na warɩ á tɔgɩ cɩga dɩ wǝǝnu tɩlʋ ba na kwe ba kɩ abam jɩŋa nɩ sɩ á nii tɩ baŋa nɩ tɩn, Wɛ bá sɛ sɩ DƖ pa abam wǝǝnu tɩlʋ na wʋ́ ta yɩ abam tɩtɩ nyɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tɩntʋŋnʋ bá wanɩ o kwe wʋbʋŋ-dɩdwɩ sɩ o ma tʋŋɩ o pa o yuutiinǝ bale. Oó ta culi dɩdʋa kam yɩ o daarɩ o soe wʋdoŋ wʋm, naa oó ta nɩgɩ dɩdʋa kam yɩ o daarɩ o gooni wʋdoŋ wʋm. Kʋntʋ ŋwaanɩ abam bá wanɩ á pa sɩ Wɛ taa yɩ á yuutu, sɩ á daarɩ á pa sǝbu dɩ taa yɩ á yuutu.» ");
INSERT INTO xsm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizɩan tiinǝ bam na tɔgɩ ba wʋra tɩn ma ni Zezi na tagɩ kʋlʋ maama tɩn. Ba na yɩ sǝbu-swǝn-nyɩna tɩn, ba maa jɩg-o ba mwana. ");
INSERT INTO xsm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O ma ta dɩ ba o wɩ: «Abam mʋ lagɩ sɩ á brɩ á tɩtɩ nɔɔna yigǝ nɩ, nɩ á yɩ nɔn-ŋʋna. Wɛ nan ye á wʋbʋŋa na yɩ te tɩn. Woŋo kʋlʋ nɔɔna na paɩ kʋ yɩ wo-kamunu tɩn, kʋ yɩ wo-zɔɔnɩ mʋ Wɛ yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nɔɔna dɛɛn jɩgɩ Moyisi cullu tɩm dɩ faŋa faŋa Wɛ nijoŋnǝ bam na brɩ kʋlʋ tɩn mʋ ba tɔga, yɩ kʋ vu kʋ yi maŋa kalʋ Zan wʋlʋ na miisi nɔɔna na wʋnɩ tɩn laan ba. O na tu tɩn, kʋ laan yɩ Wɛ paarɩ kwǝr-ywǝŋǝ kam mʋ wʋra, yɩ nɔɔna maama tiini ba kwaanɩ sɩ ba tɔgɩ ba zʋ dɩ wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dɩ kʋ dɩ, kʋ yɩ mwalɩ sɩ wɛyuu dɩ tɩga je kʋ dwe woŋo fɩnfɩɩn na lagɩ kʋ lɩ Wɛ cullu tɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nɔɔnʋ wʋlʋ na yagɩ o kaanɩ yɩ o daarɩ o di kaanɩ wʋdoŋ, kʋntʋ tu kǝm dɩm yɩ balɔrɔ nɩnɛɛnɩ nɔɔnʋ na pǝni dɩ o doŋ kaanɩ te tɩn mʋ. Nɔɔnʋ wʋlʋ na zaŋɩ o di kaanɩ wʋlʋ o tɩtɩ barʋ na yag-o tɩn, kʋntʋ tu kǝm dɩm dɩ yɩ balɔrɔ nɩnɛɛnɩ nɔɔnʋ na pǝni dɩ o doŋ kaanɩ te tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Zezi ta ma ta o wɩ: «Nadum mʋ wʋra. O maa yǝni o zʋ gwar-ŋʋnnʋ tɩlʋ na tiini tɩ lana tɩn. O jɩgɩ woŋo maama kʋ yi-o, yɩ o ŋwɩa lana dɛ maama. ");
INSERT INTO xsm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yinigǝ tu dɩ mʋ wʋra, o yɩrɩ mʋ Lazaarɩ. O yǝni o tigi nadum wʋm sɔŋɔ mancoŋo nɩ. O yɩra maama yɩ ŋwana. ");
INSERT INTO xsm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","O maa lagɩ sɩ o taa di wʋdiu kʋlʋ nadum wʋm na di yɩ kʋ siiri tɩga nɩ tɩn, yɩ o ba na-kʋ o di. Kakuri dɩ ma tui sɩ dǝlimi o ŋwana yam. ");
INSERT INTO xsm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yinigǝ tu wʋm laan ma ba o tɩ. Wɛ malɛsɩ ma ba sɩ kwe-o sɩ ja vu Wɛ-sɔŋɔ sɩ pa o jǝni Abraham tɩkǝri nɩ. Nadum wʋm dɩ ma tɩ. Ba ma kwe-o ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","O ma vu curu. O maa wʋra o yaara zanzan. O ma kwǝni o yuu wɛɛnɩ o na Abraham na wʋ yigǝ yigǝ, yɩ Lazaarɩ je o tɩkǝri nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O ma kaasɩ o ta dɩd-o o wɩ: ‹A ko Abraham, popo, duri a ŋwaŋa. A loori-m sɩ n pa Lazaarɩ vu o ma o nʋa o laŋɩ na o ba o ma zuri a dindǝlimi, sɩ a tiini a yaarɩ zanzan mini dɩm wʋnɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ma lǝr-o o wɩ: ‹A bu, nan guli nmʋ dɛɛn na ŋwɩ lʋgʋ baŋa nɩ yɩ n na wo-laarʋ tɩlʋ maama n na lagɩ tɩn. Lazaarɩ dɛɛn nan jɩgɩ yaara yɩranɩ mʋ. Kʋ daarɩ lele kʋntʋ, wʋm bɩcarɩ laan zuri, yɩ nmʋ dɩ daa wʋ yaara wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Woŋo kʋlʋ na wǝli da tɩn, goŋ-canluŋu mʋ cɩgɩ dɩbam dɩ abam laŋa nɩ, yɩ nɔɔn-nɔɔnʋ bá wanɩ o zɩgɩ yo o vu o bɛ o yi abam te. Nɔɔn-nɔɔnʋ dɩ bá wanɩ o zɩgɩ abam tee nɩ o bɛ o ba dɩbam te.› ");
INSERT INTO xsm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nadum wʋm ma ta o wɩ: ‹A ko, kʋ nan na yɩ kʋntʋ, a loori-m sɩ n tʋŋɩ Lazaarɩ sɩ o vu a ko sɔŋɔ, ");
INSERT INTO xsm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sɩ a nyaana banu wʋra, sɩ o kaanɩ-ba, sɩ ba dɩ daa yɩ tɔgɩ ba ba yaara jǝgǝ kantʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ma ta dɩd-o o wɩ: ‹Ba maŋɩ ba jɩgɩ twaanʋ tɩlʋ Moyisi dɩ Wɛ nijoŋnǝ bam na pʋpʋnɩ tɩn. Ba nan maŋɩ sɩ ba sɛ twaanʋ tɩntʋ taanɩ dɩm mʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O ma lǝri o wɩ: ‹A ko Abraham, ba bá sɛ kʋntʋ. Nɔɔnʋ nan na bi o yagɩ tʋʋnɩ yɩ o vu ba te o ta dɩ ba, ba laan wʋ́ lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ tɩm.› ");
INSERT INTO xsm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ma lǝri nadum wʋm o wɩ: ‹Ba na wʋ sɛ Moyisi dɩ Wɛ nijoŋnǝ bam maama taanɩ dɩm, nɔɔnʋ na maŋɩ o bi o yagɩ tʋʋnɩ dɩ, ba ta bá sɛ sɩ o taanɩ dɩm yɩ cɩga.› » ");
INSERT INTO xsm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zezi dɛɛn ma ta dɩ o karabiǝ bam o wɩ: «Kʋ bá wanɩ sɩ wǝǝnu tɩlʋ na ganɩ nɔɔna sɩ ba yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn taa tǝrǝ. Kʋ nan na yɩ nɔɔnʋ wʋlʋ na ganɩ nɔɔna sɩ ba yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn, lɛɛrʋ wʋ o yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kʋʋ́ ta lana kʋ pa kʋntʋ tu sɩ ba lǝ kandwɛ kamunu o ba nɩ ba dɩ-o nɩnɩʋ wʋnɩ, kʋ garɩ cam dɩlʋ o na wʋ́ na dɩ o na pɛ Wɛ bu-balaŋa dɩdʋa yagɩ Wɛ cwǝŋǝ tɔgɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kʋntʋ tɩn, á taá cʋ á tɩtɩ! N nu-bu na kɩ lwarɩm, sɩ n kaan-o dɩ o na kɩ kʋlʋ tɩn. O nan na sɛ yɩ o lǝni o wʋ dɩ o kǝm-balɔrɔ kʋm, sɩ n ma n cɛ-o. ");
INSERT INTO xsm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O na maŋɩ o kɩ nmʋ lwarɩm kuni bɩrpɛ dɛ wʋnɩ yɩ o sɛ nɩ o kɩ o cɔgɩ, nmʋ ta maŋɩ sɩ n ma n cɛ-o mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dɩ́ Yuutu Zezi tɩntʋŋna bam ma ta dɩd-o ba wɩ: «Wǝli dɩbam wʋbʋŋa, sɩ dɩ́ taá jɩgɩ wʋ-dɩdʋa dɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Zezi ma lǝri-ba o wɩ: «Á na kɩ á wʋ-dɩdʋa dɩ amʋ, yɩ kʋ na maŋɩ kʋ yɩ fɩnfɩɩn yɩranɩ nɩ nyasaŋ-bu te dɩ, á wʋ́ wanɩ á ta dɩ tu-kamunu kʋntʋ nɩ kʋ gɔ kʋ vu kʋ jǝni nɩnɩʋ kʋm wʋnɩ, yɩ kʋʋ́ sɛ á ni.» ");
INSERT INTO xsm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zezi daa ta ma ta o wɩ: «Abam wʋlʋ na jɩgɩ tɩntʋŋnʋ, yɩ o na wʋra o varɩ o pa-m, naa o na tɔgɩ n peeni, yɩ wʋntʋ na tʋŋɩ o ti yɩ o ba o yi sɔŋɔ, n ta dɩd-o nɩ o ba o jǝni o di wʋdiu dɩ nmʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aye. Nmʋ nan wʋ́ ta dɩd-o nɩ: ‹Ve n kɩ wʋdiu, sɩ n laan vɔ n gɔrɔ dɩ vʋa, n ja wʋdiu kʋm n ba n pa-nɩ sɩ a di. Amʋ na di a ti, sɩ n laan vu n di n tɩtɩ nyɩm.› ");
INSERT INTO xsm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kʋ daa daɩ sɩ n kɩ n tɩntʋŋnʋ wʋm le, dɩ o na kɩ kʋlʋ nmʋ na pɛ-o ni sɩ o kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kʋ yɩ bɩdwɩ mʋ dɩ abam dɩ. Abam na kɩ kʋlʋ maama Wɛ na pɛ abam ni sɩ á kɩ tɩn, á maŋɩ sɩ á taá wɩ: ‹Dɩbam yɩ tɩntʋŋna má mʋ. Dɩ́ kɩ kʋlʋ na maŋɩ sɩ dɩ́ kɩ tɩn yɩranɩ mʋ.› » ");
INSERT INTO xsm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zezi dɛɛn ma wʋ cwǝŋǝ nɩ o maa ve Zeruzalɛm. O ma da Samari lʋgʋ dɩ Galile lʋgʋ sisǝm o maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","O ma vu sɩ o zʋ tɩʋ kʋdoŋ. Mʋ nanywaanʋ fugǝ jeer-o cwǝŋǝ nɩ. Ba ma zɩgɩ yigǝ yigǝ, ");
INSERT INTO xsm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","yɩ ba kaasɩ dɩ kwǝr-dɛ ba wɩ: «Dɩbam tu Zezi, popo duri dɩbam ŋwaŋa.» ");
INSERT INTO xsm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Zezi na nɛ-ba tɩn, o ma ta dɩ ba o wɩ: «Ve-na Wɛ kaanɩm tu wʋm te sɩ á pa o nii á yɩra yam.» O na tagɩ kʋntʋ yɩ ba maa ve tɩn, mʋ ba maama nɛ yazurǝ yɩ ba yɩra ji lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ba wʋ dɩdʋa na nɛ nɩ o yawɩʋ kʋm je tɩn, o ma pipiri o joori o vu Zezi te, yɩ o zuli Wɛ dɩ kwǝr-dɩa. ");
INSERT INTO xsm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O ma vu o tʋ Zezi yigǝ nɩ, yɩ o kɩ o le. Wʋlʋ na kɩ kʋntʋ tɩn yɩ Samari tu mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zezi ma bwe o wɩ: «Kʋ daɩ nɔɔna fugǝ kam maama mʋ nɛ yazurǝ na? Nʋgʋ kʋm nan bɛ? ");
INSERT INTO xsm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba wʋlʋwʋlʋ wʋ joori o ba sɩ o kɩ Wɛ le, kʋ na daɩ dwi-gɛ tu wʋntʋ yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","O laan ma ta dɩ nɔɔnʋ wʋm o wɩ: «Nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ tɩn mʋ pɛ n na vrɩm. Nan zaŋɩ n viiri.» ");
INSERT INTO xsm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizɩan tiinǝ bam dɛɛn ma bwe Zezi, sɩ ba lwarɩ maŋa kalʋ Wɛ na wʋ́ di paarɩ nɔɔna tɩtarɩ nɩ tɩn. O ma lǝri-ba o wɩ: «Wɛ paarɩ dɩm maŋa na yiǝ, á bá wanɩ á ma á yiǝ á na-dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nɔɔna bá ta wɩ: ‹Nii-na yo seeni›, asawɛ ba wɩ: ‹Nii jǝgǝ kantʋ nɩ›, bɛŋwaanɩ Wɛ paarɩ dɩm maŋɩ dɩ wʋ abam tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zezi ma ta dɩ o karabiǝ bam o wɩ: «Maŋa wʋ́ ba, yɩ á wʋ́ ta lagɩ dɩ á wʋ maama sɩ á ya na tɔgɩ á wʋra, kʋ na maŋɩ kʋ yɩ dɛ dɩdwɩ yɩranɩ dɩ, maŋa kalʋ amʋ Nabiin-bu wʋm na joori a ba tɩn. Á nan bá na. ");
INSERT INTO xsm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kantʋ maŋa kam nɩ nɔɔna wʋ́ ta dɩ abam ba wɩ: ‹Nii-na, o wʋ yo seeni›, asawɛ: ‹O wʋ jǝgǝ kantʋ nɩ›. Á nan yɩ sɛ ba taanɩ dɩm sɩ á vu á nii. ");
INSERT INTO xsm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bɛŋwaanɩ, dɛ dɩm amʋ Nabiin-bu wʋm na lagɩ a ba tɩn na yiǝ, kʋʋ́ ta nyɩ dɩ dʋa na pɩpɩlɩ wɛyuu nɩ ka lɛɛnɩ ka paɩ pooni lʋgʋ baŋa je maama nɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kʋ na wʋ́ loori kʋntʋ tɩn, kʋ fɩn mʋ sɩ amʋ Nabiin-bu wʋm na yaara zanzan sɩ zɩm nɔɔna bam culi-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Amʋ Nabiin-bu wʋm na wʋ́ ba maŋa kalʋ tɩn wʋ́ ta nyɩ nɩnɛɛnɩ kʋ dɛɛn na kɩ Nowe maŋa kam nɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kantʋ maŋa kam nɩ, nɔɔna dɛɛn di ba wʋdiiru yɩ ba nyɔa, yɩ ba daarɩ ba di kaana, yɩ kaana dɩ zʋʋrɩ banna, sɩ kʋ vu kʋ yi dɛ dɩm Nowe na zʋ naboro kamunu kʋm wʋ tɩn. Na laan ma ba, ba li lʋgʋ baŋa ba cɔgɩ nɔɔna bam maama. ");
INSERT INTO xsm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maŋa kalʋ Lɔtɩ dɛɛn na wʋra tɩn, kʋ dɩ maŋɩ kʋ yɩ kʋntʋ mʋ. Nɔɔna dɛɛn wʋra ba di ba wʋdiiru yɩ ba nyɔa, yɩ ba daarɩ ba kɩ pipiu, yɩ ba vara yɩ ba lɔ sam. ");
INSERT INTO xsm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kʋ ma ba kʋ yi dɛ dɩm Lɔtɩ na duri o nuŋi Sodɔm nɩ tɩn. Dɛ dɩm kʋntʋ nɩ, mini dɩ min-kandwa ma nuŋi wɛyuu nɩ ya tʋ tɩga nɩ ya cɔgɩ tɩʋ kʋm nɔɔna bam maama. ");
INSERT INTO xsm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dɛ dɩm amʋ Nabiin-bu wʋm na wʋ́ joori a ba lʋgʋ baŋa a brɩ a tɩtɩ tɩn, kʋʋ́ darɩ nɔɔna kʋntʋ doŋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Dɛ dɩm kʋntʋ nɩ, nɔɔnʋ wʋlʋ na wʋ nayuu nɩ yɩ o wǝǝnu na wʋ digǝ wʋnɩ, kʋntʋ tu daa yɩ tu o zʋ digǝ wʋ sɩ o kwe o wǝǝnu tɩm o ja duri. Nɔɔnʋ wʋlʋ nan na wʋ kara nɩ, o dɩ daa yɩ joori sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Guli-na kʋ dɛɛn na kɩ Lɔtɩ kaanɩ wʋm te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wʋlʋ maama na lagɩ sɩ o taa jɩgɩ o tɩtɩ ŋwɩa tɩn, kʋntʋ tu wʋ́ ga-ka mʋ. Wʋlʋ maama nan na sɛ sɩ o ga o ŋwɩa tɩn, kʋntʋ tu wʋ́ ta jɩgɩ ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A lagɩ a ta abam sɩ, nɔɔna bale na pǝni tɩtɩɩ nɩ sara dɩdʋa wʋnɩ, Wɛ wʋ́ lɩ ba dɩdʋa DƖ daarɩ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kaana bale na wʋra ba cʋɩ muni, Wɛ wʋ́ lɩ ba dɩdʋa DƖ daarɩ dɩdʋa.  ");
INSERT INTO xsm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nɔɔna bale dɩ na wʋ kara nɩ ba tʋŋa, Wɛ wʋ́ lɩ ba dɩdʋa DƖ daarɩ dɩdʋa.» ");
INSERT INTO xsm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zezi na tagɩ kʋntʋ tɩn, ba ma bwe-o ba wɩ: «Dɩbam Yuutu, kʋntʋ woŋo wʋ́ kɩ yǝn mʋ?» O ma lǝri-ba dɩ bɩtar-dɩndɩa o wɩ: «Wo-tʋʋ na wʋ mɛ tɩn, duurǝ dɩ gilimi da mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Zezi dɛɛn ma maŋɩ mɩmaŋa o brɩ o karabiǝ bam nɩ ba maŋɩ sɩ ba taa loori Wɛ taan mʋ, sɩ ba yɩ yagɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O ma maŋɩ o brɩ-ba o wɩ: «Tɩʋ kʋdoŋ nɩ mʋ sarɩya-diru wʋdoŋ dɛɛn ya wʋra, yɩ o ba kwarɩ Wɛ. O maa ba nɩgɩ nɔɔna dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kadǝm wʋdoŋ dɩ maa wʋ tɩʋ kʋm kʋntʋ nɩ. O maa yǝni o ve sarɩya-diru wʋm te maŋa maama, o loor-o zǝnǝ o wɩ: ‹Nan kwaanɩ n wǝli-nɩ, sɩ n pa a na bʋra a dʋm wʋm tee nɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sarɩya-diru wʋm maa ba sɛ o taanɩ dɩm. Kʋ maa wʋra kʋ wʋra, o laan ma ta o tɩtɩ wʋnɩ o wɩ: ‹A ba kwarɩ Wɛ. A ba nɩgɩ nɔɔna dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Dɩ kʋ dɩ, kadǝm wʋntʋ nan ta jɩgɩ-nɩ o yaara maŋa maama dɩ o taanɩ dɩm. Kʋntʋ ŋwaanɩ a maŋɩ sɩ a pa-o bʋra. Kʋ na daɩ kʋntʋ, oó ta tui a te o yaarɩ-nɩ maŋa maama.› » ");
INSERT INTO xsm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dɩ́ Yuutu Zezi laan ma ta o wɩ: «Cǝgi-na sarɩya-diru balɔrɔ kʋm na tagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Sɩ kʋ laan nan na yɩ Wɛ, DƖ bá sɛ sɩ DƖ wǝli DƖ tɩtɩ nɔɔna balʋ DƖ na kuri tɩn sɩ ba na cɩga na? DƖ bá kɩ lɩla DƖ wǝli balʋ na tiini ba loori-DƖ maŋa maama wɩa dɩ tɩtɩɩ tɩn na? ");
INSERT INTO xsm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A lagɩ a ta abam sɩ, DƖ wʋ́ pa-ba cɩga lɩla. Kʋ daarɩ, amʋ Nabiin-bu wʋm na joori a ba lʋgʋ baŋa, nɔɔna ta wʋ́ ta jɩgɩ wʋ-dɩdʋa dɩ amʋ na?» ");
INSERT INTO xsm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zezi daa ma maŋɩ mɩmaŋɩ dɩdoŋ, sɩ o ma brɩ balʋ na bʋŋɩ ba paɩ ba yɩ nɔn-ŋʋna Wɛ tee nɩ yɩ ba gooni ba donnǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","O ma maŋɩ o brɩ-ba o wɩ: «Nɔɔna bale mʋ wʋra. Ba dɩdʋa yɩ Farizɩan tu mʋ. Wʋdoŋ wʋm maa yɩ lampo-joŋnu. Ba ma zaŋɩ ba vu Wɛ-di-kamunu kʋm sɩ ba warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ba na zʋ tɩn, Farizɩan tu wʋm ma zɩgɩ o warɩ Wɛ o wʋnɩ o wɩ: ‹Wɛ, a kɩ nmʋ le dɩ amʋ na daɩ nɩnɛɛnɩ nɔɔna badaara balʋ na yɩ ŋwɩɩna dɩ wo-lwaan-kǝrǝ dɩ ka-lagɩna te tɩn. A kɩ nmʋ le dɩ a na daɩ nɩnɛɛnɩ lampo-joŋnu wʋntʋ dɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A yǝni a vɔ ni kuni bɩle mʋ da yarpɛ maama wʋnɩ. Wǝǝnu tɩlʋ maama a na nɛ tɩn, a yǝni a lɩ nmʋ tǝri tɩ wʋnɩ a pa nmʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kʋ daarɩ lampo-joŋnu wʋm maa zɩgɩ daa nɩ o warɩ Wɛ. O maa ba lagɩ sɩ o kwǝni o yuu wɛɛnɩ, yɩ o magɩ o japoorǝ Wɛ yigǝ nɩ o wɩ: ‹Wɛ, amʋ yɩ lwarɩm tu mʋ. Nan duri a yibwǝnǝ.› ");
INSERT INTO xsm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kʋntʋ tɩn, a nan lagɩ a ta dɩ abam sɩ, nɔɔna bantʋ bale na warɩ Wɛ ba ti yɩ ba laan joori sɔŋɔ tɩn, kʋ yɩ lampo-joŋnu wʋm mʋ nɛ cɩga Wɛ tee nɩ, sɩ kʋ daɩ Farizɩan tu wʋm. Bɛŋwaanɩ, wʋlʋ na zǝŋi o tɩtɩ tɩn, Wɛ wʋ́ tu kʋntʋ tu. Wʋlʋ nan na tu o tɩtɩ tɩn, Wɛ wʋ́ zǝŋi kʋntʋ tu.» ");
INSERT INTO xsm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nɔɔna badonnǝ maa jaanɩ ba bu-balwa ba tui Zezi te, sɩ o daŋɩ o jɩa ba baŋa nɩ o warɩ Wɛ o pa-ba. O karabiǝ bam na nɛ kʋntʋ tɩn, ba ma zaŋɩ ba kaanɩ-ba sɩ ba yɩ taa kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Zezi laan ma bǝŋi biǝ bam sɩ ba ba o te, yɩ o wɩ: «Yagɩ-na sɩ biǝ bam taa tui a te, sɩ á yɩ zaŋɩ á cɩ-ba. Bɛŋwaanɩ balʋ na nyɩ dɩ bu-balwa te tɩn mʋ maŋɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ na wʋ sɛ sɩ Wɛ taa te-o nɩ bu-balaŋa te, o bá na cwǝŋǝ sɩ o zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zwifǝ yigǝ tu wʋdoŋ dɛɛn ma bwe Zezi o wɩ: «Karanyɩna, n yɩ nɔn-ŋʋm. Brɩ-nɩ kʋlʋ a na wʋ́ kɩ, sɩ a ma a na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zezi ma ta dɩd-o o wɩ: «Bɛŋwaanɩ mʋ n bǝŋi-nɩ nɩ nɔn-ŋʋm? Nɔɔn-nɔɔnʋ tǝrǝ o na yɩ nɔn-ŋʋm, kʋ na daɩ Wɛ DƖ yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nmʋ maŋɩ n ye Wɛ cullu tɩm na brɩ kʋlʋ tɩn. Yɩ zaŋɩ n pǝni dɩ n doŋ kaanɩ. Yɩ zaŋɩ n gʋ nɔɔnʋ. Yɩ zaŋɩ n ŋɔ. Yɩ fɔ vwan n pa nɔɔn-nɔɔnʋ. Ta n zuli n nu dɩ n ko.» ");
INSERT INTO xsm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Zwifǝ yigǝ tu wʋm ma ta o wɩ: «Kʋ zɩgɩ amʋ biini nɩ mʋ a maŋɩ a tɔgɩ cullu tɩntʋ maama.» ");
INSERT INTO xsm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Zezi na ni o na tagɩ kʋlʋ tɩn, o ma ta dɩd-o o wɩ: «Kʋ nan ta gɛ woŋo dɩdʋa mʋ sɩ n kɩ. Kwe wǝǝnu tɩlʋ maama n na jɩgɩ tɩn n yǝgi, sɩ n laan maŋɩ tɩ sǝbu kʋm n pa yinigǝ tiinǝ. Kʋntʋ wʋ́ pa n ta n jɩgɩ jɩjɩgɩrʋ Wɛ-sɔŋɔ nɩ. Nmʋ na kɩ kʋntʋ, sɩ n laan ba n ta n tɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nɔɔnʋ wʋm na ni kʋntʋ tɩn, o wʋ ma cɔgɩ zanzan, o na yɩ jɩjɩgɩrʋ zanzan tu tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Zezi ma lwarɩ o wʋ na cɔgɩ te tɩn. O ma ta o wɩ: «Nadunǝ na lagɩ sɩ ba zʋ Wɛ paarɩ dɩm wʋ, kʋ sɩɩnɩ kʋ cana kʋ pa-ba. ");
INSERT INTO xsm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kʋʋ́ ta yɩ mwalɩ sɩ yogondi da gar-lwe bɔɔnɩ dɩ nuŋi kʋ dwe nadum na lagɩ sɩ o zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɔɔna balʋ na ni kʋlʋ Zezi na tagɩ tɩn ma bwe-o ba wɩ: «Kʋ nan na yɩ kʋntʋ, wɔɔ mʋ wʋ́ wanɩ o na vrɩm?» ");
INSERT INTO xsm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","O ma lǝri-ba o wɩ: «Kʋlʋ nabiinǝ na warɩ ba kɩ tɩn, Wɛ wa-kʋ DƖ kɩa.» ");
INSERT INTO xsm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pɩyɛɛrɩ laan ma ta o wɩ: «Nii. Dɩbam yagɩ dɩ́ wǝǝnu mʋ yɩ dɩ́ daarɩ dɩ́ tɔgɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zezi ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ maama na tagɩ Wɛ paarɩ dɩm ŋwaanɩ yɩ o yagɩ o sɔŋɔ naa o kaanɩ naa o nu-biǝ naa o nu dɩ o ko naa o biǝ tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kʋntʋ tu wʋ́ sɩɩnɩ o joŋi kʋ dwǝni kʋlʋ maama o na yagɩ tɩn maŋa kantʋ nɩ. Kʋ daarɩ maŋa kalʋ na wʋ́ ba tɩn, kʋntʋ tu wʋ́ na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zezi dɛɛn ma pɔɔrɩ o karabiǝ fugǝ-bale bam kɔgɔ kʋm wʋnɩ, yɩ o ta dɩ ba o wɩ: «Taá ye-na sɩ, dɩ́ maa ve Zeruzalɛm, yɩ wǝǝnu tɩlʋ maama faŋa faŋa Wɛ nijoŋnǝ bam na pʋpʋnɩ amʋ Nabiin-bu wʋm ŋwaanɩ tɩn wʋ́ kɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Baá ja amʋ ba kɩ dwi-gɛ tiinǝ jɩŋa nɩ. Baá mwanɩ amʋ, baá bɛɛsɩ amʋ, baá twɩ lileeru ba yagɩ a yɩra nɩ, ");
INSERT INTO xsm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","baá kwe balaarɩ ba ma magɩ-nɩ, yɩ ba laan daarɩ ba gʋ-nɩ. Da yatɔ dɛ nɩ, a laan wʋ́ joori a bi a yagɩ tʋʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Zezi na tagɩ kʋntʋ tɩn, ba wʋ ni o taanɩ dɩm kuri. Ba maa yǝri o na jɩgɩ kʋlʋ o ŋɔɔnɩ tɩn, kʋ kuri na sǝgi dɩ ba tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zezi dɛɛn ma vu o twɛ tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Zeriko. Lilwe maa je cwǝŋǝ kam ni nɩ o loorǝ. ");
INSERT INTO xsm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","O ma ni nɔn-kɔgɔ na tɔgɩ da kʋ maa kɛa. O ma bwe sɩ o lwarɩ kʋ na yɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ba ma ta ba brɩ-o sɩ kʋ yɩ Nazarɛtɩ tu Zezi mʋ tɔgɩ dáanɩ o maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","O ma tɔɔlɩ o bǝŋi o wɩ: «Zezi, Pɛ Davidi dwi tu, duri a yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nɔɔna balʋ na wʋ kɔgɔ kʋm yigǝ nɩ ba maa ve tɩn ma kaan-o sɩ o pu o ni. O laan ma tiini o tɔɔlɩ baŋa baŋa o wɩ: «Pɛ Davidi dwi tu, duri a yibwǝnǝ!» ");
INSERT INTO xsm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Zezi ma zɩgɩ, yɩ o pa ni sɩ ba vaŋɩ lilwe wʋm ba ja ba o te. O na yi o te tɩn, Zezi ma bwe-o o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Nmʋ lagɩ sɩ a kɩ bɛɛ mʋ a pa-m?» O ma lǝri o wɩ: «A tu, a lagɩ sɩ a joori a taa na mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zezi ma ta dɩd-o o wɩ: «Ta n naɩ. Nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ te tɩn mʋ pɛ n na vrɩm.» ");
INSERT INTO xsm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Zezi na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ lilwe wʋm yiǝ joori ya naɩ. O ma zaŋɩ o tɔgɩ Zezi, yɩ o zuli Wɛ lanyɩranɩ. Nɔɔna bam maama na nɛ kʋlʋ na kɩ tɩn, ba dɩ maa tee Wɛ. ");
INSERT INTO xsm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zezi ma vu o tɔgɩ Zeriko tɩʋ kʋm wʋ o maa kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nɔɔnʋ wʋdoŋ mʋ wʋ tɩʋ kʋm wʋnɩ, o yɩrɩ mʋ Zase. O maa yɩ lampo-joŋnǝ yigǝ tu, yɩ o yɩ nadum. ");
INSERT INTO xsm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","O dɛɛn ma lagɩ sɩ o lwarɩ Zezi na yɩ wʋlʋ tɩn. O ma kwaanɩ o ga, o na yɩ nɔn-kukulǝ yɩ kɔgɔ kʋm daga tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","O ma duri o kɛ kɔgɔ kʋm yigǝ, o vu o di kapʋrʋ yuu sɩ o kwaanɩ o na Zezi, o na lagɩ o ba o da dáanɩ o kɛ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zezi ma vu o yi jǝgǝ kam. O ma kwǝni o yuu wɛɛnɩ o nii, yɩ o wɩ: «Zase, kɩ lɩla n tu tɩga, sɩ zɩm a maŋɩ sɩ a ba a pǝni nmʋ sɔŋɔ nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zase na ni kʋntʋ tɩn, o ma kɩ lɩla o tu tɩga, yɩ o vu o jeeri Zezi lanyɩranɩ o sɔŋɔ nɩ dɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nɔɔna bam na nɛ Zezi na kɩ te tɩn, ba maama maa pʋʋnɩ ba wɩ: «Taá nii o na ve o zʋ nɔn-cɩcɔgɔ sɔŋɔ sɩ o taa yɩ o vǝru.» ");
INSERT INTO xsm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zase laan ma zaŋɩ wɛɛnɩ o ta dɩ dɩ́ Yuutu Zezi o wɩ: «A tu, nii amʋ na lagɩ a kɩ te tɩn. Aá pɔɔrɩ a jɩjɩgɩrʋ tɩm cicoro mʋ a maŋɩ a pa yinigǝ tiinǝ. A ya na pini wʋlʋ maama a joŋi lampoo zanzan o tee nɩ tɩn, aá joori a ŋwɩ-kʋ kuni bɩna mʋ a pa kʋ tu.» ");
INSERT INTO xsm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zezi ma ta dɩd-o o wɩ: «Zɩm dɛ dɩm nɩ sɔŋɔ kʋntʋ tiinǝ nɛ vrɩm, bɛŋwaanɩ nɔɔnʋ wʋntʋ brɩ sɩ o dɩ tɔgɩ o yɩ Abraham dwi tu cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Amʋ Nabiin-bu wʋm na tu lʋgʋ baŋa tɩn, kʋ yɩ sɩ a beeri balʋ na je tɩn mʋ, sɩ a daarɩ a vrɩ-ba a kɩ Wɛ jɩŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nɔɔna bam ta na wʋra ba cǝgi o taanɩ dɩm kʋntʋ tɩn, Zezi daa ma maŋɩ mɩmaŋa o brɩ-ba. O na tu o twɛ Zeruzalɛm tɩn, nɔɔna bam ga bʋŋɩ sɩ Wɛ paarɩ dɩm wʋ́ ba lɩla mʋ ba yibiyǝ nɩ kantʋ maŋa kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kʋntʋ ŋwaanɩ mʋ o ma maŋɩ o brɩ-ba o wɩ: «Nɔɔnʋ wʋdoŋ mʋ wʋra o na yɩ pabu. Dɛ dɩdwɩ o ma zaŋɩ sɩ o vu tɩʋ kʋdoŋ yigǝ yigǝ sɩ ba pa-o paarɩ, sɩ o laan joori o ba. ");
INSERT INTO xsm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","O ma bǝŋi o tɩntʋŋna fugǝ, yɩ o kwe sǝbu-sɩŋa dala fugǝ o pa-ba, yɩ o wɩ: ‹Ma-na sǝbu kʋntʋ á taá maa pipiǝ, sɩ kʋ taa ve maŋa kalʋ a na wʋ́ joori a ba tɩn.› ");
INSERT INTO xsm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","O tɩʋ kʋm tiinǝ nan cul-o zanzan. Ba ma tʋŋɩ nɔɔna sɩ ba da o kwaga ba vu ba ta wɩ, ba ba lagɩ sɩ o taa yɩ ba pɛ. ");
INSERT INTO xsm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dɩ kʋ dɩ, ba ta pɛ-o paarɩ. O ma joori o tɩtɩ tɩʋ kʋm. O laan ma pa ba bǝŋi o tɩntʋŋna balʋ o ya na pɛ-ba sǝbu kʋm tɩn, sɩ ba ba o te ba brɩ-o nyɔɔrɩ dɩlʋ ba na nɛ kʋ baŋa nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dayigǝ nɔɔnʋ wʋm ma ba o ta dɩd-o o wɩ: ‹A yuutu, a kwe sǝbu-sɩŋa dalɩ dɩm nmʋ na pɛ-nɩ tɩn, a ma na dala fugǝ nyɔɔrɩ mʋ a wǝli da.› ");
INSERT INTO xsm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O yuutu wʋm ma lǝr-o o wɩ: ‹N kɩ cɩga n jɩgɩ yawala, n yɩ tɩntʋŋ-ŋʋm. Nmʋ na kɩ cɩga dɩ kʋlʋ fɩnfɩɩn a na kɩ n jɩŋa nɩ tɩn, a laan wʋ́ pa n ta n te tɩɩnɩ fugǝ.› ");
INSERT INTO xsm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bale-tu wʋm ma ba o ta dɩ o yuutu wʋm o wɩ: ‹A yuutu, a kwe sǝbu-sɩŋa dalɩ dɩm a ma na dala yanu nyɔɔrɩ mʋ a wǝli da.› ");
INSERT INTO xsm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O yuutu wʋm ma lǝr-o o dɩ o wɩ: ‹Aá pa n ta n te tɩɩnɩ dɩnu.› ");
INSERT INTO xsm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wʋlʋ na yɩ batɔ-tu wʋm tɩn dɩ ma daa ba o ta dɩd-o o wɩ: ‹A yuutu, nan joŋi nmʋ sǝbu-sɩŋa dalɩ dɩm. A kwe-dɩ mʋ a kukuli dɩ yu-kwala a tiŋi, ");
INSERT INTO xsm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","a na ye nɩ nmʋ laŋa damma, yɩ a kwarɩ fʋʋnɩ dɩ nmʋ tɩn ŋwaanɩ. Nmʋ yǝni n joŋi nyɔɔrɩ wǝǝnu tɩlʋ nmʋ yɩra na wʋ cɛ tɩ baŋa nɩ tɩn, yɩ n zagɩ mɩna yalʋ n tɩtɩ na wʋ dugi tɩn.› ");
INSERT INTO xsm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O yuutu wʋm laan ma ta dɩd-o o wɩ: ‹Nmʋ yɩ tɩntʋŋ-balɔrɔ mʋ. N tɩtɩ ni-taanɩ dɩm mʋ brɩ nɩ n ba jɩgɩ bʋra. Nmʋ ya na ye nɩ a laŋa damma, yɩ a joŋi nyɔɔrɩ wǝǝnu tɩlʋ a yɩra na wʋ cɛ tɩ baŋa nɩ tɩn, yɩ a zagɩ mɩna yalʋ a tɩtɩ na wʋ dugi tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","bɛɛ nan yɩ nmʋ wʋ kwe a sǝbu kʋm n tiŋi bankɩ nɩ. Nmʋ ya na tiŋi-kʋ bankɩ nɩ, a ya wʋ́ ba a joŋi-kʋ dɩ nyɔɔrɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","O laan ma ta dɩ balʋ na zɩgɩ da tɩn o wɩ: ‹Joŋi-na sǝbu-sɩŋa dalɩ dɩm o tee nɩ á pa wʋlʋ na nɛ dala fugǝ kam tɩn tu.› ");
INSERT INTO xsm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ba ma ta dɩd-o ba wɩ: ‹Dɩ́ yuutu, wʋntʋ maŋɩ o jɩgɩ dala fugǝ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O ma lǝri o wɩ: ‹A lagɩ a ta abam sɩ wʋlʋ maama na maŋɩ o jɩgɩ woŋo tɩn, o ta wʋ́ joŋi kʋdoŋ o wǝli da. Wʋlʋ nan na maŋɩ o ba jɩgɩ kʋlʋkʋlʋ tɩn laan wʋ́ ba o ga kʋlʋ fɩnfɩɩn o ya na jɩgɩ tɩn dɩ. ");
INSERT INTO xsm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kʋ daarɩ, kʋ na yɩ a dʋna balʋ na ba lagɩ sɩ a taa yɩ ba pɛ tɩn, ve-na á ja-ba á ba yo seeni sɩ á gʋ-ba a yigǝ nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zezi dɛɛn na tagɩ wǝǝnu tɩm kʋntʋ maama o ti tɩn, o ma zaŋɩ o kwe cwǝŋǝ o tɔgɩ nɔɔna bam yigǝ o maa ve Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ba ma vu ba yi tɩ-balwa bale, ba yɩra mʋ Betifaazɩ dɩ Betani. Je sɩm kʋntʋ wʋ piu kʋdoŋ saŋa nɩ mʋ, kʋ yɩrɩ mʋ Olivi piu. Zezi ma tʋŋɩ nɔɔna bale o karabiǝ bam wʋnɩ, ");
INSERT INTO xsm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yɩ o ta dɩ ba o wɩ: «Ve-na á zʋ tɩʋ kʋlʋ na wʋ abam yigǝ nɩ tɩn. Á na zʋ kʋ wʋ, á wʋ́ na bɩna-pɔla na lǝgi da, yɩ nɔɔn-nɔɔnʋ daa ta wʋ garɩ ka baŋa. Ve-na á bwǝli-ka á ja ba á pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɔɔnʋ nan na bwe abam o wɩ: ‹Bɛɛ mʋ yɩ á bwǝli-ka?›, sɩ á ta dɩd-o nɩ: ‹Kʋ yɩ dɩ́ Yuutu wʋm mʋ lagɩ-ka.› » ");
INSERT INTO xsm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nɔɔna bale balʋ o na tʋŋɩ tɩn ma zaŋɩ ba vu sɩ ba nii. Ba ma sɩɩnɩ ba na nɩ kʋ yɩ o na tagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ba na wʋra ba bwǝli bɩna-pɔla kam tɩn, ka tiinǝ ma bwe-ba ba wɩ: «Bɛŋwaanɩ mʋ yɩ á wʋra á bwǝli bɩnaga kam?» ");
INSERT INTO xsm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ba ma lǝri ba wɩ: «Kʋ yɩ dɩ́ Yuutu wʋm mʋ lagɩ-ka.» ");
INSERT INTO xsm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ba ma ja-ka ba ja vu Zezi te. Ba laan ma kwe ba gwaarʋ ba daŋɩ ka baŋa nɩ, yɩ ba pa Zezi di ka baŋa. ");
INSERT INTO xsm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","O na maa kɛ tɩn, nɔɔna bam ma zul-o, yɩ ba kwe ba gwaarʋ ba lwarɩ cwǝŋǝ kam yuu nɩ, sɩ o taa ve tɩ baŋa nɩ o kɛa. ");
INSERT INTO xsm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","O na gɛ fɩnfɩɩn sɩ o yi Zeruzalɛm tɩn, o ma da cwǝŋǝ kalʋ na kwe ka tu Olivi piu kʋm seeni tɩn. O karabiǝ kɔgɔ kʋm maama laan ma puli sɩ ba taa zuli Baŋa-Wɛ dɩ kwǝr-dɛ. Ba maa tee Wɛ dɩ wʋpolo, dɩ wo-kamunnu tɩlʋ zanzan DƖ na kɩ yɩ ba yiǝ na tɩn ŋwaanɩ, ");
INSERT INTO xsm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yɩ ba wɩ: «Zuli-na pɛ wʋlʋ na tu dɩ́ Yuutu Wɛ yɩrɩ ŋwaanɩ tɩn. Ywǝǝni taa wʋ Wɛ-sɔŋɔ nɩ. Zulǝ dɩ taa wʋ Baŋa-Wɛ tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farizɩan tiinǝ badonnǝ na tɔgɩ ba wʋ kɔgɔ kʋm wʋnɩ tɩn ma ta dɩ Zezi ba wɩ: «Karanyɩna, bagɩ n karabiǝ bam sɩ ba yɩ taa tɛ kʋntʋ doŋ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O ma lǝri-ba o wɩ: «A lagɩ a ta abam sɩ, bantʋ na cɩm, kandwa yam tɩtɩ wʋ́ kaasɩ dɩ kwǝr-dɛ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zezi ma vu o twɛ Zeruzalɛm. O na nɛ tɩʋ kʋm tɩn, o ma keeri kʋ nɔɔna bam ŋwaanɩ, ");
INSERT INTO xsm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yɩ o wɩ: «Zeruzalɛm tiinǝ-ba, á ya na lwarɩ zɩm dɛ dɩm nɩ wǝǝnu tɩlʋ ya na wʋ́ pa sɩ á taá zʋʋrɩ dɩ ywǝǝni tɩn, kʋ ya wʋ́ ta lana. Wo-laarʋ tɩm kʋntʋ nan sǝgi abam tee nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Taá ye-na sɩ maŋa wʋ́ ba, yɩ á dʋna wʋ́ ba ba gilimi á tɩʋ kʋm maama. Baá cɩ kʋ niǝ yam maama sɩ nɔɔn-nɔɔnʋ daa yɩ wanɩ o nuŋi kʋ wʋnɩ, ");
INSERT INTO xsm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","yɩ baá tiini ba cɔgɩ tɩʋ kʋm dɩdaanɩ abam balʋ na zʋʋrɩ kʋ wʋnɩ tɩn. Ba na cɔgɩ-kʋ ba ti, tɩʋ kʋm kandwɛ daa bá daŋɩ dɩdoŋ baŋa nɩ. Kʋ yɩ abam na wʋ lwarɩ nɩ maŋa kam yiǝ, sɩ Wɛ ba DƖ vrɩ abam tɩn ŋwaanɩ mʋ wǝǝnu tɩm kʋntʋ maama wʋ́ kɩ abam baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zezi ma vu o zʋ Wɛ-di-kamunu kʋm wʋ. O ma na balʋ na je da ba pipi tɩn. O ma puli sɩ o zǝli-ba sɩ ba nuŋi. ");
INSERT INTO xsm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","O ma ta dɩ ba o wɩ: «Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ, nɩ Wɛ mʋ wɩ: ‹Amʋ digǝ kantʋ maŋɩ sɩ ka taa yɩ jǝgǝ kalʋ nɔɔna na wʋ́ ta tui ba warɩ amʋ da tɩn mʋ.› Abam nan pɛ ka ji ŋwɩɩna joro jǝgǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dɛ maama Zezi maa wʋ Wɛ-di-kamunu kʋm wʋnɩ o brɩ nɔɔna Wɛ taanɩ dɩm. Kʋ daarɩ Zwifǝ kaanɩm yigǝ tiinǝ dɩ ba cullu karanyɩna tiinǝ bam dɩ tɩʋ kʋm dɩdɛɛra bam maa kwaana, sɩ ba na cwǝŋǝ ba gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ba maa yǝri ba na wʋ́ kɩ te, bɛŋwaanɩ nɔɔna bam maama cǝgi o taanɩ dɩm lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dɛ dɩdwɩ mʋ Zezi dɛɛn wʋ Wɛ-di-kamunu kʋm wʋnɩ, o tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam o brɩ nɔɔna. Zwifǝ bam kaanɩm yigǝ tiinǝ dɩ cullu karanyɩna tiinǝ bam dɩ ba tɩʋ kʋm nakwa bam ma vu ba yi o te. ");
INSERT INTO xsm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ba ma ta dɩd-o ba wɩ: «Ta n brɩ dɩbam, wɔɔ dam mʋ n ma n kɩ wǝǝnu tɩlʋ maama n na kɩ tɩn? Wɔɔ mʋ pɛ nmʋ ni, sɩ n ta n kɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","O ma lǝri-ba o wɩ: «A dɩ jɩgɩ bwiǝ a lagɩ a bwe abam, sɩ á lǝri-ya á pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Zan na miisi nɔɔna na wʋnɩ tɩn, kʋ yɩ Wɛ mʋ pɛ-o cwǝŋǝ naa nabiinǝ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","O na bwe-ba kʋntʋ tɩn, ba maa wʋra ba bwɛ daanɩ sɩ ba nii, ba na wʋ́ lǝr-o te tɩn. Ba laan ma wɩ: «Dɩbam na lǝri dɩ́ wɩ, kʋ yɩ Wɛ mʋ, o laan wʋ́ bwe dɩbam nɩ, bɛɛ mʋ yɩ dɩ́ nan wʋ sɛ Zan taanɩ dɩm? ");
INSERT INTO xsm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dɩ́ nan na wɩ, kʋ yɩ nabiinǝ mʋ pɛ-o cwǝŋǝ, nɔɔna bam maama wʋ́ dʋlɩ dɩbam dɩ kandwa mʋ ba gʋ, bɛŋwaanɩ ba maama paɩ sɩ Zan yɩ Wɛ nijoŋnu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kʋntʋ ŋwaanɩ ba ma lǝri Zezi ba wɩ, ba yǝri wʋlʋ na pɛ Zan cwǝŋǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Zezi laan ma ta dɩ ba o wɩ: «Kʋ na yɩ kʋntʋ, amʋ dɩ bá sɛ sɩ a ta wʋlʋ na pɛ amʋ ni sɩ a taa tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Zezi ma maŋɩ mɩmaŋa o brɩ nɔɔna bam o wɩ: «Nɔɔnʋ wʋdoŋ mʋ wʋra. O ma zaŋɩ o cɩ gaarɩ, yɩ o daarɩ o jǝri tweeru tɩlʋ yɩrɩ na yɩ vinyǝ tɩn dɩ wʋnɩ. O laan ma kwe nɔɔna o yagɩ da sɩ ba taa tʋŋa, yɩ o daarɩ o beeri o vu tɩʋ kʋdoŋ o daanɩ da. ");
INSERT INTO xsm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tweeru tɩm biǝ gwǝrim maŋa ma yi. O ma tʋŋɩ o tɩntʋŋnʋ sɩ o vu nɔɔna balʋ na nii o gaarɩ dɩm baŋa nɩ tɩn te, sɩ ba cɛ o tǝri ba pa-o. Tɩntʋŋnʋ wʋm na yi ba te tɩn, ba ma mag-o. Ba daarɩ ba pa o viiri dɩ jɩ-kʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɔɔnʋ wʋm daa ma tʋŋɩ o tɩntʋŋnʋ wʋdoŋ. Ba ma magɩ wʋntʋ dɩ, yɩ ba twɩ-o zanzan. Ba ma pa o dɩ viiri dɩ jɩ-kʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O daa ma tʋŋɩ tɩntʋŋnʋ wʋdoŋ o kɩ kuni bɩtɔ. Ba ma ja wʋntʋ dɩ ba magɩ o yɩra ba kaarɩ, yɩ ba zǝl-o gaarɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Gaarɩ dɩm tu wʋm laan ma bʋŋɩ o wɩ: ‹A nan wʋ́ kɩ ta mʋ? Amʋ na wʋ́ kɩ te tɩn, aá tʋŋɩ a tɩtɩ bu wʋlʋ a na so-o tɩn mʋ. Kʋ ba dwe, baá ta kwarɩ wʋntʋ.› ");
INSERT INTO xsm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nɔɔna bam na nɛ-o tɩn, ba ma bwɛ daanɩ ba wɩ: ‹Mʋ gaarɩ dɩm tu bu. Wʋntʋ mʋ lagɩ o ba o taa te o ko wʋm wǝǝnu tɩm. Pa-na dɩ́ gʋ-o, sɩ dɩ́ daarɩ dɩ́ taá te o wǝǝnu tɩm.› ");
INSERT INTO xsm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ba laan ma vaŋ-o ba ja nuŋi gaarɩ dɩm wʋnɩ, yɩ ba mag-o ba gʋ.» Zezi laan ma bwe-ba o wɩ: «Gaarɩ dɩm tu laan wʋ́ kɩ nɔɔna bam kʋntʋ ta mʋ? ");
INSERT INTO xsm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O maŋɩ sɩ o ba o gʋ-ba mʋ, sɩ o daarɩ gaarɩ dɩm o pa nɔɔna badonnǝ sɩ ba taa niǝ.» Nɔɔna bam na ni kʋntʋ tɩn, ba ma ta ba wɩ: «Wɛ pa kʋ yɩ kɩ kʋntʋ!» ");
INSERT INTO xsm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Zezi ma nii ba seeni yɩ o wɩ: «Kʋ na daɩ kʋntʋ, bɛɛ mʋ yɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Kandwɛ dɩlʋ lwara na vɩn tɩn laan mʋ joori dɩ ba dɩ ji kandwɛ dɩlʋ na paɩ sɔŋɔ kʋm dana tɩn›? ");
INSERT INTO xsm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɔɔnʋ wʋlʋ maama na tʋ kandwɛ dɩntʋ baŋa nɩ tɩn wʋ́ cɩcʋgɩ o tɩtɩ mʋ. Kʋ daarɩ, wʋlʋ maama kandwɛ dɩm na tʋ o baŋa nɩ tɩn, dɩ wʋ́ mɩɩrɩ kʋntʋ tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Zezi na tagɩ wǝǝnu tɩm kʋntʋ tɩn, Zwifǝ kaanɩm yigǝ tiinǝ dɩ cullu karanyɩna tiinǝ ma lwarɩ sɩ o maŋɩ mɩmaŋɩ dɩm bam ŋwaanɩ mʋ. Kʋntʋ tɩn, ba ma kwaanɩ ba lagɩ cwǝŋǝ sɩ ba ja-o lɩla. Ba maa warɩ, ba na kwarɩ fʋʋnɩ dɩ nɔɔna bam tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Zwifǝ yigǝ tiinǝ bam dɛɛn ma yɩrɩ Zezi, sɩ ba daa ta nii o na wʋ́ ta kʋlʋ tɩn. Ba ma lagɩ cwǝŋǝ sɩ ba brɩ nɩ o dwǝgǝ, sɩ ba wanɩ ba ja-o, sɩ ba daarɩ ba kɩ-o gʋvɩrma tu wʋm jɩŋa nɩ sɩ o di o sarɩya. Ba ma lɩ nɔɔna sɩ ba vu Zezi te nɩnɛɛnɩ ba yɩ nɔn-ŋʋna mʋ te, sɩ ba laan kwaanɩ ba ja-o dɩ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bantʋ ma vu Zezi te ba bwe-o ba wɩ: «Karanyɩna, dɩ́ ye nɩ taanɩ dɩlʋ nmʋ na yǝni n tɛ n brɩ nɔɔna tɩn yɩ cɩga mʋ. Nmʋ ba pɔɔrɩ nɔɔna daanɩ dɩ n na kɩ-ba te tɩn. Nmʋ nan yǝni n brɩ nɔɔna Wɛ cwǝŋǝ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dɩ́ lagɩ dɩ́ bwe dɩ́ nii, dɩbam cullu pɛ ni sɩ dɩ́ ŋwɩ lampoo dɩ́ pa lʋgʋ kʋm pa-farʋ wʋm na?» ");
INSERT INTO xsm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Zezi ma lwarɩ ba na kɩ ba swan yam dɩd-o te tɩn, o ma ta dɩ ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Kwe-na sǝbu dalɩ á brɩ-nɩ. Dɩ jɩgɩ wɔɔ nyɩnyʋgʋ dɩ o yɩrɩ mʋ dɩ baŋa nɩ?» Ba ma lǝr-o ba wɩ: «Kʋ yɩ pa-farʋ wʋm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","O laan ma ta dɩ ba o wɩ: «Kʋ lamma. Á nan taá ŋwɩ kʋlʋ na yɩ pa-farʋ wʋm nyɩm tɩn á pa-o, sɩ á daarɩ á taá paɩ Wɛ kʋlʋ dɩ na yɩ DƖ nyɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Zezi na tagɩ kʋntʋ dɩ ba tɩn, ba maa warɩ ba ja-o nɔɔna bam maama yigǝ nɩ dɩ o na tagɩ kʋlʋ tɩn. O na lǝri-ba te tɩn sʋ-ba zanzan yɩ ba cɩm. ");
INSERT INTO xsm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusɩan tiinǝ badonnǝ dɛɛn ma zaŋɩ ba vu Zezi te. Bantʋ zaasɩm mʋ brɩ sɩ, nɔɔnʋ na tɩga, o daa bá joori o bi. ");
INSERT INTO xsm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ba ma vu ba bwe-o ba wɩ: «Karanyɩna, Moyisi dɛɛn na pʋpʋnɩ kʋlʋ o tiŋi o pa dɩbam tɩn, o brɩ sɩ, nɔɔnʋ nu-bu na tɩga yɩ o daarɩ kaanɩ, yɩ ba na wʋ lʋgɩ biǝ, tʋ wʋm cʋrʋ mʋ maŋɩ sɩ o di kaanɩ wʋm sɩ ba wanɩ ba lʋ biǝ o nu-bu wʋlʋ na tɩgɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kʋntʋ tɩn, nu-biǝ barpɛ mʋ ya wʋra. Ba dɩdʋa ma di kaanɩ yɩ o tɩ o daar-o, yɩ ba ba jɩgɩ biǝ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wʋlʋ na saŋɩ tɩn ma di kadǝm wʋm. ");
INSERT INTO xsm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","O dɩ ma tɩ o daar-o. Batɔ-tu wʋm dɩ daa ma di-o. Kʋ ma kɩ ba maama kʋntʋ doŋ. Ba maama barpɛ ma tɩ, yɩ ba wʋ lʋgɩ bu dɩ kaanɩ wʋm. ");
INSERT INTO xsm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ba maama na tɩgɩ tɩn, kaanɩ wʋm dɩ laan ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kʋntʋ tɩn, ba maama barpɛ na di kaanɩ wʋm tɩn, ba laan na tu ba bi ba yagɩ tʋʋnɩ, bantʋ wɔɔ mʋ wʋ́ ta te kaanɩ wʋm?» ");
INSERT INTO xsm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Zezi ma lǝri-ba o wɩ: «Kʋ na yɩ zɩm lʋgʋ baŋa nɔn-biǝ mʋ, baara di kaana yɩ kaana dɩ zʋʋrɩ banna. ");
INSERT INTO xsm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kʋ daarɩ, nɔɔna balʋ Wɛ na nii nɩ ba maŋɩ sɩ ba bi ba yagɩ tʋʋnɩ sɩ ba laan taa zʋʋrɩ DƖ lʋ-dʋŋʋ kʋm nɩ tɩn, bantʋ bá di kaana, yɩ kaana dɩ daa bá zʋ banna. ");
INSERT INTO xsm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba daa bá wanɩ ba tɩ, ba na wʋ́ ta nyɩ dɩ Wɛ malɛsɩ sɩm tɩn ŋwaanɩ. Ba yɩ Wɛ tɩtɩ biǝ mʋ, dɩ ba na bi ba yagɩ tʋʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kʋ nan na yɩ twa biim, Moyisi maŋɩ o brɩ nɩ nɔɔna wʋ́ sɩɩnɩ ba bi. O dɛɛn pʋpʋnɩ maŋa kalʋ Wɛ na brɩ DƖ tɩtɩ dɩd-o sabarɩ puŋu kʋm wʋnɩ yɩ DƖ ta kʋlʋ tɩn. Moyisi ma brɩ sɩ Yuutu Baŋa-Wɛ yɩ Abraham Wɛ, dɩ Yizakɩ Wɛ, dɩ Zakɔbɩ Wɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kʋ brɩ sɩ bantʋ daa ta jɩgɩ ŋwɩa mʋ Wɛ tee nɩ, bɛŋwaanɩ Baŋa-Wɛ yɩ naŋʋna Wɛ mʋ, sɩ DƖ daɩ twa Wɛ. Wɛ yibiyǝ nɩ, nɔɔna maama jɩgɩ ŋwɩa, dɩ balʋ na tɩgɩ tɩn dɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wɛ cullu karanyɩna tiinǝ badonnǝ na ni kʋntʋ tɩn, ba ma lǝri ba wɩ: «Karanyɩna, n tagɩ cɩga.» ");
INSERT INTO xsm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ba dɛɛn ma kwarɩ sɩ ba daa bwe-o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zezi laan ma ta dɩ ba o wɩ: «Nɔɔna yǝni ba wɩ, sɩ Krisi wʋm Wɛ na tʋŋɩ tɩn yɩ Pɛ Davidi dwi tu mʋ. Kʋ nan wʋ́ wanɩ kʋ taa yɩ kʋntʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davidi tɩtɩ nan pʋpʋnɩ Wɛ lǝŋ-ŋwɩ tɔnɔ kʋm wʋnɩ o wɩ: ‹Yuutu Baŋa-Wɛ tagɩ dɩ a Yuutu DƖ wɩ: Ba n jǝni a jazɩm nɩ, ");
INSERT INTO xsm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sɩ aá kɩ nmʋ dʋna maama n nɛ kuri nɩ sɩ n nɔ-ba nɩ tɩga te.› ");
INSERT INTO xsm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kʋntʋ tɩn, Davidi tɩtɩ na sɩɩnɩ o bǝŋi Krisi wʋm Wɛ na tʋŋɩ tɩn nɩ o Yuutu tɩn, kʋʋ́ kɩ ta mʋ sɩ o daa joori o taa yɩ Davidi naa?» ");
INSERT INTO xsm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nɔn-kɔgɔ kʋm maama ta na wʋra kʋ cǝgi o taanɩ dɩm kʋntʋ tɩn, o ma ta dɩ o karabiǝ bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Taá yɩrɩ-na á tɩtɩ dɩ cullu karanyɩna tiinǝ bam. Bantʋ soe sɩ ba taa zʋʋrɩ gwar-dɩdwaarʋ ba beerǝ, sɩ nɔɔna taa nii-ba. Ba na ve yaga, ba soe sɩ nɔɔna maama taa tui ba zuli-ba. Ba na yǝni ba zʋ ba Wɛ-di sɩm, ba ta lagɩ je-kamunnu mʋ sɩ ba taa je yigǝ nɩ. Ba na ve nɔɔnʋ sɔŋɔ sɩ ba di candiǝ, kʋ yɩ je-ŋʋŋa je mʋ ba lagɩ sɩ ba taa je da. ");
INSERT INTO xsm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ba nan yǝni ba ganɩ kadǝnǝ ba joŋi kʋlʋ maama ba na jɩgɩ tɩn. Ba kwǝri ba kɩ Wɛ-lor-dɩdwaarʋ, sɩ kʋ taa nyɩ nɩ ba yɩ nɔn-ŋʋna mʋ te. Wɛ wʋ́ tiini DƖ pa bantʋ na cam kʋ ja gaalɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zezi ta na wʋ Wɛ-di-kamunu kʋm wʋnɩ o brɩ nɔɔna bam kʋntʋ tɩn, o ma kwǝni o yuu wɛɛnɩ o nii je maama. O ma na nadunǝ na ve ba dɩ ba sǝbiǝ daka kalʋ na zɩgɩ da Wɛ pɛɛra ŋwaanɩ tɩn wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","O daa ta ma na kadǝm wʋdoŋ na tɔgɩ o wʋra, o yɩ yinigǝ tu mʋ. Wʋntʋ ma ja sǝbu dalɩ-balwa bale yɩranɩ mʋ o ja vu o dɩ daka kam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zezi na nɛ kʋntʋ tɩn, o ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, kadǝm wʋntʋ na yɩ yinigǝ tu tɩn, o dɩ sǝbu kʋ dwǝni balʋ maama na dɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bantʋ maama lɩ ba daarɩ mʋ. Kadǝm wʋm nan yɩ yinigǝ tu mʋ, yɩ o kwe kʋlʋ maama o na jɩgɩ sɩ o ma yǝgi o ni-wʋdiu tɩn o dɩ da.» ");
INSERT INTO xsm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nɔɔna badonnǝ dɛɛn ma tɛ Wɛ-di-kamunu kʋm taanɩ yɩ ba wɩ: «Nii-na kandwa yam ba na mɛ ba lɔ-ka tɩn na tiini ya lana te, yɩ ba ma pɛɛra yalʋ ba na pɛ Wɛ tɩn ba ma kɩ-ka lanyɩranɩ.» Zezi ma lǝri-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Kʋ na yɩ wǝǝnu tɩntʋ á na naɩ tɩn, maŋa wʋ́ ba ba, sɩ ba dɩ tɩ maama tɩga nɩ. Kandwɛ daa bá daŋɩ dɩdoŋ baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ba ma bwe-o ba wɩ: «Karanyɩna, maŋa kɔɔ mʋ kʋntʋ woŋo wʋ́ kɩ? Bɛɛ mʋ lagɩ kʋ kɩ maana kʋ brɩ dɩbam, sɩ dɩ́ lwarɩ nɩ wǝǝnu tɩntʋ lagɩ tɩ kɩ?» ");
INSERT INTO xsm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zezi ma lǝri-ba o wɩ: «Á fɔgɩ á cɩ á tɩtɩ, sɩ á yɩ pa nɔɔna ganɩ abam. Nɔɔna zanzan wʋ́ ba abam te dɩ amʋ yɩrɩ, ba ta dɩ abam nɩ ba dɩdʋa dɩdʋa mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, yɩ baá daarɩ ba ganɩ abam ba wɩ, maŋa kam yiǝ. Á nan yɩ sɛ á tɔgɩ bantʋ kwaga. ");
INSERT INTO xsm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Á wʋ́ ba á ni tigurǝ dɩ jara ŋwa. Á nan yɩ pa fʋʋnɩ zʋ abam. Wǝǝnu tɩm kʋntʋ maama maŋɩ sɩ tɩ da yigǝ tɩ kɩ mʋ, yɩ kʋ ta daɩ lʋgʋ tiim mɩmaŋa.» ");
INSERT INTO xsm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O daa ta ma ta dɩ ba o wɩ: «Dwi wʋ́ zaŋɩ dɩ kɩ jara dɩ dwi dɩdoŋ, yɩ tɩʋ dɩ kʋ doŋ tɩʋ wʋ́ zaŋɩ tɩ magɩ jara. ");
INSERT INTO xsm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɩga ma wʋ́ sisiŋi zanzan. Kana dɩ wʋ́ ba ka taa wʋ je sɩdonnǝ nɩ, yɩ yawɩ-loŋnu dɩ wʋ́ cɔgɩ nɔɔna zanzan. Wɛ wʋ́ pa wo-kɩnkagɩla yalʋ na brɩ DƖ dam tɩn taa kɩ wɛyuu nɩ, yɩ fʋʋnɩ wʋ́ ja nɔɔna ya ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kʋ na wʋ́ loori wǝǝnu tɩntʋ kǝm tɩn, nɔɔna wʋ́ ja abam dam ba pa á na yaara. Baá ja abam ba vu ba saŋɩ ba Wɛ-di sɩm nakwa tee nɩ, yɩ ba kɩ abam pɩɩna digǝ nɩ. Baá ja abam ba pa á zɩgɩ pwa dɩ dɩdɛɛra yigǝ nɩ, abam na tɔgɩ amʋ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kʋ nan wʋ́ pa á na pwǝlǝ sɩ á brɩ-ba Wɛ cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Taá ye-na kʋntʋ ni nɩ, sɩ á pa á bɩcara kɩ dam. Á yɩ taá kɩ liǝ, dɩ á na wʋ́ lǝri-ba tɩte sɩ á ma vrɩ á tɩtɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bɛŋwaanɩ amʋ wʋ́ pa abam wʋbʋŋ-ŋʋna dɩ á ni-taanɩ, kʋʋ́ pa á dʋna bá wanɩ ba twanɩ dɩ á na wʋ́ ta kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Abam tɩtɩ kwǝ dɩ á niinǝ, dɩ á cʋrrʋ dɩ á cilonnǝ wʋ́ ja abam ba kɩ dɩdɛɛra jɩŋa nɩ, yɩ baá gʋ abam badonnǝ. ");
INSERT INTO xsm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nɔɔna maama wʋ́ ta culi abam á na yɩ a nɔɔna tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Baá kɩ abam kʋntʋ, yɩ Wɛ ta wʋ́ ta nii á baŋa nɩ, yɩ á bá lagɩ á yuuywe sɩm dɩdʋa tɩtɩ dɩ á ga. ");
INSERT INTO xsm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Abam nan na kwaanɩ á kɩ pu-dɩa á zɩgɩ kǝŋkǝŋ, á wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Abam nan wʋ́ ba á na pamaŋna na gilimi Zeruzalɛm tɩʋ kʋm maama ba pu. Á na nɛ kʋntʋ, á laan wʋ́ lwarɩ nɩ maŋa kam yiǝ sɩ ba cɔgɩ-kʋ. ");
INSERT INTO xsm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Maŋa kam kʋntʋ nɩ, abam balʋ na zʋʋrɩ Zude nɩ tɩn maŋɩ sɩ á kɩ lɩla á nuŋi á duri á beeri pweeru je á sǝgi da. Balʋ na wʋ tɩʋ kʋm wʋnɩ tɩn maŋɩ sɩ á nuŋi lɩla. Balʋ dɩ na wʋ ba karɩ nɩ tɩn daa yɩ ve á zʋ tɩʋ kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bɛŋwaanɩ maŋa kantʋ nɩ mʋ yaara maŋɩ sɩ ya ba, Wɛ na wʋ́ vaŋɩ nɔɔna zwa tɩn ŋwaanɩ, sɩ kʋlʋ maama na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn laan kɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kantʋ maŋa kam nɩ kʋʋ́ tiini kʋ taa yɩ lɛɛrʋ dɩ kaana balʋ na jɩgɩ pwi tɩn, dɩ balʋ na jɩgɩ biǝ yɩ ba ŋɔgɩ yɩlɩ tɩn. Yaara zanzan wʋ́ ba tɩʋ kʋntʋ dɩ kʋ nɔɔna maama baŋa nɩ, yɩ Baŋa-Wɛ wʋ́ kwe DƖ bam ba yɩra nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba ma wʋ́ gʋ ba badonnǝ dɩ sʋ-zɔɔrʋ, yɩ ba daarɩ ba ja ba badonnǝ ba vɔ ba ja vu gambɛɛm dwi tiinǝ maama tɩtarɩ nɩ. Dwi-gɛ tiinǝ laan wʋ́ ba zʋ Zeruzalɛm tɩʋ kʋm wʋ ba karɩ ba nɔnɩ kʋ wǝǝnu ba cɔga taan, sɩ kʋ vu kʋ yi maŋa kalʋ Wɛ na pɛ-ba tɩn tiim.» ");
INSERT INTO xsm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Maŋa wʋ́ ba sɩ Wɛ pa wo-kɩnkagɩla yalʋ na brɩ DƖ dam tɩn taa kɩ wɩa wʋnɩ dɩ cana dɩ calɩcwɩ sɩm wʋnɩ. Liǝ wʋ́ ja lʋgʋ baŋa dwi tiinǝ maama, yɩ ba wʋbʋŋa vugimi dɩ nɩnɩʋ kʋm na bam na pɔgɩla dɩ sɔɔ zanzan tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Fʋʋnɩ zanzan wʋ́ pa nɔɔna wʋbʋŋa je ba na bʋŋɩ woŋo kʋlʋ na bɩɩnɩ lʋgʋ baŋa tɩn, bɛŋwaanɩ wɛyuu wʋ́ sisiŋi kʋ pa wǝǝnu tɩlʋ na wʋ wɛyuu nɩ tɩn maama vugimi daanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Maŋa kam kʋntʋ nɩ nɔɔna wʋ́ na Nabiin-bu wʋm na maa bɩɩnɩ lʋgʋ baŋa. Oó ta wʋ kunkwǝǝnu wʋnɩ o bɩɩnɩ dɩ dam, yɩ Wɛ paarɩ-zulǝ wʋ o tee nɩ zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Á na nɛ sɩ wǝǝnu tɩm kʋntʋ puli tɩ kɩa, sɩ á zaŋɩ á zɩgɩ lanyɩranɩ á kwǝni á yum wɛɛnɩ, bɛŋwaanɩ maŋa kam twɛ sɩ Wɛ vrɩ abam DƖ yagɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Zezi laan ma maŋɩ mɩmaŋa o brɩ-ba o wɩ: «Maanɩ-na á nii kapʋrʋ dɩ tweeru maama na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Á na nɛ nɩ tweeru wʋra tɩ kwi vɔɔrʋ, abam waɩ á lwarɩ nɩ kʋ twɛ yadɛ. ");
INSERT INTO xsm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kʋ nan yɩ bɩdwɩ mʋ dɩ á na nɛ wǝǝnu tɩlʋ a na tagɩ a brɩ abam tɩn na wʋra tɩ kɩa, sɩ á lwarɩ nɩ maŋa kam laan twɛ sɩ Wɛ paarɩ dɩm lagɩ dɩ ba nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wǝǝnu tɩntʋ maama wʋ́ ba wʋra tɩ kɩa, yɩ zɩm nɔɔna bam ta wʋ tɩgɩ ba ti. ");
INSERT INTO xsm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wɛyuu dɩ tɩga wʋ́ ba tɩ kɛ, yɩ amʋ taanɩ dɩm bá kɛ maŋa dɩ maŋa. ");
INSERT INTO xsm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Á taá fɔgɩ á cʋ á tɩtɩ, sɩ á yɩ taá bʋŋɩ wʋdi-fwaarʋ dim naa sa-nyɔgɔ wʋbʋŋa, naa á taá jɩgɩ liǝ dɩ á ŋwɩa wǝǝnu. Á na jɩgɩ wʋbʋŋa yantʋ doŋ, dɛ dɩlʋ amʋ Nabiin-bu wʋm na wʋ́ ba tɩn waɩ dɩ tui bɩdwɩ baŋa nɩ dɩ darɩ abam, ");
INSERT INTO xsm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","nɩ cɩkʋ na jaanɩ varɩm te tɩn. Bɛŋwaanɩ dɛ dɩm kʋntʋ wʋ́ ba li nɔɔnʋ wʋlʋ maama na wʋ lʋgʋ baŋa nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kʋntʋ tɩn, á taá yɩrɩ á tɩtɩ maŋa maama, sɩ á taá loori Wɛ sɩ DƖ pa abam dam, sɩ á wanɩ á nuŋi yaara yalʋ maama na lagɩ ya ba tɩn wʋnɩ, sɩ á daarɩ á vu á zɩgɩ amʋ Nabiin-bu wʋm yigǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Zezi dɛɛn yǝni o wʋ Wɛ di-kamunu kʋm wʋnɩ dɛ maama o brɩ nɔɔna Wɛ taanɩ dɩm. Tɩga na yǝni ka yi, o yǝni o nuŋi tɩʋ kʋm wʋ o vu Olivi piu kʋm seeni o pǝni da. ");
INSERT INTO xsm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kʋ daarɩ tɩga na yǝni ka pʋʋrɩ, nɔɔna bam maama yǝni ba zaŋɩ lɩla ba ve Wɛ di-kamunu kʋm, sɩ ba taa cǝgi o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kʋ dɛɛn gɛ fɩɩn sɩ Zwifǝ bam di ba candiǝ kalʋ yɩrɩ na yɩ Pakɩ tɩn. Candiǝ kam kʋntʋ nɩ mʋ ba yǝni ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ dɩ wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kaanɩm yigǝ tiinǝ dɩ cullu karanyɩna tiinǝ bam ma kwaanɩ ba lagɩ cwǝŋǝ, sɩ ba ja Zezi ba gʋ. Ba na kwarɩ fʋʋnɩ dɩ nɔɔna bam tɩn ŋwaanɩ, ba yǝri ba na wʋ́ kɩ te sɩ ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sʋtaanɩ laan ma zʋ Zudasɩ Yiskarɩyo bɩcarɩ. Wʋntʋ yɩ Zezi karabiǝ fugǝ-bale bam wʋ nɔɔnʋ dɩdʋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","O ma vu kaanɩm yigǝ tiinǝ dɩ Wɛ di-kamunu kʋm yɩrɩna yigǝ tiinǝ bam te sɩ ba banɩ ba nii, o na wʋ́ kɩ te o brɩ-ba cwǝŋǝ sɩ ba wanɩ ba ja Zezi. ");
INSERT INTO xsm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ba na ni kʋntʋ tɩn, ba wʋ ma poli zanzan. Ba ma di yǝlo ba maŋɩ daanɩ dɩ sǝbu ni. ");
INSERT INTO xsm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O ma sɛ. O laan ma beeri cwǝŋǝ sɩ o ja Zezi o kɩ ba jɩŋa nɩ, sɩ kɔgɔ kʋm yɩ zaŋɩ kʋ lwarɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kʋ ma ba kʋ yi dɛ dɩlʋ ba na puli sɩ ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ dɩ wʋnɩ tɩn. Dɛ dɩm kʋntʋ nɩ Zwifǝ bam yǝni ba gʋɩ pibalɩ mʋ ba ma di Pakɩ candiǝ kam. ");
INSERT INTO xsm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zezi ma lɩ Pɩyɛɛrɩ dɩ Zan yɩ o ta dɩ ba o wɩ: «Ve-na á kwɛ woŋo maama á pa dɩbam, sɩ dɩ́ ba dɩ́ di Pakɩ candiǝ kam.» ");
INSERT INTO xsm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ba ma bwe-o ba wɩ: «Nmʋ lagɩ sɩ dɩ́ vu jǝgǝ kɔɔ mʋ dɩ́ kwɛ jǝgǝ kam?» ");
INSERT INTO xsm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","O ma lǝri-ba o wɩ: «Cǝgi-na, á na ve á maa zʋʋrɩ tɩʋ kʋm wʋ, nɔɔnʋ wʋdoŋ wʋ́ jeeri abam o na zɩŋɩ kɔɔrʋ dɩ na. Da-na o kwaga á vu á zʋ sɔŋɔ kʋlʋ o na wʋ́ zʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Á na zʋa, sɩ á ta dɩ sɔŋɔ kʋm tu nɩ: ‹Dɩ́ karanyɩna wɩ, dɩ́ ba dɩ́ bwe dɩ́ nii, digǝ kalʋ o na wʋ́ jǝni da dɩ o karabiǝ bam sɩ ba di Pakɩ candiǝ kam wʋdiu kʋm tɩn wʋ yǝn mʋ?› ");
INSERT INTO xsm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oó brɩ abam wɛyuu digǝ, ka daga lanyɩranɩ, yɩ ka jɩgɩ woŋo kʋlʋ maama dɩ́ na lagɩ tɩn ka wʋnɩ. Ve-na á kwɛ candiǝ kam wǝǝnu tɩm á ti, sɩ dɩ́ laan ba.» ");
INSERT INTO xsm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ba ma zaŋɩ ba vu, yɩ ba sɩɩnɩ ba na woŋo maama nɩ Zezi na maŋɩ o ta te tɩn. Ba ma kwɛ Pakɩ candiǝ kam wʋdiu kʋm ba ti. ");
INSERT INTO xsm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wʋdiu dim maŋa na yi tɩn, Zezi jǝni dɩ o karabiǝ fugǝ-bale bam sɩ ba di wʋdiu kʋm. ");
INSERT INTO xsm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O laan ma ta dɩ ba o wɩ: «Amʋ ya tiini a lagɩ sɩ a di candiǝ kantʋ dɩ abam dɩ a wʋ maama, sɩ a laan daarɩ a yaarɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A nan lagɩ a ta abam sɩ, a daa bá di candiǝ kantʋ, sɩ kʋ taa ve maŋa kalʋ candiǝ kam kʋntʋ kuri na wʋ́ vu kʋ kweeli Wɛ paarɩ dɩm wʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Zezi na tagɩ kʋntʋ o ti tɩn, o laan ma joŋi tweeru biǝ sana dɩ zʋŋa, yɩ o kɩ Wɛ le tɩ ŋwaanɩ. O ma ta dɩ ba o wɩ: «Joŋi-na tɩntʋ á nyɔ á daarɩ á pa daanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A lagɩ a ta abam sɩ, kʋ na puli zɩm, a daa bá nyɔ wo-nyɔɔrʋ tɩntʋ, sɩ kʋ taa ve maŋa kalʋ Wɛ paarɩ dɩm na wʋ́ ba nɔɔna tɩtarɩ nɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Zezi laan ma kwe dɩpɛ, yɩ o kɩ Wɛ le dɩ ŋwaanɩ. O ma daarɩ o fɔ-dɩ o pa o karabiǝ bam yɩ o wɩ: «Amʋ yɩra yam mʋ tɩntʋ, a na lagɩ a kwe a pa abam ŋwaanɩ tɩn. Taá kɩ-na kʋntʋ doŋ, sɩ á taá ma guli a gulǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ba na di ba ti tɩn, o daa ma kwe zʋŋa dɩ ka wo-nyɔɔrʋ o kɩ Wɛ le tɩ ŋwaanɩ o pa-ba, yɩ o wɩ: «Wo-nyɔɔrʋ tɩntʋ brɩ sɩ Wɛ goni ni-dʋʋrɩ dɩdaanɩ nabiinǝ amʋ jana kam ŋwaanɩ. A jana kam lagɩ ka nuŋi ka duri abam ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nan nii-na, nɔɔnʋ wʋlʋ na lagɩ o yǝgi-nɩ o pa nɔɔna tɩn tɔgɩ o je dɩ amʋ o di yo seeni. ");
INSERT INTO xsm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kʋ nan fɩn mʋ sɩ amʋ Nabiin-bu wʋm tɩ, nɩ Wɛ na maŋɩ DƖ lagɩ te tɩn. Kʋ nan za yɩ lɛɛrʋ mʋ kʋ pa nɔɔnʋ wʋlʋ na wʋ́ yǝgi-nɩ o pa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ba na ni o na tagɩ kʋlʋ tɩn, ba ma sɩŋɩ ba bwe daanɩ ba nii, bantʋ wʋnɩ wɔɔ mʋ wʋ́ wanɩ o kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zezi karabiǝ bam dɛɛn magɩ kantɔgɔ kʋ cɛ, sɩ ba nii bantʋ wʋnɩ wɔɔ mʋ yɩ kamunu o dwe ba maama. ");
INSERT INTO xsm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zezi ma ta dɩ ba o wɩ: «Kʋ na yɩ lʋgʋ baŋa pwa, bantʋ yǝni ba te ba nɔɔna dɩ dam mʋ. Balʋ na di dam nɔɔna baŋa nɩ tɩn, nɔɔna bam daa ta yǝni ba bǝ-ba ba wɩ ‹Lanyɩran-kǝrǝ› mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Abam nan wʋ maŋɩ sɩ á taá yɩ kʋntʋ doŋ. Wʋlʋ na yɩ nɔn-kamunu abam wʋnɩ tɩn maŋɩ sɩ o ji nɩ á nyaanɩ mʋ te. Wʋlʋ dɩ na yɩ abam yuutu tɩn maŋɩ sɩ o ji nɩ á tɩntʋŋnʋ mʋ te. ");
INSERT INTO xsm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wʋlʋ na jǝni sɩ o di wʋdiu tɩn, dɩ wʋlʋ na kwe wʋdiu kʋm o ja ba o pa-o tɩn, bantʋ wɔɔ mʋ yɩ kamunu? Kʋ daɩ wʋlʋ na jǝni sɩ o di tɩn mʋ na? Kʋ nan na yɩ amʋ, a wʋ abam wʋnɩ yɩ a kɩ nɩnɛɛnɩ wʋlʋ na yɩ á tɩntʋŋnʋ tɩn mʋ te. ");
INSERT INTO xsm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Abam nan yɩ balʋ na tɔgɩ dɩ amʋ a cam maama wʋnɩ, yɩ á wʋ yagɩ a tɔgɩm. ");
INSERT INTO xsm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aá pa abam tɔgɩ á di paarɩ, nɩ a Ko Wɛ na pɛ sɩ a di paarɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kʋntʋ tɩn, á wʋ́ ba á zʋ a paarɩ dɩm wʋ, yɩ á tɔgɩ dɩ amʋ á jǝni á di ywǝǝni. Á wʋ́ ba á jǝni paarɩ jangwaanʋ tɩm baŋa nɩ, sɩ á di Yisɩrayɛlɩ dwi tiinǝ kuri fugǝ-bale bam taanɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Zezi laan ma ta dɩ Simɔn Pɩyɛɛrɩ o wɩ: «Simɔn, Simɔn, sʋtaanɩ sɩɩnɩ dɩ na cwǝŋǝ sɩ dɩ maŋɩ abam dɩ nii, nɩ nɔɔnʋ na caarɩ mɩna te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amʋ nan loori Wɛ a pa nmʋ, sɩ n kɩ n wʋ-dɩdʋa dɩ amʋ sɩ n yɩ yagɩ-nɩ. Nmʋ nan na tusi, yɩ n wʋbʋŋa na joori ya tɔgɩ amʋ, sɩ n pa n ko-biǝ fɔgɩ ba zɩgɩ kǝŋkǝŋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pɩyɛɛrɩ laan ma ta dɩd-o o wɩ: «A Yuutu, ba na lagɩ ba kɩ amʋ dɩ nmʋ pɩɩna digǝ nɩ, naa ba na lagɩ ba gʋ dɩbam, a ta bá sɛ sɩ a joori nmʋ kwaga nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Zezi ma lǝr-o o wɩ: «Pɩyɛɛrɩ, a lagɩ a ta nmʋ sɩ, kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri zɩm tɩ-bra-pʋra nɩ tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O laan ma ta dɩ ba maama o wɩ: «A daama na tʋŋɩ abam sɩ á tʋlɩ á tɔɔlɩ Wɛ kwǝrǝ kam yɩ á ba jɩgɩ sǝbiǝ gan-lɔgɔdɩ dɩ tampɔgɔ dɩ natra tɩn, woŋo muri abam na?» Ba ma lǝri ba wɩ: «Awo, dɩ́ wʋ gɛ kʋlʋkʋlʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O ma ta dɩ ba o wɩ: «Kʋ daarɩ lele kʋntʋ, wʋlʋ na jɩgɩ sǝbiǝ gan-lɔgɔdɩ tɩn, kʋntʋ tu maŋɩ sɩ o kwe-dɩ mʋ. Wʋlʋ dɩ na jɩgɩ tampɔgɔ tɩn maŋɩ sɩ o kwe-kʋ mʋ. Wʋlʋ maama na ba jɩgɩ sʋ-lɔŋɔ tɩn, kʋntʋ tu maŋɩ sɩ o kwe o gɔrɔ mʋ o yǝgi o ma yǝgi sʋ-lɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Amʋ nan lagɩ a ta abam sɩ, kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ amʋ ŋwaanɩ tɩn maŋɩ sɩ kʋ kɩ, dɩ kʋ na wɩ: ‹Ba wǝl-o dɩ nɔn-balwaarʋ mʋ›. Kʋntʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ amʋ ŋwaanɩ tɩn laan wʋ́ kɩ lele.» ");
INSERT INTO xsm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Zezi karabiǝ bam ma ta dɩd-o ba wɩ: «Dɩ́ Yuutu, nii sʋ-lwaanʋ tɩle mʋ dɩ́ jɩga.» O ma lǝri-ba o wɩ: «Yagɩ-na sɩ kʋ maŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zezi dɛɛn ma nuŋi tɩʋ kʋm wʋnɩ o vu Olivi piu kʋm seeni, nɩ o na yǝni o kɩ te tɩn. O karabiǝ bam dɩ ma tɔg-o ba vu. ");
INSERT INTO xsm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ba na yi jǝgǝ kalʋ ba na maa ve tɩn, Zezi ma ta dɩ ba o wɩ: «Á taá loori Wɛ, sɩ á yɩ tʋ maŋɩm dɩm maŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","O laan ma fɔɔrɩ ba tee nɩ o vu o zɩgɩ daa nɩ, kʋ maŋɩ nɔɔnʋ na wʋ́ dʋlɩ kandwɛ yɩ dɩ yi mɛ tɩn. O ma kuni doonǝ o loori Wɛ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«A Ko, nmʋ na sɛ, sɩ n pa cam dɩlʋ na lagɩ dɩ ba amʋ baŋa nɩ tɩn kɛ. Nan kɩ kʋlʋ na tɔgɩ nmʋ wʋbʋŋa tɩn, sɩ yɩ kɩ amʋ wʋbʋŋa na lagɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","O na loori Wɛ kʋntʋ tɩn, Wɛ malɛka ma nuŋi wɛyuu ka ba o te, yɩ ka wǝl-o dɩ dam. ");
INSERT INTO xsm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","O wʋ na tiini kʋ cɔgɩ zanzan tɩn ma pa o tiini o loori Wɛ dɩ o wʋ maama. O luluŋu ma ji nɩnɛɛnɩ jana te, yɩ kʋ luri tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","O na loori Wɛ o ti tɩn, o ma zaŋɩ o joori o vu o karabiǝ bam te. O ma na sɩ ba tigi ba dɔa wʋ-cɔgɔ kʋm ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O ma ta dɩ ba o wɩ: «Bɛɛ mʋ yɩ á dɔa? Zaŋɩ-na sɩ á taá loori Wɛ, sɩ á yɩ tʋ maŋɩm dɩm maŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zezi ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, nɔn-kɔgɔ laan ma ba kʋ yi o te. Zudasɩ wʋlʋ na yɩ o karabiǝ fugǝ-bale bam wʋ dɩdʋa tɩn ma tɔgɩ ba yigǝ. O ma fɔɔrɩ o yi Zezi te sɩ o kukwǝr-o. ");
INSERT INTO xsm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Zezi ma ta dɩd-o o wɩ: «Zudasɩ, nmʋ tu sɩ n pa ba ja amʋ Nabiin-bu wʋm, yɩ n ta lagɩ n kukwǝri-nɩ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zezi karabiǝ balʋ na wʋ o tee nɩ tɩn ma na kʋ na lagɩ kʋ kɩ-o te tɩn. Ba ma bwe-o ba wɩ: «Dɩ́ Yuutu, dɩ́ lɩ dɩ́ sʋ-lwaanʋ tɩm dɩ́ zagɩ-ba na?» ");
INSERT INTO xsm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba wʋ dɩdʋa ma lɩ o sʋgʋ kʋm o ma zagɩ kaanɩm yuutu wʋm tɩntʋŋnʋ jazɩm zwɛ o go. ");
INSERT INTO xsm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Zezi na nɛ kʋntʋ tɩn, o ma ta dɩ ba o wɩ: «Yagɩ-na». O ma vu o dwe nɔɔnʋ wʋm zwɛ dɩm, yɩ dɩ je, dɩ joori dɩ yɩ dɩ ya na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","O ma daarɩ o ta dɩ kaanɩm yigǝ tiinǝ bam dɩ Wɛ-di-kamunu kʋm yɩrɩna bam yigǝ tiinǝ dɩ nakwa bam, ba na tu sɩ ba ja-o tɩn, o wɩ: «Abam na kwe sʋ-lwaanʋ dɩ da-lwaanʋ á ba sɩ á ja amʋ tɩn, a yɩ ŋwɩɩnʋ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dɛ maama a yǝni a wʋ abam tee nɩ Wɛ-di-kamunu kʋm wʋnɩ, yɩ á wʋ jaanɩ amʋ. Kʋ nan na yɩ te tɩn, maŋa kam laan yiǝ sɩ á kɩ á wʋbʋŋa na lagɩ kʋlʋ tɩn, bɛŋwaanɩ maŋa mʋ yiǝ sɩ lim pɛ joŋi dam.» ");
INSERT INTO xsm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ba laan ma ja Zezi, yɩ ba ja-o ba kɛ. Pɩyɛɛrɩ ma dalɩ o tɔgɩ ba kwaga o da o vu. Ba ma vu ba yi kaanɩm yuutu wʋm sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ba ma dwe mini ba tiŋi sɔŋɔ kʋm tɩtarɩ nɩ. Nɔɔna bam ma vu ba je ba weeri mini dɩm. Pɩyɛɛrɩ dɩ ma tɔgɩ o vu o jǝni ba wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","O na tɔgɩ o je mini dɩm yigǝ nɩ kʋntʋ tɩn, sɔŋɔ kʋm tɩntʋŋ-kana kadoŋ ma yɔɔrɩ o nii o yibiyǝ nɩ, yɩ o wɩ: «Nɔɔnʋ wʋntʋ dɩ tɔgɩ o wʋ Zezi tee nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pɩyɛɛrɩ ma fʋ yɩ o wɩ: «Kaanɩ, a yǝr-o.» ");
INSERT INTO xsm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kʋ na kɩ fɩɩn tɩn, nɔɔnʋ wʋdoŋ dɩ daa ma na-o, yɩ o wɩ: «Nmʋ tɔgɩ n yɩ Zezi kɔgɔ kʋm nɔɔnʋ dɩdʋa mʋ.» Pɩyɛɛrɩ ma lǝri nɔɔnʋ wʋm o wɩ: «A tɔgɩ a daɩ ba wʋ nɔɔnʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kʋ daa na kɩ fɩɩn nɩnɛɛnɩ luu dɩdʋa tɩn, nɔɔnʋ wʋdoŋ dɩ daa ma ta o wɩ: «Nɔɔnʋ wʋntʋ sɩɩnɩ o tɔgɩ dɩd-o mʋ. O dɩ yɩ Galile tu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pɩyɛɛrɩ ma lǝri o wɩ: «Baarʋ, a yǝri n taanɩ dɩm kuri.» O ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, cɩbwɩʋ ma da kʋ keeri. ");
INSERT INTO xsm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dɩ́ Yuutu Zezi laan ma pipiri o yɔɔrɩ Pɩyɛɛrɩ o nii. Pɩyɛɛrɩ ma guli Zezi ya na tagɩ kʋlʋ dɩd-o o wɩ: «Kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri zɩm tɩ-bra-pʋra nɩ tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","O na guli kʋntʋ tɩn, o laan ma nuŋi, yɩ o tiini o keeri zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nɔɔna balʋ dɛɛn na yɩrɩ Zezi tɩn maa yáal-o ba mwan-o, yɩ ba kwǝri ba mag-o. ");
INSERT INTO xsm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ba ma kwe gɔrɔ ba ma kwǝli o yiǝ, yɩ ba daarɩ ba mag-o. Ba maa wɩ: «Lwarɩ n brɩ dɩbam wʋlʋ na magɩ-m tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ba ta maa ŋɔɔnɩ wǝǝnu dwi dwi ba ma cɔgɩ o yuu, yɩ ba twɩ-o zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɩga na pʋʋrɩ tɩn, Zwifǝ bam nakwa kɔgɔ kʋm maama ma la daanɩ, dɩ ba kaanɩm yigǝ tiinǝ bam dɩ ba cullu karanyɩna tiinǝ maama. Ba laan ma pa Zezi nuŋi o vu taanɩ dɩm dim jǝgǝ o zɩgɩ ba yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ba ma ta dɩd-o ba wɩ: «Nmʋ na sɩɩnɩ n yɩ Krisi wʋm Wɛ na maŋɩ sɩ DƖ tʋŋɩ DƖ pa dɩbam tɩn, sɩ n ta.» Zezi ma lǝri-ba o wɩ: «A na tagɩ kʋntʋ a brɩ abam, á ta bá sɛ a ni. ");
INSERT INTO xsm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A nan daa na bwe abam taanɩ dɩ, abam bá sɛ sɩ á lǝri á pa-nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kʋ na puli lele kʋntʋ, amʋ Nabiin-bu wʋm wʋ́ vu a jǝni Dam-Paŋwa Tu Baŋa-Wɛ jazɩm nɩ a da a di paarɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ba maama laan ma bwe-o ba wɩ: «Kʋntʋ tɩn, nmʋ nan sɩɩnɩ n yɩ Wɛ Bu wʋm mʋ na?» Zezi ma lǝri-ba o wɩ: «Mʋ abam na wɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba laan ma ŋɔɔnɩ daanɩ ba wɩ: «Dɩbam tɩtɩ laan mʋ ni o kwǝrǝ kam na brɩ o tɩtɩ cɔgɩm. Dɩ́ daa ba lagɩ maana tiinǝ sɩ ba ŋɔɔnɩ o taanɩ dɩm.» ");
INSERT INTO xsm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Zwifǝ bam nakwa kɔgɔ kʋm maama dɛɛn ma zaŋɩ ba ja Zezi ba ja vu gʋvɩrma tu Pilatɩ te. ");
INSERT INTO xsm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ba ma sɩŋɩ sɩ ba fɔ vwan ba pa-o, yɩ ba wɩ: «Dɩbam nɛ nɔɔnʋ wʋntʋ mʋ o jɩgɩ dɩ́ tɩʋ kʋm nɔɔna bam o gana sɩ ba tusi. O tɛ-ba o wɩ, ba yɩ taa laɩ lampoo ba paɩ gʋvɩrma. O maa kwǝri o brɩ o tɩtɩ nɩ wʋm mʋ yɩ Krisi, kʋ na lagɩ kʋ ta nɩ pɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatɩ na ni kʋntʋ tɩn, o ma bwe-o o wɩ: «Nmʋ mʋ yɩ Zwifǝ bam pɛ wʋm na?» Zezi ma lǝr-o o wɩ: «Mʋ ka da n taga.» ");
INSERT INTO xsm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatɩ ma ta dɩ kaanɩm yigǝ tiinǝ bam dɩ nɔn-kɔgɔ kʋm maama o wɩ: «Amʋ wʋ nɛ nɔɔnʋ wʋntʋ na kɩ kʋlʋ o cɔgɩ tɩn, sɩ dɩ́ di o taanɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba ma tiini ba ŋɔɔnɩ taanɩ dɩm, yɩ ba kwaana ba tɛ ba wɩ: «O nan yǝni o tʋlɩ Zude tɩɩnɩ dɩm maama, o brɩ nɔɔna bam sɩ ba yɩ taa sɛ ba tɩʋ kʋm dɩdɛɛra ni. O dɛɛn puli o kɩ kʋntʋ doŋ Galile nɩ mʋ, yɩ o laan yi yo seeni.» ");
INSERT INTO xsm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatɩ na ni kʋntʋ tɩn, o ma bwe-ba sɩ o nii, nɔɔnʋ wʋm yɩ Galile tu mʋ na? ");
INSERT INTO xsm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","O na tu o lwarɩ nɩ Zezi nuŋi tɩʋ kʋlʋ Erɔdɩ na te tɩn, o ma pa ba ja-o ba vu wʋntʋ te sɩ o di taanɩ dɩm, bɛŋwaanɩ Erɔdɩ dɩ tɔgɩ o wʋ Zeruzalɛm nɩ maŋa kam kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erɔdɩ na nɛ Zezi tɩn, o maa jɩgɩ wʋpolo zanzan, bɛŋwaanɩ o ya maŋɩ o ni o ŋwa, yɩ o tiini o lagɩ sɩ o na-o. O maa lagɩ sɩ o nii Zezi wʋ́ kɩ wo-kɩnkagɩlɩ o brɩ-o na. ");
INSERT INTO xsm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O ma kwaanɩ o bwe-o wǝǝnu zanzan. Zezi ma wʋ sɛ o lǝr-o kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kaanɩm yigǝ tiinǝ dɩ cullu karanyɩna tiinǝ bam maa tɔgɩ ba zɩgɩ da, yɩ ba tiini ba ŋɔɔnɩ taanɩ dɩm dɩ baarɩ sɩ ba ma dɩ-o. ");
INSERT INTO xsm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erɔdɩ dɩ o pamaŋna bam laan ma gooni Zezi zanzan. Ba pa o zʋ paarɩ gɔrɔ sɩ ba ma mwan-o, yɩ Erɔdɩ laan pa o joori o vu Pilatɩ te. ");
INSERT INTO xsm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dɩntʋ dɛ dɩm nɩ Erɔdɩ dɩ Pilatɩ laan di ciloŋo mʋ daanɩ, yɩ ba dɛɛn ya culi daanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatɩ ma pa kaanɩm yigǝ tiinǝ bam dɩ nakwa bam dɩ nɔɔna bam maama la daanɩ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","O ma ta dɩ ba o wɩ: «Abam na saŋɩ nɔɔnʋ wʋntʋ amʋ tee nɩ tɩn, yɩ á tɛ á wɩ, o yɩ wʋlʋ na ganɩ á tɩʋ kʋm nɔɔna bam o pa ba tusi tɩn, kʋntʋ mʋ a nan bwe-o abam yibiyǝ nɩ sɩ a nii, yɩ a wʋ nɛ kʋlʋ o na kɩ o cɔgɩ yɩ abam ja-o kʋ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erɔdɩ dɩ wʋ nɛ kʋlʋ o na cɔgɩ tɩn. Mʋ kʋ kuri o pɛ o joori o ba dɩbam te. Á taá ye sɩ kʋlʋkʋlʋ tǝrǝ kʋ na wʋ́ pa ba ja-o ba gʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kʋntʋ ŋwaanɩ aá pa ba mag-o dɩ balaarɩ mʋ, yɩ ba daar-o ba yagɩ.»  ");
INSERT INTO xsm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pakɩ candiǝ kam maŋa na yǝni ka ba yi, Pilatɩ maŋɩ sɩ o lɩ ba pɩɩnʋ dɩdʋa mʋ o yagɩ sɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nɔn-kɔgɔ kʋm maama ma kɩ daanɩ ba kaasɩ dɩ kwǝr-dɛ ba wɩ: «Kʋ na yɩ nɔɔnʋ wʋntʋ, ja-o n gʋ, sɩ n daarɩ n lɩ Barabasɩ n pa dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasɩ yɩ wʋlʋ ba dɛɛn na kɩ pɩɩna digǝ nɩ, o na kɩ jara dɩ ba tɩʋ kʋm dɩdɛɛra yɩ o gʋ nɔɔna tɩn ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɩ na lagɩ sɩ o lɩ Zezi o yagɩ tɩn ŋwaanɩ, o daa ma ta dɩ nɔɔna bam sɩ ba sɛ sɩ o yagɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ba ma daa ta vɩn, yɩ ba tiini ba kaasɩ baŋa baŋa ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ. Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","O daa ta ma ta dɩ ba o kɩ bɩtɔ o wɩ: «Bɛɛ wo-lɔŋɔ mʋ o kɩa? A wʋ nɛ kʋlʋ o na kɩ o cɔgɩ pa kʋ maŋɩ sɩ dɩ́ gʋ-o tɩn. Kʋntʋ tɩn, aá pa ba mag-o, yɩ a daarɩ a yag-o.» ");
INSERT INTO xsm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ba daa ta maa tiini ba kwaana ba kaasɩ dɩ kwǝr-dɛ, yɩ ba tɛ dɩ baarɩ ba wɩ: «N maŋɩ sɩ n pa-o dagara baŋa nɩ mʋ n gʋ.» Ba na tiini ba ŋɔɔnɩ dɩ kwǝr-dɛ tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","kʋ ma pa Pilatɩ sɛ sɩ o kɩ kʋlʋ ba na lagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O ma pa ni sɩ ba lɩ Barabasɩ wʋlʋ ba na lagɩ sɩ o yagɩ o pa-ba tɩn. Wʋntʋ mʋ yɩ wʋlʋ ba ya na jaanɩ ba kɩ pɩɩna digǝ nɩ, o na kɩ jara dɩ ba tɩʋ kʋm dɩdɛɛra yɩ o gʋ nɔɔnʋ tɩn ŋwaanɩ. Pilatɩ ma daarɩ o kɩ Zezi pamaŋna jɩŋa nɩ, sɩ ba kɩ-o nɩ kɔgɔ kʋm wʋbʋŋa na lagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pamaŋna bam laan ma ja Zezi ba maa kɛa. Nɔɔna bam maama maa tɔga. Ba na maa ve tɩn, ba ma jeeri nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Simɔn. O nuŋi Sirɛɛnɩ mʋ. O dɛɛn ya nuŋi gaa mʋ o ba o yi tɩʋ wʋnɩ o maa kɛa. Pamaŋna bam ma ja-o, yɩ ba pa o zɩŋɩ dagara kam o bakalɩ nɩ o tɔgɩ Zezi kwaga. ");
INSERT INTO xsm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zeruzalɛm kɔ-fɔrɔ dɛɛn maa tɔgɩ Zezi kwaga. Kaana dɩ maa tɔgɩ ba wʋra, yɩ ba keerǝ ba frɩ ba tɩtɩ o ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zezi ma pipiri o nii-ba yɩ o wɩ: «Zeruzalɛm kaana-ba, yɩ taá keeri-na amʋ ŋwaanɩ. Á za taá keeri á tɩtɩ dɩ á biǝ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bɛŋwaanɩ maŋa wʋ́ ba ka yi, yɩ baá ta wɩ: ‹Kaanɩ wʋlʋ maama na yɩ ka-dʋgʋ tɩn yɩ yu-yoŋo tu mʋ. Wʋlʋ na maŋɩ o wʋ lʋgɩ bu sɩ o pa o ŋɔgɩ yɩlɩ tɩn jɩgɩ yu-yoŋo zanzan.› ");
INSERT INTO xsm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yaara yam kʋntʋ maŋa na yiǝ, nɔɔna wʋ́ loori pweeru sɩ tɩ tʋ ba baŋa nɩ, yɩ ba loori pu-kum sɩ tɩ kwǝli-ba. ");
INSERT INTO xsm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Taá nii-na, da-lɩa na jɩgɩ mini ka di tɩntʋ tɩn, kʋ laan na yɩ da-kʋra, kaá kɩ ta?» ");
INSERT INTO xsm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ba dɛɛn ma ja nɔn-balwaarʋ tɩle ba vu sɩ ba wǝli dɩ Zezi ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ba ma vu ba yi jǝgǝ kalʋ yɩrɩ na yɩ Yukol-pʋa piu tɩn. Ba laan ma ja Zezi ba pa dagara kam baŋa nɩ. Ba ma ja nɔn-balwaarʋ tɩm dɩ, ba pa dagarɩ sɩdonnǝ baŋa nɩ. Ba ma cwi dɩdʋa Zezi jazɩm nɩ. Wʋwʋm maa wʋ o jagwiǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ba na pagɩ Zezi dagara kam baŋa nɩ kʋntʋ tɩn, o ma loori Wɛ o wɩ: «A Ko, yagɩ n ma n cɛ-ba, sɩ ba yǝri woŋo kʋlʋ ba na kɩ tɩn.» Pamaŋna bam na lagɩ ba maŋɩ o gwaarʋ tɩm tɩn, ba tagɩ jɔrɔ mʋ ba ma maŋɩ-tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nɔn-kɔgɔ kʋm maa zɩgɩ da ba niǝ. Zwifǝ bam nakwa bam ma kɩ-o cavɩɩra, yɩ ba mwana ba wɩ: «O yǝni o vrɩ nɔɔna ŋwɩa. O na sɩɩnɩ o yɩ Krisi wʋm Wɛ na kuri tɩn, sɩ o vrɩ o tɩtɩ ŋwɩa sɩ dɩ́ nii.» ");
INSERT INTO xsm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pamaŋna bam dɩ maa mwan-o, yɩ ba jɩgɩ sa-nywana ba suŋi o yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ba maa wɩ: «Nmʋ na sɩɩnɩ n yɩ Zwifǝ bam pɛ, sɩ n vrɩ n tɩtɩ ŋwɩa sɩ dɩ́ nii.» ");
INSERT INTO xsm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ba dɛɛn ya pʋpʋnɩ tɔnɔ ba tanɩ-kʋ daa kam yɩra nɩ o yuu baŋa nɩ, yɩ kʋ wɩ: ");
INSERT INTO xsm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nɔn-balwaarʋ tɩlʋ ba na pagɩ dɩ Zezi tɩn dɩdʋa maa jɩgɩ Zezi o twɩa yɩ o wɩ: «Kʋ daɩ nmʋ mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn na? Nan vrɩ n tɩtɩ ŋwɩa, sɩ n daarɩ n vrɩ dɩbam dɩ n wǝli da.» ");
INSERT INTO xsm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nɔn-balɔrɔ kʋdoŋ kʋm ma kaanɩ kʋkʋm kʋm kʋ wɩ: «Nmʋ ba kwarɩ Wɛ fʋʋnɩ na? Ba lagɩ ba gʋ dɩbam maama mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kʋ na yɩ dɩbam, dɩbam tʋʋnɩ dɩm maŋɩ, bɛŋwaanɩ kǝm-balwaarʋ tɩlʋ dɩ́ na kɩ tɩn, kʋ maŋɩ sɩ dɩ́ tɩ mʋ. Kʋ nan na yɩ nɔɔnʋ wʋntʋ, o wʋ kɩ kʋlʋkʋlʋ o cɔgɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","O ma daarɩ o ta dɩ Zezi o wɩ: «Nmʋ na tu n ba n joŋi n paarɩ dɩm, sɩ n guli a gulǝ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Zezi ma lǝr-o o wɩ: «A lagɩ a ta cɩga dɩ nmʋ sɩ, nmʋ wʋ́ jǝni dɩ amʋ Wɛ-sɔŋɔ kʋm nɩ zɩm dɛ dɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kʋ ma vu kʋ yi maŋa kam wɛ na tu dɩ yi yuparɩ baŋa tɩn. Lʋgʋ kʋm maama ma ji lim taan, sɩ kʋ vu kʋ yi luu batɔ. ");
INSERT INTO xsm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wɩa kam daa ba jɩgɩ pooni. Gɔrɔ kʋlʋ ba na lǝgǝ ba ma cɩ Wɛ-di-laa kam tɩn ma kaarɩ bɩle. ");
INSERT INTO xsm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Zezi laan ma kaasɩ dɩ kwǝr-dɩa o wɩ: «Amʋ Ko, a kwe a joro a kɩ nmʋ jɩŋa nɩ.» O na tagɩ kʋntʋ tɩn, o ma daarɩ o tɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pamaŋna bam yigǝ tu wʋm na nɛ kʋlʋ na kɩ tɩn, o ma tee Wɛ yɩ o wɩ: «Kʋ yɩ cɩga pwɛɛn. Nɔɔnʋ wʋntʋ sɩɩnɩ o yɩ nɔn-ŋʋm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kɔgɔ kʋlʋ maama na tu sɩ kʋ nii kǝm dɩm tɩn ma sɩɩnɩ ba na kʋ na kɩ te tɩn. Ba na ma joori sɔŋɔ tɩn, ba maa frɩ ba tɩtɩ ba veǝ, ba wʋ na cɔgɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kʋ daarɩ balʋ maama na maŋɩ ba ye-o tɩn dɩ kaana balʋ ya na tɔgɩ dɩd-o ba nuŋi Galile ba ba tɩn maa zɩgɩ daa nɩ ba niǝ. ");
INSERT INTO xsm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Zʋzɛfʋ. O nuŋi Zwifǝ tɩʋ kʋdoŋ mʋ, kʋ yɩrɩ mʋ Arimatɩ. O maa yɩ Zwifǝ bam nakwa kɔgɔ kʋm nɔɔnʋ dɩdʋa mʋ. O ma kwǝri o yɩ nɔn-ŋʋm, yɩ o tɔgɩ Wɛ dɩ cɩga. Ba kɔgɔ kʋm ya na kɩ ni daanɩ sɩ ba ja Zezi tɩn, o wʋ sɛ ba na bʋŋɩ sɩ ba kɩ-o kʋlʋ tɩn. O maa jɩgɩ tɩɩna sɩ Wɛ paarɩ dɩm wʋ́ ba nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O ma zaŋɩ o vu Pilatɩ te, o loori cwǝŋǝ sɩ o vu parɩ Zezi yɩra yam o kɩ. ");
INSERT INTO xsm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilatɩ na sɛ tɩn, Zʋzɛfʋ ma vu o parɩ Zezi dagara kam yuu nɩ. Ba ma kwe gar-jalɩ ba ma pipir-o, yɩ ba daarɩ ba ja-o ba vu ba kɩ piu bɔɔnɩ wʋnɩ. Dɩntʋ yɩ bɔɔnɩ dɩlʋ ba dɛɛn na lugi-dɩ piu yɩra nɩ yɩ ba maŋɩ ba wʋ kɩ nɔɔnʋ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dɛ dɩm Zʋzɛfʋ na kɩ kʋntʋ tɩn maa yɩ dɛ dɩlʋ Zwifǝ bam na maŋɩ sɩ ba ti ba yigǝ ba siun dɛ dɩm ŋwaanɩ tɩn. Tɩga na yi, ba siun dɛ dɩm puli mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kaana balʋ ya na tɔgɩ dɩ Zezi ba nuŋi Galile tɩn dɛɛn ma da Zʋzɛfʋ kwaga, ba vu ba na bɔɔnɩ dɩm dɩ ba na tiŋi Zezi te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ba na nɛ kʋntʋ tɩn, ba ma joori ba vu sɔŋɔ. Ba ma vu ba lagɩ tralɩa nwi dwi dwi, sɩ ba ma turi Zezi yɩra yam. Ba siun dɛ dɩm nɩ ba ma sin dɩ ba tɩtʋŋa yam nɩ Wɛ cullu na brɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dɛ dɩlʋ na saŋɩ siun dɛ dɩm tɩn, kaana bam ma zaŋɩ ba go tɩga ba vu yibeeli dɩm jǝgǝ kam. Ba ma jɩgɩ tralɩa nwi sɩlʋ ba na lagɩ ba ma turi Zezi yɩra yam tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ba na yi jǝgǝ kam tɩn, ba ma na kandwɛ dɩlʋ ya na pɩ bɔɔnɩ dɩm ni tɩn bibili dɩ tigi daa nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba ma vu ba zʋ bɔɔnɩ dɩm wʋ. Ba wʋ nɛ dɩ́ Yuutu Zezi da. ");
INSERT INTO xsm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ba wʋbʋŋa ma vugimi, yɩ ba yǝri ba na wʋ́ bʋŋɩ kʋlʋ. Ba na zɩgɩ da kʋntʋ tɩn, nɔɔna bale ma da ba nuŋi ba zɩgɩ ba tee nɩ, yɩ ba zʋ gwaarʋ tɩ nyɩɩnɩ pʋgʋ pʋgʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Fʋʋnɩ ma ja kaana bam. Ba ma cɔɔlɩ ba yum tɩga nɩ. Nɔɔna bam laan ma ta dɩ ba ba wɩ: «Bɛŋwaanɩ mʋ á karɩ á beeri wʋlʋ na ŋwɩ tɩn twa wʋnɩ? ");
INSERT INTO xsm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O nan tǝri yo. O joori o bi. Guli-na kʋlʋ o dɛɛn na tagɩ dɩ abam maŋa kalʋ o ta na wʋ Galile nɩ tɩn, ");
INSERT INTO xsm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","yɩ o ta o wɩ, ba maŋɩ sɩ ba ja wʋm Nabiin-bu ba kɩ nɔn-balwaarʋ jɩŋa nɩ, sɩ ba pa-o tʋʋn-dagara baŋa nɩ ba gʋ, sɩ o laan joori o bi da yatɔ dɛ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nɔɔna bam na tagɩ kʋntʋ tɩn, kaana bam laan ma guli Zezi ya na tagɩ kʋlʋ dɩ ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ba ma zaŋɩ yibeeli dɩm jǝgǝ kam nɩ, ba joori ba vu ba ta dɩ Zezi karabiǝ fugǝ-dɩdʋa kam dɩ balʋ maama na tɔgɩ ba wʋra tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kaana bam kʋntʋ mʋ yɩ Mari wʋlʋ na nuŋi Magɩdala, dɩ Zannɩ, dɩ Mari wʋlʋ na yɩ Zakɩ nu tɩn, kʋ wǝli dɩ kaana balʋ na tɔgɩ dɩ ba tɩn. Bantʋ maama maa wʋra ba tɛ kʋlʋ na kɩ tɩn ba brɩ Zezi karabiǝ fugǝ-dɩdʋa kam. ");
INSERT INTO xsm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nɔɔna bam na ni tɩn, ba ma wʋ pɛ kaana bam taanɩ dɩm ja kuri, yɩ ba wʋ sɛ ba ni. ");
INSERT INTO xsm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kʋ daarɩ Pɩyɛɛrɩ ma zaŋɩ lɩla o duri o vu yibeeli dɩm jǝgǝ kam sɩ o nii. O na yi da tɩn, o ma tiiri o nii bɔɔnɩ dɩm wʋnɩ, yɩ o na garyiǝ yam yɩranɩ na tigi da. O ma joori o viiri, yɩ kʋ kɩ-o yǝǝu dɩ kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dɩntʋ dɛ dɩm nɩ mʋ Zezi karabiǝ bam bale wʋ cwǝŋǝ nɩ ba maa ve tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Emayusi. Tɩʋ kʋm kʋntʋ yɩ nɩnɛɛnɩ kilomɛtra fugǝ-dɩdʋa mʋ dɩ Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ba na maa ve tɩn, ba maa ŋɔɔna kʋlʋ maama na kɩ tɩn ba veǝ. ");
INSERT INTO xsm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba na ŋɔɔnɩ yɩ ba bwɛ daanɩ kʋntʋ tɩn, Zezi tɩtɩ ma tʋ ba wʋnɩ o tɔgɩ dɩ ba o veǝ. ");
INSERT INTO xsm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba na tɔgɩ daanɩ kʋntʋ tɩn, ba yiǝ ma pugimi yɩ ba wʋ lwar-o. ");
INSERT INTO xsm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zezi ma bwe-ba o wɩ: «Bɛɛ woŋo mʋ abam jɩgɩ á ŋɔɔnɩ á veǝ?» Ba na ni kʋntʋ tɩn, ba ma zɩgɩ yɩ ba yigǝ nywanɩ. ");
INSERT INTO xsm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ba dɩdʋa yɩrɩ mʋ Klɩʋpasɩ. O ma lǝri Zezi o wɩ: «Nɔɔna balʋ maama na zʋʋrɩ Zeruzalɛm nɩ tɩn maŋɩ ba lwarɩ wo-kamunnu tɩlʋ na kɩ da lele kʋntʋ tɩn. Bɛɛ nan mʋ kɩa, yɩ nmʋ yɩranɩ wʋ ni?» ");
INSERT INTO xsm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O ma bwe-ba o wɩ: «Bɛɛ wǝǝnu mʋ tɩntʋ?» Ba ma lǝri ba wɩ: «Kʋ yɩ kʋlʋ na kɩ Nazarɛtɩ tu Zezi tɩn mʋ. O yɩ Wɛ nijoŋnu mʋ, yɩ o kikiǝ dɩ o ni-taanɩ maama jɩgɩ dam. Wɛ tɩtɩ brɩ sɩ kʋ yɩ cɩga mʋ, yɩ nɔɔna maama dɩ na kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dɩbam kaanɩm yigǝ tiinǝ bam dɩ dɩ́ tɩʋ kʋm nakwa bam ma ja-o, ba vu ba pa ba di o taanɩ sɩ kʋ ji tʋʋnɩ. Ba laan ma pa pamaŋna bam ja Zezi ba vu ba pa tʋʋn-dagara yuu nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dɩbam nan ya jɩgɩ tɩɩna, sɩ wʋntʋ mʋ yɩ wʋlʋ na lagɩ o vrɩ Yisɩrayɛlɩ dwi tiinǝ bam o yagɩ tɩn. Dɩ kʋntʋ maama, zɩm mʋ jɩgɩ da yatɔ woŋo kʋntʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kʋlʋ na wǝli da tɩn, dɩbam kɔgɔ kʋm kaana badonnǝ ve o yibeeli dɩm jǝgǝ kam ba na kʋlʋ na sɔɔrɩ dɩbam yɩra. Ba ya ve tɩtɩɩtɩ mʋ, ");
INSERT INTO xsm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yɩ ba wʋ nɛ o yɩra yam da. Ba ma joori ba ba, ba ta dɩ dɩbam nɩ ba nɛ wo-kɩnkagɩlɩ mʋ. Ba ma na Wɛ malɛsɩ, yɩ sɩ ta dɩ ba sɩ wɩ, Zezi daa ta ŋwɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dɩbam nɔɔna bam badonnǝ dɩ ma zaŋɩ ba vu yibeeli dɩm nɩ. Ba ma na nɩ kʋ sɩɩnɩ kʋ yɩ nɩnɛɛnɩ kaana bam na tagɩ te tɩn mʋ, kʋ daarɩ Zezi tɩtɩ mʋ ba wʋ nɛ.» ");
INSERT INTO xsm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Zezi laan ma ta dɩ nɔɔna bam o wɩ: «Á ba jɩgɩ wʋbʋŋa na? Bɛɛ mʋ yɩ á warɩ á sɛ Wɛ kwǝrǝ kalʋ DƖ nijoŋnǝ bam dɛɛn na tɔɔlɩ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kʋ daɩ mʋ Krisi wʋm na maŋɩ sɩ o na yaara yalʋ sɩ o daarɩ o di Wɛ-sɔŋɔ o joŋi o paarɩ tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","O laan ma maŋɩ kʋlʋ maama na pʋpʋnɩ o ŋwaanɩ kʋ tiŋi Wɛ tɔnɔ kʋm wʋnɩ tɩn o brɩ-ba. O ma puli o pa ba lwarɩ Moyisi zaasɩm dɩm kuri, yɩ o daarɩ o brɩ-ba faŋa faŋa Wɛ nijoŋnǝ bam maama zaasɩm dɩm kuri na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ba na maa kɛ tɩn, ba ma vu ba twɛ tɩʋ kʋlʋ ba na maa ve tɩn. Zezi ma kɩ nɩ o maa kɛ yigǝ mʋ te. ");
INSERT INTO xsm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nɔɔna bam ma wʋ sɛ, yɩ ba loor-o ba wɩ: «Tɩga lagɩ ka yi. Nan zʋ n pǝni dɩbam tee nɩ.» O ma sɛ yɩ o da o zʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","O ma jǝni sɩ o di wʋdiu dɩ ba. O ma kwe dɩpɛ yɩ o kɩ Wɛ le dɩ ŋwaanɩ. O laan ma fɔ fɔ dɩpɛ dɩm o maŋɩ o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","O na kɩ kʋntʋ tɩn, mʋ ba yiǝ pʋʋrɩ yɩ ba laan lwar-o. Ba na lwar-o tɩn, o ma da o je ba yigǝ ni, yɩ ba daa wʋ nɛ-o. ");
INSERT INTO xsm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ba laan ma ta daanɩ ba wɩ: «Nmʋ wʋ nɛ na? Dɩ́ ya na tɔgɩ daanɩ cwǝŋǝ nɩ yɩ o ŋɔɔnɩ o brɩ dɩbam Wɛ tɔnɔ kʋm wǝǝnu tɩm kuri na yɩ te tɩn, dɩ́ ya ba tiini dɩ́ jɩgɩ wʋpolo na?» ");
INSERT INTO xsm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ba ma zaŋɩ lɩla ba joori ba vu Zeruzalɛm tɩʋ kʋm wʋ. Ba na yi da tɩn, ba ma na Zezi karabiǝ fugǝ-dɩdʋa kam dɩ nɔɔna badonnǝ bam na lagɩ daanɩ jǝgǝ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bantʋ ma tɛ ba wɩ: «Kʋ yɩ cɩga mʋ. Dɩ́ Yuutu Zezi sɩɩnɩ o bi o yagɩ tʋʋnɩ. O tu o brɩ o tɩtɩ dɩ Simɔn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nɔɔna bale bam dɩ ma maŋɩ kʋlʋ na kɩ cwǝŋǝ nɩ tɩn ba brɩ-ba. Ba daarɩ ba maŋɩ Zezi na fɔgɩ dɩpɛ dɩm yɩ ba laan lwar-o te tɩn. ");
INSERT INTO xsm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Zezi karabiǝ bam ta na wʋra ba ŋɔɔnɩ kʋntʋ tɩn, o ma da o ba o zɩgɩ ba tɩtarɩ nɩ. O ma jɔɔnɩ-ba yɩ o wɩ: «Yazurǝ wʋ́ jǝni dɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ba bɩcara ma di yɩ fʋʋnɩ ja-ba zanzan. Ba ma bʋŋɩ nɩ ba nɛ ciru mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","O ma ta dɩ ba o wɩ: «Bɛŋwaanɩ mʋ kʋ sʋ abam kʋntʋ? Bɛɛ mʋ yɩ á jɩgɩ bʋbwɛa dɩ amʋ? ");
INSERT INTO xsm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Fɔgɩ-na á nii amʋ jɩa dɩ a nɛ na yɩ te tɩn. Kʋ sɩɩnɩ kʋ yɩ amʋ. Taanɩ-na amʋ á nii. Ciru ba jɩgɩ ya-nwana dɩ kwi, nɩ á na naɩ amʋ na yɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","O na tagɩ kʋntʋ tɩn, o ma brɩ-ba o jataala dɩ o nɛ. ");
INSERT INTO xsm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kʋ na tiini kʋ jɩgɩ wʋpolo kʋ pa-ba tɩn, ba ta warɩ ba sɛ nɩ kʋ yɩ cɩga, yɩ kʋ sʋ-ba zanzan. O ma bwe-ba o wɩ: «Á jɩgɩ wʋdiu yo nɩ sɩ dɩ́ di na?» ");
INSERT INTO xsm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ba ma twǝri kalǝŋ-saŋa ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O ma joŋi-ka o di ba yibiyǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","O laan ma ta dɩ ba o wɩ: «Wǝǝnu tɩlʋ na kɩ amʋ tɩn maŋɩ dɩ taanɩ dɩlʋ a na maŋɩ a ta a brɩ abam, maŋa kalʋ a ta na wʋ abam wʋnɩ tɩn. A dɛɛn tagɩ a wɩ, kʋlʋ maama na pʋpʋnɩ amʋ ŋwaanɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn maŋɩ sɩ kʋ kɩ mʋ. Kʋ na yɩ kʋlʋ Moyisi dɩ faŋa faŋa Wɛ nijoŋnǝ bam na pʋpʋnɩ tɩn, dɩ kʋlʋ na pʋpʋnɩ Wɛ lǝŋ-ŋwɩ tɔnɔ kʋm wʋnɩ tɩn maama.» ");
INSERT INTO xsm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","O ma daarɩ o pa ba wʋ pʋʋrɩ, sɩ ba wanɩ ba lwarɩ Wɛ tɔnɔ kʋm na brɩ kʋlʋ tɩn kuri. ");
INSERT INTO xsm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O ma ta o brɩ-ba o wɩ: «Ba pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ ba wɩ: ‹Krisi wʋm lagɩ o na yaara zanzan mʋ sɩ o tɩ, yɩ o laan wʋ́ joori o bi o yagɩ tʋʋnɩ da yatɔ dɛ nɩ.› ");
INSERT INTO xsm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ba daa ta pʋpʋnɩ ba wɩ: ‹O karabiǝ wʋ́ vu lʋgʋ baŋa dwi tiinǝ maama te, yɩ wʋm yɩrɩ dɩm ŋwaanɩ baá brɩ nɔɔna nɩ ba maŋɩ sɩ ba lǝni ba wʋrʋ mʋ, sɩ Wɛ laan yagɩ ba lwarɩm DƖ ma cɛ-ba.› Á nan maŋɩ sɩ á puli Zeruzalɛm nɩ mʋ á taá tɔɔlɩ Wɛ kwǝrǝ kam kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Abam nɛ kʋlʋ maama na kɩ tɩn, á nan maŋɩ sɩ á brɩ nɔɔna kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A nan wʋ́ tʋŋɩ wʋlʋ wʋm a Ko na goni ni sɩ o ba abam te tɩn, yɩ o na tuǝ, oó pa abam na dam dɩlʋ na nuŋi Wɛ te tɩn. Maŋɩ-na Zeruzalɛm nɩ, sɩ á taá cǝgǝ dam dɩlʋ a na tɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Zezi laan ma ja-ba o nuŋi tɩʋ kʋm wʋnɩ, o ja vu o yi Betani seeni. O ma zǝŋi o jɩa wɛyuu nɩ, yɩ o ta dɩ ba o wɩ: «Amʋ pɛ abam yu-yoŋo.» ");
INSERT INTO xsm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","O na kɩ-ba yu-yoŋo kʋntʋ tɩn, o ma yagɩ-ba yɩ Wɛ kwe-o DƖ ja di DƖ sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ba ma kuni doonǝ ba zul-o, yɩ ba laan daarɩ ba joori Zeruzalɛm dɩ wʋpolo zanzan. ");
INSERT INTO xsm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ba na wʋra tɩn, ba wʋ fɔgɩ ba kwɛ Wɛ-di-kamunu kʋm vǝŋǝ, yɩ ba zuli Wɛ maŋa maama.");
INSERT INTO xsm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pulim nɩ tɩn, Bɩtara kam maŋɩ ka wʋra mʋ, yɩ lʋgʋ baŋa daa ta tǝrǝ. Ka maŋɩ ka wʋ Wɛ tee nɩ mʋ. Wʋlʋ na yɩ Bɩtara kam tɩn dɩ Wɛ maama yɩ bɩdwɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","O maŋɩ o wʋ Wɛ tee nɩ mʋ pulim nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kʋ dɛ dɩ wʋntʋ mʋ yɩ Baŋa-Wɛ dɛɛn kɩ woŋo maama. Kʋlʋkʋlʋ tǝrǝ Wɛ na kɩa, yɩ kʋ wʋ dɛ dɩ wʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wʋm mʋ paɩ nabiinǝ na ŋwɩa. Ŋwɩa kam kʋntʋ nan mʋ paɩ nabiinǝ na pooni. ");
INSERT INTO xsm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pooni dɩm kʋntʋ na tu tɩn, dɩ zǝli lim, yɩ lim daa warɩ pooni dɩm dɩ zǝli. ");
INSERT INTO xsm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wɛ dɛɛn tʋŋɩ nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Zan. ");
INSERT INTO xsm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O tu sɩ o ta wʋlʋ na yɩ pooni dɩm tɩn taanɩ mʋ o brɩ nɔɔna, sɩ nabiinǝ maama wanɩ ba lwar-o sɩ ba daarɩ ba sɛ-o. ");
INSERT INTO xsm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zan tɩtɩ daɩ pooni dɩm. O nan tu sɩ o ta wʋlʋ na yɩ pooni dɩm tɩn taanɩ mʋ o brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Wʋlʋ na yɩ pooni dɩm cɩga cɩga tɩn dɛɛn nuŋi Wɛ te mʋ o ba lʋgʋ baŋa. Wʋntʋ mʋ paɩ nabiinǝ maama na pooni sɩ ba wanɩ ba lwarɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","O dɛɛn ma ba lʋgʋ baŋa o wʋra. Kʋ ya dɛ dɩ wʋntʋ mʋ yɩ Wɛ kɩ lʋgʋ. Dɩ kʋntʋ dɩ, nabiinǝ daa ta wʋ lwar-o. ");
INSERT INTO xsm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O ma ba o tɩtɩ tɩʋ, yɩ o dwi tiinǝ wʋ jeer-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kʋ daarɩ balʋ maama na sɛ-o yɩ ba kɩ ba wʋ-dɩdʋa dɩd-o tɩn, o ma pa-ba ni sɩ ba ji Baŋa-Wɛ biǝ. ");
INSERT INTO xsm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba na jigi Wɛ biǝ kʋntʋ tɩn, kʋ daɩ nabiinǝ na lʋrɩ te tɩn, naa nɔɔna yɩra lagɩm, naa nɔɔna wʋbʋŋa na lagɩ te tɩn. Kʋ nan yɩ Baŋa-Wɛ tɩtɩ mʋ pɛ ba ji DƖ biǝ. ");
INSERT INTO xsm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Bɩtara kam dɛɛn ma ji nabiinu, yɩ o zʋʋrɩ dɩbam tɩtarɩ nɩ. Wɛ zaanɩ dɩ DƖ cɩga maama tiini ka wʋ o tee nɩ. Dɩ́ ma na o paarɩ-zulǝ na dagɩ te, o na yɩ o Ko Wɛ Bu-dʋa tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zan dɛɛn ŋɔɔnɩ wʋntʋ taanɩ, yɩ o ta dɩ kwǝr-dɩa o wɩ: «Mʋ wʋlʋ wʋm a na maŋɩ a ta o taanɩ a wɩ, nɔɔnʋ wʋdoŋ wʋ́ saŋɩ amʋ kwaga o ba. Wʋntʋ yɩ kamunu o dwe amʋ, bɛŋwaanɩ o maŋɩ o wʋra yɩ amʋ yaa ta tǝrǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wʋntʋ mʋ yǝni o pa dɩbam maama na zaanɩ zanzan, o na tiini o jɩgɩ Wɛ zaanɩ lanyɩranɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bɛŋwaanɩ Wɛ pɛ DƖ cullu tɩm Moyisi mʋ yɩ o pa dɩbam. Kʋ daarɩ, kʋ na yɩ Wɛ zaanɩ dɩ DƖ cɩga kam, DƖ dɛ DƖ Bu Zezi Krisi ŋwaanɩ mʋ DƖ pa dɩbam ka. ");
INSERT INTO xsm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nɔɔn-nɔɔnʋ ta maŋɩ o wʋ nɛ Baŋa-Wɛ. Kʋ daarɩ DƖ Bu-dʋa kam mʋ pɛ dɩ́ lwarɩ-DƖ. Wʋntʋ dɩ Wɛ yɩ bɩdwɩ mʋ. O maa wʋ o Ko Baŋa-Wɛ tɩkǝri nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zan dɛɛn na pɛ nɔɔna lwarɩ Zezi te tɩn mʋ tɩntʋ: Zwifǝ yigǝ tiinǝ balʋ na zʋʋrɩ Zeruzalɛm nɩ tɩn dɛɛn ma tʋŋɩ ba kaanɩm yigǝ tiinǝ dɩ Leviti tiinǝ sɩ ba vu Zan te. Ba ma vu ba bwe-o ba wɩ: «Nmʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zan ma vɩɩrɩ o ta-ba o wɩ: «Kʋ daɩ amʋ mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ba ta ma joori ba bwe-o ba wɩ: «Nmʋ nan yɩ wɔɔ mʋ za? Nmʋ yɩ Eli mʋ na?» O ma lǝri-ba o wɩ, wʋm daɩ Eli. Ba daa ma bwe-o ba wɩ: «Nmʋ yɩ Wɛ nijoŋnu wʋlʋ na maŋɩ sɩ o ba tɩn mʋ na?» O maa wɩ: «Awo.» ");
INSERT INTO xsm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ba laan ma ta ba wɩ: «Nmʋ nan yɩ wɔɔ? Dɩ́ maŋɩ sɩ dɩ́ ja nmʋ na lǝri te tɩn mʋ, dɩ́ vu dɩ́ ta dɩ́ brɩ balʋ na tʋŋɩ dɩbam tɩn. Ta n brɩ dɩbam nmʋ na yɩ wʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ba na bwe-o kʋntʋ tɩn, Zan ma lǝri-ba o wɩ: «Amʋ yɩ wʋlʋ na tɔɔlɩ kwǝrǝ kagʋa wʋnɩ a wɩ: ‹Zaŋɩ-na á kwɛ cwǝŋǝ kalʋ dɩ́ Yuutu wʋm na lagɩ o ba o tɔgɩ da tɩn, á pa ka fɔgɩ ka yɔɔrɩ lanyɩranɩ.› Mʋ Wɛ nijoŋnu Ezayi na maŋɩ o ta amʋ taanɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nɔɔna badonnǝ dɩ dɛɛn tɔgɩ ba wʋ ba wʋnɩ, ba na nuŋi Farizɩan tiinǝ kɔgɔ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ba ma bwe Zan ba wɩ: «Nmʋ nan na sɩɩnɩ n daɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, yɩ n daɩ Eli naa Wɛ nijoŋnu wʋlʋ na maŋɩ sɩ o ba tɩn, wɔɔ mʋ pɛ nmʋ ni sɩ n miisi nɔɔna na wʋnɩ?» ");
INSERT INTO xsm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zan ma lǝri-ba o wɩ: «Kʋ na yɩ amʋ, a yǝni a miisi nɔɔna na wʋnɩ mʋ. Abam nan na zɩgɩ tɩn, nɔɔnʋ wʋ á tɩtarɩ nɩ yɩ á yǝr-o. ");
INSERT INTO xsm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wʋntʋ mʋ lagɩ o saŋɩ amʋ kwaga o ba, yɩ a wʋ maŋɩ sɩ a lɩ o nɛ natra dɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kʋntʋ maama dɛɛn kɩ Betani nɩ mʋ, Zʋrdɛn bugǝ kam bubɛ dɩm nɩ, mɛ Zan na miisi nɔɔna na wʋnɩ Wɛ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tɩga na pʋʋrɩ tɩn, Zan ma na Zezi na ve o maa bɩɩnɩ o te. O ma ta dɩ balʋ na wʋra tɩn o wɩ: «Nii-na Wɛ Pǝlbu wʋlʋ na lɩ nabiinǝ lwarɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A ya tagɩ a wɩ: ‹Nɔɔnʋ wʋ́ saŋɩ amʋ kwaga o ba, yɩ o yɩ kamunu o dwe amʋ, bɛŋwaanɩ o maŋɩ o wʋra yɩ amʋ yaa ta tǝrǝ.› Kʋ nan yɩ wʋntʋ taanɩ mʋ a tɛa. ");
INSERT INTO xsm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Amʋ tɩtɩ dɛɛn maŋɩ a yǝri o na yɩ wʋlʋ tɩn, yɩ a laan ba a lwar-o. A nan tu sɩ a pa Yisɩrayɛlɩ dwi tiinǝ mʋ lwar-o. Kʋntʋ ŋwaanɩ mʋ a yǝni a miisi nɔɔna na wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Zan daa ta ma ŋɔɔnɩ Zezi taanɩ o brɩ-ba o wɩ: «A ya yǝri Wɛ Bu wʋm na yɩ wʋlʋ tɩn. Wʋlʋ nan na tʋŋɩ-nɩ sɩ a ba a miisi nɔɔna na wʋnɩ tɩn tagɩ o wɩ, a na nɛ Wɛ Joro kʋm tu kʋ wʋ nɔɔnʋ wʋlʋ baŋa nɩ tɩn, wʋntʋ mʋ yɩ wʋlʋ na wʋ́ miisi nɔɔna Wɛ Joro kʋm wʋnɩ tɩn. A laan nan nɛ Wɛ Joro kʋm na nuŋi wɛyuu nɩ kʋ tu kʋ ba kʋ wʋ nɔɔnʋ wʋntʋ baŋa nɩ, yɩ kʋ nyɩ dɩ kunkwǝŋǝ te. ");
INSERT INTO xsm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Amʋ sɩɩnɩ a na kʋlʋ Wɛ na tagɩ tɩn, yɩ a lagɩ a ta cɩga dɩ abam sɩ wʋntʋ mʋ yɩ Wɛ Bu wʋm.» ");
INSERT INTO xsm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tɩga na pʋʋrɩ tɩn, Zan dɩ o karabiǝ bale daa ta maa wʋra. ");
INSERT INTO xsm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Zan ma na Zezi na ve o maa kɛa. O ma ta o wɩ: «Nii-na Wɛ Pǝlbu wʋm.» ");
INSERT INTO xsm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zan karabiǝ bale bam ma ni o na tagɩ kʋlʋ tɩn. Ba ma pɛ Zezi kwaga ba pu. ");
INSERT INTO xsm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zezi ma pipiri o nii o na ba na tɔg-o tɩn. O ma bwe-ba o wɩ: «Abam beeri bɛɛ mʋ?» Ba ma lǝri ba wɩ: «Rabi, nmʋ zʋʋrɩ yǝn mʋ?» (Rabi kuri mʋ Karanyɩna.) ");
INSERT INTO xsm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O ma lǝri-ba o wɩ: «Ba-na sɩ á wʋ́ na.» Ba ma tɔgɩ dɩd-o ba vu ba na o na zʋʋrɩ mɛ tɩn. Kʋ yɩ dɩdaan-ni nɩ mʋ. Ba ma maŋɩ o tee nɩ ba tʋ wɛ. ");
INSERT INTO xsm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nɔɔna bale balʋ na ni Zan na tagɩ Zezi taanɩ dɩm te yɩ ba daarɩ ba tɔg-o tɩn dɩdʋa yɩrɩ mʋ Andre. O yɩ Simɔn Pɩyɛɛrɩ nyaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ba na joori tɩn, Andre ma kɩ lɩla o vu o zɩmbaarʋ Simɔn te, o ta dɩd-o o wɩ: «Dɩbam nɛ Mesi wʋm.» (Yɩrɩ dɩm kʋntʋ dɩ Krisi yɩ bɩdwɩ mʋ.) ");
INSERT INTO xsm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O laan ma ja-o o vu Zezi te. Zezi ma nii o yibiyǝ nɩ yɩ o wɩ: «Nmʋ yɩ Simɔn wʋlʋ na yɩ Zan bu tɩn mʋ. Nmʋ yɩrɩ laan wʋ́ ta yɩ Sɩfasɩ mʋ.» (Yɩrɩ dɩm kʋntʋ dɩ Pɩyɛɛrɩ yɩ bɩdwɩ mʋ, yɩ dɩ kuri mʋ Pulɔrɔ.) ");
INSERT INTO xsm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tɩga dɛɛn na pʋʋrɩ tɩn, Zezi ma bʋŋɩ sɩ o vu Galile. O ma vu o jeeri Filipi, yɩ o ta dɩd-o o wɩ: «Ba n ta n tɔgɩ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi nuŋi Betisayida mʋ, tɩʋ kʋlʋ Andre dɩ Pɩyɛɛrɩ dɩ na nuŋi da tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi laan ma zaŋɩ o vu o jeeri nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Natanayɛlɩ. O ma ta dɩd-o o wɩ: «Dɩbam nɛ wʋlʋ wʋm Moyisi na pʋpʋnɩ o taanɩ faŋa faŋa Wɛ cullu tɔnɔ kʋm wʋnɩ tɩn, yɩ Wɛ nijoŋnǝ dɩ dɛɛn pʋpʋnɩ ba ta o taanɩ tɩn. Wʋntʋ mʋ yɩ Zezi, o yɩ Zʋzɛfʋ bu mʋ. O nuŋi Nazarɛtɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayɛlɩ ma ta dɩd-o o wɩ: «Wo-laa kʋntʋ wʋ́ wanɩ kʋ nuŋi Nazarɛtɩ na?» Filipi ma lǝri o wɩ: «Ba sɩ n na.» ");
INSERT INTO xsm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ba na maa ve tɩn, Zezi ma na Natanayɛlɩ na maa bɩɩnɩ o te. O ma ta o taanɩ o wɩ: «Wʋntʋ sɩɩnɩ o yɩ Yisɩrayɛlɩ dwi tu mʋ cɩga cɩga, o wʋ lana.» ");
INSERT INTO xsm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayɛlɩ ma bwe-o o wɩ: «Nmʋ kɩ ta mʋ n ye amʋ?» O ma lǝr-o o wɩ: «A ya nɛ nmʋ maŋa kam n na wʋ kapʋrʋ kʋm kuri nɩ kʋ loori Filipi na bǝŋi nmʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayɛlɩ ma lǝr-o o wɩ: «Karanyɩna, nmʋ yɩ Baŋa-Wɛ Bu mʋ, yɩ n ta yɩ Yisɩrayɛlɩ tiinǝ pɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zezi ma ta dɩd-o o wɩ: «Nmʋ na sɛ amʋ tɩn, kʋ yɩ a na tagɩ a wɩ, a ya nɛ nmʋ kapʋrʋ kʋm kuri nɩ tɩn ŋwaanɩ mʋ. Nmʋ nan wʋ́ na wo-kɩnkagɩla yalʋ na tiini ya dana ya dwe kʋntʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","O laan ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam wʋ́ ba á na wɛyuu na pʋrɩ, yɩ Wɛ malɛsɩ tɔgɩ da sɩ diinǝ yɩ sɩ tuǝ Nabiin-bu wʋm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Da yale dɛɛn na kɛ tɩn, ba maa wʋra ba kɩ kadiri candiǝ Galile tɩʋ kʋdoŋ nɩ, kʋ yɩrɩ mʋ Kana. Zezi nu maa tɔgɩ o wʋra. ");
INSERT INTO xsm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ba dɛɛn bǝŋi Zezi dɩ o karabiǝ bam kadiri candiǝ kam kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ba na wʋra tɩn, tweeru biǝ sana kalʋ yɩrɩ na yɩ vɛn ba ya na jɩgɩ ba nyɔ tɩn ma ti. Zezi nu ma ta dɩd-o o wɩ: «Ba daa ba jɩgɩ sana sɩ ba nyɔ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Zezi ma lǝri o wɩ: «A nu, nmʋ lagɩ n brɩ-nɩ a na wʋ́ kɩ kʋlʋ tɩn na? A maŋa kam daa ta wʋ yi.» ");
INSERT INTO xsm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","O nu wʋm laan ma ta dɩ wʋdi-maŋna bam o wɩ: «O na tagɩ kʋlʋ maama dɩ abam, sɩ á kɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kandwa kambi-zɛ sɩrdʋ dɛɛn maa zɩgɩ da. Sɩ dɩdʋa maama jɩgɩ nɩnɛɛnɩ litra fusɩrdʋ naa bi mʋ. Sɩ dɛɛn zɩgɩ da sɩ nɔɔna ta maa sɩn ba jɩa dɩ ba zwɩ mʋ, nɩ Zwifǝ bam cullu tɩm na brɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Zezi ma ta dɩ wʋdi-maŋna bam sɩ ba mɔ na ba su kambi sɩm ni. Ba ma mɔ na ba su sɩ ni ba pɛɛlɩ. ");
INSERT INTO xsm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","O daa ma ta-ba o wɩ, ba laan mɔ na bam ba vu ba pa wʋlʋ na nii candiǝ kam wǝǝnu tɩm baŋa nɩ tɩn. Ba ma mɔ ba pa-o. ");
INSERT INTO xsm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","O ma nyɔ na bam, dɩdaanɩ ba maŋɩ ba ji tweeru biǝ sana. O ma wʋ lwarɩ sana kam kʋntʋ na nuŋi mɛ, yɩ wʋdi-maŋna balʋ na mɔɔnɩ na bam tɩn nan ye. Nɔɔnʋ wʋlʋ na nii candiǝ kam baŋa nɩ tɩn laan ma bǝŋi kan-barʋ wʋm o ta dɩd-o o wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Nɔɔnʋ maama yǝni o pa sa-ŋʋŋa mʋ yigǝ yɩ ba nyɔ. Ba laan na yǝni ba nyɔ ba su, o ma pa-ba sana kalʋ na ba tiini ka ywǝnǝ tɩn yɩ ba nyɔ. Nmʋ nan kwe sa-ŋʋŋa kam mʋ n zɩgɩ, yɩ n laan ba n kwe-ka n pa dɩbam kʋ kwaga nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mʋ Zezi na dɛ yigǝ o kɩ wo-kɩnkagɩlɩ dɩlʋ tɩn. O dɛɛn kɩ-dɩ Kana nɩ mʋ, Galile tɩʋ nɩ, sɩ kʋ brɩ nɔɔna nɩ o nuŋi Wɛ te mʋ. Kʋ ma pa nɔɔna lwarɩ o dam na yɩ te tɩn. O karabiǝ bam na nɛ kʋntʋ tɩn, ba ma kɩ ba wʋ-dɩdʋa dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kʋntʋ dɛɛn na kɛ tɩn, Zezi dɩ o nu dɩ Zezi nyaana dɩ o karabiǝ bam ma vu Kapɛrnawum ba kɩ da fɩnfɩɩn da. ");
INSERT INTO xsm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kʋ dɛɛn ma daarɩ fɩɩn sɩ Zwifǝ bam di ba candiǝ kalʋ yɩrɩ na yɩ Pakɩ tɩn. Zezi ma zaŋɩ o vu Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O na yi da tɩn, o ma vu Wɛ-di-kamunu kʋm nɩ. O ma na nɔɔna na jɩgɩ naanɩ dɩ peeni dɩ kunkwǝn-pulǝ ba yǝgǝ ka kʋnkɔlɔ kʋm nɩ. Sǝbu-lǝnnǝ dɩ maa je da ba lǝni ba sǝbiǝ. ");
INSERT INTO xsm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O ma kwe ŋʋnɩ o ma kɩ balaarɩ o zǝli peeni sɩm dɩ naanɩ dɩm maama, o pa dɩ nuŋi. O ma daarɩ o yigi sǝbu-lǝnnǝ bam taabʋllʋ tɩm o dɩ tɩga nɩ, o pa ba sǝbu kʋm jagɩ. ");
INSERT INTO xsm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O ma daarɩ o ta nɔɔna balʋ dɩ na jɩgɩ kunkwǝn-pulǝ bam ba yǝgi tɩn o wɩ: «Ja-na-ba á ja nuŋi yo. Á yɩ zaŋɩ á pa a Ko Wɛ digǝ kam taa yɩ pipiu jǝgǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zezi na kɩ kʋntʋ tɩn, o karabiǝ bam laan ma ba ba guli kʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ te: «Amʋ na tiini a jɩgɩ sono kʋlʋ nmʋ Wɛ-di-kamunu kʋm ŋwaanɩ tɩn nyɩ nɩnɛɛnɩ mini na di-nɩ te tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Zwifǝ yigǝ tiinǝ bam laan ma bwe Zezi ba wɩ: «Wo-kɩnkagɩlɩ dɔɔ nmʋ wʋ́ kɩ, sɩ kʋ pa dɩbam lwarɩ nɩ nmʋ jɩgɩ ni sɩ n zǝli nɔɔna bam kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Zezi ma lǝri-ba o wɩ: «Abam na magɩ Wɛ-digǝ kantʋ maama á dɩ tɩga nɩ, amʋ wʋ́ ma da yatɔ mʋ a joori a lɔ-ka a zɩgɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ba laan ma ta ba wɩ: «Ba mɛ bɩna fiinna yardʋ mʋ (46) ba ma lɔ Wɛ-di-kamunu kʋntʋ ba ti. Nmʋ nan wʋ́ kɩ ta mʋ n ma da yatɔ yɩranɩ n joori n lɔ-ka n zɩgɩ?» ");
INSERT INTO xsm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zezi nan ya na ŋɔɔnɩ Wɛ-digǝ kam taanɩ kʋntʋ tɩn, kʋ yɩ o tɩtɩ yɩra yam taanɩ mʋ o taga. ");
INSERT INTO xsm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kʋ dɛɛn na tu kʋ yi maŋa kam Zezi na tɩgɩ yɩ o joori o bi tɩn, o karabiǝ bam ma guli o dɛɛn na tagɩ te tɩn. Ba ma sɛ kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn, dɩ Zezi na tagɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zezi dɛɛn na wʋ Zeruzalɛm nɩ Pakɩ candiǝ kam maŋa nɩ tɩn, nɔɔna zanzan ma na wo-kɩnkagɩla yalʋ o na kɩ tɩn, yɩ ba laan sɛ-o. ");
INSERT INTO xsm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Zezi dɛɛn nan wʋ pɛ-ba o wʋ maama, bɛŋwaanɩ o ye nɔɔnʋ maama na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O maa ba lagɩ sɩ nɔɔn-nɔɔnʋ brɩ-o nabiinǝ na yɩ te tɩn, o na maŋɩ o ye kʋlʋ na wʋ nabiinu maama bɩcarɩ nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Nikodɛm. O nuŋi Farizɩan tiinǝ kɔgɔ kʋm wʋnɩ mʋ. O maa tɔgɩ o yɩ Zwifǝ bam yigǝ tu dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dɛ dɩdwɩ o ma zaŋɩ o vu Zezi te tɩtɩɩ nɩ, yɩ o ta dɩd-o o wɩ: «Karanyɩna, dɩ́ ye nɩ Wɛ mʋ tʋŋɩ nmʋ sɩ n ba n brɩ nɔɔna DƖ cɩga kam. Dɩ́ nɛ wo-kɩnkagɩla yalʋ nmʋ na kɩ tɩn. Kʋ pɛ dɩ́ lwarɩ nɩ Wɛ mʋ sɩɩnɩ DƖ wʋ nmʋ tee nɩ, DƖ paɩ n waɩ wo-kɩnkagɩla yam n kɩa.» ");
INSERT INTO xsm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Zezi ma lǝr-o o wɩ: «A lagɩ a ta cɩga dɩ nmʋ sɩ, ba na wʋ joori ba lʋ nɔɔnʋ wʋlʋ tɩn, kʋntʋ tu bá wanɩ o na Wɛ paarɩ dɩm na yɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛm ma bwe-o o wɩ: «Nɔɔnʋ na yɩ nɔn-kwɩʋn, baá kɩ ta mʋ ba lʋ-o daga? O bá wanɩ o joori o zʋ o nu wʋ sɩ ba daa lʋ-o.» ");
INSERT INTO xsm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Zezi ma lǝr-o o wɩ: «A lagɩ a ta cɩga dɩ nmʋ sɩ, nɔɔnʋ wʋlʋ Wɛ na wʋ mɛ na dɩ DƖ Joro kʋm DƖ pa o na lʋr-dʋŋa tɩn, kʋntʋ tu bá wanɩ o zʋ Wɛ paarɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nabiinǝ na lʋgɩ nɔɔnʋ wʋlʋ tɩn, kʋ yɩ lʋgʋ baŋa ŋwɩa mʋ o jɩga. Kʋ daarɩ, Wɛ Joro kʋm na lʋgɩ wʋlʋ tɩn, kʋ yɩ Wɛ Joro kʋm ŋwɩa mʋ o jɩga. ");
INSERT INTO xsm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yɩ pa kʋ sʋ-m dɩ a na tagɩ kʋlʋ nɩ kʋ maŋɩ sɩ ba joori ba lʋ abam tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kʋ na yɩ viu, kʋ yǝni kʋ dʋlɩ mɛ dɩ mɛ kʋ na lagɩ tɩn mʋ. N yǝni n ni kʋ sɔɔ kʋm, yɩ n yǝri kʋ na nuŋi mɛ dɩ kʋ na maa ve mɛ tɩn. Kʋ yɩ bɩdwɩ mʋ dɩ Wɛ Joro kʋm na pɛ wʋlʋ maama ŋwɩ-dʋŋa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛm ma bwe o wɩ: «Kʋʋ́ kɩ ta mʋ kʋ kɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zezi ma lǝr-o o wɩ: «Nmʋ yɩ Zwifǝ bam karanyɩna mʋ, yɩ n daa n ta yǝri wǝǝnu tɩntʋ? ");
INSERT INTO xsm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A lagɩ a ta cɩga dɩ nmʋ sɩ, dɩ́ yǝni dɩ́ tɛ wǝǝnu tɩlʋ dɩ́ na ye tɩn mʋ, yɩ dɩ́ kwǝri dɩ́ ŋɔɔnɩ kʋlʋ dɩ́ na nɛ tɩn dɩ́ brɩ nɔɔna. Dɩ kʋntʋ dɩ, á ta ba sɛ dɩbam taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A na tɛ lʋgʋ kʋntʋ baŋa wǝǝnu taanɩ a brɩ abam yɩ á ba sɛ a ni tɩn, a laan na ŋɔɔnɩ Wɛ-sɔŋɔ wǝǝnu a brɩ abam, á wʋ́ kɩ ta mʋ á sɛ a ni? ");
INSERT INTO xsm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nɔɔn-nɔɔnʋ tǝrǝ o na diini Wɛ-sɔŋɔ, kʋ na daɩ Nabiin-bu wʋm na zɩgɩ da o tu tɩn yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nɩ Moyisi dɛɛn na zǝŋi can-na bɩsankwɩa kam o palɩ daa yuu nɩ kagʋa kam wʋnɩ te tɩn, ba nan maŋɩ sɩ ba kwe Nabiin-bu wʋm dɩ ba zǝŋi wɛyuu nɩ kʋntʋ mʋ, ");
INSERT INTO xsm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sɩ kʋ pa nɔɔnʋ wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩd-o tɩn na ŋwɩ-dʋŋa kalʋ na ba ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bɛŋwaanɩ Wɛ na tiini DƖ soe nabiinǝ tɩn mʋ pɛ DƖ tʋŋɩ DƖ Bu-dʋa sɩ o ba lʋgʋ baŋa, sɩ wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩd-o tɩn daa yɩ cɔgɩ, sɩ o na ŋwɩ-dʋŋa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wɛ na tʋŋɩ DƖ Bu wʋm sɩ o ba lʋgʋ baŋa kʋntʋ tɩn, kʋ daɩ sɩ o di nabiinǝ taanɩ sɩ o cɔgɩ-ba, kʋ nan yɩ sɩ o vrɩ-ba lwarɩm wʋnɩ mʋ o yagɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩ Wɛ Bu wʋm tɩn, ba daa bá di o taanɩ. Kʋ daarɩ wʋlʋ maama na wʋ sɛ-o tɩn maŋɩ o ga bʋra mʋ, o na vɩn sɩ o sɛ Wɛ Bu-dʋa kam tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wɛ na di nabiinǝ taanɩ te tɩn mʋ tɩntʋ: Wɛ pɛ wʋlʋ na yɩ pooni tɩn mʋ ba lʋgʋ baŋa. Nabiinǝ nan soe lim ba dwe pooni dɩm ba tɩtʋŋ-balwaarʋ tɩm ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nɔɔnʋ wʋlʋ maama na kɩ kǝm-balwaarʋ tɩn culi pooni dɩm mʋ, o bá sɛ sɩ o nuŋi dɩ yigǝ nɩ, sɩ o wo-balwaarʋ tɩm wʋ́ jalɩ jaja. ");
INSERT INTO xsm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wʋlʋ maama nan na tɔgɩ cɩga cwǝŋǝ tɩn wʋ́ nuŋi pooni dɩm yigǝ mʋ, sɩ kʋ brɩ nɩ o tɩtʋŋa maama tɔgɩ Wɛ wʋbʋŋa mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kʋntʋ kwaga nɩ Zezi dɩ o karabiǝ bam ma vu ba beeri Zude tɩ-balwa bam wʋnɩ. Ba ma daanɩ jǝgǝ kam kʋntʋ nɩ, yɩ o miisi nɔɔna na wʋnɩ Wɛ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zan dɛɛn maa wʋ Ɛnɔn nɩ. Tɩʋ kʋm kʋntʋ batwarɩ dɩdaanɩ Salim. O dɩ maa wʋra o miisi nɔɔna na wʋnɩ, na na daga je sɩm kʋntʋ nɩ tɩn ŋwaanɩ. Nɔɔna zanzan dɛɛn yǝni ba tui o te maŋa maama, sɩ ba pa o miisi-ba na wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Maŋa kam kʋntʋ nɩ ba ta wʋ jaanɩ Zan ba pɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zan karabiǝ badonnǝ dɛɛn ma magɩ kantɔgɔ dɩ Zwifu wʋdoŋ, dɩ nɔɔna na maŋɩ sɩ ba zarɩ ba tɩtɩ te sɩ kʋ tɔgɩ Zwifǝ bam cullu tɩm cwǝŋǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ba ma vu Zan te ba ta dɩd-o ba wɩ: «Karanyɩna, dɩ́ nɛ nɔɔnʋ wʋlʋ dɛɛn na wʋ nmʋ tee nɩ yɩ n wʋ Zʋrdɛn bugǝ kam bubɛ dɩdoŋ dɩm nɩ tɩn. Nmʋ tagɩ o taanɩ n brɩ dɩbam. Lele kʋntʋ, o laan wʋra o miisi nɔɔna na wʋnɩ, yɩ nɔɔna zanzan tiini ba ve o te ba daarɩ dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zan ma lǝri-ba o wɩ: «Kʋ ba cɔga. Nɔɔnʋ bá wanɩ o na woŋo, yɩ kʋ na daɩ Wɛ mʋ pɛ-o-kʋ. ");
INSERT INTO xsm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Abam tɩtɩ maŋɩ á yɩ amʋ maana tiinǝ dɩ a na tagɩ a wɩ, amʋ daɩ Krisi wʋm, sɩ kʋ yɩ Wɛ mʋ tʋŋɩ-nɩ sɩ a tɔgɩ Krisi wʋm yigǝ a ba. ");
INSERT INTO xsm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kʋ nyɩ dɩ nɔɔnʋ na di kaanɩ te tɩn mʋ, kʋ yɩ kan-barʋ wʋm tɩtɩ mʋ te kaanɩ wʋm. Ka-yiginu wʋm maa zɩgɩ daa nɩ yɩ o cǝgǝ. O na nɛ nɩ kan-barʋ wʋm jɩgɩ wʋpolo dɩ o kaanɩ wʋm, o dɩ wʋ́ ta jɩgɩ wʋpolo. Kʋntʋ, a dɩ jɩgɩ wʋpolo kʋ ja gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wʋntʋ nan maŋɩ sɩ o ji nɔn-kamunu mʋ, sɩ amʋ joori a ji nɔn-balaŋa. ");
INSERT INTO xsm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nɔɔnʋ wʋlʋ na nuŋi Wɛ te tɩn mʋ yɩ nɔn-kamunu o dwe nɔɔnʋ maama. Kʋ daarɩ wʋlʋ na nuŋi lʋgʋ baŋa tɩn yɩ lʋgʋ nyɩm mʋ. O ni-taanɩ dɩ maa yɩ lʋgʋ baŋa nyɩm. Wʋlʋ nan na nuŋi Wɛ-sɔŋɔ tɩn mʋ dwe maama. ");
INSERT INTO xsm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O yǝni o tɛ kʋlʋ o na niǝ yɩ o kwǝri o na tɩn mʋ o brɩ nɔɔna. Dɩ kʋntʋ dɩ, nɔɔna ta ba sɛ o zaasɩm dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nɔɔnʋ wʋlʋ nan na sɛ o zaasɩm dɩm tɩn, kʋntʋ tu sɩɩnɩ o brɩ nɩ Wɛ yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bɛŋwaanɩ, kʋ na yɩ wʋlʋ wʋm Wɛ na tʋŋɩ tɩn, Wɛ pɛ-o DƖ Joro kʋm kʋ tiini kʋ ja gaalɩ, yɩ kʋ paɩ o tɛ Wɛ tɩtɩ ni-taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ko Baŋa-Wɛ soe DƖ Bu wʋm yɩ DƖ pa-o dam woŋo maama baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nɔɔnʋ wʋlʋ na kɩ o wʋ-dɩdʋa dɩ Wɛ Bu wʋm tɩn jɩgɩ ŋwɩ-dʋŋa kalʋ na ba ti tɩn. Kʋ daarɩ nɔɔnʋ wʋlʋ na vɩn Wɛ Bu wʋm tɩn bá fɔgɩ o na ŋwɩa Wɛ tee nɩ. Wɛ ban-zɔŋɔ nan wʋ́ ta wʋ o yuu nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Farizɩan tiinǝ bam dɛɛn ma ni nɩ Zezi wʋra o paɩ nɔɔna zanzan tɔgɩ o kwaga kʋ dwe Zan, yɩ o ta kwǝri o miisi-ba na wʋnɩ Wɛ ŋwaanɩ. Kʋ nan daɩ Zezi tɩtɩ mʋ miisi-ba na wʋnɩ, kʋ yɩ o karabiǝ bam mʋ miisi-ba. Zezi na maanɩ nɩ Farizɩan tiinǝ bam lwarɩ kʋntʋ tɩn, o ma zaŋɩ Zude nɩ o joori o maa ve Galile. ");
INSERT INTO xsm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","O na maa ve kʋntʋ tɩn, o maŋɩ sɩ o tɔgɩ Samari wʋnɩ mʋ o kɛ. ");
INSERT INTO xsm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O ma vu o yi Samari tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Siswaarɩ. Kʋ batwarɩ dɩ tɩga kalʋ Zakɔbɩ dɛɛn na pɛ o bu Zʋzɛfʋ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Zakɔbɩ dɛɛn jɩgɩ vʋlɩ je sɩm kʋntʋ nɩ, dɩ ta na wʋra dɩ zɩm maama. Zezi na ve taan kʋntʋ tɩn, o ma bwǝni. O ma vu o jǝni vʋlɩ dɩm ni nɩ. Kʋ dɛɛn yɩ wɩa tɩtarɩ nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","O karabiǝ bam maa kɛ tɩʋ kʋm wʋ sɩ ba yǝgi wʋdiu. Zezi na je da kʋntʋ tɩn, Samari tiinǝ kaanɩ wʋdoŋ laan ma ba sɩ o mɔ na. Zezi ma ta dɩd-o o wɩ, o kɩ na o pa-o sɩ o nyɔ. ");
INSERT INTO xsm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kaanɩ wʋm ma ta dɩ Zezi o wɩ: «Nmʋ yɩ Zwifu mʋ, yɩ amʋ yɩ Samari tu. Bɛɛ mʋ yɩ n ta n wɩ, a kɩ na a pa-m?» Kaanɩ wʋm tagɩ kʋntʋ, bɛŋwaanɩ Zwifǝ bam dɩ Samari tiinǝ dɛɛn warɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Zezi ma lǝr-o o wɩ: «Nmʋ ya na ye pɛɛrɩ dɩlʋ Wɛ na lagɩ DƖ pa-m tɩn, yɩ nmʋ ya na ye wʋlʋ na loori nmʋ na tɩn, nmʋ tɩtɩ ya mʋ wʋ́ loori amʋ, yɩ a pa nmʋ na balʋ na paɩ nabiinǝ ŋwɩ-dʋŋa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kaanɩ wʋm ma ta dɩd-o o wɩ: «A tu, nmʋ ba jɩgɩ goŋo yɩ vʋlɩ dɩm luunǝ. Nmʋ nan wʋ́ kɩ ta mʋ n mɔ na balʋ na paɩ nabiinǝ ŋwɩ-dʋŋa tɩn? ");
INSERT INTO xsm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dɩbam nabaarʋ Zakɔbɩ mʋ kʋgɩ vʋlɩ dɩntʋ o pa dɩbam. Wʋntʋ tɩtɩ dɩ o biǝ dɩ o vara maama dɛɛn mɔɔnɩ na yo mʋ faŋa faŋa ba nyɔa. Nmʋ nan bʋŋɩ n paɩ n dwe Zakɔbɩ mʋ naa?» ");
INSERT INTO xsm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","O ma lǝr-o o wɩ: «Kʋ na yɩ vʋlɩ dɩntʋ na bam, nɔɔnʋ wʋlʋ maama na nyɔgɩ-ba tɩn, na-nyɔm ta wʋ́ ja kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kʋ nan na yɩ na balʋ amʋ na wʋ́ pa tɩn, na-nyɔm daa bá ja wʋlʋ na nyɔgɩ-ba tɩn. Na balʋ a na wʋ́ pa tɩn wʋ́ ji nɩnɛɛnɩ buli-yi mʋ te o wʋnɩ, yɩ dɩ wʋ́ ta burǝ na balʋ na paɩ ŋwɩ-dʋŋa kalʋ na ba ti tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kaanɩ wʋm daa ma ta dɩd-o o wɩ: «A tu, nan pa-nɩ na bam kʋntʋ, sɩ na-nyɔm daa yɩ ja-nɩ sɩ a taa tui yo a mɔɔnɩ na.» ");
INSERT INTO xsm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Zezi ma ta dɩd-o o wɩ: «Ve n bǝŋi n barʋ sɩ á da daanɩ á ba.» ");
INSERT INTO xsm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kaanɩ wʋm ma lǝri o wɩ, wʋm ba jɩgɩ barʋ. Zezi ma ta-o o wɩ: «Nmʋ na tagɩ nɩ n ba jɩgɩ barʋ tɩn yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nmʋ ya n zʋ banna banu mʋ, yɩ nmʋ na wʋ nɔɔnʋ wʋlʋ tee nɩ lele kʋntʋ tɩn daɩ n barʋ. Kʋ yɩ cɩga mʋ n tagɩ n brɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kaanɩ wʋm ma ta dɩd-o o wɩ: «A tu, amʋ lwarɩ nɩ n yɩ Wɛ nijoŋnu mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dɩbam Samari tiinǝ nabaara bam dɛɛn tui piu kʋntʋ yuu mʋ ba zuli Wɛ. Kʋ daarɩ abam Zwifǝ bam brɩ nɩ, kʋ maŋɩ sɩ nɔɔna taa zuli Wɛ Zeruzalɛm nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zezi laan ma ta dɩd-o o wɩ: «Kaanɩ, sɛ a taanɩ dɩm. Maŋa wʋ́ ba, yɩ abam daa bá ta ve piu kʋntʋ yuu naa Zeruzalɛm sɩ á zuli dɩ́ Ko Wɛ da. ");
INSERT INTO xsm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Abam Samari tiinǝ yǝri wʋlʋ á na zuli tɩn. Dɩbam Zwifǝ bam nan ye wʋlʋ dɩ́ na zuli tɩn, bɛŋwaanɩ Wɛ tɔgɩ Zwifǝ bam jɩŋa mʋ DƖ vrɩ nabiinǝ ba lwarɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kʋ daarɩ maŋa maa bɩɩnɩ lele kʋntʋ, yɩ balʋ na sɩɩnɩ ba zuli dɩ́ Ko Wɛ cɩga tɩn, baá zuli-DƖ dɩ Wɛ Joro dam dɩ cɩga. Mʋ dɩ́ Ko Wɛ na lagɩ sɩ nabiinǝ taa zuli-DƖ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wɛ yɩ joro mʋ. Balʋ maama na lagɩ ba zuli-DƖ tɩn maŋɩ sɩ ba zuli-DƖ dɩ Wɛ Joro dam dɩ cɩga mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kaanɩ wʋm ma ta o wɩ: «Amʋ ye sɩ Mesi wʋlʋ ba na bǝ nɩ Krisi tɩn wʋ́ ba. O nan na tuǝ, oó ta Wɛ cɩga kam maama o brɩ dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zezi ma lǝr-o o wɩ: «Kʋ yɩ amʋ mʋ kʋntʋ, a zɩgɩ a ŋɔɔnɩ dɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Zezi karabiǝ bam laan ma joori ba ba. Ba na nɛ Zezi na zɩgɩ o ŋɔɔnɩ dɩ kaanɩ wʋm kʋntʋ tɩn, kʋ ma sʋ-ba. Dɩ kʋntʋ dɩ, ba wʋlʋwʋlʋ nan wʋ bwe o nii, «bɛɛ mʋ o laga?» naa, «bɛɛ mʋ yɩ Zezi ŋɔɔnɩ dɩ kaanɩ wʋm?» ");
INSERT INTO xsm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kaanɩ wʋm laan ma yagɩ o kɔɔrʋ wʋm, yɩ o daarɩ o vu tɩʋ kʋm wʋ. O na yi da tɩn, o ma ta dɩ nɔɔna bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ba-na á nii nɔɔnʋ, o na tagɩ amʋ na kɩ kʋlʋ maama tɩn o brɩ-nɩ. A yǝri wʋntʋ mʋ wʋ́ ta yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn naa?» ");
INSERT INTO xsm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","O na tagɩ o brɩ-ba kʋntʋ tɩn, ba ma nuŋi tɩʋ kʋm wʋnɩ ba maa ve Zezi te. ");
INSERT INTO xsm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kantʋ maŋa kam nɩ Zezi karabiǝ bam ma ta dɩd-o sɩ o di wʋdiu. ");
INSERT INTO xsm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","O ma lǝri-ba o wɩ: «A maŋɩ a jɩgɩ wʋdiu. Abam nan yǝri kʋ na yɩ wʋdiu kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","O karabiǝ bam laan ma bwe daanɩ ba wɩ: «Nɔɔnʋ mʋ nan ga jaanɩ wʋdiu o ba o pa-o naa?» ");
INSERT INTO xsm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zezi ma ta dɩ ba o wɩ: «Amʋ wʋdiu kʋm yɩ sɩ a tɔgɩ wʋlʋ wʋm na tʋŋɩ-nɩ tɩn wʋbʋŋa mʋ, sɩ a tʋŋɩ o tɩtʋŋa yam a ti. ");
INSERT INTO xsm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Abam yǝni á tɛ nɩ: ‹Kʋ daarɩ canɩ sɩna mʋ sɩ dɩ́ kɩ faa.› Amʋ nan lagɩ a ta abam sɩ á fɔgɩ á nii karɩ sɩm na yɩ te tɩn. Faa kʋm bɩga, kʋ laan daarɩ zagɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maŋa kam yiǝ, sɩ wʋlʋ na kɩ faa kʋm tɩn joŋi o ŋwɩɩrʋ. Faa kʋm nyɩ dɩ nɔɔna balʋ Wɛ na vrɩ DƖ pa ba na ŋwɩ-dʋŋa kalʋ na ba ti tɩn mʋ, sɩ nɔɔnʋ wʋlʋ na dugi tɩn dɩ wʋlʋ na zagɩ tɩn maama wǝli daanɩ ba na wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Taanɩ dɩntʋ yɩ cɩga mʋ: ‹Nɔɔnʋ mʋ dugǝ, yɩ wʋdoŋ zagɩ.› ");
INSERT INTO xsm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kʋntʋ tɩn, a tʋŋɩ abam sɩ á vu á beeri nɔɔna mʋ á pa Wɛ. Kʋ nyɩ nɩnɛɛnɩ abam wʋ vagɩ mɩna, yɩ á laan wʋ́ vu á zagɩ-ya. Nɔɔna badonnǝ mʋ vagɩ-ya, yɩ abam di nyɔɔrɩ ba tɩtʋŋa yam baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samari tiinǝ kaanɩ wʋm dɛɛn na tagɩ o brɩ o tɩʋ kʋm tiinǝ nɩ Zezi tagɩ wʋm na kɩ kʋlʋ maama o brɩ-o tɩn, kʋ ma pa Samari tiinǝ zanzan kɩ ba wʋ-dɩdʋa dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samari tiinǝ bam ma vu Zezi te, ba loor-o sɩ o maŋɩ ba tee nɩ. O ma kɩ da yale dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nɔɔna zanzan daa ta ma kɩ ba wʋ-dɩdʋa dɩd-o o ni-taanɩ dɩm ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ba ma ta dɩ kaanɩ wʋm ba wɩ: «Dɩbam laan kɩ dɩ́ wʋ-dɩdʋa dɩd-o, yɩ kʋ daa daɩ nmʋ na tagɩ kʋlʋ n brɩ dɩbam tɩn ŋwaanɩ. Dɩbam tɩtɩ ni o taanɩ dɩm, yɩ dɩ́ kwǝri dɩ́ lwarɩ nɩ wʋntʋ mʋ sɩɩnɩ o yɩ wʋlʋ na vrɩ nabiinǝ lwarɩm wʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Da yale yam dɛɛn na kɛ tɩn, Zezi ma zaŋɩ o maa ve o tɩtɩ tɩʋ Galile. ");
INSERT INTO xsm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Zezi tɩtɩ dɛɛn mʋ tagɩ o wɩ, ba ba nɩgɩ Wɛ nijoŋnu o tɩtɩ tɩʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Zezi nan na ve o yi Galile tɩn, nɔɔna ma jeer-o lanyɩranɩ, bɛŋwaanɩ ba ya na ve Zeruzalɛm sɩ ba di Pakɩ candiǝ kam tɩn, ba nɛ wo-kɩnkagɩla yalʋ maama o na kɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zezi laan ma joori o vu Kana, Galile tɩʋ nɩ. Kʋ yɩ jǝgǝ kalʋ o ya na pɛ na bam ji tweeru biǝ sana tɩn mʋ. Dɩdɛɛrʋ wʋdoŋ maa wʋ Kapɛrnawum nɩ, yɩ o bu ba jɩgɩ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","O na lwarɩ nɩ Zezi nuŋi Zude nɩ o ba Galile tɩn, o ma zaŋɩ o vu o te, o loor-o sɩ o vu Kapɛrnawum o pa o bu wʋm na yazurǝ, o na lagɩ o tɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zezi ma ta dɩd-o o wɩ: «Abam na wʋ nɛ wo-kɩnkagɩla yalʋ na brɩ nɩ Wɛ tʋŋɩ-nɩ tɩn, abam bá fɔgɩ á sɛ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dɩdɛɛrʋ wʋm daa ma ta o wɩ: «A tu, pa dɩ́ vu lɩla sɩ a bu wʋm wʋ́ zɩgɩ o tɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Zezi laan ma ta dɩd-o o wɩ: «Ve sɔŋɔ, sɩ n bu wʋm daa bá tɩ.» Nɔɔnʋ wʋm ma kɩ o wʋ-dɩdʋa dɩ Zezi na tagɩ te tɩn, yɩ o zaŋɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","O ta na wʋ cwǝŋǝ nɩ o maa ve sɔŋɔ tɩn, mʋ o tɩntʋŋna tu ba jeer-o, yɩ ba ta ba wɩ: «N bu wʋm nɛ yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O ma bwe-ba o wɩ: «Maŋa kɔɔ mʋ kʋ garɩ bu wʋm yɩra nɩ?» Ba ma ta ba wɩ: «Kʋ yɩ diin, wɩa tɩtarɩ nɩ mʋ, o paa kam yag-o.» ");
INSERT INTO xsm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ba na tagɩ kʋntʋ tɩn, nɔɔnʋ wʋm ma guli nɩ kʋ yɩ maŋa kam kʋntʋ nɩ nɔ́ɔ mʋ Zezi tagɩ o wɩ, o bu wʋm daa bá tɩ. O dɩ o sɔŋɔ tiinǝ maama laan ma kɩ ba wʋ-dɩdʋa dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mʋ Zezi na kɩ wo-kɩnkagɩlɩ dɩlʋ, o kɩ kuni bɩle Galile nɩ, o na nuŋi Zude o joori o ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kʋntʋ kwaga nɩ Zezi ma zaŋɩ o vu Zeruzalɛm, sɩ o tɔgɩ o di Zwifǝ bam candiǝ kadoŋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bugǝ kadoŋ mʋ wʋra, ka na batwarɩ dɩ tɩʋ kʋm ni dɩlʋ peeni na tɔgɩ da tɩn. Ka yɩrɩ dɩ Zwifǝ bam taanɩ mʋ yɩ Betizata. Ba dɛɛn te pwe sɩnu mʋ ka ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yawɩɩna zanzan dɛɛn yǝni ba tigi pwe sɩm kuri nɩ. Badaara yɩ lilwǝ dɩ gwanɩ dɩ kwaarʋ. Ba tigi da ba cǝgǝ, sɩ Wɛ malɛka mʋ ba ka pɔgɩlɩ na bam. ");
INSERT INTO xsm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ka na yǝni ka pɔgɩlɩ na bam kʋntʋ doŋ, yawɩɩnʋ wʋlʋ na wʋ́ loori yigǝ o tu na bam wʋnɩ tɩn wʋ́ na yazurǝ dɩ yawɩʋ kʋlʋ maama na jɩg-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nɔɔnʋ wʋdoŋ dɛɛn ma wʋra, o na ba jɩgɩ yazurǝ kʋ yi nɩ bɩna fiintɔ nana (38) te. ");
INSERT INTO xsm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zezi ma na o na tigi da tɩn, yɩ o lwarɩ nɩ o ya maŋɩ o ba jɩgɩ yazurǝ kʋ daanɩ. O ma ta dɩ nɔɔnʋ wʋm o wɩ: «Nmʋ lagɩ sɩ n na yazurǝ na?» ");
INSERT INTO xsm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yawɩɩnʋ wʋm ma lǝr-o o wɩ: «A tu, bugǝ kam na bam na yǝni ba pɔgɩlɩ, a ba jɩgɩ nɔɔnʋ wʋlʋ na wʋ́ kwe-nɩ o ja tu na bam wʋnɩ tɩn. A na yǝni a kwaanɩ sɩ a tu, nɔɔnʋ mʋ wʋ́ tu o loori amʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Zezi ma ta dɩd-o o wɩ: «Zaŋɩ wɛɛnɩ, sɩ n kwe n sara kam n ta n veǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","O na tagɩ kʋntʋ tɩn, nɔɔnʋ wʋm ma sɩɩnɩ o na yazurǝ bɩdwɩ baŋa nɩ, yɩ o zaŋɩ o kwe o sara kam o veǝ. Kʋ yɩ Zwifǝ bam siun dɛ nɩ mʋ kʋ kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kʋntʋ ŋwaanɩ Zwifǝ yigǝ tiinǝ bam ma ta dɩ nɔɔnʋ wʋm ba wɩ: «Zɩm yɩ dɩbam siun dɛ mʋ. Kʋntʋ ŋwaanɩ kʋ culǝ sɩ n ta n ze n sara kam.» ");
INSERT INTO xsm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O ma lǝri-ba o wɩ: «Nɔɔnʋ wʋlʋ na pɛ amʋ na yazurǝ tɩn mʋ tagɩ o wɩ, a kwe a sara kam a taa veǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba ma bwe-o ba wɩ: «Nɔɔnʋ wʋm kʋntʋ yɩ wɔɔ mʋ, yɩ o wɩ n kwe n sara kam n ta n veǝ?» ");
INSERT INTO xsm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","O maa daa yǝri wʋlʋ na pɛ o na yazurǝ yam tɩn, bɛŋwaanɩ Zezi zʋ nɔn-kɔgɔ kʋm wʋ yɩ o daa wʋ nɛ-o. ");
INSERT INTO xsm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kʋ na kɩ fɩɩn tɩn, Zezi ma vu o jeer-o Wɛ-di-kamunu kʋm wʋnɩ. O ma ta dɩd-o o wɩ: «Nii, nmʋ laan nɛ yazurǝ. Nan daa n yɩ kɩ lwarɩm, sɩ wo-lɔŋɔ kʋlʋ na dwe kʋntʋ tɩn daa yɩ kɩ-m.» ");
INSERT INTO xsm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nɔɔnʋ wʋm laan ma vu o ta dɩ Zwifǝ yigǝ tiinǝ bam o wɩ: «Kʋ yɩ Zezi ya mʋ pɛ a na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Zwifǝ yigǝ tiinǝ bam dɛɛn maa wʋra ba yaarɩ Zezi, dɩ o na pɛ yawɩɩnʋ wʋm na yazurǝ ba siun dɛ dɩm nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Zezi ma lǝri-ba o wɩ: «A Ko Wɛ yǝni DƖ kɩ kʋlʋ DƖ wʋbʋŋa na lagɩ tɩn mʋ maŋa maama. Amʋ dɩ nan kɩ kʋntʋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","O na tagɩ kʋntʋ tɩn ŋwaanɩ mʋ pɛ Zwifǝ yigǝ tiinǝ bam laan tiini ba bʋŋɩ o gʋm. Kʋ nan daɩ nɩ ba na wɩ o cɔgɩ ba siun dɛ cullu tɩm tɩn má ŋwaanɩ, kʋ yɩ o na tagɩ o wɩ Wɛ yɩ o tɩtɩ Ko tɩn mʋ. O taanɩ dɩm kʋntʋ brɩ nɩ o dɩ Wɛ yɩ bɩdwɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Zezi ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, amʋ na yɩ Wɛ Bu wʋm tɩn, a bá wanɩ a kɩ kʋlʋkʋlʋ a tɩtɩ nɩ, kʋ na daɩ kʋlʋ a na nɛ a Ko Wɛ na kɩ tɩn. A Ko na kɩ kʋlʋ tɩn mʋ amʋ dɩ wʋ́ kɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bɛŋwaanɩ Baŋa-Wɛ soe DƖ Bu wʋm yɩ DƖ maa brɩ-o kʋlʋ maama DƖ tɩtɩ na kɩ tɩn. DƖ nan wʋ́ brɩ-o wo-kamunnu tɩlʋ na dwe tɩntʋ tɩn sɩ o kɩ, yɩ kʋʋ́ sʋ abam. ");
INSERT INTO xsm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kʋntʋ, Baŋa-Wɛ na bi nɔɔna DƖ pa ba yagɩ tʋʋnɩ yɩ DƖ pa-ba ŋwɩ-dʋŋa te tɩn, DƖ Bu wʋm dɩ wʋ́ pa balʋ o na lagɩ tɩn na ŋwɩ-dʋŋa. ");
INSERT INTO xsm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kʋlʋ na wǝli da tɩn, Baŋa-Wɛ tɩtɩ bá di nɔɔn-nɔɔnʋ taanɩ. DƖ nan pɛ DƖ Bu wʋm ni sɩ o di nabiinǝ maama taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kʋntʋ wʋ́ pa nɔɔna maama zuli Wɛ Bu wʋm, nɩ ba na zuli o Ko Wɛ te tɩn. Wʋlʋ maama na ba zuli Wɛ Bu wʋm tɩn, o ba zuli o Ko Wɛ dɩlʋ na tʋŋ-o tɩn dɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Zezi daa ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, wʋlʋ maama na ni a taanɩ dɩm yɩ o daarɩ o kɩ o wʋ-dɩdʋa dɩ wʋlʋ na tʋŋɩ-nɩ tɩn, kʋntʋ tu jɩgɩ ŋwɩ-dʋŋa kalʋ na ba ti tɩn. Ba daa bá di o taanɩ. Kʋntʋ tu nuŋi tʋʋnɩ wʋnɩ mʋ, o zʋ ŋwɩa kalʋ na ba ti tɩn wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A lagɩ a ta cɩga dɩ abam sɩ, maŋa maa bɩɩna lele kʋntʋ, yɩ balʋ na ba jɩgɩ ŋwɩa Wɛ tee nɩ tɩn wʋ́ ni amʋ Wɛ Bu wʋm kwǝrǝ. Balʋ na sɛ-ka tɩn wʋ́ na Wɛ ŋwɩ-dʋŋa kam. ");
INSERT INTO xsm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kʋntʋ, Wɛ na yɩ ŋwɩa tu tɩn, mʋ DƖ pɛ wʋlʋ na yɩ DƖ Bu wʋm tɩn dɩ ji ŋwɩa tu. ");
INSERT INTO xsm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","DƖ ma kwǝri DƖ pa-o ni sɩ o di nabiinǝ taanɩ, o na yɩ Nabiin-bu wʋm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yɩ pa-na kʋ sʋ abam dɩ a na tagɩ woŋo kʋlʋ tɩn. Maŋa maa bɩɩna, yɩ balʋ maama na tɩgɩ tɩn wʋ́ ni amʋ kwǝrǝ, ");
INSERT INTO xsm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","yɩ ba nuŋi ba yibeelǝ wʋnɩ. Balʋ maama na kɩ lanyɩranɩ tɩn wʋ́ bi ba taa ŋwɩ Wɛ tee nɩ. Kʋ daarɩ balʋ maama na kɩ wo-balwaarʋ tɩn wʋ́ bi, yɩ ba di ba taanɩ, yɩ ba na cam. ");
INSERT INTO xsm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","A bá wanɩ a kɩ kʋlʋkʋlʋ amʋ tɩtɩ nɩ. Amʋ tɔgɩ a Ko ni mʋ a maa di nabiinǝ taanɩ. Kʋntʋ ŋwaanɩ amʋ sarɩya dim dɩm yɔɔrɩ dɩ yɩ cɩga mʋ, bɛŋwaanɩ amʋ ba kwaanɩ sɩ a kɩ kʋlʋ amʋ tɩtɩ na lagɩ tɩn, kʋ yɩ Wɛ na tʋŋɩ-nɩ sɩ a kɩ kʋlʋ DƖ na lagɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Zezi ta ma ta dɩ Zwifǝ yigǝ tiinǝ bam o wɩ: «A tɩtɩ yɩranɩ mʋ ya na brɩ a cɩga kam, kʋ daɩ fɩfɩʋn sɩ á sɛ nɩ a taanɩ dɩm yɩ cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nɔɔnʋ wʋdoŋ nan mʋ zɩgɩ amʋ cɩga kam kwaga nɩ, kʋ yɩ amʋ Ko Wɛ mʋ, yɩ a ye nɩ wʋntʋ jɩgɩ cɩga dɩ o na tɛ amʋ taanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Abam ya tʋŋɩ nɔɔna Zan tee nɩ yɩ o ta amʋ cɩga o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kʋ na yɩ amʋ, a ya ba lagɩ sɩ nɔɔn-nɔɔnʋ pa amʋ cɩga kam maana. A nan tagɩ Zan taanɩ abam ŋwaanɩ mʋ, sɩ kʋ wanɩ kʋ wǝli abam sɩ á na vrɩm lwarɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zan dɛɛn nyɩ dɩ kanɩa mini na tiini dɩ jɩgɩ pooni te tɩn mʋ. Abam ma sɛ sɩ á tɔgɩ o taanɩ dɩm dɩ wʋpolo maŋa fɩnfɩɩn yɩranɩ, yɩ á laan kwe á yagɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","A nan jɩgɩ maana yalʋ na daga ya dwe Zan na pɛ yalʋ tɩn. Tɩtʋŋa yam a Ko Wɛ na pɛ-nɩ sɩ a tʋŋɩ tɩn, yantʋ mʋ a jɩgɩ a tʋŋa, yɩ yantʋ mʋ pa-nɩ cɩga nɩ Wɛ mʋ sɩɩnɩ DƖ tʋŋɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Ko Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn zɩgɩ a cɩga kam kwaga nɩ. Abam nan maŋɩ á wʋ cǝgi DƖ kwǝrǝ, naa á na DƖ na nyɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Abam wʋ joŋi DƖ taanɩ dɩm á kɩ á wʋ nɩ. Á na wʋ sɛ wʋlʋ wʋm DƖ na tʋŋɩ tɩn mʋ brɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Abam yǝni á kwaanɩ á zaasɩ Wɛ twaanʋ tɩm, bɛŋwaanɩ á bʋŋɩ nɩ tɩntʋ ŋwaanɩ mʋ á wʋ́ na ŋwɩa kalʋ na ba ti tɩn. Kʋ nan yɩ amʋ taanɩ mʋ twaanʋ tɩm kʋntʋ tɛa. ");
INSERT INTO xsm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Abam nan ta ba sɛ sɩ á ba amʋ te, sɩ kʋ pa á na ŋwɩ-dʋŋa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","A nan ba bʋŋɩ sɩ nabiinǝ ta pa amʋ zulǝ. ");
INSERT INTO xsm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kʋ na yɩ abam, amʋ ye á wʋrʋ. A ye nɩ Wɛ sono tǝri á bɩcara nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Amʋ nan jaanɩ a Ko yɩrɩ mʋ a ba, yɩ abam vɩn sɩ á jeeri-nɩ. Nɔɔnʋ wʋlʋ nan na jaanɩ o tɩtɩ yɩrɩ o ba, á wʋ́ jeeri kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Abam nan lagɩ sɩ á taá joŋi zulǝ mʋ da-tee nɩ, yɩ á ba lagɩ sɩ á kɩ kʋlʋ na wʋ́ pa á na zulǝ Wɛ dɩlʋ na ba jɩgɩ doŋ tɩn tee nɩ. Kʋntʋ mʋ á warɩ á kɩ á wʋ-dɩdʋa dɩ amʋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Á yɩ taá bʋŋɩ nɩ, amʋ mʋ wʋ́ vɩn abam bʋra a Ko Wɛ tee nɩ. Kʋ yɩ Moyisi wʋm abam ya na bʋŋɩ sɩ á wʋ́ na ŋwɩa Wɛ tee nɩ o ŋwaanɩ tɩn mʋ wʋ́ vɩn abam bʋra. ");
INSERT INTO xsm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Abam ya na sɩɩnɩ á sɛ Moyisi na tagɩ kʋlʋ tɩn, á ya wʋ́ sɛ amʋ dɩ, bɛŋwaanɩ wʋntʋ pʋpʋnɩ amʋ taanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Abam nan maŋɩ á wʋ sɛ o na pʋpʋnɩ kʋlʋ tɩn. Kʋntʋ tɩn, á nan wʋ́ kɩ ta mʋ á sɛ amʋ na tagɩ kʋlʋ tɩn?» ");
INSERT INTO xsm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Dɛ dɩdwɩ Zezi dɩ o karabiǝ bam ma zaŋɩ ba vu ba bɛ Galile nɩnɩʋ kʋm bubɛ dɩdoŋ dɩm. Nɔɔna badaara bǝ-ka nɩ Tiberiyadɩ nɩnɩʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nɔn-kɔgɔ zanzan maa tɔgɩ o kwaga, bɛŋwaanɩ ba nɛ wo-kɩnkagɩla yalʋ o na kɩ o pa yawɩɩna na yazurǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Kʋ dɛɛn twɛ sɩ Zwifǝ bam di ba candiǝ kalʋ yɩrɩ na yɩ Pakɩ tɩn. Zezi ma vu o di piu yuu o jǝni da dɩ o karabiǝ bam. ");
INSERT INTO xsm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","O ma kwǝni o yuu o nii, yɩ o na nɩ kɔgɔ zanzan mʋ maa bɩɩnɩ o te. O ma ta dɩ Filipi o wɩ: «Dɩ́ wʋ́ kɩ ta mʋ dɩ́ na wʋdiu, sɩ dɩ́ yǝgi dɩ́ pa nɔɔna bantʋ maama sɩ ba di?» ");
INSERT INTO xsm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","O na tagɩ kʋntʋ tɩn, kʋ yɩ sɩ o ma nii Filipi wʋbʋŋa na yɩ te tɩn mʋ, sɩ o maŋɩ o ye o na wʋ́ kɩ te. ");
INSERT INTO xsm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi ma lǝr-o o wɩ: «Dɩ́ na lagɩ dɩ́ yǝgi dɩpɛ sɩ nɔɔnʋ maama na fɩnfɩɩn o di, kʋ sǝbu kʋm wʋ́ dwǝni sǝbu-dala biǝ-yale (200).» ");
INSERT INTO xsm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","O karabiǝ bam dɩdʋa, Andre wʋlʋ na yɩ Simɔn Pɩyɛɛrɩ nyaanɩ tɩn, ma ta o wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Nii, bu wʋdoŋ mʋ wʋ yo seeni, o jɩgɩ dɩpwa yanu dɩ kalǝŋ-balɛ sɩle. Kʋ nan bá wanɩ kʋ yi nɔɔna bantʋ maama dim.» ");
INSERT INTO xsm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zezi laan ma ta dɩ ba o wɩ: «Á nan pa nɔɔna bam jǝni tɩga nɩ.» Gaarʋ tiini tɩ wʋra jǝgǝ kam kʋntʋ nɩ. Nɔɔna bam maama ma jǝni tɩga nɩ. Ba yi nɩnɛɛnɩ baara mʋrr-tɩnu (5.000), kʋ wǝli dɩ kaana dɩ biǝ. ");
INSERT INTO xsm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Zezi ma kwe dɩpwa yam yɩ o kɩ Wɛ le ya ŋwaanɩ. O ma daarɩ o maŋɩ-ya o pa nɔɔna bam na je tɩga nɩ tɩn. O ma kɩ Wɛ le kale sɩm dɩ ŋwaanɩ yɩ o pa-ba. Nɔɔna bam maama ma di nɩ ba na lagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ba ma di ba su ba daarɩ. Zezi ma ta dɩ o karabiǝ bam o wɩ: «Ve-na á twɛ cicwǝǝru tɩlʋ na daarɩ tɩn, sɩ á yɩ yagɩ sɩ tɩ cɔgɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ba ma twɛ tɩ maama ba su tɩtwarʋ fugǝ-tɩle. Dɩpwa yanu yam ba na di ba daarɩ tɩn cicwǝǝru yɩranɩ mʋ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nɔɔna bam na nɛ wo-kɩnkagɩlɩ dɩm Zezi na kɩ tɩn, ba ma ta ba wɩ: «Kʋ sɩɩnɩ kʋ yɩ cɩga mʋ, Wɛ nijoŋnu wʋlʋ ya na maŋɩ sɩ o ba lʋgʋ baŋa tɩn mʋ tɩntʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zezi laan ma lwarɩ nɩ ba lagɩ ba pa o ji ba pɛ dɩ dam mʋ. O na lwarɩ kʋntʋ tɩn, o ma zaŋɩ o joori o vu o di piu yuu o wʋra o yɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dɩdaanɩ na yi tɩn, Zezi karabiǝ bam ma vu ba yi nɩnɩʋ kʋm ni. ");
INSERT INTO xsm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ba ma zʋ naboro ba tɔgɩ nɩnɩʋ kʋm wʋ ba maa ve Kapɛrnawum. Tɩga maa tiini ka yi, yɩ Zezi daa ta wʋ tu ba te. ");
INSERT INTO xsm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Vu-dɩʋ laan ma zaŋɩ kʋ fufugǝ kʋ pa na bam pɔgɩla. ");
INSERT INTO xsm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Zezi karabiǝ bam ma co naboro kʋm ba vu ba yi nɩnɛɛnɩ kilomɛtra yanu naa yardʋ te. Ba laan ma na Zezi na ve na bam baŋa nɩ o maa bɩɩnɩ ba te. Fʋʋnɩ ma zʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Zezi ma ta dɩ ba o wɩ: «Á yɩ taá kwarɩ fʋʋnɩ, sɩ kʋ yɩ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ba ma bʋŋɩ sɩ ba pa Zezi zʋ naboro kʋm, dɩ ba dɛ ba yi buburu ni, jǝgǝ kalʋ ba ya na maa ve tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tɩga na pʋʋrɩ tɩn, nɔn-kɔgɔ kʋlʋ na maŋɩ nɩnɩʋ kʋm bubɛ dɩdoŋ dɩm nɩ tɩn ma maanɩ nɩ, naboro dɩdʋa yɩranɩ ya mʋ wʋra. Ba maa ye nɩ Zezi karabiǝ bam kɛ ba daar-o, yɩ o wʋ dɛ o zʋ ba naboro kʋm o vu. ");
INSERT INTO xsm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nabwǝǝru tɩdonnǝ ma nuŋi Tiberiyadɩ tɩ ba, tɩ yi bubɛ dɩlʋ nɔn-kɔgɔ kʋm na wʋra tɩn. Kʋ yɩ jǝgǝ kam kʋntʋ nɩ mʋ dɩ́ Yuutu Zezi ya kɩ Wɛ le wʋdiiru tɩm ŋwaanɩ, yɩ o daarɩ o pa nɔɔna bam di tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nɔɔna bam na lwarɩ nɩ Zezi dɩ o karabiǝ bam daa tǝrǝ tɩn, ba ma zʋ nabwǝǝru tɩm wʋ ba maa ve Kapɛrnawum sɩ ba beer-o. ");
INSERT INTO xsm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nɔɔna bam na bɛ nɩnɩʋ kʋm tɩn, ba ma na Zezi. Ba ma bwe-o ba wɩ: «Karanyɩna, maŋa kɔɔ mʋ n tu yoba?» ");
INSERT INTO xsm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zezi ma lǝri-ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam na karɩ á beeri amʋ tɩn, kʋ daɩ á na nɛ wo-kɩnkagɩla yalʋ na brɩ nɩ Wɛ tʋŋɩ-nɩ tɩn ŋwaanɩ. Kʋ yɩ á na di wʋdiiru tɩm á su tɩn ŋwaanɩ mʋ á beeri amʋ. ");
INSERT INTO xsm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Á nan yɩ taá tʋŋɩ-na wʋdiu kʋlʋ na wʋ́ ba kʋ cɔgɩ tɩn má ŋwaanɩ. Á taá tʋŋɩ wʋdiu kʋlʋ na wʋ́ pa á na ŋwɩ-dʋŋa kalʋ na ba ti tɩn ŋwaanɩ. Amʋ Nabiin-bu wʋm mʋ wʋ́ pa abam kʋntʋ wʋdiu kʋm, bɛŋwaanɩ a Ko Wɛ mʋ pɛ-nɩ ni sɩ a taa tʋŋa a pa-DƖ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba laan ma bwe-o ba wɩ: «Dɩbam nan wʋ́ kɩ ta mʋ, sɩ dɩ́ taá tʋŋɩ tɩtʋŋa yalʋ Wɛ na lagɩ tɩn?» ");
INSERT INTO xsm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","O ma lǝri-ba o wɩ: «Tɩtʋŋɩ dɩlʋ Wɛ na lagɩ sɩ abam tʋŋɩ tɩn, kʋ yɩ sɩ á sɛ wʋlʋ DƖ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ba ma ta bwe-o ba wɩ: «Wo-kɩnkagɩlɩ dɔɔ mʋ nmʋ wʋ́ kɩ, sɩ dɩ́ wanɩ dɩ́ lwarɩ nɩ Wɛ mʋ sɩɩnɩ DƖ tʋŋɩ nmʋ, sɩ dɩ́ laan sɛ-m? Nmʋ wʋ́ kɩ bɛɛ mʋ n brɩ dɩbam? ");
INSERT INTO xsm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Faŋa faŋa tɩn, dɩbam nabaara dɛɛn na wʋ kagʋa wʋnɩ maŋa kalʋ nɩ tɩn, ba di wʋdiu kʋlʋ yɩrɩ na yɩ ‹Maanɩ› tɩn mʋ, nɩ Wɛ tɔnɔ kʋm na tagɩ te kʋ wɩ: ‹O pɛ-ba wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ nɩ tɩn yɩ ba di.› » ");
INSERT INTO xsm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zezi ma lǝri-ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, kʋ daɩ Moyisi mʋ pɛ abam wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ nɩ tɩn. Kʋ nan yɩ a Ko Wɛ mʋ paɩ abam wʋdiu kʋlʋ na nuŋi DƖ sɔŋɔ nɩ yɩ kʋ yɩ wʋdiu cɩga cɩga tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bɛŋwaanɩ wʋdiu kʋlʋ Wɛ na paɩ tɩn mʋ yɩ wʋlʋ na nuŋi DƖ sɔŋɔ nɩ o tu o ba lʋgʋ baŋa o paɩ nabiinǝ ŋwɩ-dʋŋa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ba ma ta dɩd-o ba wɩ: «Dɩbam tu, ta n paɩ dɩbam wʋdiu kʋm kʋntʋ maŋa maama.» ");
INSERT INTO xsm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Zezi ma ta dɩ ba o wɩ: «Amʋ yɩ wʋdiu kʋlʋ na paɩ nabiinǝ ŋwɩ-dʋŋa tɩn. Wʋlʋ maama na tu amʋ te tɩn, kana daa bá ja kʋntʋ tu. Wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn, na-nyɔm daa bá ja kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","A nan maŋɩ a ta a brɩ abam nɩ, á nɛ amʋ yɩ á ta ba sɛ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kʋ daarɩ wʋlʋ maama a Ko Wɛ na pɛ amʋ tɩn wʋ́ ba amʋ te. Wʋlʋ maama nan na tu amʋ te tɩn, a bá fɔgɩ a vɩn kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bɛŋwaanɩ amʋ nuŋi Wɛ-sɔŋɔ a ba sɩ a kɩ wʋlʋ na tʋŋɩ-nɩ tɩn wʋbʋŋa mʋ, sɩ kʋ daɩ a tɩtɩ wʋbʋŋa. ");
INSERT INTO xsm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wʋlʋ na tʋŋɩ-nɩ tɩn wʋbʋŋa na lagɩ kʋlʋ tɩn mʋ yɩ sɩ a yɩ yagɩ a pa balʋ maama DƖ na pɛ-nɩ tɩn wʋlʋwʋlʋ je, sɩ a daarɩ a pa ba maama joori ba bi lʋgʋ tiim dɛ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A Ko Wɛ wʋbʋŋa mʋ yɩ sɩ, wʋlʋ maama na lwarɩ DƖ Bu wʋm yɩ o kɩ o wʋ-dɩdʋa dɩd-o tɩn, sɩ kʋntʋ tu na ŋwɩ-dʋŋa kalʋ na ba ti tɩn. Aá pa kʋntʋ tu joori o bi lʋgʋ tiim dɛ dɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zezi na tagɩ kʋntʋ tɩn, Zwifǝ bam maa pʋʋna dɩ o na tagɩ o wɩ, wʋm mʋ yɩ wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba maa tɛ ba wɩ: «Wʋntʋ mʋ daɩ Zʋzɛfʋ bu Zezi wʋm na? Dɩ́ ye o nu dɩ o ko. Bɛɛ mʋ yɩ o laan nan ta wɩ, o nuŋi Wɛ-sɔŋɔ nɩ mʋ o ba?» ");
INSERT INTO xsm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Zezi ma lǝri-ba o wɩ: «Yagɩ-na, á yɩ taá pʋʋna. ");
INSERT INTO xsm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nɔɔn-nɔɔnʋ bá wanɩ o ba amʋ te, kʋ na daɩ a Ko Wɛ dɩlʋ na tʋŋɩ-nɩ tɩn mʋ vaŋɩ kʋntʋ tu jɩŋa sɩ o ba amʋ te. Amʋ wʋ́ pa kʋntʋ tu joori o bi lʋgʋ tiim dɛ dɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kʋ pʋpʋnɩ faŋa faŋa Wɛ nijoŋnǝ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Ba maama wʋ́ zaasɩ Wɛ tee nɩ.› Wʋlʋ maama nan na cǝgi a Ko Wɛ taanɩ dɩm yɩ o sɛ DƖ zaasɩm dɩm tɩn wʋ́ ba amʋ te. ");
INSERT INTO xsm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kʋ nan daɩ nɩ nɔɔnʋ mʋ nɛ a Ko Wɛ, kʋ yɩ amʋ na nuŋi DƖ te tɩn yɩranɩ mʋ nɛ-DƖ. ");
INSERT INTO xsm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wʋlʋ na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn mʋ jɩgɩ ŋwɩ-dʋŋa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Amʋ yɩ wʋdiu kʋlʋ na paɩ nabiinǝ ŋwɩ-dʋŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Faŋa faŋa tɩn, abam nabaara dɛɛn na wʋ kagʋa kam wʋnɩ tɩn, ba di wʋdiu kʋlʋ yɩrɩ na yɩ ‹Maanɩ› tɩn, yɩ ba ta wʋ lugi tʋʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kʋ daarɩ kʋntʋ yɩ wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ, yɩ wʋlʋ na di-kʋ tɩn, tʋʋnɩ daa bá ja kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Amʋ yɩ wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ nɩ yɩ kʋ jɩgɩ ŋwɩa kʋ paɩ nabiinǝ tɩn. Wʋlʋ maama na di wʋdiu kʋm kʋntʋ tɩn wʋ́ ta ŋwɩ mʋ maŋa maama. Wʋdiu kʋlʋ a na wʋ́ pa nabiinǝ tɩn yɩ a yɩra yam mʋ, sɩ kʋ pa nabiinǝ taa jɩgɩ ŋwɩ-dʋŋa.» ");
INSERT INTO xsm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zezi na tagɩ kʋntʋ tɩn, Zwifǝ bam laan ma tiini ba magɩ kantɔgɔ daanɩ ba wɩ: «Nɔɔnʋ wʋntʋ wʋ́ kɩ ta mʋ o kwe o yɩra o pa dɩbam sɩ dɩ́ di?» ");
INSERT INTO xsm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zezi laan ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam na wʋ di amʋ Nabiin-bu wʋm yɩra yam, yɩ á daarɩ á wʋ nyɔgɩ a jana kam, á ba jɩgɩ Wɛ ŋwɩ-dʋŋa kam. ");
INSERT INTO xsm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wʋlʋ nan na di a yɩra yam yɩ o daarɩ o nyɔ a jana kam tɩn, kʋntʋ tu jɩgɩ ŋwɩa kalʋ na ba ti tɩn. Amʋ wʋ́ joori a bi kʋntʋ tu lʋgʋ tiim dɛ dɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bɛŋwaanɩ a yɩra yam mʋ yɩ wʋdiu cɩga, yɩ a jana kam yɩ wo-nyɔɔrʋ cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wʋlʋ na di a yɩra yam yɩ o daarɩ o nyɔ a jana kam tɩn wʋ́ ta ŋwɩ dɩ amʋ, yɩ amʋ ŋwɩ kʋntʋ tu wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A Ko Wɛ dɩlʋ na yɩ ŋwɩa tu tɩn mʋ tʋŋɩ-nɩ. Kʋ nan yɩ dɩntʋ ŋwaanɩ mʋ amʋ dɩ jɩgɩ ŋwɩa. Kʋntʋ, wʋlʋ na di a yɩra yam tɩn, kʋntʋ tu dɩ wʋ́ ta ŋwɩ amʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mʋ wʋdiu kʋlʋ na nuŋi Wɛ-sɔŋɔ nɩ tɩn. Kʋntʋ nan ba nyɩ dɩ wʋdiu kʋlʋ abam nabaara bam dɛɛn na di yɩ ba daa ta tɩ tɩn. Wʋlʋ maama na di wʋdiu kʋntʋ tɩn wʋ́ ta ŋwɩ mʋ maŋa maama.» ");
INSERT INTO xsm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Mʋ Zezi dɛɛn na brɩ nɔɔna bam tɩte Kapɛrnawum Wɛ-digǝ kam wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Zezi karabiǝ bam zanzan na ni kʋntʋ tɩn, ba ma ta ba wɩ: «O taanɩ dɩm tiini dɩ cana. Nɔɔn-nɔɔnʋ bá wanɩ o joŋi-dɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Zezi ma lwarɩ o tɩtɩ nɩ, nɩ o karabiǝ bam pʋʋna dɩ o taanɩ dɩm. O laan ma ta dɩ ba o wɩ: «A taanɩ dɩm kʋntʋ pɛ á wʋbʋŋa vugimi mʋ na? ");
INSERT INTO xsm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kʋ nan na yɩ kʋntʋ, á na nɛ Nabiin-bu wʋm na maa joori o diini o ya na maŋɩ o wʋ mɛ tɩn, á laan wʋ́ kɩ tɩta mʋ? ");
INSERT INTO xsm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kʋ yɩ Wɛ Joro kʋm mʋ paɩ nɔɔna ŋwɩa. Kʋ daarɩ nabiinǝ dam bá wanɩ kʋlʋkʋlʋ dɩ kɩ. A na tagɩ taanɩ dɩlʋ dɩ abam tɩn mʋ pɛ abam Wɛ Joro kʋlʋ na paɩ nabiinǝ ŋwɩ-dʋŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dɩ kʋntʋ dɩ, abam badaara ta wʋ sɛ.» Zezi tagɩ kʋntʋ, bɛŋwaanɩ kʋ pulim nɩ mʋ o maŋɩ o ye balʋ na bá sɛ-o tɩn, dɩ wʋlʋ na wʋ́ ba o yǝg-o o pa nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O daa ma ta o wɩ: «Kʋntʋ ŋwaanɩ mʋ a tagɩ a brɩ abam nɩ, nɔɔn-nɔɔnʋ bá wanɩ o ba amʋ te, yɩ kʋ na daɩ a Ko Wɛ mʋ pɛ-o cwǝŋǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kʋntʋ na kɩ tɩn, o karabiǝ zanzan ma joori o kwaga nɩ, yɩ ba daa ba tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Zezi laan ma ta dɩ o karabiǝ fugǝ-bale bam o wɩ: «Abam dɩ ba lagɩ sɩ á yagɩ amʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simɔn Pɩyɛɛrɩ ma lǝr-o o wɩ: «A yuutu, dɩbam wʋ́ yagɩ nmʋ, sɩ dɩ́ daa vu wɔɔ te mʋ? Nmʋ jɩgɩ taanɩ dɩlʋ na paɩ nɔɔna ŋwɩa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dɩbam sɛ nmʋ, yɩ dɩ́ kwǝri dɩ́ lwarɩ nɩ nmʋ yɩ Wʋ-poŋo Tu wʋlʋ Wɛ na tʋŋɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Zezi ma ta dɩ ba o wɩ: «Amʋ kuri abam fugǝ-bale bam, abam dɩdʋa nan yɩ sʋtaanɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","O na tagɩ kʋntʋ tɩn, kʋ yɩ Zudasɩ wʋlʋ na yɩ Simɔn Yiskarɩyo bu tɩn taanɩ mʋ o tɛa. Wʋntʋ tɔgɩ o wʋ karabiǝ fugǝ-bale bam wʋnɩ, yɩ wʋm mʋ lagɩ o ba o yǝgi Zezi o pa nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Zezi dɛɛn maa wʋ Galile nɩ o beerǝ. O dɛɛn ba lagɩ sɩ o vu Zude o beeri da, bɛŋwaanɩ Zwifǝ yigǝ tiinǝ balʋ na wʋ dáanɩ tɩn lagɩ cwǝŋǝ mʋ sɩ ba gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kʋ dɛɛn ma daarɩ fɩɩn sɩ Zwifǝ bam di ba candiǝ kalʋ yɩrɩ na yɩ vwǝ candiǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Zezi nyaana ma ta dɩd-o ba wɩ, o yagɩ Galile je sɩm sɩ o daarɩ o vu Zude, sɩ o karabiǝ bam wanɩ ba na tɩtʋŋa yalʋ o na jɩgɩ o tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ba ta maa ta ba wɩ: «Nɔɔnʋ wʋlʋ na lagɩ sɩ ba taa ye-o lanyɩranɩ tɩn ba sǝgi kʋlʋ o na kɩ tɩn. Kʋntʋ ŋwaanɩ, nmʋ na kɩ wǝǝnu tɩntʋ tɩn, n maŋɩ sɩ n ta n kɩ-tɩ nabiinǝ maama yigǝ nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ba na tagɩ te tɩn brɩ nɩ ba tɩtɩ ta wʋ kɩ ba wʋ-dɩdʋa dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Zezi ma ta dɩ ba o wɩ: «A maŋa kam ta wʋ yi sɩ a vu candiǝ kam. Kʋ nan na yɩ abam, maŋa maama lana dɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nabiinǝ bá wanɩ ba taa culi abam. Ba nan culi amʋ, bɛŋwaanɩ amʋ yɔɔrɩ a tɛ-ba jaja mʋ, nɩ ba tɩtʋŋa ba tɔgɩ cwǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Abam nan ve-na á di candiǝ kam, sɩ amʋ ta bá vu lele, bɛŋwaanɩ a maŋa kam ta wʋ yi ka ti sɩ a vu.» ");
INSERT INTO xsm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","O na tagɩ kʋntʋ tɩn, o ma maŋɩ Galile nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Zezi nyaana bam na kɛ ba daar-o tɩn, o dɩ laan ma zaŋɩ o vu candiǝ kam. O na ve kʋntʋ tɩn, o wʋ ve jaja sɩ nɔɔna lwar-o. ");
INSERT INTO xsm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zwifǝ yigǝ tiinǝ balʋ na wʋ candiǝ kam nɩ tɩn maa karɩ ba beer-o, yɩ ba bwe ba wɩ: «O wʋ yǝn mʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nɔn-kɔgɔ kʋlʋ na wʋra tɩn maa tiini ba jɩgɩ o taanɩ ba waasa. Nɔɔna badonnǝ maa tɛ ba wɩ: «O yɩ nɔn-ŋʋm mʋ.» Badaara maa tɛ ba wɩ: «Aye, o daɩ nɔn-ŋʋm, sɩ o jɩgɩ nɔɔna bam o ganɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nɔɔn-nɔɔnʋ nan wʋ tagɩ o taanɩ jaja, bɛŋwaanɩ ba kwarɩ Zwifǝ yigǝ tiinǝ bam. ");
INSERT INTO xsm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba na di candiǝ kam ba yi ka da yam tɩtarɩ tɩn, Zezi laan ma vu o zʋ Wɛ-di-kamunu kʋm o wʋra o brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zwifǝ yigǝ tiinǝ bam maa tiini ba yɩ yǝǝu dɩ o na brɩ nɔɔna bam te tɩn. Ba maa tɛ ba wɩ: «Nɔɔnʋ wʋntʋ nan wʋ zaasɩ tɔnɔ nɔɔn-nɔɔnʋ tee nɩ, yɩ o yi kɩ ta mʋ dɩ pʋʋrɩ yɩ o ye Wɛ tɔnɔ kʋm kʋntʋ doŋ?» ");
INSERT INTO xsm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Zezi ma lǝri-ba o wɩ: «A na brɩ kʋlʋ tɩn daɩ amʋ tɩtɩ nyɩm, kʋ yɩ wʋlʋ na tʋŋɩ-nɩ tɩn nyɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wʋlʋ nan na lagɩ sɩ o kɩ Wɛ wʋbʋŋa na lagɩ kʋlʋ tɩn, kʋntʋ tu wʋ́ lwarɩ amʋ zaasɩm dɩm kuri na nuŋi mɛ tɩn, dɩ na yɩ Wɛ nyɩm mʋ, naa dɩ na yɩ a tɩtɩ dam mʋ a maa bra, oó lwarɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nɔɔnʋ wʋlʋ na ŋɔɔnɩ dɩ o tɩtɩ dam tɩn, kʋntʋ tu kwaanɩ sɩ o na yɩrɩ mʋ o pa o tɩtɩ. Kʋ daarɩ wʋlʋ nan na kwaanɩ sɩ o lagɩ yɩrɩ o pa wʋlʋ na tʋŋ-o tɩn, kʋntʋ tu mʋ yɩ wʋlʋ na jɩgɩ cɩga tɩn, yɩ o ba tusi kʋlʋkʋlʋ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyisi nan maŋɩ o pa abam lwarɩ Wɛ cullu tɩm. Abam wʋlʋwʋlʋ nan ba tɔgɩ-tɩ. Bɛɛ mʋ yɩ abam kwaanɩ á lagɩ cwǝŋǝ sɩ á gʋ amʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ba ma lǝr-o ba wɩ: «N yirisi mʋ. Wɔɔn beeri nmʋ sɩ o gʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zezi ma lǝri-ba o wɩ: «A tʋŋɩ tɩtʋŋ-kamunu dɩdʋ mʋ siun dɛ nɩ, yɩ kʋ sʋ abam. ");
INSERT INTO xsm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyisi dɛɛn pɛ abam ni sɩ á taá goni á bǝkǝri. Kʋ nan daɩ nɩ Moyisi mʋ puli-kʋ. Kʋ puli dɩ abam nabaara mʋ. Moyisi na pɛ abam ni dɩm kʋntʋ tɩn, abam maa goni á bǝkǝri dɩ siun dɛ nɩ dɩ, sɩ kʋ yɩ pa á cɔgɩ ni dɩm kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Abam na waɩ á goni bǝkǝri siun dɛ dɩm nɩ sɩ á yɩ cɔgɩ Moyisi culu kʋm, bɛɛ mʋ yɩ á bana zaŋɩ dɩ amʋ, dɩ a na pɛ yawɩɩnʋ na yazurǝ fasɩ siun dɛ nɩ tɩn ŋwaanɩ? ");
INSERT INTO xsm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Abam yɩ taá garɩ á yáalɩ nɔɔnʋ kǝm dɩ á yiǝ na nɛ kʋlʋ tɩn. Á nan maŋɩ sɩ á bʋrɩ dɩ cɩga mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nɔɔna balʋ na zʋʋrɩ Zeruzalɛm nɩ tɩn badaara laan maa ŋɔɔnɩ Zezi taanɩ ba wɩ: «Kʋ daɩ nɔɔnʋ wʋntʋ mʋ ba kwaanɩ sɩ ba gʋ tɩn na? ");
INSERT INTO xsm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nii-na o na zɩgɩ o ŋɔɔnɩ jaja, yɩ nɔɔn-nɔɔnʋ ba tɛ kʋlʋkʋlʋ sɩ ba cɩ-o. Dɩbam yigǝ tiinǝ bam laan bʋŋɩ nɩ wʋntʋ mʋ sɩɩnɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn naa? ");
INSERT INTO xsm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kʋ nan na yɩ Krisi wʋm mʋ na tuǝ, nɔɔn-nɔɔnʋ bá wanɩ o lwarɩ o na nuŋi mɛ tɩn. Kʋ daarɩ dɩbam maama ye wʋntʋ na nuŋi mɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Zezi dɛɛn na wʋ Wɛ-di-kamunu kʋm wʋnɩ o brɩ nɔɔna tɩn, o ma ŋɔɔnɩ dɩ kwǝr-dɩa o wɩ: «Abam bʋŋɩ nɩ á sɩɩnɩ á ye amʋ, yɩ á kwǝri á ye a na nuŋi mɛ tɩn. A nan wʋ tu a tɩtɩ nɩ, wʋlʋ na tʋŋɩ-nɩ tɩn yɩ cɩga tu mʋ. Abam nan yǝr-o. ");
INSERT INTO xsm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amʋ mʋ ye-o, bɛŋwaanɩ a nuŋi wʋntʋ te mʋ, yɩ wʋm mʋ tʋŋɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zezi na tagɩ kʋntʋ tɩn, ba laan ma lagɩ sɩ ba ja-o. Nɔɔn-nɔɔnʋ nan ba jɩgɩ cwǝŋǝ sɩ o kɩ-o kʋlʋkʋlʋ, o maŋa kam ta na wʋ yi tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kʋ daarɩ nɔn-kɔgɔ kʋm wʋ nɔɔna zanzan ma kɩ ba wʋ-dɩdʋa dɩd-o, yɩ ba tɛ ba wɩ: «Krisi wʋm na tuǝ, o bá wanɩ o kɩ wo-kɩnkagɩla zanzan sɩ kʋ dwǝni wʋntʋ na maŋɩ o kɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farizɩan tiinǝ bam ma ni nɔn-kɔgɔ kʋm na jɩgɩ Zezi taanɩ ba waasa te tɩn. Ba dɩ Wɛ kaanɩm yigǝ tiinǝ bam laan ma tʋŋɩ nɔɔna sɩ ba vu ba ja Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Zezi laan ma ta o wɩ: «Amʋ bá tiini a daanɩ abam tee nɩ. Kʋ na kɩ fɩɩn, aá vu wʋlʋ na tʋŋɩ-nɩ tɩn te. ");
INSERT INTO xsm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Abam nan wʋ́ ba á beeri amʋ je á ga, bɛŋwaanɩ amʋ na wʋ mɛ tɩn, abam bá wanɩ da á vu.» ");
INSERT INTO xsm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","O na tagɩ kʋntʋ tɩn, Zwifǝ yigǝ tiinǝ bam maa ŋɔɔnɩ daanɩ ba wɩ: «O lagɩ o vu yǝn mʋ yɩ dɩbam bá na-o? O ga lagɩ o vu Zwifǝ balʋ na zʋʋrɩ Grɛkɩ tiinǝ tɩɩnɩ dɩm nɩ tɩn te mʋ, sɩ o taa brɩ-ba na? ");
INSERT INTO xsm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O taanɩ dɩm kuri mʋ bɛɛ? O na tagɩ o wɩ, dɩbam wʋ́ ba dɩ́ beeri wʋm jǝgǝ dɩ́ ga, yɩ o ta o wɩ, wʋm na wʋ mɛ tɩn, dɩbam bá wanɩ da dɩ́ vu tɩn, kʋ kuri mʋ bɛɛ?» ");
INSERT INTO xsm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kʋ dɛɛn ma ba kʋ yi candiǝ kam tiim dɛ. Dɛ dɩm kʋntʋ mʋ yɩ candiǝ kam dɛ kamunu. Zezi maa zaŋɩ wɛɛnɩ o ŋɔɔnɩ dɩ kwǝr-dɩa o wɩ: «Na-nyɔm na jɩgɩ wʋlʋ maama tɩn, sɩ o ba amʋ te o nyɔ. ");
INSERT INTO xsm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bɛŋwaanɩ wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn wʋ́ na ŋwɩ-dʋŋa Wɛ tee nɩ, nɩnɛɛnɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ brɩ te kʋ wɩ: ‹Na balʋ na paɩ nabiinǝ ŋwɩa tɩn wʋ́ ta buri kʋntʋ tu bɩcarɩ nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zezi na tagɩ na bam taanɩ kʋntʋ tɩn, kʋ yɩ o brɩ Wɛ na wʋ́ kɩ DƖ Joro kʋm balʋ na kɩ ba wʋ-dɩdʋa dɩd-o tɩn bɩcara nɩ te tɩn mʋ. Kantʋ maŋa nɩ Wɛ Joro kʋm daa ta wʋ tu ba te, bɛŋwaanɩ Zezi daa ta wʋ tɩgɩ o joori o bi o na paarɩ-zulǝ Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nɔn-kɔgɔ kʋm dɛɛn na ni Zezi na tagɩ te tɩn, badaara maa tɛ ba wɩ: «Nɔɔnʋ wʋntʋ sɩɩnɩ o yɩ Wɛ nijoŋnu wʋlʋ ya na maŋɩ sɩ o ba tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Badaara dɩ maa tɛ ba wɩ: «O yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn mʋ.» Kʋ daarɩ badonnǝ maa tɛ ba wɩ: «Kʋ da-o. Krisi wʋm na tuǝ, o bá nuŋi Galile. ");
INSERT INTO xsm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bɛŋwaanɩ Wɛ tɔnɔ kʋm brɩ nɩ Krisi wʋm wʋ́ ta yɩ Pɛ Davidi dwi tu mʋ, yɩ o nuŋi Betelɩhɛm, tɩʋ kʋlʋ Davidi dɛɛn na zʋʋrɩ da tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kʋntʋ ŋwaanɩ, kampwara dɛɛn ma ba nɔn-kɔgɔ kʋm wʋ Zezi ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Badaara lagɩ sɩ ba ja-o, yɩ nɔɔn-nɔɔnʋ nan wʋ nɛ cwǝŋǝ sɩ o kɩ-o kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wɛ kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam na tʋŋɩ nɔɔna balʋ tɩn ma joori ba ba ba te. Ba ma bwe-ba ba wɩ: «Bɛɛ mʋ yɩ á wʋ jaan-o á ba?» ");
INSERT INTO xsm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɔɔna bam ma lǝri-ba ba wɩ: «Nɔɔn-nɔɔnʋ maŋɩ o wʋ ŋɔɔnɩ nɩ nɔɔnʋ wʋm kʋntʋ na ŋɔɔnɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farizɩan tiinǝ bam ma ta-ba ba wɩ: «Abam pɛ o ganɩ abam dɩ mʋ na? ");
INSERT INTO xsm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Abam yǝri nɩ dɩbam yigǝ tiinǝ dɩ Farizɩan tiinǝ bam wʋlʋwʋlʋ wʋ sɛ-o na? ");
INSERT INTO xsm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kʋ nan na yɩ nɔn-kɔgɔ kʋm, bantʋ yǝri Wɛ cullu tɩm Moyisi na tiŋi o pa dɩbam tɩn. Kʋntʋ ŋwaanɩ kʋʋ́ cɔgɩ-ba.» ");
INSERT INTO xsm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farizɩan tiinǝ bam wʋ nɔɔnʋ dɩdʋa dɛɛn maa tɔgɩ o wʋra, o yɩrɩ mʋ Nikodɛm. Wʋntʋ mʋ yɩ wʋlʋ ya na maŋɩ o vu Zezi te tɩn. O ma zaŋɩ o ta dɩ o donnǝ bam o wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kʋ na yɩ Wɛ cullu tɩm Moyisi na brɩ tɩn, kʋ culǝ sɩ dɩ́ cɔgɩ nɔɔnʋ, yɩ dɩ́ daa ta wʋ bwe-o sɩ dɩ́ ni o na kɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba laan ma lǝri ba wɩ: «Nmʋ dɩ yɩ Galile tu mʋ na? Nan karɩmɩ Wɛ tɔnɔ wʋnɩ n nii, sɩ n na nɩ Wɛ nijoŋnu tǝrǝ o na wʋ́ nuŋi Galile nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ba maama laan ma jagɩ ba vu sam. ");
INSERT INTO xsm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kʋ daarɩ Zezi dɛɛn ma vu Olivi piu kʋm yuu. ");
INSERT INTO xsm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tɩga na pʋʋrɩ tɩtɩɩtɩ puru tɩn, Zezi ma joori o vu o zʋ Wɛ-di-kamunu kʋm wʋ. Nɔn-kɔgɔ kʋm maama ma ba kʋ gilim-o. O ma jǝni tɩga nɩ o wʋra o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wɛ cullu karanyɩna tiinǝ dɩ Farizɩan tiinǝ ma ja kaanɩ wʋlʋ ba na pɩɩr-o boorim baŋa nɩ tɩn, ba ja ba ba zɩgɩ ba maama yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ba ma ta dɩ Zezi ba wɩ: «Karanyɩna, dɩbam pɩɩrɩ kaanɩ wʋntʋ boorim baŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moyisi na pɛ dɩbam Wɛ cullu tɩlʋ tɩn pɛ dɩbam ni sɩ, kaanɩ na kɩ kǝm dɩntʋ doŋ, sɩ dɩ́ dʋl-o dɩ́ gʋ mʋ. Kʋ nan na yɩ nmʋ, nmʋ wɩ dɩ́ kɩ ta mʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ba na bwe-o kʋntʋ tɩn, ba lagɩ sɩ ba maŋɩ Zezi mʋ ba nii, baá wanɩ ba saŋ-o na? Zezi ma tiiri o ma o nʋa o la tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ba maa ta joori ba bwe Zezi taan. O laan ma kwǝni wɛɛnɩ, yɩ o ta dɩ ba o wɩ: «Abam wʋlʋ na wʋ kɩ lwarɩm tɩn, sɩ o da yigǝ o kwe kandwɛ o ma dʋlɩ kaanɩ wʋm.» ");
INSERT INTO xsm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O laan ma joori o tiiri o wʋra o la tɩga nɩ dɩ o nʋa. ");
INSERT INTO xsm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba na ni o na tagɩ te tɩn, ba nakwa bam mʋ dɛ yigǝ ba nuŋi dɩdʋa dɩdʋa ba viiri. Ba maama ma nuŋi ba daarɩ Zezi yɩranɩ, yɩ kaanɩ wʋm daa ta zɩgɩ o yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","O ma kwǝni wɛɛnɩ, yɩ o bwe kaanɩ wʋm o wɩ: «Balʋ na saŋɩ nmʋ tɩn wʋ yǝn? Ba nɔɔn-nɔɔnʋ daa wʋ daarɩ sɩ o ŋɔɔnɩ o cɔgɩ nmʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O ma lǝri o wɩ: «Aye, a tu, ba nɔɔn-nɔɔnʋ daa wʋ daarɩ.» Zezi ma ta dɩd-o o wɩ: «Amʋ dɩ nan bá di nmʋ sarɩya. Ve, nan daa n yɩ kɩ lwarɩm.» ");
INSERT INTO xsm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zezi dɛɛn ma ta dɩ nɔɔna bam o wɩ: «Amʋ mʋ yɩ pooni a paɩ nabiinǝ maama. Wʋlʋ nan na tɔgɩ amʋ tɩn, kʋntʋ tu daa bá vu lim wʋnɩ. Kʋntʋ tu wʋ́ na pooni dɩlʋ na wʋ́ pa-o ŋwɩa cɩga cɩga tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farizɩan tiinǝ bam ma ta dɩd-o ba wɩ: «Nmʋ na paɩ n tɩtɩ cɩga tɩn, n taanɩ dɩm ba jɩgɩ kuri.» ");
INSERT INTO xsm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","O ma lǝri-ba o wɩ: «A na maŋɩ a paɩ a tɩtɩ cɩga dɩ, kʋ ta yɩ cɩga mʋ, bɛŋwaanɩ amʋ ye a na nuŋi mɛ tɩn. Abam nan yǝri amʋ na nuŋi mɛ dɩ mɛ a na maa ve tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Abam yǝni á di nɔɔna taanɩ nɩ nabiinǝ wʋbʋŋa na lagɩ te tɩn mʋ. Amʋ nan ba di nɔɔn-nɔɔnʋ taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kʋ daarɩ, amʋ na lagɩ a di nɔɔna taanɩ, amʋ taanɩ dim dɩm wʋ́ ta yɩ cɩga mʋ, bɛŋwaanɩ amʋ Ko mʋ tʋŋɩ-nɩ. O nan wʋra dɩ amʋ, kʋ daɩ amʋ yɩranɩ mʋ wʋ́ di nɔɔna taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kʋ pʋpʋnɩ Moyisi cullu twaanʋ tɩm wʋnɩ kʋ wɩ, nɔɔna bale na jɩgɩ ni dɩdʋa, ba na tagɩ kʋlʋ tɩn yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Amʋ paɩ a tɩtɩ cɩga, yɩ a Ko wʋlʋ na tʋŋɩ-nɩ tɩn dɩ paɩ amʋ cɩga.» ");
INSERT INTO xsm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba ma bwe-o ba wɩ: «N ko wʋm bɛɛ?» O ma lǝri-ba o wɩ: «Abam yǝri amʋ na yɩ wʋlʋ tɩn, yɩ á yǝri a Ko wʋm dɩ. Á ya na ye amʋ, á ya wʋ́ lwarɩ a Ko wʋm dɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zezi dɛɛn tagɩ wǝǝnu tɩm kʋntʋ o brɩ nɔɔna Wɛ-di-kamunu kʋm wʋnɩ, jǝgǝ kalʋ nɔɔna na ve ba dɩ sǝbu da ba pa Wɛ tɩn mʋ. O na tagɩ kʋntʋ o ti tɩn, nɔɔn-nɔɔnʋ wʋ nɛ cwǝŋǝ sɩ o ja-o, o maŋa kam ta na wʋ yi tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zezi daa ma ta dɩ nɔn-kɔgɔ kʋm o wɩ: «Amʋ wʋ́ viiri, yɩ abam wʋ́ beeri amʋ jǝgǝ á ga, bɛŋwaanɩ abam wʋ́ tɩ á lwarɩm dɩm wʋnɩ mʋ. A na maa ve mɛ tɩn, abam bá wanɩ da á vu.» ");
INSERT INTO xsm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Zwifǝ bam maa tɛ daanɩ ba wɩ: «O na tagɩ o wɩ, dɩbam bá wanɩ dɩ́ vu o na maa ve mɛ tɩn, kʋ brɩ nɩ o lagɩ o gʋ o tɩtɩ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","O ma ta dɩ ba o wɩ: «Abam yɩ lʋgʋ baŋa nɔɔna mʋ, amʋ nan nuŋi wɛyuu mʋ. Abam kugu je yɩ lʋgʋ baŋa yo mʋ. Amʋ kugu je nan daɩ lʋgʋ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kʋntʋ mʋ a tagɩ a brɩ abam nɩ, abam wʋ́ tɩ á lwarɩm dɩm wʋnɩ mʋ, bɛŋwaanɩ abam na wʋ sɛ nɩ amʋ sɩɩnɩ a yɩ wʋlʋ na wʋra maŋa maama tɩn, á wʋ́ tɩ á lwarɩm dɩm wʋnɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ba ma bwe-o ba wɩ: «Nmʋ yɩ wɔɔ mʋ?» O ma ta dɩ ba o wɩ: «Kʋ yɩ kʋlʋ a na maŋɩ a ta a brɩ abam tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Amʋ ya jɩgɩ wǝǝnu zanzan sɩ a ŋɔɔnɩ a ma di abam taanɩ. Wʋlʋ nan na tʋŋɩ-nɩ tɩn tiini o yɩ cɩga tu mʋ. A na ni kʋlʋ o tee nɩ tɩn yɩranɩ mʋ a tɛ a brɩ nabiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Zezi na tagɩ wǝǝnu tɩm kʋntʋ tɩn, ba wʋ lwarɩ nɩ kʋ yɩ o Ko Baŋa-Wɛ taanɩ mʋ o ŋɔɔnɩ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","O laan ma ta dɩ ba o wɩ: «Maŋa wʋ́ ba, yɩ á kwe amʋ wʋlʋ na yɩ Nabiin-bu wʋm tɩn á zǝŋi wɛɛnɩ. Á laan wʋ́ lwarɩ nɩ amʋ sɩɩnɩ a yɩ wʋlʋ na wʋra maŋa maama tɩn. Abam ta wʋ́ lwarɩ nɩ amʋ ba kɩ kʋlʋkʋlʋ a tɩtɩ nɩ. A nan yǝni a tɛ wǝǝnu tɩlʋ a Ko wʋm na brɩ-nɩ tɩn yɩranɩ mʋ a brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wʋlʋ nan na tʋŋɩ-nɩ tɩn wʋ amʋ tee nɩ, o wʋ yagɩ-nɩ a yɩranɩ, bɛŋwaanɩ a yǝni a kɩ kʋlʋ na poli o wʋ tɩn mʋ maŋa maama.» ");
INSERT INTO xsm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Zezi dɛɛn na ŋɔɔnɩ kʋntʋ doŋ tɩn, nɔɔna zanzan laan ma kɩ ba wʋ-dɩdʋa dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zezi laan ma ta dɩ Zwifǝ balʋ na sɛ-o tɩn o wɩ: «Abam na sɛ amʋ zaasɩm dɩm yɩ á wʋ yagɩ, á wʋ́ sɩɩnɩ á ji amʋ karabiǝ cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Abam laan wʋ́ ba á lwarɩ cɩga, yɩ cɩga kam wʋ́ vrɩ abam ka yagɩ sɩ á taá te á tɩtɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ba ma lǝr-o ba wɩ: «Dɩbam yɩ Abraham dwi tiinǝ mʋ, dɩbam maŋɩ dɩ́ wʋ jigi nɔɔn-nɔɔnʋ gambɛ. Bɛŋwaanɩ mʋ yɩ n ta n wɩ, dɩ́ wʋ́ ta te dɩ́ tɩtɩ tɩn?» ");
INSERT INTO xsm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","O ma ta dɩ ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, wʋlʋ maama na kɩ lwarɩm tɩn yɩ lwarɩm gambaa mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kʋ nan na yɩ gambaa, kantʋ ba zʋʋrɩ ka tu sɔŋɔ nɩ maŋa maama. Kʋ daarɩ, kʋ na yɩ sɔŋɔ kʋm bu, wʋntʋ jɩgɩ kugu je sɔŋɔ kʋm wʋnɩ maŋa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kʋntʋ ŋwaanɩ, Wɛ Bu wʋm na vrɩ abam o yagɩ, á wʋ́ sɩɩnɩ á taá te á tɩtɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Amʋ ye nɩ abam yɩ Abraham dwi tiinǝ mʋ, yɩ abam ta kwaanɩ sɩ á gʋ amʋ, bɛŋwaanɩ á ba sɛ a zaasɩm dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Amʋ ŋɔɔnɩ wǝǝnu tɩlʋ a na nɛ amʋ Ko tee nɩ tɩn mʋ. Abam dɩ nan kɩ kʋlʋ á na niǝ abam ko tee nɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ba ma lǝr-o ba wɩ: «Dɩbam ko mʋ Abraham.» O ma ta dɩ ba o wɩ: «Abam ya na sɩɩnɩ á yɩ Abraham biǝ, á ya wʋ́ taá kɩ wǝǝnu tɩlʋ Abraham dɛɛn na kɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Amʋ tagɩ cɩga kalʋ a na ni Wɛ tee nɩ tɩn a brɩ abam, yɩ abam kwaanɩ sɩ á gʋ-nɩ. Abraham dɛɛn nan ba kɩ abam kǝm dɩm doŋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Abam yǝni á kɩ kǝnǝ yalʋ á ko na kɩ tɩn mʋ.» Ba ma lǝr-o ba wɩ: «Dɩbam daɩ tampirǝ. Wɛ tɩtɩ yɩranɩ mʋ yɩ dɩbam Ko.» ");
INSERT INTO xsm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","O ma ta dɩ ba o wɩ: «Baŋa-Wɛ ya na yɩ abam Ko, á ya wʋ́ taá soe amʋ, bɛŋwaanɩ amʋ nuŋi Wɛ te mʋ a ba a wʋra dɩ abam. A wʋ tu a tɩtɩ nɩ. Wɛ mʋ tʋŋɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɛɛ mʋ yɩ abam ba ni a taanɩ dɩm kuri? Kʋ yɩ abam na ba lagɩ sɩ á sɛ a taanɩ dɩm tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Abam yɩ á ko sʋtaanɩ biǝ mʋ. Á maa lagɩ sɩ á taá kɩ dɩ wʋbʋŋa na lagɩ te tɩn. Pulim nɩ tɩn sʋtaanɩ maŋɩ dɩ yɩ nɔn-gʋrʋ mʋ. Dɩ ba fɔgɩ dɩ tɔgɩ cɩga cwǝŋǝ, bɛŋwaanɩ cɩga tǝri dɩ wʋnɩ. Dɩ na yǝni dɩ fɔ vwan, kʋ yɩ dɩ wʋbʋŋa na maŋɩ ya yɩ te tɩn mʋ. Dɩ yɩ vwa-fɔrʋ mʋ. Dɩntʋ nan mʋ yɩ vwa-nyɩna ko. ");
INSERT INTO xsm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kʋ na yɩ amʋ, a yǝni a tɛ cɩga mʋ. Kʋntʋ ŋwaanɩ mʋ abam ba sɛ amʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Abam wɔɔ mʋ wʋ́ wanɩ o brɩ nɩ amʋ kɩ a cɔgɩ? Amʋ nan na ŋɔɔnɩ cɩga tɩn, bɛɛ mʋ yɩ á ba sɛ-nɩ? ");
INSERT INTO xsm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wʋlʋ na yɩ Wɛ nɔɔnʋ tɩn cǝgi Wɛ taanɩ mʋ. Abam nan na daɩ Wɛ nɔɔna tɩn mʋ paɩ á ba cǝgǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Zwifǝ bam ma lǝri Zezi ba wɩ: «Dɩbam jɩgɩ bʋra sɩ dɩ́ ta nɩ, nmʋ sɩɩnɩ n yɩ Samari tu mʋ. N yirisi mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","O ma lǝri-ba o wɩ: «A ba yirisǝ. Amʋ paɩ a Ko mʋ zulǝ. Kʋ daarɩ abam nan gooni amʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A nan ba beeri a tɩtɩ zulǝ. Wɛ yɩranɩ mʋ pa-nɩ zulǝ, yɩ dɩntʋ mʋ di nabiinǝ taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wʋlʋ maama na sɛ yɩ o kɩ a na tagɩ kʋlʋ tɩn, tʋʋnɩ daa bá ja kʋntʋ tu.» ");
INSERT INTO xsm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Zwifǝ bam laan ma ta dɩd-o ba wɩ: «N taanɩ dɩm n na tagɩ tɩn pɛ dɩ́ lwarɩ nɩ n yirisi mʋ. Abraham dɛɛn tɩga, yɩ Wɛ nijoŋnǝ bam maama dɩ tɩ. Nmʋ nan ta tagɩ n wɩ, wʋlʋ na sɛ yɩ o kɩ n na tagɩ kʋlʋ tɩn, tʋʋnɩ daa bá ja kʋntʋ tu. ");
INSERT INTO xsm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nmʋ yɩ nɔn-kamunu n dwe dɩbam ko Abraham mʋ na? Wʋntʋ nan tɩga. Wɛ nijoŋnǝ bam dɩ ma tɩ. Nmʋ bʋŋɩ n paɩ n yɩ wɔɔ?» ");
INSERT INTO xsm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","O ma lǝri-ba o wɩ: «A ya na lagɩ yɩrɩ a pa a tɩtɩ, kʋntʋ ya yɩ kafɛ mʋ. Kʋ yɩ a Ko Wɛ mʋ zǝŋi a yɩrɩ, kʋ yɩ dɩntʋ mʋ abam yǝni á tɛ á wɩ: ‹Wɛ dɩlʋ na yɩ dɩbam Wɛ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Abam nan yǝri-DƖ, amʋ nan ye-DƖ. A ya na tagɩ a wɩ, a yǝri-DƖ, a ya yɩ vwa-nyɩm mʋ nɩnɛɛnɩ abam te. Amʋ nan sɩɩnɩ a ye-DƖ, yɩ a sɛ a kɩ kʋlʋ DƖ na tagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abam ko Abraham dɛɛn jɩgɩ wʋpolo sɩ o na maŋa kam a na wʋ́ ba tɩn. O nan sɩɩnɩ o na-ka, yɩ o wʋ poli.» ");
INSERT INTO xsm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ba ma lǝri ba wɩ: «Nmʋ ta wʋ yi bɩna fiinnu, yɩ n kɩ ta mʋ n na Abraham?» ");
INSERT INTO xsm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","O ma lǝri-ba o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, ba dɛɛn ta na wʋ lʋgɩ Abraham tɩn, amʋ maŋɩ a wʋra mʋ, a nan ta wʋ́ ta wʋra maŋa maama.» ");
INSERT INTO xsm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Zezi na tagɩ kʋntʋ tɩn, ba laan ma kwe kandwa sɩ ba ma dʋl-o ba gʋ. O ma sǝgi o nuŋi Wɛ-di-kamunu kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zezi dɛɛn ma vu o maa kɛa. O ma na nɔɔnʋ wʋdoŋ ba na maŋɩ ba lʋ-o yɩ o yɩ lilwe. ");
INSERT INTO xsm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","O karabiǝ bam ma bwe-o ba wɩ: «Karanyɩna, wɔɔ lwarɩm mʋ pɛ ba lʋ nɔɔnʋ wʋntʋ dɩ lilweem? Kʋ yɩ o tɩtɩ lwarɩm mʋ naa, o nu dɩ o ko lwarɩm mʋ pɛ ba lʋ-o dɩ lilweem?» ");
INSERT INTO xsm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zezi ma lǝri-ba o wɩ: «O na yɩ lilwe tɩn, kʋ daɩ o tɩtɩ mʋ kɩ lwarɩm naa o nu dɩ o ko mʋ kɩ lwarɩm. Kʋ nan yɩ sɩ kʋ pa nɔɔna mʋ wanɩ ba lwarɩ Wɛ tɩtʋŋa na yɩ te tɩn wʋntʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dɩbam nan maŋɩ sɩ dɩ́ tʋŋɩ wʋlʋ na tʋŋɩ-nɩ tɩn tɩtʋŋa yam yɩ wɩa ta wʋra mʋ. Kʋ daarɩ fɩɩn sɩ tɩga yi, yɩ nɔɔn-nɔɔnʋ daa bá wanɩ o tʋŋɩ Wɛ tɩtʋŋa yam. ");
INSERT INTO xsm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Maŋa kam a ta na wʋ lʋgʋ baŋa nɩ tɩn, amʋ yɩ pooni mʋ a paɩ nabiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","O na tagɩ kʋntʋ o ti tɩn, o laan ma twɩ lileeru o dɩ tɩga nɩ. O ma viiri tɩɩrʋ, yɩ o kɩ-tɩ o bǝ lilwe wʋm yiǝ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O ma ta dɩd-o o wɩ: «Ve n su n yiǝ yam Silʋa bugǝ kam nɩ.» (Bugǝ kam yɩrɩ dɩm kuri mʋ Atʋŋɩ.) Nɔɔnʋ wʋm ma vu o su o yiǝ yam. O ma joori o ba, yɩ o laan naɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Balʋ na zʋʋrɩ o tɩkǝri nɩ dɩ balʋ na maŋɩ ba ye nɩ o yɩ looru tɩn ma na-o, yɩ ba bwɛ ba wɩ: «Kʋ daɩ nɔɔnʋ wʋntʋ mʋ yǝni o je o loori tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Badaara maa tɛ ba wɩ: «Kʋ yɩ wʋntʋ mʋ.» Badonnǝ maa wɩ: «Kʋ daɩ wʋntʋ, sɩ ba nyɩ daanɩ mʋ.» Nɔɔnʋ wʋm tɩtɩ ma ta o wɩ: «Kʋ yɩ amʋ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ba ma bwe-o ba wɩ: «Nmʋ yiǝ yam kɩ ta mʋ ya puri?» ");
INSERT INTO xsm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O ma lǝri o wɩ: «Nɔɔnʋ wʋlʋ yɩrɩ na yɩ Zezi tɩn mʋ kɩ tɩɩrʋ o ma bǝ a yiǝ yam baŋa, yɩ o ta-nɩ o wɩ, a ve Silʋa bugǝ kam a su-ya. A ma vu a su, yɩ a laan naɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ba ma bwe-o ba wɩ: «Nɔɔnʋ wʋm kʋntʋ bɛ?» O ma lǝri-ba o wɩ: «A yǝri o je.» ");
INSERT INTO xsm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ba laan ma ja-o ba vu Farizɩan tiinǝ bam te. ");
INSERT INTO xsm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dɛ dɩm Zezi na kɩ tɩɩrʋ tɩm o ma puri nɔɔnʋ wʋm yiǝ yam tɩn ya yɩ Zwifǝ bam siun dɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kʋntʋ ŋwaanɩ mʋ Farizɩan tiinǝ bam dɩ daa bwe nɔɔnʋ wʋm ba wɩ: «N yiǝ yam kɩ ta mʋ ya puri?» O ma ta-ba o wɩ: «O kɩ tɩɩrʋ mʋ o ma bǝ a yiǝ baŋa. A ma su-ya, yɩ a laan naɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farizɩan tiinǝ bam badaara ma ta ba wɩ: «Nɔɔnʋ wʋm na kɩ te tɩn, o wʋ nuŋi Wɛ te, bɛŋwaanɩ o cɔgɩ siun dɛ cullu tɩm.» Badonnǝ dɩ maa tɛ ba wɩ: «O na yɩ nɔn-balɔrɔ, o bá wanɩ o kɩ wo-kɩnkagɩla yantʋ doŋ.» Kʋntʋ ma pa kampwara ba ba tɩtarɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ba laan ma joori ba bwe nɔɔnʋ wʋm ba wɩ: «O nan na pɛ n yiǝ yam puri tɩn, nmʋ tɛ n wɩ, o yɩ wɔɔ mʋ?» O ma lǝri o wɩ: «O yɩ Wɛ nijoŋnu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Zwifǝ yigǝ tiinǝ bam maa ba lagɩ sɩ ba sɛ, nɩ nɔɔnʋ wʋm ya maŋɩ o yɩ lilwe mʋ yɩ o laan ba o naɩ. Kʋntʋ ŋwaanɩ, ba ma bǝŋi nɔɔnʋ wʋm nu dɩ o ko sɩ ba bwe ba nii. ");
INSERT INTO xsm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba ma bwe-ba ba wɩ: «Wʋntʋ yɩ abam bu mʋ na? Á lʋg-o dɩ o maŋɩ o yɩ lilwe mʋ na? O nan kɩ ta mʋ o naɩ lele kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nɔɔnʋ wʋm tiinǝ bam ma lǝri ba wɩ: «Dɩbam ye nɩ o yɩ dɩbam bu mʋ. Dɩ́ ye nɩ dɩ́ lʋg-o dɩ o yɩ lilwe mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dɩ́ nan yǝri o laan na kɩ te o naɩ, yɩ dɩ́ yǝri wʋlʋ na puri o yiǝ yam dɩ. Abam nan bwe-na o tɩtɩ, sɩ o yɩ nɔn-kwɩʋn mʋ, o tɩtɩ wʋ́ wanɩ o lǝri.» ");
INSERT INTO xsm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","O tiinǝ bam na tagɩ kʋntʋ tɩn, ba dɛɛn kwarɩ Zwifǝ yigǝ tiinǝ bam mʋ. Bantʋ ya maŋɩ ba kɩ ni daanɩ sɩ nɔɔnʋ wʋlʋ maama na sɛ nɩ Zezi mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, sɩ ba lɩ kʋntʋ tu ba Wɛ-digǝ kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mʋ kʋ kuri o tiinǝ bam cɩm, yɩ ba ta ba wɩ, ba bwe o tɩtɩ sɩ o yɩ nɔn-kwɩʋn mʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ba ma joori ba bǝŋi nɔɔnʋ wʋm ba na lʋg-o dɩ lilweem tɩn, yɩ ba ta dɩd-o ba wɩ: «Nan kwarɩ Wɛ, sɩ n ta cɩga, sɩ dɩbam ye nɩ nɔɔnʋ wʋm kʋntʋ yɩ nɔn-balɔrɔ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O ma lǝri-ba o wɩ: «Amʋ yǝri nɩ nɔɔnʋ wʋm kʋntʋ yɩ nɔn-balɔrɔ naa o daɩ. Kʋlʋ yɩranɩ a na ye tɩn mʋ yɩ sɩ, a dɛɛn yɩ lilwe mʋ, yɩ a laan naɩ lele kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba ma bwe-o ba wɩ: «O kɩ ta mʋ o puri nmʋ yiǝ yam?» ");
INSERT INTO xsm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɔɔnʋ wʋm ma lǝri o wɩ: «A maŋɩ a ta a brɩ abam, yɩ á wʋ sɛ sɩ á cǝgi. Bɛɛ mʋ yɩ abam daa lagɩ sɩ á bwe á nii? Abam dɩ ga lagɩ sɩ á taá tɔgɩ á yɩ o karabiǝ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","O na tagɩ kʋntʋ tɩn, ba ma twɩ-o yɩ ba wɩ: «Kʋ yɩ nmʋ mʋ tɔgɩ o kwaga, sɩ kʋ daɩ dɩbam mʋ tɔg-o. Dɩbam tɔgɩ Moyisi cullu tɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Dɩbam ye nɩ Wɛ dɛɛn ŋɔɔnɩ dɩ Moyisi mʋ. Kʋ daarɩ, kʋ na yɩ nɔɔnʋ wʋntʋ, dɩ́ brɩ dɩ́ yǝri o na nuŋi mɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","O ma lǝri-ba o wɩ: «Aa. Kʋ yɩ kʋlʋ na tiini kʋ sʋ amʋ tɩn. Abam yǝri o na nuŋi mɛ, yɩ wʋntʋ nan mʋ puri a yiǝ yam. ");
INSERT INTO xsm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dɩbam ye nɩ Wɛ ba cǝgi nɔn-balwaarʋ taanɩ. Kʋ yɩ nɔɔna balʋ na nɩgɩ-DƖ yɩ ba kɩ DƖ wʋbʋŋa na lagɩ te tɩn mʋ DƖ cǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kʋ na zɩgɩ lʋgʋ baŋa pulim nɩ sɩ kʋ ba kʋ yi zɩm tɩn, dɩ́ daa ta wʋ ni nɩ nɔɔnʋ puri wʋlʋ ba na lʋg-o dɩ lilweem tɩn yiǝ. ");
INSERT INTO xsm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nɔɔnʋ wʋntʋ na sɩɩnɩ o wʋ nuŋi Wɛ te, o ya bá wanɩ o kɩ wo-kɩnkagɩlɩ dɩntʋ doŋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ba ma lǝr-o ba wɩ: «Ba lʋgɩ nmʋ yɩ n maama maŋɩ n yɩ lwarɩm punǝ mʋ. Bɛɛ mʋ yɩ n bʋŋɩ sɩ n brɩ dɩbam?» Ba laan ma zǝl-o, sɩ o daa yɩ tɔgɩ o zʋ ba Wɛ-digǝ kam. ");
INSERT INTO xsm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zezi dɛɛn ma ni nɩ ba lɩ nɔɔnʋ wʋm ba Wɛ-digǝ kam wʋnɩ. O ma vu o jeer-o, yɩ o bwe-o o wɩ: «Nmʋ sɛ Nabiin-bu wʋm dɩ n wʋ maama na?» ");
INSERT INTO xsm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nɔɔnʋ wʋm ma lǝri o wɩ: «A yuutu, ta n brɩ-nɩ o na yɩ wʋlʋ tɩn, sɩ a wanɩ a sɛ-o.» ");
INSERT INTO xsm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","O ma ta dɩd-o o wɩ: «Nmʋ maŋɩ n na-o. Amʋ mʋ yɩ Nabiin-bu wʋm, a zɩgɩ a ŋɔɔnɩ dɩ nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O laan ma ta o wɩ: «A Yuutu, a sɛ-m.» O ma kuni doonǝ Zezi yigǝ nɩ o zul-o. ");
INSERT INTO xsm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zezi ma ta o wɩ: «Amʋ tu lʋgʋ kʋntʋ baŋa sɩ a pɔɔrɩ nɔɔna balʋ na jɩgɩ bʋra dɩ balʋ na ba jɩgɩ bʋra tɩn mʋ daanɩ, sɩ balʋ na yɩ lilwǝ tɩn yiǝ puri, sɩ balʋ yiǝ na naɩ tɩn joori ya dwe.» ");
INSERT INTO xsm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizɩan tiinǝ badaara balʋ na wʋra dɩd-o tɩn ma ni o na tagɩ te tɩn. Ba ma bwe-o ba wɩ: «Nmʋ lagɩ n brɩ nɩ dɩbam nyɩ dɩ lilwǝ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zezi ma lǝri-ba o wɩ: «Abam ya na nyɩ dɩ lilwǝ, kʋ lagɩ kʋ ta nɩ á yǝri Wɛ taanɩ dɩm mʋ, á lwarɩm ya bá ta wʋ á yuu nɩ. Kʋ daarɩ, á nan na brɩ nɩ á yiǝ pʋʋrɩ tɩn, á lwarɩm taa wʋ á yuu nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zezi dɛɛn ma maŋɩ mɩmaŋa o brɩ nɔɔna bam o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ wʋlʋ na wʋ dɛ najɩrɩ ni o zʋ sɩ o pʋrɩ peeni yɩ o tɔgɩ jǝgǝ kadoŋ o cu o zʋ tɩn, kʋntʋ tu yɩ ŋwɩɩnʋ yɩ o kwǝri o yɩ vɩrnʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kʋ daarɩ, wʋlʋ na dɛ najɩrɩ dɩm ni o zʋ sɩ o pʋrɩ o peeni sɩm tɩn, wʋm mʋ yɩ peeni sɩm nayɩrʋ wʋm tɩtɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O na lagɩ o zʋ, wʋlʋ na nii najɩrɩ dɩm ni baŋa nɩ tɩn wʋ́ pʋrɩ o pa o zʋ. Peeni sɩm wʋ́ ni o kwǝrǝ, yɩ oó bǝŋi o tɩtɩ peeni sɩm yɩra, yɩ sɩ da-o sɩ nuŋi. ");
INSERT INTO xsm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","O na jaanɩ-sɩ o nuŋi, oó ta tɔgɩ sɩ yigǝ, yɩ peeni sɩm tɔgɩ o kwaga, bɛŋwaanɩ sɩ ye o kwǝrǝ. ");
INSERT INTO xsm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kʋ nan na yɩ nɔn-gaa, sɩ bá sɛ sɩ tɔg-o. Sɩ wʋ́ duri sɩ viiri mʋ, bɛŋwaanɩ sɩ yǝri o kwǝrǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zezi na tagɩ kʋntʋ o brɩ-ba tɩn, ba ma wʋ lwarɩ o taanɩ dɩm kuri. ");
INSERT INTO xsm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zezi daa ma ta o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, amʋ mʋ nyɩ dɩ ni dɩlʋ peeni sɩm na tɔgɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Balʋ maama na dɛ yigǝ ba ba ba zʋ ba loori amʋ tɩn nyɩ dɩ ŋwɩɩna dɩ vɩrna mʋ. Peeni sɩm ma wʋ sɛ ba ni. ");
INSERT INTO xsm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Amʋ mʋ yɩ ni dɩm. Wʋlʋ maama na tɔgɩ amʋ o zʋ tɩn, kʋntʋ tu wʋ́ na vrɩm. O nan wʋ́ na ŋwɩa kalʋ na ywǝmmǝ tɩn, nɩ peeni na tɔgɩ najɩrɩ ni sɩ nuŋi sɩ di yɩ sɩ joori sɩ zʋʋrɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ŋwɩɩnʋ na tu o zʋ, o lagɩ sɩ o ŋɔ mʋ o gʋ o daarɩ o ja o cɔgɩ. Kʋ nan na yɩ amʋ, a tu sɩ a pa nabiinǝ mʋ na ŋwɩa kalʋ na ywǝnǝ tɩn cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Amʋ mʋ nyɩ dɩ nayɩr-ŋʋm cɩga cɩga, yɩ a soe a nɔɔna. Nayɩr-ŋʋm sɛ tʋʋnɩ mʋ o peeni ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kʋ daarɩ, kʋ na yɩ wʋlʋ na tɔgɩ peeni sɩm o joŋi sǝbu tɩn, wʋntʋ daɩ nayɩrʋ wʋlʋ na yɩ peeni sɩm tu tɩn. Wʋntʋ na nɛ nywǝnkurǝ na maa bɩɩna, oó duri mʋ o daarɩ peeni sɩm. Nywǝnkurǝ kam wʋ́ zʋ peeni sɩm wʋ ka ja-sɩ ka pa sɩ jagɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Oó duri o viiri, bɛŋwaanɩ o tɔgɩ peeni sɩm sǝbu ŋwaanɩ mʋ, sɩ o ba jɩgɩ sɩ ŋwaŋa. ");
INSERT INTO xsm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Amʋ mʋ yɩ nayɩr-ŋʋm cɩga cɩga. Amʋ ye a nɔɔna bam, yɩ ba dɩ ye amʋ, ");
INSERT INTO xsm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nɩnɛɛnɩ amʋ Ko na ye-nɩ yɩ amʋ dɩ ye-o te tɩn. Amʋ wʋ́ sɛ sɩ a tɩ a nɔɔna bam ŋwaanɩ, nɩ nayɩr-ŋʋm na sɛ sɩ o tɩ o peeni ŋwaanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A daa ta jɩgɩ peeni sɩdaara, sɩ na tǝri najɩrɩ dɩntʋ wʋnɩ. A nan maŋɩ sɩ a vu a kalɩ-sɩ mʋ a ja ba a kɩ daanɩ. Peeni sɩntʋ dɩ wʋ́ ni amʋ kwǝrǝ. Kʋntʋ, a peeni sɩm maama wʋ́ la jǝgǝ dɩdʋa, yɩ nayɩrʋ dɩdʋa nii-sɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A Ko Wɛ soe amʋ, dɩ a na sɛ sɩ a tɩ nabiinǝ ŋwaanɩ, sɩ a joori a bi a na ŋwɩa tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nɔɔn-nɔɔnʋ nan bá wanɩ o pa a ga a ŋwɩa. Amʋ tɩtɩ nan mʋ lɩ wʋbʋŋa sɩ a ga-ka. A jɩgɩ cwǝŋǝ sɩ a ga a ŋwɩa kam. A nan ta jɩgɩ cwǝŋǝ sɩ a joori a bi a na-ka. Mʋ woŋo kʋlʋ a Ko na pɛ-nɩ ni sɩ a kɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zezi na tagɩ kʋntʋ o ti tɩn, kampwara daa ma ba Zwifǝ bam wʋ o taanɩ dɩm ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ba zanzan maa tɛ ba wɩ: «Cicirǝ mʋ jɩg-o, o yuu mʋ tǝrǝ. Bɛɛ mʋ yɩ á cǝgi o taanɩ?» ");
INSERT INTO xsm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kʋ daarɩ badaara maa tɛ ba wɩ: «Wʋlʋ yuu na tǝrǝ tɩn bá wanɩ o ŋɔɔnɩ tɩntʋ doŋ. Cicirǝ na jɩgɩ wʋlʋ tɩn bá wanɩ o puri lilwe yiǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kʋ dɛɛn ma ba kʋ yi sɩ Zwifǝ bam di ba candiǝ kalʋ yɩrɩ na yɩ Bakwebapawɛ tɩn Zeruzalɛm nɩ. Kʋ yɩ waarʋ mɩmaŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Zezi dɛɛn ma vu Wɛ-di-kamunu kʋm. O maa wʋ Salɔmɔn kʋnkɔlɔ kʋm nɩ o kaaga. ");
INSERT INTO xsm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Zwifǝ badaara laan ma ba ba gilim-o, yɩ ba bwe-o ba wɩ: «Nmʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn na? Bɛɛ mʋ yɩ n pa kʋ tiini kʋ yɩ wʋbʋŋa zanzan dɩ dɩbam? Ta cɩga n brɩ dɩbam sɩ dɩ́ kɔ joro.» ");
INSERT INTO xsm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","O ma lǝri-ba o wɩ: «A maŋɩ a ta a brɩ abam, yɩ á ba sɛ a ni. Tɩtʋŋa yalʋ a Ko Wɛ na pɛ a tʋŋɩ tɩn mʋ brɩ nɩ a jɩgɩ cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Abam nan ba sɛ a ni, bɛŋwaanɩ abam daɩ amʋ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","A nɔɔna bam nyɩ dɩ peeni sɩlʋ na cǝgi amʋ kwǝrǝ tɩn mʋ. A maa ye-sɩ, yɩ sɩ tɔgɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Amʋ paɩ a nɔɔna bam na ŋwɩa kalʋ na ba ti tɩn mʋ, yɩ ba bá fɔgɩ ba cɔgɩ maŋa dɩ maŋa. Nɔɔn-nɔɔnʋ bá wanɩ o vrɩ-ba amʋ jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kʋ yɩ a Ko Wɛ mʋ kwe-ba DƖ kɩ a jɩŋa nɩ. Dɩntʋ nan mʋ dwe woŋo maama. Nɔɔn-nɔɔnʋ bá wanɩ o vrɩ-ba DƖ jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Amʋ dɩ a Ko Wɛ yɩ bɩdwɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Zezi na tagɩ kʋntʋ tɩn, Zwifǝ bam daa ma kwe kandwa sɩ ba ma dʋl-o ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","O ma ta dɩ ba o wɩ: «Amʋ Ko pɛ a tʋŋɩ tɩtʋŋ-ŋʋna zanzan mʋ a brɩ abam. Tɩtʋŋa yantʋ wʋnɩ dɔɔ tɩtɩ mʋ pɛ abam kwaanɩ sɩ á gʋ amʋ dɩ kandwa?» ");
INSERT INTO xsm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ba ma lǝr-o ba wɩ: «Kʋ daɩ tɩtʋŋ-ŋʋm ŋwaanɩ mʋ dɩ́ lagɩ dɩ́ dʋlɩ-m dɩ́ gʋ. Kʋ yɩ nmʋ na twɩ Wɛ tɩn ŋwaanɩ mʋ. Nmʋ yɩ nabiinu mʋ, yɩ n paɩ n yɩ Wɛ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","O ma lǝri-ba o wɩ: «Wɛ cullu tɔnɔ kʋlʋ DƖ na pɛ abam tɩn wʋnɩ mʋ kʋ pʋpʋnɩ kʋ wɩ, Wɛ tagɩ dɩ nɔɔna badonnǝ DƖ wɩ: ‹Abam dɩdʋa dɩdʋa yɩ Wɛ nyɩnyʋgʋ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kʋ brɩ nɩ Wɛ dɛɛn pɛ DƖ kwǝrǝ nɔɔna bantʋ mʋ, yɩ DƖ bǝŋi-ba nɩ DƖ nyɩnyʋgʋ. Kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn bá wanɩ kʋ ji kafɛ. ");
INSERT INTO xsm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Amʋ nan yɩ wʋlʋ a Ko Wɛ na lɩ sɩ a kɩ DƖ wʋbʋŋa, yɩ DƖ tʋŋɩ-nɩ sɩ a ba lʋgʋ baŋa tɩn mʋ. Kʋntʋ, a na tagɩ nɩ a yɩ Wɛ Bu tɩn, bɛɛ mʋ yɩ á ba sɛa? Bɛɛ mʋ yɩ á brɩ nɩ a twɩ Wɛ mʋ? ");
INSERT INTO xsm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Maanɩ-na á nii a tɩtʋŋa yam na yɩ te tɩn. Kʋ na daɩ a Ko Wɛ tɩtʋŋa mʋ a tʋŋa, sɩ á yɩ sɛ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kʋ nan na yɩ Wɛ tɩtʋŋa, á na maŋɩ á ba sɛ amʋ, sɩ á sɛ tɩtʋŋa yam na brɩ te tɩn. Á na sɛ tɩtʋŋa yam kʋntʋ, á wʋ́ sɩɩnɩ á lwarɩ nɩ a Ko wʋra dɩ amʋ, yɩ amʋ dɩ wʋra dɩ a Ko.» ");
INSERT INTO xsm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","O na tagɩ kʋntʋ tɩn, ba daa maa lagɩ sɩ ba ja-o. O ma lu ba jɩa wʋnɩ o viiri. ");
INSERT INTO xsm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Zezi ma joori o vu o bɛ Zʋrdɛn bugǝ kam. O ma vu je sɩlʋ Zan dɛɛn na yǝni o miisi nɔɔna na wʋnɩ tɩn, o zʋʋrɩ da. ");
INSERT INTO xsm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nɔɔna zanzan dɛɛn maa tui o te. Ba maa yǝni ba tɛ ba wɩ: «Zan nan wʋ kɩ wo-kɩnkagɩla. Kʋ daarɩ o na tagɩ kʋlʋ maama Zezi ŋwaanɩ tɩn yɩ cɩga mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Je sɩm kʋntʋ nɩ nɔɔna zanzan ma kɩ ba wʋ-dɩdʋa dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Nɔɔnʋ wʋdoŋ dɛɛn zʋʋrɩ Betani nɩ, o yɩrɩ mʋ Lazaarɩ. O nakwa mʋ yɩ Mari dɩ o zɩmbaarʋ Marɩtɩ. Mari wʋntʋ mʋ yɩ wʋlʋ dɛɛn na kwe tralɩ nugǝ o lo dɩ́ Yuutu wʋm nɛ nɩ yɩ o daarɩ o ma o yuuywe o guguni-sɩ tɩn. Lazaarɩ ma ba o ba jɩgɩ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mari dɩdaanɩ Marɩtɩ ma tʋŋɩ ni ba pa Zezi ba wɩ: «Dɩbam Yuutu, nmʋ ciloŋ-sono kʋm ba jɩgɩ yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zezi na ni kʋntʋ tɩn, o maa wɩ: «Yawɩʋ kʋntʋ kweelim je bá ta yɩ o tʋʋnɩ. Kʋ nan kɩ sɩ kʋ pa Wɛ mʋ na zulǝ, sɩ amʋ Wɛ Bu wʋm dɩ na zulǝ kʋ ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zezi yagɩ o soe Marɩtɩ dɩ o nyaanɩ wʋm dɩ Lazaarɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","O na ni nɩ Lazaarɩ ba jɩgɩ yazurǝ tɩn, o ta ma kɩ da yale o ya na wʋ mɛ tɩn, ");
INSERT INTO xsm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","yɩ o laan daarɩ o ta dɩ o karabiǝ bam o wɩ: «Pa-na dɩ́ joori dɩ́ vu Zude.» ");
INSERT INTO xsm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","O karabiǝ bam ma ta dɩd-o ba wɩ: «Karanyɩna, Zwifǝ bam daama na lagɩ sɩ ba dʋlɩ nmʋ dɩ kandwa ba gʋ tɩn, n swe mʋ na? Yɩ n daa ta lagɩ sɩ n joori n vu da.» ");
INSERT INTO xsm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zezi ma lǝri-ba o wɩ: «Kʋ nan maŋɩ sɩ a vu mʋ. Luu fugǝ-bale mʋ wʋra wɩa nɩ. Kʋ daɩ kʋntʋ na? Nɔɔnʋ na ve wɩa nɩ, o daa ba tri o tʋɩ, bɛŋwaanɩ lʋgʋ baŋa pooni dɩm paɩ o naɩ. ");
INSERT INTO xsm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","O nan na ve tɩtɩɩ nɩ, o tri o tʋ mʋ, bɛŋwaanɩ pooni tǝri o tee nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zezi na tagɩ kʋntʋ tɩn, o daa ma ta o wǝli da o wɩ: «Dɩbam ciloŋ Lazaarɩ dɔ mʋ. A nan maa ve sɩ a pa o zaŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","O karabiǝ bam ma ta dɩd-o ba wɩ: «Dɩbam yuutu, o na dɔa, kʋʋ́ garɩ o yɩra nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Zezi nan na tagɩ te tɩn brɩ nɩ Lazaarɩ tɩgɩ mʋ. Bantʋ maa bʋŋɩ nɩ Zezi ŋɔɔnɩ dɔɔm tɩtɩ woŋo mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","O laan ma ta dɩ ba jaja o wɩ: «Lazaarɩ tɩgɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Amʋ nan jɩgɩ wʋpolo abam ŋwaanɩ dɩ a na tǝri o tee nɩ tɩn. Kʋʋ́ pa á wanɩ á kɩ á wʋ-dɩdʋa dɩ amʋ. Nan pa-na dɩ́ vu o te.» ");
INSERT INTO xsm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma wʋlʋ ba na bǝ nɩ Yiywɛ tɩn ma ta dɩ o donnǝ bam o wɩ: «Pa-na dɩ́ maama tɔgɩ dɩ́ vu dɩ́ wǝli dɩ dɩ́ Yuutu dɩ́ tɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zezi ma vu o yi Betani dɩ ba kwe Lazaarɩ ba kɩ kʋ jɩgɩ da yana mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani batwarɩ dɩ Zeruzalɛm nɩnɛɛnɩ kilomɛtra yale mʋ te. ");
INSERT INTO xsm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Zwifǝ zanzan dɛɛn ya tu sɩ ba kɩ Marɩtɩ dɩ Mari le dɩ ba nabɔ wʋm tʋʋnɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marɩtɩ na ni nɩ Zezi maa bɩɩnɩ tɩn, o ma nuŋi o vu sɩ o jeer-o. Mari ma maŋɩ sɔŋɔ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marɩtɩ na yi Zezi te tɩn, o ma ta o wɩ: «A yuutu, nmʋ ya na wʋ yo, a nabɔ wʋm ya bá tɩ. ");
INSERT INTO xsm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dɩ kʋ dɩ, a ye nɩ nmʋ na loori kʋlʋ maama Wɛ tee nɩ tɩn, DƖ wʋ́ kɩ DƖ pa nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zezi ma ta dɩd-o o wɩ: «N nabɔ wʋm wʋ́ joori o bi.» ");
INSERT INTO xsm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marɩtɩ ma lǝr-o o wɩ: «A ye nɩ oó joori o bi lʋgʋ tiim dɛ dɩm nɩ, Wɛ na wʋ́ pa twa joori ba bi ba yagɩ tʋʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Zezi ma ta dɩd-o o wɩ: «Amʋ mʋ yɩ twa biinu dɩ ŋwɩa tu. Wʋlʋ na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn, o na maŋɩ o tɩ dɩ, kʋntʋ tu ta wʋ́ na ŋwɩa. ");
INSERT INTO xsm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kʋlʋ na wǝli da tɩn, wʋlʋ maama na ŋwɩ yɩ o kɩ o wʋ-dɩdʋa dɩ amʋ tɩn, tʋʋnɩ daa bá ja kʋntʋ tu maŋa dɩ maŋa. Nmʋ sɛ kʋntʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","O ma lǝr-o o wɩ: «Ɛɛn. A yuutu, a sɛ nɩ nmʋ mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, yɩ n kwǝri n yɩ Wɛ Bu wʋlʋ na maŋɩ sɩ o ba lʋgʋ baŋa tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marɩtɩ na tagɩ kʋntʋ o ti tɩn, o ma joori o vu o na Mari o yɩranɩ, yɩ o bǝŋ-o o wɩ: «Karanyɩna tuǝ, yɩ o lagɩ sɩ o na-m.» ");
INSERT INTO xsm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari na ni kʋntʋ tɩn, o ma zaŋɩ lɩla o nuŋi o vu sɩ o jeer-o. ");
INSERT INTO xsm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Zezi daa ta wʋ jǝgǝ kalʋ Marɩtɩ na jeer-o da tɩn mʋ. O ta wʋ yi tɩʋ kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zwifǝ balʋ na wʋ sɔŋɔ kʋm nɩ ba larɩ dɩ Mari sɩ kʋ ganɩ o wʋ tɩn ma na o na zaŋɩ lɩla o nuŋi. Ba ma zaŋɩ ba tɔg-o, yɩ ba bʋŋɩ nɩ o ga lagɩ o vu yibeeli dɩm jǝgǝ mʋ o keeri. ");
INSERT INTO xsm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari na ve o yi Zezi na wʋ mɛ tɩn, o ma na-o yɩ o vu o kuni doonǝ o yigǝ nɩ o wɩ: «A yuutu, nmʋ ya na wʋ yo, a nabɔ wʋm ya bá tɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zezi ma na o na keerǝ, yɩ Zwifǝ balʋ na tɔgɩ dɩd-o ba ba tɩn dɩ keerǝ. O wʋ ma cɔgɩ, yɩ o yɩra sɔɔrɩ. ");
INSERT INTO xsm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O ma bwe-ba o wɩ: «Abam kɩ-o yǝn mʋ?» Ba ma lǝri ba wɩ: «Dɩbam yuutu, ba n nii o yibeeli dɩm.» ");
INSERT INTO xsm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Zezi ma kan yi-na. ");
INSERT INTO xsm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Zwifǝ bam na nɛ kʋntʋ tɩn, ba ma ta ba wɩ: «Nii o na tiini o so-o te.» ");
INSERT INTO xsm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kʋ daarɩ badaara maa tɛ ba wɩ: «Wʋntʋ mʋ puri lilwe wʋm yiǝ yam. Kʋ nan kɩ ta mʋ yɩ o wʋ cɩgɩ Lazaarɩ tʋʋnɩ dɩm?» ");
INSERT INTO xsm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zezi na maa ve yibeeli dɩm jǝgǝ tɩn, o wʋ daa ma cɔgɩ zanzan. Yibeeli dɩm dɛɛn wʋ piu yɩra nɩ mʋ, yɩ ba ma kandwɛ ba pɩ dɩ ni. ");
INSERT INTO xsm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zezi ma ta o wɩ: «Lɩ-na kandwɛ dɩm á yagɩ daa nɩ.» Tʋ wʋm nakɔ Marɩtɩ ma lǝri o wɩ: «A yuutu, ba na kwe-o ba kɩ tɩn, kʋ jɩgɩ da yana mʋ zɩm. Kʋntʋ tɩn, oó ta tiini o lwe.» ");
INSERT INTO xsm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Zezi ma ta dɩd-o o wɩ: «A maŋɩ a ta dɩ nmʋ nɩ, nmʋ na kɩ n wʋ-dɩdʋa dɩ amʋ, nmʋ wʋ́ na Wɛ na jɩgɩ dam te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ba ma lɩ kandwɛ dɩm ba yagɩ daa nɩ. Zezi ma kwǝni o yuu wɛɛnɩ, yɩ o ta o wɩ: «Amʋ Ko, dɩnle dɩ nmʋ na cǝgi a taanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A maŋɩ a ye nɩ nmʋ yǝni n cǝgi a taanɩ maŋa maama. A nan tagɩ kʋntʋ nɔn-kɔgɔ kʋlʋ na zɩgɩ yo tɩn ŋwaanɩ mʋ, sɩ kʋ pa ba sɛ nɩ nmʋ tʋŋɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","O na tagɩ kʋntʋ o ti tɩn, o ma bǝŋi dɩ kwǝr-dɩa o wɩ: «Lazaarɩ, zaŋɩ n nuŋi!» ");
INSERT INTO xsm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tʋ wʋm ma zaŋɩ o nuŋi, dɩ garyiǝ yam ba ya mɛ ba ba o jɩa dɩ o nɛ, yɩ gɔrɔ dɩ kɩkarɩ o yibiyǝ. Zezi ma ta dɩ ba o wɩ: «Bwǝli-na garyiǝ yam á yagɩ sɩ o vu.» ");
INSERT INTO xsm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zwifǝ balʋ ya na tu Mari te tɩn ma na Zezi na bi Lazaarɩ te tɩn. Ba zanzan ma kɩ ba wʋ-dɩdʋa dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kʋ daarɩ ba badaara ma joori ba vu Farizɩan tiinǝ bam te, yɩ ba ta dɩ ba Zezi na kɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wɛ kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam laan ma la sarɩya-dirǝ nakwa bam maama ba kɩ daanɩ, yɩ ba bwɛ ba wɩ: «Nii-na nɔɔnʋ wʋntʋ na kɩ wo-kɩnkagɩla yalʋ maama tɩn. Dɩbam nan wʋ́ kɩ-o ta mʋ? ");
INSERT INTO xsm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dɩ́ na yag-o sɩ o taa kɩ kʋntʋ, nɔɔna bam maama wʋ́ ba ba sɛ wʋm mʋ. Kʋntʋ wʋ́ pa Rom dɩdɛɛra bam laan ba ba cɔgɩ dɩ́ Wɛ-di-kamunu kʋm dɩ dɩ́ tɩʋ kʋm maama.» ");
INSERT INTO xsm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Balʋ na bwɛ daanɩ kʋntʋ tɩn, ba wʋ nɔɔnʋ dɩdʋa yɩrɩ mʋ Kayifu. Wʋntʋ mʋ yɩ ba Wɛ kaanɩm yuutu bɩnɩ dɩm kʋntʋ wʋnɩ. O ma ta dɩ ba o wɩ: «Abam yǝri kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Á fɔgɩ á bʋŋɩ á nii, nɔɔnʋ dɩdʋa na tɩga dɩbam nɔɔna bam maama ŋwaanɩ, kʋʋ́ ta lana kʋ pa dɩbam kʋ garɩ dɩ́ tɩʋ kʋm maama na cɔgɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayifu na tagɩ kʋntʋ tɩn, kʋ daɩ o tɩtɩ wʋbʋŋa mʋ o mɛ o ta. O nan na yɩ Wɛ kaanɩm yuutu tɩn, mʋ Wɛ pɛ o wuuri o ta nɩ, Zezi lagɩ o tɩ Zwifǝ dwi dɩm maama ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kʋ nan daɩ nɩ o lagɩ o tɩ bantʋ dwi dɩm má ŋwaanɩ mʋ. Kʋ yɩ Wɛ biǝ bam na jagɩ je maama tɩn dɩ ŋwaanɩ mʋ, sɩ o wanɩ o kɩ-ba daanɩ sɩ ba taa yɩ dwi dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kʋ na zɩgɩ dɛ dɩm kʋntʋ nɩ tɩn, Zwifǝ yigǝ tiinǝ bam ma kɩ ni daanɩ sɩ ba gʋ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kʋntʋ ma pa Zezi daa ba beeri jaja Zude nɩ sɩ nɔɔna taa na-o. O ma yagɩ dáanɩ, yɩ o vu je sɩlʋ na batwarɩ dɩ kagʋa ni tɩn. Kʋ yɩ Efrayim nɩ mʋ o ve o zʋʋrɩ da dɩ o karabiǝ bam. ");
INSERT INTO xsm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zwifǝ bam candiǝ kalʋ yɩrɩ na yɩ Pakɩ tɩn dɛɛn ma daarɩ fɩɩn sɩ ka yi. Nɔɔna zanzan ma zaŋɩ tɩʋ kʋm je maama nɩ, ba vu Zeruzalɛm sɩ ba kwɛ ba tɩtɩ dɩ Wɛ, sɩ kʋ loori candiǝ kam. ");
INSERT INTO xsm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nɔɔna bam ma beeri Zezi je. Ba ma la daanɩ Wɛ-di-kamunu kʋm nɩ, yɩ ba bwe daanɩ ba wɩ: «Abam bʋŋɩ nɩ, o bá ba o di candiǝ kam na?» ");
INSERT INTO xsm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wɛ kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam dɛɛn ya pɛ ni nɩ, nɔɔnʋ wʋlʋ na ye Zezi na wʋ mɛ tɩn, sɩ o brɩ-ba, sɩ ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Da yardʋ dɛɛn na daarɩ sɩ kʋ yi Pakɩ candiǝ kam tɩn, Zezi ma vu o yi Betani. Kʋ yɩ dáanɩ mʋ Lazaarɩ zʋʋrɩ da. Wʋntʋ mʋ yɩ nɔɔnʋ wʋlʋ Zezi na pɛ o bi o yagɩ tʋʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ba ma kɩ wʋdiu ba pa-o jǝgǝ kam kʋntʋ nɩ. Marɩtɩ maa wʋra o maŋɩ wʋdiu kʋm. Lazaarɩ ma tɔgɩ o jǝni sɩ o di dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari laan ma kwe tralɩ nugǝ kalʋ yɩrɩ na yɩ naadɩ tɩn. Ka dɛɛn yɩ kunkwǝlǝ yi mʋ, yɩ ka tiini ka lana. Nugǝ kam kʋntʋ yǝlo cana zanzan. O ma kwe-ka o ma turi Zezi nɛ. O ma daarɩ o ma o yuuywe o guguni o nɛ sɩm. Tralɩ nugǝ kam lwǝm dɩm ma zaŋɩ sɔŋɔ kʋm maama wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Zezi karabiǝ bam dɩdʋa wʋlʋ yɩrɩ na yɩ Zudasɩ Yiskarɩyo tɩn dɩ tɔgɩ o wʋra. Wʋntʋ mʋ yɩ wʋlʋ na wʋ́ ba o yǝgi Zezi o pa nɔɔna tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","O na nɛ Mari na kɩ te tɩn, o ma ta o wɩ: «Bɛɛ mʋ yɩ o kɩ kʋntʋ? Dɩ́ ya waɩ dɩ́ kwe tralɩ nugǝ kam dɩ́ yǝgi, yɩ dɩ́ cɛ dɩ́ pa yinigǝ tiinǝ. Ka sǝbu kʋm ya wʋ́ yi sǝbu-dala biǝ-yatɔ (300).» ");
INSERT INTO xsm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O na tagɩ kʋntʋ tɩn, kʋ daɩ nɩ o jɩgɩ yinigǝ tiinǝ bam ŋwaŋa mʋ. O yɩ ŋwɩɩnʋ mʋ. Wʋntʋ mʋ nii ba kɔgɔ kʋm sǝbu kʋm baŋa nɩ, yɩ o yǝni o ŋɔnɩ-kʋ o lɩa. ");
INSERT INTO xsm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Zezi laan ma lǝri o wɩ: «Yagɩ o yɩra, sɩ o kɩ kʋntʋ a na wʋ́ tɩ yɩ ba kɩ-nɩ tɩn ŋwaanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kʋ nan na yɩ yinigǝ tiinǝ, bantʋ ta wʋra mʋ dɩ abam maŋa maama. Kʋ daarɩ amʋ nan bá ta wʋra dɩ abam maŋa maama.» ");
INSERT INTO xsm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zwifǝ kɔgɔ zanzan ma lwarɩ nɩ Zezi wʋ Betani nɩ. Ba ma zaŋɩ ba vu da. Ba na ve tɩn, kʋ daɩ Zezi yɩranɩ ŋwaanɩ, kʋ yɩ sɩ ba dɩ na Lazaarɩ wʋlʋ Zezi na pɛ o bi o yagɩ tʋʋnɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wɛ kaanɩm yigǝ tiinǝ bam laan ma kɩ ni daanɩ sɩ ba gʋ Lazaarɩ dɩ, ");
INSERT INTO xsm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bɛŋwaanɩ Lazaarɩ biim dɩm mʋ te Zwifǝ zanzan joori ba yigǝ tiinǝ bam kwaga nɩ, yɩ ba daarɩ ba sɛ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tɩga na pʋʋrɩ tɩn, nɔn-kɔgɔ kʋlʋ na tu Zeruzalɛm sɩ ba di candiǝ kam tɩn ma lwarɩ nɩ Zezi maa bɩɩna. ");
INSERT INTO xsm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ba ma vu ba kaarɩ kʋrʋ-vɔɔrʋ, yɩ ba nuŋi ba maa ve sɩ ba jeer-o. Ba na maa ve tɩn, ba maa zul-o ba wɩ: «Ozaana! Zuli-na wʋlʋ na tu dɩ́ Yuutu Baŋa-Wɛ yɩrɩ ŋwaanɩ tɩn. Wʋntʋ mʋ yɩ Yisɩrayɛlɩ dwi tiinǝ pɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zezi ma na bɩna-pɔla o di, nɩ Wɛ tɔnɔ kʋm na maŋɩ kʋ ta te tɩn. Kʋ pʋpʋnɩ kʋ wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Abam balʋ na zʋʋrɩ Siyɔn tɩʋ kʋm nɩ tɩn, á yɩ taá kwarɩ fʋʋnɩ. Nii-na á pɛ wʋm, o diini bɩna-pɔla o maa bɩɩna.» ");
INSERT INTO xsm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Maŋa kam kʋntʋ nɩ, Zezi karabiǝ bam ya ma wʋ lwarɩ wǝǝnu tɩm kʋntʋ kuri. Kʋ daarɩ maŋa kam Zezi na tɩgɩ yɩ o bi o yagɩ tʋʋnɩ o na paarɩ-zulǝ Wɛ tee nɩ tɩn, mʋ ba laan guli Wɛ tɔnɔ kʋm na tagɩ o taanɩ te tɩn, dɩ nɔn-kɔgɔ kʋm na kɩ kʋlʋ ba zul-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nɔɔna balʋ dɛɛn na wʋ Zezi tee nɩ yɩ o pa Lazaarɩ bi o yagɩ tʋʋnɩ tɩn ya maŋɩ ba ta ba brɩ tɩʋ kʋm nɔɔna bam, o na kɩ te o bǝŋi Lazaarɩ yɩ o nuŋi yibeeli dɩm wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kʋ yɩ kʋntʋ ŋwaanɩ mʋ nɔn-kɔgɔ kʋm nuŋi tɩʋ kʋm nɩ ba jeer-o, ba na ni nɩ o kɩ wo-kɩnkagɩlɩ dɩm kʋntʋ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farizɩan tiinǝ bam laan maa tɛ daanɩ ba wɩ: «Á wʋ nɛ? Dɩbam brɩ dɩ́ bá wanɩ kʋlʋkʋlʋ dɩ́ kɩ. Nii-na lʋgʋ kʋm nɔɔna bam maama mʋ tɔgɩ o kwaga.» ");
INSERT INTO xsm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grɛkɩ tiinǝ balʋ dɛɛn na tɔgɩ ba vu Zeruzalɛm sɩ ba di candiǝ kam ba zuli Wɛ tɩn badaara ma vu Filipi te. ");
INSERT INTO xsm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wʋntʋ nuŋi Galile tɩʋ kʋlʋ yɩrɩ na yɩ Betisayida tɩn mʋ. Ba ma ta dɩd-o ba wɩ: «Dɩbam lagɩ sɩ dɩ́ na Zezi mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi ma vu o ta dɩ Andre. Bantʋ bale ma vu ba ta ba brɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Zezi ma ta dɩ ba o wɩ: «Maŋa kam laan yiǝ, sɩ Wɛ pa Nabiin-bu wʋm na paarɩ-zulǝ. ");
INSERT INTO xsm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nmʋ na jɩgɩ mɩn-dwi, yɩ n na dugi-dɩ tɩga nɩ, dɩ wʋ́ nuŋi dɩ kɩ biǝ zanzan mʋ. Nmʋ nan na wʋ sɛ sɩ n du-dɩ tɩga nɩ sɩ dɩ puli dɩ nuŋi dɩ daarɩ sɩ mɩn-bu wʋm pɔ, dɩ wʋ́ ta yɩ dɩdwɩ yɩranɩ mʋ taan, n bá na nyɔɔrɩ dɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wʋlʋ na soe o tɩtɩ ŋwɩa tɩn, kʋntʋ tu bá na ŋwɩa Wɛ tee nɩ. Wʋlʋ nan na vɩn o ŋwɩa lʋgʋ kʋntʋ baŋa nɩ tɩn, kʋ tu wʋ́ na ŋwɩa kalʋ na ba ti tɩn Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wʋlʋ maama na lagɩ sɩ o tʋŋɩ amʋ tɩtʋŋa tɩn, kʋntʋ tu maŋɩ sɩ o tɔgɩ a kwaga mʋ. Kʋntʋ, a na wʋ mɛ tɩn, a tɩntʋŋnʋ wʋm dɩ wʋ́ ta tɔgɩ o wʋra. Wʋlʋ maama na tʋŋɩ amʋ tɩtʋŋa tɩn, amʋ Ko wʋ́ pa o na zulǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zezi ma ta o wɩ: «A wʋ mʋ cɔgɩ zanzan. A nan wʋ́ ta nɩ bɛɛ mʋ? Aá loori a Ko mʋ sɩ o vrɩ-nɩ yaara yantʋ wʋnɩ na? Awo. Kʋ yɩ kʋntʋ ŋwaanɩ mʋ amʋ maŋɩ a ba sɩ a yaarɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A nan wʋ́ loori a Ko sɩ o pa o yɩrɩ na zulǝ.» Kwǝrǝ laan ma ŋɔɔnɩ wɛyuu nɩ ka wɩ: «A maŋɩ a pa a yɩrɩ na zulǝ, a nan ta wʋ́ pa dɩ na zulǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nɔn-kɔgɔ kʋlʋ na zɩgɩ da tɩn ma ni kwǝrǝ kam, yɩ ba ta ba wɩ, dʋa mʋ mumunǝ. Badaara maa wɩ, kʋ yɩ malɛka mʋ ŋɔɔnɩ dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Zezi ma ta dɩ ba o wɩ: «Kʋ daɩ amʋ ŋwaanɩ mʋ kwǝrǝ kantʋ ŋɔɔnɩ, kʋ yɩ abam ŋwaanɩ mʋ ka ŋɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maŋa laan yiǝ sɩ Wɛ di nabiinǝ taanɩ, sɩ DƖ zǝli lʋgʋ baŋa pɛ wʋm. ");
INSERT INTO xsm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kʋ daarɩ kʋ na yɩ amʋ, maŋa kalʋ ba na wʋ́ zǝŋi amʋ wɛɛnɩ tɩn, amʋ wʋ́ pa nabiinǝ maama ba amʋ te.» ");
INSERT INTO xsm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O na tagɩ kʋntʋ tɩn, o brɩ o na lagɩ o tɩ tʋʋnɩ dwi dɩlʋ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nɔn-kɔgɔ kʋm ma lǝr-o kʋ wɩ: «Dɩbam ni nɩ kʋ pʋpʋnɩ Wɛ cullu tɔnɔ wʋnɩ kʋ wɩ, Krisi wʋm Wɛ na tʋŋɩ tɩn maŋɩ sɩ o taa ŋwɩ mʋ maŋa maama. Bɛɛ nan mʋ yɩ n ta n wɩ, ba maŋɩ sɩ ba zǝŋi Nabiin-bu wʋm wɛɛnɩ? Nabiin-bu wʋntʋ nan yɩ wɔɔ?» ");
INSERT INTO xsm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Zezi ma lǝri-ba o wɩ: «Pooni bá tiini dɩ daanɩ abam tee nɩ. Pooni dɩm ta na wʋ á tee nɩ maŋa kalʋ tɩn, sɩ á taá veǝ, sɩ lim yɩ ba dɩ yi abam. Wʋlʋ na ve lim wʋnɩ tɩn yǝri o na ve mɛ. ");
INSERT INTO xsm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pooni dɩm ta na wʋ á tee nɩ tɩn, á nan sɛ wʋlʋ na yɩ pooni dɩm tɩn, sɩ á daarɩ á taá yɩ pooni dɩm biǝ.» Zezi na tagɩ kʋntʋ o ti tɩn, o ma nuŋi ba tɩtarɩ nɩ o vu o sǝgi. ");
INSERT INTO xsm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dɩ o na maŋɩ o kɩ wo-kɩnkagɩla zanzan ba yibiyǝ nɩ tɩn, ba daa ta wʋ sɛ-o. ");
INSERT INTO xsm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kʋntʋ ma pa kʋlʋ Wɛ nijoŋnu Ezayi dɛɛn na tagɩ tɩn sɩɩnɩ kʋ kɩ. O dɛɛn tagɩ faŋa faŋa o wɩ: «Yuutu Baŋa-Wɛ, nɔɔn-nɔɔnʋ wʋ sɛ dɩ́ na tagɩ taanɩ dɩlʋ dɩ́ brɩ-ba tɩn. Nɔɔn-nɔɔnʋ nan wʋ lwarɩ dɩ́ Yuutu wʋm dam dɩm na yɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ba wʋ wanɩ ba sɛ Zezi taanɩ dɩm, bɛŋwaanɩ Ezayi ta tagɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Dɩntʋ mʋ dwe ba yiǝ, yɩ DƖ pa ba wʋbʋŋa tɩ, sɩ ba yiǝ yam yɩ wanɩ ya taa naɩ, sɩ ba wʋbʋŋa yam dɩ yɩ wanɩ ya lwarɩ Wɛ taanɩ dɩm kuri, sɩ ba yɩ lǝni ba wʋbʋŋa ba sɛ Wɛ sɩ DƖ pa ba na yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezayi dɛɛn tagɩ dɩ́ Yuutu wʋm taanɩ kʋntʋ, bɛŋwaanɩ o wuuri o na Zezi paarɩ-zulǝ na yɩ te yɩ o daa ta wʋ tu lʋgʋ baŋa. ");
INSERT INTO xsm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dɩ kʋntʋ dɩ, Zwifǝ yigǝ tiinǝ zanzan dɩ ta kɩ ba wʋ-dɩdʋa dɩ Zezi. Ba na kwarɩ Farizɩan tiinǝ bam tɩn ŋwaanɩ mʋ, ba wʋ ŋɔɔnɩ-kʋ jaja, sɩ baá zǝli-ba ba Wɛ-digǝ kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ba na kɩ te tɩn brɩ nɩ ba soe sɩ nabiinǝ wʋrʋ poli dɩ ba kʋ dwe Wɛ wʋ na poli dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Zezi ma ta dɩ kwǝr-dɩa o wɩ: «Wʋlʋ na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn, kʋ daɩ nɩ o sɛ amʋ yɩranɩ mʋ, kʋ yɩ wʋlʋ na tʋŋɩ-nɩ tɩn mʋ o sɛ. ");
INSERT INTO xsm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wʋlʋ na nɛ amʋ tɩn nɛ wʋlʋ na tʋŋɩ-nɩ tɩn dɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Amʋ tu lʋgʋ baŋa sɩ a taa yɩ pooni mʋ a paɩ nabiinǝ, sɩ wʋlʋ maama na sɛ amʋ tɩn daa yɩ maŋɩ lim wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wʋlʋ na ni a taanɩ dɩm yɩ o wʋ sɛ sɩ o kɩ kʋlʋ a na tagɩ tɩn, kʋ daɩ amʋ mʋ cɔgɩ kʋntʋ tu, bɛŋwaanɩ amʋ na tu lʋgʋ baŋa tɩn, kʋ daɩ sɩ a di nabiinǝ taanɩ sɩ a cɔgɩ-ba. Kʋ nan yɩ sɩ a vrɩ-ba ba lwarɩm wʋnɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wʋlʋ na vɩn amʋ yɩ o wʋ sɛ a taanɩ dɩm tɩn, mʋ kʋlʋ na wʋ́ cɔg-o: Taanɩ dɩlʋ amʋ na ŋɔɔnɩ a brɩ nɔɔna tɩn mʋ wʋ́ zaŋɩ lʋgʋ tiim dɛ dɩm nɩ dɩ brɩ nɩ kʋntʋ tu ba jɩgɩ bʋra. ");
INSERT INTO xsm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kʋ nan daɩ a tɩtɩ wʋbʋŋa mʋ a ŋɔɔna. Kʋ yɩ a Ko wʋlʋ na tʋŋɩ-nɩ tɩn mʋ pɛ-nɩ ni sɩ a ta kʋlʋ DƖ wʋbʋŋa na lagɩ tɩn, yɩ DƖ ta brɩ-nɩ kʋlʋ a na wʋ́ ŋɔɔnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Amʋ nan ye sɩ balʋ na sɛ ni dɩlʋ a Ko Wɛ na pɛ-nɩ sɩ a ŋɔɔnɩ tɩn wʋ́ na ŋwɩa kalʋ na ba ti tɩn. A na yǝni a ŋɔɔnɩ te maama tɩn, kʋ yɩ a Ko Wɛ na tagɩ kʋlʋ o brɩ-nɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dɛ dɩdwɩ na daarɩ sɩ ba di Pakɩ candiǝ kam tɩn, Zezi dɛɛn maa ye nɩ o maŋa kam yiǝ, sɩ o yagɩ lʋgʋ baŋa sɩ o daarɩ o vu o Ko te. O maa soe balʋ na yɩ o nɔɔna lʋgʋ baŋa nɩ tɩn, yɩ o tiini o so-ba kʋ ja gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zezi dɩ o karabiǝ bam maa je ba di wʋdiu tɩtɩɩ nɩ, dɩ sʋtaanɩ ya maŋɩ dɩ pa Zudasɩ Yiskarɩyo wʋlʋ na yɩ Simɔn bu tɩn lɩ wʋbʋŋa sɩ o yǝgi Zezi o pa nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zezi maa ye nɩ o Ko Wɛ mʋ pɛ-o dam woŋo maama baŋa nɩ, yɩ o ye nɩ o nuŋi Wɛ te mʋ, o nan ta wʋ́ joori o vu Wɛ te. ");
INSERT INTO xsm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ba na wʋra ba di tɩn, o ma zaŋɩ da. O lɩ o na zʋ gɔrɔ kʋlʋ o daŋɩ tɩn, yɩ o daarɩ o vɔ pʋpaa o tǝŋǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","O ma kɩ na o kɩ kacuǝ wʋnɩ o wʋra o maa zarɩ o karabiǝ bam nɛ, yɩ o ma pʋpaa kʋm o ma guguni-sɩ. ");
INSERT INTO xsm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","O ma ba o yi Simɔn Pɩyɛɛrɩ te. Wʋntʋ ma ta dɩd-o o wɩ: «A yuutu, nmʋ mʋ wʋ́ zarɩ amʋ nɛ na?» ");
INSERT INTO xsm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zezi ma lǝr-o o wɩ: «Nmʋ bá lwarɩ amʋ na wʋra a kɩ kʋlʋ tɩn kuri lele, n nan wʋ́ ba n lwarɩ kʋ kuri.» ");
INSERT INTO xsm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pɩyɛɛrɩ ma ta o wɩ: «N brɩ n bá zarɩ a nɛ maŋa dɩ maŋa.» Zezi ma lǝr-o o wɩ: «A na wʋ zarɩ n nɛ sɩm, n bá n wanɩ n ta n yɩ amʋ nɔɔnʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simɔn Pɩyɛɛrɩ ma ta dɩd-o o wɩ: «Kʋ na yɩ kʋntʋ, a yuutu, yɩ zarɩ a nɛ yɩranɩ, zarɩ a jɩa dɩ a yuu dɩ n wǝli da.» ");
INSERT INTO xsm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Zezi laan ma ta dɩd-o o wɩ: «Wʋlʋ na swɛ o yɩra tɩn daa ba jɩgɩ digiru, yɩ o daa wʋ maŋɩ sɩ o swɛ o yɩra, kʋ na daɩ o nɛ yɩranɩ. Abam ba jɩgɩ digiru, kʋ nan daɩ á maama.» ");
INSERT INTO xsm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bɛŋwaanɩ Zezi maŋɩ o ye wʋlʋ na lagɩ o yǝg-o o pa nɔɔna tɩn. Mʋ kʋ kuri o tagɩ o wɩ, kʋ daɩ ba maama mʋ ba jɩgɩ digiru tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Zezi na zarɩ ba nɛ sɩm o ti tɩn, o ma joori o zʋ o gɔrɔ kʋm, yɩ o vu o jǝni o jǝŋǝ je nɩ. O laan ma bwe-ba o wɩ: «Abam lwarɩ kʋlʋ amʋ na kɩ dɩ abam tɩn kuri na? ");
INSERT INTO xsm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Abam yǝni á bǝ amʋ nɩ, Karanyɩna naa á Yuutu mʋ. Abam na bǝ te tɩn kʋ maŋɩ, bɛŋwaanɩ amʋ sɩɩnɩ a yɩ kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Amʋ nan na yɩ abam Yuutu dɩ á Karanyɩna yɩ a zarɩ abam nɛ tɩn, kʋ maŋɩ sɩ abam dɩ laan zuli daanɩ kʋntʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Amʋ nan kɩ a brɩ abam, sɩ á lwǝni amʋ na kɩ abam te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A lagɩ a ta cɩga mʋ dɩ abam sɩ, gambaa tǝrǝ ka na dwe ka tu. Tɩntʋŋnʋ nan tǝrǝ o na dwe wʋlʋ na tʋŋ-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Abam na lwarɩ tɩn, á na kɩ kʋntʋ, á wʋ́ taá jɩgɩ yu-yoŋo. ");
INSERT INTO xsm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kʋ nan daɩ abam maama taanɩ mʋ a tɛa. A ye balʋ a na kuri tɩn. Kʋ daarɩ kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn maŋɩ sɩ kʋ kɩ mʋ. Kʋ tagɩ kʋ wɩ: ‹Wʋlʋ na jǝni o di wʋdiu dɩ amʋ tɩn mʋ joori o zɩgɩ amʋ zɩga.› ");
INSERT INTO xsm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A nan wuuri a ta a brɩ abam mʋ yɩ kʋ ta wʋ kɩ, sɩ kʋ na tu kʋ kɩ, sɩ á wanɩ á sɛ nɩ amʋ yɩ wʋlʋ na wʋra maŋa maama tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A lagɩ a ta cɩga mʋ dɩ abam sɩ, nɔɔnʋ na jeeri wʋlʋ maama a na tʋŋɩ tɩn, kʋntʋ tu jeeri amʋ mʋ. Kʋ daarɩ, wʋlʋ na jeeri amʋ tɩn, o jeeri wʋlʋ na tʋŋɩ-nɩ tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zezi na tagɩ kʋntʋ o ti tɩn, o wʋ ma tiini kʋ cɔgɩ kʋ pa o ŋɔɔnɩ jaja o wɩ: «A lagɩ a ta cɩga mʋ dɩ abam sɩ, abam dɩdʋa mʋ lagɩ o yǝgi amʋ o pa nɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","O na tagɩ kʋntʋ tɩn, o karabiǝ bam maa nii daanɩ, yɩ ba brɩ ba yǝri wʋlʋ tɩtɩ o na tɛ bantʋ wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wʋlʋ Zezi na soe lanyɩranɩ ba wʋnɩ tɩn maa je o tɩkǝri nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔn Pɩyɛɛrɩ ma yɩgɩsɩ o jɩŋa o brɩ wʋntʋ, sɩ o bwe Zezi o nii, kʋ yɩ wɔɔ taanɩ mʋ o tɛa. ");
INSERT INTO xsm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nɔɔnʋ wʋm ma fɔɔrɩ o yi Zezi o sal-o, yɩ o bwe o wɩ: «A Yuutu, kʋ yɩ wɔɔ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Zezi ma lǝri o wɩ: «Amʋ na fɔgɩ dɩpɛ a lu dwǝ wʋnɩ a pa wʋlʋ tɩn, mʋ kʋ tu.» O laan ma fɔ dɩpɛ dɩm o ma lu o pa Zudasɩ Yiskarɩyo wʋlʋ na yɩ Simɔn bu tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zudasɩ na joŋi dɩpɛ dɩm kʋntʋ tɩn, sʋtaanɩ ma zʋ o bɩcarɩ. Zezi ma ta dɩd-o o wɩ: «Kɩ lɩla sɩ n kɩ kʋlʋ nmʋ na lagɩ n kɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Balʋ maama na je ba di tɩn wʋlʋwʋlʋ ma wʋ lwarɩ Zezi na tagɩ kʋlʋ dɩd-o tɩn kuri. ");
INSERT INTO xsm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zudasɩ nan na nii ba kɔgɔ kʋm sǝbu kʋm baŋa nɩ tɩn, ba badaara maa bʋŋɩ nɩ Zezi tʋŋ-o sɩ o vu o yǝgi wʋdiu mʋ sɩ ba ma di candiǝ kam, naa o ga tʋŋ-o sɩ o vu o pa yinigǝ tiinǝ wǝǝnu mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zudasɩ na joŋi dɩpɛ dɩm tɩn, o ma da o zaŋɩ o nuŋi. Kʋ dɛɛn yɩ tɩtɩɩ nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zudasɩ na nuŋi o daarɩ kʋntʋ tɩn, Zezi ma ta o wɩ: «Lele kʋntʋ amʋ Nabiin-bu wʋm wʋ́ na paarɩ-zulǝ, yɩ Wɛ tɩtɩ wʋ́ na zulǝ amʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wɛ na nɛ zulǝ amʋ ŋwaanɩ tɩn, DƖ laan wʋ́ pa a na paarɩ-zulǝ DƖ tɩtɩ tee nɩ. Wɛ nan wʋ́ pa a na zulǝ lele kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A biǝ-ba, a daa bá tiini a daanɩ abam tee nɩ. Abam nan wʋ́ ba á beeri amʋ jǝgǝ. A nan lagɩ a ta a brɩ abam kʋlʋ a na maŋɩ a ta a brɩ Zwifǝ bam a wɩ, amʋ na lagɩ a vu mɛ tɩn, abam bá wanɩ da á vu. ");
INSERT INTO xsm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A nan lagɩ a pa abam ni-dʋʋrɩ mʋ. Taá soe-na daanɩ. Amʋ na soe abam te tɩn, abam dɩ taá soe daanɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Á na soe daanɩ, nɔɔna maama wʋ́ lwarɩ nɩ abam yɩ a karabiǝ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔn Pɩyɛɛrɩ ma bwe Zezi o wɩ: «A yuutu, yǝn mʋ n lagɩ n vu?» Zezi ma lǝri o wɩ: «Amʋ na lagɩ a vu mɛ tɩn, nmʋ bá wanɩ n da n vu lele kʋntʋ. Maŋa kadoŋ nɩ mʋ, nmʋ laan wʋ́ wanɩ n da-nɩ n vu.» ");
INSERT INTO xsm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pɩyɛɛrɩ ma ta o wɩ: «A yuutu, bɛɛ mʋ yɩ a bá wanɩ a tɔgɩ nmʋ lele kʋntʋ? Amʋ wʋ́ sɛ sɩ a tɩ nmʋ ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Zezi ma lǝr-o o wɩ: «Nmʋ wʋ́ sɩɩnɩ n sɛ sɩ n tɩ amʋ ŋwaanɩ na? A lagɩ a ta cɩga mʋ dɩ nmʋ sɩ, kʋ na wʋ́ loori sɩ cɩbwɩʋ keeri tɩn, nmʋ wʋ́ fʋ kuni bɩtɔ nɩ n yǝri amʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zezi laan ma ta dɩ o karabiǝ bam o wɩ: «Á yɩ pa á bɩcara taa maga. Kɩ-na á wʋ-dɩdʋa dɩ Wɛ, sɩ á kɩ á wʋ-dɩdʋa dɩ amʋ dɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A Ko wʋm sɔŋɔ nɩ, je zanzan mʋ wʋra. A nan lagɩ a vu a kwɛ je mʋ a pa abam. Kʋ na daɩ cɩga, a ya bá ta dɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A na ve a kwɛ je sɩm a ti abam ŋwaanɩ, a laan wʋ́ joori a ba a ja abam, sɩ á tɔgɩ á vu á taá wʋ amʋ na wʋ mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Abam nan ye a na maa ve tɩn cwǝŋǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma ma ta dɩd-o o wɩ: «A yuutu, dɩbam yǝri nmʋ na lagɩ n vu mɛ tɩn. Dɩ́ nan wʋ́ kɩ ta mʋ dɩ́ lwarɩ ka cwǝŋǝ?» ");
INSERT INTO xsm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Zezi ma ta dɩd-o o wɩ: «Amʋ mʋ yɩ cwǝŋǝ dɩ cɩga tu dɩ ŋwɩa tu. Nɔɔn-nɔɔnʋ bá wanɩ o vu a Ko Wɛ te dɩ o na wʋ dɛ amʋ o vu. ");
INSERT INTO xsm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Abam na ye amʋ, á wʋ́ lwarɩ a Ko wʋm dɩ. Lele kʋntʋ abam lwar-o, á nan nɛ-o dɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi ma ta o wɩ: «A yuutu, brɩ dɩbam n Ko wʋm, sɩ kʋntʋ wʋ́ maŋɩ dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zezi ma lǝri o wɩ: «Filipi, amʋ daanɩ abam tee nɩ yɩ nmʋ ta yǝri amʋ na? Wʋlʋ maama na nɛ amʋ tɩn nɛ amʋ Ko wʋm mʋ. Bɛŋwaanɩ mʋ yɩ n ta n wɩ, a brɩ abam a Ko wʋm? ");
INSERT INTO xsm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nmʋ wʋ sɛ nɩ amʋ wʋra dɩ a Ko yɩ a Ko wʋra dɩ amʋ na? Taanɩ dɩlʋ amʋ na tagɩ a brɩ abam tɩn daɩ amʋ tɩtɩ nyɩm. Kʋ yɩ amʋ Ko wʋm mʋ ŋwɩ amʋ wʋnɩ, yɩ o tʋŋɩ o tɩtʋŋa. ");
INSERT INTO xsm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taá jɩgɩ-na wʋ-dɩdʋa dɩ amʋ, sɩ amʋ wʋra dɩ a Ko yɩ a Ko wʋra dɩ amʋ. Á na wʋ kɩ á wʋ-dɩdʋa dɩ amʋ a taanɩ dɩm ŋwaanɩ, á weeni á kɩ á wʋ-dɩdʋa dɩ amʋ tɩtʋŋa yalʋ amʋ na tʋŋɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A lagɩ a ta cɩga mʋ dɩ abam sɩ, wʋlʋ na kɩ o wʋ-dɩdʋa dɩ amʋ tɩn wʋ́ tʋŋɩ tɩtʋŋa yalʋ doŋ amʋ na tʋŋɩ tɩn. O nan wʋ́ tʋŋɩ tɩtʋŋ-kamunǝ sɩ ya taa dwe amʋ na kɩ te tɩn, amʋ na lagɩ a vu a Ko te tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kʋlʋ maama abam na wʋ́ loori amʋ yɩrɩ ŋwaanɩ tɩn, aá kɩ-kʋ a pa abam sɩ a Ko Wɛ na zulǝ amʋ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Abam na loori woŋo kʋlʋ maama amʋ yɩrɩ ŋwaanɩ tɩn, amʋ wʋ́ kɩ-kʋ a pa abam. ");
INSERT INTO xsm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Abam na soe amʋ, á wʋ́ sɛ a niǝ yam. ");
INSERT INTO xsm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A nan wʋ́ loori a Ko wʋm sɩ o pa abam Zǝnnu wʋdoŋ. Wʋntʋ wʋ́ ta wʋ abam tee nɩ maŋa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wʋntʋ mʋ yɩ Wɛ Joro kʋlʋ na yɩ cɩga tu tɩn. Nɔɔna balʋ kugu je na wʋ lʋgʋ baŋa nɩ tɩn bá wanɩ ba sɛ-o, bɛŋwaanɩ ba bá wanɩ ba na-o, yɩ ba bá wanɩ ba lwar-o dɩ. Kʋ daarɩ abam nan ye-o, bɛŋwaanɩ o wʋra dɩ abam, yɩ oó ta ŋwɩ abam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Amʋ bá yagɩ abam á yɩranɩ. Aá joori a ba abam te. ");
INSERT INTO xsm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kʋ na kɩ fɩɩn, lʋgʋ baŋa nɔɔna bam daa bá na amʋ. Abam nan wʋ́ na-nɩ. Bɛŋwaanɩ, amʋ na jɩgɩ ŋwɩa Wɛ tee nɩ tɩn, abam dɩ wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dɛ dɩm kʋntʋ nɩ á wʋ́ lwarɩ nɩ a wʋra dɩ a Ko Wɛ, yɩ abam dɩ wʋra dɩ amʋ, yɩ amʋ dɩ wʋra dɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nɔɔnʋ wʋlʋ maama na sɛ a niǝ yam yɩ o tɔgɩ-ya tɩn mʋ yɩ wʋlʋ na soe amʋ tɩn. A Ko Wɛ wʋ́ ta soe kʋntʋ tu. A dɩ nan wʋ́ ta so-o, yɩ a kwǝri a pa o lwarɩ amʋ na yɩ wʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Zezi na tagɩ kʋntʋ tɩn, nɔɔnʋ wʋdoŋ dɩ yɩrɩ na yɩ Zudasɩ yɩ kʋ daɩ Zudasɩ Yiskarɩyo tɩn ma lǝri o wɩ: «A yuutu, nmʋ wʋ́ kɩ ta mʋ n pa dɩbam lwarɩ nmʋ na yɩ wʋlʋ tɩn, yɩ lʋgʋ baŋa nɔɔna bam bá lwarɩ?» ");
INSERT INTO xsm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Zezi ma lǝr-o o wɩ: «Wʋlʋ na soe amʋ tɩn wʋ́ sɛ o kɩ a na tagɩ kʋlʋ tɩn mʋ. A Ko wʋ́ ta soe kʋntʋ tu, yɩ amʋ dɩ a Ko wʋ́ ba o te dɩ́ taá wʋra dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wʋlʋ maama nan na ba soe amʋ tɩn bá sɛ o kɩ a na tagɩ kʋlʋ tɩn. Taanɩ dɩlʋ abam nan na ni tɩn daɩ amʋ nyɩm, dɩ nuŋi a Ko wʋlʋ na tʋŋɩ-nɩ tɩn te mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","A maŋɩ a ta wǝǝnu tɩm kʋntʋ a brɩ abam maŋa kam a ta na wʋ abam tee nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kʋ daarɩ, Zǝnnu wʋlʋ na wʋ́ ba abam te tɩn, wʋntʋ mʋ yɩ Wɛ Joro kʋm a Ko Wɛ na wʋ́ tʋŋɩ sɩ kʋ ba amʋ yɩrɩ ŋwaanɩ tɩn. Kʋntʋ wʋ́ brɩ abam woŋo maama, yɩ kʋʋ́ pa á guli kʋlʋ maama amʋ na maŋɩ a ta a brɩ abam tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Amʋ yagɩ wʋ-zuru mʋ a pa abam. Kʋ yɩ amʋ tɩtɩ wʋ-zuru mʋ a pɛ abam. Amʋ na pɛ abam wʋ-zuru kʋlʋ tɩn, kʋ daɩ lʋgʋ baŋa nyɩm. Á yɩ pa á bɩcara taa maga, á nan yɩ taá jɩgɩ liǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Abam maŋɩ á ni amʋ na tagɩ dɩ abam nɩ, a lagɩ a viiri, yɩ a ta wʋ́ joori a ba abam te. Abam ya na soe amʋ, á wʋ́ taá jɩgɩ wʋpolo dɩdaanɩ amʋ na lagɩ a vu a Ko Wɛ te tɩn, bɛŋwaanɩ a Ko Wɛ dwe amʋ. ");
INSERT INTO xsm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amʋ nan tagɩ wǝǝnu tɩntʋ a brɩ abam lele kʋntʋ yɩ tɩ daa ta wʋ kɩ, sɩ tɩ na tu tɩ kɩ, sɩ á wanɩ á sɛ a taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Amʋ daa bá ŋɔɔnɩ taanɩ zanzan dɩ abam, lʋgʋ baŋa pɛ sʋtaanɩ na maa bɩɩnɩ tɩn ŋwaanɩ. Wʋntʋ nan bá jɩgɩ dam dɩ amʋ. ");
INSERT INTO xsm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A nan maŋɩ sɩ a pa lʋgʋ baŋa nɔɔna lwarɩ nɩ a soe a Ko wʋm, kʋntʋ mʋ a kɩ kʋlʋ maama a Ko na pɛ-nɩ ni sɩ a kɩ tɩn mʋ. Á zaŋɩ sɩ dɩ́ viiri.» ");
INSERT INTO xsm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Zezi ma ta dɩ ba o wɩ: «Amʋ yɩ vinyǝ tiu cɩga cɩga. A Ko maa yɩ tiu kʋm tu, yɩ o nii kʋ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naga kalʋ na nuŋi tiu kʋm yɩra nɩ yɩ ka ba lǝri biǝ tɩn, oó go-ka o yagɩ mʋ. Kʋ daarɩ naga kalʋ na lǝri biǝ tɩn, oó farɩsɩ-ka mʋ, sɩ ka taa lana, sɩ ka taa fɔgɩ ka lǝri biǝ zanzan. ");
INSERT INTO xsm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Abam bɩcara nan maŋɩ ya kwɛ lanyɩranɩ, nɩ ba na farɩsɩ tiu nɛ yɩ sɩ lana te tɩn, á na sɛ taanɩ dɩlʋ amʋ na ŋɔɔnɩ a brɩ abam tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taá wʋra dɩ amʋ, sɩ amʋ dɩ wʋ́ ta ŋwɩ abam wʋnɩ. Tiu naga bá wanɩ ka lǝ biǝ ka yɩranɩ yɩ ka tǝri tiu kʋm yɩra nɩ. Kʋ nan yɩ bɩdwɩ mʋ dɩ abam. Abam maŋɩ sɩ á taá wʋra dɩ amʋ mʋ, sɩ á laan wanɩ á taá kɩ kǝm-laarʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Amʋ mʋ yɩ tiu kʋm, yɩ abam yɩ kʋ nɛ sɩm. Wʋlʋ maama na wʋra dɩ amʋ yɩ amʋ ŋwɩ kʋntʋ tu wʋnɩ tɩn wʋ́ ta kɩ kǝm-laarʋ mʋ, nɩ naga kalʋ na lǝri biǝ zanzan tɩn. Amʋ nan na tǝri á bɩcara nɩ, á bá wanɩ kʋlʋkʋlʋ á kɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wʋlʋ na tǝrǝ dɩ amʋ tɩn nyɩ dɩ tiu naga kalʋ ba na goni ba yagɩ yɩ ka kʋ tɩn mʋ. Tiu nɛ sɩlʋ na kʋgɩ tɩn, baá pɛ-sɩ ba kɩ mini nɩ mʋ yɩ sɩ di. ");
INSERT INTO xsm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Abam nan na wʋra dɩ amʋ, yɩ amʋ taanɩ dɩm na wʋ á bɩcara nɩ, á wʋ́ wanɩ á loori kʋlʋ maama á wʋbʋŋa na lagɩ tɩn, yɩ á wʋ́ na-kʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Abam na kɩ kǝm-laarʋ, nɩ tiu na lǝri bu-ŋʋna zanzan te tɩn, á wʋ́ sɩɩnɩ á taá yɩ amʋ karabiǝ, yɩ kʋntʋ wʋ́ pa a Ko wʋm na zulǝ. ");
INSERT INTO xsm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nɩnɛɛnɩ a Ko na soe amʋ te tɩn, amʋ dɩ soe abam kʋntʋ mʋ. Taá jɩgɩ-na amʋ sono kʋm á bɩcara nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Abam na kɩ a na tagɩ kʋlʋ tɩn, á wʋ́ wanɩ á taá jɩgɩ amʋ sono kʋm kʋntʋ, nɩ amʋ dɩ na kɩ a Ko na tagɩ kʋlʋ yɩ a jɩgɩ o sono kʋm a bɩcarɩ nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A tagɩ wǝǝnu tɩntʋ a brɩ abam, sɩ wʋpolo kʋlʋ a na jɩgɩ tɩn mʋ taa wʋ abam wʋnɩ, sɩ kʋ pa abam wʋpolo kʋm ja gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ni dɩlʋ amʋ na lagɩ a pa abam tɩn mʋ tɩntʋ: Á taá soe daanɩ, nɩnɛɛnɩ a na soe abam te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Sono tǝrǝ kʋ na dwe tɩntʋ, sɩ nɔɔnʋ sɛ sɩ o tɩ o donnǝ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Abam na kɩ a na tagɩ kʋlʋ tɩn, á wʋ́ ta yɩ a cilonnǝ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Amʋ daa bá ta bǝ abam nɩ a tɩntʋŋna. Bɛŋwaanɩ tɩntʋŋnʋ yǝri kʋlʋ o yuutu na lagɩ o kɩ tɩn. Kʋ nan na yɩ abam, a tagɩ kʋlʋ maama a na ni a Ko Wɛ tee nɩ tɩn a brɩ abam. Kʋntʋ ŋwaanɩ mʋ a laan bǝ abam nɩ a cilonnǝ. ");
INSERT INTO xsm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kʋ nan daɩ abam mʋ kuri amʋ. Kʋ yɩ amʋ mʋ kuri abam, yɩ a daarɩ a pa abam ni sɩ á taá kɩ kǝm-laarʋ. Kǝm-laarʋ tɩm kʋntʋ wʋ́ ta wʋra maŋa maama. Abam na kɩ kǝm-laarʋ tɩm kʋntʋ, a Ko wʋ́ pa abam kʋlʋ maama á na wʋ́ loori o tee nɩ amʋ yɩrɩ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Amʋ na pɛ abam ni sɩ á kɩ kʋlʋ tɩn mʋ tɩntʋ: Á taá soe daanɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Zezi daa ma ta o wɩ: «Lʋgʋ baŋa nɔɔna bam wʋ́ culi abam. Ba nan na culi abam, sɩ á lwarɩ nɩ ba maŋɩ ba da yigǝ ba culi amʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Abam ya na yɩ lʋgʋ baŋa nyɩm, kʋ nɔɔna bam ya wʋ́ ta soe abam, á na yɩ kʋ nyɩm tɩn ŋwaanɩ. Amʋ nan mʋ kuri abam lʋgʋ nɔɔna bam wʋnɩ, yɩ á daa daɩ ba nyɩm. Kʋntʋ ŋwaanɩ mʋ balʋ na yɩ lʋgʋ baŋa nɔɔna tɩn wʋ́ ta culi abam. ");
INSERT INTO xsm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Guli-na a na maŋɩ a ta kʋlʋ a brɩ abam tɩn: Tɩntʋŋnʋ tǝrǝ o na dwe o yuutu. Ba na yaarɩ amʋ tɩn, baá yaarɩ abam dɩ mʋ. Ba nan na sɛ amʋ ni-taanɩ dɩm, baá sɛ abam dɩ ni-taanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba nan wʋ́ kɩ abam tɩntʋ wǝǝnu tɩm maama amʋ ŋwaanɩ mʋ, bɛŋwaanɩ ba yǝri wʋlʋ na tʋŋɩ-nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Amʋ ya na wʋ tu a ŋɔɔnɩ cɩga a brɩ-ba, lwarɩm ya bá ta wʋ ba yuu nɩ. Lele kʋntʋ ba nan daa bá wanɩ ba ta nɩ ba jɩgɩ bʋra. ");
INSERT INTO xsm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wʋlʋ maama na culi amʋ tɩn, kʋntʋ tu culi a Ko wʋm dɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amʋ kɩ tɩtʋŋ-ŋʋna yalʋ nɔɔn-nɔɔnʋ ta na wʋ kɩ ya doŋ tɩn a brɩ-ba. A ya na wʋ kɩ a brɩ-ba, lwarɩm ya bá ta wʋ ba yuu nɩ. Ba nan nɛ a na kɩ kʋlʋ tɩn, yɩ ba ta culi amʋ dɩ a Ko wʋm maama. ");
INSERT INTO xsm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kʋ nan kɩ sɩ kʋ pa kʋlʋ na pʋpʋnɩ Wɛ cullu tɔnɔ kʋm wʋnɩ tɩn mʋ sɩɩnɩ kʋ kɩ, dɩ kʋ na wɩ: ‹Ba culi amʋ, yɩ a wʋ kɩ kʋlʋkʋlʋ.› ");
INSERT INTO xsm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Zǝnnu wʋm nan wʋ́ nuŋi a Ko te o ba. Wʋm mʋ yɩ Wɛ Joro kʋlʋ na yɩ cɩga tu tɩn. A nan wʋ́ tʋŋ-o yɩ o ba abam te, yɩ o laan wʋ́ ŋɔɔnɩ a cɩga kam o brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Abam dɩ nan wʋ́ ŋɔɔnɩ a cɩga kam taanɩ á brɩ nɔɔna, bɛŋwaanɩ abam maŋɩ á wʋra dɩ amʋ pulim nɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«A nan ŋɔɔnɩ wǝǝnu tɩntʋ a brɩ abam sɩ kʋ pa á yɩ zaŋɩ á yagɩ Wɛ cwǝŋǝ kam tɔgɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ba nan wʋ́ lɩ abam ba Wɛ-di sɩm wʋnɩ. Maŋa nan wʋ́ ba ka yi, yɩ nɔɔna wʋ́ gʋ abam, yɩ ba bʋŋɩ nɩ ba tʋŋɩ tɩtʋŋ-ŋʋm mʋ ba pa Wɛ. ");
INSERT INTO xsm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba nan wʋ́ kɩ abam wǝǝnu tɩm kʋntʋ, bɛŋwaanɩ ba yǝri a Ko wʋm, ba nan yǝri amʋ dɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A tɛ wǝǝnu tɩntʋ maama a brɩ abam, sɩ maŋa kam na yiǝ ba na kɩ abam kʋntʋ, sɩ á wanɩ á guli nɩ amʋ maŋɩ a ta-tɩ a brɩ abam.» «A wʋ tagɩ wǝǝnu tɩm kʋntʋ a brɩ abam pulim nɩ, bɛŋwaanɩ amʋ ya wʋ abam tee nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kʋ daarɩ lele kʋntʋ a lagɩ a vu wʋlʋ na tʋŋɩ-nɩ tɩn te. Abam wʋlʋwʋlʋ nan wʋ bwe-nɩ á nii, a lagɩ a vu yǝn mʋ? ");
INSERT INTO xsm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amʋ nan na tagɩ a brɩ abam kʋlʋ na lagɩ kʋ kɩ tɩn mʋ pɛ á wʋrʋ tiini tɩ cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kʋ daarɩ, a lagɩ a ta cɩga mʋ dɩ abam sɩ, amʋ na viiri, kʋʋ́ ta lana kʋ pa abam. Bɛŋwaanɩ, amʋ na wʋ viiri, Zǝnnu wʋm bá ba abam te. A nan na veǝ, a laan wʋ́ tʋŋ-o yɩ o ba abam te. ");
INSERT INTO xsm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","O nan na tuǝ, oó pa lʋgʋ baŋa nɔɔna lwarɩ nɩ ba tusi mʋ ba lwarɩm wʋnɩ, dɩ Wɛ cɩga kam laŋa nɩ, dɩ Wɛ na wʋ́ di nɔɔna taanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oó brɩ-ba nɩ ba na wʋ sɛ amʋ tɩn ba kɩ lwarɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Oó brɩ-ba nɩ ba tusi Wɛ cɩga kam wʋnɩ, bɛŋwaanɩ amʋ lagɩ a vu a Ko Wɛ te, yɩ á daa bá na-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","O ta wʋ́ brɩ-ba nɩ ba tusi Wɛ sarɩya dim dɩm wʋnɩ, bɛŋwaanɩ wʋlʋ na yɩ lʋgʋ baŋa pɛ wʋm tɩn maŋɩ o ga bʋra. ");
INSERT INTO xsm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Amʋ ya ta jɩgɩ wǝǝnu zanzan sɩ a ta a brɩ abam, tɩ nan wʋ́ ta tiini tɩ camma dɩ abam lele. ");
INSERT INTO xsm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kʋ daarɩ Wɛ Joro kʋm yɩ cɩga tu mʋ. Kʋ na tuǝ, kʋ laan wʋ́ pa á lwarɩ cɩga kam maama. Kʋ nan daɩ kʋ tɩtɩ taanɩ mʋ kʋ lagɩ kʋ ŋɔɔnɩ. Kʋʋ́ ŋɔɔnɩ kʋlʋ kʋ na ni Wɛ tee nɩ tɩn mʋ, kʋ ma daarɩ kʋ ta wǝǝnu tɩlʋ na lagɩ tɩ ba tɩn kʋ brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kʋ nan wʋ́ pa amʋ na zulǝ, bɛŋwaanɩ kʋʋ́ brɩ abam amʋ cɩga kam maama. ");
INSERT INTO xsm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A Ko wʋm na jɩgɩ kʋlʋ maama tɩn yɩ amʋ dɩ nyɩm mʋ. Kʋntʋ ŋwaanɩ mʋ a tagɩ a wɩ, DƖ Joro kʋm wʋ́ brɩ abam amʋ cɩga kam maama. ");
INSERT INTO xsm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kʋ na kɩ fɩɩn, abam daa bá na amʋ, yɩ maŋa fɩnfɩɩn na wǝli da, á wʋ́ joori á na-nɩ, a na maa ve a Ko te tɩn ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Zezi na tagɩ kʋntʋ tɩn, o karabiǝ badaara maa tɛ daanɩ ba wɩ: «O na tagɩ o wɩ, kʋ na kɩ fɩɩn dɩ́ daa bá na-o, yɩ maŋa fɩnfɩɩn na wǝli da dɩ́ daa wʋ́ joori dɩ́ na-o tɩn, kʋ kuri mʋ bɛɛ? O na tagɩ o wɩ, o lagɩ o vu o Ko te tɩn, dɩ́ yǝri kʋ kuri.» ");
INSERT INTO xsm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ba ta maa tiini ba bwɛ daanɩ ba wɩ: «O na tagɩ o wɩ, kʋ na kɩ fɩɩn tɩn, kʋ kuri mʋ bɛɛ? Dɩ́ yǝri o na tɛ kʋlʋ tɩn kuri.» ");
INSERT INTO xsm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zezi ma lwarɩ nɩ ba lagɩ sɩ ba bwe-o taanɩ dɩm kuri. O ma ta dɩ ba o wɩ: «A na tagɩ a wɩ, kʋ na kɩ fɩɩn á daa bá na-nɩ, yɩ maŋa fɩnfɩɩn na wǝli da á wʋ́ joori á na-nɩ tɩn ŋwaanɩ mʋ á bwɛ daanɩ na? ");
INSERT INTO xsm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A nan lagɩ a ta cɩga mʋ dɩ abam sɩ, abam wʋ́ ba á keeri á coosi. Kʋ daarɩ lʋgʋ baŋa nɔɔna bam wʋ́ ta jɩgɩ wʋpolo. Abam wʋrʋ wʋ́ ba tɩ cɔgɩ, yɩ á wʋ-cɔgɔ kʋm laan wʋ́ lǝni kʋ ji wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maŋa kalʋ kaanɩ na lagɩ o lʋ bu tɩn, o jɩgɩ liǝ mʋ, bɛŋwaanɩ o canɛɛrɩ maŋa yiǝ. O nan na lʋgɩ bu wʋm, o laan wʋ́ swe o cam dɩm ni nɩ, yɩ o jɩgɩ wʋpolo dɩ o na lʋgɩ bu wʋm tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kʋ nan yɩ kʋntʋ mʋ dɩ abam dɩ. Lele kʋntʋ á jɩgɩ liǝ. Amʋ nan daa ta wʋ́ joori a na abam, yɩ kʋ pa á tiini á na wʋpolo, yɩ nɔɔn-nɔɔnʋ daa bá wanɩ-kʋ o cɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Dɛ dɩm kʋntʋ na yiǝ, abam daa bá bwe amʋ kʋlʋkʋlʋ. A lagɩ a ta cɩga mʋ dɩ abam sɩ, a Ko wʋm wʋ́ pa abam kʋlʋ maama abam na wʋ́ loori amʋ yɩrɩ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Abam nan ta maŋɩ á wʋ loori kʋlʋkʋlʋ dɩ amʋ yɩrɩ. Nan loori-na, sɩ á wʋ́ na, sɩ kʋ pa abam wʋpolo kʋm tiini kʋ gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","A na tagɩ wǝǝnu tɩntʋ a brɩ abam tɩn, kʋ yɩ mɩmaŋa mʋ a mɛ a ta. Maŋa nan wʋ́ ba, yɩ a daa bá maŋɩ mɩmaŋa a ma brɩ abam. A laan wʋ́ ba a ŋɔɔnɩ a Ko Wɛ taanɩ dɩm jaja mʋ a brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dɛ dɩm kʋntʋ nɩ, amʋ daa bá loori a Ko Wɛ abam ŋwaanɩ. Abam mʋ wʋ́ loori-DƖ amʋ yɩrɩ ŋwaanɩ, ");
INSERT INTO xsm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","bɛŋwaanɩ Wɛ tɩtɩ maŋɩ DƖ soe abam, abam na soe amʋ yɩ á kwǝri á sɛ nɩ a nuŋi DƖ tee nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Amʋ sɩɩnɩ a nuŋi a Ko Baŋa-Wɛ te mʋ a ba lʋgʋ baŋa. Lele kʋntʋ a nan lagɩ a yagɩ lʋgʋ baŋa sɩ a joori a vu DƖ te.» ");
INSERT INTO xsm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Zezi na tagɩ kʋntʋ tɩn, o karabiǝ bam laan ma ta dɩd-o ba wɩ: «Nii, nmʋ laan ŋɔɔnɩ jaja mʋ, n daa wʋ mɛ mɩmaŋa n maŋɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lele kʋntʋ, dɩ́ laan lwarɩ nɩ nmʋ ye woŋo maama. Nmʋ daa n ba lagɩ sɩ nɔɔn-nɔɔnʋ bwe-m taanɩ. Kʋntʋ ŋwaanɩ mʋ dɩbam sɛ nɩ nmʋ sɩɩnɩ n nuŋi Wɛ te.» ");
INSERT INTO xsm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Zezi ma lǝri-ba o wɩ: «Lele kʋntʋ á laan sɛ na? ");
INSERT INTO xsm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nii-na, maŋa maa bɩɩnɩ, ka nan yi ka ti, yɩ abam wʋ́ jagɩ, yɩ á dɩdʋa dɩdʋa wʋ́ joori o kwe o cwǝŋǝ o daarɩ amʋ yɩranɩ. A nan bá ta yɩ a yɩranɩ, bɛŋwaanɩ a Ko wʋm wʋ́ ta wʋ a tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Amʋ tagɩ wǝǝnu tɩntʋ a brɩ abam sɩ kʋ pa á na wʋ-zuru mʋ amʋ tɔgɩm dɩm wʋnɩ. Lʋgʋ baŋa nɩ á wʋ́ na yaara. Nan taá jɩgɩ-na pu-dɩa, sɩ amʋ wanɩ lʋgʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zezi na tagɩ taanɩ dɩm kʋntʋ o ti tɩn, o ma kwǝni o yuu wɛɛnɩ yɩ o wɩ: «Amʋ Ko, a tʋʋnɩ maŋa kam laan yiǝ. Amʋ yɩ nmʋ Bu mʋ. Nan pa a na zulǝ, sɩ amʋ dɩ wʋ́ pa n na zulǝ. ");
INSERT INTO xsm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bɛŋwaanɩ nmʋ pɛ-nɩ dam nabiinǝ maama baŋa nɩ, sɩ a wanɩ a pa balʋ maama nmʋ na pɛ-nɩ tɩn na ŋwɩa kalʋ na ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ŋwɩa kalʋ na ba ti tɩn mʋ yɩ sɩ nabiinǝ wanɩ ba lwarɩ nmʋ wʋlʋ yɩranɩ na yɩ Cɩga Tu Baŋa-Wɛ tɩn, sɩ ba daarɩ ba taa ye amʋ Zezi Krisi wʋlʋ nmʋ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A pɛ nɔɔna lwarɩ nmʋ zulǝ yam lʋgʋ baŋa nɩ. A ti tɩtʋŋɩ dɩm nmʋ na pɛ-nɩ sɩ a tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Amʋ Ko, pa a na paarɩ-zulǝ nmʋ tee nɩ lele kʋntʋ, paarɩ-zulǝ yalʋ a na maŋɩ a jɩgɩ dɩ nmʋ kʋ loori lʋgʋ baŋa ta na wʋ kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Amʋ pɛ nɔɔna balʋ nmʋ na kuri lʋgʋ baŋa nɔɔna bam wʋnɩ n kɩ amʋ jɩŋa nɩ tɩn lwarɩ nmʋ na yɩ wʋlʋ. Bantʋ yɩ nmʋ nyɩm mʋ, yɩ n kwe-ba n kɩ amʋ jɩŋa nɩ. Ba nan sɛ nmʋ ni-taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lele kʋntʋ ba lwarɩ nɩ, kʋlʋ maama nmʋ na pɛ amʋ tɩn nuŋi nmʋ te mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bɛŋwaanɩ kwǝrǝ kalʋ nmʋ na pɛ amʋ tɩn mʋ a pɛ-ba, yɩ ba sɛ. Ba nan lwarɩ lanyɩranɩ nɩ amʋ nuŋi nmʋ te mʋ, yɩ ba ta sɛ nɩ nmʋ tʋŋɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A nan loori nmʋ bantʋ ŋwaanɩ mʋ, sɩ a ba loori nmʋ lʋgʋ baŋa nɔɔna bam ŋwaanɩ. Kʋ yɩ nɔɔna balʋ nmʋ na kɩ a jɩŋa nɩ tɩn ŋwaanɩ mʋ, bɛŋwaanɩ bantʋ yɩ nmʋ nyɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Woŋo kʋlʋ maama a na jɩgɩ tɩn yɩ nmʋ nyɩm mʋ, yɩ nmʋ dɩ na jɩgɩ woŋo kʋlʋ maama tɩn yɩ amʋ nyɩm. Nɔɔna balʋ na yɩ nmʋ nyɩm yɩ n kɩ-ba amʋ jɩŋa nɩ tɩn mʋ pɛ a na zulǝ. ");
INSERT INTO xsm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Amʋ daa bá ta wʋ lʋgʋ baŋa nɩ, bantʋ nan ta wʋra mʋ. A maa bɩɩnɩ nmʋ te mʋ. Amʋ Ko, Wʋ-poŋo Tu Baŋa-Wɛ, maɩ nmʋ yɩrɩ dam dɩm n ta n maɩ n nii n nɔɔna bam baŋa nɩ, yɩrɩ dɩlʋ nmʋ na pɛ amʋ tɩn, sɩ kʋ pa ba taa yɩ woŋo dɩdʋa, nɩ nmʋ dɩ amʋ na yɩ dɩdʋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A na wʋra dɩ ba maŋa kalʋ tɩn, nmʋ yɩrɩ dam dɩm n na pɛ-nɩ tɩn mʋ a mɛ a nii ba baŋa nɩ, a ma cɩ-ba yɩ ba wʋlʋwʋlʋ wʋ je, kʋ na daɩ wʋlʋ wʋm na maŋɩ sɩ o cɔgɩ tɩn yɩranɩ. Nmʋ tɔnɔ kʋm brɩ nɩ wʋntʋ maŋɩ sɩ o cɔgɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lele kʋntʋ amʋ maa bɩɩnɩ nmʋ te, a nan tagɩ wǝǝnu tɩntʋ lʋgʋ baŋa nɩ mʋ, sɩ kʋ pa nmʋ nɔɔna bam taa jɩgɩ amʋ wʋpolo kʋm doŋ ba wʋnɩ, sɩ ba taa jɩgɩ wʋpolo kʋ gaalɩ. ");
INSERT INTO xsm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A ma pa-ba nmʋ taanɩ dɩm. Balʋ kugu je na wʋ lʋgʋ baŋa nɩ tɩn ma culi-ba, ba na daɩ lʋgʋ baŋa nyɩm tɩn ŋwaanɩ, nɩ amʋ dɩ na daɩ lʋgʋ baŋa nyɩm te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kʋ nan daɩ nɩ a loori nmʋ sɩ n lɩ-ba lʋgʋ baŋa nɩ. A loori nmʋ sɩ n cɩ-ba sʋtaanɩ na yɩ wo-lwaanʋ tu tɩn jɩŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba daɩ lʋgʋ baŋa nyɩm, nɩ amʋ dɩ na daɩ lʋgʋ baŋa nyɩm te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Fɔgɩ n kwɛ-ba dɩ n cɩga kam sɩ ba taa yɩ nmʋ nyɩm. Nmʋ taanɩ dɩm yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Amʋ tʋŋɩ-ba lʋgʋ wʋnɩ, nɩ nmʋ dɩ na tʋŋɩ amʋ lʋgʋ baŋa nɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kʋ nan yɩ bantʋ ŋwaanɩ mʋ a kwe a tɩtɩ a kɩ nmʋ jɩŋa nɩ, sɩ kʋ pa bantʋ dɩ wanɩ ba taa yɩ nmʋ nyɩm cɩga cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","A nan ba loori nmʋ a paɩ bantʋ yɩranɩ má, kʋ yɩ balʋ dɩ na wʋ́ ba ba kɩ ba wʋ-dɩdʋa dɩ amʋ bantʋ taanɩ dɩm ŋwaanɩ tɩn dɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","A nan loori nmʋ, sɩ kʋ pa ba maama taa yɩ woŋo dɩdʋa mʋ. Amʋ Ko, nmʋ ŋwɩ amʋ wʋnɩ, yɩ amʋ dɩ ŋwɩ nmʋ wʋnɩ. Nan pa bantʋ dɩ taa ŋwɩ dɩ dɩbam kʋntʋ doŋ, sɩ ba taa yɩ woŋo dɩdʋa, sɩ kʋ pa lʋgʋ baŋa nɔɔna sɛ nɩ nmʋ tʋŋɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A pɛ-ba zulǝ yalʋ nmʋ na pɛ amʋ tɩn, sɩ ba wanɩ ba taa yɩ woŋo dɩdʋa, nɩ amʋ dɩ nmʋ na yɩ dɩdʋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Amʋ ŋwɩ ba wʋnɩ yɩ nmʋ ŋwɩ amʋ wʋnɩ, sɩ kʋ pa ba sɩɩnɩ ba taa yɩ woŋo dɩdʋa, sɩ lʋgʋ baŋa nɔɔna wanɩ ba lwarɩ nɩ nmʋ mʋ tʋŋɩ-nɩ, yɩ nmʋ soe nmʋ nɔɔna bam, nɩnɛɛnɩ nmʋ na soe amʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Amʋ Ko, a lagɩ sɩ balʋ nmʋ na kɩ a jɩŋa nɩ tɩn taa tɔgɩ ba wʋ amʋ na wʋ mɛ tɩn, sɩ kʋ pa ba na amʋ paarɩ-zulǝ yalʋ nmʋ na pɛ-nɩ tɩn. Bɛŋwaanɩ nmʋ maŋɩ n soe amʋ kʋ loori lʋgʋ baŋa daa ta na wʋ kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amʋ Ko, nmʋ yɩ Cɩga Tu. Lʋgʋ kʋm nɔɔna bam nan yǝri nmʋ. A nan ye nmʋ, yɩ a nɔɔna bam dɩ ye nɩ nmʋ tʋŋɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Amʋ nan pɛ ba lwarɩ nmʋ na yɩ wʋlʋ tɩn, yɩ a daa ta wʋ́ pa ba lwarɩ nmʋ, sɩ kʋ pa sono kʋlʋ nmʋ na jɩgɩ amʋ ŋwaanɩ tɩn taa wʋ ba wʋnɩ, sɩ amʋ tɩtɩ taa ŋwɩ ba wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zezi dɛɛn na tagɩ wǝǝnu tɩm kʋntʋ o ti tɩn, o dɩ o karabiǝ bam ma zaŋɩ ba nuŋi ba kɛ. Ba ma vu ba bɛ nabara kalʋ yɩrɩ na yɩ Sɩdrɔn tɩn. Gaarɩ maa wʋ jǝgǝ kam kʋntʋ nɩ. Ba ma vu ba zʋ dɩ wʋ. ");
INSERT INTO xsm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zezi dɩ o karabiǝ bam dɛɛn yǝni ba jeeri daanɩ gaarɩ dɩm kʋntʋ nɩ mʋ. Kʋntʋ mʋ pɛ Zudasɩ wʋlʋ na lagɩ o yǝgi Zezi o pa tɩn dɩ ye ka jǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zudasɩ ma tɔgɩ dɩ pamaŋ-kɔgɔ o vu jǝgǝ kam kʋntʋ. Wɛ kaanɩm yigǝ tiinǝ bam dɩ Farizɩan tiinǝ bam dɩ tʋŋɩ ba nɔɔna sɩ ba tɔgɩ ba vu. Ba ma jɩgɩ ba jara zɩla dɩdaanɩ min-zwǝǝnu dɩ mɔɔla. ");
INSERT INTO xsm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Zezi nan maŋɩ o ye kʋlʋ maama na lagɩ kʋ kɩ-o tɩn. O ma fɔɔrɩ o twɛ ba te, yɩ o bwe-ba o wɩ: «Wɔɔ mʋ abam laga?» ");
INSERT INTO xsm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ba ma lǝr-o ba wɩ: «Zezi wʋlʋ na yɩ Nazarɛtɩ tu tɩn mʋ dɩ́ laga.» Zezi ma ta o wɩ: «Kʋ yɩ amʋ mʋ kʋntʋ.» Zudasɩ wʋlʋ na yǝg-o o pa tɩn dɩ maa tɔgɩ o zɩgɩ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zezi na tagɩ dɩ ba o wɩ wʋm mʋ kʋntʋ tɩn, ba ma titwǝni ba joori kwaga ba tʋ tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","O ma joori o bwe-ba o wɩ: «Wɔɔ mʋ abam laga?» Ba ma ta ba wɩ: «Zezi wʋlʋ na yɩ Nazarɛtɩ tu tɩn mʋ dɩ́ laga.» ");
INSERT INTO xsm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Zezi ma ta dɩ ba o wɩ: «A maŋɩ a ta a brɩ abam nɩ, amʋ mʋ kʋntʋ. Kʋ nan na yɩ amʋ mʋ á laga, sɩ á yagɩ bantʋ sɩ ba viiri.» ");
INSERT INTO xsm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","O tagɩ kʋntʋ, sɩ kʋ pa o na maŋɩ o ta taanɩ dɩlʋ tɩn mʋ sɩɩnɩ dɩ kɩ, dɩ o na wɩ: «Amʋ Ko, a wʋ pɛ balʋ maama nmʋ na kɩ a jɩŋa nɩ tɩn dɩ dɩdʋa dɩ je.» ");
INSERT INTO xsm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔn Pɩyɛɛrɩ maa jɩgɩ sʋ-lɔŋɔ. O ma lɩ-kʋ o ma zagɩ Wɛ kaanɩm yuutu wʋm tɩntʋŋnʋ jazɩm zwɛ o go. Tɩntʋŋnʋ wʋm yɩrɩ mʋ Malɩkusi. ");
INSERT INTO xsm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Zezi ma ta dɩ Pɩyɛɛrɩ o wɩ: «Joori n sɩn n sʋgʋ kʋm kʋ polo nɩ. Nmʋ bʋŋɩ nɩ a lagɩ sɩ a lu cam dɩlʋ a Ko na pɛ-nɩ tɩn mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pamaŋna bam kɔgɔ kʋm dɩ ba dɩdɛɛrʋ wʋm dɩ Zwifǝ bam nɔɔna bam laan ma ja Zezi ba vɔ. ");
INSERT INTO xsm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ba ma ja-o ba da yigǝ ba vu Annɩ te. O yɩ Kayifu tɩmbaarʋ mʋ. Kayifu mʋ yɩ Wɛ kaanɩm yuutu bɩnɩ dɩm kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wʋntʋ dɛɛn mʋ ya tagɩ dɩ Zwifǝ bam nɩ kʋ maŋɩ sɩ nɔɔnʋ dɩdʋa mʋ tɩ nɔɔna bam maama ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔn Pɩyɛɛrɩ dɩ o doŋ karabu dɩdʋa ma tɔgɩ Zezi kwaga. Karabu wʋm kʋntʋ dɩ Wɛ kaanɩm yuutu wʋm ye daanɩ lanyɩranɩ. O ma tɔgɩ dɩ Zezi o zʋ Wɛ kaanɩm yuutu wʋm sɔŋɔ kʋnkɔlɔ. ");
INSERT INTO xsm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɩyɛɛrɩ ma maŋɩ mancoŋo ni nɩ o zɩga. Zezi karabu wʋlʋ dɩ Wɛ kaanɩm yuutu wʋm na ye daanɩ tɩn ma joori o nuŋi o ta dɩ bɩsankana kalʋ na nii mancoŋo kʋm ni dɩm baŋa nɩ tɩn, yɩ o daarɩ o ja Pɩyɛɛrɩ o zʋ. ");
INSERT INTO xsm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bɩsankana kam ma bwe Pɩyɛɛrɩ ka wɩ: «Nmʋ tɔgɩ n yɩ Zezi karabu mʋ na?» O ma lǝri o wɩ: «A daɩ o karabu.» ");
INSERT INTO xsm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Waarʋ dɛɛn ma wʋra. Kʋntʋ ŋwaanɩ tɩntʋŋna bam dɩ Zwifǝ yigǝ tiinǝ nɔɔna bam ma dwe mini ba zɩgɩ ba weerǝ. Pɩyɛɛrɩ dɩ ma vu o tɔgɩ o zɩgɩ da o weeri mini dɩm. ");
INSERT INTO xsm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wɛ kaanɩm yuutu wʋm laan ma bwe Zezi o karabiǝ bam laŋa, dɩ o zaasɩm dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Zezi ma lǝr-o o wɩ: «Amʋ yǝni a ŋɔɔnɩ jaja mʋ a brɩ nɔɔna bam maama. A nan yǝni a brɩ nɔɔna bam ba Wɛ-di sɩm nɩ mʋ dɩ Wɛ-di-kamunu kʋm nɩ, mɛ Zwifǝ bam maama na yǝni ba jeeri daanɩ tɩn. A wʋ fɔgɩ a sǝgi a ta kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bɛɛ nan mʋ yɩ n bwe amʋ sɩ n nii? Nan bwe balʋ na cǝgi amʋ taanɩ dɩm tɩn n nii a na tagɩ kʋlʋ dɩ ba tɩn, sɩ bantʋ mʋ ye a na tagɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zezi na tagɩ kʋntʋ tɩn, Zwifǝ yigǝ tiinǝ bam tɩntʋŋnʋ dɩdʋa na zɩgɩ o tɩkǝri nɩ tɩn ma lɔ o pʋpɔŋɔ, yɩ o bwe-o o wɩ: «Bɛɛ mʋ yɩ n ŋɔɔnɩ kʋntʋ doŋ dɩ Wɛ kaanɩm yuutu wʋm?» ");
INSERT INTO xsm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Zezi ma lǝr-o o wɩ: «A na tagɩ kʋlʋ a cɔgɩ tɩn, sɩ n ta sɩ dɩ́ lwarɩ. Kʋ nan na yɩ cɩga mʋ a taga, bɛɛ mʋ yɩ n magɩ-nɩ?» ");
INSERT INTO xsm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annɩ laan ma pa ba ja-o ba vu Kayifu wʋlʋ na yɩ Wɛ kaanɩm yuutu tɩn te, yɩ ba ta wʋ bwǝl-o. ");
INSERT INTO xsm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simɔn Pɩyɛɛrɩ daa ta maa zɩgɩ da o weeri mini dɩm. Ba ma bwe-o ba wɩ: «Nmʋ tɔgɩ n yɩ nɔɔnʋ wʋntʋ karabu mʋ na?» Pɩyɛɛrɩ ma fʋ o wɩ, wʋm daɩ o karabu. ");
INSERT INTO xsm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Wɛ kaanɩm yuutu wʋm tɩntʋŋnʋ dɩdʋa, wʋlʋ cʋrʋ Pɩyɛɛrɩ na zagɩ o zwɛ o go tɩn, ma ta dɩd-o o wɩ: «Amʋ wʋ nɛ abam daanɩ gaarɩ dɩm wʋnɩ na?» ");
INSERT INTO xsm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pɩyɛɛrɩ daa ta ma fʋ. Cɩbwɩʋ ma da kʋ keeri. ");
INSERT INTO xsm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ba laan ma ja Zezi ba nuŋi Kayifu sɔŋɔ nɩ ba vu Rom gʋvɩrma tu wʋm sɔŋɔ. Kʋ dɛɛn yɩ tɩtɩɩtɩ mʋ. Zwifǝ bam ma wʋ dɛ ba zʋ sɔŋɔ kʋm wʋ ba cullu tɩm ŋwaanɩ. Ba maŋɩ sɩ ba cɩ ba tɩtɩ dɩ digiru sɩ ba wanɩ ba na cwǝŋǝ ba di Pakɩ candiǝ kam. ");
INSERT INTO xsm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gʋvɩrma tu Pilatɩ ma nuŋi ba te, yɩ o bwe-ba o wɩ: «Bɛɛ mʋ yɩ abam saŋɩ nɔɔnʋ wʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ba ma lǝr-o ba wɩ: «Nɔɔnʋ wʋntʋ ya na wʋ kɩ o cɔgɩ, dɩ́ ya bá ja-o dɩ́ ba nmʋ te.» ");
INSERT INTO xsm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatɩ ma ta dɩ ba o wɩ: «Abam tɩtɩ nan joŋ-o sɩ á di o taanɩ, sɩ kʋ tɔgɩ abam cullu tɩm na yɩ te tɩn.» Zwifǝ bam ma lǝri ba wɩ: «Dɩbam ba jɩgɩ cwǝŋǝ sɩ dɩ́ gʋ nɔɔn-nɔɔnʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kʋntʋ nan kɩ sɩ kʋ pa Zezi na tagɩ kʋlʋ tɩn mʋ sɩɩnɩ kʋ kɩ, dɩ o na tagɩ nɩ oó tɩ tʋʋnɩ dɩlʋ dwi tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatɩ laan ma joori o zʋ sɔŋɔ kʋm wʋ o bǝŋi Zezi, yɩ o bwe-o o wɩ: «Nmʋ yɩ Zwifǝ bam pɛ mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Zezi ma bwe-o o wɩ: «Nmʋ na tagɩ kʋntʋ tɩn, kʋ yɩ nmʋ tɩtɩ wʋbʋŋa taanɩ mʋ naa nɔɔna mʋ tagɩ a taanɩ dɩ nmʋ?» ");
INSERT INTO xsm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","O ma lǝri o wɩ: «Amʋ daɩ Zwifu. Kʋ yɩ nmʋ tɩtɩ dwi tiinǝ dɩ ba kaanɩm yigǝ tiinǝ bam mʋ jaanɩ nmʋ ba ba ba kɩ amʋ jɩŋa nɩ. Kɔɔ mʋ n kɩa?» ");
INSERT INTO xsm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zezi ma lǝri o wɩ: «Amʋ paarɩ dɩm wʋ nuŋi lʋgʋ baŋa, sɩ dɩ ya na yɩ lʋgʋ baŋa nyɩm, a nɔɔna bam ya wʋ́ kɩ jara sɩ ba cɩ sɩ Zwifǝ bam yɩ wanɩ ba ja amʋ. Kʋ nan na yɩ te tɩn, amʋ paarɩ dɩm daɩ lʋgʋ baŋa nyɩm.» ");
INSERT INTO xsm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatɩ ma bwe-o o wɩ: «Kʋntʋ, nmʋ za yɩ pɛ mʋ na?» Zezi ma lǝri o wɩ: «Nmʋ tɩtɩ mʋ tagɩ n wɩ, a yɩ pɛ. A tu sɩ a ŋɔɔnɩ cɩga mʋ a brɩ nɔɔna lʋgʋ baŋa nɩ. Kʋntʋ ŋwaanɩ mʋ ba lʋgɩ amʋ. Wʋlʋ maama na yɩ cɩga nɔɔnʋ tɩn mʋ cǝgi amʋ taanɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","O ma ta dɩd-o o wɩ: «Bɛɛn yɩ cɩga?» Pilatɩ na tagɩ kʋntʋ tɩn, o laan ma joori o nuŋi pooni o ta dɩ Zwifǝ bam o wɩ: «Amʋ wʋ nɛ o na kɩ kʋlʋ o cɔgɩ tɩn sɩ a di o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Abam nan yǝni á jɩgɩ mɩʋ kʋdoŋ: Pakɩ candiǝ kam maŋa nɩ, amʋ yǝni a lɩ abam pɩɩnʋ dɩdʋa mʋ a yagɩ yɩ o viiri. Abam nan lagɩ sɩ a yagɩ Zwifǝ bam pɛ wʋm mʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ba ma kaasɩ dɩ kwǝr-dɩa ba wɩ: «Kʋ daɩ wʋntʋ, kʋ yɩ Barabasɩ mʋ dɩ́ laga sɩ n yagɩ.» Barabasɩ ya yɩ nɔn-vɩrnʋ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatɩ laan ma pa ba ja Zezi ba magɩ dɩ balaara. ");
INSERT INTO xsm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pamaŋna bam ma kɩ sabarɩ ba ma sɔ yipugǝ ba pu o yuu nɩ. Ba ma kwe gwar-sʋŋʋ ba zʋ-o, yɩ ba mwan-o. ");
INSERT INTO xsm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba maa ve o te, yɩ ba tɛ dɩd-o ba wɩ: «Zwifǝ bam pɛ, dɩnle», yɩ ba lɔɛ o pʋpwaanʋ. ");
INSERT INTO xsm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatɩ daa ta ma joori o nuŋi pooni, yɩ o ta dɩ kɔgɔ kʋm o wɩ: «Nii-na, aá pa nɔɔnʋ wʋm nuŋi o ba o zɩgɩ abam yigǝ nɩ, sɩ á wanɩ á lwarɩ nɩ amʋ wʋ nɛ o na kɩ kʋlʋ o cɔgɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zezi ma nuŋi dɩ o yuu sabarɩ yipugǝ kam dɩ o gwar-sʋŋʋ kʋm. Pilatɩ ma ta dɩ ba o wɩ: «Nii-na nɔɔnʋ wʋm da.» ");
INSERT INTO xsm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wɛ kaanɩm yigǝ tiinǝ bam dɩ ba nɔɔna bam na nɛ-o tɩn, ba maa tɛ dɩ kwǝr-dɩa ba wɩ: «Pa-o tʋʋn-dagara baŋa nɩ n gʋ. Pa-o tʋʋn-dagara baŋa nɩ n gʋ.» Pilatɩ ma ta dɩ ba o wɩ: «Abam tɩtɩ nan ja-o á pa dagara baŋa nɩ á gʋ, sɩ amʋ wʋ nɛ kʋlʋ o na cɔgɩ sɩ a ma di o taanɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Zwifǝ bam ma joori ba lǝr-o ba wɩ: «Dɩbam jɩgɩ culu kʋlʋ na brɩ nɩ o maŋɩ sɩ o tɩ tɩn, bɛŋwaanɩ o brɩ o tɩtɩ nɩ o yɩ Wɛ Bu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatɩ na ni ba na tagɩ kʋntʋ tɩn, fʋʋnɩ ma tiini dɩ zʋ-o. ");
INSERT INTO xsm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","O ma joori o zʋ sɔŋɔ kʋm wʋ, yɩ o bwe Zezi o wɩ: «Nmʋ nuŋi yǝn mʋ?» Zezi maa cɩm yɩ o wʋ lǝr-o kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","O ma ta dɩd-o o wɩ: «Nmʋ ba lagɩ sɩ n lǝri amʋ na? Nmʋ yǝri nɩ amʋ jɩgɩ dam sɩ a pa ba yagɩ-m naa sɩ a pa ba pa-m tʋʋn-dagara baŋa nɩ ba gʋ na?» ");
INSERT INTO xsm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Zezi ma lǝr-o o wɩ: «Nmʋ ya n ba jɩgɩ dam amʋ baŋa nɩ, kʋ na daɩ dam dɩlʋ Wɛ na pɛ-m tɩn. Kʋntʋ ŋwaanɩ nɔɔnʋ wʋlʋ na jaanɩ amʋ o kɩ nmʋ jɩŋa nɩ tɩn mʋ tiini o kɩ wo-lɔŋɔ o dwǝni nmʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Maŋa kam Pilatɩ na ni kʋntʋ tɩn, o maa kwaanɩ o lagɩ cwǝŋǝ sɩ o pa ba yagɩ Zezi. Kʋ daarɩ Zwifǝ bam maa tiini ba tɛ dɩ kwǝr-dɩa ba wɩ: «Nmʋ na yagɩ nɔɔnʋ wʋntʋ, kʋʋ́ brɩ nɩ n culi lʋgʋ kʋm pa-farʋ wʋm mʋ. Nɔɔnʋ wʋlʋ na pɛ o tɩtɩ paarɩ tɩn, kʋntʋ tu yɩ pa-farʋ wʋm dʋm mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatɩ na ni kʋntʋ tɩn, o ma pa ba ja Zezi ba nuŋi, yɩ o daarɩ o jǝni taanɩ dim jǝŋǝ kam je nɩ. Ba bǝ jǝgǝ kam kʋntʋ nɩ, Kandwa-pulwaarʋ je mʋ. Ka yɩrɩ dɩ Zwifǝ bam taanɩ mʋ yɩ Gabata. ");
INSERT INTO xsm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kʋ dɛɛn yɩ wɩa tɩtarɩ nɩ mʋ, dɛ dɩm tɩga na wʋ́ pʋʋrɩ sɩ Pakɩ candiǝ kam di tɩn. Pilatɩ laan ma ta dɩ Zwifǝ bam o wɩ: «Nii-na á pɛ wʋm.» ");
INSERT INTO xsm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ba ma ta kaasɩ baŋa baŋa ba wɩ: «Ti o mʋmwɛ, ti o mʋmwɛ, pa-o tʋʋn-dagara baŋa nɩ n gʋ.» O ma bwe-ba o wɩ: «Abam lagɩ sɩ ba pa á pɛ wʋm dagara baŋa nɩ ba gʋ mʋ na?» Wɛ kaanɩm yigǝ tiinǝ bam ma lǝri ba wɩ: «Dɩbam ba jɩgɩ pɛ wʋdoŋ, kʋ na daɩ lʋgʋ kʋm pa-farʋ wʋm yɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilatɩ laan ma kɩ Zezi pamaŋna bam jɩŋa nɩ, sɩ ba pa-o tʋʋn-dagara baŋa nɩ ba gʋ. Pamaŋna bam laan ma ja Zezi, ");
INSERT INTO xsm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","yɩ ba pa o zɩŋɩ dagara kalʋ ba na lagɩ ba pa-o ka baŋa nɩ tɩn. O ma vu o yi jǝgǝ kalʋ ba na bǝ nɩ Yukol-pʋa piu tɩn. Kʋ yɩrɩ dɩ Zwifǝ bam taanɩ mʋ yɩ Goligota. ");
INSERT INTO xsm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kʋ yɩ dáanɩ mʋ ba pag-o tʋʋn-dagara kam baŋa nɩ. Ba ma ja nɔɔna badonnǝ bale dɩ, ba pa dagarɩ baŋa nɩ. Zezi maa wʋ bantʋ bale tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɩ ma pʋpʋnɩ tɔnɔ o pa ba tanɩ-kʋ dagara kam yuu nɩ. Kʋ pʋpʋnɩ kʋ wɩ: «Wʋntʋ mʋ yɩ Nazarɛtɩ tu Zezi wʋlʋ na yɩ Zwifǝ bam pɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zwifǝ bam zanzan ma karɩmɩ tɔnɔ kʋm, bɛŋwaanɩ jǝgǝ kalʋ ba na pagɩ Zezi da tɩn batwarɩ dɩ tɩʋ kʋm ni. Kʋ ma pʋpʋnɩ dɩ Zwifǝ bam taanɩ dɩ Rom tiinǝ taanɩ dɩ Grɛkɩ tiinǝ taanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Zwifǝ kaanɩm yigǝ tiinǝ bam na nɛ tɩn, ba ma vu ba ta dɩ Pilatɩ ba wɩ: «Kʋ wʋ maŋɩ sɩ n pʋpʋnɩ nɩ ‹Zwifǝ bam pɛ›. Kʋ maŋɩ sɩ n pʋpʋnɩ nɩ: ‹Nɔɔnʋ wʋntʋ mʋ brɩ o tɩtɩ o wɩ, o yɩ Zwifǝ bam pɛ mʋ.› » ");
INSERT INTO xsm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","O ma lǝri-ba o wɩ: «Amʋ na pʋpʋnɩ te tɩn maŋɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pamaŋna bam na pagɩ Zezi dagara kam baŋa nɩ ba ti tɩn, ba laan ma kwe o gwaarʋ tɩm ba cɛ kuni bɩna, sɩ pamaŋnʋ maama kwe o nyɩm. Ba ma kwe o gwar-bu wʋm dɩ. Kʋ maama sɔgɩ punǝ mʋ, kʋ ba jɩgɩ toŋim je. ");
INSERT INTO xsm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kʋ na yɩ kʋntʋ tɩn, ba ma ta daanɩ ba wɩ: «Yɩ pa-na dɩ́ kaarɩ-kʋ. Nan pa-na dɩ́ ta jɔrɔ sɩ dɩ́ nii wʋlʋ na wʋ́ joŋi-kʋ tɩn.» Kʋ dɛɛn kɩ kʋntʋ mʋ, sɩ kʋ pa kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn sɩɩnɩ kʋ kɩ, nɩ kʋ na wɩ: «Ba cɛ amʋ gwaarʋ ba pa daanɩ, yɩ ba daarɩ ba ta jɔrɔ amʋ gwar-bu wʋm ŋwaanɩ.» Pamaŋna bam ma sɩɩnɩ ba kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Balʋ dɛɛn na zɩgɩ ba batwarɩ dɩ Zezi dagara kam tɩn mʋ yɩ o nu wʋm dɩ o nu nyaanɩ, dɩ Mari wʋlʋ na yɩ Klopasɩ kaanɩ tɩn, dɩ Mari wʋlʋ na nuŋi Magɩdala tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zezi na nɛ o nu wʋm dɩ o karabu wʋlʋ o na soe lanyɩranɩ ba zɩgɩ da tɩn, o ma ta dɩ o nu wʋm o wɩ: «A nu, nii wʋntʋ laan mʋ yɩ n bu.» ");
INSERT INTO xsm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","O ma daarɩ o ta dɩ o karabu wʋm dɩ o wɩ: «Nii n nu da.» Kʋ na zɩgɩ maŋa kam kʋntʋ nɩ, o karabu wʋm laan ma joŋi Zezi nu wʋm o pa o ba o zʋʋrɩ o sɔŋɔ nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kʋntʋ kwaga nɩ Zezi maa ye nɩ woŋo maama kɩ kʋ ti. O maa wɩ, na-nyɔm jɩg-o. O tagɩ kʋntʋ, sɩ kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn mʋ sɩɩnɩ kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Zʋŋa dɛɛn mʋ zɩgɩ da, ka na su dɩ sana kalʋ na nywana tɩn. Ba ma kwe sɩpɔɔ ba dɩ sana kam wʋnɩ, yɩ ba vɔ-kʋ miu ni nɩ ba te ba pa kʋ yi Zezi ni. ");
INSERT INTO xsm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zezi na laŋɩ sa-nywana kam tɩn, o ma ta o wɩ: «Kʋ laan kɩ kʋ ti.» O ma daarɩ o cɔɔlɩ o yuu tɩga nɩ, yɩ o pa o siun ti. ");
INSERT INTO xsm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kʋ dɛɛn yɩ dɛ dɩlʋ Zwifǝ bam na yǝni ba ti ba yigǝ sɩ ba siun dɛ dɩm laan yi tɩn mʋ. Tɩga na wʋ́ pʋʋrɩ sɩ kʋ taa yɩ ba siun dɛ kamunu kʋm tɩn, ba maa ba lagɩ sɩ nɔɔna bam yɩra yam taa wʋ dagarɩ sɩm baŋa nɩ dɛ dɩm kʋntʋ nɩ. Kʋntʋ ŋwaanɩ Zwifǝ yigǝ tiinǝ bam ma vu Pilatɩ te, ba ta dɩd-o sɩ o pa cwǝŋǝ sɩ ba bwǝri nɔɔna bam nɛ sɩ ba tɩ, sɩ ba laan parɩ-ba ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kʋntʋ, pamaŋna bam ma vu balʋ ba na pagɩ ba wǝli dɩ Zezi tɩn te, yɩ ba magɩ dayigǝ nɔɔnʋ wʋm nɛ ba bwǝri, dɩ o doŋ wʋm nɛ. ");
INSERT INTO xsm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba ma vu ba yi Zezi. Ba ma na nɩ o maŋɩ o tɩ mʋ, yɩ ba daa wʋ bwǝri wʋntʋ nɛ. ");
INSERT INTO xsm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kʋ daarɩ pamaŋnʋ dɩdʋa ma kwe o cicwe o ma zɔ Zezi saŋa nɩ. Jana dɩ na ma da ba nuŋǝ. ");
INSERT INTO xsm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nɔɔnʋ wʋlʋ yi na nɛ kʋntʋ tɩn mʋ ŋɔɔnɩ kʋ woŋo, sɩ kʋ pa abam dɩ wanɩ á sɛ. O nan ye nɩ o na tagɩ kʋlʋ tɩn yɩ cɩga mʋ, yɩ o zɩgɩ cɩga kam kʋntʋ kwaga nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kʋntʋ nan kɩ sɩ kʋ pa kʋlʋ na pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ tɩn mʋ sɩɩnɩ kʋ kɩ, nɩ kʋ na wɩ: «O kuǝ dɩ dɩdʋa dɩ bá bwǝri.» ");
INSERT INTO xsm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wɛ tɔnɔ kʋm ta tagɩ kʋ wɩ: «Nɔɔna wʋ́ fɔgɩ ba nii wʋlʋ wʋm ba na zɔgɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kʋntʋ kwaga nɩ nɔɔnʋ wʋdoŋ na nuŋi Arimatɩ o yɩrɩ mʋ Zʋzɛfʋ tɩn ma zaŋɩ o vu Pilatɩ te. O dɛɛn yɩ Zezi karabu mʋ, yɩ o ba brɩ o tɩtɩ jaja o na kwarɩ Zwifǝ yigǝ tiinǝ bam tɩn ŋwaanɩ. O ma vu o bwe Pilatɩ sɩ o nii, oó wanɩ o kwe Zezi yɩra yam na. Pilatɩ ma sɛ sɩ o kwe. Zʋzɛfʋ ma vu o par-o dagara kam yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛm wʋlʋ dɛɛn na ve o na Zezi tɩtɩɩ nɩ tɩn dɩ maa tɔgɩ o wʋra. O maa jɩgɩ tralɩ nugǝ zanzan o tee nɩ, kʋ na maŋɩ dɩ garɩwaa yi. Nugǝ kam yɩ Miiri dɩ Alowɛsɩ nugǝ mʋ gwaanɩ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Zʋzɛfʋ dɩ Nikodɛm ma kwe Zezi yɩra yam ba turi-ya dɩ tralɩ nugǝ kam, yɩ ba daarɩ ba pri-o dɩ gar-jalɩ, nɩ Zwifǝ bam na yǝni ba kɩ ba twa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Gaara mʋ wʋ jǝgǝ kalʋ ba na pagɩ Zezi dagara baŋa nɩ tɩn. Piu ma wʋ gaara yam wʋnɩ, bɔn-dʋʋrɩ maa wʋ piu kʋm yɩra nɩ ba ta na wʋ kɩ nɔɔn-nɔɔnʋ da. ");
INSERT INTO xsm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kʋ na yɩ dɛ dɩlʋ tɩga na wʋ́ pʋʋrɩ sɩ kʋ taa yɩ ba siun dɛ dɩm tɩn, ba ma kwe Zezi ba tiŋi bɔɔnɩ dɩm wʋnɩ, dɩ je na batwarɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dɛ dɩlʋ na saŋɩ ba siun dɛ dɩm tɩn, Mari wʋlʋ na nuŋi Magɩdala tɩn ma zaŋɩ o go tɩga o vu Zezi yibeeli dɩm jǝgǝ. O ma na nɩ kandwɛ dɩlʋ ya na pɩ bɔɔnɩ dɩm ni tɩn tigi daa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O ma duri o joori o vu o ta dɩ Simɔn Pɩyɛɛrɩ dɩ karabu wʋlʋ Zezi na soe tɩn o wɩ: «Ba kwe dɩ́ Yuutu wʋm yɩra yam yibeeli dɩm wʋnɩ, dɩ́ nan yǝri ba na kɩ-o mɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Pɩyɛɛrɩ dɩ karabu wʋdoŋ wʋm ma zaŋɩ ba duri ba maa ve bɔɔnɩ dɩm jǝgǝ. Karabu wʋntʋ ma duri o loori Pɩyɛɛrɩ bɔɔnɩ dɩm ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O ma tiiri o nii bɔɔnɩ dɩm wʋnɩ o na gar-jalɩ dɩm na tigi da, yɩ o wʋ zʋ dɩ wʋ. ");
INSERT INTO xsm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Pɩyɛɛrɩ ma da o kwaga o ba o yi. O ma kɛ o zʋ bɔɔnɩ dɩm wʋ o na gar-jalɩ dɩm na tigi da, ");
INSERT INTO xsm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yɩ o na gɔrɔ kʋlʋ ba ya na mɛ ba ba Zezi yuu tɩn. Kʋntʋ nan pri mʋ kʋ tigi kʋ yɩra. ");
INSERT INTO xsm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Karabu wʋlʋ ya na yi da yigǝ tɩn dɩ laan ma zʋ bɔɔnɩ dɩm wʋ. O ma na kʋlʋ na wʋra tɩn, yɩ o daarɩ o sɛ nɩ kʋ sɩɩnɩ kʋ yɩ cɩga. ");
INSERT INTO xsm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ba daa ta ma wʋ lwarɩ Wɛ tɔnɔ kʋm na tagɩ kʋlʋ kʋ wɩ o maŋɩ sɩ o bi o yagɩ tʋʋnɩ tɩn kuri. ");
INSERT INTO xsm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ba laan ma joori ba vu sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari daa ta maa zɩgɩ yibeeli dɩm ni nɩ o keerǝ. O na keerǝ kʋntʋ tɩn, o ma tiiri o nii bɔɔnɩ dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","O ma na malɛsɩ sɩle na zʋ gwar-pwǝǝnu, sɩ je mɛ seeni Zezi yɩra yam ya na tigi da tɩn. Dɩdʋa maa wʋ o yuu seeni, yɩ kadoŋ kam wʋ o nɛ seeni. ");
INSERT INTO xsm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Sɩ ma bwe-o sɩ wɩ: «A nakɔ, bɛɛ mʋ yɩ n keerǝ?» O ma ta dɩ sɩ o wɩ: «Ba kwe a Yuutu wʋm yɩra yam mʋ ba ja viiri, a nan yǝri ba na kwe-o ba kɩ mɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","O na tagɩ kʋntʋ tɩn, o ma pipiri o nii o kwaga nɩ o na Zezi na zɩgɩ da, yɩ o wʋ lwarɩ nɩ kʋ yɩ Zezi mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Zezi ma bwe-o o wɩ: «A nakɔ, bɛɛ mʋ yɩ n keerǝ? Wɔɔ mʋ nmʋ beerǝ?» Mari maa bʋŋɩ nɩ o yɩ gaarɩ dɩm tu mʋ. O ma ta dɩd-o o wɩ: «Amʋ tu, kʋ na yɩ nmʋ na kwe-o n ja n viiri, sɩ n brɩ-nɩ n na kɩ-o mɛ tɩn, sɩ a vu a kwe-o.» ");
INSERT INTO xsm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Zezi ma bǝŋi o yɩrɩ o wɩ: «Mari.» Mari ma pipiri o nii o seeni, yɩ o ta dɩ Zwifǝ bam taanɩ o wɩ: «Rabuni», kʋ kuri mʋ Karanyɩna. ");
INSERT INTO xsm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zezi ma ta dɩd-o o wɩ: «Yɩ ta n dwe-nɩ, sɩ amʋ daa ta wʋ joori a vu a Ko wʋm te. Nan ve n ta n brɩ a ko-biǝ bam nɩ, amʋ laan maa ve a Ko wʋm te, wʋlʋ na yɩ abam dɩ Ko tɩn. Wʋntʋ mʋ yɩ Baŋa-Wɛ, amʋ Tu dɩ abam dɩ Tu.» ");
INSERT INTO xsm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari wʋlʋ na nuŋi Magɩdala tɩn laan ma zaŋɩ o vu o ta dɩ Zezi karabiǝ bam o wɩ: «Amʋ nɛ dɩ́ Yuutu wʋm», yɩ o daarɩ o ta kʋlʋ Zezi na tagɩ o brɩ-o tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dɛ dɩm kʋntʋ nɩ dɩdaan-ni nɩ mʋ Zezi karabiǝ bam lagɩ daanɩ jǝgǝ dɩdʋa. Ba fɔgɩ ba pɩ digǝ kam ni dɩ borbu, ba na kwarɩ fʋʋnɩ dɩ Zwifǝ yigǝ tiinǝ bam tɩn ŋwaanɩ. Zezi laan ma da o ba o zɩgɩ ba tɩtarɩ nɩ. O ma ta dɩ ba o wɩ: «Yazurǝ wʋ́ jǝni dɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","O na tagɩ kʋntʋ tɩn, o ma brɩ-ba o jɩa dɩ o saŋa kam. O karabiǝ bam maa tiini ba jɩgɩ wʋpolo lanyɩranɩ dɩ ba na nɛ ba Yuutu wʋm tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","O daa ta ma joori o ta dɩ ba o wɩ: «Yazurǝ wʋ́ jǝni dɩ abam. A Ko Wɛ na tʋŋɩ-nɩ lʋgʋ baŋa nɩ te tɩn, amʋ dɩ tʋŋɩ abam lʋgʋ kʋm wʋnɩ kʋntʋ doŋ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","O na tagɩ kʋntʋ tɩn, o ma fuli ba seeni yɩ o wɩ: «Joŋi-na Wɛ Joro kʋm. ");
INSERT INTO xsm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Abam na yagɩ nɔɔnʋ wʋlʋ lwarɩm á ma cɛ-o tɩn, Wɛ wʋ́ sɩɩnɩ DƖ yagɩ DƖ ma cɛ kʋ tu. Kʋ daarɩ, abam na wʋ yagɩ á ma cɛ wʋlʋ tɩn, Wɛ dɩ bá yagɩ DƖ ma cɛ-o.» ");
INSERT INTO xsm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma wʋlʋ ba na ma bǝ nɩ Yiywɛ yɩ o wʋ Zezi karabiǝ fugǝ-bale bam wʋnɩ tɩn ya tǝrǝ maŋa kam Zezi na tu o karabiǝ bam te tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Karabiǝ badonnǝ bam ma ta ba brɩ-o ba wɩ: «Dɩbam ya nɛ dɩ́ Yuutu wʋm.» O ma ta dɩ ba o wɩ: «Amʋ yi na wʋ nɛ cɩna yam niǝ o jɩ sɩm nɩ, sɩ a kɩ a nʋa da a nii, sɩ a daarɩ a kɩ a jɩŋa o saŋa kam nɩ, amʋ bá sɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Da nana na kɛ tɩn, Zezi karabiǝ bam daa ma la daanɩ jǝgǝ dɩdʋa, yɩ Toma dɩ laan wʋra. Ba ma fɔgɩ ba pɩ digǝ kam ni dɩ borbu. Zezi ma da o ba o zɩgɩ ba tɩtarɩ nɩ. O ma ta o wɩ: «Yazurǝ wʋ́ jǝni dɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","O laan ma ta dɩ Toma o wɩ: «Ma n nʋa n taanɩ a jɩ sɩm yo seeni n nii, n daarɩ n tʋrɩ n jɩŋa a saŋa kam nɩ. Yagɩ bʋbwɛa, sɩ n daarɩ n sɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma ma lǝr-o o wɩ: «Nmʋ yɩ a Yuutu dɩ amʋ Baŋa-Wɛ.» ");
INSERT INTO xsm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zezi ma ta dɩd-o o wɩ: «Nmʋ na nɛ amʋ tɩn ŋwaanɩ mʋ n laan sɛ na? Balʋ nan na sɛ amʋ yɩ ba ta wʋ nɛ-nɩ tɩn mʋ tiini ba jɩgɩ yu-yoŋo.» ");
INSERT INTO xsm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zezi dɛɛn kɩ wo-kɩnkagɩla yadonnǝ zanzan o karabiǝ bam tɩtarɩ nɩ, yɩ tɩ maama nan wʋ pʋpʋnɩ tɔnɔ kʋntʋ wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wǝǝnu tɩlʋ na pʋpʋnɩ tɩn yɩ sɩ á wanɩ á sɛ, nɩ Zezi mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn, yɩ o kwǝri o yɩ Wɛ Bu wʋm. Á nan na kɩ á wʋ-dɩdʋa dɩd-o, á wʋ́ na ŋwɩa Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kʋntʋ kwaga nɩ Zezi daa ma joori o brɩ o tɩtɩ dɩ o karabiǝ bam Tiberiyadɩ nɩnɩʋ kʋm ni nɩ. O na brɩ o tɩtɩ te tɩn mʋ tɩntʋ: ");
INSERT INTO xsm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔn Pɩyɛɛrɩ dɛɛn wʋra, dɩ Toma wʋlʋ ba na bǝ nɩ Yiywɛ tɩn. Natanayɛlɩ dɩ wʋra, wʋlʋ na nuŋi Galile tɩʋ Kana tɩn, dɩdaanɩ Zebede biǝ bam dɩ Zezi karabiǝ badonnǝ bale. Bantʋ bam maama mʋ wʋ daanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔn Pɩyɛɛrɩ ma ta dɩ ba o wɩ: «A maa ve a ja kale mʋ.» Ba ma lǝr-o ba wɩ: «Dɩ́ wʋ́ tɔgɩ dɩ nmʋ dɩ́ vu.» Ba ma zaŋɩ ba vu ba zʋ naboro kʋm. Tɩtɩɩ dɩm kʋntʋ nɩ ba ma kwaanɩ sɩ ba ja kale, yɩ ba wʋ nɛ kʋlʋkʋlʋ ba ja. ");
INSERT INTO xsm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tɩga na wʋra ka pʋʋrɩ tɩn, Zezi maa zɩgɩ nɩnɩʋ kʋm ni nɩ, yɩ ba wʋ lwar-o. ");
INSERT INTO xsm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O ma bǝŋi-ba o wɩ: «A badonnǝ-ba, abam wʋ jaanɩ kale na?» Ba ma lǝr-o ba wɩ: «Dɩ́ wʋ nɛ kʋlʋkʋlʋ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O laan ma ta dɩ ba o wɩ: «Nan dɩ-na á bʋra kam naboro kʋm jazɩm seeni, sɩ á wʋ́ ja.» Ba ma sɩɩnɩ ba dɩ bʋra kam, yɩ ba daa warɩ ba vaŋɩ-ka ba lɩ ba dɩ boro kʋm wʋnɩ, kale sɩm na tiini sɩ dagɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Zezi karabu wʋlʋ o na soe tɩn ma ta dɩ Pɩyɛɛrɩ o wɩ: «Dɩbam Yuutu wʋm mʋ.» Simɔn Pɩyɛɛrɩ na lwarɩ nɩ kʋ yɩ ba Yuutu wʋm kʋntʋ tɩn, o ma kwe o gɔrɔ kʋlʋ o ya na lɩ tɩn o zʋ, yɩ o laan daarɩ o faŋɩ o cu na bam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Karabiǝ badaara bam ma ja naboro kʋm ba ba, yɩ ba vaŋɩ bʋra kam dɩ kale sɩm ba wǝli da ba yi na bam ni, ba na daɩ yigǝ yigǝ dɩ buburu kʋm tɩn ŋwaanɩ. Kʋ dɛɛn yɩ nɩnɛɛnɩ mɛtra bi mʋ te. ");
INSERT INTO xsm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ba na bɛ bubɛ dɩm tɩn, ba ma na min-cala na wʋra, yɩ kale wʋ ya yuu nɩ. Dɩpɛ dɩ maa tigi da. ");
INSERT INTO xsm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zezi ma ta dɩ ba o wɩ: «Twǝri-na kale sɩlʋ á na jaanɩ lele tɩn sɩdaara á ja á ba.» ");
INSERT INTO xsm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔn Pɩyɛɛrɩ laan ma vu o zʋ naboro kʋm wʋ o vaŋɩ bʋra kam o dɩ tɩga nɩ. Ka su dɩ kalǝŋ-kamunǝ mʋ, sɩ maama yɩ bi dɩ fiinnu sɩtɔ mʋ (153). Dɩ kale sɩm na daga kʋntʋ tɩn dɩ, bʋra kam wʋ kaarɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zezi ma ta dɩ ba o wɩ: «Ba-na á gʋ á ni-cɛɛrɩ.» O karabiǝ bam maama ma kwarɩ sɩ ba bwe-o ba nii nɩ o yɩ wɔɔ mʋ, bɛŋwaanɩ ba maŋɩ ba lwarɩ nɩ kʋ yɩ ba Yuutu wʋm mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Zezi ma zaŋɩ o vu o kwe dɩpɛ dɩm o pa-ba, yɩ o daarɩ o kwe kale sɩm dɩ o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zezi na bi o yagɩ tʋʋnɩ tɩn, kʋntʋ mʋ kɩ kuni bɩtɔ o na brɩ o tɩtɩ dɩ o karabiǝ bam. ");
INSERT INTO xsm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ba na di ba ti tɩn, Zezi laan ma bwe Simɔn Pɩyɛɛrɩ o wɩ: «Zan bu Simɔn, nmʋ soe amʋ n dwe bantʋ na?» O ma lǝri o wɩ: «A Yuutu, ɛɛn, nmʋ ye nɩ amʋ soe nmʋ.» Zezi ma ta dɩd-o o wɩ: «Nan ta n nii a pǝlbiǝ bam baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","O ma joori o bwe Pɩyɛɛrɩ o kɩ bɩle o wɩ: «Zan bu Simɔn, nmʋ soe amʋ na?» O ma lǝri o wɩ: «A Yuutu, ɛɛn, nmʋ ye nɩ amʋ soe nmʋ.» Zezi ma ta dɩd-o o wɩ: «Nan ta n nii amʋ peeni sɩm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","O daa ma bwe Pɩyɛɛrɩ o kɩ kuni bɩtɔ o wɩ: «Zan bu Simɔn, nmʋ soe amʋ na?» Pɩyɛɛrɩ wʋ ma cɔgɩ dɩ Zezi na bwe-o kuni bɩtɔ o wɩ o so-o na tɩn. O ma ta dɩ Zezi o wɩ: «Amʋ Yuutu, nmʋ ye woŋo maama. Kʋntʋ ŋwaanɩ nmʋ ye nɩ amʋ soe nmʋ.» Zezi laan ma ta dɩd-o o wɩ: «Nan ta n nii amʋ peeni sɩm baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A lagɩ a ta cɩga mʋ dɩ nmʋ sɩ, nmʋ dɛɛn na yɩ nɔn-dʋŋʋ tɩn, nmʋ yǝni n vɔ n kilǝ n tɩtɩ nɩ mʋ lanyɩranɩ, yɩ n daarɩ n ve nmʋ na lagɩ mɛ tɩn. Kʋ daarɩ nmʋ nan na kwɩn, n laan wʋ́ zǝŋi n jɩa mʋ wɛɛnɩ, yɩ nɔɔnʋ wʋdoŋ vɔ-ka o pa-m, yɩ o daarɩ o ja-m o vu nmʋ na ba lagɩ mɛ sɩ n vu tɩn.» ");
INSERT INTO xsm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zezi dɛɛn tagɩ kʋntʋ sɩ kʋ brɩ Pɩyɛɛrɩ na wʋ́ tɩ tʋʋnɩ dɩlʋ dwi sɩ kʋ pa Wɛ na zulǝ tɩn mʋ. O laan ma daarɩ o ta dɩ Pɩyɛɛrɩ o wɩ: «Ta n tɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pɩyɛɛrɩ ma pipiri o nii o kwaga nɩ, yɩ o na Zezi karabu wʋlʋ o na soe tɩn na tɔgɩ-ba. Wʋntʋ mʋ yɩ wʋlʋ ya na jǝni o salɩ Zezi wʋdiu kʋm dim maŋa nɩ yɩ o bwe-o o wɩ: «A Yuutu, wɔɔ mʋ lagɩ o yǝgi nmʋ o pa?» tɩn. ");
INSERT INTO xsm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pɩyɛɛrɩ na nɛ-o tɩn, o ma bwe Zezi o wɩ: «A Yuutu, sɩ wʋntʋ, bɛɛ mʋ lagɩ kʋ kɩ-o?» ");
INSERT INTO xsm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zezi ma lǝr-o o wɩ: «Amʋ na lagɩ sɩ o taa ŋwɩ sɩ kʋ taa ve maŋa kam amʋ na wʋ́ joori a ba tɩn, kʋntʋ daɩ nmʋ yigǝ. Nmʋ za n weeni n ta n tɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kʋntʋ ŋwaanɩ mʋ pɛ Zezi karabiǝ bam dɛɛn jɩgɩ-ka ba ŋɔɔnɩ ba wɩ, Zezi karabu wʋm kʋntʋ bá tɩ maŋa dɩ maŋa. Zezi nan wʋ tagɩ o wɩ, o bá tɩ. O dɛɛn tagɩ o wɩ: «Amʋ na lagɩ sɩ o taa ŋwɩ sɩ kʋ taa ve maŋa kam a na wʋ́ joori a ba tɩn, kʋntʋ daɩ nmʋ yigǝ.» ");
INSERT INTO xsm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Zezi karabu wʋlʋ o na tagɩ o taanɩ kʋntʋ tɩn mʋ yɩ amʋ wʋlʋ na brɩ Wɛ cɩga kam yɩ a daarɩ a pʋpʋnɩ-ka a tiŋi tɩn. Dɩbam maama nan ye nɩ a na brɩ te tɩn sɩɩnɩ kʋ yɩ cɩga mʋ. ");
INSERT INTO xsm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zezi ta kɩ wǝǝnu zanzan o wǝli da. Tɩ maama dɩdʋa dɩdʋa nan ya na lagɩ tɩ pʋpʋnɩ tɩ tiŋi, a bʋŋɩ nɩ lʋgʋ baŋa ya bá na je sɩ twaanʋ tɩm kʋntʋ pǝni da.");
INSERT INTO xsm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A ciloŋ Teofili, a maŋɩ a da yigǝ a pʋpʋnɩ tɔnɔ a pa nmʋ. Tɔnɔ kʋm kʋntʋ wʋnɩ mʋ a pʋpʋnɩ wǝǝnu tɩlʋ maama Zezi dɛɛn na kɩ tɩn, yɩ a kwǝri a pʋpʋnɩ o na yǝni o brɩ nɔɔna te tɩn, kʋ na sɩŋɩ maŋa kalʋ o na puli o tɩtʋŋa yam ");
INSERT INTO xsm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sɩ kʋ vu kʋ yi dɛ dɩm Wɛ na kwe-o DƖ ja di DƖ sɔŋɔ tɩn. Kʋ na wʋ́ loori sɩ o di Wɛ-sɔŋɔ kʋntʋ tɩn, o laan ma brɩ o tɩntʋŋna balʋ o na kuri tɩn dɩ Wɛ Joro dam, yɩ o brɩ-ba ba na maŋɩ sɩ ba kɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","O tʋʋnɩ dɩm kwaga nɩ o ma joori o ba o brɩ o tɩtɩ o nɔɔna bam tee nɩ kuni zanzan, sɩ kʋ brɩ-ba lanyɩranɩ nɩ o sɩɩnɩ o bi o yagɩ tʋʋnɩ. O dɛɛn brɩ o tɩtɩ o tɩntʋŋna bam da fiinna mʋ, yɩ o ŋɔɔnɩ Wɛ paarɩ dɩm taanɩ o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dɛ dɩdwɩ Zezi na wʋra o brɩ-ba kʋntʋ tɩn, o ma kaanɩ-ba o wɩ, ba yɩ zaŋɩ ba nuŋi Zeruzalɛm wʋnɩ, sɩ ba taa cǝgi wʋlʋ wʋm o Ko na goni ni sɩ o ba ba te tɩn, nɩ o na maŋɩ o ta dɩ ba te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zezi ma ta dɩ ba o wɩ: «Zan dɛɛn yǝni o miisi nɔɔna na wʋnɩ mʋ, da fɩnfɩɩn nan na wǝli da, Wɛ wʋ́ miisi abam DƖ Joro kʋm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zezi dɩ o tɩntʋŋna bam dɛɛn na kikili daanɩ kʋntʋ tɩn, ba ma bwe-o ba wɩ: «Dɩbam Yuutu, kʋ yɩ lele kʋntʋ mʋ n lagɩ n pa dɩbam Yisɩrayɛlɩ tiinǝ bam joori dɩ́ di paarɩ na?» ");
INSERT INTO xsm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Zezi ma lǝri-ba o wɩ: «Kʋ daɩ sɩ abam lwarɩ maŋa kalʋ Wɛ na lɩ dɩdaanɩ DƖ tɩtɩ ni sɩ wǝǝnu tɩntʋ kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wɛ Joro kʋm nan wʋ́ ba abam yuu nɩ kʋ pa á joŋi dam dɩlʋ na nuŋi Wɛ tee nɩ tɩn. Abam laan wʋ́ ji a maana tiinǝ sɩ á brɩ nɔɔna amʋ cɩga kam je maama nɩ, kʋ na sɩŋɩ dɩ Zeruzalɛm dɩ Zude dɩ Samari tɩɩnɩ dɩm maama, dɩ lʋgʋ baŋa je maama nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zezi dɛɛn na ŋɔɔnɩ kʋntʋ dɩ ba o ti tɩn, o ma zaŋɩ o maa diini Wɛ-sɔŋɔ, yɩ ba zɩgɩ ba nii-o. Kunkwǝǝnu ma ba tɩ kwǝl-o kʋ pa ba daa warɩ ba na-o. ");
INSERT INTO xsm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","O na maa diini kʋntʋ tɩn, ba daa ta ma kwǝni ba nii wɛyuu nɩ. Ba na zɩgɩ ba nii kʋntʋ tɩn, nɔɔna bale ma da ba ba ba zɩgɩ ba tee nɩ. Ba zʋ gwar-pwǝǝnu mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ba ma ta dɩ ba ba wɩ: «Galile tiinǝ-ba, bɛɛ mʋ yɩ á zɩgɩ yoba á kwǝni á nii wɛɛnɩ? Abam na nɛ kʋlʋ tɩn, kʋ yɩ Wɛ mʋ kwe Zezi DƖ ja di DƖ sɔŋɔ. Wʋntʋ tɩtɩ nan ta wʋ́ joori o ba kʋntʋ doŋ, nɩ abam na nɛ-o o na maa diini te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Zezi tɩntʋŋna bam laan ma zɩgɩ piu kʋm ba ya na wʋ kʋ yuu nɩ tɩn, ba joori ba vu Zeruzalɛm tɩʋ kʋm wʋ. Piu kʋm kʋntʋ yɩrɩ mʋ Olivi piu, yɩ kʋ batwarɩ dɩdaanɩ tɩʋ kʋm nɩnɛɛnɩ kilomɛtrɩ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ba ma vu ba zʋ tɩʋ kʋm ba kɛ ba vu sɔŋɔ kʋlʋ ba na maŋɩ ba zʋʋrɩ da tɩn, ba di wɛyuu digǝ kam. Nɔɔna bam kʋntʋ yɩ Pɩyɛɛrɩ dɩ Zan dɩ Zakɩ dɩ Andre, kʋ wǝli dɩ Filipi dɩ Toma, dɩdaanɩ Batelemi dɩ Matiyu, kʋ wǝli dɩ Zakɩ wʋlʋ na yɩ Alɩfɩ bu tɩn, dɩ Simɔn wʋlʋ na yɩ Zelɔtɩ nɔɔna bam wʋ nɔɔnʋ tɩn, dɩdaanɩ Zudasɩ wʋlʋ na yɩ Zakɩ bu tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maŋa maama bantʋ dɛɛn yǝni ba wʋ daanɩ dɩ wʋbʋŋ-dɩdwɩ mʋ, yɩ ba warɩ Wɛ. Kaana badonnǝ dɩdaanɩ Zezi nu Mari dɩ Zezi nyaana dɩ tɔgɩ ba wʋra dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dɛ dɩdwɩ balʋ maama na yɩ ko-biǝ Zezi ŋwaanɩ tɩn ma kikili daanɩ jǝgǝ dɩdʋa, ba yi nɩ nɔɔna bi dɩ fiinle (120). Ba na wʋra kʋntʋ tɩn, Pɩyɛɛrɩ ma zaŋɩ ba wʋnɩ o zɩgɩ wɛɛnɩ sɩ o ŋɔɔnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","O maa wɩ: «A ko-biǝ-ba, kʋ na yɩ Zudasɩ wʋlʋ na brɩ Zezi dʋna bam cwǝŋǝ sɩ ba ja-o tɩn, Wɛ Joro kʋm dɛɛn maŋɩ kʋ pa Pɛ Davidi ŋɔɔnɩ wʋntʋ taanɩ faŋa faŋa. Kʋlʋ na pʋpʋnɩ kʋ tiŋi Wɛ tɔnɔ kʋm wʋnɩ wʋntʋ ŋwaanɩ tɩn mʋ maŋɩ sɩ kʋ ba kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zudasɩ dɛɛn tɔgɩ o wʋ dɩbam kɔgɔ kʋm wʋnɩ mʋ, yɩ o tɔgɩ o tʋŋɩ Wɛ tɩtʋŋa yam.» ");
INSERT INTO xsm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Zudasɩ na kɩ te tɩn, o dɛɛn kwe sǝbu kʋlʋ o na joŋi o kǝm-balɔrɔ kʋm baŋa nɩ tɩn o ma yǝgi tɩga mʋ. O daarɩ o tʋ tɩga nɩ o tɩ. O pugǝ ma bagɩ yɩ o lʋrʋ pi tɩ nuŋi. ");
INSERT INTO xsm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nɔɔna balʋ maama na zʋʋrɩ Zeruzalɛm nɩ tɩn ma ni kʋlʋ na kɩ-o tɩn, kʋntʋ ŋwaanɩ mʋ ba bǝŋi tɩga kam kʋntʋ nɩ Akɩlɩdama dɩ ba tɩtɩ taanɩ. Kʋ kuri mʋ Jana tɩga. ");
INSERT INTO xsm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pɩyɛɛrɩ ta ma ta o wɩ: «Kʋ nan pʋpʋnɩ Wɛ lǝŋ-ŋwɩ tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Wɛ wʋ́ pa wʋntʋ sɔŋɔ kʋm ba kʋ cɔgɩ, sɩ nɔɔn-nɔɔnʋ daa yɩ daarɩ kʋ wʋnɩ.› Kʋ daa ta pʋpʋnɩ kʋ wɩ: ‹Wɛ wʋ́ pa nɔɔnʋ wʋdoŋ lǝni wʋntʋ yuu nɩ o taa tʋŋɩ o tɩtʋŋa yam.› ");
INSERT INTO xsm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kʋ nan maŋɩ sɩ nɔɔnʋ wǝli dɩbam Zezi tɩntʋŋna bam wʋnɩ o ji maana tu, sɩ o taa ŋɔɔnɩ dɩ́ Yuutu Zezi cɩga kam dɩ o na bi o yagɩ tʋʋnɩ te tɩn. Kʋntʋ tu nan maŋɩ sɩ o taa yɩ wʋlʋ dɛɛn na tɔgɩ o wʋ dɩbam kɔgɔ kʋm wʋnɩ maŋa maama dɩ́ Yuutu Zezi dɛɛn na tɔgɩ dɩ dɩbam o beeri tɩn mʋ, kʋ sɩŋɩ maŋa kam Zan na miisi Zezi na wʋnɩ tɩn, sɩ kʋ vu kʋ yi maŋa kam Zezi na yagɩ dɩbam te yɩ o di Wɛ-sɔŋɔ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pɩyɛɛrɩ na tagɩ kʋntʋ o ti tɩn, ba ma lɩ nɔɔna bale. Dɩdʋa mʋ yɩ Zʋzɛfʋ wʋlʋ ba na bǝ nɩ Basaba yɩ ba daa ta bǝ-o nɩ Zusitu tɩn. Wʋdoŋ wʋm maa yɩ Matɩasɩ. ");
INSERT INTO xsm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ba laan ma loori Wɛ ba wɩ: «Dɩ́ Yuutu, nmʋ maŋɩ n ye nɔɔnʋ maama wʋbʋŋa na yɩ te tɩn. Kʋntʋ ŋwaanɩ dɩ́ loori nmʋ tee nɩ sɩ n brɩ dɩbam nɔɔna bantʋ bale wʋnɩ nmʋ na kuri wʋlʋ sɩ o ji nmʋ tɩntʋŋnʋ tɩn, ");
INSERT INTO xsm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sɩ o taa tʋŋɩ tɩtʋŋa yalʋ Zudasɩ na kwe o yagɩ yɩ o daarɩ o vu o na maŋɩ sɩ o vu mɛ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba na loori Wɛ ba ti tɩn, ba ma ta jɔrɔ sɩ ba kuri nɔɔna bale bam kʋntʋ wʋnɩ. Ba na tagɩ ba kuri wʋlʋ tɩn mʋ yɩ Matɩasɩ. Ba laan ma pa o tɔgɩ o yɩ Zezi tɩntʋŋnʋ o wǝli ba fugǝ-dɩdʋa kam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dɛ dɩm Zwifǝ bam na yǝni ba di ba candiǝ kalʋ yɩrɩ na yɩ Pantɩkoti tɩn ma ba ka yi. Zezi karabiǝ bam maama maa wʋ daanɩ jǝgǝ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sɔɔ ma da kʋ nuŋi wɛyuu nɩ nɩnɛɛnɩ vu-dɩʋ na fufugi te tɩn. Sɔŋɔ kʋm ba na je kʋ wʋnɩ tɩn maama ma su dɩ sɔɔ kʋm kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ba ma na wǝǝnu nɩ min-vwɩ te, yɩ tɩ pwɛ pwɛ tɩ jǝni ba dɩdʋa dɩdʋa yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wɛ Joro kʋm ma ba ba maama tee nɩ dɩ dam, yɩ ba sɩŋɩ sɩ ba taa ŋɔɔnɩ taana dwi dwi, nɩnɛɛnɩ Wɛ Joro kʋm na pɛ-ba dam sɩ ba ŋɔɔnɩ taanɩ dɩlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kantʋ maŋa kam nɩ, Zwifǝ zanzan dɛɛn mʋ tu ba wʋ tɩʋ kʋm nɩ. Ba maa yɩ balʋ na kwarɩ Wɛ lanyɩranɩ tɩn, yɩ ba nuŋi je maama mʋ lʋgʋ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Balʋ na wʋra tɩn dɛɛn ma ni sɔɔ kʋm na kɩ te tɩn, yɩ kɔgɔ zanzan laan ma ba kʋ la daanɩ jǝgǝ kam nɩ. Ba ma ni Zezi karabiǝ bam na zɩgɩ ba ŋɔɔnɩ taana dwi dwi. Kʋ ma sʋ-ba, bɛŋwaanɩ ba maama dɛɛn ni Zezi karabiǝ bam na ŋɔɔnɩ ba dɩdʋa dɩdʋa dwi taanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ba yɩra ma sɔɔrɩ yɩ kʋ kɩ-ba yǝǝu. Ba ma ta ba wɩ: «Nii, bantʋ maama yɩ Galile tiinǝ mʋ, yɩ ba zɩgɩ ba ŋɔɔnɩ taana yantʋ doŋ. ");
INSERT INTO xsm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kʋ nan kɩ ta mʋ yɩ dɩbam maama ni ba na ŋɔɔnɩ dɩbam dɩdʋa dɩdʋa dwi taanɩ? ");
INSERT INTO xsm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dɩbam nuŋi je dwi tǝri tǝri mʋ. Dɩbam badonnǝ nuŋi Parɩtɩ dɩ Meedi dɩ Elam, kʋ wǝli dɩ Mesopotami dɩ Zude dɩ Kapadɔsɩ, dɩdaanɩ Pɔn dɩ Azi tɩɩnɩ dɩm maama. ");
INSERT INTO xsm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Dɩ́ badonnǝ dɩ ma nuŋi Friizi dɩ Pamfili dɩ Ezipi dɩ Liibi tɩɩnɩ dɩlʋ na batwarɩ dɩ Sirɛɛnɩ tɩn. Dɩ́ badonnǝ maa nuŋi Rom. ");
INSERT INTO xsm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Dɩbam yɩ Zwifǝ mʋ, kʋ wǝli dɩ dwi-gɛ tiinǝ balʋ na tɔgɩ cullu tɩlʋ Wɛ na pɛ dɩbam Zwifǝ bam tɩn. Dɩbam badonnǝ maa nuŋi Krɛtɩ dɩ Arabi. Dɩ kʋntʋ dɩ, dɩbam maama nan ta ni ba na maɩ dɩbam dɩdʋa dɩdʋa dwi taanɩ ba ŋɔɔnɩ wo-kamunnu tɩlʋ Wɛ na kɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nɔɔna bam na yɩ yǝǝu yɩ ba wʋbʋŋa vugimi daanɩ kʋntʋ tɩn, ba maa bwe daanɩ ba wɩ: «Kǝm dɩntʋ kuri mʋ bɛɛ?» ");
INSERT INTO xsm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ba badaara laan maa jɩgɩ Zezi tɩntʋŋna bam ba mwana, yɩ ba tɛ ba wɩ: «Nɔɔna bantʋ nyɔgɩ sana mʋ ba su.» ");
INSERT INTO xsm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pɩyɛɛrɩ laan ma zaŋɩ wɛɛnɩ dɩdaanɩ o donnǝ fugǝ-dɩdʋa kam. O ma ŋɔɔnɩ dɩ kwǝr-dɩa o ta dɩ nɔn-kɔgɔ kʋm o wɩ: «A badonnǝ-ba, Zwifǝ-ba dɩ abam balʋ maama na zʋʋrɩ Zeruzalɛm nɩ tɩn, cǝgi-na sɩ a ta kǝm dɩntʋ kuri a brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abam na bʋŋɩ nɩ nɔɔna bantʋ nyɔgɩ sana mʋ ba su tɩn, kʋ nan daɩ kʋntʋ. Kʋ daa ta yɩ tɩtɩɩtɩ mʋ, wɩa ta wʋ bɩgɩ sɩ ba nyɔ sana. ");
INSERT INTO xsm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kʋ nan yɩ kʋlʋ Wɛ nijoŋnu Zʋwɛlɩ dɛɛn na ŋɔɔnɩ kʋ taanɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","O tagɩ sɩ Baŋa-Wɛ wɩ: ‹Lʋgʋ tiim maŋa na yiǝ, amʋ wʋ́ pwǝri a Joro kʋm sɩ kʋ taa wʋ nabiinǝ maama tee nɩ. Kʋntʋ nan wʋ́ pa abam biǝ dɩ á bukwa ŋɔɔnɩ amʋ yiyiu-ŋwɛ. Aá pa abam nɔn-dʋnnʋ na vɩɩrɩm, kʋ daarɩ sɩ á nankwɩn dwɛ dɩndwɩa. ");
INSERT INTO xsm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kʋ yɩ cɩga sɩ da yam kʋntʋ nɩ, kʋ na yɩ a tɩntʋŋ-baara dɩ kaana dɩ, aá pwǝri a Joro kʋm a pa ba maama, sɩ ba ŋɔɔnɩ amʋ yiyiu-ŋwɛ. ");
INSERT INTO xsm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","A ta wʋ́ pa wo-kɩnkagɩla taa kɩ wɛyuu nɩ, yɩ a daarɩ a kɩ wǝǝnu tɩlʋ na brɩ a dam tɩn tɩga baŋa nɩ. Kantʋ maŋa kam nɩ jana wʋ́ ta wʋra dɩ mini dɩ nyʋa kalʋ na tiini ka zwǝrǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wɩa kam wʋ́ ji lim, yɩ cana kam dɩ wʋ́ ji nasʋŋʋ nɩ jana te, kʋ na wʋ́ loori sɩ amʋ Baŋa-Wɛ sarɩya dɛ kamunu kʋlʋ na jɩgɩ zulǝ ba dɩ yi tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dɛ dɩm kʋntʋ nɩ, wʋlʋ maama na wʋ́ bǝŋi dɩ́ Yuutu yɩrɩ o ma loori zǝnǝ tɩn, oó na vrɩm.› ");
INSERT INTO xsm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","A badonnǝ Yisɩrayɛlɩ tiinǝ-ba, cǝgi-na a na lagɩ a ta kʋlʋ tɩn. A lagɩ a ta Zezi wʋlʋ na yɩ Nazarɛtɩ tu tɩn taanɩ mʋ a brɩ abam. Baŋa-Wɛ tagɩ wʋntʋ ŋwaanɩ mʋ DƖ kɩ wo-kamunnu dɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ DƖ dam tɩn, sɩ kʋ brɩ abam nɩ o sɩɩnɩ o nuŋi wʋm Baŋa-Wɛ te mʋ. Abam tɩtɩ maŋɩ á ye kʋntʋ, bɛŋwaanɩ wǝǝnu tɩm kʋntʋ maŋɩ tɩ kɩ abam tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wɛ maŋɩ DƖ ye kʋ na wʋ́ ta yɩ te tɩn. DƖ dɛɛn ma lɩ wʋbʋŋa sɩ abam ja Zezi á kɩ nɔn-balwaarʋ jɩŋa nɩ, sɩ ba pa-o tʋʋn-dagara baŋa nɩ. Á kɩ kʋntʋ mʋ á ma á gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wɛ nan mʋ bi-o DƖ pa o yagɩ tʋʋnɩ. DƖ ma joŋ-o tʋʋnɩ yaara yam wʋnɩ DƖ yagɩ. Bɛŋwaanɩ tʋʋnɩ dɛɛn wʋ wanɩ dɩ cǝŋ-o dɩ yagɩ yibeeli dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Faŋa faŋa tɩn, Pɛ Davidi dɛɛn tagɩ wʋntʋ taanɩ o wɩ: ‹A naɩ a Yuutu Wɛ a yigǝ nɩ maŋa maama. DƖ wʋ a jazɩm nɩ, sɩ DƖ zǝni-nɩ sɩ a yɩ tʋ. ");
INSERT INTO xsm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mʋ kʋ kuri a jɩgɩ wʋpolo lanyɩranɩ, yɩ a ni-taanɩ dɩ jɩgɩ ywǝǝni. Dɩ a yɩra bwǝni dɩm maama a nan ta jɩgɩ tɩɩna nmʋ Wɛ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bɛŋwaanɩ, a na tɩga, nmʋ Baŋa-Wɛ bá yagɩ-nɩ sɩ a maŋɩ curu nɩ. Nmʋ bá sɛ sɩ n tɩtɩ Wʋ-poŋo Tu wʋm yɩra pɔ. ");
INSERT INTO xsm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nmʋ pɛ a lwarɩ cwe sɩlʋ na yɩ ŋwɩa cwe tɩn sɩ a taa tɔga. Nmʋ wʋ́ pa a na ywǝǝni zanzan nmʋ tee nɩ.› ");
INSERT INTO xsm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","A ko-biǝ-ba, mʋ kʋlʋ dɩbam nabaarʋ Davidi dɛɛn na tagɩ tɩn. A nan lagɩ a ŋɔɔnɩ wʋntʋ taanɩ mʋ jaja a brɩ abam nɩ o tɩga, yɩ ba kwe-o ba kɩ. O yibeeli ta wʋra dɩ zɩm maama. ");
INSERT INTO xsm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","O dɛɛn nan yɩ Wɛ nijoŋnu mʋ, yɩ o guli Wɛ na goni ni DƖ pa-o DƖ wɩ, DƖ wʋ́ pa o dwi tiinǝ bam dɩdʋa zaŋɩ o di paarɩ o jǝŋǝ kam je nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi nan maŋɩ o da yigǝ o lwarɩ kʋlʋ Wɛ na wʋ́ kɩ tɩn. Kʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn tʋʋnɩ biim woŋo mʋ o tagɩ o wɩ: ‹Wɛ wʋ sɛ sɩ DƖ yag-o curu nɩ. O yɩra yam dɩ nan wʋ pɔgɩ.› ");
INSERT INTO xsm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Cɩga tɩn, Baŋa-Wɛ mʋ joori DƖ pa Zezi wʋlʋ a ya na tagɩ tɩn ŋwɩa, yɩ dɩbam maama yɩ maana tiinǝ dɩ́ brɩ nɔɔna cɩga kam kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Wɛ na bi-o tɩn, DƖ zǝŋ-o DƖ jǝni DƖ jazɩm nɩ. Zezi laan ma joŋi Wɛ Joro kʋm o Ko Wɛ tee nɩ, nɩ Wɛ na maŋɩ DƖ go ni sɩ DƖ wʋ́ pa-o te tɩn, yɩ o pwǝri-kʋ dɩbam baŋa nɩ. Mʋ kʋlʋ abam zɩm na naɩ yɩ á kwǝri á ni tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kʋ daɩ Davidi tɩtɩ mʋ diini Wɛ-sɔŋɔ. Wʋntʋ nan tagɩ o wɩ: ‹Yuutu Baŋa-Wɛ tagɩ dɩ a Yuutu DƖ wɩ: Ba n jǝni a jazɩm nɩ, ");
INSERT INTO xsm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sɩ aá kɩ nmʋ dʋna maama n nɛ kuri nɩ, sɩ n nɔ-ba nɩ tɩga te.› ");
INSERT INTO xsm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kʋntʋ tɩn, Yisɩrayɛlɩ dwi maama nan maŋɩ sɩ ba lwarɩ lanyɩranɩ nɩ, Zezi wʋlʋ abam na pagɩ tʋʋn-dagara baŋa nɩ á gʋ tɩn, kʋ yɩ wʋntʋ tɩtɩ nɔ́ɔ mʋ Wɛ laan pɛ sɩ o taa yɩ Krisi wʋm, yɩ o kwǝri o yɩ dɩbam Yuutu.» ");
INSERT INTO xsm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nɔɔna bam na ni Pɩyɛɛrɩ na tagɩ kʋlʋ kʋntʋ tɩn, kʋ ma tiini kʋ cɔgɩ ba wʋrʋ zanzan. Ba ma bwe Pɩyɛɛrɩ dɩ Zezi tɩntʋŋna badonnǝ bam ba wɩ: «Dɩ́ ko-biǝ-ba, dɩ́ nan wʋ́ kɩ ta mʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pɩyɛɛrɩ ma lǝri-ba o wɩ: «Abam maama maŋɩ sɩ á lǝni á wʋrʋ á yagɩ kǝm-balwaarʋ tɩm, sɩ á daarɩ á pa ba miisi abam na wʋnɩ Zezi Krisi yɩrɩ ŋwaanɩ, sɩ Wɛ wʋ́ yagɩ á lwarɩm DƖ ma cɛ abam. Wɛ laan wʋ́ pa DƖ Joro kʋm taa wʋ abam tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mʋ Wɛ na goni ni sɩ DƖ kɩ te tɩn. DƖ goni ni dɩntʋ DƖ pa abam dɩ á biǝ, kʋ wǝli dɩ balʋ maama na baŋwɛ tɩn. Kʋ yɩ balʋ maama dɩbam Yuutu Baŋa-Wɛ na wʋ́ bǝŋi sɩ ba taa tɔg-o tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pɩyɛɛrɩ ma joori o fɔgɩ o ma bɩtarɩ dwi dwi o brɩ-ba Wɛ cɩga kam, yɩ o kaanɩ-ba o wɩ: «Sɛ-na sɩ Baŋa-Wɛ vrɩ abam zɩm nɔn-balwaarʋ tɩm tɩtarɩ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɔɔna bam zanzan ma sɛ o taanɩ dɩm, yɩ ba daarɩ ba pa ba miisi-ba na wʋnɩ Wɛ ŋwaanɩ. Dɛ dɩm kʋntʋ nɩ nɔɔna zanzan mʋ tu ba zʋ ba wǝli Zezi karabiǝ kɔgɔ kʋm wʋnɩ, ba yi nɩnɛɛnɩ nɔɔna mʋrr-tɩtɔ (3.000) te. ");
INSERT INTO xsm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ba ma tiini ba kwaanɩ ba pa Zezi tɩntʋŋna bam brɩ-ba Wɛ cwǝŋǝ kam. Ba maama maa wǝli daanɩ dɩ ni dɩdʋa, yɩ ba kwǝri ba tɔgɩ daanɩ ba di wʋdiu nɩ Zezi dɛɛn na fɔgɩ dɩpɛ dɩm o pa o karabiǝ bam yɩ ba di te tɩn. Ba ma kwǝri ba tɔgɩ daanɩ ba warɩ Wɛ maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Fʋʋnɩ ma zʋ nɔɔna bam maama, bɛŋwaanɩ Wɛ dɛɛn pɛ Zezi tɩntʋŋna bam kɩ wo-kɩnkagɩla dɩ wǝǝnu zanzan na brɩ Baŋa-Wɛ dam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Zezi karabiǝ bam maama dɛɛn yǝni ba wʋ jǝgǝ dɩdʋa mʋ, yɩ wǝǝnu tɩlʋ ba na jɩgɩ tɩn yɩ ba maama nyɩm. ");
INSERT INTO xsm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ba maa yǝni ba kwe ba jɩjɩgɩrʋ dɩ ba zɩla ba yǝgǝ, yɩ ba maŋɩ tɩ sǝbu kʋm ba pa daanɩ, kʋ maŋɩ nɩ nɔɔnʋ maama na lagɩ zǝnǝ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dɛ maama ba yǝni ba la daanɩ Wɛ-di-kamunu kʋm wʋnɩ. Ba ma tɔgɩ daanɩ ba di wʋdiu da sam nɩ, kʋ nyɩ dɩ Zezi dɛɛn na fɔgɩ dɩpɛ o pa karabiǝ bam te tɩn. Ba maa maŋɩ ba wʋdiiru ba pa daanɩ, yɩ ba jɩgɩ wʋpolo lanyɩranɩ dɩdaanɩ wʋbʋŋ-dɩdwɩ. ");
INSERT INTO xsm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ba maa zuli Wɛ maŋa maama, yɩ ba jɩgɩ zulǝ nɔɔna maama yibiyǝ nɩ. Dɛ maama dɩ́ Yuutu wʋm maa paɩ balʋ na nɛ vrɩm tɩn tui ba wǝli ba kɔgɔ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dɛ dɩdwɩ mʋ Pɩyɛɛrɩ dɩ Zan dɛɛn zaŋɩ ba vu Wɛ-di-kamunu kʋm, maŋa kalʋ nɔɔna na yǝni ba ve ba warɩ Wɛ tɩn. Kʋ yɩ wɛ-gunim maŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ba ma vu ba yi digǝ kam ni dɩlʋ ba na bǝ nɩ Ni-laa tɩn. Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩ kɔrɔ mʋ kʋ na puli o lʋra kam maŋa nɩ. O nɔɔna maa yǝni ba zɩŋ-o ba vu ba jǝni da dɛ maama, sɩ o taa loori sǝbiǝ nɔɔna balʋ na tui ba tɔgɩ da ba zʋ Wɛ-di-kamunu kʋm wʋ tɩn tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nɔɔnʋ wʋm ma na Pɩyɛɛrɩ dɩ Zan na maa zʋʋrɩ Wɛ-digǝ kam. O ma loori-ba sɩ ba pa-o woŋo. ");
INSERT INTO xsm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ba ma nii-o ziin. Pɩyɛɛrɩ laan ma ta dɩd-o o wɩ: «Nii dɩbam seeni.» ");
INSERT INTO xsm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O ma sɩɩnɩ o nii-ba yɩ o jɩgɩ tɩɩna sɩ baá pa-o woŋo. ");
INSERT INTO xsm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pɩyɛɛrɩ ma ta dɩd-o o wɩ: «A ba jɩgɩ sǝbu sɩ a pa-m. A nan wʋ́ pa nmʋ a na jɩgɩ kʋlʋ tɩn. Dɩ Nazarɛtɩ tu Zezi Krisi yɩrɩ ŋwaanɩ, zaŋɩ n ta n veǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pɩyɛɛrɩ na tagɩ kʋntʋ tɩn, o laan ma ja o jazɩm o zǝn-o o pa o zaŋɩ wɛɛnɩ. O na zaŋɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ o nɛ sɩm dɩ o nakwǝǝlu tɩm maama kɩ dam lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nɔɔnʋ wʋm ma faŋɩ wɛɛnɩ o joori o ba o cwi o nɛ baŋa nɩ yɩ o sɩŋɩ vǝŋǝ. O ma tɔgɩ-ba o zʋ Wɛ-di-kamunu kʋm wʋ. O maa veǝ yɩ o faŋa wɛɛnɩ yɩ o zuli Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nɔn-kɔgɔ kʋm ma na o na veǝ yɩ o zuli Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ba ma lwarɩ nɩ nɔɔnʋ wʋm kʋntʋ mʋ yɩ looru wʋlʋ ya na je Wɛ-di-kamunu kʋm Ni-laa kʋm nɩ tɩn. Kʋ ma tiini kʋ sɔɔrɩ-ba, yɩ kʋ kɩ-ba yǝǝu dɩ kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nɔɔnʋ wʋm ma yɔɔrɩ o mǝǝli Pɩyɛɛrɩ dɩ Zan. Nɔɔna bam maama maa yɩ yǝǝu. Ba ma zaŋɩ ba duri ba vu ba te, kʋnkɔlɔ kʋlʋ na jɩgɩ pwǝŋǝ yɩ ba maa bǝ nɩ Salɔmɔn kʋnkɔlɔ tɩn nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pɩyɛɛrɩ na nɛ nɔɔna bam kʋntʋ tɩn, o ma ta dɩ ba o wɩ: «A badonnǝ Yisɩrayɛlɩ tiinǝ-ba, bɛŋwaanɩ mʋ yɩ abam yɩ yǝǝu dɩ kʋlʋ na kɩ tɩn? Bɛɛ mʋ yɩ abam yɔɔrɩ á nii dɩbam kʋntʋ? Abam bʋŋɩ sɩ kʋ yɩ dɩbam tɩtɩ dam mʋ pɛ o zaŋɩ o ve na? Á bʋŋɩ nɩ kʋ yɩ dɩbam na kwarɩ Wɛ lanyɩranɩ tɩn ŋwaanɩ mʋ pɛ o zaŋɩ o ve na? ");
INSERT INTO xsm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kʋ nan na yɩ te tɩn, dɩbam nabaara Abraham dɩ Yizakɩ dɩ Zakɔbɩ Baŋa-Wɛ laan mʋ pɛ DƖ tɩntʋŋnʋ Zezi joŋi paarɩ dɩ zulǝ. Abam jaanɩ wʋntʋ mʋ á pa ba gʋ-o. Pilatɩ dɛɛn bʋŋɩ sɩ o yag-o yɩ abam wʋ sɛ. ");
INSERT INTO xsm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Zezi Krisi yɩ wʋ-poŋo tu mʋ dɩ cɩga tu. Abam nan vɩ-o, yɩ á daarɩ á loori Pilatɩ sɩ o yagɩ nɔn-gʋrʋ mʋ o pa abam. ");
INSERT INTO xsm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Abam na kɩ te tɩn, á gʋ wʋlʋ na yɩ ŋwɩa tu tɩn mʋ, yɩ Wɛ joori DƖ bi-o DƖ pa o yagɩ tʋʋnɩ. Dɩbam yɩ maana tiinǝ dɩ́ brɩ nɔɔna cɩga kam kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kʋ yɩ Zezi Krisi yɩrɩ dam dɩm ŋwaanɩ, dɩ dɩ́ na kɩ dɩ́ wʋ-dɩdʋa dɩd-o tɩn mʋ pɛ nɔɔnʋ wʋlʋ abam na nɛ yɩ á ye tɩn na dam. Kʋ yɩ o na kɩ o wʋ-dɩdʋa dɩ Zezi tɩn mʋ pɛ o na yazurǝ abam maama yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","A ko-biǝ-ba, abam dɩ á yigǝ tiinǝ bam na kɩ Zezi te tɩn, a ye nɩ abam ya yǝri woŋo kʋlʋ á na kɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Faŋa faŋa tɩn, Wɛ dɛɛn pɛ DƖ nijoŋnǝ bam maama tɔɔlɩ DƖ kwǝrǝ ba brɩ nɔɔna nɩ Krisi wʋm DƖ na tʋŋɩ tɩn maŋɩ sɩ o yaarɩ mʋ. Abam na kɩ-o te tɩn mʋ pɛ Wɛ taanɩ dɩm sɩɩnɩ dɩ kɩ. ");
INSERT INTO xsm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kʋntʋ ŋwaanɩ, nan lǝni-na á wʋrʋ á yagɩ kǝm-balwaarʋ, sɩ á daarɩ á pipiri á taá tɔgɩ Wɛ, sɩ Wɛ wʋ́ yagɩ á lwarɩm DƖ ma cɛ abam. ");
INSERT INTO xsm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kʋntʋ tɩn, dɩ́ Yuutu Baŋa-Wɛ wʋ́ pa abam wʋrʋ taa zurǝ maŋa dɩ maŋa, yɩ DƖ daarɩ DƖ tʋŋɩ Krisi wʋm DƖ na maŋɩ DƖ kuri sɩ DƖ pa abam tɩn. Wʋntʋ mʋ yɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","O maŋɩ sɩ o taa wʋ Wɛ-sɔŋɔ nɩ mʋ, sɩ kʋ taa ve maŋa kalʋ Wɛ na wʋ́ fɔgɩ DƖ kwɛ wǝǝnu maama tɩn, nɩ Wɛ na maŋɩ DƖ pa DƖ nijoŋnǝ bam tɔɔlɩ DƖ kwǝrǝ faŋa faŋa te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kʋ yɩ nɩnɛɛnɩ Moyisi dɛɛn na tagɩ o wɩ: ‹Abam Yuutu Baŋa-Wɛ wʋ́ pa abam dwi tu dɩdʋa mʋ zaŋɩ o taa yɩ Wɛ nijoŋnu abam tɩtarɩ nɩ, nɩ DƖ na tʋŋɩ amʋ Moyisi te tɩn. Wʋntʋ nan na tuǝ, abam maŋɩ sɩ á sɛ taanɩ dɩlʋ maama o na wʋ́ ta o brɩ abam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wʋlʋ maama nan na wʋ sɛ kʋlʋ Wɛ nijoŋnu wʋm na wʋ́ brɩ tɩn, ba maŋɩ sɩ ba lɩ kʋ tu mʋ Wɛ nɔɔna bam wʋnɩ ba gʋ.› Mʋ kʋlʋ Moyisi dɛɛn na tagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kʋ na puli dɩ Samʋwɛlɩ dɩ balʋ maama na saŋɩ o kwaga tɩn, Wɛ nijoŋnǝ balʋ maama na tɔɔlɩ Wɛ kwǝrǝ tɩn dɛɛn brɩ kʋlʋ na wʋ́ kɩ da yantʋ wʋnɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Wɛ kwǝrǝ kam DƖ dɛɛn na pɛ DƖ nijoŋnǝ bam sɩ ba tɔɔlɩ tɩn yɩ abam ŋwaanɩ mʋ. Wɛ ni dɩm DƖ dɛɛn na goni DƖ pa dɩbam nabaara bam tɩn dɩ daa ta yɩ abam ŋwaanɩ mʋ. DƖ dɛɛn goni ni dɩ Abraham DƖ wɩ: ‹Nmʋ dwi dɩm ŋwaanɩ amʋ wʋ́ kɩ lʋgʋ baŋa dwi tiinǝ maama lanyɩranɩ.› ");
INSERT INTO xsm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kʋntʋ ŋwaanɩ Baŋa-Wɛ dɛ yigǝ DƖ tʋŋɩ DƖ tɩntʋŋnʋ wʋm abam tee nɩ mʋ, sɩ o kɩ abam lanyɩranɩ dɩ o na pa abam dɩdʋa dɩdʋa yagɩ á kǝm-balwaarʋ tɩm.» ");
INSERT INTO xsm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pɩyɛɛrɩ dɩ Zan dɛɛn na wʋra ba ŋɔɔnɩ kʋntʋ doŋ ba brɩ nɔɔna bam tɩn, Zwifǝ bam kaanɩm tiinǝ dɩdaanɩ Wɛ-di-kamunu kʋm yɩrɩna bam yigǝ tu wʋm dɩ Sadusɩan tiinǝ badonnǝ ma zaŋɩ ba ba ba te. ");
INSERT INTO xsm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ba bana tiini ya zaŋɩ dɩ Pɩyɛɛrɩ dɩ Zan dɩ ba na ŋɔɔnɩ te ba wɩ, Zezi bi o yagɩ tʋʋnɩ, yɩ kʋntʋ brɩ nɩ twa dɩ wʋ́ wanɩ ba bi ba yagɩ tʋʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ba ma ja Pɩyɛɛrɩ dɩ Zan ba kɩ pɩɩna digǝ nɩ. Tɩga na yi tɩn ŋwaanɩ, ba ma yagɩ-ba da sɩ tɩga pʋʋrɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kʋ daarɩ kɔgɔ kʋm nɔɔna zanzan ma sɛ taanɩ dɩlʋ ba na ni tɩn, yɩ ba kɩ ba wʋ-dɩdʋa dɩ Zezi. Balʋ na sɛ tɩn kɔgɔ kʋm dɛɛn yɩ nɩnɛɛnɩ nɔɔna mʋrr-tɩnu (5.000). ");
INSERT INTO xsm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tɩga na pʋʋrɩ tɩn, Zwifǝ yigǝ tiinǝ bam dɩ ba nakwa bam dɩ ba cullu karanyɩna tiinǝ bam ma la daanɩ Zeruzalɛm nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ba ma jeeri dɩdaanɩ Annɩ wʋlʋ na yɩ ba kaanɩm yuutu tɩn, dɩ Kayifu dɩ Zan dɩ Alɛsandrɩ, dɩ balʋ na tɔgɩ ba yɩ kaanɩm yuutu wʋm sɔŋɔ tiinǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ba ma pa Pɩyɛɛrɩ dɩ Zan ba ba zɩgɩ ba yigǝ nɩ. Ba ma bwe-ba ba wɩ: «Kʋ yɩ dɩ bɛɛ dam mʋ, dɩ wɔɔ yɩrɩ ŋwaanɩ mʋ, abam mɛ á kɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wɛ Joro kʋm laan ma ba Pɩyɛɛrɩ te dɩ dam. O ma lǝri-ba o wɩ: «Tɩʋ kʋm yigǝ tiinǝ dɩ nakwa-ba, ");
INSERT INTO xsm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","abam zɩm na bwe dɩbam kʋlʋ taanɩ tɩn, kʋ na yɩ dɩbam na zǝni kɔrɔ kʋm yɩ kʋ na yazurǝ tɩn, ");
INSERT INTO xsm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dɩ́ wʋ́ pa abam dɩ Yisɩrayɛlɩ dwi tiinǝ bam maama lwarɩ kʋ na kɩ te. Á taá ye nɩ Nazarɛtɩ tu Zezi Krisi yɩrɩ dam ŋwaanɩ mʋ pɛ nɔɔnʋ wʋntʋ na yazurǝ, yɩ o laan ba o zɩgɩ abam yigǝ nɩ. Abam nan pagɩ Zezi Krisi tʋʋn-dagara baŋa nɩ á gʋ, yɩ Wɛ joori DƖ bi-o DƖ pa o yagɩ tʋʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wʋntʋ mʋ yɩ wʋlʋ Wɛ tɔnɔ kʋm na maŋɩ kʋ ta o taanɩ nɩ: ‹Kandwɛ dɩlʋ abam lwara bam na vɩn tɩn laan mʋ joori dɩ ba dɩ ji kandwɛ dɩlʋ na paɩ sɔŋɔ kʋm dana tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yɩrɩ dɩdoŋ daa tǝri lʋgʋ baŋa nɩ Wɛ na pɛ nabiinǝ sɩ dɩ wanɩ dɩ pa ba na vrɩm. Kʋ na daɩ Zezi Krisi yɩranɩ mʋ waɩ o vrɩ nɔɔna o yaga.» ");
INSERT INTO xsm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zwifǝ nakwa bam na nɛ Pɩyɛɛrɩ dɩ Zan na jɩgɩ baarɩ dɩ ba na ŋɔɔnɩ te tɩn, kʋ ma kɩ-ba yǝǝu dɩ ba na yɩ nɔɔna balʋ na yǝri kʋlʋkʋlʋ yɩ ba daɩ yi-pʋrɩ-nyɩna tɩn ŋwaanɩ. Ba ma lwarɩ nɩ bantʋ dɛɛn tɔgɩ ba wʋ dɩ Zezi mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ba na nɛ kɔrɔ kʋm na zɩgɩ Pɩyɛɛrɩ dɩ Zan tee nɩ yɩ kʋ jɩgɩ yazurǝ tɩn, ba maa warɩ kʋlʋkʋlʋ sɩ ba daa ta. ");
INSERT INTO xsm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ba ma ta dɩ ba ba wɩ, ba nuŋi da ba taanɩ dim jǝgǝ kam nɩ sɩ ba daarɩ. Ba laan maa wʋra ba bwɛ daanɩ, sɩ ba nii ba na wʋ́ kɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ba ma bwe daanɩ ba wɩ: «Dɩ́ nan wʋ́ kɩ nɔɔna bantʋ ta mʋ? Nɔɔna balʋ maama na zʋʋrɩ Zeruzalɛm nɩ tɩn lwarɩ nɩ bantʋ mʋ kɩ wo-kɩnkagɩlɩ dɩm kʋntʋ. Dɩ́ daa bá wanɩ dɩ́ ta nɩ vwan. ");
INSERT INTO xsm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dɩ́ nan na lagɩ sɩ kǝm dɩntʋ yɩ jagɩ dɩ vu yigǝ tɩn, dɩ́ maŋɩ sɩ dɩ́ kaanɩ nɔɔna bam mʋ, sɩ ba daa yɩ ŋɔɔnɩ Zezi woŋo dɩ nɔɔn-nɔɔnʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ba laan ma joori ba bǝŋi-ba, yɩ ba zʋ. Ba ma ta dɩ ba ba wɩ, ba ba jɩgɩ cwǝŋǝ sɩ ba daa ŋɔɔnɩ Zezi woŋo, naa sɩ ba taa brɩ nɔɔna dɩ wʋntʋ yɩrɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pɩyɛɛrɩ dɩ Zan ma lǝri-ba ba wɩ: «Abam tɩtɩ bʋŋɩ-na á nii. Kɔɔ mʋ lana Wɛ yigǝ nɩ? Kʋ maŋɩ sɩ dɩ́ sɛ abam dɩ́ dwǝni Baŋa-Wɛ na? ");
INSERT INTO xsm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Dɩbam nan bá wanɩ dɩ́ yagɩ kʋlʋ dɩ́ na nɛ yɩ dɩ́ kwǝri dɩ́ ni tɩn ŋwaŋa.» ");
INSERT INTO xsm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Zwifǝ nakwa bam laan ma fɔgɩ ba kaanɩ-ba zanzan, yɩ ba daarɩ ba yagɩ-ba ba pa ba viiri. Ba dɛɛn wʋ nɛ kʋlʋ kʋm ba na wʋ́ vaŋɩ ba zwa kʋ baŋa nɩ tɩn, bɛŋwaanɩ tɩʋ kʋm nɔɔna maama tiini ba zuli Wɛ dɩ woŋo kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bɛŋwaanɩ nɔɔnʋ wʋlʋ wo-kɩnkagɩlɩ dɩm na kɩ o baŋa nɩ yɩ o na yazurǝ tɩn dwe bɩna fiinna o ya na yɩ kɔrɔ. ");
INSERT INTO xsm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ba na yagɩ Pɩyɛɛrɩ dɩ Zan kʋntʋ tɩn, ba ma joori ba vu ba kɔgɔ kʋm te. Ba ma ta dɩ ba Zwifǝ kaanɩm yigǝ tiinǝ bam dɩ ba tɩʋ kʋm nakwa bam na tagɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ba na ni kʋntʋ tɩn, ba maama ma wǝli daanɩ ba warɩ Wɛ yɩ ba wɩ: «Yuutu Baŋa-Wɛ, nmʋ mʋ kɩ wɛyuu dɩ tɩga baŋa dɩ na-fara dɩ wǝǝnu tɩlʋ maama na zʋʋrɩ tɩ wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Dɩ́ nabaarʋ Davidi dɛɛn mʋ yɩ nmʋ tɩntʋŋnʋ. Nmʋ dɛɛn ma pa n Joro kʋm pa o ta nmʋ kwǝrǝ kam o wɩ: ‹Bɛɛ mʋ yɩ lʋgʋ baŋa tiinǝ dwi tǝri tǝri bana zaŋɩ yɩ ba bʋŋɩ wʋbʋŋ-yɔɔrʋ? ");
INSERT INTO xsm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ba pwa bam ti ba yigǝ sɩ ba kɩ jara. Ba yum tiinǝ dɩ ma la daanɩ sɩ ba kɩ jara dɩdaanɩ Baŋa-Wɛ dɩ Krisi wʋm DƖ na tʋŋɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kʋ sɩɩnɩ kʋ kɩ kʋntʋ mʋ. Tɩʋ kʋntʋ nɩ mʋ Erɔdɩ dɩ Pɔnsɩ Pilatɩ jǝni daanɩ dɩ Yisɩrayɛlɩ tiinǝ dɩ dwi-gɛ tiinǝ, sɩ ba ja dɩ nmʋ tɩntʋŋ-ŋʋm Zezi wʋlʋ nmʋ na kuri tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ba na bwɛ daanɩ kʋntʋ tɩn, ba kɩ kʋ maŋɩ dɩ nmʋ na maŋɩ n lɩ wʋbʋŋa dɩ n dam dɩm sɩ kʋlʋ wʋ́ kɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dɩ́ Yuutu Wɛ, nii ba na lagɩ ba yaarɩ dɩbam te tɩn! Dɩbam nan yɩ nmʋ tɩntʋŋna mʋ. Nan pa dɩbam dam, sɩ dɩ́ wanɩ dɩ́ taá tɔɔlɩ nmʋ kwǝrǝ kam dɩ baarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nan twɩ n jɩ-dɩa kam n pa nɔɔna taa naɩ yazurǝ, sɩ n pa wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ n dam tɩn taa kɩ nmʋ tɩntʋŋ-ŋʋm Zezi yɩrɩ dɩm ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ba na warɩ Wɛ ba ti tɩn, jǝgǝ kam ba na lagɩ daanɩ mɛ tɩn ma sisiŋǝ. Wɛ Joro kʋm laan ma ba ba maama te dɩ dam, yɩ ba ŋɔɔnɩ Wɛ kwǝrǝ kam dɩ baarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Zezi karabiǝ bam kɔgɔ kʋm maama wʋbʋŋa dɩ ba ŋwɩa maama dɛɛn yɩ bɩdwɩ mʋ. Ba wʋlʋwʋlʋ wʋ tagɩ nɩ wʋm yɩranɩ mʋ te o wǝǝnu. Wǝǝnu tɩlʋ ba na jɩgɩ tɩn yɩ ba maama nyɩm mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Zezi tɩntʋŋna bam maa jɩgɩ dam kamunu, yɩ ba fɔgɩ ba brɩ dɩ́ Yuutu Zezi cɩga kam nɩ o sɩɩnɩ o bi o yagɩ tʋʋnɩ. Wɛ ma zǝni ba maama dɩ DƖ zaanɩ dɩm lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nɔɔn-nɔɔnʋ tǝri ba kɔgɔ kʋm wʋnɩ o na yɩ yinigǝ tu. Balʋ na jɩgɩ karɩ naa sam tɩn yǝni ba yǝgi-tɩ mʋ, ");
INSERT INTO xsm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yɩ ba daarɩ ba kwe sǝbu kʋm ba ja ba ba pa Zezi tɩntʋŋna bam. Ba laan ma maŋɩ sǝbu kʋm ba pa daanɩ, kʋ maŋɩ dɩ wʋlʋ maama na lagɩ zǝnǝ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kʋntʋ, Zʋzɛfʋ wʋlʋ ba na maa bǝ nɩ Banabasɩ, kʋ kuri mʋ kwiǝ tu, yɩ o yɩ Leviti tu wʋlʋ na nuŋi Sipri tɩn, ");
INSERT INTO xsm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","o dɛɛn yǝgi o kara yɩ o kwe sǝbu kʋm o pa Zezi tɩntʋŋna bam. ");
INSERT INTO xsm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kʋ daarɩ nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Ananiya, o kaanɩ yɩrɩ mʋ Safiira. Nɔɔnʋ wʋm ma kwe ba kara o yǝgi. ");
INSERT INTO xsm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","O ma twǝri sǝbu kʋm wʋnɩ sɩ o ta jɩga, yɩ o kaanɩ dɩ ye kʋ ni nɩ. O laan ma kwe kʋlʋ na daarɩ tɩn o ja vu o pa Zezi tɩntʋŋna bam. ");
INSERT INTO xsm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","O na kɩ kʋntʋ tɩn, Pɩyɛɛrɩ ma ta dɩd-o o wɩ: «Ananiya, bɛɛ mʋ kɩ yɩ nmʋ pa sʋtaanɩ wanɩ nmʋ kʋntʋ doŋ, yɩ n fɔ vwan dɩ Wɛ Joro kʋm dɩ nmʋ na twǝri kara kam sǝbu kʋm wʋnɩ sɩ n ta n jɩgɩ tɩn? ");
INSERT INTO xsm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Maŋa kam nmʋ ta na wʋ yǝgi kara kam tɩn, ka ya yɩ nmʋ nyɩm mʋ. Nmʋ nan na kwe n yǝgi tɩn, sǝbu kʋm ta yɩ nmʋ nyɩm mʋ. Bɛŋwaanɩ mʋ n bʋŋɩ n wʋ nɩ, yɩ nmʋ kɩ kǝm dɩm kʋntʋ? Nmʋ na fɔgɩ vwan kʋntʋ tɩn, n fɔgɩ n pa Wɛ mʋ, sɩ kʋ daɩ nabiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya na ni kʋntʋ tɩn, o ma tʋ tɩga nɩ o tɩ. Kʋ dɛɛn ma pa fʋʋnɩ ja balʋ maama na lwarɩ kʋ ni nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nɔn-dʋnnʋ ma zaŋɩ ba vu ba pri tʋ wʋm ba ja nuŋi ba kɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kʋ na kɛ nɩ luu tɩtɔ te tɩn, o kaanɩ wʋm dɩ daa ma ba o zʋ Pɩyɛɛrɩ-ba te. O ma daa ta wʋ lwarɩ kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pɩyɛɛrɩ ma ta dɩd-o o wɩ: «Ta n brɩ-nɩ, mʋ sǝbu kʋlʋ maama nmʋ dɩ n barʋ wʋm na joŋi á kara kam ŋwaanɩ tɩn na?» O ma sɛ o wɩ: «Ɛɛn, kʋ maama mʋ kʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pɩyɛɛrɩ laan ma bwe-o o wɩ: «Bɛŋwaanɩ mʋ nmʋ dɩ n barʋ wʋm kɩ ni daanɩ sɩ á maŋɩ Yuutu Baŋa-Wɛ Joro kʋm á nii? Nɔɔna balʋ na kwe n barʋ wʋm ba kɩ tɩn ta zɩgɩ digǝ kam ni nɩ lele kʋntʋ. Ba nan wʋ́ zɩŋɩ nmʋ dɩ ba ja nuŋi.» ");
INSERT INTO xsm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","O na tagɩ kʋntʋ o ti tɩn, bɩdwɩ baŋa nɩ mʋ kaanɩ wʋm tʋ tɩga nɩ Pɩyɛɛrɩ yigǝ nɩ o tɩ. Nɔn-dʋnnʋ tɩm ma ba tɩ yi dɩ o tɩga. Ba ma kwe-o ba ja nuŋi ba kɩ o barʋ wʋm tɩkǝri nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Fʋʋnɩ dɛɛn ma ja Zezi kɔgɔ kʋm dɩ nɔɔna balʋ maama dɩ na ni kʋlʋ na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wɛ dɛɛn pɛ Zezi tɩntʋŋna bam kɩ wǝǝnu tɩlʋ na brɩ DƖ dam tɩn dɩ wo-kɩnkagɩla zanzan nɔɔna tɩtarɩ nɩ. Zezi nɔɔna bam maama dɛɛn yǝni ba jeeri daanɩ dɩ wʋbʋŋ-dɩdwɩ mʋ faŋa faŋa Pɛ Salɔmɔn kʋnkɔlɔ kʋm nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Balʋ na daɩ ba kɔgɔ kʋm wʋ nɔɔna tɩn, ba wʋlʋwʋlʋ wʋ dɛ o wǝli ba wʋnɩ. Kʋ daarɩ tɩʋ kʋm nɔɔna bam maama ma tee Zezi nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Baara dɩ kaana zanzan dɛɛn tu ba kɩ ba wʋ-dɩdʋa dɩ dɩ́ Yuutu Zezi. Ba ma tɔgɩ ba wǝli o kɔgɔ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Zezi nɔɔna bam na yɩ kʋntʋ tɩn, nɔɔna maa zɩŋɩ yawɩɩna ba nuŋi ba tiŋi cwe niǝ nɩ. Ba dɛɛn tiŋi-ba sarɩ dɩ gungwǝǝlu baŋa nɩ mʋ, sɩ Pɩyɛɛrɩ na maa tɔgɩ da o kɛa, sɩ o luluŋu kʋm má wanɩ kʋ tɔgɩ ba badonnǝ baŋa. ");
INSERT INTO xsm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nɔɔna zanzan maa yǝni ba nuŋi Zeruzalɛm sa-tɩɩnɩ dɩm maama wʋnɩ ba jaanɩ yawɩɩna dɩ balʋ ciciri na jɩgɩ-ba sɩ yaarɩ tɩn ba tui, yɩ ba maama nɛ yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Zwifǝ bam kaanɩm yuutu wʋm dɩ o nɔɔna bam maama na tɔgɩ ba yɩ Sadusɩan tiinǝ kɔgɔ kʋm wʋ nɔɔna tɩn dɛɛn ma na kʋlʋ na kɩ tɩn. Ba maa tiini ba jɩgɩ wʋ-gʋrʋ dɩ Zezi tɩntʋŋna bam. ");
INSERT INTO xsm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba laan ma zaŋɩ ba ja-ba ba ja vu ba kɩ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tɩga na yi tɩn, Baŋa-Wɛ malɛka ma ba ka pʋrɩ pɩɩna digǝ kam niǝ yam, yɩ ka pa Zezi tɩntʋŋna bam nuŋi. Ka ma ta dɩ ba ka wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ve-na á zʋ Wɛ-di-kamunu kʋm, sɩ á taá brɩ nɔɔna bam Wɛ ŋwɩ-dʋŋa kam na yɩ te tɩn maama.» ");
INSERT INTO xsm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ba ma sɛ Wɛ malɛka kam ni. Tɩga na pʋʋrɩ tɩtɩɩtɩ tɩn, ba ma vu ba zʋ Wɛ-di-kamunu kʋm ba wʋra ba brɩ nɔɔna bam. Kaanɩm yuutu wʋm dɩ o nɔɔna bam laan ma bǝŋi Zwifǝ sarɩya-dirǝ nakwa dɩ Zwifǝ nakwa bam kɔgɔ kʋm maama sɩ ba kikili daanɩ. Ba ma daarɩ ba tʋŋɩ nɔɔna sɩ ba vu ba lɩ Zezi tɩntʋŋna bam pɩɩna digǝ kam nɩ ba ja ba ba pa-ba. ");
INSERT INTO xsm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ba nɔɔna bam na yi da tɩn, mʋ ba wʋ nɛ Zezi tɩntʋŋna bam pɩɩna digǝ kam nɩ. Ba ma joori ba vu Zwifǝ nakwa bam te yɩ ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Dɩ́ na yi da tɩn, pɩɩna digǝ kam niǝ yam pɩ mʋ lanyɩranɩ. Nɔɔna balʋ na wʋra ba yɩra sɩ pɩɩna bam yɩ lu tɩn maa zɩgɩ da. Dɩ́ nan na pʋrɩ digǝ kam tɩn, dɩ́ wʋ nɛ nɔɔn-nɔɔnʋ ka wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wɛ-di-kamunu kʋm yɩrɩna bam yigǝ tu wʋm dɩdaanɩ kaanɩm yigǝ tiinǝ bam na ni kʋntʋ tɩn, ba wʋbʋŋa vugimi daanɩ yɩ ba yǝri kʋlʋ na kɩ Zezi tɩntʋŋna bam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɔɔnʋ wʋdoŋ laan ma ba o zʋ ba na wʋ mɛ tɩn o ta dɩ ba o wɩ: «Nii-na, nɔɔna balʋ abam ya na jaanɩ á kɩ pɩɩna digǝ kam nɩ tɩn, bam mʋ wʋ Wɛ-di-kamunu kʋm wʋnɩ ba zɩgɩ da ba brɩ nɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yɩrɩna bam yigǝ tu wʋm na ni kʋntʋ tɩn, o dɩ o nɔɔna bam ma joori ba vu ba ja Zezi tɩntʋŋna bam ba ba. Ba daa wʋ jaanɩ-ba dɩ dam, bɛŋwaanɩ ba kwarɩ fʋʋnɩ sɩ nɔɔna bam wʋ́ dʋlɩ-ba dɩ kandwa. ");
INSERT INTO xsm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ba laan ma pa ba zʋ ba zɩgɩ sarɩya-dirǝ nakwa bam yigǝ nɩ. Kaanɩm yuutu wʋm laan ma bwe-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Bɛŋwaanɩ mʋ á kɩ kʋntʋ? Dɩbam maŋɩ dɩ́ kaanɩ abam sɩ á daa yɩ taá brɩ nɔɔna dɩ yɩrɩ dɩntʋ. Nii abam na kɩ te. Á pɛ abam zaasɩm dɩm yɩranɩ mʋ jagɩ Zeruzalɛm maama wʋnɩ, yɩ á ta lagɩ sɩ wʋntʋ caa kʋm tɔgɩ dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pɩyɛɛrɩ dɩ o donnǝ tɩntʋŋna bam ma lǝri ba wɩ: «Dɩbam maŋɩ sɩ dɩ́ sɛ Wɛ ni mʋ kʋ dwǝni nabiinǝ ni. ");
INSERT INTO xsm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zezi wʋlʋ abam na jaanɩ á pa tʋʋn-dagara baŋa nɩ á gʋ tɩn, Baŋa-Wɛ dɩlʋ dɩbam nabaara bam na tɔgɩ tɩn mʋ pɛ o bi o yagɩ tʋʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kʋ yɩ wʋntʋ mʋ Baŋa-Wɛ zǝŋ-o DƖ jǝni DƖ jazɩm nɩ, sɩ o taa yɩ dɩbam Pɛ dɩ dɩ́ Vɩrnʋ, sɩ o pa Yisɩrayɛlɩ tiinǝ na cwǝŋǝ ba lǝni ba wʋrʋ, sɩ Wɛ laan yagɩ ba lwarɩm DƖ ma cɛ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dɩbam dɩ Wɛ Joro kʋlʋ Wɛ na pɛ balʋ maama na sɛ DƖ ni tɩn yɩ cɩga kantʋ maana tiinǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zwifǝ nakwa bam na ni Zezi tɩntʋŋna bam na tɛ kʋlʋ tɩn, ba bana ma tiini ya zaŋɩ dɩ ba, yɩ ba lagɩ sɩ ba gʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sarɩya-dirǝ nakwa bam dɩdʋ ma zaŋɩ ba tɩtarɩ nɩ, o yɩrɩ mʋ Gamalɩyɛlɩ. O yɩ Farizɩan tu yɩ o ta yɩ Wɛ cullu tɩm karanyɩn-kamunu. Nɔɔna maama maa pa-o zulǝ. O na zaŋɩ ba kɔgɔ kʋm wʋnɩ tɩn, o maa wɩ, ba ja Zezi tɩntʋŋna bam ba nuŋi pooni sɩ ba cǝgi fɩɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","O ma daarɩ o ta dɩ sarɩya-dirǝ nakwa bam o wɩ: «Yisɩrayɛlɩ tiinǝ-ba, á cʋ-na á tɩtɩ dɩ á na bʋŋɩ sɩ á kɩ nɔɔna bantʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kʋ ta wʋ daanɩ nɔɔnʋ wʋdoŋ mʋ zaŋɩ dɩbam lʋgʋ nɩ, o yɩrɩ mʋ Tɩʋdasɩ. O maa paɩ o yɩ nɔn-kamunu yɩ nɔɔna zanzan dɛɛn tɔgɩ o kwaga, ba yɩ nɩnɛɛnɩ nɔɔna biǝ-yana (400) te. Ba dɛɛn gʋ-o mʋ yɩ o karabiǝ bam jagɩ da yigǝ nɩ. Nɔɔn-nɔɔnʋ daa wʋ daarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kʋntʋ kwaga nɩ Galile tu wʋdoŋ dɩ daa ma zaŋɩ o yɩrɩ mʋ Zudasɩ. Maŋa kam ba dɛɛn na wʋra ba garɩ dɩ́ lʋgʋ kʋm nɔn-biǝ tɩn, mʋ o zaŋɩ o la kɔgɔ o kɩ o kwaga nɩ. Ba ma gʋ wʋntʋ dɩ. O dɩ kwaga nɔɔna bam maama ma jagɩ da yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kʋntʋ ŋwaanɩ mʋ a lagɩ a ta abam sɩ á yɩ zaŋɩ á kɩ nɔɔna bantʋ kʋlʋkʋlʋ. Yagɩ-na-ba, bɛŋwaanɩ ba wʋbʋŋa yam dɩ ba tɩtʋŋa yam maama na yɩ nabiinǝ nyɩm mʋ, yaá ba ya ji kafɛ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kʋ nan na yɩ Wɛ nyɩm mʋ, abam bá wanɩ á cɩ-ba. Yɩrɩ-na á tɩtɩ sɩ á yɩ ba á ja dɩ Baŋa-Wɛ.» Gamalɩyɛlɩ na tagɩ kʋntʋ o ti tɩn, ba ma sɛ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ba ma bǝŋi Zezi tɩntʋŋna bam sɩ ba joori ba zʋ ba te. Ba ma magɩ-ba dɩ balaara, yɩ ba daarɩ ba kaanɩ-ba sɩ ba daa yɩ ŋɔɔnɩ kʋlʋkʋlʋ dɩ Zezi yɩrɩ. Ba laan ma yagɩ-ba yɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Zezi tɩntʋŋna bam ma nuŋi sarɩya-dirǝ nakwa bam tee nɩ, yɩ ba jɩgɩ wʋpolo lanyɩranɩ dɩ ba na maŋɩ sɩ ba na yaara Zezi yɩrɩ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Dɛ maama ba maa yǝni ba jeeri daanɩ Wɛ-di-kamunu kʋm wʋnɩ, yɩ ba daarɩ ba tʋlɩ sam ba brɩ nɔɔna Wɛ cɩga kam. Ba ma tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam, nɩ Zezi mʋ yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Maŋa kam kʋntʋ nɩ Zezi karabiǝ bam kɔgɔ kʋm maa wʋra kʋ pulǝ zanzan. Ba kɔgɔ kʋm wʋnɩ Zwifǝ balʋ na yɩ vǝrǝ yɩ ba ŋɔɔnɩ Grɛkɩ tiinǝ taanɩ dɩm tɩn maa jɩgɩ balʋ na ŋɔɔnɩ ba tɩtɩ Zwifǝ taanɩ dɩm tɩn ba pʋʋna, dɩ ba na ba paɩ ba kadǝnǝ kʋlʋ na maŋɩ sɩ ba pa-ba ba ni-wʋdiu ŋwaanɩ dɛ maama tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Zezi tɩntʋŋna fugǝ-bale bam ma bǝŋi ba kɔgɔ kʋm maama ba kɩ daanɩ, yɩ ba ta ba wɩ: «Kʋ wʋ maŋɩ sɩ dɩbam yagɩ Wɛ taanɩ dɩm zaasɩm, sɩ dɩ́ daarɩ dɩ́ taá maŋɩ wʋdiiru. ");
INSERT INTO xsm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Dɩ́ ko-biǝ-ba, á maŋɩ sɩ á lɩ nɔɔna barpɛ mʋ á wʋnɩ, sɩ dɩ́ pa ba taa nii wǝǝnu tɩntʋ baŋa nɩ. Ba nan maŋɩ sɩ ba taa yɩ nɔɔna balʋ nɔɔna maama na ye nɩ ba yɩ nɔn-ŋʋna yɩ Wɛ Joro kʋm wʋ ba tee nɩ lanyɩranɩ yɩ ba jɩgɩ wʋbʋŋ-ŋʋna tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sɩ dɩbam dɩ́ daarɩ dɩ́ kwaanɩ dɩ́ nii Wɛ warɩm dɩ DƖ taanɩ dɩm zaasɩm baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ba na tagɩ kʋntʋ tɩn, kʋ ma poli ba kɔgɔ kʋm maama wʋ. Ba ma kuri nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Etiyɛnɩ. Wʋntʋ jɩgɩ wʋ-dɩdʋa dɩ Zezi yɩ Wɛ Joro kʋm wʋ o tee nɩ. Ba ma wǝli Filipi dɩ Prokori dɩ Nikano dɩ Timɔn dɩ Pamɩna dɩ Nikola wʋlʋ na nuŋi Antɩɔsɩ, o yɩ dwi-gɛ tu yɩ o ba o tɔgɩ cullu tɩlʋ Wɛ na pɛ dɩbam Zwifǝ bam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ba ma lɩ-ba ba ja vu ba zɩgɩ Zezi tɩntʋŋna bam yigǝ nɩ. Ba ma warɩ Wɛ ba pa-ba yɩ ba daŋɩ ba jɩa ba baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wɛ kwǝrǝ kam dɛɛn ma fɔgɩ ka jagɩ ka ve yigǝ yɩ nɔɔna sɛ-ka. Zezi karabiǝ bam kɔgɔ kʋm maa pulǝ zanzan Zeruzalɛm nɩ. Zwifǝ kaanɩm tiinǝ zanzan dɩ dɛɛn ma ba ba sɛ Zezi cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyɛnɩ dɛɛn yɩ nɔɔnʋ wʋlʋ Wɛ na pɛ-o zaanɩ dɩ dam zanzan tɩn. O maa tiini o kɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ Wɛ dam tɩn nɔɔna tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nɔɔna badonnǝ maa zaŋɩ ba magɩ kantɔgɔ dɩd-o. Bantʋ nuŋi Zwifǝ kɔgɔ kʋlʋ ya na yɩ gambɛ yɩ ba laan ba ba te ba tɩtɩ tɩn wʋnɩ mʋ. Ba dɛɛn nuŋi Sirɛɛnɩ dɩ Alɛsandrɩ mʋ. Ba ma tɔgɩ ba wǝli dɩ Zwifǝ badaara na nuŋi Silisi dɩ Azi tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ba na magɩ kantɔgɔ dɩd-o tɩn, o ma ŋɔɔnɩ dɩ bʋŋɩm dam nɩ Wɛ Joro kʋm na pɛ-o te tɩn, kʋ pa ba daa warɩ o taanɩ ba lǝri. ");
INSERT INTO xsm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ba laan ma nuŋi ba kɩ ni dɩdaanɩ nɔɔna badonnǝ, sɩ ba fɔ vwan ba ta wɩ: «Dɩbam ni nɔɔnʋ wʋntʋ na ŋɔɔnɩ o twɩ Moyisi dɩ Wɛ.» ");
INSERT INTO xsm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ba ma pa tɩʋ kʋm nɔɔna dɩ ba nakwa bam dɩ ba cullu karanyɩna tiinǝ bam bana zaŋɩ, yɩ ba ja Etiyɛnɩ ba ja vu ba sarɩya-dirǝ nakwa bam yigǝ sɩ ba di o taanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba ma pa nɔɔna badonnǝ zʋ ba fɔ vwan ba pa-o, yɩ ba ta ba wɩ: «Maŋa maama nɔɔnʋ wʋntʋ sɩɩnɩ o ŋɔɔnɩ ta-balwaarʋ mʋ o paɩ dɩbam Wɛ-di-kamunu kʋm dɩ Wɛ cullu tɩlʋ DƖ na kɩ Moyisi jɩŋa nɩ dɩbam ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Dɩ́ ma ni o na tagɩ o wɩ, Nazarɛtɩ tu Zezi mʋ wʋ́ ba o cɔgɩ Wɛ-di-kamunu kʋm, yɩ o pipiri mɩʋ kʋlʋ maama Moyisi dɛɛn na brɩ dɩ́ nabaara sɩ dɩ́ taá tɔgɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Zwifǝ nakwa balʋ maama na je da tɩn laan maa yɔɔrɩ ba nii Etiyɛnɩ cɔɔn. Ba ma nii ba na o yibiyǝ na lǝni nɩ malɛka yibiyǝ te. ");
INSERT INTO xsm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Zwifǝ kaanɩm yuutu wʋm ma zaŋɩ o bwe Etiyɛnɩ o wɩ: «Wǝǝnu tɩlʋ ba na tagɩ ba pa nmʋ tɩn yɩ cɩga mʋ naa vwan mʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyɛnɩ laan ma lǝri o wɩ: «A kwǝ-ba dɩ a ko-biǝ-ba, cǝgi-na amʋ na lagɩ a ta woŋo kʋlʋ tɩn. Faŋa faŋa tɩn Paarɩ-Zulǝ Tu Baŋa-Wɛ mʋ tu dɩbam nabaarʋ Abraham te. Kantʋ maŋa kam nɩ, Abraham dɛɛn ta zʋʋrɩ Mesopotami nɩ mʋ. O daa ta wʋ ve sɩ o taa zʋʋrɩ Aaran nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wɛ dɛɛn ma ta dɩd-o DƖ wɩ: ‹Yagɩ n tɩtɩ tɩʋ kʋm dɩ n sɔŋɔ tiinǝ, sɩ n daarɩ n vu tɩʋ kʋlʋ amʋ na wʋ́ brɩ nmʋ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","O ma sɩɩnɩ o zaŋɩ o nuŋi Kalɩdɩan tiinǝ tɩʋ kʋm nɩ o vu o yi Aaran o zʋʋrɩ da. O na wʋ dáanɩ tɩn, o ko ma tɩ. Wɛ ma pa o daa nuŋi o fɔɔrɩ o vu o yi tɩʋ kʋntʋ abam na zʋʋrɩ zɩm tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wɛ nan wʋ pɛ Abraham tɩga yo seeni sɩ o taa te, dɩ fɩnfɩɩn dɩ. Wɛ dɛɛn goni ni mʋ dɩd-o DƖ wɩ, wʋm wʋ́ pa-o tɩga kantʋ sɩ o taa te, yɩ o na tɩgɩ o daarɩ, sɩ o dwi tiinǝ ta ta te-ka. Wɛ na goni DƖ ni dɩm tɩn, Abraham ta ba jɩgɩ bu. ");
INSERT INTO xsm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mʋ Wɛ na tagɩ kʋlʋ dɩd-o tɩn mʋ tɩntʋ: ‹Abraham, nmʋ dwi tiinǝ wʋ́ vu ba taa zʋʋrɩ tʋ-gaa nɩ. Baá ta yɩ gambɛ mʋ tɩʋ kʋm kʋntʋ nɩ, yɩ nɔɔna wʋ́ bɛɛsɩ-ba taan bɩna biǝ-yana (400). ");
INSERT INTO xsm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Amʋ Wɛ nan wʋ́ di balʋ na fɩ-ba sɩ ba tʋŋɩ gambɛɛm tɩtʋŋa tɩn taanɩ sɩ ba na cam. Kʋntʋ kwaga nɩ, ba laan wʋ́ nuŋi tɩʋ kʋm kʋntʋ nɩ ba ba, ba taa zuli amʋ jǝgǝ kantʋ nɩ.› ");
INSERT INTO xsm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Baŋa-Wɛ ma daarɩ DƖ go ni DƖ pa Abraham DƖ wɩ, Abraham dwi tiinǝ taa goni ba bǝkǝri sɩ kʋ brɩ nɩ ba sɛ DƖ ni. Kʋntʋ, Abraham na lʋgɩ Yizakɩ tɩn, da nana dɛ nɩ o ma go-o. Yizakɩ dɩ dɛɛn ma ba o lʋ Zakɔbɩ, o dɩ ma go-o. Zakɔbɩ ma lʋ dɩ́ nabaara fugǝ-bale bam yɩ o go-ba dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nabaara bam dɩdʋa yɩrɩ mʋ Zʋzɛfʋ. O cʋrrʋ tɩm dɛɛn maa jɩgɩ wʋ-gʋrʋ dɩd-o. Kʋntʋ ŋwaanɩ mʋ ba jaan-o ba yǝgi ba pa o vu Ezipi sɩ o taa yɩ gambaa. Wɛ ta maa wʋra dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","DƖ ma pa o nuŋi cam maama wʋnɩ dɩ yazurǝ. Zʋzɛfʋ na tu o zɩgɩ Ezipi pa-farʋ wʋm yigǝ nɩ tɩn, Wɛ pɛ-o wʋbʋŋ-ŋʋna yɩ pɛ wʋm yi su Zʋzɛfʋ lanyɩranɩ. Pɛ wʋm ma pa o ji o sɔŋɔ kʋm tu dɩ Ezipi tɩʋ kʋm maama yuutu. ");
INSERT INTO xsm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kana dɛɛn ma ba ka wʋ Ezipi dɩ Kanaan tɩɩnɩ dɩm maama nɩ. Kʋ ma tiini kʋ cɛ ba yɩra nɩ. Dɩ́ nabaara bam maa warɩ sɩ ba na wʋdiu ba di. ");
INSERT INTO xsm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zakɔbɩ dɛɛn ma ni nɩ wʋdiu wʋ Ezipi nɩ. O ma tʋŋɩ dɩ́ nabaara bam sɩ ba vu ba yǝgi. ");
INSERT INTO xsm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kʋntʋ kwaga nɩ ba daa ma joori ba vu ba kɩ bɩle. Zʋzɛfʋ laan ma pa o cʋrrʋ tɩm lwar-o. Ezipi pa-farʋ wʋm dɩ laan ma ba o lwarɩ Zʋzɛfʋ dwi dɩm na nuŋi mɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Zʋzɛfʋ ma daarɩ o tʋŋɩ ni o pa o ko Zakɔbɩ, sɩ o dɩ o sɔŋɔ tiinǝ bam maama ba o te Ezipi nɩ. Ba maama dɛɛn yɩ nɔɔna fusɩrpɛ-banu mʋ (75). ");
INSERT INTO xsm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zakɔbɩ ma sɩɩnɩ o zaŋɩ o vu Ezipi. Dáanɩ mʋ wʋntʋ tɩga. Dɩbam nabaara bam dɩ ma ba ba tɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba ma ja ba yɩra yam ba joori ba vu Sisɩm ba kɩ-ba yibeeli dɩlʋ Abraham na yǝgi dɩ sǝbu Emori biǝ bam tee nɩ tɩn nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Maŋa kam ma twɛ sɩ Baŋa-Wɛ sɩɩnɩ DƖ kɩ kʋlʋ DƖ dɛɛn na goni ni dɩ Abraham tɩn. Maŋa kam kʋntʋ nɩ dɩbam nɔɔna balʋ na wʋ Ezipi nɩ tɩn maa tiini ba wʋra ba puli zanzan. ");
INSERT INTO xsm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pa-farʋ wʋdoŋ dɩ daa ma zaŋɩ sɩ o taa te Ezipi. O maa yǝri Zʋzɛfʋ ni nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","O dɛɛn maa jɩgɩ dɩbam nabaara bam o bɛɛsa. O dɛɛn kɩ swan mʋ o fɩ-ba sɩ ba kwe ba bu-sɩsɩn ba jaanɩ ba ve ba yaga, sɩ ba taa tʋa. ");
INSERT INTO xsm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kantʋ maŋa kam nɩ mʋ ba lʋgɩ Moyisi. O dɛɛn maa yɩ bu-ŋʋm Wɛ yibiyǝ nɩ. Ba maa jɩg-o ba kɔna o ko sɔŋɔ nɩ canɩ sɩtɔ. ");
INSERT INTO xsm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba laan ma ja-o ba nuŋi ba vu ba yagɩ. Pa-farʋ wʋm bukɔ ma kwe-o o jɩgɩ o niǝ, nɩ o yɩ o tɩtɩ bu mʋ te. ");
INSERT INTO xsm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ba ma brɩ Moyisi Ezipi tiinǝ yi-pʋrʋ kʋm maama. O ma ji nɔn-babɩa o ni-taanɩ dɩ o kǝm maama baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moyisi dɛɛn na yi bɩna fiinna tɩn, o ma lɩ wʋbʋŋa sɩ o vu o nii o ko-biǝ Yisɩrayɛlɩ tiinǝ bam na yɩ te. ");
INSERT INTO xsm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O na ve tɩn, o ma na Ezipi tu wʋdoŋ na jɩgɩ Yisɩrayɛlɩ tu o maga. Moyisi ma vu sɩ o wǝli o tɩtɩ dwi tu wʋm jara yam wʋnɩ. O ma magɩ Ezipi tu wʋm o gʋ. ");
INSERT INTO xsm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O dɛɛn ya bʋŋɩ nɩ o tɩtɩ dwi tiinǝ bam wʋ́ lwarɩ nɩ Wɛ lagɩ DƖ pa wʋntʋ mʋ joŋi-ba Ezipi tiinǝ bam jɩŋa nɩ o yagɩ. Ba nan wʋ lwarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tɩga na pʋʋrɩ tɩn, o daa ma na Yisɩrayɛlɩ tiinǝ bale na jɩgɩ daanɩ. O ma kwaanɩ sɩ o lo-ba, yɩ o ta dɩ ba o wɩ: ‹A ko-biǝ-ba, abam yɩ cʋrrʋ mʋ daanɩ. Bɛɛ mʋ kɩ yɩ abam daa jɩgɩ daanɩ?› ");
INSERT INTO xsm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","O na tagɩ dɩ ba kʋntʋ tɩn, mʋ wʋlʋ wʋm na dana tɩn ma yigi Moyisi o yagɩ daa nɩ, yɩ o daarɩ o bwe Moyisi o wɩ: ‹Wɔɔ mʋ pɛ nmʋ ni sɩ n ta n yɩ dɩbam yuutu sɩ n daarɩ n ŋɔɔnɩ dɩbam taanɩ? ");
INSERT INTO xsm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nmʋ lagɩ sɩ n gʋ amʋ dɩ mʋ, nɩ n diin na gʋ Ezipi tu wʋm te tɩn na?› ");
INSERT INTO xsm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moyisi na ni kʋntʋ tɩn, o laan ma duri o nuŋi Ezipi nɩ o vu o zʋʋrɩ Madɩan tɩʋ nɩ. Dáanɩ mʋ o di kaanɩ yɩ ba lʋ biǝ bale. ");
INSERT INTO xsm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bɩna fiinna dɛɛn na kɛ tɩn, Wɛ malɛka ma ba Moyisi te kagʋa wʋnɩ Sinayi piu kʋm tɩkǝri nɩ. O ma na min-vʋgʋ na jɩgɩ puŋu kʋ di, yɩ malɛka kam wʋ mini dɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyisi yɩra ma sɔɔrɩ dɩ o na nɛ kʋlʋ tɩn. O ma fɔɔrɩ o yi mini dɩm te sɩ o nii. O laan ma ni Baŋa-Wɛ kwǝrǝ na ŋɔɔnɩ dɩd-o ka wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Amʋ yɩ nmʋ nabaara bam Baŋa-Wɛ. Amʋ mʋ yɩ Abraham Baŋa-Wɛ, dɩ Yizakɩ dɩ Zakɔbɩ Baŋa-Wɛ.› Moyisi yɩra maa saɩ, yɩ o daa warɩ o nii. ");
INSERT INTO xsm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Baŋa-Wɛ ma ta dɩd-o DƖ wɩ: ‹Lɩ n natra yam, sɩ jǝgǝ kalʋ nmʋ na zɩgɩ da tɩn yɩ amʋ tɩtɩ jǝgǝ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Wɛ daa ma ta DƖ wɩ: ‹A nɛ a nɔɔna bam na wʋ Ezipi nɩ ba yaara te tɩn, yɩ a kwǝri a ni ba na kʋnɩ te tɩn. Amʋ nan tu sɩ a joŋi-ba mʋ a yagɩ. Kʋntʋ tɩn, a lagɩ a tʋŋɩ nmʋ sɩ n joori n vu Ezipi.› » ");
INSERT INTO xsm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Etiyɛnɩ ta ma ta o wɩ: «Moyisi dɛɛn yɩ wʋlʋ Yisɩrayɛlɩ tiinǝ bam na vɩ-o tɩn. Ba dɛɛn bwe-o ba wɩ: ‹Wɔɔ mʋ pɛ nmʋ ni, sɩ n ta n yɩ dɩbam yuutu sɩ n daarɩ n ŋɔɔnɩ dɩbam taanɩ?› Moyisi wʋntʋ mʋ Wɛ tʋŋɩ sɩ o vu o taa te DƖ nɔɔna bam, sɩ o daarɩ o joŋi-ba o yagɩ. Wɛ ma tʋŋɩ DƖ malɛka, yɩ ka nuŋi o yigǝ nɩ puŋu wʋnɩ ka brɩ-o kʋntʋ maama. ");
INSERT INTO xsm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moyisi dɛɛn ma kɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ Wɛ dam tɩn Ezipi nɩ, yɩ o wanɩ o ja nɔɔna bam o nuŋi. Ba ma tɔgɩ nɩnɩʋ-sʋŋʋ kʋm ba bɛ, yɩ ba daarɩ ba beeri kagʋa kam wʋnɩ taan bɩna fiinna, yɩ Moyisi dɛɛn ta kɩ wo-kɩnkagɩla zanzan ba tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyisi daa ta mʋ yɩ wʋlʋ na tagɩ dɩ Yisɩrayɛlɩ tiinǝ bam o wɩ: ‹Wɛ wʋ́ pa abam dwi tu dɩdʋa zaŋɩ o taa yɩ Wɛ nijoŋnu abam tɩtarɩ nɩ, nɩ DƖ na tʋŋɩ amʋ Moyisi te tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moyisi mʋ yɩ wʋlʋ dɛɛn na wʋra dɩ Yisɩrayɛlɩ tiinǝ kɔgɔ kʋm kagʋa kam wʋnɩ tɩn, yɩ o wʋra dɩdaanɩ dɩbam nabaara bam, dɩ malɛka kalʋ na ŋɔɔnɩ dɩd-o Sinayi piu kʋm yuu nɩ tɩn. Wʋntʋ mʋ joŋi Wɛ bɩtarɩ sɩlʋ na paɩ ŋwɩa tɩn o pa dɩbam. ");
INSERT INTO xsm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Dɩ kʋntʋ maama, dɩ́ nabaara bam dɛɛn ba lagɩ sɩ ba sɛ Moyisi ni. Ba ma vɩ-o, yɩ ba daarɩ ba bʋŋɩ sɩ ba joori ba vu Ezipi. ");
INSERT INTO xsm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ba ma ta dɩ Aarɔn ba wɩ: ‹Mɔ jwǝnǝ n pa dɩbam sɩ ya taa tɔgɩ dɩ́ yigǝ, sɩ Moyisi wʋlʋ na jaanɩ dɩbam o nuŋi Ezipi nɩ tɩn, dɩ́ yǝri woŋo kʋlʋ na kɩ-o tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Maŋa kam kʋntʋ nɩ ba ma sɩɩnɩ ba mɔ kamɔgɔ kʋ nyɩ dɩ nʋa, yɩ ba pa kʋ yɩ ba jwǝni. Ba maa jɩgɩ-dɩ ba kaana. Ba ma daarɩ ba kɩ wʋpolo dɩ ba tɩtɩ na mɛ ba jɩa ba ma mɔ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ba na kaanɩ jwǝni dɩm kʋntʋ tɩn, Wɛ ma pipiri DƖ kwaga DƖ ya-ba. DƖ ma yagɩ-ba sɩ ba taa zuli calɩcwɩ sɩlʋ na wʋ wɛyuu nɩ tɩn. Kʋ kɩ nɩnɛɛnɩ kʋ na maŋɩ kʋ pʋpʋnɩ Wɛ nijoŋnǝ bam tɔnɔ kʋm wʋnɩ kʋ wɩ: ‹Abam Yisɩrayɛlɩ dwi tiinǝ-ba, á dɛɛn na gʋ vara á ma kaanɩ jwǝnǝ kagʋa kam wʋnɩ bɩna fiinna tɩn, kʋ daɩ amʋ mʋ á kaanɩ á pa kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kʋ nan yɩ Moloki jwǝni dɩm vwe mʋ abam dɛɛn zɩŋɩ, dɩdaanɩ calɩcʋa kalʋ na yɩ abam jwǝni Rifanɩ tɩn. Tɩntʋ maama nan yɩ kamwarʋ tɩlʋ á na kɩ sɩ á taá zuli-tɩ mʋ. Kʋntʋ ŋwaanɩ amʋ wʋ́ pa nɔɔna zǝli abam ba ja vu ba gaalɩ Babilɔnɩ na wʋ mɛ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Dɩbam nabaara bam na beeri kagʋa kam wʋnɩ tɩn, ba dɛɛn jɩgɩ Wɛ vwe dɩlʋ na brɩ nɩ Wɛ wʋ ba tee nɩ tɩn mʋ. Wɛ dɛɛn brɩ Moyisi o na wʋ́ kɩ te sɩ o ma pu vwe dɩm tɩn. Ba dɛɛn sɩɩnɩ ba kɩ-dɩ nɩ Wɛ na brɩ sɩ ba kɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kʋ kwaga seeni tɩn, dɩbam nabaara bam mʋ joŋi vwe dɩm ba kwǝ tee nɩ ba zɩŋɩ-dɩ ba ja tɔgɩ Zozwe kwaga. Ba ma vu ba wanɩ tɩɩnɩ dɩlʋ Wɛ na lagɩ DƖ pa-ba sɩ ba taa zʋʋrɩ da tɩn. Wɛ dɛɛn zǝli je sɩm nɔɔna bam DƖ yagɩ ba yigǝ nɩ. Vwe dɩm maa wʋra taan, kʋ ba kʋ yi Davidi na zaŋɩ o ji pɛ maŋa kalʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Wɛ wʋ ma poli dɩ Davidi, yɩ o loori Wɛ sɩ DƖ pa-o cwǝŋǝ sɩ o lɔ digǝ o ma lǝni vwe dɩm yuu nɩ, sɩ Wɛ taa zʋʋrɩ da sɩ DƖ taa wʋ Zakɔbɩ dwi tiinǝ bam tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kʋ nan yɩ Davidi bu Salɔmɔn mʋ lɔgɩ digǝ kam o pa Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Baŋa-Wɛ dɩlʋ na yɩ kamunu tɩn nan ba zʋʋra di sɩlʋ nabiinǝ na lɔgɩ tɩn wʋnɩ. Wɛ nijoŋnu dɩdʋa dɛɛn mʋ tagɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Yuutu Baŋa-Wɛ wɩ: Wɛyuu mʋ yɩ amʋ jǝŋǝ je, kʋ daarɩ tɩga baŋa maa yɩ amʋ nɛ cwiim je. Digǝ kɔɔ dwi mʋ abam wʋ́ wanɩ á lɔ á pa amʋ? Jǝgǝ kɔɔ mʋ amʋ wʋ́ vu a pǝni da a sin? ");
INSERT INTO xsm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kʋ daɩ amʋ tɩtɩ jɩŋa mʋ kɩ wǝǝnu tɩntʋ maama na?› » ");
INSERT INTO xsm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyɛnɩ daa ta ma ta dɩ Zwifǝ nakwa bam o wɩ: «Abam yɩ vɩɩna zanzan. Á wʋbʋŋa dɩ nyɩ dɩ balʋ na ba tɔgɩ Wɛ tɩn wʋbʋŋa. Abam zwa mʋ kwarɩmɩ yɩ á ba ni Wɛ kwǝrǝ kam. Abam ba sɛ Wɛ Joro kʋm na brɩ cɩga kalʋ tɩn. Abam dɩ á nabaara bam kikiǝ maama yɩ bɩdwɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wɛ nijoŋnǝ bam wʋnɩ wʋlʋwʋlʋ tǝrǝ abam nabaara bam na wʋ bɛɛs-o. Ba dɛɛn gʋ balʋ na brɩ nɩ Wɛ wʋ́ tʋŋɩ Cɩga Tu wʋm sɩ o ba tɩn. Lele kʋntʋ abam nan mʋ jaanɩ wʋntʋ á kɩ nɔɔna jɩŋa nɩ, yɩ á kɩ daanɩ á gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Abam yɩ balʋ na joŋi Wɛ cullu tɩlʋ DƖ na tɔgɩ malɛsɩ jɩŋa DƖ pa abam tɩn mʋ. Dɩ kʋntʋ dɩ á ta wʋ sɛ-tɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Etiyɛnɩ na tagɩ kʋntʋ o ti tɩn, kʋ ma pa Zwifǝ nakwa bam bana zaŋɩ dɩd-o zanzan, yɩ ba dʋnɩ ba yǝlǝ. ");
INSERT INTO xsm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wɛ Joro kʋm maa wʋ Etiyɛnɩ tee nɩ lanyɩranɩ. O ma kwǝni o yuu wɛɛnɩ o nii Wɛ-sɔŋɔ seeni yɔɔrɔ-tɔtɔ, yɩ o na Wɛ paarɩ-zulǝ na dagɩ te. O ma daarɩ o nii o na Zezi na zɩgɩ Baŋa-Wɛ jazɩm nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","O laan ma ta o wɩ: «Nii-na, amʋ nɛ Wɛ-sɔŋɔ ni na pʋrɩ yɩ Nabiin-bu wʋm zɩgɩ Baŋa-Wɛ jazɩm nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Zwifǝ nakwa bam kɔgɔ kʋm maama na ni kʋntʋ tɩn, ba ma kaasɩ dɩ kwǝr-dɩa, yɩ ba pu ba zwa sɩ ba daa yɩ taa ni o taanɩ dɩm. Ba maama ma duri bɩdwɩ baŋa nɩ ba vu ba ja-o. ");
INSERT INTO xsm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ba ma vaŋ-o ba pa o nuŋi tɩʋ kʋm daa. Ba laan ma daarɩ ba jɩg-o ba dʋlɩ dɩ kandwa sɩ ba gʋ. Balʋ na dʋl-o dɩ kandwa tɩn ma lɩ ba gwaarʋ ba pa nɔn-dʋŋʋ kʋdoŋ sɩ o ta niǝ. Nɔɔnʋ wʋm yɩrɩ mʋ Sooli. ");
INSERT INTO xsm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ba na jɩgɩ Etiyɛnɩ ba dʋlɩ kʋntʋ tɩn, o ma loori Wɛ o wɩ: «A Yuutu Zezi, joŋi a joro.» ");
INSERT INTO xsm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","O laan ma kuni doonǝ tɩga nɩ o kaasɩ dɩ kwǝr-dɩa o wɩ: «A Yuutu, yɩ kwe ba taalɩ ba kǝm-balɔrɔ kʋntʋ ŋwaanɩ.» O na tagɩ kʋntʋ tɩn, o laan ma tɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sooli na nɛ ba na kɩ te ba gʋ Etiyɛnɩ tɩn, o ma sɛ nɩ kʋ maŋɩ. Dɛ dɩm kʋntʋ nɩ nɔɔna puli sɩ ba yaarɩ Zezi kɔgɔ kʋlʋ na wʋ Zeruzalɛm nɩ tɩn zanzan. Ba maama ma jagɩ ba duri ba zʋ tɩɩnɩ dɩlʋ maama na wʋ Zude dɩ Samari nɩ tɩn wʋnɩ. Kʋ daarɩ Zezi tɩntʋŋna fugǝ-bale bam yɩranɩ mʋ wʋ tɔgɩ ba duri. ");
INSERT INTO xsm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nɔɔna balʋ na kwarɩ Wɛ tɩn ma kwe Etiyɛnɩ yɩra yam ba kɩ, yɩ ba daarɩ ba keeri zanzan o tʋʋnɩ dɩm ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sooli maa kwaanɩ sɩ o cɔgɩ Zezi kɔgɔ kʋm maama. O maa yǝni o tʋlɩ sam dɩm wʋnɩ o jaanɩ baara dɩ kaana balʋ na tɔgɩ Zezi tɩn o ve o kɩ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Zezi karabiǝ balʋ na duri ba jagɩ tɩn maa yǝni ba ve je maama ba tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi ma zaŋɩ o vu Samari tɩʋ kʋdoŋ o tɔɔlɩ Krisi wʋm Wɛ na tʋŋɩ tɩn kwǝrǝ o brɩ nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nɔn-kɔgɔ kʋm maama maa kwaanɩ ba cǝgi Filipi na ŋɔɔnɩ kʋlʋ tɩn. Ba maama cǝgi o taanɩ dɩm, yɩ ba kwǝri ba na wo-kɩnkagɩla yalʋ o na kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ba ma na ciciri na nuŋi sɩ yagɩ nɔɔna zanzan yɩ sɩ kaasa dɩ kwǝr-dɛ. Kwaarʋ zanzan dɩ gwanɩ dɩ ma na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kʋntʋ ŋwaanɩ wʋpolo dɛɛn maa tiini kʋ wʋ tɩʋ kʋntʋ wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tɩʋ kʋm kʋntʋ nɩ nɔɔnʋ dɛɛn ya wʋra, o yɩrɩ mʋ Simɔn. O dɛɛn jɩgɩ liri mwaanʋ mʋ o kɩa. Kʋ maa paɩ Samari tiinǝ bam yɩ yǝǝu dɩd-o. O maa brɩ o tɩtɩ nɩ o yɩ nɔn-kamunu mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tɩʋ kʋm nɔɔna maama maa kwaanɩ ba cǝgi o taanɩ lanyɩranɩ, dɩdɛɛra dɩ nabwǝnǝ maama. Ba maa paɩ Wɛ dam mʋ wʋ o tee nɩ, yɩ ba jɩg-o ba bǝ ba wɩ Dam-fɔrɔ tu. ");
INSERT INTO xsm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","O dɛɛn ya paɩ ba yɩ yǝǝu dɩ o liri mwaanʋ tɩm taan yɩ kʋ daanɩ zanzan. Kʋntʋ ŋwaanɩ mʋ ba kwaanɩ ba cǝg-o lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipi laan ma ba o tɔɔlɩ Wɛ kwǝrǝ o brɩ-ba Wɛ paarɩ dɩm taanɩ dɩ Zezi Krisi yɩrɩ dɩm. O na brɩ-ba kʋntʋ tɩn, nɔɔna bam ma sɛ o taanɩ dɩm. Ba pa ba miisi-ba na wʋnɩ Zezi yɩrɩ ŋwaanɩ, baara dɩ kaana maama. ");
INSERT INTO xsm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn tɩtɩ dɩ ma sɛ, yɩ o daarɩ o pa ba miis-o na wʋnɩ. O ma tɔgɩ dɩdaanɩ Filipi yɩ o naɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ Wɛ dam tɩn. O na nɛ kʋntʋ tɩn, kʋ ma sʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Zezi tɩntʋŋna balʋ na wʋ Zeruzalɛm nɩ tɩn ma ni nɩ Samari tiinǝ bam sɛ Wɛ taanɩ dɩm. Ba ma tʋŋɩ Pɩyɛɛrɩ dɩ Zan ba tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ba na ve ba yi da tɩn, ba ma loori Wɛ ba pa balʋ na sɛ Zezi tɩn sɩ ba wanɩ ba joŋi Wɛ Joro kʋm. ");
INSERT INTO xsm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bɛŋwaanɩ Wɛ Joro kʋm daa ta wʋ tu bantʋ wʋlʋwʋlʋ te. Ba dɛɛn pɛ ba miisi-ba na wʋnɩ dɩ́ Yuutu Zezi yɩrɩ ŋwaanɩ má mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pɩyɛɛrɩ dɩ Zan laan ma daŋɩ ba jɩa ba baŋa nɩ, yɩ ba joŋi Wɛ Joro kʋm ba bɩcara nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Zezi tɩntʋŋna bam na daŋɩ ba jɩa nɔɔna bam baŋa nɩ yɩ ba joŋi Wɛ Joro kʋm kʋntʋ tɩn, yɩ Simɔn na nɛ kʋ na kɩ te tɩn, o ma kwe sǝbu o ma loori Pɩyɛɛrɩ dɩ Zan o wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«A lagɩ sɩ á pa amʋ dɩ taa jɩgɩ dam dɩntʋ doŋ, sɩ a na kwe a jɩa a daŋɩ nɔɔnʋ wʋlʋ baŋa nɩ, sɩ kʋntʋ tu dɩ joŋi Wɛ Joro kʋm.» ");
INSERT INTO xsm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pɩyɛɛrɩ ma lǝr-o o wɩ: «Wɛ wʋ́ cɔgɩ nmʋ dɩ n sǝbu kʋm maama, dɩ nmʋ na bʋŋɩ sɩ nń wanɩ n ma n sǝbu n yǝgi Wɛ pɛɛrɩ dɩm tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nmʋ wʋbʋŋa ba tɔgɩ cɩga Wɛ yigǝ nɩ. Kʋntʋ tɩn, n bá na cwǝŋǝ sɩ n tɔgɩ dɩ dɩbam n tʋŋɩ Wɛ tɩtʋŋa yam. ");
INSERT INTO xsm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nan lǝni n wʋ sɩ n yagɩ wo-balwaarʋ tɩlʋ nmʋ na bʋŋɩ sɩ n kɩ tɩn, sɩ n daarɩ n loori dɩ́ Yuutu Wɛ sɩ, DƖ na sɛ, sɩ DƖ yagɩ n lwarɩm DƖ ma cɛ-m. ");
INSERT INTO xsm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bɛŋwaanɩ a nɛ sɩ n jɩgɩ pu-sɩŋa zanzan, yɩ n wʋ lwarɩm gambɛɛm wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simɔn ma lǝri o wɩ: «Nan loori-na Wɛ á pa-nɩ, sɩ wǝǝnu tɩlʋ maama á na tagɩ amʋ baŋa nɩ tɩn yɩ ba tɩ cɔgɩ-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pɩyɛɛrɩ dɩ Zan dɛɛn ma ŋɔɔnɩ dɩ́ Yuutu Zezi taanɩ dɩm ba brɩ nɔɔna bam. Ba laan ma joori ba maa ve Zeruzalɛm. Ba na maa joori tɩn, ba ma tʋlɩ Samari tɩ-niǝ yam wʋnɩ ba tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Baŋa-Wɛ malɛka ma ba Filipi te ka ta dɩd-o ka wɩ: «Zaŋɩ n da jagwiǝ seeni n vu n da cwǝŋǝ kalʋ na zɩgɩ Zeruzalɛm nɩ ka ve Gaaza tɩn.» Cwǝŋǝ kam kʋntʋ tɔgɩ kagʋa wʋ mʋ ka veǝ. ");
INSERT INTO xsm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi ma zaŋɩ o maa kɛa. Etiyopi tu dɩ dɛɛn maa wʋ cwǝŋǝ kam nɩ o maa ve sɔŋɔ. Wʋntʋ mʋ tʋŋɩ o paɩ ba tɩʋ kʋm pa-kana kalʋ ba na bǝ ba wɩ Kandaasɩ tɩn. O yɩ dɩdɛɛrʋ wʋlʋ na nii o jɩjɩgɩrʋ tɩm maama baŋa nɩ. O dɛɛn ya ve Zeruzalɛm mʋ sɩ o zuli Wɛ, ");
INSERT INTO xsm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yɩ o laan maa joori o ve sɔŋɔ dɩ tǝriko kʋlʋ sise na vaɩ tɩn. O na maa kɛ dɩ o tǝriko kʋm kʋntʋ tɩn, o maa je o karɩmɩ tɔnɔ kʋlʋ Wɛ nijoŋnu Ezayi na pʋpʋnɩ faŋa faŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wɛ Joro kʋm ma brɩ Filipi kʋ wɩ: «Ve n ta n tɔgɩ dɩ tǝriko kʋm.» ");
INSERT INTO xsm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","O ma duri o vu o yi tǝriko kʋm yɩ kʋ veǝ. O ma ni nɔɔnʋ wʋm na jɩgɩ Wɛ nijoŋnu Ezayi tɔnɔ kʋm o karɩma. O ma bwe-o o wɩ: «Nmʋ ni n na karɩmɩ kʋlʋ tɩn kuri na?» ");
INSERT INTO xsm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O ma lǝri o wɩ: «A nan wʋ́ kɩ ta mʋ a ni kʋ kuri, yɩ nɔɔn-nɔɔnʋ wʋ maŋɩ-kʋ o brɩ-nɩ?» O laan ma loori Filipi sɩ o di tǝriko kʋm baŋa o jǝni o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","O na wʋra o karɩmɩ wǝǝnu tɩlʋ tɔnɔ kʋm wʋnɩ tɩn mʋ tɩntʋ: «Wʋntʋ dɛɛn mʋ nyɩ dɩ piǝ kalʋ nɔɔnʋ na vaŋɩ o ja o vu sɩ ba gʋ tɩn. O ta nyɩ dɩ pǝlbu wʋlʋ ba na fanɩ o kʋrʋ yɩ o wʋ kɩ sɔɔ tɩn. O nan wʋ puri o ni o ta kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nɔɔna maa goon-o, yɩ ba wʋ di o taanɩ dɩ cɩga. Wɔɔn wʋ́ wanɩ o ŋɔɔnɩ wʋntʋ dwi dɩm ŋwaŋa? Bɛŋwaanɩ ba lɩ o ŋwɩa lʋgʋ baŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dɩdɛɛrʋ wʋm ma ta dɩ Filipi o wɩ: «A lagɩ a bwe a nii, wɔɔ taanɩ mʋ Wɛ nijoŋnu wʋm tɛa, o tɩtɩ mʋ o tɛ naa nɔɔnʋ wʋdoŋ mʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipi ma joori o puli nɔɔnʋ wʋm na karɩmɩ mɛ tɩn o brɩ-o kʋ kuri, yɩ o daarɩ o ta Zezi kwǝr-ywǝŋǝ kam maama o brɩ-o. ");
INSERT INTO xsm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ba na tɔgɩ cwǝŋǝ kam ba maa kɛ kʋntʋ tɩn, ba ma vu ba yi bugǝ. Dɩdɛɛrʋ wʋm ma ta o wɩ: «Nii, na wʋ yo seeni. N bá wanɩ n miisi-nɩ na wʋnɩ na?»  ");
INSERT INTO xsm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi ma lǝr-o o wɩ: «Nmʋ na sɛ Wɛ cɩga kam dɩ n wʋ maama, aá wanɩ a miisi-m na wʋnɩ.» O ma lǝri o wɩ: «A sɛ sɩ Zezi Krisi yɩ Baŋa-Wɛ Bu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dɩdɛɛrʋ wʋm laan ma pa tǝriko kʋm zɩgɩ. O dɩ Filipi ma tu tɩga ba vu ba zʋ na bam wʋ, yɩ Filipi miis-o na bam wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ba ma nuŋi na bam wʋnɩ. Ba na nuŋi tɩn, dɩ́ Yuutu Wɛ Joro kʋm ma kwe Filipi kʋ ja viiri. Dɩdɛɛrʋ wʋm ma daa wʋ nɛ-o. O ma joori o kwe cwǝŋǝ o maa kɛa, yɩ o jɩgɩ wʋpolo zanzan. ");
INSERT INTO xsm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipi ma na nɩ o wʋ Azoti nɩ mʋ. O ma tʋlɩ tɩɩnɩ dɩm maama o tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam taan, o vu o yi Sezaarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sooli dɛɛn maa kwaana o yaarɩ dɩ́ Yuutu Zezi karabiǝ bam, yɩ o lagɩ sɩ o gʋ-ba. O ma zaŋɩ o vu Zwifǝ bam kaanɩm yuutu wʋm te. ");
INSERT INTO xsm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O ma loor-o sɩ o pʋpʋnɩ twaanʋ o pa Zwifǝ Wɛ-di sɩm na wʋ Damasɩ nɩ tɩn, nɩ wʋm na nɛ nɔɔna balʋ na tɔgɩ Zezi cwǝŋǝ kam, oó ja baara dɩ kaana o ja vu o kɩ pɩɩna digǝ nɩ Zeruzalɛm nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","O na nɛ twaanʋ tɩm tɩn, o ma zaŋɩ o maa ve Damasɩ. O na twɛ tɩʋ kʋm tɩn, pooni ma da dɩ nuŋi wɛyuu dɩ pɩpɩlɩ dɩ gilim-o. ");
INSERT INTO xsm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O ma tʋ tɩga nɩ, yɩ o ni kwǝrǝ na bǝŋi o yɩrɩ ka wɩ: «Sooli, Sooli, bɛŋwaanɩ mʋ n jɩgɩ amʋ n bɛɛsɩ kʋntʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O ma bwe o wɩ: «A tu, nmʋ yɩ wɔɔ mʋ?» Kwǝrǝ kam ma ta ka wɩ: «Amʋ yɩ Zezi wʋlʋ nmʋ na jɩgɩ n bɛɛsɩ tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nan zaŋɩ n zʋ tɩʋ kʋm wʋ. Nmʋ na yi da, ba laan wʋ́ ta kʋlʋ nmʋ na maŋɩ sɩ n kɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nɔɔna balʋ na tɔgɩ dɩ Sooli tɩn maa zɩgɩ da, yɩ ba warɩ kʋlʋkʋlʋ sɩ ba ta. Ba dɛɛn ni kwǝrǝ kam, yɩ ba nan wʋ nɛ nɔɔn-nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sooli ma zaŋɩ wɛɛnɩ o puri o yiǝ yɩ o daa ba naɩ. Ba ma ja-o o jɩŋa nɩ, ba vaŋ-o ba ja zʋ Damasɩ wʋ. ");
INSERT INTO xsm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kʋ dɛɛn jɩgɩ da yatɔ mʋ o yiǝ na dwe. Maŋa kam kʋntʋ nɩ o wʋ di, o nan wʋ nyɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Zezi karabu wʋdoŋ dɛɛn maa wʋ Damasɩ nɩ, o yɩrɩ mʋ Ananiya. O ma na vɩɩrɩm wʋnɩ dɩ́ Yuutu wʋm na ŋɔɔnɩ dɩd-o. O ma bǝŋi o yɩrɩ o wɩ: «Ananiya!» O ma lǝri o wɩ: «A yuutu, nii-nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dɩ́ Yuutu wʋm ma ta dɩd-o o wɩ: «Zaŋɩ n vu Zudasɩ sɔŋɔ, kʋ na zɩgɩ cwǝŋǝ kalʋ yɩrɩ na yɩ ‹Yɔɔrɔ-tɔtɔ› tɩn ni nɩ. Nmʋ na yi da, sɩ n bwe nɔɔnʋ wʋlʋ yɩrɩ na yɩ Sooli tɩn bwiǝ. O yɩ Tarɩsɩ tu mʋ. Nmʋ wʋ́ na o na wʋra o warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Vɩɩrɩm wʋnɩ mʋ o nɛ nɔɔnʋ, o yɩrɩ mʋ Ananiya. O ma na-o yɩ o ba o daŋɩ o jɩa o baŋa nɩ, sɩ o yiǝ yam joori ya taa naɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya na ni kʋntʋ tɩn, o ma lǝri o wɩ: «A yuutu, nɔɔna zanzan maŋɩ ba ta nɔɔnʋ wʋm kʋntʋ taanɩ ba brɩ amʋ, dɩ o na kɩ wo-balwaarʋ tɩlʋ maama o ma cɔgɩ nmʋ nɔɔna balʋ na wʋ Zeruzalɛm nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","O nan tu yo dɩ ni dɩlʋ o na joŋi Zwifǝ kaanɩm yigǝ tiinǝ bam tee nɩ tɩn mʋ, sɩ o ma ja balʋ maama na bǝ nmʋ nɩ ba Yuutu tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dɩ́ Yuutu wʋm ma ta dɩd-o o wɩ: «Nan ve, bɛŋwaanɩ wʋntʋ mʋ yɩ wʋlʋ amʋ na kuri sɩ o taa tʋŋɩ o pa-nɩ, sɩ o daarɩ o pa amʋ yɩrɩ dɩm zaŋɩ Yisɩrayɛlɩ tiinǝ bam tee nɩ dɩdaanɩ dwi-gɛ tiinǝ dɩ ba pwa dɩ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Amʋ tɩtɩ nan wʋ́ brɩ-o yaara yalʋ maama o na maŋɩ sɩ o na amʋ yɩrɩ ŋwaanɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiya laan ma zaŋɩ o vu o yi sɔŋɔ kʋm o zʋ. O ma na Sooli yɩ o daŋɩ o jɩa o baŋa nɩ o wɩ: «A ko-bu Sooli, dɩ́ Yuutu Zezi tɩtɩ mʋ tʋŋɩ amʋ nmʋ tee nɩ. Wʋntʋ ya mʋ brɩ o tɩtɩ nmʋ yigǝ nɩ maŋa kalʋ n ya na wʋ cwǝŋǝ nɩ n maa n bɩɩnɩ tɩn. O tʋŋɩ-nɩ sɩ a ba a pa n joori n ta n naɩ mʋ, sɩ n daarɩ n joŋi Wɛ Joro kʋm dam.» ");
INSERT INTO xsm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananiya na tagɩ kʋntʋ tɩn, bɩdwɩ baŋa nɩ mʋ wǝǝnu dwanɩ Sooli yiǝ nɩ tɩ tʋ tɩga nɩ nɩnɛɛnɩ ŋwam-pʋrrʋ te tɩ daarɩ, yɩ o laan naɩ. O ma zaŋɩ o zɩgɩ wɛɛnɩ. O ma pa ba miis-o na wʋnɩ Zezi yɩrɩ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","O laan ma di wʋdiu yɩ o dam joori dɩ ba. O ma maŋɩ Zezi karabiǝ bam tee nɩ Damasɩ nɩ da fɩnfɩɩn. ");
INSERT INTO xsm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sooli dɛɛn na wʋ Damasɩ nɩ kʋntʋ tɩn, o maa yǝni o vu Zwifǝ bam Wɛ-di sɩm o brɩ-ba Zezi taanɩ. O maa tɛ o wɩ: «Zezi yɩ Wɛ Bu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kʋ ma sʋ nɔɔna balʋ maama na ni o zaasɩm dɩm tɩn. Ba ma bwe daanɩ ba wɩ: «Kʋ daɩ nɔɔnʋ wʋntʋ dɛɛn mʋ wʋ Zeruzalɛm nɩ o cɔgɩ balʋ na ma Zezi ba bǝ nɩ ba Yuutu tɩn na? Kʋ nan daɩ kʋntʋ ŋwaanɩ mʋ o tu yo seeni, sɩ o taa jaanɩ Zezi karabiǝ o ve o paɩ Zwifǝ kaanɩm yigǝ tiinǝ bam na?» ");
INSERT INTO xsm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sooli dɛɛn maa ve yigǝ dɩ baarɩ zanzan, yɩ o brɩ nɔɔna bam nɩ Zezi mʋ sɩɩnɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. Kʋ ma paɩ Zwifǝ balʋ na zʋʋrɩ Damasɩ nɩ tɩn daa warɩ o ni-taanɩ ba lǝri. ");
INSERT INTO xsm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Da zanzan na kɛ tɩn, Zwifǝ bam ma kɩ ni daanɩ sɩ ba gʋ Sooli. ");
INSERT INTO xsm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","O ma lwarɩ ba na bʋŋɩ sɩ ba kɩ-o kʋlʋ tɩn. Dɛ maama wɩa dɩ tɩtɩɩ ba zɩgɩ ba yɩrɩ tɩʋ kʋm niǝ yam mʋ, sɩ Sooli na tu sɩ o da da, sɩ ba laan gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dɛ dɩdwɩ tɩtɩɩ nɩ mʋ o karabiǝ bam ma pa o zʋ tɩtɔgɔ wʋ, yɩ ba lǝ ŋʋna kʋ ni nɩ ba pa o da kǝbrǝ o tu tɩga yɩ o lu. ");
INSERT INTO xsm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sooli laan ma vu Zeruzalɛm. O maa kwaanɩ sɩ o tɔgɩ o wǝli Zezi karabiǝ bam wʋnɩ. Ba maama maa fʋna dɩd-o, yɩ ba ba bʋŋɩ nɩ o sɩɩnɩ o ji Zezi karabu. ");
INSERT INTO xsm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Banabasɩ ma vu o zǝn-o, yɩ o ja-o o vu Zezi tɩntʋŋna bam te. O ma ta o brɩ-ba Sooli na nɛ dɩ́ Yuutu Zezi cwǝŋǝ nɩ yɩ o ŋɔɔnɩ dɩd-o te tɩn. O ta ma ta o brɩ-ba Sooli na kwaanɩ o ŋɔɔnɩ dɩ baarɩ o pa balʋ na wʋ Damasɩ nɩ tɩn lwarɩ Wɛ cɩga kam dɩ Zezi yɩrɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sooli ma maŋɩ Zezi karabiǝ bam tee nɩ, yɩ o tʋlɩ Zeruzalɛm ni maama o tɔɔlɩ Wɛ kwǝrǝ dɩ dɩ́ Yuutu Zezi yɩrɩ o brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","O maa yǝni o ŋɔɔnɩ dɩ Zwifǝ balʋ na ŋɔɔnɩ Grɛkɩ tiinǝ taanɩ tɩn, yɩ o magɩ kantɔgɔ dɩ ba. Ba laan maa kwaanɩ sɩ ba gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Zezi karabiǝ bam na lwarɩ kʋntʋ tɩn, ba ma ja-o ba ja vu Sezaarɩ, yɩ ba pa o kɛ o vu Tarɩsɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Zezi kɔgɔ kʋm nɔɔna balʋ maama na wʋ Zude dɩ Galile dɩ Samari je sɩm nɩ tɩn dɛɛn ma na siun dɩ ba yaara yam. Ba kɔgɔ kʋm ma fɔgɩ kʋ pulǝ kʋ wǝli da, Wɛ Joro kʋm na zǝni-ba tɩn ŋwaanɩ. Ba maa tɔgɩ dɩ́ Yuutu yɩ ba sɛ-o ba ŋwɩa maama wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pɩyɛɛrɩ dɛɛn yǝni o beeri o ve je maama mʋ o nii Zezi karabiǝ bam. Dɛ dɩdwɩ o daa ma zaŋɩ o vu sɩ o nii karabiǝ balʋ na zʋʋrɩ Lidi nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O na yi da tɩn, o ma na nɔɔnʋ o yɩrɩ mʋ Ene. O dɛɛn yɩ kɔrɔ mʋ, yɩ o tigi bɩna nana o warɩ o zaŋɩ wɛɛnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pɩyɛɛrɩ na nɛ-o tɩn, o ma ta dɩd-o o wɩ: «Ene, Zezi Krisi wʋ́ pa-m yazurǝ. Nan zaŋɩ wɛɛnɩ sɩ n pri n sara kam n tiŋi.» O na tagɩ kʋntʋ bɩdwɩ baŋa nɩ tɩn, mʋ Ene zaŋɩ wɛɛnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nɔɔna balʋ maama na zʋʋrɩ Lidi nɩ dɩ Sarɔn je sɩm maama nɩ tɩn ma na Ene na nɛ yazurǝ. Ba laan ma ba ba tɔgɩ dɩ́ Yuutu Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kaanɩ wʋdoŋ dɛɛn mʋ wʋ Zope nɩ, o yɩrɩ mʋ Tabita. (O yɩrɩ dɩdaanɩ Grɛkɩ tiinǝ taanɩ mʋ yɩ Dɔrkasɩ, dɩ kuri mʋ fǝrǝ.) O maa yɩ Zezi karabu. O maa kɩ lanyɩranɩ yɩ o wǝli yinigǝ tiinǝ zanzan. ");
INSERT INTO xsm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Maŋa kam kʋntʋ nɩ, o ma ba o ba jɩgɩ yazurǝ yɩ o tɩ. Nɔɔna ma kwe-o ba swɛ, yɩ ba ja-o ba di wɛyuu digǝ ba tiŋi da. ");
INSERT INTO xsm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Zope nan batwarɩ dɩdaanɩ Lidi. Kʋntʋ tɩn, Zezi karabiǝ balʋ na wʋ Zope nɩ tɩn ma lwarɩ nɩ Pɩyɛɛrɩ tu Lidi o wʋra. Ba ma tʋŋɩ nɔɔna bale o tee nɩ. Ba ma vu ba loor-o ba wɩ: «Popo, kɩ lɩla n ba dɩbam tɩʋ kʋm.» ");
INSERT INTO xsm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pɩyɛɛrɩ ma zaŋɩ o tɔgɩ dɩ ba o kɛ. O na yi Zope tɩn, ba ma ja-o ba di wɛyuu digǝ kam. Kadǝnǝ bam maama maa zɩgɩ ba gilim-o yɩ ba keerǝ. Ba ma brɩ-o gwaarʋ tɩlʋ maama Dɔrkasɩ ya na ŋwɩ yɩ o nyaanɩ-tɩ o pa-ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɩyɛɛrɩ laan ma pa ba maama nuŋi pooni ba daar-o. O ma kuni doonǝ tɩga nɩ o warɩ Wɛ. O laan ma pipiri o nii tʋ wʋm yɩ o wɩ: «Tabita, zaŋɩ wɛɛnɩ.» O ma puri o yiǝ o na Pɩyɛɛrɩ. O ma zaŋɩ o je. ");
INSERT INTO xsm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pɩyɛɛrɩ ma twɩ o jɩŋa o ja-o o pa o zaŋɩ wɛɛnɩ o zɩgɩ. O laan ma bǝŋi kadǝnǝ bam dɩ Zezi karabiǝ bam maama. O ma pa Tabita zɩgɩ ba yigǝ nɩ yɩ o brɩ-ba sɩ o ŋwɩ. ");
INSERT INTO xsm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Zope je sɩm nɔɔna bam maama ma ni kǝm dɩm kʋntʋ ŋwa. Kʋ ma paɩ nɔɔna zanzan kɩ ba wʋ-dɩdʋa dɩ dɩ́ Yuutu Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pɩyɛɛrɩ ma maŋɩ Zope nɩ taan da zanzan. O dɛɛn zʋʋrɩ tɔn-gɔgɔ kʋdoŋ tee nɩ mʋ, o yɩrɩ mʋ Simɔn. ");
INSERT INTO xsm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Kɔrɩnɛɛlɩ. O maa zʋʋrɩ Sezaarɩ nɩ. O dɛɛn yɩ Rom pamaŋna dɩdɛɛrʋ mʋ. Pamaŋna kɔgɔ kʋlʋ o na tɔgɩ o wʋ kʋ wʋnɩ tɩn yɩrɩ mʋ Yitali tiinǝ kɔgɔ. ");
INSERT INTO xsm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","O dɛɛn kwarɩ Wɛ, yɩ o dɩ o sɔŋɔ tiinǝ maama zuli Wɛ lanyɩranɩ. O maa kɩ wǝǝnu zanzan o wǝli Zwifǝ yinigǝ tiinǝ bam. O maa yǝni o warɩ Wɛ maŋa maama. ");
INSERT INTO xsm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dɛ dɩdwɩ wɛ na guni maŋa kalʋ tɩn, o nɛ vɩɩrɩm. O ma na Wɛ malɛka na tu ka bǝŋi o yɩrɩ ka wɩ: «Kɔrɩnɛɛlɩ!» ");
INSERT INTO xsm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O maa nii malɛka kam yɩ fʋʋnɩ jɩg-o. O ma ta o wɩ: «Kʋ yɩ ta, a tu.» Malɛka kam ma lǝr-o ka wɩ: «Nmʋ na yǝni n warɩ Wɛ yɩ n kwǝri n wǝli yinigǝ tiinǝ tɩn, kʋ yi Baŋa-Wɛ wʋbʋŋa. DƖ nan guli nmʋ gulǝ. ");
INSERT INTO xsm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Laan nan tʋŋɩ nɔɔna sɩ ba vu Zope ba bǝŋi nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Simɔn Pɩyɛɛrɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","O yɩ vǝru mʋ o wʋ Simɔn wʋlʋ na yɩ tɔn-gɔgɔ tɩn sɔŋɔ nɩ, nɩnɩʋ kʋm ni nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malɛka kam na tagɩ dɩd-o kʋntʋ ka ti tɩn, ka ma viiri. Kɔrɩnɛɛlɩ ma bǝŋi o sɔŋɔ kʋm tɩntʋŋna bale dɩ pamaŋnʋ dɩdʋa wʋlʋ na tʋŋɩ o pa-o yɩ o dɩ kwarɩ Wɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O ma ta kʋlʋ maama na kɩ tɩn o brɩ-ba, yɩ o daarɩ o tʋŋɩ-ba sɩ ba vu Zope. ");
INSERT INTO xsm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tɩga na pʋʋrɩ yɩ nɔɔna bam wʋ cwǝŋǝ nɩ ba ma twɛ Zope tɩn, kʋ maŋɩ dɩ Pɩyɛɛrɩ dɩ diini sɔŋɔ kʋm nayuu sɩ o warɩ Wɛ wɩa tɩtarɩ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kana laan maa jɩg-o yɩ o lagɩ wʋdiu sɩ o di. Ba na wʋra ba kɩ wʋdiu kʋm tɩn, Wɛ ma pa o na wo-kɩnkagɩlɩ nɩ dɩndwɩa mʋ te. ");
INSERT INTO xsm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O nɛ wɛyuu na pʋrɩ o baŋa nɩ, yɩ woŋo nuŋi da kʋ maa tu tɩga. Woŋo kʋm nyɩ dɩ gɔrɔ kamunu mʋ, yɩ ba jɩgɩ kʋ niǝ yana, yɩ kʋ maa tu tɩga. ");
INSERT INTO xsm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Vara dwi maama mʋ wʋ kʋ wʋnɩ, dɩdaanɩ tɩga wo-vǝǝlu dɩ zunǝ. ");
INSERT INTO xsm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","O na nɛ tɩn, o ma ni kwǝrǝ na ŋɔɔnɩ dɩd-o ka wɩ: «Pɩyɛɛrɩ, zaŋɩ n gʋ wǝǝnu tɩntʋ n di.» ");
INSERT INTO xsm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pɩyɛɛrɩ ma lǝri o wɩ: «Amʋ tu, a bá sɛ. A ta wʋ fɔgɩ a di dɩbam cullu woŋo naa kʋlʋ na wʋ maŋɩ dɩ dim tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","O daa ta ma joori o ni kwǝrǝ kam na wɩ: «Yɩ zaŋɩ n culi woŋo kʋlʋ Wɛ na wɩ kʋ yɩ lanyɩranɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kʋ kɩ kʋntʋ mʋ kuni bɩtɔ. Wǝǝnu tɩm laan ma joori tɩ vaŋɩ tɩ di wɛyuu. ");
INSERT INTO xsm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pɩyɛɛrɩ maa bwɛ wo-kɩnkagɩlɩ dɩm o na nɛ tɩn kuri. Ka maŋa kam nɩ mʋ nɔɔna balʋ Kɔrɩnɛɛlɩ na tʋŋɩ o tee nɩ tɩn bwe ba lwarɩ Simɔn sɔŋɔ kʋm je. Ba laan ma vu ba yi mancoŋo kʋm ba zɩga. ");
INSERT INTO xsm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ba ma bǝŋi nɔɔnʋ ba bwe ba wɩ: «Nɔɔnʋ zʋʋrɩ yo o yɩrɩ mʋ Simɔn Pɩyɛɛrɩ na?» ");
INSERT INTO xsm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pɩyɛɛrɩ daa ta na wʋra o bwɛ sɩ o lwarɩ wo-kɩnkagɩlɩ dɩm kuri tɩn, Wɛ Joro kʋm ma ta dɩd-o kʋ wɩ: «Nii, nɔɔna batɔ mʋ tu ba lagɩ nmʋ. ");
INSERT INTO xsm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Zaŋɩ n tu tɩga. Yɩ ta n bwɛa, sɩ n tɔgɩ dɩ ba n vu, bɛŋwaanɩ amʋ mʋ tʋŋɩ-ba.» ");
INSERT INTO xsm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pɩyɛɛrɩ ma tu tɩga, yɩ o ta dɩ ba o wɩ: «Amʋ mʋ yɩ wʋlʋ abam na lagɩ tɩn. Bɛɛ mʋ jaanɩ abam kʋ ba?» ");
INSERT INTO xsm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba ma lǝri ba wɩ: «Pamaŋna dɩdɛɛrʋ Kɔrɩnɛɛlɩ mʋ tʋŋɩ dɩbam. O yɩ nɔn-ŋʋm mʋ yɩ o kwarɩ Wɛ lanyɩranɩ. Zwifǝ bam maama maa zul-o. Wɛ malɛka mʋ tagɩ dɩd-o sɩ o bǝŋi nmʋ o sɔŋɔ nɩ, sɩ o wanɩ o ni kʋlʋ nmʋ na lagɩ n ta tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pɩyɛɛrɩ ma pa ba zʋ sɔŋɔ kʋm ba pǝni. Tɩga na pʋʋrɩ tɩn o ma zaŋɩ o tɔgɩ dɩ ba o vu. Zezi karabiǝ badaara dɩ ma zaŋɩ Zope nɩ ba tɔgɩ dɩd-o ba vu. ");
INSERT INTO xsm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Tɩga daa na pʋʋrɩ tɩn mʋ o yi Sezaarɩ. O yi da dɩdaanɩ Kɔrɩnɛɛlɩ dɩ o sɔŋɔ tiinǝ dɩ o badonnǝ balʋ o na bǝŋi tɩn maŋɩ ba je ba cǝg-o. ");
INSERT INTO xsm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pɩyɛɛrɩ na yi sɔŋɔ kʋm yɩ o maa zʋʋrɩ tɩn, Kɔrɩnɛɛlɩ ma zaŋɩ o nuŋi o jeer-o, yɩ o kuni doonǝ o yigǝ nɩ o jɔɔn-o. ");
INSERT INTO xsm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pɩyɛɛrɩ ma pa o zaŋɩ wɛɛnɩ o zɩgɩ, yɩ o ta dɩd-o o wɩ: «Amʋ dɩ yɩ nabiinu mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","O ta maa ŋɔɔnɩ dɩd-o yɩ ba maa zʋʋrɩ sɔŋɔ kʋm. O ma na nɔn-kɔgɔ na kikili da ba je. ");
INSERT INTO xsm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O ma ta dɩ nɔɔna bam o wɩ: «Abam maŋɩ á ye nɩ kʋ culǝ sɩ Zwifu taa zʋʋrɩ dɩdaanɩ dwi-gɛ tiinǝ, naa o taa tɔgɩ dɩ ba. Wɛ nan mʋ brɩ amʋ nɩ kʋ wʋ maŋɩ sɩ a taa culi nɔɔn-nɔɔnʋ naa a paɩ o taa yɩ nɔn-diku. ");
INSERT INTO xsm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kʋntʋ ŋwaanɩ mʋ, abam na tʋŋɩ á bǝŋi-nɩ tɩn, a wʋ vɩn yɩ a ba. A nan lagɩ a bwe a nii, bɛŋwaanɩ mʋ á tʋŋɩ á bǝŋi-nɩ?» ");
INSERT INTO xsm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrɩnɛɛlɩ ma ta o wɩ: «Zɩm mʋ jɩgɩ da yana, kʋ maŋɩ dɩ maŋa kantʋ nɩ wɛ na guni tɩn, dɩ a wʋra a warɩ Wɛ a sɔŋɔ nɩ, nɔɔnʋ ma da o ba o zɩgɩ a yigǝ nɩ. O zʋ gwaarʋ tɩ na nyɩɩna. ");
INSERT INTO xsm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","O ma ta dɩ amʋ o wɩ: ‹Kɔrɩnɛɛlɩ, Wɛ mʋ joŋi n loro kʋm. Nmʋ na wǝli yinigǝ tiinǝ tɩn mʋ DƖ guli nmʋ gulǝ. ");
INSERT INTO xsm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nan tʋŋɩ nɔɔna sɩ ba vu Zope ba bǝŋi nɔɔnʋ wʋdoŋ, o yɩrɩ mʋ Simɔn Pɩyɛɛrɩ. O yɩ vǝru mʋ, o wʋ Simɔn wʋlʋ na yɩ tɔn-gɔgɔ tɩn sɔŋɔ nɩ. O zʋʋrɩ nɩnɩʋ kʋm ni nɩ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","O na tagɩ kʋntʋ tɩn, a ma tʋŋɩ nɔɔna lɩla sɩ ba vu ba bǝŋi nmʋ sɩ n ba. Nmʋ na tu tɩn, n kɩ cɩga. Dɩbam maama nan zɩgɩ Wɛ yigǝ nɩ mʋ dɩ́ cǝgi, sɩ dɩ́ ni kʋlʋ maama dɩ́ Yuutu wʋm na pɛ-m sɩ n ta tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pɩyɛɛrɩ laan ma zaŋɩ o ta o wɩ: «A zɩm lwarɩ nɩ kʋ yɩ cɩga mʋ sɩ Wɛ ba kuri nɔɔna daanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Wɛ joŋi nɔɔnʋ wʋlʋ maama na kwarɩ-DƖ yɩ o kɩ kʋlʋ na lana tɩn mʋ, kʋ na maŋɩ kʋ yɩ dwi dɩlʋ nɔɔnʋ. ");
INSERT INTO xsm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Abam maŋɩ á ye Wɛ na tagɩ DƖ taanɩ dɩm DƖ brɩ Yisɩrayɛlɩ tiinǝ bam, nɩ Zezi Krisi mʋ waɩ o joŋi nɔɔna o fɔgɩ ba dɩ Wɛ daanɩ. Wʋntʋ mʋ yɩ nabiinǝ maama Yuutu. ");
INSERT INTO xsm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Abam ta ye wo-kamunnu tɩlʋ maama na kɩ Zude nɩ tɩn. Kʋ dɛɛn puli Galile nɩ mʋ, maŋa kam Zan na tɔɔlɩ Wɛ kwǝrǝ dɩ nɔɔna sɩ ba miisi na wʋnɩ tɩn kwaga nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Abam maŋɩ á ye Wɛ na pɛ DƖ Joro kʋm Nazarɛtɩ tu Zezi yɩ DƖ kwǝri DƖ pa-o dam te tɩn. Wɛ na wʋ o tee nɩ kʋntʋ tɩn, o yǝni o ve je maama o kɩ nɔɔna lanyɩranɩ, yɩ o kwǝri o vrɩ balʋ na wʋ sʋtaanɩ jɩŋa nɩ tɩn o yaga. ");
INSERT INTO xsm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Dɩbam nan mʋ nɛ wǝǝnu tɩlʋ maama o na kɩ Zeruzalɛm nɩ dɩ Zwifǝ tɩɩnɩ dɩm maama nɩ tɩn, yɩ dɩ́ yɩ cɩga kantʋ maana tiinǝ. Ba dɛɛn jaan-o mʋ ba pa tʋʋn-dagara baŋa nɩ ba gʋ. ");
INSERT INTO xsm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wɛ ma pa o joori o bi o yagɩ tʋʋnɩ da yatɔ dɛ nɩ. DƖ ma pa o brɩ o tɩtɩ nɔɔna yigǝ nɩ sɩ ba na-o. ");
INSERT INTO xsm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kʋ nan daɩ nɩ nɔɔna maama mʋ nɛ-o, kʋ yɩ dɩbam balʋ Wɛ na maŋɩ DƖ kuri sɩ dɩ́ taá yɩ o maana tiinǝ tɩn mʋ nɛ-o. Zezi na bi o yagɩ tʋʋnɩ tɩn, dɩbam tɔgɩ dɩd-o dɩ́ di wʋdiu yɩ dɩ́ nyɔ na. ");
INSERT INTO xsm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O ma pa dɩbam ni sɩ dɩ́ tɔɔlɩ Wɛ kwǝrǝ kam dɩ́ brɩ nɔɔna, dɩ́ pa ba lwarɩ nɩ wʋm mʋ yɩ wʋlʋ Wɛ na tiŋi sɩ o di naŋʋna dɩ balʋ na tɩgɩ tɩn taanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Faŋa faŋa Wɛ nijoŋnǝ bam maama dɛɛn tagɩ wʋntʋ taanɩ ba wɩ, nɔɔnʋ wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩd-o tɩn, Wɛ wʋ́ yagɩ kʋntʋ tu lwarɩm DƖ ma cɛ-o wʋntʋ yɩrɩ ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pɩyɛɛrɩ ta na wʋra o ŋɔɔnɩ kʋntʋ tɩn, Wɛ Joro kʋm ma tu balʋ maama na je ba cǝgi o taanɩ dɩm tɩn yuu nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wɛ na pɛ DƖ Joro kʋm dwi-gɛ tiinǝ dɩ tɩn, kʋ darɩ Zwifǝ balʋ na maŋɩ ba tɔgɩ Zezi yɩ ba da dɩ Pɩyɛɛrɩ ba ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bɛŋwaanɩ ba ni ba na ŋɔɔnɩ ta-gɛ yɩ ba kwǝri ba zuli Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pɩyɛɛrɩ laan ma ta o wɩ: «Nɔɔna bantʋ sɩɩnɩ ba joŋi Wɛ Joro kʋm nɩ dɩbam dɩ na joŋi te tɩn mʋ. Kʋntʋ tɩn, dɩ́ wʋ́ wanɩ dɩ́ cɩ ba yigǝ sɩ ba yɩ miisi na wʋnɩ dɩ Zezi yɩrɩ na?» ");
INSERT INTO xsm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","O ma daarɩ o pa ni sɩ ba miisi-ba na wʋnɩ Zezi Krisi yɩrɩ ŋwaanɩ. Ba laan ma loori Pɩyɛɛrɩ sɩ o maŋɩ ba tee nɩ da fɩnfɩɩn. ");
INSERT INTO xsm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Zezi tɩntʋŋna bam dɩ o karabiǝ balʋ na zʋʋrɩ Zude nɩ tɩn ma ni nɩ dwi-gɛ tiinǝ dɩ laan sɛ Wɛ kwǝrǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pɩyɛɛrɩ dɛɛn ma zaŋɩ o vu Zeruzalɛm. O na yi da tɩn, Zwifǝ balʋ na tɔgɩ Zezi tɩn ma magɩ kantɔgɔ dɩd-o. ");
INSERT INTO xsm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ba ma bwe-o ba wɩ: «Bɛɛ mʋ yɩ n vu n zʋ dwi-gɛ tiinǝ sɔŋɔ yɩ ba yɩ balʋ na ba goni ba bǝkǝri tɩn? Bɛɛ mʋ yɩ n di wʋdiu dɩ ba?» ");
INSERT INTO xsm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pɩyɛɛrɩ ma zaŋɩ o tʋlɩ kʋlʋ maama na kɩ tɩn o brɩ-ba o wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«A ya wʋ Zope nɩ mʋ a warɩ Wɛ. Wɛ ma pa a na vɩɩrɩm. A nɛ wo-kamunu na nuŋi wɛyuu kʋ maa tu tɩga. Kʋ nyɩ dɩ gɔrɔ kamunu mʋ, yɩ ba jɩgɩ kʋ niǝ yana ba pa kʋ maa tu tɩga. Kʋ ma ba kʋ zɩgɩ a yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A ma nii kʋ wʋnɩ yɩ a na vara na wʋra, sɔŋɔ vara dɩ ga-vara dɩ tɩga wo-vǝǝlu dɩ zunǝ. ");
INSERT INTO xsm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","A laan ma ni kwǝrǝ na ŋɔɔnɩ dɩ amʋ ka wɩ: ‹Pɩyɛɛrɩ, zaŋɩ n gʋ n di.› ");
INSERT INTO xsm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","A ma lǝri a wɩ: ‹A tu, aye a bá sɛ. A maŋɩ a wʋ di dɩbam cullu woŋo naa kʋlʋ na wʋ maŋɩ dɩ dim tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kwǝrǝ kam daa ta ma joori ka zɩgɩ wɛyuu nɩ ka ŋɔɔnɩ ka wɩ: ‹Yɩ zaŋɩ n culi woŋo kʋlʋ Wɛ na wɩ kʋ yɩ lanyɩranɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kʋ ma kɩ kʋntʋ taan kuni bɩtɔ, yɩ wǝǝnu tɩm maama joori tɩ vaŋɩ tɩ di wɛyuu. ");
INSERT INTO xsm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Maŋa kantʋ nɩ nɔɔna batɔ dɛɛn tu ba zɩgɩ sɔŋɔ kʋlʋ amʋ na zʋʋrɩ da tɩn ni nɩ. Ba ya tʋŋɩ-ba Sezaarɩ nɩ mʋ sɩ ba ba amʋ te. ");
INSERT INTO xsm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wɛ Joro kʋm ma ta kʋ brɩ-nɩ kʋ wɩ, a yɩ taa bwɛa, sɩ a tɔgɩ dɩ ba a vu. Dɩ́ ko-biǝ bantʋ bardʋ dɩ ma da amʋ ba vu. Dɩ́ maama ma vu dɩ́ yi Sezaarɩ, yɩ dɩ́ vu dɩ́ zʋ Kɔrɩnɛɛlɩ sɔŋɔ kʋm. ");
INSERT INTO xsm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O ma ta o brɩ dɩbam o na nɛ Wɛ malɛka na tu o sɔŋɔ ka zɩgɩ yɩ ka ta dɩd-o ka wɩ: ‹Tʋŋɩ nɔɔna sɩ ba vu Zope ba bǝŋi nɔɔnʋ wʋdoŋ o yɩrɩ na yɩ Simɔn Pɩyɛɛrɩ tɩn sɩ o ba. ");
INSERT INTO xsm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wʋntʋ na tuǝ, o laan wʋ́ ŋɔɔnɩ taanɩ dɩlʋ na wʋ́ pa nmʋ dɩ n sɔŋɔ tiinǝ bam maama na vrɩm tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","A na sɩŋɩ sɩ a ŋɔɔnɩ dɩ ba tɩn, mʋ Wɛ Joro kʋm tu ba te nɩnɛɛnɩ kʋ na maŋɩ kʋ tu dɩbam te pulim nɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","A laan ma guli dɩ́ Yuutu Zezi dɛɛn na tagɩ te o wɩ: ‹Zan dɛɛn miisi nɔɔna bam na wʋnɩ mʋ, Wɛ nan wʋ́ miisi abam DƖ Joro kʋm wʋnɩ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kʋ sɩɩnɩ kʋ yɩ cɩga mʋ nɩ Wɛ pɛ dwi-gɛ tiinǝ bantʋ DƖ pɛɛrɩ dɩm, nɩ DƖ na maŋɩ DƖ pa dɩbam dɩ, maŋa kalʋ dɩ́ na kɩ dɩ́ wʋ-dɩdʋa dɩ dɩ́ Yuutu Zezi Krisi tɩn. Kʋntʋ tɩn, a nan yɩ wɔɔ mʋ sɩ a cɩ Wɛ yigǝ?» ");
INSERT INTO xsm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pɩyɛɛrɩ na tagɩ kʋntʋ yɩ ba ni tɩn, ba ma yagɩ taanɩ dɩm yɩ ba daarɩ ba zuli Wɛ. Ba maa wɩ: «Wɛ sɩɩnɩ DƖ pa dwi-gɛ tiinǝ bam dɩ cwǝŋǝ sɩ ba lǝni ba wʋrʋ, sɩ ba daarɩ ba na DƖ ŋwɩ-dʋŋa kam.» ");
INSERT INTO xsm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Maŋa kam ba dɛɛn na gʋ Etiyɛnɩ tɩn, nɔɔna yaarɩ Zezi karabiǝ bam kʋ pa ba jagɩ da-yigǝ nɩ. Balʋ na jagɩ tɩn badonnǝ ma vu ba yi Fenisi dɩ Sipri dɩ Antɩɔsɩ. Ba na jagɩ kʋntʋ tɩn, ba yǝni ba tɔɔlɩ Wɛ kwǝrǝ kam ba brɩ Zwifǝ bam yɩranɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kʋ daarɩ Zezi karabiǝ badaara na nuŋi Sipri dɩ Sirɛɛnɩ tɩn ma zaŋɩ ba vu Antɩɔsɩ ba tɔɔlɩ dɩ́ Yuutu Zezi kwǝr-ywǝŋǝ kam ba brɩ dwi-gɛ tiinǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Baŋa-Wɛ dam maa wʋ ba tee nɩ. Nɔɔna zanzan ma kɩ ba wʋ-dɩdʋa dɩ dɩ́ Yuutu Zezi yɩ ba tɔg-o. ");
INSERT INTO xsm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Zezi kɔgɔ kʋlʋ na wʋ Zeruzalɛm nɩ tɩn ma ni kʋlʋ na kɩ tɩn. Ba ma tʋŋɩ Banabasɩ sɩ o vu Antɩɔsɩ o nii. ");
INSERT INTO xsm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","O na ve o yi da tɩn, o ma na Wɛ na sɩɩnɩ DƖ kɩ nɔɔna bam lanyɩranɩ te tɩn. O maa jɩgɩ wʋpolo lanyɩranɩ. O ma kwe ba maama kwiǝ yalʋ na wʋ́ pa ba taa tɔgɩ dɩ́ Yuutu wʋm dɩ ba wʋ maama sɩ ba yɩ zaŋɩ ba yagɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabasɩ dɛɛn yɩ nɔn-ŋʋm. O maa tiini o jɩgɩ wʋ-dɩdʋa dɩ Zezi, yɩ Wɛ Joro kʋm wʋ o tee nɩ dɩ dam. Nɔɔna zanzan dɛɛn ma ba ba tɔgɩ dɩ́ Yuutu wʋm, yɩ ba dɩ wǝli o kɔgɔ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabasɩ laan ma zaŋɩ o vu Tarɩsɩ sɩ o beeri Sooli je. ");
INSERT INTO xsm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","O na ve o na-o tɩn, o ma ja-o o joori Antɩɔsɩ. Ba na wʋra tɩn, ba maa yǝni ba wǝli daanɩ ba brɩ Zezi kɔgɔ kʋm Wɛ taanɩ. Ba kɩ kʋntʋ taan sɩ kʋ vu kʋ yi bɩm, yɩ nɔɔna balʋ ba na brɩ tɩn dagɩ zanzan. Kʋ yɩ Antɩɔsɩ nɩ mʋ ba puli sɩ ba bǝŋi Zezi karabiǝ bam nɩ Krisi biǝ. ");
INSERT INTO xsm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Da yam kʋntʋ nɩ Wɛ nijoŋnǝ badonnǝ ma zɩgɩ Zeruzalɛm nɩ ba vu Antɩɔsɩ. ");
INSERT INTO xsm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ba dɩdʋa yɩrɩ mʋ Agabusi. Wɛ Joro kʋm ma pa o ta Wɛ kwǝrǝ, nɩ kana lagɩ ka ba ka tiini ka zʋ lʋgʋ maama. (Kʋ dɛɛn sɩɩnɩ kʋ kɩ kʋntʋ mʋ maŋa kalʋ Kloodi na di paarɩ tɩn.) ");
INSERT INTO xsm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Zezi karabiǝ bam na ni kʋntʋ tɩn, ba ma lɩ wʋbʋŋa sɩ ba la sǝbu ba ma wǝli ba ko-biǝ balʋ na zʋʋrɩ Zude nɩ tɩn. Ba ma sɛ sɩ ba dɩdʋa dɩdʋa wʋ́ pa nɩ ba na wʋ́ wanɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba ma sɩɩnɩ ba kɩ kʋntʋ. Ba ma kwe sǝbu kʋlʋ ba na lagɩ tɩn ba kɩ Banabasɩ dɩ Sooli jɩŋa nɩ, sɩ ba ja vu Zeruzalɛm ba pa Zezi kɔgɔ kʋm nakwa bam. ");
INSERT INTO xsm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Maŋa kam kʋntʋ nɩ Pɛ Erɔdɩ ma zaŋɩ o ja Zezi kɔgɔ kʋm wʋ nɔɔna badonnǝ sɩ o yaarɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O ma ja Zakɩ wʋlʋ na yɩ Zan zɩmbaarʋ tɩn o pa ba gʋ-o dɩ sʋ-zɔɔ. ");
INSERT INTO xsm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","O na kɩ kʋntʋ yɩ o lwarɩ nɩ kʋ poli Zwifǝ bam wʋ lanyɩranɩ tɩn, o daa ma ja Pɩyɛɛrɩ dɩ. Kʋ yɩ Zwifǝ bam candiǝ kalʋ ba na yǝni ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ tɩn maŋa nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","O na jaanɩ Pɩyɛɛrɩ kʋntʋ tɩn, o ma kɩ-o pɩɩna digǝ nɩ, yɩ o pa pamaŋna bana bana kuri bɩna yɩr-o ba lǝni daanɩ. Erɔdɩ dɛɛn maa lagɩ sɩ Pakɩ candiǝ kam na kɛ ka daarɩ, sɩ o laan pa ba ja Pɩyɛɛrɩ ba nuŋi, sɩ o di o taanɩ nɔɔna bam maama yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kʋntʋ ŋwaanɩ Pɩyɛɛrɩ maa wʋ pɩɩna digǝ kam nɩ taan, yɩ Zezi kɔgɔ kʋm nɔɔna bam tiini ba loori Wɛ o ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kʋ dɛɛn yɩ tɩtɩɩ dɩlʋ tɩga na wʋ́ pʋʋrɩ sɩ Erɔdɩ pa Pɩyɛɛrɩ nuŋi pooni sɩ o di o taanɩ tɩn. Pɩyɛɛrɩ ya tigi pamaŋna bale tɩtarɩ nɩ mʋ o dɔa. Ba ya vɔg-o dɩ capʋnnʋ tɩle mʋ. Pamaŋna badonnǝ dɩ ma wʋ pɩɩna digǝ kam ni nɩ ba yɩra. ");
INSERT INTO xsm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Baŋa-Wɛ malɛka laan ma da ka tu ka zɩgɩ da. Pooni maa da zǝŋi digǝ kam wʋnɩ. Malɛka kam ma pɩpagɩ Pɩyɛɛrɩ tɩkǝri nɩ ka pa o zaŋɩ, yɩ ka ta-o ka wɩ: «Kɩ lɩla n zaŋɩ wɛɛnɩ!» Capʋnnʋ tɩm ma kɔ Pɩyɛɛrɩ jɩa nɩ tɩ tʋ tɩga nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malɛka kam ma ta-o ka wɩ: «Fɔgɩ n vɔ n vɔɔrʋ tɩm sɩ n zʋ n natra yam.» O ma sɩɩnɩ o kɩ kʋntʋ. Ka daa ma ta ka wɩ: «Kwe n kasaa kʋm n zʋ, sɩ n ta n tɔgɩ amʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pɩyɛɛrɩ ma tɔgɩ ka kwaga o nuŋi pɩɩna digǝ kam wʋnɩ. O maa wʋ lwarɩ nɩ malɛka kam na kɩ kʋlʋ tɩn yɩ cɩga. O maa bʋŋɩ nɩ kʋ yɩ dɩndwɩa mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ba ma vu ba gaalɩ dayigǝ yɩrɩna bam dɩ kwaga yɩrɩna bam. Ba laan ma vu ba yi luu-bor-zɔŋɔ kʋlʋ na pʋrɩ kʋ yɔɔrɩ tɩʋ kʋm wʋ tɩn. Boro kʋm tɩtɩ ma pʋrɩ, yɩ ba kɛ ba nuŋi. Ba ma kwe cwǝŋǝ ba ve ba maa kɛa. Malɛka kam laan ma da ka viiri ka daarɩ Pɩyɛɛrɩ. ");
INSERT INTO xsm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kʋ laan ma ba Pɩyɛɛrɩ wʋbʋŋa. O ma ta o wɩ: «A laan lwarɩ nɩ kʋ yɩ cɩga mʋ. Wɛ mʋ sɩɩnɩ DƖ tʋŋɩ DƖ malɛka sɩ ka ba ka joŋi-nɩ Erɔdɩ jɩŋa nɩ ka yagɩ, sɩ Zwifǝ bam daa yɩ wanɩ ba kɩ amʋ nɩ ba na bʋŋɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pɩyɛɛrɩ na maanɩ kʋ na yɩ te tɩn, o ma vu Mari-ba sɔŋɔ. Wʋntʋ yɩ Zan Marɩkɩ nu mʋ. Nɔɔna zanzan dɛɛn mʋ kikili daanɩ sɔŋɔ kʋm nɩ ba wʋra ba warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","O ma vu o yi mancoŋo boro kʋm o magɩ, sɩ ba pʋrɩ sɩ o zʋ. Ka-nyaanɩ maa wʋ sɔŋɔ kʋm nɩ, o yɩrɩ mʋ Rɔdɩ. O ma vu sɩ o nii, wɔɔ mʋ maga. ");
INSERT INTO xsm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","O na ve tɩn, o ma lwarɩ Pɩyɛɛrɩ kwǝrǝ. O maa tiini o jɩgɩ wʋpolo zanzan kʋ pa o duri o joori, yɩ o wʋ pʋrɩ boro kʋm. O ma vu o ta dɩ nɔɔna bam o wɩ: «Pɩyɛɛrɩ mʋ zɩgɩ cicwǝŋǝ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba ma lǝr-o ba wɩ, o co mʋ. O maa cɩm yɩ o ta o wɩ: «Kʋ sɩɩnɩ kʋ yɩ cɩga mʋ.» Ba daa ma lǝri ba wɩ: «Kʋ ga yɩ o ciru mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pɩyɛɛrɩ daa ta maa zɩgɩ o magɩ boro kʋm taan. Ba laan ma ba ba pʋrɩ. Ba na nɛ-o tɩn, kʋ ma tiini kʋ sʋ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O ma zǝŋi o jɩa o wɩ, ba cǝgi sɔɔ. O ma daarɩ o maŋɩ dɩ́ Yuutu wʋm na kɩ te o ja-o o nuŋi pɩɩna digǝ kam nɩ tɩn. O ta ma ta dɩ ba o wɩ, ba ve ba ta kʋlʋ na kɩ tɩn ba brɩ Zakɩ dɩ Zezi karabiǝ bam maama. O laan ma yagɩ-ba yɩ o vu jǝgǝ kadoŋ. ");
INSERT INTO xsm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tɩga na pʋʋrɩ tɩtɩɩtɩ tɩn, pamaŋna balʋ ya na yɩrɩ Pɩyɛɛrɩ tɩn wʋbʋŋa vugimi. Ba ma bwe daanɩ ba wɩ: «Bɛɛ mʋ kɩ yɩ Pɩyɛɛrɩ tǝrǝ?» ");
INSERT INTO xsm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erɔdɩ ma pa ni sɩ ba kwaanɩ ba beeri o jǝgǝ. Ba ma beer-o taan ba ga. Erɔdɩ ma bwe pamaŋna bam o nii, ba kɩ ta mʋ yɩ Pɩyɛɛrɩ nuŋi, yɩ o daarɩ o pa ni sɩ ba gʋ-ba. Kʋntʋ na kɩ kʋ kɛ tɩn, Erɔdɩ ma zaŋɩ Zude nɩ o vu Sezaarɩ o zʋʋrɩ da. ");
INSERT INTO xsm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erɔdɩ banɩ dɛɛn tiini dɩ zaŋɩ dɩ Tiiri dɩ Sidɔn tiinǝ. Je sɩm kʋntʋ nɔɔna bam ma zaŋɩ ba la kɔgɔ sɩ ba vu ba tʋ Erɔdɩ sɩ o yagɩ. Erɔdɩ dɛɛn jɩgɩ dɩdɛɛrʋ wʋlʋ na nii o sɔŋɔ kʋm baŋa nɩ, o yɩrɩ mʋ Bɩlasɩtɩ. Nɔɔna bam ma puli ba di ciloŋo dɩdaanɩ wʋntʋ, yɩ ba daarɩ ba vu Erɔdɩ te ba ŋɔɔnɩ dɩd-o sɩ o yagɩ o ban-zɔŋɔ kʋm. Ba dɛɛn lagɩ sɩ ba ni daanɩ, bɛŋwaanɩ ba tɩtɩ tɩʋ kʋm yǝni kʋ joŋi kʋ wʋdiiru pɛ wʋntʋ tɩʋ kʋm nɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ba ma lɩ dɛ sɩ ba jǝni daanɩ ba ŋɔɔnɩ taanɩ dɩm. Dɛ dɩm na yi tɩn, Erɔdɩ ma kwe o paarɩ gwar-fwaarʋ o zʋ. O laan ma jǝni o paarɩ jangɔŋɔ kʋm baŋa nɩ sɩ o ŋɔɔnɩ dɩ nɔɔna bam. ");
INSERT INTO xsm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","O kwǝrǝ na zaŋɩ yɩ o ŋɔɔnɩ dɩ ba kʋntʋ tɩn, nɔɔna bam ma kaasɩ baŋa baŋa ba wɩ: «Kwǝrǝ kantʋ yɩ wɛ kwǝrǝ mʋ sɩ ka daɩ nabinzwǝnǝ nyɩm.» ");
INSERT INTO xsm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Erɔdɩ na sɛ ba zulǝ yam yɩ o wʋ pɛ Wɛ DƖ zulǝ tɩn, Baŋa-Wɛ malɛka ma pa yawɩʋ ja-o lɩla. Kanzwa ma zʋ o wʋ ya di-o ya gʋ. ");
INSERT INTO xsm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Wɛ kwǝrǝ kam dɛɛn maa jagɩ je maama, yɩ nɔɔna zanzan sɛ-ka. ");
INSERT INTO xsm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabasɩ dɩ Sooli ma ti tɩtʋŋɩ dɩlʋ ba na ve Zeruzalɛm sɩ ba tʋŋɩ tɩn. Ba laan ma ja Zan Marɩkɩ ba wǝli ba tɩtɩ nɩ, yɩ ba nuŋi Zeruzalɛm ba joori ba vu Antɩɔsɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Zezi kɔgɔ kʋlʋ na wʋ Antɩɔsɩ nɩ tɩn dɛɛn jɩgɩ Wɛ nijoŋnǝ dɩ balʋ na brɩ Wɛ taanɩ dɩm tɩn ba tɩtarɩ nɩ. Bantʋ mʋ yɩ Banabasɩ, dɩ Simeyon wʋlʋ ba na bǝ nɩ nazono tɩn, dɩ Sirɛɛnɩ tu Lukiyusi, dɩ Manayɛn wʋlʋ dɛɛn na yɩ gʋvɩrma tu Erɔdɩ yuu-doŋo ba biini nɩ tɩn, dɩdaanɩ Sooli. ");
INSERT INTO xsm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dɛ dɩdwɩ ba maa wʋra ba zuli Baŋa-Wɛ, yɩ ba ta kwǝri ba vɔ ni. Wɛ Joro kʋm laan ma ta kʋ brɩ-ba kʋ wɩ: «Lɩ-na Banabasɩ dɩ Sooli amʋ ŋwaanɩ, sɩ ba taa tʋŋɩ tɩtʋŋɩ dɩlʋ amʋ na kuri-ba sɩ ba tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Zezi karabiǝ bam na ni kʋntʋ tɩn, ba daa ma vɔ ni yɩ ba loori Wɛ ba pa-ba. Ba ma daarɩ ba daŋɩ ba jɩa ba baŋa nɩ, yɩ ba laan banɩ-ba yɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wɛ Joro kʋm dɛɛn na tʋŋɩ Banabasɩ dɩ Sooli kʋntʋ tɩn, ba ma vu ba yi Seliusi. Ba ma zʋ naboro ba tɔgɩ nɩnɩʋ kʋm wʋ ba vu ba bɛ ba yi Sipri. ");
INSERT INTO xsm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ba ma vu ba zʋ Sipri tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Salamini. Ba na yi da tɩn, ba maa zʋʋrɩ Zwifǝ bam Wɛ-di sɩm ba tɔɔlɩ Wɛ kwǝrǝ. Zan Marɩkɩ maa wʋ ba tee nɩ o wǝli-ba. ");
INSERT INTO xsm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ba ma zaŋɩ Salamini nɩ ba tʋlɩ je sɩm maama ba kɛ. Ba ma vu ba yi Pafɔsɩ. Ba ma jeeri liri tu wʋdoŋ dáanɩ, o yɩrɩ mʋ Bar-Zezi, yɩ o yɩ Zwifu. O dɛɛn paɩ o yɩ Wɛ nijoŋnu mʋ yɩ o daɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","O maa yɩ gʋvɩrma tu Sɛrɩziu Polusi kwaga nɔɔnʋ mʋ. Gʋvɩrma tu wʋm maa jɩgɩ swan lanyɩranɩ. O ma bǝŋi Banabasɩ dɩ Sooli o pa ba ba o te. O maa lagɩ sɩ o ni Wɛ kwǝrǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Liri tu wʋm ma zaŋɩ o wʋra o culi ba brɩm dɩm. O maa kwaanɩ sɩ o cɩ gʋvɩrma tu wʋm sɩ o yɩ sɛ Wɛ cɩga kam. Liri tu wʋm yɩrɩ dɩdoŋ mʋ yɩ Elimasɩ dɩ Grɛkɩ tiinǝ taanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sooli wʋlʋ yɩrɩ dɩdoŋ ta na yɩ Pooli tɩn dɛɛn jɩgɩ Wɛ Joro kʋm dam lanyɩranɩ. O ma nii liri tu wʋm vɩrr, yɩ o wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«N wʋ su dɩ sɩsɩɩna mʋ dɩdaanɩ balɔrɔ. Nmʋ yɩ sʋtaanɩ jɩŋa nɔɔnʋ mʋ. Nmʋ culi wǝǝnu tɩlʋ maama na lana tɩn. Nmʋ tiini n kwaana sɩ n pipiri dɩ́ Yuutu wʋm cɩga kam sɩ ka ji vwan mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nii, Baŋa-Wɛ wʋ́ ba DƖ magɩ-m dɩ DƖ jɩ-dɩa lele kʋntʋ. Nń ji lilwe yɩ n daa n bá na wɩa pooni, sɩ kʋ taa ve maŋa kalʋ Wɛ na lagɩ tɩn.» O na tagɩ kʋntʋ tɩn, bɩdwɩ baŋa nɩ mʋ Elimasɩ yiǝ dwe, yɩ o zɩgɩ lim wʋnɩ. O maa ve o kɩkara, yɩ o lagɩ vaŋɩnʋ sɩ o ja o jɩŋa. ");
INSERT INTO xsm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gʋvɩrma tu wʋm na nɛ kʋlʋ na kɩ tɩn, o laan ma kɩ o wʋ-dɩdʋa dɩ Zezi Krisi. Dɩ́ Yuutu cɩga kam ba na brɩ-o tɩn ma sʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pooli dɩ o badonnǝ bam laan ma zaŋɩ Pafɔsɩ nɩ ba zʋ naboro ba vu ba yi Pamfili tɩʋ kʋdoŋ, kʋ yɩrɩ mʋ Pɛrɩzɩ. Zan Marɩkɩ ma yagɩ-ba dáanɩ, yɩ o daarɩ o joori Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba daa maa zɩgɩ Pɛrɩzɩ nɩ ba vu Antɩɔsɩ kʋlʋ na wʋ Pisidi nɩ tɩn. Zwifǝ bam siun dɛ dɩm na yi tɩn, ba ma vu ba zʋ ba Wɛ-digǝ kam wʋ ba je da. ");
INSERT INTO xsm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nɔɔna ma zaŋɩ ba karɩmɩ Moyisi cullu twaanʋ tɩm dɩ faŋa faŋa Wɛ nijoŋnǝ bam twaanʋ tɩm wʋnɩ. Ba na karɩmɩ ba ti tɩn, ba yigǝ tiinǝ bam ma tʋŋɩ ni ba pa Pooli-ba, yɩ ba wɩ: «Dɩ́ ko-biǝ-ba, abam na jɩgɩ kwiǝ yalʋ na wʋ́ zǝni nɔɔna bam tɩn, sɩ á zaŋɩ á ta.» ");
INSERT INTO xsm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pooli ma zaŋɩ wɛɛnɩ o zǝŋi o jɩŋa, yɩ o laan daarɩ o ta o wɩ: «Yisɩrayɛlɩ dwi tiinǝ-ba dɩdaanɩ dwi-gɛ tiinǝ balʋ na kwarɩ Wɛ tɩn, cǝgi-na a na lagɩ a ta kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wɛ dɩlʋ dɩbam Yisɩrayɛlɩ tiinǝ bam na tɔgɩ tɩn dɛɛn mʋ kuri dɩ́ nabaara bam, sɩ ba taa yɩ DƖ tɩtɩ nɔɔna. Maŋa kam ba dɛɛn na yɩ vǝrǝ Ezipi nɩ tɩn mʋ Wɛ pɛ ba puli zanzan. DƖ ma daarɩ DƖ ma DƖ tɩtɩ jɩ-dɩa kam DƖ lɩ-ba DƖ pa ba nuŋi tɩʋ kʋm kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ba na beeri kagʋa wʋnɩ taan bɩna fiinna tɩn, DƖ ma kɩ wʋ-zuru dɩdaanɩ ba. ");
INSERT INTO xsm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ba na zʋ Kanaan tɩn, DƖ ma pa tɩʋ kʋm dwi dwi tiinǝ kuni bɩrpɛ cɔgɩ, yɩ DƖ daarɩ DƖ pa DƖ tɩtɩ nɔɔna Yisɩrayɛlɩ tiinǝ bam taa te tɩʋ kʋm kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kʋntʋ kǝm dɩm maama yɩ nɩnɛɛnɩ bɩna biǝ-yana dɩ fiinnu mʋ (450). Kʋntʋ kwaga nɩ, Wɛ laan ma kuri yigǝ tiinǝ DƖ pa-ba yɩ bantʋ te-ba taan, kʋ vu kʋ yi maŋa kam DƖ nijoŋnu Samʋwɛlɩ na tu o ba o te-ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɔɔna bam laan ma loori Samʋwɛlɩ sɩ o tiŋi pɛ o pa-ba. Wɛ ma tiŋi Bɛnzamɛn dwi tu dɩdʋa DƖ pa-ba, o yɩrɩ mʋ Sayuli. O yɩ Kisi bu mʋ. O maa ji ba pɛ bɩna fiinna. ");
INSERT INTO xsm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wɛ dɛɛn ma ba DƖ lɩ Sayuli paarɩ dɩm wʋnɩ, yɩ DƖ daarɩ DƖ pa Davidi ji ba pɛ. Wɛ dɛɛn tagɩ wʋntʋ taanɩ DƖ wɩ: ‹Zese bu Davidi yɩ nɔɔnʋ wʋlʋ na su amʋ wʋ tɩn. Wʋntʋ wʋ́ kɩ kʋlʋ maama a wʋbʋŋa na lagɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kʋ nan yɩ wʋntʋ dwi dɩm wʋnɩ mʋ Wɛ pɛ Zezi ba. Wɛ ma tɔgɩ ni dɩlʋ DƖ na goni tɩn DƖ pa Zezi ji dɩbam Yisɩrayɛlɩ tiinǝ bam Vɩrnʋ. ");
INSERT INTO xsm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Maŋa kam Zezi ta na wʋ puli o tɩtʋŋa yam tɩn, Zan dɛɛn mʋ brɩ Yisɩrayɛlɩ tiinǝ bam maama o wɩ, ba lǝni ba wʋrʋ ba yagɩ kǝm-balwaarʋ, sɩ ba daarɩ ba pa ba miisi-ba na wʋnɩ Wɛ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kʋ na tu kʋ daarɩ fɩnfɩɩn sɩ Zan ti o tɩtʋŋa yam tɩn, o ma bwe nɔɔna bam o wɩ: ‹Abam bʋŋɩ sɩ amʋ yɩ wɔɔ mʋ? Amʋ daɩ wʋlʋ wʋm á na tɩɩnɩ tɩn. Wʋntʋ nan lagɩ o saŋɩ a kwaga mʋ o ba, yɩ a wʋ maŋɩ sɩ a bwǝli o nɛ natra dɩ.› ");
INSERT INTO xsm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","A ko-biǝ-ba, Abraham dwi tiinǝ dɩ dwi-gɛ tiinǝ balʋ na kwarɩ Wɛ tɩn, kʋ yɩ dɩbam mʋ Wɛ pɛ sɩ dɩ́ ni DƖ taanɩ dɩm kʋntʋ, sɩ dɩ́ wanɩ dɩ́ lwarɩ DƖ na lagɩ DƖ vrɩ dɩbam DƖ yagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Zeruzalɛm tiinǝ bam dɩ ba yigǝ tiinǝ bam nan wʋ lwarɩ Zezi na yɩ wʋlʋ tɩn. Kʋ daa zɩ yɩ wǝǝnu tɩlʋ Wɛ nijoŋnǝ bam na pʋpʋnɩ ba tiŋi yɩ nɔɔna yǝni ba karɩmɩ-tɩ ba siun da yam maama nɩ tɩn, ba ba ni wǝǝnu tɩntʋ kuri dɩ. Ba nan na pɛ Zezi na cam tɩn, kʋ pɛ Wɛ nijoŋnǝ bam na pʋpʋnɩ kʋlʋ tɩn sɩɩnɩ kʋ kɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba maa ba jɩgɩ taanɩ dɩlʋ na wʋ́ pa ba gʋ-o tɩn. Dɩ kʋntʋ dɩ, ba ta ma loori Pilatɩ sɩ o pa ba gʋ-o. ");
INSERT INTO xsm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ba ma kɩ kʋlʋ maama na maŋɩ kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ yɩ kʋ ta o taanɩ tɩn ba ti. O na tɩgɩ tɩn, ba laan ma par-o tʋʋn-dagara kam baŋa nɩ ba ja vu ba kɩ yibeeli wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wɛ laan ma pa o bi o yagɩ tʋʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","O maa wʋra da kɔgɔ kɔgɔ. O na wʋra tɩn, kuni zanzan mʋ o brɩ o tɩtɩ o karabiǝ bam yigǝ nɩ, balʋ ya na tɔgɩ dɩd-o Galile nɩ ba beeri ba ve Zeruzalɛm tɩn. Bantʋ laan mʋ yɩ o maana tiinǝ ba brɩ o cɩga kam ba pa dɩbam Yisɩrayɛlɩ tiinǝ bam. ");
INSERT INTO xsm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Dɩbam nan tu abam te mʋ sɩ dɩ́ tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam dɩ́ brɩ abam. Kʋ nan yɩ nɩ, Wɛ dɛɛn na goni ni dɩ dɩbam nabaara bam nɩ DƖ wʋ́ kɩ kʋlʋ tɩn mʋ, ");
INSERT INTO xsm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","DƖ laan sɩɩnɩ DƖ kɩ DƖ pa dɩbam balʋ na yɩ ba naarʋ tɩn. Mʋ kʋntʋ mʋ DƖ bi Zezi DƖ pa o yagɩ tʋʋnɩ. Kʋ yɩ nɩnɛɛnɩ kʋ na maŋɩ kʋ pʋpʋnɩ Wɛ lǝŋ-ŋwɩ tɔnɔ pɔɔrɩm bɩle tu wʋnɩ te tɩn kʋ wɩ: ‹Nmʋ mʋ yɩ amʋ Bu yɩ zɩm amʋ dɩ jigi nmʋ Ko.› ");
INSERT INTO xsm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wɛ tɔnɔ kʋm daa ta brɩ Wɛ na wʋ́ bi-o DƖ pa o yagɩ tʋʋnɩ, sɩ o yɩra yɩ pɔ. Kʋ ma ta kʋ wɩ: ‹Aá pa n na wo-laarʋ cɩga cɩga, nɩ a na maŋɩ a go ni sɩ a pa Davidi na-tɩ te tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Wɛ tɔnɔ kʋm jǝgǝ kadoŋ nɩ Davidi pʋpʋnɩ o wɩ: ‹Nmʋ Wɛ bá sɛ sɩ n tɩtɩ Wʋ-poŋo Tu wʋm yɩra pɔ.› ");
INSERT INTO xsm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kʋ nan na yɩ Davidi tɩtɩ, wʋntʋ dɛɛn tʋŋɩ Wɛ tɩtʋŋa yam maŋa kalʋ o na ŋwɩ tɩn, yɩ o laan ba o tɩ. Ba ma kwe-o ba kɩ o nabaara bam tee nɩ. O yɩra yam ma sɩɩnɩ ya pɔ. ");
INSERT INTO xsm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kʋ daarɩ, wʋlʋ wʋm Wɛ na pɛ o bi o yagɩ tʋʋnɩ tɩn, wʋntʋ yɩra nan wʋ pɔgɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","A ko-biǝ-ba, abam maŋɩ sɩ á lwarɩ nɩ kʋ yɩ Zezi ŋwaanɩ mʋ dɩ́ jɩgɩ cwǝŋǝ sɩ dɩ́ brɩ abam nɩ Wɛ wʋ́ wanɩ DƖ yagɩ á lwarɩm DƖ ma cɛ abam. ");
INSERT INTO xsm_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Wɛ cullu tɩlʋ DƖ na kɩ Moyisi jɩŋa nɩ tɩn warɩ tɩ pa á lwarɩm dɩm ti. Kʋ daarɩ wʋlʋ maama na kɩ o wʋ-dɩdʋa dɩ Zezi tɩn wʋ́ na vrɩm Wɛ tee nɩ, dɩ o lwarɩm dɩm maama na ti wʋntʋ ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nan taá yɩrɩ-na á tɩtɩ, sɩ lɛɛrʋ tɩlʋ Wɛ nijoŋnǝ bam na pʋpʋnɩ tɩ taanɩ tɩn yɩ zaŋɩ tɩ yi abam. ");
INSERT INTO xsm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ba dɛɛn tagɩ ba wɩ: ‹Nii-na, abam balʋ na yǝni á gooni amʋ Wɛ cɩga kam tɩn, abam yɩra wʋ́ sɔɔrɩ yɩ á tɩ. Bɛŋwaanɩ kʋ na yɩ kǝm dɩlʋ a na lagɩ a kɩ abam da yam kʋntʋ nɩ tɩn, abam bá sɛ nɩ dɩ yɩ cɩga, nɔɔnʋ na maŋɩ o brɩ abam tɩ kuri dɩ, á ta bá sɛ.› » ");
INSERT INTO xsm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pooli na tagɩ kʋntʋ o ti tɩn, o dɩ Banabasɩ ma zaŋɩ sɩ ba nuŋi Wɛ-digǝ kam wʋnɩ. Ba na lagɩ ba viiri tɩn, nɔɔna bam ma ta dɩ ba sɩ ba joori ba ba siun dɛ dɩdoŋ dɩm nɩ, sɩ ba daa ta ŋɔɔnɩ taanɩ dɩm kʋntʋ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nɔɔna bam ma zaŋɩ ba jagɩ. Ba zanzan ma tɔgɩ Pooli dɩ Banabasɩ, Zwifǝ bam dɩ dwi-gɛ tiinǝ balʋ na nɩgɩ Wɛ yɩ ba tɔgɩ cullu tɩlʋ DƖ na pɛ dɩbam Zwifǝ bam tɩn dɩ maa tɔga. Pooli dɩ Banabasɩ maa ta dɩ nɔɔna bam sɩ ba ta kwaanɩ ba dalɩ Wɛ DƖ zaanɩ dɩlʋ DƖ na pɛ-ba tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ba siun dɛ dɩm ma joori dɩ yi. Nɔɔna zanzan ma la daanɩ sɩ ba cǝgi Baŋa-Wɛ kwǝrǝ kam, kʋ gɛ fɩɩn sɩ kʋ taa nyɩ dɩ tɩʋ kʋm nɔɔna maama mʋ lagɩ da te. ");
INSERT INTO xsm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zwifǝ bam na nɛ kɔgɔ kʋm na su je sɩm maama tɩn, ba maa tiini ba jɩgɩ wʋ-gʋrʋ dɩ ba. Ba ma yáalɩ Pooli na tɛ kʋlʋ tɩn, yɩ ba kwǝri ba twɩ-o. ");
INSERT INTO xsm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pooli dɩ Banabasɩ laan ma fɔgɩ ba ŋɔɔnɩ dɩ baarɩ, yɩ ba wɩ: «Dɩ́ ya maŋɩ sɩ dɩ́ puli abam tee nɩ mʋ dɩ́ ŋɔɔnɩ Wɛ kwǝrǝ kam. Abam nan na maŋɩ á wʋ sɛ-ka tɩn, abam ba bʋŋɩ nɩ á maŋɩ dɩ Wɛ ŋwɩ-dʋŋa kam. Kʋntʋ ŋwaanɩ dɩ́ wʋ́ vu dwi-gɛ tiinǝ bam te dɩ́ daarɩ abam. ");
INSERT INTO xsm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dɩ́ Yuutu wʋm na pɛ dɩbam ni dɩlʋ tɩn mʋ tɩntʋ: ‹Amʋ Wɛ tiŋi nmʋ sɩ n ja a pooni dɩm n vu n pa dwi-gɛ tiinǝ bam, sɩ n wanɩ n pa nabiinǝ na vrɩm lʋgʋ baŋa je maama nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Dwi-gɛ tiinǝ balʋ na wʋra yɩ ba ni kʋntʋ tɩn, ba maa jɩgɩ wʋpolo, yɩ ba pa Baŋa-Wɛ kwǝrǝ kam jɩgɩ dam. Balʋ maama na maŋɩ sɩ ba na Wɛ ŋwɩ-dʋŋa kam tɩn mʋ sɩɩnɩ ba kɩ ba wʋ-dɩdʋa dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Baŋa-Wɛ kwǝrǝ kam ma jagɩ je sɩm kʋntʋ maama wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kʋ daarɩ Zwifǝ bam ma kwaanɩ ba pa kaana balʋ jɩŋa na jɩgɩ yɩ ba nɩgɩ Wɛ tɩn dɩ tɩʋ kʋm yigǝ tiinǝ bam bana zaŋɩ dɩ Pooli dɩ Banabasɩ. Ba dɛɛn ma pa ba yaarɩ Pooli dɩ Banabasɩ, yɩ ba daarɩ ba zǝli-ba ba pa ba nuŋi ba tɩʋ kʋm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ba na kɩ-ba kʋntʋ tɩn, Pooli dɩ Banabasɩ ma pɩɩsɩ ba nɛ fogo kʋm ba yagɩ da, sɩ kʋ brɩ nɩ ba wʋ kɩ lanyɩranɩ. Ba laan ma daarɩ ba vu Yikon. ");
INSERT INTO xsm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Zezi karabiǝ bam dɛɛn tiini ba jɩgɩ wʋpolo, yɩ Wɛ Joro kʋm wʋ ba tee nɩ lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pooli dɩ Banabasɩ na wʋ Yikon nɩ tɩn, ba daa ta ve Zwifǝ bam Wɛ-digǝ kam. Ba ŋɔɔnɩ Wɛ taanɩ dɩm ba brɩ nɔɔna bam, yɩ ba zanzan kɩ ba wʋ-dɩdʋa dɩ Zezi, Zwifǝ dɩ dwi-gɛ tiinǝ dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kʋ daarɩ Zwifǝ badonnǝ vɩn Wɛ taanɩ dɩm. Bantʋ ma zaŋɩ ba vugimi dwi-gɛ tiinǝ bam wʋbʋŋa ba pa ba wʋrʋ cɔgɩ dɩ Zezi karabiǝ bam. ");
INSERT INTO xsm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pooli dɩ Banabasɩ maa zʋʋrɩ da taan. Ba na wʋra kʋntʋ tɩn, ba maa ŋɔɔnɩ dɩ́ Yuutu Zezi taanɩ dɩ baarɩ yɩ ba kɩ ba wʋ-dɩdʋa dɩd-o. Ba maa tɛ dɩ́ Yuutu wʋm na kɩ nɔɔna lanyɩranɩ te tɩn, yɩ o zɩgɩ ba taanɩ dɩm kwaga nɩ dɩ o na pɛ-ba dam sɩ ba taa kɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ Wɛ dam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tɩʋ kʋm nɔɔna bam dɛɛn pɔɔrɩ bɩle mʋ. Badaara tɔgɩ Zwifǝ bam mʋ, yɩ badonnǝ dɩ tɔgɩ Zezi tɩntʋŋna bam. ");
INSERT INTO xsm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dwi-gɛ tiinǝ dɩ Zwifǝ badonnǝ dɛɛn ma lɩ wʋbʋŋa ba wǝli dɩdaanɩ ba yigǝ tiinǝ bam, sɩ ba yaarɩ Zezi tɩntʋŋna bam, sɩ ba dʋlɩ-ba dɩ kandwa. ");
INSERT INTO xsm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ba na lwarɩ kʋ ni nɩ tɩn, ba ma duri ba vu Likoni tɩɩnɩ dɩm, Lisitri dɩ Dɛrɩbɩ dɩ tɩ-niǝ yam maama. ");
INSERT INTO xsm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ba na wʋra tɩn, ba maa tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam ba brɩ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nɔɔnʋ dɛɛn mʋ wʋ Lisitri nɩ, o yɩ kɔrɔ mʋ. Kʋ na zɩgɩ o lʋra maŋa nɩ o maŋɩ o warɩ o vu. ");
INSERT INTO xsm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","O dɛɛn maa tɔgɩ o je o cǝgi Pooli na ŋɔɔnɩ taanɩ dɩlʋ tɩn. Pooli ma nii-o ziin, yɩ o lwarɩ nɩ o kɩ o wʋ-dɩdʋa dɩ Zezi sɩ o wanɩ o na yazurǝ. ");
INSERT INTO xsm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","O laan ma ta dɩ kwǝr-dɩa o wɩ: «Zaŋɩ wɛɛnɩ n zɩgɩ n nɛ sɩm baŋa nɩ ywam!» O na tagɩ kʋntʋ tɩn, kɔrɔ kʋm ma zaŋɩ wɛɛnɩ kʋ faŋɩ kʋ cwi yɩ kʋ sɩŋɩ vǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nɔn-kɔgɔ kʋm na nɛ kʋlʋ Pooli na kɩ tɩn, ba maa tiini ba ŋɔɔnɩ baŋa baŋa dɩ ba tɩtɩ dwi taanɩ dɩm ba wɩ: «Kʋ yɩ dɩbam wa yam mʋ jigi nabiinǝ ya tu ya ba dɩbam te.» ");
INSERT INTO xsm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ba ma pa Banabasɩ yɩrɩ nɩ Ziusi. Pooli dɩ yɩrɩ maa yɩ Ɛrmɛsɩ, bɛŋwaanɩ kʋ yɩ wʋntʋ ya mʋ ŋɔɔnɩ taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ba dɛɛn maa jɩgɩ digǝ ba tɩʋ kʋm daa nɩ ba na yǝni ba kaanɩ ba wɛ Ziusi da tɩn. Ba kaanɩm tu wʋm ma zaŋɩ o ja nabɛ dɩ tweeru punnu tɩlʋ ba na sɔgɩ tɩn o ba o zɩgɩ tɩʋ kʋm ni nɩ. Wʋntʋ dɩdaanɩ nɔn-kɔgɔ kʋm maama dɛɛn maa lagɩ sɩ ba gʋ nabɛ sɩm ba ma kaanɩ Zezi tɩntʋŋna bam. ");
INSERT INTO xsm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Banabasɩ dɩ Pooli ma lwarɩ ba na bʋŋɩ sɩ ba kɩ te tɩn. Ba wʋ ma cɔgɩ zanzan. Ba ma ja ba gwaarʋ ba kaarɩ, yɩ ba daarɩ ba duri lɩla ba zʋ nɔn-kɔgɔ kʋm wʋ. Ba maa tɛ baŋa baŋa ba wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Nɔɔna-ba, bɛɛ mʋ yɩ abam lagɩ á kɩ kʋntʋ? Dɩbam yɩ nabiinǝ mʋ, nɩ abam dɩ te. Dɩbam nan tu yo seeni sɩ dɩ́ tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam mʋ dɩ́ brɩ abam, sɩ á yagɩ jwǝnǝ kaanɩm, sɩ á daarɩ á taá tɔgɩ Ŋwɩa Tu Baŋa-Wɛ. Dɩntʋ mʋ kɩ wɛyuu dɩ tɩga dɩ na-fara dɩ wǝǝnu tɩlʋ maama na wʋ tɩ wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Faŋa tɩn, Wɛ dɛɛn yagɩ dwi maama sɩ dɩ kɩ dɩ wʋbʋŋa na lagɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Dɩ kʋntʋ dɩ, DƖ ta yǝni DƖ kɩ abam lanyɩranɩ, sɩ kʋ pa á lwarɩ nɩ DƖ yɩ Wɛ cɩga cɩga. DƖ yǝni DƖ pa dʋa nɩa yɩ wʋdiiru kɩ tɩ maŋa nɩ. DƖ paɩ abam wʋdiu yɩ á di, yɩ DƖ paɩ abam wʋpolo lanyɩranɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pooli na tagɩ kʋntʋ tɩn, kʋ ya gɛ fɩnfɩɩn mʋ sɩ nɔɔna bam kwe wǝǝnu tɩm ba ma kaanɩ-ba, yɩ ba laan yagɩ. ");
INSERT INTO xsm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Zwifǝ badonnǝ ya nuŋi Antɩɔsɩ mʋ Pisidi tɩʋ nɩ ba ba. Badaara dɩ ma nuŋi Yikon ba ba. Bantʋ ma pa kɔgɔ kʋm maama wʋrʋ lǝni dɩ Pooli. Ba laan ma dʋl-o dɩ kandwa, yɩ ba daarɩ ba tuur-o ba ja nuŋi tɩʋ kʋm wʋnɩ. Ba ya bʋŋɩ nɩ o tɩgɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Zezi karabiǝ bam laan ma vu ba gilim-o. O ma zaŋɩ ba tɩtarɩ nɩ o joori o zʋ tɩʋ kʋm wʋ. Tɩga na pʋʋrɩ tɩn, o ma tɔgɩ dɩdaanɩ Banabasɩ yɩ ba vu Dɛrɩbɩ. ");
INSERT INTO xsm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pooli dɩ Banabasɩ na wʋ Dɛrɩbɩ nɩ tɩn, ba ma tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam yɩ nɔɔna zanzan ji Zezi karabiǝ. Ba daa ma joori ba vu Lisitri dɩ Yikon, yɩ ba daarɩ ba kɛ ba yi Antɩɔsɩ kʋlʋ na wʋ Pisidi wʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ba na maa ve kʋntʋ tɩn, ba ma pa balʋ maama na yɩ Zezi karabiǝ tɩn na baarɩ, yɩ ba kwe-ba sɩ ba fɔgɩ ba taa tɔgɩ Wɛ cwǝŋǝ kam, sɩ ba yɩ yagɩ-ka. Ba ta ma brɩ-ba ba wɩ: «Dɩbam balʋ maama na tɔgɩ Zezi tɩn, dɩ́ wʋ́ na yaara zanzan mʋ sɩ dɩ́ laan zʋ Wɛ paarɩ dɩm wʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Je sɩlʋ maama ba na ve tɩn, ba lɩ nakwa Zezi kɔgɔ kʋm wʋnɩ sɩ ba taa nii-ba. Ba maa yǝni ba vɔ ni ba loori Wɛ ba pa nakwa bam, yɩ ba kɩ-ba dɩ́ Yuutu jɩŋa nɩ, o na yɩ wʋlʋ ba na kɩ ba wʋ-dɩdʋa dɩd-o tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ba dɛɛn ma da Pisidi ba kɛ. Ba ma vu ba yi Pamfili je sɩm. ");
INSERT INTO xsm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ba na wʋra tɩn, ba ma vu Pɛrɩzɩ ba ŋɔɔnɩ Wɛ taanɩ dɩm da, yɩ ba daarɩ ba vu Atali. ");
INSERT INTO xsm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ba laan ma zɩgɩ dáanɩ ba zʋ naboro ba joori ba vu Antɩɔsɩ kʋlʋ na wʋ Siiri wʋnɩ tɩn. Kʋ dɛɛn yɩ kantʋ jǝgǝ kam nɩ mʋ Zezi kɔgɔ kʋm nɔɔna bam ya kwe-ba ba kɩ Wɛ jɩŋa nɩ, sɩ DƖ zǝni-ba sɩ ba wanɩ ba vu ba tʋŋɩ kʋlʋ ba laan na tu ba tʋŋɩ ba ti tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ba na yi Antɩɔsɩ tɩn, ba ma pa Zezi kɔgɔ kʋm la daanɩ, yɩ ba laan tʋlɩ kʋlʋ maama Wɛ na kɩ dɩ ba tɩn ba brɩ-ba, dɩ DƖ na pʋrɩ cwǝŋǝ DƖ pa dwi-gɛ tiinǝ sɩ ba wanɩ ba kɩ ba wʋ-dɩdʋa dɩ Zezi tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ba ma zʋ Zezi karabiǝ bam tee nɩ ba daanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nɔɔna badonnǝ ma zaŋɩ Zude nɩ ba vu Antɩɔsɩ. Ba maa wʋra ba brɩ Zezi karabiǝ bam ba wɩ: «Abam na wʋ sɛ á tɔgɩ Moyisi cullu tɩm na brɩ te sɩ á go á bǝkǝri, á bá wanɩ á na vrɩm.» ");
INSERT INTO xsm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pooli dɩ Banabasɩ na ni kʋntʋ tɩn, ba ma tiini ba magɩ kantɔgɔ dɩ nɔɔna bam. Kʋntʋ ŋwaanɩ Zezi kɔgɔ kʋm ma lɩ wʋbʋŋa sɩ ba lɩ Pooli dɩ Banabasɩ dɩ nɔɔna badonnǝ ba wʋnɩ, sɩ ba ja taanɩ dɩm ba vu Zeruzalɛm ba kɩ Zezi tɩntʋŋna bam dɩ nakwa bam jɩa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Zezi kɔgɔ kʋm ma banɩ-ba yɩ ba kɛ. Ba ma vu ba da Fenisi dɩ Samari je sɩm. Ba na maa ve tɩn, ba maa tɛ dwi-gɛ tiinǝ na lǝni ba wʋrʋ ba sɛ Wɛ te tɩn ba brɩ nɔɔna bam. Zezi karabiǝ bam na ni kʋntʋ tɩn, kʋ ma pa ba maama jɩgɩ wʋpolo lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ba ma vu ba yi Zeruzalɛm. Zezi tɩntʋŋna bam dɩ o kɔgɔ kʋm maama dɩ ba nakwa bam ma jeeri-ba lanyɩranɩ. Ba laan ma maŋɩ ba brɩ-ba Wɛ na kɩ kʋlʋ dɩ ba tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Zwifǝ badaara balʋ na wʋ Farizɩan kɔgɔ kʋm wʋnɩ yɩ ba ba ba tɔgɩ Zezi tɩn ni taanɩ dɩm. Ba ma zaŋɩ ba ta ba wɩ: «Nɔɔna bantʋ maŋɩ sɩ ba go ba bǝkǝri mʋ, sɩ ba daarɩ ba sɛ Moyisi cullu tɩm maama na brɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Zezi tɩntʋŋna bam dɩ o kɔgɔ kʋm nakwa bam ma la daanɩ sɩ ba bwɛ taanɩ dɩm ba nii. ");
INSERT INTO xsm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba na magɩ kantɔgɔ taan tɩn, Pɩyɛɛrɩ ma zaŋɩ ba wʋnɩ o ta o wɩ: «A ko-biǝ-ba, abam ye sɩ Wɛ dɛɛn kuri amʋ abam wʋnɩ, sɩ a vu dwi-gɛ tiinǝ bam te sɩ a brɩ-ba DƖ kwǝr-ywǝŋǝ kam, sɩ ba daarɩ ba sɛ-ka. ");
INSERT INTO xsm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wɛ na ye nɔɔna wʋbʋŋa na yɩ te tɩn, DƖ ma pa-ba DƖ Joro kʋm, nɩ DƖ na maŋɩ DƖ pa dɩbam te tɩn, sɩ kʋ brɩ nɩ DƖ sɩɩnɩ DƖ vrɩ-ba ba lwarɩm wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","DƖ ma wʋ pɔɔrɩ bantʋ dɩ dɩbam daanɩ. DƖ fɔgɩ DƖ kwɛ ba wʋbʋŋa mʋ dɩ ba na kɩ ba wʋ-dɩdʋa dɩ Zezi tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kʋntʋ tɩn, bɛŋwaanɩ mʋ á bʋŋɩ sɩ á maŋɩ Wɛ á nii dɩ á na lagɩ á pa Zezi karabiǝ bam zɩŋɩ zɩla yalʋ na dummǝ ya dwe-ba tɩn? Kʋ na yɩ dɩbam nabaara bam naa dɩbam tɩtɩ dɩ, dɩ́ warɩ dɩ́ tɔgɩ kǝnǝ yantʋ cwǝŋǝ, yɩ á lagɩ á pa bantʋ tɔgɩ-ka. ");
INSERT INTO xsm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kʋ nan daɩ kʋntʋ. Wɛ na joŋi dɩbam DƖ yagɩ te tɩn, kʋ yɩ dɩ́ Yuutu Zezi zaanɩ dɩm ŋwaanɩ mʋ, dɩ dɩ́ na kɩ dɩ́ wʋ-dɩdʋa dɩd-o tɩn. Kʋ nan yɩ bɩdwɩ mʋ dɩ bantʋ dɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ba kɔgɔ kʋm maa je, yɩ ba cǝgi sɔɔ sɩ ba ni taanɩ dɩm. Pooli dɩ Banabasɩ ma zaŋɩ ba ta Wɛ na dɛ bantʋ jɩŋa DƖ kɩ wo-kɩnkagɩla dɩ wǝǝnu tɩlʋ na brɩ DƖ dam dwi-gɛ tiinǝ bam te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ba na ŋɔɔnɩ ba ti tɩn, Zakɩ ma zaŋɩ o ta o wɩ: «A ko-biǝ-ba, á cǝgi-na a na lagɩ a ta kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔn Pɩyɛɛrɩ maŋɩ o ta o brɩ dɩbam, Wɛ na sɩŋɩ DƖ brɩ DƖ tɩtɩ dwi-gɛ tiinǝ bam tee nɩ yɩ DƖ lɩ nɔɔna ba wʋnɩ sɩ ba taa yɩ DƖ tɩtɩ nɔɔna te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wɛ nijoŋnǝ bam na tagɩ kʋlʋ faŋa faŋa tɩn dɩdaanɩ kǝm dɩntʋ maama yɩ bɩdwɩ mʋ. Kʋ pʋpʋnɩ Wɛ tɔnɔ kʋm wʋnɩ kʋ wɩ: ");
INSERT INTO xsm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Kʋntʋ kwaga nɩ amʋ Wɛ wʋ́ joori a ba, yɩ a daa lɔ Davidi sɔŋɔ kʋlʋ ya na cɔgɩ tɩn. Amʋ wʋ́ fɔgɩ a lɔ di-doŋo kʋm, sɩ kʋ ji sɔ-dʋŋʋ. ");
INSERT INTO xsm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kʋntʋ tɩn, nɔɔna balʋ na daarɩ tɩn wʋ́ kwaanɩ sɩ ba lwarɩ amʋ wʋlʋ na yɩ ba Yuutu Baŋa-Wɛ tɩn. Dwi-gɛ tiinǝ balʋ a na lɩ sɩ ba taa yɩ a tɩtɩ nɔɔna tɩn wʋ́ lwarɩ amʋ. Yuutu Baŋa-Wɛ mʋ tagɩ kʋntʋ, yɩ DƖ pa wǝǝnu tɩm sɩɩnɩ tɩ kɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","DƖ maŋɩ DƖ pa nɔɔna lwarɩ wǝǝnu tɩntʋ ni nɩ faŋa faŋa mʋ.› » ");
INSERT INTO xsm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Zakɩ ta ma ta o wɩ: «Kʋntʋ ŋwaanɩ amʋ bʋŋɩ sɩ, dɩ́ wʋ maŋɩ sɩ dɩ́ yaarɩ dwi-gɛ tiinǝ balʋ na tu ba sɛ Wɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Dɩ́ nan na wʋ́ kɩ kʋlʋ tɩn, dɩ́ wʋ́ pʋpʋnɩ tɔnɔ mʋ dɩ́ pa-ba, sɩ dɩ́ brɩ-ba nɩ ba daa yɩ taa di wʋdiu kʋlʋ nɔɔna na mɛ ba kaanɩ jwǝnǝ yɩ kʋ ba lana tɩn, sɩ ba yɩ cɔgɩ ba tɩtɩ dɩ kaana, sɩ kaana dɩ yɩ cɔgɩ ba tɩtɩ dɩ baara. Dɩ́ wʋ́ ta dɩ ba sɩ ba yɩ di varɩm wʋlʋ ba na jujugi ba gʋ tɩn, sɩ ba yɩ di jana dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bɛŋwaanɩ, kʋ na sɩŋɩ faŋa faŋa tɩn, ba maŋɩ ba karɩmɩ Moyisi tɔnɔ kʋm Zwifǝ Wɛ-di sɩm nɩ ba siun dɛ maama wʋnɩ, yɩ nɔɔna yǝni ba brɩ wǝǝnu tɩlʋ na pʋpʋnɩ da tɩn tɩɩnɩ dɩm maama wʋnɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ba maama na ni kʋntʋ tɩn, Zezi tɩntʋŋna bam dɩ o kɔgɔ kʋm nakwa bam maa lɩ wʋbʋŋa sɩ ba lɩ nɔɔna ba wʋnɩ, sɩ ba tɔgɩ dɩ Pooli dɩ Banabasɩ ba vu Antɩɔsɩ. Ba dɛɛn ma lɩ nɔɔna bale balʋ na yɩ yigǝ tiinǝ ba kɔgɔ kʋm wʋnɩ tɩn. Ba dɩdʋa yɩrɩ mʋ Zudi wʋlʋ yɩrɩ dɩdoŋ na yɩ Basaba tɩn. Wʋdoŋ wʋm yɩrɩ mʋ Silasɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ba ma pʋpʋnɩ tɔnɔ sɩ ba tʋŋɩ-ba dɩ kʋ, yɩ tɔnɔ kʋm wʋnɩ kʋ wɩ: «Dɩbam balʋ na yɩ á ko-biǝ tɩn, Zezi tɩntʋŋna bam dɩ o kɔgɔ kʋm nakwa bam, dɩ́ jɔɔnɩ abam, dwi-gɛ tiinǝ balʋ na tu á tɔgɩ Zezi yɩ á zʋʋrɩ Antɩɔsɩ nɩ, dɩ Siiri dɩ Silisi nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dɩbam ni nɩ dɩ́ kɔgɔ kʋm nɔɔna badonnǝ mʋ zaŋɩ ba ba abam te, ba yaarɩ abam ba pa á wʋbʋŋa cɔgɩ dɩ kʋlʋ ba na brɩ abam tɩn. Dɩbam nan wʋ pɛ-ba cwǝŋǝ sɩ ba kɩ kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kʋntʋ ŋwaanɩ dɩbam maama mʋ kɩ ni daanɩ sɩ dɩ́ lɩ nɔɔna dɩ́ tʋŋɩ-ba abam tee nɩ, sɩ ba tɔgɩ dɩ dɩbam cilon-sonnu Banabasɩ dɩ Pooli ba ba. ");
INSERT INTO xsm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bantʋ mʋ yɩ balʋ na kwe ba ŋwɩa maama ba pa dɩ́ Yuutu Zezi Krisi tɩtʋŋa yam ŋwaanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Dɩbam nan mʋ tʋŋɩ Zudi dɩ Silasɩ abam tee nɩ, sɩ ba ba ba fɔgɩ ba ŋɔɔnɩ ba brɩ abam kʋlʋ dɩ́ na pʋpʋnɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Wɛ Joro kʋm dɩdaanɩ dɩbam maama bʋŋɩ nɩ kʋ wʋ maŋɩ sɩ dɩ́ yaarɩ abam zanzan. Woŋo kʋlʋ yɩranɩ na yɩ fɩfɩʋn sɩ á yɩ kɩ tɩn mʋ tɩntʋ: ");
INSERT INTO xsm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Á yɩ zaŋɩ á di wʋdiu kʋlʋ ba na mɛ ba kaanɩ jwǝnǝ tɩn. Á yɩ di jana. Á yɩ di varɩm wʋlʋ ba na jujugi ba gʋ tɩn. Á yɩ cɔgɩ á tɩtɩ dɩ kaana, sɩ kaana dɩ yɩ cɔgɩ ba tɩtɩ dɩ baara. Á na jɩgɩ á tɩtɩ dɩ wǝǝnu tɩntʋ maama, á wʋ́ taá kɩ lanyɩranɩ. Wɛ wʋ́ pa abam yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ba na pʋpʋnɩ kʋntʋ ba ti tɩn, ba laan ma tʋŋɩ nɔɔna bam sɩ ba vu Antɩɔsɩ. Ba na yi da tɩn, ba ma la ba kɔgɔ kʋm maama daanɩ, yɩ ba daarɩ ba pa-ba tɔnɔ kʋm sɩ ba karɩmɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nɔɔna bam na karɩmɩ tɔnɔ kʋm tɩn, ba maa jɩgɩ wʋpolo lanyɩranɩ dɩ kʋ na fɔgɩ kʋ zǝni ba wʋbʋŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Zudi dɩ Silasɩ na yɩ Wɛ nijoŋnǝ tɩn dɛɛn ma tiini ba ŋɔɔnɩ dɩ nɔɔna bam ba pa ba na pu-dɩa dɩ baarɩ. ");
INSERT INTO xsm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ba maa daanɩ ba tee nɩ, yɩ ba ba ba lagɩ ba viiri. Zezi kɔgɔ kʋm nɔɔna bam ma banɩ-ba, yɩ ba joori ba vu balʋ na tʋŋɩ-ba tɩn te dɩ yazurǝ.  ");
INSERT INTO xsm_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasɩ ma lɩ wʋbʋŋa sɩ o maŋɩ da. ");
INSERT INTO xsm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kʋ daarɩ Pooli dɩ Banabasɩ dɩ ma maŋɩ Antɩɔsɩ nɩ. Ba dɛɛn maa tɔgɩ dɩ nɔɔna zanzan ba tɔɔlɩ dɩ́ Yuutu Wɛ kwǝrǝ kam yɩ ba brɩ DƖ cɩga kam. ");
INSERT INTO xsm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ba na daanɩ da da yagratʋ tɩn, Pooli ma ta dɩ Banabasɩ o wɩ: «Pa dɩ́ joori dɩ́ vu dɩ́ nii dɩ́ ko-biǝ bam tɩɩnɩ dɩlʋ maama wʋnɩ dɩ́ na maŋɩ dɩ́ tɔɔlɩ dɩ́ Yuutu wʋm kwǝrǝ kam da tɩn, sɩ dɩ́ nii kʋ na yɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabasɩ ma sɛ yɩ o lagɩ sɩ Zan Marɩkɩ taa tɔgɩ dɩdaanɩ ba o tʋŋa. ");
INSERT INTO xsm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pooli maa bʋŋɩ nɩ kʋ wʋ maŋɩ sɩ o tɔgɩ o wǝli ba wʋnɩ, bɛŋwaanɩ maŋa kalʋ ba dɛɛn na wʋ Pamfili nɩ tɩn wʋntʋ yagɩ-ba mʋ, yɩ o daa ba tɔgɩ dɩ ba o tʋŋa. ");
INSERT INTO xsm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ba ma tiini ba magɩ kantɔgɔ daanɩ, yɩ kʋ pa ba pwɛ da-tee nɩ. Banabasɩ ma ja Zan Marɩkɩ yɩ ba vu ba zʋ naboro sɩ ba vu Sipri. ");
INSERT INTO xsm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pooli dɩ ma lɩ Silasɩ sɩ ba tɔgɩ daanɩ ba vu. Zezi karabiǝ bam ma kɩ-ba dɩ́ Yuutu wʋm jɩŋa nɩ sɩ o zǝni-ba. Ba laan ma zaŋɩ ba kɛ. ");
INSERT INTO xsm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ba ma tɔgɩ Siiri dɩ Silisi wʋ, yɩ ba pa Zezi kɔgɔ kʋm nɔɔna bam na wʋ je sɩlʋ maama tɩn fɔgɩ ba zɩgɩ dɩ dam lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pooli daa ta ma vu o yi Dɛrɩbɩ dɩ Lisitri. Zezi karabu wʋdoŋ maa wʋra, o yɩrɩ mʋ Timoti. O nu maa yɩ Zwifu yɩ o dɩ kɩ o wʋ-dɩdʋa dɩ Zezi. O ko maa yɩ Grɛkɩ tu. ");
INSERT INTO xsm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Zezi karabiǝ balʋ na zʋʋrɩ Lisitri nɩ dɩ Yikon nɩ tɩn maa tɛ ba wɩ, o yɩ nɔn-ŋʋm lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pooli maa lagɩ sɩ o ja-o, sɩ ba taa tɔgɩ daanɩ ba tʋŋa. Zwifǝ balʋ maama na zʋʋrɩ je sɩm kʋntʋ nɩ tɩn maa ye nɩ Timoti ko yɩ Grɛkɩ tu mʋ. Kʋntʋ ŋwaanɩ Pooli ma pa ba go-o, nɩ Moyisi dɛɛn na brɩ Zwifǝ bam sɩ ba taa goni ba bǝkǝri te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ba laan ma zaŋɩ ba vu ba tʋlɩ tɩɩnɩ dɩm sɩ ba nii Zezi kɔgɔ kʋm nɔɔna bam maama. Ba maa brɩ-ba niǝ yalʋ Zezi tɩntʋŋna bam dɩ o kɔgɔ kʋm nakwa bam na lɩ Zeruzalɛm nɩ tɩn. Ba ma ta dɩ ba sɩ ba taa sɛ niǝ yam kʋntʋ. ");
INSERT INTO xsm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kʋntʋ mʋ pɛ Zezi kɔgɔ kʋm nɔɔna bam na wʋ je sɩlʋ maama tɩn na dam dɩ ba Wɛ cwǝŋǝ kam tɔgɩm, yɩ dɛ maama ba kɔgɔ kʋm fɔgɩ kʋ pulǝ kʋ wǝli da. ");
INSERT INTO xsm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pooli dɩ o tɔgɩ-donnǝ bam maa lagɩ sɩ ba kɛ ba vu Azi tɩɩnɩ dɩm ba tɔɔlɩ Wɛ kwǝrǝ kam. Wɛ Joro kʋm ma cɩ ba yigǝ sɩ ba yɩ ve. Ba daa ma vu ba tɔgɩ Friizi dɩ Galatɩ tɩ-niǝ yam wʋnɩ ba kɛ. ");
INSERT INTO xsm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ba ma vu ba yi Miizi sisǝm dɩm ni. Ba maa kwaanɩ sɩ ba zʋ Bitini wʋ. Zezi Joro kʋm ma wʋ pɛ-ba cwǝŋǝ sɩ ba zʋ da. ");
INSERT INTO xsm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ba na kwaanɩ ba ga kʋntʋ tɩn, ba ma tɔgɩ Miizi wʋ ba kɛ, yɩ ba vu ba yi Trʋasɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ba na yi da tɩn, tɩtɩɩ nɩ Pooli ma dwɛ o na nɔɔnʋ na zɩgɩ o yigǝ nɩ. O yɩ Masɩdʋanɩ tu mʋ. O ma loori Pooli o wɩ: «Popo, zaŋɩ n tɔgɩ nɩnɩʋ kʋm wʋ n bɛ n ba Masɩdʋanɩ, n zǝni dɩbam.» ");
INSERT INTO xsm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pooli na dwɛ kʋntʋ tɩn, dɩbam ma kɩ lɩla dɩ́ ti dɩ́ yigǝ sɩ dɩ́ vu Masɩdʋanɩ, bɛŋwaanɩ dɩ́ maanɩ nɩ kʋ yɩ Wɛ mʋ bǝŋi dɩbam sɩ dɩ́ vu dɩ́ brɩ nɔɔna bam DƖ kwǝr-ywǝŋǝ kam dáanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Dɩ́ laan ma kwe naboro Trʋasɩ nɩ dɩ́ yɔɔrɩ Samotrasɩ. Tɩga na pʋʋrɩ tɩn, dɩ́ daa ma zaŋɩ dɩ́ tɔgɩ nɩnɩʋ kʋm dɩ́ vu Nɩapolisi. ");
INSERT INTO xsm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Dɩ́ laan ma zɩgɩ dáanɩ dɩ́ vu tɩga nɩ dɩ́ vu dɩ́ yi Filipi. Tɩʋ kʋm kʋntʋ yɩ Masɩdʋanɩ tɩ-niǝ yam dayigǝ tɩʋ mʋ. Rom tiinǝ mʋ te-kʋ. Dɩ́ ma kɩ da kɔgɔ kɔgɔ tɩʋ kʋm kʋntʋ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Zwifǝ bam siun dɛ dɩm na yi tɩn, dɩ́ ma nuŋi tɩʋ kʋm wʋ dɩ́ vu bugǝ ni. Dɩ́ ya bʋŋɩ nɩ jǝgǝ wʋ́ ta wʋ dáanɩ Zwifǝ bam na yǝni ba ve ba warɩ Wɛ da. Dɩ́ na nɛ jǝgǝ kam tɩn, dɩ́ ma jǝni tɩga nɩ yɩ dɩ́ ŋɔɔnɩ dɩ kaana balʋ na lagɩ daanɩ jǝgǝ kam nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kaanɩ wʋdoŋ dɛɛn tɔgɩ o wʋra, o yɩrɩ mʋ Lidɩa. O nuŋi Tiyatiiri mʋ, yɩ o nɩgɩ Wɛ lanyɩranɩ. O maa jɩgɩ gwaarʋ tɩlʋ na tiini tɩ jɩgɩ nɩnwaŋa tɩn o yǝgǝ. Dɩ́ Yuutu wʋm ma pʋrɩ o wʋbʋŋa yɩ o sɛ wǝǝnu tɩlʋ Pooli na jɩgɩ o tɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","O dɛɛn ma pa dɩ́ miis-o dɩ o sɔŋɔ tiinǝ maama na wʋnɩ Zezi yɩrɩ ŋwaanɩ. O laan ma zaŋɩ o loori dɩbam o wɩ: «Abam na sɛ nɩ a sɩɩnɩ a kɩ a wʋ-dɩdʋa dɩdaanɩ dɩ́ Yuutu Zezi, sɩ á ba á taá zʋʋrɩ dɩbam sɔŋɔ nɩ.» O ma wʋ sɛ sɩ dɩ́ viiri. ");
INSERT INTO xsm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dɛ dɩdwɩ mʋ dɩ́ zaŋɩ dɩ́ maa ve Wɛ warɩm jǝgǝ kam. Dɩ́ na maa ve tɩn, dɩ́ ma jeeri bɩsankana kalʋ na yɩ nɔɔna gambaa tɩn. Cicirǝ dɛɛn maa tɔg-o ka pa o pwǝrisǝ. O na yǝni o pwǝrisǝ o tɛ wǝǝnu tɩlʋ na lagɩ tɩ ba tɩ kɩ tɩn, mʋ o yuu tiinǝ bam dɛɛn nɛ sǝbu zanzan kʋ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","O ma tɔgɩ Pooli dɩ dɩbam kwaga, yɩ o tɔɔlɩ dɩ kwǝr-dɩa o wɩ: «Nɔɔna bantʋ yɩ Yuutu Baŋa-Wɛ tɩntʋŋna mʋ. Ba tu sɩ ba brɩ abam cwǝŋǝ mʋ sɩ á tɔgɩ da á na vrɩm.» ");
INSERT INTO xsm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","O dɛɛn tɔgɩ dɩbam kwaga o kɩ kʋntʋ mʋ taan da kɔgɔ kɔgɔ. Pooli wʋ laan ma cɔgɩ. O ma pipiri o ta dɩ cicirǝ kam o wɩ: «A lagɩ a ta dɩ nmʋ Zezi Krisi yɩrɩ ŋwaanɩ, nuŋi sɩ n daar-o!» O na tagɩ kʋntʋ tɩn, cicirǝ kam ma nuŋi ka daar-o bɩdwɩ baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bɩsankana kam yuu tiinǝ bam ma maanɩ ba lwarɩ nɩ ba daa bá wanɩ ba na sǝbu o ŋwaanɩ. Ba ma ja Pooli dɩ Silasɩ ba vaŋɩ ba ja ba vu yaga, sɩ ba saŋɩ-ba dɩdɛɛra bam tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ba ma ja-ba ba vu ba pa Rom tiinǝ dɩdɛɛra sɩ ba di ba taanɩ. Ba ma ta ba wɩ: «Nɔɔna bantʋ yɩ Zwifǝ mʋ, yɩ ba jɩgɩ dɩbam tɩʋ kʋm nɔɔna wʋbʋŋa ba vugimǝ. ");
INSERT INTO xsm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ba brɩ wǝǝnu tɩlʋ na cɔgɩ dɩbam cullu tɩm mʋ. Dɩbam nan yɩ Rom tiinǝ mʋ, dɩ́ bá wanɩ dɩ́ sɛ bantʋ na brɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kɔgɔ kʋm maama ma tɔgɩ ba jɩgɩ dɩ Pooli dɩ Silasɩ. Rom tiinǝ dɩdɛɛra bam ma ja-ba ba vaŋɩ ba gwaarʋ tɩm ba kaarɩ, yɩ ba daarɩ ba pa nɔɔna magɩ-ba dɩ balaara. ");
INSERT INTO xsm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ba na tiini ba magɩ-ba kʋntʋ tɩn, ba laan ma kɩ-ba pɩɩna digǝ nɩ. Dɩdɛɛra bam ma ta dɩ wʋlʋ na nii pɩɩna digǝ kam baŋa nɩ tɩn, sɩ o fɔgɩ o pɩ nɔɔna bam lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nɔɔnʋ wʋm na ni kʋntʋ tɩn, o ma pa ba zʋ tɩtarɩ digǝ kam wʋ, yɩ o daarɩ o kwaarɩ-ba dɩ dɛ. ");
INSERT INTO xsm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Maŋa kalʋ tɩga na kwɩɩrɩ tɩn, Pooli dɩ Silasɩ maa wʋra ba warɩ Wɛ yɩ ba leenǝ ba zuli Wɛ. Pɩɩna badonnǝ bam maa je ba cǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tɩga kam laan ma da ka sisiŋi, yɩ pɩɩna digǝ kam sisiŋi dɩ ka kuri maama. Digǝ kam bwǝǝru tɩm maama ma da tɩ pʋrɩ, pɩɩna bam capʋnnʋ tɩm maama ma kɔ tɩ tʋ. ");
INSERT INTO xsm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nɔɔnʋ wʋlʋ na yɩrɩ digǝ kam tɩn ma zaŋɩ yɩ o na pɩɩna digǝ kam niǝ na pʋrɩ. O ma bʋŋɩ nɩ pɩɩna bam maama nuŋi ba duri mʋ. Kʋntʋ ŋwaanɩ o ma lɩ sʋ-zɔɔ sɩ o ma gʋ o tɩtɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pooli laan ma bagɩ dɩ kwǝr-dɩa o wɩ: «Yɩ zaŋɩ n gʋ n tɩtɩ, sɩ dɩbam maama wʋ yo.» ");
INSERT INTO xsm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nɔɔnʋ wʋm ma bǝŋi sɩ ba ja mini ba ba ba pa-o. O ma kɩ lɩla o zʋ digǝ kam wʋ o vu o tʋ Pooli dɩ Silasɩ yigǝ nɩ, yɩ o yɩra saɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","O ma pa ba nuŋi pooni, yɩ o daarɩ o bwe-ba o wɩ: «A yuu tiinǝ-ba, a nan wʋ́ kɩ ta mʋ sɩ a ma na vrɩm?» ");
INSERT INTO xsm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ba ma lǝr-o ba wɩ: «Nmʋ maŋɩ sɩ n kɩ n wʋ-dɩdʋa mʋ dɩdaanɩ dɩ́ Yuutu Zezi, sɩ Wɛ wʋ́ vrɩ nmʋ dɩ n sɔŋɔ tiinǝ maama.» ");
INSERT INTO xsm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ba ma daarɩ ba ta Wɛ kwǝrǝ kam ba brɩ-o dɩ balʋ maama na wʋ o sɔŋɔ kʋm nɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tɩtɩɩ dɩm maŋa kam kʋntʋ nɩ mʋ o jaanɩ-ba o vu o zarɩ ba fufwǝlǝ yam maama. O na kɩ kʋntʋ o ti tɩn, mʋ o dɩ o sɔŋɔ tiinǝ bam maama dɛ ba pa ba miisi-ba na wʋnɩ Zezi yɩrɩ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","O ma daarɩ o pa Pooli dɩ Silasɩ zʋ o sɔŋɔ kʋm wʋ. O ma kɩ wʋdiu o pa ba di. O na tu o sɛ Wɛ dɩ wʋ-dɩdʋa tɩn, o maa jɩgɩ wʋpolo lanyɩranɩ dɩ o sɔŋɔ tiinǝ bam maama. ");
INSERT INTO xsm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tɩga na pʋʋrɩ tɩn, Rom tiinǝ dɩdɛɛra bam ma tʋŋɩ nɔɔna sɩ ba vu pɩɩna digǝ kam yɩrɩnʋ wʋm te, ba ta dɩd-o nɩ o yagɩ nɔɔna bam sɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pɩɩna digǝ kam yɩrɩnʋ wʋm ma ta o brɩ Pooli dɩdɛɛra bam na tagɩ te sɩ o yagɩ-ba tɩn. O maa wɩ: «Ba pɛ abam cwǝŋǝ sɩ á viiri. Nan ve-na dɩ yazurǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pooli laan ma ta dɩ nɔɔna bam o wɩ: «Dɩbam nan yɩ Rom tɩʋ kʋm jɩŋa nɔɔna mʋ. Ba nan wʋ di dɩbam taanɩ sɩ ba na dɩ́ kǝm-balɔrɔ, yɩ ba garɩ ba ja dɩbam ba magɩ nɔɔna maama yigǝ nɩ, yɩ ba daarɩ ba kɩ dɩbam pɩɩna digǝ nɩ. Bɛɛ mʋ yɩ ba laan lagɩ sɩ ba sǝgi ba pʋrɩ dɩbam ba yagɩ? Dɩ́ bá sɛ. Ba tɩtɩ mʋ maŋɩ sɩ ba ba ba pʋrɩ dɩbam ba yagɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nɔɔna bam ma vu ba ta Pooli na tagɩ kʋlʋ tɩn ba brɩ Rom tiinǝ dɩdɛɛra bam. Ba na lwarɩ nɩ Pooli dɩ Silasɩ yɩ Rom tɩʋ kʋm jɩŋa nɔɔna mʋ tɩn, fʋʋnɩ ma zʋ-ba dɩ ba na kɩ-ba te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ba ma vu ba koori Pooli dɩ Silasɩ sɩ ba yagɩ taanɩ dɩm sɩ kʋ ti. Ba ma daarɩ ba pʋrɩ-ba ba yagɩ, yɩ ba loori-ba ba wɩ, ba nuŋi tɩʋ kʋm wʋnɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pooli dɩ Silasɩ ma nuŋi pɩɩna digǝ kam nɩ ba vu ba zʋ Lidɩa-ba sɔŋɔ. Dáanɩ mʋ ba jeeri Zezi karabiǝ bam, yɩ ba ŋɔɔnɩ dɩ ba ba pa-ba dam dɩ baarɩ. Ba laan ma zaŋɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ba dɛɛn ma da Afipolisi dɩ Apoloni ba kɛ ba vu ba yi Tesaloniki. Tɩʋ kʋm kʋntʋ nɩ mʋ Zwifǝ bam Wɛ-digǝ wʋra. ");
INSERT INTO xsm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pooli ma vu da, nɩ o na maŋɩ o yǝni o kɩ te tɩn. O dɛɛn kɩ siun da yatɔ mʋ dɩ ba. O maa karɩmɩ Wɛ tɔnɔ kʋm, yɩ o brɩ-ba kʋ kuri sɩ ba ni. ");
INSERT INTO xsm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","O ma maŋɩ o brɩ-ba o wɩ, kʋ dɛɛn ya maŋɩ sɩ Krisi wʋm Wɛ na tʋŋɩ tɩn yaarɩ mʋ o tɩ, sɩ o joori o bi o yagɩ tʋʋnɩ. O ma ta dɩ ba o wɩ: «Zezi wʋlʋ a na jɩgɩ o taanɩ a tɛa a brɩ abam tɩn mʋ sɩɩnɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Zwifǝ bam na ni kʋntʋ tɩn, ba badonnǝ ma sɛ o na tagɩ kʋlʋ tɩn, yɩ ba laan tɔgɩ ba wǝli Pooli dɩ Silasɩ nɩ. Grɛkɩ tiinǝ balʋ na nɩgɩ Wɛ tɩn kɔgɔ zanzan dɩ ma sɛ Pooli taanɩ dɩm, dɩdaanɩ kaana zanzan balʋ jɩa na garɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Zwifǝ badaara maa jɩgɩ wʋ-gʋrʋ dɩ ba. Ba ma vu yaga ba la zwabani-nyɩna ba pa ba tɔgɩ daanɩ, yɩ ba kɔgɔ kʋm ma pa tɩʋ kʋm maama vugimi dɩ sɔɔ bɔgɩ bɔgɩ. Ba ma vu ba ciŋi jara Zazɔn sɔŋɔ nɩ, yɩ ba kwaanɩ ba lagɩ Pooli dɩ Silasɩ jǝgǝ, sɩ ba ja-ba ba ja nuŋi ba kɩ nɔɔna bam jɩŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba ma wʋ nɛ-ba. Ba ma ja Zazɔn dɩ Zezi karabiǝ badonnǝ ba ja vu tɩʋ kʋm dɩdɛɛra bam te, yɩ ba tɔɔlɩ ba wɩ: «Nɔɔna bantʋ mʋ yǝni ba beeri lʋgʋ baŋa je maama ba vugimi nɔɔna wʋbʋŋa. Bantʋ nan mʋ tu yo. ");
INSERT INTO xsm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zazɔn mʋ pɛ ba zʋʋrɩ o sɔŋɔ nɩ. Bantʋ maama mʋ vɩn dɩ́ pa-farʋ wʋm cullu tɩm, yɩ ba tɛ ba wɩ, pɛ wʋdoŋ mʋ wʋra, o yɩrɩ mʋ Zezi.» ");
INSERT INTO xsm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tɩʋ kʋm dɩdɛɛra bam dɩ kɔgɔ kʋm maama na ni kʋntʋ tɩn, ba bana ma zaŋɩ zanzan dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dɩdɛɛra bam ma pa Zazɔn dɩ o donnǝ bam tiŋi sǝbu kʋlʋ na wʋ́ pa-ba cwǝŋǝ sɩ ba vrɩ ba tɩtɩ tɩn. Ba laan ma yagɩ-ba ba pa ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tɩga na tu ka yi tɩn, Zezi karabiǝ bam ma pa Pooli dɩ Silasɩ nuŋi tɩʋ kʋm nɩ ba vu Beere. Ba na ve ba yi da tɩn, ba ma vu ba zʋ Zwifǝ bam Wɛ-digǝ kam wʋ. ");
INSERT INTO xsm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tɩʋ kʋm kʋntʋ Zwifǝ bam maa jɩgɩ wʋbʋŋ-ŋʋna ba dwe Tesaloniki nɔɔna bam. Ba ma cǝgi Wɛ kwǝrǝ kam lanyɩranɩ dɩ ba wʋ maama. Dɛ maama wʋnɩ ba yǝni ba karɩmɩ Wɛ tɔnɔ kʋm sɩ ba nii, Pooli na brɩ kʋlʋ tɩn sɩɩnɩ kʋ yɩ cɩga na. ");
INSERT INTO xsm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ba zanzan ma sɛ Pooli taanɩ dɩm, Grɛkɩ tiinǝ zanzan dɩ maa sɛ, baara dɩ kaana balʋ jɩa na garɩ tɩn zanzan dɩ maa sɛ. ");
INSERT INTO xsm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tesaloniki Zwifǝ bam ma ni nɩ Pooli wʋ Beere nɩ o tɔɔlɩ Wɛ kwǝrǝ kam. Ba ma zaŋɩ ba vu Beere ba la kɔgɔ ba pa tɩʋ kʋm nɔɔna bam bana zaŋɩ dɩ Pooli. ");
INSERT INTO xsm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Zezi karabiǝ bam na nɛ kʋntʋ tɩn, ba ma pa Pooli zaŋɩ lɩla o nuŋi o vu nɩnɩʋ kʋm ni. Kʋ ma daarɩ Silasɩ dɩ Timoti mʋ maŋɩ Beere nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nɔɔna balʋ na kogili Pooli tɩn ma da dɩd-o ba vu ba yi Atɛɛnɩ. Ba na maa joori tɩn, Pooli ma pa-ba ni sɩ ba vu ba ta Silasɩ dɩ Timoti nɩ ba zaŋɩ ba tɔgɩ o kwaga ba ba lɩla. ");
INSERT INTO xsm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pooli dɛɛn na wʋ Atɛɛnɩ nɩ o cǝgi Silasɩ dɩ Timoti sɩ ba ba tɩn, o wʋ ma tiini kʋ cɔgɩ dɩ o na nɛ nɩ jwǝnǝ zanzan su tɩʋ kʋm tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","O maa yǝni o zʋ Zwifǝ bam Wɛ-digǝ kam wʋ o ŋɔɔnɩ dɩ ba dɩdaanɩ dwi-gɛ tiinǝ balʋ na nɩgɩ Wɛ tɩn. Dɛ maama o maa yǝni o ve yaga ni o ŋɔɔnɩ dɩ balʋ na wʋra tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yi-pʋrʋ tiinǝ badonnǝ dɩ ma ba ba maŋɩ dɩd-o. Ba badaara dɛɛn tɔgɩ Epikuri zaasɩm dɩm mʋ, babam dɩ maa tɔgɩ Sitoyisi zaasɩm dɩm. Ba badaara ma ta ba wɩ: «Ŋwaŋ-fara tu wʋntʋ bʋŋɩ sɩ o brɩ bɛɛ mʋ?» Badonnǝ dɩ ma ta ba wɩ: «Kʋ nyɩ dɩ o ŋɔɔnɩ dwi-gɛ tiinǝ jwǝnǝ taanɩ mʋ te.» Ba tagɩ kʋntʋ, bɛŋwaanɩ o tɔɔlɩ Zezi kwǝr-ywǝŋǝ kam dɩ twa biim taanɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ba laan ma ja-o ba vu Arɩpaazɩ, (mɛ ba yigǝ tiinǝ bam na jeeri da tɩn). Ba ma ta-o ba wɩ: «Dɩbam ya lagɩ sɩ dɩ́ lwarɩ zaasɩm-dʋʋrɩ dɩm nmʋ na jɩgɩ n zaasɩ tɩn kuri mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wǝǝnu tɩlʋ nmʋ na brɩ tɩn, dɩ́ ta wʋ fɔgɩ dɩ́ ni tɩ dwi. Kʋntʋ mʋ dɩ́ lagɩ sɩ dɩ́ lwarɩ tɩ kuri na yɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atɛɛnɩ tiinǝ bam maama dɩdaanɩ vǝrǝ balʋ na zʋʋrɩ ba tee nɩ tɩn dɛɛn tiini ba lagɩ sɩ ba taa larɩ daanɩ mʋ maŋa maama, sɩ ba taa cǝgi wǝǝnu tɩlʋ na yɩ wo-dʋnnʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pooli ma zaŋɩ o zɩgɩ Arɩpaazɩ yigǝ tiinǝ bam tɩtarɩ nɩ o wɩ: «Atɛɛnɩ tiinǝ-ba, amʋ na nii tɩn, abam ŋwɩa kam maama wʋnɩ á tiini á zuli jwǝnǝ mʋ zanzan. ");
INSERT INTO xsm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A na beeri abam tɩʋ kʋm wʋnɩ tɩn, a nɛ je sɩm maama á na zuli á jwǝnǝ da tɩn. A na beeri tɩn mʋ a nɛ kaanɩm bimbim dɩdʋa, yɩ kʋ pʋpʋnɩ dɩ yɩra nɩ kʋ wɩ: ‹Wɛ dɩlʋ dɩ́ na yǝri tɩn›. Kʋntʋ, Wɛ dɩlʋ abam na jɩgɩ á zuli yɩ á ta yǝri-DƖ tɩn kwǝrǝ mʋ a lagɩ a tɔɔlɩ a brɩ abam. ");
INSERT INTO xsm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dɩntʋ mʋ yɩ Wɛ dɩlʋ na kɩ lʋgʋ baŋa dɩ wǝǝnu tɩlʋ maama na wʋ kʋ wʋnɩ tɩn. DƖ maa te wɛyuu dɩ tɩga baŋa maama, yɩ DƖ ba zʋʋrɩ di sɩlʋ nabiinǝ na lɔgɩ ba pa-DƖ tɩn wʋnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wɛ nan wʋ gɛ kʋlʋkʋlʋ sɩ nabiinǝ taa tʋŋa ba pa-DƖ, kʋ na yɩ dɩntʋ tɩtɩ mʋ kwe ŋwɩa dɩ siun dɩ woŋo maama DƖ pa nabiinǝ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wɛ nan kɩ nabiinu dɩdʋa mʋ, yɩ DƖ laan pa nabiinǝ dwi maama zɩgɩ wʋntʋ yɩra nɩ. DƖ ma pa ba jagɩ ba zʋʋrɩ lʋgʋ baŋa maama wʋnɩ. Kʋntʋ tɩn, dɩntʋ mʋ maŋɩ DƖ lɩ wʋbʋŋa yɩ DƖ lɩ mɩmaŋa kalʋ dɩ je sɩlʋ dwi maama na wʋ́ ta zʋʋrɩ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wɛ na kɩ nabiinǝ kʋntʋ tɩn, kʋ yɩ sɩ ba taa lagɩ-DƖ mʋ. Ba maŋɩ sɩ ba beeri-DƖ mʋ ba na DƖ jǝgǝ, sɩ ba ma wanɩ ba lwarɩ-DƖ. Wɛ nan maŋɩ DƖ daɩ yigǝ yigǝ dɩdaanɩ dɩbam maama. ");
INSERT INTO xsm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kʋ nyɩ nɩ nɔɔnʋ wʋdoŋ na tagɩ o wɩ: ‹Dɩntʋ ŋwaanɩ mʋ dɩ́ ŋwɩ, dɩ́ wʋra yɩ dɩ́ veǝ.› Abam tɩtɩ lǝŋ-leenu dɩdʋa dɩ tagɩ kʋntʋ doŋ o wɩ: ‹Dɩbam dɩ maŋɩ dɩ́ yɩ DƖ dwi tiinǝ mʋ.› ");
INSERT INTO xsm_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Dɩbam na sɩɩnɩ dɩ́ yɩ Wɛ dwi tiinǝ tɩn, dɩ́ wʋ maŋɩ sɩ dɩ́ bʋŋɩ nɩ Wɛ wʋ́ ta nyɩ dɩ kamɔgɔ kʋlʋ nabiinu na mɛ sǝbu-sɩŋa naa luguru naa kandwa o ma o kɩ dɩ o tɩtɩ wʋbʋŋa tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Faŋa faŋa yɩ nabiinǝ ta yǝri kʋlʋ na lana sɩ ba taa kɩ tɩn, Wɛ wʋ kwe-kʋ DƖ kɩ DƖ wʋbʋŋa nɩ. Kʋ daarɩ lele kʋntʋ, DƖ laan pɛ ni nɩ nɔɔna maama lʋgʋ baŋa nɩ maŋɩ sɩ ba lǝni ba wʋrʋ ba yagɩ wo-balwaarʋ kǝm. ");
INSERT INTO xsm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bɛŋwaanɩ DƖ lɩ dɛ mʋ sɩ DƖ ma DƖ di nabiinǝ maama taanɩ. DƖ nan wʋ́ tɔgɩ cɩga mʋ DƖ ma di ba taanɩ dɩm. DƖ nan maŋɩ DƖ kuri wʋlʋ DƖ na wʋ́ tɔgɩ o ŋwaanɩ DƖ ma di ba taanɩ tɩn. DƖ pɛ nɔɔnʋ wʋm kʋntʋ mʋ bi o yagɩ tʋʋnɩ, sɩ kʋ pa nɔɔna maama lwarɩ nɩ kʋ sɩɩnɩ kʋ yɩ cɩga mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pooli na ŋɔɔnɩ twa biim taanɩ kʋntʋ tɩn, nɔɔna bam badonnǝ maa jɩg-o ba mwana. Kʋ daarɩ badaara maa tɛ ba wɩ: «Dɩ́ lagɩ sɩ n joori n ŋɔɔnɩ taanɩ dɩm kʋntʋ doŋ mʋ sɩ dɩ́ cǝgi dɛ dɩdoŋ nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pooli laan ma zaŋɩ o nuŋi ba tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nɔɔna badonnǝ dɛɛn ma sɛ ba tɔgɩ Pooli, yɩ ba kɩ ba wʋ-dɩdʋa dɩ Zezi. Ba dɩdʋa yɩrɩ mʋ Denisi. O tɔgɩ o wʋ Arɩpaazɩ kɔgɔ kʋm wʋnɩ mʋ. Kaanɩ wʋdoŋ dɩ wʋra, o yɩrɩ mʋ Damarisi. Nɔɔna badonnǝ dɩ tɔgɩ ba wǝli da ba na sɛ Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kʋntʋ kwaga nɩ, Pooli dɛɛn ma zɩgɩ Atɛɛnɩ nɩ o vu Korɛntɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","O na yi da tɩn, o ma maŋɩ dɩdaanɩ Zwifu wʋdoŋ, o yɩrɩ mʋ Akwila. Ba dɛɛn lʋg-o Pɔn nɩ mʋ. Maŋa kalʋ Pooli na nɛ-o tɩn, o ya nuŋi Yitali mʋ o ba, dɩ o kaanɩ Prisili, bɛŋwaanɩ Rom pa-farʋ Kloodi dɛɛn ya zǝli Zwifǝ bam maama o pa ba nuŋi Rom nɩ ba viiri. Pooli ma zaŋɩ o vu ba te, ");
INSERT INTO xsm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","yɩ o zʋʋrɩ dɩ ba sɩ ba taa tʋŋɩ daanɩ, ba dɛɛn na tʋŋɩ tɩtʋŋɩ dɩdwɩ tɩn ŋwaanɩ. Ba dɛɛn nyaanɩ gwaarʋ mʋ yɩ ba yǝgi ba ma pu vwǝ. ");
INSERT INTO xsm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Zwifǝ bam siun dɛ maama o maa yǝni o zʋ ba Wɛ-digǝ kam o ŋɔɔnɩ Wɛ taanɩ dɩ ba. O maa kwaanɩ sɩ o pa Zwifǝ bam dɩ Grɛkɩ tiinǝ bam maama sɛ o taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silasɩ dɩ Timoti dɛɛn zɩgɩ Masɩdʋanɩ nɩ ba ba Pooli te. Ba na tu tɩn, Pooli laan ma cɛ dɩ Wɛ taanɩ dɩm zaasɩm. O maa kwaanɩ o pa Zwifǝ bam lwarɩ nɩ Zezi yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ba ma wʋ sɛ o taanɩ dɩm yɩ ba twɩ-o. O laan ma ja o gwaarʋ tɩm o pupugi tɩ fogo kʋm ba yigǝ nɩ, yɩ o ta dɩ ba o wɩ: «Abam na nɛ lɛɛrʋ Wɛ tee nɩ, kʋ yɩ abam tɩtɩ yigǝ mʋ. Kʋ daa daɩ amʋ yigǝ. Kʋ na sɩŋɩ lele kʋntʋ tɩn, a laan wʋ́ vu dwi-gɛ tiinǝ bam te a daarɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","O ma sɩɩnɩ o nuŋi Zwifǝ bam tee nɩ o daarɩ o vu o zʋʋrɩ dwi-gɛ tu wʋdoŋ sɔŋɔ nɩ, o yɩrɩ mʋ Titiu Zusitu. Wʋntʋ maa nɩgɩ Wɛ. O sɔŋɔ kʋm maa zɩgɩ Zwifǝ bam Wɛ-digǝ kam tɩkǝri nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Wɛ-digǝ kam yuutu wʋm yɩrɩ mʋ Krisipu. Wʋntʋ dɩ o sɔŋɔ tiinǝ bam maama dɛɛn tu ba tɔgɩ dɩ́ Yuutu Zezi. Korɛntɩ tiinǝ zanzan dɩ dɛɛn ma ni Wɛ kwǝr-ywǝŋǝ kam yɩ ba sɛ. Ba laan ma pa ba miisi-ba na wʋnɩ Zezi yɩrɩ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Dɛ dɩdwɩ tɩtɩɩ nɩ mʋ Pooli dwɛ o na vɩɩrɩm wʋnɩ dɩ́ Yuutu wʋm na ŋɔɔnɩ dɩd-o o wɩ: «Yɩ ta n kwarɩ fʋʋnɩ. Ta ta n ŋɔɔna, sɩ n yɩ ta n cɩm, ");
INSERT INTO xsm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","sɩ amʋ wʋ nmʋ tee nɩ. Nɔɔn-nɔɔnʋ bá wanɩ o kɩ nmʋ lwarɩm, bɛŋwaanɩ tɩʋ kʋntʋ wʋnɩ nɔɔna zanzan mʋ wʋra ba na yɩ amʋ tɩtɩ nɔɔna.» ");
INSERT INTO xsm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pooli dɛɛn maa zʋʋrɩ da taan bɩnɩ dɩ canɩ sɩrdʋ. O na wʋra tɩn, o ma brɩ-ba Wɛ taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nɔɔnʋ wʋdoŋ dɛɛn tu o ji Akayi tɩɩnɩ dɩm gʋvɩrma tu, o yɩrɩ mʋ Galɩʋ. O na wʋra maŋa kalʋ tɩn, Zwifǝ bam ma kɩ ni-dɩdwɩ yɩ ba ja Pooli ba vu saŋɩ o tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ba ma ta dɩ Galɩʋ ba wɩ: «Nɔɔnʋ wʋntʋ mʋ jɩgɩ nɔɔna o sʋga, o pa ba tɔgɩ Wɛ kʋ na wʋ maŋɩ dɩ cullu na brɩ te tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pooli ya maa bʋŋɩ sɩ o ŋɔɔnɩ, yɩ Galɩʋ wuuri o ta dɩ Zwifǝ bam o wɩ: «Kʋ ya na yɩ ŋwɩɩnʋ taanɩ naa kǝm-balɔrɔ kʋdoŋ taanɩ mʋ á jɩgɩ sɩ á ŋɔɔnɩ, kʋ yaá maŋɩ sɩ a zuri a yɩra a cǝgi abam. ");
INSERT INTO xsm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kʋ nan na yɩ abam na magɩ kantɔgɔ abam tɩtɩ cullu tɩm baŋa nɩ yɩ kʋ yɩ bɩtarbiǝ dɩ nɔɔna yɩra ŋwaanɩ mʋ tɩn, abam tɩtɩ mʋ maŋɩ sɩ á nii kʋ baŋa nɩ. A bá sɛ sɩ a di abam taana yantʋ donnǝ.» ");
INSERT INTO xsm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","O na tagɩ kʋntʋ tɩn, o ma zǝli-ba sɩ ba nuŋi taanɩ dɩm dim jǝgǝ kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nɔɔna bam maama laan ma zaŋɩ ba ja Sositɛnɩ wʋlʋ na yɩ ba Wɛ-digǝ kam yuutu tɩn, ba mag-o taanɩ dɩm dim jǝgǝ kam nɩ. Galɩʋ yigǝ nan maŋɩ ka tǝrǝ dɩ ba kǝm dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pooli dɛɛn ma kɩ da kɔgɔ kɔgɔ Korɛntɩ nɩ Zezi karabiǝ bam tee nɩ. O laan ma zaŋɩ o banɩ-ba sɩ o viiri. O ma pa Prisili dɩ Akwila tɔgɩ dɩd-o ba zʋ naboro sɩ ba vu Siiri. Ba ta na wʋ zʋ naboro kʋm sɩ ba kɛ tɩn, Pooli ya zɩgɩ Sankrɩ nɩ o pa ba fanɩ o yuu, sɩ kʋ brɩ nɩ o goni o ni dɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ba ma tɔgɩ nɩnɩʋ kʋm wʋ ba vu ba yi Efɛɛzɩ. Pooli ma yagɩ Prisili dɩ Akwila dáanɩ. O ma vu o zʋ Zwifǝ bam Wɛ-digǝ kam o ŋɔɔnɩ dɩ ba. ");
INSERT INTO xsm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ba ma loor-o sɩ o maŋɩ ba tee nɩ maŋa fɩnfɩɩn. O ma wʋ sɛ. ");
INSERT INTO xsm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","O ma banɩ-ba, yɩ o ta o wɩ: «Wɛ na sɛ, aá joori a ba a na abam.» O daa ma zʋ naboro Efɛɛzɩ nɩ o kɛ. ");
INSERT INTO xsm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","O dɛɛn ma vu o yi Sezaarɩ. O ma zɩgɩ dáanɩ o vu tɩga nɩ o vu o yi Zeruzalɛm. O ma jɔɔnɩ Zezi kɔgɔ kʋm, yɩ o daarɩ o kɛ o vu Antɩɔsɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","O ma daanɩ da da fɩnfɩɩn, yɩ o laan zaŋɩ o kɛ. O ma vu o tʋlɩ Galatɩ dɩ Friizi tɩɩnɩ dɩm wʋ, yɩ o pa Zezi karabiǝ bam maama fɔgɩ ba zɩgɩ kǝŋkǝŋ. ");
INSERT INTO xsm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Zwifu wʋdoŋ dɛɛn mʋ wʋra, o yɩrɩ mʋ Apolɔsɩ. Ba lʋg-o Alɛsandrɩ nɩ mʋ. Wʋntʋ ma ba Efɛɛzɩ. O dɛɛn yɩ wʋlʋ na waɩ taanɩ o ŋɔɔnɩ pʋrɩ pʋrɩ tɩn mʋ. O maa kwǝri o ye Wɛ tɔnɔ kʋm wǝǝnu tɩm kuri maama lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nɔɔna dɛɛn maŋɩ ba brɩ-o dɩ́ Yuutu wʋm cɩga kam na yɩ te tɩn. O maa wʋra o brɩ nɔɔna dɩ o wʋ maama, sɩ o pa ba lwarɩ wǝǝnu tɩlʋ maama na brɩ Zezi cɩga kam tɩn. Kʋ nan na yɩ nɔɔna na pa ba miisi-ba na wʋnɩ Wɛ ŋwaanɩ te tɩn, o ye Zan na miisi nɔɔna na wʋnɩ te tɩn yɩranɩ mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","O ma puli sɩ o ta ŋɔɔnɩ Wɛ cɩga kam dɩ baarɩ Zwifǝ bam Wɛ-digǝ kam nɩ. Prisili dɩ Akwila ma ba ba lwarɩ o zaasɩm dɩm na yɩ te tɩn. Ba ma pa o tɔgɩ o zʋʋrɩ dɩ ba, yɩ ba fɔgɩ ba maŋɩ Wɛ cwǝŋǝ kam cɩga na yɩ te tɩn ba brɩ-o. ");
INSERT INTO xsm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolɔsɩ laan ma bʋŋɩ sɩ o nuŋi Efɛɛzɩ nɩ o kɛ o vu Akayi. Zezi karabiǝ bam ma pu o wʋbʋŋa yam kwaga nɩ. Ba ma pʋpʋnɩ tɔnɔ sɩ ba pa Zezi karabiǝ balʋ na wʋ Akayi nɩ tɩn, ba ta dɩ ba sɩ ba fɔgɩ ba jeer-o lanyɩranɩ. O ma sɩɩnɩ o zaŋɩ o kɛ. O na yi Akayi tɩn, o ma tiini o wǝli balʋ na sɛ Wɛ zaanɩ dɩm tɩn sɩ ba kɩ ba wʋ-dɩdʋa dɩ Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","O ma kwaanɩ o ŋɔɔnɩ dɩ Zwifǝ bam nɔɔna maama yigǝ nɩ, yɩ o magɩ kantɔgɔ o wanɩ-ba, dɩ o na mɛ Wɛ tɔnɔ kʋm o brɩ-ba nɩ Zezi sɩɩnɩ o yɩ Krisi wʋm Wɛ na tʋŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolɔsɩ dɛɛn ta na wʋ Korɛntɩ nɩ tɩn, Pooli ma zaŋɩ o beeri o tɔgɩ tɩɩnɩ dɩm tɩtarɩ o vu o yi Efɛɛzɩ. O na yi da tɩn, o ma na Wɛ cwǝŋǝ karabiǝ badonnǝ, ");
INSERT INTO xsm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yɩ o bwe-ba o wɩ: «Abam na tu á sɛ Wɛ tɩn, á joŋi Wɛ Joro kʋm na?» Ba ma lǝr-o ba wɩ: «Aye, dɩbam maŋɩ dɩ́ brɩ dɩ́ wʋ lwarɩ nɩ Wɛ Joro wʋra.» ");
INSERT INTO xsm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","O daa ma bwe-ba o wɩ: «Ba nan na miisi abam na wʋnɩ tɩn, ba miisi abam tɩta mʋ?» Ba maa wɩ: «Kʋ yɩ Zan na miisi nɔɔna na wʋnɩ te tɩn mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pooli laan ma ta o wɩ: «Kʋ na yɩ Zan na miisi nɔɔna na wʋnɩ te tɩn, wʋntʋ dɛɛn brɩ nɔɔna sɩ ba lǝni ba wʋrʋ ba yagɩ ba kǝm-balwaarʋ tɩm, sɩ ba daarɩ ba pa ba miisi-ba na wʋnɩ. O ma ta dɩ nɔɔna bam sɩ ba kɩ ba wʋ-dɩdʋa dɩ wʋlʋ wʋm na wʋ́ saŋɩ o kwaga o ba tɩn. Zezi mʋ wʋntʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nɔɔna bam na ni kʋntʋ tɩn, ba ma pa ba miisi-ba na wʋnɩ dɩ́ Yuutu Zezi yɩrɩ ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pooli ma daŋɩ daŋɩ o jɩa ba baŋa nɩ. Wɛ Joro kʋm laan ma ba ba te. Ba ma ŋɔɔnɩ dwi-gɛ taana tǝri tǝri, yɩ ba daarɩ ba tɔɔlɩ Wɛ kwǝrǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ba maama dɛɛn yi nɩnɛɛnɩ baara fugǝ-bale mʋ te. ");
INSERT INTO xsm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pooli dɛɛn ma kɩ canɩ sɩtɔ Efɛɛzɩ nɩ. O maa yǝni o ve o zʋʋrɩ Zwifǝ bam Wɛ-digǝ kam o ŋɔɔnɩ dɩ baarɩ o brɩ-ba. O ma kwaanɩ o magɩ kantɔgɔ dɩ ba, sɩ o pa ba lwarɩ Wɛ paarɩ dɩm na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nɔɔna bam badonnǝ ma kwarɩmɩ ba zwa, yɩ ba vɩn sɩ ba sɛ o taanɩ dɩm. Ba maa jɩgɩ dɩ́ Yuutu wʋm cwǝŋǝ kam tɔgɩm ba goonǝ nɔɔna bam maama yigǝ nɩ. Pooli ma zaŋɩ o nuŋi ba wʋnɩ, yɩ o pwɛ balʋ na sɛ ba tɔgɩ Zezi tɩn sɩ ba ta wʋ o tee nɩ. Dɛ maama o maa yǝni o ŋɔɔnɩ o brɩ nɔɔna bam Tiranusi karadigǝ kam nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pooli ma kɩ kʋntʋ doŋ taan bɩna yale. Kʋ ma pa nɔɔna balʋ maama na zʋʋrɩ Azi tɩɩnɩ dɩm nɩ tɩn ba ba ni dɩ́ Yuutu wʋm taanɩ dɩm, kʋ na yɩ Zwifǝ dɩ dwi-gɛ tiinǝ maama dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Wɛ dɛɛn ma tɔgɩ Pooli jɩŋa DƖ kɩ wo-kɩnkagɩla yalʋ doŋ na maŋɩ ya wʋ kɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kʋ dɛɛn na kɩ te tɩn, nɔɔna yǝni ba kwe garyiǝ dɩ gwaarʋ tɩlʋ na dwe Pooli yɩra tɩn ba ja vu ba ma dwe yawɩɩna, yɩ kʋ pa ba na yazurǝ, yɩ ciciri dɩ nuŋi sɩ yagɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Zwifǝ liri tiinǝ badonnǝ dɩ maa wʋra ba na yǝni ba beeri ba zǝli ciciri nɔɔna tee nɩ. Bantʋ dɩ dɛɛn ma kwaanɩ sɩ ba zǝli ciciri sɩm dɩ́ Yuutu Zezi yɩrɩ ŋwaanɩ. Ba maa yǝni ba tɛ dɩ ciciri sɩm ba wɩ: «Zezi wʋlʋ Pooli na brɩ o taanɩ tɩn yɩrɩ ŋwaanɩ mʋ a tɛ abam sɩ á nuŋi á viiri.» ");
INSERT INTO xsm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Baara barpɛ dɩ dɛɛn mʋ wʋra, ba ko yɩrɩ mʋ Seeva yɩ o yɩ Zwifǝ kaanɩm yigǝ tu. Ba maa maɩ Zezi yɩrɩ dɩm ba zǝli ciciri nɔɔna tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Cicirǝ kadoŋ laan ma ta dɩ ba ka wɩ: «A maŋɩ a ye Zezi. A ye Pooli dɩ na yɩ wʋlʋ tɩn. Sɩ abam nan yɩ bra mʋ?» ");
INSERT INTO xsm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nɔɔnʋ wʋm cicirǝ kam na tɔg-o tɩn laan ma zaŋɩ o puuri-ba. O ma wanɩ-ba o pa ba maama duri ba nuŋi o sɔŋɔ kʋm nɩ, yɩ ba gwaarʋ kaarɩ kaarɩ yɩ ba yɩra dɩ fwǝli fwǝli. ");
INSERT INTO xsm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nɔɔna balʋ maama na zʋʋrɩ Efɛɛzɩ nɩ tɩn ma lwarɩ kʋlʋ na kɩ tɩn, Zwifǝ bam dɩ dwi-gɛ tiinǝ maama. Fʋʋnɩ ma zʋ-ba zanzan. Kʋ ma pa dɩ́ Yuutu Zezi yɩrɩ tiini dɩ zaŋɩ dɩ zulǝ. ");
INSERT INTO xsm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nɔɔna balʋ na tu ba sɛ Zezi tɩn zanzan ma zaŋɩ ba zɩgɩ nɔɔna bam maama yigǝ nɩ, yɩ ba ta ba brɩ kʋlʋ ba na kɩ ba cɔgɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ba badonnǝ zanzan ya na yǝni ba tɔgɩ liri kǝm tɩn ma kwe ba liri kǝm twaanʋ tɩm ba vwe daanɩ jǝgǝ dɩdʋa, yɩ ba daarɩ ba zwɛ-tɩ nɔɔna bam maama yigǝ nɩ. Ba ma jeeli twaanʋ tɩm sǝbu ba nii kʋ ni na wʋ́ ta maɩ te tɩn. Kʋ ma yi sǝbu-dala mʋrr-fiinnu (50.000). ");
INSERT INTO xsm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Dɩ́ Yuutu wʋm na brɩ o dam dɩm kʋntʋ tɩn, kʋ ma pa o taanɩ dɩm fɔgɩ dɩ jagɩ dɩ ve yigǝ yɩ nɔɔna sɛ-dɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wǝǝnu tɩntʋ dɛɛn na kɩ tɩ kɛ tɩn, Pooli ma lɩ wʋbʋŋa sɩ o beeri o tɔgɩ Masɩdʋanɩ dɩ Akayi wʋ, sɩ o laan kɛ o vu Zeruzalɛm. O ma bʋŋɩ o wɩ: «A na ve a wʋ Zeruzalɛm nɩ, a maŋɩ sɩ a vu Rom dɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","O ma tʋŋɩ nɔɔna bale sɩ ba da o yigǝ ba vu Masɩdʋanɩ. Bantʋ maa yɩ Timoti dɩ Erasɩtɩ balʋ na tɔgɩ ba tʋŋɩ ba pa-o tɩn. O tɩtɩ ma maŋɩ Azi nɩ o daanɩ fɩnfɩɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Da yam kʋntʋ nɩ mʋ vuvugǝ zanzan tuǝ dɩ́ Yuutu Zezi cwǝŋǝ kam ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nɔɔnʋ wʋdoŋ dɛɛn mʋ wʋ Efɛɛzɩ nɩ, o yɩrɩ mʋ Demɛtrisi. O yɩ gɔgɔ mʋ, yɩ o maɩ sǝbu-pwǝǝnu o maa mɔɔnɩ kamwarʋ o paɩ tɩ nyɩ dɩ digǝ kalʋ ba na zuli ba wɛ Atɩmisi ka wʋnɩ tɩn. O tɩtʋŋa yam maa jaanɩ nyɔɔrɩ zanzan ya paɩ o tɩntʋŋ-donnǝ bam. ");
INSERT INTO xsm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O ma zaŋɩ o bǝŋi ba maama dɩ balʋ dɩ na tʋŋɩ tɩtʋŋa yantʋ doŋ tɩn, yɩ ba la daanɩ. O ma ta dɩ ba o wɩ: «A badonnǝ-ba, abam maŋɩ á ye nɩ tɩtʋŋɩ dɩlʋ dɩ́ na jɩgɩ dɩ́ tʋŋɩ tɩn mʋ pa dɩ́ jɩa gara. ");
INSERT INTO xsm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Abam nan nɛ yɩ á kwǝri á ni Pooli wʋntʋ na kɩ te tɩn. O yǝni o tɛ nɩ nabiinǝ na mɛ ba jɩa ba kɩ wǝǝnu tɩlʋ tɩn bá wanɩ tɩ taa yɩ wa cɩga cɩga, dɩ́ wʋ maŋɩ sɩ dɩ́ zuli-ya. O kɩ kʋntʋ mʋ o sʋgɩ nɔɔna zanzan o pa ba sɛ o taanɩ dɩm, yɩ kʋ daɩ Efɛɛzɩ yɩranɩ wʋnɩ mʋ o kɩ kʋntʋ, kʋ gɛ fɩɩn mʋ sɩ kʋ taa yɩ Azi tɩʋ kʋm maama. ");
INSERT INTO xsm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kʋntʋ maama waɩ kʋ pa nɔɔna ŋɔɔnɩ ba cɔgɩ dɩbam tɩtʋŋɩ dɩm. Kʋ ta wǝli da, ba laan wʋ́ gooni dɩbam wɛ kamunu Atɩmisi digǝ kam, yɩ baá pa ka taa yɩ kafɛ. Kʋlʋ na daarɩ tɩn mʋ yɩ sɩ Atɩmisi tɩtɩ yɩrɩ dɩm wʋ́ cɔgɩ nɔɔna tee nɩ, yɩ wʋntʋ ya yɩ wɛ dɩlʋ nɔɔna maama na zuli Azi tɩʋ kʋm wʋnɩ dɩ lʋgʋ baŋa maama wʋnɩ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nɔɔna bam na ni kʋntʋ tɩn, ba bana ma tiini ya zaŋɩ zanzan yɩ ba kaasɩ ba wɩ: «Dɩbam Efɛɛzɩ tiinǝ wɛ Atɩmisi mʋ jɩgɩ dam!» ");
INSERT INTO xsm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sɔɔ laan ma tiini kʋ kɩ tɩʋ kʋm maama wʋnɩ bɔgɩ bɔgɩ. Nɔn-kɔgɔ kʋm ma vu ba ja Gayusi dɩ Arisarɩkɩ, yɩ ba kɩ lɩla ba vaŋɩ-ba ba ja vu tɩʋ kʋm joro jǝgǝ kam. Nɔɔna bantʋ bale ya tɔgɩ dɩ Pooli mʋ ba nuŋi Masɩdʋanɩ ba ba. ");
INSERT INTO xsm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pooli ma bʋŋɩ sɩ o vu o zɩgɩ kɔgɔ kʋm yigǝ nɩ o ŋɔɔnɩ dɩ ba. Zezi karabiǝ bam ma wʋ sɛ ba pa-o cwǝŋǝ. ");
INSERT INTO xsm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Tɩʋ kʋm dɩdɛɛra badonnǝ ya di ciloŋo dɩ Pooli. Ba ma tʋŋɩ ni ba loor-o sɩ o yɩ zaŋɩ o vu joro kʋm jǝgǝ. ");
INSERT INTO xsm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ba ma kɩ sɔɔ bɔgɩ bɔgɩ joro jǝgǝ kam nɩ. Nɔɔnʋ maama maa tiini o ŋɔɔnɩ o wʋbʋŋa taanɩ dɩ kwǝr-dɩa. Kɔgɔ kʋm nɔɔna zanzan ma wʋ lwarɩ woŋo kʋlʋ ŋwaanɩ ba na jeeri daanɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Zwifǝ bam ma lɩ Alɛsandrɩ sɩ o nuŋi o zɩgɩ kɔgɔ kʋm yigǝ nɩ o ŋɔɔnɩ. Kɔgɔ kʋm nɔɔna badonnǝ ma kwaanɩ ba brɩ-o o na wʋ́ kɩ te. O ma zǝŋi o jɩŋa sɩ ba cǝgi sɔɔ kʋm, yɩ o sɩŋɩ sɩ o tʋlɩ kʋlʋ na kɩ tɩn o brɩ nɔn-kɔgɔ kʋm. ");
INSERT INTO xsm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ba nan na lwarɩ nɩ o yɩ Zwifu tɩn, ba maama maa tɔgɩ daanɩ ba tiini ba bagɩ bɩdwɩ ba wɩ: «Dɩbam Efɛɛzɩ tiinǝ wɛ Atɩmisi jɩgɩ dam!» Ba kɩ kʋntʋ doŋ mʋ taan, sɩ kʋ vu kʋ yi nɩnɛɛnɩ luu tɩle te. ");
INSERT INTO xsm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tɩʋ kʋm twan-pʋpʋnʋ laan ma kwaanɩ o pa kɔgɔ kʋm bɩcara pǝni tɩga nɩ. O ma ta dɩ ba o wɩ: «A badonnǝ Efɛɛzɩ tiinǝ-ba, nɔɔn-nɔɔnʋ tǝrǝ o na yǝri nɩ dɩbam wɛ kamunu Atɩmisi digǝ kam zɩgɩ Efɛɛzɩ wʋnɩ yoba seeni, yɩ dɩbam mʋ nii ka baŋa nɩ. Dɩ́ ta kwǝri dɩ́ jɩgɩ dɩ kamɔgɔ kʋlʋ na nuŋi wɛyuu nɩ kʋ tʋ tɩga nɩ tɩn dɩ́ niǝ. ");
INSERT INTO xsm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nɔɔn-nɔɔnʋ bá wanɩ o ta nɩ kʋntʋ yɩ vwan. Kʋntʋ ŋwaanɩ kʋ maŋɩ sɩ á pa á bɩcara pǝni tɩga nɩ, sɩ á yɩ garɩ á kɩ kʋlʋ na wʋ maŋɩ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nii-na, abam jaanɩ nɔɔna bantʋ bale á ba yo, yɩ ba wʋ ŋɔgɩ dɩbam wɛ digǝ kam wǝǝnu naa ba ŋɔɔnɩ ba cɔgɩ dɩbam wɛ dɩm yuu. ");
INSERT INTO xsm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kʋ nan na yɩ Demɛtrisi dɩ o nɔɔna bam, ba na jɩgɩ nɔɔnʋ wʋm taanɩ, ba maŋɩ sɩ ba vu sarɩya dim jǝgǝ nɩ ba saŋ-o dɩdɛɛra bam yigǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kʋ daarɩ, abam ta na jɩgɩ bwiǝ sɩ á wǝli da, dɩ́ maŋɩ sɩ dɩ́ bǝŋi tɩʋ kʋm nɔɔna sɩ ba la daanɩ, nɩ kʋ na wʋ́ tɔgɩ cwǝŋǝ te tɩn. Dɩ́ laan wʋ́ wanɩ dɩ́ ŋɔɔnɩ taanɩ dɩm sɩ dɩ́ ni dɩ kuri. ");
INSERT INTO xsm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kʋlʋ na kɩ zɩm tɩn wʋ́ wanɩ kʋ pa Rom tiinǝ bam cwǝŋǝ sɩ ba taa wɩ, dɩ́ zɩm jeeri daanɩ dɩ́ kɩ wo-balɔrɔ. Sɔɔ kʋm na su tɩʋ kʋm maama tɩn, kʋ ba jɩgɩ kuri. Ba na bwe dɩbam kʋ kuri, dɩ́ bá wanɩ dɩ́ ŋɔɔnɩ dɩ́ vrɩ dɩ́ tɩtɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","O na tagɩ kʋntʋ o ti tɩn, o ma ta dɩ nɔn-kɔgɔ kʋm sɩ ba viiri. ");
INSERT INTO xsm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tɩʋ kʋm vuvugǝ kam na tu ka ti tɩn, Pooli laan ma zaŋɩ sɩ o kɛ. O ma bǝŋi Zezi karabiǝ bam sɩ ba jǝni daanɩ, yɩ o ŋɔɔnɩ dɩ ba o pa ba na baarɩ. O ma daarɩ o banɩ-ba yɩ o kɛ o vu Masɩdʋanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O maa tʋlɩ je sɩm kʋntʋ maama o ŋɔɔnɩ wǝǝnu zanzan o brɩ nɔɔna bam o pa ba na baarɩ. O daa ma kɛ o vu o yi Grɛkɩ tɩʋ. ");
INSERT INTO xsm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","O ma kɩ canɩ sɩtɔ dáanɩ. O laan ma ti o yigǝ sɩ o zʋ naboro o vu Siiri. O ma ba o lwarɩ nɩ Zwifǝ bam kɩ ni daanɩ sɩ ba kwaanɩ ba cɔg-o. Kʋntʋ ŋwaanɩ o ma lǝni o wʋbʋŋa yɩ o bʋŋɩ sɩ o vu tɩga nɩ o tɔgɩ Masɩdʋanɩ cwǝŋǝ kam o joori o vu Siiri. ");
INSERT INTO xsm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Balʋ na zaŋɩ sɩ ba tɔgɩ dɩd-o tɩn mʋ tɩntʋ: Sopatɛɛrɩ wʋlʋ na yɩ Pirusi bu yɩ o nuŋi Beere tɩn, Arisitakɩ dɩ Sɩkɔn, bantʋ nuŋi Tesaloniki mʋ, Gayusi wʋlʋ na nuŋi Dɛrɩbɩ tɩn, Timoti, Tisiki dɩ Trofim, ba na yɩ Azi tiinǝ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bantʋ mʋ dɛ yigǝ ba loori ba vu Trʋasɩ ba cǝgi dɩbam da. ");
INSERT INTO xsm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Dɩbam tɩtɩ laan ma maŋɩ Filipi nɩ, yɩ dɩ́ tɔgɩ dɩ́ di Zwifǝ bam candiǝ kalʋ ba na yǝni ba di dɩpɛ dɩlʋ na ba jɩgɩ dabɩlɩ tɩn. Candiǝ kam na ti tɩn, dɩ́ laan ma zʋ naboro dɩ́ tɔgɩ nɩnɩʋ kʋm wʋ dɩ́ kɩ da yanu dɩ́ vu dɩ́ yi Trʋasɩ. Dɩ́ ma jeeri dɩ́ tɔgɩ-donnǝ bam da, yɩ dɩ́ kɩ da yarpɛ tɩʋ kʋm nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dɛ dɩlʋ na saŋɩ Zwifǝ bam siun dɛ dɩm tɩn, dɩbam maama ma jeeri daanɩ sɩ dɩ́ di wʋdiu nɩ Zezi dɛɛn na fɔgɩ dɩpɛ o pa o karabiǝ bam yɩ ba di te tɩn. Pooli ma tiini o ŋɔɔnɩ o brɩ nɔɔna bam taan, kʋ vu kʋ yi tɩtɩɩ kʋnkʋrʋ, bɛŋwaanɩ tɩga na pʋʋrɩ o lagɩ o viiri mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Dɩ́ ya lagɩ daanɩ wɛyuu digǝ kalʋ na yɩ bɩtɔ tu tɩn wʋnɩ mʋ. Ba ma tarɩgɩ min-zwǝǝnu zanzan ba zɩgɩ da. ");
INSERT INTO xsm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nɔn-dʋŋʋ kʋdoŋ maa tɔgɩ o wʋra, o yɩrɩ mʋ Yutiki. O maa je tǝkoro ni nɩ. Pooli na tiini o ŋɔɔnɩ o daanɩ kʋntʋ tɩn, nɔn-dʋŋʋ kʋm maa je o dɔ o vɩɩla. O laan ma ba o dɔ fasɩ o kɛ. O ma tɔgɩ tǝkoro kʋm o tʋ tɩga nɩ. Ba ma tu ba kwe-o dɩ o tɩga. ");
INSERT INTO xsm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pooli tɩtɩ ma tu o vu o pǝni nɔn-dʋŋʋ kʋm baŋa nɩ o kukwǝr-o dɩ o jɩa yɩ o wɩ: «Á yɩ pa á yɩra sɔɔrɩ, sɩ o ta ŋwɩ mʋ.» ");
INSERT INTO xsm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pooli ma joori o di wɛyuu digǝ kam. O ma fɔ dɩpɛ dɩm o di. O daa ta ma larɩ dɩ ba taan, yɩ tɩga ba ka pʋʋrɩ. O laan ma viiri. ");
INSERT INTO xsm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","O na viiri tɩn, nɔɔna bam ma ja nɔn-dʋŋʋ kʋm ba ja vu sɔŋɔ dɩ yazurǝ. Ba bɩcara ma pǝni tɩga nɩ yɩ ba jɩgɩ wʋpolo. ");
INSERT INTO xsm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Dɩbam ma yagɩ Pooli, yɩ dɩ́ vu dɩ́ zʋ naboro kʋm sɩ dɩ́ tɔgɩ yigǝ dɩ́ da nɩnɩʋ kʋm wʋ dɩ́ vu Asɔsɩ. Dɩ́ ya kɩ ni daanɩ sɩ dɩ́ jeeri Pooli Asɔsɩ nɩ mʋ, o na lagɩ sɩ o vu tɩga nɩ tɩn ŋwaanɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Dɩ́ na nɛ daanɩ Asɔsɩ nɩ tɩn, Pooli laan ma zʋ naboro kʋm, yɩ dɩ́ maama tɔgɩ daanɩ dɩ́ vu dɩ́ yi Mitilɛɛnɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Dɩ́ ma zɩgɩ dáanɩ dɩ́ tɔgɩ nɩnɩʋ kʋm wʋ dɩ́ kɛ. Tɩga ma pʋʋrɩ, yɩ dɩ́ vu dɩ́ tɔgɩ Kiyo buburu kʋm dɩ́ kɛ. Tɩga daa ma pʋʋrɩ, dɩ́ ma vu dɩ́ bɛ dɩ́ yi Samɔsɩ. Tɩga daa ta na pʋʋrɩ tɩn, dɩ́ ma vu dɩ́ yi Mileti. ");
INSERT INTO xsm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pooli dɛɛn ya bʋŋɩ sɩ o da Efɛɛzɩ mʋ o kɛ sɩ o yɩ zɩgɩ da. O ya ba lagɩ sɩ o daanɩ Azi nɩ, bɛŋwaanɩ o lagɩ lɩla mʋ sɩ o na waɩ, sɩ o vu o yi Zeruzalɛm dɩ Pantɩkoti candiǝ kam ta wʋ yi. ");
INSERT INTO xsm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Dɩbam dɛɛn na wʋ Mileti nɩ tɩn, Pooli ma tʋŋɩ ni o pa Zezi kɔgɔ kʋm nakwa bam Efɛɛzɩ nɩ o wɩ, ba ba. ");
INSERT INTO xsm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ba na tu tɩn, o ma ta dɩ ba o wɩ: «Abam maŋɩ á ye a dɛɛn na zʋʋrɩ abam tee nɩ yɩ a kɩ te maŋa maama, kʋ na zɩgɩ dɛ dɩlʋ a na sɩŋɩ a ba Azi tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","A tʋŋɩ a pa dɩ́ Yuutu wʋm dɩ tu-n-tɩtɩ mʋ, a yi-na nuŋi, yɩ a na yaara dɩ Zwifǝ bam na kɩ ni daanɩ sɩ ba cɔgɩ amʋ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Abam ta ye nɩ, a wʋ yagɩ sɩ a ta woŋo kʋlʋ maama na wʋ́ wanɩ kʋ wǝli abam tɩn a brɩ abam. A ma kwaanɩ a brɩ abam Wɛ cɩga kam nɔɔna maama yigǝ nɩ dɩ á tɩtɩ sam nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","A ma tiini a brɩ Zwifǝ bam dɩ dwi-gɛ tiinǝ maama sɩ ba lǝni ba wʋrʋ ba sɛ Wɛ, sɩ ba daarɩ ba kɩ ba wʋ-dɩdʋa dɩ dɩ́ Yuutu Zezi. ");
INSERT INTO xsm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Lele kʋntʋ a laan maa ve Zeruzalɛm. Kʋ yɩ Wɛ Joro kʋm mʋ fɩ-nɩ sɩ a vu, yɩ a yǝri kʋlʋ na wʋ́ vu kʋ kɩ amʋ da tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","A na ye kʋlʋ tɩn mʋ yɩ sɩ Wɛ Joro kʋm yǝni kʋ brɩ amʋ tɩʋ maama nɩ, nɩ nɔɔna wʋ́ ja-nɩ ba vɔ yɩ ba kwǝri ba bɛɛsɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","A nan na bʋŋɩ te tɩn, a ba paɩ sɩ a ŋwɩa taa jɩgɩ nyɔɔrɩ ka pa-nɩ. Kʋlʋ na yɩ wo-ŋʋŋʋ tɩn mʋ yɩ sɩ a tʋŋɩ tɩtʋŋa yalʋ dɩ́ Yuutu Zezi na kɩ a jɩŋa nɩ sɩ a tʋŋɩ tɩn a ti. Tɩtʋŋa yam kʋntʋ mʋ yɩ sɩ a kwaanɩ a brɩ Wɛ kwǝr-ywǝŋǝ kam dɩ DƖ na kɩ nɔɔna lanyɩranɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","A nan ye nɩ abam wʋlʋwʋlʋ daa bá na amʋ, abam nan yɩ balʋ a na beeri á wʋnɩ a brɩ abam Wɛ paarɩ dɩm cɩga kam tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kʋntʋ ŋwaanɩ a lagɩ a tiini a kaanɩ abam zɩm dɛ dɩm nɩ, nɩ abam wʋlʋ na gɛ ŋwɩa Wɛ tee nɩ, kʋ daa daɩ amʋ yigǝ. ");
INSERT INTO xsm_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Bɛŋwaanɩ a tɔɔlɩ cɩga kalʋ maama na tɔgɩ Wɛ wʋbʋŋa tɩn a brɩ abam, yɩ a wʋ sǝgi abam kʋlʋkʋlʋ. ");
INSERT INTO xsm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nan fɔgɩ-na á taá nii á tɩtɩ baŋa nɩ, dɩdaanɩ kɔgɔ kʋlʋ maama Wɛ Joro kʋm na kwe kʋ kɩ abam jɩŋa nɩ sɩ á taá nii tɩn. Á taá nii Wɛ kɔgɔ kʋm baŋa nɩ, nɩ nayɩra na nii ba peeni te tɩn. Wɛ mɛ DƖ tɩtɩ bu wʋm jana mʋ DƖ ma vrɩ DƖ kɔgɔ kʋm sɩ kʋ taa yɩ DƖ nyɩm. ");
INSERT INTO xsm_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A ye nɩ, a na viiri a daarɩ abam, nɔn-balwaarʋ wʋ́ zaŋɩ ba zʋ abam wʋ ba yaarɩ abam nɩnɛɛnɩ nywǝnkuri na jaanɩ peeni te tɩn. Ba bá sɛ sɩ ba yagɩ abam kɔgɔ kʋm yɩ ba wʋ cɔgɩ abam wʋ nɔɔna. ");
INSERT INTO xsm_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nɔɔna dɩ wʋ́ zaŋɩ abam tɩtɩ wʋnɩ, ba pipiri Wɛ cɩga kam ba ganɩ Zezi karabiǝ bam, ba pa ba ywǝri Wɛ kwaga nɩ sɩ ba daarɩ ba tɔgɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kʋntʋ ŋwaanɩ á fɔgɩ á cɩ á tɩtɩ. Á taá guli nɩ amʋ zʋ abam tee nɩ bɩna yatɔ, yɩ a kaanɩ abam maama sɩ á taá tɔgɩ Wɛ dɩ cɩga. Maŋa maama a yǝni a kɩ kʋntʋ mʋ wɩa dɩ tɩtɩɩ, yɩ a yi-na nuŋi zanzan. ");
INSERT INTO xsm_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","A laan lagɩ a kɩ abam Wɛ jɩŋa nɩ, sɩ á taá tɔgɩ DƖ zaanɩ kwǝrǝ kam. Kaá wanɩ ka kwɛ abam lanyɩranɩ, sɩ á laan ba á tɔgɩ dɩ balʋ maama na yɩ Wɛ tɩtɩ nɔɔna tɩn á na ywǝǝni DƖ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A wʋ joŋi sǝbu naa sǝbu-sɩŋa naa gwaarʋ abam wʋlʋwʋlʋ tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Abam tɩtɩ ye lanyɩranɩ nɩ, a mɛ a tɩtɩ jɩa mʋ a tʋŋɩ sɩ a dɩ a tɔgɩ-donnǝ bam wanɩ dɩ́ na dɩ́ ni-wʋdiu. ");
INSERT INTO xsm_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","A na kɩ kʋlʋ maama abam tee nɩ yɩ a cɛ dɩ tɩtʋŋa kʋntʋ doŋ tɩn, a kɩ a brɩ abam nɩ dɩ́ maŋɩ sɩ dɩ́ tʋŋɩ dɩ́ wǝli nabwǝnǝ mʋ. Taá guli-na dɩ́ Yuutu Zezi na tagɩ o wɩ: ‹Nmʋ na kwe woŋo n pa n doŋ, nń na wʋpolo kʋ dwǝni n na joŋi woŋo n doŋ tee nɩ.› » ");
INSERT INTO xsm_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pooli na tagɩ kʋntʋ o ti tɩn, ba maama ma kuni doonǝ yɩ o loori Wɛ o pa-ba. ");
INSERT INTO xsm_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ba ma zaŋɩ yɩ ba maama tiini ba keerǝ. Ba ma kukwǝri Pooli lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ba wʋrʋ ma tiini tɩ cɔgɩ, dɩ o na tagɩ taanɩ dɩlʋ o brɩ-ba nɩ ba daa bá joori ba na-o tɩn. Ba ma zaŋɩ ba kogil-o ba ja vu naboro kʋm na wʋ mɛ tɩn ba yag-o. ");
INSERT INTO xsm_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Dɩ́ laan ma banɩ-ba yɩ dɩ́ daarɩ dɩ́ viiri. Dɩ́ ma kwe dɩ́ yigǝ dɩ́ yɔɔrɩ nɩnɩʋ kʋm wʋ dɩ́ vu dɩ́ yi Kosi. Tɩga ma pʋʋrɩ, dɩ́ daa ma yi Rodi. Dɩ́ ma zɩgɩ dáanɩ dɩ́ vu Patara. ");
INSERT INTO xsm_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dɩ́ na yi dáanɩ tɩn, dɩ́ ma na naboro kʋdoŋ kʋ na lagɩ kʋ vu Fenisi. Dɩ́ ma vu dɩ́ zʋ kʋ wʋ sɩ dɩ́ tɔgɩ dɩ́ vu. ");
INSERT INTO xsm_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dɩ́ na maa ve tɩn, dɩ́ ma tʋlɩ dɩ́ na Sipri. Dɩ́ ma yagɩ-kʋ dɩ́ jagwiǝ nɩ, yɩ dɩ́ daarɩ dɩ́ kɛ. Dɩ́ ma vu dɩ́ yi Siiri. Dɩ́ na yi da tɩn, dɩ́ ma zɩgɩ Tiiri nɩ. Kʋ yɩ dáanɩ mʋ ba maŋɩ sɩ ba lɩ naboro kʋm zɩla yam. ");
INSERT INTO xsm_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Dɩ́ ma nuŋi dɩ́ vu dɩ́ jeeri balʋ na yɩ Zezi karabiǝ tɩn, yɩ dɩ́ kɩ da yarpɛ ba tee nɩ. Dɩ́ na wʋra tɩn, Wɛ Joro kʋm dam ma pa ba ta dɩ Pooli sɩ o yɩ zaŋɩ o vu Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Da yarpɛ yam na kɛ tɩn, dɩ́ ma zaŋɩ dɩ́ kwe dɩ́ cwǝŋǝ sɩ dɩ́ viiri. Zezi nɔɔna bam dɩ ba kaana dɩ ba biǝ maama ma ja dɩbam ba nuŋi tɩʋ kʋm wʋnɩ ba vu sɩ ba yagɩ. Dɩ́ na ve dɩ́ yi nɩnɩʋ kʋm ni tɩn, dɩbam maama ma kuni doonǝ tɩga nɩ dɩ́ warɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Dɩ́ na warɩ Wɛ dɩ́ ti tɩn, dɩ́ ma banɩ daanɩ dɩ yi-na, yɩ dɩ́ zʋ naboro kʋm. Bantʋ ma joori sɔŋɔ. ");
INSERT INTO xsm_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Dɩ́ ma zaŋɩ dɩ́ nuŋi Tiiri nɩ, yɩ dɩ́ tʋlɩ nɩnɩʋ kʋm ni dɩ́ vu dɩ́ yi Tolɛmɩ. Dɩ́ na yi da tɩn, mʋ dɩ́ nɛ Zezi karabiǝ. Dɩ́ ma jɔɔnɩ-ba yɩ dɩ́ kɩ dɛ dɩdwɩ ba tee nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tɩga na pʋʋrɩ tɩn, dɩ́ ma zaŋɩ dɩ́ vu dɩ́ yi Sezaarɩ. Dɩ́ ma vu dɩ́ pǝni Filipi-ba sɔŋɔ nɩ. Wʋntʋ mʋ tɔɔlɩ Wɛ kwǝr-ywǝŋǝ kam, yɩ o tɔgɩ o yɩ nɔɔna barpɛ balʋ ba na lɩ Zeruzalɛm nɩ tɩn wʋ nɔɔnʋ dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","O maa jɩgɩ o bukwa bana ba ta wʋ zʋ banna. Bantʋ yɩ balʋ na waɩ ba ŋɔɔnɩ Wɛ yiyiu-ŋwɛ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Dɩ́ na kɩ da fɩnfɩɩn dáanɩ kʋntʋ tɩn, nɔɔnʋ wʋdoŋ ma nuŋi Zude o ba dɩbam te. O yɩrɩ mʋ Agabusi. O yɩ Wɛ nijoŋnu mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","O na tu dɩbam te kʋntʋ tɩn, o ma lɩ Pooli kilǝ o tǝŋǝ nɩ o ma vɔ o tɩtɩ nɛ dɩ o jɩa o kɩ daanɩ. O laan ma ta o wɩ: «Mʋ Wɛ Joro kʋm na tagɩ kʋlʋ tɩn kʋ wɩ: Zwifǝ balʋ na zʋʋrɩ Zeruzalɛm nɩ tɩn wʋ́ ja kilǝ kantʋ tu ba vɔ tɩntʋ doŋ, yɩ ba daarɩ ba kɩ-o dwi-gɛ tiinǝ jɩŋa nɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Dɩ́ na ni kʋntʋ tɩn, dɩbam dɩ balʋ na tɔgɩ ba wʋra tɩn maa kwaanɩ dɩ́ loori Pooli sɩ o yɩ zaŋɩ o vu Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","O ma lǝri o wɩ: «Bɛŋwaanɩ mʋ abam keerǝ, yɩ á pa a wʋ cɔgɩ? Ba na lagɩ ba vɔ-nɩ Zeruzalɛm nɩ naa ba na lagɩ ba gʋ-nɩ dɩ, amʋ wʋ́ sɛ sɩ a tɩ dɩ́ Yuutu Zezi yɩrɩ ŋwaanɩ.» ");
INSERT INTO xsm_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dɩ́ na loor-o taan dɩ́ ga tɩn, dɩ́ ma yagɩ yɩ dɩ́ ta dɩ́ wɩ: «Wɛ wʋ́ kɩ DƖ wʋbʋŋa na lagɩ kʋlʋ tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dɩ́ na kɩ da fɩnfɩɩn da tɩn, dɩ́ ma zaŋɩ dɩ́ ti dɩ́ yigǝ dɩ́ nuŋi dɩ́ maa ve Zeruzalɛm. ");
INSERT INTO xsm_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Zezi karabiǝ badaara ma zaŋɩ Sezaarɩ nɩ ba kogili dɩbam. Ba ma ja dɩbam ba vu nɔɔnʋ wʋlʋ sɔŋɔ dɩ́ na lagɩ dɩ́ pǝni da tɩn. O yɩrɩ mʋ Mɩnasɔn. O yɩ Sipri tu mʋ o na maŋɩ o yɩ Zezi karabu faŋa faŋa. ");
INSERT INTO xsm_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Dɩ́ na yi Zeruzalɛm tɩn, dɩ́ ko-biǝ bam ma jeeri dɩbam lanyɩranɩ. ");
INSERT INTO xsm_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tɩga na pʋʋrɩ tɩn, Pooli ma zaŋɩ o tɔgɩ dɩdaanɩ dɩbam sɩ dɩ́ vu dɩ́ na Zakɩ. Zezi kɔgɔ kʋm nakwa bam maama maa tɔgɩ ba wʋra. ");
INSERT INTO xsm_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pooli ma jɔɔnɩ-ba. O ma tʋlɩ kʋlʋ maama Wɛ na kɩ dwi-gɛ tiinǝ bam tee nɩ o tɩtʋŋa yam wʋnɩ tɩn o brɩ-ba. ");
INSERT INTO xsm_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ba na ni kʋlʋ maama o na tagɩ tɩn, ba ma kɩ Wɛ le kʋ ŋwaanɩ. Ba laan ma ta dɩ Pooli ba wɩ: «Dɩbam ko-bu, ni kʋ na yɩ te tɩn. Zwifǝ bam mʋrrʋ kɔgɔ kɔgɔ laan mʋ tu ba sɛ Zezi, yɩ ba ta tɔgɩ Wɛ ni-doorǝ yam dɩ ba wʋ maama. ");
INSERT INTO xsm_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ba ni nɩ nmʋ yǝni n brɩ Zwifǝ balʋ na zʋʋrɩ dwi-gɛ tiinǝ wʋnɩ tɩn, sɩ ba yagɩ Wɛ cullu tɩlʋ DƖ na kɩ Moyisi jɩŋa nɩ tɩn. Ba ni nɩ n tɛ nɔɔna bam kʋntʋ sɩ ba daa yɩ ta goni ba bǝkǝri, sɩ ba daa yɩ ta tɔgɩ dɩbam Zwifǝ bam mɩʋ na yɩ te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Zwifǝ balʋ na wʋ yo seeni tɩn wʋ́ lwarɩ nɩ nmʋ tuǝ. Dɩ́ nan wʋ́ kɩ ta mʋ? ");
INSERT INTO xsm_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kʋntʋ, dɩ́ nan wʋ́ brɩ-m n na wʋ́ kɩ te tɩn. Nɔɔna bana wʋ dɩbam tee nɩ ba na goni ba ni dɩ Wɛ. ");
INSERT INTO xsm_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ba na lagɩ ba vu Wɛ-di-kamunu kʋm sɩ ba kwɛ ba tɩtɩ dɩ Wɛ, nmʋ maŋɩ sɩ n tɔgɩ n vu mʋ, sɩ n daarɩ n ŋwɩ kʋlʋ na wʋ́ pa ba na cwǝŋǝ sɩ ba fa ba yuni tɩn. N na kɩ kʋntʋ, nɔɔna bam maama wʋ́ lwarɩ nɩ ba na tɛ kʋlʋ ba pa nmʋ tɩn daɩ cɩga. Ba nan wʋ́ lwarɩ nɩ nmʋ tɩtɩ tɔgɩ Wɛ cullu tɩm na brɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kʋ daarɩ dwi-gɛ tiinǝ balʋ na tu ba kɩ ba wʋ-dɩdʋa dɩ Zezi tɩn, dɩbam maŋɩ dɩ́ pʋpʋnɩ tɔnɔ dɩ́ pa-ba yɩ dɩ́ ta kʋlʋ dɩ́ na bʋŋɩ tɩn. Dɩbam tagɩ-ba sɩ ba yɩ zaŋɩ ba di wʋdiu kʋlʋ nɔɔna na mɛ ba kaanɩ jwǝnǝ tɩn, naa ba di jana, naa ba di varɩm wʋlʋ ba na jujugi ba gʋ tɩn, yɩ dɩ́ ta dɩ ba sɩ ba yɩ cɔgɩ ba tɩtɩ dɩ kaana, sɩ kaana dɩ yɩ cɔgɩ ba tɩtɩ dɩ baara.» ");
INSERT INTO xsm_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ba na tagɩ kʋntʋ tɩn, Pooli ma sɛ ba taanɩ dɩm. Tɩga na pʋʋrɩ tɩn, o ma ja nɔɔna bam o vu sɩ o tɔgɩ o kwɛ o tɩtɩ dɩ Wɛ. O ma daarɩ o zʋ Wɛ-di-kamunu kʋm wʋ, sɩ o ta o brɩ ka yigǝ tiinǝ bam da yalʋ ni na daarɩ sɩ nɔɔna bam kwɛ ba tɩtɩ dɩ Wɛ ba ti tɩn, sɩ ba laan ja ba wǝǝnu tɩm ba ja ba, sɩ ba ma kaanɩ Baŋa-Wɛ ba pa ba dɩdʋa dɩdʋa. ");
INSERT INTO xsm_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Da yarpɛ yam ni na daarɩ fɩɩn sɩ ya ti tɩn, Zwifǝ badaara ma na Pooli Wɛ-di-kamunu kʋm wʋnɩ. Bantʋ nuŋi Azi tɩʋ kʋdoŋ mʋ. Ba ma pa nɔn-kɔgɔ kʋm maama na wʋra tɩn bana zaŋɩ dɩ Pooli. Ba ma ja-o, ");
INSERT INTO xsm_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","yɩ ba tɔɔlɩ ba tɛ ba wɩ: «Yisɩrayɛlɩ tiinǝ-ba, ba zǝni-na dɩbam! Nɔɔnʋ wʋntʋ mʋ yɩ wʋlʋ na tʋlɩ je maama o brɩ nɔɔna maama sɩ ba yɩ taa nɩgɩ dɩbam Yisɩrayɛlɩ tiinǝ, sɩ ba yɩ taa sɛ Wɛ cullu tɩlʋ dɩbam na tɔgɩ tɩn, sɩ ba pa Wɛ-di-kamunu kʋntʋ dɩ ji kafɛ. Kʋ wǝli da, o jaanɩ dwi-gɛ tiinǝ badonnǝ mʋ o ba o zʋ dɩbam Wɛ-digǝ kam wʋ, o pa ba digiru cɔgɩ jǝgǝ kalʋ na yɩ Wɛ nyɩm tɩn.» ");
INSERT INTO xsm_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ba dɛɛn tagɩ kʋntʋ doŋ, bɛŋwaanɩ ba ya nɛ Trofim dɩ Pooli na tɔgɩ daanɩ tɩʋ kʋm wʋnɩ, yɩ o yɩ dwi-gɛ tu na nuŋi Efɛɛzɩ tɩn. Ba dɛɛn bʋŋɩ nɩ nɔɔnʋ wʋm kʋntʋ mʋ Pooli jaanɩ o zʋ Wɛ-di-kamunu kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Vuvugǝ ma zaŋɩ tɩʋ kʋm maama wʋnɩ. Nɔn-kɔgɔ ma duri kʋ vu jǝgǝ kam. Ba laan ma ja Pooli ba tuur-o ba ja nuŋi Wɛ-di-kamunu kʋm wʋnɩ, yɩ ba daarɩ ba pɩ ka niǝ yam maama. ");
INSERT INTO xsm_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nɔn-kɔgɔ kʋm maa kwaana sɩ ba gʋ Pooli. Rom pamaŋna bam dɩdɛɛrʋ wʋm ma ni nɩ Zeruzalɛm tɩʋ kʋm maama vugimi. ");
INSERT INTO xsm_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","O na ni kʋntʋ tɩn, o ma lɩ pamaŋna bam dɩ ba yigǝ tiinǝ badaara, yɩ ba duri lɩla ba vu ba yi kɔgɔ kʋm na wʋ mɛ tɩn. Nɔɔna bam na nɛ-o dɩ o pamaŋna bam kʋntʋ tɩn, ba ma yagɩ Pooli magɩm. ");
INSERT INTO xsm_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dɩdɛɛrʋ wʋm ma vu o twɛ Pooli te, yɩ o pa ba ja-o. O ma pa ba kwe capʋnnʋ tɩle ba ma vɔ-o. O ma daarɩ o bwe sɩ o lwarɩ nɔɔnʋ wʋm na yɩ wʋlʋ tɩn, dɩ o na kɩ kʋlʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","O na bwe kʋntʋ tɩn, nɔɔna badaara ma kaasa kɔgɔ kʋm wʋnɩ yɩ ba tɛ n ni n ni. Sɔɔ kʋm na daga kʋntʋ tɩn, kʋ ma pa dɩdɛɛrʋ wʋm warɩ sɩ o lwarɩ kʋlʋ na kɩ cɩga cɩga tɩn. Kʋntʋ ŋwaanɩ o ma pa o nɔɔna bam ni, sɩ ba ja Pooli ba vu ba pamaŋna bam pɩɩna digǝ kam. ");
INSERT INTO xsm_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ba na jaan-o ba yi natǝnǝ yam diinim jǝgǝ tɩn, pamaŋna bam kwe-o mʋ ba zɩŋɩ, bɛŋwaanɩ nɔn-kɔgɔ kʋm yiǝ tiini ya sɩɩnɩ o baŋa nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nɔɔna bam maama ma pɛ ba pu o kwaga, yɩ ba kaasɩ ba tɛ ba wɩ: «Gʋ-o-na!» ");
INSERT INTO xsm_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pamaŋna bam na lagɩ ba ja Pooli ba zʋ ba pɩɩna digǝ kam tɩn, o ma ta dɩ ba dɩdɛɛrʋ wʋm o wɩ: «Nmʋ wʋ́ pa-nɩ cwǝŋǝ sɩ a ta taanɩ a brɩ-m na?» Dɩdɛɛrʋ wʋm na ni kʋntʋ tɩn, o ma bwe Pooli o wɩ: «Nmʋ kɩ ta mʋ n ni Grɛkɩ tiinǝ taanɩ? ");
INSERT INTO xsm_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kʋ na yɩ kʋntʋ, nmʋ daɩ Ezipi tu wʋlʋ dɛɛn na pɛ nɔɔna vɩn ba tɩʋ kʋm yigǝ tiinǝ ni yɩ o daarɩ o lɩ nɔɔna mʋrr-tɩna (4.000) balʋ na yɩ jara-kǝrǝ o ja vu kagʋa wʋnɩ tɩn na?» ");
INSERT INTO xsm_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pooli ma lǝri o wɩ: «Aye. Amʋ yɩ Zwifu mʋ. Ba lʋgɩ amʋ Silisi tɩʋ Tarɩsɩ nɩ mʋ. A yɩ tʋ-kamunu kʋm kʋntʋ nɔn-bu mʋ. A loori-m sɩ n pa-nɩ cwǝŋǝ sɩ a ŋɔɔnɩ dɩ nɔn-kɔgɔ kʋm.» ");
INSERT INTO xsm_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Dɩdɛɛrʋ wʋm ma sɛ. Pooli ma zaŋɩ o zɩgɩ natǝnǝ yam baŋa nɩ. O ma zǝŋi o jɩŋa kɔgɔ kʋm baŋa nɩ. Ba maama ma cǝgi sɔɔ. O ma ŋɔɔnɩ dɩ ba dɩ ba tɩtɩ Zwifǝ taanɩ dɩm. ");
INSERT INTO xsm_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","O ma ta o wɩ: «A kwǝ-ba dɩ a ko-biǝ-ba, á fɔgɩ á cǝgi sɩ a tʋlɩ kʋ na yɩ te tɩn a brɩ abam.» ");
INSERT INTO xsm_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Zwifǝ bam na lwarɩ nɩ o ŋɔɔnɩ ba tɩtɩ dwi taanɩ mʋ tɩn, ba ma fɔgɩ ba cǝgi sɔɔ. ");
INSERT INTO xsm_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","O laan ma ta dɩ ba o wɩ: «Amʋ yɩ Zwifu mʋ. Ba lʋgɩ-nɩ Silisi tɩʋ Tarɩsɩ nɩ mʋ. Kʋ nan yɩ Zeruzalɛm yo mʋ a kɩ nɔɔnʋ. Gamalɩyɛlɩ mʋ brɩ amʋ dɩbam nabaara cullu tɩm na yɩ te tɩn cɩga cɩga. A dɛɛn cɛ lanyɩranɩ a kwe a tɩtɩ a pa Wɛ nɩnɛɛnɩ abam zɩm dɩ na kɩ te tɩn mʋ. ");
INSERT INTO xsm_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","A dɛɛn yaarɩ balʋ na sɛ ba tɔgɩ Zezi cwǝŋǝ kam tɩn, yɩ a daarɩ a pa ba gʋ badaara. A maa yǝni a jaanɩ baara dɩ kaana a kɩ pɩɩna digǝ nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dɩbam kaanɩm yuutu wʋm dɩdaanɩ dɩ́ nakwa kɔgɔ kʋm maama wʋ́ wanɩ ba ta nɩ kʋ yɩ cɩga. Maŋa kadoŋ nɩ a ve bantʋ te mʋ a joŋi twaanʋ tɩlʋ a na wʋ́ kwe a brɩ Zwifǝ balʋ na wʋ Damasɩ nɩ tɩn, sɩ ba pa-nɩ cwǝŋǝ sɩ a ja balʋ na tɔgɩ Zezi cwǝŋǝ kam tɩn, a vɔ-ba a ja a ba Zeruzalɛm sɩ ba na cam. ");
INSERT INTO xsm_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","A na maa ve yɩ a daarɩ fɩɩn sɩ a yi Damasɩ tɩn, kʋ na maŋɩ dɩ wɩa tɩtarɩ nɩ tɩn, mʋ pooni dɛ dɩ nuŋi wɛyuu nɩ dɩ ba dɩ pɩpɩlɩ dɩ kaagɩ-nɩ. ");
INSERT INTO xsm_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A ma tʋ tɩga nɩ, yɩ a ni kwǝrǝ na bǝŋi-nɩ ka wɩ: ‹Sooli, Sooli! Bɛŋwaanɩ mʋ yɩ n jɩgɩ amʋ n bɛɛsɩ kʋntʋ?› ");
INSERT INTO xsm_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","A ma bwe a wɩ: ‹A tu, nmʋ yɩ wɔɔ mʋ?› O ma lǝri o wɩ: ‹Amʋ yɩ Zezi mʋ, Nazarɛtɩ tu wʋlʋ nmʋ na jɩgɩ n bɛɛsɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nɔɔna balʋ na tɔgɩ dɩ amʋ tɩn ma na pooni dɩm, yɩ ba wʋ ni wʋlʋ kwǝrǝ na ŋɔɔnɩ dɩ amʋ tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","A laan ma bwe a wɩ: ‹A tu, bɛɛ mʋ a nan wʋ́ kɩ?› Dɩ́ Yuutu wʋm ma lǝri-nɩ o wɩ: ‹Zaŋɩ n vu n zʋ Damasɩ, sɩ dáanɩ mʋ ba laan wʋ́ brɩ-m kʋlʋ maama Wɛ na pɛ ni sɩ n kɩ tɩn.› ");
INSERT INTO xsm_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","A ma zaŋɩ wɛɛnɩ, yɩ a yiǝ daa ba naɩ, pooni dɩm na tiini dɩ pɩpɩlɩ-ya tɩn ŋwaanɩ. Kʋntʋ, balʋ na tɔgɩ dɩ amʋ tɩn ma ja a jɩŋa ba vaŋɩ-nɩ ba ja zʋ Damasɩ tɩʋ kʋm wʋ. ");
INSERT INTO xsm_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nɔɔnʋ wʋdoŋ maa wʋra, o yɩrɩ mʋ Ananiya. O maa nɩgɩ Wɛ lanyɩranɩ, yɩ o tɔgɩ dɩbam Zwifǝ bam cullu tɩm. Zwifǝ balʋ maama na zʋʋrɩ Damasɩ nɩ tɩn maa tɛ o taanɩ ba wɩ, o yɩ nɔn-ŋʋm. ");
INSERT INTO xsm_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","O laan ma ba o zɩgɩ amʋ tee nɩ yɩ o wɩ: ‹A ko-bu Sooli, joori n ta n naɩ!› O na tagɩ kʋntʋ tɩn, bɩdwɩ baŋa nɩ mʋ a yiǝ yam puri yɩ a na o yibiyǝ. ");
INSERT INTO xsm_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","O ma ta o wɩ: ‹Dɩbam nabaara Baŋa-Wɛ mʋ lɩ nmʋ sɩ n lwarɩ DƖ wʋbʋŋa na lagɩ kʋlʋ tɩn, sɩ n daarɩ n na Wʋ-poŋo Tu wʋm sɩ n ni o na ŋɔɔnɩ dɩ o tɩtɩ kwǝrǝ. ");
INSERT INTO xsm_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Bɛŋwaanɩ nmʋ wʋ́ ta n yɩ o maana tu sɩ n brɩ nɔɔna bam maama o cɩga kam, sɩ n ta n brɩ-ba nmʋ na nɛ kʋlʋ yɩ n daarɩ n ni te tɩn. ");
INSERT INTO xsm_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nmʋ nan wʋ maŋɩ sɩ n da n daanɩ. Zaŋɩ sɩ n loori Wɛ dɩ́ Yuutu wʋm yɩrɩ ŋwaanɩ, sɩ n daarɩ n pa ba miisi-m na wʋnɩ, sɩ Wɛ wʋ́ yagɩ n lwarɩm DƖ ma cɛ-m.› ");
INSERT INTO xsm_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kʋntʋ na kɛ tɩn, a laan ma joori a vu Zeruzalɛm. A ma vu Wɛ-di-kamunu kʋm wʋ a wʋra a warɩ Wɛ. A na wʋra tɩn, Wɛ ma pa a na wo-kɩnkagɩlɩ nɩ dɩndwɩa te. ");
INSERT INTO xsm_vpl VALUES ("AC22_18","074_22