﻿USE sofia;
DROP TABLE IF EXISTS sofia.xsi_vpl;
CREATE TABLE xsi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xsi_vpl WRITE;
INSERT INTO xsi_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ambo tamâta toŋge tini pwâka ŋana ipaloŋo pa kinzi tamâta sakamao nenzi ŋgua, ambo i tini pwâka ŋana ipono muli pa kinzi kiesaka tamwatanzi nenzi ŋgua, ambo i tini pwâka ŋana isaŋona kunzi tamâta ŋinde uru siporo ŋgua pavaligiŋa pa Yova Kindeni, ande tamâta ŋinde ikura tu indeka. ");
INSERT INTO xsi_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Tamâta ŋinde ilo ara ndo ŋana Yova Kindeni ne ŋgua tukuŋa kâ, aku i nde kari wa mbo wa uru kalo ŋgere sondo ŋana ŋgua tukuŋa ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Tamâta ŋinde itogo kâi toŋge imandi lââ pwali. I uru ipula kanaŋo ikura zo zo, aku ne lau uru ŋgâla-ŋgâla tia ndo. Vetâŋa rârâni iveta nde uru ipâŋga ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Aŋga kinzi tamâta sakamao nde simo mine tia. Kinzi simandi kaika tia ndo. Kinzi sitogo gawura lawea itapala kala ilâ. ");
INSERT INTO xsi_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Mine nde Yova Kindeni ma ipare nia sondo panzi tamâta sakamao. Kinzi kiesaka tamwatanzi ma sikura tu simo kunzi Yova Kindeni ne tamâta, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ŋana tu Yova Kindeni uru ikea ŋananzi i ne tamâta. Taitu kinzi tamâta sakamao ma naonzi tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Mana mana ŋana kinzi tinikoa ŋgu, a? Ŋana sâ kâ ŋga kinzi sipa ŋgua ŋana siveta paraŋa kâ, a? Ŋana sâ kâ ŋga siveta ŋgua pâŋa kaa kaa mine, a? ");
INSERT INTO xsi_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Kinzi ŋgu ŋinde nenzi koipu ŋalaŋala siluku ŋana paraŋa kâ. Kinzi nenzi tamâta mbâna-mbâna sipasau tu siroto nzâla ŋana siŋgoloa paraŋa kuku Yova Kindeni tava Koipu Ŋalae ŋinde i muŋga ipatea. ");
INSERT INTO xsi_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Kinzi situ ŋgua mine tu, “Yova Kindeni kuku ne koipu ŋalae rua nde sipa wâlo kaika lâ kinda tininda lâ, andeta kala ŋine kinda ma tapu wâlo mbutukunâŋa ŋinde ututu.” ");
INSERT INTO xsi_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Andeta Maro Ŋalae, ina uru isaŋona koipu ŋalae ne saŋonâŋa nia lâ samba lawea, ande iŋeleanzi wa iveta “a” panzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ŋineŋga i wisi nâna ŋalae panzi kala itu ŋgua kaika panzi. Aku Maro Ŋalae ne wisi-nâna ŋinde iveta ruruŋa ŋalae ŋinde panzi. ");
INSERT INTO xsi_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Aku Maro Ŋalae iporo mine tu, “Muŋgani naŋa apatea tamâta ŋinde tu ma imo Koipu Ŋalae, aku naŋa warakâŋgu ao i imo Saion tuu kulu, naneŋgu tuu sapâŋa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Aku Koipu Ŋalae ŋinde nde iporo tu, “Ŋine naŋa ma atula Yova Kindeni kawa ŋgua pwataki. Muŋga Yova Kindeni ipai naŋa mine tu, ‘Noko nde naŋa natuŋgu. Kala ŋine naŋa amo noko tama.’” ");
INSERT INTO xsi_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Aku Yova Kindeni kala ipai naŋa mine tu, “‘Ambo noko ma kuno pa naŋa, ande naŋa ma tamâta rârâni nenzi tâno alano, aku noko ma pwai poe pa nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Noko ma pwai poe kaika ndo panzi tamâta rârâni, aku ma kupunzi pwapwataki, itogo tamâta ipu kulo pwapwataki kala punu-punu nâ ikeno.’” Yova Kindeni iporo ŋgua mine pa naŋa koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Mine nde miki koipu ŋalaŋala rârâni kaloŋo naneŋgu ŋgua ŋine sondo, aku kapakatona warakami nemi vetâŋa sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Miki ma kamege ŋana Yova Kindeni kâ, aku kapanea i ŋa tava ilomi ruruŋa. ");
INSERT INTO xsi_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Miki ma kapare tukumi ndue lâ i kie tini laiti. Tia ma i wisi nâna walele nâ pami, aku ma izavarumi ku naomi tia lâ. Aŋga tamâta ea kinzi uru silâ pa Yova Kindeni tu ma ikea ŋananzi, ande i ne nzâmbe ara ikeno panzi. ");
INSERT INTO xsi_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Yova Kindeni, naneŋgu kazâŋa tamâta sipâŋga kambwaŋenzi rârâ ŋinde! Kinzi simandi ŋana siveta kenzi sakamao pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Kinzi siporo ŋgua ŋana naŋa kâ mine tu, “Maro Kindeni ma ivila i tia.” ");
INSERT INTO xsi_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Taitu nenzi ŋgua ŋinde nde mao tia. Yova Kindeni, noko kutogo naneŋgu maramuŋa mine. Noko ma kumuŋga pana ŋana apole paraŋa kâ. Noko nâ uru kupu tini kaika pa iloŋgu kaloŋgu, ŋana naŋa akura tu amandi kaika kâ. ");
INSERT INTO xsi_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Naŋa uru asarâwa pa Yova Kindeni tu ivila naŋa. Aku i imo tamwata ne tuu sapâŋa kulu ku ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Yova Kindeni uru ikea ŋanana ikura mbo mbo. Mine nde lâ zo ŋana naŋa akeno kenoŋa nia, ande naŋa uru akeno utu lâ lee mbwale pwataki, ŋineŋga amandi sânda kilo. ");
INSERT INTO xsi_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Kinzi kazâŋa tamâta kambwaŋenzi tamâta-tamâta siŋge naŋa mbwaliu lâ, taitu naŋa ŋandai aruru ŋananzi ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yova Kindeni, kumandi ŋga! Naneŋgu Maro Kindeni, kumâ kuvilana! Noko uru kupunzi naneŋgu kazâŋa tamâta rârâni pâta lâ, kala nenzi kaika ŋana sipole naŋa kâ ande ikeno panzi tia. ");
INSERT INTO xsi_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yova Kindeni, noko simbo nâ uru kuvilanzi ne tamâta ŋana sipole paraŋa kâ. Noko uru kuveta kie ara nâ panzi tamâta ŋinde sipono muli pano. ");
INSERT INTO xsi_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","O Maro Kindeni, noko uru pwea ŋanana. Mine nde kupaloŋo pa naneŋgu noŋa! Muŋga noko pwai naŋa piti lâ kazâŋa ilo. Kala ŋine naŋa ano pano tu kuo ne wisi-wisi imâ pana ku kutambira taŋa pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Aŋga miki tamâta ŋai, miki ma kayaula naŋa ŋâŋgu ikura zo ŋapia kilo, a? Miki ma ilomi koŋa pa ŋgua kaa kaa wa kapono muli pa mâsi laŋeŋa wa ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Miki kalomi ŋgere sondo ŋga; Yova Kindeni nde ipateanzi tamâta pinde pa i tamwata, kinzi ŋinde uru sipono muli pa i. Mine nde lâ zo ndia naŋa ano papa i, ande i uru ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ambo miki wisimi nâna, ande kapakatona sondo ŋga. Tia ma kaveta kiesaka. Lâ zo ndia miki kakeno nemi kenoŋa nia, ande ara ŋana miki ma kalomi ŋgere sondo, aku kawami buu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Ara ŋana miki ma kao patarawâŋa sondo nâ ilâ pa Yova Kindeni, aku kao nemi kalo-tawana ilâ mao papa i nâ. ");
INSERT INTO xsi_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Tamâta rârâ uru ilonzi pa mbaliŋa nâ, kala sikai noŋa mine tu, “Ea ikura tu ivilama kamo ara kilo, a? O, Yova Kindeni, kalo sukâŋa ŋanama!” ");
INSERT INTO xsi_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Lâ zo ŋana kâpwa ipâŋga maria lâ tâno ilo, ande kinzi tamâta ŋinde uru sindeka. Taitu muŋgani noko kuo ndekâŋa ŋalae tina lâ naŋa iloŋgu, aku ndekâŋa ŋine ipole nenzi ndekâŋa kaa ŋinde ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Yova Kindeni, noko simbo nâ uru pwatona naŋa kala amo ara nâ. Naŋa aruru ŋana sâ toŋge tia. Mine nde lâ zo ŋana naŋa alâ akeno naneŋgu kenoŋa nia, ande naŋa uru akeno walele ku akeno utu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Yova Kindeni, kupaloŋo pa naneŋgu noŋa. Naŋa iloŋgu malia ndo; mine nde kutambira taŋa pa naneŋgu tiŋa. ");
INSERT INTO xsi_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Naneŋgu Koipu Ŋalae, naneŋgu Maro Kindeni noko, naŋa ano pano tu kuvilana, aku kupaloŋo pa naneŋgu sarawâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yova Kindeni, naŋa uru amâ pano ikura mboyo mboyo, aku noko kupaloŋo pa naneŋgu noŋa. Naneŋgu noŋa uru imâ pano itogo naneŋgu patarawâŋa mwasina. Naŋa akai noŋa pano lâ, ŋineŋga ao tiniŋgu pa noko tu kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Maro Kindeni, noko ŋandai kundeka ŋana vetâŋa potomule ŋga. Mine nde kinzi tamâta sakamao sikura tu simo noko tini laiti, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Tamâta ea kinzi uru sipasuka warakanzi tininzi, kinzi ŋinde sikura tu simandi noko nao, ande tia. Noko tini pwâka ndo ŋananzi kiesaka tamwatanzi. ");
INSERT INTO xsi_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Noko kuzavarunzi kinzi laŋeŋa tamwatanzi, aku noko pwai kazâŋa ŋalae tina panzi tamâta ea uru sikai laŋeŋa wa sipunzi tamâta pâta simâte wa. ");
INSERT INTO xsi_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Taitu noko tini mwasa ndo pa naŋa ikura zo rârâni. Mine kala naŋa akura tu amâ pano lâ noko ne luma sapâŋa, aku apare tukuŋgu pano awâŋgi awawano. ");
INSERT INTO xsi_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yova Kindeni, kinzi kazâŋa tamâta situ siyaula naŋa. Mine nde naŋa ano pano tu kugagati iloŋgu kaloŋgu, ŋana naŋa ma aveta ikura noko ne pateâŋa mine. Kutula noko ne nzâla sondo ŋinde pa naŋa, ŋana naŋa ma apono muli sondo pano. ");
INSERT INTO xsi_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Naneŋgu kazâŋa tamâta nenzi ŋgua rârâni nde sondo tia ndo. Kinzi ilonzi ndo tu ma sizavarunzi tamâta. Kinzi kawanzi nde itogo mateŋa tamâta nenzi kuru mwasina, kawa maa nâ ikeno, ŋana tu kinzi uru siporo ŋgua mona-mona palaŋeŋa rârâ ŋana siyaulanzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Maro Kindeni, naŋa iloŋgu tu noko ma kuonzi tamâta ŋinde lâ ŋgua nia, ŋineŋga kupare nia panzi. Naŋa iloŋgu tu nenzi ilo-kalo potomule ŋinde ma iyaula warakanzi. Kinzi uru taŋanzi kaika pa noko, aku siveta kiesaka rârâ ŋinde. Mine nde naŋa iloŋgu tu noko ma kusokinzi silâ simo malawae ndo ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Aŋga tamâta ea uru simâ pa noko tu ma pwea ŋananzi, ande kinzi ŋinde rârâni ma sindeka. Kinzi ma wisinzi ara, aku ma siwâŋgi wâŋgiŋa ndekâŋa kâ. Naŋa ano pano tu pwatonanzi sondo, kinzi ŋinde ilonzi ndo keno pano. Noko uru kuveta kie ara ndo panzi; mine kala kinzi sindeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Yova Kindeni, noko uru kuveta kie ara ndo panzi tamâta ea sipono muli pa noko ne ŋgua. Noko ne wisi-wisi ŋinde nde itogo tamâta ŋinde nenzi maramuŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Yova Kindeni, noko ma wisi nâna ku kumbita naŋa ndimo! Mao nâ, noko wisi nâna, taitu naŋa ano pano tu kupare nia pa naŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yova Kindeni, naneŋgu kaika nde ikâwa ilâ lâ. Mine nde kalo sukâŋa ŋanana! Naŋa tiniŋgu ndoni pââsââ lâ, aku iloŋgu tu noko ma kuveta tiniŋgu ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Naŋa iloŋgu nde malia ndo. Andeta Yova Kindeni, noko ma kupaloŋo pa naneŋgu noŋa ku kuvilana lâ zo ndia, a? ");
INSERT INTO xsi_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yova Kindeni, kulele nao pana ku kuvilana ŋga! Noko ilo ndo keno pa naŋa ikura zo rârâni. Mine nde naŋa ano pano tu kutiŋgi mateŋa piti pana. ");
INSERT INTO xsi_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Tiambo kinzi mateŋa tamâta sikura tu kalonzi ŋgere ŋana noko kâ, tiya? Tia ndo. Lâ mateŋa nianzi, tamâta toŋge ikura tu ipanea noko ŋa, ande tia. Mine kala ano pano tu kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Naŋa amo ata nâ lee waloŋgu ndoni marumbu lâ. Naŋa matâŋgu sulu indu indue isusulua naneŋgu kenoŋa nia ikura mbo mbo. Mine nde naŋa kuluŋgu kulânda nde lââ sakoa lâ. ");
INSERT INTO xsi_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Naneŋgu kazâŋa tamâta nde siveta kenzi sakamao pa naŋa. Mine kala naŋa amo atata nâ. Naŋa matâŋgu poa lâ, kala akura tu amora nia sondo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Ayo, miki tamâta sakamao, miki kakâwa kalâ! Yova Kindeni iloŋo naneŋgu tiŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Naŋa asarâwa pa Yova Kindeni tu ma kalo sukâŋa ŋanana, aku i ilo ara ŋana naneŋgu noŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Yova Kindeni ma ipolenzi naneŋgu kazâŋa tamâta rârâni, aku kinzi ma siruru ku ma mainzi ŋalae. I ma iŋaranzi walele nâ, kala kinzi ma sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Yova Kindeni, naneŋgu Maro Kindeni noko, naŋa amâ pa noko ku ano pano tu pwea ŋanana. Kuvilana, aku pwai naŋa piti lâ kinzi tamâta uru sitaŋgula naŋa ŋinde mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Tia ma kinzi sikai naŋa alâ pa nia bilimu, ŋineŋga ma sizavaru naŋa ndo lâ, itogo mbwâmbwa saka “leve” uru iveta panzi tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","4","Yova Kindeni, naneŋgu Maro Kindeni noko, ambo naneŋgu soki tâ ikeno pana, ambo naŋa muŋga aveta keŋgu sakamao pa tamâta toŋge tâku, akai laŋeŋa pa niŋgu-nambwe toŋge tâku, aveta vetâŋa soki kaa nâ pa naneŋgu kazâŋa tamâta toŋge tâ; ");
INSERT INTO xsi_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ambo mine, ande ara ŋana kinzi kazâŋa tamâta ma sitaŋgula naŋa lee sikaina kaika lâ. Ara ŋana kinzi ma kenzi nâ sipale naŋa sizavaruna ndo lâ, aku ara ŋana ma sipile karaeŋgu ikeno kaa nâ lâ tâno kulu. Andeta naŋa ŋandai aveta vetâŋa mine ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yova Kindeni, naŋa iloŋgu tu noko ma kumandi sânda ku pwai nâna panzi naneŋgu kazâŋa tamâta. Kumandi ku pwai kazâŋa panzi tamâta ŋinde uru wisinzi nâna ŋalae tina pa naŋa. Maro Kindeni, noko kuporo kaika lâ tu tamâta ma siveta vetâŋa sondo ndo panzi tininzi pinde. Mine kala naŋa ano pano tu kupagagati tamwata ku kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Noko uru kusaŋona koipu ŋalae ne saŋonâŋa nia lâ samba lawea. Naŋa iloŋgu tu noko ma kugonanzi tamâta rârâni simâ taitu ku kuonzi simandi noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yova Kindeni, noko uru kumandi lâ ŋgua nia ku kulea sondo pa tamâta rârâni nenzi vetâŋa. Noko kusama tu naŋa aveta vetâŋa soki toŋge tia. Mine nde naŋa ano pano tu kutula ŋinde pwataki panzi naneŋgu kazâŋa tamâta lâ ŋgua nia. ");
INSERT INTO xsi_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Maro Kindeni, noko ne vetâŋa rârâni nde sondo ndo. Noko kusama tamâta rârâni nenzi ilo-kalo wa ilonzi wa marumbu lâ. Mine kala naŋa ano pano tu kutoto kinzi tamâta sakamao nenzi vetâŋa potomule ŋinde, aku kuveta kie ara panzi tamâta ea uru sipaveta kuku vetâŋa ara. ");
INSERT INTO xsi_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Naŋa kaloŋgu tawana tu Maro Kindeni i nde naneŋgu maramuŋa. I uru ivilanzi tamâta ea sipaloŋo pa i kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Maro Kindeni ne pareŋa-nia nde sondo ndo. Ikura zo rârâni i uru wisi nâna panzi kiesaka tamwatanzi. ");
INSERT INTO xsi_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Ambo kinzi tamâta sakamao mine ma sipalele ilonzi kalonzi tia, ande Maro Kindeni ma iwawa ne pila kazâŋa kâ. I itike ne temba kala iluku lâ ŋana paraŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","I inziu ne silâwa ku mata ruru ndo, ŋineŋga ikai ne temba kâki ku irae temba ŋana ipanenzi tamâta sakamao kâ. ");
INSERT INTO xsi_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Opopo, kinzi tamâta sakamao uru kalonzi ŋgere ŋana vetâŋa kiesaka kie-kie nâ. Kinzi simo sitogo vetâŋa potomule rârâni tamanzi, aku kawanzi laŋeŋa nâ ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Kinzi sisale tâno wewe ŋalae ŋana sikainzi tamâta kâ. Taitu kinzi warakanzi patanzi sindue silâ wewe ŋinde ilo. ");
INSERT INTO xsi_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Mine kala nenzi vetâŋa potomule nde iyaula kinzi warakanzi lâ. Kinzi mbaunzi nâ iveta nâna pa warakanzi. ");
INSERT INTO xsi_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Mao nâ, Yova Kindeni ne vetâŋa rârâni nde sondo ndo. Mine nde naŋa kawâŋgu ndaŋge papa i. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pa Yova Kindeni âta Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Yova Kindeni, maka nema Maro Ŋalae noko, kinzi tamâta rârâni lâ tâno ndoni simora noko ne walo ŋalae ipâŋga nia yo panzi. Kinzi simo sipanea noko ŋa, aku nenzi paneâŋa ŋinde ikâki ilâ lee ipâŋga samba lawea. ");
INSERT INTO xsi_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Aku kinzi lâlu kiri-kiri kala uru sipanea noko ŋa mine nâ, aku nenzi paneâŋa ŋinde nde itogo ŋgumbi kaika ŋana ipono noko ne kazâŋa tamâta nzalanzi. ");
INSERT INTO xsi_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Yova Kindeni, naŋa matâŋgu kâki alea pa nia maa, niani ndaina noko nia ndoyo kupulia ipâŋga lâ. Naŋa amora nzimona tavanzi pitu rârâni ŋinde noko muŋga kuonzi simo nianzi nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Naŋa amora kelekele ŋinde lâ, ŋineŋga akasoŋano lâ warakâŋgu iloŋgu mine tu, “Maka tamâta nde sâ kala noko uru ilo ŋanama. Maka nde kelekele kaa nâ; mine nde mana mana ŋga noko uru pwatonama, a?” ");
INSERT INTO xsi_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Andeta noko muŋgani kuo maka kamo kelekele rârâni kulunzi, kala maka kamo noko simbo nâ kalo. Noko kuveta maka kakai koipu, aku kusuka maka ŋama kâki lâ. ");
INSERT INTO xsi_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Noko kupatea maka ŋana kakai poe pa kelekele rârâni noko muŋga kupulianzi sipâŋga ŋinde. Noko kuonzi kelekele rârâni simo maka tamâta kaloma marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Mao nâ, noko pwainzi lama wa, bulmakao wa, simbi rârâni simo dugu ilo wa, ");
INSERT INTO xsi_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","sii rârâni wa, iŋa rârâni wa, aku kuonzi kelekele rârâni ŋinde simo maka kaloma. ");
INSERT INTO xsi_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yova Kindeni, maka nema Maro Ŋalae noko, kinzi tamâta rârâni lâ tâno ndoni simora noko ne walo ŋalae ipâŋga nia yo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Yova Kindeni, naŋa iloŋgu ndo tu aporo ndaŋge ŋalae pa noko. Naŋa ma aporo atula ŋgua panzi tamâta ŋana vetâŋa ŋalaŋala rârâni noko muŋga kuveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Naŋa kaloŋgu ŋgere ŋana noko ne vetâŋa ŋinde kâ, kala awâŋgi wâŋgiŋa tava ndekâŋa ŋalae. Yova Kindeni âta Tamwata, naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pa noko, ");
INSERT INTO xsi_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","ŋana tu noko kumandi lâ naneŋgu kazâŋa tamâta naonzi, kala sikâwa silâ. Kinzi patanzi sindue aku sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Lâ zo ŋana noko kulea pa naneŋgu kazâŋa tamâta nenzi vetâŋa lâ ŋgua nia, ande noko kuveta vetâŋa ŋinde sondo ndo. Mine nde noko kutula pwataki lâ kinzi naonzi tu naneŋgu soki toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Noko kupa ŋgua lâ ŋana kupare nia panzi tinikoa ŋgu. Noko kuzavarunzi tamâta sakamao ŋinde kala naonzi tia lâ, aku tamâta toŋge ma kalo ŋgere kilo ŋana kinzi kâ, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Noko kuzavarunzi kazâŋa tamâta kala naonzi tia ndo lâ. Mine nde kinzi ma sikura tu sikai kazâŋa pa maka kilo, ande tia. Yova Kindeni, noko kuzavaru nenzi lawea ŋalaŋala marumbu lâ, aku tamâta rârâni nde kalonzi kapa ŋananzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Aŋga Yova Kindeni nde imo koipu ŋalae ikura zo zo. I iluku lâ ŋana ipare nia panzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","I uru ikai poe sondo ndo panzi tamâta ŋgu ndoni. Aku i ne mâsi ŋana ipare nia panzi tamâta kâ nde ipakura kuku nenzi vetâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Tamâta pinde nenzi walo nde ŋalae koŋa tia, kala nenzi kazâŋa tamâta uru siveta kenzi sakamao panzi. Taitu Yova Kindeni uru ikea ŋananzi tamâta ŋinde. Lâ zo ndia malia ipâŋga panzi, ande kinzi uru silâ simuna i tini laiti, kala simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Yova Kindeni, ambo tamâta toŋge itu imâ pano, ande naŋa asama tu noko ma kupu muli pa tamâta ŋinde tia ndo. Mine kala tamâta ea sisama noko kilala sondo, ande kinzi ŋinde rârâni ma kalonzi tawana noko mao nâ. ");
INSERT INTO xsi_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Miki kaloŋo ŋga; Yova Kindeni imo koipu ŋalae lâ Saion lawea! Miki ma kawâŋgi kapanea i kasuka ŋa kâki, aku katapâri panzi tamâta ŋgu ndoni ŋana vetâŋa ŋalaŋala i muŋga iveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Yova Kindeni ilo ŋananzi tamâta ŋinde uru sikai nâna koa tia nâ, aku ipono taŋa ŋana nenzi tiŋa kâ, ande tia. I uru ipare nia pa tamâta ea iveta soki panzi. ");
INSERT INTO xsi_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Yova Kindeni, kalo sukâŋa ŋanana! Kumora ŋga; naneŋgu kazâŋa tamâta siveta kenzi sakamao ndo pa naŋa. Naŋa ano pano tu pwaina piti lâ mateŋa ne nimbu ilo. ");
INSERT INTO xsi_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Ambo noko ma kuvila naŋa mine, ande naŋa ma akura tu amandi Jerusalem lawea ne ŋgumbi nzâla kawa, ku ma apaneano atapâri panzi tamâta ŋana vetâŋa rârâni noko muŋga kuveta pa naŋa ŋinde. Naŋa ma amo andeka nâ, ŋana tu noko pwaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Muŋga kinzi tinikoa tamâta sisale tâno wewe ŋalae ŋana sitatau maka kâ. Andeta kinzi warakanzi patanzi sindue silâ wewe ŋinde ilo. Kinzi sio nimbu ŋana sikale maka kaika kâ, andeta nimbu ŋinde nde ikai kinzi warakanzi. ");
INSERT INTO xsi_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Kinzi tamâta sakamao ŋinde siveta kelekele ŋana iyaula maka, andeta kelekele ŋinde ipalele ku izavaru kinzi warakanzi. Mine nde Yova Kindeni kilala ipâŋga nia yo tu i uru ipare nia sondo panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Tamâta ea sipu mulinzi pa Maro Kindeni, ande kinzi tamâta sakamao ŋinde rârâni nde soka nzâla ŋinde ilâ pa mateŋa nianzi nâ. ");
INSERT INTO xsi_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Andeta Maro Kindeni ma kalo kapa ŋana isuka kinzi sugorai tamwatanzi, ande ma tia. Kinzi tamâta ŋinde uru sio tininzi pa Maro Kindeni tu ma ivilanzi, aku nenzi mâsi ŋinde ma ilâ kaa nâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yova Kindeni, kumâ ŋga! Noko ma kusâu panzi tamâta tu taŋanzi kaika pano ndimo. Naŋa iloŋgu tu noko ma kuonzi tinikoa tamâta simandi noko nao lâ ŋgua nia, ŋineŋga ma kupa ŋgua ŋana pareŋa-nia kâ panzi. ");
INSERT INTO xsi_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Yova Kindeni, naŋa iloŋgu tu noko ma kuveta ruruŋa ŋalae panzi. Kutula pwataki panzi tu kinzi nde tamâta nâ, kala simo noko kalo. ");
INSERT INTO xsi_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Yova Kindeni, ŋana sâ kâ ŋga noko kumo malawae ndo ŋana naŋa kâ, a? Naŋa amo sakamao ndo; ŋana sâ kâ ŋga noko kupavea ŋanana, a? ");
INSERT INTO xsi_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Kinzi tamâta sakamao uru sipasuka warakanzi tininzi ku siveta kenzi sakamao panzi sugorai tamwatanzi. Naŋa iloŋgu tu kinzi ma patanzi sindue wewe ilo, wewe ndainani kinzi warakanzi muŋga sisale ŋana sikainzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Kinzi tamâta sakamao uru kawanzi pakâe siporo ŋana ilo-kalo potomule ŋinde ikeno ilonzi kalonzi. Kinzi ilonzi yosi ŋana mbaliŋa kie-kie. Kinzi uru siporo ŋgua sakamao pa Yova Kindeni wa sipu mulinzi papa wa. ");
INSERT INTO xsi_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Kinzi tamâta sakamao situ kinzi warakanzi nâ nde tamâta ŋalaŋala. Kinzi tininzi pwâka ndo ŋana Maro Kindeni kâ. Kinzi situ i nde maro kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Mbaliŋa kie-kie ikeno panzi, kala simo sindeka nâ. Kinzi sizizâla ndo ŋana Maro Kindeni ne mâsi ŋana ipare nia panzi tamâta kâ. Kinzi uru siveta “a” pa nenzi kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Kinzi siporo lâ ilonzi mine tu, “Naŋa amandi kaika nâ; sâ toŋge ikura tu ipono nzalâŋgu, ande tia. Malia toŋge ma ikura tu isânda naŋa kuluŋgu, ande tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Ikura zo rârâni kinzi uru siporo ŋgua sakamao wa ŋgua laŋeŋa wa ŋgua ŋana itu ruruŋa panzi tamâta pinde wa. Kinzi ilonzi ndo ŋana siporo wisi-nâna ne ŋgua sakamao panzi tamâta pinde. ");
INSERT INTO xsi_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Kinzi tamâta sakamao uru simuna simo lawea ilo, ku sio ŋananzi tamâta ara ŋana sipunzi pâta simâte kâ. Kinzi simuna ku sititike sio ŋananzi tamâta pinde ŋana sizavarunzi kâ, kinzi ŋinde nenzi walo ŋalae koŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Kinzi simo simuna nâ, itogo mbwâmbwa saka “leve” uru imuna lâ ne ŋgânza ilo mine. Kinzi sio ŋananzi sugorai tamwatanzi lee sikainzi kaika lâ nenzi nimbu. Ŋineŋga silaenzi silâ. ");
INSERT INTO xsi_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Kinzi tamâta sakamao nenzi kaika nde ŋalae tina. Mine kala kinzi sitawanzi sugorai tamwatanzi ndue ndo lâ ku sipolenzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Kinzi uru siporo lâ ilonzi mine tu, “Maro Kindeni kalo kapa ŋana naneŋgu vetâŋa kâ. Ipono tamwata nao lâ, kala ikura tu imora sâ toŋge tia.” ");
INSERT INTO xsi_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Mao nâ, kinzi tamâta sakamao uru siveta vetâŋa mine. Mine nde Yova Kindeni, kumandi ŋga! Maro Kindeni, kuzavarunzi tamâta ŋinde ndo lâ. Kalo ŋgere ŋananzi tamâta ara ŋinde uru simo sikai nâna. ");
INSERT INTO xsi_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Kinzi tamâta sakamao sipu mulinzi pa noko lâ, aku uru siporo lâ warakanzi ilonzi tu, “Maro Kindeni ma ipare nia pa naŋa ŋana naneŋgu vetâŋa soki kâ, ande ma tia.” Kinzi nenzi ilo-kalo ŋinde nde ara tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Mao nâ, noko uru kumora kinzi tamâta sakamao nenzi vetâŋa. Noko kusama lâ ŋana nâna wa malia ŋinde kinzi tamâta ara uru sikai, aku ikura zo zo noko ilo ara nâ ŋana kuvilanzi. Ikura zo rârâni noko uru kuvilanzi sugorai tamwatanzi wa kinzi tamâta nenzi kaika tia wa, kinzi ŋinde sipauwo warakanzi lâ noko mbau ilo. ");
INSERT INTO xsi_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Mine nde naŋa ano pano tu kutawa kinzi kiesaka tamwatanzi nenzi kaika ndue ndo lâ, aku kupare nia panzi ŋana nenzi vetâŋa soki rârâni lee, ikura lâ zo ndia kinzi ma sipile nenzi vetâŋa soki ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yova Kindeni imo koipu ŋalae, ma imo mine ku imo nâ. I ma isokinzi tinikoa tamâta lâ i ne tâno, aku ma naonzi tia ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Yova Kindeni, noko ma kupaloŋo panzi tamâta uru sikai nâna ŋinde nenzi noŋa, aku ma kupu tini kaika pa ilonzi kalonzi. ");
INSERT INTO xsi_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Noko ma kupaloŋo pa kinzi sugorai tamwatanzi nenzi tiŋa, aku ma kupaloŋo pa kinzi tamâta uru sikai malia ŋinde nenzi tiŋa tona. Noko ma kuveta kie sondo nâ panzi. Mine kala kinzi tâno tamâta ma sikura tu siveta ruruŋa panzi kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Naŋa kaloŋgu tawana tu Yova Kindeni ma ikatona naŋa. Mine nde noko tamâta ŋai, ŋana sâ kâ ŋga noko kupai naŋa mine tu, “Pwâwa kulâ pa tuu, itogo sii iruru ku ikâwa ilâ walele nâ mine. ");
INSERT INTO xsi_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Pwâwa kulâ, ŋana tu kinzi tamâta sakamao simuna simo nia kondoma. Kinzi sitike nenzi temba lâ, ku sisaŋa silâwa sirae silea pa kinzi tamâta ara tu ma sipanenzi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Kinzi tamâta sakamao sizavaru vetâŋa ara rârâni. Mine nde tamâta ara ma ikura tu iveta sâ toŋge tia.” Ayo, noko tamâta ŋai, ŋana sâ kâ ŋga noko kuporo ŋgua kapa-kapa mine pa naŋa, a? ");
INSERT INTO xsi_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Ŋana tu Yova Kindeni imo tamwata ne luma sapâŋa ilo. I imo ikai koipu lâ samba ilo, aku i mata uru ilea panzi tamâta rârâni. Isama ŋana vetâŋa rârâni siveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yova Kindeni uru ilea pa tamâta rârâni nenzi vetâŋa, kinzi saka wa ara wa. I tini pwâka ndo ŋananzi tamâta ŋinde sivaligi i tamwata ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","I ma isupwa yââ tava mira ndimoro imbe indue lâ kinzi tamâta sakamao kulunzi, itogo karâzi mine. Aku i ma isupwa lawea kaika ilâ panzi ŋana iveta kelekele rârâni ŋgâla-ŋgâla lâ. Mao nâ, Yova Kindeni ipatea tu vetâŋa mine ma ipâŋga panzi tamâta sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yova Kindeni tamwata uru iveta vetâŋa sondo nâ, aku i tini mwasa pa vetâŋa arara rârâni. Kinzi tamâta ara ma simo kuku i. ");
INSERT INTO xsi_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Yova Kindeni, kuvila maka ŋga! Tamâta ara toŋge imo ŋai, ande tia. Muŋga tamâta pinde sipono muli pa noko, andeta kala ŋine kinzi ŋinde nde naonzi tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Tamâta rârâni uru sikai laŋeŋa panzi tininzi pinde. Kinzi uru siporo ŋgua kaŋa mona-mona panzi ŋana silaŋenzi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Yova Kindeni, naŋa ano pano tu kupono kinzi tamâta uru siporo ŋgua mona-mona kaa kaa ŋinde kawanzi, kinzi ŋinde simo nâ sipasuka warakanzi tininzi. ");
INSERT INTO xsi_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Kinzi tamâta ŋinde uru siporo mine tu, “Kelekele ndia maka iloma papa, ande maka kawama nâ kaporo ŋgua, aku kakai kelekele ŋinde rârâni. Maka warakama nema ŋgua uru isukama; mine kala maka ma kapaloŋo pa tamâta toŋge tia.” ");
INSERT INTO xsi_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Andeta Yova Kindeni iporo mine tu, “Kinzi tamâta sakamao uru siveta malia panzi sugorai tamwatanzi, aŋga kinzi tamâta ara uru sikai malia wa nâna wa, kala simo sita nâ. Mine kala ŋine nâ naŋa ma alâ panzi. Kinzi uru sino pa naŋa tu ma navilanzi, kala naŋa ma akea ŋananzi.” ");
INSERT INTO xsi_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Mao nâ, Yova Kindeni uru iveta ikura ne ŋgua pâŋa rârâni. I ne ŋgua rârâni nde ara ndo, itogo mira “silva” kinzi simomo lâ yââ ilo, kala zuzuli ndo. ");
INSERT INTO xsi_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Yova Kindeni, kinzi tamâta sakamao simo sikura nia ndoni, aku tamâta rârâni sindeka nâ ŋana vetâŋa potomule kâ. Mine nde maka kano pano tu pwatonama sondo. Pwea ŋanama ikura zo rârâni, ŋana kinzi tamâta sakamao ma sikura tu sizavaru maka tia. ");
INSERT INTO xsi_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Yova Kindeni, noko ma kalo ŋgere kilo ŋana naŋa lâ zo ndia, a? Tiambo noko ma kalo kapa ŋana naŋa kâ ikura zo rârâni, a? Noko ma kupavea ŋanana ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Naŋa iloŋgu malia ndo, aku ikura kari wa mbo wa naŋa kaloŋgu sukâŋa nâ. Naŋa ma amo mine ikura zo ŋapia kilo, a? Naneŋgu kazâŋa tamâta ma sipole naŋa ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Yova Kindeni, naneŋgu Maro Kindeni, naŋa ano pano tu kupaloŋo pana ku kusâu pa naneŋgu noŋa. Noko ne walo kaika kulua naŋa kilo. Tia ma naŋa alâ pa mateŋa nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Naŋa tiniŋgu pwâka tu naneŋgu kazâŋa tamâta ma siporo ŋgua ŋana naŋa kâ mine tu, “Maka kapole i marumbu lâ”. Ambo kinzi ma simora naŋa patana andue, ande ma sindeka nâ, aku naŋa tiniŋgu pwâka tu vetâŋa mine ma ipâŋga pana. ");
INSERT INTO xsi_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Andeta naŋa kaloŋgu tawana tu noko ne tini-mwasa uru imâ pana ikura zo rârâni. Naŋa ma andeka nâ, ŋana tu noko ma pwai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Mao nâ, naŋa ma awâŋgi apanea Yova Kindeni ŋa, ŋana tu i uru iveta kie ara ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Kinzi tamâta kapa-kapa uru siporo lâ warakanzi ilonzi mine tu, “Maro Kindeni nde maro kaa nâ”. Kinzi tamâta ŋinde nde tamâta sakamao ndo. Kinzi uru siveta vetâŋa potomule nâ. Tamâta toŋge uru iveta vetâŋa ara nâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yova Kindeni imo samba ilo, aku i mata ndue ilea pa kinzi tamâta. I itu isama mine: tiambo tamâta pinde simo tava ilo-kalo ara, tiya? Tiambo tamâta pinde ilonzi tu ma simo kuku i, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Andeta tia. Kinzi rârâni sipile nzâla ara marumbu lâ. Kinzi rârâni nenzi vetâŋa nde kie taituni, kinzi nde tamâta sakamao ndo. Tamâta toŋge uru iveta vetâŋa ara nâ, ande tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Yova Kindeni ne ŋgua ikeno mine tu, “Tiambo kinzi tamâta ŋinde nenzi ilo-kalo tia tâ. Kinzi rârâni uru siveta vetâŋa sakamao. Kinzi sizavarunzi naneŋgu tamâta, itogo sika kâpwa mine, aku uru sikai noŋa pa naŋa tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Andeta kinzi tamâta ŋinde ma siruru pâta kanaŋo, ŋana tu Maro Kindeni uru imo kunzi tamâta ea sipono muli pa i ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Kinzi sugorai tamwatanzi ilonzi patea tu ma siveta vetâŋa ara pinde, andeta kinzi tamâta sakamao uru sipono nzalanzi. Taitu Yova Kindeni uru ikea ŋananzi sugorai tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Naŋa iloŋgu tu Yova Kindeni ma isupwa kinda Isrel ŋgu nenda Yautâŋa Tamâta iyoka pa Saion Tuu indue imâ. Mao nâ, Yova Kindeni tamwata ma iyoka pa Saion imâ, ku ma ivilanzi Yakopu ne vâsa ŋgu tu simo ara kilo. Aku lâ zo ŋinde kinzi ma sindeka ŋalae tina. ");
INSERT INTO xsi_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Yova Kindeni, tamâta mana ikura tu iyoka ilâ noko ne luma sapâŋa ilo. Tamâta mana ikura tu imo Saion Tuu kulu, noko tamwata ne tuu sapâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Maro Kindeni iporo ŋgua taulo imâ mine tu, “Ambo tamâta toŋge ipaveta kuku Yova Kindeni ne ŋgua tukuŋa rârâni, ambo iveta vetâŋa ara ikura zo zo, ambo iporo ŋgua mao nâ, ande tamâta ŋinde ma ikura tu ilâ luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Ambo tamâta toŋge tini pwâka tu isowe ŋgua laŋeŋa ilâ i tini pinde tininzi, ambo i tini pwâka tu iveta soki panzi ninambwe wukale, ambo i tini pwâka tu itu tamâta laginanzi, ande tamâta ŋinde ma ikura tu ilâ luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Ambo tamâta toŋge uru tini piti ndo ŋananzi tamâta ŋinde Yova Kindeni ipu muli panzi lâ, aku i uru isuka kinzi tamâta uru sipono muli pa Yova Kindeni ŋinde ŋanzi kâki, ande tamâta ŋinde ma ikura tu ilâ luma sapâŋa ilo. Lâ zo ndia tamâta mine ipa ŋgua ŋana iveta vetâŋa toŋge, ande i uru iveta vetâŋani ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","I uru isâu panzi i tini pinde tu sikai mbumbu saŋe i, aku lâ zo ndia kinzi situ ŋana, ande i ikai mbumbu kambwaŋe ndainani nâ saŋenzi. Ambo tamâta pinde situ sipu i tini, kala siko lâ mbumbu ŋana imandi ŋgua nia ku iporo ŋgua laŋeŋa ŋananzi tamâta pinde muŋga siveta vetâŋa soki tia, ande i ma iveta mine tia ndo. Tamâta ea sipaveta kuku vetâŋa arara ŋinde, ande kinzi ŋinde ma sikura tu simandi kaika ikura zo rârâni.” ");
INSERT INTO xsi_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Maro Kindeni, naŋa ano pano tu pwatonana. Naŋa amâ pa noko tu ma pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Naŋa aporo pa Yova Kindeni tu, “Naneŋgu Maro Ŋalae, kelekele arara ndia ikeno pa naŋa, ande ŋinde rârâni iyoka noko nâ mbau ilo imâ pana.” ");
INSERT INTO xsi_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Maro Kindeni ne tamâta kinzi nde tamâta ara ndo, aku naŋa andeka nâ tu amo kunzi. ");
INSERT INTO xsi_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Aŋga tamâta pinde uru sipalilu silâ ŋana siwâŋgi panzi maro laŋeŋa kâ. Kinzi ŋinde uru sisânda malia rârâ kulu. Naŋa ma alâ taitu kunzi tamâta ŋinde ŋana aveta patarawâŋa kâ, ande ma tia. Aku naŋa ma awâŋgi apatu kinzi nenzi maro ŋanzi, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Noko simbo nâ kumo naneŋgu Maro Kindeni, aku noko uru kuveta kie ara ndo pa naŋa. Noko uru kutula nzâla pana, aku naneŋgu via nde ikeno noko mbau ilo. ");
INSERT INTO xsi_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Noko kuwae kelekele ara ndo pa naŋa. Mao nâ, kelekele ŋinde nde ara pâta lâ. ");
INSERT INTO xsi_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Naŋa apanea Yova Kindeni ŋa, ŋana tu i uru ikai poe sondo pana. Ikura mbo mbo i io ilo-kalo ara nâ lâ iloŋgu kaloŋgu ŋana ipananana. ");
INSERT INTO xsi_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ikura zo rârâni naŋa apasama tu Yova Kindeni imo tiniŋgu laiti. I imo naŋa tiniŋgu pa wia kâ ŋana ivilana. Mine nde sâ toŋge ikura tu iveta ruruŋa pa naŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Mine kala naŋa iloŋgu ndeka ndo, aku kawâŋgu ndaŋge papa i. I uru ikatona naŋa sondo ndo, kala amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Ŋana tu Yova Kindeni, noko ma kusâu pa mateŋa tu ikai naŋa kaika kâ, ande ma tia. Naŋa uru apono muli sondo pa noko, aku noko ma kupile karaeŋgu isâmbu lâ kuru ilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Noko tamwata ma kutula nzâla pa naŋa ŋana akai via mao kâ. Noko kumo kuna, kala ndekâŋa nde ipipi ndo lâ iloŋgu. Mao nâ, noko kuveta naŋa iloŋgu ndeka ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Yova Kindeni, kupaloŋo pa naneŋgu sarawâŋa. Naŋa amandi noko nao atogo tamâta sondo ndo. Naŋa kawâŋgu laŋeŋa tia ndo. Mine nde naŋa iloŋgu tu noko ma kupaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Naŋa iloŋgu tu noko ma kulea sondo pa naneŋgu vetâŋa, aku kutula pwataki lâ ŋgua nia tu naneŋgu soki toŋge ikeno pana tia. ");
INSERT INTO xsi_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Ilo-kalo ndia ikeno naŋa iloŋgu kaloŋgu, ande ŋinde noko kusama lâ. Ambo noko ma kumâ pa naŋa lâ mbo ŋana pwai samâŋa pana, ande noko ma kumora tu ilo-kalo potomule ikeno pa naŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Tamâta pinde uru siporo ŋgua sakamao, andeta naŋa ŋandai aveta mine ŋga. Naŋa apono muli sondo pa noko kawa ŋgua, aku apu muliŋgu pa kinzi nzanzare tamwatanzi nenzi vetâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ikura zo zo naŋa uru ayoka noko ne nzâla, aku naŋa keŋgu nde kaika nâ. ");
INSERT INTO xsi_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Maro Kindeni, noko uru kupaloŋo pa naneŋgu noŋa. Mine kala ŋine naŋa ano pano. Kutambira taŋa sondo pa naŋa kawâŋgu ŋgua, aku kuveta pana ikura naneŋgu noŋa ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Naŋa iloŋgu tu noko ma kutula ne tini-mwasa ŋalae ŋinde kilala pwataki. Noko uru kuvilanzi ne tamâta, kinzi ŋinde simâ pano tu simuna ŋananzi nenzi kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Naŋa ano pano tu pwatonana, itogo tamâta ikatona i tamwata mata mine. Kuvea naŋa sondo, itogo tatareko tina igogonzi natu simo mbani kalo mine. ");
INSERT INTO xsi_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Kuvea naŋa ŋananzi tamâta sakamao, kinzi ŋinde situ sizavaru naŋa ndo lâ. Kinzi sikai kazâŋa ŋalae pa naŋa, kala simâ siŋge naŋa mbwaliu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Kinzi kalonzi sukâŋa ŋananzi tamâta pinde tia ndo. Kinzi uru kawanzi pakâe sipasuka warakanzi nâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Kinzi sitaŋgula naŋa lee, kala ŋine simâ siŋge naŋa mbwaliu lâ, aku sio ŋana sipu naŋa pâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Kinzi sitogo mbwâmbwa saka “leve” putole ipu kala imuna io ŋana simbi tu ma ipu ika kâ. ");
INSERT INTO xsi_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yova Kindeni, kumâ kupara kunzi naneŋgu kazâŋa tamâta, aku kupunzi ndue! Pwai ne pila kazâŋa kâ, aku kumâ pwai naŋa piti lâ kinzi tamâta sakamao mbaunzi ilo! ");
INSERT INTO xsi_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Yova Kindeni, kusuŋa mbau ndue ku pwaina piti lâ kinzi mbaunzi ilo. Kinzi simo sitogo mbaliŋa warakanzi lâ tâno ŋine kulu. Naŋa iloŋgu tu noko ma pwatu nenzi vetâŋa sakamao kulu panzi, ikura noko muŋga kupatea tu ma kuveta mine, aku kuveta nâna mine nâ panzi tamâta ŋinde natunzi-timbunzi tona. ");
INSERT INTO xsi_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Aŋga naŋa aveta vetâŋa soki tia, aku muli ŋga naŋa ma amandi noko nao. Lâ zo ŋana naŋa ma amandi sânda kâ, ande naŋa ma amo kuno, aku ŋinde ma iveta iloŋgu ndeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Yova Kindeni, naŋa iloŋgu ndo ikeno pa noko! Noko uru walo kaika kulana. ");
INSERT INTO xsi_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yova Kindeni uru ikea ŋana naŋa kâ. I imo itogo mira ŋalae naŋa uru amuna tini mwasina, aku imo naneŋgu Yautâŋa Tamwata. Naŋa amo i tini laiti, kala kinzi kazâŋa tamâta sikura tu sizavaru naŋa, ande tia. Maro Kindeni ikea ŋanana, aku imo itogo naneŋgu maramuŋa mine. Mao nâ, i ne kaika ikatona naŋa lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Naneŋgu paneâŋa ilâ pa Yova Kindeni! Naŋa asarâwa papa i tu ivilana, kala ikaina piti lâ kinzi kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Muŋga mateŋa nao sondo imâ pana, aku zavaruŋa ipole naŋa itogo tâi ilaŋa ipole tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Lâ zo ŋinde mateŋa ne wâlo ilita naŋa kaika lâ, aku mateŋa imâ ipâŋga tiniŋgu laiti. ");
INSERT INTO xsi_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Mine nde naŋa kaloŋgu loko ŋalae tina, kala asarâwa pa Yova Kindeni. Naŋa ano pa naneŋgu Maro Kindeni tu ma isukana. I imo ne luma sapâŋa ilo, aku iloŋo naneŋgu sarawâŋa. I ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Ŋineŋga Maro Kindeni ivila naŋa mine; i wisi nâna kala iveta tâno ririŋo ŋalae ku iveta tuu duvi iyoka yâti taulo. ");
INSERT INTO xsi_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ŋineŋga mâsi ŋalaŋala kie-kie ipâŋga tâno kulu. Mundo tava yââ ŋalae wa mira ndimoro nde ipâŋga tuu ŋalaŋala ilonzi ku iyâti imâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","I tamwata ipu nia maa pwataki ku indue imâ, aku take-take mâmâŋga ikeno i kie kalo. ");
INSERT INTO xsi_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","I isaŋona kelekele via kâ toŋge kumbu, aku ŋinde ikai i ilou walele nâ imâ. Lawea ikai i pââ pââ imâ, itogo sii uru ilou walele mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","I ipatura tini lâ kondoma ŋalae, aku ipavea lâ take-take ŋalae toŋge ilo, io mâmâŋga ku ipâŋga togo karâzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Loloa salaga-salaga imuŋga papa imâ, aŋga mira “ais” tava yââ mela-mela nde ipu take-take mâmâŋga ŋinde pwataki ku imbe ndue. ");
INSERT INTO xsi_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Ŋineŋga Yova Kindeni isarâwa kaika lâ samba tini, itogo mbamba ipu mwasina. Yova Kindeni âta Tamwata kawa ne sarawâŋa ipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","I irae ne temba ku silâwa nâ ipanenzi ne kazâŋa tamâta, kala sikâwa silâ. Mao nâ, i loloa nâ ipanenzi, aku sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yova Kindeni, lâ zo ŋinde noko wisi nâna ŋalae tina kala kumbitanzi ne kazâŋa tamâta. Noko kumbana koroani ku kuveta tâno ikeno tâi kalo ŋinde ipâŋga mâsa-mâsa lâ, aku tâno ne duvi ipâŋga nia yo. ");
INSERT INTO xsi_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Lâ zo ŋinde naŋa atogo tamâta imbwatuke lâ tâi geza-geza ilo, andeta Maro Kindeni, inani uru imo samba ilo, ande isuŋa mbau ndue isaŋa naŋa kaika ku itapana akâki amâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Mao nâ, itapa naŋa piti lâ kinzi kazâŋa tamâta kaika ŋinde mbaunzi ilo, kinzi ŋinde uru wisinzi nâna pa naŋa. Kinzi nenzi kaika ipole naneŋgu kaika ndo lâ, andeta Maro Kindeni ivilana. ");
INSERT INTO xsi_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Zo sakamao nde isânda naŋa kuluŋgu lâ, aku lâ zoni ndaina kinzi simâ tu sipara kuna. Andeta naŋa amarerea Yova Kindeni, kala amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","I ikatona naŋa lâ. Mine nde naŋa aŋgeŋge ŋana kazâŋa ŋinde kâ. I ilo ara ndo pa naŋa, aku ŋana duvi ŋinde kâ i ivilana. ");
INSERT INTO xsi_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Naŋa uru apaveta kuku vetâŋa rârâni Yova Kindeni ilo papa ŋinde. Mine kala i uru iveta kie ara nâ pana. Naŋa aveta vetâŋa soki toŋge tia, aku ŋana duvi ŋinde kâ Yova Kindeni io ne wisi-wisi imâ pa naŋa itogo naneŋgu vetâŋa ara ne kulu mine. ");
INSERT INTO xsi_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Naŋa apono muli sondo pa Yova Kindeni ne ŋgua tukuŋa. Naŋa ŋandai aveta vetâŋa soki ŋana apu muliŋgu pa naneŋgu Maro Kindeni ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Naŋa iloŋgu pa i ne ŋgua tukuŋa rârâni, aku naŋa ŋandai alaŋa apole i ne tukuŋa ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","I isama tu naŋa aveta vetâŋa soki toŋge tia, aku naŋa apu muliŋgu pa kiesaka ne vetâŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Naŋa iloŋgu ikeno mbâra-mbâra lâ i nao. Mine nde iveta kie ara pa naŋa, itogo naneŋgu vetâŋa ara ne kulu mine. ");
INSERT INTO xsi_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yova Kindeni, tamâta ea sipono muli mao pa noko, ande noko uru kuveta kie ara nâ panzi, ikura muŋga kupa ŋgua tu ma kuveta mine. Tamâta ea sipaveta kuku vetâŋa ara, ande noko uru kuveta vetâŋa sondo ndo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Tamâta ea simo ilonzi mbâra-mbâra lâ noko nao, ande noko uru kuo ne wisi-wisi ilâ ŋalae tina panzi. Aŋga tamâta ea sipaveta kuku laŋeŋa ne mâsi kie-kie, ande noko uru pwatu nenzi vetâŋa ŋinde kulu taulo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Noko uru kuvilanzi tamâta ea sipatawa warakanzi tininzi. Aŋga tamâta ea sipasuka warakanzi tininzi, ande noko kutawanzi ndue ndo. ");
INSERT INTO xsi_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yova Kindeni, noko tamwata nde naneŋgu sinâla. Naneŋgu Maro Kindeni uru isinala kondoma ŋine itura naŋa, kala kondoma ŋinde ikâwa ilâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Noko uru walo kaika kulua naŋa. Mine nde naŋa akura tu apolenzi naneŋgu kazâŋa tamâta. Naneŋgu Maro Kindeni uru ivilana. Mine nde naŋa akura tu alaŋa apole nenzi lawea ne ŋgumbi ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Maro Kindeni ne vetâŋa rârâni nde ara ku sondo ndo. Ambo i ma ipa ŋgua ŋana iveta vetâŋa toŋge, ande i ne ŋgua ŋinde nde mao kanaŋo. I imo itogo maramuŋa mine panzi tamâta rârâni simâ pa i tu ma ikea ŋananzi. ");
INSERT INTO xsi_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yova Kindeni simbo nâ nde maro mao. Kinda nenda Maro Kindeni i simbo nâ imo itogo mira ŋalae kinda tamuna tini. ");
INSERT INTO xsi_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Inani uru kaika ilua naŋa, aku lâ zo ndia naŋa atu ayoka nzâla, ande i uru ikatona naŋa sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","I iveta naŋa keŋgu kaika, itogo wiki kie mine. Lâ zo ndia naŋa ayoka nia tuu, ande isuka naŋa kala patana tia. ");
INSERT INTO xsi_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","I uru ipanana naŋa ŋana paraŋa ne mâsi kâ. Mine kala naŋa akura tu arae temba kaika ndo. ");
INSERT INTO xsi_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yova Kindeni, noko uru pwea ŋanana ku pwaina piti lâ kazâŋa ilo. Noko ne walo kaika ivila naŋa sondo lâ. Noko ne wisi-wisi iveta naŋa ŋâŋgu ipâŋga ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Noko uru pwatona naŋa nzalâŋgu. Mine nde kinzi kazâŋa tamâta ŋandai sikai naŋa kaika ŋga. Aku naŋa ŋandai patana lâ nia zuli-zuli ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Naŋa apalilu ataŋgulanzi naneŋgu kazâŋa tamâta lee akainzi kaika lâ. Naŋa apwarea tia lee ikura lâ zo naŋa ayaula kinzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Naŋa apunzi ndue ndo, kala sikura tu simandi kilo tia. Kinzi simâte lâ naŋa naoŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Noko tamwata walo kaika kulana ŋana apara kunzi naneŋgu kazâŋa tamâta. Noko tamwata kusuka naŋa, kala apolenzi lâ paraŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Noko kuvetanzi naneŋgu kazâŋa tamâta sikâwa sipalilu silâ. Naŋa azavarunzi tamâta uru wisinzi nâna pa naŋa ŋinde kala sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Kinzi sisarâwa pa tamâta toŋge tu ma imâ isukanzi, taitu tamâta toŋge isukanzi nde tia. Kinzi sino pa Yova Kindeni, andeta ipaloŋo pa nenzi noŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Naŋa azavarunzi ndo lâ, kala sipâŋga sitogo tâno gawura lawea itapala kala nao tia lâ mine. Naŋa apunzi kazâŋa tamâta ŋinde ndue lâ ku keŋgu nâ apalenzi, itogo tamâta kie nâ ipale nziŋa ikeno nzâla tini mine. ");
INSERT INTO xsi_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Yova Kindeni, kinzi taŋa-kaika tamwatanzi nde sikai kazâŋa pa naŋa lâ, andeta noko kusuka naŋa kala sipole naŋa tia. Noko kuo naŋa akai koipu panzi tinikoa ŋgu. Muŋga naŋa azizâla ŋananzi ŋgu pinde, andeta kala ŋine kinzi tamâtani ndaina nde simo kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Kinzi tamâta lâ lawea malawae nde siloŋo naŋa parinâŋgu kala sipono muli pa naneŋgu ŋgua. Kinzi simâ pa naŋa ku tininzi ruru sipare tukunzi ndue lâ keŋgu tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Kinzi ŋinde rârâni nenzi walo nde ikâwa ŋananzi. Kinzi siruru pâta ku sipile nenzi teŋgo kaika simâ pa naŋa ku siporo tu, “Noko ne kaika kala kupole maka.” ");
INSERT INTO xsi_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yova Kindeni imo via nâ! I itogo mira ŋalae naŋa uru amuna tini mwasina, aku naneŋgu paneâŋa ilâ pa i nâ. Maro Kindeni nde naneŋgu Yautâŋa Tamwata, aku naŋa ma apanea i asuka ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","I simbo nâ ivila naŋa kala apolenzi naneŋgu kazâŋa tamâta. I simbo nâ ionzi tinikoa ŋgu simo kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","I simbo nâ uru ivila naŋa. Mine nde naneŋgu kazâŋa tamâta sikura tu sipole naŋa nde tia. Mao nâ, Maro Kindeni, noko simbo nâ kuvila naŋa lâ paraŋa ilo kala apunzi naneŋgu kazâŋa tamâta ndue. Noko pwea ŋanana, kala kinzi nzanzare tamwatanzi sikura tu sipu naŋa pâta amâte, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Mine nde naŋa ma kawâŋgu ndaŋge pano lâ kinzi tinikoa ŋgu naonzi. Naŋa ma awâŋgi apaneano asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yova Kindeni ipatea naŋa Daviti tu akai koipu, aku i uru ivila naŋa kala apole paraŋa. I tini mwasa ndo papa ne pateâŋa tamâta naŋa, aku i ma tini mwasa mine nâ panzi naneŋgu vâsa ŋinde ma sipâŋga muli-muli sikai niâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Nia maa uru itula Maro Kindeni kilala pwataki pa kinda tu i nde ara ku ara ndo. Kelekele rârâni simo âta ŋinde situla i ne vetâŋa ara kilala pwataki pa kinda. ");
INSERT INTO xsi_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kari kari itula Maro Kindeni kilala ŋinde pwataki, aŋga mbo mbo kala itula i kilala ndainani nâ pwataki kilo. ");
INSERT INTO xsi_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Mbo ŋga kari kawanzi tia. Mine nde kinzi ŋandai siporo ŋgua itogo kinda tamâta nenda ŋgua mine. Kinda takura tu taloŋo kaŋanzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Taitu nenzi sarawâŋa ilâ isala nia ndoni lâ tâno kulu, aku tamâta lâ lawea ndoni siloŋo nenzi ŋgua ŋinde. Maro Kindeni ipa luma toŋge lâ nia maa ŋana kari ma imo ilo, ");
INSERT INTO xsi_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","aku ikura mboyo mboyo kari uru ipile ne luma ŋinde ku iyâti imâ pa nia yo tava ndekâŋa. Mao nâ, kari ilo ara nâ ku iyâti imâ ŋana iveta ne wurâta ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Kari uru ipâŋga pa samba warika pa mbwera kâ, aku iparuse ilâ lee ilâ pa ŋgaŋe pinde. Aku kelekele toŋge ikura tu imuna ŋana kari mata ne nâna kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yova Kindeni ne ŋgua tukuŋa nde sondo ndo, aku tukuŋa ŋinde uru walo wasaseki ilua kinda. Ara ŋana kinda ma kalonda tawana Yova Kindeni ne ŋgua. I kawa ŋgua ŋinde uru ipanananzi tamâta, kinzi ŋinde nenzi ilo-kalo ŋalae koŋa tia. Mine kala nenzi ilo-kalo ipâŋga ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yova Kindeni ne tukuŋa nde ara ndo, aku tamâta ea sipono muli papa, ande kinzi ŋinde uru ilonzi ndeka nâ. Yova Kindeni ne ŋgua tukuŋa nde sondo ndo, aku itula ilo-kalo ara ndo pa kinda. ");
INSERT INTO xsi_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Ara ŋana kinzi tamâta ma sipanea Yova Kindeni sisuka i ŋa kâki ikura zo zo. Yova Kindeni ne pateâŋa rârâni nde sondo ndo, aku i ne vetâŋa rârâni nde mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Kinzi tamâta uru ilonzi pa mira ara “gol”. Taitu Yova Kindeni ne ŋgua tukuŋa nde kelekele ara ndo, ipole mira “gol”. Aku Yova Kindeni ne tukuŋa i kaŋa mona-mona ndo, ipole sipa siŋi ara ne mona-mona. ");
INSERT INTO xsi_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Noko ne ŋgua tukuŋa ŋinde ipanana noko ne wurâta tamâta naŋa sondo ndo. Naŋa apono muli pa noko ne tukuŋa, aku ŋana duvi ŋinde kâ noko uru kuveta kie ara ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Andeta naŋa kaloŋgu loko ŋana ŋine kâ; tamâta toŋge ikura tu isama i tamwata ne vetâŋa soki rârâni kilala, ande tia. Yova Kindeni, zo pinde naŋa aveta vetâŋa soki pinde, andeta azizâla ŋana. Mine nde naŋa ano pano tu kuzavaru vetâŋa soki ŋinde ne muso piti lâ iloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Andeta zo pinde naŋa taŋâŋgu kaika, kala aveta vetâŋa pinde naŋa nanayoni asama kilala tu ŋinde nde vetâŋa soki. Naŋa ano pano tu kupono ne wurâta tamâta naŋa nzalâŋgu, ŋana naŋa ma akura tu aveta vetâŋa soki ŋinde tia. Naŋa tiniŋgu pwâka tu vetâŋa soki mine ma ikai poe pa naŋa. Ambo noko ma kusuka naŋa ŋana apu muliŋgu pa vetâŋa soki kâ, ande naŋa ma amo iloŋgu mbâra-mbâra lâ noko nao, aku kiesaka ne vetâŋa sakamao ma ikeno pa naŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Yova Kindeni, noko kutogo mira ŋalae naŋa uru amuna tini mwasina, aku noko kumo naneŋgu Yautâŋa Tamwata. Mine nde naŋa iloŋgu tu naneŋgu ŋgua ndoni wa ilo-kalo ndoni ma imo itogo kelekele ara ndo lâ noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Koipu ŋalae, lâ zo ndia malia ipâŋga pano ku iveta noko kalo loko, ande maka kano pa Yova Kindeni tu ma ivilano. Maka kano tu kinda timbunda Yakopu ne Maro Kindeni ma ikea ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Maka kano tu i ma io ne pavilâŋa iyoka ne luma sapâŋa ikeno Saion tuu kulu ŋinde imâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Maka kano tu i ma kalo ŋgere ŋana noko ne patarawâŋa rârâni, aku ma ilo ara ŋana noko ne patarawâŋa ŋinde simomo lâ yââ. ");
INSERT INTO xsi_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Kelekele ndia noko ilo papa, ande maka kano pa Maro Kindeni tu i ma kelekele ŋinde rârâni ilano. Aku wurâta wa vetâŋa ndia noko ilo tu kuveta, ande maka kano tu i ma isukano ŋana kuveta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Mine kala lâ zo ŋana noko ma kupole paraŋa kâ, ande maka ma kandeka, aku ma kapanea nenda Maro Kindeni kasuka i ŋa kâki. Maka kano pa Yova Kindeni tu ma ipaloŋo pa noko ne noŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Kala ŋine naŋa asama tu Yova Kindeni uru isuka ne koipu ŋalae, koipu ŋinde i tamwata ipatea lâ. I imo ne lawea sapâŋa lâ samba ilo, aku uru ipaloŋo pa koipu ŋalae ne noŋa. I io i tamwata ne walo kaika imâ ŋana isuka koipu ŋalae kâ. Mine nde koipu ŋalae ikura tu ipole paraŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Tamâta pinde kalonzi tawana tu nenzi kareta kaika ma ivilanzi lâ paraŋa ilo, aŋga pinde nde kalonzi tawana tu nenzi “hosi” ma sivilanzi. Taitu maka nde kaloma tawana tu nema Maro Yova Kindeni ne walo kaika ŋinde nâ ma ivilama lâ paraŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Tamâta ea kalonzi tawana tu nenzi kareta wa “hosi” ma ivilanzi, ande kinzi ŋinde ma patanzi. Aŋga maka nde ma gagatima kamandi kaika. ");
INSERT INTO xsi_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yova Kindeni, maka kano pano tu kuvila koipu ŋalae tu ma ipole paraŋa kâ. Maka nema sarawâŋa imâ pano. Kupaloŋo pa maka ŋga! ");
INSERT INTO xsi_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Yova Kindeni, koipu ŋalae indeka nâ, ŋana tu noko walo kaika kulua i lâ. Noko kuvila i ŋana ipole paraŋa kâ. Mine nde i ilo ndeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Kelekele ŋinde i ilo papa, ande ŋinde noko kulua lâ. Noko kupaloŋo pa i ne noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Noko kumâ papa i ku kelekele arara kulua lâ. Noko kuo loki-loki “gol” lâ i kulu ŋana itula pwataki tu i imo koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Muŋga i ino pano tu ma via luandondo kulua, aku noko kusâu papa kala kuseŋge mbwera rârâ lâ zo ŋine i imo via. ");
INSERT INTO xsi_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Noko kuvila i, aku ŋana duvi ŋinde kâ i ŋa ipâŋga ŋalae ndo. Noko walo kaika kulua i, kala imo koipu ŋalae ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Ikura zo rârâni noko uru kuveta kie ara ndo papa i. Noko kumo kuku i, aku ŋinde iveta i ilo ndeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Yova Kindeni Walo Tamwata, koipu ŋalae ne kalo-tawana ikeno pa noko. Aku Yova Kindeni, noko ilo ndo ikeno papa i ikura zo zo. Mine kala koipu ŋalae ma imandi kaika mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Noko mbau nâ ma pwainzi ne kazâŋa tamâta rârâni kaika lâ. Kinzi tamâta ŋinde ilonzi sakamao pano, andeta noko ma kusaŋa kinzi rârâni kaika lâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Muli ŋga, lâ zo ŋinde noko ma kumâ kupâŋga, ande noko ma kuzavarunzi ne kazâŋa tamâta ndo lâ, itogo yââ ŋalae kana kelekele ku nao tia lâ mine. Mao nâ, Yova Kindeni, noko ma wisi nâna ŋalae tina, aku ma kupunzi ndue ndo. Aku yââ ma kananzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Noko ma kupunzi ne kazâŋa tamâta ŋinde natunzi rârâni simâte, aku nenzi vâsa muli-muli rârâni kala ma naonzi tia mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Ambo kinzi situ simâ taitu ku sipa ŋgua ŋana siveta soki pano, ande kinzi ma sikura tu siveta sâ toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Noko ma kurae temba ku silâwa nâ kupanenzi, kala ma sipalilu sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Mao nâ, Yova Kindeni imo tava ne walo kaika. Maka ma kawâŋgi kapanea noko ŋa ŋana noko ne vetâŋa kaika ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Naneŋgu Maro, naneŋgu Maro, ŋana sâ kâ ŋga noko kupile naŋa, a? Ŋana sâ kâ ŋga noko tini pwâka tu kuvilana, a? Ŋana sâ kâ ŋga noko kuloŋo naneŋgu tiŋa tia, a? ");
INSERT INTO xsi_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Maro Kindeni, naŋa asarâwa pano lâ kari, taitu noko kupaloŋo pa naneŋgu noŋa tia. Naŋa asarâwa pano lâ mbo, andeta naneŋgu nâna keno mo ŋai yo. ");
INSERT INTO xsi_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Andeta Maro Kindeni, noko nde Sapâŋa Tamwata. Noko uru kusaŋona koipu ŋalae ne saŋonâŋa nia, aku maka Isrel ŋgu kapaneano. ");
INSERT INTO xsi_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Muŋga maka timbuma kalonzi tawanano. Kinzi nenzi kalo-tawana uru ikeno pano, kala noko pwainzi piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Kinzi sikai noŋa sisarâwa pano, kala noko pwea ŋananzi. Kinzi kalonzi tawana tu noko ma kuvilanzi, aku nenzi kalo-tawana ŋinde ilâ kaa nâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Aŋga naŋa nde atogo tâno ne mwâta-mwâta kaa nâ. Naŋa ŋandai tamâta mao ŋga. Kinzi tamâta rârâni ilonzi sakamao pa naŋa ku sipu mulinzi pana. ");
INSERT INTO xsi_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Tamâta rârâ simora naŋa, aku kinzi ŋinde rârâni siporo ŋgua pavaligiŋa pa naŋa wa siveta “a” pana wa sirurua kulunzi pana wa. ");
INSERT INTO xsi_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Kinzi siporo tu, “Noko kalo tawana Yova Kindeni. Mine nde mana mana ŋga ivila noko tia, a? Ambo Yova Kindeni tini mwasa pa noko, ande ŋana sâ kâ ŋga i ŋandai ikaino piti lâ kazâŋa ilo, a?” ");
INSERT INTO xsi_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Andeta Maro Kindeni, nia ndoyo, lâ zo ŋinde nana ipaguguana apâŋga lâ, ande nokoni pwea ŋanana kala apâŋga amo ara nâ. Aku lâ zo muŋgâŋa ŋinde naŋa amo suu tini yo, ande noko tamwata pwatonana, kala amo ara mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Nanayoni, lâ zo ŋinde nana ipaguguana, aku amo lee apâŋga lâ zo ŋine, ande naneŋgu kalo-tawana ikeno pa noko simbo nâ. Ikura zo rârâni naŋa amo viâŋgu lâ tâno kulu, ande noko kumo naneŋgu Maro Kindeni ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Kala ŋine malia isânda naŋa kuluŋgu lâ, aku tamâta toŋge imo ŋana ivila naŋa kâ, ande tia. Mine nde noko ma kupile naŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Kinzi kazâŋa tamâta rârâ siŋge naŋa lâ, sitogonzi bulmakao tamâne mine. Kinzi nenzi kaika nde ŋalae ndo, itogo bulmakao tamâne ŋgoi nenzi kaika mine. ");
INSERT INTO xsi_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Kinzi simandi ŋana sizavaru naŋa kâ, itogo mbwâmbwa saka “leve” isuŋa kawa kaika ku inzaŋa kawa ŋana ika simbi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Naneŋgu walo ndoni nde marumbu ndo lâ, itogo lââ imaliŋi lâ tâno kulu kala nao tia lâ. Naŋa tukâŋgu ne siŋgeŋa ndoni nde pââsââ lâ. Naŋa iloŋgu nde mbariri lâ, itogo lona ŋinde yââ kana kala ipâŋga itogo lââ mine. ");
INSERT INTO xsi_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Naŋa ŋandolâŋgu mâsa-mâsa ndo lâ, aku memelâŋgu nde ipasipa lâ kawâŋgu. Noko tamwata nde kupile naŋa kulâ lâ, kala laiti ŋana ma amâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kinzi tamâta sakamao simo siŋge naŋa, itogo mbwâmbwa siŋge ŋgoa ŋgoi mine. Kinzi niŋonzi nâ sisowe naŋa mbalauŋgu wa keŋgu wa. ");
INSERT INTO xsi_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Naŋa tukâŋgu ndoni ipâŋga nia yo lâ. Naneŋgu kazâŋa tamâta ŋinde matanzi silea pa naŋa, aku sindeka ŋana akai nâna mine. ");
INSERT INTO xsi_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Kinzi sipagui paguiŋa toŋge ŋana sipatea tu tamâta ea ma ikai naneŋgu pasawaŋa. Mine kala siwae naneŋgu pasawaŋa, aku sikai nenzi nenzi. ");
INSERT INTO xsi_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Mine nde Yova Kindeni, noko ma tini piti mine ŋana naŋa kâ ndimo! Naneŋgu Pavilâŋa Tamwata noko. Kumâ walele nâ kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Kinzi kazâŋa tamâta situ ma pila nâ sisowe naŋa amâte. Pwai naŋa piti ŋga! Kinzi sikaika sitogonzi mbwâmbwa mine. Pwatona naneŋgu via ara ŋine! ");
INSERT INTO xsi_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Kinzi situ sizavaru naŋa, itogo mbwâmbwa saka “leve” ika ŋgoa mine. Kinzi simo sitogonzi bulmakao ŋgoi situ kulunzi tando nâ ma sisowe naŋa, aku naŋa akura tu apavila warakâŋgu, ande tia. Pwai naŋa piti lâ kinzi mbaunzi ilo! ");
INSERT INTO xsi_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ŋineŋga naŋa ma atula ŋgua pwataki panzi niŋgu-nambwe ŋana mâsi ŋalaŋala noko muŋga kuveta ŋinde. Lâ zo ŋana kinzi sipasau tu siwâŋgi pano, ande naŋa ma alâ amo kunzi apaneano mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Naŋa ma aporo panzi mine tu, “Miki tamâta ŋine uru kapono muli pa Yova Kindeni, miki ma kapanea i nâ! Miki Yakopu ne vâsa ŋgu, miki ma kasuka i ŋa kâki! Miki Isrel ŋgu, miki ma kamege ŋana i kâ! ");
INSERT INTO xsi_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Ŋana tu i ŋandai tini pwâka ŋana kinzi sugorai tamwatanzi nenzi malia wa nâna wa, ande tia. I ŋandai uru ipu muli panzi ŋga. I uru ipaloŋo pa nenzi noŋa.” ");
INSERT INTO xsi_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Yova Kindeni, lâ zo ŋana noko ne tamâta ma sipasau ŋana siwâŋgi pano, ande naŋa ma apanea noko simbo nâ ŋa ŋana vetâŋa rârâni noko muŋga kuveta ŋinde. Naŋa ma ao patarawâŋa imâ pano lâ kinzi tamâta uru sipono muli pano ŋinde naonzi, ikura muŋga apa ŋgua tu ma aveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Yova Kindeni ma ivilanzi sugorai tamwatanzi, kala kinzi ma sika lee kapwanzi pupuro ndo. Aku tamâta ea kinzi uru silâ pa Yova Kindeni, ande kinzi ŋinde ma sipanea i ŋa. Naŋa iloŋgu tu Yova Kindeni ma ivetanzi simo ara nâ ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Kinzi tamâta ŋgu rârâni lâ tâno ndoni ma kalonzi ŋgere ŋana Yova Kindeni kâ, aku ma sipanea i sisuka ŋa kâki. Mao nâ, kinzi tamâta ŋgu ndoni ma sipalele ilonzi kalonzi ku ma sipare tukunzi ndue lâ i nao. ");
INSERT INTO xsi_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Ŋana tu Yova Kindeni imo koipu ŋalae, kala ikai Maro panzi tamâta ŋgu ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Tamâta pinde sipasuka warakanzi tininzi, andeta kinzi ŋinde rârâni ma sisama i kilala, ku ma sipare tukunzi ku siwâŋgi siwawa i. Kinzi tâno tamâta rârâni ma sipanea i ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Kinzi tamâta kala simo lâ zo ŋine, ande nenzi vâsa muli-muli ma siveta wurâta papa Yova Kindeni. Kinzi ma siloŋo Maro Ŋalae parina. ");
INSERT INTO xsi_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Kinzi tamâta ŋinde nde sipâŋga tâno kulu tia yo. Taitu lâ zo ŋana ma sipâŋga simo vianzi kâ, ande kinzi ma siloŋo pâri mine tu, “Muŋgani Maro Ŋalae tamwata ikainzi ne tamâta piti lâ kazâŋa ilo.” ");
INSERT INTO xsi_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Yova Kindeni nde imo naneŋgu katonâŋa tamâta. I ikatona naŋa itogo lama nenzi katonâŋa ikatonanzi lama mine. Mine nde naŋa aroto ŋana kelekele toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","I uru ikai naŋa alâ pa nia pinde unza ara keno, ŋana naŋa ma aka wa apwarea wa. Aku i uru ikai naŋa alâ pa lââ ara kala anu tona. ");
INSERT INTO xsi_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","I uru walo wasaseki ilua naŋa, aku ikaina alâ pa nzâla ara, ikura muŋga ipa ŋgua tu ma iveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yova Kindeni, ambo naŋa ma ayoka nia sakamao toŋge kondoma ŋalae itura ndo lâ, ande naŋa ma aruru ŋana sâ toŋge tia, ŋana tu noko kumo kuna. Naŋa asama tu noko uru kusaŋa katonâŋa ŋana lama kâ ne tukâla lâ mbau ilo. Mine nde naŋa wisiŋgu puu ndue, ŋana tu noko ma pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Noko kuveta kâŋa-nuŋa ŋalae pa naŋa lâ naneŋgu kazâŋa tamâta naonzi. Noko kupaliŋi samimi ara lâ kuluŋgu, ŋana itula pwataki tu noko ilo ara pana. Aku noko kuwuwu waini ara lâ naneŋgu kâmba ilo lee pipi ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Yova Kindeni, naŋa asama tu noko ne vetâŋa ara tava ne wisi-wisi nde ma ikeno pa naŋa ikura zo rârâni naŋa ma amo viâŋgu, aku naŋa ma amo ara mine lâ noko ne luma ilo ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Tâno ndoni ande Yova Kindeni nâ ne, aku kelekele rârâni ikeno tâno kulu ande i ne tona. Aku tamâta rârâni kala simo i ne tona. ");
INSERT INTO xsi_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Ŋana tu nia ndoyo Yova Kindeni isau tâno kâki tâi geza-geza kulu, aku iŋgunu tâno duvi imandi tâi ŋgini. ");
INSERT INTO xsi_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Tamâta mana ikura tu ikâki ilâ Yova Kindeni ne tuu kulu, aŋga tamâta mana ikura tu ilâ Yova Kindeni tamwata ne luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Ambo tamâta toŋge uru iŋgeŋge ŋana vetâŋa potomule kâ, ambo i imo tava ilo mbâra-mbâra, ambo i ipu muli pa mâsi ŋana iwâŋgi ipaneanzi maro laŋeŋa wa mâsi ŋana itoto ne ŋgua pâŋa wa, ande tamâta mine ikura tu ikâki Yova Kindeni ne tuu kulu ku ilâ i ne luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Maro Kindeni imo kinzi tamâta mine nenzi Pavilâŋa Tamâta, aku i ma iveta kie ara nâ panzi. I ma iporo ŋgua panzi mine tu, “Miki nemi soki toŋge ikeno pami tia”. ");
INSERT INTO xsi_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Kinzi tamâta mine uru silâ pa Maro Kindeni. Kinzi ilonzi tu silâ simandi kinda timbunda Yakopu ne Maro Kindeni nao. ");
INSERT INTO xsi_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Mine nde miki tamâta ndai, miki kalâ kakai luma sapâŋa siŋga ne nzâla kawa piti. Kalâ kaveta nzâla ŋinde kawa maa ŋalae, ŋana koipu ŋalae taituni ma ikura tu ilâ luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Koipu ŋalae taituni ŋinde, ande ea. Ŋinde nde Yova Kindeni tamwata. I ne walo kaika nde ŋalae ndo, aku ipole paraŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Miki tamâta ndai, miki kalâ kakai luma sapâŋa siŋga ne nzâla kawa piti. Kalâ kaveta nzâla ŋinde kawa maa ŋalae, ŋana koipu ŋalae taituni ma ikura tu ilâ luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Koipu ŋalae taituni ŋinde, ande ea. Ŋinde nde Yova Kindeni, i Walo Tamwata. I simbo nâ nde koipu ŋalae taituni. ");
INSERT INTO xsi_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Yova Kindeni, kala ŋine naŋa ano pano. ");
INSERT INTO xsi_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Naneŋgu Maro Kindeni, naŋa kaloŋgu tawana noko nâ. Mine nde naŋa ano pano tu kuvilana. Ambo noko ma kuvilana tia, ande naneŋgu kazâŋa tamâta ma siŋelea naŋa, aku ma maiŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Andeta naŋa asama tu tamâta ea kinzi sio nenzi kalo-tawana imâ pa noko, ande kinzi ŋinde ma sikai maŋeti ŋana nenzi kalo-tawana ŋinde kâ nde tia, ŋana tu noko ma kuvilanzi. Aŋga tamâta ea taŋanzi kaika pa noko koa tia nâ, kinzi ŋinde nâ ma mainzi, ŋana tu nenzi walo ma ivilanzi tia. ");
INSERT INTO xsi_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yova Kindeni, naŋa iloŋgu tu noko ma kupananana ŋana apaveta kuku noko ne vetâŋa ara, aku iloŋgu tu noko ma kutula ne nzâla pana. ");
INSERT INTO xsi_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Noko kumo naneŋgu Yautâŋa Tamwata Maro Kindeni. Mine nde kupananana ŋana apono muli pa vetâŋa ndia noko kupatea panzi ne tamâta tu ma siveta. Ikura zo zo naŋa uru ao tiniŋgu pa noko tu kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yova Kindeni, naŋa ano pano tu kalo ŋgere kilo ŋana ne wisi-wisi tava ne tini-mwasa, aku kuvila naŋa kilo. Siŋgani lâ, aku imâ lee ipâŋga lâ zo ŋine, ande noko uru kuo ne wisi-wisi wa tini-mwasa ŋinde ilâ panzi ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Yova Kindeni, nanayoni, lâ zo ŋinde naŋa limoa yo, ande naŋa aveta kiesaka wa vetâŋa potomule wa. Naŋa ano pano tu kuzavaru kiesaka ŋinde piti lâ tiniŋgu. Noko ne tini-mwasa wa wisi-wisi uru ikeno mine ku imo nâ. Mine nde naŋa ano pano tu pwatonana. ");
INSERT INTO xsi_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yova Kindeni i nde ara tamwata wa wisi-wisi warika wa. Mine nde i ipanananzi kinzi kiesaka tamwatanzi ŋana vetâŋa ndia i ilo tu kinzi ma sipaveta kuku. ");
INSERT INTO xsi_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","I uru ikai poe panzi tamâta ea sipatawa warakanzi tininzi. I ipanananzi ŋana ne nzâla ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Yova Kindeni ilo ndo keno panzi tamâta rârâni ŋinde sipaveta kuku i ne ŋgua pâŋa wa ne tukuŋa wa. Aku i uru iveta panzi ikura i muŋga ipa ŋgua tu ma iveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Yova Kindeni, kiesaka rârâ ŋinde nde ikeno tiniŋgu. Naŋa ano pano tu kuveta ikura ne ŋgua pâŋa mine, aku kuzavaru naneŋgu kiesaka rârâni piti. ");
INSERT INTO xsi_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Tamâta ea kinzi sipaveta kuku Yova Kindeni ne ŋgua, ande i ma itula nzâla ara panzi tamâta ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Kinzi ma simo ara ndo ikura zo zo, aku nenzi vâsa ma sikatona tâno ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Tamâta ea kinzi simege ŋana Yova Kindeni ku simo i kalo, ande i imo kinzi tamâta ŋinde rârâni ninzi-nambwe. I uru itula pwataki panzi tu i ne ŋgua pâŋa muŋgâŋa ŋinde nde mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Ikura zo zo naŋa uru ao tiniŋgu pa Yova Kindeni tu ivilana, aku ikai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Yova Kindeni, naŋa ano pano tu kupaloŋo pana ku kuo ne wisi-wisi imâ pana, ŋana tu naŋa simboŋgu nâ amo, aku kinzi kazâŋa tamâta siveta kenzi sakamao pana. ");
INSERT INTO xsi_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Naŋa kaloŋgu loko nâ. Naŋa ano pano tu kuveta wisiŋgu puu ndue, aku kutiŋgi malia kie-kie ŋine ilâ malawae ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Kinzi siveta kenzi sakamao pa naŋa, kala iloŋgu malia ndo. Naŋa ano pano tu kalo ŋgere ŋanana ku kuzavaru naneŋgu kiesaka piti lâ tiniŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Kumora ŋga; naneŋgu kazâŋa tamâta kambwaŋenzi ŋalae ŋinde, aku ilonzi sakamao ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Naŋa ano pano tu pwea ŋanana ku pwaina piti lâ kazâŋa ŋine ilo. Ambo noko ma kuvila naŋa ŋana apole paraŋa kâ, ande naŋa ma akai maŋeti tia. Naŋa amâ pano tu amuna noko tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Naŋa kaloŋgu tawana noko nâ, aku uru aveta vetâŋa ara wa aporo ŋgua mao wa. Mine nde naŋa ano pano tu pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Maro Kindeni, pwainzi ne ŋgu Isrel piti lâ malia kie-kie rârâni ŋine ilo! ");
INSERT INTO xsi_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Yova Kindeni, naŋa uru aveta vetâŋa ara, aku naneŋgu kalo-tawana nde imâ mao pa noko nâ. Mine nde ano pano tu kutula ŋgua pwataki lâ ŋgua nia mine tu naŋa nde tamâta sondo, naneŋgu soki toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yova Kindeni, naŋa iloŋgu tu noko ma pwai samâŋa pana ŋana naneŋgu vetâŋa rârâni. Aku naŋa iloŋgu tu noko ma kulea sondo pa iloŋgu wa naneŋgu ilo-kalo tona. ");
INSERT INTO xsi_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Ŋana tu noko ne tini-mwasa uru ikai poe pa naŋa ikura zo rârâni. Noko uru kuveta ikura ne ŋgua pâŋa rârâni, aku mâsi ŋinde itula nzâla pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Naŋa uru asaŋona kunzi laŋeŋa tamwatanzi tia ndo. Naŋa amo tiniŋgu piti ndo ŋananzi tamâta ŋinde uru siporo ŋgua kie toŋge, aŋga ilonzi ikeno piti. ");
INSERT INTO xsi_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Naŋa tiniŋgu pwâka ndo ŋana asaŋona kunzi kiesaka tamwatanzi, aku uru aŋgeŋge ŋananzi tamâta sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Yova Kindeni, lâ zo ŋana naŋa atu alâ pa noko ne patarawâŋa nia ŋana awâŋgi pano, ande naŋa uru apua mbauŋgu muŋga lâ ŋga, ŋana atula pwataki tu naneŋgu soki toŋge tia. Naŋa aveta mine lâ, ŋineŋga ayoka akarerea patarawâŋa nia kunzi noko ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Mao nâ, naŋa awâŋgi wâŋgiŋa ŋana atu ndaŋge pano, aku aporo atula ŋgua panzi tamâta ŋana vetâŋa arara rârâni noko muŋga kuveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yova Kindeni, naŋa iloŋgu ndo keno pa noko ne luma sapâŋa, niani ndaina noko kumo kala tamâta simora noko kilala ara ŋinde pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Mine nde lâ zo ŋana noko ma kuzavarunzi kinzi kiesaka tamwatanzi, ande naŋa ano pano tu noko ma kuzavaru naŋa tona ndimo. Lâ zo ŋana noko ma kupunzi pâta sipamateteu, ande noko ma kupu naŋa tona ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Ikura zo zo tamâta ŋinde siveta vetâŋa sakamao. Kinzi mbumbu silanzi tamâta pinde sipu tininzi ŋana siveta potomule panzi tamâta pinde. ");
INSERT INTO xsi_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Andeta naŋa warakâŋgu uru aveta vetâŋa ara. Mine nde naŋa ano pano tu kuo ne wisi-wisi imâ pana, aku pwaina piti lâ kazâŋa ilo! ");
INSERT INTO xsi_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Naŋa uru amandi kaika lâ nia papata, aku sâ toŋge ikura tu izavaruna, ande tia. Lâ zo ŋana noko ne tamâta ma sipasau ŋana siwâŋgi pano, ande naŋa ma amo kunzi apanea Yova Kindeni ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Yova Kindeni i nde naneŋgu sinâla, aku ina imo naneŋgu Pavilâŋa Tamwata tona. Mine nde naŋa ma aruru ŋana tamâta toŋge tia. Yova Kindeni taituni uru ikea ŋanana. Mine nde naŋa ma tiniŋgu ruru tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Lâ zo ndia kinzi tamâta sakamao simâ pana ŋana sipu naŋa pâta amâte kâ, ande naneŋgu kazâŋa tamâta ŋinde ma sisâsa ku ma patanzi sindue. ");
INSERT INTO xsi_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Ambo zugu tamâta ŋgu ŋalae ma simâ siŋge naŋa lâ, ande naŋa ma aruru ŋananzi tia ndo. Ambo kinzi situ sipara kuku naŋa, ande ara, naneŋgu kalo-tawana ma ikeno pa Yova Kindeni nâ. ");
INSERT INTO xsi_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Muŋga naŋa ano pa Yova Kindeni tu ma iveta vetâŋa taitu nâ pa naŋa, aku iloŋgu ndo tu i ma iveta vetâŋani ndaina. Naŋa iloŋgu tu i ma isâu pa naŋa, kala naŋa ma akura tu amo i ne luma ilo ikura zo rârâni amo viâŋgu. Ŋineŋga naŋa ma apanea i mine tu, “Noko nde ara tamwata!”, aku naŋa ma ano papa i tu ma ikai poe pana. ");
INSERT INTO xsi_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Lâ zo ndia malia kie-kie itu ipâŋga pa naŋa, ande i ma ikea ŋanana. I ma ivea naŋa lâ ne luma sapâŋa ilo, kala ma amo ara ndo. I ma io naŋa lâ mira ŋalae toŋge kulu, aku kazâŋa toŋge ma ikura tu isânda kuluŋgu, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Mine kala naŋa ma apolenzi naneŋgu kazâŋa tamâta ku apunzi ndue ndo, kinzi ŋinde muŋga simâ siŋge naŋa. Naŋa ma andeka asarâwa kawâŋgu ŋalae aveta patarawâŋa lâ Yova Kindeni ne luma sapâŋa ilo. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yova Kindeni, lâ zo ndia naŋa ma asarâwa pano, ande naŋa iloŋgu tu noko ma kalo sukâŋa ŋanana ku kupaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Muŋga noko kupai naŋa mine tu, “Kumâ pa naŋa ku kuwâŋgi pana”. Mine nde Yova Kindeni, naŋa ma amâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Taitu lâ zo ŋana naŋa amâ pano, ande noko ma kupavea tamwata ŋanana ndimo. Noko uru kuvila naŋa ikura zo zo, aku naŋa amo noko ne wurâta tamâta. Mine nde ano pano tu noko ma wisi nâna pana ku kusoki naŋa ndimo. O Maro Kindeni, naneŋgu Yautâŋa Tamwata noko. Mine nde naŋa ano pano tu noko ma kupile naŋa wa kupu muli pana ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Ambo naŋa nana wa mama wa ma sipu mulinzi pa naŋa, ande Yova Kindeni ma ikatonana. ");
INSERT INTO xsi_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Mine nde Yova Kindeni, kupanana naŋa ŋana vetâŋa ndia noko ilo tu naŋa ma apaveta kuku. Naneŋgu kazâŋa tamâta kambwaŋenzi rârâ simo. Mine nde ano pano tu kuo naŋa alâ pa nzâla ara. ");
INSERT INTO xsi_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Naneŋgu kazâŋa tamâta simandi ŋana siporo ŋgua laŋeŋa ku situ ruruŋa pana. Noko ma kupile naŋa kala alâ tamâta ŋinde mbaunzi ilo, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Naŋa kaloŋgu tawana mine: lâ zo ŋine naŋa amo viâŋgu, ande naŋa ma amora Yova Kindeni iveta kie ara panzi ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Mine kala miki tamâta, miki ma kalomi tawana, aku kao tinimi pa Yova Kindeni tu ma imâ ivilami. Kamandi kaika ŋga! Miki ma ilomi malia ndimo. Kalomi tawana kaika, aku kao tinimi pa Yova Kindeni tu ma imâ ivilami. ");
INSERT INTO xsi_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Yova Kindeni, naneŋgu pavilâŋa tamâta noko, naŋa asarâwa pano. Kupaloŋo pa naneŋgu tiŋa. Ambo noko ma kupono taŋa ŋana naneŋgu noŋa kâ, ande naŋa ma amâte. ");
INSERT INTO xsi_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Naŋa asarâwa pano tu kalo sukâŋa ŋanana ku kuvilana. Kupaloŋo pa naneŋgu noŋa ŋine. Naŋa naoŋgu pa noko ne luma sapâŋa asuka mbauŋgu kâki akai noŋa pano. ");
INSERT INTO xsi_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Mine nde Yova Kindeni, lâ zo ŋana noko ma kupare nia panzi tamâta sakamao, ande naŋa ano pano tu noko ma kupare nia mine pa naŋa tia. Kinzi tamâta sakamao ŋinde uru siveta kiesaka nâ. Kinzi uru siporo ŋgua kaŋa mona-mona panzi tininzi pinde, taitu ilo-kalo sakamao nâ nde ipipi lâ ilonzi kalonzi. ");
INSERT INTO xsi_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Naŋa iloŋgu tu noko ma pwatu tamâta ŋinde nenzi vetâŋa sakamao kulu itaulo panzi, ipakura kuku vetâŋa potomule kinzi muŋga siveta ŋinde. Kupare nia sakamao panzi, ikura nenzi kiesaka rârâni ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Kinzi ilonzi tu Yova Kindeni ne mâsi nde kaa nâ, aku ilonzi tu kelekele ŋinde i nia ndoyo ivetanzi sipâŋga lâ, ande ŋinde nde kelekele kaa nâ tona. Mine nde i ma izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Paneâŋa ilâ pa Yova Kindeni, ŋana tu i ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yova Kindeni i simbo nâ walo kaika ilua naŋa, aku ina imo naneŋgu maramuŋa. Mine nde naneŋgu kalo-tawana ikeno kaika papa i. Yova Kindeni uru ivila naŋa, aku io ndekâŋa ŋalae ikeno iloŋgu. Mine nde kawâŋgu ndaŋge awâŋgi wâŋgiŋa paneâŋa kâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yova Kindeni uru walo kaika ilanzi ne tamâta. Aku ikatona wa ivila koipu ŋalae tona, tamâta ŋinde i muŋga ipatea. ");
INSERT INTO xsi_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Mine nde Yova Kindeni, naŋa ano pano tu kuvilanzi ne tamâta rârâni, aku kuveta kie ara panzi tamâta ŋinde noko kupateanzi lâ tu simo noko ne ŋgu. Pwatonanzi sondo ndo, itogo lama nenzi katonâŋa tamâta uru ikatonanzi lama mine. Pwea ŋananzi ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Miki kelekele rârâni ŋinde kamo tava nemi kaika lâ samba ilo, miki kapanea Yova Kindeni ŋa. Kaporo katula pwataki tu i nde ara tamwata, aku i ne walo nde kaika ndo. ");
INSERT INTO xsi_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Kapanea Yova Kindeni katula pwataki tu i ŋa nde ŋalae ndo. Miki ma kawâŋgi ku kawawa i, ŋana tu i nde sapâŋa ku zuzuli tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yova Kindeni isuŋa kawa, aku sarawâŋa ŋinde ne nduŋeŋani nde ilâ ikura tâi ndoni. Maro Kindeni, i ara tamwata, ande isarâwa kawa ŋalae, itogo mbamba ipu mine, aku ne sarawâŋa ŋinde ne nduŋeŋani nde ilâ isala tâi kulu ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yova Kindeni ne sarawâŋa nde kaika ŋinde, aku ŋinde itula i kilala pwataki tu i ŋa nde ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yova Kindeni iporo, aku i kawa ŋgua ne sarawâŋa ŋinde ilâ imbware kâi matapuru ŋalaŋala imandi Lebanon tâno ŋinde nuki-nuki. ");
INSERT INTO xsi_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","I iruruanzi Lebanon tuu ŋalaŋala kala sisosoŋga itogo bulmakao natu uru isoŋga mine. Mao nâ, iveta Hermon tuu isoŋga kâki, itogo bulmakao natu isoŋga mine. ");
INSERT INTO xsi_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yova Kindeni ne sarawâŋa ilâ isinala nia itogo loloa salaga-salaga mine. ");
INSERT INTO xsi_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","I kawa ŋgua iveta nia bilimu ririŋo. I iveta Kedes nia bilimu imo ririŋo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yova Kindeni ne sarawâŋa ilâ itirianzi kâi ŋalaŋala, aku iveta kâi rârâni launzi yauru ndue. Aku kinzi tamâta rârâni simo i ne luma sapâŋa ilo ŋinde nde sisarâwa kawanzi ŋalae mine tu, “Paneâŋa ilâ pa Yova Kindeni!” ");
INSERT INTO xsi_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yova Kindeni imo koipu ŋalae, aku ikai poe pa tâi geza-geza ndoni. I imo koipu ŋalae, ma imo mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Aku inani uru walo kaika ilanzi ne tamâta tona. I uru iveta kie ara panzi, aku ivetanzi simo tava wisinzi pisi nâ. ");
INSERT INTO xsi_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Yova Kindeni, muŋga noko pwai naŋa piti lâ kazâŋa ilo. Noko pwea ŋanana; mine nde naneŋgu kazâŋa tamâta sikura tu sipu naŋa ndue ku siŋeleana, ande tia. Ŋana duvi ŋinde kâ naŋa apaneano asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yova Kindeni, naneŋgu Maro Kindeni noko, lâ zo ŋinde pukoŋa ikai naŋa kaika lâ, kala naŋa ano pano tu kusukana. Aku noko kuveta naŋa tiniŋgu ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yova Kindeni, lâ zo ŋinde naŋa apoko ŋalae, kala laiti ŋana amâte kâ. Andeta noko kutiŋgi mateŋa piti ŋanana. Ŋinde itogo naŋa ayoka lâ nzâla ŋinde ilâ pa mateŋa nianzi, andeta noko via kulua naŋa kilo. ");
INSERT INTO xsi_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Mine nde miki Yova Kindeni ne tamâta, naŋa iloŋgu tu miki ma kawâŋgi wâŋgiŋa paneâŋa kâ papa i. Kalomi ŋgere ŋana vetâŋa rârâni Yova Kindeni Sapâŋa Tamwata muŋga iveta ŋinde, aku kawami ndaŋge papa. ");
INSERT INTO xsi_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","I uru wisi nâna ikura zo mbwana-mbwana nâ, andeta i ilo pa kinda kala iveta kie ara nâ pa kinda ikura zo rârâni tamo viânda lâ tâno kulu. Mao nâ, zo pinde matânda sulu ma irere ndue lâ mbo, andeta ndekâŋa imâ ipâŋga pa kinda lâ mbwale pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Muŋga naŋa amo ara ndo, kala apandekâna aporo mine tu, “Kelekele toŋge ikura ŋana iyaula naŋa kâ, ande tia ndo”. ");
INSERT INTO xsi_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Yova Kindeni, lâ zo ŋinde noko kuveta kie ara ndo pa naŋa, aku kusukana amandi kaika, itogo luma mira mine. Naŋa iloŋgu patea tu naŋa amo ara nâ, andeta muli ŋga noko kupavea tamwata ŋanana, ande kala aruru ŋalae tina. ");
INSERT INTO xsi_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Maro Ŋalae, lâ zo ŋinde naŋa asarâwa pano. Naŋa ano kaika pa noko tu ma kuvilana. Naŋa aporo mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Ambo naŋa ma amâte, ande ŋinde ma ivila noko mâsi mana, a? Ambo naŋa ma alâ pa mateŋa nianzi, ande vetâŋa ara ndia ma ipâŋga, a? Tiambo mateŋa tamâta sikura tu sipanea noko ŋa, a? Tiambo kinzi sikura ŋana siporo situla pwataki tu noko uru kuveta kie ara panzi ikura zo zo, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Mine nde Yova Kindeni, kupaloŋo pa naŋa ku kalo sukâŋa ŋanana! Yova Kindeni, kumâ kuvilana ŋga!” ");
INSERT INTO xsi_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Lâ zo ŋinde, naŋa amo awâŋgi wâŋgiŋa kalo-kalo kâ. Andeta noko kusoki kalo-lokoni ŋinde piti lâ, ku kuveta naŋa awâŋgi tava ndekâŋa nâ. Muŋga naŋa amo atogo tamâta ika mâsa ku ita ŋana ninambwe toŋge ne mateŋa kâ. Andeta muli ŋga noko kulele naneŋgu tiŋa ŋinde ku kuveta iloŋgu ndeka mao. ");
INSERT INTO xsi_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Mine kala naŋa ma kawâŋgu buu nâ tia ndo. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pa noko. Yova Kindeni, naneŋgu Maro Kindeni noko, naŋa ma atu ndaŋge pano ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Yova Kindeni, naŋa amâ pano tu ma pwatonana. Noko ma kusâu panzi kazâŋa tamâta tu ma sipole naŋa ku siveta maŋeti pana, mine ndimo. Noko nde vetâŋa sondo warika. Mine nde ano pano tu pwaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Kupaloŋo pa naneŋgu noŋa, aku kumâ walele nâ kuvilana! Noko kumo kutogo mira ŋalae naŋa uru amuna tini mwasina. Pwea ŋanana, itogo teŋgo kaika ikea ŋana tamâta lâ paraŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Mao nâ, noko kutogo naneŋgu munâŋa nia mine, aku noko uru pwea ŋanana. Pwai poe pana ku kutula nzâla pana, ikura noko muŋga kupa ŋgua tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Kinzi kazâŋa tamâta nde sio nimbu ŋana ikai naŋa kaika kâ. Mine nde ano pano tu pwatonana, ŋana tu noko kumo naneŋgu munâŋa nia. ");
INSERT INTO xsi_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Naŋa ao warakâŋgu lâ noko mbau ilo. Mine nde pwai naŋa piti lâ kazâŋa ilo. Yova Kindeni, noko simbo nâ nde Maro mao. ");
INSERT INTO xsi_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Noko uru wisi nâna panzi tamâta ea siwâŋgi panzi maro laŋeŋa. Aŋga naŋa nde ma kaloŋgu tawana noko nâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Noko tini mwasa pa naŋa ikura zo zo. Mine nde naŋa ma amo andeka nâ. Noko mata kumora naneŋgu malia ŋine lâ, aku noko kusama tu naneŋgu kazâŋa tamâta siveta vetâŋa sakamao kie-kie pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Naneŋgu kazâŋa tamâta situ sikai naŋa kaika, andeta noko ŋandai kusâu panzi ŋana siveta mine ŋga. Noko kuvilana kala amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Andeta Yova Kindeni, kala ŋine naŋa iloŋgu malia ndo. Mine nde naŋa ano pano tu kalo sukâŋa ŋanana. Naŋa amo ata nâ, kala matâŋgu nde poa lâ. Naŋa tiniŋgu ndoni nde pââsââ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Naŋa iloŋgu malia ŋalae tina, aku kalo-lokoni ŋine itu itoto naneŋgu via ipâŋga mbwana-mbwana nâ. Naneŋgu tiŋa ŋine nde iyaula naŋa ndo lâ, kala akura tu amo zo luandondo, ande tia. Malia kie-kie ikai naŋa kaika lee waloŋgu tia lâ. Mao nâ, naŋa tukâŋgu rârâni nenzi walo nde marumbu ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Naneŋgu kazâŋa tamâta rârâni nde uru sivaligi naŋa. Andeta kinzi nâ tia; naneŋgu mete kala ilonzi sakamao ndo pa naŋa, aku niŋgu-nambwe nde tininzi pwâka ndo ŋanana. Lâ zo ndia naŋa atu ayoka nzâla, ambo kinzi simora naŋa ayoka amâ panzi, ande sikâwa silâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Kinzi tamâta rârâni nde kalonzi kapa lâ ŋana naŋa kâ, itogo tamâta kalonzi kapa ŋana tamâta toŋge imâte muŋgani lâ. Naŋa atogo kulo toŋge mâta pwapwataki kala tamâta sitambira lâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Naŋa aloŋonzi kazâŋa tamâta rârâ siporo ilonzi ŋuru-ŋuru. Kinzi situ siveta ruruŋa ŋalae tina pa naŋa. Kinzi sipasau lâ taitu ku sipa ŋgua ŋana siveta kenzi sakamao pana. Kinzi situ sipu naŋa pâta amâte. ");
INSERT INTO xsi_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Andeta kalo loko. Yova Kindeni, naneŋgu kalo-tawana ikeno pa noko nâ. Naneŋgu Maro Kindeni kala noko. Mine nde naŋa wisiŋgu puu ndue. ");
INSERT INTO xsi_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Noko uru pwatona naŋa ikura zo rârâni. Naŋa ano pano tu pwaina piti lâ naneŋgu kazâŋa tamâta mbaunzi ilo, kinzi ŋinde uru siveta kenzi sakamao pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Kalo sukâŋa ŋana ne wurâta tamâta naŋa! Noko ne tini-mwasa uru ikeno panzi ne tamâta ikura zo rârâni. Mine nde naŋa ano pano tu pwaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yova Kindeni, naŋa asarâwa pano tu kuvilana. Ambo noko ma kuvila naŋa, ande naŋa ma akai maŋeti lâ naneŋgu kazâŋa tamâta naonzi tia. Naŋa iloŋgu tu noko ma kuveta maŋeti pa kinzi tamâta sakamao warakanzi. Naŋa iloŋgu tu noko ma kusae kawanzi ku kuonzi silâ pa mateŋa nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Ŋana tu kinzi uru sipasuka warakanzi tininzi ku sitalea ŋgua sakamao lâ tamâta pinde tininzi, kinzi ŋinde uru siveta vetâŋa ara. Mine nde naŋa iloŋgu tu noko ma kutoto kinzi laŋeŋa tamwatanzi ŋinde nenzi ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Maro Ŋalae, naŋa asama tu noko uru kuveta kie ara ndo panzi tamâta ea simege ŋanano kala siwâŋgi pano. Kinzi tamâta rârâni sisama tu noko uru pwatonanzi tamâta ea kalonzi tawana noko kala simâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Noko uru kuveanzi tamâta sondo ŋinde lâ noko tini laiti. Mine nde kinzi kazâŋa tamâta sikura tu sizavarunzi kâ, ande tia. Noko uru pwea ŋananzi. Mine nde nenzi kazâŋa tamâta nenzi ŋgua sakamao ikura tu iyaula ilonzi kalonzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Paneâŋa ilâ pa Yova Kindeni, ŋana tu i ne tini-mwasa ikeno pa naŋa ikura zo zo! Muŋga, lâ zo ŋinde kinzi kazâŋa tamâta siŋge naŋa ku simandi ŋana sizavaruna, ande i itula ne tini-mwasa ŋinde pwataki lâ, kala naŋa amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Yova Kindeni, lâ zo ŋinde naŋa tiniŋgu ruru, aku iloŋgu patea tu noko kuŋara naŋa lâ, kala amo malawae ŋanano. Andeta naŋa asarâwa pano tu kuvilana, aku kupaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Miki Yova Kindeni ne tamâta, miki ma tinimi mwasa ndo papa i. I uru ikea ŋananzi tamâta ea simo i kalo. Aŋga tamâta ea kinzi sipasuka warakanzi tininzi, ande ipare nia sondo panzi, ikura nenzi vetâŋa soki ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Miki tamâta ŋine uru kao tinimi pa Yova Kindeni tu ma iveta kie ara pami, ande miki rârâni kapu kaika pa warakami ilomi kalomi, aku kamandi kaika. ");
INSERT INTO xsi_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Ambo Yova Kindeni ikai kiesaka piti lâ tamâta toŋge tini ku izavarunzi i ne vetâŋa potomule rârâni piti, ande tamâta ŋinde ikura tu indeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Ambo tamâta toŋge ipu muli ndo pa laŋeŋa ne mâsi, aku Yova Kindeni ipatea tu i ma kalo ŋgere kilo tia ŋana tamâta ŋinde ne kiesaka kâ, ande tamâta ŋinde ikura tu indeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Muŋga, lâ zo ŋinde naŋa ŋandai apatula naneŋgu kiesaka pwataki papa Yova Kindeni ŋga, ande naŋa amo ata nâ ikura zo zo. Mine kala naŋa tiniŋgu ndoni nde pââsââ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Yova Kindeni, lâ zo ŋinde noko mbau nâ kupu naŋa ikura kari wa mbo wa. Naneŋgu walo nde ipilena ku ilâ lâ, itogo unza kari kana kala ŋgâla-ŋgâla ndo mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Andeta muli ŋga naŋa apatula naneŋgu kiesaka pwataki pa noko. Naŋa ŋandai avea naneŋgu vetâŋa sakamao toŋge ŋga. Naŋa iloŋgu patea mine tu, “Naŋa ma apatula naneŋgu kiesaka rârâni pwataki pa Yova Kindeni.” Naŋa iloŋgu malia ŋana naneŋgu kiesaka ŋinde kâ. Mine kala naŋa apatula lâ, ŋineŋga noko kuzavaru naneŋgu kiesaka piti, ku kuveta iloŋgu kaloŋgu ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Mine nde lâ zo ndia malia itu ipâŋga panzi tamâta ŋinde uru sipono muli pa noko, ande ara ŋana kinzi ma sino pano. Ŋineŋga lâ zo ŋana malia itu ipâŋga ŋalae tina panzi, itogo lââ pondi kâki ku imâ ŋana ipatukunzi mine, ande malia ŋinde ma ikura tu izavarunzi, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Yova Kindeni, noko nâ kumo naneŋgu munâŋa nia. Noko uru pwatonana, kala malia toŋge ŋandai ipu naŋa ndue ŋga. Lâ zo ndia malia itu ipâŋga pana, ande noko pwea ŋanana. Mine nde naŋa kawâŋgu ŋalae awâŋgi apaneano. ");
INSERT INTO xsi_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yova Kindeni iporo mine tu, “Naŋa ma apananano sondo, aku ma natula nzâla pano. Naŋa ma akatonano wa akai poe pano wa. ");
INSERT INTO xsi_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Kupaloŋo pa naŋa kawâŋgu ŋgua nâ. Noko ma kumo kutogonzi bulmakao ndimo. Kinzi bulmakao ilonzi kalonzi tia. Mine nde tamâta uru sio ‘aini’ lâ vigunzi ilo ku sitapa raveŋa ŋana kinzi ma sipaloŋo panzi. Ambo kinzi ma siveta mine tia, ande kinzi bulmakao ma soka potomule nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Malia rârâ ŋinde ma ipâŋga panzi tamâta sakamao, andeta ikura zo zo Yova Kindeni ilo ndo keno panzi tamâta ea kalonzi tawana i, aku ikatonanzi sondo. ");
INSERT INTO xsi_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Mine nde miki tamâta ŋine uru kaveta vetâŋa ara, miki ma ilomi ara ku kandeka ŋana vetâŋa arara Yova Kindeni muŋga iveta pami ŋinde. Miki tamâta ŋine kapono muli papa i, miki rârâni ma kawami kâki kandeka ku kapanea i ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Miki tamâta ŋine uru kaveta vetâŋa ara, miki rârâni kandeka ku kapanea Yova Kindeni ŋana vetâŋa rârâni i muŋga iveta ŋinde. Miki ŋine uru kapono muli pa Yova Kindeni, miki rârâni kawâŋgi kasuka i ŋa kâki, ŋana tu ŋinde nde mâsi ara. ");
INSERT INTO xsi_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Miki kawami ndaŋge kawâŋgi wâŋgiŋa kapanea Yova Kindeni. Kara wâŋgu kiri-kiri wa ŋalaŋala wa, aku kawâŋgi wâŋgiŋa papa i. ");
INSERT INTO xsi_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Miki kawâŋgi wâŋgiŋa wasaseki pinde papa i. Kara wâŋgu sondo ndo ku kawâŋgi ara nâ. Miki rârâni kandeka ku kasuŋa kawami kâki. ");
INSERT INTO xsi_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Ŋana tu Yova Kindeni ne ŋgua rârâni nde mao kanaŋo, aku i uru iveta vetâŋa rârâni sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yova Kindeni indeka ŋana iveta kie ara panzi tamâta, aku i ilo ara nâ ŋana ipare nia sondo panzi tamâta rârâni, ikura nenzi vetâŋa mine. Aku ikura zo zo i ne tini-mwasa ilâ isala nia rârâni lâ tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Nia ndoyo Yova Kindeni iporo ŋgua, aku i kawa ŋgua ŋinde nâ ivetanzi kari wa nzimona wa pitu sipâŋga samba tini. Iporo lâ kawa nâ, aku kelekele rârâni ŋinde ipâŋga pa âta. ");
INSERT INTO xsi_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Igonanzi tâi rârâni ku ionzi lâ nia taitu nâ, itogo tamâta itai lââ lâ kulo ilo mwasina. I io tâi geza-geza lâ nia sondo. ");
INSERT INTO xsi_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Mine kala miki tamâta rârâni kamo tâno kulu, miki kamege ŋana Yova Kindeni kâ. Miki rârâni kapare tukumi ndue lâ i nao. ");
INSERT INTO xsi_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Ŋana tu nia ndoyo iporo ŋgua, aku i kawa ŋgua ŋinde nâ iveta tâno ipâŋga. Iporo lâ kawa nâ, aku ndainani nâ kelekele rârâni sipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Mao nâ, ikai poe pa kelekele ndoni. Lâ zo ndia kinzi tinikoa tamâta simâ taitu ku sipa ŋgua ŋana siveta vetâŋa pinde, ande Yova Kindeni uru iveta nenzi ŋgua pâŋa ŋinde ilâ kaa nâ. Kinzi sipa ŋgua, andeta isae nzâla ŋananzi, kala sikura tu siveta vetâŋa ŋinde tia. ");
INSERT INTO xsi_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Andeta sâ ma ikura tu iveta Yova Kindeni ne ŋgua pâŋa ilâ kaa nâ, a? Tia ndo! I ne ŋgua pâŋa ma ikeno kaika mine ku imo nâ. Ambo i ilo patea tu ma iveta vetâŋa toŋge, ande i ne ilo-kalo ŋinde ma ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Ambo tamâta ŋgu toŋge ma sipono muli pa Maro Kindeni ku simo i kalo, ande ŋgu ŋinde sikura tu sindeka ŋalae. Kinzi tamâta ŋinde i muŋga ipateanzi pa i tamwata, kinzi ŋinde ma sindeka pâta. ");
INSERT INTO xsi_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Mao nâ, Yova Kindeni imo samba ilo, aku i mata indue imâ imoranzi tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","I imo koipu ŋalae lâ i tamwata ne lawea, aku i mata indue imâ imoranzi tamâta rârâni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","I tamwata iveta tamâta rârâni ilonzi kalonzi, ande kala isama lâ ŋana vetâŋa rârâni kinzi siveta. ");
INSERT INTO xsi_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ambo koipu ŋalae toŋge ne zugu tamâta kambwaŋenzi rârâ simo, ande ŋinde ikura tu isuka koipu ŋinde ŋana ipole paraŋa kâ, ande tia. Ambo zugu tamâta toŋge imo tava ne walo kaika, ande ŋinde ikura tu isuka i ŋana ipu ne kazâŋa tamâta ndue kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Aku mine nâ, ambo tamâta toŋge kalo tawana tu i ne “hosi” ma isuka i ŋana ipole paraŋa kâ, ande i ne kalo-tawana ŋinde ma ilâ kaa nâ. Kinzi “hosi” nenzi kaika ŋalae ikura tu ivilanzi zugu tamâta nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Taitu miki kaloŋo ŋga; Yova Kindeni uru ikatonanzi tamâta ea simege ŋana i kâ, kinzi ŋinde kalonzi tawana tu i ne tini-mwasa ikeno panzi ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","I ikea sondo ndo ŋananzi tamâta ŋinde. Mine kala nenzi kazâŋa tamâta sikura tu sipunzi pâta simâte, ande tia. Ambo nia putole, ande i ikatonanzi, kala simâte tia. ");
INSERT INTO xsi_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Mine nde kinda uru tao tininda pa Yova Kindeni tu ma imâ ivila kinda. I nde nenda Pavilâŋa Tamwata, aku i imo itogo nenda maramuŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","I uru iveta kie ara nâ pa kinda, aku ŋinde iveta ilonda ndeka. I nde Sapâŋa Tamwata, aku ŋana duvi ŋinde kâ kinda kalonda tawana i. ");
INSERT INTO xsi_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yova Kindeni, maka kao tinima pa noko tu kumâ kuvilama. Maka kano pano tu kuo ne tini-mwasa imâ imo kuma ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Naŋa ma kawâŋgu ndaŋge papa Yova Kindeni ikura zo zo. Naŋa ma amo apanea i asuka ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Yova Kindeni iveta kie ara pa naŋa lâ. Mine kala naŋa ma awâŋgi awawa i. Miki tamâta ea kamo tava malia, miki ŋinde katambira taŋami pa naneŋgu ŋgua ŋine ku kandeka nâ! ");
INSERT INTO xsi_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Ara ŋana miki ma katula Yova Kindeni kilala pwataki kuku naŋa tu i nde Maro Ŋalae. Kinda ma tagogo kawânda tasuka i ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Muŋga naŋa ano pa Yova Kindeni tu ma ivilana, aku ipaloŋo pa naneŋgu noŋa. I ikai ruruŋa rârâni piti lâ iloŋgu, kala ŋine naŋa amo iloŋgu pisi nâ. ");
INSERT INTO xsi_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Tamâta pinde uru simo tava malia kie-kie. Andeta lâ zo ŋana kinzi sio nenzi kalo-tawana ilâ pa Yova Kindeni, ande ilonzi ndeka nâ. Kinzi ma sikai maŋeti ŋana nenzi kalo-tawana ŋinde kâ, ande tia ndo, ŋana tu Yova Kindeni ma ivilanzi. ");
INSERT INTO xsi_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Kinzi simo ara tia ndo, andeta sino papa Yova Kindeni, aku ipaloŋo pa nenzi noŋa. I ivilanzi ku ikainzi piti lâ nenzi malia rârâni ilo. ");
INSERT INTO xsi_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yova Kindeni ne aŋelo uru ikatonanzi tamâta ea siruru ŋana i kâ, aku ikea ŋananzi lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yova Kindeni uru iveta kie ara ndo pa kinda. Ambo miki warakami ma kalâ kamo i kalo, ande miki kala ma kasama Yova Kindeni kilala pwataki tu i nde ara ndo. Tamâta ea simuna i tini laiti, kinzi ŋinde sikura tu sindeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Miki Yova Kindeni ne tamâta, miki kamâ kapare tukumi ndue lâ i nao. Ŋana tu tamâta ea kinzi sipaveta kuku i kawa ŋgua, kinzi ŋinde ma siroto ŋana kelekele toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Kinzi mbwâmbwa saka “leve” nenzi kaika nde ŋalae tina, andeta zo pinde kanzi simbi tia, kala putole ipunzi. Andeta Yova Kindeni uru irombonzi tamâta ea sipaveta kuku i kawa ŋgua. Mine kala kinzi siroto ŋana kelekele ara toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Mine nde miki lâlu wukale, miki kamâ katambira taŋami sondo pa naneŋgu ŋgua. Naŋa ma apananami ŋana kamege ŋana Yova Kindeni ku kamo i kalo. ");
INSERT INTO xsi_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Tiambo miki ilomi tu ma kamo ara nâ, tiya? Tiambo miki ilomi tu ma kamo viami tava ndekâŋa nâ ikura zo luandondo, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Ambo ilomi tu ma kamo mine, ande nzâla ikeno mine: miki ma kapile mâsi ŋana kaporo ŋgua sakamao wa ŋgua laŋeŋa wa; ");
INSERT INTO xsi_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","miki ma kapu mulimi pa vetâŋa sakamao, aku kapono muli pa vetâŋa ara nâ; aku miki ma kakai wurâta kaika ŋana kamo ilomi kalomi taitu kunzi tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yova Kindeni uru ikea ŋananzi tamâta ea sipaveta kuku vetâŋa ara, aku ipaloŋo pa tamâta mine nenzi noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Taitu Yova Kindeni ne wisi-nâna ikeno panzi tamâta ea uru siveta vetâŋa sakamao. Mine kala lâ zo ŋana kinzi ŋinde ma simâte, ande kinzi tamâta ma kalonzi ŋgere ŋananzi kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Tamâta pinde uru sipaveta kuku vetâŋa ara, aku lâ zo ndia kinzi ŋinde sino papa Yova Kindeni, ande ipaloŋo panzi ku ivilanzi ŋana nenzi malia rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Tamâta ea kinzi simo tava ilonzi malia, ande Yova Kindeni imo kinzi tininzi laiti. I uru ivilanzi tamâta ea ilonzi patea tu malia ma ipunzi ndue ndo. ");
INSERT INTO xsi_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Malia kie-kie uru ipâŋga panzi tamâta ara, andeta Yova Kindeni ivilanzi sondo kala malia ŋinde ikura tu ipunzi ndue, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Yova Kindeni uru ikatona kinzi tamâta ara tininzi ndoni. Mine kala kinzi tukanzi toŋge ma mbwaranuki tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Andeta vetâŋa sakamao kie-kie ma ipunzi tamâta sakamao simâte. Yova Kindeni ma iyaulanzi tamâta ea uru sikai kazâŋa panzi tamâta ara. ");
INSERT INTO xsi_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Mao nâ, Yova Kindeni uru ikai kinda i ne tamâta rârâni piti lâ kazâŋa ilo. Tamâta ea imâ papa i tu ma imuna i tini laiti, ande Yova Kindeni ma izavaru tamâta ŋinde tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Yova Kindeni, naŋa ano pano tu pwai kazâŋa panzi tamâta ŋine kala sikai kazâŋa pa naŋa, aku kupara kunzi tamâta ŋine kala sipara kuku naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Pwai ne maramuŋa kâki tava paraŋa ne kelekele pinde, aku kumâ kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Pwai ne ua wa kavasi wa kâki, ku kumâ kupara kunzi tamâta ŋine sitaŋgula naŋa. Ambo noko ma kuveta mine, ande naŋa ma asama tu noko kumo naneŋgu Pavilâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Naneŋgu kazâŋa tamâta ŋinde situ sipu naŋa pâta amâte. Naŋa iloŋgu tu noko ma kupunzi wa kuveta maŋeti panzi wa. Kinzi sipa ŋgua tu ma sizavaru naŋa. Naŋa iloŋgu tu noko ma kupono nzalanzi ku kuŋaranzi sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yova Kindeni, naŋa iloŋgu tu noko ne aŋelo kinzi ma siŋaranzi tamâta sakamao ŋinde, itogo lawea itapala gawura mine. ");
INSERT INTO xsi_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Naŋa iloŋgu tu noko ne aŋelo ma sitaŋgulanzi kala sikâwa silâ nzâla kondoma ku zuli-zuli ndo. ");
INSERT INTO xsi_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Naŋa ŋandai aveta vetâŋa soki toŋge pa kinzi ŋga, andeta sivea nimbu ŋana siyaula naŋa kâ. Kinzi situ sikai naŋa kaika. Mine kala sisale tâno ne wewe ŋalae toŋge tu ma patana andue ilo. ");
INSERT INTO xsi_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Mine nde naŋa iloŋgu tu noko ma walele nâ kupâŋga panzi ku kuveta wisinzi motutu, ŋineŋga kuzavarunzi marumbu lâ. Naŋa iloŋgu tu nimbu ŋinde kinzi sio ŋana ikai naŋa kaika kâ ma ikai kinzi warakanzi nâ. Naŋa iloŋgu tu kinzi warakanzi ma patanzi sindue wewe kinzi muŋga sisale ŋinde ilo, ku ma sipayaula ndo. ");
INSERT INTO xsi_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Naŋa kaloŋgu tawana tu Yova Kindeni ma iveta ikura naneŋgu noŋa mine, kala naŋa ma andekana i nâ. Lâ zo ŋinde naŋa ma iloŋgu ara ndo, ŋana tu i ivila naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Aku naŋa iloŋgu ndoni ma atu ndaŋge ŋalae papa Yova Kindeni. Naŋa ma aporo mine tu, “Maro Kindeni, maro toŋge irerege kuku noko nde tia. Lâ zo ndia kinzi tamâta kaika situ siveta kenzi sakamao panzi tamâta ŋinde nenzi kaika ikeno panzi tia, ande noko uru pwea ŋananzi. Noko kupono nzâla ŋananzi mbaliŋa warakanzi, kala sikura tu siveta malia panzi sugorai tamwatanzi, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Kala ŋine kinzi laŋeŋa tamwatanzi simandi lâ ŋgua nia ku sitalea naŋa ŋana vetâŋa soki pinde, andeta naŋa ŋandai aveta vetâŋa soki ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Naŋa uru aveta keŋgu ara nâ panzi naneŋgu kazâŋa tamâta, aŋga kinzi nde siveta kenzi sakamao ndo pa naŋa. Mine kala naŋa iloŋgu nde malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Mao nâ, naneŋgu vetâŋa nde piti ndo ŋana kinzi nenzi vetâŋa kâ. Muŋga pukoŋa ikainzi, aku kaloŋgu sukâŋa ŋananzi kala apita lalava râge-râge. Naŋa andi kaika ŋana kâpwa kâ, ŋana atula naneŋgu kalo-sukâŋa pwataki. Lâ zo ŋinde naŋa akai noŋa pano tu ma kuvetanzi tininzi ara kilo, aku naneŋgu noŋa ŋinde ŋandai ŋgua kaa nâ ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ambo pukoŋa kie mine ma ikai niŋgu-nambwe tâku naŋa tata tâ, ande naŋa ma akai noŋa kie taituni pano, itogo noŋa ŋinde naŋa akai pano ŋananzi naneŋgu kazâŋa tamâta ŋinde. Lâ zo ŋinde naŋa ayoka naoŋgu tundu, itogo tamâta toŋge tina imâte lâ kala ita ŋana mwasina. Naŋa iloŋgu malia ndo, kala amo ata nâ. ");
INSERT INTO xsi_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Andeta muli ŋga naŋa asânda malia kulu, aku kinzi silâ taitu ku sindeka nâ. Kinzi siŋge naŋa mbwaliu lâ ŋana siveta “a” pa naŋa. Naŋa ŋandai asama kinzi kilalanzi ŋga, taitu kinzi simo siponda ŋgua sakamao imâ tiniŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Kinzi sivaligi naŋa ku siveta maŋeti ŋalae ŋinde pana. Kinzi wisinzi sakamao ndo pana, aku naonzi kaika silea pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Maro Ŋalae, noko tamwata kumora nenzi vetâŋa sakamao ŋinde, andeta noko ŋandai kuvila naŋa ŋga. Noko ma kumo nâ ikura zo ŋapia kilo, a? Naŋa ano pano tu pwaina piti lâ mbaunzi ilo. Kinzi sitogo mbwâmbwa saka “leve” mine, aku situ sipu naŋa pâta amâte. Mine nde ano pano tu kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ambo noko ma kuvila naŋa, ande naŋa ma kawâŋgu ndaŋge pano lâ noko ne tamâta ŋgu rârâni naonzi. Mao nâ, naŋa ma amandi noko ne ŋgu nenzi pasauŋa ilo ku ma asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Tamâta pinde simo sikai kazâŋa pa naŋa koa tia nâ. Noko ma kusâu panzi tu sitawa naŋa ndue ku sindeka, mine ndimo. Naŋa tiniŋgu pwâka tu kinzi ma ilonzi ara ŋana naneŋgu malia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Kinzi ŋandai uru siporo ŋgua mwasa ŋga. Kinzi siporo ŋgua laŋeŋa kie-kie ilâ panzi tamâta arara ŋinde uru naonzi mwasa nâ panzi tininzi pinde. ");
INSERT INTO xsi_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Kinzi kawanzi pakâe-pakâe siveta “a” pana ku sitalea naŋa mine tu, “Mao nâ, maka warakama kamora noko kuveta mâsi sakamao pinde.” ");
INSERT INTO xsi_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Andeta Yova Kindeni, noko tamwata kumora nenzi vetâŋa ŋinde marumbu lâ. Mine nde noko ma kusae kawa ndimo. Maro Ŋalae, naŋa tiniŋgu pwâka tu noko ma kumo malawae ŋana naŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Noko nde naneŋgu Maro Kindeni; naneŋgu Maro Ŋalae noko. Naŋa ano pano tu kumandi sânda ku kumâ kuvilana. Kumandi ku kuporo kusuka naneŋgu ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Maro Kindeni, naneŋgu Maro Kindeni noko. Noko ne vetâŋa rârâni nde sondo ndo. Mine kala naŋa ano pano tu kuvilana, aku kuporo kutula pwataki tu naŋa aveta vetâŋa soki toŋge tia. Noko ma kusâu panzi tu siŋelea naŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Naŋa tiniŋgu pwâka tu kinzi ma siporo ŋgua pa warakanzi mine tu, “Kala ŋaina. Muŋga kinda ilonda patea tu ma tazavaru i ndo lâ, kala ŋine kinda taveta vetâŋani ndaina!” Noko ma kusâu panzi tu siporo ŋgua kaŋa mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Kinzi sindeka nâ ŋana naneŋgu malia ŋine. Naŋa iloŋgu tu noko ma kuveta maŋeti panzi ku kupolenzi lâ. Kinzi sipasuka warakanzi ŋanzi kâki ku situ sitawa naŋa ŋâŋgu ndue ndo. Naŋa iloŋgu tu noko ma kuveta kinzi mainzi ŋalae, aku kutawa warakanzi ŋanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Andeta Yova Kindeni, tamâta pinde ilonzi tu naŋa ma apolenzi tamâta ŋinde lâ ŋgua nia. Ande kala naŋa iloŋgu tu kinzi tamâta ara ŋinde ma sindeka ku sisarâwa ikura zo zo mine tu, “Tasuka Yova Kindeni ŋa kâki! Ina ilo ndeka nâ ŋana ivilanzi ne wurâta tamâta tu simo ara kâ.” ");
INSERT INTO xsi_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Aku naŋa kala ma aporo atula pwataki tu noko ne vetâŋa rârâni nde sondo ndo, aku ma apaneano asuka noko ŋa kâki ikura kari wa mbo wa. ");
INSERT INTO xsi_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Kiesaka ikeno lâ kinzi tamâta sakamao ilonzi kalonzi, aku kiesaka ŋinde uru ikai poe panzi. Kinzi simege ŋana Maro Kindeni tia ndo. Kinzi sipu mulinzi papa i. ");
INSERT INTO xsi_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Kinzi uru sipandekâna warakanzi ku ilonzi mine tu, “Naŋa nde tamâta ara ndo. Naneŋgu kiesaka nde ipavea nâ ikeno. Mine nde Maro Kindeni ikura tu isânda naneŋgu vetâŋa sakamao toŋge kulu ku io naŋa alâ pa ŋgua nia ŋana, ande tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Kinzi tamâta ŋinde kawanzi laŋeŋa nâ, aku siporo ŋgua sakamao ndo. Kinzi sipu mulinzi pa ilo-kalo ara kala sipile mâsi ŋana sipaveta kuku vetâŋa ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Lâ zo ŋana sikeno sipwarea kâ, ande kinzi uru kalonzi ŋgere ŋana vetâŋa sakamao pinde kinzi situ siveta. Kinzi sipaveta kuku vetâŋa potomule nâ, aku ŋandai sipu mulinzi pa mâsi sakamao ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yova Kindeni, noko ne tini-mwasa nde ŋalae ndo, ikâki pa nia maa ikeno âta ŋinde. Aku noko ne mâsi ŋana kuveta ikura ne ŋgua pâŋa rârâni kala nde ŋalae ndo mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Noko ne mâsi ŋana kuveta vetâŋa ara nâ nde ŋalae tina, itogo tuu ŋalaŋala mwasina. Aku noko ne mâsi ŋana kutu kinzi tamâta sondo kâ nde ŋalae ndo, itogo tâi geza-geza mine. Yova Kindeni, noko uru pwatonanzi kinzi tamâta wa kinzi ŋgoa-mbwâmbwa wa. ");
INSERT INTO xsi_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Yova Kindeni, noko ne tini-mwasa ikeno mine ku imo nâ, aku maka kasama tu ŋinde nde kelekele ara ndo. Noko pwea ŋananzi tamâta ŋalaŋala wa kinzi sugorai tamwatanzi wa, itogo tatareko tina iveanzi natu simo mbani kalo mine. ");
INSERT INTO xsi_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Kâpwa rârâ nde ipipi lâ noko ne luma ilo, aku noko uru kurombonzi tamâta rârâni. Noko ne vetâŋa ara nde ilâ panzi itogo lââ ŋalae irere ndue mine, aku sinu kala ilonzi ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Noko nde via warika, aku noko ne sinâla uru isinala maka ku iveta maka kamo sondo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ikura zo zo noko ilo ndo ikeno panzi tamâta ŋinde sisama noko kilala sondo. Aku ikura zo rârâni noko uru kuveta kie ara panzi tamâta ŋinde sipono muli pano. Naŋa ano pano tu kuveta mine ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Tamâta pinde sipasuka warakanzi tininzi ku situ ma kenzi nâ sipale naŋa. Kinzi tamâta sakamao situ sisuka mbaunzi kâki ku sipu naŋa. Noko ma kusâu panzi tu siveta mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Miki tamâta ŋai, naŋa akai noŋa mine, aku kamora ŋga! Kinzi tamâta sakamao nde patanzi lâ kala simo sikeno nâ. Kinzi sikura tu sipagagati ku simandi kaika kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Noko ma kalo loko ŋana vetâŋa ŋinde kinzi tamâta sakamao uru siveta, mine ndimo. Aku noko ma kupadâda ŋananzi tamâta ŋinde uru siveta vetâŋa soki, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Ŋana tu kinzi tamâta sakamao uru simo ikura zo mbwana-mbwana nâ, itogo unza wa kâi lau wa, kari kana ku ŋgâla-ŋgâla walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Andeta ara ŋana noko ma kalo tawana Yova Kindeni ku kupaveta kuku vetâŋa ara nâ. Ambo noko ma kuveta mine, ande noko ma kumo ara lâ tâno ŋinde i muŋga ipatea pano, aku sâ toŋge ma ikura tu izavaruno, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Ambo noko ma kundekana Yova Kindeni nâ, ande vetâŋa ndia noko ilo tu i ma iveta pano, ande i ma iveta vetâŋani ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Mine nde ara ŋana noko ma kuo tamwata ne via ilâ Yova Kindeni mbau ilo. Ambo noko ma kalo tawana i, ande i ma ivilano mine; ");
INSERT INTO xsi_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","i ma itula noko ne vetâŋa ara ipâŋga nia yo, itogo kari ne sinâla mine. Mao nâ, i ma itula pwataki tu noko nde tamâta sondo, itogo kari ikâki imâ ŋgini ku isinala nia kaika mine. ");
INSERT INTO xsi_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Mine nde ara ŋana noko ma kumo mwasa nâ lâ Yova Kindeni nao, aku kumo kuo tini pa i ne pavilâŋa. Ambo tamâta ma siveta vetâŋa sakamao pinde ikura muŋga sipa ŋgua tu ma siveta mine, ande noko ma kalo loko ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Noko ma kupu muli pa kalo-lokoni ne vetâŋa wa wisi-nâna ne vetâŋa wa, ŋana tu vetâŋa kie mine ikura tu ilaŋeno ŋana kuveta kiesaka. ");
INSERT INTO xsi_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Kuloŋo ŋga; Yova Kindeni ma izavarunzi kinzi tamâta sakamao. Aŋga tamâta ea kalonzi tawana Yova Kindeni ku sio tininzi pa i ne pavilâŋa kâ, ande kinzi ŋinde ma simo sondo lâ tâno ara ŋinde i muŋga ipambwâre tu ma ilanzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Kinzi tamâta sakamao simo ikura zo mbwana-mbwana nâ. Ambo kinzi tamâta ara ma siroto ŋananzi lâ nenzi lawea ilo, ande kinzi ma sisânda kulunzi tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Aŋga tamâta pinde uru sipatawa warakanzi tininzi, aku kinzi ŋinde ma sikai tâno ara ŋinde. Kinzi ma simo ara ndo, aku kazâŋa toŋge ma ipâŋga panzi nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Kinzi tamâta sakamao sipa ŋgua tu ma sizavarunzi tamâta ara, aku wisinzi sakamao ndo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Andeta Maro Ŋalae iŋeleanzi tamâta sakamao ŋinde, ŋana tu i ma muli izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Kinzi tamâta sakamao sikai nenzi pila kâki ku sirae nenzi temba ŋana sipanenzi sugorai tamwatanzi. Kinzi simandi ŋana sipunzi tamâta ŋinde uru sipaveta kuku vetâŋa ara. ");
INSERT INTO xsi_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Andeta nenzi pila ŋinde ma isowe warakanzi kapwanzi pwataki, aku nenzi temba nde ma mbwaranuki. ");
INSERT INTO xsi_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Miki kalomi ŋgere ŋana ŋine kâ; tamâta ara toŋge ne mbaliŋa kiri-mwata nde ipole kinzi tamâta sakamao rârâ nenzi mbaliŋa kie-kie ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Ŋana tu Yova Kindeni ma iyaula kinzi tamâta sakamao nenzi kaika, andeta ikea ŋananzi tamâta ara. ");
INSERT INTO xsi_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yova Kindeni ikatonanzi tamâta ŋinde uru sipaloŋo pa i ne ŋgua ku soka muli. Aku ikura zo rârâni kinzi ma simo ara lâ tâno ŋinde Yova Kindeni muŋgani ipatea panzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Ambo zo sakamao ma ipâŋga panzi, ande malia toŋge ma izavarunzi tia. Lâ zo ŋana nia putole ipâŋga, ande kanzi kâpwa rârâ ma ikeno panzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Taitu Yova Kindeni ma izavarunzi tamâta sakamao. I ne kazâŋa tamâta kinzi ma naonzi tia lâ, sitogo mâle wa unza wa. Mao nâ, kinzi ma simo sitogo mundo ikeno zo mbwana-mbwana nâ, ŋineŋga nzarana walele nâ ku nao tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Kinzi tamâta sakamao uru sikai kelekele saŋenzi tininzi pinde, andeta muli kinzi situ ŋana kelekele ŋinde, nde tia. Aŋga kinzi tamâta ara sisilikana warakanzi nenzi mbaliŋa tia ndo. Kinzi uru kelekele rârâ silanzi tininzi pinde. ");
INSERT INTO xsi_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Yova Kindeni ne nzâmbe ara ikeno panzi tamâta pinde, aku kinzi ŋinde ma sikai nenzi tâno ara. Aŋga tamâta pinde, ande Yova Kindeni ipa ŋgua ŋana izavarunzi kâ, aku i ma iŋaranzi tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yova Kindeni ikai poe sondo panzi tamâta ŋine uru sipaveta kuku vetâŋa ndia i ilo papa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Mine kala lâ zo ŋana kinzi ŋinde ma sisâsa lâ nzâla, ande kinzi ma patanzi ku sipayaula, ande tia, ŋana tu Yova Kindeni isaŋa mbaunzi kaika. ");
INSERT INTO xsi_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Muŋga naŋa tamâta limoa, aku amo lee kala ŋine naŋa nde koŋa lâ. Aku lâ naneŋgu mbwera ndoni, naŋa ŋandai amora Yova Kindeni ipu muli pa tamâta ara toŋge ŋga. Aku naŋa ŋandai amora kinzi tamâta ara natunzi simo sugorai ndo kala sino panzi tamâta pinde tu kâpwa silanzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Ikura zo zo kinzi tamâta ara mine ilonzi panzi tininzi pinde, kala sindeka ŋana kelekele silanzi. Yova Kindeni ne nzâmbe ara ikeno panzi tamâta ŋinde natunzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Mine nde kuloŋo ŋga; ambo noko ma kupu muli pa vetâŋa sakamao ku kupaveta kuku vetâŋa ara, ande noko ma kumo ara lâ tâno ara ŋinde ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Ŋana tu Yova Kindeni tini mwasa panzi tamâta ea sipaveta kuku vetâŋa sondo, aku i ma ipilenzi ne tamâta tia ndo. Ikura zo rârâni i ikatonanzi tamâta ea sipaveta kuku vetâŋa ara. Andeta i ma iŋaranzi kinzi tamâta sakamao nenzi vâsa. ");
INSERT INTO xsi_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Kinzi tamâta ara ma sikai tâno ŋinde Yova Kindeni ipatea panzi, aku ma simo ara mine ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Tamâta ara imo tava ilo-kalo ara nâ. Mine kala i uru itula ŋgua sondo nâ. I kawa ŋgua rârâni nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","I ne Maro Kindeni ne ŋgua tukuŋa nde ikeno kaika lâ i ilo. Mine kala i uru iyoka tukuŋa ŋinde muli, aku i pata ndue tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Aŋga kinzi tamâta sakamao simuna ku sio ŋananzi tamâta ara. Kinzi siroto nzâla ŋana sipunzi tamâta ara pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Andeta Yova Kindeni ma io tamâta ara toŋge ilâ pa kinzi tamâta sakamao mbaunzi ilo, ande ma tia. Lâ zo ndia kinzi tamâta sakamao simandi ŋgua nia ku sitalea tamâta ara toŋge, ande Yova Kindeni ma isâu panzi tu sipole tamâta ara ŋinde, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Mine nde ara ŋana noko ma kuo tini pa Yova Kindeni ne pavilâŋa wa kupaloŋo pa i kawa ŋgua wa. Ambo noko ma kuveta mine, ande i ma isuka noko ŋa kâki, kala noko ma pwura ŋana pwai tâno ara ŋinde. Aku lâ zo ŋana Yova Kindeni ma izavarunzi tamâta sakamao, ande noko mata ma kumora i ne vetâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Naneŋgu ŋgua ŋine nde duvi mine; nanayoni naŋa amora tamâta sakamao toŋge, i ne kaika ŋalae ŋinde. I nde ipolenzi tamâta ndoni kala imo kulunzi, itogo kâi ŋalae toŋge imandi tuu kulu ku ipolenzi kâi pinde rârâni mine. ");
INSERT INTO xsi_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Andeta muli ŋga naŋa amo nia ŋinde kilo, aku tamâta sakamao ŋinde nde nao tia lâ. Naŋa aroto ŋana i kâ, andeta asânda kulu tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Andeta ara ŋana noko ma kalo ŋgere sondo ŋananzi tamâta pinde, kinzi ŋinde sipaveta kuku vetâŋa ara kala soki toŋge ikeno panzi tia. Kinzi simo tava wisinzi pisi nâ, aku ma simo ikura zo luandondo ku ma sipulianzi nenzi vâsa rârâ. ");
INSERT INTO xsi_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Aŋga kinzi kiesaka tamwatanzi, ande Yova Kindeni ma iyaula kinzi rârâni ndo lâ. I ma izavarunzi tamâta sakamao kala nenzi vâsa tia. ");
INSERT INTO xsi_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Ambo kazâŋa ma ipâŋga panzi tamâta ara, ande Yova Kindeni tamwata ma ikainzi piti. Aku lâ zo ndia malia itu ipâŋga panzi, ande kinzi silâ pa i tu ikea ŋananzi. ");
INSERT INTO xsi_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Kinzi kalonzi tawana tu Yova Kindeni ma ikatonanzi. Mine nde i ivilanzi ku ikainzi piti lâ tamâta sakamao mbaunzi ilo, kala simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Yova Kindeni, noko ma wisi nâna ku kumbita naŋa ndimo. Mao nâ, noko wisi nâna, taitu naŋa ano pano tu kupare nia pa naŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Noko kupane naŋa lâ, aku noko ne silâwa isowe kapwâŋgu. Noko mbau nâ kupu naŋa kala patana andue lâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Noko wisi nâna pa naŋa, kala pukoŋa sakamao ikai tiniŋgu ndoni. Naŋa aveta kiesaka, aku ŋana duvi ŋinde kâ naŋa karaeŋgu ndoni nde ipayaula ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Naneŋgu kiesaka rârâni nde itawa naŋa ndue ndo lâ. Ŋinde itogo kelekele toŋge malia ndo naŋa atu akale, andeta akura tia. ");
INSERT INTO xsi_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Naŋa aveta vetâŋa soki ndo, aku ŋana duvi ŋinde kâ mbwatakâe rârâ ika tiniŋgu, kala wembu rârâ ipâŋga ku sâmbu ndo. ");
INSERT INTO xsi_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Naŋa iloŋgu malia ndo, kala akura tu amandi kaika nde tia. Ikura zo rârâni naŋa kaloŋgu sukâŋa kala amo ata nâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Naŋa tiniŋgu nde nâna ŋalae, itogo yââ mela-mela ne nâna mine, aku pukoŋa ŋalae tina ikai naŋa kaika lâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Noko kuyaula naŋa ndo lâ, aku naneŋgu kaika ndoni marumbu lâ. Naŋa iloŋgu kurana tia ndo, aku nâna ŋine iveta naŋa asarâwa kawâŋgu ŋalae ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Maro Ŋalae, noko kusama lâ ŋana vetâŋa ŋinde naŋa iloŋgu tu noko ma kuveta pana. Naŋa iloŋgu ita ŋalae, aku ŋinde ŋandai ipavea ŋanano ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Naŋa wisiŋgu nde iveta pupu kaika nâ, aku waloŋgu ndoni nde marumbu lâ. Naŋa matâŋgu nde ipâŋga sakamao, kala ŋandai amora nia sondo ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Naŋa niŋgu-nambwe sitavanzi naneŋgu mete kinzi nde tininzi pwâka tu simo tiniŋgu laiti, ŋana tu pukoŋa sakamao ikaina lâ. Aku naŋa seeŋgu kinzi ŋinde kala tininzi piti ŋanana mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Andeta ŋinde nâ tia; tamâta pinde situ sipu naŋa pâta amâte, aku sio nimbu ŋana ikai naŋa kaika kâ. Kinzi situ ma siyaula naŋa, aku siporo pwataki tu ma siveta kenzi sakamao pana. Ikura zo zo kinzi kalonzi ŋgere ŋana siveta kenzi sakamao pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Naŋa apâŋga togo tamâta toŋge taŋa pasâe, aku apono taŋâŋgu ŋana nenzi ŋgua kâ. Naŋa apâŋga atogo tamâta toŋge kawa pasâe, aku kawâŋgu buu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Naŋa apâŋga atogo tamâta toŋge ikura tu iloŋo ŋgua tia. Mine kala naŋa ŋandai aporo ŋgua taulo panzi ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Andeta Yova Kindeni, naŋa ao tiniŋgu pa noko. Maro Ŋalae, naneŋgu Maro Kindeni noko, noko tamwata ma kuporo ŋgua taulo pana. ");
INSERT INTO xsi_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Naŋa ano pano tu noko ma kusâu panzi naneŋgu kazâŋa tamâta tu sindeka ŋana naneŋgu malia ŋine, mine ndimo. Naŋa tiniŋgu pwâka tu kinzi ma simora naŋa patana ku ma simarawa naŋa wa sindeka wa. ");
INSERT INTO xsi_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ŋana tu laiti ŋana naŋa ma patana kâ, aku akai nâna mine ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Maro Kindeni, kala ŋine naŋa apatula naneŋgu kiesaka pwataki pano, aku kaloŋgu loko ŋana kiesaka ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Naneŋgu kazâŋa tamâta nde simo tava nenzi walo kaika. Tamâta rârâ ŋinde nde wisinzi nâna pa naŋa, andeta ŋinde ne duvi tia. ");
INSERT INTO xsi_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Naŋa aveta keŋgu ara panzi, aŋga kinzi nde siveta kenzi sakamao pa naŋa. Naŋa uru apaveta kuku vetâŋa ara, aku ŋana duvi ŋinde kâ kinzi sikai kazâŋa pana. ");
INSERT INTO xsi_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Yova Kindeni, noko ma kupile naŋa ndimo! Naneŋgu Maro Kindeni, noko ma kumo malawae ŋanana ndimo! ");
INSERT INTO xsi_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Maro Ŋalae, naneŋgu Pavilâŋa Tamwata noko, naŋa ano pano tu kumâ walele nâ ku kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Muŋga naŋa aporo mine tu, “Naŋa ma apakatona warakâŋgu sondo ŋana naneŋgu vetâŋa rârâni. Tia ma naŋa aveta kiesaka ŋana aporo ŋgua sakamao kâ. Lâ zo ndia kinzi tamâta sakamao simo naŋa tiniŋgu laiti, ande naŋa ma asae kawâŋgu.” ");
INSERT INTO xsi_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Mine nde naŋa kawâŋgu buu nâ, ku aporo ŋgua toŋge tia ndo. Andeta naŋa aveta mine koa tia nâ. Naŋa iloŋgu ipâŋga malia ndo, ");
INSERT INTO xsi_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","aku kaloŋgu loko nâ. Naŋa iloŋgu kaloŋgu ikai wurâta kaika lee iloŋgu kurana tia ndo. Aku marumbu; naŋa akura tu asae kawâŋgu kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Mine kala naŋa akasoŋa Yova Kindeni mine tu, “Yova Kindeni, naŋa ma amo viâŋgu ikura mbwera ŋapia kilo. Naŋa ma amâte lâ zo ndia. Tiambo naneŋgu via ŋine ma marumbu walele nâ, tiya? Noko kuporo kutula ŋine pwataki naloŋo. ");
INSERT INTO xsi_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Naŋa asama tu noko kupatea zo mbwana-mbwana nâ pa naŋa. Lâ noko nao, naneŋgu zo ŋine nde kelekele kaa nâ. Mao nâ, maka tamâta rârâni nema via nde kelekele kaa nâ, itogo tamâta toŋge imbana koroani mbwani taitu nâ lâ kawa. ");
INSERT INTO xsi_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Lâ zo ŋine maka kamo tâno kulu, ande maka tamâta rârâni nde katogo kâi uŋa mine. Maka uru kaveta wurâta ŋalae tina, andeta wurâta ŋinde ilâ kaa nâ. Maka kagona mbaliŋa rârâ, taitu maka kazizâla tu muli ŋga ea ma ikai. Mao nâ, maka katogo kelekele kaa nâ uru nao tia walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Mine nde Maro Ŋalae, kala ŋine naŋa ma ao tiniŋgu pa sâ toŋge tia. Naŋa kaloŋgu tawanano, kala ao tiniŋgu pa noko nâ tu kuvila naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Naŋa ano pano tu kuzavaru naneŋgu kiesaka rârâni piti lâ tiniŋgu, ŋana naŋa ma amo ara kilo. Ŋineŋga kinzi tamâta kapa-kapa ma sikura tu siveta ‘a’ pa naŋa kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Naŋa asama tu noko tamwata kuo malia ŋine imâ ipâŋga pana. Mine nde naŋa ma aporo tia, ma kawâŋgu buu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Taitu naŋa ano pano tu noko ma kupare nia pa naŋa kilo ndimo. Noko mbau nâ kupu naŋa lee ku laiti ŋana amâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Maro Ŋalae, naŋa asama tu noko uru kuleleanzi tamâta ŋana nenzi kiesaka kâ, aku noko kupare nenzi kiesaka ŋinde nia panzi. Aku mbaliŋa ndia kinzi ilonzi papa, ande ŋinde noko kuyaula, itogo nzirika ika lalava ku iveta ipâŋga sakamao mwasina. Mao nâ, maka tamâta rârâni nema via nde kelekele kaa nâ, itogo tamâta toŋge imbana koroani mbwani taitu nâ lâ kawa. ");
INSERT INTO xsi_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yova Kindeni, kupaloŋo pa naneŋgu noŋa, aku kutambira taŋa pa naneŋgu sarawâŋa. Noko ma kupono taŋa ŋana naneŋgu tiŋa ŋine ndimo, ŋana tu naŋa amo lombo ikura zo tini mwata nâ kuku noko lâ tâno kulu, itogo naŋa timbuŋgu rârâni muŋga simo mine. ");
INSERT INTO xsi_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Naŋa ano pano tu kulele nao pa naŋa kilo. Ŋineŋga naŋa ma akura tu andeka kilo lee ikura lâ zo ndia ma napile tâno ŋine ku naoŋgu tia lâ.” ");
INSERT INTO xsi_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Muŋga, naŋa amo nâ ao tiniŋgu pa Yova Kindeni tu ivila naŋa. Amo lee ŋineŋga i nao pana kala ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Pa zo ŋinde naŋa amo atogo tamâta imo mbââ ŋalae ilo mwasina, kala amo sakamao ndo. Andeta Yova Kindeni itapa naŋa kâki kala apâŋga amandi tâno kulu kilo. Ŋinde itogo naŋa aloko lâ nia mbariri sakamao ilo, andeta ipasu naŋa piti iŋgunu naŋa amandi mira kulu. Mine kala ŋine naŋa ayoka kaika kilo. ");
INSERT INTO xsi_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ŋinde itogo i io wâŋgiŋa wasaseki toŋge lâ kawâŋgu. Ŋinde nde wâŋgiŋa ŋana tapanea nenda Maro Kindeni tasuka i ŋa kâki. Tamâta rârâ ma simora naŋa apanea Yova Kindeni mine, aku ma simege ŋana i wa sio nenzi kalo-tawana ilâ papa i wa. ");
INSERT INTO xsi_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Mao nâ, tamâta ea kinzi sio nenzi kalo-tawana ilâ pa Yova Kindeni, kinzi ŋinde ma sindeka. Kinzi tamâta mine uru sipu mulinzi panzi tamâta ea sipasuka warakanzi tininzi ku sipile Maro Kindeni ku siwâŋgi panzi maro laŋeŋa. ");
INSERT INTO xsi_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yova Kindeni, naneŋgu Maro Kindeni noko, noko muŋga kuveta vetâŋa arara rârâ ŋinde ŋana kuvila maka kâ. Maro toŋge irerege kuku noko nde tia ndo! Aku noko kupatea vetâŋa arara pinde kilo ŋana kuveta pama. Opopo, ambo naŋa atu aporo atula ŋgua pwataki ŋana noko ne vetâŋa arara ŋinde taitu-taitu, ande naŋa ma akura tia. ");
INSERT INTO xsi_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Naŋa asama tu noko tini pwâka ŋana simbi wa kâpwa kie-kie ŋinde kinzi tamâta uru sipatarâwa pano. Aku patarawâŋa rârâni kinzi uru simomo lâ yââ kulu wa, patarawâŋa ŋana izavaru kiesaka piti kâ wa, ande ŋinde noko tini pwâka ŋana tona. Andeta nanayoni noko kuveta naŋa taŋâŋgu ipwa kala apaloŋo pa noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Mine kala naŋa aporo taulo tu, “Maro Kindeni, naŋa warakâŋgu amo ŋai mbo. Naŋa amâ apâŋga lâ, ikura ŋgua ŋinde kinzi muŋga siŋgere lâ pepa tini ŋana naŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Naneŋgu Maro Kindeni, naŋa iloŋgu ndo tu aveta ikura noko ne pateâŋa mine. Noko ne ŋgua tukuŋa nde ikeno lâ iloŋgu kaloŋgu.” ");
INSERT INTO xsi_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Yova Kindeni, lâ zo ŋana noko ne tamâta sipasau ŋana sipaneano, ande naŋa uru aporo panzi tu noko uru kuvila maka. Naŋa ŋandai asae kawâŋgu ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Noko uru kuvilanzi ne tamâta, aku naŋa ŋandai avea ŋgua ŋana ne pavilâŋa ŋinde ŋga. Ikura zo zo naŋa aporo atula pwataki tu noko uru kuveta ikura ne ŋgua pâŋa rârâni. Naŋa aporo tu noko tini mwasa panzi ne tamâta ikura zo rârâni, aku noko uru pwatonanzi sondo, ikura muŋga kuporo tu ma kuveta mine. Lâ zo ŋana noko ne ŋgu sipasau ŋana siwâŋgi pano, ande naŋa ŋandai avea ŋgua ŋana noko ne vetâŋa ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yova Kindeni, naŋa asama tu noko ma kupile ne mâsi ŋana kalo sukâŋa ŋana naŋa kâ, ande ma tia. Noko uru tini mwasa pana, aku noko uru kuveta ikura ne ŋgua pâŋa rârâni. Mine nde noko ma pwatona naŋa ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Andeta kala ŋine malia rârâ ŋinde nde imâ ipâŋga pana, kala siŋge naŋa lâ. Naŋa akura tu asowe malia ŋinde kambwaŋenzi nde tia. Muŋga naŋa aveta kiesaka rârâ, aku ŋinde itawa naŋa ndue lâ. Mine nde naŋa akura tu amora sondo tia. Naneŋgu kiesaka ŋinde kambwaŋenzi nde ŋalae tina, ipole kuluŋgu pwau ŋine kambwaŋenzi. Mine kala naŋa tiniŋgu ruru, aku naneŋgu walo nde ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Mine nde Yova Kindeni, kalo sukâŋa ŋanana ku pwai naŋa piti ŋga! Yova Kindeni, kumâ walele ku kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Tamâta pinde situ sipu naŋa pâta amâte. Naŋa iloŋgu tu noko ma kuveta maŋeti panzi ku kupolenzi ndo lâ. Kinzi uru sindeka ŋana naneŋgu malia ŋine. Naŋa iloŋgu tu noko ma kuŋaranzi ku kutawa ŋanzi ndue lâ. ");
INSERT INTO xsi_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Kinzi sivaligi naŋa ku siveta “a” pana. Naŋa iloŋgu tu noko ma kuzavarunzi ndo lâ, aku kuveta kinzi mainzi ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Aŋga tamâta pinde nde uru simâ pano, aku naŋa iloŋgu tu kinzi ŋinde ma sindekanano. Noko muŋga pwainzi tamâta ŋinde piti lâ kazâŋa ilo, aku naŋa iloŋgu tu kinzi rârâni ma kawanzi ndaŋge pano ku siporo ŋgua ikura zo rârâni mine tu, “Yova Kindeni nde ara ku ara ndo!” ");
INSERT INTO xsi_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ambo taitu naŋa nde tamâta kaa nâ, aku akura tu apavila warakâŋgu, ande tia. Andeta Maro Ŋalae, naŋa asama tu noko uru kalo ŋgere ŋanana. Naneŋgu Maro Kindeni, naneŋgu Pavilâŋa Tamâta wa naneŋgu Yautâŋa Tamâta noko. Mine nde naŋa ano pano tu kumâ walele nâ ku kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Tamâta ea kinzi uru kalonzi sukâŋa ŋananzi sugorai tamwatanzi kala sisukanzi, ande kinzi ŋinde sikura tu sindeka, ŋana tu lâ zo ndia malia ma imâ ipâŋga panzi, ande Yova Kindeni ma ivilanzi. ");
INSERT INTO xsi_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yova Kindeni ma ikea ŋananzi ku ikatona nenzi via. I ma ivetanzi simo ara ndo lâ nenzi tâno, aku ma isâu pa nenzi kazâŋa tamâta tu sizavarunzi, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Lâ zo ndia kinzi tamâta ara ŋinde sikai pukoŋa, ande Yova Kindeni ma isukanzi ku ma iveta tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Naŋa warakâŋgu asama ŋine kala aporo mine tu, “Yova Kindeni, muŋga naŋa aveta kiesaka pa noko. Kalo sukâŋa ŋanana, ku kuzavaru pukoŋa ŋine piti lâ tiniŋgu.” ");
INSERT INTO xsi_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Naneŋgu kazâŋa tamâta nde ilonzi sakamao pa naŋa. Kinzi siporo tu, “Ara ŋana i ma imâte walele nâ ku nao tia lâ.” ");
INSERT INTO xsi_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Zo katiŋe kinzi nawalanzi pinde simâ sikalele naŋa, andeta silâŋe ku siporo ŋgua kaa kaa pana. Kinzi situ siloŋo tapâriŋa ŋana naneŋgu pukoŋa sakamao ŋine, ŋineŋga siyâti silâ ku situ naŋa laginâŋgu panzi tininzi pinde. ");
INSERT INTO xsi_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Naneŋgu kazâŋa tamâta rârâni silâ taitu ku siporo ŋgua sakamao ŋana naŋa kâ. Kinzi ilonzi tu vetâŋa sakamao ndo ma iyaula naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Kinzi siporo mine tu, “Pukoŋa sakamao nde ikai i kaika lâ. Mine nde i ma kura ŋana imandi kilo lâ kenoŋa nia, ande ma tia. I ma imâte nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Aku niŋgu-nambwe sondo, inani muŋga imo ilo taitu kuku naŋa ku ika kuna, ande i kala ikai kazâŋa pa naŋa mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","O Yova Kindeni, kalo sukâŋa ŋanana ku kuzavaru pukoŋa ŋine piti lâ tiniŋgu, ŋana naŋa ma kura tu apare nia panzi naneŋgu kazâŋa tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Lâ zo ŋana noko ma kupaloŋo pa naneŋgu noŋa ku kupono nzalanzi, ande naŋa ma asama tu noko ilo ara pana. ");
INSERT INTO xsi_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Mao nâ, naŋa uru aveta ikura noko ne pateâŋa mine, aku ŋana duvi ŋinde kâ noko kuvilana ku kuo naŋa amandi noko nao ikura zo rârâni, ma amo mine ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Mine nde ara ŋana kinda ma tapanea Yova Kindeni tasuka i ŋa kâki. Ina Isrel ŋgu nema Maro Kindeni. Paneâŋa ma ilâ mine nâ papa i ikura zo zo. Mao ku mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ambo wiki toŋge imo dugu ilo ku irakoŋa ŋana lââ kâ, ande i ma ilo ndo tu isânda lââ ŋalae kulu ŋana inu kâ. Maro Kindeni, naŋa kala mine nâ iloŋgu ndo tu amâ amo noko tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Maro Kindeni, noko Via Tamwata, naŋa iloŋgu ndo keno pano, itogo tamâta ŋandola mâsa-mâsa kala ilo pa lââ tu inu kâ. Maro Kindeni, naŋa ma kura tu amâ amandi noko nao ku awâŋgi pano lâ zo ndia. ");
INSERT INTO xsi_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Ikura zo zo naneŋgu kazâŋa tamâta pinde sivaligi naŋa ku siporo mine tu, “Ŋana sâ kâ ŋga noko ne Maro Kindeni tini pwâka tu ivilano, a?” Mine kala naŋa amo ata nâ ikura kari wa mbo wa. Naŋa matâŋgu sulu nde itogo nakâŋgu kâpwa mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Naŋa kaloŋgu ŋgere ŋana zo ara muŋgâŋa ŋinde, ku amo ata nâ. Nanayoni naŋa uru ayoka kunzi ŋgu ŋalae amuŋga panzi akainzi silâ Maro Kindeni ne luma sapâŋa ilo. Lâ zo ŋinde maka iloma ndeka nâ kala kasarâwa ŋalae kawama ndaŋge kawâŋgi pa Maro Kindeni. Ikura kumbwa rârâni maka uru kapasau kawâŋgi papa i. ");
INSERT INTO xsi_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Naŋa apakasoŋa warakâŋgu mine tu, “Ŋana sâ kâ ŋga iloŋgu malia mine, a? Ŋine nde ara tia. Ara ŋana naŋa ma ao tiniŋgu pa naneŋgu Maro Kindeni, inani naneŋgu Yautâŋa Tamwata, tu ma ivila naŋa. Naŋa ma apanea i asuka ŋa kâki kilo.” ");
INSERT INTO xsi_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Andeta kala ŋine naŋa iloŋgu malia ndo. Mine nde Maro Kindeni, naŋa ma kaloŋgu ŋgere kilo ŋana noko kâ. Naŋa amo naneŋgu lawea tina tia; naŋa amo papa Jodan tâno, nia ŋine Hermon Tuu aŋga Misa Tuu simandi. Naŋa amo ŋai kala kaloŋgu ŋgere ŋanano kilo. ");
INSERT INTO xsi_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Noko kusâu pa malia kie-kie tu sipâŋga pana ku sitawa naŋa ndue ndo, itogo tâi ne kâla ŋalaŋala sipatuku naŋa mine. Mao nâ, ŋinde itogo tâi geza-geza ne kâla ikâki ŋalae, aku ne nduŋeŋani nde itogo lââ ŋalae irere mira ilo ku isoŋga ndue. ");
INSERT INTO xsi_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Ŋineŋga naŋa kaloŋgu ŋgere ŋana ŋine kâ; ikura kari kari Yova Kindeni uru io ne tini-mwasa ara ŋinde imâ pa naŋa, aŋga ikura mbo mbo i ne wâŋgiŋa nde ikeno pana. Naŋa uru awâŋgi wâŋgiŋa ŋinde pa Maro Kindeni, inani naneŋgu via warika, aku wâŋgiŋa ŋinde nde ipâŋga itogo naneŋgu noŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Maro Kindeni uru ikatona naŋa sondo ndo, andeta naŋa akasoŋa i mine tu, “Ŋana sâ kâ ŋga noko kalo kapa ŋanana, a? Ŋana sâ kâ ŋga noko kusâu panzi naneŋgu kazâŋa tamâta tu siveta kenzi sakamao pana, kala amo tava iloŋgu malia ndo, a?” ");
INSERT INTO xsi_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Ikura zo zo naneŋgu kazâŋa tamâta sivaligi naŋa ku siporo ŋgua sakamao pana mine tu, “Ŋana sâ kâ ŋga noko ne Maro Kindeni tini pwâka tu ivilano, a?” Nenzi ŋgua ŋinde isowe naŋa iloŋgu itogo silâwa mine, kala atu amâte. ");
INSERT INTO xsi_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Naŋa apakasoŋa warakâŋgu mine tu, “Ŋana sâ kâ ŋga iloŋgu malia mine, a? Ŋine nde ara tia. Ara ŋana naŋa ma ao tiniŋgu pa naneŋgu Maro Kindeni, inani naneŋgu Yautâŋa Tamwata, tu ma ivila naŋa. Naŋa ma apanea i asuka ŋa kâki kilo.” ");
INSERT INTO xsi_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Maro Kindeni, tamâta pinde sipu mulinzi pa noko, aku kinzi ŋinde ilonzi tu sitawa naŋa ndue. Naŋa ano pano tu kuvilana ku kusuka naneŋgu ŋgua. Kuporo kutula pwataki tu naŋa aveta vetâŋa soki toŋge tia. Kinzi tamâta sakamao ŋinde nde laŋeŋa tamwatanzi. Naŋa ano pano tu kuvilana ku pwaina piti lâ mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Maro Kindeni, naŋa uru amâ pano tu amuna ŋananzi kazâŋa tamâta. Andeta ŋana sâ kâ ŋga noko kupu muli pa naŋa, a? Ŋana sâ kâ ŋga noko kusâu panzi naneŋgu kazâŋa tamâta tu siveta kenzi sakamao pana kala iloŋgu malia ndo, a? ");
INSERT INTO xsi_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Naŋa ano pano tu kuo ne sinâla tava ne ŋgua mao imâ, ŋana itula nzâla pa naŋa ku ikaina ayoka sondo pa noko tamwata ne tuu sapâŋa Saion, niani ndaina noko uru kumo. ");
INSERT INTO xsi_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Maro Kindeni, ŋineŋga naŋa ma alâ pa noko ne patarawâŋa nia, ŋana tu nokoni nde naneŋgu ndekâŋa ŋine warika. Maro Kindeni, naneŋgu Maro Ŋalae noko, naŋa ma ara wâŋgu awâŋgi wâŋgiŋa paneâŋa kâ pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Naŋa apakasoŋa warakâŋgu mine tu, “Ŋana sâ kâ ŋga iloŋgu malia mine, a? Ŋine nde ara tia. Ara ŋana naŋa ma ao tiniŋgu pa naneŋgu Maro Kindeni, inani naneŋgu Yautâŋa Tamwata, tu ma ivila naŋa. Naŋa ma apanea i asuka ŋa kâki kilo.” ");
INSERT INTO xsi_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Maro Kindeni, maka timbuma nde sitapâri pama lâ ŋana mâsi ŋalaŋala noko muŋga kuveta lâ kinzi nenzi zo, lâ zo muŋgâŋa ŋinde. Maka warakama nde kaloŋo tapâriŋa ŋinde lâ. ");
INSERT INTO xsi_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Kinzi sitapâri tu noko tamwata kusokinzi tinikoa ŋgu lâ nenzi tâno, ŋineŋga tânoni ndaina kulanzi timbuma, kala simo sondo lâ tâno ŋinde. Kinzi sitapâri tu noko kutawanzi tinikoa ŋgu ndue lâ, aŋga kinzi warakanzi nde noko kuvetanzi simo ara nâ kala sipâŋga kambwaŋenzi ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Kinzi sipara, andeta kinzi warakanzi nenzi temba-silâwa ŋandai isukanzi ŋana sikai tâno ŋinde ŋga. Aku mine nâ, kinzi warakanzi nenzi kaika ŋandai ivilanzi ŋana sipole paraŋa ŋinde ŋga. Noko ilo ndo keno panzi; mine kala noko tamwata nâ ne walo kaika ipole paraŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Mine kala naŋa aporo tu noko nde naneŋgu koipu ŋalae, aku naneŋgu Maro Kindeni kala noko. Nokoni kupatea tu maka Yakopu ne vâsa ŋgu ma uru kapole paraŋa. ");
INSERT INTO xsi_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Nokoni uru kuvila maka ŋana katawanzi nema kazâŋa tamâta ndue. Noko ne walo kaika nâ isukama ŋana kapolenzi tamâta ŋinde situ sipara kuma. ");
INSERT INTO xsi_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Naneŋgu temba tava pila ŋalae nde ikeno pana, andeta naŋa ŋandai kaloŋgu tawana tu kelekele ŋinde ma ivila naŋa ŋana apole paraŋa kâ. Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Taitu nokoni muŋga kuvila maka kala kapolenzi nema kazâŋa tamâta. Kinzi tamâta ŋinde ilonzi sakamao pa maka, andeta noko kutawanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Mine nde Maro Kindeni, maka nema paneâŋa ilâ pa noko simbo nâ ikura zo zo. Maka ma kawama ndaŋge pano, ma kaveta mine ku kamo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Andeta mana mana, a? Kala ŋine noko kupu muli pa maka lâ, aku kusâu panzi kazâŋa tamâta tu sipolema. Lâ zo ŋana nema zugu tamâta silâ ŋana paraŋa kâ, ande noko kupile ne mâsi ŋana kulâ kumo kunzi. ");
INSERT INTO xsi_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Noko kupile maka lâ, kala kakâwa ŋananzi kazâŋa tamâta, aku sikai nema kelekele marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Noko kusâu panzi tu sipu maka pâta kamâte, itogo mbwâmbwa saka sikanzi lama mine. Aku noko kusoki maka ŋana nema tâno, kala kakâwa pwapwataki kalâ kamo potomule lâ tinikoa ŋgu ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Noko kuveta tamwata ne ŋgu maka tu kapâŋga wurâta tamâta kaa nâ panzi tinikoa ŋgu. Tiambo noko kutu maka nde kelekele sugorai nâ kala kuveta mine, a? ");
INSERT INTO xsi_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","14","Ŋana duvi ŋinde kâ kinzi ŋgu simo nema lawea tini laiti ŋine nde uru siporo ŋgua pavaligiŋa pama. Kinzi siŋeleama pâta lâ, aku siveta maŋeti nâ pama. Lâ zo ndia kinzi siloŋo maka parinama, ande kinzi siveta “a” pama wa sirurua kulunzi pama wa. ");
INSERT INTO xsi_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Naneŋgu kazâŋa tamâta nde ilonzi sakamao ndo pa naŋa, aku simandi naoŋgu siporo ŋgua pavaligiŋa wa ŋgua sakamao wa pana. Nenzi ŋgua ŋinde iveta maŋeti ŋalae pana, kala maiŋgu ndo. ");
INSERT INTO xsi_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Maro Kindeni, ŋana sâ kâ ŋga vetâŋa mine ipâŋga pama, a? Maka ŋandai kaloma kapa ŋanano ŋga, aku ŋandai katoto ŋgua pâŋa ŋinde noko muŋga kuveta kuku maka ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Maka ŋandai kapu mulima pa noko ŋga, aku ŋandai kalaŋa kapole noko ne tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Andeta noko kuzavaru maka lâ. Ŋinde itogo noko kutambirama kamo waloma tia ndo lâ kinzi mbwâmbwa saka ŋgininzi. Noko kupilema kala kamo nia kondoma ŋaŋa ndo. ");
INSERT INTO xsi_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Andeta maka nema Maro Kindeni, noko kusama maka kilalama lâ. Ambo maka muŋga kaloma kapa ŋanano ku kapare tukuma kano panzi maro laŋeŋa, ");
INSERT INTO xsi_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","ande noko ma kusama, ŋana tu noko kusama ilo-kalo paveâŋa rârâni ikeno iloma kaloma. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Maka nde kamo noko ne tamâta. Mine kala ikura zo rârâni kinzi sipu maka pinde pâta kamâte. Kinzi siveta kenzi taituni pa maka, itogo siveta panzi lama lâ zo ŋana sipunzi pâta ŋana sikanzi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Mine nde Maro Ŋalae, kupagagati ku kumandi sânda ŋga! Ŋana sâ kâ ŋga noko pweno nâ, a? Kumandi sânda tâ! Noko ma kupu muli pa maka ikura zo rârâni ndimo! ");
INSERT INTO xsi_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Ŋana sâ kâ ŋga noko kumuna ŋanama, a? Kinzi tamâta ŋinde siveta kenzi sakamao pama, aku maka kakai malia ŋalae tina. Noko ma kalo kapa ŋana nema malia ŋine kâ ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Maka patama kandue tâno kulu marumbu lâ, aku karaema nde ikeno nâ, katogonzi mateŋa tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Maro Ŋalae, maka kano pano tu kumâ kuvilama! Noko ne tini-mwasa uru ikeno mine ku imo nâ. Mine nde kumâ ku pwaima piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Ŋgua ara rârâ nde pipi lâ ikeno iloŋgu kaloŋgu, kala naŋa atu asia wâŋgiŋa ŋine pa koipu ŋalae. Tamâta pinde sikura tu siŋgere ŋgua kaŋa ara lâ pepa tini, aku naŋa kala aluku ŋana awâŋgi wâŋgiŋa kaŋa ara mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Naneŋgu wâŋgiŋa nde mine; Koipu Ŋalae, noko tamwata nao wa tini wa nde ara pâta lâ. Tamâta toŋge irerege kuku noko, nde tia. Aku noko kawa ŋgua kilala nde ara ndo. Ŋinde itula pwataki tu Maro Kindeni uru iveta kie ara pano ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Noko nde walo tamwata. Mine nde naŋa iloŋgu tu noko ma kupa ne pila ŋana paraŋa kâ lâ kambwaŋe. Ŋineŋga kinzi tamâta ma simora tu noko ne walo nde ŋalae ŋinde, aku ma sisama tu noko ne vetâŋa nde ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Noko ŋa nde ŋalae ndo, aku naŋa iloŋgu tu noko ma kusaŋona “hosi” kumbu ku kulâ kupara kunzi tamâta ŋinde uru sikai kazâŋa pa ŋgua mao wa vetâŋa sondo wa. Noko ne walo nde kaika ndo; mine nde noko uru kuveta mâsi ŋalaŋala kie-kie. ");
INSERT INTO xsi_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Koipu Ŋalae, noko ne silâwa mata ruru ndo, aku ŋinde ikura tu isowe ne kazâŋa tamâta kapwanzi. Mine nde noko kupolenzi ne kazâŋa tamâta ŋinde, kala sipare tukunzi ndue lâ noko kie tini. ");
INSERT INTO xsi_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Maro Kindeni io noko pwai koipu ŋalae, ma kumo mine ku kumo nâ. Noko uru pwai poe sondo ndo panzi ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Noko tini mwasa pa vetâŋa sondo nâ, aŋga vetâŋa sakamao nde noko ilo papa tia ndo. Mine kala noko tamwata ne Maro Kindeni ipateano tu pwai koipu, aku i ŋoa ŋalae ilano. Koipu toŋge ŋa ipole noko ŋa, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Kinzi muŋga sivala samimi kuwae ara ndo lâ noko ne pasawaŋa luandondo rârâni tininzi, aku sisiŋgara noko ne luma lâ ŋgoa ŋalae “elefan” ne saŋiri. Kala ŋine tamâta pinde simo noko ne luma ara ŋinde ilo ku sira wâŋgu siwâŋgi ŋana siveta noko ilo ndeka. ");
INSERT INTO xsi_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Koipu ŋalaŋala pinde natunzi taine nde simo noko ne luma ilo sitavanzi taine ŋalaŋala. Aku noko ne taine taipa nde imandi pa noko mbau wia kâ tava ne siŋgâra arara. Kinzi muŋga siveta i ne siŋgâra lâ mira ara “gol” ŋinde ikeno Ofir tâno. ");
INSERT INTO xsi_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Kala ŋine naŋa atu aporo ŋgua pinde pa noko taine taipa kinzi sipateano pa koipu ŋalae. Noko ma kutambira taŋa sondo pa naneŋgu ŋgua. Noko ma kupatâpa noko taine piti lâ noko ne ŋgu wa noko see taitu ŋinde ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Koipu ŋalae imora noko tu noko nde taine ara pâta lâ, aku i tini mwasa nâ pano. I nde noko ne tamâta ŋalae; mine kala noko ma kupono muli pa i kawa ŋgua nâ. ");
INSERT INTO xsi_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Kinzi tamâta simo Tair lawea ŋinde ma sikai wisi-ara kie-kie simâ pano. Aku kinzi mbaliŋa warakanzi kala ma sitogo tu sipu noko mata tona. ");
INSERT INTO xsi_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Ayo, kala ŋine koipu ŋalae ne taine taipa iyoka ilâ koipu ŋalae ne luma ilo, aku kinzi simora i tu i nde taine ara ndo. I nde ipasawa pasawaŋa toŋge muŋga sisuta lâ kaimbo “gol”. ");
INSERT INTO xsi_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Pasawaŋa ŋinde nde ne siŋgâra kie-kie rârâ. Kala ŋine sikai taine taipa ŋinde silâ pa koipu ŋalae, aku i nuwala taine taipa kinzi nde soka muli silâ. ");
INSERT INTO xsi_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Kinzi sindeka pâta ku ilonzi ara nâ, aku soka silâ koipu ŋalae ne luma ilo. ");
INSERT INTO xsi_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Koipu ŋalae, noko ma kupulianzi natu tamâne rârâ, aku muli ŋga kinzi ma sikai noko timbu muŋgâŋa ŋinde nianzi. Noko ma kuonzi tu sikai koipu sikura tâno ŋine ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Ikura zo muli-muli, ande naneŋgu wâŋgiŋa ŋine ma ivetanzi tamâta rârâ tu kalonzi ŋgere ŋanano. Mine nde kinzi ŋgu ndoni ma sipanea noko ŋa sisuka kâki ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Maro Kindeni uru ikea ŋana kinda kâ, aku i tamwata ne walo kaika ilua kinda ikura zo zo. I imo tininda laiti nâ, aku lâ zo ŋana malia imâ ipâŋga pa kinda, ande indeka ŋana ivila kinda. ");
INSERT INTO xsi_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Mine kala kinda ma taruru ŋana sâ toŋge tia. Ambo ogigi ma iririŋo tâno kaika, kala tâno ipwa pwapwataki aku tuu imbe indue tâi geza-geza ilo, ande kinda ma taruru tia. ");
INSERT INTO xsi_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Ambo tâi ma ipu kaika ndo ku ne maka ipâŋga, ambo ne kâla ma isuka kâki imbware ku isapunzi tuu iririŋo tuu duvi, ande kinda ma taruru tia. ");
INSERT INTO xsi_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Ŋana tu lââ ŋalae toŋge nde irere lâ Jerusalem lawea ilo, lawea sapâŋa ŋinde Maro Kindeni âta Tamwata uru imo. Aku lââ ŋinde uru iveta kinzi tamâta sindeka. ");
INSERT INTO xsi_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Maro Kindeni imo Jerusalem lawea ilo. Mine nde sâ toŋge ikura tu izavaru lawea ŋinde tia ndo, ŋana tu ikura zo zo, lâ mbwale pwataki, Maro Kindeni ma ivila ne lawea ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Aŋga kinzi tinikoa ŋgu ndoni nde wisinzi motutu kala sisarâwa kawanzi ŋalae, aku kinzi warakanzi sipayaula tava nenzi lawea. Maro Kindeni isuŋa kawa kâki ŋalae ndo, ŋineŋga tâno ikâwa kala nao tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Andeta Yova Kindeni, ina kaika warika, ande uru imo kuku kinda. Kinda talâ tamuna lâ timbunda Yakopu ne Maro Kindeni tini laiti, kala tamo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ayo, miki kamâ kamora vetâŋa ŋalaŋala Yova Kindeni iveta ŋinde. I iveta mâsi kaika ŋalaŋala kie-kie ipâŋga tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","I nde ilulu paraŋa lâ tâno ndoni. Imbwarenzi temba wa silâwa wa nuki-nuki, aŋga maramuŋa nde irumbianzi lâ yââ kana lâ. ");
INSERT INTO xsi_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Iporo mine tu, “Miki ma kapara kilo ndimo! Naŋa iloŋgu tu miki ma kasama naŋa kilalâŋgu sondo tu naŋa warakâŋgu nde Maro Yova Kindeni. Kinzi tamâta ŋgu ndoni nde simo naŋa kaloŋgu. Naŋa amo akai Maro Ŋalae ikura tâno ndoni.” ");
INSERT INTO xsi_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yova Kindeni, ina kaika warika, ande uru imo kuku kinda. Kinda talâ tamuna lâ timbunda Yakopu ne Maro Kindeni tini laiti, kala tamo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Miki tamâta lâ ŋgu ndoni, miki kandeka ku kaponza mbaumi! Miki kandeka ku kasuŋa kawami ŋalae kawâŋgi wâŋgiŋa paneâŋa kâ pa Maro Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","I nde koipu ŋalae kaika ndo, aku i uru ikai poe panzi tamâta ndoni simo tâno kulu. Mine nde ara ŋana kinda rârâni ma tamege ŋana Yova Kindeni kâ, inani Yova Kindeni âta Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","I ivila kinda lâ, kala tapolenzi tinikoa ŋgu ndoni. Ionzi ŋgu ndoni simo kinda kalonda. ");
INSERT INTO xsi_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Yova Kindeni ilo ndo keno pa kinda. Mine kala nanayoni i tamwata ipatea tâno toŋge panzi ne ŋgu Isrel. Kala ŋine kinda tamo tava ndekâŋa nâ lâ tânoni ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Miki kamora ŋga! Maro Kindeni nde ikâki ilâ ne luma sapâŋa ilo kala imo ŋinde, aku tamâta sindeka ku sisarâwa kaika wa simbana tando wa. ");
INSERT INTO xsi_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Ayo, miki rârâni kagogo kawami kawâŋgi kapanea Maro Kindeni ŋa! Kawâŋgi pa nenda Koipu Ŋalae tava ndekâŋa nâ! ");
INSERT INTO xsi_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Ŋana tu Maro Kindeni imo koipu ŋalae, aku ikai maro pa tâno ndoni. Miki kawâŋgi wâŋgiŋa paneâŋa kâ ilâ papa i! ");
INSERT INTO xsi_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Mao nâ, Maro Kindeni imo koipu ŋalae ku ikai poe panzi tamâta ŋgu ndoni marumbu lâ. Isaŋona koipu ŋalae ne saŋonâŋa nia sapâŋa, aku imo ikai maro. ");
INSERT INTO xsi_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Kinda uru tapono muli pa Abraham ne Maro Kindeni, aku tamâta ŋgu ndoni nenzi koipu ŋalaŋala nde sipasau simâ taitu ku kinda, ŋana tu kinzi koipu ŋalaŋala rârâni nde simo Maro Kindeni kalo. I ikai maro ŋalae ikura tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Yova Kindeni ŋa nde ŋalae ndo. Kinda ma takâki talâ pa Maro Kindeni ne lawea Jerusalem, laweani ndaina ikeno i ne tuu sapâŋa kulu, aku tapanea i tasuka ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Saion Tuu ŋinde nde ara ndo, aku ikâki ilâ âta ŋinde. Kinzi tamâta ndoni simo tâno kulu nde sindeka ŋana Koipu Ŋalae ne lawea ŋinde ikeno Saion Tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Maro Kindeni imo ne lawea ŋinde ilo, aku i uru ikea ŋananzi ne tamâta lâ nenzi kazâŋa tamâta naonzi. Mine kala kinzi simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Muŋga kinzi koipu ŋalaŋala pinde nde silâ taitu ŋana sikai paraŋa pa Saion Tuu. ");
INSERT INTO xsi_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Andeta kinzi simâ sipâŋga laiti, ŋineŋga matanzi kâki simora Maro Kindeni ne kaika ikeno pa lawea ŋinde, aku wisinzi motutu lâ. Kinzi siruru pâta kala sikâwa silâ. ");
INSERT INTO xsi_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Kinzi siruru pâta lâ, aku ilonzi kura tia ndo. Kinzi simo sitogo taine ikai nâna ŋana ipagugua lâlu kâ mine. ");
INSERT INTO xsi_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Kinzi siruru ndo, sitogo tamâta imo wâŋga kulu ku iruru ŋana kâla-lawea ikâki ku isapu wâŋga kaika lâ. ");
INSERT INTO xsi_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Kinda taloŋo pâri ŋana mâsi ŋalaŋala pinde Maro Kindeni iveta muŋgani lâ, aku kinda warakânda kala tamora i ne mâsi ŋalaŋala pinde tona. Kala ŋine kinda tamo Yova Kindeni Walo Tamwata ne lawea ilo. Kinda tamo nenda Maro Kindeni ne lawea Jerusalem ilo, aku tasama tu i ma ikatona lawea ŋine ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Maro Kindeni, maka kamâ noko ne luma sapâŋa ilo, aku kaloma ŋgere ŋana noko ne tini-mwasa ŋinde uru ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Maro Kindeni, noko ŋa ŋalae nde ikura tâno ndoni. Aku mine nâ, kinzi tamâta lâ nia rârâni sipaneano, ŋana tu noko ne mâsi ŋana pwai poe panzi tamâta kâ nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Mao nâ, noko uru kupare nia sondo nâ panzi tamâta ŋana nenzi vetâŋa kâ. Mine nde kinzi tamâta kala simo Saion lawea wa Juda ŋgu nenzi lawea rârâni wa, ande kinzi ŋinde sindeka ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Miki Maro Kindeni ne tamâta, naŋa iloŋgu tu miki rârâni ma kalâ kakarerea Saion lawea, aku kasowe luma kambwaŋenzi, luma kaika ŋalaŋala ŋinde simandi pa lawea ne ŋgumbi mira ŋgaŋe-ŋgaŋe. Ŋineŋga miki ma kasama tu Maro Kindeni nde kaika warika. ");
INSERT INTO xsi_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Miki matami kalea sondo pa lawea ŋinde ne ŋgumbi kaika. Kamora ŋga; ŋgumbi ŋinde ikâki ilâ âta, kala nenda kazâŋa tamâta ma sikura tu silaŋa sipole, ande tia ndo. Ambo miki ma matami kalea pa ŋgumbi ŋinde, ande miki ma kakura tu katapâri panzi nemi vâsa mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","“Maro Kindeni nde imo nenda Maro Ŋalae, ma imo mine ku imo nâ. I ma ikai poe sondo pa kinda ikura zo rârâni.” ");
INSERT INTO xsi_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Miki tamâta rârâni kaloŋo ŋga. Miki ŋinde rârâni kamo tâno ndoni, katambira taŋami sondo pa naneŋgu ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Miki tamâta ŋalaŋala wa miki tamâta kaa nâ wa, aŋga miki mbaliŋa warakami wa miki sugorai tamwatami wa, miki rârâni kaloŋo ŋgua ŋine sondo. ");
INSERT INTO xsi_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Ilo-kalo ara nâ nde ikeno iloŋgu kaloŋgu. Mine nde naŋa ma atula ŋgua ara ŋine pami ŋana iveta kalo-ŋgere pami. ");
INSERT INTO xsi_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Naŋa ma atula ŋgua tambirâŋa pinde pami muŋga lâ ŋga. Naŋa ma ara wâŋgu ku ma atula ŋgua tambirâŋa ŋinde duvi pwataki pami. ");
INSERT INTO xsi_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Tamâta pinde ilonzi ŋalae koŋa pa mbaliŋa nâ. Kinzi uru sipasuka warakanzi tininzi ku siporo tu kinzi nde mbaliŋa warakanzi. Aku kinzi tamâtani ndaina nde siŋge naŋa mbwaliu lâ, aku situ siveta kenzi sakamao pana. Andeta naŋa ma aruru ŋananzi tia, ŋana tu tamâta rârâni ma muli simâte. ");
INSERT INTO xsi_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Mao nâ, kinda tasama tu tamâta toŋge ikura tu mbumbu ilua Maro Kindeni ŋana imo via ikura zo luandondo, ande tia. Aku mine nâ, tamâta toŋge ikura tu iko Maro Kindeni ŋana isâu pa ninambwe toŋge tu ma imo via nâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","Ŋana tu kulu ŋana tako tamâta toŋge ne via kâ nde ikâki ndo. Mine kala tamâta toŋge ikura tu iko Maro Kindeni ŋana isâu pa tamâta toŋge tu ma iŋgeŋge ŋana mateŋa ku imo via nâ, ande tia ku tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Mao nâ, kinda tasama tu kinzi ilo-kalo tamwatanzi rârâni nde ma simâte. Aŋga kinzi tamâta ŋinde nenzi ilo-kalo ŋalae koŋa tia, sitavanzi tamâta kapa-kapa, ande kinzi ŋinde rârâni kala ma simâte tona. Kinzi tamâta rârâni taitu-taitu ma sipile nenzi mbaliŋa, ŋineŋga tamâta pinde ma sikai. ");
INSERT INTO xsi_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Muŋga kinzi simo lâ warakanzi nenzi tâno, andeta muli ŋga kuru nia ma ipâŋga itogo nenzi lawea sondo ikura zo zo. Kinzi ma simo mine lâ niani ndaina ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Ambo tamâta toŋge ŋa nde ŋalae, ande ŋinde ma ikura tu ipono nzâla ŋana mateŋa kâ, ande ma tia. I ma imâte, itogo ŋgoa ŋgoi simâte mine. ");
INSERT INTO xsi_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Mao nâ, vetâŋa kie mine ma ipâŋga panzi tamâta kapa-kapa ŋinde uru kalonzi tawana warakanzi nâ kala sindeka kaa nâ ŋana nenzi mbaliŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Maro Kindeni ipatea tu kinzi rârâni ma simâte, sitogonzi lama mine, aku mateŋa ma ikai poe panzi itogo nenzi katonâŋa tamâta mwasina. Kinzi karaenzi nde ma sâmbu walele nâ lâ kuru ilo, aku kinzi tamâta ara ma sindeka ŋana tamâta mine nenzi mateŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Andeta Maro Kindeni ma ivila naŋa. I ma ikaina piti lâ mateŋa nianzi, aku mateŋa ma ikura tu iliko naŋa kaika, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Ambo tamâta toŋge ipâŋga itogo mbaliŋa warika mine, aku ikai luma ŋalae tava kelekele arara nâ, ande noko ma wisi motu ku ilo rârâ ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ŋana tu i ma muli imâte, aku lâ zo ŋinde i ma kura tu ikai kelekele toŋge ilâ kuku, ande tia. I ne mbaliŋa ma kura tu iyoka kuku i ilâ pa mateŋa nianzi, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Mao nâ, lâ zo ŋana i imo via yo, ande i uru ipandekâna ŋana ne via ŋinde kâ. Aku tamâta pinde kala uru sisuka i ŋa kâki tona, ŋana tu i imo ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Andeta muli ŋga i ma iyoka i timbu muŋgâŋa rârâni mulinzi, ku ma imâte. I ma imo mateŋa nianzi, lâ nia kondoma ŋaŋa ndo. ");
INSERT INTO xsi_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ambo tamâta toŋge ŋa nde ŋalae, ande ŋinde ma kura tu ipono nzâla ŋana mateŋa kâ, ande ma tia. I ma imâte, itogo ŋgoa ŋgoi simâte mine. ");
INSERT INTO xsi_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Maro Kindeni Kaika Warika, ina Yova Kindeni, ande iporo ŋgua. I ne sarawâŋa ilâ panzi tamâta rârâni simo nia ndoni lâ tâno kulu, kinzi pa mbwera kâ wa kinzi pa wâra kâ wa. ");
INSERT INTO xsi_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Maro Kindeni imo Saion lawea ara ŋinde, aku ne walo isinala nia ndoni lâ tâno kulu itogo sinâla mine. ");
INSERT INTO xsi_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Kala ŋine kinda nenda Maro Kindeni ŋga imâ, andeta i ŋandai nao mwasa ŋga. Yââ ŋalae nde iyoka imuŋga papa ku ikana kelekele, aŋga mbilu ŋalae nde iŋge i lâ. ");
INSERT INTO xsi_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","I nde isarawanzi samba tava tâno tu simâ simora i itunzi ne tamâta sondo. ");
INSERT INTO xsi_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Maro Kindeni iporo mine tu, “Naneŋgu tamâta, miki ŋine uru kawâŋgi pa naŋa, miki ŋine muŋga kaveta patarawâŋa pana ŋana itula nenda ŋgua pâŋa pwataki kâ, miki kapagona lâ taitu ku kamâ pana.” ");
INSERT INTO xsi_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Maro Kindeni kawa ŋgua ŋinde nde duvi mine; i nde ŋgua-samâŋa tamwata. Nia maa ikeno âta ŋinde itula pwataki tu Maro Kindeni nde vetâŋa sondo warika. ");
INSERT INTO xsi_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Maro Kindeni iporo tu, “Naneŋgu tamâta, miki kaloŋo ŋga. Naŋa iloŋgu ŋgua pami. Miki Isrel ŋgu, naŋa ma aomi kamandi ŋgua nia, aku ma nasowe ŋgua lâ tinimi. Naŋani nde miki nemi Maro Yova Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Naŋa ŋandai aporo tu nemi mâsi ŋana kaveta patarawâŋa pa naŋa kâ nde mâsi soki ŋga. Aku naŋa ŋandai aleleami ŋana patarawâŋa kie-kie miki uru kamomo lâ yââ kulu ku kakai kamâ pa naŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Taitu naŋa iloŋgu pa bulmakao tamâne tâku meme toŋge imo nemi ŋgumbi ilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Ŋana tu simbi ŋgoi rârâni simo dugu ilo ŋinde nde naŋa warakâŋgu nâ neŋgu. Aŋga bulmakao ndoni simo tuu rârâni kulunzi ande naŋa warakâŋgu nâ neŋgu tona. ");
INSERT INTO xsi_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Aŋga sii ndoni wa kelekele rârâni simo vianzi lâ leu ilo, kinzi ŋinde rârâni nde naŋa warakâŋgu nâ neŋgu tona. ");
INSERT INTO xsi_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Ambo naŋa ma putole ipuna, ande naŋa ma aporo atula ŋinde pwataki pami tia, ŋana tu tâno tava kelekele ndoni ikeno tâno ilo ŋinde nde naŋa warakâŋgu nâ neŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Tiambo miki katu naŋa uru aka bulmakao tamâne mbatunzi, a? Tiambo miki katu naŋa uru anu meme seenzi, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Naŋa iloŋgu tu miki ma kawami ndaŋge pa naŋa, aku ŋinde ma ipâŋga itogo nemi patarawâŋa mao mine. Aku vetâŋa ndia miki muŋga kapa ŋgua kuku Maro Kindeni âta Tamwata ŋana ma kaveta kâ, ande naŋa iloŋgu tu miki ma kaveta vetâŋa ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Lâ zo ŋana malia itu imâ ipâŋga pami, ambo miki ma kasarâwa pa naŋa, ande naŋa ma avilami. Ŋineŋga miki ma kapanea naŋa kasuka ŋâŋgu kâki.” ");
INSERT INTO xsi_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Aŋga kinzi tamâta sakamao, ande Maro Kindeni iporo ŋgua kaŋa mine panzi; “Ŋana sâ kâ ŋga miki katula naneŋgu ŋgua tukuŋa pwataki lâ kawami, a? Ŋana sâ kâ ŋga miki katapâri ŋana tukuŋa ŋinde naŋa muŋga alami, a? ");
INSERT INTO xsi_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Miki tinimi pwâka tu naŋa ma apananami, aku kapu mulimi pa naneŋgu ŋgua tukuŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Miki kaveta mete kunzi nzanzare tamwatanzi rârâni taitu-taitu. Aku miki uru kasaŋona kunzi tamâta ŋinde muŋga sipakâe, andeta kala ŋine sitambira warakanzi tininzi potomule. ");
INSERT INTO xsi_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ikura zo zo miki kandeka ŋana kaporo ŋgua sakamao wa ŋgua laŋeŋa wa. ");
INSERT INTO xsi_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Miki kandeka ŋana kasowe ŋgua laŋeŋa lâ taimi-tuami tininzi wa katu laginanzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Miki uru kaveta mine, andeta naŋa kawâŋgu buu nâ. Mine kala miki ilomi patea tu naŋa iloŋgu ara ŋana nemi vetâŋa kâ. Andeta tia ndo! Kala ŋine naŋa ambita miki pâta lâ, aku natula nemi vetâŋa potomule ipâŋga nia yo lâ ŋgua nia. ");
INSERT INTO xsi_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Miki tamâta ŋine kala kapu mulimi pa naŋa lâ, miki kaloŋo sondo ŋga. Tia ma naŋa azavarumi ndo lâ, aku tamâta toŋge ma ikura tu ivilami tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Ambo tamâta toŋge kawa ndaŋge pa naŋa, ande ŋinde ipâŋga itogo i ne patarawâŋa ara ndo, aku patarawâŋa mine isuka naŋa ŋâŋgu kâki. Mao nâ, naŋa ma avilanzi tamâta rârâni uru sipakatona warakanzi nenzi vetâŋa sondo.” ");
INSERT INTO xsi_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Maro Kindeni, noko ne tini-mwasa uru ikeno mine ku imo nâ. Mine nde naŋa ano pano tu kalo-sukâŋa ŋanana. Noko nde kalo sukâŋa warika; mine kala ano pano tu kuzavaru naneŋgu vetâŋa potomule rârâni piti lâ tiniŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kupua naneŋgu kiesaka rârâni ne muso piti lâ iloŋgu. Kusoki naneŋgu vetâŋa potomule rârâni piti, aku kuveta iloŋgu ipâŋga mbâra-mbâra ndo. ");
INSERT INTO xsi_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Naŋa asama tu naŋa nde kiesaka tamwatâŋgu. Naŋa akura tu kaloŋgu kapa ŋana naneŋgu vetâŋa potomule kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Naneŋgu kiesaka ŋinde, ande naŋa aveta pa noko simbo nâ. Naŋa aveta sakamao lâ noko nao. Mine nde noko kuveta mâsi sondo ku kupole naŋa lâ ŋgua nia. Noko pwatu naneŋgu vetâŋa soki ŋinde pana, aku ŋinde nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Mao nâ, nia ndoyo, lâ zo ŋinde nana ipaguguana apâŋga lâ, ande naŋa amo aveta vetâŋa sakamao nâ. Lâ zo ŋinde naŋa amo nana kapwa ilo yo, aku amo lee apâŋga lâ zo ŋine, ande naŋa amo kiesaka tamwatâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Noko ilo tu naŋa ma apono muli sondo pa noko ne ŋgua mao. Mine nde naŋa ano pano tu kupananana ŋana noko ne ilo-kalo ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ambo noko ma kuzavaru naneŋgu kiesaka piti lâ, ande naŋa ma apâŋga iloŋgu mbâra-mbâra. Ambo noko ma kupua iloŋgu, ande ŋinde ma ipâŋga zuzuli ku pâne ndo, itogo lââ ne mira ndumu-ndumu mine. ");
INSERT INTO xsi_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Naŋa ano pano tu kuo ndekâŋa lâ iloŋgu kilo. Mao nâ, noko kutawa naŋa ndue ndo lâ ku pwatu naneŋgu kiesaka kulu pana. Andeta kala ŋine naŋa atu andeka kilo. ");
INSERT INTO xsi_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Noko ma kulea pa naneŋgu kiesaka ŋinde kilo ndimo. Naŋa iloŋgu tu noko ma kuzavaru naneŋgu vetâŋa sakamao rârâni piti ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Maro Kindeni, naŋa iloŋgu tu noko ma kuveta iloŋgu kaloŋgu ipâŋga zuzuli ndo. Kuo ilo-kalo wasaseki imâ iloŋgu, ŋana naŋa ma akura tu apono muli sondo pano. ");
INSERT INTO xsi_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Naŋa tiniŋgu pwâka tu noko ma kusoki naŋa amo malawae ŋanano. Aku naŋa tiniŋgu pwâka tu noko ma pwai ne Koroani saŋena. ");
INSERT INTO xsi_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Noko uru kuvila naŋa, aku muŋga noko ne pavilâŋa ŋinde iveta naŋa iloŋgu ndeka. Kala ŋine naŋa iloŋgu tu noko ma ndekâŋa ŋinde kulua naŋa taulo imâ kilo. Naŋa ano pano tu kusukana ku kugagati iloŋgu kaloŋgu tu ma apono muli pa noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ambo noko ma kuveta mine, ande naŋa ma apanananzi kiesaka tamwatanzi ŋana vetâŋa ara rârâni noko ilo papa ŋinde. Ŋineŋga kinzi ma sipalele ilonzi kalonzi ku ma sitaulo simâ pa noko kilo. ");
INSERT INTO xsi_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Maro Kindeni, naneŋgu Pavilâŋa Tamwata noko. Noko ma kupu naŋa pâta amâte ndimo. Ambo noko ma kalo sukâŋa ŋanana, ande naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ atula pwataki tu noko kuveta vetâŋa sondo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Maro Ŋalae, ambo noko ma kuvilana, ande naŋa ma aporo pwataki apanea noko ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Noko ilo tu naŋa ma akai kelekele pinde ku aveta patarawâŋa pano, ande tia. Ambo naŋa ma amomo simbi lâ yââ kulu ku ao imâ pano, ande noko ma kundeka ŋalae koŋa ŋana patarawâŋa ŋinde kâ, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Andeta Maro Kindeni, kala ŋine naŋa ma aveta patarawâŋa kie toŋge pano, aku noko ma ilo ara ŋana. Naŋa ma apatawa warakâŋgu tiniŋgu ku apauwo warakâŋgu amo noko kalo. Naŋa asama tu ambo tamâta toŋge ilo malia ŋana ne kiesaka kâ kala ipalele ilo kalo ku ipatawa tamwata tini lâ noko nao, ande noko ma kupu muli papa i nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Aku Maro Kindeni, naŋa iloŋgu tu noko ma kalo sukâŋa ŋananzi Isrel ŋgu tava, aku kuveta kie ara panzi. Naŋa ano pano tu kupa Jerusalem lawea ne ŋgumbi mira kâki kilo. ");
INSERT INTO xsi_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ŋineŋga noko ma ilo ara nâ ŋana patarawâŋa sondo ŋinde maka ma kaveta pano, patarawâŋa kie-kie ŋinde maka ma kamomo lâ yââ. Aku maka ma kapatarâwa bulmakao tamâne lâ noko ne patarawâŋa nia tona. ");
INSERT INTO xsi_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Noko tamâta kaika ndaina, ŋana sâ kâ ŋga kupasuka tamwata tini ku kundeka koa tia nâ ŋana vetâŋa potomule ŋinde muŋga kuveta panzi Maro Kindeni ne tamâta, a? Maro Kindeni uru iveta ikura i ne ŋgua pâŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Noko laŋeŋa tamwata, noko ne ŋgua nde itogo pila mata ndo, aku ŋinde uru izavarunzi tamâta. Ikura zo rârâni noko ilo tu ma kuyaulanzi tamâta pinde. ");
INSERT INTO xsi_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Noko ŋandai ilo pa vetâŋa ara ŋga, aku noko ŋandai ilo tu kuporo ŋgua mao ŋga. Noko ilo tu kuporo ŋgua laŋeŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Noko kawa laŋeŋa! Noko ilo pa ŋgua ndia uru iyaulanzi tamâta pinde. ");
INSERT INTO xsi_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Andeta kuloŋo ŋga; Maro Kindeni ma izavaru noko ndo lâ. I ma ikaino kaika ku ma iŋarano ŋana noko ne luma kâ. I ma izavaru noko ndo lâ, kala noko ma kumo via lâ tâno ŋine kulu kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Tamâta pinde uru siveta vetâŋa ara, aku kinzi ŋinde ma simora mâsi mine ipâŋga pano ku ma siruru pâta. Kinzi ma siŋeleano ku ma siporo tu, ");
INSERT INTO xsi_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Kamora ŋga, tamâta ndai tini pwâka tu Maro Kindeni ma ikea ŋana i kâ. I kalo tawana tu i tamwata ne mbaliŋa ma ivila i, aku i kalo tawana tu vetâŋa sakamao nâ ma iveta i imo sondo.” ");
INSERT INTO xsi_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Aŋga naŋa nde amo atogo i, ande tia ndo. Naŋa kaloŋgu tawana tu Maro Kindeni ne tini-mwasa ma ikeno pa naŋa ikura zo rârâni. Mine nde amo ara nâ, atogo kâi “oliv” toŋge imandi Maro Kindeni ne luma sapâŋa tini laiti mine. ");
INSERT INTO xsi_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Maro Kindeni, noko kuvila naŋa lâ. Mine kala ikura zo rârâni naŋa ma kawâŋgu ndaŋge pano, aku ma amandi noko ne tamâta naonzi ku ma apanea noko ŋa aporo tu, “Maro Kindeni iveta kie ara ndo pa naŋa”. ");
INSERT INTO xsi_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Kinzi tamâta kapa-kapa uru siporo lâ warakanzi ilonzi mine tu, “Maro Kindeni nde maro kaa nâ”. Kinzi tamâta ŋinde nde tamâta sakamao ndo. Kinzi uru siveta vetâŋa potomule nâ. Tamâta toŋge uru iveta vetâŋa ara nâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Maro Kindeni imo samba ilo, aku i mata ndue ilea pa kinzi tamâta. I itu isama mine: tiambo tamâta pinde simo tava ilo-kalo ara, tiya? Tiambo tamâta pinde ilonzi tu simâ papa i, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Andeta tia. Kinzi rârâni sipile nzâla ara marumbu lâ. Kinzi rârâni nenzi vetâŋa taituni, kinzi nde tamâta sakamao ndo. Tamâta toŋge uru iveta vetâŋa ara nâ, ande tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Maro Kindeni imora ŋine kala iporo mine tu, “Tiambo kinzi tamâta ŋinde nenzi ilo-kalo tia tâ. Kinzi rârâni uru siveta vetâŋa sakamao. Kinzi sizavarunzi naneŋgu tamâta, itogo sika kâpwa mine, aku uru sikai noŋa pa naŋa tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Andeta tini nâ kinzi ma siruru pâta kanaŋo. Muŋga kinzi ŋandai sisama ruruŋa kie mine ŋga. Ŋana tu Maro Kindeni ma izavarunzi ne tamâta kinda nenda kazâŋa tamâta marumbu lâ. I ipu muli panzi lâ, ku ma ipolenzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Naŋa iloŋgu tu Maro Kindeni ma isupwa kinda Isrel ŋgu nenda Yautâŋa Tamâta iyoka pa Saion Tuu indue imâ. Yakopu ne vâsa ŋgu Isrel ma sindeka ŋalae tina lâ ŋinde zo Maro Kindeni ma ivilanzi ne tamâta kala ma simo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Maro Kindeni, noko Walo Tamwata, naŋa ano pano tu kuvilana! Kumandi tava ne kaika ŋalae ŋinde ku pwai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Maro Kindeni, kupaloŋo pa naneŋgu noŋa. Kutambira taŋa sondo pa naŋa kawâŋgu ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Kinzi taŋa-kaika tamwatanzi nde simâ sipâŋga lâ, kala situ sikai kazâŋa pa naŋa. Kinzi uru siveta kenzi sakamao nâ panzi tamâta pinde, aku kala ŋine kinzi situ sipu naŋa pâta amâte. Kinzi ilonzi tu Maro Kindeni nde maro kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Andeta Maro Kindeni imo naneŋgu Pavilâŋa Tamwata. Mao kanaŋo, Maro Ŋalae uru ikatona naŋa ku ivetana amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Naŋa iloŋgu tu i ma nâna ilanzi naneŋgu kazâŋa tamâta ŋinde. Vetâŋa sakamao ndia kinzi situ siveta pa naŋa, ande naŋa iloŋgu tu i ma iveta vetâŋa taituni nâ pa kinzi warakanzi. Maro Kindeni, noko uru kuveta ikura ne ŋgua pâŋa rârâni. Mine nde naŋa ano pano tu kuzavarunzi kazâŋa tamâta ŋinde ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Yova Kindeni, naŋa ma andeka nâ ŋana aveta patarawâŋa pano. Naŋa ma kawâŋgu ndaŋge ŋalae pano, ŋana tu noko ilo pa ŋgua mine. ");
INSERT INTO xsi_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Noko pwai naŋa piti lâ naneŋgu malia rârâni ilo marumbu lâ. Naŋa matâŋgu amora noko kuzavarunzi naneŋgu kazâŋa tamâta lâ. ");
INSERT INTO xsi_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Maro Kindeni, kupaloŋo pa naneŋgu noŋa. Noko ma kupono taŋa pa naneŋgu sarawâŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Naŋa ano pano tu kutambira taŋa pa naŋa kawâŋgu ŋgua, aku kutu ŋgua pana itaulo imâ. Malia ŋine iveta naŋa iloŋgu kura tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Kinzi kazâŋa tamâta siporo kaika tu ma sizavaru naŋa. Kinzi tamâta sakamao ŋinde nde sitawa naŋa ndue ndo lâ, kala iloŋgu putuka ŋalae. Kinzi siveta malia pa naŋa, aku wisinzi nâna sikai kazâŋa sakamao pana. ");
INSERT INTO xsi_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Naŋa wisiŋgu nde ikâki lâ, aku tiniŋgu ruru. Naŋa aruru tu ma amâte, aku ŋinde iveta iloŋgu malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Mao nâ, naŋa aruru pâta kanaŋo, aku tiniŋgu ruru ndo. Ruruŋa nde ipu naŋa ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Mine kala naŋa aporo mine tu, “Naŋa iloŋgu tu akai mbaniŋgu, itogo sii mbaninzi mine. Ŋineŋga naŋa ma alou akâwa alâ asânda nia toŋge ŋana apwarea kâ, aku ma amo ara lâ nia ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Naŋa ma alou alâ pa nia bilimu toŋge ikeno malawae ŋinde, aku ma amo niani ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Naŋa ma alâ walele nâ asânda nia toŋge ŋana apavea warakâŋgu kâ, aku ma amuna ŋana mbilu wa mbamba wa.” ");
INSERT INTO xsi_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Naŋa amoranzi tamâta sipara potomule lâ lawea ŋalae ilo. Mine nde Maro Ŋalae, naŋa iloŋgu tu noko ma kuyaula nenzi ŋgua ku kuzavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Kinzi soka lawea ne ŋgumbi mira ŋalae kulu ikura kari wa mbo wa, aku vetâŋa soki kie-kie nde ipipi lâ ikeno lawea ne ŋgumbi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Zavaruŋa ne mâsi nde ipâŋga ŋalae lâ lawea ilo. Lâ nzâla ŋgaŋe-ŋgaŋe wa pasauŋa nia wa, ande kinzi tamâta kaika uru siveta malia panzi tamâta pinde ku sikai laŋeŋa panzi. ");
INSERT INTO xsi_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Aku kinzi siveta malia mine nâ pa naŋa tona. Ambo naneŋgu kazâŋa tamâta simbonzi nâ ma siveta “a” pa naŋa, ande naŋa ma iloŋgu malia ŋalae koŋa tia. Ambo naneŋgu kazâŋa tamâta simbonzi nâ ma sipasuka warakanzi tininzi ŋana sitawa naŋa ndue kâ, ande naŋa ma akura tu tiniŋgu piti ŋananzi. ");
INSERT INTO xsi_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Andeta niŋgu-nambwe, nokoni tamwata kuveta vetâŋa kie mine pa naŋa, aku ŋine iveta iloŋgu malia ndo. Noko nde naŋa nawalâŋgu ma, aku kinda rua tamo nambwe nambwe. ");
INSERT INTO xsi_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Kinda rua muŋga toka taitu wa tapaloŋo wa, aku talâ pa Maro Kindeni ne luma sapâŋa tatavanzi tininda pinde. Mine nde ŋana sâ kâ ŋga noko tamwata pwai kazâŋa pa naŋa, a? ");
INSERT INTO xsi_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Mao nâ, ilo-kalo sakamao nde ipipi lâ ikeno naneŋgu kazâŋa tamâta ŋgininzi. Mine kala naŋa iloŋgu tu kinzi ma sipamateteu walele nâ. Naŋa iloŋgu tu kinzi ma vianzi nâ silâ pa mateŋa nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Andeta naŋa ano pa Maro Yova Kindeni tu i ma ivila naŋa ku ikaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Lâ mboyo ŋaŋa yo wa kari imâ ŋgini wa lala pararai wa, ande naŋa uru ata pa i ŋana malia kala itu iyaula naŋa ŋine. Aku i ma ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Kinzi kazâŋa tamâta rârâ ŋinde nde sipara kuku naŋa, andeta naŋa ma akai nzimba toŋge tia, ŋana tu Maro Kindeni ma ikea ŋanana ku ma ikaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Nia ndoyo, aku imâ lee ipâŋga lâ zo ŋine, ande Maro Kindeni imo Koipu Ŋalae mine ku imo nâ. I tamwata ma ipaloŋo pa naneŋgu noŋa ku ma ipolenzi naneŋgu kazâŋa tamâta, ŋana tu kinzi tininzi pwâka tu sipalele ilonzi kalonzi, aku ŋandai siruru ŋana i ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Niŋgu-nambwe ŋinde uru ipara kunzi ne mete, aku ŋgua pâŋa i muŋga iveta ŋinde, ande ipu ututu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","I uru iporo ŋgua kaŋa mona-mona nâ, andeta nânâo nde ipipi lâ ikeno i ilo. I ne ŋgua uru iveta ninambwe kinzi wisinzi pisi nâ, andeta i ne ŋgua ŋinde nde ŋana iyaulanzi kâ, itogo pila mata ruru ndo mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Malia kie-kie nde uru ipâŋga pa kinda. Ambo noko ma kuo malia ŋinde lâ Yova Kindeni mbau ilo, ande i ma ikale malia ŋinde pano, ku ma ipu tini kaika pa noko ilo kalo. I ma isâu pa sâ toŋge tu iyaulanzi tamâta ŋine uru sipono muli papa i, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Andeta Maro Kindeni, noko ma pwainzi laŋeŋa tamwatanzi ŋinde uru sipunzi tamâta pâta simâte, aku ma kutambiranzi sindue silâ pa mateŋa nianzi. Kinzi tamâta sakamao ŋinde nenzi zo ŋana simo vianzi lâ tâno kulu kâ nde ma marumbu tia yo yo, andeta kinzi ma sipamateteu. Aŋga naŋa warakâŋgu ma ao naneŋgu kalo-tawana ilâ sondo pa noko nâ ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Maro Kindeni, kinzi kazâŋa tamâta sitaŋgula naŋa ŋana sipara kuna. Mine kala naŋa ano pano tu kuo ne wisi-wisi imâ pana. Ikura zo rârâni kinzi siveta kenzi sakamao papa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Kinzi sikai kazâŋa pa naŋa lâ mboyo ŋaŋa lâ, aku ilâ lee ipâŋga mbo. Kinzi tamâta kambwaŋenzi ŋalae nde sipasuka warakanzi tininzi ku sipara kuku naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Andeta Maro Kindeni Walo Tamwata, lâ zo ndia naŋa aruru, ande naŋa ma ao naneŋgu kalo-tawana imâ pa noko nâ. ");
INSERT INTO xsi_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Naŋa kaloŋgu tawana Maro Kindeni. Naŋa uru apanea i ŋa asuka kâki, ŋana tu muŋga i ipa ŋgua tu ma ivila naŋa. Naŋa kaloŋgu tawana Maro Kindeni, kala aruru ŋana sâ toŋge tia. Kinzi tâno tamâta ma sikura tu siveta sâ toŋge pa naŋa, nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Andeta vetâŋa ndia rârâni naŋa atu aveta, ande naneŋgu kazâŋa tamâta sipono nzalâŋgu kala akura tu aveta tia. Ikura zo zo kinzi siroto nzâla ŋana sizavaru naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Kinzi uru sipasau lâ nia paveâŋa ku sio ŋanana, ŋana ma sipu naŋa pâta amâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Maro Kindeni, naŋa iloŋgu tu noko ma kupare nia panzi ŋana vetâŋa soki kinzi siveta ŋinde. Naŋa iloŋgu tu noko ma wisi nâna panzi ŋgu ŋinde ku kutawanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Noko kusama tu naŋa iloŋgu malia ndo, kala amo ata nâ. Mao nâ, noko kusowe naŋa matâŋgu sulu ŋine kambwaŋenzi lâ, aku noko kalo sukâŋa ŋana ŋinde rârâni taitu-taitu. ");
INSERT INTO xsi_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Maro Kindeni, naŋa asama noko kilala tu noko nde naneŋgu Pavilâŋa Tamwata. Mine nde muli, lâ zo ŋinde naŋa ma asarâwa pano, ande naŋa asama tu noko ma kusokinzi naneŋgu kazâŋa tamâta sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Naŋa kaloŋgu tawana Yova Kindeni, inani muŋga ipa ŋgua tu ma ivilana. Mine nde naŋa uru apanea i ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Naŋa kaloŋgu tawana Maro Kindeni, kala aruru ŋana sâ toŋge tia. Kinzi tâno tamâta ma sikura tu siveta sâ toŋge pa naŋa, nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","13","Maro Kindeni, noko pwai naŋa piti lâ kazâŋa ilo marumbu lâ, kala naŋa ŋandai amâte ŋga. Noko kuvila naŋa lâ, kala kinzi kazâŋa tamâta sikura tu sipole naŋa, nde tia. Mine nde Maro Kindeni, naŋa ma apono muli pa noko nâ, aku ma ayoka noko ne sinâla nâ ilo lee ikura zo rârâni amo viâŋgu. Aku vetâŋa ŋinde naŋa apambwâre lâ tu ma aveta pano, ande naŋa ma aveta vetâŋani ndaina tava. Aku naŋa ma ao naneŋgu patarawâŋa imâ pano, ŋana itula pwataki tu naŋa kawâŋgu ndaŋge ŋalae pano. ");
INSERT INTO xsi_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Maro Kindeni, naŋa amâ pa noko tu ma pwatonana. Mine nde ano pano tu kalo sukâŋa ŋanana. Lâ zo ŋana naŋa amo noko tini laiti, ande naŋa amo ara nâ, itogo tatareko natu sipavea simo ara lâ tinanzi mbani kalo mine. Mine nde naŋa iloŋgu tu ma amo mine lee ikura lâ zo ndia kazâŋa ŋine ma marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Naŋa asarâwa pa Maro Kindeni âta Tamwata tu ma ivila naŋa. Ina uru iveta kie ara pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","I imo samba ilo, aku i ma ipaloŋo pa naneŋgu noŋa ku ma ikaina piti lâ kazâŋa ilo. I ma ipolenzi tamâta ŋinde situ sizavaru naŋa. Maro Kindeni ma itula pwataki tu i ilo ndo ikeno pa naŋa ikura zo rârâni, aku i ma itula pwataki tu i uru iveta ikura ne ŋgua pâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Naŋa amo kinzi tamâta sakamao ŋgininzi. Kinzi nde sitogo mbwâmbwa saka “leve” ŋinde uru sio ŋananzi tamâta tu ma sikanzi kâ. Kinzi niŋonzi nde mata-mata ndo, itogo sagawu wa ua wa, aŋga memelanzi nde itogo pila mata ndo mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O Maro Kindeni, naŋa iloŋgu tu noko ma kuveta mâsi toŋge ipâŋga samba tini, ŋana itula noko kilala pwataki tu noko tamwata nde kumo Maro Ŋalae. Naŋa iloŋgu tu noko ma kuveta ne walo kaika ipâŋga nia yo panzi tamâta ndoni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ŋana tu naneŋgu kazâŋa tamâta nde sio nimbu tu sikai naŋa kaika kâ. Mine nde malia ŋalae itu ipu naŋa ndue ndo. Kinzi sikale tâno wewe ŋalae sipono nzalâŋgu ŋana ma patana andue ilo kâ. Andeta naŋa ŋandai patana ŋga. Kinzi warakanzi patanzi sindue wewe ŋinde ilo marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Mine nde Maro Kindeni, naneŋgu kalo-tawana nde ikeno kaika pa noko nâ. Mao nâ, naŋa kaloŋgu tawanano sondo ndo, aku naŋa ma awâŋgi apanea noko ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Lâ mbone-mbone nâ, naŋa ma apagagati warakâŋgu amandi sânda lâ kenoŋa nia, aku ma ara naneŋgu wâŋgu. Naŋa ma awâŋgi wâŋgiŋa mine lee mbwale pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Maro Ŋalae, naŋa ma amandi kinzi tinikoa ŋgu naonzi, ku ma kawâŋgu ndaŋge pa noko. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pano lâ tamâta ŋgu rârâni ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Ŋana tu noko ne tini-mwasa nde kiri-mwata tia ndo. Ŋinde ikeno mine ku imo nâ, aku ne keri nde ilâ ikura lâ nia maa ikeno âta ŋinde. Ikura zo zo noko uru kuveta ikura ne ŋgua pâŋa rârâni, aku mâsi ŋinde nde ŋalae ndo, ipole take-take ikeno samba tini ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O Maro Kindeni, naŋa iloŋgu tu noko ma kuveta mâsi toŋge ipâŋga samba tini, ŋana itula noko kilala pwataki tu noko tamwata nde kumo Maro Ŋalae. Naŋa iloŋgu tu noko ma kuveta ne walo kaika ipâŋga nia yo panzi tamâta ndoni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Miki tamâta ŋalaŋala, tiambo miki uru kaporo ŋgua sondo lâ ŋgua nia, a? Tiambo miki uru kalea sondo pa tamâta nenzi ŋgua rârâni ku kaveta kemi sondo panzi, a? Tia ndo kanaŋo! ");
INSERT INTO xsi_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Ikura zo zo miki uru kalomi ŋgere ŋana kaveta vetâŋa sakamao nâ. Aku miki kamandi kaika ŋana kazavarunzi tamâta lâ nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Kinzi tamâta sakamao uru sipile nzâla ara ikura nenzi mbwera rârâni. Nia ndoyo, lâ zo ŋinde tinanzi sipaguguanzi sipâŋga lâ, aku simo lee sipâŋga koŋa lâ, ande kinzi kawanzi laŋeŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Kinzi nenzi ŋgua nde itogo mwâta saka kawa sulu mwasina. Aku tininzi pwâka tu siloŋo ŋgua ara, kala sipono taŋanzi. ");
INSERT INTO xsi_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Kinzi sitogo tamâta taŋa pasâe mine. Ambo i tini pinde ma sisarâwa papa tu imâ, ande i ma imâ tia, ŋana tu iloŋo kawanzi ŋgua tia. ");
INSERT INTO xsi_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Maro Kindeni, naŋa iloŋgu tu noko ma kuzavarunzi tamâta sakamao ŋinde. Yova Kindeni, kinzi sitogo mbwâmbwa saka “leve” uru imo ikai kazâŋa nâ. Mine nde ara ŋana noko ma kumbware niŋonzi kupasu piti lâ kawanzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Naŋa iloŋgu tu kinzi ma naonzi tia lâ, itogo lââ irere ilâ tâno ilo ku mâsa-mâsa lâ mine. Naŋa iloŋgu tu noko ma kie nâ kupalenzi kunukianzi, itogo tamâta inuki unza kala ŋgâla-ŋgâla lâ. ");
INSERT INTO xsi_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Naŋa iloŋgu tu noko ma kuyaulanzi ndo, itogo ŋgola imâte ku isâmbu lâ paulo kulu mine. Naŋa iloŋgu tu kinzi ma simâte itogo lâlu toŋge imâte lâ tina kapwa ilo mine. ");
INSERT INTO xsi_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Maro Kindeni ma izavaru kinzi tamâta mine walele nâ, itogo tamâta ilamo leu mine. I ma wisi nâna ŋalae tina panzi, ku ma itambiranzi itogo tamâta itambira meme mine. ");
INSERT INTO xsi_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Mao nâ, Maro Kindeni ma ipare nia panzi kiesaka tamwatanzi. Kinzi ma sipamateteu, aku seenzi ma ilâ isala nia ndoni. Kinzi tamâta ara ma simora ŋine, kala ma simo sindeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Ŋineŋga kinzi tamâta ma siporo tu, “Mao nâ, Maro Kindeni uru kulu ara ndo ilanzi tamâta ŋinde sipono muli papa i. Mao nâ, Maro Kindeni imo, aku ionzi tamâta rârâni silâ ŋgua nia ŋana nenzi vetâŋa kâ.” ");
INSERT INTO xsi_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Naneŋgu Maro Kindeni, naŋa ano pano tu pwaina piti lâ naneŋgu kazâŋa tamâta mbaunzi ilo. Naŋa ano pano tu pwea ŋanana, ŋana kinzi ma sizavaru naŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Pwaina piti lâ kinzi tamâta sakamao mbaunzi ilo. Kuvila naŋa, ŋana kinzi ma sikura tu sipu naŋa pâta amâte, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Kumora ŋga, kinzi simuna ku sio ŋana sipu naŋa pâta amâte kâ. Kinzi tamâta kaika nde sipagona lâ ku ilonzi taitu situ siyaula naŋa. Andeta naŋa ŋandai aveta kiesaka toŋge tâku vetâŋa potomule toŋge ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Yova Kindeni, naneŋgu vetâŋa soki toŋge tia, taitu kinzi sipalilu simâ ŋana sipara kuku naŋa. Naŋa ano pano tu kumâ walele nâ ŋana kuvila naŋa kâ! ");
INSERT INTO xsi_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yova Kindeni, noko Maro Walo Tamwata, aku Isrel ŋgu nema Maro Kindeni kala noko. Kumâ walele ku kuzavarunzi tinikoa ŋgu ŋinde rârâni. Kinzi uru sio ninzi-nambwe silâ nenzi kazâŋa tamâta mbaunzi ilo; mine nde noko ma kalo sukâŋa ŋananzi ndimo. Naŋa ano pano tu kupare nia panzi tamâta sakamao ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ikura mbo mbo kinzi sitaulo simâ pa lawea ilo, aku ilonzi ŋuru-ŋuru soka potomule lâ lawea ne ŋgumbi mira ŋgaŋe-ŋgaŋe, sitogonzi mbwâmbwa niŋonzi ŋerere mine. ");
INSERT INTO xsi_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Yova Kindeni, kuloŋo ŋga; kinzi nenzi ŋgua nde sakamao ndo, itogo pila mata ruru ndo mwasina. Andeta kinzi siporo pa warakanzi tu, “Ea ma ikura tu iloŋo kinda, a?” ");
INSERT INTO xsi_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Andeta Yova Kindeni, noko uru kuŋeleanzi pâta ŋana nenzi ŋgua kaa kaa ŋinde. Noko kuveta “a” panzi tinikoa ŋgu rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Noko simbo nâ uru walo kaika kulua naŋa. Mine nde Maro Kindeni, naŋa amâ pa noko simbo nâ tu ma amuna ŋananzi kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Naneŋgu Maro Kindeni ilo ndo ikeno pa naŋa ikura zo rârâni, aku i ma imâ ivila naŋa. I ma isâu pa naŋa tu amora i ipolenzi naneŋgu kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Maro Ŋalae, noko kumo kutogo maka nema maramuŋa mwasina. Andeta naŋa tiniŋgu pwâka tu noko ma kupasusu ŋana kupunzi kazâŋa tamâta ŋinde pâta sipamateteu. Ambo noko ma kupunzi walele nâ, ande naneŋgu ŋgu ma muli kalonzi kapa ŋana noko ne pavilâŋa ara ŋinde. Mine nde naŋa ano pano tu kuŋaranzi tamâta ŋinde pwapwataki soka potomule silâ lee, ŋineŋga kuzavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Ŋana tu ikura zo zo kinzi nenzi ŋgua itula kilalanzi pwataki tu kinzi nde kiesaka tamwatanzi. Kinzi uru sipasuka warakanzi tininzi, aku naŋa iloŋgu tu nenzi mâsi ŋinde ma iyaula warakanzi, itogo viâŋa ikainzi iŋa mine. Ikura zo zo kinzi siporo ŋgua laŋeŋa wa ŋgua ŋana siyaulanzi tamâta pinde wa. ");
INSERT INTO xsi_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Mine nde ara ŋana noko ma wisi nâna panzi ku kupunzi pâta sipamateteu. Naŋa iloŋgu tu noko ma kuzavarunzi tamâta sakamao ŋinde ndo lâ. Ambo noko ma kuveta mine, ande tamâta rârâni ma sisama tu noko Maro Kindeni kumo maka Isrel ŋgu nema Koipu Ŋalae, aku noko kala kumo pwai maro panzi tamâta simo tâno ndoni tona. ");
INSERT INTO xsi_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Ikura mbo mbo kinzi tamâta sakamao ŋinde sitaulo simâ pa lawea ilo, aku ilonzi ŋuru-ŋuru soka potomule lâ lawea ne ŋgumbi mira ŋgaŋe-ŋgaŋe, sitogonzi mbwâmbwa niŋonzi ŋerere mine. ");
INSERT INTO xsi_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Ŋinde itogo kinzi soka silâ wa simâ wa siroto kapwanzi. Ambo kapwanzi pupuro tia yo, ande kinzi ilonzi ŋuru-ŋuru nâ. ");
INSERT INTO xsi_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Andeta kalo loko, naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ ŋana noko ne walo kaika ŋinde. Ikura mboyo mboyo naŋa ma awâŋgi atula pwataki tu noko ilo ndo ikeno pa naŋa, uru ikeno mine ku imo nâ. Ŋana tu lâ zo ndia malia kie-kie imâ ipâŋga pa naŋa, ande noko uru pwatona naŋa sondo ndo. Noko kumo kutogo naneŋgu maramuŋa kaika mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Maro Kindeni, noko simbo nâ uru kupu tini kaika pa naŋa iloŋgu kaloŋgu. Naŋa amâ pa noko simbo nâ tu amuna ŋananzi kazâŋa tamâta. Maro Kindeni, noko tini mwasa ndo pa naŋa ikura zo rârâni. Naŋa ma awâŋgi apanea noko ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Maro Kindeni, noko kupu muli pa maka marumbu lâ, kala kusâu panzi kazâŋa tamâta tu sipole maka. Noko wisi nâna pa maka kala kuveta mine. Andeta ŋine naŋa ano pano tu kutaulo kumâ ku kuvila maka kilo. ");
INSERT INTO xsi_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Noko kuveta maka nema tâno ririŋo lâ. Noko kundawea tâno kala mbââ ŋalae ipâŋga lâ. Kala ŋine nema tâno nde ipâŋga sakamao lâ. Ara, ŋine maka iloma tu noko ma kuveta tâno sondo kilo. ");
INSERT INTO xsi_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Noko kuo malia kie-kie imâ pa ne ŋgu maka. Mine nde maka kakai nâna ŋalae, kala kakura tu koka sondo tia. Ŋinde itogo noko lââ kaika kulama kanu lâ, aku kapâŋga kadauda ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Aŋga maka pinde nde kamege ŋanano, aku noko kusona mbila toŋge itâra ŋana kuvila maka kâ. Maka kakura tu kakâwa ŋananzi kazâŋa tamâta ku kalâ pa mbila ŋinde ŋana kamo ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Maro Kindeni, noko ilo ndo keno pa maka, aku ne walo nde ŋalae tina. Mine nde maka kano pano tu kupaloŋo pa nema noŋa ku pwaima piti lâ kazâŋa ilo, ŋana ma kamo ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Maro Kindeni imo i tamwata ne luma sapâŋa ilo, aku iporo tu, “Naŋa ma apole paraŋa, ŋineŋga ma andeka ŋana akisi keri lâ Sekem lawea tava Sekot ŋgu nenzi nia kawa ŋinde panzi naneŋgu tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Kinzi Ruben ŋgu aŋga kinzi Gat ŋgu nde naŋa warakâŋgu neŋgu tamâta, aku kinzi Manase ŋgu kala simo naneŋgu tamâta mine nâ. Kinzi Efraim ŋgu nde sitogo naneŋgu sambara kaika ŋana paraŋa kâ, aŋga kinzi Juda ŋgu nde sitogo koipu ŋalae ne tukâla ŋine uru ikeno naŋa mbauŋgu ilo. ");
INSERT INTO xsi_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Taitu naneŋgu morâŋa ikeno mine ŋananzi naneŋgu kazâŋa tamâta; kinzi Moap ŋgu nde ŋgu kaa nâ, itogo kondo naŋa uru apua mbauŋgu lâ ilo mwasina. Aku kinzi Idom ŋgu kala simo ŋgu kaa nâ tona, kala naŋa uru keŋgu nâ apalenzi. Naŋa apolenzi kinzi Filistia ŋgu lâ paraŋa ilo, kala andeka nâ akai lolove.” ");
INSERT INTO xsi_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Maro Kindeni, tiambo noko tini pwâka tu pwai naŋa alâ apara kunzi ŋgu ŋinde simo lawea ŋalae ilo, laweani ndaina ne ŋgumbi kaika iŋge mbwaliu lâ, tiya? Tiambo noko tini pwâka tu pwai naŋa alâ apara lâ Idom nenzi tâno, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Tiambo noko tamwata kupu muli pa maka marumbu lâ, tiya? Tiambo noko tini pwâka tu kuvilanzi nema zugu tamâta sipole paraŋa, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Maka kasama tu kinzi tamâta nenzi pavilâŋa nde kelekele kaa nâ. Mine kala maka kano pa noko tu kuvilama ŋana kapolenzi nema kazâŋa tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Mao nâ, ambo Maro Kindeni ma ivila maka, ande maka ma kapole paraŋa. I tamwata ma izavarunzi nema kazâŋa tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Maro Kindeni, kupaloŋo pa naneŋgu sarawâŋa. Kutambira taŋa sondo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Naŋa amo malawae ŋana naneŋgu lawea tina, aku iloŋgu malia ndo. Mine nde naŋa asarâwa pano tu kuvilana. Pwai naŋa alâ pa nia paveâŋa toŋge, ŋana kinzi kazâŋa tamâta ma sikura tu sizavaru naŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Ŋana tu noko simbo nâ uru pwea ŋanana. Noko simbo nâ kumo naneŋgu maramuŋa kaika. Mine nde naneŋgu kazâŋa tamâta sikura tu sipole naŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Naŋa iloŋgu ŋalae tu ma amo noko ne luma ilo ikura zo rârâni. Naŋa iloŋgu tu amo ara lâ noko tini laiti, itogo tatareko natunzi simo ara lâ tinanzi mbani kalo mine. ");
INSERT INTO xsi_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Maro Kindeni, muŋga noko kuloŋo naŋa aveta ŋgua pâŋa pinde kuku noko. Aku vetâŋa arara noko kupambwâre tu ma kuveta panzi tamâta ŋinde uru simege ŋanano, ande noko kuveta vetâŋani ndaina pa naŋa tava. ");
INSERT INTO xsi_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kala ŋine naŋa ano pano tu kuseŋge mbwera rârâ ilâ kuku zo ŋinde koipu ŋalae ma imo via lâ tâno kulu. Naŋa iloŋgu tu i ma imo mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Maro Kindeni, naŋa iloŋgu tu i ma imo koipu ŋalae lâ noko nao ikura zo rârâni. Noko ne tini-mwasa ikeno mine ku imo nâ, aku noko uru kuveta ikura ne ŋgua pâŋa rârâni. Mine nde ano pano tu pwatona i sondo ndo, ikura noko ne ŋgua pâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Ambo noko ma kuveta mine, ande naŋa ma kari kari ao patarawâŋa imâ pano, ikura naneŋgu ŋgua pâŋa mine. Aku naŋa ma awâŋgi apanea noko ŋa ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Naŋa kaloŋgu tawana Maro Kindeni simbo nâ. I simbo nâ ikai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","I simbo nâ ikatonana wa ivilana wa. I simbo nâ imo naneŋgu teŋgo kaika. Mine kala kinzi kazâŋa tamâta ma sikura tu sipole naŋa, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Miki tamâta ndai, miki ma kakai kazâŋa pa naŋa ku katu kayaulana ikura zo ŋapia kilo, a? Naŋa amo atogo ŋgumbi siŋga saputi ndue lâ, kala waloŋgu tia. Tiambo miki rârâni katu kazavaru naŋa ndo lâ, a? ");
INSERT INTO xsi_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Naŋa ŋâŋgu nde ŋalae, taitu miki ilomi tu ma katawa naŋa ndue. Miki uru kandeka ŋana ŋgua laŋeŋa nâ. Miki kawami nâ kaporo ŋgua ara mine tu, “Maka iloma tu Maro Kindeni ma iveta kie ara pano”, andeta ilomi tu i ma iyaula naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Naŋa kaloŋgu tawana Maro Kindeni simbo nâ, ku ao tiniŋgu pa i simbo nâ tu ma isukana. ");
INSERT INTO xsi_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","I simbo nâ ikatonana wa ivilana wa. I simbo nâ imo naneŋgu teŋgo kaika. Mine kala kinzi kazâŋa tamâta ma sikura tu sipole naŋa, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Maro Kindeni simbo nâ uru ikai naŋa piti lâ kazâŋa ilo, aku i tamwata iveta naŋa ŋâŋgu ipâŋga ŋalae. I imo itogo mira ŋalae naŋa uru amuna tini mwasina. I uru ikea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Mine nde miki naneŋgu ŋgu, naŋa apaimi tu miki ma kalomi tawana Maro Kindeni ikura zo rârâni. Miki ma kapatula nemi malia wa nemi ilo-kalo ndoni papa i, ŋana tu i imo itogo nenda teŋgo kaika mine. ");
INSERT INTO xsi_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Kinzi tamâta rârâni nde sitogo tamâta imbana koroani mbwani taitu lâ kawa ku ilâ kaa nâ. Mao nâ, kinzi mbaliŋa warakanzi aŋga kinzi sugorai tamwatanzi nde kelekele kaa nâ. Kinzi rârâni nde sitogo kelekele kiri-mwata lawea itapala kala nao tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Tamâta pinde situ mâsi ŋana taveta ruruŋa panzi tamâta kâ tava panaweŋa ne mâsi nde mâsi ara. Andeta miki ma ilomi mine ndimo, ŋana tu ilo-kalo mine nde soki ndo. Mao nâ, zo pinde miki ma kakai mbaliŋa, andeta miki ma ilomi tu mbaliŋa ŋinde ikura tu ivilami, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Muŋga naŋa aloŋo Maro Kindeni iporo pwataki tu ina nde walo kaika warika. ");
INSERT INTO xsi_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Andeta ŋinde nâ tia; naŋa aloŋo Maro Kindeni iporo pwataki kilo tu i ne tini-mwasa uru ikeno mine ku imo nâ. Mao nâ, Maro Ŋalae, noko tamwata ma kulu kulanzi tamâta rârâni taitu-taitu, ipakura kuku vetâŋa ndia muŋga kinzi siveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Maro Kindeni, naneŋgu Maro Ŋalae noko, naŋa iloŋgu ndo tu apono muli pano. Naŋa iloŋgu ndo ikeno pano, itogo tamâta imo nia bilimu ku irakoŋa ŋalae tina ŋana lââ kâ. ");
INSERT INTO xsi_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Naŋa iloŋgu tu amora noko kilala tava ne walo kaika ipâŋga nia yo lâ noko ne luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Maro Kindeni, noko ne tini-mwasa uru ikeno mine ku imo nâ, aku ŋinde nde kelekele ara ndo, ipole maka tamâta nema via lâ tâno ŋine kulu, aku ipole kelekele pinde rârâni tona. Mine kala naŋa apaneano asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Naŋa ma kawâŋgu ndaŋge pano ikura zo rârâni naŋa ma amo viâŋgu. Naŋa ma asuka mbauŋgu kâki akai noŋa pano. ");
INSERT INTO xsi_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Lâ zo ŋana naŋa amo noko tini laiti, ande naŋa ma iloŋgu ara nâ, itogo tamâta ika kâpwa ara lee kapwa pupuro ndo mwasina. Aku naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pano tava ndekâŋa ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Maro Kindeni, lâ zo ŋana naŋa akeno kenoŋa nia, ande naŋa uru kaloŋgu ŋgere ŋanano. Naŋa kaloŋgu ŋgere ŋanano mine lee mbwale pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Naneŋgu vetâŋa ŋinde nde duvi mine; noko kumo naneŋgu Pavilâŋa Tamwata ikura zo rârâni. Naŋa amo noko tini laiti, itogo tatareko natu imuna tina mbani kalo mine, aku andeka nâ awâŋgi pano. ");
INSERT INTO xsi_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Naŋa asaŋa noko kaika ndindi nâ, aku noko ne walo kaika uru ikea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Tamâta pinde situ sipu naŋa pâta amâte, andeta kinzini ma sisânda kazâŋa kulu ku ma silâ pa mateŋa nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Kinzi ma sipamateteu lâ paraŋa ilo, ŋineŋga kinzi mbwâmbwa ŋgoi ma sika mbatunzi. ");
INSERT INTO xsi_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Aŋga naŋa koipu ŋalae ma andekana Maro Kindeni ŋana i ne pavilâŋa ara ŋinde. Tamâta ea sipa ŋgua lâ Maro Kindeni nao, ande kinzi ŋinde ma sindeka ŋalae. Aŋga kinzi laŋeŋa tamwatanzi, ande i ma isae kawanzi. ");
INSERT INTO xsi_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Maro Kindeni, naŋa iloŋgu makisa ndo. Kupaloŋo pa naneŋgu noŋa ŋga! Naŋa aruru ŋananzi kazâŋa tamâta, kala ano pano tu pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Kinzi tamâta sakamao nde simuna ku sipa ŋgua ŋana siyaula naŋa kâ. Kinzi kawanzi pakâe pakâe siveta mâsi potomule nâ. Naŋa ano pano tu pwatona naŋa sondo. ");
INSERT INTO xsi_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Kinzi tamâta ŋinde nenzi ŋgua nde itogo pila mata ruru ndo mwasina. Nenzi ŋgua sakamao nde nao sondo imâ pana, itogo tamâta irae temba ku mata ilea sondo pa tamâta toŋge tu ma ipane kâ. ");
INSERT INTO xsi_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Kinzi simuna lâ nia ŋgaŋe ku silâwa nâ sipanenzi tamâta ara. Kinzi siruru tia ndo, aku sipanenzi walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Kinzi sipu tini-kaika pa warakanzi ilonzi kalonzi ŋana mâsi sakamao ŋinde muŋga sipa ŋgua tu ma siveta. Kinzi siporo ŋana nia pinde sipatea lâ ŋana sio nimbu tu ma ikainzi tamâta kâ. Aku kinzi siporo pa warakanzi mine tu, “Ea ma ikura tu imora kinda, a? Tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Kinzi sipa ŋgua ŋana siveta mâsi potomule kâ, aku siporo tu, “Kinda tapatea nzâla ara ndo!” Mao nâ, kinzi tamâta nenzi ilo-kalo nde ikeno paveâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Andeta Maro Kindeni ma silâwa nâ ipanenzi, aku ma patanzi sindue walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Muŋga kinzi tamâta sakamao ŋinde sipa ŋgua tu ma siyaula naŋa, andeta Maro Kindeni ilele nenzi ŋgua ŋinde ku iveta iyaula kinzi warakanzi. Tamâta pinde ma simoranzi ku ma siŋeleanzi wa sirurua kulunzi panzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ŋineŋga tamâta rârâni ma siruru. Kinzi ma kalonzi ŋgere ŋana mâsi ŋinde Maro Kindeni iveta lâ, aku ma sitapâri ŋana mâsi ndainani nâ. ");
INSERT INTO xsi_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Ara ŋana kinzi tamâta arara rârâni ma sindekana Yova Kindeni ku silâ simuna i tini laiti. Ara ŋana kinzi tamâta sondo rârâni ma sipanea i sisuka ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Maro Kindeni, ara ŋana maka ma kalâ kamandi Saion Tuu kulu ku kapaneano kasuka noko ŋa kâki. Aku ara ŋana maka ma kaveta vetâŋa rârâni ŋinde muŋga kapa ŋgua tu ma kaveta pano tona, ");
INSERT INTO xsi_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","3","ŋana tu noko uru kupaloŋo pa maka nema noŋa. Aku tamâta rârâni ma kalonzi ŋgere ŋana nenzi kiesaka kâ, ku ma simâ pano. Maka nema vetâŋa potomule nde itawama ndue ndo, andeta noko kuzavaru nema kiesaka ŋinde piti lâ tinima. ");
INSERT INTO xsi_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Maka kandeka ŋalae, ŋana tu noko kupatea maka lâ kala pwaima kalâ kamo noko ne luma ilo. Kelekele arara nâ nde ipipi lâ ikeno noko ne luma sapâŋa ŋinde ilo, aku maka ma iloma ndeka ŋana kakai kelekele ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Maro Kindeni, maka nema Yautâŋa Tamwata noko, noko uru kupaloŋo pa nema noŋa kala kuveta mâsi ŋalaŋala kie-kie ŋana kuvila maka kâ. Andeta maka nâ tia; kinzi tamâta simo tâno ndoni ikeno pa tâi tini pinde rârâni, kinzi ŋinde nde sio tininzi pa noko tu ma kuvilanzi. ");
INSERT INTO xsi_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Noko ne walo nde kaika; mine nde noko kuonzi tuu ŋalaŋala silâ simandi nianzi nianzi. Aku mâsi ŋinde itula pwataki tu noko ne walo nde ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Lâ zo ŋana kâla-lawea imandi tava ne nduŋeŋani, ande noko kuveta tâi pâti kii lâ. Aku noko uru kuveta vetâŋa kie taituni ŋana kupupu kinzi tinikoa ŋgu nenzi taŋa-kaika ndue tona. ");
INSERT INTO xsi_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Kinzi tamâta simo tâno ndoni nde simora mâsi ŋalaŋala noko kuveta ŋinde, kala wisinzi motutu. Lâ tâno ŋinde ikeno pa mbwera kâ, aku ilâ lee ipâŋga tâno ŋinde ikeno pa wâra kâ, ande kinzi tamâta sindeka ku sisuŋa kawanzi kâki ŋana sipaneano. ");
INSERT INTO xsi_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Noko ilo pa tâno; mine kala noko uru kuo karâzi imbe indue, aku kuveta tâno ne siŋi ipâŋga. Maro Kindeni, noko ne lââ nde ŋalae tina, kala kupaliŋi karâzi imbe ndue. Aku noko kuveta kâpwa kie-kie ipâŋga tâno ilo panzi tamâta tu sika. Noko tamwata ne pateâŋa nde ikeno mine. ");
INSERT INTO xsi_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Noko kuo karâzi ŋalae imbe indue pa tâno ŋinde muŋga tamâta sike. Noko kuo karâzi imbe indue ŋana iveta tâno mbariri, aku kuveta kaniŋa mata ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Noko kuveta kie ara ndo, kala zo ŋana kaniŋa gonâŋa kâ, ande kâpwa maria ipâŋga. Mao nâ, kelekele arara kie-kie nde ikeno pano. ");
INSERT INTO xsi_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Unza arara nde ipâŋga lâ tâno ŋinde kinzi lama uru simo, aku noko kuveta ndekâŋa ipâŋga lâ nia tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Kinzi lama ŋgu kambwaŋenzi ŋalae nde simandi nia unza ŋinde, aku kâpwa nde ipipi lâ nia kawa kawa rârâni. Mine kala kelekele rârâni nde sigogo kawanzi ku sindeka siwâŋgi wâŋgiŋa paneâŋa kâ pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Miki tamâta rârâni kamo tâno ndoni, miki rârâni kandeka ku kasarâwa kapanea Maro Kindeni kasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Miki kawâŋgi ku katula i kilala pwataki tu i ŋa nde ŋalae ndo! Kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Kaporo pa Maro Kindeni mine tu, “Maka kamora mâsi ŋalaŋala noko kuveta ŋinde, kala wisima motu. Noko ne walo nde kaika ndo; mine nde noko ne kazâŋa tamâta siruru ku sipare tukunzi ndue lâ noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Mao nâ, tamâta rârâni lâ tâno kulu nde sipare tukunzi pano ku siwâŋgi wâŋgiŋa paneâŋa kâ sisuka noko ŋa kâki ndo.” ");
INSERT INTO xsi_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Mine nde miki kamâ kamora vetâŋa rârâni Maro Kindeni muŋga iveta ŋinde. Iveta mâsi ŋalaŋala lâ tamâta naonzi, kala wisinzi motutu. ");
INSERT INTO xsi_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Iveta mâsi mine; iveta tâi ipalele ipâŋga nia mâsa-mâsa, kala maka timbuma kinzi soka simbwaliu pa tini pinde. Kala ŋine maka kamandi niani ndaina ku kandekana Maro Kindeni ŋana i ne mâsi ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","I ne walo nde kaika, aku ikai koipu ŋalae, ma imo mine ku imo nâ. I mata ilea kaika panzi tinikoa ŋgu. Mine nde miki tamâta ŋine uru taŋami kaika papa i, ande miki ma kapasuka warakami tinimi ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Miki ŋgu ŋine ma kapanea maka nema Maro Kindeni kasuka i ŋa kâki. Ara ŋana nemi paneâŋa ŋinde ma ipâŋga nia yo. ");
INSERT INTO xsi_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Ŋana tu Maro Kindeni ikatona maka Isrel ŋgu sondo ndo, kala kamo viama nâ. I ŋandai isâu panzi kazâŋa tamâta tu sipole maka ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Maro Kindeni, noko malia kulua maka ŋana pwai samâŋa pama, itogo tamâta ikai samâŋa pa mira “silva” ku imomo lâ yââ ilo ŋana ma ipâŋga zuzuli ndo. ");
INSERT INTO xsi_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Muŋga noko pwaima kaika kalâ viâŋa ilo, aku kusia malia ŋalae kâki kuluma. ");
INSERT INTO xsi_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Noko kusâu panzi kazâŋa tamâta, kala kenzi nâ sipale maka lâ. Maka kakai nâna ŋalae, itogo tamâta toŋge yââ ikana tâku lââ pondi kâki ku ipatuku i lâ. Taitu kala zo ŋine noko kuo maka kamo nia ara, kala iloma ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Muŋga, lâ zo ŋinde malia imâ ipâŋga pa naŋa, ande naŋa apambwâre tu ma aveta vetâŋa pinde pano. Kala ŋine naŋa ma aveta patarawâŋa pano, ikura naneŋgu ŋgua pâŋa mine. Naŋa ma akai simbi amâ noko ne luma sapâŋa ilo ku ma apatarâwa pano. ");
INSERT INTO xsi_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Naŋa ma amomo simbi situmbu ŋalaŋala ŋinde nâ lâ patarawâŋa nia. Naŋa ma amomo lama tamâne simbi, aku ne mundo ma ikâki imâ pano. Aku naŋa ma amomo bulmakao simbi tava meme simbi lâ patarawâŋa nia tona. ");
INSERT INTO xsi_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Ayo, miki tamâta ea uru kamege ŋana Maro Kindeni kâ, miki ŋinde rârâni kamâ katambira taŋami. Naŋa ma aporo atula ŋgua pami ŋana vetâŋa rârâni i muŋga iveta ŋana ivila naŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Muŋga naŋa asarâwa papa i tu ma ivilana. Naŋa kawâŋgu kâki awâŋgi wâŋgiŋa paneâŋa kâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Lâ zo ŋinde, ambo kiesaka ikeno pa naŋa aku naŋa ŋandai iloŋgu malia ŋana ŋga, ande Maro Ŋalae ma ipono taŋa ŋana naneŋgu noŋa kâ. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Mao nâ, Maro Kindeni itambira taŋa pa naneŋgu sarawâŋa, aku ipaloŋo pa naneŋgu noŋa lâ. ");
INSERT INTO xsi_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Maro Kindeni ŋandai ipu muli pa naneŋgu noŋa ŋga, aku i ŋandai ikai ne tini-mwasa ara ŋinde piti ŋanana ŋga. Mine kala naneŋgu paneâŋa ilâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Maro Kindeni, kalo sukâŋa ŋanama ku kuveta kie ara pama. Kulele nao pama ku kuvilama! ");
INSERT INTO xsi_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Ambo noko ma kuveta mine, ande tamâta rârâni simo tâno ndoni ma sisama noko ne vetâŋa kilala pwataki, aku ma sisama tu noko uru pwainzi tamâta piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Maro Kindeni, naŋa iloŋgu tu tamâta rârâni ma sipaneano. Ara ŋana tamâta ndoni ma sisuka noko ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Naŋa iloŋgu tu kinzi tinikoa ŋgu ndoni ma sindeka ku siwâŋgi pano, ŋana tu noko uru kumandi ŋgua nia ku pwai samâŋa sondo ndo panzi tamâta ŋana nenzi vetâŋa kâ. Noko pwai poe sondo ndo panzi tamâta ŋgu rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Maro Kindeni, naŋa iloŋgu tu tamâta rârâni ma sipaneano. Ara ŋana tamâta ndoni ma sisuka noko ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Kâpwa arara nde ipâŋga maria lâ tâno ilo. Maro Kindeni, ina maka Isrel nema Maro Ŋalae, ande iveta kie ara ndo pama. ");
INSERT INTO xsi_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Mao nâ, Maro Kindeni iveta kie ara ndo pama. Ara ŋana tamâta lâ tâno ndoni ma simege ŋana i kâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Naŋa iloŋgu tu Maro Kindeni ma imâ walele nâ ŋana isokinzi ne kazâŋa tamâta sikâwa pwapwataki silâ. Kinzi tamâta ŋinde uru ilonzi sakamao ndo papa i. Ara ŋana kinzi ma sikâwa lâ i nao. ");
INSERT INTO xsi_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Naŋa iloŋgu tu i ma isokinzi piti, itogo lawea itapala yââ ne mundo kala nao tia lâ. Naŋa iloŋgu tu i ma izavarunzi ndo, itogo yââ isimu sipa siŋi ku iveta ipâŋga itogo lââ mine. ");
INSERT INTO xsi_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Andeta ara ŋana kinzi tamâta sondo ma sindeka lâ Maro Kindeni nao. Ara ŋana kinzi ma ilonzi ndeka nâ sisuŋa kawanzi kâki. ");
INSERT INTO xsi_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Mine nde miki ma kawâŋgi wâŋgiŋa paneâŋa kâ pa Maro Kindeni kasuka i ŋa kâki. Ina uru iyoka take-take kulu ilâ wa imâ wa, aku i ŋa mine tu Yova Kindeni. Miki kawâŋgi papa i ku kandeka lâ i nao. ");
INSERT INTO xsi_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Maro Kindeni imo ne luma sapâŋa ilo, aku inani uru ikatonanzi lâlu mundoro wa taine mwala-mwala wa. ");
INSERT INTO xsi_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Kinzi tamâta ea simo simbonzi nâ, ande Maro Kindeni iveta nia sondo panzi ŋana simo ara kâ. I iyautenzi tamâta piti lâ luma sakamao ilo, aku ivetanzi simo ara ndo. Aŋga tamâta ea sipu mulinzi papa i, ande ionzi simo nia sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Maro Kindeni, nanayoni noko kumuŋga panzi ne tamâta ku pwainzi soka nia bilimu silâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Pa zo ŋinde tâno iririŋo, aku karâzi ŋalae imbe ndue. Noko nde maka Isrel nema Maro Kindeni, aku vetâŋa kie mine nde ipâŋga lâ noko nao, lâ zo ŋinde noko kupatua lâ Sinai tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","O Maro Kindeni, lâ zo ŋinde noko kuo karâzi imbe more-more ŋalae indue pa noko ne tâno, kala tâno ŋinde ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Noko ne tamâta siveta nenzi lawea lâ tâno ŋinde. O Maro Kindeni, ara tamwata kala noko; mine nde noko kurombonzi kinzi sugorai tamwatanzi. ");
INSERT INTO xsi_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Aku muli ŋga Maro Ŋalae iporo itula ŋgua pwataki lâ, ŋineŋga taine rârâ nde sikai i kawa ŋgua ŋinde silâ situla pwataki mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Kinzi koipu ŋalaŋala sitavanzi nenzi zugu tamâta nde sikâwa pwapwataki sipalilu nâ silâ!” Taine pinde simo lawea ilo, aku kinzi ŋinde siwae mbaliŋa wa kelekele ŋinde kinzi tamâne muŋga sikai lâ paraŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Kinzi siwae sii bâlu tainzi muŋga tamâta siveta lâ mira “silva” tini, aŋga sii ŋinde mbaninzi nde siveta lâ mira “gol” tini kala salaga-salaga. Ambo taitu ŋana sâ kâ ŋga miki tamâta pinde kamuna kamo lama nenzi ŋgumbi ilo, aku miki ŋandai kalâ paraŋa ilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Maro Kindeni Walo Tamwata nde izavarunzi koipu ŋalaŋala lâ Salmon Tuu kulu, itogo karâzi tava “ais” imbe ndue mine. ");
INSERT INTO xsi_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Aku tuu toŋge kala imandi tâno ŋinde tona, sipatu ŋa tu Basan Tuu. Ŋinde nde tuu ŋalae tina, aku ne mira ŋalaŋala rârâ ŋinde keno. Andeta tuu ŋinde imo ipadâda nâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Ayo, noko tuu ŋalae ndai, ŋana sâ kâ ŋga noko kupadâda ŋana Saion Tuu, tuu ŋinde Maro Kindeni muŋgani ipatea tu ma imo kulu, a? Mao nâ, Yova Kindeni ma imo tuu ŋinde kulu ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Maro Ŋalae iyoka pa Sinai Tuu kulu ku iyoka lee ikâki ilâ ne luma sapâŋa ikeno Saion Tuu kulu ŋinde ilo. Iyoka imuŋga panzi ne zugu tamâta sitava nenzi kareta kaika, kambwaŋenzi tamâta-tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Maro Kindeni, noko pwâki kulâ tuu ŋinde kulu, aku pwainzi ne kazâŋa tamâta soka muli silâ, kinzi ŋinde muŋga kupolenzi lâ paraŋa ilo ku wâlo nâ kupanzi kaika lâ. Lâ zo ŋinde, kinzi kazâŋa tamâta ŋinde mbaliŋa kie-kie silano. Mao nâ, kinzi tamâta muŋga mbo sipu mulinzi pano ŋinde sio nenzi mbaliŋa imâ pano. Mine nde Maro Yova Kindeni ma imo niani ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Mine kala nenda paneâŋa ilâ pa Maro Ŋalae, inani uru ikale nenda malia ikura zo zo! Maro Kindeni simbo nâ nde imo nenda Yautâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Kinda warakânda nenda Maro Kindeni ŋinde nde Maro ŋana iyautenzi tamâta piti lâ kazâŋa ilo. Ina kinda nenda Koipu Ŋalae Yova Kindeni, aku inani itiŋgi mateŋa piti kala iŋgeŋge ŋana kinda kâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Mao nâ, Maro Kindeni ma izavarunzi ne kazâŋa tamâta ndo lâ, kinzi ŋinde uru sipono muli pa vetâŋa kiesaka. ");
INSERT INTO xsi_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Maro Ŋalae iporo tu, “Naŋa ma alâ pa Basan tâno wa tâi geza-geza wa, aku ma akainzi kazâŋa tamâta ataulo amâ kilo, ŋineŋga ma apunzi pâta sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Kinzi seenzi ma isala nia ilâ, aku miki ma kamora ku kandeka ŋalae. Aku nemi mbwâmbwa ma sinu seenzi lee kapwanzi pupuro lâ.” ");
INSERT INTO xsi_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Maro Kindeni, naneŋgu Koipu Ŋalae noko, noko kupolenzi ne kazâŋa tamâta marumbu lâ, kala tamâta rârâni simora noko pwoka kulâ ne luma sapâŋa ilo tava ndekâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Kinzi wâŋgiŋa tamwatanzi nde soka noko muli silâ, aŋga kinzi wâŋgu râŋa tamwatanzi nde soka kinzi mulinzi silâ. Aŋga kinzi taine taipa nde soka kunzi ku sira nenzi wâŋgu kiri-kiri. ");
INSERT INTO xsi_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Kinzi siwâŋgi mine tu, “Miki Maro Kindeni ne tamâta kala kapasau kamo taitu ŋai, miki rârâni kapanea i! Miki Isrel ŋgu kapanea Yova Kindeni kasuka i ŋa kâki!” ");
INSERT INTO xsi_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Kamora ŋga! Kinzi Benjamin ne vâsa ŋgu nde ŋgu kiri-mwata nâ, taitu kinzi ŋinde simuŋga panzi tinikoa ŋgu rârâni silâ. Aŋga kinzi tamâta mbâna-mbâna lâ Juda ne vâsa ŋgu nde sikainzi nenzi tamâta ku soka Benjamin ŋgu mulinzi silâ. Aŋga kinzi tamâta mbwananâŋa lâ Sebulun ne vâsa ŋgu wa Naptali ne vâsa ŋgu, kinzi ŋinde soka mulinzi silâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O Maro Kindeni, maka iloma tu noko ma kutula ne walo kaika pwataki, waloni ndaina noko muŋga kuo pama ŋana ivilama kâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Kinzi koipu ŋalaŋala nde sisama tu noko kumo Koipu Ŋalae, kala sikai nenzi wisi-ara simâ pano lâ noko ne luma sapâŋa ŋinde ikeno Jerusalem lawea ilo. ");
INSERT INTO xsi_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Maka iloma tu noko ma kumbitanzi Isip ŋgu, kinzi ŋinde sitogo ŋgoa ŋgoi uru imo lââ pwali. Kinzi simo sitogonzi bulmakao tamâne lâ kinzi bulmakao natu ŋgininzi. Kumbitanzi lee ikura lâ zo ndia kinzi ma sipare tukunzi pano ku mira “silva” silano. Maka iloma tu noko ma pwai kazâŋa panzi tamâta ŋinde uru sindeka ŋana paraŋa kâ, aku kusokinzi sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Noko ma kupolenzi Isip ŋgu mine, ŋineŋga nenzi koipu ŋalae ma ionzi ne dumui soka silâ pa Jerusalem lawea, aŋga kinzi tamâta ŋinde simo Itiopia tâno kala ma sikai nenzi mbaliŋa simâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Mine nde miki tamâta pa ŋgu rârâni kamo tâno ndoni, miki kawâŋgi pa Maro Kindeni. Kawâŋgi wâŋgiŋa paneâŋa kâ pa Maro Ŋalae, ");
INSERT INTO xsi_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","ina uru iyoka nia maa siŋga ikeno âta ŋinde ilâ wa imâ wa. Miki kaloŋo ŋga; kala ŋine isuŋa kawa kâki ŋalae ndo! ");
INSERT INTO xsi_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Miki rârâni kaporo katula pwataki tu Maro Kindeni ne walo nde ŋalae tina. I imo Isrel nenzi Koipu Ŋalae, aku uru itula ne walo kaika pwataki lâ nia maa ikeno âta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Isrel nenzi Maro Kindeni imo ne luma sapâŋa ilo, aku tamâta rârâni nde simege ŋana i kâ. I uru iwae ne walo kaika panzi ne tamâta. Paneâŋa ilâ pa Maro Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Maro Kindeni, kuvilana ŋga! Lââ ipondi kâki imâ ipâŋga naŋa ndaŋgenâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Naŋa apale tâno mbariri andue alâ, aku tâno kaika ŋana namandi kulu keno, ande tia. Naŋa amo tâi geza-geza ilo, aku laiti ŋana ambwatuke kâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Maro Kindeni, naŋa amo asarâwa pa noko lee naneŋgu walo marumbu lâ, aku ŋandolâŋgu mbwendu mâsa-mâsa lâ. Naŋa ao matâŋgu ikura zo luandondo koŋa pa noko tu ma kuvilana, kala matâŋgu sakamao lâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Tamâta rârâ sikai kazâŋa pa naŋa koa tia nâ. Kinzi kambwaŋenzi ŋalae tina, ipole naŋa kuluŋgu pwau ŋine kambwaŋenzi. Kinzi kazâŋa tamâta ŋinde nenzi walo nde kaika, aku kawanzi laŋeŋa nâ sisowe ŋgua lâ naŋa tiniŋgu. Kinzi situ ma sizavaru naŋa ndo. Naŋa ŋandai apanawe nenzi kelekele toŋge ŋga, andeta kinzi siporo kaika kala naŋa warakâŋgu neŋgu mbaliŋa alanzi koa tia nâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Maro Kindeni, noko kusama tu naneŋgu ilo-kalo nde soki ndo. Naneŋgu kiesaka ipavea lâ noko nao, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Maro Ŋalae, noko Yova Kindeni Kaika Warika, ambo noko ma kuvila naŋa tia, ande naneŋgu kazâŋa tamâta ma sipole naŋa. Ŋineŋga kinzi tamâta kala uru kalonzi tawanano ŋinde ma sikai maŋeti kuku naŋa. Maka Isrel nema Maro Kindeni, naŋa tiniŋgu pwâka tu naneŋgu malia ŋine ma ivetanzi tamâta pinde siporo ŋgua sakamao panzi tamâta ŋinde uru siwâŋgi pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Naŋa uru apono muli pano, aku ŋana duvi ŋinde kâ kinzi tamâta siporo ŋgua pavaligiŋa pa naŋa, aku siveta naŋa maiŋgu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Andeta ŋinde nâ tia; niŋgu-nambwe wukale simora naŋa nde togo tamâta lâ ŋgu toŋge. Aku naŋa taiŋgu-tata kinzi kala simora naŋa nde togo tamâta lombo mine. ");
INSERT INTO xsi_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Ŋana tu naŋa iloŋgu ndo keno pa noko ne luma sapâŋa, aku iloŋgu ŋalae tina tu luma ŋinde ma ikeno ara nâ. Aku lâ zo ŋana kinzi tamâta siporo ŋgua pavaligiŋa pa noko, ande nenzi ŋgua soki ŋinde imâ ikai naŋa tona. ");
INSERT INTO xsi_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Mine nde naŋa kaloŋgu sukâŋa ŋalae tina, kala apatawa warakâŋgu tiniŋgu ku asâpa ŋana aka kâpwa kâ. Taitu kinzi tamâta simora naŋa aveta mine, kala siporo ŋgua pavaligiŋa pana. ");
INSERT INTO xsi_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Aku naŋa asawa pasawaŋa râge-râge lâ tiniŋgu tona, ŋana itula pwataki tu naŋa akai mâŋgu ŋana kalo-sukâŋa kâ. Ambo taitu kinzi tamâta simora ŋinde ku siŋelea naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Kinzi tamâta sipasau lâ ao ŋgini ku situ naŋa ŋguanâŋgu. Tamâta pinde simo nia ŋinde ku sinu lââ kaika sidauda ikura zo zo, aku kinzi ŋinde sisia wâŋgiŋa sakamao sivaligi naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Andeta kalo loko, naŋa ma akai noŋa pa noko, Yova Kindeni. Maro Kindeni, noko uru tini mwasa ndo pa naŋa ikura zo zo, aku noko uru kupaveta kuku tamwata ne ŋgua pâŋa ŋana kuvilanzi ne tamâta. Mine kala lâ zo ndia noko tamwata kupatea, ande naŋa iloŋgu tu noko ma kusâu pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Pwai naŋa piti lâ tâno pâpâŋa ŋine. Tia ma naŋa andue alâ nziŋa ilo, ku ma naoŋgu tia lâ. Pwea ŋanana, ŋana kinzi kazâŋa tamâta ma sikura tu sizavaru naŋa tia, aku tâi geza-geza ŋine ma ikura tu ipatuku naŋa tia mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Noko ma kusâu pa uŋara tu ikai naŋa, mine ndimo. Aku noko ma kusâu pa tâi geza-geza tu ma ipatuku naŋa kala ambwatuke, mine ndimo. Aku noko ma kusâu pa mateŋa nianzi tu ipaŋando naŋa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yova Kindeni, ikura zo rârâni noko tini mwasa ndo pa naŋa, aku ŋinde nde ara ndo. Mine nde kupaloŋo pa naneŋgu noŋa ŋga! Noko ne kalo-sukâŋa nde ŋalae tina; mine kala kulele nao pa naŋa! ");
INSERT INTO xsi_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Naŋa nde noko ne wurâta tamâta. Mine kala noko ma kupavea ŋanana ndimo. Naŋa asânda malia ŋalae toŋge kulu; mine nde ano pano tu kusâu pa naneŋgu noŋa walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Kumâ kumo naŋa tiniŋgu laiti, aku pwaina piti lâ naneŋgu kazâŋa tamâta mbaunzi ilo, ŋana ma amo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Noko kusama lâ ŋana ŋgua potomule kinzi tamâta ŋinde uru siporo pa naŋa. Noko kusama tu kinzi uru siveta maŋeti pa naŋa wa sitawa ŋâŋgu ndue wa. Noko mata kumoranzi naneŋgu kazâŋa tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Ŋgua sakamao ŋinde iyaula naŋa iloŋgu kaloŋgu ndo lâ, kala iloŋgu malia ndo. Naŋa atu tamâta pinde ma kalonzi sukâŋa ŋanana tâ, andeta tia. Aku naŋa atu tamâta pinde ma siporo ŋgua ara tâ pana ŋana sipu tini kaika pa iloŋgu kaloŋgu kâ. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Aku lâ zo ŋana putole ipuna, ande kinzi kâpwa kaŋa makisa nâ silana tu aka. Naŋa arakoŋa ŋana lââ kâ, andeta kinzi waini sakamao nâ silana tu anu. ");
INSERT INTO xsi_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Mine nde lâ zo ndia kinzi siveta kâŋa-nuŋa ŋalaŋala, ande naŋa iloŋgu tu ndekâŋa ne zo ŋinde ma ipalele ku iyaula kinzi warakanzi, itogo nimbu ikai ŋgoa mine. Naŋa iloŋgu tu kinzi ma sikai pareŋa-nia ŋana nenzi vetâŋa potomule kâ. ");
INSERT INTO xsi_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Maro Kindeni, naŋa iloŋgu ndo tu noko ma kuveta matanzi leva-leva, ŋana kinzi ma sikura tu simora kilo tia. Kuyaula kumbunzi totoroni, ŋana kinzi ma sikura tu simandi kaika kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Naŋa iloŋgu tu noko ma wisi nâna ŋalae ndo pa kinzi, aku kuyaulanzi. Ara ŋana noko ne wisi-nâna ma ilâ panzi ku izavarunzi ndo. ");
INSERT INTO xsi_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Naŋa iloŋgu tu nenzi lawea ma ikeno kaa nâ, tamâta toŋge tia. Noko ma kusâu pa tamâta toŋge lâ ŋgu ŋinde tu ma imo via ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Ŋana tu kinzi siveta kenzi sakamao panzi noko ne tamâta, maka ŋine muŋga noko tamwata kupare nia pama lâ. Kinzi siporo ŋgua pavaligiŋa pa maka tamâta ŋine muŋga noko nâna kulama, aku nenzi vetâŋa ŋinde iveta iloma malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Naŋa iloŋgu tu noko ma kalo ŋgere ŋana kinzi tamâta sakamao ŋinde nenzi kiesaka rârâni taitu-taitu. Noko ma kusâu panzi tu ma simo kunzi noko ne ŋgu, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Ara ŋana noko ma kuzavaru ŋanzi piti lâ pepa ŋana via kâ tini. Noko ma kuŋgere ŋanzi lâ pepa ŋinde kinzi tamâta sondo ŋanzi keno tini, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Aŋga naŋa nde akai nâna ŋalae ŋinde, kala iloŋgu malia ndo. O Maro Kindeni, pwaina piti lâ kazâŋa ilo, aku kuveta naŋa amo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Maro Kindeni, ambo noko ma kuveta mine, ande naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pa noko. Naŋa ma kawâŋgu ndaŋge pano ku aporo asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Yova Kindeni, naŋa asama tu noko ma tini mwasa ndo ŋana vetâŋa mine, ŋana tu noko ilo ndeka ŋalae ŋana tamâta nenzi paneâŋa kâ. Aku noko ne ndekâŋa ŋinde ipole ne ndekâŋa lâ zo ndia kinzi tamâta sipatarâwa bulmakao tamâne pano. ");
INSERT INTO xsi_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Tamâta pinde uru sikai nâna wa malia rârâ, andeta lâ zo ŋana kinzi ma simora Maro Kindeni ivila naŋa, ande kinzi ma sindeka. I ne vetâŋa ŋinde ma ipu tini kaika panzi tamâta ŋinde uru sipare tukunzi pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Ŋana tu Yova Kindeni uru ipaloŋo pa kinzi sugorai tamwatanzi nenzi noŋa. Aku i ŋandai kalo kapa ŋananzi ne tamâta ŋinde simo luma sakamao ilo ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Ayo, miki samba wa tâno wa tâi wa, ara ŋana miki rârâni ma kagogo kawami ilâ kunzi kelekele rârâni simo vianzi ŋinde kawanzi, aku kapanea Maro Kindeni kasuka i ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Ŋana tu Maro Kindeni ma ikea ŋana Jerusalem lawea, aku i ma iveta Juda nenzi lawea rârâni kilo. I ma ionzi ne tamâta simo ara kilo lâ lawea ŋinde, aku ma sikai tâno ŋinde ndoni saŋenzi kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Maro Kindeni ne tamâta ŋinde nenzi vâsa ma muli sikai tâno ŋinde, aku tamâta ea ilonzi ndo ikeno pa Maro Kindeni, kinzi ŋinde ma simo tâno ŋinde ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Maro Kindeni, kalo sukâŋa ŋanana ku pwaina piti lâ kazâŋa ilo! Yova Kindeni, kumâ walele ku kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Tamâta pinde situ sipu naŋa pâta amâte. Naŋa iloŋgu tu noko ma kuveta maŋeti panzi ku kupolenzi ndo lâ. Kinzi uru sindeka ŋana naneŋgu malia ŋine kâ. Naŋa iloŋgu tu noko ma kuŋaranzi ku kutawa ŋanzi ndue lâ. ");
INSERT INTO xsi_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Kinzi sivaligi naŋa wa siveta “a” pana wa. Naŋa iloŋgu tu noko ma kuzavarunzi ndo lâ, aku kuveta kinzi mainzi ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Aŋga tamâta pinde nde uru simâ pano, aku naŋa iloŋgu tu kinzi ŋinde ma sindekanano. Noko muŋga pwainzi tamâta ŋinde piti lâ kazâŋa ilo, aku naŋa iloŋgu tu kinzi rârâni ma kawanzi ndaŋge pano ku siporo ŋgua ikura zo rârâni mine tu, “Maro Kindeni nde ara ku ara ndo!” ");
INSERT INTO xsi_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Ambo taitu naŋa nde tamâta kaa nâ, aku akura tu apavila warakâŋgu, ande tia. O Yova Kindeni, kumâ walele pa naŋa ŋga! Naneŋgu Maro Kindeni, naneŋgu Pavilâŋa Tamâta wa naneŋgu Yautâŋa Tamâta noko. Mine nde ano pano tu kumâ walele nâ ku kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yova Kindeni, naŋa amâ pa noko ŋana noko ma pwatonana. Noko ma kusâu panzi kazâŋa tamâta tu ma sipole naŋa kala akai maŋeti, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Noko nde vetâŋa sondo warika. Mine nde kuvilana, aku pwaina piti lâ kazâŋa ilo. Kupaloŋo pa naneŋgu noŋa, aku kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Noko kumo kutogo mira ŋalae naŋa uru amuna tini mwasina. Noko kumo kutogo ŋgumbi kaika mine, aku noko uru pwea ŋanana, ŋana tu naŋa amâ pa noko nâ ŋana apavea kâ. Noko simbo nâ pwatona naŋa kala amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Naneŋgu Maro Kindeni, pwai naŋa piti lâ kinzi tamâta sakamao mbaunzi ilo. Kinzi nenzi walo nde kaika, aku nenzi vetâŋa nde sakamao ndo. ");
INSERT INTO xsi_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Maro Yova Kindeni, naŋa kaloŋgu tawana noko simbo nâ. Nanayoni, lâ zo ŋinde naŋa tamâta limoa yo, aku amo lee ikura lâ zo ŋine, ande naneŋgu kalo-tawana ikeno mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Ikura zo rârâni naŋa amo viâŋgu, naŋa uru amarerea noko simbo nâ. Nia ndoyo, lâ zo ŋinde nana ipaguguana, aku amo lee apâŋga lâ zo ŋine, ande noko pwatona naŋa sondo ndo. Mine nde naŋa ma apanea noko ŋa ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Tamâta rârâ simora vetâŋa rârâni noko kuveta pa naŋa, kala wisinzi motutu. Kinzi sisama tu noko simbo nâ ne kaika ŋalae uru ikea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Ikura zo rârâni naŋa apanea noko ŋa ku atula noko kilala pwataki panzi ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Andeta kala ŋine naŋa ŋga koŋa lâ; mine nde noko ma kupile naŋa ndimo. Naneŋgu walo nde marumbu lâ; noko ma kupu muli pa naŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Kinzi kazâŋa tamâta situ sipu naŋa pâta amâte, aku sipasau lâ sipa ŋgua ŋana siyaula naŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Kinzi siporo tu, “Maro Kindeni ipile i marumbu lâ. Ayo, kinda ma tataŋgula i lee takale kaika. Tamâta toŋge imo ŋana ivila i kâ, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Maro Kindeni, noko ma kumo malawae ŋana naŋa kâ ndimo. Naneŋgu Maro Kindeni, kumâ walele nâ ku kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Kinzi tamâta ŋinde uru siporo sitalea naŋa. Naŋa iloŋgu tu noko ma kutawa kinzi ndue ku kuzavarunzi ndo lâ. Kinzi situ siyaula naŋa. Naŋa iloŋgu tu noko ma kuveta kinzi mainzi ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Aŋga naŋa ma kaloŋgu tawana noko ikura zo rârâni, aku ma ao tiniŋgu pa noko tu kuvilana. Naŋa ma apanea noko ŋa ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Naŋa ma atapâri panzi tamâta ŋana vetâŋa arara ŋinde noko muŋga kuveta pa naŋa. Naŋa azizâla ŋana noko ne pavilâŋa ara ŋinde ne duvi, andeta naŋa ma aporo atula pwataki ikura zo rârâni tu noko pwai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Maro Yova Kindeni, naŋa ma kaloŋgu ŋgere ŋana noko ne walo kaika ŋalae, aku ma amo apaneano. Naŋa ma asuka noko ŋa kâki aporo atula ŋgua mine tu, “Maro Kindeni i simbo nâ nde vetâŋa sondo warika.” ");
INSERT INTO xsi_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Maro Kindeni, nanayoni, lâ zo ŋinde naŋa lâlu kiri-mwata yo, ande noko uru kupananana, aku kuveta mine lee imâ ipâŋga lâ zo ŋine. Kala zo ŋine naŋa amo ŋai yo atula ŋgua pwataki ŋana noko ne vetâŋa arara ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Kala ŋine naŋa koŋa lâ, aku kuluŋgu pwau sâsâŋa lâ. Andeta Maro Kindeni, noko ma kupile naŋa ndimo. Naŋa iloŋgu tu noko ma kumo kuna, aku naŋa ma atapâri panzi naneŋgu vâsa ŋana noko ne walo kaika. ");
INSERT INTO xsi_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Maro Kindeni, noko ne vetâŋa rârâni nde sondo ndo, aku noko parina ŋinde nde isala nia ndoni ilâ lee ipâŋga lâ nia maa ikeno âta ŋinde. Noko muŋga kuveta mâsi ŋalaŋala kie-kie. Opopo, tamâta toŋge ipakura kuku noko, ande tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Noko muŋga kuo malia kie-kie imâ ipâŋga pa naŋa, andeta naŋa kaloŋgu tawana tu noko ma kupu tini kaika pa iloŋgu kaloŋgu kilo. Mateŋa imâ ipâŋga tiniŋgu laiti lâ, andeta naŋa kaloŋgu tawana tu noko ma pwaina kâki kala ma amo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Naŋa kaloŋgu tawana tu noko ma kusuka ŋâŋgu ipâŋga ŋalae ndo, aku noko ma kuveta iloŋgu ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Mao nâ, naŋa ma ara wâŋgu ku awâŋgi wâŋgiŋa paneâŋa kâ pa noko. Naneŋgu Maro Kindeni, noko uru kuveta ikura noko kawa ŋgua rârâni, aku naŋa ma awâŋgi atula ŋinde pwataki. Isrel nenzi Maro Kindeni, noko Sapâŋa Tamwata, naŋa ma ara wâŋgu awâŋgi wâŋgiŋa paneâŋa kâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Naŋa ma andeka ŋalae asuŋa kawâŋgu kâki awâŋgi pano. Taitu naŋa ma awâŋgi lâ kawâŋgu nâ, ande tia ndo. Naŋa ma awâŋgi pano tava iloŋgu ndo, ŋana tu noko pwai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Tamâta pinde sitogo tu siyaula naŋa, andeta noko kupunzi ndue ku kuvetanzi sikai maŋeti ŋalae. Mine kala ikura zo zo naŋa ma atapâri panzi tamâta tu noko ne vetâŋa rârâni nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Maro Kindeni, naŋa iloŋgu tu noko ma kupanana koipu ŋalae ŋana noko ne vetâŋa sondo kâ. Ŋineŋga i ma isamanzi tamâta sondo lâ ŋgua nia. Noko uru kuveta vetâŋa sondo ndo lâ ŋgua nia. Mine kala naŋa ano pano tu kupanana koipu ŋalae ŋana wurâta ndainani nâ. ");
INSERT INTO xsi_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Ŋineŋga i ma ikura tu ikai poe sondo ndo panzi noko ne tamâta, kinzi ŋinde uru simo sitogo sugorai tamwatanzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Naŋa iloŋgu tu noko ma kuveta kâpwa maria ipâŋga tâno ilo, aku kuvetanzi ne tamâta rârâni tu ma sipono muli pa noko ne vetâŋa sondo ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Naŋa iloŋgu tu koipu ŋalae ma iveta kie ara ndo panzi sugorai tamwatanzi, aku ma ivilanzi tamâta ŋinde nenzi kelekele keno panzi tia. Andeta naŋa iloŋgu tu i ma izavarunzi tamâta pinde tona, kinzi ŋinde situ siveta kenzi sakamao panzi tininzi pinde. ");
INSERT INTO xsi_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Maro Kindeni, naŋa iloŋgu tu noko ne tamâta ma siwâŋgi sipanea noko ikura zo rârâni kari tava nzimona ma sipane nia simo ŋai yo. ");
INSERT INTO xsi_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Aku naŋa iloŋgu tu koipu ŋalae ma iveta vetâŋa arara nâ ŋana isukanzi tamâta kâ, itogo karâzi imbe ndue tâno kulu ku iveta kâpwa ipâŋga ara mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Naŋa iloŋgu tu kinzi tamâta ma sipaveta kuku vetâŋa ara nâ, ikura zo rârâni koipu ŋalae imo via yo. Naŋa iloŋgu tu kinzi ma simo ara nâ lee ikura zo rârâni nzimona ma ipane nia imo ŋai yo. ");
INSERT INTO xsi_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Mao nâ, i ma ikai koipu ŋalae panzi tamâta rârâni simo tâno ŋinde ikeno pa mbwera kâ, aku ilâ lee ipâŋga lâ tâno ŋinde ikeno pa wâra kâ. I ne tâno ne keri ma imandi lâ Yufretis Lââ tini laiti, aku ma ilâ lee ikura tâno pinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Tinikoa ŋgu pinde uru simo nia bilimu, aku kinzi ŋinde ma sipare tukunzi ndue lâ koipu ŋalae nao. Mao nâ, i ne kazâŋa tamâta ma patanzi sindue i kie tini laiti, ku ma simo i kalo. ");
INSERT INTO xsi_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Kinzi tinikoa ŋgu nenzi koipu ŋalaŋala ma simora tu i ne kaika nde ŋalae ndo. Mine kala Spen nenzi koipu ŋalae tavanzi koipu ŋalaŋala simo sia pinde, ande kinzi ŋinde ma sikai nenzi mbaliŋa kie-kie simâ silua i. Aŋga Arabia nenzi koipu ŋalae tava Itopia nenzi koipu ŋalae, ande kinzi rua kala ma sikai nenzi mbaliŋa simâ. ");
INSERT INTO xsi_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Mao nâ, kinzi koipu ŋalaŋala rârâni ma sipare tukunzi papa i, aku nenzi ŋgu ndoni ma simo nenda Koipu Ŋalae kalo, ");
INSERT INTO xsi_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","ŋana tu i uru isukanzi sugorai tamwatanzi rârâni lâ zo ndia sisarâwa papa i, kinzi ŋinde kelekele keno panzi tia aku nenzi pavilâŋa tamâta tia. ");
INSERT INTO xsi_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","I uru kalo sukâŋa ŋananzi tamâta ŋinde nenzi kaika tia kala simo sugorai nâ. I uru ikainzi sugorai tamwatanzi piti lâ kazâŋa ilo, kala simo vianzi. ");
INSERT INTO xsi_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Ambo kinzi tamâta sakamao situ siyaulanzi sugorai tamwatanzi ŋinde, ande koipu ŋalae uru ikainzi piti lâ tamâta ŋinde mbaunzi ilo. I tini mwasa ndo panzi, aku i tini pwâka tu kinzi tamâta sakamao ma sipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Ayo, naŋa iloŋgu tu koipu ŋalae ma imo via ikura zo luandondo! Ara ŋana kinzi tinikoa ŋgu simo Arabia tâno ŋinde ma sikai mira “gol” simâ silua i. Naŋa iloŋgu tu kinzi tamâta ma sino pa Maro Kindeni ikura zo rârâni tu ma isuka koipu ŋalae. Aku naŋa iloŋgu tu Maro Kindeni ma iveta kie ara nâ papa koipu ŋalae ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Ara ŋana kâpwa kie-kie rârâni ma ipâŋga maria lâ tâno ilo, itogo uru ipâŋga lâ Lebanon tâno mine. Aku ara ŋana kinzi tamâta ma sipâŋga kambwaŋenzi walo lâ lawea ndoni, sitogo leu mine. ");
INSERT INTO xsi_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Naŋa iloŋgu tu koipu ŋalae ŋa ma ipâŋga ŋalae ndo, ma ikeno mine ku imo nâ. Ara ŋana kinzi tamâta ma situ i parina lee ikura zo rârâni kari ma ipane nia imo ŋai yo. Aku ara ŋana kinzi tamâta ŋgu ndoni ma sino pa Maro Kindeni tu ma iveta kie ara taituni pa kinzi, itogo uru iveta pa koipu ŋalae mine. Aku ara ŋana kinzi ma sino tu koipu ŋalae ma imo tava ndekâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Mine nde tapanea Maro Yova Kindeni tasuka i ŋa kâki, ina Isrel nenzi Maro Kindeni! Ŋana tu i simbo nâ uru iveta vetâŋa arara ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","I ŋa imo ara ku ara ndo. Tapanea i mine ikura zo rârâni. Ara ŋana i kilala ma ipâŋga nia yo ikura tâno ndoni. Mao ku mao nâ. ");
INSERT INTO xsi_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Jesi natu Daviti ne noŋa rârâni kala imâ imotu lâ ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Mao nâ, Maro Kindeni iveta kie ara ndo panzi Isrel ŋgu, kinzi ŋinde ilonzi ikeno mbâra-mbâra. ");
INSERT INTO xsi_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Andeta muŋga, naneŋgu kalo-tawana imâ laiti ŋana imbe kâ. Ŋinde itogo naŋa keŋgu apale zuli-zuli sârârâ mine. ");
INSERT INTO xsi_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Ŋana tu naŋa amora tu kinzi tamâta sakamao nde sipâŋga mbaliŋa warakanzi. Kinzi uru sipasuka warakanzi tininzi, aku naŋa iloŋgu yosi pa nenzi kelekele. ");
INSERT INTO xsi_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Kinzi uru sikai nâna lâ karaenzi, ande tia. Kinzi situmbu ara kala simo ara nâ, nenzi pukoŋa toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Kinzi simo tava malia sitogo kinda mine, ande tia. Malia kie-kie uru ipâŋga pa kinda tamâta rârâni, andeta vetâŋa kie mine uru ipâŋga panzi tamâta sakamao ŋinde, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Mine kala kinzi sindeka kaa nâ ku sipasuka warakanzi tininzi kâki, itogo nenzi siŋgâra ara mwasina. Kinzi uru sizavarunzi tamâta pinde koa tia nâ, aku nenzi mâsi ŋinde ikeno nia yo, itogo nenzi pasawaŋa mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ilo-kalo sakamao nde ipipi lâ ilonzi kalonzi. Kinzi uru siveta vetâŋa potomule kie-kie ndia ilonzi patea tu ma siveta. ");
INSERT INTO xsi_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Kinzi siŋeleanzi tamâta pinde, aku sipasule tu ma siveta vetâŋa potomule panzi. Kinzi sipandekâna warakanzi nâ, aku sipa ŋgua tu ma siyaulanzi tamâta pinde. ");
INSERT INTO xsi_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Kinzi uru siporo ŋgua pavaligiŋa pa Maro Kindeni, ina imo samba ilo, aku siporo ŋgua potomule panzi tamâta tona. ");
INSERT INTO xsi_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Opopo, Maro Kindeni ne tamâta pinde sitambira taŋanzi pa kinzi tamâta sakamao ŋinde nenzi ŋgua, aku sindeka ŋana sipono muli pa ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Kinzi tamâta sakamao uru siporo mine tu, “Maro Kindeni izizâla ndo ŋana kinda nenda vetâŋa, ŋana tu Maro Kindeni âta Tamwata ne ilo-kalo nde ŋalae koŋa tia.” ");
INSERT INTO xsi_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Kinzi tamâta sakamao kalonzi loko ŋana sâ toŋge tia, aku simo nâ sigona mbaliŋa kie-kie rârâ. ");
INSERT INTO xsi_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Andeta mana mana, a? Naŋa uru apakatona warakâŋgu sondo ndo, kala iloŋgu ikeno mbâra-mbâra nâ. Vetâŋa soki toŋge iveta muso pa naŋa, ande tia ndo. Andeta naŋa amora kinzi tamâta sakamao nenzi mbaliŋa kala apakasoŋa warakâŋgu tu, “Tiambo naŋa apakatona warakâŋgu mine koa tia nâ, a?” ");
INSERT INTO xsi_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","O Maro Kindeni, ŋana sâ kâ ŋga noko nâna kulua naŋa ikura kari wa mbo wa. Ŋana sâ kâ ŋga noko pwai kazâŋa pa naŋa ikura mboyo mboyo. ");
INSERT INTO xsi_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ambo naŋa muŋga aporo ŋgua pavaligiŋa kaŋa taituni pa noko itogo kinzi tamâta sakamao uru siporo mine, ande ŋinde ma itula pwataki tu naŋa apu muliŋgu panzi noko ne tamâta marumbu lâ. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Naŋa iloŋgu ikai wurâta ŋalae tina ŋana asama ŋinde ne duvi kâ. Andeta ŋinde ne duvi ipavea ndo ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Naŋa amo aroto mine nâ ŋana duvi ŋinde kâ lee, ikura lâ zo ŋinde naŋa alâ Maro Kindeni ne luma sapâŋa ilo. Ŋineŋga iloŋgu kaloŋgu ipâŋga lâ, aku naŋa asama lâ ŋana vetâŋa ŋinde ma muli ipâŋga panzi tamâta sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Noko ma kuonzi soka nia zuli-zuli ndo, ku ma kuveta kinzi patanzi sindue ku sipayaula ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Noko ma kuzavarunzi walele nâ, aku nenzi mateŋa nde ma sakamao ndo. ");
INSERT INTO xsi_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Kinzi sitogo mbupuleŋa toŋge tamâta imbipole lâ mbo. Lâ zo ŋana tamâta ŋinde imandi sânda, ande ne mbupuleŋa ŋinde nao tia lâ walele nâ. Maro Ŋalae, muli ŋga, lâ zo ŋana noko ma kumandi tu pwai kazâŋa panzi tamâta sakamao, ande kinzi ma naonzi tia mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Opopo, muŋga, lâ zo ŋinde naŋa iloŋgu makisa ndo wa wisiŋgu sakamao wa, ");
INSERT INTO xsi_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ande naŋa azizâla ndo ŋana noko ne vetâŋa kilala. Naŋa iloŋgu kaloŋgu pasâsâe ndo, kala amo noko nao atogo ŋgoa ŋgoi, ne ilo-kalo tia mine. ");
INSERT INTO xsi_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Andeta kala ŋine naŋa amo noko tini laiti ikura zo zo, aku noko uru kusaŋa mbauŋgu pa wia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Noko kawa ŋgua ara ŋinde uru ikai poe sondo pa naŋa, aku muli ŋga noko ma pwaina alâ amo ku noko ku ma kusuka ŋâŋgu kâki. ");
INSERT INTO xsi_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Maro Ŋalae, naneŋgu pavilâŋa tamâta toŋge imo samba ilo, ande tia; noko simbo nâ. Naŋa iloŋgu ndo ikeno pa noko, aku ŋine ikura lâ. Mine nde naŋa ma iloŋgu pa tâno ne kelekele tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Naŋa karaeŋgu ne walo tava iloŋgu ne kaika ma marumbu lâ, andeta Maro Kindeni tamwata imo naneŋgu kaika mao. I ma imo kuku naŋa mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Mao nâ, tamâta ea kinzi sipile noko, ande kinzi ŋinde rârâni ma naonzi tia lâ. Noko ma kuzavarunzi tamâta ea sipu mulinzi pano. ");
INSERT INTO xsi_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Aŋga naŋa nde uru amo Maro Kindeni tini laiti, aku ŋinde nde ara ndo. Koipu Ŋalae Yova Kindeni imo itogo naneŋgu maramuŋa mwasina. Naŋa ma aporo atula i ne vetâŋa rârâni pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Maro Kindeni, ŋana sâ kâ ŋga noko kupu muli pa maka, a? Tiambo noko ma wisi nâna pa noko tamwata ne lama ŋgu maka ikura zo rârâni, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Maka kano pano tu kalo ŋgere kilo ŋana ne tamâta maka. Nia ndoyo noko kupatea maka pa tamwata, aku pwaima piti lâ kazâŋa ilo kala kamo noko ne ŋgu. Maka kano pano tu ma kutaulo kumâ pa Saion Tuu kilo, nia ŋinde noko muŋga kumo, aku kuvilama kilo. ");
INSERT INTO xsi_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Kumâ kumora ŋga; maka nema kazâŋa tamâta nde sizavaru kelekele ndoni ikeno noko ne luma sapâŋa ilo marumbu lâ. Mao nâ, luma sapâŋa nde zavaruŋa ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Noko ne kazâŋa tamâta nde silâ noko ne luma ilo, aku simo sikai lolove nâ. Kinzi sikai mbila pinde warakanzi kilalanzi ikeno tini, aku sisona târa luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Kinzi siveta pa noko ne luma sapâŋa itogo tamâta kavasi nâ itale kâi lâ dugu ilo mine. ");
INSERT INTO xsi_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Kinzi sikai palaŋa arara pinde muŋga tamâta sipare mâsi lâ tini, andeta kavasi nâ sitoto palaŋa ŋinde nuki-nuki. ");
INSERT INTO xsi_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Kinzi sizavaru noko ne luma sapâŋa, ŋineŋga yââ nâ sirumbia ndo lâ. Kinzi siveta vetâŋa sakamao ndo ku siveta muso ŋalae pa lumani ndaina noko muŋga kupatea pa tamwata tu ma kumo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Kinzi ilonzi patea tu ma sizavaru maka ndo. Mine kala kinzi sirumbia luma sapâŋa rârâni ikeno maka nema tâno kana lâ. ");
INSERT INTO xsi_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Noko muŋga kuveta mâsi ŋalaŋala kie-kie, andeta kala zo ŋine maka kamora mâsi toŋge tia. Aku noko ne ŋgua-tulâŋa tamâta rârâni kala naonzi tia mine nâ. Maka nema malia ŋine ma marumbu lâ zo ndia, a? Ŋinde nde maka rârâni kasama tia. ");
INSERT INTO xsi_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","11","Maro Kindeni, ŋana sâ kâ ŋga noko tini pwâka tu kuvila maka, a? Ŋana sâ kâ ŋga noko kumo kusaŋona nâ, a? Noko ma kusâu panzi kazâŋa tamâta tu ma siŋeleano ikura zo ŋapia kilo, a? Tiambo kinzi ma siporo ŋgua pavaligiŋa pa noko ikura zo rârâni, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Andeta Maro Kindeni, nia ndoyo, aku imâ lee ipâŋga lâ zo ŋine, ande noko kumo maka nema koipu ŋalae. Noko muŋga kupunzi kazâŋa tamâta simo tâno ŋine mbwani rârâ. ");
INSERT INTO xsi_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Noko ne walo nde kaika ndo, kala nanayoni nokoni tamwata kupu tâi ŋalae ipwa pwataki. Aku noko kuzavarunzi iŋa saka ŋalaŋala simo tâi ilo ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Mao nâ, nokoni kupu iŋa saka ŋalaŋala ŋinde kulunzi pwapwataki simâte lâ, ŋineŋga kutambira karaenzi ilâ pa nia bilimu, kala kinzi mbwâmbwa simâ sikanzi. ");
INSERT INTO xsi_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Aku nokoni kuveta lââ pinde isâko ipâŋga tâno kulu ku irere ilâ. Aŋga lââ ŋalaŋala pinde nde kuvetanzi sipâŋga mâsa-mâsa ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Nokoni tamwata kuveta nia pâne wa kondoma wa, aku noko kuonzi kari ku nzimona rua simo nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Nokoni kuo keri pa tâno ndoni, aku noko kupatea kari ne zo wa karâzi ne zo wa, ikura mbwera mbwera. ");
INSERT INTO xsi_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Mao nâ, noko muŋga kuveta mâsi ŋalaŋala ŋinde. Mine nde Yova Kindeni, ara ŋana noko ma kalo ŋgere ŋana ŋine kâ; noko ne kazâŋa tamâta uru siŋeleano. Kinzi sitogonzi tamâta kapa-kapa, ilonzi kalonzi tia ndo, aku simo siporo ŋgua pavaligiŋa pano. ");
INSERT INTO xsi_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Aku kinzi siveta kenzi sakamao ndo pa noko ne ŋgu maka tona. Maka kakura tu kapavila warakama, ande tia. Mine nde noko ma kusâu panzi nema kazâŋa tamâta tu ma sizavaruma ndimo. Maka kano pano tu ma kalo ŋgere kilo ŋana maka kâ. ");
INSERT INTO xsi_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Kinzi nzanzare tamwatanzi simuna nâ simo nia kondoma rârâni lâ tâno kulu. Mine nde maka kano pano tu kalo ŋgere kilo ŋana ŋgua pâŋa ŋinde noko muŋga kuveta kuku maka. ");
INSERT INTO xsi_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Noko ma kusâu panzi tamâta sakamao tu ma sitawanzi tamâta pinde ndue ku siveta maŋeti panzi, mine ndimo. Ara ŋana noko ma kuveta nzâla panzi sugorai tamwatanzi tu ma sipanea noko ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Maro Kindeni, kumâ kutula pwataki panzi kazâŋa tamâta tu noko ne vetâŋa rârâni nde sondo. Kalo ŋgere sondo ŋga; kinzi tamâta ŋinde sitogonzi tamâta kapa-kapa, ilonzi kalonzi tia ndo, andeta simo siŋeleano ikura kari wa mbo wa. ");
INSERT INTO xsi_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Noko ne kazâŋa tamâta uru kawanzi pakâe pakâe siporo ŋgua sakamao pa noko. Kinzi sisuŋa kawanzi siveta nduŋeŋa ŋalae ikura zo zo. Maro Kindeni, noko ma kalo kapa ŋana tamâta ŋinde nenzi vetâŋa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Maro Kindeni, maka kawama ndaŋge pa noko. Mao nâ, kawama ndaŋge ŋalae ndo pano. Noko uru kumo kuma, aku kinzi tamâta sipaneano situla ŋgua ŋana vetâŋa arara kie-kie noko muŋga kuveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Maro Kindeni iporo mine tu, “Naŋa warakâŋgu apatea zo toŋge ŋana ma aonzi tamâta rârâni simandi ŋgua nia. Aku lâ zo ŋinde, ande naŋa ma apare nia sondo ndo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Tâno ma imo ririŋo nâ, aku tamâta rârâni sitavanzi kelekele rârâni simo vianzi lâ tâno kulu, kinzi ŋinde kala ma tininzi ruru nâ. Andeta naŋani ma asaŋa tâno duvi kaika. ");
INSERT INTO xsi_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Naŋa Yova Kindeni apainzi tamâta ea uru sipandekâna warakanzi mine tu, ‘Miki ma kapasuka warakami tinimi ndimo.’ Aku naŋa apainzi tamâta sakamao mine tu, ‘Miki ma kapanea warakami ŋami ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Miki ma kandeka ŋana warakami nemi kaika wa kapandekâna wa, mine ndimo.’” Maro Kindeni kawa ŋgua kala ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Mine nde ea ikura tu iveta wurâta sondo ŋana isuka tamâta toŋge ŋa kâki wa itawa tamâta toŋge ŋa ndue wa, a? Kinzi tamâta simo pa mbwera kâ wa kinzi tamâta simo pa wâra kâ wa kinzi tamâta simo nia bilimu wa, ande kinzi ŋinde sikura tu siveta wurâta ŋinde sondo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Maro Kindeni simbo nâ iveta wurâta ŋinde sondo. Inani nâ imo ŋgua-samâŋa tamwata. I uru itawa tamâta toŋge ndue, aŋga toŋge nde isuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Ŋinde itogo Yova Kindeni isaŋa kâmba toŋge lâ mbau ilo, aku i ne wisi-nâna nde ipipi ikeno kâmba ŋinde ilo, itogo lââ makisa ndo mine. I ipaliŋi ne wisi-nâna ŋinde ndue ilâ panzi tamâta sakamao rârâni lee marumbu ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Aŋga naŋa nde ma aporo atula Yakopu ne Maro Kindeni parina pwataki ikura zo zo, aku ma amo awâŋgi wâŋgiŋa paneâŋa kâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Inani ma itawa kinzi tamâta sakamao nenzi kaika indue ndo, andeta i ma walo kaika ŋalae ilanzi tamâta sondo. ");
INSERT INTO xsi_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Kinzi Juda ŋgu nde sisama Maro Kindeni kilala sondo ndo. Kinzi Isrel ŋgu uru sipanea i sisuka ŋa kâki ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","I ne luma ikeno Jerusalem lawea ilo. I uru imo lawea ŋinde ikeno Saion Tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Lâ niani ndaina, ande i muŋgani imbware kinzi kazâŋa tamâta nenzi temba-kula kaika, tava nenzi maramuŋa wa pila kazâŋa kâ wa. Mao nâ, Maro Kindeni izavaru paraŋa ne kelekele rârâni ŋinde ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Maro Kindeni, noko ŋa nde ŋalae ndo, aku ne sinâla isinala nia ndoni. Noko kumo âta ndo, kupolenzi tuu ŋalaŋala rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Kinzi zugu tamâta ŋinde nenzi walo ŋalae, andeta Maro Kindeni, noko pwai nenzi kelekele arara rârâni saŋenzi lâ, aku kupunzi pâta sipamateteu. Aku nawalanzi toŋge ikura tu ikai ne temba-kula kâki kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Mao nâ, Yakopu ne Maro Kindeni, noko kusuŋa kawa kâki ŋalae lâ, ŋineŋga zugu tamâta rârâni sitavanzi nenzi hosi rârâni nde sipamateteu lâ, kala sikeno tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Maro Kindeni, kinzi tamâta rârâni siruru pâta ŋanano. Ambo noko ma wisi nâna kala pwai kazâŋa panzi, ande tamâta toŋge ma ikura tu imuna ŋana noko ne wisi-nâna ŋinde kâ, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Noko kumo samba ilo, aku kupatea pareŋa-nia panzi tamâta ŋinde lâ. Lâ zoni ndaina noko kumandi ku pwainzi tâno ŋine ne sugorai tamâta rârâni piti lâ kazâŋa ilo, ŋineŋga kupare nia pa nenzi kazâŋa tamâta. Tamâta rârâni simora ŋinde ku siruru ŋalae tina, kala simandi kawanzi buu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Mao nâ, kinzi tamâta sakamao uru wisinzi nâna ŋana noko ne pareŋa-nia, aŋga kinzi tamâta ara nde sindeka ŋana ku sipanea noko ŋa. Noko ne wisi-nâna iŋgeŋge ŋananzi tamâta ara, kala kinzi ŋinde ma siwawano. ");
INSERT INTO xsi_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Miki Maro Kindeni ne tamâta, miki ŋine muŋga kapa ŋgua kuku nemi Maro Yova Kindeni ŋana kaveta mâsi pinde, ande ara, miki ma koka ŋgua pâŋa ŋinde muli nâ. Aŋga miki tinikoa ŋgu, miki kala ma kamege ŋana i ku kakai mbaliŋa pinde kamâ kalua Maro Kindeni, inani uru ivetanzi tamâta siruru ŋana i. ");
INSERT INTO xsi_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","I uru itawanzi tamâta mbâna-mbâna ŋinde uru sipandekâna warakanzi, aku iveta ruruŋa ŋalae panzi tâno ne koipu ŋalaŋala. ");
INSERT INTO xsi_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Naŋa asarâwa pa Maro Kindeni. Naŋa ano papa tu ma ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Malia nde imâ ipâŋga pa naŋa lâ, kala akai noŋa pa Maro Ŋalae. Ikura mbo mbo naŋa asuka mbauŋgu kâki ano pa i lee mbwale pwataki, andeta wisiŋgu ŋandai puu ndue ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Naŋa kaloŋgu ŋgere ŋana Maro Kindeni kâ, kala aveta kusu lâ. Ŋana tu naŋa kaloŋgu loko nâ, aku iloŋgu malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Maro Kindeni isâu pa naŋa tu ma akeno matâŋgu, ande tia. Naŋa iloŋgu malia ndo. Mine kala akura tu aporo ŋgua toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Naŋa kaloŋgu ŋgere ŋana zo ara muŋgâŋa pinde. Mao nâ, naŋa kaloŋgu ŋgere kilo ŋana mbwera muŋgâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Lâ mbo naŋa amo iloŋgu paŋgereŋa nâ. Naŋa iloŋgu ikai wurâta rârâ ku apakasoŋa warakâŋgu mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Tiambo Maro Ŋalae ma ipu muli pa maka ikura zo rârâni, tiya? Tiambo i ma iveta kie ara pama kilo tia tâ. ");
INSERT INTO xsi_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Tiambo i ma tini mwasa pa maka kilo tia, a? Tiambo i ne ŋgua pâŋa ŋinde nde imbe lâ kala ilâ kaa nâ, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Tiambo Maro Kindeni kalo kapa ŋana i ne mâsi ŋana io ne wisi-wisi imâ pa maka, a? Tiambo i ne wisi-nâna nde ikai ne kalo-sukâŋa ŋinde nia, tiya?” ");
INSERT INTO xsi_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Naŋa kaloŋgu ŋgere mine, ŋineŋga aporo pa warakâŋgu tu, “Oyae, Maro Kindeni âta Tamwata nde ipalele ilo kalo kala tini pwâka tu ivila maka kilo.” ");
INSERT INTO xsi_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Andeta Yova Kindeni, naŋa ma kaloŋgu ŋgere kilo ŋana mâsi ŋalaŋala noko kuveta lâ zo muŋgâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Mao nâ, naŋa ma kaloŋgu ŋgere kilo ŋana vetâŋa rârâni noko muŋga kuveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Maro Kindeni, noko ne vetâŋa kaika rârâni nde mao kanaŋo ku sondo ndo. Maro laŋeŋa toŋge irerege kuku maka nema Maro Kindeni noko, ande tia. Noko kupolenzi kinzi rârâni ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Maro Kindeni, noko simbo nâ uru kuveta mâsi ŋalaŋala kie-kie. Muŋgani noko kutula ne walo kaika panzi tinikoa ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Noko muŋga kumandi tava tamwata ne walo kaika ku kuyautenzi ne tamâta piti lâ kazâŋa ilo, kinzi ŋinde pa Yakopu ku Yosepe rua nenzi vâsa ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Maro Kindeni, lâ zo ŋinde tâi ndoni tavanzi lââ rârâni nde siruru lâ noko nao. Mao nâ, tâi geza-geza ilâ wa imâ wa, itogo tamâta iruru mine. ");
INSERT INTO xsi_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Karâzi imbe indue ŋalae ndo, aŋga mbamba nde ipu kaika ŋinde, aŋga noko ne loloa nde salaga-salaga ilâ wa imâ wa ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Noko kuveta mbamba ipu kaika lâ mbilu ŋalae ilo. Loloa nde salaga-salaga nâ kala isinala tâno ndoni, aku tâno tamwata imo ririŋo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Noko pwoka tâi ŋgini-ŋgini kumbwaliu kulâ. Noko ne nzâla ikeno tâi ilo, andeta tamâta toŋge imora noko kie nia, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Noko kumuŋga panzi ne tamâta, itogo lama nenzi katonâŋa imuŋga panzi lama mine. Noko wurâta kulanzi Mose ku Aron rua ŋana sikai poe panzi silâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Miki naneŋgu ŋgu, miki katambira taŋami sondo pa ŋgua ŋine naŋa atu apananami. Kaloŋo naŋa kawâŋgu ŋgua ŋine sondo. ");
INSERT INTO xsi_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Naŋa ma aporo ŋgua tambirâŋa nâ pami. Mao nâ, naŋa ma atula ŋgua pinde duvi pwataki, ŋgua ŋinde nanayoni ikeno paveâŋa lee imâ ipâŋga lâ ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Kinda timbunda sitapâri pama ŋana kelekele ŋinde kâ, aku maka kaloŋo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Kinda ma tavea ŋgua ŋinde ŋananzi natunda ndimo. Ara ŋana kinda ma taporo pwataki panzi nenda vâsa ŋinde ma sipâŋga muli-muli. Kinda ma tapanea Yova Kindeni tatapâri panzi nenda vâsa ŋana i ne walo kaika tava ne mâsi ŋalaŋala muŋga iveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Nanayoni Yova Kindeni itu ŋgua tukuŋa panzi Isrel ŋgu, kinzi Yakopu ne vâsa ŋgu. Ipainzi timbunda tu ma sipanananzi natunzi sondo ŋana i ne ŋgua tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Mine kala kinzi tamâta ŋinde natunzi ma sikura tu sipanâna sondo tona, aku kinzi kala ma sikura tu situla ŋgua tukuŋa pa warakanzi natunzi mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Maro Kindeni ilo tu kinda ma tapanananzi natunda mine ŋana duvi ŋine kâ; i ilo tu timbunda nenzi vâsa rârâni kala ma sio nenzi kalo-tawana ilâ papa i. I tini pwâka tu kinzi ma kalonzi kapa ŋana vetâŋa kie-kie i muŋga iveta ŋinde. I ilo tu kinzi ma sipono muli pa ne tukuŋa ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","I tini pwâka tu kinzi ma sipâŋga simo sitogonzi timbunzi muŋgâŋa mine. Kinzi timbunzi ŋinde taŋanzi kaika ndo, aku sivaligi Maro Kindeni ne ŋgua. Kinzi nenzi kalo-tawana ŋandai ikeno kaika pa i ŋga, kala ŋandai sipono muli sondo papa i ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Kinzi parinanzi nde mine; muŋga kinzi zugu tamâta lâ Efraim ne ŋgu nenzi temba-silâwa nde keno panzi, andeta lâ zo ŋana paraŋa ipâŋga panzi, ande kinzi sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Kinzi sipu mulinzi pa Maro Kindeni ne ŋgua pâŋa. Kinzi tininzi pwâka tu sipaveta kuku i ne tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Kinzi kalonzi kapa ŋana vetâŋa rârâni i muŋga iveta ŋinde. Kinzi kalonzi kapa ŋana mâsi ŋalaŋala ŋinde muŋga kinzi warakanzi simora i iveta. ");
INSERT INTO xsi_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Iveta mâsi ŋalaŋala pinde lâ timbunzi naonzi, lâ zo ŋinde kinzi simo Soan lawea lâ Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Lâ zo ŋinde Maro Kindeni ipu tâi, kala tâi ipwa pwataki mo rua. Iveta tâi ilâ imandi pa pinde, ilâ imandi pa pinde. Ŋineŋga ikainzi Isrel ŋgu soka ŋgini silâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Ikura kari kari, ande isupwa take-take toŋge iyoka imuŋga panzi ilâ. Aŋga ikura mbo mbo, ande isupwa yââ ŋalae ne mela-mela iyoka imuŋga panzi ilâ mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","I ipunzi mira ŋalaŋala pwapwataki lâ nia bilimu, kala iveta lââ ipâŋga panzi ŋana ma sinu kâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Mao nâ, iveta lââ ipâŋga mira ilo ku iyâti imaliŋi imâ, itogo lââ ŋalae irere dugu ilo mine. ");
INSERT INTO xsi_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Maro Kindeni iveta kie ara mine panzi, andeta kinzi soka nenzi vetâŋa siŋga muli aku simo siveta kiesaka nâ papa i. Kinzi simo nia bilimu ku taŋanzi kaika nâ papa Maro Kindeni âta Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Kinzi mainzi tia; siporo ŋgua kaika pa Maro Kindeni. Kinzi sisarâwa kaika papa tu ma kâpwa ilanzi, kâpwa arara ŋinde kinzi ilonzi ŋalae papa. ");
INSERT INTO xsi_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Kinzi siporo ŋgua pavaligiŋa pa Maro Kindeni mine tu, “Tiambo Maro Kindeni ikura tu kâpwa ara ilua kinda lâ nia bilimu, a? ");
INSERT INTO xsi_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Mao nâ, muŋga i ipu mira pwataki ku lââ ŋalae ipâŋga ku irere ndue. Andeta mana mana, a? Tiambo ikura tu puroŋa tava simbi ilua ne tamâta kinda taka tona, tiya?” ");
INSERT INTO xsi_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yova Kindeni iloŋo nenzi ŋgua ŋinde, aku i wisi nâna ŋalae. I ne wisi-nâna nde ipâŋga ŋalae ndo panzi Isrel ŋgu, itogo yââ mela-mela mine, ");
INSERT INTO xsi_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","ŋana tu nenzi kalo-tawana ikeno papa i tia ndo. Kinzi ŋandai kalonzi tawana tu i ikura ŋana ivilanzi ŋana simo ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Andeta Maro Kindeni iporo itu kaika pa nia maa ikeno âta ŋinde, aku ikai samba ne nzâla piti, ");
INSERT INTO xsi_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","ŋineŋga io kâpwa “mana” iyoka pa samba indue imâ. Mao nâ, i samba ne kâpwa ilanzi tamâta tu ma sika. ");
INSERT INTO xsi_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Mine kala kinzi tamâta sika aŋelo kapwanzi. Maro Kindeni kâpwa ŋalae ilanzi, kala sika lee kapwanzi pupuro ndo. ");
INSERT INTO xsi_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Ŋineŋga iveta mbwera ipâŋga lâ nia maa pa mbwera kâ, aku i ne walo kaika ŋinde iveta lawea ŋalae ipâŋga pa nia pinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Ŋineŋga ivetanzi sii rârâ ŋinde silou simâ sindue ŋgininzi itogo karâzi mine. Kinzi sii ŋinde kambwaŋenzi ŋalae tina, itogo tâno ne gawura mine. Aku kambwaŋenzi nde itogo paulo ikeno sâwaneka ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Maro Kindeni ivetanzi sii ŋinde simbe sindue lâ Isrel ŋgininzi lâ nia bilimu, kala sikeno nenzi pâla rârâni ŋgaŋe-ŋgaŋe. ");
INSERT INTO xsi_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Mine kala kinzi tamâta sika lee kapwanzi pupuro. Kâpwa ŋinde kinzi muŋga sita ŋana, ande ŋinde Maro Kindeni ilanzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Kinzi simo sika mine nâ, aku sika marumbu tia yo. ");
INSERT INTO xsi_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Andeta pa zoni ndaina Maro Kindeni wisi nâna ŋalae panzi, kala ipunzi ŋgu ŋinde nenzi tamâta kaika sipamateteu, kinzi Isrel ŋgu nenzi tamâta limoa arara ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Andeta kinzi tamâta simo nâ siveta kiesaka. Maro Kindeni muŋga iveta mâsi ŋalaŋala pinde, andeta kinzi kalonzi tawana i tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Ŋana duvi ŋinde kâ, Maro Kindeni izavarunzi kala naonzi tia ndo lâ. Izavarunzi walele nâ, kala sipamateteu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Lâ zo ŋana Maro Kindeni ipunzi pinde simâte, ande nawalanzi rârâni nde sipalele ilonzi kalonzi ku sitaulo simâ pa i kilo, aku sikai noŋa kaika papa. ");
INSERT INTO xsi_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Kinzi ilonzi kalonzi ipâŋga, kala kalonzi ŋgere kilo tu Maro Kindeni imo nenzi katonâŋa. Kinzi kalonzi ŋgere kilo tu Maro Kindeni âta Tamwata imo nenzi Yautâŋa Tamâta, kala sipono muli pa i kilo. ");
INSERT INTO xsi_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Andeta kinzi ŋandai sipalele ilonzi kalonzi mao ŋga; kawanzi laŋeŋa nâ sikai laŋeŋa papa i. ");
INSERT INTO xsi_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Kinzi sipu mulinzi pa i kawa ŋgua kilo, aku ŋgua pâŋa ŋinde i muŋga iveta kunzi, ande ŋinde kinzi sipu ututu. ");
INSERT INTO xsi_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Andeta Maro Kindeni i nde kalo-sukâŋa warika. Mine kala izavaru nenzi kiesaka piti lâ tininzi, aku i ŋandai iyaulanzi ŋga. Itawa tamwata ne wisi-nâna ndue mbwani rârâ, aku i wisi nâna ŋalae koŋa pa kinzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Ŋana tu isama kilalanzi pwataki mine tu kinzi nde tamâta nâ. Kinzi sitogo lawea iyoka imâ ku nao tia walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Naŋa aporo ŋguani ndaina kilo; lâ zo ŋinde kinzi simo nia bilimu, ande kinzi taŋanzi kaika papa i ku siveta i ilo malia mbwani rârâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Kinzi simo nâ sikai samâŋa pa Isrel nenzi Maro Kindeni, i Sapâŋa Tamwata, kala siveta i wisi nâna ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Kinzi kalonzi kapa ŋana i ne walo kaika ŋalae, aku kalonzi kapa ŋana zo muŋgâŋa ŋinde iyautenzi piti lâ kazâŋa tamâta mbaunzi ilo tona. ");
INSERT INTO xsi_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Pa zo ŋinde iveta mâsi ŋalaŋala kie-kie lâ Soan lawea, lâ Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Maro Kindeni iveta mine; ipulia Isip nenzi lââ rârâni ipâŋga see. Mine kala tamâta kanzi lââ ara keno ŋana sinu kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Aku isupwanzi lâŋo rârâ silâ sipâŋga panzi, aku lâŋo simo sikâonzi nâ. Aku isupwanzi piri-piri kala silâ sipâŋga panzi ku siyaula nenzi tâno tona. ");
INSERT INTO xsi_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Aku Maro Kindeni isupwanzi ndemu-ndemu kala silâ sipâŋga nenzi tâno ilo, ku sika kâpwa wa kâi bâŋa launzi rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","I io karâzi ŋalae itogo “ais” mine imbe indue, aku ŋinde iyaula nenzi kâi waini ndoni. Aŋga pisi ŋalae ipâŋga ku iyaula nenzi kâi “fik” tona, kala putole ipunzi. ");
INSERT INTO xsi_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","I io karâzi ŋalae itogo “ais” mine imbe ndue, aku “ais” ŋinde ipunzi nenzi bulmakao pâta sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Ipaliŋi ne wisi-nâna ŋalae ŋinde ilâ panzi Isip ŋgu, aku isupwanzi aŋelo sikai i ne wisi-nâna ŋinde silâ ku sizavarunzi ndo. ");
INSERT INTO xsi_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","I wisi nâna ŋalae tina panzi, kala igeranzi tia ndo. I io pukoŋa sakamao ilâ panzi ŋana ipunzi pâta simâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Ipunzi Isip ŋgu natunzi tamâne nzâla-kulu rârâni sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Ŋineŋga ikainzi i ne tamâta siyâti silâ, aku iyoka imuŋga panzi itogo lama nenzi katonâŋa imuŋga panzi lama mine. Itula nzâla panzi lâ nia bilimu, ku ikea ŋananzi. ");
INSERT INTO xsi_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ikai poe sondo ndo panzi, kala simo ara nâ. Mine kala kinzi siruru tia. Aŋga tâi nde imâ ipatukunzi nenzi kazâŋa tamâta kala simbwatuke marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Ikainzi ne tamâta silâ pa i tamwata ne tâno. Ikainzi silâ pa nia tuu ŋinde muŋgani i tamwata ipole lâ paraŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Maro Kindeni ne tamâta kinzi soka silâ, aŋga Maro Kindeni nde imuŋga panzi iŋaranzi tinikoa ŋgu piti lâ tâno ŋinde. Ŋineŋga ikisi tâno ne keri panzi Isrel ŋgu rârâni, aku ionzi simo sondo lâ nenzi pâla ilo. ");
INSERT INTO xsi_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Andeta kinzi Isrel ŋgu taŋanzi kaika pa Maro Kindeni âta Tamwata, kala siveta i wisi nâna. Kinzi ŋandai sipono muli pa i ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Kinzi sipu mulinzi papa ku siveta vetâŋa potomule, itogo timbunzi muŋga siveta mine. Kinzi sitogo silâwa toŋge imwaŋgi kala uru iyoka sondo tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Kinzi siveta patarawâŋa nia pinde panzi maro laŋeŋa, aku nenzi vetâŋa ŋinde iveta Maro Kindeni wisi nâna panzi. Kinzi mbaunzi sipare maro laŋeŋa tainzi lâ kâi tini, kala Maro Kindeni wisi nâna ndo. ");
INSERT INTO xsi_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Maro Kindeni imora nenzi vetâŋa ŋinde, aku i wisi nâna ŋalae tina panzi. Mine kala ipu muli ndo pa kinzi Isrel ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Mao nâ, ipile ne pâla ikeno Silo lawea, niani ndaina i tamwata muŋga imo kunzi tâno tamâta, aku ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Aku isâu panzi kazâŋa tamâta tu sipanawe ŋgua pâŋa ne sopi, sopi ŋinde uru itula Maro Kindeni kilala pwataki panzi Isrel ŋgu tu i ne walo nde kaika, aku i nde ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Mao nâ, i wisi nâna panzi i tamwata ne ŋgu, kala isâu panzi kazâŋa tamâta tu ma simâ sipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Kinzi tamâta limoa nde sipamateteu lâ paraŋa ilo. Mine nde kinzi taine taipa sikura tu sikâe kaiwanzi tamâne, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Aku kinzi kazâŋa tamâta sipunzi Isrel nenzi patarawâŋa tamâta pâta simâte lâ, taitu patarawâŋa tamâta ŋinde kaiwanzi taine sikura tu sikai kalo-kalo ku sita ŋananzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Ŋineŋga Maro Ŋalae ipagagati tamwata, itogo tamâta ipagagati lâ kenoŋa nia mine. Ipâŋga itogo tamâta kaika toŋge inu lââ kaika rârâ kala wisi kâki mine. ");
INSERT INTO xsi_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Mao nâ, Maro Ŋalae wisi kâki kala ilâ ipara kunzi kazâŋa tamâta, aku iŋaranzi sikâwa pwapwataki silâ. I ipolenzi ndo lâ, kala kinzi mainzi pâta kanaŋo. Kinzi sikura tu sipara kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Ŋineŋga ipu muli pa Yosepe ne vâsa ŋgu, aku i ŋandai ipatea kinzi Efraim ne vâsa ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Andeta ipateanzi Juda ne vâsa ŋgu, aku ipatea Saion Tuu tona, tuu ŋinde i ilo ndo keno papa. ");
INSERT INTO xsi_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Ŋineŋga i ipa ne luma sapâŋa kâki lâ tuu ŋinde kulu, aku iveta luma ŋinde imandi kaika ikura zo rârâni, itogo samba wa tâno mine. ");
INSERT INTO xsi_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Aku Maro Ŋalae ipatea ne wurâta tamâta Daviti, ina muŋga ikai wurâta ŋana ikatonanzi lama kâ. ");
INSERT INTO xsi_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Aku itoto Daviti ne wurâta ŋinde, ku io ikai koipu ŋalae panzi Isrel ŋgu. Mine kala Daviti ipâŋga tamâta ŋana ikatonanzi Maro Kindeni ne ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Daviti ilo ndo keno pa ne wurâta ŋinde nâ. Mine kala ikatonanzi sondo ndo, aku imo nenzi poe tamâta ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Maro Kindeni, kinzi tinikoa ŋgu nde simâ sipâŋga noko ne tâno ŋine marumbu lâ, kala sipara kuku noko ne tamâta maka. Kinzi siveta mâsi sakamao pa noko ne luma sapâŋa, kala luma ŋinde ipâŋga muso ndo. Aku siyaula Jerusalem lawea ndo tona. ");
INSERT INTO xsi_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Kinzi kazâŋa tamâta ŋinde sipunzi noko ne tamâta pâta sipamateteu lâ, aku sipile karaenzi ikeno tâno kulu. Mine kala kinzi sii wa ŋgoa ŋgoi wa sika noko ne wurâta tamâta ŋinde karaenzi. ");
INSERT INTO xsi_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Kinzi sipunzi noko ne tamâta pâta sipamateteu, kala seenzi imaliŋi ku irere ilâ ikura Jerusalem lawea ndoni, itogo lââ irere mine. Andeta tamâta toŋge imo ŋana ikea karaenzi kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Tinikoa ŋgu pinde simo nema lawea tini laiti, aku kinzi ŋinde uru siporo ŋgua pavaligiŋa pa maka. Kinzi siŋeleama pâta lâ, aku siveta maŋeti nâ pama. ");
INSERT INTO xsi_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Yova Kindeni, tiambo noko ma wisi nâna pa maka ikura zo rârâni, tiya? Tiambo noko ne wisi-nâna ŋinde ma imo itogo yââ mela-mela mine ku imo nâ, a? ");
INSERT INTO xsi_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Maka kano pano tu kuo ne wisi-nâna ŋinde ilâ panzi tamâta ŋgu pinde, kinzi ŋinde sipu mulinzi pano. Pwai kazâŋa panzi tamâta ŋinde tininzi pwâka tu sikai noŋa pano. ");
INSERT INTO xsi_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Kinzi ŋgu ŋinde sipunzi noko ne tamâta pâta simâte lâ, aku siyaula noko ne tâno ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Noko ma kupare nia pa maka ŋana kiesaka ŋinde maka timbuma muŋga siveta, mine ndimo. Kalo-lokoni nde iveta iloma malia ndo. Mine kala maka kano pano tu kalo sukâŋa walele nâ ŋanama! ");
INSERT INTO xsi_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Maro Kindeni, maka nema Pavilâŋa Tamwata noko, maka kano pano tu kuvilama. Tia ma kinzi tamâta sivaligi noko ŋa. Pwaima piti lâ kazâŋa ilo, aku kuzavaru nema kiesaka ndoni piti lâ tinima! Tia ma noko ŋa ipâŋga sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Ŋana tu kinzi ŋgu pinde uru siveta maŋeti pama ku sikasoŋama mine tu, “Aŋga miki nemi Maro Kindeni nde imo ndia, a?” Kinzi sipunzi noko ne wurâta tamâta pâta simâte. Maka iloma tu noko ma kupare nia panzi lâ maka naoma ŋana nenzi vetâŋa ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","O Maro Kindeni, maka tamâta rârâ kamo nema kazâŋa tamâta nenzi luma sakamao ilo. Maka kano pano tu kupaloŋo pa nema tiŋa. Kinzi kazâŋa tamâta sipa ŋgua tu ma sipu maka pâta kamâte. Taitu noko ne walo kaika nde ŋalae. Mine nde pwea ŋanama! ");
INSERT INTO xsi_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Opopo, kinzi kazâŋa tamâta nde siporo ŋgua pavaligiŋa rârâ ŋinde pa noko. Mine nde Maro Ŋalae, maka kano pano tu kupare nenzi vetâŋa sakamao ŋinde itaulo panzi ikura mbwani lima kanaŋo rua. ");
INSERT INTO xsi_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ambo noko ma kuveta mine, ande noko tamwata ne lama ŋgu maka ma kapanea noko mine ku kamo nâ. Aku maka nema vâsa kinzi rârâni kala ma sio nenzi paneâŋa imâ pano ikura zo rârâni mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","O Isrel ŋgu nema katonâŋa tamâta, kutambira taŋa pa maka. Noko uru pwai poe papa ne lama ŋgu maka. Kupaloŋo pa nema noŋa ŋga! Noko kumo koipu ŋalae ne saŋonâŋa nia ŋinde ikeno kinzi aŋelo ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Maka kano pano tu kupatua tamwata pa maka Efraim, Benjamin aŋga Manase nenzi vâsa ŋgu. Kutula ne walo kaika ŋalae ŋinde pama, aku kumâ pwaima piti lâ kazâŋa ilo! ");
INSERT INTO xsi_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Maro Kindeni, kuveta maka kamo ara kilo. Kalo sukâŋa ŋanama, aku kuvilama ŋana kazâŋa ŋine ma iyaula maka tia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Yova Kindeni, noko Maro Walo Tamwata, noko ma wisi nâna ŋana ne tamâta maka nema noŋa kâ ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Noko kuveta maka kata pâta kala matama sulu irere ndue. Noko kuveta nema tiŋa ŋinde ipâŋga itogo kama kâpwa mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Noko kusâu panzi tinikoa ŋgu ŋinde simo nema lawea tini laiti, kala kinzi simâ lâ sipara ku sipakawea nema tâno. Opopo, maka nema kazâŋa tamâta situ laginama wa siŋeleama wa. ");
INSERT INTO xsi_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Maro Kindeni Walo Tamwata, kuveta maka kamo ara kilo. Kalo sukâŋa ŋanama, aku kuvilama ŋana kazâŋa ŋine ma iyaula maka tia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Maka Isrel ŋgu nde katogo noko tamwata ne kâi waini. Muŋga noko pwai kâi waini ŋinde piti lâ Isip tâno, aku pwai kulâ. Ŋineŋga noko kuŋaranzi tinikoa ŋgu lâ nenzi tâno, aku kupau kâi waini ŋinde lâ tânoni ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Noko kuyawo tâno ku kuveta nia papa lâ, ŋineŋga kupau lâ. Aku kâi ŋinde mburu-mburu indue ilâ tâno ilo, aku ipâŋga ŋalae ŋinde ku ilâ itura tâno ŋinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Aku kâi waini ŋinde laka nde ilâ ipono Lebanon nenzi tuu wa kâi matapuru ŋalaŋala rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Kâi waini ŋinde ne laka pinde nde ilâ lee ipâŋga tâi pwali, aŋga laka pinde nde ilâ lee ipâŋga Yufretis Lââ ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Mine nde ŋana sâ kâ ŋga noko kuzavaru ŋgumbi ŋinde muŋga iŋge kâi waini ŋinde, a? Noko kuveta mine lâ, kala tamâta rârâni soka nzâla ŋinde nde sipanawe kâi ŋinde kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Aku kinzi ŋgoa ŋgoi kenzi nâ sipale kâi ŋinde, aŋga kelekele rârâni simo vianzi lâ dugu ilo ŋinde nde uru simâ sika kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","15","Maro Kindeni, noko Walo Tamwata, kupalele nao pa maka kilo ŋga! Noko kumo samba ilo; maka kano pano tu mata ndue kumora maka. Pwatona kâi ŋine noko tamwata mbau kaika muŋga kupau kala kuveta ipâŋga ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Maka nema kazâŋa tamâta nde sitoto kâi ŋinde piti lâ, ŋineŋga sirumbia lâ yââ. Maka iloma tu noko ma wisi nâna panzi ku kuzavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Maka kano pano tu pwea ŋana maka tamâta ŋine noko tamwata muŋgani kupatea pa tamwata. Pwatona ŋgu ŋine muŋga noko tamwata kuvetama kapâŋga tava walo kaika. ");
INSERT INTO xsi_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ambo noko ma kuveta mine, ande maka ma kapu mulima pa noko kilo tia ku tia ndo. Ambo noko ma kuvilama, ande maka ma kapaneano kasuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Maro Yova Kindeni Walo Tamwata, kuveta maka kamo ara kilo. Kalo sukâŋa ŋanama, aku kuvilama ŋana kazâŋa ŋine ma iyaula maka tia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Miki rârâni kandeka ku kapanea nenda Pavilâŋa Tamwata Maro Kindeni kasuka i ŋa kâki! Kawâŋgi wâŋgiŋa paneâŋa kâ pa Yakopu ne Maro Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Miki kara wâŋgu ku kambana kauro kie-kie. Kaveta wâŋgiŋa kaŋa ara nâ ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Miki kambana tando lâ zo ŋana nzimona ipâŋga wasaseki wa zo ŋana nzimona ipâŋga ŋalae wa, ŋana itula pwataki tu kumbwa ne zo nde ŋga ipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Ŋana tu kinda Isrel nenda ŋgua tukuŋa ikeno tu kinda ma taveta mine. Ŋinde nde Maro Kindeni ne tukuŋa, ina Yakopu ne Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Nanayoni, lâ zo ŋinde Maro Kindeni iŋgoloa paraŋa lâ Isip tâno, ande i tukuŋa ŋinde ilua kinda Isrel ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Lâ zo ŋinde, kinda timbunda kinzi siloŋo tamâta toŋge kawa iporo ŋgua, andeta sisama i kilala tia. Iporo mine tu, “Muŋga, lâ zo ŋinde miki kamo Isip tâno, ande naŋa akai malia rârâni piti lâ kalami, aku asâu pami tu ma mbaumi piti lâ nemi ŋgâmo malia tini. ");
INSERT INTO xsi_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Malia ŋalae tina nde imâ ipâŋga pami lâ, aku lâ zo ŋinde miki kasarâwa pa naŋa. Ŋineŋga naŋa akaimi piti lâ kazâŋa ilo, kala kamo ara nâ. Naŋa amo take-take mâmâŋga ŋalae toŋge ilo, aku apaloŋo pa nemi noŋa. Aku muli ŋga miki kalâ lee kapâŋga Meriba Lââ bwalika tini, ŋineŋga naŋa akai samâŋa pami. ");
INSERT INTO xsi_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Miki naneŋgu tamâta, kala ŋine naŋa atu aporo ŋgua kaika pami. Miki Isrel ŋgu, naŋa iloŋgu ndo tu miki ma kaloŋo naneŋgu ŋgua ŋine sondo. ");
INSERT INTO xsi_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Naŋa tiniŋgu pwâka tu kinzi tinikoa ŋgu nenzi maro ma simo ŋginimi. Miki ma kapare tukumi pa tinikoa ŋgu nenzi maro laŋeŋa ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Naŋani nâ nde miki nemi Maro Yova Kindeni. Naŋani warakâŋgu nâ muŋga ayautemi piti lâ Isip tâno kala akaimi kayâti kamâ. Ambo miki ma kawami nzaŋa, ande naŋa ma kâpwa alami kaka. ");
INSERT INTO xsi_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Andeta tia. Naneŋgu tamâta tininzi pwâka tu siloŋo naneŋgu ŋgua. Kinzi taŋanzi kaika nâ kala sipu mulinzi pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Mine kala naŋa asâu panzi tu ma simo siveta taŋa-kaika ne mâsi. Naŋa asâu panzi tu ma siveta vetâŋa ndia kinzi warakanzi ilonzi papa. ");
INSERT INTO xsi_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Naŋa iloŋgu ndo tu naneŋgu tamâta ma soka naneŋgu ŋgua muli. Naŋa iloŋgu ndo tu kinzi Isrel ŋgu ma sipono muli pa naŋa ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Ambo kinzi ma siveta mine, ande naŋa ma walele nâ apunzi nenzi kazâŋa tamâta ndue. Naŋa ma apara kunzi kazâŋa tamâta ŋinde ku ma apolenzi ndo. ");
INSERT INTO xsi_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Ŋineŋga tamâta ea ilonzi sakamao papa naŋa Yova Kindeni, kinzi ŋinde ma siruru pâta ku ma naonzi tundu naŋa keŋgu tini laiti. Aku naŋa ma apare nia panzi ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Mao nâ, ambo naneŋgu tamâta miki ma kapono muli pa naneŋgu ŋgua, ande naŋa ma kâpwa ara ndo alami, kala miki ma kaka kâpwa mona-mona ŋinde lee kapwami pupuro.” ");
INSERT INTO xsi_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Maro Kindeni nde isaŋona koipu ŋalae ne saŋonâŋa nia ku ikai poe pa pasauŋa ŋalae lâ samba ilo. Ionzi maro laŋeŋa simandi ŋgua nia, ŋineŋga ipatula tamwata ne ilo-kalo pwataki panzi. ");
INSERT INTO xsi_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Iporo mine tu, “Lâ zo ŋana miki kaloŋo tamâta nenzi ŋgua lâ ŋgua nia, ande miki kaveta nenzi ŋgua sondo tia ndo. Miki uru kavilanzi tamâta sakamao nâ. Miki ma kaveta mine kilo ndimo! ");
INSERT INTO xsi_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ara ŋana miki ma kavilanzi tamâta ŋinde nenzi walo tia, sitavanzi lâlu ŋinde tamanzi simâte lâ. Ara ŋana miki ma kaveta kemi ara panzi tamâta ŋinde uru sikai malia kie-kie, sitavanzi kinzi sugorai tamwatanzi. ");
INSERT INTO xsi_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Kinzi tamâta ŋinde nde simo sugorai ndo, aku sikura ŋana sipavila warakanzi kâ, ande tia. Ara ŋana miki ma kayautenzi piti lâ kinzi tamâta sakamao mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Miki ilomi kalomi tia ndo! Miki kapâŋga kapa lâ! Miki uru koka kondoma ilo; mine nde miki kaveta vetâŋa ara toŋge panzi tamâta tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Nanayoni naŋa aporo mine tu, ‘Miki nde maro ŋalaŋala. Nia ndoyo naŋa apuliami kapâŋga lâ. Mine kala miki rârâni kamo katogo naŋa Yova Kindeni âta Tamwata natuŋgu wukale mine.’ ");
INSERT INTO xsi_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Andeta miki ma muli kamâte itogo tamâta uru simâte mine. Kinzi koipu rârâni simo vianzi lee ŋineŋga simâte, aku miki nemi via kala ma marumbu mine nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Maro Kindeni, kumâ pwai poe panzi tamâta rârâni lâ tâno kulu! Kinzi tamâta ŋgu rârâni ande noko tamwata nâ ne. ");
INSERT INTO xsi_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Maro Kindeni, noko ma kawa buu ndimo. Noko ma tini pwâka ku pwai kusaŋona nâ ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Kumora ŋga, noko ne kazâŋa tamâta nde sipagagati ŋana siŋgoloa paraŋa kâ. Kinzi wisinzi nâna nâ pa noko, kala sirurua kulunzi pano. ");
INSERT INTO xsi_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Kinzi sipavea nâ ku sipa ŋgua tu ma sikai kazâŋa panzi noko ne tamâta. Kinzi situ sizavarunzi tamâta ŋinde noko ilo ndo keno panzi. ");
INSERT INTO xsi_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Kinzi siporo mine tu, “Ayo, kinda ma talâ tazavarunzi Isrel ŋgu ndo lâ. Ŋineŋga tamâta toŋge ma muli kalo ŋgere ŋananzi kilo, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Kinzi nde ilonzi taitu ku sipambwâre tu ma sipavila ŋana sitawa noko ndue. ");
INSERT INTO xsi_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Kinzi ŋgu ŋine nde simâ taitu ŋana sikai kazâŋa pano; kinzi Idom ŋgu wa, kinzi Ismael ŋgu wa, kinzi Moap ŋgu wa, kinzi Hakri ŋgu wa, ");
INSERT INTO xsi_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","kinzi Gebel ŋgu wa, kinzi Amon ŋgu wa, kinzi Amalek ŋgu wa, kinzi ŋgu ŋinde simo Filistia tâno wa Tair lawea wa. ");
INSERT INTO xsi_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Aku kinzi tamâta kaika lâ Siria ŋgu kala silâ taitu kunzi tona, aku simandi ŋana sisukanzi Loto ne vâsa ŋgu ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Naŋa ano pano tu ma kuveta vetâŋa kie taituni panzi, itogo muŋga kuveta panzi Midian ŋgu mine. Kuveta panzi itogo muŋga kuveta pa koipu ŋalae Jabin kuku i ne zugu tamâta nenzi koipu Sisera rua, lâ Kison Lââ pwali. ");
INSERT INTO xsi_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Lâ zo ŋinde noko kuzavarunzi lâ Endo lawea, aku karaenzi nde sisâmbu nâ sikeno tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Naŋa iloŋgu tu noko ma kuveta vetâŋa kie taituni pa nenzi tamâta mbâna-mbâna, itogo muŋga kuveta panzi koipu rua Orep ku Sep rua mine. Kupolenzi nenzi katonâŋa lâ vetâŋa kie taituni itogo muŋga noko kuveta panzi koipu ŋalae rua Seba ku Salamuna rua mine. ");
INSERT INTO xsi_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Lâ zo ŋinde kinzi koipu ŋinde siporo mine tu, “Ayo, talâ takai Maro Kindeni ne tâno ara ŋinde pa warakânda nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Naneŋgu Maro Kindeni, naŋa iloŋgu tu noko ma kuŋaranzi sikâwa pwapwataki silâ, itogo tâno ne gawura ŋinde lawea itapala kala ilâ potomule mine. ");
INSERT INTO xsi_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Naŋa iloŋgu tu noko ma kuzavarunzi, itogo yââ ikana kâi simandi dugu ilo, aku ilâ ikana leu ŋinde imandi nia ndamwa tona. ");
INSERT INTO xsi_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Naŋa iloŋgu tu noko ma kuveta vetâŋa kie taituni nâ, aku kuo karâzi ŋalae imbe ndue ku iŋaranzi ŋgu ŋinde sikâwa pwapwataki. Kusupwa lawea iyoka kaika ndo ilâ panzi ku iveta ruruŋa ŋalae panzi. ");
INSERT INTO xsi_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Yova Kindeni, naŋa iloŋgu tu noko ma kuveta kinzi mainzi pâta. Ŋineŋga kinzi ma sisuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Naŋa iloŋgu tu noko ma kupolenzi ndo, kala kinzi ma simo siruru nâ ikura zo rârâni. Ara ŋana kinzi ma mainzi ŋalae lee simâte ku naonzi tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Ara ŋana noko ma kuveta mine panzi, ŋana tu ŋinde ma itula noko tamwata kilala pwataki panzi tu noko kumo Maro Ŋalae. Yova Kindeni âta Tamwata, kutula pwataki panzi tu noko simbo nâ pwai poe pa tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Yova Kindeni, noko Walo Tamwata, noko ne luma sapâŋa nde ara ku ara ndo! ");
INSERT INTO xsi_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Naŋa iloŋgu ndo tu ma amo noko ne luma ŋinde ilo. Naŋa andeka awâŋgi wâŋgiŋa paneâŋa kâ pa Maro Kindeni Via Tamwata tava karaeŋgu ndoni wa iloŋgu kaloŋgu ndoni wa. ");
INSERT INTO xsi_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yova Kindeni, noko Walo Tamwata, naneŋgu koipu ŋalae noko. Naneŋgu Maro Kindeni kala noko. Mao nâ, noko ne luma sapâŋa nde ara ndo; mine nde kinzi sii kiri-kiri sindeka ŋana siveta palanzi lâ noko ne patarawâŋa nia tini laiti, aku sikatonanzi natunzi lâ niani ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Tamâta pinde uru simo noko ne luma ilo, aku kinzi ŋinde kala simo sindeka mine nâ. Ikura zo rârâni kinzi simo siwâŋgi wâŋgiŋa paneâŋa kâ pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Noko tamwata ne nzâmbe ara ikeno panzi tamâta pinde, aku kinzi ŋinde kala sindeka ikura zo zo. Mine nde ilonzi gagatinzi ŋana sikâki silâ pa Saion Tuu. ");
INSERT INTO xsi_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Kinzi soka silâ, aku lâ zo ŋana soka nia bilimu, ande nia mâsa-mâsa ŋinde kala indeka ku ipâŋga itogo nia ara lââ uru sâko keve ilo mine. Ŋinde itogo karâzi imbe ŋalae ku iveta tâno ŋinde ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Kinzi sikâki lee, aku nenzi walo ipâŋga ŋalae. Mao nâ, kinzi ma simandi lâ kinzi maro rârâni nenzi Maro Kindeni nao lâ Saion Tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Maro Yova Kindeni Walo Tamwata, kupaloŋo pa naneŋgu noŋa. Noko Yakopu ne Maro Kindeni, kutambira taŋa sondo pa naŋa! ");
INSERT INTO xsi_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Maro Kindeni, naŋa ano pano tu kuveta kie ara pa maka nema koipu ŋalae, inani noko tamwata kupatea lâ. ");
INSERT INTO xsi_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Ambo naŋa ma akura tu amo noko ne luma ilo ikura kari taitu mai nâ, ande naŋa ma andeka ŋalae tina. Ndekâŋa ŋinde ma ipole naneŋgu ndekâŋa ŋana amo nia arara pinde ikura zo luandondo. Ambo naŋa ma akura tu amandi luma sapâŋa ne nzâla kawa pa nia yo nâ, ande naŋa ma andeka ŋalae ŋana ŋinde kâ, aku ndekâŋa ŋinde ma ipole naneŋgu ndekâŋa ŋana amo kinzi mbaliŋa warakanzi nenzi luma ilo. ");
INSERT INTO xsi_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Yova Kindeni ikatona kinda itogo maramuŋa mine, aku inani uru ikai poe pa kinda, itogo sinâla mine. I uru iveta kie ara ndo pa kinda wa isuka ŋânda kâki wa. Tamâta ea kinzi uru sipaveta kuku vetâŋa ara, ande Yova Kindeni ma isilikana kelekele ara toŋge ŋananzi tamâta ŋinde, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Yova Kindeni, noko Walo Tamwata, tamâta ea kalonzi tawana noko, ande kinzi ŋinde ma sindeka mine ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Yova Kindeni, nanayoni noko kuveta kie ara panzi tamâta simo noko ne tâno. Mao nâ, noko kuvilanzi Isrel ŋgu kala simo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Noko kuzavaru kiesaka piti lâ ne tamâta tininzi, aku noko ŋandai kupare nia panzi ŋana vetâŋa soki rârâni muŋga siveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Muŋga, noko wisi nâna ŋalae panzi, taitu muli ŋga, ande noko kupile ne wisi-nâna ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Maro Kindeni, nema Yautâŋa Tamwata, kala ŋine maka kano pano tu kuveta kie ara taituni ndaina pa maka kilo. Noko uru wisi nâna pa maka ku kumo nâ. Kupile ne wisi-nâna ŋinde ŋga! ");
INSERT INTO xsi_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Tiambo noko ma wisi nâna pa maka ikura zo rârâni, a? Tiambo noko ne wisi-nâna ŋinde ma marumbu tia, a? ");
INSERT INTO xsi_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Maka kano pano tu kuveta maka kamo ara kilo. Ŋineŋga noko ne tamâta maka ma kandekanano kapanea noko ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Yova Kindeni, maka iloma tu noko ma kutula pwataki tu noko ne tini-mwasa ikeno pama ikura zo rârâni. Pwaima piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Ara, kala ŋine naŋa ma atambira taŋâŋgu sondo pa Maro Yova Kindeni kawa ŋgua. I ne ŋgua pâŋa ikeno mine, “Ambo naneŋgu tamâta ma sipile mâsi potomule muŋga siveta ŋinde, ande naŋa ma avetanzi simo ara nâ.” I ne ŋgua pâŋa kala ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Mao nâ, i nde iluku lâ ŋana ikainzi tamâta piti lâ kazâŋa ilo, kinzi ŋinde uru simege ŋana i kâ. Ŋineŋga i tamwata ma imo kuku maka tava ne walo kaika ŋalae lâ nema tâno ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Aku lâ zo ŋinde Yova Kindeni ne tini-mwasa ma ipakâtu kuku tamâta nenzi mâsi ŋana soka i ne ŋgua pâŋa muli. Aku kinzi nenzi vetâŋa sondo kuku i ne wisi-pisi rua ma sipatâŋo. ");
INSERT INTO xsi_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Mao nâ, kinzi tamâta nenzi mâsi ŋana sipono muli pa Yova Kindeni lâ tâno kulu ma ipakâtu kuku Yova Kindeni ne mâsi ŋana iveta vetâŋa sondo panzi tâno tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yova Kindeni ma iveta maka kamo ara nâ, aku kâpwa ma ipâŋga maria lâ nema tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Yova Kindeni ne mâsi ŋana iveta vetâŋa sondo kâ ma imuŋga papa i ilâ, aku ma iveta nzâla sondo papa i tamwata tu ma imâ kâ. ");
INSERT INTO xsi_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Yova Kindeni, naneŋgu kaika keno tia, aku akura tu apasuka warakâŋgu kâ, ande tia. Mine kala ano pano tu kupaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Naŋa uru apono muli sondo pa noko nâ. Mine kala ano pano tu kutiŋgi mateŋa piti iŋgeŋge ŋanana. Naŋa amo noko ne wurâta tamâta, aku kaloŋgu tawana noko nâ. Mine nde kumâ kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Naneŋgu Maro Kindeni, naŋa ano pano tu kalo sukâŋa ŋanana, ŋana tu naŋa uru akai noŋa pa noko ikura kari wa mbo wa. ");
INSERT INTO xsi_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Maro Ŋalae, kuveta ne wurâta tamâta naŋa iloŋgu ndeka, ŋana tu naŋa uru akai noŋa pa noko simbo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Maro Ŋalae, noko nde ara tamwata, aku kuzavaru naneŋgu kiesaka piti lâ tiniŋgu. Ikura zo zo, noko tini mwasa ndo panzi tamâta rârâni ŋinde uru sino pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yova Kindeni, kutambira taŋa pa naneŋgu noŋa. Naŋa asarâwa pano tu kuvilana. Kupaloŋo pa naneŋgu sarawâŋa! ");
INSERT INTO xsi_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Noko uru kupaloŋo pa naneŋgu noŋa. Mine kala lâ zo ndia malia isânda kuluŋgu, ande naneŋgu sarawâŋa imâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Maro Ŋalae, naŋa asama tu maro toŋge nde irerege kuku noko, ande tia ndo. Noko kupolenzi maro rârâni marumbu lâ. Maro toŋge ikura tu iveta vetâŋa itogo noko uru kuveta mine, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Nia ndoyo noko kupulianzi tamâta ŋgu ndoni sipâŋga lâ, aku muli ŋga kinzi tinikoa ŋgu rârâni ma simâ sipare tukunzi pano, ku ma sipanea noko ŋa sisuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Ŋana tu noko ne walo kaika nde ŋalae, aku noko uru kuveta vetâŋa arara kie-kie. Noko simbo nâ nde Maro mao. ");
INSERT INTO xsi_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yova Kindeni, ambo noko ma kupananana ŋana vetâŋa ndia noko ilo tu naŋa ma aveta, ande naŋa ma apono muli pa pateâŋa ŋinde ikura zo rârâni. Kupananana sondo, ŋana naŋa ma ao iloŋgu ndo ilâ pa noko wa amege ŋanano wa. ");
INSERT INTO xsi_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Maro Ŋalae, naneŋgu Maro Kindeni noko, naŋa apanea noko tava iloŋgu kaloŋgu ndoni. Naŋa ma awawano asuka noko ŋa kâki ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Opopo, noko ne tini-mwasa pa naŋa nde ŋalae ŋinde, aku kumo mine ku kumo nâ. Muŋga, ande mateŋa itu ikai naŋa, andeta noko kuvilana kala ŋandai amâte ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Kinzi taŋa-kaika tamwatanzi nde simâ sipâŋga lâ, kala situ sikai kazâŋa pa naŋa. Kinzi uru siveta kenzi sakamao nâ panzi tamâta pinde, aku kala ŋine situ sipu naŋa pâta amâte. Kinzi ilonzi tu Maro Kindeni nde maro kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Andeta Maro Ŋalae, noko nde kalo-sukâŋa warika wa wisi-wisi warika wa, aku noko uru wisi nâna walele, ande tia. Noko ne tini-mwasa ŋalae ŋinde uru ikeno mine ku imo nâ, aku noko uru kuveta ikura tamwata ne ŋgua pâŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Kupalele nao pana ku kalo sukâŋa ŋanana! Kuo ne walo kaika imâ pa ne wurâta tamâta naŋa ku kuvilana, ŋana tu naŋa uru apono muli pa noko nâ. ");
INSERT INTO xsi_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Yova Kindeni, naŋa iloŋgu tu noko ma kuveta mâsi toŋge ŋana kutula pwataki pa naŋa tu noko nde ara tamwata. Ambo noko ma kuveta mine, ande kinzi kazâŋa tamâta ma sisama tu nokoni kuvila naŋa ku kupu tini kaika pana. Ŋineŋga kinzi ma mainzi ŋana nenzi vetâŋa soki kâ. ");
INSERT INTO xsi_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Muŋgani, Yova Kindeni iveta tamwata ne lawea ŋalae imandi ne tuu sapâŋa kulu. ");
INSERT INTO xsi_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Lawea rârâ nde keno Isrel nenda tâno. Andeta Yova Kindeni ilo ndo ikeno pa Saion lawea, aku i ne morâŋa tu lawea ŋinde ipole lawea pinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Mine kala miki tamâta ŋine kamo Maro Kindeni ne lawea, miki kaloŋo ŋga! Maro Kindeni uru iporo ŋgua arara nâ ŋana miki kâ. ");
INSERT INTO xsi_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Iporo mine tu, “Kinzi tinikoa ŋgu rârâni ma muli sipaveta kuku naneŋgu ŋgua. Naŋa aporo ŋananzi tinikoa ŋgu ŋinde simo Isip tâno wa Babilon lawea wa Filistia lawea wa Tanis lawea wa Itopia tâno wa. Kinzi ŋinde ma sipâŋga sitogo Saion lawea warakanzi mine, ŋana tu kinzi ma siwâŋgi pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Mao nâ, lâ zo ŋinde Maro Kindeni ma itula Saion lawea kilala pwataki mine tu, “Ŋine nde tamâta rârâni nenzi lawea tina mao.” Yova Kindeni âta Tamwata, i tamwata ma iveta Saion lawea ipâŋga kaika ndo, ku ma ikai maro panzi tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yova Kindeni ma iŋgere kinzi tamâta pa ŋgu ndoni ŋanzi lâ pepa tini, aku ma iseŋge ŋanzi ŋinde ilâ taitu kuku Saion lawea laluna ŋanzi. ");
INSERT INTO xsi_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Aku kinzi tamâta ŋinde ma siwâŋgi ku sindeka nâ. Kinzi ma siporo mine tu, “O Saion, maka nema lawea tina mao kala nokoni.” ");
INSERT INTO xsi_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Yova Kindeni, naneŋgu Maro Kindeni Pavilâŋa Tamwata noko. Ikura kari kari naŋa asarâwa pano tu kuvilana, aku naneŋgu tiŋa imâ pano ikura mbo mbo. ");
INSERT INTO xsi_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Kupaloŋo pa naneŋgu noŋa ŋga! Naŋa asarâwa pano tu kuvilana; kutambira taŋa pa naŋa! ");
INSERT INTO xsi_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Malia kie-kie rârâ ŋinde nde imâ ipâŋga pa naŋa lâ, kala laiti ŋana amâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Naŋa amo atogonzi tamâta ŋinde mateŋa ne zo ŋga imâ ipâŋga panzi lâ. Naneŋgu walo ndoni nde ikâwa ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Naŋa atogo zugu tamâta toŋge kinzi sipu pâta imâte lâ, kala sio i karae ilâ ikeno kuru ilo. Ŋinde itogo kinzi sitambira karaeŋgu ikeno mateŋa tamâta ŋgininzi. Naŋa amo atogonzi tamâta ŋinde noko kalo kapa ndo ŋananzi, kinzi ŋinde noko pwai ne pavilâŋa piti ndo ŋananzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Oyae, noko kutambira karaeŋgu andue alâ mbââ ŋalae ŋinde ilo, aku amo lâmbu ndo lâ nia kondoma. ");
INSERT INTO xsi_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Noko ne wisi-nâna itawa naŋa ndue lâ, itogo tâi ŋalae ne kâla-lawea ilaŋa ipolenzi tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Noko kusowe niŋgu-nambwe ilonzi kalonzi, kala sipu mulinzi pa naŋa marumbu lâ. Noko kuveta naŋa amo sakamao ndo; mine kala kinzi tininzi pwâka ndo tu ma simo kuna. Malia ŋine ipa naŋa kaika lâ. Ŋinde itogo noko kuo naŋa amo luma sakamao ilo, kala akura tu ayâti ku akâwa alâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Naŋa iloŋgu malia ndo, kala matâŋgu sakamao lâ. Mine nde naŋa akura tu amora nia sondo, ande tia. Ikura zo zo naŋa asuka mbauŋgu kâki akai noŋa pa noko tu ma kuvilana. Ambo noko ma kuvilana tia, ande naŋa ma amâte, kala ma akura tu apanea noko ŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Mana mana, a? Tiambo noko uru kuveta mâsi ŋalaŋala pinde ŋana kuvilanzi mateŋa tamâta, a? Tiambo kinzi sikura tu simo vianzi kilo ku sipanea noko ŋa sisuka kâki, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Tiambo kinzi tamâta sikeno kuru nia ŋinde nde sikura tu siporo situla pwataki tu noko ilo ndo keno panzi, a? Tiambo kinzi tamâta simo zavaruŋa ne lawea ŋinde nde sikura ŋana siporo tu noko uru pwatonanzi sondo, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Tiambo kinzi tamâta simo nia kondoma ŋinde nde sikura tu simora noko ne mâsi ŋalaŋala, a? Tiambo kinzi tamâta muŋga simâte ŋinde nde sikura tu simora noko ne vetâŋa ara pinde, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Mine nde Yova Kindeni, naŋa asarâwa pa noko tu kuvilana. Naŋa uru ano pano ikura mboyo mboyo. ");
INSERT INTO xsi_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Yova Kindeni, ŋana sâ kâ ŋga noko kupu muli pa naŋa, a? Ŋana sâ kâ ŋga noko kupavea ŋanana, a? ");
INSERT INTO xsi_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Oyae, nia ndoyo, lâ zo ŋinde naŋa amo limoa yo, aku amo lee apâŋga lâ zo ŋine, ande naŋa amo akai nâna nâ. Ikura zo zo naŋa amo mateŋa ne nzâla tini laiti. Noko kuveta kie ara tia pa naŋa, kala iloŋgu kurana tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Noko ne wisi-nâna itawa naŋa ndue ndo lâ. Noko pwai kazâŋa ŋalae tina pa naŋa, ku kuyaula naŋa ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Ikura kari wa mbo wa, noko ne wisi-nâna ŋinde iŋge naŋa mbwaliu lâ, itogo lââ ipondi ŋalae ku ilâ itura nia mine, aku naŋa ambwatuke lâ. ");
INSERT INTO xsi_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Noko kuvetanzi niŋgu-nambwe rârâni sipile naŋa silâ lâ. Mine kala kondoma simbo nâ ipâŋga itogo naneŋgu mete mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Yova Kindeni, noko ne tini-mwasa ikeno mine ku imo nâ, aku naŋa ma awâŋgi wâŋgiŋa atula ŋinde pwataki ikura zo zo. Naŋa ma amo nâ aporo atula pwataki tu noko uru kuveta ikura tamwata ne ŋgua pâŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Naŋa asama tu noko ne tini-mwasa ŋinde ma marumbu tia ndo. Noko ne mâsi ŋana pwoka ne ŋgua pâŋa rârâni muli ŋinde nde ikeno kaika ndo, itogo samba mine. ");
INSERT INTO xsi_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Muŋgani noko kuporo mine tu, “Naŋa apatea tamâta toŋge, aku apambwâre kaika kuku i lâ. Naŋa apa ŋgua kaika kuku naneŋgu wurâta tamâta Daviti. ");
INSERT INTO xsi_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Naŋa apai Daviti mine tu, ‘Ikura zo muli rârâni, ande noko ne vâsa pinde ma sikai noko nia ku ma simo koipu ŋalaŋala. Zo ŋana noko ne vâsa toŋge ma imo koipu ŋalae kâ ma marumbu, ande tia ndo.’” ");
INSERT INTO xsi_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yova Kindeni, kinzi ŋinde rârâni simo samba ilo nde siwâŋgi sipaneano ŋana vetâŋa arara noko uru kuveta ŋinde. Mao nâ, kinzi ŋgu sapâŋa ŋinde siwâŋgi situla pwataki tu noko uru kuveta ikura noko tamwata kawa ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Yova Kindeni, ea imo samba ilo nde irerege kuku noko, a? Tia ndo. Mao nâ, maro toŋge ipakura kuku noko, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Kinzi maro ŋinde rârâni nde siruru ŋana noko kâ. Kinzi sipare tukunzi ndue lâ noko nao, aku simege ndo ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yova Kindeni, noko Maro Kindeni Walo Tamwata, toŋge ne walo irerege kuku noko ne walo kaika ŋinde, ande tia. Noko kuveta ikura ne ŋgua pâŋa rârâni mine ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Noko uru pwai poe pa tâi ndoni. Lâ zo ŋana tâi ne kâla ŋalae kâki, ande noko kutawa i ne walo ŋinde ndue kala pâti kii lâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Aku noko kuzavaru Rahap ne walo kaika ŋinde marumbu lâ, ina mwâta saka ŋinde uru imo tâi ilo, aku kuyaula i ndo lâ. Noko ne walo nde kaika ŋinde; mine kala kupolenzi ne kazâŋa tamâta sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Samba tava tâno nde noko simbo nâ ne. Nia ndoyo noko kupulia tâno tava kelekele rârâni ikeno tâno kulu sipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Noko kuveta tâno papa mbwera kâ tava tâno papa wâra kâ. Aku Tabor Tuu aŋga Hermon Tuu nde sindekanano siwâŋgi pano. ");
INSERT INTO xsi_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Noko ne walo nde ŋalae tina, ikeno kaika mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Noko kumo koipu ŋalae, aku uru pwai poe sondo ndo panzi tamâta. Aku noko ne pateâŋa rârâni lâ ŋgua nia nde sondo nâ. Noko nde tini-mwasa warika, aku noko uru kuveta ikura noko tamwata ne ŋgua pâŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Tamâta ea kinzi uru siwâŋgi wâŋgiŋa paneâŋa kâ pa noko, kinzi ŋinde ma sindeka nâ. Noko tamwata uru pwai poe panzi, itogo sinâla ŋana isinala nzalanzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Kinzi kalonzi ŋgere ŋana vetâŋa arara noko uru kuveta ŋinde, kala sindeka sipanea noko ŋa sisuka kâki ikura kari wa mbo wa. ");
INSERT INTO xsi_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Nokoni uru walo kaika ara ŋinde kulua maka. Noko kuo ne wisi-wisi imâ pama, kala kapole paraŋa. ");
INSERT INTO xsi_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Yova Kindeni, muŋgani noko tamwata kupatea nema katonâŋa tamâta. Maka Isrel ŋgu nema Maro Kindeni, noko Sapâŋa Tamwata, noko tamwata kupatea koipu ŋalae pa maka. ");
INSERT INTO xsi_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yova Kindeni, nanayoni noko kutula mâsi toŋge itogo mbupuleŋa mine panzi ne ŋgua-tulâŋa tamâta, kinzi ŋinde sipono muli sondo pano. Noko kupainzi tu, “Naŋa ao naneŋgu pavilâŋa ilâ pa tamâta kaika toŋge lâ. Naŋa apatea i lâ tamâta ŋgininzi ku ao ipâŋga imo koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Naŋa apatea naneŋgu wurâta tamâta Daviti, aku aliŋi samimi sapâŋa lâ i kulu ŋana atula pwataki tu i imo miki nemi koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Mine kala naneŋgu walo ŋinde ma imo kuku i mine ku imo nâ. Naneŋgu walo ŋinde ma iveta i ipâŋga tamâta kaika ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","I ne kazâŋa tamâta kinzi ma sikura tu sipole i, ande tia. Kinzi tamâta sakamao ma sikura tu sipu i ndue, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Naŋa warakâŋgu ma azavarunzi i ne kazâŋa tamâta ndo lâ i nao. Tamâta ea ilonzi sakamao pa i, ande naŋa ma apunzi tamâta ŋinde pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Naŋa ma aveta ikura naneŋgu ŋgua pâŋa rârâni, aku ma tiniŋgu mwasa ndo papa i ikura zo rârâni. Naŋa warakâŋgu ma avila i ŋana ipolenzi ne kazâŋa tamâta ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Mine kala i ma ikai koipu pa tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Aku Daviti ma iporo pa naŋa mine tu, ‘Mama, naneŋgu Maro Kindeni noko. Noko kumo kutogo mira ŋalae naŋa uru amuna tini mwasina. Naneŋgu Pavilâŋa Tamwata kala noko.’ ");
INSERT INTO xsi_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Mao nâ, naŋa Yova Kindeni ma ŋoa ŋalae alua i, itogo tamâta iveta pa natu tamâne nzâla-kulu mine. Mine kala i ma imo mbâna-mbâna panzi koipu ŋalaŋala rârâni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Naneŋgu tini-mwasa ma ikeno ndo papa i ikura zo rârâni. Naneŋgu ŋgua pâŋa ma imo kuku i, aku ŋgua pâŋa ŋinde ma keno kaika mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Ikura zo rârâni, tamâta toŋge lâ i ne vâsa ŋgu ma imo koipu ŋalae. Samba uru ikeno âta ku imo nâ, aku mine nâ, koipu ŋalae toŋge lâ i ne vâsa ŋgu ma ikatonanzi Isrel ŋgu ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Taitu miki kaloŋo ŋga; ambo i timbu wukale kinzi ma taŋanzi kaika ŋana naneŋgu ŋgua tukuŋa kâ, ku ma sipu mulinzi pa naneŋgu vetâŋa, ");
INSERT INTO xsi_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ambo kinzi ma tininzi pwâka tu siloŋo naneŋgu ŋgua, ku silaŋa sipole naneŋgu ŋgua tukuŋa, ");
INSERT INTO xsi_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ande naŋa ma apare nia panzi ŋana nenzi kiesaka ŋinde kâ. Naŋa ma kaloŋgu ŋgere ŋana nenzi vetâŋa soki ŋinde kâ, aku ma mbilâo nâ apalilinzi. ");
INSERT INTO xsi_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Andeta naŋa ma apile neŋgu mâsi ŋana tiniŋgu mwasa ndo pa Daviti kâ, ande ma tia. Aku naŋa ma kaloŋgu kapa ŋana ŋgua pâŋa ŋinde naŋa muŋga aveta kuku i, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Naŋa ma atoto naneŋgu ŋgua pâŋa ŋinde utu, ande tia. Aku naŋa ma alele naneŋgu ŋgua ipâŋga kie toŋge kilo, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Mine nde naŋani ao warakâŋgu ŋâŋgu Yova Kindeni Sapâŋa Tamwata ikeno kaika lâ ŋgua pâŋa ŋine tini: naŋa ma aporo ŋgua laŋeŋa toŋge pa Daviti tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Ikura zo rârâni, tamâta toŋge lâ i ne vâsa ŋgu ma imo koipu ŋalae. I ma ikai koipu mine ku imo lee ikura zo rârâni kari ma isinala nia imo ŋai yo. ");
INSERT INTO xsi_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","I ma ikai koipu mine ku imo nâ, itogo nzimona uru imo samba tini ku isinala nia ikura zo zo. Naŋa Yova Kindeni neŋgu ŋgua pâŋa kala ŋine.” ");
INSERT INTO xsi_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Andeta Yova Kindeni, kala ŋine noko wisi nâna pa koipu ŋalae, inani noko kupatea lâ. Noko kupu muli papa, kala kupile i lâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Noko kutoto ŋgua pâŋa ŋinde muŋga kuveta kuku ne wurâta tamâta. Noko kutambira koipu ŋalae ne loki-loki imbe indue tâno kulu, kala kuveta ipâŋga muso ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Noko kuzavaru i ne lawea ŋinde ne ŋgumbi kaika rârâni kala bururu ndue lâ. Aku i ne luma kaika ŋalaŋala rârâni nde noko kuzavaru ndo lâ mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Mine kala tamâta ŋinde soka nzâla silâ, ande kinzi ŋinde rârâni sipanawe koipu ŋalae ne kelekele. Aku kinzi ŋgu kala simo i ne lawea tini laiti ŋinde, ande kinzi siporo ŋgua pavaligiŋa papa i. ");
INSERT INTO xsi_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Noko kusâu panzi kazâŋa tamâta tu sipole i lâ paraŋa ilo, aku kuveta ilonzi ndeka ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Noko kuzavaru i ne temba-silâwa rârâni, aku lâ zo ŋana ipara kunzi kazâŋa tamâta, ande noko ŋandai kuvila i ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Noko kutawa i ndue ndo; mine kala ikura ŋana imo koipu ŋalae kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Noko pwai i ne walo saŋe, kala ipâŋga koŋa ndo walele nâ. Noko kuveta i ipâŋga tamâta kaa nâ, kala ikai maŋeti ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Ayo, Yova Kindeni, noko ma kupavea tamwata mine ikura zo ŋapia kilo, a? Tiambo noko ma kupavea ikura zo rârâni, a? Noko ne wisi-nâna ipâŋga ŋalae ndo, itogo yââ ne mela-mela mine. Noko ma wisi nâna mine ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yova Kindeni, naŋa ano pano tu kalo ŋgere ŋanana. Maka tamâta uru kamo viama ikura zo mbwana-mbwana nâ. Noko muŋga kupuliama kapâŋga, andeta noko ne pateâŋa ikeno tu maka rârâni ma kamâte. ");
INSERT INTO xsi_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Ea ikura tu itiŋgi mateŋa piti lâ ku imo via nâ, a? Ea imo tava ne walo kaika, kala ikura tu iŋgeŋgeana ŋana mateŋa nianzi kâ, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Maro Ŋalae, noko uru kuveta ikura ne ŋgua pâŋa rârâni, aku nanayoni noko kupambwâre kuku Daviti tu noko ne tini-mwasa ma ikeno kuku i ku imo nâ. Aŋga mana mana, a? Ŋgua ŋinde kanaŋo nde keno ndia, a? ");
INSERT INTO xsi_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Maro Ŋalae, kalo ŋgere ŋana noko ne wurâta tamâta ŋinde kâ. Kinzi tamâta siporo ŋgua pavaligiŋa papa i, aku naŋa iloŋgu malia ndo ŋana kinzi tinikoa nenzi ŋgua sakamao ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yova Kindeni, noko muŋgani kupatea koipu ŋalae ŋinde, andeta noko ne kazâŋa tamâta uru siveta “a” papa i. Kinzi soka i muli ku sivaligi i mine nâ ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Andeta kinda ma tapanea Yova Kindeni ŋa tasuka kâki ikura zo rârâni. Mao ku mao nâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Maro Ŋalae, ikura zo rârâni noko kumo kutogo maka nema luma kaika mine. ");
INSERT INTO xsi_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Nia ndoyo, aku ilâ lee ipâŋga lâ zo muli ndo, ande noko Maro Kindeni kumo ikura zo rârâni ku kumo nâ. Nanayoni, lâ zo ŋinde kinzi tuu sipâŋga tia yo yo, aku noko ŋandai kupulia tâno ne kelekele rârâni sipâŋga ŋga, ande noko kumo muŋgani lâ ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Andeta noko ne pateâŋa ikeno tu tamâta rârâni ma simâte ku sipâŋga sitogo tâno kilo. Noko kupainzi tamâta rârâni mine tu, “Miki tâno tamâta, miki ma kamâte ku ma kapalele kapâŋga tâno kilo.” ");
INSERT INTO xsi_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Maro Kindeni, noko ne morâŋa nde mine; mbwera tamâta-tamâta (1000) nde itogo kari taitu mai nâ, aku zo ŋinde ilâ walele nâ, itogo nola nâ mine. Mao nâ, ŋinde nde zo mbwana-mbwana nâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Noko uru kutoto tamâta nenzi via kala simâte. Kinzi simo zo mbwana-mbwana nâ, itogo mbupuleŋa mwasina. Kinzi sitogo unza ipâŋga wasaseki lâ mboyo nâ, ");
INSERT INTO xsi_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","aku ipâŋga ŋalae ku ne mâle ipâŋga. Andeta lala nâ, ŋineŋga unza ŋinde ŋgâla-ŋgâla lâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Maro Kindeni, noko wisi nâna pa maka, aku ŋana duvi ŋinde kâ noko kuzavaruma kala naoma tia lâ. Noko ne wisi-nâna ŋalae ŋinde iveta maka karuru ndo. ");
INSERT INTO xsi_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Noko kusama nema vetâŋa potomule rârâni. Aku kiesaka ndia maka kapavea ku kaveta, ande ŋinde noko uru kutula pwataki ipâŋga nia yo lâ noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Noko ne wisi-nâna uru ikeno pa maka ikura zo kiri-mwata ŋine maka kamo viama lâ tâno kulu. Mao nâ, maka nema zo nde marumbu walele nâ, itogo tamâta iveta kusu mbwani taitu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Maka kamo viama ikura mbwera tamâta ŋato kanaŋo saŋao nâ. Ambo nema kaika ikeno yo, ande maka pinde ma kamo viama ikura mbwera tamâta ŋapa. Andeta maka uru kakai nâna wa kasânda malia rârâ kulu ikura nema mbwera rârâni. Maka nema via ŋine nde marumbu walele nâ, ŋineŋga naoma tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Maro Kindeni, noko ŋandai kupaliŋi ne wisi-nâna ndoni imâ pa maka ŋga. Ambo noko ma kuveta mine, ande tamâta toŋge ma ikura tu imo via, ande tia. Mao nâ, lâ zo ŋana maka kaloma ŋgere ŋana noko ne wisi-nâna kâ, ande ara ŋana maka ma karuru pâta ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Mine nde maka kano pano tu kupananama, ŋana maka ma kasama sondo mine tu maka kakura tu kamo zo mbwana-mbwana nâ lâ tâno kulu. Ambo noko ma kupananama mine, ande maka ma kakai noko ne ilo-kalo ara ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yova Kindeni, noko ne wisi-nâna ma imâ mine pa maka ikura zo ŋapia kilo, a? Maka kano pano tu kupile ne wisi-nâna ŋinde, aku kalo sukâŋa ŋana ne wurâta tamâta maka. ");
INSERT INTO xsi_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Noko ne tini-mwasa ikeno mine ku imo nâ. Maka iloma tu noko ma kuo ne tini-mwasa ŋinde imâ ŋalae pa maka ikura mboyo mboyo. Ambo noko ma kuveta mine, ande maka ma kandeka wa kawâŋgi wa, ikura zo rârâni maka ma kamo viama. ");
INSERT INTO xsi_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Muŋgani, ande noko malia kulua maka, kala kamo sakamao ikura mbwera rârâ lee imâ ipâŋga lâ zo ŋine. Taitu kala ŋine maka kano pano tu kuveta maka kandeka nâ ikura mbwera rârâ, kambwaŋenzi irerege kuku mbwera sakamao ŋinde kambwaŋenzi. ");
INSERT INTO xsi_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Maka kano pano tu kutula ne mâsi kaika pa ne wurâta tamâta maka. Aku kano pano tu kutula ne walo kaika ara ŋinde panzi maka nema vâsa muli-muli tona mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Maro Ŋalae, maka nema Maro Kindeni noko, maka iloma tu noko ma kuo ne wisi-wisi imâ pama, ku kuveta kie ara pama. Maka iloma tu noko ma kuveta nema vetâŋa wa wurâta rârâni ipâŋga ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Tamâta ea kinzi Yova Kindeni âta Tamwata uru ikea ŋananzi, ande kinzi ŋinde uru simo Maro Kindeni Walo Tamwata tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Kinzi tamâta ŋinde rârâni ma siporo pa Yova Kindeni mine tu, “Noko kumo kutogo naneŋgu ŋgumbi kaika mwasina, aku noko uru pwatonana sondo nâ. Naneŋgu Maro Kindeni noko; naŋa kaloŋgu tawana noko nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Mao kanaŋo, Maro Kindeni ma ikea sondo ŋanano; mine kala nimbu paveâŋa toŋge ma ikura tu izavaru noko, ande tia. Aku mine nâ, pukoŋa sakamao toŋge ma ikura tu ikaino, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","I ma ikea sondo nâ ŋanano, itogo tatareko tina igogoranzi natu simo mbani kalo mine. Noko ma kupavea sondo nâ lâ Maro Kindeni mbani kalo, kala ma kumo ara nâ. I uru iveta ikura ne ŋgua pâŋa rârâni. Mine kala i ma imo itogo noko ne maramuŋa mwasina, ku ma ikea ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Lâ mbo, ande noko ma kururu ŋana vetâŋa sakamao toŋge tia. Aku lâ kari, ande noko ma kururu ŋana vetâŋa toŋge tu ipâŋga walele nâ ku iyaulano, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Aku noko ma kururu ŋana pukoŋa ŋalaŋala uru ipâŋga lâ mbo wa vetâŋa sakamao uru ipâŋga lâ kari ŋana siyaulanzi tamâta kâ, ande ma tia, ŋana tu Yova Kindeni ma ikea ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Mao nâ, ambo tamâta kambwaŋenzi ŋalae ŋinde ma sipamateteu noko waŋgira lâ paraŋa ilo, ande Yova Kindeni ma ikea ŋanano, kala ma kumo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Aku noko tamwata ma kumora Yova Kindeni ipare nia panzi tamâta sakamao ŋana vetâŋa kiesaka muŋga siveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ŋinde nde duvi mine; noko uru kulâ pa Yova Kindeni ku kupavea ŋana kazâŋa kie-kie kâ, aku Yova Kindeni âta Tamwata ikatonano. ");
INSERT INTO xsi_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Mine nde sâ toŋge ma ikura tu izavaru noko, ande tia. Aku zavaruŋa ne mâsi toŋge ma ikura tu imo noko ne luma tini laiti, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ŋana tu Yova Kindeni ma ionzi ne aŋelo tu ma sikatonano ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Kinzi ma mbaunzi nâ sisuka noko kâki, kala mira toŋge ma ikura tu isowe noko kie, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Noko ma kie nâ kupalenzi mbwâmbwa saka “leve” wa mwâta saka kie-kie wa. ");
INSERT INTO xsi_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Mao nâ, Yova Kindeni iporo mine tu, “Tamâta ea ilonzi ndo keno pa naŋa, ande naŋa ma akainzi ŋinde rârâni piti lâ kazâŋa ilo. Naŋa ma akea sondo ŋananzi tamâta ea sisama naŋa kilalâŋgu sondo. ");
INSERT INTO xsi_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Lâ zo ndia kinzi sisarâwa pana, ande naŋa ma apaloŋo pa nenzi noŋa. Aŋga zo ndia malia itu ipâŋga panzi, ande naŋa ma amo kunzi. Naŋa ma akainzi piti lâ kazâŋa ilo, aku ma aveta ŋanzi ipâŋga ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Naŋa ma aseŋge nenzi mbwera luandondo, kala kinzi ma ilonzi ara nâ. Naŋa ma atula pwataki panzi tu naŋa nde nenzi Pavilâŋa Tamâta.” ");
INSERT INTO xsi_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Yova Kindeni, noko âta Tamwata, naŋa andeka ŋana aporo ndaŋge pa noko wa awâŋgi wâŋgiŋa paneâŋa kâ asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Ikura mboyo mboyo, naŋa andeka ŋana aporo atula pwataki tu noko ne tini-mwasa ikeno mine ku imo nâ. Aku ikura mbo mbo, naŋa andeka ŋana aporo atula pwataki tu noko uru kuveta ikura ne ŋgua pâŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Mao nâ, naŋa ma ara wâŋgu awâŋgi wâŋgiŋa kaŋa ara nâ apanea noko ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Yova Kindeni, naŋa kaloŋgu ŋgere ŋana noko ne mâsi kaika kâ, aku iloŋgu ara ndo. Noko ne vetâŋa arara ŋinde igagati iloŋgu kaloŋgu ŋana awâŋgi wâŋgiŋa tava ndekâŋa ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yova Kindeni, noko uru kuveta mâsi ŋalaŋala kaika ndo. Noko ne ilo-kalo nde ŋalae tina, kala ipole maka tamâta nema ilo-kalo. ");
INSERT INTO xsi_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Tamâta pinde sizizâla ndo ŋana Yova Kindeni kilala kâ, kala sipâŋga sitogonzi tamâta nenzi ilo-kalo tia mine. Kinzi ŋinde sizizâla ŋana ŋine kâ: ");
INSERT INTO xsi_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Mao nâ, lâ zo ŋine kinzi tamâta sakamao sipâŋga walele sitogo unza mine, aku kinzi kiesaka tamwatanzi uru sigona mbaliŋa rârâ kie-kie kala simo ara ndo. Andeta muli ŋga, Yova Kindeni ma izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Aŋga Yova Kindeni, noko tamwata nâ pwai koipu ŋalae pa kelekele ndoni, ma kumo mine ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Maka kasama tu noko ne kazâŋa tamâta rârâni ma simâte, aku noko ma kupolenzi kiesaka tamwatanzi rârâni ku kutawanzi ndue ndo. ");
INSERT INTO xsi_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Muŋga noko walo kaika kulua naŋa, kala naneŋgu walo ipâŋga ŋalae lâ, itogo bulmakao ŋgoi ŋalae ne walo mine. Noko kuveta kie ara pa naŋa, kala amo andeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Naŋa warakâŋgu matâŋgu amora Maro Kindeni izavarunzi naneŋgu kazâŋa tamâta. Naŋa aloŋo kinzi tamâta sakamao nenzi tiŋa, kala andeka pâta. ");
INSERT INTO xsi_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Aŋga kinzi tamâta ara ma simo ara ndo, sitogo kâi ipâŋga ŋalae kala ipula kanaŋo ara mine. Kinzi ma sipâŋga kaika ndo, sitogo kâi matapuru imandi Lebanon tâno mine. ");
INSERT INTO xsi_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Kinzi sitogo kâi tamâta pinde muŋga sipau lâ Yova Kindeni ne luma tini laiti. Kâi ŋinde uru sipâŋga ara ndo lâ nenda Maro Kindeni ne luma sapâŋa ŋinde ne ŋgumbi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Kâi ŋinde ma simandi ikura mbwera rârâ ŋinde, aku ma simo sipula kanaŋonzi. Kinzi ma simandi kaika, ku ma ŋgâla-ŋgâla tia. Kâi ŋinde launzi ma kenza-kenza mine ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Mao nâ, Yova Kindeni ma ivilanzi tamâta ara kala ma simo mine, aku i ne pavilâŋa ŋinde ma itula pwataki panzi tamâta tu Yova Kindeni nde vetâŋa sondo warika. I uru ikea ŋana naŋa kâ, aku i ne vetâŋa rârâni nde ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yova Kindeni imo Koipu Ŋalae. I ŋa ŋalae tava ne walo kaika ŋinde nde situra i, itogo koipu ŋalaŋala nenzi pasawaŋa arara mwasina. Nia ndoyo, inani ipulia tâno ŋine ku iveta ikeno kaika lâ, aku sâ toŋge ikura tu ilele Yova Kindeni ne vetâŋa ŋinde, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Yova Kindeni, nia ndoyo, lâ zo ŋinde kelekele toŋge ipâŋga tia yo yo, ande noko kumo muŋgani lâ. Nanayoni noko kumo koipu ŋalae, aku ma kumo mine ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yova Kindeni, tâi geza-geza ipu nduŋeŋani ŋalae. Tâi ipu kaika ndo ku isuŋa kawa kâki ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Yova Kindeni, noko ne walo nde kaika ŋinde, aku kumo samba ilo pwai koipu ŋalae pa nia ndoni. Tâi ne nduŋeŋani ŋinde nde kelekele mota mwata nâ, aŋga noko ne kaika ŋinde nde ŋalae tina. Tâi ipu nduŋeŋani lâ sâwaneka, andeta tâi ne kaika irerege kuku noko ne kaika ŋinde, ande tia, ŋana tu kelekele rârâni imo noko kalo. ");
INSERT INTO xsi_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Mao nâ, sâ toŋge ma ikura tu ilele noko ne ŋgua tukuŋa ipâŋga kie toŋge, ande tia. Aku mine nâ, noko ne luma nde sapâŋa ndo, ma ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yova Kindeni, noko nde Maro Kindeni Pareŋa-nia Tamwata. Kala ŋine naŋa ano pano tu kutula ne wisi-nâna pwataki pa kinzi tamâta sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Noko uru kupare nia panzi tamâta rârâni ŋana nenzi vetâŋa kâ. Kala ŋine naŋa ano pano tu kumandi ku kupare nia panzi tamâta ŋinde uru sipasuka warakanzi tininzi. Kutu ŋananzi ikura nenzi vetâŋa potomule mine. ");
INSERT INTO xsi_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Yova Kindeni, kinzi tamâta sakamao ma sindeka mine ŋana nenzi vetâŋa potomule kâ ikura zo ŋapia kilo, a? Kinzi nenzi zo ŋapia keno mo ŋai. ");
INSERT INTO xsi_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Kinzi kiesaka tamwatanzi ma sipandekâna ku ma sipasuka warakanzi tininzi ikura zo ŋapia kilo, a? ");
INSERT INTO xsi_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yova Kindeni, kinzi tamâta sakamao uru sitawanzi noko ne tamâta ndue ndo. Mao nâ, kinzi siveta kenzi sakamao ndo pa noko tamwata ne ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Kinzi uru sipunzi taine mwala-mwala sitavanzi lâlu mundoro simâte, aku sipunzi tamâta simo lombo lâ maka nema tâno ŋine simâte tona. ");
INSERT INTO xsi_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Kinzi siporo mine tu, “Yova Kindeni ikura tu imora maka, ande tia. Isrel nenzi Maro Kindeni nde izizâla ndo ŋana nema vetâŋa kâ.” ");
INSERT INTO xsi_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Ayo, miki tamâta kapa-kapa ŋai, ŋana sâ kâ ŋga miki kaveta vetâŋa potomule mine, a? Miki tamâta sakamao, miki nemi ilo-kalo ma ipâŋga lâ zo ndia, a? ");
INSERT INTO xsi_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Mana mana, a? Tiambo Yova Kindeni ikura tu iloŋo nemi ŋgua tia tâ, a? Opopo, i tamwata iveta taŋânda, kala iloŋomi lâ. Tiambo ikura tu imora nemi vetâŋa ŋinde tia tâ, a? Opopo, i tamwata iveta matânda, kala imorami lâ! ");
INSERT INTO xsi_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Tiambo i ikura tu ipare nia pa miki tamâta sakamao tia tâ, a? Opopo, i tamwata uru imbitanzi tinikoa ŋgu, kala ma ipare nia pami! Tiambo i ne ilo-kalo tia tâ, a? Opopo, i tamwata imo tamâta rârâni nenzi pananâŋa, kala i ne ilo-kalo nde ŋalae ndo! ");
INSERT INTO xsi_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Miki kaloŋo ŋga; Yova Kindeni isama tamâta rârâni nenzi ilo-kalo marumbu lâ, aku isama tu nenzi ilo-kalo ŋinde ma ilâ kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Andeta Yova Kindeni, noko ne nzâmbe ara ikeno panzi tamâta ea noko uru kupanananzi ŋana ne tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Noko uru pwareâŋa ara kulanzi tamâta sondo mine; mine nde malia kie-kie ikura ŋana isânda kulunzi kâ, ande tia. Kinzi ma sipwarea mine lee, ikura zo muli ŋinde noko ma kupare nia panzi tamâta sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Ŋana tu Yova Kindeni ma ipilenzi ne tamâta, ande tia. Mao nâ, i ma ipu muli panzi i tamwata ne ŋgu ŋinde, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Aku muli ŋga, kinzi tamâta uru sikai poe pa ŋgua nia ŋinde ma siveta nenzi wurâta sondo kilo. Ŋineŋga kinzi tamâta sondo ma ilonzi ara ŋana ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Muŋga, lâ zo ŋinde kinzi tamâta sakamao sikai kazâŋa pa naŋa, ande tamâta toŋge ivila naŋa, ande tia. Tamâta toŋge imandi kuku naŋa ŋana ipara kunzi kiesaka tamwatanzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Lâ zo ŋinde, ambo Yova Kindeni ivila naŋa tia, ande nanayoni naŋa ma akeno lâ mateŋa nianzi. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Lâ zo ŋinde, naŋa iloŋgu patea tu, “Naŋa keŋgu apale nia zuli-zuli, kala ma patana ndue.” Andeta tia. Yova Kindeni, noko ne tini-mwasa ikeno pa naŋa ku imo nâ, aku noko kusaŋa naŋa kaika lâ. ");
INSERT INTO xsi_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Lâ zo ndia naŋa kaloŋgu loko wa iloŋgu rârâ wa, ande noko uru kupu tini kaika pa iloŋgu kaloŋgu ku kuveta naŋa andeka. ");
INSERT INTO xsi_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Noko kumo piti ndo ŋananzi koipu sakamao, kinzi tamâta ŋinde uru silaŋa sipole ŋgua tukuŋa ku siveta kenzi sakamao panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Kinzi uru silâ taitu ku siroto nzâla ŋana siyaulanzi tamâta arara kâ. Aku kinzi sionzi tamâta pinde silâ pa ŋgua nia, ŋineŋga sipa ŋgua tu ma sipunzi pâta simâte, andeta tamâta ŋinde ŋandai siveta vetâŋa soki ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Andeta Yova Kindeni ikea ŋanana. Naneŋgu Maro Kindeni imo itogo mira kaika naŋa uru amuna tini mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","I ma ipare nia panzi tamâta sakamao ŋinde ŋana nenzi vetâŋa sakamao kie-kie kâ. Kinda nenda Maro Yova Kindeni ma kalo ŋgere ŋana nenzi kiesaka ŋinde kâ, ku ma izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Miki kamâ ŋga, ma tawâŋgi tapanea Yova Kindeni ŋa tasuka kâki! Kinda ma kalonda ŋgere ŋana Yova Kindeni Kaika Tamwata, ina nenda Yautâŋa Tamwata, aku ma tawâŋgi wâŋgiŋa papa ku tandeka ŋana i kâ. ");
INSERT INTO xsi_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Kinda ma talâ tamandi i nao, aku kawânda ndaŋge papa. Kinda ma tawâŋgi wâŋgiŋa ndekâŋa kâ ku tapanea i ŋa tasuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Ŋana tu Maro Yova Kindeni i ne walo nde ŋalae ndo. Ina imo koipu ŋalae tava ne walo kaika ŋinde, aku imo kinzi maro rârâni kulunzi. ");
INSERT INTO xsi_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ina uru ikai poe pa tâno ndoni. Ikai poe pa nia rârâni ikeno tâno ilo lâmbu ŋinde, aku inani kala ikai poe pa tuu ŋalaŋala ikâki pa âta ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Nia ndoyo ina tamwata ipulia tâno wa tâi wa sipâŋga lâ. Mine kala inani uru ikai poe pa tâno ndoni wa tâi ndoni wa. ");
INSERT INTO xsi_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Mine nde miki kamâ luma ilo, ma naonda tundu tapanea Yova Kindeni. Nia ndoyo i tamwata ipulia kinda tapâŋga lâ. Mine nde ara ŋana kinda ma talâ tamo i nao, aku tapare tukunda papa. ");
INSERT INTO xsi_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Ina tamwata nde kinda nenda Maro Kindeni. Ina tamwata kala uru ikatona i ne tamâta kinda rârâni, itogo lama nenzi katonâŋa tamâta ikatonanzi lama mine. Mine nde kala ŋine miki ma kapaveta kuku i kawa ŋgua! ");
INSERT INTO xsi_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Yova Kindeni iporo tu, “Miki ma kapasakana ilomi kalomi kaika, itogo timbumi muŋga siveta lâ Meriba tâno wa Masa nia bilimu wa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Lâ zo ŋinde kinzi simo nia bilimu ŋinde, ande kinzi simo sipulo naŋa ŋana aveta mâsi pinde panzi. Andeta muŋgani yo kinzi simora naneŋgu mâsi ŋalaŋala pinde pwataki lâ. ");
INSERT INTO xsi_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ikura mbwera tamâta rua lâ, ande naŋa tiniŋgu pwâka ndo ŋananzi tamâta ŋgu ŋinde. Mine nde naŋa aporo tu, ‘Kinzi ilonzi kalonzi ŋandai ikeno sondo pa naŋa ŋga. Ikura zo rârâni kinzi sipu mulinzi pa naneŋgu ŋgua tukuŋa.’ ");
INSERT INTO xsi_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Mine nde naŋa wisiŋgu nâna aporo mine tu, ‘Mao kanaŋo, kinzi tamâta ŋine ma sikura tu silâ pa naneŋgu pwareâŋa nia tia ku tia ndo!’” ");
INSERT INTO xsi_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Miki tamâta ŋai, miki kawâŋgi wâŋgiŋa wasaseki pa Yova Kindeni! Miki tamâta rârâni kamo tâno kulu, ara ŋana miki ma kawâŋgi papa Yova Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Kawâŋgi pa Yova Kindeni kapanea i ŋa kasuka kâki! Ikura zo zo, ande ara ŋana miki ma kaporo katula pwataki mine tu ina imo kinda nenda Yautâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Miki ma kaporo katula panzi tamâta ŋgu rârâni tu i ŋa nde ŋalae ndo. Katapâri panzi tamâta simo nia ndoni ŋana vetâŋa ŋalaŋala arara i muŋga iveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Ŋana tu Yova Kindeni ŋa nde ŋalae ndo. Mine nde ara ŋana kinda ma tapanea i ŋa tasuka kâki ndo. Kinda ma tamege ŋananzi maro pinde ndimo. Kinda ma tamege ŋana Maro Kindeni simbo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ŋana tu kinzi tinikoa ŋgu nenzi maro rârâni nde kelekele laŋeŋa nâ, kala sikura tu siveta mâsi ŋalae toŋge tia. Taitu nia ndoyo Yova Kindeni ipulia samba tava kelekele rârâni simo âta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Yova Kindeni kilala ipâŋga nia yo tu i ŋa nde ŋalae, aku imo Koipu Ŋalae ara ndo. Kelekele rârâni keno i ne luma ilo ŋinde nde situla i kilala pwataki tu i ne walo nde kaika, aku i nde ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Miki tamâta ŋgu rârâni kamo tâno ndoni, miki kapanea Yova Kindeni ŋa. Kaporo katula pwataki tu i nde ara tamwata, aku i ne walo nde kaika ndo. ");
INSERT INTO xsi_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Kapanea Yova Kindeni katula pwataki tu i ŋa nde ŋalae ndo. Kakai patarawâŋa toŋge ku kamâ i ne luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Miki ma kawâŋgi kawawa i, ŋana tu i nde sapâŋa ku zuzuli tamwata. Miki tamâta rârâni kamo tâno kulu, miki kapatawa warakami tinimi lâ i nao. ");
INSERT INTO xsi_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Miki ma kaporo katula ŋgua panzi tamâta ŋgu rârâni mine tu, “Yova Kindeni imo Koipu Ŋalae!” Nia ndoyo ina iveta tâno ikeno kaika lâ, kala sâ toŋge ikura tu iveta tâno ilâ wa imâ wa, ande tia. Aku muli ŋga, lâ zo ŋinde i ma ionzi tamâta rârâni simandi ŋgua nia, ande i ma iveta panzi ikura nenzi vetâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ayo, miki samba wa tâno wa, naŋa apaimi tu miki kandeka ŋga! Aŋga tâi tava kelekele rârâni kamo tâi ilo, miki kala kaveta nduŋeŋa kasuka kawami kâki! ");
INSERT INTO xsi_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","13","Aŋga tâno tava kelekele rârâni ikeno tâno ilo, miki kala kandeka pâta ŋga! Muli ŋga, lâ zo ŋinde Yova Kindeni ma imâ ŋana ikai poe panzi tamâta rârâni, ande kelekele rârâni ikeno tâno kulu ma sindeka pâta. Mao nâ, kâi rârâni simandi dugu ilo ŋinde ma siwâŋgi wâŋgiŋa ndekâŋa kâ. Ŋana tu ina ma ikai poe sondo ndo panzi tamâta rârâni tava vetâŋa mao nâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yova Kindeni imo Koipu Ŋalae! Mine kala miki tamâta rârâni kamo tâno kulu, ande miki kandeka. Aŋga miki tamâta kamo sia sia, ande miki kala ilomi ara mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Take-take mâmâŋga tava kondoma ŋalae nde uru situra i, aku i ne mâsi ŋana ikai koipu panzi tamâta nde ara ku sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Yova Kindeni isupwa yââ imuŋga papa, aku yââ ŋinde ne mela-mela ikananzi ne kazâŋa tamâta ŋinde muŋga siŋge i mbwaliu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","I ne loloa nde salaga-salaga ku isinala tâno ndoni. Tâno nde imora ŋinde, kala imo ririŋo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yova Kindeni ikai Maro Ŋalae pa tâno ndoni. Lâ zo ndia i imâ ipâŋga laiti, ande tuu siruru ku sipâŋga sitogo lââ mine. ");
INSERT INTO xsi_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Samba uru itula pwataki tu Yova Kindeni nde ara tamwata, aku tamâta ŋgu rârâni simora pwataki tu i ŋa nde ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Aŋga tamâta pinde uru siwâŋgi sipaneanzi maro laŋeŋa, aku sindekananzi nenzi maro kaa kaa ŋinde. Andeta kinzi tamâta ŋinde rârâni ma sikai maŋeti ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Kinzi tamâta simo Saion Tuu kulu ŋinde, sitavanzi tamâta simo Juda nenzi lawea ŋalaŋala, kinzi ŋinde siloŋo pâri tu noko kupare nia panzi ne kazâŋa tamâta lâ, kala ilonzi ara ku simo sindeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Yova Kindeni, Maro Walo Tamwata noko, noko pwai poe pa tâno ndoni. Noko ŋa nde ŋalae ndo, aku noko ŋa ŋinde ipole kinzi maro rârâni ŋanzi marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yova Kindeni uru tini mwasa ndo panzi tamâta ea sipu mulinzi pa vetâŋa sakamao. Ina uru ikatonanzi i tamwata ne tamâta, aku ikainzi piti lâ tamâta sakamao mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Yova Kindeni ne sinâla isinalanzi tamâta ea uru sipaveta kuku vetâŋa ara. I io ndekâŋa ilâ panzi tamâta sondo. ");
INSERT INTO xsi_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Mine nde miki tamâta ŋine uru kapaveta kuku vetâŋa ara, miki kandeka ŋana Yova Kindeni ne vetâŋa kâ! Kalomi ŋgere ŋana ŋinde kâ, ku kawami ndaŋge kapanea Yova Kindeni ŋa sapâŋa ŋinde kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Miki tamâta ŋai, miki kawâŋgi wâŋgiŋa wasaseki pa Yova Kindeni, ŋana tu ina iveta vetâŋa ŋalaŋala arara nâ. I ne walo kaika nde ŋalae; mine kala i tamwata ipole paraŋa lâ. ");
INSERT INTO xsi_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yova Kindeni itula pwataki tu inani ipole paraŋa lâ. Itula pwataki panzi tamâta ŋgu ndoni tu inani ikai kinda piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","I iyoka tamwata ne ŋgua pâŋa muŋgâŋa muli, kala ikura zo zo i uru tini mwasa ndo panzi Isrel ŋgu. I ŋandai ipilenzi ŋga. Mine kala tamâta rârâni simo tâno ndoni nde simora tu kinda nenda Maro Kindeni ipole paraŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Miki tamâta rârâni kamo tâno kulu, miki kandeka ku kawâŋgi wâŋgiŋa paneâŋa kâ kandekana Yova Kindeni! Kawâŋgi kawami kâki ku kandeka kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Kara wâŋgu ku kawâŋgi wâŋgiŋa paneâŋa kâ pa Yova Kindeni. Kawâŋgi wâŋgiŋa kaŋa ara nâ papa. ");
INSERT INTO xsi_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Kambana tando kie-kie ku kasarâwa kandekana Yova Kindeni, inani kinda nenda Koipu Ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Aŋga tâi tava kelekele rârâni kamo tâi ilo, miki kala kaveta nduŋeŋa kasuŋa kawami kâki. Aŋga tâno tavanzi tamâta rârâni kamo tâno kulu, miki kala kawâŋgi wâŋgiŋa mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Miki lââ ŋalaŋala kaponza mbaumi, aŋga miki tuu ŋalaŋala kala kagogo kawami kawâŋgi wâŋgiŋa ndekâŋa kâ lâ Yova Kindeni nao. ");
INSERT INTO xsi_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Ŋana tu muli ŋga, i ma imâ ŋana ikai poe panzi tamâta rârâni. I ma ikai poe sondo panzi tamâta rârâni tava vetâŋa sondo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yova Kindeni imo Koipu Ŋalae, kala kinzi tamâta tininzi ruru. I imo koipu ŋalae ne saŋonâŋa nia ŋinde ikeno kinzi aŋelo ŋgininzi, kala tâno ririŋo yâti taulo. ");
INSERT INTO xsi_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Mao nâ, Yova Kindeni imo Saion Tuu kulu tava ne walo kaika ŋalae ndo, aku tamâta ŋgu rârâni nde simo i kalo. ");
INSERT INTO xsi_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Kinzi tamâta rârâni ma wisinzi motutu kala ma sipanea i sisuka i ŋa ŋalae ŋinde kâki. Ina Yova Kindeni Sapâŋa Tamwata! ");
INSERT INTO xsi_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Koipu Ŋalae, noko Kaika Tamwata, noko uru tini mwasa ndo ŋana vetâŋa sondo nâ. Muŋgani noko kutu ŋgua tukuŋa sondo ndo pa maka Isrel tamâta ŋana kapono muli papa, aku noko uru pwai poe sondo ndo pama. ");
INSERT INTO xsi_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Ayo, miki tamâta ŋai, miki kapanea kinda nenda Maro Yova Kindeni ŋa kasuka kâki! Kalâ kapare tukumi ndue lâ i ne saŋonâŋa nia ŋinde nao, aku kawawa i. Ina Yova Kindeni Sapâŋa Tamwata! ");
INSERT INTO xsi_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Nanayoni Mose ku Aron rua simo Yova Kindeni ne patarawâŋa tamâta, aku Samyuel kala uru ino papa i tona. Kinzi sisarâwa pa Yova Kindeni, aku ipaloŋo pa nenzi noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Lâ zo muŋgâŋa ŋinde, Yova Kindeni imo take-take ŋalae ilo ku iporo ŋgua panzi. Aku kinzi sipono muli sondo pa ŋgua tukuŋa rârâni itula panzi. ");
INSERT INTO xsi_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yova Kindeni, maka nema Maro Ŋalae, lâ zo ŋinde noko kupaloŋo pa nenzi noŋa. Noko kupatula tamwata kilala pwataki panzi mine tu noko uru kuzavaru nenzi kiesaka piti lâ tininzi. Andeta mao nâ, noko muŋga kupare nia sondo panzi ŋana nenzi vetâŋa soki kâ. ");
INSERT INTO xsi_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Mine nde kinda ma tapanea nenda Maro Yova Kindeni ŋa, tatula pwataki tu i nde Walo Tamwata! Talâ pa i ne tuu sapâŋa, aku tawâŋgi papa i nâ! Ŋana tu kinda nenda Maro Yova Kindeni nde Sapâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Miki tamâta rârâni kamo tâno kulu, miki kasuka kawami kâki kawâŋgi wâŋgiŋa pa Yova Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Miki ilomi ndeka nâ kapanea Yova Kindeni ŋa kasuka kâki! Kalâ kamandi i nao ku kawâŋgi wâŋgiŋa ndekâŋa kâ papa i! ");
INSERT INTO xsi_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Ara ŋana miki ma kasama ku kaporo pwataki tu Yova Kindeni imo Maro Ŋalae. Ŋana tu muŋgani i simbo nâ iveta kinda Isrel tapâŋga i ne ŋgu, aku ipatea kinda pa i tamwata. Kinda tamo i ne tamâta, tatogonzi lama ŋgu i uru ikatonanzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Miki kawami ndaŋge nâ kamâ luma sapâŋa ilo kapanea i. Kaporo ndaŋge papa, ku kasuka i ŋa kâki ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Ŋana tu Yova Kindeni nde Ara Tamwata. Ikura zo zo i tini mwasa ndo panzi ne tamâta. I uru iyoka ne ŋgua pâŋa rârâni muli, ma iveta mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Yova Kindeni, naŋa ma awâŋgi wâŋgiŋa atula pwataki tu noko uru kuveta ikura tamwata ne ŋgua rârâni, aku noko uru kuveta vetâŋa sondo nâ panzi tamâta rârâni. Yova Kindeni, naŋa ma awâŋgi wâŋgiŋa ŋine imâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Aku naŋa ma apakatona warakâŋgu sondo ndo ŋana naneŋgu vetâŋa rârâni kâ. Aŋga Yova Kindeni, ande noko ma kumâ pa naŋa lâ zo ndia, a? Naŋa koipu ŋalae ma apaveta kuku vetâŋa sondo nâ lâ naneŋgu luma ara ŋine ilo. ");
INSERT INTO xsi_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Naŋa ma asâu pa mâsi sakamao toŋge tu ma imo naoŋgu, ande tia ndo. Tamâta pinde sipu mulinzi pa Yova Kindeni, andeta naŋa tiniŋgu pwâka ndo ŋana nenzi vetâŋa ŋinde kâ. Naŋa ma tiniŋgu piti ndo ŋananzi. ");
INSERT INTO xsi_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Ilo-kalo soki-soki ma ikeno malawae ndo ŋana naŋa kâ, aku naŋa ma apu muliŋgu pa mâsi sakamao rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Naŋa koipu ŋalae ma azavarunzi tamâta rârâni uru simo nia ŋgaŋe-ŋgaŋe siporo ŋgua tale ŋananzi tamâta pinde. Mao nâ, tamâta ea kinzi uru sipandekâna wa sipasuka warakanzi tininzi wa, ande naŋa ma aŋaranzi kinzi ŋinde rârâni piti lâ naoŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Taitu naŋa ma iloŋgu ara ndo ŋananzi tamâta ŋinde uru sipono muli pa Yova Kindeni. Naŋa ma asâu panzi tu ma simo naneŋgu luma ara ŋine ilo kuku naŋa. Mao nâ, tamâta ea sipaveta kuku vetâŋa ara, ande naŋa ma asâu panzi ŋinde tu ma siveta wurâta pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Andeta naŋa ma asâu pa laŋeŋa tamâta toŋge tu ma imo naneŋgu luma ilo, ande tia ndo. Ambo tamâta toŋge ma iporo ŋgua laŋeŋa, ande i ma ikura tu imandi naoŋgu kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Ikura zo zo, naŋa ma akai wurâta ŋana azavarunzi tamâta sakamao rârâni simo tâno ŋine. Naŋa ma aŋaranzi kinzi kiesaka tamwatanzi rârâni sikâwa silâ, aku kinzi ma sikura tu sitaulo simâ simo Yova Kindeni ne lawea ilo kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Yova Kindeni, kupaloŋo pa naneŋgu noŋa! Naŋa asarâwa pano tu kuvilana. Kutambira taŋa pa naneŋgu tiŋa! ");
INSERT INTO xsi_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Lâ zo ŋana malia itu imâ ipâŋga pa naŋa, ande noko ma kupavea ŋanana ndimo. Lâ zo ndia naŋa asarâwa pano, ande naŋa iloŋgu tu noko ma kuloŋo naneŋgu sarawâŋa ku kuvilana walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Naneŋgu via ŋine nde ilâ walele, itogo yââ ne mundo uru ikeno zo mbwana-mbwana nâ, ŋineŋga nao tia lâ. Aŋga karaeŋgu nde nâna ndo, itogo yââ ŋalae ikana mine. ");
INSERT INTO xsi_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Kinzi sitawa naŋa ndue ndo, itogo tamâta kie nâ ipale leu ŋgâla-ŋgâla mine, aku naŋa tiniŋgu pwâka ŋana aka kâpwa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Naŋa asama nâna ŋalae kala amo asarâwa nâ. Mine nde naŋa tiniŋgu râki-râki ndo. ");
INSERT INTO xsi_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Naŋa amo ara tia ndo. Naŋa amo atogo malabogi imo nia bilimu, aku amo atogo sii toŋge uru imo kaa nâ lâ lawea toŋge muŋga sizavaru kala tamâta simo tia. ");
INSERT INTO xsi_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Naŋa akeno kenoŋa nia, andeta matâŋgu pareŋge nâ. Opopo, naŋa simboŋgu nâ amo, atogo sii toŋge isaŋona luma kulu âta mine. ");
INSERT INTO xsi_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Naneŋgu kazâŋa tamâta nde siporo ŋgua potomule pa naŋa ikura kari wa mbo wa. Kinzi siporo ŋgua pavaligiŋa pana, aku kinzini uru sipatu naŋa ŋâŋgu ŋineŋga situ nzâmbe sakamao tona. ");
INSERT INTO xsi_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","O, Yova Kindeni, noko nde wisi nâna ŋalae tina pa naŋa. Mine nde ikura zo zo naŋa aliŋi kââ kâki kuluŋgu, ŋana itula pwataki tu naŋa iloŋgu malia ndo. Mao nâ, matâŋgu sulu indu ndue ikura kari wa mbo wa. Noko pwai naŋa kâki ku kutambirana alâ nia ŋgaŋe, atogo kina mine. ");
INSERT INTO xsi_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Naŋa ma amo viâŋgu ikura zo mbwana-mbwana nâ, itogo kari indue ku pararai lâ. Naneŋgu walo nde marumbu lâ, itogo unza ŋgâla-ŋgâla lâ mine. ");
INSERT INTO xsi_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Andeta Yova Kindeni, noko kumo koipu ŋalae ku kumo nâ. Ikura zo muli rârâni, ande kinzi tamâta ma situla noko parina pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Muli ŋga noko ma kumandi ku ma kalo sukâŋa ŋana Saion lawea kâ. Muŋga noko kupatea zo toŋge ŋana ma kuveta kie ara pa lawea ŋinde. Kala ŋine zo ŋinde nde imâ ipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Kinzi sizavaru Saion lawea marumbu lâ, andeta noko ne wurâta tamâta nde ilonzi ndo keno yo papa lawea ŋinde. Mao nâ, lawea ŋinde nde zavaruŋa ndo lâ, kala noko ne tamâta kalonzi sukâŋa ŋana. ");
INSERT INTO xsi_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Andeta muli ŋga tamâta ŋgu ndoni ma simege ŋana Yova Kindeni kâ, aku kinzi koipu ŋalaŋala rârâni simo tâno kulu ma siruru ŋana i ne kaika kâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Lâ zo ŋana Yova Kindeni ma ipa Saion lawea kâki kilo, ande lâ zoni ndaina i ma itula ne walo kaika pwataki panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Aku kinzi ma simora tu i ipaloŋo panzi ne tamâta nenzi noŋa lâ, kinzi ŋinde muŋga ipilenzi kala simo sugorai nâ. Mao nâ, i ma tini pwâka kilo ŋana nenzi noŋa kâ, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Naŋa iloŋgu tu kinzi tamâta sipâŋga muli-muli ŋinde ma sipanea Yova Kindeni ŋa sisuka kâki mine nâ. Mine nde ara ŋana kinda ma taŋgere ŋgua ŋana Yova Kindeni ne mâsi ŋalaŋala ŋinde lâ pepa tini ilâ panzi mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","“Yova Kindeni imo tamwata ne lawea sapâŋa ikeno âta ŋinde, aku mata indue imâ. Ina imo samba ilo, aku mata indue imâ ilea pa tâno. ");
INSERT INTO xsi_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","I iloŋo kinzi tamâta simo luma sakamao ilo ŋinde nenzi tiŋa. Muŋga kinzi kazâŋa tamâta sipa ŋgua tu ma sipunzi tamâta ŋinde pâta simâte. Andeta Yova Kindeni iyautenzi piti kala siyâti silâ.” ");
INSERT INTO xsi_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Mine kala muli ŋga, lâ zo ŋana kinzi tinikoa ŋgu rârâni ma sipile nenzi lawea lawea ku silâ sipasau lâ Jerusalem lawea tu siwâŋgi sipanea Yova Kindeni, ande kinzi ma sisuka i ŋa kâki lâ Saion tuu kulu, aku paneâŋa ma ikâki pa i lâ Jerusalem lawea ilo. ");
INSERT INTO xsi_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Oyae, naŋa amo limoa yo, andeta Yova Kindeni iyaula naneŋgu kaika marumbu lâ. Mine nde naŋa akura tu amo viâŋgu zo ŋalae tia. ");
INSERT INTO xsi_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Naŋa ŋandai koŋa ŋga, naŋa tamâta limoa yo. Mine nde noko ma pwai naŋa piti lâ tâno kulu ndimo. Andeta naneŋgu Maro Kindeni, naŋa asama tu noko kumo mine ku kumo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Nia ndoyo, noko kupulia tâno ŋine kala ikeno kaika lâ, aku noko tamwata mbau nâ kupulia samba tava kelekele rârâni simo âta ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Samba tava tâno ŋinde ma muli naonzi tia lâ, aŋga noko Yova Kindeni ma kumo nâ. Mao nâ, samba tava tâno ma muli sakamao lâ, sitogo lalava siŋga râge-râge mine. Aku noko ma pwainzi piti, itogo tamâta ipasea ne pasawaŋa mine, aku ma naonzi tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Aŋga noko nde kumo mine ku kumo nâ. Noko ŋandai kupalele ŋga, aku noko ne mbwera ma marumbu, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Maka nde noko ne wurâta tamâta, aku kasama tu maka natuma ma simo ara nâ. Aku noko ma pwatonanzi natuma nenzi vâsa muli-muli mine nâ, aku kinzi kala ma simo ara lâ noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Naŋa apanea Yova Kindeni ŋa asuka kâki. Naŋa iloŋgu kaloŋgu ndoni apanea Yova Kindeni ŋa sapâŋa ŋinde asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Naŋa apanea Yova Kindeni ŋa asuka kâki. I nde ara tamwata, aku naŋa ma kaloŋgu kapa ŋana ŋinde kâ, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ina kala uru izavaru naneŋgu kiesaka rârâni piti lâ tiniŋgu. Aku lâ zo ndia pukoŋa itu ikai naŋa, ande inani uru isoki pukoŋa ŋinde rârâni piti lâ ku iveta tiniŋgu ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Yova Kindeni uru itiŋgi mateŋa piti kala iŋgeŋge ŋana naŋa kâ, aku inani uru iveta kie ara ndo pa naŋa mine: i ne tini-mwasa ikeno pa naŋa ikura zo zo, aku i uru kalo sukâŋa ŋalae tina ŋanana tona. ");
INSERT INTO xsi_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Yova Kindeni uru kelekele arara nâ ilua naŋa ikura zo rârâni naŋa amo viâŋgu lâ tâno kulu. Mao nâ, ŋinde itogo naŋa amo limoa nâ ikura mbwera mbwera, aku naneŋgu walo ikeno pana ikura zo zo, itogo sii kananâwe ne walo mine. ");
INSERT INTO xsi_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Aku Yova Kindeni uru ivilanzi tamâta pinde lâ vetâŋa kie taituni. Kinzi nenzi walo nde ŋalae tia, kala tamâta pinde siveta kenzi sakamao panzi. Taitu Yova Kindeni ivetanzi simo sondo. ");
INSERT INTO xsi_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Muŋgani, Yova Kindeni itula ne pateâŋa pwataki pa Mose, aku isâu panzi Isrel tamâta tu ma simora i ne mâsi ŋalaŋala pinde. ");
INSERT INTO xsi_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Mao nâ, Yova Kindeni itula pwataki tu i nde kalo-sukâŋa warika wa wisi-wisi warika wa. I uru wisi nâna walele ande tia, aku i ne tini-mwasa ŋalae ŋinde uru imo mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","I ma ileleanzi ne tamâta ikura zo pinde nâ, aku ne wisi-nâna ma ikeno zo luandondo nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Kinda uru taveta kiesaka tava vetâŋa potomule kie-kie, aku Yova Kindeni ikura tu ipare nia sondo pa kinda ku nâna ŋalae tina ilua kinda. Andeta i uru nâna tini mwata nâ ilua kinda. ");
INSERT INTO xsi_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","I ne vetâŋa ŋinde nde duvi mine: i tini mwasa ŋalae ndo panzi tamâta ea simege ŋana i kâ. Samba ikeno âta ndo ŋana tâno kâ, aku i ne tini-mwasa nde ŋalae tina mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Yova Kindeni uru ikai nenda kiesaka piti ku ionzi simo malawae ndo ŋana kinda kâ, itogo tâno pa mbwera kâ ikeno malawae ndo ŋana tâno pa wâra kâ. ");
INSERT INTO xsi_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Aku mine nâ, Yova Kindeni kala tini mwasa ndo panzi tamâta ea simege ŋana i kâ, itogo tamâta tini mwasa ndo panzi natu mine. ");
INSERT INTO xsi_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Ŋana tu nia ndoyo i tamwata ikai tâno ku ipulia kinda tapâŋga lâ. Isama kinda tamâta kilalânda tu nenda walo nde ŋalae tia. Mao nâ, kinda tatogo tâno ne gawura mine. ");
INSERT INTO xsi_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Kinda tamâta nenda via nde mbwana-mbwana nâ, itogo unza mine. Kinda tatumbu lee ku tamo zo kiri-mwata nâ, itogo unza ne mâle ipâŋga dugu ilo mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Ŋineŋga lawea iyoka ku iveta mâle ŋinde ŋgâla-ŋgâla lâ, kala iyauru ndue ku nao tia lâ walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Andeta Yova Kindeni ne tini-mwasa ikeno panzi tamâta ea simege ŋana i kâ, ma ikeno mine ku imo nâ. Aku i uru iveta vetâŋa arara nâ panzi tamâta sondo ŋinde nenzi vâsa muli-muli tona mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","I iveta mine panzi tamâta ea sipono muli pa i ne ŋgua pâŋa wa sipaveta kuku i ne tukuŋa wa. ");
INSERT INTO xsi_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yova Kindeni imo koipu ŋalae lâ samba ilo, aku inani uru ikai poe pa kelekele rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Miki Yova Kindeni ne aŋelo kaika rârâni, miki ma kapanea Yova Kindeni ŋa kasuka kâki, aku kapono muli sondo pa i ne tukuŋa wa kapaloŋo sondo nâ pa i kawa ŋgua wa, ikura uru kaveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Aku miki Yova Kindeni ne zugu tamâta kaika, miki ŋinde kamo samba ilo ku kaveta ikura i ne pateâŋa mine, miki kala kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Mao nâ, miki kelekele rârâni ŋine Yova Kindeni nanayoni ipuliami kapâŋga lâ, kala kamo kakura nia ndoni i tamwata uru ikai poe papa, miki ŋinde kapanea Yova Kindeni ŋa kasuka kâki! Naŋa kala mine nâ apanea Yova Kindeni ŋa asuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Naŋa apanea Yova Kindeni ŋa asuka kâki. Naneŋgu Maro Yova Kindeni, noko ŋa nde ŋalae ndo. Noko kilala nde ipâŋga nia yo tu noko ne walo nde kaika, aku noko nde ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Yova Kindeni, noko kulita sinâla lâ tini itogo tamâta ilita lalava mine. Aku nia ndoyo noko kuo nia maa ikeno âta ŋinde, itogo tamâta ipa luma ne mende kâki mine. ");
INSERT INTO xsi_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Aku noko kuveta tamwata ne luma imandi lââ âta ŋinde kulu. Take-take nde sitogo noko ne kareta mine, aŋga lawea uru ikaino kulâ wa kumâ wa. ");
INSERT INTO xsi_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Noko kuporo kusupwa lawea, aku lawea ikai kuleŋa pano kala ikai noko kawa ŋgua ilâ. Aŋga mbamba ne loloa nde ipâŋga itogo noko ne wurâta tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Noko muŋgani kuo tâno ŋine imandi kaika, aku tâno nde ŋana iparuse ilâ wa imâ wa, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Aku lâ zo ŋinde noko kuo tâi itura tâno itogo lalava itura tamâta mine. Mao nâ, lâ zo ŋinde lââ ituranzi tuu ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Andeta muli ŋga noko kuporo kaika pa tâi, aku ikâwa ilâ. Tâi nde iloŋo noko kusarâwa kaika, aku ikâwa ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Tâi ipilenzi tuu ndoni ku irere indue ilâ nia kawa kawa. Noko kupatea tu tâi ma imo nia ŋgaŋe ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Aku noko kuo keri lâ, aku kundi kaika tu tâi ma ipu keri ŋinde utu ndimo. Mine kala tâi ma ikura tu itura tâno ndoni kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Noko kuveta lââ ipâŋga tâno ne keve ilo lâ tuu ŋgininzi, aku kuo lââ irere indue ilâ nia papata ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Aku kinzi simbi ŋgoi rârâni uru sinu lââ ŋinde. Mao nâ, kinzi sinu lee ikuranzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Kâi pinde simandi lââ ŋinde ŋgaŋe-ŋgaŋe, aku kinzi sii uru siveta palanzi lâ kâi ŋinde lakanzi kulu. Kinzi sisaŋona kâi lakanzi kulu ku sita sindeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Noko kusupwa karâzi iyoka pa âta ndo imbe indue imâ tuu kulunzi. Noko kuveta kie ara mine pa tâno, kala tâno indeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Aku noko kala kuveta unza ipâŋga panzi bulmakao tu ma sika kâ. Aŋga kelekele kie-kie ŋinde maka tamâta uru kapau, ande ŋinde tona noko kuvetanzi sipâŋga, kala kaka. ");
INSERT INTO xsi_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Mao nâ, noko kuveta kâi waini ipâŋga, kala maka kapale kanaŋo ku kanu waini, aku kandeka nâ. Aku noko kuveta kâi “oliv” ipâŋga tona, kala maka kakai ne samimi ku kayoli lâ naoma ŋana naoma zuli-zuli kâ. Aku noko kuveta kâpwa ipâŋga tona, kala maka kaka tu isuka karaema. ");
INSERT INTO xsi_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Nanayoni Yova Kindeni tamwata ipau kâi matapuru sipâŋga Lebanon tâno, aku i uru io karâzi ŋalae imâ ŋana isukanzi kâi ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Kinzi sii uru siveta palanzi lâ kâi matapuru ŋinde lakanzi kulu. Aŋga sii pararâo nde uru siveta palanzi lâ kâi gâru lakanzi kulu. ");
INSERT INTO xsi_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Kinzi meme ŋgoi nde simo tuu ŋalaŋala kulunzi, aŋga kinzi gewo nde simuna simo nia mira. ");
INSERT INTO xsi_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Maro Kindeni, nia ndoyo noko kupulia nzimona ipâŋga, aku kupatea tu ŋinde ma itula zo pwataki ikura nzimona rârâni lâ mbwera mbwera. Aku kari nde uru indue lâ zo sondo ŋinde noko tamwata kupatea papa. ");
INSERT INTO xsi_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Noko kuveta kondoma ipâŋga lâ mbo, aku ikura mbo mbo kinzi simbi ŋgoi nde siyâti simâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Kinzi mbwâmbwa saka “leve” natunzi nde sisuŋa kawanzi ku silâ wa simâ wa, siroto kanzi simbi ndia noko tamwata kupatea panzi ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Kinzi siroto lee mbwale pwataki, ŋineŋga sitaulo silâ pa nenzi ŋgânza ŋgânza, aku sikeno. ");
INSERT INTO xsi_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Ŋineŋga mboyo, ande kinzi tamâta simandi sânda ku silâ siveta nenzi wurâta. Siveta wurâta lee kari indue ku lala pararai lâ, ŋineŋga sipwarea. ");
INSERT INTO xsi_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Yova Kindeni, noko kuveta kelekele kie-kie rârâ! Noko ne ilo-kalo nde ŋalae kala kuvetanzi kelekele ŋinde rârâni sipâŋga. Kelekele vianzi kâ kie-kie muŋga kupulianzi sipâŋga ŋinde nde sipipi ndo sikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Tâi nde ŋalae ndo, aku iŋa tava kelekele pinde kie-kie nde simo tâi ilo, kelekele ŋalaŋala wa kiri-kiri wa. Maka kakura ŋana kasowe kelekele ŋinde kambwaŋenzi kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Wâŋga ŋalaŋala uru sikâwa tâi kulu silâ wa simâ wa, aŋga iŋa ŋalae ŋinde noko muŋga kupulia ipâŋga, ande ŋinde kala imo tâi ilo ku imo ipapatiki indeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Kinzi kelekele ŋinde rârâni nde uru sio tininzi ŋana noko nâ tu ma kâpwa kusuanzi lâ zo ndia putole ipunzi. ");
INSERT INTO xsi_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Noko tamwata uru kâpwa kusuanzi sika. Noko nâ kurombonzi kala kapwanzi pupuro. ");
INSERT INTO xsi_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Lâ zo ndia noko kupu muli panzi, ande kinzi siruru. Aŋga zo ŋana noko pwai koroani saŋenzi, ande kinzi simâte ku sipâŋga sitogo tâno gawura kilo. ");
INSERT INTO xsi_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Andeta noko kumbana koroani kilo kala natunzi simo vianzi. Mine nde noko uru kupulianzi kelekele pinde simo vianzi, aku sikai kelekele muŋga simâte ŋinde nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Naŋa kaloŋgu tawana tu Yova Kindeni ne walo kaika ŋinde ma keno mine ku imo nâ. Naŋa kaloŋgu tawana tu i ma indeka nâ ŋana kelekele rârâni ipulianzi sipâŋga ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Lâ zo ndia i mata ilea pa tâno, ande tâno ririŋo nâ. Aŋga lâ zo ndia isuŋa mbalau itaŋo tuu tini, ande mundo ipâŋga tuu ilo ku iyâti imâ. ");
INSERT INTO xsi_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Naŋa ma awâŋgi wâŋgiŋa pa Maro Kindeni ikura zo rârâni naŋa amo viâŋgu. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pa naneŋgu Yova Kindeni lee ikura lâ zo ndia naŋa ma amâte. ");
INSERT INTO xsi_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Inani uru io ndekâŋa lâ iloŋgu kaloŋgu, kala awâŋgi wâŋgiŋa paneâŋa kâ papa i. Naŋa iloŋgu tu i ma ilo ara nâ ŋana naneŋgu wâŋgiŋa ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Yova Kindeni, naŋa iloŋgu tu noko ma kuzavarunzi kinzi kiesaka tamwatanzi rârâni. Naŋa iloŋgu tu kinzi tamâta sakamao ma naonzi tia lâ. Naŋa apanea Yova Kindeni ŋa asuka kâki. Miki rârâni kala kapanea Yova Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Miki tamâta ŋai, miki ma kawami ndaŋge pa Yova Kindeni, aku katula i kilala pwataki tu i ŋa nde ŋalae. Miki katapâri panzi tinikoa ŋgu rârâni ŋana i ne vetâŋa ŋalaŋala kâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Miki kawâŋgi wâŋgiŋa paneâŋa kâ papa i, aku katula vetâŋa arara rârâni i muŋga iveta ŋinde pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Miki kandekana Yova Kindeni Sapâŋa Tamwata. Miki tamâta ea uru kapono muli pa i, ande ara ŋana miki ŋinde ma ilomi ndeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Miki kalâ pa Yova Kindeni i Walo Tamwata, ku kamandi i nao ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Miki Yova Kindeni ne wurâta tamâta ŋine lâ Abraham ne vâsa ŋgu, miki kaloŋo ŋga. Mao nâ, miki Yova Kindeni ne pateâŋa tamâta ŋinde lâ Yakopu ne vâsa ŋgu, miki kalomi ŋgere kilo ŋana Yova Kindeni ne mâsi ŋalaŋala, aku kalomi ŋgere kilo ŋana i ne mâsi ŋana ipare nia panzi tamâta sakamao kâ tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yova Kindeni imo kinda nenda Maro Ŋalae. Ina uru ikai poe panzi tamâta rârâni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","I ne mbutukunâŋa muŋgâŋa ŋinde ma ikeno mine ikura zo zo. I ma iveta ikura ne ŋgua pâŋa mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Nanayoni ipambwâre kuku Abraham, aku ŋgua pâŋa ŋinde ikeno pa Abraham natu Isaka tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Yova Kindeni ipa ŋgua kuku Isaka natu Yakopu, aku ŋgua pâŋa ŋinde ma ikeno mine nâ ikura zo rârâni. Iveta ŋgua pâŋa kunzi Isrel ŋgu, aku ŋinde ma marumbu tia. ");
INSERT INTO xsi_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Yova Kindeni ne ŋgua pâŋa kala ŋine: “Naŋa ma Kenan tâno alua miki. Naŋa apatea tâno ŋinde tu ma ikeno pa miki tavanzi nemi vâsa ŋgu.” ");
INSERT INTO xsi_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Mao nâ, nia ndoyo Yova Kindeni ne ŋgu ŋinde kambwaŋenzi nde kiri-mwata, aku simo tâno ŋinde sitogo lombo mine. ");
INSERT INTO xsi_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Lâ zo ŋinde kinzi simo sondo tia. Kinzi uru soka silâ pa tâno pinde, aku muli ŋga silâ pa tâno pinde. Kinzi simo koipu ŋalae toŋge ne tâno ikura zo mbwana-mbwana nâ, ŋineŋga sipile tâno ŋinde ku silâ pa koipu ŋalae toŋge ne tâno. ");
INSERT INTO xsi_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Andeta Yova Kindeni ŋandai isâu panzi tinikoa ŋgu tu ma sizavarunzi ŋga. I itu kaika panzi koipu ŋalaŋala tu ma siveta soki pa i ne ŋgu ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Ipainzi tu, “Naŋa apateanzi tamâta ŋine tu ma sikai wurâta pa naŋa. Miki ma kaveta kemi sakamao toŋge panzi ndimo. Miki ma kakai kazâŋa panzi naneŋgu ŋgua-tulâŋa tamâta ndimo.” ");
INSERT INTO xsi_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Yova Kindeni iveta putole ŋalae ipâŋga Kenan tâno, tâno ŋine i ne ŋgu simo, aku izavaru kanzi kâpwa rârâni marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Andeta i ilo tu ma ivilanzi ne tamâta. Mine kala muŋgani lâ isupwa Yosepe ilâ pa Isip tâno imuŋga panzi. Vetâŋa ŋinde nde ipâŋga mine; tamâta pinde siko Yosepe saŋenzi tua, aku sikai silâ Isip tâno ku iveta wurâta koa tia nâ panzi. ");
INSERT INTO xsi_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Kinzi wâlo kaika nâ sipa i kie, kala kie nâna. Aku simwali wâlo kaika ku silita lâ i ŋandola tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","I imo mine lee, ŋineŋga vetâŋa pinde ipâŋga, aku vetâŋa ŋinde nde kie taituni itogo Yosepe muŋga iporo tu ma ipâŋga mine. Mine kala ŋgua ŋinde Yova Kindeni itula pa Yosepe nde ipâŋga kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Ŋineŋga Isip nenzi koipu ŋalae ipalele ilo kalo ku isupwa tamâta toŋge ilâ iyaule wâlo kaika piti lâ Yosepe tini. Mao nâ, koipu ŋalae ŋinde ikai Yosepe piti lâ luma sakamao ilo ku iyâti imâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Aku koipu ŋalae ŋinde io Yosepe ipâŋga tamâta ŋalae. Mine kala Yosepe imo koipu mbâna-mbâna lâ Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","I ne wurâta nde ŋana ikai poe panzi koipu ŋalae ne dumui wa ipanananzi tamâta ŋinde uru situla ilo-kalo pa koipu ŋalae wa. ");
INSERT INTO xsi_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Aku muli, ŋineŋga Yosepe tama Yakopu kala ilâ imo Isip tâno tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Kinzi simo Isip tâno lee, ku Yova Kindeni ivilanzi tamwata ne ŋgu, kala sipulianzi nenzi vâsa rârâ sipâŋga. Iveta nenzi walo ipâŋga ŋalae, ipole nenzi kazâŋa tamâta ŋinde nenzi walo. ");
INSERT INTO xsi_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Mine nde ilele kinzi Isip tamâta ilonzi kalonzi kala sikai kazâŋa panzi i tamwata ne ŋgu. Ŋineŋga kinzi Isip siroto nzâla ŋana siveta soki panzi Yova Kindeni ne wurâta tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Ŋineŋga Yova Kindeni ipateanzi ne wurâta tamâta rua, Mose ku Aron rua, aku isupwanzi ŋana sivilanzi i ne ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Mine kala kinzi rua situla Yova Kindeni ne mâsi ŋalaŋala kie-kie ipâŋga Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Mao nâ, lâ zo ŋinde Yova Kindeni iveta kondoma ŋalae ipâŋga itura Isip tâno ndoni, andeta kinzi taŋanzi kaika nâ pa i kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Aku iveta lââ ipalele ipâŋga see tona, kala Isip kanzi iŋa rârâni sipamateteu marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Aku ivetanzi piri-piri sipâŋga kambwaŋenzi walo tona, kala sipipi lâ sikura tâno ŋinde ndoni. Kinzi silâ lee sipipi lâ koipu ŋalae tamwata ne luma ilo tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Aku Yova Kindeni iporo ŋgua, ŋineŋga lâŋo wa nipa-nipa rârâ ŋinde nde simâ sipâŋga tava, ku silâ sikura tâno ŋinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Aku i ŋandai io karâzi nâ indue pa nenzi tâno ŋga. I io karâzi “ais” tava loloa indue imâ ŋana iyaula nenzi tâno. ");
INSERT INTO xsi_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","I iyaula nenzi kâi waini wa kâi “fik” wa, aku imbware nenzi kâi pinde rârâni nuki-nuki tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Aku i kawa iporo ŋgua, ŋineŋga ndemu-ndemu rârâ ŋinde simâ sipâŋga tona. Tamâta toŋge ikura tu isowe kambwaŋenzi, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Kinzi ndemu-ndemu sika kelekele rârâni launzi keno, aku sika kâpwa ndoni Isip tamâta muŋga sipau kala ipâŋga tâno ilo ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ŋineŋga Yova Kindeni ipunzi Isip ŋgu natunzi tamâne nzâla-kulu rârâni sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Aku muli, ŋineŋga Yova Kindeni ikainzi Isrel ŋgu sipile Isip ku siyâti silâ. I iveta mine; igagati kinzi Isip ilonzi kalonzi, kala sikai nenzi siŋgâra arara “silva” wa “gol” rârâni ku silanzi Isrel ŋgu, kala sikai silâ. Kinzi Isrel tamâta rârâni soka ara nâ silâ, aku Yova Kindeni ne tamâta toŋge ipayaula ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Ŋana tu kinzi Isip ŋgu siruru pâta ŋananzi Isrel ŋgu. Mine kala lâ zo ŋana kinzi simora tu Isrel ma sipilenzi silâ, ande ilonzi ndeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Kinzi Isrel ŋgu nde soka silâ, aku Yova Kindeni io take-take toŋge imâ ituranzi ne tamâta. Aŋga lâ mbo, ande isupwa yââ ŋalae ipâŋga isinalanzi itogo sinâla mine. ");
INSERT INTO xsi_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Kinzi sino papa ŋana simbi pinde, aku ionzi sii pinde simâ, kala i ne ŋgu sika. I samba ne kâpwa ilanzi sika, kala kapwanzi pupuro ndo. ");
INSERT INTO xsi_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Aku kinzi sirakoŋa ŋana lââ tava. Mine nde iveta mira ŋalae toŋge tu ipwa, kala lââ imaliŋi irere indue ilâ pa nia bilimu, itogo lââ irere dugu ilo mine. ");
INSERT INTO xsi_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Mao nâ, i kalo ŋgere kilo ŋana ŋgua pâŋa sapâŋa ŋinde muŋga iveta kuku ne wurâta tamâta Abraham. ");
INSERT INTO xsi_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Mine kala ikainzi i tamwata ne pateâŋa tamâta siyâti silâ. Kinzi sisuŋa kawanzi ŋalae, aku siwâŋgi ku sindeka nâ silâ. ");
INSERT INTO xsi_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Aku muli ŋga ikai tinikoa ŋgu nenzi tâno ku ikisi keri panzi i ne ŋgu ŋinde kala simo ndaina, aku isâu panzi tu ma sika kâpwa kinzi ŋgu ŋinde muŋga sipau ipâŋga tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Iveta mine ŋana duvi ŋine kâ: i ilo tu kinzi Isrel ŋgu ma sipono muli pa i ne ŋgua tukuŋa rârâni wa i kawa ŋgua ndoni wa. Tapanea Yova Kindeni ŋa tasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Tapanea Yova Kindeni ŋa tasuka kâki! Kawânda ndaŋge pa i, ŋana tu i nde ara tamwata, aku i uru tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Tamâta toŋge ikura ŋana itula mâsi ŋalaŋala rârâni Yova Kindeni muŋga iveta ŋinde duvi pwataki, ande tia. Aku tamâta toŋge ne paneâŋa ma irerege kuku i ne vetâŋa ŋinde, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Kinda tasama tu Yova Kindeni ne nzâmbe ara ikeno panzi tamâta ea soka i ne tukuŋa muli ku sipaveta kuku vetâŋa ara ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Mine nde Yova Kindeni, lâ zo ŋana noko ma kuvilanzi ne tamâta, ande naŋa ano pano tu kalo ŋgere ŋana naŋa kâ tava. Mao nâ, lâ zo ŋana noko ma pwainzi piti lâ kazâŋa ilo, ande naŋa iloŋgu tu noko ma pwai naŋa piti tona mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Naŋa iloŋgu tu amora noko ne tamâta simo ara wa sikai kelekele arara wa, aku naŋa atu andeka kunzi noko tamwata ne ŋgu. Noko kupatea maka pa tamwata, aku naŋa atu andekanano kunzi. ");
INSERT INTO xsi_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Yova Kindeni, maka kaveta kiesaka, itogo timbuma muŋga siveta mine. Maka kaveta vetâŋa potomule wa mâsi sakamao kie-kie. ");
INSERT INTO xsi_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Nanayoni, lâ zo ŋinde maka timbuma simo Isip tâno, ande kinzi ŋandai kalonzi ŋgere sondo ŋana mâsi ŋalaŋala ŋinde noko kuveta panzi ŋga. Noko kutula pwataki panzi mbwani rârâ tu noko tini mwasa ndo panzi. Andeta kinzi kalonzi kapa ŋana ŋinde kâ, aku lâ zo ŋinde kinzi silâ sipâŋga Tâi Ŋiŋi pwali, ande kinzi taŋanzi kaika papa Yova Kindeni Walo Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Andeta Yova Kindeni ilo patea tu ma itula ne walo kaika ŋalae ŋinde pwataki panzi. Mine kala ikea ŋananzi, itogo muŋga ipa ŋgua tu ma iveta mine, kala ŋandai sipayaula ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","I iveta mine; i itu ŋgua kaika papa Tâi Ŋiŋi, kala tâi mâsa-mâsa lâ. Mine nde ikainzi ne tamâta soka mâsa-mâsa nâ lâ tâi ilo simbwaliu silâ, itogo tamâta iyoka tâno kaika mine. ");
INSERT INTO xsi_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Mao nâ, iyautenzi piti lâ tamâta pinde mbaunzi ilo, kinzi ŋinde uru wisinzi nâna panzi. Ivilanzi kala nenzi kazâŋa tamâta sikura tu sizavarunzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Andeta tâi ipatukunzi nenzi kazâŋa tamâta marumbu lâ, kala kinzi rârâni naonzi tia lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Ŋineŋga Yova Kindeni ne tamâta kalonzi tawana i ne ŋgua pâŋa, aku siwâŋgi wâŋgiŋa paneâŋa kâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Andeta kinzi walele nâ kalonzi kapa ŋana Yova Kindeni ne vetâŋa ŋinde kâ. Aku kinzi ŋandai sio tininzi pa Maro Kindeni tu ma itula ne pateâŋa pwataki panzi ŋga. Kinzi sikai siveta ikura warakanzi nâ nenzi ilo-kalo. ");
INSERT INTO xsi_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Kinzi simo nia bilimu, aku ilonzi ŋalae koŋa ŋana sika kâpwa ara pinde kâ. Mine kala siveta soki ku siporo ŋgua kaika pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Ŋineŋga Maro Kindeni isâu panzi, aku kelekele ŋinde kinzi sita ŋana, ande ŋinde ilanzi lâ. Andeta iveta pukoŋa ŋalae ipâŋga panzi tona. ");
INSERT INTO xsi_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Kinzi sipa nenzi pâla kâki simo nia bilimu, andeta tamâta pinde ilonzi ŋuru-ŋuru ŋana Mose kâ. Aku mine nâ, kinzi sipadâda ŋana Yova Kindeni tamwata ne wurâta tamâta Aron tona. ");
INSERT INTO xsi_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Mine nde tâno ipwa kawa maa, aku Datan tavanzi Abiram ne ŋgu ndoni nde patanzi sindue silâ mbââ ilo. Ŋineŋga tâno kawa kapu ku itataunzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Ŋineŋga yââ iyoka pa samba indue imâ kananzi tamâta sakamao ŋinde muŋga sipono muli panzi Datan ku Abiram rua, kala sipamateteu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ŋineŋga silâ sipâŋga Orep Tuu, ande sikai mira “gol” ku siveta bulmakao tai toŋge, aku sipare tukunzi papa maro laŋeŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Kinzi sipile nenzi mâsi ŋana sipare tukunzi pa Yova Kindeni, inani ŋa ŋalae ndo, aku sipare tukunzi pa bulmakao tamâne kaa uru ika leu nâ ŋinde tai. ");
INSERT INTO xsi_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Kinzi kalonzi kapa ŋana nenzi Yautâŋa Tamwata Maro Kindeni, inani kala muŋga iveta mâsi ŋalaŋala lâ Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Mao nâ, ina iveta mâsi ŋalaŋala kie-kie lâ Isip. Kinzi tamâta simora mâsi ŋalaŋala ŋinde iveta lâ Tâi Ŋiŋi, kala wisinzi motutu lâ. Andeta kinzi walele nâ kalonzi kapa ŋana. ");
INSERT INTO xsi_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Mine kala Maro Kindeni ilo patea tu ma izavarunzi ne ŋgu. Andeta i ne pateâŋa tamâta Mose nde imandi nao ku ino papa tu ma ipile ne wisi-nâna ku ma kalo sukâŋa ŋananzi. Aku Yova Kindeni isâu papa, kala izavarunzi tia. ");
INSERT INTO xsi_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Andeta muli ŋga, ande kinzi Isrel ŋgu tininzi pwâka tu sikai tâno ara ŋinde, ŋana tu kinzi ŋandai kalonzi tawana Yova Kindeni ne ŋgua pâŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Kinzi sisaŋona nâ simo nenzi pâla ilo, aku siporo ŋgua ilonzi ŋuru-ŋuru. Kinzi ŋandai sipono muli pa Yova Kindeni kawa ŋgua ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Mine nde Yova Kindeni itu ŋgua kaika panzi, aku iporo tu ma ipunzi pâta simâte lâ nia bilimu. ");
INSERT INTO xsi_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Aku ipa ŋgua tu ma isoki nenzi vâsa sikâwa pwapwataki silâ simo tinikoa ŋgu ŋgininzi lee, ma sipamateteu lâ tinikoa nenzi tâno. ");
INSERT INTO xsi_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Ŋineŋga kinzi silâ sipâŋga Peor Tuu, aku sipono muli pa kinzi tinikoa nenzi maro laŋeŋa, i ŋa tu Bal. Kinzi sika simbi muŋga sipatarâwa papa maro laŋeŋa ŋinde, andeta maro laŋeŋa ŋinde ŋandai imo via ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Nenzi vetâŋa ŋinde igagati Yova Kindeni ilo kalo, kala i wisi nâna ŋalae ŋinde panzi. Mine kala isupwa pukoŋa sakamao ilâ ipâŋga panzi. ");
INSERT INTO xsi_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Andeta Finias imandi ku ipare nia panzi tamâta siveta vetâŋa soki ŋinde, kala pukoŋa ŋalae ŋinde marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Kala ŋine kinda uru kalonda ŋgere ŋana Finias ne vetâŋa sondo ŋinde kâ. Aku muli ŋga, ikura zo rârâni, ande kinzi tamâta ma kalonzi ŋgere mine nâ ŋana i ne vetâŋa ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Aku zo toŋge kinzi Isrel ŋgu simo Meriba lââ bwalika, andeta siveta Yova Kindeni wisi nâna panzi. Aku ŋana nenzi vetâŋa soki ŋinde kâ, ande malia ipâŋga pa Mose. ");
INSERT INTO xsi_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Kinzi siveta Mose wisi nâna ndo. Mine kala i ŋandai kalo ŋgere sondo ŋineŋga iporo ŋga; ikai iporo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Muŋga Yova Kindeni iporo itu kaika panzi tu ma sipunzi tinikoa ŋgu rârâni pâta sipamateteu. Andeta kinzi ŋandai siveta ikura Yova Kindeni kawa ŋgua ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Tia ku Isrel tamâta sipakâe kunzi tinikoa ŋgu tamâta, aku sipono muli pa nenzi vetâŋa sakamao tona. ");
INSERT INTO xsi_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Kinzi sipare tukunzi panzi maro laŋeŋa, aku ŋinde iveta Yova Kindeni wisi nâna, kala izavarunzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Opopo, kinzi sipunzi warakanzi natunzi simâte, itogo patarawâŋa siveta panzi maro laŋeŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Mao nâ, kinzi sipunzi warakanzi natunzi taine wa tamâne wa simâte. Natunzi ŋinde ŋandai siveta vetâŋa soki toŋge ŋga, taitu kinzi sipunzi pâta ku sio karaenzi ilâ pa Kenan tâno nenzi maro laŋeŋa, itogo patarawâŋa mwasina. Aku nenzi vetâŋa sakamao ŋinde iveta tâno ipâŋga muso lâ Yova Kindeni nao. ");
INSERT INTO xsi_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Nenzi vetâŋa ŋinde iveta kinzi warakanzi sipâŋga ilonzi muso ndo lâ Yova Kindeni nao. Kinzi sipu mulinzi pa nenzi Maro Kindeni, aku silâ sipasipa kunzi maro pinde. Mine kala kinzi sipâŋga sitogonzi nzâla taine mine. ");
INSERT INTO xsi_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Mine nde Yova Kindeni wisi nâna ndo panzi ne tamâta. I tini pwâka ndo ŋananzi ne ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Ipu muli panzi lâ, ku ionzi silâ tinikoa ŋgu mbaunzi ilo. Mine kala kinzi simo nenzi kazâŋa tamâta kalonzi. ");
INSERT INTO xsi_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Nenzi kazâŋa tamâta ŋinde nde siveta kenzi sakamao ndo panzi. Kinzi kazâŋa tamâta nenzi walo nde kaika, kala sitawanzi Yova Kindeni ne tamâta ndue ndo. ");
INSERT INTO xsi_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Muŋga Yova Kindeni ivilanzi ne tamâta mbwani rârâ, taitu kinzi warakanzi ilonzi patea tu ma sipu mulinzi papa i. Aku nenzi kiesaka ŋinde itawanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Taitu muli ŋga kinzi sisarâwa pa Yova Kindeni tu ivilanzi, aku ipaloŋo pa nenzi noŋa. I kalo sukâŋa ŋananzi, ŋana tu kinzi simo sakamao. ");
INSERT INTO xsi_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","I kalo sukâŋa ndo ŋananzi, aku kalo ŋgere kilo ŋana ne ŋgua pâŋa muŋgâŋa kâ. I ilo ndo keno panzi, kala ipalele ilo kalo ku ilele nao panzi kilo. ");
INSERT INTO xsi_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Kinzi kazâŋa tamâta muŋga siveta kenzi sakamao nâ panzi Isrel. Andeta Yova Kindeni ŋineŋga ilulunzi ilonzi kalonzi kala kalonzi sukâŋa ŋananzi Isrel ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Mine nde maka nema Maro Yova Kindeni, kala ŋine maka kano pano tu kuvilama lâ vetâŋa kie taituni, aku pwaima piti lâ kinzi tinikoa ŋgu mbaunzi ilo. Pwaima kataulo kalâ pa nema tâno kilo. Ambo noko ma kuveta mine, ande maka ma kawama ndaŋge ŋalae pano, ku ma kandekanano kapanea noko ŋa sapâŋa ŋinde kasuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Tapanea Yova Kindeni, ina kinda Isrel nenda Yova Kindeni! Tapanea i ŋa tasuka kâki ikura zo zo! Miki tamâta rârâni kawami tu, “Mao nâ”. Tapanea Yova Kindeni ŋa tasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","“Kinda kawânda ndaŋge pa Yova Kindeni, ŋana tu i nde ara tamwata, aku i tini mwasa ndo pa kinda ikura zo rârâni.” ");
INSERT INTO xsi_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Miki tamâta ŋine Yova Kindeni muŋga ikaimi piti lâ kazâŋa ilo, miki rârâni kagogo kawami aku kaporo ŋgua ndaina. ");
INSERT INTO xsi_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Ŋana tu miki muŋga kamo tinikoa ŋgu nenzi tâno ikeno pa mbwera kâ wa wâra kâ wa nia ndoni wa, andeta iyautemi piti lâ ku ikaimi taulo mâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Kinzi pinde muŋga simo nia bilimu ku soka silâ wa simâ wa, siroto nzâla ŋana ma silâ pa lawea toŋge tu ma simo ara kâ. Andeta sisânda nzâla toŋge kulu tia. ");
INSERT INTO xsi_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Kinzi putole ipunzi pâta lâ, aku sirakoŋa ŋana lââ kâ, kala ilonzi malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Malia ikainzi mine lee, ŋineŋga sisarâwa pa Yova Kindeni tu ivilanzi, aku ikai malia ŋinde piti panzi. ");
INSERT INTO xsi_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Ionzi lâ nzâla ara ku ikai poe panzi. Ikainzi soka silâ lee sipâŋga lawea ara toŋge, aku simo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Mine nde ara ŋana kinzi ŋinde ma kawanzi ndaŋge ŋalae pa Yova Kindeni, ŋana tu i ne tini-mwasa ikeno panzi ikura zo rârâni, aku i uru iveta mâsi ŋalaŋala arara panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","I uru lââ ilanzi tamâta ea sirakoŋa ŋana lââ kâ. Kinzi sinu, aku ilonzi ara ndo. Aŋga tamâta ea kinzi putole ipunzi, ande i uru kâpwa ŋalae ilanzi kala sika lee kapwanzi pupuro ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Aŋga kinzi pinde nde simo luma sakamao ilo. Kinzi simo nia ŋaŋa ndo. Kinzi nenzi kazâŋa tamâta muŋga sipa wâlo kaika lâ tininzi, aku nâna silanzi. ");
INSERT INTO xsi_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Ŋana tu kinzi taŋanzi kaika pa Maro Kindeni kawa ŋgua. Kinzi sipu Yova Kindeni Walo Tamwata ne ŋgua tukuŋa ututu. ");
INSERT INTO xsi_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Yova Kindeni iveta malia panzi kala simakâsa sikai wurâta ŋalae ndo, aku ilonzi kura tia ndo. Kinzi patanzi sindue tâno kulu, andeta tamâta toŋge imo ŋana isukanzi kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Malia ikainzi mine lee, ŋineŋga sisarâwa pa Yova Kindeni tu ivilanzi, aku ikai malia ŋinde piti panzi. ");
INSERT INTO xsi_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Yova Kindeni iyautenzi piti lâ nia kondoma ŋinde ilo, aku ipu wâlo kaika muŋga ikeno tininzi ŋinde ututu. ");
INSERT INTO xsi_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Mine nde ara ŋana kinzi ŋinde ma kawanzi ndaŋge ŋalae pa Yova Kindeni, ŋana tu i ne tini-mwasa ikeno panzi ikura zo rârâni, aku i uru iveta mâsi ŋalaŋala arara panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Ŋana tu imbware kinzi kazâŋa tamâta nenzi lawea ŋgumbi nzâla “aini” ŋinde ututu, aku imbware “aini” ipono luma sakamao ne nzâla kawa ŋinde ututu tona. ");
INSERT INTO xsi_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Aŋga kinzi pinde nde sipile ilo-kalo ara, kala sikai malia ŋana kiesaka kie-kie kinzi siveta ŋinde. Kinzi sipaveta kuku vetâŋa sakamao, kala sisânda nâna kulu. ");
INSERT INTO xsi_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Mine kala kinzi tininzi pwâka ŋana sika kâpwa kâ, ande kala laiti ŋana simâte kâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Malia ikainzi mine lee, ŋineŋga sisarâwa pa Yova Kindeni tu ivilanzi, aku ikai malia ŋinde piti panzi. ");
INSERT INTO xsi_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","I tamwata iporo ŋgua, aku ŋgua ŋinde iveta tininzi ara kilo. Iyautenzi piti lâ nâna ilo. ");
INSERT INTO xsi_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Mine nde ara ŋana kinzi ŋinde ma kawanzi ndaŋge ŋalae pa Yova Kindeni, ŋana tu i ne tini-mwasa ikeno panzi ikura zo rârâni, aku i uru iveta mâsi ŋalaŋala arara panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Aku ara ŋana kinzi ma siveta patarawâŋa, ŋana itula pwataki tu nenzi ndaŋge ŋalae ikeno papa i. Aku ara ŋana kinzi ma sindeka ku siwâŋgi wâŋgiŋa situla i ne vetâŋa rârâni pwataki panzi tamâta tona. ");
INSERT INTO xsi_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Aŋga kinzi pinde nde sikai wurâta lâ wâŋga ŋalaŋala kulu, kala sikâwa tâi geza-geza silâ sikura lawea lawea sikai wurâta ŋana mbaliŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Kinzi tamâta ŋinde simora Yova Kindeni ne mâsi kilala. Kinzi simora mâsi ŋalaŋala iveta lâ tâi geza-geza tini. ");
INSERT INTO xsi_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Mao nâ, kinzi simora Yova Kindeni itu pa lawea, ŋineŋga lawea ŋalae imandi ku iveta kâla ikâki ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Tâi nde isukanzi wâŋga ŋalaŋala kâki wa itawanzi ndue wa. Mine nde kinzi tamâta simo wâŋga kulu ŋinde nde siruru tu ma sipayaula, aku kalonzi loko nâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Kinzi sikâwa sitaŋgeŋge silâ wa simâ wa, sitogo tamâta inu lââ kaika kala idauda mine. Kinzi sisama pâta ŋana sikai poe pa wâŋga kâ, andeta sikura tu siveta vetâŋa toŋge ŋana sivila wâŋga kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Malia ikainzi mine lee, ŋineŋga sisarâwa pa Yova Kindeni tu ivilanzi, aku ikai malia ŋinde piti panzi. ");
INSERT INTO xsi_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ipono lawea ŋalae kala tâi pâti kii lâ, aku kâla imâte lâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Kinzi simora tu tâi pâti kii lâ, kala sindeka ndo. Aku Yova Kindeni ikainzi silâ sipâŋga lawea ne mâta ŋinde kinzi ilonzi tu ma sipâti simo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Mine nde ara ŋana kinzi ŋinde ma kawanzi ndaŋge ŋalae pa Yova Kindeni, ŋana tu i ne tini-mwasa ikeno panzi ikura zo rârâni, aku i uru iveta mâsi ŋalaŋala arara panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Lâ zo ŋana Yova Kindeni ne tamâta ma sipasau tu siwâŋgi, ande ara ŋana kinzi tamâta ŋinde ma siporo situla i kilala pwataki tu i ŋa nde ŋalae ndo. Aku ara ŋana kinzi ma simandi tamâta mbâna-mbâna naonzi lâ nenzi pasauŋa tona, ku sipanea i ŋa sisuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Ŋana tu Yova Kindeni ivetanzi lââ ŋalaŋala sipâŋga mâsa-mâsa ndo lâ, aku itu kaika papa lââ tu ma isâko ipâŋga tâno kulu tia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Kinzi tamâta simo tâno ŋinde nde uru siveta vetâŋa sakamao nâ. Mine nde Yova Kindeni ikai nenzi tâno ara ŋinde ne siŋi piti, ku iveta ipâŋga tâno ara tia. ");
INSERT INTO xsi_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Andeta Yova Kindeni itu ivilanzi ne tamâta. Mine kala iveta lââ bwalika ipâŋga nia bilimu, aku iveta lââ isâko ipâŋga nia mâsa-mâsa ku irere indue tava. ");
INSERT INTO xsi_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Isâu panzi tamâta ŋinde putole ipunzi tu ma sikai tâno ŋinde, kala siveta nenzi lawea ku simo. ");
INSERT INTO xsi_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Kinzi sipau kâpwa tava kâi waini lâ tânoni ndaina, aku kanaŋo ipâŋga maria. ");
INSERT INTO xsi_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yova Kindeni iveta kie ara ndo panzi ne tamâta. Mine kala sipulianzi nenzi vâsa kambwaŋenzi rârâ sipâŋga, aku iveta nenzi bulmakao sipâŋga kambwaŋenzi walo tona. ");
INSERT INTO xsi_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Andeta muli, ŋineŋga kinzi kazâŋa tamâta sipolenzi Yova Kindeni ne tamâta lâ paraŋa ilo ku siveta maŋeti panzi. Kinzi siveta kenzi sakamao panzi wa nâna silanzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Andeta Yova Kindeni itawanzi nenzi kazâŋa tamâta ndue ndo, ku iŋaranzi silâ wa simâ wa lâ nia bilimu pinde nzâla keno tia. ");
INSERT INTO xsi_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Andeta ivilanzi kinzi sugorai tamwatanzi, kinzi ŋinde muŋga simo sakamao, aku iveta nenzi vâsa sipâŋga kambwaŋenzi walo. ");
INSERT INTO xsi_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Kinzi tamâta arara nde simora Yova Kindeni ne vetâŋa mine ku wisinzi ara nâ. Aŋga kinzi tamâta sakamao nde siporo tia, kawanzi buu nâ. ");
INSERT INTO xsi_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Ayo, miki tamâta ea kamo tava nemi ilo-kalo ara, ande ara ŋana miki ma kalomi ŋgere sondo ŋana kelekele rârâni ŋinde kâ. Miki kalomi ŋgere sondo ŋana Yova Kindeni ne tini-mwasa ŋinde uru ikeno pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Maro Kindeni, naneŋgu kalo-tawana nde ikeno kaika pa noko nâ. Mao nâ, naŋa kaloŋgu tawanano sondo ndo, aku naŋa ma awâŋgi apanea noko ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Lâ mbone-mbone nâ, naŋa ma apagagati warakâŋgu amandi sânda lâ kenoŋa nia, aku ma ara neŋgu wâŋgu. Naŋa ma awâŋgi wâŋgiŋa mine lee mbwale pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Yova Kindeni, naŋa ma amandi kinzi tinikoa ŋgu naonzi, ku ma kawâŋgu ndaŋge pa noko. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ pano lâ tamâta ŋgu rârâni ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Ŋana tu noko ne tini-mwasa nde kiri-mwata tia ndo. Ŋinde ikeno mine ku imo nâ, aku ne keri nde ilâ ikura lâ nia maa ikeno âta ŋinde. Ikura zo zo noko kuveta ikura ne ŋgua pâŋa rârâni, aku mâsi ŋinde nde ŋalae ndo, ipole take-take ikeno samba tini ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Maro Kindeni, naŋa iloŋgu tu noko ma kuveta mâsi toŋge ipâŋga samba tini, ŋana itula noko kilala pwataki tu noko tamwata nde Maro Ŋalae. Naŋa iloŋgu tu noko ma kuveta ne walo kaika ipâŋga nia yo panzi tamâta ndoni simo tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Noko ilo ndo keno pa maka, aku ne walo nde ŋalae tina. Mine nde maka kano pano tu kupaloŋo pa nema noŋa, aku pwaima piti lâ kazâŋa ilo, ŋana ma kamo ara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Maro Kindeni imo i tamwata ne luma sapâŋa ilo, aku iporo tu, “Naŋa ma apole paraŋa, ŋineŋga ma andeka ŋana akisi keri lâ Sekem lawea tava Sekot ŋgu nenzi nia kawa ŋinde panzi naneŋgu tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Kinzi Ruben ŋgu aŋga kinzi Gat ŋgu nde naŋa warakâŋgu neŋgu tamâta, aku kinzi Manase ŋgu kala simo naneŋgu tamâta mine nâ. Kinzi Efraim ŋgu nde sitogo naneŋgu sambara kaika ŋana paraŋa kâ, aŋga kinzi Juda ŋgu nde sitogo koipu ŋalae ne tukâla uru ikeno naŋa mbauŋgu ilo. ");
INSERT INTO xsi_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Taitu naneŋgu morâŋa ikeno mine ŋananzi naneŋgu kazâŋa tamâta; kinzi Moap ŋgu nde ŋgu kaa nâ, itogo kondo naŋa uru apua mbauŋgu lâ ilo mwasina. Aku kinzi Idom ŋgu kala simo ŋgu kaa nâ, kala naŋa uru keŋgu nâ apalenzi. Naŋa apolenzi kinzi Filistia ŋgu lâ paraŋa ilo, kala andeka nâ akai lolove.” ");
INSERT INTO xsi_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Maro Kindeni, tiambo noko tini pwâka tu pwai naŋa alâ apara kunzi ŋgu ŋinde simo lawea ŋalae ilo, laweani ndaina ne ŋgumbi kaika iŋge mbwaliu lâ, tiya? Tiambo noko tini pwâka tu pwai naŋa alâ apara lâ Idom nenzi tâno, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Tiambo noko tamwata kupu muli pa maka marumbu lâ, tiya? Tiambo noko tini pwâka tu kuvilanzi nema zugu tamâta sipole paraŋa, tiya? ");
INSERT INTO xsi_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Maka kasama tu kinzi tamâta nenzi pavilâŋa nde kelekele kaa nâ. Mine kala maka kano pa noko tu kuvilama ŋana kapolenzi nema kazâŋa tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Mao nâ, ambo Maro Kindeni ma ivila maka, ande maka ma kapole paraŋa. I tamwata ma izavarunzi nema kazâŋa tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Maro Kindeni, naneŋgu paneâŋa imâ pa noko simbo nâ. Naŋa ano pano tu kupaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Ŋana tu kinzi laŋeŋa tamwatanzi sakamao nde sikai kazâŋa pa naŋa ku situ laginâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Naŋa ŋandai aveta vetâŋa soki panzi ŋga, andeta kinzi sikai kazâŋa pana ku sisowe ŋgua sakamao lâ tiniŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Naŋa uru tiniŋgu mwasa nâ panzi ku ano pano tu kusukanzi, andeta kinzini sitalea naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Naŋa uru aveta keŋgu ara nâ panzi, andeta kinzi sikatu kenzi sakamao imâ pa naŋa. Naŋa iloŋgu ndo ikeno panzi, andeta kinzi wisinzi nâna nâ pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Maro Ŋalae, kinzi nawalanzi toŋge iveta malia ŋalae tina pa naŋa. Naŋa iloŋgu tu noko ma kupatea tamâta sakamao toŋge tu ma imandi ŋgua nia ku isowe ŋgua lâ naneŋgu kazâŋa tamâta ŋinde tini. ");
INSERT INTO xsi_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Naŋa iloŋgu tu noko ma kusânda naneŋgu kazâŋa tamâta ŋinde ne vetâŋa soki kulu, aku kupa ŋgua ŋana kupare nia papa i kâ. Aku naŋa iloŋgu tu noko ma kumora i ne noŋa itogo kelekele sakamao tona. ");
INSERT INTO xsi_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Naŋa iloŋgu tu i ma imâte walele nâ, ŋineŋga tamâta toŋge ma ikai i nia. ");
INSERT INTO xsi_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Naŋa iloŋgu tu i ma imâte, aku i natu kinzi ma sipâŋga simo mundoro. Ara ŋana i kaiwa ma imo mwala! ");
INSERT INTO xsi_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Naŋa iloŋgu tu i natu kinzi ma simo sugorai, nenzi luma tia. Ara ŋana tamâta pinde ma siŋaranzi ŋana nenzi luma siŋga! ");
INSERT INTO xsi_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Ambo tamâta pinde nenzi mbuku ikeno pa naneŋgu kazâŋa tamâta ŋinde, ande naŋa iloŋgu tu kinzi ma simâ sikai i ne tâno tava ne kelekele rârâni. Naŋa iloŋgu tu kinzi ma sikai mbaliŋa rârâni i muŋga imakâsa ŋalae ŋana ikai ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Naŋa tiniŋgu pwâka tu tamâta toŋge ma io ne wisi-wisi ilâ pa tamâta ŋinde, aku tiniŋgu pwâka tu tamâta toŋge ma kalo sukâŋa ŋananzi i natu simo mundoro ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Naŋa iloŋgu tu i ne vâsa rârâni ma sipamateteu, aku kinzi tamâta sipâŋga muli-muli ŋinde ma kalonzi kapa ndo ŋana tamâta ŋinde ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Naŋa tiniŋgu pwâka tu Yova Kindeni ma izavaru naneŋgu kazâŋa tamâta ŋinde timbu muŋgâŋa nenzi kiesaka piti lâ tininzi! Aku naŋa iloŋgu mine nâ ŋana i tina tona! ");
INSERT INTO xsi_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Mao nâ, naŋa iloŋgu tu Yova Kindeni ma kalo ŋgere ŋana nenzi kiesaka kâ ikura zo rârâni. Ara ŋana i ma ivetanzi tamâta rârâni kalonzi kapa ndo ŋana kinzi ŋgu ŋinde seenzi kâ, ");
INSERT INTO xsi_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","ŋana tu naneŋgu kazâŋa tamâta ŋinde ŋandai io ne wisi-wisi ilâ pa tamâta toŋge ŋga. I uru iveta kie sakamao panzi sugorai tamâta wa, kinzi tamâta nenzi kelekele tia wa, kinzi tamâta simo tava kalonzi loko wa. I ilinzi lee ipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","I muŋga indeka ŋana ino pa Yova Kindeni tu ma iveta kie sakamao panzi tamâta pinde. Mine nde ara ŋana tamâta pinde ma sino pa Yova Kindeni tu iveta kie sakamao mine nâ pa i tamwata! I tini pwâka tu Yova Kindeni ma iveta vetâŋa ara panzi tamâta pinde. Mine nde ara ŋana Yova Kindeni ne vetâŋa ara ma ikeno malawae ndo ŋana i tamwata mine nâ! ");
INSERT INTO xsi_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","I uru iporo ŋgua sakamao mine ikura zo rârâni, itogo tamâta ipasawa pasawaŋa lâ tini mine. Ara ŋana i ne ŋgua sakamao ŋinde ma ipalele ku izavaru i tamwata! ");
INSERT INTO xsi_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Naŋa iloŋgu tu i ne ŋgua sakamao ŋinde ma ipâŋga itogo i ne lalava mine. Ara ŋana ŋgua ŋinde ma ilita i kaika ikura zo zo, itogo tamâta ilita wâlo lâ kambwaŋe mine. ");
INSERT INTO xsi_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Mao nâ, naŋa iloŋgu tu Yova Kindeni ma ipare nia mine panzi naneŋgu kazâŋa tamâta, kinzi ŋinde uru siporo ŋgua soki ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Taitu Koipu Ŋalae Yova Kindeni, naŋa ano pano tu kuvilana, ikura noko ne ŋgua pâŋa muŋgâŋa mine. Noko ne tini-mwasa ara ŋinde ikeno pa naŋa ikura zo zo. Mine nde ano pano tu pwaina piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Naŋa amo sugorai ndo, aku akura tu apavila warakâŋgu nde tia. Naŋa iloŋgu malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Tini nâ nde ma naŋa naoŋgu tia lâ, itogo kari indue ku lala pararai lâ. Naŋa amo atogo ndemu-ndemu lawea itapala kala ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Naŋa andi kaika ŋana kâpwa kâ ikura zo luandondo, kala tukuŋgu rua nenzi walo tia ndo. Naŋa tiniŋgu râki-râki ndo. ");
INSERT INTO xsi_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Naneŋgu kazâŋa tamâta nde simora naŋa ku siporo ŋgua pavaligiŋa nâ pana. Kinzi sirurua kulunzi pana wa siŋeleana wa. ");
INSERT INTO xsi_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Naneŋgu Maro Yova Kindeni, kuvilana ŋga! Noko tini mwasa pa naŋa ikura zo rârâni. Mine kala pwaina piti lâ kazâŋa ilo! ");
INSERT INTO xsi_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Yova Kindeni, kutula pwataki panzi naneŋgu kazâŋa tamâta tu noko tamwata simbo nâ kumo naneŋgu Pavilâŋa Tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Ambo kinzi ma sino pano tu kuzavaru naŋa, ande ara. Taitu naŋa kaloŋgu tawana tu noko ma kuveta kie ara nâ pana. Naŋa iloŋgu tu noko ma kutawanzi tamâta ŋinde siveta kenzi sakamao pa naŋa. Ŋineŋga noko ne wurâta tamâta naŋa ma iloŋgu ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Naŋa iloŋgu tu naneŋgu kazâŋa tamâta ma mainzi ŋalae. Ara ŋana maŋeti ma ituranzi ndo lâ, itogo pasawaŋa mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Andeta naŋa ma aporo kawâŋgu ndaŋge ŋalae pa Yova Kindeni. Lâ zo ŋana i ne tamâta ma sipasau ŋana siwawa i kâ, ande naŋa ma amandi kunzi apanea i ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Ŋana tu i uru isukanzi kinzi sugorai tamwatanzi ku ikainzi piti lâ nenzi kazâŋa tamâta mbaunzi ilo, kinzi ŋinde situ sipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Maro Yova Kindeni itu ŋgua pa naneŋgu Maro Ŋalae mine tu, “Noko kusaŋona ŋai pa mbauŋgu wia kâ lee, ikura lâ zo ŋinde naŋa ma aonzi noko ne kazâŋa tamâta simo noko kalo.” ");
INSERT INTO xsi_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Maro Yova Kindeni imo Saion lawea, aku io noko tu pwai koipu pa lawea ndoni. Ara, pwai poe kaika panzi ne kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Mao nâ, lâ zo ŋana noko kupara kunzi ne kazâŋa tamâta, ande noko ne tamâta ma ilonzi ara tu simâ pano lâ tuu sapâŋa kulu ŋana sivilano. Noko ma pwai walo kaika ikura zo rârâni, itogo mbo mbo mwâka uru ipâŋga unza tini, kala unza ikai walo wasaseki mine. ");
INSERT INTO xsi_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Maro Yova Kindeni ipambwâre lâ ku iporo mine tu, “Noko koipu ŋalae ma kumo patarawâŋa tamâta mine ku kumo nâ. Noko kumo patarawâŋa tamâta ŋalae, kutogo Melikisede mine.” Yova Kindeni kawa ŋgua rârâni nde mao kanaŋo, aku i ma ilele ne ŋgua ipâŋga kie toŋge tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Maro Yova Kindeni uru imandi noko tini laiti ŋana ivilano. Mine kala muli, lâ zo ŋana i ne wisi-nâna ma ipâŋga nia yo, ande i ma ipara kunzi koipu ŋalaŋala, ku ma ipolenzi itawanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Mao nâ, i ma ipare nia panzi tamâta ŋgu rârâni, ku ma ipunzi tamâta rârâ sipamateteu. I ma itawanzi koipu ŋalaŋala simo tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Koipu Ŋalae ma ilâ pa lââ ŋinde irere nzâla ŋgaŋe, aku ma inu. Mine kala i ma ikai walo, ku ma ipole paraŋa. ");
INSERT INTO xsi_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Naŋa iloŋgu kaloŋgu ndoni aporo ndaŋge ŋalae papa i. Lâ zo ŋana i ne tamâta sipasau tu siwawa i, ande naŋa ma amo kunzi ku ma kawâŋgu ndaŋge mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Ŋana tu Yova Kindeni uru iveta vetâŋa arara nâ. Tamâta ea ilonzi ara nâ ŋana Yova Kindeni ne vetâŋa kie-kie kâ, ande kinzi ŋinde rârâni uru kalonzi ŋgere sondo ŋana i ne vetâŋa ŋinde kilala kâ. ");
INSERT INTO xsi_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","I ne vetâŋa rârâni situla i kilala pwataki tu i ŋa nde ŋalae, aku i ne walo nde kaika ndo. I uru iveta kie ara ndo panzi ne tamâta, ma iveta mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Yova Kindeni uru igagatinzi ne tamâta ilonzi kalonzi tu ma kalonzi ŋgere ŋana i ne vetâŋa arara ŋinde kâ. I itu kinzi ma sisama tu inani nde wisi-wisi warika wa kalo-sukâŋa warika wa. ");
INSERT INTO xsi_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","I uru kâpwa isuanzi tamâta ea simege ŋana i kâ. Aku i ma kalo kapa ŋana ŋgua pâŋa ŋinde i muŋga iveta kunzi ne tamâta, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Muŋga ikai tinikoa ŋgu nenzi tâno ku ikisi keri panzi tamwata ne tamâta, aku ne vetâŋa ŋinde itula i ne kaika kilala pwataki panzi. ");
INSERT INTO xsi_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Mao nâ, Yova Kindeni ne vetâŋa rârâni nde mao kanaŋo ku sondo ndo. Mine kala kinda takura tu tapono muli pa i ne tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Nanayoni, lâ zo ŋinde Yova Kindeni itula ne ŋgua tukuŋa panzi ne tamâta, ande i ne vetâŋa ŋinde ipâŋga mao kanaŋo ku sondo nâ. Aku i ne ŋgua tukuŋa ŋinde ma ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Ina kala iyautenzi ne tamâta piti lâ kazâŋa ilo, ku iveta ŋgua pâŋa kunzi. Aku ŋgua pâŋa ŋinde ma ikeno mine ku imo nâ. Mao nâ, Yova Kindeni ŋa imo sapâŋa ndo; mine nde ara ŋana tamâta rârâni ma siruru ŋana i kâ. ");
INSERT INTO xsi_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Ambo tamâta toŋge ilo tu ipâŋga ilo-kalo tamâta, ande i ma imege ŋana Yova Kindeni muŋga lâ ŋga. Ina uru itula ilo-kalo arara panzi tamâta ea sipaloŋo pa i kawa ŋgua. Paneâŋa ilâ pa i ikura zo rârâni! ");
INSERT INTO xsi_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! I ne nzâmbe ara ikeno pa tamâta ea uru imege ŋana i wa ilo ara nâ ŋana ipono muli pa i ne tukuŋa wa. ");
INSERT INTO xsi_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Tamâta ara ŋinde natu wukale, kinzi ma simo tamâta ŋalaŋala lâ ŋgu naonzi. Aku Yova Kindeni ne nzâmbe ara ma ikeno panzi tamâta ara ŋinde timbunzi wukale mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Tamâta ara ŋinde see taitu kinzi ma simo mbaliŋa warakanzi, aku i tamwata ne vetâŋa arara ma ikeno ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ikura zo zo, tamâta ara uru kalo sukâŋa ŋananzi tini pinde ku io ne wisi-wisi ilâ panzi, aku i ne vetâŋa rârâni nde sondo nâ. Mine kala i nde itogo sinâla ŋana isinalanzi tamâta arara simo nia ŋaŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Tamâta ea uru ivilanzi tini pinde ŋana mbumbu kâ ku iveta vetâŋa sondo nâ ŋana ikai mbaliŋa kâ, ande tamâta ŋinde ma imo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Mao nâ, ambo tamâta toŋge ipono muli sondo pa Yova Kindeni, ande tamâta ŋinde ma imo ara nâ. Aku kinzi tamâta sipâŋga muli-muli ŋinde ma siloŋo i parina. ");
INSERT INTO xsi_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Ambo tamâta ara mine ma iloŋo pâri tu malia pinde ma imâ ipâŋga, ande i ma iruru tia, ŋana tu i ne kalo-tawana ikeno kaika pa Yova Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","I ma iruru ku kalo loko ŋana vetâŋa toŋge tia. Isama tu Yova Kindeni ma ipolenzi ne kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","I uru kelekele rârâ ilanzi sugorai tamwatanzi, aku ne vetâŋa arara ŋinde ma ikeno ikura zo zo. I ma imo tamâta ŋalae, aku kinzi tamâta ma sisuka i ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Kinzi tamâta sakamao simora tu tamâta ara uru imo ara mine, kala simo sipadâda nâ. Kinzi wisinzi nâna lee sipayaula ku naonzi tia lâ. Aku kelekele ara ndia kinzi tamâta sakamao situ ma sikai pa warakanzi, ande ŋinde ma sikai tia. ");
INSERT INTO xsi_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Miki Yova Kindeni ne wurâta tamâta, miki kasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Ara ŋana paneâŋa mine nâ ma ilâ pa Yova Kindeni lâ zo ŋine wa zo muli-muli wa. ");
INSERT INTO xsi_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Mine nde miki tamâta kala kamo pa mbwera kâ, aŋga miki ŋinde kamo pa wâra kâ, miki rârâni kapanea Yova Kindeni kasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Ŋana tu Yova Kindeni imo ikai Maro panzi tamâta ŋgu ndoni. I ŋa nde ŋalae ndo, kala ipolenzi kelekele rârâni simo samba ilo. ");
INSERT INTO xsi_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Mao nâ, tamâta toŋge irerege kuku kinda nenda Maro Yova Kindeni, ande tia. Ina imo âta ndo, ");
INSERT INTO xsi_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","kala nao tundu ŋana imora nia maa wa tâno wa. ");
INSERT INTO xsi_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","I nao tundu ŋana ivilanzi kinzi sugorai tamwatanzi, aku ikainzi piti lâ nia sakamao ilo. Tamâta ea simo sakamao ku sikura tu sipavila warakanzi tia, ande i uru isuka kinzi ŋinde kâki, ");
INSERT INTO xsi_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","aku ionzi simo rege-rege kunzi i ne ŋgu nenzi tamâta mbâna-mbâna. ");
INSERT INTO xsi_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Aku i uru iveta kie ara ndo panzi taine niŋga tava. Ivilanzi kala sipaguguanzi natunzi, ande kala taine ŋinde sindeka pâta kanaŋo. Mine kala tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Muŋgani, lâ zo ŋinde kinzi Isrel ŋgu sipile Isip tâno, lâ zo ŋinde Yakopu ne vâsa ŋgu sipile tinikoa ŋgu nenzi lawea, ");
INSERT INTO xsi_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","ande lâ zoni ndaina kinzi Juda ŋgu sipâŋga Maro Kindeni ne ŋgu sapâŋa. Mao nâ, kinzi Isrel ŋgu sipâŋga i tamwata ne tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Maro Kindeni ina ipâŋga Tâi Ŋiŋi pwali, aku tâi nde ikâwa ilâ imandi pa pinde, ilâ imandi pa pinde. Ŋineŋga i ilâ lee ipâŋga Jodan Lââ pwali, aku lââ imandi nâ. ");
INSERT INTO xsi_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Kinzi tuu ŋalaŋala siruru kala sipapatiki sitogonzi meme mine. Aku kinzi tuu kiri-kiri kala sisoŋga pwapwataki sitogonzi lama natu mine. ");
INSERT INTO xsi_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Noko tâi ndai, ande vetâŋa ndia ipâŋga pano kala noko pwâwa mine, a? Aŋga noko Jodan Lââ, mana mana ŋga kurere tia, a? ");
INSERT INTO xsi_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Aŋga miki tuu ŋalaŋala, ande vetâŋa ndia ipâŋga pami kala kapapatiki katogonzi meme mine, a? Aŋga miki tuu kiri-kiri, mana mana ŋga kasoŋga pwapwataki katogonzi lama natu mine, a? ");
INSERT INTO xsi_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Mao nâ, miki kamege ŋana Maro Kindeni kâ kala kaveta mine. Noko tâno ŋai, kala ŋine Maro Ŋalae imâ ipâŋga laiti lâ. Mine kala kuririŋo ŋga! Yakopu ne Maro Kindeni nde imâ ipâŋga lâ; mine nde ara ŋana noko ma kumo kuririŋo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Ŋana tu ina iveta lââ ipâŋga mira ilo ku iyâti imâ, aku inani iveta lââ isâko mira kaika ŋalaŋala ilo ku irere ndue. ");
INSERT INTO xsi_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Yova Kindeni, noko ne tini-mwasa ikeno pa maka ikura zo zo, aku noko uru kuveta ikura tamwata kawa ŋgua rârâni. Mine nde maka ma kasuka noko simbo nâ ŋa kâki. Maka ma kapasuka warakama ŋama kâki, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Ŋana sâ kâ ŋga kinzi tinikoa ŋgu uru sivaligi maka ku sikasoŋama mine tu, “Miki nemi Maro Kindeni ande imo ndia”, a? ");
INSERT INTO xsi_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Kinzi sizizâla tu kinda nenda Maro Kindeni imo samba ilo, aku i uru iveta ikura tamwata nâ ne pateâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Aŋga kinzi tinikoa ŋgu nenzi maro nde kelekele kaa nâ. Kinzi tamâta nâ sipare maro ŋinde tainzi lâ mira “gol” wa “silva” tini. ");
INSERT INTO xsi_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Kinzi maro laŋeŋa ŋinde kawanzi keno, andeta sikura tu siporo ŋgua kâ, nde tia. Kinzi matanzi keno, andeta sikura tu simora kelekele kâ, nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Kinzi taŋanzi keno, andeta sikura tu siloŋo ŋgua kâ, nde tia. Kinzi vigunzi keno, andeta sikura tu siŋo kelekele kuwae kâ, nde tia. ");
INSERT INTO xsi_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Kinzi mbaunzi keno, andeta sikura tu sitaŋo kelekele kâ, nde tia. Aku kinzi kenzi keno, andeta sikura tu soka kâ, nde tia. Kinzi sikura tu sisarâwa wa siveta nduŋeŋa toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Mine nde naŋa aporo tu kinzi tamâta kala uru sipare maro laŋeŋa kaa kaa ŋinde tainzi, ande kinzi ŋinde nde sirerege kunzi maro laŋeŋa ŋinde. Aku tamâta ea uru kalonzi tawana maro laŋeŋa ŋinde, ande kinzi kala sipâŋga kaa nâ, sitogonzi kinzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Aŋga miki Isrel ŋgu tamâta, miki ma kalomi tawana Yova Kindeni, ina uru ivilami wa ikatonami wa. ");
INSERT INTO xsi_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Aku miki Yova Kindeni ne patarawâŋa tamâta lâ Aron ne vâsa ŋgu, miki ma kalomi tawana Yova Kindeni, ina uru ivilami wa ikatonami wa. ");
INSERT INTO xsi_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Miki tamâta ŋine uru kamege ŋana Yova Kindeni kâ, miki ma kalomi tawana i nâ, ina uru ivilami wa ikatonami wa. ");
INSERT INTO xsi_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Ŋana tu Yova Kindeni uru kalo ŋgere ŋana kinda kâ, aku i ma iveta kie ara nâ pa kinda. I ma iveta kie ara mine nâ panzi Isrel ŋgu tamâta, sitavanzi Yova Kindeni ne patarawâŋa tamâta lâ Aron ne vâsa ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Mao nâ, Yova Kindeni ma iveta kie ara panzi tamâta ea simege ŋana i kâ, kinzi tamâta ŋalaŋala wa sugorai tamwatanzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Naŋa iloŋgu tu Yova Kindeni ma iveta natumi sipâŋga kambwaŋenzi walo, aku iloŋgu tu i ma iveta mine nâ panzi timbumi wukale tona. ");
INSERT INTO xsi_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Mao nâ, naŋa iloŋgu tu Yova Kindeni tamwata ma iveta kie ara ndo pa miki. Ina nia ndoyo ipulianzi samba wa tâno wa. ");
INSERT INTO xsi_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Samba nde Yova Kindeni simbo nâ ne ninia, aŋga tâno nde ilua kinda tamâta lâ. ");
INSERT INTO xsi_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Kinzi mateŋa tamâta silâ pa warakanzi nenzi lawea, aku sikura tu sipanea Yova Kindeni sisuka i ŋa kâki, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Aŋga kinda nde tamo viânda yo, aku ma kawânda ndaŋge pa Yova Kindeni lâ zo ŋine wa zo muli-muli tona. Tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Yova Kindeni uru ipaloŋo pa naneŋgu sarawâŋa. Mine nde naŋa tiniŋgu mwasa ndo papa i. Mao kanaŋo, i uru ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Ina itambira taŋa pa naneŋgu sarawâŋa rârâni. Mine nde naŋa ma amo akai noŋa pa i nâ ikura zo rârâni naŋa ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Muŋga, mateŋa ne nimbu nde ikai naŋa kaika lâ. Mine kala naŋa kaloŋgu ŋgere ŋana mateŋa nianzi, aku ŋinde iveta naŋa aruru pâta kanaŋo. Naŋa kaloŋgu loko ku iloŋgu malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Ŋineŋga asarâwa pa Yova Kindeni ku apai tu, “Yova Kindeni, naŋa ano kaika pano tu kuvilana! Tia ma amâte!” ");
INSERT INTO xsi_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Naŋa asama tu Yova Kindeni nde wisi-wisi warika wa vetâŋa sondo warika wa. Mao nâ, kinda nenda Maro Kindeni nde kalo-sukâŋa warika. ");
INSERT INTO xsi_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","I uru ikea ŋananzi tamâta ea sikura ŋana sipavila warakanzi tia. Mine nde lâ zo ŋana kalo-lokoni iveta iloŋgu malia ndo, ande ina ivilana. ");
INSERT INTO xsi_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Kala ŋine naŋa wisiŋgu puu ndue kilo, ŋana tu Yova Kindeni iveta kie ara ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Yova Kindeni itiŋgi mateŋa piti kala iŋgeŋge ŋanana lâ. Ipamasi matâŋgu sulu mâsa-mâsa lâ, aku ikea ŋanana. Mine nde malia ŋandai itawa naŋa ndue ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Mine kala naŋa ma ayoka kuku Yova Kindeni ikura zo rârâni naŋa ma amo viâŋgu lâ tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Naŋa kaloŋgu tawana Yova Kindeni. Mine kala muŋga naŋa aporo lâ warakâŋgu iloŋgu mine tu, “Malia ŋalae tina itawa naŋa ndue ndo lâ.” Taitu lâ zo ŋinde, naŋa ŋandai apile naneŋgu kalo-tawana ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Lâ zo ŋinde naŋa iloŋgu rârâ kala aporo lâ warakâŋgu iloŋgu mine tu, “Tamâta rârâni nenzi ŋgua pâŋa rârâni nde laŋeŋa nâ.” Andeta naneŋgu kalo-tawana ŋandai imbe ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Opopo, Yova Kindeni iveta kie ara ndo pa naŋa. Andeta naŋa ma akatu i ne vetâŋa ŋinde mâsi mana. ");
INSERT INTO xsi_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ayo, naŋa ma awuwu waini lâ kâmba ilo, ku akai amâ alua Yova Kindeni itogo patarawâŋa mine. Vetâŋa ŋinde ma itula pwataki tu naŋa kawâŋgu ndaŋge ŋalae papa i ŋana ne pavilâŋa ara ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Aku lâ zo ŋana Yova Kindeni ne tamâta rârâni ma sipasau ŋana siwâŋgi pa i kâ, ande naŋa ma amo kunzi ku ma aveta ikura naneŋgu ŋgua pâŋa muŋgâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Mao nâ, Yova Kindeni ilo ndo keno panzi ne tamâta. Mine kala ambo toŋge ma imâte, ande i kalo sukâŋa ŋalae ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Yova Kindeni, naŋa amo noko ne wurâta tamâta. Naŋa uru aveta wurâta pano, itogo nana muŋga iveta mine. Noko kutiŋgi mateŋa piti kala iŋgeŋge ŋanana, kala ŋine naŋa amo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Mine nde naŋa ma aveta patarawâŋa pano ŋana itula pwataki tu naŋa kawâŋgu ndaŋge ŋalae pano. Aku naŋa ma ano pa noko tona. ");
INSERT INTO xsi_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Aku lâ zo ŋana Yova Kindeni ne tamâta rârâni ma sipasau ŋana siwâŋgi pa i kâ, ande naŋa ma amo kunzi ku ma aveta ikura naneŋgu ŋgua pâŋa muŋgâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Yova Kindeni, naŋa ma aveta mine lâ Jerusalem lawea ilo, lâ noko ne luma sapâŋa ne ŋgumbi ilo. Tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Miki tamâta lâ tinikoa ŋgu ndoni, miki rârâni kapanea Yova Kindeni kasuka i ŋa kâki! Miki tamâta kamo tâno ndoni, miki kawawa i! ");
INSERT INTO xsi_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Ŋana tu i ne tini-mwasa ikeno kaika pa kinda ku imo nâ. Ikura zo zo, ande iveta ikura i kawa ŋgua rârâni. Mine kala tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Kinda ma kawânda ndaŋge ilâ pa Yova Kindeni, ŋana tu i nde ara tamwata. I ne tini-mwasa ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Mine nde miki Isrel ŋgu tamâta, ara ŋana miki ma kaporo mine tu, “I ne tini-mwasa ikeno mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Aŋga miki Yova Kindeni ne patarawâŋa tamâta lâ Aron ne vâsa ŋgu, miki kala ma kaporo mine tu, “I ne tini-mwasa ikeno mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Aŋga miki tamâta ŋine uru kamege ŋana Yova Kindeni kâ, miki rârâni kala mine nâ ma kaporo tu, “I ne tini-mwasa ikeno mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ŋana tu muŋga, ande malia ŋalae itawa naŋa ndue lâ. Ŋineŋga naŋa ano pa Yova Kindeni, aku ipaloŋo pa naneŋgu noŋa kala izavaru malia ŋinde piti lâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Naŋa asama tu Yova Kindeni uru imo kuku naŋa. Mine kala naŋa ma aruru tia ndo, ŋana tu kinzi tamâta sikura ŋana siveta vetâŋa soki toŋge pa naŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Mao nâ, Yova Kindeni tamwata uru imo kuku naŋa ŋana ivilana. Mine kala naŋa ma amora i itawanzi naneŋgu kazâŋa tamâta ndue ku izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Ambo kinda kalonda tawana tu kinzi tamâta ma sivila kinda, ande ŋinde nde ara koŋa tia. Andeta kaloŋo ŋga; ambo kinda talâ pa Yova Kindeni tu ikea ŋana kinda kâ, ande ŋinde nde ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Ambo kinda kalonda tawana tu kinzi tamâta ŋalaŋala ma sivila kinda, ande ŋinde nde ara koŋa tia. Ambo kinda talâ pa Yova Kindeni tu ikea ŋana kinda kâ, ande ŋinde nde ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Naneŋgu kazâŋa tamâta rârâ nde siŋge naŋa mbwaliu lâ, andeta Yova Kindeni walo kaika ilua naŋa, kala azavarunzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Kinzi siŋge naŋa lâ, kala simo pa naoŋgu wa muliŋgu wa tiniŋgu pa wia kâ wa tiniŋgu pa ŋâsi kâ. Andeta Yova Kindeni walo kaika ilua naŋa, kala azavarunzi lâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Kinzi siŋge naŋa mbwaliu lâ, itogo wuli-wuli siveta mine. Andeta Yova Kindeni walo kaika ilana, kala azavarunzi lâ. Mao nâ, kinzi sipamateteu walele nâ, itogo yââ kana leu walele nâ ŋineŋga imâte pusii lâ mine. ");
INSERT INTO xsi_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Kinzi kazâŋa tamâta ŋinde sipara kaika ndo kuku naŋa, aku laiti ŋana sipole naŋa kâ. Andeta Yova Kindeni ivilana. ");
INSERT INTO xsi_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Mine kala naŋa apaimi tu Yova Kindeni tamwata uru walo kaika ilua naŋa. Ina tamwata imo naneŋgu Pavilâŋa Tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Miki kaloŋo ŋga! Yova Kindeni ne tamâta nde simo nenzi luma ilo ku sindeka wa sikai lolove wa. Kinzi sisarâwa mine tu, “Yova Kindeni Walo Tamwata ivila kinda kala tapole paraŋa lâ! ");
INSERT INTO xsi_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Mao nâ, Yova Kindeni ne walo kaika nde ŋalae ndo! Yova Kindeni Walo Tamwata ivila kinda kala tapole paraŋa lâ.” ");
INSERT INTO xsi_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Aku naŋa kala ŋandai amâte lâ paraŋa ilo ŋga. Naŋa ma amo viâŋgu, ku ma atu pâri ŋana Yova Kindeni ne vetâŋa ŋalaŋala ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yova Kindeni ipu naŋa pâta lâ, andeta i ŋandai isâu pa mateŋa tu ikai naŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Mine nde naŋa amandi Yova Kindeni ne luma sapâŋa nao amo ŋai. Miki kakai nzâla piti pana, ŋana naŋa ma ayoka alâ luma ilo ku ma kawâŋgu ndaŋge asuka i ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Yova Kindeni ne ŋgumbi nzâla kala ŋine. Tamâta ea simo ilonzi mbâra-mbâra lâ i nao, kinzi ŋinde nâ ma sikura tu silâ luma sapâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Yova Kindeni, noko kupaloŋo pa naneŋgu noŋa lâ, kala kumo naneŋgu Pavilâŋa Tamwata. Mine nde naŋa apanea noko ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Mira ŋine kinzi tamâta ŋana sipa luma kâ situ nde sakamao kala sitambira lâ, ande mirani ndaina ipâŋga mira ara ŋana isuka luma ŋgaŋe kaika kâ. ");
INSERT INTO xsi_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yova Kindeni tamwata iveta vetâŋa ŋinde ipâŋga lâ, kala kinda tamora ŋinde tu ara pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Kala kari ŋine kinda kalonda ŋgere ŋana Yova Kindeni ne vetâŋa ŋinde. Kinda ma tandeka ku ilonda ara nâ papa i. ");
INSERT INTO xsi_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Yova Kindeni, nema pavilâŋa tamwata noko, maka kano pano tu kuvilama! Kusukama ŋana nema vetâŋa rârâni ma ipâŋga kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Kala ŋine tamâta kala ikai Yova Kindeni ndamwa ŋinde nde ilâ luma sapâŋa ilo, aku Yova Kindeni itu nzâmbe pa koipu ŋalae ŋine ikai i ndamwa kala imâ. Maka kamo Yova Kindeni ne luma sapâŋa ilo ku kano pa i tu ma iveta kie ara pa miki. ");
INSERT INTO xsi_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Mao nâ, Yova Kindeni nde Maro Ŋalae, aku uru ikatona kinda sondo ndo. Mine nde miki kalâ kakai kâi launzi lâ mbaumi ilo, aku kao lae ku koka kalâ kakarerea patarawâŋa nia ku kapanea i. ");
INSERT INTO xsi_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","O Maro Kindeni, noko simbo nâ kumo naneŋgu Yova Kindeni, aku kawâŋgu ndaŋge imâ pano. Mao nâ, naneŋgu Maro Kindeni noko, aku naŋa ma aporo atula pwataki tu noko ŋa imo ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Miki ma kawami ndaŋge ilâ pa Yova Kindeni, ŋana tu i nde ara tamwata. I ne tini-mwasa ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Tamâta ea kinzi uru sipaveta kuku vetâŋa sondo nâ ku soka Yova Kindeni ne ŋgua tukuŋa muli, ande i ne nzâmbe ara ikeno panzi. ");
INSERT INTO xsi_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Ŋana tu kinzi ilonzi ndo tu sipono muli sondo pa Yova Kindeni kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Mao kanaŋo, kinzi tamâta ŋinde sipu mulinzi pa vetâŋa sakamao rârâni. Kinzi uru siveta ikura Yova Kindeni nâ ne pateâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Yova Kindeni, nanayoni noko kutula ŋgua tukuŋa rârâni pama, aku kutu ŋgua kaika pama tu maka ma kapakatona sondo ŋana kapono muli sondo nâ pa ŋgua tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Mine nde naŋa iloŋgu tu aveta ikura noko ne pateâŋa mine ikura zo rârâni! ");
INSERT INTO xsi_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Naŋa asama tu ambo naŋa ma kaloŋgu ŋgere sondo ŋana noko ne tukuŋa rârâni, ande naŋa ma maiŋgu lâ tamâta naonzi tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Naŋa ma apanâna ŋana noko ne pateâŋa sondo rârâni. Ŋineŋga naŋa ma apanea noko ŋa asuka kâki tava iloŋgu mbâra-mbâra ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Naŋa ma apono muli pa noko ne ŋgua tukuŋa rârâni. Mine kala noko ma kupu muli ndo pa naŋa ndimo! ");
INSERT INTO xsi_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Ambo tamâta limoa itu ipakatona tamwata ne vetâŋa ŋana imo mbâra-mbâra lâ noko nao, ande i ma ipaveta kuku noko ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Yova Kindeni, naŋa ŋandai iloŋgu rua-rua ŋga. Naŋa iloŋgu ndo tu apono muli pa noko. Mine nde ano pano tu pwai poe sondo pana, aku kupono nzalâŋgu ŋana naŋa ma akura tu apu muliŋgu pa noko ne tukuŋa tia kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Naŋa tiniŋgu pwâka tu ma aveta kiesaka toŋge pa noko. Mine kala naŋa ao noko kawa ŋgua ikeno kaika lâ iloŋgu kaloŋgu marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yova Kindeni, naŋa apanea noko ŋa asuka kâki. Naŋa ano pano tu kupananana ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ambo noko ma kupananana, ande naŋa ma aporo atula tukuŋa rârâni muŋga kulama ŋinde pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Mao nâ, naŋa iloŋgu ndeka ndo ŋana apono muli pa noko kawa ŋgua, aku ŋinde ipole naneŋgu ndekâŋa ŋana naneŋgu mbaliŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Naŋa uru kaloŋgu ŋgere ŋana vetâŋa rârâni noko ilo tu naŋa ma aveta ŋinde, aku matâŋgu alea sondo pa noko ne ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Naŋa tiniŋgu mwasa ndo pa noko ne pateâŋa. Naŋa ma kaloŋgu kapa ŋana noko ne ŋgua ŋinde kâ, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Yova Kindeni, naŋa ano pano tu kuveta kie ara pa ne wurâta tamâta naŋa. Ambo noko ma kuveta mine, ande naŋa ma amo viâŋgu nâ ku ma apono muli pa noko ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Pwai iloŋgu kaloŋgu ne nzâla piti, ŋana naŋa ma asama sondo ŋana ŋgua arara rârâni ikeno noko ne ŋgua tukuŋa tini. ");
INSERT INTO xsi_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Naŋa nde tamâta nâ, kala akura tu amo zo luandondo lâ tâno ŋine kulu, ande tia. Mine nde noko ma kuvea ne ŋgua tukuŋa ŋanana ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Ikura kari wa mbo wa, ande naŋa iloŋgu ndo tu apono muli pa noko ne pateâŋa, aku ŋinde ipâŋga itogo yââ mela-mela mine lâ iloŋgu kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Naŋa asama tu noko uru pwai kazâŋa panzi tamâta ea sipasuka warakanzi tininzi, aku noko ma kuzavarunzi tamâta ea silaŋa sipole noko ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Aŋga naŋa apono muli pa noko kawa ŋgua, aku ŋana duvi ŋinde kâ kinzi kazâŋa tamâta siporo ŋgua pavaligiŋa pana wa siŋeleana wa. Naŋa ano pano tu kupono nzalanzi, ŋana ma sikura tu siveta mine kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Aku kinzi tamâta ŋalaŋala sipasau ku siporo sipa ŋgua ŋana siyaula naŋa kâ. Andeta kalo loko, naŋa nde noko ne wurâta tamâta, aku ma kaloŋgu ŋgere sondo ŋana noko ne ŋgua tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Ŋana tu naŋa iloŋgu ndeka nâ ŋana noko kawa ŋgua kâ. Noko ne ŋgua ŋinde uru ipananana ku ikai poe pana. ");
INSERT INTO xsi_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Yova Kindeni, naneŋgu kazâŋa tamâta situ sitawa naŋa ndue ndo lâ, kala laiti ŋana amâte kâ. Naŋa ano pano tu kuvilana ku kupu tini kaika pana, itogo muŋga noko kupambwâre tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Muŋgani, lâ zo ŋinde naŋa apatula naneŋgu vetâŋa rârâni pwataki pano, ande noko kuporo ŋgua taulo imâ pa naŋa lâ. Kala ŋine ano pano tu kupananana ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Ambo noko ma kupananana ŋana noko kawa ŋgua duvi kâ, ande naŋa ma kaloŋgu ŋgere sondo ŋana noko ne vetâŋa arara rârâni kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Naŋa kaloŋgu sukâŋa ŋalae tina, kala iloŋgu malia ndo. Mine nde ano pano tu kupu tini kaika pana, itogo muŋga kuporo tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Ambo noko ma pwai poe sondo pa naŋa, ande naŋa ma akura tu aŋgeŋge ŋana noko ne nzâla ara ŋinde kâ, ande tia. Mine nde kuveta kie ara pana, ku kupananana ŋana ne ŋgua tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Naŋa iloŋgu patea tu ma apono muli sondo pa noko. Naŋa uru kaloŋgu ŋgere ŋana noko ne tukuŋa kâ ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Yova Kindeni, naŋa uru apaveta sondo ndo kuku noko kawa ŋgua. Mine kala noko ma kupilena ku kusâu panzi naneŋgu kazâŋa tamâta tu siveta maŋeti pana, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Naŋa asama tu noko ma ilo-kalo ŋalae kulua naŋa. Mine nde naŋa ma andeka nâ ŋana ayoka noko ne ŋgua tukuŋa muli. ");
INSERT INTO xsi_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Yova Kindeni, ambo noko ma kupanana naŋa sondo ŋana ne ŋgua tukuŋa duvi kâ, ande naŋa ma apono muli papa ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Kutula ne ŋgua tukuŋa kie ipâŋga nia yo pa naŋa, ŋana naŋa ma apaveta sondo kuku. Ŋineŋga naŋa ma iloŋgu ara ndo ŋana apono muli pa noko ne ŋgua tukuŋa ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Naŋa iloŋgu ndeka ndo ŋana noko ne tukuŋa kâ. Mine nde ano pano tu pwai poe sondo pana, ŋana naŋa ma apono muli sondo pa noko ne tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Kupaŋo naŋa iloŋgu kaloŋgu, ŋana naŋa ma tiniŋgu mwasa nâ ŋana apaveta kuku noko kawa ŋgua. Tia ma wisiŋgu kâki ŋana agona tâno ŋine ne mbaliŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Yova Kindeni, kusukana ŋana apu muliŋgu pa kelekele kaa kaa rârâni kâ. Naŋa ano pano tu kuveta kie ara pana, itogo muŋga kupambwâre tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Noko uru kuveta ŋgua pâŋa kunzi tamâta ea simege ŋanano. Mine kala naŋa ano pano tu kupono muli pa ne ŋgua pâŋa ŋinde, aku kuvila ne wurâta tamâta naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Naŋa aruru ŋana ŋgua sakamao ŋinde naneŋgu kazâŋa tamâta uru siporo pa naŋa. Mine nde kuvilana! Noko ne tukuŋa rârâni nde arara nâ, ");
INSERT INTO xsi_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","aku naŋa atu apono muli sondo papa. Noko nde vetâŋa sondo warika. Mine nde ano pano tu via wasaseki kulana. ");
INSERT INTO xsi_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Yova Kindeni, naŋa ano pano tu pwai naŋa piti lâ kazâŋa ilo, ikura muŋga kupa ŋgua tu ma kuveta mine. Ambo noko ma kuveta mine, ande ŋinde ma itula pwataki tu noko tini mwasa ndo pa naŋa ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Ambo noko ma kuvila naŋa mine, ande naŋa ma akura tu aporo ŋgua taulo kilo panzi tamâta ŋinde uru siporo ŋgua sakamao pana, ŋana tu naŋa kaloŋgu tawana noko ne ŋgua pâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Mao nâ, naŋa kaloŋgu tawana noko ne ŋgua rârâni. Mine kala ano pano tu kupu tini kaika pana, ŋana naŋa ma akura tu atula noko ne ŋgua mao pwataki ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ikura zo zo, naŋa ma apaveta sondo kuku noko ne tukuŋa rârâni, ma aveta mine ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Naŋa uru apatogo ŋana ayoka noko kawa ŋgua rârâni muli. Mine nde naneŋgu kazâŋa tamâta ma sikura tu sipole naŋa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Naŋa ma atula noko kawa ŋgua pwataki panzi koipu ŋalaŋala, aku naŋa ma akai maŋeti ŋana aveta mine kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Yova Kindeni, naŋa iloŋgu ndo ikeno pa noko ne ŋgua tukuŋa. Mine nde iloŋgu ndeka nâ ŋana apono muli papa. ");
INSERT INTO xsi_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Naŋa amege ŋana noko ne ŋgua tukuŋa kâ, aku tiniŋgu mwasa ndo papa. Naŋa ma kaloŋgu ŋgere sondo nâ ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Yova Kindeni, naŋa ano pano tu kalo ŋgere kilo ŋana ŋgua pâŋa ŋinde noko muŋga kuveta kuku ne wurâta tamâta naŋa. Naŋa ao tiniŋgu pano tu ma kuveta ŋgua pâŋa ŋinde ipâŋga kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Lâ zo ŋana naŋa asânda malia kulu, ande naŋa wisiŋgu pisi nâ, ŋana tu noko ne ŋgua pâŋa ivilana ŋana amo viâŋgu kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Noko kusama tu tamâta pinde uru sipasuka warakanzi tininzi, aku kinzi ŋinde siporo ŋgua pavaligiŋa pa naŋa. Andeta naŋa ŋandai apu muliŋgu pa noko ne tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Yova Kindeni, lâ zo ndia naŋa kaloŋgu ŋgere ŋana noko ne ŋgua tukuŋa siŋga ŋinde, ande ŋgua ŋinde uru ipu tini kaika pa iloŋgu kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Aŋga lâ zo ndia amoranzi tamâta sakamao sipu noko ne ŋgua tukuŋa ŋinde ututu, ande naŋa wisiŋgu nâna ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Naŋa asama tu naŋa ma amo viâŋgu lâ tâno ŋine kulu ikura zo luandondo tia. Andeta naŋa ma asia wâŋgiŋa kaŋa-kaŋa ŋana noko ne ŋgua tukuŋa kâ, ikura zo rârâni naŋa ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Yova Kindeni, ikura mbo mbo naŋa kaloŋgu ŋgere ŋanano, aku uru kaloŋgu ŋgere ŋana noko ne tukuŋa tona. ");
INSERT INTO xsi_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Naŋa uru apaveta kuku noko kawa ŋgua rârâni, aku ŋinde iveta naŋa wisiŋgu ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Yova Kindeni, naŋa iloŋgu pa sâ toŋge tia. Naŋa iloŋgu pa noko simbo nâ, kala ŋine apambwâre tu ma apono muli pa noko kawa ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Mine nde naŋa ano kaika pano tu kuo ne wisi-wisi imâ pana, itogo muŋga noko kupa ŋgua tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Naŋa kaloŋgu ŋgere ŋana naneŋgu vetâŋa kâ, kala ŋine naŋa apalele iloŋgu kaloŋgu ku apa ŋgua tu ma ayoka noko ne ŋgua muli kilo. ");
INSERT INTO xsi_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Naŋa ma amo soŋgo, ande tia. Naŋa ma walele nâ apono muli pa noko ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Kinzi tamâta sakamao sio nimbu ŋana sikai naŋa kaika kâ, andeta naŋa kaloŋgu kapa ŋana noko ne tukuŋa kâ tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Lâ mbo ŋgini-ŋgini tamwata, ande naŋa uru amandi sânda ku apaneano, ŋana tu noko ne pateâŋa rârâni nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Aku tamâta ea kinzi uru simege ŋanano wa sipono muli pa noko ne ŋgua tukuŋa wa, ande naŋa amo kinzi tamâta ŋinde rârâni ninzi-nambwe. ");
INSERT INTO xsi_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Yova Kindeni, ikura zo zo noko tini mwasa ndo panzi tamâta rârâni simo tâno ndoni. Mine kala naŋa ano pano tu kupananana ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Yova Kindeni, muŋga noko kuveta kie ara ndo pa ne wurâta tamâta naŋa, ikura noko ne ŋgua pâŋa muŋgâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Aku naŋa kaloŋgu tawana noko ne tukuŋa rârâni. Mine nde ano pano tu ilo-kalo ara kulana, ŋana naŋa ma akura tu apatea kelekele sondo kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Nanayoni naŋa apaveta kuku vetâŋa soki-soki nâ. Andeta muli ŋga noko kupare nia sondo pa naŋa, kala ŋine naŋa uru apono muli pa noko ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Noko nde wisi-wisi warika ku ara tamwata. Mine nde ano pano tu kupananana ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Kinzi taŋa-kaika tamwatanzi situ naŋa laginâŋgu. Andeta naŋa iloŋgu rua-rua tia ndo; naŋa iloŋgu ndo tu apaveta kuku noko kawa ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Kinzi tamâta ŋinde nenzi ilo-kalo tia ndo, aŋga naŋa nde iloŋgu ndeka nâ ŋana noko ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Noko kupare nia pa naŋa lâ, aku ŋinde nde ara ndo, ŋana tu ŋinde ipanana naŋa sondo ŋana noko ne pateâŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Naneŋgu morâŋa nde mine; tâno ŋine ne mbaliŋa rârâni nde kelekele ara koŋa tia, aŋga noko tamwata ne tukuŋa nde kelekele ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Yova Kindeni, nanayoni noko tamwata kupulia naŋa apâŋga lâ, aku nokoni uru pwea ŋanana. Naŋa ano pano tu kutula ilo-kalo ara pana, ŋana naŋa ma apanâna sondo ŋana noko ne ŋgua tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Naŋa kaloŋgu tawana noko ne ŋgua pâŋa. Mine kala lâ zo ŋana kinzi tamâta uru simege ŋanano ŋinde ma simora naŋa, ande kinzi ma sindeka. ");
INSERT INTO xsi_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Yova Kindeni, naŋa asama tu noko ne pateâŋa rârâni nde sondo ndo. Noko uru kuveta ikura ne ŋgua pâŋa rârâni, aku ŋana duvi ŋinde kâ noko kupare nia pa naŋa lâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Taitu kala ŋine ano pano tu kuo ne tini-mwasa ara ŋinde imâ pa ne wurâta tamâta naŋa ŋana ipu tini kaika pana, ikura muŋga noko kupambwâre tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Naŋa iloŋgu ndeka nâ ŋana noko ne tukuŋa kâ. Mine nde kalo sukâŋa ŋanana, aku kusâu pana tu ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Kinzi taŋa-kaika tamwatanzi sisowe ŋgua laŋeŋa rârâ lâ tiniŋgu. Naŋa iloŋgu tu noko ma kuveta maŋeti panzi ŋana nenzi vetâŋa ŋinde kâ. Aŋga naŋa nde ma kaloŋgu ŋgere sondo ndo ŋana noko kawa ŋgua kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Tamâta ea kinzi uru simege ŋanano ku sisama noko ne ŋgua tukuŋa, ande naŋa iloŋgu tu kinzi ŋinde ma simâ pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ambo noko ma kusukana ŋana apono muli sondo nâ pa noko ne tukuŋa rârâni, ande naŋa ma akai maŋeti lâ naneŋgu kazâŋa tamâta naonzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Yova Kindeni, naŋa ao tiniŋgu pano tu ma pwaina piti lâ kazâŋa ilo lee, kala iloŋgu malia ndo, aku naneŋgu walo nde marumbu lâ. Taitu naŋa kaloŋgu tawana noko ne ŋgua pâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Naŋa amo ao matâŋgu tu ma amora noko kuveta ikura ne ŋgua pâŋa muŋgâŋa mine. Ao matâŋgu mine lee, matâŋgu sakamao lâ. Aku naŋa akasoŋano tu, “Noko ma kuveta iloŋgu kaloŋgu pisi kilo lâ zo ndia.” ");
INSERT INTO xsi_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Kumora ŋga, naŋa apâŋga atogo kelekele kaa nâ mine. Naŋa amo atogo lââ patu siŋga muŋga kinzi siwuwu lââ lâ ilo, andeta lulu iyaula kala sitambira lâ. Andeta naŋa ŋandai kaloŋgu kapa ŋana noko ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Mine kala naŋa atu asama ŋine; naŋa ma ao tiniŋgu mine ikura zo ŋapia kilo, a? Kinzi tamâta ŋinde siveta kenzi sakamao pa naŋa. Aŋga noko ma kupare nia panzi lâ zo ndia, a? ");
INSERT INTO xsi_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Kinzi uru sipasuka warakanzi tininzi, aku sipu mulinzi pa noko ne tukuŋa. Kinzi sisale tâno wewe ku situ naŋa ma patana andue ilo, ku ma sikaina kaika. ");
INSERT INTO xsi_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Noko ne tukuŋa rârâni nde mao kanaŋo, ma ikeno mine ku imo nâ. Aŋga naneŋgu kazâŋa tamâta ŋinde kawanzi laŋeŋa nâ, siveta kenzi sakamao pa naŋa. Mine nde naŋa ano pano tu kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Laiti ŋana sipu naŋa pâta amâte kâ. Taitu naŋa ŋandai kaloŋgu kapa ŋana noko ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Yova Kindeni, noko ne tini-mwasa ikeno pa naŋa ku imo nâ. Mine kala ano pano tu pwaina piti lâ kazâŋa ilo. Ambo noko ma kuveta mine, ande naŋa ma akura tu apono muli pa noko kawa ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Yova Kindeni, noko kawa ŋgua ma imo mine ku imo nâ. Ŋinde ikeno kaika lâ samba ilo. ");
INSERT INTO xsi_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","91","Mao nâ, noko kupono muli pa tamwata kawa ŋgua ikura zo zo, ma kuveta mine ku kumo nâ. Noko kawa ŋgua ŋinde ipulia tâno ipâŋga lâ, aku kuo ikeno kaika lâ ne nia sondo lee ikura lâ zo ŋine. Ŋana tu kelekele rârâni uru sipono muli pa noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Aku naŋa kala aveta mine nâ. Ambo naŋa iloŋgu ndeka ŋana noko ne ŋgua tukuŋa tia, ande nanayoni, nâna noko kulana ŋine ma ipu naŋa pâta amâte lâ. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Noko kawa ŋgua uru ivila naŋa kala amo viâŋgu nâ. Mine kala naŋa ma tiniŋgu pwâka ŋana apaloŋo pa noko kawa ŋgua ŋinde, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Yova Kindeni, naŋa nde noko tamwata simbo nâ ne tamâta. Mine nde kuvilana ŋga! Noko kusama tu naŋa apatogo ŋana apono muli sondo nâ pa noko ne ŋgua ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Kinzi tamâta sakamao sipavea lâ ku sio ŋanana tu ma sizavaru naŋa kâ. Taitu naŋa ma kaloŋgu ŋgere ŋana noko ne tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Naŋa asama tu noko kuo keri panzi kelekele rârâni, kala ma muli naonzi tia lâ. Andeta sâ toŋge ikura tu ipono noko ne ŋgua tukuŋa nao, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Opopo, naŋa iloŋgu ndo ikeno pa noko ne ŋgua tukuŋa! Yova Kindeni, ikura kari wa mbo wa, ande naŋa uru kaloŋgu ŋgere ŋana tukuŋa ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Noko ne ŋgua tukuŋa nde imo ku naŋa ku ipananana ikura zo zo. Mine kala naneŋgu ilo-kalo ipâŋga ŋalae lâ, aku ipole naneŋgu kazâŋa tamâta nenzi ilo-kalo ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ikura zo zo naŋa uru kaloŋgu ŋgere sondo ŋana noko kawa ŋgua kâ. Mine kala naŋa asama kelekele kie-kie duvi, aku naneŋgu ilo-kalo ara ŋine ipole naneŋgu pananâŋa tamâta nenzi ilo-kalo. ");
INSERT INTO xsi_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Kinzi tamâta kokoŋa nenzi ilo-kalo nde ŋalae, andeta naneŋgu ilo-kalo nde ipolenzi, ŋana tu naŋa uru apaveta kuku noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Mao nâ, naŋa iloŋgu tu ayoka noko ne ŋgua muli nâ. Mine nde naŋa uru apu muliŋgu pa vetâŋa potomule rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Aku Yova Kindeni, noko tamwata uru kupanana naŋa ŋana ne pateâŋa kâ. Mine kala naŋa ŋandai kaloŋgu kapa ŋana ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Sipa siŋi nde kaŋa mona-mona nâ, andeta noko kawa ŋgua nde mona-mona ndo, ipole sipa siŋi kaŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Noko ne tukuŋa ŋinde uru ilo-kalo ara nâ ilua naŋa. Mine nde naŋa tiniŋgu pwâka ndo ŋana mâsi sakamao ndoni. ");
INSERT INTO xsi_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Yova Kindeni, noko kawa ŋgua nde itogo sinâla mine ŋana ikai poe pa naneŋgu yokâŋa kâ. Sinâla ŋinde uru isinala naneŋgu nzâla rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Mine nde naŋa apa ŋgua kaika lâ tu naŋa ma apono muli mao pa noko ne tukuŋa sondo ŋinde rârâni, aku ma aveta ikura naneŋgu ŋgua pâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Andeta Yova Kindeni, kumora ŋga! Naneŋgu kazâŋa tamâta siveta kenzi sakamao ndo pa naŋa. Ambo noko ma pwea ŋanana, ikura muŋga noko kupa ŋgua tu ma kuveta mine, ande naŋa ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yova Kindeni, naŋa kawâŋgu ndaŋge imâ pano itogo naneŋgu patarawâŋa mwasina. Noko ma kupu muli pa naneŋgu ŋgua ŋine ndimo. Kupananana sondo ŋana noko ne tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Kumora ŋga; ikura zo rârâni mateŋa imâ ipâŋga naŋa tiniŋgu laiti, andeta naŋa ŋandai kaloŋgu kapa ŋana noko ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Mao nâ, kinzi tamâta sakamao sio nenzi nimbu ŋana silita naŋa kaika kâ, andeta naŋa ŋandai apu muliŋgu pa noko kawa ŋgua ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Noko kawa ŋgua nde itogo wisi-ara noko kulua naŋa mine, aku ŋinde ma ikeno kuku naŋa ikura zo zo. Ŋgua ŋinde uru iveta iloŋgu kaloŋgu ndeka ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Mine kala naŋa iloŋgu patea tu naŋa ma ayoka noko ne tukuŋa rârâni muli nâ, ikura zo rârâni naŋa ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Yova Kindeni, tamâta pinde kawanzi nâ siporo tu kinzi uru sipono muli pa noko, andeta nenzi ŋgua ŋinde nde laŋeŋa nâ. Naŋa tiniŋgu pwâka ndo ŋananzi tamâta ŋinde, andeta tiniŋgu mwasa ndo pa noko ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Noko tamwata nâ kumo kutogo naneŋgu munâŋa nia wa naneŋgu maramuŋa wa. Naŋa kaloŋgu tawana noko ne ŋgua pâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Miki kiesaka tamwatami, miki kapile naŋa ku kakâwa kalâ! Naŋa atu apono muli pa naneŋgu Maro Kindeni ne tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Yova Kindeni, noko kupambwâre tu ma walo kaika kulua naŋa, aku naŋa kaloŋgu tawana ne ŋgua pâŋa ŋinde. Kala ŋine naŋa ano pano tu kaika ŋinde kulana, ŋana naŋa ma amo viâŋgu kâ. Tia ma naneŋgu kalo-tawana ŋine ilâ kaa nâ, ne kanaŋo tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Andeta naŋa asama tu ambo noko ma kusaŋa mbauŋgu kaika, ande naŋa ma amo ara nâ, ku ma apaveta kuku noko kawa ŋgua ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Noko uru kupu muli panzi tamâta ea silaŋa sipole noko ne ŋgua tukuŋa. Nenzi ilo-kalo laŋeŋa ŋinde ma kanaŋo tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Mao nâ, kinzi tamâta sakamao rârâni nde simo sitogo kina mine lâ noko nao. Mine kala naŋa tiniŋgu mwasa ndo pa noko ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Yova Kindeni, naŋa aruru pâta ŋanano. Naŋa kaloŋgu ŋgere ŋana noko ne ŋgua tukuŋa, kala tiniŋgu ruru nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Yova Kindeni, naŋa uru apaveta kuku vetâŋa ara ku vetâŋa sondo nâ. Mine nde noko ma kusâu panzi naneŋgu kazâŋa tamâta tu siveta soki pa naŋa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Naŋa iloŋgu tu noko ma kupambwâre ŋana kuvila ne wurâta tamâta naŋa. Noko ma kusâu panzi tamâta uru sipasuka warakanzi tininzi ŋinde tu siveta kenzi sakamao pa naŋa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Naŋa ao matâŋgu tu ma amora noko kumâ ŋana pwaina piti lâ kinzi tamâta sakamao mbaunzi ilo, ikura muŋga noko kupa ŋgua tu ma kuveta mine. Naŋa ao matâŋgu mine lee, matâŋgu sakamao lâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Yova Kindeni, noko ne tini-mwasa ikeno mine ku imo nâ. Kala ŋine ano pano tu kuo ne tini-mwasa ŋinde imâ pa ne wurâta tamâta naŋa mine nâ. Aku naŋa kala ano pano tu kupananana sondo ŋana noko ne pateâŋa kâ tona. ");
INSERT INTO xsi_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Mao nâ, naŋa amo noko ne wurâta tamâta. Mine nde ano pano tu kutula ilo-kalo ara pana, ŋana naŋa ma asama noko kawa ŋgua ne duvi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Yova Kindeni, kinzi tamâta silaŋa sipole noko ne ŋgua tukuŋa. Mine kala ŋine nâ kumandi ku kuveta nâna panzi! ");
INSERT INTO xsi_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Ŋana tu naŋa iloŋgu ŋalae koŋa pa mira “gol” nde tia, taitu naŋa iloŋgu ndo keno pa noko ne ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Mine kala naŋa uru ayoka noko kawa ŋgua rârâni muli. Aku naŋa tiniŋgu pwâka ndo ŋana mâsi sakamao rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Yova Kindeni, noko ne ŋgua nde ara pâta kanaŋo. Mine kala naŋa uru apaveta sondo kuku. ");
INSERT INTO xsi_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Lâ zo ŋana noko kutula ne ŋgua duvi pwataki panzi tamâta, ande ŋgua ŋinde imo itogo sinâla mine panzi. Mao nâ, noko kawa ŋgua uru itula ilo-kalo ara panzi tamâta ŋinde nenzi ilo-kalo ŋalae koŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Opopo, naŋa tiniŋgu mwasa ndo pa noko ne tukuŋa, aku iloŋgu gagatina ndo ŋana apono muli papa! ");
INSERT INTO xsi_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Mine kala naŋa ano pano tu kuwara nao pana ku kalo sukâŋa ŋanana, itogo uru kuveta panzi tamâta rârâni ŋine tininzi mwasa nâ pano. ");
INSERT INTO xsi_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Pwai poe sondo nâ pana, ikura muŋga noko kupa ŋgua tu ma kuveta mine. Noko ma kusâu panzi kiesaka tamwatanzi tu ma sipole naŋa, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Pwaina piti lâ kinzi tamâta uru siveta kenzi sakamao pa naŋa ŋinde mbaunzi ilo, ŋana naŋa ma akura tu apono muli pa noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","O Yova Kindeni, kuveta kie ara pa ne wurâta tamâta naŋa, aku kumo kuna kupananana ŋana noko ne pateâŋa rârâni kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Noko ne ŋgua tukuŋa nde ara ndo, taitu tamâta rârâ tininzi pwâka ŋana. Mine kala naŋa ata pâta, kala matâŋgu sulu irere ndue itogo lââ mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Yova Kindeni, noko nde vetâŋa sondo warika, aku ne pateâŋa rârâni nde ara ku sondo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Ŋgua tukuŋa rârâni kala kupatea pama ŋinde nde sondo ndo, ma ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Andeta naneŋgu kazâŋa tamâta tininzi pwâka ŋana noko ne tukuŋa kâ. Mine nde naŋa wisiŋgu nâna ndo, itogo yââ mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Ŋana tu noko ne ŋgua pâŋa kilala ipâŋga nia yo tu ŋinde nde ŋgua mao kanaŋo, aku noko ne wurâta tamâta naŋa tiniŋgu mwasa ndo papa. ");
INSERT INTO xsi_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Naŋa nde tamâta kaa nâ, aku kinzi tamâta uru siporo situ naŋa laginâŋgu. Taitu naŋa ŋandai kaloŋgu kapa ŋana noko ne ŋgua ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Ŋana tu noko ne vetâŋa rârâni nde ara nâ, ma ikeno mine ku imo nâ, aku ne tukuŋa rârâni nde mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Kalo-lokoni tava malia kie-kie nde uru ipâŋga pa naŋa, andeta iloŋgu ndeka nâ ŋana noko ne ŋgua tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Yova Kindeni, noko kawa ŋgua nde sondo ndo, ma ikeno mine ku imo nâ. Ambo noko ma kutula ilo-kalo ara pa naŋa, ande naŋa ma apono muli papa ku ma akura tu amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Yova Kindeni, naŋa iloŋgu kaloŋgu ndoni asarâwa kaika pa noko. Kupaloŋo pa naneŋgu noŋa, aku naŋa ma aveta ikura noko ne pateâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Kala ŋine naŋa asarâwa pano. Kuvila naŋa, aku naŋa ma apono muli pa noko ne tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","148","Ikura mbo mbo, naŋa ŋandai akeno ŋga. Naŋa matâŋgu pareŋge nâ ku kaloŋgu ŋgere ŋana noko ne ŋgua pambwareŋa kâ. Mbwale pwataki tia yo, ande naŋa amandi sânda ku ano pano tu kusukana. Naŋa kaloŋgu tawana noko ne ŋgua pâŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Yova Kindeni, noko ne tini-mwasa ikeno pa naŋa mine ku imo nâ. Mine kala kupaloŋo pa naneŋgu noŋa! Noko nde vetâŋa sondo warika. Mine nde pwea ŋanana lâ naneŋgu kazâŋa tamâta naonzi, ŋana ma amo viâŋgu kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Ŋana tu kinzi tamâta sakamao situ siyaula naŋa, aku kinzi ŋinde simâ sipâŋga laiti lâ. Kinzi tininzi pwâka ndo ŋana noko ne tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Andeta Yova Kindeni, nokoni uru kumo naŋa tiniŋgu laiti, aku asama tu noko ne tukuŋa rârâni nde mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Siŋgani naŋa apanâna ŋana noko kawa ŋgua kâ, aku asama mine; noko kupatea tu ŋgua ŋinde ma ikeno kaika mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Yova Kindeni, kumora ŋga; naneŋgu kazâŋa tamâta siveta kenzi sakamao ndo pa naŋa. Naŋa ano pano tu pwaina piti lâ kazâŋa ilo, ŋana tu naŋa ŋandai kaloŋgu kapa ŋana noko ne tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Kusuka naneŋgu ŋgua lâ ŋgua nia, aku kuyaute naŋa piti! Pwea ŋanana, ikura muŋga noko kupa ŋgua tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Kinzi tamâta sakamao tininzi pwâka tu soka noko ne tukuŋa muli. Mine kala noko ma kuvilanzi ku pwainzi piti lâ kazâŋa ilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Yova Kindeni, noko ne kalo-sukâŋa nde ŋalae tina, aku noko nde vetâŋa sondo warika. Mine nde pwea ŋanana lâ naneŋgu kazâŋa tamâta naonzi, ŋana ma amo viâŋgu kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Tamâta rârâ sikai kazâŋa pa naŋa kala situ siveta kenzi sakamao pana. Andeta naŋa apu muliŋgu pa noko ne ŋgua mao ŋinde tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Lâ zo ndia naŋa amoranzi tamâta ŋinde kala muŋga sipu mulinzi pa noko, ande naŋa wisiŋgu nâna ndo ŋananzi, ŋana tu kinzi silaŋa sipole noko ne tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Yova Kindeni, kumora ŋga! Naŋa iloŋgu ndo ikeno pa noko ne ŋgua. Noko ne tini-mwasa ikeno mine ku imo nâ; mine nde pwea ŋanana, aku naŋa ma amo viâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Noko kawa ŋgua kilala ipâŋga nia yo tu ŋinde nde mao kanaŋo. Aku noko ne ŋgua tukuŋa rârâni nde sondo ndo, ma ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Yova Kindeni, kinzi tamâta ŋalaŋala nde siveta kenzi sakamao koa tia nâ pa naŋa. Taitu naŋa amege ndo ŋana noko kawa ŋgua nâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Naŋa iloŋgu ndeka pâta kanaŋo ŋana noko ne ŋgua pâŋa kâ, itogo tamâta indeka ŋana ikai mbaliŋa arara kie-kie mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Naŋa tiniŋgu pwâka ndo ŋana vetâŋa laŋeŋa rârâni kâ. Aŋga noko ne ŋgua tukuŋa, ande naŋa tiniŋgu mwasa ndo papa. ");
INSERT INTO xsi_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Ikura kari kari, ande naŋa uru kawâŋgu ndaŋge pano mbwaniŋgu rârâ, ŋana tu noko ne pateâŋa rârâni nde sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Mao nâ, tamâta ea ilonzi ndo keno pa noko ne tukuŋa, ande kinzi ŋinde rârâni uru simo ara ndo, aku malia toŋge ikura ŋana itawanzi ndue kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Mine nde Yova Kindeni, naŋa ao tiniŋgu nâ ŋanano tu ma pwaina piti lâ kazâŋa ilo, aku naŋa uru aveta ikura noko ne pateâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Naŋa uru ayoka noko kawa ŋgua rârâni muli. Naŋa tiniŋgu mwasa ndo papa ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Naneŋgu vetâŋa rârâni nde ikeno nia yo lâ noko nao. Mine kala noko kusama tu naŋa apono muli pa noko ne ŋgua wa tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Yova Kindeni, naŋa asarâwa pano tu kuvilana. Kutambira taŋa pa naŋa, aku kutula ilo-kalo ara pana, itogo muŋga noko kupa ŋgua tu ma kuveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Kupaloŋo pa naneŋgu noŋa ku pwaina piti lâ kazâŋa ilo, ikura ne ŋgua pambwareŋa muŋgâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Noko uru kupanana naŋa sondo ŋana ne pateâŋa rârâni kâ. Mine nde naŋa ma apanea noko ŋa asuka kâki ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Mao nâ, naŋa ma awâŋgi wâŋgiŋa ŋana noko kawa ŋgua ŋinde kâ, ŋana tu noko ne tukuŋa rârâni nde ara ku sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Naŋa iloŋgu patea tu ma apono muli pa noko kawa ŋgua. Mine kala ano pano tu kuluku ŋana kuvila naŋa ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Yova Kindeni, naŋa iloŋgu ndo tu noko ma kuvilana ku pwaina piti lâ kazâŋa ilo. Aku iloŋgu ndeka nâ ŋana noko ne ŋgua tukuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Ambo noko ma pwatona naneŋgu via, ande naŋa ma apanea noko ŋa asuka kâki. Naŋa iloŋgu tu noko ne ŋgua ma ikai poe sondo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Naŋa aŋgeŋge ŋana nzâla ara kâ, itogo lama isapiri kala izizâla ŋana nia kâ. Naŋa ano pano tu kumâ kuroto ŋana ne wurâta tamâta naŋa, ŋana tu naŋa ŋandai kaloŋgu kapa ŋana noko ne ŋgua tukuŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Lâ zo ndia malia itu imâ ipâŋga pa naŋa, ande naŋa asarâwa pa Yova Kindeni, aku ipaloŋo pa naneŋgu noŋa. ");
INSERT INTO xsi_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Naŋa akai noŋa mine tu, “Yova Kindeni, kinzi laŋeŋa tamwatanzi situ sizavaru naŋa. Kuvilana ŋga!” ");
INSERT INTO xsi_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Aŋga miki laŋeŋa tamwatami, miki kaloŋo ŋga; Yova Kindeni ma iveta mâsi kaika pami, ku ma ipare nia sondo ndo pami. ");
INSERT INTO xsi_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","I ma silâwa nâ ipanemi, aku ma iliŋi yââ lâ tinimi. ");
INSERT INTO xsi_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Opopo, naŋa amo miki tamâta sakamao ŋginimi kala amo sakamao ndo. Ŋinde nde kie taituni itogo naŋa amo kunzi tamâta ŋgoi simo Mesek tâno wa Kedar tâno wa. ");
INSERT INTO xsi_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Oyae, naŋa amo zo luandondo koŋa kunzi tamâta ŋine uru ilonzi pa paraŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Lâ zo ndia naŋa aporo ŋgua panzi ŋana kamo tava iloma pisi, ande kinzi situ sipara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Naŋa matâŋgu kâki alea pa nia tuu, aroto ŋana naneŋgu pavilâŋa tamâta. Aku apakasoŋa warakâŋgu tu, “Naneŋgu pavilâŋa tamâta nde ma iyoka pa sinia imâ.” ");
INSERT INTO xsi_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Ŋineŋga naneŋgu ilo-kalo ipâŋga tu Yova Kindeni nanayoni ipulia samba wa tâno wa, aku ina simbo nâ imo naneŋgu Pavilâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","I ma mbau piti lâ noko tini kala patano kundue, ande ma tia. Noko ne katonâŋa tamâta ŋinde ma ikeno mata tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Kuloŋo sondo ŋga; ina uru ikea ŋananzi Isrel ŋgu, aku i ŋana mata tutu ku ikeno utu kâ, ande tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Mao nâ, Yova Kindeni nde imo noko ne katonâŋa tamâta mao. Ina kala uru imandi noko tini laiti ku ikea ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Mine nde kari ma ikura tu ikana noko tini, ande tia, aŋga nzimona kala ma ikura tu iyaula noko lâ mbo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yova Kindeni ma ikea sondo ndo ŋanano. Mine kala vetâŋa sakamao toŋge ma ikura tu izavaruno, ande tia. Ina ma ikatona noko sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Yova Kindeni ma ikea ŋanano ikura nia ndia rârâni noko kumo ŋinde, ma iveta mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Kinzi sipai naŋa mine tu, “Ayo, toka talâ pa Yova Kindeni ne luma sapâŋa.” Kinzi siporo mine, kala iloŋgu ndeka ndo. ");
INSERT INTO xsi_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","O Jerusalem lawea, kala ŋine maka kamâ kapâŋga lâ, aku kamandi noko ne ŋgumbi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Mao nâ, kinzi siveta Jerusalem ipâŋga lawea kaika ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Yova Kindeni ne tamâta rârâni uru silâ pa lawea ŋine ŋana siporo kawanzi ndaŋge ilâ pa i, ikura muŋga itu tukuŋa panzi Isrel ŋgu tu ma siveta mine. ");
INSERT INTO xsi_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ikura mbwera mbwera, Isrel ne koipu ŋalae uru imo lawea ŋine, aku isaŋona ŋgua nia ŋana itu tamâta nenzi ŋgua sondo kâ. ");
INSERT INTO xsi_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Miki naneŋgu ŋgu, ara ŋana miki ma kano pa Yova Kindeni tu ma ivetanzi tamâta simo lawea ŋine tu simo ara nâ. Miki ma kakai noŋa mine, “Kinzi tamâta ea tininzi mwasa pa Jerusalem lawea, ande naŋa iloŋgu tu kinzi ŋinde ma simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Ŋana tu naŋa iloŋgu tu kinzi tamâta ma sisaŋona sondo ndo lâ Jerusalem lawea ne ŋgumbi ilo, ŋana kazâŋa toŋge ma ikura tu isânda kulunzi tia. Aku naŋa iloŋgu tu koipu ŋalae tavanzi tamâta mbâna-mbâna rârâni kala ma sisaŋona sondo mine nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Aku naŋa iloŋgu ŋananzi niŋgu-nambwe wukale wa neŋgu mete kinzi simo Jerusalem lawea tona. Mine nde naŋa ma aporo panzi tamâta ŋinde simo Jerusalem lawea mine tu, “Naŋa iloŋgu tu miki ma kamo ilomi kalomi taitu nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Naŋa iloŋgu tu nenda Maro Yova Kindeni ne luma sapâŋa ma ikeno ara nâ. Mine kala naŋa ma ano pa i tu ma iveta kie ara nâ pa Jerusalem lawea. ");
INSERT INTO xsi_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Yova Kindeni, noko kumo koipu ŋalae lâ samba ilo, kala matâŋgu kâki akai noŋa pano. ");
INSERT INTO xsi_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Maka nema Maro Yova Kindeni, maka ma kao tinima pano lee ikura lâ zo ndia noko ma kuo ne wisi-wisi imâ pama. Mao nâ, maka ma kao tinima pano, itogo wurâta tamâta uru io tini pa ne tamâta ŋalae tu ma iveta kie ara papa, aku itogo kuleŋa taine kala uru io tini mine nâ pa ne taine ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Yova Kindeni, kalo sukâŋa ŋanama! Tamâta rârâ situ maka nde sugorai tamwatama, kala simo siveta kenzi sakamao nâ pama. Mine nde kalo sukâŋa ŋanama! ");
INSERT INTO xsi_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Mao nâ, muŋgani yo, aku imâ lee ipâŋga lâ zo ŋine, ande kinzi mbaliŋa warakanzi simo nâ siveta “a” pama. Kinzi sipasuka warakanzi tininzi ku sitawa maka ndue ndo. ");
INSERT INTO xsi_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Muŋga, ambo Yova Kindeni ivila kinda tia, ande kinda ma tamo viânda, tiya? Kala ŋine miki Isrel tamâta kaporo katula ŋgua pwataki ŋana ŋinde kâ mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","“Muŋga, lâ zo ŋinde nenda kazâŋa tamâta sipara kuku kinda, ambo Yova Kindeni ivila kinda tia, ande kinzi kazâŋa tamâta ma wisinzi nâna ŋalae tina ku ma sizavaru kinda marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Kinda ma naonda tia lâ, itogo uŋara ikai tamâta ilâ pa tâi geza-geza mwasina, aku itogo lââ pondi kâki ku ipatuku tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Kinzi kazâŋa tamâta ma sizavaru kinda ndo lâ, itogo tamâta imbwatuke lâ lââ ŋalae ilo ku imâte mine. Andeta tia.” ");
INSERT INTO xsi_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Mine kala kawânda ndaŋge ilâ pa Yova Kindeni, ŋana tu i ŋandai isâu panzi nenda kazâŋa tamâta tu sizavaru kinda ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Kinda takâwa ŋananzi, itogo sii ipatâpa piti lâ kambâru siŋi ku ilou ilâ. Kambâru siŋi ŋinde nde kaika tia, kala takâwa talâ marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Nia ndoyo Yova Kindeni ipulia samba wa tâno wa, aku inani simbo nâ imo nenda Pavilâŋa Tamwata. ");
INSERT INTO xsi_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Tamâta ea kinzi uru kalonzi tawana Yova Kindeni, kinzi ŋinde nde sitogo Saion Tuu mine. Sâ toŋge ikura tu iririŋo tuu ŋinde yâti taulo ande tia, ma ikeno kaika mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Tuu ŋalaŋala pinde simandi siŋge Jerusalem lawea, aku lâ zo ŋine wa zo muli-muli wa, ande Yova Kindeni kala ma ipâŋga itogo ŋgumbi mine panzi ne tamâta, ku ma ikea ŋananzi mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Nanayoni ina ikisi tâno ne keri panzi ne tamâta, taitu kala zo ŋine kinzi tamâta sakamao sikai maro pa tâno ŋinde. Andeta kinzi ma sikura tu siveta mine ikura zo rârâni, ande tia. Ambo kinzi ma sikura tu siveta mine, tiambo Yova Kindeni ne tamâta kala ma sipaveta kuku mâsi sakamao mine tâ. ");
INSERT INTO xsi_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Yova Kindeni, maka tinima pwâka tu kinzi ma siveta mine. Mine kala kano pano tu kuveta kie ara panzi tamâta arara, kinzi ŋine uru sipono muli pa noko kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Andeta lâ zo ŋana noko ma kupare nia panzi tamâta sakamao, ande maka iloma tu noko ma kupare nia mine nâ panzi tamâta pinde tona, kinzi ŋinde sipu mulinzi pano ku siveta ikura warakanzi nâ nenzi ilo-kalo potomule mine. Aku maka kano pano tu kuvetanzi Isrel tamâta simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Muŋga, lâ zo ŋinde Yova Kindeni ikai maka piti lâ tinikoa nenzi luma sakamao nia, aku ikai maka kataulo kamâ pa Jerusalem lawea kilo, ande maka iloma patea tu ŋinde nde mbupuleŋa nâ. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Mine nde maka kaŋele ku kandeka ŋalae, aku kawama kâki kawâŋgi wâŋgiŋa ndekâŋa kâ. Ŋineŋga kinzi tinikoa ŋgu tamâta nde simora ku siporo pa warakanzi mine tu, “Opopo, Yova Kindeni iveta mâsi ŋalaŋala kie-kie ŋana ivilanzi i tamwata ne ŋgu!” ");
INSERT INTO xsi_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Mao kanaŋo, Yova Kindeni iveta mâsi ŋalaŋala kie-kie ŋana ivila maka, kala iloma ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Yova Kindeni, maka kano pano tu pwaima piti lâ kazâŋa ilo kilo, itogo muŋga kuveta mine. Noko uru kusupwa karâzi imbe ndue lââ kawa-kawa mâsa-mâsa ilo, kala lââ isâko ipipi lâ kawa-kawa ilo, aku maka iloma tu noko ma kuveta vetâŋa kie taituni pa maka. ");
INSERT INTO xsi_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Muŋga, lâ zo ŋinde kinzi tamâta sikai kaniŋa vâsa silâ nenzi tâno ilo ŋana sipau kâ, ande kinzi kalonzi sukâŋa kala simo sipataiŋa nâ. Aŋga lâ zo ŋana kinzi ma sigona kâpwa kanaŋo, ande kinzi ma sindeka ŋalae. Aku maka kala kaloma sukâŋa mine nâ, andeta iloma tu ma kandeka kilo. ");
INSERT INTO xsi_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Mao nâ, maka katogonzi tamâta ŋinde muŋga silâ pa nenzi tâno ŋana sipau kaniŋa vâsa kâ, andeta ilonzi tiŋa nâ. Andeta muli ŋga kâpwa ma ipâŋga, kala kinzi ma kawanzi kâki siwâŋgi wâŋgiŋa ndekâŋa kâ, aku ma sikai kâpwa ŋalae ŋinde sitaulo simâ. ");
INSERT INTO xsi_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Lâ zo ŋana kinzi tamâta sipa luma kâki kâ, ambo kinzi ŋandai sino pa Yova Kindeni tu ivilanzi, ande kinzi siveta nenzi wurâta koa tia nâ. Aku mine nâ, ambo ŋgu toŋge ŋandai sino pa Yova Kindeni tu ikatona nenzi lawea, ande kinzi yoŋa tamâta sio ŋana lawea ŋinde koa tia nâ. ");
INSERT INTO xsi_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Aku mine nâ, tamâta pinde kalonzi kapa ŋana Yova Kindeni kâ, kala simakâsa ŋana sikai mbaliŋa wa kâpwa wa. Ikura zo zo, kinzi sipile kenoŋa nia lâ mboyo ŋaŋa yo, aku sinâna siveta wurâta ŋalae lee mbo. Andeta kinzi siveta mine koa tia nâ. Taitu Yova Kindeni ilo ndo keno panzi ne tamâta, kala lâ zo ŋana sikeno kenoŋa nia yo, ande i uru irombonzi. ");
INSERT INTO xsi_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Tamâta toŋge natu nde sitogo wisi-ara Yova Kindeni ilua i mine. Mao nâ, kinda natunda sitogo kulu ara i tamwata ipatea pa kinda. ");
INSERT INTO xsi_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Ambo tamâta lâlu ipulianzi natu, ande kinzi ŋinde ma muli sikatona i sondo, itogo zugu tamâta ne silâwa uru ikatona i mine. ");
INSERT INTO xsi_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Mao nâ, ambo tamâta toŋge natu rârâ simo, ande i ma indeka nâ, ŋana tu lâ zo ŋana ne kazâŋa tamâta ma sio i lâ ŋgua nia, ande i natu ŋinde ma sivila i ŋana ipolenzi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Noko tamâta ea uru kumege ŋana Yova Kindeni wa kupono muli pa i ne ŋgua wa, ande i ne nzâmbe ara ikeno pano. ");
INSERT INTO xsi_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Aku mbaliŋa ndia noko pwai ŋana ne wurâta kulu, ande ŋinde ma ikurano. Mao nâ, noko ma kumo ara nâ, aku ma ilo ndeka nâ. ");
INSERT INTO xsi_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Noko kaiwa taine ma imo noko ne luma ilo itogo kâi waini ara ipula kanaŋo rârâ mwasina. Mao nâ, i ma ipaguguanzi noko natu rârâ, aku kinzi ma siŋge noko ne kâro-kâro mbwaliu lâ, itogo kâi mbimu irumba wasaseki mine. ");
INSERT INTO xsi_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Mao kanaŋo, Yova Kindeni ma iveta kie ara mine panzi tamâta rârâni uru sipono muli pa i kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Niŋgu-nambwe, Yova Kindeni imo Saion lawea, aku naŋa iloŋgu tu i ma iveta kie ara mine pa noko. Naŋa iloŋgu tu noko ma kusaŋona ara nâ lâ Jerusalem lawea, ikura zo rârâni noko ma kumo via lâ tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Naŋa iloŋgu tu noko ma kumo zo luandondo lee, kumoranzi timbu sipâŋga. Aku naŋa ano pa Yova Kindeni tu ma ivetanzi Isrel tamâta simo ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Miki Isrel ŋgu, kala ŋine miki ma katapâri ŋana vetâŋa sakamao ŋinde nemi kazâŋa tamâta siveta pami, lâ nia ndoyo lee imâ ipâŋga lâ zo ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Mao nâ, nia ndoyo, aku imâ lee ipâŋga lâ zo ŋine, ande kinzi kazâŋa tamâta simo siveta vetâŋa sakamao ndo pa maka. Andeta kinzi ŋandai sipole maka ŋga. ");
INSERT INTO xsi_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Kinzi uru sipalili maka sakamao ndo, aku mbilâo ive kumbuma karae pwapwataki. Mine nde mbwatakâe luandondo rârâ sipâŋga kumbuma, itogo lââ kawa-kawa ikeno tâno ilo mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Andeta Yova Kindeni, ina Vetâŋa Sondo Warika, ande ivila maka ku ipalalana tamâta sakamao nenzi wâlo kaika piti lâ tinima, kala kamo tinima vesa nâ.” ");
INSERT INTO xsi_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Mine kala naŋa iloŋgu tu kinzi tamâta rârâni uru ilonzi sakamao pa Saion lawea ŋinde ma mainzi, ku ma sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ara ndo ŋana kinzi ma simo sitogo unza ipâŋga nia mira mwasina. Unza ŋinde ma ipâŋga wasaseki, andeta ŋgâla-ŋgâla walele nâ. ");
INSERT INTO xsi_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Unza ŋinde nde kelekele kaa nâ. Mine kala tamâta uru silamo ŋineŋga sipa wâra ku sikale silâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Lâ kaniŋa gonâŋa ne zo, ambo tamâta pinde soka nzâla silâ, ande kinzi uru sisarâwa panzi wurâta tamâta tu, “Yova Kindeni iveta kie ara pano!”. Aku kinzi wurâta tamâta kala siporo ŋgua kaŋa taituni taulo panzi. Andeta maka tinima pwâka tu tamâta toŋge ma iporo ŋgua kaŋa mine panzi Saion lawea ne kazâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Yova Kindeni, naŋa iloŋgu malia ndo kala asarâwa pano. ");
INSERT INTO xsi_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Maro Ŋalae, kupaloŋo pa naneŋgu tiŋa. Naŋa asarâwa pano tu kalo sukâŋa ŋanana. Mine nde kutambira taŋa pa naneŋgu sarawâŋa! ");
INSERT INTO xsi_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ambo noko ma kalo ŋgere ŋana maka nema kiesaka rârâni taitu-taitu ikura zo zo, ande ea ma ikura tu iŋgeŋge ŋana noko ne pareŋa-nia, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Andeta noko kuzavaru nema kiesaka piti lâ tinima, ŋana tu noko ilo tu maka ma kamege ŋanano. ");
INSERT INTO xsi_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Mine nde naŋa ao tiniŋgu pa Yova Kindeni. Mao nâ, naŋa amo ao tiniŋgu papa i nâ tu ma ivilana, ikura ne ŋgua pâŋa mine, aku naŋa kaloŋgu tawana i ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Naŋa uru ao tiniŋgu pa Maro Ŋalae nâ tu ma ivilana, itogo kinzi yoŋa tamâta uru mbo mbo sio tininzi pa mbwale pwataki mine. Kinzi ilonzi ŋalae tu mbwale pwataki ma imâ walele nâ, ŋana ma simo ara. ");
INSERT INTO xsi_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Aŋga miki Isrel tamâta, miki kala ma kao tinimi pa Yova Kindeni nâ, ŋana tu i ne tini-mwasa ikeno mine ku imo nâ. Ikura zo rârâni i ilo ara nâ ŋana ikainzi ne tamâta piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Mao nâ, inani ma izavaru i ne tamâta nenzi kiesaka rârâni piti lâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Yova Kindeni, naŋa apile mâsi ŋana apandekâna warakâŋgu kâ marumbu lâ, aku ŋandai uru apasuka warakâŋgu tiniŋgu ŋga. Ilo-kalo pinde nde kaika ndo kala ipole naneŋgu ilo-kalo, andeta naŋa kaloŋgu loko ŋana ilo-kalo ŋinde kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Mao nâ, naŋa wisiŋgu puu ndue lâ, kala amo tava wisiŋgu pisi nâ, itogo lâlu puro-puro wisi pisi ŋana imo tina tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Miki Isrel tamâta, miki ma kao tinimi pa Yova Kindeni nâ, lâ zo ŋine wa zo muli-muli wa. ");
INSERT INTO xsi_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Yova Kindeni, maka kano pano tu kalo ŋgere kilo ŋana Daviti tava malia kie-kie muŋga ipâŋga pa i ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Noko nde Yakopu ne vâsa ŋgu nenzi Maro Kindeni Walo Tamwata, aku maka kano pano tu kalo ŋgere kilo ŋana ŋgua pâŋa kaika ŋinde Daviti iveta kuku noko, aku kuvila i. ");
INSERT INTO xsi_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Daviti ipambwâre mine tu, “Naŋa ma atu kaika ŋana alâ naneŋgu luma ilo wa akeno naneŋgu kenoŋa nia wa. ");
INSERT INTO xsi_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Naŋa ma apwarea ku akeno matâŋgu tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Naŋa ma aka mâsa mine lee, ikura lâ zo ndia naŋa ma apa luma toŋge kâki pa Yova Kindeni, inani Yakopu ne vâsa ŋgu nenzi Maro Kindeni Walo Tamwata, ŋana i ma imo ilo kâ.” ");
INSERT INTO xsi_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Muŋga, lâ zo ŋinde maka kamo Betlehem lawea, ande maka kaloŋo ŋgua tu Yova Kindeni ne ŋgua pâŋa ne sopi sapâŋa nde ikeno nia toŋge. Maka karoto lee kasânda kulu lâ Jar lawea tini laiti. ");
INSERT INTO xsi_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Ŋineŋga maka kaporo tu, “Ayo, toka talâ pa Yova Kindeni ne luma sapâŋa! Talâ pa i ne saŋonâŋa nia ara ŋinde nao, aku tapare tukunda tawâŋgi papa i!” ");
INSERT INTO xsi_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Yova Kindeni, sopi sapâŋa ŋinde itula noko kilala pwataki tu noko nde Walo Tamwata. Maka kano pano tu pwai sopi ŋinde kulâ ne luma sapâŋa ilo, aku kumo ŋinde ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Aku maka iloma tu noko ne patarawâŋa tamâta ma sipaveta kuku vetâŋa sondo lâ noko ne luma ilo ikura zo zo. Aku maka iloma tu noko ne tamâta ma sisarâwa tava ndekâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Yova Kindeni, maka kano pano tu kalo ŋgere ŋana ne wurâta tamâta Daviti kâ. Noko ma kupu muli pa tamâta ŋine noko tamwata muŋga kupatea tu ma imo koipu ŋalae, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yova Kindeni, noko kuveta ŋgua pâŋa kaika kuku Daviti lâ, aku noko ŋana kulele ne ŋgua ipâŋga kie toŋge kilo, ande tia. Noko ne ŋgua pambwareŋa ikeno mine; “Muli mbo noko ne zo marumbu lâ ŋga, ŋineŋga naŋa ma ao noko natu tamâne toŋge ikai noko nia ŋana imo koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Ambo noko ne vâsa kinzi ma siveta ikura naneŋgu ŋgua pâŋa mine, aku ma sipono muli pa ŋgua tukuŋa rârâni naŋa ma alanzi ŋinde tona, ande noko timbu wukale kala ma muli sikai noko nia mine nâ, ku ma simo koipu ŋalaŋala ikura zo rârâni.” ");
INSERT INTO xsi_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Mao nâ, Yova Kindeni ipatea Saion lawea lâ. I ilo tu ma imo ne lawea ŋinde ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Iporo tu, “Naŋa ma amo lawea ŋine ikura zo rârâni. Naŋa iloŋgu pa lawea ŋine, kala ma amo koipu ŋalae lâ lawea ŋainani nâ. ");
INSERT INTO xsi_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Naŋa ma amo ŋai ku ma arombonzi tamâta ŋinde simo Saion lawea, kala kinzi ma siroto ŋana kelekele toŋge tia. Mao nâ, naŋa ma kâpwa alanzi sugorai tamâta simo ŋine, kala ma kapwanzi pupuro ndo. ");
INSERT INTO xsi_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Naŋa ma wurâta alanzi Saion ne patarawâŋa tamâta, kala kinzi ma situla pwataki tu naŋa uru akainzi tamâta piti lâ kazâŋa ilo. Mine kala naneŋgu tamâta simo Saion lawea ŋine nde ma siwâŋgi ku ma sisarâwa tava ndekâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Naŋa ma akai tamâta toŋge lâ Daviti ne vâsa ŋgu, aku ma ao i imo koipu ŋalae lâ lawea ŋine. Naŋa apatea i tu ma ikai koipu ikura zo zo, itogo sinâla mine. ");
INSERT INTO xsi_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Daviti ne walo kaika ma ivilanzi tamâta rârâni i uru ikai poe panzi ŋinde, kala ma simo ara nâ. Andeta naŋa ma aveta maŋeti ŋalae panzi i ne kazâŋa tamâta.” Yova Kindeni kawa ŋgua kala ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Ambo Yova Kindeni ne tamâta ma simo ilonzi taitu nâ, ande ŋinde ma ara ku ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Mâsi mine nde ara ndo, itogo samimi ara ŋinde kinzi muŋga sipaliŋi lâ patarawâŋa tamâta Aron kulu. Samimi ŋinde irere indue ipâŋga ndaŋgeni pwau, aku indue ilâ ikura ne pasawaŋa luandondo ŋgaŋe. Kinzi tamâta simora ŋinde ku ilonzi ndeka. ");
INSERT INTO xsi_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Mao nâ, mâsi ŋana tamo taitu tava ilonda taitu nâ, ande ara ndo, itogo mwâka ŋinde uru mbo mbo imbe ndue Hermon Tuu kulu wa Saion lawea ne tuu kulunzi wa. Ŋana tu Yova Kindeni iveta kie ara ndo panzi tamâta simo Saion lawea, kala ma simo ara mine ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Miki Yova Kindeni ne wurâta tamâta ŋine uru mbo mbo kaveta wurâta lâ i ne luma sapâŋa ilo, miki rârâni kamâ kapanea i kasuka ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Miki naomi pa Nia Sapâŋa Ndo ŋinde, aku mbaumi kâki kano pa Yova Kindeni wa kasuka i ŋa kâki wa. ");
INSERT INTO xsi_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Naŋa iloŋgu tu Yova Kindeni, ina imo Saion lawea, ma iveta kie ara ndo pa miki. Inani nia ndoyo ipulia samba wa tâno wa. ");
INSERT INTO xsi_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","2","Tapanea Yova Kindeni tasuka i ŋa kâki! Miki Yova Kindeni ne wurâta tamâta ŋine uru kamandi i ne luma ilo, kinda nenda Maro Kindeni ne luma sapâŋa ŋinde, ande miki kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Tapanea i ŋa tasuka kâki, ŋana tu i nde ara tamwata. Kinda ma tawâŋgi wâŋgiŋa paneâŋa kâ papa i, ŋana tu ŋinde ma iveta ilonda ndeka. ");
INSERT INTO xsi_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Yova Kindeni ipatea kinda Yakopu ne vâsa ŋgu pa i tamwata. Mine kala kinda Isrel tamâta tamo i tamwata ne ŋgu sondo. ");
INSERT INTO xsi_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Mao nâ, naŋa asama tu nenda Maro Ŋalae ne walo kaika nde ŋalae ndo, aku ina ipolenzi maro laŋeŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Vetâŋa ndia Yova Kindeni ilo tu ma iveta lâ samba ilo wa tâno kulu wa tâi ilo wa tâi duvi lâmbu wa, ande i ma iveta vetâŋani ndaina ikura i tamwata nâ ne pateâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Aku ina kala igonanzi karâzi ne take-take ŋalaŋala sipâŋga lâ nia ŋgaŋe, aku ina isupwa loloa iyoka tava karâzi indue imâ. Ina tamwata uru isupwa lawea ipile ne luma ku iyâti ilâ wa imâ wa. ");
INSERT INTO xsi_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Aku nanayoni, inani kala ipunzi Isip tamâta natunzi tamâne nzâla-kulu rârâni sipamateteu, aku ipunzi nenzi ŋgoa-mbwâmbwa natunzi nzâla-kulu sipamateteu mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Aku iveta mâsi kaika kie-kie pinde lâ Isip tâno ŋinde tona, ŋana ipare nia pa nenzi koipu ŋalae tavanzi i ne sukâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Aku muli ŋga Yova Kindeni izavarunzi tamâta ŋgu rârâ ŋinde. Kinzi ŋgu ŋinde nenzi koipu ŋalaŋala simo tava walo kaika ndo, andeta ipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Mao nâ, Yova Kindeni ipu Amor ŋgu nenzi koipu ŋalae Sihon pâta imâte lâ, aku ipu Basan ŋgu nenzi koipu ŋalae Ok pâta imâte tona. Aku ipunzi ŋgu rârâni simo Kenan tâno ŋinde nenzi koipu ŋalaŋala simâte tona. ");
INSERT INTO xsi_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Ŋineŋga ikai koipu ŋalaŋala ŋinde nenzi tâno ku ikisi keri panzi ne ŋgu Isrel. ");
INSERT INTO xsi_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Mine nde Yova Kindeni, ikura zo zo kinzi tamâta ma sisama noko kilala pwataki tu noko nde Maro Ŋalae mao. Mao nâ, kinzi tamâta ma situla noko parina pwataki ikura zo muli-muli. ");
INSERT INTO xsi_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Ŋana tu Yova Kindeni ma iveta vetâŋa sondo nâ panzi ne tamâta lâ ŋgua nia. I ma kalo sukâŋa ŋana ne wurâta tamâta kinda. ");
INSERT INTO xsi_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Kinda tasama tu kinzi tinikoa ŋgu rârâni nenzi maro nde kelekele kaa nâ. Kinzi tamâta nâ sipare tainzi lâ mira “silva” tini wa mira “gol” tini wa. ");
INSERT INTO xsi_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Kinzi maro laŋeŋa ŋinde kawanzi keno, andeta sikura tu siporo ŋgua kâ, ande tia. Kinzi matanzi keno, andeta sikura tu simora kelekele kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Kinzi taŋanzi keno, andeta sikura tu siloŋo ŋgua, ande tia. Aku kinzi sikura tu simbana korananzi, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Ara ŋana kinzi tamâta uru sipare maro laŋeŋa kaa kaa tainzi ŋinde ma sipâŋga simo rege-rege kunzi maro laŋeŋa ŋinde. Naŋa iloŋgu tu tamâta ea uru kalonzi tawana maro laŋeŋa ŋinde, ande kinzi kala ma sipâŋga kaa nâ, sitogonzi kinzi mine. ");
INSERT INTO xsi_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Aŋga miki Isrel tamâta, miki kapanea Yova Kindeni kasuka i ŋa kâki! Aŋga miki Yova Kindeni ne patarawâŋa tamâta lâ Aron ne vâsa ŋgu, miki kala kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Aŋga miki tamâta lâ Livai ne vâsa ŋgu, miki kala kapanea Yova Kindeni ŋa kasuka kâki! Miki tamâta ea uru kamege ŋana Yova Kindeni kâ, miki rârâni kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Mao nâ, miki tamâta kamo Saion Tuu kulu lâ Yova Kindeni ne lawea Jerusalem ilo, miki ŋinde kapanea i ŋa kasuka kâki! Tapanea Yova Kindeni ŋa tasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Kinda kawânda ndaŋge ilâ pa Yova Kindeni, ŋana tu i nde ara tamwata. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Kinda taporo ndaŋge ilâ pa Maro Kindeni, ina ipolenzi maro rârâni. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Kinda taporo ndaŋge ilâ pa Maro Ŋalae, ina kala ipolenzi tamâta ŋalaŋala rârâni simo tâno kulu. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Ina simbo nâ uru iveta mâsi ŋalaŋala. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","I ne ilo-kalo nde ŋalae ndo; mine kala ipulia samba ipâŋga lâ. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Ina io tâno imandi lââ kulu. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Ina ionzi sinâla ŋalaŋala sipâŋga samba tini. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Aku ina io kari tu ikatona mbwale. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Ina io nzimona tavanzi pitu tu sikatona mbo. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Ina nanayoni ivilanzi timbunda, kala ipunzi Isip tamâta natunzi tamâne nzâla-kulu pâta sipamateteu. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Ŋineŋga ina ikainzi Isrel ŋgu sipile Isip tâno siyâti simâ. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","I tamwata ne walo nde kaika ndo, kala iveta mine. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Aku muli ŋga ina ipu Tâi Ŋiŋi kala ipwa pwataki mo rua. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Ŋineŋga ina ikainzi ne tamâta soka mâsa-mâsa nâ lâ tâi ŋgini simbwaliu silâ. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Andeta ipatuku Isip nenzi koipu ŋalae tavanzi ne zugu tamâta sinu lââ kala sipamateteu lâ. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Aku ina imuŋga panzi ne tamâta soka nia bilimu silâ. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Ŋineŋga ina ipunzi koipu kaika ŋalaŋala pâta simâte. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Kinzi koipu ŋalaŋala ŋinde nawalanzi pinde nde ŋanzi ŋalae, andeta ipunzi pâta simâte. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Ina ipu Amor ŋgu nenzi koipu ŋalae Sihon pâta imâte. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Aku ina kala ipu Basan ŋgu nenzi koipu ŋalae Ok pâta imâte tona. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Ŋineŋga ikai kinzi koipu ŋalaŋala ŋinde nenzi tâno, aku ikisi keri panzi ne tamâta. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Ŋineŋga tâno ŋinde ilanzi ne wurâta tamâta Isrel. ‘Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Kinzi simo lee aku muli, ŋineŋga nenda kazâŋa tamâta sipole kinda lâ, andeta i ŋandai kalo kapa ŋana kinda ŋga. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","I kalo ŋgere kilo ŋana kinda kâ, kala ikai kinda piti lâ nenda kazâŋa tamâta mbaunzi ilo. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ina uru kâpwa ilanzi kelekele rârâni simo vianzi. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Mine nde kawânda ndaŋge ilâ pa Maro Kindeni, inani imo samba ilo. “Mao nâ, i tini mwasa ndo pa kinda ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Maka kasaŋona Babilon ŋgu nenzi lââ ŋgaŋe-ŋgaŋe, aku kaloma ŋgere ŋana nema lawea Saion kâ. Mine nde maka kaloma sukâŋa kala kamo kapataiŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Maka kasonanzi nema wâŋgu sitâra lâ kâi simandi waŋgirama ŋinde lakanzi kulu, aku kapile keno. ");
INSERT INTO xsi_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Maka kaveta mine ŋana duvi ŋine kâ: kinzi kazâŋa tamâta muŋga sikai maka kaika sioma lâ nenzi tâno ŋinde, aku kinzi ŋinde sipai maka tu, “Kala ŋine miki ma kawâŋgi wâŋgiŋa toŋge ŋana iveta maka iloma ara kâ. Kawâŋgi Saion ne wâŋgiŋa toŋge!” ");
INSERT INTO xsi_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Opopo, maka kamo kinzi tinikoa nenzi lawea ma! Mine nde maka kakura ŋana kandeka ku kawâŋgi Yova Kindeni ne wâŋgiŋa mâsi mana, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","O Jerusalem lawea, ambo naŋa ma kaloŋgu kapa ŋanano, ande ara ŋana Yova Kindeni ma iyaula mbauŋgu, ŋana naŋa ma akura tu ara neŋgu wâŋgu kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","O Jerusalem lawea, ambo naŋa ma kaloŋgu kapa ŋanano, ambo naŋa ma apile naneŋgu mâsi ŋana andekanano ŋalae tina kâ, ande ara ŋana Yova Kindeni ma iveta ŋandolâŋgu sakamao, ŋana naŋa ma akura tu awâŋgi wâŋgiŋa kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","O Yova Kindeni, maka kano pano tu kalo ŋgere kilo ŋana vetâŋa sakamao ŋinde kinzi Idom ŋgu siveta, lâ zo ŋinde nema kazâŋa tamâta sipara kuma ku sipole Jerusalem lawea. Kalo ŋgere kilo ŋana ŋgua ŋinde kinzi simo siporo mine tu, “Kazavaru Jerusalem lawea ndoni! Kazavaru ne luma wa kelekele rârâni marumbuni lâ!” ");
INSERT INTO xsi_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Aŋga miki Babilon ŋgu, kaloŋo ŋga; Yova Kindeni ne pateâŋa ikeno tu i ma izavaru miki ndo lâ. Tamâta ea ipare nia pami ŋana vetâŋa sakamao miki muŋga kaveta pa maka ŋinde, ande i ma iveta mâsi ara ndo. ");
INSERT INTO xsi_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","I ma indeka ŋana ikainzi nemi lâlu puro-puro ku itambiranzi sindue mira kulu sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Yova Kindeni, naŋa iloŋgu kaloŋgu ndoni aporo ndaŋge imâ pa noko. Naŋa amandi kinzi maro rârâni naonzi ku awâŋgi wâŋgiŋa paneâŋa kâ pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Noko tini mwasa pa naŋa ikura zo rârâni, aku noko uru kuveta ikura ne ŋgua rârâni. Aku noko kusuka tamwata ŋa tava ne ŋgua pâŋa ŋinde kâki ndo, kala ipole kelekele pinde rârâni. Mine nde naŋa naoŋgu pa noko ne luma sapâŋa, ku apare tukuŋgu apaneano asuka noko ŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Naŋa asarâwa pa noko lâ, aku noko kupaloŋo pa naneŋgu noŋa kala kuo tamwata ne walo ŋalae imâ pana ku ipu tini kaika pa iloŋgu kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Aku koipu ŋalaŋala rârâni simo tâno ndoni kala siloŋo pâri ŋana noko ne ŋgua tukuŋa kâ. Mine kala kinzi ma sipanea noko ŋa sisuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Kinzi ma siwâŋgi wâŋgiŋa situla noko ne vetâŋa ŋalaŋala pwataki, aku ma situla noko kilala pwataki tona tu noko ŋa imo ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","O Yova Kindeni, noko kumo âta ndo, andeta noko kalo ŋgere ŋananzi tamâta ŋine uru sipatawa warakanzi tininzi. Aŋga tamâta ea uru sipasuka warakanzi tininzi, ande kinzi ŋinde sikura tu sipavea ŋanano, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Mao nâ, lâ zo ŋana malia kie-kie ipâŋga pa naŋa, ande noko uru pwea ŋanana kala amo ara nâ. Naneŋgu kazâŋa tamâta wisinzi nâna ŋalae pa naŋa, andeta noko uru kumandi kupara kunzi. Noko ne walo nde kaika ndo; mine nde noko pwai naŋa piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yova Kindeni ma iveta vetâŋa rârâni ŋinde i muŋga ipa ŋgua tu ma iveta pa naŋa. Ŋana tu Yova Kindeni, noko ne tini-mwasa uru ikeno mine ku imo nâ. Mine nde noko ma kupile noko mwasi maka Isrel ŋgu ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yova Kindeni, noko mata kulea sondo pa iloŋgu kaloŋgu, kala kusama naŋa kilalâŋgu marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ambo naŋa asaŋona tâku amandi tâku, ande noko kumora ku kusama naneŋgu vetâŋa rârâni. Noko kumo malawae ŋinde, andeta kusama naneŋgu ilo-kalo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Ambo naŋa aveta wurâta tâku apwarea tâku, ande noko kumora ku kusama. Naneŋgu vetâŋa rârâni nde ikeno nia yo lâ noko nao. ");
INSERT INTO xsi_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Yova Kindeni, ambo naŋa iloŋgu tu aporo ŋgua, andeta aporo pwataki tia yo yo, ande nanayoni noko kusama naneŋgu ŋgua ŋinde marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Mao nâ, noko kuŋge naŋa mbwaliu lâ kutogo ŋgumbi mwasina, aku noko tamwata uru pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Naŋa iloŋgu ikai wurâta ŋalae ŋana asama noko ne vetâŋa ŋinde duvi kâ. Opopo, noko ne ilo-kalo nde kelekele ŋalae tina, kala akura tu asama duvi tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Mine kala ambo naŋa atu apavea ŋanano, ande naŋa ma alâ pa sinia, a? Naŋa ma akâwa alâ pa nia ndia ŋana noko ma kumorana tia, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Ambo naŋa ma akâki pa samba lawea âta ŋinde, ande noko kumo niani ndaina. Ambo naŋa ma alâ pa mateŋa nianzi, ande noko kala kumo nia ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Ambo naŋa ma alou alâ lee apâŋga nia malawae ndo pa mbwera kâ, tâku alâ amo nia malawae ndo pa wâra kâ tâku, ");
INSERT INTO xsi_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ande noko ma kumo niani ndaina tona, aku noko ma pwai poe sondo pa naŋa wa kusaŋa mbauŋgu kuvilana wa. ");
INSERT INTO xsi_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Mao nâ, ambo naŋa ma ano pa kondoma tu imâ ivea naŋa, ambo naŋa ma ano pa kari tu ipalele ipâŋga ŋaŋa, ande naŋa ma akura tu apavea ŋana noko kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Ŋana tu kondoma ikura tu ipono noko mata, ande tia ndo. Kondoma wa mbwale pwataki wa nde kelekele kie taituni lâ noko nao. Mine nde noko uru kumora nia lâ kari wa mbo wa. ");
INSERT INTO xsi_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Yova Kindeni, nanayoni noko tamwata kuveta karaeŋgu ne pinde-pinde ndoni. Noko kuo naŋa apâŋga nana kapwa ilo, aku kuseŋge tukâŋgu ndoni ilâ taitu. ");
INSERT INTO xsi_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Noko ne mâsi ŋana kupulia naŋa kâ nde ŋalae tina ku ara ndo. Mine kala naŋa amege ŋanano wa apaneano wa. Naŋa asama tu noko ne vetâŋa rârâni nde ara ku ara ndo! ");
INSERT INTO xsi_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Nia ndoyo, lâ zo ŋinde naŋa atumbu mwasa-mwasa amo paveâŋa nâ lâ nana kapwa ilo, aku tukâŋgu sipaseŋge lâ, ande noko kumora ku kusama lâ. ");
INSERT INTO xsi_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Naŋa nana ipagugua naŋa tia yo, andeta noko mata kumora naŋa lâ. Naŋa apâŋga amo tâno kulu tia yo yo, andeta nanayoni noko kupatea naneŋgu zo ŋana ma amo viâŋgu kâ marumbu lâ, kala kuŋgere zo ŋinde kambwaŋe lâ pepa tini ikeno lâ. ");
INSERT INTO xsi_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Opopo, Maro Kindeni, naŋa akura tu asama noko ne ilo-kalo rârâni ŋinde tia ndo! Noko ne ilo-kalo nde ŋalae tina. ");
INSERT INTO xsi_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Ambo naŋa ma asowe kelekele rârâni noko uru kalo ŋgere ŋana ŋinde kambwaŋenzi, ande kambwaŋenzi ŋinde ma ipole paulo rârâni ikeno sâwa ndoni. Lâ zo ŋana naŋa amandi sânda lâ kenoŋa nia, ande naŋa amo kuku noko yo. ");
INSERT INTO xsi_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Ayo, Maro Kindeni, naŋa iloŋgu tu noko ma kupunzi tamâta sakamao pâta simâte. Naŋa iloŋgu tu kinzi tamâta kala ilonzi pa paraŋa nâ ŋinde nde ma sipile naŋa ku silâ. ");
INSERT INTO xsi_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Kinzi kazâŋa tamâta ŋinde uru siporo ŋgua pavaligiŋa sakamao pa noko. Mao nâ, kinzi siveta ŋgua potomule kaŋa-kaŋa ŋana siyaula noko ŋa. ");
INSERT INTO xsi_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Yova Kindeni, naŋa wisiŋgu nâna ndo panzi tamâta ea wisinzi nâna pa noko. Naŋa tiniŋgu pwâka ndo ŋananzi tamâta ea uru sikai kazâŋa pa noko. ");
INSERT INTO xsi_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Mao nâ, naŋa iloŋgu panzi tamâta ŋinde tia ku tia ndo! Naŋa amora kinzi sitogo warakâŋgu neŋgu kazâŋa tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Mine nde Maro Kindeni, naŋa iloŋgu tu noko ma kulea sondo pa naŋa, aku kumora ilo-kalo rârâni ŋine ikeno iloŋgu kaloŋgu. Pwai samâŋa pana, aku kutula naneŋgu ilo-kalo rârâni pwataki. ");
INSERT INTO xsi_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Ambo naŋa ayoka lâ nzâla ara tia tâ, ande naŋa iloŋgu tu noko ma kutula ŋinde pwataki pana. Pwai poe sondo nâ pana, aku kuona alâ pa via ne nzâla, ŋana ma amo ara mine ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Yova Kindeni, pwai naŋa piti lâ kinzi tamâta sakamao mbaunzi ilo. Kinzi tamâta ŋinde ilonzi tu sipunzi tamâta. Mine kala ano pano tu pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Ikura zo rârâni kinzi kalonzi ŋgere ŋana mâsi sakamao nâ. Aku kinzi siveta wisi-nâna tava kazâŋa ipâŋga ŋgininzi ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Kinzi nenzi ŋgua nde mata-mata, itogo mwâta niŋo ruru ndo mwasina. Mao nâ, kinzi kawanzi ŋgua uru iyaulanzi tamâta, itogo mwâta saka ikanzi tamâta kala simâte mine. ");
INSERT INTO xsi_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Mine nde Yova Kindeni, pwatona naŋa, ŋana kinzi tamâta sakamao ŋinde nenzi walo ma ikura tu ipole naŋa tia. Kinzi ilonzi tu sipunzi tamâta, aku sipa ŋgua lâ tu ma sizavaru naŋa tona. Mine kala ano pano tu pwea ŋanana. ");
INSERT INTO xsi_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Kinzi taŋa-kaika tamwatanzi ŋinde nde sipavea ku sio nimbu ŋana sikai naŋa kaika kâ. Kinzi sikalolo kaimbo ku siveta nimbu sio lâ nzâla tu ma sikai naŋa, itogo uru sikai simbi mine. ");
INSERT INTO xsi_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Mine nde naŋa asarâwa pa Yova Kindeni mine tu, “Naneŋgu Maro Kindeni kala nokoni.” Yova Kindeni, kutambira taŋa pa naneŋgu noŋa, aku kumâ kuvilana! ");
INSERT INTO xsi_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","O Koipu Ŋalae Yova Kindeni, noko kumo naneŋgu Yautâŋa Tamwata kaika. Muŋga, lâ zo ŋinde maka kamo paraŋa ilo, ande noko pwatona naŋa sondo nâ, kutogo naneŋgu maramuŋa mwasina. ");
INSERT INTO xsi_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Mine nde Yova Kindeni, noko ma kusâu panzi tamâta sakamao tu ma siveta vetâŋa ndia ilonzi tu siveta, mine ndimo. Kinzi sipa ŋgua ŋana siveta vetâŋa sakamao kâ. Naŋa ano pano tu kupono nzalanzi. ");
INSERT INTO xsi_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Noko ma kusâu panzi naneŋgu kazâŋa tamâta tu sizavaru naŋa ndimo. Vetâŋa ndia kinzi siporo tu ma siveta pa naŋa, ande naŋa iloŋgu tu noko ma kulele vetâŋa ŋinde itaulo pa warakanzi nâ. ");
INSERT INTO xsi_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Naŋa iloŋgu tu noko ma kuzavarunzi. Mao nâ, kusupwa yââ imbe ndue kulunzi! Kutambiranzi sindue silâ mbââ ŋalae ilo ku kusae nzâla, ŋana ma sikura tu siyâti simâ kilo tia. ");
INSERT INTO xsi_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Kinzi tamâta mine uru sisowe ŋgua laŋeŋa nâ lâ tamâta pinde tininzi. Noko ma kusâu panzi tamâta ŋinde tu ma simo ara, mine ndimo. Naŋa iloŋgu tu vetâŋa sakamao ma ipâŋga walele nâ panzi tamâta ŋinde uru ilonzi tu sipunzi tamâta, ku ma izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Yova Kindeni, naŋa asama tu noko uru kuvilanzi sugorai tamwatanzi. Aŋga tamâta ea nenzi kaika ŋalae koŋa tia kala sikura tu sipavila warakanzi tia, ande noko uru kuveta vetâŋa sondo ndo panzi. ");
INSERT INTO xsi_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Mao nâ, kinzi tamâta arara ma sipaneano sisuka noko ŋa kâki. Kinzi ŋinde ma simo kuku noko. ");
INSERT INTO xsi_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Yova Kindeni, kala ŋine naŋa ano pano. Naŋa asarâwa pano tu kupaloŋo pa naneŋgu noŋa. Kumâ walele nâ kuvilana. ");
INSERT INTO xsi_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Naŋa iloŋgu tu naneŋgu noŋa ŋine ma ikâki pano itogo mundo ne kuwae ara mwasina. Kari indue lala lâ, kala asuka mbauŋgu kâki akai noŋa pano itogo naneŋgu patarawâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Yova Kindeni, naŋa ano pano tu pwatona naŋa kawâŋgu sondo. Pwai poe pa naneŋgu ŋgua rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Pwai poe sondo nâ pa iloŋgu kaloŋgu tona. Tia ma iloŋgu igagatina ŋana aveta mâsi sakamao wa apakaka kunzi tamâta sakamao aveta kiesaka kunzi wa. Ambo naŋa iloŋgu patea tu ma asaŋona aka kunzi lâ nenzi kâŋa-nuŋa ŋalaŋala, ande naŋa ano pano tu kupono nzalâŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Ambo tamâta ara toŋge kalo sukâŋa ŋanana kala ipu naŋa wa itu naŋa sondo wa, ande ŋinde ma ara. Andeta ikura zo rârâni naŋa ano pa Yova Kindeni tu ma itoto kinzi tamâta sakamao nenzi vetâŋa potomule. Naŋa tiniŋgu pwâka ndo tu kinzi tamâta sakamao ma sisuka naŋa ŋâŋgu kâki. ");
INSERT INTO xsi_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Ara ŋana tamâta pinde ma sikainzi tamâta sakamao ŋinde nenzi koipu ŋalaŋala silâ pa nia ndamwa ku ma sitambiranzi sindue. Ŋineŋga lâ zoni ndaina kinzi ma sisama tu Yova Kindeni kawa ŋgua nde mao kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Ara ŋana kinzi ma sitambira tukanzi simbe sindue mateŋa nianzi nzâla kawa, itogo tamâta itale kâi ilâ pinde-pinde ku itambira pwapwataki mine. ");
INSERT INTO xsi_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Andeta Koipu Ŋalae Yova Kindeni, naŋa kaloŋgu tawana noko nâ. Naŋa amâ pano tu ma amuna noko tini laiti. Noko ma kusâu panzi kazâŋa tamâta tu sipu naŋa pâta amâte, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Kinzi kiesaka tamwatanzi sio nimbu ŋana sikai naŋa kaika kâ. Naŋa ano pano tu pwea ŋanana, ŋana naŋa ma aŋgeŋge ŋana nenzi nimbu ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Naŋa iloŋgu tu kinzi tamâta sakamao nenzi nimbu ŋinde ma ikai kinzi warakanzi kaika, aŋga naŋa warakâŋgu ma aŋgeŋge ŋana nimbu ŋinde kâ, ku ayoka alâ. ");
INSERT INTO xsi_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Naŋa asarâwa kaika pa Yova Kindeni. Naŋa kawâŋgu kâki ano papa i tu ma ivilana. ");
INSERT INTO xsi_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Naŋa iloŋgu makisa kala aporo papa i, atula ŋgua pwataki ŋana malia kie-kie rârâni kala ipâŋga pa naŋa ŋine. ");
INSERT INTO xsi_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Yova Kindeni, lâ zo ŋana iloŋgu malia ŋalae tina, ande noko uru pwatonana. Naneŋgu kazâŋa tamâta sivea nimbu toŋge lâ nzâla naŋa uru ayoka ŋinde. Kinzi situ ma sikale naŋa kaika kâ. ");
INSERT INTO xsi_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Opopo, naŋa matâŋgu ilâ wa imâ wa, andeta amora tu tamâta toŋge imo tiniŋgu laiti ŋana ivila naŋa kâ, ande tia. Tamâta toŋge imo ŋana ikea ŋanana, ande tia. Tamâta toŋge kalo sukâŋa ŋana naŋa kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Mine nde Yova Kindeni, naŋa asarâwa pano tu kumâ kuvilana. Naŋa aporo tu, “Noko tamwata nâ nde naneŋgu katonâŋa tamâta. Lâ zo ŋine naŋa amo viâŋgu, ande naŋa iloŋgu pa kelekele taitu ŋine nâ; naŋa iloŋgu tu noko ma kumo kuku naŋa.” ");
INSERT INTO xsi_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Naŋa asarâwa pano tu kuvilana. Kutambira taŋa pa naneŋgu noŋa, ŋana tu iloŋgu kaloŋgu nde malia ndo. Naneŋgu kazâŋa tamâta kinzi nde tamâta kaika ndo, aku naŋa akura tu apolenzi tia. Mine kala ano pano tu pwaina piti lâ mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Malia ŋine ikale naŋa kaika lâ, itogo wâlo kaika ikeno tiniŋgu mwasina. Naŋa ano pano tu kupalalana wâlo ŋine piti lâ tiniŋgu, ŋana naŋa ma amo ara kilo kâ. Ŋineŋga naŋa ma apaneano asuka noko ŋa kâki. Aku noko ne tamâta ma simora tu noko kuveta kie ara pa naŋa, aku kinzi kala ma simandi kuku naŋa ŋana sipaneano. ");
INSERT INTO xsi_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Yova Kindeni, kupaloŋo pa naneŋgu noŋa! Kutambira taŋa pa naneŋgu tiŋa. Noko ne vetâŋa rârâni nde sondo ndo, aku noko uru kuveta ikura tamwata ne ŋgua rârâni. Mine kala ano pano tu kupaloŋo pa naŋa! ");
INSERT INTO xsi_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Naŋa asama tu tamâta toŋge imo tava ilo mbâra-mbâra ndo lâ noko nao, ande tia ndo. Mine nde noko ma kuo ne wurâta tamâta naŋa amandi noko ne ŋgua nia ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Kumora ŋga; naneŋgu kazâŋa tamâta itaŋgula naŋa lee ipolena ku itawa naŋa ndue ndo lâ. Ipa naŋa kaika lâ, aku io naŋa amo nia kondoma, atogonzi tamâta ŋinde simâte muŋgani lâ. ");
INSERT INTO xsi_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Mine kala naŋa iloŋgu kurana tia, aku iloŋgu kaloŋgu nde malia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Kala ŋine naŋa kaloŋgu ŋgere kilo ŋana zo muŋgâŋa. Naŋa kaloŋgu ŋgere ŋana noko ne vetâŋa rârâni, vetâŋa ŋalaŋala muŋga kuveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Mine nde naŋa asuka mbauŋgu kâki ku ano pano, ŋana tu naŋa iloŋgu ndo tu noko ma kumo kuna, itogo tâno mâsa-mâsa ilo ndo tu karâzi ma imbe indue. ");
INSERT INTO xsi_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Yova Kindeni, kumâ kuvila naŋa walele nâ, ŋana tu iloŋgu kurana tia ndo. Noko ma kupavea ŋanana ndimo. Ambo noko ma kupavea ŋanana, ande naŋa ma amâte ku ma alâ amo mateŋa nianzi. ");
INSERT INTO xsi_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Naŋa ao neŋgu kalo-tawana ilâ pa noko simbo nâ. Mine nde ano pano tu kuveta naneŋgu kalo-ŋgere ipâŋga ikura mboyo mboyo ŋana noko ne tini-mwasa ŋinde uru ikeno mine ku imo nâ. Naneŋgu noŋa imâ pa noko nâ. Mine kala kutula nzâla pana, aku naŋa ma ayoka noko muli. ");
INSERT INTO xsi_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Yova Kindeni, naŋa apalilu akâwa amâ pa noko tu ma pwea ŋanana. Pwai naŋa piti lâ naneŋgu kazâŋa tamâta mbaunzi ilo! ");
INSERT INTO xsi_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Naneŋgu Maro Kindeni kala noko. Mine nde naŋa iloŋgu tu noko ma kupananana sondo ŋana apaveta kuku noko ne pateâŋa nâ. Kuveta kie ara pa naŋa, aku pwai poe pana ŋana ayoka nzâla ara nâ. ");
INSERT INTO xsi_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Yova Kindeni, naŋa ano pano kilo tu pwaina piti lâ kazâŋa ilo, ŋana noko kilala ma ipâŋga nia yo. Noko nde vetâŋa sondo warika. Mine nde kutiŋgi malia rârâni ŋine piti lâ tiniŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Noko ne tini-mwasa ikeno pa naŋa ikura zo rârâni. Mine kala ano pano tu kupunzi naneŋgu kazâŋa tamâta rârâni pâta simâte. Kuzavarunzi tamâta rârâni ŋinde uru siveta kenzi sakamao pa naŋa, ŋana tu naŋa amo noko ne wurâta tamâta. ");
INSERT INTO xsi_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Naŋa apanea Yova Kindeni asuka i ŋa kâki, ŋana tu ina kaika tamwata ŋana ikatona naŋa kâ, itogo mira ŋalae mwasina. Aku ina kala uru ipanana naŋa sondo nâ ŋana paraŋa ne mâsi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","I nde naneŋgu Maro Kindeni tini-mwasa warika, aku ina uru ikatona naŋa itogo ŋgumbi kaika mwasina. I imo itogo naneŋgu maramuŋa mine, aku naneŋgu Yautâŋa Tamwata kala i. Aku naŋa kaloŋgu tawana tu i ma ikea ŋanana, ŋana tu ina kala uru ipolenzi tinikoa ŋgu ku ionzi simo naŋa kaloŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Andeta Yova Kindeni, naneŋgu morâŋa tu maka tamâta nde kelekele kaa nâ. Mine nde mana mana ŋga noko uru kalo ŋgere ŋanama, a? Maka katogo kelekele sugorai kaa nâ mine. Mine nde ŋana sâ kâ ŋga noko ilo ŋanama, a? ");
INSERT INTO xsi_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Maka nde katogo tamâta imbana koroani tini mwata nâ mbwani taitu nâ lâ kawa. Maka kamo zo mbwana-mbwana nâ, katogo kâi uŋa mine. ");
INSERT INTO xsi_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Mine nde Yova Kindeni, pwai samba ne nzâla piti, aku kundue kumâ ku kuvilama! Kusuŋa mbau ndue ku kutaŋonzi tuu, aku kuveta mundo ŋalae ipâŋga tuu tininzi. ");
INSERT INTO xsi_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Kusupwa loloa salaga-salaga indue imâ iŋaranzi kazâŋa tamâta sikâwa pwapwataki silâ. Noko ne silâwa nâ kupanenzi, aku kusokinzi sikâwa silâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Yova Kindeni, naŋa asakoko amo tâi geza-geza ilo. Kusuŋa mbau indue imâ ku kutapa naŋa akâki amâ. Kuvilana, ku pwaina piti lâ kinzi tinikoa tamâta kaika mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Kinzi tamâta ŋinde kawanzi laŋeŋa nâ. Lâ zo ŋana kinzi mbaunzi kâki siporo tu “Maro isama tu naneŋgu ŋgua nde mao nâ”, ande kinzi silâŋe nâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Andeta Maro Kindeni, kala ŋine naŋa ma awâŋgi wâŋgiŋa wasaseki toŋge pa noko. Naŋa ma ara wâŋgu ŋalae ku awâŋgi pano. ");
INSERT INTO xsi_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Ŋana tu nokoni uru kusuka maka Isrel nema koipu ŋalaŋala ŋana sipole paraŋa kâ, aku nokoni kala uru pwai ne wurâta tamâta naŋa Daviti piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Mine kala ŋine nâ kumâ kuvilana, ŋana kinzi kazâŋa tamâta ma sikura tu siveta kenzi sakamao pa naŋa tia. Pwaina piti lâ tinikoa tamâta kaika mbaunzi ilo, kinzi laŋeŋa tamwatanzi ŋinde. Lâ zo ŋana kinzi mbaunzi kâki siporo tu “Maro isama tu naneŋgu ŋgua nde mao nâ”, ande kinzi silâŋe nâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Maka kano pano tu kuvilama, ŋana tu maka iloma tu natuma tamâne limoa kinzi ma situmbu tava walo kaika, sitogonzi kâi ŋalaŋala mine. Aku maka iloma tu natuma taine kinzi ma sipâŋga ara ndo, sitogo sâmbwe arara ŋinde kinzi sisiŋgarana ku siŋgunu ŋana koipu ŋalae ne luma ma imandi kulu kâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Aku maka iloma tu kâpwa kie-kie ma ipâŋga maria lâ nema tâno ilo tona, ŋana kâpwa ne luma ma pipi ndo. Aku maka iloma tu nema lama malakupi ma sipaguguanzi natunzi kambwaŋenzi walo. ");
INSERT INTO xsi_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Maka iloma tu nema bulmakao kala ma sipaguguanzi natunzi rârâ ŋinde tona. Andeta maka tinima pwâka tu kinzi kazâŋa tamâta ma sipu nema lawea ne ŋgumbi mira pwataki ku sikaima kaika kalâ kamo nenzi lawea. Maka tinima pwâka tu kinzi tamâta ma simandi nema lawea ne nzâla ŋgaŋe ku sitarâra ŋana kazâŋa nao panzi kâ. ");
INSERT INTO xsi_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ambo Yova Kindeni ne nzâmbe ma ikeno mine pa ŋgu toŋge, ande kinzi ma sindeka ŋalae. Mao nâ, tamâta ea kinzi uru kalonzi tawana nenzi Maro Yova Kindeni, kinzi ŋinde ma sindeka mine nâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Maro Kindeni, naneŋgu koipu ŋalae, naŋa ma atula noko kilala pwataki tu noko ŋa nde ŋalae ndo. Naŋa ma aporo kawâŋgu ndaŋge imâ pano mine ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Ikura zo zo naŋa ma kawâŋgu ndaŋge imâ pano. Naŋa ma apaneano asuka noko ŋa kâki mine ku amo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yova Kindeni i ŋa nde ŋalae ndo, aku ara ŋana kinda ma tapanea i ŋa tasuka kâki ndo. Ina âta tamwata, aku tamâta toŋge ikura tu isama i kilala sondo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","O Yova Kindeni, kinzi tamâta kala simo lâ zo ŋine nde ma sitapâri panzi natunzi ŋana noko ne vetâŋa arara kâ, aku muli ŋga nenzi vâsa ŋinde kala ma sitapâri mine nâ pa warakanzi natunzi. Ikura zo rârâni, kinzi tamâta ma sipaneano mine nâ ŋana noko ne vetâŋa ŋalaŋala kâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Kinzi ma situla noko kilala pwataki tu noko ne walo nde kaika ndo, aku kumo pwai koipu ŋalae pa kelekele rârâni wa nia ndoni wa. Aku naŋa warakâŋgu kala ma kaloŋgu ŋgere mine nâ ŋana noko ne vetâŋa arara kâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Mao nâ, kinzi tamâta ma sitapâri ŋana mâsi kaika ŋalaŋala noko muŋga kuveta ŋinde, aku naŋa kala ma aporo atula noko kilala pwataki tu noko ŋa nde ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Kinzi ma siporo situla pwataki tu noko nde ara tamwata, aku ma siwâŋgi wâŋgiŋa ŋana noko ne wisi-wisi kâ mine tu, ");
INSERT INTO xsi_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","“Yova Kindeni i nde kalo-sukâŋa warika wa wisi-wisi warika wa. I uru wisi nâna walele tia, aku ne tini-mwasa ŋalae ŋinde ikeno mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Ina kala uru iveta kie ara nâ panzi tamâta rârâni, aku i uru io ne wisi-wisi ilâ pa kelekele rârâni muŋga ivetanzi sipâŋga ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Mao nâ, Yova Kindeni, kelekele vianzi kâ rârâni noko muŋga kupulianzi ŋinde nde ma sipanea noko ŋa sisuka kâki. Aku noko ne tamâta rârâni kala ma kawanzi ndaŋge pano. ");
INSERT INTO xsi_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Kinzi ma situla pwataki tu noko kumo koipu ŋalae kaika ndo pa samba wa tâno wa, aku ma sitapâri ŋana noko ne walo kaika ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Mine kala tamâta rârâni ma sisama ŋana vetâŋa ŋalaŋala kie-kie noko muŋga kuveta ŋinde. Aku kinzi ma sisama tu noko kumo koipu ŋalae kaika tamwata, aku noko ŋa nde ŋalae ndo. ");
INSERT INTO xsi_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Mao nâ, noko ma kumo pwai maro mine ikura zo rârâni. Noko kumo koipu ŋalae, ma kumo mine ku kumo nâ. Yova Kindeni uru iveta ikura tamwata ne ŋgua pâŋa rârâni, aku i ne vetâŋa rârâni itula pwataki tu i nde wisi-wisi warika. ");
INSERT INTO xsi_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Tamâta ea sisânda malia kulu, ande i uru ivilanzi tamâta ŋinde rârâni. Aku ina uru ipu tini kaika panzi tamâta ea nenzi walo ŋalae koŋa tia. ");
INSERT INTO xsi_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Kinzi kelekele rârâni simo vianzi kâ ŋinde nde sio tininzi ŋana noko nâ tu ma kâpwa kusuanzi, aku noko uru kusuanzi lâ zo ndia putole ipunzi. ");
INSERT INTO xsi_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Nokoni uru kâpwa kulanzi kinzi rârâni taitu-taitu, kala sika lee kapwanzi pupuro lâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Mao nâ, Yova Kindeni ne vetâŋa rârâni nde sondo ndo, aku i ne vetâŋa rârâni itula pwataki tu i nde wisi-wisi warika. ");
INSERT INTO xsi_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Tamâta ea kinzi uru kalonzi tawana Yova Kindeni mao ku sisarâwa pa i tu ivilanzi, ande ipaloŋo pa nenzi noŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Tamâta ea simege ŋana i kâ, ande i uru kelekele ndia ilonzi papa ŋinde ilanzi. I ipaloŋo pa nenzi noŋa, ku ikainzi piti lâ kazâŋa ilo. ");
INSERT INTO xsi_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Ina kala uru ikatonanzi tamâta rârâni ŋine ilonzi ndo ikeno pa i. Aŋga kinzi tamâta sakamao, ande i ma izavarunzi ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Mine nde naŋa ma apanea Yova Kindeni asuka i ŋa kâki ikura zo rârâni. Aŋga miki kelekele rârâni ŋine i muŋga ipuliami kala kapâŋga kamo viami, ande miki kala kapanea i kasuka i ŋa sapâŋa kâki mine ku kamo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Naŋa warakâŋgu ma apanea i ŋa asuka kâki. ");
INSERT INTO xsi_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Naŋa ma apanea i ŋa asuka kâki ikura zo rârâni naŋa ma amo viâŋgu lâ tâno kulu. Naŋa ma awâŋgi wâŋgiŋa paneâŋa kâ papa naneŋgu Maro Kindeni lee alâ apâŋga lâ keri. ");
INSERT INTO xsi_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Naneŋgu tamâta, miki kaloŋo ŋga; kinzi koipu ŋalaŋala sitavanzi tâno tamâta ma sikura ŋana sivila miki kâ, ande tia. Mine kala miki ma kalomi tawananzi ndimo. ");
INSERT INTO xsi_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Lâ zo ŋana kinzi ma simâte, ande karaenzi ma ipalele ipâŋga itogo tâno kilo. Aku lâ zoni ndaina, vetâŋa ndia kinzi muŋga siporo tu ma siveta, ande ma sikura tu siveta tia. ");
INSERT INTO xsi_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Aŋga tamâta ea kalo tawana tu Yakopu ne Maro Kindeni ma ivila i, ande i ma indeka nâ, ŋana tu ipasipa kuku ne Maro Yova Kindeni. ");
INSERT INTO xsi_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Yova Kindeni ina nia ndoyo ipulia samba wa tâno wa tâi wa, tavanzi kelekele rârâni simo vianzi lâ nia ndoni. Aku inani kala uru iveta ikura tamwata ne ŋgua pâŋa rârâni ikura zo zo. ");
INSERT INTO xsi_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Tamâta pinde nenzi walo nde ŋalae koŋa tia, kala tamâta pinde siveta kenzi sakamao panzi. Taitu Yova Kindeni uru ivilanzi tamâta ŋinde ku ivetanzi simo sondo. Aku ina uru kâpwa isuanzi tamâta ea putole ipunzi, ku iyautenzi tamâta simo kazâŋa tamâta nenzi luma sakamao ilo ŋinde piti tona. ");
INSERT INTO xsi_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Ina uru ivetanzi tamâta matanzi leva-leva simora kilo. Aku ina kala uru ipu tini kaika panzi tamâta ea nenzi walo ŋalae koŋa tia. Mao nâ, Yova Kindeni ilo ndo keno panzi ne tamâta, kinzi ŋine uru sipono muli papa i nâ. ");
INSERT INTO xsi_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Inani kala uru ikea ŋananzi tamâta lombo mine nâ, kinzi ŋinde soka pa lawea pinde simâ kala simo nenda tâno. Aku ina kala uru ivilanzi taine mwala-mwala wa kinzi lâlu mundoro wa. Aŋga kinzi tamâta sakamao, ande inani uru izavaru vetâŋa ndia kinzi situ siveta. ");
INSERT INTO xsi_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Kinda tasama tu Yova Kindeni ma imo koipu ŋalae mine ku imo nâ. Miki tamâta ŋine kamo Saion lawea, miki nemi Maro Kindeni ma ikai Maro mine ikura zo rârâni. Tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Ara ŋana kinda ma tawâŋgi wâŋgiŋa paneâŋa kâ pa nenda Maro Kindeni, ŋana tu ŋinde nde mâsi ara ku sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Ŋana tu Yova Kindeni iŋgunu Jerusalem lawea imandi kilo, aku kinzi tamâta ŋinde muŋga nenzi kazâŋa tamâta sikainzi silâ pa tâno toŋge, ande Yova Kindeni ikainzi sitaulo simâ kilo. ");
INSERT INTO xsi_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Mao nâ, ikainzi sitaulo simâ kilo ku inzuku nenzi mbwatakâe. Aŋga tamâta pinde, ande malia iyaula nenzi ilo-kalo kala simo ara tia ndo. Andeta Yova Kindeni ivetanzi tamâta ŋinde simo ara kilo. ");
INSERT INTO xsi_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Ina ipateanzi pitu kambwaŋenzi marumbu lâ, aku ipatu kinzi pitu taitu-taitu ŋanzi. ");
INSERT INTO xsi_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Mao nâ, nenda Maro Ŋalae ŋa nde ŋalae ndo, aku imo tava walo kaika. I ne ilo-kalo ipole kinda tamâta nenda ilo-kalo marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Ina kala uru walo ilanzi tamâta ea sipatawa warakanzi tininzi. Aŋga kinzi tamâta sakamao, ande i uru itawanzi ndue ku ipolenzi ndo. ");
INSERT INTO xsi_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Mine nde miki kawâŋgi wâŋgiŋa paneâŋa kâ pa Yova Kindeni! Kara wâŋgu ku kawâŋgi wâŋgiŋa ilâ pa nenda Maro Kindeni! ");
INSERT INTO xsi_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Ŋana tu ina uru ivetanzi take-take sipâŋga lâ samba tini, aku isupwa karâzi imbe indue ŋana iveta unza ipâŋga isala nia ndamwa ndamwa. ");
INSERT INTO xsi_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Aku ina kala uru kâpwa isuanzi simbi rârâni, aku lâ zo ndia kinzi sii natunzi sisarâwa ŋana kapwanzi, ande inani uru kâpwa isuanzi. ");
INSERT INTO xsi_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Yova Kindeni ŋandai ilo ndeka ŋana kinzi zugu tamâta ŋinde uru sipandekâna ŋana warakanzi nâ nenzi kaika wa nenzi “hosi” ŋalaŋala nenzi kaika wa. ");
INSERT INTO xsi_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Andeta i indeka ndo ŋananzi tamâta ea uru simege ŋana i kâ, kinzi ŋine kalonzi tawana tu i ne tini-mwasa ikeno panzi ikura zo rârâni. ");
INSERT INTO xsi_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Mine nde miki tamâta ŋine kamo Jerusalem lawea, miki kapanea Yova Kindeni kasuka i ŋa kâki! Mao nâ, miki ŋine kamo Saion tuu kulu, miki kapanea nemi Maro Kindeni ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ŋana tu ina iveta Jerusalem lawea ne ŋgumbi nzâla sipâŋga kaika ndo, aku inani uru iveta kie ara nâ panzi tamâta simo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ina kala isokinzi lawea pinde nenzi zugu tamâta simo malawae ndo ŋana miki nemi tâno kâ, aku iveta kâpwa ara ndo ipâŋga maria lâ nemi tâno ilo, kala miki kaka lee kapwami pupuro lâ. ");
INSERT INTO xsi_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Andeta ŋinde nâ tia; i itu ŋgua kaika ilâ walele nâ pa tâno, aku tâno ipaloŋo nâ pa i kawa ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Aku ina uru io wââ indue imâ itura tâno lâ. Aku io mwâka ipâŋga unza tini tona. ");
INSERT INTO xsi_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Ina uru io karâzi tava mira “ais” kiri-kiri imbe indue. Lâ zo ŋana iveta nia pisi ŋalae ndo, ande tamâta toŋge ikura tu imo ara, ande tia. ");
INSERT INTO xsi_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Andeta muli ŋga ina iporo itu ŋgua kaika, aku “ais” ipâŋga itogo lââ mine. Mao nâ, i kawa ŋgua iveta “ais” ipâŋga lââ ku irere ilâ. ");
INSERT INTO xsi_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Aku mine nâ, Yova Kindeni iporo itula ŋgua pwataki pa Yakopu ne vâsa ŋgu tona. Itula ne ŋgua tukuŋa kie-kie panzi Isrel ŋgu. ");
INSERT INTO xsi_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Andeta i ŋandai iveta kie mine panzi tinikoa ŋgu. Kinzi sizizâla ŋana i ne ŋgua tukuŋa. Mine nde tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Tapanea Yova Kindeni ŋa tasuka kâki! Miki rârâni kamo samba ilo, mikini kala kamo âta ŋinde, ande miki kapanea Yova Kindeni ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Miki aŋelo rârâni, miki kapanea i ŋa kasuka kâki! Mao nâ, miki aŋelo kaika rârâni, miki kapanea i ŋa kasuka kâki mine nâ! ");
INSERT INTO xsi_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Kari wa nzimona wa, miki kapanea i ŋa kasuka kâki! Aŋga miki pitu rârâni uru kasinala nia, miki kala kapanea i ŋa kasuka kâki mine nâ! ");
INSERT INTO xsi_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Noko samba kumo âta ndo, noko kupanea i ŋa kusuka kâki! Aŋga miki lââ kamo âta ŋinde, ande miki kala kapanea i ŋa kasuka kâki mine nâ! ");
INSERT INTO xsi_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Ara ŋana kelekele rârâni ŋinde ma sipanea Yova Kindeni sisuka i ŋa kâki, ŋana tu nia ndoyo i tamwata iporo itu ŋgua kaika, aku kinzi sipâŋga kala simo. ");
INSERT INTO xsi_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Ina iporo ŋgua, kala kinzi silâ simo nianzi nianzi, ma simo mine ku simo nâ. Io keri panzi lâ, aku sâ toŋge ikura tu itoto i ne ŋgua tukuŋa ŋinde ututu, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Aŋga miki kelekele rârâni kamo tâno kulu, miki kala kapanea Yova Kindeni ŋa kasuka kâki! Miki iŋa ŋalaŋala wa kelekele kamo tâi geza-geza wa, ");
INSERT INTO xsi_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","miki karâzi ne loloa wa mira “ais” wa, miki wââ wa mwâka wa, miki mbilu-lawea kaika kala uru kapono muli pa Yova Kindeni kawa ŋgua, ande miki rârâni kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Miki tuu ŋalaŋala wa tuu kiri-kiri wa, miki kâi bâŋa wa kâi kamandi dugu ilo wa, ");
INSERT INTO xsi_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","miki simbi bâŋa wa simbi ŋgoi wa, miki mwâta wa sii wa, ande miki kala kapanea Yova Kindeni ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Aŋga miki koipu ŋalaŋala wa miki tamâta ŋgu ndoni wa, miki tamâta mbâna-mbâna wa miki katonâŋa rârâni wa, ");
INSERT INTO xsi_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","miki tamâta limoa wa miki taine taipa wa, miki tamâta kokoŋa wa miki lâlu kiri-kiri wa, ande miki rârâni kala kapanea Yova Kindeni ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Mao kanaŋo, miki rârâni kapanea Yova Kindeni ŋa kasuka kâki, ŋana tu i simbo nâ ŋa nde ŋalae, ipolenzi ŋoa ŋalaŋala pinde rârâni. I ne walo nde kaika ndo, aku kelekele rârâni simo samba ilo wa tâno kulu wa, ande kelekele rârâni ŋinde simo i kalo nâ. ");
INSERT INTO xsi_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Aku i tini mwasa ndo panzi Isrel tamâta, kala ivetanzi sipâŋga ŋgu kaika lâ. Kinzi simo i tamwata ne tamâta. Mine kala kinzi uru sipanea i ŋa sisuka kâki. Tapanea Yova Kindeni ŋa tasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Lâ zo ŋana miki Yova Kindeni ne tamâta kapasau ŋana kawâŋgi pa i kâ, ande ara ŋana miki ma kawâŋgi wâŋgiŋa wasaseki papa. ");
INSERT INTO xsi_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Mao nâ, miki Isrel tamâta, miki kalomi ŋgere tava ndekâŋa ŋana Yova Kindeni, inani nanayoni ivetami kapâŋga i ne ŋgu. Miki ŋine kamo Saion lawea, miki kandekana nemi koipu ŋalae! ");
INSERT INTO xsi_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Miki kawâŋgi wâŋgiŋa, aku kaki kapanea i ŋa kasuka kâki! Kara nemi wâŋgu kie-kie, ku kandekana i. ");
INSERT INTO xsi_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Ŋana tu Yova Kindeni uru ilo ara nâ ŋananzi ne tamâta. Aku tamâta ea sipatawa warakanzi tininzi ku simarerea i, ande i ivilanzi tamâta ŋinde ŋana sipole paraŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Ara ŋana Yova Kindeni ne tamâta ma sindeka pâta, ŋana tu kinzi sipole paraŋa lâ. Ikura kari wa mbo wa, ande ara ŋana kinzi ma sindeka ku siwâŋgi wâŋgiŋa papa i. ");
INSERT INTO xsi_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Ara ŋana kinzi ma sisuŋa kawanzi kâki sipanea Maro Kindeni, ŋineŋga sikai nenzi pila ŋana kazâŋa kâ mata ruru ndo ku silâ ");
INSERT INTO xsi_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","sipare nia panzi tinikoa ŋgu. Kinzi ma situ ŋana ŋgu ŋinde nenzi vetâŋa soki-soki, ku ma sizavarunzi wa sitawanzi ndue ndo lâ. ");
INSERT INTO xsi_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Kinzi ma sipa wâlo kaika lâ ŋgu ŋinde nenzi koipu ŋalaŋala tininzi wa nenzi katonâŋa tininzi wa. ");
INSERT INTO xsi_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Ŋineŋga kinzi ma sizavarunzi ŋgu ŋinde ndo, ikura Maro Kindeni ne pateâŋa mine. Kinzi Maro Kindeni ne tamâta rârâni ma sipolenzi kazâŋa tamâta mine nâ. Mine nde tapanea Yova Kindeni tasuka i ŋa kâki! ");
INSERT INTO xsi_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Tapanea Yova Kindeni tasuka i ŋa kâki! Miki ŋine kala kamo Yova Kindeni ne luma sapâŋa ilo, miki kapanea i! Mao nâ, kapanea i kala uru imo samba lawea kaika ŋinde ilo! ");
INSERT INTO xsi_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Ina uru iveta vetâŋa ŋalaŋala kie-kie, aku i ŋa tava ne walo kaika nde ŋalae ndo, ipole kelekele rârâni marumbu lâ. Mine nde miki kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Kambana nemi tando wa kara nemi wâŋgu kie-kie, ku kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Kara nemi wâŋgu, aku kaki kapanea i ŋa kasuka kâki! Kara nemi wâŋgu ŋalaŋala wa kambana kauro wa, ku kapanea i ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Kara nemi kondo “aini” kiri-kiri wa ŋalaŋala wa, aku kaveta ne nduŋeŋani ipâŋga ŋalae ilâ ŋana kapanea Maro Kindeni ŋa kasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Miki kelekele rârâni kamo viami, miki kapanea Yova Kindeni ŋa kasuka kâki! Tapanea Yova Kindeni ŋa tasuka kâki! ");
INSERT INTO xsi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kinzi tamâta ŋine nde Yesu Kirisi timbu wukale: Yesu nde Koipu Ŋalae Daviti ne vâsa, aŋga Daviti nde Abraham ne vâsa. ");
INSERT INTO xsi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham nde Isaka tama, aŋga Isaka nde Yakopu tama, aŋga Yakopu nde Juda wa tai-tua wa tamanzi. ");
INSERT INTO xsi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda nde Peres ku Sera rua tamanzi. Kinzi rua tinanzi nde Tamar. Aŋga Peres nde Hesron tama. Aŋga Hesron nde Ram tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nde Aminadap tama, aŋga Aminadap nde Nason tama. Aŋga Nason nde Salmon tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Aŋga Salmon nde Boas tama; Boas tina nde Rahap. Aŋga Boas nde Obet tama, aŋga Obet tina nde Rutu. Aŋga Obet nde Jesi tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Aŋga Jesi nde Koipu Ŋalae Daviti tama, aŋga Daviti nde Solomon tama. Solomon tina nde muŋga imo Uria kaiwa. ");
INSERT INTO xsi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Aŋga Solomon nde Rehoboam tama, aŋga Rehoboam nde Abiya tama. Aŋga Abiya nde Asa tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aŋga Asa nde Jehosafat tama, aŋga Jehosafat nde Jehoram tama. Aŋga Jehoram nde Usia tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aŋga Usia nde Jotam tama, aŋga Jotam nde Ahas tama. Aŋga Ahas nde Hesekia tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aŋga Hesekia nde Manase tama, aŋga Manase nde Emon tama. Aŋga Emon nde Josaia tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Aŋga Josaia nde Jehoiakin wa tai-tua wa tamanzi. Lâ zo ŋinde kinzi Babilon ŋgu sikainzi Isrel ŋgu sionzi simo Babilon lawea, aku nâna silanzi. ");
INSERT INTO xsi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kinzi Isrel ŋgu silâ sipâŋga Babilon lawea lâ, ŋineŋga Jehoiakin ipulia Sealtiel. Aŋga Sealtiel nde Serubabel tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aŋga Serubabel nde Abiut tama, aŋga Abiut nde Eliakim tama, aŋga Eliakim nde Asor tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aŋga Asor nde Sadok tama, aŋga Sadok nde Akim tama. Aŋga Akim nde Eliut tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aŋga Eliut nde Eleasar tama, aŋga Eleasar nde Matan tama. Aŋga Matan nde Yakopu tama. ");
INSERT INTO xsi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aŋga Yakopu nde Yosepe tama, aŋga Yosepe nde Maria kaiwa. Aku Maria ipagugua Yesu, ina Kirisi, tamâta ŋinde Maro Kindeni ipatea tu ivilanzi ne ŋgu. ");
INSERT INTO xsi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mine kala Abraham see rârâni imâ ipâŋga lâ Daviti ne zo, ande kinzi ŋinde kambwaŋenzi ikura saŋao kanaŋonzi ŋapa. Aku Daviti see rârâni imâ ipâŋga lâ zo ŋinde Isrel ŋgu silâ simo nâna nia lâ Babilon lawea, ande kinzi ŋinde kambwaŋenzi kala ikura saŋao kanaŋonzi ŋapa mine nâ. Aku lâ zo ŋinde simo Babilon lawea, aku ilâ lee ikura lâ zo ŋinde Kirisi ipâŋga, ande kinzi ŋinde kambwaŋenzi kala ikura saŋao kanaŋonzi ŋapa mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Pâri ŋana Yesu Kirisi tu ipâŋga tâno kulu mâsi mana, ande mine: i tina Maria, muŋga sipatea i tu ma ikai kaiwa Yosepe. Andeta kinzi rua sipakâe tia yo, ŋineŋga Koroani Sapâŋa iveta mâsi ŋalae toŋge papa Maria, kala Maria kapwa lâ. ");
INSERT INTO xsi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aŋga Yosepe, ina tamâne ŋinde kinzi muŋga sipatea tu ma ikai kaiwa Maria, ande i tamâta ara, kala tini pwâka tu iveta maŋeti papa Maria. Mine kala itu ipile Maria mwasa nâ. ");
INSERT INTO xsi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosepe nde ilo keno mine yo, ŋineŋga lâ mbupuleŋa Maro Ŋalae ne aŋelo toŋge imâ papa. Aku aŋelo nde ipai tu, “Yosepe, Daviti ne vâsa noko, noko ma kururu ŋana pwai kaiwa taine Maria imâ imo kuno ndimo. Kuloŋo; muŋga, Koroani Sapâŋa io lâlu ŋinde ilâ ikeno Maria kapwa ilo. ");
INSERT INTO xsi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aku Maria ma ipagugua natu tamâne toŋge ipâŋga. Noko ma kupatu i ŋa tu Yesu, ŋana tu i ma izavaru kiesaka piti lâ ne tamâta tininzi, aku ma ivilanzi tu simo vianzi ku simo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mine kala vetâŋa rârâni ipâŋga ikura ŋgua toŋge Maro Ŋalae muŋga io lâ ŋgua-tulâŋa tamâta toŋge kawa mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Taine taipa toŋge, i muŋga ikeno kuku tamâne toŋge tia, ande i ma kapwa, aku ma ipagugua lâlu tamâne. Kinzi ma sipatu lâlu ŋinde ŋa tu ‘Emanyuel’. Ŋoa ŋine nde duvi mine tu, ‘Maro Kindeni imo kuku kinda’.” ");
INSERT INTO xsi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosepe nde imbipole marumbu lâ, ŋineŋga imandi sânda ku iveta ikura Maro Ŋalae ne aŋelo kawa ŋgua mine. Yosepe ikai kaiwa taine Maria imâ imo kuku, ku rua sipakâe. ");
INSERT INTO xsi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Andeta Yosepe ikeno kuku Maria tia. Kinzi simo mine lee, ŋineŋga Maria ipagugua lâlu tamâne ipâŋga. Aku Yosepe ipatu lâlu ŋinde ŋa tu “Yesu”. ");
INSERT INTO xsi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria ipagugua Yesu lâ Betlehem lawea lâ Judia tâno. Pa zo ŋinde Herot imo koipu lâ Judia. Aku lâ zoni ndaina, kinzi tamâta pinde soka papa tâno toŋge ikeno pa mbwera warika kâ simâ pa Jerusalem lawea. Tamâta ŋinde nde sikai ilo-kalo ŋananzi pitu kie-kie. ");
INSERT INTO xsi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kinzi simâ sipâŋga Jerusalem lâ, ŋineŋga sikasoŋa tu, “Lâlu wasaseki toŋge ipâŋga lâ, i ma muli ikai koipu panzi Juda ŋgu, ande imo ndia. Maka kamora i ne pitu pa mbwera kâ, kala kamâ tu ma kapanea i.” ");
INSERT INTO xsi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Koipu Herot nde iloŋo ŋgua ŋinde, ŋineŋga i ilo rârâ. Aku kinzi tamâta rârâni lâ Jerusalem lawea kala ilonzi rârâ mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ŋineŋga Herot ipasupwa ilâ panzi Juda nenzi patarawâŋa tamâta ŋalaŋala rârâni sitavanzi nenzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ tu simâ. Simâ sipasau lâ, ŋineŋga Herot ikasoŋanzi tu, “Tamâta ŋinde sisarawa i ŋa tu Kirisi, ande i ma ipâŋga lâ lawea ndia.” ");
INSERT INTO xsi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kinzi nde sipai tu, “I ma ipâŋga lâ Betlehem lawea, lâ Judia tâno. Ŋgua-tulâŋa tamâta toŋge muŋga iŋgere ŋgua lâ pepa tini mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Noko Betlehem lawea lâ Juda nenzi tâno, noko kumo togo lawea kaa nâ lâ kinzi Juda tamâta ŋalaŋala naonzi, ande tia ndo. Noko ne koipu toŋge ma ipâŋga, aku ma ikai katonâŋa panzi naneŋgu ŋgu Isrel.’” ");
INSERT INTO xsi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot iloŋo nenzi ŋgua lâ, ŋineŋga ipasupwa paveâŋa nâ panzi tamâta papa mbwera warika kâ ŋinde tu simbonzi nâ simâ kuku. Simâ lâ, ŋineŋga ikasoŋanzi tu, “Pitu ŋinde nde ipâŋga lâ zo ndia.” Aku situla pitu ne zo pwataki papa. ");
INSERT INTO xsi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ŋineŋga Herot isupwanzi silâ pa Betlehem lawea, aku iporo laŋeŋa panzi tu, “Miki kalâ ku karoto sondo ŋana lâlu ŋinde kâ. Mambo kasânda lâlu kulu, ŋineŋga kakai pâri kataulo kamâ pa naŋa, aku naŋa kala ma alâ apanea i.” ");
INSERT INTO xsi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kinzi ilo-kalo tamâta ŋinde siloŋo koipu ne ŋgua lâ, ŋineŋga siyâti silâ. Aku pituni ndaina muŋga simora pa mbwera kâ ŋinde nde imuŋga panzi. Pitu iyoka imuŋga panzi ilâ lee, ŋineŋga ipâti itâra âta lâ luma lâlu imo ŋinde kulu. ");
INSERT INTO xsi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kinzi nde simora pitu, ku sindeka pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aku silâ luma ilo, ande simora lâlu ku tina Maria rua. Ŋineŋga sipare tukunzi papa aku sipanea lâlu ŋinde. Aku sikai nenzi tâŋa kawa piti, aku nenzi wisi-ara kulu ŋalae tina silua; mira ara “gol” wa kâu kuwae ara wa samimi kuwae ara wa silua. ");
INSERT INTO xsi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aku lâ nenzi mbupuleŋa, Maro Kindeni itu kaika panzi tu, “Miki ma kataulo kalâ pa Herot kilo ndimo.” Tia ku kinzi soka nzâla toŋge sitaulo silâ pa nenzi lawea kilo. ");
INSERT INTO xsi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kinzi ilo-kalo tamâta nde silâ lâ, ŋineŋga Maro Ŋalae ne aŋelo toŋge ipatua pa Yosepe lâ mbupuleŋa. Aŋelo ipai tu, “Noko kumandi, aku pwainzi lâlu ku tina rua kakâwa kalâ pa Isip tâno. Aku kamo ndaina lee ikura lâ zo ndia naŋa warakâŋgu ma amâ aporo pano kilo ŋga. Herot ma isupwanzi ne tamâta tu siroto ŋana lâlu tu sipu pâta imâte kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ŋineŋga Yosepe imandi sânda, aku ndainani nâ, lâ mbo ŋgini-ŋgini, ikainzi lâlu ku tina Maria rua, aku sikâwa silâ papa Isip tâno. ");
INSERT INTO xsi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aku Yosepe imo Isip lee ikura lâ zo muli Herot imâte lâ ŋga. Mine kala ŋgua toŋge muŋga Maro Ŋalae io lâ ŋgua-tulâŋa tamâta toŋge kawa nde ipâŋga kanaŋo lâ. Ŋgua-tulâŋa tamâta muŋgâŋa ŋinde ikai Maro Kindeni kawa ku iŋgere ŋgua lâ pepa tini tu, ‘Naŋa asarâwa pa natuŋgu tamâne, aku iyoka Isip imâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kinzi ilo-kalo tamâta nde sitaulo silâ pa nenzi lawea lâ, ŋineŋga Koipu Herot isama tu kinzi muŋga silaŋe i tu ma sitaulo simâ papa. Mine kala Herot wisi nâna ŋalae tina. Aku i kalo ŋgere ŋana ŋgua kinzi muŋga siporo ŋinde, ŋana pitu ne zo ŋana ipâŋga kâ. Mine kala isupwanzi zugu tamâta pinde silâ pa Betlehem lawea, aku sikura lawea laiti laiti ŋinde tava. Aku lâ lawea ŋinde sikainzi lâlu tamâne rârâni nenzi mbwera rua tia yo, aku sipunzi pâta sipamateteu. ");
INSERT INTO xsi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vetâŋa ŋinde nde iyoke ŋgua toŋge muŋga Maro Kindeni io lâ ŋgua-tulâŋa tamâta Jeremaia kawa mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kinzi siloŋo sarawâŋa toŋge tava tiŋa wa kalo-kalo iveta nduŋeŋa ŋalae lâ Rama lawea. Rasele ne vâsa nde sitata ŋananzi natunzi, kala kinzi tamâta silâ kunzi tu siveta ilonzi ara kâ. Andeta sikura tia, ŋana tu natunzi rârâni nde sipamateteu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aku muli, ŋineŋga Koipu Herot imâte lâ. Ŋineŋga Maro Ŋalae ne aŋelo ipatua kilo pa Yosepe lâ Isip tâno, lâ i ne mbupuleŋa. ");
INSERT INTO xsi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Aku aŋelo ipai Yosepe tu, “Kumandi sânda, ku pwainzi lâlu ku tina rua kataulo kalâ pa Isrel tâno kilo. Kinzi tamâta muŋga situ sipu lâlu pâta imâte ŋinde, ande simâte lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ŋineŋga Yosepe imandi, aku ikainzi lâlu ku tina rua ku soka silâ pa Isrel tâno. ");
INSERT INTO xsi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Andeta Yosepe iloŋo ŋgua tu Arkelaus ikai tama Herot nia, kala imo koipu panzi tamâta lâ Judia tâno. Aku Yosepe iruru ŋana itaulo pa nia ŋinde. Ŋineŋga lâ Yosepe ne mbupuleŋa toŋge, Maro Ŋalae itu kaika tu Yosepe ma iŋgeŋge ŋana nia ŋinde kâ. Mine kala Yosepe ilâ papa Galilaya tâno. ");
INSERT INTO xsi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ipâŋga Galilaya lâ, aku imo lawea toŋge, i ŋa tu Nasarete. Mine kala ŋgua-tulâŋa tamâta muŋgâŋa nenzi ŋgua ŋana Kirisi kâ nde ipâŋga kanaŋo. Nenzi ŋgua ŋine nde mine, “Kinzi ma siporo tu, ‘I nde Nasarete lawea warika’.” ");
INSERT INTO xsi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mbwera pinde ilâ lâ, ŋineŋga Yoane Lââ-Liliŋa Tamwata ipâŋga nia bilimu toŋge lâ Judia tâno. I uru itula ŋgua panzi tamâta mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ nde imâ ipâŋga laiti lâ. Mine nde miki kapalele ilomi kalomi.” ");
INSERT INTO xsi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yoane nde tamâta ŋinde Maro Kindeni muŋga iporo ŋana lâ ŋgua-tulâŋa tamâta Aisaia kawa mine tu, “Lâ nia bilimu, sarawâŋa toŋge iyoka lâ tamâta toŋge kawa imâ mine tu, ‘Kaveta nzâla sondo ŋana Maro Ŋalae ma imâ kâ’.” ");
INSERT INTO xsi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoane nde uru isawa pasawaŋa muŋga sisuta lâ ŋgoa “kamel” karae, ku ipu ŋgoa karae lâ kambwaŋe. Aku i uru ika ndemu-ndemu tava sipa siŋi togo kâ kaniŋa mwasina. ");
INSERT INTO xsi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lâ zo ŋinde, kinzi Jerusalem tamâta ŋgu ŋalae sitavanzi Judia tamâta rârâ aŋga tamâta lâ lawea lawea ikeno Jodan Lââ tini laiti, ande kinzi ŋinde rârâni nde simâ pa Yoane. ");
INSERT INTO xsi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kinzi sipatula nenzi kiesaka papa, aku ililinzi lâ Jodan Lââ. ");
INSERT INTO xsi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoane mata ilâ imoranzi tamâta rârâ lâ kinzi Parisai ŋgu wa Sadyusi ŋgu simâ ŋana sikai lââ-liliŋa kâ. Aku Yoane ipainzi tamâta ŋinde tu, “Miki nde mwâta sakamao natunzi! Miki ea ipaimi tu kakâwa ŋana Maro Kindeni ne wisi-nâna, a? ");
INSERT INTO xsi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Miki ŋandai kaveta vetâŋa arara ŋga. Ambo miki ma kaveta vetâŋa ara, ande ŋinde nâ ma itula ilomi pwataki tu miki kapalele ilomi kalomi lâ. ");
INSERT INTO xsi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Miki uru kaporo kaa nâ lâ warakami ŋginimi tu, ‘Abraham nde maka timbuma’, aku lâ ŋgua ŋine miki katu Maro Kindeni ne pareŋa-nia ŋana nemi kiesaka kâ ma iŋgeŋge ŋanami. Opopo, miki kapalâŋe ndo! Naŋa aporo mao nâ pami; Maro Kindeni ikura tu ikainzi mira ŋai ku ivetanzi sipâŋga Abraham ne vâsa, sitogo miki mine! ");
INSERT INTO xsi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kavasi nde ikeno lâ kâi duvi tini. Kâi ndia uru ipula kanaŋo ara tia, ŋinde ma Maro Kindeni iso irumbia lâ yââ kana lâ. ");
INSERT INTO xsi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naŋa uru alilimi lâ lââ nâ, aku vetâŋa ŋine itula ilomi pwataki tu miki kapalele ilomi kalomi lâ. Aŋga tamâta toŋge iyoka naŋa muliŋgu mwaŋga imâ, aku i ne walo nde ipole naneŋgu walo. I nde tamâta ŋalae; mine kala naŋa amo i kalo, atogo tamâta kaa nâ mine. Naneŋgu ara keno ŋana akai i ne kie kâmba atogo i ne wurâta tamâta sugorai mine, ande tia. I ma ililimi lâ Koroani Sapâŋa wa yââ wa. ");
INSERT INTO xsi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I ne kâro-kâro keno i mbalau ilo, aku ma ikaro ‘wit’ ne kina itambira lâ. I ma igona ‘wit’ kanaŋo ku io lâ kâpwa ne luma ilo. Aŋga kina nde ma irumbia lâ yââ ŋinde uru mela-mela mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lâ zo ŋinde Yesu ipile Galilaya tâno, aku indue imâ pa Jodan Lââ. Imâ pa Yoane Lââ-Liliŋa Tamwata tu ma ikai lââ-liliŋa lâ Yoane mbau. ");
INSERT INTO xsi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Andeta Yoane ilelea i, aku ipai tu, “Ara ŋana noko ma kulili naŋa. Mine nde mana mana aŋga noko kumâ pa naŋa ŋana alilino.” ");
INSERT INTO xsi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Andeta Yesu itu lâ kawa tu, “Kupile ŋga. Kinda rua ma taveta ŋine, ikura Maro Kindeni ne pateâŋa mine.” Ŋineŋga Yoane isâu papa Yesu ne ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yoane ilili Yesu lâ, aku walele nâ Yesu ipile lââ ku ikâki ilâ pa pâŋga pwali. Aku ndainani nâ samba ipwa pwataki, aku Yesu imora Maro Kindeni ne Koroani Sapâŋa itogo bâlu mine indue imâ papa. ");
INSERT INTO xsi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aku sarawâŋa toŋge iyoka pa samba indue imâ mine tu, “Naŋa natuŋgu kala ŋine. Naŋa iloŋgu ndo keno papa wa iloŋgu indeka papa wa.” ");
INSERT INTO xsi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesu ikai lââ-liliŋa lâ, ŋineŋga Koroani Sapâŋa ikai Yesu io lâ nia bilimu toŋge, ŋana koroani saka nenzi koipu ma ikai samâŋa papa. ");
INSERT INTO xsi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aku pa zo ŋinde Yesu indi kaika pa tamwata tu ma ika kâpwa tia, kala imo mine lee ikura kari tamâta rua (40) lâ, kala putole ipu pâta. ");
INSERT INTO xsi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ŋineŋga koroani saka nenzi koipu imâ pa Yesu, aku ipai tu, “Noko kutu Maro Kindeni natu, ande ara, kuporo panzi mira ŋai tu ma sipalele sipâŋga sitogo puroŋa mine.” ");
INSERT INTO xsi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Andeta Yesu iporo taulo tu, “Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Kâpwa nâ ikura tu isukanzi tamâta ŋana simo vianzi kâ, ande tia; ŋgua rârâni ipâŋga lâ Maro Kindeni kawa ŋinde tona ma isukanzi tamâta’.” ");
INSERT INTO xsi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yesu iporo ŋgua mine lâ, ŋineŋga koroani saka nenzi koipu ikai Yesu ilâ Jerusalem lawea, aku io i kâki imandi Maro Kindeni ne luma sapâŋa mende kulu. ");
INSERT INTO xsi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aku ipai Yesu tu, “Noko kutu Maro Kindeni natu, ande ara, kusoŋga kundue pa tâno kulu. Ŋana tu Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘I ma ionzi ne aŋelo tu sikatonano. Kinzi ma mbaunzi nâ sisuka noko kâki, kala mira toŋge ma ikura tu isowe noko kie, ande ma tia’.” ");
INSERT INTO xsi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Andeta Yesu ipai tu, “Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Noko ma kuveta samâŋa toŋge pa noko ne Maro Ŋalae Kindeni ndimo’.” ");
INSERT INTO xsi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ŋineŋga koroani saka nenzi koipu ikai Yesu ikâki tuu ŋalae toŋge kulu, aku itula nia wa lawea ndoni tava nenzi siŋgâra arara papa. ");
INSERT INTO xsi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aku ipai Yesu tu, “Ambo noko ma kupare tuku ku kutundu kupanea naŋa, ande naŋa ma kelekele rârâni ŋine alano.” ");
INSERT INTO xsi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Andeta Yesu itu lâ kawa tu, “Sadana, noko pwâwa kulâ! Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Noko ma kutundu kupanea noko ne Maro Ŋalae Kindeni, aku kuveta wurâta papa i simbo nâ’.” ");
INSERT INTO xsi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ŋineŋga koroani saka nenzi koipu nde ipile Yesu ilâ, aku kinzi aŋelo simâ ku sikatona Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pa zo ŋinde, Yesu iloŋo ŋgua tu kinzi sio Yoane Lââ-Liliŋa Tamwata imo luma sakamao ilo. Mine kala itaulo ilâ pa Galilaya tâno kilo. ");
INSERT INTO xsi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ipile Nasarete lawea ku ilâ ipâŋga Kaperneam lawea, aku imo lawea ndaina. Kaperneam lawea ikeno Galilaya Lââ bwalika pwali. Nia ŋinde nde kinzi Sebulun ŋgu aŋga kinzi Naptali ŋgu nenzi tâno. ");
INSERT INTO xsi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mine kala Yesu iveta ikura ŋgua toŋge muŋga ŋgua-tulâŋa tamâta Aisaia iporo lâ. Aisaia muŋga ikai Maro Kindeni kawa ku iporo tu, ");
INSERT INTO xsi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Miki tamâta lâ Sebulun ŋgu aŋga lâ Naptali ŋgu, miki ŋinde kamo papa Galilaya Lââ bwalika, pa Jodan Lââ tini pinde, aku kamo Galilaya tâno kunzi tinikoa ŋgu, miki kaloŋo; ");
INSERT INTO xsi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kinzi tamâta uru simo kondoma ilo, ande kinzi ma simora sinâla ŋalae toŋge. Mao nâ, kinzi simo nia kondoma, itogo mateŋa nianzi mine. Andeta sinâla ŋinde ma isinalanzi.” ");
INSERT INTO xsi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lâ zo ŋinde, Yesu imandi ŋana iveta ne wurâta ŋana itula ŋgua kâ. I uru itula ŋgua mine tu, “Miki kapalele ilomi kalomi, ŋana tu Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ nde imâ ipâŋga laiti lâ”. ");
INSERT INTO xsi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zo toŋge Yesu iyoka Galilaya Lââ bwalika pwali ilâ, aku mata ilâ imoranzi tai-tua rua, Saimon, i ŋa toŋge Petero, kuku i tai Andaria rua. Kinzi rua simo sitambira viâŋa lâ lââ bwalika ilo, ŋana tu rua uru sikai iŋa ŋana nenzi mbaliŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aku Yesu ipainzi rua tu, “Miki rua kamâ kapono muli pa naŋa, aku ma apananami ŋana kakainzi tamâta kâ”. ");
INSERT INTO xsi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aku walele nâ kinzi rua sipile nenzi viâŋa ku soka i muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aku Yesu iyoka ilâ, ŋineŋga imoranzi tamâta rua, tai-tua rua; Yamesi, i Sebedi natu, aŋga i tai Yoane. Kinzi rua kala sisaŋona wâŋga kulu kuku tamanzi Sebedi, aku siveta nenzi viâŋa sondo. Aku Yesu isarawanzi rua, ");
INSERT INTO xsi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aku walele nâ kinzi rua sipile tamanzi imo wâŋga kulu ku soka Yesu muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ŋineŋga Yesu iyoka ilâ ikura nia ndoni lâ Galilaya tâno. I uru ipanananzi tamâta lâ nenzi luma ŋana pasauŋa kâ ilo. Aku itula pâri ara ŋana Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ tava, aku ivetanzi pukoŋa tamâta rârâni tininzi ara, kinzi ŋinde muŋga simo tava pukoŋa kie-kie. ");
INSERT INTO xsi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aku Yesu parina nde ilâ isala nia ndoni papa Siria tâno kâ. Mine kala sikainzi tamâta rârâni ŋinde pukoŋa wa nâna kie-kie ikainzi lâ, ku simâ pa Yesu. Aku sikainzi tamâta ŋinde koroani saka sipakâe kunzi ŋinde tona, sitavanzi tamâta ŋinde uru patanzi wa tininzi ruru ŋalae wa tukanzi pââsââ wa; kinzi sikainzi tamâta ŋinde rârâni simâ pa Yesu. Aku Yesu ivetanzi tamâta ŋinde rârâni tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mine kala tamâta ŋgu ŋalae tina lâ Galilaya tâno, aŋga lâ Lawea Saŋao, aŋga lâ Jerusalem lawea, aŋga lâ Judia tâno, aŋga lâ Jodan Lââ tini pinde, kinzi ŋinde soka Yesu muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu nde imoranzi tamâta ŋgu ŋalae ŋinde simâ papa, ŋineŋga ilâ ikâki tuu toŋge kulu isaŋona. Aku kinzi kalo-tawana tamâta nde simâ papa. ");
INSERT INTO xsi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ŋineŋga Yesu ipanananzi mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tamâta ea kinzi sipasama tu kinzi sikura ŋana sipavila warakanzi tia, kala sino pa Maro Kindeni simbo nâ tu ma ivilanzi, ande kinzi ŋinde ma sindeka, ŋana tu kinzi simo Maro Kindeni ne ŋgumbi ilo marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aŋga tamâta ea kinzi sipamorai tu nenzi kiesaka rârâ ikeno tininzi, aku ilonzi malia ŋana ŋinde kâ, kinzi ŋinde ma sindeka, ŋana tu Maro Kindeni ma iveta ilonzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aŋga tamâta ea kinzi uru sipatawa warakanzi tininzi, kinzi ŋinde ma sindeka, ŋana tu muli Maro Kindeni ma tâno ndoni ilanzi. ");
INSERT INTO xsi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aŋga tamâta ea kinzi ilonzi ndo tu sipâŋga ilonzi mbâra-mbâra lâ Maro Kindeni nao, kinzi ŋinde ma sindeka, ŋana tu Maro Kindeni ma ivetanzi sipâŋga mbâra-mbâra mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aŋga tamâta ea kinzi uru kalonzi sukâŋa ŋananzi tamâta kala sisukanzi, kinzi ŋinde ma sindeka, ŋana tu Maro Kindeni ma kalo sukâŋa ŋana kinzi warakanzi mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aŋga tamâta ea kinzi ilonzi ndo tu sipono muli pa Maro Kindeni, aku ilonzi rua-rua tia, kinzi ŋinde ma sindeka, ŋana tu muli kinzi matanzi ma simora i nao. ");
INSERT INTO xsi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aŋga tamâta ea kinzi uru silulu tininzi pinde nenzi wisi-nâna wa paraŋa wa, kinzi ŋinde ma sindeka, ŋana tu Maro Kindeni ma ikatonanzi sitogo i natu wukale mine. ");
INSERT INTO xsi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aŋga tamâta ea kinzi sikai nâna ŋana sipaveta kuku Maro Kindeni ne pateâŋa, kinzi ŋinde ma sindeka, ŋana tu kelekele ŋinde Maro Kindeni uru ilanzi tamâta ikai maro panzi ŋinde, ande ma ilanzi kinzi tona. ");
INSERT INTO xsi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kinzi tamâta pinde ma sisama tu miki uru kapono muli pa naŋa, aku ŋana duvi ŋinde kâ ma siporo ŋgua sakamao pami wa siveta malia pami wa sisowe ŋgua laŋeŋa kie-kie lâ tinimi wa. Ambo mine, ande ara, miki ma kandeka. ");
INSERT INTO xsi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Miki ma ilomi ara ŋana ŋinde kâ, aku kandeka pâta kanaŋo, ŋana tu Maro Kindeni io kulu ŋalae ikeno indamwami lâ samba ilo. Mao nâ, kinzi muŋga siveta malia mine nâ panzi ŋgua-tulâŋa tamâta simo muŋgâŋa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Miki nde katogo tâi panzi tamâta rârâni. Ambo tâi ne makisa marumbu, ande vetâŋa toŋge ikeno ŋana tamâta ma siveta ne makisa ipâŋga kilo, ande tia. Ambo tâi ne makisa tia, ande ipâŋga itogo kina mine, kala tamâta uru sitambira lâ tâno kulu, aku kenzi nâ sipale. ");
INSERT INTO xsi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Miki nde katogo sinâla panzi tamâta rârâni. Ambo lawea toŋge ikeno tuu kulu, ande ikura tu ipavea tia. ");
INSERT INTO xsi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kinzi tamâta uru sisulu sinâla ŋineŋga sio lâ kondo toŋge kalo, ande tia. Kinzi uru sio sinâla kâki lâ peke kulu, ŋana ma isinalanzi tamâta rârâni simo luma ŋinde ilo. ");
INSERT INTO xsi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aku miki kala mine nâ, miki ma kao nemi sinâla yâti ŋana isinalanzi tamâta rârâni. Ambo miki ma kaveta mine, ande kinzi ma simora vetâŋa arara kala kaveta ŋinde, aku ma sipanea miki tamami Maro Kindeni, ina imo samba ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ambo miki ilomi patea tu naŋa amâ tâno kulu ŋana azavaru Mose ne ŋgua tukuŋa wa kinzi ŋgua-tulâŋa tamâta nenzi ŋgua wa, ande miki ma ilomi mine ndimo. Ŋana tu naŋa amâ ŋana aveta ŋgua ŋinde rârâni ipâŋga kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Naŋa aporo mao nâ pami; ŋgua tukuŋa ne ŋgereŋa kiri-mwata toŋge ma zavaruŋa tia ndo lee samba wa tâno ne zo marumbu. Ŋana tu vetâŋa rârâni ma ipâŋga muŋga lâ ŋga, ikura ŋgua tukuŋa iporo tu ma ipâŋga mine. ");
INSERT INTO xsi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ambo tamâta toŋge ipu muli pa ŋgua tukuŋa kiri-mwata toŋge, aku ipanananzi tamâta tu ma sipu mulinzi pa ŋgua tukuŋa mine, ande tamâta ŋinde ma imo kaa nâ lâ ŋgu Maro Kindeni ikai maro papa ŋinde naonzi. Aŋga tamâta ea iyoka ŋgua tukuŋa rârâni muli ku ipanananzi tamâta tu ma soka ŋgua tukuŋa muli mine, ande i ma imo tamâta ŋalae lâ ŋgu Maro Kindeni ikai maro papa ŋinde naonzi. ");
INSERT INTO xsi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ sitavanzi kinzi tamâta lâ Parisai ŋgu, ande kinzi uru simakâsa ŋana soka ŋgua tukuŋa muli. Andeta naŋa apaimi tu ambo miki nemi vetâŋa arara ŋandai ipole kinzi nenzi vetâŋa arara, ande miki ma kakura tu kamo Maro Kindeni ne ŋgumbi ilo, ande tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi tamâta mine, ‘Kinda timbunda muŋga sikai ŋgua tukuŋa ŋine: “Noko ma kupu tamâta pâta imâte ndimo. Ambo tamâta toŋge ipu tamâta toŋge pâta imâte, ande kinzi ma sikai i ilâ imandi ŋgua nia”.’ Ŋine miki kasama lâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ambo taitu ŋine naŋa apaimi tu ambo tamâta toŋge wisi nâna pa ninambwe toŋge, ande Maro Kindeni ne pareŋa-nia ikeno papa i. Ambo tamâta toŋge iporo ŋgua sakamao papa ninambwe toŋge, ande kinzi tamâta ŋalaŋala ma situ i sondo. Andeta kaloŋo ŋga; ambo tamâta toŋge ipai ninambwe toŋge tu, ‘Noko kapa!’, ande i ipâŋga yââ ŋalae ne mbââ tini laiti. ");
INSERT INTO xsi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mine kala lâ zo ndia noko pwai ne patarawâŋa kulâ pa patarawâŋa nia, ambo noko kalo ŋgere ŋana muŋga kuveta soki pa ninambwe toŋge kala i wisi nâna pano, ");
INSERT INTO xsi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ande kuo ne patarawâŋa ndue keno patarawâŋa nia nao, aku kulâ kuveta ŋgua sondo kuku ninambwe muŋga lâ ŋga. Kuveta sondo lâ, ŋineŋga kutaulo kilo, aku kuo ne patarawâŋa ilâ pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ambo tamâta toŋge isowe ŋgua lâ noko tini, kala miki rua koka nzâla kalâ pa ŋgua nia, ande walele nâ noko ma kuveta ŋgua sondo kuku i. Tia ma tamâta ŋinde io noko lâ ŋgua-samâŋa tamâta mbau ilo, ŋineŋga i ma iono lâ sambara mbaunzi ilo, ŋineŋga kinzi ma siono lâ luma sakamao ilo. ");
INSERT INTO xsi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Naŋa aporo mao nâ; noko ma kumo luma sakamao ilo lee ikura lâ zo ndia noko ma kupare ne mbumbu kulu kinzi sipatea pano ŋinde marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi tamâta mine, ‘Ŋgua tukuŋa keno mine: “Noko ma kuveta sakamao kuku tamâta toŋge kaiwa ndimo”.’ ");
INSERT INTO xsi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ambo taitu ŋine naŋa apaimi tu, ambo tamâta toŋge mata ilea pa taine toŋge ku ilo yosi ŋana, ande lâ i tamwata ilo tamâta ŋinde iveta sakamao kuku i marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ambo noko mata ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kupasiki mata ŋinde piti ku kutambira ilâ. Ambo noko mata taitu nâ, ande ŋine nde ara koŋa tia. Taitu kuloŋo ŋga; ambo noko tini ndoni ku Maro Kindeni itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ambo noko mbau toŋge ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kutoto mbau ŋinde piti ku kutambira ilâ. Ambo noko mbau taitu nâ, ande ŋine nde ara koŋa tia. Taitu kuloŋo ŋga; ambo noko tini ndoni kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipananami tu, ‘Ambo tamâta toŋge itu ipile kaiwa taine, ande i ma iŋgere ŋgua lâ pepa toŋge tini ku ilua kaiwa taine, ŋana itoto pakâeŋa kâ’. ");
INSERT INTO xsi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ambo taitu ŋine naŋa apaimi tu ambo tamâne toŋge ipile kaiwa taine, andeta taine ŋinde muŋga iveta sakamao kuku tamâta toŋge tia, ande tamâne ŋinde iveta kaiwa taine ŋinde ipâŋga togo taine ŋana itambira tini potomule kâ. Ambo muli tamâta toŋge ikai taine ŋinde, ande kaiwa tamâne wasaseki ŋinde iveta sakamao kuku tamâta toŋge kaiwa.” ");
INSERT INTO xsi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi tamâta mine, ‘Kinda timbunda muŋga sikai ŋgua tukuŋa mine: “Ambo noko kupa ŋgua kuku Maro Kindeni ŋana ma kuveta vetâŋa toŋge, ande noko ma muli kumbware ŋgua pâŋa ŋinde ndimo”.’ Ŋine miki kasama lâ. ");
INSERT INTO xsi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ambo taitu ŋine naŋa apaimi tu ambo noko kuveta ŋgua pâŋa toŋge, ande noko ma kusarâwa pa sâ toŋge tu iveta ŋgua ŋinde kaika ndimo. Noko ma kusarâwa pa samba ndimo, ŋana tu samba nde Maro Kindeni ne saŋonâŋa nia. ");
INSERT INTO xsi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aku noko ma kusarâwa pa tâno ndimo, ŋana tu tâno nde Maro Kindeni ne nia ŋana io kie lâ kulu kâ. Aku noko ma kusarâwa pa Jerusalem lawea ndimo, ŋana tu Jerusalem nde Koipu Ŋalae Maro Kindeni ne lawea. ");
INSERT INTO xsi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aku noko ma kusarâwa pa tamwata kulu kâmba tu iveta ŋgua toŋge kaika ndimo, ŋana tu noko pwura ŋana kuveta kulu pwau ŋinde ipâŋga pâne tâku mâmâŋga, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ambo noko ilo tu kuveta ŋgua pâŋa toŋge, ande noko ma kuporo tu, ‘Naŋa ma aveta mine’, tâku, ‘Naŋa ma aveta mine tia’. Ŋinde ikura lâ. Ŋgua ndia noko kuseŋge ilâ tava ne ŋgua pâŋa, ande ŋgua ŋinde iyoka pa koroani saka nenzi koipu nâ kawa imâ, ina sakamao tamwata.” ");
INSERT INTO xsi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi tamâta tu, ‘Ŋgua tukuŋa keno mine: “Ambo tamâta toŋge iyaula noko mata, ande ara, noko kala kuyaula i mata. Ambo tamâta toŋge imbware noko niŋo, ande ara, noko kala kumbware i niŋo”.’ ");
INSERT INTO xsi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ambo taitu ŋine naŋa apaimi tu noko ma kupare nia pa tamâta iveta soki pano ŋinde ndimo. Ambo tamâta toŋge iponza noko gawula pinde, ande ara, kupulia gawula pinde kala ilâ papa tu iponza tona. ");
INSERT INTO xsi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ambo tamâta toŋge ikaino ilâ pa ŋgua nia tu ikai noko ne pasawaŋa saŋeno, ande ara, noko ne pasawaŋa kulua, aku ne pasawaŋa luandondo kulua tava. ");
INSERT INTO xsi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ambo Rom nenzi zugu tamâta toŋge ikaika pano tu pwale i ne kelekele ku pwoka kuku ikura nia mbuku taitu, ande ara, pwoka kuku ikura nia mbuku rua. ");
INSERT INTO xsi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ambo tamâta toŋge ino pano tu kelekele kulua, ande ara, ŋinde kulua. Ambo tamâta toŋge itu ikai kelekele toŋge saŋeno, aku ipaino tu muli i ma itu ŋana, ande ara, noko ma kupu muli papa i ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi tamâta tu, ‘Ŋgua tukuŋa keno mine: “Noko ma tini mwasa panzi noko ne ŋgu, aku wisi nâna panzi ne kazâŋa tamâta”.’ ");
INSERT INTO xsi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ambo taitu ŋine naŋa apaimi tu noko ma tini mwasa panzi ne kazâŋa tamâta, aku kuno pa Maro Kindeni tu ma ivilanzi tamâta ea siveta mâsi sakamao pano ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ambo noko ma kuveta mine, ande ŋinde ma itula pwataki tu noko nde Tamami Maro Kindeni imo samba ilo ŋinde natu. Ŋana tu i uru iveta ne kari ikâki imâ âta ŋana isinalanzi kinzi tamâta saka wa ara wa. Aku i uru iveta karâzi indue imâ panzi tamâta uru soka i ne ŋgua tukuŋa muli wa kinzi tamâta uru sipu mulinzi pa i ne ŋgua tukuŋa tona. ");
INSERT INTO xsi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ambo noko ma tini mwasa panzi tamâta uru tininzi mwasa pa noko, andeta noko ŋandai tini mwasa panzi tamâta pinde, ande Maro Kindeni ma kulu ara ndia ilano, a? Opopo, kinzi mbumbu-kaiŋa tamâta sakamao kala uru siveta mine wa! ");
INSERT INTO xsi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aku mine nâ, ambo noko uru kuporo ‘Kari ara’ panzi ninambwe nâ, ande noko ne vetâŋa ara imo ndia, a? Opopo, kinzi tinikoa tamâta uru siveta mine wa! ");
INSERT INTO xsi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Noko ma kuveta kie ara nâ panzi ninambwe wa ne kazâŋa tamâta wa, itogo noko tama Maro Kindeni imo samba ilo uru iveta mine.” ");
INSERT INTO xsi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ŋineŋga Yesu iporo ŋgua panzi kilo mine tu, “Noko kupakatona sondo ŋga. Noko ma kuveta ne vetâŋa ara lâ tamâta naonzi, ŋana ma simora wa sisuka noko ŋa kâki wa, mine ndimo. Ambo noko kuveta mine, ande noko tama Maro Kindeni imo samba ilo ma kulu toŋge ilano, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ambo noko kutu kelekele toŋge kulanzi sugorai tamwatanzi, ande noko ma kuveta ikura tamâta pinde uru siveta, mine ndimo. Kinzi kawanzi siporo ŋgua kie toŋge, aŋga ilonzi nde keno piti. Kinzi uru sisupwa tamâta toŋge imbana tando imuŋga panzi. Siveta mine lâ luma ŋana pasauŋa kâ ilo wa lâ nzâla wa. Kinzi situ tamâta ma sisuka warakanzi ŋanzi kâki ŋana nenzi vetâŋa kâ. Naŋa aporo mao nâ pami; kinzi ŋinde ma sikai kulu toŋge lâ Maro Kindeni mbau, ande tia ndo, ŋana tu kinzi ŋgu nenzi paneâŋa ŋinde nâ ma ipâŋga itogo nenzi kulu mwasina. ");
INSERT INTO xsi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aŋga noko, ambo noko kutu kuvilanzi sugorai tamwatanzi, ande ara ŋana noko mbau ŋâsi kâ ma izizâla ŋana vetâŋa ndia noko mbau wia kâ iveta. ");
INSERT INTO xsi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mine nde noko ne vetâŋa ara ma imo paveâŋa nâ. Noko tama Maro Kindeni isama ŋana vetâŋa paveâŋa kâ, ande kala i ma kulu ilano.” ");
INSERT INTO xsi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aku lâ zo ndia miki kakai noŋa, ande miki ma kaveta itogo tamâta pinde uru siveta, mine ndimo. Kinzi kawanzi siporo ŋgua kie toŋge, aŋga ilonzi nde keno piti. Kinzi ilonzi ndo tu simandi sikai noŋa lâ luma ŋana pasauŋa kâ ilo wa lâ nzâla pasiŋâni wa, ŋana ma tamâta simoranzi kâ. Naŋa aporo mao nâ pami; kinzi ma sikai kulu toŋge lâ Maro Kindeni mbau, ande tia ndo, ŋana tu kinzi ŋgu nenzi paneâŋa ŋinde nâ ma ipâŋga itogo nenzi kulu mwasina. ");
INSERT INTO xsi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aŋga noko, ambo noko kutu pwai noŋa, ande ara ŋana ma kulâ ne luma kisiŋa pwataki toŋge ilo ku kusae nzâla, ŋineŋga simbo nâ pwai noŋa pa tama Maro Kindeni. I uru imo nia paveâŋa, aku imora vetâŋa ndia ikeno paveâŋa. Ambo noko ma kuveta mine, ande i ma kulu ilano. ");
INSERT INTO xsi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aku lâ zo ndia noko pwai noŋa, ande noko ma kuveta ŋgua kapa-kapa luandondo itogo kinzi tinikoa uru siveta, mine ndimo. Kinzi ilonzi tu mambo siveta ŋgua luandondo, ande nenzi maro ma sipaloŋo pa nenzi ŋgua tâ. ");
INSERT INTO xsi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aŋga noko ma pwai noŋa ikura nenzi mâsi ŋinde ndimo. Ŋana tu lâ zo ndia noko kuno pa Tama Maro Kindeni tia yo, ande isama lâ ŋana kelekele ndia rârâni ikeno pano tia ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mine nde miki ma kakai noŋa mine; ‘Maka tamama uru kumo samba ilo, noko ŋa imo sapâŋa. ");
INSERT INTO xsi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kumo pwai maro ikura nia nia. Noko ne aŋelo simo samba ilo nde uru soka noko ne ŋgua muli; maka iloma tu tamâta rârâni simo tâno kulu ma siveta mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kama kaniŋa kulama ŋine kari. ");
INSERT INTO xsi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Maka nema kiesaka ikeno tinima, andeta kano pano tu kuzavaru ŋinde piti, ŋana tu maka muŋga kaveta mine nâ panzi tinima pinde. ");
INSERT INTO xsi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pwai samâŋa kaika toŋge imâ pa maka ndimo; pwaima piti lâ koroani saka nenzi koipu mbau ilo. Noko maro; noko tini walo; noko zuzuli tamwata; noko kumo mine ku kumo nâ. Mao.’” ");
INSERT INTO xsi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipainzi tu, “Miki kaloŋo ŋga; ambo tamâta toŋge iveta mâsi sakamao pano, andeta noko kuzavaru ne soki ŋinde piti lâ i tini, ande noko tama Maro Kindeni imo samba ilo kala ma izavaru noko ne kiesaka piti lâ noko tini mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Taitu kuloŋo ŋga; ambo noko kuzavaru soki ŋinde piti lâ tamâta ŋinde tini tia, ande noko tama Maro Kindeni ma izavaru noko ne kiesaka piti lâ noko tini, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Lâ zo ndia miki katu kaika ŋana kâpwa kâ, ŋana ma kakai noŋa kâ, ande miki ma kaveta naomi matami sakamao itogo tamâta pinde uru siveta, mine ndimo. Kinzi kawanzi siporo ŋgua kie toŋge, aŋga ilonzi nde keno piti. Kinzi uru siveta naonzi matanzi sakamao, ŋana kinzi tamâta ma sisama tu kinzi situ kaika ŋana kâpwa kâ. Naŋa aporo mao nâ pami, kinzi ma sikai kulu toŋge lâ Maro Kindeni mbau, ande tia ndo, ŋana tu kinzi ŋgu nenzi paneâŋa ŋinde nâ ma ipâŋga itogo nenzi kulu mwasina. ");
INSERT INTO xsi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aŋga noko, ambo noko kutu kaika ŋana kâpwa kâ, ande noko ma kuveta kulu pwau sondo wa kupua nao wa. ");
INSERT INTO xsi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ambo noko ma kuveta mine, ande kinzi tamâta ma sizizâla ŋana noko ne vetâŋa ŋana kutu kaika ŋana kâpwa kâ. Aŋga noko tama Maro Kindeni imo paveâŋa ŋinde, ande i simbo nâ ma isama. I uru imora vetâŋa ndia ikeno paveâŋa, ande kala i ma kulu ilano.” ");
INSERT INTO xsi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Miki ma kagona mbaliŋa arara lâ tâno ŋine kulu ndimo. Lâ tâno ŋine, ande nzirika wa take kana uru iyaula kelekele, aku kinzi panawe tamwatanzi uru sipu ŋgumbi pwapwataki ku sipanâwe. ");
INSERT INTO xsi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aŋga miki, ambo miki ma kaveta ikura naneŋgu ŋgua mine, ande Maro Kindeni ma iveta vetâŋa ara ndo pami lâ samba ilo. Lâ samba ilo, ande nzirika wa take kana ikura tu iyaula kelekele, ande tia; aku kinzi panawe tamwatanzi sikura tu sipu ŋgumbi pwapwataki ku sipanâwe, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lâ nia ndia miki nemi mbaliŋa arara ikeno, ande miki ma ilomi keno ndo pa nia ŋinde nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kinda matânda nde itogo sinâla pa kinda. Ambo noko mata ara, ande sinâla ma ipane noko ilo ndoni. ");
INSERT INTO xsi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ambo noko mata ŋaŋa, ande noko ilo ndoni ma imo ŋaŋa ndo. Mao nâ, ambo sinâla ikeno noko ilo ŋinde nde ipâŋga itogo kondoma mine, ande kondoma ŋinde ma ŋaŋa ndo.” ");
INSERT INTO xsi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tamâta toŋge ikura tu ikai wurâta panzi koipu rua ande tia, ŋana tu i ma wisi nâna pa toŋge, aŋga ma tini mwasa pa toŋge. Aku i ma ipono muli pa koipu toŋge, aŋga ma ipu muli pa toŋge. Miki kakura tu kao ilomi ilâ pa Maro Kindeni, aku kao ilomi ilâ pa mbaliŋa tona, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mine nde naŋa apaimi tu miki ma ilomi paŋgereŋa ŋana nemi via ku kaporo tu ‘Maka ma kaka kâpwa ndia wa kanu lââ ndia’, mine ndimo. Aku miki ma ilomi paŋgereŋa ŋana tinimi kala kaporo tu, ‘Maka ma kasawa pasawaŋa ndia’, mine ndimo. Ŋana tu nemi via ŋinde nde kelekele ŋalae tina kala ipole kâpwa, aŋga warakami tinimi kala ipole pasawaŋa mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ayo, miki kalomi ŋgere sondo ŋananzi sii kâ. Kinzi sii uru sipau kaniŋa vâsa, ande tia, aku uru sigona kâpwa kanaŋo sio lâ luma ŋana kâpwa kâ ilo, ande tia. Taitu miki tamami Maro Kindeni, ina imo samba ilo, ande uru kâpwa ilanzi sii ikura zo zo. Andeta Maro Kindeni ne romboŋa pa miki tamâta nde ŋalae tina, ipole i ne romboŋa panzi sii. ");
INSERT INTO xsi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aŋga noko ea pwura tu kuseŋge zo kiri-mwata toŋge pa zo ŋine kumo via lâ tâno kulu, a? Tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aku mana mana ŋga miki ilomi ŋalae ŋana pasawaŋa kâ, a? Kalomi ŋgere sondo ŋana mâle uru sipâŋga tâno ilo. Mâle ŋinde nde sipâŋga ku sio matanzi mâsi mana, a? Mâle uru siveta wurâta ŋana sisuta warakanzi nenzi pasawaŋa kâ, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ambo taitu naŋa apaimi tu mâle ne siŋgâra nde ara ndo, ipole Koipu Ŋalae Solomon ne siŋgâra arara rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Unza ŋinde ipâŋga tâno ilo lâ ŋine kari, andeta wurita kinzi tamâta ma silamo ku sirumbia lâ yââ ilo kana. Opopo, Maro Kindeni io siŋgâra ara ndo lâ unza kaa kaa ŋinde tini; mine nde i ma ikatona miki ŋana pasawaŋa tona. Miki nemi kalo-tawana nde mota mwata nâ! ");
INSERT INTO xsi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mine kala naŋa apaimi kilo tu miki ma ilomi rârâ ku kaporo tu, ‘Maka ma kaka kâpwa ndia, wa kanu lââ ndia, wa kasawa pasawaŋa ndia’, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kinzi tinikoa tamâta uru kalonzi loko ŋana kelekele ŋinde kâ, kala simo siroto ŋana. Andeta miki tamami Maro Kindeni, ina imo samba ilo, ande isama tu miki kandolo ŋana kelekele kie-kie ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mine nde miki ma kao ilomi ndo ilâ pa Maro Kindeni tu ikai maro pami, aku kapaveta kuku vetâŋa arara ndia itula pami ŋinde. Ambo miki ma kaveta mine, ande Maro Kindeni ma kelekele ndia ikeno pami tia ŋinde ilami tona. ");
INSERT INTO xsi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mine kala miki ma kalomi loko ŋana wurita kâ ndimo. Miki ma kakale wurita ne malia tava kari ŋine ne malia ndimo, ŋana tu malia pinde kie-kie ma ipâŋga ikura zo zo.” ");
INSERT INTO xsi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Noko ma kulea pa tamâta toŋge ne vetâŋa ndimo. Tia ma Maro Kindeni ilea kaika pa noko tamwata ne vetâŋa mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mao nâ, Maro Kindeni ma ilea pa noko ne vetâŋa lâ mâsi kie taituni itogo noko kala kuveta panzi tini pinde mine. ");
INSERT INTO xsi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mana mana ŋga noko kalo ŋgere ŋana kâi nzileŋa mwata ikeno noko ninambwe mata ilo, aŋga kuzizâla ŋana kâi mbuku ikeno noko tamwata mata ilo, a? ");
INSERT INTO xsi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ŋana sâ kâ ŋga noko uru kupai ninambwe tu, ‘Naŋa atu akai kâi nzileŋa mwata ŋinde piti lâ noko mata ilo’, andeta kâi mbuku ikeno noko tamwata mata ilo, a? ");
INSERT INTO xsi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Noko kawa kuporo ŋgua kie toŋge, aŋga ilo nde keno piti! Pwai kâi mbuku ikeno noko tamwata mata ilo ŋinde piti muŋga lâ, ŋineŋga noko ma pwura tu pwai kâi nzileŋa mwata piti lâ ninambwe mata ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yesu iporo ŋgua ŋine lâ, ŋineŋga isia ŋgua mine tu, “Kelekele sapâŋa, ande miki ma kalanzi mbwâmbwa ndimo. Tia ma sipupulia ku sikami warakami. Aŋga miki ma katambira nemi mbote-mbote arara ilâ panzi ŋgoa ndimo. Tia ma sipale lâ kenzi.” ");
INSERT INTO xsi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ambo miki kano pa Maro Kindeni, ande i ma ipaloŋo pa nemi noŋa. Ambo karoto ŋana i ne vetâŋa ara, ande ma kasânda kulu. Ambo kapitikina i ne nzâla, ande i ma ikai nzâla piti pami. ");
INSERT INTO xsi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ŋana tu tamâta ea ino pa Maro Kindeni, ande i ma ipaloŋo pa ne noŋa; tamâta ea iroto ŋana i kâ, ande ma isânda kulu; aŋga tamâta ea ipitikina nzâla, ande Maro Kindeni ma ikai nzâla piti papa. ");
INSERT INTO xsi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ambo noko natu toŋge ino pano tu kâpwa kulua, ande noko ma mira toŋge kulua, tiya? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ambo ino pano tu iŋa kulua, ande noko ma mwâta saka kulua, tiya? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Opopo, miki nde kiesaka tamwatami, ambo taitu miki uru kelekele ara nâ kalanzi natumi. Mine nde kalomi ŋgere sondo ŋga; miki tamami Maro Kindeni imo samba ilo, aku indeka ŋana kelekele ara ndo ilanzi tamâta ea sino papa i. ");
INSERT INTO xsi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mose ne ŋgua tukuŋa tava kinzi ŋgua-tulâŋa tamâta muŋgâŋa nenzi ŋgua rârâni nde ipâŋga kanaŋo lâ ŋgua ŋine tini: ‘Vetâŋa ndia miki ilomi tu kinzi tamâta ma siveta pa miki, ande miki ma kaveta vetâŋani ndaina pa kinzi.’” ");
INSERT INTO xsi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Nzâla toŋge ilâ pa zavaruŋa nia, aku nzâla ŋinde nde ŋalae tina. Mine nde kinzi tamâta ŋgu ŋalae ŋinde nde uru soka nzâla ŋinde. Aŋga nzâla toŋge ilâ pa via nia, aku nzâla ŋinde nde mota mwata nâ. Mine nde kinzi tamâta ŋgu kiri-mwata nâ sikura tu sisânda nzâla ŋinde kulu. Ayo, miki ma koka nzâla mota kala ilâ pa via nia ŋinde nâ kalâ.” ");
INSERT INTO xsi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Miki kapakatona sondo ŋananzi ŋgua-tulâŋa tamâta laŋeŋa kâ. Kinzi uru sitogonzi ‘lama’ kala naonzi mwasa nâ simâ pami. Ambo taitu kinzi kilalanzi mao nde mine: kinzi sitogonzi mbwâmbwa saka. ");
INSERT INTO xsi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ambo miki ma kalomi ŋgere sondo ŋana tamâta ŋinde nenzi vetâŋa kâ, ande ma kakura tu kasama ilonzi pwataki. Ŋana tu kâi wâka-wâka uru ipula kâi waini kanaŋo, ande tia, aŋga wâlo mata-mata uru ipula mbimu kanaŋo, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aku mine nâ, kâi ara rârâni nde uru sipula kanaŋonzi ara nâ, aŋga kâi sakamao nde uru sipula kanaŋonzi sakamao nâ. ");
INSERT INTO xsi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kâi ara ikura tu ipula kanaŋo sakamao ande tia, aŋga kâi sakamao ikura tu ipula kanaŋo ara, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kâi ndia uru ipula kanaŋo ara tia, ŋinde ma kinzi sitoto ku sitambira lâ yââ ilo ikana lâ. ");
INSERT INTO xsi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kinzi ŋgua-tulâŋa tamâta nde sitogo kâi. Mine kala, ambo miki ma kalomi ŋgere sondo ŋana nenzi vetâŋa kâ, ande miki ma kakura tu kasama ilonzi pwataki. ");
INSERT INTO xsi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kinzi tamâta rârâ sisarâwa pa naŋa tu, ‘Maro, Maro’. Taitu lâ zo muli, kinzi pinde ma simo Maro Kindeni ne ŋgumbi ilo, ande tia. Aŋga tamâta ea kinzi uru siveta ikura naŋa Mama imo samba ilo ne pateâŋa mine, kinzi ŋinde nâ ma simo i ne ŋgumbi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mao nâ, muli, lâ zo ŋinde naŋa ma amâ ŋana apare nia panzi tamâta rârâni, ande kinzi tamâta rârâ ma sisarâwa pa naŋa tu, ‘Maro, Maro, maka muŋga kakai noko ndamwa ku katula ŋgua wa kasokinzi koroani saka piti tamâta ilonzi wa kaveta mâsi ŋalaŋala rârâ wa!’ ");
INSERT INTO xsi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Andeta naŋa ma aporo ŋgua ipâŋga nia yo pa kinzi ŋinde mine tu, ‘Naŋa asama miki tia ndo. Miki nde sakamao tamwatami! Kakâwa kalâ!’” ");
INSERT INTO xsi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mine nde tamâta ea iloŋo naneŋgu ŋgua ŋine, aku taŋa mwasa nâ iyoka muli, ande i itogo ilo-kalo tamâta toŋge ipa ne luma kâki imandi tâno kaika kulu. ");
INSERT INTO xsi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Karâzi imbe ŋalae, aku sakuru pondi kâki, kala lawea iyoka kaika ndo itiŋgi luma ŋinde yâti taulo. Andeta luma ŋinde saputi ndue nde tia, ŋana tu ne ŋgunu-ŋgunu keno tâno kaika ilo. ");
INSERT INTO xsi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aŋga tamâta ea iloŋo naneŋgu ŋgua ŋine, andeta taŋa kaika ku tini pwâka tu iyoka muli, ande i itogo tamâta kapa toŋge ipa ne luma kâki imandi tâno mbariri kulu. ");
INSERT INTO xsi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Karâzi imbe ŋalae, aku sakuru pondi kâki, kala lawea iyoka kaika ndo itiŋgi luma ŋinde ilâ wa imâ wa. Ande kala luma ŋinde saputi ndue, ku ipayaula ndo lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu iporo ŋgua rârâni ŋine panzi marumbu lâ, ande kinzi tamâta rârâni wisinzi motutu ŋana i ne mâsi ŋana ipanananzi kâ. ");
INSERT INTO xsi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ŋana tu i ŋandai ipanananzi itogo nenzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru sipanananzi mine; ipanananzi itogo i tamwata ikai Maro Kindeni ndamwa kala iporo. ");
INSERT INTO xsi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu iyoka tuu ŋinde kulu indue imâ, aku tamâta rârâ soka kuku silâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Indue lâ, ŋineŋga tamâta toŋge, i tini saga-saga, nde imâ pa Yesu ipare tuku ku ipai tu, “Maro Ŋalae, ambo noko ilo tu kuveta mine, ande noko pwura tu kuveta naŋa tiniŋgu ipâŋga mbâra-mbâra”. ");
INSERT INTO xsi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aku Yesu isuŋa mbalau ilâ itaŋo tamâta ŋinde tini ku ipai tu, “Naŋa iloŋgu tu aveta mine; kala ŋine nâ noko kupâŋga mbâra-mbâra!” Aku ndainani nâ pukoŋa saga-saga ŋinde marumbu lâ tini, aku tamâta ŋinde ipâŋga tini mbâra-mbâra lâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ŋineŋga Yesu ipai mine tu, “Kuloŋo sondo ŋga; noko ma kutapâri pa tamâta toŋge ŋana vetâŋa kala ipâŋga pano ŋine ndimo. Kulâ kupatula tini pa patarawâŋa tamâta, aku kuveta patarawâŋa ŋana tini mbâra-mbâra kâ, ikura Mose ne ŋgua tukuŋa itula mine. Ambo noko ma kuveta mine, ande kinzi tamâta ma sisama tu noko ne pukoŋa nde marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu iyoka ilâ lee ipâŋga Kaperneam lawea. Ŋineŋga Rom zugu tamâta nenzi koipu toŋge nde imâ papa ku ino tu, ");
INSERT INTO xsi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Tamâta Ŋalae, naneŋgu wurâta tamâta toŋge ikai pukoŋa, kala ikeno luma. Pukoŋa ŋinde iveta i tini râki-râki ku tuka pââsââ lâ, aku ikai nâna ŋalae tina.” ");
INSERT INTO xsi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ŋineŋga Yesu iporo ŋgua taulo papa tu, “Ara, naŋa ma alâ aveta i tini ara kilo.” ");
INSERT INTO xsi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Andeta koipu ŋinde ipai tu, “Tamâta Ŋalae, mine tia. Naŋa nde tamâta kaa nâ; mine nde mana mana ŋga noko kutu kumâ naneŋgu luma ilo, a? Ambo noko ma kuporo lâ kawa nâ, ande naneŋgu tamâta ŋinde ma tini ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ŋana tu naŋa kala mine nâ uru aveta wurâta panzi tamâta ŋalaŋala pinde. Aku naŋa warakâŋgu akai poe panzi zugu tamâta ŋgu toŋge. Ambo naŋa apai toŋge tu, ‘Kulâ!’, ande ma ilâ. Ambo naŋa apai toŋge tu, ‘Kumâ!’, ande ma imâ. Ambo naŋa aporo pa naneŋgu wurâta tamâta toŋge tu, ‘Kuveta wurâta ŋine!’, ande i ma iveta.” ");
INSERT INTO xsi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu iloŋo Rom koipu ne ŋgua ŋinde, aku i wisi motu. Aku ipainzi tamâta soka kuku i ŋinde mine tu, “Opopo, tamâta ŋai nde tinikoa ma, andeta naŋa aporo mao nâ pami tu naŋa muŋga amora tamâta toŋge lâ Isrel ŋgu ne kalo-tawana irerege kuku tamâta ŋine ne kalo-tawana, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mine nde naŋa apaimi tu kinzi kalo-tawana tamâta rârâ ma soka pa tâno ndoni simâ, aku ma sisaŋona sika kunzi timbunda Abraham, Isaka, ŋga Yakopu, lâ zo ŋinde Maro Kindeni ma ikai maro panzi tamâta lâ tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aŋga kinzi Juda tamâta ŋinde muŋga Maro Kindeni isarawanzi tu simo i ne ŋgu, ande i ma iŋaranzi silâ pa nia kondoma. Aku lâ nia ŋinde kinzi ma sita ŋalae ku niŋonzi giri-giri ŋana sikai nâna kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu iporo ŋgua ŋinde lâ, ŋineŋga ipai koipu ŋinde mine tu, “Ayo, ŋine nâ noko kutaulo kulâ, aku vetâŋa ŋinde ma ipâŋga pano, ikura noko ne kalo-tawana mine”. Aku lâ kari tai ndainani nâ, koipu ŋinde ne wurâta tamâta ŋinde tini ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ŋineŋga Yesu iyoka ilâ Petero ne luma ilo, aku mata ilâ imora Petero ana taine ipoko ikeno ne kenoŋa nia, ikai pukoŋa ndamwa nâna. ");
INSERT INTO xsi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu ilâ ikai taine ŋinde mbau, aku ndainani nâ pukoŋa ipile i ilâ lâ. Ŋineŋga taine imandi ku isu kâpwa pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kari indue lala lâ, ŋineŋga kinzi tamâta lâ lawea ŋinde sikainzi tamâta rârâ ŋinde koroani saka sipakâe kunzi, aku simâ pa Yesu. Aku Yesu itu kaika panzi koroani saka ku iŋaranzi, kala sipilenzi tamâta ŋinde sikâwa silâ. Aku Yesu ivetanzi pukoŋa tamâta rârâni tininzi ara kilo tona. ");
INSERT INTO xsi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesu ne vetâŋa ŋinde nde iyoke Maro Kindeni kawa ŋgua toŋge muŋga io lâ ŋgua-tulâŋa tamâta Aisaia kawa. Aisaia iporo ŋgua mine tu, “I tamwata izavaru nenda pukoŋa kie-kie piti lâ tininda.” ");
INSERT INTO xsi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu mata ilâ imora tamâta ŋgu ŋalae tina simandi siŋge i lâ, kala ipainzi ne pâri-tamâta mine tu, “Kinda ma tambwaliu talâ pa lââ bwalika tini pinde”. ");
INSERT INTO xsi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ŋineŋga pananâŋa tamâta ŋana ŋgua tukuŋa kâ toŋge nde imâ pa Yesu ku ipai tu, “Pananâŋa, lawea ndia noko kutu kulâ papa, ande naŋa kala ma ayoka noko muli alâ”. ");
INSERT INTO xsi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Andeta Yesu iporo taulo tu, “Kinzi mbwâmbwa ŋgoi nenzi ŋgânza nde keno dugu ilo, aŋga kinzi sii nde palanzi keno tona. Aŋga naŋa Tamâta Natu nde niâŋgu toŋge ŋana akeno apwarea kâ, nde tia.” ");
INSERT INTO xsi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu iporo ŋgua ŋine lâ, ŋineŋga kalo-tawana tamâta toŋge ipai Yesu tu, “Maro Ŋalae, mwaŋga ŋga. Naŋa ma alâ akea naŋa mama muŋga lâ ŋga.” ");
INSERT INTO xsi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Andeta Yesu ipai tu, “Kalo loko. Kinzi mateŋa tamâta ma sipakea warakanzi nawalanzi. Aŋga noko kumâ, kupono muli pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ŋineŋga Yesu ikâki wâŋga toŋge kulu kunzi ne pâri-tamâta, aku simbwaliu silâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kinzi silâ lee sipâŋga lââ bwalika ŋgini, ŋineŋga walele nâ lawea iyoka more-more ŋalae aku ne kâla kâki iliŋi lâ wâŋga ilo. Aŋga Yesu nde ikeno utu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tia ku kinzi pâri-tamâta silâ sipaŋo Yesu ku sipai tu, “Maro Ŋalae, kuvilama tâ! Tia ma tambwatuke ku ma naonda tia lâ!” ");
INSERT INTO xsi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ŋineŋga Yesu ipainzi tu, “Miki nemi kalo-tawana nde kiri-mwata nâ! Ŋana sâ kâ ŋga miki karuru pâta, a?” Yesu iporo ŋgua ŋine lâ, ŋineŋga imandi ku itu ŋgua kaika pa lawea wa kâla wa. Aku walele nâ lawea imâte lâ, aku lââ pâti kii lâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kinzi pâri-tamâta simora ŋine ku ilonzi rârâ, aku sipakasoŋa warakanzi tu, “Opopo, tamâta ŋine nde tamâta mana kala iporo kaika pa kâla-lawea, aku kinzi kala sipaloŋo pa i kawa ŋgua!” ");
INSERT INTO xsi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ilâ itoa lâ Galilaya Lââ bwalika tini pinde, lâ kinzi Gadara nenzi tâno. Ŋineŋga tamâta rua simâ sipakâtu kuku Yesu. Koroani saka uru simo kinzi tamâta rua ŋinde ilonzi, ande kala rua uru simo potomule lâ ŋgânza ilo lâ kuru nia. Kinzi rua nde sipuli ŋgoi ndo; mine kala kinzi tamâta sikura tu soka nzâla ŋinde silâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ŋineŋga walele nâ kinzi rua sisarâwa kaika mine tu, “Maro Kindeni Natu, noko kutu kuveta mana pa maka. Maro Kindeni ne zo ŋana ipare nia panzi ne kazâŋa tamâta nde ipâŋga tia yo, andeta noko kumâ ŋana nâna kulua maka, a?” ");
INSERT INTO xsi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ande ŋgoa ŋgu ŋalae toŋge nde simo nia ŋinde, sipaŋuŋu sika simo malawae mwasa. ");
INSERT INTO xsi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aku koroani saka ŋinde sino Yesu mine tu, “Ambo noko kuŋara maka, ande maka iloma tu noko ma kuoma kalâ pa ŋgoa ŋinde ilonzi.” ");
INSERT INTO xsi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ŋineŋga Yesu isâu panzi ku ipainzi tu, “Kakâwa kalâ!” Aku walele nâ koroani saka sipilenzi tamâta rua ŋinde, aku silâ ŋgoa ilonzi. Aku ŋgoa ŋinde ndoni wisinzi motutu simaŋguru sipalilu kaika silâ sindue nia ndamwa toŋge. Ŋineŋga sisoŋga sindue lââ bwalika ilo sinu lââ ku sipamateteu marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kinzi katonâŋa tamâta ŋana ŋgoa kâ simora mâsi ŋinde, aku sipalilu silâ nenzi lawea ilo. Kinzi sitapâri panzi tamâta ŋana mâsi muŋga ipâŋga panzi ŋinde. Aku sitapâri panzi tona ŋana mâsi kala ipâŋga panzi tamâta rua ŋinde koroani saka muŋga simo ilonzi. ");
INSERT INTO xsi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kinzi tamâta ndoni lâ lawea ŋinde siloŋo pâri lâ, ŋineŋga rârâni simâ pa Yesu. Sipakâtu kuku, ŋineŋga sino kaika papa tu ma ipile nenzi ninia ku ilâ pa nia toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ŋineŋga Yesu ikâki wâŋga kulu ku imbwaliu ilâ pa lââ bwalika tini pinde. Ilâ lee itoa Kaperneam lawea, lawea ŋinde i uru imo. ");
INSERT INTO xsi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Itoa lâ, ŋineŋga tamâta pinde sikale pukoŋa tamâta toŋge simâ papa. Pukoŋa tamâta ŋinde kie-mbalau ndoni nde imâte lâ, kala ikeno rombe-rombe kulu. Yesu isama kinzi tamâta ŋinde kilalanzi pwataki tu nenzi kalo-tawana ikeno pa i. Mine kala ipai pukoŋa tamâta ŋinde tu, “Natuŋgu, noko wisi puu ndue. Naŋa azavaru noko ne kiesaka piti lâ tini.” ");
INSERT INTO xsi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde nde siloŋo Yesu ne ŋgua ŋinde, kala ilonzi ŋuru-ŋuru siporo pa warakanzi tu, “Yoo, tamâta ŋine nde itu ikai Maro Kindeni nia, kala iporo ŋgua ara tia ndo lâ Maro Kindeni nao!” ");
INSERT INTO xsi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu isama kinzi ilonzi kalonzi ŋinde lâ, kala ipainzi mine tu, “Ŋana sâ kâ ŋga ilo-kalo sakamao ŋinde ikeno miki ilomi, a? ");
INSERT INTO xsi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mao nâ, naŋa akura tu apai pukoŋa tamâta ŋine mine tu, ‘Naŋa azavaru noko ne kiesaka piti lâ tini’. Aku mine nâ, naŋa akura apai tu, ‘Noko kumandi sânda, ku pwoka kulâ’. Ayo, ŋgua ndia ma itula naneŋgu walo pwataki pami, a? ");
INSERT INTO xsi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Andeta naŋa iloŋgu tu miki ma kasama ŋine: naŋa Tamâta Natu akai Maro Kindeni ndamwa lâ tâno ŋine kulu, ikura ŋana azavaru kiesaka piti lâ tamâta tininzi tona.” Yesu iporo ŋgua ŋine panzi lâ, ŋineŋga ipai pukoŋa tamâta ŋinde tu, “Noko kumandi sânda, pwai ne rombe-rombe aku pwoka kulâ pa tamwata ne luma!” ");
INSERT INTO xsi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ŋineŋga tamâta ŋinde imandi ku iyoka ilâ pa ne luma. ");
INSERT INTO xsi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kinzi tamâta simora mâsi ŋinde, kala ilonzi rârâ. Mine nde sipanea Maro Kindeni, ŋana tu i ne walo ŋalae ikeno pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu iyoka ilâ, aku mata imora tamâta toŋge, i ŋa mine Matai. Matai nde uru iveta wurâta lâ Rom nenzi luma ŋana mbumbu kaiŋa kâ toŋge, kala isaŋona imo lumani ndaina ilo. Aku Yesu ipai tu, “Noko kumâ, kupono muli pa naŋa.” Ŋineŋga Matai imandi ku iyoka Yesu muli ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aku muli, zo toŋge, ŋineŋga Yesu ilâ Matai ne luma ilo ku isaŋona ika kâpwa kuku. Ande kinzi mbumbu-kaiŋa tamwatanzi ŋgu ŋalae sitavanzi kiesaka tamwatanzi pinde, kinzi rârâni simo luma ŋinde ilo sika kunzi Yesu ŋga ne pâri-tamâta. ");
INSERT INTO xsi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Andeta kinzi tamâta pinde lâ Parisai ŋgu nde simora ŋinde, ande kala sikasoŋanzi Yesu ne pâri-tamâta mine tu, “Wa, ŋana sâ kâ ŋga miki nemi pananâŋa ika kunzi tamâta sakamao ŋana mbumbu kaiŋa kâ wa kinzi kiesaka tamwatanzi wa, a?” ");
INSERT INTO xsi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu iloŋo nenzi ŋgua ŋinde, ŋineŋga ipainzi tu, “Kinzi tamâta tininzi ara uru silâ pa tamâta ŋana ivetanzi pukoŋa kâ, ande tia. Kinzi pukoŋa tamâta nâ uru silâ pa tamâta ŋana ivetanzi pukoŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Andeta Maro Kindeni ne ŋgua ikeno lâ pepa tini mine tu, ‘Naŋa tiniŋgu pwâka ŋana simbi ŋinde miki uru kapatarâwa pana. Taitu naŋa iloŋgu ndo tu miki ma kalomi sukâŋa ŋananzi tinimi pinde ku kasukanzi.’ Ara ŋana miki ma karoto ŋana ŋgua ŋinde ne duvi kâ. Naŋa ŋandai amâ tâno kulu ŋana asarawanzi kinzi vetâŋa ara warakanzi ŋga; naŋa amâ ŋana asarawanzi kinzi kiesaka tamwatanzi.” ");
INSERT INTO xsi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ŋinde ilâ lâ, ŋineŋga Yoane Lââ-Liliŋa Tamwata ne pâri-tamâta pinde simâ pa Yesu, aku sipai tu, “Maka uru katu kaika ŋana kâpwa kâ, ŋana ma kakai noŋa kâ, aku kinzi tamâta lâ Parisai ŋgu kala uru siveta mine tona. Mine nde mana mana ŋga noko ne pâri-tamâta uru siveta mâsi ŋine tia, a?” ");
INSERT INTO xsi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ŋineŋga Yesu itu lâ kawanzi aku isia ŋgua lâ tamwata tini mine tu, “Ambo tamâta toŋge itu ikâe kâ, ande i ninambwe kinzi ma ilonzi malia lâ zo ŋinde i imo kunzi yo, ande ma tia. Taitu muli, lâ zo ŋinde kinzi ma sikai pakâeŋa tamâta ŋinde piti lâ ninambwe ŋgininzi silâ, ŋineŋga lâ zoni ndaina kinzi ma kalonzi sukâŋa ŋalae, aku ma situ kaika ŋana kâpwa kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ŋineŋga Yesu iporo tu, “Kinzi tamâta uru sisaraka lalava wasaseki katiŋe ku sisuta ipono pasawaŋa siŋga râge-râge, ande tia. Ambo siveta mine, ande lalava ŋana ipono pasawaŋa râge-râge ŋinde ma ipasaŋgu ku isaraka pasawaŋa kilo, kala ma râge-râge ipwa ŋalae tina kilo. ");
INSERT INTO xsi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aŋga kinzi tamâta uru siwuwu waini waseki lâ ŋgoa karae patu siŋga ilo, ande tia. Ambo siveta mine, ande waini ma ipondi kâki ku ma iveta ŋgoa karae patu siŋga ipwa pwataki. Ŋineŋga waini ma imaliŋi kaa nâ indue lâ tâno kulu, aku ŋgoa karae patu kala ma ipâŋga sakamao tona. Kinzi tamâta uru siwuwu waini waseki lâ ŋgoa karae patu wasaseki nâ ilo, ande kala ruani ma keno sondo.” ");
INSERT INTO xsi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu iporo ŋgua ŋine panzi tamâta marumbu tia yo, ande luma ŋana pasauŋa kâ ne katonâŋa tamâta toŋge iyoka imâ laiti. Ipare tuku papa Yesu ku ipai tu, “Naŋa natuŋgu taine ŋineni ŋga imâte lâ. Taitu naŋa asama tu ambo noko ma kumâ kuo mbau lâ i kulu, ande i ma imo via kilo.” ");
INSERT INTO xsi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ŋineŋga Yesu imandi aku iyoka kuku katonâŋa ŋinde ilâ, aku Yesu ne pâri-tamâta nde soka kunzi silâ tona. ");
INSERT INTO xsi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Andeta taine toŋge imo ndaina, i uru tini mâta ikai see ikura zo zo lee mbwera saŋao kanaŋo rua lâ. Aku ndainani nâ taine ŋinde iyoka pa Yesu muli imâ laiti, aku mbau ilâ itaŋo Yesu ne pasawaŋa luandondo ŋgaŋe. ");
INSERT INTO xsi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I ne vetâŋa ŋinde nde duvi mine; muŋga i taine ilo patea tu, “Ambo naŋa mbauŋgu ataŋo i ne pasawaŋa ŋgaŋe nâ, ande ma tiniŋgu ara kilo”. ");
INSERT INTO xsi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mine kala mbau ilâ itaŋo Yesu ne pasawaŋa ŋgaŋe. Ŋineŋga Yesu itale ku mata ilâ imora taine ŋinde, aku ipai tu, “Natuŋgu, noko wisi puu ndue; noko ne kalo-tawana ŋinde iveta noko tini ara lâ.” Aku ndainani nâ, taine ŋinde tini ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ŋineŋga Yesu iyoka ilâ katonâŋa ŋinde ne luma ilo, aku mata ilâ imoranzi tamâta pinde simbana kauro ŋana mateŋa kâ, aku imoranzi ŋgu ŋalae sita wa siveta nia nduŋeŋa ŋalae tina. ");
INSERT INTO xsi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Andeta Yesu ipainzi tu, “Kaveta mine ndimo! Lâlu taine ŋine imâte tia; ikeno mata nâ.” Andeta kinzi siŋelea i pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mine kala Yesu ionzi siyâti silâ pa nia yo marumbu lâ, ŋineŋga ilâ luma ilo kisiŋa pwataki ŋinde ilo. Aku ikai taine taipa mbau, ŋineŋga taine imandi sânda imo via kilo. ");
INSERT INTO xsi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aku pâri ŋinde nde ilâ ikura nia ŋinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ipile luma ŋinde aku iyoka ilâ. Andeta tamâta rua matanzi leva-leva nde sitawa i simâ, aku kawanzi ŋalae sisasarâwa papa mine tu, “Noko Daviti ne vâsa, kalo sukâŋa ŋanama!” ");
INSERT INTO xsi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu iyoka ilâ ne luma ilo, ŋineŋga tamâta rua ŋinde simâ papa. Aku Yesu ikasoŋanzi tu, “Mana mana; miki rua kalomi tawana tu naŋa akura ŋana aveta matami ara kilo, tiya?” Kinzi rua nde siporo taulo tu, “Tamâta Ŋalae, maka kaloma tawana mine”. ");
INSERT INTO xsi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ŋineŋga Yesu io mbau lâ kinzi rua matanzi ku ipainzi tu, “Miki nemi kalo-tawana ikeno pa naŋa; mine kala vetâŋa miki ilomi papa ŋine, ande ma ipâŋga pami mine nâ”. ");
INSERT INTO xsi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aku ndainani nâ kinzi rua matanzi pareŋge simora kilo. Ŋineŋga Yesu iporo itu kaika panzi rua mine tu, “Miki rua ma katapâri pa tamâta toŋge ŋana vetâŋa ŋine ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Andeta muli, kinzi rua siyâti silâ, ŋineŋga situla Yesu parina panzi tamâta ikura nia ndoni. ");
INSERT INTO xsi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kinzi rua simandi ŋana sipile Yesu siyâti silâ, ŋineŋga tamâta pinde sikai tamâta toŋge imâ pa Yesu. Koroani saka toŋge muŋga ipakâe kuku tamâta ŋinde, kala iveta i kawa pasâe lâ. ");
INSERT INTO xsi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ŋineŋga Yesu isoki koroani saka ŋinde ikâwa ilâ lâ, aku tamâta ŋinde muŋga kawa pasâe nde iporo ŋgua kilo. Kinzi tamâta simora mâsi ŋinde kala wisinzi motutu lâ, aku siporo mine tu, “Opopo, vetâŋa toŋge kie mine muŋga ipâŋga lâ kinda Isrel ŋgininda, ande tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Andeta kinzi tamâta pinde lâ Parisai ŋgu nde siporo ŋgua pavaligiŋa mine tu, “Yoo, ikai koroani saka nenzi koipu ne walo, kala isokinzi koroani saka piti lâ tamâta ilonzi”. ");
INSERT INTO xsi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu iyoka ilâ ikura lawea ndoni ikeno Galilaya tâno. I uru ipanananzi tamâta lâ nenzi luma ŋana pasauŋa kâ ilo, ku itula pâri ara panzi ŋana Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ. Aku kinzi pukoŋa tamâta rârâni, kinzi ŋinde simo tava pukoŋa kie-kie, ande ivetanzi tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu mata ilâ imoranzi tamâta ŋgu ŋalae simo nia ŋinde, aku i kalo sukâŋa ŋananzi, ŋana tu kinzi walonzi tia ku sikura tu sipavila warakanzi, ande tia. Kinzi simo sitogonzi “lama” ŋgu, nenzi katonâŋa tamâta tia. ");
INSERT INTO xsi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mine kala Yesu itambira ŋgua panzi ne pâri-tamâta mine tu, “Kâpwa maria ndo keno tâno ilo, andeta wurâta tamâta ŋana sikai kâpwa kâ nde kambwaŋenzi mota mwata. ");
INSERT INTO xsi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mine nde miki ma kakai noŋa kano pa Maro Kindeni, ina tâno ŋine warika, ŋana ma ionzi wurâta tamâta pinde silâ sisukami ŋana kagona i ne kâpwa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu isarawanzi ne pâri-tamâta saŋao kanaŋonzi rua simâ, ŋineŋga i walo kaika ilanzi ŋana sisokinzi koroani saka wa siveta tamâta nenzi pukoŋa kie-kie rârâni tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kinzi pâri-tamâta saŋao kanaŋonzi rua ŋinde ŋanzi ande mine: Saimon, i ŋa toŋge Petero, tava i tai Andaria; aŋga Yamesi, i Sebedi natu, tava i tai Yoane; ");
INSERT INTO xsi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","aŋga Pilip ku Bartolomyu rua; aŋga Tomas, aŋga Matai, i muŋga uru iveta wurâta ŋana mbumbu kaiŋa kâ; aŋga Yamesi, i Alfius natu, aŋga Tadius; ");
INSERT INTO xsi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","aŋga Saimon Selot, aŋga Judas Iskariot, i muli ikai kulu-pâŋga ŋana Yesu kâ, ku io i lâ kinzi kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ŋineŋga Yesu ionzi ne pâri-tamâta saŋao kanaŋonzi rua silâ. Aku ipainzi tu, “Miki ma kalâ pa kinzi tinikoa ŋgu nenzi ninia ndimo, aku kalâ kinzi Samaria ŋgu nenzi lawea ilo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Miki ma koka sondo kalâ panzi tamâta lâ Isrel ŋgu nâ. Kinzi ŋgu ŋinde nde sitogo ‘lama’ ŋgu, sisapiri kala soka potomule siroroto ŋana nzâla kâ. ");
INSERT INTO xsi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Miki kalâ katula ŋgua panzi mine tu, ‘Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ, ande imâ ipâŋga laiti lâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Miki kalâ kavetanzi pukoŋa tamâta tininzi ara kilo; aku kapaŋonzi mateŋa tamâta wa kavetanzi tamâta tininzi saga-saga ipâŋga mbâra-mbâra wa kasokinzi koroani saka piti lâ tamâta ilonzi wa. Naŋa muŋga walo kaika alami ŋana kaveta mâsi kie-kie ŋinde, aku miki ŋandai mbumbu toŋge kalua naŋa ŋana kakai walo ŋinde ŋga. Mine kala lâ zo ŋana miki ma kaveta mâsi ŋinde panzi tamâta, ande miki ma kakai mbumbu ŋana ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aku miki ma kazeze mbumbu pinde lâ nemi tâŋa ilo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mao nâ, lâ zo ŋana miki koka kâ, ande miki ma kakai keta wa pasawaŋa rua wa kemi kâmba wa tukâla ŋana yokâŋa kâ ndimo. Ara ŋana kinzi tamâta ma kelekele ŋinde silua tamâta ea iveta wurâta panzi. ");
INSERT INTO xsi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ambo miki koka kalâ lawea toŋge ilo, ande miki ma kalâ karoto ŋana tamâta ea lâ lawea ŋinde ma ilo ara pami. Ambo kasânda tamâta kulu, ande miki ma kamo ndaina kuku tamâta ŋinde lee, ikura lâ zo ŋana miki kapile lawea ŋinde kalâ. ");
INSERT INTO xsi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ambo miki kalâ luma toŋge ilo, ande kaporo wisi-ara ne ŋgua panzi tamâta simo luma ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ambo kinzi tamâta simo luma ŋinde ma ilonzi ara nâ pami, ande kano pa Maro Kindeni tu ma itu nzâmbe panzi. Taitu kaloŋo ŋga; ambo kinzi ilonzi ara pami tia, ande kakai noŋa kilo tu Maro Kindeni ne nzâmbe ma piti lâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ambo kinzi tamâta rârâni lâ luma toŋge tâku lawea toŋge nde tininzi pwâka tu sikaimi kamo kunzi, aku tininzi pwâka tu siloŋo nemi ŋgua, ande miki ma kapilenzi, ŋineŋga kapamasi kemi tâno gawura piti, ŋana itula nenzi vetâŋa soki ŋinde pwataki. ");
INSERT INTO xsi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Naŋa aporo mao nâ pami; lâ zo muli, Maro Kindeni ma ionzi tamâta rârâni lâ i ne ŋgua nia. Aku pa zo ŋinde, kinzi tamâta lâ lawea ŋinde ma sikai nâna ŋalae tina, ipole nâna ndia kinzi tamâta sakamao muŋga simo Sodom lawea ŋga Gomora lawea ŋinde ma sikai.” ");
INSERT INTO xsi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu iporo ŋgua ŋine panzi ne pâri-tamâta lâ, ŋineŋga ipainzi tu, “Miki kaloŋo ŋga; naŋa aomi kalâ katogonzi ‘lama’ kamo mbwâmbwa saka ŋgininzi. Mine nde miki ma kaŋgeŋge ŋana kazâŋa kâ, itogo mwâta uru iveta mine; aku kamo naomi mwasa nâ, itogo sii bâlu uru imo mine. ");
INSERT INTO xsi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Miki kapakatona sondo ŋga, ŋana tu kinzi tamâta pinde ma sikaimi kaika ku siomi lâ ŋgua nia, aku ma sipalilimi pâta lâ nenzi luma ŋana pasauŋa kâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kinzi ma ilonzi tu sitawa naŋa ŋâŋgu ndue, ande kala ma sikaimi kalâ panzi tamâta mbâna-mbâna wa koipu ŋalaŋala wa. Lâ zo ŋinde, miki ma katula pâri ara ŋana naŋa kâ pwataki panzi Juda tamâta wa kinzi tinikoa wa. ");
INSERT INTO xsi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ambo siomi kalâ pa ŋgua nia, ande miki ma karuru ku kalomi loko tu, ‘Maka ma kaporo ŋgua mana’, mine ndimo. Ŋana tu lâ zoni ndaina, Maro Kindeni ma itula ŋgua pami tu katula kâ. ");
INSERT INTO xsi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aku ŋgua miki ma katula panzi ŋinde nde warakami nemi ŋgua, ande tia. Miki tamami Maro Kindeni ne Koroani Sapâŋa tamwata ma io ŋgua ŋinde lâ kawami. ");
INSERT INTO xsi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Lâ zo ŋinde, kinzi tamâta ma sio ninzi-nambwe lâ ŋgua nia, aku ma sipunzi pâta simâte. Aku tamâta ma siveta mine nâ pa warakanzi natunzi tona. Aŋga kinzi lâlu ma sikai kazâŋa kie taituni panzi tinanzi-tamanzi tava, kala ma sionzi lâ kazâŋa tamâta mbaunzi ilo tu ma sipunzi pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kinzi tamâta ndoni ma wisinzi nâna ndo pa miki, ŋana tu miki kalomi tawana naŋa. Andeta tamâta ea kalo tawana naŋa kaika lee ilâ ipâŋga lâ keri, ande Maro Kindeni ma via mao ilua i. ");
INSERT INTO xsi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ambo kinzi tamâta lâ lawea toŋge ma siveta malia pami, ande kakâwa kalâ pa lawea toŋge. Naŋa aporo mao nâ pami; miki ma kaveta wurâta ŋine kakura Isrel nenzi lawea rârâni marumbu tia yo, ŋineŋga naŋa Tamâta Natu ma amâ.” ");
INSERT INTO xsi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Kinzi pepa tamâta nenzi ilo-kalo ŋandai ipole nenzi pananâŋa tamâta ne ilo-kalo ŋga; aku mine nâ, kinzi wurâta tamâta ŋandai simo nenzi tamâta ŋalae kulu ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mine nde vetâŋa ndia kinzi siveta pa pananâŋa tamâta, ande ma siveta mine nâ panzi i ne pepa tamâta tona; aŋga vetâŋa ndia siveta pa tamâta ŋalae, ande ma siveta mine nâ panzi i ne wurâta tamâta. Ambo kinzi tamâta pinde uru sipatu tamâta ŋalae toŋge ŋa tu Belsebul (i ŋa toŋge Sadana), ande kinzi ma siporo ŋgua sakamao ndo ŋananzi tamâta uru sipono muli papa i ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Mine nde miki ma karuru ŋananzi nemi kazâŋa tamâta ndimo. Ŋgua ndia rârâni ikeno paveâŋa, ŋinde miki ma katula pwataki ipâŋga nia yo, ŋana kinzi tamâta ma sisama ŋgua rârâni ne duvi. ");
INSERT INTO xsi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mao nâ, ŋgua ndia rârâni naŋa aporo pami lâ nia ŋgaŋe, ŋinde miki ma katula ipâŋga nia yo. Aku ŋgua ndia rârâni muŋga taporo imo ŋgininda nâ, ŋinde miki ma kamandi lâ luma kulu âta aku kawami ŋalae katula pwataki. ");
INSERT INTO xsi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Miki ma karuru ŋananzi kazâŋa tamâta ndimo, ŋana tu kinzi sikura tu sipu karaemi nâ pâta imâte, taitu sikura tu sipu koranami pâta imâte, ande tia. Ambo taitu miki ma karuru ŋana Maro Kindeni, ŋana tu i simbo nâ ikura tu izavaru karaemi wa koranami lâ yââ ŋalae ne mbââ ilo. ");
INSERT INTO xsi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Miki kasama tu kinzi tamâta uru sikonzi sii kiri-kiri rua lâ mbumbu taitu nâ. Mine nde kasama tu sii nde itogo kelekele kaa nâ. Andeta miki tamami Maro Kindeni uru ikai katonâŋa sondo panzi sii ŋinde. Mao nâ, ambo i ma isâu tia, ande sii toŋge ma ikura tu imbe ndue ipu tâno, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aku mine nâ, Maro Kindeni isama lâ ŋana miki nemi moŋa wa vetâŋa wa. Opopo, kulu pwau ŋapia keno kulumi, ande isama ŋine wa! ");
INSERT INTO xsi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mine nde miki ma karuru ndimo, ŋana tu lâ Maro Kindeni nao, ande miki nde kelekele ara ndo, kapolenzi sii ndoni marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tamâta ea itula ne ilo-kalo pwataki lâ nia yo tu i kalo tawana naŋa, ande muli naŋa kala ma atula ŋgua pwataki papa naŋa Mama lâ samba lawea mine tu, ‘Tamâta ŋine nde naneŋgu tamâta’. ");
INSERT INTO xsi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aŋga tamâta ea itula ne ilo-kalo pwataki lâ nia yo tu i kalo tawana naŋa tia, ande muli naŋa kala ma atula ŋgua pwataki papa naŋa Mama lâ samba lawea mine tu, ‘Tamâta ŋine nde naneŋgu tamâta tia’.” ");
INSERT INTO xsi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Miki ma ilomi tu naŋa amâ ŋana apupu paraŋa rârâni lâ tâno kulu, mine ndimo. Naŋa ŋandai amâ ŋana apupu paraŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Naŋa amâ ŋana aveta kazâŋa ne mâsi ipâŋga. Mao nâ, ‘Natu tamâne ma ikai kazâŋa pa tama, aŋga natu taine ma ikai kazâŋa pa tina, aŋga lawa ma ikai kazâŋa pa ana. ");
INSERT INTO xsi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamâta see kinzini ma sipâŋga simo i ne kazâŋa tamâta.’ ");
INSERT INTO xsi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ambo tamâta toŋge ne tini-mwasa panzi tina-tama ipole ne tini-mwasa pa naŋa, ande i ma ikura tu imo naneŋgu tamâta, ande tia. Aku mine nâ, ambo tamâta toŋge ne tini-mwasa panzi natu ipole ne tini-mwasa pa naŋa, ande i ma ikura tu imo naneŋgu tamâta, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aku mine nâ, ambo tamâta toŋge tini pwâka tu ikale i ne kâi popole ku iyoka naŋa muliŋgu, ande i ma ikura tu imo naneŋgu tamâta, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tamâta ea ilo ŋalae ŋana tamwata ne via lâ tâno kulu, ande i ma ikura tu ikai via mao, ande tia. Aŋga tamâta ea kalo tawana naŋa kala ipatawa tini ku imora tamwata ne via tu kelekele kaa nâ, ande i ma isânda ne via mao kulu.” ");
INSERT INTO xsi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tamâta ea iveta kie ara pa miki, ande iveta kie ara pa naŋa tona. Aku tamâta ea iveta kie ara pa naŋa, ande iveta kie ara pa Maro Kindeni tona, ina muŋga isupwa naŋa kala amâ. ");
INSERT INTO xsi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ambo tamâta toŋge ilo ara panzi Maro Kindeni ne ŋgua-tulâŋa tamâta, kala iveta kie ara pa toŋge, ande tamâta ŋinde ma ikai ne kulu, itogo kulu ŋinde kinzi ŋgua-tulâŋa tamâta uru sikai mine. Aku mine nâ, ambo tamâta toŋge ilo ara panzi tamâta ŋinde uru sipono muli pa Maro Kindeni, ande kala iveta kie ara pa toŋge, ande i ma ikai ne kulu, itogo kulu kinzi tamâta uru sipono muli pa Maro Kindeni ŋinde uru sikai mine. ");
INSERT INTO xsi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Naŋa aporo mao nâ pami; ambo tamâta toŋge ilo ara panzi kalo-tawana tamâta, kala iliŋi lââ vâra-vâra lâ kâmba ilo ku ilua naneŋgu tamâta toŋge tu inu kâ, ande Maro Kindeni ma kulu ilua tamâta ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu iporo ŋgua ŋine panzi ne pâri-tamâta saŋao kanaŋonzi rua marumbu lâ, ŋineŋga ipile lawea ŋinde ku ilâ pa lawea pinde ikeno Galilaya tâno, ku ipanananzi tamâta ku itula Maro Kindeni kawa ŋgua panzi. ");
INSERT INTO xsi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aŋga Yoane Lââ-Liliŋa Tamwata nde imo luma sakamao ilo, ande iloŋo Yesu Kirisi parina tu iveta mâsi kie-kie ŋinde. Mine kala Yoane ionzi ne pâri-tamâta pinde silâ pa Yesu, ");
INSERT INTO xsi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ŋana ma sikasoŋa i mine tu, “Tiambo nokoni kala tamâta ŋinde Maro Kindeni muŋga ipa ŋgua tu ma isupwa imâ, tiya?, ma kao tinima ŋana tamâta toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ŋineŋga Yesu itu ŋgua taulo panzi tu, “Miki kataulo kalâ katapâri pa Yoane ŋana vetâŋa wa mâsi kie-kie miki kaloŋo ku kamora ŋine: ");
INSERT INTO xsi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kinzi tamâta muŋga matanzi leva-leva ande simora nia, aŋga kinzi tamâta muŋga kenzi sakamao nde soka nzâla silâ. Kinzi tamâta muŋga tininzi saga-saga nde sipâŋga tininzi mbâra-mbâra lâ, aŋga kinzi tamâta muŋga taŋanzi pasâe nde siloŋo ŋgua. Kinzi mateŋa tamâta nde simandi simo vianzi kilo, aŋga kinzi sugorai tamwatanzi nde siloŋo pâri ara. ");
INSERT INTO xsi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tamâta ea ikai nâna ŋana ne kalo-tawana kâ, ambo i ma imandi kaika ku ipono muli sondo pa naŋa, ande Maro Kindeni ne nzâmbe ma ikeno papa i.” ");
INSERT INTO xsi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoane Lââ-Liliŋa Tamwata ne pâri-tamâta ŋinde nde silâ lâ, ŋineŋga Yesu iporo ŋgua panzi tamâta ŋgu simo kuku i ŋinde. Ipainzi tu, “Miki muŋga kalâ pa nia bilimu ŋana kaloŋo Yoane Lââ-Liliŋa Tamwata ne ŋgua, aku lâ zo ŋinde miki kalâ tu kamora sâ. Tiambo miki kalâ tu kamora kuli toŋge, lawea itili ilâ wa imâ wa, tiya? Mine tia. ");
INSERT INTO xsi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mine nde miki kalâ tu kamora sâ. Tiambo miki kalâ tu kamora tamâta toŋge uru isiŋga pasawaŋa arara, tiya? Mine tia. Kinzi tamâta uru sisiŋga pasawaŋa arara ŋinde nde simo koipu ŋalaŋala nenzi luma nâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mine kala miki kalâ tu kamora sâ. Tiambo miki kalâ tu kamora ŋgua-tulâŋa tamâta toŋge, tiya? Mao nâ, miki kalâ tu kamora ŋgua-tulâŋa tamâta toŋge. Andeta miki ŋandai kamora ŋgua-tulâŋa tamâta kaa nâ ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mao nâ, kinzi ŋgua-tulâŋa tamâta muŋgâŋa nde sikai Maro Kindeni kawa ŋgua, ŋineŋga siŋgere ŋgua ŋana Yoane lâ pepa tini mine tu, ‘Kuloŋo ŋga; naŋa ma ao naneŋgu ŋgua-tulâŋa tamâta toŋge ilâ imuŋga pano. I ma iveta nzâla sondo pa noko.’ ");
INSERT INTO xsi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Naŋa aporo mao nâ pami; ikura zo muŋgâŋa rârâni, ande tamâta toŋge imo tamâta ŋalae kala ipole Yoane Lââ-Liliŋa Tamwata, ande tia ndo. Ambo taitu miki kaloŋo ŋga; lâ ŋgu ŋine Maro Kindeni ikai maro papa, tamâta ea imo kinzi tamâta rârâni kalonzi, ande i imo tamâta ŋalae, kala ipole Yoane. ");
INSERT INTO xsi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Muŋga, lâ zo ŋinde Yoane Lââ-Liliŋa Tamwata imandi ŋana iveta ne wurâta, aku imâ lee ipâŋga lâ zo ŋine kala tamo ŋine, ande kinzi kazâŋa tamâta nde sipara kaika ku sitogo tu sipono nzâla ŋana Maro Kindeni ma ikai maro panzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mao nâ, siŋgani, aku imâ lee ipâŋga lâ Yoane Lââ-Liliŋa Tamwata ne zo, ande Mose ne ŋgua tukuŋa aŋga kinzi ŋgua-tulâŋa tamâta rârâni nde situla ŋgua ŋana Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aku miki ea ilomi tu kalomi tawana nenzi ŋgua ŋinde, ande miki kaloŋo ŋga; Yoane nde ikai Ilia nia, ina ŋgua-tulâŋa tamâta muŋgâŋa ŋinde kinzi siporo tu ma itaulo imâ kilo. ");
INSERT INTO xsi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo. ");
INSERT INTO xsi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ayo, naŋa ma aporo asia ŋgua mana ŋana vetâŋa kinzi tamâta uru siveta lâ zo ŋine. Kinzi nde sitogonzi lâlu kiri-kiri, ilonzi kalonzi soki-soki sisaŋona ao ŋgini ku sisarâwa pa nawalanzi tu, ");
INSERT INTO xsi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Opopo, maka kambana kauro ŋana miki ma kakina kiniŋa, andeta miki tinimi pwâka tu kaki. Aŋga maka kawâŋgi wâŋgiŋa kalo-kalo kâ, andeta miki tinimi pwâka tu kata.’” ");
INSERT INTO xsi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ŋineŋga Yesu iporo ŋgua siâŋa ŋine ne duvi pwataki panzi tu, “Yoane Lââ-Liliŋa Tamwata uru indi kaika pa tamwata ŋana kâpwa wa waini wa, andeta kinzi sivaligi i mine tu, ‘Koroani saka imo kuku i!’ ");
INSERT INTO xsi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aŋga naŋa Tamâta Natu uru aka wa anu wa, andeta kinzi sivaligi naŋa mine tu, ‘Kamora ŋga, i tamâta ŋana ika kâpwa wa inu waini ŋalae tina. Aku iveta mete kunzi tamâta sakamao ŋana mbumbu kaiŋa kâ wa kinzi kiesaka tamwatanzi wa!’ Andeta Maro Kindeni uru iwae wurâta sondo ndo panzi ne tamâta, kala miki kamora kanaŋo pwataki lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu muŋga iveta mâsi ŋalaŋala rârâ ŋinde lâ lawea pinde, andeta kinzi tamâta lâ lawea ŋinde ŋandai sipalele ilonzi kalonzi ŋga. Mine kala Yesu iporo ŋgua kaika ŋananzi tamâta ŋinde mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Oyae, miki tamâta lâ Korasin lawea! Oyae, miki tamâta lâ Betsaida lawea! Malia ŋalae tina ma imâ pami! Ambo naŋa muŋga aveta mâsi ŋalaŋala panzi kiesaka tamwatanzi simo Tair lawea ŋga Saidon lawea, itogo naŋa muŋga aveta lâ miki nemi lawea mine, ande nanayoni kinzi tamâta ŋinde ma sipasawa pasawaŋa siŋga wa sio kââ lâ kulunzi wa, ŋana itula ilonzi pwataki tu kinzi sipalele ilonzi kalonzi ilâ pa naŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Andeta naŋa aporo mao nâ pami; lâ zo ŋana Maro Kindeni ma ionzi tamâta silâ pa i ne ŋgua nia, ande kinzi tamâta lâ Tair wa Saidon nde ma sikai nâna, aŋga miki ma kakai nâna ŋalae tina! ");
INSERT INTO xsi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aŋga miki tamâta lâ Kaperneam lawea, miki katu kapasuka warakami tinimi ku kakâki kalâ pa samba lawea, a? Tia ndo! Maro Kindeni ma itambirami kalâ kandue yââ ŋalae ne mbââ ilo! Ambo lâ nia ndoyo naŋa aveta mâsi ŋalaŋala panzi kiesaka tamwatanzi lâ Sodom lawea, itogo naŋa muŋga aveta lâ miki nemi lawea mine, ande Sodom lawea ma keno mo ŋai yo, ma zavaruŋa tia. ");
INSERT INTO xsi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Andeta naŋa aporo mao nâ pami; lâ zo ŋana Maro Kindeni ma ionzi tamâta silâ pa i ne ŋgua nia, ande kinzi tamâta lâ Sodom ma sikai nâna, aŋga miki ma kakai nâna ŋalae tina!” ");
INSERT INTO xsi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesu iporo ŋgua ŋine lâ, ŋineŋga ikai noŋa pa Maro Kindeni mine tu, “O, Mama, noko uru pwai maro pa samba wa tâno wa. Naŋa kawâŋgu ndaŋge pano, ŋana tu noko kuvea ilo-kalo ŋinde ŋananzi ilo-kalo tamwatanzi, andeta kutula pwataki panzi tamâta ŋinde nenzi ilo-kalo ŋalae koŋa tia. ");
INSERT INTO xsi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mao nâ, Mama, noko ilo patea tu ma kuveta mine, kala kuveta lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu ikai noŋa ŋine lâ, ŋineŋga iporo panzi tamâta ŋgu mine tu, “Naŋa akai Mama ndamwa marumbu lâ. Tamâta toŋge isama Maro Kindeni Natu kilala sondo, ande tia; Mama simbo nâ isama. Aku naŋa Maro Kindeni Natu simboŋgu nâ kala asama Mama kilala sondo, tavanzi tamâta ndia naŋa apateanzi tu ma atula i kilala pwataki panzi. ");
INSERT INTO xsi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mine nde noko tamâta ea kumakâsa ŋalae tina kala tini pââsââ lâ, ande noko kumâ pa naŋa, aku naŋa ma pwareâŋa alano. ");
INSERT INTO xsi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kumâ pwai wurâta ŋine naŋa atu alano, aku naŋa ma apananano ŋana kumo naneŋgu tamâta. Naŋa uru akai poe mwasa nâ panzi tamâta, aku uru apatawa warakâŋgu tiniŋgu. Mine nde kumâ pa naŋa, aku noko ilo ma isânda pwareâŋa kulu. ");
INSERT INTO xsi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ŋana tu wurâta ŋine naŋa atu alano, ande wurâta ŋalae koŋa tia. Aku mine nâ, kelekele ndia naŋa alano tu pwale, ande ŋinde ne malia nde ŋalae koŋa tia.” ");
INSERT INTO xsi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Zo toŋge, lâ Juda nenzi pwareâŋa ne zo sapâŋa toŋge, Yesu tavanzi ne pâri-tamâta soka silâ sipâŋga kâpwa “wit” ne tâno ŋgini. I ne pâri-tamâta nde putole ipunzi, kala sisiki kanaŋo pinde ku sika. ");
INSERT INTO xsi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Andeta tamâta pinde lâ Parisai ŋgu nde matanzi ilâ simoranzi siveta mine, aku sipai Yesu tu, “Wa! Ŋgua tukuŋa ikeno tu kinda ma taveta wurâta lâ zo sapâŋa ndimo. Mine nde noko ne pâri-tamâta silaŋa sipole ŋgua tukuŋa ŋinde!” ");
INSERT INTO xsi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Andeta Yesu iporo ŋgua taulo panzi tu, “Tiambo miki ŋandai kapono ŋgua ŋana vetâŋa ŋinde timbunda Daviti muŋga iveta, lâ zo ŋinde putole ipu i tavanzi ne ŋgu, a? ");
INSERT INTO xsi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mao nâ, Daviti ilâ luma sapâŋa ilo, aku mbau ilâ ikai puroŋa ŋinde kinzi patarawâŋa tamâta muŋga sipatarâwa pa Maro Kindeni. Patarawâŋa tamâta ŋalae puroŋa ŋinde ilua Daviti, ŋineŋga Daviti ika kunzi ne tamâta. Andeta ŋgua tukuŋa ikeno tu kinzi patarawâŋa tamâta simbonzi nâ ma sika puroŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aku tiambo miki kazizâla tava ŋana ŋgua tukuŋa Mose iŋgere ŋananzi patarawâŋa tamâta, tiya? Kinzi uru siveta wurâta lâ Maro Kindeni ne luma sapâŋa ilo ikura pwareâŋa ne zo sapâŋa rârâni. Mine nde silaŋa sipole tukuŋa ŋana zo sapâŋa kâ. Andeta kinzi siveta soki ŋana ŋinde kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naŋa aporo mao nâ pami; tamâta toŋge imo ŋai, ande i tamâta ŋalae, ipole Maro Kindeni ne luma sapâŋa. ");
INSERT INTO xsi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Naŋa tiniŋgu pwâka ŋana simbi ŋinde miki uru kapatarâwa pa naŋa. Taitu naŋa iloŋgu ndo tu miki ma kalomi sukâŋa ŋananzi tinimi pinde ku kasukanzi.’ Ambo miki ma kalomi ŋgere sondo ŋana ŋgua ŋinde ne duvi, ande miki ma kasowe ŋgua mine lâ tamâta ŋine tininzi, ande ma tia. Kinzi ŋandai siveta kiesaka ŋana ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ŋana tu naŋa Tamâta Natu akai maro pa pwareâŋa ne zo sapâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ipile nia ŋinde, ŋineŋga iyoka ilâ Juda nenzi luma ŋana pasauŋa kâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aku tamâta toŋge imo niani ndaina, i mbalau toŋge panzukuma lâ. Aŋga kinzi Parisai tamâta pinde simo ndaina, aku situ sio Yesu lâ ŋgua nia. Mine kala sikasoŋa Yesu tu, “Mose ne ŋgua tukuŋa isâu ŋana taveta pukoŋa tamâta tini ara lâ pwareâŋa ne zo sapâŋa, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ande Yesu itu lâ kawanzi tu, “Ambo miki nawalami tamâta toŋge ne ‘lama’ taitu nâ imo, andeta lama ŋinde pata indue mbââ toŋge ilo lâ pwareâŋa ne zo sapâŋa, ande tamâta ŋinde ma isaŋa ne lama ŋinde ku itapa kâki imâ, tiya? Mao nâ, i ma isaŋa itapa kâki imâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ambo taitu lama nde lama nâ, aŋga lâ Maro Kindeni nao kinzi tamâta nde sipolenzi lama ndo lâ. Mine kala ŋgua tukuŋa isâu ŋana taveta vetâŋa ara lâ pwareâŋa ne zo sapâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo pa tamâta mbalau sakamao ŋinde tu, “Kusowea mbalau.” Tamâta ŋinde isowea mbalau lâ, aku ndainani nâ mbalau sakamao ŋinde ipâŋga ara lâ, itogo i mbalau toŋge mine. ");
INSERT INTO xsi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aŋga kinzi Parisai tamâta nde simandi silâ, ŋineŋga sipasau ku sipa ŋgua tu ma sipu Yesu pâta imâte. ");
INSERT INTO xsi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Andeta Yesu isama lâ ŋana nenzi ŋgua ŋinde. Mine kala ipile nia ŋinde ku iyoka ilâ. Aku tamâta rârâ soka i muli silâ, ande ivetanzi pukoŋa tamâta rârâni tininzi ara lâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Andeta Yesu indi kaika panzi tamâta ŋinde tu ma situ i parina ilâ panzi tamâta pinde siloŋo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu iveta mine, ande kala Maro Kindeni kawa ŋgua muŋga itula papa ŋgua-tulâŋa tamâta Aisaia ŋinde, ande ipâŋga kanaŋo. Ŋgua ŋinde nde mine; ");
INSERT INTO xsi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Naŋa muŋga apatea tamâta ŋine tu imo naneŋgu wurâta tamâta. Naŋa tiniŋgu mwasa ndo papa, aku iloŋgu ndeka ŋana. Naŋa ma ao koranâŋgu ilâ papa i, kala i ma itula ŋgua panzi tinikoa ŋgu ŋana vetâŋa sondo naŋa uru aveta lâ ŋgua nia. ");
INSERT INTO xsi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I ŋana iporo ipambita kunzi tamâta wa iporo ŋgua kawa pakâe ŋalae panzi, ande ma tia. Kinzi ma siloŋo i isarâwa lâ nzâla kawa, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ambo taumbwa toŋge kambwaŋe sasa mwata, ande ŋinde i ma imbware nuki ndo, ande tia. Ambo sinâla ne ‘wiki’ toŋge yââ kana lâ kala mundo nâ ikâki, ande ŋinde i ma ipupu imâte puusii kâ, ande ma tia. I ma iveta wurâta mine lee, ikura lâ zo ŋinde itunzi tamâta rârâni sondo marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aku kinzi tamâta papa ŋgu rârâni ma sio nenzi kalo-tawana ilâ papa i, ku ma sio tininzi ŋana i ne pavilâŋa ŋinde kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ŋine ilâ lâ, ŋineŋga tamâta pinde sikai tamâta toŋge simâ pa Yesu. Tamâta ŋinde nde koroani saka ipagagara, aku iveta i mata leva-leva wa kawa pasâe wa. Andeta Yesu iveta tamâta ŋinde tini ara kilo, kala iporo ŋgua pwataki ku mata imora nia kilo. ");
INSERT INTO xsi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kinzi tamâta ŋgu ŋalae simo ndaina, ande matanzi simora Yesu ne mâsi ŋinde. Kinzi wisinzi motutu lâ, aku sipakasoŋa tu, “Opopo, tiambo tamâta ŋine nde timbunda Daviti ne vâsa ŋinde kala kinda uru tao tininda ŋana, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Andeta kinzi Parisai ŋgu tamâta pinde siloŋo ŋgua ŋine, aku sipainzi tu, “Tamâta ŋine ikai koroani saka nenzi koipu ŋalae Belsebul ne walo (i ŋa toŋge Sadana), kala waloni ndaina isuka i ŋana isokinzi koroani saka piti lâ tamâta ilonzi.” ");
INSERT INTO xsi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu nde isama kinzi ilonzi pwataki lâ, ande kala ipainzi tu, “Ambo kinzi tamâta nenzi lawea taitu ma sipwa pwataki simo ŋgu rua ku sipara, ande lawea ŋinde ikura tu imo kaika, ande tia. Ambo tamâta toŋge natu-timbu ma sipwa pwataki simo ŋgu rua ku sikai kazâŋa pa warakanzi, ande kinzi ŋgu ŋinde ma sipayaula ndo. ");
INSERT INTO xsi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aku mine nâ, ambo Sadana ne ŋgu ma sipwa pwataki simo ŋgu rua ku sikai kazâŋa pa warakanzi, ande i ne ŋgu ŋinde ma sipayaula ndo. ");
INSERT INTO xsi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ayo, miki kaporo tu koroani saka nenzi koipu ŋalae isuka naŋa kala asokinzi koroani saka. Andeta miki kalomi ŋgere sondo ŋga; miki Parisai nemi tamâta uru sisokinzi koroani saka piti mine nâ! Mine nde ea uru isuka kinzi, a? Miki nemi tamâta nenzi vetâŋa ŋinde itula nemi ŋgua ŋinde kilala pwataki tu soki ndo. ");
INSERT INTO xsi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Andeta Maro Kindeni ne Koroani Sapâŋa uru imo kuku naŋa, aku walo ilana ŋana asokinzi koroani saka. Mine nde miki kasama tu Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ nde imâ ipâŋga pami marumbu lâ! ");
INSERT INTO xsi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tamâta toŋge ikura tu iyoka kaa nâ ilâ tamâta kaika toŋge ne luma ilo ku ipanawe i ne kelekele, ande tia. I ma ipa tamâta ŋinde kaika muŋga lâ ŋga. Iveta mine, ŋineŋga ikura tu ikai ne kelekele rârâni keno i ne luma ilo ŋinde marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tamâta ea ipono muli pa naŋa tia, ande i ikai kazâŋa pa naŋa. Aŋga tamâta ea tini pwâka tu isarawanzi tamâta tu simâ pa naŋa, ande i iveta wurâta ŋana iŋaranzi tamâta sikâwa pwapwataki silâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mine kala naŋa aporo mao nâ pami; Maro Kindeni ikura tu izavaru kiesaka rârâni tava ŋgua pavaligiŋa rârâni kinzi tamâta siporo papa i ŋinde piti lâ tininzi. Taitu kaloŋo ŋga; ambo tamâta toŋge iporo ŋgua pavaligiŋa pa Maro Kindeni ne Koroani Sapâŋa, itogo kala ŋine miki kaporo mine, ande Maro Kindeni ma izavaru tamâta ŋinde ne kiesaka ŋinde piti tia. ");
INSERT INTO xsi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mao nâ, tamâta ea iporo ŋgua potomule pa Tamâta Natu, ande Maro Kindeni ikura tu izavaru kiesaka ŋinde piti. Aŋga tamâta ea iporo ŋgua potomule pa Koroani Sapâŋa, ande lâ zo ŋine wa zo muli wa, Maro Kindeni ma izavaru tamâta ŋinde ne kiesaka ŋinde piti, ande ma tia.” ");
INSERT INTO xsi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu iporo ŋgua ŋine panzi Parisai tamâta lâ, ŋineŋga ipainzi tu, “Kâi ara ne kanaŋo nde ara, aŋga kâi sakamao ne kanaŋo nde sakamao. Ambo kinzi tamâta ma simora kâi kanaŋo, ande ma sisama tu kâi ŋinde nde ara, tiya?, sakamao. ");
INSERT INTO xsi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Miki nde sakamao tamwatami, katogonzi mwâta saka mine! Miki kakura tu kaporo ŋgua ara toŋge tia ndo! Tamâta kawa ŋgua nde itula ilo-kalo ndia ipipi lâ keno i ilo. ");
INSERT INTO xsi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mao nâ, tamâta ara ne ilo-kalo ara rârâ nde ipipi lâ keno i ilo, kala i uru iveta vetâŋa arara. Aŋga tamâta sakamao ne ilo-kalo sakamao rârâ nde ipipi lâ keno i ilo, kala i uru iveta vetâŋa sakamao. ");
INSERT INTO xsi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kinzi tamâta rârâni zo pinde siporo ŋgua kapa-kapa pinde. Kala ŋine apaimi tu lâ zo muli Maro Kindeni ma ionzi tamâta rârâni simandi i ne ŋgua nia, aku lâ zo ŋinde i ma italeanzi ŋana nenzi ŋgua ŋinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lâ zo ŋinde, Maro Kindeni ma iporo panzi tamâta pinde mine tu, ‘Noko tamwata kawa ŋgua itula pwataki pa naŋa tu noko ne soki toŋge keno tia.’ Aŋga ma iporo ŋgua panzi tamâta pinde mine tu, ‘Noko tamwata kawa ŋgua itula pwataki pa naŋa tu noko ne soki keno’.” ");
INSERT INTO xsi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yesu iporo ŋgua ŋine lâ, ŋineŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde, sitavanzi tamâta pinde lâ kinzi Parisai ŋgu, ande simâ pa Yesu. Aku sipai tu, “Pananâŋa, maka iloma tu noko ma kuveta mâsi kaika toŋge lâ naoma, ŋana ma kamora ku kasama tu Maro Kindeni ne walo ikeno pano.” ");
INSERT INTO xsi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Andeta Yesu itu lâ kawanzi ku ipainzi tu, “Opopo, kinzi kiesaka tamwatanzi ŋandai sio ilonzi kalonzi ilâ mao papa Maro Kindeni ŋga. Miki kakasoŋa naŋa ŋana kamora Maro Kindeni ne mâsi kaika toŋge, a? Naŋa ma atula mâsi kaika toŋge pa miki tia ndo. Maro Kindeni ma itula mâsi kaika taitu nâ pami, itogo muŋga itula pa ŋgua-tulâŋa tamâta Yona mine. ");
INSERT INTO xsi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Muŋga, Yona imo iŋa ŋalae toŋge kapwa ilo ikura kari ŋato lâ; aku naŋa Tamâta Natu kala ma amo mateŋa ne kuru ilo ikura kari ŋato mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lâ zo ŋana Maro Kindeni ma ionzi tamâta rârâni lâ i ne ŋgua nia, ande kinzi tamâta muŋga simo Ninive lawea ŋinde ma simandi ŋgua nia ku ma situla miki nemi vetâŋa soki pwataki, ŋana tu kinzi Ninive tamâta muŋga siloŋo Yona itula ŋgua panzi, ŋineŋga sipalele ilonzi kalonzi ndoni ilâ pa Maro Kindeni nâ. Andeta tamâta toŋge imo ŋai, aku i nde ipole ŋgua-tulâŋa tamâta Yona. ");
INSERT INTO xsi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aku mine nâ, lâ zo ŋana Maro Kindeni ma ionzi tamâta rârâni lâ i ne ŋgua nia, ande koipu taine ŋalae kala nanayoni ikai poe panzi lâ Siba tâno ŋinde, ande ma imandi lâ ŋgua nia ku ma itula nemi vetâŋa soki pwataki, ŋana tu koipu taine ŋinde muŋga iyoka pa nia malawae imâ tu iloŋo timbunda Koipu Ŋalae Solomon itula i ne ilo-kalo ara papa. Andeta tamâta toŋge imo ŋai, aku i ne ilo-kalo nde ipole Solomon ne ilo-kalo.” ");
INSERT INTO xsi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ŋineŋga Yesu itambira ŋgua mine tu, “Ambo koroani saka toŋge ipile tamâta toŋge ilâ, ande i ma ilâ wa imâ wa lâ nia bilimu, iroroto nia toŋge ŋana ipwarea kâ. Ambo isânda nia ara toŋge tia, ");
INSERT INTO xsi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ande i ma ilo patea mine tu, ‘Ayo, naŋa ma ataulo alâ kilo pa luma siŋga ŋinde muŋga naŋa amo’. I ma iyoka ilâ, ŋineŋga ma isânda lumani ndaina, kinzi sitaka wa sisaŋgarana lâ, aku ikeno ilo kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ŋineŋga koroani saka ŋinde ma ilâ ikainzi nuwala koroani lima kanaŋonzi rua simâ kuku i. Kinzi ŋinde uru siveta mâsi sakamao ndo, sipole i ne mâsi sakamao ŋinde. Aku kinzi rârâni ma silâ luma ŋinde ilo. Muŋga tamâta ŋinde imo ara koŋa tia, andeta zo ŋinde i ma imo sakamao ndo ikura zo zo. Aku mâsi kie taituni ma ipâŋga panzi tamâta sakamao kala simo lâ zo ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu iporo ŋgua ŋine panzi tamâta marumbu tia yo, ŋineŋga i tina wa tai nde simâ sipâŋga simandi nia yo. Kinzi simâ tu ma siporo ŋgua pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mine kala tamâta toŋge imâ ipai Yesu tu, “Kuloŋo, noko tina wa tai nde simâ sipâŋga lâ, kala simandi nia yo. Kinzi ilonzi ŋgua tu siporo pano.” ");
INSERT INTO xsi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Andeta Yesu itu lâ tamâta ŋinde kawa, ku iporo tu, “Naŋa nana mao nde ea. Aŋga naŋa taiŋgu mao nde ea kinzi.” ");
INSERT INTO xsi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ŋineŋga Yesu mbau sili isowe iyokenzi ne pâri-tamâta, aku iporo tu, “Naŋa nana wa taiŋgu mao kala simo ŋai. ");
INSERT INTO xsi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tamâta ea kinzi uru siveta ikura naŋa Mama Maro Kindeni imo samba ilo ŋinde ne pateâŋa, aku soka i muli, kinzi ŋinde nde sitogo naŋa nana wa mwaneŋgu wa taiŋgu wa.” ");
INSERT INTO xsi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yesu iporo ŋgua ŋine marumbu lâ, ŋineŋga ipile luma ŋinde ku iyoka ilâ isaŋona Galilaya Lââ bwalika pwali, ŋana ma ipanananzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Andeta tamâta ŋgu ŋalae tina nde simâ sipasau pasâe ndo lâ i tini. Mine kala Yesu ikâki wâŋga toŋge kulu isaŋona. Aŋga kinzi tamâta ŋgu ŋalae nde simandi sâwa. ");
INSERT INTO xsi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ŋineŋga Yesu isia ŋgua tambirâŋa rârâ panzi ŋana Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ. Ipainzi tu, “Miki kaloŋo ŋga; tamâta toŋge iyoka ilâ iliŋi kaniŋa vâsa lâ tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iliŋi ilâ, ande kaniŋa vâsa pinde nde imbe indue nzâla-kawa, aku sii simâ sika marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aŋga kaniŋa vâsa pinde nde imbe indue tâno mira-mira. Tâno ŋinde nde matatola koŋa tia, kala mata ipâŋga walele. ");
INSERT INTO xsi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Andeta kari ikâki imâ ikana. Aku kâpwa ŋinde ne mburu-mburu kaika tia, kala ŋgâla-ŋgâla ndo lâ, kala imâte. ");
INSERT INTO xsi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aŋga kaniŋa vâsa pinde nde imbe indue wâlo mata-mata ŋgininzi. Aku wâlo mata-mata ŋinde ipâŋga ŋalae ku ilita, kala kanaŋo ipâŋga tia. ");
INSERT INTO xsi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aŋga kaniŋa vâsa pinde nde imbe indue tâno ara kulu, aku ipâŋga ŋalae ku ipula kanaŋo. Pinde ipula kanaŋo tamâta ŋalae taitu (100), aŋga pinde nde ipula kanaŋo tamâta ŋato (60), aŋga pinde nde ipula kanaŋo tamâta taitu kanaŋo saŋao (30). ");
INSERT INTO xsi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo.” ");
INSERT INTO xsi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesu iporo ŋgua ŋine marumbu lâ, ŋineŋga ne pâri-tamâta simâ papa ku sikasoŋa tu, “Mana mana ŋga noko uru kuporo ŋgua tambirâŋa nâ panzi tamâta.” ");
INSERT INTO xsi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu nde iporo taulo tu, “Maro Kindeni itula ŋgua paveâŋa ne duvi pwataki pa miki ŋana i ne mâsi ŋana ikai maro panzi tamâta kâ. Andeta iveta mine panzi tamâta pinde, nde tia. ");
INSERT INTO xsi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tamâta ea ikai ne ilo-kalo ŋana Maro Kindeni ne vetâŋa paveâŋa, ande Maro Kindeni ma ilo-kalo ŋalae ilua i, ma ipipi lâ i ilo. Aŋga tamâta ea tini pwâka tu ikai ilo-kalo ŋinde, ande Maro Kindeni ma ikai tamâta ŋinde ne ilo-kalo tini mwata ŋinde saŋe i. ");
INSERT INTO xsi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Naŋa uru aporo ŋgua tambirâŋa nâ panzi, ŋana tu kinzi matanzi silea, andeta sikura tu simora kelekele toŋge tia. Kinzi sitambira taŋanzi, andeta siloŋo ŋgua ku sisama ne duvi, nde tia. ");
INSERT INTO xsi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ŋgua-tulâŋa tamâta Aisaia muŋga ikai Maro Kindeni kawa ku iŋgere ŋgua lâ pepa tini ŋana kinzi tamâtani ŋaina nenzi mâsi ŋana siloŋo naneŋgu ŋgua kâ. Iŋgere ŋgua mine tu, ‘Tamâta ŋgu ŋine ma sitambira taŋanzi, andeta ma sisama ŋgua duvi kilala tia. Aku kinzi ma matanzi pareŋge, andeta ma simora kelekele toŋge tia, ");
INSERT INTO xsi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ŋana tu tamâta ŋgu ŋine ilonzi nde pasâe lâ, aku taŋanzi ikai pwapwaka nâ ŋana siloŋo ŋgua kâ, aku sipono matanzi marumbu lâ. Ambo siveta mine tia, ande ma matanzi simora kelekele, aku taŋanzi ma siloŋo ŋgua, aku ilonzi ma sisama ŋgua duvi, ku ma sipalele ilonzi kalonzi simâ pa naŋa, aku naŋa ma aveta tininzi ara kilo’.” ");
INSERT INTO xsi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipainzi ne pâri-tamâta tu, “Aŋga miki nde ma kandeka nâ, ŋana tu Maro Kindeni iveta miki matami ikura tu kamora kelekele, aku iveta taŋami ikura tu kaloŋo ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Naŋa aporo mao nâ pami; lâ zo muŋgâŋa, kinzi ŋgua-tulâŋa tamâta rârâ sitavanzi kinzi tamâta rârâ uru soka Maro Kindeni ne ŋgua muli, kinzi ŋinde ilonzi ndo tu simora vetâŋa kala zo ŋine miki kamora ŋine, andeta simora tia. Aku ilonzi ndo tu siloŋo ŋgua kala ŋine miki kaloŋo ŋine, andeta siloŋo tia.” ");
INSERT INTO xsi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Kala ŋine miki kaloŋo, ma natula ŋgua tambirâŋa ŋana tamâta iliŋi kaniŋa vâsa lâ tâno ilo ŋinde ne duvi pwataki pami. ");
INSERT INTO xsi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tamâta ea iloŋo ŋgua ŋana Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, andeta izizâla ŋana ŋgua ŋinde ne duvi kilala, ande tamâta ŋinde itogo kaniŋa vâsa ŋinde imbe indue nzâla-kawa. Sadana imâ walele nâ ku ikawea ŋgua ŋinde Maro Kindeni muŋga ipau lâ tamâta ŋinde ilo, aku ikai ikâwa ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aŋga tamâta ea iloŋo naneŋgu ŋgua ŋine aku ikai walele nâ ku indeka, ande tamâta ŋinde itogo kaniŋa vâsa ŋinde imbe indue tâno mira-mira. ");
INSERT INTO xsi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tamâta ŋinde ikai ŋgua ŋinde kaika tia. Mine kala i imo tini nâ, aŋga muli ŋga tamâta pinde simâ, situ malia silua wa siveta kenzi sakamao papa ŋana i ne kalo-tawana kâ. Mine kala tamâta ŋinde ne kalo-tawana nde imbe walele nâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aŋga tamâta ea iloŋo naneŋgu ŋgua ŋine, andeta ilo ŋalae ŋana tâno ne kelekele, ande tamâta ŋinde itogo kaniŋa vâsa ŋinde imbe indue wâlo mata-mata ŋgininzi. I ne ilo-kalo ŋinde iveta kalo-lokoni papa i ŋana igona ne mbaliŋa rârâ, kala i uru iveta vetâŋa ara pinde, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aŋga tamâta ea iloŋo Maro Kindeni ne ŋgua ku isama ŋgua ŋine ne duvi kilala sondo, ande tamâta ŋinde itogo kaniŋa vâsa ŋinde imbe indue tâno ara kulu. Kinzi tamâta ŋinde uru siveta vetâŋa ara rârâ, itogo kanaŋonzi mine. Pinde siveta vetâŋa tamâta ŋalae taitu (100), aŋga pinde siveta vetâŋa tamâta ŋato (60), aŋga pinde siveta vetâŋa tamâta taitu kanaŋo saŋao (30).” ");
INSERT INTO xsi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu itambira ŋgua toŋge kilo panzi tamâta mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, ande itogo tamâta toŋge iliŋi kaniŋa vâsa ara lâ ne tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Iliŋi lâ, ŋineŋga mbo toŋge, kinzi tamâta sikeno utu lâ, andeta tâno warika ŋinde ne kazâŋa tamâta nde imâ, aku iliŋi unza sakamao vâsa ilâ kaniŋa ŋgininzi. Iliŋi lee marumbu lâ, ŋineŋga ikâwa ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aku muli, ŋineŋga kaniŋa ŋinde ipâŋga kundu ramu aku kanaŋo, andeta kinzi wurâta tamâta matanzi ilâ simora unza sakamao ipagema kuku. ");
INSERT INTO xsi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aku kinzi wurâta tamâta silâ papa tâno warika ku sipai tu, ‘Ayo, tamâta ŋalae, maka iloma patea tu noko muŋga kuliŋi kaniŋa vâsa ara tâ ilâ noko ne tâno ilo. Andeta mana mana ŋga unza sakamao ŋinde ipâŋga ipagema kuku.’ ");
INSERT INTO xsi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aku tâno warika ipainzi tu, ‘Naneŋgu kazâŋa tamâta toŋge iveta ŋinde’. Ŋineŋga i ne wurâta tamâta sikasoŋa tu, ‘Ayo, noko ilo tu maka ma kalâ kamburu unza sakamao ŋinde piti ku kasau ilâ taitu, tiya?’ ");
INSERT INTO xsi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Andeta tâno warika ileleanzi ku ipainzi tu, ‘Kaveta mine ndimo. Ambo miki ma kakai wurâta ŋana kamburu unza sakamao, ande ma kamburu kâpwa ara tona. ");
INSERT INTO xsi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mine nde miki ma kapile ruani sipâŋga simandi taitu lee, mambo zo ŋana kâpwa gonâŋa kâ. Ŋineŋga lâ zo ŋinde, ande naŋa ma apainzi naneŋgu wurâta tamâta ŋana kâpwa gonâŋa kâ tu, “Miki kalâ kasau unza sakamao ndoni ilâ taitu muŋga lâ ŋga, ŋineŋga walele nâ kapa wâra-wâra ku karumbia kana lâ. Kaveta mine lâ, ŋineŋga kagona kâpwa kanaŋo ilâ taitu, ku kao ilâ naneŋgu luma ŋana kâpwa kâ ilo”.’” ");
INSERT INTO xsi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu iporo ŋgua tambirâŋa toŋge kilo panzi tamâta mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ nde itogo kaniŋa vâsa toŋge, i ŋa tu ‘mastet’. Tamâta toŋge ikai mastet vâsa toŋge, aku ilâ ipau lâ ne tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet vâsa ŋandai irerege kuku kâi pinde nenzi kapula ŋga; ŋinde nde mota mwata. Andeta muli, ŋineŋga kâi ŋinde ipâŋga ŋalae, aku i ne luandondo nde ipolenzi kaniŋa kie-kie ndoni uru sipau lâ tâno ilo. Ipâŋga kâi, kala kinzi sii kie-kie uru sipagona simâ sisaŋona ne laka kulu.” ");
INSERT INTO xsi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu iporo ŋgua tambirâŋa toŋge kilo panzi tamâta mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ ande itogo ‘yisi’. Taine toŋge ikai yisi ŋinde ku igema tona puroŋa kulo ŋalae toŋge. Igema lee, ŋineŋga puroŋa ŋinde ndoni ipondi kâki.” ");
INSERT INTO xsi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu iporo ŋgua ŋinde ndoni panzi tamâta lâ ŋgua tambirâŋa nâ. Itula ŋgua toŋge duvi pwataki panzi, ande tia; iporo ŋgua tambirâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aku Yesu ne vetâŋa ŋinde nde iyoke ŋgua toŋge muŋga ŋgua-tulâŋa tamâta toŋge itula. Ŋgua-tulâŋa tamâta ŋinde ikai Maro Kindeni kawa ŋgua ku iporo mine tu, ‘Naŋa ma aporo ŋgua tambirâŋa nâ pami. Mao nâ, naŋa ma atula ŋgua pinde duvi pwataki, ŋgua ŋinde ikeno paveâŋa lâ zo ŋinde naŋa apulia samba wa tâno wa, aku ikeno paveâŋa mine lee ikura lâ zo ŋine.’ ");
INSERT INTO xsi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ŋineŋga Yesu ipilenzi tamâta ŋgu ŋinde, aku ilâ luma ilo. Ŋineŋga i ne pâri-tamâta simâ papa ku sipai tu, “Kupanana maka ŋana ŋgua tambirâŋa ŋana unza sakamao ipâŋga tâno ilo kâ ŋinde ne duvi.” ");
INSERT INTO xsi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu nde itu lâ kawanzi tu, “Tamâta ŋinde iliŋi kaniŋa vâsa ara, ande itogo Tamâta Natu. ");
INSERT INTO xsi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aŋga i ne tâno ŋinde nde itogo tâno ndoni. Aŋga kaniŋa vâsa ara nde itogonzi tamâta ŋinde Maro Kindeni uru ikai maro panzi. Aŋga unza sakamao nde itogonzi tamâta ŋinde Sadana uru ikai maro panzi. ");
INSERT INTO xsi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kazâŋa tamâta ŋinde kala iliŋi unza vâsa sakamao, ande itogo Sadana tamwata. Aŋga zo ŋana sigona kâpwa kâ nde itogo tâno ŋine ne zo marumbu. Aŋga kinzi wurâta tamâta ŋana sigona kâpwa kâ nde sitogonzi Maro Kindeni ne aŋelo. ");
INSERT INTO xsi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kinzi wurâta tamâta nde sigona unza sakamao sirumbia lâ; aku lâ zo muli ŋana tâno ne zo marumbu kâ, ande kinzi aŋelo kala ma siveta mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lâ zo ŋinde, naŋa Tamâta Natu ma aonzi naneŋgu aŋelo silâ, aku ma sigonanzi kinzi tamâta rârâni uru siveta kiesaka, sitavanzi tamâta rârâni uru siveta tamâta pinde simbe ŋana kiesaka kâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ŋineŋga kinzi aŋelo ma sikainzi kiesaka tamwatanzi ŋinde rârâni, ku ma sitambiranzi silâ pa yââ ŋalae ne mbââ ilo. Lâ nia ŋinde, kinzi tamâta ŋinde ma sita pâta kanaŋo, aku ma niŋonzi giri-giri ŋana sikai nâna kâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aŋga kinzi tamâta uru soka Maro Kindeni ne ŋgua muli ŋinde, ande kinzi ma tininzi sinala nia itogo kari mine, lâ tâno wasaseki tamanzi Maro Kindeni ma muli ipulia ŋinde. Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo.” ");
INSERT INTO xsi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu itambira ŋgua mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, nde itogo ŋine: zo toŋge, tamâta pinde sikai mbumbu rârâ ku sikea lâ tâno toŋge ilo. Mbumbu ŋinde ikeno lee, ŋineŋga zo toŋge, tamâta toŋge isânda kulu lâ. Aku walele nâ tamâta ŋinde ilâ ku ivea kilo lâ tânoni ndaina ilo. I nde indeka pâta lâ, aku ilâ imbalaŋa ne kelekele rârâni ku ikai mbumbu ŋana. Ŋineŋga ilâ ku iko tâno ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aku Yesu itambira ŋgua kilo mine tu, “Aku Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, nde itogo mine: tamâta toŋge uru iroto ŋana mbote-mbote ara pâta tu iko kâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Imo lee, ku zo toŋge, i mata imora mbote-mbote toŋge ara matea nâ. Aku ilâ imbalaŋa ne kelekele ndoni ku ikai mbumbu ŋana. Ŋineŋga ilâ ku iko mbote-mbote ara ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu itambira ŋgua mine tu, “Aku Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, nde itogo viâŋa toŋge kinzi tamâta pinde sitambira ndue lââ bwalika ilo ku iŋgenzi iŋa kie-kie. ");
INSERT INTO xsi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Viâŋa pipi lâ, ŋineŋga sitapa imâ itoa sâwaneka. Ŋineŋga lambunzi ndue sisaŋona ku sipateanzi iŋa ara sigona lâ kondo toŋge ilo. Aŋga iŋa sakamao nde sikai siliŋi lâ. ");
INSERT INTO xsi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aku lâ zo muli ŋana tâno ne zo marumbu kâ, ande ma vetâŋa mine nâ ipâŋga. Maro Kindeni ne aŋelo ma silâ sipateanzi kinzi kiesaka tamwatanzi ŋinde muŋga simo tamâta ara ŋgininzi, ku ma sikainzi piti, ");
INSERT INTO xsi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ŋineŋga ma sitambiranzi silâ pa yââ ŋalae ne mbââ ilo. Lâ nia ŋinde kinzi tamâta ma sita pâta kanaŋo, aku ma niŋonzi giri-giri ŋana sikai nâna kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ŋineŋga Yesu ikasoŋanzi ne pâri-tamâta tu, “Miki kasama ŋgua rârâni ŋine ne duvi, tiya?” Ande kinzi sisâu papa tu, “Maka kasama lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aku Yesu isia ŋgua panzi mine tu, “Mine kala kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ ŋinde ilonzi tu Maro Kindeni ma ikai maro panzi, ande kinzi rârâni sitogo luma toŋge warika. I uru ilâ ne luma ilo ku ikai kelekele wasaseki tava kelekele siŋga yâti ipâŋga nia yo.” ");
INSERT INTO xsi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu iporo ŋgua tambirâŋa ŋinde lâ, ŋineŋga ipile lawea ŋinde, ");
INSERT INTO xsi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aku itaulo ilâ pa i tamwata ne lawea tina Nasarete kilo. Ipâŋga Nasarete lâ, ŋineŋga iveta wurâta ŋana ipanananzi tamâta lâ nenzi luma ŋana pasauŋa kâ ilo. Kinzi nde siloŋo Yesu iporo ŋgua panzi, aku wisinzi motutu lâ. Kinzi siveta “a” papa ku siporo warakanzi nenzi mine tu, “Opopo! Ilo-kalo wa mâsi kaika ndoni ŋinde, ande tamâta ŋine ikai lâ nia ndia, a? ");
INSERT INTO xsi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tiambo tamâta ŋine tama nde nawalânda tamâta ŋinde uru ipa luma, tiya? Tiambo Maria nde i tina, tiya? Tiambo Yamesi, aŋga Yosepe, aŋga Saimon, aŋga Judas nde i tai kinzi, tiya? ");
INSERT INTO xsi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tiambo i mwane rârâni nde simo ŋai kuku kinda, tiya? Mine nde ikai ilo-kalo wa kaika ŋinde lâ nia ndia, a?” ");
INSERT INTO xsi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kinzi siporo ŋgua mine rârâ, aku sipu mulinzi pa Yesu. Aŋga Yesu nde ipainzi tu, “Kinzi tamâta simo lawea ndoni nde ilonzi ara pa ŋgua-tulâŋa tamâta; taitu kinzi tamâta lâ i tamwata ne lawea tina wa i see wukale wa, kinzi ŋinde ilonzi ara papa i, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kinzi tamâta lâ Nasarete lawea sio nenzi kalo-tawana ilâ pa Yesu, ande tia. Mine kala iveta mâsi kaika rârâ pinde lâ lawea ŋinde, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pa zo ŋinde, Koipu Ŋalae Herot ikai koipu panzi tamâta simo tâno ŋinde. Aku Herot iloŋo Yesu parina. ");
INSERT INTO xsi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Mine kala ipainzi ne wurâta tamâta tu, “Opopo, Yoane Lââ-Liliŋa Tamwata imandi sânda lâ mateŋa nianzi imo via kilo tâ, kala ikai walo ikura ŋana iveta mâsi kaika ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot ne ŋgua ŋine nde duvi mine: muŋga, i tai Pilip ikai taine toŋge, i ŋa tu Herodias, andeta muli ŋga Herot ikai taine ŋinde saŋe Pilip, aku rua sipakâe. Mine kala Yoane Lââ-Liliŋa Tamwata uru ilelea Herot mine tu, “Ŋana sâ kâ ŋga noko pwai taine ŋinde, a? Mâsi mine nde ara tia ndo!” Herot wisi nâna ŋana Yoane ne ŋgua ŋine, kala isupwanzi ne zugu tamâta sikai Yoane kaika ku sipa lâ wâlo kaika sio lâ luma sakamao ilo. ");
INSERT INTO xsi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot nde ilo tu ma ipu Yoane pâta imâte, andeta iruru ŋananzi Juda tamâta, ŋana tu kinzi kalonzi tawana tu Yoane nde ŋgua-tulâŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Simo lee ku zo toŋge, ŋineŋga tamâta pinde silâ kuku Herot ŋana sindeka ku sika kâŋa-nuŋa ŋalae ŋana i ne zo muŋga tina ipagugua i kâ. Aku lâ zo ŋinde, i kaiwa Herodias natu taine ikina kiniŋa panzi tamâta ŋinde. Aku Herot ilo yosi pa taine taipa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mine kala Herot iveta ne ŋgua pâŋa kaika papa taine ŋinde mine tu, “Naŋa aporo mao pa âta, sâ kelekele toŋge noko ilo papa ku kuno naŋa, ande ma alano.” ");
INSERT INTO xsi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Andeta taine taipa ŋinde tina io ŋgua pinde lâ natu kawa, kala taine taipa ipai Herot tu, “Noko ma kuo Yoane Lââ-Liliŋa Tamwata kulu kâmba lâ kondo toŋge ilo, aku ŋine nâ kutula pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Taine iporo ŋgua ŋine lâ, aku Herot ilo malia ndo. Andeta i ilo ŋana ne ŋgua pâŋa muŋga iveta lâ tamâta sisaŋona sika kâpwa kuku i ŋinde naonzi. Mine kala isupwanzi ne sambara tu siveta ikura taine ne ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kinzi sambara ŋinde silâ luma sakamao ilo, aku sitoto Yoane ŋandola utu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ŋineŋga sikai Yoane kulu kâmba sio lâ kondo toŋge ilo, aku sikai silâ situla pa taine taipa ŋinde. Ŋineŋga taine ikai ilâ itula pa tina. ");
INSERT INTO xsi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoane ne pâri-tamâta siloŋo ŋgua tu Yoane ŋga imâte lâ, ŋineŋga simâ sikai i karae silâ sikea. Sikea lâ, ŋineŋga sikai pâri silâ siporo pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu iloŋo ŋgua tu Yoane Lââ-Liliŋa Tamwata nde imâte lâ, ŋineŋga ikainzi ne pâri-tamâta ku sipile lawea ŋinde. Aku soka paveâŋa nâ sikai wâŋga silâ ku sitoa lâ nia bilimu toŋge. Andeta kinzi tamâta ŋgu ŋalae siloŋo pâri tu Yesu ikai wâŋga ilâ pa nia ŋinde. Tia ku sipile nenzi lawea lawea ku soka nzâla silâ pa nia kala Yesu ilâ papa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aŋga Yesu ilâ lee itoa tina tini lâ, ŋineŋga mata ilâ imoranzi tamâta ŋgu ŋalae simuŋga simâ kala simo ŋinde. Aku i kalo sukâŋa ŋalae ŋananzi, kala ivetanzi nenzi pukoŋa tamâta tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Simo lee, ku kari indue lala lâ, ŋineŋga Yesu ne pâri-tamâta simâ kuku ku sipai tu, “Wa, kari ŋga indue lala lâ, aku nia ŋgaŋe ŋine tamâta simo tia. Mine nde kuonzi tamâta silâ, aku ma siroto ŋana nia wa lawea ŋana sipako kapwanzi sika.” ");
INSERT INTO xsi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Andeta Yesu itu lâ kawanzi aku ipainzi tu, “Kinzi ma simo ŋaina nâ; miki warakami nâ kasuanzi.” ");
INSERT INTO xsi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ande kinzi siporo taulo tu, “Opopo, maka kapwama puroŋa lima ŋga iŋa rua nâ kala keno pama!” ");
INSERT INTO xsi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Andeta Yesu ipainzi tu, “Kakai kâpwa ŋinde kamâ ŋai kalana.” ");
INSERT INTO xsi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sikai simâ silua Yesu, ŋineŋga Yesu ipainzi tamâta tu lambunzi ndue sisaŋona unza kulu. Sisaŋona lâ, ŋineŋga Yesu ikai puroŋa lima tava iŋa rua ŋinde kâki. Aku Yesu mata kâki pa samba ku kawa ndaŋge pa Maro Kindeni, ŋineŋga ipwataki puroŋa ilanzi ne pâri-tamâta, aku siwae panzi tamâta. Aku iŋa rua kala siwae panzi tona. ");
INSERT INTO xsi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aku kinzi tamâta rârâni sika lee kapwanzi pupuro lâ. Ŋineŋga kinzi pâri-tamâta sigona kâpwa pinde keno mo ŋai yo, kinzi tamâta kapwanzi pupuro kala sika tia, aku ikura ŋgâmo saŋao kanaŋo rua ilonzi pipi lâ. ");
INSERT INTO xsi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kinzi tamâne kala sika kâpwa ŋinde kambwaŋenzi nde ikura 5,000 mine. Aku nenzi taine wa lâlu nde sika kunzi tona. ");
INSERT INTO xsi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sika marumbu lâ, ŋineŋga walele nâ Yesu ipainzi ne pâri-tamâta tu ma sikâki wâŋga kulu ku simuŋga simbwaliu silâ papa lââ bwalika tini pinde. Aŋga i tamwata nde itu ionzi tamâta mbo silâ ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yesu ionzi tamâta rârâni silâ lâ, ŋineŋga i simbo nâ ikâki tuu toŋge kulu ŋana ikai noŋa kâ. Lala pararai lâ, aku Yesu simbo nâ imo tuu kulu. ");
INSERT INTO xsi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aŋga wâŋga nde ilâ lee ipâŋga lââ bwalika ŋgini, ŋineŋga lawea ŋalae imandi aku kâla itiŋgi wâŋga kaika. Mine kala kinzi pâri-tamâta simakâsa ŋalae ŋana sipoe sikundua lawea kâ. ");
INSERT INTO xsi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Simakâsa sipoe lee, ku mbwale-mbwale kâ, ŋineŋga Yesu iyoka lââ bwalika kulu ilâ panzi. ");
INSERT INTO xsi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kinzi matanzi ilâ simora Yesu iyoka lââ bwalika kulu imâ panzi, kala tininzi ruru. Siruru pâta ku siporo tu, “Ŋine nde barâwe ma!”, aku sitara pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Andeta walele nâ Yesu ipainzi tu, “Wa, miki tinimi kaika, karuru ndimo! Ŋine nde naŋani warakâŋgu!” ");
INSERT INTO xsi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ande Petero itu lâ kawa ku ipai tu, “Maro Ŋalae, ambo ŋine nde nokoni, ande kupai naŋa tu ayoka lââ kulu amâ pano.” ");
INSERT INTO xsi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aku Yesu ipai tu, “Kumâ!” Ŋineŋga Petero ipile wâŋga ku iyoka lââ bwalika kulu imâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Petero imâ lee, ŋineŋga mata indue imora kâla kâki ŋalae, aku iruru. Ŋineŋga imbwatuke tini mwata lâ lââ ilo. Iruru pâta kala isuŋa kawa ino Yesu tu, “Maro Ŋalae, kuvilana!” ");
INSERT INTO xsi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aku walele nâ Yesu io mbau ilâ isaŋa Petero, aku ipai tu, “Opopo, noko ne kalo-tawana nde mota mwata. Mana mana ŋga noko ilo rua-rua, a?” ");
INSERT INTO xsi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kinzi rua sisoŋga sikâki wâŋga kulu, aku ndainani nâ lawea kautu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kinzi pâri-tamâta simo wâŋga kulu ŋinde nde matanzi simora mâsi ŋalae ŋinde, aku sipanea Yesu sipai tu, “Mao nâ, Maro Kindeni Natu kala nokoni!” ");
INSERT INTO xsi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ŋineŋga Yesu tavanzi ne pâri-tamâta simbwaliu silâ sitoa Genesaret lawea. ");
INSERT INTO xsi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kinzi tamâta papa nia ŋinde sisama Yesu kilala lâ. Mine kala sipasupwa ilâ panzi lawea rârâni ikeno laiti, aku kinzi tamâta lâ lawea ŋinde sikainzi nenzi pukoŋa tamâta rârâni simâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kinzi sino Yesu tu, “Noko ma kusâu panzi pukoŋa tamâta ŋine tu sio mbaunzi nâ ilâ sitaŋo noko ne pasawaŋa ŋgaŋe.” Isâu lâ, aku kinzi pukoŋa tamâta ea sitaŋo Yesu ne pasawaŋa ŋgaŋe ŋinde, ande kinzi ŋinde rârâni tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lâ zo ŋinde, kinzi tamâta pinde lâ Parisai ŋgu wa kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde sipile Jerusalem, aku sindue simâ pa Yesu. Sisânda Yesu kulu lâ, ŋineŋga sikasoŋa tu, ");
INSERT INTO xsi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Mana mana ŋga noko ne pâri-tamâta silaŋa sipole timbunda nenzi vetâŋa muŋgâŋa, a? Lâ zo ŋana sika kâpwa, ande noko ne pâri-tamâta ŋandai sipua mbalaunzi lâ ŋga sika.” ");
INSERT INTO xsi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Andeta Yesu itu lâ kawanzi ku ipainzi tu, “Mana mana ŋga miki uru koka timbumi nenzi vetâŋa nâ muli, aku kalaŋa kapole Maro Kindeni ne ŋgua tukuŋa, a?” ");
INSERT INTO xsi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yesu iporo ŋgua ŋine lâ, ŋineŋga itula nenzi vetâŋa soki toŋge pwataki mine tu, “Maro Kindeni muŋga iporo tu, ‘Noko ma kupaloŋo pa tina-tama kawanzi ŋgua. Ambo tamâta toŋge iporo soki panzi tina-tama, ande kinzi katonâŋa ma sipu i pâta imâte.’ ");
INSERT INTO xsi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aŋga miki uru kapanananzi tamâta ŋgua kie toŋge. Miki uru kaporo tu, ‘Ambo tamâta toŋge ne mbaliŋa keno ŋana isukanzi tina-tama, andeta tamâta ŋinde ilo patea tu mbaliŋa ŋinde ma io ilâ pa Maro Kindeni, ");
INSERT INTO xsi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ande ara ŋana ipu muli panzi tina-tama’. Opopo, miki uru kasâu ŋana mâsi soki ŋinde, ande kala miki katoto Maro Kindeni ne ŋgua tukuŋa utu, aku kasuka warakami nemi vetâŋa kâki. ");
INSERT INTO xsi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Ŋgua-tulâŋa tamâta Aisaia muŋga ikai Maro Kindeni kawa ku itula miki kilalami pwataki sondo mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kinzi ŋgu ŋine uru sipanea naŋa koa tia nâ lâ kawanzi, aŋga ilonzi nde keno pa naŋa tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kinzi uru situla tamâta nâ nenzi ŋgua tukuŋa, aku siporo tu, “Maro Kindeni kawa ŋgua kala ŋine”. Mine kala sipanea naŋa koa tia nâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ŋineŋga Yesu isarâwa panzi tamâta tu simâ kuku, aku ipainzi tu, “Miki kaloŋo naneŋgu ŋgua, aku kalomi ŋgere sondo ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kelekele ndia iyoka tamâta kawa indue pa kapwa ilo, ande ŋinde ikura tu iveta muso papa i lâ Maro Kindeni nao, ande tia. Aŋga ilo-kalo wa ŋgua ndia ikeno tamâta ilo ŋga iyâti pa nia yo, ande ŋinde nâ ikura tu iveta muso papa i lâ Maro Kindeni nao.” ");
INSERT INTO xsi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu iporo ŋgua ŋine lâ, ŋineŋga i ne pâri-tamâta simâ papa ku sipai tu, “Wa, kinzi Parisai tamâta siloŋo noko ne ŋgua ŋinde, aku ilonzi makisa ŋana. Tiambo noko kusama ŋine tia, a?” ");
INSERT INTO xsi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Andeta Yesu itu lâ kawanzi ku isia ŋgua ŋananzi Parisai tamâta mine tu, “Naŋa mama imo samba ilo, aku i ne tâno kala ŋine. Mine nde kelekele ndia kinzi tamâta sipau lâ i ne tâno ŋine, ande muli i tamwata ma imburu ŋinde ndoni. ");
INSERT INTO xsi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mine nde miki kapilenzi Parisai tamâta ŋinde simo. Kinzi matanzi leva-leva, andeta situ situla nzâla panzi tamâta pinde matanzi leva-leva mine nâ. Ambo tamâta leva-leva toŋge itogo tu itula nzâla papa tamâta leva-leva toŋge, ande kinzi ruani ma patanzi sindue mbââ ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ŋineŋga Petero ipai Yesu tu, “Ŋgua tambirâŋa kala noko kutula panzi Parisai ŋinde, ande kutula ŋinde ne duvi pwataki pa maka kaloŋo.” ");
INSERT INTO xsi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Andeta Yesu ipai tu, “Opopo, miki warakami kala ilomi kalomi ipâŋga tia yo, a? ");
INSERT INTO xsi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tiambo miki kasama ŋine tia tâ; kelekele rârâni tamâta sika lâ kawanzi, ande ŋinde indue pa kapwanzi ilo, ku mbusalinzi simbariŋa lâ. ");
INSERT INTO xsi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aŋga ilo-kalo wa ŋgua ndia kinzi tamâta siporo lâ kawanzi, ande ŋinde iyoka tamâta ilonzi ŋga iyâti pa nia yo. Kelekele ŋinde nâ ikura tu iveta muso papa tamâta lâ Maro Kindeni nao. ");
INSERT INTO xsi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mao nâ, kinzi tamâta nenzi ilo-kalo sakamao uru igagatinzi ŋana sipunzi tamâta pâta simâte wa, sipanawe tamâta kaiwanzi wa, sipalulua tininzi potomule wa, sipanâwe wa, siporo ŋgua laŋeŋa wa, situ tamâta laginanzi wa. ");
INSERT INTO xsi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Vetâŋa sakamao kie-kie ŋinde rârâni nde iveta muso papa tamâta lâ Maro Kindeni nao. Taitu miki kaloŋo ŋga; ambo tamâta ipua mbalua tia ŋineŋga ika, ande ŋine iveta muso papa i lâ Maro Kindeni nao, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu ipile Genesaret lawea, ŋineŋga iyoka ilâ pa tâno ŋinde Tair lawea ŋga Saidon lawea keno ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ipâŋga nia ŋinde lâ, ŋineŋga Kenan ŋgu taine toŋge, i uru imo nia ŋinde, ande imâ pa Yesu ku isarâwa tu, “Tamâta Ŋalae, noko Daviti ne vâsa, kalo sukâŋa ŋanana! Koroani saka toŋge ipagagara naŋa natuŋgu taine lâ, kala iveta malia wa nâna ŋalae tina papa.” ");
INSERT INTO xsi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Andeta Yesu iporo ŋgua toŋge lâ taine ŋinde kawa, ande tia. Mine kala Yesu ne pâri-tamâta simâ papa ku sipai tu, “Wa, taine ŋine imo isasarâwa nâ itawa kinda imâ. Kuŋara ilâ tâ!” ");
INSERT INTO xsi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ande Yesu iporo mine tu, “Maro Kindeni isupwa naŋa amâ ŋananzi Isrel ŋgu simbonzi nâ. Kinzi ŋinde sitogonzi ‘lama’ sisapiri kala soka potomule siroroto ŋana nzâla kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ŋineŋga taine ŋinde imâ Yesu tini laiti aku ipare tuku papa, aku ino papa kilo tu, “Tamâta Ŋalae, kuvilana!” ");
INSERT INTO xsi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ŋineŋga Yesu isia ŋgua papa tu, “Ambo sikai lâlu kapwanzi ku siliŋi ilâ panzi mbwâmbwa, ande ŋine nde ara tia.” ");
INSERT INTO xsi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Andeta taine ipai Yesu tu, “Tamâta Ŋalae, noko kuporo mao nâ; ambo taitu kinzi mbwâmbwa uru sika kâpwa punu-punu ŋinde lâlu sika ambo iyauru indue tamanzi nenzi peke kalo.” ");
INSERT INTO xsi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ŋineŋga Yesu ipai taine ŋinde tu, “Taine, noko ne kalo-tawana nde ŋalae ŋinde! Vetâŋa ŋine noko ilo tu aveta pano, ande ma aveta.” Aku lâ zoni ndaina, koroani saka ipile taine ŋinde natu taine ikâwa ilâ, aku natu tini ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ipile lawea ŋinde ku iyoka ilâ pa Galilaya Lââ bwalika pwali. Ŋineŋga iyoka ilâ ikâki tuu toŋge kulu isaŋona. ");
INSERT INTO xsi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aku kinzi tamâta ŋgu ŋalae simâ papa, aku sikai nenzi pukoŋa tamâta tava simâ kunzi. Sikainzi tamâta pinde kenzi sakamao, aŋga tamâta pinde matanzi leva-leva, aŋga tamâta pinde kenzi tuka simwaŋgi, aŋga tamâta pinde kawanzi siporo ŋgua tia, aŋga tamâta pinde nenzi pukoŋa kie-kie rârâ tona; sikainzi tamâta rârâni ŋinde simâ sionzi ndue simo Yesu tini laiti. Aku Yesu ivetanzi tamâta ŋinde rârâni tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kinzi tamâta ŋgu ŋalae simora Yesu ne mâsi ŋinde. Simora tu ivetanzi tamâta ŋinde kawanzi muŋga siporo ŋgua tia, ande siporo ŋgua kilo; aŋga ivetanzi tamâta ŋinde tukanzi muŋga simwaŋgi, ande tukanzi sondo kilo; aŋga ivetanzi tamâta ŋinde kenzi muŋga sakamao, ande soka kilo; aŋga ivetanzi tamâta ŋinde matanzi muŋga leva-leva, ande simora nia kilo. Mine kala kinzi ŋgu ŋalae wisinzi motutu, aku sipanea Isrel nenzi Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ŋineŋga Yesu isarâwa panzi ne pâri-tamâta tu simâ kuku, aku ipainzi tu, “Naŋa kaloŋgu sukâŋa ŋananzi tamâta ŋgu ŋalae ŋine, ŋana tu kinzi simo kuku naŋa ikura kari ŋato lâ, aku kapwanzi ŋana sika kâ ande sika marumbu lâ. Naŋa tiniŋgu pwâka tu aonzi soka sitaulo silâ pa nenzi lawea lawea. Tia ma putole ipunzi pâta, aku ma patanzi lâ nzâla.” ");
INSERT INTO xsi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Andeta i ne pâri-tamâta siporo taulo tu, “Opopo, nia ŋai nde nia bilimu ma! Mine kala ma takai kâpwa lâ ndia ŋga ikura tasuanzi tamâta ŋgu ŋalae ŋine, a?” ");
INSERT INTO xsi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ande Yesu ikasoŋanzi, “Aŋga miki nde puroŋa ŋapia keno pami.” Kinzi siporo taulo tu, “Puroŋa lima kanaŋo rua tava iŋa kiri-kiri pinde nâ kala keno pama.” ");
INSERT INTO xsi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ŋineŋga Yesu ipainzi tamâta tu lambunzi ndue sisaŋona tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ŋineŋga ikai puroŋa ŋga iŋa ŋinde kâki, kawa ndaŋge papa Maro Kindeni, ku ipwataki lâ, ŋineŋga ilanzi ne pâri-tamâta tu siwae panzi ŋgu. Aku sikai siwae panzi. ");
INSERT INTO xsi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kinzi tamâta ŋgu ŋinde nde sika kuranzi lâ, ŋineŋga Yesu ne pâri-tamâta sigona puroŋa wa iŋa katiŋe keno ŋinde lâ ŋgâmo ŋalae lima kanaŋo rua ilonzi pipi lâ. ");
INSERT INTO xsi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kinzi tamâne kala sika kâpwa ŋinde kambwaŋenzi ikura 4,000. Aku nenzi taine wa lâlu sika kunzi tona. ");
INSERT INTO xsi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ŋineŋga Yesu ionzi ŋgu ŋinde silâ. Silâ lâ, ŋineŋga ikâki wâŋga kulu ilâ papa Magadan lawea kâ. ");
INSERT INTO xsi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aku muli, zo toŋge, ŋineŋga kinzi Juda tamâta pinde lâ Parisai ŋgu wa Sadyusi ŋgu nde simâ pa Yesu tu sikai samâŋa papa. Kinzi sino tu ma ikai Maro Kindeni ne walo ŋalae ku iveta mâsi kaika toŋge panzi simora. ");
INSERT INTO xsi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Andeta Yesu itu lâ kawanzi mine tu, “Ikura lala lala, ambo miki kamora samba tini kilala tu puro-puro, ande miki uru kaporo tu, ‘Wurita ma karâzi tia’. ");
INSERT INTO xsi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aŋga ikura mboyo mboyo, ambo miki kamora samba tini kilala tu puro-puro aku take-take mâmâŋga keno samba tini tava, ande miki uru kaporo tu, ‘Lâ kari ŋine ma karâzi imbe’. Mao nâ, miki uru kamora nia maa ikeno âta ŋinde kilala mine, aku kapatea sondo. Andeta kala ŋine miki kamora vetâŋa rârâ pinde, aku vetâŋa ŋinde itula vetâŋa ŋana ipâŋga muli ŋinde kilala pwataki; andeta miki kazizâla ŋana. ");
INSERT INTO xsi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Opopo, kinzi kiesaka tamwatanzi ŋandai sio ilonzi kalonzi ilâ mao papa Maro Kindeni ŋga! Miki kano naŋa tu kamora Maro Kindeni ne mâsi kaika toŋge, a? Naŋa ma atula mâsi kaika toŋge pami, ande tia ndo. Andeta Maro Kindeni ma itula mâsi kaika taitu nâ pami, itogo muŋga itula pa ŋgua-tulâŋa tamâta Yona mine.” Yesu iporo ŋgua ŋine lâ, ŋineŋga ipilenzi ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu ne pâri-tamâta nde silâ sipâŋga lââ bwalika tini pinde. Andeta kinzi kalonzi kapa ŋana sikai kanzi puroŋa ŋana sika kâ. ");
INSERT INTO xsi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ande Yesu ipainzi tu, “Miki kapakatona sondo ŋga. Kapakatona warakami ŋana kinzi Parisai wa Sadyusi tamâta nenzi ‘yisi’.” ");
INSERT INTO xsi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ŋineŋga kinzi pâri-tamâta warakanzi siporo imâ naonzi nâ mine tu, “O, kinda ŋandai takai puroŋa pinde tamâ ŋga, kala Yesu iporo ŋgua mine.” ");
INSERT INTO xsi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Andeta Yesu isama lâ ŋana nenzi ilo-kalo soki-soki ŋinde. Mine kala ipainzi tu, “Opopo, miki nemi kalo-tawana nde mota mwata nâ! Ŋana sâ kâ ŋga miki warakami kaporo mine tu, ‘Kinda takai puroŋa tia’, a? ");
INSERT INTO xsi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tiambo miki ilomi kalomi tia tâ! Tiambo miki ŋandai kalomi ŋgere ŋana puroŋa lima ŋinde naŋa muŋga alanzi tamâne 5,000 sika, a? Lâ zo ŋinde, ande miki kazeze ŋgâmo ŋapia ilonzi ipipi lâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aku tiambo miki kala ŋandai kalomi ŋgere ŋana puroŋa lima kanaŋo rua ŋinde naŋa muŋga alanzi tamâne 4,000 sika, a? Lâ zo ŋinde, miki kazeze ŋgâmo ŋapia ilonzi ipipi lâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Naŋa muŋga nâ apaimi tu kapakatona sondo ŋana kinzi Parisai wa Sadyusi nenzi ‘yisi’. Andeta naŋa ŋandai aporo ŋgua pami ŋana puroŋa ŋga. Mana mana ŋga miki kasama ŋgua ŋine ne duvi sondo tia yo, a?” ");
INSERT INTO xsi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kinzi siloŋo Yesu ne ŋgua ŋine lâ, ŋineŋga kulunzi kâmba ipwa ku sisama tu Yesu ŋandai ipainzi tu ma sipakatona ŋana puroŋa ne “yisi” ŋga. Ipainzi tu ma sipakatona ŋana kinzi Parisai wa Sadyusi tamâta nenzi ŋgua soki-soki uru sipanananzi tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu iyoka ilâ pa nia pinde ikeno Sisaria Pilipai lawea tini laiti. Ipâŋga nia ŋinde lâ, ŋineŋga ikasoŋanzi ne pâri-tamâta mine tu, “Kinzi tamâta uru siporo situ naŋa Tamâta Natu nde ea.” ");
INSERT INTO xsi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ŋineŋga kinzi siporo taulo tu, “Kinzi tamâta pinde situ noko nde Yoane Lââ-Liliŋa Tamwata; aŋga pinde nde situ noko nde ŋgua-tulâŋa tamâta Ilia; aŋga pinde nde situ noko nde ŋgua-tulâŋa tamâta Jeremaia tâku ŋgua-tulâŋa tamâta muŋgâŋa toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ŋineŋga Yesu ikasoŋanzi kilo tu, “Aŋga miki warakami nde katu naŋa nde ea.” ");
INSERT INTO xsi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Petero itu lâ i kawa mine tu, “Noko nde Kirisi. Maro Kindeni Via Tamwata Natu kala noko.” ");
INSERT INTO xsi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ŋineŋga Yesu ipai Petero tu, “Saimon, Yoane natu, Maro Kindeni ne nzâmbe ikeno pano. Ŋana tu tamâta toŋge muŋga itula ŋgua ŋine pa noko, ande tia. Naŋa Mama imo samba ilo, ande i simbo nâ itula ŋine pano. ");
INSERT INTO xsi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mine kala naŋa apaino tu, ‘Petero, noko ne kalo-tawana ipâŋga itogo mira mwasina, aku naŋa ma agonanzi naneŋgu ŋgu aonzi simandi mira ŋinde kulu. Aŋga mateŋa ne kaika ma ikura tu izavaru ŋgu ŋinde, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Noko ma pwai poe panzi tamâta ŋinde Maro Kindeni uru ikai maro panzi. Aku vetâŋa ndia rârâni noko kundi ŋana lâ tâno ŋine kulu, ande Maro Kindeni ma indi ŋana mine nâ lâ samba ilo. Aŋga vetâŋa ndia rârâni noko kusâu ŋana lâ tâno ŋine kulu, ande Maro Kindeni ma isâu ŋana mine nâ lâ samba ilo.’” ");
INSERT INTO xsi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu iporo ŋgua ŋine lâ, ŋineŋga indi kaika panzi pâri-tamâta tu ma sitapâri pa tamâta toŋge tu i nde Kirisi, mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lâ zoni ndaina, Yesu itula ŋgua pwataki panzi ne pâri-tamâta mine tu, “Maro Kindeni ne pateâŋa ikeno tu naŋa ma alâ Jerusalem. Ŋineŋga kinzi katonâŋa wa patarawâŋa tamâta ŋalaŋala wa kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa, kinzi ŋinde ma siveta kenzi sakamao ndo pa naŋa. Aku i ne pateâŋa ikeno tu kinzi ma sipu naŋa pâta amâte. Andeta kari ŋato lâ, ŋineŋga i ma ipaŋo naŋa amandi amo viâŋgu kilo.” Aku muli, Yesu iporo ŋguani ndaina panzi kilo mbwani pinde. ");
INSERT INTO xsi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero nde iloŋo ŋgua ŋine, ŋineŋga ikai Yesu siyâti silâ pa nia ŋgaŋe, aku ilelea Yesu pâta ŋana i ne ŋgua ŋinde kâ. Ipai Yesu tu, “Maro Ŋalae, mine tia ndo! Maro Kindeni ŋandai ilo tu vetâŋa mine ma ipâŋga pano ŋga!” ");
INSERT INTO xsi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Andeta Yesu ipupulia lâ aku imbita Petero, ipai tu, “Sadana, noko pwâwa kulâ malawae! Noko kutu kupono naŋa nzalâŋgu. Noko pwoka tamâta nâ nenzi ilo-kalo muli, kala noko ŋandai kuporo ŋgua ikura Maro Kindeni ne ilo-kalo ŋga.” ");
INSERT INTO xsi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ŋineŋga Yesu ipainzi ne pâri-tamâta mine tu, “Ambo tamâta toŋge ilo tu ipono muli pa naŋa, ande i ma ipatawa tamwata tini ku ikale ne kâi popole iyoka naŋa muliŋgu. ");
INSERT INTO xsi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ŋana tu tamâta ea ilo ŋalae ŋana tamwata ne via, ande i ma ikai via mao, nde tia. Aŋga tamâta ea kalo tawana naŋa kala imora tamwata ne via tu kelekele kaa nâ, ande tamâta ŋinde ma imo via ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Miki kalomi ŋgere sondo ŋga; ambo tamâta toŋge igona tâno ne kelekele rârâni ŋineŋga imâte, ande i ne via mao ikeno ndia, a? Aku i ma ikura tu iko tamwata ne via kilo lâ mbumbu ŋapia, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Miki kaloŋo ŋga; zo mbwana-mbwana nâ, ŋineŋga naŋa Tamâta Natu ma akai Mama ne walo ŋalae, aku ma ayoka pa samba amâ kunzi Mama ne aŋelo. Aku lâ zoni ndaina naŋa ma apare nia panzi tamâta rârâni, ipakura kuku vetâŋa ndia muŋga siveta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Naŋa aporo mao nâ pami; miki pinde kala kamo ŋai ma kamâte tia yo yo, ŋineŋga miki ma kamora naŋa Tamâta Natu apatua lâ nia yo ku akai maro panzi tamâta lâ tâno kulu.” ");
INSERT INTO xsi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kari lima kanaŋo taitu ilâ lâ, ŋineŋga Yesu ikainzi Petero, aŋga Yamesi kuku tai Yoane rua, aku sikâki silâ tuu ŋalae toŋge kulu. Aku kinzi ŋapa simbonzi nâ simo ndaina. ");
INSERT INTO xsi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ŋineŋga kinzi pâri-tamâta ŋato ŋinde nde simora Yesu tini pasinala, aku ipâŋga kie toŋge. I nao nde isinala nia itogo kari mine, aŋga ne pasawaŋa nde ipâŋga togo sinâla mwasina, ku pâne ndo. ");
INSERT INTO xsi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ŋineŋga Mose ku Ilia rua simâ sipâŋga, aku kinzi pâri-tamâta matanzi ilâ simoranzi ŋgua-tulâŋa tamâta muŋgâŋa rua ŋinde simandi siporo kuku Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero imora mâsi ŋinde ku ipai Yesu tu, “Maro Ŋalae, kinda tamo ŋaina, aku ŋine nde ara ndo. Ambo noko ilo mine, ande naŋa ma apa pâla ŋato: noko ne toŋge, aŋga Mose ne toŋge, aŋga Ilia ne toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petero iporo ŋgua ŋine marumbu tia yo, ŋineŋga take-take pâne toŋge ipâŋga ku itura kinzi rârâni lâ. Aku kawa toŋge ne sarawâŋa iyoka pa take-take ilo imâ mine tu, “Naŋa natuŋgu ara kala ŋine. Naŋa tiniŋgu mwasa papa wa iloŋgu ndeka papa wa. Miki ma katambira taŋami pa i kawa ŋgua!” ");
INSERT INTO xsi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kinzi pâri-tamâta siloŋo ŋgua ŋine lâ, ŋineŋga sipare tukunzi naonzi tundu pa tâno, aku siruru pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ŋineŋga Yesu imâ tininzi laiti aku mbau ilâ itaŋonzi, ku ipainzi tu, “Kamandi sânda ŋga. Miki karuru ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ŋineŋga naonzi kâki matanzi simora, andeta simora Yesu simbo mai nâ; take-take nde ilâ lâ, aku tamâta toŋge imo kuku Yesu, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kinzi sipile tuu ŋinde, aku soka sindue yo, ŋineŋga Yesu indi kaika panzi tu, “Miki ma katapâri pa tamâta toŋge ŋana mâsi miki kamora ŋinde ndimo. Andeta muli ŋga, lâ zo ŋinde Maro Kindeni ma ipaŋo naŋa Tamâta Natu amandi lâ mateŋa nianzi amo viâŋgu kilo, ŋineŋga katapâri panzi tamâta ŋana mâsi ŋinde kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ŋineŋga kinzi pâri-tamâta sikasoŋa Yesu tu, “Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru siporo ŋgua ŋana Ilia mine tu i ma imâ muŋga lâ ŋga, ŋineŋga Kirisi ma imâ. Ŋinde nde duvi mana.” ");
INSERT INTO xsi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ande Yesu itu lâ kawanzi tu, “Ŋgua ŋinde nde mao nâ. Ilia imâ muŋga ŋana iveta kelekele rârâni sondo. ");
INSERT INTO xsi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Taitu kala ŋine naŋa apaimi tu Ilia nde imâ lâ, andeta kinzi Juda tamâta sisama i kilala sondo, nde tia. Aku mâsi sakamao rârâni kinzi situ ma siveta papa, ande siveta lâ. Aku kinzi ma siveta mâsi sakamao kie taituni pa Tamâta Natu.” ");
INSERT INTO xsi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu iporo ŋgua ŋine lâ, ŋineŋga kinzi pâri-tamâta sisama tu Yesu isia ŋgua ŋana Yoane Lââ-Liliŋa Tamwata kâ lâ Ilia tini. ");
INSERT INTO xsi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu tavanzi ne pâri-tamâta ŋato ŋinde sindue silâ lee sipâŋga kunzi tamâta ŋgu ŋalae. Sipâŋga lâ, ŋineŋga tamâta toŋge imâ pa Yesu aku ipare tuku papa. ");
INSERT INTO xsi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Aku ipai Yesu tu, “Tamâta Ŋalae, naŋa ano pano tu kalo sukâŋa ŋana natuŋgu tamâne. Zo pinde ipâŋga kapa lâ, aku imo sakamao ndo, ŋana tu i uru pata ndue yââ kulu wa lââ ilo wa. ");
INSERT INTO xsi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naŋa muŋga akai i amâ panzi noko ne pâri-tamâta, andeta kinzi sikura tu siveta ipâŋga ara kilo, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ŋineŋga Yesu iporo taulo tu, “Opopo, miki tamâta ŋandai kalomi tawana Maro Kindeni ŋga. Miki ilomi kalomi wa nemi mâsi nde soki ndo! Ayo, naŋa ma amo kuku miki ikura zo ŋapia kilo, a? Aŋga nemi ilo-kalo soki-soki ma iveta naŋa iloŋgu malia ikura zo ŋapia kilo, a? Kakai lâlu ŋinde kamâ pa naŋa!” ");
INSERT INTO xsi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sikai lâlu simâ lâ, ŋineŋga Yesu iporo kaika imbita koroani saka imo lâlu ilo ŋinde, aku koroani saka ipile lâlu ku ikâwa ilâ. Aku ndainani nâ, lâlu ŋinde ne pukoŋa marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku muli, ŋineŋga Yesu ne pâri-tamâta simbonzi nâ simâ pa Yesu ku sikasoŋa tu, “Muŋga maka katogo tu kasoki koroani saka ŋinde, andeta kakura tia. Ŋinde nde duvi mana.” ");
INSERT INTO xsi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aku Yesu ipainzi tu, “Miki nemi kalo-tawana nde mota mwata nâ, kala miki kakura tia. Naŋa aporo mao nâ pami; ambo miki nemi kalo-tawana ma itumbu tini mwata, itogo ‘mastet’ vâsa mine, ande miki ma kakura tu kasupwa tuu ndai mine tu, ‘Noko kumandi ku kulâ pa nia pinde!’, aku tuu ma iyoka ilâ. Ambo miki kalomi tawana Maro Kindeni, ande miki ma kakura tu kaveta vetâŋa kie-kie rârâni.  ");
INSERT INTO xsi_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ambo miki ma katu kaika ŋana kâpwa kâ ku kakai noŋa kaika nâ, ande ma kakura tu kasokinzi koroani saka sitogo koroani saka ŋinde. Nzâla toŋge keno, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zo pinde ilâ lâ, ŋineŋga Yesu ikainzi ne pâri-tamâta rârâni simâ taitu lâ Galilaya tâno. Ŋineŋga ipainzi tu, “Kinzi ma sio naŋa Tamâta Natu lâ tamâta pinde mbaunzi ilo, ");
INSERT INTO xsi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","aku ma sipu naŋa pâta amâte. Andeta kari ŋato lâ, ŋineŋga Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo.” Kinzi pâri-tamâta siloŋo Yesu ne ŋgua ŋine, kala ilonzi putuka ndo. ");
INSERT INTO xsi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zo pinde ilâ lâ, ŋineŋga Yesu ikainzi ne pâri-tamâta ku soka silâ sipâŋga Kaperneam lawea. Ŋineŋga tamâta pinde, kinzi ŋinde uru siveta wurâta ŋana sikai mbumbu ŋana Maro Kindeni ne luma sapâŋa kâ, ande simâ pa Petero. Aku sikasoŋa tu, “Wa, noko ne pananâŋa uru io mbumbu ŋana luma sapâŋa kâ, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aku Petero isâu panzi tu, “Mao nâ, i uru iveta mine.” Ŋineŋga Petero iyoka ilâ luma Yesu imo ŋinde ilo. Petero iporo ŋgua toŋge tia yo, andeta Yesu ikasoŋa mine tu, “Saimon, noko ilo mana. Ea kinzi uru sio mbumbu ilâ panzi koipu ŋalaŋala lâ tâno kulu. Tiambo kinzi koipu warakanzi seenzi wa natunzi wa uru sio mbumbu ilâ panzi, tiya?, kinzi tamâta pinde uru siveta mine.” ");
INSERT INTO xsi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero iporo taulo tu, “Kinzi tamâta pinde uru sio mbumbu ilâ panzi.” Ŋineŋga Yesu ipai tu, “Mine nde koipu see kinzi ma mbumbu silua tia. ");
INSERT INTO xsi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Taitu kuloŋo ŋga; ambo kinda ma tao luma sapâŋa ne mbumbu ilâ panzi wurâta tamâta ŋinde tia, ande ma wisinzi nâna pa kinda. Mine nde kulâ kuo gigi lâ lââ bwalika ilo. Kuveta mine lee, ku gigi ma ikai iŋa toŋge. Kutapa iŋa ŋinde kâki ku kunzaŋa i kawa, aku ma kusânda mbumbu toŋge ikeno iŋa kawa ilo. Pwai mbumbu ŋinde kulâ, aku kulanzi kinzi tamâta ŋana luma sapâŋa mbumbu kaiŋa kâ. Ŋinde ma ikai nenzi mbuku piti lâ kinda rua tininda.” ");
INSERT INTO xsi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lâ zo ŋinde kinzi pâri-tamâta simâ pa Yesu, aku sikasoŋa tu, “Ea imo mbâna-mbâna panzi tamâta ŋinde Maro Kindeni ikai maro panzi.” ");
INSERT INTO xsi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ŋineŋga Yesu isarâwa pa lâlu kiri-mwata toŋge tu imâ, aku iŋgunu imandi pâri-tamâta naonzi. ");
INSERT INTO xsi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ŋineŋga Yesu ipainzi tu, “Naŋa aporo mao nâ pami; Maro Kindeni ikai maro panzi tamâta ea sitogonzi lâlu kiri-kiri mine. Mine nde miki kaloŋo ŋga; ambo miki ma kapalele ilomi kalomi tia, ande miki ma kakura tu kamo Maro Kindeni ne ŋgumbi ilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ambo tamâta toŋge ipatawa tamwata tini, itogo lâlu kiri-mwata ŋine uru iveta mine, ande tamâta ŋinde ma imo mbâna-mbâna panzi tamâta Maro Kindeni ikai maro panzi ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ambo tamâta toŋge kalo tawana naŋa kala iveta kie ara pa lâlu mota toŋge itogo lâlu ŋai, ande i iveta kie ara pa naŋa tona.” ");
INSERT INTO xsi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ŋineŋga Yesu iporo tu, “Ambo tamâta toŋge ma iyaula i tini pinde ne kalo-tawana, kala ipu muli pa naŋa, ande ŋinde nde mâsi sakamao ndo. Ara ŋana kinzi nia ndoyo ma sipa mira ŋalae toŋge lâ tamâta ŋinde ŋandola tâ ku sitambira indue tâi geza-geza ilo mbo inu tâi mbo imâte tâ. Ŋana tu ambo kinzi muŋga siveta mine papa, ande i ma ikura tu iyaula tini pinde ŋinde ne kalo-tawana, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Vetâŋa sakamao ma ipâŋga panzi tamâta ŋinde uru siveta tamâta pinde sipile nenzi kalo-tawana. Mao nâ, vetâŋa pinde ma ipâŋga panzi tamâta ku isowe ilonzi kalonzi ŋana siveta kiesaka kâ. Andeta vetâŋa sakamao ndo ma ipâŋga pa tamâta ea iveta vetâŋa ŋinde ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ambo noko mbalau tâku kie ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kutoto ŋinde piti ku kutambira ilâ. Ambo noko mbalau taitu nâ, tâku kie taitu nâ, ande ŋinde nde ara koŋa tia; andeta muli ŋga, noko ma kumo via ku kumo nâ. Taitu kuloŋo ŋga; ambo noko kie-mbalau rua, andeta muli Maro Kindeni ma itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aku mine nâ, ambo noko mata toŋge ilaŋeno kala kuveta kiesaka, ande ara ŋana kupasiki mata ŋinde piti ku kutambira ilâ. Ambo noko mata taitu nâ, ande ŋinde nde ara koŋa tia; andeta muli, noko ma kumo via ku kumo nâ. Taitu kuloŋo ŋga; ambo noko mata rua, andeta muli Maro Kindeni ma itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Miki kapakatona sondo ŋga! Tia ma miki kamoranzi tamâta pinde, nenzi kalo-tawana itogo lâlu nenzi kalo-tawana mine, aku ma ilomi tu, ‘Kinzi nde tamâta kaa nâ’. Naŋa apaimi tu lâ samba ilo, kinzi kalo-tawana tamâta ŋinde nenzi aŋelo nde uru simandi naŋa Mama nao ikura zo zo.”  ");
INSERT INTO xsi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Naŋa Tamâta Natu amâ ŋana akainzi tamâta muŋga sisapiri kala soka potomule ŋinde piti lâ kondoma ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ŋineŋga Yesu itambira ŋgua panzi ne pâri-tamâta mine tu, “Miki ilomi mana. Ambo tamâta toŋge ne ‘lama’ kambwaŋenzi tamâta ŋalae taitu (100) simo, andeta lama toŋge isapiri ku nao tia lâ, ande i ma iveta mana. Naŋa apaimi tu i ma ipilenzi lama ŋgu ŋalae simo tuu kulu, aku ma ilâ mbo iroroto ŋana lama taitu ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Naŋa aporo mao nâ pami, ambo iroto ŋana lee isânda kulu lâ, ande i ma indeka pâta ku wisi puu ndue. I ma indeka ŋalae koŋa tia ŋananzi lama 99 ŋinde ŋandai sisapiri ŋga; ambo taitu i ma indeka ŋalae tina ŋana lama ŋinde muŋga isapiri ŋineŋga isânda kulu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aku mine nâ, miki Tamami imo samba ilo ŋinde nde tini pwâka tu kalo-tawana tamâta toŋge ma ipile ne kalo-tawana ku imo niaka.” ");
INSERT INTO xsi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Ambo kalo-tawana tamâta toŋge iveta soki pano, ande kulâ papa aku simbomi rua nâ kaporo ŋgua ŋana kaveta ŋinde sondo kâ. Ambo i kalo sukâŋa ku iporo tu, ‘Mao nâ, aveta soki pano’, ande ara, miki rua ma kamo nambwe-nambwe kilo. ");
INSERT INTO xsi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Taitu kaloŋo ŋga; ambo iporo tu, ‘Naŋa ŋandai aveta soki toŋge ŋga’, ande ara, noko ma pwainzi kalo-tawana tamâta taitu tâku rua, ikura Mose ne ŋgua tukuŋa mine, aku kalâ kaporo pa tamâta ŋinde kilo. Ŋana tu Mose ne ŋgua tukuŋa ikeno mine tu, ‘Ara ŋana kinzi tamâta rua tâku ŋato ma sisuka ŋgua noko kusowe lâ tamâta toŋge tini’. ");
INSERT INTO xsi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ambo noko ma kuveta mine, andeta tamâta ŋinde ipatiâmo ku iporo kilo tu, ‘Naŋa ŋandai aveta soki toŋge ŋga’, ande ara, kulâ kumandi ŋgu naonzi ku kuporo ŋgua ŋine pwataki panzi siloŋo. Ambo i tini pwâka tu iloŋo ŋgu nenzi ŋgua, ande noko ma tini piti ndo ŋana i kâ, itogo uru tini piti ŋananzi tinikoa wa kinzi tamâta sakamao ŋana mbumbu kaiŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Naŋa aporo mao nâ pami; vetâŋa ndia rârâni miki kandi ŋana lâ tâno kulu, ande Maro Kindeni ma indi ŋana mine nâ lâ samba ilo. Aŋga vetâŋa ndia rârâni miki kasâu ŋana lâ tâno kulu, ŋinde Maro Kindeni ma isâu ŋana mine nâ lâ samba ilo. ");
INSERT INTO xsi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Naŋa apaimi kilo tu ambo kinzi kalo-tawana tamâta rua nâ ilonzi taitu ku sikai noŋa pa naŋa Mama imo samba ilo ŋinde tu ma iveta vetâŋa toŋge panzi, ande i ma iveta ikura kinzi rua nenzi noŋa mine. ");
INSERT INTO xsi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ŋana tu lâ zo ndia kinzi kalo-tawana tamâta ŋato tâku rua simâ taitu sipasau ŋana siwâŋgi pa naŋa, ande naŋa warakâŋgu ma amâ amo kunzi.” ");
INSERT INTO xsi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lâ zo ŋinde, Petero imâ pa Yesu ku ikasoŋa tu, “Maro Ŋalae, ambo kalo-tawana tamâta toŋge uru iveta soki pa naŋa, ande naŋa ma apile i ne vetâŋa soki ŋinde mbwaniŋgu ŋapia. Ambo naŋa ma aveta mine mbwaniŋgu lima kanaŋo rua, ande ŋinde ma ikura, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Andeta Yesu itu lâ Petero kawa tu, “Naŋa apaino tu noko ma kuveta mine mbwani lima kanaŋo rua nâ nde tia; noko ma kuveta mine ikura mbwani tamâta ŋalae lima (500). ");
INSERT INTO xsi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Noko kuloŋo ŋga; Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, ande itogo koipu ŋalae toŋge. Koipu ŋinde ilo tu i ne wurâta tamâta rârâni ma sikatu mbuku papa i taulo imâ. ");
INSERT INTO xsi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kinzi simâ ŋana sikatu mbuku kâ, ŋineŋga sikai tamâta toŋge simâ, i muŋga ikai mbumbu 10,000 saŋe koipu ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tamâta ŋinde ikura tu ikatu mbuku ŋinde tia ndo. Mine kala koipu ŋalae ipainzi ne tamâta pinde tu sikai wurâta tamâta ŋinde tavanzi kaiwa-natu, aku sionzi silâ pa tamâta ŋalae toŋge tu ma ikainzi ŋana siveta wurâta koa tia nâ papa. Aku ipainzi tu ma sio tamâta ŋinde ne luma tava ne kelekele ndoni ilâ panzi tamâta tu siko tona, ŋana ma sikai mbaliŋa ŋana sikatu mbuku kâ. ");
INSERT INTO xsi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Andeta wurâta tamâta ŋinde iloŋo ŋgua ŋinde, aku ipare tuku lâ koipu ŋalae kie tini laiti, aku ino mine tu, ‘Kalo sukâŋa ŋanana, aku kundamwana ŋga. Muli ŋga naŋa ma atu ŋana mbumbu ndoni muŋga akai saŋeno ŋinde.’ ");
INSERT INTO xsi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ŋineŋga koipu ŋalae kalo sukâŋa ŋana ku ipai tu, ‘Akai naneŋgu mbuku piti lâ noko tini; kuyâti kulâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ayo, ŋineŋga wurâta tamâta ndainani nâ iyâti ilâ pa nia yo, andeta isânda nuwala toŋge kulu, i ne mbuku peko mwata nâ ikeno papa. Aku mbau ilâ ikai nuwala ŋandola kaika, ku ipai tu, ‘Noko ma kutu ŋana mbumbu rârâni ŋinde muŋga mbo noko pwai saŋe naŋa!’ ");
INSERT INTO xsi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","I nuwala ŋinde nde iloŋo ŋgua ŋinde, ku ipare tuku ipai wurâta tamâta ŋinde mine tu, ‘Kalo sukâŋa ŋanana, aku kundamwana ŋga. Muli ŋga naŋa ma atu ŋana mbumbu ndoni muŋga akai saŋeno ŋinde.’ ");
INSERT INTO xsi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Andeta wurâta tamâta ŋinde wisi nâna ku io nuwala ilâ luma sakamao ilo lee, mambo ikatu mbuku ikura lâ. ");
INSERT INTO xsi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kinzi rua nawalanzi pinde simora tamâta ŋinde iveta mâsi mine, aku ilonzi kura tia. Mine nde silâ siporo ŋgua ŋinde rârâni papa nenzi koipu ŋalae. ");
INSERT INTO xsi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aku marumbu; koipu ŋinde isarâwa pa wurâta tamâta ŋinde imâ, aku ipai tu, ‘Noko wurâta tamâta sakamao! Noko muŋga kuno naŋa, aku akai neŋgu mbuku rârâni piti lâ noko tini. ");
INSERT INTO xsi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mao nâ, naŋa muŋga kaloŋgu sukâŋa ŋalae tina ŋanano. Mine nde ŋana sâ kâ ŋga noko ŋandai kalo sukâŋa ŋana noko nuwala kâ, a?’ ");
INSERT INTO xsi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ŋineŋga koipu ŋalae wisi nâna, aku io wurâta tamâta ŋinde ilâ luma sakamao ilo. Aku ipainzi luma ŋinde ne wurâta tamâta tu ma nâna silua lee, ikura lâ zo ndia ikatu mbuku rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipainzi ne pâri-tamâta mine tu, “Aku mine nâ, ambo kalo-tawana tamâta toŋge iveta soki pano, aku noko tini mwasa papa tia kala kupile i ne vetâŋa soki ŋinde tia, ande Maro Kindeni ma iveta mâsi kie taituni pano, ikura koipu ŋalae ŋinde iveta papa ne wurâta tamâta mine.” ");
INSERT INTO xsi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipile Galilaya tâno ku iyoka ilâ pa Judia tâno ikeno pa Jodan Lââ tini pinde. ");
INSERT INTO xsi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aŋga kinzi tamâta ŋgu ŋalae nde soka i muli silâ. Aku lâ nia ŋinde Yesu ivetanzi pukoŋa tamâta tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aŋga tamâta pinde lâ Parisai ŋgu nde simâ pa Yesu tu sikai samâŋa papa. Sipai mine tu, “Kinda nenda ŋgua tukuŋa keno ŋana tamâne tu ambo i tini pwâka ŋana kaiwa taine kala itu isoki ŋana duvi ndia, ande ikura. Ayo, ŋgua tukuŋa ŋine nde ara, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu nde iporo taulo tu, “Opopo, tiambo miki ŋandai kapono Maro Kindeni ne ŋgua ŋinde ikeno lâ pepa tini, tiya? Ŋgua ŋinde nde mine, ‘Nia ndoyo, Maro Kindeni Puliâŋa Tamwata nde ipulianzi tamâta, ku ionzi taine wa tamâne wa.’ ");
INSERT INTO xsi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aku Maro Kindeni iporo tu, ‘Mine kala tamâne ma ipilenzi tina-tama ku ma ipasipa kuku kaiwa taine nâ, aku kinzi rua ma simo tininzi lâ taitu.’ ");
INSERT INTO xsi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mine nde kinzi ŋandai simo piti piti ŋga; kinzi rua ma simo togo ilonzi wa karaenzi taitu nâ. Mao nâ, Maro Kindeni ipanzi rua lâ taitu lâ; mine nde tamâta toŋge ma itikianzi piti ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ŋineŋga kinzi Parisai tamâta nde sipai Yesu mine tu, “Ayo, mine nde ŋana sâ kâ ŋga Mose ne tukuŋa isâu pa tamâne tu ambo iŋgere ŋgua lâ pepa tini ŋana itoto pakâeŋa kâ, ku pepa ilua kaiwa taine, ande nenzi pakâeŋa nde totoŋa lâ, a?” ");
INSERT INTO xsi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ande Yesu iporo taulo tu, “Miki nde taŋa-kaika tamwatami. Mine kala Mose isâu pami tu kasokinzi kaiwami taine. Ambo taitu muŋgani, lâ nia ndoyo, ande mâsi mine ikeno tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naŋa apaimi tu, ambo tamâne toŋge isoki kaiwa taine, andeta taine ŋinde ŋandai iveta sakamao kuku tamâta toŋge ŋga, ambo tamâne ŋinde ikai taine wasaseki, ande iveta sakamao kuku taine wasaseki ŋinde, kala ilaŋa ipole ŋgua tukuŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kinzi pâri-tamâta siloŋo Yesu ne ŋgua kaika ŋinde, ŋineŋga sipai tu, “Ambo tamâne ŋga taine nenzi pakâeŋa ikeno mine, ande ara ŋana tamâne ma imo simbo mai nâ, ikai taine toŋge tia.” ");
INSERT INTO xsi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Andeta Yesu ipainzi tu, “Kinzi tamâta pinde nâ sikura tu sipaveta kuku ŋgua ŋine. Mao nâ, Maro Kindeni muŋga kaika ilanzi tamâta pinde nâ ŋana sipaveta kuku ŋgua ŋine. ");
INSERT INTO xsi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kinzi tamâta pinde sikâe tia. Kinzi pinde nde tininzi sakamao lâ zo ŋinde tinanzi sipaguguanzi, kala sikura tu sipulianzi natunzi tia. Aŋga pinde nde muŋga tamâta pinde sitoto tininzi piti, kala sikura tu sipulianzi natunzi tia. Aŋga pinde nde ilonzi ndo ŋana siveta wurâta pa Maro Kindeni, kala situ kaika pa warakanzi tu ma sikâe tia. Miki tamâta ea kakura tu kapaveta kuku ŋgua ŋine, ande kapaveta kuku.” ");
INSERT INTO xsi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lâ zo ŋinde kinzi tamâta pinde sikainzi lâlu kiri-kiri simâ pa Yesu. Kinzi ilonzi tu i ma io mbau kâki kulunzi ku ino pa Maro Kindeni ŋananzi tâ. Andeta kinzi pâri-tamâta nde sileleanzi tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aŋga Yesu nde ipainzi pâri-tamâta tu, “Miki ma kasâu panzi lâlu kiri-kiri tu simâ pa naŋa; kapono nzâla ŋananzi ndimo. Ŋana tu Maro Kindeni uru ikai maro panzi tamâta ea nenzi kalo-tawana irerege kuku lâlu kiri-kiri ŋine nenzi kalo-tawana.” ");
INSERT INTO xsi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ŋineŋga Yesu io mbau kâki kinzi lâlu kiri-kiri taitu-taitu kulunzi, ku itu nzâmbe panzi. Iveta mine lâ, ŋineŋga ipile nia ŋinde ku ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Zo toŋge, tamâta toŋge imâ pa Yesu ku ikasoŋa tu, “Pananâŋa, naŋa ma aveta vetâŋa ara ndia ŋga ikura tu amo viâŋgu ku amo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu nde itu lâ kawa mine tu, “Ŋana sâ kâ ŋga noko pwasoŋa naŋa ŋana vetâŋa ara kâ, a? Maro Kindeni simbo nâ nde Ara Tamwata. Ambo noko ilo tu kumo via ku kumo nâ, ande noko ma kupaveta kuku Maro Kindeni ne ŋgua tukuŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ŋineŋga tamâta ŋinde ikasoŋa Yesu kilo tu, “Noko kuporo ŋana tukuŋa ndia.” Ande Yesu ipai tu, “Naŋa aporo ŋana tukuŋa ŋine: ‘Noko ma kupu tamâta pâta ndimo; noko ma kuveta sakamao kuku tamâta toŋge kaiwa ndimo; noko ma kupanâwe ndimo; noko ma kusowe ŋgua laŋeŋa lâ tamâta toŋge tini lâ ŋgua nia ndimo; ");
INSERT INTO xsi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","noko ma kumege ŋananzi tina-tama ku taŋa mwasa nâ panzi; aku noko ma tini mwasa panzi tini pinde itogo noko tini mwasa pa tamwata mine.’” ");
INSERT INTO xsi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aku tamâta ŋinde nde ipai Yesu tu, “Naŋa uru apaveta kuku ŋgua tukuŋa ŋinde rârâni. Aŋga vetâŋa ndia nde naŋa aveta tia yo, a?” ");
INSERT INTO xsi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aku Yesu ipai tu, “Ambo noko ilo tu kumo tamâta sondo ndo lâ Maro Kindeni nao, ande kulâ kuo ne kelekele rârâni ilâ panzi tamâta tu siko kâ. Ŋineŋga mbumbu ŋinde ndoni kulanzi sugorai tamwatanzi. Ambo noko ma kuveta mine, ande noko ma kumo ara ndo lâ samba lawea. Aku kumâ, kupono muli pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tamâta ŋinde iloŋo Yesu ne ŋgua ŋinde, aku ilo malia ndo, ŋana tu i nde mbaliŋa warika. Tia ku ipile Yesu ku ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ilâ lâ, ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Naŋa aporo mao nâ pami; kinzi mbaliŋa warakanzi ande wurâta ŋalae panzi ŋana simo Maro Kindeni ne ŋgumbi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Naŋa aporo kilo pami tu, ambo ŋgoa ŋalae ‘kamel’ itu itambwa ilâ mbiri kiri-mwata ne maa ilo, ande i ma ikura tu iveta mine tia ndo. Aku mine nâ, ambo mbaliŋa warika itu imo Maro Kindeni ne ŋgumbi ilo, ande ŋinde nde wurâta ŋalae tina!” ");
INSERT INTO xsi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kinzi pâri-tamâta nde siloŋo ŋgua ŋinde, ku wisinzi motutu kala sikasoŋa tu, “Ayo, ambo mine, ande ea ikura tu ikai via mao ŋana imo mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aku Yesu mata ilea ilâ panzi ku ipainzi tu, “Kinzi tamâta warakanzi nâ ma sikura tia; aŋga Maro Kindeni tamwata nde ikura tu iveta vetâŋa rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yesu iporo ŋgua ŋine lâ, ŋineŋga Petero itu lâ kawa mine tu, “Opopo! Maka muŋga kapile kelekele ndoni ŋana kapono muli pa noko! Mine nde maka ma kakai kulu ndia.” ");
INSERT INTO xsi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aku Yesu ipainzi tu, “Naŋa aporo mao nâ pami; muli, lâ zo ŋinde Maro Kindeni ma ipulia samba wa tâno ipâŋga wasaseki ndo, ande naŋa Tamâta Natu ma amo Koipu Ŋalae tava naneŋgu walo wa sinâla ŋalae. Aku lâ zo ŋinde miki pâri-tamâta saŋao kanaŋomi rua nde ma kakai poe panzi Isrel ŋgu kambwaŋenzi saŋao kanaŋonzi rua, aku ma kamo katonâŋa panzi. ");
INSERT INTO xsi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aku tamâta ea kalo tawana naŋa kala ipile ne luma wa tai-tua wa mwane wa tina-tama wa natu wa ne tâno wa; ande Maro Kindeni ma itu pa kinzi ŋinde rârâni ŋana ŋinde kâ mbwani tamâta ŋalae taitu (100). Aku muli, i ma via mao ilanzi, ma simo vianzi mine ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Andeta kinzi tamâta rârâ muŋga simo tamâta ŋalaŋala lâ tâno kulu, ande kinzi ŋinde ma muli simo tamâta kaa nâ. Aŋga kinzi tamâta rârâ muŋga simo tamâta kaa nâ lâ tâno kulu, ande kinzi ŋinde ma muli simo tamâta ŋalaŋala.” ");
INSERT INTO xsi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu iporo ŋgua ŋine lâ, ŋineŋga itambira ŋgua mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ nde itogo tâno toŋge warika. Zo toŋge, mbwale pwataki lâ, ŋineŋga tâno warika ŋinde ilâ lawea ilo iroto ŋananzi wurâta tamâta pinde tu ma sikai wurâta lâ i ne tâno waini ilo. ");
INSERT INTO xsi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Isânda wurâta tamâta pinde kulunzi lâ, aku ipa ŋgua kunzi ŋana sikai mbumbu saŋao saŋao ŋana nenzi wurâta lâ kari ŋinde. Sisâu lâ, ŋineŋga tamâta ŋalae ŋinde ionzi silâ siveta wurâta lâ ne tâno waini ilo. ");
INSERT INTO xsi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ayo, kari tai ŋato ilâ lâ, ŋineŋga tamâta ŋalae ŋinde ilâ ku mata imoranzi tamâta pinde simandi nenzi lâ ao ŋgini, nenzi wurâta toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aku ipainzi tu, ‘Wa! Miki kalâ kaveta wurâta lâ naneŋgu tâno waini ilo, aku ma kulu alami ikura naneŋgu pateâŋa mine.’ ");
INSERT INTO xsi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aku silâ. Simo lee, ku kari imâ ŋgini, ŋineŋga tamâta ŋalae ilâ lawea ilo kilo ku iveta mâsi ndaina nâ kilo. Lee, ku kari tai ŋato kilo ilâ lâ, ŋineŋga iveta mâsini ndaina kilo. ");
INSERT INTO xsi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lee ku lala, kari indue lâ, ŋineŋga tamâta ŋinde ilâ ku mata imoranzi tamâta pinde simandi nenzi nâ simo lawea ilo. Aku ikasoŋanzi tu, “Wa, mana mana ŋga miki kamandi nemi koa tia nâ lee, kari ŋga indue lâ, a?” ");
INSERT INTO xsi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kinzi nde siporo taulo tu, “Ŋandai tamâta toŋge wurâta ilua maka ŋga.” Ŋineŋga tamâta ŋalae ipainzi tu, “Ara, miki kalâ kaveta wurâta lâ naneŋgu tâno waini ilo.” Aku silâ. ");
INSERT INTO xsi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Aku lala pararai lâ, ŋineŋga tâno warika iporo pa wurâta tamâta nenzi katonâŋa tu, “Kusarâwa panzi wurâta tamâta tu simâ ŋana sikai nenzi kulu kâ. Kuwae mbumbu muŋga panzi wurâta tamâta ŋinde sipâŋga muli ndo. Kuveta mine nâ kuwae panzi kulâ lee ku marumbu lâ wurâta tamâta sipâŋga muŋgâŋa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ŋineŋga kinzi tamâta kala siveta wurâta ikura kari tai taitu nâ ŋinde nde simuŋga simâ, aku sikai mbumbu saŋao saŋao. ");
INSERT INTO xsi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mine kala kinzi tamâta ŋinde siveta wurâta ikura mboyo wa lala wa ande ilonzi tu ma sikai mbumbu ŋalae. Andeta tia; kinzi kala sikai mbumbu saŋao saŋao mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kinzi simora nenzi mbumbu ŋinde, aku wisinzi nâna papa tâno warika. ");
INSERT INTO xsi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Aku sipai tâno warika tu, “Wa! Kinzi tamâta ŋinde sipâŋga muli ndo! Kinzi siveta wurâta ikura kari tai taitu mai nâ! Aŋga maka nde kaveta wurâta ŋalae lâ mboyo lee imâ ipâŋga lâ ŋine, aku kari kanama pâta lâ! Andeta kinzi ŋinde nenzi mbumbu nde rege-rege kuku maka nema mbumbu ma!” ");
INSERT INTO xsi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tâno warika nde iloŋo nenzi ŋgua ŋinde, ŋineŋga iporo pa nenzi tamâta toŋge mine tu, “Niŋgu-nambwe, naŋa ŋandai aveta soki toŋge pa noko ŋga, ŋana tu muŋga mboyo noko tamwata kupa ŋgua tu ma pwai mbumbu saŋao ŋana noko ne wurâta. ");
INSERT INTO xsi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ara, pwai ne mbumbu, aku kulâ. Naŋa iloŋgu tu mbumbu saŋao alua tamâta kala imâ muli ndo ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ŋine nde keno pa naŋa simboŋgu nâ. Naŋa akura tu awae naneŋgu mbaliŋa ikura naŋa warakâŋgu nâ neŋgu pateâŋa mine. Kala ŋine naŋa atu aveta keŋgu ara panzi tamâta ŋinde; mine nde ŋana sâ kâ ŋga noko kupadâda, a?” ");
INSERT INTO xsi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu iporo ŋgua tambirâŋa ŋine marumbu lâ, ŋineŋga iporo tu, “Aku mine nâ, kinzi tamâta muŋga simo tamâta kaa nâ lâ tâno kulu, ande muli ma simo tamâta ŋalaŋala. Aŋga kinzi tamâta muŋga simo tamâta ŋalaŋala lâ tâno kulu, ande muli ma simo tamâta kaa nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu nde ikainzi ne pâri-tamâta saŋao kanaŋonzi rua, aku sikâki silâ pa Jerusalem lawea kâ. Soka nzâla yo, ŋineŋga Yesu iporo ŋgua ilâ pa kinzi nâ mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ayo, ŋine kinda takâki talâ pa Jerusalem. Ma tapâŋga lâ, ŋineŋga tamâta toŋge ma io naŋa Tamâta Natu lâ kinzi patarawâŋa tamâta ŋalaŋala wa pananâŋa tamâta ŋana ŋgua tukuŋa kâ mbaunzi ilo. Kinzi ma sio naŋa lâ ŋgua nia, aku ma sipa ŋgua tu sipu naŋa pâta amâte. ");
INSERT INTO xsi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ŋineŋga kinzi kala ma sio naŋa alâ tinikoa mbaunzi ilo, aku kinzi ŋinde ma siporo ŋgua pavaligiŋa pa naŋa wa sipalili naŋa wa. Marumbu, ŋineŋga ma sipu naŋa lâ kâi popole tini amâte. Andeta kari ŋato lâ, ŋineŋga Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo.” ");
INSERT INTO xsi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yesu iporo mine lâ, ŋineŋga Sebedi kaiwa taine ikainzi natunzi rua simâ pa Yesu. Taine ŋinde nde ipare tuku pa Yesu ku ino Yesu tu ma iveta vetâŋa toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aku Yesu ikasoŋa tu, “Noko ilo tu naŋa ma aveta mana.” Aku taine ŋinde nde ipai Yesu tu, “Naŋa iloŋgu mine: lâ zo ŋana noko ma pwai Koipu Ŋalae, ande noko ma kupatea natuŋgu toŋge ŋana isaŋona noko tini laiti pa wia kâ, aŋga toŋge ŋana isaŋona noko tini laiti pa ŋâsi kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ŋineŋga Yesu isia ŋgua panzi pâri-tamâta rua ŋinde mine tu, “Miki rua kazizâla ŋana vetâŋa ŋine kala kakasoŋa naŋa ŋana. Naŋa ma muli anu lââ makisa ikeno kâmba toŋge ilo. Tiambo miki rua kala kakura tu kanu lââ ŋinde, tiya?” Aku kinzi rua sipai tu, “Maka rua kurama.” ");
INSERT INTO xsi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ŋineŋga Yesu ipainzi tu, “Mao nâ, miki rua ma kanu lââ makisa kala naŋa ma anu ŋinde. Ambo taitu pateâŋa ŋana tamâta ea ma isaŋona tiniŋgu laiti pa wia kâ ŋga pa ŋâsi kâ, ande ŋinde ikeno pa naŋa tia. Naŋa mama i simbo nâ ma iwae saŋonâŋa nia panzi tamâta ea muŋga ipateanzi ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kinzi nawalanzi pâri-tamâta saŋao nde siloŋo kinzi tai-tua rua parinanzi mine, aku wisinzi nâna panzi. ");
INSERT INTO xsi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Andeta Yesu isarawanzi tu simâ kuku, aku ipainzi tu, “Miki kasama tu kinzi tamâta pinde uru sikai koipu panzi tinikoa ŋgu, aku kinzi tamâta ŋalaŋala ŋinde uru siveta malia kie-kie panzi ŋgu ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Andeta mâsi mine ma ikeno miki ŋginimi ndimo. Ambo tamâta itu imo tamâta ŋalae lâ ŋginimi, ande nzâla keno mine: i ma imo nemi kuleŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aku tamâta ea itu imo mbâna-mbâna pami, ande nzâla keno mine: i ma imo nemi wurâta tamâta kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ŋana tu naŋa Tamâta Natu ŋandai amâ ŋana kinzi tamâta ma sikai kuleŋa pa naŋa ŋga. Naŋa amâ ŋana akai kuleŋa panzi tamâta, aku ma amâte ŋana akainzi tamâta rârâ piti lâ kondoma ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ikainzi ne pâri-tamâta ku soka ŋana sipile Jeriko lawea silâ kâ, ande tamâta ŋgu ŋalae nde soka mulinzi silâ. ");
INSERT INTO xsi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aŋga tamâta rua nde sisaŋona nzâla ŋgaŋe, kinzi rua matanzi leva-leva lâ. Kinzi rua siloŋo ŋgua tu Yesu ŋga iyoka imâ, ŋineŋga sisarâwa kaika tu, “Maro Ŋalae, Daviti ne vâsani noko, kalo sukâŋa ŋanama!” ");
INSERT INTO xsi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kinzi tamâta nde siloŋonzi rua sisarâwa mine ku simbitanzi tu kawanzi buu nâ. Andeta kinzi rua sisarâwa kawanzi kâki ŋalae mine tu, “Maro Ŋalae, Daviti ne vâsani noko, kalo sukâŋa ŋanama!” ");
INSERT INTO xsi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ŋineŋga Yesu imandi ku ikasoŋanzi tu, “Aŋga miki rua katu naŋa ma aveta mana pami.” ");
INSERT INTO xsi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ande kinzi rua situ lâ kawa mine tu, “Maro Ŋalae, maka iloma tu ma matama kamora nia.” ");
INSERT INTO xsi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aku Yesu kalo sukâŋa ŋananzi, kala io mbau lâ kinzi rua matanzi. Aku walele nâ kinzi rua matanzi ara, aku simora nia. Ŋineŋga simandi ku soka Yesu muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ikainzi ne pâri-tamâta ku soka lee sipâŋga Jerusalem lawea tini laiti, aku sipâŋga lawea toŋge ikeno Oliv Tuu waŋgira, i ŋa mine Betfasi lawea. Ande Yesu isupwanzi ne pâri-tamâta rua, ");
INSERT INTO xsi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aku ipainzi tu, “Miki rua kalâ pa lawea ndai, ikeno naomi ŋinde. Kalâ lawea ŋinde ilo, aku walele nâ ma kamora ‘donki’ malakupi toŋge kinzi sisine lâ imandi tava natu. Kayaute wâlo piti aku kakainzi rua kamâ pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ambo tamâta toŋge ikasoŋami tu, ‘Ŋana sâ kâ ŋga miki rua kaveta mine’, ande miki rua ma kapai tu, ‘Maro Ŋalae ne wurâta ikeno panzi rua. Aku mwaŋga ma ionzi rua sitaulo simâ kilo walele nâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Vetâŋa ŋinde iveta ŋgua toŋge Maro Kindeni muŋga io lâ ŋgua-tulâŋa tamâta toŋge kawa tu ipâŋga kanaŋo. Ŋgua ŋinde nde mine, ");
INSERT INTO xsi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kupainzi tamâta simo Saion tuu kulu tu, ‘Kamora ŋga! Miki nemi koipu ŋalae kala imâ pami. Ipatawa tamwata tini ku isaŋona donki toŋge kumbu. Mao nâ, isaŋona donki natu toŋge kumbu kala imâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ŋineŋga pâri-tamâta rua ŋinde silâ lawea ŋinde ilo, aku siveta ikura Yesu muŋga iporo panzi mine. ");
INSERT INTO xsi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kinzi rua sikai donki tina ŋga natu tona simâ, ŋineŋga siliŋi nenzi pasawaŋa luandondo kâki donki rua kumbunzi. Aku Yesu ikâki isaŋona. ");
INSERT INTO xsi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ŋineŋga tamâta ŋgu ŋalae sisawa nenzi pasawaŋa luandondo piti, ku silalaga lâ nzâla ŋana Yesu ma iyoka kulu kâ. Aŋga pinde nde sitoto tumba lau ku sikai simâ silalaga lâ nzâla tava. ");
INSERT INTO xsi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kinzi tamâta pinde soka simuŋga pa Yesu, aŋga pinde nde soka muli, aku rârâni sindeka ku sisuŋa kawanzi mine tu, “Paneâŋa ilâ pa Daviti ne vâsa! Maro Kindeni itu nzâmbe pa koipu ŋalae ŋine ikai i ndamwa kala imâ. Tapanea Maro Kindeni pa âta!” ");
INSERT INTO xsi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu iyoka mine lee ilâ Jerusalem lawea ilo, ande tamâta rârâni simo lawea ŋalae ŋinde nde sipakasoŋa warakanzi mine tu, “Tamâta ŋine nde ea.” ");
INSERT INTO xsi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aku kinzi tamâta soka simâ kuku Yesu ŋinde nde sipainzi tu, “Ŋine nde Yesu, ina ŋgua-tulâŋa tamâta ŋinde kinzi muŋga siporo tu ma iyoka pa Nasarete lawea lâ Galilaya tâno imâ.” ");
INSERT INTO xsi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ŋineŋga Yesu ilâ Maro Kindeni ne luma sapâŋa ne ŋgumbi ilo, aku iŋaranzi mbaliŋa warakanzi simo sipako kelekele lâ nia ŋinde. Itili peke lâ kinzi tamâta ŋana sipalulua mbumbu kâ, aku itili paŋgi lâ kinzi tamâta siveta wurâta ŋana sipako sii ŋana patarawâŋa kâ tava. ");
INSERT INTO xsi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aku ipainzi tu, “Maro Kindeni kawa ŋgua ikeno mine tu, ‘Naneŋgu luma nde ma kinzi sipatu ŋa tu “Luma ŋana noŋa kâ” ’; aŋga miki nde kaveta ŋine ipâŋga itogo kinzi nzanzare tamâta nenzi munâŋa nia mine!” ");
INSERT INTO xsi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu imo niani ndaina, ŋineŋga kinzi tamâta matanzi leva-leva wa kenzi pââsââ nde simâ papa, aku ivetanzi tininzi ara. ");
INSERT INTO xsi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Andeta kinzi patarawâŋa tamâta ŋalaŋala wa kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ nde simora mâsi ŋalaŋala pinde Yesu iveta ŋinde. Aku siloŋonzi lâlu kiri-kiri sisarâwa lâ luma sapâŋa ne ŋgumbi ilo mine tu, “Paneâŋa ilâ pa Daviti ne vâsa!” Mine nde kinzi tamâta ŋalaŋala ŋinde wisinzi nâna pa Yesu, ");
INSERT INTO xsi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","kala sikasoŋa i mine tu, “Wa, noko kuloŋo ŋgua ŋine kinzi lâlu siporo, tiya?” Aku Yesu itu lâ kawanzi mine tu, “Naŋa aloŋo lâ. Andeta mana mana ŋga miki ŋandai kapono ŋgua-tulâŋa tamâta ŋinde ne ŋgua ikeno lâ pepa tini, a? Ŋgua ikeno mine tu, ‘Aku kinzi lâlu kiri-kiri kala uru sipanea noko ŋa mine nâ’.” ");
INSERT INTO xsi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipilenzi simo, aku iyâti ilâ pa nia yo. Ŋineŋga ilâ imo Betani lawea lâ mbo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aku mbwale kilo, mboyo nâ, ŋineŋga Yesu iyoka itaulo ilâ pa Jerusalem lawea kilo, andeta putole ipu. ");
INSERT INTO xsi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yesu mata ilâ imora kâi “fik” toŋge imandi nzâla ŋgaŋe, aku iyoka ilâ laiti. Andeta imora tu kanaŋo toŋge keno nde tia; lau nâ keno. Aku Yesu iporo papa kâi ŋinde mine tu, “Noko ma kupula kanaŋo kilo tia ndo!” Aku ndainani nâ, kâi ŋinde ŋgâla-ŋgâla lâ. ");
INSERT INTO xsi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kinzi pâri-tamâta simora ŋinde, aku wisinzi motutu lâ. Aku siporo tu, “Mana mana ŋga kâi ŋine ŋgâla-ŋgâla walele nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Andeta Yesu ipainzi tu, “Naŋa aporo mao nâ pami; ambo miki ma kao nemi kalo-tawana ilâ mao pa Maro Kindeni, aku ilomi rua-rua tia, ande miki ma kakura tu kaveta mâsi mineni, itogo kala ŋine aveta pa kâi ‘fik’ mine. Andeta ŋinde nâ tia; ambo miki ma kaporo pa tuu ŋai mine tu, ‘Noko kumandi kupatiki kundue tâi ilo’, ande Maro Kindeni ma iveta vetâŋa ŋinde ipâŋga, itogo miki kaporo mine. ");
INSERT INTO xsi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ambo miki kalomi tawana Maro Kindeni kala kakai noŋa papa, ande i ma iveta ikura nemi noŋa mine.” ");
INSERT INTO xsi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ŋine ilâ lâ, ŋineŋga Yesu ilâ Maro Kindeni ne luma sapâŋa ne ŋgumbi ilo, aku ipanananzi tamâta simo ŋinde. Andeta kinzi patarawâŋa tamâta ŋalaŋala sitavanzi Isrel ŋgu nenzi katonâŋa nde simâ papa, aku sikasoŋa tu, “Wa, noko pwai ea ndamwa kumâ kala kuveta mâsi kie-kie ŋine, a? Aŋga ea wurâta ŋine ilano, a?” ");
INSERT INTO xsi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ande Yesu itu lâ kawanzi ku iporo tu, “Ara, naŋa kala atu akasoŋami kasoŋâŋa toŋge. Ambo miki ma kaporo ŋgua sondo itaulo imâ pa naŋa, ande naŋa kala ma aporo ŋgua pwataki pami ŋana akai ea ndamwa ŋga aveta vetâŋa ŋine. ");
INSERT INTO xsi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Naneŋgu kasoŋâŋa nde mine; muŋga, lâ zo ŋinde Yoane Lââ-Liliŋa Tamwata iveta wurâta ŋana ililinzi tamâta, ande ea wurâta ŋinde ilua i. Miki ilomi tu Maro Kindeni wurâta ŋinde ilua, tiya?, i tamwata nâ ilo patea tu iveta.” Ŋineŋga kinzi warakanzi siporo lâ ŋgininzi mine tu, “Ambo kinda ma taporo taulo tu, ‘Maro Kindeni isupwa Yoane tu iveta wurâta ŋinde’, ande i ma iporo pa kinda mine tu, ‘Mine kala ŋana sâ kâ ŋga miki ŋandai kalomi tawana Yoane ne ŋgua, a?’ ");
INSERT INTO xsi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ambo kinda ma taporo taulo mine tu, ‘Yoane tamwata nâ ilo patea tu iveta wurâta ŋinde’, ande kinzi tamâta ma wisinzi nâna ŋalae tina pa kinda. Kinda taruru ŋananzi, ŋana tu kinzi rârâni kalonzi tawana tu Yoane nde Maro Kindeni ne ŋgua-tulâŋa tamâta toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tia ku kinzi siporo ŋgua taulo pa Yesu mine tu, “Maka kasama tia.” Ŋineŋga Yesu ipainzi tu, “Ara, naŋa kala ma aporo ŋgua toŋge pami tia ŋana akai ea ndamwa amâ kala aveta vetâŋa ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ŋineŋga Yesu itambira ŋgua panzi tamâta ŋalaŋala mine tu, “Ayo, miki ilomi mana. Tamâta toŋge imo kunzi natu tamâne rua. Tamâta ŋinde ilâ pa natu nzâla-kulu kâ, aku ipai tu, ‘Natuŋgu, ma ŋine noko kulâ kuveta wurâta pa naŋa lâ tâno waini ilo.’ ");
INSERT INTO xsi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aku natu ipai tu, ‘Naŋa tiniŋgu pwâka, ma alâ aveta wurâta pa noko nde tia.’ Andeta mwaŋga, natu ŋinde ipalele ilo, aku ilâ iveta wurâta. ");
INSERT INTO xsi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ŋineŋga tamanzi kala ilâ pa natu toŋge, aku iporo ŋgua mineni papa. Aku natu ŋinde iporo tu, ‘Ara, mama; naŋa ma alâ aveta wurâta pano.’ Andeta i ŋandai ilâ iveta ne wurâta ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mine nde ea lâ tamâta rua ŋinde ande iveta ikura tamanzi ne pateâŋa.” Aku kinzi tamâta ŋalaŋala sipai Yesu tu, “Natu nzâla-kulu iveta ikura tama ne pateâŋa mine”. Ŋineŋga Yesu ipainzi tu, “Naŋa aporo mao nâ pami; kinzi tamâta sakamao ŋana sikai mbumbu pa Rom kâ wa kinzi nzâla taine wa, ande kinzi ŋinde simuŋga pami ŋana sikai Maro Kindeni ne nzâmbe ara. ");
INSERT INTO xsi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ŋana tu Yoane Lââ-Liliŋa Tamwata muŋga imâ pa miki Isrel ŋgu ŋana itula mâsi sondo Maro Kindeni ilo tu miki ma kaveta ŋinde, andeta miki ŋandai kalomi tawana Yoane ne ŋgua ŋga. Aŋga kinzi tamâta sakamao ŋana sikai mbumbu pa Rom kâ wa kinzi nzâla taine wa, ande kinzi ŋinde siloŋo Yoane ne ŋgua, aku sio nenzi kalo-tawana ilâ pa Maro Kindeni, kala sipile nenzi vetâŋa sakamao. Aŋga miki kamora kinzi kiesaka tamwatanzi ŋinde nenzi kalo-tawana ŋinde, andeta miki kapalele ilomi kalomi ku kalomi tawana Yoane ne ŋgua, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ŋineŋga Yesu ipainzi tamâta ŋalaŋala mine tu, “Miki kaloŋo ŋgua tambirâŋa toŋge. Tamâta toŋge ipâu tâno waini toŋge aku ipa ŋgumbi ŋana. Aku iveta wewe lâ tâno ilo, itogo kondo ŋana sipale waini kapula tu punu-punu kâ, aku ipa pâla ŋana tamâta ma simo ilo sio ŋana tâno kâ. Ŋineŋga io tâno ŋinde lâ tamâta pinde mbaunzi ilo ŋana sikatona ku sikai wurâta ŋana mbumbu lâ tini. Ŋineŋga tâno warika iyoka ilâ pa nia malawae toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Imo lee, aku zo laiti ŋana kâi waini ma ipula kanaŋo kâ. Ŋineŋga tâno warika isupwanzi wurâta tamâta pinde silâ pa tâno waini ŋinde ŋana sikai waini kanaŋo pinde, ikura muŋga sipa ŋgua tu ma silua i. ");
INSERT INTO xsi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Andeta kinzi tamâta uru sikai wurâta lâ tâno ŋinde nde sikainzi tâno warika ne wurâta tamâta kaika, aku sipu toŋge. Aŋga toŋge nde sipu pâta imâte, aŋga mira nâ sisia toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ŋine ilâ lâ, ŋineŋga tâno warika isupwanzi wurâta tamâta pinde kilo silâ panzi. Kinzi kambwaŋenzi nde ipole tamâta muŋga isupwanzi ŋinde kambwaŋenzi. Andeta kinzi tamâta uru sikai wurâta lâ tâno ŋinde nde siveta mâsi mine nâ panzi wurâta tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Simo lee ku muli, ŋineŋga tâno warika isupwa i tamwata natu tamâne ilâ panzi. I itu mine, ‘Kinzi ma simege ŋana natuŋgu’. ");
INSERT INTO xsi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Andeta kinzi tamâta uru sikai wurâta lâ tâno ŋinde nde simora tâno warika natu imâ panzi, aku siporo lâ warakanzi ŋgininzi mine tu, ‘Wa, tamâta ndai ma muli ikai tama ne mbaliŋa ndoni. Ayo, ŋine ma tapu pâta imâte, aku ma warakânda takai i ne tâno ŋine.’ ");
INSERT INTO xsi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Siporo ŋgua ŋine lâ, aku marumbu; mbaunzi ilâ sikai tâno warika natu kaika ku siŋara lâ tâno ilo iyâti ilâ pa nia yo, ŋineŋga sipu pâta imâte lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu itambira ŋgua ŋine panzi lâ, ŋineŋga ikasoŋanzi tu, “Ayo, mwaŋga tâno waini warika ma imâ, ŋineŋga ma iveta kie mana panzi tamâta ŋinde muŋga sikai wurâta lâ tâno ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aku kinzi tamâta ŋalaŋala siporo taulo tu, “I ma iyaulanzi tamâta sakamao ŋinde, ku ma izavarunzi sakamao ndo. Aŋga ne tâno waini ŋinde ma ilanzi tamâta pinde ŋana sikatona kâ. Aku lâ zo ŋana sikai kanaŋo kâ, ande ma sigona kanaŋo pinde silua i.” ");
INSERT INTO xsi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ŋineŋga Yesu ipainzi tu, “Tiambo miki ŋandai kapono Maro Kindeni ne ŋgua ikeno lâ pepa tini mine tu, ‘Mira ŋine kinzi tamâta ŋana sipa luma kâ situ nde sakamao kala sitambira lâ, ande mirani ndaina ipâŋga mira ara ŋana isuka luma ŋgaŋe kaika kâ. Maro Kindeni tamwata iveta vetâŋa ŋinde ipâŋga lâ, kala kinda tamora ŋinde tu ara pâta kanaŋo.’ ");
INSERT INTO xsi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mine kala naŋa apaimi tu Maro Kindeni ma ipono nzâla ŋana miki Isrel tamâta ŋana kamo i ne ŋgumbi ilo, aku ma ikai maro pa tamâta ŋgu pinde, kinzi ŋinde uru siveta mâsi ara ikura Maro Kindeni ne pateâŋa mine.  ");
INSERT INTO xsi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ambo tamâta toŋge pata ndue ku mira ŋine ipu, ande mira ŋine ma ipu tamâta ŋinde karae pwapwataki. Ambo mira ŋine imbe ndue ipu tamâta toŋge kulu, ande mira ŋine ma izavaru i ndo lâ imâte.” ");
INSERT INTO xsi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kinzi patarawâŋa tamâta ŋalaŋala aŋga kinzi tamâta lâ Parisai ŋgu nde siloŋo Yesu itambira ŋgua mine panzi, aku ilonzi patea tu ŋgua ŋine nde iyoke kinzi warakanzi. ");
INSERT INTO xsi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mine kala ilonzi tu ma sikale Yesu kaika sio lâ luma sakamao ilo. Andeta siruru ŋananzi ŋgu, ŋana tu kinzi tamâta ilonzi tu Yesu nde Maro Kindeni ne ŋgua-tulâŋa tamâta toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ŋineŋga Yesu iporo ŋgua tambirâŋa kilo ilâ panzi Isrel nenzi tamâta ŋalaŋala mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, nde itogo koipu ŋalae toŋge iveta waiŋa ŋalae papa natu tamâne ŋana ne pakâeŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Koipu ŋinde isupwanzi ne wurâta tamâta silâ panzi tamâta pinde i ilo tu ma simâ sika kâpwa lâ waiŋa pakâeŋa ŋinde. Silâ panzi, ku siveta ŋana sigonanzi tamâta ŋinde simâ. Andeta tininzi pwâka tu simâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ŋineŋga isupwanzi ne wurâta tamâta pinde kilo, aku ipainzi tu, ‘Miki kalâ panzi tamâta ŋinde naŋa muŋga asarâwa panzi, aku kapainzi tu, “Kaloŋo ŋga! Koipu ŋalae iveta ne kâŋa-nuŋa marumbu lâ. I ne bulmakao tamâne pinde aŋga simbi pinde arara situmbu kambwaŋenzi ŋalaŋala, ande maka ŋga kapunzi lâ. Aku kelekele rârâni vetâŋa lâ kala ikeno. Mine nde miki kamâ kaka kâpwa lâ waiŋa ŋana pakâeŋa kâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kinzi wurâta tamâta nde silâ siporo ŋgua mine panzi tamâta ŋinde, andeta kinzi taŋanzi kaika ku sikâwa pwapwataki silâ. Toŋge nde ilâ ne tâno ilo, aŋga toŋge nde ilâ iveta ne wurâta ŋana mbaliŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aŋga kinzi pinde nde sikalenzi wurâta tamâta ŋinde kaika ku sikai kazâŋa panzi sipunzi pâta simâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Siveta mine lâ, ande kala koipu ŋalae nde wisi nâna ndo. Aku ionzi ne zugu tamâta silâ sizavarunzi tamâta ŋinde muŋga sipunzi ne wurâta tamâta pâta simâte. Aku sirumbia nenzi lawea kana lâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ŋineŋga koipu ŋalae isarawanzi ne wurâta tamâta simâ papa, aku ipainzi tu, ‘Waiŋa pakâeŋa ne kâŋa-nuŋa nde vetâŋa lâ kala keno, andeta kinzi tamâta ŋinde naŋa muŋga asarawanzi tu simâ, ande kinzi ŋinde nde tamâta ara ikura ŋana simâ kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mine nde miki kalâ kakura nzâla nzâla, aku kanonzi tamâta rârâni simo ŋinde tu ma simâ ŋana waiŋa pakâeŋa ne kâŋa-nuŋa kâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iporo mine lâ, ŋineŋga kinzi wurâta tamâta nde silâ sikura nzâla nzâla sigonanzi tamâta rârâni simo ŋinde, kinzi tamâta saka wa ara wa. Aku kinzi ŋinde rârâni simâ luma ilo pipi lâ ŋana sika kâŋa-nuŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kinzi tamâta simâ sisaŋona lâ, ŋineŋga koipu ŋalae nde imâ luma ilo tu imoranzi. Andeta mata ilâ imora tamâta toŋge ŋandai ipasawa pasawaŋa ara ŋana waiŋa pakâeŋa ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tia ku koipu nde ilâ papa ku ikasoŋa tu, ‘Niŋgu-nambwe, ŋana sâ kâ ŋga noko kumâ naneŋgu luma ilo, andeta noko ŋandai kupasawa pasawaŋa ara ŋana waiŋa pakâeŋa kâ, a?’ Andeta tamâta ŋinde nde kawa buu nâ, iporo ŋgua toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ŋineŋga koipu ipainzi ne wurâta tamâta mine tu, ‘Kakai wâlo ku kapa tamâta ŋine kie-mbalau kaika lâ, ŋineŋga katambira yâti lâ nia ŋgaŋe, ŋana imo kondoma ilo.’” Yesu iporo ŋgua tambirâŋa ŋine lâ, ŋineŋga ipainzi Juda tamâta ŋalaŋala tu, “Lâ nia kondoma ŋinde kinzi ma sita ŋalae wa niŋonzi giri-giri ŋana sikai nâna kâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Miki kaloŋo ŋga; Maro Kindeni ne sarawâŋa ilâ panzi tamâta rârâ, andeta ipateanzi kinzi pinde nâ, kinzi ŋinde kalonzi tawana i mao.” ");
INSERT INTO xsi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ŋine ilâ lâ, ŋineŋga tamâta pinde lâ Parisai ŋgu nde sipasau ku sipa ŋgua ŋana ma sikai samâŋa pa Yesu kâ. Kinzi ilonzi patea tu ambo Yesu ma iporo ŋgua pinde ŋgâsi tâ, ande ma sio ilâ pa ŋgua nia. ");
INSERT INTO xsi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kinzi Parisai tamâta ŋinde nde sionzi nenzi pâri-tamâta pinde sitavanzi Herot ne tamâta pinde, aku simâ kuku Yesu. Simâ kuku, ŋineŋga siporo ŋgua mâru-mâru papa mine tu, “Pananâŋa, maka kasama tu noko nde tamâta ŋana kuporo ŋgua mao kâ. Noko ŋgua mao nâ uru kupanananzi tamâta ŋana Maro Kindeni ne vetâŋa kâ. Noko uru kuporo ŋgua kaŋa taituni nâ panzi tamâta ŋalaŋala wa kinzi sugorai tamwatanzi wa. ");
INSERT INTO xsi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mine nde maka iloma tu noko ma kuporo ŋgua taulo pama. Noko ilo mana; nenda koipu ŋalae Kaisara uru iporo kaika tu kinda ma mbumbu talua. Aŋga Mose ne ŋgua tukuŋa isâu tu kinda ma mbumbu ŋinde talua Kaisara, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Andeta Yesu isama kinzi ilonzi kalonzi pwataki tu sakamao ndo. Mine kala ipainzi tu, “Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti. Ŋana sâ kâ ŋga miki kakai samâŋa pa naŋa, a? ");
INSERT INTO xsi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kakai mbumbu toŋge uru kao ilâ pa koipu, aku kamâ katula pa naŋa.” Kinzi nde sikai mbumbu toŋge simâ pa Yesu, ");
INSERT INTO xsi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ŋineŋga ikasoŋanzi tu, “Tai wa ŋoa ŋine kala ikeno mbumbu tini, ande ea ne.” ");
INSERT INTO xsi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ande siporo taulo tu, “Kaisara ne.” Ŋineŋga Yesu ipainzi tu, “Mine kala Kaisara ne kelekele, ande miki kalua Kaisara; aŋga Maro Kindeni ne kelekele, ande kalua Maro Kindeni.” ");
INSERT INTO xsi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kinzi siloŋo Yesu ne ŋgua ŋine, aku wisinzi motutu. Mine kala sipile Yesu ku silâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lâ zo ndainani nâ kinzi tamâta pinde lâ Sadyusi ŋgu nde simâ pa Yesu. Kinzi ŋgu ŋinde uru kalonzi tawana tu kinzi mateŋa tamâta ma muli simandi simo vianzi kilo tia. Kinzi sipai tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Pananâŋa, Mose muŋga iŋgere ŋgua tukuŋa toŋge imâ pa kinda mine tu, ‘Ambo tamâta toŋge i natu tia ku imâte, ambo i kaiwa taine imo ŋai yo, ande tamâta ŋinde tai ma ikai tua kaiwa, aku kinzi rua ma sipulia lâlu itogo tua kilala mine.’” ");
INSERT INTO xsi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Siporo ŋgua ŋine lâ, ŋineŋga sisia ŋgua pa Yesu tu, “Ayo, tamâne nzâla-kulu toŋge i tai lima kanaŋo taitu simo. Nzâla-kulu ŋinde ikai kaiwa taine toŋge, andeta mwaŋga tamâne imâte lâ, aku i natu tia. Mine kala i tai iyoka tua muli ku ikai taine ŋinde itogo i kaiwa mine. ");
INSERT INTO xsi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Andeta i kala natu tia aku imâte lâ. Ŋineŋga kinzi rua tainzi kala iveta mine nâ, ikai taine ŋinde ŋineŋga imâte, aku natu tia. Siveta mine lee, aku kinzi tai rârâni sikai taine taituni ŋinde, aku kinzi kala natunzi tia, ku simâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kinzi rârâni simâte marumbu lâ, aku muli ŋga taine kala imâte. ");
INSERT INTO xsi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ayo, lâ zo muli, ambo kinzi mateŋa tamâta ma simandi simo vianzi kilo, ande taine ŋinde ma imo itogo ea kaiwa lâ kinzi tai-tua lima kanaŋonzi rua ŋinde. Noko kusama tu kinzi rârâni muŋga sikai kaiwanzi taine taitu ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Andeta Yesu itu lâ kawanzi tu, “Opopo, miki kasama Maro Kindeni ne ŋgua ikeno lâ pepa tini, ande tia. Aku miki kazizâla ŋana i ne walo kaika mine nâ. Mine kala miki kaveta ŋgua palaŋeŋa rârâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lâ zo ŋana kinzi mateŋa tamâta ma simandi simo vianzi kilo, ande kinzi tamâta ma simo sitogonzi aŋelo lâ samba ilo mine, kala ma sipakâe tia. ");
INSERT INTO xsi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Andeta naŋa atu aporo ŋgua toŋge pami ŋana kinzi mateŋa tamâta nenzi mandiŋa kâ. Tiambo miki ŋandai kapono ŋgua ŋinde Maro Kindeni muŋga itula pami ikeno lâ pepa tini, a? Iporo ŋgua ŋananzi timbumi, kinzi ŋinde simâte muŋgani lâ, aku iporo tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Naŋa Maro Kindeni nde Abraham ŋga Isaka aŋga Yakopu nenzi Maro Ŋalae.’ Ayo, miki kaloŋo ŋga; Maro Kindeni i ŋandai kinzi mateŋa tamâta nenzi Maro Ŋalae ŋga. I nde tamâta simo vianzi ŋinde nâ nenzi Maro Ŋalae.” ");
INSERT INTO xsi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kinzi tamâta siloŋo Yesu ne ŋgua ŋine, aku wisinzi motu ŋana i ne mâsi ŋana ipanananzi kâ. ");
INSERT INTO xsi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lâ zo ŋinde kinzi tamâta pinde lâ Parisai ŋgu siloŋo pâri tu Yesu iporo ŋgua kanaŋo nâ, aku isae ŋgua ne nzâla ŋananzi Sadyusi ŋgu. Mine kala silâ taitu, ku simâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aku nenzi tamâta toŋge nde imâ kunzi tona, i muŋga ikai ilo-kalo ŋalae ŋana ŋgua tukuŋa kâ. I ilo tu ikai samâŋa pa Yesu kâ, kala ikasoŋa tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Pananâŋa, ŋgua tukuŋa ndia nde ipolenzi ŋgua tukuŋa rârâni Mose muŋga itula pa kinda.” ");
INSERT INTO xsi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu nde iporo taulo tu, “‘Noko ma tini mwasa ndo papa noko ne Maro Ŋalae Kindeni, aku kuo noko ilo ndoni wa koroani ndoni wa ilo-kalo ndoni ilâ pa i simbo nâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ŋgua tukuŋa ŋine imuŋga ku ipolenzi ŋgua tukuŋa rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aŋga ŋgua tukuŋa iyoka ŋinde muli nde kaŋa taituni nâ; ‘Noko ma tini mwasa panzi tini pinde, itogo noko tini mwasa pa tamwata mine.’ ");
INSERT INTO xsi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tukuŋa rua ŋine nde sitogo ŋgunu-ŋgunu tina pa Mose ne tukuŋa rârâni wa kinzi ŋgua-tulâŋa tamâta nenzi tukuŋa rârâni wa.” ");
INSERT INTO xsi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kinzi Parisai tamâta nde sipasau simo kuku Yesu yo, aku Yesu ikasoŋanzi tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ayo, miki ilomi mana; tamâta ŋine Maro Kindeni ipatea tu ivilanzi ne ŋgu, sipatu i ŋa tu Kirisi, ande i nde ea ne vâsa.” Kinzi nde siporo taulo mine tu, “Kirisi nde timbunda Daviti ne vâsa.” ");
INSERT INTO xsi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aku Yesu itu lâ kawanzi tu, “Ara mbo, mine nde mana mana ŋga Koroani Sapâŋa itula ilo-kalo pa Daviti kala Daviti ipatu Kirisi ŋa tu, ‘Maro Ŋalae’, a? Ŋana tu Daviti ne ŋgua ikeno lâ pepa tini mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Maro Ŋalae Kindeni itu ŋgua pa naneŋgu Maro Ŋalae mine tu, “Noko kusaŋona ŋai pa mbauŋgu wia kâ lee, ikura lâ zo ŋinde naŋa ma aonzi noko ne kazâŋa tamâta simo noko kalo.’” ");
INSERT INTO xsi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Miki kamora ŋga. Daviti tamwata nde ipatu Kirisi ŋa tu ‘Maro Ŋalae’. Mine nde mana mana ŋga Kirisi nde Daviti ne vâsa nâ, a?” ");
INSERT INTO xsi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tamâta toŋge lâ ŋgu ŋinde ikura ŋana iporo ŋgua toŋge taulo pa Yesu kâ, ande tia. Aku lâ zoni ndaina, kinzi tamâta rârâni ilonzi patea tu ma sikai samâŋa mine papa Yesu kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aku muli, ŋineŋga Yesu itula ŋgua panzi tamâta sitavanzi ne pâri-tamâta. ");
INSERT INTO xsi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ipainzi mine tu, “Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ sitavanzi tamâta lâ Parisai ŋgu, kinzi ŋinde simbonzi nâ uru situla ŋgua tukuŋa ne duvi pwataki, itogo Mose muŋga iveta mine. ");
INSERT INTO xsi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mine nde ŋgua rârâni situla wa sipananami ŋinde, ande miki ma kaloŋo ku kapaveta kuku. Ambo taitu mâsi wa vetâŋa ndia kinzi uru siveta, ande ŋinde miki ma kapaveta kuku ndimo. Ŋana tu kinzi uru siporo ŋgua rârâ ŋinde, andeta kinzi warakanzi ŋandai sipaveta kuku ŋgua ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ŋinde itogo kinzi sinzuku bwali malia ndo, ku sio lâ tamâta kalanzi, kala kinzi tamâta simakâsa ŋalae tina ŋana sikale kâ. Aŋga kinzi warakanzi ŋandai sio mbalaunzi ilâ ŋana sivilanzi tamâta tu sikale malia ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vetâŋa rârâni kinzi uru siveta, ande siveta ŋana ma tamâta simoranzi kâ. Kinzi uru sipa kariga ŋalaŋala ŋana noŋa kâ lâ tininzi, ku sipa wareŋa luandondo lâ nenzi pasawaŋa ŋalaŋala ŋgaŋe tona, ŋana sipasuka warakanzi tininzi kâ. Ŋana nenzi mâsi ŋinde kâ, ande kinzi silâŋe tu ilonzi keno pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kinzi ilonzi tu ma sikai saŋonâŋa nia arara lâ tamâta naonzi lâ kâŋa-nuŋa ŋalaŋala nia, aku ilonzi tu sisaŋona mine nâ lâ luma ŋana pasauŋa kâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kinzi ilonzi ŋalae tina tu tamâta ma simege ŋananzi ku siporo ‘Kari ara’ panzi lâ ao ŋgini, aku ilonzi tu tamâta ma sisarawanzi tu, ‘O, Pananâŋa’. ");
INSERT INTO xsi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Andeta miki kaloŋo ŋga; ambo kinzi tamâta sipatu noko ŋa tu ‘Pananâŋa’, ande ŋinde nde ara tia ndo, ŋana tu tamâta taitu nâ nde miki nemi Pananâŋa, aku miki rârâni nde kamo togo nambwe-nambwe. ");
INSERT INTO xsi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mine nde lâ tâno ŋine kulu, miki ma kaporo pa tamâta toŋge tu, ‘Noko nde tamâta ŋalae kutogo tamama mine’, mine ndimo. Ŋana tu miki Tamami taitu nâ imo, ande kala imo samba ilo. ");
INSERT INTO xsi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aku mine nâ, ambo kinzi ma sipatu noko ŋa tu ‘koipu’, ande ŋinde nde ara tia ndo, ŋana tu miki nemi koipu taitu nâ imo, aku i nde Maro Kindeni ne Pateâŋa Tamâta Kirisi. ");
INSERT INTO xsi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tamâta ea imo mbâna-mbâna pami, ande ara ŋana i ma imo itogo nemi kuleŋa tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ŋana tu tamâta ea uru ipasuka tamwata ŋa kâki, ande Maro Kindeni ma itawa tamâta ŋinde ŋa indue lâ. Aŋga tamâta ea uru ipatawa tamwata ŋa, ande Maro Kindeni ma isuka tamâta ŋinde ŋa ipâŋga ŋalae.” ");
INSERT INTO xsi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yesu nde iporo kilo mine, “Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa. Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Mine nde miki uru kapono nzâla ŋananzi tamâta situ simo Maro Kindeni ne ŋgumbi ilo. Miki kapono warakami nemi nzâla ŋana Maro Kindeni ma ikai maro pami, aku kapono nzâla ŋananzi tamâta ŋinde tona. ");
INSERT INTO xsi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa. Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Miki uru kalâ kakura nia nia lâ tâi kulu wa tâno tâno wa, ŋana kasowe tamâta taitu nâ ilo-kalo ŋana kalo tawana nemi ŋgua. Aŋga lâ zo ŋana tamâta toŋge kalo tawanami, ande miki kaveta i ipâŋga tamâta ŋana ilâ pa yââ ŋalae ne mbââ ilo, itogo miki warakami mine. Miki kaveta tamâta ŋinde ipole miki ndo ŋana iveta kiesaka kâ. ");
INSERT INTO xsi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Oyae, mâsi sakamao ndo ma ipâŋga pami. Miki matami leva-leva, andeta katogo tu katula nzâla panzi tamâta. Miki uru kapanananzi tamâta mine: ‘Ambo tamâta itu iveta ŋgua pâŋa toŋge, aku isarâwa pa Maro Kindeni ne luma sapâŋa ŋana isuka ne ŋgua pâŋa ŋinde kâ, ande ŋgua pâŋa ŋinde nde mao tia. Mine kala ambo muli i ma imbware ŋgua pâŋa ŋinde, ande i ne soki tia. Taitu mambo isarâwa pa mira “gol” uru ikeno Maro Kindeni ne luma sapâŋa ilo, ande ŋgua pâŋa ŋine nde mao, kala i ma imbware ndimo.’ ");
INSERT INTO xsi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Opopo, miki nde kapa ndo, aku matami leva-leva nâ! Kelekele ndia ipâŋga ŋalae tina lâ Maro Kindeni nao, a? Maro Kindeni ne luma sapâŋa nde kelekele ara ndo, ipole mira “gol” uru ikeno ilo ŋinde, ŋana tu luma sapâŋa iveta “gol” ipâŋga sapâŋa. Tiambo miki kazizâla ŋana ŋine kâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aku mine nâ, miki uru kapanananzi tamâta tu, ‘Ambo tamâta toŋge iveta ŋgua pâŋa toŋge, aku isarâwa pa patarawâŋa nia ŋana isuka ne ŋgua pâŋa ŋinde kâ, ande i ne ŋgua pâŋa ŋinde nde mao tia. Mine kala ambo muli i ma imbware ŋgua pâŋa ŋinde, ande i ne soki tia. Taitu mambo isarâwa pa kelekele ikeno patarawâŋa nia kulu ŋinde, ande ŋgua pâŋa ŋinde nde mao, kala i ma imbware ndimo.’ ");
INSERT INTO xsi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Opopo, miki matami leva-leva ndo! Kelekele ndia ipâŋga ŋalae tina lâ Maro Kindeni nao, a? Patarawâŋa nia nde kelekele ara ndo, ipole kelekele uru ikeno kulu ŋinde, ŋana tu patarawâŋa nia iveta kelekele ŋinde ipâŋga sapâŋa. Tiambo miki kazizâla ŋana ŋine kâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mine kala tamâta ea isarâwa pa patarawâŋa nia tu isuka ne ŋgua pâŋa kâ, ande isarâwa pa patarawâŋa nia tava kelekele ndia ikeno kulu tona. ");
INSERT INTO xsi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aŋga tamâta ea isarâwa pa Maro Kindeni ne luma sapâŋa tu isuka ne ŋgua pâŋa kâ, ande isarâwa pa luma sapâŋa tava Maro Kindeni tona, ina uru imo luma sapâŋa ŋinde ilo. ");
INSERT INTO xsi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aŋga tamâta ea isarâwa pa samba tu isuka ne ŋgua pâŋa kâ, ande isarâwa pa Maro Kindeni ne saŋonâŋa nia wa Maro Kindeni tona, ŋana tu ina uru isaŋona nia ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo kilo tu, “Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa! Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Miki uru kagona kâi lau kie-kie ŋana iveta kâpwa mona-mona kâ, ku kao lâ wâra saŋao-saŋao, ŋineŋga wâra taitu-taitu uru kalua Maro Kindeni itogo patarawâŋa mine, aku ŋine nde ara. Ambo taitu miki kalaŋa kapole ŋgua tukuŋa ŋalae tina ŋana kaveta kemi ara nâ panzi tamâta wa tinimi mwasa panzi wa kamandi kaika ŋana nemi kalo-tawana wa. Ara ŋana miki ma koka ŋgua tukuŋa ŋalaŋala ŋinde muli, aku koka tukuŋa kiri-kiri muli tona. ");
INSERT INTO xsi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Opopo, miki matami leva-leva, andeta katogo tu katula nzâla panzi tamâta! Miki kapono muli pa ŋgua tukuŋa kiri-kiri, aŋga kalomi kapa ŋana ŋgua tukuŋa ŋalaŋala. Mine kala miki katogo tamâta toŋge isânda lâŋo mota mwata lâ kâ lââ ilo ku ikai piti itambira lâ. Andeta i ŋandai imora ŋgoa ŋalae “kamel” ikeno lââ ilo ŋga; mine nde inu ipaŋando ndoni indue lâ kapwa ilo. ");
INSERT INTO xsi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa! Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Miki uru kaveta nemi kâmba wa kondo kumbu tu sipâŋga mbâra-mbâra ndo. Aŋga kâpwa wa lââ miki uru kao lâ ilo, ande ŋinde miki muŋga kakai lâ nemi vetâŋa potomule wa ilo-kalo sakamao wa. ");
INSERT INTO xsi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Miki Parisai tamâta nde matami leva-leva ndo! Kaveta ilomi mbâra-mbâra muŋga lâ, ŋineŋga kapua kondo kumbu tona, ŋana ruani ma ipâŋga mbâra-mbâra. ");
INSERT INTO xsi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa! Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Miki katogo kuru toŋge; kuru kulu pa nia yo kâ nde pâne ndo, aku ara pâta ŋana tamâta simora kâ. Andeta mateŋa tamâta tukanzi wa kelekele rârâni sâmbu ndo nde sipipi lâ ikeno kuru ilo. ");
INSERT INTO xsi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aku miki kala kamo mine nâ. Kinzi tamâta simora karaemi nâ, ku situ miki nde tamâta ŋana koka Maro Kindeni ne ŋgua muli kâ. Andeta mâsi laŋeŋa tava mâsi sakamao nde ipipi lâ ikeno ilomi kalomi.” ");
INSERT INTO xsi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo ŋgua pinde panzi kilo tu, “Oyae, mâsi sakamao ndo ma ipâŋga pa miki pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa miki Parisai tamâta wa! Miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti! Miki uru kaveta kuru nia ara ndo panzi ŋgua-tulâŋa tamâta muŋgâŋa, aku kaveta siŋgâra arara nâ kasiŋgara kinzi tamâta ara nenzi kuru tona, kinzi ŋinde muŋga sipono muli pa Maro Kindeni. ");
INSERT INTO xsi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aku miki uru kaporo tu, ‘Ambo tu maka kamo muŋgani, lâ timbuma nenzi zo, ande maka ma kasukanzi ŋana kakai kazâŋa panzi ŋgua-tulâŋa tamâta ku kapunzi pâta simâte, ande tia ndo!’ ");
INSERT INTO xsi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Andeta miki nemi ŋgua ndainani itula warakami kilalami pwataki tu mikini nde kinzi tamâta ŋinde nenzi vâsa, kinzi ŋinde muŋga sipunzi ŋgua-tulâŋa tamâta pâta simâte. ");
INSERT INTO xsi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ara mbo, mine kala ŋine miki kalâ, aku vetâŋa potomule ndia muŋga timbumi siveta marumbu tia yo, ande ŋinde miki kalâ kaveta marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Miki nde mwâta sakamao natunzi! Maro Kindeni ma iomi kalâ pa ne ŋgua nia, ŋineŋga ma itambirami kalâ pa yââ ŋalae ne mbââ ilo. Miki kakura tu kaŋgeŋgeana ŋana i ne pareŋa-nia ŋinde kâ, ande tia ndo! ");
INSERT INTO xsi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mine kala miki kaloŋo sondo ŋga. Naŋa ma asupwanzi kinzi ŋgua-tulâŋa tamâta wa ilo-kalo tamwatanzi wa pananâŋa simâ pami. Andeta miki ma kasonanzi pinde sitâra lâ kâi popole tini simâte. Aŋga pinde nde ma kapalilinzi lâ nemi luma ŋana pasauŋa kâ ilo, ŋineŋga ma kalinzi sikâwa pwapwataki silâ pa lawea pinde. ");
INSERT INTO xsi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mine kala Maro Kindeni ma ipare nia pa miki nâ ŋana kinzi tamâta rârâni simo muŋga-muŋga ŋinde nenzi kiesaka kâ, kinzi ŋinde muŋga sikainzi tamâta arara ku sipunzi pâta simâte. Maro Kindeni ma nâna ŋalae ilua mikini ŋana Adam natu Abel ne mateŋa lâ nia ndoyo, aku imâ lee ipâŋga lâ zo ŋinde miki Juda tamâta kapu Berekaia natu Sakaria imâte, lâ patarawâŋa nia ŋga Maro Kindeni ne luma sapâŋa ŋgininzi. ");
INSERT INTO xsi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Naŋa aporo mao nâ pami; kulu sakamao ŋana vetâŋa potomule muŋgâŋa ŋinde rârâni nde ma imâ ipâŋga pa miki tamâta ŋgu ŋine kala kamo lâ zo ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo kilo mine tu, “O, Jerusalem, Jerusalem, miki uru kakai kazâŋa panzi ŋgua-tulâŋa tamâta kala kapunzi pâta simâte. Mao nâ, miki kakainzi tamâta ŋinde Maro Kindeni isupwanzi simâ pami, aku mira nâ kasianzi pâta ku kapunzi simâte. Ikura zo zo naŋa atu agogorami, itogo tatareko tina igogoranzi natu silâ taitu ku isupinanzi lâ mbani kalo mine. Andeta miki tinimi pwâka. ");
INSERT INTO xsi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mine kala kaloŋo ŋga; Maro Kindeni nde ipile nemi luma sapâŋa ku ilâ lâ, kala luma sapâŋa ikeno ilo kaa nâ. ");
INSERT INTO xsi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Naŋa apaimi tu miki ma kamora naŋa kilo tia lee, ikura lâ zo muli ŋinde miki ma kaporo tu, ‘Maro Kindeni itu nzâmbe pa koipu ŋalae ŋine ikai i ndamwa kala imâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ipile Maro Kindeni ne luma sapâŋa aku iyoka ilâ, ŋineŋga ne pâri-tamâta nde simâ kuku. Kinzi situ situla luma arara ikeno nia sapâŋa ŋinde papa. ");
INSERT INTO xsi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Andeta Yesu ipainzi tu, “Miki kamora luma arara ŋine, a? Naŋa aporo mao nâ pami; kinzi ma sipile luma ŋine ne mira toŋge ikeno mira toŋge kulu tia ndo. Kinzi ma sisapira rârâni iyauru bururu ndue lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ikâki isaŋona Oliv Tuu kulu, ŋineŋga ne pâri-tamâta simbonzi nâ nde simâ papa ku sikasoŋa tu, “Maka katu kasama ŋine; mâsi ŋinde ma ipâŋga lâ zo ndia. Aku mâsi ndia ma ipâŋga ŋana itula pwataki tu noko ne zo ŋana kutaulo kumâ kilo nde imâ laiti lâ, kala tâno ŋine ne zo nde laiti ŋana marumbu kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ande Yesu itula ŋgua pwataki panzi mine tu, “Miki kapakatona sondo ŋga. Tia ma tamâta toŋge ilaŋemi. ");
INSERT INTO xsi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ŋana tu kinzi tamâta rârâ ma simâ sipatu naŋa ŋâŋgu ku ma siporo tu, ‘Naŋani tamwatâŋgu kala Kirisi’, ku ma sikai laŋeŋa mine panzi tamâta rârâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aku miki ma kaloŋo paraŋa ŋalaŋala ne nduŋeŋani imâ laiti, aku ma kaloŋo ŋgua ŋana paraŋa ŋalaŋala pinde ipâŋga nia malawae tona. Andeta miki ma tinimi ruru ndimo, ŋana tu ŋinde ma imâ ipâŋga, aŋga zo ŋalae ŋana tâno ŋine ne zo marumbu kâ nde ma ipâŋga tia yo. ");
INSERT INTO xsi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kinzi tamâta lâ lawea pinde ma simandi sikai kazâŋa panzi tamâta lâ lawea pinde, aŋga ŋgu pinde ma simandi sikai kazâŋa panzi ŋgu pinde. Putole ŋalae ma ipâŋga lâ tâno pinde, aku ogigi ma iririŋo tâno pinde yâti taulo. ");
INSERT INTO xsi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mâsi ŋine rârâni ma ipâŋga muŋga, itogo nâna uru ipâŋga panzi taine kâpwa-kâpwa ku itula tu paguguŋa ne zoni nde imâ ipâŋga laiti lâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Lâ zo ŋinde kinzi ma sikai miki kaika ku siomi lâ ŋgua nia ŋana nâna wa malia silami, aku ma sipumi pâta kamâte. Kinzi tamâta rârâni ma ilonzi sakamao ndo ŋanami, ŋana tu miki kalomi tawana naŋa. ");
INSERT INTO xsi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lâ zo ŋinde, kinzi kalo-tawana tamâta rârâ ma sipile nenzi kalo-tawana, aku ma simandi sikai kazâŋa wa wisi-nâna ŋalae tina pa nawalanzi, ku ma sionzi silâ kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aku ŋgua-tulâŋa tamâta laŋeŋa rârâ ma simandi ku ma sikai laŋeŋa panzi tamâta rârâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Vetâŋa potomule ma ipâŋga more-more ŋalae tina. Mine kala tamâta rârâ ma sipile mâsi ŋana tininzi mwasa panzi tininzi pinde kâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aŋga tamâta ea ne kalo-tawana ikeno mao pa naŋa, kala ipile ne kalo-tawana tia, ande Maro Kindeni ma via mao ilua i, kala ma imo via mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aku kinzi tamâta pinde ma silâ situla pâri ara ŋana Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ sikura tâno ndoni, kala tamâta rârâni ma siloŋo lâ. Ŋineŋga zo ŋalae ŋana tâno ŋine ne zo marumbu kâ ma imâ ipâŋga.” ");
INSERT INTO xsi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipainzi ne pâri-tamâta kilo mine tu, “Miki ma kamora vetâŋa sakamao ndo ipâŋga iveta muso ŋalae lâ Maro Kindeni ne luma sapâŋa ilo. Ŋgua-tulâŋa tamâta muŋgâŋa Taneli itula ŋgua pwataki ŋana vetâŋa ŋinde.” (Noko tamâta ea kupono ŋgua ŋine, ande kalo ŋgere sondo ŋana kusama duvi.) ");
INSERT INTO xsi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Pa zo ŋinde, ara ŋana kinzi tamâta simo Judia tâno ma sikâwa silâ pa nia tuu. ");
INSERT INTO xsi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ambo toŋge imo ne luma mende kulu, ande ara ŋana i ma indue ku ikâwa nâ ilâ; i ma ilâ luma ilo ŋana ikai ne kelekele toŋge ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ambo toŋge imo ne tâno ilo, ande i ma itaulo ilâ luma ilo ŋana ikai ne pasawaŋa luandondo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Opopo, lâ zo ŋinde kalo-sukâŋa ŋalae ma ilâ panzi taine kâpwa-kâpwa wa kinzi taine ŋinde natunzi simo suu tini yo. ");
INSERT INTO xsi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ara ŋana miki ma kano kaika tu mâsi ŋinde ma ipâŋga lâ mâo ne zo tia. Aku mine nâ, ara ŋana miki ma kano tu mâsi ŋinde ma ipâŋga lâ pwareâŋa ne zo sapâŋa tia. ");
INSERT INTO xsi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ŋana tu lâ zo ŋinde, malia ŋalae tina ma ipâŋga. Nia ndoyo, lâ zo ŋinde Maro Kindeni ipulia samba wa tâno wa kelekele rârâni sipâŋga lâ, aku imâ lee ipâŋga lâ zo ŋine, ande malia kie-kie mine muŋga ipâŋga tia ndo. Aku muli kala malia kie-kie mine ma ipâŋga kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ambo Maro Kindeni ma io zo luandondo ŋana malia kie-kie ŋine, ande kinzi tamâta rârâni ma sipamateteu marumbu lâ. Andeta Maro Kindeni ilo ndo keno panzi tamâta muŋga ipateanzi ŋinde, kala ma io zo ŋinde mbuku taitu nâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pa zo ŋinde, ambo tamâta toŋge ipaimi tu, ‘Kamora ŋga, Kirisi imo ŋai!’, tâku ‘Imo ndai!’, ande miki ma kalomi tawana ŋgua ŋinde ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ŋana tu lâ zo ŋinde, kinzi ‘Kirisi’ laŋeŋa rârâ aŋga ŋgua-tulâŋa tamâta laŋeŋa rârâ ma simâ sipâŋga, ku ma siveta mâsi kie-kie pinde sitogo tu silaŋenzi tamâta Maro Kindeni muŋga ipateanzi ŋinde. Andeta kinzi ma sikura tia. ");
INSERT INTO xsi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Miki kaloŋo ŋga! Naŋa aporo atula vetâŋa ŋine pwataki pami lâ, aku mao kanaŋo, vetâŋa ŋine ma muli ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mine kala lâ zo ŋinde, ambo kinzi sipaimi tu, ‘Kamora ŋga, Kirisi imo nia bilimu ndai!’, ande miki ma kalâ pa nia ŋinde ndimo. Ambo siporo tu, ‘Kamora, Kirisi ipavea imo luma ŋinde ilo’, ande miki ma kalomi tawana nenzi ŋgua ndimo. ");
INSERT INTO xsi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ŋana tu miki kasama tu zo ŋana loloa salaga, ande sinâla ŋinde uru ipâŋga muŋga pa wâra kâ, ku ipane nia ilâ walele nâ pa mbwera kâ. Aku naŋa Tamâta Natu kala ma ayoka pa samba ilo andue amâ mine nâ. Mine nde kinzi tamâta rârâni ma simora ku sisama. ");
INSERT INTO xsi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lâ nia ndia ŋgoa imâte ku karae sâmbu nâ ikeno, ande kinzi sii malabogi uru sipagona lâ niani ndaina.” ");
INSERT INTO xsi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo kilo tu, “Mâsi wa malia ŋalae tina ŋinde rârâni ma ipâŋga lâ ŋga, ŋineŋga walele nâ ‘kari mata ma ipâŋga ŋaŋa, aŋga nzimona ma mata ipane nia kilo tia, aŋga pitu ma simbe piti lâ samba tini, aŋga samba ne siŋgâra kaika rârâni ma silâ wa simâ wa.’ ");
INSERT INTO xsi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aku lâ zo ŋinde, mâsi toŋge ma ipâŋga lâ samba tini ŋana itula zo pwataki tu Tamâta Natu ŋga imâ. Aku kinzi tamâta rârâni lâ tâno kulu ma sipataiŋa nâ. Kinzi rârâni ma simora naŋa Tamâta Natu ayoka samba ne take-take kulu amâ apâŋga tava walo ŋalae. Kinzi ma simora naneŋgu sinâla ŋalae, ande kala ma sisama naŋa kilalâŋgu pwataki tu naŋa nde Maro Ŋalae. ");
INSERT INTO xsi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aku aŋelo toŋge ma imbana tando ŋalae ilâ nduŋeŋa ŋalae tina, ŋineŋga naŋa ma aonzi naneŋgu aŋelo simâ sigonanzi naneŋgu tamâta rârâni muŋga apateanzi ŋinde. Mao nâ, kinzi aŋelo ma silâ sikura nia ndoni lâ tâno kulu ŋana sikainzi naneŋgu tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Miki kalomi ŋgere ŋana kâi pâla-pâla kâ, ŋana tu ŋinde ma isukami ŋana kasama naneŋgu ŋgua ŋine ne duvi. Lâ zo ŋana kâi pâla-pâla irumba ku lau wasaseki ipâŋga, ande ŋinde miki kasama tu kari ne zo ŋga imâ ipâŋga laiti lâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aku mine nâ, ambo miki kamora mâsi ŋinde rârâni ipâŋga marumbu lâ, ŋineŋga miki ma kasama tu tâno ŋine ne zo ŋga laiti ŋana marumbu kâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Naŋa aporo mao nâ pami; kinzi tamâta lâ zo ŋine ma simâte tia yo, ŋineŋga mâsi rârâni ŋinde ma imâ ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mao nâ, samba wa tâno wa ma marumbu lâ, aŋga naŋa kawâŋgu ŋgua nde ma marumbu tia ndo, ma ikeno mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu iporo ŋgua ŋine lâ, ŋineŋga iporo kilo mine tu, “Tamâta toŋge isama zo ndia wa kari tai ŋapia naŋa ma ataulo amâ kilo, ande tia. Kinzi aŋelo lâ samba ilo sisama ŋine tia, aku naŋa Maro Kindeni Natu tamwatâŋgu kala asama tia. Mama simbo nâ isama. ");
INSERT INTO xsi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nia ndoyo, lâ Noa ne zo, kinzi tamâta sizizâla ŋana pondi ŋalae laiti ŋana ipâŋga kâ, aku simo nenzi. Aku mine nâ, kinzi tamâta ma sizizâla ŋana naneŋgu zo ŋana ataulo amâ apâŋga kâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mao nâ, lâ zo muŋgâŋa ŋinde, pondi ŋalae ipâŋga tia yo, ku kinzi tamâta nde simo nenzi, sika wa sinu wa sipakâe wa. Siveta mine ku simo lee, ŋineŋga Maro Kindeni ipai Noa tu ikâki ilâ wâŋga ŋalae muŋga isape ŋinde ilo. ");
INSERT INTO xsi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kinzi tamâta ŋinde nde sizizâla ŋana mâsi ma ipâŋga panzi ŋinde, ku simo mine lee, ŋineŋga pondi ŋalae ipâŋga ku izavarunzi tamâta rârâni marumbu lâ. Ande kala vetâŋa kie taituni nâ ma ipâŋga lâ naŋa Tamâta Natu neŋgu zo ŋana amâ apâŋga kâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kinzi tamâta rua ma simo nenzi tâno ilo, aku Maro Kindeni ma ikai toŋge imâ imo kuku, aŋga ma ipile toŋge imo. ");
INSERT INTO xsi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kinzi taine rua ma simo simomo kanzi puroŋa, aku Maro Kindeni ma ikai toŋge imâ imo kuku, aŋga ma ipile toŋge imo. ");
INSERT INTO xsi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mine nde miki ma kaka mâsa ku kamo nâ, ŋana tu miki kazizâla ŋana zo ndia nemi Maro Ŋalae ma imâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Miki kalomi ŋgere sondo ŋga. Ambo luma warika isama muŋga lâ ŋana kari tai ŋapia lâ mbo panawe tamâta ma imâ, ande i ma ika mâsa, kala panawe tamâta ma ikura tu imâ ipu luma pwataki ku imâ ilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mine nde miki kala kao tinimi ku kamo nâ, ŋana tu naŋa Tamâta Natu kala ma ataulo amâ lâ zo toŋge miki ilomi patea tu ma amâ tia.” ");
INSERT INTO xsi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ŋineŋga Yesu itambira ŋgua panzi ne pâri-tamâta mine tu, “Ambo koipu toŋge imora ne wurâta tamâta toŋge tu i tamâta ara, ŋana tu i uru iveta ikura koipu iporo mine, aku ne ilo-kalo nde sondo; ande koipu ma ipatea tamâta ŋinde tu ipâŋga mbâna-mbâna ku ikatonanzi ne wurâta tamâta pinde wa kâpwa ilanzi wa. ");
INSERT INTO xsi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ambo koipu ŋinde ilâ pa nia malawae toŋge, ŋineŋga itaulo imâ ku imora wurâta tamâta ŋinde iveta ne wurâta ara mine nâ, ande wurâta tamâta ŋinde ikura ŋana indeka kâ. ");
INSERT INTO xsi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Naŋa aporo mao nâ pami; koipu ma ipatea wurâta tamâta ŋinde tu ikai poe pa i ne kelekele rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Taitu kaloŋo ŋga; ambo wurâta tamâta mbâna-mbâna ŋinde nde tamâta ara tia, ande i ma iporo lâ ilo tu, ‘Naneŋgu koipu ma imo soŋgo, ma itaulo imâ walele tia.’ ");
INSERT INTO xsi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ŋineŋga i ma imandi ŋana ipunzi wurâta tamâta, aku ma ika wa inu kunzi tamâta pinde uru sinu rârâ ku sidauda ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ambo mine, ambo koipu itaulo imâ lâ zo toŋge wurâta tamâta ŋinde ŋandai isama ku io tini ŋana ŋga, ");
INSERT INTO xsi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ande koipu ma izavaru wurâta tamâta ŋinde ndo, ku ma io imo kunzi tamâta ŋinde uru kawanzi nâ sipanea Maro Kindeni, andeta ilonzi keno papa tia. Lâ nia ŋinde, kinzi ma sita pâta lâ ku niŋonzi giri-giri ŋana sikai nâna kâ.” ");
INSERT INTO xsi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ŋineŋga Yesu itambira ŋgua panzi ne pâri-tamâta mine tu, “Maro Kindeni ne zo ŋana imâ ikai maro panzi tamâta kâ, ande itogo ŋine: Tamâne toŋge itu ikai taine toŋge itogo kaiwa mine. Aku rua nenzi zo ŋana sipakâe kâ nde ipâŋga lâ, kala taine taipa saŋao sikai nenzi lamu ku silâ pa nawalanzi taine ŋinde ne luma. Sipâŋga lâ, ŋineŋga sisaŋona ku sio tininzi pa pakâeŋa tamwata ŋinde, ŋana tu i ma muli imâ ikai taine, ku rua ma silâ pa tamâne ne luma. Kinzi taine saŋao ŋinde ilonzi tu ma silâ kunzi ku sika kâŋa-nuŋa ŋana nenzi pakâeŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Kinzi taine lima nde ilonzi kalonzi ara koŋa tia, ŋana tu sikai nenzi lamu kaa nâ simâ, aku ŋandai sikai lââ tona ŋga. Aŋga kinzi taine lima nde simo tava ilonzi kalonzi ara nâ, ŋana tu muŋga siwuwu nenzi lââ lâ belo ilo ku sikai tava lamu simâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Andeta pakâeŋa tamwata nde imâ walele tia, aku kinzi taine taipa saŋao nde sio tininzi lee matanzi matutu, kala sikeno lâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sikeno lee, ku mbo ŋgini-ŋgini, ŋineŋga siloŋo sarawâŋa toŋge ipâŋga mine tu, ‘Ayo, pakâeŋa tamwata kala imâ lâ, kala miki kamâ kamora ku takai talâ!’ ");
INSERT INTO xsi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ŋineŋga kinzi taine taipa saŋao nde simandi sânda ku siveta nenzi lamu sondo lâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kinzi taine taipa lima nenzi lââ tia ŋinde nde sino nawalanzi taine ŋinde tu, ‘Wa, miki lââ nuŋa mwata kalua maka ŋga, ŋana tu maka nema lââ tia, aku laiti ŋana yââ imâte kâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Andeta kinzi ilo-kalo taine lima ŋinde nde siporo taulo panzi nawalanzi tu, ‘Tia ma! Lââ ŋine nde ikura maka nâ, ma ikura miki tona, nde tia. Ara ŋana miki ma kalâ panzi tamâta ŋana sipako lââ kâ, aku kako ikura warakami nemi nâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ŋineŋga kinzi taine lima ŋinde nde silâ ŋana siko nenzi lââ kâ. Silâ lâ, ŋineŋga pakâeŋa tamwata imâ ipâŋga. Kinzi taine lima muŋga sikai nenzi lââ ŋinde nde silâ kuku, aku silâ luma ilo ŋana sika waiŋa pakâeŋa ne kâŋa-nuŋa kâ. Silâ luma ilo lâ, ŋineŋga kinzi wurâta tamâta sisae nzâla kaika giri lâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aku muli, ŋineŋga kinzi taine lima ŋinde sitaulo simâ, aku sita sisarâwa ku sipai tu, ‘Wa, tamâta ŋalae! Tamâta ŋalae! Kumâ pwai nzâla piti pama ŋga!’ ");
INSERT INTO xsi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Andeta pakâeŋa tamwata iporo taulo tu, ‘Naŋa aporo mao tu naŋa asama miki tia.’” ");
INSERT INTO xsi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu iporo ŋgua tambirâŋa ŋine lâ, ŋineŋga ipainzi ne pâri-tamâta tu, “Mine nde miki ma kaka mâsa ku kamo nâ, ŋana tu miki kazizâla ŋana zo wa kari tai ŋapia naŋa ma ataulo amâ kilo.” ");
INSERT INTO xsi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ŋineŋga Yesu itambira ŋgua toŋge panzi ne pâri-tamâta kilo tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, nde itogo ŋine: mbaliŋa warika toŋge itu iyoka ilâ pa nia malawae kâ. Mine kala isarawanzi ne wurâta tamâta simâ, ku iwae ne mbaliŋa panzi ŋana sikatona kâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I kalo ŋgere ŋana ne wurâta tamâta taitu-taitu nenzi ilo-kalo wa vetâŋa wa, ŋineŋga iwae mbaliŋa panzi. Tamâta toŋge nde mbumbu 5,000 ilua, aŋga toŋge nde mbumbu 2,000 ilua, aŋga toŋge nde mbumbu 1,000 ilua. Iveta mine nâ ilanzi lâ, ŋineŋga ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ilâ lâ, ŋineŋga wurâta tamâta ŋinde muŋga ikai mbumbu 5,000 ŋinde, nde iveta wurâta lâ tini, aku mbumbu pagugu ŋalae. Aku ikai mbumbu ŋinde ne kalulu wasaseki pinde ipâŋga lâ 5,000 kilo. ");
INSERT INTO xsi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aŋga wurâta tamâta muŋga ikai mbumbu 2,000 ŋinde, ande i kala iveta wurâta lâ tini mine nâ. Aku ikai mbumbu ŋinde ne kalulu wasaseki pinde ipâŋga lâ 2,000 kilo. ");
INSERT INTO xsi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aŋga wurâta tamâta muŋga ikai mbumbu 1,000 ŋinde, ande ilâ iveta wewe ŋalae lâ tâno ilo, aku ikea tamâta ŋalae ne mbumbu ŋinde lâ wewe ilo ikeno. ");
INSERT INTO xsi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Zo luandondo lâ, ŋineŋga kinzi wurâta tamâta ŋato ŋinde nenzi tamâta ŋalae nde itaulo imâ. Imâ lâ, ŋineŋga iveta ŋgua sondo kunzi ŋana mbumbu kala muŋga ilanzi ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ŋineŋga wurâta tamâta muŋga ikai mbumbu 5,000 ŋinde nde imâ ku iporo itula mine, ‘Tamâta ŋalae, noko muŋga mbumbu 5,000 kulua naŋa. Ayo, kumora ŋga, naŋa aveta wurâta lâ tini, kala akai mbumbu kalulu 5,000 kilo tona.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ŋineŋga ne tamâta ŋalae nde ipai mine tu, ‘Noko nde wurâta tamâta ara ndo. Noko uru kuveta wurâta ara nâ ku pwatona ne wurâta sondo nâ. Noko muŋga pwatona naneŋgu mbaliŋa mota mwata ŋinde sondo; mine kala naŋa ma wurâta alano tu pwatona mbaliŋa ŋalae tina. Naŋa iloŋgu ndeka nâ! Kumâ kundeka kuku naŋa!’ ");
INSERT INTO xsi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ŋineŋga wurâta tamâta muŋga ikai mbumbu 2,000 ŋinde, ande i kala imâ, ku iporo itula mine, ‘Tamâta ŋalae, noko muŋga mbumbu 2,000 kulua naŋa. Ayo, kumora ŋga, naŋa aveta wurâta lâ tini, kala akai mbumbu kalulu 2,000 kilo tona.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ŋineŋga ne tamâta ŋalae nde ipai mine tu, ‘Noko nde wurâta tamâta ara ndo. Noko uru kuveta wurâta ara nâ ku pwatona ne wurâta sondo nâ. Noko muŋga pwatona naneŋgu mbaliŋa mota mwata ŋinde sondo; mine kala naŋa ma wurâta alano tu pwatona mbaliŋa ŋalae tina. Naŋa iloŋgu ndeka nâ! Kumâ kundeka kuku naŋa!’ ");
INSERT INTO xsi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ŋineŋga wurâta tamâta muŋga ikai mbumbu 1,000 ŋinde, ande i kala imâ, ku iporo itula mine tu, ‘Tamâta ŋalae, naŋa asama tu noko uru kalo sukâŋa ŋananzi tamâta tia ndo. Noko uru kugona kâpwa lâ tamâta pinde nenzi tâno, andeta noko muŋga kuliŋi kaniŋa vâsa lâ tâno ŋinde ilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Asama ŋine lâ, ande kala naŋa aruru, kala akai noko ne mbumbu 1,000 ŋinde alâ avea lâ tâno ilo. Ande kala ŋai, pwai noko ne mbumbu 1,000 ŋine.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ŋineŋga ne tamâta ŋalae nde ipai mine tu, ‘Noko nde wurâta tamâta sakamao. Noko wulitia tamwata! Noko kusama tu naŋa uru agona kâpwa lâ tamâta pinde nenzi tâno, andeta naŋa muŋga aliŋi kaniŋa vâsa lâ tâno ŋinde ilo tia, a? ");
INSERT INTO xsi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mine nde ŋana sâ kâ ŋga noko ŋandai kuo naneŋgu mbumbu lâ pinze ilo, a? Ambo noko muŋga kuveta mine, ŋineŋga ataulo amâ, ande naŋa ma akai naneŋgu mbumbu 1,000 aŋga kalulu wasaseki pinde tona. Andeta tia. ");
INSERT INTO xsi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mine kala miki kakai mbumbu 1,000 ŋine saŋe wurâta tamâta ŋine, ku kalua tamâta ŋine muŋga ikai mbumbu 10,000. ");
INSERT INTO xsi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ŋana tu tamâta ea uru iveta wurâta ara pa naŋa, ande naŋa ma wurâta ŋalae alua i tu ma iveta, kala i ma imo itogo tamâta ŋalae mine. Aŋga tamâta ea uru iveta wurâta ara tia pa naŋa, ande naŋa ma akai wurâta ŋine saŋe, kala i ma imo itogo tamâta kaa nâ mine. ");
INSERT INTO xsi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ayo, miki kakai wurâta tamâta sakamao ŋinde ku katambira ilâ pa nia kondoma. Lâ nia ŋgaŋe ŋinde kinzi ma sita pâta ku niŋonzi giri-giri ŋana sikai nâna kâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ŋineŋga Yesu ipainzi ne pâri-tamâta kilo mine tu, “Lâ zo muli, naŋa Tamâta Natu ma akainzi naneŋgu aŋelo rârâni ataulo amâ atogo koipu ŋalae mine, ŋineŋga naŋa tamwatâŋgu ma asaŋona koipu ŋalae ne saŋonâŋa nia ŋana apare nia panzi tamâta kâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naŋa ma agonanzi tamâta rârâni muŋga simo lâ nia ndoni lâ tâno kulu, aku ma simâ simandi naoŋgu. Aku ma apateanzi ku awaenzi pwapwataki lâ ŋgu rua, itogo ‘lama’ nenzi katonâŋa ipateanzi lama piti simo lâ ŋgu toŋge, aŋga ‘meme’ simo piti lâ ŋgu toŋge. ");
INSERT INTO xsi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naŋa ma aonzi tamâta ŋinde muŋga sipono muli pa Maro Kindeni silâ simo pa tiniŋgu pa wia kâ. Aŋga kinzi tamâta muŋga sipu mulinzi pa Maro Kindeni, kinzi ŋinde ma silâ simo pa tiniŋgu pa ŋâsi kâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ŋineŋga naŋa Koipu Ŋalae ma apainzi tamâta simo pa tiniŋgu pa wia kâ tu, ‘Miki kamâ. Naŋa Mama ne nzâmbe imo kumi, aku i tamwata ma ikai maro sondo pami. Kamâ kakai nzâmbe ŋine Mama nia ndoyo ipatea pami, lâ zo ŋinde ipulia samba wa tâno wa. ");
INSERT INTO xsi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nzâmbe ŋine imâ pami, ŋana tu muŋga naŋa putole ipuna, ande miki kâpwa kalana aka. Naŋa arakoŋa ŋana lââ kâ, ande miki lââ kalana anu. Naŋa ayoka lombo amâ pami, ande miki kao naŋa lâ nemi luma ilo. ");
INSERT INTO xsi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Naneŋgu lalava toŋge tia, ande miki lalava kalana apita. Naŋa akai pukoŋa, ande miki kakatona naŋa. Naŋa amo luma sakamao ilo, ande miki kamâ kakalele naŋa.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kinzi tamâta ŋinde muŋga sipono muli pa Maro Kindeni, ande ma sikasoŋa naŋa tu, ‘Maro Ŋalae, lâ zo ndia noko putole ipuno kala maka kâpwa kalano. Aku lâ zo ndia noko kurakoŋa ŋana lââ kâ, kala lââ kalano. ");
INSERT INTO xsi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aŋga lâ zo ndia maka kamora noko pwoka lombo kumâ pama, kala kaono lâ nema luma ilo. Aŋga lâ zo ndia noko ne lalava toŋge tia, kala maka lalava kalano. ");
INSERT INTO xsi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aŋga lâ zo ndia maka kamora noko kupoko kala kakatonano, wa kumo luma sakamao ilo kala kamâ kakalele noko.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ŋineŋga naŋa ma aporo taulo panzi mine tu, ‘Naŋa aporo mao nâ pami: kinzi sugorai tamwatanzi ŋine nde simo niŋgu-nambwe wukale. Mine nde vetâŋa rârâni miki muŋga kaveta pa kinzi, ande ŋinde itogo miki kaveta pa naŋa tava.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ŋineŋga naŋa ma apainzi tamâta simo pa tiniŋgu pa ŋâsi kâ ŋinde mine tu, ‘Miki nde tamâta ŋana kakai Maro Kindeni ne pareŋa-nia kâ! Miki kakâwa kalâ pa yââ ŋalae ne mbââ ilo! Maro Kindeni muŋgani io yââ nia ŋinde panzi Sadana tavanzi ne aŋelo, aku yââ ŋinde ma imâte tia, ma ikana mine ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nâna ŋine imâ pami ŋana tu muŋga, naŋa putole ipuna, andeta miki ŋandai kâpwa kalana ŋga. Naŋa arakoŋa ŋana lââ kâ, andeta miki ŋandai lââ kalana ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Naŋa ayoka lombo amâ pami, andeta miki ŋandai kao naŋa lâ nemi luma ilo ŋga. Naneŋgu lalava toŋge tia, andeta miki ŋandai lalava kalana ŋga. Naŋa akai pukoŋa wa amo luma sakamao ilo wa, andeta miki ŋandai kamâ kakalele naŋa ŋga.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ŋineŋga kinzi kala ma sikasoŋa naŋa mine tu, ‘Maro Ŋalae, lâ zo ndia maka kamora noko putole ipuno wa, kurakoŋa ŋana lââ kâ wa, pwoka lombo kumâ pama wa, kumo kaa nâ ne lalava tia wa, pukoŋa ikaino wa, kumo luma sakamao ilo wa, andeta kakatonano tia, a?’ ");
INSERT INTO xsi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ŋineŋga naŋa ma aporo taulo tu, ‘Naŋa aporo mao nâ pami; vetâŋa arara ndia miki tinimi pwâka tu kaveta panzi sugorai tamwatanzi ŋine, ande ŋinde itogo miki kaveta pa naŋa tia mine nâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ŋineŋga naŋa ma aonzi tamâta ŋinde silâ ŋana sikai nenzi pareŋa-nia, kala ma sikai nâna ku simo nâ. Aŋga kinzi tamâta ŋinde muŋga sipono muli pa Maro Kindeni, ande kinzi ma sikai via mao, ma simo ara mine ku simo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu nde itula ŋgua ŋine rârâni pwataki marumbu lâ, ŋineŋga ipainzi ne pâri-tamâta tu, ");
INSERT INTO xsi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miki kasama tu zo rua nâ keno mo ŋai yo, ŋineŋga kumbwa ŋalae Pasova ma ipâŋga. Ŋineŋga kinzi ma sio naŋa Tamâta Natu lâ kazâŋa tamâta mbaunzi ilo, aku ma sisona naŋa atâra lâ kâi popole tini.” ");
INSERT INTO xsi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aŋga kinzi patarawâŋa tamâta ŋalaŋala nde sipasau silâ taitu kunzi Isrel nenzi katonâŋa lâ patarawâŋa tamâta kulu-kâmba Kaiafas ne luma. ");
INSERT INTO xsi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kinzi siporo siroto nzâla ŋana sikai Yesu kaika lâ nia ŋgaŋe toŋge, ŋana ma sipu pâta imâte kâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Andeta kinzi siporo tu, “Kinda ma taveta ŋine lâ zo sapâŋa tia. Tia ma kinzi tamâta wisinzi nâna ku siŋgoloa paraŋa, ku ma sipara potomule.” ");
INSERT INTO xsi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ŋineŋga Yesu ilâ pa Betani lawea, aku imo Saimon ne luma. Saimon nde tamâta toŋge muŋga ikai pukoŋa saga-saga, ŋineŋga tini mbâra-mbâra kilo. ");
INSERT INTO xsi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu nde isaŋona peke tini ŋana ika kâ, andeta taine toŋge ikai ne mira belo ara toŋge, samimi kuwae ara pâta keno ilo, ku ikai imâ pa Yesu. Samimi ŋinde nde kulu ŋalae tina. Aku taine ipaliŋi samimi ŋinde lâ Yesu kulu. ");
INSERT INTO xsi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu ne pâri-tamâta nde simora ŋine ku ilonzi kura tia ndo. Kinzi siporo tu, “Opopo, ŋana sâ kâ ŋga ipaliŋi samimi ŋine iyaula kaa nâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ambo kinda muŋga takai samimi ŋinde talanzi tamâta tu siko tâ, ande kinda ma takura tu takai kulu ŋalae ŋinde, aku mbumbu ŋinde ma talanzi sugorai tamwatanzi. Andeta tia.” ");
INSERT INTO xsi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Andeta Yesu isama tu nenzi ilo-kalo mine ikeno panzi, kala ipainzi tu, “Ŋana sâ kâ aŋga miki kaveta malia pa taine ŋine, a? Iveta mâsi ara pâta pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kinzi sugorai tamâta ma simo kumi ikura zo zo, aŋga naŋa nde ma amo soŋgo kumi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Taine ipaliŋi samimi ŋine ŋana iveta karaeŋgu sondo ŋana alâ pa kuru nia kâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Naŋa aporo mao nâ pami; lâ tâno ndia muli mbo kinzi ma silâ situla pâri ara ŋana naŋa kâ, ande kinzi ma situla vetâŋa taine ŋine iveta ŋinde tona, ŋana kinzi tamâta ma kalonzi ŋgere ŋana i wa.” ");
INSERT INTO xsi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ŋine ilâ lâ, ŋineŋga kinzi pâri-tamâta saŋao kanaŋonzi rua nawalanzi toŋge, i ŋa tu Judas Iskariot, ande ilâ panzi patarawâŋa tamâta ŋalaŋala. ");
INSERT INTO xsi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Aku ikasoŋanzi tu, “Ambo naŋa ma ao Yesu lâ miki mbaumi ilo, ande miki ma sâ kalua naŋa.” Ŋineŋga mbumbu tamâta taitu kanaŋo saŋao (30) silua. ");
INSERT INTO xsi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ŋineŋga Judas nde ilâ ku iroto zo ŋana ma io Yesu lâ kinzi kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ŋineŋga zo sapâŋa ŋana sika puroŋa ne yisi tia kâ ŋga ipâŋga lâ. Aku kinzi pâri-tamâta nde simâ pa Yesu ku sikasoŋa tu, “Noko ilo tu maka ma kaveta kelekele sondo lâ nia ndia, ŋana ma taka kumbwa Pasova ne kâŋa-nuŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu nde ipainzi tu, “Miki kalâ lawea ŋalae ilo, ku kalâ pa tamâta toŋge imo ndai. Kapai tamâta ŋinde tu, ‘Nema pananâŋa isupwama ŋana kaporo ŋgua pano tu i ne zo ŋga imâ ipâŋga lâ. I ma ika kumbwa ŋine ne kâŋa-nuŋa lâ noko ne luma ilo, tava maka, i ne pâri-tamâta.’” ");
INSERT INTO xsi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kinzi pâri-tamâta nde siveta ikura Yesu iporo panzi mine, aku siveta kâŋa-nuŋa sondo. ");
INSERT INTO xsi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kari indue lala pararai lâ, ŋineŋga Yesu isaŋona kunzi ne pâri-tamâta saŋao kanaŋonzi rua lâ kâŋa-nuŋa nia. ");
INSERT INTO xsi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kinzi sisaŋona sika yo, ande Yesu ipainzi tu, “Naŋa aporo mao nâ pami; tamâta toŋge lâ miki ŋginimi ma io naŋa lâ kinzi kazâŋa tamâta mbaunzi ilo.” ");
INSERT INTO xsi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kinzi pâri-tamâta nde siloŋo ŋgua ŋine ku ilonzi malia ndo, ku kinzi taitu-taitu sikasoŋa Yesu tu, “Maro Ŋalae, tiambo noko kuporo ŋana naŋa kâ, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu nde iporo taulo panzi tu, “Tamâta ŋinde nde io mbau lâ kondo ilo kuku naŋa, kala maka rua kaka lâ. Ina ma io naŋa lâ kinzi kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mao nâ, naŋa Tamâta Natu ma amâte, ikura Maro Kindeni kawa ŋgua kinzi ŋgua-tulâŋa tamâta muŋgâŋa siŋgere lâ pepa tini ikeno mine. Andeta vetâŋa sakamao ndo ma ipâŋga pa tamâta ŋinde kala io Tamâta Natu lâ kinzi kazâŋa tamâta mbaunzi ilo. Ambo nia ndoyo tamâta ŋinde tina ipagugua i tia tâ, ande ŋinde ma ara.” ");
INSERT INTO xsi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ŋineŋga Judas, ina muli ma io Yesu ilâ kazâŋa tamâta mbaunzi ilo, ande i tamwata ikasoŋa Yesu tu, “Pananâŋa, tiambo noko kuporo ŋana naŋa kâ, tiya?” Yesu nde itu lâ kawa tu, “Kala nokoni.” ");
INSERT INTO xsi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kinzi sisaŋona sika yo, ŋineŋga Yesu ikai puroŋa, kawa ndaŋge pa Maro Kindeni, aku ipwataki ilanzi ne pâri-tamâta. Aku iporo tu, “Miki kakai kaka. Naŋa kanaŋoŋgu kala ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ŋineŋga ikai kâmba waini kala mine nâ, kawa ndaŋge pa Maro Kindeni, ku ilanzi. Aku ipainzi tu, “Miki rârâni kanu waini ikeno kâmba ŋine ilo. ");
INSERT INTO xsi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Naŋa seeŋgu kala ŋine. Ŋine nde Maro Kindeni ne ŋgua pâŋa ne kanaŋo. Naŋa apaliŋi ŋananzi tamâta rârâ, ŋana izavaru nenzi kiesaka piti lâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naŋa aporo mao nâ pami; naŋa ma anu waini kanaŋo kilo tia lee, ikura lâ zo ŋinde Maro Kindeni ma ikai maro panzi tamâta lâ tâno kulu. Ŋineŋga ma anu waini waseki kuku miki.” ");
INSERT INTO xsi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesu iporo ŋgua ŋine lâ, ŋineŋga siwâŋgi wâŋgiŋa toŋge, aku simandi sipile lawea ŋalae ku siyâti silâ pa Oliv Tuu. ");
INSERT INTO xsi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Miki ma kamora mâsi ŋalae toŋge ipâŋga pa naŋa lâ ŋine mbo, ande kala miki rârâni nemi kalo-tawana ma imbe. Vetâŋa ŋine iyoke Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Naŋa ma apu lama nenzi katonâŋa tamâta, ande kala kinzi lama ma sikâwa pwapwataki silâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Andeta muli ŋga Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo, ŋineŋga ma ayoka amuŋga pami alâ Galilaya tâno.” ");
INSERT INTO xsi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yesu iporo mine, andeta Petero itu lâ kawa tu, “Ambo kinzi ŋine rârâni simora mâsi ŋalae ipâŋga pano, kala nenzi kalo-tawana imbe lâ, ande naneŋgu kalo-tawana ma imbe mine tia ku tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ŋineŋga Yesu ipai Petero mine, “Naŋa aporo mao nâ pano; ma ŋine mbo nâ, tatareko ma ita isuŋa kawa tia yo, ande noko ma kuporo kupatimoa naŋa mbwani ŋato tu noko kusama naŋa tia.” ");
INSERT INTO xsi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Andeta Petero iporo kilo pa Yesu tu, “Ambo kinzi situ sipu naŋa pâta amâte kuku noko, ande naŋa ma aporo apatimoa noko mine tia ku tia ndo kanaŋo!” Aku kinzi pâri-tamâta rârâni kala siporo ŋgua kaŋa taituni mine. ");
INSERT INTO xsi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ŋineŋga Yesu ikainzi ne pâri-tamâta silâ sipâŋga tâno toŋge, i ŋa tu Getsemani, aku ipainzi tu, “Miki kasaŋona kamo ŋai, mbo naŋa alâ ndai akai noŋa ŋga.” ");
INSERT INTO xsi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ŋineŋga Yesu ikainzi Petero ŋga Sebedi natu rua, aku kinzi ŋato silâ kuku. Ŋineŋga Yesu kalo sukâŋa ŋalae tina ku isama ilo malia ndo. ");
INSERT INTO xsi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aku ipainzi ne pâri-tamâta ŋato mine tu, “Naŋa kaloŋgu sukâŋa ŋalae tina, aku laiti ŋana iyaula naŋa ndo. Mine nde ara ŋana miki ma kamo ŋaina ku kaka mâsa kuku naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ŋineŋga ilâ tini ku ikeno nao tundu lâ tâno kulu, ku ino mine, “O Mama, ambo noko ilo tu kuveta mine, ande naŋa iloŋgu tu noko ma pwai kâmba ŋana nâna kâ ŋine saŋe naŋa. Ambo taitu noko ma kuveta ikura naneŋgu pateâŋa mine ndimo. Noko ma kuveta ikura noko tamwata nâ ne pateâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ŋineŋga Yesu itaulo ilâ panzi ne pâri-tamâta ŋato kilo, andeta sikeno. Aku ipaŋonzi ku ikasoŋa Petero tu, “Mana mana ŋga miki kakura tia ŋana kaka mâsa kuku naŋa ikura kari tai taitu nâ, a? ");
INSERT INTO xsi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ara ŋana miki ma kao tinimi, ku kano pa Maro Kindeni tu ma isukami ŋana kamandi kaika lâ zo ndia samâŋa imâ ipâŋga pami. Mao nâ, miki ilomi tu kaveta vetâŋa ara, aŋga karaemi nde iveta malia pami.” ");
INSERT INTO xsi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ŋineŋga Yesu ipilenzi ku itaulo kilo, ku ino mine; “O Mama, ambo kâmba ŋana nâna kâ ŋine ikura tu iŋgeŋge ŋanana tia, aku noko ilo tu ma anu, ande ara, kuveta ikura noko ne pateâŋa mine.” ");
INSERT INTO xsi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ikai noŋa ŋine lâ, ŋineŋga itaulo ilâ panzi ne pâri-tamâta kilo. Andeta imoranzi sikeno nâ simo, ŋana tu matanzi matutu pâta. ");
INSERT INTO xsi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mine kala Yesu ipilenzi ku itaulo kilo, aku ikai noŋa kilo. I ne noŋa ŋinde nde rege-rege kuku noŋa ikai muŋga ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ino lâ, ŋineŋga itaulo ilâ panzi ne pâri-tamâta, ku ipainzi tu, “Opopo, miki kakeno kamo ŋai yo kapwarea, a? Kaloŋo ŋga! Zo ŋga ipâŋga lâ, kala ŋine kinzi simâ ŋana sio naŋa Tamâta Natu lâ kinzi kiesaka tamwatanzi mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ayo, kamandi, ku toka talâ panzi. Kamora ŋga, tamâta ŋana ikai kulu-pâŋga ŋana naŋa kâ, ande kala imâ ipâŋga laiti lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu iporo ŋgua ŋine yo, ŋineŋga Judas, i nde toŋge lâ Yesu ne pâri-tamâta saŋao kanaŋonzi rua ŋinde, ande imâ ipâŋga lâ. Aku tamâta ŋgu ŋalae tina nde sikai pila ŋana kazâŋa kâ wa kâi mbuku wa soka kuku simâ. Kinzi patarawâŋa tamâta ŋalaŋala wa ŋgu nenzi katonâŋa muŋga sisupwanzi simâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ande kulu-pâŋga tamâta ŋinde muŋga ipainzi tu ma iveta mâsi toŋge pa Yesu. Ipainzi tu, “Naŋa ma anzumwa tamâta toŋge nao, aku tamâta ŋinde nde Yesuni. Miki kakai i kaika.” ");
INSERT INTO xsi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ŋineŋga walele nâ Judas iyoka imâ pa Yesu ku iporo tu, “Pananâŋa, mbo ara.” Aku inzumwa Yesu nao. ");
INSERT INTO xsi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu nde ipai Judas mine tu, “Niŋgu-nambwe, vetâŋa ndia kala noko kumâ tu kuveta, ande kuveta walele nâ.” Ŋineŋga kazâŋa tamâta pinde simâ, aku mbaunzi ilâ sikai Yesu kaika lâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Andeta Yesu ne pâri-tamâta toŋge mbau nâ ipasu ne pila yâti, ku ipu patarawâŋa tamâta ŋalae ne wurâta tamâta toŋge, aku pila isalu taŋa motu piti imbe ndue tâno kulu. ");
INSERT INTO xsi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Andeta Yesu ipai ne pâri-tamâta ŋinde tu, “Noko kulumbwa ne pila taulo kilo tâ! Ŋana tu tamâta ea kinzi uru sikai pila ŋana kazâŋa kâ, ande pila ma isowe kinzi warakanzi kapwanzi simâte. ");
INSERT INTO xsi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Opopo, noko kalo ŋgere sondo ŋga! Ambo naŋa ma asarâwa pa Mama, ande ikura tu isupwanzi aŋelo ŋgu ŋalae saŋao kanaŋonzi rua simâ ŋana sivila naŋa kâ. Tiambo noko kusama ŋine tia, a? ");
INSERT INTO xsi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Taitu kuloŋo ŋga; ambo naŋa ma aveta mine, ande Maro Kindeni ne ŋgua kinzi ŋgua-tulâŋa tamâta muŋgâŋa siŋgere lâ pepa tini ŋinde ma ipâŋga kanaŋo tia. Maro Kindeni ne pateâŋa ikeno tu vetâŋa rârâni ŋine ma ipâŋga pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ŋineŋga Yesu iporo panzi tamâta ŋgu ŋinde tu, “Ŋana sâ kâ ŋga miki kakai pila ŋalaŋala tava kâi mbuku kamâ ŋana kakai naŋa kâ, a? Tiambo miki katu naŋa nde panawe tamwatâŋgu, a? Ikura zo zo naŋa uru asaŋona Maro Kindeni ne luma sapâŋa ilo ku apanananzi tamâta, andeta miki ŋandai kakai naŋa kaika lâ zo ŋinde ŋga. ");
INSERT INTO xsi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Andeta vetâŋa rârâni ŋine ipâŋga lâ ŋana iveta ŋgua-tulâŋa tamâta muŋgâŋa nenzi ŋgua ipâŋga kanaŋo.” Yesu iporo ŋgua ŋine lâ, ŋineŋga kinzi pâri-tamâta rârâni nde sipile Yesu ku sikâwa silâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kinzi tamâta ŋinde sikai Yesu kaika lâ, ŋineŋga sikai silâ pa patarawâŋa tamâta ŋalae Kaiafas ne luma. Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ aŋga kinzi katonâŋa nde muŋga sipasau lâ kala simo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aŋga Petero nde iyoka Yesu muli ilâ, aku imo malawae mwasa. Iyoka ilâ patarawâŋa tamâta ŋalae ne luma ŋinde ne ŋgumbi ilo, aku isaŋona kunzi sambara tamâta. I ilo tu ma imora vetâŋa mana ma ipâŋga pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kinzi patarawâŋa tamâta ŋalaŋala aŋga kinzi tamâta mbâna-mbâna rârâni nde sisarawanzi tamâta pinde simâ tu ma situla nenzi ŋgua laŋeŋa ŋana Yesu ne vetâŋa kâ. Kinzi ilonzi tu ma sisânda vetâŋa soki ndia muŋga Yesu iveta tâ, ŋana sikura tu sipu i pâta imâte kâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mine kala kinzi tamâta rârâ nde simâ ku siporo sisowe ŋgua laŋeŋa lâ Yesu tini. Andeta kinzi ŋandai situla i ne vetâŋa soki toŋge pwataki ŋga. Siveta, siveta lee, ŋineŋga tamâta rua simâ, ");
INSERT INTO xsi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aku siporo mine tu, “Tamâta ŋine muŋga iporo tu, ‘Naŋa akura tu asapira Maro Kindeni ne luma sapâŋa piti, ŋineŋga aŋgunu kâki kilo lâ kari ŋato nâ.’” ");
INSERT INTO xsi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ŋineŋga patarawâŋa tamâta ŋalae imandi ku ipai Yesu tu, “Wa, noko tini pwâka tu kuporo ŋgua toŋge lâ kinzi kawanzi, a? Mana mana ŋana ŋgua ŋine kala kinzi sisowe lâ noko tini, a?” ");
INSERT INTO xsi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aŋga Yesu nde iporo ŋgua toŋge tia, kawa buu nâ imandi. Ŋineŋga patarawâŋa tamâta ŋalae ipai tu, “Lâ Maro Kindeni Via Tamwata ŋa, naŋa aporo kaika tu noko ma kuporo ŋgua mao nâ. Tiambo noko nde Kirisi, tiya? Tiambo noko nde Maro Kindeni Natu, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ŋineŋga Yesu itu lâ kawa tu, “Ŋguani kala noko tamwata kuporo lâ, ande mao nâ. Aku naŋa apaimi tu lâ zo muli, miki ma kamora naŋa Tamâta Natu asaŋona Maro Kindeni Walo Tamwata mbau pa wia kâ, aku ma kamora naŋa ayoka samba ne take-take kulu andue amâ.” ");
INSERT INTO xsi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Patarawâŋa tamâta ŋalae nde iloŋo Yesu ne ŋgua ŋine, aku marumbu; i wisi nâna ŋalae kala isaraka tamwata ne pasawaŋa lâ tini, ku iporo mine tu, “Oyae, tamâta ŋine itu ikai Maro Kindeni nia, aku ŋgua kala iporo ŋinde nde sakamao ndo lâ Maro Kindeni nao! Kinda ma tasarawanzi tamâta pinde kilo ŋana sisowe ŋgua lâ tamâta ŋine tini, ande tia. Kala ŋine nâ iporo ŋgua pavaligiŋa pa Maro Kindeni, aku miki kaloŋo lâ. ");
INSERT INTO xsi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Miki ilomi tu kinda ma taveta mana pa tamâta ŋine.” Kinzi nde situ lâ kawa mine, “Iveta soki ŋalae, ande kala ara ŋana ma sipu pâta imâte.” ");
INSERT INTO xsi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ŋineŋga kinzi sisupwara Yesu nao, ku siŋgu mbalaunzi sikatu. Aŋga pinde nde siponza, ");
INSERT INTO xsi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ku siporo tu, “Wa, noko nde Kirisi, a? Mine nde kuporo ŋgua-tulâŋa tamâta ne ŋgua, ku kutula pwataki tu ea ipuno! Kupatu tamâta ŋine ŋa tâ!” ");
INSERT INTO xsi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aŋga Petero nde isaŋona nia yo lâ luma ŋinde ne ŋgumbi ilo. Imo lee, ŋineŋga wurâta taine toŋge iyoka imâ papa ku ipai tu, “O, noko wa, noko kala muŋga kumo kuku Yesu Galilaya tamwata.” ");
INSERT INTO xsi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Andeta Petero iporo ipatiâmo lâ kinzi rârâni naonzi, ku iporo tu, “Naŋa asama ŋgua kala noko kuporo ŋinde duvi, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ŋineŋga Petero imandi ilâ pa luma ne nzâla kawa ikeno ŋgumbi tini. Aku wurâta taine toŋge kala imora i, ku ipainzi tamâta simandi laiti tu, “Tamâta ŋine nde muŋga imo kuku Yesu Nasarete Tamwata.” ");
INSERT INTO xsi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Andeta Petero ipatiâmo kilo ku iporo mine tu, “Mao pa âta, naŋa asama tamâta ŋinde tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Simo tini nâ, ŋineŋga tamâta pinde nde simâ ku sipai Petero tu, “Mao kanaŋo, noko nde toŋge lâ kinzi nawalanzi. Noko kawa kaŋa itula noko kilala pwataki lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ŋineŋga Petero iporo kaika tu, “Ambo naŋa alâŋe, ande naŋa ano pa Maro Kindeni tu ma izavaru naŋa; naŋa asama tamâta ŋinde tia ku tia ndo!” Aku walele nâ tatareko toŋge isuŋa kawa. ");
INSERT INTO xsi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ŋineŋga Petero ne kalo-ŋgere ipâŋga ŋana ŋgua Yesu muŋga iporo tu, “Tatareko ma ita isuŋa kawa tia yo, ande noko ma kuporo kupatimoa naŋa mbwani ŋato mine tu noko kusama naŋa tia.” Ŋineŋga Petero iyâti ilâ pa nia yo, aku ita pâta kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mbwale pwataki lâ, ŋineŋga kinzi patarawâŋa tamâta ŋalaŋala aŋga Isrel ŋgu nenzi katonâŋa nde siporo sipa ŋgua tu ma sio Yesu lâ Rom koipu mbaunzi ilo, tu ma sipu pâta imâte kâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mine kala sipa Yesu lâ wâlo kaika, ku sikai silâ sio i lâ Pilata mbau ilo, i tamâta ŋana ikai Rom ndamwanzi ku ikatonanzi tamâta rârâni simo nia ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, ina muŋga itula Yesu panzi kazâŋa tamâta, ande iloŋo pâri tu kinzi tamâta ŋalaŋala sipa ŋgua lâ ŋana ma sio Yesu ilâ panzi Rom koipu tu ma sipu pâta imâte kâ. Ŋineŋga Judas ilo ipâŋga malia ndo, ku ikai mbumbu tamâta taitu kanaŋo saŋao (30) ŋinde imâ, ku ilanzi patarawâŋa tamâta ŋalaŋala sitavanzi katonâŋa taulo kilo. ");
INSERT INTO xsi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aku ipainzi tu, “Naŋa aveta kiesaka, ŋana tu tamâta kala atula pami ŋinde, ande i ŋandai iveta soki toŋge ŋga. Andeta miki kapa ŋgua tu ma sipu i pâta imâte.” Ŋineŋga kinzi situ lâ i kawa tu, “Ŋine nde maka nema malia nde tia. Malia nde keno noko tamwata nâ tini.” ");
INSERT INTO xsi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ŋineŋga Judas isia mbumbu ŋinde ilâ Maro Kindeni ne luma sapâŋa ilo, aku ilâ ipa wâlo kaika lâ tamwata ŋandola, ku isoŋga indue ipayaula tamwata karae kala imâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aŋga kinzi patarawâŋa tamâta ŋalaŋala nde sikai mbumbu ŋinde ku siporo imâ warakanzi ŋgininzi tu, “Mbumbu ŋine nde koa ŋana tamâta puŋa kâ. Mine kala ŋgua tukuŋa indi kaika tu kinda ma tao mbumbu ŋine ilâ itogo luma sapâŋa ne mbaliŋa mine ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tia ku sipa ŋgua tu ma sikai mbumbu ŋinde ku siko tâno toŋge, i ŋa tu “Kulo-Puŋa Tamâta Nenzi Tâno”, aku tâno ŋinde ma ipâŋga itogo kuru nia mine panzi tamâta lombo muŋga soka lawea malawae malawae simo Isrel tâno. ");
INSERT INTO xsi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mine kala sipatu tâno ŋinde ŋa wasaseki tu “Tâno See”, aku ŋoa ŋine nde keno mineni lâ zo ŋine. ");
INSERT INTO xsi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mine kala ŋgua toŋge Maro Kindeni siŋgani io lâ ŋgua-tulâŋa tamâta Jeremaia kawa, ande ipâŋga kanaŋo. Ŋgua ŋine nde mine: “Kinzi Isrel ŋgu sipatea tu tamâta ma iko i lâ mbumbu tamâta taitu kanaŋo saŋao (30). Mine nde sikai mbumbu ndainani nâ, ");
INSERT INTO xsi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aku siko Kulo-Puŋa Tamâta Nenzi Tâno, ikura tukuŋa Maro Kindeni muŋga itula pa naŋa mine.” ");
INSERT INTO xsi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu nde imandi Rom nenzi koipu Pilata nao, aku Pilata ikasoŋa tu, “Noko nde Juda nenzi Koipu Ŋalae, tiya?” Ande Yesu itu lâ kawa tu, “Noko tamwata kuporo ŋguani ndaina.” ");
INSERT INTO xsi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ŋineŋga kinzi patarawâŋa tamâta ŋalaŋala sitavanzi kinzi katonâŋa nde sisowe ŋgua kie-kie lâ Yesu tini. Andeta iporo ŋgua toŋge taulo panzi, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mine kala Pilata ikasoŋa Yesu tu, “Tiambo ŋgua kala sisowe lâ noko tini ŋinde, ande kuloŋo tia tâ, a?” ");
INSERT INTO xsi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Andeta Yesu iporo ŋgua toŋge tia. Mine kala Pilata ilo rârâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aku Rom nenzi mâsi toŋge nde mine: ikura mbwera mbwera, lâ Juda nenzi kumbwa ŋinde, ande Pilata uru iyaute tamâta toŋge muŋga imo luma sakamao ilo iyâti ilâ, ikura kinzi Juda tamâta warakanzi nenzi pateâŋa mine. ");
INSERT INTO xsi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aku lâ zoni ndaina, ande nzanzare tamâta toŋge imo luma sakamao ilo, i ŋa mine Barabas. ");
INSERT INTO xsi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mine kala kinzi tamâta ŋgu ŋalae nde simâ sipasau lâ Pilata ne luma, ŋineŋga Pilata ikasoŋanzi tu, “Miki ilomi tu naŋa ma ayaute tamâta ea imâ pami. Naŋa ma ayaute Barabas, tiya?, ayaute Yesu, tamâta ŋine siporo tu i nde Kirisi.” ");
INSERT INTO xsi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilata nde isama tu kinzi tamâta ŋalaŋala sipadâda nâ ŋana Yesu kâ, aku ŋana duvi ŋinde kâ sikai i simâ papa. ");
INSERT INTO xsi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Andeta Pilata isaŋona ŋgua nia iporo ŋgua yo, ŋineŋga i kaiwa nde ipasupwa imâ papa mine tu, “Noko ma kuveta vetâŋa toŋge pa tamâta sondo ŋinde ndimo. Muŋga mbo, naŋa amora i nao lâ naneŋgu mbupuleŋa tini, aku ŋine iveta naŋa iloŋgu malia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ambo taitu kinzi patarawâŋa tamâta ŋalaŋala aŋga kinzi katonâŋa nde sisowe kinzi tamâta ilonzi, kala sisarâwa kaika pa Pilata tu ma iyaute Barabas imâ panzi, ku ma io Yesu tu ma sipu pâta imâte. ");
INSERT INTO xsi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ŋineŋga Pilata ikasoŋanzi kilo mine tu, “Miki ilomi tu naŋa ma ayaute ea lâ kinzi rua ŋine imâ pami.” Aku kinzi tamâta sisarâwa mine tu, “Kuyaute Barabas imâ!” ");
INSERT INTO xsi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ande Pilata ikasoŋanzi tu, “Mine ŋga ma naŋa aveta mana papa Yesu, tamâta ŋine siporo tu i nde Kirisi.” Ŋineŋga kinzi rârâni sisarâwa kaika tu, “Kupu lâ kâi popole tini imâte!” ");
INSERT INTO xsi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Andeta Pilata ikasoŋanzi tu, “Ŋana sâ kâ, a? Iveta vetâŋa soki ndia.” Andeta sisarâwa kaika ndo tu, “Kupu lâ kâi popole tini imâte!” ");
INSERT INTO xsi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilata isama tu i ikura ŋana itoto nenzi ŋgua, nde tia, aku kazâŋa ŋalae nde laiti ŋana ipâŋga kâ. Mine kala iveta mâsi toŋge lâ kinzi tamâta naonzi. Ikai lââ ku ipua tamwata mbau, ŋineŋga iporo tu, “Ambo tamâta ŋine imâte, ande ŋinde ma naneŋgu soki tia. Ŋinde ma miki warakami nâ nemi soki.” ");
INSERT INTO xsi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ŋineŋga kinzi tamâta siporo taulo papa tu, “Ara, soki ndia ŋana i ne mateŋa kâ nde ma ikeno pa maka warakama, aku ma ikeno panzi nema vâsa mine nâ!” ");
INSERT INTO xsi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Siporo ŋgua ŋine lâ, ŋineŋga Pilata iyaute Barabas imâ panzi. Aku io Yesu lâ zugu tamâta mbaunzi ilo tu ma sipalili pâta muŋga lâ, ŋineŋga ma sikai silâ sipu lâ kâi popole tini. ");
INSERT INTO xsi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ŋineŋga Pilata ne zugu tamâta nde sikai Yesu silâ Rom nenzi luma ŋana pasauŋa kâ ilo. Ŋineŋga sisarâwa panzi nawalanzi zugu tamâta rârâni tu ma simâ siŋge Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Simâ lâ, ŋineŋga mbaunzi ilâ sikai Yesu ne pasawaŋa piti lâ tini, aku sisawa pasawaŋa ŋiŋi toŋge lâ tini, itogo kinzi koipu ŋalaŋala uru sipasawa lâ tininzi mine. ");
INSERT INTO xsi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ŋineŋga simwali wâka-wâka toŋge ku sisawa lâ Yesu kulu, aku sio taumbwa tuka toŋge ilâ pa mbau wia kâ. Siveta mine lâ, ŋineŋga sipare tukunzi papa, aku siporo ŋgua pavaligiŋa papa mine tu, “Oe, Juda nenzi koipu ŋalae!” ");
INSERT INTO xsi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ŋineŋga sisupwara Yesu tini, aku sikai taumbwa tuka muŋga sio lâ i mbau ilo ŋinde, aku sipu i kulu mbwaninzi rârâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kinzi zugu tamâta siveta vetâŋa ŋinde ndoni sivaligi Yesu lee, ŋineŋga sisawa pasawaŋa ŋiŋi ŋinde piti lâ tini, aku sisawa tamwata ne pasawaŋa lâ tini kilo. Ŋineŋga sikai silâ ŋana sipu lâ kâi popole tini imâte. ");
INSERT INTO xsi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kinzi sipile Jerusalem lawea ku soka silâ, ŋineŋga sipakâtu kuku Sairini lawea warika toŋge, i ŋa mine Saimon. Aku kinzi zugu tamâta siveta kaika papa i tu ma ikale Yesu ne kâi popole ilâ kunzi. ");
INSERT INTO xsi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aku silâ lee sipâŋga nia ndamwa toŋge, i ŋa mine Golgata. Ŋoa ŋine nde duvi mine tu, “Kulu Kâmba Nia.” ");
INSERT INTO xsi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ŋineŋga kinzi zugu tamâta sigema waini tava lââ makisa pinde, aku silua Yesu tu inu kâ. Aku Yesu itogo nuŋa mwata nâ, andeta tini pwâka, kala inu tia. ");
INSERT INTO xsi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ŋineŋga kinzi zugu tamâta sipu Yesu lâ kâi popole tini. Aku sipagui mira itogo satu mine ŋana sisama tu ea ma ikai Yesu ne pasawaŋa. Siveta lâ, ŋineŋga siwae i ne pasawaŋa. ");
INSERT INTO xsi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ŋineŋga sisaŋona niani ndaina, aku sio tininzi ŋana Yesu tu ma imâte. ");
INSERT INTO xsi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aku lâ Yesu kulu âta, ande siŋgere ŋgua ŋinde muŋga sio i ilâ pa ŋgua nia ŋana. Siŋgere ŋgua mine tu, “Tamâta ŋine nde Yesu, ina Juda nenzi koipu ŋalae.” ");
INSERT INTO xsi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Aŋga lâ Yesu waŋgira, ande sisonanzi nzanzare tamwatanzi rua tona. Toŋge sipu lâ kâi popole toŋge tini papa Yesu tini pa wia kâ, aŋga toŋge nde sipu lâ kâi popole toŋge tini papa i tini pa ŋâsi kâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aku tamâta pinde soka nia ŋinde silâ wa simâ wa, sirurua kakalinzi papa ku siporo ŋgua pavaligiŋa mine tu, ");
INSERT INTO xsi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Oe, noko tamâta ŋana kusapira Maro Kindeni ne luma sapâŋa ku kuŋgunu kâki kilo lâ kari ŋato nâ, a? Mine nde kupavila tamwata tâ! Noko kutu Maro Kindeni Natu, ande ara, ŋine nâ kupile kâi popole ku kundue kumâ!” ");
INSERT INTO xsi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aku kinzi patarawâŋa tamâta ŋalaŋala aŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ aŋga Isrel nenzi katonâŋa, kinzi ŋinde rârâni kala siporo ŋgua pavaligiŋa mine nâ papa. ");
INSERT INTO xsi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Siporo tu, “Opopo, i muŋga ivilanzi tamâta pinde, andeta ikura ŋana ipavila tamwata kâ, ande tia. I nde Isrel nenzi koipu ŋalae, a? Mine nde mambo ŋine nâ ipile kâi popole ku indue imâ, ande kinda ma kalonda tawana i. ");
INSERT INTO xsi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mao nâ, i kalo tawana Maro Kindeni, kala uru iporo tu, ‘Naŋa nde Maro Kindeni Natu.’ Ara mbo, ambo Maro Kindeni ilo papa i, ande ara ŋana ŋaina nâ i tamwata ma imâ ivila i.” ");
INSERT INTO xsi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aku kinzi nzanzare tamwatanzi rua kala sitâra lâ kâi popole simo Yesu waŋgira ŋinde, ande kinzi kala siporo ŋgua pavaligiŋa kaŋa taituni nâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kari ikâki imâ ŋgini lâ, ŋineŋga kondoma ŋalae itura tâno ndoni. Ikeno mine lee lala lâ, ikura kari tai ŋato. ");
INSERT INTO xsi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aku kari tai ŋato lâ, ŋineŋga Yesu isuŋa kawa ŋalae kâki isarâwa mine tu, “Eli, Eli, lema sabatani!” Ŋgua ŋinde nde duvi mine, “Neŋgu Maro, neŋgu Maro, ŋana sâ kâ ŋga kupu muli pa naŋa!” ");
INSERT INTO xsi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aku tamâta pinde simandi tini laiti nde siloŋo Yesu ne ŋgua ŋinde, andeta siloŋo soki, ku siporo tu, “Ayo, isarâwa papa Ilia!” ");
INSERT INTO xsi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aku walele nâ nenzi toŋge ipalilu ilâ ikai nzomo toŋge, ku ipatuku lâ waini makisa ilo. Ŋineŋga iseŋge lâ lumbi-lumbi toŋge tini ku isuŋa kâki ilâ papa Yesu kawa tu ma indomo kâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ŋineŋga tamâta pinde siporo tu, “Ara, mambo tamora ŋga. Tiambo Ilia ma imâ ivila i, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Andeta Yesu nde isarâwa kawa ŋalae kilo, ŋineŋga imâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aku ndainani nâ lalava matatola ŋalae kala uru itâra Maro Kindeni ne luma sapâŋa ilo ŋinde nde ipwa pwataki pa âta ku indue papa lâmbu mo rua lâ. Aŋga ogigi ririŋo kala mira ŋalaŋala sipakâtu warakanzi. ");
INSERT INTO xsi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aku kuru rârâ kawanzi pareŋge lâ, aku Maro Kindeni ipaŋonzi ne pateâŋa tamâta rârâ, kinzi ŋinde muŋga simâte ku karaenzi ikeno kuru ilo, ande kala simandi sânda simo vianzi kilo, ");
INSERT INTO xsi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","aku sipile kuru siyâti simâ. Aku muli, lâ zo ŋinde Yesu imandi imo via kilo, ŋineŋga kinzi tamâta ŋinde nde silâ Jerusalem lawea ilo, aku tamâta rârâ simo lawea ŋinde nde simoranzi. ");
INSERT INTO xsi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aku kinzi zugu tamâta sitavanzi nenzi koipu, kinzi ŋinde muŋga sio tininzi pa Yesu tu imâte kâ, ande simora mâsi ŋinde rârâni. Simora ogigi ririŋo ku simora mâsi kie-kie ŋinde ipâŋga lâ, kala siruru pâta. Aku siporo mine tu, “Mao kanaŋo, tamâta ŋine nde Maro Kindeni Natu!” ");
INSERT INTO xsi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aku taine rârâ kala simo nia ŋinde tona, kinzini muŋga sipile Galilaya tâno ku soka kuku Yesu sikai kuleŋa papa. Kinzi taine ŋinde nde simandi malawae mwasa ku simora mâsi ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aku taine ŋato nde simo kunzi taine ŋgu ŋinde: toŋge nde Maria, i Makdala lawea taine; aŋga toŋge nde i nuwaka Maria, ina Yamesi ku Yosepe rua tinanzi; aŋga toŋge nde Sebedi natu rua tinanzi. ");
INSERT INTO xsi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kari indue lala lâ, ŋineŋga mbaliŋa warika toŋge lâ Arimatea lawea, i ŋa mine Yosepe, ande imâ ipâŋga Pilata ne luma. I muŋga ipono muli pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Imâ ipâŋga lâ, ŋineŋga ino Pilata tu ma ikai Yesu karae, ŋana ma ilâ ikea kâ. Pilata nde isâu papa ku ipainzi ne zugu tamâta tu Yesu karae ma silua Yosepe. ");
INSERT INTO xsi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ŋineŋga Yosepe ikai lalava pâne toŋge ku ilita lâ Yesu karae. ");
INSERT INTO xsi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ilita lâ, ŋineŋga ikai Yesu karae ilâ ku io lâ i tamwata ne kuru wasaseki ilo. Kinzi muŋga siveta kuru ŋinde lâ nia mira. Ŋineŋga Yosepe itambumbua mira ŋalae toŋge ilâ ipono kuru ŋinde kawa. Iveta mine lâ, aku ilâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aŋga Maria, i Makdala taine ŋinde, kuku nuwaka Maria rua nde sisaŋona kuru ŋinde nao kala simo. ");
INSERT INTO xsi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesu nde imâte lâ wurâta lima, lâ zo ŋinde kinzi Juda tamâta uru siveta kelekele sondo ŋana pwareâŋa ne zo sapâŋa kâ lâ wurita. Aku mbwale kilo, ŋineŋga kinzi patarawâŋa tamâta ŋalaŋala sitavanzi tamâta pinde lâ Parisai ŋgu nde silâ ŋana siporo ŋgua pa Pilata kâ. ");
INSERT INTO xsi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sipasau kuku Pilata lâ, ŋineŋga sipai mine tu, “Tamâta Ŋalae, maka iloma ikai ŋgua toŋge muŋga laŋeŋa tamwata ŋinde imo via yo mbo iporo ŋine. Iporo mine tu, ‘Kari ŋato lâ, ŋineŋga naŋa ma amandi amo viâŋgu kilo.’ ");
INSERT INTO xsi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mine nde maka kano pano tu kuonzi ne zugu tamâta tu sika mâsa ku simandi lâ kuru ŋinde kawa tini laiti ikura kari ŋato marumbu lâ. Tia ma ne pâri-tamâta simâ sipanawe i karae silâ tâ, aku ma sipainzi tamâta mine tu, ‘Imandi lâ mateŋa nianzi imo via kilo!’ Ambo siveta mine, ande ŋgua laŋeŋa wasaseki ŋinde nde ma ipole ŋgua laŋeŋa muŋga iporo ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ŋineŋga Pilata ipainzi tu, “Ara, miki kakainzi zugu tamâta pinde ku kalâ kaveta kuru sondo, ŋana tamâta toŋge ma ikura tu ipanawe i karae, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ŋineŋga kinzi silâ ku siveta mâsi toŋge lâ kuru ne kawa mira tini, ŋana itula tu tuŋa kaika keno ŋana kuru ŋinde kâ. Aku sionzi zugu tamâta tu simandi lâ kuru ŋinde kawa tini laiti tona. ");
INSERT INTO xsi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juda nenzi pwareâŋa ne zo sapâŋa marumbu lâ ŋga. Aku wurita kilo, lâ sânda, mbwale pwataki lâ, ŋineŋga Maria, i Makdala taine, nde ikai nuwaka Maria, aku rua silâ ŋana simora Yesu ne kuru kâ. ");
INSERT INTO xsi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Andeta walele nâ ogigi ririŋo ŋalae tina, ŋana tu Maro Ŋalae ne aŋelo toŋge iyoka pa samba indue imâ pa kuru ŋinde, ku itambumbua mira piti lâ kuru kawa. Itambumbua piti lâ, ŋineŋga isaŋona mira ŋinde kulu. ");
INSERT INTO xsi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aŋelo ŋinde tini nde sinala nia itogo loloa salaga mine, aŋga ne pasawaŋa nde pâne ndo. ");
INSERT INTO xsi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aku kinzi zugu tamâta kala sikatona kuru ŋinde nde simora aŋelo ŋinde, ku siruru pâta kanaŋo. Tininzi ruru, aku patanzi sindue sikeno tâno kulu, sitogonzi mateŋa tamâta mine. ");
INSERT INTO xsi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ŋineŋga aŋelo nde ipainzi taine rua tu, “Miki rua karuru ndimo. Naŋa asama tu miki kamâ tu kamora Yesu, ina muŋga itâra lâ kâi popole tini ku imâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Taitu i nde imo ŋai tia; imandi sânda lâ kala imo via kilo, ikura ŋgua muŋga iporo ŋinde. Miki rua kamâ kamora nia kala muŋga sio karae ndue ikeno ŋine. ");
INSERT INTO xsi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ayo, miki walele nâ kalâ kapainzi ne pâri-tamâta mine tu, ‘Imandi lâ mateŋa nianzi imo via kilo, kala imuŋga pami ilâ Galilaya tâno. Miki kalâ ma kasânda i kulu lâ niani ndaina.’ Naŋa amâ ŋana atula ŋgua ŋine pami, kala atula pami lâ.” ");
INSERT INTO xsi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aŋelo iporo ŋgua ŋine panzi taine rua marumbu lâ, ŋineŋga walele nâ kinzi rua sipile kuru nia ku sipalilu silâ tu siporo ŋgua ŋinde panzi Yesu ne pâri-tamâta. Tininzi ruru, andeta ilonzi ndeka pâta lâ. ");
INSERT INTO xsi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Soka nzâla sipalilu silâ yo, ŋineŋga walele nâ Yesu tamwata ipakâtu kunzi ku iporo tu, “Maro Kindeni ne nzâmbe imâ pami.” Ŋineŋga kinzi rua sipare tukunzi papa aku mbaunzi ilâ sikale Yesu kie kaika, aku sipanea i. ");
INSERT INTO xsi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ŋineŋga Yesu ipainzi tu, “Miki karuru ndimo. Kalâ kaporo panzi niŋgu-nambwe tu mambo silâ Galilaya tâno, ande ma simora naŋa lâ nia ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Taine rua ŋinde nde silâ yo, ŋineŋga kinzi zugu tamâta pinde muŋga simandi Yesu ne kuru kawa laiti ŋinde, ande silâ Jerusalem lawea ilo ku sitapâri panzi patarawâŋa tamâta ŋalaŋala ŋana vetâŋa rârâni muŋga ipâŋga panzi ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ŋineŋga kinzi patarawâŋa tamâta ŋalaŋala sipasau kunzi Isrel ŋgu nenzi katonâŋa, aku sipa ŋgua tu ma mbumbu ŋalae tina silanzi zugu tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mbumbu silanzi lâ, ŋineŋga sipainzi tu, “Miki ma kaporo ŋgua mine: ‘Lâ mbo, maka kakeno utu lâ, ŋineŋga Yesu ne pâri-tamâta sipavea nâ simâ ku sikawea i karae silâ lâ.’ ");
INSERT INTO xsi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ambo Rom nemi koipu ŋalae iloŋo ŋgua ŋine, ande maka ma kaveta ŋgua sondo kuku i, ande kala miki ma kasânda malia toŋge kulu, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mine kala kinzi zugu tamâta sikai mbumbu ŋinde aku silâ siveta ikura Juda tamâta ŋalaŋala nenzi ŋgua mine. Aku tapâriŋa laŋeŋa ŋine nde ilâ isala nia lâ, kala lâ zo ŋine kinzi Juda tamâta pinde uru sitapâri tapâriŋa ndainani nâ. ");
INSERT INTO xsi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aku muli, ŋineŋga Yesu ne pâri-tamâta saŋao kanaŋo taitu nde soka silâ pa Galilaya tâno. Soka lee sipâŋga tuu ŋinde Yesu muŋga ipainzi tu ma silâ papa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aku matanzi ilâ simora Yesu, ŋineŋga sipare tukunzi papa ku sipanea i. Aŋga kinzi pinde nde ilonzi rua-rua. ");
INSERT INTO xsi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ŋineŋga Yesu imâ tininzi laiti, aku ipainzi tu, “Maro Kindeni walo ndoni ilua naŋa lâ, kala naŋa akai Maro pa kelekele rârâni lâ samba ilo wa tâno kulu wa. ");
INSERT INTO xsi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mine kala miki kalâ kakura nia nia, aku katu pâri ara panzi tamâta simo tâno ndoni, ŋana kinzi ma kalonzi tawana naŋa kâ. Kalilinzi lâ Tama ŋa, aŋga Natu ŋa, aŋga Koroani Sapâŋa ŋa. ");
INSERT INTO xsi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aku kapanananzi ŋana sipaveta kuku ŋgua rârâni naŋa muŋga atula pami ŋinde. Mao kanaŋo, naŋa ma amo kumi ikura zo rârâni lee, tâno ŋine ne zo marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ŋine nde pâri ara ŋana Maro Kindeni natu Yesu Kirisi kâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Muŋgani, ŋgua-tulâŋa tamâta Aisaia ikai ŋgua muŋga Maro Kindeni iporo pa Kirisi, ku iŋgere lâ pepa tini mine tu, “Kuloŋo ŋga; naŋa ma asupwa naneŋgu kuleŋa tamâta toŋge ikai naŋa kawâŋgu ŋgua imuŋga pano. I ma iveta noko nzalani sondo.” ");
INSERT INTO xsi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Lâ nia bilimu, sarawâŋa toŋge iyoka lâ tamâta toŋge kawa imâ mine tu, ‘Kaveta nzâla sondo ŋana Maro Ŋalae ma imâ kâ’.” ");
INSERT INTO xsi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mine kala Yoane Lââ-Liliŋa Tamwata ipâŋga nia bilimu, aku itula ŋgua panzi tamâta tu ma sipalele ilonzi kalonzi ku silili pâri ara ne lââ, aku Maro Kindeni ma izavaru nenzi kiesaka piti lâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aku kinzi tamâta ŋgu ŋalae nde soka pa Judia tâno wa Jerusalem lawea wa simâ pa Yoane. Kinzi sipatula nenzi kiesaka papa, kala Yoane ililinzi lâ Jodan Lââ. ");
INSERT INTO xsi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoane nde uru isawa pasawaŋa muŋga sisuta lâ ŋgoa “kamel” karae, ku ipu ŋgoa karae lâ kambwaŋe. Aku i uru ika ndemu-ndemu tava sipa siŋi itogo kâ kaniŋa mwasina. ");
INSERT INTO xsi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aku i uru itula ŋgua mine tu, “Tamâta toŋge iyoka naŋa muliŋgu mwaŋga imâ, aku i ne walo nde ipole naneŋgu walo. Naŋa nde tamâta kaa nâ; mine kala naŋa akura tu atundu lâ i kie tini ku ayaute i kie kâmba ne wâlo piti, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naŋa alili miki lâ lââ nâ, aŋga i nde ma ililimi lâ Koroani Sapâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa zo ŋinde, Yesu ipile Nasarete lawea lâ Galilaya tâno ku iyoka imâ pa Yoane, aku Yoane ilili i lâ Jodan Lââ. ");
INSERT INTO xsi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu ipile lââ ku ikâki imâ pa pâŋga pwali, ŋineŋga mata kâki imora samba ipwa pwataki ku Koroani Sapâŋa itogo bâlu mine indue imâ papa. ");
INSERT INTO xsi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aku sarawâŋa toŋge iyoka pa samba imâ mine tu, “Naŋa natuŋgu ara kala noko. Naŋa iloŋgu ndo keno pano wa iloŋgu ndeka pano wa.” ");
INSERT INTO xsi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aku lâ zoni ndaina Koroani Sapâŋa ikai Yesu io i lâ nia bilimu toŋge. ");
INSERT INTO xsi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aku imo nia bilimu ŋinde ikura kari tamâta rua lâ, aku pa zo ŋinde Sadana imâ tu ikai samâŋa papa. Yesu nde imo nia ŋinde kunzi ŋgoa ŋgoi, ku kinzi aŋelo sikatona i. ");
INSERT INTO xsi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kinzi kazâŋa tamâta sio Yoane Lââ-Liliŋa Tamwata imo luma sakamao ilo lâ, aku pa zoni ndaina Yesu iyoka ilâ pa Galilaya tâno, ku itula Maro Kindeni ne pâri ara panzi. ");
INSERT INTO xsi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aku iporo tu, “Zo ŋga ipâŋga lâ. Maro Kindeni ne zo ŋana ikai maro panzi tamâta kâ ŋga imâ ipâŋga laiti lâ. Mine nde miki kapalele ilomi kalomi ku kalomi tawana pâri ara.” ");
INSERT INTO xsi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu imo tâno ŋinde ku iyoka Galilaya lââ bwalika pwali, ande mata ilâ imoranzi Saimon ku tai Andaria rua. Kinzi rua sitambira viâŋa lâ lââ bwalika ilo, ŋana tu rua uru sikai iŋa ŋana nenzi mbaliŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aku Yesu ipainzi rua mine tu, “Miki rua kamâ kapono muli pa naŋa, aku ma apananami ŋana kakainzi tamâta kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aku walele nâ kinzi rua sipile nenzi viâŋa ku soka i muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aku Yesu iyoka ilâ, ŋineŋga imora Yamesi, i Sebedi natu, tava tai Yoane. Kinzi rua kala sisaŋona wâŋga kulu siveta nenzi viâŋa sondo. ");
INSERT INTO xsi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aku Yesu walele nâ isarawanzi rua, kala sipile tamanzi Sebedi imo wâŋga kulu tavanzi ne wurâta tamâta, aku kinzi rua soka Yesu muli silâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ikainzi ne pâri-tamâta ku soka silâ sipâŋga Kaperneam lawea, ŋineŋga Juda nenzi pwareâŋa ne zo sapâŋa ipâŋga lâ. Mine kala Yesu ilâ ipanananzi tamâta lâ luma ŋana pasauŋa kâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kinzi siloŋo i ne ŋgua ku wisinzi motutu lâ, ŋana tu i ŋandai ipanananzi itogo kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru siveta mine ŋga; ipanananzi itogo i tamwata ikai Maro Kindeni ndamwa kala iporo. ");
INSERT INTO xsi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lâ zoni ndaina tamâta toŋge imo luma ŋana pasauŋa kâ ilo kunzi, i muŋga koroani saka ipagagara lâ. Aku isarâwa mine tu, ");
INSERT INTO xsi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasarete tamwata, noko kumâ ŋine tu kuveta mana pa maka, a? Tiambo noko kumâ ŋine tu kuzavaruma, tiya? Naŋa asama noko kilala tu noko nde Maro Kindeni ne Tamâta Sapâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Andeta Yesu imbita ku ipai tu, “Noko kawa buu nâ, ku kupile tamâta ŋine pwâwa kulâ!” ");
INSERT INTO xsi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ŋineŋga koroani saka irurua tamâta ŋinde tini, aku itara kawa kâki ŋalae tina ŋinde, ku ipile i ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aku kinzi tamâta rârâni nde wisinzi motutu, ku sipakasoŋa warakanzi tu, “Ŋine nde vetâŋa mana. Ŋine nde ŋgua wasaseki ndo! Opopo, tamâta ŋine nde tamâta kaika, kala imbitanzi koroani saka ku sipono muli pa i kawa ŋgua!” ");
INSERT INTO xsi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mine kala Yesu parina ilâ walele nâ isala Galilaya tâno ndoni. ");
INSERT INTO xsi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kinzi sipile luma ŋana pasauŋa kâ ku siyâti silâ pa nia yo, aku silâ Saimon ku tai Andaria rua nenzi luma ilo. Aŋga Yamesi ku Yoane rua kala soka kunzi silâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Andeta Saimon ana taine ikeno ne kenoŋa nia, ikai pukoŋa ndamwa nâna. Aku walele nâ kinzi sitapâri papa Yesu ŋana i kâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ŋineŋga Yesu ilâ pa taine ŋinde, ikai i mbau ku igagati imandi sânda. Aku pukoŋa ipile taine ŋinde, kala i tini ara kilo, kala ilâ isu kâpwa panzi. ");
INSERT INTO xsi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Simo lee ku lala, kari indue kudu lâ, ŋineŋga kinzi tamâta sikainzi pukoŋa tamâta simâ pa Yesu, sitavanzi tamâta pinde koroani saka sipagagaranzi lâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aku tamâta rârâni simo lawea ŋinde nde sipasau lâ luma ŋinde ne nzâla kawa tini marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kinzi tamâta ŋinde nde sikai pukoŋa kie-kie, andeta Yesu ivetanzi tininzi mbalaunzi ara kilo, ku isokinzi koroani saka rârâ piti lâ ilonzi wa. Andeta kinzi koroani saka sisama i kilala, kala itu kaika panzi tu ma kawanzi buu nâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lâ mboyo ŋaŋa yo, ande Yesu imandi iyâti pa nia yo ku ilâ nia ŋgaŋe toŋge, aku ino pa Maro Kindeni imo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aŋga Saimon tavanzi ninambwe nde siroto ŋana i simâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kinzi siroto lee sisânda kulu lâ, ŋineŋga sipai tu, “Wa, kinzi tamâta rârâni nde siroto ŋanano.” ");
INSERT INTO xsi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Andeta Yesu iporo taulo panzi tu, “Kinda ma tamo lawea ŋine nâ tia. Ayo, toka talâ pa lawea pinde keno laiti ŋai, ŋana tu naŋa atu atula Maro Kindeni kawa ŋgua pa kinzi wa. Naŋa amâ ŋana aveta mine kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aku iyoka ikura Galilaya tâno ndoni itula ŋgua panzi lâ nenzi luma ŋana pasauŋa kâ ndoni ilo, ku isokinzi koroani saka piti lâ tamâta ilonzi tava. ");
INSERT INTO xsi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aku tamâta toŋge tini saga-saga nde imâ pa Yesu ku ita papa. Tamâta ŋinde ipare tuku itundu lâ Yesu kie tini ku iporo tu, “Ambo noko ilo tu kuveta mine, ande noko pwura ŋana kuveta naŋa tiniŋgu ipâŋga mbâra-mbâra.” ");
INSERT INTO xsi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aku Yesu kalo sukâŋa ŋana kala isuŋa mbau ilâ itaŋo tamâta ŋinde tini ku ipai tu, “Naŋa iloŋgu tu aveta mine; kala ŋine nâ noko kupâŋga mbâra-mbâra!” ");
INSERT INTO xsi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aku ndainani nâ pukoŋa saga-saga ŋinde marumbu lâ, kala ipâŋga tini mbâra-mbâra lâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ŋineŋga Yesu itu ŋgua kaika papa, ku walele nâ io i ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Aku Yesu ipai tu, “Noko kuloŋo sondo ŋga; noko ma kutapâri pa tamâta toŋge ŋana vetâŋa kala ipâŋga pano ŋine ndimo. Kulâ kupatula tini pa patarawâŋa tamâta, aku kuveta patarawâŋa ŋana tini mbâra-mbâra kâ, ikura Mose ne ŋgua tukuŋa itula mine. Ambo noko ma kuveta mine, ande kinzi tamâta ma sisama tu noko ne pukoŋa nde marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Andeta tamâta ŋinde ilâ ku itula vetâŋa rârâni ŋinde pwataki, kala tapâriŋa ŋinde nde ilâ ikura nia pinde lâ. Mine kala Yesu ikura tu ilâ ipâŋga tamâta naonzi lâ lawea toŋge ilo, ande tia. I imo nia ŋgaŋe nâ, andeta kinzi tamâta sipile nenzi lawea rârâni ku simâ papa i. ");
INSERT INTO xsi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Zo pinde ilâ lâ, ŋineŋga Yesu ilâ pa Kaperneam lawea kilo. Aku kinzi tamâta siloŋo ŋgua tu i imo luma ilo. ");
INSERT INTO xsi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Mine kala tamâta rârâ sipasau lâ luma ŋinde, kala nia maa toŋge ikeno lâ nzâla kawa, ande tia. Aku Yesu imo itula Maro Kindeni ne ŋgua panzi. ");
INSERT INTO xsi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ŋineŋga tamâta pinde sikai pukoŋa tamâta toŋge simâ papa. Tamâta ŋinde kie-mbalau ndoni imâte lâ. Aku tamâta ŋapa sindawe pukoŋa tamâta ŋinde sikai simâ. ");
INSERT INTO xsi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Andeta kinzi tamâta nde sipasâe ndo lâ, kala sikura tu sikai pukoŋa tamâta ŋinde simâ Yesu tini laiti, ande tia. Tia ku sikai sikâki luma Yesu imo ŋinde kulu, ku sitikia luma ne mende toŋge piti. Sitikia mende toŋge piti lâ, ŋineŋga sitiu pukoŋa tamâta ikeno rombe-rombe kulu ŋinde indue Yesu nao. ");
INSERT INTO xsi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aku Yesu isama kinzi tamâta ŋinde kilalanzi pwataki tu nenzi kalo-tawana ikeno pa i. Mine kala ipai pukoŋa tamâta ŋinde tu, “Natuŋgu, naŋa azavaru noko ne kiesaka piti lâ tini.” ");
INSERT INTO xsi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Aŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde nde simo ŋinde, ku ilonzi kalonzi iporo mine tu, ");
INSERT INTO xsi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wa, ŋana sâ kâ ŋga tamâta ŋine iporo mine, a? Itu ikai Maro Kindeni nia kala iporo ŋgua ara tia ndo lâ Maro Kindeni nao! Noko tamâta toŋge pwura ŋana kuzavaru kiesaka piti lâ tamâta tininzi tia ndo! Maro Kindeni simbo nâ ikura tu iveta mine.” ");
INSERT INTO xsi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu ipasama lâ tamwata ilo kalo tu nenzi ilo-kalo mine nde keno panzi. Mine kala walele nâ ipainzi tu, “Ŋana sâ kâ ŋga miki nemi ilo-kalo mine keno pami, a? ");
INSERT INTO xsi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mao nâ, naŋa akura tu apai pukoŋa tamâta ŋine mine tu, ‘Naŋa azavaru noko ne kiesaka piti lâ tini’. Aku mine nâ, naŋa akura apai tu, ‘Noko kumandi sânda, ku pwai ne rombe-rombe pwoka kulâ’. Ayo, ŋgua ndia ma itula naneŋgu walo pwataki pami, a? ");
INSERT INTO xsi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Andeta naŋa iloŋgu tu miki ma kasama ŋine: naŋa Tamâta Natu akai Maro Kindeni ndamwa lâ tâno ŋine kulu, ikura ŋana azavaru kiesaka piti lâ tamâta tininzi.” Yesu iporo ŋgua ŋine panzi lâ, ŋineŋga ipai pukoŋa tamâta ŋinde tu, ");
INSERT INTO xsi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Naŋa apaino tu kumandi sânda, pwai ne rombe-rombe, ku pwoka kulâ pa tamwata ne luma!” ");
INSERT INTO xsi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aku ndainani nâ tamâta ŋinde imandi ku walele nâ ikai ne rombe-rombe kâki ku iyoka tamâta naonzi ilâ. Mine kala kinzi tamâta rârâni wisinzi motutu lâ, aku sipanea Maro Kindeni ŋa siporo tu, “Muŋga kinda tamora mâsi toŋge irerege kuku mâsi ŋinde, ande tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ŋineŋga Yesu ipile nia ŋinde ku ilâ, aku ilâ pa sâwa lâ lââ bwalika pwali. Aku tamâta ŋgu ŋalae nde simâ papa, ku itula Maro Kindeni kawa ŋgua panzi ipanananzi. ");
INSERT INTO xsi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aku iyoka ilâ, ande mata ilâ imora Livai, i Alfius natu, iveta wurâta lâ Rom nenzi luma ŋana mbumbu kaiŋa kâ isaŋona ŋinde. Aku Yesu ipai tu, “Noko kumâ, kupono muli pa naŋa.” Aku imandi iyoka i muli ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aku muli, zo toŋge, ŋineŋga Yesu ilâ Livai ne luma ilo ku isaŋona ika kâpwa kuku. Aku kinzi mbumbu-kaiŋa tamwatanzi ŋgu ŋalae, sitavanzi kiesaka tamwatanzi pinde, nde sisaŋona sika kunzi Yesu ŋga ne pâri-tamâta, ŋana tu kinzi tamâta mine rârâ uru soka kuku Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde, kinzi lâ Parisai ŋgu, ande simora tu Yesu ika kunzi kiesaka tamwatanzi wa kinzi mbumbu-kaiŋa tamâta sakamao wa. Mine kala sipainzi Yesu ne pâri-tamâta tu, “Wa, ŋana sâ kâ ŋga i ika kunzi tamâta sakamao ŋana mbumbu kaiŋa kâ wa kinzi kiesaka tamwatanzi wa, a?” ");
INSERT INTO xsi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Andeta Yesu iloŋo ŋgua ŋine, ku ipainzi tu, “Kinzi tamâta tininzi ara uru silâ pa tamâta ŋana ivetanzi pukoŋa kâ, ande tia. Kinzi pukoŋa tamâta nâ uru silâ pa tamâta ŋana ivetanzi pukoŋa kâ. Naŋa ŋandai amâ tâno kulu ŋana asarawanzi kinzi vetâŋa ara warakanzi ŋga. Naŋa amâ ŋana asarawanzi kinzi kiesaka tamwatanzi.” ");
INSERT INTO xsi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yoane Lââ-Liliŋa Tamwata ne pâri-tamâta aŋga kinzi Parisai tamâta nde zo pinde uru situ kaika ŋana kâpwa kâ, ŋana ma sikai noŋa kâ. Mine nde kinzi tamâta pinde simâ sikasoŋa Yesu tu, “Yoane Lââ-Liliŋa Tamwata ne pâri-tamâta aŋga kinzi Parisai nenzi pâri-tamâta uru situ kaika ŋana kâpwa kâ. Mine nde ŋana sâ kâ ŋga noko ne pâri-tamâta ŋandai siveta mine ŋga, a?” ");
INSERT INTO xsi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aku Yesu isia ŋgua lâ tamwata tini ku ipainzi tu, “Ambo tamâta toŋge itu ikâe, ande i ninambwe kinzi ma situ kaika ŋana kâpwa kâ lâ zo ŋinde i imo kunzi, ande ma tia. Ŋana tu pakâeŋa tamwata imo kunzi yo, kala kinzi ma situ kaika ŋana kâpwa kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Taitu muli, lâ zo ŋinde kinzi tamâta pinde ma sikai pakâeŋa tamâta ŋinde piti lâ ninambwe ŋgininzi, ŋineŋga lâ zoni ndaina kinzi ma kalonzi sukâŋa ku ma situ kaika ŋana kâpwa kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ŋineŋga Yesu iporo tu, “Kinzi tamâta uru sisaraka lalava wasaseki katiŋe ku sisuta ipono pasawaŋa siŋga râge-râge, ande tia. Ambo siveta mine, ande lalava ŋana ipono pasawaŋa râge-râge ŋinde ma ipasaŋgu ku ma isaraka pasawaŋa kilo, kala ma râge-râge ipwa ŋalae kilo. ");
INSERT INTO xsi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aŋga kinzi tamâta uru siwuwu waini waseki lâ ŋgoa karae patu siŋga ilo, ande tia. Ambo siveta mine, ande waini ma ipondi kâki ku iveta ŋgoa karae patu siŋga ipwa pwataki. Ŋineŋga waini ma imaliŋi kaa nâ lâ tâno kulu, aku ŋgoa karae patu kala ma ipâŋga sakamao tava. Mine kala kinzi tamâta uru siwuwu waini waseki lâ ŋgoa karae patu wasaseki nâ ilo.” ");
INSERT INTO xsi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zo toŋge, lâ Juda nenzi pwareâŋa ne zo sapâŋa toŋge, Yesu tavanzi ne pâri-tamâta nde soka silâ sipâŋga kâpwa ‘wit’ ne tâno ŋgini. Aku ne pâri-tamâta sisiki ‘wit’ kanaŋo pinde sika. ");
INSERT INTO xsi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Andeta kinzi Parisai tamâta sipai Yesu tu, “Wa! Ŋgua tukuŋa ikeno tu kinda ma taveta wurâta toŋge lâ zo sapâŋa ndimo. Mine nde ŋana sâ kâ ŋga kinzi sipu ŋgua tukuŋa utu, a?” ");
INSERT INTO xsi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Andeta Yesu iporo ŋgua taulo panzi tu, “Tiambo miki ŋandai kapono ŋgua ŋana vetâŋa ŋinde timbunda Daviti iveta, lâ zo ŋinde putole ipu i tavanzi ne tamâta, a? ");
INSERT INTO xsi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lâ zo ŋinde Abaiata imo patarawâŋa tamâta nenzi tamâta ŋalae, aku Daviti ilâ Maro Kindeni ne luma ilo ku mbau ilâ ikai puroŋa ŋinde kinzi patarawâŋa tamâta muŋga sipatarâwa pa Maro Kindeni. Patarawâŋa tamâta ŋalae puroŋa ŋinde ilua Daviti, ŋineŋga Daviti ika kunzi ne tamâta. Andeta ŋgua tukuŋa ikeno tu kinzi patarawâŋa tamâta simbonzi nâ ma sika puroŋa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ŋineŋga Yesu ipainzi tu, “Maro Kindeni ŋandai ionzi tamâta ŋana sisuka pwareâŋa ne zo sapâŋa ŋga. Io pwareâŋa ne zo sapâŋa ŋana ma isukanzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mine nde naŋa Tamâta Natu akai maro pa pwareâŋa ne zo sapâŋa tava.” ");
INSERT INTO xsi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Zo toŋge Yesu ilâ luma ŋana pasauŋa kâ ilo. Aku tamâta toŋge imo ndaina, i mbalau toŋge panzukuma lâ. ");
INSERT INTO xsi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aŋga kinzi tamâta pinde sio ŋana Yesu kâ. Kinzi situ sisama mine; tiambo i ma iveta tamâta ŋinde tini ara kilo lâ pwareâŋa ne zo sapâŋa, tiya? Kinzi situ ma sio Yesu lâ ŋgua nia ŋana ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aku Yesu ipai tamâta mbalau sakamao ŋinde tu, “Noko kumâ kumandi ŋai.” ");
INSERT INTO xsi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ŋineŋga ikasoŋanzi tu, “Mose ne ŋgua tukuŋa isâu pa kinda tu ma taveta vetâŋa ara lâ pwareâŋa ne zo sapâŋa, tiya?, taveta vetâŋa sakamao. Aku ŋgua tukuŋa isâu pa kinda tu ma tavilanzi tamâta lâ zo sapâŋa tu simo ara, tiya?, tayaulanzi.” Taitu kinzi siporo tia, kawanzi buu nâ. ");
INSERT INTO xsi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aku i mata kikimbwaki ilea panzi ku wisi nâna. Imora tu kinzi taŋanzi kaika ndo, kala i ilo malia ŋana ŋinde kâ. Ŋineŋga ipai tamâta ŋinde tu, “Kusowea mbalau.” Isowea mbalau lâ, aku mbalau ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aku ndainani nâ kinzi Parisai tamâta simandi silâ, aku sipasau kunzi Herot ne tamâta. Kinzi silâ taitu sipa ŋgua tu ma siroto nzâla ŋana sipu Yesu pâta imâte. ");
INSERT INTO xsi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ŋineŋga Yesu ikainzi ne pâri-tamâta ku sipile lawea ŋinde silâ pa lââ bwalika. Aku tamâta ŋgu ŋalae nde soka kuku i. Kinzi ŋinde nde papa Galilaya tâno, ");
INSERT INTO xsi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aŋga Judia tâno, aŋga Jerusalem lawea, aŋga Idumea tâno, aŋga Jodan lââ tini pinde, aŋga Tair lawea wa Saidon lawea wa. Kinzi ŋgu ŋalae tina nde siloŋo pâri ŋana mâsi kie-kie Yesu iveta ŋinde, kala simâ papa. ");
INSERT INTO xsi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesu muŋga ivetanzi pukoŋa tamâta rârâ tininzi mbalaunzi ara kilo. Mine kala kinzi pukoŋa tamâta rârâ simâ siŋge i lâ. Kinzi situ ma sio mbalaunzi ilâ sitaŋo i. Mine kala Yesu ipainzi ne pâri-tamâta tu, “Tamâta ŋgu ŋalae simo ŋai kala sipono naoŋgu. Mine nde kao wâŋga toŋge yâti tu ma nakâki kulu.” ");
INSERT INTO xsi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aŋga kinzi koroani saka simora i kilala pwataki, kala situndu lâ Yesu nao sisarâwa mine tu, “Noko nde Maro Kindeni Natu!” ");
INSERT INTO xsi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Andeta iporo kaika indi panzi tu ma situla i parina mine ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ŋineŋga Yesu ikâki tuu kulu, ku isarawanzi tamâta pinde i ilo panzi ŋinde tu ma simâ papa. ");
INSERT INTO xsi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Simâ lâ, ŋineŋga ipateanzi tamâta saŋao kanaŋonzi rua tu ma simo kuku i. Ipateanzi tu ma muli isupwanzi silâ situla Maro Kindeni kawa ŋgua, ");
INSERT INTO xsi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aku i walo ilanzi sikai i ndamwa ŋana sisokinzi koroani saka piti tona. ");
INSERT INTO xsi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I ipatea Saimon ku io ŋoa Petero lâ tini, ");
INSERT INTO xsi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","aku ipatea Yamesi, i Sebedi natu, tava tai Yoane, ku ipatu kinzi rua ŋanzi toŋge tu, “Boanesis”. (Ŋoa ŋinde nde duvi mine tu, “Tamâta Sitogo Mbamba Ipu”.) ");
INSERT INTO xsi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aku ipateanzi Andaria, ŋga Pilip, ŋga Bartolomyu, ŋga Matai, ŋga Tomas, ŋga Yamesi i Alfius natu, ŋga Tadius, ŋga Saimon Selot, ");
INSERT INTO xsi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","aŋga Judas Iskariot, ina ma muli ikai kulu-pâŋga ŋana Yesu kâ ku io ilâ kinzi kazâŋa tamâta mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ipateanzi tamâta ŋinde lâ, ŋineŋga ilâ pa luma kilo. Andeta kinzi tamâta ŋgu ŋalae nde sipasau kuku kilo ku sipono nao, kala Yesu tavanzi ne pâri-tamâta sikura tu sisaŋona sika, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aku Yesu see kinzi siloŋo pâri ŋana ŋinde kâ, kala simâ tu sikale i kaika kâ. Kinzi siporo tu, “Opopo, ipâŋga kapa lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde nde sipile Jerusalem lawea sindue simâ, ku sivaligi Yesu tu, “Belsebul, i ŋa toŋge Sadana, ande ipagagara i lâ. Mine kala ikai koroani saka nenzi koipu ŋalae ŋinde ne walo ku isokinzi koroani saka piti.” ");
INSERT INTO xsi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mine kala Yesu isarawanzi tu simâ kuku, ku isia ŋgua panzi mine tu, “Mana mana ŋga Sadana ma ikura tu isoki i tamwata ne ŋgu, a? ");
INSERT INTO xsi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Miki kalomi ŋgere sondo ŋga; ambo kinzi tamâta nenzi lawea taitu ma sipwa pwataki simo ŋgu rua ku sikai kazâŋa pa warakanzi, ande lawea ŋinde ma sipayaula ndo. ");
INSERT INTO xsi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ambo tamâta toŋge natu-timbu ma sipwa pwataki simo ŋgu rua ku sikai kazâŋa pa warakanzi, ande ŋgu ŋinde ma sipayaula ndo. ");
INSERT INTO xsi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aku mine nâ, ambo Sadana ikai kazâŋa pa tamwata kala ne ŋgu sipwa pwataki, ande i ma ikura tu imo tia, ŋana tu i ne walo ma marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mao nâ, tamâta toŋge ikura tu iyoka kaa nâ ilâ tamâta kaika toŋge ne luma ilo ku ikai i ne kelekele, ande tia. I ma wâlo nâ ipa tamâta kaika ŋinde muŋga lâ ŋga. Ambo iveta mine lâ, ŋineŋga i ma ikai tamâta ŋinde ne kelekele rârâni keno ne luma ilo ŋinde marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Naŋa aporo mao nâ pami; tamâta nenzi kiesaka kie-kie wa ŋgua sakamao ŋinde wa, ande Maro Kindeni ikura tu izavaru kiesaka ŋinde rârâni piti lâ tininzi. ");
INSERT INTO xsi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ambo taitu tamâta ea iporo ŋgua pavaligiŋa pa Maro Kindeni ne Koroani Sapâŋa, ande Maro Kindeni ma izavaru kiesaka ŋinde piti lâ tini, ande tia. Tamâta ŋinde ne kiesaka ŋinde ma keno papa mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu iporo mine ŋana duvi ŋine kâ; kinzi muŋga siporo tu, “Koroani saka ipagagara i.” ");
INSERT INTO xsi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lâ zoni ndaina Yesu tina wa tai kinzi nde simâ sipâŋga kala simandi nia yo, ku sipasupwa imâ papa. Kinzi situ i ma imâ imoranzi. ");
INSERT INTO xsi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aŋga tamâta ŋgu ŋalae nde sisaŋona siŋge i lâ, aku kinzi pinde sipai Yesu tu, “Kuloŋo, noko tina wa tai kinzi nde simâ simandi nia yo kala sisarâwa pano.” ");
INSERT INTO xsi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Andeta iporo taulo panzi tu, “Naŋa nana wa taiŋgu wa nde ea kinzi.” ");
INSERT INTO xsi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ŋineŋga i mata ilea panzi tamâta ŋinde kala sisaŋona siŋge i lâ, ku iporo tu, “Naŋa nana wa taiŋgu wa kala simo ŋai! ");
INSERT INTO xsi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ŋana tu tamâta ea kinzi uru siveta ikura Maro Kindeni ne pateâŋa mine, ande kinzi ŋinde sitogo naŋa taiŋgu wa mwaneŋgu wa nana wa.” ");
INSERT INTO xsi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Zo toŋge Yesu imandi kilo ŋana ipanananzi tamâta lâ Galilaya lââ bwalika pwali. Aku ŋgu kambwaŋenzi ŋalae ŋinde nde simâ sipasau pasâe ndo lâ i tini. Mine kala ikâki wâŋga toŋge kulu isaŋona. Aŋga kinzi tamâta nde simandi sâwa. ");
INSERT INTO xsi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ŋineŋga Yesu iporo ŋgua siâŋa rârâ ŋinde ipanananzi tu, ");
INSERT INTO xsi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Miki kaloŋo ŋga. Tamâta toŋge iyoka ilâ iliŋi kaniŋa vâsa lâ tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iliŋi ilâ, ande vâsa pinde nde imbe indue nzâla-kawa, aku sii simâ sika marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aŋga vâsa pinde nde imbe indue tâno mira-mira. Tâno ŋinde nde matatola koŋa tia, kala mata ipâŋga walele. ");
INSERT INTO xsi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Andeta kari ikâki imâ ikana. Aku kâpwa ŋinde ne mburu-mburu kaika tia, kala ŋgâla-ŋgâla ndo lâ, kala imâte. ");
INSERT INTO xsi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aŋga vâsa pinde nde imbe indue wâlo mata-mata ŋgininzi. Aku wâlo ŋinde ipâŋga ŋalae ku ilita, kala kanaŋo ipâŋga tia. ");
INSERT INTO xsi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aŋga vâsa pinde nde imbe indue tâno ara kulu, aku ipâŋga ŋalae ku ipula kanaŋo. Pinde ipula kanaŋo tamâta taitu kanaŋo saŋao (30), aŋga pinde nde ipula kanaŋo tamâta ŋato (60), aŋga pinde nde ipula kanaŋo tamâta ŋalae taitu (100).” ");
INSERT INTO xsi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aku Yesu ipainzi tu, “Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo.” ");
INSERT INTO xsi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Muli ŋga, ŋgu ŋalae ŋinde nde silâ lâ, ŋineŋga kinzi pâri-tamâta saŋao kanaŋonzi rua sitavanzi tamâta pinde uru simo kunzi ŋinde, ande sikasoŋa Yesu ŋana ŋgua tambirâŋa ŋinde duvi kâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aku Yesu ipainzi tu, “Maro Kindeni itula ŋgua paveâŋa ne duvi pwataki pami ŋana i ne mâsi ŋana ikai maro panzi tamâta kâ. Aŋga kinzi tamâta simo niaka ande siloŋo ŋgua tambirâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ŋana tu muŋga ŋgua-tulâŋa tamâta Aisaia iŋgere ŋgua lâ pepa tini mine tu, ‘Kinzi matanzi ma pareŋge, andeta ma simora kelekele toŋge tia. Aku ma sitambira taŋanzi, andeta ma sisama ŋgua duvi kilala tia. Ambo kinzi simo mine tia, ande ma sipalele ilonzi kalonzi, kala Maro Kindeni ma izavaru nenzi kiesaka piti lâ tininzi. Andeta tia.’” ");
INSERT INTO xsi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aku Yesu ipainzi tu, “Ambo miki kazizâla ŋana ŋgua tambirâŋa ŋine duvi, ande miki ma kakura tu kasama ŋgua tambirâŋa rârâni ne duvi mâsi mana, a? ");
INSERT INTO xsi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kaniŋa vâsa kala tamâta iliŋi ŋinde, ande itogo Maro Kindeni ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kinzi tamâta pinde sitogo vâsa ŋinde imbe indue nzâla-kawa, ŋana tu kinzi siloŋo Maro Kindeni ne ŋgua lâ taŋanzi, andeta lâ zoni ndaina Sadana imâ ku ikawea ŋguani ndaina piti lâ ilonzi. ");
INSERT INTO xsi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aŋga tamâta pinde nde sitogo vâsa ŋinde imbe indue tâno mira-mira. Kinzi siloŋo ŋgua ku sikai walele nâ, aku sindeka ŋana. ");
INSERT INTO xsi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Andeta kinzi sikai ŋgua ŋinde kaika tia. Mine kala simo zo mbwana-mbwana nâ, aku muli ŋga tamâta pinde simâ situ siveta malia panzi ku siveta kenzi sakamao panzi ŋana nenzi kalo-tawana kâ. Mine kala kinzi nenzi kalo-tawana imbe walele nâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aŋga kinzi tamâta pinde nde sitogo vâsa ŋinde imbe indue wâlo mata-mata ŋgininzi. Kinzi siloŋo ŋgua, ");
INSERT INTO xsi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","andeta ilonzi ŋalae ŋana tâno ne kelekele, aku ilonzi ŋalae ŋana sigona mbaliŋa rârâ, kala ilonzi yosi ŋana toŋge-toŋge rârâ. Aku ilo-kalo ŋinde iveta kalo-lokoni panzi, kala siveta vetâŋa ara pinde tia. ");
INSERT INTO xsi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aŋga kinzi tamâta pinde nde sitogo vâsa ŋinde imbe indue tâno ara kulu. Kinzi siloŋo ŋgua ku sikai sipaveta kuku, kala siveta vetâŋa ara rârâ, itogo kanaŋonzi mine; pinde siveta vetâŋa ara tamâta taitu kanaŋo saŋao (30), aŋga pinde siveta vetâŋa tamâta ŋato (60), aŋga pinde nde siveta vetâŋa tamâta ŋalae taitu (100).” ");
INSERT INTO xsi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ŋineŋga Yesu ipainzi tu, “Kinda uru takai sinâla ku tao lâ kondo kalo wa peke kalo, ande tia. Kinda uru tao sinâla ikeno peke kulu. ");
INSERT INTO xsi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aku mine nâ, ŋgua ndia rârâni ikeno paveâŋa, ŋinde miki ma katula pwataki ipâŋga nia yo, ŋana kinzi tamâta ma sikura tu sisama ŋgua rârâni duvi. ");
INSERT INTO xsi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo.” ");
INSERT INTO xsi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ŋineŋga Yesu ipainzi tu, “Ŋgua ndia miki kaloŋo, ande ŋinde miki ma ilomi ipatea sondo. Ŋana tu tamâta ea itambira taŋa sondo pa Maro Kindeni kawa ŋgua, ande Maro Kindeni ma itula ŋgua ŋinde ne duvi pwataki papa i, aku ma itula ŋgua pinde kilo papa tava. ");
INSERT INTO xsi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mao nâ, tamâta ea ikai ilo-kalo ŋana Maro Kindeni ne vetâŋa paveâŋa kâ, ande Maro Kindeni ma ilo-kalo ŋalae ilua i. Aŋga tamâta ea tini pwâka tu ikai ilo-kalo ŋinde, ande ilo-kalo tini-mwata i muŋga ikai, ande ŋinde Maro Kindeni ma ikai saŋe.” ");
INSERT INTO xsi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aku Yesu iporo mine tu, “Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ, ande itogo tamâta iliŋi kaniŋa vâsa lâ tâno ilo. ");
INSERT INTO xsi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikura mbo mbo tamâta ŋinde ikeno, aŋga kari kari imandi ku iyoka. Andeta vâsa ŋinde ipâŋga ilâ ŋalae mâsi mana; ande tamâta ŋinde isama ŋine tia. ");
INSERT INTO xsi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ŋana tu tâno tamwata nâ iveta wurâta papa vâsa ku iveta kâpwa ipâŋga. Mata ipâŋga muŋga, ŋineŋga io lau, aku mwaŋga ŋga kanaŋo ipâŋga ŋalae itumbua mata. ");
INSERT INTO xsi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aku muli ŋga kanaŋo ŋinde ipâŋga ŋalae lâ, kala tâno warika ŋinde isupwanzi ne wurâta tamâta tu sikai nenzi pila silâ ŋana sitoto kâ. Ŋana tu kâpwa gonâŋa ne zo nde imâ ipâŋga lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Kinda ma taporo ŋgua mana ŋana tatula Maro Kindeni ne mâsi ŋana ikai maro panzi tamâta kâ ipâŋga nia yo. Kinda ma tasia ŋgua mana ŋana tatula ŋinde pwataki. ");
INSERT INTO xsi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maro Kindeni ne mâsi ŋinde nde itogo kaniŋa ‘mastet’ vâsa. Mastet vâsa ŋandai irerege kuku vâsa rârâ kinzi tamâta uru sipau lâ tâno ilo ŋga. I nde mota mwata, itogo paulo mine. ");
INSERT INTO xsi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tamâta ipau vâsa ŋinde lâ, ŋineŋga kâi mastet ŋinde ipâŋga aku ilâ ŋalae tina lâ, aku i ne luandondo ipolenzi kaniŋa kie-kie rârâni uru sipau lâ tâno ilo. I laka ŋalae ŋinde, kala kinzi sii kie-kie uru sipagona simâ sisaŋona ne laka kulu.” ");
INSERT INTO xsi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu iporo ŋgua panzi tamâta, ande iporo ŋgua tambirâŋa rârâ mine, ipakura kuku nenzi ilo-kalo ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I ŋandai iporo ŋgua rârâ ipâŋga nia yo panzi ŋga. Iporo ŋgua tambirâŋa rârâ panzi. Andeta i uru ikainzi ne pâri-tamâta silâ pa nia ŋgaŋe, ŋineŋga itula ŋgua ŋinde rârâni duvi pwataki panzi. ");
INSERT INTO xsi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aku lâ zoni ndaina, kari indue lala lâ, ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Ayo, kinda ma tambwaliu talâ pa lââ bwalika tini pinde.” ");
INSERT INTO xsi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aku sipilenzi tamâta ŋgu ŋalae ŋinde, ku sikâki wâŋga muŋga Yesu isaŋona ŋinde kulu. Aku sikai Yesu tava silâ. Aŋga wâŋga pinde nde silâ kunzi tava. ");
INSERT INTO xsi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Andeta lawea iyoka more-more ŋalae ku ne kâla kâki iliŋi lâ wâŋga ilo, aku lââ pipi lâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aŋga Yesu nde ikulanda kulânda toŋge ku ikeno wâŋga ilo pa muli kâ. Mine kala kinzi sipaŋo Yesu ku sipai tu, “Pananâŋa! Laiti ŋana kinda tambwatuke kâ, andeta noko kalo sukâŋa tia tâ!” ");
INSERT INTO xsi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aku Yesu imandi itu ŋgua kaika pa lawea ku ipai tu, “Kura lâ! Pâti kii lâ!” Aku ndainani nâ lawea pâti kii lâ, aku kâla imâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ŋineŋga ipainzi ne pâri-tamâta tu, “Ŋana sâ kâ ŋga miki karuru pâta, a? Miki nemi kalo tawana nde kiri-mwata nâ!” ");
INSERT INTO xsi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Andeta kinzi siruru pâta kanaŋo ku siporo nenzi mine tu, “Opopo, tamâta ŋine nde tamâta mana kala iporo kaika pa kâla-lawea, aku kinzi kala sipaloŋo pa i kawa ŋgua!” ");
INSERT INTO xsi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kinzi silâ lee sitoa lââ bwalika tini pinde, lâ kinzi Gerasa nenzi tâno. ");
INSERT INTO xsi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu ipile wâŋga itoa lâ, ŋineŋga walele nâ tamâta toŋge ipakâtu kuku, i koroani saka ipagagara lâ. Tamâta ŋinde imo potomule lâ kuru nia, kala iyoka pa ŋinde imâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tamâta ŋinde uru ikeno ŋgânza ilo lâ kuru nia ŋinde. Muŋga, kinzi tamâta pinde sipa wâlo kaika lâ i tini, andeta kala ŋine sikura tu siveta mine kilo, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Muŋga, ikura zo rârâ kinzi sipa i kie-mbalau lâ wâlo kaika. Andeta i uru itaki wâlo kaika ŋinde utu. I nde tamâta kaika ndo, kala tamâta toŋge ikura tu ikai i kaika, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ikura kari wa mbo wa, tamâta ŋinde imo kuru nia wa tuu kulu wa, aku uru kawa pakâe ipaive tamwata karae lâ mira tu ma ipayaula pâta imâte. ");
INSERT INTO xsi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tamâta kapa ŋinde imandi imo malawae, andeta mata ilâ imora Yesu kala ipalilu imâ ku ipare tuku papa. ");
INSERT INTO xsi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aku Yesu ipai tu, “Noko koroani saka ŋai, noko kupile tamâta ŋine ku pwâwa kulâ!” Andeta koroani saka isarâwa kaika ndo ku iporo tu, “Yesu, Maro Kindeni âta Tamwata Natu, noko kutu kuveta mana pa naŋa, a? Naŋa ano pano lâ Maro Kindeni ŋa tu noko ma nâna kulua naŋa ndimo!” ");
INSERT INTO xsi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aku Yesu ikasoŋa koroani saka mine tu, “Aŋga noko nde ŋa mana.” Ande iporo taulo tu, “Naŋa ŋâŋgu ‘Zugu Tamwatama’, ŋana tu maka ŋgu kambwaŋema ŋalae ndo.” ");
INSERT INTO xsi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku ino kaika ŋinde pa Yesu tu, “Noko ma kuŋarama lâ tâno ŋine ndimo!” ");
INSERT INTO xsi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aku ŋgoa ŋgu ŋalae nde simo nia ŋinde, sipaŋuŋu sika simo nia ndamwa. ");
INSERT INTO xsi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aku kinzi koroani saka sino kaika pa Yesu tu, “Kuo maka kalâ kinzi ŋgoa ŋinde ilonzi.” ");
INSERT INTO xsi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aku Yesu isâu panzi tu silâ. Aku marumbu; kinzi koroani saka sipile tamâta ŋinde ku silâ ŋgoa ilonzi. Ŋineŋga ŋgoa ŋinde nde wisinzi motutu simaŋguru sipalilu kaika silâ sindue nia ndamwa ŋinde. Ŋgoa ŋgu ŋinde kambwaŋenzi ipâŋga ikura 2000 mine, aku kinzi rârâni sisoŋga sindue lââ bwalika ilo sinu lââ ku sipamateteu marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ŋineŋga kinzi ŋgoa nenzi katonâŋa tamâta nde sikâwa silâ, ku sikai pâri silâ pa lawea ilo wa nia ŋinde ndoni wa. Mine kala kinzi tamâta simâ tu simora mâsi kala muŋga ipâŋga ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kinzi simâ sipâŋga pa Yesu, aku simora tamâta ŋinde, muŋga koroani saka rârâ sipagagara, andeta ŋineŋga ipita lalava ku ne ilo-kalo ipâŋga sondo lâ, kala isaŋona imo. Kinzi tamâta simora ŋine ku wisinzi motutu. ");
INSERT INTO xsi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ŋineŋga kinzi tamâta kala muŋga simora mâsi ŋinde nde sitapâri panzi ŋana mâsi ŋinde ipâŋga pa tamâta ŋinde, ina muŋga koroani saka sipagagara. Aku sitapâri panzi ŋananzi ŋgoa tona. ");
INSERT INTO xsi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ŋineŋga kinzi tamâta sino kaika pa Yesu tu ma ipile nenzi lawea ku ilâ pa nia toŋge. ");
INSERT INTO xsi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mine kala Yesu ikâki wâŋga kulu. Andeta tamâta ŋinde muŋga koroani saka sipagagara, ande ino Yesu mine tu, “Naŋa iloŋgu tu ma amo kuku noko.” ");
INSERT INTO xsi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Andeta Yesu ipai tu, “Tia. Noko kutaulo kulâ panzi noko see, aku kutapâri panzi ŋana vetâŋa rârâni Maro Ŋalae iveta pano ŋine. Aku kutula pwataki panzi tu i kalo sukâŋa ŋanano.” ");
INSERT INTO xsi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ŋineŋga tamâta ŋinde ilâ, aku iveta wurâta ŋana itu pâri ŋinde panzi tamâta simo lawea pinde sipatu ŋa tu Dekapolis (nenda ŋgua tu “Lawea Saŋao”). Itapâri panzi ŋana vetâŋa ŋinde Yesu muŋga iveta papa. Mine kala kinzi tamâta rârâni nde ilonzi rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ikainzi ne pâri-tamâta sikâki wâŋga kulu ku simbwaliu kilo. Sitoa lâ, ŋineŋga tamâta ŋgu ŋalae ŋinde nde simâ sipasau lâ Yesu tini lâ lââ bwalika pwali. ");
INSERT INTO xsi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ŋineŋga tamâta toŋge, i ŋa tu Jairus, ande imâ ipâŋga. I nde luma ŋana pasauŋa kâ ne katonâŋa tamâta toŋge. I mata ilâ imora Yesu, ku imâ ipare tuku lâ i kie tini laiti. ");
INSERT INTO xsi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aku ino kaika pa Yesu tu, “Naŋa natuŋgu taine taipa nde laiti ŋana imâte kâ. Mine nde kumâ kutaŋo i, aku ma tini ara kilo ku ma imo via.” ");
INSERT INTO xsi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aku Yesu iyoka kuku silâ. Andeta tamâta ŋgu ŋalae ŋinde soka i muli, ku sipatiŋgi nâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aku taine toŋge kala imo ndaina, i uru imora nzimona zo rârâni. I imo mine ikura mbwera saŋao kanaŋo rua lâ, ");
INSERT INTO xsi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","aku kinzi tamâta ŋana sivetanzi pukoŋa kâ rârâ nâna kie-kie silua i ŋana ne pukoŋa ŋinde kâ. Taine ŋinde nde ipile ne mbumbu rârâ panzi, andeta ne pukoŋa marumbu tia, ikeno kaika lâ tini ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Taine ŋinde iloŋo Yesu parina lâ, kala i ilo patea tu, “Ambo naŋa mbauŋgu sili ataŋo i ne pasawaŋa ŋgaŋe nâ, ande ma tiniŋgu ara kilo.” Mine kala imâ imo tamâta ŋgu ŋalae ŋinde ŋgininzi. Imege ku iyoka pa Yesu muli imâ, ku mbau ilâ itaŋo i ne pasawaŋa ŋgaŋe. ");
INSERT INTO xsi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ŋineŋga walele nâ i see mâsa-mâsa, ku ipasama tini tu pukoŋa ŋine nde marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Andeta Yesu ipasama tu i ne walo pinde nde ilâ lâ. Mine kala ipupulia ku ikasoŋanzi ŋgu tu, “Ea itaŋo naneŋgu pasawaŋa ŋgaŋe.” ");
INSERT INTO xsi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Andeta i ne pâri-tamâta sipai tu, “Opopo, kinzi tamâta ŋgu ŋalae nde sitiŋgi noko. Mine nde mana mana ŋga noko pwasoŋanzi tu, ‘Ea itaŋo naŋa’, a?” ");
INSERT INTO xsi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Andeta Yesu mata imora ilâ wa imâ wa tu isama tamâta ea itaŋo i. ");
INSERT INTO xsi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aku taine ŋinde ipasama lâ ŋana vetâŋa ŋinde kala ipâŋga papa, aku i kalo loko ku tini ruru. Tia ku imâ pa Yesu ku ipare tuku papa, ku iporo pwataki ŋana vetâŋa ŋinde rârâni. ");
INSERT INTO xsi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ŋineŋga Yesu ipai tu, “Natuŋgu, noko ne kalo-tawana ŋinde ivetano tini ara kilo. Noko kulâ, aku wisi puu ndue, ŋana tu noko ne pukoŋa nde marumbu lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu iporo ŋgua ŋine yo, ŋineŋga tamâta pinde muŋga soka pa katonâŋa Jairus ne luma kâ nde simâ sipâŋga lâ. Aku sipai tu, “Noko natu nde imâte lâ. Mine nde noko ma kuveta kalo-lokoni papa pananâŋa kilo ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Andeta Yesu ipaloŋo pa kinzi nenzi ŋgua ŋinde, ande tia. Iporo pa Jairus mine tu, “Noko kururu ndimo. Kalo tawana naŋa nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aku itu kaika panzi tamâta tu ma soka kuku i simâ ndimo. Ikainzi Petero, ŋga Yamesi, ŋga Yamesi tai Yoane, aku kinzi ŋato nâ soka kuku i silâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kinzi silâ lee sipâŋga katonâŋa Jairus ne luma, ande Yesu imoranzi tamâta siveta nduŋeŋa ŋalae wa sita pâta lâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aku ilâ luma ilo ku ipainzi tu, “Ayo, ŋana sâ kâ ŋga miki kata wa kaveta nduŋeŋa ŋalae koŋa, a? Lâlu ŋine ŋandai imâte ŋga; ikeno mata nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Andeta kinzi siŋelea i pâta kanaŋo. Tia ku ionzi tamâta rârâni siyâti pa nia yo. Ŋineŋga ikainzi lâlu tina ku tama rua, sitavanzi ne pâri-tamâta ŋato, aku kinzi ŋinde nâ soka silâ luma ilo kisiŋa pwataki lâlu ikeno ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ŋineŋga isaŋa taine taipa ŋinde mbau ku ipai tu, “Talita kumi!” Ŋgua ŋinde nde duvi mine tu, “Taine taipa, naŋa apaino tu kumandi sânda!” ");
INSERT INTO xsi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aku walele nâ taine taipa imandi ku iyoka. I ne mbwera ipâŋga ikura saŋao kanaŋo rua mine. Aku kinzi simora mâsi ŋinde ku wisinzi motutu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Andeta Yesu indi kaika panzi mine tu, “Miki ma katapâri pa tamâta toŋge ŋana mâsi ŋine ndimo.” Aku ipainzi tu, “Kâpwa pinde kalua taine taipa ŋine ika.” ");
INSERT INTO xsi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ipile lawea ŋinde aku ilâ pa tamwata ne lawea. Aku i ne pâri-tamâta nde soka kuku silâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aku lâ pwareâŋa ne zo sapâŋa, Yesu ilâ luma ŋana pasauŋa kâ ilo ku itula Maro Kindeni kawa ŋgua pwataki panzi tamâta. Kinzi siloŋo i ne ŋgua, aku kinzi rârâni wisinzi motu pâta. Kinzi sipakasoŋa tu, “Opopo, tamâta ŋine nde ikai ŋgua ŋine lâ nia ndia, a? Aŋga ilo-kalo ŋine kala ikeno papa i, ande ilo-kalo mana, a? Mana mana ŋga iveta mâsi kaika mine, a? ");
INSERT INTO xsi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tiambo tamâta ŋine uru iveta wurâta ŋana ipa luma kâ, tiya? Tiambo i nde Maria natu, aŋga i nde Yamesi wa Josis wa Juda wa Simeon tuanzi, tiya? Tiambo i mwane wukale kala simo ŋai kuku kinda, tiya?” Kinzi siporo ŋgua mine rârâ, ku sipu mulinzi pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Andeta Yesu ipainzi tu, “Kinzi tamâta simo lawea ndoni nde ilonzi ara pa ŋgua-tulâŋa tamâta. Taitu kinzi tamâta lâ i tamwata ne lawea tina wa i see wukale wa, kinzi ŋinde ilonzi ara papa i, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kinzi nenzi kalo-tawana ikeno pa Yesu tia ndo. Mine kala ikura tu iveta mâsi kaika toŋge lâ lawea ŋinde, ande tia. Andeta io mbau lâ kinzi pukoŋa tamâta pinde nâ tininzi, ku ivetanzi tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aku Yesu ilo malia ŋana kinzi tamâta ŋinde nenzi kalo-tawana soki-soki ŋinde. Ŋineŋga iyoka ilâ pa lawea pinde, ku ipanananzi tamâta ŋana Maro Kindeni kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu isarawanzi ne pâri-tamâta saŋao kanaŋonzi rua tu simâ kuku, ŋineŋga ionzi rua rua tu ma silâ situla pâri ara. Aku i tamwata ne walo kaika ilanzi ŋana sisokinzi koroani saka piti lâ tamâta ilonzi. ");
INSERT INTO xsi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ŋineŋga ipainzi tu, “Miki ma kakai nemi tukâla ŋana yokâŋa kâ ŋine nâ koka. Miki ma kakai sâ toŋge iyoka tona ndimo. Miki ma kakai kâpwa wa tâŋa wa mbumbu wa ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Miki ma kasawa kâmba lâ kemi, ambo taitu ma kasawa pasawaŋa rua ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ambo miki kalâ kapâŋga lawea toŋge ku kalâ luma toŋge ilo, ande miki ma kakeno luma taituni ŋinde nâ ilo. ");
INSERT INTO xsi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ambo kinzi tamâta lâ lawea pinde tininzi pwâka ŋanami ku taŋanzi kaika ŋana nemi ŋgua, ande ara, kapile lawea ŋinde, aku kapamasi kemi tâno gawura piti, ŋana itula nenzi vetâŋa soki ŋinde pwataki.” ");
INSERT INTO xsi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu iporo ŋgua ŋine panzi lâ, ŋineŋga silâ ku situla ŋgua mine tu, “Miki kapalele ilomi kalomi.” ");
INSERT INTO xsi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aku sisokinzi koroani saka rârâ piti lâ tamâta ilonzi tava. Aŋga kinzi pukoŋa tamâta rârâ, ande pâri-tamâta sivala samimi lâ tininzi, kala Maro Kindeni ivetanzi tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pa zo ŋinde, Herot ikai koipu panzi tamâta rârâni simo tâno ŋinde. Aŋga Yesu parina nde ilâ isala nia ndoni. Mine kala Herot iloŋo ŋgua ŋana Yesu ne pâri-tamâta nenzi vetâŋa ŋinde. Kinzi tamâta pinde simora Yesu ne mâsi kaika ku siporo tu, “Yoane Lââ-Liliŋa Tamwata imandi sânda lâ mateŋa nianzi imo via kilo, kala walo kaika ŋalae nde ipâŋga lâ i mbalau!” ");
INSERT INTO xsi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aŋga kinzi pinde nde siporo tu, “I nde Ilia.” Aŋga pinde nde siporo tu, “I nde ŋgua-tulâŋa tamâta, itogo kinzi ŋgua-tulâŋa tamâta muŋgâŋa ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Andeta Herot iloŋo ŋgua ŋine, aku iporo tu, “Opopo, muŋga naŋa atoto Yoane Lââ-Liliŋa Tamwata ŋandola utu lâ. Andeta ŋine imandi sânda imo via kilo tâ!” ");
INSERT INTO xsi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herot ne ŋgua ŋinde nde duvi mine; muŋga Herot tai Pilip ikai taine toŋge, i ŋa mine Herodias, andeta muli, ŋineŋga Herot ikai taine ŋinde saŋe Pilip, aku rua sipakâe. Andeta Yoane Lââ-Liliŋa Tamwata iporo ŋgua kaika mbwani rârâ pa Herot ilelea mine tu, “Ŋana sâ kâ ŋga noko pwai tai kaiwa, a? Mâsi mine nde ara tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodias iloŋo ŋgua ŋine, aku i wisi nâna pa Yoane Lââ-Liliŋa Tamwata, kala itu ipu Yoane pâta imâte. Andeta Herot nde imege ŋana Yoane, aku isama tu Yoane nde tamâta sapâŋa kala iveta vetâŋa sondo ndo. Mine kala Herot isupwanzi tamâta pinde silâ sikale Yoane Lââ-Liliŋa Tamwata kaika ku sipa lâ wâlo kaika, ŋineŋga sikai silâ sio lâ luma sakamao ilo. Aku Herot ikatona Yoane sondo, aku i tini mwasa nâ ŋana iloŋo Yoane iporo ŋgua. Andeta lâ zo ŋana iloŋo Yoane iporo ŋgua, ande i uru ilo rua-rua wa ilo malia tona. ");
INSERT INTO xsi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Andeta muli, ŋineŋga Herodias isânda nzâla ŋana Yoane ma imâte kâ. Ŋinde ipâŋga lâ zo ŋinde Herot iveta kâŋa-nuŋa ŋalae ŋana ne zo tina ipagugua i kâ. Iveta kâpwa ŋinde panzi tamâta ŋalaŋala uru sisuka i ŋana wurâta kâ, sitavanzi kinzi zugu tamâta nenzi koipu wa kinzi mbaliŋa warakanzi simo Galilaya tâno. ");
INSERT INTO xsi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lâ zoni ndaina, Herodias natu taine imâ luma ilo ku ikina kiniŋa panzi. Aku kinzi tamâta kala sika kuku Herot ŋinde nde ilonzi yosi papa taine ŋinde. Mine kala Herot ipai taine taipa tu, “Sâ kelekele toŋge noko ilo papa kala kuno naŋa, ande ma naŋa alano.” ");
INSERT INTO xsi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ŋineŋga Herot iporo ŋgua kaika tu, “Naŋa aporo mao pa âta, ambo noko kuno pana ŋana kelekele toŋge, ande ŋinde ma nalano. Ambo noko kupai naŋa tu, ‘Noko kupu ne mbaliŋa ndoni pwataki lâ ŋgini ku pinde kulana’, ande ara, naŋa akura.” ");
INSERT INTO xsi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mine kala taine taipa iyâti ilâ ku ikasoŋa tina tu, “Naŋa ma asarâwa sâ papa.” Aku tina nde iporo tu, “Noko kupai tu, ‘Naŋa atu akai Yoane Lââ-Liliŋa Tamwata kulu kâmba’.” ");
INSERT INTO xsi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Taine taipa itaulo imâ walele nâ papa Herot, aku ipai tu, “Ŋaina nâ, naŋa atu noko ma kuo Yoane Lââ-Liliŋa Tamwata kulu kâmba lâ kondo ilo, ku pwai kumâ kutula pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Taine iporo mine lâ, aku Herot ilo malia ŋalae ŋinde. Andeta i ilo ŋana ne ŋgua pâŋa muŋga iveta lâ kinzi tamâta sisaŋona kuku i ŋinde naonzi. Mine kala i tini pwâka tu itoto taine taipa ŋinde kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tia ku Herot walele nâ isupwa ne sambara toŋge ilâ tu ikai Yoane kulu kâmba imâ. Aku sambara ŋinde ilâ pa luma sakamao nia, ku itoto Yoane ŋandola utu, ");
INSERT INTO xsi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ku io kulu kâmba lâ kondo toŋge ilo, ku ikai imâ itula pa taine taipa. Aku taine taipa kala itula pa tina. ");
INSERT INTO xsi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yoane ne pâri-tamâta siloŋo ŋgua tu Yoane ŋga imâte lâ, kala simâ sikai i karae ku silâ sikea. ");
INSERT INTO xsi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kinzi pâri-tamâta saŋao kanaŋonzi rua nde sitaulo simâ sipasau kuku Yesu kilo, aku sitapâri papa ŋana vetâŋa siveta wa ŋgua sipanananzi tamâta ŋinde wa. ");
INSERT INTO xsi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Andeta kinzi tamâta rârâ nde silâ wa simâ wa, kala Yesu ne zo ŋana ipwarea ika kunzi ne pâri-tamâta, ande tia. Mine kala Yesu ipainzi tu, “Ayo, kinda nâ ma talâ papa nia ŋgaŋe toŋge tamâta simo tia, mambo miki kapwarea ŋga.” ");
INSERT INTO xsi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ŋineŋga kinzi sikai wâŋga silâ pa nia toŋge tamâta simo tia. ");
INSERT INTO xsi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Andeta tamâta ŋgu ŋalae ŋinde simoranzi ku sisama tu kinzini kala silâ. Tia ku sipile nenzi lawea rârâni ku sipalilu simuŋga silâ sikai nia ŋinde lâ. Aku muli, ŋineŋga Yesu tavanzi ne pâri-tamâta nde simâ sipâŋga. ");
INSERT INTO xsi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu itoa tina tini, aku mata ilâ imoranzi tamâta ŋgu ŋalae, aku i kalo sukâŋa ŋananzi, ŋana tu kinzi sitogo lama ŋgu nenzi katonâŋa tia mwasina. Mine kala iveta wurâta ŋana ipanananzi ŋgua rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ipanananzi lee kari indue lala lâ, ŋineŋga ne pâri-tamâta simâ papa ku sipai tu, “Wa, kari ŋga indue lala lâ, aku nia ŋgaŋe ŋine tamâta simo tia. ");
INSERT INTO xsi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mine nde kuonzi tamâta tu silâ, aku ma siroto ŋana nia wa lawea ŋana sipako kapwanzi sika kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Andeta Yesu itu lâ kawanzi tu, “Miki warakami nâ kasuanzi.” Ande kinzi sipai tu, “Opopo, tiambo noko kutu maka ma kalâ kako puroŋa lâ mbumbu tamâta-tamâta aku kasuanzi, a?” ");
INSERT INTO xsi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ŋineŋga Yesu ikasoŋanzi tu, “Miki kalâ kamora, puroŋa ŋapia keno pami.” Kinzi sisama lâ aku siporo tu, “Puroŋa lima aŋga iŋa rua nâ kala keno pama.” ");
INSERT INTO xsi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ande Yesu ipainzi tu, “Kaonzi tamâta sisaŋona ŋgu ŋgu sipaseŋge lâ unza kulu.” ");
INSERT INTO xsi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kinzi lambunzi ndue sisaŋona ŋgu ŋgu, kambwaŋenzi ikura 100 wa 50 wa. ");
INSERT INTO xsi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ŋineŋga Yesu ikai puroŋa lima tava iŋa rua ŋinde kâki, aku mata kâki pa samba ku kawa ndaŋge pa Maro Kindeni. Ŋineŋga ipwataki puroŋa ilanzi ne pâri-tamâta tu siwae panzi tamâta. Aku ipwataki iŋa rua kala ku iveta mine nâ, iwae panzi rârâni sika. ");
INSERT INTO xsi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kinzi tamâta rârâni sika lee kapwanzi pupuro lâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sika lâ, aku puroŋa wa iŋa katiŋe keno mo ŋai yo. Ŋineŋga Yesu ne pâri-tamâta sigona kâpwa ŋinde ikura ŋgâmo ŋalae saŋao kanaŋo rua ilonzi pipi pâŋga. ");
INSERT INTO xsi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kinzi tamâne kala sika kâpwa ŋinde kambwaŋenzi nde ipâŋga ikura 5,000 mine. ");
INSERT INTO xsi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesu ipasusuanzi ne pâri-tamâta tu sikai wâŋga ku walele nâ simuŋga simbwaliu silâ papa lââ bwalika tini pinde lâ Betsaida lawea. Aŋga i itu ma ionzi tamâta mbo silâ ŋga. ");
INSERT INTO xsi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu ionzi tamâta silâ lâ, ŋineŋga ikâki tuu toŋge kulu ŋana ikai noŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ikai noŋa lee lala pararai lâ, aku wâŋga nde ilâ ipâŋga lââ bwalika ŋgini. Aŋga Yesu nde simbo nâ imandi sâwa. ");
INSERT INTO xsi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aku i mata ilâ imoranzi ne pâri-tamâta simakâsa ŋalae ŋana sipoe kâ, ŋana tu sikundua lawea ŋalae. Aku mbwale mbwale kâ, ŋineŋga Yesu iyoka lââ kulu ilâ panzi. Iveta ŋana ipolenzi kâ, ");
INSERT INTO xsi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","andeta ne pâri-tamâta matanzi kâki simora i iyoka lââ kulu, aku situ i nde barâwe, kala sitara pâta. ");
INSERT INTO xsi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kinzi rârâni simora i aku siruru pâta kanaŋo. Andeta walele nâ Yesu ipainzi tu, “Wa, miki tinimi kaika, karuru ndimo! Ŋine nde naŋani warakâŋgu!” ");
INSERT INTO xsi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aku ikâki ilâ wâŋga ilo kunzi, ŋineŋga lawea kautu lâ. Aku kinzi wisinzi motu pâta ku ilonzi rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ŋana tu ilonzi kalonzi ŋandai ipâŋga ŋana puroŋa ŋinde muŋga Yesu ilanzi tamâta ŋga. Kinzi kalonzi tawana soki-soki yo. ");
INSERT INTO xsi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu ikainzi ne pâri-tamâta ku simbwaliu silâ sitoa, ŋineŋga sisine wâŋga papa lââ bwalika tini pinde lâ Genesaret lawea. ");
INSERT INTO xsi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kinzi sipile wâŋga sitoa tina tini, andeta walele nâ kinzi tamâta lâ lawea ŋinde simora Yesu kilala pwataki lâ. ");
INSERT INTO xsi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mine kala kinzi sipalilu sikura nia nia silâ, aku sitapâri tu Yesu ŋga imâ ipâŋga lâ. Ŋineŋga sionzi nenzi pukoŋa tamâta lâ rombe-rombe kulu, aku sikalenzi simâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aku ikura nia nia wa lawea ndia Yesu ilâ ipâŋga, ande kinzi uru sionzi nenzi pukoŋa tamâta lâ ao ŋgini. Aku kawanzi kâki sisarâwa sino kaika pa Yesu tu ma isâu pa nenzi pukoŋa tamâta tu sitaŋo i ne pasawaŋa ŋgaŋe. Aku kinzi ŋinde sitaŋo i ne pasawaŋa ŋgaŋe, ande kinzi rârâni tininzi ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kinzi Parisai ŋgu sitavanzi kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde nde soka Jerusalem simâ ŋana sipasau kuku Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Andeta matanzi ilâ simora tu Yesu ne pâri-tamâta pinde ŋandai sipua mbalaunzi muŋga lâ ŋineŋga sika. ");
INSERT INTO xsi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ŋine nde duvi mine; kinzi Parisai aŋga kinzi Juda tamâta rârâni uru sipaveta kuku timbunzi muŋgâŋa nenzi vetâŋa rârâni. Mine kala ambo kinzi ma sipua mbalaunzi sondo tia, ande ma sika tia. ");
INSERT INTO xsi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aku mine nâ, ambo kinzi ma silâ pa nââ nia, ŋineŋga sitaulo simâ kilo, ambo sipua tinikoa nenzi muso piti lâ mbaunzi wa kâpwa tia, ande ma sika tia. Mao nâ, kinzi sipaveta kuku vetâŋa rârâ siloŋo wa sikai lâ timbunzi ŋinde, kala uru sipua kulo-kâmba wa moe-sambure wa.) ");
INSERT INTO xsi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mine kala kinzi Parisai tamâta sitavanzi kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ nde sikasoŋa Yesu tu, “Ŋana sâ kâ ŋga noko ne pâri-tamâta ŋandai sipaveta kuku timbunda nenzi vetâŋa, a? Ayo, tinikoa nenzi muso ikeno mbalaunzi yo, andeta sika!” ");
INSERT INTO xsi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Andeta Yesu itu lâ kawanzi tu, “Opopo, nanayoni ŋgua-tulâŋa tamâta Aisaia itula miki kilalami pwataki tu miki kawami kaporo ŋgua kie toŋge, aŋga ilomi nde keno piti. Mao nâ, Aisaia ikai Maro Kindeni kawa ku iŋgere ŋgua lâ pepa tini mine tu, ‘Kinzi ŋgu ŋine uru sipanea naŋa koa tia nâ lâ kawanzi, aŋga ilonzi nde keno pa naŋa tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kinzi uru situla tamâta nâ nenzi ŋgua tukuŋa ku siporo tu, “Maro Kindeni kawa ŋgua kala ŋine”. Mine kala sipanea naŋa koa tia nâ.’ ");
INSERT INTO xsi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Miki kapile Maro Kindeni ne ŋgua tukuŋa marumbu lâ, aku ilomi ipaipa kuku tamâta nâ nenzi mâsi.” ");
INSERT INTO xsi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ŋineŋga Yesu ipainzi kilo tu, “Mao nâ, miki uru kapu mulimi papa Maro Kindeni ne ŋgua tukuŋa, ŋana kapono muli pa warakami nemi vetâŋa nâ. ");
INSERT INTO xsi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ŋana tu Mose muŋga iporo tu, ‘Noko ma kupono muli pa tina-tama kawanzi ŋgua. Ambo tamâta toŋge iporo ŋgua soki panzi tina-tama, ande kinzi katonâŋa ma sipu i pâta imâte’. ");
INSERT INTO xsi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Andeta miki uru kapanananzi tamâta ŋgua kie toŋge. Miki uru kaporo tu, ‘Ambo tamâta toŋge ne mbaliŋa keno ŋana isukanzi tina-tama, andeta ipainzi tu, “Mbaliŋa ŋine ande iloŋgu patea tu ma ao ilâ papa Maro Kindeni, kala ma avilami tia”, ande tamâta ŋinde iveta soki tia.’ ");
INSERT INTO xsi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Opopo, miki kaporo ŋgua soki mine nâ, kala kapono nzâla ŋana i ma ivetanzi tina-tama sondo. ");
INSERT INTO xsi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mine nde miki kalaŋa kapole Maro Kindeni ne ŋgua tukuŋa, aku koka timbumi nenzi vetâŋa muli nâ. Aku miki uru kapanananzi tamâta ŋana sipaveta kuku vetâŋa soki-soki rârâ mine nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu isarawanzi tamâta tu simâ kuku kilo, ŋineŋga ipainzi tu, “Miki rârâni kaloŋo naneŋgu ŋgua, aku ilomi patea sondo ŋga. ");
INSERT INTO xsi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kelekele ndia ikeno pa nia yo ŋineŋga ilâ pa tamâta ilo, ande ŋinde ikura tu iveta i ilo muso lâ Maro Kindeni nao, ande tia ndo. Aŋga ilo-kalo wa vetâŋa ndia ikeno tamâta ilo ŋineŋga iyâti imâ pa nia yo, ande ŋinde nâ iveta i ilo muso lâ Maro Kindeni nao.  ");
INSERT INTO xsi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ambo miki taŋami keno, ande kaloŋo ŋgua ŋine sondo.” ");
INSERT INTO xsi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu iporo ŋgua ŋine lâ, ŋineŋga ipilenzi ku ilâ luma ilo. Ŋineŋga i ne pâri-tamâta sikasoŋa i ŋana ŋgua tambirâŋa ŋinde ne duvi. ");
INSERT INTO xsi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Andeta Yesu ipainzi tu, “Opopo, miki warakami kala ilomi kalomi ipâŋga tia yo, a? Tiambo miki kasama ŋine tia tâ: kelekele ndia ikeno pa nia yo ŋineŋga ilâ pa tamâta ilo, ande ŋinde ikura tu iveta i ilo muso lâ Maro Kindeni nao, ande tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ŋana tu kelekele mine ŋandai ilâ tamâta ilo ŋga. Ŋinde ma ilâ kapwa ilo nâ, aku muli ma imbariŋa lâ.” (Yesu ne ŋgua ŋinde itula pwataki tu kâpwa rârâni nde ara ŋana taka kâ.) ");
INSERT INTO xsi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ŋineŋga Yesu iporo kilo tu, “Ilo-kalo wa vetâŋa ndia ikeno tamâta ilo ŋineŋga iyâti imâ pa nia yo, ande ŋinde nâ iveta tamâta ilo muso lâ Maro Kindeni nao. ");
INSERT INTO xsi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ŋana tu vetâŋa sakamao kie-kie iyoka pa tamâta ilo ku iyâti imâ pa nia yo. Mao nâ, kinzi tamâta nenzi ilo-kalo sakamao uru igagatinzi ŋana sipalulua tininzi potomule wa, sipanâwe wa, sipunzi tamâta pâta simâte wa, sipanawe tamâta kaiwanzi wa, ");
INSERT INTO xsi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ilonzi yosi ŋana tamâta nenzi kelekele wa, siveta mâsi potomule kie-kie wa, siporo ŋgua laŋeŋa tava ŋgua sakamao wa, sipadâda wa, situ tamâta laginanzi wa, siveta vetâŋa kapa-kapa wa. ");
INSERT INTO xsi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mao nâ, vetâŋa sakamao kie-kie ŋinde rârâni ipâŋga tamâta ilo ku iyâti imâ pa nia yo, aku vetâŋa mine nde iveta i ilo muso lâ Maro Kindeni nao.” ");
INSERT INTO xsi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu imandi ipile lawea ŋinde, aku iyoka ilâ pa Tair lawea, lâ tinikoa ŋgu toŋge nenzi tâno. Iyoka paveâŋa nâ ilâ luma toŋge ilo, ŋana tu i ilo tu ma imo simbo nâ ikura zo pinde. Andeta i parina nde isala nia ndoni lâ, kala ikura ŋana ipavea kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aku taine toŋge imo nia ŋinde, i natu taine nde koroani saka ipagagara lâ. Taine ŋinde iloŋo pâri tu Yesu imâ lâ, aku walele nâ imâ papa ku ipare tuku lâ Yesu kie tini laiti. ");
INSERT INTO xsi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Andeta taine ŋinde ŋandai Juda taine ŋga; i nde Grik taine, aku ipâŋga lâ Fonisia lawea ikeno pa Siria tâno kâ. Taine ŋinde ino kaika pa Yesu tu ma isoki koroani saka piti lâ i natu taine ilo. ");
INSERT INTO xsi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Andeta Yesu isia ŋgua papa tu, “Kinzi uru lâlu kapwanzi silanzi lâlu muŋga lâ ŋga. Ambo sikai lâlu kapwanzi ku siliŋi ilâ panzi mbwâmbwa, ande ŋine nde ara tia.” ");
INSERT INTO xsi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Andeta taine itu lâ Yesu kawa mine tu, “Tamâta ŋalae, noko kuporo mao nâ; ambo taitu kinzi mbwâmbwa uru sika kâpwa punu-punu ŋinde lâlu sika mbo iyauru indue ŋgili kulu ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ŋineŋga Yesu ipai taine tu, “Noko kawa ŋgua ŋinde nde ara ndo. Mine nde kutaulo kulâ. Koroani saka nde ipile noko natu ku ilâ lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aku taine nde itaulo ilâ luma kilo, aku mata ilâ imora natu ikeno moe kulu, ande koroani saka ipile i ku ilâ lâ. ");
INSERT INTO xsi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ŋinde ilâ lâ, ŋineŋga Yesu imandi ipile Tair lawea, aku ikatona nzâla ilâ pa Saidon lawea ilo. Ipâŋga ŋinde, ŋineŋga indue ilâ pa Galilaya lââ bwalika ŋgaŋe, aku ilâ ipâŋga Dekapolis tâno. ");
INSERT INTO xsi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ilâ ipâŋga lâ, ŋineŋga kinzi sikai tamâta toŋge taŋa pasâe wa mela-mela duvi kaika lâ, ku sikai simâ pa Yesu. Aku sino papa tu ma itaŋo tamâta ŋinde ŋana iveta i tini ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mine kala Yesu ikai tamâta ŋinde simbo nâ sipilenzi ŋgu ŋalae ku kinzi rua siyâti silâ. Ŋineŋga Yesu io mbau sili ilâ tamâta ŋinde taŋa ilo, aku isupwara veli-veli lâ mbau sili tini, ŋineŋga itaŋo tamâta mela-mela tona. ");
INSERT INTO xsi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ŋineŋga Yesu mata kâki pa samba ku iveta kusu lâ, ŋineŋga iporo tu, “Epata” (ŋgua ŋinde nde duvi mine, “Noko kupwa”). ");
INSERT INTO xsi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aku ndainani nâ tamâta ŋinde taŋa ipwa aku mela-mela duvi pao, kala iporo ŋgua pwataki. ");
INSERT INTO xsi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu indi kaika panzi tamâta tu ma sitapâri pa tamâta toŋge ŋana mâsi ŋinde kâ ndimo. Andeta tia; kinzi situ pâri ŋine aku isala nia ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kinzi pinde siloŋo aku wisinzi motutu, kala siporo tu, “Opopo, i ne vetâŋa rârâni nde ipâŋga ara nâ. Mao nâ, ivetanzi tamâta taŋanzi pasâe tu siloŋo ŋgua, aŋga ivetanzi tamâta kapa tu siporo ŋgua pwataki.” ");
INSERT INTO xsi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa zo ŋinde tamâta ŋgu ŋalae nde sipasau kilo, andeta kapwanzi ŋana sika kâ ikeno panzi tia. Mine kala Yesu isarawanzi ne pâri-tamâta tu simâ kuku, aku ipainzi tu, ");
INSERT INTO xsi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Naŋa kaloŋgu sukâŋa ŋalae ŋananzi tamâta ŋgu ŋalae ŋine, ŋana tu kinzi simo kuku naŋa ikura kari ŋato lâ, aku kapwanzi ŋana sika kâ ande sika marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ambo ma sika tia ku aonzi silâ pa nenzi lawea lawea, ande ma putole ipunzi ku ma patanzi lâ nzâla, ŋana tu kinzi pinde nde soka papa nia malawae simâ.” ");
INSERT INTO xsi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Andeta i ne pâri-tamâta siporo taulo tu, “Aŋga kinda ma takai puroŋa lâ nia ndia ŋana tasuanzi tamâta ŋgu ŋalae ŋine, a? Opopo, ŋine nde nia bilimu ma!” ");
INSERT INTO xsi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Andeta Yesu ikasoŋanzi tu, “Aŋga miki nde puroŋa ŋapia ikeno pami.” Ande kinzi siporo taulo tu, “Puroŋa lima kanaŋo rua nâ kala keno pama”. ");
INSERT INTO xsi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ŋineŋga Yesu ipainzi tamâta tu lambunzi ndue sisaŋona tâno kulu. Ŋineŋga ikai puroŋa kâki, kawa ndaŋge pa Maro Kindeni, ku ipwataki lâ, ŋineŋga ilanzi ne tamâta tu siwae panzi ŋgu. Aku kinzi sikai siwae panzi. ");
INSERT INTO xsi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aŋga kanzi iŋa kiri-kiri pinde kala keno tona. Mine nde Yesu ikai iŋa kala, kawa ndaŋge pa Maro Kindeni, ŋineŋga ilanzi ne pâri-tamâta tu siwae panzi tamâta tona. ");
INSERT INTO xsi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kinzi rârâni sika lee ikuranzi lâ, ŋineŋga Yesu ne pâri-tamâta sigona puroŋa wa iŋa katiŋe keno ŋinde lâ ŋgâmo ŋalae lima kanaŋo rua ilonzi pipi lâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kinzi tamâne ŋinde nâ kambwaŋenzi nde ipâŋga lâ 4,000. Ŋineŋga Yesu ionzi silâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aku walele nâ ikâki wâŋga kulu kunzi ne pâri-tamâta, aku simbwaliu silâ papa Dalmanuta tâno kâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kinzi Parisai tamâta pinde simâ sipâŋga lâ, aku siporo sipalelea ŋgua kuku Yesu. Kinzi situ sikai samâŋa papa, kala sino tu ma ikai Maro Kindeni ne walo ŋalae ku iveta mâsi kaika toŋge simora. ");
INSERT INTO xsi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu ipasama tu ilo malia, kala iveta kusu lâ. Ŋineŋga iporo tu, “Ŋana sâ kâ ŋga kinzi tamâta lâ zo ŋine sino tu ma simora mâsi kaika toŋge, a? Naŋa aporo mao nâ pami, naŋa ma aveta mâsi toŋge pami tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ŋineŋga ipilenzi ku ikâki wâŋga kulu kilo imbwaliu papa lââ bwalika tini pinde. ");
INSERT INTO xsi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu ne pâri-tamâta kalonzi kapa ŋana sikai kanzi puroŋa simâ, kala puroŋa taitu nâ ikeno panzi lâ wâŋga kulu. ");
INSERT INTO xsi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ande Yesu iporo ŋgua kaika panzi tu, “Miki kapakatona sondo ŋga. Kapakatona warakami ŋana kinzi Parisai wa Herot nenzi ‘yisi’.” ");
INSERT INTO xsi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ŋineŋga kinzi warakanzi siporo imâ naonzi nâ tu, “O, kinda ŋandai takai puroŋa ŋga, kala Yesu iporo ŋgua mine pa kinda.” ");
INSERT INTO xsi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Andeta Yesu isama lâ ŋana nenzi ilo-kalo soki ŋinde. Mine kala ipainzi tu, “Ŋana sâ kâ aŋga miki warakami kaporo mine tu, ‘Kinda takai puroŋa tia’, a? Tiambo miki ilomi kalomi tia tâ. Tiambo miki taŋami kaika tâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miki matami keno, andeta kamora ŋinde pwataki tia, a? Aŋga taŋami keno, andeta kaloŋo ŋgua tia, a? Miki kalomi kapa lâ, a? ");
INSERT INTO xsi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Muŋga, lâ zo ŋinde naŋa apwataki puroŋa lima awae panzi tamâne 5,000, ande kâpwa katiŋe sika tia ŋinde nde miki kagona lâ ŋgâmo ŋalae ŋapia ilonzi pipi.” Kinzi situ lâ kawa tu, “Ŋgâmo ŋalae saŋao kanaŋo rua.” ");
INSERT INTO xsi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ŋineŋga Yesu ikasoŋanzi kilo tu, “Aŋga lâ zo ŋinde naŋa apwataki puroŋa lima kanaŋo rua awae panzi tamâne 4,000, ande kâpwa katiŋe sika tia ŋinde nde miki kagona lâ ŋgâmo ŋalae ŋapia ilonzi pipi.” Kinzi siporo kilo tu, “Ŋgâmo ŋalae lima kanaŋo rua.” ");
INSERT INTO xsi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ŋineŋga Yesu ipainzi kilo tu, “Andeta miki kasama sondo tia yo, a?” ");
INSERT INTO xsi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kinzi soka silâ lee sipâŋga Betsaida lawea, ŋineŋga tamâta pinde sikai nenzi tamâta toŋge mata leva-leva simâ pa Yesu, aku sino papa tu ma itaŋo i ŋana iveta mata ipâŋga ara kilo. ");
INSERT INTO xsi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mine kala Yesu ikai tamâta mata leva-leva ŋinde mbalau, ku kinzi rua sipile lawea siyâti silâ pa nia yo. Ŋineŋga Yesu isupwara veli-veli lâ tamâta ŋinde mata, aku io mbau kâki lâ i kulu tava. Ŋineŋga ikasoŋa tu, “Noko kumora sâ tâ, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tamâta ŋinde nde mata pareŋge ku ipai Yesu tu, “Namoranzi tamâta pinde sitogo kâi mine, soka silâ wa simâ wa.” ");
INSERT INTO xsi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ŋineŋga Yesu io mbau lâ i mata kilo, aku tamâta ŋinde mata ara lâ, kala imora pwataki. Ŋineŋga imora kelekele rârâni ipâŋga nia yo. ");
INSERT INTO xsi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aku Yesu isupwa i ilâ pa ne luma, aku ipai tu, “Noko ma kutaulo kulâ lawea ilo ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ŋineŋga Yesu ikainzi ne pâri-tamâta simandi silâ pa lawea pinde ikeno Sisaria Pilipai lawea tini laiti. Soka nzâla yo, ande ikasoŋanzi tu, “Kinzi tamâta uru siporo situ naŋa nde ea.” ");
INSERT INTO xsi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ande sipai tu, “Pinde situ noko nde Yoane Lââ-Liliŋa Tamwata, aŋga pinde nde situ noko nde Ilia, aŋga pinde nde situ noko nde ŋgua-tulâŋa tamâta muŋgâŋa toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ŋineŋga Yesu ikasoŋanzi kilo tu, “Aŋga miki warakami katu naŋa nde ea.” Aku Petero ipai tu, “Noko nde Kirisi, Maro Kindeni ne Pateâŋa Tamâta.” ");
INSERT INTO xsi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ŋineŋga Yesu indi kaika panzi tu ma siporo situla i parina pwataki panzi tamâta pinde ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ŋineŋga Yesu ipanananzi ne pâri-tamâta tu, “Maro Kindeni ne pateâŋa ikeno tu naŋa Tamâta Natu ma akai nâna ŋalae. Aku kinzi katonâŋa wa patarawâŋa tamâta ŋalaŋala wa pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa, ande ma sipu mulinzi pa naŋa, ku ma sipu naŋa pâta amâte. Andeta kari ŋato lâ, ŋineŋga Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo.” ");
INSERT INTO xsi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu itula ŋgua ŋine pwataki ipâŋga nia yo panzi. Andeta Petero ikai Yesu siyâti silâ pa nia ŋgaŋe, aku ilelea Yesu ŋana i ne ŋgua ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Andeta Yesu ipupulia lâ ku mata ilea panzi ne pâri-tamâta, ŋineŋga imbita Petero, ipai tu, “Sadana, noko pwâwa kulâ malawae! Noko ŋandai kuporo ŋgua ikura Maro Kindeni ne ilo-kalo ŋga; noko pwoka kinzi tamâta nâ nenzi ilo-kalo muli.” ");
INSERT INTO xsi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ŋineŋga Yesu isarawanzi kinzi tamâta tu ma simâ papa i tavanzi ne pâri-tamâta, aku ipainzi tu, “Ambo tamâta toŋge ilo tu ipono muli pa naŋa, ande i ma ipatawa tamwata tini ku ikale ne kâi popole iyoka naŋa muliŋgu. ");
INSERT INTO xsi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ŋana tu tamâta ea ilo ŋalae ŋana tamwata ne via, ande i ma ikai via mao, ande tia. Aŋga tamâta ea kalo tawana naŋa tava kawâŋgu ŋgua ŋine, kala imora tamwata ne via tu kelekele kaa nâ, ande tamâta ŋinde ma imo via ku imo nâ. ");
INSERT INTO xsi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Miki kalomi ŋgere sondo ŋga; ambo tamâta toŋge igona tâno ne kelekele rârâni, ŋineŋga imâte, ande i ne via mao ikeno ndia, a? ");
INSERT INTO xsi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aku i ma ikura tu iko tamwata ne via kilo lâ mbumbu ŋapia, a? Tia ndo! ");
INSERT INTO xsi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mao nâ, kinzi tamâta uru siveta mâsi potomule wa kiesaka kie-kie. Andeta tamâta ea mai ŋana naŋa tava kawâŋgu ŋgua, ande muli naŋa Tamâta Natu kala ma maiŋgu ŋana i mine nâ, lâ zo ŋinde naŋa ma ayoka tava Mama ne walo ŋalae amâ kunzi aŋelo sapâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ŋineŋga Yesu ipainzi tu, “Naŋa aporo mao nâ pami. Miki pinde kala kamo ŋai ma kamâte tia yo yo, ande ma kamora Maro Kindeni ikai maro panzi tamâta lâ tâno kulu tava walo ŋalae.” ");
INSERT INTO xsi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kari lima kanaŋo taitu ilâ lâ, ŋineŋga Yesu ikainzi Petero, ŋga Yamesi, ŋga Yoane, aku sikâki silâ tuu ŋalae toŋge kulu. Aku kinzi ŋapa simbonzi nâ simo ndaina. Ŋineŋga kinzi simora Yesu tini pasinala, aku ipâŋga kie toŋge. ");
INSERT INTO xsi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aku i ne pasawaŋa tini sinala nia, aku pâne ndo. Tamâta toŋge lâ tâno kulu ikura tu iveta pasawaŋa pâne mine tia. ");
INSERT INTO xsi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ŋineŋga Ilia ku Mose rua simâ sipâŋga, aku kinzi pâri-tamâta matanzi ilâ simoranzi ŋgua-tulâŋa tamâta muŋgâŋa rua ŋinde siporo kuku Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero imora mâsi ŋinde, ku ipai Yesu tu, “Pananâŋa, kinda tamo ŋaina, aku ŋine nde ara ndo. Maka iloma tu ma kapa pâla ŋato; noko ne toŋge, aŋga Mose ne toŋge, aŋga Ilia ne toŋge.” ");
INSERT INTO xsi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kinzi pâri-tamâta nde siruru pâta lâ, kala Petero ilo iroto ŋgua kala ikai iporo nâ. ");
INSERT INTO xsi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Andeta take-take ŋalae toŋge ipâŋga ku ituranzi lâ. Aku sarawâŋa toŋge iyoka pa take-take ilo imâ mine tu, “Naŋa natuŋgu ara kala ŋine. Naŋa tiniŋgu mwasa papa i. Miki ma katambira taŋami pa i ne ŋgua.” ");
INSERT INTO xsi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aku walele nâ matanzi ilâ wa imâ wa, andeta simora tamâta toŋge tia. Yesu simbo nâ imo kunzi. ");
INSERT INTO xsi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kinzi sipile tuu, aku soka sindue yo, ŋineŋga Yesu indi kaika panzi tu, “Miki ma katapâri pa tamâta toŋge ŋana mâsi kala muŋga nâ kamora ŋinde ndimo. Andeta muli ŋga, lâ zo ŋinde naŋa Tamâta Natu ma amandi lâ mateŋa nianzi amo viâŋgu kilo, ŋineŋga katapâri panzi tamâta.” ");
INSERT INTO xsi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aku kinzi sikai ŋgua ŋine kaika. Andeta sipakasoŋa warakanzi tu, “Ŋgua ŋine iporo tu ma imandi imo via kilo, ande ŋinde nde duvi mana.” ");
INSERT INTO xsi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mine kala sikasoŋa i tu, “Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru situla Ilia parina tu i ma imâ muŋga lâ, ŋineŋga Kirisi ma imâ. Ŋinde nde duvi mana.” ");
INSERT INTO xsi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ande Yesu ipainzi tu, “Ŋgua ŋinde nde mao nâ; Ilia imâ muŋga ŋana iveta kelekele rârâni sondo. Mine nde mana mana ŋga kinzi ŋgua-tulâŋa tamâta siŋgere ŋgua ikeno lâ pepa tini tu naŋa Tamâta Natu ma akai nâna ŋalae, aku tamâta ma siveta kenzi sakamao pana, a? ");
INSERT INTO xsi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Taitu kala ŋine naŋa apaimi tu Ilia nde imâ ipâŋga lâ, aku mâsi sakamao rârâni kinzi situ siveta papa i, ande siveta lâ, ikura ŋgua ŋinde kinzi ŋgua-tulâŋa tamâta muŋgâŋa siŋgere ikeno lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu ikainzi ne pâri-tamâta ŋato ŋinde ku sindue silâ lee sipâŋga panzi nawalanzi pâri-tamâta, ande simora tu tamâta ŋgu ŋalae nde sipasau simo kunzi. Aku kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ pinde nde simo sipawa ŋgua kunzi. ");
INSERT INTO xsi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kinzi tamâta rârâni simora tu Yesu ŋga imâ lâ, aku walele nâ ilonzi igagatinzi ku simandi sipalilu simâ papa. ");
INSERT INTO xsi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aku Yesu ikasoŋanzi tu, “Miki kapawa ŋgua mana kunzi.” ");
INSERT INTO xsi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aku tamâta toŋge iporo taulo tu, “Pananâŋa, naŋa natuŋgu tamâne toŋge koroani saka isae i kawa ku ipagagara lâ, kala naŋa akai amâ pa noko. ");
INSERT INTO xsi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ikura zo rârâ koroani saka ŋinde ikai i kaika, aku itambira indue tâno kulu. Aku kawa maka ipâŋga ku niŋo giri lâ, ku tini kaika nâ. Aku naŋa ano panzi noko ne pâri-tamâta tu ma sisoki koroani saka piti, andeta sikura tia.” ");
INSERT INTO xsi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu iloŋo ŋgua ŋinde ku iporo tu, “Opopo, miki kalomi tawana tia ndo! Naŋa ma amo ku miki ikura zo ŋapia kilo, a? Aŋga miki nemi ilo-kalo soki-soki ma iveta naŋa iloŋgu malia ikura zo ŋapia kilo, a? Kakai lâlu kamâ pana!” ");
INSERT INTO xsi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aku kinzi sikai lâlu ŋinde simâ papa. Andeta koroani saka imora Yesu, ku irurua lâlu yâti taulo. Mine kala lâlu pata ndue tâno kulu ku pulia mbwaliu mbwaliu, aku kawa maka ipâŋga. ");
INSERT INTO xsi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ŋineŋga Yesu ikasoŋa tama tu, “I imo mine ikura zo ŋapia.” Ande iporo tu, “Muŋgani, i kiri-mwata yo, ande koroani saka ipagagara i. ");
INSERT INTO xsi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aku zo rârâ koroani saka ŋinde itambira i lâ yââ kulu wa lââ ilo wa, itu ma ipu pâta imâte. Ambo noko pwura tu kuvilama, ande kalo sukâŋa ŋanama ku kuvilama.” ");
INSERT INTO xsi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Andeta Yesu ipai tu, “Ŋana sâ kâ ŋga noko kuporo tu, ‘Ambo noko pwura’, a? Ambo tamâta toŋge kalo tawana naŋa, ande vetâŋa ndia i ilo tu Maro Kindeni ma iveta papa, ande Maro Kindeni ikura tu iveta vetâŋa ŋinde rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aku walele nâ lâlu ŋinde tama isarâwa tu, “Naŋa kaloŋgu tawana, ambo taitu naneŋgu kalo-tawana nde peko mwata nâ. Kuvila naŋa!” ");
INSERT INTO xsi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu imoranzi tamâta ŋgu ŋalae tina sipalilu simâ. Mine kala imbita koroani saka ipai tu, “Noko koroani saka ŋana kuveta kawa wa taŋa pasâsâe, naŋa aporo kaika pano tu kupile lâlu ŋine kulâ, aku kutaulo kumâ papa i kilo ndimo!” ");
INSERT INTO xsi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aku koroani saka ŋinde itara sakamao ku irurua lâlu yâti taulo, ŋineŋga ipile i ilâ. Aku lâlu imo itogo mateŋa mine, kala tamâta rârâ siporo tu, “Opopo, imâte lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Andeta Yesu ikai i mbau ku igagati imandi sânda lâ, ku imandi. ");
INSERT INTO xsi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ŋineŋga Yesu ilâ luma ilo, aku ne pâri-tamâta simbonzi nâ simâ papa ku sikasoŋa tu, “Muŋga maka katogo tu kasoki koroani saka ŋinde piti, andeta kurama tia. Ŋinde nde duvi mana.” ");
INSERT INTO xsi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ande Yesu ipainzi tu, “Noŋa nâ ma ikura tu isoki koroani saka mine piti. Nzâla toŋge ikeno tia.” ");
INSERT INTO xsi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kinzi sipile lawea ŋinde ku soka silâ sipâŋga Galilaya tâno ŋgini. Aku Yesu tini pwâka tu kinzi tamâta ma sisama tu i imo ŋinde, ");
INSERT INTO xsi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ŋana tu iveta wurâta ŋana ipanananzi ne pâri-tamâta. Aku ipainzi tu, “Kinzi ma sio naŋa Tamâta Natu lâ tamâta pinde mbaunzi ilo, aku ma sipu naŋa pâta amâte. Andeta kari ŋato lâ, ŋineŋga Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo.” ");
INSERT INTO xsi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Andeta kinzi sisama ŋgua ŋine duvi kilala tia, aku siruru tu sikasoŋa Yesu tu ma itula ŋine pwataki panzi. ");
INSERT INTO xsi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kinzi soka silâ lee sipâŋga Kaperneam lawea, aku silâ luma ilo. Ŋineŋga Yesu ikasoŋanzi ne pâri-tamâta mine tu, “Lâ nzâla, ande miki kapawa ŋgua mana.” ");
INSERT INTO xsi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Andeta kinzi kawanzi buu nâ, mainzi, ŋana tu lâ nzâla kinzi sipawa ŋgua tu ea imo mbâna-mbâna panzi. ");
INSERT INTO xsi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mine kala Yesu isaŋona ku isarawanzi ne pâri-tamâta saŋao kanaŋonzi rua tu simâ, aku ipainzi tu, “Ambo tamâta toŋge itu imo mbâna-mbâna, ande nzâla ikeno mine; i ma imo tamâta rârâni kalonzi, itogo nenzi kuleŋa tamâta mine.” ");
INSERT INTO xsi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iporo mine lâ, ŋineŋga ikai lâlu toŋge ku iŋgunu imandi ŋgininzi. Ŋineŋga ikai lâlu kâki isaŋona i kie kulu, ku ipainzi tu, ");
INSERT INTO xsi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ambo tamâta toŋge kalo tawana naŋa kala iveta kie ara pa lâlu mota toŋge itogo lâlu ŋai, ande i ma iveta kie ara pa naŋa tava. Aŋga tamâta ea iveta kie ara pa naŋa, ande iveta kie ara pa naŋa nâ tia; iveta kie ara pa Maro Kindeni tona, ina isupwa naŋa kala amâ.” ");
INSERT INTO xsi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ŋineŋga Yoane ipai Yesu tu, “Pananâŋa, maka muŋga kamora tamâta toŋge ikai wurâta ŋana ipatu noko ŋa ku isokinzi koroani saka piti lâ tamâta ilonzi. Andeta i ŋandai kinda nawalânda ŋga. Mine kala maka kandi kaika papa tu ma iveta mine kilo ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Andeta Yesu ipainzi tu, “Miki ma kandi kaika pa tamâta ŋinde ndimo. Kalomi ŋgere sondo ŋga; ambo tamâta toŋge ipatu naŋa ŋâŋgu ku iveta mâsi kaika, ande i ma ikura tu iporo isowe ŋgua sakamao lâ naŋa tiniŋgu walele, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ŋana tu tamâta ea ikai kazâŋa pa kinda tia, ande tamâta ŋinde nde kinda nenda mete. ");
INSERT INTO xsi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Naŋa aporo mao nâ pami; ambo tamâta toŋge isama tu miki kapono muli pa naŋa, kala ilo patea tu ma iveta kie ara pami kala iliŋi lââ lâ kâmba ilo ilami, ande muli Maro Kindeni ma kulu ilua tamâta ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ambo tamâta toŋge ma iyaula i tini pinde ne kalo-tawana kala ipu muli pa naŋa, ande ŋinde nde mâsi sakamao ndo. Ara ŋana kinzi nia ndoyo ma sipa mira ŋalae toŋge lâ tamâta ŋinde ŋandola tâ ku ma sitambira indue tâi geza-geza ilo mbo inu tâi mbo imâte tâ. Ŋana tu ambo kinzi muŋga siveta mine, ande i ma ikura tu iyaula i tini pinde ne kalo-tawana, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ambo noko mbalau toŋge ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kutoto ŋinde piti lâ. Ambo noko mbalau taitu nâ, ande ŋinde nde ara koŋa tia; andeta muli noko ma kumo via ku kumo nâ. Taitu kuloŋo ŋga; ambo noko mbalau rua, andeta muli Maro Kindeni ma itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo kanaŋo. Sâ toŋge ikura tu ipupu yââ ŋinde ne mela-mela, ande tia.  ");
INSERT INTO xsi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lâ nia ŋinde nde mwâta-mwâta simo tininzi sikanzi, andeta simâte tia. Aŋga yââ ŋinde ma marumbu tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aku mine nâ, ambo noko kie ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kutoto ŋinde piti lâ. Ambo noko kie taitu nâ, ande ŋinde nde ara koŋa tia; andeta muli noko ma kumo via ku kumo nâ. Taitu kuloŋo ŋga; ambo noko kie rua, andeta muli Maro Kindeni ma itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo kanaŋo.  ");
INSERT INTO xsi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lâ nia ŋinde nde mwâta-mwâta simo tininzi sikanzi, andeta simâte tia. Aŋga yââ ŋinde ma marumbu tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aku mine nâ, ambo noko mata ilaŋeno kala kuveta kiesaka, ande ara ŋana noko ma kupasiki mata ŋinde piti kutambira lâ. Ambo noko mata taitu nâ, ande ŋinde nde ara koŋa tia; andeta muli noko ma kumo via ku kumo nâ. Taitu kuloŋo ŋga; ambo noko mata rua, andeta muli Maro Kindeni ma itambirano kulâ yââ ŋalae ne mbââ ilo, ande ŋinde nde ara tia ndo kanaŋo. ");
INSERT INTO xsi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lâ nia ŋinde nde mwâta-mwâta simo tininzi sikanzi, andeta simâte tia. Aŋga yââ ŋinde ma marumbu tia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ŋana tu yââ ma ilâ panzi tamâta rârâni, itogo tâi kinda uru taliŋi lâ kâpwa kulu mwasina. ");
INSERT INTO xsi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tâi nde kelekele ara. Andeta kalomi ŋgere sondo ŋga; ambo tâi ne makisa marumbu lâ, ande vetâŋa toŋge ikeno ŋana tamâta ma siveta ne makisa ipâŋga kilo, ande tia. Ara ŋana tâi ma ikeno ŋginimi, aku ara ŋana miki ma kamo ilomi kalomi taitu kunzi nimi-nambwe.” ");
INSERT INTO xsi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu imandi ipile Kaperneam lawea, ku iyoka ilâ pa Judia tâno ikeno pa Jodan Lââ tini pinde. Aku tamâta rârâ nde simâ sipasau kuku i kilo. Mine kala ipanananzi Maro Kindeni kawa ŋgua, ikura uru iveta mine. ");
INSERT INTO xsi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aku kinzi tamâta pinde lâ Parisai ŋgu nde simâ pa Yesu. Kinzi situ sikai samâŋa papa, kala sikasoŋa tu, “Ambo tamâta toŋge itu isoki kaiwa taine, ande ŋgua tukuŋa isâu papa tu ma iveta mine, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ande Yesu iporo taulo tu, “Aŋga Mose itula ŋgua tukuŋa mana pami.” ");
INSERT INTO xsi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kinzi sipai tu, “Mose isâu ŋana tamâne tu ambo iŋgere ŋgua lâ pepa tini ŋana itoto pakâeŋa kâ, aku pepa ilua kaiwa taine, ande nenzi pakâeŋa nde totoŋa lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aku Yesu iporo tu, “Miki nde taŋa-kaika tamwatami. Mine kala Mose iŋgere tukuŋa ŋinde pami. ");
INSERT INTO xsi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Andeta nia ndoyo, lâ zo ŋinde Maro Kindeni ipulia samba wa tâno wa, ande ‘ipulianzi tamâta ku ionzi taine wa tamâne wa’. ");
INSERT INTO xsi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mine nde tamâne ma ipilenzi tina-tama ku ma ipasipa kuku kaiwa taine, ");
INSERT INTO xsi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aku kinzi rua ma simo tininzi lâ taitu.’ Mine nde kinzi rua ŋandai simo piti piti ŋga; kinzi rua ma simo togo ilonzi wa karaenzi taitu nâ. ");
INSERT INTO xsi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mao nâ, Maro Kindeni ipanzi rua lâ taitu lâ; mine nde tamâta toŋge ma itikianzi piti ndimo.” ");
INSERT INTO xsi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu iporo ŋgua ŋine lâ, ŋineŋga kinzi sitaulo silâ luma ilo. Ande kinzi pâri-tamâta sikasoŋa Yesu kilo ŋana pakâeŋa kâ. ");
INSERT INTO xsi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aku ipainzi tu, “Ambo tamâne toŋge isoki kaiwa taine ku ikai taine wasaseki toŋge, ande tamâta ŋinde iveta sakamao kuku kaiwa taine wasaseki ŋinde, kala ilaŋa ipole ŋgua tukuŋa. ");
INSERT INTO xsi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aku mine nâ, ambo taine toŋge ipile kaiwa tamâne ku ikai tamâne wasaseki toŋge, ande taine ŋinde iveta sakamao kuku kaiwa tamâne wasaseki ŋinde, kala ilaŋa ipole ŋgua tukuŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kinzi tamâta pinde sikainzi lâlu kiri-kiri simâ pa Yesu. Kinzi ilonzi tu ma io mbau kâki kulunzi tu ma itu nzâmbe panzi. Andeta kinzi pâri-tamâta sileleanzi. ");
INSERT INTO xsi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu imora ŋinde, ku ilo kura tia, kala ipainzi ne pâri-tamâta tu, “Miki ma kasâu panzi lâlu kiri-kiri tu simâ pa naŋa; kapono nzâla ŋananzi ndimo. Ŋana tu Maro Kindeni uru ikai maro panzi tamâta ea nenzi kalo-tawana irerege kuku lâlu kiri-kiri ŋine nenzi kalo-tawana. ");
INSERT INTO xsi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Naŋa aporo mao nâ pami; kinzi lâlu kiri-kiri ŋine uru ilonzi ndo keno pa naŋa. Ambo tamâta toŋge ilo keno mine tia, ande i ma ikura tu imo Maro Kindeni ne ŋgumbi ilo, ande tia ndo.” ");
INSERT INTO xsi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ŋineŋga Yesu ikotinzi lâlu lâ kie kulu, ku isuŋa mbau itaŋo kinzi taitu-taitu kulunzi, ku itu nzâmbe panzi. ");
INSERT INTO xsi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu imandi ku iyoka ilâ, andeta tamâta toŋge ipalilu imâ, ipare tuku papa ku ikasoŋa tu, “Pananâŋa ara, naŋa ma aveta mana ŋga ikura tu amo viâŋgu ku amo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu ipai tu, “Ŋana sâ kâ ŋga noko kusarawa naŋa tu ‘ara’, a? Maro Kindeni simbo nâ nde Ara Tamwata. ");
INSERT INTO xsi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Noko kusama ŋgua tukuŋa rârâni: ‘Noko ma kupu tamâta pâta ndimo; noko ma kuveta sakamao kuku tamâta toŋge kaiwa ndimo; noko ma kupanâwe ndimo; noko ma kusowe ŋgua laŋeŋa lâ tamâta tininzi lâ ŋgua nia ndimo; noko ma pwai laŋeŋa ku pwai tamâta nenzi kelekele saŋenzi ndimo; aku noko ma kumege ŋananzi tina-tama ku taŋa mwasa nâ panzi’.” ");
INSERT INTO xsi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aku tamâta ŋinde ipai Yesu tu, “Pananâŋa, lâ zo ŋinde naŋa lâlu kiri-mwata yo, aku amo lee ikura lâ zo ŋine, ande naŋa uru apaveta kuku ŋgua tukuŋa ŋine rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu mata ilea pa tamâta ŋinde ku tini mwasa papa, kala ipai tu, “Vetâŋa taitu nâ nde noko kuveta tia yo. Noko kulâ, aku kuo ne kelekele rârâni ilâ panzi tamâta tu siko. Ŋineŋga pwai mbumbu ŋinde aku kulanzi kinzi sugorai tamwatanzi. Ambo noko ma kuveta mine, ande noko ma kumo ara ndo lâ samba lawea. Aku kumâ, kupono muli pa naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Andeta tamâta ŋinde iloŋo ŋgua ŋine, ku nao mata ipâŋga sakamao, ku iyoka tava ilo malia nâ ilâ, ŋana tu i nde mbaliŋa warika. ");
INSERT INTO xsi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ŋineŋga Yesu mata ileanzi ne pâri-tamâta ku ipainzi tu, “Ambo kinzi mbaliŋa warakanzi situ simo Maro Kindeni ne ŋgumbi ilo, ande ŋine nde wurâta ŋalae panzi.” ");
INSERT INTO xsi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aku kinzi pâri-tamâta wisinzi motutu ŋana i ne ŋgua ŋine. Andeta Yesu itu ŋgua kilo ku ipainzi tu, “Miki lâlu kiri-kiri, ambo tamâta itu imo Maro Kindeni ne ŋgumbi ilo, ande ŋine nde wurâta ŋalae tina! ");
INSERT INTO xsi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mao nâ, ambo ŋgoa ŋalae ‘kamel’ itu itambwa ilâ mbiri kiri-mwata ne maa ilo, ande i ma ikura tu iveta mine tia. Aku mine nâ, ambo mbaliŋa warika itu imo Maro Kindeni ne ŋgumbi ilo, ande ŋine nde wurâta ŋalae tina.” ");
INSERT INTO xsi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kinzi pâri-tamâta nde wisinzi motu pâta, kala sipakasoŋa warakanzi tu, “Opopo, ambo mine, ande ea ikura tu ikai via mao ŋana imo ara mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aku Yesu mata ilea kaika panzi, ku iporo tu, “Kinzi tamâta warakanzi nâ ma sikura tia; aŋga Maro Kindeni nde ikura lâ. Mao nâ, Maro Kindeni ikura tu iveta vetâŋa rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ŋineŋga Petero ipai Yesu tu, “Ayo, maka muŋga kapile nema kelekele ndoni ŋana kapono muli pa noko!” ");
INSERT INTO xsi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ande Yesu iporo tu, “Naŋa aporo mao nâ pami; tamâta ea kinzi ilonzi pa naŋa kala silâ situla pâri ara, ambo sipile nenzi luma wa mota-ŋala wa mwanenzi wa tinanzi wa tamanzi wa natunzi wa nenzi tâno wa, ");
INSERT INTO xsi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ande Maro Kindeni ma itu kilo panzi ŋana ŋinde kâ mbwani rârâ ŋinde. Mao nâ, lâ zo ŋana kinzi simo tâno kulu yo, ande kinzi ma sikai luma rârâ wa mota-ŋala rârâ wa mwanenzi rârâ wa tinanzi rârâ wa natunzi rârâ wa tâno ŋalae wa. Andeta ŋinde nâ tia; kinzi tamâta pinde ma siveta kenzi sakamao ndo panzi tava. Aku lâ zo muli, ŋineŋga kinzi ma sikai via mao, ma simo ara mine ku simo nâ. ");
INSERT INTO xsi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ande kinzi tamâta rârâ muŋga simo tamâta ŋalaŋala lâ tâno kulu, ande kinzi ŋinde ma muli simo tamâta kaa nâ. Aŋga kinzi tamâta rârâ muŋga simo tamâta kaa nâ lâ tâno kulu, ande kinzi ŋinde ma muli simo tamâta ŋalaŋala.” ");
INSERT INTO xsi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ikainzi ne pâri-tamâta ku soka nzâla sikâki silâ pa Jerusalem lawea. Yesu nde imbâmba iyoka imuŋga panzi. Mine kala kinzi pâri-tamâta ilonzi rârâ, aŋga kinzi tamâta soka mulinzi ŋinde nde siruru. Ŋineŋga Yesu ikainzi ne pâri-tamâta saŋao kanaŋonzi rua silâ pa nia ŋgaŋe kilo, ku iporo panzi ŋana vetâŋa rârâ nao laiti ŋana ipâŋga papa i kâ. ");
INSERT INTO xsi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ipainzi tu, “Ayo, kala ŋine kinda takâki talâ pa Jerusalem. Aku tamâta toŋge ma io naŋa Tamâta Natu lâ kinzi patarawâŋa tamâta ŋalaŋala wa pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa mbaunzi ilo. Aku kinzi ma sio naŋa lâ ŋgua nia, ku ma sipa ŋgua ŋana sipu naŋa pâta amâte. Aku muli, ŋineŋga ma sio naŋa alâ kinzi tinikoa mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aku kinzi tinikoa ma siporo ŋgua pavaligiŋa pa naŋa wa sisupwara tiniŋgu wa sipalili naŋa lâ, ŋineŋga ma sipu naŋa pâta amâte. Andeta kari ŋato lâ, ŋineŋga ma amandi amo viâŋgu kilo.” ");
INSERT INTO xsi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yesu iporo mine lâ, ŋineŋga Sebedi natu rua Yamesi ku Yoane rua nde simâ papa ku sipai tu, “Pananâŋa, maka rua katu kakasoŋano ŋana vetâŋa toŋge, aku iloma tu noko ma kuveta mine pama.” ");
INSERT INTO xsi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ande Yesu ikasoŋanzi tu, “Miki rua ilomi tu naŋa ma aveta sâ tâ pami.” ");
INSERT INTO xsi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aku kinzi rua sipai tu, “Mwaŋga, lâ zo ŋinde noko ma kupâŋga pwai koipu ŋalae, ŋineŋga maka rua iloma tu ma kasaŋona noko tini laiti, toŋge pa mbau wia kâ, aŋga toŋge pa mbau ŋâsi kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Andeta Yesu isia ŋgua ku ipainzi tu, “Miki rua kazizâla ŋana vetâŋa ŋine kala kakasoŋa naŋa ŋana. Naŋa ma muli anu lââ makisa ikeno kâmba toŋge ilo. Tiambo miki rua kala kakura tu kanu lââ ŋinde, tiya? Aku miki kakura tu kakai lââ-liliŋa ŋinde naŋa ma muli akai, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aku kinzi rua sipai tu, “Maka rua kurama.” Ŋineŋga Yesu ipainzi tu, “Mao nâ, lââ makisa naŋa ma anu ŋinde, ande miki rua kala ma kanu tona. Aku naneŋgu lââ-liliŋa ŋinde, ande miki rua kala ma kakai mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ambo taitu pateâŋa ŋana tamâta ea ma isaŋona tiniŋgu laiti pa mbauŋgu wia kâ ŋga pa mbauŋgu ŋâsi kâ, ande ŋinde ikeno pa naŋa tia. Maro Kindeni tamwata simbo nâ ma iwae saŋonâŋa nia panzi tamâta ea muŋga ipateanzi ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kinzi nawalanzi pâri-tamâta saŋao nde siloŋo ŋine, kala wisinzi nâna panzi Yamesi ku Yoane rua. ");
INSERT INTO xsi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Andeta Yesu isarawanzi tu simâ, ku ipainzi tu, “Miki kasama tu kinzi tamâta pinde uru sikai koipu panzi tinikoa ŋgu, aku kinzi tamâta ŋalaŋala ŋinde uru siveta malia kie-kie panzi ŋgu ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Andeta mâsi mine ma ikeno miki ŋginimi ndimo. Ambo tamâta toŋge itu imo tamâta ŋalae lâ ŋginimi, ande nzâla ikeno mine; i ma imo nemi kuleŋa tamâta. ");
INSERT INTO xsi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aku tamâta ea itu imo mbâna-mbâna pami, ande nzâla ikeno mine; i ma imo wurâta tamâta kaa nâ panzi tamâta rârâni. ");
INSERT INTO xsi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ŋana tu naŋa Tamâta Natu ŋandai amâ ŋana kinzi tamâta ma sikai kuleŋa pa naŋa ŋga. Naŋa amâ ŋana akai kuleŋa panzi tamâta, aku ma amâte ŋana akainzi tamâta rârâ piti lâ kondoma ilo.” ");
INSERT INTO xsi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ŋineŋga kinzi silâ sipâŋga Jeriko lawea. Soka lee, aku laiti ŋana sipile Jeriko kâ, aku kinzi pâri-tamâta sitavanzi tamâta ŋgu ŋalae nde soka kuku Yesu silâ. Andeta tamâta toŋge, i ŋa mine Bartimeus, nde isaŋona nzâla ŋgaŋe. I mata leva-leva, kala uru isarâwa mbumbu wa kelekele panzi tamâta. ");
INSERT INTO xsi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tamâta ŋinde iloŋo ŋgua tu Yesu Nasarete tamwata ŋga iyoka imâ, kala isarâwa kaika tu, “Yesu, Daviti ne vâsa noko, kalo sukâŋa ŋanana!” ");
INSERT INTO xsi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Andeta kinzi tamâta rârâ simbita sipai tu, “Wa, noko kawa buu!” Andeta isarâwa kawa kâki ŋalae tu, “Daviti ne vâsa, kalo sukâŋa ŋanana!” ");
INSERT INTO xsi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aku Yesu imandi ku iporo tu, “Kasarâwa pa tamâta ŋinde tu imâ.” Aku kinzi sisarâwa pa tamâta mata leva-leva ŋinde ku sipai tu, “Wa, ilo kaika kumandi sânda ŋga! Isarâwa pano.” ");
INSERT INTO xsi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ŋineŋga tamâta ŋinde ikai ne pasawaŋa luandondo piti, ku walele nâ imandi imâ pa Yesu. ");
INSERT INTO xsi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aku Yesu ikasoŋa tu, “Noko ilo tu naŋa ma aveta mana pano.” Aku tamâta mata leva-leva ipai tu, “Pananâŋa, naŋa iloŋgu tu matâŋgu amora nia.” ");
INSERT INTO xsi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aku Yesu ipai tu, “Noko kulâ. Noko ne kalo-tawana ivetano ara lâ.” Aku walele nâ i mata ara lâ, ku imora nia. Aku iyoka Yesu muli lâ nzâla ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kinzi silâ sipâŋga Jerusalem lawea tini laiti, aku sipâŋga Betfasi lawea wa Betani lawea wa, lâ Oliv Tuu waŋgira. Aku Yesu isupwanzi ne pâri-tamâta rua, ");
INSERT INTO xsi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ku ipainzi tu, “Miki rua kalâ pa lawea ndai ikeno naomi ŋinde, aku kalâ lawea ŋinde ilo. Aku walele nâ miki ma kamora ‘donki’ natu toŋge kinzi sisine lâ imandi. Tamâta toŋge muŋga isaŋona donki ŋinde kumbu, ande tia. Kayaute wâlo piti, ku kakai kamâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ambo tamâta toŋge ma ikasoŋami tu, ‘Ŋana sâ kâ ŋga miki rua kaveta mine, a?’, ande miki ma kapai tu, ‘Maro Ŋalae ne wurâta nde ikeno papa, aku mwaŋga i ma walele nâ io taulo imâ kilo’.” ");
INSERT INTO xsi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ŋineŋga kinzi rua silâ, aku simora donki natu kinzi muŋga sisine imandi nia yo lâ luma toŋge ne nzâla tini. Aku kinzi rua siyaute wâlo piti lâ donki tini. ");
INSERT INTO xsi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Andeta tamâta pinde simandi laiti, aku sikasoŋanzi tu, “Ayo, miki rua kaveta mana ŋga kayaute donki natu ŋinde, a?” ");
INSERT INTO xsi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aku kinzi siporo ŋgua taulo panzi ikura Yesu muŋga itula panzi mine, aku kinzi tamâta ŋinde sisâu panzi rua tu sikai donki silâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ŋineŋga kinzi sikai donki natu ŋinde simâ pa Yesu. Aku siliŋi nenzi pasawaŋa luandondo kâki donki kumbu, ku Yesu isaŋona kulu. ");
INSERT INTO xsi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aŋga kinzi tamâta rârâ nde siŋga nenzi pasawaŋa luandondo lâ nzâla. Aŋga pinde nde silâ tâno ilo ku sitoto tumba lau ku sikai simâ silalaga lâ nzâla tava, ŋana Yesu ma iyoka kulu kâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aku kinzi tamâta pinde nde silâ simuŋga panzi, aŋga pinde nde soka i muli, ande rârâni sindeka sisarâwa tu, “Paneâŋa pa âta! Maro Kindeni itu nzâmbe pa koipu ŋalae ŋine ikai i ndamwa kala imâ! ");
INSERT INTO xsi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mao nâ, Maro Kindeni itu nzâmbe pa tamâta ŋine kala imâ ikai koipu itogo timbunda Daviti mine! Tapanea Maro Kindeni i âta Tamwata!” ");
INSERT INTO xsi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kinzi soka mine lee sipâŋga Jerusalem lawea, aku Yesu ilâ Maro Kindeni ne luma sapâŋa ilo ku mata imora ilâ wa imâ wa, ku imora kelekele rârâni keno luma sapâŋa ilo. Andeta kari ŋga indue pararai lâ. Mine kala Yesu itaulo ilâ pa Betani lawea kunzi ne pâri-tamâta saŋao kanaŋonzi rua. ");
INSERT INTO xsi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aku mbwale kilo, ŋineŋga kinzi simandi sipile Betani lawea ku soka sitaulo silâ pa Jerusalem kilo, andeta Yesu nde putole ipu. ");
INSERT INTO xsi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I mata ilâ imora kâi ‘fik’ toŋge imandi malawae mwasa, aku lau ŋani-ŋani ŋalae ŋinde, kala ilâ laiti tu iroto kanaŋo. Aku ilâ papa kâi, andeta imora tu kanaŋo toŋge keno tia; lau nâ ikeno, ŋana tu zo ŋana ‘fik’ tu ipula kanaŋo kâ nde ipâŋga tia yo. ");
INSERT INTO xsi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tia ku Yesu iporo pa kâi ŋinde mine tu, “Noko ma kupula kanaŋo kilo tia ndo!” Aku kinzi pâri-tamâta siloŋo ne ŋgua ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kinzi silâ lee sipâŋga Jerusalem lawea. Aku Yesu ilâ pa Maro Kindeni ne luma sapâŋa ku iŋaranzi mbaliŋa warakanzi simo sipako kelekele lâ nia ŋinde. Itili peke lâ kinzi tamâta ŋana sipalulua mbumbu kâ, aŋga itili paŋgi lâ kinzi tamâta siveta wurâta ŋana sipako sii ŋana patarawâŋa kâ tava. ");
INSERT INTO xsi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ŋineŋga indi kaika panzi tu ma sikai kelekele kie-kie simâ luma sapâŋa ne ŋgumbi ilo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aku ipainzi tu, “Maro Kindeni kawa ŋgua ikeno mine tu, “‘Naneŋgu luma nde ma kinzi sipatu ŋa tu, “Kinzi ŋgu ndoni nenzi luma ŋana noŋa kâ’”, aŋga miki nde kaveta ŋine ipâŋga itogo kinzi nzanzare tamâta nenzi munâŋa nia mine!” ");
INSERT INTO xsi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aku kinzi patarawâŋa tamâta ŋalaŋala ŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ nde siloŋo ŋgua ŋinde, kala siroto nzâla ŋana ma sipu i pâta imâte kâ. Andeta kinzi siruru ŋana i kâ, ŋana tu kinzi tamâta rârâni nde wisinzi motutu ŋana i kawa ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aku kari indue lala lâ, ŋineŋga Yesu ikainzi ne pâri-tamâta sipile Jerusalem lawea ku siyâti silâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aku wurita mboyo, ŋineŋga kinzi soka silâ, aku simora kâi ‘fik’ ŋinde tu lau tava mburu-mburu ndoni nde ŋgâla-ŋgâla marumbu lâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ŋineŋga Petero kalo ŋgere ku iporo tu, “Pananâŋa, kumora ŋga! Nola noko kutu ŋgua kaika pa kâi ŋine, kala ŋgâla-ŋgâla lâ!” ");
INSERT INTO xsi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aku Yesu iporo taulo panzi tu, “Miki kao nemi kalo-tawana ilâ pa Maro Kindeni nâ. ");
INSERT INTO xsi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Naŋa aporo mao nâ pami, ambo tamâta toŋge kalo tawana sondo, ku isupwa tuu ŋai mine tu, ‘Noko kumandi kupatiki kundue tâi ilo’, ambo tamâta ŋinde ilo rua-rua tia, i kalo tawana nâ kala iporo, ande Maro Kindeni ma iveta mâsi ŋinde ipâŋga, ikura tamâta ŋinde iporo mine. ");
INSERT INTO xsi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ambo miki kano pa Maro Kindeni, aku kalomi tawana ku kaporo lâ ilomi tu, ‘Mao nâ, i ma iveta ikura naneŋgu noŋa mine’, ande mao nâ, i ma iveta mine. ");
INSERT INTO xsi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Andeta miki kaloŋo ŋga; lâ zo ŋana miki kano pa Maro Kindeni, ambo miki kalomi ŋgere ŋana vetâŋa soki toŋge tamâta toŋge muŋga iveta pami, ambo miki ma kazavaru tamâta ŋinde ne soki piti lâ tini, ande miki Tamami imo samba ilo kala ma iveta mine nâ pa miki.  ");
INSERT INTO xsi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Taitu mambo miki kazavaru tamâta ŋinde ne soki piti lâ tini tia, ande Tamami imo samba ilo kala ma izavaru nemi kiesaka piti lâ tinimi tia mine nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kinzi soka silâ sipâŋga Jerusalem lawea kilo, aku Yesu ilâ Maro Kindeni ne luma sapâŋa ne ŋgumbi ilo. Ŋineŋga kinzi patarawâŋa tamâta ŋalaŋala wa kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ wa kinzi katonâŋa, ande simâ papa i. ");
INSERT INTO xsi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aku sikasoŋa tu, “Wa, noko pwai ea ndamwa kala kuveta mâsi kie-kie mine, a? Aŋga ea wurâta ŋine ilano, a?” ");
INSERT INTO xsi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Andeta Yesu ipainzi tu, “Ara, naŋa kala atu akasoŋami kasoŋâŋa toŋge. Ambo miki ma kaporo ŋgua sondo itaulo imâ, ande naŋa ma aporo pwataki pami ŋana akai ea ndamwa ŋga aveta vetâŋa ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ŋineŋga ikasoŋanzi tu, “Muŋga, lâ zo ŋinde Yoane Lââ-Liliŋa Tamwata iveta wurâta ŋana ililinzi tamâta, ande ea wurâta ŋinde ilua i. Miki ilomi tu Maro Kindeni wurâta ŋinde ilua i, tiya?, i tamwata nâ ilo patea tu ma iveta. Miki kaporo imâ pa naŋa ŋga!” ");
INSERT INTO xsi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Andeta kinzi siporo ŋgua lâ warakanzi ŋgininzi tu, “Ambo kinda ma taporo taulo tu, ‘Maro Kindeni isupwa Yoane tu iveta wurâta ŋinde’, ande i ma iporo pa kinda tu, ‘Mine kala ŋana sâ kâ ŋga miki ŋandai kalomi tawana Yoane ne ŋgua, a?’ ");
INSERT INTO xsi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ambo kinda ma taporo taulo tu, ‘Yoane tamwata nâ ilo patea tu ma iveta wurâta ŋinde’, ande kinzi tamâta ma wisinzi nâna ŋalae pa kinda.” (Kinzi siruru ŋananzi tamâta, ŋana tu kinzi rârâni situ Yoane nde Maro Kindeni ne ŋgua-tulâŋa tamâta mao.) ");
INSERT INTO xsi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tia ku kinzi siporo ŋgua taulo pa Yesu tu, “Maka kasama tia.” Ŋineŋga Yesu ipainzi tu, “Ara, naŋa kala ma aporo ŋgua toŋge pami tia ŋana akai ea ndamwa amâ kala aveta vetâŋa ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aku Yesu iporo ŋgua tambirâŋa panzi mine tu, “Tamâta toŋge ipâu tâno waini toŋge, aku ipa ŋgumbi ŋana. Aku iveta wewe lâ tâno ilo itogo kondo ŋana sipale waini kanaŋo tu punu-punu kâ, aku ipa pâla toŋge ŋana tamâta ma simo ilo sio ŋana tâno kâ. Aku tâno nde io lâ tamâta pinde mbaunzi ilo ŋana sikatona ku sikai wurâta ŋana mbumbu kâ lâ tini. Ŋineŋga tâno warika ŋinde ilâ pa nia malawae toŋge. ");
INSERT INTO xsi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Imo lee, aku zo laiti ŋana waini ma ipula kanaŋo kâ. Ŋineŋga isupwa ne wurâta tamâta toŋge ilâ pa tâno waini ŋinde ŋana ikai waini kanaŋo pinde, ikura muŋga sipa ŋgua tu ma silua i. ");
INSERT INTO xsi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Andeta kinzi sikai tâno warika ne wurâta tamâta ŋinde kaika ku sipu pâta lâ, aku sio iyoka mbau kaa nâ itaulo ilâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ŋineŋga tâno warika isupwa wurâta tamâta toŋge kilo ilâ panzi. Andeta kinzi sipu i kulu pwataki ku siveta kenzi sakamao papa. ");
INSERT INTO xsi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ŋineŋga tâno warika isupwa wurâta tamâta toŋge kilo, andeta sipu tamâta ŋinde pâta imâte. Aku isupwanzi wurâta tamâta rârâ kilo mine nâ, andeta kinzi sipunzi rârâni, aŋga pinde nde sipunzi pâta simâte lâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Isupwanzi ne wurâta tamâta rârâni marumbu lâ. Ŋineŋga tâno warika kalo ŋgere ŋana tamâta taitu nâ i ŋandai isupwa ilâ panzi ŋga. Ŋinde nde i natu taituni nâ, aku i ilo ndo keno papa. Mine kala isupwa natu ŋinde ilâ panzi tamâta uru siveta wurâta lâ tâno waini ilo. I itu mine, ‘Kinzi ma simege ŋana natuŋgu.’ ");
INSERT INTO xsi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Andeta kinzi tamâta uru siveta wurâta lâ tâno ŋinde nde siporo lâ warakanzi ŋgininzi tu, ‘Wa, tamâta ndai ma muli ikai tama ne mbaliŋa ndoni. Ayo, ŋine ma tapu pâta imâte, ande kinda warakânda ma takai i ne tâno ŋine.’ ");
INSERT INTO xsi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Siporo ŋgua ŋine lâ, aku marumbu; mbaunzi ilâ sikai natu ŋinde ku sipu pâta imâte. Aŋga i karae nde sisia yâti tâno ŋgaŋe.” ");
INSERT INTO xsi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu itambira ŋgua mine panzi lâ, ŋineŋga ikasoŋanzi tu, “Ayo, tâno waini warika ma iveta mana. I ma imâ ku ma izavarunzi tamâta muŋga siveta wurâta lâ tâno ŋinde, ku ma tâno ŋinde ilanzi tamâta pinde ŋana sikatona kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ŋineŋga Yesu ipainzi tamâta ŋalaŋala ŋinde tu, “Tiambo miki ŋandai kapono Maro Kindeni ne ŋgua ikeno lâ pepa tini mine tu, ‘Mira ŋine kinzi tamâta ŋana sipa luma kâ situ nde sakamao kala sitambira lâ, ande mirani ndaina ipâŋga mira ara ŋana isuka luma ŋgaŋe kaika kâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maro Kindeni tamwata iveta vetâŋa ŋinde ipâŋga lâ, kala kinda tamora ŋinde tu ara pâta kanaŋo’.” ");
INSERT INTO xsi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu iporo ŋgua ŋine lâ, aku lâ zoni ndaina kinzi tamâta ŋalaŋala situ ma sikale Yesu kaika ku sio lâ luma sakamao ilo, ŋana tu sisama tu Yesu itambira ŋgua ŋinde iyoke kinzi warakanzi nâ. Andeta siruru ŋananzi tamâta, kala ŋandai siveta mine ŋga. ");
INSERT INTO xsi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Aku muli, ŋineŋga kinzi tamâta ŋalaŋala sisupwanzi Parisai tamâta pinde sitavanzi Herot ne tamâta pinde simâ pa Yesu. Kinzi ilonzi patea tu ambo i ma iporo ŋgua pinde ŋgâsi tâ, ande ma sio i ilâ pa ŋgua nia. ");
INSERT INTO xsi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kinzi simâ pa Yesu ku sipai tu, “Pananâŋa, maka kasama tu noko nde tamâta ŋana kuporo ŋgua mao kâ. Noko uru kuporo ŋgua taituni panzi tamâta ŋalaŋala wa kinzi sugorai tamwatanzi wa. Noko ŋgua mao nâ uru kupanananzi tamâta ŋana Maro Kindeni ne vetâŋa kâ. Mine kala maka katu kakasoŋano mine: ‘Noko ilo mana; nenda Koipu Ŋalae Kaisara uru iporo kaika tu kinda ma mbumbu talua. Ayo, Mose ne ŋgua tukuŋa isâu tu kinda ma mbumbu talua Kaisara, tiya? Ma tako, tiya?’” ");
INSERT INTO xsi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Andeta Yesu isama kinzi kilalanzi pwataki tu kinzi nde laŋeŋa tamwatanzi. Mine kala ipainzi tu, “Ŋana sâ kâ ŋga miki kakai samâŋa pa naŋa, a? Kakai mbumbu toŋge kamâ ku katula pana.” ");
INSERT INTO xsi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aku kinzi sikai mbumbu toŋge simâ. Ŋineŋga Yesu ikasoŋanzi tu, “Tai wa ŋoa ŋine kala ikeno mbumbu tini, ande ea ne.” Aku siporo tu, “Kaisara ne.” ");
INSERT INTO xsi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ande Yesu ipainzi tu, “Mine kala Kaisara ne kelekele, ande miki kalua Kaisara. Aŋga Maro Kindeni ne kelekele, ande kalua Maro Kindeni.” Aku kinzi wisinzi motutu ŋana Yesu ne ŋgua ŋinde kâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ŋineŋga kinzi tamâta pinde lâ Sadyusi ŋgu nde simâ pa Yesu. Kinzi ŋgu ŋinde uru kalonzi tawana tu kinzi mateŋa tamâta ma muli simandi simo vianzi kilo, ande tia. Kinzi situ siveta kapa-kapa pa Yesu kala sipai tu, ");
INSERT INTO xsi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Pananâŋa, Mose muŋga iŋgere ŋgua tukuŋa toŋge imâ pa kinda mine tu, ‘Ambo tamâta toŋge i natu tia ku imâte, ambo i kaiwa taine imo ŋai yo, ande tamâta ŋinde tai ma ikai tua kaiwa, aku kinzi rua ma sipulia lâlu itogo tua kilala mine’.” ");
INSERT INTO xsi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Siporo ŋgua ŋine lâ, ŋineŋga sisia ŋgua pa Yesu mine tu, “Ayo, tamâne nzâla-kulu toŋge i tai lima kanaŋo taitu simo. Nzâla-kulu ŋinde ikai kaiwa taine toŋge, andeta mwaŋga i tamwata imâte lâ, aku i natu toŋge tia. ");
INSERT INTO xsi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mine kala i tai iyoka tua muli ku ikai taine ŋinde itogo kaiwa mine. Andeta i kala natu tia, ku imâte. Ŋineŋga i tai kala iveta mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Siveta mine lee, aku kinzi tai rârâni sikai taine taituni ŋinde, ku kinzi kala natunzi tia, ku simâte lâ. Aku muli ŋga taine kala imâte. ");
INSERT INTO xsi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ayo, lâ zo muli, ambo kinzi mateŋa tamâta ma simandi simo vianzi kilo, ande taine ŋinde ma imo ea kaiwa lâ kinzi tai-tua lima kanaŋonzi rua ŋinde. Noko kusama tu kinzi rârâni muŋga sikai kaiwanzi taitu ŋinde.” ");
INSERT INTO xsi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Andeta Yesu ipainzi tu, “Opopo, miki kasama Maro Kindeni ne ŋgua ikeno lâ pepa tini, ande tia. Aku miki kazizâla ŋana i ne walo kaika mine nâ. Mine kala miki kaveta ŋgua palaŋeŋa rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lâ zo ŋana kinzi mateŋa tamâta ma simandi simo vianzi kilo, ande kinzi ma simo sitogonzi aŋelo lâ samba ilo mine, kala ma sipakâe tia. ");
INSERT INTO xsi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Andeta naŋa atu aporo ŋgua toŋge pami ŋana kinzi mateŋa tamâta nenzi mandiŋa kâ. Mose muŋga iŋgere ŋgua tapâriŋa ŋana kâi kiri-mwata yââ kana, andeta miki ŋandai kapono ŋgua ŋinde ŋga, a? Lâ tapâriŋa ŋinde Maro Kindeni ipai Mose tu, ‘Naŋa nde Abraham ŋga Isaka ŋga Yakopu nenzi Maro Ŋalae’. ");
INSERT INTO xsi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ayo, ŋgua ŋinde itula pa kinda tu Maro Kindeni ŋandai kinzi mateŋa tamâta nenzi Maro Ŋalae ŋga. I imo Maro Ŋalae panzi tamâta simo vianzi ŋinde, ŋana tu lâ i nao kinzi tamâta rârâni simo vianzi nâ. Opopo, miki nemi ilo-kalo nde soki ndo.” ");
INSERT INTO xsi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ŋineŋga pananâŋa tamâta ŋana ŋgua tukuŋa kâ toŋge nde kala imâ, aku iloŋonzi sipawa ŋgua. Iloŋo Yesu iporo ŋgua kanaŋo nâ taulo panzi, kala ikasoŋa Yesu tu, “Ŋgua tukuŋa ndia nde ipolenzi tukuŋa rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ande Yesu iporo taulo tu, “Ŋgua tukuŋa taitu nde kala ŋine: ‘Miki Isrel ŋgu kaloŋo! Maro Kindeni nde nenda Maro, aku i simbo nâ nde Maro Ŋalae. ");
INSERT INTO xsi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Noko ma tini mwasa ndo pa noko ne Maro Kindeni, aku kuo noko ilo ndoni wa koroani ndoni wa ilo kalo ndoni wa ne walo ndoni ilâ pa i simbo nâ.’ ");
INSERT INTO xsi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aŋga ŋgua tukuŋa iyoka ŋinde muli, ande mine: ‘Noko ma tini mwasa panzi tini pinde, itogo noko tini mwasa pa tamwata mine.’ Ŋgua tukuŋa toŋge nde ŋalae ku ipolenzi rua ŋine, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aku pananâŋa tamâta ŋinde ipai Yesu tu, “Pananâŋa, noko kuporo ŋgua mao. Mao nâ, Maro Kindeni simbo nâ nde Maro Ŋalae, aku toŋge irerege kuku i, nde tia. ");
INSERT INTO xsi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aku kinda ma tininda mwasa ndo papa i lâ ilonda wa nenda ilo-kalo wa nenda walo ndoni wa. Aku kinda ma tininda mwasa panzi tininda pinde itogo tininda mwasa pa warakânda mine. Ambo kinda ma toka tukuŋa rua ŋine muli, ande mâsi ŋine nde ma ara ndo lâ Maro Kindeni nao, ipole patarawâŋa ndoni kinzi uru simomo lâ yââ, tava patarawâŋa kie-kie rârâni.” ");
INSERT INTO xsi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu iloŋo tamâta ŋinde iporo ŋgua ara, itogo kinzi ilo-kalo tamâta uru siporo mine. Mine kala ipai tu, “Laiti ŋana noko ne kalo-tawana ipâŋga sondo kâ.” Aku kinzi tamâta rârâni simege ŋana Yesu, ku ilonzi patea tu ma sikai samâŋa mine papa i kilo, ande ma tia. ");
INSERT INTO xsi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu imo Maro Kindeni ne luma sapâŋa ne ŋgumbi ilo ku ipanananzi tamâta. Aku ipainzi tu, “Kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ uru siporo tu, ‘Kirisi nde timbunda Daviti natu’. Andeta ŋgua ŋinde nde duvi mana, a? ");
INSERT INTO xsi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ŋana tu nanayoni Koroani Sapâŋa itula ilo-kalo pa Daviti, kala Daviti tamwata iporo tu, ‘Maro Kindeni itu ŋgua pa naneŋgu Maro Ŋalae mine tu, “Noko kusaŋona ŋai pa mbauŋgu wia kâ lee, ikura lâ zo ŋinde naŋa ma aonzi noko ne kazâŋa tamâta simo noko kalo”.’ ");
INSERT INTO xsi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ayo, Daviti tamwata ipatu Kirisi ŋa tu Maro Ŋalae. Mine nde mana mana ŋga kinzi siporo tu Kirisi nde Daviti ne vâsa nâ, a?” Aku kinzi tamâta ŋgu ŋalae nde sindeka ŋana siloŋo Yesu ne ŋgua. ");
INSERT INTO xsi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aku Yesu ipanananzi mine tu, “Miki kapakatona sondo ŋana kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ nenzi vetâŋa. Kinzi ilonzi tu sisawa pasawaŋa luandondo ŋana sipasuka warakanzi tininzi kâ, ku soka silâ. Aku ilonzi tu kinzi tamâta ma simege ŋananzi ku ma siporo panzi lâ ao ŋgini tu, ‘O, tamâta ŋalae, kari ara!’ ");
INSERT INTO xsi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aku kinzi ilonzi tu sisaŋona lâ tamâta naonzi lâ luma ŋana pasauŋa kâ ilo, aku ilonzi pa saŋonâŋa nia arara lâ kâŋa-nuŋa ŋalaŋala nia tava. ");
INSERT INTO xsi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kinzi uru sikai laŋeŋa panzi taine mwala, aku sipanawe nenzi luma. Aku kinzi uru sipasuka warakanzi tininzi ku sikai noŋa luandondo ŋana kinzi tamâta ma simoranzi. Andeta muli, lâ zo ŋinde Maro Kindeni ma ipare nia panzi tamâta, ande kinzi ma sikai nâna ŋalae tina.” ");
INSERT INTO xsi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu isaŋona patarawâŋa nia tini laiti lâ luma sapâŋa ilo, aku mata ilâ imoranzi tamâta sio mbumbu lâ pinze ilo. Aku kinzi mbaliŋa warakanzi rârâ nde sio mbumbu rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Andeta ŋineŋga sugorai taine mwala toŋge imâ ku io mbumbu kiri-kiri rua nâ indue pinze ilo. ");
INSERT INTO xsi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ŋineŋga Yesu isarawanzi ne pâri-tamâta tu simâ, aku ipainzi tu, “Naŋa aporo mao nâ pami; sugorai taine mwala ŋine io mbumbu ŋalae tina, ipole mbumbu kinzi tamâta rârâni muŋga sio lâ pinze ilo. ");
INSERT INTO xsi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ŋana tu kinzi rârâni nenzi mbumbu rârâ keno panzi, aku sio pinde nâ ilâ pinze ilo. Aŋga taine ŋine nde imo sugorai ndo, andeta io ne mbumbu ndoni, kala i ne mbumbu toŋge ikeno ŋana iko kapwa kâ, ande tia.” ");
INSERT INTO xsi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ipile Maro Kindeni ne luma sapâŋa ku iyâti ilâ, ŋineŋga i ne pâri-tamâta toŋge ipai tu, “Pananâŋa, kumora mira ŋalaŋala wa luma arara ŋai!” ");
INSERT INTO xsi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Andeta Yesu iporo taulo tu, “O, noko kumoranzi luma ŋalaŋala ŋine, a? Naŋa apaino tu kinzi kazâŋa tamâta ma sipile luma ŋine ne mira toŋge ikeno mira toŋge kulu tia ndo. Kinzi ma sisapira rârâni iyauru bururu ndue lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ikâki isaŋona Oliv Tuu kulu. Aŋga Maro Kindeni ne luma sapâŋa ikeno pa nao. Ŋineŋga Petero, ŋga Yamesi, ŋga Yoane, ŋga Andaria nde simâ papa ku sikasoŋa tu, ");
INSERT INTO xsi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Maka katu kasama ŋine; mâsi ŋinde ma ipâŋga lâ zo ndia. Aŋga mâsi ndia ma ipâŋga muŋga ŋana itula pwataki tu mâsi ŋalaŋala ŋinde ŋga nao laiti ŋana ipâŋga kâ.” ");
INSERT INTO xsi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ŋineŋga Yesu itula ŋgua pwataki panzi tu, “Miki kapakatona sondo ŋga. Tia ma tamâta toŋge ilaŋemi. ");
INSERT INTO xsi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ŋana tu kinzi tamâta rârâ ma simâ ku sipatu naŋa ŋâŋgu, ku ma siporo tu, ‘Naŋani tamwatâŋgu kala i’, aku ma sikai laŋeŋa panzi tamâta rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aku miki ma kaloŋo paraŋa ŋalaŋala ne nduŋeŋani imâ laiti, aku ma kaloŋo ŋgua ŋana paraŋa ŋalaŋala pinde ipâŋga nia malawae tona. Andeta miki ma tinimi ruru ndimo. Ŋinde ma imâ ipâŋga, aŋga zo ŋalae ŋana tâno ŋine ne zo marumbu kâ nde ipâŋga tia yo. ");
INSERT INTO xsi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kinzi tamâta lâ lawea pinde ma simandi sikai kazâŋa panzi tamâta lâ lawea pinde, aŋga ŋgu pinde ma sikai kazâŋa panzi ŋgu pinde. Ogigi ma iririŋo tâno pinde yâti taulo, aku putole ŋalae ma ipâŋga lâ tâno pinde. Mâsi ŋine rârâni ma ipâŋga muŋga, itogo nâna uru ipâŋga panzi taine kâpwa kâpwa ku itula pwataki tu paguguŋa ne zoni nde imâ ipâŋga laiti lâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Andeta miki kapakatona warakami sondo ŋga. Ŋana tu kinzi ma sikaimi kaika ku siomi lâ ŋgua nia, ku ma sipalilimi lâ luma ŋana pasauŋa kâ ilo. Aku ma siŋgunumi kamandi lâ kinzi koipu ŋalaŋala wa tamâta mbâna-mbâna wa naonzi, ŋana tu miki nemi kalo-tawana ikeno pa naŋa. Andeta vetâŋa ŋinde nde itogo nemi nzâla ŋana kaporo katula pâri ara panzi tamâta ŋalaŋala ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Andeta Maro Kindeni ne pateâŋa ikeno tu kinzi tamâta pinde ma silâ situla pâri ara panzi tamâta simo tâno ndoni muŋga lâ ŋga, kala kinzi tamâta rârâni ma siloŋo. ");
INSERT INTO xsi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aku lâ zo ŋana kinzi ma sipa miki kaika ŋana siomi kalâ pa ŋgua nia, ande miki ma karuru ndimo, aku kalomi loko ŋana ŋgua ndia miki ma kaporo taulo panzi, mine ndimo. Ŋana tu Maro Kindeni ma itula ŋgua pami lâ zo ndainani nâ ŋana kaporo yâti. Mine nde ŋandai miki warakami nâ ma kaporo ŋga; Koroani Sapâŋa ma itula ŋgua pwataki lâ kawami. ");
INSERT INTO xsi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pa zo ŋinde kinzi tamâta ma sionzi ninzi-nambwe silâ kazâŋa tamâta mbaunzi ilo, ŋana ma sipunzi pâta simâte kâ. Aku kinzi tamâne kala ma siveta mine nâ panzi natunzi. Aku kinzi lâlu kala ma sikai kazâŋa panzi tinanzi tamanzi mine nâ, ku ma sionzi silâ kazâŋa tamâta mbaunzi ilo ŋana sipunzi pâta simâte kâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mao nâ, kinzi tamâta rârâni ma wisinzi nâna ŋalae tina pami, ŋana tu nemi kalo-tawana ikeno pa naŋa. Aŋga tamâta ea imandi kaika lee zo sakamao ŋinde marumbu lâ, ande Maro Kindeni ma via mao ilua i, ma imo via mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aku Yesu ipainzi ne pâri-tamâta tu, “Miki ma kamora vetâŋa sakamao ndo ipâŋga iveta muso ŋalae lâ nia ŋinde tuŋa kaika ikeno ŋana.” (Noko tamâta ea kupono ŋgua ŋine, ande kalo ŋgere sondo ŋana kusama duvi kâ.) “Pa zo ŋinde, ara ŋana kinzi tamâta simo Judia tâno ŋinde ma sikâwa silâ pa nia tuu. ");
INSERT INTO xsi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ambo toŋge imo ne luma mende kulu, ande ara ŋana i ma indue ku ikâwa nâ ilâ; i ma ilâ luma ilo ŋana ikai ne kelekele toŋge ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ambo toŋge imo ne tâno ilo, ande i ma itaulo ilâ luma ilo ŋana ikai ne pasawaŋa luandondo ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Opopo, lâ zo ŋinde kalo-sukâŋa ŋalae tina ma ilâ panzi taine kâpwa kâpwa wa kinzi taine ŋinde natunzi simo suu tini yo. ");
INSERT INTO xsi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ara ŋana miki ma kano kaika tu mâsi ŋinde ma ipâŋga lâ mâo ne zo tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lâ zo ŋinde, malia ŋalae tina ma ipâŋga. Nia ndoyo, lâ zo ŋinde Maro Kindeni ipulia samba wa tâno wa kelekele rârâni sipâŋga lâ, aku imâ lee ipâŋga lâ zo ŋine, ande malia kie-kie mine muŋga ipâŋga tia ndo. Aku muli kala malia kie-kie mine ma ipâŋga kilo, nde tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ambo Maro Kindeni ma io zo luandondo ŋana malia kie-kie ŋinde, ande kinzi tamâta rârâni ma sipamateteu marumbu lâ. Andeta i ilo ndo keno panzi tamâta muŋga ipateanzi ŋinde, kala ma io zo ŋinde mbuku taitu nâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pa zo ŋinde, ambo tamâta toŋge ipaimi tu, ‘Kamora ŋga, Kirisi imo ŋai’, tâku ‘Imo ndai’, ande miki ma kalomi tawana ŋgua ŋinde ndimo. ");
INSERT INTO xsi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ŋana tu lâ zo ŋinde, kinzi ‘Kirisi’ laŋeŋa rârâ aŋga ŋgua-tulâŋa tamâta laŋeŋa rârâ ma sipâŋga, ku ma siveta mâsi kie-kie pinde sitogo tu silaŋenzi ku siyaulanzi tamâta ŋinde Maro Kindeni muŋga ipateanzi ŋinde. Andeta kinzi ma sikura tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Naŋa aporo atula vetâŋa ŋine pwataki pami lâ, aku mao kanaŋo, vetâŋa mine ma muli ipâŋga. Mine nde miki kapakatona sondo ŋga.” ");
INSERT INTO xsi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ŋineŋga Yesu iporo kilo tu, “Mâsi wa malia ŋalae tina ŋinde ma ipâŋga marumbu lâ, ŋineŋga ‘kari mata ma ipâŋga ŋaŋa, aŋga nzimona ma ipane nia kilo tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Aŋga pitu ma simbe piti lâ samba tini, aŋga samba ne siŋgâra kaika rârâni ma silâ wa simâ wa.’ ");
INSERT INTO xsi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ŋineŋga kinzi tamâta ma simora naŋa Tamâta Natu amo take-take toŋge ŋgini amâ tava walo ŋalae, aku ma simora naŋa kilalâŋgu pwataki tu naŋa nde Maro Ŋalae. ");
INSERT INTO xsi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lâ zo ŋinde naŋa ma aonzi naneŋgu aŋelo silâ sigonanzi naneŋgu tamâta rârâni muŋga apateanzi ŋinde. Mao nâ, kinzi aŋelo ma silâ sikura nia ndoni lâ tâno kulu ŋana sigonanzi naneŋgu tamâta ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Miki kalomi ŋgere ŋana kâi pâla-pâla kâ, ŋana tu ŋinde ma isukami ŋana kasama naneŋgu ŋgua ŋine duvi. Lâ zo ŋana kâi pâla-pâla irumba ku lau wasaseki ipâŋga, ande miki kasama tu kari ne zo ŋga imâ ipâŋga laiti lâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aku mine nâ, ambo miki ma kamora mâsi ŋinde rârâni ipâŋga lâ, ŋineŋga ma kasama tu tâno ŋine ne zo ŋga laiti ŋana marumbu kâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Naŋa aporo mao nâ pami; kinzi tamâta simo lâ zo ŋine ma simâte tia yo, ŋineŋga mâsi ŋinde rârâni ma imâ ipâŋga lâ. ");
INSERT INTO xsi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mao nâ, samba wa tâno wa ma marumbu lâ, aŋga naŋa kawâŋgu ŋgua nde ma marumbu tia ndo, ma ikeno mine ku imo nâ.” ");
INSERT INTO xsi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ŋineŋga Yesu iporo tu, “Tamâta toŋge isama zo ndia wa kari tai ŋapia naŋa ma ataulo amâ kilo, ande tia. Kinzi aŋelo lâ samba ilo sisama ŋine tia, aku naŋa Maro Kindeni Natu tamwatâŋgu kala asama ŋine tia. Mama simbo nâ isama. ");
INSERT INTO xsi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mine nde kapakatona sondo ŋga, ŋana tu miki kasama naneŋgu zo ŋana ataulo amâ kilo kâ, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ŋinde itogo tamâta ŋalae toŋge ipile ne luma ku iyoka ilâ pa nia toŋge. Aku ipainzi ne wurâta tamâta tu ma sikatona i ne kelekele sondo, ŋineŋga iwae wurâta panzi taitu-taitu. Aku ipai tamâta uru ikatona luma ne nzâla ŋinde tu ma io tini sondo ndo. ");
INSERT INTO xsi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mine nde miki kala kao tinimi sondo ndo, ŋana tu miki kasama ŋana zo ndia luma warika ma itaulo imâ kilo, ande tia. Tiambo i ma itaulo imâ lâ lala tâku mbo ŋgini-ŋgini tâku mbwale mbwale kâ tâku mbwale pwataki tâ; ande miki kasama tia. ");
INSERT INTO xsi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mine nde kao tinimi sondo ku kamo nâ. Tia ma i imâ walele nâ, aku ma imora tu miki kakeno. ");
INSERT INTO xsi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ŋgua ŋine naŋa aporo pa miki, ande kala aporo panzi tamâta rârâni mine nâ tu, ‘Miki ma kao tinimi sondo ku kamo nâ’.” ");
INSERT INTO xsi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma wurita lâ mbwale mauru, ŋineŋga Juda nenzi zo sapâŋa ŋana sika puroŋa ne yisi tia ma ipâŋga. Kinzi sipatu kumbwa ŋinde ŋa tu Pasova. Aku kinzi patarawâŋa tamâta ŋalaŋala ŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ nde siporo tu, “Kinda ma taveta mana ŋga ma talaŋe Yesu ku takai kaika tapu pâta imâte.” ");
INSERT INTO xsi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Andeta kinzi siporo tu, “Kinda ma taveta ŋinde lâ zo sapâŋa tia. Tia ma kinzi tamâta wisinzi nâna ku siŋgoloa paraŋa, ku ma sipara potomule.” ");
INSERT INTO xsi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu imandi ilâ pa Betani lawea, aku imo Saimon ne luma ilo. Saimon nde tamâta toŋge muŋga ikai pukoŋa tini saga-saga, andeta ŋineŋga tini mbâra-mbâra kilo. Yesu isaŋona peke tini tu ma ika kâ, andeta taine toŋge ikai ne mira belo ara toŋge, samimi kuwae ara pâta ikeno ilo, ku ikai imâ pa Yesu. Samimi ŋinde nde kulu ŋalae tina. Aku taine ipu belo samimi ŋinde kawa pwataki, ku ipaliŋi samimi lâ Yesu kulu. ");
INSERT INTO xsi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Taitu kinzi tamâta pinde simora ŋinde ku ilonzi kura tia ndo. Kinzi siporo pa warakanzi tu, “Opopo, ŋana sâ kâ ŋga ipaliŋi samimi ŋine iyaula kaa nâ, a? ");
INSERT INTO xsi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ambo kinda muŋga takai samimi ŋinde talanzi tamâta tu siko tâ, ande kinda ma takura tu takai kulu ŋalae ŋinde, aku mbumbu ŋinde ma talanzi sugorai tamwatanzi. Andeta tia.” Aku simbita taine ŋinde pâta. ");
INSERT INTO xsi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Andeta Yesu ipainzi tu, “Ŋana sâ kâ ŋga miki kaveta malia pa taine ŋine, a? Iveta mâsi ara ndo pa naŋa. ");
INSERT INTO xsi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋana tu kinzi sugorai tamâta ma simo kumi ikura zo zo. Mine kala lâ zo ndia miki katu kasukanzi, ande kasukanzi. Aŋga naŋa ma amo soŋgo kuku miki, ande tia. ");
INSERT INTO xsi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vetâŋa kala taine ikura tu iveta, ande iveta lâ. Ipaliŋi samimi lâ naŋa karaeŋgu ŋana iveta sondo ŋana alâ pa kuru nia kâ. ");
INSERT INTO xsi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Naŋa aporo mao nâ pami; lâ tâno ndia muli mbo kinzi ma situla pâri ara ŋana naŋa kâ, ande kinzi ma situla vetâŋa taine ŋine iveta ŋinde tona, ŋana kinzi tamâta ma kalonzi ŋgere ŋana i wa.” ");
INSERT INTO xsi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ŋineŋga kinzi pâri-tamâta saŋao kanaŋonzi rua nawalanzi toŋge, i ŋa tu Judas Iskariot, ande ilâ panzi patarawâŋa tamâta ŋalaŋala. I itu ma ikai kulu-pâŋga ŋana Yesu kâ panzi. ");
INSERT INTO xsi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kinzi siloŋo ŋgua ŋine ku sindeka pâta, ŋineŋga sipa ŋgua kaika ŋana mbumbu pinde ma silua i. Ŋineŋga Judas ilâ ku iroto nzâla toŋge ŋana ma io Yesu lâ mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ŋineŋga zo sapâŋa ŋana sika puroŋa ne yisi tia kâ nde imâ ipâŋga lâ. Lâ zo ŋalae ŋinde, kinzi Juda tamâta uru sipunzi lama natunzi pâta simâte, ŋineŋga sika. Ŋine nde ŋana iveta kinzi kalonzi ŋgere ŋana kumbwa Pasova ne duvi kâ. Aku Yesu ne pâri-tamâta sikasoŋa i tu, “Noko ilo tu maka ma kalâ kaveta kâŋa-nuŋa lâ nia ndia ŋana ma taka.” ");
INSERT INTO xsi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku Yesu isupwanzi ne pâri-tamâta rua tu silâ, ku ipainzi tu, “Miki rua kalâ lawea ŋalae ilo, aku ma kapakâtu kuku tamâta toŋge lâ nzâla, ikale lââ lâ kulo ŋalae toŋge. Miki rua koka i muli. ");
INSERT INTO xsi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","I ma ilâ luma toŋge ilo. Ŋineŋga miki ma kaporo pa luma ŋinde warika tu, ‘Pananâŋa ne kasoŋâŋa nde ikeno mine; “Luma ilo kisiŋa pwataki toŋge nde keno ndia ŋana ma aka kumbwa ŋine ne kâŋa-nuŋa kunzi naneŋgu pâri-tamâta ŋai.’” ");
INSERT INTO xsi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ŋineŋga i ma itula luma ilo kisiŋa pwataki toŋge ikeno âta pami, peke tava kelekele ŋana kâŋa-nuŋa kâ nde ikeno ŋinde. Miki rua kalâ kaveta kâpwa pa kinda lâ niani ndaina.” ");
INSERT INTO xsi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aku kinzi rua silâ lawea ŋalae ilo, aku simora kelekele rârâni ikeno itogo muŋga Yesu iporo panzi mine. Mine kala siveta kâŋa-nuŋa lâ ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kari indue lala pararai lâ, ŋineŋga Yesu ikainzi ne pâri-tamâta saŋao kanaŋonzi rua ku silâ sipâŋga luma ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kinzi nde sisaŋona sika yo, ande Yesu ipainzi tu, “Naŋa aporo mao nâ pami; tamâta toŋge lâ miki ŋginimi ma io naŋa lâ kinzi kazâŋa tamâta mbaunzi ilo. Ande kala tamâta ŋine ika kuku naŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kinzi pâri-tamâta nde siloŋo ŋgua ŋine ku ilonzi malia ndo, ku kinzi taitu-taitu sikasoŋa Yesu tu, “Tiambo noko kuporo ŋana naŋa kâ, tiya?” ");
INSERT INTO xsi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ande Yesu ipainzi tu, “I nde toŋge lâ miki saŋao kanaŋomi rua. Ande kala tamâta ŋine io mbau lâ kondo ilo kuku naŋa, kala maka rua kaka. ");
INSERT INTO xsi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mao nâ, naŋa Tamâta Natu ma amâte, ikura Maro Kindeni kawa ŋgua kinzi ŋgua-tulâŋa tamâta muŋga siŋgere lâ pepa tini mine. Andeta vetâŋa sakamao ndo ma ipâŋga pa tamâta ŋine io Tamâta Natu lâ kinzi kazâŋa tamâta mbaunzi ilo. Ambo nia ndoyo tamâta ŋine tina ipagugua i tia tâ, ande ŋinde ma ara.” ");
INSERT INTO xsi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kinzi sisaŋona sika yo, ŋineŋga Yesu ikai puroŋa, kawa ndaŋge pa Maro Kindeni, aku ipwataki ilanzi ne pâri-tamâta. Aku iporo tu, “Miki kakai kaka. Naŋa kanaŋoŋgu kala ŋine.” ");
INSERT INTO xsi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ŋineŋga ikai kâmba waini kala mine nâ, kawa ndaŋge pa Maro Kindeni, ku ilanzi, aku rârâni sinu waini lâ kâmba ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aku ipainzi tu, “Naŋa seeŋgu kala ŋine. Ŋine nde Maro Kindeni ne ŋgua pâŋa ne kanaŋo. Naŋa apaliŋi ŋananzi tamâta rârâ. ");
INSERT INTO xsi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Naŋa aporo mao nâ pami; naŋa ma anu waini kanaŋo kilo tia lee, ikura lâ zo ŋinde Maro Kindeni ma ikai Maro panzi tamâta lâ tâno kulu. Ŋineŋga ma anu waini waseki.” ");
INSERT INTO xsi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesu iporo ŋgua ŋine lâ, ŋineŋga siwâŋgi wâŋgiŋa toŋge, aku simandi sipile lawea ŋinde ku silâ pa Oliv Tuu. ");
INSERT INTO xsi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ŋineŋga Yesu ipainzi ne pâri-tamâta tu, “Miki rârâni nemi kalo-tawana ma imbe, ikura Maro Kindeni kawa ŋgua ikeno lâ pepa tini mine tu, ‘Naŋa ma apu lama nenzi katonâŋa, ande kala kinzi lama ma sikâwa pwapwataki silâ.’ ");
INSERT INTO xsi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Andeta muli, Maro Kindeni ma ipaŋo naŋa amandi amo viâŋgu kilo, ŋineŋga ma ayoka amuŋga pami alâ Galilaya tâno.” ");
INSERT INTO xsi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Andeta Petero ipai tu, “Ambo kinzi tamâta ŋine rârâni nenzi kalo-tawana ma imbe, ande naneŋgu kalo-tawana ma imbe tia ndo!” ");
INSERT INTO xsi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Andeta Yesu ipai Petero tu, “Naŋa aporo mao nâ pano; ma ŋine mbo nâ, tatareko ma isuŋa kawa mbwani rua tia yo, ande noko tamwata ma kuporo kupatimoa naŋa mbwani ŋato tu noko kusama naŋa tia.” ");
INSERT INTO xsi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Andeta Petero iporo kaika kilo tu, “Ambo kinzi situ sipu naŋa pâta amâte kuku noko, ande naŋa ma aporo apatimoa noko mine tia ku tia ndo!” Aku kinzi pâri-tamâta rârâni kala siporo ŋgua kaŋa taituni mine nâ. ");
INSERT INTO xsi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ŋineŋga kinzi silâ sipâŋga tâno toŋge, i ŋa mine Getsemani. Aku Yesu ipainzi ne pâri-tamâta tu, “Miki kasaŋona kamo ŋai, mbo naŋa alâ akai noŋa ŋga”. ");
INSERT INTO xsi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku ikainzi Petero, ŋga Yamesi, ŋga Yoane, aku kinzi ŋato silâ kuku i. Ŋineŋga Yesu ilo putuka wa ilo malia ndo. ");
INSERT INTO xsi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aku ipainzi tu, “Naŋa kaloŋgu sukâŋa ŋalae tina, aku laiti ŋana iyaula naŋa ndo. Mine nde miki kamo ŋine ku kaka mâsa.” ");
INSERT INTO xsi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ŋineŋga ilâ tini, aku ikeno nao tundu lâ tâno kulu, ku ino pa Maro Kindeni ŋana nâna ŋalae ŋinde laiti ŋana ipâŋga papa i kâ, tu ma iŋgeŋge ŋana i kâ. ");
INSERT INTO xsi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Yesu ikai noŋa mine tu, “O, Mama! Noko pwura ŋana kuveta vetâŋa rârâni. Mine kala naŋa atu noko ma pwai kâmba ŋana nâna kâ ŋine saŋe naŋa. Ambo taitu noko ma kuveta ikura naneŋgu pateâŋa mine ndimo. Kuveta ikura noko tamwata nâ ne pateâŋa.” ");
INSERT INTO xsi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ŋineŋga Yesu itaulo ilâ panzi ne pâri-tamâta kilo, andeta sikeno. Aku ipaŋonzi ku ipai Petero tu, “Saimon, noko pweno, a? Mana mana ŋga noko pwura tia ŋana kuka mâsa ikura kari tai taitu nâ, a? ");
INSERT INTO xsi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ara ŋana miki ma kao tinimi, ku kano pa Maro Kindeni tu ma isukami ŋana kamandi kaika lâ zo ndia samâŋa imâ ipâŋga pami. Mao nâ, miki ilomi tu kaveta vetâŋa ara, aŋga karaemi nde iveta malia pami.” ");
INSERT INTO xsi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ŋineŋga Yesu ipilenzi ku itaulo ilâ ikai noŋa kilo. Aku lâ i ne noŋa ŋinde, ande iporo ŋgua rege-rege kuku ne noŋa muŋgâŋa ŋinde. ");
INSERT INTO xsi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ikai noŋa lâ, ŋineŋga itaulo ilâ panzi ne pâri-tamâta kilo, andeta imoranzi sikeno nâ simo, ŋana tu matanzi matutu pâta. Kinzi simandi sânda, andeta mainzi, kala siporo ŋgua toŋge pa Yesu tia. ");
INSERT INTO xsi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tia ku Yesu itaulo ilâ ikai noŋa kilo, ŋineŋga itaulo imâ panzi ne pâri-tamâta ku ipainzi tu, “Opopo, miki kakeno kamo ŋai yo kapwarea, a? Kura lâ! Zo ŋga ipâŋga lâ. Kamora ŋga; kala ŋine kinzi simâ ŋana sio naŋa Tamâta Natu lâ kinzi kiesaka tamwatanzi mbaunzi ilo. ");
INSERT INTO xsi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ayo, kamandi sânda, ku toka talâ panzi! Kamora ŋga, tamâta ŋana ikai kulu-pâŋga ŋana naŋa kâ, ande kala imâ ipâŋga laiti lâ.” ");
INSERT INTO xsi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu iporo ŋgua ŋine yo, aku walele nâ Judas, ina toŋge lâ Yesu ne pâri-tamâta saŋao kanaŋonzi rua, ande imâ ipâŋga lâ. Aku tamâta ŋgu ŋalae tina nde sikai pila ŋana kazâŋa kâ wa kâi mbuku wa soka kuku simâ. Kinzi patarawâŋa tamâta ŋalaŋala, aŋga kinzi pananâŋa tamâta ŋana ŋgua tukuŋa kâ, aŋga kinzi ŋgu nenzi katonâŋa, ande kinzi ŋinde muŋga sisupwanzi kala simâ. ");
INSERT INTO xsi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ande kulu-pâŋga tamâta ŋinde muŋga ipainzi tu i ma iveta mâsi toŋge pa Yesu. Ipainzi tu, “Naŋa ma anzumwa tamâta toŋge nao, aku tamâta ŋinde nde Yesuni. Miki ma kakai i kaika ku kakatona sondo nâ kakai kalâ.” ");
INSERT INTO xsi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mine kala Judas iyoka imâ pa Yesu ku walele nâ iporo tu, “Pananâŋa!”, ku inzumwa i nao. ");
IN