﻿USE sofia;
DROP TABLE IF EXISTS sofia.xsb_vpl;
CREATE TABLE xsb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xsb_vpl WRITE;
INSERT INTO xsb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yadti a listawan nin lahi a pinangibatan ni Jesu-Cristo, paibat koni Abraham bi-sa paibat anaman koni Ari David. ");
INSERT INTO xsb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Hi Abraham ay tatay ni Isaac, hi Isaac ay tatay ni Jacob, hi Jacob ay tatay li Juda tan tawtalakaka na. ");
INSERT INTO xsb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Hawanin, nag-in anak ni Juda koni Tamar hi Fares tan hi Zara, bi-sa hi Fares ay tatay ni Esrom, hi Esrom ay tatay ni Aram, ");
INSERT INTO xsb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","hi Aram ay tatay ni Aminadab, hi Aminadab ay tatay ni Naason, hi Naason ay tatay ni Salmon, ");
INSERT INTO xsb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","anak ni Salmon koni Rahab hi Booz, anak ni Booz koni Ruth hi Obed, hi Obed ay tatay ni Jesse, ");
INSERT INTO xsb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","hi Jesse ay tatay ni Ari David. Hawanin, yay nag-in anak ni Ari David konan datin kaambali ni Urias ay hi Ari Solomon. ");
INSERT INTO xsb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hi Ari Solomon ay tatay ni Ari Roboam, hi Ari Roboam ay tatay ni Ari Abias, hi Ari Abias ay tatay ni Ari Asa, ");
INSERT INTO xsb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","hi Ari Asa ay tatay ni Ari Josafat, hi Ari Josafat ay tatay ni Ari Joram, hi Ari Joram ay tatay ni Ari Ozias, ");
INSERT INTO xsb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","hi Ari Ozias ay tatay ni Ari Jotam, hi Ari Jotam ay tatay ni Ari Acaz, hi Ari Acaz ay tatay ni Ari Ezequias, ");
INSERT INTO xsb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","hi Ari Ezequias ay tatay ni Ari Manases, hi Ari Manases ay tatay ni Ari Amon, hi Ari Amon ay tatay ni Ari Josias. ");
INSERT INTO xsb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hi Ari Josias ay tatay ni Ari Jeconias tan tawtalakaka na. Konan yadtin panaon ni Ari Jeconias, binihag hilay aw-Israelita nin hilay tawtaga nasyon Babilonia. ");
INSERT INTO xsb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pa-makayari orin pa-ngawit konla ha Babilonia, nagkamain yan anak hi Ari Jeconias. Yay ngalan na ay Salatiel. Hi Salatiel ay tatay ni Zorobabel, ");
INSERT INTO xsb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","hi Zorobabel ay tatay ni Abiud, hi Abiud ay tatay ni Eliaquim, hi Eliaquim ay tatay ni Azor, ");
INSERT INTO xsb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","hi Azor ay tatay ni Sadoc, hi Sadoc ay tatay ni Aquim, hi Aquim ay tatay ni Eliud, ");
INSERT INTO xsb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","hi Eliud ay tatay ni Eleazar, hi Eleazar ay tatay ni Matan, hi Matan ay tatay ni Jacob, ");
INSERT INTO xsb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","bi-sa hi Jacob ay tatay ni Jose a kaambali ni Maria a nanay ni Jesus, yay anha-wayan Cristo. ");
INSERT INTO xsb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kanya yay bilang nin honol-honol a hinirasyon a pinangibatan ni Jesus, paibat koni Abraham anggan koni Ari David ay labin-a-pat. Paibat anaman koni Ari David anggan hin binihag hilay aw-Israelita para awiton ha Babilonia ay labin-a-pat anamaot. Bi-sa paibat konan yadtin pa-ngawit konla ha Babilonia angga hin in-abing hi Cristo ay labin-a-pat anaman a hinirasyon. ");
INSERT INTO xsb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yay tongkol ha pa-miabing koni Jesu-Cristo ay anodti nangyari: Hi Maria a nanay na tan hi Jose ay nakatakda anan pakahal. Kot ba-yo hila niambali ay na-tandaan a ampanginaw ya hi Maria. Yadtin panginginaw na ay gawa nin kapangyarian nin Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yadtin hi Jose a nobyo na ay mahonol ha kawkapanogoan nin Israelita. Kot kay na magawa honolon yay kapanogoan a dapat ipatandaan a hinoman a nobyan na-palombit nin laloma pigaw maipapati. Kanya inisip nan ihiyay na ya tana nin pasikrito. ");
INSERT INTO xsb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Balo ta lo-gan na ot an-isip-isipon odti, main a-say anghil nan Katawan a nagpa-kit kona ha taynop. Wana, “Jose, apopo ni Ari David, ando ka mag-alangan nin ipagkaambali hi Maria, bana ta ya-rin lombit na ay gawa nin kapangyarian nin Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mangabing yan a-say lalaki a pangalanan mon Jesus yay labay totolon nin ya-rin a ngalan ay ‘Ma-milipyas’ bana ta ilipyas nay tawtawo na ha main lan kawkasalanan,” wanan anghil. ");
INSERT INTO xsb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Konan ya-rin halban nangyari ay na-paptogan yay impabalita nan Katawan ha a-say propita na hin yadtaw, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Biliwon moyo ta main a-say dalaga a manginaw. Mangabing yan a-say lalaki a ha-wayan Emmanuel.” (Yay labay totolon nin ya-rin a ngalan ay “Iti yay Dios kontamo”.) ");
INSERT INTO xsb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pa-mimata ni Jose, hinonol nay impanogo nan anghil nan Katawan kona. Kanya impagkaambali na yay na hi Maria. ");
INSERT INTO xsb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Balo ta kay na ginwa konay a-say bagay lo-gan kay ot in-abing ni Maria yadtin o-nan anak na. Hin in-abing yay na, pinangalanan na yay naor ni Jose nin Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hi Jesus ay impangabing ha babalin Betlehem, probinsyan Judea hin panaon ni Ari Herodes. Hin ya-rin ay main lawlalakin mangaronong, laloy na tongkol ha bawbitoon. Taga hila ha marayo a logar ha baytan. Nako hila ha syodad Jerusalem ta namastang. ");
INSERT INTO xsb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wanla, “Ayti ya man orin a in-abing para mag-in ari moyon aw-Israelita? Nga-min na-kit mi itaw ha baytan a bitoon na a pamilbian in-abing yay na. Kanya nako kami iti para sambawon ya.” ");
INSERT INTO xsb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hin na-tandaan ni Ari Herodes a main ot laloman mag-in ari, naaboridoy main nan kaisipan. Anorin anamaot kapara konlan intiron taga Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanya yay ginwa ni Ari Herodes ay tinipon na hilay pawpoon pari tan mawmaistron kapanogoan nin aw-Israelita, ta pinastang na konla no ayti ya dapat iabing yay Cristo a impangako nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wanla kona, “Ha babalin Betlehem, probinsyan Judea. Nga-min anodti a imbalita nan Dios a sinolat nin a-say propita na hin yadtaw: ");
INSERT INTO xsb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Hikamoy taga babalin Betlehem ha probinsyan Juda, ya-rin babali moyo ay ambo hoyot ha bawbabalin bantog ha Juda, Bana ta ison ya iabing yay mamoon komoyon aw-Israelita a tawtawo ko.’” ");
INSERT INTO xsb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bi-sa pasikrito nan impa-ka ni Ari Herodes hiladtaw lawlalakin mangaronong, ta pinastang na hilan labah no naka-no nilomwah odtaw bitoon. ");
INSERT INTO xsb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pa-makayari ay pina-ka na hilay na ha Betlehem, ta wana konla, “Mako kamoy na ta paka-tingkapon moyo ya-rin a anak. No ma-kit moyo ya ay ipatandaan moyo kongko pigaw maka-ka akoy namaot para sambawon ya.” ");
INSERT INTO xsb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pa-makalngo la ha imbalita nan ari, nako hilay na. Tongwa, na-kit lay naman odtaw bitoon a na-kit la hin itaw hila ot ha baytan. Ya-rin a bitoon a nango-na konla anggan hin tinomgon ha tobon kamainan nan anak. ");
INSERT INTO xsb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hin na-kit lay naor orin bitoon, na-ligawan hilan labah. ");
INSERT INTO xsb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bi-sa hin nilomoob hila ha bali, na-kit la yay anak ha dani ni Maria a nanay na. Nanalimokor hilan palokob ta sinamba la ya. Bi-sa inabriyan lay aw-awit la, ta nami hilan rawrigalo koni Jesus nin balitok, insinso tan mira. ");
INSERT INTO xsb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hawanin, impataynopan nan Dios konla a ando hilay na domalan itaw koni Ari Herodes, ta main ya paytin doka a plano. Kanya norong hilay na ha sarili lan logar nin hakalakoy pinagpa-wanan. ");
INSERT INTO xsb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hin nakaalih hilay nadtaw lawlalakin mangaronong, tongwa main anaman a-say anghil nan Katawan a nagpa-kit koni Jose ha taynop. Wana kona, “Mibangon ka ta awiton mo hilay mitala-ina ha nasyon Egipto ta omari kamo yapon itaw. Magpirmi kamo itaw anggan ha ibalita kon omalih kamoy na. Nga-min, ipatingkap ni Ari Herodes yay anak para ipapati.” ");
INSERT INTO xsb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kanya nibangon hi Jose hin ya-rin ot a yabi ta inawit na hilay naor a mitala-ina ha Egipto. ");
INSERT INTO xsb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bi-sa ni-wan hila itaw anggan nati hi Ari Herodes. Ha anorin a nangyari, na-paptogan yay impabalita nan Katawan konan a-say propita na hin yadtaw, a wanan nakasolat, “Hina-wayan koy anak ko nin omalih ha Egipto.” ");
INSERT INTO xsb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hawanin, hin na-patnagan ni Ari Herodes a naa-sawan la ya nin hiladtaw lawlalakin mangaronong ay inomamot masyadoy olo na. Kanya impapati nay halban awa-nak a lalaki ha babalin Betlehem tan ha halban ka-danin logar a idad loway taon paaypa. Yadti yay idad a imbasi na ha panaon hin nilomwah odtaw bitoon ayon ha na-pastang na konlan hiladtaw lawlalakin mangaronong. ");
INSERT INTO xsb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ha anorin a nangyari, pinomtog yadtin impabalita nan Dios koni Propita Jeremias hin yadtaw, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ha logar a anha-wayan Rama ay angkalngo a kata-tangih, pa-migo-golaab tan grabin pa-miaanito, Ta antangihan ni Raquel hilay aw-awa-nak a lipi na. Kay ya ma-liwa-liwa ta halban la ay na-min pinati-pati.” ");
INSERT INTO xsb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hawanin, hin nati na hi Ari Herodes, main anaman a-say anghil nan Katawan a nagpa-kit koni Jose ha taynop, hin itaw hila ot ha nasyon Egipto. ");
INSERT INTO xsb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wanan anghil kona, “Mibangon ka ta iorong mo hilay nay mitala-ina ha nasyon Israel, ta hiladtaw malabay mangmati konan anak ay nati na.” ");
INSERT INTO xsb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kanya nibangon ya ta in-orong na hilay naor a mitala-ina ha Israel. ");
INSERT INTO xsb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kot nali-mo hi Jose nin mako mi-wan ha probinsyan Judea, hin na-tandaan nan hi Arquelao a anak ni Ari Herodes yay hinomagilin ampamoon itaw. Impataynopan nan Dios koni Jose a dilikado no mi-wan hila itaw. Kanya pinoma-lilih hila ta nako ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Itaw hila ni-wan ha babalin Nazaret. Kanya pinomtog yadtin impapibalita nan Dios konlan pawpropita na hin yadtaw, a wanan nakasolat, “Ha-wayan yan Nazareno.” ");
INSERT INTO xsb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pa-makalabah nin omnoy taon, hi Juan Bautista ay nako itaw ha probinsyan Judea ha disyirto ta nangaral. ");
INSERT INTO xsb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wana, “Mi-pangombabali kamoy na tan bokotan moyoy kawkasalanan moyo, ta madani nay nan ipa-kit nin Dios a pa-mag-ari na.” ");
INSERT INTO xsb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yadtin hi Juan a antokoyon ha impabalita nan Dios koni Propita Isaias hin yadtaw, a wanan nakasolat, “Itaw ha disyirto ay main malngo a ampama-balawbaw a bosis, a wanan ialimbawa, ‘Iparihado moyoy pa-hal pagpa-wanan nan Katawan, tan pa-hal itoynong moyoy dalanan na.’” ");
INSERT INTO xsb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yadtin hi Juan, yay ayhing na ay momorawon bongat a klasi a yari ha habot kamilyo. Bi-sa yay an-ipagsintoron na ay bastan katat bongat. Yay pa-mangan nay namaot ay doron tan polot panilan bongat. ");
INSERT INTO xsb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lako a tawtawon nako nanglongo kona a naibat ha syodad Jerusalem tan ha halban babali a hakop namaot nin probinsyan Judea, tan ibat ha intiron ka-libol nin Kabatwan Jordan. ");
INSERT INTO xsb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Binaotismowan na hila ni Juan itaw ha Kabatwan Jordan, hin imbalita lay main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kot hin na-kit ni Juan a lako konlan rawrilihyoson aw-Israelita a kabilang ha gropo lan paw-Pariseo tan ha gropo lan saw-Saduseo a ni-pako kona para pabaotismo, wana konla, “Bilang kamon olay a mataktika. Hino wani komoyo a maka-pa-lilih kamo ha matindin hobhob nan Katawan a main awit parosa, no basta kamon bongat pabaotismo? ");
INSERT INTO xsb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","No talagan ampangombabali kamo, ipa-kit moyo no-nin ha paralan nin kagogwa moyon kaabigan a binokotan moyoy nay main moyon kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ando moyo isipon a kay na kamo parosawan nin Dios, bana ta lawlipi na kamo ni Abraham a tawo nan Dios. Ibalita ko komoyo, magawa nan Dios tawtawo odtin bawbato nin mag-in lawlipi ni Abraham para mag-in ka-hagilyan moyo. ");
INSERT INTO xsb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bana ta yay gawgawa moyo kot doka, kaalimbawaan moyo ay kayon an-awagan anan payakol para pokanon, ta balang poon kayon kay ampamongan labah a klasin bonga ay ampokanon ta poolan.” ");
INSERT INTO xsb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wana ot ni Juan konlan tawtawo itaw, “Ambaotismowan katamo nin lanom, pamilbian nin pa-ngombabali tan kabo-bokot moyo ha main moyon kawkasalanan. Kot main lomato a hoyot kongko a mas makapangyayari kongko, ta maskin mangawit apin na ay ambo akon marapat. Hiyay mamaotismo komoyo, kot yay ipamaotismo na ay yay Masanton Ispirito nan Dios tan apoy. ");
INSERT INTO xsb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kaalimbawaan na ay ma-ngalipar, tan hitamoy tawtawo ay pa-hal trigon nailik a aaliparan. Handa na tamoy nan aliparan ta bi-sa ilimpoh nay pa-hal malinis anan trigo ha kamalig, balo ta yay pa-hal apil ay poolan na ha apoy a homin pa-nga-lop.” ");
INSERT INTO xsb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hin ya-rin ay inomalih hi Jesus ha probinsyan Galilea ta nako ya koni Juan Bautista para pabaotismo kona itaw ha Kabatwan Jordan. ");
INSERT INTO xsb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kay na komon labay ni Juan ta wana koni Jesus, “Hikoy dapat pabaotismo komo, anongkot hika a pabaotismo kongko?” ");
INSERT INTO xsb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kot wanan in-obat ni Jesus, “Pomayag kay na ta yadti a dapat ta nin gaw-on, pigaw ma-honol a halban kalabayan nan Dios.” Kanya pinomayag hi Juan. ");
INSERT INTO xsb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hin na-baotismowan ana hi Jesus ay tampol yan ninapat. Tongwa, naabriyan a kalangitan bi-sa na-kit nay Ispirito nan Dios a inomaypa ta bi-sa dinompa kona nin bilang a-say kalapati. ");
INSERT INTO xsb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tongwa, bigla nalngo a bosis nan Dios a naibat ha langit, wana, “Yadti a anlabyon kon Anak, tan angkalilikot akon labah kona.” ");
INSERT INTO xsb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bi-sa hi Jesus ay intandoro nin Ispirito nan Dios nin mako ha disyirto para toksowon na ya ni Satanas. ");
INSERT INTO xsb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lolog nan itaw ni Jesus ay nagsakripisyo yan kay nangan ha loob nin a-pat a polo a awlo tan yabi. Pa-makayari odti ay masyado yay nan mabitil. ");
INSERT INTO xsb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tongwa, nakalato hi Satanas para toksowon na ya. “No talagan Anak na kan Dios,” wana kona, “gaw-on mon pa-mangan odtin bawbato.” ");
INSERT INTO xsb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kay na ya hinonol ni Jesus, nokay wanan in-obat kona, “Nakasolat ha Masanton Kasolatan, ‘Ambo bongat ha pa-mangan mabyay a tawo, Nokay kailangan na syimpri a balang halita nan Dios.’” ");
INSERT INTO xsb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bi-sa inawit ni Satanas hi Jesus ha Masagradon Syodad Jerusalem, ta itaw na ya pina-dong ha pinakatoktok nin timplo nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bi-sa wanay naman koni Jesus, “No talagan Anak na kan Dios, magdadabo ka. Total, wana ha Masanton Kasolatan, ‘Ipabantayan na kan Dios konlan aw-anghil na.’ tan ‘Alalayan la ka, Pigaw ni ayi mo kot kay mitiro ha bato.’” ");
INSERT INTO xsb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wanan in-obat ni Jesus kona, “Potog orin, balo ta wanay namaot ha Masanton Kasolatan, ‘Ando mo hobokon a kapangyarian nan Dios a Katawan.’” ");
INSERT INTO xsb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bi-sa inawit na yay naman ni Satanas ha toktok nin a-say na-pakata-gay a bakil, ta impatamolaw na konay halban kawkaarian iti ha mondo tan yay kagandawan nin yadti. ");
INSERT INTO xsb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bi-sa wana koni Jesus, “Halban ya-rin ay ibi ko komo, no manalimokor ka tan somamba kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kot wani Jesus kona, “Paka-dayo ka, Satanas, ta wana ha Masanton Kasolatan, ‘Sambawon moy Dios a Katawan mo Tan hiyan bongat a pagsirbiwan mo.’” ");
INSERT INTO xsb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanya imbati na ya ni Satanas. Bi-sa main aw-anghil a nako koni Jesus ta sinirbiwan la ya. ");
INSERT INTO xsb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Hin na-tandaan ni Jesus a impriso hi Juan Bautista, norong ya ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kay ya nagpirmi ha sarili nan babalin Nazaret ta nako ya ni-wan ha babalin Capernaum. Yadtin babali ay iti ha liglig nin Alindayat Galilea tan madani namaot ha logar Zabulon tan Neftali. ");
INSERT INTO xsb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ha pa-mi-wan ni Jesus itaw ay pinomtog yay impabalita nan Dios koni Propita Isaias hin yadtaw, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yay lawlogar a anha-wayan Zabulon tan Neftali Ay madani ha Alindayat Galilea, ha dobali nin Kabatwan Jordan. Hakop ot yadti nin probinsyan Galilea, kot main anan ampi-wan nin ambo Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hilay tawtawo itaw ay pa-hal ampi-wan ha karobloman bana ha kawkasalanan la. Ampamagka hilay na komon ha kamatyan nin homin panganggawan a kaparosawan, Kot na-hawangan ot a main lan kaisipan Ta nakalato ana yay ampamin hawang konla.” ");
INSERT INTO xsb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Paibat hin ya-rin a panaon a ni-wan hi Jesus ha Capernaum ay nag-ompisa yan nangaral. Wanan an-ipangaral, “Mi-pangombabali kamoy na tan bokotan moyoy kawkasalanan moyo ta madani nay nan ipa-kit Dios a pa-mag-ari na.” ");
INSERT INTO xsb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ninghan, hin anlalako hi Jesus ha liglig Alindayat Galilea, main yan na-kit loway mitalakaka, hi Simon a hina-wayan Pedro hin bandan hoyot tan yay ali na a hi Andres. Ampanglala hila hin ya-rin ta maninilay hila. ");
INSERT INTO xsb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Wani Jesus konla, “Homonol kamo kongko ta gaw-on katamon pa-hal ma-nilay nin tawo para tompol hila kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tampol lan in-inapat a lala la ta hinomonol hila kona. ");
INSERT INTO xsb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ha pa-magpatoloy nan kala-lalako ni Jesus, na-kit nay lowa ot a mitalakaka a hila ni Santiago tan hi Juan, a awa-nak ni Zebedeo. Itaw hilay mita-talaama ha baloto ta an-ayomawon lay aw-ikot la. Hina-wayan anamaot ni Jesus odtin mitalakaka. ");
INSERT INTO xsb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kanya antimano imbati lay baloto la, pati tatay la ta hinomonol hilay namaot kona. ");
INSERT INTO xsb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hawanin, nako hi Jesus ha halban lawlogar nin probinsyan Galilea, ta nangaral ya ha sawsinagoga a ampagsambawan la. Impangaral na yay Labah a Balita tongkol ha pa-mag-ari nan Dios, tan pinaabig nay namaot a tawtawo ha halban klasin mawmasakit tan dawdipirinsya la. ");
INSERT INTO xsb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bana ha ka-paka-ngap a gawgawa na, nibantog ya pati ha intiron Siria. Hawanin, inawit lan tawtawo koni Jesus hilay halban tawon main nangasasari a mawmasakit tan dawdoka a angkalayam, pati hilay nilooban nin dawdoka a ispirito, hilay ansompongon nin pa-ma-paghon tan hilay pawparalitiko. Kanya halban la ay pinaabig na. ");
INSERT INTO xsb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kanya maski man ayti ya mako hi Jesus, golpin tawoy ampaki-ki-ka kona. Hila-rin a tawtawo ay main ibat ha Galilea a probinsya na, main anamaot ibat ha Decapolis, ha Jerusalem, Judea tan ha baytan nin Kabatwan Jordan. ");
INSERT INTO xsb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A-say awlo, hin na-kit ni Jesus hilay malabong a tawo, nako yan hinomaka ha a-say bakil. Hin nakatoklo yay na, dinomani hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bi-sa inompisawan na hilay nay naman tinoroan, wana: ");
INSERT INTO xsb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Makalma hilay ambomilbi a kailangan la yay Dios, ta kabilang hila konlan ampag-arian na. ");
INSERT INTO xsb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Makalma hilay anlomolo bana ha kasalanan, ta liwa-liwawon na hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Makalma hilay tawon mapagmaaypa, ta maipag-ikon la yay ba-yon mondo ha lomato a panaon. ");
INSERT INTO xsb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Makalma hilay malabay a ma-honol yay kanakoman nan Dios, ta ma-kit lan mangyari ya-rin. ");
INSERT INTO xsb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Makalma hilay mainganga-rowon, ta inga-rowan na hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Makalma hilay malinis a kanakoman, ta ma-kit la yay Dios anggan-angga. ");
INSERT INTO xsb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Makalma hilay anggomwa paralan nin pa-misosondo, ta ha-wayan hilan awa-nak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Makalma hilay anda-damsakon bana ta mahonol hila konan Dios, ta kabilang hila konlan ampag-arian na. ");
INSERT INTO xsb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Makalma kamo no bana ha kaho-honol moyo kongko ay antoya-toyaon o anda-damsakon o ambara-baraan la kamo nin nangasasari a kawkarokaan nin homin kaptogan. ");
INSERT INTO xsb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","No ampangyari odti komoyo, lomilikot kamo tan magpakaliga, bana ta mahi-ban a itobalo nan Dios komoyo itaw ha langit, ta hila man a pawpropita na hin yadtaw ay dina-damsak anamaot.” ");
INSERT INTO xsb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wana ot ni Jesus konlan dawdisipolos na, “Kaalimbawaan moyo ay asin a ampakapamin kaabigan ha intiron mondo. Kot no alimbawa ta na-hominan anan alat a asin, maiorong ot wari a alat na? Homin yay nan sirbi, kanya ibantak tana ta bi-sa ma-dakat-dakat nin tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hikamoy hawang ha intiron mondo. Kanya dapat mapatnag kamo ha tawtawo a bilang ha a-say syodad a iti ha ta-gay bakil a kay maiari. ");
INSERT INTO xsb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bilang anamaot ha a-say lamparilya, kay ampartawan odti nin tawo ta bi-sa wari hakban nin halop. Nokay an-igwa syimpri ha dapat pamigwaan pigaw ma-hawangan a halban ha bali. ");
INSERT INTO xsb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anorin anamaot kapara komoyo, dapat yay biyay moyo ay pa-hal na-pakahawang, pigaw ma-kit lay gawgawa moyon kaabigan ta bi-sa poriwon lay Ama moyo ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Wana ot ni Jesus, “Ando moyo isipon a nako ko iti para alihan nin alag'a yay kawkapanogoan a inimbi nan Dios koni Moises tan yay sawsinolat lan propita nan Dios hin yadtaw. Nokay nako ko iti pigaw mangyari ya-rin, ambo para alihan nin alag'a. ");
INSERT INTO xsb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yay potog, ibalita ko komoyo, manganggawan a langit tan lota, balo ta homin maba-wah konan ya-rin a kawkapanogoan maskin a-say litra o toldok bonga ta kailangan mangyari ya-rin halban. ");
INSERT INTO xsb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanya hinoman a kay ampamaalag'a maski ha a-sa ha pinakamalo-paw a kawkapanogoan nan Dios tan mamitoro ot ha laloma para kialig kona, ya-rin a tawon ay ibilang yan homin kwinta ha ampag-arian nan Dios. Balo ta hinoman a anhomonol ha kawkapanogoan bi-sa an-itoro na ot ha laloma, ya-rin a tawo ay ibilang yan marangal ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kanya ibalita ko komoyo, no kay moyo madaog hilay mawmaistron kapanogoan tan hilay paw-Pariseo ha kaho-honol ha kalabayan nan Dios, sigoradon kay kamo maka-paki-lamo ha ampag-arian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wana ot ni Jesus, “Tanda moyodtin impanogo konlan tawtawo hin yadtaw: ‘Ando ka mangmatin tawo ta hinoman a mangmatin tawo ay hosgawan ha korti.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kot hiko, oyay ibalita ko komoyo: Hinoman a main bongat amot olo ha kapara ay hosgawan ha korti. Tan hinoman a manoboy ha kapara ay hosgawan ha pinakamata-gay a korti. Bi-sa yay manginsolto ha kapara ay parosawan ha impyirno. ");
INSERT INTO xsb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kanya, no alimbawa ta iti ka ha timplo ta main kan ida-ton ha Dios ta bi-sa ma-panomtoman mon main tawon mahkit a nakom na komo, ");
INSERT INTO xsb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ibati mo yapon ya-rin a da-ton mo ha altar ta maki-sondo ka kona. Pa-makayari ay magbalik ka ta itoloy moy nay pa-mida-ton mo ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“No main anamaot magdimanda komo ta awiton na ka ha korti, makiariglo kan tampol kona mintras kay kamo ot inomabot. No kay mo gaw-on odti ay iarap na ka ha howis ta bi-sa ipaaristo na kan howis ha polis, kanya mapriso kay na ingat. ");
INSERT INTO xsb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yay potog, ibalita ko komo, kay ka makalikol ha prisowan, anggan kay mo ma-bayaran yay kalin-ooltimowan sintimos nin molta mo.” ");
INSERT INTO xsb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wana ot ni Jesus, “Tanda moyoy namaot odtin impanogo konlan tawtawo hin yadtaw: ‘Ando ka mamabayi o maki-lalaki.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kot hiko, oyay ibalita ko komoyo: No yay a-say lalaki kot homilap yan bongat ha a-say babayi ta ha isip na ay main yay nan doka a apos kona, bilang ot bongat nakapagkasalanan yan pa-mabayi. ");
INSERT INTO xsb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Alimbawa, no yay wanan mata mo a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan hokiton tan ibantak a mata mo. Labah ot pa-hal ma-kolangan kan a-say partin lalaman, dinan intiron lalaman mo kot mi-ka ha impyirno. ");
INSERT INTO xsb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No yay wanan gamot moy namaot a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan po-tohon tan ibantak a gamot mo. Labah ot pa-hal ma-kolangan kan a-say partin lalaman, dinan intiron lalaman mo kot mi-ka ha impyirno.” ");
INSERT INTO xsb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Wana ot ni Jesus, “Oyay a-sa ot a kahogoan: ‘Hinoman a lalakin mamihiyay nin kaambali ay kailangan biyan na ya yapon kasolatan nin pa-mihiyay.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Balo ta oyay ibalita ko komoyo: Hinoman a lalakin mamihiyay nin kaambali, anta kay ya naki-lalaki ay kasalanan nan yadtin lalaki, ta ma-pilitan yadtin babayi nin magkaambalin oman o kari maki-lalaki a parihon an-itoring pa-maki-lalaki. Tan hinoman a lalakin magkaambali ha a-say babayin inhiyay ay makapagkasalanan ya syimprin pa-mabayi.” ");
INSERT INTO xsb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wana ot ni Jesus, “Tanda moyoy namaot odtin impanogo konlan tawtawo hin yadtaw: ‘Ando mo hiraon a pinaghompaan mon pangako konan Katawan, nokay kailangan gaw-on moy pinaghompaan mo kona.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kot oyay ibalita ko komoyo: Ando kay na maghompa. No mangako ka o mangalimpotogan, ando mo halitaon: ‘Tistigo koy langit,’ bana ta ya-rin kot pa-hal trono nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ando moy namaot halitaon: ‘Tistigo koy lota,’ ta yadti ay pa-hal paparnaan ayi nan Dios, tan ando moy namaot halitaon: ‘Tistigo koy Jerusalem,’ ta ya-rin yay syodad nan pinakamata-gay a Ari a homin laloma no ambo yay Dios. ");
INSERT INTO xsb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tan ando mo halitaon: ‘Mati ko man,’ ta ni a-say habot mo ay kay mo ma-papoti o ma-pangitit. ");
INSERT INTO xsb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tama anay ibalita moyon ‘Iya’ no iya o ‘Kai’ no kai, ta no pa-lahan moyo ot nin pa-maghompa ay ibat ana-rin koni Satanas.” ");
INSERT INTO xsb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wana ot ni Jesus, “Tanda moyoy namaot odtin kahogoan tongkol ha pa-miaway: ‘No nabolag nin a-say tawo a a-say mata mo, bolagon moy namaot a a-say mata na. O no na-balian na kan a-say ngipon, balion moy namaot a a-say ngipon na.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Balo ta oyay ibalita ko komoyo: Ando mo baloon yay hinoman a ampangwa doka komo. Alimbawa, no tinampal na ka ha wanan lopa mo, masbali iarap mo ot a wili. ");
INSERT INTO xsb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No idimanda na ka ta labay nan makway ayhing mo, ibi moy na ingat pati yay alimonmon mo. ");
INSERT INTO xsb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No alimbawa ta piliton na kan balatayon a awit na nin a-say kilomitro kadayo, gaw-on moy na ingat nin loway kilomitro nin losob ha nakom. ");
INSERT INTO xsb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Biyan mo yay ampakirawat komo, tan ando ka maki-kai ha ampaki-ram komo.” ");
INSERT INTO xsb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wana ot ni Jesus, “Tanda moyoy namaot odtin kahogoan: ‘Labyon mo hilay madani komo, balo ta tiplonon mo hilay angkomontra komo.’ ");
INSERT INTO xsb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Balo ta oyay ibalita ko komoyo: Labyon moyo maskin hilay angkomontra komoyo. Idawat moyo hilay ampamihompa komoyo a payabolan na hilan Dios nin abig. Pangwaan moyon abig hilay ampaniplon komoyo. Tan idawat moyo hilay ampangaagrabyado tan ampana-damsak komoyo. ");
INSERT INTO xsb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gaw-on moyo-rin pigaw ma-bilbi a hikamo kot awa-nak nan Ama moyo ha langit. Nga-min, ampahilaon nay awlo para ha halban tawo, doka may labah, tan ambiyan na hilan abagat, mahonol hila man kona o ambo. ");
INSERT INTO xsb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Kanya, no hilan bongat a ampanglabi komoyo a anlabyon moyo, kay homin kamon ma-taga-nan a tobalo nan Dios. Nga-min, hila man a ma-ni-non bowis a an-ibilang moyon dawdoka a tawo ay anlabyon lay namaot hilay ampanglabi konla. ");
INSERT INTO xsb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hawanin, no hilay aw-amigo moyon bongat a an-asikasowon moyo, main kamo wari nagawa a maholok ha nagawa lan laloman tawo? Hila man a ma-ni-non bowis ay anorin anamaot a anggaw-on la. ");
INSERT INTO xsb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kanya dapat pakaabig kamo ha hinoman, pigaw mag-in kamon pirpikto a bilang konan Ama moyo ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Wana ot ni Jesus, “No gomawa kamon kaabigan, mag-ingat kamo pigaw kay moyo gaw-on odti para ipa-kit ha tawo, ta no anorin a gaw-on moyo, kay na kamo tobaloon nin Ama moyo ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Alimbawa, no mami kan tambay ha tawon mairap, ando mo ipa-pakatlok a bilang ha anggaw-on lan hilay ampiabig-abig, ta yay pa-mami la ay an-ipa-kit la ha kamainan nin lako a tawo a bilang ha sawsinagoga tan ha kawkalsada, pigaw poriwon hilan tawtawo. Yay potog, ibalita ko komoyo, kay hilay na tobaloon nin Dios ta yay pamomori nin tawtawo anay impagka-tobalo la. ");
INSERT INTO xsb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kanya, no mami kan tambay, ando mo ipatandaan, maski ha pinakaamigo mo, ");
INSERT INTO xsb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","pigaw yay kata-tambay mo ay a-say sikrito. Bi-sa yay Ama mo a magtanda nin halban sikrito, hiyay nay tomobalo komo nin angka-kit.” ");
INSERT INTO xsb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wana ot ni Jesus, “Ha kada-dawat moyoy namaot, ando moyo aligon hilay ampiabig-abig, ta hila-rin a klasin tawo ay labay-labay lan domawat ha Dios nin naka-dong ha paradan logar a bilang ha sawsinagoga tan ha kawkalsada pigaw ma-kit hilan tawtawo. Yay potog, ibalita ko komoyo, kay na hilay na tobaloon nin Dios ha kada-dawat la bana ta yay pamomori nin tawtawo anay impagka-tobalo la. ");
INSERT INTO xsb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kot hika, no domawat ka, masbali maghara ka ha kwarto mo ta bi-sa domawat ka konan Ama mo a kay angka-kit. Hiya a magtanda nin halban sikrito, hiyay nay tomobalo komo nin angka-kit. ");
INSERT INTO xsb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hawanin, ha kada-dawat moyo, ando kamo migamit nin lako a halita a homin ha nakom a bilang ha anggaw-on lan hilay tawtawon kay magbilbi konan Dios, ta hay wanla ay mas long-on na hilan Dios no paanlohon lay kada-dawat la. ");
INSERT INTO xsb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ando moyo hila aligon bana ta ba-yo kamo domawat, tanda nay nan Ama moyo ha langit no anyay kailangan moyo. ");
INSERT INTO xsb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kanya anodti kamon domawat: ‘Ama mi a ison ha langit, Sambawon a ngalan mo. ");
INSERT INTO xsb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma-kit mi na komon a pa-mag-ari mo. Ma-honol komon a kalabayan mo iti ha lota a bilang anamaot ison ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyan mo kami komon nin pa-mangan mi para konan yadtin awlo; ");
INSERT INTO xsb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tan patawaron mo kami komon ha kawkasalanan mi A bilang anamaot ha pa-matawad mi konlan ampagkasalanan komi. ");
INSERT INTO xsb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tan komon ando mo aboloyan a matokso kami, Nokay masbali ipa-lilih mo kamin kay makagawa doka, ta ikon moy kaarian, kapangyarian tan karangalan a homin panganggawan. Amen’.*” ");
INSERT INTO xsb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wana ot ni Jesus, “Nga-min, no patawaron moyo hilay ampagkasalanan komoyo, patawaron na kamoy namaot nin Ama moyo ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kot no kay moyo patawaron hilay ampagkasalanan komoyo, kay na kamoy namaot patawaron nin Ama moyo ha main moyon kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wana ot ni Jesus, “No ampagsakripisyo kamon kay mangan, ando kamo maglopan mangalolo a bilang anggaw-on lan hilay ampiabig-abig. Ansadyaon lan kay mag-ayos nin sarili la ta labay lan ma-tandaan nin tawtawo a ampagsakripisyo hilan kay mangan. Yay potog, ibalita ko komoyo, kay na hilay na tobaloon nin Dios, ta yay pamomori nin tawtawo ha pa-magsakripisyo lan kay mangan anay impagka-tobalo la. ");
INSERT INTO xsb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kot hikamo, no ampagsakripisyo kamon kay mangan, dapat mila-moh kamo tan mangohay, ");
INSERT INTO xsb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pigaw homin laloman magtanda a hikamo kot ampagsakripisyon kay mangan, no ambo yay Ama moyon bongat a kay angka-kit. Hiya a magtanda nin halban sikrito, ipa-kit nay pa-mami nan tobalo komoyo.” ");
INSERT INTO xsb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Wana ot ni Jesus, “Ando kamo manipon-tipon nin kawkayamanan iti ha lota, ta iti kot main aw-insikto tan taoy a ampanira tan main tawtawon ampakaloob maniba. ");
INSERT INTO xsb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Masbali, pag-inakitan moyon gomawa kaabigan ta ya-rin a mag-in kayamanan a matipon moyo ha langit. Itaw ay homin insikto o taoy a makahira tan homin anamaot makaloob maniba. ");
INSERT INTO xsb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nga-min, no ayti yay kayamanan moyo ay itaw anamaot a nakom moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Wana ot ni Jesus nin in-alimbawa, “Yay mata ay pa-hal ampakapamin hawang ha pa-magkatawo. No labah a hilap nin tawo, mahawang a intiron pa-magkatawo na. ");
INSERT INTO xsb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kot no doka a hilap na, maroblom anamaot a intiron pa-magkatawo na. Hawanin, no yay mata nin tawo a dapat komon mamin hawang kona kot ampamaroblom ana ingat kona, masyadoy nan doka a pa-magkatawo na.” ");
INSERT INTO xsb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wana ot nin in-alimbawa ni Jesus, “Kay maari paalipon yay a-say tawo ha loway amo, ta yay mangyari ay kasorawan nay a-sa kot yay a-sa ay ma-labi na, o kari ma-kilingan nay a-sa ta yay a-sa kot ma-basta-basta. Anorin anamaot kapara komoyo, kay moyo maari pagsirbiwan yay Dios tan yay kayamanan. ");
INSERT INTO xsb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ibalita ko komoyo, ando moyo pag-aboridowan yay tongkol ha pa-mangan o inomon a kailangan moyo para mabyay tan yay tongkol ha doloh para ha lalaman moyo. Nga-min, mas maalag'a yay biyay moyo dinan ha pa-mangan tan yay lalaman moyo dinan ha doloh. ");
INSERT INTO xsb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bilyon moyo hilay mawmanok-manok: Kay hila ampamihabwag bini ni ampanglapot o ampanipon wari nin pa-mangan. Anodtaw pa man, ambiyan na hilan pa-mangan nin Ama moyo ha langit. Ambo doman mas maalag'a kamo dinan hilay mawmanok-manok? ");
INSERT INTO xsb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mag-aborido kamo man, kay moyoy nan lamang ma-paanloh a biyay moyo maskin a-say oras bongat, ambo doman? ");
INSERT INTO xsb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Anongkot ampag-aboridowan moyoy tongkol ha maipagdoloh moyo? Imatonan moyoy kato-tobo nin dawdikot ha lawak a ampi-pamolak. Kay hila ampagtrabaho ni anggomwa nin impagka-doloh la. ");
INSERT INTO xsb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kot ibalita ko komoyo, maskin hi Ari Solomon a pinakamayaman hin yadtaw ay kay nakapagdoloh nin anorin kaganda ha itsoran bawbolak. ");
INSERT INTO xsb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yay dawdikot a angka-kit tamo hawanin ha lawak, maari dilap ay malanoh ana ta bi-sa poolan lan tawtawo. No hila-rin a dawdikot a main pa-ngalanoh kot ampabolakon nan Dios ta ya-rin a impagka-doloh la, hikamo ot wari a kay na padolohan? Hay kakapoyan pay nan katotpol moyo! ");
INSERT INTO xsb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kanya ando kamo mag-aborido no ayti mangwan pa-mangan, o no ayti mangwan mainom, o no ayti mangwan maiholot. ");
INSERT INTO xsb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Anorin a bawbagay a ampakaisipon lan hilay ambo Israelita a kay magbilbi konan Dios. Kot ando moyo hila aligon bana ta tanda nan Ama moyo ha langit a kailangan moyo-rin halban. ");
INSERT INTO xsb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Masbali, mo-na mo-na moyon pag-inakitan somolong yay pa-mag-ari nan Dios tan ma-honol a main nan kalabayan, ta bi-sa halban pangangailangan moyo ay ibi na komoyo. ");
INSERT INTO xsb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Kanya ando moyo problimawon yay para ha awlon dilap ta yay Dios a makaolay komoyo. Tama anay problima konan yadtin awlo, ando moyoy na pa-lahan nin problima para dilap.” ");
INSERT INTO xsb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Wana ot ni Jesus, “Ando kamo manosga ha kapara moyo pigaw kay na kamo hosgawon nin Dios ha lomato a panaon. ");
INSERT INTO xsb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nga-min, hosgawon na kamon Dios ayon ha pa-nosga moyo ha kapara, ta no pa-noy trato moyo ha kapara ay anorin anamaot a gaw-on nan Dios komoyo.” ");
INSERT INTO xsb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bi-sa wani Jesus nin in-alimbawa, “Anongkot angka-sikaso moy pa-hal makalog a poling nin kapara mo, anta yay pa-hal mahi-ban a kayo ha mata mo kot kay mo angka-sikaso? ");
INSERT INTO xsb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Halako mon halitaon ha kapara mo, ‘Ipaalih mo kongkoy poling mo,’ anta main pa-hal mahi-ban a kayo ha mata mo. ");
INSERT INTO xsb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ampiabig-abig ka! Kailangan alihon mo yapon a pa-hal mahi-ban a kayo ha mata mo pigaw maka-kit kan labah, ta bi-sa maalih moy pa-hal makalog a poling nin kapara mo. ");
INSERT INTO xsb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yay Halita nan Dios ay masagrado, kanya ando moyo ipilit itoro konlan kay malabay. Kaalimbawaan nin ya-rin ay bilang moyon an-ibi pawpirlas ha aw-ason maramsak bi-sa kayaton la kamon bongat, o bilang moyon an-ibi ha bawbaboy bi-sa dakat-dakaton lan bongat.” ");
INSERT INTO xsb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Nangaral yay naman hi Jesus, wana, “Makirawat kamo konan Dios ta biyan na kamo; maningkap kamo ta maka-romog kamo; komatok kamo ta abriyan komoyo. ");
INSERT INTO xsb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nga-min, yay tawon ampakirawat ha Dios ay ma-biyan, yay ampaningkap ay maka-romog, tan yay angkomatok, konay abriyan. ");
INSERT INTO xsb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Alimbawa, hikamoy mawmatoantawo, biyan moyo wari bato a anak moyo no ampakirawat yan tinapay? ");
INSERT INTO xsb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O biyan moyo ya wari olay no ampakirawat yan konâ? ");
INSERT INTO xsb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No hikamoy tawtawo a main doka a ogali, kot tanda moyon mami konlan awa-nak moyo nin lawlabah a bagay, balo-balo pay na konan Ama moyo ha langit. Biyan ta biyan nan lawlabah a bagay hilay ampakirawat kona. ");
INSERT INTO xsb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Yay bawbagay a labay moyon gaw-on la komoyo nin kapara ay yadtaw anamaot a dapat moyon gaw-on konla. Nga-min, iti konan yadtin totoro ay hakop anay halban kawkapanogoan nan Dios tan yay tawtotoro lan pawpropita na ha Masanton Kasolatan.” ");
INSERT INTO xsb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Bi-sa nami yay naman alimbawa hi Jesus, wana, “Lomoob kamo ha pa-hal makipot a polta. Nga-min, yay pa-hal malawang a polta tan malawang a dalan ay mamonta ha impyirno, kot lako a ampagpa-wan ison. ");
INSERT INTO xsb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Balo ta yay pa-hal makipot a polta tan makipot a dalan ay mamonta ha langit, kot da-raoto a ampaka-romog nin ya-rin.” ");
INSERT INTO xsb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Wana ot ni Jesus, “Mag-ingat kamo konlan ampagkonwari nin pawpropita a mangangaral nan Dios. Ampako hila komoyo a bilang kawkarniron mangaamo, anta kapa-halan la ay mangaramsak a aw-ayop ta labay la kamon hamhaman. ");
INSERT INTO xsb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma-bilbi hila ha gawgawa lan ambo labah. Bilang ot bongat ha poon kayo, ma-bilbi ha bonga no anya magklasin kayo odti. Yay bongan obas ay kay ampotiwon ha poon aroma, tan yay bongan igos ay kay ampotiwon ha poon kokoh posa, ambo doman? ");
INSERT INTO xsb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kanya alimbawa, balang kayon angka-kan a bonga, no labah yan klasi, labah anamaot a bonga na. Kot no doka yan klasi, doka syimpri a bonga na. ");
INSERT INTO xsb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tanda tamo, ha kawkayon angka-kan a bonga, yay labah a klasi ay kay ampamongan doka a klasin bonga, tan anorin anamaot kapara ha doka a klasin kayo, kay ya syimpri ampamongan labah a klasi. ");
INSERT INTO xsb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yay balang poon kayon kay ampamongan labah a klasin bonga ay ampokanon ta poolan. ");
INSERT INTO xsb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Anorin ot bongat syimpri konlan ampagkonwari a mangangaral na hilan Dios, ma-bilbi hila ha klasin gawgawa la.” ");
INSERT INTO xsb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wana ot ni Jesus, “Ambo halban anha-way kongko ‘Katawan, Katawan’ ay mi-ka ha langit, nokay hilan bongat a anhomonol ha kalabayan nan Ama ko a itaw ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nga-min, ha awlon pangongokom, lako hilay mamibalita kongko nin anodti, ‘Katawan, ambo doman nangaral kami bilang propita ha ngalan mo? Ambo doman naka-palayah kami namaot dawdoka a ispirito konlan tawtawon nilooban bana ta hinabtan mi ngalan mo? Ambo doman nakagwa kami ot lako a ka-paka-ngap a gawgawa bana ha kapangyarian mo?’ ");
INSERT INTO xsb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kot ibalita ko konla, ‘Nika-ka-noman kay katamo binilbi kahakopan ko. Paka-dayo kamo kongko, hikamoy ma-mangwa doka.’” ");
INSERT INTO xsb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Wana ot ni Jesus, “Balang ampanglongo ha hawhalita ko tan anhonolon nadti, kaalimbawaan na ay tawon maronong a nama-dong bali na ha bato a ma-pagpondasyonan. ");
INSERT INTO xsb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bi-sa, hin nangabagat nin makhaw, nagbaha tan na-pahpah ot nin makhaw a lopot yay bali, kay natomba bana ta nakapondasyon naor ha bato. ");
INSERT INTO xsb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kot yay ampanglongo bongat nin hawhalita ko balo ta kay na anhonolon, kaalimbawaan na ay tawon kay ampangintindi ta yay pinili nan pamipa-dongan bali ay ha maboyangin. ");
INSERT INTO xsb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hin nangabagat nin makhaw, bi-sa nagbaha tan na-pahpah nin makhaw a lopot yay bali, natombay bali tan grabi a pa-makahira.” ");
INSERT INTO xsb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pa-makayari nan imbalita ni Jesus odtin bawbagay, naka-ngap hilay tawtawo ha klasin panonoro na, ");
INSERT INTO xsb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta nanoro yan bilang a-say main kapangyarian, ambo bilang ha panonoro lan mawmaistron kapanogoan nin aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hin inomaypa ana hi Jesus ibat ha bakil, golpin tawo a inomaloyon kona. ");
INSERT INTO xsb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tongwa, main nako kona nin a-say lalaki a main masakit kitong. Bi-sa nanalimokor yan palokob, ta wana, “Maistro, no labayon mo, ma-paabig mo ko.” ");
INSERT INTO xsb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Imparna ni Jesus a gamot na konan lalaki, bi-sa wana, “Labay ko. Omabig kay na!” Antimanoy naor, inomabig ya. ");
INSERT INTO xsb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bi-sa wani Jesus kona, “Ando mo iba-balita odti ha hinoman, nokay magdiritso ka ha pari ha Jerusalem pigaw ma-paptogan nan inomabig kay na. Mangawit kan ida-ton mo ayon ha impanogo ni Moises a pamilbian lan tawtawo a talagan labah kay na.” ");
INSERT INTO xsb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hin hoston lomoob hi Jesus ha babalin Capernaum, main hinomakbat kona nin a-say dayowan a kapitan hondalo nin Roma ta nagpasi-singa-ro kona, ");
INSERT INTO xsb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","wana, “Maistro, main akon alila a na-paralitiko. Nakaiira ya tana itaw komi. Kay nay na kano maagwantawan a masakit na.” ");
INSERT INTO xsb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wani Jesus kona, “Mako ko itaw ta paabigon ko ya.” ");
INSERT INTO xsb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kot wanan in-obat, “Maistro, ambo akon karapat-dapat para mako ka ot ha bali ko. Basta halitaon mon bongat ta omabig yay alila ko. ");
INSERT INTO xsb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nga-min, hiko man ay main akon poon tan main akoy namaot ga-got a hawhondalo. No wangko ha a-say hondalo ko, ‘Mako ka itaw!’ mako ya. No wangkoy namaot ha a-sa, ‘Mako ka iti!’ mako ya syimpri. Anorin anamaot kapara ha alila ko, no wangko konay ‘Gaw-on modti!’ gaw-on na.” ");
INSERT INTO xsb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Naka-ngap hi Jesus hin nalngo na-rin. Bi-sa wana konlan tawtawon an-omaloyon kona, “Yay potog, ibalita ko komoyo, ni kontamon Israelita ay homin ako ot na-kit a main anorin kakhaw a katotpol. ");
INSERT INTO xsb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Oya ot a ibalita ko komoyo: Ha lomato a panaon, lako hilay ambo Israelita a mangibat ha intiron mondo a maka-pakirongon mangan konlan kalimpapo-papoan tamon hi Abraham, hi Isaac tan hi Jacob itaw ha langit a kaarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kot hilay kapara tamon Israelita a dapat komon kot kabilang ha ampag-arian nan Dios, ha lomato a panaon ay lako konla a ibantak ha impyirno ha logar a sangkarobloman. Mi-tangih-tangih hila itaw tan mi-pigogot ha grabin kadya-dyaan.” ");
INSERT INTO xsb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bi-sa wani Jesus konan kapitan, “Morong kay na no-nin ta mangyari yay labay mo ayon ha katotpol mo.” Potog anaor, yadtaw ot a oras ay inomabig yay alila nan kapitan. ");
INSERT INTO xsb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hin nako hi Jesus ha bali ni Pedro, na-kit na a ampira yay katyangan ni Pedro ta angka-mot. ");
INSERT INTO xsb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Gina-gotan ni Jesus a gamot nan babayi. Kanya inomabig ya ha main nan pa-nga-mot, bi-sa nibangon ya ta sinirbiwan na hilay na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hin bandan yabi na, main lako a tawon nilooban nin dawdoka a ispirito a inawit koni Jesus. Ha a-say halita nan bongat ay pinalayah na hilay dawdoka a ispirito. Pinaabig na ot a halban inawit kona a main mawmasakit. ");
INSERT INTO xsb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kanya pinomtog odtaw impabalita nan Dios koni Propita Isaias, a wanan nakasolat, “Kinwa nay dawdipirinsyan lalaman tamo tan yay dawdoka a angkalayam.” ");
INSERT INTO xsb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ninghan, hin na-kit ni Jesus a golpin tawoy naman a tinomipon kona, imbalita na konlan dawdisipolos na a magparihadon lomipay ha alindayat. ");
INSERT INTO xsb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kot main a-say maistron kapanogoan a dinomani kona, ta wana, “Maistro, homonol ako komo maskin ayti ka mako.” ");
INSERT INTO xsb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kot wani Jesus kona, “Isipon mo yapon: Hilay aw-ason talon ay main hilan yokib tan hilay mawmanok-manok ay main hilan an-aponan: Kot hiko a Naglalaman Tawo ay homin sarilin balin ma-pagpainawawan.” ");
INSERT INTO xsb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wanay namaot nin a-sa konlan dawdisipolos ni Jesus, “Katawan, morong ako yapo itaw komi anggan makihiyay hi tatay ko ta pigaw maitabon ko ya.” ");
INSERT INTO xsb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kot wani Jesus kona, “Homonol kay na kongko ta hilay nati, ipaolay mo hilan itabon nin hilay tawtawon pa-hal nati ta kay hila anhomonol kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hawanin, nilomolan yay na hi Jesus ha baloto ta bi-sa hinomonol hilay namaot a dawdisipolos na kona. ");
INSERT INTO xsb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tongwa, hin itaw hilay na ha taaw ay nanglopot makhaw, kanya angka-hapwakan anan lalako a alon a baloto la. Balo ta angka-lok hi Jesus hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanya kina la yan pinokaw hi Jesus nin hilay dawdisipolos na, wanla, “Katawan, dandanon mo kami! Lomdog tamoy na!” ");
INSERT INTO xsb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kot wani Jesus konla, “Anongkot angkali-mo kamo? Hay kakapoyan pay nan katotpol moyo!” Bi-sa nibangon ya ta minandawan nan tomgon a makhaw a lopot tan lominak a lanom. Antimano tinominok anaor. ");
INSERT INTO xsb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ambo makano-kanoy pa-mag-ispanta lan hilay dawdisipolos ni Jesus. Wanla, “Anya kari magklasin tawo yadti ta maskin lopot tan alon kot anhomonol kona?” ");
INSERT INTO xsb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hin nakalipay hilay na ni Jesus ha alindayat, ha logar lan Gadareno, main loway lalakin nilooban nin dawdoka a ispirito a hinomakbat kona. Hiladtin lowa ay itaw ana ampagpirmi ha kamposanto. Masyado hilan mangaramsak kanya homin makapagkohaw nakom nin magpa-wan konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Hawanin, wanlan imbolyaw koni Jesus a impahalita lan dawdoka a ispirito, “Anongkot ampakiomonan mo kami, hika Jesus a Anak nan Dios? Labay mo kami na doman padya-dyaon anta ambo ot oras nin pangongokom?” ");
INSERT INTO xsb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hin ya-rin ay main itaw malabong a baboy a ampangkob ha ambo karayoan konla. ");
INSERT INTO xsb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kanya hilay dawdoka a ispirito a nilomoob konlan hiladtin loway lalaki ay nagpasi-singa-ro koni Jesus, wanla, “No palayahon mo kami, po-layan mo kami tanan lomoob konlan hila-rin bawbaboy.” ");
INSERT INTO xsb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wani Jesus konla, “Mako kamoy na!” Kanya inomalih hila konlan hila-rin lowa katawo ta bi-sa nilomoob konlan bawbaboy. Tongwa, halban lan baboy ay bigla nipo-polayon paloyhon ha bongaw diritson alindayat. Kanya ni-ka-lilimoh hila. ");
INSERT INTO xsb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hawanin, hilay ma-magbantay konlan bawbaboy ay nolayon nako ha babali ta imba-balita lay halban nangyari, pati yay nangyari konlan loway lalakin datin nilooban dawdoka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kanya halos halban tawo ha babali ay nilomikol para hakbaton hi Jesus. Pa-maka-kit la kona ay impaki-totol la a omalih yay na ha logar la. ");
INSERT INTO xsb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hawanin, nilomolan hilan oman ni Jesus ha baloto, ta nilomipay hilan norong ha babalin Capernaum a ampagpirmiwan na. ");
INSERT INTO xsb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bi-sa main a-say lalakin paralitiko a inalsa nin omnoy tawo nin iti ha an-iraan na ta ini-ka la koni Jesus. Hin na-kit ni Jesus a main lan katotpol, wana konan paralitiko, “Talakaka, pakhawon moy nakom mo ta pinatawad koy nay kawkasalanan mo.” ");
INSERT INTO xsb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hawanin, main itaw nin mawmaistron kapanogoan a nakalngo ha hinalita ni Jesus. Wanla ha sarili la, “Ha anorin a hinalita na ay an-ipantay nay sarili na ha Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kot tanda ni Jesus a laman isip la, kanya wana konla, “Anongkot anorin kadoka a isip moyo kongko? ");
INSERT INTO xsb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anya kot yay mas maganoh gaw-on maskin homin kapangyarian, yay halitaon konan paralitiko, ‘Pinatawad koy nay kawkasalanan mo,’ o yay halitaon kona, ‘Mibangon ka ta lomalako ka’? ");
INSERT INTO xsb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ipa-kit ko komoyo hawanin ha pa-maabig ko konan yadtin tawo a hiko a Naglalaman Tawo ay main akoy namaot kapangyarian magpatawad nin kawkasalanan iti ha lota.” Bi-sa wana konan paralitiko, “Mibangon ka, kowon moy an-iraan mo ta morong kay na.” ");
INSERT INTO xsb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nibangon yay naor bi-sa norong yay na. ");
INSERT INTO xsb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hin na-kit ladtin ginwa ni Jesus nin hilay malabong a tawo itaw, naka-ngap hila. Pinori la yay Dios a nami nin anodtin klasin kapangyarian ha tawo. ");
INSERT INTO xsb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hin nagpatoloy hi Jesus nin nilomalako, na-kit nay a-say ma-ni-non bowis a hi Mateo a antoklo itaw ha opisinan ampamayaran bowis. Wana kona, “Homonol ka kongko.” Inomdong ya tan paibat hin ya-rin, hinomonol yay na kona. ");
INSERT INTO xsb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hin nakalato hilay na ha bali ni Mateo, lo-gan lan ampangan ni Jesus tan hilay dawdisipolos na, tongwa nakalato a kalakan ot ma-ni-non bowis a mangahaol tan laloma ot a tawtawon makasalanan ta nakirongo hilan nangan. ");
INSERT INTO xsb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hin na-kit la-rin nin hilay paw-Pariseo a panay rawrilihyoso, wanla konlan dawdisipolos na, “Anongkot ampakirongo yan mangan ya-rin maistro moyo konlan ma-ni-non bowis tan laloma ot a tawtawon makasalanan?” ");
INSERT INTO xsb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hin nalngo ni Jesus ya-rin imbalita la, wanan in-alimbawa konla, “Ambo hilay mawmaligsa a ampangailangan nin doktor, nokay hilay mawmain masakit. ");
INSERT INTO xsb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Intindyon moyoy kanaboan nin yay wana ha Masanton Kasolatan, ‘Mas labay koy inganga-ro moyo ha kapara dinan yay dawda-ton moyo.’ Nga-min, yay pa-mako ko iti ay ambo para ha-wayan hilay hay wanla lawlabah hilan tawo, nokay para paombabalyon hilay mawmakasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hawanin, nako hilay antoroan ni Juan Bautista koni Jesus ta pinastang la ya, wanla, “Hikami tan hilay paw-Pariseo ay mabotbot ampagsakripisyon kay mangan. Anongkot hilay dawdisipolos mo kai?” ");
INSERT INTO xsb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Inobat na hila ni Jesus nin in-alimbawa nay sarili na ha a-say nobyo, wana, “Kay maari a hilay kombidado ha kahal ay lomolo tan magsakripisyon kay mangan lo-gan kalamoan la yay nobyo. Balo ta lomato yay panaon a ambo la yay nan kalamoan, ison hilay na magsakripisyon kay mangan.” ");
INSERT INTO xsb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bi-sa imparalan ni Jesus ha aw-alimbawa a yay ba-yon totoro na ay ambo dapat ilamo ha naiknawan a kaogalian nin rilihyon a bilang ha pa-magsakripisyon kay mangan tan laloma ot, ta wana, “Kay antalo-noban a lapok anan ayhing nin ba-yon ritaso a kay ot kinomo-tot. Ta no gaw-on orin, kako-ko-tot nan ba-yon ritaso, mabira yay pinanalo-noban, magi-nit anaman nin mas grabi ot. ");
INSERT INTO xsb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Anorin anamaot kapara, kay an-igwa a ba-yon alak a ampag-alsa ot, ha pamigwaan a lapok a katat. Ta no anorin a gaw-on, ha kaaalsa nan alak ay lomtoh yay pinamigwaan, masayang yay alak tan mahira ot yay pinamigwaan. Kailangan yay ba-yon alak a ampag-alsa ot ay itobong ha ba-yon pamigwaan, pigaw parihon kay masayang.” ");
INSERT INTO xsb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lo-gan na ot an-ibalita ni Jesus orin konla, main nakalato nin a-say ampamoon ha sinagoga. Nanalimokor yan palokob, ta wana, “Kapimati nan anak kon babayi. Maki-ka ka pa kongko ta iparna moy gamot mo kona pigaw mabyay ya.” ");
INSERT INTO xsb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kanya antimano naki-ka hi Jesus kona nin kalamo hilay disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tongwa, main a-say babayin labinloway taon anan andayaon a tinomombok koni Jesus. Dinomani ya ha bokotan ni Jesus ta kinowit nay palpal ayhing na. ");
INSERT INTO xsb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nga-min, wana ha sarili na, “Ma-kowit ko tanay ayhing na ay omabig akoy na.” ");
INSERT INTO xsb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Binomling hi Jesus. Pa-maka-kit na kona, wana, “Talakaka ko, pakhawon moy nakom mo ta inomabig kay na bana ha main mon katotpol.” Paibat ya-rin, labah yay nay babayi. ");
INSERT INTO xsb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hin nakalato hi Jesus ha bali ni Jairo, na-lato na a main anan mawmosikiro a ampanogtog plaota tan malabong a tawon mawmakatlok. ");
INSERT INTO xsb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wani Jesus konla, “Omalih kamoy na ta kay ya nati ya-rin a dalagita, nokay angka-lok yan bongat.” Kot kinaka-lihan la hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Balo ta, hin na-paalih hilay nay malabong a tawo, nilomoob hi Jesus ha kamainan nan anak, bi-sa ginawang nay gamot na. Kanya nibangon yay anak. ");
INSERT INTO xsb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya-rin ginwa ni Jesus ay nibantog ha intiron ka-libol nan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hin an-omalih hilay na ni Jesus itaw, main loway lalakin bolag a maaaloyon kona. Wanlan inha-way, “Lipi ni Ari David, inga-rowan mo kami.” ");
INSERT INTO xsb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hin nilomoob yay na hi Jesus ha bali, dinomani hiladtin bolag kona. Kanya wani Jesus konla, “Ampi-pol kamo doman a ma-paabig katamo?” “Iya, Maistro,” wanlan in-obat. ");
INSERT INTO xsb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kanya inaptoh nay mata la, bi-sa wana, “Mangyari orin labay moyo ayon ha pa-mi-pol moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kanya antimano naka-kit hilay na. Hawanin, wanan impaka-bibilin ni Jesus konla, “Ando moyo totolon odti ha hinoman.” ");
INSERT INTO xsb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Balo ta hin inomalih hilay na, imba-balita la syimpri ha intiron logar la yay tongkol ha ginwa ni Jesus konla. ");
INSERT INTO xsb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pa-makaalih la, main namaot a-say lalakin omol a inawit lan tawtawo koni Jesus. Nag-in yan omol gawa nin doka a ispirito a nilomoob kona. ");
INSERT INTO xsb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pa-makayari nan pinalayah ni Jesus yay doka a ispirito, nakahalita yay nay omol. Hilay lako a tawon naka-kit ay nag-ispanta, tan wanlan imbalita, “Ba-ba-yo kami naka-kit nin anodtin nangyari iti ha Israel.” ");
INSERT INTO xsb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kot wanlan paw-Pariseo, “Kanya ya ampaka-palayah nin dawdoka a ispirito ay bana ta binyan na yan kapangyarian nin poon lan dawdoka a ispirito.” ");
INSERT INTO xsb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hawanin, hi Jesus tan hilay dawdisipolos na ay kina-kina lay bawbabali tan bawbaryo ta nangaral ya ha sawsinagoga la. Impangaral na yay Labah a Balita tongkol ha pa-mag-ari nan Dios, tan pinaabig nay namaot a tawtawo ha balang masakit tan dipirinsya la. ");
INSERT INTO xsb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hin na-kit ni Jesus hilay lako a tawo, nadabo a inganga-ro na konla, ta bilang hilan kawkarniron makapoy ana tan niboyak bana ta homin hilan pastol. ");
INSERT INTO xsb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanya wana konlan disipolos na, “Talagan kalakan tawtawo a kailangan ma-pahawangan para tompol ha Dios. Kaalimbawaan la ay golpin gagapason, kot hilay pa-hal ma-ngapas ay da-raoto. ");
INSERT INTO xsb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kanya dawaton moyo ha Katawan a main ikon konlan hila-rin a pa-hal gagapason a mamihogo yan tawtawo para pa-hal mangapas konla.” ");
INSERT INTO xsb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Hina-wayan ni Jesus hilay labinloway disipolos na, ta binyan na hilan kapangyarian mamalayah dawdoka a ispirito ha tawtawon nilooban, tan kapangyarian mamaabig halban klasin mawmasakit tan dawdipirinsya. ");
INSERT INTO xsb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Oyay ngawngalan lan labinloway apostolis a ihohogo na: yay o-na, hi Simon a pinangalanan anamaot Pedro, bi-sa hi Andres a talakaka nan yadtin hi Pedro, hilay mitalakakan Santiago tan Juan a awa-nak ni Zebedeo, ");
INSERT INTO xsb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","hi Felipe tan hi Bartolome, hi Tomas tan hi Mateo a ma-ni-non bowis, hi Santiago a anak ni Alfeo, hi Tadeo, ");
INSERT INTO xsb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hi Simon a mainakit ha nasyon Israel tan hi Judas Iscariote a nagtraidor koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hawanin, wanan imbibilin ni Jesus konlan labinloway ihohogo na para mangaral, “Ando kamo mako ha lawlogar lan hilay ambo Israelita, maski ha bawbabali lan taga Samaria. ");
INSERT INTO xsb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yay dapat moyon kaon ay hilay kaparan Israelita a kapa-halan kot kawkarniron nitalon, ta dinomayô hila ha Dios a pa-hal pastol la. ");
INSERT INTO xsb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mako kamon mangaral konla. Ibalita moyo, ‘Madani nay nan ipa-kit Dios a pa-mag-ari na.’ ");
INSERT INTO xsb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Paabigon moyo hilay mawmain masakit pati hilay main kitong, paorongon moyoy namaot mabyay hilay nawnati tan paalihon moyoy dawdoka a ispirito ha tawtawon nilooban. Ando moyo ipabayaran a kata-tambay moyo, bana ta kay na impabayaran nin Dios yay kapangyarian a inimbi na komoyo. ");
INSERT INTO xsb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ando kamoy na magbalon kwarta a bilang ha balitok, pilak o tanso. ");
INSERT INTO xsb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ha pa-mako moyo, ambo anamaot kailangan a mangawit kamon bag, ni risirban ayhing o apin o baston. Nga-min, yay ma-magtrabaho ay main yan karapatan mananggap ipagkabyay na. ");
INSERT INTO xsb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ha aytimay babali o baryo a kaon moyo, mamiliw kamon tawon marapat pakihandaan ta makihanda kamo kona anggan omalih kamo konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kalo-loob moyo ha bali na, idawat moyo konan Katawan a biyan na hilan kaliswayan nakom. ");
INSERT INTO xsb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","No hilay tawtawo ha bali na ay marapat mananggap nin kaliswayan nakom, mangyari yay dawat moyo. Kot no ambo hilan marapat, kay mangyari yay dawat moyo. ");
INSERT INTO xsb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No wari ta kay la kamo labay tanggapon o long-on ha a-say bali o ha a-say babali, omalih kamo itaw. Oltimon gabok ha ayi moyo ay pagpagon moyo. ");
INSERT INTO xsb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yay potog, ibalita ko komoyo, ha awlon pangongokom ay mas mabyat a parosa nan Dios konlan tawtawo ha anorin a klasin babali dinan konlan taga Sodoma tan taga Gomorra a bantog ha main lan karokaan hin yadtaw.” ");
INSERT INTO xsb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wana ot ni Jesus konlan aw-apostolis na, “Tandaan moyo a an-ihogo katamo bilang kawkarniro a maka-paki-lamo ha mangaramsak a ayop. Kanya kailangan mag-ingat kamo a bilang pa-mag-ingat lan aw-olay tan magpakapinon ogali a bilang ogali nin kalapati. ");
INSERT INTO xsb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-ingat kamo ha tawtawo, ta ha lomato a panaon ay main komoyo a iintriga ha gawgropon ampamoon ha sawsinagoga a main katongkolan para manosga ta bi-sa ipagaroti la kamo itaw. ");
INSERT INTO xsb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Main komoyo a awiton pilit ha gawgobirnador o ha aw-ari para imbistigawon bana ha katotpol moyo kongko. Balo ta mag-in oportonidad moyo-rin para maiabot konla tan konlan ambo Israelita yay kaptogan tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ha panaon a ipaimbistiga la kamo, ando kamo mag-aborido no pa-no moyo hila obaton o anyay halitaon moyo, bana ta konan ya-rin a oras ay ipaisipan komoyo yay dapat moyon halitaon. ");
INSERT INTO xsb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nga-min, ambo mangibat ha sarili moyon isip a halitaon moyo, nokay yay Ispirito nan Dios a Ama moyo a mamipaisip nin dapat moyon halitaon. ");
INSERT INTO xsb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Yay mangyari ot, main talakaka a ipapati nay talakaka na a antompol, o main matoantawo a ipapati nay anak na a antompol. Tan anorin anamaot kapara ha awa-nak a kay antompol, lomaban hila ha mawmatoantawo la a antompol anggan ha toloy la hilan ipapati. ");
INSERT INTO xsb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tiplonon la kamon halban tawtawon kay antompol bana ha katotpol moyo kongko. Kot yay makapagpatoloy nin maptog kongko anggan ha oltimo ay malipyas. ");
INSERT INTO xsb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No andamsakon la kamo ha a-say babali, omalih kamo ta mako ha laloman babali. Yay potog, ibalita ko komoyo: Kay moyo ot na-ka a halban babali iti ha Israel ay makalato akoy nan oman, hiko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Bi-sa nagpatoloy yan nangwawali hi Jesus konlan dawdisipolos na, wana, “Yay antoroan ay ambo yan mata-gay ha maistro na. Anorin anamaot kapara ha a-say alila, ambo yan mata-gay ha amo na. ");
INSERT INTO xsb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kanya yay a-say antoroan no ampakaranas ya nin bilang ha na-ranasan nin maistro na, dapat tanggapon na-rin. Anorin anamaot kapara ha a-say alila no ampakaranas ya nin bilang ha na-ranasan nin amo na, dapat tanggapon nay namaot ya-rin. Bilang ot bongat kongko a maiparis ha ampamoon ha pamilya, no hiko kot anha-wayan lan Satanas, mas mabyat a gaw-on la komoyon impagka-pamilya ko.” ");
INSERT INTO xsb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wana ot ni Jesus, “Anodtaw pa man, ando kamo mali-mo. Nga-min, homin nakaari a kay ma-tandaan tan homin sikrito a kay mibolgar. ");
INSERT INTO xsb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Alimbawa, anyaman a an-ibalita ko komoyo ha maroblom ay ibalita moyo ha mahawang, labay totolon, anyaman a an-isikrito ko komoyo nin hikamo-hikamon bongat ay ipangaral moyo ha tawtawo ha lomato a panaon. ");
INSERT INTO xsb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ando kamo mali-mo konlan malabay mangmati komoyo bana ha katotpol moyo kongko ta lalaman moyon bongat a ma-pati la. Kay la maano yay kalolwa moyo. Yay Dios a kali-mowan moyo, bana ta hiyay main kapangyarian nin mami-ka ha impyirno nin ambo bongat lalaman moyo nokay pati kalolwa. ");
INSERT INTO xsb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ambo doman angkailako a loway layno ha a-say sintimos bongat? Anodtaw pa man, homin ni a-sa konla a bastay nan bongat madabo no kay na aboloyan nin Ama moyo ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Balo-balo pay na komoyo, oltimon habot moyo ay tanda nay bilang. ");
INSERT INTO xsb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kanya ando kamo mali-mo ha anyamay mangyari komoyo, bana ta mas maalag'a kamo ot ha lako a layno.” ");
INSERT INTO xsb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Wana ot ni Jesus, “Hinoman a ampamibalita ha kapara na a hiko kot Katawan na ay bilbion ko yay namaot ha arapan nan Ama ko ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Balo ta hinoman a ampamibalita ha kapara na a ambo na kon Katawan ay ibalita koy namaot ha arapan nan Ama ko ha langit a ambo na kon Katawan.” ");
INSERT INTO xsb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bi-sa wana ot ni Jesus, “Ando moyo isipon a nako ko iti ha kalotaan pigaw magkamain pa-misosondo a halban tawtawo. Ambo pa-misosondo nin halban tawo a ogotan nin pa-mako ko iti, nokay masbali magkamain pa-milalaban bana kongko. ");
INSERT INTO xsb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Alimbawa, hikoy bara-nan a main anak a lalaki a kontra ha tatay na, main anak a babayi a kontra ha nanay na, tan main anamaot manoyang a babayi a kontra ha katyangan nan babayi. ");
INSERT INTO xsb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mismon ka-pamilya nin a-say tawo ay komontra kona bana ha katotpol na kongko. ");
INSERT INTO xsb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kanya, yay tawon mas ampamabli ha tatay na o nanay na dinan kongko ay ambo yan karapat-dapat itoring a kahakopan ko. Tan yay tawon mas ampabliwon nay awa-nak na dinan kongko ay ambo ya syimprin karapat-dapat itoring nin kahakopan ko. ");
INSERT INTO xsb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hinoman a kay mananggap nin kadya-dyaan a andomalan ha biyay na alang-alang kongko a kaalimbawaan kay na balatayon a sarili nan kros, tan kay namaot homonol kongko ay ambo yan karapat-dapat itoring nin kahakopan ko. ");
INSERT INTO xsb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yay tawoy namaot a ambo matibolos a nakom mati alang-alang kongko ay kay na matanggap yay biyay a homin anggawan. Kot yay tawon mati alang-alang kongko ay matanggap nay biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Bi-sa wana ot ni Jesus, “Yay tawon ampananggap komoyo ay bilang hikoy antanggapon na. Tan yay ampananggap kongko ay bilang yay nanogo kongko a antanggapon na. ");
INSERT INTO xsb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yay tawoy namaot a ampananggap ha a-say propita bana ta bilbi na yan propita nan Dios ay makatanggap nin primyo a bilang ha primyon ibi konan ya-rin a propita. Anorin anamaot kapara, yay ampananggap ha a-say tawon mahonol ha Dios bana ta tanda nan a-sa yan mahonol ha Dios ay makatanggap yan primyo a bilang ha primyon ibi konan ya-rin a tawon mahonol ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tan hinoman a manambay ha a-sa konlan pinakamaaypa ha hilap nin tawo, maskin a-say bason lanom bongat a ipainom na kona bana ta tanda na a ya-rin a tawo kot anhomonol kongko, ibalita ko komoyo, sigoradon tobaloon na yan Dios ha ginwa nan kaabigan.” ");
INSERT INTO xsb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hin nayari na hilan binibilinan ni Jesus a labinloway disipolos na, nako ya nanoro tan nangaral ha ka-libol a bawbabali. ");
INSERT INTO xsb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hin ya-rin ay nakapriso hi Juan Bautista. Kot hin na-tandaan nay gawgawa ni Cristo ay namihogo ya kona nin loway tinoroan na para pastangon la ya. ");
INSERT INTO xsb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pa-makalato la itaw kona, wanla, “Hikay na doman kano yadtaw ampalatoon a ihogo nan Dios, o main ot doman laloman taga-nan?” ");
INSERT INTO xsb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Wanan in-obat ni Jesus, “Magbolta kamo koni Juan ta ibalita moyodtin nalngo tan na-kit moyon gawgawa ko. ");
INSERT INTO xsb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ibalita moyo a hilay bawbolag ay ampaka-kit ana, hilay lawlompo ay ampakalalakoy na, hilay main masakit kitong ay ampaabigon ana, hilay tawtolok ay ampakalngo ana, main ni-kati a ampaorongon mabyay, tan hilay mangairap ay an-abotan anan Labah a Balita tongkol ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ibalita moyoy namaot a makalma yay tawon kay ampagdoda a hikoy inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hin inomalih hilay nay inhogo ni Juan Bautista, main yan imbalita hi Jesus konlan malabong a tawo itaw tongkol koni Juan. Wana, “Hin nako kamo koni Juan itaw ha disyirto, anya kot a labay moyon ma-kit? Tawo doman a paba-yo-ba-yoy isip a bilang ha talaib a ampaki-ki-ka ha lopot? Ambo yan anorin. ");
INSERT INTO xsb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anya kot talagay labay moyon ma-kit? Tawo doman a nakaholot nin primira klasin doloh? Ambo anorin a na-kit moyo itaw ta hilay nakaholot nin primira klasin doloh ay itaw hila ma-kit ha palasyo a an-iwanan ari. ");
INSERT INTO xsb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Anya no-nin a kina moyon biniliw itaw? Ambo doman a-say propita a mangangaral nan Dios? Ibalita ko komoyo a maholok ot ha a-say propita a na-kit moyo. ");
INSERT INTO xsb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nga-min, hi Juan yadtaw antokoyon ha Masanton Kasolatan, a wanan Dios, ‘Main akon ihogo nin mo-na komo a mamiparihadon kanakoman lan tawtawo para ha main mon kala-lato.’ ");
INSERT INTO xsb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yay potog, ibalita ko komoyo: Ha halban tawon impangabing, homin ot propitan homolok koni Juan Bautista. Anorin pa man, maskin yay tawon an-ibilang nin pinakamaaypa konlan ampag-arian nan Dios ay holok ot koni Juan. ");
INSERT INTO xsb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Paibat hin nangaral hi Juan Bautista anggan hawanin, lako a ampagpilit nin mailamo ha ampag-arian nan Dios, kanya angkailamo hila bama ha kapi-pilit la. ");
INSERT INTO xsb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Hin yadtaw, ha Masanton Kasolatan ha lawlibron sinolat lan propita, tan ha Libron Kawkapanogoan a sinolat ni Moises ay impatandaan nan Dios yay tongkol ha lomato a pa-mag-ari na. Kot hin hi Juan ana ay an-ibalita na a mag-ompisay nay pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","No labay moyon pi-polon, ya-rin hi Juan ay hiyay na a pa-hal hi Propita Elias a impatandaan lan pawpropita nan Dios hin yadtaw a makon oman iti. ");
INSERT INTO xsb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hawanin, hikamoy ampakalngo, intindyon moyoy nalngo moyo. ");
INSERT INTO xsb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ayti ko kari iparis a tawtawo nin yadtin panaon? Kaalimbawaan la ay awa-nak a ampiikap ha plasa a angkasora ha kawkaikap la, a wanla, ");
INSERT INTO xsb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ampanogtog kami para komoyo, kot kay moyo labay bomayli. Ampiaanito-anito kami ot, kot kay moyo syimpri labay ki-tangih-tangih komi.’ ");
INSERT INTO xsb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Anorin anamaot koni Juan, angkasorawan la yan tawtawo ta mabotbot yan ampagsakripisyon kay mangan tan kay ya ampinom alak, kanya anhalitaon la a nilooban yan doka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bi-sa, hiko a Naglalaman Tawo ay ampangan tan ampinom, bi-sa anhalitaon lan hiko kot lo-noh tan ma-maglahing, tan ampakiamigo konlan ma-ni-non bowis tan laloma ot a tawtawon makasalanan. Kot yay ampango-na komi ay karonongan ibat ha Dios ta angka-patnagan ha bonga a bilang ha biyay lan anhomonol komi.” ");
INSERT INTO xsb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Bi-sa pinanalitaan ni Jesus hilay tawtawo ha bawbabalin pinangwaan nan lako a mawmilagro, bana ta kay hila ni-pangombabali ha main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wana, “Hikamoy taga Corazin tan hikamoy taga Betsaida, ka-ka-roy ogotan moyo! No yay mawmilagro a ginwa ko ha babali moyo kot itaw ko ginwa ha Tiro tan Sidon a kamainan nin tawtawon homin tanda tongkol ha Dios ay naboyot hilay na komon nagholot nin sako tan tinomoklo ha abo, pamilbian nin pa-ngombabali la ha main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ibalita ko komoyo, ha awlon pangongokom ay mas mabyat a parosa nan Dios komoyo, dinan konlan taga Tiro tan konlan taga Sidon. ");
INSERT INTO xsb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hikamoy namaot a taga Capernaum, yay labay moyo lawo ay ita-gay kamo anggan ha langit! Kot ibagsak kamo ha impyirno! No yay mawmilagro a ginwa ko ha babali moyo kot ginwa ha Sodoma hin yadtaw, sigoradon nangombabali hila tan kay na komon inabagat Dios nin apoy a babali la. ");
INSERT INTO xsb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ibalita ko komoyo, ha awlon pangongokom ay mas mabyat a parosa nan Dios komoyo dinan konlan taga Sodoma.” ");
INSERT INTO xsb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Hin ya-rin ot a oras, dinomawat hi Jesus, wana, “Ampaki-salamat ako komo, Ama a Katawan nin langit tan lota, ta yay kanaboan nin an-ipangaral ko ay insikrito mo pigaw kay la maintindyan nin hilay mawmaronong tan hilay mawmatalino, balo ta impaintindyan mo konlan ma-ngaaypa a nakom a bilang ha mangakalog a awa-nak. ");
INSERT INTO xsb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ginwa mo-rin, Ama, ta ya-rin a kalabayan mo ayon ha main mon kaabigan.” ");
INSERT INTO xsb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bi-sa wani Jesus konlan tawtawo, “Halban bawbagay ay impa-taya kongko nin Ama ko. Homin ampaka-bilbi hosto kongko no ambo yay Ama. Anorin anamaot kapara, homin ampaka-bilbi nin hosto konan Ama, no ambo hiko a Anak na tan hilay labay kon pamipabilbian.” ");
INSERT INTO xsb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Wana ot ni Jesus, “Hikamoy pa-hal mapagal tan angka-pabyatan, domani kamo kongko ta biyan katamon kapainawawan. ");
INSERT INTO xsb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Iholot moyoy pa-hal babah ko, labay totolon, patoro kamo kongko ta mapangabot ako tan ma-ngaaypa a nakom, pigaw magkamain kamon kaliswayan nakom. ");
INSERT INTO xsb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nga-min, yay pa-hal babah ko ay malo-paw, ta yay an-ipagawa ko ay maganoh.” ");
INSERT INTO xsb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ninghan, a-say Awlon Pa-mainawa nin aw-Israelita, nagpa-wan hi Jesus tan hilay dawdisipolos na ha bowat. Hin ya-rin ay mabitil hilay dawdisipolos na. Kanya na-nangto hilan trigo, bi-sa la kinan. ");
INSERT INTO xsb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kot main itaw nin paw-Pariseo a naka-kit konla. Kanya wanla koni Jesus, “Bilyon mo-rin a anggaw-on lan dawdisipolos mo, anta ayon ha kawkapanogoan nan Dios ay bawal orin no Awlon Pa-mainawa ta maitoring anan trabaho orin.” ");
INSERT INTO xsb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kot wanan in-obat ni Jesus konla, “Ambo doman nabasa moyodtaw ginwa ni David tan hilay kawkalamoan na hin mabitil hilay na? ");
INSERT INTO xsb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ambo doman nilomoob ya ha impagka-bali nan Dios ta bi-sa nangan ya pati hilay kawkalamoan na nin tinapay a inda-ton ha Dios a inimbi nan pari kona? Bawal komon ayon ha kapanogoan nan Dios a kanon ladtaw bana ta para bongat ha pawpari. ");
INSERT INTO xsb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ambo doman nabasa moyo ot ha Masanton Kasolatan ha Libron Kawkapanogoan a yay kasi-sirbi lan pawpari ha timplo no Awlon Pa-mainawa kot kay orin an-ibilang kako-kontra ha kapanogoan tongkol ha Awlon Pa-mainawa, ta mas maalag'a yay timplo dinan ha Awlon Pa-mainawa? ");
INSERT INTO xsb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ibalita ko komoyo, yay karongo moyo hawanin ay mas maalag'a ot dinan ha timplo. ");
INSERT INTO xsb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wana ot ha Masanton Kasolatan, ‘Mas labay koy inganga-ro moyo ha kapara dinan yay dawda-ton moyo.’ No komon ta angkaintindyan moyo-rin, kay moyo komon hinosgawan a dawdisipolos ko ta homin hilan ginwa a doka. ");
INSERT INTO xsb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tandaan moyo a hiko a Naglalaman Tawo a makaolay no anyay dapat ha Awlon Pa-mainawa.” ");
INSERT INTO xsb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bi-sa nagdiritso hilay na ni Jesus ha sinagoga. ");
INSERT INTO xsb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hawanin, main a-say lalaki itaw a paralitikoy a-say gamot. Main anamaot itaw nin paw-Pariseo. Pinastang la hi Jesus, wanla, “Ayon ha kawkapanogoan nan Dios, maari doman mamaabig ha Awlon Pa-mainawa?” Nga-min, ampaningkap hilan bara-nan pigaw ma-kasowan la hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kot wani Jesus konla, “Alimbawa ta main komoyo a main karniro a nadabo ha malalo a lobot ha Awlon Pa-mainawa, kay mo wari alawahon? ");
INSERT INTO xsb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mas maalag'a yay tawo dinan ha karniro. Kanya, ayon ha kawkapanogoan nan Dios, yay kagogwa abig ha Awlon Pa-mainawa ay ambo bawal.” ");
INSERT INTO xsb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bi-sa wana konan lalakin paralitikoy gamot, “Ipa-nat moy gamot mo.” Impa-nat nay naor, kanya antimano inomabig a gamot na ta nag-in anan bilang ha dobali. ");
INSERT INTO xsb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bi-sa nilomikol hilay paw-Pariseo ta pinipapa-nowan la no pa-no maipapati hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tanda ni Jesus yadtin plano lan paw-Pariseo, kanya inomalih ya konan ya-rin a logar. Lako a tawtawon tinomombok kona. Halban main masakit konla ay pinaabig na. ");
INSERT INTO xsb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kot binibilinan na hilan ando mamibalita nin tongkol kona. ");
INSERT INTO xsb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ha anorin a nangyari, na-paptogan yay hinalita ni Propita Isaias hin yadtaw tongkol koni Jesus, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Oyay pinili kon ma-magsirbi ko. Hiyay anlabyon ko tan angkalilikot akon labah kona. Ihogo ko konay Ispirito ko ta ipatandaan na konlan ambo Israelita yay paralan para kay ko hila parosawan. ");
INSERT INTO xsb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kay ya maki-porpya tan kay ya magta-gay bosis, kanya kay malngo a bosis na ha kalsada. ");
INSERT INTO xsb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kay na ilorlor a tawon ka-ka-ro a bilang nahpak anan bolo, o kari ipoyra a tawon makapoy anay katotpol a bilang apoy a makoyop anay pabilo. Masbali gomwa yan paralan anggan ha matalo nay pa-mang-api-api konla. ");
INSERT INTO xsb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanya kona pomasimala maski hilay ambo Israelita.” ");
INSERT INTO xsb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ninghan, main anaman tawtawon nangawit koni Jesus nin a-say lalakin bolag tan omol ta nilooban yan doka a ispirito. Pinalayah ni Jesus yay doka a ispirito, kanya tampol yan nakahalita tan naka-kit oman yadtin lalaki. ");
INSERT INTO xsb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naka-ngap hilay halban tawo itaw, kanya wanla, “Hiyay na wari yay Lipi ni Ari David a impangako nan Dios para mag-in ari tamo?” ");
INSERT INTO xsb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kot hin nalngo lan paw-Pariseo odti, wanlan in-obat, “Ambo! Angka-palayah nan bongat a dawdoka a ispirito, bana ta hi Satanas a poon lan dawdoka a ispirito a nami kona nin kapangyarian.” ");
INSERT INTO xsb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tanda ni Jesus a laman isip la, kanya wana konla, “Mahira a balang kaarian, no hila-hila ot a ampikokontra. Tan kay bomoyot a a-say babali o kari a-say pamilya, no hila-hila ot a ampikokontra. ");
INSERT INTO xsb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kanya, no wari ta potog a ampamalayah hi Satanas nin kapara nan doka a ispirito, ampikokontra hila no-nin. No anorin, pa-no man makapagpatoloy a kaarian na? ");
INSERT INTO xsb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A-sa ot a rason: Wamoyo, hi Satanas a nami kongko nin kapangyarian para mamalayah dawdoka a ispirito. Hapay namaot hilay kawkalamoan moyo a ampamalayah anamaot dawdoka a ispirito, hino man no-nin a nami konla nin kapangyarian? Ambo doman yay Dios? Hila-rin mismo a kalamoan moyo a maari mamaptog a lawlingo kamo! ");
INSERT INTO xsb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hawanin, bana ta yay Ispirito nan Dios a nami kongko nin kapangyarian para mamalayah dawdoka a ispirito, labay totolon, yay pa-mag-ari nan Dios ay nilomato ana komoyo. ");
INSERT INTO xsb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nga-min, hi Satanas ay bilang a-say tawon makhaw a kailangan balolon yapon, bi-sa makaloob ha bali na pigaw ma-hamham a main nan kama-main. Kanya mapatnag a tinalo koy na hi Satanas ta angka-palayah koy dawdoka a ispirito a kampon na.” ");
INSERT INTO xsb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Hawanin, wanan impatandaan ni Jesus, “Yay tawon kay angkomampi kongko ay kontra kongko. Anorin anamaot kapara, yay tawon kay ampakitambay kongko nin manipon tawtawo para tompol kongko ay bilang ot bongat an-ipaka-dayo na hila kongko. ");
INSERT INTO xsb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kanya ibalita ko komoyo: Ma-patawad a balang kasalanan nin tawo maskin yay pa-maroroka ha kapara, kot yay pa-maroroka ha Masanton Ispirito nan Dios ay kay ma-patawad. ");
INSERT INTO xsb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hinoman a ampanalita nin kontra kongko a Naglalaman Tawo ay ma-patawad na ya ot Dios. Kot hinoman a ampanalita nin kontra ha Masanton Ispirito nan Dios ay kay na ya patawaron, hawanin man a panaon o mika-ka-noman.” ");
INSERT INTO xsb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Wana ot ni Jesus nin in-alimbawa, “Ha kayon angka-kan a bonga, no labah yan klasi, labah anamaot a bonga na. Kot no doka yan klasi, doka syimpri a bonga na. Nga-min, ha bonga ma-bilbi no yay kayon angka-kan a bonga kot labah o doka yan klasi. ");
INSERT INTO xsb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anorin ot bongat komoyo, bilang kamon olay a madita! Palibhasay doka a pa-magnanakom moyo, kanya yay hawhalita moyo ay ampakahira ha kapara. Nga-min, no anyay laman nin kaisipan, lomwah ta lomwah ha boboy. ");
INSERT INTO xsb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yay labah a tawo ay ampakapamin kaabigan ibat ha lawlabah a aral a natipon na ha main nan kanakoman. Kot yay doka a tawo ay karokaan a angkaibi na ibat ha dawdoka a natipon na ha main nan kanakoman. ");
INSERT INTO xsb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ibalita ko komoyo, ha awlon pangongokom, obaton nin tawtawo yay balang hinalita lan homin kwinta. ");
INSERT INTO xsb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nga-min, yay panonosga nan Dios komo ay ayon ha hawhinalita mo. No labah a hawhinalita mo, kay ka parosawan, kot no doka a hawhinalita mo, parosawan na ka.” ");
INSERT INTO xsb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bi-sa wanlan hilay laloman mawmaistron kapanogoan tan paw-Pariseo koni Jesus, “Maistro, labay mi komon pa-kitan mo kamin milagro a pamilbian a inhogo na kan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kot wanan in-obat ni Jesus, “Hikamoy tawtawo hawanin, masyadoy nan dawdoka tan ambo kamon maptog ha Dios ta ampaningkapan moyo ko ot nin pamilbian. Kot homin anan laloman pamilbian a ipa-kit komoyo, no ambo yadtaw tanay kaparihon nangyari koni Propita Jonas hin yadtaw. ");
INSERT INTO xsb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","No pa-non toloy awlo tan toloy yabi ni Propita Jonas ha lalo tiyan nin balyina, anorin anamaot kapara kongko a Naglalaman Tawo, toloy awlo tan toloy yabi koy namaot ha lalo panabonan. ");
INSERT INTO xsb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha awlon pangongokom, hiladtaw taga Ninive ay omdong ta ibalita la a hikamoy tawtawo hawanin ay nagkasalanan. Nga-min, hin nangaral hi Propita Jonas konla hin yadtaw ay ni-pangombabali hila. Balo ta hikamo, maskin iti koy na komoyo a mas holok ot koni Propita Jonas ay kay moyo ko anlong-on. ");
INSERT INTO xsb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Maskin yadtaw Rayna nin ‘Bagatan’ a ambo tamon kaparan Israelita ay omdong anamaot ha awlon pangongokom ta ibalita na a nagkasalanan kamo. Nga-min, halos kalindoyo-doyowan ana nin mondo a inibatan na, kot nako ya syimpri koni Ari Solomon hin yadtaw para manglongo ha karonongan na. Balo ta hikamo, maskin iti koy na komoyo a mas holok ot koni Ari Solomon ay kay moyo ko anlong-on,” wani Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bi-sa tinoroan na hilay naman ni Jesus, wana, “Alimbawa, no main a-say doka a ispirito a inomalih ha tawon nilooban, tomala ya ha lawak a homin kalanom-lanom ta mamiliw nin laloman maiwanan. Kot no homin yan ma-kit, ");
INSERT INTO xsb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","halitaon na ha sarili na, ‘Magbolta ko tana ha inibatan ko.’ No ha pa-magbolta na kot ma-kit na a yay dati nan nilooban ay bilang ha a-say balin bakanti, malinis tan maayos, ");
INSERT INTO xsb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yay gaw-on na ay mako yan mangwa nin pitoy ispirito a mas doka ot kona. Bi-sa lomoob hila tan magpirmi konan ya-rin a tawo. Kanya yay mag-in pa-hal nan ya-rin a tawo ay mas grabi na ingat dinan hin o-na. Anorin ot bongat yay mangyari konlan dawdoka a tawo hawanin ta lomoor anan lomoor a karokaan la,” wani Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lo-gan na ot ampanalita ni Jesus konlan tawtawo, nilomato a nanay na tan tawtalakaka nan lalaki. Itaw hila an-omdong ha likol bali ta impapibalita la tana a labay la yan paki-totolan. ");
INSERT INTO xsb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kanya main namibalita koni Jesus, wana, “Ison ha likol yay nanay tan tawtalakaka mo ta labay la kan paki-totolan.” ");
INSERT INTO xsb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wanan in-obat ni Jesus konan lalakin namibalita kona, “Tanda mo doman no hino-hinoy an-itoring kon nanay tan tawtalakaka?” ");
INSERT INTO xsb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bi-sa intoro na hilay dawdisipolos na, ba-yo wana, “Oy hilay an-itoring kon nanay ko tan tawtalakaka. ");
INSERT INTO xsb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nga-min, hinoman a anhomonol ha kalabayan nan Ama ko ha langit ay an-itoring kon tawtalakaka tan nanay.” ");
INSERT INTO xsb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yadtaw ot a awlo, inomalih hi Jesus ha bali, ta nako ya tinomoklo ha liglig alindayat nin kalamo hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pinititiponan la yan malabong a tawtawo, kanya nako ya tinomoklo ha baloto a itaw ha lanom. Kot yay intiron kalabongan ay iti ha liglig. ");
INSERT INTO xsb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bi-sa tinoroan na hilan lako a bawbagay a imparalan na ha aw-alimbawa, wana, “Main a-say tawon nako nanabwag bini. ");
INSERT INTO xsb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ha pananabwag na, main bini a ni-ka ha dalan. Na-romogan lan mawmanok-manok, kanya na-min lan kinan. ");
INSERT INTO xsb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Main anamaot ni-ka ha logar a mabato a maimpih bongat a lota, bi-sa tampol tinomobo palibhasay maimpih anaor a lota. ");
INSERT INTO xsb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kot hin ma-mot anay awlo, nalanoh bi-sa toloy anan nati ta kay nakapangyamot labah. ");
INSERT INTO xsb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Main anamaot ni-ka ha logar a antoboan dawdikot a marowih. Kato-tobo nan bini, nagsalidan tinomobo anamaot a dawdikot, kanya kay nakaaliwahwah. ");
INSERT INTO xsb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Balo ta yay bini a nadabo ha magandan lota ay ni-pamongan lako. Main namongan sanyatos, main a-nom a polo, tan main anamaot tolompolo.” ");
INSERT INTO xsb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bi-sa wana ot ni Jesus, “Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bi-sa dinomani koni Jesus hilay dawdisipolos na ta pinastang la ya. Wanla kona, “Anongkot an-iparalan mo ha aw-alimbawa a pa-noro mo konlan tawtawo?” ");
INSERT INTO xsb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wanan in-obat ni Jesus, “Komoyon bongat an-ipaintindyan a sawsikrito tongkol ha pa-mag-ari nan Dios, ambo ha laloman tawo. ");
INSERT INTO xsb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nga-min, hinoman a ampi-pol ha an-ipaintindi nan Dios kona ay pa-lahan a angkaintindyan na anggan mag-in lako. Kot hinoman a kay ampi-pol ha an-ipaintindi nan Dios kona ay alihon ot kona yay daoto a angkaintindyan na. ");
INSERT INTO xsb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kanya ko an-iparalan ha aw-alimbawa a pa-noro ko konla, bana ta maskin ambiliwon lay gawgawa ko ay kay lay nan lamang ambilbion a yadti kot kapangyarian nan Dios. Tan maskin ampanglongo hila ha hawhalita ko ay bilang kay la angkalngo tan kay ladti angkaintindyan. ");
INSERT INTO xsb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kanya ampomtog konla yadtaw impabalita nan Dios hin yadtaw koni Propita Isaias, a wanan nakasolat, ‘Manglongo kamo man anan manglongo kot kay kamo makaintindi, tan mamiliw kamo man anan mamiliw kot kay kamo maka-bilbi. ");
INSERT INTO xsb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nga-min, hikamoy tawtawo, mangatiboy anay aw-olo, kanya bilang kamoy nan tawtolok tan bilang an-iiplong moyoy mawmata moyo, no komon ta ambo moyon anorin, ma-patnagan moyo a kapa-pa-hal moyo tan malngo moyoy an-ipangaral komoyo pigaw maintindyan moyo. Bi-sa, no mangombabali kamo ta magbolta kongko ay ilipyas katamo.’” ");
INSERT INTO xsb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wana ot ni Jesus konlan dawdisipolos na, “Makalma kamo ta angka-patnagan moyoy angka-kit moyo tan angkaintindyan moyoy angkalngo moyo. ");
INSERT INTO xsb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yay potog, ibalita ko komoyo: Lako a pawpropita nan Dios tan laloma ot a tawtawon mahonol kona hin yadtaw a ngali-ngalin manganon maka-kit tan makapanglongo nin bilang ha angka-ka-kit tan angka-kalngo moyo hawanin kongko. Kot kay yadti nangyari hin panaon la.” ");
INSERT INTO xsb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bi-sa wani Jesus, “Long-on moyoy labay nan totolon nin alimbawa ko nangon tongkol konan yay ma-mihabwag nin bini. ");
INSERT INTO xsb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yay bini ay Halita nan Dios tongkol ha pa-mag-ari na. Balang tawon ampanglongo nin yadti ta bi-sa kay na angkaintindyan ay tampol nan an-alihon ni Satanas orin a nalngo na ha main nan kaisipan. Ya-rin a kaalimbawaan nin bini a ni-ka ha dalan. ");
INSERT INTO xsb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Yay lota anamaot a mabato a pini-kaan nin bini ay tawon ampanglongo Halita nan Dios, bi-sa tampol nan ampi-polon odti nin main kaligawan. ");
INSERT INTO xsb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kot pa-hal kay ampakapangyamot odti ha nakom na. Antompol ya kot kado-domali bongat, ta no ma-pairapan ya tan ma-damsak bana ha kaho-honol na ha Halita nan Dios ay tampol yan antomgon. ");
INSERT INTO xsb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Yay lota a antoboan dawdikot a marowih a pini-kaan nin bini ay tawon ampanglongo Halita nan Dios, balo ta angkadaog yay Halita nan Dios a nalngo na, bana ta ampag-aboridowan nay kabi-biyay iti ha mondo tan mailig ya ha kayamanan. Kanya yay angkalngo na ay kay ampamongan lawlabah a gawa ha main nan biyay. ");
INSERT INTO xsb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Kot yay magandan lota a pinanabwagan bini ay tawon ampanglongo tan ampakaintindi nin Halita nan Dios. Kanya yay nalngo na ay ampamongan lawlabah a gawa ha main nan biyay. Hawanin, konlan hiladti, main a yay lawlabah a gawa na ay maiparis ha sanyatos a bonga, main anamaot maiparis ha a-nom a polo, tan main maiparis ha tolompolo.” ");
INSERT INTO xsb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nanotol hi Jesus nin a-say naman a alimbawa, wana, “Yay pa-mag-ari nan Dios ay bilang ha magandan bini a trigo a inhabwag nin a-say lalaki ha main nan bowat. ");
INSERT INTO xsb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kot kinayabiwan, hin ampi-ka-lok anay tawtawo, main a-say ampangontra konan yadtin lalaki a nako ha bowat na ta hinabwagan nan bawbongan dikot bi-sa inomalih ya. ");
INSERT INTO xsb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hin tinomobo yay bawbini, tinomobo anamaot yay inhabwag a bawbongan dikot. Hin parihoy nan ampamonga, ison bongat na-kit a main laok dawdikot. ");
INSERT INTO xsb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hin na-kit lay dikot nin hilay aw-alila nan main ikon bowat, kina la yay main ikon bowat, ta wanlan imbalita, ‘Amo, ambo doman maganda yay bawbini a trigo a inhabwag mo ha main mon bowat? Anongkot man ta main anan golpin dawdikot a kalaok?’ ");
INSERT INTO xsb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Wanan in-obat nin amo la, ‘Sigoradon a-say angkomontra a main gawa nin ya-rin.’ Pinastang la yan aw-alila na, wanla, ‘Labay mo wari a kaon min botboton a dawdikot?’ ");
INSERT INTO xsb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kot wanan amo la, ‘Ando, ta ola-no ma-botbot moyo pati yay trigo. ");
INSERT INTO xsb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Basta po-layan moyo tana yapo ta painsan no panaon anan pa-manglapot, ibalita ko konlan ma-manglapot a tiponon la yapon a dawdikot ta takol-takolon para poolan. Balo ta yay tawtrigo ay tiponon ta igwa ha kamalig.’” ");
INSERT INTO xsb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Bi-sa nanotol yay naman hi Jesus konlan disipolos na nin laloman alimbawa. Wana, “Yay ompisan pa-mag-ari nan Dios ay bilang ha a-say botol mostasa a inmola nin a-say tawo ha main nan bowat. ");
INSERT INTO xsb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maskin yadti nay pinakamakalog ha halban klasin botol, balo ta hin tinomobo ana, yadti nay pinakamahi-ban a klasin poon pihing a bilang kayo kahi-ban. Kanya angkaon nin mawmanok-manok tan ampanalayan la ot a hawhanga na.” ");
INSERT INTO xsb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wanay naman konla nin in-alimbawa ni Jesus, “Yay kaka-kalat nin pa-mag-ari nan Dios ay bilang ha pampalbag. Maskin daoto bongat a inigwa nin a-say babayi ha tolon halop a arina ay na-palbag nay intiro.” ");
INSERT INTO xsb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ya-rin halban intoro ni Jesus konlan malabong a tawo ay imparalan na ha aw-alimbawa. Homin yan intoro konla a kay na ginamitan alimbawa. ");
INSERT INTO xsb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kanya pinomtog yay impabalita nan Dios konan a-say propita na hin yadtaw, a wanan nakasolat, “Iparalan ko ha aw-alimbawa a pa-noro ko konla. Totolon ko konlay bawbagay a kay impatandaan paibat hin pinalsa a kalotaan.” ");
INSERT INTO xsb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pa-makayari, imbati ni Jesus hilay malabong a tawo ta nilomoob ya ha balin an-iwanan na. Dinomani hilay disipolos na kona, ta wanla, “Ipalino mo pa komi yay kanaboan nin yadtaw alimbawa tongkol ha dawdikot a tinomobo kalamo ha trigo.” ");
INSERT INTO xsb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wanan in-obat ni Jesus, “Hiko a Naglalaman Tawo a kaalimbawaan nan tawon nanabwag nin magandan bini. ");
INSERT INTO xsb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yay pa-hal ampalbwatan ay yadtin kalotaan. Yay magandan bini ay hilay tawtawon ampahakop ha pa-mag-ari nan Dios, tan yay bawbongan dikot anamaot ay hilay tawtawon ampag-arian ni Satanas. ");
INSERT INTO xsb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yay angkomontra a nanabwag nin bawbongan dikot ay hi Satanas. Yay panaon pa-manglapot ay yay panganggawan nin babon lota. Hilay namaot a ma-manglapot ay hilay aw-anghil. ");
INSERT INTO xsb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","No pa-non yay dawdikot kot tiponon bi-sa poolan ay anorin ot bongat a mangyari konlan dawdoka a tawo ha panganggawan nin babon lota. ");
INSERT INTO xsb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hiko a Naglalaman Tawo a mamihogo konlan aw-anghil ko para tiponon a halban tawtawon ampamoon-poon nin kawkasalanan, pati halban lan anggomwa dawdoka ta ipolok hila ha tawtawon ampahakop ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bi-sa ibantak hila ha apoy itaw ha impyirno. Mi-tangih-tangih hila itaw tan mi-pigogot ha grabin kadya-dyaan. ");
INSERT INTO xsb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kot hilay mahonol ha Dios ay mag-in hilan mahnag a bilang ha awlo itaw ha kaarian nan Ama la ha langit. Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Wana ot ni Jesus, “Yay pa-mag-ari nan Dios ay na-pakaalag'a a bilang ha kayamanan a nakakotkot ha bowat. Bi-sa main a-say tawo a naka-romog nin yadti. Tinambagan na yapon, bi-sa ha kahi-banan kaligawan na ay tampol yan norong ta inlako nay halban kama-main na, ta hinaliw na-rin lota a kamainan nin yadtin kayamanan.” ");
INSERT INTO xsb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Wana ot ni Jesus, “Kaalimbawaan ot nin pa-maka-romog ha pa-mag-ari nan Dios a na-pakaalag'a ay bilang ha a-say nigosyanti a ampaningkap nin mangablin pirlas. ");
INSERT INTO xsb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hin naka-romog yan a-say pirlas a talagan mablin klasi, norong ya ta inlako nay halban kama-main na, ta hinaliw na yadtin pirlas.” ");
INSERT INTO xsb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Wana ot ni Jesus, “Kaalimbawaan ot nin pa-mag-ari nan Dios ay bilang ha a-say sinsoro a ingkatkat ha ambay, bi-sa nakakwa nin kalakan nangasasari a konâ. ");
INSERT INTO xsb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hin napno ana, binira lay na ha liglig nin hilay ma-magsinsoro. Bi-sa tinomoklo hila ta impolok lay mawmagandan konâ ha mawmakasta a kay ma-pakinabangan. Yay mawmaganda ay inigwa la ha pamigaw-an ta yay mawmakasta a kay ma-pakinabangan ay imbantak. ");
INSERT INTO xsb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Anorin ot bongat a mangyari ha panganggawan nin babon lota. Hilay aw-anghil ay mako iti para ipolok hilay dawdoka a tawo konlan lawlabah a tawo. ");
INSERT INTO xsb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bi-sa hilay dawdoka a tawo ay ibantak hila ha apoy itaw ha impyirno. Mi-tangih-tangih hila itaw tan mi-pigogot ha grabin kadya-dyaan.” ");
INSERT INTO xsb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bi-sa pinastang ni Jesus hilay disipolos na, wana, “Angkaintindyan moyo doman odtin aw-alimbawa a intoro ko?” “Iya, Katawan,” wanlan in-obat. ");
INSERT INTO xsb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bi-sa wani Jesus konla, “Kanya, balang maistron kapanogoan a na-toroan anamaot tongkol ha pa-mag-ari nan Dios, yay kaalimbawaan na ay a-say main ikon bali a main inlimpoh a dawdaan tan bawba-yon kahangkapan ha pamilimpohan na pigaw pariho nan magamit. Labay totolon, yay maitoro na ay ambo bongat yay daan a kawkapanogoan, nokay pati yay ba-yo nan na-tandaan.” ");
INSERT INTO xsb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pa-makayari nan tinotol ni Jesus orin a aw-alimbawa ay inomalih yay na konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bi-sa norong ya ha Nazaret a sarili nan babali ta nangaral ya itaw ha sinagoga la. Naka-ngap hilay nakalngo kona. Wanla, “Ayti kari naibat a karonongan na, tan pa-no na angkagawa ya-rin gawgawa a pamilbian ambo bastan kapangyarian nan Dios? ");
INSERT INTO xsb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ambo doman ya-rin yay anak nan karpintiro? Ambo doman yay nanay na ay hi Maria, tan yay tawtalakaka nan lawlalaki ay hila hi Santiago, hi Jose, hi Simon tan hi Judas? ");
INSERT INTO xsb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ambo doman iti kontamo hilay halban tawtalakaka nan bawbabayi? Ayti na kari na-tandaan orin halban?” ");
INSERT INTO xsb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hinalita la-rin ta nasora hila kona. Kanya wani Jesus konla, “An-igalang a propita maskin ayti, poyra ha sarili nan logar tan bali.” ");
INSERT INTO xsb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kanya oomnon bongat a milagron ginwa ni Jesus itaw konla bana ha kay la pa-mi-pol kona. ");
INSERT INTO xsb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hin ya-rin a panaon, na-tandaan ni Ari Herodes Antipas a ampamoon ha probinsyan Galilea a kabantogan ni Jesus bana ha gawgawa na. ");
INSERT INTO xsb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hawanin, wana konlan tawtawo na, “Hiya hi Juan Bautista. Pinaorong yan nabyay, kanya main yan kapangyarian gomwa ka-paka-ngap a bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hinalita nadti, bana ta impapati na hi Juan Bautista. Anodti a nangyari: Impadakop na ya, impabalol tan impapriso bana koni Herodias a impagkaambali na, anta kaambali ya ni Felipe a talakaka na. ");
INSERT INTO xsb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nga-min, hin yadtaw ay sinita ni Juan Bautista hi Ari Herodes Antipas, a wana, “Ambo tama ayon ha kapanogoan nan Dios, ya-rin a anggaw-on mon an-ipagkaambali moy ayro mo.” ");
INSERT INTO xsb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bana konan ya-rin a pa-nita ni Juan, labay na ya komon ipapati ni Ari Herodes Antipas. Kot angkali-mo ya ha tawtawo ta ampi-polon la a hi Juan kot a-sa yan propita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hawanin, hin nakalato a awlon kapangabingan ni Ari Herodes Antipas ay nagsilibra ya. Binomayli yay anak a dalaga ni Herodias ha arapan lan bawbisita. Na-ligawan yay ari, ");
INSERT INTO xsb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kanya nangako ya konan dalaga tan pinaghompaan na ot a ibi na konay anyakamay pastangon na. ");
INSERT INTO xsb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ayon ha imbalita ni Herodias a nanay nan dalaga ay anodti a wana, “Labay ko komon a ibi mo kongko hawanin yay olo ni Juan Bautista nin nakaigwa ha bandihado.” ");
INSERT INTO xsb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nilomolo yay ari. Kot bana ha pinaghompaan nan pangako tan ha arapan la paot nin hilay bawbisita na, inmanda na a ibi ladti konan dalaga. ");
INSERT INTO xsb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kanya kina hi Juan itaw ha prisowan ta pino-tohan yan olo. ");
INSERT INTO xsb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bi-sa inawit yay olo na nin nakaigwa ha bandihado ta inimbi konan dalaga. Ba-yo inimbi nan dalaga konan nanay na. ");
INSERT INTO xsb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yay ginwa lay namaot nin hilay tinoroan ni Juan ay kina lan kinway bangkay na ta intabon. Bi-sa nako hila koni Jesus ta imbalita lay nangyari. ");
INSERT INTO xsb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hin nalngo ni Jesus yadtin nangyari koni Juan, nilomolan ya ha baloto nin kalamo hilay disipolos na, ta inomalih hila itaw ta nako ha a-say logar a homin tawo. Lako a tawon naka-tanda a inomalih hi Jesus, kanya tinomombok hila kona ibat ha bawbabali itaw nin nilomalakon nangli-liglig ha alindayat. ");
INSERT INTO xsb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pa-makalakah ni Jesus ha baloto, na-kit nay golpin tawo. Nadabo a inganga-ro na konla, kanya pinaabig na hilay mawmain masakit. ");
INSERT INTO xsb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hin anyomabi na, dinomani hilay disipolos na kona, ta wanla, “Homin kabali-bali iti tan madani nan domoblom. Pa-kaon mo hilay nay tawtawo ha bawbaryo pigaw makahaliw hilan pa-mangan la.” ");
INSERT INTO xsb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kot wani Jesus, “Ambo anan kailangan mako hila ot manaliw. Hikamoy nay mamin pa-mangan la.” ");
INSERT INTO xsb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wanlan disipolos na, “Main tamon bongat limay tinapay tan loway konâ.” ");
INSERT INTO xsb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Awiton moyo iti kongko,” wani Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bi-sa pinatoklo na hilay malabong a tawo ha dikot a magandan tokloan. Pa-makayari ay kinwa na yay limay tinapay tan loway konâ, ta bi-sa tinomangal ya ha langit ta pinasalamatan na yay Dios. Bi-sa pini-pikna na ba-yo na inimbi konlan disipolos na ta bi-sa impapto la konlan malabong a tawo. ");
INSERT INTO xsb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Halban la ay nakapangan tan ni-kabhoy. Bi-sa, hin tinipon lan disipolos na yay ni-katla a pini-pikna nin tinapay ay nakapno hila ot nin labinloway bakol. ");
INSERT INTO xsb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yay bilang lan lawlalaki a ni-pangan ay manga limanlibo, ambo kalamo ha bilang hilay bawbabayi tan awa-nak. ");
INSERT INTO xsb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pa-makayari ya-rin, pinalolan na hila ni Jesus ha baloto a dawdisipolos na, ta pinao-na na hilan lomipay ha alindayat lo-gan ampaibwaton na hilay tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hin na-paibwat na hilay na, hinomaka hi Jesus ha bakil para domawat ha Dios. Asa-sa na itaw nin na-palatan yabi. ");
INSERT INTO xsb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hin ya-rin a oras, yay baloton anlolanan lan disipolos na ay madayo ana ha liglig alindayat. Angkaipa-pahpah odti nin lalako a alon ta halonga hila ha lopot. ");
INSERT INTO xsb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hin palbangon ana, tinomombok hi Jesus konlan disipolos na nin anlalako ha babon lanom. ");
INSERT INTO xsb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hin na-kit la a main anlalako ha babon lanom ay nali-mo hilan masyado, “Molto,” wanla. Ha kali-mowan la ay nakaaghaw hila. ");
INSERT INTO xsb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kot antimano nanalita hi Jesus konla, wana, “Ando kamo mali-mo ta hikodti! Pakhawon moyoy nakom moyo!” ");
INSERT INTO xsb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wanan in-obat ni Pedro, “Katawan, no hika-rin, pa-kaon mo ko-son nin lomalako ha babon lanom.” ");
INSERT INTO xsb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wani Jesus kona, “Mako kay na-ti.” Kanya nilomakah hi Pedro ha baloto ta nilomalako ya ha babon lanom namagka koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kot hin na-kit na a makhaw yay lopot, nali-mo ya. Tongwa anlomdog yay na, kanya wanan inha-way, “Katawan, dandanon mo ko!” ");
INSERT INTO xsb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Antimano, ginawang na ya ni Jesus. Bi-sa wana kona, “Hay kapoy nin katotpol mo. Anongkot nagdoda ka?” ");
INSERT INTO xsb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pa-makalolan la ha baloto, bigla tinomgon a makhaw a lopot. ");
INSERT INTO xsb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hilay kawkalamoan na ha baloto ay dinaniwan la ya ta sinamba, wanla, “Talagan hikay Anak nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hin nakalipay hilay na ay nilomakah hila itaw ha kapatagan Genesaret. ");
INSERT INTO xsb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hin na-bilbi hi Jesus nin hilay tawtawo itaw, impapibalita la ha halban lawlogar itaw a nakalato ya. Kanya inawit koni Jesus a halban mawmain masakit. ");
INSERT INTO xsb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bi-sa nagpasi-singa-ro hila kona a maskin ma-kowit la tanay palpal ayhing na pigaw omabig hila. Kanya halban lan naka-kowit ayhing na ay inomabig. ");
INSERT INTO xsb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ninghan, main paw-Pariseo tan mawmaistron kapanogoan a ibat ha syodad Jerusalem a nako koni Jesus, ta wanla, ");
INSERT INTO xsb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Anongkot kay la anhonolon dawdisipolos mo yay naiknawan tamon totoro lan kapapo-papoan tamo? Ampagkasalanan hila ta ampangan hilan kay anggaw-on a sirimonyan pa-mibano ba-yo mangan.” ");
INSERT INTO xsb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kot pinastang na hilay namaot yapo ni Jesus, wana, “Hapa hikamo, anongkot man kay moyo anhonolon a kapanogoan nan Dios, boga tanay makahonol kamo ha naiknawan moyon kaogalian? ");
INSERT INTO xsb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Oyay kapanogoan nan Dios: ‘Igalang moy tatay mo tan nanay mo.’ ta bi-sa ‘Hinoman a mamaroroka ha tatay na o nanay na ay dapat yan patyon.’ ");
INSERT INTO xsb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kot hikamo, anodti an-itoro moyo: No main manalita ha tatay na o nanay na, ‘Yay anyaman a maitambay ko komo ay intatala ko para ida-ton ha Dios,’ konan ya-rin ay ambo nay nan kailangan tambayan a matoantawo na. ");
INSERT INTO xsb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ha anorin a totoro moyo ay lomwah a ambo nay nan kailangan igalang a matoantawo na. Kanya an-alihan moyon alaga yay kapanogoan nan Dios, boga tanay ma-honol yay an-itoro moyon naiknawan a kaogalian. ");
INSERT INTO xsb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ampiabig-abig kamo! Mitama komoyo yay impabalita nan Dios koni Propita Isaias, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kaboboy-boboy bongat a pa-magsamba la kongko nin hiladtin tawtawo, Tan yay kaga-galang la ay nangangga ha halita bongat ta marayo a nakom la kongko. ");
INSERT INTO xsb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Homin anan lamang kwinta a pa-magsamba la kongko, Ta yay aw-impanogo nin tawo ay an-ipangaral lan bilang aral ibat kongko.’” ");
INSERT INTO xsb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hawanin, pinadani ni Jesus hilay malabong a tawo, bi-sa inobat nay pastang no anongkot kay la anggaw-on yay sirimonyan pa-mibano ba-yo mangan, wana, “Paka-long-on moyoy halitaon ko tan pakaintindyon. ");
INSERT INTO xsb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ambo yay an-ipaloob ha boboy a makapamin kasalanan ha tawo, nokay yay an-ipalwah ha boboy yay ampakapamin kasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bi-sa dinomani hilay disipolos na kona, ta wanla, “Tanda mo doman a na-hakitan a kanakoman lan paw-Pariseo hin nalngo la-rin hinalita mo?” ");
INSERT INTO xsb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Inobat na hila ni Jesus ha a-say alimbawa tongkol konlan paw-Pariseo tan mawmaistron kapanogoan, wana, “Balang tanaman a ambo nan mola nin Ama ko ha langit ay botboton. ");
INSERT INTO xsb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kanya po-layan moyo hila ta bilang hilan bawbolag a ampangakay ha kapara lan bolag. Kapag bolag a ampangakay ha kapara nan bolag, pariho hilan madabo ha kanal.” ");
INSERT INTO xsb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kot wani Pedro kona, “Ipalino mo pa komi yadtaw no-nan alimbawa mo.” ");
INSERT INTO xsb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Wani Jesus, “Pati hikamo wari ay kay ot ampakaintindi? ");
INSERT INTO xsb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kay moyo doman angkaintindyan a yay an-ipaloob ha boboy ay andomiritso ha tiyan bi-sa an-idiskarga? ");
INSERT INTO xsb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kot yay anlomwah ha boboy a dawdoka a halita ay ibat ha nakom. Yadti a ampakapamin kasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nga-min, ha nakom nin tawo ampangibat a dawdoka a isip, pa-mangmatin tawo, pa-mabayi o pa-maki-lalaki, tan laloma ot a imoralidad a gawa, paniniba, pa-nistigon kagalotoyan, tan pa-maroroka ha kapara. ");
INSERT INTO xsb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hiladti a ampakapamin kasalanan ha tawo. Kot yay kay anggaw-on a sirimonyan pa-mibano ba-yo mangan ay kay ampakapamin kasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bi-sa inomalih hi Jesus tan hilay disipolos na konan ya-rin a logar, ta nako hila ha kapatagan a madani ha syodad Tiro tan syodad Sidon a ambo anan hakop nin Israel nokay hakop anan Canaan. ");
INSERT INTO xsb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hawanin, main a-say babayin taga Canaan a hinomakbat koni Jesus. Wanan inha-way, “Katawan, lipi ni Ari David, inga-rowan mo ko pa! Yay anak kon babayi kot masyadon ampagdya-dya ta nilooban yan doka a ispirito.” ");
INSERT INTO xsb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kot ni a-say halita ay kay na ya inobat ni Jesus. Kanya dinomani hilay disipolos na ta impaki-totol la ya kona, wanla, “Gaw-on mo pay na pigaw morong yay na ta ha-way yay nan ha-way nin mato-totombok kontamo.” ");
INSERT INTO xsb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kot wani Jesus, “Yay pinanogoan kongko ay para bongat konlan kaparan Israelita a kapa-halan kot kawkarniron nitalon ta dinomayô hila ha Dios a pa-hal pastol la.” ");
INSERT INTO xsb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Anodtaw pa man, dinomani ya syimpri ya-rin a babayi koni Jesus. Nanalimokor yan palokob ha arapan na, ta wana, “Katawan, tambayan mo ko pa.” ");
INSERT INTO xsb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","In-alimbawa ni Jesus a obat na, wana, “Ambo labah a kowon yay pa-mangan lan awa-nak ta bi-sa ibi konlan aw-aso.” ");
INSERT INTO xsb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maskin naintindyan nan babayi a yay dapat nan o-nawon tambayan ay hilay Israelita, wana syimpri, “Potog orin, Katawan, kot maskin hilay aw-aso ay ampangan hila syimprin mawmomo a nadabo ha hilong lamisawan nin amo la.” ");
INSERT INTO xsb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanya wani Jesus kona, “Hay kahi-banan katotpol mo, talakaka. Mangyari no-nin orin a labay mo.” Kanya antimano inomabig a anak nan yadtin babayi. ");
INSERT INTO xsb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Inomalih hi Jesus pati hilay disipolos na itaw, bi-sa nilomalako hilay naman nin nangli-lig-lig ha Alindayat Galilea. Bi-sa hinomaka hila ha a-say bakil ta tinomoklo itaw hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ni-pakalato konay golpin tawo. Main hilan awit pawpilay, bawbolag, aw-omol, sawsingkol, tan lako ot a main nangasasari a klasin masakit. Bi-sa, itaw hila inigwa ha arapan ni Jesus. Kanya pinaabig na hila. ");
INSERT INTO xsb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Naka-ngap hilay tawtawo hin na-kit lan nakahalita hilay aw-omol, nag-in maayos a sawsingkol, nakalalako hilay nay pawpilay, tan naka-kit hilay bawbolag. Kanya pinori la yay Dios a ansambawon nin aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hin toloy awlo lay na itaw, hina-wayan ni Jesus hilay disipolos na, ta wana konla, “Angka-ka-rowan koy tawtawo ta na-hominan hilay nan pa-mangan, bana ta toloy awlo lay na iti. Kay ko labay paorongon hilan mabitil ta ola-no maolaw hila ha dalan.” ");
INSERT INTO xsb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kot wanlan disipolos na, “Ayti tamo man wari mangwan pa-mangan a harag maibi konla? Hay kalakan la paot tan homin kabali-bali iti.” ");
INSERT INTO xsb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Wani Jesus konla, “Omno ot a tinapay moyo ison?” “Pito bongat tan main oomnon mangakalog a konâ,” wanla. ");
INSERT INTO xsb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bi-sa pinatoklo ni Jesus hilay tawtawo ha lota. ");
INSERT INTO xsb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hawanin, kinwa nay pitoy tinapay tan yay konâ, bi-sa pa-makayari nan pinasalamatan yay Dios ay pini-pikna na ta inimbi konlan disipolos na, ta bi-sa impapto la konlan malabong a tawo. ");
INSERT INTO xsb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Halban la ay nakapangan tan ni-kabhoy. Bi-sa, hin tinipon lan disipolos na yay ni-katla a pini-pikna nin tinapay, nakapno hila ot nin pitoy bakol. ");
INSERT INTO xsb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yay bilang lan lawlalaki a ni-pangan ay a-pat a libo, ambo kalamo ha bilang hilay bawbabayi tan awa-nak. ");
INSERT INTO xsb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Hawanin, pinaorong ni Jesus a tawtawo, bi-sa nilomolan ya ha baloto ta nako ha logar a anha-wayan Magadan. ");
INSERT INTO xsb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Main paw-Pariseo tan saw-Saduseo a nako koni Jesus para hobokon la ya. Kanya impaki-totol la kona a pa-kitan na hilan milagron ibat ha langit a pamilbian inhogo na yan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kot wanan in-obat ni Jesus konla, “Balang no homlop a awlo ta ma-kit moyon ti-tibyaan a langit, wamoyo, ‘Maganday panaon dilap.’ ");
INSERT INTO xsb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kot no ha boklah anamaot ta ma-kit moyon ti-tibyaan a langit tan maho-yom, wamoyo, ‘Mangabagat hawanin awlo.’ Hikamoy ma-magkonwari,* tanda moyon intindyon yay pawpamilbian ha langit, kot kay moyo tanda intindyon a yay gawgawa ko kot a-say namaot pamilbian. ");
INSERT INTO xsb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hikamoy tawtawo hawanin, masyadoy nan karokaan tan ambo kamon maptog ha Dios ta ampaningkapan moyo ko ot nin pamilbian. Kot homin anan laloman pamilbian a ipa-kit komoyo, no ambo yadtaw tanay kaparihon nangyari koni Propita Jonas hin yadtaw.” Pa-makahalita nadti ni Jesus ay imbati na hilay na. ");
INSERT INTO xsb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hawanin, hin nakalipay hilay na ni Jesus ha dobali nin alindayat, na-sikaso lan disipolos na a na-lingwanan lan nagbalon tinapay. ");
INSERT INTO xsb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hin ya-rin, main yan labay ibibilin hi Jesus konlan disipolos na a imparalan na ha alimbawa. Wana konla, “Mag-ingat kamo, tan pag-atapan moyoy pampalbag lan paw-Pariseo tan saw-Saduseo.” ");
INSERT INTO xsb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pinipapa-nowan lan disipolos na yadtaw imbalita na, wanla, “Kanya hinalita na-rin, bana ta kay tamo nakapagbalon tinapay.” ");
INSERT INTO xsb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kot hi Jesus, tanda nay ampipapa-nowan la, kanya wana konla, “Anongkot ampipapa-nowan moyo yay kay moyo pa-maka-wit nin tinapay? Hay kapoy katotpol moyo! ");
INSERT INTO xsb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kay moyo ot wari tanda a main kon kapangyarian? Na-lingwanan moyoy na wari hin pinapangan ko hilay limanlibon lalaki nin limay tinapay, tan no omnoy bakol ot a napno nin ni-katla? ");
INSERT INTO xsb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O kari yadtaw pitoy tinapay a kinan lan a-pat a libon lalaki, tan no omnoy namaot a bakol a natipon moyon ni-katla? ");
INSERT INTO xsb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Anongkot kay moyo angkaintindyan a ambo tongkol ha tinapay yay hinalita ko nangon? Yay wangko komoyo, pag-atapan moyoy pampalbag lan paw-Pariseo tan saw-Saduseo.” ");
INSERT INTO xsb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pa-makahalita nadti ni Jesus ay ba-ba-yo lan bongat naintindyan nin dawdisipolos na a yay labay nan pag-atapan la ay ambo yay pampalbag nin tinapay, nokay yay tawtotoro lan paw-Pariseo tan saw-Saduseo. ");
INSERT INTO xsb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hin niabot hilay na ni Jesus ha danin babalin Cesarea a hakop ni Felipe, pinastang na hilay disipolos na. Wana, “Hiko a Naglalaman Tawo, anyay wanlan tawtawo no hino ko?” ");
INSERT INTO xsb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","In-obat la kona, “Wanlan laloma, hika kano hi Juan Bautista. Main anamaot ampanalita a hika kano hi Propita Elias. Wanlay namaot laloma, hika kano hi Propita Jeremias, o a-sa konlan laloman pawpropita nan Dios hin o-na.” ");
INSERT INTO xsb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bi-sa wani Jesus konlan disipolos na, “Hapa hikamo, hino ko man komoyo?” ");
INSERT INTO xsb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Inombat hi Simon Pedro, wana, “Hika yay Cristo, yay Anak nan Dios a angkabyay.” ");
INSERT INTO xsb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bi-sa wani Jesus kona, “Makalma ka, Simon a anak ni Jonas, ta ambo tawo a namipatanda komo nin ya-rin nokay yay Ama ko ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ibalita ko ot komo, hika ay ‘Pedro’, yay labay totolon ‘bato’. Konan yadtin bato ay ipa-dong ko yay iglesia ko a homin laloma no ambo halban antompol kongko. Tan homin makatalo konan yadti maskin yay kamatyan. ");
INSERT INTO xsb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ibi ko komoy pa-hal sawsosi nin kaarian ha langit, ta anyakamay ibawal mo iti ha lota ay ibawal nay namaot nin Ama ko ha langit. Tan anorin anamaot kapara, anyakamay payagan mo iti ha lota ay payagan nay namaot nin Ama ko ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bi-sa impaka-bibilin na konlan disipolos na a ando la iba-balita ha hinoman a hiya hi Jesus, yay Cristo. ");
INSERT INTO xsb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Paibat hin ya-rin ay inompisawan nay nan impatandaan ni Jesus konlan disipolos na a dapat yan mako ha syodad Jerusalem, ta kailangan nan dalanan a lako a dawdya-dya ha gamot lan pawpoon nin Israelita, pawpoon pari tan mawmaistron kapanogoan tan ipapati la ya. Balo ta ha ikatlon awlo ay morong yan mabyay. ");
INSERT INTO xsb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bi-sa impa-lilih na yan domali ni Pedro ta hinaar na ya, wana, “Katawan, kay na aboloyan Dios orin! Kay dapat mangyari orin komo.” ");
INSERT INTO xsb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kot inarap na ya ni Jesus, wana kona, “Domayô ka kongko, ampango-nawan na ka ni Satanas! Ampaka-hadlang ka kongko ta yay an-isipon mo ay ambo kalabayan nin Dios, nokay kalabayan nin tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bi-sa wani Jesus konlan disipolos na, “Hinoman a malabay homonol kongko ay kailangan lingwanan nay sarili na tanggapon nay kawkadya-dyaan a andomalan ha biyay na alang-alang kongko a kaalimbawaan balatayon nay sarili nan kros, tan kailangan homonol ya kongko. ");
INSERT INTO xsb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nga-min, hinoman a ambo matibolos a nakom mati alang-alang kongko ay kay na matanggap yay biyay a homin anggawan. Kot hinoman a mati alang-alang kongko ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nga-min, anyay pakinabang nin a-say tawo, maipag-ikon na may halban kayamanan ha babon lota no impyirnoy nan lamang a ogotan na? Ma-bayaran na wari nin kayamanan a kalolwa na pigaw kay mi-ka ha impyirno? ");
INSERT INTO xsb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nga-min, ha lomato a panaon, hiko a Naglalaman Tawo ay makon oman iti kalamo ko hilay aw-anghil, tan ma-kit moyoy kalinggasan nan Ama a iti kongko. Bi-sa ibi koy tobalo a marapat ha balang a-sa ayon ha main nan gawgawa. ");
INSERT INTO xsb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yay potog, ibalita ko komoyo, main iti hawanin a angkabyay ot anggan ha ma-kit la kon makalato para mag-ari, hiko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pa-makalabah nin a-nom a awlo, impagkalamoan ni Jesus hi Pedro tan hilay mitalakakan Santiago tan Juan nin nako ha a-say mata-gay a bakil nin hila-hilan bongat. ");
INSERT INTO xsb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tongwa, na-kit lan hila-rin toloy kalamoan na a nangoman a itsora ni Jesus. Yay lopa na ay hinomawang nin bilang ha awlo, tan yay doloh na ay nag-in na-pakapoti anamaot nin bilang ha hawang. ");
INSERT INTO xsb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tongwa, na-kit lay nan bongat hi Moises tan hi Elias a ampaki-totol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Hawanin, wani Pedro koni Jesus, “Katawan, labah ta iti tamo. No labay mo, mama-dong kamin toloy hihilongan iti, a-sa para komo, a-sa para koni Moises, tan a-sa para koni Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hin ampanalita ya ot hi Pedro, tongwa naamoyan hilan a-say mahyang a lolom. Bi-sa nalngo lay bosis nan Dios a naibat konan ya-rin a lolom, wana, “Yadti a anlabyon kon Anak, tan angkalilikot akon labah kona. Manglongo kamo kona.” ");
INSERT INTO xsb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pa-makalngo lan disipolos na nin ya-rin a bosis ay nilomokob hila bana ha masyadon kali-mowan. ");
INSERT INTO xsb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kot dinomani hi Jesus konla ta inaptoh na hila. “Omdong kamo,” wana, “tan ando kamo mali-mo!” ");
INSERT INTO xsb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hin hinomilap hilan oman, homin hilay nan na-kit no ambo hi Jesus tana. ");
INSERT INTO xsb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lo-gan lan an-omaypa ni Jesus ha bakil, binibilinan na hilay toloy disipolos na. Wana, “Ando moyo yapon iba-balita ha hinoman yay na-kit moyo anggan ha hiko a Naglalaman Tawo ay paorongon anan mabyay.” ");
INSERT INTO xsb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bi-sa pinastang la yan hiladtin disipolos na, wanla, “Anongkot man no-nin an-ibalita lan mawmaistron kapanogoan a dapat lomato yapon oman hi Propita Elias, ba-yo kano makalato yay Cristo?” ");
INSERT INTO xsb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wanan in-obat ni Jesus konla, “Potog, nakasolat a mo-na yan lomato hi Propita Elias ta iparihado nay halban bagay. ");
INSERT INTO xsb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kot ibalita ko komoyo, yay antokoyon ison a Propita Elias ay nilomato ana. Balo ta kay la ya na-bilbi, nokay masbali ginwa la konay balang labay la. Anorin anamaot kapara kongko, padya-dyaon la koy namaot, hiko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hawanin, naintindyan lan disipolos na a yay antokoyon ni Jesus ay yadtaw hi Juan Bautista. ");
INSERT INTO xsb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pa-makalato la ni Jesus ha kamainan lan lako a tawo, main a-say lalakin dinomani koni Jesus. Nanalimokor ya, ta wana, ");
INSERT INTO xsb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Maistro, inga-rowan mo pay anak kon lalaki ta main yan masakit nin pa-ma-paghon. Masyado yan angka-pairapan ta mabotbot yan ampipalokma ha apoy o ha lanom. ");
INSERT INTO xsb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inawit ko ya konlan dawdisipolos mo kot kay la ya na-paabig.” ");
INSERT INTO xsb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wanan in-obat ni Jesus, “Hikamoy tawtawo hawanin, homin kamon katotpol tan masyadon matiko a pawpangingisip. Pa-no ot kari kaboyot a kailangan kon maki-lamo komoyo bi-sa kamo tompol? Pa-no ot kari kaboyot a kailangan katamon pagpasinsyawan? Awiton moyo-rin anak iti kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hin inawit lay nay anak ay pinanalitaan ni Jesus yay doka a ispirito a nilomoob konan anak, kanya inomalih ya. Antimano, inomabig yay anak. ");
INSERT INTO xsb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hin hila-hila tana ni Jesus, dinomani hilay disipolos na kona ta pinastang la ya. Wanla, “Anongkot kay mi ya na-palayah yadtaw doka a ispirito?” ");
INSERT INTO xsb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wana konla, “Bana ta kolang a katotpol moyo. Nga-min, yay potog, ibalita ko komoyo, maskin main kamo tanan katotpol a bilang bongat kakalog botol mostasa, ta alimbawa, halitaon moyo konan ya-rin a bakil, ‘Lomipat ka itaw!’ ay lomipat ya. ");
INSERT INTO xsb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kot yay anorin a klasin doka a ispirito ay kay ma-palayah no kay domawat ha Dios, nin main awit pa-magsakripisyon kay mangan.” ");
INSERT INTO xsb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hin hi Jesus tan hilay disipolos na ay ampagpirmi ha probinsyan Galilea, wanay naman konla, “Hiko a Naglalaman Tawo ay pagtraidoran para iintriga ha tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ipapati la ko, balo ta paorongon akon mabyay ha ikatlon awlo.” Pa-makalngo la nin yadti ay masyado hilan nilomolo. ");
INSERT INTO xsb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pa-makalato la ni Jesus ha babalin Capernaum, dinomani koni Pedro hilay ma-ni-non bowis para ha timplo, ta pinastang la ya. Wanla, “Ampamayar doman a Maistro moyo nin bowis para ha timplo?” ");
INSERT INTO xsb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Iya,” wanan in-obat ni Pedro. Bi-sa, hin nakalato yay na ha bali, ino-nawan na yan pinastang ni Jesus. Wana, “Anyay opinyon mo, Simon, hinoy dapat mamayar bawbowis konlan aw-ari, hila doman a awa-nak la o hilay laloman tawo?” ");
INSERT INTO xsb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Hilay laloman tawo,” wani Pedro. “No anodtaw no-nin,” wani Jesus, “libri hilay awa-nak la. Kanya dapat libri koy namaot komon ha pamamayar bowis para ha timplo nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Anodtaw pa man, pigaw homin hilan ma-halita, kailangan mamayar ta. Kanya mako ka ha alindayat mamanit. Bi-sa abriyan moy boboy nin o-nan konâ a makwa mo ta main kan ma-kit a-say kwartan pilak. Kowon mo ta ipamayar mon bowis para kontan lowa.” ");
INSERT INTO xsb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yadtaw ot a oras ay dinomani hilay disipolos ni Jesus kona ta pinastang la ya, wanla, “Hino kot a tawon pinakamata-gay ha ampag-arian nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nana-way hi Jesus nin a-say anak ta pinaodong na ha pibotlayan la. ");
INSERT INTO xsb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bi-sa wana, “Yay potog, ibalita ko komoyo, no kay kamo mama-yon kaisipan ta kay kamo mag-in bilang ha awa-nak a kay ampangisip nin magmata-gay, mika-ka-noman kay kamo maka-paki-lamo ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nga-min, yay tawon mapagmaaypa a bilang konan yadtin anak ay hiyay pinakamata-gay ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bi-sa, hinoman a ampananggap ha a-say tawo a bilang konan yadtin anak alang-alang kongko ay bilang hikoy antanggapon na.” ");
INSERT INTO xsb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wana ot ni Jesus, “Kot balo, hinoman a mag-in pangibatan nin makapagkasalanan a a-sa konlan antompol kongko a maaypa ha hilap nin tawo a bilang konlan hiladtin awa-nak, labah ot katinan a looy na nin baton an-ipangiling ta bi-sa idabo ya ha taaw. ");
INSERT INTO xsb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ka-ka-roy tawtawo iti ha babon lota bana ha bawbagay a ampangibatan nin makapagkasalanan hila. Natoral bongat a main ampangibatan nin makapagkasalanan a tawo, kot ka-pali-moy ogotan nin hinoman a ampangibatan nin makapagkasalanan a kapara na. ");
INSERT INTO xsb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Alimbawa, no yay gamot o ayi mo a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan po-tohon tan ibantak a gamot o ayi mo. Labah ot pa-hal po-toh a a-say gamot o ayi mo, basta mi-ka ka ha langit, dinan komplitoy gamot o ayi mo kot balo ibantak kay nan lamang ha impyirnon homin pa-nga-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No yay mata moy namaot a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan hokiton tan ibantak a mata mo. Labah ot pa-hal bolag a a-say mata mo, basta mi-ka ka ha langit, dinan komplitoy mata mo kot balo ibantak kay nan lamang ha apoy ha impyirno.” ");
INSERT INTO xsb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Wana ot ni Jesus, “Ingatan moyon ando mata-matawon a a-say maaypa ha hilap nin tawo a bilang konlan hiladtin awa-nak. Nga-min, oyay tandaan moyo: Hilay aw-anghil a ampagbantay konla ay pirmi hila ha arapan nan Ama ko ha langit, ");
INSERT INTO xsb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","tan hiko a Naglalaman Tawo ay nako iti ha babon lota para ilipyas a tawtawon nitalon ta dinomayô hila ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Anya kari ha wamoyo a gaw-on nin a-say tawo a main sanyatos a karniro no nitalon a a-sa? Kay na hila wari ibati yapon a siyam-a-polo tan siyam itaw ha ampagpastolan na, ta mako ya ha bakil ta tingkapon nay a-say nitalon? ");
INSERT INTO xsb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yay potog, ibalita ko komoyo, no na-kit na yay na, mas mahi-ban a lilikot na ta na-kit na ya, dinan ha lilikot na konlan siyam-a-polo tan siyam a kay nitalon. ");
INSERT INTO xsb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anorin anamaot kapara konan Ama moyo ha langit, kay na komon labay a maskin a-say maaypa ha hilap nin tawo a bilang konlan hiladtin awa-nak kot mi-ka ha impyirno.” ");
INSERT INTO xsb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Wana ot ni Jesus, “Alimbawa, no main a-say talakaka ha katotpol a nakapagkasalanan komo, kaon mo ya ta ibalita mo konay kalingowan na, kot dapat lowa kamon bongat ha pa-mi-totol moyo. No manglongo ya komo, ma-tambayan mo ya ta ma-piorong a pa-mi-talakaka moyo. ");
INSERT INTO xsb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kot no kay ya manglongo komo, mangawit kan a-sa o lowa a kapara moyon antompol, pigaw halban pi-totolan moyo ay ma-paptogan nin lowa o toloy tistigo. ");
INSERT INTO xsb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","No kay ya ot manglongo konla, ipatandaan moy na ha gropo moyon antompol pigaw hilay nay maki-totol kona. Kot no kay ya ot syimpri manglongo konla, itoring mo yay nan a-say kay antompol ha Dios o a-sa konlan mawmahaol a ma-ni-non bowis.” ");
INSERT INTO xsb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yay potog, ibalita ko komoyo, anyakamay ibawal moyo iti ha lota ay ibawal nay namaot nin Ama ko ha langit. Anorin anamaot kapara, anyakamay payagan moyo iti ha lota ay payagan nay namaot nin Ama ko ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ibalita ko ot komoyo, no main lowa komoyo iti ha babon lota a ma-piasa-sawan lay anyakaman a bagay a idawat la konan Ama ko ha langit ay gaw-on na-rin para konla. ");
INSERT INTO xsb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nga-min, aytimay main lowa o toloy ampititipon ha ngalan ko ay ison ako ha main lan pibotlayan.” ");
INSERT INTO xsb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bi-sa dinomani hi Pedro koni Jesus, ta wana, “Katawan, mi-noy bisis kon dapat patawaron a talakakan paolit-olit nin ampakapagkasalanan kongko? Anggan pitoy bisis wari?” ");
INSERT INTO xsb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Wanan in-obat ni Jesus kona, “No hiko, kay ko ibalita pitoy bisis, nokay pitompolo a pito. ");
INSERT INTO xsb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nga-min, yay pa-mag-ari nan Dios ay maialimbawa ha ginwa nin a-say ari a labay mani-non pawpaotang konlan aw-alila na. ");
INSERT INTO xsb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hin ompisawan nay pa-ni-no, yay primiron in-arap kona ay a-say alila a nakaotang kona nin libo-libo. ");
INSERT INTO xsb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kot hin kay ya makabayar, inmanda nan ari a ilako ya, pati kaambali na, awa-nak na tan halban kawkama-main na pigaw ma-bayaran a otang na. ");
INSERT INTO xsb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hawanin, nanalimokor yadtin alila konan ari, ta wana, ‘Sinyor ari, pagpasinsyawan mo ko pa yapon ta bayaran ko man a halban otang ko komo.’ ");
INSERT INTO xsb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nainga-rowan na yan ari, kanya pino-layan nay na yay otang na, bi-sa pinaorong na yay na. ");
INSERT INTO xsb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kot pa-makalikol na, na-hakbat nay kapara nan alila a nakaotang kona nin sanyatos bongat a alaga. Yay ginwa na ay antimano binitkol na ya, ta wana, ‘Bayaran moy otang mo kongko!’ ");
INSERT INTO xsb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kot yadtin kapara nan alila ay homin yay namaot maibayar. Kanya nanalimokor ya kona, ta wanan nagpasi-singa-ro, ‘Pagpasinsyawan mo ko pa yapon ta bayaran ko man a halban otang ko komo.’ ");
INSERT INTO xsb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kot kay ya pinomayag, nokay masbali impapriso na ya anggan ma-bayaran nay otang na. ");
INSERT INTO xsb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Hin na-kit lan kawkapara lan alila a nangyari, nilomolo hilan hosto, kanya inhombon lay halban nangyari konan ari. ");
INSERT INTO xsb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanya impa-ka nan ari odtaw alila nan homin inganga-ro. Bi-sa wana kona, ‘Hay karokaan mo pay nan tawo! Pino-layan koy nay naor a halban otang mo bana ta nagpasi-singa-ro ka. ");
INSERT INTO xsb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Dapat ininga-rowan moy namaot komon a kapara mon alila nin bilang ha pa-nginganga-ro ko komo, ambo doman?’ ");
INSERT INTO xsb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ha ka-motan olo nan ari, impapriso na yay namaot para padya-dyaon, anggan ha ma-bayaran nay halban otang na kona. ");
INSERT INTO xsb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Anorin anamaot kapara, parosawan nay namaot nin Ama ko ha langit yay hinoman komoyo a kay tanda magpatawad nin losob ha nakom ha kapara ha main lan kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pa-makayari nan tinotol ni Jesus odtin aw-alimbawa, inomalih ya ha probinsyan Galilea kalamo hilay disipolos na, ta nilomipay hila ha Kabatwan Jordan ta nako ha a-say logar a hakop ot probinsyan Judea. ");
INSERT INTO xsb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Golpin tawo a tinomombok kona, kanya halban lan mawmain masakit itaw ay pinaabig na. ");
INSERT INTO xsb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bi-sa main anamaot paw-Pariseo a nako kona para hobokon la no ma-ka-lot la ya ha pananalita. Kanya wanlan impastang kona, “Ayon ha kawkapanogoan nan Dios kontamo, maari doman ihiyay nin lalaki a kaambali na ha maskin anyay bara-nan?” ");
INSERT INTO xsb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wanan in-obat ni Jesus, “Kay moyo doman nabasa ha Masanton Kasolatan, hin pinalsa nan Dios a tawo hin kalin-oo-nawan ay ginwa na hilan lalaki tan babayi? ");
INSERT INTO xsb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tan wana ot Dios, ‘Yadti bara-nan no anongkot ibati nin lalaki a tatay tan nanay na ta tomapol ya konan kaambali na, bi-sa hilay lowa ay mag-in anan asa-sa.’ ");
INSERT INTO xsb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kanya, ambo hilay nan lowa nokay pa-hal asa-say na. Intonsis, yay piniasa-sa nan Dios ay kay dapat pihiyayon nin tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wanlay naman impastang nin hilay paw-Pariseo kona, “Anongkot man no-nin inmanda ni Moises a dapat biyan nin lalaki a kaambali na nin kasolatan nin pa-mihiyay, ba-yo na ya ihiyay?” ");
INSERT INTO xsb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wani Jesus konla, “Bana ha katiboyan olo moyon tawtawo ay pinayagan ni Moises nin ihiyay moyoy kaambali moyo, kot ambo anorin hin kalin-oo-nawan. ");
INSERT INTO xsb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kanya ibalita ko komoyo, hinoman a lalaki a mamihiyay nin kaambali, bi-sa magkaambalin laloma ay magkasalanan yan pa-mabayi, poyra no naki-lalaki yay babayi. Tan hinoman a lalaki a magkaambali konan yay babayin inhiyay ay magkasalanan anamaot nin pa-mabayi.” ");
INSERT INTO xsb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Hawanin, wanlan disipolos na kona, “No anorin paytaw a pa-hal nin lalakin main kaambali, mas labah no-nin a ando ana ingat magkaambali.” ");
INSERT INTO xsb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kot wani Jesus konla, “Ambo halban tawo ay makaagwantan kay magkaambali, nokay hiladtaw bongat a binyan nan kababaan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nangasasari a bara-nan no anongkot main kay ampagkaambali: Main kay ampakapagkaambali bana ta naiabing hilan main dipirinsya. Main anamaot odtaw bana ta kinapon hila. Hilay namaot a laloma ay disididon kay magkaambali ha apos lan isolong a pa-mag-ari nan Dios. No yay tawo kot magawa na-rin, iti-rin kona.” ");
INSERT INTO xsb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hawanin, main tawtawon nangawit nin awa-nak koni Jesus para iparna nay gamot na ha olo la ta idawat na hila ha Dios. Kot hinaar hila nin dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kot wani Jesus, “Po-layan moyo hilan domani kongkoy aw-awa-nak, ando moyo hila haaron. Nga-min, hilay tawtawon main pa-masimala ha Dios a bilang konla ay kabilang ha ampag-arian na.” ");
INSERT INTO xsb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bi-sa imparna nay gamot na ha olo nin balang a-sa konlan awa-nak ta binindisyonan na hila. Pa-makayari ay inomalih ana hi Jesus kalamo hilay disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hawanin, main a-say anakaba-yo a dinomani koni Jesus ta namastang, wana, “Labah a Maistro, anyay labah a gawa a kailangan kon gaw-on pigaw magkamain akon biyay a homin anggawan?” ");
INSERT INTO xsb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wanan in-obat ni Jesus, “Anongkot hina-wayan mo kon labah? Homin laloman labah no ambo yay Dios bongat. Kot no labay mon magkamain biyay a homin anggawan, honolon moy kawkasogoan nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wanan yadtin anakaba-yo, “Anya magkawkasogoan?” Wanan in-obat ni Jesus, “Ando ka mangmatin tawo; ando ka mamabayi; ando ka maniba; ando ka tomistigo nin kagalotoyan; ");
INSERT INTO xsb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","igalang moy tatay tan nanay mo; tan labyon moy kapara nin bilang ha pa-manglabi mo ha sarili.” ");
INSERT INTO xsb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wanan in-obat nin yadtin anakaba-yo, “Ya-rin halban ay anhonolon ko paibat hin anak ako. Anya man ot a kolang?” ");
INSERT INTO xsb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wani Jesus kona, “No labay mon mag-in pirpikto, morong ka. Ilako moy main mon kawkama-main, ta ipapto moy na-paglakoan konlan mawmairap pigaw magkamain kan kayamanan ha langit. Bi-sa magbolta ka ta homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hin nalngo nadti nin yay anakaba-yo, inomalih yan mairap a nakom bana ta kalakan nan kama-main. ");
INSERT INTO xsb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hawanin, wani Jesus konlan disipolos na, “Yay potog, ibalita ko komoyo, mairap para ha a-say mayaman a pahakop ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ibalita ko ot komoyo, maganoh ot ha a-say kamilyo nin homlot ha lobot karayom, dinan yay a-say mayaman a pahakop ha pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hin nalngo la-rin nin dawdisipolos na, nag-ispanta hilan masyado. Kanya wanla, “Hino man no-nin a maari malipyas?” ");
INSERT INTO xsb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Hinilap na hila ni Jesus, bi-sa wana konla, “Yadti ay kay magawa nin tawo, kot konan Dios, halban bagay ay magawa na.” ");
INSERT INTO xsb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bi-sa wani Pedro, “Hapa hikami? Imbati mi halban ta anhomonol kami na komo. Anya man yay ma-tanggap mi?” ");
INSERT INTO xsb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Wani Jesus konlan disipolos na, “Yay potog, ibalita ko komoyo, ha ba-yon mondo, no hiko a Naglalaman Tawo kot tomoklo ana ha trono ko nin angka-kit a sangkarangalan ko, hikamoy anhomonol kongko ay main kamoy namaot nin labinloway trono itaw a tokloan moyo, para manosga konlan labinloway lipi nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","A-sa ot, hinoman a mamibati nin main nan bawbali o tawtalakaka o tatay o nanay o kaambali o aw-awa-nak o lawlota alang-alang kongko ay makatanggap yan yatos-yatos a holok ha imbati na, tan magkamain ya ot biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kot lako konlan ampo-na hawanin a ha lomato a panaon kot ma-hoyot, tan lako anamaot a angka-hoyot hawanin a mio-na.” ");
INSERT INTO xsb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Wanan impagpatoloy ni Jesus, “Yay pa-mag-ari nan Dios ay maialimbawa ha ginwa nin a-say tawon main obasan. A-say awlo, nanakbay yan nakon naningkap maopaan nin magtrabaho ha obasan na. ");
INSERT INTO xsb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hin naka-kit yan maopaan, na-pi-sondoan la a yay opa kot a-say kwartan poron pilak ha a-say awlo. Bi-sa inhogo na hilay nan magtrabaho ha main nan obasan. ");
INSERT INTO xsb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hin manga alas nuwebe nin boklah, nako yay main ikon obasan ha plasa. Main yan na-lato tawtawo itaw a homin kagawa-gawa. ");
INSERT INTO xsb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wana konla, ‘Maari kamoy namaot mako magtrabaho ha obasan ko ta ibi koy marapat iopa komoyo.’ Kanya nako hila. ");
INSERT INTO xsb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bi-sa, hin nako yay naman hin bandan ogtiawlo tan hin bandan alas tres, anodtaw ot syimpri a ginwa na. ");
INSERT INTO xsb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hawanin, hin manga alas singkoy na, nilomikol yay naman. Naka-lato ya ot syimpri nin tawtawo itaw a nakaoodong. Kanya wana konla, ‘Anongkot ansayangon moyoy awlo moyo nin homin kagawa-gawa?’ ");
INSERT INTO xsb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wanlan in-obat kona, ‘Iya ta homin mangopa komi.’ Kanya wanan yadtin main ikon obasan, ‘Maari kamoy namaot mako magtrabaho ha obasan ko, bi-sa matanggap moyoy opa a marapat para komoyo.’ Kanya nako hilay namaot. ");
INSERT INTO xsb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hin anyomabi na, wanan main ikon obasan konan pina-tayaan na ha pa-matrabaho, ‘Ha-wayan mo hilay nay tawtrabahador ta ibi moy nay opa la. O-nawon mo hilan bayaran hilay hoyot nilomoob nagtrabaho anggan omabot konlan hilay no-na.’ ");
INSERT INTO xsb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hin dinomani hilay naor a hoyot nilomoob nagtrabaho nin alas singko ay binyan hilan hiyo-san kwartan poron pilak. ");
INSERT INTO xsb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hawanin, hin dinomani hilay namaot a o-nan nagtrabaho, hay wanla no mas lako a matanggap la, anta payti pari-pariho hila syimprin binyan hiyo-san kwartan poron pilak. ");
INSERT INTO xsb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hin anodtaw a tinanggap la ay nagriklamo hila konan main ikon obasan. ");
INSERT INTO xsb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wanla, ‘Hila-rin hawhoyot ay asa-say oras lan bongat nagtrabaho, anongkot anamaot impariho moy opa la komi, anta hikamidti ay nanagaawlon nagpagal tan nagawgaw?’ ");
INSERT INTO xsb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kot wanan yadtin main ikon obasan ha a-sa konla, ‘Amigo, ambo haol a anggaw-on ko komoyo. Ambo doman hika mismo ay pinomayag ha a-say kwartan pilak ha a-say awlo? ");
INSERT INTO xsb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kanya kowon mo-rin opa mo ta morong kay na. Kalabayan ko a ipariho koy opa lan hoyot komoyon hikamoy no-na. ");
INSERT INTO xsb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ambo doman karapatan kon gaw-on a balang labay ko ta sarili ko man kwarta? O, angkainggit ka wari ha ginwa kon kaabigan’?” ");
INSERT INTO xsb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hawanin, wanan impagpatoloy ni Jesus, “Anorin anamaot kapara, main konlan angka-hoyot hawanin a mio-na ha lomato a panaon, tan main anamaot ampo-na hawanin a ma-hoyot. Nga-min, lako a anhagyaton kot da-raoto a ma-pili.” ");
INSERT INTO xsb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hin iti hila ni Jesus ha dalan makon syodad Jerusalem, impa-lilih na hilay labinloway disipolos na konlan tawtawo, ta wana konla, ");
INSERT INTO xsb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tandaan moyodti: Yadtin pa-mako tamo ha Jerusalem, hiko a Naglalaman Tawo ay iintrigay na konlan pawpoon pari tan mawmaistron kapanogoan ta sintinsyawan la kon kamatyan. ");
INSERT INTO xsb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bi-sa iintriga la ko konlan ambo Israelita para toya-toyaon tan latigowon tan ipasak ha kros. Kot ha ikatlon awlo ay morong akon mabyay.” ");
INSERT INTO xsb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hawanin, nako yay kaambali ni Zebedeo koni Jesus, kalamo na hilay awa-nak nan hi Santiago tan hi Juan a parihon disipolos ni Jesus. Nanalimokor yan palokob koni Jesus ta main yan labay ipaki-totol kona. ");
INSERT INTO xsb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wani Jesus kona, “Anya kot a labay mo?” Wanan in-obat, “Komon ha pa-mag-ari mo, ibi mo konlan hiladtin loway anak ko a karapatan nin tomoklo ka-dani mo, yay a-sa ha wanan mo tan yay a-sa ha wili mo.” ");
INSERT INTO xsb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kot wani Jesus, “Kay moyo tanda a kanaboan nin ya-rin an-ipaki-totol moyo. Kababaan moyo wari magdya-dya nin bilang ha pa-magdya-dya ko?” “Iya, kababaan mi,” wanlan in-obat nin loway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kot wani Jesus konla, “Potog a magdya-dya kamo nin bilang kongko, balo ta ambo kon karapatan mamili no hinoy tomoklo ha wanan ko o ha wili ko, nokay yay totokloan ha dani ko ay para konlan pinaghandaan nan Ama ko ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hin nalngo lan mapolo ot a disipolos yay impaki-totol lan loway mitalakaka, nasora hila. ");
INSERT INTO xsb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanya pinadani na hila ni Jesus, ta wana konlan halban, “Tanda moyo a hilay ampamoon konlan ambo Israelita ay mabyat a pamomoon la, tan hilay mas mata-gay a katongkolan ay an-ipilit lay labay la. ");
INSERT INTO xsb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kot ambo kamon dapat mag-in anorin. Nokay hinoman a malabay mag-in mata-gay ha gropo moyo, kailangan disidido yan magsirbi ha kawkalamoan na. ");
INSERT INTO xsb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tan hinoman komoyo a malabay mag-in poon ha gropo moyo ay kailangan mag-in yan pa-hal alipon nin kawkalamoan na, ");
INSERT INTO xsb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","a bilang anamaot kongko a Naglalaman Tawo, kay ko nako iti ha babon lota para pasirbi, nokay para magsirbi tan para ibi koy biyay ko nin ipanondon ha lako a tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hin an-omalih hilay na ni Jesus ha babalin Jerico, lako a tawtawon inomaloyon kona. ");
INSERT INTO xsb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hin ya-rin ay main loway lalakin bolag a antoklo ha liglig kalsada. Hin nalngo lan anlomabah ya hi Jesus ay hinoma-way hila, wanla, “Katawan, lipi ni Ari David, inga-rowan mo kami pa!” ");
INSERT INTO xsb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kot hilay tawtawo itaw ay hinaar na hila pigaw mamakatinok hila. Kot lalo hilay na ingat hinoma-way, wanla, “Katawan, lipi ni Ari David, inga-rowan mo kami pa!” ");
INSERT INTO xsb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tinomgon hi Jesus ta hina-wayan na hila. Bi-sa wana konla, “Anyay labay moyon gaw-on ko para komoyo?” ");
INSERT INTO xsb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wanla kona, “Katawan, labay mi komon maka-kit.” ");
INSERT INTO xsb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nadabo a inganga-ro ni Jesus konla, kanya inaptoh nay mata la. Antimano naka-kit hilay naor, bi-sa inomaloyon hilay namaot kona. ");
INSERT INTO xsb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Madani hilay na ni Jesus ha syodad Jerusalem ta niabot hilay na ha baryon Betfage ha liglig nin Bakil Olibo. Hawanin, inhogo nay lowa konlan disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wana konla, “Domiritso kamo konan ya-rin ka-tobon a baryo ta main kamon ma-kit itaw a a-say asno a nakatakol a kalamo nay kilaw na. Orkalan moyo ta awiton hila iti kongko. ");
INSERT INTO xsb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No wari ta main manita, ibalita moyo, ‘Kailangan nan Katawan,’ wamoyo ta pomayag ya man tampol.” ");
INSERT INTO xsb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Konan ya-rin halban nangyari ay na-paptogan yay hinalita nin a-say propita nan Dios hin yadtaw, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ibalita moyo konlan tawtawo ha Sion labay totolon ha Jerusalem: ‘Bilyon moyo! Ampakalato yay nay Ari moyo. Mapagmaaypa ya, kilaw asnon bongat a anggamiton nan pagkabayowan.’” ");
INSERT INTO xsb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bi-sa nako hilay nay loway disipolos ni Jesus ta ginwa lay ayon ha pinanogoan konla. ");
INSERT INTO xsb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inawit la yay asno tan yay kilaw na koni Jesus. Ba-yo insapin lay aw-alimonmon la konan kilaw, ta bi-sa pinagkabayowan nay na ni Jesus ha pa-makon Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Karamilan konlan hilay malabong a tawo ay in-apin lay aw-alimonmon la ha dalanan na, tan hilay lalomay namaot ay namo-toh nin hawhangan kayo ta bi-sa la in-apin ha dalanan na, pa-mipa-kit nin kaga-galang la koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hilay tawtawon anlalako ha o-nawan na tan hilay namaot a an-omaloyon kona ay ampiho-holyak ha kaligawan. Wanla, “Viva konan yay lipi ni Ari David! Poriwon yay ampakalato ha ngalan nan Katawan! Dayawon yay Katawan ha sangkalangitan!” ");
INSERT INTO xsb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pa-makalato ni Jesus ha Jerusalem, halban lan tawtawo ha syodad ay ni-paka-ngap. Wanla, “Hino ya kari orin?” ");
INSERT INTO xsb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wanlan in-obat nin hilay malabong a tawo a an-aloyon koni Jesus, “Hiya hi Jesus a propita nan Dios a taga Nazaret, probinsyan Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hawanin, nako hi Jesus ha timplo nan Dios kalamo hilay disipolos na. Pina-paalih nay halban ampi-paglako tan ampi-panaliw itaw nin maida-ton konan Dios. Bi-sa binalinta nay lawlamisawan lan ma-nagilin kwarta itaw, pati tawtotokloan lan ma-maglako nin kawkalapatin idada-ton anamaot. ");
INSERT INTO xsb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wana konla, “Nakasolat ha Masanton Kasolatan a wanan Dios, ‘Yay bali ko ay ha-wayan balin panawatan.’ Halako ta anggaw-on moyon ‘pamaliwan nin mawmahiba.’” ");
INSERT INTO xsb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bi-sa main bawbolag tan pawpilay a dinomani kona itaw ha timplo, kanya pinaabig na hila. ");
INSERT INTO xsb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Balo ta inomamot a olo lan hilay pawpoon pari tan mawmaistron kapanogoan, hin na-kit lay gi-ginwa ni Jesus a kawka-paka-ngap, tan hin nalngo la ot a an-iho-holyak lan awa-nak ha loob nin timplo, a wanla, “Viva konan yay lipi ni Ari David!” ");
INSERT INTO xsb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kanya wanla koni Jesus, “Angkalngo mo doman a an-iho-holyak lan hiladtin awa-nak?” Kot wanan in-obat ni Jesus konla, “Angkalngo ko. Kay moyo ot doman nabasa yadtin wana ha Masanton Kasolatan tongkol ha gawa nan Dios: ‘Tinoroan mo hilay awa-nak, pati hilay ansomoso ot, kanya ampanayaw hilan hosto?’” ");
INSERT INTO xsb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bi-sa imbati na hila ni Jesus. Nilomikol ya ha syodad Jerusalem nin kalamo hilay disipolos na, ta nako hila ha baryon Betania. Itaw hila namalabah nin yabi. ");
INSERT INTO xsb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kinaboklahan, pa-magbolta la ni Jesus ha syodad Jerusalem ay nalayam nay bitil na. ");
INSERT INTO xsb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hin na-kit nay a-say poon igos ha danin dalan a lako anay bolong, kina na. Kot homin yan na-kit bonga nokay bawbolong bongat. Kanya inhompa na-rin poon igos, wana, “Kay kay na mamongan oman mika-ka-noman!” Antimano, nalanoh yay poon igos. ");
INSERT INTO xsb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hin na-kit lan dawdisipolos nay nangyari, naka-ngap hila. Wanla, “Pa-no nangyarin nalanoh tampol ya-rin poon igos?” ");
INSERT INTO xsb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Wani Jesus konla, “Yay potog, ibalita ko komoyo, no main kamon katotpol a homin awit pa-magdoda, makagawa kamoy namaot nin bilang ha ginwa ko konan ya-rin poon igos. Tan ambo bongat anorin, nokay maskin alimbawa halitaon moyo konan ya-rin a bakil, ‘Maalih ka-son ta lomipat ka ha ambay!’ ay mangyari orin. ");
INSERT INTO xsb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nga-min, anyakaman a bagay a dawaton moyo ha Dios ay matanggap moyo no tompol kamo.” ");
INSERT INTO xsb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pa-makalato la ha Jerusalem, nako hila ha timplo. Lo-gan yan ampanoro hi Jesus itaw, nako kona hilay pawpoon pari tan hilay pawpoon nin Israelita, ta wanla, “Anyay karapatan mo anongkot angga-gaw-on mo-rin halban? Hino kot a nami nin karapatan komo?” ");
INSERT INTO xsb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Wanan in-obat ni Jesus konla, “Main akoy namaot labay pastangon komoyo. No obaton moyo ko, ibalita koy namaot komoyo no hinoy nami nin karapatan kongko para gomwa anodtin bawbagay. ");
INSERT INTO xsb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oyay pastang ko: Ayti naibat a karapatan ni Juan para mamaotismo, ha Dios doman o ha tawo?” Nipapa-no hila yapon ha a-sa tan a-sa, wanla, “No halitaon tamon ibat ha Dios, sigoradon halitaon na kontamo, ‘Anongkot man no-nin ta kay moyo ya pini-pol?’ ");
INSERT INTO xsb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kot no halitaon tamoy namaot a naibat ha tawo, angkali-mo tamo ha tawtawo, bana ta ambilbion nin halban a yadtaw hi Juan ay propita nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanya, yay in-obat la tana ay “Kay mi tanda.” Kanya wani Jesus konla, “Kay koy namaot no-nin ibalita komoyo no hinoy nami nin karapatan kongko para gomwa anodtin bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bi-sa nanotol ot hi Jesus konla nin a-say alimbawa, wana, “Anyay opinyon moyo konan yadti: Main a-say tatay a main loway anak a lalaki. A-say awlo, dinaniwan na yay kaka, ta wana, ‘Anak ko, mako ka magtrabaho hawanin awlo ha obasan tamo.’ ");
INSERT INTO xsb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wanan in-obat nin yadtin kaka, ‘Kay ko labay.’ Kot na-paongganan ay nangoman a isip na, kanya nako ya syimpri. ");
INSERT INTO xsb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nako yay namaot a tatay konan ali ta anodtaw anamaot a imbalita na kona. Wanan yadtin ali, ‘Iya, Tatay, mako ko.’ Kot kay ya nako. ");
INSERT INTO xsb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hawanin, hino man konlan lowa a hinomonol ha kalabayan nin tatay la?” Wanlan in-obat, “Yay kaka.” Wani Jesus konla, “Yay potog, ibalita ko komoyo, anorin anamaot a ampangyari hawanin ta hilay ma-ni-non bowis a mangahaol tan hilay dawdoka a babayi ay ampi-pangoman a isip la a bilang konan yay in-alimbawa kon kaka. Kanya ampo-na hilay na ingat komoyo nin mailamo ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nga-min, nako ya komoyo hi Juan Bautista ta impangaral na yay kalabayan nan Dios a dapat moyon honolon, kot kay moyo ya pini-pol. Balo ta hilay ma-ni-non bowis a mangahaol tan dawdoka a babayi ay hilay na ingat a ni-pol kona. Kot hikamo, maskin na-kit moyon ni-pol hilay na, kay kamo ot syimpri nangombabali ta mi-pol ana komon kona.” ");
INSERT INTO xsb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Bi-sa impagpatoloy ni Jesus a pa-noro na konla, wana, “Long-on moyodtin a-say naman a alimbawa: Main a-say lalaki a nangmolan golpin obas ha main nan lota. Bi-sa na inalalan a nanglibol. Ba-yo ginomwa yan pamohpohan obas tan nama-dong ot nin mata-gay a balin pagbantayan. Pa-makayari, nangwa yan tawtawon mangasiwa konan yadtin obasan na, bi-sa nako ya ni-wan ha laloman logar. ");
INSERT INTO xsb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hin panaon anan pa-motin obas, namihogo yan aw-alila na konlan ma-ngasiwa nin obasan na para kowon lay parti na. ");
INSERT INTO xsb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kot pa-makalato la, binombonan hila nin mawma-ngasiwa ta bino-bogbog lay a-sa, pinati lay a-sa, tan bina-batibat lan bato a a-sa anggan nati namaot. ");
INSERT INTO xsb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bana ta anodtaw, nanogo yay naman yadtin main ikon obasan nin laloman aw-alila a mas lako dinan konlan o-nan inhogo na. Kot anodtaw ot syimpri a ginwa la konla nin hilay mawma-ngasiwa. ");
INSERT INTO xsb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hin hoyot, mismon yay anak nan lalaki a inhogo na konla, ta wana ha sarili na, ‘Sigoradon igalang lay anak ko.’ ");
INSERT INTO xsb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kot hin na-kit lan mawma-ngasiwa yadtin anak na, wanla ha a-sa tan a-sa, ‘Ya-rin yay manawil. Patyon tamo ya pigaw maipag-ikon tamoy tatawilon na.’ ");
INSERT INTO xsb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kanya yay ginwa la ay binombonan la ya, bi-sa inlikol ha obasan ta pinati. ");
INSERT INTO xsb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Hawanin,” wanan impagpatoloy ni Jesus, “no makalato yay nay main ikon obasan, anya man wari a gaw-on na konlan hila-rin mawma-ngasiwa?” ");
INSERT INTO xsb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wanlan in-obat kona, “Sigoradon patyon na hilan homin inganga-ro hila-rin dawdoka a tawo. Bi-sa ipa-taya nay na a obasan na ha laloman mawma-ngasiwa a maronong mamin parti ha panaon nin pa-moti.” ");
INSERT INTO xsb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Wana ot ni Jesus konla, “Ambo doman nabasa moyodtin wana ha Masanton Kasolatan: ‘Yay bato a impoyra lan karpintiro ay yadtaw mismo a ginwa pinakapondasyon nin bali. Yadti ay gawa nan Katawan tan ka-paka-ngap kontamo.’” ");
INSERT INTO xsb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bi-sa wana ot ni Jesus, “Ibalita ko komoyo, ambo anan hikamoy pag-arian nan Dios, nokay hilay nay ambo Israelita a pa-hal ampami kona nin lawlabah a bonga. ");
INSERT INTO xsb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hikodtaw pa-hal bato a impoyra moyo. Hinoman a madabo konan yadtin pa-hal bato ay mangababalian, tan hinoman a ma-bondagan nan yadti ay madonot.” ");
INSERT INTO xsb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hin nalngo lan pawpoon pari tan paw-Pariseo a aw-alimbawa ni Jesus ay naintindyan la a hilay antokoyon na. ");
INSERT INTO xsb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dakpon la yay na komon, kot angkali-mo hila konlan malabong a tawo bana ta an-itoring la hi Jesus nin a-say propita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bi-sa nanotol yay naman hi Jesus nin a-say alimbawa. ");
INSERT INTO xsb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Wana, “Yay pa-mag-ari nan Dios ay maialig ha a-say ari a naghanda nin mahi-ban a handaan para ha kahal nin anak nan lalaki. ");
INSERT INTO xsb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ba-yo impa-ka na konlan aw-alila na hilay inimbitawan ha kahal, kot kay la labay maki-ka. ");
INSERT INTO xsb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nanogo yay naman yadtin ari nin laloman aw-alila na. Wana konla, ‘Ibalita moyo konlan inimbitawan a naihanda anay halban pa-mangan ta naloto anay karni nin impapati kon bawbaka, pati yay pinataba kon kawkilaw. Hawanin, nakahanda anay halban, kanya mako hilay na iti ha kahal.’ ");
INSERT INTO xsb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kot kay la binyan alaga yay pa-ngombida konla ta nagpatoloy hila ha main lan kakaon. Main nako nin nagtrabaho ha bowat, main nako nagtinda. ");
INSERT INTO xsb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hilay namaot a laloma ay binombonan lay aw-alila na, bi-sa impa-paringoy tan toloy la ot pinati. ");
INSERT INTO xsb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hin na-tandaan nan ari odti, inomamot a olo na. Kanya inhogo nay hawhondalo na, ta impapati na hilay ni-pangmati konlan aw-alila na tan impapoolan nay syodad la. ");
INSERT INTO xsb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bi-sa wanan ari ha laloman aw-alila na, ‘Nakahanda anay pawpa-mangan para ha kahal, kot hilay inimbitawan ay ambo hilan karapat-dapat. ");
INSERT INTO xsb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kanya mako kamo ha kawkalsada a matawo ta halban ma-kit moyo ay imbitawan moyo ha kahal.’ ");
INSERT INTO xsb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kanya nako hilay nay naor a aw-alila ha kawkalsada ta inimbita lay halban tawtawon na-romogan la, ki labah ki doka. Kanya napno nin bawbisita yay logar a pagkahalan. ");
INSERT INTO xsb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Hin nilomoob yay ari para biliwon nay bawbisita, na-kit nay a-say lalaki a kay nakahili nin doloh pangkahal. ");
INSERT INTO xsb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kanya wana kona, ‘Amigo, anongkot basta ka tanan nilomoob iti nin kay yapon naghili nin doloh pangkahal?’ Kay ya naka-bat odtin lalaki. ");
INSERT INTO xsb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanya wanan ari konlan aw-alila na, ‘Balolon moyoy gamot tan ayi na ta bi-sa awiton moyo ya ta ibantak itaw ha logar a sangkarobloman. Mi-tangih-tangih tan mi-pigogot a tawtawo itaw ha grabin kadya-dyaan.’” ");
INSERT INTO xsb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Wanan impagpatoloy ni Jesus, “Anorin ot bongat ha pa-mag-ari nan Dios, lako hilay anhagyaton, kot da-raoto a ma-pili.” ");
INSERT INTO xsb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hawanin, inomalih hilay paw-Pariseo ta pinipapa-nowan la no pa-no la ya ma-taktika hi Jesus, pigaw makahalita yan maari lan maikaso kona. ");
INSERT INTO xsb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kanya yay ginwa la ay inhogo lay tawtawon antoroan la a impalalamoan ha omnoy tawon maka-Ari Herodes Antipas ta pinastang hi Jesus. Wanla, “Maistro, tanda mi a maptog ka tan potog yay an-itoro mon kalabayan nan Dios para ha tawo. Kay ka ampag-alangan ha hinoman ta kay mo anhilapon a katongkolan nin tawo. ");
INSERT INTO xsb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ibalita mo pa no-nin komi no anyay opinyon mo iti: Marapat doman ayon ha kawkapanogoan nan Dios kontamon Israelita a mamayar nin bowis konan ari ha Roma a main hakop kontamo?” ");
INSERT INTO xsb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kot tanda ni Jesus a doka a sadya la, kanya wana konla, “Hikamoy mawma-magkonwari, anongkot labay moyo kon hobokon? ");
INSERT INTO xsb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipa-kit moyo kongkoy kwartan ibabayar ha bowis.” Kanya intorol la konay a-say kwartan pilak. ");
INSERT INTO xsb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bi-sa pinastang na hila ni Jesus, wana, “Hino man lopa tan ngalan yadti iti?” ");
INSERT INTO xsb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Yay ari ha Roma,” wanla. Bi-sa wani Jesus konla, “Intonsis, ibi moyo no-nin konan ari ha Roma yay ikon na, tan anorin anamaot kapara, ibi moyoy namaot konan Dios yay ikon na.” ");
INSERT INTO xsb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hin nalngo ladti ay naka-ngap hila ta yay obat na ay ambo kontra konan ari tan ambo anamaot kontra konan Dios. Kanya imbati la yay na. ");
INSERT INTO xsb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ya-rin ot a awlo, main anamaot saw-Saduseo a nako koni Jesus. Hiladti yay gropon kay ampi-pol a main pa-morong mabyay. Pinastang la yay namaot hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wanla, “Maistro, yay wani Moises ay ‘No nati yay a-say lalaki nin homin anak, kailangan ipagkaambali nin talakaka na yay nabalo, ta pigaw maibalô nan magkamain anak yay nati.’ ");
INSERT INTO xsb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hin yadtaw, main iti komin pitoy mita-talakakan lawlalaki. Nagkaambali yay kalingkakaan, kot nati yan kay hila nagkaanak. Kanya na-bati nay balo konan homonol a talakaka na para ipagkaambali. ");
INSERT INTO xsb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kot yay nangyari konan yadtin pangalwa ay parihas ot bongat ha kalingkakaan, tan anorin syimpri nangyari ha pangatlo anggan ha pampito. ");
INSERT INTO xsb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hin hoyot, yay babayi namaot a nati. ");
INSERT INTO xsb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hawanin, no wari ta main pa-morong mabyay, hino man no-nin konlan pitoy mita-talakaka a makapag-ikon konan yadtaw babayi bilang kaambali na painsan? Ta halban la ay naipagkaambali la ya.” ");
INSERT INTO xsb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kot wanan in-obat ni Jesus konla, “Lawlingo kamo bana ta kay moyo an-intindyon yay Masanton Kasolatan, ni yay kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ha pa-morong mabyay ay kay hilay na mi-pagkaambali ta bilang hilay nan aw-anghil nan Dios ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kot tongkol ha pa-morong mabyay nin hilay ni-kati, main kamo syimprin nabasa a hinalita nan Dios para komoyo, wana, ");
INSERT INTO xsb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Hikoy Dios ni Abraham, Dios ni Isaac, tan Dios ni Jacob.’ Kot ambo yan Dios nin tawtawon nati, nokay Dios ya nin tawtawon angkabyay, labay totolon, an-itoring nan angkabyay hiladtin tolo.” ");
INSERT INTO xsb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hin nalngo ladti nin tawtawo, naka-ngap hilan hosto ha tawtotoro na. ");
INSERT INTO xsb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hin na-tandaan lan paw-Pariseo a hilay saw-Saduseo kot naninok bana ha in-obat ni Jesus, nititipon hilay naman itaw koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hawanin, main a-sa konla a ikspirto ha kapanogoan a namastang koni Jesus para hobokon na ya. ");
INSERT INTO xsb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wana, “Maistro, anya kot yay pinakamaalagan kasogoan nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Wanan in-obat ni Jesus, “Labyon mo yay Katawan mon Dios nin asa-say nakom, nin mo-na ha main mon kalayaman, tan mo-na ot ha main mon pangingisip. ");
INSERT INTO xsb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yadti a o-na tan pinakamaalagan kasogoan. ");
INSERT INTO xsb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kot a-sa ot a kapariho nan maalaga ay yay ‘Labyon moy kapara nin bilang ha pa-manglabi mo ha sarili.’ ");
INSERT INTO xsb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Konlan hiladtin loway kasogoan ay hakop anay halban kawkapanogoan nan Dios tan yay tawtotoro lan pawpropita na ha Masanton Kasolatan.” ");
INSERT INTO xsb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hin ya-rin a tipon hila ot a paw-Pariseo, pinastang na hilay namaot ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Wana, “Anyay tanda moyo tongkol konan yay Cristo? Hinon lipi a ibatan na?” Wanlan in-obat, “Lipi ni Ari David.” ");
INSERT INTO xsb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wani Jesus konla, “Hawanin ta lipi na ya, pa-no man no-nin a hina-wayan ni Ari David yay Cristo nin ‘Katawan’ ayon ha impanakom nin Ispirito nan Dios kona, ta oyay wani Ari David a nakasolat: ");
INSERT INTO xsb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wanan Dios a Katawan koni Cristo a Katawan ko: Iti ka tomoklo ha wanan ko Ta ta-ganan mon igwa ko ha aypa kapangyarian mo hilay kawkontra komo.’” ");
INSERT INTO xsb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bi-sa wana ot ni Jesus konla, “Iti ay hina-wayan ni Ari David yay Cristo nin ‘Katawan’. Anyay wamoyo: Pa-no maari a Katawan na ya ta bi-sa lipi na ya ot?” ");
INSERT INTO xsb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Homin ni a-sa a naka-bat ha pastang na. Kanya paibat hin ya-rin ay homin anan nagkohaw nakom nin namastang ot kona. ");
INSERT INTO xsb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pa-makayari, wani Jesus konlan malabong a tawo tan konlan disipolos na, ");
INSERT INTO xsb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hilay mawmaistron kapanogoan tan paw-Pariseo ay hilay binyan nin katongkolan para mamipalino nin kawkapanogoan a inimbi nan Dios koni Moises. ");
INSERT INTO xsb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kanya gaw-on moyoy an-itoro la tan honolon yay an-ipanogo la. Kot ando moyo aligon a gawgawa la, bana ta kay la anhonolon a an-itoro la. ");
INSERT INTO xsb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lako a kawkapanogoan a an-ipahonol la ha tawtawo a bilang ampabalatayon la hilan mangabyat a kawkarga a halos kay la mabalatay, anta ni a-say galawagaw la ay kay la tana anggamiton para ipanambay konlan antoroan la pigaw makahonol hila komon. ");
INSERT INTO xsb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Halban gawgawa la ay anggaw-on lan bongat para ipa-kit ha tawo a bilang anodti: An-ipa-parada lay kawkapanogoan nan Dios a inigwa ha makalog a pamigwaan a an-itakol ha walong tan braso la. Ampa-paanlohon lay pawpalamoy ha aw-ayhing la, pamilbian a rawrilihyoso hila. ");
INSERT INTO xsb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bi-sa mangailig hilan tomoklo ha kawkabisira no main hawhandaan tan ha ambo basta-bastan totokloan ha sawsinagoga. ");
INSERT INTO xsb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Labay-labay la ot nin asikasowon hila ha pawplasa tan ma-ha-wayan hila nin ‘Maistro’. ");
INSERT INTO xsb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kot hikamo, ando kamo paha-way ‘Maistro’ bilang mangangaral Halita nan Dios, bana ta asa-sa bongat a Maistro moyo a homin laloma no ambo hiko hi Cristo, tan halban moyo ay pa-hal mita-talakaka. ");
INSERT INTO xsb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tan ando moyo ha-wayan nin ‘Ama’ yay hinoman iti ha lota a ampanoro tongkol ha Dios, bana ta asa-san bongat a Ama moyo a homin laloma no ambo yay Ama ha langit. ");
INSERT INTO xsb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Anorin anamaot kapara, hinoman komoyo a mango-na ha gropo moyo ay ando paha-way ‘Poon’, bana ta asa-sa bongat a Poon moyo a homin laloma no ambo hiko hi Cristo. ");
INSERT INTO xsb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hinoman komoyo a an-ibilang nin pinakamata-gay ha gropo moyo ay dapat nin ibilang nay sarili nan ma-magsirbi yan halban. ");
INSERT INTO xsb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nga-min, yay tawon ampagmata-gay ay iaypa nan Dios kot yay tawon ampagmaaypa ay ita-gay na.” ");
INSERT INTO xsb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Wana ot ni Jesus, “Hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig, ka-ka-roy ogotan moyo! Nga-min, ampakaharang kamo ha pa-mag-ari nan Dios ha tawtawo, ta hikamo mismo ay kay ampahakop ha pa-mag-ari na ta bi-sa hilay malabay pahakop ay kay moyo ampayagan. ");
INSERT INTO xsb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Talagan ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Nga-min, antaktikawon moyoy bawbabayin balo anggan makwa moyo pati na ingat a bali la, ta bi-sa ampa-paanlohon moyoy kada-dawat moyo pigaw kay ma-halata a gawgawa moyon doka. Bana konan ya-rin a angga-gaw-on moyo, mas ambomyat ana ingat a parosa komoyo.* ");
INSERT INTO xsb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Ampagbyahi kamon madayo tan maskin layat anlipayon moyo ha pa-mako konlan ambo Israelita, ta pigaw makaayat kamon maskin a-sa bongat a tawo ha katotpol tamon Israelita. Bi-sa, no main kamoy nan naayat, ha pa-ngalig la komoyo ay ampag-in hilay na ingat doblin karoka komoyo a pangibatan mi-ka hila ha impyirno. ");
INSERT INTO xsb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ka-ka-roy ogotan moyo, hikamo a bilang bawbolag a ma-ngakay! Nga-min oyay a-say lingon an-itoro moyo, ta wamoyo, Hinoman a maghompa ha an-ipangako na ta yay halitaon na ay ‘Tistigo koy timplo,’ maari maskin kay nay na tooron kot no maghompa ya ta yay halitaon na ay ‘Tistigo koy balitok ha timplo,’ kailangan tooron na. ");
INSERT INTO xsb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bilang kamon homin aw-isip tan bawbolag! Anyay mas maalaga, yay balitok wari ha timplo o yay mismon timplo a ampamasagrado konan ya-rin a balitok? ");
INSERT INTO xsb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ba-yo an-itoro moyo ot, no hinoman a maghompa ta yay halitaon na ay ‘Tistigo koy altar,’ maari maskin kay nay na tooron. Kot no maghompa ya ta yay halitaon na ay ‘Tistigo koy dawda-ton ha altar,’ kailangan tooron na. ");
INSERT INTO xsb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bilang kamon homin aw-isip tan bawbolag! Anyay mas maalaga, yay dawda-ton wari ha altar o yay mismon altar a ampamasagrado konan ya-rin a dawda-ton? ");
INSERT INTO xsb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kanya no maghompa kamo ta yay altar a hambiton moyo, bilang ot bongat pati nay halban bawbagay a nakaigwa konan ya-rin a altar a hinambit moyo. ");
INSERT INTO xsb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Anorin anamaot kapara, no maghompa kamo ta timplo a hambiton moyo, bilang ot bongat pati nay Dios a hinambit moyo, bana ta ya-rin a timplo ay impagka-bali na. ");
INSERT INTO xsb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","No yay hinalita moyoy namaot ha pa-maghompa moyo ay ‘Tistigo koy langit,’ bilang ot bongat pati nay Dios a hinambit moyo, bana ta yay langit ay pa-hal trono na. ");
INSERT INTO xsb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Ampami kamo konan Dios nin ikamapolo a parti nin angkaalawah moyo, maskin ha pinakamakating a kawklasin bongan pangrikado. Kot ampo-po-layan moyo yay mas mawmaalagan an-ipagawa ha kawkapanogoan nan Dios a bilang ha gawgawa katoynongan tan pa-nginganga-ro ha kapara tan yay pa-mag-in maptog. Hiladti a dapat moyon asikasowon nin ando anamaot lingwanan a lawlaloma. ");
INSERT INTO xsb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bilang kamon bawbolag a ma-ngakay! Hay kotino moyo ha mawmakalog a bagay a bilang ansalaon moyoy an-inomon moyo pigaw kay kamo makaitlon nin kiti-kiti. Balo ta ha pa-ma-paolay moyo konlan hila-rin mawmaalagan bagay ay bilang kamoy na ingat ampamitlon kamilyo. ");
INSERT INTO xsb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Ha kaaapos moyon ma-honol a sirimonyan pa-manglinis, ampaka-linison moyon mo-na mo-na a likol nin tawtasa tan pawplato moyo. Anta yay an-ipalaman moyo ay panay hinaol-haol tan gina-gamgam. ");
INSERT INTO xsb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bilang kamon bawbolag, hikamoy paw-Pariseo! Kailangan alihon moyo yapon ha tawtasa tan pawplato moyo ya-rin a an-ipalaman moyon pa-hal yawyangat, pigaw anggan likol ay mag-in malinis anamaot. ");
INSERT INTO xsb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Bilang kamon pawpantyon a pinintorawan nin mapoti a hay gandan biliw-biliwon, anta yay lalo nin ya-rin ay bawbotol nin natin tawtawo tan panay dawdolmong. ");
INSERT INTO xsb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Anorin moyo ta ha hilap nin tawtawo ay mahonol kamo ha Dios, anta ha lalo nakom moyo kot panay pa-magkonwari tan kawkarokaan.” ");
INSERT INTO xsb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Impangwâ moyon pawpantyon hilay pawpropita nan Dios a pinati lan kapapo-papoan moyo, tan andi-dikorasyonan moyo ot a pawpinanabonan lan laloma ot a tawtawon maptog hin o-nan panaon. ");
INSERT INTO xsb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bi-sa wamoyo, ‘No komon ta biyay mi na hin panaon lan kapapo-papoan tamo, kay kami nakiasa-sa konla ha pa-mangmati konlan pawpropita nan Dios.’ ");
INSERT INTO xsb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ha pananalita moyon anorin ay ampaptogon moyo a hikamo kot aw-apopo lan hilay nangmati konlan pawpropita nan Dios hin yadtaw. ");
INSERT INTO xsb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hala, isigi moyoy na ingat no-nin a kagogwa nin doka a inompisawan lan hilay kapapo-papoan moyo! ");
INSERT INTO xsb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bilang kamon olay a madita! Hay wamoyo wari a ma-pa-lilihan moyoy parosa nan Dios a i-ka na kamo ha impyirno? ");
INSERT INTO xsb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mamihogo ako ot komoyo nin pawpropita a mangangaral, tawtawon maronong tan mawmaistron kapanogoan. Main konlan hila-rin a patyon moyo tan main anamaot a ipasak moyo ha kros, main kamon rindiwon ha sawsinagoga moyo, tan to-tombokon moyo hila ot para da-damsakon ha bawbabali a ampolayowan la. ");
INSERT INTO xsb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kanya obaton moyo konan Dios yay biyay lan halban tawtawon mahonol konan Dios a pinati-pati hin yadtaw, paibat koni Abel a homin kasalanan, anggan koni Zacarias a anak ni Baraquias a pinati moyo ha pibotlayan nin altar tan timplo. ");
INSERT INTO xsb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yay potog, ibalita ko komoyo, hikamoy tawtawo hawanin ay mananggap anamaot nin parosa ha halban ya-rin.” ");
INSERT INTO xsb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bi-sa wanan impagpatoloy ni Jesus, “An-ikalolo katamoy tawtaga Jerusalem ha gawgawa moyon pa-mangmati ha pawpropita nan Dios tan pa-ma-batibat moyon bawbato anggan mati hilay laloma ot a an-ihogo na komoyo. Mabotbot a ngali-ngali kon mangano para alakopon katamo a bilang ha pa-ngalakop nin toan manok ha sawsisiw na ha hilong pakpak na, kot hikamoy kay malabay. ");
INSERT INTO xsb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kanya po-layan nan Dios odtin syodad moyo ta bi-sa homin anan tawon mi-wan iti. ");
INSERT INTO xsb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ibalita ko komoyo: Kay moyo koy na ma-kit oman anggan ha panaon a ihakbat moyo kongkon halitaon, ‘Poriwon yay anlomato ha ngalan nan Katawan.’” ");
INSERT INTO xsb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hin nilomikol hilay na ni Jesus itaw ha timplo ta omalih ana, dinomani hilay disipolos na kona ta intoro la konay bawbali a kahakopan nin timplo. ");
INSERT INTO xsb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kot wani Jesus konla, “Iya, angka-kit moyo-rin halban. Yay potog, ibalita ko komoyo, lomato yay panaon a homin anan ma-bati ison ni a-say bato a nakababo ha laloman bato ta halban ay watakon.” ");
INSERT INTO xsb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bi-sa, hin itaw hilay na ha Bakil Olibo ta bi-sa hi Jesus ay nakatoklo ana, dinomani hilay disipolos na kona nin hila-hilan bongat. Wanla, “Ibalita mo pa komi no maka-no mangyari yadtaw imbalita mon watakon yay timplo, bi-sa anyay pamilbian nin pa-mako mon oman iti tan yay panganggawan nin babon lota.” ");
INSERT INTO xsb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Inobat na hila ni Jesus kot binibilinan na hila yapon. Wana, “Mag-ingat kamo pigaw kay kamo mailingo nin hinoman. ");
INSERT INTO xsb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nga-min, lako a mako komoyo a mangamit ngalan ko ta ibalita lan hila yay Cristo. Bana konan yadti, lako a tawtawon mailingo la. ");
INSERT INTO xsb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Makalngo kamon lawlabanan tan bawbalita tongkol ha gawgira. Kot ando kamo mahalak ta kailangan mangyari yapon orin halban. Balo ta ambo ot ya-rin a panganggawan nin babon lota. ");
INSERT INTO xsb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nga-min, milalaban a nangasasari a nawnasyon tan kawkaarian. Magkamain anamaot bitil, aw-ipidimya tan layon ha nangasasari a lawlogar. ");
INSERT INTO xsb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kot ompisa bongat ya-rin nin masyadon pa-magdya-dya a bilang ompisan pa-manglayam tiyan bi-sa mangabing. ");
INSERT INTO xsb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Konan ya-rin a panaon ay dakpon la kamoy antompol kongko ta iintriga para da-damsakon tan patyon. Tiplonon la kamoy namaot nin tawtawo ha halban nawnasyon bana ha katotpol moyo kongko. ");
INSERT INTO xsb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kanya lako a mamibokot nin main lan katotpol kongko. Bi-sa pagtraidoran tan tiplonon lay kawkalamoan lan antompol. ");
INSERT INTO xsb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lako anamaot a lomtaw nin magkonwari a hila kot propita a mangangaral nan Dios, kanya lako a tawtawon mailingo la. ");
INSERT INTO xsb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bana ta lomoor anan lomoor a kawkarokaan, lako a tawtawon lomayop a labi la. ");
INSERT INTO xsb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kot yay makapagpatoloy nin maptog kongko anggan ha oltimo ay malipyas. ");
INSERT INTO xsb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tan yay Labah a Balita tongkol ha pa-mag-ari nan Dios ay maipangaral yapon ha intiron mondo, pigaw ma-tandaan lan tawtawo ha halban nawnasyon, ba-yo manganggawan a mondo.” ");
INSERT INTO xsb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Wana ot ni Jesus, “Ma-kit moyo yay sangkarokaan a kapa-palayang a ampangibatan nin ambo bastan paninira a binanggit ni Propita Daniel hin yadtaw ta ipa-dong ya ha Masagradon Logar ha timplo.” (Hikamoy ampamasa ay pakaintindyon moyodti!) - ");
INSERT INTO xsb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“No mangyari ana-rin a hola, hinoman a iti ha probinsyan Judea ay kailangan tampol molayon omari ha bakil. ");
INSERT INTO xsb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hinoman a ma-palatan ha likol nin bali ay ando yay na mag-abala nin lomoob, para mangwa nin anyakaman a ma-wit. ");
INSERT INTO xsb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Anorin anamaot kapara ha hinoman a ma-palatan ha bowat, ando yay na mag-abala nin morong ot ha bali para mangwan dawdoloh na. ");
INSERT INTO xsb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ka-ka-ro hilay ma-palatan malombit o ampamasoso konan ya-rin a panaon! ");
INSERT INTO xsb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kanya dawaton moyo ha Dios a ando tana komon mitaon ya-rin pa-molayo moyo ha panaon layop o ha Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nga-min, grabin pa-mag-dya-dya a domalan ha tawtawo konan ya-rin a panaon. Ya-rin anay klasin pa-magdya-dya a kay ot na-nangyari paibat hin pinalsay babon lota, tan kay ana maolit maski mika-ka-noman. ");
INSERT INTO xsb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No ya-rin a panaon nin pa-magdya-dya kot kay na paantoron Dios, homin tawon makalibri. Kot alang-alang konlan tawtawon pinili na ay paantoron na-rin. ");
INSERT INTO xsb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Hawanin, no wari ta main mamibalita komoyo, ‘Iti yay na hi Cristo!’ o kari wana, ‘Itaw ya!’ ando moyo pi-polon. ");
INSERT INTO xsb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nga-min main lomato a magkonwari a hila kano hi Cristo tan hilay namaot a laloma ay magkonwari a propita hila a mangangaral nan Dios. Mama-kit hilan ambo basta-bastan gawgawa a kawka-paka-ngap a konwari pamilbian kapangyarian nan Dios para mailingo la, no maari bongat pati tawtawon pinili nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","An-ipao-na koy nadti komoyo pigaw makapag-ingat kamo. ");
INSERT INTO xsb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kanya, no main mamibalita komoyo, ‘Itaw ya hi Cristo ha disyirto,’ ando kamo mako. No wanlay namaot, ‘Ison ya ha kwarto,’ ando moyo pi-polon. ");
INSERT INTO xsb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nga-min, yay kala-lato ko, hiko a Naglalaman Tawo ay ma-kit nin halban ta bilang odti ha kimat a ampaka-hawang paibat ha baytan anggan ha libaba. ");
INSERT INTO xsb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Wanay naor a-say kahalitaan, ‘No ayti bangkay, itaw ampititipon a bawbowitri.’” ");
INSERT INTO xsb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Wana ot ni Jesus, “Pa-makayari nin pa-magdya-dya lan tawtawo konan ya-rin a panaon, domoblom yay awlo tan yay bolan ay kay homawang, Mi-kadabo anamaot a bawbitoon tan yay lawlaloma ot ison ha ta-gay ay mi-kayogyog tan maalih ha andalanan la. ");
INSERT INTO xsb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bi-sa ma-kit ha langit yay pamilbian nin kala-lato ko, hiko a Naglalaman Tawo. Bi-sa, intiron tawtawo ha kalotaan ay mi-tangih-tangih ha sobran kali-mowan, ta ma-kit la kon amponaoy nin iti ha lolom, nin main awit kapangyarian tan ambo bastan karangalan. ");
INSERT INTO xsb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Malngo lay namaot a makhaw a tonoy trompita, ta konan ya-rin ay ihogo ko hilay aw-anghil ko ha a-pat a diriksyon nin babon lota, para tiponon lay tawtawon pinili ko maibat ha halban lawlogar.” ");
INSERT INTO xsb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wanan impagpatoloy ni Jesus, “Intindyon moyoy aral ibat ha poon igos: No ma-kit moyoy nan ampanarok tan ampama-yon bolong, tanda moyo a madani nay panaon abagat. ");
INSERT INTO xsb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anorin anamaot kapara, no ma-kit moyon ampangyari nadtin halban bawbagay a impatandaan ko ay ma-tandaan moyo a tampol akoy nan lomato, bilang akoy nan iti ha polta. ");
INSERT INTO xsb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yay potog, ibalita ko komoyo, ha tawtawon angkabyay hawanin panaon ay main ot angkabyay anggan kay mangyari yadtin halban bawbagay. ");
INSERT INTO xsb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Manganggawan a langit tan lota, balo ta yay hawhalita ko ay homin pa-ngapaso.” ");
INSERT INTO xsb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Wana ot ni Jesus, “Ma-kit moyoy pamilbian nin pa-mako kon oman iti, balo ta homin magtanda, no anya mag-awlo tan no anyay oras a ilato ko. Maskin hilay aw-anghil ha langit o hiko a Anak* ay kay ko tanda. Yay Ama kon bongat a magtanda. ");
INSERT INTO xsb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Yay pa-hal nin tawtawo ha kala-lato ko, hiko a Naglalaman Tawo ay bilang ot bongat ha pa-hal lan tawtawo hin panaon ni Noe. ");
INSERT INTO xsb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hin kay ot nanglonop, sigi-sigi hilan ampangan tan ampinom, main ampi-pagkaambali tan main anamaot an-ipaambali, anggan hin awlon nilomoob hila ni Noe ha arko. ");
INSERT INTO xsb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bi-sa bigla nanglonop nin homin magtanda, kanya halban la ay na-lilimoh. Anorin ot bongat kapara, homin magtanda ha pa-mako kon oman iti, hiko a Naglalaman Tawo. ");
INSERT INTO xsb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Konan ya-rin a panaon, main mangyarin aw-anodti: Alimbawa, main loway lalakin ampi-tambay nin ampagtrabaho ha bowat, bi-sa yay a-sa ay kowon, ta yay a-sa kot ibati. ");
INSERT INTO xsb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Anorin anamaot kapara, main loway babayin ampi-tambay nin mangiling, bi-sa yay a-sa ay kowon, ta yay a-sa kot ibati. ");
INSERT INTO xsb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kanya dapat pirmi kamon handa bana ta kay moyo tanda no anyay oras a ilato ko, hiko a Katawan moyo. ");
INSERT INTO xsb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tandaan moyodti: Alimbawa, no tanda na komon nin main ikon bali, no anyay oras ha yabi a ilato nan mahiba, sigoradon nagbantay ya tan kay na pino-layan nin na-looban a bali na. ");
INSERT INTO xsb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanya hikamo man, kailangan pirmi kamon handa ta hiko a Naglalaman Tawo ay makalato ha oras a kay moyo an-ola-lomon.” ");
INSERT INTO xsb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Bi-sa in-alimbawa ni Jesus a sarili na ha a-say amo, wana, “Hino kot a maiparis ha maronong tan maptog a ma-magsirbi, a pina-tayaan nin amo na, para mangasiwa ha main nan bali tan mami nin pawpa-mangan konlan kapara nan ma-magsirbi ha intakda a oras? ");
INSERT INTO xsb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Makalma yay anodtin ma-magsirbi no ha kala-lato nan amo na ay anggaw-on nay impa-taya konan trabaho. ");
INSERT INTO xsb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yay potog, ibalita ko komoyo, sigoradon gaw-on na yan ma-ngasiwa ha halban kawkama-main na. ");
INSERT INTO xsb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kot no a-sa yan doka a ma-magsirbi, wana ha sarili na, ‘Ma-boyotan a amo ko.’ ");
INSERT INTO xsb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bi-sa bogbogon na hilay nay kapara nan ma-magsirbi, ba-yo makipangan tan makiinoman ya tana konlan lawlasinggiro. ");
INSERT INTO xsb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tongwa, makalato yay amo na ha awlon kay na an-asahan tan ha oras nin kay na an-ola-lomon. ");
INSERT INTO xsb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kanya sigoradon parosawan na yan amo na tan ilamo na ya itaw ha kamainan lan tawtawon ampiabig-abig. Mi-tangih-tangih a tawtawo itaw tan mi-pigogot ha grabin kadya-dyaan.” ");
INSERT INTO xsb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Bi-sa wanay naman ni Jesus, “Yay pa-maghanda ha kalo-loob ha ampag-arian nan Dios ay bilang ha pa-maghanda nin mapolo a dalaga a ni-pamarta nin hiyo-san lamparilya, para makibanhal ha yabi ta hakbaton la yay nay nobyo. ");
INSERT INTO xsb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Yay lima konla ay madisposisyon, kot yay lima ay ambo madisposisyon, ");
INSERT INTO xsb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ta kay hila nagbalon risirban langis. ");
INSERT INTO xsb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hila balo a limay madisposisyon ay ni-pagbalon hilan langis pangrisirba. ");
INSERT INTO xsb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hawanin ta naboyot kay nakalato yay nobyo, halban la ay namatongga tan toloy nin nakaka-lok. ");
INSERT INTO xsb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kot hin kapikna yabi main hinoma-way, a wana, ‘Anlato yay nay nobyo! Hakbaton moyo yay na.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Halban lan mapolo a dalaga ay ni-pibangon, bi-sa inayos lay lawlamparilya la. ");
INSERT INTO xsb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hawanin, wanlan hilay lima a ambo madisposisyon, ‘Na-hominan kamin langis. Biyan la kami pa ta ma-lop anay lamparilya mi.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kot wanlan in-obat nin hilay madisposisyon, ‘Kay maari ta kay ana maka-harag yadti kontamon halban. Labah ot mako kamoy na manaliw.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanya nako hilan nanaliw. Kot kapi-pialih la, nakalato yay nobyo. Hawanin, hilay lima bongat a parihado a naka-paki-ka kona ha balin pagbanhalan. Bi-sa, hin nilomoob hilay na, inhara anay polta. ");
INSERT INTO xsb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Na-paongganan, nakalato hilay namaot a limay dalagan ambo madisposisyon. Bi-sa wanla, ‘Sinyor! Sinyor, paloobon mo kami pa.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Kot wanan in-obat nin nobyo konla, ‘Kai! Ibalita ko komoyo a kay katamo ambilbion.’” ");
INSERT INTO xsb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bi-sa wana ot ni Jesus, “Kanya hikamoy namaot, kailangan pirmi kamon handa, ta kay moyo tanda no anya mag-awlo tan no anyay oras a ilato ko, hiko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bi-sa nanotol yay naman hi Jesus nin a-say alimbawa, wana, “Yay pa-mag-ari nan Dios ay bilang ha a-say lalakin nako ha madayo a logar. Ba-yo ya inomalih, hina-wayan nay toloy alila na ta impa-taya na konlay kawkama-main na. ");
INSERT INTO xsb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Balang a-sa konla ay pina-tayaan nan kwarta ayon ha kanya-kanyan kababaan lan pa-mipalalako. Yay a-sa ay binyan nan limanlibo, yay a-say namaot ay lowanlibo tan yay a-sa ot ay sanlibo. Bi-sa inomalih yay nay amo. ");
INSERT INTO xsb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hawanin, yadtaw nakatanggap nin limanlibo ay nakoy na ta tampol nan innigosyo. Yay inogotan ay naka-tobo yan limanlibo. ");
INSERT INTO xsb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Anorin anamaot a ginwa nan yadtaw nakatanggap nin lowanlibo, kanya naka-tobo yan lowanlibo. ");
INSERT INTO xsb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kot yadtaw nakatanggap sanlibo ay ingkotkot nadti ha lota ta itaw na inharya a kwarta nan amo na. ");
INSERT INTO xsb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pa-makalabah nin maanloh a panaon, norong yay amo la. Bi-sa pinastang na hila no anyay ginwa la ha kwartan impa-taya na konla. ");
INSERT INTO xsb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yadtaw nakatanggap limanlibo ay dinomani ya kona, awit-awit nay kwarta nin amo na pati yay tinobo. Bi-sa wana, ‘Amo, oyay imbati mo kongkon limanlibo pati yay tinobo kon limanlibo.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Wanan amo na kona, ‘Maganday ginwa mo. Labah kan alila tan ma-pasimalaan. Hawanin ta na-pasimalaan ka ha daoto a alaga, pa-lahan koy ipa-taya ko komo pigaw lalon lomako. Lomoob ka para maki-liga-liga kongko.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Hawanin, dinomani yay namaot kona yadtaw nakatanggap nin lowanlibo, ta wana, ‘Amo, oyay imbati mo kongkon lowanlibo, tan oyay tinobo kon lowanlibo.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Wanan amo na kona, ‘Maganday ginwa mo. Labah kan alila tan ma-pasimalaan. Hawanin ta na-pasimalaan ka ha daoto a alaga, pa-lahan koy ipa-taya ko komo pigaw lalon lomako. Lomoob kay namaot para maki-liga-liga kongko.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Bi-sa dinomani yay namaot kona yadtaw nakatanggap nin sanlibo, ta wana, ‘Amo, tanda kon mahigpit ka ta ampanglapot ka nin ambo hikay nananom tan angkowon moy ganansya nin ambo hikay nagpagal. ");
INSERT INTO xsb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kanya ha kali-mowan ko ay ingkotkot koy kwarta mo ha lota ta inharya. Kanya oyay nay sanlibo mo.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kot wanan in-obat nin amo na kona, ‘Doka kan alila tan matamlar! Ha tanda mo, ampanglapot ako nin ambo hikoy nananom tan angkowon koy ganansya nin ambo hikoy nagpagal. ");
INSERT INTO xsb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maskin imbangko mo tana komon a kwarta ko ta pigaw pa-makalato ko ay makwa kon main tobo.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kanya wanan amo konlan laloman alila na, ‘Kowon moyoy kwarta a impa-taya ko kona ta ipa-lah konan yay main mapolo a libo. ");
INSERT INTO xsb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nga-min, yay tawon maronong magdisposisyon ha anyakaman a impa-taya kona ay lalon pa-lahan a main kona, kanya magkasobra ya. Kot yay tawon ambo maronong magdisposisyon ha impa-taya kona ay balawion orin kona. ");
INSERT INTO xsb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Bi-sa, ya-rin homin kapa-pakinabang a alila ay ibantak ya itaw ha na-pakaroblom a logar a kamainan lan tawtawon amparosawan. Itaw ay mi-tangih-tangih hila tan mi-pigogot ha grabin kadya-dyaan.’” ");
INSERT INTO xsb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wana ot ni Jesus, “Ha pa-mako kon oman iti, hiko a Naglalaman Tawo ay ma-kit a kalinggasan ko tan kalamo ko hilay halban bawbanal a anghil, ta bi-sa tomoklo akoy na ha trono kon homin kapara para manosga. ");
INSERT INTO xsb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Intiron tawtawo ha nawnasyon ay tiponon ha arapan ko, ta ipolok ko hilay tawtawo ko konlan ambo kon ikon, a bilang pa-mipolok nin pastol ha kawkarniro tan ha kawkanding. ");
INSERT INTO xsb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hilay tawon in-alimbawa ha karniro ay igwa ko hila ha wanan ko, balo ta hilay in-alimbawa ha kanding, iti hila ha wili ko. ");
INSERT INTO xsb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bi-sa hiko a Ari, halitaon ko konlan hilay iti ha wanan ko, ‘Hikamo a pinayabolan abig nin Ama ko, mako kamo iti ta mi-wan kamoy na ha kaarian a imparihado nan Ama ko para komoyo, paibat hin palsawon yay mondo. ");
INSERT INTO xsb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nga-min, hin mabitil ako ay pinapangan moyo ko, hin malata ako ay pinainom moyo ko. Maski a-sa kon dayo, pinahanda moyo ko. ");
INSERT INTO xsb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hin homin akon doloh, binyan moyo kon maiholot. Hin main akon masakit, tinibaw moyo ko. Hin nakapriso ko, kina moyo ko.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Bi-sa wanlan iobat nin hiladtin lawlabah a tawo, ‘Katawan, naka-no orin a na-kit mi kan mabitil a pinapangan mi ka, o malata ka a pinainom mi ka? ");
INSERT INTO xsb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Naka-no orin a dayo ka a pinahanda mi ka, o homin kan doloh a binyan mi kan maiholot? ");
INSERT INTO xsb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Naka-no orin a main kan masakit o nakapriso a tinibaw mi ka?’ ");
INSERT INTO xsb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Bi-sa, hiko a Ari ay anodti iobat ko konla, ‘Yay potog, ibalita ko komoyo, yay anyaman a ginwa moyo ha maskin a-sa konlan an-itoring pinakamaaypa a impagka-tawtalakaka ko ay bilang anan kongko moyo ginwa.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bi-sa halitaon koy namaot konlan tawtawo a iti ha wili ko, ‘Hikamo a inhompa, paka-dayo kamo kongko! Itaw kamo mako ha impyirno, ha apoy a homin pa-nga-lop a imparihado para koni Satanas tan para konlan dawdoka a anghil a nagpahakop kona. ");
INSERT INTO xsb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nga-min, hin mabitil ako ay kay moyo ko pinapangan, hin malata ako ay kay moyo ko pinainom. ");
INSERT INTO xsb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hin a-sa kon dayo ay kay moyo ko pinahanda. Hin homin akon doloh ay kay moyo ko binyan maiholot. Hin main akon masakit tan hin nakapriso ko ay kay moyo ko tinibaw.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Bi-sa wanlay namaot iobat kongko, ‘Katawan, naka-no orin a na-kit mi kan mabitil o malata o a-sa kan dayo o homin kan doloh o main kan masakit o nakapriso a kay mi ka tinambayan?’ ");
INSERT INTO xsb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Bi-sa ibalita ko konla, ‘Yay potog, ibalita ko komoyo, yay anyaman a kay moyo ginwa ha a-sa konlan an-itoring pinakamaaypa a impagka-tawtalakaka ko ay bilang ana syimprin kay moyo ginwa kongko.’ ");
INSERT INTO xsb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kanya hiladtaw tawtawon kay tinomambay ay mi-ka ha homin panganggawan a kaparosawan ha impyirno. Balo ta hiladtaw lawlabah a tawo ay magkamain hilan biyay homin anggawan ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hin nayari na imbalita ni Jesus odtin halban, wana konlan disipolos na, ");
INSERT INTO xsb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tanda moyo a loway awlo tana, Pistay nan Pa-makalibri.* Konan ya-rin a awlon pista, hiko a Naglalaman Tawo ay iintriga para ipasak ha kros.” ");
INSERT INTO xsb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hin ya-rin, nititipon hilay pawpoon pari, hilay mawmaistron kapanogoan, tan hilay pawpoon nin Israelita itaw ha palasyo ni Caifas a pinakapoon pari. ");
INSERT INTO xsb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nga-min, pinipapa-nowan la no pa-no la maipadakop hi Jesus nin homin magtanda pigaw maipapati la ya. ");
INSERT INTO xsb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kanya wanla, “Ando tamo itaon ha Pistan Pa-makalibri, ta ola-no magkagoloy tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hawanin, hin itaw hila ni Jesus ha baryon Betania ha bali ni Simon a datin nagmasakit kitong, ");
INSERT INTO xsb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","main a-say babayi a nako koni Jesus nin main awit na-pakablin pabanglo a nakaigwa ha botin gawa ha alabastro. Hin ya-rin a ampakirongo yan ampangan hi Jesus, imbo-bo nan babayi yay pabanglo ha olo ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kot hin na-kit la-rin nin hilay disipolos na, nagolo hila. Wanla, “Anongkot sinayang na-rin? ");
INSERT INTO xsb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ya-rin klasin pabanglo ay mailako komon nin mahi-ban a alaga, ta bi-sa maibi yay ma-paglakoan konlan mangairap.” ");
INSERT INTO xsb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kot palibhasay tanda ni Jesus a paninita la ha ginwa nan babayi, wana konla, “Anongkot anggolo-golowon moyoy isip na, anta labah odtin ginwa na kongko? ");
INSERT INTO xsb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hilay mangairap ay pirmi moyon maipagkalamoan, kot hiko, maantor tanay panaon a maipagkalamoan moyo ko. ");
INSERT INTO xsb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yadtin pa-mo-bo nan pabanglo kongko ay pa-miparihadoy na para ha pa-nabon kongko. ");
INSERT INTO xsb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yay potog, ibalita ko komoyo, ha aytimay logar ha intiron mondo a ipangaral yay Labah a Balita tongkol kongko ay ma-panomtoman yadtin babayi, ta mabanggit yay ginwa na kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hi Judas Iscariote a a-say namaot konlan labinloway disipolos ni Jesus ay nako konlan pawpoon pari. ");
INSERT INTO xsb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wana konla, “Anya wari a ibi moyo kongko no iintriga ko hi Jesus komoyo?” Yay ginwa la ay namilang hilan tolompolo a kwartan pilak para ibi kona. ");
INSERT INTO xsb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kanya paibat hin ya-rin, nana-gan yay nan tyimpo para ma-pagtraidoran na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hin ya-rin ay awloy na nin Pistan Pa-makalibri a ompisay namaot nin manglinggon Pistan Tinapay a Homin Pampalbag. Kanya dinomani koni Jesus hilay disipolos na, ta wanla, “Ayti may labay mon pamihandaan min pangaponan tamo para ha pista?” ");
INSERT INTO xsb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wani Jesus, “Mako kamo ha syodad ta ibalita moyo konan yadtaw tawo itaw, ‘Anodti a wanan Maistro: Madani na kanoy oras na. Labay nan silibrawon yay pangaponan pampista iti ha bali mo nin kalamo hilay disipolos na.’” ");
INSERT INTO xsb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanya main nakon dawdisipolos ni Jesus ha syodad Jerusalem ta ginwa lay ayon ha impagawa na. Inhanda lay naor a pangaponan la ha pista. ");
INSERT INTO xsb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hin yabi na, dinomolog yay na hi Jesus ha lamisawan, kalamo hilay labinloway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hin ampangan hilay na, wana konla, “Yay potog, ibalita ko komoyo, a-sa komoyo a magtraidor kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Masyado hilan nilomolo a dawdisipolos na, bi-sa a-sa a-sa hilan namastang koni Jesus, wanla, “Katawan, hiko doman?” ");
INSERT INTO xsb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wani Jesus, “Yay a-say ampaki-sabay kongkon mamidoldol tinapay ay hiya a magtraidor kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bi-sa wana ot, “Hiko a Naglalaman Tawo ay mati ayon ha nakasolat tongkol kongko, balo ta ka-ka-roy ogotan nin yay tawon magtraidor kongko! Labah ot a kay yay na komon impangabing.” ");
INSERT INTO xsb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bi-sa wani Judas a magtraidor kona, “Maistro, hiko doman?” Wani Jesus kona, “Nahalita moy na.” ");
INSERT INTO xsb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hin ya-rin a ampangan hila, nangwa yan tinapay hi Jesus. Pa-makayari nan pinasalamatan yay Dios, pini-pikna na bi-sa intorol na konlan disipolos na, ta wana, “Mangwa kamo ta kanon moyo. Yadti a lalaman ko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bi-sa nangwa yay namaot nin a-say kopa. Pa-makayari nan pinasalamatan yay Dios, inimbi na konlan disipolos na. Wana, “Minom kamo nin yadti, halban moyo, ");
INSERT INTO xsb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ta yadti a daya kon tomolo a pangibatan magkamain nin ba-yon kasondoan yay Dios ha tawtawo, para ma-patawad a lako a tawo ha main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ibalita ko komoyo, kay koy na minom oman nin anodtin inomon a ibat ha obas anggan ha lomato a panaon a kalamoan katamoy nan minom nin ba-yon klasin alak itaw ha kaarian nan Ama ko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bi-sa pa-makayari lan nagkanta nin pamomori ha Dios ay inomalih hilay nan mako ha Bakil Olibo. ");
INSERT INTO xsb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hin ya-rin, wani Jesus konlan disipolos na, “Yadtin yabi, halban moyo ay ibati moyo ko, ta wanay naor Dios ha Masanton Kasolatan, ‘Aboloyan kon patyon yay pa-hal pastol, kanya hilay pa-hal kawkarniro a ampastolan na ay miboyak.’ ");
INSERT INTO xsb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anodtaw pa man, morong akon mabyay, bi-sa mo-na ko komoyo ha Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wani Pedro kona, “Maskin ibati la kan hiladtin halban, mika-ka-noman kay kata ibati.” ");
INSERT INTO xsb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kot wani Jesus kona, “Yay potog, ibalita ko komo, yadti ot a yabi ba-yo tomaran-ok a manok, mitloy bisis mo kon iporlingor.” ");
INSERT INTO xsb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Wani Pedro kona, “Maskin pati hiko patyon la, kay kata iporlingor.” Anorin anamaot a imbalita lan halban laloma ot a disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bi-sa inawit ni Jesus hilay disipolos na ha a-say logar ha Bakil Olibo a anha-wayan Getsemani. Bi-sa wana konla, “Tomoklo kamo yapon iti ta mako ko ha banda itaw para domawat.” ");
INSERT INTO xsb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inawit nan impagkalamoan hi Pedro tan hilay loway anak ni Zebedeo. Tongwa, bigla yan nilomolo hi Jesus tan golo-goloy isip na. ");
INSERT INTO xsb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kanya wana konla, “Masyadoy kaloloan ko, halos kon ikamati. Iti kamo tana ta maki-poyat kamo kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dinomayô yan daoto, bi-sa nanalimokor yan palokob ta dinomawat ha Dios. Wana, “O Ama ko, no maari komon, ando mo aboloyan lomato odtin pa-magdya-dya kongko. Kot anodtaw pa man, ambo yay kalabayan koy mangyari nokay yay kalabayan mo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bi-sa, hin nagbolta ya konlan toloy disipolos na ay na-lato na hilan angka-lok. Wana koni Pedro, “Kay moyo doman magawa nin maki-poyat kongko maskin a-say oras? ");
INSERT INTO xsb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tomalan kamo tan domawat pigaw kay kamo matokso. Mahi-ban a nakom moyon homonol, kot kay mababa nin sarili moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bi-sa dinomayô yay naman hi Jesus ta dinomawat. Wana, “O Ama ko, no wari ta kay ma-pa-lilihan odtin pa-magdya-dya ko, mangyari a kalabayan mo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bi-sa, hin kina nan oman hilay toloy disipolos na, na-lato na hilay naman nin angka-lok bana ta namatongga hila. ");
INSERT INTO xsb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanya imbati na hilay naman ta nako ya dinomawat nin ikatlon bisis nin anodtaw ot syimpri a indawat na. ");
INSERT INTO xsb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na-paongganan, kina nay naman hiladtin disipolos na. Bi-sa wana konla, “Angka-lok kamo ot? Ampagpainawa kamo ot anggan hawanin? Nilomato anay oras a hiko a Naglalaman Tawo kot iintrigay na konlan tawtawon makasalanan. ");
INSERT INTO xsb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mibangon kamoy na ta lomato yay nay magtraidor kongko. Hakbaton tamo hila.” ");
INSERT INTO xsb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lo-gan ya ot ampanalita hi Jesus, nakalato naor hi Judas a a-sa konlan labinloway disipolos. Kalamo nay lako a tawon main awit bawbonong tan pawpapatok a inhogo lan pawpoon pari tan pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Binyan na hilay nan daan ni Judas a magtraidor nin pamilbian, a wana, “Yay alokan ko, yadtaw a dakpon moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hawanin, dinomani naor hi Judas koni Jesus, ta wana, “Komosta, Maistro!” Bi-sa inalokan na ya. ");
INSERT INTO xsb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kot wani Jesus kona, “Amigo, gaw-on moy nay sadya mo!” Bi-sa dinomani hilay nay tawtawon kalamoan ni Judas ta binombonan la hi Jesus ta dinakop. ");
INSERT INTO xsb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hawanin, a-sa konlan kalamoan ni Jesus ay tampol nan inoyoh a bonong na ta tinabtab nay alila nan pinakapoon pari. Kot totolyan a natigpah na. ");
INSERT INTO xsb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kot wani Jesus kona, “Igomâ moy bonong mo ta hinoman a mangamit bonong para ipangmati ha kapara ay bonong anamaot a ipangmati kona. ");
INSERT INTO xsb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hay wamo wari, kay ko makadawat konan Ama ko para manogo ya hawanin ot nin libo-libon anghil para tomambay kongko? ");
INSERT INTO xsb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kot no gaw-on ko-rin, pa-no man ot pomtog yay wana ha Masanton Kasolatan a dapat mangyari yadti kongko?” ");
INSERT INTO xsb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hin ya-rin ot a oras, wani Jesus konlan hila-rin lako a tawo, “Tolisan ako doman ta nangawit kamo ot bawbonong tan pawpapatok ha pa-nakop moyo kongko? Anta awlo-awlo kon ampanoro ha timplo, kot kay moyo ko dinakop. ");
INSERT INTO xsb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kot konan yadtin halban ampangyari ay angka-paptogan yay sawsinolat lan pawpropita nan Dios ha Masanton Kasolatan tongkol kongko.” Hin ya-rin, halban disipolos na ay nipo-polayo ta imbati la ya. ");
INSERT INTO xsb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hawanin, inawit la hi Jesus nin hilay nanakop kona ha bali ni Caifas, yay pinakapoon pari ta itaw hila nititipon a mawmyimbro nin pinakamata-gay a konsiho nin nasyon Israel a bilang konlan mawmaistron kapanogoan tan hilay pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hi Pedro namaot ay mato-totombok nin main karayoan. Pa-makalato na itaw ha bali nan pinakapoon pari, nilomoob ya ha patyo ta naki-toklo konlan gwardya ta labay nan ma-tandaan no anyay mangyari koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hilay namaot a pawpoon pari tan halban lan pawpoon nin Israelita itaw a pari-parihon myimbro nin pinakamata-gay a konsiho ay naningkap nin tawtawon tomistigon kagalotoyan laban koni Jesus pigaw maipapati la ya. ");
INSERT INTO xsb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kot maskin lako a nagtistigon kawkagalotoyan, homin ha hinalita la a magamit laban koni Jesus. Hin hoyot, main anaman loway palson tistigon inomarap. ");
INSERT INTO xsb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Wanla, “Yadtin tawo, anodti hinalita na: ‘Baba kon yobaon yay timplo nan Dios ta bi-sa maipa-dong kon oman ha loob nin toloy awlo.’” ");
INSERT INTO xsb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Inomdong yay pinakapoon pari, ta wana koni Jesus, “Anyay maiobat mo konan ya-rin riklamo la komo?” ");
INSERT INTO xsb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kot namakatinok yan bongat hi Jesus. Bi-sa wanay naman nin pinakapoon pari kona, “Ha arapan nan Dios a angkabyay, mangalimpotogan ka no doman ta hika yay Cristo, yay Anak nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Wani Jesus kona, “Nahalita moy na. Kot ibalita ko komoyo: Ha lomato a panaon, ma-kit moyo ko, hiko a Naglalaman Tawo nin nakatoklo ha wanan nan Dios a Makapangyayari, tan ma-kit moyo ko ot lomato nin iti ha lolom.” ");
INSERT INTO xsb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ha ka-motan olo nan pinakapoon pari bana ha pa-mipantay ni Jesus nin sarili na ha Dios ay winakwak nay sarili nan doloh. Bi-sa wana konlan mawmyimbro nin pinakamata-gay a konsiho, “Yay hinalita na ay pa-masta-basta ha Dios! Anongkot kailangan tamo ot a tawtistigo? Nalngo moyoy na hawanin a pa-masta-basta na ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Anyay sintinsya moyo?” Wanlan in-obat, “Dapat yan patyon!” ");
INSERT INTO xsb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kanya niloraan lay lopa na tan bino-bogbog la ya. Hilay namaot a laloma ay tina-tampal la ya. ");
INSERT INTO xsb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Wanla kona, “Hika, Cristo, holaan mo pa no-nin no hino-hinoy ampanampal komo.” ");
INSERT INTO xsb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hin ya-rin a nakatoklo hi Pedro itaw ha patyo, tongwa main a-say babayin alila nan pinakapoon pari a dinomani kona. Wana, “A-sa kay namaot a kalamoan ni Jesus a taga Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kot imbori nadti ni Pedro nin nalngo lan halban tawtawo itaw, a wana, “Kay ko tanda a labay mon totolon.” ");
INSERT INTO xsb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bi-sa, hin nako ya ha poltan balaybay, na-kit yay naman nin a-say laloman babayin alila. Wanan yadtin alila konlan hilay tawtawo itaw, “Yadtin tawo ay kalamoan ni Jesus a taga Nazaret.” ");
INSERT INTO xsb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kot imbori nay naman ni Pedro, a wana, “An-ihompa ko, ambo kon bilbi ya-rin a tawo!” ");
INSERT INTO xsb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na-paongganan daoto, dinomani hilay naka-dong itaw koni Pedro, ta wanla, “Sigoradon a-sa kay namaot ha kawkalamoan na, ta mapatnag ha pa-nalita mo a taga kay namaot Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hin ya-rin ay nagho-hompa yay na hi Pedro, wana, “Maski parosawan na kon Dios, talagan ambo kon bilbi ya-rin a tawo!” Tongway naor tinomaran-ok a manok. ");
INSERT INTO xsb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bi-sa na-panomtoman ni Pedro yay hinalita ni Jesus kona, a wana, “Ba-yo tomaran-ok a manok, mitloy bisis mo kon iporlingor.” Kanya nilomikol hi Pedro bi-sa tinomangih yan hosto. ");
INSERT INTO xsb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hin kinaboklahan, halban lan pawpoon pari tan hilay pawpoon nin Israelita ay pinipapa-nowan lay pa-mapati koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bi-sa yay ginwa la ay impabalol la ya ta inawit koni Poncio Pilato, yay gobirnador a taga Roma. ");
INSERT INTO xsb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hin na-tandaan ni Judas Iscariote a nagtraidor koni Jesus a sinintinsyawan la yan kamatyan ay nangombabali ya. In-orong nay tolompolo a kwartan pilak konlan pawpoon pari tan konlan pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wana, “Nagkasalanan ako ta impadakop koy tawon homin kasalanan.” Wanla, “Anya may pakiomon mi ison? Bahala ka ha sarili mo.” ");
INSERT INTO xsb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Imbasyo ni Judas a kwarta itaw ha timplo ta bi-sa nilomikol yay na ta nako ya nagbibitay. ");
INSERT INTO xsb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinolot la syimprin pawpoon pari a kwarta, bi-sa wanla, “Kontra ha kawkapanogoan nan Dios no ilaok tamodti ha kwarta nin timplo, bana ta pangibatan odti nin main mabo-bo a daya.” ");
INSERT INTO xsb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kanya nipapa-no hila yapon ta bi-sa yay kwarta ay impanaliw lan yadtaw bowat nan ma-mangwa koron para mag-in pamitabonan nin dawdayowan. ");
INSERT INTO xsb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanya, ya-rin hinaliw lan bowat ay anha-wayan anggan hawanin nin “Bowat nin Daya.” ");
INSERT INTO xsb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kanya pinomtog yay impabalita nan Dios koni Propita Jeremias hin yadtaw, a wanan nakasolat, “Kinwa lay tolompolo a kwartan pilak a na-pi-sondoan nin omnoy Israelita a kabayaran biyay nin a-say tawo. ");
INSERT INTO xsb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yadti impamayar lan yadtaw bowat nan ma-mangwa koron ayon ha impanakom nan Katawan kongko.” ");
INSERT INTO xsb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hin in-arap lay na hi Jesus koni Gobirnador Pilato, wana koni Jesus, “Hika doman a Ari lan Israelita?” Wanan in-obat ni Jesus, “Nahalita moy na.” ");
INSERT INTO xsb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kot hin binaraan la yan pawpoon pari tan hilay pawpoon nin Israelita ay kay ya nanlok. ");
INSERT INTO xsb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kanya wani Gobirnador Pilato kona, “Kay mo doman angkalngo ya-rin kalakan riklamo la komo?” ");
INSERT INTO xsb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kot homin yan inobat hi Jesus ni a-sa ha rawriklamo la kona, kanya masyado yan naka-ngap a gobirnador. ");
INSERT INTO xsb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Taon-taon, no Pistan Pa-makalibri nin Israelita ay nakaogalian a yay gobirnador a taga Roma ay ampamiboloh nin a-say priso ayon ha dawaton nin tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hin ya-rin, main a-say prison bantog a yay ngalan ay Barabbas. ");
INSERT INTO xsb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kanya, hin tipon hilay tawtawo, pinastang na hila ni Gobirnador Pilato. Wana, “Hino kot a labay moyon bolohan ko para komoyo, hi Barabbas doman o hi Jesus a anha-wayan ‘Cristo’?” ");
INSERT INTO xsb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pinastang nadtaw ta tanda na a angkainggit hilay pawpoon pari tan pawpoon nin Israelita koni Jesus, kanya la ya in-intriga. ");
INSERT INTO xsb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ambo bongat orin, nokay hin itaw yay na antoklo hi Gobirnador Pilato ha Intabladon Bato a ampagbistawan na, main impapibalita yay kaambali na kona. Wana, “Ando ka gomwa nin anyakaman a bagay kontra konan ya-rin tawon homin kasalanan. Nga-min, nayabi na-pairapan akon masyado ha taynop ko tongkol kona.” ");
INSERT INTO xsb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kot hilay pawpoon pari tan pawpoon nin Israelita ay kinombinsi lay malabong a tawo itaw a dawaton la koni Gobirnador Pilato a hi Barabbas yay bolohan ta bi-sa hi Jesus a ipapati. ");
INSERT INTO xsb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Hawanin, pinastang na hilay naman nin gobirnador, wana, “Hino kot konlan lowa a labay moyon bolohan ko para komoyo?” “Hi Barabbas,” wanlan in-obat. ");
INSERT INTO xsb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bi-sa wanay naman ni Gobirnador konla, “Anya man no-nin a gaw-on ko koni Jesus a anha-wayan Cristo?” “Ipasak ya ha kros!” wanlan halban. ");
INSERT INTO xsb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kot wani Gobirnador, “Anongkot, anya kot a nagawa nan karokaan?” Kot lalo lan in-aghaw, a wanla, “Ipasak ya ha kros!” ");
INSERT INTO xsb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hawanin, na-kit ni Gobirnador Pilato a homin yan magawa para ma-patgon hilay tawtawo ta masbali hilay na ingat ampagkagolo. Kanya namakwa yan lanom ta nibano ya ha arapan lan tawtawo, wana, “Yadti a pamilbian a ambo kon kasalanan a pa-mapati konan yadtin tawon homin kasalanan. Hikamoy mangobat ha kamatyan na.” ");
INSERT INTO xsb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wanlan halban tawtawo itaw, “Iya, hikami tan hilay aw-awa-nak mi a mangobat ha kamatyan na!” ");
INSERT INTO xsb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanya impapiboloh na hi Barabbas, balo ta hi Jesus ay impalatigo na. Bi-sa in-intriga na ya ha omnoy hondalo a taga Roma para ipasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hawanin, hiladtin hondalo nan gobirnador ay inloob la hi Jesus ha ampagkampowan la ha palasyo nan gobirnador. Bi-sa in-arap la ya ha halban kawkalamoan lan hondalo. ");
INSERT INTO xsb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nilapyangan la ya, bi-sa pinadolohan la yan kolor obi ta konwari ari ya. ");
INSERT INTO xsb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Namayokal hilan hangan marowih ta inkorona la kona. Pinaga-gotan la ya ot talaib ha wanan gamot na a konwari baston ari. Pa-makayari, nana-talimokor hila kona nin main awit a pa-noya-toya, wanla, “Viva yay Ari lan Israelita!” ");
INSERT INTO xsb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bi-sa nilora-loraan la ya, ba-yo hinampat lay impaga-gotan lan talaib kona ta impa-pahpah la ha olo na. ");
INSERT INTO xsb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hin nayari la yan tinoya-toya, nilohpok lay impadoloh la kona ta impaholot lay sarili nan doloh, ta bi-sa ini-ka la yay nan ipasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hin anlomikol hilay na ha syodad Jerusalem, na-hakbat lay a-say lalakin taga Cirene a yay ngalan kot Simon. Pinilit la yan hawhondalo a balatayon nay kros ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hin nakalato hilay na ha Golgota (yay labay totolon “Logar nin Bongo”), ");
INSERT INTO xsb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","binyan la hi Jesus nin maalhom a alak obas a nilaokan mapait a makatambal hakit para inomon na. Kot hin na-tawayan na, kay na ininom. ");
INSERT INTO xsb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hin nayari la impasak hi Jesus ha kros, nibobonot hilay hawhondalo ta pinipapartiwan lay dawdoloh na. Ha anorin a nangyari ay na-paptogan yay hinalita nan propita nan Dios, a wanan nakasolat, “Pinarti-parti lay dawdoloh ko ta bi-sa pini-bonotan la no hinoy makapag-ikon nin ayhing ko.” ");
INSERT INTO xsb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pa-makayari nin ya-rin ay tinomoklo hilay hawhondalo ta itaw hila nin ampagbantay koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Namipaskin hila ha olowan ni Jesus nin anodti a bara-nan nin pa-mapati kona: “Yadti hi Jesus a Ari nin Aw-Israelita.” ");
INSERT INTO xsb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Main anamaot loway tolisan a impasak la ha kros, yay a-sa ha bandan wanan ni Jesus tan yay a-sa ha bandan wili na. ");
INSERT INTO xsb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bi-sa hilay tawtawon anlomabah ay tinoya-toya la yan main ot awit a poyong olo. ");
INSERT INTO xsb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wanla, “Wamo, yobaon moy timplo ta ba-yo ipa-dong mon oman ha loob nin toloy awlo, di ilipyas mo hawanin a sarili mo. No hikay Anak nan Dios, omaypa ka no-nin ha kros.” ");
INSERT INTO xsb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tinoya-toya la yay namaot nin hilay pawpoon pari, pati hilay mawmaistron kapanogoan tan pawpoon nin Israelita, wanla, ");
INSERT INTO xsb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Inlipyas na hilay laloma, kot mismon sarili na ay kay na mailipyas. No hiyay Ari nin Israel, magtatangtang ya hawanin ha kros pigaw mi-pol tamo kona. ");
INSERT INTO xsb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ampasimala ya konan Dios, tan wana, hiya yay Anak nan Dios. Bilyon tamo pa no-nin no ilipyas na ya hawanin.” ");
INSERT INTO xsb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Maskin hilay tolisan a impasak anamaot ha kros nin kasabay na ay anorin anamaot a pa-noya-toya la kona. ");
INSERT INTO xsb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Paibat ogtiawlo ay dinomoblom a intiron ka-libol anggan alas tres nin apon. ");
INSERT INTO xsb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hin ya-rin a bandan alas tres, wanan in-aghaw ni Jesus, “Eli, Eli, lema sabachthani?” yay labay totolon, “Dios ko, Dios ko, anongkot mo ko ampo-layan?” ");
INSERT INTO xsb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hin nalngo la-rin nin omnoy tawon nakaodong itaw, kay la naintindyan. Wanla, “Anha-wayan na hi Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Antimano polayo nan a-sa konla, ta nangwa yan ispongha. Bi-sa insawsaw na ha maalhom a alak obas ta inigwa ha tampoh nin talaib, ta impahophop na koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wanla balo laloma, “Ta-gan, ta biliwon tamo no kaon na yan ilipyas ni Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tongwa inomaghaw anaman hi Jesus, bi-sa in-intriga nay na a ispirito na konan Dios. ");
INSERT INTO xsb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hin ya-rin, yay kortina ha botlay nin timplo ay bigla nagi-nit ha botlay paibat ta-gay anggan aypa. Nanglayon anamaot tan nangapapakay bawbakil a bato. ");
INSERT INTO xsb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Naabriyan anamaot a pawpinanabonan, tan lako a bawbanal a tawo nan Dios a nati na a norong nabyay. ");
INSERT INTO xsb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi-sa, pa-makayari nan norong nabyay ni Jesus, nilomikol hiladti ha pinanabonan konla ta nako ha Jerusalem a anha-wayan “Masagradon Syodad” ta nagpa-kit ha lako a tawo. ");
INSERT INTO xsb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yay kapitan nin hawhondalo tan hilay kalamoan na a ampagbantay koni Jesus ay nalayam lay layon tan na-kit lay ni-pangyari, kanya masyadoy li-mo la. Bi-sa wanla, “Talagan hiya yay Anak nan Dios!” ");
INSERT INTO xsb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lako anamaot a bawbabayi itaw a ampanamolaw hin ya-rin. Hila-rin a hinomonol tan tinomambay koni Jesus paibat hin nangaral ya ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yay laloma konla ay hi Maria Magdalena, hi Maria a nanay li Santiago tan Jose, tan yay nanay lan loway disipolos a awa-nak ni Zebedeo. ");
INSERT INTO xsb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hin madani nay yabi, nakalato a a-say lalakin yay ngalan kot Jose a taga babalin Arimatea. A-sa yan mayaman a hinomonol anamaot koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nako ya koni Gobirnador Pilato ta dinawat nay bangkay ni Jesus. Kanya inmanda ni Gobirnador Pilato a ibi kona. ");
INSERT INTO xsb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hawanin, kinwa ni Jose a bangkay ni Jesus ta pinotot nan ba-yon pinon tila a mapoti. ");
INSERT INTO xsb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bi-sa inggawa na ya ha ba-yon panabonan a impakwiba na ha bakil a bato a para komon pansarili na. Bi-sa intolir nay malapar a bato ta impanara na ha pinanabonan. Hin nayari ay nako yay na. ");
INSERT INTO xsb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hawanin, hi Maria Magdalena tan yay a-sa ot a Maria ay itaw hila nakatoklo ha tobon pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kinadilapan, Awlon Pa-mainawa, ni-pako hilay pawpoon pari tan paw-Pariseo koni Gobirnador Pilato. ");
INSERT INTO xsb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wanla kona, “Gobirnador, angka-panomtoman midtaw imbalita nan yadtaw ma-magkonwari a hi Jesus hin angkabyay ya ot, a pa-makayari kano nin toloy awlon pa-ngamati na ay morong yan mabyay. ");
INSERT INTO xsb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanya no maari, ipabantayan mon labah yay pinanabonan kona anggan ha ikatlon awlo, ta ola-no kaon lan hibaon nin dawdisipolos na a bangkay na ha yabi ta bi-sa halitaon la ha tawtawo a norong yan nabyay. No gaw-on la-rin, mas grabi na ingat a mangyari nin pa-manglingo-lingo la dinan hin o-na.” ");
INSERT INTO xsb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Wani Gobirnador Pilato konla, “Sigi, mangwa kamon hawhondalo ko. Bi-sa mako kamoy na ta gaw-on moyoy halban paralan a maisipan moyo.” ");
INSERT INTO xsb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kanya nako hilay na. Bi-sa namidalit hilan panandaan ha baton impanara ha pinanabonan pigaw ma-tandaan no wari ta main mangabri. Ba-yo impagwardyawan la ot ha hawhondalo. ");
INSERT INTO xsb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pa-makayari nin Awlon Pa-mainawa, palbangon ot nin Dominggo, nako hilay na ni Maria Magdalena tan yay a-sa ot a Maria ha pinanabonan koni Jesus para biliwon la ya. ");
INSERT INTO xsb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tongwa, nanglayon makhaw, ta nonaoy ibat ha langit a a-say anghil nan Katawan. Kina nan intolir a baton impanara ha poltan pinanabonan, bi-sa na tinokloan. ");
INSERT INTO xsb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yay itsora nan anghil ay ampaka-polag a bilang kimat. Yay ayhing na ay na-pakapoti a ampangi-kirlap. ");
INSERT INTO xsb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ha kali-mowan lan gwardya ay pinangoygoyan hila, bi-sa naalihan malay. ");
INSERT INTO xsb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kot wanan anghil konlan babayi, “Ando kamo mali-mo. Tanda kon antingkapon moyo hi Jesus a impasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kay yay na iti ta norong yay nan nabyay ayon ha hinalita na. Domani kamo iti ta biliwon moyoy pinamigaw-an konan Katawan. ");
INSERT INTO xsb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bi-sa mako kamoy nan tampol ta ibalita moyo konlan dawdisipolos na yay anodti: ‘Norong yan nabyay, bi-sa mo-na ya komoyon mako ha Galilea. Itaw moyo ya ma-kit.’ Tandaan moyodtin imbalita ko.” ");
INSERT INTO xsb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tampol hilan inomalih ha pinanabonan nin angkali-mo, kot mahi-ban a kaligawan la. Nolayo hila para balitaan hilay disipolos ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hin ya-rin a ampako hila para ipatandaan konlan disipolos na, tongwa na-kit la hi Jesus a hinomakbat konla nin nangasikaso. Dinomani hila kona, bi-sa nanalimokor ta gina-gotan lay ayi na, ba-yo sinamba la ya. ");
INSERT INTO xsb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bi-sa wani Jesus konla, “Ando kamo mali-mo. Mako kamoy na ta ibalita moyo konlan impagka-talakaka ko a mako hila ha Galilea ta itaw la ko ma-kit.” ");
INSERT INTO xsb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hin iti hila ot ha dalan a loway babayi, hilay namaot a laloman gawgwardya ay nako ha syodad Jerusalem ta imbalita la konlan pawpoon pari yay halban nangyari. ");
INSERT INTO xsb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kanya tinipon lan pawpoon pari hilay pawpoon nin Israelita a ka-konsiho la ta bi-sa hila nipapa-no. Pa-makayari ay sinoholan lay hawhondalo nin lako a kwarta. ");
INSERT INTO xsb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bi-sa wanla, “Ibalita moyo ha tawtawo a nayabi ay kina lan hiniba nin dawdisipolos ni Jesus a bangkay na lo-gan kamon angka-lok. ");
INSERT INTO xsb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Bi-sa, no wari ta miabot yadti konan gobirnador, hikami nay makaolay nin maki-totol kona pigaw homin kamon dapat kali-mowan.” ");
INSERT INTO xsb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kinwa lan hawhondalo a kwarta ta bi-sa hinonol ladtaw pinanogoan konla. Kanya ya-rin a tototolon ay ampibantog konlan aw-Israelita anggan hawanin. ");
INSERT INTO xsb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hawanin, hilay labin-a-say disipolos ni Jesus ay nako ha probinsyan Galilea, ha bakil a imbalita nan paka-kitan la kona. ");
INSERT INTO xsb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pa-maka-kit la koni Jesus itaw ay sinamba la ya, kot main ot konla a ampagdoda. ");
INSERT INTO xsb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pinaka-daniwan na hila ni Jesus, bi-sa wana konla, “Halban kapangyarian ha langit tan ha lota ay inimbi nay nan Dios kongko. ");
INSERT INTO xsb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kanya mako kamo ha halban nawnasyon ta gaw-on moyon disipolos ko a tawtawo: Baotismowan moyo hila ha ngalan nan Ama, nan Anak tan Ispirito Santo, ");
INSERT INTO xsb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","tan toroan moyo hilan homonol ha halban pinanogoan ko komoyo. Tandaan moyo a lawah katamon lalamoan anggan manganggawan a mondo.” Amen.");
INSERT INTO xsb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yadti yay ompisa nin yay Labah a Balita tongkol koni Jesu-Cristo a Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ha libro ni Propita Isaias ay anodti nakasolat a halita nan Dios konan Anak na: “Main akon ihogo nin mo-na komo A mamiparihadon kanakoman lan tawtawo para ha main mon kala-lato. ");
INSERT INTO xsb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Malngo a bosis na itaw ha disyirto nin ampama-balawbaw, a wanan ialimbawa: ‘Iparihado moyoy pa-hal pagpa-wanan nan Katawan, tan pa-hal itoynong moyoy dalanan na.’” ");
INSERT INTO xsb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ayon ha nakasolat, nakalato anaor hi Juan Bautista itaw ha disyirto. Impangaral na ha tawtawo a kailangan mi-pangombabali hila tan bokotan lay kawkasalanan la, tan pabaotismo pigaw patawaron na hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Halos halban tawo ha probinsyan Judea, laloy na ha syodad Jerusalem ay nako nanglongo kona. Bi-sa binaotismowan na hila itaw ha Kabatwan Jordan hin imbalita lay main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yadtin hi Juan, yay ayhing na ay momorawon bongat a klasi a yari ha habot kamilyo, bi-sa yay an-ipagsintoron na ay bastan katat. Yay pa-mangan nay namaot ay doron tan polot panilan bongat. ");
INSERT INTO xsb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wana ot nin impahawang, “Main lomato hoyot kongko a mas makapangyayari kongko, ta ni tomook para mangorkal kordon apin na ay ambo akon marapat. ");
INSERT INTO xsb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ambaotismowan katamo nin lanom, kot yay lomato, hiyay mamaotismo komoyo nin Masanton Ispirito nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Hin ya-rin a panaon, inomalih hi Jesus ha babalin Nazaret, probinsyan Galilea ta nako ya koni Juan Bautista ta nagpabaotismo kona itaw ha Kabatwan Jordan. ");
INSERT INTO xsb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pa-makainapat na, na-kit nan naabriyan a kalangitan ta bi-sa inomaypa konay Ispirito nan Dios bilang a-say kalapati. ");
INSERT INTO xsb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bi-sa wanan bosis nan Dios a naibat ha langit, “Hika a anlabyon kon Anak tan angkalilikot akon labah komo.” ");
INSERT INTO xsb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hawanin, hi Jesus ay tampol yan pina-ka nin Ispirito nan Dios ha disyirto. ");
INSERT INTO xsb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Lolog nin a-pat a polo a awlo na itaw ay antoksowon na ya ni Satanas. Yay kalamoan nan bongat itaw ay aw-ayop talon. Balo ta main aw-anghil a nako kona ta sinirbiwan la ya. ");
INSERT INTO xsb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Hin impriso hi Juan Bautista, norong hi Jesus ha probinsyan Galilea ta impangaral na yay Labah a Balita tongkol ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wana, “Yadti nay panaon a intakda nan Dios. Madani nay nan ipa-kit a pa-mag-ari na. Kanya pangombabalyan tan bokotan moyoy nay kawkasalanan moyo, tan mi-pol kamo ha Labah a Balita.” ");
INSERT INTO xsb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ninghan, lo-gan anlalako hi Jesus ha liglig Alindayat Galilea, na-kit nay mitalakakan Simon tan Andres. Ampanglala hila hin ya-rin ta maninilay hila. ");
INSERT INTO xsb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wani Jesus konla, “Homonol kamo kongko ta paibat hawanin ay gaw-on katamon pa-hal maninilay tawo para tompol hila kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tampol lan in-inapat a lala la ta hinomonol hila kona. ");
INSERT INTO xsb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nakalalako hilan daoto, na-tamolaw ni Jesus hi Santiago tan hi Juan a awa-nak ni Zebedeo. Itaw hila ha baloto la nin ampangayoman aw-ikot la. ");
INSERT INTO xsb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Antimano hina-wayan na hilay namaot ni Jesus. Kanya imbati lay tatay la pati hilay an-opaan lan kawkatambay itaw ha baloto ta hinomonol hilay namaot kona. ");
INSERT INTO xsb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Hawanin, nako hi Jesus tan hilay dawdisipolos na ha babalin Capernaum, probinsyan Galilea. Lomato a Awlon Pa-mainawa nin Israelita, nako hi Jesus ha sinagoga a ampagsambawan la ta nangaral ya. ");
INSERT INTO xsb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Naka-ngap hilay tawtawo ha klasin pa-noro na, ta nanoro yan bilang a-say main kapangyarian, ambo bilang ha pa-noro lan mawmaistron kapanogoan nin aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ha loob nin ya-rin a sinagoga ay main a-say lalakin nilooban nin doka a ispirito a bigla inomaghaw. ");
INSERT INTO xsb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wana, “Po-layan mo kami! Anyay pakiomon mo komi, Jesus a taga Nazaret? Parosawan mo kami na doman? Tanda kon hika yay Banal a inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hinaar na ya ni Jesus, “Mamakatinok ka, tan omalih ka kona!” wana. ");
INSERT INTO xsb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pinagoygoy nan doka a ispirito yay lalaki, bi-sa niaaghaw ya ot ba-yo ya inomalih. ");
INSERT INTO xsb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Naka-ngap hilay halban tawtawo itaw, kanya nipapa-no hila. Wanla, “Anya yadti? Ba-yon klasin totoro? Main yan kapangyarian! Angka-mandawan na maskin hilay dawdoka a ispirito ta anhonolon la ya.” ");
INSERT INTO xsb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanya tampol yan nibantog hi Jesus ha intiron probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pa-makayari nan pinalayah ni Jesus yadtaw doka a ispirito, antimano inomalih hila ni Jesus ha sinagoga ta nako hila ha bali la ni Simon tan Andres nin kalamo anamaot hi Santiago tan hi Juan. ");
INSERT INTO xsb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hin ya-rin ay ampira yay katyangan ni Simon ta angka-mot. Imbalita ladtin tampol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dinomani hi Jesus konan babayi, bi-sa na ginawang a gamot na ta binangon na ya. Antimano inomabig ya ha main nan pa-nga-mot. Bi-sa sinirbiwan na hilay na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hin nayari anay Awlon Pa-mainawa ta hinomlop anay awlo, inawit lan tawtawo koni Jesus a halban main masakit tan nilooban dawdoka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Halos halban tawtawo konan ya-rin a babali ay itaw natipon ha arapan bali. ");
INSERT INTO xsb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lako a tawtawon main nangasasari a klasin masakit a pina-paabig ni Jesus tan lako anamaot a pina-palayah nan dawdoka a ispirito ha tawtawon nilooban la. Kay na pinayagan manalita a dawdoka a ispirito ta tanda la a hiya yay Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Palbangon ot, nibangon ana hi Jesus ta nako ya ha a-say logar a homin katawo-tawo ta itaw ya dinomawat. ");
INSERT INTO xsb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tinombokan na ya ni Simon tan hilay kawkalamoan na. ");
INSERT INTO xsb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hin na-kit la ya, wanla, “Halban tawo ay ampaningkap komo.” ");
INSERT INTO xsb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kot wani Jesus konla, “Kailangan mako tamoy na ha lawlaloman logar pigaw makapangaral akoy namaot itaw ta ya-rin a bara-nan no anongkot nako ko iti.” ");
INSERT INTO xsb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kanya nako hila ni Jesus ha halban lawlogar nin probinsyan Galilea ta nangaral ya ha sawsinagoga itaw tan nama-palayah yan dawdoka a ispirito ha tawtawon nangalolooban. ");
INSERT INTO xsb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Main a-say lalakin main masakit kitong a nako koni Jesus nin ampasi-singa-ro. Nanalimokor ya, ta wana koni Jesus, “No labayon mo, ma-paabig mo ko.” ");
INSERT INTO xsb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nadabo a inganga-ro ni Jesus, kanya imparna nay gamot na konan lalaki, bi-sa wana, “Labay ko. Omabig kay na!” ");
INSERT INTO xsb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pa-makahalita nadti, antimano inomabig yay lalaki ta nilominis anay lalaman na. ");
INSERT INTO xsb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bi-sa tampol na yan pinaalih ni Jesus, kot pinaka-bibilinan na ya yapon. ");
INSERT INTO xsb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Wana, “Ando mo iba-balita odti ha hinoman, nokay magdiritso ka ha pari ha Jerusalem ta hiyay dapat mamaptog a inomabig kay na. Mangawit kan ida-ton mo para ha sirimonyan pa-manglinis ayon ha impanogo ni Moises, pamilbian lan tawtawo a talagan labah kay na.” ");
INSERT INTO xsb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Inomalih yay naor, balo ta tinomala ya ta imba-balita na ha tawtawo ha lawlogar yay pa-maabig ni Jesus kona anggan nibantog ana ingat. Kanya kay yay na basta-basta maka-ka hi Jesus ha mismon bawbabali bana ha kalakan tawon ampako kona. Nokay iti ya tana ha lawlogar a ambo matawo. Kot angkaon la ya ot syimpri nin tawtawo a ibat ha halban lawlogar. ");
INSERT INTO xsb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pa-makalabah nin omnoy awlo, norong hi Jesus ha babalin Capernaum. Nibantog a norong yay na. ");
INSERT INTO xsb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Antimano, kalakan tawon nititipon anaman, kanya homin anan maodongan maskin ha likol nin poltan bali. Hin ya-rin a ampangaral hi Jesus nin Halita nan Dios, ");
INSERT INTO xsb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","main nakalato a-pat a lalaki, awit lay a-say paralitiko nin iti ha an-iraan na. ");
INSERT INTO xsb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hin kay hila makadani koni Jesus bana ha kalakan tawo, noli hila ha bobongan ta nilobtan la ha tobon ni Jesus. Bi-sa, in-ogoh lay paralitiko nin iti ha an-iraan na. ");
INSERT INTO xsb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hin na-kit ni Jesus a main lan katotpol, wana konan paralitiko, “Talakaka, pinatawad koy nay kawkasalanan mo.” ");
INSERT INTO xsb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hin ya-rin ay main nakatoklo itaw nin mawmaistron kapanogoan a nakalngo ha hinalita ni Jesus, kanya wanla ha lalo nakom la, ");
INSERT INTO xsb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Anongkot ampanalita yan anorin yadtin tawo? An-ipantay nay sarili na ha Dios, anta Dios bongat a ampaka-patawad nin kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kot tanda ni Jesus a laman isip la, kanya antimano wana konla, “Anongkot anorin a an-isipon moyo? ");
INSERT INTO xsb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Anya kot yay mas maganoh gaw-on maskin homin kapangyarian, yay halitaon konan paralitiko, ‘Pinatawad koy nay kawkasalanan mo,’ o yay halitaon kona, ‘Mibangon ka, kowon moy an-iraan mo ta lomalako ka’? ");
INSERT INTO xsb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ipa-kit ko komoyo hawanin ha pa-maabig ko konan yadtin tawo, a hiko a Naglalaman Tawo ay main akoy namaot kapangyarian magpatawad nin kawkasalanan iti ha lota.” Bi-sa wana konan paralitiko, ");
INSERT INTO xsb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“An-imanda ko komo: Mibangon ka, kowon moy an-iraan mo ta morong kay na.” ");
INSERT INTO xsb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Antimano, nibangon yay naor. Bi-sa kinwa nay iniraan na ta inomalih ya nin na-kit la yan halban. Naka-ngap hilay halban itaw ta bi-sa dinayaw la yay Dios. Wanla, “Nika-ka-noman ay kay kami ot naka-kit nin bilang anorin.” ");
INSERT INTO xsb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Hawanin, nilomikol hi Jesus ha bali ta nako yay naman ha liglig alindayat. Hay kalakan tawon ni-pako kona, kanya tinoroan na hila. ");
INSERT INTO xsb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hin nagpatoloy yan nilomalako, main yan na-kit a-say ma-ni-non bowis a hi Levi a anak ni Alfeo. Itaw ya antoklo ha opisina a ampamayaran bowis. Wani Jesus kona, “Homonol ka kongko.” Inomdong yay naor hi Levi, bi-sa paibat hin ya-rin, hinomonol yay na kona. ");
INSERT INTO xsb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hin itaw hila ni Jesus tan hilay laloma ot a dawdisipolos na ha bali ni Levi nin ampangan, kalakan ma-ni-non bowis a mangahaol, tan laloma ot a tawtawon makasalanan a nakirongo konlan nangan. Nga-min, kalakan anan mato-totombok koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hawanin, main anamaot itaw nin mawmaistron kapanogoan tan paw-Pariseo. Hin na-kit la a ampakirongo yan mangan hi Jesus ha tawtawon makasalanan tan konlan ma-ni-non bowis a mangahaol, wanla konlan dawdisipolos na, “Anongkot ampakirongo yan mangan konlan ma-ni-non bowis tan laloma ot a tawtawon makasalanan?” ");
INSERT INTO xsb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hin nalngo ni Jesus ya-rin imbalita la, wanan in-alimbawa konla, “Ambo hilay mawmaligsa a ampangailangan nin doktor, nokay hilay mawmain masakit. Anorin kapara kongko, yay pa-mako ko iti ay ambo para ha-wayan hilay hay wanla lawlabah hilan tawo, nokay para paombabalyon hilay mawmakasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ninghan, hilay antoroan ni Juan Bautista tan hilay antoroan lan paw-Pariseo ay ampagsakripisyon kay mangan. Hawanin, main tawtawon dinomani koni Jesus ta pinastang la ya. Wanla, “Hilay antoroan ni Juan tan hilay antoroan lan paw-Pariseo ay main hilan awlon ampagsakripisyon kay mangan. Anongkot hilay dawdisipolos mo homin?” ");
INSERT INTO xsb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Inobat na hila ni Jesus nin in-alimbawa nay sarili na ha a-say nobyo, wana, “Maari doman a hilay kombidado ha kahal ay magsakripisyon kay mangan lo-gan kalamoan la yay nobyo? Kay hila maari magsakripisyon kay mangan lo-gan kalamoan la yay nobyo. ");
INSERT INTO xsb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Balo ta lomato yay panaon a ambo la yay nan kalamoan, ison hilay na magsakripisyon kay mangan.” ");
INSERT INTO xsb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bi-sa imparalan ni Jesus ha aw-alimbawa, a yay ba-yon totoro na ay ambo dapat ilamo ha naiknawan a kaogalian nin rilihyon, a bilang ha pa-magsakripisyon kay mangan tan laloma ot, ta wana, “Kay antalo-noban a lapok anan ayhing nin ba-yon ritaso a kay ot kinomo-tot. Ta no gaw-on orin, kako-ko-tot nan ba-yon ritaso, mabira yay pinanalo-noban, magi-nit anaman nin mas grabi na ingat. ");
INSERT INTO xsb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Anorin anamaot kapara, kay an-igwa a ba-yon alak a ampag-alsa ot ha pamigwaan a lapok a katat. Ta no anorin a gaw-on, ha kaaalsa nan alak ay lomtoh yay pinamigwaan, masayang yay alak tan yay pinamigwaan. Kailangan yay ba-yon alak a ampag-alsa ot ay itobong ha ba-yon pamigwaan.” ");
INSERT INTO xsb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ninghan, a-say Awlon Pa-mainawa nin aw-Israelita, nagpa-wan hi Jesus tan hilay dawdisipolos na ha bowat. Lolog hilan anlalako, na-nangto hilay dawdisipolos na nin trigo, bi-sa la kinan. ");
INSERT INTO xsb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Main itaw paw-Pariseo a naka-kit konla, kanya wanla koni Jesus, “O, bilyon mo! Anongkot anggaw-on la-rin nin dawdisipolos mo, anta ayon ha kawkapanogoan nan Dios ay bawal orin ha Awlon Pa-mainawa ta an-itoring trabaho?” ");
INSERT INTO xsb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kot wanan in-obat ni Jesus konla, “Ambo doman nabasa moyodtaw ginwa ni David tan hilay kawkalamoan na hin mabitil hilay na tan homin ma-kan? ");
INSERT INTO xsb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ambo doman nako hi David ha impagka-bali nan Dios hin hi Abiatar a pinakapoon pari? Bi-sa binyan na ya ni Pari Abiatar nin tinapay a inda-ton ha Dios. Kanya nangan ya pati hilay kawkalamoan na, anta bawal komon ayon ha kawkapanogoan nan Dios a kanon ladtaw, bana ta para bongat ha pawpari.” ");
INSERT INTO xsb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bi-sa wani Jesus konla, “Inmanda nan Dios a main Awlon Pa-mainawa para ha ikaabig nin tawo. Kay na pinalsay tawo para bongat main homonol ha Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kanya, hiko a Naglalaman Tawo a makaolay, no anyay dapat tan ambo dapat gaw-on maskin ha Awlon Pa-mainawa.” ");
INSERT INTO xsb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bi-sa nako yay naman hi Jesus ha sinagoga. Main a-say lalaki itaw a paralitikoy a-say gamot. ");
INSERT INTO xsb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hilay paw-Pariseo a ampakisimbay namaot itaw ay amba-bantayan la hi Jesus, para biliwon no paabigon na ya konan ya-rin Awlon Pa-mainawa, pigaw ma-kasowan la ya. ");
INSERT INTO xsb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wani Jesus konan ya-rin lalakin paralitikoy gamot, “Mako ka pa-ti.” Nako yay naor. ");
INSERT INTO xsb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bi-sa wani Jesus konlan tawtawo itaw, “Anyay dapat gaw-on ha Awlon Pa-mainawa ayon ha kawkapanogoan nan Dios, gomawa labah o gomawa doka? Mamilipyas biyay o mangmati?” Kot kay hila tinomlok. ");
INSERT INTO xsb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bana ha katiboyan pa-magnanakom lan paw-Pariseo, nilomolo hi Jesus. Hawanin, hinilap na hilan main awit hobhob, bi-sa wana konan lalakin paralitikoy gamot, “Ipa-nat moy gamot mo.” Impa-nat nay naor, kanya antimano inomabig a gamot na ta nag-in ana nin bilang ha dobali. ");
INSERT INTO xsb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nilomikol hilay paw-Pariseo ta tampol hilan nako konlan maka-Ari Herodes Antipas, ta naki-sabwatan no pa-no maipapati hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hawanin, inomalih hi Jesus tan hilay dawdisipolos na itaw ha sinagoga ta nako hila ha liglig alindayat. Golpin tawon ibat anamaot itaw ha probinsyan Galilea a tinomombok koni Jesus. Bi-sa lako ot a tawtawon nako kona a ibat ha probinsyan Judea, ");
INSERT INTO xsb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pati ha syodad Jerusalem, ibat ha probinsyan Idumea, ibat ha dobali nin Kabatwan Jordan tan ibat ha ka-libol nin loway syodad Tiro tan Sidon. Golpi hila-rin a nako koni Jesus ta na-balitaan lay halban gawgawa na. ");
INSERT INTO xsb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kanya namaparihado hi Jesus konlan dawdisipolos na nin baloto para ma-tokloan na, pigaw kay ya ma-pitpit nin kalakan tawon ampako kona. ");
INSERT INTO xsb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nga-min, lako anay pinaabig nan main masakit, kanya ampipapalotpotan la yan halban main masakit pigaw maaptoh la ya. ");
INSERT INTO xsb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","No ma-kit lay namaot hi Jesus nin hiladtaw nilooban dawdoka a ispirito ay anlomokob hila ha arapan na tan an-omaghaw. Wanla, “Hika yay Anak nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kot mahigpit na hilan binawalan ni Jesus a ando la iba-balita no hino ya, ta kay na labay a hilay doka a ispirito a mamipatanda a hiya kot Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A-say awlo, hinomaka hi Jesus ha a-say babo. Bi-sa hina-wayan na hilay labay nan domani kona, kanya dinomani hila. ");
INSERT INTO xsb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Namili yan labinlowa konla a hina-wayan nan aw-apostolis. Pinili na hila para ipagkalamoan na tan para ihogo nin mangaral. ");
INSERT INTO xsb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bi-sa binyan na hilan kapangyarian mamaabig mawmasakit tan mamalayah dawdoka a ispirito konlan tawtawon nilooban. ");
INSERT INTO xsb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hiladti yay labinloway apostolis a pinili na: hi Simon a pinangalanan nan Pedro, ");
INSERT INTO xsb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","hilay mitalakakan Santiago tan Juan a awa-nak ni Zebedeo (hilay binanhagan nan Boanerges, labay totolon “Tawon Korol”, ta ma-ngasolong hila), ");
INSERT INTO xsb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","hi Andres, hi Felipe, hi Bartolome, hi Mateo, hi Tomas, hi Santiago a anak ni Alfeo, hi Tadeo, hi Simon a mainakit ha nasyon Israel, ");
INSERT INTO xsb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tan hi Judas Iscariote a nagtraidor koni Jesus. Bi-sa nilomoob hi Jesus ha a-say bali pati hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nititipon anaman itaw a malabong a tawo, kanya kay lay na maarap mangan. ");
INSERT INTO xsb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hin na-tandaan ladti nin ka-pamilya ni Jesus, kina la ya para paorongon ta main ampanalita a ambo ana kanon matino a isip na. ");
INSERT INTO xsb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Main namaot nin mawmaistron kapanogoan a ibat ha syodad Jerusalem, a wanla, “Nilooban na ya ni Satanas a poon lan dawdoka a ispirito, tan hiya a nami kona nin kapangyarian para mamalayah nin dawdoka a ispirito.” ");
INSERT INTO xsb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kanya pinadani na hila ni Jesus ta imparalan na ha aw-alimbawa a obat na konla. Wana, “Palayahon na wari ni Satanas a kapara nan doka a ispirito? ");
INSERT INTO xsb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Alimbawa, no yay a-say kaarian ta hila-hila ot a ampikokontra, kay bomoyot ya-rin kaarian. ");
INSERT INTO xsb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Anorin anamaot kapara ha a-say pamilya, no hila-hila ot a ampikokontra, kay bomoyot orin a pamilya. ");
INSERT INTO xsb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kanya, no wari ta potog a angkalabanon ni Satanas a kapara nan doka a ispirito ta kay hilay na ampanga-piasa-sa, kay ya bomoyot ta manganggawan yay na. ");
INSERT INTO xsb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kot hi Satanas ay bilang a-say tawon makhaw a kailangan balolon yapon, bi-sa makaloob ha bali na pigaw ma-hamham a main nan kama-main. Kanya mapatnag a tinalo koy na hi Satanas ta angka-palayah koy dawdoka a ispirito a kampon na. ");
INSERT INTO xsb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yay potog, ibalita ko komoyo, ma-patawad a tawo ha halban klasin kawkasalanan tan anyakaman a pa-maroroka ha kapara. ");
INSERT INTO xsb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kot hinoman a ampamaroroka ha Masanton Ispirito nan Dios ay kay ma-patawad ta kasalanan yadti nin homin anggawan a parosa,” wani Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nga-min, ha pa-nalita lan mawmaistron kapanogoan a nilooban yan doka a ispirito hi Jesus, pinaroroka lay Masanton Ispirito nan Dios a nami kona nin kapangyarian. ");
INSERT INTO xsb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lo-gan ampangaral hi Jesus, nilomato a nanay na tan tawtalakaka nan lalaki. Itaw hila an-omdong ha likol bali ta impaha-wayan la tana hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hin ya-rin ay lako a tawon nakatoklo ha ka-libol ni Jesus. Kanya wanla kona, “Ison kano ha likol yay nanay tan tawtalakaka mo. Antingkapon la ka.” ");
INSERT INTO xsb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wanan in-obat ni Jesus, “Tanda moyo doman no hino-hinoy an-itoring kon nanay tan tawtalakaka?” ");
INSERT INTO xsb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bi-sa hinilap na hilay tawtawon antoklo ha ka-libol na, ta wana, “Hikamoy an-itoring kon nanay tan tawtalakaka. ");
INSERT INTO xsb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nga-min, hinoman a anhomonol ha kalabayan nan Dios ay an-itoring kon tawtalakaka tan nanay.” ");
INSERT INTO xsb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ninghan, itaw hi Jesus ha liglig alindayat ta mag-ompisa yay naman mangaral. Pinititiponan la yan malabong a tawtawo, kanya nako ya tinomoklo ha baloto a itaw ha lanom. Kot yay intiron kalabongan ay iti ha liglig. ");
INSERT INTO xsb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bi-sa tinoroan na hilan lako a bawbagay a imparalan na ha aw-alimbawa. Ha pa-noro na, wana, ");
INSERT INTO xsb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Long-on moyodti: Main a-say tawon nako nanabwag bini. ");
INSERT INTO xsb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ha pa-nabwag na, main bini a ni-ka ha dalan. Na-romogan lan mawmanok-manok, kanya na-min lan kinan. ");
INSERT INTO xsb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Main anamaot ni-ka ha logar a mabato a maimpih bongat a lota, bi-sa tampol tinomobo palibhasay maimpih anaor a lota. ");
INSERT INTO xsb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kot hin ma-mot anay awlo, nalanoh tan toloy nati ta kay nakapangyamot labah. ");
INSERT INTO xsb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Main anamaot ni-ka ha logar a antoboan dawdikot a marowih. Kato-tobo nan bini, nagsalidan tinomobo anamaot a dawdikot, kanya kay nakaaliwahwah tan toloy kay nakapamonga. ");
INSERT INTO xsb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Balo ta yay bini a nadabo ha magandan lota ay nilomhik, nagsalidan tinomobo bi-sa ni-pamonga. Main namongan tolompolo, main a-nom a polo, tan main anamaot sanyatos.” ");
INSERT INTO xsb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bi-sa wana ot ni Jesus konla, “Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hin kay hilay na itaw a tawtawo, pinastang hi Jesus nin hilay labinloway apostolis na tan hilay laloma ot a kawkalamoan na, tongkol ha inimbi nan aw-alimbawa. ");
INSERT INTO xsb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kanya wana konla, “Komoyon bongat an-ipaintindyan a sawsikrito tongkol ha pa-mag-ari nan Dios. Kot konlan kay ambomilbi kongko, halban bagay a an-itoro konla ay an-iparalan ha aw-alimbawa. ");
INSERT INTO xsb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kanya ampomtog odtin nakasolat a wanan Dios: ‘Mamiliw hila man anan mamiliw kot kay la maintindyan a angka-kit la, tan manglongo hila man anan manglongo kot kay la maintindyan a angkalngo la. No komon ta ambo hilan anorin, mangombabali hila tan magbolta kongko ta ma-patawad ko a main lan kawkasalanan.’” ");
INSERT INTO xsb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bi-sa wani Jesus konla, “Kay moyoy namaot payti naintindyan yadtaw alimbawa! Pa-no moyo man no-nin maintindyan a laloma ot a aw-alimbawa? ");
INSERT INTO xsb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Oyay labay totolon nin yadtaw alimbawa: Yay bini a inhabwag nan ma-malbwat ay Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yay dalan a pini-kaan nin bini ay tawtawon ampanglongo Halita nan Dios, balo ta tampol anlomato hi Satanas ta an-alihon na ha main lan kanakoman yay Halita a nalngo la. ");
INSERT INTO xsb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Yay lota a mabato a pini-kaan nin bini ay tawtawon ampanglongo Halita nan Dios, bi-sa tampol lan ampi-polon odti nin main kaligawan. ");
INSERT INTO xsb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kot pa-hal kay ampakapangyamot odti ha nakom la. Antompol hila kot kado-domali bongat ta no ma-pairapan hila, tan ma-damsak bana ha kaho-honol la ha Halita nan Dios ay tampol hilan antomgon. ");
INSERT INTO xsb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Yay lota a antoboan dawdikot a marowih a pini-kaan nin bini ay tawtawon ampanglongo Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Balo ta angkadaog yay Halita nan Dios a nalngo la, bana ta ampag-aboridowan lay kabi-biyay iti ha mondo, mailig hila ha kayamanan, tan an-omapos ha lawlaloma ot a bawbagay. Kanya yay angkalngo la ay kay ampamongan lawlabah a gawa ha main lan biyay. ");
INSERT INTO xsb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Kot yay magandan lota a pinanabwagan bini ay hiladtaw ampanglongo tan ampananggap nin Halita nan Dios. Kanya yay nalngo la ay ampamongan lawlabah a gawa ha main lan biyay. Main konla a yay lawlabah a gawa la ay maiparis ha tolompolo a bonga, main anamaot maiparis ha a-nom a polo, tan main maiparis ha sanyatos.” ");
INSERT INTO xsb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Bi-sa nami yay naman hi Jesus nin a-say alimbawa, wana, “Ampartawan wari a lamparilya para hakban alimbawa nin halop, o kari igwa ha hilong katri? Ambo doman an-igwa odti ha dapat pamigwaan? ");
INSERT INTO xsb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anorin anamaot kapara ha pa-mag-ari nan Dios, homin nakaari a kay ma-tandaan tan homin sikrito a kay mibolgar. ");
INSERT INTO xsb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hikamoy ampakalngo, intindyon moyoy nalngo moyo!” ");
INSERT INTO xsb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bi-sa wana ot ni Jesus, “Paka-long-on moyon labah a anhalitaon ko. Nga-min, no manglongo kamon labah, lako a ma-tandaan moyo ta bi-sa pa-lahan na ot orin nin Dios. ");
INSERT INTO xsb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nga-min, hinoman a main anan na-tandaan ay pa-lahan ot orin. Kot hinoman a kay ampama-lah ha main nan tanda, maskin yay dati nan tanda ay alihon ot kona.” ");
INSERT INTO xsb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wana ot in-alimbawa ni Jesus, “Yay pa-mag-ari nan Dios ay bilang ha bini trigo a an-ihabwag nin a-say lalaki ha bowat. ");
INSERT INTO xsb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pa-makayari, morong yay lalaki ha bali, ta ma-lok ya no yabi, bi-sa mibangon yan magtrabaho no awlo. Yay bini ay bastay nan bongat lomhik tan tomobo nin kay na tanda no pa-no. ");
INSERT INTO xsb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yay lota a ampamatobo ha bini. Primiro, lomhik yay bini, bi-sa mamolong anggan mamongay na. ");
INSERT INTO xsb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No mangaloto anay bonga, tampol nay nan ipagapas, ta panaon anan lapton.” ");
INSERT INTO xsb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wanay naman ni Jesus, “Ayti tamo ot maiparis a pa-mag-ari nan Dios, o anya ot a maari tamon pamialimbawaan? ");
INSERT INTO xsb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oya: Yay ompisan pa-mag-ari nan Dios ay bilang ha a-say botol mostasa. Yadti yay pinakamakalog a botol tanaman a an-imola. ");
INSERT INTO xsb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Balo ta no naimolay na bi-sa tinomobo, mag-in yan pinakamahi-ban ha halban klasin pawpihing, tan magkamain mawmahi-ban a hanga a ma-panalayan nin mawmanok-manok.” ");
INSERT INTO xsb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lako a aw-alimbawa a bilang ha anorin a ginamit ni Jesus ha pangangaral na nin Halita nan Dios, ayon ha kababaan nin pangingintindi lan tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kay na hila tinoroan a tawtawo nin kay na imparalan ha aw-alimbawa. Kot no hila-hila tana nin dawdisipolos na ay an-ipalino nay halban konla. ");
INSERT INTO xsb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hin bandan yabi na, wani Jesus konlan dawdisipolos na, “Lomipay tamo ha alindayat.” ");
INSERT INTO xsb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kanya imbati lay tawtawo, bi-sa nilomolan hila ha baloto a anlolanan ni Jesus ta nilomipay hila. Main anamaot nin lawlaloman tawo a nakabaloto a naki-ka konla. ");
INSERT INTO xsb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na-palatan hilan makhaw a lopot ha taaw, kanya angka-hapwakan nin alon a lalo nin baloto la anggan halos mapno anan lanom. ");
INSERT INTO xsb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kot hi Jesus ay angka-lok nin nakaalonan itaw ha hoyotan nin baloto. Kanya pinokaw la ya, wanla, “Maistro, homin doman kwinta komo a lomdog tamoy na?” ");
INSERT INTO xsb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nimata hi Jesus, bi-sa minandawan nay makhaw a lopot, wana, “Tomgon ka!” Bi-sa wana ha lanom, “Lominak ka!” Kanya tinomgon a lopot tan nilominak a lanom. ");
INSERT INTO xsb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bi-sa wana konlan dawdisipolos na, “Anongkot angkali-mo kamo? Homin kamo ot doman pa-masimala?” ");
INSERT INTO xsb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ambo makano-kanoy pa-mag-ispanta la. Kanya wanla ha a-sa tan a-sa, “Anya kari magklasin tawo yadti ta maskin lopot tan alon kot anhomonol kona?” ");
INSERT INTO xsb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pa-makalipay la ni Jesus ha alindayat ay logar lay nan Gadareno. ");
INSERT INTO xsb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hin nilomakah yay na hi Jesus ha baloto, tongwa main a-say lalakin nilooban doka a ispirito a anhomakbat kona ibat ha kamposanto. ");
INSERT INTO xsb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Itaw yay na ampagpirmi ha kamposanto. Kay la ya mabalol nin tawtawo, maskin tikala a ipamalol kona. ");
INSERT INTO xsb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nga-min, ni-no ni-no la yay nan binalol nin tikala ha gamot tan ayi, kot ambo-boytoon nan bongat, kanya homin makasopil kona. ");
INSERT INTO xsb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Awlo-yabi yan ampila-lalako ha kamposanto tan ha bawbakil nin ampibo-bolyaw, bi-sa anhogat-hogaton na ot a lalaman na nin bawbato. ");
INSERT INTO xsb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pa-makatamolaw na koni Jesus, nolayo yan hinomakbat, bi-sa nanalimokor yan palokob kona. ");
INSERT INTO xsb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wanan imbolyaw a impahalita nan doka a ispirito, “Jesus, Anak nin sangkata-ta-gayan a Dios, anongkot ampakiomonan mo ko? Alang-alang konan Dios, ando mo ko padya-dyaon.” ");
INSERT INTO xsb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hinalita nadti bana ta minandawan nay na ni Jesus yay doka a ispirito, a wana, “Omalih ka kona, hika a doka a ispirito!” ");
INSERT INTO xsb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bi-sa pinastang ni Jesus yay doka a ispirito, wana, “Anyay ngalan mo?” Wanan in-obat nan doka a ispirito, “Yay ngalan ko ay Malabong bana ta lako kami.” ");
INSERT INTO xsb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bi-sa nagpasi-singa-ro yan hosto koni Jesus a ando na hila palayahon konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hin ya-rin ay main itaw malabong a baboy a ampangkob ha liglig bakil. ");
INSERT INTO xsb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kanya halban lan dawdoka a ispirito a nilomoob konan lalaki ay nagpasi-singa-ro koni Jesus. Wanla, “Pa-kaon mo kami tana konlan hila-rin bawbaboy, pigaw makaloob kami konla.” ");
INSERT INTO xsb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kanya antimano pinayagan na hila ni Jesus. Inomalih hilay naor a dawdoka a ispirito konan lalaki ta nilomoob konlan bawbaboy. Tongwa, halban lan baboy a manga lowanlibo ay bigla nipo-polayon paloyhon ha bongaw diritson alindayat, kanya ni-ka-lilimoh hila. ");
INSERT INTO xsb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hawanin, hilay ma-magbantay konlan bawbaboy ay nolayon nako ha babali tan ha bawbaryo ta imba-balita lay nangyari. Kanya ni-pako hilay naka-balita para biliwon no anya talagay nangyari. ");
INSERT INTO xsb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pa-makalato la ha kamainan ni Jesus, na-kit la yadtaw lalakin pinamalayahan nin lako a dawdoka a ispirito a antoklo nin nakaayhing ana ta norong anay sintido na. Nali-mo hila. ");
INSERT INTO xsb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hiladtaw mismon naka-kit ha nangyari a namibalita konlan nakalato, no pa-no na-paabig yay lalakin nilooban nin dawdoka a ispirito tan no anyay nangyari konlan bawbaboy. ");
INSERT INTO xsb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kanya hilay tawtaga itaw ay impaki-totol la koni Jesus a omalih yay na ha logar la. ");
INSERT INTO xsb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hin lomolan hilay na ha baloto, impaki-totol nan tawon pinamalayahan nin dawdoka a ispirito a maki-ka yay namaot koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kot kay na ya pinayagan ni Jesus ta wana kona, “Morong ka komoyo, ta ibalita mo yay ka-paka-ngap a ginwa nan Katawan komo tan yay inganga-ro na komo.” ");
INSERT INTO xsb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kanya nako yay na ta imba-balita na ha intiron kahakopan nin Mapolo a Babali a anha-wayan “Decapolis” yay ka-paka-ngap a ginwa ni Jesus kona. Hilay halban naka-balita ay ni-paka-ngap. ");
INSERT INTO xsb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nilomolan hila ni Jesus ha baloto ta nilomipay oman ha alindayat. Pa-makalato la ha dobali ay piniroropongan la yay naman nin kalakan tawo ha liglig alindayat. ");
INSERT INTO xsb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tongwa, main nakalato a-say ampamoon ha sinagoga a yay ngalan na kot Jairo. Hin na-kit na hi Jesus, nanalimokor yan palokob ha danin ayi na, ");
INSERT INTO xsb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ta nagpasi-singa-ro ya, wana, “Mati yay nay anak kon dalagita. Maki-ka ka pa kongko ta iparna moy gamot mo kona pigaw omabig ya tan mabyay ot.” ");
INSERT INTO xsb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Naki-ka hi Jesus kona, ta bi-sa kalakan tawon nakiaaloyon nin ampipoporpor kona. ");
INSERT INTO xsb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Hin ya-rin ay main anamaot a-say babayin labinloway taon anan andayaon a nakito-tombok koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ha kalakan anan mawma-nambal a kina-kina na ay masyado yay nan na-padya-dyaan tan na-min anay kawkama-main na. Kot kay la ya syimpri na-paabig, nokay masbali naloor ana ingat. ");
INSERT INTO xsb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hin na-tandaan nay gawgawa ni Jesus, nakipo-porpor ya konlan malabong a tawtawo, anggan inomabot ya ha bokotan ni Jesus. Bi-sa kinowit nay ayhing na. ");
INSERT INTO xsb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nga-min, wana ha sarili na, “Ma-kowit ko tanay ayhing na ay omabig akoy na.” ");
INSERT INTO xsb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pa-maka-kowit na, antimano tinomgon a kada-daya na. Nalayam na a inomabig yay na ha masakit na. ");
INSERT INTO xsb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nalayam nay namaot ni Jesus a main nilomwah kapangyarian na. Kanya antimano binomling ya ta inomarap ya ha tawtawon an-omaloyon kona, ta pinastang na hila. Wana, “Hinoy nangowit ayhing ko?” ");
INSERT INTO xsb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kot wanlan dawdisipolos na, “Ampipoporporan la kan malabong a tawtawo, bi-sa pastangon mo no hinoy nangowit komo.” ");
INSERT INTO xsb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kot nagpatoloy yan hinomilap hi Jesus ta biniliw na no hino. ");
INSERT INTO xsb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yadtaw babayi, palibhasay tanda nay nangyari, dinomani ya koni Jesus nin anggoygoy ha li-mo. Bi-sa nanalimokor yan palokob ta imbalita na konay halban potog a nangyari. ");
INSERT INTO xsb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kanya wani Jesus kona, “Talakaka ko, inomabig ka bana ha main mon katotpol. Morong kay nan malisway a nakom ta inomabig kay na ha main mon masakit.” ");
INSERT INTO xsb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lo-gan na ot ampanalita ni Jesus, main nakalato ibat ha bali ni Jairo. Wanla koni Jairo, “Ando moy na abalaon yay Maistro ta nakihiyay yay nay anak mo.” ");
INSERT INTO xsb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pa-makalngo ni Jesus ha hinalita la, wana koni Jairo, “Ando ka mahalak, basta pasimala ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bi-sa homin yan laloman pinayagan maki-ka kona, no ambo hi Pedro tan hilay mitalakakan Santiago tan Juan bongat. ");
INSERT INTO xsb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hin nakalato hila ha bali ni Jairo, na-kit lan golo-goloy tawtawo itaw, ta main ampi-pagtomangih tan main anamaot ampiaanito. ");
INSERT INTO xsb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pa-makaloob ni Jesus, wana konla, “Anongkot ampagkagolo kamo tan ampi-pagtomangih? Kay ya nati ya-rin a anak, nokay angka-lok yan bongat.” ");
INSERT INTO xsb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kot kinaka-lihan la hi Jesus. Balo ta pinalikol na hilay halban, ta hilan bongat a tatay tan nanay nan anak, tan hilay dawdisipolos a kalamo na a pinaki-ka nan lomoob ha kamainan nan anak. ");
INSERT INTO xsb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bi-sa ginawang ni Jesus a gamot nan anak, ta wana kona, “Talita, kumi.” yay labay totolon, “Nini, an-imanda ko komo, mibangon ka.” ");
INSERT INTO xsb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tampol yan nibangon bi-sa nilomalako. (Yay idad nan anak ay labinloway taon.) Ambo makano-kanoy pa-mag-ispanta lan hilay naka-kit. ");
INSERT INTO xsb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kot impaka-bibilin ni Jesus konla a ando ladti iba-balita ha hinoman. Bi-sa imbalita na ot konla a biyan lan pa-mangan a anak. ");
INSERT INTO xsb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Hawanin, inomalih yay na hi Jesus konan ya-rin a logar ta norong ya ha Nazaret a sarili nan babali. Naki-ka anamaot kona hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pa-makalato nin Awlon Pa-mainawa ay nangaral hi Jesus ha sinagoga. Lako konlan nakalngo kona a naka-ngap, wanla, “Ayti na kari na-tandaan ya-rin halban? Anyay klasin karonongan odtin inimbi kona ta ampakagawa yan gawgawa a pamilbian ambo bastan kapangyarian? ");
INSERT INTO xsb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ambo doman ya-rin yay karpintiron anak ni Maria tan talakaka ni Santiago, ni Jose, ni Judas tan ni Simon? Ambo doman iti kontamo hilay tawtalakaka nan babayi?” Hinalita la-rin bana ta nasora hila kona. ");
INSERT INTO xsb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanya wani Jesus konla, “Yay a-say propita ay an-igalang maskin ayti, poyra ha sarili nan logar, ha kawkanayon na tan ha sarili nan bali.” ");
INSERT INTO xsb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Halos homin yan nagawa hi Jesus itaw konla nin gawgawa a pamilbian ambo bastan kapangyarian nan Dios. Nokay main bongat omnoy tawo itaw a imparna nay gamot na konla ta pinaabig na hila. ");
INSERT INTO xsb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nag-ispanta ya bana ta kay tinompol kona hilay ka-babali na. Hawanin, kina-kina ni Jesus a bawbaryo itaw ta nangaral. ");
INSERT INTO xsb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bi-sa hina-wayan na hilay labinloway apostolis na ta inhogo na hilay nan lowa-lowa para mangaral anamaot, tan binyan na hilan kapangyarian mamalayah dawdoka a ispirito a nilomoob ha tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Binibilinan na hila yapon, wana, “Ha pa-mako moyo, ando kamoy na mangawit nin anyakaman poyra ha baston moyo. Ni pa-mangan, bag o kwarta ay ando kamo mangawit. ");
INSERT INTO xsb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kot mag-apin kamo tan ando kamoy na mangawit risirban ayhing.” ");
INSERT INTO xsb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wana ot, “Ha aytimay bali a ma-pakihandaan moyo ay itaw kamo tana anggan omalih kamo konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kot no main kay labay mananggap komoyo tan kay labay manglongo, omalih kamo ha logar la. Oltimon gabok ha ayi moyo ay pagpagon moyo. Yay potog, ibalita ko komoyo, ha awlon pangongokom ay mas mabyat a parosa nan Dios konlan tawtawo ha anorin a klasin babali, dinan konlan taga Sodoma tan taga Gomorra a bantog ha main lan karokaan hin yadtaw.” ");
INSERT INTO xsb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kanya ni-pako hilay na ta ni-pangaral ha tawtawo a pangombabalyan tan bokotan lay dawdoka a gawa la. ");
INSERT INTO xsb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nama-palayah hilay namaot nin lako a dawdoka a ispirito konlan nangalolooban tan nilanawan lay lako a tawon mawmain masakit ta pinaabig hila. ");
INSERT INTO xsb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na-tandaan ni Ari Herodes Antipas yay tongkol koni Jesus ta nibantog yay na bana ha gawgawa na. Main ampanalita a “Hiya hi Juan Bautista a pinaorong nabyay, kanya main yan kapangyarian gomwa nin ka-paka-ngap a bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wanlay namaot laloma, “Hiya hi Elias a propita nan Dios hin yadtaw.” Wanla ot laloma, “A-sa yan propita nan Dios a bilang hin o-na.” ");
INSERT INTO xsb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kot hin nalngo ni Ari Herodes Antipas odti, wana, “Hiya hi Juan a impapo-tohan kon olo a norong nabyay.” ");
INSERT INTO xsb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hinalita nadti bana ta impapati na hi Juan Bautista. Anodti a nangyari: Impadakop na ya, impabalol tan impapriso bana koni Herodias a impagkaambali na, anta kaambali ya ni Felipe a talakaka na. ");
INSERT INTO xsb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nga-min, imbalita ni Juan koni Ari Herodes Antipas hin yadtaw a ambo tama ayon ha kawkapanogoan nan Dios a an-ipagkaambali nay ayro na. ");
INSERT INTO xsb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kanya nagkamain yan hakit nakom hi Herodias koni Juan. Labay na yay na komon ipapati, balo ta kay na magawa bana ta kay na pinayagan nin ari. ");
INSERT INTO xsb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Nga-min, mata-gay a pa-migalang ni Ari Herodes Antipas koni Juan palibhasay tanda nan a-sa yan labah tan banal a tawo, kanya in-atap na ya. Kada long-on na ya, lako anamaot a anhonolon na, tan labay-labay na yan long-on. ");
INSERT INTO xsb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hin hoyot nagkamain yan tyansa hi Herodias para maipapati hi Juan. Nga-min, hin nakalato a awlon kapangabingan ni Ari Herodes Antipas, nagpahanda yan pa-mangan para konlan aw-opisyalis na, kawkapitan hondalo tan hilay mawmain ingkatawo ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bi-sa, hin nilomoob yay anak a dalaga ni Herodias ta binomayli, na-ligawan hi Ari Herodes Antipas tan hilay bawbisita na. Kanya wanan ari konan dalaga, “Makirawat kan anyakamay labay mo ta ibi ko komo!” ");
INSERT INTO xsb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bi-sa pinaghompaan na ot, wana, “Anyakamay ipakirawat mo, ibi ta ibi ko komo maski kapikna nin kaarian ko.” ");
INSERT INTO xsb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nilomikol yapo yay dalaga ta pinastang nay nanay na, “Anya may ipakirawat ko?” wana. “Yay olo ni Juan Bautista,” wanan in-obat nin nanay na. ");
INSERT INTO xsb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nangapora yan nagbolta konan ari, ta wana, “Labay ko komon a ibi mo kongko hawanin ot yay olo ni Juan Bautista nin nakaigwa ha bandihado.” ");
INSERT INTO xsb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nilomolo yan masyado a ari. Kot alang-alang ha pinaghompaan nan pangako tan ha arapan la paot nin hilay bawbisita na, kay na ya labay tanggiwan. ");
INSERT INTO xsb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kanya antimano namihogo yan a-say hondalo para kowon a olo ni Juan. Nako yay hondalo ha prisowan ta pino-tohan nan olo hi Juan. ");
INSERT INTO xsb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bi-sa inawit nay olo nin nakaigwa ha bandihado ta inimbi konan dalaga. Ba-yo inimbi nan dalaga konan nanay na. ");
INSERT INTO xsb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hin na-tandaan lan tawtinoroan ni Juan yay nangyari, kina lan kinway bangkay na ta inigwa ha pantyon. ");
INSERT INTO xsb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hilay labinloway apostolis ni Jesus ay nagbolta kona ta tinotol la konay halban ginwa la pati yay impangaral la. ");
INSERT INTO xsb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hin ya-rin, lako a tawtawon anlomato tan an-omalih, kanya ni mangan kay la maarap ni Jesus tan hilay aw-apostolis na. Kanya wani Jesus konlan aw-apostolis na, “Mako tamo nin hitamo-hitamon bongat ha a-say logar a homin tawo ta painawa kamo yapon.” ");
INSERT INTO xsb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanya nilomolan hila ha baloto nin hila-hilan bongat ta nako hila ha a-say logar a homin tawo. ");
INSERT INTO xsb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kot na-kit hila nin tawtawo hin inomalih hila tan lako a naka-bilbi kona. Kanya hilay tawtawo ha halban babali itaw ay nangaporan tinomombok koni Jesus nin nangli-liglig ha alindayat. No-na hilan nakalato itaw kanya hinakbat la yay na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pa-makalakah na ha baloto, na-kit nay golpin tawo itaw. Nadabo a inganga-ro na konla bana ta bilang hilan kawkarniro a homin pastol. Kanya tinoroan na hila nin lako a bawbagay. ");
INSERT INTO xsb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hin anyomabi na, dinomani hilay dawdisipolos na kona, ta wanla, “Homin kabali-bali iti tan madani nan domoblom. ");
INSERT INTO xsb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hapano pa-kaon mo hilay nay tawtawo ha bawbali ha ka-libol tan ha bawbaryo, pigaw makahaliw hilan ma-kan la.” ");
INSERT INTO xsb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kot wani Jesus konla, “Hikamoy nay mamin pa-mangan la.” Wanlan in-obat nin hilay disipolos na, “Pa-no kami man makahaliw nin tinapay ha alagan opa nin a-say tawo ha lowanyatos a awlo ta bi-sa ipapangan konla?” ");
INSERT INTO xsb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wani Jesus konla, “Omno ot a tinapay ison komoyo? Bilyon moyo pa.” Hin na-kit la, wanla koni Jesus, “Main bongat limay tinapay tan loway konâ.” ");
INSERT INTO xsb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hawanin, pinatoklo ni Jesus hilay halban tawo nin gropo-gropo ha dikot a magandan tokloan. ");
INSERT INTO xsb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kanya tinomoklo hilan gropo-gropo. Main gawgropon mananyatos a tawo tan main anamaot gawgropon hililimampolo a tawo. ");
INSERT INTO xsb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pa-makayari ay kinwa ni Jesus yay limay tinapay tan loway konâ, ta bi-sa tinomangal ya ha langit ta pinasalamatan na yay Dios. Bi-sa pini-pikna nay tinapay, ba-yo na inimbi konlan dawdisipolos na para ipapto konlan tawtawo. Anorin anamaot a ginwa na ha loway konâ. ");
INSERT INTO xsb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Halban la ay nakapangan tan ni-kabhoy. ");
INSERT INTO xsb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bi-sa, hin tinipon lan dawdisipolos ni Jesus yay ni-katla a pini-pikna nin tinapay tan konâ, nakapno hila ot nin labinloway bakol. ");
INSERT INTO xsb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yay bilang lan lawlalaki bongat a ni-pangan ay manga limanlibo. ");
INSERT INTO xsb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tampol nan pinalolan ni Jesus hilay dawdisipolos na ha baloto, ta pinao-na na hilan lomipay ha alindayat makon babalin Betsaida lo-gan na hilan ampaibwaton a tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hin na-paibwat na hilay na, hinomaka hi Jesus ha bakil para domawat ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hin anyomabi na, asa-sa na itaw ha bakil. Kot hilay dawdisipolos na a nakabaloto ay itaw hilay na ha taaw. ");
INSERT INTO xsb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na-tamolaw ni Jesus hilay dawdisipolos na a angkairapan mamoghay ta halonga hila ha lopot. Hin anhomawang ana, tinomombok hi Jesus konla nin anlalako ha babon lanom. Labahan na hila komon, ");
INSERT INTO xsb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kot hin na-kit la yan anlalako ha babon lanom, hay wanla no molto, kanya nakaaghaw hila. ");
INSERT INTO xsb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nga-min, halban la ay naka-kit kona, kanya nali-mo hilan masyado. Kot antimano nanalita hi Jesus konla, wana, “Ando kamo mali-mo ta hikodti! Pakhawon moyoy nakom moyo!” ");
INSERT INTO xsb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bi-sa nakilolan yay na konla ha baloto. Tampol tinomgon yay lopot, kanya masyado hilan naka-ngap tan nag-ispanta. ");
INSERT INTO xsb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nga-min, maskin na-kit lay milagro a nangyari ha tinapay ay kay la ot na-talosan no hino talaga hi Jesus, palibhasay kay la ot maabot isipon. ");
INSERT INTO xsb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hin nakalipay hilay na ni Jesus ta niabot ha kapatagan Genesaret, indoong lay nay baloto. ");
INSERT INTO xsb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hin nilomakah hila, antimano na-bilbi la hi Jesus nin hilay tawtawo itaw. ");
INSERT INTO xsb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kanya ni-panandali hiladtin tawtawon ni-pako ha halban ka-libol a logar ta kinwa lay mawmain masakit. Bi-sa la inawit nin iti ha main lan an-iraan ta ini-ka la koni Jesus ha aytimay na-balitaan lan kamainan na. ");
INSERT INTO xsb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kanya ayti ya man niabot hi Jesus, mag-in bawbaryo, bawbabali o bawbowat, pirmin main an-awiton a mawmain masakit ha pawplasa. An-ipasi-singa-ro la kona a maskin ma-kowit la tanay palpal ayhing na pigaw omabig hila. Kanya halban lan naka-kowit ayhing na ay inomabig. ");
INSERT INTO xsb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ninghan, main nako koni Jesus nin paw-Pariseo tan omnoy mawmaistron kapanogoan a naibat ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na-kit la a hilay laloman dawdisipolos na kot kay anhomonol ha naiknawan a totoro tongkol ha sirimonyan pa-mibano ba-yo mangan, kanya pinintasan la. ");
INSERT INTO xsb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nga-min, ogali lan paw-Pariseo tan halos halban anan aw-Israelita a gaw-on yapo a sirimonyan pa-mibano ba-yo mangan, ta anhonolon lay naiknawan a tawtotoro lan kapapo-papoan mi. ");
INSERT INTO xsb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tan no naibat hila ha palingki, kailangan mibano hila yapo ba-yo mangan. Lako ot a naiknawan lan tawtotoro a anhonolon la, bilang ha sistiman pangongoyah nin aw-ampanginoman, bawbanga tan laloma ot a ampamigaw-an a yari ha tanso, tan yay pawpapag.) ");
INSERT INTO xsb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bana ta anorin, pinastang la hi Jesus nin hilay paw-Pariseo tan mawmaistron kapanogoan, wanla, “Anongkot kay la anhonolon dawdisipolos mo yay naiknawan tamon totoro lan kapapo-papoan tamo? Ampagkasalanan hila ta ampangan hilan kay anggaw-on yay sirimonyan pa-mibano ba-yo mangan.” ");
INSERT INTO xsb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wani Jesus konla, “Mitama komoyon ma-magkonwari yay impabalita nan Dios hin yadtaw koni Propita Isaias, a wanan nakasolat, ‘Yay kaga-galang lan hiladtin tawtawo kongko ay nangangga ha halita bongat ta madayo a nakom la kongko. ");
INSERT INTO xsb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Homin anan lamang kwinta a pa-magsamba la kongko, ta yay aw-impanogo nin tawo ay an-ipangaral lan bilang aral ibat kongko.’” ");
INSERT INTO xsb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wana ot ni Jesus, “Ampo-layan moyoy kapanogoan nan Dios ta yay naiknawan moyon kaogalian a anhonolon moyo a bilang ha pangongoyah nin bawbanga tan aw-ampanginoman, tan lako ot a anggaw-on moyon anorin. ");
INSERT INTO xsb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Hay hosay moyon gomwa paralan pigaw ma-po-layan moyoy kapanogoan nan Dios, boga tanay ma-honol a naiknawan moyon kaogalian. ");
INSERT INTO xsb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Oyay kapanogoan nan Dios a imbalita ni Moises: ‘Igalang moy tatay mo tan nanay mo;’ ta bi-sa ‘Hinoman a mamaroroka ha tatay na o nanay na ay dapat yan patyon.’ ");
INSERT INTO xsb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kot hikamo, anodti an-itoro moyo, wamoyo, no main manalita ha tatay na o nanay na, a wana, ‘Yay maitambay ko komo ay intatala kon mag-in Corban’, yay labay totolon ay ‘Da-ton ha Dios’, wamoyo maari kay nay na biyan a matoantawo na. ");
INSERT INTO xsb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kanya ampayagan moyon kay yay na tomambay ha tatay o nanay na. ");
INSERT INTO xsb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ha anorin ay an-alihan moyon alaga yay kapanogoan nan Dios ha pa-mitoro moyo nin naiknawan moyon kaogalian. Tan lako ot a bawbagay a anorin a anggaw-on moyo.” ");
INSERT INTO xsb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Hawanin, pinadani ni Jesus a halban tawtawo bi-sa inobat nay pastang no anongkot kay la anggaw-on yay sirimonyan pa-mibano ba-yo mangan, wana konla, “Balang a-sa komoyo, paka-long-on moyoy halitaon ko tan pakaintindyon. ");
INSERT INTO xsb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Homin an-ipaloob ha boboy a makapamin kasalanan ha tawo, nokay yay an-ipalwah ha boboy, ya-rin a ampakapamin kasalanan. ");
INSERT INTO xsb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bi-sa, hin imbati ni Jesus a tawtawo tan hin nakalato yay na ha bali ay pinastang la yan dawdisipolos na, no anyay labay totolon nin yadtaw in-alimbawa na. ");
INSERT INTO xsb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wani Jesus konla, “Kay kamoy namaot doman ampakaintindi? Kay moyo doman angkaintindyan a ambo yay angkanon nin tawo a makapamin kasalanan kona? ");
INSERT INTO xsb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nga-min, yay pa-mangan ay kay anlomoob ha nakom, nokay ha tiyan bi-sa idiskarga.” (Ha pananalita nan anodti ni Jesus, impatandaan na a halban pa-mangan ay maari kanon.) ");
INSERT INTO xsb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wana ot ni Jesus, “Yay doka a ampangibat ha nakom nin tawo a makapamin kasalanan kona. ");
INSERT INTO xsb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nga-min, ambo ha likol, nokay ha nakom nin tawo ampangibat a dawdoka a isip, pa-mabayi o pa-maki-lalaki, tan laloma ot a imoralidad a gawa, pa-mangmatin tawo, ");
INSERT INTO xsb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","paniniba, kaagoman, kagogwa halban karokaan, pananaol, karawalan gawa, inggit, pa-maroroka, pa-magmata-gay tan kaongowan. ");
INSERT INTO xsb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yadtin halban kawkarokaan ay angkaibat ha lalo nakom, kanya hiladti a ampakapamin kasalanan ha tawo.” ");
INSERT INTO xsb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Hawanin, inomalih hi Jesus tan hilay dawdisipolos na konan ya-rin a logar. Nako hila ha kapatagan a madani ha syodad Tiro tan syodad Sidon a ambo anan hakop nin Israel nokay hakop anan Sirofenicia. Nakihanda hila ha a-say bali itaw. Kay na komon labay ni Jesus a main maka-tanda ha main nan kamainan, kot kay syimpri naisikrito. ");
INSERT INTO xsb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Main itaw a-say babayin main anak a dalagita a nilooban doka a ispirito. Tampol nan na-tandaan a ison hi Jesus. Kanya kina na ya ta nanalimokor ya ha arapan na. ");
INSERT INTO xsb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yadtin babayi ay ambo Israelita, nokay taga ya Sirofenicia. Impaki-totol na a palayahon ni Jesus yay doka a ispirito konan anak nan dalagita. ");
INSERT INTO xsb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kot wanan in-alimbawa ni Jesus, “Kailangan pabhoyon hila yapon a awa-nak ta ambo dapat kowon a pa-mangan la para ibi ha aw-aso.” ");
INSERT INTO xsb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maskin naintindyan nan babayi a yay dapat nan o-nawon tambayan ay hilay Israelita, wana syimpri kona, “Potog orin, Maistro, kot maskin hilay aw-aso ha hilong lamisawan ay ampangan hila syimprin mawmomo a nadabo lan awa-nak.” ");
INSERT INTO xsb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanya wani Jesus kona, “Bana ta hinalita moy anorin, maari kay nan morong ta inomalih yay nay doka a ispirito konan anak mo.” ");
INSERT INTO xsb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hin norong yay naor, na-lato nay anak nan ampira ana ha katri ta inomalih anay doka a ispirito kona. ");
INSERT INTO xsb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nibwat yay na hi Jesus ha lawlogar ha liglig ambay a hakop nin syodad Tiro tan syodad Sidon ta magbolta yay naman ha Alindayat Galilea. Kot balo itaw ya nagpa-wan ha dobali nin alindayat a hakop nin yay Mapolo a Babali a anha-wayan “Decapolis”. ");
INSERT INTO xsb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Main tawtawo itaw a nangawit kona nin a-say lalakin disnodon tolok tan amil ta impaki-totol la a iparna nay gamot na kona pigaw omabig ya. ");
INSERT INTO xsb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kanya impaka-dayô na ya ni Jesus konlan malabong a tawo. Bi-sa inigwa nay loway tamoro na ha mi-dobali totolyan nan lalaki, ba-yo nilomora ya ta pinonahan nan lora a dila nan lalaki. ");
INSERT INTO xsb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bi-sa tinomangal ya ha langit tan nanginanawa nin malawig bana ha inganga-ro na konan lalaki. Bi-sa wana kona, “Effata,” yay labay totolon, “Maabriyan!” ");
INSERT INTO xsb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tampol yan nakalngo a lalaki tan naalih a pa-makaamil na, kanya nakahalita yay nan malino. ");
INSERT INTO xsb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Impaka-bibilin ni Jesus kona tan konlan nangawit kona a ando ladti iba-balita ha hinoman. Kot maskin pa-no kahigpit a pa-mibibilin na ay mas lalo lay na ingat imba-balita. ");
INSERT INTO xsb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Masyadoy pa-maka-ngap lan tawtawo, wanla, “Anya pay nan abig a halban ginwa na! Maskin disnodon tolok ay angkagawa nan makalngo tan omol man ay angkagawa nan makahalita!” ");
INSERT INTO xsb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A-say awlo, na-pititipon anaman a golpin tawo. Hin ikatlon awlo ay na-hominan hilay nan pa-mangan. Kanya hina-wayan ni Jesus hilay dawdisipolos na, ta wana konla, ");
INSERT INTO xsb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Angka-ka-rowan koy tawtawo ta na-hominan hilay nan pa-mangan ta toloy awlo lay na iti. ");
INSERT INTO xsb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No paorongon ko hilan mabitil, maolaw hila ha dalan. Madayo paot a orongan lan laloma.” ");
INSERT INTO xsb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kot wanlan in-obat nin dawdisipolos na, “Ayti man wari mangwan maipapangan konla konan yadtin logar a homin paot kabali-bali?” ");
INSERT INTO xsb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pinastang na hila ni Jesus, wana, “Omno ot a tinapay a ison komoyo?” “Main bongat pito,” wanlan in-obat. ");
INSERT INTO xsb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bi-sa pinatoklo ni Jesus hilay tawtawo ha lota. Hawanin, kinwa nay pitoy tinapay. Bi-sa pa-makayari nan pinasalamatan yay Dios ay pini-pikna na ta inimbi konlan dawdisipolos na ta impapipapto para ha tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Main hilay namaot oomnon mangakalog a konâ. Impaki-salamat nay namaot ni Jesus yadti konan Dios, bi-sa impapipapto na ot para konlan tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kanya ni-pangan hilay tawtawo tan ni-kabhoy. Bi-sa, hin tinipon lan dawdisipolos na yay ni-katla a pini-pikna nin tinapay, nakapno hila ot nin pitoy bakol. ");
INSERT INTO xsb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yay bilang lan ni-pangan ay manga a-pat a libo. Hawanin, pinaorong na hilay na ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bi-sa, hiya tan hilay dawdisipolos na ay tampol nilomolan ha baloto ta nako hila ha logar a anha-wayan Dalmanuta. ");
INSERT INTO xsb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hawanin, main paw-Pariseo a nako koni Jesus ta naki-dibati hila kona. Bana ta labay la yan hobokon, dinawat la a mama-kit yan milagron ibat ha langit a pamilbian inhogo na yan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bana ta anorin, nanginanawa yan malawig hi Jesus. Bi-sa wana konla, “Hikamoy tawtawo hawanin, anongkot ampaningkap kamo ot nin pamilbian? Yay potog, ibalita ko komoyo, kay kamo pa-kitan pamilbian.” ");
INSERT INTO xsb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bi-sa imbati na hilay paw-Pariseo, ba-yo hiya tan hilay dawdisipolos na ay nilomolan ha baloto ta lomipay oman ha dobali alindayat. ");
INSERT INTO xsb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hin ya-rin, na-lingwanan lan dawdisipolos ni Jesus magbalon tinapay. Main hilan bongat a-say tinapay a natla ha baloto. ");
INSERT INTO xsb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hawanin, main yan labay ibibilin hi Jesus konla a imparalan na ha alimbawa. Wana, “Mag-ingat kamo tan pag-atapan moyoy pampalbag lan paw-Pariseo tan yay pampalbag ni Ari Herodes Antipas.” ");
INSERT INTO xsb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pinipapa-nowan lan dawdisipolos na yadtaw imbalita na, wanla, “Kanya hinalita na-rin bana ta kay tamo nakapagbalon tinapay.” ");
INSERT INTO xsb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kot tanda ni Jesus yay ampipapa-nowan la, kanya wana konla, “Anongkot ampipapa-nowan moyoy kay moyo pa-maka-wit nin tinapay? Kay moyo ot doman tanda ni angkaintindyan a main kon kapangyarian? Homin ot doman ha nakom moyo a tawtotoro ko? ");
INSERT INTO xsb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Main kamon mata kot bilang kay kamo ampaka-kit, main kamoy namaot totolyan kot bilang kay kamo ampakalngo. Na-lingwanan moyoy na wari, ");
INSERT INTO xsb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","hin pini-pikna koy limay tinapay a kinan lan limanlibon lalaki? Omnoy bakol a napno hin tinipon moyoy ni-katla?” “Labinloway bakol,” wanla. ");
INSERT INTO xsb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wana ot ni Jesus, “Hapa yadtaw pitoy tinapay a kinan lan a-pat a libon lalaki, omnoy bakol a napno nin tinapay a natipon moyon ni-katla?” “Pitoy bakol,” obat lan dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Kay moyo ot wari angkaintindyan a yay pampalbag a antokoyon ko ay ambo tongkol ha tinapay nokay tongkol ha gawa karokaan?” wanan pastang ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pa-makalato li Jesus ha baryon Betsaida, main a-say lalakin bolag a inawit lan tawtawo koni Jesus, ta impaki-totol la kona a aptohon na ya pigaw maka-kit ya. ");
INSERT INTO xsb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kanya inakay ni Jesus yay bolag ta inawit na ya ha likol nin baryo. Bi-sa pinonahan nan lora na a mata nan bolag tan imparna nay gamot na ha mata na, bi-sa na ya pinastang. Wana, “Main kay na doman angka-kit?” ");
INSERT INTO xsb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Hinomilap yay lalaki, bi-sa wana, “Ampaka-kit akon tawtawon anlalako, kot bilang hilan kawkayo.” ");
INSERT INTO xsb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Imparna nay naman ni Jesus a gamot na ha mata na. Bi-sa hin pinahilap na yan oman, nilomino anay paninilap na ta na-kit nay nan malino a halban tawo. ");
INSERT INTO xsb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bi-sa pinaorong na yay na ni Jesus itaw ha bali la nin binibilinan, wana, “Ando kay na domalan ha baryo tan ando mo iba-balita ha hinoman itaw a nangyari.” ");
INSERT INTO xsb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Hawanin, inomalih hi Jesus ha baryon Betsaida kalamo a dawdisipolos na ta nako hila ha bawbaryo nin babalin Cesarea a hakop ni Felipe. Ha kala-lalako la, pinastang na hila ni Jesus, wana, “Anyay wanlan tawtawo no hino ko?” ");
INSERT INTO xsb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wanlan in-obat kona, “Hika kano hi Juan Bautista. Main anamaot ampanalita a hika kano hi Propita Elias. Wanlay namaot laloma, a-sa ka kano konlan laloma ot a pawpropita nan Dios hin yadtaw.” ");
INSERT INTO xsb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bi-sa pinastang na hilay naman ni Jesus, wana, “Hapa hikamo, anyay wamoyoy namaot no hino ko?” Inombat hi Pedro, wana, “Hika yay Cristo, yay inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bi-sa imbibilin ni Jesus konla a ando la iba-balita ha hinoman odtin tongkol kona. ");
INSERT INTO xsb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hawanin, inompisawan nay na ni Jesus nin intoro konlan dawdisipolos na yay ayon ha Masanton Kasolatan a hiya a Naglalaman Tawo ay kailangan domalan ha lako a dawdya-dya, itakwil la yan pawpoon nin Israelita, pawpoon pari tan mawmaistron kapanogoan tan ipapati, balo ta ha ikatlon awlo ay morong yan mabyay. ");
INSERT INTO xsb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Malino nan imbalita odti konla, kanya impa-lilih na ya ni Pedro ta hinaar na ya. ");
INSERT INTO xsb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kot inomarap hi Jesus konlan dawdisipolos na, bi-sa sinita na hi Pedro. Wana, “Domayô ka kongko, yay hinalita mo ay impanakom ni Satanas! Nga-min, yay an-isipon mo ay ambo kalabayan nin Dios, nokay kalabayan nin tawo.” ");
INSERT INTO xsb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Hawanin, pinadani ni Jesus hilay tawtawo pati hilay dawdisipolos na, ta wana konla, “Hinoman a malabay homonol kongko ay kailangan lingwanan nay sarili na, tanggapon nay kawkadya-dyaan a andomalan ha biyay na alang-alang kongko a kaalimbawaan balatayon nay sarili nan kros, tan kailangan homonol ya kongko. ");
INSERT INTO xsb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nga-min, hinoman a ambo matibolos a nakom mati alang-alang kongko ay kay na matanggap yay biyay a homin anggawan, kot hinoman a mati alang-alang kongko tan ha Labah a Balita ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nga-min, anyay pakinabang nin a-say tawo, maipag-ikon na may halban kayamanan ha babon lota kot impyirnoy nan lamang a ogotan na? ");
INSERT INTO xsb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma-bayaran na wari nin kayamanan a kalolwa na pigaw kay mi-ka ha impyirno? ");
INSERT INTO xsb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Hinoman a ampamikaringoy kongko tan ha hawhalita ko konlan tawtawo hawanin panaon a masyadoy nan makasalanan tan ambo maptog ha Dios, hiko a Naglalaman Tawo ay ikaringoy ko yay namaot ha pa-mako kon oman iti. Konan ya-rin pa-mako kon oman iti ay ma-kit moyon yay kalinggasan nan Ama ay iti kongko, tan kalamo ko hilay bawbanal a anghil.” ");
INSERT INTO xsb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wana ot ni Jesus, “Yay potog, ibalita ko komoyo, main naka-dong iti hawanin a angkabyay ot anggan ha ma-kit lan makalato a pa-mag-ari nan Dios, awit a main nan kapangyarian.” ");
INSERT INTO xsb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pa-makalabah nin a-nom a awlo, impagkalamoan ni Jesus hi Pedro, hi Santiago tan hi Juan nin nako ha a-say mata-gay a bakil nin hila-hilan bongat. Tongwa, na-kit lan disipolos a nangoman a itsora ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yay doloh na ay ampangi-kirlap ta sangkapotian a homin maka-papoti nin bilang anorin iti ha babon lota. ");
INSERT INTO xsb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tongwa, na-kit lay nan bongat hi Propita Elias tan hi Moises. Ampaki-totol hila koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Hawanin wani Pedro koni Jesus, “Maistro, labah ta iti tamo. Mama-dong kamin toloy hihilongan, a-sa para komo, a-sa para koni Moises tan a-sa para koni Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Homin ha nakom ni Pedro odtaw hinalita na ta masyado hilan angkali-mo. ");
INSERT INTO xsb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bi-sa inamoyan hila nin a-say lolom, tan nalngo lay bosis nan Dios a naibat konan ya-rin a lolom, wana, “Yadti a anlabyon kon Anak. Manglongo kamo kona.” ");
INSERT INTO xsb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tongwa, hin biniliw lan toloy disipolos na a ka-libol, na-sikaso la a homin hilay nan laloman kalamoan no ambo hi Jesus tana. ");
INSERT INTO xsb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lo-gan lan an-omaypa ni Jesus ha bakil, binibilinan na hilay toloy disipolos na a ando la iba-balita ha hinoman yadtaw na-kit la, anggan ha hiya a Naglalaman Tawo ay norong anan nabyay. ");
INSERT INTO xsb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hinonol lay bibilin na, balo ta pinipapa-nowan la no anyay kanaboan nin yadtaw hinalita nan pa-morong nan mabyay. ");
INSERT INTO xsb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bi-sa pinastang la ya, wanla, “Anongkot man an-ibalita lan mawmaistron kapanogoan a dapat lomato yapon oman hi Propita Elias ba-yo kano makalato yay Cristo?” ");
INSERT INTO xsb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wanan in-obat ni Jesus konla, “Potog nakasolat a mo-na yan makalato hi Propita Elias pigaw iparihado nay halban bagay. Kot nakasolat anamaot tongkol kongko, a hiko a Naglalaman Tawo ay domalan ha lako a dawdya-dya tan itakwil. ");
INSERT INTO xsb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hawanin, ibalita ko komoyo, yay antokoyon ison a Propita Elias ay nakalato ana. Bi-sa ginwa lay naor konay balang labay la ayon ha nakasolat tongkol kona.” Yay antokoyon ni Jesus ay yadtaw hi Juan Bautista. ");
INSERT INTO xsb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hin makalato hilay na ni Jesus ha kamainan lan laloman dawdisipolos na, na-kit la a na-palibolan hilan golpin tawo tan main mawmaistron kapanogoan a ampaki-diskosyon konla. ");
INSERT INTO xsb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Halban tawo ay naka-ngap hin na-kit la hi Jesus, kanya polayo lan hinomakbat kona ta inasikaso la ya. ");
INSERT INTO xsb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bi-sa pinastang ni Jesus hilay mawmaistron kapanogoan, wana, “Anya kot a ampididiskosyonan moyo?” ");
INSERT INTO xsb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A-sa konlan malabong a tawo itaw a inombat kona, wana, “Maistro, inawit ko komo yay anak kon lalaki ta nilooban yan doka a ispirito, kanya kay ya ampakahalita. ");
INSERT INTO xsb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Topo pasompongon na ya, an-itomba na ya. Bi-sa ampi-bolâ-bolâ a boboy na, ampigogot ya tan ampama-paghon. Impaki-totol koy na konlan dawdisipolos mo a palayahon la yay doka a ispirito, kot kay la na-palayah.” ");
INSERT INTO xsb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wanan in-obat ni Jesus kona, “Hikamoy tawtawo hawanin, homin kamon katotpol. Pa-no ot kari kaboyot a kailangan kon maki-lamo komoyo bi-sa kamo tompol? Pa-no ot kari kaboyot a kailangan katamon pagpasinsyawan? Awiton moyo-rin anak iti kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inawit lay naor a anak kona. Pa-maka-kit nan doka a ispirito koni Jesus, antimano pina-paghon na yay anak anggan natomba ya, ta bi-sa ni-tolir-tolir yan ampi-bolâ-bolâ a boboy. ");
INSERT INTO xsb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pinastang ni Jesus yay tatay nan anak, wana, “Naka-no ot nag-ompisa yadti?” Wanan tatay, “Paibat hin makalog ya. ");
INSERT INTO xsb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mabotbot na yan an-i-ka ha apoy o ha lanom para patyon. Kot no wari ta main kan magawa, inganga-ro mo pay na, tambayan mo kami pa.” ");
INSERT INTO xsb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“No tompol ka,” wani Jesus. “Nga-min, halban bagay ay magawa ha tawon main katotpol.” ");
INSERT INTO xsb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Antimano, inombat yan naipakhaw nay bosis na nin naka-tangih, wana, “Antompol ako, Maistro, kot tambayan mo ko ta kolang ot a katotpol ko.” ");
INSERT INTO xsb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hin na-kit ni Jesus a lalon anlomako a tawtawo, pinanalitaan nay na yay doka a ispirito, wana kona, “Hikay ispiriton ampamatolok tan ampamaomol konan anak, anmandawan kata: Omalih ka ison kona! Tan mika-ka-noman ando kay na lomoob oman kona!” ");
INSERT INTO xsb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Inomaghaw yapon yay doka a ispirito a iti konan anak, bi-sa pinagoygoy na yan grabi ba-yo ya nilomikol kona. Naalihan yan malay yay anak, kanya karamilan konlan tawtawo, yay wanla, “Nati yay na.” ");
INSERT INTO xsb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kot ginawang ni Jesus a gamot nan anak ta binangon na ya, kanya inomdong ya. ");
INSERT INTO xsb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hin norong yay na hi Jesus ha bali nin kalamo hilay dawdisipolos na, pinastang la ya nin hila-hilan bongat. Wanla, “Anongkot kay mi na-palayah yadtaw doka a ispirito?” ");
INSERT INTO xsb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wani Jesus konla, “Yay anorin a klasin doka a ispirito ay kay ma-palayah, no kay domawat ha Dios nin main awit pa-magsakripisyon kay mangan*.” ");
INSERT INTO xsb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Inomalih hila ni Jesus konan ya-rin a logar, bi-sa nagpa-wan hila ha probinsyan Galilea. Kay na labay ni Jesus a main maka-tanda a itaw ya, ");
INSERT INTO xsb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta antoroan na hilay dawdisipolos na, wana konla, “Hiko a Naglalaman Tawo ay iintriga ha tawtawo ta ipapati la ko. Balo ta ha pa-ngamati ko, maabot a ikatlon awlo ay morong akon mabyay.” ");
INSERT INTO xsb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kot kay la naintindyan a kanaboan nin ya-rin imbalita na, balo ta angkali-mo hilay namaot nin mamastang kona. ");
INSERT INTO xsb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bi-sa niabot hilay na ni Jesus ha babalin Capernaum. Hin itaw hilay na ha bali, pinastang na hilay dawdisipolos na, wana, “Anyay ampididiskosyonan moyo nangon ha dalan?” ");
INSERT INTO xsb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kot kay hila nanlok ta yay pinididiskosyonan la ay no hinoy pinakamata-gay konla. ");
INSERT INTO xsb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hawanin, tinomoklo hi Jesus ta bi-sa pinadani na hilay labinloway disipolos na, ta wana konla, “Hinoman a malabay mag-in primira ay kailangan itoring nay sarili nan pinakahoyot tan ma-magsirbi nin halban kawkalamoan na.” ");
INSERT INTO xsb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bi-sa nangwa hi Jesus nin a-say anak ta pinaodong na ha pibotlayan la. Bi-sa kinopkop na ya, ta wana konla, ");
INSERT INTO xsb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hinoman a ampananggap ha a-say tawon bilang konan yadtin anak alang-alang kongko ay bilang hikoy antanggapon na. Tan hinoman a ampananggap kongko ay ambo bongat hikoy antanggapon na, nokay pati yay nanogo kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Hawanin wani Juan koni Jesus, “Maistro, naka-kit kamin a-say lalakin ampangamit nin ngalan mo para mamalayah dawdoka a ispirito a nilomoob ha tawo, kot ambo tamo yan kalamoan. Kanya binawalan mi ya bana ta ambo tamo yay naor kalamoan.” ");
INSERT INTO xsb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kot wani Jesus, “Ando moyo ya bawalan ta yay ampangamit ngalan ko pigaw makagawa nin milagro ay kay ya basta-basta mamaroroka kongko. ");
INSERT INTO xsb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nga-min, yay tawon ambo kontra kontamo ay kakampi tamo. ");
INSERT INTO xsb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yay potog, ibalita ko komoyo, hinoman a alimbawa mamainom komoyo maskin a-say bason lanom bongat, ta tanda na a anhomonol kamo koni Cristo a homin laloma no ambo hiko ay sigoradon tobaloon na yan Dios ha ginwa nan kaabigan.” ");
INSERT INTO xsb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wana ot ni Jesus konlan dawdisipolos na, “Hinoman a mag-in pangibatan nin makapagkasalanan a a-sa konlan antompol kongko a bilang konlan hiladtin awa-nak, labah ot katinan a looy na nin mahi-ban a baton an-ipangiling ta bi-sa idabo ya ha taaw. ");
INSERT INTO xsb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Alimbawa, no yay gamot mo a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan po-tohon a gamot mo. Labah ot pa-hal pokol a a-say gamot mo basta mi-ka ka ha langit, dinan komplitoy gamot mo kot balo mi-ka kay nan lamang ha impyirnon homin pa-nga-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Itaw ay kay angkati a aw-olol a ampangan ha tawtawo tan kay angka-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","No yay ayi moy namaot a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan po-tohon a ayi mo. Labah ot pa-hal po-toh a a-say ayi mo basta mi-ka ka ha langit, dinan komplitoy ayi mo kot balo ibantak kay nan lamang ha impyirnon homin pa-nga-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Itaw ay kay angkati a aw-olol a ampangan ha tawtawo tan kay angka-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No yay mata moy namaot a ampangibatan nin makapagkasalanan ka, tampol kan gomwa paralan pigaw tomgon ana-rin, maskin mahkit a bilang moy nan hokiton a mata mo. Labah ot pa-hal bolag a a-say mata mo basta mi-ka ka ha kaarian nan Dios, dinan komplitoy mata mo kot balo ibantak kay nan lamang ha apoy ha impyirno. ");
INSERT INTO xsb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Itaw ay kay angkati a aw-olol a ampangan ha tawtawo tan kay angka-lop a apoy. ");
INSERT INTO xsb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Balang antompol kongko ay domalan ha pa-magdya-dya pigaw ma-linisan a biyay na a bilang anamaot ha dawda-ton a popoolan a ambiyan asin. ");
INSERT INTO xsb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maalaga a asin, kot no alimbawa ta na-hominan yay nan alat, ma-paalat moyo wari oman? Kanya hikamo a anhomonol kongko, ipa-kit moyo komon ha magandan ogali a hikamo ay pa-hal asin a kay na-hominan alat, tan lawah kamon misosondo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Inomalih hi Jesus ha babalin Capernaum kalamo hilay dawdisipolos na ta nilomipay hila ha Kabatwan Jordan ta nako ha a-say logar a hakop ot probinsyan Judea. Pinititiponan la yay naman itaw nin lako a tawtawo, tan tinoroan na hilay namaot a bilang nakaogalian nay nan gaw-on. ");
INSERT INTO xsb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bi-sa main anamaot paw-Pariseo a nako kona para hobokon la no ma-ka-lot la ya ha pananalita. Kanya pinastang la ya, wanla, “Ayon ha kapanogoan nan Dios kontamo, maari doman ihiyay nin lalaki a kaambali na?” ");
INSERT INTO xsb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wanan in-obat ni Jesus konla, “Anya kot yay inmanda ni Moises komoyo?” ");
INSERT INTO xsb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wanla, “Pinayagan ni Moises a ihiyay nin lalaki a kaambali na, no biyan na ya yapon kasolatan nin pa-mihiyay ba-yo na ya ihiyay.” ");
INSERT INTO xsb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kot wani Jesus konla, “Bana ha katiboyan olo moyon tawtawo, kanya na sinolat ni Moises ya-rin kasogoan. ");
INSERT INTO xsb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kot hin kalin-oo-nawan, hin pinalsa nan Dios a babon lota ay pinalsa nay tawo nin lalaki tan babayi. ");
INSERT INTO xsb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yadti bara-nan no anongkot ibati nin lalaki a tatay tan nanay na ta tomapol ya konan kaambali na, ");
INSERT INTO xsb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","bi-sa hilay lowa ay mag-in anan asa-sa. Kanya ambo hilay nan lowa nokay pa-hal asa-say na. ");
INSERT INTO xsb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Intonsis, yay piniasa-sa nan Dios ay kay dapat pihiyayon nin tawo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hin itaw hilay na ni Jesus ha bali, pinastang la yay namaot nin dawdisipolos na tongkol ha pa-mihiyay nin kaambali. ");
INSERT INTO xsb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wani Jesus konla, “Hinoman a lalaki a mamihiyay nin kaambali, bi-sa magkaambalin laloma ay magkasalanan yan pa-mabayi laban konan kaambalin inhiyay na. ");
INSERT INTO xsb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Anorin anamaot kapara, yay babayin makihiyay ha kaambali, bi-sa magkaambalin laloma ay magkasalanan yan pa-maki-lalaki.” ");
INSERT INTO xsb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hawanin, main tawtawon nangawit nin awa-nak koni Jesus ta labay lan aptohon na hila para bindisyonan, kot hinaar hila nin dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hin na-kit ni Jesus odtin ginwa lan dawdisipolos na ay nagolo ya, kanya wana konla, “Po-layan moyo hilan domani kongkoy aw-awa-nak, ando moyo hila haaron. Nga-min, hilay tawtawon main pa-masimala ha Dios a bilang konla ay kabilang ha ampag-arian na. ");
INSERT INTO xsb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yay potog, ibalita ko komoyo, hinoman a kay mananggap ha pa-mag-ari nan Dios, nin bilang ha pa-nanggap lan makalog a anak ay kay maka-paki-lamo ha tawtawon ampag-arian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bi-sa ina-sa a-sa na hilan binibi ni Jesus a aw-awa-nak tan imparna nay gamot na ha olo la ta binindisyonan na hila. ");
INSERT INTO xsb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hin an-omalih hilay na ni Jesus, main a-say lalakin nolayon nako kona. Bi-sa nanalimokor ya ha arapan na ta pinastang na ya, wana, “Labah a Maistro, anyay kailangan kon gaw-on pigaw magkamain akon biyay a homin anggawan?” ");
INSERT INTO xsb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Wani Jesus kona, “Anongkot hina-wayan mo kon labah? Homin laloman labah no ambo yay Dios bongat. ");
INSERT INTO xsb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tanda moy kawkasogoan nan Dios: Ando ka mangmatin tawo; ando ka mamabayi; ando ka maniba; ando ka tomistigo nin kagalotoyan; ando ka manaol; igalang moy tatay tan nanay mo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kot wanan yadtin lalaki, “Maistro, ya-rin halban ay anhonolon koy na paibat hin anak ako.” ");
INSERT INTO xsb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Hinilap na ya ni Jesus nin main pa-manglabi. Bi-sa wana kona, “Kolang ka ot nin a-say bagay. Morong ka ta ilako moy main mon kawkama-main ta ipapto moy na-paglakoan konlan mawmairap pigaw magkamain kan kayamanan ha langit. Bi-sa magbolta ka, balatayon moy pa-hal sarili mon kros ta homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nilomolo yay lalaki ha hinalita ni Jesus. Bi-sa norong yan mairap a nakom bana ta kalakan nan kama-main. ");
INSERT INTO xsb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hinilap ni Jesus hilay halban disipolos na, ta wana konla, “Hay irap pay na ha tawtawon mangayaman nin pahakop ha pa-mag-ari nan Dios!” ");
INSERT INTO xsb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nag-ispanta hilay dawdisipolos na ha hinalita na. Kot wanay naman ni Jesus konla, “Tawtalakaka, talagan na-pakairap konlan ampasimala ha kayamanan nin pahakop ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maganoh ot ha a-say kamilyo nin homlot ha lobot karayom, dinan yay a-say mayaman a pahakop ha pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lalo hilan nag-ispantay dawdisipolos ni Jesus, kanya wanla ha a-sa tan a-sa, “Hino man no-nin a maari malipyas?” ");
INSERT INTO xsb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Hinilap na hila ni Jesus, bi-sa wana, “Yadti ay kay magawa nin tawo kot magawa nan Dios ta halban bagay ay posibli kona.” ");
INSERT INTO xsb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hawanin wani Pedro koni Jesus, “Hapa hikami? Imbati mi halban ta anhomonol kami na komo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Wani Jesus, “Yay potog, ibalita ko komoyo, hinoman a mamibati nin bali o tawtalakaka o tatay o nanay o kaambali o aw-awa-nak o lawlota alang-alang kongko tan ha Labah a Balita ");
INSERT INTO xsb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay hawanin ot panaon ay makatanggap yay nan yatos-yatos a holok ha imbati nan bawbali o tawtalakaka o nawnanay o aw-awa-nak o lawlota, maskin da-damsakon ya. Bi-sa ha dobali biyay ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kot lako konlan ampo-na hawanin a ha lomato a panaon kot ma-hoyot tan lako anamaot a angka-hoyot hawanin a mio-na.” ");
INSERT INTO xsb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hawanin, iti hi Jesus ha dalan makon syodad Jerusalem nin kalamo a lako a tawtawo. Ha kala-lalako la ay ampo-na hi Jesus. Naka-ngap hilay labinloway disipolos na, tan halak-halakan hilay namaot a laloman tawtawo a antomombok konla. Hin ya-rin ay impa-lilih nay naman ni Jesus hilay labinloway disipolos na konlan tawtawo, ta imbalita na konla no anyay mangyari kona. ");
INSERT INTO xsb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wana, “Tandaan moyodti: Yadtin pa-mako tamo ha Jerusalem, hiko a Naglalaman Tawo ay iintrigay na konlan pawpoon pari tan mawmaistron kapanogoan ta sintinsyawan la kon kamatyan. Bi-sa iintriga la ko konlan ambo Israelita, ");
INSERT INTO xsb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ta toya-toyaon la ko, lora-loraan, latigowon tan patyon. Kot ha ikatlon awlo ay morong akon mabyay.” ");
INSERT INTO xsb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Hawanin, hi Santiago tan hi Juan a awa-nak ni Zebedeo ay dinomani koni Jesus, ta wanla kona, “Maistro, main kami komon labay a gaw-on mo para komi.” ");
INSERT INTO xsb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wana konla, “Anya kot a labay moyon gaw-on ko para komoyo?” ");
INSERT INTO xsb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wanla kona, “Payagan mo komon a ha kaarian mon sangkarangalan ay magkamain kamin karapatan nin tomoklo ka-dani mo, yay a-sa ha wanan mo tan yay a-sa ha wili mo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kot wani Jesus konla, “Kay moyo tanda a kanaboan nin ya-rin an-ipaki-totol moyo. Kababaan moyo wari magdya-dya nin bilang ha pa-magdya-dya ko, o dalanan yay klasin pa-mangmati a bilang ha gaw-on la kongko?” ");
INSERT INTO xsb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wanlan in-obat, “Iya, kababaan mi.” Kot wani Jesus konla, “Potog a magdya-dya kamo nin bilang ha pa-magdya-dya ko, tan patyon kamo nin bilang ha gaw-on la kongko. ");
INSERT INTO xsb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Balo ta ambo kon karapatan mamili no hinoy tomoklo ha wanan ko o ha wili ko, nokay yay totokloan ha dani ko ay para konlan pinaghandaan nan Ama ko ha langit.” ");
INSERT INTO xsb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hin nalngo lan mapolo ot a disipolos yay impaki-totol ni Santiago tan ni Juan, nasora hila. ");
INSERT INTO xsb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanya pinadani na hila ni Jesus, ta wana konlan halban, “Tanda moyo a hilay ambilbion pawpoon lan ambo Israelita ay mabyat a pamomoon la tan hilay main mata-gay a katongkolan ay an-ipilit lay labay la ha pamomoon la. ");
INSERT INTO xsb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kot ambo kamon dapat mag-in anorin, nokay hinoman a malabay mag-in mata-gay ha gropo moyo, kailangan disidido yan magsirbi ha kawkalamoan na. ");
INSERT INTO xsb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tan hinoman komoyo a malabay mag-in poon ha gropo moyo ay kailangan mag-in yan pa-hal alipon nin halban. ");
INSERT INTO xsb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nga-min, maskin hiko a Naglalaman Tawo ay kay ko nako iti ha babon lota para pasirbi, nokay para magsirbi tan para ibi koy biyay ko nin ipanondon ha lako a tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Hawanin, dinomalan hi Jesus kalamo hilay dawdisipolos na tan hilay malabong a tawo ha babalin Jerico. Hin an-omalih hilay na itaw, main a-say lalakin bolag a antoklo ha liglig kalsada ta ampakilimoh. Yadti ay hi Bartimeo a anak ni Timeo. ");
INSERT INTO xsb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hin nalngo nan hi Jesus a taga Nazaret yay anlomabah, hinoma-way ya ta wana, “Jesus, lipi ni Ari David, inga-rowan mo ko!” ");
INSERT INTO xsb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hinaar la yan lako a tawo itaw pigaw mamakatinok ya. Kot lalo yay na ingat hinoma-way, wana, “Lipi ni Ari David, inga-rowan mo ko!” ");
INSERT INTO xsb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tinomgon hi Jesus, ta wana konlan tawtawo, “Ha-wayan moyo ya.” Kanya hina-wayan la hi Bartimeo, wanla kona, “Ando kay na mag-aborido. Omdong kay na ta an-ipaha-wayan na ka.” ");
INSERT INTO xsb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Inwahkil nay alimonmon na ta tampol yan inomdong bi-sa dinomani koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Wani Jesus kona, “Anyay labay mon gaw-on ko para komo?” Wani Bartimeo, “Maistro, labay ko komon maka-kit.” ");
INSERT INTO xsb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kanya wani Jesus kona, “Maari kay nan morong, ta maka-kit kay na bana ha main mon katotpol.” Antimano, naka-kit yay naor, bi-sa hinomonol ya koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Madani hilay na ni Jesus ha syodad Jerusalem ta niabot hilay na ha pibotlayan nin loway baryo a Betfage tan Betania, a parihon iti ha liglig nin Bakil Olibo. Hawanin, namihogo yan loway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wana konla, “Domiritso kamo konan ya-rin ka-tobon a baryo ta pa-makalato moyo itaw, main kamon ma-kit a-say kilaw asno a nakatakol a kay ot pinagkabayowan nin maskin hinoman. Orkalan moyo ta awiton iti. ");
INSERT INTO xsb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No main mamastang komoyo no anongkot an-orkalan moyo-rin, ibalita moyo, ‘Kailangan nan Katawan,’ ta pomayag ya man tampol.” ");
INSERT INTO xsb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nako hilay na, bi-sa na-kit lay naor yay kilaw asno ha liglig kalsada a nakatakol ha poltan balaybay. Kanya inorkalan la. ");
INSERT INTO xsb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hin ya-rin ay pinastang hila nin omnoy tawon nakaodong itaw, wanla, “Anongkot an-orkalan moyo-rin?” ");
INSERT INTO xsb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bi-sa imbalita lay naor yay imbibilin ni Jesus konla, kanya pinayagan hila. ");
INSERT INTO xsb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bi-sa inawit lay nay kilaw asno koni Jesus. Ba-yo insapin lay aw-alimonmon la konan kilaw asno ta bi-sa pinagkabayowan nay na ni Jesus ha pa-makon Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lako a tawtawon namiapin aw-alimonmon la ha dalanan na. Hilay lalomay namaot ay namo-toh nin mabolong a hawhanga ha lawak ta bi-sa la in-apin ha dalanan na pa-mipa-kit nin kaga-galang la koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hilay anlalako ha o-nawan tan hilay namaot a an-omaloyon ay ampiho-holyak ha kaligawan, wanla, “Viva! Poriwon yay ampakalato ha ngalan nan Katawan! ");
INSERT INTO xsb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dayawon yay pa-mag-ari na, ta ha ngalan nan Katawan ay hiyay mamipatoloy nin yadtaw pa-mag-ari nan kapapo-papoan tamon hi Ari David. Poriwon yay Katawan ha sangkalangitan!” ");
INSERT INTO xsb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pa-makalato ni Jesus ha syodad Jerusalem, nako ya ha timplo nan Dios ta biniliw nay halban bawbagay itaw. Hin anyomabi na, nako yay na ha baryon Betania kalamo na hilay labinloway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kinaboklahan, hin an-omalih hila ni Jesus ha baryon Betania, nalayam nay bitil na. ");
INSERT INTO xsb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hin na-tamolaw nay a-say poon igos a lako anay bolong, kina nan biniliw no main anan bonga. Kot pa-makalato na itaw, homin yan na-kit bonga nokay bawbolong bongat, bana ta ambo ot disnodon panaon igos. ");
INSERT INTO xsb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kanya inhompa na-rin poon igos, wana, “Mika-ka-noman ay homin anan mangan nin bonga mo ta kay kay na mamongan oman.” Nalngo ladti nin hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pa-makalato lay naman ni Jesus ha Jerusalem, nako ya ha timplo. Pina-paalih na hilay ampi-paglako tan ampi-panaliw itaw nin maida-ton konan Dios. Bi-sa binalinta nay lawlamisawan lan ma-nagilin kwarta itaw, pati yay tawtotokloan lan ma-maglako nin idada-ton anamaot a kawkalapati. ");
INSERT INTO xsb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kay na syimpri pinayagan nin magpa-wan itaw ha timplo yay hinoman a main awit karga. ");
INSERT INTO xsb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hawanin, pinangaralan na hilay tawtawo itaw, wana, “Ambo doman nakasolat ha Masanton Kasolatan, a wanan Dios, ‘Yay bali ko ay ha-wayan balin panawatan nin tawtawo ha halban nawnasyon’? Halako ta anggaw-on moyon ‘pamaliwan nin mawmahiba.’” ");
INSERT INTO xsb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hin na-tandaan ladti nin hilay pawpoon pari tan mawmaistron kapanogoan, naningkap hilan paralan para maipapati la hi Jesus ta angkali-mo hila kona bana ta halban tawo ay anhomanga ha pa-noro na. ");
INSERT INTO xsb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hin anyomabi na, inomalih hilay na ni Jesus ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kinaboklahan, hin na-labahan lay naman ni Jesus yadtaw poon igos ha pa-mako lan oman ha Jerusalem, na-kit lan nalanoh ana ta nati. ");
INSERT INTO xsb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na-panomtoman ni Pedro a hompa ni Jesus, kanya wana kona, “Maistro, bilyon mo! Nalanoh anay poon igos a inhompa mo.” ");
INSERT INTO xsb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Wanan in-obat ni Jesus konlay nan halban, “Tompol kamo ha Dios. ");
INSERT INTO xsb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yay potog, ibalita ko komoyo, maskin hinoman a manalita konan ya-rin a bakil, ‘Maalih ka-son ta lomipat ka ha ambay!’ nin kay ampagdoda, nokay ampi-polon na a mangyari yay hinalita na ay gaw-on nan Dios orin para kona. ");
INSERT INTO xsb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kanya ibalita ko komoyo, anyakaman a bagay a dawaton moyo ha Dios, pi-polon moyon bilang moyoy nan antanggapon ta matanggap moyo. ");
INSERT INTO xsb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kot no andomawat kamo ta main kamon hakit nakom ha hinoman, patawaron moyo yapon pigaw patawaron na kamoy namaot nin Ama moyo ha langit ha main moyon kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kot no kay kamo magpatawad, kay na kamoy namaot patawaron nin Ama moyo ha langit ha main moyon kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hawanin, nagbolta hilay naman ni Jesus ha timplo ha Jerusalem. Lo-gan anlalako hi Jesus itaw ha loob nin kahakopan nin timplo, dinaniwan la yan pawpoon pari, mawmaistron kapanogoan, tan pawpoon nin Israelita a pari-parihon myimbro nin pinakamata-gay a konsiho nin nasyon Israel, ");
INSERT INTO xsb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ta wanla, “Anyay karapatan mo anongkot angga-gaw-on mo-rin halban? O hinoy nami nin karapatan komo para gaw-on yay anorin?” ");
INSERT INTO xsb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wani Jesus konla, “Main akoy namaot labay pastangon komoyo. Obaton moyo yapon yadti, bi-sa ko ibalita komoyo no hinoy nami nin karapatan kongko para gomawa anodtin bawbagay. ");
INSERT INTO xsb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ibalita moyo pa kongko: Ayti naibat a karapatan ni Juan para mamaotismo, ha Dios doman o ha tawo?” ");
INSERT INTO xsb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nipapa-no hila yapon ha a-sa tan a-sa, wanla, “No halitaon tamon ibat ha Dios, sigoradon halitaon na kontamo, ‘Anongkot man no-nin ta kay moyo ya pini-pol?’ ");
INSERT INTO xsb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kot no halitaon tamoy namaot a naibat ha tawo ay ka-pali-mo.” Nga-min, angkali-mo hila ha tawtawo bana ta ambilbion nin halban a yadtaw hi Juan ay talagan propita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kanya, yay in-obat la tana koni Jesus ay “Kay mi tanda.” Kanya wani Jesus konla, “Kay koy namaot no-nin ibalita komoyo no hinoy nami nin karapatan kongko para gomawa anodtin bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nangaral ya ot konla hi Jesus nin imparalan na ha alimbawa, wana, “Main a-say lalaki a nangmolan golpin obas ha main nan lota, bi-sa na inalalan a nanglibol. Ba-yo ginomwa yan pamohpohan obas tan nama-dong ot nin mata-gay a balin pagbantayan. Pa-makayari, nangwa yan tawtawon mangasiwa konan yadtin obasan na, bi-sa nako ya ni-wan ha laloman logar. ");
INSERT INTO xsb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hin panaon anan pa-motin obas, namihogo yan a-say alila konlan ma-ngasiwa nin obasan na, para kowon a parti na. ");
INSERT INTO xsb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kot pa-makalato nan alila, binombonan la yan mawma-ngasiwa ta bino-bogbog, bi-sa pinaorong la yan kay homin awit. ");
INSERT INTO xsb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kanya nanogo yay naman yadtin main ikon obasan nin a-sa ot a alila, kot bina-batibat la yan bato, nirindi la ya ha olo tan pinaorong la yan ka-paringoy ot a itsora. ");
INSERT INTO xsb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Hawanin, nanogo yay naman laloma, kot pinati la. Lako ot a inhogo-hogo na, kot bino-bogbog lay laloma tan hilay laloma ay pinati. ");
INSERT INTO xsb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hin hoyot, asa-sa tanay angkatla a maihogo na a homin laloma no ambo yay anlabyon nan anak a lalaki. Kanya inhogo na ya konla, ta wana ha sarili na, ‘Sigoradon igalang lay anak ko.’ ");
INSERT INTO xsb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kot hin na-kit lan mawma-ngasiwa yadtin anak na, wanla ha a-sa tan a-sa, ‘Ya-rin yay manawil. Patyon tamo ya pigaw maipag-ikon tamoy tatawilon na.’ ");
INSERT INTO xsb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kanya yay ginwa la ay binombonan la ya ta pinati, bi-sa imbasyo ha likol nin obasan.” ");
INSERT INTO xsb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Hawanin,” wanan impagpatoloy ni Jesus, “anya man wari a gaw-on nan main ikon obasan? Hiyay na mismo a mako ta pa-patyon na hilay mawma-ngasiwa, bi-sa ipa-taya nay obasan na ha laloma.” ");
INSERT INTO xsb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wana ot ni Jesus, “Ambo doman nabasa moyodtin wana ha Masanton Kasolatan: ‘Yay bato a impoyra lan karpintiro Ay yadtaw mismo a ginwa pinakapondasyon nin bali. ");
INSERT INTO xsb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yadti ay gawa nan Katawan tan ka-paka-ngap kontamo.’” ");
INSERT INTO xsb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hawanin, labay la yay na komon dakpon nin hilay pawpoon nin Israelita a nanita kona ta naintindyan la a hilay antokoyon na konan yadtaw alimbawa. Kot angkali-mo hila konlan malabong a tawo, kanya pino-layan la ya tana tan inomalih hilay na. ");
INSERT INTO xsb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hawanin, hilay pawpoon nin Israelita ay namihogo hilan omnoy paw-Pariseo tan omnoy tawon maka-Ari Herodes Antipas koni Jesus, para taktikawon la ya pigaw makahalita yan maari lan maikaso kona. ");
INSERT INTO xsb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kanya pa-makalato la itaw, wanla kona, “Maistro, tanda mi a maptog ka tan kay ka ampag-alangan ha hinoman ta kay mo anhilapon a katongkolan nin tawo. Potog yay an-itoro mon kalabayan nan Dios para ha tawo. Hawanin, anyay wamo: Marapat doman ayon ha kawkapanogoan nan Dios kontamon Israelita a mamayar nin bowis konan ari ha Roma a main hakop kontamo? ");
INSERT INTO xsb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kailangan wari a mamayar kami o kai?” Kot tanda ni Jesus a pa-magkonwari la, kanya wana konla, “Anongkot labay moyo kon hobokon? Torolan moyo kon a-say kwartan pilak ta biliwon ko.” ");
INSERT INTO xsb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tinorolan la yay naor, bi-sa pinastang na hila ni Jesus, wana, “Hino man lopa tan ngalan yadti iti?” Wanla kona, “Yay ari ha Roma.” ");
INSERT INTO xsb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanya wani Jesus konla, “Ibi moyo no-nin konan ari ha Roma yay ikon na, tan anorin anamaot kapara, ibi moyoy namaot konan Dios yay ikon na.” Naka-ngap hila koni Jesus, ta yay obat na ay ambo kontra konan ari tan ambo anamaot kontra konan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bi-sa main anamaot saw-Saduseo a nako koni Jesus. Hiladti yay gropon kay ampi-pol a main pa-morong mabyay. Pinastang la yay namaot hi Jesus, wanla, ");
INSERT INTO xsb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maistro, yay sinolat ni Moises a kapanogoan nan Dios kontamo ay ‘No nati yay a-say lalakin main kaambali nin homin hilan anak, kailangan yay talakaka nan yadtin nati ay ipagkaambali nay nabalon ayro na ta pigaw maibalô nan magkamain anak yay talakaka na a nati.’ ");
INSERT INTO xsb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hin yadtaw, main pitoy mita-talakakan lawlalaki. Nagkaambali yay kalingkakaan, kot nati yan homin hilan anak. ");
INSERT INTO xsb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kanya yay homonol a talakaka na a nagkaambali konan balo, kot nati yay namaot nin homin hilan anak. Anorin ot syimpri a nangyari ha pangatlo tan konlan hinomonol ot. ");
INSERT INTO xsb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Halban lan hiladtin pitoy mita-talakaka ay naipagkaambali la ya, kot pari-pariho hilan nati nin kay nagkamain anak. Hin hoyot, nati yay namaot a babayi. ");
INSERT INTO xsb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hawanin, no wari ta main pa-morong mabyay, hino man no-nin konla a makapag-ikon konan yadtaw babayi bilang kaambali na painsan? Nga-min, pari-pariho la yan impagkaambali nin hilay pito.” ");
INSERT INTO xsb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Wani Jesus konla, “Lawlingo kamo. Tanda moyo no anongkot? Bana ta kay moyo an-intindyon yay Masanton Kasolatan ni yay kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ha pa-morong mabyay ay kay hilay na mi-pagkaambali ta bilang hilay nan aw-anghil ha langit. ");
INSERT INTO xsb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kot tongkol ha pa-morong mabyay lan ni-kati, main kamo syimprin nabasa ha libro ni Moises tongkol ha nangyari ha maaypa a poon kayon andorta, hin wanan Dios koni Moises, ‘Hikoy Dios ni Abraham, Dios ni Isaac tan Dios ni Jacob.’ ");
INSERT INTO xsb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kot ambo yan Dios nin tawtawon nati, nokay Dios ya nin tawtawon angkabyay, labay totolon, an-itoring nan angkabyay hiladtin tolo. Kanya lingon-lingo kamo no halitaon moyon homin pa-morong mabyay.” ");
INSERT INTO xsb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hawanin, nalngo nin a-say maistron kapanogoan yay pa-maki-diskosyon lan saw-Saduseo koni Jesus. Hin na-kit na a mahosay na hilan inobat ni Jesus, dinomani ya kona ta pinastang na yay namaot, wana, “Anya kot yay pinakamaalagan kasogoan?” ");
INSERT INTO xsb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Wanan in-obat ni Jesus, “Oyay pinakamaalagan kasogoan: ‘Hikamoy aw-Israelita, paka-long-on moyodti: Yay Dios a Katawan tamo, hiyan bongat a Katawan. ");
INSERT INTO xsb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Labyon mo yay Katawan mon Dios nin asa-say nakom, nin mo-na ha main mon kalayaman, tan mo-na ot ha main mon pangingisip, tan nin halban kababaan mo.’ Yadti yay pinakamaalagan kasogoan.* ");
INSERT INTO xsb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oyay ikalwan maalagan kasogoan: ‘Labyon moy kapara nin bilang ha pa-manglabi mo ha sarili.’ Homin anan laloman kasogoan a mas maalaga konlan hiladtin lowa.” ");
INSERT INTO xsb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bi-sa wanan maistron kapanogoan koni Jesus, “Tama a hinalita mo, Maistro. Potog a yay Dios kot asa-sa, tan homin anan laloman Dios. ");
INSERT INTO xsb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bi-sa, no labyon yay Dios nin asa-say nakom, nin mo-na ha pangingisip, mo-na ha kalayaman, tan nin halban kababaan, bi-sa labyon ot yay kapara nin bilang ha pa-manglabi ha sarili ay holok yadti ha halban aw-ayop a popoolan para ida-ton ha Dios tan maskin anyaman ot a iibi kona.” ");
INSERT INTO xsb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hin na-kit ni Jesus a mahosay a obat na, wana kona, “Madani kay nan maibilang ha pa-mag-ari nan Dios.” Hin ya-rin ay homin anan nagkohaw nakom nin namastang koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hin ampangaral hi Jesus ha timplo, wana, “Anyay wamoyo konan yadti: An-itoro lan mawmaistron kapanogoan a yay Cristo kot lipi ni Ari David. ");
INSERT INTO xsb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kot ambo doman hi Ari David mismo a nanalita nin impanakom nin Masanton Ispirito nan Dios kona nin anodti: ‘Wanan Dios a Katawan koni Cristo a Katawan ko: Iti ka tomoklo ha wanan ko, Ta ta-ganan mon igwa ko ha aypa kapangyarian mo hilay kawkontra komo, a pa-hal mag-in hilan paparnaan ayi mo.’” ");
INSERT INTO xsb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wanan impagpatoloy ni Jesus, “Iti ay hina-wayan ni Ari David yay Cristo nin ‘Katawan’. Anyay wamoyo: Pa-no maari a Katawan na ya ta bi-sa lipi na ya ot?” Hilay tawtawo itaw ay nalilikot hilan nanglongo ha aw-aral ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Hawanin, ha pa-noro ni Jesus, wana konla, “Mag-ingat kamo konlan mawmaistron kapanogoan a mangailig mipa-pasyal nin nakadoloh mawmaanloh, tan labay-labay lan asikasowon hila ha pawplasa, ");
INSERT INTO xsb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tan mangailig hilan tomoklo ha ambo basta-bastan totokloan ha sawsinagoga tan ha kawkabisira ot no main hawhandaan. ");
INSERT INTO xsb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Antaktikawon lay bawbabayi a balo anggan makwa la pati na ingat a bali la, ta bi-sa ampa-paanlohon lay kada-dawat la pigaw kay ma-halata a gawgawa lan doka. Bana konan ya-rin a angga-gaw-on la, mas ambomyat ana ingat a parosa konla.” ");
INSERT INTO xsb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ninghan, tinomoklo hi Jesus ha tobon ampamidaboan kwarta ha timplo, ta an-imatonan nay lako a tawon ampamidabo nin kwarta itaw. Lako a mawmayaman a ampamidabo nin mawmahi-ban a alaga. ");
INSERT INTO xsb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kot main a-say pobrin babayin balo a nako itaw namidabo nin loway darinto a barya a ampag-alagan a-say sintimos. ");
INSERT INTO xsb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hawanin, pinadani ni Jesus hilay dawdisipolos na, ta wana konla, “Yay potog, ibalita ko komoyo, yadtaw indabo nan pobrin balo ay mas holok ha inimbi lan halban namidabo. ");
INSERT INTO xsb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nga-min, sawsobra lan bongat a indabo la, kot yay balo, maskin ampag-irap ya, inimbi na ot a ka-siya-siya nan ipagkabyay.” ");
INSERT INTO xsb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hin anlomikol hi Jesus ha timplo, main a-sa konlan dawdisipolos na a nanalita, wana, “Maistro, bilyon mo pa, hay kawkahi-banan bawbato nin timplo tan hay kagandawan nin bawbali a kahakopan nin timplo!” ");
INSERT INTO xsb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kot wanan in-obat ni Jesus kona, “Iya, angka-kit mo-rin mangahi-ban a bawbali. Balo ta lomato yay panaon a homin anan ma-bati ison ni a-say bato a nakababo ha laloman bato ta halban ay watakon.” ");
INSERT INTO xsb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bi-sa, hin itaw hilay na ha Bakil Olibo tan nakatoklo yay na hi Jesus nin angka-tamolaw nay timplo, dinomani hila ni Pedro, Santiago, Juan tan Andres nin hila-hilan bongat ta namastang hila kona. ");
INSERT INTO xsb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Wanla, “Ibalita mo pa komi no maka-no mangyari yadtaw imbalita mon watakon yay timplo tan anyay pamilbian ba-yo mangyari orin halban.” ");
INSERT INTO xsb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Inobat na hila ni Jesus kot binibilinan na hila yapon, wana, “Mag-ingat kamo pigaw kay kamo mailingo nin hinoman. ");
INSERT INTO xsb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nga-min, lako a mako komoyo a mangamit ngalan ko ta ibalita lan hila yay Cristo tan lako a tawtawon mailingo la. ");
INSERT INTO xsb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","No makalngo kamon lawlabanan tan bawbalita tongkol ha gawgira, ando kamo mahalak ta kailangan mangyari yapon orin. Balo ta ambo ot ya-rin a panganggawan nin babon lota. ");
INSERT INTO xsb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nga-min, milalaban a nangasasari a nawnasyon tan kawkaarian. Manglayon anamaot ha nangasasari a lawlogar tan magkamain bitil tan gawgolo. Kot ya-rin ay ompisan bongat nin masyadon pa-magdya-dya lan tawtawo a bilang ha ompisan pa-manglayam tiyan bi-sa mangabing. ");
INSERT INTO xsb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kot hikamoy antompol, mag-ingat kamo, ta main tawtawo a mamiintriga komoyo ha gawgropon ampamoon ha sawsinagoga a main katongkolan para manosga, bi-sa ipagaroti la kamo itaw. Iarap la kamo ot ha gawgobirnador tan ha aw-ari bana ha katotpol moyo kongko, balo ta mag-in oportonidad moyo-rin para maiabot konlay kaptogan tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nga-min, kailangan maipangaral yapon yay Labah a Balita ha tawtawo ha halban nasyon ba-yo manganggawan a mondo. ");
INSERT INTO xsb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ha oras a dinakop la kamo ta ipaimbistiga, ando kamo mag-aborido no anyay halitaon moyo o mangisip no anyay iobat moyo.* Ha pa-ngimbistiga la komoyo, halitaon moyo yay ipaisip komoyo konan ya-rin a oras, ta ambo mangibat ha sarili moyon isip a halitaon moyo nokay ha Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Main talakaka a ipapati nay talakaka na a antompol, o main matoantawo a ipapati nay anak na a antompol, tan anorin anamaot kapara ha awa-nak, lomaban hila ha matoantawo la a antompol anggan ha toloy hilan ipapati. ");
INSERT INTO xsb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tiplonon la kamon halban tawtawon kay antompol bana ha katotpol moyo kongko. Kot yay makapagpatoloy nin maptog kongko anggan ha oltimo ay malipyas.” ");
INSERT INTO xsb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wanan impagpatoloy ni Jesus, “Ma-kit moyo yay sangkarokaan a kapa-palayang a ampangibatan nin ambo bastan paninira a binanggit ni Propita Daniel hin yadtaw, ta ipa-dong ya ha timplo a ambo na komon dapat kamainan.” (Hikamoy ampamasa ay pakaintindyon moyodti!) “No mangyari na-rin a hola, hinoman a iti ha Judea ay kailangan tampol molayon omari ha bakil. ");
INSERT INTO xsb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hinoman a ma-palatan ha likol nin bali ay ando yay na mag-abala nin lomoob, para mangwa nin anyakaman a ma-wit. ");
INSERT INTO xsb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Anorin anamaot kapara ha hinoman a ma-palatan ha bowat, ando yay na mag-abala nin morong ot ha bali para mangwan dawdoloh na. ");
INSERT INTO xsb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka-ka-ro hilay ma-palatan malombit o ampamasoso konan ya-rin a panaon! ");
INSERT INTO xsb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dawaton moyo ha Dios a ando tana komon mitaon a kapo-polayo moyo ha panaon layop. ");
INSERT INTO xsb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nga-min grabin pa-magdya-dya a domalan ha tawtawo konan ya-rin a panaon. Ya-rin anay klasin pa-magdya-dya a kay ot na-nangyari, paibat hin pinalsa nan Dios a babon lota tan kay ana maolit maski mika-ka-noman. ");
INSERT INTO xsb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No ya-rin a panaon nin pa-magdya-dya kot kay na paantoron nin Katawan, homin tawon makalibri. Kot alang-alang konlan tawtawon pinili na ay paantoron na-rin. ");
INSERT INTO xsb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Hawanin, no wari ta main mamibalita komoyo, ‘Iti yay na hi Cristo!’ o kari wana, ‘Itaw ya!’ ay ando moyo ya pi-polon. ");
INSERT INTO xsb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nga-min, main lomato a magkonwari a hila kano hi Cristo, tan hilay namaot a laloma ay magkonwari hilan pawpropita nan Dios. Pa-kitan la kamon gawgawa a kawka-paka-ngap a pamilbian kapangyarian nan Dios para mailingo la, no maari bongat, pati hilay tawtawon pinili nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kanya mag-ingat kamo ta impao-na koy nan impatandaan komoyo yadtin halban bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Wana ot ni Jesus, “Pa-makayari nin ya-rin panaon pa-magdya-dya, Domoblom yay awlo, Kay homawang yay bolan, ");
INSERT INTO xsb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mi-kadabo anamaot a bawbitoon, Tan yay lawlaloma ot ison ha ta-gay ay mi-kayogyog tan maalih ha andalanan la. ");
INSERT INTO xsb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bi-sa hiko a Naglalaman Tawo ay ma-kit lan amponaoy nin iti ha lolom nin main ambo bastan kapangyarian tan karangalan. ");
INSERT INTO xsb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bi-sa ihogo ko hilay aw-anghil ha a-pat a diriksyon nin babon lota, para tiponon lay tawtawon pinili ko maibat ha halban lawlogar.” ");
INSERT INTO xsb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wanan impagpatoloy ni Jesus, “Intindyon moyoy aral ibat ha poon igos: No ma-kit moyoy nan ampanarok tan ampama-yon bolong, tanda moyo a madani nay panaon abagat. ");
INSERT INTO xsb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Anorin anamaot kapara, no ma-kit moyon ampangyari nadtin bawbagay a impatandaan ko ay ma-tandaan moyo a madani koy nan lomato, bilang akoy nan iti ha polta. ");
INSERT INTO xsb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yay potog, ibalita ko komoyo, ha tawtawon angkabyay hawanin panaon ay main ot angkabyay, anggan kay mangyari yadtin halban bawbagay. ");
INSERT INTO xsb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Manganggawan a langit tan lota, balo ta yay hawhalita ko ay homin pa-ngapaso.” ");
INSERT INTO xsb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Wana ot ni Jesus, “Ma-kit moyoy pamilbian nin pa-mako kon oman iti, balo ta homin magtanda no anya mag-awlo o anyay oras a ilato ko, maskin hilay aw-anghil ha langit ni hiko a Anak nan Dios. Yay Ama ha langit bongat a magtanda. ");
INSERT INTO xsb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kanya mag-ingat kamo, pirmi kamon handa tan domawat ta kay moyo tanda no maka-no odti mangyari. ");
INSERT INTO xsb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Hiko a Naglalaman Tawo ay bilang ot bongat ha a-say lalakin mako ha madayo a logar. Ba-yo ya omalih ha bali ay impa-taya nay kawkama-main na konlan ma-magsirbi na ta binyan na hilan hiyo-san gawa. Bi-sa imbibilin na ha gwardya a lawah yan tomala-ran ha kala-lato na. ");
INSERT INTO xsb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Anorin anamaot kapara komoyo, dapat pirmi kamon handa ta yay kala-lato ko ay bilang konan yadtin main ikon bali a homin magtanda no maka-no ya lomato, maari bandan yabi, botlay yabi, palbangon o kari boklah. ");
INSERT INTO xsb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ha bigla kon kala-lato, ola-no ma-lato katamon ambo handa a bilang ha a-say ma-magsirbi a nakaka-lok. ");
INSERT INTO xsb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yay an-ibalita ko komoyo ay para ha halban tawo: Tomala-ran kamo.” ");
INSERT INTO xsb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hin ya-rin ay loway awlo tana ba-yo Pistan Pa-makalibri, a ompisay namaot nin manglinggon Pistan Tinapay a Homin Pampalbag. Konan ya-rin a awlo, pinipapa-nowan lan pawpoon pari tan mawmaistron kapanogoan, no pa-no la maipadakop hi Jesus nin homin magtanda ta pigaw maipapati la ya. ");
INSERT INTO xsb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kanya wanla, “Ando tamo itaon ha pista ta ola-no magkagoloy tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hawanin, hin itaw ya hi Jesus ha baryon Betania ha bali ni Simon a datin nagmasakit kitong, main nakalato a-say babayi a main awit nin mablin klasin pabanglo a poron nardo a nakaigwa ha botin gawa ha alabastro. Lo-gan yan ampakirongon ampangan hi Jesus, himpak nan babayi yay tampoh nin boti ta imbo-bo nay pabanglo ha olo ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kot main omnoy nasora, wanla ha a-sa tan a-sa, “Anongkot sinayang na-rin pabanglo? ");
INSERT INTO xsb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ya-rin klasin pabanglo ay mailako nin maholok ot ha alagan opa nin tolonyatos a awlo ta bi-sa maibi komon yay ma-paglakoan konlan mangairap.” Bi-sa sinita la yay babayi. ");
INSERT INTO xsb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kot wani Jesus, “Po-layan moyo yan bongat. Anongkot anggolo-golowon moyoy isip na? Labah odtin ginwa na kongko. ");
INSERT INTO xsb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hilay mangairap ay pirmi moyon maipagkalamoan tan ma-tambayan ha anyakaman a oras a labay moyo. Kot hiko, maantor tanay panaon a maipagkalamoan moyo ko. ");
INSERT INTO xsb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ginwa nay kababaan na. Bilang imparihado nay nan daan a lalaman ko para ha pa-nabon kongko. ");
INSERT INTO xsb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yay potog, ibalita ko komoyo, ha aytimay logar ha intiron mondo a ipangaral yay Labah a Balita tongkol kongko ay ma-panomtoman yadtin babayi ta mabanggit yay ginwa na kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Hi Judas Iscariote a a-sa konlan labinloway disipolos ni Jesus ay nako konlan pawpoon pari para pagtraidoran na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hin nalngo lay imbalita na, nalilikot hila tan pinangakoan la yan biyan kwarta. Kanya nana-gan yay nan tyimpo para ma-pagtraidoran na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hin ya-rin ay nakalato anay awlon Pistan Pa-makalibri a o-nan awloy namaot nin manglinggon Pistan Tinapay a Homin Pampalbag. Konan ya-rin a awlo, kailangan mangmatin karniro para pangaponan, kanya pinastang la hi Jesus nin dawdisipolos na, wanla, “Ayti may labay mon pamihandaan min pangaponan tamo para ha pista?” ");
INSERT INTO xsb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nanogo yan loway disipolos na, wana konla, “Mako kamo ha syodad ta main kamon ma-hakbat a-say lalaki itaw a main awit a-say banga a lanom. Homonol kamo kona. ");
INSERT INTO xsb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","No ayti balin looban na, wamoyo konan main ikon bali, ‘An-ipapastang nan Maistro no ayti kanoy logar a ma-pagsilibrawan na nin Pistan Pa-makalibri, nin kalamo kamin dawdisipolos na.’ ");
INSERT INTO xsb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bi-sa ipa-kit na komoyoy a-say malawang a kwarto ha ta-gay a nakahanda ana tan komplito ha gawgamit. Itaw moyo ihanda a pangaponan tamo.” ");
INSERT INTO xsb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nako hilay nay disipolos ha syodad Jerusalem, bi-sa anodtaw anaor a na-kit la a bilang ha hinalita ni Jesus konla. Kanya inhanda lay pangaponan la ha pista. ");
INSERT INTO xsb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hin yabi na, nako hilay na ni Jesus konan yadtaw bali kalamo na hilay labinloway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hin ampirorongo hilay nan ampangan, wani Jesus, “Yay potog, ibalita ko komoyo, a-sa komoyon kalamo kon ampangan a magtraidor kongko.” ");
INSERT INTO xsb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nilomolo hilay dawdisipolos na, kanya a-sa a-sa hilan namastang koni Jesus, wanla, “Hiko doman?” ");
INSERT INTO xsb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wani Jesus konla, “A-sa komoyon labinlowa a kalamo kon ampamidoldol tinapay ha yaong. ");
INSERT INTO xsb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Hiko a Naglalaman Tawo ay mati ayon ha nakasolat tongkol kongko, balo ta ka-ka-roy ogotan nin yay tawon magtraidor kongko! Labah ot a kay yay na komon impangabing.” ");
INSERT INTO xsb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hin ya-rin ampangan hila, nangwa yan tinapay hi Jesus. Pa-makayari nan pinasalamatan yay Dios, pini-pikna na bi-sa intorol na konlan dawdisipolos na, ta wana, “Mangwa kamo ta kanon moyo. Yadti a lalaman ko.” ");
INSERT INTO xsb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bi-sa nangwa yay namaot nin a-say kopa. Pa-makayari nan pinasalamatan yay Dios, inimbi na konlan dawdisipolos na, bi-sa ninom hilay halban. ");
INSERT INTO xsb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wana konla, “Yadti a daya kon tomolo para ha lako a tawo a pangibatan nin ba-yon kasondoan nan Dios ha tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yay potog, ibalita ko komoyo, kay koy na minom oman nin anodtin inomon a ibat ha obas, anggan ha lomato a panaon a minom akon ba-yon klasin alak itaw ha kaarian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bi-sa pa-makayari lan nagkanta nin pamomori ha Dios ay inomalih hilay nan mako ha Bakil Olibo. ");
INSERT INTO xsb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hin ya-rin, wani Jesus konlan dawdisipolos na, “Yadtin yabi, halban moyo ay ibati moyo ko, ta wanay naor Dios ha Masanton Kasolatan, ‘Aboloyan kon patyon yay pa-hal pastol, kanya hilay pa-hal kawkarniro na ay miboyak.’ ");
INSERT INTO xsb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anodtaw pa man, morong akon mabyay, bi-sa mo-na ko komoyo ha Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wani Pedro kona, “Maski man ibati la kan hiladtin halban, kay kata nga-min ibati.” ");
INSERT INTO xsb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kot wani Jesus kona, “Yay potog, ibalita ko komo, yadti ot a yabi ba-yo tomaran-ok milway bisis a manok ay mitloy bisis mo kon iporlingor.” ");
INSERT INTO xsb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kot wanan pinagtiboyan ni Pedro, “Maskin pati hiko patyon la, kay kata iporlingor.” Anorin anamaot a wanlan halban disipolos na. ");
INSERT INTO xsb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hawanin, niabot hilay na ni Jesus ha a-say logar ha Bakil Olibo a anha-wayan Getsemani. Bi-sa wana konlan disipolos na, “Tomoklo kamo yapon iti ta mako ko domawat.” ");
INSERT INTO xsb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Inawit nan impagkalamoan hi Pedro, hi Santiago tan hi Juan. Tongwa, bigla yan nilomolo hi Jesus tan golo-goloy isip na. ");
INSERT INTO xsb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kanya wana konla, “Masyadoy kaloloan ko, halos kon ikamati. Iti kamo tana tan magpoyat kamoy namaot.” ");
INSERT INTO xsb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dinomayô yan daoto, bi-sa nanalimokor yan palokob ta indawat na a no maari komon ay kay nay na dalanan yay pa-magdya-dya. ");
INSERT INTO xsb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wana, “O Ama ko, halban bagay ay mababa mon gaw-on. Komon alihon modtin an-arapon kon pa-magdya-dya. Kot anodtaw pa man, ambo yay kalabayan koy mangyari, nokay yay kalabayan mo.” ");
INSERT INTO xsb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bi-sa, hin nagbolta ya konlan toloy disipolos na ay na-lato na hilan angka-lok. Wana koni Pedro, “Simon, nakaka-lok ka payti. Kay mo doman magawa nin magpoyat maskin a-say oras? ");
INSERT INTO xsb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tomalan kamo tan domawat pigaw kay kamo matokso. Mahi-ban a nakom moyon homonol, kot kay mababa nin sarili moyo.” ");
INSERT INTO xsb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bi-sa dinomayô yay naman hi Jesus ta dinomawat yay naman nin bilang ha o-nan indawat na. ");
INSERT INTO xsb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bi-sa, hin kina nan oman hilay toloy disipolos na, na-lato na hilay naman nin angka-lok ta masyado hilan namatongga. Hin napokaw hila ay kay la tanda a iobat la kona. ");
INSERT INTO xsb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bi-sa nako yay naman dinomawat. Ha pamitlon pa-magbolta na, na-lato na hilay naman nin angka-lok. Kanya wana konla, “Angka-lok kamo ot? Ampagpainawa kamo ot anggan hawanin? Tama ana. Nilomato anay oras a hiko a Naglalaman Tawo kot iintrigay na konlan tawtawon makasalanan. ");
INSERT INTO xsb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mibangon kamoy na ta lomato yay nay magtraidor kongko. Hakbaton tamo hila.” ");
INSERT INTO xsb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tongwa, lo-gan ya ot ampanalita hi Jesus, anlomato yay nay naor hi Judas a a-sa konlan labinloway disipolos na. Kalamo nay lako a tawon main awit bawbonong tan pawpapatok a inhogo lan pawpoon pari, mawmaistron kapanogoan tan hilay pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Binyan na hilay nan daan ni Judas a magtraidor nin pamilbian, a wana, “Yay alokan ko, yadtaw a dakpon moyo, awiton moyo ya tan paka-bantayan.” ");
INSERT INTO xsb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pa-makalato ni Judas itaw, antimano dinomani ya koni Jesus, ta wana, “Maistro! Maistro!” Bi-sa inalokan na ya. ");
INSERT INTO xsb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hilay namaot a kawkalamoan ni Judas ay binombonan la yay na hi Jesus ta dinakop. ");
INSERT INTO xsb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kot a-sa konlan naka-dong itaw ay nangoyoh nin bonong na, ta tinabtab nay alila nan pinakapoon pari. Kot totolyan a natigpah na. ");
INSERT INTO xsb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bi-sa wani Jesus konla, “Tolisan ako doman ta nangawit kamo ot bawbonong tan pawpapatok ha pa-nakop moyo kongko? ");
INSERT INTO xsb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Anta awlo-awlo moyo kon kalamo hin ampanoro ako ha timplo, kot kay moyo ko dinakop. Kot anodti dapat mangyari pa-maptog ha imbalita ha Masanton Kasolatan.” ");
INSERT INTO xsb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hin ya-rin, halban lan disipolos na ay nipo-polayo ta imbati la ya. ");
INSERT INTO xsb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hin an-awiton lay na hi Jesus, main a-say anakaba-yo a tinomombok konla. Kay ya nakadoloh, nokay nakaalimonmon yan bongat nin pinon tilan mapoti. Hinampat la yan aw-anakaba-yo, ");
INSERT INTO xsb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kot imbati nay alimonmon na, tan nolayo yan homin doloh. ");
INSERT INTO xsb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hawanin, inawit la hi Jesus ta in-oli la ya ha bali nan pinakapoon pari. Itaw hila nititipon a halban pawpoon pari, pawpoon nin Israelita tan mawmaistron kapanogoan a pari-parihon myimbro nin pinakamata-gay a konsiho nin nasyon Israel. ");
INSERT INTO xsb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hi Pedro namaot ay mato-totombok nin main karayoan, anggan ha patyo nan pinakapoon pari. Itaw ya naki-toklo konlan gwardya ta ampalanglang ha pinartan timbon. ");
INSERT INTO xsb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hilay namaot a pawpoon pari tan halban anan myimbro nin pinakamata-gay a konsiho ay naningkap nin tawtawon tomistigo laban koni Jesus pigaw la ya maipapati. Kot homin ha hinalita lan tawtistigo a magamit la. ");
INSERT INTO xsb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nga-min, maskin lako hilay nagtistigon kawkagalotoyan laban kona, kay syimpri angka-pitotogma a anhalitaon la. ");
INSERT INTO xsb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bi-sa main anaman omnoy inomdong ta nagtistigo hilay namaot nin kagalotoyan laban kona, wanla, ");
INSERT INTO xsb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nalngo min hinalita nay anodti: ‘Yobaon kodtin timplo a gawa nin tawo, ta ha loob nin toloy awlo ay mamipa-dong akon laloma a ambo gawa nin tawo.’” ");
INSERT INTO xsb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maskin anorin a imbalita la, kay ot syimpri na-pitotogma a intistigo la. ");
INSERT INTO xsb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hawanin, inomdong yay pinakapoon pari ha arapan la ta pinastang na hi Jesus, wana, “Anyay maiobat mo konan ya-rin riklamo la komo?” ");
INSERT INTO xsb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kot namakatinok hi Jesus, kay ya inombat. Pinastang na yay naman nin pinakapoon pari, wana, “Hika doman yay Cristo, yay Anak nan Dios a sangkaabigan?” ");
INSERT INTO xsb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Inombat hi Jesus, “Iya, hiko,” wana, “tan ma-kit moyo ko, hiko a Naglalaman Tawo nin nakatoklo ha wanan nan Dios a Makapangyayari tan ma-kit moyo ko ot lomato nin iti ha lolom.” ");
INSERT INTO xsb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yadtin pinakapoon pari, ha ka-motan olo na bana ha pa-mipantay ni Jesus nin sarili na ha Dios ay winakwak nay sarili nan doloh, tan wana, “Anongkot kailangan tamo ot a tawtistigo? ");
INSERT INTO xsb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nalngo moyoy pa-masta-basta na ha Dios. Anyay disisyon moyo?” Yay sintinsyan inimbi lan halban ay kamatyan. ");
INSERT INTO xsb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bi-sa inompisawan la yay nan niloraan nin hilay laloma tan pinorongan lay mata na. Ba-yo bino-bogbog la ya, ta wanla kona, “Holaan mo pa no-nin, no hino-hinoy ampamogbog komo.” Bi-sa tina-tampal la ya ot nin gawgwardya. ");
INSERT INTO xsb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hin itaw ya ot hi Pedro ha aypa ha patyo, main a-say babayin alila nan pinakapoon pari a nako itaw. ");
INSERT INTO xsb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pa-maka-kit na koni Pedro a ampalanglang, hinilap na yan hosto, bi-sa wana kona, “A-sa kay namaot ha kalamoan ni Jesus a taga Nazaret.” ");
INSERT INTO xsb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kot imbori nadti ni Pedro, ta wana, “Kay ko tanda ni angkaintindyan no anyay labay mon totolon.” Bi-sa nako ya ha poltan balaybay. Tongwa, tinomaran-ok a manok. ");
INSERT INTO xsb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hin na-kit na yay naman itaw nin yadtaw babayi, wana konlan tawtawo itaw, “Yadtin tawo ay a-sa ya ha kawkalamoan ni Jesus!” ");
INSERT INTO xsb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kot imbori nay naman ni Pedro. Na-paongganan daoto, wanla kona nin hilay naka-dong itaw, “Sigoradon a-sa ka ha kawkalamoan ni Jesus, ta mapatnag ha pa-nalita mo a taga kay namaot Galilea.” ");
INSERT INTO xsb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hin ya-rin ay nagho-hompa yay na hi Pedro, wana, “Maski parosawan na kon Dios, talagan ambo kon bilbi ya-rin a tawon anha-halitaon moyo!” ");
INSERT INTO xsb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tongwa, tinomaran-ok yay naman a manok nin ikalwan bisis. Hawanin, na-panomtoman ni Pedro yay hinalita ni Jesus kona, a wana, “Ba-yo tomaran-ok milwa yay manok, mitloy bisis mo kon iporlingor.” Kay nay na na-bonbonan ni Pedro a sarili na, kanya tinomangih yan hosto. ");
INSERT INTO xsb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kapi-piboklah ot, hilay pawpoon pari, pati hilay pawpoon nin Israelita, hilay mawmaistron kapanogoan tan halban lan lawlaloma ot a mawmyimbro nin pinakamata-gay a konsiho nin nasyon Israel ay nititipon ta nagplano no pa-no la ya maipapati hi Jesus. Yay ginwa la ay impabalol la ya, ta bi-sa inawit koni Gobirnador Pilato a taga Roma. ");
INSERT INTO xsb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hawanin, pinastang na ya ni Gobirnador Pilato, wana, “Hika doman a Ari lan Israelita?” Wanan in-obat ni Jesus, “Nahalita moy na.” ");
INSERT INTO xsb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bi-sa binaraan la yan pawpoon pari nin lako a bawbagay. Kot kay ya nanlok. ");
INSERT INTO xsb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pinastang na yay naman ni Gobirnador Pilato, wana, “Homin ka doman ma-halita? Anta kalakan riklamo la komo.” ");
INSERT INTO xsb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kot kay yay na inombat hi Jesus, kanya naka-ngap hi Gobirnador Pilato. ");
INSERT INTO xsb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taon-taon, no Pistan Pa-makalibri nin Israelita, nakaogalian a yay gobirnador la a taga Roma ay ampamiboloh nin a-say priso, ayon ha dawaton nin tawtawo. ");
INSERT INTO xsb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hin ya-rin, main a-say priso a yay ngalan Barabbas. Nakapriso yan kalamo nin omnoy nilomaban ha gobyirno a nangmati ha kala-laban la. ");
INSERT INTO xsb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hawanin, ni-pako hilay tawtawo koni Gobirnador Pilato ta dinawat la ha makhaw a bosis a mamiboloh yan a-say priso bilang nakaogalian nan gaw-on para konla. ");
INSERT INTO xsb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kanya pinastang na hila ni Gobirnador Pilato, wana, “Labay moyo wari a yay Ari moyon Israelita a bolohan ko?” ");
INSERT INTO xsb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pinastang nadtaw ta naintindyan na a angkainggitan lan pawpoon pari hi Jesus, kanya la ya in-intriga. ");
INSERT INTO xsb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kot sinolsolan lan pawpoon pari hilay tawtawo itaw a ambo hi Jesus nokay hi Barabbas a dawaton lan bolohan. ");
INSERT INTO xsb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hin anorin a obat la, pinastang na hilay naman ni Gobirnador Pilato, wana, “Anya man no-nin a labay moyon gaw-on ko konan yadtin tawon anha-wayan Ari moyon Israelita?” ");
INSERT INTO xsb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Inomaghaw hilay naman, wanla, “Ipasak ya ha kros!” ");
INSERT INTO xsb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kot wani Gobirnador Pilato konla, “Anongkot, anya kot a nagawa nan karokaan?” Kot lalo lan in-aghaw, wanla, “Ipasak ya ha kros!” ");
INSERT INTO xsb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ha kalabayan ni Gobirnador Pilato a ma-pakonswilo hilay tawtawo ay impapiboloh na hi Barabbas, balo ta hi Jesus ay impalatigo na. Bi-sa in-intriga na ya ha omnoy hondalo a taga Roma para ipasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hawanin, hiladtin hondalo ay inloob la hi Jesus ha ampagkampowan la ha palasyo nan gobirnador, bi-sa tinipon lay halban kawkalamoan lan hondalo. ");
INSERT INTO xsb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinadolohan la yan kolor obi ta konwari ari ya. Namayokal hilan hangan marowih ta inkorona la kona. ");
INSERT INTO xsb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bi-sa sina-salodowan la ya, wanla, “Viva yay Ari lan Israelita!” ");
INSERT INTO xsb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bi-sa pina-pahpah la yan talaib ha olo, nilora-loraan tan tina-talimokoran. ");
INSERT INTO xsb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hin nayari la yan tinoya-toya, nilohpok lay impadoloh la konan kolor obi ta impaholot lay sarili nan doloh. Bi-sa inawit la yay na para ipasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hin anlomikol hilay na ha syodad Jerusalem, na-hakbat lay a-say lalaki a nangibat ha baryo a hi Simon a taga Cirene, yay tatay ni Alejandro tan ni Rufo. Pinilit la yan hawhondalo a balatayon nay kros ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inawit la hi Jesus ha Golgota, (yay labay totolon “Logar nin Bongo”). ");
INSERT INTO xsb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pa-makalato la itaw, binyan la yan alak obas a nilaokan mapait a makatambal hakit, kot kay na ininom. ");
INSERT INTO xsb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hin naipasak la yay na ha kros, pini-bonotan lan hawhondalo no anya ha dawdoloh ni Jesus a maipag-ikon nin balang a-sa. ");
INSERT INTO xsb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebe nin boklah hin ya-rin a impasak la ya ha kros. ");
INSERT INTO xsb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bi-sa anodti a nakapaskin ha ta-gay kros a bara-nan nin pa-mangmati kona: “Yay Ari nin Aw-Israelita.” ");
INSERT INTO xsb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Main anamaot loway tolisan a impasak la ha kros, yay a-sa ha bandan wanan ni Jesus tan yay a-sa ha bandan wili na. ");
INSERT INTO xsb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Kanya pinomtog yay wana ha Masanton Kasolatan, “Imbilang la yan tawon makasalanan.” ");
INSERT INTO xsb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bi-sa, hilay tawtawon anlomabah ay tinoya-toya la yan main ot awit a poyong olo. Wanla, “O, wamo, yobaon moy timplo ta ba-yo ipa-dong mon oman ha loob nin toloy awlo. ");
INSERT INTO xsb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Di ilipyas mo no-nin a sarili mo, omaypa ka ison ha kros.” ");
INSERT INTO xsb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tinoya-toya la yay namaot nin hilay pawpoon pari tan mawmaistron kapanogoan, wanla ha a-sa tan a-sa, “Inlipyas na hilay laloma, kot mismon sarili na ay kay na mailipyas. ");
INSERT INTO xsb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","No ma-kit tamon bongat a magtatangtang ha kros ya-rin a Cristo a Ari nin Israel, mi-pol tamoy na.” Maskin hilay impasak anamaot ha kros nin kasabay na ay tinoya-toya la yay namaot. ");
INSERT INTO xsb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pa-mag-ogtiawlo, dinomoblom a intiron nasyon anggan manga alas tres nin apon. ");
INSERT INTO xsb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hin ya-rin a bandan alas tres, wanan in-aghaw ni Jesus, “Eloi, Eloi, lema sabachthani?” yay labay totolon, “Dios ko, Dios ko, anongkot mo ko ampo-layan?” ");
INSERT INTO xsb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hin nalngo la-rin nin omnoy tawon nakaodong itaw, kay la naintindyan, ta wanla, “Oy, anha-wayan na hi Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bi-sa nolayo yay a-sa konla ta namisawsaw yan ispongha ha maalhom a alak obas. Inigwa na ha tampoh nin talaib, ta bi-sa impahophop na koni Jesus. Wana, “Ta-gan ta biliwon tamo no kaon na yan iaypa ni Propita Elias.” ");
INSERT INTO xsb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tongwa inomaghaw hi Jesus, bi-sa nabtahan yay na. ");
INSERT INTO xsb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hin ya-rin, yay kortina ha botlay nin timplo ay bigla nagi-nit ha botlay paibat ta-gay anggan aypa. ");
INSERT INTO xsb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yay kapitan lan hawhondalo a ampagbantay koni Jesus ay nakaarap kona. Hin na-kit nan anodtaw a kaaaghaw ni Jesus ha pa-ngamati na, wana, “Talagan Anak yan Dios yadtin tawo!” ");
INSERT INTO xsb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Main anamaot bawbabayi itaw a ampanamolaw hin ya-rin. Kabilang konla hi Maria Magdalena, hi Salome tan hi Maria a nanay ni Santiagon malago tan ni Jose. ");
INSERT INTO xsb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Hila yay anhomonol tan ampagsirbi koni Jesus, hin itaw ya ot ha probinsyan Galilea. Hilay namaot laloman bawbabayi a itaw ay hiladtaw a naki-ka koni Jesus hin hoyot nan nako ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hin ya-rin ay Byirnis a awlon pa-magparihado para ha Awlon Pa-mainawa. Hin maaaypa anay awlo, ");
INSERT INTO xsb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","hi Jose a taga babalin Arimatea, a-say anggalangon a myimbro nin pinakamata-gay a konsiho nin nasyon Israel, tan ampana-gan anamaot ha lomato a pa-mag-ari nan Dios ay nagkohaw nakom yay nan nako koni Gobirnador Pilato ta dinawat nay bangkay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nag-ispanta hi Gobirnador Pilato ta kay na ola-lomon a nati yay na hi Jesus. Kanya impaha-wayan na yay kapitan nin hondalo ta pinastang na ya no talagan nati yay na. ");
INSERT INTO xsb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hin na-tandaan na konan kapitan a nati yay na hi Jesus, pinayagan nay nan kowon ni Jose a bangkay. ");
INSERT INTO xsb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kanya nanaliw yan pinon tilan mapoti, bi-sa in-aypa nay bangkay ni Jesus ha kros ta pinotot na yan ya-rin a tila. Bi-sa inggawa na ya ha a-say panabonan a impakwiba ha bakil a bato. Pa-makayari ay intolir nay malapar a bato ta impanara na ha pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na-kit la ni Maria Magdalena tan hi Maria a nanay ni Jose no ayti la intabon hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kinasabadowan, hin hinomlop anay awlo a pamilbian a nayari anay Awlon Pa-mainawa, hi Maria Magdalena, hi Salome tan hi Maria a nanay ni Santiago ay nanaliw hilan tawtambal a mabanglon pambalsamo, ta kaon lan ponahan yay bangkay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kinadilapan, awlon Dominggo, kapi-pihila nin awlo ay nako hilay na ha pinanabonan koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hin iti hila ha dalan, wanla ha a-sa tan a-sa, “Hino kari a ma-patolir tamo nin yadtaw malapar a baton impanara ha pinanabonan?” ");
INSERT INTO xsb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kot hin biniliw la, na-kit la a naitolir ana yadtaw bato a malapar. ");
INSERT INTO xsb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bi-sa, hin nilomoob hila ha pinanabonan, na-kit la a main nakatoklo ha bandan wanan a a-say anakaba-yo a nakaholot nin maanloh tan mapoti a ayhing. Nali-mo hilay babayi. ");
INSERT INTO xsb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kot wanan anakaba-yo konla, “Ando kamo mali-mo. Tanda kon antingkapon moyo hi Jesus a taga Nazaret a impasak ha kros. Kay yay na iti ta norong yay nan nabyay. Biliwon moyoy pinamigaw-an kona. ");
INSERT INTO xsb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mako kamoy na ta ibalita moyo konlan dawdisipolos na, pati koni Pedro, yay anodti: ‘Mo-na ya komoyon mako ha Galilea. Itaw moyo ya ma-kit ayon ha imbalita na komoyo hin yadtaw.’” ");
INSERT INTO xsb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tampol hilan inomalih a bawbabayi ha pinanabonan bi-sa nolayo. Anggoygoy hila ta masyado hilan ampag-ispanta. Tan homin hilan imbalita ha hinoman bana ha main lan kali-mowan. ");
INSERT INTO xsb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hin norong yan nabyay hi Jesus, kapi-piboklah nin ya-rin awlon Dominggo, o-na yan nagpa-kit koni Maria Magdalena, yadtaw pinamalayahan nan pitoy doka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hawanin, nako hi Maria Magdalena konlan datin kawkalamoan ni Jesus a mawmalolo tan antomangih hin ya-rin, ta imbalita na a norong nabyay hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kot kay hila naki-pol ha imbalita na a norong nabyay hi Jesus tan nagpa-kit ya kona. ");
INSERT INTO xsb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bi-sa nagpa-kit yay naman hi Jesus ha laloman itsora ha lowa konlan dati nan kawkalamoan a hin ya-rin kot anlalakon nangibat ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kanya nagbolta hiladtin lowa ta imbalita la konlan laloman kawkalamoan la, kot kay hila syimpri naki-pol. ");
INSERT INTO xsb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na-paongganan, nagpa-kit hi Jesus konlan mismon labin-a-say apostolis na hin ampirorongo hilan ampangan. Pinangaralan na hila bana ha kay la pa-mi-pol tan bana ha katiboyan olo la, ta kay hilay naor naki-pol konlan naka-kit kona, hin pa-makayari nan norong nabyay. ");
INSERT INTO xsb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bi-sa wana konla, “Mako kamo ha intiron mondo ta ipangaral moyo yay Labah a Balita ha halban tawo. ");
INSERT INTO xsb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yay tompol tan ma-baotismowan ay malipyas, kot yay kay tompol ay parosawan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hilay antompol kongko ay magkamain nin anodtin pawpamilbian nin kapangyarian: Ha ngalan ko ay maka-palayah hilan dawdoka a ispirito, makahalita hilan lawlaloman klasin halita, ");
INSERT INTO xsb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","maskin maka-hampat hilan olay o makainom nin lason ay kay hila maano, tan iparna lan bongat a gamot la ha mawmain masakit ay omabig hilay na.” ");
INSERT INTO xsb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hawanin, pa-makayari nan nanalita yay Katawan konlan dawdisipolos na, noli ya ha langit, ta bi-sa tinomoklo ya ha wanan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hilay namaot a dawdisipolos na ay nakoy naor nangaral ha halban logar. Tinambayan na hila nin Katawan tan pinaptogan nay an-ipangaral la ha kawka-paka-ngap a gawa la a pamilbian nin kapangyarian nan iti konla. Amen. 9 Nako hilay bawbabayi koni Pedro tan konlan kawkalamoan na ta tinotol la yay halban imbalita nan yadtaw lalaki ha pinanabonan. 10 Pa-makayari nin yadti, inhogo ni Jesus hilay halban apostolis na ha intiron mondo para ipangaral yay masagrado tan kay homin pangongopah a balita tongkol ha kalipyasan a kay manganggawan.");
INSERT INTO xsb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anggalangon kon talakaka Teofilo, Lako anay tawtawon nanolat nin bawbagay tongkol koni Jesus a kay ot naboyot nangyari iti kontamo. ");
INSERT INTO xsb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yay sinolat la ay yadtaw imbalita la komi nin mismon hilay paibat hin ompisa kot nakaimaton konan yadtin ni-pangyari tan nangaral nin Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hiko man, mapagalang a talakaka Teofilo, bana ta pinag-aralan kon labah odtin halban nangyari tongkol koni Jesus paibat hin ompisa, naisipan ko a labah no isolat kodti komo nin maayos ");
INSERT INTO xsb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pigaw ma-tandaan mo a talagan kaptogan yay bawbagay a intoro komo tongkol koni Jesu-Criston Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hin hi Herodes a ari nin probinsyan Judea, main a-say pari nin Israelita a yay ngalan na ay Zacarias. A-sa ya ha gropo ni Abias. Yay kaambali na ay hi Elisabet a ibat anamaot ha lipi ni Aaron a pinangibatan nin halban pawpari lan Israelita. ");
INSERT INTO xsb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hiladtin miambali ay parihon maptog ha hilap nan Dios a Katawan, tan homin hilan pa-magkolang ha kaho-honol la ha halban kawkapanogoan tan rawriglaminto na. ");
INSERT INTO xsb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Homin hilan anak bana ta baog hi Elisabet tan pariho hilay nan matokling. ");
INSERT INTO xsb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ninghan, itaw hi Zacarias ha Jerusalem nin ampagsirbi ha Dios ta nakalato a panaon nin pa-magsirbi lan pawpari ha gropo na. ");
INSERT INTO xsb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ayon ha kaogalian lan pawpari ay ampamonot hila pigaw ma-tandaan no hino ha gropo la a dapat lomoob ha timplo nan Dios para mamool nin insinso. Hin ya-rin ay hi Zacarias a naka-bonot, kanya hiya a nilomoob para mamool nin insinso. ");
INSERT INTO xsb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hin ya-rin a oras pamomool nin insinso, hilay namaot a tawtawo ay itaw ha likol timplo nin andomawat. ");
INSERT INTO xsb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tongwa, main a-say anghil nan Katawan a nagpa-kit koni Zacarias. Itaw ya naka-dong ha bandan wanan nin altar a ampamoolan insinso. ");
INSERT INTO xsb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pa-maka-kit ni Zacarias konan anghil ay na-biglaan ya tan na-li-mowan. ");
INSERT INTO xsb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kot wanan anghil kona, “Ando ka mali-mo, Zacarias ta nilngo nan Dios yadtaw dawat mo. Yay kaambali mon hi Elisabet ay mangabing yan a-say lalaki. Yay ipangalan mo kona ay Juan. ");
INSERT INTO xsb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yadtin pa-miabing kona ay pangibatan malilikot ka tan mag-in kan maligan-maliga tan lako ot a tawo a ma-ligawan ha pa-miabing kona. ");
INSERT INTO xsb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nga-min, mag-in yan marangal ha hilap nan Dios a Katawan. Kay ya minom nin anyakaman a ampakalahing. Tan maskin iti ya ot ha lalo tiyan nin nanay na ay ampango-nawan yay nan hosto nin Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lako konlan kapara moyon Israelita a pabalikon na konan Dios a Katawan moyo. ");
INSERT INTO xsb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yadtin hi Juan ay mo-na ya konan Katawan. Yay pangongo-na nin Ispirito nan Dios kona tan yay kapangyarian na ay mag-in bilang koni Propita Elias hin o-nan panaon. Ihogo ya para ipaki-sondo a tawtatay konlan aw-awa-nak tan toroan hilay tawtawon kay anhomonol nin magbolta ha pa-magbiyay a ayon ha karonongan nin tawon maptog ha Dios. Ha anorin ay maiparihado nay tawtawo ha kala-lato nan Katawan.” ");
INSERT INTO xsb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hawanin, wani Zacarias konan anghil, “Pa-no ko man ma-sigoro a mangyari orin komi, anta matokling akoy na tan anorin kapara konan kaambali ko?” ");
INSERT INTO xsb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kot in-obat nan anghil kona, “Hiko hi Gabriel a lawah itaw ha arapan nan Dios. Inhogo na ko para ka-totolon ka ta iabot komo yadtin magandan balita. ");
INSERT INTO xsb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kot hawanin ay mag-in kan omol anggan ha awlon mangyari orin impabalita nan Dios bana ta kay mo pini-pol odtin imbalita ko komo a mangyari ha panaon a intakda na.” ");
INSERT INTO xsb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lolog ya-rin, hilay tawtawon iti ha likol nin timplo ay ampana-gan koni Zacarias. Nag-ispanta hila no anongkot hay boyot na itaw ha loob. ");
INSERT INTO xsb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kot hin nilomikol ya, kay yay na makahalita konla. Biig mawmostra tana a ginwa na ta kay yay nay naor makahalita, kanya naintindyan lan tawtawo a malamang main yan na-kit a ka-paka-ngap ha loob timplo. ");
INSERT INTO xsb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hin nayari anadtin nanglinggon pa-magsirbi na ha timplo, norong yay na ha bali la. ");
INSERT INTO xsb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kay naboyot, nanginaw anaor hi Elisabet a kaambali na. Kay ya nilomikol ha bali nin limay bolan ta wana ha sarili na, ");
INSERT INTO xsb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Hawanin ay ininga-rowan na koy nan Katawan. Ginwa nadti kongko pigaw maalih a karingoyan ko ha tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hin ika-nom a bolan anay lombit ni Elisabet, inhogo nay naman Dios yay anghil nan hi Gabriel, para mako ha probinsyan Galilea, itaw ha babalin Nazaret. ");
INSERT INTO xsb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pina-ka na ya itaw ha a-say dalaga a yay ngalan kot Maria. Yadtin hi Maria ay nakatakda anan pakahal koni Jose a a-say lalakin ibat ha lipi ni Ari David. ");
INSERT INTO xsb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nilomoob yay anghil ha kamainan ni Maria, ta wana, “Lomiga ka ta pinili na kan Dios para payabolan abig. Yay Katawan ay lawah yan ison komo. Makalma ka ha halban bawbabayi.” ");
INSERT INTO xsb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pa-maka-kit ni Maria konan anghil tan* pa-makalngo na ha hinalita na ay na-golowan a isip na. An-isip-isipon na no anyay labay totolon nin hinalita nan anghil. ");
INSERT INTO xsb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kot wanan anghil kona, “Ando ka mali-mo, Maria, ta talagan pinili na kan Dios para payabolan nan abig. ");
INSERT INTO xsb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hika ay lomombit ta mangabing kan a-say lalaki, tan yay ipangalan mo kona ay Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mag-in yan marangal tan ha-wayan yan Anak nin Sangkata-ta-gayan a Dios. Ibi nan Dios a Katawan konay karapatan mag-ari ha datin kaarian nin kapapo-papoan na a hi Ari David. ");
INSERT INTO xsb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mag-ari ya konlan aw-Israelita anggan-angga, ta yay pa-mag-ari na ay homin panganggawan.” ");
INSERT INTO xsb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wani Maria konan anghil, “Pa-no mangyari orin anta dalaga ko?” ");
INSERT INTO xsb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kot wanan in-obat nin anghil kona, “Omaypa yay Masanton Ispirito nan Dios komo tan ha kapangyarian nan Sangkata-ta-gayan a Dios ay mangyari orin. Kanya yay ipangabing mon anak ay banal tan ha-wayan yan Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maskin yay kanayon mon hi Elisabet, ha dobali nin katontawowan tan pa-makabaog na ay mangabing ya. Ika-nom a bolan anay lombit na hawanin. ");
INSERT INTO xsb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nga-min, konan Dios ay homin imposibli!” ");
INSERT INTO xsb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wani Maria, “Hiko ay ma-magsirbi nan Katawan. Mangyari komon no-nin a hinalita mo kongko.” Bi-sa imbati na yay nan anghil. ");
INSERT INTO xsb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kay naboyot, nangapora yan nako hi Maria ha a-say babali a itaw ha partin kabakilan nin probinsyan Judea. ");
INSERT INTO xsb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pa-makalato na ha bali li Zacarias, nami yan galang koni Elisabet. ");
INSERT INTO xsb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hin nalngo ni Elisabet a pa-ngomosta ni Maria, nanigo yay anak ha tiyan na. Hin ya-rin ay pinango-nawan yan hosto nin Masanton Ispirito nan Dios hi Elisabet, ");
INSERT INTO xsb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kanya wana ha makhaw a bosis, “Makalma ka ha halban bawbabayi, tan makalma anamaot ya-rin a iabing mo. ");
INSERT INTO xsb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hino ko kot para tibawon mo, hika a nanay nan Katawan ko! ");
INSERT INTO xsb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bilyon mo, nalngo kon bongat a pa-ngomosta mo ay nanigo ha kaligawan yay anak a iti ha tiyan ko. ");
INSERT INTO xsb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Makalma ka ta pini-pol mo a mangyari yay impapibalita nan Katawan komo.” ");
INSERT INTO xsb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Wani Maria, “Amporiwon ko yay Katawan, ");
INSERT INTO xsb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tan angkalilikot ako konan Dios a Ma-milipyas ko, ");
INSERT INTO xsb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ta hiko a ma-magsirbi na a maaypa a kapa-pa-hal ay inisip na. Kanya paibat hawanin, halban tawtawo maskin ha hawhomonol a hinirasyon ay ha-wayan la kon makalma, ");
INSERT INTO xsb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bana ha ka-paka-ngap a bawbagay a ginwa na kongko nin Dios a makapangyarian. Ita-gay a masanto nan ngalan. ");
INSERT INTO xsb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yay inganga-ro na ay para ha tawo a main hoston li-mo kona, paibat konlan o-nan hinirasyon anggan konlan halban homonol ot a hinirasyon. ");
INSERT INTO xsb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","An-ipa-kit nay kapangyarian na ta an-iboyak na hilay mapagmata-gay, ");
INSERT INTO xsb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","tan an-ibagsak na hilay aw-ari ha main lan pa-makaari. Kot hilay mangaaypa a kapa-halan ay an-ita-gay na. ");
INSERT INTO xsb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hilay namaot a angka-bitilan ay ampabhoyon na nin labah a bawbagay. Kot hila balo a mawmayaman ay ampalayahon na hilan homin ni anyakaman a awit. ");
INSERT INTO xsb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Hitamoy aw-Israelita a mawma-magsirbi nan Dios ay antambayan na ha main nan inganga-ro, ");
INSERT INTO xsb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","bana ha pangako na konlan kalimpapo-papoan tamon hi Abraham tan hilay lawlipi na a inga-rowan na tamon anggan-angga.” Yadti a pamomori ni Maria konan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ni-wan hi Maria konli Elisabet nin manga toloy bolan, bi-sa norong yay na ha bali na. ");
INSERT INTO xsb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hin ya-rin, nilomato anay kaorasan nin pangangabing ni Elisabet. Nangabing yay naor nin a-say lalaki. ");
INSERT INTO xsb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na-balitaan lan kawkaholibay tan kawkanayon ni Elisabet yay tongkol ha kaabigan a ginwa nan Katawan kona. Kanya naki-lilikot hila kona. ");
INSERT INTO xsb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hin ikawaloy awlo nay nan anak, ni-pako hilay kawkaholibay tan kawkanayon la ha bali la para biliwon yay pa-ngogit konan anak. Hin ya-rin ay pangalanan la yay na komon Zacarias a bilang ngalan ni tatay na. ");
INSERT INTO xsb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kot wani Elisabet, “Kay maari! Juan yay dapat ngalan na.” ");
INSERT INTO xsb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kot wanlay namaot nin hilay tawtawo, “Anongkot? Anta homin anamaot ha kanayon moyo a main anorin a ngalan.” ");
INSERT INTO xsb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hawanin, sininyasan la hi Zacarias ta pinastang no anyay labay nan ipangalan konan anak. ");
INSERT INTO xsb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nagmostra hi Zacarias a biyan la yan ma-panolatan. Bi-sa insolat na, “Juan a ngalan na.” Halban lan tawtawo itaw ay nag-ispanta. ");
INSERT INTO xsb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tongwa, naalih anay pa-makaomol ni Zacarias, kanya nakapanalita yan namori konan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ambo makano-kanoy ispanta lan halban tawtawon ampi-wan ha ka-libol la. Bi-sa yadtin halban nangyari ay nibantog ha intiron partin kabakilan nin probinsyan Judea. ");
INSERT INTO xsb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Halban lan nakalngo ay inisip-isip ladti, wanla, “Mag-in anya kari yadtin anak?” Mapatnag a yay kapangyarian nan Dios a Katawan ay iti konan anak. ");
INSERT INTO xsb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hin ya-rin, hi Zacarias a tatay ni Juan ay pinango-nawan yan hosto nin Masanton Ispirito nan Dios. Anodti yay hola a impahalita na kona: ");
INSERT INTO xsb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Poriwon yay Dios a Katawan tamon hitamoy aw-Israelita. Kina na tamoy tawtawo na para ilipyas, ");
INSERT INTO xsb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ta inhogo na kontamoy makapangyarian a Ma-milipyas ibat ha lipi ni Ari David a ma-magsirbi nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Impangako na ha paralan nin banal a pawpropita na paibat hin o-nan panaon, ");
INSERT INTO xsb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a ilipyas na tamo konlan kawkontra kontamo tan konlan halban ampaniplon kontamo. ");
INSERT INTO xsb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ininga-rowan na tamoy naor Dios ayon ha impangako na konlan kalimpapo-papoan tamo ta ampanomtomon nay masagradon kasondoan na konla. ");
INSERT INTO xsb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nga-min, impangako na koni Abraham a kalimpapo-papoan tamo nin main awit pa-maghompa ha sarili na ");
INSERT INTO xsb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a ilibri na tamo ha gamot lan kawkontra kontamo, pigaw makapagsirbi tamo ha Dios nin homin anan kali-mowan, ");
INSERT INTO xsb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","banal tan maptog ha main nan arapan lolog main tamon biyay. ");
INSERT INTO xsb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Hikay namaot, anak ko ay ha-wayan propita nan sangkata-ta-gayan a Dios, ta mo-na ka konan Katawan para iparihado moy kala-lato na. ");
INSERT INTO xsb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Itoro mo konlan tawtawo na yay paralan nin kalipyasan, a homin laloma no ambo yay kapatawaran nin main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nga-min, yay Dios tamo ay malabi tan mainganga-rowon, kanya nilomato anay Ma-milipyas tamo a pa-hal hinomila anay awlo iti kontamo, ");
INSERT INTO xsb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ta pigaw ma-hawangan a balang tawon iti ha karobloman bana ha kasalanan, tan iti ha kali-mowan nin kamatyan, ta itandoro na tamo no pa-no magkamain kaliswayan nakom.” Yadti a pamomori ni Zacarias konan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hawanin, yadtin hi Juan ay hinomi-ban nin manakom. Ni-wan ya ha disyirto anggan ha nilomato a awlon dapat yay nan magpabilbi ha kapara nan aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hin ya-rin a panaon, hi Impirador Augusto ay namipataoy yan kapanogoan a halban angka-hakopan nin Roma kot dapat magparihistro para mamayar nin bowis. ");
INSERT INTO xsb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yadti yay o-nan pa-marihistro la. Nangyari odti hin hi Cirenio a gobirnador ha Siria. ");
INSERT INTO xsb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Halban anaor ay nako ha kanya-kanyan babalin lipi la para parihistro. ");
INSERT INTO xsb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kanya hi Jose man ay inomalih ha babalin Nazaret, ha probinsyan Galilea ta nako ya ha probinsyan Judea, itaw ha babalin Betlehem a logar ni Ari David. Nga-min, lipi ya ni Ari David. ");
INSERT INTO xsb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yay kalamo nan parihistro ay hi Maria a kaambali na a hin ya-rin ay kabolanan nay nan mangabing. ");
INSERT INTO xsb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hin ya-rin a itaw hila ha Betlehem, nakalato a kaorasan nin pa-ngabing ni Maria. ");
INSERT INTO xsb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","In-abing nay naor a a-say lalaki a kalingkakaan nan anak. Pinotot na ya ni Maria nin lamping tan impaira ha lalabangan ha kwadra, bana ta homin hilay nan ma-logaran ha balin anhandaan. ");
INSERT INTO xsb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hin ya-rin a yabi, itaw ha likol nin babalin Betlehem ay main pawpastol a ampagbantay nin kawkarniro ha lawak. ");
INSERT INTO xsb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tongwa, main a-say anghil nan Katawan a nagpa-kit konla. Bi-sa yay kalinggasan nan Katawan ay hinomawang ha ka-libol la, kanya ambo makano-kanoy li-mo la. ");
INSERT INTO xsb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kot wanan anghil konla, “Ando kamo mali-mo ta awit koy magandan balita komoyo a mamin mahi-ban a kaligawan ha halban tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ta yadtin yabi ay impangabing ha Betlehem a babali ni Ari David yay Ma-milipyas moyo a hi Criston Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Oyay pamilbian moyo: Maka-kit kamon kolaw a nakapotot nin lamping tan nakaira ha lalabangan.” ");
INSERT INTO xsb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tongwa, main kalakan aw-anghil ibat ha langit a naki-lamo konan ya-rin anghil. Amporiwon la yay Dios, wanla, ");
INSERT INTO xsb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Poriwon yay Dios ha sangkalangitan, tan ha babon lota ay magkamain kaliswayan nakom konlan tawtawon an-ikalilikot nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hin ya-rin a namagka hilay nay aw-anghil ha langit, wanlan pawpastol ha a-sa tan a-sa, “Mako tamoy na ha babali, ta biliwon tamo-rin nangyari a impatandaan nan Katawan kontamo.” ");
INSERT INTO xsb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nangapora hilay nan nako a pawpastol. Na-kit la hi Maria tan hi Jose, tan yay anak a nakaira naor ha lalabangan. ");
INSERT INTO xsb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pa-maka-kit la ay imba-balita la ha tawtawo odtaw hinalita nan anghil konla tongkol konan yadtin anak. ");
INSERT INTO xsb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Halban lan nakalngo ha imbalita lan pawpastol ay nag-ispanta. ");
INSERT INTO xsb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kot hi Maria, yadtin halban ay intanom na ha isip na tan toloy nan anlaman-lamanon. ");
INSERT INTO xsb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hilay namaot a pawpastol ay nagbolta ha ampagpastolan la nin ampanayaw tan ampamori ha Dios bana ha halban bawbagay a nalngo tan na-kit la ayon ha impatandaan nan anghil konla. ");
INSERT INTO xsb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hin waloy awlo nay nan anak, kinogit la ya. Tan pinangalanan la yay naor Jesus ayon ha imbalita nan anghil ba-yo ya in-inaw. ");
INSERT INTO xsb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hin naabot a panaon para gaw-on yay kapanogoan a inimbi koni Moises tongkol ha sirimonyan pa-manglinis nin a-say babayin nangabing, nako hi Maria tan hi Jose ha timplo ha Jerusalem para gaw-on la-rin. Inawit lay namaot hi Jesus para ida-ton la ya konan Dios a Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nga-min, ayon ha nakasolat a kapanogoan nan Katawan, “Yay primiron anak a lalaki ay itoring ikon nan Katawan.” ");
INSERT INTO xsb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Namida-ton hilan loway manok-manok konan Katawan, ta ayon ha kapanogoan, yay babayin kapiyari nangabing ay dapat mamida-ton loway bato-bato o kari loway malago a kalapati. ");
INSERT INTO xsb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hin ya-rin, main a-say lalaki ha Jerusalem a yay ngalan na kot Simeon. A-sa yan labah a tawo, maka-Dios tan ampana-gan ha kala-lato nan Ma-milipyas nin Israelita. Ampango-nawan yay namaot nin Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Impatandaan ot Masanton Ispirito kona a kay ya mati anggan kay na ma-kit yay Cristo a impangako nan Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hin ya-rin ay pina-ka na yan Ispirito nan Dios hi Simeon ha timplo. Kanya hin inawit la hi Jesus itaw nin matoantawo na para gaw-on yay ayon ha kapanogoan nan Dios, ");
INSERT INTO xsb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","binibi na ya ni Simeon. Bi-sa pinori na yay Dios, wana, ");
INSERT INTO xsb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Katawan, hawanin ta natoor anay pangako mo kongkon ma-magsirbi mo, malisway anay nakom kon mati, ");
INSERT INTO xsb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","bana ta na-kit ana nin sarili kon mata yay Ma-milipyas ");
INSERT INTO xsb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a intatala mo para ha halban tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hiyay hawang ha kaisipan lan ambo Israelita tan karangalan komin Israelita a tawtawo mo.” ");
INSERT INTO xsb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nag-ispanta hila ni Jose tan hi Maria bana ha bawbagay a imbalita ni Simeon tongkol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hin ya-rin ay binindisyonan na hila ni Simeon, bi-sa wana koni Maria a nanay ni Jesus, “Tandaan mo: Yadtin anak a inhogo nan Dios ay pangibatan nin lako a Israelita a miparoka ta kay hila tompol kona. Balo ta lako anamaot a malipyas bana kona. A-sa yan pamilbian a naibat ha Dios, kot lako a mangontra kona. Kanya ma-patnagan yay doka a isip nin lako a tawo. ");
INSERT INTO xsb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tan hika, bana ha mangyari kona ay makaranas kan kaloloan a bilang toyhokon ponyal ya-rin poso mo.” ");
INSERT INTO xsb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hin ya-rin, main anamaot itaw ha timplo nin a-say propitan babayi a yay ngalan kot Ana. Anak ya ni Fanuel a ibat ha lipi ni Aser. Matokling yay nan labah hin ya-rin. Pitoy taon hilan bongat ni-lamo nin kaambali na, ");
INSERT INTO xsb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ba-yo ya nabalo. Hawanin ay walompolo tan a-pat a taon yay na. Itaw yay na ampagpirmi ha timplo ta awlo-yabi yan ansomamba ha Dios nin main awit kada-dawat tan pa-magsakripisyon kay mangan. ");
INSERT INTO xsb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hin ya-rin, dinomani yay namaot hi Ana ta nagpasalamat ya konan Dios a Katawan. Bi-sa imbalita na yay tongkol koni Jesus konlan halban tawtawo ha Jerusalem a ampana-gan ha pa-milibri nan Dios konla. ");
INSERT INTO xsb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hin nayari lay na ni Jose tan hi Maria yay halban dapat lan gaw-on ayon ha kawkapanogoan nan Katawan, norong hilay na ha sarili lan babalin Nazaret, ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ha maparah a olit, hi Jesus ay hinomi-ban nin manakom. Dinomonong yan labah tan angkalilikot yay Dios kona. ");
INSERT INTO xsb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinaon-taon ampako hilay matoantawo ni Jesus ha syodad Jerusalem para ha Pistan Pa-makalibri. ");
INSERT INTO xsb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hin labinloway taon ana hi Jesus, nako hilay naman ha Jerusalem ayon ha kaogalian la. ");
INSERT INTO xsb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pa-makayari pista, hin norong hilay na ay nagpaka-bati hi Jesus ha Jerusalem nin kay la tanda ni Jose tan ni nanay na. ");
INSERT INTO xsb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Hay wanla no kasabay ya nin laloman kawkalamoan la a amporong anamaot hin ya-rin. Kanya intoloy lay kala-lalako la nin nanagaawlo. Hin tinomgon hila ta anyomabi na, pinastang la ya konlan kawkanayon la tan kawka-bilbi. ");
INSERT INTO xsb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hin kay la ya ma-kit, nagbolta hila ha Jerusalem, para tingkapon ya itaw. ");
INSERT INTO xsb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ikatlon awloy na hin na-kit la ya itaw ha timplo, nin ampaki-toklo konlan mawmaistron kapanogoan ta ampanglongo ya konla tan ampamastang. ");
INSERT INTO xsb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Halban lan ampakalngo kona ay ampag-ispanta ha katalinowan na tan ha aw-obat na. ");
INSERT INTO xsb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hin na-kit la yan matoantawo na, nag-ispanta hila. Dinaniwan na ya ni nanay na, ta wana, “Anak ko, anongkot anodti ginwa mo komi? Ampag-aborido kami ni tatay mo ha paniningkap komo.” ");
INSERT INTO xsb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kot wani Jesus konla, “Anongkot antingkapon moyo ko? Kay moyo doman tanda a iti ko dapat ha bali nin Ama ko?” ");
INSERT INTO xsb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kot kay la naintindyan nin matoantawo na no anyay labay nan totolon. ");
INSERT INTO xsb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naki-ka yay na hi Jesus konla nin norong ha Nazaret. Pirmi yan mahonol konla. Hi Maria namaot ay intanom na ha isip na yay halban pawpangyayari. ");
INSERT INTO xsb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hi Jesus ay patoloy nin hinomi-ban tan dinomonong. Patoloy anamaot angkalilikot yay Dios tan tawtawo kona. ");
INSERT INTO xsb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hin ya-rin a panaon ay ikalabinlimay taon anan pamomoon ni Impirador Tiberio ha Roma; hi Poncio Pilato ay gobirnador ha probinsyan Judea; hi Herodes Antipas ay ampag-ari ha probinsyan Galilea; hi Felipe a talakaka ni Ari Herodes Antipas ay ampamoon ha lawlogar nin Iturea tan Traconite; tan hi Lisanias ay ampamoon ha logar nin Abilinia. ");
INSERT INTO xsb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hilay pinakapoon pari ha intiron Israel hin ya-rin ay hila hi Anas tan hi Caifas. Ya-rin yay panaon a hina-wayan nan Dios yay anak ni Zacarias a hi Juan a ampi-wan itaw ha disyirto. ");
INSERT INTO xsb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kanya nako ya nangaral ha intiron logar ha ka-libol nin Kabatwan Jordan ta imbalita na ha tawtawo a kailangan mi-pangombabali hila tan bokotan lay kawkasalanan la, tan pabaotismo pigaw patawaron na hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Konan yadtin pangangaral ni Juan Bautista ay pinomtog yay sinolat ha libro ni Propita Isaias, anodti wana, “Itaw ha disyirto ay main malngo a ampama-balawbaw a bosis a wanan ialimbawa: ‘Iparihado moyoy pa-hal pagpa-wanan nan Katawan, tan pa-hal itoynong moyoy dalanan na. ");
INSERT INTO xsb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yay pa-hal nawnaglalô a logar ay tambagan, yay pa-hal bawbakil ay patagon, tan yay pa-hal tiko-tiko a dawdalan ay itoynong, bi-sa yay lobak-lobak a dawdalan ay pantayon. ");
INSERT INTO xsb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bi-sa ma-kit lan halban tawtawo a pa-milipyas nan Dios.’” ");
INSERT INTO xsb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hin ya-rin ay main malabong a tawon nako koni Juan para pabaotismo. Kot wana konla, “Mataktika kamon bilang olay. Hino wani komoyo a maka-pa-lilih kamo ha matindin hobhob nan Katawan a main awit parosa, no basta kamon bongat pabaotismo? ");
INSERT INTO xsb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","No talagan ampangombabali kamo, dapat ipa-kit moyo ha kagogwa kaabigan a binokotan moyoy nay main moyon kawkasalanan. Ando moyo isipon a kay na kamo parosawan nin Dios bana ta lawlipi na kamo ni Abraham. Ibalita ko komoyo, magawa nan Dios tawtawo odtin bawbato nin mag-in lawlipi ni Abraham para mag-in ka-hagilyan moyo. ");
INSERT INTO xsb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bana ta yay gawgawa moyo kot doka, kaalimbawaan moyo ay kayon an-awagan anan payakol para pokanon ta balang poon kayon kay ampamongan labah a klasin bonga ay ampokanon ta poolan.” ");
INSERT INTO xsb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hawanin, wanlan hilay tawtawo koni Juan Bautista, “Anya man no-nin a dapat min gaw-on?” ");
INSERT INTO xsb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Oyay dapat moyon gaw-on,” obat ni Juan, “hinoman komoyo a main loway ayhing ay ibi nay a-sa ha homin. Tan hinoman a main pa-mangan ay mami yay namaot ha homin.” ");
INSERT INTO xsb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Main anamaot mawma-ni-non bowis a nako koni Juan para pabaotismo. Pinastang la yay namaot, wanla, “Maistro, anya may dapat min gaw-on?” ");
INSERT INTO xsb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wanan in-obat ni Juan, “Ando kamo mani-no nin sobra ha dapat moyon hi-nowon.” ");
INSERT INTO xsb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pinastang la yay namaot nin hawhondalo, wanla, “Hapay hikami, anya may gaw-on mi?” Wani Juan konla, “Ando moyo abosowon a tawtawo o pwirsawon para pangwanan kwarta tan ando kamo mamarâ nin homin kaptogan. Dapat mag-in kamon kontinto ha swildo moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hila-rin a tawtawo ay talagan ampakata-taga-nan lay kala-lato nan Cristo a impangako nan Dios, kanya an-isipon la no hi Juan ana doman ya-rin. ");
INSERT INTO xsb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kot wani Juan konlan halban, “Main lomato a mas makapangyayari kongko ta ni mangorkal kordon apin na ay ambo akon marapat. Ambaotismowan katamo nin lanom, kot yay lomato, hiyay mamaotismo komoyo nin Masanton Ispirito nan Dios tan nin apoy. ");
INSERT INTO xsb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kaalimbawaan na ay ma-ngalipar, tan hitamoy tawtawo ay pa-hal trigon nailik a aaliparan. Aliparan na tamo bi-sa ilimpoh nay pa-hal malinis anan trigo ha kamalig. Balo ta yay pa-hal apil ay poolan na ha apoy a homin pa-nga-lop.” ");
INSERT INTO xsb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Anorin a pangangaral ni Juan nin Labah a Balita konlan tawtawo, tan lako ot a inwawali na konla. ");
INSERT INTO xsb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maskin hi Ari Herodes Antipas a ampamoon ha probinsyan Galilea ay sinita na bana ta impagkaambali na hi Herodias a kaambali nin talakaka na a hi Felipe tan bana ha halban dawdoka a gi-ginwa na. ");
INSERT INTO xsb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bi-sa, ya-rin a kawkasalanan nan ari ay na-pa-lahan ot hin impapriso na hi Juan. ");
INSERT INTO xsb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kot hin itaw ya ot hi Juan Bautista ha Kabatwan Jordan, a-say awlo, hin na-baotismowan nay na a halban tawtawo itaw, nako yay namaot nagpabaotismo hi Jesus. Pa-makayari, hin dinomawat hi Jesus ay naabriyan a langit. ");
INSERT INTO xsb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bi-sa inomaypa konay Masanton Ispirito nan Dios ha itsoran kalapati. Ba-yo wanan bosis nan Dios a naibat ha langit, “Hika a anlabyon kon Anak tan angkalilikot akon labah komo.” ");
INSERT INTO xsb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Manga tolompolo a taon anay idad ni Jesus hin nag-ompisa yan nangaral. Ayon ha tanda lan tawtawo ay anak na ya ni Jose. Oyay listawan nin lahi a pinangibatan ni Jose: ");
INSERT INTO xsb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hi Jose ay anak ni Eli, hi Eli ay anak ni Matat. Hi Matat ay anak ni Levi, hi Levi ay anak ni Melqui. Hi Melqui ay anak ni Jana, hi Jana ay anak ni Jose, ");
INSERT INTO xsb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","hi Jose ay anak ni Matatias, hi Matatias ay anak ni Amos, hi Amos ay anak ni Nahum, hi Nahum ay anak ni Esli, hi Esli ay anak ni Nage, ");
INSERT INTO xsb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","hi Nage ay anak ni Maat, hi Maat ay anak ni Matatias, hi Matatias ay anak ni Semei, hi Semei ay anak ni Jose, hi Jose ay anak ni Juda, ");
INSERT INTO xsb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","hi Juda ay anak ni Joana, hi Joana ay anak ni Resa, hi Resa ay anak ni Zorobabel, hi Zorobabel ay anak ni Salatiel, hi Salatiel ay anak ni Neri, ");
INSERT INTO xsb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","hi Neri ay anak ni Melqui, hi Melqui ay anak ni Adi, hi Adi ay anak ni Cosam, hi Cosam ay anak ni Elmodam, hi Elmodam ay anak ni Er, ");
INSERT INTO xsb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","hi Er ay anak ni Josue, hi Josue ay anak ni Eliezer, hi Eliezer ay anak ni Jorim, hi Jorim ay anak ni Matat, hi Matat ay anak ni Levi, ");
INSERT INTO xsb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","hi Levi ay anak ni Simeon, hi Simeon ay anak ni Juda, hi Juda ay anak ni Jose, hi Jose ay anak ni Jonan, hi Jonan ay anak ni Eliaquim, ");
INSERT INTO xsb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","hi Eliaquim ay anak ni Melea, hi Melea ay anak ni Mainan, hi Mainan ay anak ni Matata, hi Matata ay anak ni Natan, hi Natan ay anak ni David, ");
INSERT INTO xsb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","hi David ay anak ni Jesse, hi Jesse ay anak ni Obed, hi Obed ay anak ni Booz, hi Booz ay anak ni Salmon, hi Salmon ay anak ni Naason, ");
INSERT INTO xsb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","hi Naason ay anak ni Aminadab, hi Aminadab ay anak ni Admin, hi Admin ay anak ni Arni, hi Arni ay anak ni Esrom, hi Esrom ay anak ni Fares, hi Fares ay anak ni Juda, ");
INSERT INTO xsb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","hi Juda ay anak ni Jacob, hi Jacob ay anak ni Isaac, hi Isaac ay anak ni Abraham, hi Abraham ay anak ni Tare, hi Tare ay anak ni Nacor, ");
INSERT INTO xsb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","hi Nacor ay anak ni Serug, hi Serug ay anak ni Ragau, hi Ragau ay anak ni Peleg, hi Peleg ay anak ni Heber, hi Heber ay anak ni Sala, ");
INSERT INTO xsb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","hi Sala ay anak ni Cainan, hi Cainan ay anak ni Arfaxad, hi Arfaxad ay anak ni Sem, hi Sem ay anak ni Noe, hi Noe ay anak ni Lamec, ");
INSERT INTO xsb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","hi Lamec ay anak ni Matusalem, hi Matusalem ay anak ni Enoc, hi Enoc ay anak ni Jared, hi Jared ay anak ni Mahalaleel, hi Mahalaleel ay anak ni Cainan, ");
INSERT INTO xsb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","hi Cainan ay anak ni Enos, hi Enos ay anak ni Set, hi Set ay anak ni Adan, tan hi Adan ay maitoring anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hi Jesus ay pinango-nawan hosto nin Masanton Ispirito nan Dios hin inomalih ya ha Kabatwan Jordan. Bi-sa intandoro na yan mako ha disyirto. ");
INSERT INTO xsb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Lolog nan itaw nin a-pat a polo a awlo ay antoksowon na ya ni Satanas. Kay ya nangan konan ya-rin a panaon, kanya pa-makayari odti ay masyado yay nan mabitil. ");
INSERT INTO xsb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wani Satanas kona, “No talagan Anak na kan Dios, mandawan modtin bawbato a mag-in pa-mangan.” ");
INSERT INTO xsb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kot wanan in-obat ni Jesus kona, “Wana ha Masanton Kasolatan, ‘Ambo bongat ha pa-mangan mabyay a tawo, nokay kailangan na syimpri a balang halita nan Dios.’” ");
INSERT INTO xsb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pa-makayari ay inawit na ya ni Satanas ha a-say na-pakata-gay a logar, ta impatamolaw na kona nin maparah yay halban kawkaarian iti ha mondo. ");
INSERT INTO xsb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bi-sa wana koni Jesus, “Ibi ko komo yay kapangyarian nin mamoon ha halban ya-rin, tan halban bawbagay a mangaganda ison. Nga-min, inimbi anadti kongko, kanya maibi kodti ha hinoman a labay kon biyan. ");
INSERT INTO xsb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kanya no somamba ka kongko ay maipag-ikon modtin halban.” ");
INSERT INTO xsb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kot wani Jesus kona, “Paka-dayo ka kongko, Satanas, ta* wana ha Masanton Kasolatan, ‘Sambawon moy Dios a Katawan mo tan hiyan bongat a pagsirbiwan mo.’” ");
INSERT INTO xsb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bi-sa inawit na ya ni Satanas ha syodad Jerusalem ta itaw na ya pina-dong ha pinakatoktok nin timplo. Bi-sa wanay naman kona, “No talagan Anak na kan Dios, magdadabo ka iti. ");
INSERT INTO xsb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Total wana ha Masanton Kasolatan, ‘Ipabantayan na kan Dios konlan aw-anghil na para ingatan la ka.’ ");
INSERT INTO xsb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","tan: ‘Alalayan la ka, Pigaw ni ayi mo kot kay mitiro ha bato.’” ");
INSERT INTO xsb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kot wanan in-obat ni Jesus kona, “Nakasolat anamaot, ‘Ando mo hobokon a kapangyarian nan Dios a Katawan mo.’” ");
INSERT INTO xsb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hin nagawa nay na ni Satanas a halban paralan nin panonokso koni Jesus ay inomalih ya yapon ta nana-gan yan laloman tyansa. ");
INSERT INTO xsb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Norong hi Jesus ha probinsyan Galilea nin iti kona yay kapangyarian nin Ispirito nan Dios. Yay balita tongkol kona ay nibantog ha intiron ka-libol nin ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nangaral ya ha sawsinagoga a ampagsambawan la tan pinori la ya nin halban tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hawanin, norong hi Jesus ha Nazaret a babalin tinoboan na. Ayon ha kaogalian na, nako ya ha sinagoga nin Awlon Pa-mainawa nin Israelita. Hin ya-rin ay inomdong ya ha arapan lan tawtawo pigaw mamasan Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yay inimbin basawon na ay yay libron sinolat ni Propita Isaias. Binoklat nadti ha partin main anodtin nakasolat: ");
INSERT INTO xsb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yay Ispirito nan Dios ay iti kongko Ta pinili na ko para mangaral nin labah a balita konlan mangairap. Inhogo na ko para biyan kaliswayan nakom hilay main irap nakom,* para ipatandaan konlan aw-alipon a malibri hilay na, para paabigon hilay bawbolag pigaw maka-kit hila, para ilibri hilay angkaapi ha pa-ngapi konla, ");
INSERT INTO xsb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tan para ipamalita a nilomato anay panaon para ilipyas nan Katawan a tawtawo na.” ");
INSERT INTO xsb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hawanin, hin nayari nan binasa ni Jesus odtaw ay nilolon nan oman, bi-sa in-orong konan ma-ngasiwa. Pa-makayari ay tinomoklo ya para mangaral. Halban tawtawo itaw ay anhilap kona. ");
INSERT INTO xsb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bi-sa wana konla, “Hawanin awlo ay pinomtog odtaw partin Masanton Kasolatan, lolog anlong-on moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Halban la itaw ay namori kona tan nag-ispanta ha kagandawan hawhalita na. Kot wanla, “Ambo doman anak ni Jose orin?” ");
INSERT INTO xsb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kanya wani Jesus konla, “Sigoradon halitaon moyo kongko odtin kahalitaan, ‘Doktor, tambalon moy namaot a sarili mo.’ Kanya wamoyo, ‘Gaw-on moy namaot iti ha sarili tamon babali yay nalngo min ginwa mo ha Capernaum.’” ");
INSERT INTO xsb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wana ot ni Jesus, “Kot yay potog, ibalita ko komoyo, ampangyari kongko hawanin yay kahalitaan: Homin propita a antanggapon ha sarili nan logar. ");
INSERT INTO xsb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tanda moyodtin potog a nangyari hin panaon ni Propita Elias: Lako a babayin balo a mangairap iti ha nasyon tamon Israel, hin kay nangabagat nin toloy taon tan a-nom a bolan ta bi-sa nagkamain nin grabin bitil ha intiron nasyon. ");
INSERT INTO xsb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kot kay na inhogo Dios hi Propita Elias ha hinoman konla, nokay ha a-say babayin balo a taga laloman nasyon ha babalin Sarepta a hakop nin syodad Sidon. ");
INSERT INTO xsb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Anorin syimpri hin panaon ni Propita Eliseo, lako konlan kaparan Israelita a main kitong. Kot homin konla a pinaabig nokay hi Naaman bongat a taga nasyon Siria.” ");
INSERT INTO xsb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hin nalngo la-rin, halban lan nititipon itaw ha loob nin sinagoga ay masyado hilan nagolo kona. ");
INSERT INTO xsb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inomdong hila ta pwinirsa la yan inlikol ta bi-sa inawit ha toktok nin bakil a kamainan nin babali la ta idabo la ya komon ha bongaw. ");
INSERT INTO xsb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kot yay ginwa ni Jesus ay nagpa-wan ya ha botlay la ta inomalih ya. ");
INSERT INTO xsb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hawanin, nako hi Jesus ha Capernaum a a-say babali nin probinsyan Galilea. Ampangaral ya itaw ha sinagoga no Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Naka-ngap hilay tawtawo ha klasin pa-noro na ta yay hawhalita na ay main awit kapangyarian. ");
INSERT INTO xsb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hin ya-rin, itaw ha loob nin sinagoga ay main a-say lalaki a nilooban nin doka a ispirito a bigla inomaghaw. ");
INSERT INTO xsb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wana, “Po-layan mo kami. Anyay pakiomon mo komi, Jesus a taga Nazaret? Parosawan mo kami na doman? Tanda ko a hika yay Banal a inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kot hinaar na ya ni Jesus, wana, “Mamakatinok ka, tan omalih ka kona!” Intomba nan doka a ispirito yay lalaki ha arapan lan tawtawo, ba-yo ya inomalih kona, balo ta kay na ya hinakitan. ");
INSERT INTO xsb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naka-ngap a halban tawtawo itaw, tan wanla ha a-sa tan a-sa, “Anyay klasin totoro odti? Main yan awtoridad tan kapangyarian! Angka-mandawan na hilay dawdoka a ispirito ta an-omalih hila.” ");
INSERT INTO xsb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bi-sa yay balita tongkol koni Jesus ay nibantog ha intiron ka-libol nin ya-rin babalin Capernaum. ");
INSERT INTO xsb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pa-makayari nan pinalayah ni Jesus yadtaw doka a ispirito ay inomalih ya ha sinagoga ta naki-ka ya ha bali ni Simon. Hin ya-rin, mata-gay a pa-nga-mot nin katyangan ni Simon, kanya impaki-totol la koni Jesus a paabigon na ya. ");
INSERT INTO xsb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inomdong hi Jesus ha dani nan babayi, bi-sa inmanda na a maalih a main nan pa-nga-mot. Inomabig yay naor, kanya antimano nibangon ya ta sinirbiwan na hilay na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hin nayari anay Awlon Pa-mainawa, ta hinomlop anay awlo, halban main masakit maskin anyamay klasin masakit la ay inawit koni Jesus nin hilay kawkalamoan la ha bali. Bi-sa imparna ni Jesus a gamot na ha balang a-sa konla ta pinaabig na hila. ");
INSERT INTO xsb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Main anamaot lako a tawtawon nilooban nin dawdoka a ispirito. Hin ya-rin a ampalayahon ni Jesus a dawdoka a ispirito ay wanlan an-iaaghaw, “Hika yay Cristo a Anak nan Dios.” Kot hinaar na hila ni Jesus ta kay na labay a manalita hila ta tanda la a hiya yay Cristo. ");
INSERT INTO xsb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hin bandan boklah, inomalih hi Jesus ta nako ya ha a-say logar a homin katawo-tawo. Tiningkap la yan tawtawo. Bi-sa hin na-kit la ya ay impaki-totol la a ando ya omalih itaw konla. ");
INSERT INTO xsb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kot wani Jesus konla, “Kailangan ipangaral koy namaot ha lawlaloman babali yay Labah a Balita tongkol ha pa-mag-ari nan Dios, ta yadti a pinanogoan kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nako yay naor hi Jesus ha lawlogar nin probinsyan Galilea ta nangaral ya itaw ha sawsinagoga. ");
INSERT INTO xsb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A-say awlo, itaw hi Jesus ha liglig Alindayat Genesaret. Ampipoporporan la yan tawtawo ta labay lan malngo a halita nan Dios a an-ipangaral na. ");
INSERT INTO xsb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na-kit ni Jesus a main loway baloto a nakadoong ha liglig alindayat. Hilay maninilay a main ikon nin yadtaw loway baloto ay nakalakah ana, tan an-iwahwah lay nay aw-ikot la. ");
INSERT INTO xsb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nilomolan hi Jesus konan yay baloto a ikon ni Simon. Impaki-totol na kona a idayô nadti nin daoto ha liglig. Tinomoklo hi Jesus ha baloto bi-sa nanoro yay na konlan tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hin nayari yan nanoro, wana koni Simon, “Mako kamo ha malalo ta idabo moyoy aw-ikot moyo pigaw makakwa kamon kawkonâ.” ");
INSERT INTO xsb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kot wani Simon koni Jesus, “Maistro, nikakayabi kamin nanilay kot homin kamin nakwa. Kot bana ta hinalita mo, idabo mi naman a aw-ikot.” ");
INSERT INTO xsb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hin naidabo lay naor a aw-ikot, nakakwa hilan golpin konâ, kanya halos magi-nit a ikot la. ");
INSERT INTO xsb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kinawoy lay kawkalamoan la a itaw ha a-sa ot a baloto para patambay. Kanya nako hilay naor. Napno lay loway baloto nin kawkonâ anggan halos lomdog hila. ");
INSERT INTO xsb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hin na-kit na-rin ni Simon Pedro ay nanalimokor ya koni Jesus, wana, “Katawan, paka-dayo ka kongko ta a-sa kon makasalanan.” ");
INSERT INTO xsb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Na-halita na-rin bana ta nag-ispanta ya, pati hilay halban kalamoan na, ha golpin kona a nakwa la. ");
INSERT INTO xsb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hila man a kasosyo nan hi Santiago tan hi Juan a awa-nak ni Zebedeo ay nag-ispantay namaot. Wani Jesus koni Simon, “Ando ka mali-mo ta paibat hawanin ay pa-hal manilay kan tawtawo para tompol hila kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hin nailiglig lay bawbaloto la, imbati lay halban ta hinomonol hilay na koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A-say awlo, hin itaw ya hi Jesus ha a-say babali, main nako kona nin a-say lalakin pono kitong a lalaman na. Pa-maka-kit na koni Jesus, nanalimokor yan palokob ha arapan na. Nagpasi-singa-ro ya, wana, “Maistro, no labayon mo, ma-paabig mo ko.” ");
INSERT INTO xsb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Imparna ni Jesus a gamot na kona, wana, “Labay ko. Omabig kay na!” Antimanoy naor, inomabig ya. ");
INSERT INTO xsb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Binibilinan na ya ni Jesus nin ando na iba-balita yadti ha hinoman. Nokay wana kona, “Magdiritso ka ha pari ha Jerusalem pigaw ma-paptogan nan inomabig kay na. Mangawit kan ida-ton mo para ha sirimonyan pa-manglinis ayon ha impanogo ni Moises a pamilbian lan tawtawo a labah kay na.” ");
INSERT INTO xsb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Anodtaw pa man, laloy na ingat nibantog a balita tongkol koni Jesus. Kanya golpin tawon ampako kona para manglongo tan para paabigon na hila ha mawmasakit la. ");
INSERT INTO xsb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kot mabotbot yan ampoma-lilih hi Jesus konlan tawtawo ta ampako ya ha logar a ambo matawo ta andomawat ha Dios. ");
INSERT INTO xsb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ninghan, hin ampanoro hi Jesus, main omnoy paw-Pariseo tan mawmaistron kapanogoan a naki-toklo itaw. Main konla a ibat ha bawbaryon probinsyan Galilea, tan bawbaryon probinsyan Judea, tan main anamaot ibat ha syodad Jerusalem. Iti koni Jesus yay kapangyarian nan Dios a Katawan, kanya angka-paabig na hilay main masakit. ");
INSERT INTO xsb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Main nakalato nin omnoy lalaki, awit lay a-say lalakin paralitiko nin iti ha an-iraan na. Naningkap hilan paralan para mailoob la ya ha bali tan maipaka-dani koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kot kay la nagawa bana ha kalakan tawo. Kanya noli hila ha bobongan ta nanglobot hila ha tobon ni Jesus. Bi-sa in-ogoh lay paralitiko nin iti ha an-iraan na ha arapan ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hin na-kit ni Jesus no pa-no ka-got a main lan katotpol, wana konan paralitiko, “Amigo, pinatawad koy nay kawkasalanan mo.” ");
INSERT INTO xsb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hilay mawmaistron kapanogoan tan paw-Pariseo itaw ay wanla ha lalo nakom la, “Hino ya kot ta an-ipantay nay sarili na ha Dios, anta Dios bongat a ampaka-patawad nin kawkasalanan?” ");
INSERT INTO xsb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Palibhasay tanda ni Jesus a laman isip la, wana konla, “Anongkot anorin a an-isipon moyo? ");
INSERT INTO xsb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Anya kot yay mas maganoh gaw-on maskin homin kapangyarian, yay halitaon konan paralitiko, ‘Pinatawad koy nay kawkasalanan mo,’ o yay halitaon kona, ‘Mibangon ka ta lomalako ka’? ");
INSERT INTO xsb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ipa-kit ko komoyo hawanin ha pa-maabig ko konan yadtin tawo a hiko a Naglalaman Tawo ay main akoy namaot kapangyarian magpatawad nin kawkasalanan iti ha lota.” Bi-sa wana konan paralitiko, “An-imanda ko komo: Mibangon ka, kowon moy an-iraan mo ta morong kay na.” ");
INSERT INTO xsb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Antimano, nibangon yay naor nin angka-kit lan halban tawtawo itaw. Bi-sa kinwa nay iniraan na ta norong ya nin ampamori ha Dios. ");
INSERT INTO xsb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naka-ngap hilay halban ampangimaton, pinori la yay Dios, tan nagkamain hila ot hoston kali-mowan kona. Wanla ha a-sa tan a-sa, “Talagan kapa-paispantay na-kit tamon nangyari hawanin awlo.” ");
INSERT INTO xsb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pa-makayari ay inomalih hi Jesus itaw. Ha kala-lalako na, main yan na-kit a-say ma-ni-non bowis a yay ngalan kot Levi a antoklo ha opisinan ampamayaran bowis. Wani Jesus kona, “Homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Inomdong yay naor, imbati nay halban ta hinomonol yay na koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bi-sa naghanda yan mahi-ban a handaan ha bali na para koni Jesus. Kalakan ma-ni-non bowis a mangahaol tan laloma ot a tawtawo a kalamo lan ampangan hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Main paw-Pariseo tan kawkalamoan la a mawmaistron kapanogoan a naka-kit konla. Ni-panalamorom hila, ta bi-sa wanla konlan dawdisipolos ni Jesus, “Anongkot ampakirongo kamon mangan tan minom konlan ma-ni-non bowis tan laloma ot a tawtawon makasalanan?” ");
INSERT INTO xsb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wanan in-obat ni Jesus konla a imparalan ha alimbawa, “Ambo hilay mawmaligsa a ampangailangan nin doktor, nokay hilay mawmain masakit. ");
INSERT INTO xsb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anorin kapara kongko, yay pa-mako ko iti ay ambo para ha-wayan hilay hay wanla lawlabah hilan tawo, nokay para paombabalyon hilay mawmakasalanan.” ");
INSERT INTO xsb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hawanin, main namastang koni Jesus, wanla, “Hilay antoroan ni Juan ay mabotbot ampagsakripisyon kay mangan, tan mabotbot andomawat, tan anorin anamaot kapara konlan hilay antoroan lan Pariseo. Anongkot hilay dawdisipolos mo ay ampangan tan ampinom maskin anyakamay awlo?” ");
INSERT INTO xsb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Inobat na hila ni Jesus nin in-alimbawa nay sarili na ha a-say nobyo, wana, “Magawa moyo doman nin kay biyan pa-mangan hilay kombidado ha kahal lo-gan kalamoan la yay nobyo? ");
INSERT INTO xsb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Balo ta lomato yay panaon a ambo la yay nan kalamoan a nobyo, ison hilay na magsakripisyon kay mangan.” ");
INSERT INTO xsb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bi-sa imparalan ni Jesus ha aw-alimbawa a yay ba-yon totoro na ay ambo dapat ilamo ha naiknawan a kaogalian nin rilihyon a bilang ha pa-magsakripisyon kay mangan tan laloma ot, ta wana, “Homin manira nin ba-yon ayhing para italo-nob anan bongat ha lapok anan ayhing. Ta no gaw-on na-rin, mahira yay ba-yon ayhing bi-sa yay intalo-nob a ba-yo ay kay syimpri mibagay ha lapok anan ayhing. ");
INSERT INTO xsb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Anorin anamaot kapara, kay an-igwa a ba-yon alak a ampag-alsa ot ha pamigwaan a lapok a katat. Ta no anorin a gaw-on, ha kaaalsa nan ba-yon alak ay lomtoh yay pinamigwaan, masayang yay alak, tan mahira ot yay pinamigwaan. ");
INSERT INTO xsb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kailangan yay ba-yon alak a ampag-alsa ot ay itobong ha ba-yon pamigwaan pigaw parihon kay masayang.” ");
INSERT INTO xsb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wana ot ni Jesus nin in-alimbawa, “Homin anamaot tawon naka-taway nin tinaonan a alak a tampol malabay nin alak a ba-yon gawa, ta para kona ay mas malahap yay tinaonan.” ");
INSERT INTO xsb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hin homonol a Awlon Pa-mainawa lan aw-Israelita, nagpa-wan hi Jesus tan hilay dawdisipolos na ha bowat. Nangto hilay dawdisipolos nin trigo, bi-sa la piniri-piri ta kinan. ");
INSERT INTO xsb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kot main paw-Pariseo a naka-kit konla, kanya wanla, “Anongkot anorin a anggaw-on moyo, anta bawal orin ha Awlon Pa-mainawa ta an-itoring trabaho?” ");
INSERT INTO xsb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kot wanan in-obat ni Jesus, “Ambo doman nabasa moyodtaw ginwa ni David tan hilay kawkalamoan na hin mabitil hilay na? ");
INSERT INTO xsb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ambo doman nilomoob ya ha impagka-bali nan Dios, tan kinwa na yay tinapay a inda-ton ha Dios a inimbi nan pari kona, ta nangan ya pati hilay kawkalamoan na a binyan nay namaot? Bawal komon ayon ha kapanogoan nan Dios a kanon ladtaw bana ta para bongat ha pawpari. Kot ambo anan bawal ta inimbi naor konla.” ");
INSERT INTO xsb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bi-sa wana ot ni Jesus konla, “Hiko a Naglalaman Tawo a makaolay no anyay dapat ha Awlon Pa-mainawa.” ");
INSERT INTO xsb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hin a-say naman a Awlon Pa-mainawa, nako hi Jesus ha sinagoga ta nanoro ya. Hin ya-rin ay main a-say lalaki itaw a paralitikoy wanan gamot. ");
INSERT INTO xsb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hilay mawmaistron kapanogoan tan hiladtaw paw-Pariseo ay amba-bantayan la hi Jesus, no mamaabig ya ha Awlon Pa-mainawa pigaw main hilan maikaso laban kona. ");
INSERT INTO xsb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kot tanda ni Jesus yay an-isipon la, kanya wana konan lalakin paralitikoy gamot, “Mako ka-ti ha arapan.” Kanya nako ya ta inomdong ha arapan. ");
INSERT INTO xsb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hawanin, wani Jesus konlan tawtawo itaw, “Main akon pastang komoyo: Anyay dapat gaw-on ha Awlon Pa-mainawa ayon ha kawkapanogoan nan Dios, gomawa labah o gomawa doka? Mamilipyas biyay o mangmati?” ");
INSERT INTO xsb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hin ya-rin ay hinilap na hilay halban, bi-sa wana konan lalakin paralitikoy gamot, “Ipa-nat moy gamot mo.” Impa-nat nay naor, kanya antimano inomabig a gamot na ta nag-in anan bilang ha dobali. ");
INSERT INTO xsb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inomamot a olo lan mawmaistron kapanogoan tan paw-Pariseo, kanya pinipapa-nowan la no anyay dapat lan gaw-on koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hin ya-rin ay nako hi Jesus ha a-say bakil para domawat. Nikakayabi ya itaw nin dinomawat ha Dios. ");
INSERT INTO xsb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kinadilapan, hina-wayan na hilay dawdisipolos na ta namili ya konla nin labinlowa a hina-wayan nan aw-apostolis labay totolon ihohogo. ");
INSERT INTO xsb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hila ay hi Simon a pinangalanan nan Pedro, hi Andres a talakaka nan yadtin hi Pedro, hi Santiago, hi Juan, hi Felipe, hi Bartolome, ");
INSERT INTO xsb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","hi Mateo, hi Tomas, hi Santiago a anak ni Alfeo, hi Simon a mainakit ha nasyon Israel, ");
INSERT INTO xsb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","hi Judas a anak ni Santiago, tan hi Judas Iscariote a nagtraidor koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pa-makayari odtaw ay nilomoyhon hilay na ni Jesus ibat ha bakil. Tinomgon hila itaw ha kapatagan a pinititiponan nin lako ot a dawdisipolos na, tan golpin tawo a ibat ha intiron probinsyan Judea, ha syodad Jerusalem, tan ha loway syodad Tiro tan Sidon ha liglig ambay. Nako hila itaw hin ya-rin para manglongo nin totoro ni Jesus tan para paabigon na hila ha main lan masakit. ");
INSERT INTO xsb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hiladtaw nilooban dawdoka a ispirito ay inomabig ta pinalayah ni Jesus yay dawdoka a ispirito konla. ");
INSERT INTO xsb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Halban anamaot tawtawo itaw a main masakit ay nagpilit nin maaptoh hi Jesus, ta tanda la a main kapangyarian a angkaibat kona. Kanya halban nangaptoh kona ay inomabig. ");
INSERT INTO xsb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na-paongganan, hinilap ni Jesus hilay dawdisipolos na, bi-sa wana konla, “Makalma kamoy mawmairap ta kabilang kamo konlan ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Makalma kamoy angka-bitilan hawanin ta pabhoyon na kamon Dios. Makalma kamoy anlomolo hawanin ta paligawon na kamon Dios. ");
INSERT INTO xsb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Makalma kamo no bana ha kaho-honol moyo kongko a Naglalaman Tawo ay antiplonon la kamon tawtawo, an-ipoyra ha main lan gawgropo, amparorokaon, o an-itoring dawdoka a tawo. ");
INSERT INTO xsb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ha awlon anggaw-on ladti komoyo, lomilikot kamo tan lomokho ha kaligawan ta isipon moyo a mahi-ban a itobalo nan Dios komoyo ha langit. Tan isipon moyo a yay anggaw-on lan doka komoyo hawanin ay ginwa anamaot nin kawkapapo-papoan la konlan pawpropita nan Dios hin o-nan panaon. ");
INSERT INTO xsb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kot, ka-ka-roy ogotan moyo, hikamo a mawmayaman hawanin ta nangonswilo kamoy na iti ha lota. ");
INSERT INTO xsb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ka-ka-roy namaot a ogotan moyo, hikamo a ampi-pora-pora hawanin ta ma-bitilan kamo. Ka-ka-roy namaot a ogotan moyo, hikamo a ampi-pag-omlih hawanin ta lomolo kamo tan tomangih. ");
INSERT INTO xsb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ka-ka-roy namaot a ogotan moyo, no amporiwon la kamo nin halos halban tawo, ta ison lomwah a bilang kamo konlan ampagkonwari pawpropita nan Dios hin o-nan panaon, a pinori namaot nin kawkapapo-papoan lan hila-rin tawtawon ampamori komoyo hawanin.” ");
INSERT INTO xsb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kot hikamo a ampanglongo kongko,” wanan impagpatoloy ni Jesus, “oyay ibalita ko komoyo: Labyon moyo maskin hilay angkomontra komoyo tan pangwaan moyon abig hilay ampaniplon komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Idawat moyo hilay ampamihompa komoyo a payabolan na hilan Dios nin abig, tan anorin kapara, idawat moyoy namaot hilay ampana-damsak komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Alimbawa, no main nanampal komo, ipatampal mo ot a dobali nin lopa mo. Bi-sa, no main ampanamham nin alimonmon mo, ibi moy na ingat pati ayhing mo. ");
INSERT INTO xsb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mami ka ha balang ampakirawat komo. Tan no wari man ta main nangwa nin kama-main mo, ando moy na balawion. ");
INSERT INTO xsb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Yay bawbagay a labay moyon gaw-on la komoyo nin kapara ay yadtaw anamaot a dapat moyon gaw-on konla. ");
INSERT INTO xsb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“No wari ta hila bongat a ampanglabi komoyo a anlabyon moyo, marapat kamo wari poriwon? Hila man a mawmakasalanan ay anlabyon lay namaot hilay ampanglabi konla. ");
INSERT INTO xsb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A-sa ot, no hiladtaw bongat anggomwa abig komoyo a pangwaan moyon abig, marapat kamo wari poriwon? Hila man a mawmakasalanan ay anorin syimpri a anggaw-on la. ");
INSERT INTO xsb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","No ampama-ram kamon bongat konlan hiladtaw a ampasimalaan moyon makabayar komoyo, marapat kamo wari poriwon? Hila man a mawmakasalanan ay ampamaotang hila syimpri konlan kapara lan makasalanan, no tanda la a makabayar hila. ");
INSERT INTO xsb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kot hikamo, labyon moyo maski hilay angkomontra komoyo, pangwaan moyo hilan abig, tan mama-ram kamo nin kay omasa ha anyakaman a kabayaran. No gaw-on moyo-rin, magkamain kamon mahi-ban a tobalo ibat ha Dios. Bi-sa ma-bilbi a hikamo kot awa-nak nan sangkata-ta-gayan a Dios, bana ta labah ya maski konlan dawdoka a tawo tan konlan kay ambomilbi otang nakom. ");
INSERT INTO xsb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kanya dapat mag-in kamon mainganga-rowon a bilang konan Ama moyo ha langit.” ");
INSERT INTO xsb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ando kamo manosga ha kapara moyo pigaw kay na kamo hosgawon nin Dios ha lomato a panaon. Ando moyo halitaon a yay a-say tawo kot dapat parosawan nan Dios, pigaw kay na kamo parosawan nin Dios. Patawaron moyo hilay kapara moyo pigaw patawaron na kamoy namaot Dios. ");
INSERT INTO xsb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mami kamo ha kapara moyo ta biyan na kamoy namaot Dios. Tan yay pa-mami na komoyo ay pa-hal hoston hokat, pino-porpor tan niyo-yogyog, bi-sa ponoon ot anggan mila-labwa. Kanya no pa-noy trato moyo ha kapara ay anorin anamaot a gaw-on nan Dios komoyo.” ");
INSERT INTO xsb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hin ya-rin ay nami ya ot nin alimbawa hi Jesus, wana, “Makapangakay wari a a-say bolag ha kapara nan bolag? Ambo doman no gaw-on na-rin ay pariho hilan madabo ha kanal? ");
INSERT INTO xsb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yay antoroan ay ambo yan mata-gay ha maistro na. Kot no ma-toroan yan hosto ay mag-in yan bilang konan maistro na. ");
INSERT INTO xsb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Halako mon angka-sikaso a pa-hal makalog a poling nin kapara mo, anta yay pa-hal mahi-ban a kayo ha mata mo kot kay mo angka-sikaso? ");
INSERT INTO xsb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dapat mo wari halitaon, ‘Talakaka, ipaalih mo kongkoy poling mo,’ anta hika, ni kay mo angka-sikaso a pa-hal mahi-ban a kayo ha mata mo? Ampiabig-abig ka! Kailangan alihon mo yapon yay pa-hal mahi-ban a kayo ha mata mo pigaw maka-kit kan labah, ta bi-sa maalih moy pa-hal makalog a poling nin kapara mo.” ");
INSERT INTO xsb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Wana ot ni Jesus nin in-alimbawa, “Ha kawkayon angka-kan a bonga, homin labah a klasi a ampamongan doka. Anorin anamaot kapara ha doka a klasin kayo, homin syimprin ampamongan labah a klasi. ");
INSERT INTO xsb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Balang klasin kayo ay ma-bilbi ha klasin bonga na. Yay bongan igos ay kay ya ampotiwon ha poon aroma. Anorin anamaot kapara, kay ampotiwon a bongan obas ha poon kokoh posa. ");
INSERT INTO xsb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Anorin ot bongat syimpri ha tawo. Yay labah a tawo ay ampakapamin kaabigan ibat ha lawlabah a aral a natipon na ha main nan kanakoman. Kot yay doka a tawo ay karokaan a angkaibi na ibat ha dawdoka a natipon na ha main nan kanakoman. Nga-min, no anyay laman nin kaisipan, lomwah ta lomwah ha boboy.” ");
INSERT INTO xsb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Wana ot ni Jesus, “Anongkot anha-wayan moyo kon ‘Katawan, Katawan’, anta kay moyoy namaot anhonolon a anhalitaon ko komoyo? ");
INSERT INTO xsb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ibalita ko komoyo no ayti maiparis yay tawon andomani kongko, ampanglongo tan anhomonol ha hawhalita ko: ");
INSERT INTO xsb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kaalimbawaan na ay a-say tawon ampama-dong bali. Yay ginwa na yapon ay nangotkot yan malalo anggan naabot a bato ta bi-sa ison na impondasyon a bali. Kanya hin nagbaha tan inagohan makhaw a lanom yay bali, kay nayogo ta nakapondasyon naor ha bato. ");
INSERT INTO xsb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kot yay ampanglongo bongat nin hawhalita ko, balo ta kay na anhonolon ay bilang ha a-say tawon nama-dong bali nin homin pondasyon ta basta impa-dong ha lota. Kanya hin nagbaha tan inagohan makhaw a lanom yay bali, antimano natomba kanya grabi a pa-makahira.” ");
INSERT INTO xsb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hin nayari nan intoro ni Jesus odtin halban konlan tawtawo, norong ya ha babalin Capernaum. ");
INSERT INTO xsb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Itaw ay main a-say dayowan a kapitan hondalo nin Roma. Main yan a-say alila a mabli kona a hin ya-rin ay ampagmasakit tan magay na mati. ");
INSERT INTO xsb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hin na-tandaan nan yadtin kapitan yay tongkol koni Jesus, nanogo ya nin omnoy Israelita a pawpoon nin ya-rin a babali, para ipaki-totol koni Jesus a kaon nay alila na para paabigon. ");
INSERT INTO xsb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hin kina la hi Jesus ay impasi-singa-ro lan labah a nakom a paabigon na yay alila nan kapitan, ta wanla, “Yadtin kapitan ay marapat yan tambayan. ");
INSERT INTO xsb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nga-min, malabi ya kontamon aw-Israelita tan impama-dong na tamon sinagoga.” ");
INSERT INTO xsb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hawanin, naki-ka hi Jesus konla. Hin madani hilay na ha bali, nanogo yay kapitan nin omnoy amigo na para homakbat koni Jesus ta impabalita nay anodti: “Maistro, ando kay na kano mag-abala nin omabot ha bali nan kapitan, ta ambo ya kanon karapat-dapat kaon ha bali na. ");
INSERT INTO xsb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni homakbat komo ay ambo ya kanon karapat-dapat. Basta manalita ka tana kano a omabig a alila na ta omabig ya man. ");
INSERT INTO xsb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nga-min, hiya man kano ay main yan poon tan main yay namaot ga-got a hawhondalo. No wana kano ha a-say hondalo na, ‘Mako ka itaw!’ mako ya. No wanay namaot ha a-sa, ‘Mako ka iti!’ mako ya syimpri. Anorin anamaot kapara ha alila na, no wana konay, ‘Gaw-on modti!’ gaw-on na.” ");
INSERT INTO xsb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Naka-ngap hi Jesus hin nalngo na-rin. Hawanin, inomarap ya konlan malabong a tawon an-omaloyon kona, ta wana, “Oyay ibalita ko komoyo: Ni kontamon Israelita ay homin ako ot na-kit a main anorin kakhaw a katotpol.” ");
INSERT INTO xsb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hin nagbolta hilay na ha bali hiladtaw inhogo nan kapitan, na-lato lay naor a inomabig anay alila na. ");
INSERT INTO xsb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kay naboyot, nako ya hi Jesus ha babalin Nain, kalamo hilay dawdisipolos na tan lako ot a tawo. ");
INSERT INTO xsb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hin madani hilay na ha poltan padir nin babali, naka-hakbat hilan malabong a tawon ampakipanabon. Yay nati ay a-say lalaki a kasya-syan anak nin a-say babayin balo. ");
INSERT INTO xsb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hin na-kit ni Jesus yay babayin balo, nainga-rowan na ya. Kanya wana kona, “Ando kay na tomangih.” ");
INSERT INTO xsb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bi-sa dinomani hi Jesus ha longon ta gina-gotan nadti. Kanya tinomgon hilay ampamalatay. Hawanin, wani Jesus konan nati, “Ali ko, an-imanda ko komo, mibangon ka!” ");
INSERT INTO xsb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nibangon anaor a nati tan nanalita. Bi-sa inimbi na ya ni Jesus konan nanay na. ");
INSERT INTO xsb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Halban la itaw ay naka-ngap tan pinori la yay Dios, wanla, “A-say makapangyayarin propita nan Dios a nilomato kontamo. Ininga-rowan na tamon Dios hitamoy tawtawo na.” ");
INSERT INTO xsb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hin ya-rin ay nibantog ha intiron probinsyan Judea tan ha kawka-danin logar yadtin balita tongkol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hin ya-rin ay nakapriso hi Juan Bautista. Imbalita la kona nin hilay tinoroan na a halban bawbagay a anggaw-on ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kanya pinadani ni Juan a lowa konlan tinoroan na ta inhogo na hilan mamastang koni Jesus nin anodti, “Hikay na doman odtaw ampalatoon a ihogo nan Dios, o main ot doman laloman taga-nan?” ");
INSERT INTO xsb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pa-makalato lan hilay loway inhogo ni Juan Bautista koni Jesus, wanlan imbalita, “Inhogo na kami ni Juan para pastangon no hikay na doman kano odtaw ampalatoon a ihogo nan Dios, o main ot doman laloman taga-nan?” ");
INSERT INTO xsb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hin ya-rin ay ampamaabig hi Jesus nin lako a tawon main masakit tan dipirinsya. Pina-palayah nay namaot a dawdoka a ispirito konlan hilay nangalolooban, tan pina-paabig nay bawbolag pigaw hila maka-kit. ");
INSERT INTO xsb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bi-sa wanan in-obat ni Jesus konlan inhogo ni Juan, “Magbolta kamo koni Juan ta ibalita moyoy na-kit tan nalngo moyo: Hilay bawbolag ay ampaka-kit ana, hilay lawlompo ampakalalakoy na, hilay main masakit kitong ampaabigon ana, hilay tawtolok ampakalngo ana, main ni-kati a ampaorongon mabyay, tan hilay mangairap ay an-abotan anan Labah a Balita tongkol ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ibalita moyoy namaot a makalma yay tawon kay ampagdoda a hikoy inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hin inomalih hilay nay inhogo ni Juan Bautista, main yan imbalita hi Jesus konlan malabong a tawo itaw tongkol koni Juan, wana, “Hin nako kamo koni Juan itaw ha disyirto, anya kot a labay moyon ma-kit? Tawo doman a paba-yo-ba-yoy isip a bilang ha talaib a ampaki-ki-ka ha lopot? Ambo yan anorin. ");
INSERT INTO xsb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Anya kot talagay labay moyon ma-kit? Tawo doman a nakaholot nin primira klasin doloh? Ambo anorin a na-kit moyo itaw, ta hilay nakaholot nin magandan klasi tan ampagbiyay ha kainomayan ay itaw hila ma-kit ha palasyo a an-iwanan ari. ");
INSERT INTO xsb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Anya no-nin a kina moyon biniliw itaw? Ambo doman a-say propita a mangangaral nan Dios? Ibalita ko komoyo a maholok ot ha a-say propita a na-kit moyo. ");
INSERT INTO xsb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nga-min, hi Juan yadtaw antokoyon ha Masanton Kasolatan a wanan Dios, ‘Main akon ihogo nin mo-na komo A mamiparihadon kanakoman lan tawtawo para ha main mon kala-lato.’ ");
INSERT INTO xsb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ibalita ko komoyo, ha halban tawon impangabing, homin ot propitan homolok koni Juan. Anorin man, maskin yay tawon an-ibilang nin pinakamaaypa konlan ampag-arian nan Dios ay holok ot koni Juan. ");
INSERT INTO xsb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Halban lan tawtawo a nanglongo koni Juan, pati hilay ma-ni-non bowis ay binilbi la a tama yay Dios ha kawkapanogoan na, kanya nagpabaotismo hila koni Juan. ");
INSERT INTO xsb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kot hilay paw-Pariseo tan mawmaistron kapanogoan ay tinanggiwan lay plano nan Dios ha main lan biyay ta kay hila nagpabaotismo koni Juan.” ");
INSERT INTO xsb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bi-sa wana ot ni Jesus a Katawan, “Ayti ko kari iparis a tawtawo nin yadtin panaon? Anyay kaalimbawaan la? ");
INSERT INTO xsb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bilang hilan awa-nak a ampiikap ha plasa a angkasora ha kawkaikap la, a wanla, ‘Ampanogtog kami para komoyo, kot kay moyo labay bomayli! Ampiaanito-anito kami ot, kot kay moyo syimpri labay ki-tangih-tangih komi!’ ");
INSERT INTO xsb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Anorin anamaot kapara koni Juan Bautista, angkasorawan moyo ya ta mabotbot yan ampagsakripisyon kay mangan tan kay ya ampinom alak. Kanya anhalitaon moyo a nilooban yan doka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bi-sa, hiko a Naglalaman Tawo ay ampangan tan ampinom. Bi-sa anhalitaon moyo a hiko kot lo-noh tan ma-maglahing, tan ampakiamigo konlan ma-ni-non bowis tan laloma ot a tawtawon makasalanan. ");
INSERT INTO xsb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kot yay ampango-na komi ay karonongan ibat ha Dios, ta angka-patnagan syimpri ha biyay nin balang anhomonol komi.” ");
INSERT INTO xsb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ninghan, hi Simon a a-say Pariseo ay hinagyat na hi Jesus nin mangan itaw konla. Kanya naki-ka hi Jesus ha bali na ta nakirongo yan nangan. ");
INSERT INTO xsb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Konan ya-rin a babali ay main a-say babayin bilbi a makasalanan. Hin na-tandaan na a ampangan hi Jesus konli Simon, nako yan main awit nin mablin klasin pabanglo a nakaigwa ha botin gawa ha alabastro. ");
INSERT INTO xsb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Inomdong yadtin babayi ha bokotan ni Jesus nin antangih. Ha kata-tangih na ay na-toloan lowâ a ayi ni Jesus, kanya pinonahan nan habot na. Bi-sa inalokan nay ayi ni Jesus tan pinonahan na ot nin pabanglo. ");
INSERT INTO xsb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hin na-kit nadti ni Simon, a nanagyat koni Jesus, wana ha lalo nakom na, “No wari ta a-sa yan propita yadtin tawo, komon tanda na no hino ya-rin ampamonah kona tan no anyay klasin babayi ya-rin ta a-sa yan makasalanan.” ");
INSERT INTO xsb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Palibhasay tanda ni Jesus no anyay iti ha lalo nakom ni Simon, kanya wana kona, “Simon, main akon labay ibalita komo.” “Anya kot orin, Maistro?” wanan in-obat ni Simon. ");
INSERT INTO xsb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hawanin, nangistorya ya hi Jesus, wana, “Main loway tawon nangotang kwarta ha a-say ma-maotang. Yay a-sa ay nangotang nin limanyatos tan yay a-say namaot ay limampolo. ");
INSERT INTO xsb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hin kay hila makabayar, pariho na hilan ininga-rowan. Hawanin, hino wari konlan lowa a mas manglabi konan yay namaotang?” pastang ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Ha intindi ko,” wanan in-obat ni Simon, “yadtaw ininga-rowan na ha mahi-ban a otang.” “Tama a obat mo,” wani Jesus kona. ");
INSERT INTO xsb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hin ya-rin ay binomling hi Jesus konan babayi, ta wana koni Simon, “Bilyon modtin babayi. Hin nilomoob ako iti ha bali mo, kay mo ko binyan lanom nin ipangoyah ayi ko. Kot hiya, inoyahan nay ayi ko nin lowâ na ta bi-sa pinonahan nan habot na. ");
INSERT INTO xsb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kay mo ko inalokan bilang pa-nanggap mo kongko. Kot hiya, paibat hin iti ko ay kay ya tinomgon nin nangalok ayi ko, pamilbian nin main nan kaga-galang kongko. ");
INSERT INTO xsb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kay moy namaot nilanawan a olo ko ha pa-nanggap mo kongko. Kot hiya, pinonahan nan pabanglo a ayi ko. ");
INSERT INTO xsb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanya ibalita ko komo, yay kahi-banan labi a impa-kit na kongko a ampamaptog a na-patawad anay kalakan kawkasalanan na. Kot yay tawon na-patawad ha daoto a kasalanan ay daoto anamaot a an-ipa-kit nan labi.” ");
INSERT INTO xsb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bi-sa wani Jesus konan babayi, “Pinatawad koy nay kawkasalanan mo.” ");
INSERT INTO xsb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kot hilay karongo nan ampangan hin ya-rin ay wanla ha lalo nakom la, “Hino ya kari odti ta maski pa-matawad nin kawkasalanan ay anggaw-on na?” ");
INSERT INTO xsb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kot wani Jesus konan babayi, “Libri kay na ha kaparosawan nin kawkasalanan mo bana ha main mon katotpol. Morong kay nan malisway a nakom.” ");
INSERT INTO xsb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kay naboyot, nako hi Jesus ha bawbabali tan bawbaryo ta an-ipangaral nay Labah a Balita tongkol ha pa-mag-ari nan Dios. Kalamo na hilay labinloway disipolos na, ");
INSERT INTO xsb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tan main anamaot bawbabayin naki-ka kona. Main konla a pinaabig na hin yadtaw ha mawmasakit la, tan hilay laloma konla ay pinalayah nay dawdoka a ispirito a nilomoob ha main lan lalaman. Kalamo ison yay anha-wayan Maria Magdalena a pinamalayahan nan pitoy doka a ispirito, ");
INSERT INTO xsb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","hi Juana a kaambali ni Cusa a ma-ngasiwa ni Ari Herodes Antipas, hi Susana tan lako ot. Hiladtin bawbabayi a nanostos ha pawpangangailangan ni Jesus ibat ha main lan kawkama-main. ");
INSERT INTO xsb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ninghan, golpin tawoy nititipon koni Jesus a nangibat ha bawbina-babali. Hin ya-rin ay tinoroan na hila nin imparalan ha alimbawa, wana, ");
INSERT INTO xsb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Main a-say tawon nako nanabwag bini. Ha pananabwag na, main bini a ni-ka ha dalan, bi-sa na-dakat-dakat ladtin tawtawo, ba-yo kinan lan mawmanok-manok. ");
INSERT INTO xsb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Main anamaot ni-ka ha mabato, bi-sa hin tinomobo, tampol nalanoh bana ta maklang a lota. ");
INSERT INTO xsb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Main anamaot ni-ka ha logar a antoboan dawdikot a marowih. Kato-tobo nan bini, nagsalidan tinomobo anamaot a dawdikot, kanya kay nakaaliwahwah. ");
INSERT INTO xsb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Balo ta yay bini a nadabo ha magandan lota ay tinomobo bi-sa ni-pamongan mananyatos.” Bi-sa, bilang oltimon bibilin ni Jesus, wana ha makhaw a bosis, “Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hin ya-rin ay pinastang la ya hi Jesus nin hilay dawdisipolos na no anyay labay totolon nin yadtaw alimbawa. ");
INSERT INTO xsb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kanya wana konla, “Komoyon bongat an-ipaintindyan a sawsikrito tongkol ha pa-mag-ari nan Dios. Kot konlan laloma, an-iparalan odti ha aw-alimbawa, kanya ampomtog odtin nakasolat a wanan Dios: ‘Mamiliw hila man anan mamiliw kot kay hila maka-bilbi, Tan manglongo hila man anan manglongo kot kay hila makaintindi.’” ");
INSERT INTO xsb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Wani Jesus, “Oyay labay totolon nin yadtaw alimbawa: Yay bini ay Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yay dalan a pini-kaan nin bini ay tawtawon ampanglongo Halita nan Dios. Kot anlomato hi Satanas ta an-alihon na ha main lan kanakoman yay Halita a nalngo la, pigaw kay hila tompol ha Dios a pangibatan kay hila malipyas. ");
INSERT INTO xsb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yay lota a mabato ay tawtawon ampanglongo Halita nan Dios, bi-sa ampi-polon ladti nin main kaligawan. Kot pa-hal kay ampakapangyamot odti ha nakom la. Antompol hila kot kado-domali bongat, ta pa-makalato nin pawpanonobok ha biyay la ay antomgon hilay na. ");
INSERT INTO xsb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yay lota a antoboan dawdikot a marowih a pini-kaan nin bini ay tawtawon ampanglongo Halita nan Dios, balo ta angkadaog yay Halita nan Dios a nalngo la bana ta ampag-aboridowan lay kabi-biyay, mailig hila ha kayamanan tan kawkaligawan iti ha mondo. Kanya kay ampamongan lawlabah a gawa a main lan biyay. ");
INSERT INTO xsb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kot yay magandan lota ay hiladtaw ampanglongo Halita nan Dios, bi-sa an-itanom ladti ha main lan nakom a maptog tan malinis. Kanya ha main lan pa-magpasinsya ay ampamongan lawlabah a gawa a main lan biyay.” ");
INSERT INTO xsb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bi-sa nami yay naman hi Jesus nin a-say alimbawa konlan dawdisipolos na ta labay nan ipatandaan la ha tawtawo yay tongkol ha an-itoro na konla, wana, “Homin tawon mamarta nin lamparilya ta bi-sa na wari hakban nin pasig o kari igwa ha hilong katri, nokay igwa na syimpri ha dapat pamigwaan pigaw hinoman a lomoob ha bali ay ma-kit nay hawang. ");
INSERT INTO xsb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anorin anamaot kapara, homin nakaari a kay ma-kit tan homin sikrito a kay ma-tandaan o mibolgar. ");
INSERT INTO xsb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kanya pakaabigon moyoy pa-manglongo moyo. Nga-min, hinoman a main anan na-tandaan ay pa-lahan ot orin, kot hinoman a kay ampama-lah ha main nan tanda, maskin yay wana tanda na ay alihon ot kona.” ");
INSERT INTO xsb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hawanin, kina la hi Jesus nin nanay na tan tawtalakaka nan lalaki, balo ta kay la ya ma-daniwan bana ha kalakan tawo. ");
INSERT INTO xsb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kanya main namibalita kona, wana, “Ison kano ha likol yay nanay tan tawtalakaka mo ta labay la kan ma-paki-kitan.” ");
INSERT INTO xsb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kot wani Jesus, “Hilay ampanglongo tan anhomonol ha Halita nan Dios ay an-itoring kon nanay tan tawtalakaka.” ");
INSERT INTO xsb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","A-say awlo, nilomolan hi Jesus ha baloto, kalamo hilay dawdisipolos na, ta wana konla, “Lomipay tamo ha alindayat.” Kanya nako hilay na. ");
INSERT INTO xsb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lo-gan lan anlomipay nin nakalayag, nakaka-lok hi Jesus. Tongwa, na-palatan hilan makhaw a lopot ha taaw, bi-sa angka-palamnan anan lanom yay baloto la, kanya dilikadoy nay pa-hal la. ");
INSERT INTO xsb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hin ya-rin ay kina lan pinokaw hi Jesus nin hilay dawdisipolos na, wanla, “Maistro! Maistro, lomdog tamoy na!” Nimata hi Jesus, bi-sa minandawan nan tomgon yay makhaw a lopot tan yay lalako a alon. Tinomgon anaor yay lopot tan yay alon, kanya bigla tinominok. ");
INSERT INTO xsb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hin ya-rin, wani Jesus konlan dawdisipolos na, “Homin kamo ot doman pa-masimala?” Kot awit nin main lan li-mo tan pa-maka-ngap, wanlan dawdisipolos ha a-sa tan a-sa, “Anya kari magklasin tawo yadti ta maskin lopot tan alon kot anhomonol kona?” ");
INSERT INTO xsb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nagpatoloy hilan nilomipay anggan niabot hila itaw ha logar lan Gadareno a ka-tobon nin probinsyan Galilea a pinangibatan la. ");
INSERT INTO xsb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pa-makainapat ni Jesus, main a-say lalaki a taga itaw ha babalin Gadara a anhomakbat kona. Nilooban yan dawdoka a ispirito nin naboyot anan panaon. Kay ya ampagdoloh ni ampi-wan ha bali, nokay itaw ya tana ampagpirmi ha kamposanto. ");
INSERT INTO xsb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pa-maka-kit na koni Jesus ay inomaghaw ya, bi-sa nanalimokor yan palokob ha arapan na. Ba-yo wana ha makhaw a bosis a impahalita lan dawdoka a ispirito, “Jesus, Anak nin sangkata-ta-gayan a Dios, anongkot ampakiomonan mo ko? An-ipasi-singa-ro ko komo, ando mo ko padya-dyaon.” ");
INSERT INTO xsb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hinalita nadti bana ta minandawan nay na ni Jesus yay doka a ispirito nin omalih konan lalaki. Nga-min, mabotbot yan sompongon yadtin lalaki gawa nin doka a ispirito, kanya yay anggaw-on lan tawtawo pigaw ma-bantayan la ya ay ambalolon la yan tikala ha gamot tan ayi. Balo ta angkaboyto na syimpri, bi-sa ampa-kaon na yan doka a ispirito itaw ha disyirto. ");
INSERT INTO xsb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hawanin, pinastang ni Jesus yay doka a ispirito, wana, “Anyay ngalan mo?” Wanan in-obat nan doka a ispirito, “Malabong.” Anorin a imbalita nan ngalan bana ta kalakan doka a ispirito a nilomoob konan ya-rin a lalaki. ");
INSERT INTO xsb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bi-sa nagpasi-singa-ro hilay dawdoka a ispirito koni Jesus a ando na hila pa-kaon itaw ha logar a homin panganggawan a kalaloan. ");
INSERT INTO xsb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hin ya-rin ay main itaw malabong a baboy a ampangkob ha liglig bakil. Impasi-singa-ro lan dawdoka a ispirito koni Jesus a payagan na hilan lomoob konlan hiladtaw bawbaboy. Kanya pinayagan na hila. ");
INSERT INTO xsb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Inomalih hilay naor a dawdoka a ispirito konan lalaki ta nilomoob konlan bawbaboy. Tongwa, halban lan baboy ay bigla nipo-polayon paloyhon ha bongaw diritson alindayat, kanya ni-ka-lilimoh hila. ");
INSERT INTO xsb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Hin na-kit lan ma-magbantay konlan bawbaboy a nangyari ay nolayo hilan nako ha babali tan ha bawbaryo ta imba-balita lay nangyari. ");
INSERT INTO xsb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kanya ni-pako hilay naka-balita para biliwon la no anya talagay nangyari. Pa-makalato la ha kamainan ni Jesus, na-kit la yadtaw lalakin pinamalayahan nin dawdoka a ispirito a antoklo ha dani ni Jesus nin nakaayhing ana ta norong anay sintido na. Nali-mo hila. ");
INSERT INTO xsb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hiladtaw mismon naka-kit ha nangyari a namibalita konlan nakalato no pa-no na-paabig yay lalakin nilooban nin dawdoka a ispirito. ");
INSERT INTO xsb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hawanin, hiladtin halban naibat ha intiron lawlogar a angka-hakopan nin babalin Gadara ay impaki-totol la koni Jesus a omalih yay na ha logar la ta masyado hilan angkali-mo. Kanya nilomolan hi Jesus ha baloto para magbolta hilay na. ");
INSERT INTO xsb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kot yay lalakin pinamalayahan nin dawdoka a ispirito ay impaki-totol na koni Jesus a maki-ka ya kona. Balo ta pinaorong na ya ni Jesus, a wana, ");
INSERT INTO xsb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Morong ka tana ta ibalita mo yay ka-paka-ngap a ginwa nan Dios komo.” Kanya norong yay na ta imba-balita na ha intiron babali yay ka-paka-ngap a ginwa ni Jesus kona. ");
INSERT INTO xsb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pa-makalato lay naman ni Jesus ha dobali alindayat, maliga la yan hinakbat nin tawtawo ta halban la ay ampana-gan kona. ");
INSERT INTO xsb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hin ya-rin ay main nakalato a-say lalaki a yay ngalan na kot Jairo. A-sa yan ampamoon ha sinagoga lan Israelita. Nanalimokor yan palokob ha danin ayi ni Jesus ta nagpasi-singa-ro yan maki-ka hi Jesus ha bali na. ");
INSERT INTO xsb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nga-min, yay ka-siya-siya nan anak a babayi a ampag-idad nin labinloway taon ay madani nan mati. Hin naki-ka hi Jesus kona ay ampipoporporan la yan tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hin ya-rin ay main anamaot a-say babayin labinloway taon anan andayaon a nakito-tombok koni Jesus. Na-min nay nan ginastos a kama-main na ha mawma-nambal a kina-kina na, kot homin syimprin naka-paabig kona. ");
INSERT INTO xsb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hawanin, dinomani ya ha bokotan ni Jesus ta kinowit nay palpal ayhing na. Antimano, tinomgon a kada-daya na. ");
INSERT INTO xsb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pastang ni Jesus, “Hinoy nangowit kongko?” Hin homin nangamin, wani Pedro tan hilay laloman kalamoan na, “Maistro, angka-palibolan tan ampipoporporan la kan malabong a tawtawo, bi-sa pastangon mo no hinoy nangowit komo.” ");
INSERT INTO xsb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kot wani Jesus, “Main nangowit kongko ta nalayam ko a main nilomwah kapangyarian ko.” ");
INSERT INTO xsb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hin na-tandaan nan babayi a tanda na payti ni Jesus, dinomani yan anggoygoy. Bi-sa nanalimokor yan palokob ha arapan ni Jesus ta imbalita nay potog ha arapan lan halban tawo no anongkot kinowit na hi Jesus tan no pa-no ya inomabig tampol. ");
INSERT INTO xsb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kanya wani Jesus kona, “Talakaka ko, ando kay na mali-mo. Inomabig ka bana ha main mon katotpol. Morong kay nan malisway a nakom.” ");
INSERT INTO xsb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lo-gan na ot ampanalita ni Jesus, main a-say lalakin nakalato ibat ha bali ni Jairo. Wana koni Jairo, “Ando moy na abalaon a Maistro ta nakihiyay yay nay anak mo.” ");
INSERT INTO xsb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pa-makalngo ni Jesus nin yadti, wana koni Jairo, “Ando ka mahalak, basta pasimala ka kongko ta mabyay ya syimpri.” ");
INSERT INTO xsb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hin nakalato hila ni Jesus ha bali ni Jairo, homin yan laloman pinaki-ka lomoob no ambo hilan bongat hi Pedro, hi Santiago, hi Juan tan hilay matoantawo nan anak. ");
INSERT INTO xsb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Halban lan tawtawo itaw ay antomangih tan ampiaanito bana konan anak. Kot wani Jesus, “Ando kamoy na tomangih ta kay ya nati, nokay angka-lok yan bongat.” ");
INSERT INTO xsb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kot kinaka-lihan la ya hi Jesus ta tanda lan nati yay nay anak. ");
INSERT INTO xsb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Balo ta pinalikol ni Jesus hilay halban, bi-sa ginawang nay gamot nan anak, ta wana kona, “Nini, mibangon ka.” ");
INSERT INTO xsb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nabyay yan oman a anak, kanya tampol yan nibangon. Bi-sa imbalita ni Jesus a biyan la yan pa-mangan a anak. ");
INSERT INTO xsb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nag-ispanta hilay matoantawo nan anak, kot binibilinan na hila ni Jesus nin ando la iba-balita a nangyari ha maskin hinoman. ");
INSERT INTO xsb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A-say awlo, tinipon ni Jesus hilay labinloway apostolis na ta binyan na hilan kapangyarian tan karapatan para mamalayah halban klasin doka a ispirito tan para mamaabig nin mawmasakit. ");
INSERT INTO xsb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Inhogo na hilan ipangaral yay tongkol ha pa-mag-ari nan Dios tan mamaabig konlan main masakit. ");
INSERT INTO xsb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kot binibilinan na hila yapon, wana, “Ha pa-mako moyo, ando kamoy na mangawit nin anyakaman, ni baston, bag, pa-mangan, kwarta o risirban ayhing. ");
INSERT INTO xsb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ha aytimay bali a ma-pakihandaan moyo ay itaw kamo tana anggan omalih kamo konan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kot no wari ta kay la kamo tanggapon ha a-say babali, omalih kamo itaw. Oltimon gabok ha ayi moyo ay pagpagon moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bi-sa nako hilay nay dawdisipolos ha bawbinaryo-baryo ta impangaral lay Labah a Balita tan pina-paabig lay main mawmasakit ha balang logar a kina-kina la. ");
INSERT INTO xsb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hin ya-rin, na-tandaan ni Ari Herodes Antipas a ampamoon ha probinsyan Galilea a halban bawbagay a ni-pangyari a gi-ginwa ni Jesus. Na-golowan a isip na ta main ampanalita tongkol koni Jesus a hiya hi Juan Bautista a norong nabyay. ");
INSERT INTO xsb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wanlan laloma, nagpa-kit hi Elias a propita nan Dios, tan wanlay namaot laloma, norong nabyay yay a-sa konlan pawpropita nan Dios hin o-nan panaon. ");
INSERT INTO xsb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kot yay wani Ari Herodes Antipas, “Impapo-tohan kon olo hi Juan Bautista. Hino ya man kari odtin tawon anggomwa nin anorin a bawbagay a angka-balitaan ko?” Paibat hin ya-rin ay labay nan ma-kit hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hin nagbolta hilay labinloway apostolis o disipolos ni Jesus, tinotol la konay halban ginwa la. Hin ya-rin ay inawit na hila ni Jesus nin hila-hilan bongat ha a-say logar a homin tawo a angka-hakopan nin babalin Betsaida. ");
INSERT INTO xsb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na-tandaan lan tawtawo a inomalih hi Jesus, kanya tinomombok hila kona. Tinanggap na hila ni Jesus nin labah a nakom, bi-sa nangaral ya konla tongkol ha pa-mag-ari nan Dios. Pinaabig na hilay namaot a main mawmasakit. ");
INSERT INTO xsb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Hin anyomabi na, dinomani hilay labinloway disipolos na kona, ta wanla, “Maistro, hapa no pa-kaon mo hilay nay tawtawo ha bawbaryo tan ha bawbali iti ha ka-libol pigaw maka-kit hilan ma-handaan la tan makahaliw ot nin ma-kan, bana ta iti tamo ha logar a homin kabali-bali.” ");
INSERT INTO xsb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kot wani Jesus konla, “Hikamoy nay mamin pa-mangan la.” Kot wanlan in-obat, “Main tamon bongat limay tinapay tan loway konâ. Kot ola-no labay mon mako kamin manaliw pa-mangan para konlan hiladtin halban tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na-halita la-rin ta hilay lawlalaki bongat a itaw ay main anan manga limanlibo. Wani Jesus konlan dawdisipolos na, “Patokloon moyo hila nin hililimampolo ha balang gropo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kanya yay ginwa lan hilay dawdisipolos ay pinatoklo na hilay naor a halban. ");
INSERT INTO xsb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pa-makayari ay kinwa ni Jesus yay limay tinapay tan loway konâ, ta bi-sa tinomangal ya ha langit ta pinasalamatan na yay Dios. Bi-sa pini-pikna na, ba-yo na inimbi konlan dawdisipolos na para ipapto konlan malabong a tawo. ");
INSERT INTO xsb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Halban la ay nakapangan tan ni-kabhoy. Bi-sa, hin tinipon lan dawdisipolos a ni-katla a pini-pikna nin tinapay ay nakapno hila ot nin labinloway bakol. ");
INSERT INTO xsb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ninghan, asa-sa ni Jesus a dinomawat konan Dios. Hin ya-rin, kalamo na hilay dawdisipolos na. Bi-sa pinastang na hila ni Jesus, wana, “Anyay wanlan tawtawo no hino ko?” ");
INSERT INTO xsb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Obat la kona, “Hika kano hi Juan Bautista. Main anamaot ampanalita a hika kano hi Propita Elias. Wanlay namaot laloma, a-sa ka kano konlan laloman pawpropita nan Dios hin o-na a norong nabyay.” ");
INSERT INTO xsb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bi-sa wani Jesus konla, “Hapa hikamo, hino ko komoyo?” Inombat hi Pedro, wana, “Hika yay Cristo, yay inhogo nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kot binibilinan na hila ni Jesus a ando la iba-balita ha hinoman odtin tongkol kona. ");
INSERT INTO xsb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wana ot ni Jesus konla, “Hiko a Naglalaman Tawo ay kailangan domalan ha lako a dawdya-dya ha gamot lan pawpoon tamon Israelita, pawpoon pari tan mawmaistron kapanogoan. Itakwil tan ipapati la ko, balo ta ha ikatlon awlo ay morong akon mabyay.” ");
INSERT INTO xsb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hawanin, wani Jesus konlan halban, “Hinoman a malabay homonol kongko ay kailangan lingwanan nay sarili na, tanggapon nay kawkadya-dyaan a andomalan ha biyay na alang-alang kongko a kaalimbawaan balatayon nay sarili nan kros ha inawlo-awlo tan kailangan homonol ya kongko. ");
INSERT INTO xsb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nga-min, hinoman a ambo matibolos a nakom mati alang-alang kongko ay kay na matanggap yay biyay a homin anggawan, kot hinoman a mati alang-alang kongko ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nga-min, anyamay pakinabang nin a-say tawo, maipag-ikon na may halban kayamanan ha babon lota no impyirnoy nan lamang a ogotan na? ");
INSERT INTO xsb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hinoman a ampamikaringoy kongko tan ha hawhalita ko, hiko a Naglalaman Tawo ay ikaringoy ko yay namaot ha pa-mako kon oman iti. Konan ya-rin pa-mako kon oman iti ay ma-kit moyoy kalinggasan ko, yay kalinggasan nan Ama ko tan yay kalinggasan lan bawbanal a anghil. ");
INSERT INTO xsb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yay potog, ibalita ko komoyo, main naka-dong iti hawanin a angkabyay ot anggan ha ma-kit lay pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pa-makalabah nin manga waloy awlo paibat hin hinalita nadtaw ni Jesus, impagkalamoan na hi Pedro, hi Juan tan hi Santiago nin nako ha a-say bakil para domawat. ");
INSERT INTO xsb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hin ya-rin a andomawat hi Jesus, nangoman a itsoran lopa na tan yay doloh na ay ampangi-kirlap ha kapotian. ");
INSERT INTO xsb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tongwa, main loway lalaki a naki-totol kona. Hila ay hi Moises tan hi Propita Elias. ");
INSERT INTO xsb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nagpa-kit hila nin main awit a kalinggasan, bi-sa yay pini-totolan la ay tongkol ha pa-ngamati ni Jesus a madani nan mangyari ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kot hi Pedro tan hilay kalamoan na ay nakaka-lok labah hin ya-rin. Hin nakaimata hila, na-kit lay kalinggasan ni Jesus pati hilay loway lalaki a naka-dong ha dani na. ");
INSERT INTO xsb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bi-sa, hin an-omalih hila-rin loway lalaki, wani Pedro koni Jesus, “Maistro, labah ta iti tamo. Mama-dong kamin toloy hihilongan, a-sa para komo, a-sa para koni Moises tan a-sa para koni Propita Elias.” Kot homin ha nakom ni Pedro odtaw hinalita na. ");
INSERT INTO xsb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hin ampanalita ya ot hi Pedro, main nilomwah a-say lolom a nangamoy konla. Nali-mo hilay toloy disipolos ni Jesus hin naamoyan hilan ya-rin lolom. ");
INSERT INTO xsb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tongwa, nalngo lay bosis nan Dios a naibat konan ya-rin lolom, wana, “Yadti a anlabyon kon Anak. Manglongo kamo kona.” ");
INSERT INTO xsb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pa-makayari nan Dios nanalita, na-kit lan disipolos a asa-sa na tana ni Jesus. Insikrito lan toloy disipolos a na-kit la. Kay la yapon imbalita yadti ha hinoman hin ya-rin a panaon. ");
INSERT INTO xsb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kinadilapan, hin nakaaypa hilay na ni Jesus ha bakil, hinakbat hilan golpin tawo. ");
INSERT INTO xsb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tongwa, main a-say lalaki konlan malabong a tawo itaw a nanalita ha makhaw a bosis, wana koni Jesus, “Maistro, pakibiliw mo pay anak kon lalaki ta ka-siya-siya na paot. ");
INSERT INTO xsb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Main doka a ispirito a ampako kona, kanya bigla yan an-omaghaw, tan ampama-paghon anggan mamolâ-bolâ a boboy na. Anhahakiton na ya tan halos kay na ya ibati. ");
INSERT INTO xsb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Impaki-totol koy na konlan dawdisipolos mo a palayahon la ya, kot kay la na-palayah.” ");
INSERT INTO xsb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wanan in-obat ni Jesus, “Hikamoy tawtawo hawanin, homin kamon katotpol tan masyadon matiko a pawpangingisip. Pa-no ot kari kaboyot a kailangan kon maki-lamo komoyo bi-sa kamo tompol? Pa-no ot kari kaboyot a kailangan katamon pagpasinsyawan?” Bi-sa wana konan tatay nan anak, “Awiton moy anak mo iti.” ");
INSERT INTO xsb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hin andomani yay anak, intomba na yan doka a ispirito ta bi-sa pina-paghon. Pinanalitaan ni Jesus yay doka a ispirito nin omalih konan anak, kanya inomabig yay anak, bi-sa inimbi na ya konan tatay na. ");
INSERT INTO xsb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Halban lan tawtawo ay naka-ngap ha ambo basta-bastan kapangyarian nan Dios. Hin ya-rin a ampag-ispanta hilay tawtawo ha halban gi-ginwa ni Jesus, wana konlan dawdisipolos na, ");
INSERT INTO xsb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Paka-long-on moyon labah odtin halitaon ko: Hiko a Naglalaman Tawo ay iintriga ha tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kot kay la naintindyan nin dawdisipolos na a labay nan totolon ha imbalita na. Nga-min, nakaari ot konla yay kanaboan nin yadti pigaw kay la maintindyan. Angkali-mo hilay namaot mamastang koni Jesus no anyay labay nan totolon ha hinalita na. ");
INSERT INTO xsb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hawanin, na-pididiskosyon hilay dawdisipolos ni Jesus no hino konlay pinakamata-gay. ");
INSERT INTO xsb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Palibhasay tanda ni Jesus a lawlaman nin kaisipan la, nangwa yan a-say anak ta pinaodong na ha dani na. ");
INSERT INTO xsb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bi-sa wana konlan dawdisipolos na, “Hinoman a ampananggap alimbawa konan yadtin anak alang-alang kongko ay bilang hikoy antanggapon na. Tan hinoman a ampananggap kongko ay bilang ot bongat yay nanogo kongko a antanggapon na. Nga-min, hinoman komoyo a pinakamaaypa a nakom ay hiyay an-itoring kon pinakamata-gay.” ");
INSERT INTO xsb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hawanin, wani Juan koni Jesus, “Maistro, naka-kit kamin a-say lalakin ampangamit nin ngalan mo para mamalayah dawdoka a ispirito a nilomoob ha tawo. Kot binawalan mi ya bana ta ambo mi yan kalamoan nin anhomonol komo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kot wani Jesus kona, “Ando moyo ya bawalan, ta yay tawon ambo kontra kontamo ay kakampi tamo.” ");
INSERT INTO xsb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hin madani nay panaon nin pa-moli ni Jesus ha langit, inasa-sa nay nakom nan mako ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kanya nanogo yan omnoy tawon mo-na kona ha a-say babali nin probinsyan Samaria para maningkap nin ma-handaan na. ");
INSERT INTO xsb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kot kay la ya labay pahandaon nin tawtawo konan ya-rin a babali, palibhasay tanda la a mako ya ha Jerusalem a logar lan ampangmata-mata konla. ");
INSERT INTO xsb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hin na-tandaan ladti nin hilay apostolis nan hi Santiago tan hi Juan, wanla, “Katawan, labay mo doman a mamataoy kamin apoy ibat ha langit a bilang ha ginwa ni Propita Elias* pigaw maopoh hila?” ");
INSERT INTO xsb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kot inomarap hi Jesus konla ta sinita na hila, wana, “Kay moyo doman tanda no anyay nay ispirito a ampango-na komoyo? ");
INSERT INTO xsb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hiko a Naglalaman Tawo ay kay ko nako iti para patyon a tawtawo, nokay para ilipyas hila.”* Kanya nagpa-wan hila tana ha laloman babali. ");
INSERT INTO xsb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hin ya-rin a iti hilay na ha dalan, main a-say lalakin nanalita koni Jesus, wana, “Maistro, homonol ako komo maskin ayti ka mako.” ");
INSERT INTO xsb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kot wani Jesus kona, “Isipon mo yapon: Hilay ason talon ay main hilan yokib tan hilay manok-manok ay main hilan an-aponan; kot hiko a Naglalaman Tawo ay homin sarilin balin ma-pagpainawawan.” ");
INSERT INTO xsb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bi-sa wani Jesus konan a-sa ot a lalaki itaw, “Homonol ka kongko.” Kot wanan in-obat nin ya-rin a lalaki, “Katawan, morong ako yapo itaw komi anggan makihiyay hi tatay ko ta pigaw maitabon ko ya.” ");
INSERT INTO xsb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kot wani Jesus kona, “Hilay kay anhomonol kongko ay pa-hal nati, kanya kaolay hilay nan mamitabon ha kapara lan nati. Balo ta hika, mako ka ta ipangaral mo yay tongkol ha pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hawanin, wanay namaot nin a-say lalaki itaw, “Katawan, homonol ako komo, balo ta payagan mo ko nin patawo yapo itaw komi.” ");
INSERT INTO xsb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Wani Jesus kona, “Ando mo aligon a a-say ma-ngararo a palingay anan palingay, ta yay anorin a klasin tawo ay ambo karapat-dapat pahakop ha pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pa-makayari nin yadtin pawpangyayari, namili yay Katawan nin pitompolo tan lowa ot a lawlalaki para pao-nawon na hilan mako nin lowa-lowa ha balang babali tan logar a kakaon na. ");
INSERT INTO xsb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wana konla hin ya-rin, “Kalakan lan tawtawo a kailangan ma-pahawangan para tompol ha Dios. Kaalimbawaan la ay golpin gagapason kot hilay ma-ngapas ay da-raoto. Kanya dawaton moyo konan Dios a Katawan a main ikon konlan hila-rin a pa-hal gagapason, a mamihogo yan tawtawo para pa-hal mangapas konla. ");
INSERT INTO xsb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mako kamoy na, kot tandaan moyo a an-ihogo katamo bilang kawkilaw karniro a maka-paki-lamo ha mangaramsak a ayop. ");
INSERT INTO xsb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ando kamo mangawit kwartamonida, bag, ni apin ayin panghagili. Tan ando ana mag-abala nin kiaasikaso ha dalan. ");
INSERT INTO xsb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ha aytiman magbali a pakihandaan moyo, halitaon moyo yapo, ‘Hikamo iti ha bali, magkamain kamo komon kaliswayan nakom.’ ");
INSERT INTO xsb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No main konla a labay nay kaliswayan nakom, mangyari a dawat moyo. Kot no homin konla a an-omapos nin magkamain kaliswayan nakom, kay mangyari a dawat moyo. ");
INSERT INTO xsb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Magpirmi kamo ha balin handaan moyo, bi-sa anyamay idolog la komoyo ay dapat moyon bongat kanon tan inomon ta yay ma-magtrabaho ay marapat mananggap nin opa. Ando kamoy na mi-lipat-lipat nin bali. ");
INSERT INTO xsb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ha aytiman magbabali a kaon moyo ta main malabay tomanggap komoyo, no anyay idolog la ay yadtaw a kanon moyo. ");
INSERT INTO xsb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Paabigon moyo hilay main masakit konan ya-rin a logar, tan ibalita moyo konla, ‘Madani nay nan ipa-kit Dios a pa-mag-ari na.’ ");
INSERT INTO xsb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kot no main babalin kaon moyo ta kay la kamo tanggapon ha bawbali, mako kamo ha kawkalsada ta halitaon moyoy anodti, ");
INSERT INTO xsb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Oltimon gabok nin babali moyo a dinomalit ha ayi mi ay ipagpag mi. Kot tandaan moyo a madani nay nan ipa-kit Dios a pa-mag-ari na,’ wamoyo.” ");
INSERT INTO xsb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hawanin, wana ot ni Jesus konla, “Ibalita ko komoyo, ha awlon pangongokom ay mas mabyat a parosa nan Dios konlan tawtawo ha anorin a klasin babali dinan konlan taga Sodoma a bantog ha main lan karokaan hin yadtaw.” ");
INSERT INTO xsb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wana ot ni Jesus, “Hikamoy taga Corazin tan hikamoy taga Betsaida, ka-ka-roy ogotan moyo! No yay mawmilagro a ginwa ko ha babali moyo kot itaw ko ginwa ha Tiro tan Sidon a kamainan nin tawtawon homin tanda tongkol ha Dios ay naboyot hilay na komon nagholot nin sako bi-sa tinomoklo ha abo pamilbian nin pa-ngombabali la ha main lan kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ha awlon pangongokom, mas mabyat a parosa nan Dios komoyo dinan konlan taga Tiro tan taga Sidon. ");
INSERT INTO xsb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hikamoy namaot taga Capernaum, Yay labay moyo lawo ay ita-gay kamo anggan ha langit. Kot ibagsak kamo ha impyirno!” ");
INSERT INTO xsb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Hin ya-rin, wani Jesus konlan dawdisipolos na, “Hinoman a ampanglongo komoyo ay bilang ot bongat hikoy anlong-on na. Kot hinoman a kay ampananggap komoyo ay bilang ot bongat hikoy kay na antanggapon. Tan hinoman a kay ampananggap kongko ay bilang syimpri yay nanogo kongko a kay na antanggapon.” ");
INSERT INTO xsb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ha maparah a olit, maliga hilan nagbolta koni Jesus hilay pitompolo tan loway disipolos a inhogo na. Wanla kona hin ya-rin, “Katawan, maski dawdoka a ispirito ay angka-pahoko mi ha paralan nin pa-nambit min ngalan mo.” ");
INSERT INTO xsb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wani Jesus konla, “Na-kit ko a nadabo hi Satanas ibat ha langit nin bilang kaparah kirlap kimat. ");
INSERT INTO xsb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tandaan moyo a binyan katamon kapangyarian pigaw madaog moyo yay halban kahakopan nin kalaban moyo a hi Satanas. Maski man ma-do-raan moyoy aw-olay o lawliyopan ay kay kamo maano tan homin maari manakit komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Anodtaw pa man, pakaliga kamo, ambo bana ta angka-pahoko moyo hilay dawdoka a ispirito, nokay pakaliga kamo bana ta yay ngawngalan moyo ay nakalista itaw ha langit.” ");
INSERT INTO xsb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hin ya-rin a oras, ha pangongo-na nin Masanton Ispirito nan Dios ay maligan-maliga hi Jesus, wana konan Dios, “Ampaki-salamat ako komo, Ama a Katawan nin langit tan lota ta yay kanaboan nin an-ipangaral ko ay insikrito mo pigaw kay la maintindyan nin hilay mawmaronong tan hilay mawmatalino, balo ta impaintindyan mo konlan ma-ngaaypa a nakom a bilang ha mangakalog a awa-nak. Ginwa mo-rin, Ama ta ya-rin a kalabayan mo bana ha main mon kaabigan.” ");
INSERT INTO xsb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Hawanin, wani Jesus konlan tawtawo, “Halban bawbagay ay impa-taya na kongko nin Ama ko. Homin ampaka-bilbi hosto no hino ko no ambo yay Ama. Anorin anamaot kapara, homin ampaka-bilbi hosto no hino yay Ama no ambo hiko a Anak na tan hilay labay kon pamipabilbian.” ");
INSERT INTO xsb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bi-sa inomarap hi Jesus konlan dawdisipolos na, ta wana konla nin kay la nalngo nin laloman tawo, “Makalma kamo ta angka-kit moyoy bawbagay a angka-kit moyo hawanin. ");
INSERT INTO xsb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nga-min, ibalita ko komoyo, lako a pawpropita nan Dios tan aw-ari hin yadtaw a ngali-ngalin manganon maka-kit tan makapanglongo nin bilang ha angka-ka-kit tan angka-kalngo moyo hawanin kongko, kot kay nangyari yadti hin panaon la.” ");
INSERT INTO xsb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ninghan, main a-say maistron kapanogoan a dinomani koni Jesus ta labay na yan hobokon no anggan ayti a karonongan na. Kanya pinastang na ya, wana, “Maistro, anyay kailangan kon gaw-on pigaw magkamain akon biyay a homin anggawan?” ");
INSERT INTO xsb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wanan in-obat ni Jesus, “Anyay nabasa mo ha kawkapanogoan nan Dios a sinolat ni Moises?” ");
INSERT INTO xsb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wanan in-obat nin yadtin maistron kapanogoan, “Labyon mo yay Katawan mon Dios nin asa-say nakom, nin halban kababaan mo, mo-na ha main mon kalayaman, tan mo-na ot ha main mon pangingisip. Tan: Labyon moy kapara nin bilang ha pa-manglabi mo ha sarili.” ");
INSERT INTO xsb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wani Jesus kona, “Tama a obat mo. Anorin a gaw-on mo ta magkamain kan biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kot yadtin maistron kapanogoan, palibhasay kay na labay lomwah yan kapa-paringoy ay pinastang nan oman hi Jesus, wana, “Hino man wari a kapara ko?” ");
INSERT INTO xsb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wanan in-obat ni Jesus a imparalan ha alimbawa, “Main a-say lalakin kaparan Israelita a nako ha babalin Jerico ibat ha syodad Jerusalem. Hin iti ya ha dalan ay hinarang la yan tawtolisan. Kinwa lay ayhing na, bino-bogbog, bi-sa imbati la yan halos mati na. ");
INSERT INTO xsb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nitag-on main a-say pari a kaparan Israelita a nagpa-wan anamaot konan ya-rin a dalan. Pa-maka-kit na konan lalakin bino-bogbog, pina-lilihan na yan bongat. ");
INSERT INTO xsb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Main anamaot nagpa-wan itaw a a-say Levita a katambay lan pari. Na-kit nay namaot yay lalakin bino-bogbog, kot pina-lilihan na syimpri. ");
INSERT INTO xsb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hawanin, main a-say lalakin taga Samaria a ambo nan kaparan Israelita a nagpa-wan anamaot konan ya-rin a dalan. Hin na-kit na yay lalakin bino-bogbog ay nainga-rowan na ya. ");
INSERT INTO xsb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dinaniwan na ya ta tinambal nay hawhogat na nin alak obas tan lalok bi-sa na tinakol. Pa-makayari ay inlolan na ya ha nilolanan nan ayop ta inawit ha a-say balin ampaghandaan ta itaw na ya inalagaan. ");
INSERT INTO xsb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kinadilapan ba-yo ya nibwat, nami yan loway kwartan pilak konan yay ma-ngasiwa nin bali, bi-sa wana, ‘Alagaan mo ya padtin lalaki. No wari ta somobray gastos mo para kona, bayaran ko-rin ha pa-magbolta ko.’” ");
INSERT INTO xsb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hawanin, pinastang ni Jesus yay maistron kapanogoan, wana, “Ha intindi mo, hino konlan tolo a binomilbi konan lalakin bino-bogbog bilang kapara nan tawo?” ");
INSERT INTO xsb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wanan in-obat nin yadtin maistron kapanogoan, “Yadtaw nama-kit inganga-ro kona.” Wani Jesus, “Mako kay na no-nin ta anorin anamaot a gaw-on mo.” ");
INSERT INTO xsb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ha patoloy nan kala-lalako ni Jesus tan hilay dawdisipolos na ay niabot hila ha a-say baryo. Main itaw a-say babayi a yay ngalan na ay Marta a nangimbita konli Jesus ha bali la. ");
INSERT INTO xsb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yadtin hi Marta ay main yan talakaka a yay ngalan na ay Maria. Hin itaw hilay na ni Jesus ha bali la, hi Maria ay tinomoklo ha danin ayi ni Jesus ta nanglongo yan totoro na. ");
INSERT INTO xsb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kot hi Marta ay golo-goloy isip na ha kalakan gawgawa nan pa-maghanda, kanya nako ya koni Jesus, ta wana, “Katawan, kay mo wari angka-sikaso a ampo-layan na kon talakaka kon magsirbi nin asa-sa ko? Hapa no ipakibalita mo kona a tambayan na ko pay namaot.” ");
INSERT INTO xsb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kot wani Jesus nin in-obat kona, “Marta, masyado ka nga-min ampangisip tan angkaaborido ha kalakan bawbagay. ");
INSERT INTO xsb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A-say bagay bongat a kailangan. Pinili ni Maria yadtin bagay a labah, kanya ambo yan dapat haaron.” ");
INSERT INTO xsb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ninghan, nako hi Jesus ha a-say logar ta dinomawat ya konan Dios. Pa-makayari, dinomani konay a-sa konlan dawdisipolos na, ta wana, “Katawan, toroan mo kami pan domawat ha Dios a bilang ha ginwa ni Juan Bautista konlan dawdisipolos na.” ");
INSERT INTO xsb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wani Jesus konla, “No domawat kamo ha Dios, anodti a halitaon moyo, ‘Ama mi a ison ha langit,* sambawon a ngalan mo. Ma-kit mi na komon a pa-mag-ari mo. Ma-honol komon a kalabayan mo iti ha lota A bilang anamaot ison ha langit.* ");
INSERT INTO xsb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Biyan mo kami komon nin pa-mangan mi ha inawlo-awlo. ");
INSERT INTO xsb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tan patawaron mo kami komon ha kawkasalanan mi Ta ampatawaron mi namaot a balang ampagkasalanan komi. Tan komon ando mo aboloyan a matokso kami, Nokay masbali ipa-lilih mo kamin kay makagawa doka.’”* ");
INSERT INTO xsb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bi-sa wana ot ni Jesus konla, “Alimbawa, ta main a-sa komoyo a mako ha bali nin a-say amigo na nin kapikna yabi, ta ibalita na, ‘Amigo, pa-raman mo ko pan toloy tinapay, ");
INSERT INTO xsb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta main akon amigo a nakalato ibat ha pa-magbyahi bi-sa homin akon maipapangan kona.’ ");
INSERT INTO xsb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Maari a halitaon nan amigo na ha loob bali, ‘Ando mo ko istorbowon ta saradoy nay polta. Ampira kami na nin awa-nak ko. Kay koy na maari mibangon para biyan kan kailangan mo,’ wana wari. ");
INSERT INTO xsb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ibalita ko komoyo,” wani Jesus, “maski man wari kay na ya labay biyan anggano man miamigo hila, kot no mapilit ya ay mibangon syimpri a amigo na ta biyan na yan kailangan na. ");
INSERT INTO xsb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kanya ibalita ko komoyo: Makirawat kamo konan Dios ta biyan na kamo; maningkap kamo ta maka-romog kamo; komatok kamo ta abriyan komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nga-min, yay tawon ampakirawat ha Dios ay ma-biyan, yay ampaningkap ay maka-romog, tan yay angkomatok, konay abriyan. ");
INSERT INTO xsb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Alimbawa, hikamoy tawtatay, biyan moyo wari bato a anak moyo no ampakirawat yan tinapay? O biyan moyo ya wari olay no ampakirawat yan konâ? ");
INSERT INTO xsb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O biyan moyo ya wari liyopan no ampakirawat yan oybon? ");
INSERT INTO xsb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No hikamoy tawtawo a main doka a ogali kot tanda moyon mami konlan awa-nak moyo nin lawlabah a bagay, balo-balo pay na konan Ama ha langit. Ibi ta ibi nay namaot a Masanton Ispirito na konlan hilay ampakirawat kona.” ");
INSERT INTO xsb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ninghan, ampamalayah hi Jesus nin doka a ispirito ha a-say lalaki a pinangibatan nag-in omol odtin lalaki. Hin na-palayah anay doka a ispirito, nakahalita yay nay lalaki. Naka-ngap hilay tawtawo hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kot main omno konla a nanalita, wanla, “Kanya ya ampaka-palayah dawdoka a ispirito, bana ta binyan na yan kapangyarian ni Satanas a poon lan dawdoka a ispirito.” ");
INSERT INTO xsb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hilay namaot a laloma ay labay lan hobokon hi Jesus, kanya imbalita la kona a pa-kitan na hilan milagron ibat ha langit a pamilbian a inhogo na yan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kot tanda ni Jesus a laman isip la, kanya wana konla, “Mahira a balang kaarian, no hila-hila ot a ampikokontra tan bomagsak syimpri a balang mipa-pamilya, no hila-hila ot a ampikokontra. ");
INSERT INTO xsb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anorin a kaalimbawaan ni Satanas ta no wari ta hila-hila ot a ampikokontra, pa-no man makapagpatoloy a kaarian na? Nga-min, wamoyo, angka-palayah koy dawdoka a ispirito ha kapangyarian a ibat koni Satanas. ");
INSERT INTO xsb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A-sa ot a rason: Wamoyo, hi Satanas a nami kongko nin kapangyarian para mamalayah dawdoka a ispirito. Hapay namaot hilay kawkalamoan moyo a ampamalayah anamaot dawdoka a ispirito, hino man no-nin a nami konla nin kapangyarian? Ambo doman yay Dios? Hila-rin mismo a kalamoan moyo a maari mamaptog a lawlingo kamo! ");
INSERT INTO xsb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Hawanin, bana ta yay Dios a nami kongko nin kapangyarian para mamalayah dawdoka a ispirito, labay totolon, yay pa-mag-ari nan Dios ay nilomato ana komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Hi Satanas ay bilang a-say tawon makhaw a nakaarmas a ampagwardya ha palasyo na, pigaw kay maano a kawkama-main na. ");
INSERT INTO xsb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kot no main a-say mas makhaw ot kona ay malosob tan matalo na ya. Kowon nay aw-armas a ampasimalaan na, bi-sa ipa-papto nay na-hamham nan kawkama-main na. Kanya mapatnag a tinalo koy na hi Satanas ta angka-palayah koy dawdoka a ispirito a kampon na.” ");
INSERT INTO xsb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Hawanin, wanan impatandaan ni Jesus, “Yay tawon kay angkomampi kongko ay kontra kongko. Anorin anamaot kapara, yay tawon kay ampakitambay kongko nin manipon tawtawo para tompol kongko ay bilang ot bongat an-ipaka-dayo na hila kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bi-sa tinoroan na hilay naman ni Jesus, wana, “Alimbawa, no main a-say doka a ispirito a inomalih ha tawon nilooban, tomala ya ha lawak a homin kalanom-lanom ta mamiliw nin laloman maiwanan. Kot no homin yan ma-kit, halitaon na ha sarili na, ‘Magbolta ko tana ha inibatan ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","No ha pa-magbolta na kot ma-kit na a yay dati nan nilooban ay bilang ha a-say balin malinis tan maayos nin homin ampi-wan, ");
INSERT INTO xsb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yay gaw-on na ay mako yan mangwa nin pitoy ispirito a mas doka ot kona. Bi-sa lomoob hila tan magpirmi konan ya-rin a tawo. Kanya yay mag-in pa-hal nan ya-rin a tawo ay mas grabi na ingat dinan hin o-na.” ");
INSERT INTO xsb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hin ya-rin a ampanalita hi Jesus, main a-say babayi itaw ha kalabongan a nanalita nin makhaw a bosis, wana, “Makalma yay nanay mo a namiabing tan namasoso komo.” ");
INSERT INTO xsb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kot wani Jesus, “Mas makalma hilay tawtawon ampanglongo tan anhomonol ha Halita nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hin angka-pa-lahan anan angka-pa-lahan a malabong a tawo a ampanglongo koni Jesus, nagpatoloy yan nangaral. Wana, “Hikamoy tawtawo hawanin, masyadoy nan karokaan. Ampaningkapan moyo ko ot nin milagro a pamilbian a naibat ako ha langit. Kot homin anan laloman pamilbian a ipa-kit komoyo no ambo yadtaw tanay kaparihon nangyari koni Propita Jonas hin yadtaw. ");
INSERT INTO xsb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Toloy awlo tan toloy yabi na ha lalo tiyan nin balyina a nag-in pamilbian konlan taga Ninive hin yadtaw a inhogo na yan Dios. Anorin anamaot kapara, yay mangyari kongko a Naglalaman Tawo ay pamilbian anamaot komoyon tawtawo hawanin a inhogo na kon Dios. ");
INSERT INTO xsb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ha awlon pangongokom, yadtaw Rayna nin ‘Bagatan’ a ambo tamon kaparan Israelita ay omdong ta ibalita na a nagkasalanan kamo. Nga-min, halos kalindoyo-doyowan ana nin mondo a inibatan na, kot nako ya syimpri koni Ari Solomon hin yadtaw para manglongo ha karonongan na. Kot hiko a mas holok koni Ari Solomon ay kay moyo ko anlong-on. ");
INSERT INTO xsb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hila man a taga Ninive ay omdong anamaot ha awlon pangongokom ta ibalita lay namaot a hikamoy tawtawo hawanin ay nagkasalanan. Nga-min, hin nangaral hi Propita Jonas konla hin yadtaw ay ni-pangombabali hila. Kot hiko a mas holok koni Propita Jonas ay kay moyo ko anlong-on.” ");
INSERT INTO xsb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wana ot ni Jesus, “Homin tawon mamarta nin lamparilya ta bi-sa na iari, o kari hakban na wari nin halop, nokay igwa na syimpri ha dapat pamigwaan pigaw hinoman a lomoob ha bali ay ma-kit nay hawang. ");
INSERT INTO xsb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yay mata ay pa-hal ampakapamin hawang ha pa-magkatawo. No labah a hilap nin tawo, mahawang a intiron pa-magkatawo na. Kot no doka a hilap na, maroblom anamaot a intiron pa-magkatawo na. ");
INSERT INTO xsb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yay labay kon totolon, mag-ingat ka pigaw yay paninilap mo ay homin awit doka a isip. ");
INSERT INTO xsb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hawanin, no yay pa-magkatawo mo kot labah ta homin anan awit doka a isip, talagan labah kay nan tawo. No anorin, mag-in kan pa-hal na-pakahawang nin bilang angka-hawangan hosto nin lamparilya.” ");
INSERT INTO xsb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kapiyari nan nanalita ni Jesus, main a-say Pariseo a nangimbita kona para mangan itaw konla. Naki-ka hi Jesus, bi-sa nakirongo yan nangan. ");
INSERT INTO xsb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yadtin Pariseo ay naka-ngap ta na-sikaso na a kay na hinonol ni Jesus a sirimonyan pa-mibano ba-yo mangan anta kasalanan ya-rin ayon ha totoro lan aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kot wani Jesus kona, “Hikamoy paw-Pariseo, ha kaaapos moyon ma-honol a sirimonyan pa-manglinis, halako moyon ampaka-linison mo-na mo-na a likol nin tawtasa tan pawplato moyo anta panlikol bongat orin, kot yay lalo kanakoman moyo ay pono-pono kaagoman tan karokaan. ");
INSERT INTO xsb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kay kamo ampakaintindi! Ambo doman yay Dios a namalsa nin bawbagay a panlikol ay hiya ot syimpri a namalsa nin bawbagay a panloob? ");
INSERT INTO xsb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kanya mami kamon kama-main moyo konlan mawmairap pigaw mag-in malinis a kanakoman moyo, ta bi-sa halban anan bawbagay ay mag-in anamaot malinis para komoyo ha hilap nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ka-ka-roy ogotan moyo, hikamoy paw-Pariseo! Ampami kamo konan Dios nin ikamapolo a parti nin angkaalawah moyo maskin ha pinakamakating a kawklasin bongan pangrikado tan balang pawpihing, balo ta ampo-po-layan moyo yay gawgawa katoynongan tan yay pa-manglabi ha Dios. Hiladti a dapat moyon asikasowon nin ando anamaot lingwanan a lawlaloma. ");
INSERT INTO xsb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ka-ka-roy ogotan moyo, hikamoy paw-Pariseo! Nga-min, mangailig kamon tomoklo ha ambo basta-bastan totokloan ha sawsinagoga tan labay-labay moyon asikasowon kamo ha pawplasa. ");
INSERT INTO xsb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ka-ka-roy ogotan moyo, hikamoy mawmaistron kapanogoan tan paw-Pariseo a ampiabig-abig! Bilang kamon pawpinanabonan a homin pamilbian, kanya angka-dalan-dalanan lan tawtawo nin kay la angka-tandaan a nag-in hilay nan mayangat ayon ha kawkapanogoan. Anorin a kaalimbawaan moyo ta main kamon an-isi-sikriton karokaan, kanya hilay ambomilbi komoyo ay angkaolamitan anamaot ha karokaan moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hin ya-rin ay main a-say ikspirto ha kawkapanogoan a nanalita koni Jesus, wana, “Maistro, konan ya-rin hawhinalita mo, pati hikami ay angka-pintasan anamaot.” ");
INSERT INTO xsb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wanan in-obat ni Jesus, “Iya, hikamo man a mawmaistron kapanogoan ay ka-ka-roy namaot a ogotan moyo! Nga-min, lako a kawkapanogoan a an-ipahonol moyo ha tawtawo a bilang nin ampabalatayon moyo hilan mangabyat a kawkarga a halos kay la mabalatay, anta ni a-say galawagaw moyo ay kay moyo tana anggamiton para ipanambay konla pigaw makahonol hila ha an-itoro moyo. ");
INSERT INTO xsb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ka-ka-roy ogotan moyo! An-ipangwâ moyon pawpantyon hilay pawpropita nan Dios a pinati lan kapapo-papoan moyo. ");
INSERT INTO xsb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kot ha anorin a paralan, hikamoy na mismo a ampamaptog a payag kamo ha gi-ginwa lan kapapo-papoan moyo ta hilay naor a namapati konlan pawpropita, bi-sa hikamoy namaot a ampangwâ nin pawpantyon la. ");
INSERT INTO xsb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kanya ha karonongan nan Dios ay wanan impatandaan, ‘Mamihogo ako konla nin pawpropita a mangangaral tan aw-apostolis. Kot main konlan hila-rin a patyon la tan hilay laloma ay da-damsakon la.’ ");
INSERT INTO xsb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kanya hikamoy tawtawo hawanin ay obaton moyoy namaot konan Dios yay biyay lan halban pawpropita na a pinati paibat hin pinalsay babon lota, ");
INSERT INTO xsb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","paibat koni Abel anggan koni Zacarias a pinati ha pibotlayan nin altar tan timplo. Iya, ibalita ko komoyo, hikamoy mangobat nin yadtin halban. ");
INSERT INTO xsb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ka-ka-roy ogotan moyon hikamoy aw-ikspirto ha kawkapanogoan! Nga-min, ha klasin an-itoro moyo tongkol ha Halita nan Dios ay bilang moyoy na ingat an-iari ha tawtawo yay sosi para maabriyan komon a pangingintindi la tongkol kona. Hikamo mismo ay kay nagpahakop kona ta bi-sa ampondan moyo ot hilay malabay pahakop.” ");
INSERT INTO xsb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hin imbalita ni Jesus yadti, masyadon mahobhob kona hilay mawmaistron kapanogoan tan paw-Pariseo. Kanya pina-pastang la ya ta labay la yan piliton manalita nin lako a bawbagay, ");
INSERT INTO xsb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tan amba-bantayan la ya ta hapa no ma-taktika la yan makahalita nin lingo pigaw main hilan maibara laban kona. ");
INSERT INTO xsb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hin ya-rin ay libo-liboy tawon nanga-pititipon ha kamainan ni Jesus, anggan ampanga-pidodo-raan hilay nan ayi. Hawanin, wana yapon ni Jesus konlan dawdisipolos na a imparalan ha alimbawa, “Pag-atapan moyon kay maolamitan ogali ma-magkonwari nin hilay paw-Pariseo a maiparis ha pampalbag a angkomalat. ");
INSERT INTO xsb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nga-min, homin nakaari a kay ma-tandaan tan homin sikrito a kay mibolgar. ");
INSERT INTO xsb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kanya alimbawa, anyaman a pini-totolan moyo ha maroblom ay ma-tandaan ha mahawang, labay totolon, anyaman a in-anah moyo ha lalo kwarto nin hikamo-hikamon bongat ay iaghaw pigaw malngo lan tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Wana ot ni Jesus konla, “Ibalita ko komoyo, aw-amigo, ando kamo mali-mo konlan malabay mangmati komoyo ta lalaman moyon bongat a ma-pati la. Pa-makayari ay kay homin hilay nan magawa. ");
INSERT INTO xsb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","An-ipao-na koy na komoyo no hinoy dapat moyon kali-mowan: Homin laloma no ambo yay Dios, bana ta hiya yay main kapangyarian ambo bongat mamalawi biyay nokay mamibantak ot ha impyirno. An-oliton ko, hiyay dapat moyon kali-mowan.” ");
INSERT INTO xsb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Wana ot ni Jesus hin ya-rin, “Ambo doman angkailako a limay layno ha loway sintimos bongat? Anodtaw pa man, homin ni a-sa konla a angka-liwawan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Balo-balo pay na komoyo, oltimon habot moyo ay tanda nay bilang. Kanya ando kamo mali-mo ha anyamay mangyari komoyo, bana ta mas maalaga kamo ot ha lako a layno.” ");
INSERT INTO xsb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Wana ot ni Jesus, “Ibalita ko komoyo, hinoman a ampamibalita ha kapara na a hiko kot Katawan na, hiko a Naglalaman Tawo ay bilbion ko yay namaot ha arapan lan aw-anghil nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Balo ta yay tawon ampamibalita ha kapara na a ambo na kon Katawan ay ibalita koy namaot ha arapan lan aw-anghil nan Dios a ambo na kon Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Hinoman a ampanalita nin kontra kongko a Naglalaman Tawo ay ma-patawad na ya ot Dios. Kot yay tawon ampanalita nin doka kontra ha Masanton Ispirito nan Dios ay kay na patawaron Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wana ot ni Jesus, “Ha panaon a ayton la kamo ha sawsinagoga o konlan gawgobirnador o hilay laloma ot a main kapangyarian para imbistigawon bana ha katotpol moyo kongko, ando kamo mag-aborido no pa-no moyo hila obaton o anyay halitaon moyo. ");
INSERT INTO xsb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bana ta konan ya-rin a oras, yay Masanton Ispirito nan Dios a mamitoro komoyo no anyay dapat moyon halitaon.” ");
INSERT INTO xsb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hawanin, main nin a-say lalaki konlan malabong a tawo itaw a naki-totol koni Jesus, wana, “Maistro, ka-totolon mo pay talakaka ko a ibi nay na yay parti ko ha tinawil mi ha matoantawo mi.” ");
INSERT INTO xsb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kot wani Jesus kona, “Kay inimbi kongkoy katongkolan bilang howis moyo para mamarti nin tawil moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bi-sa wani Jesus konlan halban anan tawtawo itaw, “Mag-ingat kamo tan pa-lilihan moyoy kaagoman, bana ta yay kaalagawan nin biyay ay kay angkahokat ha kalakan kama-main.” ");
INSERT INTO xsb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bi-sa nanotol hi Jesus nin a-say alimbawa, wana konla, “Main a-say mayaman a naka-lapot nin golpi ha main nan palbwatan. ");
INSERT INTO xsb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kanya wana ha sarili na, ‘Anya kari a gaw-on ko ta homin akoy nan ma-pamilimpohan nin laloman naalawah ko?’ ");
INSERT INTO xsb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hawanin, naisip na, ‘A, iya, yobaon koy kawkamalig ko ta mama-dong akon mas mangahi-ban para pamilimpohan kon halban naalawah ko tan laloma ot a kawkama-main.’ ");
INSERT INTO xsb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pa-makayari, mahalita koy na ha sarili ko, ‘Labah! Lako akoy nan natipon a kawkama-main. Harag koy nadti para ha maboyot a panaon. Painawa ko tana, minom, mangan tan mi-liga-liga.’ ");
INSERT INTO xsb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Kot wanan Dios kona, ‘Homin kan intindi! Painsan ha yabi ay balawion koy nay biyay mo. Bi-sa ayti man ana mi-ka orin inli-limpoh mo para ha main mon sarili?’” ");
INSERT INTO xsb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pa-makayari nan tinotol ni Jesus yadti, wana, “Anorin a kapa-halan nin tawon ampanipon nin kayamanan para ha sarili na, balo ta ambo yan mayaman ha bawbagay a maalaga konan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hawanin, wani Jesus konlan dawdisipolos na, “Kanya ibalita ko komoyo, ando moyo pag-aboridowan yay tongkol ha pa-mangan a kailangan moyo para mabyay tan yay tongkol ha doloh para ha lalaman moyo. Nga-min, mas maalaga yay biyay moyo dinan ha pa-mangan, ");
INSERT INTO xsb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","tan yay lalaman moyo ay mas maalaga dinan ha doloh. ");
INSERT INTO xsb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Imatonan moyo hilay aw-owak: Kay hila ampamihabwag bini ni ampanglapot. Homin hilan kamalig o anyakaman ot a pamilimpohan pa-mangan la. Anodtaw pa man, ambiyan na hilan Dios nin pa-mangan. Balo-balo pay na komoyo, mas maalaga kamo kona dinan hilay mawmanok-manok! ");
INSERT INTO xsb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mag-aborido kamo man, kay moyoy nan lamang ma-paanloh a biyay moyo maskin a-say oras bongat, ambo doman? ");
INSERT INTO xsb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No yadtin bagay a makalog bongat kot kay moyoy nan lamang mababa gaw-on, anongkot ampag-aboridowan moyo ot a lawlaloman bagay? ");
INSERT INTO xsb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Imatonan moyoy kato-tobo nin dawdikot a ampi-pamolak. Kay hila ampagtrabaho ni anggomwa nin impagka-doloh la. Kot ibalita ko komoyo, maskin hi Ari Solomon a pinakamayaman hin yadtaw ay kay nakapagdoloh nin anorin kaganda ha bawbolak. ");
INSERT INTO xsb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yay dawdikot a angka-kit tamo hawanin a angkabyay ha lawak, maari dilap ay malanoh ana tan poolan lan tawtawo. No hila-rin a dawdikot a main pa-ngalanoh kot ampabolakon nan Dios ta ya-rin a impagka-doloh la, di lalo kamoy na, padolohan ta padolohan na kamo! Hay kakapoyan pay nan katotpol moyo! ");
INSERT INTO xsb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanya ando kamo kaawat mangisip ha paniningkap pa-mangan tan mainom tan ando kamon dapat ma-mag-aborido. ");
INSERT INTO xsb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anorin a bawbagay a ampakaisipon nin tawtawo ha halban nawnasyon a kay magbilbi konan Dios. Kot ando moyo hila aligon, bana ta tanda nan Ama moyo ha langit a kailangan moyo-rin. ");
INSERT INTO xsb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Masbali pag-inakitan moyon somolong yay pa-mag-ari nan Dios ta bi-sa yay pawpangangailangan moyo ay ibi na komoyo.” ");
INSERT INTO xsb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Wana ot ni Jesus konlan dawdisipolos na, “Anggano man da-raoto kamoy anhomonol kongko, ando kamo mali-mo ta kaligawan nan Ama moyo ha langit a ipa-taya na komoyoy ampag-arian na. ");
INSERT INTO xsb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilako moyoy kama-main moyo ta mami kamo konlan mawmairap. No anodti a gaw-on moyo, bilang kamon ampanipon kayamanan ha pamigaw-an a kay mahira itaw ha langit ta itaw ay kay ma-ba-wahan, palibhasay homin ma-niba a maka-ka tan homin insikto a makahira. ");
INSERT INTO xsb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nga-min, no ayti yay kayamanan moyo ay itaw anamaot a nakom moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Wana ot ni Jesus, “Kailangan pirmi kamon handa tan yay pa-hal lawlamparilya moyo ay kailangan pirmin main apoy. ");
INSERT INTO xsb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Aligon moyo hilay ma-magsirbi a ampana-gan ha pa-morong nin amo la ibat ha kahal ta kala-lato nan amo la, no komatok ya ha polta ay antimano maabriyan la ya. ");
INSERT INTO xsb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Makalma hilay anorin a ma-magsirbi a ma-lato nan amo nin ampimata. Yay potog, ibalita ko komoyo, yadtin amo ay maghili ya para magsirbi konlan ma-magsirbi na ta patokloon na hila bi-sa dologan nin pa-mangan. ");
INSERT INTO xsb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Talagan makalma hiladtin ma-magsirbi no ma-lato hila nin amo la nin handa, maski man lomato ya ha botlay nin yabi o kari ha bandan palbangon. ");
INSERT INTO xsb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tandaan moyodtin a-sa ot a alimbawa: No komon ta tanda nin a-say main ikon bali no anyay oras a ilato nan mahiba, sigoradon nagpoyat ya tan kay na pino-layan a bali na nin na-looban. ");
INSERT INTO xsb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kanya hikamo man, kailangan pirmi kamon handa ta hiko a Naglalaman Tawo ay makalato ha oras a kay moyo an-ola-lomon.” ");
INSERT INTO xsb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hawanin, pinastang ni Pedro hi Jesus, wana, “Katawan, ya-rin imbalita mon alimbawa, para bongat doman komin dawdisipolos mo o para ha halban?” ");
INSERT INTO xsb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Imparalan ni Jesus a obat na ha a-say naman a alimbawa, wana, “Isipon mo: Hino kot a maiparis ha maronong tan maptog a ma-magsirbi, ta hiyay pa-tayaan nin amo para mangasiwa ha main nan bali, tan mamin pawpa-mangan konlan kapara nan ma-magsirbi ha intakda a oras? ");
INSERT INTO xsb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Makalma yay anodtin ma-magsirbi no ha kala-lato nan amo na ay anggaw-on nay impa-taya konan trabaho. ");
INSERT INTO xsb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yay potog, ibalita ko komoyo, sigoradon gaw-on na yan ma-ngasiwa ha halban kawkama-main na. ");
INSERT INTO xsb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kot no halitaon nan yadtin ma-magsirbi ha sarili na, ‘Maboyot ya ot lomato a amo ko,’ bi-sa bogbogon na hilay nay kapara nan ma-magsirbi, lalaki man o babayi ta bi-sa mangan ya tana tan minom anggan malahing, ");
INSERT INTO xsb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tongwa, makalato yay amo na ha awlon kay na an-asahan tan ha oras a kay na an-ola-lomon. Kanya sigoradon parosawan na yan amo na, bi-sa ilamo na ya itaw ha kamainan lan tawtawon kay antompol. ");
INSERT INTO xsb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yadtin ma-magsirbi a magtanda kalabayan nin amo na, balo ta ambo yan handa tan kay na ginwa a kalabayan nin amo na ay sigoradon garotyon yan golpi. ");
INSERT INTO xsb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kot yay ma-magsirbi a kay magtanda kalabayan nin amo na, bi-sa nakagawa yan dapat nan pagdosawan ay garotyon ya syimpri, balo ta daoto bongat. Nga-min, yay tawon binyan nin lako a bagay ay lako anamaot a obaton na, tan yay pina-tayaan nin mas lako a bagay ay mas lako anamaot syimpri a obaton na.” ");
INSERT INTO xsb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Wana ot ni Jesus, “Yay pa-mako ko iti ha lota ay para magkamain nin pa-hal pool tan yay labay ko komon ay dinomtay na. ");
INSERT INTO xsb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Balo ta kailangan dalanan ko yapon a pa-magdya-dya tan kay ko mika-kanya anggan kay mayari odti. ");
INSERT INTO xsb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hay wamoyo wari, yay pa-mako ko iti ha kalotaan ay pangibatan magkamain pa-misosondo a halban tawtawo? Ibalita ko komoyo, ambo anorin, ta masbali magkamain pa-mikokontra bana kongko. ");
INSERT INTO xsb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Paibat hawanin, alimbawa, no main lima katawo ha a-say pamilya, maari yay tolo ay kontra ha lowa, o yay lowa ay kontra konlan tolo. ");
INSERT INTO xsb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Alimbawa, yay tatay ay kontra ha anak a lalaki, o yay anak a lalaki ay kontra ha tatay na; yay nanay ay kontra ha anak a babayi, tan yay anak a babayi ay kontra ha nanay na; yay katyangan a babayi ay kontra ha manoyang nan babayi, tan yay manoyang a babayi ay kontra ha katyangan nan babayi.” ");
INSERT INTO xsb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wana ot ni Jesus konlan malabong a tawo itaw, “No ma-kit moyon main makorpal a lolom a ampangibat ha libaba, yay antimanon angka-halita moyo ay ‘Mangabagat.’ Potog anaor a mangabagat. ");
INSERT INTO xsb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tan no malayam moyoy namaot a lopot a ampangibat ha bagatan, wamoyo, ‘Mangamot.’ Potog anaor a mangamot. ");
INSERT INTO xsb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hikamoy ma-magkonwari! Tanda moyon intindyon yay pawpamilbian ha lota tan ha langit ta tanda moyo no anyay mangyari. Anongkot man ta kay moyo intindyon yay ampa-pangyari hawanin ta kay moyo tanda a panaon ana para pahakop ha pa-mag-ari nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Anongkot kay moyo an-isipon no anyay dapat moyon gaw-on? ");
INSERT INTO xsb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nga-min, yay dapat moyon gaw-on ha tawo ay gaw-on moyoy namaot ha Dios: Alimbawa, no main magdimanda komo ta ayton na ka ha howis, makiariglo kan tampol kona lo-gan iti kamo ot ha dalan ta no kai, piliton na kan iarap ha howis, ta bi-sa ipaaristo na kan howis ha polis, kanya mapriso kay na ingat. ");
INSERT INTO xsb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ibalita ko komo, kay ka makalikol ha prisowan anggan kay mo ma-bayaran yay kalin-ooltimowan sintimos nin molta mo.” ");
INSERT INTO xsb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hin ya-rin ay main tawtawo itaw a namibalita koni Jesus tongkol konlan omnoy Israelita a taga Galilea a impapati ni Gobirnador Pilato lo-gan lan ampamida-ton konan Dios, kanya nilaok a daya la ha daya lan aw-ayop a an-ida-ton la. ");
INSERT INTO xsb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wanan in-obat ni Jesus konla, “An-isipon moyo wari a mas makasalanan hila-rin a pinati dinan konlan laloman kaparan taga Galilea bana ta anodtaw a inogotan la? ");
INSERT INTO xsb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ambo tama! Ibalita ko komoyo: No kay kamo mangombabali ta kay moyo bokotan a kawkasalanan moyo ay miparoka kamoy namaot a halban. ");
INSERT INTO xsb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hiladtaw man a labinwaloy tawon nati ta na-bondagan tori ha Siloe, ha intindi moyo, mas makasalanan hila wari dinan konlan kapara lan taga Jerusalem? ");
INSERT INTO xsb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Disnodon ambo! Ibalita ko komoyo: No kay kamo mangombabali ta kay moyo bokotan a kawkasalanan moyo ay miparoka kamoy namaot a halban.” ");
INSERT INTO xsb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hin ya-rin ay inistorya ni Jesus konlay a-say alimbawa, wana, “Main a-say lalaki a main a-say poon igos itaw ha obasan na. A-say awlo, kina nadtin biniliw no main yay nan bonga, kot homin yan na-kit. ");
INSERT INTO xsb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kanya wana konan ma-ngasiwa ha obasan na, ‘Bilyon mo yadtin poon igos. Ikatlon taon ko yay nan angkaon biliwon no main yay nan bonga, kot anggan hawanin ay homin ot syimpri. Pokanon moy na ta sayang bongat a anlogaran na.’ ");
INSERT INTO xsb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kot wanan yadtin ma-ngasiwa, ‘Amo, hapa no mana-gan ta ot a-say taon, ta kotkoton koy ka-libol na ta bi-sa biyan yapon gwano. ");
INSERT INTO xsb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No mamonga ya ha homonol a taon, labah, kot no kai, pokanon yay na.’” ");
INSERT INTO xsb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ninghan, hin a-say naman a Awlon Pa-mainawa, nangaral yay naman hi Jesus ha a-say sinagoga. ");
INSERT INTO xsb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hin ya-rin ay main itaw nin a-say babayin labinwaloy taon anan ampagmasakit bana ta nilooban yan doka a ispirito. Kanya binomok'ot ya bi-sa kay nay na angkaitoynong a lalaman na. ");
INSERT INTO xsb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hin na-kit na ya ni Jesus, hina-wayan na ya, bi-sa wana, “Labah kay na ha masakit mo.” ");
INSERT INTO xsb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hin ya-rin a imparna ni Jesus a gamot na ha olo nan babayi, antimano naitoynong nay lalaman na, kanya pinori na yay Dios. ");
INSERT INTO xsb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kot yay ampamoon ha sinagoga ay ampagolo bana ta namaabig hi Jesus ha Awlon Pa-mainawa. Wana konlan tawtawo hin ya-rin, “Main a-nom a awlon dapat ipagtrabaho. Ha loob nin ya-rin a-nom a awlo ay dapat kamon mako iti para ma-paabig, ambo ha Awlon Pa-mainawa.” ");
INSERT INTO xsb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kot wanan in-obat nin Katawan kona, “Hikamoy mawma-magkonwari! Ambo doman maskin Awlon Pa-mainawa ay an-orkalan moyo a baka o asno moyo ha hihilongan la ta i-ka moyo hilan painomon? ");
INSERT INTO xsb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yadtin babayi a kaparan lipi ni Abraham ay pa-hal binalol ni Satanas ha loob nin labinwaloy taon. Ambo wari marapat a alihon ya konan ya-rin a pa-hal na maskin Awlon Pa-mainawa?” ");
INSERT INTO xsb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ha anorin a obat ni Jesus ay na-paringoyan hilay halban angkomontra kona. Hila balo a lawlaloman tawo itaw ay na-ligawan bana ha kalakan ka-paka-ngap a gi-ginwa na. ");
INSERT INTO xsb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bi-sa impagpatoloy ni Jesus a pangangaral na, wana, “Anya kari ha wamoyo yay kaalimbawaan nin pa-mag-ari nan Dios? Tan ayti ko kari iparis odti? ");
INSERT INTO xsb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yay ompisan pa-mag-ari nan Dios ay bilang ha a-say botol mostasa a inmola nin a-say tawo ha main nan antanamanan. Tinomobo yadti anggan nag-in bilang kayo kahi-ban, kanya pinanalayan nin mawmanok-manok a hawhanga na.” ");
INSERT INTO xsb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wana ot ni Jesus, “Ayti ko man ot ialimbawa yay pa-mag-ari nan Dios? ");
INSERT INTO xsb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yay kaka-kalat nin pa-mag-ari nan Dios ay bilang ha pampalbag. Maskin daoto bongat a inigwa nin a-say babayi ha tolon halop a arina ay na-palbag nay intiro.” ");
INSERT INTO xsb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ha pa-magpatoloy ni Jesus mako ha syodad Jerusalem, dinomalan ya ha bawbabali tan bawbaryo nin nangaral. ");
INSERT INTO xsb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hawanin, main namastang kona, wana, “Maistro, da-raoto bongat wari a tawtawon malipyas?” Wanan in-obat ni Jesus, ");
INSERT INTO xsb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yay kaalimbawaan nin kalo-loob ha langit ay bilang ha kalo-loob ha a-say makipot a polta. Kanya pag-inakitan moyon lomoob ha pa-hal makipot a polta. Ibalita ko komoyo, lomato a panaon a lako a magpilit nin lomoob kot kay ana makaloob. ");
INSERT INTO xsb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Nga-min, yay mag-in kaalimbawaan nin yadti ay yay main ikon bali kot inhara nay na a polta. Bi-sa omdong kamo tana ha likol nin makatok-katok, ta wamoyo, ‘Sinyor! Sinyor, paloobon mo kami pa!’ Kot yay iobat na komoyo, ‘Kai! Kay katamo ambilbion maskin yay pinangibatan moyo.’ ");
INSERT INTO xsb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ba-yo halitaon moyo, ‘Naipagka-rongo mo kamin nangan tan ninom, bi-sa nangaral kay namaot ha logar mi.’ ");
INSERT INTO xsb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kot halitaon na syimpri komoyo, ‘Imbalita koy na komoyo a kay katamo ambilbion maskin yay pinangibatan moyo. Paka-dayo kamo kongko, hikamoy halban ma-mangwa doka.’ ");
INSERT INTO xsb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Konan ya-rin ay mi-tangih-tangih kamo itaw tan mi-pigogot ha grabin kadya-dyaan, laloy na no ma-kit moyo hi Abraham, hi Isaac tan hi Jacob, tan halban lan pawpropita nan Dios itaw ha kaarian na, kot hikamo balo ay itaboy na. ");
INSERT INTO xsb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Main tawtawon mirorongon mangan itaw ha kaarian nan Dios a nangibat ha intiron mondo, ha bagatan, mayanan, libaba tan baytan. ");
INSERT INTO xsb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yay mangyari ay anodti: Main angka-hoyot hawanin a mio-na ha lomato a panaon, tan main anamaot ampo-na hawanin a ma-hoyot ha lomato a panaon.” ");
INSERT INTO xsb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Konan ya-rin ot a oras, main paw-Pariseo a nako koni Jesus, ta wanla, “Omalih kay na iti ta labay na kan patyon ni Ari Herodes Antipas.” ");
INSERT INTO xsb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kot wanan in-obat ni Jesus, “Mako kamo konan ya-rin tawon ma-naktika, ta ibalita moyo kona a hawanin tan dilap ay ipagpatoloy koy pa-malayah nin dawdoka a ispirito, tan pa-maabig konlan main mawmasakit. Ha ikatlon awlo ay mayari koy nay gawa ko. ");
INSERT INTO xsb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Balo ta kailangan kon itoloy yay pa-mako ko ha Jerusalem hawanin awlo, dilap tan anggan ha makalwa. Nga-min yay a-say propita nan Dios ay kay maari patyon ha laloman logar no ambo ha Jerusalem bongat. ");
INSERT INTO xsb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“An-ikalolo katamoy tawtaga Jerusalem ha gawgawa moyon pa-mangmati ha pawpropita nan Dios tan pa-ma-batibat moyon bawbato anggan mati hilay laloma ot a an-ihogo na komoyo. Mabotbot a ngali-ngali kon mangano para alakopon katamon bilang ha pa-ngalakop nin toan manok ha sawsisiw na ha hilong pakpak na, kot hikamoy kay malabay. ");
INSERT INTO xsb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kanya po-layan nan Dios odtin syodad moyo. Ibalita ko komoyo: Kay moyo koy na ma-kit anggan ha panaon a ihakbat moyo kongkon halitaon, ‘Poriwon yay anlomato ha ngalan nan Katawan.’” ");
INSERT INTO xsb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A-say Awlon Pa-mainawa, inimbita hi Jesus nin mangan ha bali nin a-say ampamoon a myimbro nin paw-Pariseo. Hin ya-rin ay ambantayan la hi Jesus no anyay gaw-on na, ");
INSERT INTO xsb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","bana ta main itaw a-say lalakin angkaba-nol a lalaman. ");
INSERT INTO xsb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pinastang ni Jesus hilay mawmaistron kapanogoan tan hilay paw-Pariseo, wana, “Ayon ha kawkapanogoan nan Dios, bawal doman mamaabig ha Awlon Pa-mainawa o kai?” ");
INSERT INTO xsb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kot kay hila tinomlok. Hin ya-rin ay pinaabig ni Jesus yay lalakin angkaba-nol a lalaman, ba-yo pinaorong na ya. ");
INSERT INTO xsb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bi-sa wani Jesus konlan mawmaistron kapanogoan tan konlan paw-Pariseo, “Alimbawa ta main komoyo a main asno o baka a nadabo ha bobon, kay mo ya wari alawahon tampol maskin Awlon Pa-mainawa?” ");
INSERT INTO xsb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kot kay hilay naman nakaobat ha pastang na. ");
INSERT INTO xsb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hin ya-rin ay naasikaso ni Jesus a halban lan bawbisita ay namili nin totokloan a intatala para konlan mawmain ingkatawo. Kanya wani Jesus konla, ");
INSERT INTO xsb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No alimbawa ta main mangimbita komo ha a-say kahal, ando ka tomoklo ha tokloan lan main ingkatawo ta ola-no main ot inimbitan mas ambilbion main ingkatawo dinan komo. ");
INSERT INTO xsb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bi-sa i-ka na ya nin nangimbita ison ha tinokloan mo, bi-sa wana komo, ‘Ya-rin a totokloan ay intatala para konan yadtin tawo.’ No anorin a mangyari ay ma-paringoyan ka ta mi-ka kay na ingat ha pinakamaaypa a klasin tokloan. ");
INSERT INTO xsb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kanya no main mangimbita komo, tomoklo ka tana ha maaypa a klasin tokloan ta pigaw ha kala-lato nan nangimbita komo ay halitaon na komo, ‘Amigo, itaw ka tomoklo ha mas magandan totokloan.’ Ha anorin a mangyari ay ma-parangalan ka ha arapan lan halban kalamo mon nakarongo ha lamisawan. ");
INSERT INTO xsb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nga-min, hinoman a ampagmata-gay ay iaypa, kot hinoman a ampagmaaypa ay ita-gay.” ");
INSERT INTO xsb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hawanin, wanay namaot ni Jesus konan Pariseo a nangimbita kona, “No maghanda ka, alimbawa pangogtowan o pangaponan, ando mo pilion imbitawon hilay maka-tobalo komo a bilang konlan aw-amigo mo, tawtalakaka o kari hilay kawkaholibay mon mayaman. Nga-min, imbitawon la kay namaot, kanya ma-tobalo kay na. ");
INSERT INTO xsb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Masbali no maghanda ka, pilion mon imbitawon hilay mawmairap, hilay main dawdipirinsya a bilang konlan pawpokol, pawpilay tan bawbolag. ");
INSERT INTO xsb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","No anorin, makalma ka ta kay la ka ma-tobalo imbitawon, kanya yay Dios a tomobalo komo ha pa-maorong nan mabyay konlan tawtawon maptog.” ");
INSERT INTO xsb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hin nalngo la-rin nin hilay karongo ni Jesus nin ampangan, main a-sa konla a nanalita, wana kona, “Makalma hilay tawon maka-paki-lamo nin mangan itaw ha ampag-arian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kot wanan in-obat ni Jesus kona a imparalan ha alimbawa, “Main a-say lalakin naghanda nin mahi-ban a handaan tan golpin tawoy inimbita na. ");
INSERT INTO xsb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hin oras anan mangan, inhogo nay alila na konlan aw-inimbitawan na ta impapibalita nay anodti: ‘Mako kamoy na iti,’ wana, ‘ta nakahanda anay halban.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Balo ta balang a-sa konla ay pari-parihon ni-pagbara-nan. Wanan yay o-na, ‘Nakahaliw akon lota, kanya kailangan kaon kon biliwon. Ipakibalita mo pa tana konan amo mo a dispinsawon na ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wanay namaot a-sa, ‘Nanaliw akon mapolo a baka, kanya labay ko hilan halion hawanin nin itrabaho. Ipakibalita mo pa tana konan amo mo a dispinsawon na ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wana ot nin a-sa, ‘Kapikahal kon bongat, kanya kay ko maka-ka.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kanya norong yay alila ta imbalita nay bawbara-nan la konan amo na. Nagolo yay amo konla, kanya wana konan alila na, ‘Mako kan tampol ha kawkalsada tan aw-iskinita iti ha babali ta awiton moy na ingat iti hilay mawmairap, pawpokol, pawpilay tan bawbolag.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pa-magbolta nan alila, wana konan amo na, ‘Amo, ginwa koy nay ayon ha pinanogoan mo, kot lako ot syimpri ma-tokloan.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanya wanan amo konan alila na, ‘Mako ka ot ha likol babali ha kawkalsada tan ha mangakalog a dalan itaw ta piliton mon hagyaton a tawtawo nin mako iti pigaw mapno a bali ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bi-sa wana ot, ‘Ibalita ko komoyo, hinoman konlan o-nan inimbitawan ko ay kay maka-taway ha inhanda kon pawpa-mangan.’” ");
INSERT INTO xsb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Golpin tawo a naki-ka koni Jesus ha pa-mako nan syodad Jerusalem. Hin ya-rin ay inomarap ya konla, ta wana, ");
INSERT INTO xsb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hinoman a malabay homonol kongko ay kailangan mas maigot a labi na kongko dinan ha main nan tatay, nanay, kaambali, awa-nak o tawtalakaka tan maski mismon ha sarili na ta no kai ay kay ya maari mag-in disipolo ko. ");
INSERT INTO xsb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hinoman a kay mananggap nin kadya-dyaan a andomalan ha biyay na alang-alang kongko a kaalimbawaan kay na balatayon a sarili nan kros, tan kay anamaot homonol kongko ay ambo yan karapat-dapat mag-in disipolo ko. ");
INSERT INTO xsb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Alimbawa, main wari komoyo a magplanon mama-dong nin mata-gay a tori nin kay na yapon paka-kwintawon no main yan bastantin magastos para ipangyari? ");
INSERT INTO xsb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nga-min, ola-no maigwa nay pondasyon, bi-sa kay nay na ma-polyari a tori. Kanya kaka-lihan la yan halban maka-kit, ");
INSERT INTO xsb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tan halitaon la, ‘Ya-rin a tawo, nama-pa-dong ya anta kay nay nan lamang na-polyari.’ ");
INSERT INTO xsb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O alimbawa anamaot, main wari ari a mako ki-laban ha kapara nan ari a kay yapon pag-aralan no yay mapolo a libon hondalo na kot baba lan talowon yay lowampolo a libon hondalo nin kapara nan ari? ");
INSERT INTO xsb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nga-min, no ha isip na kot kay lay nan lamang mababa, lo-gan madayo hila ot a kalaban ay mamihogo yay nan tampol nin mamibalita konan kapara nan ari a labay nay nan kiayos. ");
INSERT INTO xsb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Hikamo man, mangisip kamo yapon ta hinoman a kay na bokotan a halban main kona ay kay ya maari nin ipagdisipolo ko.” ");
INSERT INTO xsb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wana ot ni Jesus, “Balang anhomonol kongko ay pa-hal asin. Maalaga a asin, kot no alimbawa ta na-hominan yay nan alat, maiorong ot wari a alat na? ");
INSERT INTO xsb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Homin yay nan sirbi ni pampataba lota, o maskin ilamo ha ampaniponan nin pampataba lota ay kay syimpri maari, kanya labah ot ibantak. Hikamoy ampakalngo, intindyon moyoy nalngo moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hin ya-rin ay kalakan mawma-ni-non bowis a mangahaol tan laloma ot a tawtawon makasalanan a andomani koni Jesus para manglongo kona. ");
INSERT INTO xsb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kot main itaw paw-Pariseo tan mawmaistron kapanogoan a ni-panalamorom, ta wanla, “Ya-rin a tawon ya-rin, antanggapon nay tawtawon makasalanan ta bi-sa ampakirongo ya ot nin mangan konla.” ");
INSERT INTO xsb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bana ta anorin, tinotol ni Jesus konla odtin alimbawa, wana, ");
INSERT INTO xsb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“No wari ta main a-sa komoyo a main sanyatos a karniro, bi-sa napirdi a a-sa, anyay gaw-on na? Kay na hila wari ibati yapon a siyam-a-polo tan siyam itaw ha lawak a ampagpastolan na ta kaon nan tingkapon yay a-say napirdi anggan ha ma-kit nadti? ");
INSERT INTO xsb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bi-sa, no ma-kit na yay na, lilikot nay nan balatayon odti para iorong. ");
INSERT INTO xsb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pa-makalato na ha bali, ha-wayan na hilay aw-amigo tan kawkaholibay na, ta wana konla, ‘Maki-lilikot kamo kongko ta na-kit koy karniro kon napirdi.’” ");
INSERT INTO xsb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wani Jesus, “Ibalita ko komoyo, anorin ot bongat itaw ha langit, mas mahi-ban a kaligawan la bana ha a-say tawon makasalanan a nangombabali tan binokotan nay main nan kawkasalanan, dinan ha siyam-a-polo tan siyam a mahonol ha Dios a ambo kailangan mangombabali.” ");
INSERT INTO xsb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Wana ot in-alimbawa ni Jesus, “No wari ta main a-say babayi a main mapolo a kwartan pilak, bi-sa napirdi nay a-sa, anyay gaw-on na? Kay ya wari mamartan lamparilya, ta bi-sa kalihan nay bali para paka-biliwon nadtin napirdi nan kwartan pilak anggan ha ma-kit na? ");
INSERT INTO xsb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bi-sa, no na-kit nay na, ha-wayan na hilay aw-amiga na tan kawkaholibay, ta wana, ‘Maki-lilikot kamo kongko ta na-kit koy napirdi kon kwartan pilak.’” ");
INSERT INTO xsb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wani Jesus, “Ibalita ko komoyo, anorin ot bongat konlan aw-anghil nan Dios ha langit, malilikot hilay namaot no main a-say makasalanan a nangombabali tan binokotan nay main nan kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wana ot ni Jesus, “Main a-say tatay a main loway anak a lalaki. ");
INSERT INTO xsb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A-say awlo, wanan bonso konan tatay na, ‘Tay, ibi mo pay nay parti ko ha ma-tawil ko komo.’ Pinarti nay naor tatay a kama-main na para konlan loway anak na. ");
INSERT INTO xsb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kot kay naboyot, inlako nan yadtin bonso yay halban tinawil na, ta nako ya ha a-say marayo a logar. Dinama-dama na itaw a halban nan na-paglakoan ta namiyay yan homin kwintan pamimiyay. ");
INSERT INTO xsb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Hin na-min nay nay kwarta na, nitaon a nagkamain nin grabin bitil itaw ha logar a kamainan na, kanya nag-irap ya. ");
INSERT INTO xsb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yay ginwa na ay nagpaalila ya ha a-say taga itaw. Yay inimbin trabaho kona ay mangalaga nin bawbaboy itaw ha bowat. ");
INSERT INTO xsb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ha sobran kabitilan na, maskin pa-mangan a an-ibi konlan bawbaboy ay labay nay na komon kanon, kot homin tanan nami kona maski anya. ");
INSERT INTO xsb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hin naisip-isip nadtin kapa-halan na, wana ha sarili na, ‘Kalakan nan aw-alila ni tatay a ansomobra ha pawpa-mangan. Halako ta hiko iti ay halos mati na ha bitil. ");
INSERT INTO xsb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Morong akoy na koni tatay ta makirawat akon patawad, ta halitaon ko kona: Tay, nakapagkasalanan ako ha Dios tan komo. ");
INSERT INTO xsb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ambo akoy nan marapat itoring nin anak mo, nokay itoring mo ko tanan a-sa konlan aw-alila mo.’ ");
INSERT INTO xsb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hin ya-rin ay nibwat yay naor ta norong itaw konli tatay na. “Madayo ya ot ha bali la ay na-tamolaw na yay na ni tatay na. Nadabo a inganga-ro na kona, kanya nolayo yan hinomakbat kona, bi-sa niyakoh na ya tan inalokan. ");
INSERT INTO xsb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wanan yadtin anak koni tatay na, ‘Tay, nakapagkasalanan ako ha Dios tan komo. Ambo akoy nan marapat itoring nin anak mo.’ ");
INSERT INTO xsb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kot hina-wayan nan tatay yay aw-alila na, wana, ‘Awiton moyo iti yay pinakamagandan ayhing ta iholot moyo kona. Bi-sa paholotan yan singsing tan pasapatosan. ");
INSERT INTO xsb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pa-makayari ay kowon moyo yay pinataba a baka ta patyon. Bi-sa mangan tamo tan mi-liga-liga. ");
INSERT INTO xsb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nga-min, yadtin anak ko, kapa-halan na ay nati kot norong nabyay, tan pa-hal napirdi kot na-kit oman.’ Kanya nag-ompisa hilay nan ni-liga-liga. ");
INSERT INTO xsb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Hin ya-rin, yay kalingkakaan a anak ay itaw ya ha bowat. Hin norong ya, tan hin madani yay na ha bali la, nalngo na a main togtogan tan bayliwan. ");
INSERT INTO xsb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kanya hina-wayan nay a-say alila la, ta pinastang na no anyay main konla. ");
INSERT INTO xsb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wanan imbalita nin alila kona, ‘Norong a ali mo, kanya impapati ni tatay mo yay pinataba a baka bana ta norong yan angkabyay tan maligsa.’ ");
INSERT INTO xsb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nagolo yadtin kaka tan kay na labay lomoob ha bali la. Kanya kina na ya ni tatay na ta inamo-amo na yan lomoob. ");
INSERT INTO xsb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kot wanan in-obat konan tatay na, ‘Hiko ingat odti, omnoy taon anan ampagsirbi komo, tan nika-ka-noman kay ko kinomontra ha kawkapanogoan mo. Kot ni ninghan, kay mo ko binyan maski a-say kanding ta pigaw maipaki-liga-liga koy namaot konlan aw-amigo ko. ");
INSERT INTO xsb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kot hin nakalato odtin anak mo a nanama-dama nin kama-main mo konlan dawdoka a babayi, impangmati mo ya ot nin pinataba a baka.’ ");
INSERT INTO xsb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wanan tatay kona, ‘Anak ko, lawah kan iti kongko, tan halban ikon ko ay ikon mo. ");
INSERT INTO xsb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tama bongat a malilikot tan mi-liga-liga tamo ta yadtin ali mo, kapa-halan na ay nati na kot norong nabyay, tan pa-hal napirdi na kot na-kit oman.’” ");
INSERT INTO xsb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hawanin, nami yay namaot hi Jesus nin alimbawa konlan dawdisipolos na, wana, “Main a-say mayaman a main nin a-say ma-ngasiwa. Hawanin, main namibalita konan yadtin mayaman a yay ma-ngasiwa na kot andama-damaon na kanoy kawkama-main na. ");
INSERT INTO xsb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kanya impaha-wayan na yay ma-ngasiwa ta pinastang na ya, wana, ‘Anya yadtin angka-balitaan kon ambo labah tongkol komo? Ibi moy na kongkoy lawlistawan nin halban impa-pa-taya ko komo ta kay kay na maari magpatoloy bilang ma-ngasiwa ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bana ta anodtaw, wanan ma-ngasiwa ha sarili na, ‘Anya kari a dapat kon gaw-on ta alihon na koy nan amo ko bilang ma-ngasiwa na? Ambo ko paot kababaan mamalbwat tan angkaringoy akoy namaot makilimoh. ");
INSERT INTO xsb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, tanda koy nay gaw-on kon paralan, pigaw painsan no maalih akoy na bilang ma-ngasiwa ay pahandaon la ko ha bali la nin hilay nakaotang ha amo ko.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kanya yay ginwa na ay ina-sa-a-sa nan impa-ka hilay mawmain aw-otang konan amo na. Bi-sa wana konan primiro, ‘Omnoy otang mo konan amo ko?’ ");
INSERT INTO xsb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Obat na, ‘Sanyatos a latan mantika.’ Hawanin, wanan ma-ngasiwa kona, ‘Oyay listawan nin otang mo. Tomoklo ka ta dandalion mon hagilyan nin limampolo bongat.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bi-sa wana konan ikalwa, ‘Hapay hika, omnoy otang mo?’ Yay obat na, ‘Sanyatos a kaban nin trigo.’ Wanan ma-ngasiwa kona, ‘Oyay listawan nin otang mo. Igwa mon walompolo.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hin na-tandaan nadti nin amo na ay na-pori na ya ingat yay mahaol a ma-ngasiwa ha kahosayan nan magparihado para ha lomato a panaon. Nga-min, hilay tawtawon makamondo ay mas mahosay hila ha pa-magparihado para ha lomato a panaon iti ha mondo, dinan hilay maka-Dios ha pa-magparihado para ha dobali biyay.” ");
INSERT INTO xsb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Bi-sa wanan impagpatoloy ni Jesus, “Ibalita ko komoyo, yay kayamanan iti ha babon lota ay ampangibatan nin lako a karokaan, balo ta hikamo, gamiton moyodti ha kata-tambay ha kapara pigaw ha oras a kay moyoy na magamit orin, matanggap kamon mi-wan ha langit anggan-angga. ");
INSERT INTO xsb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nga-min, yay tawon ma-pasimalaan ha makalog a bagay ay ma-pasimalaan anamaot ha mahi-ban a bagay. Kot yay tawon mahaol ha makalog a bagay ay mahaol anamaot ha mahi-ban a bagay. ");
INSERT INTO xsb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kanya no kay kamo ma-pasimalaan ha kayamanan iti ha babon lota a ampangibatan nin lako a karokaan, hino man wari a mamipa-taya ot komoyo nin potog a kayamanan ha langit? ");
INSERT INTO xsb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A-sa ot, no kay kamo ma-pasimalaan hawanin ha ambo moyon ikon ta halban bagay ay impa-taya bongat anaor nin Dios komoyo, hino man wari a mami komoyo ha lomato a panaon nin yay dapat moyo komon ipag-ikon?” ");
INSERT INTO xsb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wana ot nin in-alimbawa ni Jesus, “Ambo dapat paalipon yay a-say tawo ha loway amo, bana ta kay na hila ma-pagsirbiwan nin hosto ta yay ogotan nin ya-rin ay kasorawan nay a-sa, kot yay a-sa ay ma-labi na. O kari ma-kilingan nay a-sa ta yay a-sa kot ma-basta-basta. Anorin anamaot kapara, kay moyo ma-pi-sabay pagsirbiwan yay Dios tan yay kayamanan.” ");
INSERT INTO xsb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hin ya-rin ay main anamaot itaw paw-Pariseo a lawlopan kwarta a nakalngo nin yadtin halban alimbawa ni Jesus. Kanya tinoya-toya la ya. ");
INSERT INTO xsb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kot wani Jesus konla, “Ampiabig-abig kamo ha arapan lan tawtawo, kot tanda nan Dios yay kawkanakoman moyo. Nga-min, anya may ampaalagawon nin tawtawon makamondo ay ka-pariril konan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Wana ot ni Jesus, “Yay kawkapanogoan nan Dios tan yay sawsinolat lan propita na ha Masanton Kasolatan ay an-ipahonol ha tawtawo anggan hin nakalato hi Juan Bautista. Kot paibat hin nangaral hi Juan Bautista, yay an-ipangaral ana ay yay tongkol ha pa-mag-ari nan Dios, bi-sa halos halban ay ampagpilit nin pahakop ha pa-mag-ari na. ");
INSERT INTO xsb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anodtaw pa man, kay syimpri maalihan alaga yay kawkapanogoan nan Dios. Mangyari a manganggawan a langit tan lota, kot kay maari mangyari a maalihan kwinta yay kawkapanogoan nan Dios, maski yay pinakamakalog a parti nan ya-rin. ");
INSERT INTO xsb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oyay a-sa ha kawkapanogoan nan Dios a homin kali-lipas: Hinoman a lalaki a mamihiyay nin kaambali bi-sa magkaambalin laloma ay magkasalanan yan pa-mabayi. Anorin anamaot kapara, hinoman a lalaki a magkaambali konan yay babayin inhiyay nin kaambali ay magkasalanan anamaot nin pa-mabayi.” ");
INSERT INTO xsb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Wanay naman in-alimbawa ni Jesus, “Main a-say lalakin mayaman a yay klasin an-ipagdoloh na ay mawmabli tan yay pa-mangan na ha inawlo-awlo ay ambo basta-basta. ");
INSERT INTO xsb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bi-sa main anamaot a-say lalakin na-pakapobri a yay ngalan na kot Lazaro. Halos intiron lalaman na ay pono nin halna a ampangnana. Itaw ya tana nakaiira ha danin poltan bali nan yadtin lalakin mayaman. ");
INSERT INTO xsb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","An-aposon nan ma-biyan ya maski tana komon mawmomo a angkadabo ha lamisawan nan mayaman. Hilay namaot a aw-aso ay angkaon la ya ta antapohan lay hawhalna na. ");
INSERT INTO xsb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ha maparah a olit, nati yay pobrin hi Lazaro, bi-sa inawit la yan aw-anghil nan Dios itaw ha kamainan ni Abraham. Kay naboyot, nati yay namaot yay lalakin mayaman, bi-sa intabon. ");
INSERT INTO xsb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Kot itaw ya ni-ka ha impyirno. Hin itaw yay na ampagdya-dya ay tinomangal ya, bi-sa na-tamolaw na itaw hi Abraham a ka-dani na hi Lazaro. ");
INSERT INTO xsb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanya hinoma-way yan makhaw, wana, ‘Ama kon Abraham, inganga-ro moy na. Ihogo mo pa hi Lazaro ta idoldol nay tampoh nin tamoro na ha lanom ta palayopan nay dila ko, bana ta masyado kon ampagdya-dya iti ha apoy.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kot wani Abraham kona, ‘Anak ko, panomtomon mo hin lolog biyay mo itaw ha babon lota ay natanggap moy nay halban kainomayan, kot hi Lazaro balo ay biig nin kawkairapan. Hawanin, hiyay ampakonswilowon, ta hikay namaot a ampagdya-dya. ");
INSERT INTO xsb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Likol konan yadti, ha pibotlayan nin logar mi tan logar moyo ay main nin na-pakalalo a bongaw, pigaw hilay iti ay kay maka-ka ison tan hikamoy namaot a ison ay kay maka-ka iti.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Bi-sa wanan mayaman, ‘No anorin no-nin, Ama Abraham, an-ipaki-totol ko komo a pa-kaon mo hi Lazaro ha bali ni tatay ko itaw ha lota, ");
INSERT INTO xsb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta main ako ot nin limay talakakan lalaki. Komon balitaan na hila tongkol konan yadti, pigaw kay hila mi-ka iti ha logar a sangkadya-dyaan.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kot wani Abraham kona, ‘Ambo anan kailangan bana ta main hilay nan Masanton Kasolatan a sinolat ni Moises tan hilay pawpropita nan Dios. Yadti a dapat lan long-on.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kot wanay namaot nin mayaman, ‘Kay la long-on orin, Ama Abraham. Kot no main a-say tawon nati na a magbolta itaw konla nin mamibalita ay sigoradon mangombabali hila tan bokotan lay kawkasalanan la.’ ");
INSERT INTO xsb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wanay namaot ni Abraham kona, ‘No kay la pi-polon a sawsinolat ni Moises tan hilay pawpropita nan Dios, kay hilay namaot ma-kombinsi maski man main morong mabyay nin mamibalita konla.’” ");
INSERT INTO xsb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wani Jesus konlan dawdisipolos na, “Kay maiwasan a lomato a tawtokso ha biyay nin tawo, balo ta ka-pali-moy ogotan nin hinoman a pangibatan nin makapagkasalanan a kapara na. ");
INSERT INTO xsb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Labah ot katinan a looy na nin baton an-ipangiling ta bi-sa ibantak ya ha taaw, dinan mag-in yan pangibatan makapagkasalanan a a-sa konlan antompol kongko a maaypa ha hilap nin tawo. ");
INSERT INTO xsb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kanya mag-ingat kamo. “No wari ta makapagkasalanan a a-say talakaka komo, sitawon mo ya. Bi-sa, no pangombabalyan na-rin, patawaron mo ya. ");
INSERT INTO xsb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maski man wari makapagkasalanan ya komo nin pitoy bisis ha loob nin a-say awlo, balo ta pitoy bisis yay namaot mako komo nin makirawat patawad, kailangan patawaron mo ya.” ");
INSERT INTO xsb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hawanin, wanlan aw-apostolis konan Katawan, “Pa-lahan mo pay katotpol mi.” ");
INSERT INTO xsb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Wanan Katawan, “Maskin main kamo tanan katotpol a bilang bongat kakalog botol mostasa, ta alimbawa halitaon moyo konan ya-rin a poon sikomoro, ‘Mabotbot ka ta tomobo ka ha ambay!’ ay homonol ya komoyo.” ");
INSERT INTO xsb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Wana ot ni Jesus, “Alimbawa, main a-sa komoyo a main alila nin ampangararo o kari ampagpastol. Kala-lato nan ya-rin alila ibat ha bowat, halitaon mo wari kona a domolog yay nan tampol ta mangan? ");
INSERT INTO xsb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ambo doman masbali halitaon mo kona: ‘Ihanda moy pangaponan ko, bi-sa mag-ayos ka ta sirbiwan mo kon mangan. Pa-makayari ay maari kay nan mangan.’ ");
INSERT INTO xsb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hawanin, pasalamatan mo wari a alila bana ta ginwa nay pinanogoan mo kona? Para kongko, kai! ");
INSERT INTO xsb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anorin ot bongat komoyo, no magawa moyoy nay halban ampanogoan nan Dios komoyo, marapat bongat a halitaon moyo, ‘Aw-alila kamin bongat a ambo dapat pasalamatan ta ginwa min bongat a katongkolan mi.’” ");
INSERT INTO xsb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ha pa-magpatoloy la ni Jesus makon Jerusalem, nagpa-wan hila ha pibotlayan nin probinsyan Samaria tan probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hin miabot hilay na ha a-say baryo, hinakbat yan mapolo a tawon main masakit kitong. Bana ta ampakaolamit a masakit la, tinomgon hila ha main distansya koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wanlan in-aghaw, “Jesus! Maistro, inga-rowan mo kami pa!” ");
INSERT INTO xsb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pa-maka-kit ni Jesus konla, wana, “Mako kamo konlan pawpari ha Jerusalem ta ipa-kit moyon inomabig kamoy na.” Lo-gan hilan anlalako para magpa-kit, inomabig hilay na. ");
INSERT INTO xsb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yay a-sa konla, hin na-sikaso nan inomabig ya ha main nan masakit, tampol yan nagbolta koni Jesus nin pinori nay Dios ha makhaw a bosis. ");
INSERT INTO xsb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bi-sa nanalimokor yan palokob ha arapan ni Jesus nin ampaki-salamat kona. Yadti paot a lalaki ay ambo yan Israelita, nokay taga ya Samaria. ");
INSERT INTO xsb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hawanin, wanan impastang ni Jesus, “Ambo doman mapolo hilay inomabig? Ayti hila may siyam? ");
INSERT INTO xsb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Homin ana doman laloman nagbolta para poriwon yay Dios no ambo yadtin dayowan bongat?” ");
INSERT INTO xsb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bi-sa wani Jesus kona, “Omdong kay na ta maari kay nan mako. Inomabig ka bana ha main mon katotpol.” ");
INSERT INTO xsb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ninghan, main paw-Pariseo a namastang koni Jesus no maka-no makalato a pa-mag-ari nan Dios. Wanan in-obat konla, “Yay pa-mag-ompisa nin pa-mag-ari nan Dios ay homin ma-kit palatandaan, ");
INSERT INTO xsb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","tan homin maka-pibalita nin: ‘Oyay na!’ o ‘Itaw ana!’ bana ta yay pa-mag-ari nan Dios ay iti ha nakom nin tawo a antompol kona.” ");
INSERT INTO xsb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bi-sa wani Jesus konlan dawdisipolos na, “Lomato a panaon a labay moyoy nan ma-kit a hiko a Naglalaman Tawo ay mag-ari ana iti ha babon lota, maskin a-say awlon bongat, kot kay moyo ot ma-kit. ");
INSERT INTO xsb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bi-sa main mamibalita komoyo nin: ‘Oyay na!’ o kari ‘Itaw ana!’ Kot ando kamo mako ni maki-ka konla. ");
INSERT INTO xsb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nga-min, ha awlon kala-lato ko, hiko a Naglalaman Tawo ay ma-kit la kon halban tawo nin bilang ha kimat a ampaka-hawang ha intiron langit. ");
INSERT INTO xsb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kot hawanin, kailangan domalan ako yapon ha lako a pa-magdya-dya tan itakwil nin tawtawo hawanin a panaon. ");
INSERT INTO xsb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Yay pa-hal nin tawtawo ha kala-lato ko, hiko a Naglalaman Tawo ay bilang ot bongat ha pa-hal lan tawtawo hin panaon ni Noe. ");
INSERT INTO xsb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sigi-sigi hilan ampangan tan ampinom, main ampi-pagkaambali tan main anamaot an-ipaambali anggan hin awlon nilomoob hila ni Noe ha arko. Tongwa, nanglonop ta bi-sa ni-kati hilay halban. ");
INSERT INTO xsb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Anorin ot bongat syimpri a pa-hal lan tawtawo hin panaon ni Lot. Sigi-sigi hilay namaot nin ampangan, ampinom, ampanaliw tan ampaglako, ampangmola tan ampama-dong bali. ");
INSERT INTO xsb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kot hin awlon inomalih hila ni Lot ha syodad Sodoma, inabagat nan Dios nin apoy tan asopri yay Sodoma, kanya ni-kaopoh hilay halban na-bati itaw. ");
INSERT INTO xsb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Anorin anamaot a mangyari ha awlon hiko a Naglalaman Tawo ay magboltan oman iti. ");
INSERT INTO xsb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Konan ya-rin a panaon, hinoman a ma-palatan ha likol nin bali ay ando ana mag-abala nin lomoob ot para mangwa nin anyakaman a kawkama-main na, nokay molayo yay nan omari. Anorin anamaot kapara ha hinoman a ma-palatan ha bowat, ando yay na mag-abala nin morong ot ha bali. ");
INSERT INTO xsb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Panomtomon moyoy nangyari ha kaambali ni Lot. Nag-in yan asin bana ta kinawa-nan nan ibati a main lan kawkama-main. ");
INSERT INTO xsb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nga-min, yay tawon ambo matibolos a nakom mati alang-alang kongko ay kay na matanggap yay biyay a homin anggawan, kot yay tawon mati alang-alang kongko ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ibalita ko komoyo, no wari ta yabi a ilato ko, main mangyarin aw-anodti: Alimbawa, main loway tawo a angka-lok ha a-say iraan, bi-sa yay a-sa ay kowon ta yay a-sa kot ibati. ");
INSERT INTO xsb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Anorin anamaot kapara, main loway babayin ampi-tambay nin mangiling, bi-sa yay a-sa ay kowon ta yay a-sa kot ibati. ");
INSERT INTO xsb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mangyari namaot a main loway lalakin ampi-tambay nin ampagtrabaho ha bowat, bi-sa yay a-sa ay kowon ta yay a-sa kot ibati.”* ");
INSERT INTO xsb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hin ya-rin ay pinastang la hi Jesus nin hilay dawdisipolos na, wanla, “Katawan, ayti mangyari orin?” Wanan in-obat konla, “No ayti bangkay, itaw ampititipon a bawbowitri.” ");
INSERT INTO xsb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hin ya-rin ay nanotol anaman hi Jesus nin a-say alimbawa konlan dawdisipolos na, pigaw toroan na hilan lawah domawat ha Dios nin kay homawa. ");
INSERT INTO xsb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wana, “Ha a-say babali ay main a-say howis a homin li-mo ha Dios tan homin yan anggalangon a tawo. ");
INSERT INTO xsb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Konan ya-rin ot a babali ay main anamaot a-say babayin balo a pirmin ampako konan ya-rin a howis ta ampatambay yan ipaglaban nay katoynongan na ha kontraryo na. ");
INSERT INTO xsb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naboyot na ya yapo tinanggiwan nin yadtin howis, kot hin bandan hoyot, wana ha sarili na, ‘Maski man kay ko angkali-mo ha Dios ni anggomalang ha tawo, ");
INSERT INTO xsb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ipaglaban ko pay nay katoynongan nin yadtin babayin balo, ta lawah na kon an-istorbowon. Ola-no mapnoan akoy na ha pa-mako-pako na iti.’” ");
INSERT INTO xsb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pa-makayari, wanan Katawan konlan dawdisipolos na, “Anorin a hinalita nan doka a howis. ");
INSERT INTO xsb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hawanin, kay nay namaot wari ipaglaban nin Dios a katoynongan nin hilay tawtawon pinili na a awlo-yabin andomawat kona, anggano man no minghan bilang main kaboyotan a obat? ");
INSERT INTO xsb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ibalita ko komoyo, tampol nan ipaglaban a katoynongan la. Kot ha pa-mako kon oman iti ha lota, hiko a Naglalaman Tawo, main ako wari ma-lato a tawtawon ampasimala kongko?” ");
INSERT INTO xsb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hin ya-rin ay tinotol ni Jesus odtin alimbawa konlan tawtawon ampamitoring ha sarili la a lawlabah hilan tawo tan ampangmata-mata ha kapara la. ");
INSERT INTO xsb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wani Jesus konla, “Main loway lalaki a nako ha timplo para domawat ha Dios. Yay a-sa ay kabilang ha pinakaistrikton gropon rilihyon a anha-wayan Pariseo tan yay a-sa ay ma-ni-non bowis a mahaol. ");
INSERT INTO xsb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Inomdong ya-rin a Pariseo ha bandan arapan, ta wanan indawat ha sarili na, ‘O Dios, ampaki-salamat ako komo ta ambo akon bilang konlan laloman tawtawo a mangaagom, ambo maptog, ma-mabayi o kari mahaol bilang konan ya-rin a ma-ni-non bowis. ");
INSERT INTO xsb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Milwa ha manglinggo kon ampagsakripisyon kay mangan tan an-ibi ko ot komo yay ikamapolo ha halban kon angka-kitan,’ wana. ");
INSERT INTO xsb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kot yay ma-ni-non bowis ay inomdong bongat ha bandan bokotan tan kay na magawa tomangal nin omarap konan Dios, nokay nangangga antapikon na tanay kolop na ha main nan pa-ngombabali, bi-sa wanan indawat, ‘O Dios, inga-rowan mo ko ta a-sa kon makasalanan:’ ");
INSERT INTO xsb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ibalita ko komoyo,” wani Jesus, “yadtin ma-ni-non bowis ay norong ha bali na nin pinatawad, kot yay Pariseo ay kay pinatawad. Nga-min, hinoman a ampamita-gay nin sarili na ay iaypa na yan Dios, kot yay tawon ampagmaaypa ay ita-gay na ya.” ");
INSERT INTO xsb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hawanin, main anamaot tawtawon nangawit nin mangakalog a awa-nak koni Jesus, para aptohon na hila ta bindisyonan. Hin na-kit ladti nin dawdisipolos ni Jesus ay hinaar lay tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kot pinadani ni Jesus hilay aw-awa-nak kona, bi-sa wana konlan dawdisipolos na, “Po-layan moyo hilan domani kongkoy aw-awa-nak. Ando moyo hila haaron, ta hilay tawtawon main pa-masimala ha Dios a bilang konla ay kabilang ha ampag-arian na. ");
INSERT INTO xsb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yay potog, ibalita ko komoyo, hinoman a kay mananggap ha pa-mag-ari nan Dios nin bilang ha pa-nanggap lan makalog a anak ay kay maka-paki-lamo ha tawtawon ampag-arian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ninghan, main a-say lalakin main katongkolan a dinomani koni Jesus ta namastang, wana, “Labah a Maistro, anyay kailangan kon gaw-on pigaw magkamain akon biyay a homin anggawan?” ");
INSERT INTO xsb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wani Jesus kona, “Anongkot hina-wayan mo kon labah? Homin laloman labah no ambo yay Dios bongat. ");
INSERT INTO xsb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tanda moy kawkasogoan nan Dios: Ando ka mamabayi; ando ka mangmatin tawo; ando ka maniba; ando ka tomistigo nin kagalotoyan; igalang moy tatay tan nanay mo.” ");
INSERT INTO xsb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kot wanan lalakin main katongkolan, “Ya-rin halban ay anhonolon koy na paibat hin anak ako.” ");
INSERT INTO xsb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pa-makalngo ni Jesus, wana kona, “A-say bagay a kolang ot komo. Ilako moy halban kawkama-main mo ta ipapto moy na-paglakoan konlan mawmairap pigaw magkamain kan kayamanan ha langit. Bi-sa magbolta ka ta homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kot hin nalngo nadti, nilomolo ya bana ta masyado yan mayaman. ");
INSERT INTO xsb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hin na-kit ni Jesus a masyado yan nilomolo, wana, “Hay irap pay na ha tawtawon mangayaman nin pahakop ha pa-mag-ari nan Dios! ");
INSERT INTO xsb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nga-min, maganoh ot ha a-say kamilyo nin homlot ha lobot karayom, dinan yay a-say mayaman a pahakop ha pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wanlan hilay nakalngo, “Hino man no-nin a maari malipyas?” ");
INSERT INTO xsb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Wani Jesus, “Yay kay magawa nin tawo ay magawa nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bi-sa wani Pedro, “Hapa hikami? Imbati mi halban ta anhomonol kami na komo.” ");
INSERT INTO xsb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wani Jesus konla, “Yay potog, ibalita ko komoyo, hinoman a mamibati nin main nan bali o mawmatoantawo o tawtalakaka o kaambali o aw-awa-nak alang-alang ha pa-mag-ari nan Dios ");
INSERT INTO xsb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ay makatanggap yay na hawanin ot a panaon nin mas holok ha imbati na, bi-sa ha dobali biyay ay matanggap nay biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hawanin, impa-lilih ni Jesus hilay labinloway apostolis na konlan tawtawo, ta wana konla, “Tandaan moyodti: Yadtin pa-mako tamo ha Jerusalem ay mangyari na itaw a halban sawsinolat lan pawpropita nan Dios tongkol kongko a Naglalaman Tawo. ");
INSERT INTO xsb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nga-min, iintriga la ko konlan ambo Israelita ta toya-toyaon la ko, iinsoltowon tan lora-loraan. ");
INSERT INTO xsb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Latigowon la ko ot ba-yo patyon. Kot ha ikatlon awlo ay morong akon mabyay.” ");
INSERT INTO xsb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kot homin hilan naintindyan a aw-apostolis ni Jesus ha imbalita na ta bilang na-porongan a main lan kawkaisipan, kanya kay la naintindyan a labay nan totolon. ");
INSERT INTO xsb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hin madani hilay na ni Jesus ha babalin Jerico, main itaw a-say lalakin bolag a antoklo ha liglig kalsada ta ampakilimoh. ");
INSERT INTO xsb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hin nalngo na a main malabong a tawtawon anlomabah, pinastang na no anyay ampangyari. ");
INSERT INTO xsb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wanla kona, “Anlomabah hi Jesus a taga Nazaret.” ");
INSERT INTO xsb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kanya hinoma-way ya, wana, “Jesus, lipi ni Ari David, inga-rowan mo ko!” ");
INSERT INTO xsb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kot hiladtaw tawtawon ampo-na koni Jesus ay hinaar la ya pigaw mamakatinok ya. Kot lalo yay na ingat inomaghaw, wana, “Lipi ni Ari David, inga-rowan mo ko!” ");
INSERT INTO xsb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tinomgon hi Jesus ta imbalita na a awiton yay bolag kona. Hin madani yay na, wani Jesus kona, ");
INSERT INTO xsb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anyay labay mon gaw-on ko para komo?” Wana, “Maistro, labay ko komon maka-kit.” ");
INSERT INTO xsb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kanya wani Jesus kona, “Iya, maka-kit kay na. Inomabig ka bana ha main mon katotpol.” ");
INSERT INTO xsb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Antimano naka-kit yay naor, bi-sa hinomonol ya koni Jesus nin amporiwon nay Dios. Halban lan tawtawo itaw a nakaimaton ha nangyari ay namori hilay namaot ha Dios. ");
INSERT INTO xsb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bi-sa nilomoob hilay na ni Jesus ha babalin Jerico ta nagpa-wan itaw. ");
INSERT INTO xsb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Main itaw a-say lalakin yay ngalan kot Zaqueo. A-sa yan poon lan ma-ni-non bowis tan mayaman. ");
INSERT INTO xsb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ampag-inakit yan ma-kit na hi Jesus pigaw ma-bilbi na ya, kot ha kalakan tawtawo ay kay na ya ma-kit, palibhasay pandak ya. ");
INSERT INTO xsb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanya yay ginwa na ay nolayo ya pigaw o-nawan nay tawtawo. Bi-sa noli ya ha a-say poon kayo a anha-wayan sikomoro pigaw ma-kit na hi Jesus ta itaw ya lomabah. ");
INSERT INTO xsb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hin nipatobon hi Jesus itaw ha kamainan ni Zaqueo, tinomangal ya. Bi-sa wana kona, “Zaqueo, omaypa kay na. Maparah ta kailangan makihanda ako hawanin ha bali mo!” ");
INSERT INTO xsb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nangapora yay naor inomaypa hi Zaqueo, ta bi-sa hay kaligawan nan tinanggap hi Jesus ha bali na. ");
INSERT INTO xsb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kot hiladtaw a tawtawon nakaimaton ay biig ni-panalamorom, ta wanla, “Sokat nako yan nakihanda ha bali nin a-say makasalanan.” ");
INSERT INTO xsb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Hin ya-rin ay inomdong hi Zaqueo, ta wana konan Katawan, “Katawan, yay kapikna nin kama-main ko ay ibi ko konlan mangairap. Bi-sa yay hinoman a hinaol ko ay iorong koy hinaol ko kona nin mi-pat a bisis.” ");
INSERT INTO xsb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Wani Jesus kona, “Hawanin awlo, yay kalipyasan ay niabot ana konan yadtin bali, lalo lipi yay namaot ni Abraham odtin tawo. ");
INSERT INTO xsb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nga-min, hiko a Naglalaman Tawo ay nako iti ha babon lota para tingkapon tan ilipyas a tawtawon nitalon ta dinomayô hila ha Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pa-makayari, nanotol ya ot hi Jesus nin a-say alimbawa konlan hilay nanglongo ha o-nan imbalita na. Ginwa nadti bana ta madani yay nan makalato ha syodad Jerusalem, tan hay wanlan tawtawo no tampol lay nan ma-kit a pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kanya wani Jesus konla, “Main a-say lalakin main ingkatawo a nako ha a-say madayo a nasyon, para tanggapon na itaw a karapatan nan mag-ari ta bi-sa yay na morong. ");
INSERT INTO xsb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kot ba-yo ya inomalih, hina-wayan nay mapolo konlan aw-alila na. Binatian na hilan hiyo-san kwartan balitok, bi-sa wanan imbibilin konla, ‘Inigosyo moyo-rin anggan makalato ako.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kot hilay ka-nasyon nin yadtin lalaki a main ingkatawo ay antiplonon la ya. Kanya pa-makaalih na ay namihogo hila itaw ha tawon mami kona nin karapatan nin mag-ari, para ibalita a kay la labay a hiyay mag-ari konla. ");
INSERT INTO xsb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Anodtaw pa man, natanggap na syimpri a karapatan nan mag-ari. “Kanya hin norong ya, yay o-nan ginwa na ay impaha-wayan na hilay halban aw-alila na a binatian nan kwarta, para pastangon no omnoy tinobo la ha pa-magnigosyo la. ");
INSERT INTO xsb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wanan o-nan nakalato, ‘Sinyor, yay kwarta mon balitok ay tinomobo nin mapolo a kwartan balitok.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wanan ari, ‘Maganday ginwa mo. Labah kan alila. Bana ta na-pasimalaan ka ha daoto a alaga, biyan katan kapangyarian mamoon ha mapolo a babali.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dinomani yay namaot a ikalwa, ta wana, ‘Sinyor, yay kwarta mon balitok ay tinomobo nin limay kwartan balitok.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wanay namaot ari kona, ‘Hika man ay gaw-on koy namaot ma-moon ha limay babali.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bi-sa main a-sa ot a nakalato, a wana, ‘Sinyor, oyay kwarta mon balitok. Pinotot kon panyo ta inharya. ");
INSERT INTO xsb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nga-min, angkali-mo ko komo bana ta mahigpit ka. Ampangwa ka nin ambo hikay nagpagal tan ampangapas ka nin ambo hikay nangmola.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wanan ari kona, ‘Doka kan alila! Parosawan kata ayon ha bino-kanan mon halita. Ha tanda mo, mahigpit ako, ta wamo ampangwa ko nin ambo hikoy nagpagal tan ampangapas nin ambo hikoy nangmola. ");
INSERT INTO xsb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Anongkot man no-nin ta kay mo imbangkoy kwarta ko, ta pigaw komon pa-makalato ko ay makwa kon main tobo?’ ");
INSERT INTO xsb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hawanin, wanan ari konlan tawtawo itaw, ‘Kowon moyoy kwartan balitok kona ta ibi moyo konan yay main mapolo a kwartan balitok.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kot wanlan tawtawo kona, ‘Sinyor, anta main yay nan mapolo a kwartan balitok.’ ");
INSERT INTO xsb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kot wanay namaot ari, ‘Ibalita ko komoyo, yay tawon maronong magdisposisyon ha anyakaman a impa-taya kona ay lalon pa-lahan a main kona, balo ta yay tawon ambo maronong magdisposisyon ha impa-taya kona ay balawion orin kona. ");
INSERT INTO xsb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hilay namaot a tawtawon angkomontra kongko a kay labay mag-in la kon ari, awiton moyo hila iti ta patyon hila ha arapan ko.’” ");
INSERT INTO xsb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pa-makayari nan tinotol ni Jesus ya-rin a alimbawa ay nagpatoloy hilay nan hinomaka makon syodad Jerusalem nin iti ya ha o-nawan hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hin niabot hilay na ni Jesus ha pibotlayan nin loway baryo a Betfage tan Betania a parihon iti ha liglig nin Bakil Olibo, namihogo yan loway disipolos na. ");
INSERT INTO xsb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wana, “Domiritso kamo konan ya-rin ka-tobon a baryo. Pa-makalato moyo itaw, ma-kit moyoy a-say kilaw asno a nakatakol a kay ot pinagkabayowan nin maskin hinoman. Orkalan moyo ta awiton iti. ");
INSERT INTO xsb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No main mamastang komoyo no anongkot an-orkalan moyo-rin, ibalita moyo, ‘Kailangan nan Katawan.’” ");
INSERT INTO xsb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kanya nako hilay nay loway disipolos na ta bi-sa na-kit lay naor yay kilaw asno nin bilang ha imbalita ni Jesus konla. ");
INSERT INTO xsb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hin ya-rin a an-orkalan lay nay kilaw asno, pinastang hila nin hilay main ikon, wanla, “Anongkot an-orkalan moyo-rin?” ");
INSERT INTO xsb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wanlan loway disipolos, “Kailangan nan Katawan.” ");
INSERT INTO xsb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bi-sa inawit lay nay kilaw asno koni Jesus. Ba-yo insapin lay aw-alimonmon la konan kilaw asno ta bi-sa la ya pinalolan hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hin nagpatoloy yay nan makon Jerusalem, in-apin lay namaot nin tawtawo a aw-alimonmon la ha dalanan na. ");
INSERT INTO xsb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hin madani hilay na ni Jesus ha Jerusalem ta anlomoyhon hilay na ha Bakil Olibo, nalilikot hilay dawdisipolos na a kalakan, kanya inho-holyak lay pamomori la konan Dios bana ha halban mawmilagro a gi-ginwa na a na-kit la. ");
INSERT INTO xsb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wanla, “Poriwon yay Ari a ampakalato ha ngalan nan Katawan! Main katinokan itaw ha langit. Dayawon yay Katawan ha sangkalangitan!” ");
INSERT INTO xsb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Main anamaot paw-Pariseo a kalamo lan malabong a tawo itaw a nanita koni Jesus, wanla, “Maistro, haaron mo hila pay dawdisipolos mo.” ");
INSERT INTO xsb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kot wanan in-obat ni Jesus, “Ibalita ko komoyo, no wari ta mamakatinok hila, hiladti mismoy bawbato a miho-holyak nin mamori kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hin madani hilay na ni Jesus ha Jerusalem ta angka-tamolaw nay na yay syodad, tinangihan nadti. ");
INSERT INTO xsb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Bi-sa wana, “Sayang, hikamoy tawtawon ampi-wan ison, no tanda moyon bongat komon, maski tana komon hawanin konan yadtin hoyot a awlo, no anyay makapami komoyo nin kaliswayan nakom! Kot anggan hawanin ay angka-porongan ot a main moyon kaisipan. ");
INSERT INTO xsb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka-ka-ro kamo, ta lomato a panaon a ma-palibolan kamon kawkota nin kawkaaway moyo ta kobkobon la kamo ha halban diriksyon, para gipiton. ");
INSERT INTO xsb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bi-sa watak-watakon lay syodad moyo tan patyon la kamo pati hilay aw-awa-nak. Homin anan matla ison ni a-say bato a nakababo, palibhasay kay moyo tinanggap yay inhogo nan Dios komoyo.” ");
INSERT INTO xsb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pa-makalato la ni Jesus ha Jerusalem ay nako ya ha timplo. Pina-paalih na hilay ampi-paglako itaw nin maida-ton konan Dios tan hilay ampi-panaliw. ");
INSERT INTO xsb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wana konla, “Nakasolat ha Masanton Kasolatan a wanan Dios, ‘Yay bali ko ay balin panawatan,’ Kot anggaw-on moyon ‘pamaliwan nin mawmahiba.’” ");
INSERT INTO xsb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Paibat hin ya-rin ay awlo-awlo yan nangaral hi Jesus ha timplo. Kot hilay pawpoon pari, mawmaistron kapanogoan tan hilay pawpoon nin Israelita ay ampag-inakitan lan maipapati la ya. ");
INSERT INTO xsb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Balo ta kay homin hila ot magawa, bana ta halban tawo ay labay-labay lan manglongo ha hawhalita na. ");
INSERT INTO xsb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A-say awlo, hin antoroan ni Jesus hilay tawtawo itaw ha timplo ta an-ipangaral nay Labah a Balita, dinaniwan la yan pawpoon pari, mawmaistron kapanogoan, kalamo a pawpoon nin Israelita a pari-parihon myimbro nin pinakamata-gay a konsiho nin nasyon Israel. ");
INSERT INTO xsb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wanla kona, “Ibalita mo pa komi no anyay karapatan mo anongkot angga-gaw-on mo-rin halban, o hinoy nami nin karapatan komo?” ");
INSERT INTO xsb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wanan in-obat ni Jesus konla, “Main akoy namaot labay pastangon komoyo. Obaton moyodti: ");
INSERT INTO xsb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ayti naibat a karapatan ni Juan para mamaotismo, ha Dios doman o ha tawo?” ");
INSERT INTO xsb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nipapa-no hila yapon ha a-sa tan a-sa, wanla, “No halitaon tamon ibat ha Dios, sigoradon halitaon na kontamo, ‘Anongkot man no-nin ta kay moyo ya pini-pol?’ ");
INSERT INTO xsb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kot no halitaon tamoy namaot a naibat ha tawo, sigoradon patyon la tamon halban tawo nin batibaton bato, bana ta ampi-pol hila a yadtaw hi Juan ay propita nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanya, yay in-obat la tana ay “Kay mi tanda.” ");
INSERT INTO xsb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kanya wani Jesus konla, “Kay koy namaot no-nin ibalita komoyo no hinoy nami nin karapatan kongko para gomawa anodtin bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hin ya-rin ay tinotol ni Jesus konlan tawtawo yadtin alimbawa: “Main a-say lalaki a nangmolan golpin obas ha main nan lota. Bi-sa nangwa yan tawtawon mangasiwa konan yadtin obasan na, ba-yo nako ya ni-wan ha laloman logar ha loob nin maboyot a panaon. ");
INSERT INTO xsb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hin panaon anan pa-motin obas, namihogo yan a-say alila konlan ma-ngasiwa nin obasan na para kowon a parti na. Kot bino-bogbog la ya nin hilay ma-ngasiwa, bi-sa pinaorong la yan kay homin awit. ");
INSERT INTO xsb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kanya nanogo yay naman yadtin main ikon obasan nin a-sa ot a alila. Kot bino-bogbog la yay namaot, impa-paringoy tan pinaorong nin homin syimprin awit. ");
INSERT INTO xsb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hawanin, pamitlo nan nanogo nin a-sa ot a alila na, kot niri-rindi la ya syimpri bi-sa pinaalih ha obasan. ");
INSERT INTO xsb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bana ta anodtaw, wana nin main ikon obasan, ‘Anya kari a gaw-on ko? A, ihogo koy anlabyon kon anak. Sigoradon igalang la ya.’ ");
INSERT INTO xsb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kot hin na-kit lan mawma-ngasiwa a anak na, wanla ha a-sa tan a-sa, ‘Ya-rin yay manawil. Patyon tamo ya pigaw maipag-ikon tamoy tatawilon na.’ ");
INSERT INTO xsb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kanya yay ginwa la ay inlikol la ya ha obasan ta pinati. “Hawanin,” wanan impagpatoloy ni Jesus, “anya man wari a gaw-on nan main ikon obasan konlan hila-rin mawma-ngasiwa? ");
INSERT INTO xsb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hiyay na mismo a mako itaw ta pa-patyon na hila-rin a mawma-ngasiwa, bi-sa ipa-taya nay obasan na ha laloma.” Hin naintindyan lan tawtawo no hinoy antokoyon konlan hila-rin a parosawan, wanla, “Ando komon mangyari!” ");
INSERT INTO xsb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kot hinilap na hila ni Jesus, bi-sa wana, “Anya man no-nin a labay nan totolon nin yadtin wana ha Masanton Kasolatan: ‘Yay bato a impoyra lan karpintiro Ay yadtaw mismo a ginwa pinakapondasyon nin bali.’ ");
INSERT INTO xsb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hinoman a madabo konan yadtin pa-hal bato ay mangababalian tan hinoman a ma-bondagan nan yadti ay madonot.” ");
INSERT INTO xsb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hawanin, ya-rin ot a oras ay labay la yay na komon dakpon hi Jesus nin hilay pawpoon pari tan mawmaistron kapanogoan, ta naintindyan la a hilay antokoyon na ha inimbi nan alimbawa, kot angkali-mo hila ha tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanya minanmanan la ya. Namihogo hilan omnoy tawon magkonwari a hila kot mahonol ha kawkapanogoan nan Dios para pastangon la ya, ta hapa no makahalita yan maari lan maikaso kona, ta pigaw maiintriga la yay na ha gamot tan kapangyarian nan gobirnador. ");
INSERT INTO xsb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanya pinastang la hi Jesus, wanla, “Maistro, tanda mi a yay an-ibalita tan an-itoro mo ay biig tawtama. Homin kan angkilingan, nokay potog yay an-itoro mon kalabayan nan Dios para ha tawo. ");
INSERT INTO xsb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hawanin, labay min ma-tandaan no marapat doman ayon ha kawkapanogoan nan Dios kontamon Israelita a mamayar nin bowis konan ari ha Roma a main hakop kontamo.” ");
INSERT INTO xsb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kot tanda ni Jesus a doka a sadya la, kanya wana konla, “Anongkot labay moyo kon hobokon? ");
INSERT INTO xsb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Pa-kitan la kon a-say kwartan pilak.” Pa-makatorol la, wana, “Hino man lopa tan ngalan yadti iti?” Wanla, “Yay ari ha Roma.” ");
INSERT INTO xsb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wani Jesus konla, “Intonsis, ibi moyo no-nin konan ari ha Roma yay ikon na, tan anorin anamaot kapara, ibi moyoy namaot konan Dios yay ikon na.” ");
INSERT INTO xsb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kay homin hilan na-dakop a maibara la kona ha pa-nalita na ha arapan lan tawtawo. Masbali namakatinok hila bana ta naka-ngap hila ha obat na, ta yay hinalita na ay ambo kontra konan ari tan ambo anamaot kontra konan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Main anamaot omnoy Saduseo a nako koni Jesus. Hiladti yay gropon kay ampi-pol a main pa-morong mabyay. Pinastang la yay namaot hi Jesus, ");
INSERT INTO xsb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","wanla, “Maistro, yay sinolat ni Moises a kapanogoan nan Dios kontamo ay ‘No nati yay a-say lalakin main kaambali nin homin hilan anak, kailangan yay talakaka nan yadtin nati ay ipagkaambali nay nabalon ayro na ta pigaw maibalô nan magkamain anak yay talakaka na a nati.’ ");
INSERT INTO xsb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hin yadtaw, main pitoy mita-talakakan lawlalaki. Nagkaambali yay kalingkakaan, kot nati yan homin hilan anak. ");
INSERT INTO xsb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kanya yay homonol a talakaka na a nagkaambali konan balo, kot nati yay namaot nin kay hila nagkamain anak. ");
INSERT INTO xsb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bi-sa, impagkaambali na ya nin yay ikatlo, kot anorin syimpri a nangyari, anggan halban lan pitoy mita-talakaka ay naipagkaambali la ya, kot pari-pariho hilan nati nin kay nagkamain anak. ");
INSERT INTO xsb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hin hoyot, nati yay namaot a babayi. ");
INSERT INTO xsb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hawanin, no wari ta main pa-morong mabyay, hino man no-nin konla a makapag-ikon konan yadtaw babayi bilang kaambali na painsan? Nga-min, pari-pariho la yan impagkaambali nin hilay pito.” ");
INSERT INTO xsb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Wani Jesus konla, “Lo-gan iti ot ha babon lota, yay tawtawo ay ampagkaambali o an-ipaambali. ");
INSERT INTO xsb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kot hilay lawlalaki tan bawbabayi a intoring nan Dios marapat morong mabyay para ha dobali biyay ay kay hilay na magkaambali. ");
INSERT INTO xsb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nga-min, kay hilay na mati ta bilang hilay nan aw-anghil tan aw-awa-nak na hilay nan Dios, palibhasay pinaorong na hilan mabyay. ");
INSERT INTO xsb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Main pa-morong mabyay hilay ni-kati ta maskin hi Moises ay pinaptogan nadti ha hinalita na itaw ha parti nin Masanton Kasolatan tongkol ha maaypa a poon kayon andorta. Hina-wayan na yay Katawan itaw nin ‘Dios ni Abraham, Dios ni Isaac tan Dios ni Jacob.’ ");
INSERT INTO xsb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kot ambo yan Dios nin tawtawon nati, nokay Dios ya nin tawtawon angkabyay, labay totolon, an-itoring nan angkabyay hiladtin tolo. Nga-min, halban tawtawon tinompol ay an-itoring nan Dios angkabyay.” ");
INSERT INTO xsb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wanlan laloman mawmaistron kapanogoan hin ya-rin, “Maistro, labah a obat mo.” ");
INSERT INTO xsb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pa-makayari yadti ay homin anan nagkohaw nakom nin namastang ot koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hin ya-rin ay pinastang na hilay namaot ni Jesus, wana, “Anyay wamoyo konan yadti: An-itoro la a yay Cristo kot lipi ni Ari David. ");
INSERT INTO xsb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kot ambo doman wani Ari David, itaw ha Libron Kawkanta ha Masanton Kasolatan: ‘Wanan Dios a Katawan koni Cristo a Katawan ko: Iti ka tomoklo ha wanan ko, ");
INSERT INTO xsb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta ta-ganan mon igwa ko ha aypa kapangyarian mo hilay kawkontra komo.’” ");
INSERT INTO xsb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wanan impagpatoloy ni Jesus, “Iti ay hina-wayan ni Ari David yay Cristo nin ‘Katawan’. Anyay ma-halita moyo: Pa-no maari a Katawan na ya ta bi-sa lipi na ya ot?” ");
INSERT INTO xsb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hin ya-rin, wani Jesus konlan dawdisipolos na nin angkalngo lan halban tawtawo, ");
INSERT INTO xsb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-ingat kamo konlan mawmaistron kapanogoan a mangailig mipa-pasyal nin nakadoloh mawmaanloh, tan labay-labay lan asikasowon hila ha pawplasa. Bi-sa mangailig hila syimprin tomoklo ha ambo basta-bastan totokloan ha sawsinagoga tan ha kawkabisira ot no main hawhandaan. ");
INSERT INTO xsb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Antaktikawon lay bawbabayi a balo anggan ma-min lay kama-main la pati bali la, balo ta anhakban ladti ha paralan nin kada-dawat lan mawmaanloh pigaw kay hila ma-halata. Kanya mas mabyat ana ingat a parosa konla.” ");
INSERT INTO xsb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hin hinomilap hi Jesus, na-kit na hilay mangayaman a ampangdabo kwarta itaw ha ampamidaboan kwarta ha timplo. ");
INSERT INTO xsb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bi-sa na-kit nay namaot a a-say pobrin babayin balo a namidabo nin loway sintimos. ");
INSERT INTO xsb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wani Jesus, “Yay potog, ibalita ko komoyo, yadtaw indabo nan pobrin babayin balo ay mas holok ha inimbi lan halban. ");
INSERT INTO xsb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nga-min, sawsobra lan bongat a indabo la ha dawda-ton para konan Dios, kot yay balo, maskin mairap ya, inimbi na ot a ka-siya-siya nan ipagkabyay.” ");
INSERT INTO xsb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Main omnoy disipolos ni Jesus a ampitototol tongkol ha timplo, ha kagandawan ginamit a bawbato ha pamama-dong tan laloma ot a impagdikorasyon ison a inimbi lan tawtawo. Wani Jesus konla, ");
INSERT INTO xsb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Lomato yay panaon, ya-rin halban angka-kit moyo ay watakon, kanya homin anan ma-bati ison ni a-say bato a nakababo ha laloman bato.” ");
INSERT INTO xsb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pinastang la hi Jesus nin hilay dawdisipolos na, wanla, “Maistro, maka-no man mangyari yadtaw imbalita mon watakon yay timplo, tan anyay pamilbian no madani nan mangyari?” ");
INSERT INTO xsb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Inobat na hila ni Jesus kot binibilinan na hila yapon, wana, “Mag-ingat kamo pigaw kay kamo mailingo. Nga-min, lako a mako komoyo a mangamit ngalan ko, ta ibalita lan hila yay Cristo, o kari wanla, ‘Lomato anay panganggawan nin babon lota.’ Balo ta ando kamo homonol konla. ");
INSERT INTO xsb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No main kamon ma-balitaan gawgira tan kawkagolowan, ando kamo mahalak, ta kailangan mangyari yapon orin. Balo ta kay ot antimano manganggawan yay babon lota.” ");
INSERT INTO xsb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bi-sa wana konla, “Milalaban a nangasasari a nawnasyon tan kawkaarian. ");
INSERT INTO xsb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Magkamain mangakhaw a layon tan bawbitil tan aw-ipidimya ha nangasasari a lawlogar. Magkamain kawka-pali-mo tan kawka-paka-ngap a pawpangyayari a mi-ka-kit ha langit. ");
INSERT INTO xsb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Balo ta ba-yo mangyari orin halban, dakpon la kamo tan da-damsakon. Bi-sa awiton la kamo ha sawsinagoga para imbistigawon ta bi-sa ipapriso. Iarap la kamo ot ha aw-ari tan laloma ot a pawpoon bana ha katotpol moyo kongko. ");
INSERT INTO xsb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kot mag-in oportonidad moyo-rin para maiabot konlay kaptogan tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kanya asa-sawon moyoy nakom moyo a ando moyo pag-isip-isipan anan daan no anyay iobat moyon pa-magdipinsa ha main moyon sarili, ");
INSERT INTO xsb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ta biyan katamon karonongan tan kababaan manalita a kay mababa kontrawon o halongaon nin hinoman a angkomontra komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Maski mismon mawmatoantawo moyo, tawtalakaka, kawkanayon o aw-amigo a kay antompol ay pagtraidoran la kamo, bi-sa yay laloma komoyo ay ipapati la. ");
INSERT INTO xsb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tiplonon la kamon halban tawtawon kay antompol bana ha katotpol moyo kongko. ");
INSERT INTO xsb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Anodtaw pa man, ni a-say habot ha olo moyo ay kay maba-wah no kay ko aboloyan. ");
INSERT INTO xsb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kanya mag-agwanta kamo ta matanggap moyoy biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wana ot ni Jesus, “No ma-kit moyoy nan na-palibolan nin kawkaaway moyon hondalo yay syodad Jerusalem, tandaan moyo ta madani yay nan hiraon. ");
INSERT INTO xsb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","No anorin ana, hinoman a iti ha probinsyan Judea ay kailangan tampol molayon omari ha bakil. Hiladtaw anamaot a iti ha loob nin syodad Jerusalem ay dapat omalih ana, tan hiladtaw a iti ha likol nin syodad ay ando ana lomoob. ");
INSERT INTO xsb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nga-min, ya-rin anay panaon a parosawan nan Dios hilay aw-Israelita. Ha anorin, ma-paptogan a halban nakasolat ha Masanton Kasolatan ay talagan mangyari. ");
INSERT INTO xsb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka-ka-ro hilay ma-palatan malombit o ampamasoso konan ya-rin a panaon! Nga-min, magkamain nin grabin kawkadya-dyaan konan yadtin logar, ta ipa-kit nan Dios a matindin hobhob na konan yadtin nasyon Israel. ");
INSERT INTO xsb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Main konla a patyon ha ispada tan main anamaot bihagon ta i-ka ha nangasasari a nawnasyon. Bi-sa yay syodad Jerusalem ay hakopon lan hilay ambo Israelita anggan ha panaon a intakda nan Dios a manganggawan anay panaon la.” ");
INSERT INTO xsb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Wana ot ni Jesus, “No madani nay pa-mako kon oman iti ay magkamain nin kawka-paispantan pamilbian ha awlo, bolan tan bawbitoon. Bi-sa iti namaot ha babon lota ay mi-kahalak a tawtawo ha nangasasari a nawnasyon, tan kay la tanda a ga-gaw-on la ha kakhawan aw-ogong nin alon ha ambay. ");
INSERT INTO xsb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Maskin lawlalaki ay maalihan malay ha kali-mowan tan ha pangingisip tongkol ha mangyari ha babon lota, ta yay pawplanita tan lawlaloma ot ison ha ta-gay ay mi-kayogyog pangibatan maalih hila ha andalanan la. ");
INSERT INTO xsb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bi-sa hiko a Naglalaman Tawo ay ma-kit lan amponaoy nin iti ha lolom nin main awit kapangyarian tan ambo bastan karangalan. ");
INSERT INTO xsb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","No mag-ompisay nan mangyari odtin bawbagay, pakhawon moyoy nakom moyo tan gomalahgah, ta madani kamoy nan ilipyas nin Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bi-sa tinotol ni Jesus konlay a-say alimbawa, “Bilyon moyoy poon igos tan halban laloman kawkayo. ");
INSERT INTO xsb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","No ma-kit moyoy nan ampama-yon bolong, tanda moyo a madani nay panaon abagat. ");
INSERT INTO xsb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Anorin anamaot kapara, no ma-kit moyon ampangyari nadtin bawbagay a impatandaan ko ay ma-tandaan moyo a madani nay pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yay potog, ibalita ko komoyo, ha tawtawon angkabyay hawanin panaon ay main ot angkabyay anggan kay mangyari yadtin halban bawbagay. ");
INSERT INTO xsb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Manganggawan a langit tan lota, balo ta yay hawhalita ko ay homin pa-ngapaso.” ");
INSERT INTO xsb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wana ot imbibilin ni Jesus konla, “Mag-ingat kamo nin kay maliwa ha bawbagay a makamondo a bilang ha sobran pa-mangan, ha pa-maglahing tan ha pangingisip tongkol ha kawkailangan nin yadtin biyay, ta pigaw kay katamo ma-lato nin ambo handa ha awlon ilato ko. ");
INSERT INTO xsb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nga-min, ma-biglaan hilay halban tawtawo ha intiron mondo ha awlon ilato ko a bilang ha la-wan a bigla manga-lot. ");
INSERT INTO xsb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kanya kailangan pirmi kamon handa tan domawat pigaw mag-in kamon marapat malipyas konan ya-rin halban mi-pangyari tan pigaw maka-pakiarap kamo kongko, hiko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Awlo-awlo yan ampangaral hi Jesus itaw ha timplo. Bi-sa no anyomabi na, anlomikol ya ha syodad ta itaw ya ampamalabah yabi ha Bakil Olibo. ");
INSERT INTO xsb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kapi-piboklah ot ay ampako hilay nay tawtawo ha timplo para manglongo kona. ");
INSERT INTO xsb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hin ya-rin ay madani nay Pistan Pa-makalibri nin Israelita. Ya-rin ay ompisan manglinggon pista a yay dapat kanon kot tinapay a homin pampalbag. ");
INSERT INTO xsb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hin ya-rin, hilay pawpoon pari tan mawmaistron kapanogoan ay naningkap nin paralan no pa-no la maipapati hi Jesus ta angkali-mo hilan magkagoloy tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hin ya-rin anamaot ay pinango-nawan ni Satanas hi Judas a anha-wayan Iscariote a a-sa konlan labinloway disipolos ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Inomalih ya ta nako ya konlan pawpoon pari tan kawkapitan lan gawgwardya ha timplo ta impakipa-pa-no na no pa-no na maiintriga hi Jesus konla nin patraidor. ");
INSERT INTO xsb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nalilikot hila kanya nangako hilan biyan la yan kwarta. ");
INSERT INTO xsb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pinomayag hi Judas, kanya nana-gan yay nan tyimpo para ma-pagtraidoran na hi Jesus nin kay la ma-tawo nin kalabongan. ");
INSERT INTO xsb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hin ya-rin ay kaawlowan ana nin Pistan Pa-makalibri a o-nan awloy namaot nin manglinggon Pistan Tinapay a Homin Pampalbag. Konan ya-rin a awlo ay kailangan mangmatin karniro para pangaponan. ");
INSERT INTO xsb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kanya inhogo ni Jesus hi Pedro tan hi Juan, wana, “Mako kamo ta ihanda moyoy pa-mangan tamo para ha pista.” ");
INSERT INTO xsb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pastang la kona, “Ayti may labay mon pamihandaan mi?” ");
INSERT INTO xsb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wani Jesus konla, “Mako kamo ha syodad ta pa-makaloob moyo ay main kamon ma-hakbat a-say lalakin main awit a-say banga nin lanom. Honolon moyo ya anggan ha balin looban na, ");
INSERT INTO xsb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ta ibalita moyo konan main ikon bali, ‘An-ipapastang nan Maistro no ayti kanoy logar a ma-pagsilibrawan na nin Pistan Pa-makalibri nin kalamo kamin dawdisipolos na.’ ");
INSERT INTO xsb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bi-sa ipa-kit na komoyoy a-say malawang a kwarto ha ta-gay a komplito ha gawgamit. Itaw moyo ihanda a pangaponan tamo.” ");
INSERT INTO xsb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nako hilay nay disipolos ha syodad Jerusalem, bi-sa anodtaw anaor a na-kit la a bilang ha hinalita ni Jesus konla. Kanya inhanda lay pangaponan lan pampista. ");
INSERT INTO xsb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hin oras anan pa-ngapon, dinomolog yay na hi Jesus ha lamisawan, kalamo na hilay labinloway apostolis na. ");
INSERT INTO xsb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hin ya-rin ay wani Jesus konla, “Talagan mahi-ban a nakom kon maipagkarongo katamo konan yadtin pa-ngapon pampistan Pa-makalibri ba-yo ko domalan ha pa-magdya-dya. ");
INSERT INTO xsb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ibalita ko komoyo: Kay koy na mangan oman ha Pistan Pa-makalibri anggan maganap ana itaw ha kaarian nan Dios yay hoston pa-magsilibra.” ");
INSERT INTO xsb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hin ya-rin ay nangwa yan a-say kopa ta pinasalamatan na yay Dios, bi-sa wana konlan aw-apostolis na, “Kowon moyodti ta pipipiknaan moyon inomon. ");
INSERT INTO xsb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ibalita ko komoyo, paibat hawanin ay kay koy na minom oman nin anodtin inomon a ibat ha obas anggan kay ot makalato a pa-mag-ari nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bi-sa nangwa yan tinapay ta pinasalamatan na yay Dios. Pa-makayari ay pini-pikna na bi-sa intorol na konlan aw-apostolis na, ta wana, “Yadti a lalaman kon ibi para komoyo. Anodti patoloy moyon gaw-on bilang pa-manomtom kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Anorin kapara, kinwa na yay kopa pa-makayari lan nangan pangaponan, ba-yo intorol na konla nin wana, “Yadti yay pamilbian nin ba-yon kasondoan nan Dios ha tawtawo bana ha daya kon tomolo para komoyo. ");
INSERT INTO xsb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Kot biliwon moyo, a-sa komoyon kalamo kon ampangan ay magtraidor kongko. ");
INSERT INTO xsb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hiko a Naglalaman Tawo ay mati ayon ha plano nan Dios, balo ta ka-ka-roy ogotan nin yay tawon magtraidor kongko!” ");
INSERT INTO xsb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tongwa, nipapastang hila ha a-sa tan a-sa no hino kari konlay magtraidor koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nanga-pididiskosyon hilay namaot a aw-apostolis no hino kari konlay maitoring pinakamata-gay. ");
INSERT INTO xsb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kot wani Jesus konla, “Hilay aw-ari iti ha mondo ay mabyat a pamomoon la konlan angkahakopan la, bi-sa balang main katongkolan ay labay lan bilbion hilan ma-mangwâ abig. ");
INSERT INTO xsb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kot ambo kamon dapat mag-in anorin, nokay masbali no hinoman komoyo a pinakamata-gay ha gropo moyo ay dapat mag-in yan pa-hal ali. Tan hinomay ampamoon komoyo ay dapat mag-in yan ma-magsirbi. ");
INSERT INTO xsb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hino kot a mas mata-gay, yay nakadolog ha lamisawan o yay ampagsirbi? Ambo doman yay nakadolog ha lamisawan? Kot hiko ay ampoma-hal ma-magsirbi moyo.” ");
INSERT INTO xsb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wana ot ni Jesus konlan aw-apostolis na, “Hikamo yay ampagpatoloy nin anhomonol kongko ha dobali nin pawpanonobok a andomalan kongko. ");
INSERT INTO xsb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kanya no pa-no a hiko kot binyan nan Ama nin karapatan para mag-ari ay anorin anamaot a gaw-on ko komoyo, ");
INSERT INTO xsb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ta maipagkarongo katamon mangan tan minom itaw ha lamisawan ha kaarian ko. Tan main kamon kanya-kanyan trono a tokloan para mamoon konlan labinloway lipi nin Israel.” ");
INSERT INTO xsb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Hin ya-rin, wani Jesus a Katawan koni Pedro, “Hika, Simon, long-on modti: Yay labay ni Satanas ay pairapan na kamo pigaw bokotan moyoy katotpol moyo. ");
INSERT INTO xsb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kot indawat katay na a kay ka disnodon ma-hominan katotpol. Kanya painsan, no nangombabali kay na ta binomalik kay na kongko, pakhawon moy nakom lan hilay impagka-talakaka mo.” ");
INSERT INTO xsb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wanan in-obat ni Pedro kona, “Katawan, handa akon mapriso tan matin kalamo ka.” ");
INSERT INTO xsb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kot wani Jesus, “Pedro, ibalita ko komo, ba-yo tomaran-ok a manok konan yadtin yabi ay mitloy bisis mon ibalita a ambo mo kon bilbi.” ");
INSERT INTO xsb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bi-sa wani Jesus konlan aw-apostolis na, “Hin inhogo katamon nangaral tan binawalan mangawit kwarta, bag tan risirban aw-apin ayi, nagkolang kamo wari nin pawpangangailangan?” “Kai,” wanlan in-obat. ");
INSERT INTO xsb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wana ot ni Jesus konla, “Hawanin balo, no main kamon kwarta, awiton moyoy na tan anorin kapara ha bag. Hinoman komoyo a homin bonong, maglako yay nan doloh na ta pigaw main yan maipanaliw. ");
INSERT INTO xsb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ibalita ko komoyo, dapat pomtog anadtin wana ha Masanton Kasolatan tongkol kongko, ‘Imbilang yan a-sa konlan mawmakasalanan.’ Yay bawbagay tongkol kongko a dapat mangyari ay halos mayari ana.” ");
INSERT INTO xsb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wanlan aw-apostolis na, “Katawan, oy a loway bonong.” Wani Jesus konla, “Tama ana-rin.” ");
INSERT INTO xsb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hin ya-rin ay inomalih hi Jesus ta nako ya ha Bakil Olibo a bilang ha kinaogalian nan gaw-on. Hila man a dawdisipolos na ay naki-ka anamaot kona. ");
INSERT INTO xsb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hin niabot hilay na itaw, wani Jesus konla, “Idawat moyo a kay kamo matokso.” ");
INSERT INTO xsb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bi-sa dinomayô ya konla nin bilang karayo a-say basyon bato, ba-yo nanalimokor yan dinomawat. ");
INSERT INTO xsb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Wana, “Ama, no labay mo, alihon mo komon yadtin an-arapon kon pa-magdya-dya. Kot anodtaw pa man, ambo yay kalabayan koy mangyari, nokay yay kalabayan mo.” ");
INSERT INTO xsb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tongwa, main anghil a naibat ha langit a nagpa-kit kona ta pinakhaw nay nakom na. ");
INSERT INTO xsb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hawanin, bana ta masyado yan angkairapan, lalo yan dinomawat hi Jesus. Bi-sa tinomolo a hayngot na ha lota a bilang mawmahi-ban a patak nin daya. ");
INSERT INTO xsb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pa-makayari nan dinomawat ay inomdong ya ta nagbolta konlan disipolos na, kot na-lato na hilan angka-lok bana ha kakapoyan, gawa nin sobran kaloloan. ");
INSERT INTO xsb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wani Jesus konla, “Anongkot angka-lok kamo? Mibangon kamo ta domawat pigaw kay kamo matokso.” ");
INSERT INTO xsb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hin ampanalita ya ot hi Jesus, lako a tawon nakalato a pinango-nawan ni Judas, a a-sa konlan labinloway apostolis ni Jesus. Dinomani ya koni Jesus ta inalokan na ya. ");
INSERT INTO xsb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kot wani Jesus kona, “Judas, ha alok mo ot an-iparalan a pa-magtraidor mo kongko, hiko a Naglalaman Tawo?” ");
INSERT INTO xsb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hin na-kit ladti nin kawkalamoan ni Jesus ta bi-sa naintindyan la no anyay mangyari, wanla kona, “Katawan, gamiton mi na doman a bawbonong mi?” ");
INSERT INTO xsb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tongwa, tinabtab nin a-sa konlan aw-apostolis ni Jesus a alila nan pinakapoon pari, kot yay wanan totolyan a natigpah na. ");
INSERT INTO xsb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kot wani Jesus, “Itgon mo-rin!” Bi-sa gina-gotan ni Jesus a totolyan nan alila ta pinaabig na. ");
INSERT INTO xsb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ba-yo wana konlan pawpoon pari, gawgwardya ha timplo tan hilay pawpoon nin Israelita a nako itaw para dakpon ya, “Tolisan ako doman ta nangawit kamo ot bawbonong tan pawpapatok? ");
INSERT INTO xsb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Awlo-awlo kon itaw ha timplo nin kalamo moyo kot kay moyo ko dinakop. Balo ta hawanin talagay panaon moyo tan angka-kit anay kapangyarian ni Satanas a ari nin karobloman.” ");
INSERT INTO xsb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinakop lay naor hi Jesus ta inawit la ya ha bali nan pinakapoon pari. Hi Pedro namaot ay mato-totombok konla nin main karayoan. ");
INSERT INTO xsb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hin main tawtawon namartan timbon ha botlay balaybay nan pinakapoon pari ta bi-sa ampalanglang hilay na itaw, naki-toklo hi Pedro konla. ");
INSERT INTO xsb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hin ya-rin ay na-kit na yan a-say babayin alila ta angka-hawangan a lopa na nin apoy. Pinaka-hilap na ya, ta wana, “Yadtin lalaki ay kalamoan nay namaot ni Jesus.” ");
INSERT INTO xsb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kot imbori nadti ni Pedro, a wana, “Babayi, ambo ko yan bilbi.” ");
INSERT INTO xsb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na-paongganan, na-sikaso yan a-say lalaki, wana, “A-sa kay namaot ha kawkalamoan na.” Kot wani Pedro, “Amigo, na-baloan mo ko!” ");
INSERT INTO xsb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pa-makalabah nin manga a-say oras, main anaman a-say tawo a wanan impilit, “Potog kalamoan na yadtin tawo ta taga yay namaot Galilea.” ");
INSERT INTO xsb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kot wanay naman ni Pedro, “Amigo, homin akon tanda ha an-ibalita mo.” Lo-gan ya ot ampanalita hi Pedro ay bigla tinomaran-ok a manok. ");
INSERT INTO xsb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hin ya-rin ay namalingay hi Jesus ta hinilap na hi Pedro. Hawanin, na-panomtoman ni Pedro yay hinalita nan Katawan, a wana kona, “Ba-yo tomaran-ok a manok konan yadtin yabi ay mitloy bisis mo kon iporlingor.” ");
INSERT INTO xsb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kanya nilomikol hi Pedro ta bi-sa tinomangih yan hosto. ");
INSERT INTO xsb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hiladtaw anamaot a ampaggwardya koni Jesus ay tinoya-toya la ya tan bino-bogbog. ");
INSERT INTO xsb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bi-sa pinorongan lay mata na ta tiniro-tiro lay lopa na, ba-yo wanlan impastang, “Holaan mo no hinoy naniro komo?” ");
INSERT INTO xsb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bi-sa kalakan ot hina-halita lan pa-noya-toya kona. ");
INSERT INTO xsb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kinadilapan, nititipon hilay pawpoon nin Israelita, pawpoon pari tan mawmaistron kapanogoan ta hila-rin yay pinakamata-gay a konsiho nin nasyon Israel. Bi-sa in-arap hi Jesus konla, ta wanla kona, ");
INSERT INTO xsb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ibalita mo pa komi no hika doman yay Cristo a impangako nan Dios?” Kot wani Jesus konla, “Maski man ibalita ko ay kay kamoy nan lamang mi-pol. ");
INSERT INTO xsb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","No pastangon katamoy namaot, kay moyo koy nan lamang obaton o bolohan. ");
INSERT INTO xsb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kot paibat hawanin, hiko a Naglalaman Tawo ay tomoklo ha wanan nan Dios a Makapangyayari.” ");
INSERT INTO xsb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hin ya-rin ay pinastang la yan halban, “Hika doman no-nin a Anak nan Dios?” Wani Jesus konla, “Hikamoy nay ampamibalita a hikoy naor.” ");
INSERT INTO xsb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bi-sa wanla, “Anya man ot magklasin pa-maptog a kailangan tamo? Hitamoy na mismo a nakalngo ha mismon boboy na.” ");
INSERT INTO xsb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hin ya-rin ay inomdong hilay halban mawmyimbro nin pinakamata-gay a konsiho, ta inawit la yan in-arap hi Jesus koni Gobirnador Pilato a taga Roma. ");
INSERT INTO xsb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bi-sa inompisawan la yay nan baraan hi Jesus, wanla, “Naimatonan midtin tawo a anhoghogan nay tawtawo nin komontra ha gobyirno tamo. An-ibawal nay pamamayar bowis konan ari ha Roma. An-ibalita na ot a hiya kano yay Cristo, a Ari a impangako nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kanya pinastang na ya ni Gobirnador Pilato, wana, “Hika doman a Ari lan Israelita?” Wanan in-obat ni Jesus, “Nahalita moy na.” ");
INSERT INTO xsb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hin ya-rin, wani Gobirnador Pilato konlan pawpoon pari tan konlan malabong a tawo itaw, “Homin akon angka-kit kasalanan konan yadtin tawo para sintinsyawan yan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kot lalo lan impilit a bawbara la, wanla, “Ha panonoro na ay anhoghogan nay tawtawo ha intiron probinsyan Judea nin komontra ha gobyirno. Nag-ompisa ya ha probinsyan Galilea, bi-sa hawanin iti yay na ha Jerusalem.” ");
INSERT INTO xsb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hin nalngo ni Gobirnador Pilato a binanggit lay “Galilea”, sinigorado na no talagan taga yan probinsyan Galilea hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kanya, hin na-tandaan na a taga yay naor Galilea a angka-hakopan ni Ari Herodes Antipas ay impapi-ka na ya koni Ari Herodes Antipas a hin ya-rin ay itaw anamaot ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maligan-maliga hi Ari Herodes Antipas hin na-kit na hi Jesus ta naboyot na yay nan labay ma-paki-kitan, bana ha kalakan nay nan na-nalngo tongkol kona. An-asahan nan gomwa yan milagro hi Jesus pigaw ma-kit na. ");
INSERT INTO xsb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kanya kalakan nan impa-pastang koni Jesus hin ya-rin, balo ta kay na ya inobat. ");
INSERT INTO xsb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Itaw hilay namaot a pawpoon pari tan mawmaistron kapanogoan nin an-omdong tan mahakit a bawbara la koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hi Ari Herodes Antipas tan hilay hawhondalo na ay iniinsolto tan tinoya-toya la hi Jesus. Ba-yo pinaholotan la yan bilang doloh ari ta bisa impapiorong la ya koni Gobirnador Pilato. ");
INSERT INTO xsb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Konan ya-rin awlo, hi Gobirnador Pilato tan hi Ari Herodes Antipas a datin mi-kontra ay na-piamigo. ");
INSERT INTO xsb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hawanin, impaha-wayan ni Gobirnador Pilato hilay pawpoon pari, hilay main katongkolan tan hilay laloman tawtawo, ");
INSERT INTO xsb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ta wana konla, “Inawit moyodtin lalaki kongko ta an-iriklamo moyo a anhoghogan nay tawtawo para komontra ha gobyirno. Kot ha pa-ngimbistiga ko kona ha arapan moyo, na-kit ko a ha halban an-ibara moyo kona ay homin ni a-say bagay a potog. ");
INSERT INTO xsb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Maski hi Ari Herodes Antipas ay homin ya syimprin na-kit a kasalanan na, ta pina-ka katamoy naor kona. Mapatnag a homin yan nagawa odtin tawo a dapat yan sintinsyawan kamatyan. ");
INSERT INTO xsb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kanya ipagaroti ko ya tana bi-sa yay na bolohan.” ");
INSERT INTO xsb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Anorin a imbalita ni Gobirnador Pilato, palibhasay nakaogalian a dapat yan mamiboloh nin a-say priso kada Pistan Pa-makalibri. ");
INSERT INTO xsb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kot sabay-sabay hilan inomaghaw a kalabongan, wanla, “Patyon yadtin tawo! Hi Barabbas a bolohan!” ");
INSERT INTO xsb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Napriso yadti hi Barabbas bana ta kalamo ya ha nilomaban ha gobyirno ha syodad Jerusalem tan nangmati yan tawo hin ya-rin.) ");
INSERT INTO xsb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hawanin, ha apos ni Gobirnador Pilato nin bolohan hi Jesus ay naki-totol yan oman konla. ");
INSERT INTO xsb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kot inomaghaw hilay naman, wanla, “Ipasak ya ha kros! Ipasak ya ha kros!” ");
INSERT INTO xsb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hin ikatlon bisis na hilan kina-totol ni Gobirnador Pilato, wana konla, “Anongkot, anya kot a nagawa nan karokaan? Anta homin akon ma-kit bara-nan para sintinsyawan yan kamatyan. Kanya ipagaroti ko ya tana bi-sa bolohan.” ");
INSERT INTO xsb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kot lalo lay na ingat in-aaghaw a dapat yan ipasak ha kros, anggan na-honol syimpri yay in-aaghaw lan kalabongan tan hilay pawpoon pari. ");
INSERT INTO xsb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanya dinisisyonan ana ni Gobirnador Pilato a pagostowan hilay na ha andawaton la. ");
INSERT INTO xsb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Impapiboloh na hi Barabbas ta ya-rin a labay la, maskin yadtin hi Barabbas ay naprisoy naor bana ta nilomaban ya ha gobyirno tan nangmatin tawo. Kot hi Jesus ay in-intriga na ha omnoy hondalo para patyon ayon ha kalabayan lan tawtawo. ");
INSERT INTO xsb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hin ya-rin a an-i-ka lay na hi Jesus para ipasak ha kros, na-hakbat la hi Simon a taga Cirene a nangibat ha baryo. Hinampat la ya ta impabalatay konay kros ni Jesus, bi-sa pinaaloyon la ya koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Golpin tawo a nakiaaloyon kona, kalamo ot a bawbabayin antomangih bana ha ampangyari kona. ");
INSERT INTO xsb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pinalingayan na hila ni Jesus, wana, “Hikamoy bawbabayi a taga Jerusalem, ando la ko tangihan. Masbali tangihan moyoy sarili moyo tan hilay aw-awa-nak moyo. ");
INSERT INTO xsb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tandaan moyo: Lomato a panaon nin grabin kadya-dyaan a halitaon nin tawtawo yay bilang anodti, ‘Makalma hilay bawbabayin baog, hilay kay naka-ranas nin lomombit tan hilay kay naka-ranas mamasoso.’ ");
INSERT INTO xsb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Konan ya-rin a panaon, halitaon la ha bawbakil, ‘Daga-nan moyo kami!’ tan ha bawbabo, ‘Tambagan moyo kami!’ ");
INSERT INTO xsb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nga-min, no anodti nay anggaw-on lan pa-madya-dya kongko a kaalimbawaan kot kayon malaboyong a ambo dapat poolan ta homin akon ka-kasalanan, di laloy na komoyon tawon makasalanan a kaalimbawaan kot kayon malanat!” ");
INSERT INTO xsb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hin ya-rin, main hila ot inawit loway kriminal para patyon nin kalamo ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hin nakalato hilay na ha logar a anha-wayan “Bongo”, impasak la yay na ha kros hi Jesus. Impasak lay namaot hilay loway kriminal ha kros, yay a-sa ha bandan wanan ni Jesus tan yay a-sa ha bandan wili na. ");
INSERT INTO xsb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wani Jesus, “Ama, patawaron mo hila ta kay la tanda a anggaw-on la.” Hawanin, nibobonot hilay hawhondalo ta pinipapartiwan lay dawdoloh na. ");
INSERT INTO xsb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Itaw hilay tawtawon nakababantay. Hilay main katongkolan ay tinoya-toya la ya, ta wanla, “Inlipyas na hilay laloma, di ilipyas nay namaot a sarili na no hiya talaga yay Cristo, yay pinili nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Maski hilay hawhondalo ay tinoya-toya la yay namaot ta dinomani hila kona nin ambiyan la yan maalhom a alak obas. ");
INSERT INTO xsb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wanla, “No hikay Ari lan Israelita, ilipyas mo no-nin a sarili mo.” ");
INSERT INTO xsb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ha olowan ni Jesus ay main nakapaskin ha halita Griego, Latin tan Hebreo* a anodti labay totolon: “Yadti a Ari nin Aw-Israelita.” ");
INSERT INTO xsb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yay a-sa konlan kriminal a nakapasak anamaot ha kros ay tinoya-toya nay namaot hi Jesus, a wana, “Ambo doman hika yay Cristo? Ilipyas mo no-nin a sarili mo pati hikami.” ");
INSERT INTO xsb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kot hinaar na ya nin yay a-sa ot a kriminal, wana, “Kay ka doman angkali-mo ha Dios, anta pari-pariho tamon sintinsya? ");
INSERT INTO xsb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Marapat bongat a parosawan ta nin anodti bana ha gawginwa ta, kot yadtin tawo ay kay homin yan nagawa a karokaan.” ");
INSERT INTO xsb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bi-sa wana koni Jesus, “Katawan, panomtomon mo ko pa no hikay nay ampag-ari.” ");
INSERT INTO xsb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Wanan in-obat ni Jesus kona, “Yay potog, ibalita ko komo, hawanin ot a awlo, ipagkalamoan katay na ha Paraiso.” ");
INSERT INTO xsb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hin bandan ogtiawloy na, dinomoblom a intiron nasyon anggan ha bandan alas tres nin apon, ");
INSERT INTO xsb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ta dinomoblom yay awlo. Bi-sa yay kortina ha botlay nin timplo ay bigla nagi-nit nin na-pikalwa. ");
INSERT INTO xsb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tongwa wani Jesus ha makhaw a bosis, “Ama, an-ipa-taya ko komoy main kon ispirito.” Pa-makayari nan hinalita yadti ay nabtahan yay na. ");
INSERT INTO xsb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hin na-kit nan kapitan nin hawhondalo a ampagbantay koni Jesus a ni-pangyari, pinori na yay Dios. “Talagan homin yan kasalanan yadtin tawo,” wana. ");
INSERT INTO xsb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hiladtaw anamaot kalakan tawtawon nititipon itaw para mamiliw, hin na-kit lay nangyari ay ni-porong hilan ambogbogon lay kolop la pamilbian a an-ikalolo lay nangyari. ");
INSERT INTO xsb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kot hiladtaw halban kawka-bilbi ni Jesus, pati hilay bawbabayin naki-ka kona paibat ot probinsyan Galilea ay itaw hila ampanamolaw ha ambo karayoan, kanya angka-kit lay ampangyari. ");
INSERT INTO xsb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hin ya-rin ay main a-say lalaki a yay ngalan na kot Jose. Myimbro yan pinakamata-gay a konsiho nin nasyon Israel. Labah yan tawo tan maptog. ");
INSERT INTO xsb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nga-min, kay ya inomayon ha disisyon lan kapara nan kawkonsihal tan ha gawa lan pa-mapati koni Jesus. Taga yan Arimatea, a-say babali ha probinsyan Judea, tan a-sa yay namaot a ampana-gan ha pa-mag-ari nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yadtin hi Jose ay nako ya koni Gobirnador Pilato ta dinawat nay bangkay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pa-makayari ay nako yay na ta in-aypa nay bangkay ni Jesus ha kros. Pinotot nadti nin pinon tilan mapoti, bi-sa inggawa na ha a-say panabonan a kay ot ginamit a impakwiba ha bakil a bato. ");
INSERT INTO xsb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Awlon Byirnis hin ya-rin a awlon pa-magparihado para ha Awlon Pa-mainawa. Madani nay yabi a ompisan Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hiladtaw bawbabayin naki-ka koni Jesus paibat probinsyan Galilea ay hinomonol koni Jose, kanya na-kit lay pinanabonan koni Jesus tan no pa-no inggawa a bangkay na. ");
INSERT INTO xsb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bi-sa norong hila ta imparihado lay pawpabanglo tan lawlana a pambalsamo ha bangkay ni Jesus. Kot kinadilapan ta awlon Sabado ay nagpainawa hila yapo ayon ha kasogoan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Palbangon ot nin awlon Dominggo, nako hilay nay bawbabayi ha pinanabonan koni Jesus, awit lay imparihado lan pawpabanglo tan lawlaloma ot a igwa ha bangkay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na-lato lan naitolir ana yadtaw malapar a baton impanara ha pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kot hin nilomoob hila, na-kit la a homin ana itaw a bangkay ni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hin angkagoloy isip la no anya kari a nangyari, tongwa naka-kit hila ha dani la nin loway lalakin nakaayhing nin ampangi-kirlap. ");
INSERT INTO xsb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ha kali-mowan la ay ni-panalimokor hilan palokob, kot wanlan hila-rin loway lalaki, “Anongkot antingkapon moyoy angkabyay iti ha kamainan lan nawnati? ");
INSERT INTO xsb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kay yay na iti ta norong yan nabyay. Panomtomon moyodtaw imbalita na komoyo hin itaw ya ot ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Anodti wana komoyo: ‘Hiko a Naglalaman Tawo ay kailangan iintriga ha gamot lan dawdoka a tawo. Ipasak la ko, balo ta ha ikatlon awlo ay morong akon mabyay.’” ");
INSERT INTO xsb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na-panomtoman lay naor a hinalita na. ");
INSERT INTO xsb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pa-magbolta la ibat ha pinanabonan, imbalita ladtin halban konlan labin-a-say apostolis ni Jesus tan konlan halban laloma ot a kawkalamoan la. ");
INSERT INTO xsb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hila-rin bawbabayin namibalita nin yadti konlan aw-apostolis ni Jesus ay hila ni Maria Magdalena, hi Juana, hi Maria a nanay ni Santiago, tan hilay laloma ot a bawbabayin kalamoan la. ");
INSERT INTO xsb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Balo ta hay wanlan aw-apostolis kot gawa-gawa lan bongat a imbalita la, kanya kay hila naki-pol konla. ");
INSERT INTO xsb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Anodtaw pa man, hi Pedro ay inomdong ta nolayon nako ha pinanabonan. Hin tinomook ya ta hinilip nay lalo ay homin yan na-kit no ambo yadtaw bongat pinon tilan mapoti a ingkolkol ha bangkay. Kanya norong yan ampag-ispanta ha nangyari. ");
INSERT INTO xsb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ya-rin ot a awlo, main loway disipolos ni Jesus a anlalakon mako ha a-say baryo a anha-wayan Emaus, manga labin-a-say kilomitroy karayoan paibat ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Lo-gan lan anlalako ay ampi-totolan lay halban ni-pangyari koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ha pa-mi-totol tan pa-mi-pastangan la, tongwa dinaniwan na hila ni Jesus ta naki-sabay ya konla. ");
INSERT INTO xsb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Balo ta bilang pinorongan a mata la, kanya kay la na-bilbi hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hin ya-rin ay pinastang na hila, wana, “Anya kot ya-rin ampi-totolan moyo?” Tinomgon hilan mangalolo, bi-sa ");
INSERT INTO xsb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","yay a-sa konla a yay ngalan kot Cleopas a nangobat koni Jesus, wana, “Hikan bongat lawoy istranghiro ha Jerusalem a kay magtanda ha bawbagay a ni-pangyari itaw yadtin omnoy awlon nakalabah!” ");
INSERT INTO xsb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pastang ni Jesus, “Anya magbawbagay?” Wanlan in-obat kona, “Yay tongkol koni Jesus a taga Nazaret. A-sa yan propita a makapangyarian ha halita tan gawa, ha hilap nan Dios tan ha hilap nin halban tawo. ");
INSERT INTO xsb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kot hilay pawpoon pari tan pawpoon nin Israelita ay in-intriga la ya konlan taga Roma para sintinsyawan yan kamatyan, kanya impasak la ya ha kros. ");
INSERT INTO xsb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Hiya paot a pinasimalaan min mamilipyas ha nasyon Israel. Ambo bongat orin. Ikatlon awloy na hawanin paibat hin nati ya. ");
INSERT INTO xsb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bi-sa nabigla kami ha imbalita nin omnoy bawbabayin kalamoan mi. Nga-min, nanakbay hilan nako ha pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kot pa-morong la, wanlan imbalita komi a kay la na-kit a bangkay ni Jesus, balo ta main hila kanon na-kit aw-anghil a namibalita a norong yan nabyay. ");
INSERT INTO xsb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bi-sa main konlan kawkalamoan mi a nakoy namaot ha pinanabonan. Anodtaw anaor a na-kit la nin bilang ha imbalita lan bawbabayi. Kot hi Jesus ay kay la na-kit.” ");
INSERT INTO xsb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wani Jesus konla, “Anya pay nan kakapoyan pangingintindi moyo, ta hay irap moyon pi-polon a halban imbalita lan pawpropita ha Masanton Kasolatan. ");
INSERT INTO xsb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ambo doman imbalita la a yay Cristo kot kailangan dalanan nay anorin a pa-magdya-dya ba-yo na tanggapon a main nan karangalan?” ");
INSERT INTO xsb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bi-sa impahawang ni Jesus konlay impasolat ha intiron Masanton Kasolatan tongkol kona, paibat ha lawlibron sinolat ni Moises anggan ha lawlibron sinolat lan halban propita. ");
INSERT INTO xsb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Hin madani hilay nan miabot ha baryon kakaon lan lowa, hi Jesus ay bilang yan magpatoloy ha laloman kakaon. ");
INSERT INTO xsb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kot pinondan la ya, ta wanla, “Kihanda kay na yapon komi ta madani nan homlop a awlo tan anyomabi na.” Kanya nakihanda ya konla. ");
INSERT INTO xsb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hin ya-rin a nirorongo hilay na ha lamisawan para mangan, nangwa hi Jesus nin tinapay, bi-sa na pinasalamatan yay Dios. Pa-makayari ay pini-pikna na ta intorol na konla. ");
INSERT INTO xsb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tongwa, naalih yay bilang porong ha mata la, kanya na-bilbi la ya. Balo ta bigla homin yay na. ");
INSERT INTO xsb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wanla ha a-sa tan a-sa, “Kanya payti, hay gandan kalayaman ta lo-gan nan ampaki-totol konta ha dalan tan hin an-ipahawang nay Masanton Kasolatan.” ");
INSERT INTO xsb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ya-rin ot a oras ay inomdong hila ta nagbolta ha syodad Jerusalem. Na-lato la itaw hilay labin-a-say apostolis a nititipon, pati hilay laloma ot a kawkalamoan la. ");
INSERT INTO xsb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wanla konlan lowa, “Talagan potog paytaw a norong yan nabyay a Katawan ta nagpa-kit ya koni Simon!” ");
INSERT INTO xsb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hiladti namaot a loway kapilato ay imbalita lay namaot a nangyari konla ha dalan tan no pa-no la ya na-bilbi ha pa-mi-pikna na nin tinapay. ");
INSERT INTO xsb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lo-gan antotolon lay nangyari ay bigla nagpa-kit hi Jesus nin naka-dong ha botlay la. Wana konla, “Magkamain kamon kaliswayan nakom!” ");
INSERT INTO xsb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kot naka-kolalag hila tan na-li-mowan ta hay wanla no moltoy angka-kit la. ");
INSERT INTO xsb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kanya wani Jesus konla, “Anongkot golo-goloy isip moyo tan anongkot ampagdoda kamo ot? ");
INSERT INTO xsb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Bilyon moyoy gamot tan ayi ko ta ma-bilbi moyo a hikon talaga. Ga-gotan moyo ko tan paka-biliwon. Yay molto ay homin laman tan botol, ambo bilang ha angka-kit moyo kongko.” ");
INSERT INTO xsb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pa-makayari nan hinalita yadti ay impa-kit na konlay gamot tan ayi na. ");
INSERT INTO xsb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hin kay hila ot maka-paki-pol bana ha sobran kaligawan tan ampag-ispanta hila ot, wana konla, “Main doman ma-kan iti komoyo?” ");
INSERT INTO xsb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Binyan la yan a-say po-toh a hiniban konâ tan kalaba. ");
INSERT INTO xsb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kinwa nadti ta kinan na ha arapan la. ");
INSERT INTO xsb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pa-makayari, wani Jesus konla, “Yadti a labay kon totolon hin imbalita ko komoyo hin kalamo moyo ko ot a dapat mangyari yay halban nakasolat tongkol kongko ha Masanton Kasolatan ha Libron Kawkapanogoan a sinolat ni Moises tan ha lawlibron sinolat lan propita pati ha Libron Kawkanta.” ");
INSERT INTO xsb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bi-sa hinawangan ni Jesus a kawkaisipan la pigaw maintindyan lay labay totolon nin Masanton Kasolatan. ");
INSERT INTO xsb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hawanin wana konla, “Wana ha Masanton Kasolatan a kailangan magdya-dya tan mati yay Cristo, bi-sa morong yan mabyay ha ikatlon awlo. ");
INSERT INTO xsb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tan kailangan ipangaral ha tawtawo ha halban nawnasyon paibat ha Jerusalem a mangombabali hila, pigaw ha ngalan na ay ma-patawad a kawkasalanan la. ");
INSERT INTO xsb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hikamoy tistigo konan yadtin bawbagay. ");
INSERT INTO xsb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tandaan moyo: Ihogo ko komoyo yay impangako nan Ama ko. Kot iti kamo yapon ha syodad Jerusalem anggan kay kamo ma-biyan nin kapangyarian a maibat ha langit.” ");
INSERT INTO xsb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bi-sa inawit ni Jesus hilay dawdisipolos na nin lomikol ha syodad. Pa-makalato la ha baryon Betania ay inta-gay nay gamot na ta binindisyonan na hila. ");
INSERT INTO xsb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lo-gan na hila ot ambindisyonan, an-ibati na hilay na ta daoto-daoto yay nan ampamata-gay ha langit. ");
INSERT INTO xsb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hin ya-rin ay sinamba la yan dawdisipolos na. Bi-sa nagbolta hila ha Jerusalem nin main mahi-ban a kaligawan. ");
INSERT INTO xsb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi-sa pirmi hilay nan itaw ha timplo nin ampamori tan ampaki-salamat ha Dios. Amen.");
INSERT INTO xsb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Hin kalin-oo-nawan ot, ison yay na yay Halita. Yadtin Halita ay kalamoan nan Dios, tan hiya ay Dios. ");
INSERT INTO xsb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paibat hin ibat ay kalamoan na yay nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Halban bagay ay hiyay main gawa. Homin ni anyakaman a pinalsa a kay na impapalsan Dios kona. ");
INSERT INTO xsb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iti konay biyay, tan ampami yan hawang ha kaisipan nin tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yadtin hawang ay anhawangan nay karobloman a kaalimbawaan kot kasalanan, tan yadtin hawang ay kay madaog nin karobloman. ");
INSERT INTO xsb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Main a-say tawon inhogo nan Dios a yay ngalan kot Juan. ");
INSERT INTO xsb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Inhogo na ya bilang a-say tistigo para mamaptog tongkol konan yay Hawang, pigaw halban tawo kot tompol konan yay Hawang bana ha pa-maptog na. ");
INSERT INTO xsb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yadtin hi Juan Bautista ay ambo hiyay Hawang, nokay inhogo yay naor para mamaptog tongkol konan yay Hawang. ");
INSERT INTO xsb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yadtin antokoyon Hawang ay yay potog a Hawang a nako iti ha babon lota, tan anhawangan nay kaisipan nin balang tawo. ");
INSERT INTO xsb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nako ya iti ha mondo, tan hiyay namalsa nin yadtin mondo, balo ta kay la ya na-bilbi nin tawtawo ha mondo. ");
INSERT INTO xsb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nako ya ha Israel a sarili nan nasyon, balo ta karamilan konla ay kay la ya tinanggap. ");
INSERT INTO xsb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kot halban lan nananggap tan tinompol kona ay binyan na hilan karapatan para mag-in awa-nak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nag-in hilan awa-nak nan Dios ambo bana ta impangabing hila ayon ha natoral a pa-miabing, o bana ha gawa nin miambali o kalabayan nin miambali, nokay bana ta kalabayan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yay Halita ay Naglalaman Tawo tan ni-wan ya iti kontamo. Na-kit mi a main nan kapangyarian tan kalinggasan bilang ka-siya-siyan Anak nan Dios. Pono yan kaabigan tan kaptogan. ");
INSERT INTO xsb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Hi Juan ay namaptog tongkol kona. Anodti a imbalita na ha tawtawo ha makhaw a bosis: “Hiya yay antotolon kon lomato a hoyot kongko a mas makapangyayari kongko, ta anggano man kaka ako kona, kot hin yadtaw ot ba-yo ko impangabing, hiya ay hiyay na.” ");
INSERT INTO xsb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bana ta pono yay naor kaabigan tan kaptogan ay homin togon a angkatanggap tamon pawpayabol. ");
INSERT INTO xsb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yay kawkapanogoan ay inimbi nan Dios kontamo ha paralan ni Moises, balo ta yay kaabigan tan kaptogan nan Dios ay niabot kontamo ha paralan ni Jesu-Cristo. ");
INSERT INTO xsb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nika-ka-noman homin ot tawon naka-kit konan Dios, balo ta impabilbi na ya kontamo nin ka-siya-siya nan Anak a lawah nan kalamo-lamo. ");
INSERT INTO xsb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hin main pawpari tan tawtawon Levita katambay lan pari a nangibat ha Jerusalem, ta inhogo hila koni Juan Bautista nin hilay pawpoon nin Israelita para pastangon no hino ya, ");
INSERT INTO xsb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","imbalita nay kaptogan. Kay na tinanggap a hiya yay Cristo, nokay wanan pa-maptog: “Ambo ako yay Cristo.” ");
INSERT INTO xsb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kanya pinastang la yay naman, wanla, “Hino ka man no-nin? Hikay na doman hi Propita Elias a makalato oman?” “Ambo,” wani Juan. “Hika doman yay propita a impangako nan Dios?” “Ambo,” wana syimpri ni Juan. ");
INSERT INTO xsb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wanla kona hin ya-rin, “Hino ka man no-nin? Ibalita mo pa komi pigaw main kamin maibalita konlan nanogo komi. Anyay ma-halita mo tongkol ha sarili mo?” ");
INSERT INTO xsb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wani Juan, “Hikodtaw a antokoyon ni Propita Isaias, a wana, Main malngo makhaw a bosis a ampama-balawbaw ha disyirto a ampamibalita ha tawtawo: ‘Pa-hal pantayon tan itoynong moyoy dalanan nan Katawan.’” ");
INSERT INTO xsb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hiladtaw inhogo para mamastang koni Juan ay paw-Pariseo. ");
INSERT INTO xsb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wanla ot koni Juan, “Anongkot man ampamaotismo ka, anta ambo ka payti yay Cristo ni hi Propita Elias o yay propita a impangako nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wanan in-obat ni Juan, “Iya, ampamaotismo ko, balo ta lanom a anggamiton ko, kot main iti kontamo a ambo moyo ot bilbi. ");
INSERT INTO xsb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hiya yadtaw antokoyon kon lomato a hoyot kongko a mas makapangyayari kongko, ta ni mangorkal kordon apin na ay ambo akon marapat.” ");
INSERT INTO xsb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yadtin halban ay nangyari ha baryon Betania, ha lipay nin Kabatwan Jordan ha logar a ampamaotismowan ni Juan Bautista. ");
INSERT INTO xsb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kinadilapan, na-tamolaw ni Juan hi Jesus a andomani kona. Kanya wana konlan tawtawo itaw, “Oyay nay pa-hal Kordero nan Dios a mangalih kawkasalanan nin tawtawo ha mondo. ");
INSERT INTO xsb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hiya yay antotolon kon lomato a hoyot kongko a mas makapangyayari kongko, ta maski man kaka ako kona, kot hin yadtaw ot ba-yo ko impangabing, hiya ay hiyay na. ");
INSERT INTO xsb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hin o-na, maskin hiko, kay ko tanda no hino ya-rin a hogo nan Dios. Anorin man, inhogo na kon Dios iti nin mamaotismo ha lanom para ipabilbi ko ya komoyon kaparan aw-Israelita.” ");
INSERT INTO xsb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Oyay pa-maptog ni Juan tongkol koni Jesus: “Na-kit koy Ispirito nan Dios a inomaypa ibat ha langit nin bilang a-say kalapati, ta namirmi ya koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Dati kay ko tanda no hino ya-rin a hogo nan Dios, balo ta hin inhogo na kon Dios para mamaotismo nin lanom ay anodti impao-na na kongko, ‘Yay tawon ma-kit mon aypaan nin Ispirito nan Dios tan pirmiwan na ay hiya yay mamaotismo nin Masanton Ispirito.’ ");
INSERT INTO xsb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na-kit koy naor yadti,” wani Juan, “kanya ampaptogon ko a hiya yay Anak nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hin hinomonol a awlo, hi Juan Bautista ay itaw yay naman nin kalamo a lowa ha dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tongwa, hin na-kit nan anlomabah hi Jesus, wana, “Bilyon moyoy pa-hal Kordero nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hin nalngo lan loway disipolos na a hinalita na, tampol hilan inomaloyon koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Namalingay hi Jesus, kanya na-kit na hilan an-omaloyon kona. Pinastang na hila, wana, “Main kamo doman labay?” Wanla kona, “Rabi, ayti ka ampi-wan?” (Yay labay totolon “Rabi” kot Maistro.) ");
INSERT INTO xsb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wana konla, “Ki-ka kamo ta pigaw ma-kit moyo.” Naki-ka hilay naor kona kanya na-kit lay an-iwanan na. Itaw hila yapo nakihanda kona ya-rin a awlo bana ta manga alas kwatroy na nin apon hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yay a-sa konlan loway disipolos a nakalngo ha imbalita ni Juan Bautista tan inomaloyon koni Jesus ay hi Andres a talakaka ni Simon Pedro. ");
INSERT INTO xsb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pa-morong la, yadtin hi Andres a no-nan naka-kit koni Simon a kaka na, bi-sa wana kona, “Na-kit mi na yay Mesias!” (Yay labay totolon “Mesias” ay Cristo.) ");
INSERT INTO xsb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bi-sa inawit na ya koni Jesus. Hinilap ni Jesus hi Simon, bi-sa wana kona, “Hika hi Simon a anak ni Juan, balo ta Cefas anay ipangalan komo.” (Yadti ay pariho ha ngalan Pedro.) ");
INSERT INTO xsb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kinadilapan, nagdisisyon hi Jesus nin mako ha probinsyan Galilea. Na-kit na itaw hi Felipe, kanya wana kona, “Homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Yadtin hi Felipe ay taga Betsaida a babali lay namaot ni Andres tan Pedro.) ");
INSERT INTO xsb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yay ginwa ni Felipe ay tiningkap na hi Natanael, bi-sa wana kona, “Na-kit mi nadtaw antokoyon ha Libron Kawkapanogoan a sinolat ni Moises tan ha lawlibron sinolat lan laloman propita nan Dios. Hiya hi Jesus a taga Nazaret, yay anak ni Jose.” ");
INSERT INTO xsb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wani Natanael kona, “Main wari labah a ampangibat ha Nazaret?” Wani Felipe, “Maki-ka ka kongko ta biliwon mo.” ");
INSERT INTO xsb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hin na-kit ni Jesus hi Natanael a andomani kona, wanan hinalita tongkol kona, “Bilyon moyoy a-say potog a Israelita a kay anggomwa nin ambo tama.” ");
INSERT INTO xsb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pinastang na ya ni Natanael, wana, “Pa-no mo ko na-bilbi?” Obat ni Jesus kona, “Ba-yo na ka hina-wayan ni Felipe ay na-kit kata hin itaw ka ha hilong poon igos.” ");
INSERT INTO xsb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Wani Natanael kona, “Maistro, hika a Anak nan Dios! Hika yay anta-ganan min Ari nin Israel!” ");
INSERT INTO xsb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Wani Jesus anaman koni Natanael, “Bana wari ta imbalita ko komo a na-kit kata hin itaw ka ha hilong nin poon igos, kanya ka tinompol kongko? Mas holok ot ison a mi-ka-kit mo.” ");
INSERT INTO xsb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Bi-sa wana ot ni Jesus, “Yay potog a potog, ibalita ko komoyo, paibat hawanin, ma-kit moyon abirto yay langit tan hilay aw-anghil nan Dios ay moli-monaoy nin mako kongko a Naglalaman Tawo.” ");
INSERT INTO xsb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pa-makalabah nin loway awlo, main kahal ha babalin Cana ha probinsyan Galilea. Itaw yay nanay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hi Jesus tan hilay dawdisipolos na ay kinombida anamaot ha kahal. ");
INSERT INTO xsb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hin na-min anay alak obas itaw ha kahal, wanan nanay ni Jesus kona, “Na-minan hilan alak.” ");
INSERT INTO xsb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kot wani Jesus kona, “Ando mo ko pango-nawan, babayi. Ambo ko ot oras.” ");
INSERT INTO xsb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hawanin, wanan nanay na konlan ma-magsirbi, “Anyamay ibalita na komoyo ay gaw-on moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Main itaw a-nom a pasig a ampamigwaan lanom para ha sawsirimonyan pa-manglinis nin Israelita. Balang pasig ay ampaglaman nin lowampolo anggan tolompolo a galon. ");
INSERT INTO xsb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Imbalita ni Jesus konlan ma-magsirbi a ponoon lan lanom a balang pasig. Pinono lay naor lanom a pawpasig anggan labi. ");
INSERT INTO xsb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bi-sa wani Jesus konla, “Manalok kamoy na, ta ibi moyo konan ampamahala ha handaan.” Anorin anaor a ginwa la. ");
INSERT INTO xsb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tinawayan nan ampamahala yay lanom a nag-in anan alak obas, kot kay na tanda no ayti ibat yadti, (balo ta tanda lan ma-magsirbi a nanalok nin yadti.) Kanya hina-wayan nan ampamahala yay nobyo, ");
INSERT INTO xsb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ta wana kona, “Ayon ha ogali tamo ay an-o-nawon idolog yay malahap a klasin alak, bi-sa no lako anay nainom lan tawtawo, an-idolog anay ordinaryon klasi. Kot hika, naihoyot moy na ingat payti yay malahap a klasin alak.” ");
INSERT INTO xsb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yadtin nangyari ha babalin Cana, probinsyan Galilea ay yay kalin-oo-nawan milagro a ginwa ni Jesus, pa-mipatnag nin main nan pa-maka-Dios. Bana konan yadti, tinompol kona hilay dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hin nayari a kahal, nako hi Jesus ha babalin Capernaum nin kalamo a nanay na, tawtalakaka na tan dawdisipolos na. Itaw hila yapo nin omnoy awlo. ");
INSERT INTO xsb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hin ya-rin ay madani nay Pistan Pa-makalibri nin Israelita. Kanya nako hi Jesus tan hilay disipolos na ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Itaw ha timplo nan Dios ay na-lato ni Jesus hilay ampi-paglako nin mawmaida-ton konan Dios bilang ha bawbaka, kawkarniro tan kawkalapati, pati hilay ma-nagilin kwarta a nakapwisto itaw. ");
INSERT INTO xsb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yay ginwa ni Jesus, ginomwa yan maipangaroti ta ginamit nan impamaalih konlan halban ma-maglako itaw ha timplo, pati kawkarniro tan bawbaka. Inbo-bo na ot a kawkwarta lan ma-nagili, ta binalinta nay lawlamisawan la. ");
INSERT INTO xsb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Bi-sa wana konlan ma-maglako kalapati, “Alihon moyo-rin iti! Ando moyo gaw-on palingki a bali nan Ama ko!” ");
INSERT INTO xsb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na-panomtoman lan dawdisipolos na yay wana ha Masanton Kasolatan, “Halban kohaw ko ay an-ika-min ko ha pa-mag-inakit ko ha main mon bali, o Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kot hilay pawpoon nin Israelita, wanla koni Jesus hin ya-rin, “Anyay milagro a maipa-kit mo komi bilang pamilbian a hika kot main karapatan nin gomwa nin yadti?” ");
INSERT INTO xsb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Wanan in-obat ni Jesus, “Yobaon moyodtin timplo, ta ha loob nin toloy awlo ay ipa-dong kon oman.” ");
INSERT INTO xsb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kot wanlan pawpoon nin Israelita, “A-pat a polo tan a-nom a taon impa-dong yadtin timplo, tongwa wari maipa-dong mo ha loob nin toloy awlo bongat?” ");
INSERT INTO xsb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kot yay antokoyon ni Jesus a timplo ay yay main nan lalaman. ");
INSERT INTO xsb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanya, hin norong yan nabyay hi Jesus, na-panomtoman lan dawdisipolos na yadtin hinalita na, kanya pini-pol la yay wana ha Masanton Kasolatan tan yay hinalita ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hin ya-rin a itaw hi Jesus ha syodad Jerusalem lo-gan ya-rin Pistan Pa-makalibri, lako a tawtawon tinompol kona bana ha na-kit lan mawmilagro a ginwa na. ");
INSERT INTO xsb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Anorin man, kay ya pinomasimala konla bana ta bilbi nay halban tawo. ");
INSERT INTO xsb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ambo kailangan a main mamibalita kona tongkol ha hinoman a tawo, bana ta tanda nay kanakoman nin balang a-sa. ");
INSERT INTO xsb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Main a-say poon nin Israelita ha gropo lan Pariseo a yay ngalan kot Nicodemo. ");
INSERT INTO xsb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A-say yabi, nako ya koni Jesus, ta wana kona, “Maistro, tanda min a-sa kan ma-noro a inhogo nan Dios. Nga-min, kay homin makagwa nin mawmilagro a bilang ha anggaw-on mo no homin konay Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Wanan in-obat ni Jesus, “Yay potog a potog, ibalita ko komo, no kay maiabing oman a a-say tawo ay kay ya maka-paki-lamo ha ampag-arian nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Wani Nicodemo kona, “Pa-no ya man wari maiabing oman a a-say tawon matokling ana? Makaloob ya ot wari ha tiyan nin nanay na para iabing yan oman?” ");
INSERT INTO xsb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Wanan in-obat ni Jesus, “Yay potog a potog, ibalita ko komo, no kay maiabing oman yay tawo ha paralan nin lanom tan ha Ispirito nan Dios ay kay ya maka-paki-lamo ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nga-min, yay impangabing nin tawo ay tawo syimpri, kot yay in-abing ha Ispirito nan Dios ay iti konay Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kanya ando mo pag-ispantawan a imbalita ko komo a kailangan maiabing kamon oman a tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yay Ispirito nan Dios ay bilang ha lopot a ampiabot no ayti na labay. Angkalngo moy tonoy na, balo ta kay mo tanda no ayti ya ampangibat tan no ayti ya mako. Anorin anamaot kapara, kay ma-tandaan no anyay anggaw-on nin Ispirito nan Dios ha kanakoman nin tawon in-abing oman.” ");
INSERT INTO xsb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Wani Nicodemo, “Pa-no man mangyari orin?” ");
INSERT INTO xsb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Wanan in-obat ni Jesus, “A-sa kan ma-noro ha lawlipi ni Israel, bi-sa kay mo angkaintindyan yadti? ");
INSERT INTO xsb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yay potog a potog, ibalita ko komo, an-itoro mi yay tanda mi, ta yay ampaptogon mi ay yay na-kit mi, kot kay moyo antanggapon a pa-maptog mi. ");
INSERT INTO xsb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","No kay moyo ampi-polon a imbalita ko tongkol ha bawbagay a iti ha babon lota, pa-no moyo man ma-pi-pol no ibalita ko komoyo yay tongkol ha bawbagay ha langit? ");
INSERT INTO xsb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Homin ot tawon noli ha langit, kanya homin magtanda tongkol ha langit no ambo hiko, yay nangibat ha langit a Naglalaman Tawo a kalamo-lamo nan Dios ha langit.” ");
INSERT INTO xsb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wana ot ni Jesus, “Hin yadtaw ay inta-gay ni Moises yay olay a yari ha tanso ha a-say kayo, pigaw hinoman konlan na-kayat olay a homilap konan yadti ay kay nin mati. Anorin anamaot kapara kongko a Naglalaman Tawo, kailangan ita-gay akoy namaot ha a-say kayo, ");
INSERT INTO xsb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pigaw hinoman a tompol kongko ay kay mi-ka ha impyirno, nokay* magkamain yan biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bana ha kahi-banan labi nan Dios ha tawtawo ha mondo, inimbi nay ka-siya-siya nan Anak pigaw hinoman a tompol kona ay kay mi-ka ha impyirno nokay magkamain yan biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Inhogo nay naor Dios yay Anak na iti ha babon lota, kot ambo para sintinsyawan a tawtawon mi-ka ha impyirno, nokay pigaw mag-in yan paralan para malipyas a tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Hinoman a antompol konan Anak nan Dios ay kay sintinsyawan nin mi-ka ha impyirno. Balo ta hinoman a kay antompol ay sinintinsyawan anan mi-ka ha impyirno, palibhasay kay yay naor antompol ha ka-siya-siyan Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sinintinsyawan hila bana ta yay hawang a ibat ha Dios ay nakalato iti ha sangkalotaan, kot mas nilabay lan tawtawo yay karobloman dinan yay hawang, palibhasay dawdoka a gawgawa la. ");
INSERT INTO xsb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nga-min, balang tawon anggomwa doka ay antiplonon nay hawang. Kay na labay mipadani ha hawang ta pigaw kay ma-patnagan a gawgawa nan karokaan. ");
INSERT INTO xsb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kot yay tawon anggomwa labah ay andomani ha hawang ta pigaw ma-kit a yay gawginwa nan labah ay gawa nin pa-makiasa-sa na ha Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hin nayari odti, hi Jesus tan hilay disipolos na ay nakoy na ha probinsyan Judea. Nagpirmi ya yapo itaw nin kalamo hila tan namaotismo. ");
INSERT INTO xsb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hi Juan Bautista ay ampamaotismo namaot ha Enon, madani ha Salim, bana ta lako a lanom itaw. Angkaon la yan tawtawo ta bi-sa ampabaotismo hila kona. ");
INSERT INTO xsb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Kay ya ot napriso hi Juan hin ya-rin a panaon.) ");
INSERT INTO xsb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hin ya-rin ay nagkamain pa-mididiskosyon hilay dawdisipolos ni Juan Bautista tan hilay laloman Israelita tongkol ha sirimonyan pa-manglinis. ");
INSERT INTO xsb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kanya kina la hi Juan Bautista nin hilay dawdisipolos na, ta wanla kona, “Maistro, yadtaw lalaki a kalamo mo hin yadtaw ha lipay nin Kabatwan Jordan a pinaptogan mon hiya yay Cristo ay ampamaotismo yay namaot, tan halos halban tawtawo ay ampako kona.” ");
INSERT INTO xsb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kot wani Juan Bautista nin in-obat konla, “Yay tawo ay homin matanggap ni anyakaman no kay na ibi nin Dios. ");
INSERT INTO xsb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hikamo mismoy maka-paptog ha imbalita kon ambo ako yay Cristo, nokay hikoy inhogo nan Dios nin mo-na konan impangako nan ihogo. ");
INSERT INTO xsb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kaalimbawaan ko ay abay na ha kahal. Yay nobya ay para bongat ha nobyo. Yay abay a ampana-gan ha nobyo ay maligan-maliga no malngo nay bosis nan nobyo. Anorin ot bongat kapara kongko, hostoy nay kaligawan ko. ");
INSERT INTO xsb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kanya kailangan hiyay mag-in lalon importanti, ta hikoy nay ambo importanti.” ");
INSERT INTO xsb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yay ibat ha kalinta-ta-gayan ay holok ha halban. Kot hinoman a ibat ha kalotaan ay taga yan bongat babon lota, tan yay anhalitaon na ay tongkol ha bawbagay ha babon lota. Kot yay naibat ha langit ay holok yay naor ha halban. ");
INSERT INTO xsb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tan yay ampaptogon na ay yadtaw na-kit tan nalngo na, kot halos homin malabay mi-pol ha ampaptogon na. ");
INSERT INTO xsb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kot hinoman a ampi-pol ha ampaptogon na ay ampamaptog a maptog yay Dios. ");
INSERT INTO xsb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nga-min, yay inhogo nan Dios ay ampanalita nin hawhalita nan Dios, palibhasa yay pa-mami nan Dios kona nin Ispirito na ay kay mahokat. ");
INSERT INTO xsb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anlabyon nan Dios Ama yadtin Anak na tan impa-taya nay halban bawbagay kona. ");
INSERT INTO xsb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hinoman a antompol konan Anak nan Dios ay main biyay a homin anggawan. Kot hinoman a kay anhomonol konan Anak nan Dios ay kay na matanggap a biyay a homin anggawan, nokay patoloy a hobhob nan Dios kona nin main parosa ha lomato a panaon. ");
INSERT INTO xsb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Hin yadtaw, na-tandaan ni Jesus a Katawan a na-balitaan lan paw-Pariseo a mas lako a anhomonol tan ampabaotismo kona dinan koni Juan Bautista. ");
INSERT INTO xsb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kot yay potog, ambo hi Jesus yay ampamaotismo nokay hilay disipolos na.) ");
INSERT INTO xsb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kanya inomalih hi Jesus ha probinsyan Judea nin kalamo hilay disipolos na ta nagbolta hila ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ha pa-mako la itaw, kailangan magpa-wan hila ha probinsyan Samaria. ");
INSERT INTO xsb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hin itaw hilay na ha probinsyan Samaria ay niabot hila ha kahakopan nin babalin Sicar, itaw ha kamainan nin lota ni Jacob a impatawil na konan anak nan hi Jose. ");
INSERT INTO xsb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Itaw yay anha-wayan “Bobon ni Jacob”. Ha kapagalan nan nilomalako ni Jesus, tinomoklo ya ha danin bobon. Manga bandan ogtiawloy na hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tongwa, main nakalato a-say babayin taga Samaria para manago. Wani Jesus kona, “Makiinom ako pa.” ");
INSERT INTO xsb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Kay hila itaw a dawdisipolos na hin ya-rin, ta nako hila ha babali para manaliw nin pa-mangan.) ");
INSERT INTO xsb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wanan yadtin babayin taga Samaria kona, “Anongkot ka ampakirawat lanom kongko a a-say taga Samaria, anta a-sa kan Israelita?” Hinalita nadti bana ta hilay Israelita ay kay ampaki-lamo konlan taga Samaria. ");
INSERT INTO xsb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wani Jesus kona, “No tanda mon bongat komon yay an-ibi nan Dios ha tawo tan no hino ko a ampakirawat lanom komo, sigoradon makirawat ka kongko ta biyan kata nin yay lanom a ampakapamin biyay.” ");
INSERT INTO xsb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kay na naintindyan nin yadtin babayi a labay nan totolon ni Jesus, kanya wana kona, “Sinyor, homin kan tambiraw bi-sa malalo paot odtin bobon. Ayti ka man wari mangwa nin ya-rin lanom a ampakapamin biyay? ");
INSERT INTO xsb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Daog mo ot wari yay kalimpapo-papoan tamon hi Jacob a nami kontamo nin yadtin bobon? Hiya mismo, pati awa-nak na tan aw-ayop na ay iti hila ni-pinom hin yadtaw.” ");
INSERT INTO xsb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wani Jesus kona, “Hinoman a minom konan yadtin bobon ay lomata oman. ");
INSERT INTO xsb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kot hinoman a minom nin lanom a ibi ko ay kay ana lomata mika-ka-noman. Palibhasay yay lanom a ibi ko ay mag-in hobol iti kona a makapamin biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wanan babayi kona, “Sinyor, biyan mo ko pa no-nin ya-rin a lanom a an-ibalita mo, pigaw kay koy na lomata ni mako ot itin manago.” ");
INSERT INTO xsb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wani Jesus kona, “Kaon mon ha-wayan a kaambali mo, bi-sa magbolta kamo iti.” ");
INSERT INTO xsb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wanan in-obat nin yadtin babayi kona, “Homin akon kaambali.” Wani Jesus kona, “Potog orin wamo a homin kan kaambali. ");
INSERT INTO xsb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Palibhasay limay nay nag-in mon lalaki, bi-sa yay an-ipaglamo mo hawanin ay ambo mon kaambali. Kanya potog ya-rin hinalita mo.” ");
INSERT INTO xsb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wanan babayi kona, “Sinyor, ha intindi ko ay a-sa kan propita. ");
INSERT INTO xsb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hilay kapapo-papoan mi ay iti hila ansomamba ha Dios konan yadtin bakil, kot hikamoy aw-Israelita, an-ibalita moyo a itaw ha Jerusalem yay logar a dapat pagsambawan ha Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wani Jesus kona, “Mi-pol ka kongko, talakaka, anlomato anay panaon a somamba a tawtawo konan Ama nin kay hilay na mako konan yadtin bakil o itaw ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hikamoy taga Samaria ay ambo moyon bilbi yay ansambawon moyo. Kot hikamin aw-Israelita ay bilbi mi yay ansambawon mi, palibhasa yay kalipyasan a impangako nan Dios ay mangibat komin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Anlomato anay panaon, tan nag-ompisay na a hilay maptog a ansomamba konan Ama ay ansambawon la ya ibat ha lalo nakom la tan ayon ha kaptogan, ta anorin a labay nan Dios nin pa-magsamba kona. ");
INSERT INTO xsb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yay Dios ay Ispirito, kanya kailangan sambawon ya ha nakom tan ayon ha kaptogan.” ");
INSERT INTO xsb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wanan babayi kona, “Tanda ko a makalato yay Mesias, yay anha-wayan ‘Cristo’. Pa-makalato na, ibalita na kontamoy halban bawbagay.” ");
INSERT INTO xsb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Hawanin, wani Jesus kona, “Hikoy na-rin antokoyon mo.” ");
INSERT INTO xsb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hin ya-rin ay nakalato hilay nay dawdisipolos na. Nag-ispanta hila no anongkot ampaki-totol ya ha a-say babayi. Kot homin konla a namastang no anyay tatala na o no anongkot ya ampaki-totol kona. ");
INSERT INTO xsb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yay ginwa nan babayi ay imbati nay banga na, bi-sa tampol yay nan norong ha babali, ta wana ha tawtawo itaw, ");
INSERT INTO xsb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ki-ka kamo kongko, ta ma-kit moyoy a-say lalakin namibalita kongko nin halban gi-ginwa ko. Ambo wari hiyay na yay Cristo?” ");
INSERT INTO xsb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kanya naki-ka hilay tawtawo kona ibat ha babali para biliwon la hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lo-gan kay ya ot nakapagbolta a babayi, omnoy bisis la yan pinaki-totolan hi Jesus nin hilay disipolos na, a wanla kona, “Maistro, mangan kay na.” ");
INSERT INTO xsb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kot wani Jesus konla, “Main akon pa-mangan a kay moyo tanda.” ");
INSERT INTO xsb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hawanin, wanlan disipolos na ha a-sa tan a-sa, “Main wari nami nin pa-mangan kona?” ");
INSERT INTO xsb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wani Jesus konla, “Yay pa-hal pa-mangan ko ay yay honolon koy kalabayan nan nanogo kongko tan polyarion yay an-ipagwa na. ");
INSERT INTO xsb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ambo doman wamoyo, ‘A-pat a bolan ot ba-yo pa-manglapot?’ Kot yay ibalita ko komoyo, bilyon moyo hilay tawtawo, kapa-halan la ay trigon mangaloto ana tan panaon ana para gapason. ");
INSERT INTO xsb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hinoman a ampanoro konla nin tompol kongko ay pa-hal ma-manglapot a makatanggap nin tobalo, bi-sa yay risolta nin yadtin gawa la ay main tawon magkamain biyay a homin anggawan. Kanya pari-parihon maliga hilay pa-hal ma-mangmola a no-nan nangaral nin Halita nan Dios tan hilay ma-manglapot. ");
INSERT INTO xsb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iti ma-kit a potog anaor yay wanan kahalitaan, ‘Lalomay ampangmola, lalomay ampanglapot.’ ");
INSERT INTO xsb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Anorin ot bongat komoyo, an-ihogo katamo para pa-hal manglapot nin kay moyo pinagpagalan. Hakalakoy nagpagal, kot hikamoy makinabang.” ");
INSERT INTO xsb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lako a tawtawo itaw ha babalin Sicar a tinompol koni Jesus bana ha pa-maptog nan babayi nin anodti: “Imbalita na kongkoy halban gi-ginwa ko.” ");
INSERT INTO xsb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kanya pa-makalato lan taga Samaria itaw ha kamainan ni Jesus ay impaki-totol la kona a itaw ya yapon konla. Kanya itaw ya konla nin loway awlo. ");
INSERT INTO xsb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bi-sa lako ot a tinompol koni Jesus hin nalngo lay halita na. ");
INSERT INTO xsb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wanla konan babayi, “Hawanin ay antompol kami ambo anan bana ha imbalita mo, nokay mismon hikami nay nakapanglongo kona, kanya tanda mi na a talagan hiyay naor yay Cristo, yay Ma-milipyas nin halban tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pa-makalabah nin loway awlo, inomalih yay na hi Jesus ha babalin Sicar, ta nagpatoloy yay nan nako ha probinsyan Galilea. ");
INSERT INTO xsb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Maski man hi Jesus ana mismo a namibalita a yay a-say propita ay kay an-igalang ha sarili nan logar.) Kot nako ya syimpri. ");
INSERT INTO xsb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hin ya-rin balo a nakalato ya ha Galilea, tinanggap la yan tawtawo itaw, palibhasay na-kit lay gi-ginwa na hin itaw ya ot ha syodad Jerusalem hin Pistan Pa-makalibri, bana ta hila man ay nakipista anamaot. ");
INSERT INTO xsb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Hawanin, nako yay naman hi Jesus ha babalin Cana, probinsyan Galilea a pinangwaan nan alak obas yay lanom. Ha babalin Capernaum a ambo madayo ha babalin Cana ay main a-say opisyal nin gobyirno a main anak a lalaki a ampagmasakit. ");
INSERT INTO xsb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hin na-tandaan nan nakalato hi Jesus ha Galilea ibat ha probinsyan Judea, kina na ya ta impasi-singa-ro nan maki-ka ya kona ta paabigon nay anak nan maga-magay na mati. ");
INSERT INTO xsb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kot wani Jesus, “Hikamoy tawtawo, anggan kay kamo ot maka-kit nin gawgawa a ka-paka-ngap a pawpamilbian kapangyarian nan Dios ay kay kamo mi-pol.” ");
INSERT INTO xsb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wanan in-obat nin opisyal, “Maistro, maki-ka ka pay na kongko, lo-gan angkabyay ya ot a anak ko.” ");
INSERT INTO xsb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hawanin wani Jesus kona, “Morong kay na, ta labah yay nay anak mo.” Pini-pol nan opisyal yay halita ni Jesus, kanya norong yay na. ");
INSERT INTO xsb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lo-gan nan iti ha dalan, hinakbat la yay nan aw-alipon na, ta imbalita la kona a labah yay nay anak na. ");
INSERT INTO xsb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pinastang na konla no anyay oras inomabig yay anak na. Wanla kona, “Naapon hin bandan ala ona naalih a pa-nga-mot na.” ");
INSERT INTO xsb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na-panomtoman nan opisyal a ya-rin a oras hin hinalita ni Jesus kona nin “Labah yay nay anak mo.” Kanya hiya pati hilay intiron iti ha bali na ay tinompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yadti a ikalwan milagron ginwa ni Jesus ha probinsyan Galilea a nangyari naman hin nilomato ya ibat ha probinsyan Judea. ");
INSERT INTO xsb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pa-makayari nin yadtin bawbagay, madani nay naman a a-say pista nin Israelita, kanya nako yay naman hi Jesus ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Itaw ha Jerusalem ay main a-say ampalyoan ha dani nin “Poltan Kawkarniro”. Yadtin ampalyoan ay anha-wayan “Betesda” ha halita Hebreo. Ha ka-libol nan yadtin ampalyoan ay main limay hihilongan. ");
INSERT INTO xsb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Konlan yadtin hihilongan ay main lako a tawtawon ampira a main sari-sari a klasin dipirinsya a bilang ha bawbolag, pawpilay tan pawparalitiko. Antaga-nan lay pa-nigo nin lanom, ");
INSERT INTO xsb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","bana ta main oras a main anghil a amponaoy konan yay ampalyoan ta bolabogon nay lanom. Bi-sa hinoman a mo-nan maka-ka ha lanom pa-makayari mabolabog ay an-omabig, maskin anyakamay masakit na.* ");
INSERT INTO xsb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Main itaw a-say lalakin tolompolo tan waloy taon anan main masakit. ");
INSERT INTO xsb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Hin na-kit na ya ni Jesus bi-sa na-tandaan na a naboyot yay nan main masakit, wana kona, “Labay mo doman omabig?” ");
INSERT INTO xsb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Obat nan main masakit, “Maistro, homin mamiaypa kongko ha lanom no bigla yan manigo. Bi-sa, no ampamagka akoy na itaw ay angkao-nawan la koy nan laloma.” ");
INSERT INTO xsb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hawanin, wani Jesus kona, “Mibangon ka, kowon moy an-iraan mo ta lomalako kay na.” ");
INSERT INTO xsb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Antimano inomabig yay lalaki. Kinwa nay naor a iniraan na ta nilomalako yay na. Awlon Pa-mainawa hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kanya hin na-kit lan pawpoon nin Israelita ya-rin a lalakin pinaabig, wanla kona, “Awlon Pa-mainawa hawanin. Bawal ayon ha kapanogoan nan Dios ya-rin an-awiton moy iniraan mo.” ");
INSERT INTO xsb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kot wanan in-obat konla, “Yadtaw tawon namaabig kongko a nanalita a kowon ko kanoy an-iraan ko ta lomalako koy na.” ");
INSERT INTO xsb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pinastang la ya, wanla, “Hino ya kot ya-rin a tawon namibalita komo nin kowon moy an-iraan mo ta lomalako?” ");
INSERT INTO xsb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kot ya-rin lalaki ay kay na na-bilbi no hinoy namaabig kona, ta nakaalih yay na hi Jesus bana ha kalakan tawo itaw. ");
INSERT INTO xsb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kay naboyot, na-kit ni Jesus itaw ha timplo yay lalakin pinaabig na. Wana kona, “Hawanin, ta inomabig kay na, ando kay na magkasalanan oman pigaw homin mangyari komo a mas grabi ot.” ");
INSERT INTO xsb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hawanin, yadtin lalaki ay nako ya konlan pawpoon nin Israelita, ta imbalita na konla a yay namaabig kona ay hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Paibat hin ya-rin ay angkontrawon la yay na hi Jesus nin hilay pawpoon nin Israelita, tan ampaningkap hila ot paralan a ma-pati la ya bana ha pa-maabig na ha Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kot wani Jesus in-obat konla, “Yay Ama ko ha langit ay ampagpatoloy ya ha main nan gawgawa anggan hawanin, kanya anorin koy namaot.” ");
INSERT INTO xsb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ison lalon nag-in mapilit hilay pawpoon nin Israelita a patyon la hi Jesus. Nga-min para konla, ambo bongat kay na anhonolon a kasogoan tongkol ha Awlon Pa-mainawa, nokay an-ipantay na ot a sarili na ha Dios ta anhalitaon na a yay Dios kot Ama na. ");
INSERT INTO xsb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hawanin, wani Jesus konlan hila-rin a pawpoon nin Israelita, “Yay potog a potog, ibalita ko komoyo, hiko a Anak nan Dios ay kay ko maari gomawa ha sarili kon bongat kalabayan, nokay yay anggaw-on kon bongat ay yadtaw angka-kit kon anggaw-on nan Ama ko ha langit. Nga-min, anyakamay anggaw-on nan Ama ko ay anorin anamaot a anggaw-on ko bilang Anak na. ");
INSERT INTO xsb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Anlabyon na kon Ama ko bilang Anak na, kanya an-ipa-kit na kongkoy halban anggaw-on na, tan mas ka-paka-ngap ot a bawbagay a ipagawa na kongko para paka-ngapan moyo. ");
INSERT INTO xsb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yay anggaw-on nan Ama ko a ampaorongon nan mabyay hilay ni-kati ay anggaw-on koy namaot, ta ampaorongon kon mabyay yay hinoman a labay ko. ");
INSERT INTO xsb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nga-min, ambo yay Ama ko a ampamin sintinsya ha tawo, bana ta impa-taya na kongko bilang Anak na yay pa-mamin sintinsya ha halban tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ginwa na-rin pigaw hiko a Anak na ay igalang la kon halban bilang pa-migalang la konan Ama. Hinoman a kay anggomalang kongko ay bilang syimprin kay anggomalang konan Ama a nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Yay potog a potog, ibalita ko komoyo, hinoman a ampanglongo nin halita ko tan antompol konan namihogo kongko ay main yan biyay a homin anggawan tan kay yay na sintinsyawan nin mi-ka ha impyirno, palibhasay inlipyas yay na ha kamatyan a pa-makahiyay konan Dios anggan-angga, ta binyan yay nay naor nin biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yay potog a potog, ibalita ko komoyo, lomato a panaon tan nag-ompisay na hawanin a hilay tawtawon pa-hal nati ay malngo lay bosis ko a Anak nan Dios, tan balang tawon manglongo kongko ay magkamain biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","No pa-non yay Ama ko yay ampamin biyay, anorin anamaot kapara, hiko a Anak na ay binyan nan kapangyarian mamin biyay. ");
INSERT INTO xsb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tan binyan na ko ot karapatan mamin sintinsya, palibhasay naglalaman akon tawo. ");
INSERT INTO xsb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ando moyo paka-ngapan yadtin hinalita ko, ta main awlo a halban ni-kati ay malngo lay bosis ko. ");
INSERT INTO xsb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bi-sa mibangon hila, ta hiladtaw ginomwa aw-abig ay biyan biyay a homin anggawan, kot hilay ginomwa karokaan ay sintinsyawan hilan mi-ka ha impyirno.” ");
INSERT INTO xsb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Wana ot ni Jesus, “Kay ko maari gomawa ha sarili kon bongat kalabayan. Yay sawsintinsya a an-ibi ko ay ayon ha an-ibalita nan Ama kongko, kanya tama a an-ibi kon sintinsya, palibhasay ambo naor sarili kon kalabayan a anhonolon ko, nokay yay kalabayan nan Ama a nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“No wari ta hikon bongat a ampamaptog para ha sarili ko, homin alagay pa-maptog ko. ");
INSERT INTO xsb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kot main laloman ampamaptog tongkol kongko, tan tanda ko a yay ampaptogon na tongkol kongko ay potog. ");
INSERT INTO xsb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nanogo kamon tawtawo koni Juan Bautista para pastangon no hino ko. Imbalita na syimpri komoyoy kaptogan. ");
INSERT INTO xsb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kot ambo tawo yay labay kon totolon ha imbalita kon main laloman ampamaptog para kongko, nokay an-ipapanomtoman kon bongat yay hinalita ni Juan Bautista pigaw pi-polon moyo ta bi-sa malipyas kamo. ");
INSERT INTO xsb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kapa-halan ni Juan ay a-say lamparilya a marta tan ampakapamin hawang hin yadtaw. Hin nanglongo kamo kona ay na-ligawan kamo ha maantor a panaon ha pa-hal hawang a naibat kona. ");
INSERT INTO xsb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Anodtaw pa man, main pa-maptog tongkol kongko a holok ha pa-maptog ni Juan, ta yay gawgawa a anggaw-on ko a an-ipapolyari nan Ama kongko ay pa-maptog a inhogo na ko. ");
INSERT INTO xsb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tan mismon yay Ama a nanogo kongko ay ampamaptog syimpri tongkol kongko, anggano man kay moyo ot nalngo a bosis na ni na-kit a itsora na. ");
INSERT INTO xsb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kot homin ha nakom moyo yay Halita na, ta kay kamo antompol kongko a inhogo na. ");
INSERT INTO xsb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ampag-aralan moyoy naor yay Masanton Kasolatan ta yay wamoyo ay ya-rin a pangibatan nin magkamain kamon biyay a homin anggawan. Ya-rin a Masanton Kasolatan ay a-sa ot a ampamaptog tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kot anorin pa man, kay moyo ot labay domani kongko para magkamain kamo komon biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kay ko antingkapon a pamomori nin tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kot bilbi katamo; homin kamon pa-manglabi konan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nako ko iti ha ngalan nan Ama ko, balo ta kay moyo ko antanggapon. Kot no main laloman mako komoyo ha sarili lan bongat ngalan ay tanggapon moyo. ");
INSERT INTO xsb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pa-no kamo man wari tompol kongko, anta yay labay moyo ay poriwon la kamon kapara moyon tawtawo, ambo yay pamomori a ibat konan ka-siya-siyan Dios? ");
INSERT INTO xsb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ando moyo isipon a hikoy mamiriklamo konan Ama tongkol ha kawkasalanan moyo. Hi Moises mismo a ampasimalaan moyo, ta ampi-pol kamoy naor a malipyas kamo bana ha kaho-honol moyo ha kawkapanogoan, hiyay mamiriklamo tongkol ha kawkasalanan moyo. ");
INSERT INTO xsb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","No talagan ampi-polon moyo hi Moises, pi-polon moyo koy namaot komon ta nanolat ya tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kot bana ta kay moyoy nan lamang ampi-polon a sawsinolat na, pa-no moyo man ma-pi-pol a hawhalita ko?” ");
INSERT INTO xsb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pa-makayari orin ay nilomipay hi Jesus ha dobali Alindayat Galilea a anha-wayan anamaot Alindayat Tiberias nin kalamo hilay disipolos na. ");
INSERT INTO xsb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kalakan tawtawon tinomombok kona bana ta na-kit lay ka-paka-ngap a pa-maabig na konlan main masakit. ");
INSERT INTO xsb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bi-sa nako hi Jesus nin hinomaka ha a-say bakil, ta tinomoklo ya itaw nin kalamo hilay disipolos na. ");
INSERT INTO xsb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hin ya-rin ay madani nay naman a Pistan Pa-makalibri nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hin hinomilap hi Jesus, na-tamolaw nay golpin tawon anlomato. Kanya wana koni Felipe, “Ayti tamo kari makahaliw tinapay para makapangan hiladtin tawtawo?” ");
INSERT INTO xsb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hinalita nadti ni Jesus para hobokon nan bongat hi Felipe, kot tanda nay na ha sarili na no anyay gaw-on na. ");
INSERT INTO xsb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kot wanan in-obat ni Felipe, “Maski man opa nin a-say tawo ha lowanyatos a awlo ay kolang ot ipanaliw tinapay para makapangan maskin daoto a balang a-sa.” ");
INSERT INTO xsb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wanay namaot ni Andres a a-sa konlan disipolos na tan talakaka ni Simon Pedro, ");
INSERT INTO xsb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Main itin a-say anak a lalaki a main awit limay tinapay tan loway makalog a konâ, kot omno man tana-rin konlan hiladtin kalakan tawo?” ");
INSERT INTO xsb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hawanin, wani Jesus konlan disipolos na, “Patokloon moyo hilay tawtawo.” Maganday dikot itaw para tokloan, kanya tinomoklo hila. Yay bilang lan lawlalaki bongat ay manga limanliboy na. ");
INSERT INTO xsb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Hawanin, kinwa ni Jesus yay limay tinapay, bi-sa pa-makayari nan pinasalamatan yay Dios ay inimbi na konlan disipolos na, ta bi-sa impapto la konlan tawtawon pinatoklo. Anorin anamaot a ginwa na ha loway konâ. Binyan na hila anggan labay la. ");
INSERT INTO xsb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hin ni-kabhoy hilay na, wani Jesus konlan disipolos na, “Tiponon moyoy pawpirason ni-katla pigaw homin masayang.” ");
INSERT INTO xsb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hin tinipon lay naor yay ni-katla lan hilay ni-pangan ay nakapno hilan labinloway bakol nin pawpirason ni-katla ha limay tinapay. ");
INSERT INTO xsb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hin na-kit lan tawtawo odtin milagron ginwa ni Jesus, wanla, “Sigoradon yadti na yadtaw propitan impangako nan Dios a lomato iti ha kalotaan.” ");
INSERT INTO xsb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hin na-halata ni Jesus a labay la yan daniwan para piliton mag-in ari, inomalih yay naman ta nako ya ha bakil nin asa-sa na. ");
INSERT INTO xsb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hin anyomabi na, nako hilay disipolos ni Jesus ha liglig alindayat. ");
INSERT INTO xsb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bi-sa nilomolan hila ha baloto ta lomipay hilay naman ha alindayat para magbolta ha babalin Capernaum. Maroblom ana kot kay ya ot hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tongwa, nagkamain makhaw a lopot, kanya nag-in lalako a alon. ");
INSERT INTO xsb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hin nakaboghay hilay nan manga lima o a-nom a kilomitroy kadayoan, na-kit la hi Jesus nin anlalako ha babon lanom a andomani konla. Nali-mo hila ta kay la ya na-bilbi hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kot wana konla, “Hikodti! Ando kamo mali-mo!” ");
INSERT INTO xsb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hay liga la yan pinalolan ha baloto, bi-sa bigla niabot anay baloto la ha logar a kakaon la. ");
INSERT INTO xsb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kinadilapan, anta-ganan la ot hi Jesus nin hilay tawtawon na-bati itaw ha lipay nin alindayat. Nga-min, tanda la a homin laloman baloton nako itaw no ambo yadtaw bongat nilolanan lan disipolos, tan kay ya nakilolan konla hi Jesus ta inomalih hilay disipolos na nin hila-hilan bongat. ");
INSERT INTO xsb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Hawanin, main nakalato itaw nin laloman bawbaloto ibat ha babalin Tiberias. Dinomoong hila ha logar a madani konan pinanganan lan tawtawo nin tinapay a impaki-salamat ni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hin na-kit lan tawtawon na-bati itaw a talagan kay yay na itaw hi Jesus pati hilay disipolos na, nilomolan hilay na ha bawbaloton nakalato ta tinomombok hila ha babalin Capernaum para tingkapon hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hawanin, hin niabot hilay nay tawtawo ha dobali alindayat ay na-kit la itaw hi Jesus. Pinastang la ya, wanla, “Maistro, naka-no ka nako iti?” ");
INSERT INTO xsb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kot wani Jesus konlan in-obat, “Yay potog a potog, ibalita ko komoyo, antingkapon moyo ko, ambo bana ha mawmilagron na-kit moyo, nokay bana ta ni-kabhoy kamo hin nangan kamo nin yadtaw tinapay a inimbi ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ando kamo mangangga ha pa-magpagal para magkamain nin pa-mangan a main pa-ngahira, nokay masbali paka-tingkapon moyo yay klasin pa-mangan a kay mahira tan makapamin biyay a homin anggawan. Hiko a Naglalaman Tawo yay makapami komoyo nin yadtin klasin pa-mangan, bana ta binyan na kon Dios Ama nin kapangyarian.” ");
INSERT INTO xsb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hawanin, wanlan tawtawo koni Jesus, “Anyaman no-nin a dapat min gaw-on pigaw magawa mi yay kalabayan nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Wani Jesus konla, “Yay kalabayan nan Dios ay yay tompol kamo kongko a inhogo na.” ");
INSERT INTO xsb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wanlay naman tawtawo koni Jesus, “Anya may magawa mon milagro a ma-pamilbian mi para tompol kami komo? Anyay gaw-on mo? ");
INSERT INTO xsb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Hin panaon ni Moises, hilay kapapo-papoan tamo ay awlo-awlo hilan ampangan nin pa-mangan a anha-wayan ‘manna’ lolog itaw hila ha disyirto, ta wana ha Masanton Kasolatan: ‘Binyan na hilan pa-mangan a naibat ha langit.’” ");
INSERT INTO xsb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kot wani Jesus konla, “Yay potog a potog, ibalita ko komoyo, ambo hi Moises a nami konla nin yadtaw pa-mangan a ibat ha langit, nokay yay Ama ko, tan hiya syimpri a ampami komoyo nin yay pa-hal potog a pa-mangan a ibat ha langit. ");
INSERT INTO xsb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yadtin pa-hal potog a pa-mangan a an-ibi nan Dios ay homin laloma no ambo yay nonaoy ibat ha langit tan ampamin biyay a homin anggawan ha tawtawo ha mondo.” ");
INSERT INTO xsb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wanlan tawtawo koni Jesus, “Katawan, pirmi mo kami pan biyan nin ya-rin a klasin pa-mangan.” ");
INSERT INTO xsb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wani Jesus konla, “Hikoy pa-hal pa-mangan a ampakapamin biyay a homin anggawan. Balang tawon andomani tan antompol kongko ay pa-hal kay ana bomitil tan kay ana lomata mika-ka-noman. ");
INSERT INTO xsb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kot imbalita koy na komoyo a maski man angka-kit la koy na, kay kamo syimpri antompol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Halban tawtawo a an-ibi nan Ama kongko ay domani kongko, bi-sa hinoman a domani kongko ay disnodon kay ko itakwil. ");
INSERT INTO xsb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nga-min, nonaoy ako ibat ha langit, ambo para gaw-on koy sarili kon kalabayan, nokay para gaw-on ko yay kalabayan nan nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yadti yay kalabayan nan Ama a nanogo kongko: Ando ko dapat po-layan mapirdi maskin a-sa konlan halban impa-taya na kongko, nokay paorongon ko hilan mabyay ha hoyot a awlo. ");
INSERT INTO xsb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nga-min, kalabayan nan nanogo kongko a balang tawon ambomilbi tan antompol kongko a Anak na ay magkamain biyay a homin anggawan, ta bi-sa paorongon ko yan mabyay ha hoyot a awlo.” ");
INSERT INTO xsb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hin ya-rin ay main pawpoon nin Israelita itaw a mada-dalamorom, bana ha hinalita nan hiyay pa-hal pa-mangan a nonaoy ibat ha langit. ");
INSERT INTO xsb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wanla, “Ambo doman yadti hi Jesus a anak ni Jose? Bilbi tamoy tatay tan nanay na, anongkot man ta anhalitaon nan nonaoy ya ibat ha langit?” ");
INSERT INTO xsb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kot wanan in-obat ni Jesus konla, “Ando kamoy na mana-dalamorom. ");
INSERT INTO xsb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Homin tawon makadani kongko no kay na ya idani nin Ama ko a nanogo kongko. Tan hinoman a idani na kongko ay paorongon kon mabyay ha hoyot a awlo. ");
INSERT INTO xsb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wanay naor ha Masanton Kasolatan a sinolat lan pawpropita, ‘Halban tawo ay toroan nan Dios.’ Kanya hinoman a ampanglongo tan ampaka-tanda konan Ama ay andomani kongko. ");
INSERT INTO xsb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ambo labay totolon yadti a main anan tawon naka-kit konan Ama, nokay hikon bongat a naka-kit kona ta ibat akoy naor kona. ");
INSERT INTO xsb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yay potog a potog, ibalita ko komoyo, hinoman a tompol kongko ay main yan biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hikoy pa-hal pa-mangan a ampakapamin biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hilay kapapo-papoan tamo ay nangan nin yadtaw pa-mangan a anha-wayan ‘manna’ hin itaw hila ha disyirto, kot nati hila syimpri. ");
INSERT INTO xsb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kot yay antokoyon kon pa-hal pa-mangan a ibat ha langit ay nonaoy naor pigaw hinoman a mangan nin yadti ay kay mati. ");
INSERT INTO xsb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Oliton ko, hiko ya-rin pa-hal pa-mangan a ampakapamin biyay a homin anggawan a nonaoy ibat ha langit. Hinoman a mangan nin yadtin pa-mangan ay mabyay anggan-angga. Yay pa-hal pa-mangan a ibi ko para ipagkabyay nin tawtawo ha mondo ay yay laman ko.” ");
INSERT INTO xsb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bana konan yadtin hinalita ni Jesus, nanga-pipoporpya hilay pawpoon nin Israelita, a wanla, “Pa-no na kari maibi kontamo nin yadtin tawo a laman na ta kanon tamo kano?” ");
INSERT INTO xsb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kanya wani Jesus konla, “Yay potog a potog, ibalita ko komoyo, no kay kamo pa-hal mangan nin laman ko, hiko a Naglalaman Tawo, tan pa-hal minom nin daya ko, kay kamo magkamain biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kot hinoman a pa-hal ampangan nin laman ko tan pa-hal ampinom nin daya ko ay main nin biyay a homin anggawan, ta bi-sa paorongon ko yan mabyay ha hoyot a awlo. ");
INSERT INTO xsb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nga-min, yay laman ko ay potog a pa-mangan, tan yay daya ko ay potog a inomon. ");
INSERT INTO xsb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kanya balang tawon pa-hal ampangan nin laman ko tan pa-hal ampinom nin daya ko ay magpirmi ya kongko tan magpirmi koy namaot kona. ");
INSERT INTO xsb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","No pa-non lawah yan angkabyay yay Dios Ama a nanogo kongko tan lawah akoy namaot angkabyay bana kona, anorin anamaot kapara komoyo, hinoman a pa-hal mangan kongko ay mabyay bana kongko. ");
INSERT INTO xsb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Oliton ko, hiko yay pa-hal pa-mangan a nonaoy ibat ha langit. Ambo akon bilang yay pa-mangan manna a kinan lan kapapo-papoan tamo a ni-kati ot syimpri, nokay yay pa-hal makapangan konan yadtin pa-mangan a homin laloma no ambo hiko ay mabyay anggan-angga.” ");
INSERT INTO xsb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hinalita nadti ni Jesus hin nangaral ya ha sinagoga ha babalin Capernaum. ");
INSERT INTO xsb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Halban lan disipolos ni Jesus ay nakalngo anamaot konan yadtin totoro na, kanya lako konla a nanalita nin anodti, “Ya-rin totoro na ay mairap intindyon. Hino man wari a makababa manglongo ison?” ");
INSERT INTO xsb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Palibhasay tanda ni Jesus a ampanalamorom hiladtin dawdisipolos na, wana konla, “Nasora kamo wari ha hinalita ko? ");
INSERT INTO xsb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Balo-balo pay na no ma-kit moyo ko, hiko a Naglalaman Tawo nin ampamata-gay mako ha dati kon kamainan! ");
INSERT INTO xsb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yay hawhalita a hinalita ko komoyo ay ibat ha Ispirito nan Dios kanya ampakapamin biyay a homin anggawan. Nga-min, yay Ispirito nan Dios yay ampamin biyay; kay magawa odti nin tawo. ");
INSERT INTO xsb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kot main komoyon kay antompol kongko.” Na-halita ni Jesus yadti, ta paibat ot hin ibat ay tanda nay na no hinoy kay antompol kona tan no hinoy magtraidor kona. ");
INSERT INTO xsb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wana ot ni Jesus, “Kanya naor imbalita ko komoyo a homin maari domani kongko no kay na ya idani kongko nin Ama ko.” ");
INSERT INTO xsb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Paibat hin ya-rin, lako konlan laloma ot a dawdisipolos ni Jesus a binomokot ana kona tan kay ana hinomonol kona. ");
INSERT INTO xsb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hawanin, wani Jesus konlan labinloway apostolis na, “Hapa hikamo, labay moyoy namaot wari omalih?” ");
INSERT INTO xsb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hi Simon Pedro a inombat, wana kona, “Katawan, hino man ot wari a kaon mi? Iti komoy hawhalita a ampakapamin biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ampi-pol kami tan sigorado kami a hika yay Cristo, yay Anak nan Dios a lawah angkabyay.” ");
INSERT INTO xsb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Wani Jesus nin in-obat konla, “Pinili katamoy labinlowa, balo ta a-sa komoyo ay ampango-nawan ni Satanas.” ");
INSERT INTO xsb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yay antokoyon na ay hi Judas Iscariote a anak ni Simon, palibhasa hiyay naor a magtraidor koni Jesus, anta a-sa ya konlan labinloway apostolis. ");
INSERT INTO xsb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pa-makayari nin ya-rin, nako hi Jesus ha intiron probinsyan Galilea nin nangaral kalamo hilay disipolos na. Kay na yapon labay mako ha probinsyan Judea bana ta labay la yan patyon nin hilay pawpoon nin Israelita itaw. ");
INSERT INTO xsb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hin ya-rin ay madani nay naman a pista nin Israelita a angkotanawon Pistan Tolda. ");
INSERT INTO xsb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kanya wanla koni Jesus nin hilay talakaka nan lawlalaki, “Omalih kay na iti ta mako kay namaot ha Judea, pigaw ma-kit lan dawdisipolos mo a mawmilagron anggaw-on mo itaw. ");
INSERT INTO xsb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nga-min, homin tawon mamiari nin gawgawa na no labay nan mibantog. Kanya no ampakagawa kay nan lamang mawmilagro, ipa-kit moy na ingat ha halban tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Hinalita ladti nin hilay tawtalakaka ni Jesus ta pati hila ay kay antompol kona.) ");
INSERT INTO xsb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kot wani Jesus konla, “Kay ot naabot a panaon ko para mako, kot hikamo maskin anya mag-oras ay maari kamon mako itaw. ");
INSERT INTO xsb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kay la kamo antiplonon nin hilay tawtawon makamondo, kot hiko, antiplonon la ko bana ta ampaptogon ko a yay gawgawa la kot doka. ");
INSERT INTO xsb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mako kamoy nan kipista. Kay ko yapo maki-ka ta kay ot naabot a panaon a dapat akon mako.” ");
INSERT INTO xsb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ha anorin a hinalita na ay nagpaka-bati ya yapon ha Galilea. ");
INSERT INTO xsb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kay naboyot, hin nakaalih hilay nay tawtalakaka ni Jesus a lawlalaki para mako ha pista, nako yay namaot, kot homin magtanda ta bilang sikritoy pa-mako na. ");
INSERT INTO xsb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Itaw ha pista ay antingkapon la ya nin hilay pawpoon nin Israelita. Wanla ha a-sa tan a-sa, “Ayti ya kari?” ");
INSERT INTO xsb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lako a an-ianah-anah lan tawtawo tongkol kona. Main ampamibalita a “Labah yan tawo.” Wanlay namaot laloma, “Ambo ta an-italon nay tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Anorin man, homin tawon magkohaw nakom manotol tongkol kona ha pobliko, bana ta ampi-kali-mo hila konlan pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kot hin na-kapiknaan anay manglinggon Pistan Tolda, nako hi Jesus ha timplo ta nangaral ya itaw. ");
INSERT INTO xsb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Naka-ngap hilay pawpoon nin Israelita, wanla, “Anongkot hay donong na anta kay yay namaot nag-aral?” ");
INSERT INTO xsb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kot wani Jesus konla, “Yay an-itoro ko ay kay nangibat ha sarili ko nokay nangibat konan nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hinoman a malabay homonol ha kalabayan nan Dios ay ma-tandaan na no yay an-itoro ko kot ibat ha Dios o ibat bongat ha sarili kon kaisipan. ");
INSERT INTO xsb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nga-min, yay tawon ampanalita nin yadtaw ibat bongat ha sarili nan kaisipan ay yay sarili na a labay nan mapori. Kot yay tawon ampag-inakit nin mapori yay nanogo kona ay maptog ya tan kay ya anggomwa nin ambo tama. ");
INSERT INTO xsb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ambo doman inimbi ni Moises a kawkapanogoan nan Dios komoyo? Kot homin komoyon anhomonol ha kawkapanogoan. Anongkot labay moyo kon patyon?” ");
INSERT INTO xsb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wanlan in-obat nin hilay tawtawo kona hin ya-rin, “Nilooban ka lawon doka a ispirito. Hino kot a malabay mangmati komo?” ");
INSERT INTO xsb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wani Jesus konla, “Ninghan akon bongat namaabig ha Awlon Pa-mainawa, kot ampag-ispantawan moyoy nan halban. ");
INSERT INTO xsb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kot hikamo, binyan na kamo ni Moises nin kapanogoan a ipakogit a anak lomato a ikawalon awlo mayari yan iabing, (kot ambo ibat odti koni Moises nokay ogali lay na nin hilay o-nan kalimpapo-papoan tamo), kanya an-ipakogit moyoy naor a anak maskin mitaon ha Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Anggaw-on moyoy pa-makogit maskin Awlon Pa-mainawa pigaw kay ma-kontra yay kapanogoan ni Moises, anongkot man ta ampag-amotan moyo kon olo ha pa-maabig ko nin a-say tawo ha Awlon Pa-mainawa? ");
INSERT INTO xsb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ando kamo manosga ayon ha angka-kit moyon panlikol bongat. Kailangan paka-sorion moyo yapon pigaw mag-in tama a pa-nosga moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hin ya-rin ay main konlan taga syodad Jerusalem a nipapa-no, wanla, “Ambo doman yadti yay lalakin labay lan patyon? ");
INSERT INTO xsb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kot bilyon moyo, ampanoro ya ha pobliko kot kay la ya ansitawon. Angka-sigoro lay na wari nin hilay pawpoon tamo a hiyay na yay Cristo? ");
INSERT INTO xsb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kot sigoradon ambo ya, ta tanda tamoy ibatan nin ya-rin a tawo, kot no lomato yay Cristo, kay homin magtanda no ayti ya maibat.” ");
INSERT INTO xsb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanya, hin ya-rin a ampanoro hi Jesus ha timplo, imbalita na konla ha makhaw a bosis, “Bilbi moyo ko doman? Tanda moyo doman a pinangibatan ko? Yay pa-mako ko iti ay ambo kon sarilin kalabayan nokay inhogo ako, tan yay nanogo kongko ay talagan potog, balo ta ambo moyo yan bilbi. ");
INSERT INTO xsb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kot hiko, bilbi ko ya bana ta ibat ako kona tan hiyay naor a nanogo kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hin ya-rin ay labay la yay nan dakpon hi Jesus nin hilay pawpoon nin Israelita, kot homin nanampat kona bana ta kay ot naabot a panaon a intakda nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Anodtaw pa man, lako konlan tawtawo itaw a ni-pol a hiyay na yay Cristo, ta wanla, “Main ot wari makalato a Cristo a makagawa nin mas lako a milagro dinan ha anggaw-on nan yadtin tawo?” ");
INSERT INTO xsb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na-tandaan lan paw-Pariseo yay ampiaanahan lan tawtawo tongkol koni Jesus, kanya hila-rin a paw-Pariseo tan hilay pawpoon pari ay namihogo nin gawgwardya nin timplo para dakpon hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hawanin, wani Jesus ha tawtawo, “Daoto tanay panaon nin maipagkalamoan moyo ko, ta magbolta koy na itaw konan nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kot lomato a panaon a tingkapon moyo ko kot kay moyo ko ma-kit, ta kay kamo maka-ka ha kaon ko.” ");
INSERT INTO xsb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hawanin, wanlan hila-rin a pawpoon ha a-sa tan a-sa, “Ayti ya kari mako ta kay tamo ya kano ma-kit? Mako ya wari konlan kaparan Israelita a niboyak ha lawlogar lan ambo Israelita para mangaral yay namaot konlan ambo Israelita? ");
INSERT INTO xsb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Anya kari a labay nan totolon ha imbalita nan, ‘Tingkapon moyo ko kot kay moyo ko ma-kit, ta kay kamo maka-ka ha kaon ko.’” ");
INSERT INTO xsb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hin naabot a oltimo tan pinakaimportantin awlo nin Pistan Tolda, inomdong hi Jesus ha arapan lan tawtawo, ta wana ha makhaw a bosis, “Hinoman a malata ay mako ya kongko ta painomon ko. ");
INSERT INTO xsb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ayon ha nakasolat ha Masanton Kasolatan, yay hinoman a antompol kongko ay magkamain yan pa-hal hobol nin lanom ha nakom na, tan yadtin pa-hal lanom ay ampakapamin biyay a homin anggawan bi-sa milabwa ot ha kapara.” ");
INSERT INTO xsb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yay labay nan totolon ni Jesus ha pa-hal lanom a ampakapamin biyay a homin anggawan ay yay Masanton Ispirito nan Dios a tanggapon nin hilay antompol kona. Kot hin ya-rin ay kay ot naibi a Masanton Ispirito nan Dios palibhasay kay ya ot norong nabyay hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hin nalngo lan tawtawo ya-rin imbalita ni Jesus, lako konla a nanalita nin anodti, “Sigoradon yadti na yadtaw propitan impangako nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wanlay namaot laloma, “Hiyay na yay Cristo.” Kot wanla ot laloma, “Maari wari ha Galilea mangibat yay Cristo? ");
INSERT INTO xsb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ambo doman wana ha Masanton Kasolatan a maibat ha lipi ni Ari David yay Cristo, tan itaw ya iabing ha Betlehem a babalin kamainan ni Ari David?” ");
INSERT INTO xsb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kanya kay hilay na nanga-piasa-san opinyon a tawtawo tongkol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Main omno konla a labay la yay na komon dakpon, kot homin nagkohaw nakom nanakop kona. ");
INSERT INTO xsb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hawanin, nagbolta hilay gawgwardya nin timplo konlan pawpoon pari tan paw-Pariseo a namihogo konla para manakop koni Jesus. “Anongkot kay moyo ya inawit iti?” pastang lan hilay namihogo konla. ");
INSERT INTO xsb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wanlan in-obat nin gawgwardya, “Nika-ka-noman ay homin ot tawon nanalita nin bilang kona!” ");
INSERT INTO xsb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wanlay naman paw-Pariseo, “Pati hikamo doman ay nailingoy na? ");
INSERT INTO xsb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Main kamoy na doman na-kit komin pawpoon o paw-Pariseo a tinompol kona? ");
INSERT INTO xsb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Homin! Hila bongat a tawtawon kay ampakaintindi ha kawkapanogoan nan Dios a antompol kona -- aw-inhompa na hilan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hin ya-rin, ison ya hi Nicodemo a a-sa ha gropo lan paw-Pariseo. Hiya odtaw nako koni Jesus a-say yabi. Hawanin, wana konlan kapara nan paw-Pariseo, ");
INSERT INTO xsb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ambo doman ayon ha kawkapanogoan nan Dios kontamo ay kay maari hosgawan a tawo nin kay ya yapon binistawan pigaw ma-tandaan no anya talagay ginwa na?” ");
INSERT INTO xsb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kot wanla kona, “Bilang kay namaot taga Galilea! Pag-aralan mon labah yay Masanton Kasolatan, ta ma-kit mo a homin propita a maibat ha Galilea.” ");
INSERT INTO xsb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bi-sa ni-porong hilay nay tawtawo ha kanya-kanya lan bali. ");
INSERT INTO xsb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hawanin, hi Jesus anamaot ay nako ha Bakil Olibo. ");
INSERT INTO xsb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kinadilapan, kapi-piboklah ot, nako yay naman ha timplo. Halban tawtawo ay dinomolog kona, kanya tinomoklo ya ta tinoroan na hila. ");
INSERT INTO xsb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tongwa, main omnoy mawmaistron kapanogoan tan paw-Pariseo a nangawit kona nin a-say babayin na-dakop ha pa-maki-lalaki. Pina-dong ladtin babayi ha arapan nin kalabongan. ");
INSERT INTO xsb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bi-sa wanla koni Jesus, “Maistro, yadtin babayi ay na-dakop yan ampaki-lalaki. ");
INSERT INTO xsb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ayon ha kapanogoan nan Dios a inimbi ni Moises kontamo, yay anodtin klasin babayi ay dapat batibaton nin bato anggan mati. Anya may ma-halita mo tongkol kona?” ");
INSERT INTO xsb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Anorin a imbalita la ta labay lan hobokon hi Jesus, pigaw magkamain hilan maikaso laban kona. Kot yay ginwa ni Jesus ay tinomook yan bongat, ta nanolat ya ha lota nin tamoro a impanolat na. ");
INSERT INTO xsb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bana ta patoloy ot syimpri a pamamastang la kona, inomdong ya, ta wana konla, “Hinoman komoyo a homin kasalanan, hiyay nay mo-nan mamatibat kona.” ");
INSERT INTO xsb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bi-sa tinomook yay naman hi Jesus ta nanolat yay naman ha lota. ");
INSERT INTO xsb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hin nalngo ladti, na-konsinsya hila,* kanya a-sa a-sa hilay nan inomalih paibat ha pinakamatokling anggan ha hoyot, kanya yay na-bati bongat ay hi Jesus tan yay babayi a naka-dong ha arapan lan kalabongan a tinoroan ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hin tinomangal hi Jesus ay homin yay nan na-kit konla, kanya wana konan babayi, “Ayti hila man anay malabay mamarosa komo? Homin doman na-bati konlan malabay manintinsya komo?” ");
INSERT INTO xsb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wanan babayi, “Homin, Maistro.” Wani Jesus kona, “Kay katay namaot sintinsyawan. Morong kay na, tan ando kay na magkasalanan oman.”* ");
INSERT INTO xsb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kay naboyot, nangaral yay naman hi Jesus ha tawtawo, wana, “Hikoy hawang nin tawtawo ha mondo. Hinoman a anhomonol kongko ay kay yay na magbiyay ha karobloman, ta yay hawang a makapamin biyay a homin anggawan ay iti na kona.” ");
INSERT INTO xsb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kot wanlan paw-Pariseo koni Jesus, “Hika mismoy ampamaptog tongkol ha sarili mo. Kanya kay mi matanggap a potog orin.” ");
INSERT INTO xsb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Wanay namaot ni Jesus konla, “Maski man ampamaptog ako tongkol ha sarili ko, potog anamaot yay an-ibalita ko, ta tanda koy pinangibatan ko tan tanda koy namaot yay kakaon ko. Kot hikamo, kay moyo tanda no ayti ko naibat tan no ayti ko mako. ");
INSERT INTO xsb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ampanosga kamo ayon ha klasin pa-nosga nin tawo. Kot hiko ay kay ko basta ampanosga ha hinoman. ");
INSERT INTO xsb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kot no manosga ko, tama a pa-nosga ko, ta ambo kapag hikoy ampanosga nokay kalamo ko yay Ama a nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tan ha kawkapanogoan nan Dios a ampanga-gotan moyo ay nakasolat a no ma-pi-togma a pa-maptog nin lowa katawo, ison ma-bilbi a potog a an-ibalita la. ");
INSERT INTO xsb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ampamaptog ako tongkol ha sarili ko, tan anorin kapara, yay Ama a nanogo kongko ay ampamaptog anamaot tongkol kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hin ya-rin, wanlan hilay paw-Pariseo kona, “Ayti kot a Ama mo?” Wanan in-obat ni Jesus, “Ambo moyo ko talagan bilbi ni yay Ama ko. No komon ta bilbi moyo ko, bilbi moyoy namaot komon a Ama ko.” ");
INSERT INTO xsb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Imbalita nadti ni Jesus hin nangaral ya ha timplo itaw ha danin ampamidaboan nin kwarta para ha Dios. Hin ya-rin, homin ot nagkohaw nakom nin manakop kona bana ta kay ot naabot a panaon a intakda nan Dios para kona. ");
INSERT INTO xsb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ninghan, hin ampangaral yay naman hi Jesus itaw ha timplo, wana, “Kay maboyot ay omalih ako, bi-sa ti-tingkapon moyo ko. Balo ta mati kamon kay na-patawad a main moyon kasalanan, tan kay kamo maka-ka ha logar a kaon ko.” ");
INSERT INTO xsb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hin ya-rin, wanlan Israelita, “Magpakamati ya wari, ta na-halita nan kay tamo maka-ka ha logar a kaon na?” ");
INSERT INTO xsb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kot wani Jesus konla, “Taga kamo iti ha lota, kot hiko, taga ko ha langit. Makamondo kamo, kot hiko ambo. ");
INSERT INTO xsb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ya-rin a bara-nan no anongkot imbalita ko komoyo a mati kamon kay na-patawad a kawkasalanan moyo. Nga-min, no kay kamo mi-pol a hiko kot naibat ha langit ay mati kamon kay na-patawad a kawkasalanan moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hawanin, wanla kona, “Hino ka kot talaga?” Wanan in-obat ni Jesus, “Yay imbalita koy na komoyo paibat ot hin ompisa. ");
INSERT INTO xsb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lako ot a maibalita tan maihosga ko komoyo. Biig potog odti ta yay nanogo kongko ay potog, tan yay an-ibalita ko komoyon tawtawo ha mondo ay yay nalngo ko kona.” ");
INSERT INTO xsb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kot kay la naintindyan nin aw-Israelita a yay antotolon ni Jesus ay tongkol konan Dios a Ama na. ");
INSERT INTO xsb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kanya wani Jesus konla, “Painsan, no hiko a Naglalaman Tawo kot ita-gay moyoy na ha kros ay itaw moyo maintindyan a hiko talagay inhogo nan Dios tan homin akon anggaw-on ha sarili kon kalabayan, nokay yay anhalitaon ko ay ayon ha intoro na kongko nin Ama ko. ");
INSERT INTO xsb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yay nanogo kongko ay kalamo-lamo ko. Kay na ko ampo-layan nin Ama, bana ta pirmi kon anggaw-on yay bawbagay a ka-palilikot kona.” ");
INSERT INTO xsb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hin imbalita nay anorin ni Jesus, lako a tinompol kona. ");
INSERT INTO xsb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bi-sa wani Jesus konlan Israelita a antompol ana kona, “No patoloy moyon honolon a tawtotoro ko, potog a dawdisipolos katamo, ");
INSERT INTO xsb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ma-bilbi moyo yay kaptogan, tan yay kaptogan a mangalih komoyo ha pa-makaalipon.” ");
INSERT INTO xsb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wanlan in-obat koni Jesus, “Lawlipi na kami ni Abraham, tan nika-ka-noman ay kay kami nag-in alipon nin hinoman. Anongkot hinalita mon maalih kami ha pa-makaalipon?” ");
INSERT INTO xsb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Obat ni Jesus, “Yay potog a potog, ibalita ko komoyo, hinoman a ampagkasalanan ay alipon nin kasalanan. ");
INSERT INTO xsb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yay a-say alipon ay ambo yan kalamo ha pamilya anggan-angga, kot yay a-say anak ay myimbro ya ha pamilya na anggan-angga. ");
INSERT INTO xsb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kanya, no yay Anak nan Dios a mamilibri komoyo ha kasalanan, talagan libri kamoy nan anggan-angga. ");
INSERT INTO xsb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tanda ko a lawlipi kamo ni Abraham, kot ha dobali nin ya-rin ay labay moyo ko syimprin patyon, bana ta kay moyo ambiyan logar a totoro ko ha main moyon kanakoman. ");
INSERT INTO xsb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yay an-ibalita ko ay yadtaw na-tandaan ko konan Ama ko ha langit. Hikamoy namaot ay anggaw-on moyoy na-tandaan moyo konan impagka-ama moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kot wanlay naman koni Jesus, “Hi Abraham a impagka-ama mi.” Kot wani Jesus konla, “No talagan lawlipi kamo ni Abraham, dapat komon yay gawgawa moyo ay bilang ha gawginwa na. ");
INSERT INTO xsb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Halako ta labay moyo kon patyon, anta an-ibalita kon bongat komoyoy kaptogan a na-tandaan ko konan Dios. Kay na gaw-on ni Abraham yay anorin. ");
INSERT INTO xsb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wangkoy naor, yay anggaw-on moyo ay bilang ha ginwa nan impagka-ama moyo.” Kot wanla kona, “Ambo kamin awa-nak ha likol, yay Dios bongat a ambilbion min Ama mi.” ");
INSERT INTO xsb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wani Jesus konla, “No komon ta yay Dios a an-ipag-Ama moyo, dapat komon labyon moyo ko ta nangibat ako kona. Kay ko nako iti ha sarili kon kalabayan, nokay inhogo na ko. ");
INSERT INTO xsb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tanda moyo doman no anongkot kay moyo angkaintindyan a an-ibalita ko? Bana bongat ta kay moyo labay long-on a hawhalita ko. ");
INSERT INTO xsb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hi Satanas a impagka-ama moyo, kanya yay labay-labay moyon gaw-on ay yay kalabayan na. Paibat hin ibat ay ma-mangmati yan tawo, tan angkomontra ha kaptogan bana ta disnodon homin logar a kaptogan kona. Kada ampanalita ya nin kagalotoyan, ya-rin a natoral na, palibhasay magalotoy ya tan hiyay ama nin halban kagalotoyan. ");
INSERT INTO xsb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kot hiko, palibhasay an-ibalita ko yay kaptogan, kanya kay moyo ko ampi-polon. ");
INSERT INTO xsb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hino man wari komoyo a maka-pibalita a hiko kot nakagwa kasalanan? No homin, ta kaptogan a an-ibalita ko, anongkot man ta kay moyo ko ampi-polon? ");
INSERT INTO xsb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hinoman a tawo nan Dios ay ampanglongo ha halita nan Dios. Kot hikamo, kanya kay kamo ampanglongo bana ta ambo na kamon tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hin ya-rin ay wanlan hilay Israelita koni Jesus, “Tawo kan lingoy katotpol a bilang konlan taga Samaria tan nilooban ka ot doka a ispirito.” ");
INSERT INTO xsb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Wanan in-obat ni Jesus, “Kay ko nilooban nin doka a ispirito ta anggomalang ako konan Ama ko ha langit, kot hikamo, amparorokaon moyo ko. ");
INSERT INTO xsb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kay ko ampaningkap pamomori para kongko, kot main ampaningkap nin pamomori para kongko, tan hiyay nay manosga. ");
INSERT INTO xsb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yay potog a potog, ibalita ko komoyo, hinoman a anhomonol ha hawhalita ko ay kay makaranas nin kamatyan mika-ka-noman.” ");
INSERT INTO xsb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wanlay naman kona nin hilay Israelita, “Hawanin, talagan na-paptogan mi nan nilooban kan doka a ispirito. Nga-min, maski man hi Abraham tan hilay pawpropita nan Dios ay ni-kati. Kot hika, anhalitaon mon hinoman a anhomonol ha hawhalita mo ay kay makaranas nin kamatyan mika-ka-noman. ");
INSERT INTO xsb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mas makapangyayari ka ot wari dinan konan kalimpapo-papoan tamon hi Abraham? Hiya tan hilay pawpropita nan Dios ay pari-parihon nati, kot hika, anya kot a labay mon palwahon no hino ka?” ");
INSERT INTO xsb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Wanan in-obat ni Jesus, “Mag-in homin kwinta no hikoy mamori ha sarili ko. Yay ampamori kongko ay yay Ama ko a anhalitaon moyon Dios moyo. ");
INSERT INTO xsb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Balo ta ambo moyo yan bilbi, kot hiko, bilbi ko ya. No halitaon kon ambo ko yan bilbi ay mag-in akon magalotoy a bilang komoyo. Kot yay potog, bilbi ko ya tan anhonolon koy hawhalita na. ");
INSERT INTO xsb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hi Abraham a ambilbion moyon kalimpapo-papoan ay maliga yan nana-gan ha kala-lato ko. Na-kit nay naor yadti, kanya nalilikot ya.” ");
INSERT INTO xsb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hawanin, wanlan Israelita kona, “Anta homin ka ot limampolo a taon, pa-no mo man na-kit hi Abraham?” ");
INSERT INTO xsb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wanan in-obat ni Jesus konla, “Yay potog a potog, ibalita ko komoyo, ba-yo ya ot in-abing hi Abraham, hiko ay hikoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Konan ya-rin a hinalita na a impantay nay sarili na ha Dios ay nangwa hilan bawbato a aw-Israelita ta labay la yay nan batibaton para patyon. Kot nakaari hi Jesus, bi-sa inomalih yay na ha timplo. Nagpa-wan ya ha pibotlayan lan malabong a tawo, kanya ya nakalikol. ");
INSERT INTO xsb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lo-gan anlalako hi Jesus kalamo hilay disipolos na, na-kit lay a-say lalakin bolag paibat hin in-abing. ");
INSERT INTO xsb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hawanin, pinastang la hi Jesus, “Maistro, hino kari a nagkasalanan ta in-abing yan bolag orin, hiya wari o hilay matoantawo na?” ");
INSERT INTO xsb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Wanan in-obat ni Jesus, “Yay pa-mag-in nan bolag ay ambo bana ta nagkasalanan ya o yay matoantawo na, nokay pigaw maipa-kit a kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kailangan gaw-on koy an-ipagawa nan Dios a nanogo kongko lo-gan pa-hal awlo ot, ta anlomato a panaon a pa-hal yabi a homin anan makagawa. ");
INSERT INTO xsb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lo-gan iti ko ot ha mondo, hikoy hawang nin tawtawo ha mondo.” ");
INSERT INTO xsb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pa-makahalita nadti, nilomora ya ha lota, bi-sa inlaok nay lora na ha lota ta imponah na ha mata nan lalakin bolag. ");
INSERT INTO xsb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ba-yo wana kona, “Mako kan mila-moh itaw ha ampalyoan a anha-wayan Siloe.” (Yay labay totolon “Siloe” ay inhogo.) Nako yay naor nila-moh itaw, bi-sa norong yay nan ampaka-kit. ");
INSERT INTO xsb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hin na-kit la yan kawkaholibay na tan hilay datin ampaka-kit kona hin ampakilimoh ya ot, wanla, “Ambo doman yadti yay lalakin datin antoklo ison ta ampakilimoh?” ");
INSERT INTO xsb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Main nanalita a “Hiyay naor!” Balo ta wanlan laloma, “Ambo, kalopa nan bongat.” Hawanin, wanan yay main lalaman, “Hikodtaw datin bolag.” ");
INSERT INTO xsb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kanya wanla kona, “Pa-no ka man naka-kit?” ");
INSERT INTO xsb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wanan in-obat, “Yadtaw lalakin angkotanawon lan Jesus ay nano-pak nin lota, bi-sa na imponah ha loway mata ko. Wana kongko, ‘Mako kan mila-moh itaw ha ampalyoan a anha-wayan Siloe.’ Kanya nako kon nila-moh. Tongwa naor naka-kit akoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wanlay naman kona, “Ayti ya man ana?” “Kay ko tanda,” wanan in-obat. ");
INSERT INTO xsb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hawanin, inawit la yay datin bolag konlan paw-Pariseo. ");
INSERT INTO xsb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Awlon Pa-mainawa nga-min hin ya-rin nano-pak hi Jesus nin lota ta pinaabig na yay bolag. ");
INSERT INTO xsb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kanya pinastang la yay namaot nin paw-Pariseo no pa-no ya naka-kit. Wana konla, “Pinonahan nan to-pak a lota a loway mata ko bi-sa nila-moh ako, kanya ampaka-kit akoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hawanin, wanlan laloman paw-Pariseo, “Kay ya nangibat ha Dios yadtin tawo bana ta ampamaabig ya maskin Awlon Pa-mainawa.” Kot wanlan laloma, “No tawo yan bongat a makasalanan, pa-no ya wari makagawa nin anorin a ka-paka-ngap a bawbagay?” Bana konan yadti ay kay hilay na nanga-piasa-san opinyon. ");
INSERT INTO xsb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kanya pinastang la yay naman odtin datin bolag, wanla, “Hapa hika, anyay ma-halita mo tongkol kona ha hinalita mon pa-maabig na komo?” Wana, “A-sa yan propita nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kot kay la ot pini-pol nin pawpoon nin Israelita a talagan dati yan bolag ta bi-sa pinaabig, kanya impaha-wayan lay matoantawo na. ");
INSERT INTO xsb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wanlan impastang konla, “Yadti domay anak moyo, tan talaga doman in-abing yan bolag? Anongkot man ta ampaka-kit yay na hawanin?” ");
INSERT INTO xsb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Obat lan matoantawo na, “Iya, anak mi ya, tan talagan in-abing yan bolag. ");
INSERT INTO xsb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Balo ta kay mi tanda no anongkot ampaka-kit yay na hawanin tan no hinoy namaabig kona. Hiyay nay pastangon moyo ta hosto ya man ana ha idad. Makahalita yay namaot tongkol ha sarili na.” ");
INSERT INTO xsb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anodti imbalita lan matoantawo na bana ta angkali-mo hila konlan pawpoon nin Israelita. Nga-min, piniasa-sawan la a alihon ha pa-makamyimbro ha sinagoga la yay hinoman a mamibalita a hi Jesus kot yay Cristo. ");
INSERT INTO xsb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yadti bara-nan no anongkot wanlan matoantawo na a hosto yay na ha idad a anak la tan hiyay dapat pastangon. ");
INSERT INTO xsb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bana ta anodtaw, impaha-wayan la yay naman nin pawpoon nin Israelita yay lalakin datin bolag, ta wanla kona, “Alang-alang konan Dios, mangalimpotogan ka. Tanda mi a yadtaw tawo ay a-sa yan makasalanan.” ");
INSERT INTO xsb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wanan in-obat konla, “Kay ko tanda no makasalanan ya o ambo. A-say bagay bongat a tanda ko, bolag ako hin yadtaw kot hawanin ay ampaka-kit akoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pinastang la yan oman, wanla, “Anya kot talagay ginwa na komo? Pa-no na pinaabig a mata mo?” ");
INSERT INTO xsb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wanan in-obat konla, “Nayari koy nan imbalita komoyo, kot kay moyo syimpri pini-pol. Anongkot man ta labay moyon malngo oman? Labay moyo wari mag-in disipolos nay namaot?” ");
INSERT INTO xsb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hawanin, pinanalitaan la yan doka, wanla, “Hikay disipolo na. Hikami balo ay dawdisipolos ni Moises. ");
INSERT INTO xsb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tanda mi a kina-totol nan Dios hi Moises, kot ya-rin a tawo ay kay mi tanda no ayti ya nangibat.” ");
INSERT INTO xsb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hawanin, wanan in-obat nin yadtin datin bolag, “Ka-paispanta ya-rin a kay moyo tanda no ayti ya nangibat, ha dobali nin nagawa nan maka-kit akoy na. ");
INSERT INTO xsb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tanda tamo syimpri a kay na anlong-on Dios yay an-idawat nin tawtawon makasalanan, balo ta hilay tawtawon maptog a pa-magsamba la kona tan mahonol ha kalabayan na, hila-rin a anlong-on na. ");
INSERT INTO xsb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nika-ka-noman ay kay homin ot nalngo a main naka-paabig nin tawon in-abing bolag. ");
INSERT INTO xsb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kanya, no wari ta yadtin tawo kot kay ya inhogo nin Dios, homin yan magawa.” ");
INSERT INTO xsb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wanlan in-obat kona, “Halako mo kamin pangaralan, anta a-sa kan makasalanan paibat hin in-abing ka.” Bi-sa inalih la yay na ha pa-makamyimbro na ha sinagoga. ");
INSERT INTO xsb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na-tandaan ni Jesus yay pa-ngalih lan pawpoon nin Israelita konan lalakin datin bolag ha pa-makamyimbro na ha sinagoga la. Kanya hin na-kit na ya, wana kona, “Antompol ka doman ha Anak nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wanan in-obat nin yadtin lalaki, “Maistro, hino ya kot orin pigaw tompol ako kona.” ");
INSERT INTO xsb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wani Jesus kona, “Na-kit mo yay na, tan hiyay nay ka-totol mo hawanin.” ");
INSERT INTO xsb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wana koni Jesus, “Katawan, antompol ako komo.” Bi-sa nanalimokor yan sinomamba kona. ");
INSERT INTO xsb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wani Jesus, “Yay pa-mako ko iti ha kalotaan ay pangibatan a ma-pihiyay hilay tawtawon antompol ha Dios konlan kay antompol. Kanya hilay datin bolag a kaisipan ay ma-kit lay kaptogan, kot hilay ampagmahi-ban a wanlay angka-kit lay kaptogan ay mabolag ana ingat a main lan kaisipan.” ");
INSERT INTO xsb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Main paw-Pariseo itaw a nakalngo nin ya-rin hinalita ni Jesus, kanya wanla kona, “Labay mo doman totolon, bolag anamaot a kaisipan mi?” ");
INSERT INTO xsb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wani Jesus konla, “No komon ta bolag a kaisipan moyo, ambo moyo komon kasalanan a kay kamo antompol kongko. Kot bana ta wamoyoy angka-kit moyoy kaptogan, balo ta kay kamo syimpri antompol kongko, kanya kay ot naalih a kasalanan moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Hawanin, wani Jesus, “Yay potog a potog, ibalita ko komoyo, hinoman a anlomoob ha koral lan kawkarniro nin kay ampagpa-wan ha polta, nokay basta yay nan bongat lomoob nin ampoli ha ambo dapat pagpa-wanan ay a-sa yan mahiba tan tolisan. ");
INSERT INTO xsb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Balo ta yay ampagpa-wan ha poltan koral ay ya-rin talagay pastol nin kawkarniro. ");
INSERT INTO xsb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ampaloobon na yan bantay nin koral, tan anlong-on lan kawkarniro a bosis na. Anha-wayan na hila ha kanya-kanyan ngalan ta palikolon hila ha koral. ");
INSERT INTO xsb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bi-sa, no nailikol na hilay na, ampango-nawan na hilay nan mako ha pagpastolan, ta bi-sa an-omaloyon hilay nay kawkarniro kona, palibhasay bilbi lay bosis na. ");
INSERT INTO xsb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kay hila homonol ha laloman tawo, nokay masbali ampolayo hila ta ambo lan bilbi a bosis.” ");
INSERT INTO xsb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tinotol ni Jesus odtin alimbawa konla, kot kay la naintindyan a labay nan totolon. ");
INSERT INTO xsb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kanya wana ot ni Jesus konla, “Yay potog a potog, ibalita ko komoyo, hiko ot yay pa-hal poltan koral lan kawkarniro. ");
INSERT INTO xsb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Halban lan ni-po-na kongko a ampagkonwari inhogo na hilan Dios ay pa-hal mangahiba tan tawtolisan, kot hilay pa-hal kawkarniro ay kay hila hinomonol konla. ");
INSERT INTO xsb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Oliton ko, hiko yay pa-hal poltan koral. Hinoman a pa-hal karniro a lomoob ha koral nin magpa-wan kongko ay malipyas, bi-sa libri yan lomoob-lomikol ha koral tan maka-romog yan magandan pastolan. ");
INSERT INTO xsb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kot yay tawon maialimbawa ha mahiba ay mako yan bongat ha kawkarniro para maniba, mangmati tan manira. Hiko balo ay nako ko iti ha kalotaan para ma-biyan hilan biyay, yay biyay a sangkagandawan.” ");
INSERT INTO xsb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Wanay naman ni Jesus, “Hiko yay labah a pastol. Bilang a-say labah a pastol ay an-ibi koy biyay ko alang-alang konlan kawkarniro ko. ");
INSERT INTO xsb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kot yay tawon pa-hal an-opaan bongat ay hakalako, bana ta ambo yan potog a pastol tan ambo nan ikon a kawkarniro. No main yan ma-kit anlomato a mabayanin ason talon, ibati nay kawkarniro ta molayo ya. Kanya yay mangyari ay main makwa konlan ampastolan na tan hilay lawlaloma ay miboyak. ");
INSERT INTO xsb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ibati nay nan bongat a kawkarniro palibhasay an-opaan yan bongat kanya kay na hila an-ipag-inakit. ");
INSERT INTO xsb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Oliton ko, hiko yay labah a pastol. Bilbi ko hilay aw-ikon ko, tan bilbi la koy namaot. ");
INSERT INTO xsb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Anorin ot bongat komi ni Ama ko, bilbi na ko tan bilbi ko yay namaot. Handa kon ibi a biyay ko alang-alang konlan pa-hal kawkarniro ko. ");
INSERT INTO xsb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Main ako ot lawlaloman pa-hal karniro a kay ot nailoob konan yadtin pa-hal koral ko. Kailangan iloob ko hilay namaot ta bi-sa long-on la ko. No anorin, asa-sa hilay nay pa-hal ampastolan ko, tan asa-say namaot a pastol la. ");
INSERT INTO xsb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kanya na ko anlabyon nin Ama ay bana ta an-ibi koy biyay ko alang-alang konlan pa-hal kawkarniro ko. Ibi koy biyay ko, ambo bongat para mati nokay para mabyay ot oman. ");
INSERT INTO xsb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Homin maari mangwan biyay ko, nokay losob ha nakom kon an-ibi odti. Main akon kapangyarian nin ibi yadti tan kowon oman. Yadti a impanogo nan Ama ko kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bana konan yadtin imbalita ni Jesus, kay anaman nanga-piasa-sa a opinyon lan hilay pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wanlan karamilan konla, “Nilooban yan doka a ispirito, kanya hira anay olo na. Anongkot manglongo tamo ot kona?” ");
INSERT INTO xsb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kot wanlan laloma, “Yay anhalitaon na ay ambo hawhalita nin tawon nilooban doka a ispirito. Main wari doka a ispirito a maka-paabig nin bolag?” ");
INSERT INTO xsb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kay naboyot, nakalato anaman a anibirsaryo nin timplo ha Jerusalem. Panaon layop hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hi Jesus ay anlalako itaw ha timplo konan yay anha-wayan Balkon ni Ari Solomon. ");
INSERT INTO xsb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tongwa, piniroropongan la yan pawpoon nin Israelita, ta wanla kona, “Anggan maka-no mo kami ot kari pata-ganon nin ma-bilbi no hino kan talaga? No hika talaga yay Cristo, ibalita mo pay na komi nin malino.” ");
INSERT INTO xsb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Wanan in-obat ni Jesus konla, “Imbalita koy na komoyo, kot kay moyo ampi-polon. Yay mawmilagron an-ipagawa na kongko nin Ama ko ay ampamaptog tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kot kay kamo ampi-pol bana ta ambo kamon kabilang ha pa-hal kawkarniro ko a bilang imbalita koy nay naor komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Hilay pa-hal kawkarniro ko ay ampanglongo kongko. Bilbi ko hila, tan anhomonol hila kongko. ");
INSERT INTO xsb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ambiyan ko hilan biyay a homin anggawan, tan mika-ka-noman ay kay hila miparoka nin mi-ka ha impyirno. Kay homin anamaot maari makahamham konla ha gamot ko. ");
INSERT INTO xsb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Impa-taya na hila kongko nin Ama ko a makapangyayari ha halban, tan disnodon homin anamaot makahamham konla ha gamot nan Ama ko. ");
INSERT INTO xsb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Hiko tan yay Ama ay asa-sa.” ");
INSERT INTO xsb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bana konan yadtin hinalita ni Jesus, nangwa hilay naman bawbato a pawpoon nin Israelita para batibaton hi Jesus anggan mati. ");
INSERT INTO xsb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kot wani Jesus konla, “Lako a impa-kit ko komoyon gawgawa kaabigan a impagawa na kongko nin Ama ko. Ayti man wari ison ha nagawa ko a bara-nan ta labay moyo kon basyowon bato?” ");
INSERT INTO xsb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wanlan in-obat nin hila-rin a pawpoon, “Ambo bana ha gawgawa mon kaabigan a labay mi kan basyowon, nokay bana ha pa-masta-basta mo ha Dios. Anta tawo kan bongat, ampagkonwari kan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kot wani Jesus konla, “Ambo doman ha kawkapanogoan nan Dios a ampanga-gotan moyo ay main nakasolat a wanan Dios ha hawhowis, ‘An-ibalita ko a dawdios kamo.’ ");
INSERT INTO xsb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tanda tamo a yay Halita nan Dios ay kay mabali. Hawanin ta imbalita na konlan hila-rin hawhowis a dawdios hila, ta yay dawdisisyon a inimbi la ay ibat kona, ");
INSERT INTO xsb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","anongkot man ta anhalitaon moyon ambasta-bastawon koy Dios konan yay hinalita kon Anak na kon Dios, anta intatala na kon ihogo iti ha kalotaan? ");
INSERT INTO xsb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No komon ta kay ko anggaw-on yay gawgawa a an-ipanogo na kongko nin Ama ko, ison ay kay moyo ko dapat pi-polon. ");
INSERT INTO xsb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kot bana ta anggaw-on koy naor a pawpinanogoan na kongko, maski man kay moyo ko ampi-polon, mi-pol kamo tana ha gawgawa ko pigaw maintindyan moyo tan ma-pi-pol a yay Ama ay iti kongko, tan hiko ay iti konan Ama.” ");
INSERT INTO xsb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hin ya-rin ay labay la yay naman komon dakpon hi Jesus, balo ta nakaiwas ya syimpri konla. ");
INSERT INTO xsb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nako yay naman hi Jesus tan hilay disipolos na ha dobali nin Kabatwan Jordan, itaw ha logar a ampamaotismowan ni Juan Bautista hin o-na. Itaw hila yapon nagpirmi. ");
INSERT INTO xsb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lako a tawtawon ni-pako kona itaw, a wanla, “Hi Juan Bautista ay homin yan ginwa mawmilagro, balo ta halban imbalita na tongkol koni Jesus ay potog.” ");
INSERT INTO xsb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kanya lako a tawtawo itaw a tinompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hin yadtaw ay main a-say lalakin nagmasakit a hi Lazaro a taga baryon Betania. Talakaka la ya ni Marta tan hi Maria. ");
INSERT INTO xsb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yadti hi Maria a namibo-bo nin pabanglo konan Katawan ta bi-sa pinonahan na ot nin habot na yay ayi na. ");
INSERT INTO xsb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hin ya-rin anaor a nagmasakit hi Lazaro, namihogo hiladtin mitalakaka koni Jesus, ta wanla, “Katawan, main masakit yay anlabyon mon amigo.” ");
INSERT INTO xsb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hin nalngo nadti ni Jesus, wana, “Yadtin masakit ni Lazaro ay kay mangangga bongat ha kamatyan, nokay nangyari yadti pigaw ma-parangalan yay Dios, tan ha anorin a paralan ay ma-parangalan akoy namaot, hiko a Anak nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hiladtin mita-talakakan Marta, Maria tan Lazaro ay pari-parihon anlabyon ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Anodtaw pa man, hin na-balitaan nadtin pa-magmasakit ni Lazaro, namaonggan ya ot loway awlo itaw ha logar a kina na. ");
INSERT INTO xsb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pa-makayari, wani Jesus konlan disipolos na, “Magbolta tamoy na itaw ha probinsyan Judea.” ");
INSERT INTO xsb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kot wanlan disipolos na, “Maistro, naka-no bongat odtaw labay la kan batibaton bato nin pawpoon tamon Israelita. Anongkot man ta mako kay naman itaw?” ");
INSERT INTO xsb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Wanan in-obat ni Jesus a imparalan ha alimbawa, “Ambo doman main labinloway oras a mahawang ha a-say awlo? Kanya yay tawon pa-hal anlomalakon awlo ay kay ya ampiba-tol palibhasay angka-kit nay hawang ha mondo. ");
INSERT INTO xsb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kot hinoman a pa-hal anlomalakon yabi ay ampiba-tol ya bana ta homin yay hawang kona.” ");
INSERT INTO xsb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pa-makahalita nadti ni Jesus, wana ot, “Hi Lazaro a amigo tamo ay angka-lok. Kaon ko ya ta pokawon.” ");
INSERT INTO xsb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanlan disipolos kona, “Katawan, labah no-nin no angka-lok ya, ta omabig yay na.” ");
INSERT INTO xsb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yay labay na paytin totolon ni Jesus ay nati na hi Lazaro, kot hay wanlan disipolos na ay talagan angka-lok yan bongat. ");
INSERT INTO xsb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kanya malino nay nan imbalita ni Jesus konla, wana, “Nati yay na hi Lazaro. ");
INSERT INTO xsb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kot bana komoyo ay maliga kon kay ko itaw hin nati ya ta pigaw mas lalo kamon tompol kongko. Kanya mako tamoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hin ya-rin, hi Tomas a anha-wayan Kambal ay wana konlan kapara nan disipolos, “Sigi, maki-ka tamo kona maskin anggan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pa-makalato ni Jesus tan hilay disipolos na ha baryon Betania, na-tandaan na a a-pat a awlo yay nan naitabon hi Lazaro. ");
INSERT INTO xsb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yay baryon Betania ay madani ha syodad Jerusalem, manga toloy kilomitro bongat a distansya. ");
INSERT INTO xsb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lako konlan Israelita a taga Jerusalem a nako para maki-damay-damay konli Marta tan Maria ha pa-ngamati nin talakaka lan hi Lazaro. ");
INSERT INTO xsb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pa-makalngo ni Marta a ampakalato hi Jesus, hinakbat na ya, kot hi Maria ay na-bati ya ha bali la. ");
INSERT INTO xsb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Wani Marta koni Jesus, “Katawan, no komon ta iti ka hin ya-rin, kay ya komon nati a talakaka ko. ");
INSERT INTO xsb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Anodtaw pa man, tanda ko syimpri a maski hawanin, anyamay dawaton mo konan Dios ay ibi na komo.” ");
INSERT INTO xsb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wani Jesus kona, “Mabyay yan oman a talakaka mo.” ");
INSERT INTO xsb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Wani Marta kona, “Tanda kon morong ya ot mabyay ha hoyot a awlo a pabyayon oman hilay nawni-kati.” ");
INSERT INTO xsb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Wani Jesus kona, “Hikoy ampamaorong mabyay tan yay ampamin biyay. Hinoman a antompol kongko, anggano man mati ya ay mabyay ya ot oman. ");
INSERT INTO xsb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tan hinoman a ampagbiyay nin antompol kongko ay kay mati mika-ka-noman. Ampi-polon mo doman yadti?” ");
INSERT INTO xsb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wani Marta, “Iya, Katawan, ampi-polon ko a hika yay Cristo, yay Anak nan Dios a impangako nan ihogo iti ha kalotaan.” ");
INSERT INTO xsb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pa-makahalita nadti ni Marta, norong yan domali ta kina nay talakaka nan hi Maria, ta wanan in-anah, “Nakalato yay nay Maistro. An-ipa-ka na ka.” ");
INSERT INTO xsb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hin nalngo nadti ni Maria, inomdong yan tampol para hakbaton hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Hin ya-rin ay itaw hila ot ni Jesus ha likol nin baryo, ha logar a pinanakbatan ni Marta kona.) ");
INSERT INTO xsb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hilay Israelita a ampaki-damay-damay konli Maria, hin na-kit lan inomdong yan tampol ta bi-sa nilomikol ay tinombokan la ya. Hay wanla no mako ya ha pinanabonan para tomangih itaw. ");
INSERT INTO xsb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hin nakalato hi Maria itaw ha kamainan li Jesus, nanalimokor ya ha arapan na, ta wana kona, “Katawan, no komon ta iti ka hin ya-rin, kay ya komon nati a talakaka ko.” ");
INSERT INTO xsb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hin na-kit ni Jesus a antomangih hi Maria pati hilay Israelita a naki-ka kona, nabagbag a kanakoman na tan nilomolo ya. ");
INSERT INTO xsb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Bi-sa wana konla, “Ayti moyo ya inigwa?” Wanlan in-obat, “Katawan, ki-ka ka ta biliwon mo.” ");
INSERT INTO xsb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hin ya-rin ay tinomangih hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wanlan Israelita, “Talagan inaro na hi Lazaro.” ");
INSERT INTO xsb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kot wanlan laloma, “Namaabig yan bolag, anongkot man ta kay ya ginomwa paralan pigaw kay ya komon nati hi Lazaro?” ");
INSERT INTO xsb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nabagbag anaman a kanakoman ni Jesus pa-makalato na ha pinanabonan koni Lazaro. Yadti ay a-say kwiba a hinaraan nin mahi-ban a bato. ");
INSERT INTO xsb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Bi-sa wani Jesus, “Alihon moyoy bato.” Kot wani Marta a talakaka nan yadtin nati, “Katawan, sigoradon main anan angot hawanin, ta a-pat a awlo yay nan nati.” ");
INSERT INTO xsb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Wani Jesus kona, “Ambo doman imbalita ko komo a no mi-pol ka ay ma-kit moy kapangyarian nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hin ya-rin ay inalih lay naor yay bato a impanara ha pinanabonan koni Lazaro. Tinomangal hi Jesus ha langit, ta wana, “Ama, ampasalamat ako ta nilngo moy dawat ko. ");
INSERT INTO xsb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tanda ko a lawah mo kon anlong-on, anodtaw pa man, an-ibalita kodti alang-alang konlan tawtawo iti, pigaw mi-pol hila a hika a nanogo kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pa-makahalita nadti ni Jesus, wana ha makhaw a bosis, “Lazaro, lomikol ka.” ");
INSERT INTO xsb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nilomikol yay naor hi Lazaro nin nakakolkol ot ha gamot tan ayi na yay pinon tilan mapoti a pantabon, bi-sa nakahakob ot panyo a olo na. Wani Jesus ha tawtawo, “Alihon moyoy ingkolkol kona, pigaw libri yay na.” ");
INSERT INTO xsb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hawanin, hiladtaw Israelita a tinomombok koni Maria, lako konla a tinompol koni Jesus hin na-kit lay gawginwa na. ");
INSERT INTO xsb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kot balo hilay laloma ay nako konlan paw-Pariseo ta inhombon lay ginwa ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kanya hilay pawpoon pari tan hilay paw-Pariseo ay tinipon lay kawkapara lan myimbro nin pinakamata-gay a konsiho nin nasyon Israel, ta wanla, “Anyay gaw-on tamo? Yadtin tawo ay lako a anggaw-on nan mawmilagro. ");
INSERT INTO xsb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","No po-layan tamo ya, halban tawo ay mi-pol kona, ta bi-sa hilay tawtaga Roma a ampamoon kontamo ay mako iti ta hiraon lay Masagradon Timplo tamo pati yay main tamon nasyon.” ");
INSERT INTO xsb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kot yay a-sa konla a hi Caifas a pinakapoon pari hin ya-rin a taon ay wana konla, “Bilang kamon homin tanda. ");
INSERT INTO xsb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kay moyo doman angkaisipan a mas labah ot para kontamo a a-say tawo tanay mati para ha halban, dinan manganggawan a nasyon tamo?” ");
INSERT INTO xsb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yadtin imbalita ni Caifas ay hola a kay nangibat ha sarili nan kaisipan, nokay palibhasay hiyay naor a pinakapoon pari hin ya-rin a taon ay impanakom nan Dios kona a hi Jesus kot mati para ha halban Israelita, ");
INSERT INTO xsb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","tan ambo bongat para ha aw-Israelita, nokay paray namaot ha halban mag-in awa-nak nan Dios ha intiron mondo pigaw ma-piasa-sa na tamoy halban. ");
INSERT INTO xsb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kanya paibat hin ya-rin a awlo ay ampipapa-nowan lay na nin pawpoon nin Israelita no pa-no la maipapati hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bana konan yadti ay kay yay na ampagpa-kit hi Jesus ha probinsyan Judea. Nokay nako ya nin kalamo hilay disipolos na ha a-say babali a anha-wayan Efraim a madani ha disyirto, ta itaw hila yapo nagpirmi. ");
INSERT INTO xsb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hin ya-rin ay madani nay Pistan Pa-makalibri nin Israelita. Lako konlan Israelita a tawtaga probinsya a mahakbay nako ha syodad Jerusalem para gaw-on la yapon yay sirimonyan pa-manglinis nin sawsarili ba-yo hila makipista. ");
INSERT INTO xsb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hin ya-rin, hilay tawtawo itaw ha timplo ay antingkapon la hi Jesus, wanla ha a-sa tan a-sa, “Anyay wamo? Kay ya wari mako kipista?” ");
INSERT INTO xsb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nga-min, impanogo lan pawpoon pari tan paw-Pariseo a hinoman a magtanda nin kamainan na ay dapat ibalita konla pigaw maipadakop la ya. ");
INSERT INTO xsb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hin a-nom a awlo tana ba-yo Pistan Pa-makalibri ay nako hi Jesus kalamo hilay disipolos na ha baryon Betania a kamainan ni Lazaro, yay lalakin pinaorong nan nabyay. ");
INSERT INTO xsb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pinaghandaan la yan pangaponan hi Jesus itaw. Hi Marta a ampamidolog nin pa-mangan. Hi Lazaro namaot ay a-sa ya ha kawkarongo ni Jesus nin ampangan. ");
INSERT INTO xsb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hin ya-rin ay nangwa hi Maria nin kapikna litro nin mablin klasin pabanglo a poron nardo, bi-sa imbo-bo na ha ayi ni Jesus, ba-yo na pinonahan nin habot na. Yay lalo bali ay napno nin angot pabanglo. ");
INSERT INTO xsb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hawanin, yay a-sa konlan disipolos ni Jesus, hi Judas Iscariote a anak ni Simon tan hiyay magtraidor kona ay wana, ");
INSERT INTO xsb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Anongkot kay ingat inlako ya-rin a pabanglo ha alagan opa nin tolonyatos a awlo, ta bi-sa inimbi komon a na-paglakoan konlan mangairap?” ");
INSERT INTO xsb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Imbalita nadti, ambo bana ta an-ipag-inakit na hilay mangairap, nokay bana ta a-sa yan mahiba. Nga-min, hiyay ampiga-got nin kwarta la ta bi-sa ampangopitan nadti. ");
INSERT INTO xsb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kot wani Jesus, “Po-layan moyo yan bongat, ta yadtin ginwa na ay pa-miparihadoy na para ha pa-nabon kongko. ");
INSERT INTO xsb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hilay mangairap ay pirmi moyon maipagkalamoan, kot hiko, maantor tanay panaon a maipagkalamoan moyo ko.” ");
INSERT INTO xsb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lako syimprin Israelita a naka-tanda a itaw hi Jesus ha baryon Betania. Nako hila itaw, ambo bongat para biliwon hi Jesus, nokay labay lay namaot biliwon hi Lazaro a pinaorong nan nabyay. ");
INSERT INTO xsb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bana konan yadti, plinano lan pawpoon pari a patyon lay namaot hi Lazaro. ");
INSERT INTO xsb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nga-min, lako anay Israelita a inomalih konla ta tinompol hilay na koni Jesus bana ha pa-maorong nan nabyay koni Lazaro. ");
INSERT INTO xsb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kinadilapan, na-balitaan lan lako a tawon nakipista a mako hi Jesus ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kanya nampi hilan bawbolong kayon bilang itsoran bolong ongot, ta ginamit la para ipa-kit a main lan kaga-galang ha pananakbat la koni Jesus. Wanlan inho-holyak, “Viva! Poriwon yay Ari nin Israel a ampakalato ha ngalan nan Katawan!” ");
INSERT INTO xsb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Hin main yan na-kit hi Jesus a-say malago a asno ay pinagkabayowan na. Wanay naor ha Masanton Kasolatan, ");
INSERT INTO xsb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ando kamo mahalak, hikamoy tawtawo ha Sion, labay totolon Jerusalem. Bilyon moyo! Ampakalato yay nay Ari moyo Nin nakalolan ha kilaw asno.” ");
INSERT INTO xsb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Hin ya-rin, hilay disipolos ni Jesus ay kay la ot naintindyan a yadti kot nangyari ayon ha Masanton Kasolatan. Kot hin norong yay nan nabyay hi Jesus ay itaw lay na na-panomtoman a main anorin a nakasolat tongkol kona bi-sa anorin anaor a nangyari kona. ");
INSERT INTO xsb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Hawanin, hilay tawtawon naka-kit a pinaorong nan nabyay ni Jesus hi Lazaro hin hina-wayan na yay naor lomikol ha pinanabonan a namaptog tongkol konan yadti. ");
INSERT INTO xsb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kanya yadti a bara-nan no anongkot hinakbat la yan lako a tawtawo, bana anaor ta na-balitaan lay tongkol konan yadtin milagro. ");
INSERT INTO xsb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kanya wanlan paw-Pariseo ha a-sa tan a-sa, “Homin tamoy nan magawa. Bilyon moyo, halos halban tawtawo ay anhomonol ana kona.” ");
INSERT INTO xsb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hin ya-rin ay main anamaot ambo Israelita a nako nakipista ha syodad Jerusalem para somamba ha Dios. ");
INSERT INTO xsb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hawanin, nako hila koni Felipe a taga babalin Betsaida ha probinsyan Galilea a a-say apostol ni Jesus, ta wanla kona, “Sinyor, labay mi komon ma-paki-kitan hi Jesus.” ");
INSERT INTO xsb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hi Felipe ay nako ya yapo koni Andres a a-say kapara nan apostol, bi-sa lowa hilay nako namibalita koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wani Jesus konla, “Nakalato anay panaon a intakda para hiko a Naglalaman Tawo ay parangalan. ");
INSERT INTO xsb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yay potog a potog, ibalita ko komoyo, yay a-say bini nin trigo, no kay ya imola ta bi-sa kay manganggay biyay na bilang bini ay patoloy yan asa-sa. Kot no imola ya ta bi-sa manganggay nay biyay na bilang bini ay magkamain yan lako a bonga. ");
INSERT INTO xsb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hinoman a ampanglabi ha main nan biyay nin mas ot konan Dios ay kay na matanggap yay biyay a homin anggawan, kot hinoman a kay ampamabli ha main nan biyay iti ha lota ay matanggap nay biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hinoman a malabay magsirbi kongko ay kailangan homonol ya kongko. Bi-sa no ayti ko ay sigoradon itaw yay namaot, tan parangalan nan Ama ko yay hinoman a ampagsirbi kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wana ot ni Jesus, “Hawanin ay angkagoloy isip ko. Idawat ko wari konan Ama a ilipyas na ko ha an-arapon kon pa-magdya-dya? Kai, ta yadti bara-nan nin pa-mako ko iti.” ");
INSERT INTO xsb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kanya yay hinalita ni Jesus ay anodti: “Ama, ipatnag mon marangal a ngalan mo.” Tongwa, wanan bosis nan Dios a naibat ha langit, “Impatnag koy nay karangalan nin ngalan ko, tan ipatnag ko ot oman.” ");
INSERT INTO xsb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hin nalngo lan tawtawo itaw ya-rin bosis, wanlan laloma ay nangorol. Kot wanlay namaot laloma, “Kina-totol yan anghil.” ");
INSERT INTO xsb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wani Jesus in-obat konla, “Yadtaw bosis ay impalngo para komoyo, ambo para kongko. ");
INSERT INTO xsb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Panaon ana para sintinsyawan a tawtawo iti ha mondo a kay tinompol kongko, tan panaon anay namaot a idagrag hi Satanas a ampag-ari konla. ");
INSERT INTO xsb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Painsan no naita-gay akoy na ha kros ay ayaton koy halban tawo nin domani kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Imbalita nadti ni Jesus ta impatandaan na no pa-no ya mati.) ");
INSERT INTO xsb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wanlan in-obat nin lako a tawtawo itaw, “Ayon ha Libron Kawkapanogoan, yay Cristo a impangako nan Dios ay kay mati mika-ka-noman. Anongkot man anhalitaon mon hika a Naglalaman Tawo kot kailangan ita-gay ha kros? Hino man yay antotolon mon Naglalaman Tawo no hakalako ya konan yay Cristo?” ");
INSERT INTO xsb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Wani Jesus konla, “Hiko a hawang ay maantor tanay panaon a maipagkalamoan moyo. Mintras main ot hawang ay manigo kamoy na, ta no kai ay maabotan kamon doblom. Nga-min, yay tawon anlomalako ha karobloman ay kay na tanda no ayti ya mi-ka. ");
INSERT INTO xsb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mintras hiko a hawang kot iti ot komoyo ay tompol kamoy na kongko a hawang pigaw mag-in kamon tawtawon mahawang a kaisipan.” Pa-makahalita nadti ni Jesus ay inomalih yay na tan kay yay na yapon nagpa-kit konla. ");
INSERT INTO xsb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maskin na-kit lan aw-Israelita a kalakan mawmilagron gi-ginwa ni Jesus, karamilan konla ay kay tinompol kona. ");
INSERT INTO xsb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kanya pinomtog yadtin hinalita ni Propita Isaias a nakasolat, wana, “Katawan, homin ampi-pol ha an-ipangaral mi. Hino man wari a naka-bilbi ha main mon kapangyarian?” ");
INSERT INTO xsb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kanya yay nag-in ogotan la ay kay lay na magawa tompol a bilang anaor konan yadtin a-sa ot a imbalita ni Propita Isaias, a wanan nakasolat, ");
INSERT INTO xsb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pa-hal binolag nay na ingat Dios a mata la tan pinatiboy nay nakom la. No ambo anorin, ma-patnagan Tan maintindyan la komon a kapa-pa-hal la. Bi-sa, no mangombabali hila ta magbolta kongko, ilipyas ko hila.” ");
INSERT INTO xsb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Imbalita ni Propita Isaias yadti, ta tanda na hin yadtaw ot yay tongkol ha kapangyarian ni Jesus, kanya imbalita nadti tongkol kona. ");
INSERT INTO xsb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Anodtaw pa man, maski konlan pawpoon nin Israelita ay lako anamaot a tinompol koni Jesus. Kot kay lan bongat an-ipatandaan ta angkali-mo hila konlan paw-Pariseo, ta ola-no alihon hila ha pa-makamyimbro la ha sinagoga. ");
INSERT INTO xsb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nga-min, mas labay lan poriwon hilan tawtawo dinan poriwon na hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Wani Jesus ha makhaw a bosis, “Hinoman a antompol kongko ay ambo bongat hiko a ampi-polon na, nokay antompol ya syimpri konan nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tan yay tawon ampaka-kit kongko ay bilang nay nan angka-kit anamaot yay nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nako ko iti bilang hawang nin mondo pigaw hinoman a tompol kongko ay kay magpatoloy ha karobloman. ");
INSERT INTO xsb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yay tawon ampakalngo nin hawhalita ko balo ta kay na ampi-polon ay ambo hikoy manosga kona a makasalanan ya, bana naor ta kay ko nako iti ha mondo para manosga nokay para mamilipyas tawtawo. ");
INSERT INTO xsb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yay tawon ampamitakwil kongko tan kay anhomonol ha tawtotoro ko ay main laloman manosga kona a makasalanan ya, ta yay mismon halita ko a kay na hinonol yay mamipatnag a makasalanan ya. ");
INSERT INTO xsb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nga-min, yay an-ibalita ko ay kay nangibat ha sarili kon kanakoman, nokay yay Ama a nanogo kongko ay impanogo na no anyay halitaon ko tan ipatandaan. ");
INSERT INTO xsb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tanda ko a yay kapanogoan na ay makapamin biyay a homin anggawan. Kanya naor, yay an-ibalita ko ay yay an-ipapibalita na kongko nin Ama.” ");
INSERT INTO xsb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hin yabi ba-yo makalato a kaawlowan Pistan Pa-makalibri, tanda nay na ni Jesus a naabot anay panaon a hiya kot omalih ana ha mondo ta magbolta yay na konan Ama. Nilabi ni Jesus a pawpinili na iti ha mondo, tan hin ya-rin a yabi ay impa-kit na ot yadtin labi na konla anggan oltimo. ");
INSERT INTO xsb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hin ya-rin ay mayari hilay nan mangapon. Naipaisip nay na ni Satanas koni Judas Iscariote a anak ni Simon a pagtraidoran na hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tanda ni Jesus a impa-taya nan Ama konay halban bagay. Tanda na syimpri a inhogo na yan Dios tan magbolta yan oman kona. ");
INSERT INTO xsb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pa-makayari lan nangapon, inomdong hi Jesus ta inalih nay ayhing nan panlikol, bi-sa nangwa yan towalya ta inlamit na ha awak na. ");
INSERT INTO xsb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bi-sa namigwa yan lanom ha planggana ta inompisawan nan oyahan a aw-ayi lan dawdisipolos na, bi-sa na amponahan towalya a nakalamit kona. ");
INSERT INTO xsb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hin niabot yay na koni Simon Pedro, wani Pedro kona, “Katawan, anongkot hika ot a mangoyah ayi ko?” ");
INSERT INTO xsb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Wanan in-obat ni Jesus, “Kay mo ot angkaintindyan hawanin yay anggaw-on ko, balo ta maintindyan moy na painsan.” ");
INSERT INTO xsb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kot wani Pedro kona, “Mika-ka-noman, kay ko ipaoyah a ayi ko komo.” Wanay naman in-obat ni Jesus, “No kay ko oyahan a ayi mo, homin kan pa-makiasa-sa kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wani Pedro kona, “Katawan, no anorin no-nin, ambo bongat ayi ko, nokay pati na ingat gamot tan olo ko.” ");
INSERT INTO xsb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kot wani Jesus, “Yay tawon nalyo ay malinis anay intiron lalaman na. Ambo yay nan kailangan linisan poyra tana ha ayi. Hikamo ay malinis ana, balo ta ambo halban.” ");
INSERT INTO xsb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Imbalita nadti bana ta tanda na no hinoy magtraidor kona, kanya wanay naor a ambo halban kot malinis.) ");
INSERT INTO xsb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pa-makayari nan inoyahan ni Jesus a aw-ayi lan dawdisipolos na, inholot nan oman a ayhing nan panlikol, ta bi-sa nakirongo yay nay naman konla. Ba-yo wana konla, “Angkaintindyan moyo doman no anyay ginwa ko komoyo? ");
INSERT INTO xsb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Anha-wayan moyo kon ‘Maistro’ tan ‘Katawan’. Tama orin, ta Maistro tan Katawan moyo koy naor. ");
INSERT INTO xsb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kanya, no hiko a Katawan tan Maistro moyo ay nagpakaaypa nin nangoyah aw-ayi moyo, dapat kamoy namaot magpakaaypa ta pa-hal miooyahan kamon aw-ayi. ");
INSERT INTO xsb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Pina-kitan katamon alimbawa pigaw aligon moyoy bilang ha ginwa ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yay potog a potog, ibalita ko komoyo, yay a-say alila ay ambo yan mata-gay ha amo na. Anorin ot bongat kapara ha a-say inhogo, ambo yan mata-gay ha nanogo kona. ");
INSERT INTO xsb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","No angkaintindyan moyoy nadti, makalma kamo no gaw-on moyo. ");
INSERT INTO xsb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Balo ta ambo halban moyo a ampanotolan kon yadti, bana ta bilbi katamoy pawpinili ko. Kot kailangan pomtog odtin wana ha Masanton Kasolatan: ‘A-sa konlan kalamo kon nangan a magtraidor kongko.’ ");
INSERT INTO xsb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","An-ibalita koy nadti komoyo bi-sa mangyari pigaw painsan no mangyari na ay mi-pol kamo a hiko yay hiko. ");
INSERT INTO xsb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Yay potog a potog, ibalita ko komoyo, yay tawon mananggap ha hinoman a inhogo ko ay bilang ot bongat hikoy antanggapon na. Tan hinoman a ampananggap kongko ay bilang ot bongat yay nanogo kongko a antanggapon na.” ");
INSERT INTO xsb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pa-makahalita nadti ni Jesus, nilomolo ya, bi-sa imbalita nan diritsawan konla, wana, “Yay potog a potog, ibalita ko komoyo, a-sa komoyo a magtraidor kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nihihilap hilay disipolos na, ta kay la tanda no hinoy antokoyon na. ");
INSERT INTO xsb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hin ya-rin, yay disipolon ampaka-labyon ni Jesus ay nakailig ha dani na. ");
INSERT INTO xsb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Minostrawan na ya ni Simon Pedro, ta wana, “Pastangon mo no hino-rin antokoyon na.” ");
INSERT INTO xsb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kanya inomilig ya ha kolop ni Jesus, ta pinastang na ya, wana, “Katawan, hinoman orin a antokoyon mo?” ");
INSERT INTO xsb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Wanan in-obat ni Jesus, “Yay tawon ipamidoldol kon yadtin kapirason tinapay.” Hin indoldol nay naor a tinapay, intorol nadti koni Judas Iscariote a anak ni Simon. ");
INSERT INTO xsb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pa-makatanggap ni Judas nin yay tinapay, nilomoob hi Satanas kona. Bi-sa wani Jesus koni Judas, “Gaw-on moy nan tampol yay gagaw-on mo.” ");
INSERT INTO xsb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Ni a-sa konlan karongo ni Jesus hin ya-rin ay kay homin magtanda no anongkot imbalita nadtaw koni Judas.) ");
INSERT INTO xsb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kot bana naor ta hi Judas a ma-nga-got kwarta la, kanya hay wanlan laloma no an-ihogo na ya ni Jesus nin manaliw kawkailangan la para ha pista o mamin aboloy konlan mangairap. ");
INSERT INTO xsb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hin natanggap nay naor ni Judas yadtaw tinapay, inomalih yay nan tampol. Yabi na hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Hin nakaalih yay na hi Judas Iscariote, wani Jesus, “Hawanin anay panaon a ma-parangalan ako, hiko a Naglalaman Tawo, tan ma-parangalan anamaot yay Dios bana kongko. ");
INSERT INTO xsb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kanya bana naor ta ma-parangalan yay Dios bana kongko, parangalan na koy namaot nin Dios tan gaw-on nadtin tampol. ");
INSERT INTO xsb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mabli kon aw-amigo, daoto tanay panaon a maipagkalamoan moyo ko, ta bi-sa tingkapon moyo ko. Kanya yay imbalita ko konlan pawpoon tamon Israelita ay an-ibalita koy namaot hawanin komoyo: Kay kamo maka-ka ha kakaon ko. ");
INSERT INTO xsb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Hawanin, oyay ba-yon kasogoan a labay kon ibati komoyo: Milalabi kamo! No pa-no katamo nilabi ay anorin anamaot kapara a pa-milalabi moyo. ");
INSERT INTO xsb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma-bilbi nin halban tawtawo a dawdisipolos katamo no main kamon pa-milalabi.” ");
INSERT INTO xsb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wani Simon Pedro koni Jesus, “Katawan, ayti kot a kaon mo?” Wani Jesus, “Konan yadtin kakaon ko hawanin ay kay ka maka-paki-ka, kot main awlon homonol ka.” ");
INSERT INTO xsb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Wanay naman ni Pedro kona, “Katawan, anongkot kay ko maka-paki-ka hawanin? Handa ako man mati alang-alang komo!” ");
INSERT INTO xsb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wanan in-obat ni Jesus, “Magawa mo wari mati alang-alang kongko? Yay potog a potog, ibalita ko komo, ba-yo tomaran-ok a manok ay mitloy bisis mo kon iporlingor.” ");
INSERT INTO xsb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wana ot ni Jesus, “Ando kamo mag-aborido! Pomasimala kamo ha Dios, tan pomasimala kamoy namaot kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ha bali nan Ama ko ay main lako a maiwanan. No ambo anorin, imbalita koy na komon komoyo. Hawanin, mako ko itaw pigaw ihanda koy maiwanan moyo. ");
INSERT INTO xsb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","No itaw akoy na ta naihanda koy nay maiwanan moyo, magbolta ko iti ta kowon katamo, pigaw no ayti kamainan ko ay itaw kamoy namaot. ");
INSERT INTO xsb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tanda moyoy nay kaon ko, tan tanda moyoy namaot yay dalan nin mako itaw.” ");
INSERT INTO xsb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kot wani Tomas kona, “Katawan, kay mi tanda no ayti ka mako, pa-no mi man tanda a dalan mako itaw?” ");
INSERT INTO xsb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Wanan in-obat ni Jesus, “Hikoy dalan, kaptogan tan ampangibatan biyay. Kay homin maka-ka konan Ama no kay domalan kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No talagan bilbi moyo ko ay bilbi moyoy namaot ana yay Ama ko. Kanya paibat hawanin ay bilbi moyo yay na tan bilang moyo yay nan na-kit.” ");
INSERT INTO xsb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Wani Felipe kona, “Katawan, maipa-kit mo tana komi yay Ama, kontinto kami na.” ");
INSERT INTO xsb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Wani Jesus kona, “Felipe, naboyot moyo koy nan kalamo-lamo, kot ambo mo ko ot doman bilbi? Nga-min, hinoman a naka-kit kongko ay naka-kit anay namaot konan Ama. Anongkot man ta hinalita mo ot a ipa-kit ko komoyo yay Ama? ");
INSERT INTO xsb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kay mo doman ampi-polon a iti ko konan Ama, tan yay Ama ay iti ya kongko? Yay hawhalita a anhalitaon ko ay kay nangibat ha sarili kon kanakoman, nokay an-ipagawa na-rin nin Ama a iti kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pi-polon moyo ko a iti ko konan Ama tan yay Ama ay iti ya kongko. Kot no kay moyo ma-pi-pol a halita ko, pi-polon moyo ko tana bana ha ka-paka-ngap a gawgawa ko. ");
INSERT INTO xsb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yay potog a potog, ibalita ko komoyo, hinoman a antompol kongko ay makagawa yay namaot nin ka-paka-ngap a bawbagay a bilang ha anggaw-on ko tan holok ot ison, bana ta morong akoy na itaw konan Ama. ");
INSERT INTO xsb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Anyaman a dawaton moyo konan Ama ha ngalan ko ay gaw-on ko pigaw ma-parangalan yay Ama bana kongko a Anak na. ");
INSERT INTO xsb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kanya, no main kamon dawaton ha ngalan ko ay gaw-on ko-rin komoyo.” ");
INSERT INTO xsb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Wanan impagpatoloy ni Jesus, “No anlabyon moyo ko, honolon moyoy kawkapanogoan ko. ");
INSERT INTO xsb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Dawaton ko konan Ama a biyan na kamon a-say naman a Ma-mangwawali a magpirmi komoyo anggan-angga. ");
INSERT INTO xsb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yadti yay Masanton Ispirito nan Dios a mamitoro komoyo nin kaptogan. Kay la ya matanggap nin hilay tawtawon makamondo bana ta kay la ya angka-bilbi ni angkaintindyan. Kot hikamo ay ma-bilbi moyo ya bana ta mag-in moyo yan kalamoan tan magpirmi ya komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kay katamo ibati nin bilang aw-olila, bana ta magbolta ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Domali tanay panaon ay kay la koy na ma-kit nin hilay tawtawo ha kamondowan, balo ta hikamo ay ma-kit moyo kon oman. Tan bana ta mabyay akon oman, hikamo man ay mabyay kamoy namaot oman. ");
INSERT INTO xsb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Konan ya-rin a panaon ay ma-tandaan moyo a iti ko konan Ama ko, bi-sa hikamo ay iti kongko, tan hikoy namaot ay iti komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Hinoman a magtanda nin kawkapanogoan ko ta bi-sa anhonolon nadti ay ampanglabi kongko. Bi-sa, yay ampanglabi kongko ay labyon na yan Ama ko, tan labyon ko yay namaot tan magpabilbi akon hosto kona.” ");
INSERT INTO xsb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Hawanin, wani Judas kona (ambo hi Iscariote), “Katawan, anongkot hikamin bongat a pamipabilbian mon hosto, ambo pati hilay tawtawo ha mondo?” ");
INSERT INTO xsb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Wanan in-obat ni Jesus kona, “Hinoman a ampanglabi kongko ay anhonolon nay hawhalita ko. Labyon na yan Ama ko, tan hikami ni Ama ay mako magpirmi kona. ");
INSERT INTO xsb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kot yay tawon kay ampanglabi kongko ay kay anhonol ha hawhalita ko. Yay hawhalita a nalngo moyo kongko ay kay nangibat ha sarili kon kanakoman, nokay ibat konan Ama a nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“An-ibalita kodtin bawbagay komoyo lo-gan kalamoan moyo ko ot. ");
INSERT INTO xsb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Anodtaw pa man, yay Ma-mangwawali a ihogo nan Ama ko komoyo ha ngalan ko a homin laloma no ambo yay Masanton Ispirito na ay hiyay mamitoro komoyo nin halban bagay, tan hiyay mamipanomtom komoyo nin halban imbalita ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ambiyan katamon kaliswayan nakom a bilang ha kaliswayan nakom a iti kongko. Yadti ay ambo pariho ha angkaibi nin tawtawo ha kamondowan. Kanya ando kamo mag-aborido ni mali-mo. ");
INSERT INTO xsb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nalngo moyodtaw hinalita ko komoyo a ibati katamo balo ta magbolta kon oman komoyo. No talagan anlabyon moyo ko, dapat ikaliga moyoy hinalita kon mako ko konan Ama, ta mas makapangyayari ya dinan kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","An-ipa-pao-na koy nan an-ibalita yadtin halban komoyo ba-yo mangyari, ta pigaw tompol kamo kongko no mangyari anadtin halban. ");
INSERT INTO xsb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kay koy na maboyot maki-totol komoyo, bana ta anlomato yay na hi Satanas a poon nin kamondowan, kot homin yan kapangyarian kongko. ");
INSERT INTO xsb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Anodtaw pa man, anhonolon koy an-ipanogo nan Ama kongko pigaw ma-tandaan lan tawtawo a anlabyon ko yay Ama.” Pa-makahalita nadti ni Jesus, wana, “Sigi, mako tamoy na.” ");
INSERT INTO xsb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wana ot ni Jesus, “Hiko yay pa-hal potog a poon obas, tan yay Ama ko yay ma-ngalaga nin yadti. ");
INSERT INTO xsb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Balang pa-hal hanga ko a kay ampamonga ay ampo-tohon nan Ama. Balo ta balang hanga a ampamonga ay anlinisan na ta pigaw lalon mamonga. ");
INSERT INTO xsb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hikamo ay na-linisan ana bana ha hawhalita a hinalita ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kanya magpirmi kamo kongko ta magpirmi koy namaot komoyo. No pa-non yay hanga kot kay ya makapamonga no kay ya nakakabit ha poon, anorin anamaot kapara komoyo, kay makapamongan kaabigan a biyay moyo no kay kamo ampagpirmi kongko. ");
INSERT INTO xsb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Oliton ko, hiko yay pa-hal poon obas, tan hikamoy pa-hal hawhanga. Hinoman a ampagpirmi kongko ay ampagpirmi koy namaot kona, kanya mamongan lako a kaabigan a main nan biyay. Nga-min, homin kamon magawa a tama ha hilap nan Dios no nakahiyay kamo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yay tawon kay magpirmi kongko ay bilang ha hanga a ibantak ha likol ta pigaw malanoh. Yay anorin a hawhanga ay tiponon ta ibantak ha apoy para poolan. ");
INSERT INTO xsb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","No magpirmi kamo kongko tan yay hawhalita koy magpirmi komoyo, dawaton moyoy anyakaman a labayon moyo ta ibi komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma-parangalan yay Ama ko no lako a pa-hal bongan kaabigan nin biyay moyo, ta ha anorin ay ma-patnagan a hikamo kot dawdisipolos ko. ");
INSERT INTO xsb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","No pa-no na ko nilabi ni Ama ay anorin anamaot a pa-manglabi ko komoyo. Magpirmi kamo ha labi ko. ");
INSERT INTO xsb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","No anhonolon moyoy kawkapanogoan ko ay ampagpirmi kamo ha labi ko komoyo. Anorin anamaot kapara kongko, anhonolon koy kawkapanogoan nan Ama ko, kanya ampagpirmi ko ha labi na kongko. ");
INSERT INTO xsb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“An-ibalita kodti komoyo ta pigaw yay kaligawan ko ay patoloy anamaot ison komoyo tan mahostoy kaligawan moyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hawanin, oyay kasogoan ko komoyo: Milalabi kamo nin bilang pa-manglabi ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","No ha tawo, homin anan labi a homolok ot ha labi nin hinoman a ibi nay biyay na alang-alang ha aw-amigo na. ");
INSERT INTO xsb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aw-amigo katamo no anhonolon moyoy an-ipanogo ko. ");
INSERT INTO xsb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kay katamoy na ha-wayan ma-magsirbi bana ta kay na tanda nin ma-magsirbi no anyay anggaw-on nan amo na. Kot hikamo, aw-amigo anay ha-way ko komoyo, bana ta halban bawbagay a impatandaan nan Ama ko kongko ay impatandaan koy namaot komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ambo hikamoy namili kongko, nokay hikoy namili tan namihogo komoyo para mamongan kaabigan a biyay moyo, bi-sa yadtin bonga ay kay manganggawan. Kanya, anyaman a dawaton moyo konan Ama ha ngalan ko ay ibi na komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Oliton koy kasogoan ko komoyo: Milalabi kamo.” ");
INSERT INTO xsb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Wana ot ni Jesus, “No antiplonon la kamon tawtawon makamondo, dapat moyon panomtomon a hikoy o-na lan tiniplon. ");
INSERT INTO xsb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No komon ta kabilang kamo ot konlan tawtawon makamondo, labyon la kamo nin bilang kaasa-sa la. Kot bana ta ambo kamoy nan kabilang konlan tawtawon makamondo, palibhasay impolok katamoy naor konla, kanya antiplonon la kamo. ");
INSERT INTO xsb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Panomtomon moyodtaw imbalita ko komoyo a yay a-say alila ay ambo yan mata-gay ha amo na. Kanya, bana ta andamsakon la kon tawtawon makamondo ay damsakon la kamoy namaot. Kot no wari ta anhonolon lay hawhalita ko ay honolon lay namaot a hawhalita moyo. ");
INSERT INTO xsb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yadtin halban ay gaw-on la komoyo bana kongko, palibhasay ambo lan bilbi yay nanogo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No kay ko nako iti tan kay nangaral konla ay kay la komon maipagkasalanan a kay hila antompol kongko, kot hawanin balo ay homin hilay nan maipagbara-nan konan ya-rin a kasalanan la. ");
INSERT INTO xsb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hinoman a ampaniplon kongko ay antiplonon nay namaot a Ama ko. ");
INSERT INTO xsb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No kay ko hila pina-kitan nin ka-paka-ngap a bawbagay a kay magawa nin maskin hinoman, kay la komon maipagkasalanan a kay hila antompol kongko. Kot hawanin ay na-kit lay naor a gawgawa ko, balo ta antiplonon la ko syimpri pati yay Ama ko. ");
INSERT INTO xsb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Konan yadtin ampangyari kongko, angka-paptogan yay nakasolat ha Libron Kapanogoan nan Dios konla, a wana, ‘Antiplonon la kon kay homin bara-nan.’ ");
INSERT INTO xsb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kot main panaon a makalato ana yay Ma-mangwawali komoyo, ta ihogo koy nay Masanton Ispirito komoyo a maibat konan Ama a homin laloma no ambo yay Ispirito nin kaptogan. Pa-makalato na ay hiyay mamaptog tongkol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hikamo man ay mamaptog anamaot tongkol kongko, bana ta impagkalamoan katamo paibat hin nag-ompisa kon nanoro. ");
INSERT INTO xsb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yadtin halban ay an-ibalita ko komoyo pigaw kay moyo bokotan a main moyon katotpol. ");
INSERT INTO xsb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nga-min, yay gaw-on la komoyo ay alihon la kamo ha pa-makamyimbro moyo ha sawsinagoga. Iya, lomato a panaon a hinoman a mangmati komoyo, hay wana no ampagsirbiwan na yay Dios ha anorin a gawa na. ");
INSERT INTO xsb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gaw-on ladti komoyo palibhasay ambo la kon bilbi ni yay Ama. ");
INSERT INTO xsb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kot an-ibalita kodti komoyo ta pigaw no lomato anay panaon a gaw-on ladti komoyo, ma-panomtoman moyon naipa-pao-na koy nadti komoyo.” Wanan impagpatoloy ni Jesus, “Kay kodti imbalita komoyo hin o-na bana ta patoloy moyo ko ot an-ipagkalamoan. ");
INSERT INTO xsb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Hawanin ay morong akoy na konan nanogo kongko. Balo ta homin ni a-sa komoyon ampamastang no ayti ko mako. ");
INSERT INTO xsb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Masbali nilomolo kamoy na ingat bana ha bawbagay a imbalita ko komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kot ibalita ko komoyoy kaptogan: Yay kaaalih ko ay ikaabig moyo, ta no kay ko omalih ay kay ya mako komoyo yay Ma-mangwawali a homin laloma no ambo yay Ispirito nan Dios. Kot bana ta omalih akoy naor, kanya ihogo ko ya komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pa-makalato na ay ipatandaan na konlan tawtawon makamondo no anyay kasalanan la, no hinoy maptog tan no hinoy parosawan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yay ipatandaan nan kasalanan ay yay kay hila antompol kongko. ");
INSERT INTO xsb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yay ipatandaan nay namaot no hinoy maptog ay hiko ta morong ako konan Ama ko ta bi-sa kay moyo koy na ma-kit. ");
INSERT INTO xsb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tan yay ipatandaan na no hinoy parosawan nan Dios ay hilay tawtawon makamondo, ta nga-min hi Satanas a ampag-ari konla ay sinintinsyawan anan parosawan. ");
INSERT INTO xsb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lako ot komon a labay kon ibalita komoyo, kot kay moyo ot kababaan nin intindyon hawanin. ");
INSERT INTO xsb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Balo ta pa-makalato nin Ispirito nin kaptogan, labay totolon yay Ispirito nan Dios ay toroan na kamo ha halban kaptogan. Nga-min, yay ipatandaan na komoyo ay kay mangibat ha sarili na, nokay yadtaw bongat a impatandaan nan Dios kona a halitaon na a bilang ha bawbagay a mangyari ha lomato a panaon. ");
INSERT INTO xsb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Konan ya-rin ay parangalan na ko ta maibat kongko yay ipaintindyan na komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Halban ikon nan Ama ay ikon koy namaot, kanya hinalita ko a maibat kongko yay ipaintindyan na komoyo.” ");
INSERT INTO xsb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Wana ot ni Jesus, “Kay ana maboyot, kay moyo koy na ma-kit, bi-sa kay anaman maboyot ay ma-kit moyo kon oman. Nga-min, morong ako yapon konan Ama.” ");
INSERT INTO xsb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Main konlan disipolos na hin ya-rin a wanla ha a-sa tan a-sa, “Anya kari a labay nan totolon ha hinalita na kontamo a ‘Kay ana maboyot, kay moyo koy na ma-kit, bi-sa kay anaman maboyot ay ma-kit moyo kon oman,’ tan yay wana ot, ‘Nga-min, morong ako yapon konan Ama?’ ");
INSERT INTO xsb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Anya kari a labay nan totolon nin ‘kay ana maboyot’? Kay tanda no anyay labay nan totolon.” ");
INSERT INTO xsb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Hawanin, tanda nay na ni Jesus a labay la yan pastangon, kanya wana konla, “Ampipa-pa-nowan moyo ha a-sa tan a-sa no anyay labay kon totolon ha hinalita kon ‘Kay ana maboyot, kay moyo koy na ma-kit, bi-sa kay anaman maboyot ay ma-kit moyo kon oman.’ ");
INSERT INTO xsb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yay potog a potog, ibalita ko komoyo, tomangih kamo tan lomolo bana ha mangyari kongko, kot hilay tawtawon makamondo ay lomilikot. Kot hikamo, lomolo kamo man, balo ta ma-hagilyan ya-rin nin kaligawan. ");
INSERT INTO xsb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Kaalimbawaan ay a-say babayin mangangabing a malolo palibhasay ampanglayam ana, kot no nakapangabing yay na, ma-lingwanan nay nadtaw pa-ma-pailab na, bana ha kaligawan nan main ta naiabing ana ha mondo a anak na. ");
INSERT INTO xsb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","“Anorin anamaot kapara komoyo, malolo kamo hawanin, balo ta maki-pi-kit akon oman komoyo, kanya ma-ligawan kamon hosto, tan homin makaalih nin kaligawan moyo. ");
INSERT INTO xsb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Konan ya-rin a panaon, ambo anan hiko a panawatan moyo nokay yay Ama ana. Yay potog a potog, ibalita ko komoyo, ibi nan Ama komoyo yay anyakaman a dawaton moyo kona ha ngalan ko. ");
INSERT INTO xsb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Anggan hawanin ay homin kamo ot indawat kona ha ngalan ko. Domawat kamo ta makatanggap kamo pigaw mahostoy kaligawan moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Wanan impagpatoloy ni Jesus, “Ampigamit akon aw-alimbawa ha pa-mitoro ko komoyo. Kot lomato a panaon a kay koy na migamit nin aw-alimbawa, nokay toroan katamoy na tongkol konan Ama nin diritsawan. ");
INSERT INTO xsb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Konan ya-rin a panaon ay domawat kamoy na konan Ama ha ngalan ko. Kay ko an-ibalita a domawat ako konan Ama para komoyo. ");
INSERT INTO xsb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nga-min, mismon yay Ama ay anlabyon na kamo, bana ta anlabyon moyo koy naor tan ampi-polon a inhogo na kon Dios. ");
INSERT INTO xsb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naibat ako konan Ama bi-sa nako ko iti ha mondo. Hawanin ay omalih ako ha mondo ta morong akoy na konan Ama.” ");
INSERT INTO xsb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wanlan disipolos na hin ya-rin, “Hawanin diritsawan anay pa-mipalino mo komi, ta kay moy na an-iparalan ha alimbawa. ");
INSERT INTO xsb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hawanin angkaintindyan mi na a tanda moy halban bawbagay, kanya ambo anan kailangan pastangon ka ot nin hinoman. Kanya ampi-pol kami a talagan inhogo na kan Dios.” ");
INSERT INTO xsb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Wanan in-obat ni Jesus konla, “Ampi-pol kamoy na doman kongko hawanin? ");
INSERT INTO xsb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kot balo, lomato a panaon, tan ampag-ompisay na hawanin a hikamo kot miboyak ta mi-porong kamoy na ha sawsarili moyon bali ta ibati moyo ko. Anorin man, ambo akon asa-sa ta kalamo ko yay Ama. ");
INSERT INTO xsb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","An-ipatandaan koy nadti komoyo ta pigaw main kamon kaliswayan nakom ha pa-makiasa-sa moyo kongko. Iti ha mondo ay dalanan moyoy kawkadya-dyaan, balo ta pakhawon moyoy nakom moyo ta tinalo koy na yay karokaan ha mondo.” ");
INSERT INTO xsb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pa-makayari nan imbalita ni Jesus orin bawbagay, tinomangal ya ha langit, ta wanan indawat, “Ama, nakalato anay oras para ipa-kit moy karangalan ko, hiko a Anak mo. Ha anodtin paralan ay maipa-kit koy namaot a karangalan mo. ");
INSERT INTO xsb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nga-min, impa-taya mo kongkoy kapangyarian nin mamoon ha halban tawtawo iti ha babon lota, pigaw hikoy mamin biyay a homin anggawan konlan halban tawtawon impa-taya mo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yay labay totolon nin biyay a homin anggawan ay yay ma-bilbi la ka, hika a ka-siya-siyan potog a Dios tan hiko hi Jesu-Criston inhogo mo. ");
INSERT INTO xsb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Impa-kit koy karangalan mo iti ha mondo ta pinolyari koy gawgawa a impagawa mo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hawanin, Ama, ipatnag moy karangalan ko ha main mon arapan nin bilang ha karangalan a iti kongko hin ison ako ot komo ba-yo pinalsay sangkalotaan.” ");
INSERT INTO xsb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Wana ot ni Jesus ha dawat na, “Impabilbi kata konlan tawtawon inimbi mo kongko a pinili mo ibat ha mondo. Ikon mo hila, bi-sa inimbi mo hila kongko tan anhonolon lay halita mo. ");
INSERT INTO xsb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hawanin ay tanda lay na a halban bawbagay a inimbi mo kongko ay nangibat komo. ");
INSERT INTO xsb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nga-min, yay impanakom mo kongko a dapat kon halitaon ay impangaral ko konla bi-sa tinanggap ladti. Tanda la a potog a nangibat ako komo tan ampi-polon la a inhogo mo ko. ");
INSERT INTO xsb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ambo hilay tawtawon makamondo a an-idawat ko, nokay hilay inimbi mo kongko ta ikon mo hila. ");
INSERT INTO xsb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nga-min, hilay halban ikon ko ay ikon mo, tan hilay ikon mo ay ikon ko syimpri, tan yay karangalan ko ay angka-patnagan anamaot iti konla. ");
INSERT INTO xsb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kay koy na maboyot iti ha babon lota ta morong akoy na komo, kot hila ay ma-bati iti ha babon lota. Masanton Ama, ha kapangyarian nin main mon ngalan, ingatan mo hilay inimbi mo kongko pigaw patoloy a main lan pa-miasa-sa a bilang anamaot ha main tan pa-miasa-sa. ");
INSERT INTO xsb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lolog kon iti ha mondo nin kalamo hiladtin tawtawon inimbi mo kongko ay iningatan ko hila ha kapangyarian nin main mon ngalan. Iningatan ko hila, kanya homin niparoka konla, nokay yadti bongat a-sa a ampaningkap nin pakarokaan na. Kot talagan mangyari yadti pigaw pomtog yay nakasolat ha Masanton Kasolatan. ");
INSERT INTO xsb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hawanin ta morong akoy na komo, an-ibalita kodtin bawbagay lo-gan iti ko ot ha mondo, pigaw mapno hila nin kaligawan ko. ");
INSERT INTO xsb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Impangaral ko konlay halita mo, bi-sa tinanggap ladti. Kanya antiplonon hila nin tawtawon makamondo, palibhasay ambo hilay nan makamondo a bilang anamaot kongko a ambo makamondo. ");
INSERT INTO xsb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kay ko an-idawat a alihon mo hila iti ha mondo, nokay komon ingatan mo hila konan yay poon nin karokaan. ");
INSERT INTO xsb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ambo hilay naor anan makamondo a bilang anamaot kongko a ambo makamondo. ");
INSERT INTO xsb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pakabanalon mo hiladtin antompol kongko ha paralan nin kaptogan a ibat komo: Yay halita mo ay kaptogan. ");
INSERT INTO xsb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","No pa-no mo ko inhogo iti ha mondo, anorin anamaot kapara, an-ihogo ko hila ha tawtawo ha mondo. ");
INSERT INTO xsb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Alang-alang konla ay an-ibi koy biyay ko, pigaw hila man kot ibi lay namaot a main lan biyay komo ha paralan nin kaho-honol la ha kaptogan.” ");
INSERT INTO xsb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wana ot ni Jesus nin impagpatoloy ha dawat na, “An-idawat ko ambo bongat hiladtin dawdisipolos ko, nokay hila man a tompol kongko bana ha main lan pangangaral. ");
INSERT INTO xsb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Komon manga-piasa-sa hilay halban a bilang ha main tan pa-miasa-sa. No pa-non hika, Ama, kot iti kongko tan hiko kot iti komo, komon anorin hilay namaot ha a-sa tan a-sa bana ha pa-makiasa-sa la konta, pigaw hilay tawtawon makamondo kot mi-pol a talagan inhogo mo ko. ");
INSERT INTO xsb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","No pa-noy karangalan a inimbi mo kongko ay anorin anamaot a an-ibi ko konlan hilay antompol kongko, pigaw mag-in hilan asa-sa a bilang konta a asa-sa. ");
INSERT INTO xsb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iti ko konla tan hika ay iti kongko pigaw mag-in maigot a main lan pa-miasa-sa, ta pigaw maintindyan lan hilay kay antompol a talagan inhogo mo ko tan anlabyon mo hilay antompol kongko a bilang anamaot pa-manglabi mo kongko. ");
INSERT INTO xsb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, yay labay ko komon ay maipagkalamoan koy namaot ha kamainan ko ha lomato a panaon hilay tawtawon inimbi mo kongko, pigaw ma-kit lay karangalan a inimbi mo kongko bana ha labi mo kongko ba-yo ot pinalsay babon lota. ");
INSERT INTO xsb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Ama a matoynong ha halban mon gawgawa, ambo la kan bilbi nin hilay tawtawon makamondo, balo ta bilbi kata tan tanda lan hiladtin dawdisipolos ko a inhogo mo ko. ");
INSERT INTO xsb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impabilbi kata konla tan patoloy katan ipabilbi konla, pigaw magkamain hilan pa-manglabi a bilang ha pa-manglabi mo kongko tan pigaw pirmi ko iti konla.” ");
INSERT INTO xsb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pa-makayari nan indawat ni Jesus odtin halban, impagkalamoan na hilay disipolos na nin nilomipay ha Hapa Cedron. Bi-sa nilomoob hila ha a-say hardin itaw ha Bakil Olibo. ");
INSERT INTO xsb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hi Judas a magtraidor koni Jesus ay kabisado nadtin logar, palibhasay mabotbot na hilan tiponon itaw ni Jesus a dawdisipolos na. ");
INSERT INTO xsb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hawanin, nakoy naor hi Judas itaw nin main awit a-say gropon hawhondalo a taga Roma tan omnoy gawgwardya ha timplo a inhogo lan pawpoon pari tan paw-Pariseo. Aw-armado hila tan ni-pangawit apoy. ");
INSERT INTO xsb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Palibhasay tanda ni Jesus a halban mangyari kona, kanya hinakbat na hila, ta wana konla, “Hinoy antingkapon moyo?” ");
INSERT INTO xsb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wanlan in-obat kona, “Hi Jesus a taga Nazaret.” Wani Jesus konla, “Hiko-rin.” Hi Judas a nagtraidor kona ay kaarap anamaot hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pa-makahalita ni Jesus nin “Hiko-rin,” ay nipaatras hila tan nangatotomba. ");
INSERT INTO xsb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pinastang na hilan oman ni Jesus, wana, “Hino kot talagay antingkapon moyo?” Wanlay naman, “Hi Jesus a taga Nazaret.” ");
INSERT INTO xsb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Obat ni Jesus, “Imbalita koy na a hiko-rin. No hikoy antingkapon moyo, po-layan moyon makaalih hiladtin kawkalamoan ko.” ");
INSERT INTO xsb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Ha pa-mibalita nan ya-rin ay pinomtog a hinalita na ha dawat na, a wana, “Homin ni a-sa konla a niparoka.”) ");
INSERT INTO xsb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hin ya-rin ay bigla inoyoh ni Simon Pedro a awit nan bonong, ta tinabtab nay a-say alila nan pinakapoon pari. Kot natigpah a wanan totolyan nan ya-rin alila a yay ngalan na kot Malco. ");
INSERT INTO xsb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wani Jesus koni Pedro, “Igomâ moy bonong mo ta dapat tanggapon kodtin pa-magdya-dya bana ta yadti a kanakoman nan Ama ko.” ");
INSERT INTO xsb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hin ya-rin ay dinakop tan binalol la hi Jesus nin hilay hawhondalo a taga Roma, kalamo lay kapitan la, tan hilay gawgwardya a inhogo lan pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Inawit la ya yapon koni Anas a datin pinakapoon pari a katyangan ni Caifas. Yadti hi Caifas yay pinakapoon pari hin ya-rin a taon, ");
INSERT INTO xsb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","tan hiya odtaw namibalita konlan pawpoon nin Israelita a mas labah a a-say tawo tanay mati para ha halban. ");
INSERT INTO xsb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hi Simon Pedro tan a-sa ot a disipolo ay tinomombok koni Jesus. Palibhasay bilbi nan pinakapoon pari yadtin disipolo, kanya nakaloob yay namaot ha bali nan pinakapoon pari a pinangawitan la koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kot hi Pedro ay na-bati ha likol ha danin poltan balaybay. Kanya nilomikol yay disipolo a bilbi nan pinakapoon pari, ta impaki-totol na konan dalaga a ampagbantay itaw ha poltan balaybay a paloobon na hi Pedro, kanya pinaloob na ya. ");
INSERT INTO xsb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wanan dalaga koni Pedro, “A-sa kay namaot doman ha dawdisipolos nan ya-rin a tawo?” “Ambo,” wani Pedro. ");
INSERT INTO xsb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hin ya-rin ay malayop, kanya hilay aw-alipon tan gawgwardya ay namartan timbon ta ampalanglang hila. Naki-ha-lo hi Pedro konlan naka-dong itaw ta ningoroy namaot. ");
INSERT INTO xsb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hawanin, yay datin pinakapoon pari a hi Anas ay pinastang na hi Jesus tongkol ha dawdisipolos na tan ha bawbagay a intoro na. ");
INSERT INTO xsb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Wanan in-obat ni Jesus kona, “Parada kon ampangaral ha tawtawo. Itaw ako pirmin ampanoro ha sawsinagoga tan ha timplo a ampititiponan tamon aw-Israelita. Homin akon hinalita nin paari. ");
INSERT INTO xsb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Anongkot hikoy ampastangon mo? Hiladtaw nakalngo kongko a dapat mon pastangon no anyay intoro ko konla. Tanda la man no anyay hinalita ko.” ");
INSERT INTO xsb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pa-makahalita nan anorin ni Jesus, tinampal na yan a-say gwardya a naka-dong itaw, ta wana, “Anorin doman a dapat mon pa-ngobat konan pinakapoon pari?” ");
INSERT INTO xsb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Wani Jesus kona, “No main lingo ha imbalita ko, paptogon mo pa. Kot no tama, anongkot man ta tinampal mo ko?” ");
INSERT INTO xsb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hin ya-rin ay impapi-ka ni Anas hi Jesus nin nakabalol itaw koni Caifas a pinakapoon pari hin ya-rin a panaon. ");
INSERT INTO xsb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Hin ya-rin ay itaw ya ot naka-dong hi Simon Pedro nin ampalanglang, kanya wanla kona, “Ambo doman a-sa kay namaot ha dawdisipolos ni Jesus?” Kot imporlingor nadti ni Pedro, ta wana, “Ambo!” ");
INSERT INTO xsb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Main anamaot itaw a-sa ha aw-alila nan pinakapoon pari a kanayon nan yadtaw lalakin natigpah ni Pedro a totolyan, a wana kona, “Ambo doman na-kit kata nangon itaw ha hardin nin kalamo ni Jesus?” ");
INSERT INTO xsb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Imporlingor na ot syimpri ni Pedro. Tongwa, tinomaran-ok a manok. ");
INSERT INTO xsb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ibat ha bali ni Caifas ay inawit la hi Jesus ha palasyo ni Gobirnador Pilato a taga Roma. Palbangon ana hin ya-rin. Kay hila nilomoob ha palasyo nan gobirnador hilay Israelita a ma-moon bana ta a-sa yan ambo Israelita, pigaw kay hila maitoring ambo karapat-dapat mangan nin pangaponan ha Pistan Pa-makalibri* nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bana ta anorin, nilomikol hi Gobirnador Pilato, ta wana konla, “Anya kot a riklamo moyo laban konan yadtin tawo?” ");
INSERT INTO xsb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wanlan in-obat, “No ambo yan tawon anggomwa doka, kay mi ya komon in-intriga komo.” ");
INSERT INTO xsb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Wanay naman ni Gobirnador Pilato konla, “Di kowon moyo ya no-nin, ta hikamoy nay manosga kona ayon ha kawkapanogoan moyo.” Kot wanlan pawpoon nin Israelita, “Iya, kot imbawal komin manintinsyan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Ha anorin a nangyari, pinomtog yay hinalita ni Jesus tongkol ha klasin kamatyan a dalanan na.) ");
INSERT INTO xsb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Hin ya-rin ay nilomoob oman hi Gobirnador Pilato ha palasyo ta bi-sa impapiarap na hi Jesus kona. Wana kona, “Hika doman a Ari lan Israelita?” ");
INSERT INTO xsb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Wanan in-obat ni Jesus, “Naibat doman ha sarili mon kaisipan ya-rin a pastang mo? O main laloman namibalita komo tongkol kongko?” ");
INSERT INTO xsb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Wanay naman ni Gobirnador Pilato, “A-sa ko doman Israelita, ta hay wamo tanda ko-rin? Imbalita la-rin nin kapara mon Israelita tan pawpoon pari moyo a namiintriga komo. Anya kot talagay ginwa mo?” ");
INSERT INTO xsb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Wani Jesus, “Yay pa-mag-ari ko ay ambo iti ha mondo. Nga-min, no yay pa-mag-ari ko kot iti ha mondo, nilomaban komon a tawtawo ko pigaw kay ko maiintriga konlan kapara kon Israelita. Kot yay pa-mag-ari ko ay ambo anaor iti ha mondo.” ");
INSERT INTO xsb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wani Gobirnador Pilato kona, “A-sa ka no-nin ari?” Wanan in-obat ni Jesus, “Hikay nay ampamibalita a ari ako. Ya-rin a bara-nan no anongkot nako ko iti ha kalotaan tan impangabing iti, pigaw tistigosan ko yay kaptogan. Hinoman a iti ha kaptogan ay ampanglongo kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pastang ni Gobirnador Pilato, “Anya kot yay kaptogan?” Pa-makahalita nan yadti, nilomikol yay naman hi Gobirnador Pilato, ta wana konlan pawpoon nin Israelita, “Homin akon angka-kit bara-nan a dapat yan sintinsyawan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bi-sa wana konlan tawtawo, “Kot main kamo syimprin kaogalian iti a kada Pistan Pa-makalibri moyo ay dapat mamiboloh akon a-say priso para komoyo. Labay moyo wari a yay Ari moyon Israelita a bolohan ko?” ");
INSERT INTO xsb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kot halban la inomaghaw, “Kai!” wanla, “Ambo hiya! Hi Barabbas a bolohan mo!” Anta yadtin hi Barabbas ay a-sa yan tolisan. ");
INSERT INTO xsb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hin ya-rin ay impalatigo ni Gobirnador Pilato hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pa-makayari la yan nilatigo nin hawhondalo ay namayokal hilan hangan marowih ta inkorona la kona, bi-sa pinadolohan la yan kolor obi ta konwari ari ya. ");
INSERT INTO xsb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ba-yo, a-sa a-sa hilan dinomani kona ta wanlan pa-noya-toya, “Viva yay Ari lan Israelita!” Bi-sa tina-tampal la ya. ");
INSERT INTO xsb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Hin ya-rin ay nilomikol anaman hi Gobirnador Pilato, ta wana konlan tawtawo, “Iarap ko ya komoyo, pigaw ma-tandaan moyo a homin akon angka-kit bara-nan a dapat yan sintinsyawan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nilomikol yay naor hi Jesus nin nakakoronan marowih tan nakadoloh nin kolor obi. Bi-sa wani Gobirnador Pilato konla, “Biliwon moyo yadtin tawo!” ");
INSERT INTO xsb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hin na-kit la yan pawpoon pari tan gawgwardya, wanlan in-aghaw, “Ipasak ya ha kros! Ipasak ya ha kros!” Kanya wani Gobirnador Pilato konla, “Kowon moyo ya no-nin ta hikamoy mamipasak kona. Homin akon angka-kit bara-nan a dapat yan sintinsyawan kamatyan.” ");
INSERT INTO xsb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wanlan Israelita kona, “Main kamin kapanogoan a kinontra na ta ampagkonwari ya a Anak yan Dios, kanya bana konan ya-rin ay dapat yan mati.” ");
INSERT INTO xsb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hin nalngo nadti ni Gobirnador Pilato ay lalo yan nali-mo. ");
INSERT INTO xsb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nilomoob yan oman ha palasyo ta itaw na kina-totol hi Jesus, wana, “Ayti ka kot talaga taga?” Kot kay na yay na inobat ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kanya wani Gobirnador Pilato kona, “Kay mo labay maki-totol kongko? Kay mo doman tanda a iti kongkoy kapangyarian nin bolohan ka o ipapipasak ha kros?” ");
INSERT INTO xsb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Wanan in-obat ni Jesus, “Homin ka komon kapangyarian nin manintinsya kongko no kay na inimbin Dios orin komo. Kanya yay namiintriga kongko komo ay mas mabyat a kasalanan na dinan komo.” ");
INSERT INTO xsb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bana ta anodtaw, lalon nag-inakit hi Gobirnador Pilato nin bolohan hi Jesus, balo ta wanlan in-aghaw nin hilay Israelita, “No bolohan mo ya, ambo kay nan amigo nan pinakaari tamo ha Roma, ta hinoman a ampanalita a hiya kot ari ay angkontrawon na yay pinakaari tamo ha Roma.” ");
INSERT INTO xsb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hin nalngo nadti ni Gobirnador Pilato, impapilikol nay naman hi Jesus. Bi-sa tinomoklo ya itaw ha ampagbistawan na ha Intabladon Bato a angkotanawon “Gabata” ha halita Hebreo. ");
INSERT INTO xsb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hin ya-rin ay bandan ogtiawlo nin awlon pa-magparihado nin pangaponan para ha Pistan Pa-makalibri. Wani Gobirnador Pilato konlan Israelita, “Oyay Ari moyo!” ");
INSERT INTO xsb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wanlay naman in-aaghaw nin hilay Israelita, “Patyon ya! Patyon ya! Ipasak ya ha kros!” Wanay namaot ni Gobirnador Pilato, “Talagan labay moyo doman ipapipasak ko yay Ari moyo?” Wanlan in-obat nin hilay pawpoon pari, “Kay homin kamin laloman ari no ambo yay pinakaari ha Roma.” ");
INSERT INTO xsb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","In-intriga na ya ni Gobirnador Pilato hi Jesus konlan pawpoon pari para ipapipasak la ya ha kros. Kanya inawit la yay nan omnoy hondalo. ");
INSERT INTO xsb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ambalatayon ni Jesus a kros hin ya-rin anlomikol hila ha syodad nin mako itaw ha “Logar nin Bongo” a anha-wayan Golgota ha halita Hebreo. ");
INSERT INTO xsb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pa-makalato itaw, impasak la yay na ha kros nin hilay hondalo. Bi-sa main ot lowa katawo a impasak la ha kros ha mi-dobali ni Jesus, kanya hi Jesus ay iti ya ha botlay. ");
INSERT INTO xsb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Main yan impapigwa hi Gobirnador Pilato a paskin ha olowan nin kros ni Jesus a anodti nakasolat: “Hi Jesus a Taga Nazaret, Ari nin Aw-Israelita.” ");
INSERT INTO xsb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lako konlan Israelita a nakabasa nin yadtin paskin, bana ta yay logar a pinamipasakan la koni Jesus ay madani ha syodad Jerusalem, tan bana ta nakasolat yadti ha halita Hebreo, Griego tan Latin. ");
INSERT INTO xsb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wanlan hilay pawpoon pari nin Israelita hin ya-rin koni Gobirnador Pilato, “Ambo komon anodtaw a insolat mo a Ari nin aw-Israelita, nokay ‘Wanan yadtin tawo, Ari akon aw-Israelita.’” ");
INSERT INTO xsb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kot wanan in-obat ni Gobirnador Pilato, “No anyay insolat ko ay yadtaw ana.” ");
INSERT INTO xsb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hin nayari lan impasak hi Jesus nin hilay hondalo, pinarti-parti lay dawdoloh na ha a-pat, pigaw balang a-sa konla ay magkamain a-say parti. Kinwa lay namaot a ayhing nan maanloh a homin tayi ta diritson inabol. ");
INSERT INTO xsb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bi-sa wanla ha a-sa tan a-sa, “Ando tamo gi-gi-niton, nokay pi-bonotan tamo tana no hino kontamoy makapag-ikon.” Ha anorin a nangyari, pinomtog yadtin wana ha Masanton Kasolatan, “Pinarti-parti lay dawdoloh ko, Ta bi-sa pini-bonotan la no hinoy makapag-ikon nin ayhing ko.” Anorin anaor a ginwa lan hawhondalo. ");
INSERT INTO xsb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ha danin kros ni Jesus ay itaw anamaot nakaodong hi nanay na tan yay talakakan babayi ni nanay na, pati hi Maria a kaambali ni Cleopas, tan hi Maria Magdalena. ");
INSERT INTO xsb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Hin na-kit ni Jesus hi nanay na, tan yay ampaka-labyon nan disipolo a nakaodong ha dani na, wana koni nanay na, “Babayi, ibilang mo yay nan anak mo.” ");
INSERT INTO xsb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bi-sa wanay namaot konan disipolo, “Ibilang mo yan nanay mo.” Paibat hin ya-rin, impaki-ka na hi nanay ni Jesus ha balin kamainan na, ta itaw yay na ni-wan. ");
INSERT INTO xsb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pa-makayari nin yadti ay tanda ni Jesus a nangyari nay halban bagay. Hawanin, wani Jesus, “Malata ako.” Ha pa-mibalita nan anodti ay antooron na yay nakasolat ha Masanton Kasolatan. ");
INSERT INTO xsb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Main itaw hin ya-rin a-say pamigwaan a pono maalhom a alak obas. Kanya main nangwa nin ispongha ta insawsaw ha maalhom a alak, ba-yo intoraw nadti ha tangkay nin “hisop”, ta bi-sa indalit na ha boboy ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hin nakahophop hi Jesus nin maalhom a alak, wana, “Nayari ana.” Bi-sa intook nay olo na, ba-yo in-intriga nay na a ispirito na konan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bana ta awlon Byirnis hin ya-rin a awloy naor nin pa-magparihado para ha Awlon Pa-mainawa, kay la labay nin hilay pawpoon nin Israelita a hiladtaw nakapasak ha kros kot ma-palatan Awlon Pa-mainawa nin nakapasak ot. (Nga-min, ya-rin a Sabado ay ambo bastan Awlon Pa-mainawa). Kanya impaki-totol la koni Gobirnador Pilato a ipabalì nay bawbitih nin hilay nakapasak ha kros pigaw tampol hilay nan mati, tan pigaw maiaypa a bawbangkay la ha kros ba-yo lomato a Awlon Pa-mainawa. ");
INSERT INTO xsb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kanya nako hilay naor a hawhondalo, ta bi-sa binalì lay bawbitih nin hilay loway kalamo ni Jesus a impasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kot hin dinomani hilay na koni Jesus, na-sikaso la a nati yay na, kanya kay lay na binalì a bitih na. ");
INSERT INTO xsb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Balo ta main a-say hondalo a namika nin liking ni Jesus. Antimano, namola-nit a daya tan lanom. ");
INSERT INTO xsb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yay naka-kit konan yadtin pawpangyayari ay hiya mismo a ampanolat nin yadti. Talagan potog odtin an-ibalita na, tan sadya nan an-isolat odtin kaptogan pigaw tompol kamoy namaot. ");
INSERT INTO xsb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ha anorin a nangyari, pinomtog odtaw wana ha Masanton Kasolatan, “Ni a-say botol na ay kay homin mabalì.” ");
INSERT INTO xsb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wana ot ha Masanton Kasolatan a pinomtog anamaot, “Homilap hila konan yay pinika la.” ");
INSERT INTO xsb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Main a-say lalakin taga babalin Arimatea a hi Jose a a-say namaot disipolo ni Jesus, balo ta sikrito bongat a kaho-honol na kona ta angkali-mo ya konlan pawpoon nin Israelita. Impaki-totol na koni Gobirnador Pilato a payagan na yan kowon a bangkay ni Jesus. Pinomayag anamaot hi Gobirnador Pilato, kanya kinwa nay naor a bangkay ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naki-ka anamaot kona hi Nicodemo, yay nako koni Jesus hin yadtaw a-say yabi. Main yan awit nin manga limampolo a kilo nin mabanglo a yatok nin kayon mira tan aloe a anggamiton para ipambalsamon nati. ");
INSERT INTO xsb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hawanin, lo-gan lan angkolkolan a bangkay ni Jesus nin pinon tilan mapoti ay ambiyan lan ya-rin a mabanglo a yatok yay piha-loan nin ya-rin a tilan an-ikolkol la kona ayon ha kaogalian nin pa-mitabon nin aw-Israelita. ");
INSERT INTO xsb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Itaw ha danin pinamipasakan koni Jesus ay main a-say hardin. Konan ya-rin hardin ay main ba-yon panabonan a kay ot ginamit. ");
INSERT INTO xsb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Itaw lay na inigwa a bangkay ni Jesus bana ta awlon Byirnis hin ya-rin, a bispiras nin Awlon Pa-mainawa, tan madani nan homlop a awlo a ompisay nan Awlon Pa-mainawa. Nga-min, ya-rin panabonan ay madani bongat itaw. ");
INSERT INTO xsb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Palbangon nin awlon Dominggo, maroblom ot, nako yay na hi Maria Magdalena itaw ha pinanabonan koni Jesus. Na-kit na a yadtaw bato a impanara ha poltan pinanabonan ay naalih ana. ");
INSERT INTO xsb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kanya nolayo yan nako koni Simon Pedro tan konan yay disipolon ampaka-labyon ni Jesus, ta wana konla, “Kinwa lay bangkay nan Katawan itaw ha pinanabonan kona, tan kay mi tanda no ayti la inigwa.” ");
INSERT INTO xsb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Antimano, hi Pedro tan yay disipolon ampaka-labyon ni Jesus ay nilomikol para mako ha pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pariho hilan nolayo, kot mas paspas yay disipolon ampaka-labyon ni Jesus, kanya no-na ya koni Pedro nin niabot ha pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hin tinomook ya ta hinilip nay lalo, na-kit nan nakaparna yay pinon tilan mapoti a ingkolkol koni Jesus, kot kay ya yapon nilomoob. ");
INSERT INTO xsb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bi-sa nakalato anamaot hi Simon Pedro a ka-honol na. Diri-diritso yan nilomoob ha pinanabonan. Na-kit nay namaot yay pinon tilan mapoti a nakaparna. ");
INSERT INTO xsb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kot yay panyo a impamotot ha olo ni Jesus ay ambo kalamo konan yay pinon tilan mapoti, ta nakapolok yadti nin nakalolon. ");
INSERT INTO xsb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nilomoob anamaot yay disipolon no-nan nakalato. Na-kit nay naor a anodtaw a palasta, kanya ni-pol ya a norong nabyay hi Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Maski man hin ya-rin ay kay la ot tanda a main nakasolat ha Masanton Kasolatan a kailangan morong yan mabyay. ");
INSERT INTO xsb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bi-sa norong hilay na. ");
INSERT INTO xsb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kot hi Maria Magdalena ay itaw ya ot nakaodong nin matangih-tangih ha likol pinanabonan koni Jesus. Lo-gan nan antomangih ay tinomook ya ta hinilip nay lalo pinanabonan. ");
INSERT INTO xsb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na-kit nay loway anghil a nakaayhing mapoti. Itaw hila antoklo ha ibatan bangkay ni Jesus, yay a-sa ha olowan tan yay a-sa ha bandan ayi. ");
INSERT INTO xsb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wanla kona, “Babayi, anongkot antangih ka?” Wana konla, “Kinwa lay bangkay nan Katawan ko, bi-sa kay ko tanda no ayti la inigwa.” ");
INSERT INTO xsb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pa-makahalita nan yadti ay binomling ya. Na-kit na hi Jesus a nakaodong itaw, balo ta kay na ya na-bilbi. ");
INSERT INTO xsb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wani Jesus kona, “Babayi, anongkot antangih ka? Hino kot a antingkapon mo?” Hay wani Maria no hiya a hardiniro, kanya wana kona, “Sinyor, no wari ta hika a nangwa kona, ibalita mo pa no ayti mo ya inigwa, ta kowon ko ya.” ");
INSERT INTO xsb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wani Jesus kona, “Maria!” Hawanin, inomarap hi Maria koni Jesus, ta wana ha halita Hebreo, “Raboni!” (labay totolon, “Maistro!”) ");
INSERT INTO xsb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Wana ot ni Jesus kona, “Ando mo ko ga-gotan, ta kay ko ot nakaorong konan Ama ko. Mako ka konlan impagka-tawtalakaka ko, ta ibalita mo konla a morong ako konan Ama ko a Ama moyoy namaot, konan Dios ko a Dios moyo syimpri.” ");
INSERT INTO xsb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nako yay naor hi Maria Magdalena konlan disipolos ni Jesus, ta wana konla, “Na-kit ko yay Katawan!” Ta bi-sa imbalita na ot konla no anyay hinalita nan Katawan kona. ");
INSERT INTO xsb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kinayabiwan ya-rin ot a awlon Dominggo, nititipon hilay disipolos ni Jesus. Nakatrangkay pawpolta ha balin kamainan la hin ya-rin, ta angkali-mo hila konlan pawpoon nin Israelita. Tongwa, nagpa-kit hi Jesus nin nakaodong ha botlay la, bi-sa wana konla, “Magkamain kamon kaliswayan nakom.” ");
INSERT INTO xsb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pa-makahalita na-rin, impa-kit na konla yay gamot tan liking na. Hawanin, maligan-maliga hila ha pa-maka-kit la konan Katawan. ");
INSERT INTO xsb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Wanay naman ni Jesus konla, “Magkamain kamon kaliswayan nakom. No pa-no na ko inhogo nin Ama ay anorin kapara, an-ihogo katamoy namaot.” ");
INSERT INTO xsb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pa-makahalita na-rin, pinayhopan na hila, bi-sa wana, “Tanggapon moyoy Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hinoman a ampatawaron moyo ha main nan kawkasalanan ay na-patawad ana-rin. Kot hinoman a kay moyo patawaron ha main nan kawkasalanan ay kay ot pinatawad a main nan kawkasalanan.” ");
INSERT INTO xsb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hi Tomas a anha-wayan Kambal tan a-sa konlan labinloway apostolis ni Jesus ay ambo lan kalamoan hin ya-rin a nagpa-kit hi Jesus konla. ");
INSERT INTO xsb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kanya, hin na-kit la hi Tomas, wanla kona, “Na-kit mi yay Katawan.” Kot wana konla, “Anggan kay ko ma-kit a inibatan pasak ha gamot na, tan maigwa a tamoro ko ison ha inibatan pasak, bi-sa maigwa ko ot a gamot ko ha liking nan pinika ay kay ko maki-pol a norong yan nabyay.” ");
INSERT INTO xsb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pa-makalabah nin a-say linggo, tipon hilay naman a dawdisipolos ni Jesus konan yadtaw bali, kalamo lay na hi Tomas hin ya-rin. Nakatrangka syimpri a pawpoltan bali. Kot tongwa, nagpa-kit yay naman hi Jesus nin nakaodong ha botlay la, bi-sa wana, “Magkamain kamon kaliswayan nakom.” ");
INSERT INTO xsb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bi-sa wana koni Tomas, “Bilyon moy gamot ko ta igwa moy tamoro mo iti tan igwa moy gamot mo ha liking ko. Ando kay na magdoda, mi-pol kay na.” ");
INSERT INTO xsb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wanan in-obat ni Tomas kona, “Katawan ko tan Dios ko.” ");
INSERT INTO xsb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wani Jesus kona, “Tomas, palibhasay na-kit mo ko kanya ka ampi-pol. Makalma hilay kay naka-kit kongko balo ta antompol hila ot syimpri.” ");
INSERT INTO xsb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yay talagan potog, lako ot a gi-ginwa ni Jesus a mawmilagro a na-kit lan dawdisipolos na a kay naisolat iti konan yadtin libro. ");
INSERT INTO xsb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kot hiladtin nakasolat iti ay sinolat pigaw mi-pol kamo a hi Jesus yay Cristo a Anak nan Dios, tan ha paralan nin katotpol moyo kona ay magkamain kamon biyay a homin anggawan. ");
INSERT INTO xsb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kay naboyot, nagpa-kit yay naman hi Jesus konlan disipolos na ha liglig Alindayat Galilea. Anodti a nangyari: ");
INSERT INTO xsb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Hi Simon Pedro, hi Tomas a anha-wayan Kambal, hi Natanael a taga babalin Cana, probinsyan Galilea, hilay loway anak ni Zebedeo tan lowa ot a kalamoan lan dawdisipolos ni Jesus ay nanga-pilalamo hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wani Simon Pedro konla, “Mako ko manilay.” “Ki-ka kami komo,” wanlay namaot kona. Kanya nako hilay na ha alindayat, bi-sa tampol nilomolan ha a-say baloto. Kot hin ya-rin a yabi ay homin hilan nakwa. ");
INSERT INTO xsb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hin palbangon ana, itaw ya nakaodong hi Jesus ha liglig alindayat, balo ta kay la ya na-bilbi. ");
INSERT INTO xsb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wanan impastang konla, “Aw-ali* ko, main kamo doman nakwa?” Wanlan in-obat kona, “Homin.” ");
INSERT INTO xsb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wana konla, “Idabo moyoy ikot ha bandan wanan baloto ta main kamon makwa.” Indabo lay naor a ikot ayon ha imbalita na. Tongwa naor, kay lay na mabira a ikot ha kalakan konâ a nakwa. ");
INSERT INTO xsb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kanya yay disipolon ampaka-labyon ni Jesus a namibalita koni Pedro hin ya-rin, wana, “Yay Katawan orin!” Hin nalngo ni Simon Pedro a yay Katawan payti, tampol nan inholot a doloh na (nga-min lapyang ya), bi-sa nagta-boy ya ha lanom ta nako ya koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kot hilay laloman dawdisipolos ay hinomonol ana nin nakalolan ha baloto, ta goloy-goloy lay ikot a pono-pono nin konâ. Madani hilay na hin ya-rin ha liglig alindayat, manga siyam a polo a mitro tanay dayo. ");
INSERT INTO xsb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pa-makainapat la, na-kit la a main anan baya tan main anan konâ a anhibawon, bi-sa main ot tinapay. ");
INSERT INTO xsb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wani Jesus konla, “Mangawit kamo iti nin ya-rin konâ a nakwa moyo.” ");
INSERT INTO xsb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nilomolan hi Pedro ha baloto ta bi-sa ginoloy nay ikot ta in-inapat ha liglig. Pono odti nin lalako a konâ a yay bilang kot sanyatos tan limampolo tan tolo (153). Kot maskin anorin kalako a nakwa ay kay nagi-nit a ikot. ");
INSERT INTO xsb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Hawanin, wani Jesus konla, “Mako kamoy na iti ta mag-almosal tamoy na.” Kay homin konlan disipolos a nagkohaw nakom namastang no hino ya, ta bilbi lay na a hiya yay Katawan. ");
INSERT INTO xsb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hin ya-rin ay dinomani hi Jesus, bi-sa kinwa nay tinapay ta inimbi na konla, tan anorin kapara ha konâ. ");
INSERT INTO xsb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yadti a pangatlon bisis a nagpa-kit hi Jesus konlan disipolos na paibat hin norong yan nabyay. ");
INSERT INTO xsb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hin nayari hilan nag-almosal, wani Jesus koni Simon Pedro, “Simon, anak ni Juan, mas inaro mo ko doman dinan konlan hila-rin?” Wani Pedro kona, “Iya, Katawan. Tanda mo a anlabyon kata.” Wani Jesus kona, “Pa-hal pastolan mo no-nin hilay bawba-yon tinompol kongko a pa-hal mawmalago a karniro ko.” ");
INSERT INTO xsb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pinastang na yay naman, wana, “Simon, anak ni Juan, inaro mo ko doman talaga?” Wanan in-obat ni Pedro, “Iya, Katawan. Tanda mo a talagan anlabyon kata.” Wanay naman ni Jesus, “Alagaan mo no-nin hilay antompol kongko a pa-hal kawkarniro ko.” ");
INSERT INTO xsb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pinastang na yay naman ha pamitlon bisis, “Simon, anak ni Juan, talaga doman a anlabyon mo ko?” Nilomolo hi Pedro ta nitloy bisis na yay nan pinastang no anlabyon na ya, kanya wana koni Jesus, “Katawan, tanda moy halban bawbagay. Tanda mo a anlabyon kata.” Wani Jesus kona, “Pa-hal pastolan mo no-nin hilay antompol kongko a pa-hal kawkarniro ko. ");
INSERT INTO xsb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Yay potog a potog, ibalita ko komo, hin malago ka ot, hikay ampamitakol nin sarili mon tagkoh tan ampako ka ha balang labay mo. Kot no matontawo kay na, ipa-nat mo tanay gamot mo ta main laloman mamitakol komo, ta bi-sa awiton la ka ha logar a kay mo labay.” ");
INSERT INTO xsb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Imbalita nadti ni Jesus para pa-mipatanda nin klasin kamatyan a dalanan ni Pedro a makapamin pamomori ha Dios.) Pa-makayari, wana ot ni Jesus kona, “Homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Hin ya-rin ay binomling hi Pedro. Na-kit na a antomombok konla yay disipolo a ampaka-labyon ni Jesus, yadtaw nakailig ha dani na hin hoyot a pa-ngapon la, bi-sa namastang kona, “Katawan, hinodtaw magtraidor komo?” ");
INSERT INTO xsb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hin ya-rin a na-kit na ya ni Pedro, wana koni Jesus, “Katawan, hapa hiyay namaot?” ");
INSERT INTO xsb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wani Jesus, “No wari man ta kalabayan ko a mabyay ya anggan ha pa-magbolta ko, anya man orin komo? Basta hika, homonol ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bana konan ya-rin a hinalita na ay nibantog konlan antompol a kay mati orin disipolo a tinokoy na. Anta kay nay namaot disnodon imbalita ni Jesus a kay ya mati, nokay yay wana, “No wari man ta kalabayan ko a mabyay ya anggan ha pa-magbolta ko, anya man orin komo?” ");
INSERT INTO xsb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ya-rin disipolo a ampamaptog konan yadtin bawbagay, tan hiya syimpri nanolat nin yadti. Tanda na tan hilay kawkalamoan na a yadtin halban ampaptogon na kot biig potog. ");
INSERT INTO xsb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lako ot a gi-ginwa ni Jesus. No halban kot a-sa a-sawon isolat, ola-no kay komasya ha mondo yay lawlibron maisolat. Amen.");
INSERT INTO xsb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Anggalangon kon talakaka Teofilo, Itaw ha o-nan libro ko, sinolat koy tongkol ha halban gawgawa tan tawtotoro ni Jesus paibat hin nag-ompisa yan nangaral ");
INSERT INTO xsb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","angga hin yadtaw awlon noli ya ha langit. Ba-yo ya noli ay pinango-nawan yan Masanton Ispirito nan Dios a bibilinan na hilay aw-apostolis a pinili na. ");
INSERT INTO xsb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lako a bisis, hin ya-rin pa-makayari nan nati a nagpa-kit ya konla ha nangasasari a paralan a talagan prowiba a norong yan nabyay. Tinotol na konlay bawbagay tongkol ha pa-mag-ari nan Dios ha loob nin a-pat a polo a awlo a ampagpa-kit ya konla. ");
INSERT INTO xsb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ninghan hin kalamoan la ya, wanan impaka-bibilin konla, “Ando kamo yapon omalih ha Jerusalem ta taga-nan moyoy impangako nan Ama ko a ihogo na ayon ha imbalita koy na komoyo. ");
INSERT INTO xsb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nga-min, lanom a impamaotismo ni Juan hin yadtaw, kot kay maboyot ay baotismowan na kamon Dios nin Masanton Ispirito na.” ");
INSERT INTO xsb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ninghan hin naipagkalamoan la yay naman hi Jesus nin hilay aw-apostolis na, pinastang la ya, wanla, “Katawan, biyan mo kami na doman hawanin nin sarilin ari pigaw mag-in kami naman indipindyinti a bilang hin yadtaw?” ");
INSERT INTO xsb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yay obat ni Jesus konla, “Ambo moyon kailangan ma-tandaan no maka-no mangyari orin, ta yay Dios Ama a namitakda nin panaon nin halban bawbagay ha main nan kapangyarian. ");
INSERT INTO xsb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kot biyan na kamon Dios kapangyarian painsan ha pa-makiasa-sa nan Masanton Ispirito na komoyo, ta bi-sa mamaptog kamo tongkol kongko konlan tawtawo ha Jerusalem, ha intiron Judea, Samaria tan anggan ha kali-ligligan lawlogar nin intiron kalotaan.” ");
INSERT INTO xsb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pa-makayari nan imbalita odti ni Jesus, noli ya ha langit. Ambiliw-biliwon la yan ampamata-gay angga hin na-halimbongan yan lolom. ");
INSERT INTO xsb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hin lo-gan la ot antangal ta ambiliw-biliwon la hi Jesus nin ampamata-gay, tongwa main loway lalakin nakadoloh nin mapoti a nakaodong ha dani la. ");
INSERT INTO xsb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bi-sa wanla, “Hikamo a taga Galilea, anongkot ison kamon nakaodong nin matangal-tangal? Ya-rin hi Jesus a naimatonan moyon noli ha langit ay mako yan oman iti ha lota nin bilang anorin ha na-kit moyon pa-moli na ha langit.” ");
INSERT INTO xsb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bi-sa norong hilay nay aw-apostolis ha Jerusalem ibat itaw ha Bakil Olibo, a halos a-say kilomitroy karayoan. ");
INSERT INTO xsb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pa-makalato la ha bali ay dinomiritso hilay na itaw ha kwarton an-iwanan la ha ta-gay. Hila ay hi Pedro, hi Santiago, hi Juan tan hi Andres, hi Felipe tan hi Tomas, hi Bartolome tan hi Mateo, hi Santiago a anak ni Alfeo tan hi Simon a mainakit ha nasyon Israel tan hi Judas a anak nin a-sa ot a Santiago. ");
INSERT INTO xsb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Halban la ay mabotbot ampititipon domawat nin asa-say kanakoman. Ha pa-mititipon la ay kalamo hilay bawbabayi, pati hi Maria a nanay ni Jesus, tan hilay tawtalakaka ni Jesus a lawlalaki. ");
INSERT INTO xsb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pa-makalabah nin omnoy awlo ay nititipon hilay naman a antompol koni Jesus. Manga sanyatos tan lowampolo (120) hilay halban. Hin ya-rin ay inomdong hi Pedro ta nanalita ya. ");
INSERT INTO xsb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Wana, “Tawtalakaka, yadtaw inogotan ni Judas a nango-na konlan hilay nanakop koni Jesus ay kailangan mangyari ayon ha nakasolat ha Masanton Kasolatan a impabalita anan daan nin Masanton Ispirito nan Dios hin yadtaw koni Ari David. ");
INSERT INTO xsb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nag-in yan kabilang komi hi Judas, ta a-sa yay namaot pinili para magsirbi bilang apostol.” ");
INSERT INTO xsb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yadtaw kwartan imbayar la kona ha doka a ginwa na ay impanaliw bowat. Ison yay na nababyog nin pataling-orong, kanya binomoti a tiyan na tan nilomwah a intiron bitoka na. ");
INSERT INTO xsb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na-tandaan nin halban tawo ha syodad Jerusalem a nangyari kona, kanya ya-rin bowat ay pinangalanan la ha halita la nin “Akeldama”, yay labay totolon “Bowat nin Daya”.) ");
INSERT INTO xsb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wana ot ni Pedro, “Anodti ot yay nakasolat tongkol koni Judas ha Masanton Kasolatan ha libron Kawkanta: ‘Yay bali na ay ibati ta bi-sa homin anan mi-wan ison.’ Anodti ot a nakasolat itaw: ‘Yay katongkolan na ay mi-ka ana ha laloman tawo.’” ");
INSERT INTO xsb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Wana ot ni Pedro, “Kanya hawanin, kailangan mamili tamon ka-hagilyan ni Judas para mag-in min kalamoan bilang tistigo a hi Jesus a Katawan kot norong yan nabyay. Kailangan yay pilion tamo ay yadtaw dati nan ampaki-ki-ka komi lolog panaon a kalamo na tamo ni Jesus, paibat hin nagpabaotismo ya koni Juan angga hin noli ya ha langit.” ");
INSERT INTO xsb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Namibalita hilan loway tawon pamilian, hi Matias tan hi Jose a anha-wayan Barsabas tan no minghan anamaot Justo. ");
INSERT INTO xsb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bi-sa dinomawat hila yapon, wanla, “Katawan, tanda moy kawkanakoman nin halban tawtawo. Ipatandaan mo pa tana komi no hino konlan hiladtin lowa a pinili mo ");
INSERT INTO xsb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para mag-in apostol, pigaw homagili ha katongkolan a na-lakwanan ni Judas ta ni-ka yay na ha logar a talagan marapat para kona.” ");
INSERT INTO xsb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pa-makayari lan dinomawat, indalan la ha pamomonot yay main lan pa-mili. Yay na-bonot a ngalan ay Matias, kanya hiya a impa-lah konlan hilay labin-a-say apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hin kaawlowan anan pista nin Israelita a anha-wayan “Pentecostes”, halban lan antompol koni Jesus ay na-piasa-san nititipon ha a-say bali. ");
INSERT INTO xsb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tongwa, main ogong a naibat ha langit a bilang ha makhaw a lopot. Nalngo ladti nin halban ison ha loob nin ya-rin a balin ampititiponan la. ");
INSERT INTO xsb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bi-sa ni-paka-kit hilan bilang aw-apoy a kortin dila a inomaypa ha olo nin balang a-sa konla. ");
INSERT INTO xsb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Halban lan hiladtin antompol ay biig pinango-nawan Masanton Ispirito nan Dios, bi-sa nag-ompisa hilan nanalita nin sari-sari a klasin halita a impahalita konla nin Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hin ya-rin ay main anamaot aw-Israelitan maka-Dios ibat ha balang nawnasyon iti ha mondo a nakihanda itaw ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hin nalngo lan tawtawo a makatlok ison ha loob nin ya-rin a bali ay lako konla a dinomani. Naka-ngap hila bana ta pari-pariho lan nalngo ha sawsarili lan halita yay anhalitaon lan hila-rin antompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ambo makano-kanoy pa-mag-ispanta la, kanya wanla ha a-sa tan a-sa, “Ambo doman halban lan hila-rin ampi-panalita ay taga Galilea? ");
INSERT INTO xsb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Anongkot man ta angkalngo tamo hilan ampanalita ha kanya-kanya tamon halita? ");
INSERT INTO xsb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Main kontamon taga Partia, main taga Media, main taga Elam, Mesopotamia, Judea, Capadocia, Ponto tan ha probinsyan Asia. ");
INSERT INTO xsb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Yay laloma ay taga Frigia, main taga Panfilia, taga Egipto tan main ha lawlogar nin Libia a hakop nin Cirene. Yay lalomay namaot a kapara tamon bisita ay taga Roma. Main lihitimon Israelita tan main nag-in Israelita bana ta anhonolon lay kawkapanogoan tamon Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yay laloma ay taga Creta tan taga Arabia. Anodtaw pa man, halban tamo ay angkalngo tamo hilan ampanalita ha sawsarili tamon halita, bi-sa yay antotolon la ay tongkol ha ka-paka-ngap a gawgawa nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kay la maabot isipon a pawpangyayari, kanya wanla ha a-sa tan a-sa, “Anya kari a labay totolon nin yadtin ampangyari?” ");
INSERT INTO xsb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kot wanlan pa-noya-toya nin hilay laloma, “A, lawlahing hilan bongat orin!” ");
INSERT INTO xsb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hin ya-rin ay inomdong hi Pedro, kalamo hilay labin-a-say apostolis ta nanalita ya konlan kalabongan. Wana ha makhaw a bosis, “Hikamoy kaparan Israelita tan halban anan ampi-wan iti ha Jerusalem, main akon labay ipahawang komoyo, kanya paka-long-on moyon labah. ");
INSERT INTO xsb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hay wamoyo sigoro no lawlahing kami, kot disnodon ambo ta alas nuweben bongat nin boklah. ");
INSERT INTO xsb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yadti nangyari hawanin ay yadtaw antokoyon ni Propita Joel ha Masanton Kasolatan, a wana, ");
INSERT INTO xsb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Oyay mangyari ha hoyot a panaon,’ wanan Dios: ‘Ihogo koy Ispirito ko konlan halban klasin tawtawo, kanya ha lipi moyo ay main aw-awa-nak, lalaki o babayi man a mamibalita nin ipanakom ko konla. Main anamaot aw-anakaba-yo a maka-kit nin bawbagay-bagay a ipa-kit ko konla nin bilang lan tinaynop, tan main anamaot mawmatoantawon lalaki a manaynop nin bawbagay a ipataynopan ko konla. ");
INSERT INTO xsb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iya, konan ya-rin a panaon ay ihogo ko yay Ispirito ko konlan hilay ma-magsirbi ko, lalaki o babayi man, kanya ipamalita lay ipanakom ko konla. ");
INSERT INTO xsb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mama-kit akon ka-paka-ngap a bawbagay ha langit tan ha lota a bilang ha daya, apoy tan mangakorpal a asok. ");
INSERT INTO xsb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yay awlo ay domoblom, tan yay bolan ay tomibya yan bilang katibya daya, ba-yo lomato anay maalagan awlon homin kapara ay yay awlon pa-ngokom nan Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kot hinoman a tawon homa-way konan Katawan para pailipyas ay malipyas’. Ya-rin a hola ni Propita Joel,” wani Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bi-sa wana ot impagpatoloy ni Pedro, “Hikamoy kaparan Israelita, long-on moyodti: Hi Jesus a taga Nazaret a inhogo nan Dios. Pinaptogan nan Dios yadti komoyo ta impagawa na konay gawgawa a ka-paka-ngap a bilang ha mawmilagro a pamilbian nin main nan kapangyarian. Yadti ay nangyari iti mismo kontamo, kanya tanda moyo. ");
INSERT INTO xsb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Inaboloyan nan Dios nin maiintriga ya komoyo ta yadti kot plano nay na hin kalin-oo-nawan ot tan bana ta tanda nay nan daan yay halban bawbagay a mangyari. Hikamoy namapati kona ta impapipasak moyo ya ha kros konlan dawdoka a tawo. ");
INSERT INTO xsb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Balo ta inlibri na yan Dios ha kapangyarian nin kamatyan hin pinaorong na yan nabyay ta kay ya maari pondan nin kamatyan. ");
INSERT INTO xsb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nga-min, anodti a sinolat ni Ari David a maitoring anamaot halita ni Jesus, a wana, ‘Lawah ko yan angka-kit yay Katawan. Iti ya ha dani ko pigaw kay ko maaborido. ");
INSERT INTO xsb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Bana konan yadti, maligan-maliga ko tan kay ko ma-bonbonan a boboy ko ha kaligawan. Yay lalaman koy namaot ay magpainawa nin main pag-asa, ");
INSERT INTO xsb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ta tanda ko, O Dios, a kay mo po-layan a kalolwa ko nin magpirmi ha logar a kamainan lan ni-kati. Nga-min, hiko a Banal mon Ma-magsirbi, tanda kon kay mo aboloyan nin maronot a main kon lalaman. ");
INSERT INTO xsb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Impatandaan mo kongko yay dalan makon biyay a homin anggawan, bi-sa hay kaligawan kon masyado no ma-kit katay nan arap-arapan’. Ya-rin a sinolat ni Ari David,” wani Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bi-sa wanan impagpatoloy ni Pedro, “Tawtalakaka, maibalita kon homin doda a maski man sinolat nadti, nati ya syimpri hi Ari David bi-sa intabon, tan angga hawanin ay iti ot a pinanabonan kona. ");
INSERT INTO xsb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kanya ambo yay sarili na a antokoyon na konan ya-rin a hinalita na, nokay bana ta a-sa yan propita nan Dios ay tanda na a impangako nan Dios kona, ha maigot a hompa a main a-say mangibat ha lipi na a gaw-on nan Dios nin ari a bilang kona a homin laloma no ambo yay Cristo.* ");
INSERT INTO xsb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tanda ni Ari David yay tongkol ha pa-morong mabyay ni Cristo, ta wana ha hola na hin yadtaw a ‘Yay kalolwa na ay kay na po-layan Dios magpirmi ha kamainan lan hilay ni-kati, tan yay lalaman na ay kay na aboloyan maronot.’ ");
INSERT INTO xsb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yadti hi Jesus ay pinaorong nan Dios nabyay, tan hikami halban ay tistigo konan yadti. ");
INSERT INTO xsb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Inta-gay na yay naor Dios ta ison yay na hawanin ha wanan na, bi-sa tinanggap nay Masanton Ispirito a impangako nan Ama kona para ihogo kontamon tawtawo. Hawanin, inhogo na yay na komi, kanya anodti a angka-kit moyo tan angkalngo. ");
INSERT INTO xsb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Hi Ari David ay kay noli ha langit, kot hiya mismo a nanalita nin yadti hin yadtaw, ‘Wanan Dios a Katawan konan Katawan ko: Iti ka tomoklo ha wanan ko, ");
INSERT INTO xsb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ta ta-ganan mon igwa ko ha aypa kapangyarian mo hilay kawkontra komo.’” ");
INSERT INTO xsb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Bi-sa wana ot ni Pedro, “Kanya kailangan, hitamoy halban Israelita ay dapat tamon tandaan nin homin kadoda-doda a hi Jesus a impapipasak moyo ha kros, kot hiya yay ginwa nan Dios Katawan tan Cristo.” ");
INSERT INTO xsb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hin nalngo lan tawtawo odtin halban ay na-golowan a main lan kaisipan, kanya wanla koni Pedro tan konlan kapara nan aw-apostolis, “Tawtalakaka, anya man no-nin a dapat min gaw-on?” ");
INSERT INTO xsb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Wani Pedro konla, “Pangombabalyan tan bokotan moyoy kawkasalanan moyo, ta bi-sa pabaotismo yay balang a-sa komoyo ha ngalan ni Jesu-Cristo pigaw patawaron na kamon Dios ha kawkasalanan moyo, ta bi-sa ibi na komoyoy Masanton Ispirito na. ");
INSERT INTO xsb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nga-min, yadtin Masanton Ispirito ay impangako nan Dios para komoyoy namaot tan konlan lawlipi tamo, pati konlan ampi-wan ha mangarayo, iya, para ha balang tawon ha-wayan nan Dios a Katawan tamo.” ");
INSERT INTO xsb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Lako ot a impahawang ni Pedro konla, bi-sa wanan inwawali, “Pailipyas kamo pigaw kay kamo ma-parosawan a bilang konlan dawdoka a tawo hawanin.” ");
INSERT INTO xsb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hiladtaw a maligan ni-pol ha impahawang ni Pedro ay binaotismowan hila. Kanya main manga tolonlibon tawtawo a naipa-lah konlan antompol koni Jesus hin ya-rin ot a awlo. ");
INSERT INTO xsb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nagpatoloy hilan maptog ha kaho-honol ha tawtotoro lan apostolis, anorin kapara ha pa-miasa-sa la bilang mita-talakaka, ha pa-mititipon nin mangan tinapay bilang pa-manomtom nin pa-ngamati ni Jesus tan ha kada-dawat. ");
INSERT INTO xsb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hilay aw-apostolis ay ampakagawa nin lako a gawgawa a ka-paka-ngap, pawpamilbian kapangyarian nan Dios, kanya halban lan tawo ay masyadon ampaka-ngap. ");
INSERT INTO xsb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Halban lay namaot antompol koni Jesus hin ya-rin ay nagpatoloy ha maigot a pa-milalamo, tan anyamay ikon nin a-sa ay an-itoring ikon nin halban. ");
INSERT INTO xsb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","An-ilako lay namaot a main lan lawlota tan laloman kama-main, ta bi-sa yay angka-paglakoan ay an-ipapto la konlan kawkalamoan la ayon ha main lan pangangailangan. ");
INSERT INTO xsb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inawlo-awlo ay patoloy hilan ampititipon ha timplo nan Dios nin asa-say kanakoman tan ampilalamo anamaot ha bawbali la nin mangan tinapay bilang pa-manomtom nin pa-ngamati ni Jesus. Ampangan hilan main awit kaligawan tan malinis a kanakoman. ");
INSERT INTO xsb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pirmi lan amporiwon yay Dios, tan halban lan tawtawo ay angkalilikot konla. Inawlo-awloy namaot ay main tawtawo a an-ipa-lah nan Katawan ha gropo lan hilay antompol a inlipyas na. ");
INSERT INTO xsb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","A-say apon, bandan alas tres, nako hi Pedro tan hi Juan ha timplo, ta ya-rin a nakaogalian lan aw-Israelita a oras nin main lan kada-dawat. ");
INSERT INTO xsb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Itaw ha anha-wayan “Magandan Polta” a mamaloob ha timplo ay main a-say lalakin paralitikoy bitih paibat ot hin in-abing. Inawlo-awlo yan an-alsawon para igwa itaw ta ampakilimoh ya ha tawtawon anlomoob ha timplo. ");
INSERT INTO xsb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hin na-kit nan lomoob hi Pedro tan hi Juan ay nakilimoh ya konla. ");
INSERT INTO xsb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Hinilap la ya, bi-sa wani Pedro kona, “Homilap ka komi!” ");
INSERT INTO xsb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hinilap na hilay naor ta hay wana no limohan la ya. ");
INSERT INTO xsb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kot wani Pedro kona, “Homin akon kwartan balitok ni pilak, balo ta main akon laloman maibi komo. Ha ngalan ni Jesu-Cristo a taga Nazaret, lomalako ka!” ");
INSERT INTO xsb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bi-sa ginawang ni Pedro a wanan gamot na ta ampa-dongon na ya. Antimano kinomhaw a ayi na pati baya-til na. ");
INSERT INTO xsb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nilomokho yan inomdong, bi-sa nilomalako. Ampilo-lokho yay nan naki-ka konla ha loob timplo nin andayawon na yay Dios. ");
INSERT INTO xsb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Halban tawtawo itaw hin ya-rin ay na-kit la yan anlomalako tan ampanayaw konan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na-bilbi lan hiyadtaw a ma-makilimoh a pirmin nakatoklo ha liglig nin ya-rin anha-wayan “Magandan Polta”, kanya ambo makano-kanoy ispanta la ha nangyari kona. ");
INSERT INTO xsb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hin lo-gan maga-gaga-got ya ot konli Pedro tan hi Juan orin lalakin inomabig, halban lan tawtawo ha kaispantawan la ay nolayon dinomani konla itaw ha a-say logar ha timplo a anha-wayan “Balkonahi ni Ari Solomon”. ");
INSERT INTO xsb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hin na-kit nay anorin ni Pedro, wana konlan tawtawo, “Hikamoy kawkaparan Israelita, anongkot ampag-ispantawan moyodtin nangyari kona, tan anongkot anhilap-hilapon moyo kami? Ola-no hay wamoyo, sarili min kapangyarian a na-palalako mi yadtin lalaki o bana wari ta maka-Dios kami. ");
INSERT INTO xsb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kai, ta yay Dios lan kalimpapo-papoan tamon hi Abraham, Isaac tan Jacob, hiyay main gawa nin yadti para ma-parangalan yay Anak na a hi Jesus. Kot in-intriga moyo ya konlan ampamoon kontamo a taga Roma, bi-sa intakwil moyo ya ha arapan ni Gobirnador Pilato anta dinisisyonan nay na nin bolohan ya. ");
INSERT INTO xsb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iya, intakwil moyo yay Banal tan Maptog, bi-sa yay impapiboloh moyo paot ay yadtaw ma-mangmatin tawo. ");
INSERT INTO xsb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Hikamo a namapati konan yay ampangibatan nin biyay. Anorin pa man, pinaorong na yan nabyay Dios. Hikami tistigo nin yadti. ");
INSERT INTO xsb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hawanin, bana ta hinabtan mi ngalan ni Jesus ta antompol kami naor kona, kinomhaw odtin lalaki a angka-kit tan bilbi moyo. Iya, yay katotpol mi koni Jesus a pinangibatan a talagan inomabig yay na a bilang angka-kit moyon halban. ");
INSERT INTO xsb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Hawanin, tawtalakaka, tanda ko a kanya moyo impapati hi Jesus ay bana ta hikamo pati hilay ampamoon kontamon Israelita ay kay moyo tanda no hino ya. ");
INSERT INTO xsb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kot ha anorin a nangyari ay tinoor nan Dios yay impapibalita na konlan halban pawpropita na hin yadtaw a kailangan magdya-dya yay Cristo. ");
INSERT INTO xsb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kanya mangombabali kamoy na tan bokotan moyoy nay kawkasalanan moyo. Ibalik moyoy kawkanakoman moyo konan Dios a Katawan pigaw alihon nay kawkasalanan moyo tan makalato a panaon nin ba-yon kaligawan a ibat kona. ");
INSERT INTO xsb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ihogo na yan oman iti ha kalotaan hi Jesu-Cristo a impangaral ana komoyo. ");
INSERT INTO xsb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Balo ta kailangan itaw ya yapon ha langit ta painsan ya ot makon oman iti ha kalotaan no ba-yowan nay nan Dios a halban bawbagay. Anodti a impapibalita na konlan bawbanal nan propita paibat hin palsawon nay babon lota. ");
INSERT INTO xsb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Wanay naor ni Moises konlan kawkapapo-papoan tamo, ‘Yay Dios a Katawan tamo ay mamihogo ya komoyo nin a-say propita a bilang kongko a kapara tamon Israelita. Kailangan paka-honolon moyoy halban ibalita na komoyo. ");
INSERT INTO xsb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Yay tawon kay homonol ha ibalita nan yadtin propita ay doka a ogotan na ta kay yay na ibilang tawo nan Dios.’ ");
INSERT INTO xsb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Hila man a halban pawpropita nan Dios paibat koni Propita Samuel ay pari-pariho lan impamalita yay ampangyari konan yadtin panaon. ");
INSERT INTO xsb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yay pawpangako nan Dios a imparalan konlan pawpropita na ay para kontamo, tan kalamo tamoy namaot ha kasondoan na a inimbi na konlan kalimpapo-papoan tamo. Wanay naor Dios hin yadtaw koni Abraham, ‘Alang-alang konan a-sa ha lipi mo ay payabolan kon abig a intiron tawtawo ha mondo.’ ");
INSERT INTO xsb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kanya kontamon Israelita na ya yapo inhogo nin Dios yay Anak nan hi Jesus para tambayan na tamo nin bokotan yay doka a pamimiyay.” ");
INSERT INTO xsb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hin lo-gan ot ampanalita hi Pedro tan hi Juan konlan tawtawo, main nilomato a pawpari, main anamaot kapitan a poon lan gawgwardya ha timplo tan main ha gropo lan Saduseo. ");
INSERT INTO xsb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nasora hila konlan loway apostolis ta an-itoro tan an-ipangaral la ha tawtawo a norong nabyay hi Jesus, pa-maptog a main pa-morong mabyay. ");
INSERT INTO xsb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kanya dinakop la hiladtin lowa ta ingkolong anggan boklah bana ta anyomabi na hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Anodtaw pa man, lako konlan nakalngo nin aral la a tinompol koni Jesus, kanya yay nag-in bilang lan lawlalaki a antompol ay main manga limanlibo. ");
INSERT INTO xsb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hin kinadilapan ay nititipon hilay pinakamata-gay a konsiho nin nasyon Israel, labay totolon hilay pawpoon nin Israelita, hilay laloma ot a main katongkolan tan hilay mawmaistron kapanogoan. ");
INSERT INTO xsb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Konan ya-rin a pa-mititipon la itaw ha syodad Jerusalem ay kabilang ya ison yay pinakapoon pari a hi Anas tan hilay laloman pawpari a kawkanayon na a bilang konli Caifas, hi Juan tan hi Alejandro tan laloma ot. ");
INSERT INTO xsb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Impaha-wayan la hi Pedro tan hi Juan, bi-sa pinastang hiladtin lowa ha main lan pibotlayan, wanla, “Pa-no moyo ya na-palalako odtin lalakin datin paralitikoy bitih? Anya magkapangyarian o hino ngalan a hinabtan moyo ta nagawa moyodti?” ");
INSERT INTO xsb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Inombat hi Pedro nin pinango-nawan yan hosto nin Masanton Ispirito nan Dios, wana konla, “Mapagalang min pawpoon tan mawmain katongkolan, ");
INSERT INTO xsb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lamang ta ampastangon moyo komi yay tongkol ha ginwa min kaabigan konan yadtin lalaki tan no pa-no ya pinaabig, ");
INSERT INTO xsb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","labah a ma-tandaan moyon halban iti, pati nay halban kapara tamo ot Israelita a kanya angka-kit moyo yan ampaka-dong tan maligsa yadtin lalaki ay bana ha kapangyarian ni Jesu-Cristo a taga Nazaret ta hinabtan mi ngalan na. Impapipasak moyo ya ha kros kot pinaorong na yan nabyay Dios. ");
INSERT INTO xsb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Hi Jesus odtaw pa-hal bato a antokoyon ha Masanton Kasolatan, a wana, ‘Yay bato a impoyra moyon hikamoy karpintiro, yadtaw mismo a ginwa pinakapondasyon nin bali.’ ");
INSERT INTO xsb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Nga-min, homin laloman maka-pilipyas kontamo ha kasalanan no ambo hi Jesus bongat, ta homin laloman ngalan a inimbi iti ha intiron mondo para mamilipyas kontamon tawtawo,” wani Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Naka-ngap hila-rin mawmyimbro nin pinakamata-gay a konsiho nin nasyon Israel bana ha kakhawan nakom ni Pedro tan hi Juan ha pananalita la ha pobliko, anta tanda lan ordinaryo hilan bongat tawo tan kay nakapag-aral. Kot na-panomtoman la a lawah na hilan kalamo-lamo ni Jesus hin yadtaw. ");
INSERT INTO xsb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hawanin, homin hilan mahalita konli Pedro tan hi Juan, lalo paot ta yay lalaki a na-paabig la ay ison nakaodong ha dani la. ");
INSERT INTO xsb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kanya, yay ginwa lan hiladtin mawmyimbro nin pinakamata-gay a konsiho ay pinalikol la yapon hi Pedro tan hi Juan itaw ha ampag-imbistigawan konla ta nipapa-no hila yapon. ");
INSERT INTO xsb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wanla ha a-sa tan a-sa, “Anya may dapat tamon gaw-on konla? Tanda lan halban tawtaga Jerusalem a hilay main gawa konan ya-rin a ambo basta-bastan milagro tan kay tamo maari ibori bana ta talagan potog. ");
INSERT INTO xsb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kot pigaw kay ana masyadon mibantog ay kailangan paka-bibilinan tamo hila a ando hilay na mangaral tongkol koni Jesus ni ba-banggiton a ngalan na.” ");
INSERT INTO xsb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kanya impaha-wayan lan oman hi Pedro tan hi Juan ta binawalan na hila a ando hilay na mangaral-aral ni mama-banggit ngalan ni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kot wanli Pedro nin inombat, “Anya kot balo a tama ha hilap nan Dios: Yay hikamoy honolon o yay Dios? Isipon moyo! ");
INSERT INTO xsb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nga-min, kay mi magwa orin labay moyo a ando mi totolon yay na-kit mi tan nalngo tongkol koni Jesus.” ");
INSERT INTO xsb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kot binantaan hila ot syimpri nin hilay konsiho, bi-sa hila binolohan ta homin hilay nan lamang ma-kit rason para parosawan hila, lalo paot halban lan tawtawo ay biig ampamori konan Dios bana ha nangyari. ");
INSERT INTO xsb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A-sa ot, yadtaw lalakin paralitikoy bitih a pinangwaan lan milagro para omabig ay maholok anan a-pat a polo a taon a idad na. ");
INSERT INTO xsb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hin ya-rin a binolohan lay na hi Pedro tan hi Juan, antimano norong hilay na konlan kawkalamoan la. Tinotol la no anyay imba-balita lan pawpoon pari tan hilay pawpoon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Hin nalngo la-rin, halban la ay niasa-san dinomawat ha Dios. Wanla ha dawat la, “O Katawan, hikay Dios a namalsan langit, lota pati ambay tan halban bawbagay ha aytimay logar. ");
INSERT INTO xsb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Main kan impahalita koni Ari David a ma-magsirbi mo hin yadtaw nin anodti: ‘Anongkot masyadoy amot olo lan hilay ambo Israelita? Tan anongkot ampagplano hilan doka anta homin anan lamang ogotan? ");
INSERT INTO xsb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hilay aw-ari ha kalotaan tan pawpoon nin nangasasari a lawlogar ay parihadoy na ta nititipon hilay na para labanan yay Katawan tan hi Cristo a inhogo na.’ ");
INSERT INTO xsb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Pinomtog, O Dios, ya-rin a impahalita mo ta nititipon anaor hila ni Herodes Antipas tan hi Gobirnador Poncio Pilato, pati hilay ambo Israelita tan hilay laloman kaparan Israelita a angkomontra konan Anak mon hi Jesus a banal a pinili mon mag-in Cristo. ");
INSERT INTO xsb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ginwa lay naor kona yay halban bawbagay a talagan intakda moy nan mangyari. ");
INSERT INTO xsb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hawanin, Katawan, tanda moy pa-magbanta la komi. Kanya tambayan mo kamin ma-magsirbi mo, para patoloy min maipangaral yay Halita mo nin main hoston kohaw nakom. ");
INSERT INTO xsb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipa-kit mo pay kapangyarian mon mamaabig konlan hilay mawmain masakit tan aboloyan mo pa a ha ngalan nin banal mon Anak a hi Jesus ay makagwa kamin gawgawa a ka-paka-ngap a pawpamilbian nin kapangyarian mo.” ");
INSERT INTO xsb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pa-makayari lan dinomawat, nayogyog yay logar a kamainan la. Halban la ay pinango-nawan hosto nin Masanton Ispirito nan Dios ta bi-sa nagpatoloy hilay nan nangaral Halita nan Dios nin main hoston kohaw nakom. ");
INSERT INTO xsb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Halban lan antompol ay asa-say kaisipan tan kalabayan. Homin ni a-sa konla a ampanarili nin main lan kama-main, nokay an-ibilang la a yadti kot para ha halban. ");
INSERT INTO xsb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hilay namaot a aw-apostolis ay main hilan ambo basta-bastan kapangyarian ha pangangaral tongkol ha pa-morong mabyay ni Jesus a Katawan. Impa-kit nay namaot Dios konlan halban antompol yay hi-ban a inganga-ro na. ");
INSERT INTO xsb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Homin ni a-sa konla a ampagkolang ha kabi-biyay ta hilay mawmain lawlota tan bawbali ay an-ilako ladti ta bi-sa yay angka-paglakoan ");
INSERT INTO xsb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ay an-ibi la konlan aw-apostolis para ipapto ayon ha pangangailangan nin balang a-sa. ");
INSERT INTO xsb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","A-sa konla ay hi Jose a lipi ni Levi. Taga yan polo Chipre tan yay ha-way lan aw-apostolis kona ay Bernabe, yay labay totolon ay “Ma-makhaw Nakom”. ");
INSERT INTO xsb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Inlako nay lota na bi-sa in-intriga nay kwartan na-paglakoan konlan apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Main anamaot miambali a nakialig naglako nin main lan lota. Yay ngalan nin lalaki ay Ananias tan yay babayi ay hi Safira. ");
INSERT INTO xsb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Balo ta bina-wahan ni Ananias a na-paglakoan nin tanda ni Safira. Bi-sa yay natla ay yadtaw a in-intriga na konlan aw-apostolis a konwari yadtaw bongat a na-paglakoan la. ");
INSERT INTO xsb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kot wani Pedro, “Ananias, anongkot pinayagan mon pango-nawan ni Satanas a main mon kanakoman nin mangalotoy konan Masanton Ispirito nan Dios ison ha gawa mon pa-miharya nin laloman kwarta, ta konwari yadti bongat a na-paglakoan moyon lota? ");
INSERT INTO xsb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ambo doman ikon moyoy lota hin kay moyo ot nalako? Tan maski hin nayari moyoy nan inlako, ambo doman magawa moyoy balang labay moyo ha na-paglakoan? Anongkot man ta inisip mo ot gaw-on orin? Yay Dios a mo-na mo-na mon ginalotoy nin ya-rin, ambo tawo!” ");
INSERT INTO xsb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pa-makalngo nan ya-rin ni Ananias ay natomba ya a toloy nan ingkamati. Halban lan nakalngo ay nali-mon hosto. ");
INSERT INTO xsb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yay ginwa lan hilay aw-anakaba-yo itaw hin ya-rin ay pinotot la ya ta ini-ka lan intabon. ");
INSERT INTO xsb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pa-makalabah toloy oras ay nakalato hi Safira a kaambali na. Kot kay na tanda no anyay nangyari. ");
INSERT INTO xsb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Wani Pedro kona, “Safira, yadti bongat doman a na-paglakoan lota moyon miambali?” Obat ni Safira, “Iya, ya-rin bongat.” ");
INSERT INTO xsb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kot wani Pedro kona, “Anongkot pini-sondoan moyon miambali yadtin gawa a pa-nobok konan Ispirito nan Katawan? Oy, iti hilay na ha polta hilay namitabon konan kaambali mo. Ihonol la kay namaot!” ");
INSERT INTO xsb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Antimano, natomba hi Safira ha arapan ni Pedro a toloy nan ingkamati. Hin nilomoob hilay naor a aw-anakaba-yo, na-kit lan main anaman nati. Kanya kinwa lay namaot ta ini-ka lan intabon ha danin kaambali na. ");
INSERT INTO xsb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hin ya-rin, intiro lan antompol tan halban lan naka-tanda ay nali-mon masyado. ");
INSERT INTO xsb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hilay aw-apostolis ay ampakagawa nin lako a gawgawa a ka-paka-ngap, pawpamilbian kapangyarian nan Dios a angkaimatonan lan tawtawo. Halban lan antompol koni Jesus ay itaw hila nanga-piasa-san nititipon ha anha-wayan “Balkonahi ni Ari Solomon”. ");
INSERT INTO xsb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Homin ni a-sa konlan hilay kay antompol a nagkohaw nakom nin makiasa-sa konla maskin mata-gay a rispito la konla. ");
INSERT INTO xsb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kot syimpri anlako anan anlako a ampipa-lah ha bilang lan antompol koni Jesus a Katawan, lalaki man o babayi. ");
INSERT INTO xsb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bana ha kawka-paka-ngap a angkagwa lan aw-apostolis, ki-kinwa lan tawtawoy mawmain masakit ta ini-ka la ha kalsada, bi-sa impaira ha kawkatri tan aw-apay la pigaw maskin mihagoy tanay anino ni Pedro konla ha kala-labah na, omabig hilay na. ");
INSERT INTO xsb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Golpin tawoy ampi-pakalato itaw ha syodad Jerusalem a angkaibat ha ka-libol bawbabali, ta awit lay mawmain masakit tan nilooban nin dawdoka a ispirito. Halban la ay biig pinaabig nin hilay aw-apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Hilay aw-apostolis ay masyadoy nan angkainggitan nin yay pinakapoon pari pati halban kalamoan na a kasapi ha gropo lan Saduseo. ");
INSERT INTO xsb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kanya impaaristo na hila bi-sa impapikolong. ");
INSERT INTO xsb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kot kinayabiwan, main a-say anghil nan Katawan a nako itaw ha prisowan ta inabriyan nay poltan pinamikolongan konla. Pinalikol na hila, bi-sa wana konla, ");
INSERT INTO xsb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mako kamo ha timplo ta ipangaral moyo konlan tawtawo itaw yay halban bawbagay tongkol konan yadtin ba-yon biyay.” ");
INSERT INTO xsb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hinonol lan aw-apostolis a pinanogoan nan anghil, kanya mahakbay hilan nako ha timplo nin nangaral. Hin ya-rin, yay pinakapoon pari tan hilay kawkalamoan na ay tinipon lay pawpoon nin Israelita a kapara lan myimbro nin pinakamata-gay a konsiho nin nasyon Israel para ha a-say sisyon, ta bi-sa impakwa lay aw-apostolis ha prisowan konlan hawhondalo. ");
INSERT INTO xsb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kot hin lomato hiladtin hawhondalo itaw ha prisowan ay homin hilay nay aw-apostolis. Kanya nagbolta hila itaw ha pinakamata-gay a konsiho, ta wanlan imbalita, ");
INSERT INTO xsb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hin lomato kami itaw ha prisowan ay na-lato min nakasosi labah a polta, bi-sa ha lalo, halban lan gwardya ay biig anamaot maba-babantay ha pawpoltan silda. Kot hin inabriyan mi silda la ay homin kamin na-kit tawo ha lalo!” ");
INSERT INTO xsb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hin nalngo la-rin, naka-ngap yay pinakapoon pari, yay poon lan gwardya nin timplo tan hilay laloma ot a pawpoon pari. Bi-sa na-golowan hila no anya ot kari a homonol mangyari. ");
INSERT INTO xsb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tongwa, main nakalato nin a-say lalaki. Wana konla, “Hiladtaw impriso moyo ay itaw hilan an-o-dong ha timplo nin ampangaral ha tawtawo.” ");
INSERT INTO xsb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kanya antimano, yay poon lan gwardya tan hilay tawtawo na ay kina lay aw-apostolis para dakpon, balo ta kay la dinalan ha pwirsawan, bana ta angkali-mo hila konlan tawtawo ola-no batibaton hilan bato. ");
INSERT INTO xsb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hin na-dakop hilay na ay in-arap hila ha pinakamata-gay a konsiho. Bi-sa pinastang na hila nin yay pinakapoon pari, ");
INSERT INTO xsb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","wana, “Mahigpit min imbawal komoyo a ando moyoy na iaral-aral ya-rin tongkol koni Jesus, kot biliwon moyoy ginwa moyo! Imbantog moyoy na ingat ha intiron Jerusalem orin a an-iaral moyo, bi-sa hikami ot paot a labay moyon mangobat ha pa-ngamati na.” ");
INSERT INTO xsb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kot wani Pedro tan hilay kapara nan aw-apostolis, “Iya ta dapat yay Dios a honolon mi ambo tawo. ");
INSERT INTO xsb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yay Dios a sinamba lan kapapo-papoan tamo ay hiya a namaorong nabyay koni Jesus a pinati moyo ta impapipasak moyo ya ha kros. ");
INSERT INTO xsb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yadti hi Jesus ay inta-gay na yan Dios ha main nan kapangyarian bilang Poon tan Ma-milipyas, pigaw biyan na tamon oportonidad a aw-Israelita para mangombabali tan bokotan a kawkasalanan tamo ta bi-sa patawaron na tamo. ");
INSERT INTO xsb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hikami tistigo konan yadtin nangyari koni Jesus, tan ambo bongat hikami nokay pati yay Masanton Ispirito nan Dios a an-ipakiasa-sa na ha balang tawon anhomonol kona.” ");
INSERT INTO xsb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hin nalngo lan mawmyimbro nin pinakamata-gay a konsiho yay imbalita li Pedro ay ambo makano-kanoy amot olo la, kanya pini-sondoan lan ipapati a aw-apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kot inomdong yay a-sa konla, a-say Pariseo a yay ngalan na kot Gamaliel, a-say maistro nin kapanogoan a anggalangon nin halban tawtawo. Impapilikol na hilay aw-apostolis nin domali. ");
INSERT INTO xsb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bi-sa wana konlan hilay kawkalamoan nan myimbro nin pinakamata-gay a konsiho, “Kawkaparan Israelita, mag-ingat tamo ha labay tamon gaw-on konlan hila-rin a tawo. ");
INSERT INTO xsb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nga-min, kay ot naboyot nilomtaw yadtaw hi Teudas a nagkonwari nin ambo basta-bastan tawo, bi-sa main manga a-pat a yatos katawo a nakiasa-sa kona. Kot hin na-pati ya, halban lan tawtawo a hinomonol kona ay niboyak, kanya homin anan lamang inogotan. ");
INSERT INTO xsb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bi-sa main anaman nilomtaw a-say taga probinsyan Galilea a yay ngalan kot Judas. Panaon pa-marihistron tawtawo hin yadtaw bana ha pamamayar nin bowis. Lako anamaot a naayat nan homonol kona. Kot hin na-pati ya, halban lan tawtawo a hinomonol kona ay niboyak anamaot. ");
INSERT INTO xsb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kanya, yay ma-halita ko, po-layan tamo hila-rin a tawtawo, ta no ya-rin a antatalawon o anggaw-on la kot ibat bongat ha kalabayan nin tawo ay homin anan lamang syimprin ogotan. ");
INSERT INTO xsb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kot no wari ta ya-rin kot kalabayan nan Dios ay kay tamoy nan lamang ma-patgon orin, tan ola-no hitamo ot a lomwah nin anlomaban konan Dios.” ");
INSERT INTO xsb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pinomayag hilay mawmyimbro nin pinakamata-gay a konsiho koni Gamaliel. Kanya impaha-wayan hila tanay aw-apostolis ta impagaroti, bi-sa binawalan hilan ando lay na ipangaral yay tongkol koni Jesus. Pa-makayari ay binolohan hilay na. ");
INSERT INTO xsb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Inomalih hilay aw-apostolis itaw ha kamainan nin pinakamata-gay a konsiho nin angkalilikot, ta a-say karangalan konla a imbilang na hilan Dios marapat domalan ha karingoyan alang-alang ha kaho-honol la koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Inawlo-awlo hila syimprin ampako ha timplo tan ha bawbali ta nagpatoloy hila ha pa-mitoro tan pangangaral nin Labah a Balita tongkol koni Jesu-Cristo. ");
INSERT INTO xsb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hin ya-rin a anlomako anan anlomako hilay antompol koni Jesus, hilay Israelita a ampigamit halita Griego ay nagriklamo konlan hilay lihitimon Israelita, ta angka-po-layan a pa-mamin pa-mangan ha inawlo-awlo konlan bawbabayin balo ha gropo la. ");
INSERT INTO xsb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kanya tinipon lan labinloway apostolis a halban lan antompol koni Jesus, bi-sa wanlan imbalita konla, “Tawtalakaka, ambo marapat a po-layan mi yay pangangaral nin Halita nan Dios para bongat maka-pipapto nin pa-mangan. ");
INSERT INTO xsb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanya mamili kamon pitoy lalakin bilbi a labah a pa-magkatawo, mangaronong tan ampango-nawan Masanton Ispirito nan Dios, ta hila a pa-tayaan tamo konan ya-rin a gawa. ");
INSERT INTO xsb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Hikami namaot ay ibi mi halban panaon mi ha kada-dawat ha Dios tan ha pangangaral nin main nan Halita.” ");
INSERT INTO xsb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na-gostowan lan halban antompol yay imbalita lan apostolis. Kanya pinili la hi Esteban, a-say lalakin makhaw a katotpol tan ampango-nawan hosto nin Masanton Ispirito nan Dios. Kalamo ha pinili hila ni Felipe, hi Procoro, Nicanor, Timon, Parmenas, tan hi Nicolas a taga syodad Antioquia a sinomapi ha rilihyon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pa-makayari ay in-arap hila konlan aw-apostolis, ta indawat hila bi-sa imparna lay gamot la konla. ");
INSERT INTO xsb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lako ot a tawtawon naabotan nin pangangaral lan Halita nan Dios, kanya mas lalon nilomako a bilang lan antompol koni Jesus ha syodad Jerusalem. Golpi namaot pawpari a tinompol. ");
INSERT INTO xsb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hi Esteban ay pinayabolan na yan Dios nin makhaw a katotpol tan kapangyarian, kanya ampakagwa yan mawmilagro ha tawtawo a pamilbian kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kot main tawtawon ampaki-diskosyon kona a myimbron rilihyon a anha-wayan “Sinagoga lan Lawlibri” a ni-kaibat ha Cireneo, ha Alejandria, ha Cilicia tan ha Asia. ");
INSERT INTO xsb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kot kay la ya madaog ha rason hi Esteban bana ha karonongan na a impayabol nin Ispirito nan Dios kona. ");
INSERT INTO xsb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kanya main hilan inopitan nin omnoy lalakin manalita nin anodti laban koni Esteban: “Nalngo mi hi Esteban a amparorokaon na hi Moises tan yay Dios.” ");
INSERT INTO xsb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ha anorin a paralan, na-pahobhob lay tawtawo tan hilay pawpoon nin Israelita, pati hilay mawmaistron kapanogoan koni Esteban. Kanya kina la ya ta binira-bira la yan in-arap ha pinakamata-gay a konsiho. ");
INSERT INTO xsb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Nangwa hilay naman pawpalson tistigo laban koni Esteban. Wanla, “Ya-rin hi Esteban ay kay ya ma-patgon ha pananalita nan kontra konan yadtin Masagradon Timplo tan ha kawkapanogoan a inimbi nan Dios koni Moises. ");
INSERT INTO xsb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nga-min, nalngo mi yan nanalita a yadtaw kano hi Jesus a taga Nazaret ay yobaon na kano yadtin timplo tan omanon na ot kanoy natawil tamon kawkaogalian koni Moises.” ");
INSERT INTO xsb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bi-sa hin pinaka-hilap lan labah hi Esteban nin halban myimbro nin pinakamata-gay a konsiho ay na-kit la a yay lopa na ay bilang lopan anghil. ");
INSERT INTO xsb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Hawanin pinastang nan pinakapoon pari hi Esteban, wana, “Potog doman odtin dimanda la komo?” ");
INSERT INTO xsb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Inombat hi Esteban, wana, “Mawmatoa tan tawtalakaka! Long-on moyoy halitaon ko. Yay Dios a sangkalinggasan ay nagpa-kit ya konan kalimpapo-papoan tamon hi Abraham hin lo-gan itaw ya ot ampi-wan ha nasyon Mesopotamia, hin ba-yo ya nilomipat ha syodad Haran. ");
INSERT INTO xsb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Wanan Dios kona hin ya-rin, ‘Ibati mo-rin logar moyo tan kawkanayon ta lomipat ka itaw ha logar a itoro kon kaon mo.’ ");
INSERT INTO xsb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kanya imbati nay naor a logar lan caw-Caldeo ta nako ya ni-wan ha Haran. Kot hin nati yay tatay na, pinalipat na yay naman Dios iti ha kamainan tamo hawanin. ");
INSERT INTO xsb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hin yadtaw, ni makating a parti nin lota iti ay homin yan inimbi yay Dios kona para ipag-ikon na komon, balo ta impangako nan ibi odti kona pigaw maipag-ikon ladti nin lawlipi na, anggano man homin ya ot anak hin yadtaw. ");
INSERT INTO xsb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Oyay imbalita nan Dios kona, wana, ‘Mi-wan hilay lawlipi mo ha laloman nasyon. Aliponon hila itaw tan pa-pairapan lolog nin a-pat a yatos a taon. ");
INSERT INTO xsb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kot parosawan ko hila-rin tawtawon mangalipon konla. Pa-makayari ay omalih hila itaw ta mako iti ha Israel, ta iti la koy na pagsirbiwan,’ wanan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bi-sa, hin ya-rin ay inimbi nan Dios koni Abraham a a-say kasondoan a dapat kogiton a balang lalaki ha pamilya na tan maskin ha lawlipi na pigaw maibilang hila ha impangako nan Dios kona. Kanya hin in-abing hi Isaac a anak ni Abraham, pa-makalabah nanglinggon pa-miabing kona ay kinogit na yay naor. Anorin anamaot a ginwa ni Isaac ha anak nan hi Jacob, bi-sa yadtin hi Jacob, anorin anamaot a ginwa na konlan labinloway lalakin awa-nak na a pinangibatan nin labinloway lipi tamo. ");
INSERT INTO xsb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Hi Jose a a-sa konlan hila-rin labinloway anak ni Jacob ay kinainggitan lan tawtalakaka na, kanya inlako la ya para awiton ha Egipto bilang a-say alipon. Balo ta kay na ya pino-layan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Inlibri na ya ha halban dawdya-dya a dinalan-dalanan na. Hin in-arap hi Jose koni Faraon a ari lan taga Egipto ay binyan na yan Dios nin labah a pangingintindi, kanya nanabo a nakom ni Faraon kona. Kanya ginwa na yan gobirnador ha intiron Egipto tan ma-ngasiwa ot ha sarili nan kama-main. ");
INSERT INTO xsb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kay naboyot ay nagkamain bitil ha intiron Egipto tan iti ha nasyon Canaan a kamainan lan kalimpapo-papoan tamo. Masyadoy kadya-dyaan la ta homin hilay nan ma-kan hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hin na-balitaan anaor ni Jacob a main pa-mangan itaw ha Egipto ay inhogo na hilay awa-nak na a kalimpapo-papoan tamo. ");
INSERT INTO xsb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Hin pamilwa lan pa-mako ay nagpabilbi yay na hi Jose konlan tawtalakaka na. Ison anamaot ana na-tandaan ni Faraon yay tongkol ha pamilyan inibatan ni Jose. ");
INSERT INTO xsb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Hawanin, impambilin ni Jose konlan tawtalakaka na hi Jacob a tatay na pati intiron kapamilyawan na a mako hila kona ha Egipto. Pitompolo tan lima hilay halban. ");
INSERT INTO xsb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Intiron kapamilyawan ni Jacob ay nakoy naor ana itaw ha Egipto. Itaw yay na nati hi Jacob tan anorin anamaot kapara konlan hilay awa-nak na a kalimpapo-papoan tamo. ");
INSERT INTO xsb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yay bangkay la ay in-orong la itaw ha babalin Siquem, ta itaw la intabon ha panabonan a hinaliw ni Abraham konlan awa-nak nin yadtaw Hamor a tatay ni Siquem. ");
INSERT INTO xsb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Hin naabot anay panaon a tooron nan Dios a pangako na a pinanompaan na koni Abraham ay nilomabong anan golpi hilay kapapo-papoan tamo a itaw ha Egipto hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pa-makalabah nin maanloh a panaon ay nagkamain nin ari ha Egipto a homin anan tanda tongkol koni Jose. ");
INSERT INTO xsb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kanya ya-rin a ari ay inapi-api na hilay kapapo-papoan tamo, tan masyadoy karamsakan na konla ta pinilit na hilan ibantak a awa-nak lan ba-yon abing ta pigaw mati. ");
INSERT INTO xsb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Hin ya-rin ay in-abing hi Moises, a-say lalakin Israelita a na-pakagwapo. Inalagaan na yan paari ni nanay na ha loob nin toloy bolan. ");
INSERT INTO xsb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bi-sa, hin ini-ka la yay na ha kabatwan, kinwa na yan prinsisan anak ni Faraon, ta pinahi-ban bilang sarili nan anak. ");
INSERT INTO xsb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kanya hi Moises ay na-toroan ya ha halban dawdinonong lan taga Egipto, kanya nag-in yan mahosay ha pananalita tan ha gawgawa. ");
INSERT INTO xsb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hin nag-idad yay na hi Moises nin a-pat a polo a taon ay naisipan nan tibawon hilay kaparan Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hin na-kit nay a-say kaparan Israelita a anri-rindiwon nin a-say taga Egipto, tinambayan na ya, bi-sa bilang kaba-balo ay pinati na-rin taga Egipto. ");
INSERT INTO xsb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hay wana nga-min ni Moises ay tanda lan kaparan Israelita a hiyay gamiton nan Dios para mamilibri konla ha pa-makaalipon la, kot kay la payti naintindyan. ");
INSERT INTO xsb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kinadilapan, dinaniwan nay loway parihon Israelita a ampiaway. Labay na hila komon piayoson, kanya wana konla, ‘Aw-amigo, anongkot ampiaway kamo, anta kapa-halan moyo ay mitalakaka?’ ");
INSERT INTO xsb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kot inwahkil nan yay main kasalanan hi Moises, wana kona, ‘Hino kot a nanogo komo para mamoon tan manosga komi? ");
INSERT INTO xsb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Labay mo koy namaot doman patyon nin bilang ginwa mo naapon konan yadtaw taga Egipto?’ ");
INSERT INTO xsb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pa-makalngo ni Moises nin anorin ay nilomayah yan nako ha Madian, ta itaw ya ni-wan bilang a-say dayowan. Lo-gan nan itaw ay nakapagkaambali ya, bi-sa nagkaanak hilan loway lalaki. ");
INSERT INTO xsb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Pa-makalabah nin a-pat a polo a taon, main a-say anghil nan Katawan a nagpa-kit koni Moises ha itsoran apoy a anhomyab ha a-say kayon ma-ngaaypa. Itaw nangyari orin ha disyirto a madani ha Bakil Sinai. ");
INSERT INTO xsb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Naka-ngap hi Moises ha na-kit na. Hin dinomani ya para biliwon nan labah, tongwa nalngo nay bosis nan Katawan, ");
INSERT INTO xsb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","a wana, ‘Hikoy Dios lan kalimpapo-papoan moyo, yay Dios ni Abraham, ni Isaac tan ni Jacob.’ Ginoygoy hi Moises tan angkali-mo yan homilap. ");
INSERT INTO xsb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wanan Katawan kona, ‘Alihon moy apin ayi mo ta yadtin logar a an-odongan mo hawanin ay masagrado. ");
INSERT INTO xsb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Angka-kit koy pa-ma-pairap lan taga Egipto konlan tawtawo kon Israelita. Angkalngo koy aw-aloloy la, kanya nonaoy ako para ilibri hila ha pa-makaalipon. Magparihado ka ta hikay ihogo kon mangalih konla itaw ha Egipto,’ wanan Dios koni Moises.” ");
INSERT INTO xsb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Bi-sa wana ot nin impagpatoloy ni Esteban, “Yadtin hi Moises ay intakwil la hin o-na nin hilay kaparan Israelita, ta main nanalita kona nin anodti, ‘Hino kot a nanogo komo para mamoon tan manosga komi?’ Kot hiya ot syimpri a inhogo nan Dios para mango-na tan mamilibri konlan kapapo-papoan tamo. Tinambayan na yan anghil nan Katawan a nagpa-kit kona itaw ha bigla dinomtan kayon ma-ngaaypa. ");
INSERT INTO xsb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Inalih nay naor ni Moises hilay kapapo-papoan tamo itaw ha Egipto, pa-makayari nan ginomwa nin lako a gawgawa a ka-paka-ngap a pawpamilbian kapangyarian nan Dios, anorin anamaot kapara itaw ha anha-wayan ‘Ambay a Matibya’ tan maski itaw ha disyirto ha loob nin a-pat a polo a taon. ");
INSERT INTO xsb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yadti ot hi Moises a namibalita konlan kapapo-papoan tamo hin yadtaw, a wana, ‘Ha lomato a panaon, main yay naman ihogo komoyo yay Dios a Katawan nin a-say kapara tamon Israelita para mag-in propitan bilang kongko. Hiya a dapat moyon long-on.’ ");
INSERT INTO xsb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hi Moises ot syimpri a kalamo la hin nititipon hila para somamba konan Dios itaw ha disyirto. Hiyay kina-totol nan anghil itaw ha Bakil Sinai, pati hilay kapapo-papoan tamo. Hiya syimpri a nananggap nin Halita nan Dios a ampakapamin biyay para ibi kontamon Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Kot kay la ya hinonol nin hilay kapapo-papoan tamo. Nokay intakwil la ya ta nakom lan magbolta ha Egipto. ");
INSERT INTO xsb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kanya hin ya-rin a itaw ya ha ta-gay Bakil Sinai hi Moises, wanla koni Aaron, ‘Ipangwâ mo kamin rawribolto a maipagdios mi para mango-na komi. Nga-min, kay mi tanda no anyay nay nangyari konan ya-rin hi Moises a nango-na kontamon inomalih ha Egipto.’ ");
INSERT INTO xsb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kanya ginomwa hilay naor nin ribolto a kortin kilaw baka. Nangmati hilan ayop ta inda-ton la konan yay ribolto, bi-sa hilay na ni-liga-liga bana ha ribolton ginwa la. ");
INSERT INTO xsb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bana ta anorin ay binokotan na hilan Dios ta pino-layan na hilay nan somamba pati ha bawbitoon, bolan tan awlo ha langit a bilang mabasay naor ha libron sinolat lan pawpropita. Wanan sinolat la, ‘Hikamoy aw-Israelita, lolog a-pat a polo a taon moyo itaw ha disyirto ay ambo akoy pinamida-tonan moyon aw-ayop a pinati moyo, ambo doman? ");
INSERT INTO xsb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nga-min, awit-awit moyo yay toldan kamainan nan dios-diosan moyon hi Moloc tan yay ribolton dios-diosan moyon hi Renfan. Rawribolton bongat ya-rin a ginwa moyo para sambawon. Kanya po-layan katamon mabihag nin kawkaaway moyo ta awiton ha logar a lampas ot ha Babilonia.’” ");
INSERT INTO xsb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Wana ot ni Esteban, “Hilay kapapo-papoan tamo, hin itaw hilay naor ha disyirto, awit-awit lay Masagradon Toldan ampagsambawan la, pamilbian a kalamo-lamo la yay Dios. Yay pa-makagwa nin ya-rin ay ayon ha impa-kit nan Dios koni Moises a dapat nan pangaligan. ");
INSERT INTO xsb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tinawil la-rin nin hilay awa-nak la, tan awit-awit la hin hakopon la ha pangongo-na ni Josue yay lawlogar lan ambo Israelita a impatalo nan Dios konla. Patoloy ampagsambawan ya-rin a Masagradon Tolda anggan hin panaon a nag-in ari hi David. ");
INSERT INTO xsb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nalilikot yay Dios koni Ari David. Inapos ni Ari David a mamipa-dong yan a-say impagka-bali nan Dios a Dios nay namaot nin kalimpapo-papoan nan hi Jacob. ");
INSERT INTO xsb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kot yay anak na a hi Ari Solomon yay naka-pipa-dong nin yadti. ");
INSERT INTO xsb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Anodtaw pa man, yay Dios a sangkata-ta-gayan ay kay ya talagan ampi-wan ha tawtimplon impa-dong nin tawo, ta wanan impasolat konan a-say propita na, ");
INSERT INTO xsb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Yay langit a pa-hal trono ko, tan yay mondo ay pa-hal paparnaan ayi ko. Anya may klasin bali wari a maipa-dong moyo para kongko? O anya may klasin logar wari a painawawan ko? ");
INSERT INTO xsb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ambo doman halban bawbagay ay biig hikoy namalsa?’ Ya-rin a wanan Katawan.” ");
INSERT INTO xsb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bi-sa wanan impagpatoloy ni Esteban, “Hay kawkatiboyan olo moyo! Bilang kamon tawon homin tanda ha Dios ta ampagtolok-tolokan moyoy Halita na. Pirmi moyon kay anhonolon yay Masanton Ispirito na a bilang syimprin ginwa lan kapapo-papoan tamo. ");
INSERT INTO xsb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Main wari propita nan Dios hin o-nan panaon a kay la dinamsak nin hilay kapapo-papoan tamo? Pinati-pati lay aw-inhogo nan Dios a namipatanda nin tongkol ha kala-lato nan yay tawon homin ka-kasalanan. Bi-sa hikamo hawanin ay pinagtraidoran moyo ya tan impapati, ");
INSERT INTO xsb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","anta binyan na tamon Dios nin kawkapanogoan na a imparalan na ha aw-anghil na, kot kay moyo ot syimpri hinonol.” ");
INSERT INTO xsb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hin nalngo lan mawmyimbro nin pinakamata-gay a konsiho yadtin imbalita ni Esteban laban konla, ampigogot hilay na ha katindiwan hobhob la kona. ");
INSERT INTO xsb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kot yadtin hi Esteban a ampango-nawan hosto nin Masanton Ispirito nan Dios ay tinomangal ya ha langit, ta bi-sa na-kit nay kalinggasan nan Dios tan hi Jesus nin naka-dong ha wanan na. ");
INSERT INTO xsb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kanya wani Esteban konla, “Biliwon moyo! Angka-kit kon abirtoy langit tan yay Naglalaman Tawo nin naka-dong ha wanan nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Antimano pinorongan lan mawmyimbro nin pinakamata-gay a konsiho a totolyan la tan inomaghaw hilan makhaw, bana ta para konla ambo dapat ipantay hi Jesus konan Dios. Bi-sa, antimano sinogod la yan sabay-sabay, ");
INSERT INTO xsb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ba-yo intolak-tolak la yan mamalikol ha syodad Jerusalem ta bina-batibat la yan bato. Hiladtaw tawtistigo a kalamoan la ay nilohpok la yapon a ayhing la ta imbati la ha a-say anakaba-yon yay ngalan kot Saulo. ");
INSERT INTO xsb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hawanin, patoloy la yan bina-batibat bato hi Esteban a andomawat hin ya-rin, a wana, “Jesus a Katawan, an-ipa-taya koy ispirito ko komo!” ");
INSERT INTO xsb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bi-sa nanalimokor ya, ta wana ha makhaw a bosis, “Katawan, patawaron mo hila konan yadtin kasalanan a anggaw-on la.” Pa-makayari nan hinalita orin, nabtahan yay na. ");
INSERT INTO xsb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Hi Saulo ay pabor ya ha pa-mangmati la koni Esteban. Kot main lawlalakin maka-Dios a namitabon koni Esteban nin mahakit a pa-miaanito. Paibat hin ya-rin a awlo, nagkamain matindin pa-na-damsak konlan gawgropon antompol koni Jesus itaw ha syodad Jerusalem. Kanya niboyak hila ha loway probinsya a Judea tan Samaria. Kot hilay aw-apostolis ay kay inomalih ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hi Saulo namaot ay masyadon mahakit a pa-na-damsak na konlan gawgropon antompol koni Jesus, ta kina-kina nay bawbali la ta dinakop-dakop nan homin pinili, babayi man o lalaki, bi-sa na hila impa-papikolong. ");
INSERT INTO xsb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hawanin, hilay antompol koni Jesus a niboyak ay kina-kina lay intiron lawlogar a nanglibol konla ta impangaral lay Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Hi Felipe ay nako ha syodad Samaria ta impangaral nay tongkol koni Cristo konlan tawtawo itaw. ");
INSERT INTO xsb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Hilay tawo itaw ay pari-parihon ni-panglongo ha impangaral ni Felipe, hin na-tandaan la tan na-kit a mawmilagron ginwa na. ");
INSERT INTO xsb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nga-min, lako a dawdoka a ispirito a pinalayah na konlan nilooban nin main awit aghaw a kaaalih la, tan lako a tawon lopoy tan paralitiko a pinaabig na. ");
INSERT INTO xsb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kanya hi-ban a kaligawan lan tawtawo konan ya-rin a syodad. ");
INSERT INTO xsb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Itaw ha syodad Samaria ay main a-say lalakin yay ngalan kot Simon. Hin o-na ay naingganyo na hilay tawtaga probinsyan Samaria ha gawgawa nan pa-magsalamangkiro, lalo paot ta ampagkonwari yan ambo basta-bastan tawo. ");
INSERT INTO xsb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Intiron tawo ha probinsyan Samaria, mayaman man o mairap ay anlong-on la ya, ta yay wanla ison kano konay ambo basta-bastan kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Talagan anhonolon la ya bana ta naboyot na hilay nan naingganyo ha pa-magsalamangka na. ");
INSERT INTO xsb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kot hin pini-pol lay nan tawtawo a an-ipangaral ni Felipe tongkol ha pa-mag-ari nan Dios tan tongkol koni Jesu-Cristo, nagpabaotismo hilay na, lalaki man o babayi. ");
INSERT INTO xsb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hi Simon man ay naki-pol anamaot tan binaotismowan, bi-sa lawah yay nan ampaki-ki-ka koni Felipe. Ampaka-ngap ya ha angka-kit nan angkagwa ni Felipe a mawmilagro a pamilbian nin kapangyarian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Hin na-tandaan lan aw-apostolis ha syodad Jerusalem a pini-pol lan tawtaga probinsyan Samaria yay Halita nan Dios ay pina-ka la hi Pedro tan hi Juan itaw. ");
INSERT INTO xsb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hin nilomato hila itaw ay indawat la a ipakiasa-sa nan Dios yay Masanton Ispirito na konlan hila-rin ba-yon tinompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nga-min hin ya-rin a panaon ay kay ya ot impakiasa-sa yay Ispirito nan Dios konla. Binaotismowan hilan bongat ha ngalan ni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bi-sa imbabo ni Pedro tan hi Juan a gamot la konla, ba-yo impakiasa-sa nan Dios a Masanton Ispirito na konla. ");
INSERT INTO xsb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na-patnagan ni Simon a impakiasa-sa nan Dios yay Masanton Ispirito na konlan hilay binabowan lan gamot nin aw-apostolis, kanya labay nan bayaran hi Pedro tan hi Juan, ");
INSERT INTO xsb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ta wana, “Biyan moyo koy namaot nin anorin a kapangyarian a bilang komoyo, pigaw hinoman a babowan kon gamot ay ipakiasa-sa nay namaot Dios a Masanton Ispirito na konla.” ");
INSERT INTO xsb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kot wani Pedro kona, “Hika tan yay kwarta mo ay mi-lamo ha impyirno, bana konan ya-rin inisip mon maari bayaran yay an-ibi nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Talagan ambo kan kabilang komi ha trabaho, bana ta yay kanakoman mo ay ambo tama ha hilap nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pangombabaliwan mo-rin a karokaan mo, tan domawat ka konan Dios ta hapa no patawaron na ka konan ya-rin lingon kaisipan mo. ");
INSERT INTO xsb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nga-min, angka-patnagan ko a masyado kan angkainggit tan alipon kan kasalanan.” ");
INSERT INTO xsb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kanya wani Simon konla, “Hikamo pay mamidawat konan Katawan para kongko, pigaw ni anyakaman ison ha hinalita moyo ay homin mangyari kongko!” ");
INSERT INTO xsb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hin nayari namaptog hi Pedro tan hi Juan tongkol koni Jesus a Katawan tan impangaral yay Halita na itaw ha syodad Samaria ay norong hilay na ha syodad Jerusalem. Maskin ha pa-morong la ay impangaral lay Labah a Balita tongkol koni Jesus ha lako a bawbaryo nin probinsyan Samaria. ");
INSERT INTO xsb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A-say awlo, main anghil nan Katawan a nagpa-kit koni Felipe, ta wana kona, “Mako kan tampol itaw ha bagatan ha dalan a maibat Jerusalem makon Gaza a hawanin kot bilang anan disyirto.” ");
INSERT INTO xsb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tampol yay naor nako hi Felipe. Main yan na-tamolaw itaw a-say mata-gay a opisyal a taga Etiopia a kapon. Hiyay kahiro nin halban kayamanan ni Candace. Yay labay totolon Candace ay rayna ha Kaarian Etiopia. Yadtin opisyal ay nako yan sinomamba ha Dios ha Jerusalem, ");
INSERT INTO xsb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","bi-sa hin ya-rin ay amporong yay na. Nakalolan ya ha karwahi na tan ampamasa yan libro a sinolat ni Propita Isaias. ");
INSERT INTO xsb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Hawanin, wanan Ispirito nan Dios koni Felipe, “Domani ka ta sabayan moy karwahi.” ");
INSERT INTO xsb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kanya nolayo yan dinomani. Bi-sa nalngo nan ambasawon nan opisyal a libron sinolat ni Propita Isaias. Kanya namastang ya, wana, “Angkaintindyan mo doman ya-rin ambasawon mo?” ");
INSERT INTO xsb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Pa-no ko man maintindyan no homin mamipalino kongko?” wanan in-obat nin opisyal. Kanya impaki-totol na koni Felipe nin kilolan yay na ha karwahi na, bi-sa pinatoklo na ya ha dani na. ");
INSERT INTO xsb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hawanin, yay partin ambasawon na ha Masanton Kasolatan ay anodti a wana, “Kaalimbawaan na ay karniro a an-akayon ta i-ka anan patyon, tan kapa-halan na ot ay kilaw karniro a maskin angkatliban anay main nan habot, matinok yan bongat ta disnodon homin yan tolok-tolok. ");
INSERT INTO xsb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Impa-paringoy la ya bi-sa ambo ot ayon ha katoynongan a panonosga la kona. Hawanin, homin anan maka-pibalita no omnoy lawlipi na ha kalakan. Nga-min, yay biyay na iti ha lota ay kinway na.” ");
INSERT INTO xsb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Bi-sa wanan ya-rin opisyal koni Felipe, “Ipakibalita mo pa kongko no hino kot yadtin antokoyon nan Propita? Hiya wari, o main doman laloma?” ");
INSERT INTO xsb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hawanin, nag-ompisa hi Felipe konan ya-rin a partin binasa ha Masanton Kasolatan ta impahawang na konay Labah a Balita tongkol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ha patoloy a kala-lalakon lolan la ay niabot hila ha logar a main lanom. Wanan opisyal koni Felipe, “Oy anay lanom! Kay ko ot doman maari baotismowan?” ");
INSERT INTO xsb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wani Felipe kona, “Maari kay nan baotismowan no antompol kay nan losob ha nakom.” Obat na kona, “Iya, antompol ako a hi Jesu-Cristo yay Anak nan Dios.”* ");
INSERT INTO xsb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kanya impapitgon nan opisyal a karwahi ta nako hilay lowa ha lanom, bi-sa binaotismowan na ya ni Felipe. ");
INSERT INTO xsb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hin nakainapat hilay na, tongwa bigla yan inawit hi Felipe nin Ispirito nan Katawan ha laloman logar, kanya kay na yay na na-kit nin opisyal. Kot yadtin opisyal ay nagpatoloy yay nan maligan-maliga ha main nan kakaon. ");
INSERT INTO xsb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tongwa, hi Felipe namaot ay itaw yay na ha babalin Azoto. Paibat itaw ay impangaral nay Labah a Balita tongkol koni Jesus ha halban bawbabalin dinalan-dalanan na anggan hin niabot ya ha syodad Cesarea. ");
INSERT INTO xsb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kot hi Saulo ay patoloy yan ma-mot ha pa-magbanta na tan ha pa-mangmati konlan anhomonol koni Jesu-Criston Katawan. Kanya nako ya konan pinakapoon pari, ");
INSERT INTO xsb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ta namagwa yan sawsolat para mamaptog konlan ampamoon ha sawsinagoga a ampagsambawan lan Israelita ha syodad Damasco a hiya kot main karapatan manakop nin hinoman a anhomonol ha totoro ni Jesu-Criston Katawan, babayi man o lalaki ta awiton na hilan nakabalol ha syodad Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hawanin, nibwat hilay na ni Saulo tan hilay kawkalamoan na makon Damasco. Hin madani hilay na, tongwa nagkamain hawang ibat ha langit, kanya na-hawangan a logar kamainan ni Saulo. ");
INSERT INTO xsb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natomba ya, bi-sa main yan nalngo bosis a nanalita kona, “Saulo! Saulo! Anongkot mo ko anda-damsakon?” ");
INSERT INTO xsb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Hino ka, Katawan?” pastang ni Saulo. Wanan Katawan, “Hiko hi Jesus a anda-damsakon mo. Ha anorin a angga-gaw-on mo ay bilang sarili mo mismoy anhahakiton mo, ta bilang kan kabayon ampanipa nin dadagrag a an-ito-toyhok komo.*” ");
INSERT INTO xsb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nali-mo hi Saulo nin awit a ispanta, bi-sa wana, “Katawan, anyay labay mon gaw-on ko?” Wanan Katawan kona, “Omdong ka ta magdiritso ka ha Damasco ta main mamibalita komo itaw no anyay dapat mon gaw-on.” ");
INSERT INTO xsb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hin ya-rin, hilay kawkalamoan ni Saulo ay nakaodong tanan kay nakahalita bana ta nabigla hila ta nalngo ladtaw bosis, balo ta homin hilan angka-kit. ");
INSERT INTO xsb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Inomdong hi Saulo, bi-sa hin inabriyan nay mata na, kay yay na maka-kit. Kanya inakay la ya tanan kawkalamoan na anggan ha Damasco. ");
INSERT INTO xsb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Toloy awlo nan kay naka-kit tan kay nangan ni ninom. ");
INSERT INTO xsb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Hin ya-rin ay main anamaot a-say lalaki itaw ha Damasco a anhomonol koni Jesus a Katawan. Yay ngalan na ay Ananias. Kina-totol na yan Katawan a bilang nan tinaynop, wana, “Ananias.” “Anongkot, Katawan?” wanan in-obat. ");
INSERT INTO xsb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wanan Katawan kona, “Mako ka itaw ha anha-wayan ‘Dalan a Matoynong’ ta pastangon mo itaw ha bali ni Judas yay a-say lalakin taga Tarso a yay ngalan kot Saulo. Nga-min, andomawat ya hawanin. ");
INSERT INTO xsb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Impa-kit koy namaot kona a bilang ha taynop a main a-say lalaki a yay ngalan kot Ananias a lomoob ha kwarto na ta iparna nay gamot na kona pigaw maka-kit yan oman.” ");
INSERT INTO xsb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kot wani Ananias, “Katawan, lako anay namibalita kongko tongkol konan ya-rin a tawo tan ha halban angga-gaw-on nan pa-na-damsak konlan tawtawo mo itaw ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hawanin ay iti yay na ha Damasco, ta binyan la ya kano nin karapatan nin hilay pawpoon pari para dakpon a halban anhoma-way ha ngalan mo.” ");
INSERT INTO xsb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kot wanan Katawan kona, “Mako kay na ta pinili ko ya para mag-in mangangaral ko ta pigaw ipamalita nay ngalan ko konlan ambo Israelita pati konlan aw-ari la tan anorin kapara konlan Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ipatandaan ko ot kona no pa-no kalako a aw-irap a kailangan nan dalanan alang-alang kongko.” ");
INSERT INTO xsb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kanya nako yay na hi Ananias. Nilomoob ya ha balin kamainan ni Saulo ta bi-sa imparna na konay gamot na, sabay wana kona, “Talakaka Saulo, hi Jesus a Katawan a nagpa-kit komo itaw ha dalan hin nako ka iti ay hiya ot syimpri a namihogo kongko iti komo ta pigaw maka-kit kan oman tan pango-nawan na kan Masanton Ispirito nan Dios.” ");
INSERT INTO xsb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Antimano main nangadadabo bilang hawhikhik ibat ha mata ni Saulo, kanya tampol yan naka-kit oman. Inomdong ya ta nagpabaotismo. ");
INSERT INTO xsb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bi-sa hin nangan yay na ay norong anay kohaw na. Itaw yapon hi Saulo nin omnoy awlo konlan anhomonol koni Jesus ha syodad Damasco. ");
INSERT INTO xsb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bi-sa, tampol nan impangaral itaw ha sawsinagoga a ampagsambawan nin Israelita a hi Cristo kot yay Anak nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nag-ispanta hilay halban nakalngo kona ta wanla, “Ambo doman yadti yadtaw lalakin ampangmati ha hinoman a anhoma-way koni Jesus itaw ha Jerusalem? Tan yay kina na itin ya-rin ay para dakpon hilay antompol koni Jesus ta awiton na hila konlan pawpoon pari nin nakabalol?” ");
INSERT INTO xsb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kot lalon nag-in mahosay hi Saulo ha pangangaral na tan pinaptogan na a hi Jesus kot hiya talaga yay Cristo, kanya hilay Israelita a ampi-wan ha Damasco ay homin hilay nan maibabon rason kona. ");
INSERT INTO xsb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hin naboyot-boyot, piniasa-sawan lan Israelita itaw a patyon la hi Saulo. ");
INSERT INTO xsb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Balo ta na-tandaan ni Saulo a awlo-yabi la yan an-abangán ha pawpoltan padir a nanglibol ha syodad Damasco para patyon la ya. ");
INSERT INTO xsb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kot a-say yabi, yay ginwa lan hilay anhomonol koni Jesus ay pinalolan la ya ha a-say bakol, bi-sa in-ogoh la ha dobali padir pigaw makalayah ya. ");
INSERT INTO xsb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pa-magbolta ni Saulo ha syodad Jerusalem, labay nan ki-tapol ha gropo lan hilay kaparan antompol itaw. Kot halban la ay angkali-mo kona, ta kay hila ot ampi-pol a a-sa yay nan antompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Balo ta inawit na ya ni Bernabe konlan aw-apostolis, ta tinotol na konla no pa-no nagpa-kit tan naki-totol hi Jesus a Katawan koni Saulo itaw ha dalan makon Damasco. Imbalita nay namaot a kakhawan nakom ni Saulo nin nangaral tongkol koni Jesus itaw ha Damasco. ");
INSERT INTO xsb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kanya paibat hin ya-rin ay itaw yay na hi Saulo konla, ta bi-sa naki-ka yan nangaral ha intiron Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Makhaw a nakom nan nangaral itaw tongkol koni Jesus a Katawan, tan naki-diskosyon ya konlan kapara nan Israelita a maronong halita Griego. Kanya labay la yan patyon. ");
INSERT INTO xsb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hin na-tandaan la-rin nin hilay kaparan antompol ay inawit la hi Saulo ha syodad Cesarea, bi-sa pinaorong la yay na yapon ha syodad Tarso a sarili nan logar. ");
INSERT INTO xsb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Hin ya-rin ay nagkamain yapon nin katinokan hilay gawgropon antompol koni Jesus ha pawprobinsyan Judea, Galilea tan Samaria, kanya lalo hilan inomgot ha main lan katotpol. Nagpatoloy hilan main hoston kaga-galang konan Katawan tan ha tambay nin Masanton Ispirito ay patoloy hilan nilomako. ");
INSERT INTO xsb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hi Pedro namaot, ha pa-magpatoloy nan mako ha halban lawlogar ay niabot ya konlan tawtawo nan Dios ha babalin Lida. ");
INSERT INTO xsb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Main yan na-kit itaw a-say lalaki a yay ngalan kot Eneas. Yadtin hi Eneas ay waloy taon anan kay ampakaibangon ta a-sa yan paralitiko. ");
INSERT INTO xsb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wani Pedro kona, “Eneas, hi Jesu-Cristo a mamaabig komo. Mibangon ka ta limpohon mo-rin an-iraan mo.” Antimanoy naor nakaibangon ya. ");
INSERT INTO xsb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na-kit la yan halos halban tawon ampi-wan ha babalin Lida tan ha kapatagan Saron, kanya tinompol hila koni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Itaw anamaot ha babalin Jope ay main a-say babayin antompol koni Jesus a yay ngalan kot Tabita. (Ha halita Griego yadtin ngalan na ay Dorcas, yay labay totolon ay “Oysa”.) Pirmi yan anggomwa kaabigan tan antomambay konlan mangairap. ");
INSERT INTO xsb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Hin ya-rin ay nagmasakit ya tan toloy nay nan ingkamati. Pinalyo la ya bi-sa imborol ha kwarto ha ikalwan grado. ");
INSERT INTO xsb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Palibhasa ya-rin babalin Jope kot madani ha babalin Lida, tan bana ta na-tandaan lan antompol koni Jesus a itaw hi Pedro ha Lida ay nanogo hilan loway lalaki para ipaki-totol la kona a tampol yan maki-ka konla. ");
INSERT INTO xsb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kanya antimano naki-ka ya konla. Kala-lato la itaw ha Jope ay inawit la ya ha kwarto ha ikalwan grado a kamainan bangkay ni Dorcas. Piniroropongan la hi Pedro nin hilay halban bawbabayin balo nin matangih-tangih, bi-sa impa-kit la konay aw-ayhing tan aw-alimonmon a gi-ginwa ni Dorcas hin biyay na ot. ");
INSERT INTO xsb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pinalikol na hila yapon ni Pedro a halban, bi-sa ya nanalimokor ta dinomawat ha Dios. Pa-makayari ay inomarap ya ha bangkay ta wana, “Tabita, mibangon ka!” Tongway naor, nimata ya, bi-sa hin na-kit na hi Pedro ay nibangon ya ta tinomoklo. ");
INSERT INTO xsb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ginawang ni Pedro a gamot na ta inalalayan na yan inomdong. Bi-sa hina-wayan na hilay bawbabayin balo tan hilay laloma ot a antompol koni Jesus ta in-arap na ya konla nin angkabyay ana. ");
INSERT INTO xsb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yadtin nangyari ay nibantog ha intiron babalin Jope, kanya golpin tawoy tinompol koni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Itaw ya yapo naboyot-boyot hi Pedro ha Jope nin nakihanda ha bali nin a-say ma-magkakatat a yay ngalan kot Simon. ");
INSERT INTO xsb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Itaw ha syodad Cesarea ay main a-say lalakin ambo Israelita a yay ngalan kot Cornelio. Kapitan yan a-say batalyon hondalo nin Roma a ibat ha nasyon Italia. ");
INSERT INTO xsb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rilihyoso yan tawo tan main hoston li-mo ha Dios, pati yay intiron pamilya na. Hi-ban a angkaibi nan tambay konlan mangairap a Israelita, tan pirmi yan andomawat ha Dios. ");
INSERT INTO xsb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A-say awlo, manga bandan alas tres nin apon ay bilang yan nanaynop. Na-kit nan malinon-malino a main a-say anghil nan Dios a nilomoob ha kamainan na, ta wana kona, “Cornelio!” ");
INSERT INTO xsb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hin na-kit na yay anghil ay nali-mo ya, bi-sa wanan impastang, “Anongkot, mapagalang a Sinyor?” Wanan anghil kona, “Nilngo nan Dios a dawat mo tan kay na anlingwanan a kata-tambay mo konlan mangairap. ");
INSERT INTO xsb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kanya hawanin, manogo kan lawlalaki ha Jope ta ipa-ka mo hi Simon a anha-wayan Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Itaw ya ampakii-wan ha danin ambay ha bali ni Simon a ma-magkakatat. Ibalita na komo no anyay dapat mon gaw-on.” ");
INSERT INTO xsb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pa-makahalita na-rin nin anghil ay inomalih yay na. Antimano nana-way hi Kapitan Cornelio nin loway alila na tan a-say hondalo a lawah nan kalamo-lamo tan kapara nan maka-Dios. ");
INSERT INTO xsb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tinotol na yapon konla yay imbalita nan anghil, bi-sa inhogo na hilay na ha Jope. ");
INSERT INTO xsb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kinadilapan, hin madani hilay nan miabot ha Jope hiladtaw inhogo ni Kapitan Cornelio, hi Pedro namaot ay noli ha bobongan nin balin ampakihandaan na ta itaw ya dinomawat ha Dios. Bandan ogtiawloy na hin ya-rin. ");
INSERT INTO xsb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tongwa mabitil a mabitil yay na hi Pedro. Mangan yay na komon, kot lo-gan lan an-iparihadoy pa-mangan na, tongwa bilang yan nanaynop. ");
INSERT INTO xsb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Na-kit nan naabriyan a langit, bi-sa main bilang a-say mahi-ban a oloh a nakatakol yay a-pat a doyo a an-iogoh ison ha kamainan na. ");
INSERT INTO xsb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Konan ya-rin a an-iogoh ay ison anay halban klasin ayop, pati ayop tatalon tan hilay aw-angkaray tan sari-sari a manok-manok a bawal kanon nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tongwa, nalngo nay a-say bosis, a wana kona, “Omdong ka, Pedro. Mangmati ka ta mangan ka.” ");
INSERT INTO xsb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kot wani Pedro, “Kay ko magwa, Katawan, ta nika-ka-noman ay kay ko ot nangan-nangan nin anyakaman a an-itoring mayangat o bawal ayon ha kawkapanogoan.” ");
INSERT INTO xsb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kot nalngo nay naman odtaw bosis, a wana kona, “Ando mo itoring mayangat o bawal yay wanan Dios a maari kanon.” ");
INSERT INTO xsb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nitloy bisis anorin a nangyari, bi-sa pa-makayari ay biniray nan mamata-gay ha langit ya-rin bilang oloh. ");
INSERT INTO xsb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hin lo-gan na ot an-isip-isipon ni Pedro a kanaboan nin ya-rin a na-kit na a bilang nan tinaynop, na-romogan lay nan hiladtaw inhogo ni Kapitan Cornelio a bali ni Simon a ma-magkakatat, kanya itaw hilay nan maodong-odong ha polta. ");
INSERT INTO xsb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hinoma-way hila ta pinastang la no doman ta main anhanda itaw a yay ngalan kot Simon a anha-wayan anamaot Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Hin ya-rin, ampakaisipon na ot ni Pedro a kanaboan nin yay bilang nan tinaynop, tongwa imbalita nin Ispirito nan Dios kona, “Main toloy lalaki a ampaningkap komo. ");
INSERT INTO xsb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Monaoy ka tan ando ka mag-alangan nin maki-ka konla maskin ambo hilan Israelita ta hikoy namihogo konla iti.” ");
INSERT INTO xsb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nonaoy naor hi Pedro bi-sa wana konlan hila-rin toloy lalaki a inhogo ni Kapitan Cornelio, “Hiko-rin antingkapon moyo. Anya kot a sadya moyo?” ");
INSERT INTO xsb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wanlan in-obat, “Inhogo la kami ni Cornelio a a-say kapitan nin hondalo. A-sa yan labah a tawo, anggomalang konan Dios tan anrispitowon la yan halban Israelita. Imbalita nan a-say banal a anghil nan Dios kona a pa-kaon na ka kano itaw ha bali na ta pigaw malngo nay halitaon mo.” ");
INSERT INTO xsb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bana ta anorin ay pinaloob na hila ni Pedro, ta itaw na hilay na yapon pinahanda hin ya-rin a yabi. Kinadilapan, naki-ka yay na konla. Main anamaot naki-ka konla nin omnoy kaparan antompol koni Jesus a taga babalin Jope. ");
INSERT INTO xsb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Homonol a awlo ay nakalato hila ha syodad Cesarea. Anta-gan hilay na ni Kapitan Cornelio, hilay kawkanayon na tan hilay pinakaamigo na a inimbitawan na. ");
INSERT INTO xsb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pa-makalato ni Pedro ay hinakbat na ya ni Kapitan Cornelio. Nanalimokor yan palokob ha arapan na ta sinamba na ya. ");
INSERT INTO xsb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kot pina-dong na ya ni Pedro, ta wana, “Omdong ka, ta tawo koy namaot a bilang komo.” ");
INSERT INTO xsb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Patoloy hilan ampi-totol lo-gan lan anlomoob ha bali. Na-kit ni Pedro a lako a tawon nititipon itaw. ");
INSERT INTO xsb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wana konla, “Tanda moyo a ayon ha rilihyon min Israelita ay bawal komin maki-lamo o magbisita ha hinoman a ambo Israelita. Kot impatandaan nan Dios kongko a kay ko dapat itoring nin bawal o ambo marapat paki-lamoan yay hinoman a tawo. ");
INSERT INTO xsb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kanya naor, hin impa-ka moyo ko, kay koy na nag-alangan naki-ka. Hawanin, labay kon ma-tandaan no anongkot impa-ka moyo ko.” ");
INSERT INTO xsb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Wani Kapitan Cornelio, “Nakatlo ay nagsakripisyo kon kay nangan angga hin bandan anodti namaot a oras. Bi-sa manga alas tres nin apon, dinomawat ako iti ha bali. Tongwa main naka-dong ha arapan ko nin a-say lalakin nakadoloh nin ampangi-kirlap. ");
INSERT INTO xsb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Bi-sa wana kongko, ‘Cornelio, nilngo nan Dios a dawat mo tan ampanomtomon nay gawa mon kata-tambay konlan mangairap. ");
INSERT INTO xsb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kanya manogo ka ha Jope ta ipa-ka mo hi Simon a anha-wayan Pedro. Itaw ya anhomanda ha bali ni Simon a ma-magkakatat a ampi-wan ha danin ambay. Pa-makalato na, main yan ibalita komo,’ wana. ");
INSERT INTO xsb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kanya naor, antimano impa-ka kata, tan labah ta ha kaabigan mo ay nako kay naor iti. Hawanin ta iti tamoy nay halban ampititipon ha arapan nan Dios ay handa kami nan manglongo ha anyakamay ipahalita na komo.” ");
INSERT INTO xsb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Hin ya-rin ay nangaral anaor hi Pedro, wana, “Hawanin koy na angka-paptogan a halban tawo ay pantay-pantay ha hilap nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Antanggapon nay hinoman a tawo a anggomalang kona tan anggomwa nin ayon ha kalabayan nan Dios, maskin anya ya man magnasyon. ");
INSERT INTO xsb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yay Halita nan Dios ay inimbi na komin Israelita, ta impangaral anaor komi yay Labah a Balita tongkol ha pa-maki-sondo konan Dios bana koni Jesu-Cristo. (Kot Katawan ya syimprin halban.) ");
INSERT INTO xsb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tanda moyoy na-rin a balita a naibat ha probinsyan Galilea, hin nayari nan impangaral ni Juan yay tongkol ha baotismo ta bi-sa nibantog ha intiron probinsyan Judea. ");
INSERT INTO xsb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yay anhalitaon ko ay tongkol koni Jesus a taga Nazaret a binyan nan Dios nin Masanton Ispirito na tan kapangyarian, pa-maptog a hiyay inhogo na. Nako ya ha sari-sari a lawlogar ta ginomwa yan abig ha tawtawo. Pinaabig na hilay halban ampadya-dyaon ni Satanas. Nagawa nadti ni Jesus bana ta yay Dios ay ison kona. ");
INSERT INTO xsb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Hikami aw-apostolis ni Jesus ay tistigo ha halban gi-ginwa na ha logar min Israelita, ha pawprobinsya man o ha syodad Jerusalem. Ba-yo pinati la ya nin impasak ha kros. ");
INSERT INTO xsb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kot hin ikatlon awlo ay pinaorong na yan nabyay Dios. Impaipa-kit na yan Dios, ");
INSERT INTO xsb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","balo ta ambo ha halban tawo nokay komin bongat a dati nay nan pinili Dios para mag-in tistigo ha nawnangyari kona, hikami a karongo nan nangan tan ninom pa-makayari nan norong nabyay. ");
INSERT INTO xsb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Bi-sa inhogo na kamin mangaral ha tawtawo ta namaptog a hi Jesus yay pinili nan Dios nin mag-in Howis ha halban tawo, angkabyay man o nati. ");
INSERT INTO xsb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hiyay antotolon lan halban propita nan Dios hin yadtaw ha pa-maptog lan anodti: Alang-alang kona ay patawaron nan Dios a kasalanan nin hinoman a antompol kona.” ");
INSERT INTO xsb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Hin ampangaral ot hi Pedro, tongwa nonaoy yay Masanton Ispirito nan Dios ta pinakiasa-sawan na hilay halban ampanglongo ha totoro na. ");
INSERT INTO xsb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Hiladtaw kalamo ni Pedro a kapara nan antompol a Israelita ay naka-ngap bana ta impakiasa-sa nay namaot Dios a Masanton Ispirito na konlan ambo Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nga-min, nalngo la a nanalita hila ha sari-sari a klasin halita a impahalita nin Ispirito nan Dios konla tan nalngo lay namaot a ampanayaw hila konan Dios. Hawanin, wani Pedro konlan kawkalamoan na, ");
INSERT INTO xsb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Pinakiasa-sawan na hilay namaot nin Masanton Ispirito nan Dios a bilang nangyari kontamo. Kanya hino man wari a maari mamawal nin baotismowan hila?” ");
INSERT INTO xsb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kanya minandawan ni Pedro a baotismowan hilay na ha ngalan ni Jesu-Criston Katawan. Pa-makayari ay kina-totol la hi Pedro nin itaw ya tana yapon konla nin omnoy awlo. ");
INSERT INTO xsb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na-tandaan lan laloman aw-apostolis tan hilay kaparan antompol koni Jesus ha intiron probinsyan Judea a pini-pol lay namaot a Halita nan Dios nin hilay ambo Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hawanin, main konlan hila-rin kaparan antompol a ha intindi la kot dapat yapon pakogit hilay tinompol a ambo Israelita pigaw mag-in hilay namaot hakop nin kawkapanogoan nan Dios konlan Israelita. Kanya hin norong ya hi Pedro ha syodad Jerusalem ay pinintasan la yan hila-rin. ");
INSERT INTO xsb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wanla, “Nakihanda ka kano ha ambo Israelita, bi-sa nakipangan ka ot konla anta bawal ya-rin kontamo.” ");
INSERT INTO xsb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kanya ina-sa a-sa nan impalino ni Pedro konlay intiron nangyari paibat hin ompisa. Wana, ");
INSERT INTO xsb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Hin lo-gan kon andomawat konan Dios hin itaw ako ha babalin Jope ay main akon na-kit a bilang kon tinaynop. Main nin bilang a-say mahi-ban a oloh a nakatakol ha a-pat a doyo a an-iogoh nin ma-paibat ha langit, bi-sa tinomgon ha danin kamainan ko. ");
INSERT INTO xsb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Hin biniliw kon labah, na-kit ko ison a sari-sari a klasin ayop, pati ayop tatalon tan hilay angkaray tan mawmanok-manok a bawal kontamo nin kanon. ");
INSERT INTO xsb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Bi-sa main akon nalngo bosis a nanalita, wana kongko, ‘Omdong ka, Pedro. Mangmati ka ta mangan ka.’ ");
INSERT INTO xsb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kot yay in-obat ko, ‘Kay ko magwa, Katawan, ta nika-ka-noman ay kay ko ot nangan-nangan nin anyakaman a an-itoring mayangat o bawal ayon ha kawkapanogoan.’ ");
INSERT INTO xsb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wanay naman nin yay bosis a naibat ha langit, ‘Ando mo itoring mayangat o bawal yay wanan Dios a maari kanon.’ ");
INSERT INTO xsb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nitloy bisis anorin a nangyari. Pa-makayari ay inisa nan mamata-gay ha langit ya-rin bilang oloh. ");
INSERT INTO xsb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Tongwa, antimano main toloy lalakin nakalato itaw ha balin hinandaan ko a inhogo kongko ibat ha Cesarea. ");
INSERT INTO xsb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Imbalita nin Ispirito nan Dios kongko a ando ako mag-alangan nin ki-ka konla maski ambo hilan Israelita. Hiladtin a-nom a talakaka tamo ha katotpol a taga Jope ay naki-ka anamaot kongko ha Cesarea, bi-sa nilomoob kami itaw ha bali li Kapitan Cornelio. ");
INSERT INTO xsb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Bi-sa imbalita na komi a main yan na-kit a-say anghil a naka-dong ha loob bali na, bi-sa nanalita ya kona, wana, ‘Manogo ka ha babalin Jope ta ipa-ka mo hi Simon a anha-wayan Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ipangaral na komoy hawhalita a maka-pilipyas komo pati ha halban pamilya mo.’ ");
INSERT INTO xsb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ha maparah a olit, hin nag-ompisa kon bongat nanalita konla itaw ha bali ni Kapitan Cornelio, nonaoy yay Masanton Ispirito nan Dios konla ta pinango-nawan na hilay namaot a bilang nangyari kontamo hin o-na. ");
INSERT INTO xsb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hin ya-rin ay na-panomtoman kodtaw halita nan Katawan, a wana, ‘Lanom a impamaotismo ni Juan, kot hikamo ay ma-baotismowan nin Masanton Ispirito nan Dios.’ ");
INSERT INTO xsb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bana naor ta impakiasa-sa nan Dios a Ispirito na konlan hila-rin ambo Israelita a bilang ginwa na kontamon Israelita hin tinompol tamo koni Jesu-Criston Katawan, hino ko kot wari para hadlangan a kalabayan nan Dios?” ");
INSERT INTO xsb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hin nalngo la-rin ay namakatinok hilay na, ta pinori la yay nay Dios, wanla, “Intonsis no-nin, maski hilay ambo Israelita ay binyan na hilay namaot Dios nin oportonidad para mangombabali ha main lan kawkasalanan pigaw magkamain hilan biyay a homin anggawan.” ");
INSERT INTO xsb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Hawanin, niboyak anaor hilay antompol koni Cristo bana ha pa-na-damsak konla a nag-ompisa hin pinati hi Esteban. Main konla a niabot anggan probinsyan Fenicia, ha polo Chipre tan ha syodad Antioquia. Nangaral hila tongkol koni Jesus, balo ta konlan kapara lan Israelita bongat. ");
INSERT INTO xsb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Anodtaw pa man, main konlan antompol koni Jesus a taga polo Chipre tan taga babalin Cirene a nako ha syodad Antioquia, bi-sa impangaral lay namaot itaw yay Labah a Balita tongkol koni Jesus a Katawan konlan ambo Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Binyan na hilan kapangyarian nin Katawan ha main lan pangangaral, kanya golpi tinompol tan hinomonol konan Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na-balitaan odti nin gropo lan antompol koni Jesus itaw ha syodad Jerusalem, kanya pina-ka la hi Bernabe ha Antioquia. ");
INSERT INTO xsb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hin nilomato ya itaw ay na-kit na no pa-noy kaabigan ginwa nan Dios konlan tawtawo itaw, kanya nalilikot ya. Bi-sa imbibilin na konlan halban antompol a magpatoloy hilan pakaptog konan Katawan nin asa-say kanakoman. ");
INSERT INTO xsb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ya-rin hi Bernabe ay labah a tawo, ampango-nawan hosto nin Masanton Ispirito nan Dios tan makhaw a katotpol na. Kanya lako ot a nipa-lah tinompol koni Jesus a Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pa-makayari ay nako hi Bernabe ha syodad Tarso para tingkapon hi Saulo. ");
INSERT INTO xsb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hin na-kit na ya ay inawit na ya ha Antioquia. A-say taon lan naki-lamo-lamo ha gropo lan antompol koni Cristo itaw tan golpin tawoy tinoroan la. Itaw ha syodad Antioquia o-nan pinangalanan “Kristyano” hilay antompol koni Cristo. ");
INSERT INTO xsb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Hin ya-rin ay main mawmangangaral a propita nan Dios ibat ha Jerusalem a nakalato itaw ha Antioquia. ");
INSERT INTO xsb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yay a-sa konla a hi Agabo ay inomdong ha pibotlayan la, ta imbalita na yay impanakom nin Ispirito nan Dios kona a magkamain grabin bitil ha intiron kalotaan. (Pinomtog orin hin hi Claudio a impirador ha Roma.) ");
INSERT INTO xsb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hin nalngo la-rin nin hilay antompol ay na-pi-sondoan la a mama-wit hilan tambay itaw konlan kaparan antompol ha probinsyan Judea ayon ha baba nin balang a-sa. ");
INSERT INTO xsb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kanya yay ginwa la ay impa-wit ladti konli Bernabe tan hi Saulo para ibi konlan ampamoon ha kaparan antompol koni Cristo ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Hin ya-rin a panaon, hi Ari Herodes Agripa ay nag-ompisa yan nana-damsak konlan laloman antompol koni Cristo. ");
INSERT INTO xsb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Hi Santiago a talakaka ni Juan ay impapo-tohan nan olo. ");
INSERT INTO xsb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hin na-kit ni Ari Herodes a pabor hilay Israelita ha ginwa na ay impaaristo nay namaot hi Pedro. (Nangyari orin hin pista nin Israelita a anha-wayan “Pistan Tinapay a Homin Pampalbag”.) ");
INSERT INTO xsb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pa-makaaristo koni Pedro ay impapriso na ya tan impagwardyawan ha a-pat a gropon hiyo-pat a hondalo para mi-balô-balô magbantay kona. Yay plano ni Ari Herodes ay sintinsyawan ya ha arapan pobliko pa-makayari nin Pistan Pa-makalibri nin Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kanya nakapriso ya ot hi Pedro, balo ta hilay antompol koni Cristo ay patoloy ha maigot lan kada-dawat konan Dios para kona. ");
INSERT INTO xsb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hin yadtaw oltimon yabi ni Pedro ha prisowan, bana ta kadilapan kot iarap na ya ni Ari Herodes ha pobliko para sintinsyawan ay angka-lok ya ha pibotlayan loway gwardya nin nakatikala a mi-dobali gamot na. Bi-sa main ot gawgwardyan nakabantay ha arapan poltan silda na. ");
INSERT INTO xsb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tongwa, main a-say anghil nan Katawan a nagpa-kit kona bi-sa bigla hinomawang a silda na. Tinapik na hi Pedro ha liking ta pinokaw na ya. Wana kona, “Mibangon kan tampol!” Antimano naalih a tikala ha gamot ni Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Bi-sa wana ot anghil kona, “Igwa moy tagkoh mo tan mag-apin ka.” Anorin anaor a ginwa ni Pedro, bi-sa wana ot anghil kona, “Iholot moy nay alimonmon mo ta maki-ka ka kongko.” ");
INSERT INTO xsb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bi-sa inaloyon na ya ni Pedro nin namalikol ha prisowan. Kot kay na tanda no ya-rin anggaw-on nan anghil kot talagan potog, ta ha isip na ay main yan an-ipa-kit yay Dios kona a bilang nan antaynopon. ");
INSERT INTO xsb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nilampasan lay kamainan lan o-nan gwardya, bi-sa yay ikalwa, anggan niabot hila ha poltan pasak a mamalikol anan prisowan makon syodad. Nag-aabri ya-rin polta, kanya nakalikol hila. Hin na-lampasan lay nay a-say dalan, tongwa homin yay nay anghil. ");
INSERT INTO xsb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hin naalimongawan hi Pedro, wana, “Hawanin koy na tanda a potog paytin inhogo nan Katawan a anghil na, ta inlibri na ko ha gamot ni Ari Herodes tan ha halban an-aposon lan kaparan Israelita a mangyari kongko.” ");
INSERT INTO xsb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hin ya-rin a naintindyan nay na a nangyari kona ay nako ya ha bali ni Maria a nanay ni Juan a anha-wayan anamaot Marcos. Lako a kaparan antompol a natipon itaw ta andomawat. ");
INSERT INTO xsb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kinomatok hi Pedro ha polta, bi-sa main a-say dalagan katambay a yay ngalan kot Rode a nako ha polta ta pinastang na no hinoy angkatok. ");
INSERT INTO xsb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hin na-bilbi nay bosis ni Pedro, ha sobran kaligawan na ay kay na naabriyan a polta ta antimano polayo nay nan nako ha loob ta imbalita nan itaw hi Pedro ha likol polta. ");
INSERT INTO xsb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Angkahira ana lawoy olo mo!” wanla kona. Kot impilit na a talagan hi Pedro odtaw, kanya wanla, “Ola-no anghil a bantay na-rin.” ");
INSERT INTO xsb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kot syimpri patoloy a kaka-katok ni Pedro, kanya inabriyan lay polta. Hin na-kit la a hiyan talaga ay nag-ispanta hila. ");
INSERT INTO xsb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Insinyas ni Pedro a ando hila pakatlok, bi-sa tinotol na konla no pa-no na ya impalikol nin Katawan ha prisowan. “Ibalita moyodti koni Santiago tan konlan laloma ot a kaparan antompol,” wana konla. Pa-makayari ay inomalih yay na ta nako ya ha laloman logar. ");
INSERT INTO xsb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kinaboklahan, golo-golo hilay gwardya itaw ha prisowan ta kay la tanda no anyay nangyari koni Pedro. ");
INSERT INTO xsb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Impatingkap na ya ni Ari Herodes, kot kay la yay na na-kit. Kanya yay ginwa na konlan gawgwardya ay inimbistigawan na hila ta bi-sa na hilay na impapati. Pa-makayari ay inomalih hi Ari Herodes ha probinsyan Judea ta nako ya yapon ni-wan ha syodad Cesarea. ");
INSERT INTO xsb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hin ya-rin, hi Ari Herodes ay masyado nan ampag-amotan olo hilay tawtaga syodad Tiro tan Sidon a ambo nan kahakopan. Kanya yay ginwa la ay nagmihan hilan nako para paki-kitan la ya. Balo ta inamigo la yapo hi Blasto a ampangasiwa ha palasyo, ta nagpatambay hilan maki-sondo konan ari bana ta itaw angkaibat a pa-mangan la ha logar a hakop nan ari. ");
INSERT INTO xsb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hin naabot anay awlon intakda nan ari para ka-totolon na hila, inholot nay ayhing nan pang-ari, bi-sa tinomoklo ya ha main nan trono ba-yo nagdiskorso ya konla. ");
INSERT INTO xsb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bi-sa pinori la yan tawtawo, ta wanlan in-aghaw, “Ambo yan basta-bastan tawo ya-rin ampanalita nokay a-say dios.” ");
INSERT INTO xsb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bana ta tinanggap ni Ari Herodes a papori lan tawtawo a para komon ha Dios, antimano binyan na yan masakit nin anghil nan Katawan. Inolol ya a toloy nan ingkamati. ");
INSERT INTO xsb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hin ya-rin a panaon, patoloy anlako anan anlako a tawon nanglongo tan tinompol ha Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hawanin, hin naiintriga lay na ni Bernabe tan hi Saulo yay tambay konlan antompol ha syodad Jerusalem ay norong hilay na ha syodad Antioquia. Pinaki-ka la hi Juan a anha-wayan anamaot Marcos. ");
INSERT INTO xsb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Itaw ha gropo lan antompol ha syodad Antioquia, main pawpropita tan mangangaral. Kabilang ison hi Bernabe, hi Simeon a ampangalanan Negro, hi Lucio a taga babalin Cirene, hi Manaen (a pinahi-ban kalamo ni Ari Herodes Antipas) tan hi Saulo. ");
INSERT INTO xsb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A-say awlo, hila-rin a gropo nin antompol ay nagsakripisyon kay nangan ta ginamit lay panaon para somamba ha Katawan. Hin ya-rin, main yan impanakom a Masanton Ispirito nan Dios konla, a wana, “Ipolok moyo hi Bernabe tan hi Saulo ha gropo moyo para magsirbi kongko ha gawa a intatala ko para konla.” ");
INSERT INTO xsb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hin nayari hilan nagsakripisyon kay nangan tan dinomawat, imparna lay gamot la konli Bernabe tan hi Saulo, bi-sa inhogo hilay na. ");
INSERT INTO xsb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bana naor ta inhogo hi Bernabe tan hi Saulo nin Masanton Ispirito nan Dios, kanya nako hilay na ha babalin Seleucia. Bi-sa paibat itaw ay nilomolan hila ha pontin nako ha polo Chipre. ");
INSERT INTO xsb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dinomoong hila itaw ha babalin Salamina. Bi-sa impangaral lay Halita nan Dios itaw ha sawsinagoga a ampagsambawan nin Israelita. Kalamo la hi Juan Marcos para ipagkatambay ha main lan gawa. ");
INSERT INTO xsb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kina-kina lay lawlogar konan ya-rin a polo anggan niabot hila ha dobali, itaw ha babalin Pafos. Naka-romog hila itaw nin a-say salamangkiron Israelita a ampagkonwari propita a yay ngalan na kot Bar-Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kalamoan na ya nin gobirnador nin Chipre a hi Sergio Paulo, a-say tawon matalino. Yadtin gobirnador ay impaha-wayan na hi Bernabe tan hi Saulo bana ta labay nan manglongo Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kot kinontra na hila ni Elimas a salamangkiro ta kay na labay ma-kombinsi yay gobirnador nin tompol. (Elimas yay ngalan ni Bar-Jesus ha halita Griego.) ");
INSERT INTO xsb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kot hi Saulo a anha-wayan anamaot Pablo ay pinango-nawan hosto nin Masanton Ispirito nan Dios, kanya pinaka-hilap na yay salamangkiro, ");
INSERT INTO xsb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ta wana kona, “Bilang na kan anak ni Satanas ta angkontrawon moy halban kaabigan. Ison ana komoy halban klasin pa-manglingo-lingo tan karokaan. Kay ka ot doman tomgon konan ya-rin a angga-gaw-on mo ta pirmi mon ampalwahon kagalotoyan yay kaptogan tongkol konan Katawan? ");
INSERT INTO xsb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Parosawan na kan Katawan hawanin! Mabolag ka bi-sa maboyot kan kay maka-kit nin hawang.” Antimanoy naor dinomoblom a hilap na, kanya kay yay na naka-kit, bi-sa maka-kayamkam yay nan ampaningkap nin mangakay kona. ");
INSERT INTO xsb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Hin na-kit nan gobirnador a nangyari, tinompol ya koni Jesus tan pinag-ispantawan nay totoro tongkol konan Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Inomalih hi Pablo tan hilay kalamoan na itaw ha babalin Pafos, ta nilomipay hila ha Ambay Mediteraneo ta bi-sa nako ha syodad Perge ha probinsyan Panfilia. Itaw na hila imbati ni Juan a anha-wayan anamaot Marcos ta norong yay na ha Jerusalem. ");
INSERT INTO xsb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kot hila ni Pablo, paibat Perge ay hinomaka hilay nan nakon babalin Antioquia ha probinsyan Pisidia. Hin nilomato a Awlon Pa-mainawa nin Israelita ay nako hila ni Pablo ha sinagoga la ta nakisamba itaw. ");
INSERT INTO xsb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pa-makayari nin pa-masan Masanton Kasolatan ha Libron Kawkapanogoan tan ha laloma ot a lawlibron sinolat lan propita nan Dios, impabalita konla nin hilay ampango-na ha sinagoga yay anodti, “Tawtalakaka, no main kamon labay ipangaral ha tawtawo ay libri moyon ibalita.” ");
INSERT INTO xsb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kanya inomdong hi Pablo, insinyas na a mamakatinok hilay tawtawo, bi-sa wana: “Kawkaparan Israelita tan anorin anamaot kapara komoyon halban ambo Israelita a pari-parihon anggomalang konan Dios, long-on moyoy halitaon ko. ");
INSERT INTO xsb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yay Dios a ansambawon tamon hitamoy aw-Israelita ay pinili na hilay kalimpapo-papoan tamo, tan pinalabong na hila lo-gan itaw hila ampi-wan ha Egipto a ambo lan sarilin nasyon. Ha main nan kapangyarian ay inalih na hila ha pa-makaalipon la itaw ha Egipto. ");
INSERT INTO xsb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pinagpasinsyawan nay namaot a aw-ogali la lolog itaw hila ha disyirto nin manga a-pat a polo a taon para makon Canaan. ");
INSERT INTO xsb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bi-sa impatalo na konlay pitoy nasyon ha logar nin Canaan, bi-sa inimbi nadti konlan Israilita ha paralan nin pinibobonotan la. ");
INSERT INTO xsb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Pa-makayari ya-rin halban nangyari lolog a-pat a yatos tan limampolo (450) a taon ay binyan na hilan Dios nin mag-in pawpoon a anha-wayan ‘Hawhowis’ anggan hin panaon ni Samuel a propita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bi-sa dinawat lan magkamain hilan ari. Kanya yay inimbi nan Dios konla ay hi Saulo a anak ni Cis, lipi ni Benjamin. Hiyay nag-ari konla lolog a-pat a polo a taon. ");
INSERT INTO xsb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kot hin inalih na yay nan Dios ha pa-makaari, hi David ana a inhagili nan mag-in ari la. Oyay pa-maptog nan Dios tongkol kona: ‘Na-kit ko a yadtin hi David a anak ni Jesse ay a-sa yan tawon ka-palilikot kongko tan handa yan homonol ha balang kalabayan ko.’” ");
INSERT INTO xsb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Wana ot ni Pablo, “Ha lipi nan ya-rin hi Ari David ay ison nangibat hi Jesus a ginwa nan Dios nin Ma-milipyas tamon Israelita ayon ha impangako na. ");
INSERT INTO xsb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hin ba-yo na inompisawan ni Jesus a gawa na ay impangaral ni Juan Bautista ha halban Israelita a dapat lan pangombabalyan tan bokotan a main lan kawkasalanan tan pabaotismo. ");
INSERT INTO xsb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Hin madani nay nan mayari ni Juan yay an-ipagawa nan Dios kona, wana ha tawtawo, ‘Hino ko man wari ha ola-lom moyo? Ambo hiko yay ampalatoon moyon Cristo. Kot main lomato a hoyot kongko a mas makapangyayari kongko, ta ni kordon apin na ay ambo akon marapat mangorkal,’ wani Juan.” ");
INSERT INTO xsb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Hawanin, wani Pablo, “Kawkaparan Israelita a lawlahi ni Abraham, tan anorin anamaot kapara komoyon halban ambo Israelita a anggomalang konan Dios, kontamon halban an-ipatandaan nan Dios yadtin balita no pa-no tamo malipyas. ");
INSERT INTO xsb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kot hilay tawtawo ha Jerusalem tan hilay ampamoon konla ay kay la na-bilbi a hi Jesus yay Ma-milipyas. Kay la naintindyan a hiyay antokoyon nin yadtaw sinolat lan pawpropita a an-ibasa konla topo Awlon Pa-mainawa. Kanya ha pa-mapati la koni Jesus ay natoor a hawhola lan pawpropita. ");
INSERT INTO xsb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maskin homin hilan na-kit bara-nan a dapat pangmatyan koni Jesus ay dinawat la syimpri koni Gobirnador Pilato a ipapati na ya. ");
INSERT INTO xsb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hin natoor ana-rin halban inhola ha Masanton Kasolatan tongkol koni Jesus ha paralan nin gawginwa lan angkomontra kona, hilay antompol koni Jesus ay in-aypa la ya ha kros ta inggawa la ya ha a-say panabonan. ");
INSERT INTO xsb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Kot pinaorong na yan nabyay Dios. ");
INSERT INTO xsb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Bi-sa lako a awlon nagpa-kit ya konlan naki-ki-ka kona hin yadtaw a ibat ya ha probinsyan Galilea nakon syodad Jerusalem. Hila-rin hawanin a ampamaptog ha tawtawo a na-kit la ya. ");
INSERT INTO xsb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Kanya naor, iti kami ni Bernabe ta an-ipatandaan mi komoyo yay Labah a Balita, ta yadtaw impangako nan Dios konlan kalimpapo-papoan tamon hitamoy Israelita ");
INSERT INTO xsb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ay tinoor nay na kontamon lawlahi la ta pinaorong nan nabyay hi Jesus. Nakasolat anaor itaw ha Ikalwan Kanta a wanan Dios koni Jesus, ‘Hika ay Anak ko. Hawanin ko an-ipabilbi a hika kot Anak ko.’ ");
INSERT INTO xsb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Oya ot a nakasolat tongkol ha pa-maorong nan Dios mabyay koni Jesus pigaw yay lalaman na ay kay omogot nin maronot, ta anodti wana: ‘Ibi ko komoyoy masagradon pawpayabol a sigorado moyon matanggap ayon ha impangako ko koni David.’ ");
INSERT INTO xsb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Oyay namaot a nakasolat ha a-say kanta ni Ari David: ‘Kay mo aboloyan a yay Banal a Hogo mo kot maronot a main nan lalaman.’” ");
INSERT INTO xsb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bi-sa wana ot ni Pablo, “Ambo hi Ari David a antokoyon iti, ta tanda tamo a hin nayari nay nan natoor a kalabayan nan Dios lolog biyay na ay nati ya syimpri. Intabon la ya ha pinanabonan nin tatay tan pawpapo na bi-sa naronot a lalaman na. ");
INSERT INTO xsb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kot hi Jesus a pinaorong nan nabyay Dios ay kay naronot a main nan lalaman. ");
INSERT INTO xsb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kanya labay min ma-tandaan moyo tawtalakaka a an-ipangaral mi komoyo a ha paralan ni Jesus ay main pa-matawad kawkasalanan. ");
INSERT INTO xsb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Balang tawon antompol kona ay pinatawad ha halban kawkasalanan la. Yadti ay kay ma-patawad ha paralan nin kawkapanogoan a inimbi nan Dios koni Moises. ");
INSERT INTO xsb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kanya pakaingat kamo pigaw kay mangyari komoyo yadtin impasolat nan Dios konlan pawpropita na, a wana, ");
INSERT INTO xsb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Bilyon moyoy gaw-on ko, hikamoy ampamasta-basta ha Halita ko! Mag-ispanta kamo, ta bi-sa mati! Nga-min, main akon gaw-on ha kapanaonan moyo a sigoradon kay moyo pi-polon maskin main mamibalita komoyo.’” ");
INSERT INTO xsb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hawanin, hin an-omalih hilay nay Israelita ha sinagoga, impaki-totol lan hilay ambo Israelita a magbolta hila hi Pablo tan hi Bernabe ha homonol a Awlon Pa-mainawa, ta ipangaral lay naman konla yay tongkol konan ya-rin a bawbagay. ");
INSERT INTO xsb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hin ni-porong anay tawtawo, lako konlan Israelita tan konlan hilay ambo Israelita a anhomonol ha rilihyon nin Israelita a naki-ka konli Pablo tan hi Bernabe. Nanalita hiladtin loway apostolis konla, ta winawaliwan hilan magpatoloy magbiyay nin marapat ha kaabigan nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Hin homonol a Awlon Pa-mainawa, halos intiron tawo konan ya-rin babalin Antioquia ay nititipon para manglongo Halita nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kot hin na-kit lan aw-Israelitan kay antompol koni Jesus hila-rin golpin tawo, masyado hilan nainggit. Kanya kinontra ladtaw hinalita ni Pablo tan pinaroroka la ya ot. ");
INSERT INTO xsb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kot lalon kinomhaw a nakom ni Pablo tan hi Bernabe, wanla, “Talagan kailangan komoyon kaparan Israelita yapon maipangaral yay Halita nan Dios, kot bana ta antanggiwan moyo, an-ipa-kit moyo a kay moyo an-itoring a sarili moyo nin marapat magkamain biyay a homin anggawan. Kanya hilay ambo Israelita ana a kaon min abotan nin aral. ");
INSERT INTO xsb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nga-min, yadtin nakasolat ha Halita nan Katawan tongkol koni Jesus ay ampagsirbin kapanogoan komi, a wana, ‘Ginwa katan hawang para konlan ambo Israelita ta hikay pangibatan magkamain kalipyasan a tawtawo anggan ha kalindoyo-doyowan nin mondo!’” ");
INSERT INTO xsb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hin nalngo la-rin nin hilay ambo Israelita ay nalilikot hila tan pinori lay Halita nan Katawan. Hawanin, hiladtaw intatala nan Dios nin magkamain biyay a homin anggawan ay tinompol hila. ");
INSERT INTO xsb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kanya yay Halita nan Katawan ay niabot ha intiron ka-libol nan ya-rin a logar. ");
INSERT INTO xsb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Balo ta hilay laloman Israelita a kay malabay tompol koni Jesus ay hino-hoghogan lay bawbabayin ambo Israelita a mawmaka-Dios a main mata-gay a ingkatawo, tan hilay lawlalakin ambilbion konan ya-rin a babali, kanya impada-damsak la hi Pablo tan hi Bernabe tan toloy hilan na-paalih ha intiron kahakopan nin ya-rin a babali. ");
INSERT INTO xsb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bana konan yadti, pinagpag la ni Pablo tan hi Bernabe yay gabok ha ayi la, pamilbian a hilay tawtawo itaw kot kay labay manglongo Halita nan Dios. Bi-sa nako hilay na ha syodad Iconio. ");
INSERT INTO xsb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Hila balo a tinompol koni Jesus konan ya-rin a babalin Antioquia ay hi-ban a kaligawan la tan ampango-nawan hilay nan Masanton Ispirito nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hin itaw hilay na hi Pablo tan hi Bernabe ha syodad Iconio, nako hilay naman nangaral ha sinagoga a ampagsambawan lan Israelita. Ha kaabigan pahawang la ay golpin Israelita tan ambo Israelita a tinompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kot hilay Israelita a kay labay tompol koni Jesus ay hino-hoghogan la hilay ambo Israelita tan nilason lay isip la kontra konlan kaparan antompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Naboyot hila yapo ni Pablo tan Bernabe konan ya-rin a syodad Iconio ta nagpatoloy hilan nangaral tongkol konan Katawan nin kay nag-alangan. Pinaptogan nan Katawan yay an-ipangaral la tongkol ha inganga-ro na ta binyan na hilan kababaan nin makagwa gawgawa a ka-paka-ngap a pawpamilbian kapangyarian na. ");
INSERT INTO xsb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kot hilay kalabongan ha Iconio ay napikna. Hilay laloma ay kampi konlan Israelita a kay malabay tompol koni Jesus, yay laloma ay kampi konlan aw-apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hin ya-rin, main itaw ambo Israelita tan Israelita, pati hilay ampamoon konla a nanga-pisosondo a rindiwon la tan ba-batibaton bato hi Pablo tan hi Bernabe anggan ha mati hila. ");
INSERT INTO xsb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hin na-tandaan la-rin ni Pablo ay inomalih hila ha Iconio ta nako hila itaw ha babalin Listra bi-sa ha babalin Derbe a parihon hakop nin probinsyan Licaonia tan ha kawka-libol ot a logar. ");
INSERT INTO xsb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Itaw lay na impagpatoloy a pangangaral la nin Labah a Balita. ");
INSERT INTO xsb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Hin ya-rin a ampangaral hila ni Pablo ha babalin Listra, main itaw a-say lalakin lopoy a kay ampakalalako paibat ot hin in-abing ya. ");
INSERT INTO xsb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Antoklo ya ta ampanglongo koni Pablo. Hin hinilap na ya ni Pablo ay na-patnagan nan ampi-pol ya-rin a lalaki a ma-paabig ya ha main nan dipirinsya. ");
INSERT INTO xsb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kanya wana kona ha makhaw a bosis, “Omdong kan diritso!” Antimano, nilomokho yan inomdong anaor yadtin lalaki, bi-sa nakalalako yay na. ");
INSERT INTO xsb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hin na-kit nin kalabongan ya-rin ginwa ni Pablo ay in-aaghaw la ha halita Licaonia, wanla, “Nonaoy kontamo hilay dawdios a nag-itsoran tawo.” ");
INSERT INTO xsb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Hawanin, pinangalanan la hilan ngawngalan dios-diosan: Zeus yay impangalan la koni Bernabe tan Hermes koni Pablo bana ta hiya a mabotbot nin manalita. ");
INSERT INTO xsb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ha likol nin ya-rin a babalin Listra ay main timplon ampagsambawan la koni Zeus. Kanya yay pari a ampagsirbi itaw koni Zeus ay nangawit yan bawbaka tan kawkolintan bolak ha poltan mamaloob syodad, pigaw hiya tan hilay tawtawo ay ida-ton la-rin nin popoolan para konlan aw-apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Hin na-tandaan la-rin nin hilay aw-apostolis a hi Pablo tan hi Bernabe ay nila-pak lay ayhing la, pamilbian a kontra hila ha anorin a gawa. Bi-sa nolayo hila ha pibotlayan nin kalabongan, ta wanla ha makhaw a bosis, ");
INSERT INTO xsb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Hikamoy tawtawo, anongkot gaw-on moyo-rin! Tawo kamin bongat a bilang komoyo! In-abot mi komoyoy Labah a Balita pigaw bokotan moyoy nay bawbagay a anorin a homin kakwinta-kwinta ta yay Dios a angkabyay anay sambawon moyo. Hiya a namalsan langit, lota, ambay tan halban bawbagay a main ison. ");
INSERT INTO xsb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Hin nawnakalabah a panaon, pino-layan nay tawtawo ha halban nasyon nin magwa lay balang labay la. ");
INSERT INTO xsb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Anodtaw pa man, binyan na kamo syimprin pawpamilbian pigaw ma-bilbi moyo ya, ta ambiyan na tamon mawmagandan bagay bilang ha abagat tan bawbongan tanaman ha tama a panaon, pigaw mabhoy tamo ha pa-mangan tan mapno nin kaligawan,” wanla ni Pablo konla. ");
INSERT INTO xsb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Maskin hinalita ladti ni Pablo ay halos kay hila mahaar a tawtawo ha pa-mami lan da-ton para konla. ");
INSERT INTO xsb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tongwa, main aw-Israelita a nakalato ibat ha babalin Antioquia a hakop nin probinsyan Pisidia tan ibat ha syodad Iconio. Hinoghogan lay tawtawo, kanya binatibat lan bato hi Pablo anggan ha ginoloy-goloy la yan impalikol ha babali ta hay wanla nati yay na. ");
INSERT INTO xsb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kot hin piniroropongan la yan kawkaparan antompol koni Jesus ay nibangon ya, bi-sa nagbolta ya ot konan ya-rin babalin Listra. Kinadilapan, nako hilay na ni Bernabe ha babalin Derbe. ");
INSERT INTO xsb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Impangaral la ni Pablo tan hi Bernabe yay Labah a Balita tongkol koni Jesus itaw ha babalin Derbe, tan lako a tinoroan la para mag-in disipolo ni Cristo. Bi-sa nagbolta hila ha babalin Listra, bi-sa ha syodad Iconio ta bi-sa ha babalin Antioquia a hakop nin probinsyan Pisidia. ");
INSERT INTO xsb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinakhaw lay nawnakom lan kaparan antompol ison konlan hila-rin a lawlogar. Winawaliwan na hilan magpatoloy ha main lan katotpol konan Dios, tan imbalita la a hitamoy antompol koni Jesus ay kailangan domalan ha lako a dawdya-dya ba-yo tamo miabot ha ampag-arian nan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ha balang gropon antompol ay namili hila ni Pablo tan hi Bernabe nin mi-pamoon. Dinomawat hila nin main awit pa-magsakripisyon kay mangan ba-yo la hilay na impa-taya konan Katawan a ampasimalaan la. ");
INSERT INTO xsb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bi-sa nagpa-wan hila ha probinsyan Pisidia anggan niabot hila ha probinsyan Panfilia. ");
INSERT INTO xsb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Impangaral lay namaot yay Halita nan Dios ha syodad Perge, bi-sa hila namagka ha babalin Atalia. ");
INSERT INTO xsb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ha Atalia ay nagpontin hila ta norong ana ha syodad Antioquia a hakop nin probinsyan Siria. Iti konan yadtin syodad hila pinaibwat nin hilay kaparan antompol ta indawat la a tambayan na hilan Dios ha main nan kaabigan konan ya-rin a gawa a hawanin kot nayari lay naor ana. ");
INSERT INTO xsb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pa-makalato la itaw ha Antioquia ay tinipon ni Pablo tan hi Bernabe yay gropo lan antompol koni Jesus ta tinotol lay halban ginwa nan Dios para konla tan no pa-no ya ot ginomwa paralan a pinangibatan main konlan ambo Israelita a tinompol anamaot. ");
INSERT INTO xsb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naboyot-boyot a pa-mi-wan ni Pablo tan hi Bernabe itaw ha syodad Antioquia nin kalamo hilay kaparan antompol koni Jesus. ");
INSERT INTO xsb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Main lawlalakin Israelita ibat ha probinsyan Judea a nakon syodad Antioquia ta nangaral anamaot konlan ambo Israelita a antompol koni Jesus. An-itoro la a kay hila kano ilipyas nin Dios no kay la honolon yay kapanogoan a inimbi koni Moises tongkol ha pa-makogit ta ya-rin kano a pamilbian tawo hilan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kinontra ladti ni Pablo tan hi Bernabe, kanya nagkamain ma-mot a pa-mididiskosyon. Bana ta anorin, na-pi-polyarian lan hilay antompol koni Jesus itaw ha Antioquia a hila ni Pablo tan hi Bernabe, pati laloma ot a antompol a taga itaw ay dapat mako ha Jerusalem ta ipaki-pa-no konlan aw-apostolis tan hilay laloman ampamoon ha gropo nin antompol itaw no anya kot a tama. ");
INSERT INTO xsb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kanya pinaibwat lay nan hilay gropon antompol koni Jesus hila ni Pablo. Ha pa-mako lan Jerusalem ay dinomalan hila ha loway probinsya a Fenicia tan Samaria, ta imbalita la konlan antompol ison a lako hilay ambo Israelita a tinompol anamaot konan Dios. Halban lan hila-rin antompol ison ay nalilikot konan ya-rin a balita. ");
INSERT INTO xsb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hin nakalato hilay na ni Pablo ha Jerusalem ay tinanggap hila nin gropon antompol koni Jesus itaw, kalamo hilay aw-apostolis tan hilay laloma ot a ampamoon ha gropo la. Tinotol li Pablo a halban ginwa nan Dios pananambay konla ha lawlogar a kina-kina la. ");
INSERT INTO xsb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kot main itaw nin omnoy antompol koni Jesus a kabilang ha gropo lan Pariseo a ampamipilit a hilay ambo Israelita a tinompol koni Jesus kot kailangan hila kanon kogiton tan ipahonol ot konla yay laloman kawkapanogoan a inimbi nan Dios koni Moises. ");
INSERT INTO xsb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kanya nititipon hilay aw-apostolis tan hilay kapara lan ampamoon ha gropon antompol itaw ta pinipapa-nowan ladti. ");
INSERT INTO xsb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pa-makayari nin naboyot lan pa-mitototol, inomdong hi Pedro ta wana konla, “Tawtalakaka, tanda moyo a hin yadtaw ot ay hikoy o-nan pinili nan Dios para mangaral nin Labah a Balita tongkol koni Jesus konlan ambo Israelita ta pigaw tompol hilay namaot. ");
INSERT INTO xsb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bi-sa hin ya-rin, yay Dios a magtanda nin kawkaisipan nin tawo ay pinaptogan nay naor a antanggapon na hilay namaot a ambo Israelita a tinompol kona ta impakiasa-sa nay Masanton Ispirito na konla a bilang anamaot ha ginwa na kontamo. ");
INSERT INTO xsb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kanya ha hilap nan Dios, hila tan hitamo ay pari-pariho, ta hila man a ambo Israelita ay nilinis hilay namaot ha main lan kasalanan bana ha main lan katotpol. ");
INSERT INTO xsb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Anongkot labay moyon hobokon no anggan ayti pasinsya nan Dios ta labay moyon ipahonol konla yay daan a kawkapanogoan? Kaalimbawaan nan ya-rin kot an-ipabalatay moyo konlay a-say mabyat a bagay a kay tamo nababa ni hilay kapapo-papoan tamo, ta pari-pariho tamon kay nakahonol. ");
INSERT INTO xsb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ampi-polon tamo a inlipyas tamo bana ha kaabigan ni Jesu-Criston Katawan. Hila may ambo Israelita ay anorin syimpri.” ");
INSERT INTO xsb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bi-sa namakatinok hilay nay halban tipon itaw ta nagpatoloy hilan nanglongo hin tinotol ni Bernabe tan hi Pablo yay tongkol ha impagawa nan Dios konla a mawmilagro a pamilbian kapangyarian na lo-gan lan nangaral konlan ambo Israelita. ");
INSERT INTO xsb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pa-makayari lan tinotol orin, hi Santiago namaot a nanalita, wana, “Tawtalakaka, long-on moyoy namaot a ibalita ko! ");
INSERT INTO xsb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Tinotol ni Simon Pedro nangon no pa-no hina-wayan nan Dios hilay ambo Israelita hin o-na, pigaw main anamaot konla a mag-in tawtawo na. ");
INSERT INTO xsb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yadtin nangyari ay ayon ha impasolat nan Dios konlan pawpropita na, ta anodti wana ha Masanton Kasolatan, ");
INSERT INTO xsb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pa-makayari nin yadti ay magbolta ko, wanan Katawan, ta ipa-dong kon oman yay nahira a kaarian ni David. Kailangan ipa-dong kon oman tan ayoson, ");
INSERT INTO xsb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","pigaw hilay laloma ot a tawtawo kot paka-tingkapon la ko, ta hilay ambo Israelita ay hina-wayan koy namaot para mag-in kon tawtawo. Ya-rin a wanan Katawan a ampanoor nin hila-rin halban bawbagay. ");
INSERT INTO xsb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tanda nay nan Dios a halban ga-gaw-on na paibat hin ibat.’*” ");
INSERT INTO xsb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Bi-sa wana ot ni Santiago, “Intonsis, yay disisyon ko ay ambo tamon dapat pairapon hilay ambo Israelita a antompol konan Dios. ");
INSERT INTO xsb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Anodtaw pa man, solatan tamo hila a pa-lilihan lay anyakaman a bagay a koniktado ha pa-magsamba ha dios-diosan, ando gomawa nin imoralidad, tan ando hila mangna nin daya o anyakaman mag-ayop a nabitkol a kay na-padaya. ");
INSERT INTO xsb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nga-min, paibat ana hin o-nan panaon, yay kawkapanogoan a inimbi koni Moises ay pirmin ambasawon ha sawsinagoga topo Awlon Pa-mainawa tan an-ipangaral ha balang lawlogar.” ");
INSERT INTO xsb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hilay aw-apostolis tan hilay kapara lan ampamoon konlan antompol, pati hilay halban myimbro nin gropon antompol itaw ay nanga-pisosondo a mamili hila nin lawlalaki ha gropo la para ipaki-ka konli Pablo tan hi Bernabe itaw ha syodad Antioquia. Yay pinili la ay hi Judas a anha-wayan Barsabas tan hi Silas a parihon ambilbion mata-gay nin hilay kaparan antompol. ");
INSERT INTO xsb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pina-witan hilan solat a anodti laman: “Hikamin aw-apostolis pati laloma ot a ma-moon tan kaparan antompol iti ay angkomostawon mi kamoy halban tawtalakaka ha katotpol a ambo min ka-Israelita a ison ha syodad Antioquia tan ha loway probinsya a Siria tan Cilicia. ");
INSERT INTO xsb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Na-tandaan mi a main konlan kalamoan mi iti a nako ison komoyo a naka-pagolon kaisipan moyo tan pinangibatan ampaglowa-lowa kamon isip. Nga-min, anhalitaon lan kailangan moyo kanon pakogit tan honolon yay kawkapanogoan a inimbi koni Moises, pigaw mag-in kamon tawtawo nan Dios, anta kay mi hila inhogo para itoro ladti komoyo. ");
INSERT INTO xsb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hawanin, nanga-pititipon kami halban tan na-pisosondoan a mamili kamin loway lalakin maihogo mi komoyo. An-ipaki-ka mi hila konli Bernabe tan hi Pablo a mangabli tamon kaparan antompol, ");
INSERT INTO xsb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","tan parihon kay nag-alangan namitaya biyay bana ha pangangaral la tongkol koni Jesu-Criston Katawan. ");
INSERT INTO xsb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hawanin, an-ihogo mi hila ni Judas tan hi Silas para ipalino la komoyo nin arap-arapan yay tongkol konan yadtin solat mi komoyo. ");
INSERT INTO xsb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nga-min, impanakom nin Masanton Ispirito nan Dios komi tan naisip-isip mi a ambo kailangan pabyatan kamo ot nin lawlaloma ot a kawkapanogoan, nokay main bongat omnoy bawbagay a talagan kailangan moyon iwasan: ");
INSERT INTO xsb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ando kamo mangan nin anyakaman a inda-ton ha dios-diosan, tan ando mangna nin daya o anyakaman mag-ayop a nabitkol a kay na-padaya. Ando anamaot gomwa nin imoralidad. Labah no iwasan moyodtin halban. Ya-rin tana.” ");
INSERT INTO xsb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bi-sa pinaibwat hilay nay inhogo ta nako ha syodad Antioquia. Bi-sa tinipon lay intiron gropo lan antompol koni Jesus itaw ta inimbi lay solat. ");
INSERT INTO xsb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pa-makabasa la ay nalilikot hila bana ta na-liswayan a nakom la konan ya-rin a solat. ");
INSERT INTO xsb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Bi-sa, hila ni Judas tan hi Silas a parihon mangangaral a propita nan Dios ay lako a imba-balita la konlan kaparan antompol a nakapami ot konla nin wawali tan naka-pa-got nin main lan katotpol. ");
INSERT INTO xsb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pa-makayari nin naboyot-boyot a panaon nin itaw hila, pinaibwat hilay na nin labah a nakom nin hilay kaparan antompol para morong itaw konlan aw-apostolis. ");
INSERT INTO xsb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kot nagpaka-bati hi Silas.* ");
INSERT INTO xsb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Hi Pablo tan hi Bernabe namaot ay nagpirmi hila ot ha syodad Antioquia. Lolog lan itaw ay nanoro tan nangaral hilan Halita nan Katawan nin lako ot a lawlaloman naipagkalamoan la. ");
INSERT INTO xsb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pa-makalabah nin omnoy awlo, wani Pablo koni Bernabe, “Magbolta ta, ta tibawon hilay kaparan antompol ha balang babali a piniabotan ta nin Halita nan Katawan, ta biliwon no anyay nay ampangyari konla.” ");
INSERT INTO xsb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Labay ni Bernabe a awiton lan oman ipagkalamo hi Juan a anha-wayan anamaot Marcos. ");
INSERT INTO xsb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kot para koni Pablo ay ambo yan dapat awiton, bana ta hin yadtaw ay kay ya nagpatoloy naki-ka konla ha main lan pangangaral, nokay imbati na hila ha probinsyan Panfilia. ");
INSERT INTO xsb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bana konan yadti ay nagkamain hilan grabin pa-mi-porpya hi Pablo tan hi Bernabe a pinangibatan nin nagkanya-kanya hilay nan kina. Inawit ni Bernabe hi Marcos, bi-sa nagpontin hilay nan nako ha polo Chipri. ");
INSERT INTO xsb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Kot hi Pablo, yay pinili nan impagkalamoan ay hi Silas. Ha pa-mibwat la ay indawat hila nin kaparan antompol a tambayan na hilan Dios ha main nan kaabigan. ");
INSERT INTO xsb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bi-sa nako hilay na ni Pablo ha probinsyan Siria tan Cilicia ta wina-wawaliwan la hilay gawgropon antompol koni Jesus pigaw komhaw a main lan katotpol. ");
INSERT INTO xsb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Yay homonol a kina li Pablo ay ha babalin Derbe bi-sa ha babalin Listra. Konan yadtin hoyot a babali ay main a-say antompol koni Jesus a yay ngalan kot Timoteo. Yay nanay na ay a-say Israelita tan antompol anamaot koni Jesus, balo ta yadtaw tatay na ay Griego. ");
INSERT INTO xsb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Halban lan kaparan antompol ha babalin Listra tan ha syodad Iconio ay anhalitaon lan hi Timoteo kot labah a tawo. ");
INSERT INTO xsb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Hawanin, labay ni Pablo a ipaki-ka hi Timoteo. Kanya kinogit na ya pamilbian a talagan a-sa yan potog a Israelita a tawo nan Dios. Nga-min, halban lan Israelita a ampi-wan ison ay tanda la a ambo yan kogit bana ta yadtaw tatay ni Timoteo kot Griego. ");
INSERT INTO xsb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hin nako hilay na ha bawbina-babali ay impatandaan lay disisyon lan aw-apostolis tan hilay laloma ot a ma-moon konlan antompol ha syodad Jerusalem tan binibilinan hilan honolon odti. ");
INSERT INTO xsb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kanya, balang gropon antompol ay lalon inomgot a main lan katotpol, tan awlo-awlo ay nama-lah anan nama-lah a bilang la. ");
INSERT INTO xsb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nako hila ni Pablo ha probinsyan Frigia tan Galacia, bana ta kay na hila inaboloyan nin Masanton Ispirito nan Dios nin mangaral ha probinsyan Asia. ");