﻿USE sofia;
DROP TABLE IF EXISTS sofia.xrb_vpl;
CREATE TABLE xrb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xrb_vpl WRITE;
INSERT INTO xrb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yãhã ke Yesu Crise yĩŋ yi nwoŋ gii laam wo, ke nwoŋ wãlɛ myar nde, te yrũhũ nwo. Tuhufar na, Yesu Crise pye Dawide kur kuɛ puee, Dawide -sẽ pye Brama kur kuɛ puee. ");
INSERT INTO xrb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pe wãlɛ myar nde: ");
INSERT INTO xrb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaha pye Farɛhɛ ye tuhufua, Saraha ne; Tamar pye pe nahafua; ");
INSERT INTO xrb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araŋ -sẽ pye Aminada tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samu pye Baasya tuhufua, Arabe pye u nahafua. ");
INSERT INTO xrb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisay -sẽ pye u yĩŋfua Dawide tuhufua. Dawide pye Salmuu tuhufua, u nahafua pye Yuri cɔɔ. ");
INSERT INTO xrb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salmuu -sẽ pye Worbua tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yasaha -sẽ pye Yosafaha tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yosyase -sẽ pye Syataŋ tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Secas -sẽ pye Manasyɛ tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Syosya pye Syekonya ye tuhufua u cĩĩfa ne; koo cãã kẽ pe bii Yiisrɛfa yigi ga fãnga na kãntraha gaa na, pe naa n yee Babilɔn. ");
INSERT INTO xrb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pe bii Yiisrɛfa yigi ga fãnga na koo Babilɔn kãntraha na, loo kur ye, Syekonya pye Salatel tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sohobal -sẽ pye Yabuhu tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yasɔɔ -sẽ pye Sadoke tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ledyuhu -sẽ pye Lesyari tuhufua, ");
INSERT INTO xrb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Dyakuba pye Yosɛfe tuhufua, Yosɛfe wii tuu pye Maari puai. U Maari woo kẽ tuu pye Yesu nahafua, Yesu wii u ma u Crise, ke yĩntaha kẽ, u Yãhã Yĩndefua. ");
INSERT INTO xrb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma gbe Brama na, ma ba nɔ Dawide na, wãlɛ sẽnsye resyar pye. Ma gbe Dawide na, ma ba nɔ cãã gii na pe bii Yiisrɛfa yigi ga fãnga na Babilɔn kãntraha na, wãlɛ sẽnsye resyar pye. Ma gbe Yiisrɛfa wãyigi cãã na, ma ba nɔ u Crise wãsee cãã na, wãlɛ sẽnsye resyar pye. ");
INSERT INTO xrb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Crise tuu see mii syi dyaŋ le nde: Pe ba yɛr u nahafua Maari wãwãã wĩĩ na cɔɔ naa waa kẽ, u myaha ba kẽ Yosɛfe. Yosɛfe sẽ ba u cã wa gɛ cã wa cɔɔ ye, Yãhã Yrã Fãnga n u Maari ta u n nii lai ne. ");
INSERT INTO xrb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","U Yosɛfe wii tuu -sẽ ga ba nii u puai, u pye naweeyɔ̃. U sẽ naa n traha u Maari lai wĩĩ gbe yi nanihi wo ye, u n yee woo ga koho kuã u na, waa gɛ ma n yi le cãŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","U pye too laangar na; per gaa tuu ba sã wãy, yãhãyĩŋ tẽnlɛhɛ waa n pa u ye mlũhũ wo, ma ba u pye ma yee: «Yosɛfe, yĩŋfua Dawide kur, maʼa n fya Maari wãsyaŋ na cɔɔ ye. Ma sẽ yãã, Yãhã Yrã Fãnga kẽ ke ta u n nii lai ne. ");
INSERT INTO xrb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U ga ba naa kicar see, ma ba u myaha taha Yesu, ke yĩntaha kẽ Syayahafua; ma sẽ yãã, u ga ba u nawee- sya yaha kapee- wãpyeŋ koho wo.» ");
INSERT INTO xrb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yãhã ke bii kai lii cãã pãã yaha ke kaplãŋ tɔ̃rfua waa yɛ̃ ne, loo kai ne le nii n pye loo yale wo. U bii yee: ");
INSERT INTO xrb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«U capua wii tuu sẽ naa cã wa ye, u ga nii lai ne, u ba naa kicar see. Pe ga ba u myaha taha Manuɛl.» Ke Manuɛl yĩntaha kẽ, Yãhã ma wo ne. ");
INSERT INTO xrb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosɛfe n ba yir pe wãy na. Lii u yãhãyĩŋ tẽnlɛhɛ ba yar u na, u n loo pye, ma Maari sya cɔɔ. ");
INSERT INTO xrb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","U sẽ -sẽ naa n sãy u ne ye, u n sya ba u naa kicar see. Yosɛfe n u myaha taha Yesu. ");
INSERT INTO xrb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ba see Yudɛ kãntraha klo laa wo pe n yee Betelɛmu. Koo cãã na, Yɛrɔte kẽ u pye ke Yudɛ kãntraha yahaseefua. Yesu tuu see wa, kaicãfa mpãy n yir kãntraha gaa na, yainsaha dar kuɛ ye, ma pa kungbãy nde wo pe n yee Yurusalɛm. ");
INSERT INTO xrb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pe n le yey nawee- ye ma yee: «Kicar wii tuu see u n pai nii Yiifee- yĩŋfua, u ma na? Ye sẽ yãã, wo u yrompua yãã, u yi yainde darkuɛ ye, wo n pa wo n pai u sey.» ");
INSERT INTO xrb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yahaseefua Yɛrɔte tuu nde luhu, u n fya, pe Yurusalɛmfa byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","U n pe Yãhã yũndefa yĩŋfa byɛ yee ba, ma suhu pe Yãhã kaiyarfa byɛ ne, ma ba pe yey ma yee: «U Yãhã Yĩndefua Crise ga see na?» ");
INSERT INTO xrb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pe n u yɛ̃ sya ma yee: «U ga ba see Yudɛ kãntraha klo lii wo pe n yee Betelɛmu. Yãhã kaplãŋ tɔ̃rfua waa bii le yrũhũ yaha ma yee, Yãhã yee: ");
INSERT INTO xrb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Ah yii Betelɛmufa, ye klo ma Yudɛ kãntraha wo; le sẽ kloŋ tãŋ Yudɛ kãntraha kui byɛ na ye. Ye sẽ yãã, yĩŋfua waa ga yi ye klo wo. U ga ba nii ta nawee- Yiisrɛfa yĩŋ na mii mbanaha wãŋ syi dyaŋ u mbaa ne.› » ");
INSERT INTO xrb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pe loo pãã wa, Yɛrɔte n pe kaicãfa yee ba, u sẽ ta waa n yi le cãŋ na ye. U n pe yey u yrompua yiyale ne. ");
INSERT INTO xrb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","U n pe lɛhɛ wãã Betelɛmu wo ma yee: «-Ye ka yaa u kicar fla kɛ yɔ̃; ye ma u yãã, -ye ra yar, ta bya n ka n ga u sey nii ndoŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pe u yahaseefua kaplãŋ luhu wa, pe n ke Betelɛmu kãnde sya. Kãnde wo, pe n u yrompua yãã, wii pe ba yãã wa yainsaha darkuɛ kãntraha wo. Pe n maha u yrompua yãã, tuu n fã pe yahasee ye yãhãyĩŋ na. U kicar tuu pye kaha gii wo, u yrompua tuu ga nɔ ke kaha yĩŋ ne, u n yɛr. ");
INSERT INTO xrb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pe kaicãfa pe u yrompua yãã ke syi, pe n nuhu di gboho. ");
INSERT INTO xrb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pe n dye ke kaha laam wo, ma u kicar yãã u nahafua Maari ne. Pe n kãnklũy gbãã, ma u kicar sey. Loo kur ye, pe n pe wãn sãhã, ma wãn taa yi wãã u kicar kẽ: Sãn, tesẽ wusuna ne, tesẽ lasekole waa ter ne pe n yee myer. ");
INSERT INTO xrb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Loo kur ye, Yãhã n ba pe yar mlũhũ wo ma yee, pe ma n dur ga Yɛrɔte fla na ye. Pe n kãnde laa ter gbe, ma dur tɛr pe kui wo. ");
INSERT INTO xrb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pe kaicãfa pe ba tɛr wa, yãhãyĩŋ tẽnlɛhɛ waa n ba pa u Yosɛfe ye mlũhũ wo, ma ba u pye ma yee: «Yir, u kicar gbe u nahafua ne, ma fã tɛr Syipte kãntraha wo! Kuee koo fla na, ta n sya ba ma yar ma dur ba! Ma sẽ yãã, Yɛrɔte ga ba naa u kicar kɛ, woo ga u boo.» ");
INSERT INTO xrb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Loo na, Yosɛfe n yir, ma u kicar gbe u nahafua ne, ma fã tɛr pe ne yĩmper wo Syipte kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","U n ga kuee ke fla na, Yɛrɔte n sya ba ku. Yãhã ke bii kai lii cãã pãã yaha, ke kaplãŋ tɔ̃rfua waa yɛ̃ na, loo ne le pye. U bii yee: «N ta Dya yee yi Syipte kãntraha wo.» ");
INSERT INTO xrb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yɛrɔte tuu -sẽ ba yi le cãŋ na ma yee pe kaicãfa sye, pe sẽ dur ba u yar u kicar wĩĩ ne ye, ncafũhũ n u yigi ma sya ga ta tɛr. U n yir ma yee, pe pe naam kicar byɛ boo tãŋ Betelɛmu wo, tesẽ le klo kãnkãy kui byɛ ne. Pe kaicãfa pe -sẽ ba u yar u kicar seeyale ne, u n ta, naam kicar pii mpãy pe sẽ ba tɛr dyɛ- syãŋ yaha ye, pe n poo boo. ");
INSERT INTO xrb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yãhã kaplãŋ tɔ̃rfua Yermii tuu bii lii cãã pãã yaha, loo ne le pye. U bii yee: ");
INSERT INTO xrb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Pe wram wĩĩ luhu Arma na, kubɛhɛ ne busãã. Arsyɛl kẽ tuu u pii mii wũn. U wãflaŋ wĩĩ sye, u pii tee mii pe wee nantãŋ ye.» ");
INSERT INTO xrb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yɛrɔte wãku kur ye, yãhãyĩŋ tẽnlɛhɛ waa n maha ba pa u Yosɛfe ye mlũhũ wo, ke Syipte kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","U n u pye ma yee: «Yir, ma u kicar gbe u nahafua ne, ma dur ga Yiisrɛ kãntraha na! Ma sẽ yãã, mpãy byɛ pe naa u kicar wãboo kɛ, pe ku wa.» ");
INSERT INTO xrb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Loo na, Yosɛfe n yir ma u kicar gbe u nahafua ne, ma dur ga ke Yiisrɛ kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","U n ga le luhu ma yee, Arkelusi ma u u tuhufua Yɛrɔte draha gbe, ma nii Yudɛ kãntraha kui yĩŋ na. Loo n u ta u n fya, u sẽ sya ma nii Yudɛ kãntraha klo laa wo ye. Yãhã n u yar mlũhũ gaa wo, u ga nii Galɛlɛ kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","U n ka, maa nii koo kãntraha klo laa wo pe n yee Nasarɛte. Pe Yãhã kaplãŋ tɔ̃rfa pe bii lii cãã pãã yaha u kicar wĩĩ na, loo ne le pye. Pe bii yee: «Pe ga ba naa u yee Nasarɛtefa naa.» ");
INSERT INTO xrb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Le yale n ba nɔ Nsãn wii u nawee- tãã naa n yi loho wo, u n yi Yudɛ drawaha fla wo, ma nii Yãhã kaplãŋ pãã nawee- ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«-Ye le sya ye cã ye kapee- sẽ yɔ̃ ye, -tee ke miy yaha! Ye sẽ yãã, Yãhã Yai nɔ gbe taha wa.» ");
INSERT INTO xrb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nsãn wĩĩ ne Yãhã kaplãŋ tɔ̃rfua Yisa tuu naa n pãã ma yee: «Naa waa yĩmbui ne le n yir drawaha fla wo ma yee: ‹-Ye Yĩŋfua Yãhã wãpaŋ kãnde gbihi yaha ke kẽ, -ye ke kãmbɛhɛ ta ke n sroŋ yɔ̃!› » ");
INSERT INTO xrb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nsãn nayroho fai pye yũhũmii sraha yor, pe ta ma ke tyĩn. U ba sapaha ta ma u ya pua naa n cɛr nsĩĩ wo. Jĩmblɛ te pye u digi, sɔ̃r ne. ");
INSERT INTO xrb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yurusalɛm klofa naa n pai u ye, Yudɛ kãntrahafa byɛ ne, ma suhu Yurdane lafeŋ kuɛfa byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kapee- nkãy pe naa n pye, pe naa ke tɔ̃r Yãhã ye nawee- byɛ yĩnde na. Nsãn n -sẽ pe tãã naa n yi Yurdane lafeŋ loho wo. ");
INSERT INTO xrb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yiifee- yahaseefa mpãy, Farisyɛ̃ ye, Sadusyɛ̃ ye ne, poo busãã naa n pai Nsãn fla na, u n ba pe tãã naa n yi loho wo. Nsãn n pe pye ma yee: «Nwoho terfa mii! Yoo ye yar ma yee, tee ga waha wloho yi kãã te Yãhã kasãhã laam wo, tii te n pai? ");
INSERT INTO xrb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","-Ye naa kayũhũ pye mii katyiyũhũ dyaŋ ke piiyɔ̃m sa! Loo na, le ga cã tee yi kãã kapee- wãpyeŋ kãnde wo, ma kayũhũ wãpyeŋ kãnde gbe. ");
INSERT INTO xrb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ye tee le ga ye laam wo, a ye ma wo faale wãdyaha Brama kur, loo nde wĩĩ na Yãhã ga ta ye n wlohoyisaha yãã. Ye sẽ yãã, Yãhã ga waha ntẽmbar nde ta te n wã klaha nii naweeyɔ̃m, pe n ye draha gbe, pe nii Brama kur. ");
INSERT INTO xrb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ta n ye yar: Mbaapuai gbihi cai ta nii wa, ma ga katyir cããr te nnen fla na. Katyigi gii ma yee ke sẽ sa yɔ̃ ye, ke ga ba cɛr le naa wo. ");
INSERT INTO xrb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ndoo, n ye tãã n yi loho wo, loo nde le yar ma yee, ye ye kapee- miy yaha, ma kayũhũ wãpyeŋ kãnde gbe. Waa ter -sẽ ma tuu n pai; u fãnga tɛr ra wãŋ yaha. Ta syi saa waha nii u tẽntẽle, n u ntãy gbe yigi u kẽ ye. Woo, u ga ba naa ye tãã Yãhã Yrã Fãnga ne, tesẽ naa ne. ");
INSERT INTO xrb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U ma mii nawee dyaŋ tuu ma sẽncrihi ne u koho wo. U ga sẽmuhu fua yi pua laam wo. Loo kur ye, u ga u pua le mploho wo, tuu naa le te sẽmuhu na, naa gii wãfegeyãã wee ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Loo kur ye, Yesu n yir Galɛlɛ kãntraha wo, ma pa Yurdane lafeŋ fla wo. U n pa Nsãn fla na, ma yee Nsãn n u tãã yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nsãn n yee, woo ga sye ma yee: «Ndoo kẽ tẽ yai n tãã mboo ye, ah mboo -sẽ maha n pai ndoo ye!» ");
INSERT INTO xrb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu n u yɛ̃ sya ma yee: «Tyii le n nii ke dyaŋ yagaa. Kai- nkãy byɛ ke sroŋ Yãhã ye, wo yai wo naa ke pye koo syi.» Loo na, Nsãn n le sya. ");
INSERT INTO xrb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu tuu tãã wa, u n yi loho wo. Le yalebya wo, yãhãyĩŋ n fe yãr, u n Yãhã Yrã Fãnga yãã, le tege u na mii kãnsyã waa ter dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yĩmbui laa n yir yãhãyĩŋ kuɛ ye ma yee: «Ta Dya kẽ ma ne, ma ntãŋ dye gboho ra tãy, ma ra laam yĩn yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Loo kur ye, Yãhã Yrã Fãnga n ta Yesu n ka drawaha fla wo, sãndãpee yĩŋfua Setane n ga u tyĩn ga yãŋ kapee- wãpyeŋ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu n ga plii gbeesĩĩ pye, ke yai ke yĩmper u sẽ ngaa di ye. Fãã n u yigi. ");
INSERT INTO xrb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","U sãndãpee yĩŋfua n pa u tãy, ma ba u pye ma yee: «Maʼa pye Yãhã Dya cĩĩnde, ntẽmbɛhɛ ngĩĩ wã klaha digi.» ");
INSERT INTO xrb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu n u yɛ̃ sya ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ laam wo ma yee: ‹Nawee saa waha poho digi ya ne ye, cã, Yãhã yɛ̃ kapãn loo ne le nawee poho.› » ");
INSERT INTO xrb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loo na, u sãndãpee yĩŋfua n ka u ne Yãhã kungbãy Yurusalɛm wo, maa u ta u n dugu nii Yãhã kangbãŋ yããsyi na. ");
INSERT INTO xrb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","U n dur, ma u pye ma yee: «Maʼa pye Yãhã Dya cĩĩnde, yir nwo, ma kur ye tege kãntraha na. Ma sẽ yãã, le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Yãhã ga ba ke yãhãyĩŋ tẽnlɛhɛ nɔ wãã, pe n ba naa n sẽŋ ma na. Pe ga ba ma yigi pe kluɛ ne, ma saa yãã mii kor ntẽmblaha na ye.› Loo ne ta n yee, ma kur ye tege kãntraha na.» ");
INSERT INTO xrb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu n maha u yɛ̃ sya ma yee: «Le maha yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Yãhã gii ke ma ma Yĩŋfua, maʼa syi ma ke tãn yãŋ ye.› » ");
INSERT INTO xrb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Loo na, u sãndãpee yĩŋfua n ka Yesu ne yãŋ gaa yĩŋ na, ke wãjruhu! Ke yãŋ yĩŋ na, u n kãntraha kui byɛ yar tãŋ Yesu na, tesẽ te nayɔ̃r ne, ");
INSERT INTO xrb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ma u pye ma yee: «N ga koo ngĩĩ byɛ wãã ma kẽ, maʼa sya ma kãnklũy gbãã ra yahasee ye, ma ra sey.» ");
INSERT INTO xrb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu n u pye ma yee: «Tɛr kãã ra yahasee ye, Setane! Yãŋ, le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Naa Yãhã ya gboho, koo ya ke ma ma Yĩŋfua, -taa mii le soho koo ya koho wo!› » ");
INSERT INTO xrb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yagaa woo, u sãndãpee yĩŋfua n tyii u na. Loo na, yãhãyĩŋ tẽnlɛhɛ mpãy n pa Yesu fla na, ma ba nii koho le u ye. ");
INSERT INTO xrb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu tuu luhu pe Nsãn le nwompihi wo, u n dur ga Galɛlɛ kuɛ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","U sẽ ga nii kuee Nasarɛte wo ye, ma ga nii Kapornu wo, klo laa ne le ma Galɛlɛ langbãŋ yɛ̃ na, Sabuloho kãntraha kuɛ ye, Nataale kãntraha kuɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yãhã ke bii kai lii cãã pãã yaha too kãntrɛ nde wĩĩ na, ke faale kaplãŋ tɔ̃rfua Yisa yɛ̃ na, loo ne le pye Yesu wãpaŋ ne. U Yisa bii yee: ");
INSERT INTO xrb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Sabuloho kãntraha, Nataale kãntraha, langbãŋ kuɛ kãntraha, Yurdane lafeŋ kuɛ kãntraha, ma suhu Galɛlɛ gii ne, pe klofa fãnga sẽ cĩĩnde Yãhã cã ye, ");
INSERT INTO xrb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","too kãntrɛ ndefa pe nii wam wo Yãhã kuɛ ye, pe ga ba cãã- yãã, cããngbãŋ! Tesẽ mpãy pe gbã fya, cãã- ga ba yi pe ye.» ");
INSERT INTO xrb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesu n ta tɛr yir le Yãhã kapãyĩĩ wãpãã ne. U naa le pãã nawee- ye ma yee: «Yãhã Yai nɔ gbe taha wa. -Ye le sya ye cã ye kapee- sẽ yɔ̃ ye, -tee ke miy yaha!» ");
INSERT INTO xrb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu tuu naa n yãr Galɛlɛ langbãŋ yɛ̃ na, u n fuayigifa syãm mpãy yãã. Syimu wii pe naa n yee Pyar, woo ba kẽ, u cĩĩfua Andere ne. Pe pye pe naa jɔɔ miy ke langbãŋ wo, ma naa fua- yigi. ");
INSERT INTO xrb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu n pe pye ma yee: «-Ye naa n taha ra na ye kuãŋ ne! Tee naa fua- le jɔɔ wo mii, yagaa, nawee- me tee ga naa n le kãnfuɛ̃ wo ke syi.» ");
INSERT INTO xrb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Le yalebya wo, pe n pe jɔɔ- ta yaha, ma taha u na pe kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","U n ka yahasee ye, maa nawee- syãm mpãy yãã. Sewede pii ba me, Syake tesẽ u cĩĩfua Nsãn ne. Pe pye pe tuhufua Sewede ne pe salangbãŋ wo, ma naa pe jɔɔ- gbihi. Yesu n pe yee. ");
INSERT INTO xrb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Le yalebya wo, pe n ke salangbãŋ ta yaha, pe tuhufua ne, ma taha Yesu na pe kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu naa n yãr Galɛlɛ kãntraha byɛ na. U naa nawee- klaha Yiifee- yawãhã nwey wo, ma naa le Yãhã kapãyĩĩ wĩĩ yar pe na, Yãhã kapãyĩĩ lii le Yãhã Yai wĩĩ pãã. Pe laam wo, mpãy pe pye yan ne, u naa pe byɛ jaa. ");
INSERT INTO xrb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","U myaha n sya ba yi Syire kãntraha kui byɛ wo, pe n -sẽ pa u fla na yanfa ter byɛ ne, ma suhu mpãy byɛ ne pe kadye teelaa fla klaha- pe ye. Mpãy pye, sãndãpee pye pe yĩŋ na, wãtookufa pye, mpãy ne pe naa fɛn sya yan koho wo. Yesu n pe byɛ jaa. ");
INSERT INTO xrb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nabuar n nii n taha u na; pe ba yi Galɛlɛ wo, ma suhu te kui sẽnsye kãntraha ne, Yurusalɛm ne, Yudɛ kãntraha ne, ma suhu Yurdane lafeŋ kuɛ ngaa kuɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu tuu pe nabuar yãã, u n dugu nii yãŋ gaa yĩŋ na. U kãnyãrwai n yũhũ crã u na. ");
INSERT INTO xrb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesu n gbe, ma nii pe nawee- klaha kaplãŋ ngĩĩ ne ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mpãy pe cã pe wee ngaa gɛ Yãhã ye ye, ma nii ke kɛ, poo wĩĩ n tãy Yãhã ye. Yãhã Yai ma poo wãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mpãy pe cã pe pyer sẽ yɔ̃ ye, le n nii pe fãy, poo wĩĩ n tãy Yãhã ye. Yãhã ga ba koho le pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mpãy pe ma prafa, poo wĩĩ n tãy Yãhã ye. Pe ga ba kãntraha gaa ter yãã. ");
INSERT INTO xrb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mpãy pe wãsroŋ kɛ mii fããfa dyaŋ pe digi kɛ, loho ne, poo wĩĩ n tãy Yãhã ye. Yãhã ga ba loo nde wãã pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mpãy pe pe nampyeŋ- fɛn di, poo wĩĩ n tãy Yãhã ye. Yãhã ga ba pe bya fɛn di. ");
INSERT INTO xrb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mpãy pe laam ma gbɛgbɛ, poo wĩĩ n tãy Yãhã ye. Pe ga ba Yãhã yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mpãy pe n pai yrĩŋ yĩmbui ne, poo wĩĩ n tãy Yãhã ye. Yãhã ga ba naa poo yee ke pii. ");
INSERT INTO xrb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pe kapee- pye mpãy na pe sroŋ, ma yee pe tee pe troho tãhã Yãhã yor wo, poo wĩĩ n tãy Yãhã ye. Yãhã Yai ma poo wãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nawee- ma yee ye tee n taha ra na, ma nii ye tyɛhɛ, ma nii kapee- pye ye na, ma nii kawar fua n taha ye na, ma wãpee pãã ye wĩĩ na, ye wĩĩ n tãy Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","-Ye naa nuhu di loo wĩĩ na, ye cã ye wĩĩ n tãy Yãhã ye. Yãhã ga ba ye dããn wãã ye kẽ yãhãyĩŋ na. Pe bii naa kapee- pye faale Yãhã kaplãŋ tɔ̃rfa na koo syi.» ");
INSERT INTO xrb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu n maha yee: «Yii me tee ma mii tetege wãŋ syi dyaŋ driyɛ̃fa laam wo. Tetege ma sar, pe ga waha pye mii, pe ke ta ke n maha dur naa n tãy? Ke saha laa yɔ̃ nantãŋ ye. Pe ga ke kaha woo nkur ye, nawee- n tãhã naa n tɛr ke na. ");
INSERT INTO xrb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yii maha me tee ma mii cãã- dyaŋ driyɛ̃fa laam wo. Ye ma klo lii dyaŋ le fãã nii yãŋ yĩŋ na, wũhũsaha wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Waa sẽ naaloho ndyan tar ma kataŋ cĩn n tã le na ye. Ah ndee pe ma le tar, pe ne le wra ta kããnkui na, mpãy byɛ pe ma nwoŋ wo, pe n cãã- yãã. ");
INSERT INTO xrb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ye cãã- yai pe naa n yɛhɛ koo syi dyaŋ nawee- laam wo, pe n naa ye kayũhũ yãã, pe naa ye Tuhufua Yãhã sey ke kayũhũ wĩĩ na.» ");
INSERT INTO xrb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu n maha pe yar ma yee: «Yãhã kãnde kataŋ nkãy ke yar yaha, tesẽ pe faale Yãhã kaplãŋ tɔ̃rfa pe bii kai- nkãy yar yaha, n sẽ pa ma yee ye koo miy yaha ye. N pa n n pai ke gbihi yar ye na, tesẽ kai- nkãy byɛ pe cãã yrũhũ yaha ra wĩĩ na, n koo byɛ pye. ");
INSERT INTO xrb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta n cĩĩnde nde pãã ye ye, Yãhã ke ke kãnde kataŋ nkãy ta ke ga nii ke wãnii na, kãntraha tesẽ yãhãyĩŋ ne, too nde n sya ba kua. Ke kãnde kataŋ kaplãŋ teelaale gɛ saa miy yaha ye, ke yrũhũsaha teelaale gɛ saa yi kãã ye. Ke ga kuee kai- byɛ kuayale n sya ba nɔ. ");
INSERT INTO xrb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wii ma le Yãhã kãnde katan nen laa ya yi kãã, lii le kloŋ tãŋ ke byɛ na, ma maha ga nii loo klaha nawee- ye, ufua ga ba kloŋ tãŋ nawee- byɛ nsoho wo Yãhã yai klo wo. Wii woo tuu -sẽ Yãhã kãnde kataŋ gbihi yigi, ma ke yãr, ma nawee- klaha ke wãyãr ne, woofua ga ba yĩŋ yãã Yãhã yai klo wo. ");
INSERT INTO xrb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta n ye yar, ye ma yee ye sẽ n luhu Yãhã kapãn ye ma ta tɛr Farisyɛ̃ ye yaha, tesẽ Yãhã kaiyarfa ne ye, ye saa ba yãã dye Yãhã yai klo wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ye faale wãlɛ naa Yãhã kãnde kataŋ nkãy yãr, ye ke cã. Koo wĩĩ nen laa nde: ‹Maʼa syi ma nawee boo ye!› Mboo wii ma nawee boo, pe ga ma yigi ga, pe ga ma sãhã kasãhãfua fla na. ");
INSERT INTO xrb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ndoo -sẽ ga ye yar: Wii ma u laam war u nampyeŋ ne, Yãhã ye u yai u yigi ga kasãhãfua fla na. Wii ma u nampyeŋ tyɛhɛ ma yee naplege, Yãhã ye u yai u yigi ga kasãhã yĩŋfa fla na. Wii ma u nampyeŋ tyɛhɛ ma yee nafãã, Yãhã ye u yai naa fla ne, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Loo ne, maa ka diŋ yisaha wo Yãhã kẽ, ma laam ma ga too ma n cã ma laa tee pye ma nampyeŋ na, ");
INSERT INTO xrb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma diŋ ta yaha ke fla na, -taa ka maa wãã le ma nampyeŋ ne! Loo na, ma cã dur ba ma diŋ yi Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wii ma yee ma laa tee pye, ma ma yigi n gaha kasãhã saha wo, tee sẽ nɔ wa ke fla na ye, cãã naa u nar ye n wãã le. Mii loo sẽ ne ye, u n gaha ma le soho u kasãhãfua koho wo, woo n ma le soho fãngafa koho wo, pe n ma le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta n cĩĩnde nde pãã ma ye: Maʼa yee ma sẽ le kafuɛ byɛ dãã tãŋ ye, ma saa yãã yi ke nwompihi wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ke kãnde kataŋ nkãy tee cã, loo wĩĩ nen laa maha nde: ‹Maʼa syi ma cayɔr le ye!› ");
INSERT INTO xrb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ndoo -sẽ ga ye yar: Wii ma nii waa cɔɔ yãŋ, ma nii u wãkɛ wĩĩ ga u laam wo, Yãhã ye ufua laam wo u cayɔr pye wa. ");
INSERT INTO xrb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ke syi ne, maʼa yãã ma yĩnde lii le yɔ̃, le ma kɛ wãleŋ ne kapee- wãpyeŋ wo, le loho yi, ma le miy wãã deydey! Ma kadye teele nen laa ya ma yee le wee ye, koo puar ma kadye kur byɛ n ba miy le wãã naa laam wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ke ma pye ma kãndigi koho gɛ ke ma kɛ wãleŋ ne kapee- wãpyeŋ wo, ke cɛr kãã, ma ke miy wãã deydey! Ma ma koho neŋ ya yãã ke wee ye, koo puar ma ba ka ma kadye kur byɛ ne naa fla wo. ");
INSERT INTO xrb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ye faale wãlɛ kãnde laa maha nde: ‹Wii ma u ya koho cɔɔ sye, ufua yai u u cɔɔ wãsyeŋ saba wãã u kẽ!› ");
INSERT INTO xrb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ndoo -sẽ ga ye yar: Ma ya koho cɔɔ ma yee u sẽ naa waa di ye, maʼa u sye, u n ga naa waa gbe, ma u le kapee wãpyeŋ wo. Tesẽ, cɔɔ wii u puai u sye, mboo wii ma u gbe, ma bya kapee pye, ma cayɔr pye. ");
INSERT INTO xrb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ye faale wãlɛ kãnde laa maha nde: ‹Taa Yãhã di lii ne, ma sẽ yai ma ma yɛ̃ dur ye, ma yai ma le pye!› ");
INSERT INTO xrb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ndoo -sẽ ga ye yar: Ye ma syi ye naa Yãhã di kueekuee gɛ ye! Ye ma syi ye yãhãyĩŋ myaha yee ye, Yãhã niisaha kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ye ma syi ye kãntraha myaha yee ye, Yãhã trɛ tasaha kẽ! Ye ma syi ye Yurusalɛm myaha yee ye, Yãhã gii ke ma Yĩŋfuangbãŋ koo kungbãy kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ye ma syi ye naa ye yĩŋ yee ye, ye tee mii ye saha ye yĩnyoho neŋ gɛ ta ke n flege ye; ye saha maha waha ke ta ke n wɔ ye. ");
INSERT INTO xrb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lii ma pye cĩĩnde, -ye yee ‹ãwã›, lii ma yee le wee cĩĩnde ye, -ye yee ‹aye›! Kapãn laa ma taha loo na, sãndãpee yĩŋfua wĩĩ ne loo ne. ");
INSERT INTO xrb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ye faale wãlɛ kãnde laa maha nde: ‹Maʼa ra tee pye yĩnde na, ta bya, n ga ma tee pye yĩnde na. Maʼa ra tee pye nkãi na, ta bya, n ga ma tee pye nkãi na.› ");
INSERT INTO xrb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ndoo -sẽ ga ye yar: Wii ma ye tee pye laa ne, ye ma syi ye le kafuɛ yi ye! Wii ma ma fey kãndigi kuɛ ndicĩĩ syi na, tyii u na u n maha ma fey taha kãmaŋ kuɛ ndicĩĩ na! ");
INSERT INTO xrb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Wii ma yee u ga ma sãhã, u ma nayroho sya ma ye, tyii u na u n ma nayrengbãŋ bya gbe. ");
INSERT INTO xrb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wii ma yee ma ka teelaa wo fãnga na, ma koo syi yrãhã flɛ sĩĩ yãr ufua kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wii ma ma nar ngaa ne, u kẽ! Wii ma yee u ga fuɛ cɛr ma ye, maʼa n sye ye! ");
INSERT INTO xrb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ye faale wãlɛ kãnde laa maha nde: ‹Tyii ma nampyeŋ ntãŋ n dye ma tãy, ma napĩĩ wĩĩ n fũhũ ma ye!› ");
INSERT INTO xrb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ndoo -sẽ ga ye yar: Ye tyii ye napĩĩ- ntãŋ n dye ye tãy; mpãy pe kapee- pye ye na, -ye naa Yãhã nar pe kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Loo na, nawee- ga cã pe yee, ye ma ye Tuhufua Yãhã pii. Ye sẽ yãã, ke ke yai ta ke n yi napee- na, tesẽ naweeyɔ̃m bya ne wãcɛŋ. Mpãy pe sroŋ, tesẽ mpãy bya ne pe sẽ sroŋ ye, ke ke sesaha ta ke n too pe byɛ na wãcɛŋ. ");
INSERT INTO xrb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ye ma yee ye tããfa ya wĩĩ n tãy ye ye, ye yee la Yãhã ga ba dããn wãã ye kẽ loo nde wĩĩ na? Kufar wããfa gɛ pe sya ma fufor difa, pe bya n pye ke dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ye ma yee ye ga naa ye nampyeŋ- poo ya syar, ye yee la ye kayĩĩ pye gboho n tɛr loo ne? Mpãy gɛ pe sẽ cĩĩnde Yãhã cã ye, pe bya loo pye. ");
INSERT INTO xrb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ye tyii ye laam n nii tãŋ gbɛgbɛ, ye pyer n maha yɔ̃ tãŋ ye Tuhufua Yãhã wãŋ syi dyaŋ!» ");
INSERT INTO xrb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu n maha yee: «-Ye yãŋ, kai- nkãy byɛ tee n pye Yãhã myaha ne, ye ma syi ye naa ke pye nanihi wo, nawee- byɛ n ye yãã yĩnde ne ye! Ye ma nii ke pye n yar nawee- na ke syi, ye Tuhufua Yãhã saa ba ye dããn wãã ye kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Loo na, maʼa ga kla wãã nawãm kẽ, maʼa syi ma ta, nawee- byɛ n le cã ye! Dawarfa poo me pe loo pye Yiifee- yawãhã nwey wo, tesẽ nkur ye kãmbɛhɛ yɛ̃ na. Pe n pye ke syi, nawee- byɛ n pe yãã, pe naa pe sey. Ta n cĩĩnde nde pãã ye ye, pe pe dããn yãã wa ke syi. ");
INSERT INTO xrb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mboo, maʼa ga kla wãã nawãm kẽ ma kãndigi koho ne, maʼa syi ma ta ma kãmaŋ koho gɛ n le cã ye! ");
INSERT INTO xrb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Le n nii, waa gɛ ma n yi yãã le cãŋ na ye. Taa kayĩĩ lii pye, waa sẽ le cã ye, ma Tuhufua Yãhã koo le cã; ke ga ba ma dããn wãã ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesu n maha yee: «Ye ma n pãã Yãhã ne, ye ma n naa n pye dawarfa wãŋ syi dyaŋ ye! Pe ga yir yɛr Yiifee- yawãhã nwey wo, tesẽ nkur ye kãmbɛhɛ yɛ̃ na, pe naa Yãhã nar nawee- byɛ n pe yãã yĩnde ne. Ta n cĩĩnde nde pãã ye ye, pe pe dããn yãã wa ke syi. ");
INSERT INTO xrb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mboo, maʼa ga pãã Yãhã ne, dye ma nwoŋ laam wo, ma ke gbãã tã, ma pãã ma Tuhufua Yãhã ne. U ma ke fla na. Taa lii pye, waa sẽ le cã ye, ma Tuhufua Yãhã koo le cã; ke ga ba ma dããn wãã ma kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ye ma nii n pãã Yãhã ye, ye ma syi ye le ta kaplãmbuar mii mpãy dyaŋ pe sẽ cĩĩnde Yãhã cã ye. Pe laam wo, pe le ga poo ma nii kaplãmbuar pãã, Yãhã ga ba pe kaplãŋ sya pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ye ma n naa n yãŋ pe na ye! Ye sẽ yãã, ngii wĩĩ ma pye ye na, Yãhã gii ke ma ye Tuhufua ke le cãã cã wa, ye ma sya yee ye sẽ ke nar wa le ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ye yai ye naa n pãã Yãhã ne mii, le nde: ‹Wo Tuhufua Yãhã mboo wii taa ma yãhãyĩŋ na, ");
INSERT INTO xrb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ta, nawee- n cã ma miingbãŋ kai- laha. Ta, ma Yai n pa nawee- ye. Ta, ma laam wũhũ n naa n pye kãntraha na, mii ke n pye yãhãyĩŋ na mii syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wo yɛ̃ digi wãã wo kẽ nanga, peplii wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wo kapee- gbe kãã wo yĩŋ na. Mpãy pe kapee- pye wo na, wo bya wo n tyii pe kapee- foho na wo kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Maʼa n wo miy yaha, wo n tyĩn naa n gaha kapee- wãpyeŋ kuɛ ye ye. -Taa wo yi naa n kãã sãndãpee yĩŋfua koho wo. Mboo ya kẽ taa ma tãŋ yĩnfar ne, fãnga ne, miingbãŋ ne, too rii wãkuayãã wee te na ye. Amɛn, le nii ke syi!› » ");
INSERT INTO xrb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yesu n maha pe yar taha ma yee: «Ye sẽ yãã, mpãy pe kapee- pye ye na, ye ma nii n tyii pe kapee- foho na ye kuãŋ ne, ye Tuhufua Yãhã bya ga ba ye kapee- gbe kãã ye yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mpãy pe kapee- pye ye na, ye ma -sẽ yee ye sẽ n tyii pe kapee- foho na ye kuãŋ ne ye, ye Tuhufua Yãhã bya saa ba ye kapee- gbe kãã ye yĩŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu n maha yee: «Ye ma ye yɛ̃ tã digi na, ye ma syi ye yĩntaha tãhã mii dawarfa wãŋ syi dyaŋ ye! Poo ne pe yĩntar ta kaa syi, nawee- byɛ n waha le yãŋ cã, pe yee poo pe yɛ̃ tã digi na. Ta n cĩĩnde nde pãã ye ye, pe pe dããn yãã wa ke syi. ");
INSERT INTO xrb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mboo, maʼa ma yɛ̃ tã digi na, ma yĩntaha yee gbɛgbɛ, -taa ma yĩŋ yir, ");
INSERT INTO xrb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nawee- ma n waha cã pe yee ma ma yɛ̃ tã digi na ye. Taa ma mii ya teelii wo, ma Tuhufua Yãhã woo le cã ma ne. Taa lii pye waa sẽ le cã ye, ma Tuhufua Yãhã woo le cã; u ga ba ma dããn wãã ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu n maha yee: «Ye ma syi ye nangbãn wãn kɛ naa n ta driyɛ̃ nge wo ye! Driyɛ̃ wo, fyãr ma tesẽ korfyãhã ne, too nde wãn pye n klaha-. Yuhu- maha ma, pe kããnklee gbã n ka ma wãn yuhu. ");
INSERT INTO xrb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","-Ye Yãhã wũhũ kɛ naa n ta busãã yãhãyĩŋ na! Too nde, fyãr tesẽ korfyãhã ne, te saha te pye klaha- ye. Yuhu- bya saha te yuhu ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Taa ma laam wãn ta na, ma laam byɛ ma koo fla na. ");
INSERT INTO xrb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yĩnde ma mii naaloho dyaŋ kadye na. Ma yĩnde ma yɔ̃ ma ye, ma kadye byɛ ga nii cãã- na. ");
INSERT INTO xrb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma yĩnde ma klaha- ma ye, ma kadye byɛ ga nii wam wo. Cãã- mpãy pe -sẽ ma ma laam wo, poo ma -sẽ nii wam fla, ma cã ma yee wam mpãy pe ma ma laam wo, pe wɔ gboho tɛr.» ");
INSERT INTO xrb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesu n maha pe yar taha ma yee: «Waa saha yĩŋfa syãm wũhũ wãã le pye ye. Waa wĩĩ ga tãy u ye, le tɛr waa wĩĩ yaha. U ga sroŋ waa ye, tuu waa wĩĩ sye. Le ma ke syi, ye saha nii Yãhã tẽntẽ-, tee maha nii wale tẽntẽ- ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Loo ne, n ga ye yar nde ne: Dir rii tee ga naa n di, tesẽ loho gii ne tee ga naa n wɔ ye waha nii yĩnwɛr na, tesẽ nayrɛ rii ne tee ga le tã ye kadye na, ye ma syi ye naa ntãŋ cɛr too nde byɛ wĩĩ na ye! Ye sẽ yãã, yĩnwɛr puar dir na, kadye puar nayrɛ na. ");
INSERT INTO xrb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kãnsyãm mpãy pe n yir ncaha ye, ye sẽ pe yãã la? Pe sẽ digi tãhã, pe sẽ dir gbe, teelaa wee pe ye pe dir kɔ̃ŋ n yaha ye. Ye Tuhufua Yãhã sẽ pe yɛ̃ digi wãã la pe kẽ? Ye wĩĩ n tãy Yãhã ye ma tɛr kãnsyãm yaha. ");
INSERT INTO xrb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ye laam wo, yoo ma u ga waha u kuper yũhũ wãã carle gɛ laangar ya kãmay na? ");
INSERT INTO xrb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","-Ye tee maha laam ga nayrɛ wĩĩ na! Nyɛ̃ fyãr te n fĩy tar wo, ye sẽ te nayɔ̃r yãã la? Te sẽ tẽn tẽ ye, te sẽ faha wãn tyĩn ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta n -sẽ le pãã ye ye, faale yĩŋfua wii pe naa n yee Salmuu, u nangbãn naa byɛ ne, u nayrɛ nayɔ̃r sẽ -sẽ bii nɔ nyɛ̃ fyãr wãŋ neŋ gaa gɛ nayɔ̃r na ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyɛ̃ nge gɛ ke n fĩy tar wo nanga, koo gii pe n pai miy le wãã naa laam wo sukũhũ, Yãhã nayɔ̃r wãã ke kẽ. Ke -sẽ ga pye mii ke tyii yii gɛ na, ke saa nayrɛ wãã ye kẽ ye? Ye sẽ koho taha yaha Yãhã na busãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ye ma syi ye naa laam ga ye yee: Wo n pai nwa di? Wo n pai nwa wɔ? Wo n pai nwa le wo kadye na? ");
INSERT INTO xrb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mpãy pe sẽ cĩĩnde Yãhã cã ye, poo pe too nde byɛ kɛ fãnga ne. Ma -sẽ yee yii na, Tuhufua Yãhã ma ye ye, ke cã te wĩĩ ma ye na. ");
INSERT INTO xrb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","-Ye cãã Yãhã Yai wĩĩ kɛ wa, -tee Yãhã ta ye Yĩŋfua, -ye naa ye troho tãhã ke yor wo! Loo na, ngii wĩĩ ke ma ye na, ke -sẽ ga ba ke wãã taha ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ye ma syi ye naa laam ga sukũhũ wĩĩ na ye! Sukũhũ laangar wĩĩ ga ba pye le ya ya. Nanga fɛn yai ye ne ke dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu n maha pe yar ma yee: «Ye ma n naa ye nampyeŋ- kaa ye, Yãhã bya sẽ -sẽ ga ba ye sãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ye sẽ yãã, mboo nawee, taa ma nampyeŋ sãhã mii syi dyaŋ, Yãhã ga ba ma bya sãhã koo syi. Lii taa n pãã ma nampyeŋ pyer wĩĩ na, Yãhã ga ba naa loo pãã ma bya pyer wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Loo ne, n ga ye yar: Kãnkããle lii le ma ma nampyeŋ yĩnde wo, nwa ta ma n nii le yãŋ? Tẽngbãŋ gii ke -sẽ ma ma yĩnde wo, ma sẽ koo yãã la? ");
INSERT INTO xrb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mboo wii taa sẽ waha ke tẽngbãŋ yãã ma yĩnde wo ye, ma ga waha ma nampyeŋ pye la u yɛr, ma n le kãnkããle yi kãã u yĩnde wo u kẽ? ");
INSERT INTO xrb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dawarfua kẽ ma ne, cãã ke tẽngbãŋ yi kãã wa ma yĩnde wo, loo na maa waha gbihi yãŋ, ma le kãnkããle yi kãã ma nampyeŋ yĩnde wo. ");
INSERT INTO xrb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ye ma syi ye naa Yãhã wũhũ pãã napee- mpãy ye pe ma pãm wãŋ syi dyaŋ ye! Mii loo sẽ ne ye, pe ga waha wã klaha pe kapee pye ye na. Ye ma syi ye naa Yãhã wũhũ yar nawee- mpãy na pe ma tyɛ- wãŋ syi dyaŋ, pe wũhũ sẽ laha ye. Mii loo sẽ ne ye, pe ga ke Yãhã wũhũ wluhu pye klaha-.» ");
INSERT INTO xrb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu n maha yee: «-Ye naa n nar, ngaa ga wãã ye kẽ. -Ye naa n kɛ, yaa ngaa yãã. -Ye naa kããnklihi gbã, pe ga ke yãr ye kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ye sẽ yãã, mboo nawee, maʼa n nar, Yãhã ga ngaa wãã ma kẽ. Maʼa n kɛ, Yãhã ga ta ma n ngaa yãã. Maʼa kããnklihi gbã, Yãhã ga ta ke n yãr ma kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ye laam wo, waa ma la u dya ma ngaa digi nar u ye, u ga u kẽ ntĩn ne? ");
INSERT INTO xrb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Laa, u ma fua nar u ye, u ga u kẽ nwoho ne? ");
INSERT INTO xrb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tee sya pee mii, ye kayũhũ pye ye pii kẽ. Ke syi ne, ye yai ye cã, ye Tuhufua Yãhã kayũhũ wãã mpãy kẽ pe ke nar u ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kãnde lii Yãhã le ta, wo faale wãdyaha Musa ke kataŋ yrũhũ le yaha ke Yãhã sabangbãŋ wo. Tesẽ, pe faale Yãhã kaplãŋ tɔ̃rfa maha kaplãŋ nkãy yrũhũ le yaha ke wo. Koo kaplãŋ ngĩĩ byɛ yĩŋ nge tẽ ga pãã ye ye nde kapãngbɛrle: ‹Lii tee n kɛ ye nampyeŋ- pe naa le pye ye kẽ, yii gɛ -ye naa loo pye pe kẽ!› » ");
INSERT INTO xrb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesu n maha kakuãcraŋ ngĩĩ pãã pe ye ma yee: «Nwonyɛ̃ gii ke fĩhĩ, -ye dye koo ne! Nwonyɛ̃ gii ke cay, tesẽ kãnde lii ne le cay, too nde n gaha nawee ne u plahasaha wo. Too -sẽ kẽ nawee- busãã pe n sya. ");
INSERT INTO xrb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nwonyɛ̃ gii ke -sẽ fĩhĩ, tesẽ kãnde lii ne le fĩhĩ, too nde n gaha nawee ne u yrã yããsaha wo. Mpãy pe -sẽ too yãã, pe sẽ nihi ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","-Ye yii yigi kawar Yãhã kaplãŋ tɔ̃rfa ne! Pe ma pa ye ye, yaa yee pe ma mbapĩy wãŋ syi dyaŋ, pe sẽ pee ye. Pe laam -sẽ wo, waygapyãhã gɛ sẽ pee ma tɛr pe yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yaa ba pe yãŋ naa n cã pe pyer na. Waa sẽ defĩĩ katyipir tai yãã ngur katyigi na ye. Waa sẽ maha nkugu tai yãã ncũwãã na ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Katyiyũhũ puayɔ̃ sa, katyipihi -sẽ puapihi sa. ");
INSERT INTO xrb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Katyiyũhũ saha puapihi sa ye, tesẽ katyipihi saha puayɔ̃ sa ye. ");
INSERT INTO xrb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Katyigi gii ma yee ke sẽ puayɔ̃ sa ye, ke ga ba cɛr kãã, ke miy le wãã naa laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ye ga ba kawar Yãhã kaplãŋ tɔ̃rfa yãŋ naa n cã pe pyer na koo syi.» ");
INSERT INTO xrb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesu n maha yee: «Mpãy byɛ pe ra yee: ‹Yĩŋfua, Yĩŋfua,› poo byɛ sẽ me pe ga ba dye Yãhã yai klo wo ye. Mpãy pe ta Tuhufua Yãhã laam wũhũ pye, poo ya me pe n pai dye Yãhã yai klo wo. ");
INSERT INTO xrb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yãhã kasãhã per maa nɔ, nawee- busãã ga ba ra pye: ‹Yĩŋfua, Yĩŋfua, wo ba naa Yãhã kaplãŋ tɔ̃r nawee- ye ma myaha ne. Wo ba sãndãpee kar tege naa n kãã nawee- yĩŋ na ma myaha ne. Wo ba naa yɛ̃kã wũhũ busãã pye ma myaha ne.› ");
INSERT INTO xrb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Loo na, n -sẽ ga ba pe yar, n yee: ‹N sẽ ye cã ye, kapeepyefa mii, ye ma n crã ra na ye!› » ");
INSERT INTO xrb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesu n maha kakuãcran nde pãã pe ye ma yee: «Ye sẽ yãã, kaplãŋ nkãy tẽ pãã tɛr ye ye ngĩĩ, wii ma ke luhu, ma u troho tãhã koo syi dyaŋ, ufua ma mii nawee wii dyaŋ tuu kai- cã, ma ga u nwoŋ fãã ntẽmblaha fla na. ");
INSERT INTO xrb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sesaha ke gbã, lafir cããŋ yi ba dye ke laam wo, teflahangbãŋ ke fua fãnga ne, ke sẽ -sẽ too ye. Ke nwoŋ nakũy ba ta ntẽmblaha fla na koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wii tuu ra kaplãŋ ngĩĩ luhu, u ma yee u sẽ -sẽ u troho tãhã ke yor wo ye, ufua ma mii naplege dyaŋ, tuu ga u nwoŋ fãã tẽyãfũũ laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sesaha ke gbã, lafir cããŋ yi ba dye ke laam wo, teflahangbãŋ ke fua fãnga ne, ke n too pye klaha- tãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu tuu ba kaplãŋ ngĩĩ byɛ pãã kua, u wãklaha ter ba pe nabuar fe gbe, ma sya yɛ̃ gbãã pe na. ");
INSERT INTO xrb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","U sẽ naa nawee- klaha Yãhã kaiyarfa wãŋ syi dyaŋ ye, u ba kai- byɛ cã tãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu tuu tege ke yãŋ yĩŋ na, nabuar n nii n taha u na. ");
INSERT INTO xrb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Gber waa n pa u tãy, ma ba kãnklũy gbãã u yahasee ye ma yee: «Yĩŋfua, le ma tãy ma ye, ma ga waha ta ra n jaa n nii gbɛgbɛ nayɔ̃r saha na.» ");
INSERT INTO xrb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu n koho nɔ wãã, ma tɛ u na ma yee: «Ãwã le tãy ra ye, jaa ma nii gbɛgbɛ nayɔ̃r saha na!» Le yalebya wo, ke yãhã n ta tɛr laha kãã u dya na, u n nii gbɛgbɛ nayɔ̃r saha na. ");
INSERT INTO xrb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu n u pye ma yee: «Luhu yɔ̃, maʼa syi nde pãã waa ye ye! -Taa ka, maa mii yar Yãhã yũndefua na, ma ma wãjaa diŋ yi, diŋ gii faale wãdyaha Musa tuu tɔ̃r yaha mpãy kẽ pe pye yãhã ne pe kadye na, ma jaa. Ke syi ne nawee- ga waha cã ma jaa.» ");
INSERT INTO xrb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yaliile Yesu tuu dye Kapornu wo, seraasyi yĩŋfua waa n pa u fla na, maa u nar waha ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Yĩŋfua, ta tẽntẽle ma u sãy nii kaha wo, kadye n ku u na, u n fãy cĩĩnde wãfãy.» ");
INSERT INTO xrb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu n u pye ma yee: «N ga ka n ga u jaa.» ");
INSERT INTO xrb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","U seraasyi yĩŋfua n -sẽ u pye ma yee: «Yĩŋfua ta syi sẽ yai ma dye ra kaha wo ye. Kapãngbɛrle laa ya pãã, le n ta ra tẽntẽle n jaa. ");
INSERT INTO xrb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","N ma seraasyi, n n luhu ra yĩŋfa ye. N -sẽ ma nii ndoŋ seraasyi mpãy yĩŋ na. N ga nen waa pye: Ka nwaa, u n ka. N ga nen nwo pye: Pa nwo, u n pa. N ga maha ra tẽntẽle pye: Nde pye, u n le pye.» ");
INSERT INTO xrb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu tuu u kaplãŋ ngĩĩ luhu, ke n u fe gbe. Le n tãy tɛr u ye, mpãy pe naa n taha u na, u n sya pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Dya nwo, u ra ta u Yatɛr u laam byɛ wo cĩĩnde. Pe Yiifee- kur byɛ gɛ laam wo, n sẽ waa yãã yãã tuu ra ta u Yatɛr woo wãŋ syi ye. ");
INSERT INTO xrb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta n ye yar, mpãy ter ga ba yir kãntrɛ raa wo, driyɛ̃ kuɛ byɛ ye. Pe ga ba pa, pe ba nii gbar dir na Yãhã yai klo wo, wo faale wãlɛ Brama ye ne, Yisyake ne tesẽ Dyakuba ne. ");
INSERT INTO xrb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yiisrɛ kur, poo mpãy pe -sẽ yai pe dye Yãhã yai klo wo, pe ga ba miy yi wãã nkur ye wam fla wo, pe naa n wũn ke fla na, pe yĩntaha tãhã, pe cã pe wãfãy saa kua yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Loo kur ye, Yesu n u seraasyi yĩŋfua pye ma yee: «Ka ma kaha wo, taa ra ta ma Yatɛr, ma kai lii ga yigi, le ga pye yagaa.» U seraasyi yĩŋfua tẽntẽle n ta tɛr jaa le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Loo kur ye, Yesu n ka Pyar kaha wo. U n ga Pyar cɔɔ nahafua yãã, u ba sãy nii. U kadye ba war. ");
INSERT INTO xrb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu n tɛ u koho na, ke kadye n u miy yaha. U n yir, ma nii pe nampay yi. ");
INSERT INTO xrb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yainkɔŋ wo, pe n pa nawee- busãã ne Yesu fla na. Sãndãpee pye pe yĩŋ na. U kapãn n pe sãndãpee kar tege kãã pe nawee- yĩŋ na, u n maha pe yanfa byɛ jaa. ");
INSERT INTO xrb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tuu koo ngĩĩ pye, kai lii faale Yãhã kaplãŋ tɔ̃rfua Yisa tuu bii cãã pãã yaha, loo ne le pye. U Yisa bii yee: «U wo yan ter byɛ gbe kãã wo yĩŋ na, ma suhu wo kadye teebɛhɛ nkãy byɛ ne ke klaha- wo ye.» ");
INSERT INTO xrb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Loo kur ye, Yesu n nabuar yãã u ya tãy. Loo na, u n u kãnyãrwai pye pe ka ke langbãŋ kũndi ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yãhã kaiyarfua waa n yũhũ crã u na, ma u pye ma yee: «Yĩŋfua, maʼa sya n gaha teelii teelii, n ga naa n taha ma na.» ");
INSERT INTO xrb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu n u yɛ̃ wãã sya ma yee: «Yɛ̃srɛ̃ ma te syãsar ne, kãnsyãm ma pe nsɛŋ ne. Teele sẽ -sẽ wee u Nawee Puee myaha na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dya waa, u pye Yesu kãnyãrwɛ u ya ndoŋ, u n u pye ma yee: «Yĩŋfua, kãnde wãã ra kẽ, n ma ga ra tuhufua nakugu le wa, n ga pa.» ");
INSERT INTO xrb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu n u pye ma yee: «Tyii nakur na te n naa te nakurwai le. Mboo, ma naa n taha ra na ma kuãŋ ne.» ");
INSERT INTO xrb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Loo kur ye, Yesu n dugu dye ke salangbãŋ wo, woo tesẽ u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yalaale wo, teflahangbãŋ gaa n ba ta tɛr yir ke langbãŋ yĩŋ na, ma sya loho fua gbe le wãã n taha pe na, ke salangbãŋ wo. Yesu -sẽ ba sã wãy. ");
INSERT INTO xrb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pe kãnyãrwai n yũhũ crã u tãy, ma u gbã yir ma yee: «Yĩŋfua, waa ku, wo sya yaha!» ");
INSERT INTO xrb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu n pe yɛ̃ wãã sya ma yee: «Nwa ye n fya ke syi! Ye Yatɛr kloŋ tɛr la ye ye?» Loo na, u n yir, ma gbey ke teflahangbãŋ na tesẽ ke langbãŋ loho ne, te n yɛr, ke fla n nii seyĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Le n pe kãnyãrwai byɛ fe gbe, pe n sya nii le pãã pe ya ye ma yee: «Hãã, nawee wii ter syi kẽ dya nwo ne, u n gbey teflaha na tesẽ ke langbãŋ loho ne, te n sya n luhu u ye?» ");
INSERT INTO xrb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu tuu ga nɔ ke langbãŋ kuɛ ngaa kuɛ ye, Jerasinefa kuɛ ye, naam syãm mpãy n yi gbũhũ fla wo, ma Yesu wãã ba. Sãndãpee pye pe yĩŋ na, ma ba pe ta pe n ba pee cĩĩnde wãpee. Nawee- sẽ sya naa n tɛr pe kuɛ kãnde ne ye. Pe Yesu yãã, pe n nii n kui ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","«Yãhã Dya, nwa taa ga pye wo na? Maʼa n cãã wo pẽn wo pẽnyale yaha ye!» ");
INSERT INTO xrb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kaha tyɛ- busãã pye ke fla na, pe naa pe digi kɛ, pe fla ba faa dey. ");
INSERT INTO xrb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pe sãndãpee n Yesu nar ma yee: «Maʼa yee maa wo kar, tyii wo n ga dye tyɛ- mii laam laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu n le sya pe ye. Pe sãndãpee n tege kãã pe naam syãm yĩŋ na, ma ga dye pe tyɛ- laam laam wo. Le yalebya wo, pe tyɛ- n fã tege ga too dye ke langbãŋ wo, ma ku. ");
INSERT INTO xrb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pe tyɛ- sẽŋfa pe koo ngĩĩ yãã, pe n fã tɛr le klo wo, ma ga ke kai- byɛ tɔ̃r pe naam syãm mii wĩĩ na, mpãy, Yesu sãndãpee kar tege kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Loo na, pe klofa byɛ n yi ga Yesu wããsaha wo. Pe ga u yãã, pe n u nar u tɛr kãã poo fla kãntraha yaha. ");
INSERT INTO xrb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Loo kur ye, Yesu n salangbãŋ gbe, ma dur ga ke langbãŋ kũndi ngaa ye, tuu ba nii na. ");
INSERT INTO xrb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pe n tãnkurfua waa gbe ba u fla na u kasãy wãŋ ne, tuu sãy nii ke na. Pe koho taha yaha Yesu na ke syi, u n le yãã, ma u tãnkurfua pye ma yee: «Cĩĩfua mii waha, ma kapee- laha kãã ma yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yãhã kaiyarfa mpãy pye ke fla na, pe n nii le ga pe laam wo ma yee: «Eh, dya nwo n gbar Yãhã ne cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu n pe laam wũhũ cã, ma pe pye ma yee: «Nwa ta ye n nii kapee- ngĩĩ syi ga ye laam wo? ");
INSERT INTO xrb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","N ga waha yee: Ma kapee- laha kãã ma na. N ga maha waha yee: Yir naa n yãr! Koo katɛ- syãŋ ngĩĩ wo, lii loo le cã waha? ");
INSERT INTO xrb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","N -sẽ n yãŋ ye cã Yãhã kãnde wãã u Nawee Puee kẽ kãntraha nge na, u n ga waha kapee- gbe kãã nawee yĩŋ na.» Yesu n wã klaha loo na, ma u tãnkurfua pye ma yee: «N ma yar, yir, ma ma kasãy wãŋ gbe, ma yãr naa n gaha ma kaha wo!» ");
INSERT INTO xrb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","U tãnkurfua n yir, ma yãr tɛr u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pe nabuar pe loo yãã, le n pe laam wɔ pe n sya fya, ma nii Yãhã sey koo fãnga nge wĩĩ na, fãnga gii ke wãã nawee- kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu n tɛr ke fla yaha. U n nii n tɛr, ma ga kufar wããfua waa yãã tuu tege nii kufar wããsaha wo. Pe naa u yee Matɛhɛ. Yesu n u pye ma yee: «Naa n taha ra na!» Matɛhɛ n yir, ma nii n taha u na u kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Loo kur ye, Yesu pye dir na u kãnyãrwai ne, Matɛhɛ kaha wo. Kufar wããfa pye pe ba nihi, ma suhu kãmpee- yãrfa mpãy ter ne. Pe byɛ wãã naa n di pe ne. ");
INSERT INTO xrb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pe Farisyɛ̃ n loo yãã, ma Yesu kãnyãrwai pye ma yee: «Nwa ta ye Yĩŋfua n nii wãã n di kufar wããfa ne, ma suhu kãmpee- yãrfa mpãy ter ne?» ");
INSERT INTO xrb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu n pe kapãn luhu, ma pe pye ma yee: «Yĩnwɛrfa poo sẽ me pe tyinfua tay ye, yanfa poo pe u tay. ");
INSERT INTO xrb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ye sẽ Yãhã kaplãŋ ngĩĩ war ye, ngĩĩ ke yrũhũ yaha ma yee: ‹Laanyɔ̃m tẽ n kɛ, n sẽ yee diŋ wãyiŋ ye.› Ye yai ye koo war!» Yesu n maha yee: «Ye sẽ yãã, n pa kãmpee- yãrfa wĩĩ na; mpãy pe pe ya yãŋ poo ma kãnyĩĩ yãrfa, n sẽ pa poo wĩĩ na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Loo kur ye, Nsãn nawee- tããfua kãnyãrwai n ba pa Yesu fla na, ma ba u yey ma yee: «Nwa ta, wii tesẽ pe Farisyɛ̃ ne, wo ne wo yɛ̃ tã digi na, mboo kãnyãrwai sẽ -sẽ le syi pye ye?» ");
INSERT INTO xrb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu n pe yɛ̃ sya kakuãcraŋ ne ma yee: «Ah ye laam wo, cafãn yigifa ga waha pye la yĩntawahar na, u cafãn yigifua tuu ma pe ne? Ye cã le syi saha pye ye rɛhɛ! Per gaa -sẽ ma ke n pai, u cafãn yigifua ga ba yigi kãã pe laam wo. Koo per maa nɔ, pe ga ba cã naa pe yɛ̃ tã digi na. ");
INSERT INTO xrb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Waa sẽ faafuɛ̃ faagblaha ta, ma ga nayredyaha wihi pãhã n tã ke ne ye. Maʼa loo pye, le faafuɛ̃ ga ke nayredyaha tyĩn cɛr, kaa n maha taha ke cɛrsadyaha fla na. ");
INSERT INTO xrb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Waa sẽ maha sẽmper le srafũhũ sakueelɛr wo ye. Maʼa loo pye, pe sẽmper ma ba yir, te srafũhũ sakueelɛr ga fe, pe sẽm n woo tãŋ, te srafũhũ sakuee tii maha klaha- taha le na. Koo kẽ sẽmper yai pe le srafũhũ sakueefãn too laam wo. Ke syi ne, pe sẽm tesẽ te srafũhũ sakuee ne, ngaa saa te yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu naa koo kaplãŋ ngĩĩ pãã, Yiifee- yahaseefua waa n pa, ma ba kãnklũy gbãã u yahasee ye ma yee: «Ta pueesyale ku ke yagaa nge na; pa, ma ba koho taha le na, le n yir gbã wo le nii yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu n yir u kãnyãrwai ne, ma taha u dya na. ");
INSERT INTO xrb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Cɔɔ waa pye, u ntɔ̃r kuee naa n woo u ye dyɛ- sẽnsye syãŋ, wãyɛr wee ye. U n yũhũ crã Yesu na kur kuɛ ye, ma tɛ u nayroho yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","U ba le ga yigi ma yee: «N ma yãã tɛ u nayroho yɛ̃ ya na, n ga jaa.» ");
INSERT INTO xrb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu n wã klaha, ma u yãã ma yee: «Cɔɔ, mii waha, taa ra ta ma Yatɛr, loo le ma jaa.» Le yalebya wo, u cɔɔ n jaa. ");
INSERT INTO xrb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu tuu ga dye u yahaseefua kaha wo, u n pe kapẽnfa yãã, pe nabuar ne, pe nii n gble u kicar wãkɛlaa wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","U n yee: «-Ye yi kãã nwo, u kicar sẽ ku ye, wãy ya u sã wãy.» Pe n nii u lɛr. ");
INSERT INTO xrb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pe nawee- pe yi wa ke nakugu nwoŋ wo, Yesu n dye, maa le kicaale yigi koho na, le n yir, ma dur nii korkor. ");
INSERT INTO xrb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Le kapãn n cããŋ ga koo kuɛ teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu n tɛr ke fla yaha. U nii n tɛr, fũũ- syãm mpãy n nii n taha u na, ma nii n kui ma yee: «Dawide Dya, wo fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu tuu ga dye kaha wo, pe fũũ- n pa u fla na, u n pe yey ma yee: «Ye laam wo, ye yee la n ga waha ye jaa?» Pe n u yɛ̃ sya ma yee: «Ãwã, Yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Loo na, Yesu n tɛ pe yĩmpɛ na ma yee: «Tee ra ta ye Yatɛr, ma yee n ga waha ye jaa, loo na ye ga jaa.» ");
INSERT INTO xrb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pe yĩmpɛ n ta tɛr n yãŋ. Yesu n le pãã waha pe ye ma yee: «-Ye luhu yɔ̃, ye ma syi ye le gbe yi ye!» ");
INSERT INTO xrb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe -sẽ ka, ma ga Yesu wĩĩ pãã koo kuɛ teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pe nawee- syãm pe naa n tɛr, mpãy n pa Yesu fla na, dya waa ne sãndũpee pye u yĩŋ na, ma u ta u sẽ waha naa n pãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu tuu kãhã u sãndũpee kar tege kãã u bebe yĩŋ na, u n nii n pãã. Le n yɛ̃ gbãã pe nabuar na, pe n sya yee, waa sẽ nde syi yãã yãã Yiisrɛfa kãntraha wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pe Farisyɛ̃ poo -sẽ naa le pãã ma yee, a sãndãpee yĩŋfua kẽ u fãnga wãã Yesu kẽ u n waha sãndãpee kar tege n kãã nawee- yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu naa n yãr kungbãhã byɛ wo, tesẽ kusyĩmbɛhɛ byɛ ne. U naa nawee- klaha Yiifee- yawãhã nwey wo, ma naa le Yãhã Yai kapãyĩĩ wĩĩ yar nawee- na, ma naa yanfa ter byɛ jaa, ma suhu mpãy ne pe kadye teelaa fla klaha- pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tuu naa nabuar mpãy yãã, pe fɛn n u yigi, pe ba fãy, pe laam ba wlãhã; pe pye mii mbaa dyaŋ mbanaha wee pe na ye. ");
INSERT INTO xrb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Loo na, Yesu n u kãnyãrwai pye ma yee: «Te nabuar nde ma mii dingbãn wãŋ syi dyaŋ te wãgbe yale nɔ tar wo, tẽntẽ- sẽ -sẽ wee ma ga te gbe ye. ");
INSERT INTO xrb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yãhã gii ke -sẽ ma mii u dingbãnfua dyaŋ, -ye naa ke nar ke n tẽntẽ- nɔ wãã, pe n ba te nabuar le ke kãnde wo!» ");
INSERT INTO xrb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Loo kur ye, Yesu n u kãnyãrwai sẽnsye syãm yee ba, maa kãnde wãã pe kẽ pe waha sãndãpee kar tege naa n kãã nawee- yĩŋ na, pe waha naa yan ter byɛ jaa, tesẽ mpãy byɛ ne pe kadye teelaa fla klaha- pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pe tẽnlɛhɛ sẽnsye syãm myar nde: ");
INSERT INTO xrb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","U n Filipe yee, Bateremi ne; ma suhu Tema ne, ");
INSERT INTO xrb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma suhu Syimu wii ne klokai- wãgbihi n tãy u ye, ");
INSERT INTO xrb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu n poo nawee- sẽnsye syãm mii lɛhɛ wãã, ma pe yar ma yee: «Mpãy pe wee Yiifee- ye, -ye ma n ka pe kui wo ye, -ye ma n ka Syamarifa kui wo ye! ");
INSERT INTO xrb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mpãy pe ma Yiifee-, ma plaha mii mbaa dyaŋ u mbanaha wee pe ne ye, -ye ka poo ye! ");
INSERT INTO xrb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","-Ye Yãhã kapãyĩĩ pãã naa n gaha kãnde wo ye yee: Yãhã Yai nɔ gbe taha wa! ");
INSERT INTO xrb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ye ga naa yanfa jaa. Ye ga naa nakur ta te n yir gbã wo, te dur ba yrãŋ na gbaafa ye! Ye ga naa gber- jaa, pe n naa nii gbɛgbɛ nayɔ̃r saha na! Ye ga sãndãpee kar tege naa n kãã nawee- yĩŋ na! Loo kãnde nde, le wãã ye kẽ faa, ye bya ye ga naa n pye faa! ");
INSERT INTO xrb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ye ma syi ye sãn gbe war ne ye! Ye ma syi ye ntẽn war gbe le ye sapar jifaa wo ye! ");
INSERT INTO xrb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ye ma ga ke yrãhã yi, ye ma syi ye ngaa gbe ke n naa ye ndege ye, nkãnfaha dyaŋ, kalen sãnsĩĩ ne, ntãn ne, kãi gɛ ne ye! Ye sẽ yãã, tẽntẽfua yai pe naa u yɛ̃ digi wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ye ma ga dye klo lii wo, kungbãy woo, kusyĩnde woo, -ye yãŋ wii tuu yai u waha syãsaha wãã ye kẽ, -ye kuee woofua fla na ye sya ba tɛr! ");
INSERT INTO xrb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ye ma dye kaha gii wo, -ye yee: Yãhã ke yrĩŋ wãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Koo kaha ngefa ma ye yigi yɔ̃, tee pa yrĩŋ syaha gii ne, pe ga ke yrĩŋ yãã. Pe ma -sẽ yee pe sẽ ye yigi yɔ̃ ye, tee pa yrĩŋ gii ne, ke ga kuee ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kaha giifa, laa na klo liifa ma sye, pe sẽ ye yigi yɔ̃ ye, laa na pe sẽ luhu ye kaplãŋ ye ye, -ye tɛr kãã ke fla yaha, -tee ye trɛ mplẽm kor yaha pe na, pe n cã lii ma pe dye poo pe le kɛ. ");
INSERT INTO xrb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta n cĩĩnde nde pãã ye ye: Yãhã kasãhã per maa nɔ, Sodɔ̃ klofa tesẽ Gumor klofa ne pe sya bii pee tɛr, poo fɛn gɛ saa ba nɔ loo klo ndefa fɛn na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu n maha pe kãnyãrwai pye ma yee: «-Ye yãŋ, n ye lɛhɛ wãã mbaa dyaŋ waygapyãr nsoho wo. Tee -sẽ yii wãyigi cã nwɔr wãŋ syi, -ye nii kãnsyãm mpãy wãŋ syi dyaŋ pe saha kapee- pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","-Ye kacãn yãã yii na! Mpãy ga ba ye yigi naa n gaha kasãhã saha wo, pe ga ba naa ye gbã sãngblã ne, pe Yiifee- yawãhã nwey wo. ");
INSERT INTO xrb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pe ga ba ye yigi naa n gaha yahaseefa mpãy yaha ye, tesẽ yĩŋfa mpãy ne, ndoo wĩĩ na. Loo gɛ ga ba nii yĩŋ, ye n waha ta wĩĩ pãã pe yaha ye, poo tesẽ mpãy ne pe sẽ cĩĩnde Yãhã cã ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pe ma ba ye yigi ga kasãhã saha wo, kaplãŋ nkãy tee n pai pãã, tesẽ ye n pai ke pãã mii syi dyaŋ, ye ma n naa ntãŋ cɛr koo ngĩĩ ne ye! Kaplãŋ nkãy tee n pai pãã, ke ga ba le ye yɛ̃ wo loo yale wo. ");
INSERT INTO xrb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ke saa ba nii ye laam kaplãŋ ye, ye Tuhufua Yãhã Yrã Fãnga kẽ, ke ga ba naa n pãã ye yɛ̃ ne. ");
INSERT INTO xrb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nawee- mpãy ga ba pe nampyesey wãã pe n boo, tuhufa mpãy ga ba loo pye pe pii na. Kicar mpãy ga ba wã klaha pe pe seefa laha, pe ta pe n pe boo. ");
INSERT INTO xrb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ye wĩĩ ga ba fũhũ nawee- byɛ ye ta wĩĩ na. Wii ma -sẽ waha plãhã kuee ra kur ye ke kãnkai- byɛ wo, Yãhã ga ba u sya yaha. ");
INSERT INTO xrb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pe ma ba nii ye kɛ yĩntayãhã ne klo lii wo, -ye loo klo ta yaha, ye fã ga klo laa wo! Ta n cĩĩnde nde pãã ye ye: Ye saa ba Yiifee- kui byɛ fã tãŋ mii, u Nawee Puee sẽ dur ba wa ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ye le cã ma yee, wii tuu n klaha nantãŋ, u sẽ tɛr u klahafua yaha ye. Tẽntẽle sẽ tɛr u yĩŋfua yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wii tuu n klaha nantãŋ, pe ga waha u pye u klahafua wãŋ syi, tesẽ pe ga waha tẽntẽle pye u yĩŋfua wãŋ syi. Ye sẽ yãã, ndoo wii tẽ ma mii kahafua dyaŋ, pe ma ra yee Sebulɛhɛ sãndãpee yĩŋfua, yii mpãy tee ma ra kahafa, pe ga naa ye bya yee ke syi, loo laha.» ");
INSERT INTO xrb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesu n maha yee: «Ye ma syi ye naa n fya nawee- na ye! Ngii ngii ke wũhũ nii, ke ga ba yãã gbaa na. Kai- nkãy ke maha ma, waa sẽ ke cã ye, ke ga ba cã. ");
INSERT INTO xrb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ke syi ne, kaplãŋ nkãy tẽ n pãã yii ya ye yĩmperwoho wo, -ye ke pãã nawee- byɛ ye yaiwaha na; tesẽ nkãy yii ya tee n luhu ra ye, -ye ke pãã nanihi fla wo nawee- byɛ ye! ");
INSERT INTO xrb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mpãy syi pe ga waha nawee kadye boo, pe sẽ -sẽ ga waha u yrã boo ye, ye ma syi ye naa n fya poo na ye! -Ye naa Yãhã koo fya, koo gii ke ga waha nawee kadye pye klaha- tãŋ, tesẽ u yrã bya ne naa laam wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kãnsyãyi mii syi wãm syãm sẽ n par la warpua ya ne? -Ye cã ye yee, poo nen waa gɛ sẽ n too kãntraha na mii, ye Tuhufua Yãhã sẽ le cã wa ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ye yĩnyor nde gɛ Yãhã te byɛ yɛ̃ cã yaha wa. ");
INSERT INTO xrb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ye ma syi ye naa n fya laa ne ye; -ye cã ye yee, ye wĩĩ gboho Yãhã ye, ma tɛr kãnsyãyi mii syi wãbuar yaha. ");
INSERT INTO xrb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Wii ma le pãã nawee- yĩnde na ma yee woo u ya le soho ra koho wo, ta bya ga ba le pãã ta Tuhufua Yãhã ye, n yee woofua ma ra wũũ. ");
INSERT INTO xrb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wii ma -sẽ le pãã nawee- yĩnde na ma yee woo sẽ ra cã ye, ta bya ga ba le pãã ta Tuhufua Yãhã ye, n yee n sẽ woofua cã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesu n maha yee: «Ye ma syi ye le ga ye yee, n pa nawee- yĩmbuhu wããlesaha wo pe ya ne ye. N pa pe wãcɛr yĩmbui ne pe ya na. ");
INSERT INTO xrb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N pa n n pai dya cɛr u tuhufua na; n n pai pueesya cɛr u nahafua na; n n pai cɔɔ cɛr u nansya na. ");
INSERT INTO xrb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nawee nawee woo, u nwoŋfa poo pe ga nii u napĩĩ-. ");
INSERT INTO xrb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wii tuhufua wĩĩ ma n tãy u ye, u nahafua wĩĩ ne, ma tɛr ndoo wĩĩ yaha, woofua syi saha nii ra kãnyãrwɛ ye. Wii dya wĩĩ ma n tãy u ye, u pueesya wĩĩ ne, ma tɛr ndoo wĩĩ yaha, woofua syi saha nii ra kãnyãrwɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wii ma cã u ga waha wãfãy sya ra wĩĩ na, u ma sya ga gbãpee ku, woofua syi yai u naa n taha ra na. ");
INSERT INTO xrb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wii tuu u ya yĩŋ kɛ, ma suhu u laam wãn ne, woofua ga ba too byɛ kɛ laa; wii tuu -sẽ ga le sya u u yĩŋ kɛ laa, ma suhu u laam wãn ne ndoo wĩĩ na, woofua kẽ tuu cã ga ba too nde byɛ yãã.» ");
INSERT INTO xrb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu n maha yee: «Nawee wii ma ye gbihi yigi, ndoo kẽ tuu gbihi yigi; nawee wii ma -sẽ ndoo gbihi yigi, ta Tuhufua Yãhã gii ke ra lɛhɛ wãã, koo kẽ ufua gbihi yigi. ");
INSERT INTO xrb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wii ma Yãhã kaplãŋ tɔ̃rfua yãã, ma yee Yãhã kaplãŋ tɔ̃rfua kẽ u ne, ma u gbihi yigi, ufua ga ba kayũhũ yãã Yãhã ye, Yãhã kaplãŋ tɔ̃rfua wãŋ syi dyaŋ. Tesẽ, nawee wii tuu sroŋ Yãhã yĩnde na, wii ma u yãã, ma yee u sroŋ Yãhã yĩnde na, ma u gbihi yigi, ufua ga ba kayũhũ yãã Yãhã ye, nasroŋ wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta n cĩĩnde nde pãã ye ye: Mpãy pe ma naflam ta kãnyãrwai laam wo, wii ma poo nen waa yãã ma yee u ma ndoo kãnyãrwɛ, ma sekuyĩĩ nen wãã u kẽ lawɔŋ ya ne, ufua ga ba kayũhũ yãã Yãhã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu tuu u kãnyãrwai sẽnsye syãm klaha wa koo kai- ngĩĩ ne, u n yir ke fla na ma tɛr. U n ka kui nkãy wo, ma ga nii nawee- klaha, ma Yãhã kapãyĩĩ pãã pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nsãn nawee- tããfua pye nwompihi wo. U Yãhã Yĩndefua Crise tuu naa kai- nkãy pye, u n ke luhu. U n u kãnyãrwai mpãy lɛhɛ wãã Yesu ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pe n ga u yey ma yee: «U Yãhã Yĩndefua wii wãpaŋ too n sẽŋ, mboo la woo laa, u kuee wãpaŋ na kur ye?» ");
INSERT INTO xrb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu n pe yɛ̃ sya ma yee: «Nkãy tee n luhu, ma suhu nkãy ne tee n yãã yĩnde ne, -ye ka yaa ke tɔ̃r yar Nsãn na ye yee: ");
INSERT INTO xrb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Fũũ- n yãŋ, tãnklahafa gbihi n yãr, gber- wã klaha n nii gbɛgbɛ nayɔ̃r saha na, nditẽy n luhu, nakur n yir gbã wo, le Yãhã kapãyĩĩ n pãã nawãm ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wii ma yee u sẽ ba dur yi ta kur ye ye, ta n nii yai tãŋ u Yatɛr, woofua wĩĩ n tãy Yãhã ye!» ");
INSERT INTO xrb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nsãn kãnyãrwai pe tɛr wa, Yesu n nii Nsãn wĩĩ pãã pe nabuar ye ma yee: «Tee ka Nsãn fla na drawaha fla wo, ye -sẽ ka ma ga nwa yãŋ? Kipua sẽ kẽ tee ga yãŋ teflaha ke u yɛhɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ye -sẽ ka maa nwa yãã? Ye sẽ ka maa dya waa yãã tuu nangbãŋ nayreyɔ̃r le yɛr ye rɛhɛ. Ye cã mpãy pe nangbãm nayreyɔ̃r le, pe n nii nangbãm kangbãy wo. ");
INSERT INTO xrb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tee ka, Yãhã kaplãŋ tɔ̃rfua la tee ga yãã? Ãwã, ta n ye yar, Nsãn wii tee ga yãã u tɛr gɛ tɛr Yãhã kaplãŋ tɔ̃rfua yaha. ");
INSERT INTO xrb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Woo wĩĩ kẽ, le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹N nwo, n ta tẽnlɛhɛle nɔ wãã ma yahasee ye, u n gaha ta kãnde gbihi yaha ma kẽ.› » ");
INSERT INTO xrb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yesu n maha yee: «Ta n cĩĩnde nde pãã ye ye: Naa wii u tɛr Nsãn yaha, usyi sẽ see wa ye. Wii u kloŋ Yãhã Yai wo, woo -sẽ tɛr Nsãn yaha. ");
INSERT INTO xrb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nsãn tuu yir, ma nii nawee- yar ma yee, Yãhã Yai nɔ wa gɛ nɔ wa, ma gbe koo cãã na, ma sya ba nɔ nanga na, fãngafa n kɛ poo ga dye Yãhã Yai wo fãnga na. ");
INSERT INTO xrb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ma gbe faale cãã na, ma sya ba nɔ Nsãn cãã na, pe Yãhã kaplãŋ tɔ̃rfa byɛ bii Yãhã Yai wãpa wĩĩ yar yaha. Ke maha cãã yar yaha le Yãhã kãnde saba laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ye ma yee yaa le sya cĩĩnde, pe bii Yeli wãdurba wĩĩ cãã pãã yaha mii syi dyaŋ, Nsãn pa koo syi. ");
INSERT INTO xrb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃! ");
INSERT INTO xrb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","N ga waha yagaafa tɔ̃r mpãy ter syi ne? Pe ma mii kicar dyaŋ, pe tege nii nanihi nantrangbãŋ fla wo. Mpãy n nii pe nampyeŋ- pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹Wo fleŋ wuu ma yee -ye yɔɔ, ye sẽ -sẽ yɔɔ ye. Wo n dur, ma kasii yay le, ye sẽ -sẽ wũn ye.› ");
INSERT INTO xrb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ye sẽ yãã, Nsãn tuu yir, u sẽ bur di ye, u sẽ maha defĩĩ wɔ ye. Nawee- n loo yãã ma yee sãndãpee ma u yĩŋ na! ");
INSERT INTO xrb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","U Nawee Puee tuu yir, u bur di ma defĩĩ wɔ. Nawee- n loo yãã, ma maha n yee: ‹Ye sẽ dya nwo yãã? U ma tefɛŋ, ma maha ma sẽnwɔplaha. U maha naambiyãr le kufar wããfa poo ne, tesẽ kãmpee- yãrfa mpãy ter syi ne.› » Yesu n pe yar taha ma yee: «Mpãy pe pe troho tãhã Yãhã laantor yor wo, pe kai- sroŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Loo kur ye, kui nkãy Yesu tuu cã ba laanwɔ wũhũ pye nihi, ma tɛr teebɛhɛ byɛ yaha, u n nii n kuãn koo kui ngĩĩfa na. Pe tee ba sye, pe sẽ koho klaha ma pe kapee- wãpyeŋ miy yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","U naa n kuãn ma yee: «Korasyifa, ye wĩĩ pee Yãhã ye! Gbesyatafa, ye wĩĩ pee Yãhã ye! Laanwɔ wũhũ nkãy ke pye ye yĩnde na, koo syi ma ne pye faalefa Tyirfa yĩnde na, tesẽ faalefa Syidɔ̃fa ne, pe ne ga pye pe ta tɛr le cã kãã wa le yalebya wo pe kapee- sẽ yɔ̃ ye. Loo nde na, pe ne ga wram wĩĩ pye, pe nfããper ta pe fɛn nayrɛ pãhã, pe le. ");
INSERT INTO xrb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Loo ne, n ga ye yar, Yãhã kasãhã per ma ba nɔ, le ga ba pee ye na, le ta tɛr pe Tyirfa na tesẽ pe Syidɔ̃fa ne. ");
INSERT INTO xrb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ah yii Kapornufa, ye yee la pe ga ba ye kuã yir ga ta yãhãyĩŋ na? Yaʼa n naa loo gɛ ga ye laam wo ye! Ye ga ba tege ga ta tãã ye, nakur fla wo. Ye sẽ yãã, laanwɔ wũhũ nkãy ke pye ye yĩnde na, ke ma ne pye pe Sodɔ̃fa yĩnde na, pe ga ne koho klaha, Yãhã saa ne pye ke loo klo nde wĩĩ kua ye. ");
INSERT INTO xrb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Loo ne, n ga ye yar, Yãhã kasãhã per ma ba nɔ, ye wãpẽn ga ba gboho ta tɛr pe Sodɔ̃fa wãpẽn yaha.» ");
INSERT INTO xrb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Loo yale wo, Yesu n maha yee: «Ta Tuhufua Yãhã, mboo taa ma yãhãyĩŋ Yĩŋfua tesẽ kãntraha ne. Lii taa sẽ yar kaicãfa na tesẽ sabacãfa ne ye, ma loo yar mpãy na pe ma pra kicar wãŋ syi dyaŋ. N ma sey loo wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ãwã Tuhufua, le tãy ma ye, koo kẽ ma n le ta ke dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu n dur, ma pe nawee- pye ma yee: «Ta Tuhufua Yãhã kai- byɛ le soho ra koho wo. Nawee- sẽ cã yoo kẽ ra ne ye. Ta Tuhufua ya ke le cã. Pe sẽ maha cã yoo kẽ ra Tuhufua Yãhã ne ye. Ndoo ya n ke cã, tesẽ mpãy ne tẽ ke yar pe na. ");
INSERT INTO xrb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yii mpãy wãfãy gboho ye na, tesẽ fɛngbãn ma ye yĩŋ na, -ye pa ra fla na, ta n ba koo byɛ gbe kãã ye na, tẽ yrĩŋ wãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ye tyii ye naa ra tẽn tẽ, ta n naa ye klaha ta kaklaha ne, ye -sẽ ga yrĩŋ yãã ye laam wo. Ye sẽ yãã, ta laam n tãy, n maha ma pra. ");
INSERT INTO xrb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta tẽn wĩĩ n tãy, tesẽ ta teger ma yaayaa.» ");
INSERT INTO xrb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Plii raa kur ye, Yesu ba tar raa yi naa n yaha u kãnyãrwai ne. Koo per pye kanii per. Fãã ba pe kãnyãrwai yigi, pe n nii te tar kasan kãy n kũ. ");
INSERT INTO xrb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pe Farisyɛ̃ pe loo yãã, pe n Yesu pye ma yee: «Wo kãnde le kai- nkãy yar ke sẽ yai ke naa n pye kanii per wo ye, nwa ta ma kãnyãrwai n le syi laa pye!» ");
INSERT INTO xrb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu n pe yɛ̃ sya ma yee: «Ye le kal yãã Yãhã sabangbãŋ wo, faale yĩŋfua Dawide u bii lii pye, per gii fãã bii war pe na, woo tesẽ u nawee- ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","U dye Yãhã nwoŋ laam wo, bur rii te pye te bii kẽ Yãhã ye, u n te gbe di u nawee- ne. Pe sẽ -sẽ ba yai pe te di ye. Wo kãnde na, Yãhã yũndefa ya sẽ na, pe yai too bur nde ne? ");
INSERT INTO xrb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lii le yrũhũ ta le Yãhã kãnde saba laam wo Yãhã yũndefa wĩĩ na, ye maha le cã. Le yrũhũ ta, a pe yai pe pe tẽn tẽ Yãhã kangbãŋ wo kanii per na, kapee wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kaklaha nkãy tẽ ye klaha ke ne yagaa, ke -sẽ tɛr Yãhã kangbãŋ wĩĩ gɛ na! ");
INSERT INTO xrb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Le ma le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, laanyɔ̃m poo me Yãhã n kɛ nawee- ye, ke sẽ yee diŋ wãyiŋ ye. Ye sẽ kaplãŋ ngĩĩ yĩntaha war ye, mii loo sẽ ne ye, tee baha mpãy na, yaa ne cã kapee sẽ kẽ pe pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ye sẽ yãã, u Nawee Puee kẽ u ma kanii per yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Loo kur ye, Yesu n ka pe Yiifee- yawãhã nwoŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Dya waa pye kãnwaage ne ke fla na. Mpãy pe pye ke fla na, pe naa n kɛ pe laa taha Yesu na. Loo ne, pe n u yey ma yee, pe wãlɛ kãnde na nawee ga waha yanfua jaa la kanii per wo. ");
INSERT INTO xrb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu n pe yɛ̃ wãã sya ma yee: «Ye laam wo, waa ma pye mbua nen ne, u n too dye wuhu gaa laam wo kanii per wo, ufua ga yee la, a woo saa u yi ye? ");
INSERT INTO xrb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nawee sẽ puar la mbua na? Ye yai ye cã wo kãnde wo, waa ga waha kayĩĩ pye waa kẽ kanii per wo.» ");
INSERT INTO xrb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Loo na, Yesu n u dya pye ma yee: «Ma koho dii wãã.» U n ke dii wãã, ke n dur yɔ̃ nii u ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pe Farisyɛ̃ n tɛr, ma ga pe ya wãã, ma ga cã pe ga waha Yesu yãã pe u boo mii syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu tuu luhu pe u kɛ wãboo ne, u n tɛr koo fla yaha. Nabuar naa n yãr u ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","U n pe yanfa byɛ jaa, ma pe yar waha ma yee, pe ma syi le pãã yoo kẽ u ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu tuu koo kai- ngĩĩ pye, Yãhã yɛ̃ kaplãŋ nkãy faale Yãhã kaplãŋ tɔ̃rfua Yisa tuu bii cãã yar yaha, koo kẽ ke pye. Yãhã bii yee: ");
INSERT INTO xrb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Ta tẽntẽ wii tẽ yãŋ yi, woo kẽ nwo. Woo ntãŋ dye ra tãy, u ra laam yĩn yalebyɛ. N ga ra Yrã Fãnga tege u na, u n ta laam wĩĩ tɔ̃r yar kãntrɛ byɛ nawee- na. ");
INSERT INTO xrb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","U saa ba naa kaplãŋ tyĩn waa ne ye, u saa ba naa n gbey waa na ye. U saa ba naa kaplãŋ pãã nanihi teebɛhɛ wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mpãy, fãnga wee pe na ye, mii kipua kãi dyaŋ le ga naha ka, tesẽ naaloho dyaŋ ke ga fege, u ga ba pe gbihi ta. U ga ba yia kai- byɛ na, u ke ta ke n sroŋ. ");
INSERT INTO xrb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kãntrɛ byɛ nawee- ga ba koho taha yaha u na.» ");
INSERT INTO xrb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pe n pa dya waa ne Yesu kẽ. Sãndãpee pye u yĩŋ na, ma u ta u n nii fũũ, ma maha nii bebe. Yesu n u dya jaa, u n waha n pãã ma maha n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pe nabuar mpãy pe pye, le n yɛ̃ gbãã pe na, pe n sya n yee, a Dawide Dya ga kẽ Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pe Farisyɛ̃, pe -sẽ loo kapãn nde luhu pe nawee- yɛ̃ na, pe n yee: «Sãndãpee yĩŋfua Sebulɛhɛ kẽ tuu fãnga wãã dya nwo kẽ, koo kẽ u n waha sãndãpee kar tege n kãã nawee- yĩŋ na!» ");
INSERT INTO xrb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu -sẽ ba pe laam wĩĩ cã wa. U n pe pye ma yee: «Kãntraha neŋfa ma kuee n wãã pe ya ne, koo kãntraha nge ga too. Klo liifa ma kuee n wãã pe ya ne, loo klo nde wĩĩ saa waha gbihi nii ga yahasee ye ye. Nwoŋ neŋfa ma kuee n wãã pe ya ne, koo nwoŋ nge saha gbihi nii ga yahasee ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sãndãpee yĩŋfua Setane ma nii u ya koho kla kar, u n wãã u ya ne. U fãnga saa waha ka yahasee ye ye, ke ga klaha-. ");
INSERT INTO xrb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ye yee n sãndãpee kar tege n kãã nawee- yĩŋ na, sãndãpee yĩŋfua Setane kẽ tuu koo fãnga wãã ra kẽ. Cĩĩnde sẽ ne ye. Mii loo sẽ ne ye, ye nampyeŋ- mpãy pe sãndãpee kar n tege, ye ma yee pe bya loo pye Setane fãnga kãmay na, poo gɛ ga ye yar pe yee, cĩĩnde sẽ ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ta n ye yar: N sãndãpee kar tege n kãã nawee- yĩŋ na Yãhã Yrã Fãnga ne. Loo na, ye yai ye cã, Yãhã Yai pa wa ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Waa saha dye fãngafua waa kaha wo, u u wãn yuhu gbe mii, u sẽ cãã u pua yigi yaha wa ye. U ma -sẽ waha yia u na ma u pua, u ga waha u kaha wãn byɛ yuhu gbe u ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wii ma yee u wee ra ne ye, woofua ma ra napĩĩ. Tesẽ, wii ma yee u saa koho le ra ye u nawee- wãã ba ra kẽ ye, woofua u pe kar n kãã ra na. ");
INSERT INTO xrb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Loo ne, n ga ye yar nde ne: Yãhã ga waha nawee kapee- laha kãã u yĩŋ na, u yorpeer byɛ ne. Ma -sẽ yee, wii woo na tuu ga yorpeer pãã Yãhã Yrã Fãnga kẽ, Yãhã saa woofua nwo kapee nde laha kãã u yĩŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nawee wii ma tee pãã u Nawee Puee wĩĩ na, Yãhã ga ba loo kapee laha kãã u yĩŋ na. Wii ma -sẽ tee pãã Yãhã Yrã Fãnga wĩĩ na, loo kapee nde saa laha kãã u yĩŋ na, nanga nge na tesẽ sukũhũ gaa ne ye.» ");
INSERT INTO xrb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu n maha yee: «Katyiyũhũ koo ke puayɔ̃ sa. Ye ma pye katyipihi ne, ke ga naa puapihi sa ye kẽ. Nawee ga waha katyigi yãŋ cã ke pua na, pua wii ke n sa. ");
INSERT INTO xrb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nwoho terfa me ye ne! Ye pee, loo ne kayũhũ saha yi ye yɛ̃ wo ye. Nawee laam ke yĩĩ nkãy ne, koo kẽ ke n yi u yɛ̃ wo. ");
INSERT INTO xrb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nawee wii ma yɔ̃, kayũhũ ga naa n yi u laam wo, u n naa ke pye. Nawee wii ma pee, kapee- ga naa n yi u laam wo, u n tee naa n pye. ");
INSERT INTO xrb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ta n ye yar: Yãhã kasãhã per ma ba nɔ, mpãy pe naa kaplãŋ nkãy pãã ke sẽ yai wãpãã ne ye, Yãhã ga ba pe sãhã loo nde wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ye sẽ yãã, mboo wii kaplãŋ ma yɔ̃, ma ga ba wloho yi. Mboo wii kaplãŋ ma yee ke sẽ yɔ̃ ye, ma ga ba kuee le wo.» ");
INSERT INTO xrb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Loo kur ye, Yãhã kaiyarfa mpãy ma suhu Farisyɛ̃ mpãy ne, pe n Yesu pye ma yee: «Yĩŋfua, wo n traha ma laanwɔ wĩĩ laa pye, wo n yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu n pe yɛ̃ wãã sya ma yee: «Yagaafa pee, pe sẽ maha n sroŋ Yãhã ye ye! Ma -sẽ yee poo n traha pe laanwɔ wĩĩ laa yãã yĩnde ne. Aye, laanwɔ wĩĩ laa saa pye ye n yãã yĩnde ne ye, mii lii syi sẽ ne le bii faale Yãhã kaplãŋ tɔ̃rfua Yonase dye ye. ");
INSERT INTO xrb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ye sẽ yãã, Yonase plii tãã pye yĩmplii tãã ne fuangbãŋ laha wo, ma bii yi u laam wo. Koo syi dyaŋ u Nawee Puee ga ba tugu le gbĩĩ wo, u plii tãã pye yĩmplii tãã ne le laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Yonase bii Yãhã yɛ̃ kapãn pãã faalefa Nenefufa ye. Pe n le luhu, ma koho klaha ma pe kapee- wãpyeŋ miy yaha. Yãhã kasãhã per maa nɔ, pe Nenefufa ga ba le pãã pe yee, yagaafa pe sẽ koho klaha ye, pe tee pye. Kaplãŋ nkãy tẽ -sẽ n pãã ye ye, ke tɛr Yonase wũhũ yaha. ");
INSERT INTO xrb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yãhã kasãhã per maa nɔ, faale Syeba kãntraha yĩŋfasya ga ba le pãã u yee, yagaafa pe sẽ koho klaha ye, pe tee pye. Woo bii yir deydey kui wo, ma pa faale yĩŋfua Salmuu fla na, ma bii u kacãyor luhu. Kaplãŋ nkãy tẽ -sẽ n pãã ye ye, ke tɛr Salmuu wũhũ yaha!» ");
INSERT INTO xrb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesu n maha yee: «Sãndũpee ma pye nawee yĩŋ na, ma ba tege kãã u na, u sãndũpee ga ka drawaha fla wo, u ga tay naa n klaha, u ma teelaa yãã u nii naa n wũũ. U ma yee u sẽ teelaa yãã ye, ");
INSERT INTO xrb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","u ga yee tuu tɛr u niisaha gii yaha, u ga dur ga nii ke fla na. Loo na, tuu pye nawee wii yĩŋ na, ma ba tege kãã u na, u ga dur ga u fla na. U n gaha u nawee laam yãã mii nwonwaha dyaŋ pe ke pɛ, ma ke gbihi ta. ");
INSERT INTO xrb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Loo na, u sãndũpee ga yir, u ga u nampyeŋ- kuasĩĩ mpãy yigi ba, mpãy pe maha pee woo na. Pe byɛ ga pe ya wãã ba nii u nawee yĩŋ na. U nawee wĩĩ ga pee le ta tɛr faale yaha. Yagaafa pe yee poo pee, pe wĩĩ ga ba nii koo syi.» ");
INSERT INTO xrb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu naa n pãã nantãŋ nabuar ne, u nahafua n pa, Yesu cĩĩfa ne. Pe n kuee nkur ye. Pe naa n kɛ pe pãã Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Waa n ba Yesu pye, a u nahafua ma nkur ye tesẽ u cĩĩfa ne, pe n kɛ pe pãã u ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu n ufua yɛ̃ wãã sya ma yee: «N ga ye yar mpãy poo pe sroŋ ma ta nahafua, ta cĩĩfa ne cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Loo na, u n kãnde kã u kãnyãrwai na ma yee: «Ye sẽ yãã, ta nahafua ma nwo wo, tesẽ ta cĩĩfa ne. ");
INSERT INTO xrb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mpãy pe ra Tuhufua Yãhã wũhũ pye, poofa pe ma ta cĩĩfa, ta syafa, ta nahafa.» ");
INSERT INTO xrb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Koo per na, Yesu n yi kaha wo, ma ga tege nii ke langbãŋ yɛ̃ tãy, ma nii nawee- klaha. ");
INSERT INTO xrb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pe nawee- ba nihi ga ta tɛr, u n sya dugu dye nii salangbãŋ gaa laam wo. Pe nabuar -sẽ pye ke langbeŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu naa Yãhã wũhũ busãã tɔ̃r pe ye kakuãcraŋ ne. U n pe yar ma yee: «Naa waa yi u kaha wo, ma ga digi yãr u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tuu naa ke digi yãr u tar wo, pii mpãy n ga too kãnde ngbeŋ na. Kãnsyãm n pa, maa pe wãy di kãã. ");
INSERT INTO xrb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pii mpãy n ga too ntẽmbakor fla wo, kãntraflũhũ sẽ pye yɔ̃ ke fla na ye. Loo n ta pe pii sẽ waha dye ga laam wo ye, ma ta tɛr fĩy. ");
INSERT INTO xrb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yaliile yai ke ba war dye yĩndai wo, ke n too dir wãn suhu boo. Te nnen sẽ waha ba sɛr yigi yɔ̃ ye, ke fla tee pye ntẽmbakor fla. ");
INSERT INTO xrb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pii mpãy n ga too ngur wãn taa nsoho wo. Pe n ba fĩy, te ngur wãn n pe puãr, pe sẽ waha lɛ dye ye. ");
INSERT INTO xrb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pii mpãy n -sẽ too kãntrayũhũ na. Poo n fĩy, ma ba sa. Taa n pii le gboho, taa n faa le gboho, taa n le car.» ");
INSERT INTO xrb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu n pe yar taha ma yee: «Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pe kãnyãrwai n yũhũ crã Yesu na, ma u yey ma yee: «Nwa ta ma n nii ke kai- tɔ̃r pe ye kakuãcraŋ ne?» ");
INSERT INTO xrb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","U n pe yɛ̃ wãã sya ma yee: «Kai- nkãy nawee sẽ ke cã yãã Yãhã Yai wĩĩ na ye, Yãhã ta yii ga waha ke war. Ma -sẽ yee poo na, pe saha koo kai- war ye. ");
INSERT INTO xrb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wii ma waha ke war cacar, u ga ba ke war naa n gboho, u sya ba busãã cã. Wii ma -sẽ ke wãwar sye, car gii tuu cã, ke ga faha u na. ");
INSERT INTO xrb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pe n yãŋ, pe sẽ -sẽ ngaa yãã ye. Pe ndityuhu cre, pe sẽ -sẽ laa luhu ye, pe sẽ -sẽ laa war ye. Loo ne ta n nii ke kai- tɔ̃r pe ye kakuãcraŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Faale Yãhã kaplãŋ tɔ̃rfua Yisa, tuu bii kai- nkãy cãã yrũhũ yaha pe wĩĩ na, koo kai- kẽ ke nii n pye loo yale wo. U bii yee, Yãhã yee: ‹Ye ga ba luhu naa n yɔ̃, ye sẽ -sẽ ga ba naa laa war ye. Ye ga ba yãŋ naa n yɔ̃, ye sẽ -sẽ ga ba naa ngaa yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ye laam tee waha tɛr; ye ndityuhu gbãã tã, ma yĩmpɛ tyĩn tã, ma yee ye yĩmpɛ ma n ngaa yãã ye, ye ndityuhu ma n laa luhu ye, ye ma n laa war ye laam ne ye. Mii loo sẽ ne ye, ye ga faha ba ta kãnde yigi, ta n ye jaa ye kapee- wãpyeŋ na.› » ");
INSERT INTO xrb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu n u kãnyãrwai pye ma yee: «Yii poo na, ye wĩĩ n tãy: Ye yĩmpɛ n yãŋ, ye ndityuhu n luhu. ");
INSERT INTO xrb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta n cĩĩnde nde pãã ye ye: Yãhã kaplãŋ tɔ̃rfa busãã, tesẽ nawee- busãã mpãy ne pe naa n yãr Yãhã kãnde wo, poo mii byɛ naa n kɛ pe nii ye dyaŋ. Yii tee nkãy yãã yagaa, pe naa n kɛ pe ke yãã yĩnde ne, pe sẽ ke yãã ye. Nkãy tee n luhu yagaa, pe naa n kɛ pe ke yãã luhu ndityuhu ne, pe sẽ ke yãã luhu ye.» ");
INSERT INTO xrb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu n maha yee: «-Ye luhu ke digi yãrfua wĩĩ yĩntaha ne! ");
INSERT INTO xrb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nawee wii ma Yãhã Yai kapãyĩĩ yãã n luhu, u laam ma -sẽ pye mii pii mpãy dyaŋ pe too le kãnde ngbeŋ na, u saa le kapãyĩĩ war ye, u sãndãpee yĩŋfua ga pa, u ba le yi kãã u laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wii ma le kapãyĩĩ luhu, u laam ma -sẽ plãhã ntẽmbakor fla dyaŋ pe pii pe too na, u ga le sya nuhu ne le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","U sẽ -sẽ ga tyii le n nii gbãã u laam wo ye. Le ma ba nii mii wãfãy dyaŋ u na, tesẽ fɛn ne le kapãyĩĩ wĩĩ na, u ga le miy yaha. ");
INSERT INTO xrb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wii ma le kapãyĩĩ luhu, u laam ma -sẽ pye mii pii mpãy dyaŋ pe too ngur fla wo, u saa kuee le kapãyĩĩ kur ye ye. Kayaaŋ ne gboho tɛr usyifua wo, tesẽ wale wãkɛ ne. Too wĩĩ ma ba gboho ta tɛr u laam wo, te ga nii tã le kapãyĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wii ma le kapãyĩĩ luhu ma le war, u laam ma mii pii mpãy dyaŋ pe too kãntrayũhũ na. Le kapãyĩĩ pii ga lɛ u laam wo, le kayũhũ sa; mpãy pe sa gboho, mpãy pe sa yai, mpãy pe sa car.» ");
INSERT INTO xrb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu n maha kakuãcran laa tɔ̃r pe ye ma yee: «Yãhã Yai wĩĩ ma mii nde dyaŋ tẽ ga tɔ̃r ye ye: Dya waa ba yɛ̃y tãhã u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per gaa yĩmper wo, nawee- byɛ ba sã wãy, u tarfua napĩĩ n pa, ma ba nyɛ̃pihi tãhã le wlãhã te dir wãn laam wo ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te dir wãn n ba fĩy, ma nii n lɛ. Ke nyɛ̃pihi bya n fĩy. ");
INSERT INTO xrb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","U tarfua tẽntẽ- n ke nyɛ̃ yãã, ma ba u pye ma yee: ‹Yĩŋfua, te yɛ̃y ba yɔ̃ ma ye, taa ba tãhã ma tar wo; ah ke nyɛ̃pihi nge -sẽ yir na?› ");
INSERT INTO xrb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","U n pe yɛ̃ sya ma yee: ‹Ta napĩĩ waa kẽ tuu loo pye.› Loo na, u tẽntẽ- n u yey ma yee: ‹Wo ka la, waa ke nyɛ̃pihi kuã kãã?› ");
INSERT INTO xrb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","U n yee: ‹Aye, ye ma syi ye ke nyɛ̃pihi kuã ye; mii loo sẽ ne ye, ye ga waha te dir wãn wãã le kuã ke nyɛ̃pihi ne. ");
INSERT INTO xrb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ye tyii te na, te n wãã naa n lɛ ke digi gbeyale n ba nɔ. Le yale wo, tẽntẽ- mpãy pe n pai ke digi gbe, n ga ba pe yar n yee: -Ye cãã ke nyɛ̃pihi kuã yi kãã, ye ke pua yigi nkloŋ nkloŋ, ye ba ke suhu! Loo kur ye, -ye te dir gbe le ta kẽ pɛn laam wo!› » ");
INSERT INTO xrb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu n maha kakuãcran laa tɔ̃r pe ye ma yee: «Yãhã Yai wĩĩ ma mii ngaa puale dyaŋ, dya waa tuu gbe, ma tãhã le u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Le tãhãyale wo le kloŋ pii byɛ na. Le ma fĩy yi, le ga yir, le gboho ta tɛr tãŋ dir wãn ter byɛ na. Le ga kayay yi katyigi dyaŋ, kãnsyãm n sya ba naa pe nsɛŋ ta te kayay laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu n maha pe yar kakuãcran laa ne ma yee: «Yãhã Yai wĩĩ ma mii ncasur wãŋ ter syi dyaŋ, cɔɔ waa tuu gbe carle ya, ma wlãhã bur miy busãã wo gbengbeyĩĩ tãã syi, ma pe tũhũ. Te ncasur carle ya n ta, pe n sya fua yir.» ");
INSERT INTO xrb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu naa kaplãŋ ngĩĩ byɛ pãã pe nawee- ye kakuãcraŋ ne. U sẽ naa pãã pe ne mii kakuãcraŋ sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tuu naa n pãã ke syi, lii faale Yãhã kaplãŋ tɔ̃rfua waa bii cãã yrũhũ yaha, loo ne le nii n pye loo yale wo. U bii yee, Yãhã yee: «N ga ba naa kai- nkãy yar pe na kakuãcraŋ ne. Koo kai- ngĩĩ driyɛ̃ ke tãhã mii, waa sẽ ke cã yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Loo kur ye, Yesu n kãnde wãã pe nabuar kẽ, ma tɛr kaha wo. Pe kãnyãrwai n yũhũ crã u na, ma u nar u ke nyɛ̃pihi wĩĩ yĩntaha tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu n pe yɛ̃ wãã sya ma yee: «Wii tuu ke digi tãhã, u Nawee Puee kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te tar, driyɛ̃ kẽ too ne. Dir rii te tãhã, too ne nawee- mpãy byɛ ne pe ma Yãhã Yai wãm. Ke nyɛ̃pihi, koo kẽ nawee- mpãy byɛ ne pe ma sãndãpee yĩŋfua wãm. ");
INSERT INTO xrb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Napĩĩ wii tuu ke nyɛ̃pihi tãhã, Setane kẽ. Ke digi gbeyale, koo kẽ driyɛ̃ kuayale ne. Tẽntẽ- mpãy pe ga ba te dir gbe, poo me pe yãhãyĩŋ tẽnlɛhɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pe nyɛ̃pihi kuã n yi, ma ke miy le n wãã naa laam wo mii syi dyaŋ, ke driyɛ̃ kuayale wo, le ga ba nii koo syi. ");
INSERT INTO xrb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Ke yale wo, u Nawee Puee ga ba u yãhãyĩŋ tẽnlɛhɛ ye nɔ wãã, pe n ba nawee- tyɔ̃r. Mpãy pe pe nampyeŋ- ta pe n kapee- pye, tesẽ mpãy ne pe kapee- pye, pe yãhãyĩŋ tẽnlɛhɛ ga ba poo byɛ tyɔ̃r yi miy le wãã naa fla wo, naa gii wãfegeyãã wee ke na ye, pe n naa n wũn, pe naa nkãhã yĩhĩ. ");
INSERT INTO xrb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mpãy pe ma nasroŋ Yãhã ye, pe ga ba naa n yɛhɛ palpal, yai wãŋ syi dyaŋ, pe Tuhufua Yãhã yai klo wo. Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu n maha kaplãŋ nkãy kuã cra pãã pe ye ma yee: «Yãhã Yai wĩĩ ma mii wangbãy laa dyaŋ, le wũhũ ta tar raa laam wo, kacãn wee le wãgboho na ye. Dya waa n ga yi le wangbãy na, ma ke fla wũhũ. U laam n tãy tɛr, u n sya ka maa u koho wãn byɛ par tãŋ, ma ba te tar par, te n nii u wãn, le wangbãy bya ne. ");
INSERT INTO xrb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yãhã Yai wĩĩ maha ma mii cãtrohofua dyaŋ, tuu sãmuuyɔ̃m kɛ. ");
INSERT INTO xrb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","U n ga waa ter yãã kacãn wee u dir na ye. U n ga u koho wãn byɛ par tãŋ, ma ba woo sãmuu ter par, u n nii u wũũ.» ");
INSERT INTO xrb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu n maha yee: «Yãhã Yai wĩĩ ma mii jɔɔ wãŋ syi dyaŋ pe n miy langbãŋ wo, u n fua- ter byɛ yigi. ");
INSERT INTO xrb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","U ma yĩĩ fua- ne, pe jɔɔ miyfa ga u tyĩn yi ta langbeŋ na, pe tege nii pe pe fua- tyɔ̃r. Fua- mpãy pe yɔ̃, pe ga poo le takũhũ wo, mpãy pe sẽ yɔ̃ ye, pe ga poo miy yaha. ");
INSERT INTO xrb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Le ga ba pye koo syi dyaŋ, driyɛ̃ kuayale wo. Pe yãhãyĩŋ tẽnlɛhɛ ga ba pa, pe ba pe napee- tyɔ̃r yi kãã pe naweeyɔ̃m wo. ");
INSERT INTO xrb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pe ga pe napee- miy le wãã naa fla wo, naa gii wãfegeyãã wee ke na ye, pe n naa n wũn, pe naa nkãhã yĩhĩ.» ");
INSERT INTO xrb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu n u kãnyãrwai yey ma yee: «Ye ke kakuãcraŋ byɛ war la?» Pe n yee ãwã. ");
INSERT INTO xrb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Loo na, u n pe yar ma yee: «Mpãy pe ke Yãhã kãnde kataŋ yãr, ma maha nii Yãhã Yai wãm, poo mii pe faale wãlɛ kai- cã, ma maha Yãhã kai- cã yagaa. Poo ma mii kahafua wii dyaŋ, tuu ma faale nangbãn wãn ne, ma maha ma yagaa nangbãn wãn ne, ma nii te yar nawee- na.» ");
INSERT INTO xrb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu tuu koo kakuãcraŋ ngĩĩ pãã wa, u n yir loo klo wo, ");
INSERT INTO xrb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma tɛr klo lii wo tuu ba lɛ na. U n nii nawee- klaha, ke fla Yiifee- yawãhã nwoŋ wo. Nawee- mpãy pe pye, le n pe fe gbe, pe n nii n yee: «U yir na laantor nde ne, ke laanwɔ wũhũ ne? ");
INSERT INTO xrb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Woo sẽ na u katyir tafua dya? U nahafua sẽ na Maari ne? U cĩĩfa sẽ na Syake ne, Yosɛfe ne, Syimu ne, tesẽ Yuda ne? ");
INSERT INTO xrb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","U syafa byɛ sẽ na pe ma wo ne, wo teende wo? U -sẽ yir na, ma waha kai- ngĩĩ syi byɛ pye?» ");
INSERT INTO xrb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Loo n ta, pe sẽ waha Yesu wĩĩ sya ye. Yesu tuu yãã ke syi, u n plãhã nge tɔ̃r pe ye ma yee: «Ma yi kãã Yãhã kaplãŋ tɔ̃rfua kusey nawee- na tesẽ u kahafa ne, teebɛhɛ byɛ nawee- u yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pe sẽ Yesu ta pe Yatɛr ye, u sẽ sya ma laanwɔ wũhũ busãã pye ke fla na ye. ");
INSERT INTO xrb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Koo cãã na, Galɛlɛ kãntraha kui yĩŋfua Yɛrɔte n Yesu wĩĩ luhu. ");
INSERT INTO xrb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","U n u tẽntẽ- pye ma yee: «Nsãn nawee- tããfua kẽ. N ba ta pe n u yĩŋ cɛr. U yir gbã wo, ma dur ba gbaafa ye. Loo ne u n waha laanwɔ wũhũ pye.» ");
INSERT INTO xrb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Lii le ba dye Yɛrɔte nsoho wo Nsãn ne, le nde: Yɛrɔte ba ta pe n Nsãn yigi, ma u pua, ma u le nwompihi wo. Yɛrɔte ba loo pye u cĩĩfua Filipe cɔɔ Yɛrɔtyade wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nsãn naa Yɛrɔte yar, a u sẽ yai u u cĩĩfua cɔɔ tyĩn sya u ye u u ta u wũũ ye. ");
INSERT INTO xrb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yɛrɔte n naa Nsãn wãboo kɛ, ma -sẽ ba fya pe Yiifee- na, pe byɛ naa n yee Nsãn ma Yãhã kaplãŋ tɔ̃rfua. ");
INSERT INTO xrb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yɛrɔte seesee per gbar -sẽ na, u cɔɔ pueesya ba yɔɔ u Yɛrɔte nampay ye yĩnde na. Le ba tãy tɛr Yɛrɔte ye, ");
INSERT INTO xrb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","u n sya Yãhã di ma yee, u kicar ma ngii wĩĩ pãã, woo ga ke wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","U kicar n ga le pãã u nahafua ye, u nahafua n u yar u n dur ga Yɛrɔte pye ma yee: «Nsãn yĩŋ cɛr wãã ra kẽ nwo wo, tasa wo!» ");
INSERT INTO xrb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Le n Yɛrɔte laam wlãhã, u kapãn ba u yigi. Tuu -sẽ ba Yãhã di pe nampay yĩnde na, u n le sya. ");
INSERT INTO xrb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","U n waa lɛhɛ wãã, u n ka ke nwompihi wo ma ga u Nsãn yĩŋ cɛr. ");
INSERT INTO xrb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pe n pa ke yĩŋ ne tasa laam wo, ma ba ke wãã u capua kẽ, u n ke sya wãã u nahafua kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nsãn kãnyãrwai n pa, ma ba u nakugu gbe ma ga u tugu le. Loo kur ye, pe n ga Yesu yar ke kai- byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu tuu u Nsãn wãboo wĩĩ luhu, u n yir ma salangbãŋ gbe, ma yee woo ga ka u ya ya dragba gaa laam wo. Pe nabuar n -sẽ yi le cãŋ na. Pe n yi ke kui wo, ma yãr n taha Yesu na ke langbeŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu tuu yi ke salangbãŋ wo, u n nabuar yãã kacãn wee ye. Pe nawee- fɛn n u yigi fãnga ne, u n nii pe yanfa jaa pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yainkɔŋ wo, Yesu kãnyãrwai n yũhũ crã u tãy, ma u pye ma yee: «Yai kua kua wa, wo maha ma dragba wo. Pe nawee- ta pe n ka kusyĩmbɛhɛ wo, pe ga waha ngaa par di.» ");
INSERT INTO xrb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu n pe yɛ̃ sya ma yee: «Pe saha tɛr loo ya wĩĩ na ye; yii gɛ, -ye digi wãã pe kẽ pe n di!» ");
INSERT INTO xrb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pe n u pye ma yee: «Bur bua ya te ma wo ye nwo, ma suhu fua- syãm ne.» ");
INSERT INTO xrb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu n pe pye, pe pa te ne woo fla na. ");
INSERT INTO xrb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Loo kur ye, u n pe nabuar ta pe n tege nii ke nyɛ̃ na. U n te bur bua gbe, pe fua- syãm ne, ma yĩntaha kuã yir wãã yãhãyĩŋ kuɛ ye, ma Yãhã pye ma yee: «Ma syaha kẽ.» U n te bur la cɛr, ma te wãã u kãnyãrwai kẽ, pe n te la klaha pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pe byɛ n di, ma di yai. Pe n takũyĩhĩ sẽnsye syãŋ gbe tɛr te gbɛr ne, tii pe di yaha. ");
INSERT INTO xrb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mpãy pe ba di, pe pye nawee- nyersĩĩ yĩĩbua syi, pe ca yɛ̃ wee pe kicar ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Loo kur ye, Yesu n ta tɛr pe kãnyãrwai ta pe n dugu dye ke salangbãŋ wo, ma ga dii ga langbãŋ kũndi ngaa ye, u yahasee ye. Woo n kuee kur ye, u kãnde wãã pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tuu kãnde wãã wa pe kẽ, u n dugu yãŋ gaa yĩŋ na, ma ga nii u laam wũhũ tɔ̃r Yãhã ye u ya ya. Yĩmper n ba wɔ, ma Yesu yãã ke fla na u ya ya. ");
INSERT INTO xrb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Le yale wo, ke salangbãŋ ba dey ke kãntraha fla ne. Teflaha naa ke wãã, ke n gbe naa n gbã loho na. ");
INSERT INTO xrb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ngupa cir kuiyale wo, Yesu n nii yãr n gaha ke langbãŋ loho na, u kãnyãrwai kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pe kãnyãrwai pe u yãã tuu n yãr ke loho na, pe n sroŋ fya ma yee kusrãhã kẽ, ma too kule na ma n kui. ");
INSERT INTO xrb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu n ta tɛr pãã pe ne ma yee: «-Ye ye laam waha, ye ma syi fya ye, ndoo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Loo na, Pyar n yɛ̃ kuã ma Yesu pye ma yee: «Yĩŋfua, le ma pye mboo, ra ta ra n waha yãr ga ke loho yĩŋ na ma fla na!» ");
INSERT INTO xrb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu n u pye u pa. Pyar n yi ke salangbãŋ wo, ma yãr n gaha ke loho yĩŋ na Yesu fla na. ");
INSERT INTO xrb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tuu yãã teflahangbãŋ ma, u n fya, ma -sẽ yãã u sẽ waha tãhã yɛr ke loho yĩŋ na ye, ma nii n tege ke wo. U n tẽ sya ma yee: «Yĩŋfua, ta sya yaha!» ");
INSERT INTO xrb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu n ta tɛr koho nɔ wãã ma u yigi, ma u pye ma yee: «Ma Yatɛr kloŋ tɛr la ma ye? Nwa ma n ba fya?» ");
INSERT INTO xrb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pe n dugu dye ke salangbãŋ wo, pe syãm, ke teflaha n yɛr. ");
INSERT INTO xrb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pe kãnyãrwai mpãy pe pye ke salangbãŋ wo, pe n kãnklũy gbãã Yesu yaha ye ma yee: «Yãhã Dya kẽ ma ne cĩĩnde!» ");
INSERT INTO xrb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu n ba ke langbãŋ dii wa u kãnyãrwai ne, pe n tãhã Genesarɛ kuɛ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Koo flafa n Yesu yãŋ cã, ma u wãpa wĩĩ pãã pe kuɛfa byɛ ye. Pe n yanfa byɛ gbe ba u fla na. ");
INSERT INTO xrb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pe n nii u nar u tyii pe yanfa n tɛ u nayrengbãŋ yɛ̃ ya na. Mpãy byɛ pe -sẽ yãã naa n tɛ ke na, pe naa n jaa. ");
INSERT INTO xrb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Per gaa, Farisyɛ̃ mpãy tesẽ Yãhã kaiyarfa mpãy ne, pe ba yir Yurusalɛm wo, ma pa Yesu fla na, ma ba u yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Nwa ta ma kãnyãrwai sẽ wo wãlɛ kãnde yãr ye? Ma sẽ yãã, pe sẽ pe kluɛ yee wo wãlɛ kãnde wãyee na ma cã pe dir di ye.» ");
INSERT INTO xrb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu n pe yɛ̃ sya ma yee: «Ah yii, nwa ta ye n nii Yãhã kãnde wũhũ miy n yaha, ma nii ye wãlɛ kãnde wũhũ pye? ");
INSERT INTO xrb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ye sẽ yãã, Yãhã yee: ‹Ma ma tuhufua gboho, ma nahafua ne,› tesẽ ‹Wii ma u tuhufua miipihi yee u nahafua ne, u yai pe u boo kãã.› ");
INSERT INTO xrb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yii -sẽ nawee- klaha, a nawee ga waha u tuhufua pye u nahafua ne, u yee: ‹Ta koho kla gii tẽ ne ga waha wãã ma kẽ ma n di, n ke ta yaha Yãhã kẽ.› Loo na, u sẽ maha yai u u seefa gboho ye. ");
INSERT INTO xrb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ye n pye koo syi, ma Yãhã kaklaha miy n yaha, ma ye wãlɛ kaklaha wũhũ pye. ");
INSERT INTO xrb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dawarfa me ye ne! Faale Yãhã kaplãŋ tɔ̃rfua Yisa tãhã kẽ tuu bii nde cãã yar yaha ye wĩĩ na, ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee, Yãhã yee: ");
INSERT INTO xrb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Nawee- mii, pe ra gboho pe yɛ̃ kaplãŋ ya ne, ma -sẽ yee pe laam wo pe fla dey tɛr ra ne. ");
INSERT INTO xrb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pe ra gboho mii syi dyaŋ, yĩŋ wee le na ye. Nawee- pe kãnde lii ta, pe tee loo ta, ma n klaha ma yee Yãhã kãnde ne.› » ");
INSERT INTO xrb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Loo kur ye, Yesu n pe nabuar yee ba, ma ba pe pye ma yee: «-Ye kaplãŋ ngĩĩ luhu yɔ̃, -tee ke yĩntar war: ");
INSERT INTO xrb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngii ke n dye nawee yɛ̃ wo, ke sẽ u le kapee- wãpyeŋ wo ye. Ngii ke n yi u yɛ̃ wo, koo kẽ ke u le kapee- wãpyeŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesu kãnyãrwai n yũhũ crã u na, ma u pye ma yee: «Yãŋ, taa nde pãã, le pe Farisyɛ̃ laam war.» ");
INSERT INTO xrb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","U n pe yɛ̃ wãã sya kakuãcraŋ ne ma yee: «Ngii ke wee ta Tuhufua Yãhã wãŋ ye, ke ma mii katyigi gii dyaŋ ke sẽ ke tãhã ye, ma n pai ke kuã kãã. ");
INSERT INTO xrb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ye tyii pe Farisyɛ̃ na! Pe ma mii fũũ- dyaŋ, pe pe fũũwai yigi, pe n yãr n taha pe na kãnde wo. Fũũ ma u fũũwai yigi, u n yãr n taha u na kãnde wo, pe syãm byɛ n gaha too dye wuhu wo.» ");
INSERT INTO xrb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pyar n yee u le kakuãcran yĩntaha yar poo na, kakuãcran nde le nawee wãle wĩĩ pãã kapee- wãpyeŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu n yee: «Ye bya, ye maha le kakuãcran yĩntaha war gblihi laa kɛ? ");
INSERT INTO xrb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ye sẽ le war la ma yee, ngii ke n dye nawee yɛ̃ wo, ke n gaha u nfẽŋ wo, ke ga yi kãã u laha wo nyɛ̃ wo? ");
INSERT INTO xrb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngii ke -sẽ n yi nawee yɛ̃ wo, ke n yir u laam wo. Koo ke nawee le kapee- wãpyeŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ye sẽ yãã, nawee tuu kapee- nkãy ga u laam wo, koo ke ne u taha naboor na, cayɔr wãleŋ ne, tyatyãhã ne, yuhur ne, kawar wãfua ne, tesẽ wãplaŋpãã ne. ");
INSERT INTO xrb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Koo kai- ngĩĩ kẽ ke nawee le kapee- wãpyeŋ wo. Ma -sẽ yee, maʼa yee ma sẽ ma kluɛ yee wo wãlɛ kãnde wãyee na ma cã ma dir di ye, loo nde sẽ nawee le kapee- wãpyeŋ wo ye.» ");
INSERT INTO xrb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Loo kur ye, Yesu n yir ke fla na, ma ka Tyir tãy, Syidɔ̃ ne. ");
INSERT INTO xrb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanaafasya waa pye, tuu ba nii ke fla na. Kanaafa sẽ pye Yiifee- ye. U n pa Yesu tãy, ma ba tẽ sya ma yee: «Dawide Dya, ta fɛn di! Sãndũpee ma ra pueesya yĩŋ na, ma nii u fãy, u kã n yaa!» ");
INSERT INTO xrb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu sẽ -sẽ u yɛ̃ gɛ sya laa ne ye. U kãnyãrwai n yũhũ crã u tãy, ma u nar ma yee u u cɔɔ ta u n tɛr, u tee ma u kui n taha poo na. ");
INSERT INTO xrb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu n pe yɛ̃ sya ma yee: «Yiisrɛfa mpãy pe ma mii mbaa dyaŋ mbanaha wee pe na ye, pe ra lɛhɛ wãã poo ya wĩĩ na.» ");
INSERT INTO xrb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","U cɔɔ n ke kaplãŋ luhu, ma sye ma ba kãnklũy gbãã Yesu yahasee ye, ma u nar ma yee: «Yĩŋfua, ta kuɛ yãŋ!» ");
INSERT INTO xrb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu n u yɛ̃ sya ma yee: «Maʼa kicar digi gbe miy yaha pãmpii kẽ, le sẽ yɔ̃ ye.» ");
INSERT INTO xrb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","U cɔɔ n yee: «Cĩĩnde ne, Yĩŋfua. Pãmfa ma -sẽ tii bir miy yaha te n too kãntraha na, pãmpii sẽ -sẽ ga gbe di la?» ");
INSERT INTO xrb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Loo na, Yesu n u yɛ̃ sya ma yee: «Cɔɔ nwo, ma ra sroŋ ta ma Yatɛr cĩĩnde! Taa lii kɛ, le ga pye ma kẽ.» Le yalebya wo, u sãndũpee n tege kãã u pueesya yĩŋ na, u n jaa. ");
INSERT INTO xrb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu n yir ke fla na, ma ka Galɛlɛ langbãŋ yɛ̃ na. U n ga dugu nii yãŋ gaa yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nabuar raa n tãnklahafa gbe ba u fla na, fũũ- ne, tesẽ bebe ne, mpãy ne pe kadye teelaa fla ku pe ye, ma suhu yanfa busãã mpãy ter ne. Pe n ba pe tege ta Yesu tãy, u n pe jaa. ");
INSERT INTO xrb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pe nawee- n pe bebe yãã pe n pãã; mpãy pe kadye teelaa fla ku pe ye, pe n pe yãã pe jaa, ma pe tãnklahafa yãã pe yrãhã sroŋ, ma pe fũũ- yãã pe n yãŋ. Le n yɛ̃ gbãã pe nawee- byɛ na ma sya ga ta tɛr, pe n nii Yãhã sey, koo gii ke ma Yiisrɛfa Yãhã. ");
INSERT INTO xrb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Loo kur ye, Yesu n u kãnyãrwai yee ba, maa pe pye ma yee: «Nawee- mii fɛn ra yigi, pe plii tãã nanga pe ma ra ne. Yagaa, ngaa wee pe ye nantãŋ pe n ga di ye. N sẽ n traha n kãnde wãã pe kẽ pe n tɛr, mii pe sẽ ngaa yãã di ye. Mii loo sẽ ne ye, pe n gaha too wãfãy na kãnde wo.» ");
INSERT INTO xrb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pe kãnyãrwai n u yey ma yee: «Dragba nge syi laam wo, waa dir yãã na wo wãã nabuar mii syi kẽ pe n di?» ");
INSERT INTO xrb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu n pe yey ma yee, bur nii te ma pe ye. Pe n yee, wãy kuasĩĩ tesẽ fuabir raa ne. ");
INSERT INTO xrb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Loo na, Yesu n pe nabuar ta pe n tege nii kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","U n te bur kuasĩĩ gbe pe fuabir ne, ma Yãhã pye ma yee: «Ma syaha kẽ». U n te bur la cɛr, ma te wãã u kãnyãrwai kẽ, pe n te la klaha pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pe byɛ n di, ma sya di yai. Tii pe di yaha, pe n te gbe tɛr takũyĩhĩ kuasĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mpãy pe ba di, pe pye nawee- nyersĩĩ, pe ca yɛ̃ wee pe kicar ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Loo na, Yesu n kãnde wãã pe nabuar kẽ, ma dugu dye salangbãŋ wo, ma ka Magadã kuɛ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Loo kur ye, pe Farisyɛ̃ tesẽ pe Sadusyɛ̃ ne, pe n pa Yesu fla na. Pe n yee, poo ga u le namihi wo ma u pye, u laanwɔ wĩĩ laa pye poo n yãã, pe waha cã Yãhã kẽ ke kãnde wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu n -sẽ pe yɛ̃ sya ma yee: «Yaintege na, yãhãyĩŋ ma yrãhã, ye ne yee sukũhũ yai ga yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yũhũ yɛ̃ na, ye ma yãhãyĩŋ yãã ke yrãhã car ma maha wɔ, ye ga yee sesaha ga too nanga. Ye yãhãyĩŋ wũhũ yĩntaha war, ma -sẽ gblihi laa, Yãhã wũhũ nkãy ke n pye ye yĩnde na yagaa, ye sẽ ke war ye. ");
INSERT INTO xrb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yagaafa pee, pe sẽ n sroŋ Yãhã ye ye, ma maha yee, poo n kɛ pe laanwɔ wĩĩ laa yãã yĩnde ne! N sẽ -sẽ ga laanwɔ wĩĩ laa pye yar pe na ye. Lii le bii faale Yonase dye, loo syi ter ya kẽ, pe ga ba yãã yĩnde ne.» Loo kur ye, u n tɛr pe yaha ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pe kãnyãrwai pe ba dii ga ke langbãŋ kũndi ngaa ye, pe ba faha bur yaha. ");
INSERT INTO xrb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu n pe pye ma yee: «-Ye yii le yaha, -tee yii yigi Farisyɛ̃ ye ne tesẽ Sadusyɛ̃ ye ne; pe wĩĩ ma mii ncasur wãŋ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pe kãnyãrwai n nii pe ya yey ma yee: «Too sẽ bur gbe ye, loo la u n nii n pãã ke syi?» ");
INSERT INTO xrb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu n pe laam wũhũ cã, u n pe yey ma yee: «Nwa ye n yee, tee sẽ bur gbe ye, loo la n n pãã ke syi? Ye sẽ ra sroŋ ta ye Yatɛr ye! ");
INSERT INTO xrb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ye sẽ laa war wa ye. Tẽ ba bur bua la cɛr wãã nawee- nyersĩĩ yĩĩbua kẽ, ye ba te gbɛr wãã gbe tɛr takũyĩhĩ nii, le faha la ye na? ");
INSERT INTO xrb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tẽ maha ba te bur kuasĩĩ la cɛr pe nawee- nyersĩĩ kẽ, ye ba te gbɛr wãã gbe tɛr takũyĩhĩ nii, le faha la ye na? ");
INSERT INTO xrb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yaliile wo, tẽ ye pye ye yii yigi Farisyɛ̃ ye ncasur wãŋ ter syi ne, Sadusyɛ̃ ye ne, n sẽ naa n pãã bur wĩĩ na ye. Nwa ta ye sẽ waha le war ye?» ");
INSERT INTO xrb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Loo na, pe kãnyãrwai n cã le war ma yee ncasur wãŋ gii ke n le bur wo, koo sẽ kẽ Yesu naa n yãŋ ye. Farisyɛ̃ wĩĩ ne u naa n yãŋ, Sadusyɛ̃ wĩĩ ne, ma yee pe pe ya yigi le ne. ");
INSERT INTO xrb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu n ka u kãnyãrwai ne Filipe Syesarɛ klo kuɛ ye. U n ba pe yey ma yee: «Lii gɛ nawee- pe n pãã ndoo u Nawee Puee wĩĩ na?» ");
INSERT INTO xrb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pe n u yɛ̃ sya ma yee: «Mpãy n yee, a Nsãn nawee- tããfua kẽ ma ne. Mpãy maha n yee, a Yeli kẽ ma ne. Mpãy maha ma pe n yee, a le ma pye mboo sẽ kẽ faale Yermii ye, ma -sẽ ma poo faale Yãhã kaplãŋ tɔ̃rfa nen waa.» ");
INSERT INTO xrb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu n pe yey ma yee: «Ah yii, ye yee yoo kẽ ra ne?» ");
INSERT INTO xrb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Syimu wii pe n yee Pyar, u n u yɛ̃ sya ma yee: «Mboo kẽ u Yãhã Yĩndefua Crise, ma maha ma ke Dya, koo gii wãkuyãã wee ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Loo na, Yesu n u pye ma yee: «Nsãn dya Syimu, ma wĩĩ n tãy. Ma sẽ yãã, nawee sẽ kẽ tuu koo kai- ngĩĩ yar ma na ye. Ta Tuhufua Yãhã kẽ, ke ke yar ma na. ");
INSERT INTO xrb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ndoo -sẽ ga ma yar nde ne: Mboo, ma ma Pyar, ke yĩntaha kẽ ntẽmblaha. Ma ma mii ntẽmblaha dyaŋ, pe ga waha nwoŋ fãã ke yĩŋ na. Loo ne, mboo taa ga ba ta wĩĩ cãã gbe yi, ma naa le tɔ̃r mpãy ye pe sẽ ra kãnde cã ye. Gbãfua fãnga gɛ sẽ n pai waha yia ra kãndeyãrfa yawãhã na ye. ");
INSERT INTO xrb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Fãnga gii tẽ ga wãã ma kẽ mpãy nsoho wo pe cã Yãhã ma yĩŋ na, koo fãnga ma mii karndohopii dyaŋ, pe ga waha nwonyɛ̃ yãr, pe maha waha ke tã. Maʼa ba kai- nkãy sye driyɛ̃ nge wo, Yãhã kẽ ke ma ta, ma n ke sye. Maʼa maha ba kai- nkãy sya driyɛ̃ nge wo, Yãhã kẽ ke ma ta, ma n ke sya.» ");
INSERT INTO xrb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu n u kãnyãrwai yar waha, pe ma n le pãã waa ye pe yee woo kẽ u Yãhã Yĩndefua Crise ye. ");
INSERT INTO xrb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Loo kur ye, Yesu n nii ke kai- pãã u kãnyãrwai ye gbaa na. U naa pe yar ma yee: «N yai n ka Yurusalɛm wo. Koo fla na, pe Yiifee- wãlɛ, pe Yãhã yũndefa yĩŋfa ne, pe Yãhã kaiyarfa ne, pe ga ba ra fãy gboho. Pe ga ba ta gɛ ta pe n ta boo. Ta wãku plii tãã wuhu na, n ga yir gbã wo, n dur ba yrãŋ na gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pyar n u yee ga kãnkãy na, maa nii le kuãn u ye ma yee: «Yĩŋfua, Yãhã ke paha ma na! Nde sẽ yai le ma dye ye!» ");
INSERT INTO xrb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu n wã klaha, ma Pyar pye ma yee: «Yũhũ kãã ra tãy Setane nwo! Ma n kɛ ma yɛr tã ra na ta kãnkai- wo! Ma sẽ laam ga Yãhã laantor ter ne ye, ma laam ga nawee- kacãn ter ya ne.» ");
INSERT INTO xrb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu n u kãnyãrwai pye ma yee: «Wii ma yee woo ga naa n yãr ta kãnde wo, u u laam wũhũ ta yaha, tuu u ya gbihi, u ma sya ga ba gbãpee ku ra wĩĩ na. Wii ma loo sya, u naa ra kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ye sẽ yãã, wii tuu u ya yĩŋ kɛ, ma suhu u laam wãn ne, woofua ga ba too byɛ kɛ laa; wii tuu -sẽ ga le sya u u yĩŋ kɛ laa, ma suhu u laam wãn ne ndoo wĩĩ na, woofua kẽ tuu cã ga ba too nde byɛ yãã. ");
INSERT INTO xrb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mboo nawee, taa ga driyɛ̃ wãn byɛ yãã tãŋ, maʼa yee ma sẽ ba ma yĩŋ yãã Yãhã ye ye, le wãyĩĩ -sẽ ma na taa yãã? Tesẽ, koo kla ma na, nawee tuu ga ba waha kẽ, u u ya yĩŋ yãã Yãhã tãy? ");
INSERT INTO xrb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ye sẽ yãã, u Nawee Puee ga ba pa u Tuhufua Yãhã nayɔ̃r ne, tesẽ u yãhãyĩŋ tẽnlɛhɛ ye ne. U ma ba dur ba, nawee nawee woo tuu kai- nkãy byɛ pye tɛr, u ga koo byɛ draha dãã ufua kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta n cĩĩnde nde pãã ye ye: Nawee- mpãy ma ye laam wo, pe saa ku mii pe sẽ u Nawee Puee yãã tuu nii yĩŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Plii kuay kur ye, Yesu n Pyar yigi taha u ya na, Syake ne, u Syake cĩĩfua Nsãn ne, ma ka pe ne yãnjruhu gaa yĩŋ na, poo pe ya ya. ");
INSERT INTO xrb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pe n u yãã, u wã klaha pe yĩnde na, u yĩntaha n nii n yɛhɛ yai wãŋ syi dyaŋ, u nayrɛ n flege ma nii cãã- wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pe kãnyãrwai n faale wãlɛ Musa yãã tesẽ Yeli ne, pe ya kai na. Pe ba fe gbe yi, ma nii n pãã Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Loo na, Pyar n Yesu pye ma yee: «Wo Yĩŋfua, wo niisaha sroŋ yɔ̃ nwo wo. Le ma tãy ma ye, n ga kajar tãã gbã, neŋ ma wãŋ, neŋ Musa wãŋ, neŋ nge Yeli wãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tuu naa n pãã nantãŋ, yãhãsyɔ̃r raa n ba paha pe na, ma n yɛhɛ palpal. Yãhã yĩmbui n yir te yãhãsyɔ̃r laam wo ma yee: «Ta Dya kẽ nwo, u ntãŋ dye gboho ra tãy, u ra laam yĩn yalebyɛ. -Ye naa n luhu u ye!» ");
INSERT INTO xrb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pe kãnyãrwai pe kaplãŋ ngĩĩ luhu, pe n fya ma too tã pe yĩntar na. ");
INSERT INTO xrb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu n yũhũ crã pe na, ma pe pye pe yir, pe ma n fya ye. ");
INSERT INTO xrb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe n yĩntar kuã yir, pe sẽ maha waa yãã mii Yesu ya sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pe naa ke yãŋ tege, Yesu n pe yar waha ma yee: «Tee kai- nkãy yãã ke yãŋ yĩŋ na, ye ma n ke tɔ̃r waa ye ye, mii u Nawee Puee sẽ yir gbã wo, ma dur ba gbaafa ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pe kãnyãrwai n Yesu yey ma yee: «Nwa ta pe Yãhã kaiyarfa n yee, a Yeli ga cãã pa u Yãhã Yĩndefua Crise yaha?» ");
INSERT INTO xrb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu n pe yɛ̃ sya ma yee: «Cĩĩnde ne, Yeli yai u pa, u ba ke kai- byɛ gbihi ta. ");
INSERT INTO xrb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta n ye yar: Yeli pa wa, nawee- sẽ cã woo kẽ ye, ma u nuhu pe laam wãnuhu. Pe ga ba u Nawee Puee bya nuhu koo syi.» ");
INSERT INTO xrb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Loo na, pe kãnyãrwai n cã le war ma yee, Nsãn nawee- tããfua wĩĩ kẽ Yesu tuu pãã pe ye, ma Yeli myaha yee. ");
INSERT INTO xrb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pe ga nɔ nabuar raa fla na, dya waa n pa Yesu fla na, ma ba kãnklũy gbãã u yahasee ye ");
INSERT INTO xrb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma yee: «Yĩŋfua, ta dya fɛn di, wãtooku ma u na. Ke ma yir u na, ke ne pee u na. Kaa na u ga too dye naa woo, kaa na u ga too dye loho wo. ");
INSERT INTO xrb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N pa u ne ma kãnyãrwai fla na, pe sẽ -sẽ waha u jaa ye.» ");
INSERT INTO xrb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu n kuãn pe na ma yee: «Yii poo na, laanyɔ̃m wee ye ye ye, ye sẽ ra ta ye Yatɛr ye. Ye yee la n kuee ye wãwlaha na yalebyɛ? Ye yee la n naa n fãy ye ne yalebyɛ? -Ye pa ra kẽ u kicar ne nwo!» ");
INSERT INTO xrb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu n sã u sãndũpee na, u n tege kãã u kicar yĩŋ na, u n jaa le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Loo na, pe kãnyãrwai n yũhũ crã Yesu na kãnkãy na, ma u yey ma yee: «Nwa wo sẽ ba waha u sãndũpee kar tege kãã ye?» ");
INSERT INTO xrb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu n pe yar ma yee: «Ye sẽ ra ta ye Yatɛr ye laam byɛ ne ye, koo kẽ. Ta n cĩĩnde nde pãã ye ye: Ye ma Yãhã ta ye Yatɛr carle ya mii ntããfĩĩ pua nen ya dyaŋ, ye ga waha yãŋ nge pye ke yũhũ ga nwaa, ke n yũhũ ga. Kai laa saa ye yia ye.  ");
INSERT INTO xrb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yaʼa ye yɛ̃ tã digi na, ma nii Yãhã nar, loo na, ye ga waha sãndũpee nwo syi kar tege nawee yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu pye yrãhã na u kãnyãrwai ne Galɛlɛ kãntraha wo, u n ba pe pye ma yee: «Pe ga ba u Nawee Puee yi u napĩĩ- kẽ, ");
INSERT INTO xrb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","pe n u boo; u gbã plii tãã wuhu, u ga yir gbã wo, u pa gbaafa ye.» Loo kapãn nde n pe kãnyãrwai laam wlãhã pe kẽ, ma sya ga ta tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu tuu ga dye Kapornu wo u kãnyãrwai ne, Yãhã kangbãŋ kufar wããfa n yũhũ crã Syimu Pyar tãy, ma u yey ma yee: «Ye Yĩŋfua sẽ Yãhã kangbãŋ kufar dãã la?» ");
INSERT INTO xrb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pyar n pe pye ãwã, u pe dãã. Pyar tuu ga dye kaha wo, Yesu n cãã kapãn gbe, ma u pye ma yee: «Syimu, ma laam wo, mpãy poo pe yai pe naa pe kufar dãã, tesẽ pe koho wãn kufar ne kãntraha nge yĩŋfa kẽ, pe klofa laa, pe nampay?» ");
INSERT INTO xrb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pyar n yee pe nampay. Yesu n u pye ma yee: «Le ma pye pe nampay, ma cã klofa sẽ yai pe naa te dãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wo sẽ -sẽ n kɛ nawee- mii n wãpee pãã wo wĩĩ na ye. Loo ne, ka ke langbãŋ wo, maa fuɛsãn miy. Fua wii taa ga cãã yigi, u yɛ̃ yãr, maa ntẽn war yãã u laam wo. U war gbe, maa ra kufar dãã, tesẽ ma wãn ne!» ");
INSERT INTO xrb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Loo yale wo, Yesu kãnyãrwai n yũhũ crã u na, ma u yey ma yee: «Yoo syi u ma yĩŋ na Yãhã Yai wo?» ");
INSERT INTO xrb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Loo na, Yesu n kicaalaale yee ba ta pe yaha ye, ma pe yar ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Ta n cĩĩnde nde pãã ye ye: Ye ma yee ye sẽ koho klaha ma nii kicar wãŋ syi dyaŋ ye, ye saa dye Yãhã Yai wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wii ma u ya ta pra kicaale nde wãŋ syi dyaŋ, woo kẽ u ga ba yĩŋ yãã nawee- byɛ laam wo, Yãhã Yai wo. ");
INSERT INTO xrb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wii ma kicaale nde syi gbihi yigi ndoo myaha na, ndoo gɛ kẽ tuu gbihi yigi.» ");
INSERT INTO xrb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesu n maha yee: «Mpãy pe ma pra kicar wãŋ syi, ma ra ta pe Yatɛr, wii ma poo nen waa ta u n yi kãã ra kãnde wo, le ga pee woofua na. Pe ma sya cãã ntẽmbangbãŋ pua u yĩntyigi na, ma u gbe miy le wãã langbãŋ wo u sẽ yãã loo kapee nde yãã pye ye, ke puar u na. ");
INSERT INTO xrb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","-Ye yãŋ, driyɛ̃ laam wo, kapee- wãpyeŋ syar. Kapee- wãpyeŋ saha kua yãã ye. Wii ma -sẽ u nampyeŋ ta u n kapee- pye, woofua wĩĩ pee! ");
INSERT INTO xrb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Le ma pye ma koho ke ma le kapee- wãpyeŋ wo, laa na ma troho ke ma le kapee- wãpyeŋ wo, te cɛr kãã, ma te miy wãã dey dey. Ma cĩĩnde yrã yãã koho neŋ ne, tesẽ troho neŋ ne, ke puar ma kuee ma kluɛ sĩĩ ne, tesẽ ma trɛ sĩĩ ne, pe n ba ma miy le wãã naa fla wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Le ma pye ma yĩnde le ma le kapee- wãpyeŋ wo, le loho yi, ma le miy wãã dey dey. Ma cĩĩnde yrã yãã yĩnde nen ne, koo puar ma kuee ma yĩmpɛ syãŋ ne, pe n ba ma miy le wãã naa fla wo, naa gii wãfegeyãã wee ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesu n maha yee: «-Ye yii yigi, kicar mii nanem byɛ ne, ye ma syi ye naa pe yãŋ ye yee pe wee ngaa ye! Ta n ye yar: Pe kicar yãhãyĩŋ tẽnlɛhɛ n pai ta Tuhufua Yãhã tãy yalebyɛ.  ");
INSERT INTO xrb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mpãy pe plaha, u Nawee Puee pa pe wãsyayaha yĩmbui ne. ");
INSERT INTO xrb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","-Ye yãŋ, wii ma pye mbaa gbeebua ne, nen n plaha u ye, u ga pye mii? Ye cã ma yee, u ga pe mbaa gbeeresyar sẽnsye kuaresyar mii ta yaha disaha wo, yãŋ yĩŋ na, u ga u nen nwo kɛ, nen wii tuu plaha. ");
INSERT INTO xrb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta n ye yar: U ma woo mbua yãã, u ga nuhu di woo nen ya wĩĩ na, u ta tɛr pe mbaa gbeeresyar sẽnsye kuaresyar mii wĩĩ yaha. ");
INSERT INTO xrb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ye Tuhufua Yãhã ma koo syi dyaŋ. Ke sẽ n yãŋ pe kicar mii nen waa gɛ n plaha ye.» ");
INSERT INTO xrb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu n maha yee: «Ma nampyeŋ ma laa tee pye ma na, ka mii ya u fla na; tuu lii tee pye, le yar u na. U ma luhu ma ye, ma ta u n dur ba kãnyĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","U ma -sẽ sye, u saa luhu ma ye ye, ta kãndeyãrfa nawee nen waa yigi taha mii na, kaa na nawee- syãm syi, ye n ka u fla na. Le ma le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, kai yai le gbihi ta nawee- syãm yĩnde na, laa na nawee- tãã syi. ");
INSERT INTO xrb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","U ma sye, u saa luhu pe ye ye, ka maa le pãã ta kãndeyãrfa yawãhãfa ye, ye fla wo. U ma maha sye, u saa luhu pe ye ye, naa u yãŋ nawee wii syi draha wo, u sẽ cĩĩnde Yãhã cã ye. Tesẽ, naa u yãŋ kufar wããfa ne wãcɛŋ, poo mpãy pe fufor di. ");
INSERT INTO xrb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ta n cĩĩnde nde pãã ye ye: Ye ma kai lii sye nawee- ye driyɛ̃ nge wo, Yãhã kẽ ke ye ta ye n le sye. Ye ma kai lii sya nawee- ye driyɛ̃ nge wo, Yãhã kẽ ke ye ta ye n le sya. ");
INSERT INTO xrb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ta n maha ye yar: Yii mpãy tee ma kãntraha na, ma Yãhã kãnde yãr, yii nawee- syãm syi ma yĩmbuhu wãã le, ma ngii ngii nar ra Tuhufua Yãhã ye, u ga le pye pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ye sẽ yãã, teelii teelii nawee- syãm ma pe ya wãã ta myaha na, laa na nawee- tãã syi, n ma pe telai wo.» ");
INSERT INTO xrb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loo na, Pyar n yũhũ crã Yesu na, ma u yey ma yee: «Yĩŋfua, ta nampyeŋ ma kuee kapee- pye ra na yalebyɛ, n yai n tyii u kapee- foho na tɛhɛ nii? Tɛhɛ kuasĩĩ syi yai la?» ");
INSERT INTO xrb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu n u yɛ̃ sya ma yee: «Aye, tɛhɛ kuasĩĩ sẽ yai ye; naa n tyii u kapee- foho na ma kuãŋ ne yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yesu n maha yee: «Kapee- foho wãtyii wĩĩ Yãhã Yai wo, le ma mii nde dyaŋ: Yĩŋfua waa ba yir, ma yee woo ga yãŋ u foho ma pye u tẽntẽ- mpãy na, pe ke dãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","U n nii ke foho tɔ̃r, pe n ga u tẽntẽ waa yigi ba u fla na. Fuɛ lii le pye woo yĩŋ na, le pye war nagbeebua raa. ");
INSERT INTO xrb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngaa gɛ sẽ pye u dya ye u n ga le fuɛ dãã u yĩŋfua kẽ ye. U yĩŋfua n yee, pe u dya yigi ga par yãmpuai wãŋ syi dyaŋ, woo tesẽ u cɔɔ ne, tesẽ u pii ne, tesẽ u koho wãn byɛ ne. Loo na, fuɛ lii le ma u dya yĩŋ na, pe war ga yãã. ");
INSERT INTO xrb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","U tẽntẽ n kãnklũy gbãã u yĩŋfua yahasee ye, ma u nar waha ma yee: ‹Ma laam yĩn, ma ra sẽŋ, n ga ba pe war byɛ dãã ma kẽ.› ");
INSERT INTO xrb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","U yĩŋfua n u fɛn di, ma kace yaha u na, ma sya yee u tyii le fuɛ wãdãã na, ma kãnde wãã u kẽ u n tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Woo tẽntẽ n yi ke fla na, ma u tẽntẽwɛ waa wãã sya. U fuɛ -sẽ pye u tẽntẽwɛ nwo na, war naha syi. U n u fyãhã yigi yĩmbui na, u saha wũũ gɛ wũũ ye, ma nii u pye ma yee: ‹Ta fuɛ ma ma na, pe war dãã ra kẽ!› ");
INSERT INTO xrb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","U tẽntẽwɛ n kãnklũy gbãã u yahasee ye, ma u nar waha ma yee: ‹Ma laam yĩn, ma ra sẽŋ, n ga ba pe war byɛ dãã ma kẽ.› ");
INSERT INTO xrb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","U sẽ yɛr le na ye, ma sya ta pe n u le nwompihi wo ma yee, le fuɛ le dãã u n cã yi. ");
INSERT INTO xrb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tẽntẽ- mpãy pe pye ke fla na, pe loo nde yãã, le n pe laam war, pe n ga ke kai- byɛ tɔ̃r pe yĩŋfua ye. ");
INSERT INTO xrb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","U yĩŋfua n -sẽ u tẽntẽ yee ba, ma ba u pye ma yee: ‹Tẽntẽ napee nwo! Taa ra nar, n ma fuɛ gbe kãã ma yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tẽ ma fɛn di mii, ma bya sẽ ne yai la ma ma nampyeŋ fɛn di koo syi?› ");
INSERT INTO xrb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ncafũhũ n u yĩŋfua yigi. U n ta pe n u tẽntẽ tã nwompihi wo, ma yee pe u pẽn, ma maha yee, le fuɛ le dãã tãŋ u n cã yi.» ");
INSERT INTO xrb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu n maha yee: «Ye ma yee ye sẽ n tyii ye nampyeŋ- kapee- foho na ye kuãŋ ne ye, ta Tuhufua Yãhã bya ga ba ye pye mii tẽntẽ napee nwo wãŋ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu tuu nawee- klaha wa, u n yir Galɛlɛ kãntraha na, ma ka Yudɛ kãntraha kuɛ gii ye ke ma Yurdane lafeŋ kũndi ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nabuar naa n taha u na, u n pe yanfa jaa. ");
INSERT INTO xrb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisyɛ̃ mpãy n yũhũ crã u na, ma yee poo ga u le namihi wo, ma u yey ma yee: «Wo kãnde na, nawee ga waha u cɔɔ sye la, laa ma dye pe nsoho wo u cɔɔ ne?» ");
INSERT INTO xrb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu n pe yɛ̃ sya ma yee: «Ye cã le ma le yrũhũ yaha Yãhã sabangbãŋ wo ma yee: ‹Ke kai- fegbecãã na Yãhã nawee- tãhã, naa tesẽ cɔɔ ne.› ");
INSERT INTO xrb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yãhã n le pãã pe wĩĩ na ma yee: ‹Koo syi kẽ, naa ricar koho ma ba dye, u n cɔɔ sya, u ga u ya yɛ̃ yi kãã u seefa tãy, u ke wãã le u cɔɔ wãŋ ne, pe n nii nawee nen dyaŋ.› » ");
INSERT INTO xrb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yesu n pe yar taha ma yee: «Loo na, pe wee syãm nantãŋ ye, pe ma mii nawee nen ya dyaŋ. Yãhã ke tii gbra te ya na, nawee ma syi u te cããŋ te ya na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pe Farisyɛ̃ n u yey ma yee: «Ah wo faale wãdyaha Musa sẽ bii yee la, naa ga waha u cɔɔ wãsyeŋ saba wãã u kẽ, tuu u sye?» ");
INSERT INTO xrb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu n pe yɛ̃ sya ma yee: «Ye laam waha tɛr, koo kẽ Musa n bii kãnde wãã ye kẽ, tee ga waha ye ca sye. Ma -sẽ yee ke kai- fegbecãã na, le sẽ pye koo syi ye. ");
INSERT INTO xrb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta n ye yar: Wii cɔɔ ma yee u sẽ naa waa yuhu di ye, u n u sye ma cɔɔ waa gbe, ufua kapee pye, u cayɔr pye.» ");
INSERT INTO xrb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","U kãnyãrwai n u pye ma yee: «Naa wĩĩ ma pye koo syi u cɔɔ kuɛ ye, le puar waa ma n cɔɔ sya ye.» ");
INSERT INTO xrb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu n pe yɛ̃ sya ma yee: «Nawee- byɛ sẽ me pe ga waha yia pe tyii cɔɔ wãsyaŋ na, pe naa loo kãnde yãr ye. Mpãy, Yãhã loo fãnga wãã pe kẽ, poo ya pe ga waha yia, pe naa loo kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kai- busãã ma, ke ga waha naa ta u saa cɔɔ sya ye; ca mpãy bya ma ke syi. Mpãy ma pe see ke dyaŋ, pe saha cɔɔ wĩĩ yɔ̃ ye; ca mpãy bya ma ke syi. Mpãy ma pe poo sã, ma pe ta ke syi, pe saha cɔɔ wĩĩ yɔ̃ ye; ca mpãy bya ma ke syi. Mpãy ter maha ma, Yãhã Yai tẽn wĩĩ na, pe cɔɔ wãsya wĩĩ sye; ca mpãy bya ma ke syi. Wii ma cã u ga waha yia u kaklaha ngĩĩ sya, u ke sya.» ");
INSERT INTO xrb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nawee- n pa kicaabir ne Yesu fla na, tuu koho taha pe na, u Yãhã nar pe wĩĩ na. Pe kãnyãrwai n sye pe na. ");
INSERT INTO xrb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Loo na, Yesu n pe pye ma yee: «Ye tyii pe kicaabir na pe n pa ra ye! Yaʼa n sye pe na ye. Ye sẽ yãã, mpãy pe ma pra poo wãŋ syi dyaŋ, Yãhã Yai ma poo wãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","U n koho taha pe kicaabir na, ma yir ke fla na ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Naanfuɛ̃ waa n yũhũ crã Yesu na, ma u yey ma yee: «Yĩŋfua, n ga waha kayĩĩ lii pye, n waha cĩĩnde yrã yãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu n u pye ma yee: «Nwa ma n ta yey kayĩĩ wĩĩ ne? Yãhã ya ke yɔ̃. Maʼa yee ma ga cĩĩnde yrã yãã, naa Yãhã kãnde kataŋ wũhũ pye!» ");
INSERT INTO xrb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","U dya n Yesu yey, a Yãhã kãnde wũhũ nkãy? Yesu n u yɛ̃ sya ma yee: « ‹Maʼa syi ma nawee boo ye; maʼa syi ma cayɔr le ye; maʼa syi ma yuhu ye; maʼa syi ma kawar fua ye; ");
INSERT INTO xrb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","naa ma tuhufua gboho, ma nahafua ne! Ma ya wĩĩ le n tãy ma ye mii syi dyaŋ, tyii ma nampyeŋ wĩĩ n naa n tãy ma ye ke syi.› » ");
INSERT INTO xrb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","U naanfuɛ̃ n Yesu pye ma yee: «Ndoo koo ngĩĩ byɛ yigi, n yai n maha lii pye?» ");
INSERT INTO xrb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu n u pye ma yee: «Maʼa yee ma ga kua, ka, ma ga ma koho wãn byɛ par tãŋ, -taa pe war byɛ wãã tãŋ nawãm kẽ. Loo na, ma -sẽ ga ba nii nangbãŋ Yãhã yĩnde na. -Taa pa, ma ba taha ra na!» ");
INSERT INTO xrb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","U naanfuɛ̃ tuu kaplãŋ ngĩĩ luhu, u laam byɛ n wlãhã u ye, u n tɛr. U tee pye nangbãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Loo na, Yesu n u kãnyãrwai pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Nangbãm wãdye wĩĩ Yãhã Yai wo, le war! ");
INSERT INTO xrb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","-Ye yãŋ, yũhũmii wãdyeyitɛr mensãn wihi ne, le ma fãhãfãhã ma tɛr nangbãm wãdye yaha Yãhã Yai wo.» ");
INSERT INTO xrb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pe kãnyãrwai pe kaplãŋ ngĩĩ luhu, le n pe fe gbe pe n sya yee, a nangbãm ma yee pe saa waha pe yĩy yi yaha ye, yoo syi -sẽ ma u ga waha u yĩŋ yi yaha? ");
INSERT INTO xrb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu n pe yãŋ, ma pe pye ma yee: «Kai laa ne le nawee yia; ma -sẽ yee Yãhã koo na, koo n yia kai- byɛ na.» ");
INSERT INTO xrb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Loo na, Pyar n kapãn gbe ma yee: «Yĩŋfua, yãŋ, wii mpãy too -sẽ tɛr wo kãnkai- byɛ yaha, ma taha ma na, wo wĩĩ ga ba pye mii?» ");
INSERT INTO xrb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Yãhãyĩŋfãŋ ga ba pye, kãntrafãŋ ne. U Nawee Puee ma ba nii kai- byɛ yĩŋ na u niisayũhũ fla na, yii sẽnsye syãm mii tee n taha u na, ye bya ga ba nii yĩŋ na, nangbãniisar wo, ye Yiisrɛ ter sẽnsye syãŋ ngĩĩ nawee- byɛ sãhã. ");
INSERT INTO xrb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mpãy byɛ pe tɛr pe klɛ yaha, pe nampyesey ne, pe tuhufa ne, pe nahafa ne, pe ca ne, pe pa ne, pe pii ne, pe tar ne ta wĩĩ na, poofa ga too syi flɛ gbeebua yãã kãntraha nge na. Sukũhũ gaa laam wo, pe ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mpãy pe ma yahasee ye yagaa, poo busãã ga ba nii kur ye, mpãy pe -sẽ ma kur ye yagaa, poo busãã ga ba yahasee yãã.» ");
INSERT INTO xrb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu n maha yee: «-Ye yãŋ, Yãhã Yai wĩĩ ma mii tẽntẽbir mpãy wĩĩ dyaŋ, tarfua waa ne. U tarfua ba cãã yir sukũhũntãy na, yainsaha daryale wo, woo ga tẽntẽbir kɛ ba le u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","U n mpãy yãã, ma yee woo ga pe dãã per neŋ tẽn war ne. Pe n yɛr le na. U n pe ta pe n ga nii tẽn tẽ u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yai n faa dugu, u tarfua n maha yi, ma ka tẽntẽbir kɛsaha fla wo, ma ga mpãy yãã pe ka nii, laa sẽ ne pe n pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","U tarfua n pe pye ma yee: Ye ga waha ka yii ndoŋ, ye ga naa tẽn tẽ ra tar wo. N ga ba ye tẽn draha dãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pe tẽntẽbir n ka. Yai n ba dye yĩŋ wo, u tarfua n maha yi, ma ga tẽntẽbir mpãy kɛ ba le te tar wo. Yai n ba yĩn, u n maha yi ga mpãy kɛ ba le te tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yai n ba kua, u n yi, ma maha ga mpãy yãã, pe ba tege nii nantãŋ tẽn kɛsaha fla wo. U n pe yey, a nwa pe n tege nii ke fla na ma yai kua, laa sẽ ne pe n pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pe n yee, waa sẽ poo gbe tẽn na ye, koo kẽ. U tarfua n yee, le ma pye koo syi, pe tẽntẽbir pe ka pe ya ndoŋ, pe ga tẽ u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yai n ba kua tãŋ, u tarfua n u war yĩŋfua pye ma yee: ‹Pe tẽntẽbir byɛ yee ba, ma ba pe dããn wãã pe kẽ. Mpãy pe gbe kur kuɛ ye, cãã naa poo dãã, ma ba kua mpãy na pe cãã gbe.› ");
INSERT INTO xrb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mpãy pe ba dye tẽn wo yainkɔŋ yale wo, poo n cãã pa loo na, maa per naneŋ tẽn war yãã. ");
INSERT INTO xrb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tẽntẽbir mpãy pe ba cãã dye tẽn wo, poo n ba pa, ma naa le ga laa na poo war ga gboho tɛr. Pe n pe bya dãã per naneŋ tẽn war ne. ");
INSERT INTO xrb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pe n pe war sya ma yee, poo sẽ u tarfua ne, ");
INSERT INTO xrb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ma u pye ma yee: ‹Tẽntẽbir mpãy taa gbe kur kuɛ ye yainkɔŋ wo, ma cã pe sẽ ma- le tẽn na ye. Ma pye mii ma pe dãã wãcɛŋ wo ne, wii mpãy too per wihi wãfãy sya, ke yaiwlaŋ wãsuhu ne?› ");
INSERT INTO xrb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","U tarfua n poo nen waa yɛ̃ sya ma yee: ‹Ta naambiyã, n sẽ dawar pye ma na ye. Ma ba le pãã laha ma yee, mboo yɛr per neŋ tẽn dããn na. Cĩĩnde sẽ na? ");
INSERT INTO xrb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ma dããn sya, taa naa n gaha. Wii tẽ gbe kur kuɛ ye yainkɔŋ wo, n yee n ga u dãã ma ne wãcɛŋ. ");
INSERT INTO xrb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N ma yee n ga naa ra war pye mii, le yai n waha naa pe pye koo syi. Tẽ ma naweeyɔ̃ loo la le laanyar yigi ma kẽ, ma n yĩntaha waha?› » ");
INSERT INTO xrb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Loo na, Yesu n maha pe yar taha ma yee: «Mpãy pe ma kur ye yagaa, pe ga ba yahasee yãã. Mpãy pe -sẽ ma yahasee ye yagaa, poo pe ga ba nii kur kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu naa n gaha Yurusalɛm wo, nabuar naa n taha u na. U naa n yãr, ma ba u kãnyãrwai cɛr yi pe ya ya, ma pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«-Ye yãŋ, Yurusalɛm kẽ too dugu n gaha. U Nawee Puee ga ba yi pe Yãhã yũndefa yĩŋfa kẽ, tesẽ pe Yãhã kaiyarfa ne. Pe ga yɛr u wãboo wĩĩ na, ");
INSERT INTO xrb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pe u wãã mpãy kẽ pe sẽ cĩĩnde Yãhã cã ye. Poo pe ba naa u lɛr, pe naa u gbã sãngblã ne, pe ba u kuey mar boo trã na. U wãku plii tãã wuhu, u ga yir gbã wo u pa gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Loo na, Sewede pii nahafua n pa Yesu fla na, u dyam syãm ne. U n kãnklũy gbãã, woo ga laa nar Yesu ye. ");
INSERT INTO xrb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu n u yey, u ma nwa wĩĩ na. U n u pye ma yee: «Maʼa ba nii kai- byɛ yĩŋ na, ma yĩnfar wo, ma tyii ta pii n nii nen nwo ma kãndigi koho kuɛ ye, nen nwo ma kãmaŋ koho kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu n pe pye ma yee: «Tee lii nar, ye sẽ le cã ye. Wãfãy tii tẽ n pai sya, yaa waha te sya la?» Pe n u pye poo ga waha yia. ");
INSERT INTO xrb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu n pe pye ma yee: «Cĩĩnde ne, yaa ra wãfãy syi sya. Ma -sẽ yee mpãy pe ga ba nii ra kãndigi koho kuɛ ye, ta kãmaŋ koho kuɛ ne, n saha poofa yãŋ yi ye; Yãhã too niisar gbihi ta mpãy kẽ, poo niisar kẽ te ne.» ");
INSERT INTO xrb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pe kãnyãrwai sẽnsye mii pe le luhu, pe laam n war pe kãnyãrwai syãm mii wĩĩ ne. ");
INSERT INTO xrb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Loo na, Yesu n pe byɛ yee ba, maa pe pye ma yee: «Ye cã mpãy pe ma kãntrɛ kui yĩŋfa, pe nawee- nar-, tesẽ pe nangbãm bya maha pe fãnga yar pe na. ");
INSERT INTO xrb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Le sẽ -sẽ wee ke syi ye ne ye. Wii ma yee u ga yĩŋ yãã ye laam wo, woofua yai u nii ye byɛ tẽntẽle. ");
INSERT INTO xrb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wii ma yee u ga yahasee fla yãã ye laam wo, woofua yai u nii ye byɛ yãmpuai. ");
INSERT INTO xrb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Loo ne, u Nawee Puee sẽ pa nangbãn yĩmbui ne ye, u pa u n pai nii tẽntẽle nawee- byɛ ye, u u yrã wãã u ku, u nabuar par sya, u pe yi pe kapee- wãpyeŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pe naa n gaha Yurusalɛm wo, ma ga dye Yerekɔɔ wo, ma sya le yi yaha wa. Nabuar naa n taha Yesu na. ");
INSERT INTO xrb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fũũ- syãm pye, pe ba nii kãnde yɛ̃ na. Pe le luhu, a Yesu kẽ u n tɛr, pe n nii n tẽ ma yee: «Yĩŋfua, mboo Dawide Dya, wo fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pe nabuar naa n kuãn pe na, ma yee pe yaha le; pe n cã maha naa n tẽ fãnga ne loo na ma yee: «Yĩŋfua, mboo Dawide Dya, wo fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu n luhu, ma yɛr ma pe yee ba, ma pe pye ma yee: «Ye yee n nwa pye ye kẽ?» ");
INSERT INTO xrb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pe n u pye, u ta poo yĩmpɛ n waha naa n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pe fɛn n Yesu yigi, u n tɛ pe yĩmpɛ na. Pe fũũ- syãm yĩmpɛ n ta tɛr jaa, pe n maha waha n yãŋ gbɛgbɛ faale dyaŋ, ma nii n taha Yesu na. ");
INSERT INTO xrb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu tesẽ u kãnyãrwai ne, pe n ga nɔ gbe taha Yurusalɛm na, kusyĩnde laa wo pe n yee Gbefasyɛ, yãŋ gaa tãy. Katyir raa ter pye ke fla na, pe naa re yee wolifyɛ katyir. Yesu n u kãnyãrwai syãm mpãy lɛhɛ wãã yahasee ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«-Ye ka kusyĩnde ndaa wo ye yahasee ye! Yaʼa kãhã ga n dye, yaa kãnkonsyoho gaa yãã, ke pua yaha nii ke pua ne. -Ye te sãhã ba ra kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wii ma ye yey laa ne, -ye yee te wĩĩ ma wo Yĩŋfua na. U ga tyii, ye n pa re ne.» ");
INSERT INTO xrb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kai lii Yãhã kaplãŋ tɔ̃rfua waa bii cãã yrũhũ yaha, loo ne le nii n pye loo yale wo. Le ma le yrũhũ ta ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«-Ye ga Syɔ̃ klofa yar ye yee: -Ye yãŋ, ye Yĩŋfua nwo u n pai ye ye, laantãr ne. U ma u dugu nii kãnkoŋ na, kãnkonyainge kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pe kãnyãrwai n tɛr. Yesu tuu ba pe yar mii, pe n ga pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pe n pa ke kãnkonsyoho ne, ke pua ne, ma pe nayrengbãy taha ta te na, Yesu n nii te na ke kãnkonyainge na. ");
INSERT INTO xrb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nabuar n te ya wãã Yurusalɛm kãnde yɛ̃ na. Pe n nii u gboho, pe fãnga n pe nayrengbãy yi, ma yaha ta le kãnde wo, mpãy n -sẽ katyir wan ka ba ta le kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mpãy pe naa n yãr Yesu yaha ye, tesẽ mpãy ne pe naa n taha u na, pe n nii nuhu di, ma nii le gble, ma n yee: «Wo wãdyaha Dawide Dya, ma myaha ke gboho! Mboo wii taa n pai Yãhã myaha ne, Yãhã ke kaa taha ma na! Nawee- byɛ pe naa Yãhã miingbãŋ gboho!» ");
INSERT INTO xrb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu tuu dye Yurusalɛm wo, loo n gbleŋ yir le klo wo. Pe n nii le yey ma yee, yoo kẽ dya nwo ne. ");
INSERT INTO xrb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pe nabuar mpãy pe pye Yesu ne, poo n nii pe klofa yar ma yee, Yãhã kaplãŋ tɔ̃rfua Yesu wii u n yi Nasarɛte wo, woo kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Loo kur ye, Yesu n ga dye Yãhã kangbãŋ laam wo. Mpãy pe naa cãã troho, ma suhu mpãy ne pe naa wãn par ke Yãhã kangbãŋ laam wo, u n pe kar. U n warturfa tabal ye kuã cããr, tesẽ nasar kate parfa kãnay ne. ");
INSERT INTO xrb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","U n pe pye ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹Ta kangbãŋ yai ke naa n yee ta seysaha.› Yii -sẽ ke ta yuhu- dyeniisaha.» ");
INSERT INTO xrb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Fũũ- mpãy, tesẽ tãnklahafa mpãy ne, pe n yũhũ crã Yesu na ke Yãhã kangbãŋ laam wo, u n pe jaa. ");
INSERT INTO xrb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yesu naa laanwɔ wũhũ ngĩĩ pye, kicaabir naa u sey ke Yãhã kangbãŋ wo ma yee: «Dawide Dya myaha ke gboho!» Koo sẽ tãy pe Yãhã yũndefa yĩŋfa ye, ma suhu pe Yãhã kaiyarfa ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Loo na pe n Yesu pye ma yee, a pe nkãy pãã, u sẽ ke luhu la? Yesu n pe yɛ̃ sya ma yee: «Ãwã, n ke luhu. Yii gɛ le kal yãã Yãhã sabangbãŋ wo, lii le yrũhũ ta ma yee: ‹Ma ta, kicar n sya nii ma sey, pẽyãr bya ne.› » ");
INSERT INTO xrb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Loo kur ye, u n tɛr ma yi le klo wo, ma ga syã Gbetane wo. ");
INSERT INTO xrb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ke yĩŋsyii wo, pe dur naa n pai le klo wo, fãã n Yesu yigi. ");
INSERT INTO xrb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U n nasar nkugu katyigi gaa yãã kãnde yɛ̃ na, ma yũhũ crã ke na. U sẽ -sẽ ngaa yãã ke na mii wan ya sẽ kẽ ye. Loo na, u n ke katyigi pye ma yee: «Ma saa pii sa yãã yãã nantãŋ ye.» Ke katyigi n ta tɛr waha ku le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pe kãnyãrwai pe nde yãã, le n yɛ̃ gbãã pe na, ma sya ga far tɛr. Pe n Yesu yey ma yee, ke nasar nkugu katyigi pye mii, ma waha ku ke syi le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu n pe yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ye ye: Ye ma Yãhã ta ye Yatɛr, ye sẽ laalaa pye ye, tẽ lii pye nasar nkugu katyigi nge na, yaa waha le pye. Ye ga maha waha yãŋ nge gɛ pye: Yũhũ kãã, ka ma ga too dye langbãŋ laam wo, le n -sẽ pye cĩĩnde ye yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ye ma Yãhã sroŋ ta ye Yatɛr, ma ngii ngii nar ke ye, yaa ke yãã.» ");
INSERT INTO xrb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Loo kur ye, Yesu n ga dye Yãhã kangbãŋ laam wo, ma nii nawee- klaha. Pe Yãhã yũndefa yĩŋfa, ma suhu pe wãlɛ ne, pe n yũhũ crã Yesu na, ma u yey ma yee: «Kai- ngĩĩ byɛ raa n pye, ma ke pye kãnde lii ne? Yoo kãnde wãã ma kẽ ma naa ke pye?» ");
INSERT INTO xrb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu n pe yɛ̃ sya ma yee: «Ta bya, n ga ye yey katɛ nen ya ne; yaʼa ra yar, ta bya -sẽ ga ye yar n kai- ngĩĩ pye kãnde lii ne. ");
INSERT INTO xrb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoo tuu ba Nsãn lɛhɛ wãã, u n ba nawee- tãã naa n yi loho wo? Yãhã laa, nawee-?» Pe n ga nii le klãŋ n pãã pe ya ya ma yee: «Waʼa yee Yãhã kẽ ke ba u nɔ wãã, u ga wo pye, a nwa wo sẽ -sẽ ba u Nsãn kaplãŋ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wo saha yee nawee- me pe u lɛhɛ wãã ye. Wo yai wo fya pe nabuar na, pe byɛ le sya cĩĩnde ma yee Nsãn pye Yãhã kaplãŋ tɔ̃rfua.» ");
INSERT INTO xrb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Loo na, pe n ba Yesu pye ma yee, poo cã na? Yesu n -sẽ pe pye ma yee: «Yaʼa yee ke syi, ta bya n saa ye yar n kai- ngĩĩ pye kãnde lii ne ye.» ");
INSERT INTO xrb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu n maha pe yar kakuãcran ne ma yee: «-Ye yãŋ le yãŋ nde wo: Dya waa pye naam kicar syãm ne. U n u dyadyaha pye ma yee: ‹Ta dya, ka maa tẽn tẽ tar wo nanga.› ");
INSERT INTO xrb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","U n yee woo saa ka ye, ma maha ba sye kur kuɛ ye, ma ka te tar laam wo, ma ga tẽ. ");
INSERT INTO xrb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Loo kur ye, u tuhufua n loo wĩĩ nen ya pãã u dyasyĩnde ye. U n u yɛ̃ sya ma yee, ãwã tuhufua. U sẽ -sẽ ka te tar wo ye.» ");
INSERT INTO xrb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesu n pe yey, a pe kicar syãm mii laam wo, wii woo u pe tuhufua laam wĩĩ pye? Pe n yee, a u dyadyaha woo kẽ. Loo na, Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Kufar wããfa, ma suhu canaandi ne, pe ga cãã dye ye yaha Yãhã Yai wo. ");
INSERT INTO xrb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ye sẽ yãã, Nsãn nawee- tããfua pa, ma ba le kãnsroŋ yar ye na, ye n sye ye sẽ u wĩĩ sya cĩĩnde ye. Pe kufar wããfa, ma suhu pe canaandi ne, poo -sẽ u wĩĩ sya cĩĩnde. Tee sya maha loo yãã, ye sẽ sya ma ye kapee- miy yaha, ma u wĩĩ sya cĩĩnde ye.» ");
INSERT INTO xrb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu n maha kakuãcran nde pãã pe ye ma yee: «Dya waa ba defĩĩ katyir tar le, ma te klaha tã, ma ke defĩĩ pii yĩĩtyaha cɛr ntẽmbangbãŋ wo, ma dur ma te tar sẽŋsaha fla fãã. Tuu koo pye wa, u n te tar yaha tawarfa mpãy ye, ma tɛr yrãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te defĩĩ pii yiyale le ba nɔ, u tarfua n kuee, ma u tẽntẽbir mpãy lɛhɛ wãã pe tawarfa ye, pe ga woo lay sya ba. ");
INSERT INTO xrb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pe tawarfa n ga pe tẽntẽbir yigi, ma nen gbã, ma nen boo, ma nen waa boo ntẽmbar ne. ");
INSERT INTO xrb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","U tarfua n dur ma maha u tẽntẽbir mpãy lɛhɛ wãã pe tawarfa ye, poo ba nihi faale wãm na. Pe tawarfa n maha poo yigi. Pe ba faale wãm pye mii, pe n maha pe yagaa wãm pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","U tarfua n u dya lɛhɛ wãã pe ye kur kuɛ ye, ma nii le ga ma yee, laa na pe n gaha nagboho ta woo na. ");
INSERT INTO xrb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pe tawarfa pe u dya yãã, pe n nii pe ya pye ma yee: ‹Wii tuu ga ba nii tarfua, woo kẽ nwo. -Too u boo, te wãn byɛ n ba nii wo wãn.› ");
INSERT INTO xrb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pe n u dya yigi, ma u miy yi wãã te tar nkur ye, ma u boo.» ");
INSERT INTO xrb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu n pe nawee- yey ma yee: «U tarfua ma ba pa, u ga ba pe tawarfa pye mii?» ");
INSERT INTO xrb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pe n u yɛ̃ sya ma yee: «U ga ba pe napee- mii byɛ boo tãŋ, u saa pe fɛn di ye; tuu te tar yaha tawarfa mpãy kẽ, poo n ba naa u lay wãã u kẽ u defĩĩ yiyale wo.» ");
INSERT INTO xrb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Loo kur ye, Yesu n pe pye ma yee: «N cã ye kapãn nde yãã kal Yãhã sabangbãŋ wo, kapãn lii le n yee: ‹Ntẽmblaha gii nwonfããfa pe ba sye yaha, koo ntẽmblaha kẽ, ke dur yĩŋ yãã ke nwoŋ wãfãã wo. Yãhã ke lii pye loo ne nde. Laanwɔ wĩĩ ne too n yãã yĩnde ne.› » ");
INSERT INTO xrb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu n pe yar taha ma yee: «Loo ne, n ga ye yar, Yãhã Yai ga ba sya kãã ye ye, ke wãã mpãy kẽ pe Yãhã laam wũhũ pye, ma yai ke wãyãã ne.  ");
INSERT INTO xrb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wii ma too tã koo ntẽmblaha nge na, u ga u ya waa yraha ke na. Koo ntẽmblaha ma -sẽ maha too tã wii na, ke ga ufua waa yraha migimigi.» ");
INSERT INTO xrb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pe Yãhã yũndefa yĩŋfa, ma suhu pe Farisyɛ̃ ne, pe Yesu kaplãŋ luhu, pe n cã poo wĩĩ ne Yesu tuu pãã. ");
INSERT INTO xrb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pe n nii u yigisaha kɛ, ma -sẽ ba fya pe nabuar na. Pe nabuar naa n yee, a Yãhã kaplãŋ tɔ̃rfua kẽ Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu n maha nii n pãã pe nabuar ye kakuãcran ne. U n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Yãhã Yai wĩĩ ma mii nde dyaŋ tẽ ga tɔ̃r ye ye: Yĩŋfua waa ba casyadir soho u dya myaha na. ");
INSERT INTO xrb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tuu ba mpãy yee te casyadir na, u n u tẽntẽ- lɛhɛ wãã, pe ga pe yee ba. Pe sẽ -sẽ sya ma pa ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Loo na, u n maha tẽntẽ- mpãy lɛhɛ wãã, ma pe yar ma yee: ‹Tẽ mpãy yee te casyadir na, ye ga pe yar ye yee: Te dir byɛ soho tãŋ wa. Ta napa, tesẽ ra naampĩy tii ne te gboho, n ta pe n te byɛ boo, te wãn byɛ gbihi ta wa. -Ye pe yar pe pa te casyadir na!› ");
INSERT INTO xrb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pe nawee- sẽ le ta kai ye, ma ta tɛr pe kapyeŋ ye: Nwo n ka u tar wo, nwo n ka ma ga nii u cãã troho. ");
INSERT INTO xrb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mpãy n pe tẽntẽ- yigi, ma pe nuhu, ma pe boo. ");
INSERT INTO xrb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","U yĩŋfua laam n war. U n seraasyi lɛhɛ wãã, pe n ga pe naboofa mii boo, ma pe klo suhu. ");
INSERT INTO xrb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Loo kur ye, u n u tẽntẽ- mpãy pye ma yee: ‹Te casyadir byɛ soho tãŋ wa. Mpãy pe -sẽ ba yee te na, pe sẽ yai te wãdiŋ ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","-Ye ka nanihi teebɛhɛ wo, mpãy byɛ tee ga yãã, -ye pe yee ba te dir na!› ");
INSERT INTO xrb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pe tẽntẽ- n ka te nanihi teebɛhɛ wo, nawee- mpãy pe ga yãã pe n pe byɛ yee ba, napee- ma suhu naweeyɔ̃m ne. Loo na, nwongbãŋ gii te dir te pye ke laam wo, ke n yĩĩ nawee- ne. ");
INSERT INTO xrb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","U yĩŋfua n dye loo na, woo ga pe nawee- yãŋ. U n dya waa yãã, u sẽ ba te cagbar nayroho le ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","U n u pye ma yee: ‹Naambiyã, ma pye mii ma sẽ ma nayrɛ fɛr ma te cagbar nayroho le ye, ma dye ba nwo?› U dya sẽ laa pãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Loo na, u yĩŋfua n u tẽntẽ- pye ma yee: ‹-Ye u trɛ pua, u kluɛ ne, ye u gbe miy yi wãã nkur ye, wam wo, u n naa wũn, u naa nkãhã yĩhĩ.› » ");
INSERT INTO xrb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu tuu koo kaplãŋ pãã wa pe ye, u n pe yar taha ma yee: «Ye sẽ yãã, nawee- busãã ga ba yee; mpãy pe -sẽ ga ba yãŋ yi poo laam wo, pe saa ba nihi ye.» ");
INSERT INTO xrb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pe Farisyɛ̃ n ka, maa pe ya wãã, ma yee poo ga waha Yesu plaha yigi kayey lii syi ne. ");
INSERT INTO xrb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Loo kur ye, pe n pe nawee- mpãy lɛhɛ wãã Yesu ye, ma suhu Yɛrɔte nawee- mpãy ne. Pe n ga Yesu pye ma yee: «Yĩŋfua, wo cã ma cĩĩnde ya pãã. Ma nawee- klaha cĩĩnde ya ne Yãhã kãnde wãyãr wĩĩ na. Ma sẽ n fya nawee yĩnde na ye. Nawee ma sya nii mii syi dyaŋ, le sẽ kai kua ma ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Loo ne waa ma yey laa ne, maʼa lii yãã le na, ma wo yar: Wo kãnde na, wo yai la kufar wãwãã ne u fãngafa byɛ yĩŋfua kẽ laa, wo sẽ yai te wãwãã ne u kẽ ye?» ");
INSERT INTO xrb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu -sẽ ba cã pe wãpee ga yigi pe laam wo. U n pe yɛ̃ sya ma yee: «Dawarfa me ye ne! Nwa ta ye n ta wãleŋ kɛ namihi wo? ");
INSERT INTO xrb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tee kufar dãã war mpãy syi ne, -ye waa yar ra na!» Pe n ntẽn war waa yar u na. ");
INSERT INTO xrb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu n pe yey ma yee: «Yoo yirfua pe pye ta u na nwo, u myaha ne?» ");
INSERT INTO xrb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pe n yee, a u fãngafa byɛ yĩŋfua yirfua kẽ, u myaha ne. Yesu n pe pye ma yee: «Ah -ye naa fãngafa byɛ yĩŋfua dãã u myaha wãn ne, tee naa Yãhã dãã ke myaha wãn ne!» ");
INSERT INTO xrb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pe u kapãn nde luhu, le n pe laam wɔ. Pe n tyii u na, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ke per bya wo, Sadusyɛ̃ mpãy n pa pe ya ndoŋ, Yesu fla na. Poo me pe n yee, a mpãy pe ku wa, pe saa ba yir gbã wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pe n Yesu yey ma yee: «Yĩŋfua, wo faale wãdyaha Musa bii kãnde laa yar wo na, le nde: ‹Naa ma ku, kicar sẽ kẽ u ye ye, u cĩĩfua yai u u calangusya gbe, pe n kicar see u lɛfua kẽ, wii tuu ku.› ");
INSERT INTO xrb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ãhã, dya waa -sẽ pye wo fla na, cĩĩfa kuay ne. U dya n ba cɔɔ sya, ma ku u yaha, puee sẽ kẽ ye. U taha n u calangusya gbe. ");
INSERT INTO xrb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Woo bya n maha ku u cɔɔ yaha, puee sẽ kẽ ye. U tãã wuhu n u gbe, loo katɛ nen ya. Koo syi ya, koo syi ya, poo kuasĩĩ byɛ n ba ku tãŋ u cɔɔ yaha nanem. ");
INSERT INTO xrb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Loo kur ye, u cɔɔ n ba ku u ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mpãy pe ku wa, pe ma ba yir gbã wo per gii, u cɔɔ ga ba nii yoo wũũ pe laam wo? Poo byɛ sẽ u yãã cã la cɔɔ?» ");
INSERT INTO xrb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu n pe yɛ̃ sya ma yee: «Ye plaha loo nde ne ma yee, a mpãy pe ku wa, pe saa yir gbã wo ye. Ye sẽ Yãhã sabangbãŋ wũhũ cã ye, ye sẽ maha Yãhã fãnga cã ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ye sẽ yãã, mpãy pe ku wa, pe ma ba yir gbã wo, pe ga nii mii yãhãyĩŋ tẽnlɛhɛ wãŋ syi dyaŋ yãhãyĩŋ na. Naam tesẽ ca ne, pe saa ba naa pe ya gbe ye. ");
INSERT INTO xrb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mpãy pe ku wa, ma n pai yir gbã wo, Yãhã pe wĩĩ yar laha ye na. -Ye yãŋ, lii le yrũhũ yaha Yãhã sabangbãŋ wo, nakur wãyir wĩĩ na gbã wo, -ye ye laam too le na! ");
INSERT INTO xrb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Yãhã yee: ‹Ndoo tẽ ma Yãhã Brama ye, Yisyake ne, Dyakuba ne.› » Loo na, Yesu n pe yar taha ma yee: «Mpãy pe ku, pe ma yrãŋ Yãhã yĩnde na.» ");
INSERT INTO xrb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nabuar mpãy pe naa n luhu Yesu ye, u kaklaha n yɛ̃ gbãã pe na. ");
INSERT INTO xrb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pe Farisyɛ̃ pe le luhu, a Yesu pe Sadusyɛ̃ yɛ̃ wãã sya, ma sya yɛ̃ gbãã pe na, pe Farisyɛ̃ n pe ya wãã. ");
INSERT INTO xrb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Poo nen waa pye Yãhã kaiyarfua. U n yee woo ga Yesu le namihi wo, ma u yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Yĩŋfua, Yãhã kãnde kataŋ laam wo, lii loo le ma yĩŋ?» ");
INSERT INTO xrb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu n u yɛ̃ sya ma yee: «Lii le ma yĩŋ le nde: ‹Ta, ma Yĩŋfua Yãhã wĩĩ n naa n tãy ma ye, le tɛr wãn byɛ yaha, le gboho tãŋ ma laam byɛ wo, le nii tãŋ ma yrã byɛ na, ma kacãn byɛ n pye tãŋ loo na.› ");
INSERT INTO xrb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yãhã kãnde kataŋ laam wo, nde loo ne le ma yahasee ye, ma maha ma yĩŋ. ");
INSERT INTO xrb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lii le taha le yahasee wĩĩ na, le ka le kuɛ ye. Loo ne nde: ‹Ma ya wĩĩ le n tãy ma ye mii syi dyaŋ, tyii ma nampyeŋ wĩĩ n naa n tãy ma ye ke syi.› ");
INSERT INTO xrb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ke Yãhã kãnde kataŋ byɛ, ma suhu pe faale Yãhã kaplãŋ tɔ̃rfa kaklaha ne, too nde byɛ sroŋ koo kataŋ syãŋ ngĩĩ ne.» ");
INSERT INTO xrb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pe Farisyɛ̃ pe pye pe ba pe ya wãã nii, Yesu n pe yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ye laam wo, ye yee yoo kẽ u Yãhã Yĩndefua Crise ne? Yoo kur kuɛ puee kẽ?» Pe n yee, a Dawide kur kuɛ puee kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu n pe pye ma yee: «Le ma pye ke dyaŋ, Dawide -sẽ maha pye mii ma u yee Yĩŋfua? Ye sẽ yãã, Yãhã Yrã Fãnga pye Dawide na, ma bii u ta u n le pãã ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Yĩŋfua Yãhã ta Yĩŋfua pye ma yee: Pa tege nii ra kãndigi koho kuɛ ye kai- byɛ yĩŋ na, ta n sya ba ma napĩĩ- yĩy kor le ma kẽ, pe n nii mii ma tãnde fyãhã tã pe na.› » ");
INSERT INTO xrb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yesu n pe yey ma yee: «Dawide gɛ tuu naa u Yãhã Yĩndefua yee Yĩŋfua, u Yĩŋfua -sẽ ga maha pye mii u nii Dawide kur kuɛ puee waa?» ");
INSERT INTO xrb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pe Farisyɛ̃ sẽ waha u yɛ̃ wãã sya laa ne ye. Ma gbe koo per na, waa sẽ maha sya ma u yey yãã laa ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Loo na, Yesu n pe nawee- pye tesẽ pe kãnyãrwai ne ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Pe Yãhã kaiyarfa, tesẽ pe Farisyɛ̃ ne, poo me pe le kãnde yar nawee- na, kãnde lii Yãhã bii le le soho Musa koho wo. Pe taha loo na. ");
INSERT INTO xrb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Loo na, -ye naa n luhu pe ye, pe ma kai- nkãy byɛ pãã, -ye naa ke pye! Ye ma syi ye sẽ pe pyer yãŋ gbe ye! Ye sẽ yãã, pe nawee- klaha lii ne, poo gɛ sẽ le pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pe nawee- fãy kai- busãã ne, kai- nkãy ke ma mii teger dyaŋ, pe sẽ -sẽ koho le pe ye, pe n waha re tẽŋ ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nkãy byɛ pe n pye, pe n kɛ nawee- n pe yãã yĩnde ne, pe naa pe sey. Pe ga pe Yãhã kaplãŋ sabar fe, te n paha ta tɛr nawee- byɛ wãn yaha, pe n naa n pua. Tesẽ, pe nayrengbãy namihi nkãy ke n yoŋ tãã ye, ke tyĩĩ n tɛr nawee- byɛ wũhũ na. ");
INSERT INTO xrb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nanihi dir disaha wo, pe ga naa niisayɔ̃r fla kɛ, tesẽ pe yawãhã nwey wo, niisar tii nawee- byɛ yĩnde le yi n too re na, too syi niisar pe ne kɛ pe nii. ");
INSERT INTO xrb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pe n kɛ pe naa pe syar nangbãsyaha ne nanihi teebɛhɛ wo, tesẽ pe naa pe yee kaicãfa. ");
INSERT INTO xrb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yii poo na, ye ma n tyii waa n naa ye yee kaicãfa ye! Ye byɛ ma wãcɛŋ, kaicãfua neŋ ya kẽ u ma ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kãntraha nge na, ye ma syi ye naweetee waa yee ye tuhufua ye! Tuhufua nen ya kẽ u ma ye ye, woo kẽ Yãhã ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ye ma syi ye ta pe n naa ye yee yĩŋfua ye! Yĩŋfua nen ya kẽ u ma ye ye, woo kẽ u Yãhã Yĩndefua Crise ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wii u n traha u nii yĩŋ na, u yai u nii ye byɛ tẽntẽle! ");
INSERT INTO xrb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nawee wii ma u ya ta yĩŋfua draha wo, ufua ga kloŋ. Wii ma -sẽ u ya kloŋ, ufua ga kuã yir.» ");
INSERT INTO xrb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu n maha yee: «Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Ye nawee- ta pe saha dye Yãhã Yai wo ye. Yii sẽ n dye ye, mpãy pe n kɛ pe dye, ye maha n sye pe na.  ");
INSERT INTO xrb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Yii me, ye calangusyam wãn kur byɛ sya n kãã pe kluɛ wo, ye dur ye yii ta naweeyɔ̃m dyaŋ, ye Yãhã ka syar kaplãmbuar ne, ye sya ma-. Koo byɛ wãpẽn draha ga ba ye dye, ke la ke sya gboho tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Ye ne tɛr yrãhãtrũhũ ye, kaa na kãntraha na, kaa na salangbãy ne, ye ga nawee nen ya kɛ, u n naa n yãr ye kãnde wo. U ma ye kãnde yigi, yaa u ta u n yai naa fla ne, ye wãŋ syi dyaŋ ngbey syãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yii mpãy nawee- n taha ye na, fũũ- me ye ne! Ye wĩĩ pee Yãhã ye. Ye n yee: Wii ma Yãhã di Yãhã kangbãŋ myaha ne, laa wee le na ye. Wii ma -sẽ Yãhã di Yãhã kangbãŋ sãn myaha ne, tuu lii pãã, u yai u le pye. ");
INSERT INTO xrb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Napley me ye ne, fũũ- me ye ne! Ye sẽ yãã, sãn wãn tii te ma Yãhã kangbãŋ wo, koo kangbãŋ kẽ ke te ta, te n nii Yãhã wãn. ");
INSERT INTO xrb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ye maha n yee: Wii ma Yãhã di Yãhã diŋ yisaha fla myaha ne, laa wee le na ye. Diŋ gii ke -sẽ ma koo fla na, wii ma Yãhã di koo diŋ nge myaha ne, tuu lii pãã u yai u le pye. ");
INSERT INTO xrb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Fũũ- me ye ne! Ye sẽ yãã, diŋ gii ke ma Yãhã diŋ yisaha fla wo, koo fla kẽ ke ke diŋ ta ke n nii Yãhã kla. ");
INSERT INTO xrb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wii ma Yãhã di Yãhã diŋ yisaha fla myaha ne, ufua Yãhã di ke Yãhã diŋ yisaha fla myaha ne, tesẽ diŋ wãn tii byɛ ne te ma ke yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wii ma Yãhã di Yãhã kangbãŋ myaha ne, ufua Yãhã di Yãhã kangbãŋ myaha ne, tesẽ Yãhã bya ne, koo gii ke ma ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wii ma Yãhã di yãhãyĩŋ myaha ne, ufua Yãhã di Yãhã nangbãniisaha myaha ne, tesẽ Yãhã gɛ ne, koo gii ke ma ke nii ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Ye ma ne ye digi gbe, tyũhũ wãn gɛ ne, ye te la flɛ sẽnsye, ye fla neŋ wãã Yãhã kẽ. Kãnde lii Yãhã le ta, le wo klaha kai- nkãy ne ke ma yĩŋ, ye sẽ -sẽ koo pye ye. Ye sẽ n sroŋ ye, ye sẽ nawee- fɛn di ye, ye sẽ Yãhã laam wũhũ pye ye. Koo kai- ngĩĩ -sẽ kẽ tee yai ye gbihi yigi, ye koo ta yĩŋ. Ke kai- ngĩĩ n -sẽ taha, ye ma syi ye faha laa yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yii mpãy, nawee- n taha ye na, fũũ- me ye ne! Ye lakuɛ loho fĩĩ, ma tepũũ yi n kãã ke wo ma cã ke wɔ; yũhũmii ma -sẽ too ku ke lakuɛ loho wo, ye ga ke wɔ ke dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Ye ma mii nawee- mpãy dyaŋ, pe crãŋ kur kuɛ yee, tesẽ tasa kur kuɛ ne, ma n tyii ke laam na. Ye bya, ye yii ta naweeyɔ̃m nkur kuɛ ye, ye laam sẽ -sẽ wee gbɛgbɛ ye. Nawee- wãyuhu wĩĩ ya le ma ye laam wo, tesẽ kai- nkãy ne ke sẽ yɔ̃ ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yii Farisyɛ̃, fũũ- me ye ne! -Ye cãã ye laam ta pe n nii gbɛgbɛ, ye -sẽ ga yɔ̃ gbaa na. Le ma mii crãŋ dyaŋ ke laam ma yee laha, ke nkur kuɛ bya -sẽ ga laha. ");
INSERT INTO xrb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Ye ma mii nakur gbũhũ wãŋ syi dyaŋ; pe ga ke nkur kuɛ tuhu ngaa ne ke n yɔ̃, ke nii perper. Ke laam -sẽ wo, ke yĩĩ nakur kacɛr ne, tesẽ wãfũhũ wãn ter byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye bya ma koo syi. Nawee ma ye yãã, u ga yee ye ma naweeyɔ̃m. Dawar wĩĩ ya -sẽ kẽ le gboho ye laam wo, tesẽ kapee- wãpye wĩĩ ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yii Yãhã kaiyarfa, tesẽ yii Farisyɛ̃ ye ne, dawarfa me ye ne! Ye wĩĩ pee Yãhã ye. Nakur gbũhũ nkãy ke yɔ̃, koo kẽ tee n gbihi Yãhã kaplãŋ tɔ̃rfa kẽ. Ye maha nasroŋ gbũhũ gbihi n yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ye maha n yee: ‹Waʼa ne pye wo faale wãlɛ cãã na, wo saa ne yĩmbui wãã le pe ne, wo pe Yãhã kaplãŋ tɔ̃rfa boo ye!› ");
INSERT INTO xrb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tee loo pãã pe faale Yãhã kaplãŋ tɔ̃rfa wãboo wĩĩ na, ye le cã laha ma yee, mpãy pe bii naa poo Yãhã kaplãŋ tɔ̃rfa mii boo, pe kur kuɛ pii me ye ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Le yɔ̃! Ye faale wãlɛ pe tẽn lii koho yigi, tee -sẽ le tẽ kua! ");
INSERT INTO xrb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nwɔr terfa me ye ne, ye pee tɛr! Ye laam wo, ye yee la ye saa ba sãhã ye ka naa fla wo ye, naa gii wãfegeyãã wee ke na ye? ");
INSERT INTO xrb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ye sẽ yãã, loo ne n ga Yãhã kaplãŋ tɔ̃rfa nɔ wãã ye ye, laantorfa ne, sabacãfa ne. Ye ga ba mpãy boo, ye mpãy kuey mar boo trãŋ na. Ye ga maha ba mpãy gbã sãngblãŋ ne, ye yawãhã nwey wo, ye mpãy kar taha naa n gaha teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Loo ne, naboor tii byɛ te boo faale wo, too nde byɛ wãpẽn draha ga ye dye. Too naboor nde bii gbe nasroŋ Abɛl wãboo cãã na, ma sya ba waa Basyi dya Dyakaridya wãboo cãã na, woo wii pe bii boo ke Yãhã kangbãŋ nsoho wo ke Yãhã diŋ yisaha fla ne. ");
INSERT INTO xrb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ta n cĩĩnde nde pãã ye ye, ntɔ̃r rii te woo, le kapee fuɛ ga yi yagaafa na.» ");
INSERT INTO xrb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu n maha yee: «Yurusalɛmfa, Yurusalɛmfa, ye Yãhã kaplãŋ tɔ̃rfa boo, tesẽ nawee- mpãy Yãhã pe nɔ n wãã ye kẽ, ye pe waa n boo ntẽmbar ne. Yalebyɛ n n kɛ n ye wãã ta nii tãy, mii nguyĩŋ dyaŋ ke ne ke pii wãã ta ke nkaasyir flãhã tãy. Ye sẽ -sẽ le sya yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tee n pye ke syi, Yãhã ga ba kur waa ye klo na. ");
INSERT INTO xrb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","-Ye yãŋ, n ga ye yar: Ma gbe yagaa na, ye saa ra yãã yãã nantãŋ ye. Per gaa, n ga dur ba, ye n -sẽ ba naa n yee: ‹Mboo wii taa n pai Yĩŋfua Yãhã myaha na, ke kaa taha ma na.› » ");
INSERT INTO xrb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu n yi ke Yãhã kangbãŋ wo, ma n tɛr u kãnyãrwai ne. Pe kãnyãrwai n yũhũ crã u na, ma u pye u ke Yãhã kangbãŋ nwey wãfãã nayɔ̃r ter yãŋ. ");
INSERT INTO xrb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Loo na, Yesu n pe yar ma yee: «Ta n cĩĩnde nde pãã ye ye: Ke Yãhã kangbãŋ nwey nde byɛ tee n yãã nde, te ga ba too, ntẽmblaha neŋ gaa gɛ saa ba taha ta nii ke nampyeŋ na ye; te byɛ ga ba traha.» ");
INSERT INTO xrb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu n ga dugu nii te wolifyɛ katyir yãŋ yĩŋ na. Pe kãnyãrwai ya n yũhũ crã u tãy, ma u yey ma yee: «Wo Yĩŋfua, taa naa ke Yãhã kangbãŋ wãtoo wĩĩ pãã, wo yar ke tooyale ne cigege, ma suhu kayar lii ne le ga ba waha ta, nawee- n ma wãdurba yale cã, tesẽ driyɛ̃ wãkua yale ne.» ");
INSERT INTO xrb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu n -sẽ too ke kai- na, ma nii pe yar ma yee: «-Ye naa yii yigi, waa kawar ma syi waha ba ye yĩntar figi ye! ");
INSERT INTO xrb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ye sẽ yãã, nawee- busãã ga ba ta myaha taha pe ya na, pe naa kawar fua pe yee, a poo me u Yãhã Yĩndefua. Pe ga ba nawee- busãã wlaŋ koo ne. ");
INSERT INTO xrb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ye ga ba naan wũhũ luhu, te ma tũntũn, kaa na te ma deydey. Yaʼa syi ye fya ye! Koo kayĩhĩ ngĩĩ yai ke ba dye, le sẽ -sẽ ga ba pye driyɛ̃ wãkuaŋ ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nawee- tergaafa ga ba naa naan miy ter gaa ne. Yĩŋfua waa ga ba yir u nawee- ne, u ga naan miy yĩŋfua waa ter ne. Fããpihi ga ba dye teebɛhɛ nkãy wo, tesẽ kãntraha wãyɛhɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kãnkai- ngĩĩ byɛ ga ba nii mii calaifua wãn dyaŋ, te ma ne yir u na, te naa u yaa. ");
INSERT INTO xrb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nawee- ga ba ye yigi wãã, pe n ye nuhu, pe sya ye boo. Ye wĩĩ ga ba fũhũ nawee- byɛ ye ta wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Koo cãã na, nawee- busãã ga ba Yãhã kãnde miy yaha. Pe ga ba yãr naa n yaha pe ya na; pe wĩĩ ga ba naa n fũhũ pe ya ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kawar Yãhã kaplãŋ tɔ̃rfa ga ba yi nihi, pe nawee- busãã wlaŋ le kapee- wãpyeŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Loo nde ga ba pee, le sya ta, nawee- busãã saa ba naa pe nampyeŋ- yãŋ nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wii ma -sẽ waha plãhã kuee ta kur ye ke kãnkai- byɛ wo, Yãhã ga ba u sya yaha. ");
INSERT INTO xrb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Le Yãhã kapãyĩĩ nde ga ba tɔ̃r kãntrahafa byɛ ye, pe byɛ n ke kai- cã. Loo na, ke driyɛ̃ ga cã kua.» ");
INSERT INTO xrb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kaplãŋ nkãy ke n taha, wii ma ke kal u yai u ke war yɔ̃! Yesu n maha yee: «Faale Yãhã kaplãŋ tɔ̃rfua Dãyɛl, tuu bii cĩĩnde kapihi gii wĩĩ pãã, yaa ba ke yãã Yãhã niisaha wo. ");
INSERT INTO xrb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Loo yale wo, mpãy pe ga ba pye Yudɛ wo, pe fã naa n gaha yãy kuɛ koho na. ");
INSERT INTO xrb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wii ma ba pye u gbegbaha yĩntraha wo, u ma syi yee woo ga tege dye nwoŋ wo, u wãn taa gbe yigi ye. U naa n fã. ");
INSERT INTO xrb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wii ma ba pye u tar wo, u ma syi yee woo nayrengbãŋ kuee kaha wo, woo ga dur ga ke gbe ye. U naa n fã. ");
INSERT INTO xrb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Too plii nde na, ca mpãy pe ma laha ne, tesẽ mpãy ne pe ma pii ne pe n wãr, pe fɛn ga ba gboho tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","-Ye naa Yãhã nar too fee plii nde ma syi sroŋ wɛrngbãn cãã ne, tesẽ kanii per ne ye! ");
INSERT INTO xrb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ye sẽ yãã, ma gbe driyɛ̃ wãtãhã na, ma sya ba waa yagaa na, too plii nde fɛn wãpee syi sẽ yãã yãã ye. Te syi saa maha ba yãã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yãhã ma ne yee ke sẽ yɛr kaa wãyikãã na te wãfãy plii yɛ̃ na ye, waa yĩŋ gɛ saa ne wloho yi ye. Ke -sẽ yɛr koo kaa wãyikãã na ke laampii wĩĩ na, mpãy ke yãŋ yi. ");
INSERT INTO xrb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Loo na, wii ma ye pye, a u Yãhã Yĩndefua ma nwo, u Yãhã Yĩndefua ma nwaala, yaʼa syi le sya ye! ");
INSERT INTO xrb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ye sẽ yãã, kawar Yãhã yĩndefa, tesẽ kawar Yãhã kaplãŋ tɔ̃rfa ne, pe ga ba yi. Pe ga ba naa yɛ̃kã wũhũ pye tesẽ laanwɔ wũhũ ne, pe naa nawee- wlaŋ. Mpãy gɛ Yãhã pe yãŋ yi, pe ma yee pe sẽ waha pe ya na ye, pe ga waha wlaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","-Ye luhu naa n yɔ̃! N nwo, tẽ ye cãã n yar ke kai- ne. ");
INSERT INTO xrb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Loo na, pe ma ba ye pye, a -ye yãŋ u ma drawaha fla wo, laa na u ma nwoŋ laam wo, ye ma n le sya ye! ");
INSERT INTO xrb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ye sẽ yãã, u Nawee Puee wãdurbaŋ ga ba pye mii yãhã wãyɛhɛ dyaŋ, ke ne ncaha byɛ gbe tã, nawee- byɛ n ke yãã. ");
INSERT INTO xrb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ye sẽ yãã, kakugu ma pye na, yãn ga te ya wãã ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Too fɛn plii nde ma kãhã tɛr wa, yai ga ba gbã tã, yroŋ saa ba pye cãã- ne ye. Yrompii ga ba kuã too kãntraha na; ke yãhãyĩŋ wãn byɛ ga ba gbã wlãhã te ya wo. ");
INSERT INTO xrb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Loo na, u Nawee Puee wãdurba kayar wĩĩ ga yãŋ cã gbaa na, yãhãyĩŋ na. Kãntraha terfa byɛ ga ba naa pe ya mii wũn. Pe ga ba u Nawee Puee yãã yãhãsyɔ̃r na, tuu n pai fãnga ne, maha yãhãyĩŋ nayɔ̃r ne kacãn saa pye ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tũũtũũ ma ba wuu, u Nawee Puee ga u yãhãyĩŋ tẽnlɛhɛ nɔ wãã driyɛ̃ teebɛhɛ byɛ wo. Nawee- mpãy tuu yãŋ yi, pe yãhãyĩŋ tẽnlɛhɛ ga pe byɛ wãã driyɛ̃ kur byɛ wo.» ");
INSERT INTO xrb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu n maha pe yar kakuãcran ne ma yee: «Nasar nkugu ke wo klaha lii ne, ye yai ye le cã. Ye sẽ yãã, ke katyigi ma kayampẽn yi, ma maha wampẽn fe, yaa cã ke wãsayale nɔ gbe taha. ");
INSERT INTO xrb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Koo syi dyaŋ, ye ma ba kai- ngĩĩ yãã ke n pye, ye -sẽ cã u Nawee Puee ma u dur n pai. ");
INSERT INTO xrb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ta n cĩĩnde nde pãã ye ye: Yagaafa byɛ saa ku tãŋ mii kai- ngĩĩ sẽ pye poo mpãy yĩnde na ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ke yãhãyĩŋ tesẽ ke kãntraha ne, te ga ba kua kãã te saa ba pye ye; ta kaplãŋ koo -sẽ na, koo ga nii wãkuayãã saa pye ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu n maha pe gbihi yar taha ma yee: «U Nawee Puee wãdurbaŋ ke n pai pye per gii, waa sẽ koo per cã tesẽ le yale ne ye. Pe yãhãyĩŋ tẽnlɛhɛ gɛ sẽ ke per cã ye. Ndoo ke Dya, ta bya sẽ ke per cã ye. Ta Tuhufua Yãhã ya ke le cã. ");
INSERT INTO xrb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kai- nkãy ke naa n pye faale wãdyaha Nuwɛ cãã na, koo syi kai- ke ga ba naa n pye u Nawee Puee wãdurba yale wo. ");
INSERT INTO xrb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ye cã, Nuwɛ cãã na, te driyɛ̃ lafir te sẽ ba yi wa ye, nawee- naa dir di ma naa n wɔ, ma naa ca sya ma naa pe pueesyam wãã naam kẽ, ma sya ba waa Nuwɛ wãdye per na ke salangbãŋ wo, kangbãŋ dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pe sẽ ba le sya ma yee laa ga ba pe dye cĩĩnde ye, te lafir n sya ba yi tã kãntraha byɛ na, ma nawee- byɛ boo tãŋ. U Nawee Puee wãdurbaŋ ga ba pye koo syi dyaŋ, nawee- saa ba le sya pe yee kai- ngĩĩ ga pe dye cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Koo per na, naam syãm syi ma pye tar wo pe ya tãy, pe ga ba nen yigi ba ra fla na, pe tyii u nen na. ");
INSERT INTO xrb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ca syãm syi ma pye pe tra tre pe ya tãy, pe ga ba nen gbe ba ra fla na, pe tyii u nen na. ");
INSERT INTO xrb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tee sẽ ndoo, ye Yĩŋfua, wãdurba per cã ye, yaʼa syi ye sã wãy faha yii na ye! ");
INSERT INTO xrb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","-Ye nde cã laha: Kahafua ma ne u yuhu payale cã ke yĩmper wo, u ga ne kuee yrãŋ na, u sye u yuhu ma n dye u kaha wo ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Loo ne, ye bya -ye yii gbihi naa n ta, yaliile tee sẽ ga yigi ye, u Nawee Puee ga ba dur ba loo yale wo.» ");
INSERT INTO xrb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu n maha yee: «Tẽntẽle wii syi kẽ u n sroŋ u yĩŋfua ye, ma maha kai- cã? Woo kẽ wii ne u yĩŋfua tɛr, ma u taha u naa u tẽntẽwai byɛ yãŋ, u naa pe dir wãã pe kẽ sediyale wo. ");
INSERT INTO xrb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","U yĩŋfua ma dur ba, maa u yãã loo tẽn na, woo tẽntẽle wĩĩ n tãy. ");
INSERT INTO xrb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ta n cĩĩnde nde pãã ye ye: U yĩŋfua ga u taha u koho wãn byɛ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","U tẽntẽle ma pee, u ga le ga yigi, a woo yĩŋfua saa pa yagaa ye. ");
INSERT INTO xrb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Loo na, u ga too u tẽntẽwai wãgbãŋ na, u ga naa n di, u sẽm wɔ naa n tɛr sẽnwɔfa ne. ");
INSERT INTO xrb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","U tẽntẽle tuu sẽ per gii ga yigi, tesẽ yale lii ne ye, u yĩŋfua ga pa koo na. ");
INSERT INTO xrb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U ga u pẽn cĩĩnde wãpẽn, tuu u pye pyer rii ne te yai dawarfa ne, u n naa n wũn, u naa nkãhã yĩhĩ.» ");
INSERT INTO xrb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu n maha kakuãcran nde gbã pe ye ma yee: «U Nawee Puee ma ba dur ba, Yãhã yai klo wãdyeŋ ga ba nii mii cabii sẽnsye mpãy wĩĩ dyaŋ. Pe cabii sẽnsye pe naalɔr gbe, ma yi ma n gaha cafuɛ̃ yigifua wããsaha wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pe laam wo, cabii bua pye napley, pe sẽ ba kai- cã ye. Bua mii -sẽ ba kai- cã, pe pye laantorfa. ");
INSERT INTO xrb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pe cabii napley n pe naalɔr gbe, pe sẽ sẽm- gbe yigi ye. ");
INSERT INTO xrb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pe cabii laantorfa poo n pe naalɔr gbe, ma suhu sẽm- ne ngaa laam wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","U cafuɛ̃ yigifua sẽ naa n pai ye, wãy n sya ba pe cabii byɛ yigi, pe n sã wãy. ");
INSERT INTO xrb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yĩndyaha n ba dye, waa n tẽ sya ma yee: ‹U cafuɛ̃ yigifua nwo, -ye ka yaa u wãã!› ");
INSERT INTO xrb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Loo na, pe cabii byɛ n yir wãy na, poo ga pe naalɔr gbihi, pe sẽm- mpãy le taha. ");
INSERT INTO xrb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pe cabii napley n pe laantorfa pye ma yee: ‹-Ye ye sẽm- mpãy laha wo kẽ! Ye sẽ yãã, wo naalɔr n fege wo ye.› ");
INSERT INTO xrb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pe laantorfa n pe yɛ̃ wãã sya ma yee: ‹Aye, sẽm- mpãy pe ma wo ye, pe saha wo lay yi ye lay ne ye. -Ye ka sẽm- parsaha fla wo, yaa mpãy par, ye le!› ");
INSERT INTO xrb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pe cabii napley n ka loo na sẽm- parsaha wo, u cafuɛ̃ yigifua n pa loo yale wo. Mpãy pe ba pe ya gbihi ta, pe n dye u cafuɛ̃ yigifua ne te cafãn didi nwongbãŋ laam wo, pe n ke nwonyɛ̃ tã tã. ");
INSERT INTO xrb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Loo kur ye, pe cabii bua mii n ba pa, maa tẽ sya ma yee: ‹Yĩŋfua, Yĩŋfua, ke nwonyɛ̃ yãr wo kẽ.› ");
INSERT INTO xrb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","U cafuɛ̃ yigifua n pe yɛ̃ sya ma yee: ‹Ta n cĩĩnde nde pãã ye ye, n sẽ ye cã ye.› » ");
INSERT INTO xrb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu tuu ke kaplãŋ pãã wa pe ye, u n pe yar taha ma yee: «Tee sẽ u Nawee Puee wãdurba per cã, ke yale ne ye, -ye ma n faha yãã yii na ye!» ");
INSERT INTO xrb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu n maha kakuãcran laa gbã pe ye u wãdurba wĩĩ na ma yee: «Ta wãdurba wĩĩ ga ba nii mii dya waa dyaŋ, tuu ga yrãhã yi. Tuu ga yrãhã yi, u n u tẽntẽ- yee ba, ma ba u koho wale le soho pe koho wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U n war milyɔ̃ bua le soho u tẽntẽ nen waa koho wo, ma milyɔ̃ syãm le soho waa koho wo, ma milyɔ̃ nen le soho u tãã wuhu koho wo. Tuu u tẽntẽ- cã wa, pe nanem ga waha yia pe tẽn lii tẽ, u n pe war la pe kẽ koo syi, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wii tuu pe war milyɔ̃ bua yãã, u n yir le yalebya wo, ma ga nii tẽn tẽ pe war ne, ma sya ba war milyɔ̃ bua mpãy yãã. ");
INSERT INTO xrb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wii tuu ba pe war milyɔ̃ syãm yãã, u bya n ga tẽn tẽ pe war ne, ma sya ba war milyɔ̃ syãm mpãy yãã. ");
INSERT INTO xrb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wii tuu -sẽ ba pe war milyɔ̃ nen yãã, u n ga wihi tugu kãntraha wo, ma u yĩŋfua war wũhũ yaha ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Le n ba ma- pe tẽntẽ- yĩŋfua n dur ba. U n nii pe yey, pe waha tẽn lii tẽ pe war ne. ");
INSERT INTO xrb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wii, u yĩŋfua ba war milyɔ̃ bua le soho u koho wo, u n yũhũ crã, ma pe war milyɔ̃ bua flɛ sĩĩ yar ma yee: ‹Yĩŋfua, ma ba war milyɔ̃ bua le soho ra koho wo. Yãŋ, n maha war milyɔ̃ bua mpãy yãã taha.› ");
INSERT INTO xrb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","U yĩŋfua n u pye ma yee: ‹Le yɔ̃; ma ma tẽntẽyɔ̃, ma maha n sroŋ. Ma sroŋ kasyĩmbɛhɛ wo; loo nde na n ga ma taha kai- nkãy na ke yĩŋ ke gbaha. Pa, wo n ba gbar.› ");
INSERT INTO xrb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tẽntẽ wii, u yĩŋfua ba pe war milyɔ̃ syãm le soho u koho wo, u bya n yũhũ crã, ma pe war milyɔ̃ syãm flɛ sĩĩ yar ma yee: ‹Yĩŋfua, ma ba war milyɔ̃ syãm le soho ra koho wo. Yãŋ, n maha war milyɔ̃ syãm mpãy yãã taha.› ");
INSERT INTO xrb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","U yĩŋfua n u pye ma yee: ‹Le yɔ̃; ma ma tẽntẽyɔ̃, ma maha n sroŋ. Ma sroŋ kasyĩmbɛhɛ wo, loo nde na n ga ma taha kai- nkãy na ke yĩŋ ke gbaha. Pa, wo n ba gbar.› ");
INSERT INTO xrb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Loo kur ye, wii u yĩŋfua ba war milyɔ̃ nen le soho u koho wo, u n yũhũ crã ma yee: ‹Yĩŋfua, n ba cã ma laam waha. Tar rii nawee- pe n war, ma n ta pe ma myaha taha re na. Dir rii nawee- pe n gbihi, ma n ta pe te le ma myaha pɛn wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","N ba fya, ma ga ma war wũhũ yaha kãntraha wo. Yãŋ, ma war mii, sya pe ne.› ");
INSERT INTO xrb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","U yĩŋfua n u yɛ̃ sya ma yee: ‹Tẽntẽ napee nwo, napar difua kẽ ma ne! Ma cã, tar rii nawee- pe n war, n n ta pe ta myaha taha re na. Ma maha cã, dir rii nawee- pe n gbihi, n n ta pe te le ta myaha pɛn wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ma ne pye ma ga ra war wãã fuɛ na war cãtrohosaha wo. Loo na, tẽ dur ba, n saa ne yãã la u war see, ta n sya?› ");
INSERT INTO xrb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Loo kur ye, u n pe nawee- pye ma yee: ‹-Ye pe war milyɔ̃ nen sya kãã u koho wo, ye pe wãã wii kẽ u ma pe war milyɔ̃ bua ne! ");
INSERT INTO xrb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ye sẽ yãã, wii ma pye ngaa ne, pe ga ba wãã taha u kẽ dege. Wii ma -sẽ yee u wee ngaa ne ye, car gii ke ma u koho wo, ke ga ba tyĩn sya kãã u ye. ");
INSERT INTO xrb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma yee u tẽntẽ nwo na, tuu saha laa yɔ̃ ye, -ye u gbe miy yi wãã nkur ye wam fla wo, u n naa n wũn, u naa nkãhã yĩhĩ.› » ");
INSERT INTO xrb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu n maha yee: «Yaliile wo u Nawee Puee ma ba pa u yãhãyĩŋ nayɔ̃r ne, pe yãhãyĩŋ tẽnlɛhɛ byɛ ne, u ga ba nii u nangbãŋ niisayũhũ wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Teebɛhɛ byɛ nawee- ga ba wãã ta u yaha ye, u n pe tyɔ̃r mii mbanaha dyaŋ, tuu mbaa tyɔ̃r n yi sẽngaa wo. ");
INSERT INTO xrb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","U ga pe mbaa ta u kãndigi kuɛ ye, tuu pe sẽngaa ta u kãmaŋ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Loo na, mpãy pe ga ba pye u yĩŋfua kãndigi kuɛ ye, u ga pe pye: ‹Ye wĩĩ n tãy ta Tuhufua Yãhã ye. -Ye pa, ye ba Yãhã Yai kayũhũ sya, kayũhũ nkãy ke bii cãã gbihi yaha wa ye kẽ, driyɛ̃ wãtãhã cãã na. ");
INSERT INTO xrb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ye sẽ yãã, fãã ba ra yigi, ye n ba dir wãã ra n di, koo kẽ. Loho fãã ba ra yigi, ye n ba loho wãã ra n wɔ. N pye nampay, ye n ba ra yigi yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nayroho sẽ pye ra ye ye, ye n ba kaa wãã ra n le. N pye yanfua, ye n ba ra traha. N pye nwompihi wo, ye n ba pa ra fla na maa ra yãŋ.› ");
INSERT INTO xrb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Loo na, pe nasroŋ ga ba u yɛ̃ sya pe yee: ‹Yĩŋfua, wo ma yãã na, fãã ba ma yigi, wo n ma kẽ dir ne ma n di, loho fãã ne, wo n ma kẽ loho ne ma n wɔ? ");
INSERT INTO xrb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma pye nampay teelii wo, wo n ma yãã, ma ma yigi yɔ̃? Wo ma yãã na, nayroho sẽ pye ma ye ye, wo n kaa wãã ma kẽ ma n le? ");
INSERT INTO xrb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma pye yanfua na, ma pye nwompihifua teelii wo, wo n ka maa ma yãŋ?› ");
INSERT INTO xrb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","U yĩŋfua ga pe yar, u yee: ‹Ta n cĩĩnde nde pãã ye ye: Tee naa kai- ngĩĩ pye ta nawee- kẽ, mpãy gɛ pe ma naflam, le ma mii ye naa ke pye ndoo gɛ kẽ.› ");
INSERT INTO xrb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Loo kur ye, mpãy pe ga ba pye u kãmaŋ kuɛ ye, u ga pe pye: ‹-Ye dey kãã ra na, Yãhã yoosẽn ma ye na! -Ye ka naa fla wo, naa gii wãfegeyãã wee ke na ye! Koo naa gbihi Setane kẽ, tesẽ u sãndãpee ne. ");
INSERT INTO xrb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ye sẽ yãã, fãã ba ra yigi, ye sẽ ngaa wãã ra n di ye, koo kẽ. Loho fãã ba ra yigi, ye sẽ loho wãã ra n wɔ ye. ");
INSERT INTO xrb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N pye nampay, ye sẽ ba ra yigi yɔ̃ ye. Nayroho sẽ pye ra ye ye, ye sẽ ba kaa wãã ra n le ye. N pye yanfua, n pye nwompihifua, ye sẽ pa maa ra yãŋ ye.› ");
INSERT INTO xrb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pe ga ba u pye pe yee: ‹Yĩŋfua, wo ba ma yãã na, fãã ba ma yigi, loho fãã ne, ma pye nampay, nayroho sẽ pye ma ye ye, ma pye yanfua, ma pye nwompihi wo, wo sẽ kayĩĩ pye ma kẽ ye?› ");
INSERT INTO xrb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","U Yĩŋfua -sẽ ga ba pe pye: ‹Ta n cĩĩnde nde pãã ye ye: Tee sẽ naa kai- ngĩĩ pye ta nawee- mpãy kẽ pe ma naflam ye, le ma mii ye sẽ naa ke pye ndoo gɛ kẽ ye.› » ");
INSERT INTO xrb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yesu n pe yar taha ma yee: «Poo mpãy pe wee nasroŋ ye, pe ga ba wãpẽn yãã, kii wãkuayãã wee ke na ye. Mpãy pe -sẽ ma nasroŋ, pe ga ba cĩĩnde yrã yãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu tuu kaplãŋ ngĩĩ byɛ pãã wa, u n u kãnyãrwai pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ye cã te syayaha gbar ma plii sĩĩ wo. Loo yale wo, u Nawee Puee ga ba yi nawee- kẽ, pe n u kuey mar boo trã na.» ");
INSERT INTO xrb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pe Yãhã yũndefa yĩŋfa n pe ya wãã pe wãlɛ ne, u Yãhã yũndefa yĩŋfua kaha wo. U myaha ba kẽ Kayifu. ");
INSERT INTO xrb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pe n le pãã ta poo ga Yesu yuhu yigi, pe u boo. ");
INSERT INTO xrb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe n le pãã ma yee: «Wo saha u yigi te gbaryale wo ye. Mii loo sẽ ne ye, pe nawee- ga waha yir pe yee, le sẽ yai poo ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu pye Gbetane wo, Syimu kaha wo, Syimu wii tuu pye gber. ");
INSERT INTO xrb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Cɔɔ waa n pa u tãy, yablater ntẽmblaha bule ne u koho wo. Lasekole waa ter pye le wo, nawãm sẽ naa u dir yey ye. Yesu pye u naa n di, u cɔɔ n u lasekole woo u yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pe kãnyãrwai pe loo yãã, le sẽ tãy pe ye ye, pe n nii le pãã ma yee: «Kaklaha- ne nde! ");
INSERT INTO xrb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pe ma ne lasekole nwo par, ma wangbãy yãã ma wãã fɛnfa kẽ, loo sẽ puar la?» ");
INSERT INTO xrb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu n -sẽ cã pe ne, ma pe pye ma yee: «Ye tyii u cɔɔ na, u kayĩĩ pye ra kẽ! ");
INSERT INTO xrb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ye sẽ yãã, yalebyɛ fɛnfa ma ye ne. Ndoo -sẽ nwo, n saa ba pye ye ne per gaa ye. ");
INSERT INTO xrb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ye sẽ cã la, u cɔɔ tuu lasekole nwo woo ra kadye na, ta nakugu kẽ tuu gbihi wa gbĩĩ wãleŋ na? ");
INSERT INTO xrb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta n cĩĩnde nde pãã ye ye: Pe ma ba le Yãhã kapãyĩĩ wũhũ tɔ̃r teelii teelii kãntraha nge na, pe ga u cɔɔ nwo bya wĩĩ pãã, lii tuu pye ra kẽ. U wĩĩ ma syi le faha yãã nawee- na ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pe Yesu kãnyãrwai sẽnsye syãm mii wo, waa pye pe naa u yee Syikaryɔtefa Yuda. U n yir, ma ka pe Yãhã yũndefa yĩŋfa fla na, ");
INSERT INTO xrb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ma ga pe pye ma yee, a woo ma Yesu yi pe kẽ, pe ga woo kẽ nwa ne? Pe n wargbɛ warpii gbey sẽnsye tɔ̃r, ma pe wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yuda n ta tɛr nii Yesu wãyi wĩĩ kɛ pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te gbar rii Yiifee- sẽ ncasur bur di ye, te ba nɔ wa. Ke per cir na, Yesu kãnyãrwai n u yey ma yee: «Ma laam wo, ma yee too ga te syayaha gbar dir yĩntaha yi na ma kẽ?» ");
INSERT INTO xrb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Loo na, Yesu n waa yar pe na, pe ka woofua fla na, le klo laam wo, pe ga u yar pe yee: «Wo Yĩŋfua yee: Ta yale nɔ wa; n ga ba te syayaha gbar dir di ma fla na, ta kãnyãrwai ne.» ");
INSERT INTO xrb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu tuu pe kãnyãrwai yar mii, pe n pye koo syi, ma ga te syayaha gbar dir yĩntaha yi. ");
INSERT INTO xrb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yainkɔŋ wo, Yesu pye u ba draŋ nii, ma naa n di u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pe n nii n di, Yesu n yee: «Ta n cĩĩnde nde pãã ye ye: Ye laam wo, waa ma u ga ra yi ta napĩĩ- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Le n pe byɛ laam wlãhã, pe n nii u yey pe ya wuhu na ma yee: «Yĩŋfua, ndoo la?» ");
INSERT INTO xrb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu n pe yɛ̃ sya ma yee: «Wii tuu u koho wãã le ra ne wãcɛŋ tasa laam wo, woo tuu ga ba ra yi ra napĩĩ- kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cĩĩnde ne, u Nawee Puee ga ku mii le yrũhũ ta nii Yãhã sabangbãŋ wo mii. Wii fɛn te -sẽ ga cã pee, woo kẽ wii ne tuu u yi u napĩĩ- kẽ; myaha ne, u ma ne see gɛ see ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda wii, tuu ne ga ba u yi u napĩĩ- kẽ, u n kapãn gbe ma yee: «Yĩŋfua, ndoo la?» Yesu n u yɛ̃ sya ma yee: «Ma le pãã.» ");
INSERT INTO xrb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pe naa n di, Yesu n bur gbe, ma syaha kẽ Yãhã ye, ma ke la cɛr wãã u kãnyãrwai kẽ ma yee: «-Ye sya di, ke ma ta kadye draha wo.» ");
INSERT INTO xrb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","U n maha defĩĩ sekuyĩĩ gbe, ma syaha kẽ Yãhã ye, ma le sekuyĩĩ wãã pe kẽ ma yee: «Ye byɛ -ye wɔ! ");
INSERT INTO xrb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Pe ma ta ntɔ̃r draha wo, ta tɔ̃r rii te ga woo, nabuar ntãŋ n cã dye Yãhã tãy, naambiyãrfãn tii ke bii le pe ne te n cã yĩntaha ta. Loo na, nabuar kapee- ga laha kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta n le pãã ye ye: N saa maha defĩĩ wɔ yãã kãntraha nge na ye. N ga ka Yãhã yai klo wo, n cã ga koo fla defĩĩ wɔ ye ne.» ");
INSERT INTO xrb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Loo kur ye, pe n Yãhã sey yay taa ne, ma yir ma ka te wolifyɛ katyir yãŋ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ke wolifyɛ katyir yãŋ yĩŋ na, Yesu n u kãnyãrwai pye ma yee: «Nanga yĩmper wo, ye byɛ ga ba dur yi ta kur ye. Le ma le yrũhũ ta yaha Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹N ga ba u mbanaha gbã boo, pe mbaa byɛ n fã cããŋ.› » ");
INSERT INTO xrb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yesu n maha pe yar taha ma yee: «Ta wãku kur ye, n ma ba yir gbã wo, n ga ba cãã tɛr ye yaha Galɛlɛ kãntraha wo.» ");
INSERT INTO xrb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pyar n kapãn gbe, ma u pye ma yee: «Mii byɛ ma sya ga ba dur yi ma kur ye, ndoo saa yi kãã yãã ma kur ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu n u pye ma yee: «Ta n cĩĩnde nde pãã ma ye: Ke nanga yĩmper nge bya wo, ngupuai saa kui gɛ kui wa ye, maa ta wĩĩ kai tɛhɛ tãã, ma yee ma sẽ ndoo cã ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pyar n u yɛ̃ sya ma yee: «N saa ba le kai n yee, n sẽ ma cã ye, n ma sya ga gbã ku ma ne.» Pe kãnyãrwai mii byɛ n loo nen ya pãã pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Loo kur ye, Yesu n ka u kãnyãrwai ne fla ngaa wo pe n yee Gesanɛ. U n pe pye ma yee: «-Ye nii kuee nwo, ta n ka yaha ye, n ga Yãhã nar.» ");
INSERT INTO xrb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","U n Pyar yigi taha u ya na, pe Sewede pii syãm ne. U laam ba nii n wlãhã u ye, u ntãŋ n maha nii u cɛr. ");
INSERT INTO xrb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","U n pe pye ma yee: «Ta laam byɛ wlãhã, ma nii mii gbãku wĩĩ laa dyaŋ. -Ye kuee nwo wo ra ne, ye ma syi ye sã wãy ye!» ");
INSERT INTO xrb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","U n faa ka yaha ye, ma ga kãnklũy gbãã, ma yĩŋ kuɛ le ma pãã Yãhã ne ma yee: «Yãhã, ra Tuhufua, ma n yia kai- byɛ na. Le kayĩhĩ yale kuã tɛr ra na, lii le n pai nde. N sẽ -sẽ yee ta laam wĩĩ le pye ye, ma laam wĩĩ loo le naa n pye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tuu loo pãã wa, u n dur ba u kãnyãrwai tãã mii fla na, ma ba pe yãã pe sã wãy. U n Pyar pye ma yee: «Ye sẽ waha kuee yrãŋ yale nen gɛ ra ne ye! ");
INSERT INTO xrb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ye byɛ, yaʼa syi maha sã wãy ye! -Ye naa Yãhã nar, ye ma syi ye ba dye kapee- wãpyeŋ wo ye! Nawee laam yĩĩ kayũhũ wãpye wĩĩ ne, u -sẽ nɔ gbɛr ke wãpyeŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","U n maha tɛr u ya ya yahasee ye, ma maha ga pãã Yãhã ne ma yee: «Ta Tuhufua, wãfãy nge ma yee ke saha kuã tɛr ra na ye, lii le ma ma laam wĩĩ, ma loo pye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","U n dur ba, ma maha ba u kãnyãrwai yãã wãy na; pe wãy n sya naa pe yĩnkaasyikuey ndege pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","U n tɛr pe yaha, ma ka yaha ye, ma ga koo kaplãŋ tee nen ya pãã Yãhã ye, ke tɛhɛ tãã wuhu na. ");
INSERT INTO xrb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Loo kur ye, u n ka u kãnyãrwai fla na, maa pe pye ma yee: «Ye maha sã wãy, ma n wũũ kɛ. Le nde, le yale nɔ wa. -Ye naa n yãŋ, pe ga u Nawee Puee yi kapeepyefa kẽ yagaa. ");
INSERT INTO xrb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","-Ye yir wo n tɛr! Ye sẽ yãã, dya wii tuu ra yi ta napĩĩ- kẽ, u nwo u n pai.» ");
INSERT INTO xrb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu naa n pãã nantãŋ, Yuda n pa. Pe kãnyãrwai sẽnsye syãm mii waa ba kẽ u ne. Nabuar raa pye u ne, yũntruɛ̃ ne pe ye koho wo, tesẽ kãhã ne. Yãhã yũndefa yĩŋfa, ma suhu pe wãlɛ ne, poo me pe ba pe lɛhɛ wãã, pe ba Yesu kɛ yigi. ");
INSERT INTO xrb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","U Yuda wii tuu ba yi kãã Yesu kur ye, u n pe nawee- yar yaha naambiyãr syaha gaa ter ne, pe n waha Yesu cã. U ba pe pye ma yee: «Dya wii tẽ ga ba syar naambiyãr syaha ne, yaa cã woo kẽ tee n kɛ, ye ba u yigi.» ");
INSERT INTO xrb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuda n ta tɛr yũhũ crã Yesu na, ma u syar ma yee: «Yĩŋfua, n ma syar,» ma u syar ke naambiyãr syaha ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu n u pye ma yee: «Ta naambiyã, taa pa lii na, le pye!» Pe nawee- n -sẽ yũhũ crã, ma koho taha Yesu na, ma u yigi. ");
INSERT INTO xrb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesu kãnyãrwai mpãy pe pye u ne, poo nen waa n yũntrũhũ kuã, ma Yãhã yũndefa yĩŋfua tẽntẽle gbã, ma sya ndityɛ gbã cɛr kãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu n u pye ma yee: «Ma yũntrũhũ le yaha ke niisaha wo; ma sẽ yãã, mpãy byɛ pe yũntrũhũ gbe pe nampyeŋ- na, pe yũntrũhũ gbã ku. ");
INSERT INTO xrb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ma laam wo ma yee la, n saha ra Tuhufua Yãhã nar u n yãhãyĩŋ tẽnlɛhɛ seraasyi ndreŋ sẽnsye syãŋ syi wãã ra kẽ, tahar ne, ke yagaa nge na ye? ");
INSERT INTO xrb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kai- nkãy ke -sẽ n pye yagaa, ke ma ke yrũhũ yaha Yãhã sabangbãŋ wo ma yee, ke yai ke pye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yesu tuu loo pãã wa, u n wã klaha ma pe nabuar pye ma yee: «Tee pa ra yigisaha wo yũntruɛ̃ ne tesẽ kãhã ne, kapeepyefua la ra ne? Plii byɛ n pye n ba tege nii ye ne, ma naa nawee- klaha Yãhã kangbãŋ laam wo, ye sẽ -sẽ ra yigi koo fla na ye. ");
INSERT INTO xrb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yãhã kaplãŋ tɔ̃rfa pe bii cãã kai- nkãy yar yaha, koo kẽ ke n pye yagaa.» U kãnyãrwai byɛ n fã tɛr u yaha. ");
INSERT INTO xrb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mpãy pe ba Yesu yigi, pe n ka u ne Yãhã yũndefa yĩŋfua Kayifu fla na. Pe Yãhã kaiyarfa pye pe ba pe ya wãã ke fla na, ma suhu pe wãlɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pyar -sẽ pye u yuhu dey naa n taha Yesu na, ma sya ga dye u Yãhã yũndefa yĩŋfua kaha wo, ma tege nii wlãhã pe kaha sẽŋfa ne, woo ga le kuasaha yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pe Yãhã yũndefa yĩŋfa tesẽ pe kaplãŋ cɛrfa byɛ ne, pe n nii kapee- kɛ gbe pãã n taha Yesu na, kapee- nkãy syi ke ga waha ta, pe n yee Yesu yai wãboo ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nawee- busãã n kawar fua naa n taha Yesu na, pe sẽ -sẽ waha laa yãã, lii syi le u wãboo wĩĩ kua ye. Nawee- syãm mpãy n pa kur kuɛ ye, ma ba yee: ");
INSERT INTO xrb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Dya nwo yee, woo ga waha ke Yãhã kangbãŋ yoho pye klaha-, tuu dur u ke fãã plii tãã nsoho wo.» ");
INSERT INTO xrb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","U Yãhã yũndefa yĩŋfua n yir, ma Yesu pye ma yee: «Nkãy nawee- mii pe pãã n taha ma na, ma saa pe yɛ̃ wãã sya la laa ne?» ");
INSERT INTO xrb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu n yaha le. U Yãhã yũndefa yĩŋfua n u yey ma yee: «Ndoo tesẽ ke Yãhãngbãŋ ne, wo yar nde ne: Mboo la u Yãhã Yĩndefua Crise, u Yãhã Dya?» ");
INSERT INTO xrb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu n u yɛ̃ sya ma yee: «Ma le pãã. Ma gbe yagaa na, ye ga ba u Nawee Puee yãã, tuu tege nii kai- byɛ yĩŋ na, Yãhãngbãŋ kãndigi koho kuɛ ye. Yaa maha ba u yãã tuu n pai yãhãsyɔ̃r yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","U Yãhã yũndefa yĩŋfua, tuu Yesu kaplãŋ ngĩĩ luhu, u laam n war u n sya u ya nayrɛ tyĩn cɛr, ma pe nawee- pye ma yee: «U n gbar Yãhã ne. Wo sẽ maha laa kɛ waa ye u wĩĩ na ye. Tuu n gbar Yãhã ne, ye byɛ le luhu, ah ye lii yãã le na?» ");
INSERT INTO xrb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pe nawee- byɛ n yee, a Yesu yai wãboo ne. ");
INSERT INTO xrb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pe n ta tɛr yir, ma nii yɛ̃syɔ̃r tu n woo Yesu na, ma nii u gbã kãntaklo ne, ma nii u fey, ma n yee: ");
INSERT INTO xrb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Ma sẽ yee la u Yãhã Yĩndefua Crise kẽ ma ne? Yoo u ma gbã? Le cã mii ya, taa wo yar.» ");
INSERT INTO xrb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kai- ngĩĩ pyeyale wo, Pyar -sẽ pye u ba tege nii nkur ye, kãndi wo. Tẽntẽsyalaale n yũhũ crã u na, ma u pye ma yee: «Ma bya pye u Galɛlɛ kãntrahafa Yesu ne.» ");
INSERT INTO xrb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pyar n le kai nawee- byɛ yĩnde na ma yee: «Taa lii pãã, n sẽ le cã ma ne ye.» ");
INSERT INTO xrb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","U n yir, ma yãr n gaha kapahayɛ̃ kuɛ ye, tẽntẽsyalaale n maha u yãã. Mpãy pe pye ke fla na, le n pe pye ma yee: «Nwo bya pye u Nasarɛtefa Yesu ne.» ");
INSERT INTO xrb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pyar n maha le kai, ma sya Yãhã di ma yee, woo sẽ dya nwo cã ye. ");
INSERT INTO xrb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Saa n pye, mpãy pe pye ke fla na, pe n yũhũ crã, ma Pyar pye ma yee: «Le ga waha pye cĩĩnde, poo nawee- mii nen waa kẽ ma ne, ma pe yor pãã.» ");
INSERT INTO xrb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pyar n -sẽ nii le pãã n waha ma yee: «Ndoo sẽ kẽ ye rɛhɛ! Ke ma pye kawar tẽ n fua, Yãhã ke ra pẽn! Ndoo tesẽ ke Yãhã ne, n sẽ u dya cã ye ne ye.» Le yalebya wo, ngupuai n kui. ");
INSERT INTO xrb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pyar laam n too Yesu kaplãŋ na, tuu ba yee: «Ngupuai saa ba kui wa ye, ma -sẽ ga ba ra wĩĩ kai tɛhɛ tãã, ma yee ma sẽ ra cã ye.» U n yi nkur ye, ma too mii na, ma nii n wũn. ");
INSERT INTO xrb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yĩŋ ke kãhã syii wa, pe Yãhã yũndefa yĩŋfa n pe ya wãã pe wãlɛ ne, pe ga waha Yesu boo mii syi dyaŋ pe le cã. ");
INSERT INTO xrb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Loo kur ye, pe n ta pe n Yesu pua, ma ka u ne u fãngafua Pɔ̃syi Pilati fla na. ");
INSERT INTO xrb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Koo kai- ngĩĩ kur ye, Yuda wii tuu ba Yesu yi u napĩĩ- kẽ, tuu yãã pe Yesu wãboo wĩĩ ta, naniicã n u yigi. U n yir, ma ga pe wargbɛ warpii gbey sẽnsye dur wãã pe Yãhã yũndefa yĩŋfa kẽ, pe wãlɛ ne, ma pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Wii tuu sẽ kapee pye ye, n ta pe n ga ba u boo; le naniicã ra yigi.» Pe n u yɛ̃ sya ma yee: «Le wo gbe lii ne? Ma wĩĩ ne le ne.» ");
INSERT INTO xrb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda n pe war miy yaha ke Yãhã kangbãŋ wo, ma yi ma ga u ya yoŋ boo. ");
INSERT INTO xrb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pe n pe war gbe, ma yee nawee ntɔ̃r wãwoo dir kẽ, pe sẽ yai pe pe wlãhã ke Yãhã kangbãŋ diŋ war ne ye. ");
INSERT INTO xrb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pe n pãã ta, ma ga poor tẽntẽfua waa tar par, ma ta nampay nakur lesaha. ");
INSERT INTO xrb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Loo ne, pe n nii too tar nde yee te ntɔ̃r tar, ma sya ba waa ke nanga na. ");
INSERT INTO xrb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Faale Yãhã kaplãŋ tɔ̃rfua Yermii tuu bii kaplãŋ nkãy cãã pãã yaha, koo kẽ ke pye. U bii yee: «Pe n pe wargbɛ warpii gbey sẽnsye gbe. Yiisrɛfa mpãy ba pãã ta, ma poo war dãã u wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pe n poo war ta, ma u poor tẽntẽfua tar par, mii Yĩŋfua Yãhã bii ra yar mii.» ");
INSERT INTO xrb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pilati n Yesu sãhã. U n Yesu yey ma yee: «Mboo la pe Yiifee- Yĩŋfua?» Yesu n u yɛ̃ sya ma yee: «Ma le pãã.» ");
INSERT INTO xrb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pe Yãhã yũndefa yĩŋfa ma suhu pe wãlɛ ne, pe n kai- kɛ gbe pãã n taha Yesu na, Yesu sẽ laa wãã sya pe ye ye. ");
INSERT INTO xrb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Loo na, Pilati n u pye ma yee: «Ma sẽ n luhu la kai- ngĩĩ byɛ ye, pe pãã n taha ma na?» ");
INSERT INTO xrb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu n yaha le, u sẽ kapãn laa ter wãã sya ye; loo n yɛ̃ gbãã u Pilati na. ");
INSERT INTO xrb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dyɛ- byɛ, syayaha gbar ma nɔ, u fãngafua ma ne nwompihifua waa yi yaha, wii nawee- pe ne yãŋ yi. ");
INSERT INTO xrb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nwompihifua waa -sẽ pye, pe naa u yee Barebaa. U myaha ba yi u kapee- wãpye wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nawee- pe ba nihi ke fla na, Pilati n pe yey ma yee: «Ye yee, n wii woo yi yaha ye kẽ, Barebaa laa, Yesu wii pe n yee u Yãhã Yĩndefua Crise?» ");
INSERT INTO xrb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","U ba cã, pe Yesu yigi ba u kẽ laanyar na. ");
INSERT INTO xrb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","U Pilati pye nantãŋ te kasãhã na, u cɔɔ n lɛhɛ wãã u ye, ma u yar, laa ma syi le dye pe nsoho wo u nasroŋ nwo ne ye, a woo tee mlũhũpihi wãy tɛr u wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pe Yãhã yũndefa yĩŋfa -sẽ mii, pe wãlɛ ne, pe ba pe nabuar sũũ wa, a pe Barebaa woo wãyiyaha wĩĩ pãã, pe Yesu wãboo wĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","U Pilati n kapãn gbe, ma pe yey ma yee: «Ye yee, n wii woo yi yaha ye kẽ pe syãm mii laam wo?» Pe n yee Barebaa. ");
INSERT INTO xrb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilati n pe pye ma yee: «Ah u Yesu wii pe n yee u Crise, n ga woo pye mii?» Pe byɛ n yee: «U yai pe u kuey mar boo trã na.» ");
INSERT INTO xrb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilati n yee, a nwa kapee u pye? Pe nabuar n le gbey pãã fãnga ne ma yee: «U yai pe u kuey mar boo trã na.» ");
INSERT INTO xrb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilati tuu yãã, u sẽ naa u laam wĩĩ yãã ye, kaa n cã maha n taha pe nawee- gbleŋ na, u n loho gbe, ma u kluɛ yee pe nabuar yĩnde na, ma pe yar ma yee: «Ta kalaa wee u nasroŋ nwo ntɔ̃r wãwoo wĩĩ na ye. Ye yĩŋ wĩĩ ne le ne.» ");
INSERT INTO xrb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te nabuar byɛ n u yɛ̃ wãã sya ma yee: «Ãwã, u ntɔ̃r wãwoo wĩĩ, le nii wii yĩŋ wĩĩ tesẽ wo pii ne!» ");
INSERT INTO xrb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Loo na, Pilati n Barebaa yi yaha pe kẽ. U n ta pe seraasyi n Yesu gbã sãngblã ne, u n maha pe ta pe ga u kuey mar yaha trã na. ");
INSERT INTO xrb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","U fãngafua seraasyi mpãy n Yesu yigi yi u fãngafua tẽntẽsaha kangbãŋ ndyin wo, ma dur ma ke seraasyi ndreŋ byɛ yee ba. ");
INSERT INTO xrb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pe n ba nii u lɛr. Pe n u nayrɛ fɛr u na, ma dur ma yĩŋfua nayreyãhã le u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pe n ngur maha ta u yĩŋ na yĩŋfua nkifai dyaŋ, ma kipua kãi le soho u kãndigi koho wo. Loo kur ye, pe n maha nii u lɛr, ma kãnklũy gbãã u yaha ye, ma nii u syar ma n yee: «Wo ma syar Yiifee- Yĩŋfua!» ");
INSERT INTO xrb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe n nii yɛ̃syɔ̃r tu n woo u na, ma nii le kipua kãi sya u ye, ma gbã n le u kẽ yĩŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pe ba u lɛr wa, pe n yir ma ke yĩŋfua nayreyãhã yi kãã u na, ma u faale nayrɛ le u na. Pe n yi ga u ne nkur ye, pe n gaha u kuey mar yaha trã na. ");
INSERT INTO xrb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pe seraasyi pe yi, pe n nampay waa wãã sya, u pye Syirɛ̃fa naa. Pe n u ta u n Yesu kueymartrã tẽŋ fãnga na. U myaha ba kẽ Syimu. ");
INSERT INTO xrb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe n ga nɔ teelaa wo, pe n yee Gblegbeta, le yĩntaha kẽ, yĩnkluhu fla. ");
INSERT INTO xrb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pe n defĩĩ wlãhã tyinsruhu ne, ma wãã Yesu kẽ tuu sya wɔ. Tuu pe wɔ yãŋ, u n pe sye. ");
INSERT INTO xrb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pe seraasyi, pe Yesu kuey mar yir yaha wa trã na, pe n pyer raa pye, pe waha cã pe ga Yesu nayrɛ la mii syi dyaŋ. Pe n te la koo syi. ");
INSERT INTO xrb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Loo kur ye, pe n tege nii, ma nii u sẽŋ. ");
INSERT INTO xrb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tuu kai lii pye, pe n u kuey mar yaha trã na, pe n le yrũhũ gbãã yaha u yĩŋ kuɛ ye le trã na ma yee: «yesu kẽ nwo ne, yiifee- yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pe n maha kapeepyefa syãm mpãy kuey mar yir yaha trãŋ na pe ya wuhu na. Nen nwo Yesu kãndigi kuɛ ye, nen nwo u kãmaŋ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kãntɛrfa naa u tyɛhɛ, ma naa yĩŋ figi u na, ma naa n yee: ");
INSERT INTO xrb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Mboo taa naa n yee, a ma ga waha ke Yãhã kangbãŋ cããr, taa dur ma ke fãã plii tãã nsoho wo, ma saa mii sya yaha la yagaa? Maʼa pye Yãhã Dya, ma tege kãã le trã na kɛ!» ");
INSERT INTO xrb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pe Yãhã yũndefa yĩŋfa, ma suhu pe Yãhã kaiyarfa ne, ma suhu pe wãlɛ ne, pe bya naa u lɛr ma naa n yee: ");
INSERT INTO xrb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«U nawee- mpãy sya yaha, u sẽ -sẽ ga waha u yĩŋ yi yaha ye. Le ma pye u ma Yiisrɛfa Yĩŋfua cĩĩnde, u tege kãã yagaa le trã na kɛ! Wo yĩnde ma loo yãã, waa u wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U u ya le soho Yãhã koho wo; le ma pye u wĩĩ n tãy Yãhã ye, ke u sya yaha yagaa. U sẽ yee la woo kẽ u Yãhã Dya?» ");
INSERT INTO xrb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kapeepyefa mpãy pe ba kuey mar yir yaha trãŋ na pe ya wuhu na u ne, pe bya naa u tyɛhɛ koo syi pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma gbe yaiwlaŋ yale wo, ma sya ba yai yĩn, wam mpãy syi n paha tã le klo kur byɛ na. ");
INSERT INTO xrb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yaiyĩn yale n ba nɔ, Yesu n tẽ sya fãnga ne ma yee: «Yelɔyi, Yelɔyi, lema sebaketani.» Koo yĩntaha kẽ: «Yãhã, Yãhã, nwa ma n ra miy yaha?» ");
INSERT INTO xrb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nawee- mpãy pe pye ke fla na, pe n le luhu, ma le pãã, a u ma u faale Yãhã kaplãŋ tɔ̃rfua Yeli yee. ");
INSERT INTO xrb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Poo nen waa n ta tɛr fã ga, maa flũhũflũhũ wãŋ gaa kã le defĩĩtãhãpihi gaa wo, ma ke yi ba kã gbãã kipua kãi na, ma ke wãŋ kuã yir wãã Yesu kẽ, tuu u defĩĩ wãr naa n wɔ. ");
INSERT INTO xrb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe nawee- n nii u pye ma n yee: «Tyii wo n yãŋ, ncã Yeli ga ba u sya yaha, laa.» ");
INSERT INTO xrb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu n maha tẽ sya fãnga ne, ma ku. ");
INSERT INTO xrb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Loo yalebya wo, Yãhã kangbãŋ nwonuŋ nwonyɛ̃ faasrɛŋ gii ke ba pua tã menmen ke nwonyɛ̃ na, ke n fe jũũ flɛ sĩĩ, ma gbe ncaha ye ma tege tãã ye. Kãntraha n sege, ntẽmbangbãy n fe yoho. ");
INSERT INTO xrb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gbũhũ n fe yãr, Yãhã nawee- mpãy pe ba ku faale wo, poo mpãy n yir gbã wo, ma nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu tuu ba yir gbã wo, ma dur ba yrãŋ na gbaafa ye, loo kur ye, pe Yãhã nawee- mii n dye le Yãhã kungbãy Yurusalɛm laam wo, ma pe ya yar nabuar na. ");
INSERT INTO xrb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","U seraasyi yĩŋfua, ma suhu mpãy ne pe pye u ne ma naa Yesu sẽŋ, pe ke kãntraha wãsege yãã, ma suhu kai- nkãy byɛ ne ke pye loo yale wo, pe n sroŋ fya ma nii n yee: «Dya nwo pye Yãhã Dya cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ca mpãy pye, pe ba dey yɛr Yesu wãkueymar trã na, ma naa ke kai- yãŋ. Poo ca mii ba yir Yesu ne Galɛlɛ kãntraha na, ma naa n taha u na, ma naa tẽŋ nkãy tẽ u kẽ tesẽ u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pe laam wo, Madalafa Maari pye, tesẽ Maari waa ne wii tuu pye Syake ye nahafua Yosɛfe ne, ma suhu Sewede pii nahafua ne. ");
INSERT INTO xrb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yai ke ba kua wa, Yarimatefa nangbãŋ gaa n pa. U myaha ba kẽ Yosɛfe, u ba pye Yesu kur ye. ");
INSERT INTO xrb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U n ka Pilati fla na, ma ga Yesu nakugu nar u ye. Pilati n ta pe n ke wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","U Yosɛfe n ke nakugu gbe, ma faafĩĩ laa maha tã ke na, ");
INSERT INTO xrb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma ga ke le u myaha gbĩĩfuɛ̃ wo, le ba gbã fer ntẽmblaha wo. Tuu Yesu nakugu le wa loo gbĩĩ wo, u n ntẽmbangbãŋ gaa kloŋ ba paha tã le gbĩĩ yɛ̃ na, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madalafa Maari pye, u ba tege nii le gbĩĩ yahasee ye, ma suhu u Maari nen nwo ne. ");
INSERT INTO xrb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ke yĩŋsyii pye kanii per, pe Yãhã yũndefa yĩŋfa, tesẽ pe Farisyɛ̃ ne, pe n pe ya wãã ga Pilati fla na. ");
INSERT INTO xrb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Pe n ga u pye ma yee: «Yĩŋfua, wo sẽ faha ye, dawarfua nwo tuu sẽ ba ku wa ye, u ba yee, a plii tãã woo wãku kur ye woo ga ba yir gbã wo, u dur ba yrãŋ na gbaafa ye. ");
INSERT INTO xrb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Seraasyi ta, pe n le gbĩĩ sẽŋ te plii tãã nde na, mii loo sẽ ne ye, Yesu kãnyãrwai ga waha ba u nakugu yuhu yi, pe ga nawee- pye, a ter u ma u yir gbã wo, ma dur ba yrãŋ na gbaafa ye. Too kur kuɛ kawar nde ga waha ba pee tɛr faale wãn yaha.» ");
INSERT INTO xrb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilati n pe pye ma yee: «-Ye seraasyi mpãy gbe, pe n ga naa le gbĩĩ sẽŋ, mii le yai ye ye mii.» ");
INSERT INTO xrb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pe n tɛr, ma ga le gbĩĩ yɛ̃ fla maan tã, ma le gbĩĩ sẽŋfa ta. ");
INSERT INTO xrb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ke kanii per ba tɛr wa, koo yĩŋsyii kẽ cãwãã per cir. Koo per sukũhũntãy na, yĩnwɔŋ wo, Madalafa Maari ma suhu u Maari nen nwo ne, pe n yir ga le gbĩĩ yãŋsaha wo. ");
INSERT INTO xrb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kãntraha n yɛhɛ fãnga ne, yãhãyĩŋ tẽnlɛhɛ waa n tege yãhãyĩŋ na, ma ba ke ntẽmbangbãŋ kloŋ kãã le gbĩĩ yɛ̃ na, ma nii ke yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U naa n yɛhɛ mii yãhã wãyɛhɛ kalkal wãŋ syi dyaŋ. U nayrɛ pye wãfir perper mii sesantĩhĩ wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Le gbĩĩ sẽŋfa n nii n sege fyar koho wo, ma sɛr yigi nii ke fla na mii cĩĩnde nakur dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","U yãhãyĩŋ tẽnlɛhɛ n yɛ̃ kuã ma pe ca pye ma yee: «Yii poo na, ye ma n fya ye! Yesu wii pe kuey mar boo trã na, n cã woo kẽ ree n kɛ. ");
INSERT INTO xrb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","U wee nwo ye. Tuu ba le yar mii, u yir gbã wo, ma dur ba yrãŋ na gbaafa ye. U nakugu ke ba sãy ta na, -ye pa ye ba ke fla yãŋ, ");
INSERT INTO xrb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","-tee ta tɛr ga, yaa u kãnyãrwai yar ye yee, u yir gbã wo, ma dur ba yrãŋ na gbaafa ye. -Ye yãŋ, u ga ba cãã tɛr ye yaha Galɛlɛ kãntraha wo; koo fla kẽ tee n gaha u yãã. Koo kai- ngĩĩ kẽ tẽ ba yee, n ga pãã ye ye. Tẽ ye yar mii, le ga nii koo syi.» ");
INSERT INTO xrb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","U yãhãyĩŋ tẽnlɛhɛ kaplãŋ n nuhu yigi pe ca kẽ, pe -sẽ maha ba fya. Pe n tɛr kãã le gbĩĩ fla yaha farfar, ma n fã ma n gaha ke kai- tɔ̃r Yesu kãnyãrwai ye. ");
INSERT INTO xrb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesu n pe wãã kãnde wo, ma pe syar ma yee: «N ye syar.» Pe ca n yũhũ crã u na, ma kãnklũy gbãã, ma u trɛ yigi yãŋ, ma u sey. ");
INSERT INTO xrb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Loo na, Yesu n pe pye ma yee: «Ye ma n fya ye! -Ye ka, yaa ra kãnyãrwai yar, pe ka Galɛlɛ kãntraha na. Koo fla kẽ pe n gaha ra yãã.» ");
INSERT INTO xrb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pe ca pye nantãŋ kaŋ na, mpãy pe naa le gbĩĩ sẽŋ, pe n dye le klo wo, ma ke kai- byɛ tɔ̃r pe Yãhã yũndefa yĩŋfa ye, kai- nkãy ke pye. ");
INSERT INTO xrb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Poo n pe ya wãã pe wãlɛ ne, ma pãã ta, ma wangbãy wãã le gbĩĩ sẽŋfa kẽ, ");
INSERT INTO xrb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ma pe pye ma yee, a pe kawar fua nawee- ye, a yĩmper wo pe pye wãy na, Yesu kãnyãrwai n pa, maa u nakugu yuhu gbe yi le gbĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pe n maha le gbĩĩ sẽŋfa pye ma yee, a Pilati ma le luhu, poo ga u laam yĩn, laa saa pe dye ye. ");
INSERT INTO xrb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Le gbĩĩ sẽŋfa n pe war sya. Pe pe yar mii, pe n pye koo syi. Too kawar nde n cããŋ pe Yiifee- nsoho wo, ma sya ba waa ke nanga na. ");
INSERT INTO xrb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu tuu ba yãŋ gii yar yaha Galɛlɛ kãntraha na u kãnyãrwai sẽnsye nen na, pe n ka ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pe ga u yãã, pe n u sey. Pe laam wo, mpãy sẽ -sẽ ba le sya ma yee Yesu kẽ cĩĩnde ye, ma naa laalaa pye. ");
INSERT INTO xrb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu n yũhũ crã pe na, ma pãã pe ne ma yee: «Yãhã kai- byɛ fãnga wãã ra kẽ, yãhãyĩŋ na tesẽ kãntraha ne. ");
INSERT INTO xrb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","-Ye ka, yaa naa kãntrahafa byɛ klaha ta kaklaha ne, pe n naa ra kãnde yãr, tee naa pe tãã Tuhufua Yãhã myaha ne, tesẽ ke Dya myaha ne, ma suhu ke Yrã Fãnga myaha ne! ");
INSERT INTO xrb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tẽ kai- nkãy byɛ tɔ̃r ye ye, -ye ke yar pe na, -ye pe ta pe n naa ke yãr! -Ye yãŋ, n ma ye ne plii byɛ, driyɛ̃ n sya ba kua.»");
INSERT INTO xrb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Le kapãyĩĩ ne nde, kapãyĩĩ lii le Yãhã Dya wĩĩ tɔ̃r, wii u ma ke Yĩndefua Crise. ");
INSERT INTO xrb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ke kai- ba fe gbe mii faale Yãhã kaplãŋ tɔ̃rfua Yisa bii le cãã yrũhũ yaha Yãhã sabangbãŋ wo mii. U bii le yrũhũ, a Yãhã ke Dya Yesu pye ma yee: «Awa, n nwo, n ta tẽnlɛhɛ nɔ wãã ma yahasee ye, u n ga kãnde gbihi yaha ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","«Naa waa yĩmbui ne, le n yir drawaha fla wo ma yee: ‹-Ye Yĩŋfua Yãhã wãpaŋ kãnde gbihi yaha u kẽ, -ye ke kãmbɛhɛ ta ke n sroŋ yɔ̃!› » ");
INSERT INTO xrb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Dya waa ba yi drawaha fla wo, ma u ya yar nawee- na. U myaha ba kẽ Nsãn. Woo pye Yãhã tẽnlɛhɛ. U nawee- tãã naa n yi loho wo, ma maha pe yee naa n pai, maa naa pe yar ma yee: «-Ye le sya ye cã ye kapee- wãpyeŋ sẽ yɔ̃ ye, -ye ke miy yaha! -Tee pa, ta n ba ye tãã yi loho wo. Yãhã -sẽ ga ye kapee- laha kãã ye yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yurusalɛm klofa, tesẽ Yudɛ kãntrahafa ne, pe byɛ -sẽ naa n pai u ye. Nawee- byɛ yĩnde na pe naa pe kapee- tɔ̃r Yãhã ye, Nsãn n -sẽ pe tãã naa n yi Yurdane lafeŋ loho wo. ");
INSERT INTO xrb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nsãn nayroho fai pye yũhũmii sraha yor, pe ta ma ke tyĩn. U ba sapaha ta ma u ya pua naa n cɛr nsĩĩ wo. Jĩmblɛ te pye u digi, sɔ̃r ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U naa nawee- pye ma yee: «Waa ter -sẽ ma tuu n pai. Woo cɛr yaha ra kẽ mahamaha. Ta syi gɛ sẽ yai n kuɛ tege, n u ntãn sale fɛr u trɛ na ye. ");
INSERT INTO xrb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ndoo ye tãã n yi loho ya wo, woo -sẽ ga ba naa ye tãã Yãhã Yrã Fãnga ne.» ");
INSERT INTO xrb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Too plii na, Yesu n -sẽ yir Galɛlɛ kuɛ klo laa wo pe n yee Nasarɛte, ma pa Nsãn n ba u tãã yi Yurdane lafeŋ loho wo. ");
INSERT INTO xrb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yaliile Yesu naa n yi ke loho wo, yãhãyĩŋ n fe yãr, u n yãã Yãhã Yrã Fãnga tege u na kãnsyã waa ter dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yĩmbui laa n yir yãhãyĩŋ kuɛ ye ma yee: «Ta Dya kẽ ma ne, ma ntãŋ dye gboho ra tãy, ma ra laam yĩn yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Le yalebya wo, Yãhã Yrã Fãnga n Yesu ta u n ka drawaha fla wo. ");
INSERT INTO xrb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","U n ga kuee ke fla na plii gbeesĩĩ, Setane, sãndãpee yĩŋfua n u tyĩn naa n yãŋ kapee- wãpyeŋ kuɛ ye. Yesu pye wlaha wãn nsoho wo. Yãhãyĩŋ tẽnlɛhɛ n pa, ma ba nii koho le u ye. ");
INSERT INTO xrb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","U Nsãn n ba le nwompihi wo. Yesu n yir loo na, ma ka Galɛlɛ kuɛ ye, maa nii Yãhã kapãyĩĩ tɔ̃r nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","U naa n yee: «-Ye luhu yɔ̃, Yãhã Yai nɔ gbe taha, Yãhã n traha ke dye ye kuɛ ye. -Ye le sya ye cã ye kapee- wãpyeŋ sẽ yɔ̃ ye, -tee le kapãyĩĩ sya!» ");
INSERT INTO xrb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu tuu naa n tɛr Galɛlɛ langbãŋ yɛ̃ na, u n fuayigifa syãm mpãy yãã. Syimu ba kẽ u cĩĩfua Andere ne. Pe pye pe naa jɔɔ- miy ke langbãŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu n pe pye ma yee: «-Ye naa n taha ra na ye kuãŋ ne! Tee naa fua- le jɔɔ wo mii, yagaa, nawee- me tee ga naa n le kãnfuɛ̃ wo ke syi.» ");
INSERT INTO xrb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Le yalebya wo, pe n pe jɔɔ- miy yaha, ma taha u na pe kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","U n ka yahasee ye, maa nawee- syãm mpãy yãã. Sewede pii ba me, Syake tesẽ u cĩĩfua Nsãn ne. Pe pye pe salangbãŋ wo, ma naa pe jɔɔ- gbihi. ");
INSERT INTO xrb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu n pe yee, pe naa n taha woo na. Le yalebya wo, pe n pe tuhufua ta yaha ke salangbãŋ wo, u tẽntẽ- ne, ma taha Yesu na pe kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu n ka u kãnyãrwai ne klo laa wo pe n yee Kapornu. Kanii per wo u n ka Yiifee- yawãhã nwoŋ wo, ma ga nii nawee- klaha. ");
INSERT INTO xrb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","U kaklaha ter n nawee- fe gbe, ma maha yɛ̃ gbãã pe na. U kaklaha sẽ pye mpãy wãŋ syi dyaŋ pe n yee Yãhã kaiyarfa ye, u kaklaha pye fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ke yawãhã nwoŋ wo dya waa pye, sãndũpee pye u yĩŋ na. U n tẽ sya ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Eh, Nasarɛtefa Yesu, maa nwa pye wo na? Ma pa la ma n pai wo wĩĩ klaha- tãŋ? N cã yoo kẽ ma ne: Mboo kẽ wii ne u ma Yãhã wũũ.» ");
INSERT INTO xrb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu n sã waha u sãndũpee na ma u pye: «Yaha le, -taa tege kãã dya nwo yĩŋ na!» ");
INSERT INTO xrb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","U sãndũpee n tege kãã u dya na, ma n tẽ fãnga ne, ma u yɛhɛ mii wãtookufua dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Le n pe byɛ fe gbe ga far tɛr, pe n sya nii n yee: «-Ye naa laa yãŋ nde! U kai- byɛ cã tãŋ, waa sẽ u kaklaha syi ter yãã yãã ye. Dya nwo n sã sãndãpee gɛ na, pe n nii n luhu u ye.» ");
INSERT INTO xrb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesu myaha n ta tɛr yi Galɛlɛ kãntraha kui byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Loo kur ye, Yesu n yi ke Yiifee- yawãhã nwoŋ wo, ma ka Syimu ye kaha wo Andere ne. Syake tesẽ Nsãn ne pe bya pye pe ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Syimu cɔɔ nahafua pye, u ba sãy nii, u kadye ba war. Yesu wãdyetãŋ pe n u cɔɔ wĩĩ pãã u ye. ");
INSERT INTO xrb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","U n yũhũ crã, ma u yigi u koho na ma u ta u n yir. Ke kadye n u miy yaha, u n nii pe nampay yi. ");
INSERT INTO xrb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Yainkɔŋ wo, yainde le ba dye tɛr wa, nawee- n yanfa byɛ gbe ba Yesu fla na, tesẽ mpãy ne sãndãpee pye pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pe klofa byɛ n pe ya wãã ba yɛr tã ke kapahayɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu n yanfa ter byɛ jaa, ma maha sãndãpee kar tege kãã mpãy yĩŋ na. U sẽ naa n tyii pe sãndãpee na pe n naa laa pãã u wĩĩ na ye, poo ba cã yoo kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ke yĩŋsyii wo, sukũhũntãy pẽmpẽm na yĩnwɔŋ wo, Yesu n yir yi ke kaha wo. U n tɛr dragba gaa laam wo, le klo kãnkãy na, ma ga nii u laam wũhũ tɔ̃r Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Syimu tesẽ mpãy ne pe pye u ne, pe n tɛr u taysaha wo. ");
INSERT INTO xrb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pe ga u yãã, pe n u pye ma yee: «Nawee- byɛ ma pe ma kɛ.» ");
INSERT INTO xrb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu n pe pye ma yee: «Waa ka kuɛ ngaa ye kãnkãy kui wo. N yai n le Yãhã Yai kapãyĩĩ tɔ̃r pe byɛ ye. Ta wãpaŋ yĩŋ kẽ nde.» ");
INSERT INTO xrb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Koo syi kẽ u n ba Galɛlɛ kãntraha byɛ tay klaha tãŋ. U naa le kapãyĩĩ tɔ̃r pe nawee- ye te Yiifee- yawãhã nwey wo, ma maha sãndãpee kar tege naa n kãã nawee- yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Too plii nsoho wo, gber waa n ba pa Yesu ye, ma ba kãnklũy gbãã u yahasee ye, ma u nar ma yee: «Le ma tãy ma ye, ma ga waha ta ra n jaa n nii gbɛgbɛ nayɔ̃r saha na!» ");
INSERT INTO xrb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","U fɛn n Yesu yigi, u n koho nɔ wãã ma tɛ u na, ma u pye ma yee: «Ãwã le tãy ra ye, jaa ma nii gbɛgbɛ nayɔ̃r saha na.» ");
INSERT INTO xrb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Le yalebya wo, ke yãhã n ta tɛr laha kãã u dya na, u n nii gbɛgbɛ nayɔ̃r saha na. ");
INSERT INTO xrb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu n ta tɛr u dur wãã, ma -sẽ u yar waha ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Luhu yɔ̃, maʼa syi nde pãã waa ye ye! -Taa ka, maa mii yar Yãhã yũndefua na, ma ma wãjaa diŋ yi, diŋ gii faale wãdyaha Musa tuu bii tɔ̃r yaha mpãy kẽ pe pye yãhã ne pe kadye na, ma jaa. Ke syi ne nawee- ga waha cã ma jaa.» ");
INSERT INTO xrb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","U dya sẽ -sẽ waha le kai le yaha u laam wo ye. U n ka, maa le tɔ̃r teebɛhɛ byɛ wo. Ke syi ne, Yesu sẽ waha naa u ya yar klo laa gɛ wo ye, u naa n kuee dragba wo. Nawee- n maha naa n yir teebɛhɛ byɛ wo, ma naa n pai u ye. ");
INSERT INTO xrb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Plii raa n tɛr, Yesu n dur ba Kapornu wo. Pe nawee- n luhu u ma kaha wo. ");
INSERT INTO xrb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nabuar raa n yi, ma te ya wãã ba ta, tɛrsaha gɛ sẽ pye nkur ye nwonyɛ̃ kuɛ ye ye. Yesu naa Yãhã kapãyĩĩ tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nawee- resyar mpãy n pa. Pe ba tãnkurfua waa gbe, ma naa n pai u ne Yesu kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pe sẽ waha u yar Yesu na ye, pe nabuar tee ba nihi tɛr. Pe n gblihi laa, ma dugu ke nwoŋ na, ma wihi fer, ma u tãnkurfua yoŋ tege le wãã u kasãy wãŋ na ma sroŋ Yesu niisaha fla ne. ");
INSERT INTO xrb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu tuu yãã pe nawee- mii u ta pe Yatɛr, u n u tãnkurfua pye ma yee: «Cĩĩfua, ma kapee- laha kãã ma yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yãhã kaiyarfa mpãy pye ke fla na, pe ba tege nii. Pe Yesu kapãn luhu, pe n nii laam ga ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Eh, dya nwo n gbar Yãhã ne cĩĩnde. Yoo ma u ga waha kapee- laha kãã nawee yĩŋ na mii Yãhã ya sẽ kẽ ye?» ");
INSERT INTO xrb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu -sẽ ta tɛr pe laam wĩĩ cã kãã, ma pe pye ma yee: «Nwa ta ye n nii kai- ngĩĩ syi ga ye laam wo? ");
INSERT INTO xrb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","N ga waha u tãnkurfua pye: Ma kapee- laha kãã ma yĩŋ na. N ga maha waha u pye: Yir, ma ma kasãy wãŋ gbe, ma yãr naa n gaha. Koo katɛ- syãŋ ngĩĩ wo, lii loo le cã waha? ");
INSERT INTO xrb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","N -sẽ n yãŋ ye cã Yãhã kãnde wãã u Nawee Puee kẽ kãntraha nge na, u n ga waha kapee- laha kãã nawee- yĩŋ na.» Yesu n wã klaha loo na, ma u tãnkurfua pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«N ma yar, yir, -taa ma kasãy wãŋ gbe, ma yãr naa n gaha ma kaha wo!» ");
INSERT INTO xrb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","U dya n yir le yalebya wo, ma u kasãy wãŋ gbe, ma yãr n tɛr nawee- byɛ yĩnde na. Le n yɛ̃ gbãã pe na, pe n nii Yãhã sey ma yee, a poo yĩnde sẽ taha yãã nde syi na ye. ");
INSERT INTO xrb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu n dur ba Galɛlɛ langbãŋ tãy. Nabuar naa n pai u ye, u n naa pe klaha Yãhã wũhũ ne. ");
INSERT INTO xrb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","U naa n tɛr ma ba Alefɛ dya kufar wããfua Lewi yãã, tuu tege nii kufar wããsaha wo. Yesu n u pye: «Naa n taha ra na!» Lewi n yir, ma taha u na u kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Loo kur ye, Yesu pye dir na u kãnyãrwai ne Lewi kaha wo. Kufar wããfa pye pe ba nihi, poo tesẽ kãmpee- yãrfa mpãy ter ne. Pe byɛ wãã naa n di pe ne. Poo nawee- mii ter me pe ba syar, ma naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yãhã kaiyarfa mpãy pe pye yĩmbui nen na Yiifee- yahaseefa mpãy ne pe n yee Farisyɛ̃, poo me pe pye ke fla na. Pe n Yesu yãã, tuu wãã n di kufar wããfa ne ma suhu kãmpee- yãrfa mpãy ter ne, pe n le pãã u kãnyãrwai ye ma yee: «Ah nwa ta u n nii wãã n di kufar wããfa ne, ma suhu kãmpee- yãrfa ne?» ");
INSERT INTO xrb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu n pe kapãn luhu, ma pe pye ma yee: «Yĩnwɛrfa sẽ me pe tyinfua tay ye, yanfa poo pe u tay. N pa kãmpee- yãrfa myaha na, ma n kɛ pe koho klaha. Mpãy pe pe ya yãŋ poo ma kãnyĩĩ yãrfa, n sẽ pa poo mii myaha na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Per gaa, Nsãn nawee- tããfua kãnyãrwai ba pe yɛ̃ tã digi na, tesẽ Farisyɛ̃ ye ne. Nawee- mpãy n ba Yesu pye ma yee: «Nsãn kãnyãrwai pe yɛ̃ tã digi na, tesẽ Farisyɛ̃ kãnyãrwai ne, mboo kãnyãrwai sẽ -sẽ le syi pye ye.» ");
INSERT INTO xrb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu n pe yɛ̃ sya kakuãcraŋ ne ma yee: «Ah ye laam wo, cafãn yigifa ga waha fãn wãdi sye la cafãn yigisaha wo, u cafãn yigifua yĩnde na? Ye cã le saha pye ye rɛhɛ! ");
INSERT INTO xrb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per gaa -sẽ ma ke n pai, u cafãn yigifua ga ba yigi kãã pe laam wo. Koo per maa nɔ, pe ga ba cã naa pe yɛ̃ tã digi na. ");
INSERT INTO xrb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Waa sẽ faafuɛ̃ faagblaha gbe, ma nayredyaha wihi pãhã n tã ye. Mii loo sẽ ne ye, le faafuɛ̃ faagblaha ga le wãdyaha tyĩn jũũ, kaa n maha gbihi taha ke cɛrsadyaha fla na. ");
INSERT INTO xrb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Waa sẽ maha sẽmper le srafũhũ sakueelɛr wo ye. Maʼa loo pye, pe sẽmper maa yir, te srafũhũ sakueelɛr ga fe, pe sẽm n woo tãŋ, te srafũhũ sakuee tii maha klaha- taha le na. Koo kẽ sẽmper yai pe le srafũhũ sakueefãn too laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kanii per gaa na, Yesu ba tar raa yi naa n yaha u kãnyãrwai ne. Pe kãnyãrwai nii n yãr, ma te tar kasan kãy, ma te wihi kũ n tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pe Farisyɛ̃ n Yesu pye loo na ma yee: «Yãŋ lii pe n pye! Wo kãnde le kai- nkãy yar ke sẽ yai ke naa n pye kanii per wo ye, nwa ta ma kãnyãrwai n nii le syi laa pye?» ");
INSERT INTO xrb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu n pe yɛ̃ sya ma yee: «Ye le kal yãã Yãhã sabangbãŋ wo, faale yĩŋfua Dawide u bii lii pye, per gii fãã bii war pe na woo tesẽ u nawee- ne, ngaa sẽ pye pe ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dawide n dye Yãhã kangbãŋ laam wo, bur rii re bii kẽ Yãhã ye, u n te gbe di. Ke cãã na, Abyatare kẽ ruu pye Yãhã yũndefa yĩŋfua. Wo kãnde na, yũndefa ya sẽ na pe yai too bur nde ne? Dawide -sẽ bii taa gbe di te wo, ma sya ba taa wãã u nawee- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu n maha pe yar taha ma yee: «Yãhã kanii per ta nawee wãyɔ̃ŋ wĩĩ na, tesẽ u wãwũũ wĩĩ ne. Yãhã sẽ nawee tãhã ma yee u naa fɛn sya kanii per wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Koo gɛ kẽ, u Nawee Puee kẽ u ma kanii per yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu n maha dur ga Yiifee- yawãhã nwoŋ wo. Ke per, dya waa pye kãnwaage ne. ");
INSERT INTO xrb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farisyɛ̃ mpãy pe pye ke fla na, pe naa Yesu yãŋ ncã u ga yee, u ga u dya jaa ke kanii per wo laa? U ma le pye, pe n waha yee, a ter u ma u tee pye. ");
INSERT INTO xrb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu n u kãnwaagefua pye ma yee: «Yir ba yɛr nwo wo, nawee- telai wo!» ");
INSERT INTO xrb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mpãy pe naa n yãŋ, u n dur yagaa, ma poofa yey: «Wo kãnde wo, lii wãpyeŋ le yɔ̃? Kayĩĩ wãpyeŋ yɔ̃ kanii per wo laa, kapee wãpyeŋ loo le yɔ̃? Wo nawee yrã sya yaha laa, wo u wĩĩ pye klaha-?» Pe n yaha le, pe sẽ laa pãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu n pe yãŋ ncafũhũ ne, u laam byɛ maha ba wlãhã, tuu yãã pe nawee- laam ba waha tɛr. U n u dya pye ma yee: «Ma koho dii wãã!» U n ke dii wãã, ke koho n dur yɔ̃ nii u ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pe Farisyɛ̃ n ta tɛr yi ke Yiifee- yawãhã nwoŋ wo, maa pe ya wãã Galɛlɛ kui yĩŋfua Yɛrɔte nawee- mpãy ne. Pe n le yãŋ, pe ga waha Yesu boo wãboo ter gii syi na. ");
INSERT INTO xrb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu n yi, ma ka Galɛlɛ langbãŋ fla na u kãnyãrwai ne. Nabuar pye, pe naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pe naa n yi Yurusalɛm wo, Galɛlɛ kui ne, Yudɛ kui ne, Yidumɛ kui ne, tesẽ kui nkãy ne ke ma Yurdane lafeŋ kuɛ ngaa kũndi ye, tesẽ kui nkãy ne ke ma Tyir tãy Syidɔ̃ ne. Yesu u naa kai- nkãy pye, pe naa ke luhu, koo syi kẽ nabuar n te ya wãã naa n pai u ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu n sya u kãnyãrwai pye, pe salangbãŋ gaa kɛ ta u kẽ, u n dugu dye, pe nawee- ma syi pe u waa yigi fãnga ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tuu naa nabuar jaa, koo syi kẽ mpãy byɛ pe naa n yaa, pe n naa u kɛ ma ga tɛ u na. ");
INSERT INTO xrb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sãndãpee pye, pe ma u yãã pe ga ba kãnklũy gbãã u tãy, pe naa n kui pe yee: «Yãhã Dya kẽ ma ne.» ");
INSERT INTO xrb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu -sẽ le pãã naa n waha pe ye, pe ma syi pe u wĩĩ tɔ̃r naa n yar ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Loo kur ye, Yesu n ba dugu ga yãŋ gaa yĩŋ na. Tuu pye nawee- mpãy wĩĩ na, u n pe yee pe n pa u ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nawee- sẽnsye syãm ba me tuu yãŋ yi, pe n ga nii u kãnyãrwai. U n pe yãŋ yi pe nii u ne, u n ba pe lɛhɛ wãã, pe n ga naa Yãhã wũhũ yar. ");
INSERT INTO xrb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","U n fãnga wãã pe kẽ, pe n waha sãndãpee kar tege naa n kãã nawee- yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nawee- sẽnsye syãm mpãy u yãŋ yi, pe myar nde: ");
INSERT INTO xrb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Syake tesẽ u cĩĩfua Nsãn ne. Sewede pii me. ");
INSERT INTO xrb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","U n maha Andere yee, Filipe ne, ");
INSERT INTO xrb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tesẽ Syikaryɔte klofa Yuda ne, ");
INSERT INTO xrb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu n tege ke yãŋ yĩŋ na u kãnyãrwai ne, pe n dur ga kaha wo. Nabuar n maha te ya wãã ba ta. Draha gɛ sẽ yãã Yesu ye u n ga di u kãnyãrwai ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","U nna pe le luhu, pe n yee, a ter u yĩŋ yir. Pe n kãnde sya ma pa, poo n pai u yigi tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yãhã kaiyarfa mpãy ba yir Yurusalɛm wo, ma tege ba klo lii wo Yesu pye na. Pe n nii le pãã Yesu wĩĩ na ma yee: «Sãndãpee yĩŋfua Sebulɛhɛ kẽ u ma u dya nwo yĩŋ na. Pe sãndãpee yĩŋfua kẽ tuu fãnga wãã u kẽ, u n waha sãndãpee kar tege naa n kãã nawee- yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Koo kẽ Yesu n pe yee ba, maa pe yar ma yee: «Setane, sãndãpee yĩŋfua saa sya naa u kur kar ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kãntraha neŋfa ma kuee n wãã pe ya ne, koo kãntraha saa waha gbihi nii ga yahasee ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nwoŋ neŋfa ma kuee n wãã pe ya ne, koo nwoŋ saa waha gbihi nii ga yahasee ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ke syi ne, Setane ma kuee n wãã u ya ne, wãhã ma pye u kãntraha wo, u fãnga saha ka yahasee ye ye, ke ga klaha-. ");
INSERT INTO xrb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Waa saha dye fãngafua waa kaha wo, u u wãn yuhu gbe, mii u sẽ cãã u pua yigi yaha wa ye. U ma -sẽ waha yia u na ma u pua, u ga waha u wãn byɛ yuhu gbe u ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ta n cĩĩnde nde pãã ye ye, Yãhã ga waha nawee kapee- laha kãã u yĩŋ na, u yorpeer byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma -sẽ yee wii woo tuu ga yorpeer pãã Yãhã Yrã Fãnga wĩĩ na, loo kapee nde saa kua yãã u yĩŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Pe tee naa n pãã ma yee sãndãpee ma Yesu yĩŋ na, koo kẽ u n kai- ngĩĩ pãã pe ye. ");
INSERT INTO xrb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Loo na, Yesu nahafua n ba dye Yesu cĩĩfa ne. Pe n kuee nkur ye, ma waa lɛhɛ wãã Yesu ye tuu pa. ");
INSERT INTO xrb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yesu pye tuu ba tege nii nabuar raa telai wo, pe n ba u pye, a u nahafua ma nkur ye tesẽ u cĩĩfa ne, pe u yee tuu ka pe fla na. ");
INSERT INTO xrb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu n pe yɛ̃ wãã sya ma yee: «Ta nahafua kẽ wii ne, ta cĩĩfa me mpãy ne?» ");
INSERT INTO xrb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loo na, u n pe nawee- yãŋ, pe tege nii ma u gbey le. U n dur ma yee: «Ye sẽ yãã, ta nahafua ma nwo wo, tesẽ ta cĩĩfa ne. ");
INSERT INTO xrb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mpãy pe Yãhã wũhũ pye, poofa pe ma ta cĩĩfa, ta syafa, ta nahafa.» ");
INSERT INTO xrb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu n maha ka ke Galɛlɛ langbãŋ yɛ̃ na, ma ga nii nawee- klaha. Pe nawee- ba nihi ga ta tɛr, u n sya dugu dye nii salangbãŋ gaa laam wo. Ke salaŋ pye loho yĩŋ na, pe nawee- -sẽ pye langbeŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","U n nii kaplãŋ kuã cra n pãã, ma nii pe klaha kabuar ne. Tuu naa pe klaha, u n ba pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«-Ye yaha le, ye ra kapãn luhu! Dya waa yi u kaha wo, ma ga digi yãr u tar laam wo. ");
INSERT INTO xrb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tuu naa ke digi yãr u tar wo, pii mpãy n ga too kãnde ngbeŋ na. Kãnsyãm n pa, maa pe wãy di kãã. ");
INSERT INTO xrb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pii mpãy n ga too ntẽmbakor fla wo. Kãntraflũhũ sẽ pye yɔ̃ ke fla na ye. Loo n ta pe pii sẽ waha dye ga laam wo ye, ma ta tɛr fĩy. ");
INSERT INTO xrb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yaliile yai ke ba war dye yĩndai wo, ke n too dir wãn suhu boo. Te nnen sẽ waha ba sɛr yigi yɔ̃ ye, ke fla tee pye ntẽmbakor fla. ");
INSERT INTO xrb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pii mpãy n ga too ngur wãn taa nsoho wo. Te n ba fĩy, te ngur wãn n te puãr, te sẽ waha lɛ dye ma sa ye. ");
INSERT INTO xrb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pii mpãy n -sẽ too kãntrayũhũ na. Poo n fĩy, ma yir, ma lɛ dye, ma sa. Taa n pii le car, taa n faa le gboho, taa n le gboho.» ");
INSERT INTO xrb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu n pe yar taha ma yee: «Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pe nabuar pe ba tɛr wa, nawee- mpãy pe pye Yesu tãy, tesẽ u kãnyãrwai ne, pe n yee u ke kaplãŋ yĩntaha gbihi tɔ̃r yar poo na. ");
INSERT INTO xrb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","U n pe pye ma yee: «Kai- nkãy nawee- sẽ cã yãã Yãhã Yai wĩĩ na ye, Yãhã ta yii n ke cã. Ma -sẽ yee mpãy na pe sẽ ke yĩntaha kɛ ye, ke ga naa n tɔ̃r pe ye kakuãcraŋ ya wo. ");
INSERT INTO xrb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ke syi, ‹pe n waha yãŋ naa n yɔ̃, ngaa sẽ -sẽ ga naa n yãã ye. Pe n waha luhu naa n yɔ̃, laa sẽ -sẽ ga naa n war ye. Mii loo sẽ ne ye, pe ga faha ba Yãhã kãnde yigi, ke n pe kapee- laha kãã pe na.› » ");
INSERT INTO xrb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu n pe pye ma yee: «Tee sẽ kapãn nde yĩntaha war ye, ye -sẽ ga ba pye mii ye te nampyen- too war, tii tẽ ga ba tɔ̃r ye ye? Ta n le kapãn yĩntaha tɔ̃r ye yar. ");
INSERT INTO xrb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nawee wii tuu Yãhã kaplãŋ tɔ̃r, u ma mii digi yãrfua dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nawee- mpãy laam plãhã mii le kãnde ngbeŋ dyaŋ, pe pii pe too na. Pe ma le Yãhã kapãyĩĩ luhu, loo yalebya wo Setane sãndãpee yĩŋfua ga ba le yi kãã pe laam wo. ");
INSERT INTO xrb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nawee- mpãy laam ma mii ntẽmbakor fla dyaŋ, pe pii pe too na. Pe ma le kapãyĩĩ luhu, loo yalebya wo pe ga le sya nuhu ne. ");
INSERT INTO xrb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Le sẽ -sẽ ga nii gbãã pe laam wo ye. Le ma ba nii mii wãfãy dyaŋ pe na tesẽ fɛn ne le kapãyĩĩ wĩĩ na, pe ga loo byɛ miy yaha. ");
INSERT INTO xrb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mpãy ter maha ma, pe ga le kapãyĩĩ sya pe laam wo mii pii mpãy dyaŋ pe too ngur fla wo. ");
INSERT INTO xrb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Poosyifa ma le kapãyĩĩ yãã luhu, driyɛ̃ laangar -sẽ gboho tɛr pe laam wo, wale wãkɛ ne, yĩnde wãn wãkɛ ne. Too wĩĩ ma ba gboho ta tɛr pe laam wo, te ga nii tã le kapãyĩĩ na, pe saa yɛr le kapãyĩĩ kur ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mpãy -sẽ ma, pe ga le kapãyĩĩ sya pe laam wo mii pii dyaŋ pe too kãntrayũhũ fla wo. Pe ma le kapãyĩĩ luhu, pe ga le sya cĩĩnde, le n nii gbãã pe laam wo. Le kapãyĩĩ pii ga lɛ pe laam wo, le kayũhũ sa; mpãy pe sa gboho, mpãy pe sa yai, mpãy pe sa car.» ");
INSERT INTO xrb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu n maha kakuãcran nde pãã pe nabuar ye ma yee: «Pe ne naaloho ndyan tar ba la, pe ba le ta pe kataŋ cĩn tã le na laa, pe ba le le wãã gbãngbahara flãhã tãy? Ta n yee, pe ne le wra yaha kããnkui na. ");
INSERT INTO xrb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngii ngii ke wũhũ nii, ke ga ba nii gbaa na, lii nawee sẽ le cã yãã ye, le ga ba cã yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu n maha le pãã pe ye ma yee: «Tee nkãy luhu, -ye ye laam yaha ke na! Tee n luhu mii syi, Yãhã ga ba kaa taha ye wãwar na koo syi. ");
INSERT INTO xrb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wii ma waha ke war cacar, u ga ba ke war naa n gboho; wii ma -sẽ ke wãwar sye, car gii tuu cã ke ga faha u na.» ");
INSERT INTO xrb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu n maha yee: «Yãhã Yai wĩĩ ma mii dya waa dyaŋ tuu yɛ̃y tãhã u tar wo. ");
INSERT INTO xrb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Te yɛ̃y ga fĩy, te naa n lɛ, u saa laa cã le na ye. U sã wãy faha woo, u ma yrãŋ woo, te yɛ̃y ga naa n fĩy ke yai ke yĩmper. ");
INSERT INTO xrb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kãntraha sẽ na, ke ne re ta te n fĩy te ya ya, te ba nduaŋ kũũ, te sa, te pii le? ");
INSERT INTO xrb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te pii ma ba lɛ koo na, u tarfua ga pa u ba re yaa.» ");
INSERT INTO xrb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu n maha yee: «Waa maha waha Yãhã Yai wĩĩ tɔ̃r nwa ne? N ga waha le yar ye na kakuãcran lii syi ne? ");
INSERT INTO xrb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Le ma mii ngaa puale dyaŋ. Le tãhãyale wo, le kloŋ pii byɛ na. ");
INSERT INTO xrb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Le ma fĩy yi, le ga yir, le gboho ta tɛr tãŋ dir wãn ter byɛ na, le sya kayangbãy yi, kãnsyãm n sya ba naa pe nsɛŋ ta yĩm wo te kayay laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu naa nawee- klaha kakuãcraŋ busãã ne ke syi. Pe nawee- pe ne ga waha kakuãcraŋ nkãy war, u naa koo tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","U sẽ naa n pãã pe ne mii kakuãcraŋ sẽ kẽ ye. U ma -sẽ ba nii u ya ya u kãnyãrwai ne, u ga cã ke kaplãŋ yĩntaha gbihi tɔ̃r yar pe na. ");
INSERT INTO xrb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Koo per yaiyĩn na, Yesu n u kãnyãrwai pye ma yee: «-Ye pa wo n dii tɛr kũndi ngaa ye.» ");
INSERT INTO xrb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","U kãnyãrwai n wloho yi kãã te nabuar wo, ma ga dugu dye ke salangbãŋ wo Yesu tuu ba dye nii kii wo, pe n nii n tɛr. Salangbãy taa pye ke langbeŋ na, nawee- mpãy n dugu dye te wo, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Teflahangbãŋ gaa n yir wãfua ne, ma sya loho fua gbe le wãã n taha pe na ke salangbãŋ wo, ke n sya yĩĩ naa n wa. ");
INSERT INTO xrb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu pye ke salangbãŋ namlã kuɛ ye, tuu ba sã wãy, ma yĩŋ gbã yigi yĩngbũhũ ne. U kãnyãrwai n u gbã yir, ma u pye ma yee: «Wo Yĩŋfua, ma sẽ yãã la waa kuee le wo?» ");
INSERT INTO xrb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu n yir, ma sã ke teflaha na, ma pãã ke loho ne ma yee: «Yaha le, nii sũũ!» Ke teflaha n yɛr loo na, ke fla n nii seyĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu n u kãnyãrwai pye ma yee: «Nwa ye n nii n fya? Ye Yatɛr wee la ye ne?» ");
INSERT INTO xrb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pe -sẽ ba fya, ma naa le pãã pe ya ye ma yee: «Hãã, -ye naa dya nwo yãŋ, teflaha n luhu u ye ke langbãŋ loho bya ne.» ");
INSERT INTO xrb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pe n ga nɔ ke kãntraha langbãŋ kũndi ngaa ye, Jerasinefa kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu wãtegekãã ke salangbãŋ wo, dya waa n yi gbũhũ fla na, ma u wãã n pai. ");
INSERT INTO xrb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sãndũpee waa pye u dya yĩŋ na, ma u ta u n naa n nii gbũhũ fla na. Ntẽn namihi gɛ ne pe sẽ waha u dya pua yigi naa n yaha nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","U dya pye, pe ma yir, pe ga u trɛ pua ntẽn namihi ne. U -sẽ ga te ntẽn namihi cɛr, tuu te ntẽn wãn ka. U wãyigiyaha fãnga sẽ pye waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ke yai ke yĩmper, u naa wãtay ya tay gbũhũ laam wo, tesẽ yãy yĩŋ ne, ma naa n kui, ma maha naa u ya duai ntẽmbar ne. ");
INSERT INTO xrb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","U n Yesu yãã deydey, ma fã ba kãnklũy gbãã u yaha ye, ");
INSERT INTO xrb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ma tẽ sya fãnga ne ma yee: «Ke Yãhãngbãŋ Dya Yesu, nwa taa ga pye ra na? N ma nar, Yãhã yãŋ, maʼa syi ma ra pẽn ye.» ");
INSERT INTO xrb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesu naa n gbey u na ma yee: «Sãndũpee nwo, tege kãã u dya yĩŋ na!» ");
INSERT INTO xrb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","U n u dya yey ma yee: «Ma myaha mii?» U n yee: «Ta myaha Nihinihi, wo ma wo nihi.» ");
INSERT INTO xrb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","U n nii le sroŋ nar Yesu ye, tuu ma syi pe sãndãpee kar kãã ke fla draha wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kaha tyɛ- mpãy -sẽ pye, pe wãnihi; pe pye pe naa n di ke yãŋ fla na. ");
INSERT INTO xrb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pe sãndãpee n Yesu nar ma yee: «Wo nɔ wãã tyɛ- mii fla na, wo n ga dye nii pe laam laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu n le sya pe ye. Pe sãndãpee n tege kãã u dya yĩŋ na, maa dye pe tyɛ- laam laam wo. Pe tyɛ- n ke ngbeŋ fã tege, maa too dye ke langbãŋ laam wo, ma ku. Pe ba tyɛ- naha kua. ");
INSERT INTO xrb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mpãy pe naa pe tyɛ- naha, pe n fã tɛr, maa le kapãn pãã pe klofa ye, tesẽ wlɛfa ne. Nawee- n pa, maa yãŋ lii le ba pye. ");
INSERT INTO xrb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pe ba nɔ Yesu fla na, pe n u dya yãã, dya wii sãndãpee busãã pye u yĩŋ na. U dya yĩntaha ba too, u n ba faha wãn le tege nii, nafããn pyer sẽ pye u na nantãŋ ye. Pe nawee- n fya, ma sya nii n sege. ");
INSERT INTO xrb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mpãy pe ba ke kai- byɛ yãã yĩnde ne, poo n u dya wĩĩ gbe, ma tɔ̃r pe ye, tesẽ pe tyɛ- wĩĩ bya ne. ");
INSERT INTO xrb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pe n too Yesu wãnar na, tuu tɛr kãã, u pe klo ta yaha. ");
INSERT INTO xrb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu tuu dugu naa n dye ke salangbãŋ wo, u dya wii sãndãpee pye u yĩŋ na, u n Yesu pye woo ga ka u ne. ");
INSERT INTO xrb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu sẽ le sya u ye ye, ma u pye ma yee: «Dur ga ma kaha wo, ma nna fla na. Yãhã ke ma fɛn di, ma nkãy byɛ pye ma kẽ, ka maa ke tɔ̃r pe ye!» ");
INSERT INTO xrb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","U dya n tɛr. Yesu tuu lii pye u kẽ, u n ga nii le pãã nawee- ye ke kui sẽnsye teebɛhɛ byɛ wo. Mpãy pe naa le luhu, le naa pe laam wɔ. ");
INSERT INTO xrb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu n dur ga u kãnyãrwai ne ke langbãŋ kũndi nge na, ke salangbãŋ ne. U pye ke loho tãy, tuu ba yɛr nabuar ne te ba wɔ tã u na. ");
INSERT INTO xrb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yiifee- yawãhã nwoŋ yĩŋfua waa n pa, u myaha Syase. U n Yesu yãã, ma kãnklũy gbãã u yaha ye, ");
INSERT INTO xrb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma nii u nar u fĩhĩ yɔ̃ woo na, ma u pye ma yee: «Ta pueesyale ma le ga ku, n ma nar, pa maa kluɛ taha le na, le n kãhã yir, le nii yrãŋ na!» ");
INSERT INTO xrb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu n ka u ne. Nabuar naa n taha u na, ma u wãã sya naa n kor kuɛ byɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te nabuar laam wo, cɔɔ waa -sẽ pye. U ntɔ̃r kuee naa n woo u ye dyɛ- sẽnsye syãŋ, wãyɛr wee ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U ba fãy gboho tɛr tyinfa busãã koho wo; u wale byɛ ba ka tãŋ pe ye. U sẽ -sẽ naa n puar ye, te yan too ma cã ba naa n sye u ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","U n Yesu wĩĩ luhu, ma -sẽ pa pe nabuar wo Yesu kur kuɛ ye, ma ba tɛ u nayroho na. ");
INSERT INTO xrb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","U ba le ga yigi ma yee: «N ma yãã tɛ u nayroho ya na, n ga jaa.» ");
INSERT INTO xrb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tuu tɛ Yesu nayroho na ke syi, le yalebya wo u ntɔ̃r wãwoo n yɛr, u n yãã u yan te yi kãã u wo. ");
INSERT INTO xrb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu n le cã le yalebya wo, ma cã ma yee fãnga gaa yi u wo. U n wã klaha pe nabuar laam wo ma yee: «Yoo tɛ ra nayroho na?» ");
INSERT INTO xrb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","U kãnyãrwai n u pye ma yee: «Ma pe nawee- yãã pe ma kor n klaha teebɛhɛ byɛ wo, taa -sẽ maha n yey yoo tɛ ma na.» ");
INSERT INTO xrb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu -sẽ ba yãŋ gbey naa n klaha yoo nde pye. ");
INSERT INTO xrb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","U cɔɔ n nii n sege fyar koho wo, tuu ba cã wa lii le u yãã. U n pa, maa kãnklũy gbãã Yesu yaha ye, ma le cĩĩnde byɛ tɔ̃r u ye. ");
INSERT INTO xrb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu n u pye ma yee: «Cɔɔ, taa ra ta ma Yatɛr, loo le ma jaa. Naa n gaha pra, ma yan tii yi kãã ma wo.» ");
INSERT INTO xrb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu tuu naa koo pãã, tẽnlɛhɛ mpãy n yir Syase kaha wo, ma ba u Syase pye ma yee: «Ma pueesya ku, maa maha Yĩŋfua fãy ma nwa pye?» ");
INSERT INTO xrb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pe n nii n pãã, Yesu sẽ -sẽ pe kuɛ yãŋ ye, ma Syase woo pye ma yee: «Maʼa syi fya ye, ra ta ma Yatɛr, loo ya!» ");
INSERT INTO xrb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Loo kur ye, Yesu n Syase kaha kãnde sya u ne. U sẽ -sẽ sya waa n ka u ne ye mii Pyar ya sẽ kẽ ye, ma suhu Syake ne, u cĩĩfua Nsãn ne. ");
INSERT INTO xrb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pe n ga nɔ Syase kaha wo, Yesu n pe nawee- yãã, pe fã gbey n klaha, mpãy ne pe n wũn ma n kui. ");
INSERT INTO xrb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","U n dye ga ke kaha laam wo, maa pe pye ma yee: «Lii tee fã gbey n klaha ke syi? Nwa ta ye n nii n wũn? U kicar sẽ ku ye, wãy ya tuu sã wãy.» ");
INSERT INTO xrb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pe n u lɛr. U n pe byɛ ta pe n yi. U n u kicar tuhufua ya yigi, u nahafua ne, ma suhu kãnyãrwai tãã mii ne. U kicar tuu pye nwoŋ gii laam wo, pe n dye ga ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","U n u kicar yigi koho na, ma u pye Yiifee- yor wo ma yee: «Talɛta kume.» Loo yĩntaha kẽ, kicaale yir! ");
INSERT INTO xrb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Le kicaale n yir le yalebya wo, ma nii n yãr. Le pye dyɛ- sẽnsye syãŋ ne. Pe nawee- pe nde yãã, le n yɛ̃ gbãã pe na, ma sya ga ta tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu n -sẽ pe yar waha, pe ma syi nawee waa n le cã ye. U n maha pe yar ma yee, pe ngaa wãã u kicar kẽ u n di. ");
INSERT INTO xrb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu n yir ke fla na, ma ka klo lii wo, tuu ba lɛ na. U kãnyãrwai pye u ne. ");
INSERT INTO xrb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kanii per, u n nii ma nawee- klaha Yiifee- yawãhã nwoŋ wo. Nabuar mpãy pe naa n luhu u ye, le n pe fe gbe, pe n nii n yee: «U pye mii ma Yãhã wũhũ byɛ cã tɔ̃r n yar? Yoo tuu roo laantor le u laam wo? Laanwɔ wũhũ ngĩĩ byɛ ne tuu n pye, u koo fãnga yãã na? ");
INSERT INTO xrb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Woo sẽ na Maari dya, wii u ma katyigi tafua? U cĩĩfa sẽ me la Syake ne, Syose ne, Yuda ne, tesẽ Syimu ne? U syafa poo sẽ na pe ma wo ne nwo?» Loo n ta pe sẽ waha Yesu wĩĩ sya ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu n plãhã nge tɔ̃r pe ye ma yee: «Ma yi kãã Yãhã kaplãŋ tɔ̃rfua kusey nawee- na, u nwoŋfa ne, u kahafa ne, teebɛhɛ byɛ nawee- u yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu sẽ waha laanwɔ wũhũ busãã pye ke fla na ye, mii yanfa mpãy ya sẽ me tuu kluɛ taha pe na, ma pe jaa ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tuu yãã u gbenteefa pe u wãtaŋ sye pe Yatɛr, le n laam wɔ u kẽ. Loo kur ye, u n ka maa nawee- klaha kãnkãy kukui wo. ");
INSERT INTO xrb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu n u kãnyãrwai sẽnsye syãm byɛ yee ba, maa nii pe lɛhɛ n wãã nawee- sãnsyãm. U n fãnga wãã pe kẽ pe waha sãndãpee kar tege naa n kãã nawee- yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","U n maha pe yar waha ma yee: «Ye n gaha yrãhã ye, yaʼa syi ngaa gbe yigi ke n naa ye ndege ye. -Ye yrãhãyãr kãi ya gbe yigi, ye ma syi ngaa kadiŋ gbe tesẽ nkãnfaha ne, tesẽ war ne jifaa wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","-Ye ntããfey le, -ye kaleŋ naneŋ ya le!» ");
INSERT INTO xrb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","U n maha pe yar ma yee: «Yaʼa ga dye klo lii wo, pe ma syãsaha wãã ye kẽ kaha gii wo, -ye kuee koo kaha wo ye sya ba tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Teelii nawee- ma ye yɛ̃ yor sye, tesẽ ye wãyigita wĩĩ ne, -ye tɛr pe klo yaha! Ye ma nii n tɛr, -ye ye trɛ mplẽm kor yaha pe na, pe n cã lii ma pe dye, poo pe le kɛ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesu kãnyãrwai n ka loo na, ma ga Yãhã kaplãŋ tɔ̃r n yar nawee- na, ma yee pe le sya pe le cã pe kapee- wãpyeŋ sẽ yɔ̃ ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pe sãndãpee buar kar tege naa n kãã nawee- yĩŋ na, ma naa yanfa busãã tuhu sẽm- ne, pe n kãhã naa n yir. ");
INSERT INTO xrb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu myaha tẽŋ n ba teebɛhɛ byɛ kua. Galɛlɛ kui yĩŋfua Yɛrɔte n Yesu wĩĩ luhu. Nawee- mpãy naa n pãã ma yee: «Nsãn nawee- tããfua wii tuu ba ku, u dur ba yrãŋ na, koo kẽ u n waha laanwɔ wũhũ pye.» ");
INSERT INTO xrb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mpãy naa n pãã ma yee: «Faale Yãhã kaplãŋ tɔ̃rfua Yeli kẽ.» Mpãy maha naa n yee: «Faale Yãhã kaplãŋ tɔ̃rfua waa kẽ u ne.» ");
INSERT INTO xrb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yɛrɔte tuu Yesu wĩĩ luhu, u n yee: «Nsãn nawee- tããfua kẽ! N ba ta pe n u yĩŋ cɛr, u maha dur ba yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Lii le ba dye Yɛrɔte nsoho wo Nsãn ne, le nde: Yɛrɔte ba u cĩĩfua Filipe cɔɔ Yɛrɔtyade tyĩn sya u ye. Nsãn naa le kuãn u ye ma yee: «Ma sẽ yai ma ma cĩĩfua cɔɔ gbe ta ma wũũ ye.» Yɛrɔte n yir, ma ta pe n Nsãn yigi, ma u pua ma u le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nsãn wĩĩ naa u Yɛrɔte cɔɔ yaa, u n sya naa u kɛ gbã ne. ");
INSERT INTO xrb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yɛrɔte sẽ -sẽ naa le sya u ye ye. U naa Nsãn fya, u ba cã Nsãn ba sroŋ, u maha pye Yãhã nawee. Koo kẽ Yɛrɔte n koho naa n paha u na. Nsãn kaplãŋ naa u fãy, ma -sẽ naa n tãy u ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yɛrɔte cɔɔ yĩŋ -sẽ ba tãy Nsãn wĩĩ na, Yɛrɔte seesee gbar per. Ke per na, Yɛrɔte ba u tẽntẽ- yĩŋfa yee ba dir na, tesẽ u naanmiy yĩŋfa ne, ma suhu Galɛlɛ yahaseefa ne. ");
INSERT INTO xrb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yɛrɔte cɔɔ pueesya n dye ke nwongbãŋ laam wo, ma yɔɔ. Le n tãy Yɛrɔte ye, pe nawee- byɛ ne. Yɛrɔte n u capua pye loo na ma yee: «Ngii wĩĩ ma tãy ma ye, ta yar ta n ke wãã ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U n Yãhã di, ma u pye ma yee: «Maʼa ngii wĩĩ pãã, maa ke yãã, ke ma sya pye ra kãntraha kui kãnkãyaha neŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","U kicar n yi, ma ga u nahafua yey ma yee: «Ma laam wo, ma yee n ngii wĩĩ pãã?» U nahafua n yee: «U yar u Nsãn nawee- tããfua yĩŋ cɛr wãã ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","U capua n dur ga farfar Yɛrɔte fla na, maa u pye ma yee: «N n yãŋ, ma Nsãn yĩŋ cɛr wãã ra kẽ yagaa nge na, tasa laam wo.» ");
INSERT INTO xrb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yɛrɔte yĩntaha byɛ n tãhã. Tuu ba Yãhã di pe nawee- yĩnde na, u sẽ sya ma u yɛ̃ dur ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","U n ta tɛr loo na, ma seraasyi naa waa lɛhɛ wãã, ma u pye u ga pa Nsãn yĩŋ ne. ");
INSERT INTO xrb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","U seraasyi naa n yi tɛr, ma ka ke nwompihi laam wo, maa Nsãn yĩŋ cɛr, ma pa ke ne tasa wo maa wãã u capua kẽ. U capua n -sẽ ke sya wãã u nahafua kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nsãn kãnyãrwai pe ba le luhu, pe n pa, ma ba u nakugu gbe maa le gbĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu tẽnlɛhɛ n ba dur ba u fla na. Lii byɛ pe ga pye, nkãy byɛ ne pe ga nawee- klaha, pe n ke tɔ̃r u ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nawee- mpãy pe naa n pai, ma dur naa n tɛr, pe ba nihi tɛr; Yesu sẽ draha gɛ yãã, ma ga di u kãnyãrwai ne ye. U n u kãnyãrwai pye ma yee: «-Ye pa, wo n ka dragba gaa laam wo, ye n ga faa wũũ dye.» ");
INSERT INTO xrb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pe n salangbãŋ gbe, poo n gaha nii teelaa wo pe ya ya. ");
INSERT INTO xrb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nabuar n -sẽ pe yãã tɛrsaha wo, ma pe yãŋ cã. Pe n yir kukui byɛ wo, ma tyĩĩ yãr ga cãã dye ke teele wo Yesu yaha u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yaliile Yesu tuu yi ke salangbãŋ wo, u n pe nabuar yãã kacãn wee ye. Pe nawee- fɛn n u sroŋ yigi, pe pye mii mbaa dyaŋ u mbanaha wee pe ne ye. U n too kai- na, ma nii pe klaha, ma pe klaha. ");
INSERT INTO xrb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yai ke ba kua kua naa n wa ke syi, Yesu kãnyãrwai n pa, maa u pye ma yee: «Yai kua kua wa, wo maha ma dragba wo. ");
INSERT INTO xrb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pe nawee- ta pe n ka tũntũn klɛ wo, kusyĩmbɛhɛ ne, pe ga waha ngaa par di.» ");
INSERT INTO xrb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu n pe yɛ̃ sya ma yee: «Yii gɛ -ye digi wãã pe kẽ pe n di!» Pe n u yey ma yee: «Waa war nagbey bur yãã na, wo waha par wãã?» ");
INSERT INTO xrb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu n pe yɛ̃ wãã sya loo na, ma yee: «Bur wãy nii te ma ye ye? -Ye ka yaa yãŋ!» Pe n ga yãŋ, ma ba u yar ma yee: «Bur wãy bua te ma wo ye tesẽ fua- syãm ne.» ");
INSERT INTO xrb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu n kãnde wãã u kãnyãrwai kẽ, pe n pe nawee- ta pe n tege nii ga ke nyɛ̃pẽŋ na, flɛ flɛ. ");
INSERT INTO xrb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pe n pe ya to to nii ga, kaa na nawee- gbeebua, kaa na nawee- gbeesĩĩ sẽnsye. ");
INSERT INTO xrb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu n te bur bua gbe, pe fua- syãm ne, ma yĩntaha kuã yir wãã yãhãyĩŋ kuɛ ye, ma Yãhã pye ma yee: «Ma syaha kẽ.» U n te bur la cɛr, ma re wãã u kãnyãrwai kẽ, pe n te la klaha nawee- kẽ. U n maha pe fua- syãm la ke syi pe byɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pe byɛ n di, ma sya di yai. ");
INSERT INTO xrb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pe n takũyĩhĩ sẽnsye syãŋ gbe tɛr te gbɛr ne, tii pe di yaha. ");
INSERT INTO xrb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mpãy pe ba te bur di, pe naam ya ba nawee- nyersĩĩ yĩĩbua tã. ");
INSERT INTO xrb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Loo kur ye, Yesu n ta tɛr u kãnyãrwai pye ma yee pe dugu dye ke salangbãŋ wo, pe dii ga ke langbãŋ kũndi ngaa ye, u yahasee ye, klo laa wo pe n yee Gbesyata. Woo n kuee kur ye, u kãnde wãã pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tuu kãnde wãã wa pe kẽ, u n ka yãŋ gaa yĩŋ na, ma ga nii u laam wũhũ tɔ̃r Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Yai n kua tã, ma ke salangbãŋ ta yaha ke langbãŋ telai wo. Yesu -sẽ pye u ya ya kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","U n yãã ke salaŋ sẽ waha naa n fã pe ye ye, teflaha tee naa pe wãã. Ke -sẽ pye ngupa cir kuiyale syi, u n yir ma n gaha pe kuɛ ye, ma nii yãr n gaha ke loho na, ma sya ne ga pe far tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pe kãnyãrwai n u yãã tuu n yãr ke loho na, pe n yee kusrãhã kẽ, ma too kule na ma n kui. ");
INSERT INTO xrb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pe byɛ yĩnde pye u na, pe n fya sɛr yigi nii. Yesu n ta tɛr pãã pe ne ma yee: «-Ye ye laam waha, ye ma syi fya ye, ndoo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","U n dugu dye pe ne ke salangbãŋ wo, ke teflaha n yɛr. Le n u kãnyãrwai laam wɔ maa far tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pe laam kacãn tee ba kloŋ tɛr, pe sẽ ba Yesu fãnga cã yɔ̃ ye, yaliile wo tuu ba te bur bua la cɛr te n nihi. ");
INSERT INTO xrb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu n ba ke langbãŋ dii wa u kãnyãrwai ne. Pe n tãhã Genesarɛ kuɛ kãntraha na, ma pe salangbãŋ pua yaha ke langbeŋ yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pe kãhã yi ke salangbãŋ wo, pe nawee- n ta tɛr Yesu yãŋ cã. ");
INSERT INTO xrb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pe n fã ga teebɛhɛ byɛ wo, maa yanfa tẽŋ n pai u kẽ pe kasãy wãn na. Mpãy pe naa u wĩĩ luhu teebɛhɛ byɛ wo, pe naa n pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Teelii teelii Yesu naa n gaha, kusyĩmbɛhɛ wo woo, kungbãhã wo woo, klɛ wo woo, nawee- naa n pai pe yanfa ne nanihi fla wo. Pe naa u nar u tyii pe yanfa n tɛ u nayrengbãŋ yɛ̃ ya na. Mpãy byɛ pe -sẽ yãã naa n tɛ ke na, pe naa n jaa. ");
INSERT INTO xrb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Per gaa, Farisyɛ̃ ye tesẽ Yãhã kaiyarfa ne, pe ba yir Yurusalɛm wo, ma pa Yesu fla na. ");
INSERT INTO xrb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pe n ba yãã Yesu kãnyãrwai mpãy sẽ naa pe kluɛ yee pe wãlɛ kãnde wãyee na, ma cã naa pe dir di ye. ");
INSERT INTO xrb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Le -sẽ pye ke dyaŋ, Farisyɛ̃ ye ma suhu pe nampyeŋ- Yiifee- byɛ ne, pe sẽ naa ngaa di mii pe sẽ cãã pe kluɛ yee gbɛgbɛ pe wãlɛ kãnde wãyee na ye. ");
INSERT INTO xrb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pe ma yir nanihi teebɛhɛ wo ma ba dye, pe saa di mii pe sẽ cãã loho wey wa gbɛgbɛ ye. Pe wãlɛ kãnde wũhũ ba nihi, pe -sẽ ba ke byɛ yigi mii crãŋ wãyee ter dyaŋ ke ya ya, sekuhu wãyee ne, ntẽngbãhã wãyee ne. ");
INSERT INTO xrb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Koo kẽ pe Farisyɛ̃ tesẽ pe Yãhã kaiyarfa ne, pe n Yesu yey ma yee: «Nwa ta ma kãnyãrwai sẽ wo wãlɛ kãnde wũhũ pye ye? Ma sẽ yãã, pe sẽ pe kluɛ yee wo wãlɛ kãnde wãyee na ma cã pe dir di ye.» ");
INSERT INTO xrb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu n pe pye ma yee: «Dawarfa me ye ne! Faale Yãhã kaplãŋ tɔ̃rfua Yisa tãhã kẽ tuu bii nde cãã yar yaha ye wĩĩ na, ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹Nawee- mii, pe ra gboho pe yɛ̃ kaplãŋ ya ne, ma -sẽ yee pe laam wo pe fla dey tɛr ra na. ");
INSERT INTO xrb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pe ra gboho mii syi dyaŋ, yĩŋ wee le na ye. Nawee- pe kãnde lii ta, pe tee loo ta, ma n klaha ma yee Yãhã kãnde ne.› » ");
INSERT INTO xrb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu n maha pe pye ma yee: «Ye Yãhã kãnde ta yaha kãnkãy na, ma nii nawee- kãnde loo yar. ");
INSERT INTO xrb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ye -sẽ Yãhã koo kãnde wũhũ miy yaha cã, ye ye wãlɛ kãnde wũhũ ta. ");
INSERT INTO xrb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ye sẽ yãã, wo faale wãdyaha Musa bii le pãã Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹Ma tuhufua gboho, ma nahafua ne;› tesẽ: ‹Wii ma u tuhufua miipihi yee u nahafua ne, u yai pe u boo kãã.› ");
INSERT INTO xrb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yii -sẽ nawee- klaha, a nawee ga waha u tuhufua pye u nahafua ne, u yee: ‹Ta koho kla gii tẽ ne ga waha wãã ma kẽ ma n di, ke ma korobaa;› le yĩntaha ne, n ke ta yaha Yãhã kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ke syi, woofua ga waha tyii u tuhufua wãkẽŋ na, u nahafua ne. ");
INSERT INTO xrb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ye n pye koo syi, ma Yãhã kaklaha miy n yaha, ma ye wãlɛ kaklaha gbe n yar nawee- na. Kai- busãã maha ma tee n pye ngĩĩ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu n maha pe nabuar yee ba, maa pe yar ma yee: «Ye byɛ, -ye yaha le ye luhu ra ye, -tee le cã! ");
INSERT INTO xrb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngaa wee ke n yir nkur ye, ma nawee le kapee- wãpyeŋ wo ye. Kai- nkãy nawee tuu n ga, koo kẽ ke u le kapee- wãpyeŋ wo.»  ");
INSERT INTO xrb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃! ");
INSERT INTO xrb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu tuu ba pe nabuar ta yaha, ma ga dye nwoŋ laam wo, u kãnyãrwai n ga u yey le kakuãcran yĩntaha ne. ");
INSERT INTO xrb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","U n pe pye ma yee: «Ye bya, ye maha le kakuãcran yĩntaha war gblihi laa kɛ? Ye sẽ cã la ngii ke n dye nawee nfẽŋ wo, koo sẽ kẽ ke u le kapee- wãpyeŋ wo ye? ");
INSERT INTO xrb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ke ma sya dye ga u nfẽŋ wo, ke n gaha yi kãã u laha wo nyɛ̃ wo, ke sẽ ma ne dye ga u laam gasaha wo ye.» Yesu le yar ke syi nawee- n waha cã wãfãŋ wee digi gaa ter na ye. ");
INSERT INTO xrb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu n maha pe yar ma yee: «Nkãy nawee tuu n ga, koo ke u le kapee- wãpyeŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ye sẽ yãã, nawee tuu kapee- nkãy ga u ya laam wo, koo kapee- kẽ ke ne u taha tyatyãhã na, yuhur ne, naboor ne, ");
INSERT INTO xrb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cayɔr wãleŋ ne, war yĩnde ne, laangbãn ne, dawar ne, wãplaŋpye ne, yĩnde wãyitoo ne nawee- wãn na, kawar wãfua ne, yataŋ ne, nafããn pyer ne. ");
INSERT INTO xrb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Koo kapee- ngĩĩ byɛ nawee tuu n ga, ke u le kapee- wãpyeŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu n tɛr ke fla yaha, ma ka Tyir kuɛ syi ye, Syidɔ̃ ne. U n ga dye kaha gaa wo, u sẽ naa n traha pe u wãpa wĩĩ luhu ye. Pe -sẽ le luhu. ");
INSERT INTO xrb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cɔɔ waa, sãndũpee pye u pueesya yĩŋ na, u n Yesu wĩĩ luhu, ma ta tɛr ga u fla na, ma ga kãnklũy gbãã u tãy. ");
INSERT INTO xrb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","U cɔɔ sẽ pye Yiifeesya ye, u naa n yi Fenisye wo, Syire kãntraha na. U n Yesu nar, u u sãndũpee tege kãã u pueesya yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu n u pye ma yee: «Maʼa kicar digi gbe miy yaha pãmpii kẽ, le sẽ yɔ̃ ye.» ");
INSERT INTO xrb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","U cɔɔ n yee: «Cĩĩnde ne Yĩŋfua, kicaabir ma car gii miy yaha kãntraha na, pãmpii sẽ -sẽ ga gbe di la?» ");
INSERT INTO xrb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Loo na, Yesu n -sẽ u pye ma yee: «Kapãn nde wĩĩ na, maa waha dur ga ma kaha wo, u sãndũpee tege kãã wa ma pueesya yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","U n dur ga u kaha wo, maa u pueesya yãã tuu sãy nii kasãy wãŋ na. U sãndũpee ba tege kãã u pueesya yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu n ba tɛr kãã Tyir kuɛ yaha, ma tɛr Syidɔ̃ klo wo, ma dye yi tɛr te kui sẽnsye wo, ma dur ba Galɛlɛ langbãŋ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nawee- mpãy n pa u kẽ nditẽŋ naa waa ne, u sẽ maha waha pãã naa n yɔ̃ ye. Pe Yesu nar tuu koho taha u na, u u jaa. ");
INSERT INTO xrb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu n u yigi yi pe nabuar laam wo, ma ka u ne kãnkãy na, maa u kãmbɛhɛ le u ndityuhu wo, ma yɛ̃syɔ̃r tu ma ta u yĩnkãi na. ");
INSERT INTO xrb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Loo na, u n yĩntaha kuã yir wãã yãhãyĩŋ kuɛ ye, ma wũũ tege, ma u dya pye Yiifee- yor wo ma yee: «Efata,» loo yĩntaha ne, yãr! ");
INSERT INTO xrb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","U dya ndityuhu n ta tɛr yãr, u yĩnkãi n sãhã yaha, u n nii n pãã nayɔ̃r saha na. ");
INSERT INTO xrb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nawee- mpãy pe pye ke fla na, Yesu n pe yar, pe ma syi le pãã waa ye ye. Tuu le pãã naa n waha pe ye mii syi dyaŋ, pe -sẽ ke kai- pãã naa n yi ke syi. ");
INSERT INTO xrb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Le wãjaa wĩĩ n pe nawee- fe gbe ga ta tɛr, pe n sya nii le pãã ma yee: «Nkãy byɛ u n pye, ke yɔ̃ cĩĩnde. U nditẽy ta pe n luhu, ma bebe bya ta pe n pãã.» ");
INSERT INTO xrb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Too plii na, nabuar maha ba te ya wãã ba ta. Ngaa sẽ pye pe nawee- ye pe n ga di ye. Yesu n u kãnyãrwai yee ba, maa pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nawee- mii fɛn ta yigi, pe plii tãã nanga pe ma ra ne, yagaa ngaa wee pe ye pe n ga di ye. ");
INSERT INTO xrb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","N ma pe dur wãã fãã ne pe klɛ wo, pe n gaha too wãfãy na kãnde wo. Ye sẽ yãã, mpãy ma pe nihi, pe yir deydey ma pa.» ");
INSERT INTO xrb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","U kãnyãrwai n u yey ma yee: «Dragba nge syi laam wo, waa dir yãã na pe kẽ pe n di?» ");
INSERT INTO xrb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu n pe yey ma yee: «Bur nii te ma ye ye?» Pe n yee wãy kuasĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Loo na, Yesu n pe nabuar ta pe n tege nii kãntraha na. U n te bur kuasĩĩ gbe, ma Yãhã pye ma yee: «Ma syaha kẽ.» U n te bur la cɛr, ma te wãã u kãnyãrwai kẽ, pe te la klaha pe nabuar kẽ; u kãnyãrwai n te la. ");
INSERT INTO xrb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Fuabir raa maha pye pe ye. Yesu n maha syaha wãã Yãhã kẽ, ma u kãnyãrwai ta pe n maha te fuabir la. ");
INSERT INTO xrb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pe byɛ n di, ma di yai. Tii pe di yaha, pe n te gbe tɛr takũyĩhĩ kuasĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nawee- mpãy pe pye ke fla na, pe ba nawee- nyersĩĩ kua. Loo kur ye, Yesu n kãnde wãã pe kẽ, ");
INSERT INTO xrb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma dugu dye ke salangbãŋ wo u kãnyãrwai ne, ma ka Dalameta kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Loo kur ye, Farisyɛ̃ ye n pa Yesu fla na. Pe n yee, poo ga u le namihi wo, ma u pye u laanwɔ wĩĩ laa pye, poo n waha cã Yãhã kẽ ke fãnga wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu n wũũ tege u ya laam wo ma yee: «Nwa ta yagaafa n kɛ pe laanwɔ wĩĩ yãã? Ta n cĩĩnde nde pãã ye ye, poo gɛ saa laanwɔ wĩĩ laa gɛ yãã yĩnde ne ye.» ");
INSERT INTO xrb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Loo kur ye u n tɛr pe yaha, maa dugu dye ke salangbãŋ wo, ma tɛr ke langbãŋ kũndi ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Koo per na, pe kãnyãrwai ba faha pe sẽ bur gbe yigi pe ya ne ye. Bur neŋ ya kẽ ke pye pe ye ke salangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu n ba pe pye ma yee: «-Ye yii le yaha, -tee yii yigi Farisyɛ̃ ye ne, tesẽ Yɛrɔte ne! Pe wĩĩ ma mii ncasur wãŋ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pe kãnyãrwai n nii pe ya yey ma yee: «Too sẽ bur gbe ye, loo la u n nii n pãã ke syi.» ");
INSERT INTO xrb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu n pe laam wũhũ cã, ma pe yey: «Nwa ta ye n yee, bur kẽ te wee wo ye ye, koo syi kẽ? Ye kacãn fĩhĩ kloŋ. Ye sẽ laa war wa ye. Ye laam yãã waha tɛr? ");
INSERT INTO xrb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yĩmpɛ ne ye ye, ye sẽ n yãŋ la? Ndityuhu ne ye ye, ye sẽ n luhu la? Ye laam yãã faha wa? ");
INSERT INTO xrb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tẽ ba te bur bua la cɛr wãã pe naam nyersĩĩ yĩĩbua kẽ, takũyĩhĩ nii ye ba gbe te bur gbɛr ne, pe ba tii di yaha?» Pe n yee takũyĩhĩ sẽnsye syãŋ. ");
INSERT INTO xrb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu n maha pe yey ma yee: «Tẽ ba te bur kuasĩĩ la cɛr wãã pe nawee- nyersĩĩ kẽ, takũyĩhĩ nii tee ba gbe te bur gbɛr ne, pe ba tii di yaha?» Pe n yee takũyĩhĩ kuasĩĩ. ");
INSERT INTO xrb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu n pe pye loo na ma yee: «Ke n ta ye sẽ le war wa ma yee, bur wĩĩ sẽ ne tẽ naa n pãã ye?» ");
INSERT INTO xrb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Loo kur ye, pe n ka Gbesyata wo. Nawee- n pa fũũ naa waa ne Yesu fla na, maa u nar u tɛ u fũũ naa na, u u jaa. ");
INSERT INTO xrb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu n u fũũ yigi koho na, ma yi u ne le klo kãnkãy na, ma ga yɛ̃syɔ̃r tu woo u fũũ yĩmpɛ na, ma kluɛ taha u na, ma u yey: «Ma waha ngaa yãã la?» ");
INSERT INTO xrb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","U fũũ n yĩmpɛ tẽŋ wãã ma yee: «N nawee- yãã, n pe yãã katyir dyaŋ te n yãr.» ");
INSERT INTO xrb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu n maha kluɛ taha u dya yĩmpɛ na, u n yãŋ wãã u yahasee ye temm. U ba jaa wa, ma waha wãn byɛ yãã naa n tãŋ gbɛgbɛ. ");
INSERT INTO xrb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Loo na, Yesu n kãnde wãã u kẽ u tɛr u kaha wo, ma -sẽ u pye ma yee, tuu ma syi ka le klo wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu n tɛr Filipe Syesarɛ kuɛ kui ye, u kãnyãrwai ne. Kãnde wo, u n pe yey yãŋ ma yee: «Lii gɛ nawee- pe n pãã ra wĩĩ na?» ");
INSERT INTO xrb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pe n yee: «Mpãy n yee, a Nsãn nawee- tããfua kẽ ma ne. Mpãy maha n yee, a faale Yãhã kaplãŋ tɔ̃rfua Yeli kẽ ma ne, mpãy maha ma pe n yee, a faale Yãhã kaplãŋ tɔ̃rfua waa kẽ ma ne.» ");
INSERT INTO xrb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","U n dur yagaa, ma pe yey ma yee: «Ah yii, ye yee yoo kẽ ra ne?» Pyar n u yɛ̃ sya ma yee: «Mboo kẽ u Yãhã Yĩndefua Crise.» ");
INSERT INTO xrb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu n le pãã waha pe ye ma yee, pe ma syi pe le tɔ̃r waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Loo kur ye, Yesu n yir, ma nii u kãnyãrwai pye ma yee: «U Nawee Puee yai u fãy gboho. Pe Yiifee- wãlɛ ga ba u wĩĩ sye, pe Yãhã yũndefa yĩŋfa ne, tesẽ pe Yãhã kaiyarfa ne. Pe ga ba ta gɛ ta pe n u boo. Plii tãã kur ye, u ga yir gbã wo u dur ba yrãŋ na gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu naa ke kai- gbɛgbɛ pãã pe ye. Pyar n u yee ga kãnkãy na, maa nii le kuãn u ye. ");
INSERT INTO xrb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu n dur, ma u kãnyãrwai yãŋ klaha, ma sã Pyar na ma yee: «Yũhũ kãã ra tãy Setane nwo! Ma sẽ Yãhã wũhũ cã ye, ma laam ga nawee kacãn ter ya ne.» ");
INSERT INTO xrb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Loo na, Yesu n pe nabuar yee ba u kãnyãrwai ne, maa pe yar ma yee: «Wii ma yee woo ga naa n yãr ta kãnde wo, u u laam wũhũ ta yaha, tuu u ya gbihi, u ma sya ga ba gbãpee ku ra wĩĩ na. Wii ma loo sya, u naa ta kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ye sẽ yãã, wii tuu u ya yĩŋ kɛ ma suhu driyɛ̃ wãn ne, woofua ga ba too byɛ kɛ laa. Wii tuu -sẽ ga le sya, u u yĩŋ kɛ laa ma suhu driyɛ̃ wãn ne, ta wĩĩ na tesẽ le Yãhã kapãyĩĩ wĩĩ ne, woofua kẽ tuu cã ga ba too nde byɛ yãã. ");
INSERT INTO xrb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mboo nawee, taa ga driyɛ̃ wãn byɛ yãã tãŋ, maʼa yee ma sẽ ba ma yĩŋ yãã Yãhã ye ye, le wãyĩĩ -sẽ ma na taa yãã? ");
INSERT INTO xrb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Koo kla ma na, nawee tuu ga ba waha kẽ tuu u ya yĩŋ yãã Yãhã tãy? ");
INSERT INTO xrb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ye sẽ yãã, yagaafa Yãhã kãnde miy yaha, ma nii kapee- pye. Wii ma yee fyar woo yigi pe yĩnde na, ndoo wĩĩ na tesẽ ra kaplãŋ wĩĩ ne, u wĩĩ bya ga ba fyar yigi ndoo u Nawee Puee kẽ, yaliile n n pai dur ba ra Tuhufua Yãhã nayɔ̃r ne tesẽ pe yãhãyĩŋ tẽnlɛhɛyɔ̃m ne.» ");
INSERT INTO xrb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu n maha pe yar taha ma yee: «Ta n cĩĩnde nde pãã ye ye: Nawee- mpãy ma ye laam wo, pe saa ku mii pe sẽ Yãhã Yai yãã ke pa fãnga ne ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Plii kuay kur ye, Yesu n Pyar yigi taha u ya na, Syake ne, Nsãn ne, ma ka pe ne yãnjruhu gaa yĩŋ na, poo pe ya ya. Yesu n wã klaha pe yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","U nayrɛ n nii n yɛhɛ palpal, kacãn gɛ sẽ pye ye, ma maha flege, waa sẽ ke syi wãflege ter syi yãã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe n faale wãlɛ Yeli yãã tesẽ Musa ne, pe ya kai na. Pe ba fe gbe yi, ma nii n pãã Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pyar n Yesu pye ma yee: «Wo Yĩŋfua, wo niisaha sroŋ yɔ̃ nwo wo! Waa kajar tãã gbã, neŋ ma wãŋ, neŋ Musa wãŋ, neŋ nge Yeli wãŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pe ba fya yigi nii, woo tesẽ pe kãnyãrwai syãm mii ne, koo kẽ tuu ga lii pãã u sẽ cã ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yãhãsyɔ̃r raa n yi, ma yĩm paha tã pe byɛ na. Yãhã yĩmbui n yir te yãhãsyɔ̃r laam wo ma yee: «Ta Dya kẽ nwo ne, u ntãŋ dye gboho ra tãy, -ye naa n luhu u ye!» ");
INSERT INTO xrb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Le yalebya wo, pe kãnyãrwai n yãŋ klaha pe ya tãy, pe sẽ maha waa yãã nantãŋ ye. Yesu ya u pye pe ne. ");
INSERT INTO xrb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pe naa ke yãŋ tege yaliile wo, Yesu n pe pye ma yee: «Tee lii yãã, yaʼa syi le tɔ̃r waa ye ye, mii u Nawee Puee sẽ ba ku, ma yir wa gbã wo, ma pa gbaafa ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pe n le sya, ma -sẽ nii pe ya yey ma yee: «Nwa syi wãyir wĩĩ ne gbã wo?» ");
INSERT INTO xrb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pe kãnyãrwai n Yesu yey ma yee: «Nwa ta pe Yãhã kaiyarfa n yee, a Yeli woo tuu ga cãã pa u Yãhã Yĩndefua Crise yaha?» ");
INSERT INTO xrb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","U n pe yar ma yee: «Cĩĩnde ne, Yeli woo tuu ga cãã pa, u ba ke kai- byɛ gbihi ta. Nwa le n -sẽ yrũhũ ta ke Yãhã sabangbãŋ wo ma yee, a u Nawee Puee ga ba wãfãy yãã gboho tɛr, u wĩĩ le maha ba fũhũ nawee- ye? ");
INSERT INTO xrb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ta n le pãã ye ye, Yeli -sẽ pa kãã wa, pe nawee- n ba u nar- pe laam wãnar-, mii le ba yrũhũ yar yaha ke Yãhã sabangbãŋ wo mii syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu n yir u kãnyãrwai tãã mii ne, ma n pai u kãnyãrwai mii fla na. Mpãy pe ba kuee, nabuar raa ba wɔ tã pe na. Yãhã kaiyarfa pye, pe naa kaplãŋ tyĩn pe kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pe nawee- pe Yesu yãã, le n pe fe gbe, pe n fã ga u wãã syaha ne. ");
INSERT INTO xrb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu n u kãnyãrwai yey: «Lii ne tee n tyĩn pe ne?» ");
INSERT INTO xrb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dya waa n kuee pe nabuar laam wo, ma u yɛ̃ sya ma yee: «Yĩŋfua, n pa ra dya ne ma fla na, sãndũpee waa ma tuu sye u na u sẽ waha n pãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Teelii teelii u sãndũpee ma u kicar yigi, u ga u gbe miy kãntraha na, u n naa yɛ̃syɔ̃play yi, tuu naa nkãhã gbã, u kadye ke sɛr tã nii. N ma kãnyãrwai nar pe u sãndũpee kar kãã u yĩŋ na, pe sẽ waha yia ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu n kuãn pe na, ma yee: «Yii poo na, laanyɔ̃m wee ye ye ye, ye sẽ ra ta ye Yatɛr ye! Ye yee la n kuee ye wãwlaha na yalebyɛ? Ye yee la n naa n fãy ye ne yalebyɛ? -Ye pa ra kẽ u kicar ne.» Pe n pa u ne u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","U kicar tuu kãhã Yesu yãã, u sãndũpee n ta tɛr u kicar sege gbe fãnga ne. U n too, ma nii kloŋ n klaha kãntraha na, yɛ̃syɔ̃play ne u yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu n u tuhufua yey: «Le yale dey la u na?» U tuhufua n yee: «Ãwã, u sãndũpee u gbe u kicar cãã na, ma sya ba waa yagaa na. ");
INSERT INTO xrb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","U sãndũpee ne u tra le wãã naa laam wo loho ne, ma ga u boo. Maʼa ga waha laa pye, ma wo fɛn di, ma fĩhĩ yɔ̃ wo na!» ");
INSERT INTO xrb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu n u pye ma yee: «Ma sẽ yee la, a n ma ga waha laa pye? Wii woo u ra ta u Yatɛr, kai laa sẽ wee le ga waha u yia ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","U kicar tuhufua n ta tɛr tẽ sya ma yee: «N ma ta ra Yatɛr. Koho le ra ye, ta n ma sroŋ ta ra Yatɛr.» ");
INSERT INTO xrb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu n yãã te nabuar n pai pe fla na, u n sã u sãndũpee na ma yee: «Mboo sãndũpee wii raa kicar yɛ̃ pua n tã, ma u ndityuhu mar n tã, tege kãã kicar nwo yĩŋ na! Maʼa syi maha dugu yãã u yĩŋ na ye!» ");
INSERT INTO xrb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","U sãndũpee n kui, ma u kicar yɛhɛ fãnga ne, ma tege kãã u yĩŋ na. U kicar n sãy nii nakugu wãŋ syi. Pe nawee- busãã n sya yee u ku. ");
INSERT INTO xrb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu n u yigi koho na, ma u ta u n yir, ma tãhã yɛr ncaha ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu tuu ba dye kaha wo, u kãnyãrwai n u yee kãnkãy na, ma u yey ma yee: «Nwa ta wo sẽ ba waha u sãndũpee kar tege kãã ye?» ");
INSERT INTO xrb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu n pe yar ma yee: «Sãndũpee nwo syi waha kar tege n kãã Yãhã wãnar ya ne.» ");
INSERT INTO xrb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu tesẽ u kãnyãrwai ne pe n tɛr ke fla yaha, ma dye yi tɛr Galɛlɛ kãntraha wo. U sẽ naa n traha nawee- pe cã u ma teelii wo ye, ");
INSERT INTO xrb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","u naa u kãnyãrwai klaha, koo kẽ. U naa pe yar ma naa n yee: «Pe ga ba u Nawee Puee yi u napĩĩ- kẽ, pe n u boo. U gbã plii tãã wuhu, u ga yir gbã wo u pa gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","U kãnyãrwai sẽ naa kaplãŋ ngĩĩ yĩntaha cã u ne ye, ma -sẽ ba fya, pe sẽ ba u yey laa ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Loo kur ye, pe n ga dye Kapornu wo. Yaliile Yesu tuu pye kaha laam wo, u n u kãnyãrwai yey ma yee: «Ye naa lii pãã kãnde wo?» ");
INSERT INTO xrb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pe n yaha le. Kãnde wo, pe tee naa pe ya kɛ, ma naa n yee poo laam wo yoo ma yĩŋ na? ");
INSERT INTO xrb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu n tege nii, ma u kãnyãrwai sẽnsye syãm yee, maa pe yar ma yee: «Wii ma yee woo ga yĩŋ yãã, woofua u naa n nii ye byɛ kur ye, -tuu maha nii ye byɛ tẽntẽle!» ");
INSERT INTO xrb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Loo na, u n kicaalaale gbe ta pe yahasee ye, ma le gbe yigi u kluɛ wo ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wii ma kicaabir mii syi waa gbihi yigi ta myaha na, ndoo gɛ kẽ tuu gbihi yigi. Wii ma -sẽ ra gbihi yigi, ndoo ya sẽ kẽ u gbihi yigi ye. Yãhã gɛ kẽ tuu gbihi yigi, koo gii ke ra lɛhɛ wãã.» ");
INSERT INTO xrb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Loo kur ye, Nsãn n Yesu pye ma yee: «Wo Yĩŋfua, wo dya waa yãã tuu sãndãpee kar tege naa n kãã nawee- yĩŋ na ma myaha ne. Wo n ba yee, u wee wo ne ye, ma u kar tã.» ");
INSERT INTO xrb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu n u pye ma yee: «Yaʼa n sye u na ye, wii tuu laanwɔ wĩĩ pye ra myaha ne, woofua saha ta tɛr dur u wãpee pãã ra wĩĩ na ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wii ma yee u sẽ wo laha ye, u ma wo ne. ");
INSERT INTO xrb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wii ma yee ye ma u Yãhã Yĩndefua Crise nna, ma sekuyĩĩ nen wãã ye kẽ loho ne u myaha na ye n wɔ, ta n le pãã ye ye cĩĩnde, ufua ga ba kayũhũ yãã Yãhã ye.» ");
INSERT INTO xrb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu n maha yee: «Mpãy pe ma pra kicar wãŋ syi, ma ra ta pe Yatɛr, wii ma poo nen waa ta u n yi kãã ra kãnde wo, le ga pee woofua na. Pe ma sya cãã ntẽmbangbãŋ pua u yĩntyigi na, ma u gbe miy le wãã langbãŋ wo, u sẽ yãã loo kapee nde yãã pye ye, ke puar u na. ");
INSERT INTO xrb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Le ma pye ma koho ma le kapee- wãpyeŋ wo, cãã ke cɛr kãã. Ma cĩĩnde yrã yãã koho neŋ ne, koo puar ma kuee ma kluɛ sĩĩ ne, taa ba ka naa fla laam wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Le ma pye ma troho ma le kapee- wãpyeŋ wo, cãã ke cɛr kãã. Ma cĩĩnde yrã yãã troho neŋ ne, koo puar ma kuee ma trɛ sĩĩ ne, pe n ba ma gbe miy le wãã naa fla laam wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Le ma pye ma yĩnde ma le kapee- wãpyeŋ wo, le loho yi. Ma cĩĩnde yrã yãã yĩnde nen ne, koo puar ma kuee ma yĩmpɛ syãŋ ne, pe n ba ma gbe miy le wãã naa fla wo, naa gii wãfegeyãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Koo fla wo, fyãr rii te nawee kadye kaa yalebyɛ, te sẽ n ku ye; ke naa sẽ maha fege n yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tetege n le diŋ wo, ke diŋ n gbihi ta Yãhã kẽ. Koo syi, nawee bya yai u dye wãfãy naa wo, u gbihi ta Yãhã kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tetege ma kayũhũ. Ke ma -sẽ sar, le kua. Waa saha ke ta ke n dur naa n tãy ye. Ye yai ye tetege le ye laam wo, -tee naa n nii yrĩŋ ne yii ne!» ");
INSERT INTO xrb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu tesẽ u kãnyãrwai ne, pe n tɛr ke fla yaha, ma ka Yudɛ kuɛ ye, ma maha ka Yurdane lafeŋ kũndi ngaa ye. Nabuar n maha pe ya wãã ba ta u tãy, u n nii pe klaha peplii wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farisyɛ̃ mpãy n yũhũ crã u na, ma yee poo ga u le namihi wo, ma u yey ma yee: «Ma laam wo, nawee ga waha u cɔɔ sye la?» ");
INSERT INTO xrb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu n pe yɛ̃ sya kayey laa ne ma yee: «Wo faale wãdyaha Musa bii kãnde lii yar le wĩĩ na?» ");
INSERT INTO xrb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pe n yee, a Musa yee ma cãã saba yrũhũ wãã ma cɔɔ kẽ, taa cã ba u sye. ");
INSERT INTO xrb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Loo na Yesu n pe pye ma yee: «Ye laam waha, koo syi kẽ u n bii loo kãnde nde yrũhũ yar ye na. ");
INSERT INTO xrb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ke kai- fegbecãã na, Yãhã bii wãn byɛ pye, ma nawee tãhã, naa tesẽ cɔɔ ne. ");
INSERT INTO xrb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Le ma le yrũhũ Yãhã sabangbãŋ wo ma yee: ‹Koo syi kẽ, naa ricar koho ma ba dye, u n cɔɔ sya, u ga u ya yɛ̃ yi kãã u seefa tãy, ");
INSERT INTO xrb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","u ke wãã le u cɔɔ wãŋ ne, pe n nii pe ya ne.› » Yesu n pe yar taha ma yee: «Loo na, pe wee syãm nantãŋ ye, pe ma mii nawee nen ya yagaa. ");
INSERT INTO xrb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yãhã ke tii gbra te ya na, nawee ma syi u te cããŋ te ya na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yaliile Yesu loo pãã wa, u n dye u kãnyãrwai ne kaha laam wo. Pe kãnyãrwai n maha u gbihi yey le ne. ");
INSERT INTO xrb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","U n pe pye ma yee: «Naa wii ma u ya koho cɔɔ sye, ma cɔɔ waa gbe, u cayɔr pye, u kapee pye u cɔɔ na wii tuu sye. ");
INSERT INTO xrb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Cɔɔ bya ma u puai sye, ma ga naa waa gbe, u cayɔr pye, u kapee pye u puai na wii tuu sye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nawee- n pa kicaabir ne Yesu fla na, tuu koho taha pe na, u Yãhã nar pe wĩĩ na. Pe kãnyãrwai n kuãn pe na. ");
INSERT INTO xrb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu tuu nde yãã, le n fyar yigi u kẽ. U n u kãnyãrwai pye ma yee: «Ye tyii pe kicaabir na, pe n pa ra ye! Yaʼa n sye pe na ye! Ye sẽ yãã, mpãy pe ma pra poo wãŋ syi dyaŋ, Yãhã Yai ma poo wãŋ. ");
INSERT INTO xrb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ta n cĩĩnde nde pãã ye ye: Wii ma yee u sẽ Yãhã Yai wĩĩ sya yigi yaha u laam wo kicar wãŋ syi dyaŋ ye, woofua saa dye yãã Yãhã Yai wo ye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Loo na, u n pe kicaabir gbe yigi u kluɛ wo, ma koho taha pe byɛ na, ma Yãhã nar pe wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu n ba kãnde sya wa u kãnyãrwai ne, ma n tɛr. Dya waa n fã ba, maa kãnklũy gbãã u yahasee ye, ma u yey ma yee: «Yĩŋfuayɔ̃, n ga waha lii pye n cĩĩnde yrã yãã, lii wãkuayãã wee le na ye?» ");
INSERT INTO xrb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu n u pye ma yee: «Nwa ta ma n yee n yɔ̃? Waa sẽ yɔ̃ mii Yãhã ya sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ma sẽ Yãhã kãnde kataŋ wũhũ cã la, nkãy ke yar yaha ma yee: ‹Maʼa syi ma cayɔr le ye; maʼa syi ma nawee boo ye, maʼa syi ma yuhu ye; maʼa syi ma kawar fua ye; maʼa syi ma dugu waa na ye; naa ma tuhufua gboho, ma nahafua ne!› » ");
INSERT INTO xrb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","U dya n u pye ma yee: «Yĩŋfua, ta ricar wo n koo ngĩĩ byɛ yigi, ma sya ba waa yagaa na.» ");
INSERT INTO xrb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu n u yãŋ, u wĩĩ n tãy u ye, u n u pye ma yee: «Katɛ nen laa kuee ma ye: Ka, maa ma koho wãn byɛ par tãŋ, -taa pe war byɛ wãã tãŋ nawãm kẽ! Loo na, ma -sẽ ga ba nii nangbãŋ Yãhã ye. -Taa pa, ma ba taha ra na!» ");
INSERT INTO xrb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaplãŋ ngĩĩ sẽ tãy u dya ye ye, u n tɛr. U laam ba wlãhã, u tee pye nangbãŋ. ");
INSERT INTO xrb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu n u kãnyãrwai yãŋ klaha, ma pe pye ma yee: «Nangbãm wãdye wĩĩ Yãhã Yai wo, le war!» ");
INSERT INTO xrb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kaplãŋ ngĩĩ n pe kãnyãrwai fe gbe. Yesu n maha pe yar ma yee: «Cĩĩfa, Yãhã Yai wãdye wĩĩ sroŋ war mpãy ye pe pe koho taha yaha wale na! ");
INSERT INTO xrb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yũhũmii wãdyeyitɛr mensãn wihi ne, le ma fãhãfãhã ma tɛr nangbãm wãdyeyaha Yãhã Yai wo.» ");
INSERT INTO xrb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaplãŋ ngĩĩ n maha pe kãnyãrwai laam wɔ ma ga ta tɛr. Pe n nii pe ya yey, a nangbãm ma yee pe saa waha pe yĩy yi yaha ye, yoo syi -sẽ ma u ga waha u yĩŋ yi yaha? ");
INSERT INTO xrb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu n pe yãŋ ma pe pye ma yee: «Kai laa ne le nawee yia, n sẽ yee Yãhã ye. Ye sẽ yãã, Yãhã koo n yia kai- byɛ na.» ");
INSERT INTO xrb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pyar n nii u pye ma yee: «Yĩŋfua, yãŋ, wo tɛr wo kãnkai- byɛ yaha, ma taha ma na.» ");
INSERT INTO xrb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu n yee: «Ta n cĩĩnde nde pãã ye ye: Wii ma tɛr u kaha yaha, tesẽ u nampyesey ne, u nahafua ne, u tuhufua ne, u pii ne, u tar ne, ta wĩĩ na tesẽ le Yãhã kapãyĩĩ wĩĩ ne, ");
INSERT INTO xrb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u ga too syi flɛ gbeebua yãã kãntraha nge na. U ga klɛ yãã, tesẽ nampyesey ne, nahafa ne, kicar ne, tar ne, wãfãy bya ne ta wĩĩ na. Sukũhũ gaa laam wo u ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mpãy pe ma yahasee ye yagaa, poo fãnga ga ba nii kur ye, mpãy pe -sẽ ma kur ye yagaa, poo ga ba yahasee yãã.» ");
INSERT INTO xrb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu tesẽ kãnyãrwai mpãy ne, pe ba kãnde sya yagaa, ma dugu naa n tɛr Yurusalɛm wo. Yesu naa n yãr pe yahasee ye, pe ba fya. Yesu n maha u kãnyãrwai sẽnsye syãm cɛr yi, maa nii kai- tɔ̃r pe ye, kai- nkãy ke ga ba u dye ke yagaa nge na. ");
INSERT INTO xrb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","U n pe pye ma yee: «-Ye yãŋ, Yurusalɛm kẽ too dugu n gaha. U Nawee Puee ga ba yi pe Yãhã yũndefa yĩŋfa kẽ tesẽ pe Yãhã kaiyarfa ne. Pe ga yɛr u wãboo wĩĩ na, pe u wãã mpãy kẽ pe sẽ cĩĩnde Yãhã cã ye. ");
INSERT INTO xrb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Poo pe ba naa u lɛr, pe yɛ̃syɔ̃r tu naa n woo u na, pe naa u gbã sãngblã ne, pe ba u boo. Plii tãã kur ye, u ga yir gbã wo, u pa gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Loo na, Sewede pii n pa Yesu tãy, Syake tesẽ Nsãn ne, ma ba u pye ma yee: «Wo Yĩŋfua, waa ma nar kai laa ne, maʼa le pye wo kẽ le ga tãy wo ye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu n pe yey ma yee: «Ye yee n nwa pye ye kẽ?» ");
INSERT INTO xrb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pe n yee: «Maʼa ba nii kai- byɛ yĩŋ na ma nayɔ̃r fla wo, tyii wo n nii nen nwo ma kãndigi koho kuɛ ye, nen nwo ma kãmaŋ koho kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu n pe pye ma yee: «Tee lii nar ye sẽ le cã ye. Wãfãy tii tẽ n pai sya, yaa waha te sya la laa, yaa waha wãfãy wãtãã nge sya la, kii tẽ n pai tãã?» Pe n yee poo ga waha yia. ");
INSERT INTO xrb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yesu n pe pye ma yee: «Cĩĩnde ne, yaa ra wãfãy syi sya, tee maha ra wãfãy wãtãã syi yãã. ");
INSERT INTO xrb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma -sẽ yee mpãy pe ga ba nii ra kãndigi koho kuɛ ye, ta kãmaŋ koho kuɛ ne, n saha poofa yãŋ yi ye. Too niisar gbihi ta mpãy kẽ poo niisar ne te ne.» ");
INSERT INTO xrb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pe kãnyãrwai sẽnsye mii pe le luhu, pe laam n war Syake ye ne Nsãn ne. ");
INSERT INTO xrb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu n pe byɛ yee ba, maa pe yar ma yee: «Ye cã mpãy pe ma kãntrɛ kui yĩŋfa, pe nawee- nar-, tesẽ pe nangbãm bya maha pe fãnga yar pe na. ");
INSERT INTO xrb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Le sẽ -sẽ wee ke syi ye ne ye. Wii ma yee u ga yĩŋ yãã ye laam wo, woofua yai u nii ye byɛ tẽntẽle. ");
INSERT INTO xrb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Wii ma yee u ga yahasee fla yãã ye laam wo, woofua yai u nii ye byɛ yãmpuai. ");
INSERT INTO xrb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ye sẽ yãã, u Nawee Puee sẽ pa nangbãn yĩmbui ne ye, u pa u n pai nii tẽntẽle nawee- byɛ ye, u u yrã wãã u ku, u nabuar par sya, u pe yi pe kapee- wãpyeŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pe naa n gaha Yurusalɛm wo, ma ga dye Yerekɔɔ wo. Yesu ba le klo yi yaha wa u kãnyãrwai ne, pe nabuar ne. Fũũ naa waa -sẽ pye, tuu ba tege nii kãnde yɛ̃ na, ma naa n nar. Pe naa u yee Timɛ dya Bartemi. ");
INSERT INTO xrb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tuu luhu pe yee Nasarɛtefa Yesu n pai, u n nii n tẽ ma yee: «Dawide Dya Yesu, ta fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nawee- naa n kuãn u na ma yee, tuu yaha le; u n cã maha naa n kui fãnga ne loo na ma yee: «Dawide Dya, ta fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu n luhu, ma yɛr ma yee: «-Ye u yee ba!» Pe n u fũũ yee, ma u pye ma yee: «Ma laam yĩn, ma yir, u ma yee». ");
INSERT INTO xrb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","U fũũ n u nayrengbãŋ miy yaha, ma kur ye yir, ma pa Yesu ye. ");
INSERT INTO xrb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu n u yey ma yee: «Ma yee n nwa pye ma kẽ?» U fũũ n yee: «Yĩŋfua, ta ra n waha naa n yãŋ faale wãŋ syi.» ");
INSERT INTO xrb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu n u pye ma yee: «Naa n gaha, taa ra ta ma Yatɛr, loo le ta ma n jaa.» ");
INSERT INTO xrb_vpl VALUES ("MK10_53","071_10_53","MRK","10","53","53","U yĩmpɛ n ta tɛr yãr le yalebya wo, u n nii n taha Yesu na le kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu tesẽ u kãnyãrwai ne, pe n ga nɔ gbe taha Yurusalɛm wo, Gbefasyɛ tesẽ Gbetane kusyĩmbɛhɛ kuɛ ye, yãŋ gaa tãy. Katyir raa ter pye ke fla na, pe naa te yee wolifyɛ katyir. Yesu n u kãnyãrwai syãm mpãy lɛhɛ wãã yahasee ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«-Ye ka kusyĩnde ndaa wo ye yahasee ye! Yaʼa kãhã ga n dye, yaa kãnkonyainge gaa yãã, ke pua yaha nii, waa sẽ dugu yãã ke na ye. -Ye ke sãhã ba nwo! ");
INSERT INTO xrb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wii ma ye yey ma yee, nwa ye n ke sãhã, -ye ufua pye ye yee, ke wĩĩ ma wo Yĩŋfua na. U ma pye wa ke ne, u ga ke dur wãã ye kẽ yagaa nge na.» ");
INSERT INTO xrb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pe n ka, maa kãnkonyainge gaa yãã, ke pua yaha nii nkur ye kapahayɛ̃ gaa na. Pe n ke sãhã. ");
INSERT INTO xrb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nawee- mpãy pe pye, poo mpãy n pe yey ma yee: «Nwa tee n pye, nwa ta ye n ke kãnkonyainge sãhã?» ");
INSERT INTO xrb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yesu tuu ba pe yar lii ne, pe n le pãã pe nawee- ye, pe n tyii pe na pe n tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pe n pa ke kãnkonyainge ne Yesu kẽ, ma pe nayrengbãy taha ta ke na, Yesu n dugu nii te na. ");
INSERT INTO xrb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nabuar raa n te ya wãã Yurusalɛm kãnde yɛ̃ na. Pe n nii u gboho, poo busãã n pe nayrengbãy yaha ta le kãnde wo, mpãy n kayay ka te wan ne tar laam wo ma ba ta le kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mpãy pe naa n yãr Yesu yaha ye, tesẽ mpãy ne pe naa n taha u na, pe n nii nuhu di, ma nii le gble ma n yee: «Ma myaha ke gboho! Mboo wii taa n pai Yĩŋfua Yãhã myaha ne, Yãhã ke kaa taha ma na. ");
INSERT INTO xrb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Yãhã ke kaa taha wo faale wãdyaha Dawide yai na, kii ke n pai wo ye. Nawee- byɛ pe naa Yãhã miingbãŋ gboho!» ");
INSERT INTO xrb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu n dye Yurusalɛm wo, ma ka ke Yãhã kangbãŋ laam wo. Tuu ke yãŋ klaha wa, u n ta tɛr ga Gbetane wo, u kãnyãrwai sẽnsye syãm ne, yai tee ba kua kua wa. ");
INSERT INTO xrb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ke yĩŋsyii wo pe naa n yi Gbetane wo, fãã n Yesu yigi. ");
INSERT INTO xrb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","U n nasar nkugu katyigi gaa yãã. Tuu ke yãã deydey ke wan ne, u n ka, maa ke yãŋ, ngaa ma pye ke na u tai di. Tuu yũhũ crã ke katyigi na, u sẽ n ngaa yãã ke na mii wan ya sẽ kẽ ye. Ke wãsa cãã sẽ ba kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu n pãã ke katyigi ne ma yee: «Waa saa ma pii yãã di nantãŋ ye.» U kãnyãrwai n luhu ke kaplãŋ ne tuu pãã. ");
INSERT INTO xrb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pe n ga dye Yurusalɛm wo. Yesu n ga dye ke Yãhã kangbãŋ laam wo. Mpãy -sẽ mii pe pye, pe naa cãã troho ke Yãhã kangbãŋ laam wo. Yesu n pe kar yir, ma warturfa tabal ye kuã cããr, tesẽ nasar kate parfa kãnay ne. ");
INSERT INTO xrb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","U sẽ tyii waa na u n kapar kla gaa gbe n tay ke Yãhã kangbãŋ laam wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","U n pe klaha ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹Ta kangbãŋ ga nii ta seysaha nawee- ter byɛ ye.› Yii -sẽ ke ta yuhu- dyeniisaha.» ");
INSERT INTO xrb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pe Yãhã yũndefa yĩŋfa pe le luhu tesẽ pe Yãhã kaiyarfa ne, pe n nii u wãboo wĩĩ kɛ, ma -sẽ ba fya u na. U wãklaha ter ba naa n tãy pe nawee- byɛ ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Koo per yainkɔŋ wo, Yesu n maha yi le klo wo u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Koo yĩŋsyii sukũhũntãy na, Yesu tesẽ u kãnyãrwai ne, pe n maha ba tɛr loo kãnde nen ne, ma ke nasar nkugu yãã. Ke ba waha tãŋ ke nnen bya ne. ");
INSERT INTO xrb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pyar laam n too Yesu niinge kaplãŋ na, nkãy tuu ne pãã ke katyigi ne. U n Yesu pye ma yee: «Yĩŋfua, yãŋ, taa ne katyigi gii sẽ yoosẽn ne, ke nge ke waha tãŋ nii.» ");
INSERT INTO xrb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu n u kãnyãrwai yar ma yee: «-Ye Yãhã ta ye Yatɛr! ");
INSERT INTO xrb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ta n cĩĩnde nde pãã ye ye: Wii ma Yãhã ta u Yatɛr, u ga waha yãŋ nge pye: Yũhũ kãã, ka ma ga too dye langbãŋ laam wo! U ma yee u sẽ laalaa gbã u laam wo ye, ma le ga yigi ma yee le ga pye, tuu lii pãã le -sẽ ga pye cĩĩnde u yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Koo kẽ n ga ye yar: Yaʼa nii ngii ngii nar Yãhã ye, -ye le ga yigi ye laam wo, ye yee ye ke kla yãã wa; ke -sẽ ga wãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tesẽ, yaʼa yir yɛr, ma nii ye laam wũhũ tɔ̃r Yãhã ye, waa kayaan -sẽ nde ye laam wo, ye tyii u kapee fuɛ na ye kuãŋ ne. Ke syi, yãhãyĩŋ na ye Tuhufua Yãhã bya -sẽ ga ba ye kapee- gbe kãã ye yĩŋ na.  ");
INSERT INTO xrb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yaʼa -sẽ yee, ye sẽ n tyii waa kapee- fuɛ na ye kuãŋ ne ye, ye Tuhufua Yãhã bya sẽ -sẽ ga ba ye kapee- gbe kãã ye yĩŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pe n maha ba pa Yurusalɛm wo. Yesu tuu maha ba gbey n klaha ke Yãhã kangbãŋ laam wo, pe Yãhã yũndefa yĩŋfa n pa maa yɛr u tãy, tesẽ pe Yãhã kaiyarfa ne, ma suhu pe wãlɛ ne. ");
INSERT INTO xrb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Pe n u yey ma yee: «Kai- ngĩĩ byɛ raa n pye, ma ke pye kãnde lii na? Yoo kãnde wãã ma kẽ ma naa ke pye?» ");
INSERT INTO xrb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu n pe yɛ̃ sya ma yee: «Ta bya, n ga ye yey katɛ nen laa ne; yaʼa ra yar, ta bya -sẽ ga ye yar n kai- ngĩĩ pye kãnde lii na. ");
INSERT INTO xrb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoo tuu ba Nsãn lɛhɛ wãã u n ba nawee- tãã naa n yi loho wo? Yãhã laa, nawee-? -Ye ra yar!» ");
INSERT INTO xrb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pe n ga nii le klãŋ n pãã pe ya ya ma yee: «Waʼa yee Yãhã kẽ ke ba u nɔ wãã, u ga wo pye, a nwa wo sẽ -sẽ ba u Nsãn kaplãŋ sya cĩĩnde ye? ");
INSERT INTO xrb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wo sẽ -sẽ ga waha yee nawee- me pe ba u lɛhɛ wãã ye.» Pe ba fya pe nabuar na, pe byɛ le sya cĩĩnde ma yee Nsãn pye Yãhã kaplãŋ tɔ̃rfua. ");
INSERT INTO xrb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Loo na, pe n ba Yesu pye ma yee, poo cã na? Yesu n -sẽ pe pye ma yee: «Yaʼa yee ke syi, ta bya n saa ye yar n kai- ngĩĩ pye kãnde lii na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Loo kur ye, Yesu n kakuãcran nde pãã pe ye ma yee: «Dya waa ba defĩĩ katyir tar le, ma te klaha tã, ma ke defĩĩ pii yĩĩtyaha cɛr, ma dur ma te tar sẽŋsaha fla fãã. Tuu koo pye wa, u n te tar yaha tawarfa mpãy ye, ma tɛr yrãhã ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te defĩĩ pii yiyale le ba nɔ, u tarfua n kuee, ma tẽntẽle waa lɛhɛ wãã pe tawarfa ye, u ga woo lay sya ba. ");
INSERT INTO xrb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe tawarfa n ga u yigi, ma u gbã, ma u dur wãã kãnwai ne. ");
INSERT INTO xrb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","U tarfua n dur, ma maha u tẽntẽle waa lɛhɛ wãã pe tawarfa ye. Pe n maha ga woo gbã yĩŋ kuɛ ye, ma dur ma u tyɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","U tarfua n maha waa ter lɛhɛ wãã ke tɛhɛ tãã wuhu na. Pe n ga woo yigi, ma u boo. U tarfua n maha tẽntẽbir busãã nɔ wãã koo syi. Pe tawarfa n gbãr taha mpãy na, ma mpãy boo. ");
INSERT INTO xrb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","U tarfua dya nen waa pye, u ntãŋ ba dye gboho u tãy. U n woo lɛhɛ wãã pe ye kur ye ma yee: ‹Laa na, pe n gaha nagboho ta woo na.› ");
INSERT INTO xrb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pe tawarfa n ga pe ya pye ma yee: ‹Wii tuu ga ba nii tarfua, woo kẽ nwo. -Too u boo, te wãn byɛ n ba nii wo wãn!› ");
INSERT INTO xrb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pe n u dya yigi, ma u boo, ma u nakugu gbe miy yi wãã te defĩĩ tar nkur ye.» ");
INSERT INTO xrb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu n pe nawee- yey ma yee: «Yagaa, u tarfua ga lii pye? U ga ba pa, u ba pe tawarfa mii boo kãã, tuu te tar yaha nawee- mpãy ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","N cã ye kapãn nde yãã kal Yãhã sabangbãŋ wo, lii le n yee: ‹Ntẽmblaha gii nwonfããfa pe ba sye yaha, koo ntẽmblaha kẽ ke dur yĩŋ yãã ke nwoŋ wãfãã wo. ");
INSERT INTO xrb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yãhã ke lii pye, loo ne nde. Laanwɔ wĩĩ ne too n yãã yĩnde ne.› » ");
INSERT INTO xrb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pe Yiifee- yahaseefa pe yãã Yesu tuu kakuãcran nde pãã wãã pe kẽ, pe n nii u yigisaha kɛ, ma -sẽ ba fya pe nabuar na. Pe n tyii u na ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Loo kur ye, pe Yiifee- yahaseefa n ga Farisyɛ̃ mpãy nɔ wãã Yesu ye, tesẽ Yɛrɔte nawee- mpãy ne ma yee, pe ba u plaha yigi kayey laa ne. ");
INSERT INTO xrb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pe n pa, maa Yesu pye ma yee: «Yĩŋfua, wo cã ma cĩĩnde ya pãã. Ma sẽ n fya nawee yĩnde na ye. Nawee ma sya nii mii syi dyaŋ, le sẽ kai kua ma ye ye. Ma nawee- klaha cĩĩnde ya ne Yãhã kãnde wãyãr wĩĩ na. Wo yar nde ne: Wo kãnde na, wo yai la kufar wãwãã ne fãngafa byɛ yĩŋfua kẽ laa, wo sẽ yai te wãwãã ne u kẽ ye? Wo naa re wãã laa, waʼa syi naa re wãã ye?» ");
INSERT INTO xrb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu -sẽ ba cã pe sẽ laha u ye ye. U n pe pye ma yee: «Nwa ta ye n ta wãleŋ kɛ namihi wo? -Ye ga pa ra kẽ ntẽn war waa ne ta n ba yãŋ!» ");
INSERT INTO xrb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pe n ga pa ntẽn war waa ne. Yesu n pe yey ma yee: «Yoo yirfua pe pye ta u na nwo, u myaha ne?» Pe n yee, a u fãngafa byɛ yĩŋfua yirfua kẽ u myaha ne. ");
INSERT INTO xrb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Loo na, Yesu n pe pye ma yee: «Ah -ye naa u fãngafa byɛ yĩŋfua dãã u myaha wãn ne, -tee naa Yãhã dãã ke myaha wãn ne!» Yesu kapãn nde n pe laam wɔ. ");
INSERT INTO xrb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yiifee- yahaseefa mpãy pe naa n yee Sadusyɛ̃, pe n pa Yesu fla na. Poo me pe n yee, a mpãy pe ku wa, pe saa ba yir gbã wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Pe n Yesu yey ma yee: «Yĩŋfua, wo faale wãdyaha Musa bii kãnde laa yar wo na, le nde: ‹Naa ma pye cĩĩfua ne, ma ba ku u cɔɔ yaha, kicar sẽ kẽ u ye ye, u cĩĩfua yai u u calangusya gbe, pe n kicar see u lɛfua kẽ, wii tuu ku.› ");
INSERT INTO xrb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ãhã, dya waa -sẽ pye, cĩĩfa kuay ne. U dya n ba cɔɔ sya, ma ku u yaha, puee sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","U taha n u calangusya gbe, ma ba ku u yaha, puee sẽ maha kẽ. U taha n u gbe, loo katɛ nen ya. ");
INSERT INTO xrb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Koo syi ya, koo syi ya, poo kuasĩĩ byɛ n u cɔɔ yãã cã cɔɔ, pe sẽ -sẽ puee yãã see u na ye. Loo kur ye, u cɔɔ n ba ku u ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mpãy pe ku wa, pe ma ba yir gbã wo per gii, u cɔɔ ga ba nii yoo wũũ pe laam wo? Poo kuasĩĩ byɛ sẽ u yãã cã la cɔɔ?» ");
INSERT INTO xrb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu n pe yɛ̃ sya ma yee: «Ye plaha loo nde ne ma yee, a mpãy pe ku wa, pe saa ba yir gbã wo ye. Ye sẽ Yãhã sabangbãŋ wũhũ cã ye, ye sẽ maha Yãhã fãnga cã ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ye sẽ yãã, mpãy pe ku wa, pe ma ba yir gbã wo, pe ga nii mii yãhãyĩŋ tẽnlɛhɛ wãŋ syi dyaŋ yãhãyĩŋ na. Naam tesẽ ca ne, pe saa ba naa pe ya gbe ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","-Ye yãŋ, Musa lii yrũhũ yaha Yãhã sabangbãŋ wo nakur wãyir wĩĩ na gbã wo, -ye ye laam too le na! U yee Yãhã yĩmbui yi le ngur wambule fla na, ma u pye ma yee: ‹Ndoo tẽ ma Yãhã Brama ye, Yisyake ne, Dyakuba ne.› » ");
INSERT INTO xrb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Loo na, Yesu n pe yar laha ma yee: «Mpãy pe ku, pe ma yrãŋ Yãhã yĩnde na. Yii tee n yee nakur saa ba yir gbã wo ye, ye sroŋ plaha loo nde ne.» ");
INSERT INTO xrb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yãhã kaiyarfua waa ba luhu ke kaplãŋ ne pe Sadusyɛ̃ pe naa n tyĩn Yesu ne. Tuu yãã Yesu pe Sadusyɛ̃ yɛ̃ sya ma pe gbihi yar cĩĩnde ne, u n yũhũ crã u na, ma u yey ma yee: «Yãhã kãnde kataŋ wo, lii loo le ma yĩŋ?» ");
INSERT INTO xrb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu n u yɛ̃ sya ma yee: «Yãhã kãnde kataŋ wo, lii le ma yĩŋ, loo ne nde: ‹Yiisrɛfa, -ye naa n luhu! Yãhã neŋ ya ke ma, Yãhã gii ke ma wo Yĩŋfua.› ");
INSERT INTO xrb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tesẽ: ‹Ta, ma Yĩŋfua Yãhã wĩĩ n naa n tãy ma ye, le tɛr wãn byɛ yaha, le gboho tãŋ ma laam byɛ wo, le nii tãŋ ma yrã byɛ na, ma kacãn byɛ n pye tãŋ loo na, ma fãnga byɛ ne.› ");
INSERT INTO xrb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lii le -sẽ taha le na, loo ne nde: ‹Ma ya wĩĩ le n tãy ma ye mii syi dyaŋ, tyii ma nampyeŋ wĩĩ n naa n tãy ma ye ke syi.› Yãhã kãnde kataŋ wo, laa sẽ tɛr koo syãŋ ngĩĩ yaha ye.» ");
INSERT INTO xrb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","U Yãhã kaiyarfua n Yesu pye loo na ma yee: «Ãwã Yĩŋfua, lii raa pãã le cĩĩnde pua kẽ: Yãhã ya kẽ ke ma Yãhã. Yãhã gaa sẽ maha wee nantãŋ mii koo ya sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Loo ne, nawee yai Yãhã wĩĩ le gboho tãŋ u laam byɛ wo, u kacãn byɛ n pye tãŋ loo na, le n nii tãŋ u yrã byɛ na, u fãnga byɛ ne. Tesẽ, u ya wĩĩ le n tãy u ye mii syi dyaŋ, u nampyeŋ wĩĩ le tãy u ye ke syi. Koo kataŋ syãŋ ngĩĩ puar wãn wãboo tesẽ te wãsuhu na Yãhã kẽ, ma suhu diŋ wãyiŋ ne.» ");
INSERT INTO xrb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu tuu yãã u Yãhã kaiyarfua kai- ngĩĩ pãã laantor ne, u n u pye ma yee: «Ma laam wo, ma le sya gbe taha wa ma yee ma ma Yãhã Yai wũũ.» Loo kur ye, waa sẽ maha sya, ma u yey laa ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu pye ke Yãhã kangbãŋ laam wo, ma naa nawee- klaha. U n ba kayey nde yey ma yee: «Yãhã kaiyarfa pye mii ma yee, a u Yãhã Yĩndefua Crise ma wo faale wãdyaha Dawide kur kuɛ puee waa? ");
INSERT INTO xrb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yãhã Yrã Fãnga ke pye Dawide na, woo gɛ bii le pãã ma yee: ‹Yĩŋfua Yãhã ta Yĩŋfua pye ma yee: Pa tege nii ta kãndigi koho kuɛ ye kai- byɛ yĩŋ na, ta n sya ba ma napĩĩ- yĩy kor le ma kẽ, pe n nii mii ma tãnde fyãhã tã pe na.› » ");
INSERT INTO xrb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yesu n pe yey ma yee: «Dawide gɛ tuu naa u Yãhã Yĩndefua yee Yĩŋfua, u Yĩŋfua -sẽ ga maha pye mii u nii Dawide kur kuɛ puee waa?» Pe nabuar naa n luhu Yesu ye nuhu ne. ");
INSERT INTO xrb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","U naa pe klaha, ma naa pe yar ma yee: «Ye ma syi ye naa n yãŋ Yãhã kaiyarfa na ye, poo mpãy pe pe ya yi nayrengbãy ne, pe le n tay. Pe maha n yãŋ pe naa pe syar nangbãsyaha ne nanihi teebɛhɛ wo. ");
INSERT INTO xrb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yiifee- yawãhã nwey wo, tesẽ nanihi sedi flɛ wo, niisar rii nawee- byɛ yĩnde le yi n too re na, too syi niisar pe ne kɛ pe nii. ");
INSERT INTO xrb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Poo me pe calangusyam koho wãn byɛ sya n kãã pe ye, pe dur pe pe ya ta naweeyɔ̃m dyaŋ, pe Yãhã ka syar kaplãmbuar ne, pe sya ma-. Koo byɛ wãpẽn draha ga ba pe dye, ke la ke sya gboho tɛr.» ");
INSERT INTO xrb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ke Yãhã kangbãŋ laam wo, teelaa fla ma, nawee- pe ne ga war le yaha Yãhã kẽ. Yesu n ka, ma ga nii ke fla na, ma nii pe nawee- yãŋ war lesaha wo. Walefa mpãy naa war le dege. ");
INSERT INTO xrb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Calangusya nawũũ waa n ba nɔ, ma ntẽn war puabɛhɛ nkãy le, wãm syãm ya. ");
INSERT INTO xrb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu n u kãnyãrwai yee ba, maa pe yar ma yee: «Ta n cĩĩnde nde pãã ye ye: U calangusya nwo kla le, ma sya ta tɛr pe nawee- mii byɛ yaha. ");
INSERT INTO xrb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","War mpãy nawee- mii pe sya n le dege, pe wee kla pe yĩnde na ye. Cɔɔ nwo u nawãn ne, tuu car gii le, koo ya ke -sẽ pye u ye. Ngaa sẽ maha wee u ye u n ga di ye.» ");
INSERT INTO xrb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu tuu naa n yi ke Yãhã kangbãŋ wo u kãnyãrwai ne, u kãnyãrwai waa n u pye ma yee: «Wo Yĩŋfua, te Yãhã kangbãŋ nwey wãfãã yãŋ! Ntẽmbar rii pe ta, ma re fãã te wãyɔ̃ŋ!» ");
INSERT INTO xrb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu n u yɛ̃ sya ma yee: «Yãhã kangbãŋ wãgboho nge taa yãã, ke ga ba too. Ntẽmblaha neŋ gaa gɛ saa ba taha ta nii ke nampyeŋ na ye; te byɛ ga ba traha.» ");
INSERT INTO xrb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Loo kur ye, Yesu pye ke wolifyɛ katyir yãŋ yĩŋ na. U pye u ba nii, ma yĩntaha sroŋ ke Yãhã kangbãŋ ne. U kãnyãrwai resyar mpãy n yũhũ crã u tãy. Pyar ye ba me, Syake ne, Nsãn ne tesẽ Andere ne. Poo ya n Yesu yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Wo Yĩŋfua, taa naa ke Yãhã kangbãŋ wãtoo wĩĩ pãã, wo yar ke tooyale ne cigege, ma suhu kayar lii ne le ga ba waha ta nawee- n koo kai- ngĩĩ pyeyale cã.» ");
INSERT INTO xrb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu n -sẽ too ke kai- na, ma nii pe yar ma yee: «-Ye naa yii yigi, waa kawar ma syi waha ba ye yĩntar figi ye! ");
INSERT INTO xrb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ye sẽ yãã, nawee- busãã ga ba ta myaha taha pe ya na, pe naa kawar fua pe yee, a poo me u Yãhã Yĩndefua. Pe ga ba nawee- busãã wlaŋ koo ne. ");
INSERT INTO xrb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ye ma ba luhu pe yee naan ma tũntũn woo, te ma deydey woo, yaʼa syi ye fya ye! Koo kayĩhĩ yai ke dye, le sẽ -sẽ ga ba pye driyɛ̃ wãkuaŋ le yalebya wo ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nawee- tergaafa ga ba naa naan miy ter gaa ne. Yĩŋfua waa ga ba yir u nawee- ne, u ga naan miy yĩŋfua waa ter ne. Kãntraha wãyɛhɛ ga ba nihi kubɛhɛ nkãy wo. Fããpihi ga ba dye. Ke kãnkai- ga ba nii mii calaifua wãn dyaŋ te ma ne yir u na, te naa u yaa. ");
INSERT INTO xrb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yii poo na, -ye naa yii yigi ye kãnkai- wo! Nawee- mpãy ga ba ye yigi naa n gaha kasãhã saha wo, pe ga naa n sãhã. Gbãr, ye wãn kẽ te ne Yiifee- yawãhã nwey wo. Pe ga ba ye yigi naa n gaha fãngafa mpãy yaha ye, tesẽ yĩŋfa mpãy ne ndoo wĩĩ na. Loo gɛ ga ba nii yĩŋ, ye n waha ta wĩĩ pãã pe yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Le Yãhã Yai kapãyĩĩ yai le cãã pãã kãntraha terfa byɛ n le luhu, kai- ngĩĩ n cã ba pye. ");
INSERT INTO xrb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pe ma ye yigi per gii ma n gaha ye ne kasãhã saha wo, ye ma syi ye ntãŋ cɛr ye naa n yee, kapãn sẽ n gaha yãã ye yɛ̃ na ye. Ke fla na, kaplãŋ nkãy ma ga too dye ye laam wo, -ye koo pãã! Ke saa pye ye laam kaplãŋ ye, Yãhã Yrã Fãnga wũhũ kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nawee- mpãy ga ba pe nampyesey wãã pe n boo ta wĩĩ na. Tuhufa mpãy ga ba loo pye pe pii na. Kicar mpãy ga ba wã klaha pe pe seefa laha, pe ta pe n pe boo. ");
INSERT INTO xrb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ye wĩĩ ga ba fũhũ nawee- byɛ ye ta wĩĩ na. Wii ma -sẽ waha plãhã kuee ra kur ye ke kãnkai- byɛ wo, Yãhã ga ba u sya yaha.» ");
INSERT INTO xrb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kaplãŋ nkãy ke n taha, wii ma ke kal u yai u ke war yɔ̃! Yesu n maha yee: «Yaa ba cĩĩnde kapihi yãã fla ngii wo ke sẽ yai ke pye ye. Loo yale wo, mpãy pe ga ba pye Yudɛ wo, pe fã naa n gaha yãy kuɛ koho na. ");
INSERT INTO xrb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wii ma ba pye gbegbaha yĩntraha wo, u ma syi yee woo ga tege dye nwoŋ wo, u ga wãn taa gbe yigi ye. U naa n fã! ");
INSERT INTO xrb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wii ma ba pye u tar wo, u ma syi yee woo nayrengbãŋ kuee kaha wo, woo ga dur ga ke gbe ye. U naa n fã! ");
INSERT INTO xrb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Too plii nde na, ca mpãy pe ma laha ne, tesẽ mpãy ne pe ma pii ne pe n wãr, pe fɛn ga ba gboho tɛr. ");
INSERT INTO xrb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","-Ye naa Yãhã nar te fee plii nde ma syi sroŋ wɛrngbãn cãã ne ye! ");
INSERT INTO xrb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ye sẽ yãã, Yãhã ke driyɛ̃ tãhã, ma sya ba waa yagaa na, too plii nde fɛn wãpee syi sẽ yãã yãã ye. Te syi saa maha ba yãã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yãhã ma ne yee ke sẽ yɛr kaa wãyikãã na te wãfãy plii yɛ̃ na ye, waa yĩŋ gɛ saa ne wloho yi ye. Ke -sẽ yɛr koo kaa wãyikãã na ke laampii wĩĩ na, mpãy ke yãŋ yi pe nii ke wãm. ");
INSERT INTO xrb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Loo na, wii ma ye pye, a u Yãhã Yĩndefua ma nwo, u Yãhã Yĩndefua ma nwaala, yaʼa syi le sya ye! ");
INSERT INTO xrb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ye sẽ yãã, kawar Yãhã yĩndefa tesẽ kawar Yãhã kaplãŋ tɔ̃rfa ne, pe ga ba yi. Pe ga ba naa yɛ̃kã wũhũ pye, tesẽ laanwɔ wũhũ ne, pe naa nawee- wlaŋ. Mpãy gɛ Yãhã pe yãŋ yi, pe ma yee pe sẽ waha pe ya na ye, pe ga waha wlaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","-Ye naa yii yigi, n nwo tẽ ye cãã n yar ke kai- byɛ ne! ");
INSERT INTO xrb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Too fɛn nde plii kur ye, yai ga ba gbã tã, yroŋ saa ba pye cãã- ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yrompii ga ba kuã too kãntraha na; ke yãhãyĩŋ wãn byɛ ga ba gbã wlãhã te ya wo. ");
INSERT INTO xrb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Loo na, nawee- byɛ ga ba u Nawee Puee yãã yãhãsyɔ̃r na, tuu n pai fãngangbãŋ ne, maha yãhãyĩŋ nayɔ̃r ne. ");
INSERT INTO xrb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","U ga ba yãhãyĩŋ tẽnlɛhɛ nɔ wãã driyɛ̃ teebɛhɛ byɛ wo. Nawee- mpãy pe yãŋ yi, pe yãhãyĩŋ tẽnlɛhɛ ga pe byɛ wãã driyɛ̃ kur byɛ wo.» ");
INSERT INTO xrb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu n maha pe yar kakuãcran ne ma yee: «Nasar nkugu ke wo klaha lii ne, ye yai ye le cã. Ye sẽ yãã, ke katyigi ma kayampẽn yi, ma maha wampẽn fe, yaa cã ke wãsa yale nɔ gbe taha. ");
INSERT INTO xrb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Koo syi dyaŋ, ye ma ba kai- ngĩĩ yãã ke n pye, ye -sẽ cã u Nawee Puee ma, u dur n pai. ");
INSERT INTO xrb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ta n cĩĩnde nde pãã ye ye: Yagaafa byɛ saa ku tãŋ mii kai- ngĩĩ sẽ pye poo mpãy yĩnde na ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ke yãhãyĩŋ tesẽ ke kãntraha ne, te ga ba kua kãã te saa ba pye ye; ta kaplãŋ koo -sẽ na, koo ga nii wãkuayãã saa pye ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu n maha pe gbihi yar taha ma yee: «U Nawee Puee wãdurbaŋ ke n pai dye per gii, waa sẽ koo per cã tesẽ le yale ne ye. Yãhãyĩŋ tẽnlɛhɛ gɛ pe ma yãhãyĩŋ na, pe sẽ ke per cã ye. Ndoo ke Dya, ta bya sẽ ke per cã ye. Ta Tuhufua Yãhã ya ke le cã. ");
INSERT INTO xrb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tee sẽ ke per cã ye, -ye yii yigi, ye ma syi ye ba pye ye sã wãy ye! ");
INSERT INTO xrb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Le ga ba nii mii dya waa wãŋ syi dyaŋ, tuu ka yrãhã ye. Tuu ga tɛr, u u kaha yaha u tẽntẽbir kẽ, pe naa ke yigi. U ke tẽŋ la klaha pe byɛ kẽ, ma u kapahayɛ̃ sẽŋfua pye u yĩntaha ta, u ma syi u sã wãy ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ye byɛ, yaʼa syi ye sã wãy ye, ye ma n faha yii na ye! Ndoo wii, n ma mii u kahafua dyaŋ, ye sẽ ta wãdurba yale cã ye: Yainkɔŋ laa, yĩndyaha laa, ngupa wãkui yale laa, sukũhũntãy laa, ye sẽ le cã ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta wãdurbaŋ ga ba ye fe gbe; ye ma syi ta n ba ye yãã tee sã wãy ye. ");
INSERT INTO xrb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tẽ lii pãã ye ye, n le pãã nawee- byɛ ye: Ye ma syi ye ba sã wãy ye faha yii na ye!» ");
INSERT INTO xrb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yiifee- gbar tii pe n yee syayaha gbar, te wãdyeŋ ba kuee plii sĩĩ. Too plii ba wãã dye gbar tii ne pe sẽ ncasur bur di te na ye. Pe Yãhã yũndefa yĩŋfa tesẽ pe Yãhã kaiyarfa ne, pe Yesu yuhu naa n kɛ, pe ma u yigi pe u boo. ");
INSERT INTO xrb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pe n pe ya klaha ta ma yee: «Wo saha u yigi te gbar yale wo ye. Mii loo sẽ ne ye, pe nawee- ga waha yir, pe yee le sẽ yai poo ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu pye Gbetane wo u kãnyãrwai ne, Syimu kaha wo, Syimu wii tuu pye gber. Yesu ba tege nii wa nawee- ne, ma ga sro di. Cɔɔ waa n ba dye yablater ntẽmblaha bule ne u koho wo. Lasekole waa ter pye le wo, pe n yee nardi, nawãm sẽ naa u dir yey ye. U cɔɔ n le bule yɛ̃ naha ka, ma u lasekole woo Yesu yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nawee- mpãy pe pye ke fla na, le sẽ tãy mpãy ye ye. Pe n yɛ̃ kuã ma yee: «Lasekole nwo ter syi wãklaha- yĩŋ? ");
INSERT INTO xrb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pe ma ne u par war nagbey sẽnsye syi, ma pe war wãã fɛnfa kẽ, loo sẽ puar la?» Pe n nii n tyɔ̃r ma yee, u cɔɔ sẽ le pye yɔ̃ ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu n -sẽ pe pye loo na ma yee: «Ye tyii u cɔɔ na, u kayĩĩ pye ra kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ye sẽ yãã, yalebyɛ fɛnfa ma ye ne. Per gii ma yai ye ye, ye ga waha naa kayũhũ pye pe kẽ. Ndoo -sẽ nwo, n saa ba pye yãã ye ne nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cɔɔ nwo tuu yia lii na, loo tuu pye ra kẽ. Ye sẽ cã la, ta nakugu kẽ tuu cãã gbihi wa gbĩĩ wãleŋ na? ");
INSERT INTO xrb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta n cĩĩnde nde pãã ye ye: Pe ma ba le Yãhã kapãyĩĩ wũhũ tɔ̃r teelii teelii kãntraha nge na, pe ga u cɔɔ nwo bya wĩĩ pãã, lii tuu pye ra kẽ. U wĩĩ ma syi le faha yãã nawee- na ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pe Yesu kãnyãrwai sẽnsye syãm mii wo, waa pye pe naa u yee Syikaryɔtefa Yuda. U n ka, maa Yãhã yũndefa yĩŋfa pye, woo n traha u Yesu yi pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pe le luhu, le n tãy pe ye, pe n yee pe ga ba u kẽ war yɛ̃ gaa ne, Yuda n nii Yesu wãyi wĩĩ kɛ pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Te gbar rii Yiifee- sẽ ncasur bur di ye, te ba nɔ wa. Ke per cir na, pe ne mbapẽnge boo. Koo per na Yesu kãnyãrwai n u yey ma yee: «Ma laam wo, ma yee too ga te syayaha gbar dir yĩntaha yi na ma kẽ?» ");
INSERT INTO xrb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu n u nawee- syãm mpãy lɛhɛ wãã, ma pe pye ma yee: «-Ye ka Yurusalɛm laam wo, ye n gaha dya waa wãã sya lakugbãi ne, tuu tẽŋ yĩŋ na. -Ye naa n taha u na! ");
INSERT INTO xrb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","U ma ga dye kaha gii wo, -ye u kahafua pye ye yee: Wo Yĩŋfua yee, nwoŋ gii tuu n pai syayaha gbar dir di u kãnyãrwai ne, ke ma na? ");
INSERT INTO xrb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U ga ye yar nwongbãŋ gaa na, ke kaha gbegbaha yĩŋ na. Yaa ke nwoŋ yãã ke laam ne, ke gbihi ta nii wa, wãn byɛ ne ke wo. Koo fla kẽ tee ga te dir yĩntaha yi wo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pe kãnyãrwai mii n ka le klo wo. Yesu tuu ba pe yar mii, pe n ga yãã ke syi, ma te syayaha gbar dir yĩntaha yi. ");
INSERT INTO xrb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ke yainkɔŋ wo, Yesu n pa u kãnyãrwai sẽnsye syãm ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pe pye pe naa n di nantãŋ, Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Yii mpãy tee n di ra ne, ye laam wo waa ma u ga ra yi ta napĩĩ- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Le n pe kãnyãrwai byɛ laam wlãhã, pe n nii u yey pe ya wuhu na ma n yee: «Yĩŋfua, ndoo la?» ");
INSERT INTO xrb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu n pe yɛ̃ sya ma yee: «Yii nawee- sẽnsye syãm mii nen waa kẽ, wii ruu u koho wãã le ra ne wãcɛŋ tasa laam wo. ");
INSERT INTO xrb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cĩĩnde ne, u Nawee Puee ga ku mii le yrũhũ ta nii Yãhã sabangbãŋ wo mii. Wii fɛn te -sẽ ga cã pee, woo kẽ wii ne tuu u yi u napĩĩ- kẽ; myaha ne u ma ne see gɛ see ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pe naa n di, Yesu n bur gbe, ma syaha kẽ Yãhã ye, ma ke la cɛr wãã u kãnyãrwai kẽ ma yee: «-Ye sya di, ke ma ta kadye draha wo!» ");
INSERT INTO xrb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","U n maha defĩĩ sekui gbe, ma syaha kẽ Yãhã ye, ma le sekui wãã pe kẽ, pe byɛ n wɔ. ");
INSERT INTO xrb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","U n pe pye ma yee: «Pe ma ta ntɔ̃r draha wo, ta ntɔ̃r rii te ga woo, nabuar ntãŋ n cã dye Yãhã tãy, naambiyãrfãn tii ke bii le pe ne te n cã yĩntaha ta. ");
INSERT INTO xrb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta n cĩĩnde nde pãã ye ye: N saa maha defĩĩ wɔ yãã kãntraha nge na ye. N ga ka Yãhã yai klo wo, n cã ga koo fla defĩĩ wɔ.» ");
INSERT INTO xrb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Loo kur ye, pe n Yãhã sey yay taa ne, ma yir ma ka ke wolifyɛ katyir yãŋ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ke wolifyɛ katyir yãŋ yĩŋ na, Yesu n u kãnyãrwai pye ma yee: «Ye byɛ ga ba dur yi ta kur ye. Le yĩntaha ma le yrũhũ ta yaha Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹N ga ba u mbanaha gbã boo, pe mbaa byɛ n fã cããŋ.› » ");
INSERT INTO xrb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yesu n pe yar taha ma yee: «Ta wãku kur ye, n ma ba yir gbã wo, n ga ba cãã tɛr ye yaha Galɛlɛ kãntraha wo.» ");
INSERT INTO xrb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pyar n u yɛ̃ wãã sya ma yee: «Mii byɛ ma sya ga ba dur yi ma kur ye, ndoo saa yi kãã ma kur ye ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu n u pye ma yee: «Ta n cĩĩnde nde pãã ma ye: Ke nanga yĩmper nge bya wo, ngupuai saa kui u tɛhɛ syãŋ tã ye, ma -sẽ ga ta wĩĩ kai tɛhɛ tãã, ma yee ma sẽ ndoo cã ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pyar n maha le gbihi gbey pãã taha ma yee: «N saa ba le kai n yee n sẽ ma cã ye, n ma sya ga gbã ku ma ne.» Pe kãnyãrwai mii byɛ n loo nen ya pãã pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Loo kur ye, pe n ga nɔ fla ngaa na pe n yee Gesanɛ. Yesu n u kãnyãrwai pye ma yee: «-Ye nii kuee nwo, ta n ga Yãhã nar.» ");
INSERT INTO xrb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","U n Pyar yigi taha u ya na Syake ne, Nsãn ne. Pe naa n gaha, u ntãŋ n nii u cɛr fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","U n pe pye ma yee: «Ta laam byɛ wlãhã, ma nii mii gbãku wĩĩ laa dyaŋ. -Ye kuee nwo wo, ye ma syi ye sã wãy ye!» ");
INSERT INTO xrb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","U n faa ka yaha ye, ma ga kãnklũy gbãã kãntraha na, ma pãã Yãhã ne ma yee, a le ma yai ke ye, loo yale wãfãy le kuã tɛr woo na. ");
INSERT INTO xrb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tuu naa n pãã Yãhã ne mii le nde: «Yãhã ra Tuhufua, ma yia kai- byɛ na. Le kayĩhĩ yale kuã tɛr ra na, lii le n pai nde. N sẽ -sẽ yee ta laam wĩĩ le pye ye, ma laam wĩĩ loo le n naa n pye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tuu loo pãã wa, u n dur ba u kãnyãrwai tãã mii fla na, ma ba pe yãã pe sã wãy. U n Pyar pye ma yee: «Syimu, ma sã wãy! Ke n ta ma sẽ waha kuee yrãŋ, ma yalaale gɛ dye ye? ");
INSERT INTO xrb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ye byɛ, yaʼa syi maha sã wãy ye! -Ye naa Yãhã nar ye ma syi ye ba dye kapee- wãpyeŋ wo ye! Nawee laam yĩĩ kayũhũ wãpye wĩĩ ne, u -sẽ nɔ gbɛr ke wãpyeŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","U n maha tɛr u ya ya yahasee ye, ma maha ga pãã Yãhã ne ke faale wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","U n dur ba, ma maha ba u kãnyãrwai yãã wãy na; pe wãy n sya naa pe yĩnkaasyikuey ndege pe kẽ. Pe ga u yɛ̃ sya lii ne pe sẽ le cã ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tuu ga dur ke tɛhɛ tãã wuhu na, u n pe pye ma yee: «-Ye maha sã wãy, ma n wũũ! Le kua, ke yai ke dyaŋ, le yale nɔ wa. -Ye naa n yãŋ, pe ga u Nawee Puee yi kapeepyefa kẽ yagaa. ");
INSERT INTO xrb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","-Ye yir wo n tɛr! Ye sẽ yãã, dya wii tuu ra yi ta napĩĩ- kẽ, u nwo u n pai.» ");
INSERT INTO xrb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu naa n pãã nantãŋ, Yuda n pa. Pe kãnyãrwai sẽnsye syãm mii waa ba kẽ u ne. Nabuar raa pye u ne, yũntruɛ̃ ne, tesẽ kãhã ne. Pe Yãhã yũndefa yĩŋfa, tesẽ pe Yãhã kaiyarfa ne, ma suhu pe wãlɛ ne, poo kẽ pe ba pe lɛhɛ wãã, pe ba Yesu kɛ yigi. ");
INSERT INTO xrb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","U Yuda wii tuu ba yi kãã Yesu kur ye, u n pe nawee- yar yaha naambiyãr syaha gaa ter ne, pe n waha Yesu cã. U ba pe pye ma yee: «Dya wii tẽ ga ba syar naambiyãr syaha ne, yaa cã woo kẽ tee n kɛ. -Ye ba u yigi yɔ̃ kãnkãŋ, ye ka u ne!» ");
INSERT INTO xrb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda tuu ba nɔ, u n ta tɛr yũhũ crã Yesu na, ma u pye ma yee: «Yĩŋfua», ma u syar ke naambiyãr syaha ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe nawee- mii n -sẽ koho taha Yesu na, ma u yigi. ");
INSERT INTO xrb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yesu kãnyãrwai mpãy pe pye, poo nen waa n u yũntrũhũ kuã, ma Yãhã yũndefa yĩŋfua tẽntẽle gbã, ma sya ndityɛ gbã cɛr kãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu n pe nawee- pye ma yee: «Tee pa ra yigisaha wo yũntruɛ̃ ne tesẽ kãhã ne, kapeepyefua la ra ne? ");
INSERT INTO xrb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Plii byɛ n pye ye ne, ma naa nawee- klaha Yãhã kangbãŋ laam wo, ye sẽ -sẽ ra yigi koo fla na ye. Nkãy ke bii cãã yrũhũ yar yaha Yãhã sabangbãŋ wo, koo kẽ ke n pye yagaa.» ");
INSERT INTO xrb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Loo na, u kãnyãrwai byɛ n fã tɛr u yaha. ");
INSERT INTO xrb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naanfãnde laa naa n taha Yesu na. U pye fai laa ya ne u kadye na. Pe n yee pe ga u yigi. ");
INSERT INTO xrb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","U n le fai miy yaha, ma fã tɛr kadyepua ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Loo kur ye, pe Yesu yigifa n ka u ne Yãhã yũndefa yĩŋfua fla na. Pe Yãhã yũndefa yĩŋfa byɛ, pe wãlɛ ne, tesẽ pe Yãhã kaiyarfa ne, pe n pe ya wãã ba ke fla na. ");
INSERT INTO xrb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pyar -sẽ pye u yuhu dey naa n taha Yesu na, ma sya ba dye u Yãhã yũndefa yĩŋfua kaha wo, ma tege nii wlãhã ke kaha sẽŋfa ne ndyin wo, ma naa waha pe ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pe Yãhã yũndefa yĩŋfa tesẽ pe kaplãŋ cɛrwai byɛ ne, pe n nii kapee- kɛ gbe pãã n taha Yesu na, kapee- nkãy syi ke ga waha ta pe n yee Yesu yai wãboo ne. Pe sẽ -sẽ waha laa kapee yãã u wĩĩ na ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nawee- kawar fua naa n taha Yesu na, ke kaplãŋ sẽ -sẽ naa ke ya gbe ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mpãy ter n yir loo na ma yee, ");
INSERT INTO xrb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","a poo le luhu u yɛ̃ na tuu yee, a ter Yãhã kangbãŋ nge nawee- pe fãã nge, woo ga ba ke yoho, tuu dur u ke fãã plii tãã nsoho wo. Ke saa maha pye nawee- pe ke fãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pe kaplãŋ sẽ maha ke ya gbe loo nde na ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","U Yãhã yũndefa yĩŋfua n yir loo na, nawee- byɛ yĩnde na, ma Yesu yey ma yee: «Nkãy nawee- mii pe pãã n taha ma na, ma saa pe yɛ̃ wãã sya la?» ");
INSERT INTO xrb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu n yaha le u sẽ laa wãã sya ye. U Yãhã yũndefa yĩŋfua n maha u yey: «Mboo la u Yãhã Yĩndefua Crise, ke Yãhãngbãŋ Dya?» ");
INSERT INTO xrb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu n u yɛ̃ sya ma yee: «Ãwã ndoo kẽ. Ye ga ba u Nawee Puee yãã, tuu tege nii kai- byɛ yĩŋ na, ke Yãhãngbãŋ kãndigi koho kuɛ ye. Yaa maha ba ra yãã tẽ n pai yãhãsyɔ̃r yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","U Yãhã yũndefa yĩŋfua tuu Yesu kaplãŋ ngĩĩ luhu, u laam n war u n sya u ya nayrɛ tyĩn cɛr, ma pe nawee- pye ma yee: «Le kua, wo sẽ maha laa kɛ waa ye u wĩĩ na ye. ");
INSERT INTO xrb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tuu n gbar Yãhã ne, ye byɛ le luhu. Ah ye lii yãã le na?» Pe byɛ n yee, a tuu yai wãboo ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mpãy n yir, ma nii yɛ̃syɔ̃r tu n woo u na, ma dur ma u yĩmpɛ paha tã, ma nii u gbã kãntakloŋ ne, ma nii u yey: «Yoo u ma gbã, le cã mii ya, -taa wo yar!» Pe n Yesu wãã ke kaha sẽŋfa kẽ, pe n u yigi ma u fey kãntaha ne. ");
INSERT INTO xrb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kai- ngĩĩ pyeyale wo, Pyar pye tãã ye ndyin wo, Yãhã yũndefa yĩŋfua tẽntẽsyale n pa. ");
INSERT INTO xrb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tuu Pyar yãã u nii naa waha, u tẽntẽsyale n u gbihi yãŋ, ma u pye ma yee: «Ma bya pye u Nasarɛtefa Yesu ne.» ");
INSERT INTO xrb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pyar n le kai ma yee: «N cã na? Taa lii pãã, n sẽ le war ma ne ye.» U n yi ma ka kãndi wo kapahayɛ̃ na. Ngupuai n kui. ");
INSERT INTO xrb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","U tẽntẽsyale n u yãã, ma maha yir, ma nii le pãã nawee- ye ke fla na, ma yee: «Poo nen waa kẽ dya nwo ne.» ");
INSERT INTO xrb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pyar n maha le kai. Saa n pye, mpãy pe pye ke fla na pe n maha Pyar pye ma yee: «Le ga waha pye cĩĩnde. Taa n yi Galɛlɛ wo, poo nawee nen waa kẽ ma ne.» ");
INSERT INTO xrb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pyar n -sẽ nii le kai ma yee: «Ndoo sẽ kẽ ye rɛhɛ! Ke ma pye kawar tẽ n fua, Yãhã ke ra pẽn! Ndoo tesẽ ke Yãhã ne, tee dya wii wĩĩ pãã, n sẽ u cã ye.» ");
INSERT INTO xrb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Le yalebya wo, ngupuai waa n kui. Pyar laam n too le kapãn na, Yesu tuu naa lii pãã u ye ma ba yee: «Ngupuai wãkui saa ba tɛhɛ syãŋ wuhu tã wa ye, ma -sẽ ga ba ra wĩĩ kai tɛhɛ tãã, ma yee mboo sẽ ra cã ye.» Pyar n too mii na ma n wũn. ");
INSERT INTO xrb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ke yĩŋsyii sukũhũntãy yĩŋ na, pe Yãhã yũndefa yĩŋfa n pe ya wãã Yesu wĩĩ na, pe wãlɛ ne, pe Yãhã kaiyarfa ne, tesẽ pe kaplãŋ cɛrwai byɛ ne. Loo kur ye, pe n ta pe n Yesu pua, ma ka u ne u fãngafua Pilati fla na. ");
INSERT INTO xrb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilati n u yey: «Mboo la pe Yiifee- Yĩŋfua?» Yesu n u yɛ̃ sya ma yee: «Ma le pãã.» ");
INSERT INTO xrb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pe Yãhã yũndefa yĩŋfa kai- busãã pãã naa n taha Yesu na. ");
INSERT INTO xrb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilati n maha Yesu yey loo na ma yee: «Ma sẽ luhu la kai- ngĩĩ byɛ ne, pe pãã n taha ma na? Ma saa laa wãã sya la pe ye?» ");
INSERT INTO xrb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu sẽ -sẽ maha laa wãã sya ye. Nde n yɛ̃ gbãã Pilati na. ");
INSERT INTO xrb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dyɛ- byɛ, syayaha gbar ma nɔ, u fãngafua ma ne nwompihifua waa yi yaha, wii nawee- pe ne yãŋ yi. ");
INSERT INTO xrb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nwompihifua waa pye, pe naa u yee Barebaa. U pye nwompihi wo u kapeepyewai ne. Pe pye nasyey, ma wãhã cɛr ma sya nawee boo le na. ");
INSERT INTO xrb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nabuar n dugu taha ga Pilati na, ma ga nii u yey dyɛ- byɛ pyer ne, tii u ma ne pye pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilati n pe yɛ̃ sya ma yee: «Ye n yãŋ la, n Yiifee- Yĩŋfua yi yaha ye kẽ?» ");
INSERT INTO xrb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","U ba cã, pe Yãhã yũndefa yĩŋfa ba Yesu yigi ba le soho u koho wo, pe laanyar wĩĩ na. Koo kẽ u n pe yey ke syi. ");
INSERT INTO xrb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pe Yãhã yũndefa yĩŋfa -sẽ mii, pe ba pe nabuar sũũ wa, pe n yee, Pilati tuu Barebaa woo yi yaha. ");
INSERT INTO xrb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilati n maha pe pye ma yee: «Ah wii tee n yee Yiifee- Yĩŋfua, ye -sẽ yee n woo pye mii?» ");
INSERT INTO xrb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pe n tẽ sya ma yee: «U kuey mar boo trã na!» ");
INSERT INTO xrb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati n pe yey: «U -sẽ kapee lii loo pye?» Pe n maha tẽ sya fãnga ne ma yee: «U kuey mar boo trã na!» ");
INSERT INTO xrb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilati tuu ba yee wa woo ga pe nawee- laam yĩn, u n Barebaa yi yaha pe kẽ. U n ta pe seraasyi n Yesu gbã sãngblã ne, u n maha yee pe ga u kuey mar yaha trã na. ");
INSERT INTO xrb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pe seraasyi mpãy n Yesu yigi ga u fãngafua tẽntẽsaha kangbãŋ ndyin wo, ma dur ma ke seraasyi ndreŋ byɛ yee ba. ");
INSERT INTO xrb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pe n yĩŋfua nayreyãhã le u kẽ, ma ngur maha ta u yĩŋ na yĩŋfua nkifai dyaŋ, ");
INSERT INTO xrb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ma nii u lɛr syaha ne ma yee: «Wo ma syar Yiifee- Yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pe n nii gbã n le u kẽ yĩŋ wo, kipua kãi ne, ma yɛ̃syɔ̃r tu n woo u na, ma kãnklũy gbãã u tãy nangbãŋ wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pe ba u lɛr wa, pe n yir ma ke yĩŋfua nayreyãhã yi kãã u na, ma u faale nayrɛ le u na. Pe n yi ga u ne nkur ye, pe n gaha u kuey mar yaha trã na. ");
INSERT INTO xrb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pe seraasyi n ga Syirɛ̃fa naa waa wãã sya, tuu naa n gaha le klo laam wo. Pe n u ta u n Yesu kueymartrã tẽŋ fãnga na. U myaha ba kẽ Syimu, Lesyããnder ye tuhufua ba kẽ u ne Wurfuu ne. ");
INSERT INTO xrb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pe n ka Yesu ne teelaa wo pe n yee Gblegbeta; le yĩntaha kẽ, yĩnkluhu fla. ");
INSERT INTO xrb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pe n defĩĩ gbe, ma myer le u wo, ma wãã Yesu kẽ tuu sya wɔ. Yesu n pe sye. ");
INSERT INTO xrb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pe seraasyi n u kuey mar yir yaha le trã na, ma pyer raa pye pe waha cã, yoo ga Yesu nayrɛ wãn fai lii yãã. ");
INSERT INTO xrb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","U kueymaryale pye ntãŋ gbãyale syi. ");
INSERT INTO xrb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tuu kai lii pye pe n u kuey mar, pe ba le kai yrũhũ gbãã yaha le trã ncaha kuɛ ye ma yee: «yiifee- yĩŋfua kẽ.» ");
INSERT INTO xrb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pe n maha kapeepyefa syãm mpãy kuey mar yir yaha trãŋ na pe ya wuhu na, nen nwo Yesu kãndigi kuɛ ye, nen nwo u kãmaŋ kuɛ ye.  ");
INSERT INTO xrb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ke syi ne, kapãn lii le bii cãã yrũhũ yaha Yãhã sabangbãŋ wo ma yee: «Pe u tɔ̃r kapeepyefa ne wãcɛŋ,» loo ne le nii n pye loo yale wo. ");
INSERT INTO xrb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kãntɛrfa naa u tyɛhɛ, ma naa yĩŋ figi u na, ma naa n yee: «Ah mboo wii taa naa n yee, a ma ga waha ke Yãhã kangbãŋ cããr, taa dur ma ke fãã plii tãã nsoho wo, ");
INSERT INTO xrb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ma saa mii sya yaha la yagaa? Tege kãã le trã na kɛ!» ");
INSERT INTO xrb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pe Yãhã yũndefa yĩŋfa bya, tesẽ pe Yãhã kaiyarfa ne, pe n nii Yesu lɛr ke syi, ma nii pe ya pye ma yee: «U nawee- mpãy sya yaha, u sẽ -sẽ ga waha u yĩŋ yi yaha ye. ");
INSERT INTO xrb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","U Yãhã Yĩndefua Crise, wii u ma Yiisrɛfa Yĩŋfua, u tege kãã yagaa le trã na kɛ! Wo yĩnde ma loo yãã, waa cã u wĩĩ sya cĩĩnde.» Kapeepyefa syãm mpãy pe ba kuey mar yir yaha trãŋ na pe ya wuhu na, pe naa u tyɛhɛ pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yaiwlaŋ ba kẽ, wam mpãy syi n paha tã le klo kur byɛ na, ma sya ba yai yĩn. ");
INSERT INTO xrb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yaiyĩn yale le ba nɔ Yesu n tẽ sya fãnga ne ma yee: «Yelɔyi, Yelɔyi, lema sabaketani.» Koo yĩntaha kẽ: «Yãhã, Yãhã, nwa ma n ta miy yaha?» ");
INSERT INTO xrb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nawee- mpãy pe pye ke fla na, pe n le luhu ma le pãã, a u ma u faale Yãhã kaplãŋ tɔ̃rfua Yeli yee. ");
INSERT INTO xrb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Poo nen waa n fã ga flũhũflũhũ wãŋ gaa kã le defĩĩtãhãpihi gaa wo, ma ke yi ba kã gbãã kipua kãi na, ma ke wãŋ kuã yir wãã Yesu kẽ tuu ke defĩĩtãhãpihi wãr naa n wɔ. U n dur ma nawee- pye ma yee: «Ye tyii wo n yãŋ, ncã Yeli ga ba u tege le trã na, laa?» ");
INSERT INTO xrb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu n tẽ sya fãnga ne, ma ku. ");
INSERT INTO xrb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Loo yalebya wo, Yãhã kangbãŋ nwonuŋ nwonyɛ̃ faasrɛŋ gii ke ba pua tã menmen ke nwonyɛ̃ na, ke n fe jũũ flɛ sĩĩ, ma gbe ncaha ye ma tege tãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Seraasyi yĩŋfua wii u pye Yesu yaha ye, tuu u wãku yãã, u n yee: «Dya nwo pye Yãhã Dya cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ca mpãy pye pe ya ndoŋ, pe ba dey yɛr ma naa n yãŋ. Pe laam wo, Madalafa Maari pye, Salme ne, tesẽ Maari waa ne wii tuu pye Syakesyĩnde ye nahafua tesẽ Syose ne. ");
INSERT INTO xrb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cãã gii cãã na Yesu naa n tay Galɛlɛ kãntraha wo, pe ca mii naa n taha u na, ma naa tẽŋ nkãy tẽ u kẽ, tesẽ u kãnyãrwai ne. Ca mpãy maha pye ke fla na, pe ba dugu ba Yesu ne Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Koo per -sẽ pye, kanii per ga dye koo yainkɔŋ wo. Nawee- yai pe cãã kanii kai- gbihi, yai n cã kua. ");
INSERT INTO xrb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Koo yainkɔŋ wo, Yosɛfe wii tuu n yi Yarimate wo, u n pa Pilati fla na, ma ba sɛr Yesu nakugu nar u ye. U Yosɛfe pye Yiifee- yahaseefua waa; pe naa u yãŋ. U laam wo, u bya naa Yãhã Yai wãpaŋ yɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilati tuu le luhu Yesu ku wa, le n u fe gbe. U n u seraasyi yĩŋfua yee ba, ma u yey ke ma pye Yesu wãku yale dey. ");
INSERT INTO xrb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tuu u seraasyi yĩŋfua nwo yɛ̃ kapãn luhu wa, u n Yosɛfe pye ma yee u ga waha Yesu nakugu gbe. ");
INSERT INTO xrb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosɛfe n ga faafĩĩ laa par, ma ba ta pe n Yesu nakugu tege le trã na, ma le fai maha tã ke na, ma ga ke le gbĩĩ laam wo, ma ntẽmbangbãŋ gaa kloŋ ba paha tã le gbĩĩ yɛ̃ na. Le gbĩĩ ba gbã fer ntẽmblaha wo. ");
INSERT INTO xrb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Madalafa Maari, tesẽ Syose nahafua Maari ne, pe pye pe ba naa Yesu nakugu yãŋ lesaha wo. ");
INSERT INTO xrb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ke kanii per yai ba kua wa, Madalafa Maari, Salme ne, ma suhu Syake ye nahafua Maari ne, pe n yi ma ga lasekole par. Pe ba yee pe n gaha u woo Yesu nakugu na. ");
INSERT INTO xrb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ke kanii per yĩŋsyii wo, cãwãã per cir kẽ, koo sukũhũntãy na yĩnwɔŋ wo, pe n yir ga le gbĩĩ fla na. ");
INSERT INTO xrb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pe naa pe ya yey: «Yoo n gaha ke ntẽmbangbãŋ kloŋ kãã wo kẽ le gbĩĩ yɛ̃ na?» ");
INSERT INTO xrb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pe ga nɔ ke fla na, pe n yee poo ga yãŋ, ma yãã ke ntẽmbangbãŋ ba kloŋ kãã wa le gbĩĩ yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pe n dye le gbĩĩ laam wo, ma naanfuɛ̃ waa yãã. U ba tege nii kãndigi kuɛ ye, nayrengbãŋ ne wãfigi tuu le, yãhãyĩŋ tẽnlɛhɛ ba kẽ. Pe n fya. ");
INSERT INTO xrb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","U n pe pye ma yee: «Ye ma syi ye fya ye! Nasarɛtefa Yesu wii pe kuey mar boo trã na, woo tee n kɛ. Yãhã u yir gbã wo, u n dur ba yrãŋ na gbaafa ye, u wee nwo ye. -Ye yãŋ, pe ba u sãy ta teelii wo, ke fla nge! ");
INSERT INTO xrb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","-Ye ka yagaa, yaa le pãã Pyar ye, tesẽ pe kãnyãrwai mii bya ye, ye yee Yesu ga cãã tɛr pe yaha Galɛlɛ kãntraha wo. Koo fla kẽ pe n gaha u yãã, mii tuu ba pe yar wa mii.» ");
INSERT INTO xrb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pe n yi le gbĩĩ wo, ma fã tɛr. Pe ba fya ma sya ba naa n sege. Pe sẽ n ga laa pãã waa gɛ ye ye, pe tee ba fya tɛr.  ");
INSERT INTO xrb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ke kanii per yĩŋsyii wo, Yesu n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. U n cãã ga u ya yar Madalafa Maari na, tuu ba sãndãpee kuasĩĩ kar tege kãã wii yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","U Maari n ka, ma ga le pãã Yesu kãnyãrwai ye. Pe laam ba wlãhã, pe n ba naa n wũn. ");
INSERT INTO xrb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pe kãnyãrwai pe le luhu u cɔɔ yɛ̃ na, tuu yee Yesu yir gbã wo, woo n u yãã yĩnde ne, pe sẽ le sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Loo kur ye, Yesu n maha u ya yar kaa syi ter kãnyãrwai syãm mpãy na. Pe kãnyãrwai pye kãnde wo, ma naa n gaha wlaha wo. ");
INSERT INTO xrb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe n dur ba, maa le pãã pe nampyeŋ- ye. Pe n maha yee cĩĩnde sẽ ne ye. ");
INSERT INTO xrb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pe kãnyãrwai sẽnsye nen pye pe naa n di, Yesu n cã ba u ya yar pe na loo na. Mpãy pe ba cãã u yãã gbaa na, ma ba naa le pãã pe ye, pe naa n yee cĩĩnde sẽ ne ye; Yesu n loo kuãn pe ye ma yee pe laam waha tɛr, pe sẽ u kaplãŋ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Loo na, Yesu n ba pe pye ma yee: «-Ye ka driyɛ̃ kur byɛ wo, ye ga naa le Yãhã Yai kapãyĩĩ tɔ̃r nawee- ter byɛ ye! ");
INSERT INTO xrb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wii ma le kapãyĩĩ wĩĩ sya cĩĩnde, pe n ba u tãã yi loho wo, woofua ga sya yaha. Wii ma -sẽ yee u sẽ le sya cĩĩnde ye, woofua saa wãsyayaha yãã ye. ");
INSERT INTO xrb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mpãy pe ga ba le sya cĩĩnde, pe ga ba naa laanwɔ wũhũ nkãy pye, koo kẽ ngĩĩ: Pe ga ba sãndãpee kar tege naa n kãã nawee- yĩŋ na; pe ga ba naa yor raa ter pãã. ");
INSERT INTO xrb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pe ma sya nwɔr wãã sya gbe yigi koho wo ke syi, pe ma maha sya naboo tyin wãã sya wɔ, ngaa saa pe pye ye. Pe ga ba naa kluɛ taha yanfa na, pe n naa n jaa.» ");
INSERT INTO xrb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","U Yĩŋfua Yesu tuu loo pãã wa pe kãnyãrwai ye, Yãhã fãnga n ta u n kuã yir tɛr fãã yãhãyĩŋ na, ma ga tege nii Yãhã kãndigi koho kuɛ ye kai- byɛ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pe kãnyãrwai n tɛr teebɛhɛ byɛ wo, ma ga nii le kapãyĩĩ tɔ̃r nawee- ye. U Yĩŋfua Yesu pye pe kur ye, pe n waha laanwɔ wũhũ pye naa n taha pe kaplãŋ na.");
INSERT INTO xrb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tohofile, waa u wãdyaha ne. Kai- nkãy ke pye wo nsoho wo Yesu cãã na, nawee- mpãy ke wãyrũhũyaha fe gbe. ");
INSERT INTO xrb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mpãy ter ke kai- fegbesaha yãã yĩnde ne, ma ke yar wo na. Poofa n nii le Yãhã kapãyĩĩ pããfa. ");
INSERT INTO xrb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wãdyaha Tohofile, ta bya tẽ ke kai- luhu, n ke gbe ke ya wuhu na, ma ke yey fũũ, ma ke tɛrsaha cã. Koo kẽ ta n yee n ga ke yrũhũ yaha, ma gbe ke fegbecãã na, ma ga waa ke kuasaha na. ");
INSERT INTO xrb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","N ke yrũhũ ma kẽ, ma waha cã kai- nkãy nawee- ma yar Yesu wĩĩ na, cĩĩnde wũhũ kẽ ke ne. ");
INSERT INTO xrb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cãã gii cãã na Yɛrɔte tuu pye Yudɛ kui yahaseefua, Yãhã yũndefua waa pye pe naa n yee Dyakaridya. Pe Yãhã yũndefa laam wo, mpãy pye pe naa n yee Dabyafa. U Dyakaridya pye poo waa. Pe naa u Dyakaridya cɔɔ yee Lisabɛte. U Dyakaridya tesẽ u Lisabɛte ne, pe pye u faale Yãhã yũndefua Yarɔ̃ nwoŋ pii. ");
INSERT INTO xrb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dyakaridya tesẽ Lisabɛte ne, pe syãm byɛ ba sroŋ Yãhã yĩnde na, ma naa n yãr Yãhã kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lisabɛte -sẽ pye cayroŋ. Nanlɛr n sya ba nɔ pe na, pe sẽ kicar nen waa gɛ yãã see ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Per gaa, Dabyafa tẽn tẽ lay ba maha nɔ ke Yãhã kangbãŋ laam wo. Dyakaridya n yãŋ yi loo tẽn na. Loo ne u Dyakaridya pye ke Yãhã kangbãŋ laam wo, ma naa wusuna le naa laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","U wusuna leyale wo naa wo, nabuar pye nkur ye, pe yɛr naa Yãhã nar. ");
INSERT INTO xrb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Loo nde pyeyale wo, Yĩŋfua Yãhã yãhãyĩŋ tẽnlɛhɛ waa n fe gbe yi u Dyakaridya na ke Yãhã kangbãŋ laam wo, ke wusuna suhusaha fla kãndigi koho kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dyakaridya n u yãã, ma nii n sege fyar koho wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","U yãhãyĩŋ tẽnlɛhɛ n u pye ma yee: «Dyakaridya, maʼa n fya ye, taa naa Yãhã nar lii ne, ke le sya ma ye. Ma cɔɔ ga lai gbe, u naa kicar waa see, ma u myaha taha Nsãn. ");
INSERT INTO xrb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U wãsee wĩĩ ga ba ma laam sroŋ flege ma kẽ. Nabuar ga ba naa nuhu di loo na. ");
INSERT INTO xrb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","U ga ba nii naweengbãŋ Yĩŋfua Yãhã ye. U saa ba naa defĩĩ wɔ, tesẽ sẽm mpãy syi ne pe nawee yigi ye. U wãyitãŋ u nahafua laha wo, Yãhã Yrã Fãnga ga ba dye u wo, ke u laam yĩĩ. ");
INSERT INTO xrb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U ga ba ta Yiisrɛfa busãã n dur naa n yãr Yĩŋfua Yãhã kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yãhã ga ba ta u n Yãhã kai- cã, tuu maha fãnga yãã mii faale Yãhã kaplãŋ tɔ̃rfua Yeli wãŋ syi dyaŋ. Loo ga ba ta u n tuhufa wãã le pe kicar ne, tuu kapeepyefa ta pe n koho klaha, pe naa pe troho tãhã naweeyɔ̃m yor wo. U ga ba nawee- gbihi ta Yĩŋfua Yãhã kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dyakaridya n u yãhãyĩŋ tẽnlɛhɛ pye ma yee: «Lii raa tɔ̃r nde, n waha le syi sya la n yee cĩĩnde? Ndoo ta cɔɔ ne, wo sẽ lɛ tɛr la syihi wãsee na?» ");
INSERT INTO xrb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","U yãhãyĩŋ tẽnlɛhɛ n u yɛ̃ wãã sya ma yee: «Ndoo kẽ Gaburɛle, n ma Yãhã tãy ma ke laam wũhũ pye. Koo ke ra lɛhɛ wãã ma ye, n ba le kapãyĩĩ nde tɔ̃r ma ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kaplãŋ nkãy tẽ pãã ma ye, le kai pyeyale ma ba nɔ, le ga pye. Taa sẽ -sẽ ra kaplãŋ sya cĩĩnde ye, maa nii bebe ma yɛ̃ ga mar ma ye, ma saa waha naa n pãã ye. Kai- ngĩĩ ga ba pye, ma yɛ̃ n cã kuã, ma n waha dur naa n pãã.» ");
INSERT INTO xrb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Loo yale wo, te nabuar rii te pye nkur ye, te naa Dyakaridya sẽŋ. U tee ba ma kuee tɛr ke Yãhã kangbãŋ laam wo, le n pe laam wɔ. ");
INSERT INTO xrb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","U n ba yi, u sẽ waha pãã pe nabuar ne ye, pe n cã ma yee u ba ngaa yãã wãytãã wo ke Yãhã kangbãŋ laam wo. U ba naa kluɛ ya yãhã kaplãŋ draha wo, u yɛ̃ ba mar. ");
INSERT INTO xrb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dyakaridya kai- wãpyeŋ lay n ba kua ke Yãhã kangbãŋ wo, u n dur ga u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Loo kur ye, u Dyakaridya cɔɔ Lisabɛte n ba lai gbe, ma naa n kuee kaha ya laam wo yrey bua, u sẽ naa n yi ye. U laam wo, u naa le ga ma naa n yee: ");
INSERT INTO xrb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«-Ye naa Yãhã yãŋ ke nde pye ra kẽ. Ke sroŋ yɛr yagaa ra fyar wãgbekãã wĩĩ na ra na, ta n ga waha yĩŋ kuã yir naa nawee- yãŋ. Pe saa naa ra yãŋ cayroŋ nantãŋ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lisabɛte lai yrey kuay wuhu, Yãhã n ke yãhãyĩŋ tẽnlɛhɛ Gaburɛle nɔ wãã Galɛlɛ kãntraha klo nde laam wo pe n yee Nasarɛte. ");
INSERT INTO xrb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U n ka capua waa fla na pe naa n yee Maari. U sẽ -sẽ ba naa cã wa ye. Pe ba yɛr u wãwãã wĩĩ na cɔɔ, naa waa kẽ pe naa n yee Yosɛfe. U Yosɛfe faale wãdyaha bii kẽ Dawide ne, wii tuu bii pye Yiisrɛfa yĩŋfua faale wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","U yãhãyĩŋ tẽnlɛhɛ n dye ga u Maari fla na, maa u pye ma yee: «N ma syar Maari, mboo wii, ma yãŋ yi. Yĩŋfua Yãhã ma ma ne.» ");
INSERT INTO xrb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maari tuu kaplãŋ ngĩĩ luhu, tuu ga lii pye u sẽ le cã ye. U n nii le ga u laam wo ma yee: «Syaha nge yĩŋ kẽ lii ne?» ");
INSERT INTO xrb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Loo na, u yãhãyĩŋ tẽnlɛhɛ n u pye ma yee: «Maari, maʼa n fya ye. Yãhã ke laantãr yar ma na. ");
INSERT INTO xrb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Maa ba lai gbe, ma naa kicar waa see, ma ba u myaha taha Yesu. ");
INSERT INTO xrb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U myaha ga ba gboho, pe ga ba naa u yee ke Yãhãngbãŋ Dya. Yãhã ga ba u faale wãdyaha Dawide yĩnfar wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U ga ba nii Yiisrɛ kur Yĩŋfua. Too yĩnfar nde saa ba sya kãã yãã u koho wo ye, u n kuee yai tãŋ Yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maari n u yãhãyĩŋ tẽnlɛhɛ pye ma yee: «Eh, n ga pye mii n waha lai gbe, tẽ sẽ -sẽ naa cã wa ye?» ");
INSERT INTO xrb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","U yãhãyĩŋ tẽnlɛhɛ n u pye ma yee: «Yãhã Yrã Fãnga ga ba tege ma na, Yãhãngbãŋ Fãnga ga ba paha tã ma na mii yĩm wãŋ syi dyaŋ. Koo syi kẽ, kicaryɔ̃ wii u n pai see, pe ga ba naa u yee Yãhã Dya. ");
INSERT INTO xrb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma nwoŋfua Lisabɛte, u wãlɛ naa byɛ ne, u ma lai ne, u ga ba naa kicar see. Pe sẽ ba naa n yee la, a u ma cayroŋ? Yagaa u ma yrey kuay lai ne. ");
INSERT INTO xrb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cã, laa sẽ Yãhã yia ye.» ");
INSERT INTO xrb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Loo na, Maari n yee: «N nwo, n ma Yãhã koho wo. Taa le tɔ̃r mii, le -sẽ pye koo syi.» Loo kur ye, u yãhãyĩŋ tẽnlɛhɛ Gaburɛle n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Too plii na, Maari n yir ma Yudɛ yãy klo laa kãnde sya, ma tɛr farfar Lisabɛte fla na. Loo klo nde wo, Lisabɛte ye pye ke fla na u puai Dyakaridya ne. ");
INSERT INTO xrb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maari n ga dye pe kaha wo, ma Lisabɛte syar. ");
INSERT INTO xrb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Yaliile Lisabɛte tuu u syaha yĩmbui luhu, kicar wii tuu pye u laha wo u n u ya yɛhɛ. Yãhã Yrã Fãnga n dye u Lisabɛte wo, ma u laam yĩĩ. ");
INSERT INTO xrb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","U n tẽ sya ma yee: «Maari, Yãhã kaa taha ma na, ma tɛr ca byɛ yaha. Ke maha kaa taha u kicar na, wii raa n pai see. ");
INSERT INTO xrb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nawee la ta syi ne, ta Yĩŋfua nahafua n sya yir ba ra fla na? ");
INSERT INTO xrb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma sẽ yãã, yaliile tẽ ma syaha luhu, nuhu n u kicar yigi, u n sya u ya yɛhɛ ta laha wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ma wĩĩ yɔ̃, mboo wii taa Yĩŋfua Yãhã kaplãŋ sya cĩĩnde, kaplãŋ nkãy ke ba tɔ̃r ma ye.» ");
INSERT INTO xrb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maari n too Yãhã wãsey na ma yee: «N Yĩŋfua Yãhã sey, ");
INSERT INTO xrb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","n nuhu di, Yãhã ma ra Syayahafua. ");
INSERT INTO xrb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ke fãy sya, ma kuɛ tege ma ra syi yãŋ, ndoo wii tẽ ma ke koho wo. Yagaa, ta myaha ga ba dye kuee yai tãŋ kãntrahafa byɛ yɛ̃ wo, pe n naa le pãã pe yee: Cɔɔ nwo wĩĩ fĩhĩ yɔ̃ cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ye sẽ yãã, Yãhã kayũhũ pye ra kẽ, nkãy ke gbaha. Ke miingbãŋ kai- laha. ");
INSERT INTO xrb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mpãy byɛ pe n luhu ke ye, ke ke laantãr yar pe na yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ke kãnkai- sroŋ pye ke ya koho fãnga kãmay na. Ke fyar ta yataŋfa na. ");
INSERT INTO xrb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ke nangbãm ta pe n kuã too, ma naflam ta pe n kuã yir. ");
INSERT INTO xrb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ke fããfa ta klafa, pe n yãã ma sya ta tɛr pe wãdiŋ yaha. Ke walefa dur wãã kãnwai ne. ");
INSERT INTO xrb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yãhã ke laantãr yar wo faale wãlɛ na. Ke dye Yiisrɛfa kuɛ ye, Yiisrɛfa mpãy pe pye ke koho wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ke bii yɛ̃ tɛr Brama ye tesẽ u kur ne, ma yee ke ga naa ke laantãr yar pe na yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Loo kur ye, Maari n kuee yrey tãã syi Lisabɛte fla na, ma cã ba dur tɛr u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lisabɛte seeper n ba nɔ, u n naa ricar see. ");
INSERT INTO xrb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Loo kafuɛ̃ n yi, u kasohowai n le luhu tesẽ u kahafa ne. Pe n nii nuhu di, ma nii n yee Yãhã ke laantãr yar Lisabɛte na. ");
INSERT INTO xrb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Plii kuatãã wuhu, nawee- n pe ya wãã ba u kicar kũũsaha wo. Pe n yee poo ga u tuhufua Dyakaridya myaha gbe pe taha u na. ");
INSERT INTO xrb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","U kicar nahafua n pe pye ma yee: «Aye, ye tyii u myaha n nii Nsãn.» ");
INSERT INTO xrb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pe n u pye ma yee, a u nwoŋfua waa myaha sẽ pye yãã Nsãn ye, a poo saa waha koo myaha nge gbe pe taha u kicar na ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","U kicar tuhufua tuu sẽ -sẽ waha naa n pãã ye, pe n kluɛ yãhã wãã u ye, a ter myaha gii yai ke taha u kicar na. ");
INSERT INTO xrb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dyakaridya n kluɛ yãhã wãã pe ye, pe n kla wãã u kẽ, u n yrũhũ ke na ma yee: «Nsãn ke ma u kicar myaha.» Le n pe byɛ fe gbe. ");
INSERT INTO xrb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Loo yalebya wo, Dyakaridya yɛ̃ n kuã, u n too Yãhã wãsey na ma sya nii yĩmbui yir. ");
INSERT INTO xrb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Loo nde le pye ke syi, pe klofa byɛ n fya, le kapãn n cããŋ yi Yudɛ yãy teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Le n nii, wii ma le luhu, u ga naa laam ga u yee, a kicar nwo ma ba lɛ, u ga ba nii nwasyipyefua? Yãhã yĩnde -sẽ pye u kicar na yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yãhã Yrã Fãnga n dye u kicar tuhufua Dyakaridya laam wo, ma u yĩĩ. Kai- nkãy ke n pai pye, u n too ke na ma nii ke yar n yaha ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Wo Yĩŋfua wii u ma Yiisrɛfa Yãhã, ke myaha yai ke gboho nawee- byɛ yɛ̃ wo. Ke wo kuɛ yãŋ, ma wo sya yaha. ");
INSERT INTO xrb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ke u Syayahafua yĩŋ yi wo faale yĩŋfua Dawide nwoŋ wo, ma fãnga wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yĩŋfua Yãhã bii ke kaplãŋ tɔ̃rfayɔ̃m ta pe n bii loo nde cãã yar yaha faale wo ma yee, ");
INSERT INTO xrb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yãhã ga ba dye wo kuɛ ye. Ke u Syayahafua nɔ wãã wo ye, u n wo sya yaha wo napĩĩ- koho wo, tesẽ mpãy ne wo wĩĩ fũhũ pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ke bii wo wãlɛ pye ma yee, koo ga ba ke laantãr yar pe na, koo saa faha yãã ke naambiyãr na ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ke sẽ bii yɛ̃ tɛr la wo faale wãdyaha Brama ye koo syi? ");
INSERT INTO xrb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ke ga ba wo sya yaha wo napĩĩ- fãnga koho wo, wo n waha naa ke laam wũhũ pye, ntãncɛr saa pye nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Loo na, wo ga nii Yãhã nawee-, wo ga maha naa n sroŋ ke yaha ye yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta dya, mboo na, pe ga ba naa ma yee Yãhãngbãŋ kaplãŋ tɔ̃rfua. Maa ba cãã yi Yĩŋfua yahasee ye, ma u kãnde gbihi yaha u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Taa u nawee- yar, u n pai pe sya yaha, u pe kapee- laha kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ye sẽ yãã, Yãhã n traha ke ke laantãr yar wo na, koo syi kẽ ke ga ba ta ke cãã- n pa wo ye, mii yainsatãhã wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Loo na, mpãy pe nii wam wo Yãhã kuɛ ye, tesẽ mpãy ne pe gbã fya, poo cãã- ga pa pe ye. Ke syi, wo byɛ n waha naa n yãr Yãhã yrĩŋ kãnde wo.» ");
INSERT INTO xrb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","U kicar nii n lɛ, u yĩntaha nii n too. Tuu ba nii naanfuɛ̃, u n ga kuee dragba gaa laam wo yatata. Per gaa, u n cã ba u ya yi Yiisrɛ kur n u yãã. ");
INSERT INTO xrb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Koo kai- wãpyeŋ cãã na, Woguse tuu pye kãntrɛ fãngafa byɛ yĩŋfua. U bii yir ma yee, a pe kãntrɛ nawee- ter byɛ myar yrũhũ. ");
INSERT INTO xrb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Too nayrũhũ nde ne te pye nayrũhũ cir. Koo cãã na, Cirimusu tuu pye Syire kui fãngafua. ");
INSERT INTO xrb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nawee- byɛ naa n gaha, maa naa pe myar yrũhũ pe wãlɛ klɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","U Yosɛfe -sẽ pye klo lii wo pe n yee Nasarɛte, Galɛlɛ kãntraha na. Tuu -sẽ pye faale yĩŋfua Dawide kur waa, u n yir le klo wo, ma ka Betelɛmu wo Yudɛ kãntraha laam wo. U nwoŋ wãdyaha Dawide kusey ba kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","U n ka, woo tesẽ Maari ne wii tuu ga nii u cɔɔ, pe n ga yrũhũ. Maari pye lai ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pe pye ke Betelɛmu laam wo, Maari seeper n ba nɔ. ");
INSERT INTO xrb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","U n ke syihi cir nge see, naa ricar. U n u kicar maha tã kompua fai ne, ma u sãy ta mbaa didi kataŋ wo. Draha sẽ ba yãã pe ye nampay syãsaha fla wo ye. Pe n gblihi laa, ma ga dye nii yraha sãysaha fla wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Le klo kãnkãy na mbanaha mpãy pye, pe naa n kuee nyɛ̃ wo yĩmper wo ma naa pe mbaa sẽŋ. ");
INSERT INTO xrb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yãhãyĩŋ tẽnlɛhɛ waa n fe gbe yi pe na, Yãhã nayɔ̃r cãã- n yɛhɛ pe telai wo. Pe n fya nii. ");
INSERT INTO xrb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","U yãhãyĩŋ tẽnlɛhɛ n pe pye ma yee: «Ye ma n fya ye, kapãyĩĩ laa ne tẽ ga tɔ̃r ye ye, lii le ga ba nuhungbãn yigi ye kãntraha nawee- byɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yĩmper nge laam wo, ye wãdyaha Dawide klo nde laam wo, ye Syayahafua ma tuu see, Syayahafua wii u ma u Yãhã Yĩndefua. ");
INSERT INTO xrb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ta n ye yar laa ne, lii le ga ta ye n waha ga u yãŋ cã: Ye ma ga pẽyãhã gii yãã pe maha tã kompua fai ne, ma ke sãy ta mbaa didi kataŋ wo, yaa cã koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Loo yalebya wo, yãhãyĩŋ tẽnlɛhɛ mpãy n maha fe gbe yi pe na, ma ba yɛr u yãhãyĩŋ tẽnlɛhɛ nen nwo tãy, ma nii Yãhã sey ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Miingbãŋ, Yãhã wãŋ kẽ ke ne yãhãyĩŋ na. Ke ke yrĩŋ wãã kãntrahafa kẽ, poo mpãy wĩĩ le n tãy ke ye.» ");
INSERT INTO xrb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pe yãhãyĩŋ tẽnlɛhɛ pe dur tɛr yãhãyĩŋ na, pe mbanaha n pe ya pye ma yee: «Ye tyii wo n yir ga ke Betelɛmu laam wo; Yãhã ke wo yar lii ne, wo ga le yãã wo yĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pe loo pãã wa, pe n yir farfar, maa dye ma Maari yãã Yosɛfe ne, tesẽ le pẽyãle ne pe kompua fai maha tã le na, ma le sãy le yaha mbaa didi kataŋ wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pe le pẽyãle yãã pe yĩnde ne, pe n too ke kai- na ma nii n tɔ̃r, kai- nkãy u yãhãyĩŋ tẽnlɛhɛ ba yar pe na le pẽyãle wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nawee- mpãy pe naa ke luhu, ke n pe laam wɔ. ");
INSERT INTO xrb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maari n -sẽ ke byɛ le yaha u ya laam wo, ma nii ke wũũ u ya ya. ");
INSERT INTO xrb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pe mbanaha pe ba le pẽyãle yãã wa, pe n dur ma pe nakoho kãnde sya. U yãhãyĩŋ tẽnlɛhɛ tuu ba ke kai- tɔ̃r pe ye mii, pe n ga ke yãã koo syi. Pe n nii Yãhã miingbãŋ gboho ke kai- wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","U kicar wãsee plii kuatãã wuhu na, pe n u kũũ, ma u myaha taha Yesu. Koo myaha kẽ u yãhãyĩŋ tẽnlɛhɛ u ba yar yaha, u nahafua n cã u lai gbe. ");
INSERT INTO xrb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Per gii Maari wãsee wor yai te yee kãã, mii le yar mii kãnde lii wo Yãhã bii le le soho Musa koho wo faale wo, Yosɛfe tesẽ Maari ne, pe n u kicar gbe ba Yurusalɛm kungbãy wo, ma ga u yar Yãhã na ke kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee: «Naa kicar wii ma cãã see u nahafua na, woo ter ga nii Yĩŋfua Yãhã wũũ.» ");
INSERT INTO xrb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Diŋ gii u faale wãdyaha Musa bii yar yaha Yãhã kãnde wo, Yosɛfe ye n ke yi. Koo diŋ nge n yi kate syãm mpãy ter ne, laa na nasar katepir syãm. ");
INSERT INTO xrb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Le Yurusalɛm klo wo, naa waa pye pe naa n yee Syimu. U ba sroŋ, ma naa Yãhã kãnde yãr. U naa u Syayahafua wãpaŋ yɛhɛ, Syayahafua wii ruu n pai Yiisrɛfa yi kãã pe fɛn wo. Yãhã Yrã Fãnga pye u ne, ");
INSERT INTO xrb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ba u yar ma yee u saa ku mii u sẽ u Syayahafua yãã ye, u Crise wii u ma Yãhã Yĩndefua. ");
INSERT INTO xrb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Per gii Yesu seefa pe ba u gbe ga, pe n gaha u yar Yãhã na mii Yãhã kãnde le yar mii, Yãhã Yrã Fãnga n Syimu gbe ga Yãhã kangbãŋ wo, pe fla na. ");
INSERT INTO xrb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Syimu n u kicar gbe yigi kluɛ wo, ma syaha wãã Yãhã kẽ ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Yĩŋfua Yãhã, taa yɛ̃ tɛr ra ye lii ne, le nii cĩĩnde. Yagaa, maa waha tyii ra na ra n ku laanyĩn ne, ndoo wii tẽ ma ma koho wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ma nwo, taa ra ta ra n u Syayahafua yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","U Syayahafua wii taa gbihi, u n ga tɛr kãntrahafa byɛ yahasee ye, pe wãsyayaha yĩmbui ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Syayahafua nwo sẽ na tuu ga ba ta, kãntrahafa byɛ n ma cã, u maha ta, Yiisrɛfa myaha n gboho, Yiisrɛfa mpãy pe ma ma koho wo?» ");
INSERT INTO xrb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Syimu tuu naa kai- nkãy pãã Yesu wĩĩ na, koo ngĩĩ n Yesu tuhufua laam wɔ tesẽ u nahafua ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Syimu n Yãhã nar pe kẽ, ke kaa taha pe na. Loo kur ye, u n Yesu nahafua Maari pye ma yee: «Yãhã kẽ ke kicar nwo yãŋ yi, u ba ta, nabuar mpãy n too Yiisrɛ kãntraha na, nabuar mpãy n kuã yir. U ga ba Yãhã wũhũ pye naa n yar nawee- na. Pe nawee- -sẽ ga ba u sye. ");
INSERT INTO xrb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","U ga ba ta, nabuar laam wũhũ nkãy pe ga yigi, ke n yi yaha gbaa na. Ma -sẽ yee mboo na cɔɔ, kayaan ga ba too ma na, le n naa ma yaa mii sãn dyaŋ pe ma waa.» ");
INSERT INTO xrb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Cɔɔ waa pye Yãhã kaplãŋ tɔ̃rfua, pe naa n yee Ana. U pye Yasɛr nwoŋfua, Fayer pueesya ba kẽ u ne. U ba sroŋ lɛ, u ba dyɛ- gbeeresyar yãã wĩhĩ resyar ne. U cabir laam wo, u ba puai yãã, pe n dyɛ- kuasĩĩ pye pe ya ne, u puai n ku u yaha. U n kuee calangusya u kuãŋ ne. U sẽ naa n cɛr Yãhã kangbãŋ na ye, ma naa tẽn tẽ Yãhã kẽ ke yai ke yĩmper. Kaa na u ga yai plaŋ, ngaa saa le yɛ̃ wo ye, u naa Yãhã nar. ");
INSERT INTO xrb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yaliile Syimu tuu ba naa koo kaplãŋ ngĩĩ pãã Yesu wĩĩ na, Ana n ba dye Yesu seefa fla na, ma naa Yãhã sey. Loo kur ye, u n nii u kicar wĩĩ pãã nawee- mpãy ye pe naa Yurusalɛm wãsyayaha wĩĩ kɛ. ");
INSERT INTO xrb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu seefa pe ba Yãhã kai- byɛ pye kua wa, pe n dur tɛr Yesu ne Galɛlɛ kãntraha klo laa wo pe n yee Nasarɛte. Pe niisaha ba kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","U kicar nii n lɛ, u yĩntaha nii n too. Wãlɛ kacãn pye u ye, u wĩĩ naa n tãy Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dyɛ- byɛ Yesu seefa naa n gaha Yurusalɛm wo, syayaha gbar na. ");
INSERT INTO xrb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu tuu ba dyɛ- sẽnsye syãŋ yãã dyɛ lii, pe n ka u ne too gbar nde na, mii Yiifee- kãnde le yar mii. ");
INSERT INTO xrb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te gbar te ba kua wa, nawee- byɛ n dur ma n tɛr pe kui wo. Yesu n wlãhã kuee Yurusalɛm wo, u seefa sẽ le cã ye, ma tɛr u yaha. ");
INSERT INTO xrb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pe naa le ga ma yee, a ter u ma pe yrãhãyãrwai ne. Pe n sya yãr per wihi, ma cã yir u wãtay na pe nampyeŋ- laam wo, tesẽ pe naambiyãm ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pe sẽ u yãã ye, pe n gblihi laa, ma dur ma u tay n gaha, ma sya ga dye ke Yurusalɛm laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pe n u tay plii tãã ke Yurusalɛm laam wo, ma cã ga u yãã Yãhã kangbãŋ laam wo. U pye Yiifee- yahaseefa telai wo, tuu dye nii, ma nii n luhu pe ye, ma pe yey kai- ne. ");
INSERT INTO xrb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yesu ba kai- busãã cã, ma maha pe yahaseefa yɛ̃ wãã naa n sya kacãn ne. Nde n yɛ̃ gbãã mpãy na pe pye ke fla na. ");
INSERT INTO xrb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","U seefa pe u yãã, le n pe sroŋ fe gbe. U nahafua n u pye ma yee: «Ta dya, lii raa pye wo na ke dyaŋ? Ma sẽ yãã, ma wo ta wo n fya, ma nii ma tay teebɛhɛ byɛ wo, wo syãm ma tuhufua ne.» ");
INSERT INTO xrb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","U n pe yɛ̃ wãã sya ma yee: «Nwa ta ye n ga ra tay teelaa wo? Ye sẽ cã la, n yai n nii ta Tuhufua Yãhã kangbãŋ wo?» ");
INSERT INTO xrb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","U seefa sẽ -sẽ u kaplãŋ yĩntaha war ye. ");
INSERT INTO xrb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu n yir, pe n wãã kũn tɛr Nasarɛte wo. U naa n luhu pe ye. Koo kai- ngĩĩ pye tɛr, u nahafua Maari n ke byɛ le yaha u ya laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nii n lɛ, kaa nii n taha u kadye na, tesẽ u laantor ne. U wĩĩ naa n tãy Yãhã ye ma suhu nawee- ne. ");
INSERT INTO xrb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dyɛ lii kãntrɛ fãngafa byɛ yĩŋfua Tyibɛre fãnga wãma- ke ba nɔ dyɛ- sẽnsye bua na, koo cãã kẽ fãngafua Pɔ̃syi Pilati u pye Yudɛ kãntraha kur byɛ yĩŋ na. Yɛrɔte u pye Galɛlɛ kui yahaseefua, u nampyesey Filipe pye Lityire kui yahaseefua ma suhu Trakũhũ kui ne. Lesãhã u -sẽ pye Labyile kui yahaseefua. ");
INSERT INTO xrb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yana tesẽ Kayifu ne, poo pe pye Yãhã yũndefa yĩŋfa. Loo dyɛ Dyakaridya dya Nsãn tuu pye drawaha fla wo, ma Yãhã yɛ̃ kapãn luhu. ");
INSERT INTO xrb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Loo na, u n yir ma Yurdane lafeŋ tũntũn kui tay n klaha, ma nii le gble nawee- ye ma yee: «-Ye le sya ye cã ye kapee- wãpyeŋ sẽ yɔ̃ ye, -ye ke miy yaha! -Tee pa, ta n ba ye tãã yi loho wo. Yãhã -sẽ ga ye kapee- laha kãã ye yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Faale Yãhã kaplãŋ tɔ̃rfua Yisa, tuu bii lii cãã yrũhũ ta Yãhã sabangbãŋ wo Nsãn wĩĩ na, loo ne le nii n pye loo yale wo. Loo ne nde: «Naa waa yĩmbui ne le n yir drawaha fla wo ma yee: -Ye Yĩŋfua Yãhã wãpaŋ kãnde gbihi yaha ke kẽ, -ye ke kãmbɛhɛ ta ke n sroŋ yɔ̃! ");
INSERT INTO xrb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Teelii fla ma pye nfaha, ke fla ke yĩĩ. Yãygbãy ma suhu te wãsyĩmbir ne, te byɛ te traha kãã. Kãmbɛhɛ nkãy ke kuãy klaha, ke byɛ ke sroŋ. Kãmbɛhɛ nkãy ke pee, ke byɛ ke gbihi, ke nii diidii. ");
INSERT INTO xrb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yãhã ke lii pye ma ga wo sya yaha, kãntrahafa byɛ ga ba le yãã pe yĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nabuar naa n gaha Nsãn ye wãtãã yĩmbui ne. U naa pe pye ma yee: «Nwoho terfa mii! Yoo ye yar ma yee tee ga waha wloho yi kãã te Yãhã kasãhã laam wo, tii te n pai? ");
INSERT INTO xrb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","-Ye naa kayũhũ pye mii katyiyũhũ dyaŋ ke piiyɔ̃m sa. Loo na, le ga cã tee yi kãã kapee- wãpyeŋ kãnde wo, ma kayũhũ wãpyeŋ kãnde gbe. Ye tee le ga ye laam wo, a ye ma wo faale wãdyaha Brama kur, loo nde wĩĩ na, Yãhã ga ta ye n wlohoyisaha yãã. Ye sẽ yãã, Yãhã ga waha ntẽmbar nde ta te n wã klaha nii naweeyɔ̃m, pe n ye draha gbe, pe nii Brama kur. ");
INSERT INTO xrb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ta n ye yar: Mbaapuai gbihi cai ta nii wa, ma ga katyir cããr te nnen fla na. Katyigi gii ma yee ke sẽ sa yɔ̃ ye, ke ga gbã cɛr le naa wo.» ");
INSERT INTO xrb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pe nabuar n u yey ma yee: «Wo yai wo naa n pye mii wo nii naweeyɔ̃m?» ");
INSERT INTO xrb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nsãn n pe yɛ̃ wãã sya ma yee: «Nayrɛ sĩĩ ma pye wii ye, u neŋ wãã waa kẽ, wii ruu wee kaa ne ye. Digi ma yãã mboo wii ye, ke la fããfa ne.» ");
INSERT INTO xrb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kufar wããfa mpãy n pa Nsãn fla na tããsaha wo, ma ba u yey ma yee: «Yĩŋfua, wii yai wo naa n pye mii?» ");
INSERT INTO xrb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","U n pe yɛ̃ wãã sya ma yee: «Yɛ̃ gii pe tɔ̃r yar ye na, ye ma syi ye kufar wale sya le n ta naa n tɛr koo yaha ye!» ");
INSERT INTO xrb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Seraasyi mpãy n pa pe ya ndoŋ, ma ba u Nsãn yey loo nen ya ne ma yee: «Ah wii, wo yai wo naa n pye mii?» U n pe yɛ̃ wãã sya ma yee: «Ye ma syi ye naa wale sya fãnga na nawee- ye ye! Ye ma syi ye maha kawar fua naa n taha nawee- na ye naa war sya pe ye ye. Ye yĩŋfa pe ye dãã war mpãy ne, -ye naa n kuee poo ya ne!» ");
INSERT INTO xrb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nawee- mpãy pe pye ke fla na, ma naa u Yãhã Yĩndefua wãpaŋ yɛhɛ, pe naa le ga ma naa n yee, a laa na Nsãn kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Loo na, Nsãn n pe byɛ pye ma yee: «Ndoo, n ye tãã n yi loho wo. Waa ter -sẽ ma tuu n pai, woo cɛr yaha ra kẽ mahamaha. Ta syi gɛ sẽ yai u ntãn sale wãfɛr ne u trɛ na ye. Woo ga ba naa ye tãã Yãhã Yrã Fãnga ne, tesẽ naa ne. ");
INSERT INTO xrb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U ma mii nawee dyaŋ tuu ma sẽncrihi ne u koho wo. U ga sẽmuhu fua yi pua wo. Loo kur ye, u ga u pua le mploho wo, tuu naa le te sẽmuhu na, naa gii wãfege yãã wee ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nsãn maha ba naa kai- busãã yar nawee- na, ma naa le Yãhã kapãyĩĩ tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","U n ba yãã Galɛlɛ kui yahaseefua Yɛrɔte tuu yir, ma u ya lɛfuasey cɔɔ Yɛrɔtyade tyĩn sya u ye ma u ta u cɔɔ, u n le kuãn u ne, ma suhu kai- nkãy byɛ ne tuu tee naa n pye. ");
INSERT INTO xrb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","U Yɛrɔte sẽ luhu u ye ye, u ga cã lii pye le taha kapee, ma ta pe n u Nsãn yigi le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nawee- mpãy pe ba pa Nsãn fla na tããsaha wo, Yesu pye pe laam wo. Nsãn n Yesu tãã u ya ndoŋ. Loo kur ye, Yesu tuu naa n pãã Yãhã ne, yãhãyĩŋ n fe yãr, ");
INSERT INTO xrb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yãhã Yrã Fãnga n tege ba Yesu na. Le n le ya klaha mii kãnsyã waa ter dyaŋ. Yĩmbui laa ter n yir yãhãyĩŋ kuɛ ye ma yee: «Ta Dya kẽ ma ne, ma ntãŋ dye gboho ra tãy, ma ra laam yĩn yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu tuu ba dyɛ- gbey sẽnsye syi kua, tuu see ba lii wãpyeŋ myaha ne, u n le wãpyeŋ koho yigi. ");
INSERT INTO xrb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yeli pye Matar dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛfe -sẽ pye Matetya dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Matetya -sẽ pye Semii dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda -sẽ pye Yɔnaa dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Naari -sẽ pye Marki dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yɛr -sẽ pye Yosya dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Syimɔ̃ -sẽ pye Yuda dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melaa -sẽ pye Menaa dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yisay -sẽ pye Yobɛde dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminada -sẽ pye Adamen dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda -sẽ pye Dyakuba dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nasyɔɔ -sẽ pye Seru dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kanaa -sẽ pye Yarpasye dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matesyela -sẽ pye Yɛnake dya, ");
INSERT INTO xrb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Yenose -sẽ pye Sɛte dya, ");
INSERT INTO xrb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu wãtããyi kur ye, Yãhã Yrã Fãnga n u yĩĩ, ma u ta u n yir ke Yurdane lafeŋ wo, ma ka dragba wo. ");
INSERT INTO xrb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","U n ga kuee ke dragba wo plii gbeesĩĩ. Sãndãpee yĩŋfua Setane n nii u tyĩn ga n yãŋ kapee- wãpyeŋ kuɛ ye. Too plii gbeesĩĩ nsoho wo, Yesu sẽ ngaa di ye. Loo kur ye, fãã n u yigi. ");
INSERT INTO xrb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","U sãndãpee yĩŋfua n u pye ma yee: «Maʼa pye Yãhã Dya cĩĩnde, ntẽmblaha nge wã klaha digi.» ");
INSERT INTO xrb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu n u yɛ̃ sya ma u pye ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ laam wo ma yee: ‹Nawee saa waha poho digi ya ne ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Loo na, u sãndãpee yĩŋfua n Yesu yigi ga ncaha ye, ma kãntraha kui byɛ yar tãŋ u na, teele nen ya. U n dur ma u pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","«Kãntraha nge byɛ fãnga, tesẽ te nangbãn ne, n ga waha te wãã ma kẽ. Too nde byɛ le soho ra koho wo, te ma ta wãn. Wii wĩĩ ma tãy ra ye, n ga waha te wãã ufua kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Maʼa kãnklũy gbãã ra yahasee ye ma ra gboho, n ga te byɛ wãã ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu n u yɛ̃ wãã sya ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Naa Yãhã ya gboho, koo ya ke ma Yĩŋfua, -taa mii le soho koo ya koho wo!› » ");
INSERT INTO xrb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Loo na, u sãndãpee yĩŋfua n ka u ne Yurusalɛm wo, maa u ta u n dugu nii Yãhã kangbãŋ yããsyi na. U n dur ma u pye ma yee: «Maʼa pye Yãhã Dya cĩĩnde, yir nwo ma kur ye tege kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ma sẽ yãã, le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Yãhã ga ba ke yãhãyĩŋ tẽnlɛhɛ ye nɔ wãã, pe n ba naa n sẽŋ ma na. ");
INSERT INTO xrb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pe ga ba ma yigi pe kluɛ wo, ma saa mii kor ntẽmblaha na ye.› Loo ne ta n yee, ma kur ye tege kãntraha na!» ");
INSERT INTO xrb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu n maha u yɛ̃ wãã sya ma yee: «Ta n ma yar, le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Yãhã ke ma ma Yĩŋfua, maʼa syi ma ke tãn yãŋ ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setane tuu u kacãn byɛ ta ma Yesu tyĩn ga yãŋ kapee- wãpyeŋ kuɛ ye, u n dur tɛr ma u wãtyĩnyãŋ ta yaha per gaa na. ");
INSERT INTO xrb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Loo kur ye, Yesu n dur tɛr Galɛlɛ kãntraha wo. U ba yĩĩ Yãhã Yrã Fãnga ne. Pe n nii u wĩĩ pãã ke kuɛ kãntraha kur byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","U ba naa nawee- klaha Yiifee- yawãhã nwey laam wo. Nawee- byɛ naa u sey. ");
INSERT INTO xrb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu n ka Nasarɛte wo. U u kicar cãã pye ke fla na. Teebɛhɛ byɛ wo kanii per na, Yesu sẽ kɛ naa n laa Yiifee- yawãhã nwoŋ wo ye. Koo per ke ba nɔ, u n dye Yiifee- yawãhã nwoŋ wo ke Nasarɛte wo. U n yir yɛr, ma yee woo ga Yãhã kaplãŋ nkãy kal nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pe n saba waa gbe wãã u kẽ, saba wii faale Yãhã kaplãŋ tɔ̃rfua Yisa bii yrũhũ ta. U n u saba yãr, ma draha gaa kal nawee- ye, draha gii ke yrũhũ ta ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Yãhã Yrã Fãnga ma ra yĩŋ na, Yĩŋfua Yãhã ra yãŋ yi ma yee n naa koo kapãyĩĩ yar fɛnfa na. ");
INSERT INTO xrb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ke ra nɔ wãã n ba yãmpa ta pe n wlohoyisaha yãã, ma suhu fũũ- ne, pe n naa n yãŋ gbɛgbɛ, tesẽ mpãy ne pe fɛn sya ma yee tẽ ba poofa yi kãã napee- koho wo. Yãhã maha ra nɔ wãã n ba nawee- yar yaha dyɛ lii ne ke ga ba ke laantãr yar pe na.» ");
INSERT INTO xrb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Loo na, Yesu n u Yãhã sabangbãŋ tã tã, ma u wãã kaha sẽŋfua kẽ, ma dur tege nii maa nawee- klaha. Nawee- mpãy byɛ pe pye ke nwoŋ laam wo, pe n yĩnde gbãã u na ma nii u yãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu n -sẽ gbe ma nii pe yar ma yee: «Kai- ngĩĩ tẽ kal ye ye ke Yãhã sabangbãŋ wo ye n luhu, koo kẽ tee n yãã nanga, ke yagaa nge na.» ");
INSERT INTO xrb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yesu tuu naa kapãyũhũ nkãy pãã, ke ba yɛ̃ gbãã pe na. Pe n nii le klãŋ n pãã ma yee, a Yosɛfe dya woo syi ya la u n pãã ke syi? ");
INSERT INTO xrb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu n pe pye ma yee: «N cã, yaa plãhã nge pãã wãã ra kẽ: Tyinfua cãã mii jaa mii ya. Yaa maha waha ra pye ye yee: Kai- nkãy byɛ taa pye Kapornu wo, wo ke luhu. Maha koo syi pye ma kusey wo nwo wo.» ");
INSERT INTO xrb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","U n maha yee: «Ta n le pãã ye ye cĩĩnde: Yãhã kaplãŋ tɔ̃rfua klofa sẽ u wũhũ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","-Ye Yeli cãã kai- wũũ yãŋ, cãã gii cãã sesaha dyɛ- tãã pye gblihi ne, ke sẽ too ye. Fãã n bii dye taha nawee- byɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Koo cãã kẽ Yãhã ke bii Yeli nɔ wãã calangusya waa fla na Sarɛte wo, Syidɔ̃ kãntraha na. Le -sẽ nde calangusyam pye busãã Yeli klo wo Yiisrɛfa kãntraha na. Nwa ta Yeli sẽ ka poo nen waa fla na ye? ");
INSERT INTO xrb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yelisye bya cãã na, gber- pye busãã Yiisrɛfa kãntraha na. Nwa ta poo nen waa gɛ sẽ waha jaa ye? Namaha woo n jaa, woo wii u pye kulaafua, Syirefa naa waa.» ");
INSERT INTO xrb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mpãy byɛ pe pye ke yawãhã nwoŋ laam wo, pe Yesu kaplãŋ ngĩĩ luhu ga n kua na, ncafũhũ n pe yigi ma sya nafããn taha pe na. ");
INSERT INTO xrb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pe n tyĩn yir, ma u yigi ga le klo kãnkãy na. Le klo pye yãnjruhu gaa yĩŋ na. Pe n ka u ne ke ncaha ye, ma yee poo ga u miy tege wãã tãã ye kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Le n ga pe yia, Yesu n wloho yi pe laam wo ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Loo kur ye, Yesu n tege ga Galɛlɛ kãntraha klo laa wo pe n yee Kapornu. U naa nawee- klaha kanii per gaa na Yiifee- yawãhã nwoŋ wo. ");
INSERT INTO xrb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","U kaklaha ter ba nawee- fe gbe, ma maha pe laam wɔ. U ba kai- byɛ cã ma naa nawee- klaha te ne. ");
INSERT INTO xrb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ke yawãhã nwoŋ wo, dya waa pye sãndũpee ne u yĩŋ na. U n nii n tẽ fãnga ne ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Eh, Nasarɛtefa Yesu, maa nwa pye wo na? Ma pa la ma n pai wo wĩĩ klaha-? N cã wii kẽ ma ne: Mboo kẽ wii ne u ma Yãhã wũũ.» ");
INSERT INTO xrb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu n sã waha u sãndũpee na, ma u pye ma yee: «Yaha le, -taa tege kãã dya nwo yĩŋ na!» U sãndũpee n u dya cããr nawee- byɛ yĩnde na ma tege kãã u yĩŋ na, u sẽ -sẽ laa wãpee pye u na ye. ");
INSERT INTO xrb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Le n pe byɛ fe gbe ga far tɛr, pe n sya nii pe ya yey ma yee: «U kaplãŋ pye mii ma n yia sãndãpee na? Dya nwo n sã sãndãpee gɛ na fãnga ne, pe n nii n luhu u ye, ma tege n kãã nawee- yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesu myaha n yi koo kãntraha fla kur byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Loo kur ye, Yesu n yir ke yawãhã nwoŋ wo, ma ka dya waa kaha wo, u myaha Syimu. U Syimu cɔɔ nahafua kadye ba kã war. Pe n Yesu nar u u jaa. ");
INSERT INTO xrb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","U n kuɛ tege u yĩŋ na ma sã te yan na. Ke kadye n u miy yaha, u n ta tɛr yir ma nii pe nampay yi. ");
INSERT INTO xrb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Yainkɔŋ wo, yainde le ba dye tɛr wa, nawee- mpãy pe pye yanfa ne pe klɛ wo, pe n poo yanfa ter byɛ gbe ba Yesu fla na. U n kluɛ taha pe nanem byɛ na ma pe jaa. ");
INSERT INTO xrb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sãndãpee pye yanfa mpãy yĩŋ na, pe n nii tege n kãã pe yĩŋ na kule ne. Pe naa n kui ma naa n yee: «Yãhã Dya kẽ ma ne!» Pe ba cã Yãhã Yĩndefua Crise kẽ u ne, koo kẽ. Yesu naa n sã pe na, u sẽ naa n sya pe n naa u wĩĩ pãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Koo yĩŋsyii, Yesu n yi le klo wo, ma ka dragba gaa laam wo. Nabuar raa n yir ma nii u tay. Pe ga u yãã, pe n yee poo ga u yigi ta pe ya ne, u ma syi u tɛr poo yaha ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yesu n pe pye ma yee: «N yai n le Yãhã Yai kapãyĩĩ tɔ̃r yar kãnkãy kuifa byɛ na. Yãhã ra nɔ wãã loo na.» ");
INSERT INTO xrb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","U n nii le kapãyĩĩ wũhũ tɔ̃r Yiifee- kui yawãhã nwey wo. ");
INSERT INTO xrb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Per gaa, Yesu pye u ba yɛr Genesarɛ langbãŋ tãy. Nawee- ba wɔ tã u na ma naa Yãhã kaplãŋ luhu. ");
INSERT INTO xrb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","U n salangbãy raa yãã ke langbeŋ na, wãy sĩĩ. Pe fuayigifa ba tege kãã te wo, ma naa pe jɔɔ- yee. ");
INSERT INTO xrb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu n dugu dye salaŋ neŋ gaa laam wo, ke pye Syimu wãŋ. Yesu n Syimu ta u n faa ke salangbãŋ fã dur yi kãã ke langbeŋ na. Yesu n tege nii ke salangbãŋ wo, ma nii pe nawee- klaha. ");
INSERT INTO xrb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tuu ba pe nawee- klaha wa, u n Syimu pye ma yee: «Teelii fla ke n cuhu, -ye ka ke salangbãŋ ne ke fla na, ye ga ye jɔɔ- miy le!» ");
INSERT INTO xrb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Syimu n u yɛ̃ sya ma yee: «Yĩŋfua, wo tẽn tẽ yĩmper wihi, wo sẽ ngaa gɛ yãã yigi ye. Le nii mboo kapãn, n le sya n ga pe jɔɔ- miy le yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","U n ta pe n pe miy le, fua- n gbe pe laam wo, dege. Pe jɔɔ- namihi n sya n traha ke naa n cɛr. ");
INSERT INTO xrb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Loo na, pe n kluɛ yãhã wãã pe nampyeŋ- mii ye ke salangbãŋ neŋ ngaa wo, pe ba koho le pe ye. Pe n pa, pe n ba te salangbãy sĩĩ yĩĩ pe fua- ne, te n sya nii n kɛ te ne dye tɛr loho laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Syimu Pyar tuu nde yãã, u n ga kãnklũy gbãã Yesu yaha ye, ma u pye ma yee: «Yĩŋfua, kapeepyefua kẽ ra ne, maʼa syi kuee naa n crã ra na ye!» ");
INSERT INTO xrb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Syimu ba fya yigi nii, tesẽ mpãy byɛ ne pe pye ke fla na. Pe fua- ba gboho ga far tɛr, le n sya pe laam wɔ. ");
INSERT INTO xrb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Syake pye Nsãn ne, Sewede pii ba me. Syimu tẽntẽwai mpãy ba me pe ne. Pe ba fya pe ya ndoŋ. Yesu n Syimu pye ma yee: «Maʼa syi ma fya ye! Taa naa fua- le jɔɔ wo mii, yagaa, nawee- me taa ga naa n le kãnfuɛ̃ wo ke syi.» ");
INSERT INTO xrb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Loo na, pe byɛ n ka te salangbãy ne ngbãŋ na, ma pe wãn kur byɛ ta yaha, ma taha Yesu na pe kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu pye klo laa wo, gber waa n pa u fla na, te yãhã ba u kadye byɛ gbe tã. Tuu Yesu yãã, u n ga kãnklũy gbãã u yahasee ye, ma u nar ma yee: «Yĩŋfua, le ma tãy ma ye, ma ga waha ta ra n jaa, n nii gbɛgbɛ nayɔ̃r saha na.» ");
INSERT INTO xrb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu n koho nɔ wãã, ma tɛ u na ma yee: «Ãwã le tãy ra ye, jaa ma nii gbɛgbɛ nayɔ̃r saha na!» Le yalebya wo, ke yãhã n ta tɛr laha kãã u dya na, u n nii gbɛgbɛ nayɔ̃r saha na. ");
INSERT INTO xrb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu n le pãã waha u ye ma yee: «Maʼa syi nde pãã waa ye ye! -Taa ka, maa mii yar Yãhã yũndefua na, ma ma wãjaa diŋ yi, diŋ gii faale wãdyaha Musa tuu tɔ̃r yaha mpãy kẽ pe pye yãhã ne pe kadye na, ma jaa. Ke syi ne nawee- ga waha cã ma jaa.» ");
INSERT INTO xrb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Loo nde kur ye, Yesu myaha yi naa n gaha teebɛhɛ byɛ wo. Nabuar n te ya wãã naa n pai u kaplãŋ luhusaha wo, tesẽ pe ya wãjaa saha wo. ");
INSERT INTO xrb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu woo -sẽ naa n kɛ u naa n nii u ya ya, u naa n gaha dragba wo, u ga naa u laam wũhũ tɔ̃r Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Per gaa, Yesu naa nawee- klaha. Pe nawee- laam wo, Yiifee- yahaseefa mpãy pye, pe naa n yee Farisyɛ̃, tesẽ Yãhã kaiyarfa mpãy ne. Pe ba yi Galɛlɛ kui byɛ wo, tesẽ Yudɛ kui byɛ ne, ma suhu Yurusalɛm ne. Yĩŋfua Yãhã fãnga pye Yesu ne, ma u ta u n waha naa yanfa jaa. ");
INSERT INTO xrb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nawee- mpãy n ba pa tãnkurfua waa ne, pe u gbe u kasãy wãŋ na. Pe naa n kɛ pe dye u ne Yesu tãy nwoŋ laam wo, pe ga u ta u yaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pe sẽ waha dye ye, nawee- tee ba nihi tɛr. Pe n gblihi laa, ma dugu ke nwoŋ yĩŋ na maa wihi fer, ma u tãnkurfua yoŋ tege le wãã u kasãy wãŋ na pe nawee- telai wo, Yesu yaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu tuu yãã poo nawee- mii pe u ta pe Yatɛr, u n u yanfua pye ma yee: «Cĩĩfua, ma kapee- laha kãã ma yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pe Yãhã kaiyarfa tesẽ pe Farisyɛ̃ ne, pe n nii le ga pe laam wo ma yee: «Yoo ma u ga waha kapee- laha kãã nawee yĩŋ na mii Yãhã ya sẽ kẽ ye? -Ye naa dya waa syi yãŋ! U n gbar Yãhã ne cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu -sẽ ba pe laam wũhũ cã. U n pe pye ma yee: «Nwa ta ye n nii kai- ngĩĩ syi ga ye laam wo? ");
INSERT INTO xrb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","N ga waha yee: Ma kapee- laha kãã ma na. N ga maha waha yee: Yir naa n yãr! Koo katɛ- syãŋ ngĩĩ wo, lii loo le cã waha? ");
INSERT INTO xrb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","N yãŋ ye cã Yãhã kãnde wãã u Nawee Puee kẽ kãntraha nge na, u n ga waha kapee- laha kãã nawee yĩŋ na.» Yesu n wã klaha loo na, ma u tãnkurfua pye ma yee: «N ma yar, yir, -taa ma kasãy wãŋ gbe, ma yãr naa n gaha ma kaha wo!» ");
INSERT INTO xrb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","U tãnkurfua n ta tɛr yir nawee- byɛ yĩnde na, ma u kasãy wãŋ gbe, kii tuu ba sãy nii, ma yãr n tɛr ma Yãhã sey n gaha u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Le n yɛ̃ gbãã pe nawee- byɛ na, pe n sya fya, ma nii Yãhã sey ma yee, a poo laanwɔ wũhũ yãã koo per. ");
INSERT INTO xrb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Loo kur ye, Yesu n yi ma kufar wããfua waa yãã, tuu tege nii kufar wããsaha wo. Pe naa u yee Lewi. Yesu n u pye ma yee: «Naa n taha ra na!» ");
INSERT INTO xrb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi n te wãn kur byɛ ta yaha, ma yir, ma nii n taha Yesu na u kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Loo kur ye, Lewi n gbar ta u kaha wo Yesu myaha na u kãnyãrwai ne, ma ta pe n dir soho. Pe pye pe wãã naa n di kufar wããfa busãã ne, tesẽ nawee- mpãy ter ne. ");
INSERT INTO xrb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisyɛ̃ mpãy pye ke fla na, tesẽ Yãhã kaiyarfa mpãy ne pe pye yĩmbui nen na pe Farisyɛ̃ ne. Poo mii pe Yesu yãã, tuu wãã n di nawee- mii ter syi ne, le sẽ tãy pe ye ye. Pe n Yesu kãnyãrwai pye ma yee: «Nwa ta ye n nii wãã n di kufar wããfa ne, ma suhu kãmpee- yãrfa mpãy ter ne?» ");
INSERT INTO xrb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu n pe yɛ̃ wãã sya ma yee: «Yĩnwɛrfa poo sẽ me pe tyinfua tay ye, yanfa poo pe u tay. ");
INSERT INTO xrb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N pa kãmpee- yãrfa myaha na, ma n kɛ pe koho klaha. Mpãy pe pe ya yãŋ poo ma kãnyĩĩ yãrfa, n sẽ pa poo mii myaha na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Loo kur ye, nawee- mpãy n ba Yesu pye ma yee: «Nsãn kãnyãrwai ne pe yɛ̃ tã digi na, pe Yãhã nar. Farisyɛ̃ kãnyãrwai bya loo pye. Ah nwa ta mboo kãnyãrwai -sẽ n di ma n wɔ?» ");
INSERT INTO xrb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu n pe yɛ̃ sya kakuãcran ne ma yee: «Ah ye laam wo, cafãn yigifa ga waha fãn wãdi sye la te cafãn yigisaha wo, u cafãn yigifua yĩnde na? Ye cã le syi saha pye ye rɛhɛ! ");
INSERT INTO xrb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per gaa -sẽ ma ke n pai, u cafãn yigifua ga ba yigi kãã pe laam wo. Koo per maa nɔ, pe ga ba cã naa pe yɛ̃ tã digi na.» ");
INSERT INTO xrb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu n maha kakuãcran nde pãã pe ye ma yee: «Waa sẽ nayrefãŋ fai kuãy n cɛr, ma nayredyaha wihi pãhã n tã le ne ye. Maʼa loo pye, ma ke nayrefãŋ cɛr pye klaha-, ke nayrefãŋ faagblaha wãsɛr ga maha ke nayredyaha tyĩn jũũ taha. ");
INSERT INTO xrb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Waa sẽ maha sẽmper le srafũhũ sakueelɛr wo ye. Maʼa loo pye, pe sẽmper maa yir, te srafũhũ sakueelɛr ga fe, pe sẽm n woo tãŋ, te srafũhũ sakuee tii maha klaha- taha le na. ");
INSERT INTO xrb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Koo kẽ sẽmper yai pe le srafũhũ sakueefãn too laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wii tuu sẽndyaha wɔ wa, u sẽ maha sẽmper kɛ nantãŋ ye. Pe sẽ n yee la sẽndyaha poo n tãy?» ");
INSERT INTO xrb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kanii per gaa na, Yesu dye yi naa n tɛr tar raa wo, u kãnyãrwai ne. U kãnyãrwai n nii te tar kasan kãy, ma te pii wihi kũ n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisyɛ̃ mpãy pye ke fla na. Pe n u kãnyãrwai yey ma yee: «Wo kãnde le kai- nkãy yar ke sẽ yai ke naa n pye kanii per wo ye, nwa ta ye n nii le syi laa pye?» ");
INSERT INTO xrb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu n pe yɛ̃ sya ma yee: «Ye le kal yãã Yãhã sabangbãŋ wo, faale yĩŋfua Dawide u bii lii pye, per gii fãã bii war pe na, woo tesẽ u nawee- ne. ");
INSERT INTO xrb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","U dye Yãhã nwoŋ laam wo, bur rii te pye te bii kẽ Yãhã ye, u n te gbe di, ma taa wãã u nawee- kẽ. Wo kãnde na, Yãhã yũndefa ya sẽ na pe yai too bur nde ne?» ");
INSERT INTO xrb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu n maha pe pye ma yee: «U Nawee Puee kẽ u ma kanii per yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kanii per gaa maha ba nɔ, Yesu n ga dye Yiifee- yawãhã nwoŋ gaa wo, ma nii nawee- klaha. Dya waa pye ke fla na, u kãndigi koho ne wãwaage. ");
INSERT INTO xrb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yãhã kaiyarfa mpãy pye ke fla na, tesẽ Farisyɛ̃ mpãy ne. Pe naa Yesu yãŋ, ncã u ga ba sya u yee, woo ga waa jaa ke kanii per wo laa. U ma le syi pye pe n waha yee, a ter Yesu ma tuu tee n pye. ");
INSERT INTO xrb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu -sẽ ba pe laam wũhũ cã wa. U n u kãnwaagefua pye ma yee: «Yir ba yɛr nawee- telai wo.» U dya n yir ga yɛr ke fla na. ");
INSERT INTO xrb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Loo na, Yesu n pe pye ma yee: «N ga ye yey laa ne: Wo kãnde wo lii wãpyeŋ le yɔ̃? Kayĩĩ wãpyeŋ yɔ̃ kanii per wo laa, kapee wãpyeŋ loo le yɔ̃? Wo nawee yrã sya yaha laa, wo u wĩĩ pye klaha-?» ");
INSERT INTO xrb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Loo na, u n pe byɛ yãŋ klaha, ma dur ma u kãnwaagefua pye ma yee: «Ma koho dii wãã!» U n le pye, ke koho n dur yɔ̃ nii u ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mpãy pe pye ke fla na, ncafũhũ n -sẽ pe yigi, pe n sya nii n pãã pe ya nsoho wo, kapee lii pe ga waha pye Yesu na. ");
INSERT INTO xrb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Per gaa, Yesu n ba dugu ga yãy nsoho wo, ma ga nii n pãã Yãhã ne ke per yĩmper byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yĩŋ ke ba syii wa, u n u kãnyãrwai yee ba, maa nawee- sẽnsye syãm yãŋ yi pe laam wo ma poo ta u tẽnlɛhɛ. Pe myar nde: ");
INSERT INTO xrb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Syimu wii Yesu Pyar myaha taha u na, ");
INSERT INTO xrb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","U n Matɛhɛ yee, tesẽ Tema ne, ");
INSERT INTO xrb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","U n Syake dya Yuda yee, ");
INSERT INTO xrb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu n tege kãã poo mii ne te yãy nsoho wo, ma ba yɛr trahatraha fla gaa na. Koo fla na, u kãnyãrwai mpãy pye, pe ba nihi. Nabuar raa maha pye, te ba yi Yudɛ kui byɛ wo, tesẽ Yurusalɛm ne, ma suhu Tyir ne tesẽ Syidɔ̃ ne, langbãŋ yɛ̃ kui kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pe ba pa pe n pai naa u kaplãŋ luhu, u n maha naa pe yanfa jaa. Tuu naa pe jaa, mpãy pye sãndãpee ne pe yĩŋ na, u n maha pe sãndãpee kar tege kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fãnga gaa syi naa n yi u na ma naa pe byɛ jaa. Pe nawee- byɛ n -sẽ naa n kɛ pe tɛ u na. ");
INSERT INTO xrb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Loo na, Yesu n u kãnyãrwai yãŋ, ma nii pe yar kai- nkãy ne ma yee: «Yii mpãy tee mii nawãm, ye wĩĩ n tãy Yãhã ye. Yãhã Yai ma ye wãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yii mpãy tee mii fããfa yagaa, ye wĩĩ n tãy Yãhã ye. Ye ga ba digi yãã, ke saa pye wãditãŋ wãŋ ye. Yii mpãy tee mii miiwũnfa yagaa, ye wĩĩ n tãy Yãhã ye. Ye ga ba naa nuhu di. ");
INSERT INTO xrb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ye wĩĩ ma pee nawee- ye, pe ma kur waa ye na, pe ma ye tyɛhɛ, pe ma ye myar klaha- u Nawee Puee wĩĩ na, ye wĩĩ n tãy Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Koo kai- ngĩĩ maa ye dye per gii, ye naa nuhu di ye sya naa n yɔɔ. Yãhã ga ba kayũhũ wãã ye kẽ yãhãyĩŋ na. Nawee- mpãy pe ga ba kapee- ngĩĩ pye ye na, poo nawee- mii wãlɛ bii koo syi pye pe faale Yãhã kaplãŋ tɔ̃rfa na. ");
INSERT INTO xrb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Yii mpãy tee -sẽ mii walefa, ye wĩĩ pee Yãhã ye. Ye ye kayũhũ lay yãã wa. ");
INSERT INTO xrb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yii mpãy tee -sẽ mii diyaifa yagaa, ye wĩĩ pee Yãhã ye. Ye ga ba nii fãã ne. Yii mpãy, tee -sẽ mii nuhudifa yagaa, ye wĩĩ pee Yãhã ye. Ye miiwũn ga ba gboho tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nawee- byɛ ma nii ye miiyũhũ yee, ye wĩĩ pee Yãhã ye. Ye sẽ yãã, poo nawee- mii wãlɛ bii naa n pye koo syi pe faale kawar Yãhã kaplãŋ tɔ̃rfa ne.» ");
INSERT INTO xrb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu n maha yee: «Ta n le pãã ye ye, yii mpãy ye n luhu ra ye: Ye tyii ye napĩĩ- wĩĩ n naa n tãy ye ye! Ye wĩĩ pee mpãy ye, -ye naa kayũhũ pye pe kẽ! ");
INSERT INTO xrb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mpãy pe yoosẽn pãã n wãã ye kẽ, -ye naa Yãhã nar ke n kaa taha pe na! Mpãy pe ye nuhu, -ye naa wãyĩĩ nar Yãhã ye pe kẽ! ");
INSERT INTO xrb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Waa ma ma fey ndicĩĩ nen na, maha ndicĩĩ nen nde gbihi ta u kẽ. Waa ma ma nayrengbãŋ gbe, tyii u n ke wãsyĩnge byɛ gbe taha! ");
INSERT INTO xrb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nawee wii woo u ma nar ngaa ne, u kẽ; wii ma ma kla gbe, maʼa n ke wĩĩ yey u ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Lii le n tãy ye ye pe naa n pye ye kẽ, -ye naa koo syi pye nawee- kẽ! ");
INSERT INTO xrb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ye ma yee ye tããfa ya wĩĩ n tãy ye ye, ye yee la ye kayũhũ pye gboho n tɛr? Mpãy gɛ pe sẽ Yãhã kãnde yãr ye, pe tããfa wĩĩ n tãy pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mpãy pe kayũhũ pye ye kẽ, ye ma yee ye kayũhũ pye poo ya kẽ, ye yee la ye kayũhũ pye gboho n tɛr? Mpãy gɛ pe sẽ Yãhã kãnde yãr ye, pe ke syi pye pe ya kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mpãy tee n yãŋ ma yee pe ga waha fuɛ dãã, ye ma yee ye foho le poo ya na, ye yee la ye kayũhũ pye gboho n tɛr? Aye, mpãy gɛ pe sẽ Yãhã kãnde yãr ye, pe foho le pe nampyeŋ- na, ma yee pe ba loo wale yɛ̃ dãã pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ye tyii ye napĩĩ- wĩĩ n naa n tãy ye ye, -ye naa kayũhũ pye pe kẽ, -ye naa foho le pe na; ye ma syi ye naa le wale wãdur wĩĩ ga ye, Yãhã -sẽ ga ba kayũhũ wãã ye kẽ. Loo na, nawee- ga cã ye ma Yãhãngbãŋ pii. Mpãy pe sẽ kayĩĩ fuɛ cã ye tesẽ napee- ne, Yãhã n yɔ̃ pe byɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wo Tuhufua Yãhã u yɔ̃ nii mii, ye bya -ye nii u wãŋ syi dyaŋ!» ");
INSERT INTO xrb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu n maha yee: «Ye ma n naa ye nampyeŋ- kaa ye, Yãhã bya sẽ -sẽ ga ba ye sãhã ye. Ye ma yee ye sẽ ye nampyeŋ- le kawlaŋ wo ye, Yãhã sẽ -sẽ ga ba ye le kawlaŋ wo ye. Ye tyii ye nampyeŋ- kapee- foho na, Yãhã -sẽ ga ba tyii ye bya kapee- foho na. ");
INSERT INTO xrb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","-Ye naa ye nampyeŋ- kẽ, Yãhã -sẽ ga ba ye kẽ; ke ga ba ye kẽ ye n sya toho yigi laa ntraŋ na. Tee tãn n wãã ye nampyeŋ- kẽ mii, Yãhã -sẽ ga ba tãn wãã ye kẽ ke syi.» ");
INSERT INTO xrb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu n maha pe yar plãhã gaa ne ma yee: «Fũũ waa saha fũũ waa yigi koho na u ka u ne fla ngaa na ye. Mii loo sẽ ne ye, pe n gaha too dye wuhu gaa laam wo, pe syãm byɛ. ");
INSERT INTO xrb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ye le cã ma yee, wii tuu n klaha nantãŋ, u sẽ tɛr u klahafua yaha ye. U ma -sẽ u ya waha, u ga ba nii u klahafua dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kãnkããle lii le ma ma nampyeŋ yĩnde wo, nwa ta ma n nii le yãŋ? Tẽngbãŋ gii ke -sẽ ma ma yĩnde wo, ma sẽ koo yãã la? ");
INSERT INTO xrb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mboo wii taa sẽ waha ke tẽngbãŋ yãã ma yĩnde wo ye, ma ga waha ma nampyeŋ pye la u yɛr, ma n le kãnkããle yi kãã u yĩnde wo u kẽ? Dawarfua kẽ ma ne, cãã ke tẽngbãŋ yi kãã wa ma yĩnde wo, loo na maa waha gbihi yãŋ, ma le kãnkããle yi kãã ma nampyeŋ yĩnde wo. ");
INSERT INTO xrb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Katyiyũhũ sẽ puapihi sa ye, tesẽ katyipihi sẽ puayɔ̃ sa ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Katyigi yãŋ n cã ke pii mpãy na ke n sa. Waa sẽ nasar nkugu tai yãã ncũwãã na ye. Waa sẽ defĩĩ katyipir tai yãã ngur katyigi na ye. ");
INSERT INTO xrb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nawee wii ma yɔ̃, kayũhũ ga naa n yi u laam wo, u n naa ke pye. Nawee wii ma pee, kapee- ga naa n yi u laam wo, u n tee naa n pye. Nawee laam ke yĩĩ nkãy ne, koo kẽ ke n yi u yɛ̃ wo.» ");
INSERT INTO xrb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu n maha yee: «Tee ra yee Yĩŋfua, Yĩŋfua, nwa ta tẽ -sẽ kãnde lii ta ye kẽ, ye n le wãyãr sye? ");
INSERT INTO xrb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nawee wii woo u n pai ra ye, maa ra kaplãŋ luhu, ma u troho tãhã ke yor wo, woofua ma ngii wãŋ syi dyaŋ n ga ye yar: ");
INSERT INTO xrb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Woofua ma mii nawee wii dyaŋ tuu nii nwoŋ fãã. U ga cãã ke kãntraha tugu, u sya ga nɔ ntẽmblaha fla na. Loo kur ye, u ga ke nwoŋ nakũy ta, tuu ke fãã. Lakuɛ yĩĩ loho ne, lafir n cããŋ yi ga, maa ke nwoŋ sugu, te sẽ -sẽ waha ke sugu cããr ye. Koo nwoŋ wãfãã ba yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nawee wii u ra kaplãŋ luhu, u sẽ -sẽ u troho tãhã ke yor wo ye, woofua ma mii nawee wii dyaŋ tuu u nwoŋ fãã kãntraha ya na. U sẽ ke nwoŋ nakũy fla tugu dye ga nɔ ntẽmblaha fla na ye. Lafir n cããŋ yi ga, maa ke nwoŋ sugu; ke n too pye klaha- tãŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu tuu ba kaplãŋ ngĩĩ byɛ pãã wa pe nawee- ye, u n tɛr Kapornu wo. ");
INSERT INTO xrb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Loo klo nde wo, seraasyi yĩŋfua waa pye tẽntẽle waa ne. U tẽntẽle wĩĩ sroŋ naa n tãy u ye. Woo tẽntẽle n yigi, ma ga kuee wale nen. ");
INSERT INTO xrb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","U seraasyi naa, tuu Yesu wĩĩ luhu, u n Yiifee- wãlɛ mpãy lɛhɛ wãã, pe ga Yesu yar u ba u tẽntẽle jaa. ");
INSERT INTO xrb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pe n ga Yesu yãã, ma nii u sroŋ nar ma u yar ma yee: «Seraasyi yĩŋfua nwo yai ma laa pye u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wo klofa wĩĩ n tãy u ye. Woo kẽ u ta pe n wo yawãhã nwoŋ fãã.» ");
INSERT INTO xrb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Yesu n kãnde sya pe ne. Pe ba nɔ gbe taha ke kaha na, u seraasyi yĩŋfua n u naambiyãm mpãy lɛhɛ wãã, pe n ga Yesu pye ma yee: «Yĩŋfua, maʼa syi mii fãy ye. Ma ra yãã la tẽ n ka ma fla na? Ta syi sẽ yai ma ba dye ta kaha wo ye. Koo syi kẽ, n sẽ sya ma ka nii ya ma fla na ye. Kapãngbɛrle laa ya pãã, le n ta ra tẽntẽle n jaa. ");
INSERT INTO xrb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","N ma seraasyi, n n luhu ra yĩŋfa ye. N -sẽ ma nii ndoŋ seraasyi mpãy yĩŋ na. N ga nen waa pye: Ka nwaa, u n ka; n ga nen nwo ter pye: Pa nwo, u n pa. N ga maha ra tẽntẽle pye: Nde pye, u n le pye.» ");
INSERT INTO xrb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu tuu u kaplãŋ ngĩĩ luhu pe nawee- mii yɛ̃ na, le n u fe gbe. Nabuar mpãy pe naa n taha u na, u n wã klaha ma pe pye ma yee: «Ta n ye yar, dya nwo tuu sẽ sya wee Yiifee- ye, u ra ta u Yatɛr u laam byɛ wo cĩĩnde. Yiifee- kur byɛ gɛ laam wo, n sẽ waa yãã yãã tuu ra ta u Yatɛr woo wãŋ syi ye.» ");
INSERT INTO xrb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pe tẽnlɛhɛ n dur tɛr u seraasyi yĩŋfua kaha wo, maa u tẽntẽle yãã u jaa ma nii korkor. ");
INSERT INTO xrb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Loo kur ye, Yesu n ka klo laa wo pe naa n yee Nani. U kãnyãrwai pye u ne tesẽ nabuar raa ne. ");
INSERT INTO xrb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pe ga nɔ le klo kapahayɛ̃ na, pe n nawee- wãã sya pe n gaha nakugu gaa lesaha wo. Calangusya waa dyapuai nen ba kẽ. Le klo nawee- busãã pye u cɔɔ ne, ke nakugu lesaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yĩŋfua Yesu tuu u cɔɔ yãã, u fɛn n u yigi ga ta tɛr, u n u pye ma yee: «Maʼa naa n wũn ye!» ");
INSERT INTO xrb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","U n yũhũ dye, maa tɛ wãŋ gii na pe ba ke nakugu le. Ke gbefa n yɛr. Yesu n ke nakugu pye ma yee: «Cĩĩfua, yir yãŋ!» ");
INSERT INTO xrb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","U dya wii tuu ba ku u n yir nii, ma n pãã. Yesu n u dya wãã u nahafua kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pe nawee- byɛ n fya nii, ma nii Yãhã sey ma yee: «Yãhã kaplãŋ tɔ̃rfuangbãŋ waa ma wo ne.» Tesẽ: «Yãhã pa ke n pai dye ke nna kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yudɛ kuɛ kui wo, tesẽ kui nkãy ne ke pye tũntũn, Yesu tuu lii pye nawee- byɛ n le cã kãã. ");
INSERT INTO xrb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nsãn nawee- tããfua kãnyãrwai n ke kai- byɛ luhu, ma ba ke tɔ̃r Nsãn ye. ");
INSERT INTO xrb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","U n syãm mpãy yee ba pe laam wo, maa pe lɛhɛ wãã pe ga u Yĩŋfua Yesu yey pe yee: «U Yãhã Yĩndefua wii wãpaŋ too n sẽŋ, mboo la woo laa, u kuee wãpaŋ na kur ye?» ");
INSERT INTO xrb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pe Nsãn kãnyãrwai syãm n ka Yesu fla na, maa u pye ma yee: «Nsãn wo lɛhɛ wãã, wo ba ma yey laa ne: U Yãhã Yĩndefua wii wãpaŋ too n sẽŋ, mboo la woo laa, u kuee wãpaŋ na kur ye?» ");
INSERT INTO xrb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Loo yalebya wo, Yesu n yanfa buar jaa pe yan na. Mpãy pye sãndãpee ne pe yĩŋ na, u n pe sãndãpee kar tege kãã pe yĩŋ na. Fũũ- pye, u n pe jaa pe n nii n yãŋ gbɛgbɛ. ");
INSERT INTO xrb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","U n Nsãn tẽnlɛhɛ pye ma yee: «Tee nkãy yãã yĩnde ne ma nkãy luhu, -ye ka yaa ke tɔ̃r yar Nsãn na ye yee: Fũũ- n yãŋ, tãnklahafa gbihi n yãr, gber- wã n klaha n nii gbɛgbɛ nayɔ̃r saha na, nditẽy n luhu, nakur n yir gbã wo, le Yãhã kapãyĩĩ n pãã nawãm ye. ");
INSERT INTO xrb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wii ma yee u sẽ ba dur yi ta kur ye ye, ta n nii yai tãŋ u Yatɛr, woofua wĩĩ n tãy Yãhã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","U Nsãn tẽnlɛhɛ pe tɛr wa, Yesu n nii Nsãn wĩĩ pãã pe nabuar ye ma yee: «Tee ka Nsãn fla na drawaha fla wo, ye -sẽ ka ma ga nwa yãŋ? Kipua sẽ kẽ tee ga yãŋ teflaha ke u yɛhɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ye -sẽ ka maa nwa yãã? Ye sẽ ka maa dya waa yãã tuu nangbãŋ nayreyɔ̃r le yɛr ye rɛhɛ? Ye cã mpãy pe nangbãm nayreyɔ̃r le, ma maha ma katãr ne, pe n nii nangbãm kangbãy wo. ");
INSERT INTO xrb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tee ka, Yãhã kaplãŋ tɔ̃rfua sẽ na tee ga yãŋ? Ãwã, ta n ye yar, Nsãn wii tee ga yãã u tɛr gɛ tɛr Yãhã kaplãŋ tɔ̃rfua yaha. ");
INSERT INTO xrb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nsãn wĩĩ kẽ le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹N nwo, n ta tẽnlɛhɛ nɔ wãã ma yahasee ye, u n ga ta kãnde gbihi yaha ma kẽ.› » ");
INSERT INTO xrb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu n maha yee: «Ta n ye yar, naa wii u tɛr Nsãn yaha, usyi sẽ see wa ye. Wii u kloŋ Yãhã Yai wo, woo -sẽ tɛr Nsãn yaha. ");
INSERT INTO xrb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pe nawee- byɛ tesẽ pe kufar wããfa ne, pe byɛ naa n luhu u Nsãn ye. Pe ba le yãŋ cã ma yee Yãhã kai- sroŋ, ma ka Nsãn n ga pe tãã yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisyɛ̃ poo tesẽ Yãhã kaiyarfa ne, Yãhã ke n yãŋ pe lii pye, pe n le sye pe sẽ ka Nsãn n ga pe tãã yi loho wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","N ga waha yagaafa tɔ̃r mpãy ter syi ne? Pe ma nawee- mpãy ter syi dyaŋ? ");
INSERT INTO xrb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pe ma mii kicar dyaŋ, pe tege nii nanihi nantrangbãŋ fla wo. Mpãy n nii pe nampyeŋ- pye ma yee: ‹Wo fleŋ wuu ma yee -ye yɔɔ, ye sẽ -sẽ yɔɔ ye. Wo n dur ma kasii yay le, ye sẽ -sẽ wũn ye.› ");
INSERT INTO xrb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ye sẽ yãã, Nsãn nawee- tããfua tuu yir, u sẽ bur di ye, u sẽ maha defĩĩ wɔ ye. Ye n loo yãã ma yee, sãndũpee ma u yĩŋ na! ");
INSERT INTO xrb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","U Nawee Puee tuu yir, u bur di ma defĩĩ wɔ. Tee loo yãã ye maha n yee: ‹Ye sẽ dya nwo yãã? U ma tefɛŋ, ma maha ma sẽnwɔplaha. U maha naambiyãr le kufar wããfa poo ne, tesẽ kãmpee- yãrfa mpãy ter syi ne.› » ");
INSERT INTO xrb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yesu n pe yar taha ma yee: «Ye sẽ yãã, mpãy pe pe troho tãhã Yãhã yor wo, pe kai- sroŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisyɛ̃ naa waa pye pe naa n yee Syimu. Per gaa, u ba Yesu nampay yi u kaha wo. Yesu n ga draŋ nii, ma ga di. ");
INSERT INTO xrb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Loo klo wo cɔɔ waa pye, u myaha ba klaha-. Tuu Yesu wĩĩ luhu, u ma u n di u Farisyɛ̃ Syimu kaha wo, u n pa yablater ntẽmblaha bule ne lasekole ne le laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tuu ba dye, u n ga kãnklũy gbãã Yesu kur kuɛ ye u trɛ tãy, ma nii n wũn, ma u yĩntãm ta ma nii Yesu trɛ tuhu. U n ba u yĩnyor ta ma te kluã, ma te tɛ n tege u kẽ, ma dur ma pe lasekole kaha woo te na. ");
INSERT INTO xrb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","U Farisyɛ̃ naa wii tuu Yesu yee ba, u n le yãã, ma nii laam ga ma yee: «Dya nwo ma ne pye u ma Yãhã kaplãŋ tɔ̃rfua cĩĩnde, u ne ga cã nawee wii syi ter kẽ cɔɔ nwo ne, u n tɛ u na. Ehe, u myaha klaha-.» ");
INSERT INTO xrb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu n kapãn gbe, ma u Farisyɛ̃ naa pye ma yee: «Syimu, yãŋ, n ga ma yar laa ne.» Syimu n u yɛ̃ sya ma yee: «Ãwã, ta yar Yĩŋfua!» ");
INSERT INTO xrb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu n kaplãŋ kuã cra pãã u ye ma yee: «Foholefua waa ba foho le nawee- syãm mpãy na: Nen pye war nagbeesĩĩ sẽnsye fuɛ ne, nen nwo -sẽ pye war nyerbua fuɛ ne. ");
INSERT INTO xrb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe sẽ waha naa pe war dãã u kẽ ye, u n ba pe pye pe tyii ke foho na, pe syãm byɛ. Yagaa, u fuɛlefua wĩĩ ga cã tãy tɛr wii woo ye?» ");
INSERT INTO xrb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Syimu n u yɛ̃ sya ma yee: «Ta laam wo, wii fuɛ le ba gboho, u wĩĩ ga cã tãy tɛr woo ye.» Yesu n yee: «Cĩĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","U n wã klaha u cɔɔ kuɛ ye, ma Syimu pye ma yee: «Ma sẽ cɔɔ nwo yãã? Mboo kaha tẽ dye, ma sẽ ra kẽ loho ne ta n ta trɛ yee ye, woo -sẽ ta trɛ yee u yĩntãm ne, ma te kluã u yĩnyor ne. ");
INSERT INTO xrb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mboo, ma sẽ ra wãã yigi ma ra syar nampay syaha ne ye. Tẽ ba dye, u cɔɔ woo -sẽ kuee ra trɛ tɛ n tege. ");
INSERT INTO xrb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma sẽ sẽm- woo ra kẽ yĩŋ na ye, woo -sẽ lasekole woo ra kẽ trɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Koo ta n ga le pãã ma ye: U cɔɔ kapee- ba nihi tɛr, yagaa ke byɛ laha kãã u yĩŋ na, loo ne ta wĩĩ n tãy ga ta tɛr u ye. Kapee- car ma -sẽ laha kãã wii yĩŋ na, ta wĩĩ saha tãy tɛr ufua ye ye.» ");
INSERT INTO xrb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu n u cɔɔ pye ma yee: «Ma kapee- laha kãã ma yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mpãy pe naa n di Yesu ne, pe n nii laam ga ma yee: «Yoo kẽ dya nwo ne, u n sya yee woo ma tuu kapee- laha n kãã nawee- yĩŋ na?» ");
INSERT INTO xrb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu n -sẽ u cɔɔ pye ma yee: «Taa ra wĩĩ sya ma ra ta ma Yatɛr, ma sya yaha, naa n gaha pra.» ");
INSERT INTO xrb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Loo kur ye, Yesu n ka kungbãhã wo, tesẽ kusyĩmbɛhɛ ne, ma le kapãyĩĩ wũhũ pãã naa n yar nawee- na, kapãyĩĩ lii le Yãhã Yai wĩĩ tɔ̃r. Pe kãnyãrwai sẽnsye syãm naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ca mpãy bya pye pe naa n taha u na. Yesu ba sãndãpee kar tege kãã poo ca mpãy yĩŋ na, ma mpãy jaa pe yan na. Pe ca myar nde: Maari wii pe naa n yee Madala klofa Maari, Yesu ba sãndãpee kuasĩĩ kar tege woo cɔɔ yĩŋ na, ");
INSERT INTO xrb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tesẽ Syane ne, u puai myaha ba kẽ Susya ma pye Yɛrɔte wale yĩŋ na, tesẽ Sisane ne, ma suhu ca mpãy ne. Poo ca mii naa koho le Yesu ye u kãnyãrwai ne pe koho wãn ne. ");
INSERT INTO xrb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nawee- naa n yir kui byɛ wo, ma naa n pai Yesu fla na. U n kaplãŋ nkãy kuã cra pãã pe nabuar ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Dya waa yi u kaha wo, ma ga dir yãr u tar wo. Tuu naa ke digi yãr u tar laam wo, pii mpãy n ga too kãnde ngbeŋ na. Nawee- n tãhã tɛr pe na, kãnsyãm n maha pe wãy di kãã. ");
INSERT INTO xrb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pii mpãy n ga too ntẽmbakor fla wo. Pe pii n fĩy, ma -sẽ ta tɛr waha ku, yrĩŋ sẽ pye ke fla wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pii mpãy n ga too ngur wãn taa nsoho wo. Te ngur n fĩy wãcɛŋ te dir wãn ne, ma ba te puãr, te sẽ waha lɛ dye ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pii mpãy n -sẽ too kãntrayũhũ fla wo. Too dir wãn n yir, ma sa ma pii le gboho.» Yesu n pe yar taha ma yee: «Wii ma n traha u le yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","U kãnyãrwai n u yey u le kakuãcran yĩntaha gbihi tɔ̃r yar poo na. ");
INSERT INTO xrb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","U n pe yɛ̃ wãã sya ma yee: «Kai- nkãy nawee sẽ ke cã yãã Yãhã Yai wĩĩ na ye, Yãhã ta yii ga waha ke war. Ma -sẽ yee mpãy na, pe sẽ ke yĩntaha wãwar kɛ ye, pe ga naa ke kai- luhu kakuãcraŋ ne. Ke syi, ‹pe n waha naa n yãŋ, ngaa sẽ -sẽ ga naa n yãã ye. Pe n waha naa n luhu, laa sẽ -sẽ ga naa n war ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu n maha pe kãnyãrwai pye ma yee: «Le kakuãcran yĩntaha nde: Yãhã kaplãŋ ma mii te dir wãn dyaŋ pe yãr. ");
INSERT INTO xrb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nawee- mpãy ma pe laam plãhã mii le kãnde yɛ̃ dyaŋ, pe pii pe too na. Pe ma le Yãhã kapãyĩĩ luhu, sãndãpee yĩŋfua -sẽ ga pa, u ba ke kaplãŋ wãy yi kãã pe laam wo, pe ma syi pe ke sya pe waha sya yaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mpãy laam ma mii te ntẽmbakor fla dyaŋ. Pe ma le kapãyĩĩ luhu, pe ga le sya nuhu ne. Pe sẽ -sẽ ga tyii le na le n nii gbãã pe laam wo ye. Wãfãy ma pa, pe ga ke kaplãŋ miy yaha. ");
INSERT INTO xrb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mpãy laam ma mii pii mpãy dyaŋ, pe too ngur fla wo. Pe ma le kapãyĩĩ luhu, kayaaŋ tesẽ wale wãkɛ ne tesẽ driyɛ̃ yĩnde wãn wãkɛ ne, too nde byɛ ga ba yir tã ke kaplãŋ na, pe saa kuee le kapãyĩĩ kur ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mpãy laam -sẽ ma mii pii mpãy dyaŋ pe too kãntrayũhũ fla wo. Pe ma le kapãyĩĩ luhu, le ga pii see pe laam wo, pe laam mpãy pe sroŋ ma maha yɔ̃. Poofa ga kuee yai tãŋ le kapãyĩĩ kur ye, pe naa kayũhũ pye.» ");
INSERT INTO xrb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu n maha yee: «Waa sẽ naaloho ndyan tar ma kataŋ cĩn n tã le na ye. Le sẽ maha n tar ma le n yaha gbãngbahara flãhã tãy ye. Pe ne le wra yaha kããnkui na, wii ma dye u waha naa n yãŋ cãã- na. ");
INSERT INTO xrb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta n ye yar, ngii ngii ke wũhũ nii, ke ga ba nii gbaa na, lii nawee- sẽ le cã yãã ye, le ga ba cã. ");
INSERT INTO xrb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tee nkãy luhu, -ye ye laam yaha ke na! Wii ma waha ke war cacar, u ga ba ke war naa n gboho, wii ma -sẽ ke wãwar sye, car gii tuu yee u cã, ke ga faha u na.» ");
INSERT INTO xrb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Loo kur ye, Yesu nahafua n pa u fla na, tesẽ Yesu cĩĩfa ne. Nawee- ba nihi tɛr, pe sẽ waha nɔ u na ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pe n Yesu yar ma yee, a u nahafua ma nkur ye, tesẽ u cĩĩfa ne, pe n traha pe u yãã. ");
INSERT INTO xrb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu n -sẽ pe nawee- byɛ pye ma yee: «Mpãy pe Yãhã kaplãŋ luhu, ma maha ke laam wũhũ pye, poo pe ma ta nahafa tesẽ ta cĩĩfa.» ");
INSERT INTO xrb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Per gaa, Yesu ba dugu dye salangbãŋ gaa laam wo, woo tesẽ u kãnyãrwai ne, ma pe pye ma yee: «Waa dii tɛr kuɛ ngaa kũndi ye.» Pe n nii n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pe naa n gaha, Yesu n sã wãy. Teflahangbãŋ gaa n ta tɛr yir n fua ke langbãŋ na. Ke salangbãŋ naa n yĩĩ loho ne, kapee. ");
INSERT INTO xrb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pe kãnyãrwai n yũhũ crã Yesu tãy, ma u gbã yir ma u pye ma yee: «Yĩŋfua, Yĩŋfua, waa ku!» Yesu n yir, ma gbey ke teflahangbãŋ na tesẽ loho sẽmpĩy ne, te n yɛr. Ke fla n nii seyĩĩ. ");
INSERT INTO xrb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu n pe kãnyãrwai pye ma yee: «Ye Yatɛr wee la ye ne?» Pe -sẽ ba fya. Le n maha pe fe gbe, pe n naa pe ya pye ma yee: «Hãã, -ye naa dya nwo yãŋ, u n gbey teflaha na tesẽ loho ne, te n sya n luhu u ye.» ");
INSERT INTO xrb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Loo kur ye, pe n ga nɔ langbãŋ kuɛ ngaa kuɛ ngbeŋ na Jerasinefa kuɛ ye, Galɛlɛ kãntraha kũndi ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu tuu naa n tege kãntraha na, loo klofua waa n u yãã ma pa. Sãndãpee pye u dya yĩŋ na. Le yale wãdey, u dya sẽ naa nayrɛ le ye, u sẽ maha naa n dye nwoŋ wo ye, ma naa n nii nakur lesaha fla wo. ");
INSERT INTO xrb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tuu Yesu yãã, u n too mii na ma nii n tẽ, ma kãnklũy gbãã Yesu tãy ma yee: «Ke Yãhãngbãŋ Dya Yesu, nwa taa ga pye ra na? N ma nar, maʼa syi ra pẽn ye!» ");
INSERT INTO xrb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu naa n gbey u sãndũpee na, u tege kãã u dya yĩŋ na, koo kẽ u dya n naa koo pãã. U sãndũpee pye u ma yir u dya na, pe ga u dya pua yigi yaha, u ma n waha ka teelaa wo ye. Pe ga ntẽn namihi ta, pe u kluɛ pua u trɛ ne, u -sẽ ga ba te ntẽn namihi cɛr, u sãndũpee n u ta u n ka dragba wo. ");
INSERT INTO xrb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu n u yey ma yee: «Ma myaha mii?» U dya n yee: «Ta myaha Nihinihi.» Pe sãndãpee ba nihi u dya yĩŋ na, koo u n ba loo pãã ke syi. ");
INSERT INTO xrb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pe sãndãpee n nii Yesu nar, u ma syi u poo nɔ wãã tãã ye wãfãy fla wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kaha tyɛ- mpãy -sẽ pye ke fla na yãŋ yĩŋ na, ma kɛ naa n di. Pe ba nihi. Pe sãndãpee n Yesu nar u tyii poo n ga dye pe tyɛ- mii laam laam wo. U n le sya pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pe sãndãpee n tege kãã u dya yĩŋ na, maa dye pe tyɛ- laam laam wo. Pe n ke ngbeŋ fã tege, maa too dye ke langbãŋ laam wo ma ku. ");
INSERT INTO xrb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mpãy pe naa pe tyɛ- sẽŋ, pe yãã le pye ke dyaŋ, pe n fã tɛr maa le pãã klofa ye tesẽ wlɛfa ne. ");
INSERT INTO xrb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pe nawee- n yir ba, pe n pai yãŋ lii le pye. Pe ba nɔ Yesu tãy, pe n u dya yãã pe sãndãpee ba tege kãã u yĩŋ na. U yĩntaha ba too, u n nayrɛ le, ma tege nii Yesu tãy. Pe n fya yigi nii. ");
INSERT INTO xrb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mpãy pe ba ke kai- byɛ yãã, poo n le tɔ̃r pe nawee- ye, pe sãndãpee tege kãã u dya yĩŋ na mii syi. ");
INSERT INTO xrb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pe Jerasine klofa byɛ n nii Yesu nar ma yee, u tɛr u poo klo ta yaha. Pe tee ba fya tɛr. Yesu n dugu dye ke salangbãŋ wo, ma ga tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pe sãndãpee ba tege kãã dya wii yĩŋ na, u n nii Yesu nar woo ga kuee u ne. Yesu n u dur wãã ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Dur ga ma fla na, maa le pãã ma nna ye Yãhã ke lii pye ma kẽ.» U dya n tɛr loo na, maa le pãã pe klofa byɛ ye, lii Yesu u pye u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yaliile Yesu tuu ba yir ke langbãŋ kuɛ ngaa kũndi ye ma pa, te nabuar tii te naa u sẽŋ, te n u wãã. ");
INSERT INTO xrb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dya waa pye, pe naa n yee Syase. U pye ke fla Yiifee- yawãhã nwoŋ yĩŋfua. U n pa, maa kãnklũy gbãã Yesu tãy, ma u nar u ka woo fla na, ");
INSERT INTO xrb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ma yee pueesyale nen le ma woo ye. Le ma dyɛ- sẽnsye syãŋ syi, a le ma le kuee wale nen ma ga ku. Yesu naa n gaha ke fla na, te nabuar u waa naa n yigi kuɛ byɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te nabuar laam wo, cɔɔ waa -sẽ pye. U ntɔ̃r kuee naa n woo u ye dyɛ- sẽnsye syãŋ, wãyɛr wee ye. U wale byɛ ba ka tãŋ tyinfa ye, waa sẽ -sẽ ba waha u jaa ye. ");
INSERT INTO xrb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","U n yũhũ crã Yesu na kur kuɛ ye, maa tɛ u nayroho yɛ̃ na. Loo yalebya wo, u ntɔ̃r wãwoo n ta tɛr yɛr. ");
INSERT INTO xrb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Loo kur ye, Yesu n pe nawee- yey ma yee: «Yoo tɛ ra nayroho na?» Waa sẽ yee ndoo n le pye ye. Pyar n yee: «Ah wo Yĩŋfua, ma sẽ pe nawee- yãã la pe ma waa yigi kuɛ byɛ ye?» ");
INSERT INTO xrb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu n -sẽ yee: «Ãwã, n yee waa tɛ ra na, n yãã fãnga gaa yi ra wo.» ");
INSERT INTO xrb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","U cɔɔ tuu yãã pe cã woo kẽ, u n nii n sege fyar koho wo. U n pa loo na, maa kãnklũy gbãã Yesu yaha ye, ma le pãã nawee- byɛ yĩnde na nwa ta u n tɛ u na, tesẽ u jaa mii ke fla byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu n u pye ma yee: «Cɔɔ, taa ra ta ma Yatɛr, loo le ma jaa. Naa n gaha pra.» ");
INSERT INTO xrb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu tuu naa ngĩĩ pãã, tẽnlɛhɛle waa n yir Syase kaha wo, ma ba u Syase pye ma yee: «Ma pueesya ku, maʼa n maha naa u Yĩŋfua fãy ye.» ");
INSERT INTO xrb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu n luhu u dya kaplãŋ ne, ma Syase pye ma yee: «Maʼa n fya ye, ra ta ma Yatɛr loo ya, u -sẽ ga jaa.» ");
INSERT INTO xrb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu tuu ga nɔ ke nakugu nwoŋ na, u sẽ sya waa n dye ga u ne ye mii Pyar ye ya sẽ kẽ, Nsãn ne, Syake ne ye, tesẽ le kicaale tuhufua ne u nahafua ne. ");
INSERT INTO xrb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ke gbã kaha wo, nawee- byɛ naa n wũn ma naa fɛn le, le kicaale wĩĩ na. Yesu n pe pye ma yee: «Yaʼa n naa n wũn ye! Le sẽ ku ye, le sã wãy.» ");
INSERT INTO xrb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pe ba cã le ku wa, pe n nii u lɛr. ");
INSERT INTO xrb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu n dye ke nwoŋ wo, ma le kicaale yigi koho na, ma gbey pãã ma yee: «Kicaale yir!» ");
INSERT INTO xrb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Le kicaale yrã n dur ba le ye, le n ta tɛr yir. Yesu n pe yar, ma yee: «-Ye ngaa wãã le kẽ le n di!» ");
INSERT INTO xrb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Le kicaale wãdurba yrãŋ na, le n u seefa laam wɔ ga ta tɛr. Yesu n -sẽ pe yar waha ma yee, lii le pye pe ma syi le pãã waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu n u kãnyãrwai sẽnsye syãm yee, ma pe wãã ta ma kãnde wãã pe kẽ tesẽ fãnga ne pe waha sãndãpee kar tege naa n kãã nawee- yĩŋ na, pe maha waha naa yanfa jaa. ");
INSERT INTO xrb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tuu kãnde wãã wa pe kẽ tesẽ fãnga ne, u n pe lɛhɛ wãã, pe ga naa Yãhã Yai wĩĩ tɔ̃r naa n yar nawee- na, pe maha naa yanfa jaa. ");
INSERT INTO xrb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tuu ga pe lɛhɛ wãã, u n pe yar ma yee: «Ye ma ga ke yrãhã yi, ye ma syi ye ngaa gbe ke n naa ye ndege ye. Ye ma n kãi gɛ gbe ye, nkãnfaha ne ye, ngaa kadiŋ ne ye, war ne ye! -Ye kaleŋ naneŋ ya gbe yigi! ");
INSERT INTO xrb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pe ma syãsaha wãã ye kẽ na, -ye kuee koo kaha wo ye sya ba tɛr! ");
INSERT INTO xrb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Teelii nawee- ma sye pe saa ye yigi yɔ̃ ye, -ye tɛr pe klo yaha! Ye ma nii n tɛr, -ye ye trɛ mplẽm kor yaha pe na, pe n cã lii ma pe dye poo pe le kɛ.» ");
INSERT INTO xrb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tuu koo pãã wa pe kãnyãrwai ye, pe n tɛr. Pe naa n gaha kui byɛ wo, ma le Yãhã Yai kapãyĩĩ tɔ̃r naa n yar nawee- na, ma maha naa yanfa jaa teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yesu tuu naa kai- nkãy byɛ pye, Yɛrɔte naa ke tẽŋ luhu, u laam n wlãhã. Nawee- mpãy naa n yee, a Nsãn kẽ u dur ba yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mpãy maha naa n yee, a faale Yeli kẽ tuu u ya yi yar nawee- na. Mpãy ter maha naa n yee, a faale Yãhã kaplãŋ tɔ̃rfua waa kẽ, u dur ba yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yɛrɔte -sẽ naa le pãã ma yee: «N ta pe n Nsãn yĩŋ cɛr. Yoo -sẽ kẽ dya nwo ne, pe n sya nii kai- ngĩĩ byɛ pãã u wĩĩ na?» U n naa traha u Yesu yãã. ");
INSERT INTO xrb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu tẽnlɛhɛ n dur ba, maa u yar nkãy byɛ ne pe ga pye. U n tɛr poo ya ne, klo laa kuɛ ye pe n yee Gbesyata. ");
INSERT INTO xrb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pe nabuar n -sẽ le cã ma taha u na. Yesu n ga pe yigi ta, ma Yãhã Yai wĩĩ pãã pe ye ma maha yanfa jaa pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yai ke naa n gaha kuasaha wo, pe kãnyãrwai sẽnsye syãm n yũhũ crã Yesu na, ma u pye ma yee: «Kãnde wãã pe nabuar kẽ, pe n ka tũntũn kusyĩmbɛhɛ wo tesẽ klɛ ne, pe ga ngaa par di, pe maha syãsaha kɛ. Wo tee ma dragba wo.» ");
INSERT INTO xrb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu n pe yɛ̃ sya ma yee: «Yii gɛ, -ye digi wãã pe kẽ pe n di!» Pe n yee: «Wo ga waha pe yɛ̃ woo mii? Bur wãy bua ya te ma wo ye, tesẽ fua- syãm ya ne. Ma n traha la wo ka wo ga dir par pe nabuar mii byɛ kẽ?» ");
INSERT INTO xrb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nawee- mpãy pe pye ke fla na, pe naam ya ba nawee- nyersĩĩ yĩĩbua kua. Yesu n u kãnyãrwai pye ma yee: «-Ye pe ta pe n nii ga flɛ flɛ, nawee- gbeesãnsĩĩ sesãnsyihi.» ");
INSERT INTO xrb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pe kãnyãrwai n le sya u ye, ma pe nawee- ta pe n tege nii ga ke syi. ");
INSERT INTO xrb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu n te bur bua gbe pe fua- syãm ne, ma yĩntaha kuã yir wãã yãhãyĩŋ kuɛ ye, ma yee Yãhã n kaa taha pe na. U n dur ma te la cɛr ma te wãã u kãnyãrwai kẽ, pe n te la klaha pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pe byɛ n di, ma sya di yai. Pe n takũyĩhĩ sẽnsye syãŋ gbe tɛr te gbɛr ne, tii pe di yaha. ");
INSERT INTO xrb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Per gaa Yesu pye u ya ya, ma naa n pãã Yãhã ne. U kãnyãrwai n taha ba u na. U n pe yey ma yee: «Lii gɛ pe nawee- pe n pãã ta wĩĩ na?» ");
INSERT INTO xrb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pe n yee: «Mpãy n yee, a Nsãn nawee- tããfua kẽ ma ne. Mpãy maha n yee, a faale Yeli kẽ ma ne, mpãy maha ma pe n yee, a faale Yãhã kaplãŋ tɔ̃rfua waa kẽ ma ne tuu dur ba yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu n pe yey ma yee: «Ah yii, ye yee yoo kẽ ra ne?» Pyar n u yɛ̃ sya ma yee: «Mboo kẽ u Yãhã Yĩndefua Crise.» ");
INSERT INTO xrb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Loo na, Yesu n pe kãnyãrwai yar waha ma yee, pe ma syi pe u wĩĩ pãã waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","U n maha pe pye ma yee: «U Nawee Puee yai u fãy gboho. Pe Yiifee- wãlɛ ga ba u wĩĩ sye, tesẽ pe Yãhã yũndefa yĩŋfa ne, tesẽ pe Yãhã kaiyarfa ne. Pe ga ba ta gɛ ta pe n u boo. U wãku plii tãã wuhu na, u ga yir gbã wo, u dur ba yrãŋ na gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Loo na, Yesu n pe nawee- byɛ pye ma yee: «Wii ma yee woo ga naa n yãr ta kãnde wo, u u laam wũhũ ta yaha, -tuu u ya gbihi naa n ta plii byɛ, u ma sya ga ba gbãpee ku ra wĩĩ na. Wii ma loo sya, u naa ra kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ye sẽ yãã, wii tuu u ya yĩŋ kɛ, ma suhu u laam wãn ne, woofua ga ba too byɛ kɛ laa; wii tuu -sẽ ga le sya u u yĩŋ kɛ laa, ma suhu u laam wãn ne ndoo wĩĩ na, woofua kẽ tuu cã ga ba too nde byɛ yãã. ");
INSERT INTO xrb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mboo nawee, taa ga driyɛ̃ wãn byɛ yãã tãŋ, maʼa -sẽ ba yãã ma plaha mii ya, ma sẽ maha ba ma yĩŋ yãã Yãhã ye ye, le wãyĩĩ -sẽ ma na taa yãã? ");
INSERT INTO xrb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nawee wii ma yee ta wĩĩ fyar yigi woo kẽ tesẽ ra kaplãŋ ne, u wĩĩ bya ga ba fyar yigi ndoo u Nawee Puee kẽ yaliile n n pai dur ba ra nayɔ̃r ne, ta Tuhufua Yãhã nayɔ̃r ne, tesẽ pe yãhãyĩŋ tẽnlɛhɛyɔ̃m nayɔ̃r ne.» ");
INSERT INTO xrb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yesu n maha pe yar taha ma yee: «Ta n cĩĩnde nde pãã ye ye: Nawee- mpãy ma ye laam wo, pe saa ku mii pe sẽ Yãhã Yai yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu tuu kaplãŋ ngĩĩ pãã wa, plii kuasĩĩ syi n tɛr, u n Pyar yigi taha u ya na, Nsãn ne, tesẽ Syake ne. U n ka pe ne yãŋ gaa yĩŋ na, u n gaha pãã Yãhã ne. ");
INSERT INTO xrb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tuu ga nii n pãã Yãhã ne, u yĩntaha n wã klaha, u nayrɛ n flege ma sya n yɛhɛ palpal. ");
INSERT INTO xrb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Naam syãm mpãy n fe gbe yi yãhãyĩŋ nayɔ̃r ne. Faale wãlɛ syãm ba me, Musa ma suhu Yeli ne. Yesu tuu ga ba ku mii syi dyaŋ Yurusalɛm wo, tuu pa lii myaha na kãntraha na le n pye tãŋ, loo pe naa n pãã Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pyar tesẽ u nampyeŋ- ne, pe ba sã wãy faha. Pe n yir, ma Yesu yãhãyĩŋ nayɔ̃r yãã, tesẽ pe naam syãm ne pe yir yɛr u ne. ");
INSERT INTO xrb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Yaliile pe naam syãm pe naa n tɛr Yesu yaha, Pyar n Yesu pye ma yee: «Wo Yĩŋfua, wo niisaha sroŋ yɔ̃ nwo wo! Waa kajar tãã gbã, neŋ ma wãŋ, neŋ Musa wãŋ, neŋ nge Yeli wãŋ.» U ba le pãã ke dyaŋ, u sẽ laam ga ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tuu naa koo pãã, yãhãsyɔ̃r raa n yi nii ma yĩm paha tã pe byɛ na. Pe kãnyãrwai pe te yãhãsyɔ̃r yãã te pe gbey le, pe n fya. ");
INSERT INTO xrb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yãhã yĩmbui n yi te yãhãsyɔ̃r laam wo ma yee: «Ta Dya kẽ nwo ne, woo kẽ tẽ yãŋ yi. -Ye naa n luhu u ye!» ");
INSERT INTO xrb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Loo kapãn le pãã wa, pe kãnyãrwai n Yesu nen ya yãã ke fla na. Pe kãnyãrwai n ke kai- byɛ yaha le. Koo cãã na, pe sẽ laa pãã waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ke yĩŋsyii wo, pe n tege ke yãŋ yĩŋ na, nabuar raa n pa maa Yesu wãã. ");
INSERT INTO xrb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dya waa n kuee pe nabuar laam wo, ma gbey pãã wãã Yesu ye ma yee: «Yĩŋfua, n ma nar, ta dya yãŋ ta kẽ, ta dyapuai nen ya. ");
INSERT INTO xrb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sãndũpee ma u yĩŋ na, ma n yir u na tugutugu. U ma yir u na, u ga u ta u n naa n kui, tuu naa u yɛhɛ fãnga ne, tuu u ta u n naa yɛ̃syɔ̃play yi. U sãndũpee ma yir u na, u ga u nuhu gboho ke syi tuu cã ba u miy yaha. ");
INSERT INTO xrb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N ma kãnyãrwai nar pe u sãndũpee kar tege kãã u na, pe sẽ waha yia ye.» ");
INSERT INTO xrb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu n kuãn pe na ma yee: «Yii poo na, laanyɔ̃m wee ye ye ye, ye sẽ ra ta ye Yatɛr ye. Ye yee la n kuee ye wãwlaha na yalebyɛ? Ye yee la n naa n fãy ye ne yalebyɛ?» U n u kicar tuhufua pye ma yee: «Pa ma dya ne nwo wo!» ");
INSERT INTO xrb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","U kicar tuu yũhũ naa n pai, u sãndũpee n u yãr gbe miy kãntraha na ma u yɛhɛ fãnga ne. Yesu n sã waha u sãndũpee na, ma u kicar jaa ma u wãã u tuhufua kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pe nawee- byɛ pe Yãhã fãngangbãŋ yãã ke syi, le n pe laam wɔ ma sya ta tɛr. Nawee- pe naa Yesu tẽŋ tẽ u kai- wĩĩ na, u n u kãnyãrwai pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Yii poo na, n ga laa pãã ye ye, -ye le le yaha ye laam wo: U Nawee Puee ga yi u napĩĩ- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pe kãnyãrwai sẽ -sẽ naa ke kaplãŋ ngĩĩ war u ye ye. Le kapãn ba pãã ke syi, pe ma n waha le tɛrsaha cã ye. Pe ba fya Yesu na, pe sẽ u yey le kapãn tɛrsaha ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu kãnyãrwai n ba sãnkɛr kɛ pe ya nsoho wo, ma ga cã yoo woo u ma yĩŋ na poo laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu n -sẽ pe laam wĩĩ cã. U n kicaalaale gbe ba ta u yahasee ye, ");
INSERT INTO xrb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma pe pye ma yee: «Wii ma kicaale nde syi gbihi yigi ndoo myaha na, ndoo gɛ kẽ tuu gbihi yigi. Wii ma -sẽ ra gbihi yigi, Yãhã gɛ kẽ tuu gbihi yigi, koo gii ke ra lɛhɛ wãã. Wii ma -sẽ u ya ta ma nii ye byɛ kurkuɛfua, woo tuu ma yĩŋ ye byɛ na.» ");
INSERT INTO xrb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nsãn n kapãn gbe ma yee: «Wo Yĩŋfua, wo dya waa yãã tuu sãndãpee kar tege n kãã nawee- yĩŋ na ma myaha ne. Wo n ba yee u wee wo ne ye, ma u kar tã.» ");
INSERT INTO xrb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu n u yɛ̃ sya ma yee: «Yaʼa n sye u na ye. Ye sẽ yãã, wii ma yee u sẽ ye laha ye, u ma ye ne.» ");
INSERT INTO xrb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu tɛrper yãhãyĩŋ na ke ba nɔ gbe naa n taha, u n u laam waha ma yee u yai u ka Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","U n tẽnlɛhɛ mpãy nɔ wãã u yahasee ye, pe n ka Syamarifa kãntraha klo laa wo, pe n gaha fla ngaa gbihi ta u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pe klofa n sye ma yee, u tee n gaha Yurusalɛm wo, poo saa syãsaha wãã u kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","U Yesu kãnyãrwai syãm mii Syake tesẽ Nsãn ne, pe ba le luhu ke dyaŋ, pe n Yesu pye ma yee: «Yĩŋfua, le ma tãy ma ye, waa naa ta ke n yir yãhãyĩŋ na, ke ba too tã pe na ke pe suhu muu.» ");
INSERT INTO xrb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu n wã klaha pe kuɛ ye, ma loo kuãn pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pe n tɛr klo laa ter wo. ");
INSERT INTO xrb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesu tesẽ u kãnyãrwai ne, pe pye kãnde wo ma naa n yãr. Dya waa n pa, maa Yesu pye ma yee: «Yĩŋfua maʼa sya n gaha teelii teelii, n ga naa n taha ma na.» ");
INSERT INTO xrb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu n u yɛ̃ wãã sya ma yee: «Yɛ̃srɛ̃ ma te syãsar ne, kãnsyãm ma pe nsɛŋ ne, teele sẽ -sẽ wee u Nawee Puee myaha na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","U n dya waa pye ma yee: «Naa n taha ra na.» U dya n u pye ma yee: «Yĩŋfua, kãnde wãã ra kẽ, n ma ga ra tuhufua nakugu le wa, n ga pa.» ");
INSERT INTO xrb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu n u yɛ̃ sya ma yee: «Tyii nakur na te n naa re nakurwai le. Mboo, ka maa naa Yãhã Yai wĩĩ yar nawee- na!» ");
INSERT INTO xrb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dya waa n maha Yesu pye ma yee: «Yĩŋfua, ndoo ga naa n taha ma na, -taa -sẽ kãnde wãã ra kẽ, ra n ka n ga ra nna yar, tẽ dur ba.» ");
INSERT INTO xrb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu n u pye ma yee: «Wii ma nii mii wii dyaŋ u nii tar war yar ne, ma maha nii yãŋ n klaha u kur kuɛ ye, woofua saha laa yɔ̃ Yãhã Yai wĩĩ na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Loo kur ye, Yĩŋfua Yesu n maha nawee- gbeetãã sẽnsye syãm yãŋ yi. Kui nkãy byɛ tesẽ teebɛhɛ nkãy byɛ tuu naa n traha u ka, u n poo nawee- mii cãã lɛhɛ wãã sãnsyãm koo kui wo tesẽ koo teebɛhɛ ne. ");
INSERT INTO xrb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","U n pe yar kakuãcraŋ nkãy ne ma yee: «Dir busãã ma wãgbe wãn tar wo. Tẽntẽfa sẽ -sẽ syar yai, ma ga waha te byɛ gbe dye tãŋ kaha wo ye. -Ye u tarfua nar u n tẽntẽfa busãã mpãy nɔ wãã, pe n ba te dir gbe dye kaha laam wo u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","-Ye naa n gaha, n ye lɛhɛ wãã mii mbapĩy dyaŋ waygapyãr nsoho wo. ");
INSERT INTO xrb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ye ma syi ye war gbe ye, nkãnfaha ne ye, ntãy ne ye. Ye ma n taha kuee naa nawee- syar kãnde wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yaʼa ga dye kaha gii laam wo, ye cãã syaha nge syar ye yee: Yãhã ke yrĩŋ le kaha nge wo. ");
INSERT INTO xrb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Waa ma pye ke fla na Yãhã yrĩŋ ne, ye yrĩŋ syaha nge ga kuee u na. Le ma -sẽ pye woosyifua sẽ kẽ ye, ye syaha nge saa laa yɔ̃ u kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","-Ye kuee koo kaha wo, pe ye kẽ loho gii ne, -ye ke wɔ, pe ye kẽ digi gii ne, -ye ke di! Tẽntẽfua yai pe naa u dãã. Ye ma syi ye yi kaha gaa wo, ye ga dye kaha gaa laam wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Yaʼa ga dye klo lii wo pe n syãsaha wãã ye kẽ, pe ma pa ye kẽ digi gii ne, -ye ke di! ");
INSERT INTO xrb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","-Ye naa loo klo yanfa jaa, -tee naa pe nawee- yar Yãhã Yai nɔ wa gɛ nɔ wa. ");
INSERT INTO xrb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yaʼa -sẽ ga dye klo lii wo, pe ma yee pe saa syãsaha wãã ye kẽ ye, -ye ka yaa le pãã nanihi fla wo ye yee: ");
INSERT INTO xrb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Ye klo tẽyãhã mplẽm mpãy gɛ pe yir too wo trɛ na, wo mii wo poo mplẽm mii kor yaha ye na. -Tee -sẽ le cã ye yee Yãhã Yai pa wa ye ye.› ");
INSERT INTO xrb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta n le pãã ye ye, Yãhã kasãhã per ma ba nɔ, le ga ba pee klo ndefa na le tɛr Sodɔ̃ klofa yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu n kuãn kui raafa na ma yee: «Korasyifa, ye wĩĩ pee Yãhã ye! Gbesyatafa, ye wĩĩ pee Yãhã ye! Laanwɔ wũhũ nkãy ke pye ye yĩnde na, ke syi ma ne pye faale Tyirfa yĩnde na, tesẽ faale Syidɔ̃fa ne, pe ne ga pye pe ta tɛr le cã kãã wa le yalebya wo, pe kapee- wãpyeŋ sẽ yɔ̃ ye. Loo nde na, pe ne ga wram wĩĩ pye, pe nfããper ta, pe fɛn nayrɛ pãhã pe le. ");
INSERT INTO xrb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Loo ne, Yãhã kasãhã per ma ba nɔ, le ga ba pee ye na le ta tɛr pe Tyirfa yaha, tesẽ pe Syidɔ̃fa ne. ");
INSERT INTO xrb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ah yii Kapornufa, ye yee la pe ga ba ye kuã yir ga ta yãhãyĩŋ na? Ye ma n naa loo gɛ ga ye laam wo ye! Ye ga ba tege ga ta tãã ye nakur fla wo.» ");
INSERT INTO xrb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu n maha u kãnyãrwai pye ma yee: «Wii ma n luhu ye ye, ke nii mii u n luhu ndoo gɛ ye. Wii ma ye wĩĩ sye, ke nii mii ndoo gɛ wĩĩ kẽ tuu sye. Wii ma -sẽ ndoo wĩĩ sye, ke nii mii wii u ra lɛhɛ wãã woofua wĩĩ kẽ tuu sye.» ");
INSERT INTO xrb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pe nawee- gbeetãã sẽnsye syãm n dur ba laanfir ne, ma ba nii le pãã nuhu ne ma n yee: «Wo Yĩŋfua, sãndãpee gɛ n luhu wo ye, waʼa gbey pe na ma myaha ne!» ");
INSERT INTO xrb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu n pe yɛ̃ wãã sya ma yee: «Yalaale wo, n naa u Setane yãã yãhãyĩŋ kuɛ ye, tuu tege naa n too mii yãhãyĩŋ dyaŋ ke yɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","-Ye luhu yɔ̃ ra ye: N fãnga wãã ye kẽ ye waha naa n yia nwɔr na tesẽ sãnam ne, ye tãhã naa n tɛr te na. N fãnga wãã ye kẽ ye waha yia ye napĩĩ Setane na, ye u fãnga byɛ pye klaha- tãŋ, ngaa ma n waha kapee pye ye na ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sãndãpee n luhu ye ye, loo yɔ̃, le sẽ -sẽ nɔ nuhu wãdi na ye. Ye myar te yrũhũ ta wa yãhãyĩŋ saba laam wo, -ye naa nuhu di loo ne!» ");
INSERT INTO xrb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Loo yalebya wo, Yãhã Yrã Fãnga n Yesu laam yĩĩ nuhu ne, u n yee: «Ta Tuhufua Yãhã, mboo taa ma yãhãyĩŋ Yĩŋfua tesẽ kãntraha ne. Lii taa sẽ yar kaicãfa na, tesẽ sabacãfa ne ye, ma loo yar mpãy na pe ma pra kicar wãŋ syi dyaŋ. N ma sey loo wĩĩ na. Ãwã Tuhufua, le tãy ma ye, koo kẽ ma n le ta ke dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu n dur ma pe nawee- pye ma yee: «Ta Tuhufua Yãhã kai- byɛ le soho ra koho wo. Nawee- sẽ cã yoo kẽ ra ne ye. Ta Tuhufua ya ke le cã. Pe sẽ maha cã yoo kẽ ra Tuhufua ne ye. Ndoo ya n ke cã, tesẽ mpãy ne tẽ ke yar pe na.» ");
INSERT INTO xrb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Loo na, Yesu n wã klaha u kãnyãrwai kuɛ ye, ma poo ya pye ma yee: «Yii, tee nii lii yãã yagaa, ye wĩĩ n tãy, -ye naa nuhu di loo ne! ");
INSERT INTO xrb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta n ye yar nde ne: Nkãy byɛ tee n yãã yĩnde ne, tesẽ nkãy byɛ ne tee n luhu ndityɛ ne, Yãhã kaplãŋ tɔ̃rfa busãã pye tesẽ kui yĩŋfa busãã ne, pe naa n kɛ pe kai- ngĩĩ syi yãã yĩnde ne tesẽ pe ke yãã luhu ndityɛ ne, pe sẽ -sẽ ke yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yãhã kaiyarfua waa n ba yir ma yee woo ga Yesu le namihi wo, ma u yey ma yee: «Yĩŋfua, n ga pye mii n waha cĩĩnde yrã yãã, lii wãkuayãã wee le na ye?» ");
INSERT INTO xrb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu n u yɛ̃ sya ma yee: «Kãnde lii Yãhã le ta, le yãŋ! Lii ne le yrũhũ yaha loo wĩĩ na? Ma lii war le na?» ");
INSERT INTO xrb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","U dya n yee: «Lii le yrũhũ ta le nde: ‹Ta, Yĩŋfua Yãhã wĩĩ n naa n tãy ma ye, le tɛr wãn byɛ yaha; le gboho tãŋ ma laam byɛ wo, le nii tãŋ ma yrã byɛ na, ma fãnga byɛ ne, ma kacãn byɛ n pye tãŋ loo na.› Tesẽ: ‹Ma ya wĩĩ le n tãy ma ye mii syi dyaŋ, tyii ma nampyeŋ wĩĩ n naa n tãy ma ye ke syi.› » ");
INSERT INTO xrb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Loo na, Yesu n u pye ma yee: «Ma le pãã yɔ̃. Maʼa loo nde pye, ma -sẽ ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","U Yãhã kaiyarfua -sẽ naa n traha u tãhã wãã u ya kẽ. U n Yesu yey ma yee: «N ga waha wii syi yee ra nampyeŋ?» ");
INSERT INTO xrb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu n u yɛ̃ sya ma yee: «Dya waa ba yir Yurusalɛm wo, ma Yerekɔɔ kãnde sya ma tege naa n tɛr. Yuhu- mpãy n ga u yãã kãnde laam wo, ma wɔ toho u na ma u yuhu, ma u nayrɛ tyĩn cɛr u na ma u gbã cããr yaha. ");
INSERT INTO xrb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yãhã yũndefua waa n yir u ya ndoŋ, ma tege n tɛr loo kãnde nen ya ne. Tuu ga u dya yãã, u n laha yi, ma ga le kãnde wãã sya ma tɛr, u sẽ yɛr gɛ yɛr ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Loo kur ye, Lewi kur kuɛ puee waa n ba yir u ya ndoŋ. U n ba nɔ ke fla na, ma u dya yãã. U n laha yi, ma ga le kãnde wãã sya ma tɛr, u sẽ yɛr gɛ yɛr ye. ");
INSERT INTO xrb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Syamarifa naa waa -sẽ ba yrãhã yi u ya ndoŋ. Yiifee- sẽ pe Syamarifa yãŋ ngaa ye. U bya naa n tɛr loo kãnde nen ya ne. U n ba nɔ u dya na, ma u yãã pe u duai yaha. Tuu u dya yãã ke syi, u fɛn n u sroŋ yigi fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U n yũhũ crã u dya na, ma u nar yee u kẽ defĩĩ ne, ma re tuhu sẽm- ne, ma dur ma re pua u kẽ. U n dur loo na ma u gbe taha u kãnkoŋ na, ma tɛr u ne nampay syãsaha fla wo ma ga u gbihi. ");
INSERT INTO xrb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ke yĩŋsyii wo, u n war yi ma wãã u nwoŋfua kẽ, ma u pye ma yee: ‹Naa u dya gbihi ra kẽ. Maʼa sya u gbihi ma ta tɛr war mii draha yaha tẽ wãã ma kẽ, n ma ba dur ba nwo, n ga ba pe war draha dãã ma kẽ.› » ");
INSERT INTO xrb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Loo na Yesu n dur, ma u Yãhã kaiyarfua yey ma yee: «Ma laam wo, wii woo tuu nii u dya nampyeŋ, dya wii pe ba gbã cããr yaha kãnde wo?» ");
INSERT INTO xrb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","U Yãhã kaiyarfua n Yesu yɛ̃ wãã sya ma yee: «Wii tuu yɔ̃ u na, woo tuu sroŋ ma u nampyeŋ.» Loo na, Yesu n u pye ma yee: «Ka, ma ga naa n pye koo syi!» ");
INSERT INTO xrb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ye naa n yãr kãnde wo, u kãnyãrwai ne. Pe n ba laha dye kusyĩnde laa wo. Cɔɔ waa n pe wãã ma pe yigi ga u kaha wo, woo n gaha pe nampay yi. U cɔɔ myaha ba kẽ Marti. ");
INSERT INTO xrb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U cĩĩfua pye u ne, pe naa u yee Maari. Yesu naa le Yãhã kapãyĩĩ tɔ̃r pe ye, u Maari woo n ba tege nii u tãy ma nii ke kaplãŋ luhu. ");
INSERT INTO xrb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marti woo -sẽ pye tuu ba dye kuee tẽŋ laam wo. U n ba Yesu pye ma yee: «Yĩŋfua, ma sẽ yãã ta cĩĩfua ra ta yaha nii ya ke tẽŋ laam wo, le yɔ̃ la? Ma saa u yar la u ba koho le ra ye?» ");
INSERT INTO xrb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu n u yɛ̃ wãã sya ma yee: «Yãŋ, Marti! Ma laam wlãhã nii ma ye, ma n nii n gber kai- busãã na. ");
INSERT INTO xrb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Katɛ nen ya -sẽ ne le ma yĩŋ. Maari ka le wãyĩĩ kuɛ ye. Le saha tyĩn sya kãã u ye ye.» ");
INSERT INTO xrb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Per gaa, Yesu naa n pãã Yãhã ne teelaa wo. Tuu ba nar wa, u kãnyãrwai waa n u pye ma yee: «Wo Yĩŋfua, wo klaha Yãhã wãnar ne, mii Nsãn dyaŋ tuu u kãnyãrwai klaha le ne mii.» ");
INSERT INTO xrb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu n pe yar ma yee: «Ye ma ga Yãhã nar, -ye yee: ‹Wo Tuhufua Yãhã, ta, nawee- n cã ma miingbãŋ kai- laha. Ta, ma Yai n pa nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Naa wo yɛ̃ digi wãã wo kẽ plii wuhu na. ");
INSERT INTO xrb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wo kapee- gbe kãã wo yĩŋ na. Mpãy pe kapee- pye wo na, wo bya wo n tyii pe kapee- foho na wo kuãŋ ne. Maʼa n wo miy yaha, wo n tyĩn naa n gaha kapee- wãpyeŋ kuɛ ye ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu n maha pe yar ma yee: «Laa na, ye laam wo, waa ma naambiyã ne. Per gaa, u ga yir u ka u naambiyã fla na yĩndyaha wo, u ga u pye: ‹Naambiyã, bur wãy tãã fuɛ le ra na. ");
INSERT INTO xrb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ta naambiyã nen waa yir yrãhã ye, ma pa ra fla na, ngaa wee tẽ ga wãã u kẽ ye.› ");
INSERT INTO xrb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","U naambiyã nwo ga waha kuee nwoŋ laam wo, u pãã yi wãã u kẽ u u pye: ‹Tyii ra na dya, ma sẽ yãã nwonyɛ̃ gbãã tã wa karndohopua ne. Ma sẽ cã la, wo sã wãy wa ta pii ne. N wee n ga waha yir n bur gbe wãã ma kẽ ye!› » ");
INSERT INTO xrb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesu n pe yar taha ma yee: «Ta n le pãã ye ye: Pe sya nii naambiyãm, nen nwo ga waha sye u saa yir ye. U nkurfua ma -sẽ naa tã u nwoŋfua na, ma nii u yee u kadye ga ba war, u n yir, u nwonyɛ̃ yãr, u te wãn byɛ gbe wãã u naambiyã kẽ, tii wĩĩ te ma u na. ");
INSERT INTO xrb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Koo kẽ n ga ye yar nde ne: -Ye naa n nar, ngaa ga wãã ye kẽ. -Ye naa n kɛ, yaa ngaa yãã. -Ye naa kããnklihi gbã, pe ga ke yãr ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ye sẽ yãã, mboo nawee, maʼa n nar, Yãhã ga ngaa wãã ma kẽ. Maʼa n kɛ, Yãhã ga ta ma ngaa yãã. Maʼa kããnklihi gbã, Yãhã ga ta ke n yãr ma kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ye ma pye tuhufua, ye dyale ma fuale nar ye ye, yaa u kẽ la nwoho ne? ");
INSERT INTO xrb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Laa na, u ma ngucĩĩ nar ye ye, yaa u kẽ la sãnuɛ̃ ne? ");
INSERT INTO xrb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tee sya pee mii, ye kayũhũ pye ye pii kẽ. Ke syi ne, ye yai ye cã, ye Tuhufua Yãhã ga Yãhã Yrã Fãnga wãã mpãy kẽ pe le nar u ye.» ");
INSERT INTO xrb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sãndũpee pye dya waa yĩŋ na, ma u ta u n nii bebe. Yesu n u kar tege kãã u dya yĩŋ na. U sãndũpee n tege kãã u dya yĩŋ na, u nii n pãã gbɛgbɛ. Le n yɛ̃ gbãã pe nabuar na ma sya ta tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mpãy n yir ma yee: «Sãndãpee yĩŋfua Sebulɛhɛ kẽ tuu fãnga wãã u kẽ, u n waha sãndãpee kar tege n kãã nawee- yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mpãy ter n yee, poo ga u le namihi wo, ma u pye ma yee, tuu yɛ̃kã wĩĩ laa pye poo n yãã yĩnde ne, pe cã cã Yãhã fãnga kẽ ke ma u ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu -sẽ ba pe laam wĩĩ cã wa. U n pe yar ma yee: «Kãntraha neŋfa ma kuee n wãã pe ya ne, koo kãntraha nge ga too. Kaha neŋfa ma kuee n wãã pe ya ne, koo kaha ga too. ");
INSERT INTO xrb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ke syi ne, Setane ma kuee n wãã u ya ne, u fãnga saa waha ka yahasee ye ye, ke ga klaha-. Ye -sẽ yee, n sãndãpee kar tege n kãã nawee- yĩŋ na, sãndãpee yĩŋfua Setane kẽ tuu koo fãnga wãã ra kẽ! ");
INSERT INTO xrb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cĩĩnde sẽ ne ye. Mii loo sẽ ne ye, ye nampyeŋ- mpãy pe sãndãpee kar n tege, ye ma yee pe bya loo pye Setane fãnga kãmay na, poo gɛ ga ye yar pe yee, cĩĩnde sẽ ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta n ye yar, n sãndãpee kar tege n kãã Yãhã Fãnga ne. Loo na, ye yai ye cã Yãhã Yai pa wa ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Fãngafua ma pye naanmiy wãn ne ma nii u kaha sẽŋ, nawee waa saa sɛr u kla gaa gbe ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Waa ter ma -sẽ pa, woo fãnga ma tɛr nwo wãŋ na, u n yia u na, u ga u naanmiy wãn byɛ tyĩn sya u ye, tii tuu ba ta ma naa u ya paha. Loo na, u ga u kahafua nwo koho wãn byɛ gbe u ye, u te la u nampyeŋ- ne. ");
INSERT INTO xrb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wii ma yee u wee ra ne ye, woofua ma ra napĩĩ. Tesẽ, wii ma yee u saa koho le ra ye, u nawee- wãã ba ra kẽ ye, woofua u pe kar n kãã ra na. ");
INSERT INTO xrb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sãndũpee ma pye nawee yĩŋ na ma ba tege kãã u na, u sãndũpee ga ka drawaha fla wo, u ga tay naa n klaha, u ma teelaa yãã u nii naa n wũũ. U ma yee u sẽ teelaa yãã ye, u ga yee tuu tɛr u niisaha gii yaha, u ga dur ga nii ke fla na. ");
INSERT INTO xrb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Loo na, tuu pye nawee wii yĩŋ na ma ba tege kãã u na, u ga dur ga u fla na. U n gaha u nawee laam yãã mii nwoŋ dyaŋ pe ke pɛ ma ke gbihi ta. ");
INSERT INTO xrb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Loo na, u sãndũpee ga yir, u ga u nampyeŋ- kuasĩĩ mpãy yigi ba, mpãy pe maha pee woo na. Pe byɛ ga pe ya wãã ba nii u nawee yĩŋ na. U nawee wĩĩ ga pee, le ta tɛr faale yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu tuu ba koo pãã wa, cɔɔ waa n kuee pe nabuar laam wo, ma u pye ma yee: «Cɔɔ wii tuu ma see ma maha u yrã ta ma kẽ, u wĩĩ n tãy.» ");
INSERT INTO xrb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu n -sẽ u yɛ̃ wãã sya ma yee: «Mpãy pe Yãhã kapãyĩĩ luhu, ma maha Yãhã kãnde yãr, poo wĩĩ le n tãy!» ");
INSERT INTO xrb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nawee- wɔ naa n tã Yesu na, u n nii pe pye ma yee: «Yagaafa pee, ma -sẽ yee poo n traha pe laanwɔ wĩĩ laa yãã yĩnde ne. Aye, laanwɔ wĩĩ laa saa pye ye n yãã yĩnde ne ye, mii lii syi sẽ kẽ le bii faale Yãhã kaplãŋ tɔ̃rfua Yonase dye ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ye sẽ yãã, mii Yonase wĩĩ bii nii kayar wĩĩ faalefa Nenefufa ye mii, u Nawee Puee wĩĩ bya ga ba nii kayar wĩĩ yagaafa ye koo syi. ");
INSERT INTO xrb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Yãhã kasãhã per ma ba nɔ, faale Syeba kãntraha yĩŋfasya ga ba le pãã u yee, yagaafa pe sẽ koho klaha ye, pe tee pye. Woo bii yir deydey kui wo, ma pa faale yĩŋfua Salmuu fla na ma ba u kacãyor luhu. Kaplãŋ nkãy tẽ -sẽ n pãã ye ye, ke tɛr Salmuu wũhũ yaha! ");
INSERT INTO xrb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yãhã kasãhã per ma ba nɔ, pe faale Nenefufa ga ba le pãã pe yee, yagaafa pe sẽ koho klaha ye, pe tee pye. Faale wo, Yonase bii Yãhã yɛ̃ kapãn pãã pe Nenefufa ye, pe n le luhu ma koho klaha ma pe kapee- wãpyeŋ miy yaha. Kaplãŋ nkãy tẽ -sẽ n pãã ye ye, ke tɛr Yonase wũhũ yaha!» ");
INSERT INTO xrb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu n maha yee: «Waa sẽ naaloho ndyan tar ma ga le wũhũ teelaa wo ye, waa sẽ maha le tar ma kataŋ cĩn n tã le na ye. Ah ndee, pe ma le tar, pe ne le wra ta kããnkui na, wii ma dye u naa n yãŋ cãã- na. ");
INSERT INTO xrb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yĩnde ma mii naaloho dyaŋ kadye na. Ma yĩnde ma yɔ̃ ma ye, ma kadye byɛ ga nii cãã- na; ma yĩnde ma -sẽ klaha- ma ye, ma kadye byɛ ga nii wam wo. ");
INSERT INTO xrb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Loo na, nawee woo yai u u ya yigi, cãã- mpãy pe ma u na, wam ma syi pe sya tãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ke syi ne, nawee kadye byɛ ma nii cãã- na, teelaa sẽ wee wam wo ye, u kadye kur byɛ ga nii tãŋ cãã- na, ke naa n yɛhɛ palpal mii naaloho cãã- dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu tuu ba pãã wa, Farisyɛ̃ naa waa n u yee u ga di u kaha wo. Yesu n dye ke kaha wo, maa nii ma ga di. ");
INSERT INTO xrb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","U Farisyɛ̃ naa n ba yãã Yesu sẽ u kluɛ yee pe wãlɛ kãnde na ye, ma nii n di, le n u fe gbe. ");
INSERT INTO xrb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Loo na, Yĩŋfua Yesu n u pye ma yee: «Yii Farisyɛ̃, ye ma mii nawee- mpãy dyaŋ pe crãŋ kur kuɛ yee, tesẽ tasa kur kuɛ ne, ma n tyii ke laam na. Ye byɛ ye yii ta naweeyɔ̃m nkur kuɛ ye, ye laam sẽ -sẽ wee gbɛgbɛ ye. Nawee- wãyuhu wĩĩ ya le ma ye laam wo, tesẽ kapee- wãpyeŋ ne. ");
INSERT INTO xrb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ye plege, ye sẽ kai- cã ye! Yãhã gii ke nkur kuɛ pye, koo neŋ ya sẽ na ke laam bya pye? ");
INSERT INTO xrb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","-Ye ye crãŋ yĩĩ kayũhũ ne, tesẽ ye tasa bya ne, ye ke wãã nawãm kẽ, loo na ye kãnkai- byɛ ga cã nii gbɛgbɛ. ");
INSERT INTO xrb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Yii Farisyɛ̃, ye wĩĩ pee Yãhã ye! Ye ma ne ye digi gbe, le tãy ke nii waŋ kla woo, tyũhũ wãŋ woo, ye ne ke la flɛ sẽnsye, ye fla neŋ wãã Yãhã kẽ. Ma -sẽ yee ye wãsroŋ wĩĩ na, tesẽ Yãhã wĩĩ wãtãy ne ye laam wo, ye kalaa wee koo na ye. Koo -sẽ kẽ tee yai ye gbihi yigi, ye koo ta yĩŋ. Ke kai- ngĩĩ n -sẽ taha, ye ma syi ye faha laa yaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Yii Farisyɛ̃, ye wĩĩ pee! Yiifee- yawãhã nwey wo niisar rii nawee- byɛ yĩnde le yi n too re na, too syi niisar ye ne kɛ ye nii. Ye tee maha n yãŋ pe naa ye syar nangbãsyaha ne nanihi teebɛhɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ye wĩĩ pee! Ye laam wluhu, ye ma mii nakur gbũhũ nkãy syi dyaŋ nawee saa cã ye, u tãhã naa n tɛr te na!» ");
INSERT INTO xrb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yãhã kaiyarfua waa n u pye ma yee: «Yĩŋfua, taa nii n pãã ke syi, ma wo bya wãã le n tyɛhɛ.» ");
INSERT INTO xrb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu n u yɛ̃ sya ma yee: «Yii Yãhã kaiyarfa, ye bya wĩĩ pee! Ye nawee- taha kai- nkãy na ke ma mii teger dyaŋ pe saha tẽŋ ye. Ye saa maha koho le pe ye, pe n waha re tẽŋ ye. ");
INSERT INTO xrb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ye wĩĩ pee! Gbũhũ nkãy syi ke yɔ̃, ye ne koo fãã Yãhã kaplãŋ tɔ̃rfa kẽ, poo mpãy ye wãlɛ pe boo! ");
INSERT INTO xrb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Le nii mii ye wãlɛ pe lii pye, le tãy ye ye. Poo pe Yãhã kaplãŋ tɔ̃rfa boo, yii -sẽ pe gbũhũ fãã! ");
INSERT INTO xrb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Loo ne, Yãhã gii ke kai- byɛ cã tãŋ, ke n le yar yaha ye wĩĩ na ma yee: ‹N ga ba ra kaplãŋ tɔ̃rfa mpãy nɔ wãã pe ye, tesẽ ra tẽntẽfa mpãy ne. Pe ga ba mpãy boo pe laam wo, pe mpãy nar- gboho.› ");
INSERT INTO xrb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ke syi ne, ma gbe driyɛ̃ wãtãhã na, ma ba waa ke yagaa na, Yãhã kaplãŋ tɔ̃rfa mpãy byɛ pe boo tɛr, yagaafa ga ba loo kapee fuɛ dãã. ");
INSERT INTO xrb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Too naboor nde bii gbe Abɛl wãboo cãã na, ma sya ba waa Dyakaridya wãboo cãã na, woo wii pe bii u boo ke Yãhã kangbãŋ nsoho wo, ke Yãhã diŋ yisaha fla ne. Ãwã, cĩĩnde ne tẽ n pãã ye ye, ntɔ̃r rii te woo, le kapee fuɛ ga yi yagaafa na. ");
INSERT INTO xrb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yii Yãhã kaiyarfa, ye wĩĩ pee! Lii le ga waha nawee ta u n Yãhã wĩĩ cã, yii gɛ le sye, ma -sẽ maha yɛr tã le na nawee- ma n le yãã ye. Ye ma mii nawee waa dyaŋ u nwoŋ gaa yɛ̃ gbãã tã ma sye u karndohopua na.» ");
INSERT INTO xrb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yaliile Yesu tuu ba yi ke kaha wo, pe Yãhã kaiyarfa tesẽ pe Farisyɛ̃ ne, pe n nii ncafũhũ di u ne, ma nii u yey kai- ter byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pe naa n kɛ pe Yesu ta u n plaha pãã pe n luhu. ");
INSERT INTO xrb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Loo yale wo, nabuar n ba wɔ tã ma sya pe ya trɛ tãhã, Yesu n cãã u kãnyãrwai pye ma yee: «-Ye yii yigi Farisyɛ̃ ye ne, pe wĩĩ ma mii ncasur wãŋ ter syi dyaŋ. Pe naweeyɔ̃m pyer pye gbaa na, pe laam wo ma -sẽ pee. ");
INSERT INTO xrb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ngii ngii ke wũhũ nii, ke ga ba yãã gbaa na. Kai- nkãy ke maha ma waa sẽ ke cã ye, ke ga ba cã. ");
INSERT INTO xrb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Loo ne, kaplãŋ nkãy tee n pãã yii ya yĩmperwoho wo, ye ga ba naa ke pãã nawee- byɛ ye yaiwaha na. Tesẽ, lii byɛ tee yuhu pãã waa ndityɛ wo, nwonuŋ laam wo, le ga ba gbey pãã nanihi fla wo.» ");
INSERT INTO xrb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesu n maha yee: «Ta n le pãã ye ye, yii mpãy tee ma ra naambiyãm: Mpãy syi pe ga waha nawee kadye boo wãboo ya, pe sẽ -sẽ ga waha laa pye nantãŋ ye, ye ma syi naa poo fya ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wii tee yai ye naa n fya, n ga u yar ye na: Ye yai ye naa Yãhã koo fya, koo gii ye ma ba ku, ke ga waha ye le naa fla wo, naa gii wãfegeyãã wee ke na ye. Ãwã, n le pãã ye ye, ye yai ye naa koo ya fya! ");
INSERT INTO xrb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kãnsyãyi mii syi wãm bua sẽ n par la warpii syãm ya ne? Ye cã poo kãnsyãyi mii wee ngaa ye, Yãhã sẽ -sẽ n faha poo nen waa gɛ yaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ye wĩĩ n tãy Yãhã ye, ma tɛr kãnsyãyi mii syi wãbuar yaha. Ye yĩnyor nde gɛ Yãhã te byɛ yɛ̃ cã yaha wa. Ye ma syi naa n fya laa na ye!» ");
INSERT INTO xrb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesu n maha yee: «Ta n nde pãã ye ye: Wii ma le pãã nawee- yĩnde na ma yee woo u ya le soho ra koho wo, ndoo u Nawee Puee, ta bya ga ba le pãã pe Yãhã yãhãyĩŋ tẽnlɛhɛ yĩnde na n yee, woofua ma ra wũũ. ");
INSERT INTO xrb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wii ma -sẽ le pãã nawee- yĩnde na ma yee woo sẽ ndoo cã ye, ta bya ga ba le pãã pe Yãhã yãhãyĩŋ tẽnlɛhɛ yĩnde na n yee, n sẽ woofua cã ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nawee wii ma tee pãã u Nawee Puee wĩĩ na, Yãhã ga ba loo kapee laha kãã u yĩŋ na. Wii ma -sẽ tee pãã Yãhã Yrã Fãnga wĩĩ na, loo kapee nde saa laha kãã u yĩŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pe ma ba ye yigi ga Yiifee- yawãhã nwey wo, laa na yahaseefa yahasee ye, laa na fãngafa yahasee ye, ye ma syi ye fya ye! Ye ma syi ye naa ntãŋ cɛr, ye yee tee ga ba lii pãã le n nii wãyĩĩ, tesẽ tee ga ba lii pãã ye waha ye yĩŋ yi yaha, ye sẽ cã ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Loo yale wo, kaplãŋ nkãy ke yai ke yi ye yɛ̃ wo, Yãhã Yrã ga ye klaha ke ne.» ");
INSERT INTO xrb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dya waa pye pe nabuar laam wo, ma ba Yesu pye ma yee: «Yĩŋfua, ta lɛfua yar, u tyii wo n wo tuhufua kloho la wii na.» ");
INSERT INTO xrb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu n u yɛ̃ sya ma yee: «Naambiyã, yoo u ra taha ye nwoŋ kai- wãsãhã na, tesẽ ye koho wãn wãlaŋ na ye nsoho wo?» ");
INSERT INTO xrb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","U n wã klaha, ma pe nawee- byɛ pye ma yee: «-Ye yii yigi, ye ma n pua yaha wale wĩĩ na, tesẽ nangbãn wãn ne ye. Nawee koho wãn sẽ ne te ga waha ta u n kuee yrãŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Loo na, Yesu n kakuãcran pãã pe ye ma yee: «Nangbãŋ gaa pye tangbãn ne, dir n ba yi u ye kacãn sẽ pye ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","U n nii laam ga ma yee: ‹N ga pye mii, dir nde byɛ lesaha wee ra ye ye.› ");
INSERT INTO xrb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","U n ba u ya pye ma yee: ‹Tẽ ga lii pye, n le cã yagaa. Loo ne nde: N ga ra mplɛ nde yoho kãã, n dur n taa fãã, tii te cã gboho faale wãn na, n ta dir wãn byɛ le yaha te laam wo ta koho wãn byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","N ma loo pye wa, n ga dur n nii yar n yee: Naambiyã, diyɔ̃r ma ma ye kacãn wee ye, te ga waha ta ma di yai dyɛ- buar. Yagaa, fĩhĩ nii naa n wũũ, ma naa n di ma naa n wɔ, -taa naa nuhu di.› ");
INSERT INTO xrb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Yãhã n -sẽ u dya pye ma yee: ‹Naplege nge! Yĩmper nge gɛ laam wo, ma ga ku. Taa ga ku, dir nde byɛ taa gbihi ta ma myaha na, te ga nii yoo wãn yagaa?› » ");
INSERT INTO xrb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Loo na, Yesu n maha le pãã taha ma yee: «Wii woo na tuu driyɛ̃ nangbãn wãn ya kɛ wãã n ta u ya myaha na, u sẽ -sẽ wee ngaa nangbãŋ Yãhã ye ye, woofua wĩĩ ma mii ke nangbãŋ naplege nge wĩĩ dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Loo kur ye, Yesu n u kãnyãrwai pye ma yee: «Loo ne, n ga ye yar nde ne: Dir rii tee ga naa n di, tesẽ loho gii ne tee ga naa n wɔ ye waha nii yĩnwɛr na, tesẽ nayrɛ rii ne tee ga le tã ye kadye na, ye ma syi ye naa ntãŋ cɛr too nde byɛ wĩĩ na ye! ");
INSERT INTO xrb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ye sẽ yãã, yĩnwɛr puar dir na, kadye puar nayrɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","-Ye naa kãnsyãm yãŋ, pe sẽ digi tãhã, pe sẽ digi gbe, teelaa wee pe ye pe dir kɔ̃ŋ n yaha ye. Yãhã sẽ pe yɛ̃ digi wãã la pe kẽ? Ye wĩĩ n tãy Yãhã ye, ma tɛr kãnsyãm yaha. ");
INSERT INTO xrb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ye laam wo, yoo ma u ga waha u kuper yũhũ wãã carle gɛ laangar ya kãmay na? ");
INSERT INTO xrb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ye ma gblihi laa ndele syi ya wãpyeŋ na, lii tee -sẽ laam ga ke kai- ngĩĩ wĩĩ na? ");
INSERT INTO xrb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nyɛ̃ fyãr te n fĩy tar wo, ye sẽ te nayɔ̃r yãã la? Te sẽ tẽn tẽ ye, te sẽ faha wãn tyĩn ye. Ta n -sẽ le pãã ye ye, u faale yĩŋfua Salmuu, u nangbãn naa byɛ ne, u nayrɛ nayɔ̃r sẽ -sẽ bii nɔ nyɛ̃ fyãr wãŋ neŋ gaa gɛ nayɔ̃r na ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nyɛ̃ nge gɛ ke n fĩy tar wo nanga, koo gii pe n pai miy le wãã naa laam wo sukũhũ, Yãhã nayɔ̃r wãã ke kẽ. Ke -sẽ ga pye mii ke tyii yii gɛ na, ke saa nayrɛ wãã ye kẽ ye? Ye sẽ koho taha yaha Yãhã na busãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ye ma syi ye naa ntãŋ cɛr, ye yɛ̃ digi wãkɛ ne tesẽ ye lawɔŋ ne ye! ");
INSERT INTO xrb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nawee- mpãy pe sẽ cĩĩnde Yãhã cã ye, poo pe too nde byɛ kɛ fãnga ne. Ma -sẽ yee yii na, Tuhufua Yãhã ma ye ye, ke cã te wĩĩ ma ye na. ");
INSERT INTO xrb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","-Ye cãã Yãhã Yai wĩĩ kɛ wa! Loo na, ngii wĩĩ ke ma ye na, ke -sẽ ga ba wãã taha ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yii mpãy tee sẽ nihi ye, ye ma syi ye fya ye! Le tãy ye Tuhufua Yãhã ye, loo ne u n ye le Yãhã Yai wo. ");
INSERT INTO xrb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","-Ye ye koho wãn par, -tee pe war wãã nawãm kẽ! Wale lii syi le sẽ n klaha ye, -ye naa loo kɛ! -Ye Yãhã wũhũ kɛ naa n ta busãã yãhãyĩŋ wo, koo fla gii wãplaha wee te na ye, yuhu saha nɔ te na ye, fyãr saha te pye klaha- ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tee ye laam wãn ta na, ye laam byɛ ma koo fla na.» ");
INSERT INTO xrb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu n maha yee: «-Ye yii gbihi ra tẽn wĩĩ ne, -ye ye nsĩĩ cɛr pua, -ye ye naaloho tar yaha! ");
INSERT INTO xrb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","-Ye yii gbihi mii tẽntẽ- mpãy dyaŋ pe yĩŋfua ka cagbar na. U ma dur ba ke kapahayɛ̃ gbã, pe yir ga ke yãr u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","U yĩŋfua tuu ga dur ba tẽntẽ- mpãy yãã yrãŋ na, poo wĩĩ n tãy! U ga u ya gbihi, u pe ta pe n tege nii, u n ba dir la klaha pe byɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","U ma dur ba yĩndyaha wo, le tãy yĩndyaha kur ye, ma ba u tẽntẽ- yãã yrãŋ na, pe wĩĩ n tãy. ");
INSERT INTO xrb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","-Ye nde cã laha: Kahafua ma ne u yuhu payale cã, u ga ne kuee yrãŋ na, u sye u yuhu ma n dye u kaha wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye bya -ye yii gbihi naa n ta, yaliile tee sẽ ga yigi ye, u Nawee Puee ga ba dur ba loo yale wo.» ");
INSERT INTO xrb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pyar n ba le pãã ma yee: «Yĩŋfua, ma kaplãŋ ngĩĩ kuã cra pãã wãã wii ya kẽ laa, ma ke pãã nawee- kur byɛ kẽ?» ");
INSERT INTO xrb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu n u yɛ̃ sya ma yee: «Tẽntẽle wii syi kẽ u n sroŋ u yĩŋfua ye, ma maha kai- cã? Woo kẽ wii ne u yĩŋfua tɛr ma u taha u naa ke kaha yãŋ, tuu naa u tẽntẽwai byɛ yãŋ, u naa pe dir wãã pe kẽ sediyale wo. ");
INSERT INTO xrb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","U yĩŋfua ma dur ba, maa u yãã loo tẽn na, woo tẽntẽle wĩĩ n tãy. ");
INSERT INTO xrb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta n cĩĩnde nde pãã ye ye. U yĩŋfua ga u taha u koho wãn byɛ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","U tẽntẽle ma -sẽ le ga yigi, a woo yĩŋfua saa pa yagaa ye, u ga too u tẽntẽwai wãgbãŋ na, u naa dir ya di, u naa sẽm wɔ pe n u yigi. ");
INSERT INTO xrb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","U tẽntẽle tuu sẽ per gii ga yigi ye, u yĩŋfua ga pa koo per na. U ga u pẽn cĩĩnde wãpẽn, tuu u pye pyer rii ne te yai mpãy ne pe sẽ sroŋ ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tẽntẽle wii tuu u yĩŋfua laam wĩĩ cã, u sẽ -sẽ u ya gbihi ye, u sẽ -sẽ u yĩŋfua laam wĩĩ pye ye, u ga ba gbãr sya busãã. ");
INSERT INTO xrb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma -sẽ yee tẽntẽle wii tuu sẽ u yĩŋfua laam wũhũ cã ye, u ma sya tee pye ma yai gbãr ne, u ga gbã car ya. Yãhã ma wii kẽ busãã, ke ga ba ufua yey kai- busãã ne. Yãhã ma kai- busãã le soho wii koho wo, ke ga ba woofua yey kai- busãã ne ke n sya gboho tɛr.» ");
INSERT INTO xrb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu n maha yee: «N pa nawee- wãcɛr naa ne kãntraha na. Koo naa nge ma ne pye ke le wa, le ne ga tãy ra ye. ");
INSERT INTO xrb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","N ga ba tãã fɛn laam wo, ta laam byɛ n wlãhã nii. Loo n ba pye wa, ta laam n cã tege nii. ");
INSERT INTO xrb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ye laam wo, ye yee la n pa nawee- yĩmbuhu wããlesaha wo? Aye rɛhɛ, n pa pe wãcɛr wĩĩ loo ne. ");
INSERT INTO xrb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ma gbe yagaa na, nwoŋ giifa ma pye nawee- bua, nawee- tãã ga wãã le, pe cɛr nawee- syãm mii na. Kaa na, nawee- syãm ga wãã le, pe cɛr nawee- tãã mii na. ");
INSERT INTO xrb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tuhufa ga ba napĩr le pe dyam ne, dyam -sẽ ga ba napĩr le pe tuhufa ne. Nahafa ga ba napĩr le pe pueesyam ne, pueesyam -sẽ ga ba napĩr le pe nahafa ne. Nansyam ga ba napĩr le pe pii ca ne, pii ca -sẽ ga ba napĩr le pe nansyam ne.» ");
INSERT INTO xrb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu maha naa pe nawee- yar ma yee: «Ye ma sesaha yãã ke wɔ ke pakuɛ ye, ye sẽ ne yee la, ke ga pa? Ke n -sẽ pa cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ye ma tefay yãã pe yir yãhãyĩŋ kãndigi koho kuɛ ye ma fua n pai, ye sẽ ne yee la kar ga war? Le n -sẽ pye cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Dawarfa me ye ne! Tee waha yãhãyĩŋ wũhũ yĩntaha war, tesẽ kãntraha wũhũ ne, Yãhã wũhũ nkãy ke -sẽ n pye ye yĩnde na yagaa, nwa ta ye n koo wãwar wĩĩ sye? ");
INSERT INTO xrb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tee ga lii pye le n sroŋ, nwa ta ye n loo sye? ");
INSERT INTO xrb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wii ma yee ma laa tee pye, ma ma yigi n gaha kasãhã saha wo, tee sẽ nɔ wa ke fla na ye, cãã naa u nar ye n wãã le. Mii loo sẽ ne ye, u n gaha ma le soho u kasãhãfua koho wo, woo n ma le soho fãngafa koho wo, pe n ma le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta n le pãã ma ye: Maʼa yee ma sẽ le kafuɛ byɛ dãã tãŋ ye, ma saa yãã yi ke nwompihi wo ye.» ");
INSERT INTO xrb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Per gaa, nawee- mpãy n pa Yesu fla na, ma ba Galɛlɛfa mpãy wĩĩ pãã u ye. Pe Galɛlɛfa ka Yãhã kangbãŋ laam wo, u fãngafua Pilati n ta pe n pe boo wlãhã pe kaboo wãn ne. ");
INSERT INTO xrb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu n pe yɛ̃ sya ma yee: «Galɛlɛfa mii pe boo, ye laam wo ye yee la, poo pye kapeepyefa ma ta tɛr Galɛlɛ kãntrahafa byɛ yaha? ");
INSERT INTO xrb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ye bya ma -sẽ yee, ye sẽ le sya ye kapee- sẽ yɔ̃, ma maha ke wãpyeŋ miy yaha ye, ye byɛ wĩĩ ga ba klaha-. ");
INSERT INTO xrb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ye yai ye ye laam too nwonjruhu gii na ke pye Syilwee wo, ma ba too tã nawee- sẽnsye kuatãã na, pe n ku. Ye laam wo ye yee la, poo pye kapeepyefa ma ta tɛr Yurusalɛm klofa kur byɛ yaha? ");
INSERT INTO xrb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ye bya ma -sẽ yee, ye sẽ le sya ye kapee- sẽ yɔ̃, ma maha ke wãpyeŋ miy yaha ye, ye byɛ wĩĩ ga ba klaha- koo syi.» ");
INSERT INTO xrb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu n maha kakuãcraŋ pãã pe ye ma yee: «Dya waa ba nasar nkugu katyigi sĩĩ kãntrayũhũ fla wo, ke n lɛ. U dya n pa u n pai nkugu tai, u sẽ ngaa yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","U n te tar gbihifua pye ma yee: ‹Yãŋ, ke dyɛ- tãã kẽ yagaa, n ma pa n pai nkugu tai katyigi nge na, n saa ngaa yãã ye. Ke cɛr kãã! Ke tee nii ma draha ka sya, ke sẽ n sa ye.› ");
INSERT INTO xrb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","U tar gbihifua n u yɛ̃ sya ma yee: ‹Yĩŋfua, maha tyii ke na naandyɛ; n ga ke yĩŋ tugu klaha, n nafuhu le ke tãy. ");
INSERT INTO xrb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ke syi ne, laa na ke ga ba sa dyɛ laa; ke maa yee ke sẽ maha sa ye, ma ta ke n cɛr.› » ");
INSERT INTO xrb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kanii per gaa na, Yesu pye u maha naa nawee- klaha Yiifee- yawãhã nwoŋ gaa laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Cɔɔ waa -sẽ pye ke fla na, u sẽ pye korkor ye. Ke dyɛ- sẽnsye kuatãã ba kẽ sãndũpee waa pye, u ba u cɔɔ ta u n kur nii, u saha kãntuhu sroŋ ye. ");
INSERT INTO xrb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu tuu u cɔɔ yãã, u n u yee ba, ma ba u pye ma yee: «Cɔɔ, ma yan ma miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu n koho taha u na, ke kãntuhu n ta tɛr sroŋ u ye, u n nii Yãhã sey. ");
INSERT INTO xrb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesu tuu maha nawee jaa kanii per wo ke syi, le sẽ tãy u Yiifee- yawãhã nwoŋ yĩŋfua ye ye. U n kapãn gbe, ma pe nabuar pye ma yee: «Plii kuay ma, nawee yai u tẽn tẽ too plii na. -Ye naa too plii yãŋ, ye naa n pai ye yan wãjaa wĩĩ na, tee ke kanii per yãã ye ke ta yaha!» ");
INSERT INTO xrb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yĩŋfua Yesu n u yɛ̃ wãã sya ma yee: «Dawarfa me ye ne! Kanii per na, ye sẽ ne ye naha sãhã la, laa na ye kãnkoŋ, ye ka ke ne lawɔsaha wo? ");
INSERT INTO xrb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ah cɔɔ nwo wii tuu -sẽ ma Brama kur waa, Setane tuu pua yigi yaha dyɛ- sẽnsye kuatãã, ye yee la woo ma syi u sãhã yaha kanii per na u sãndũpee namihi wo ye?» ");
INSERT INTO xrb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu kapãn nde n nii u napĩĩ- ye fyar wĩĩ. Laanwɔ wũhũ nkãy tuu naa n pye, ke -sẽ naa nuhu yigi pe nabuar kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Loo na, Yesu n maha pe nawee- yar kakuãcraŋ ne ma yee: «N ga waha Yãhã Yai wĩĩ tɔ̃r nwa ne? Ke ngii tay, n ga ke kla yar ye na. ");
INSERT INTO xrb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ke ma mii ngaa puale dyaŋ, dya waa tuu gbe, ma tãhã le kãntraha wo u lankua wo. Loo puale kloŋ tãŋ pii byɛ na. Le -sẽ fĩy ma jruhu katyigi dyaŋ, kãnsyãm n sya ba pe nsɛŋ ta te kayay laam wo.» ");
INSERT INTO xrb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu n maha yee: «N ga maha ye yar Yãhã Yai ma mii syi dyaŋ? ");
INSERT INTO xrb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yãhã Yai wĩĩ maha ma mii ncasur wãŋ ter syi dyaŋ, cɔɔ waa tuu gbe carle ya, ma wlãhã bur miy busãã wo gbengbeyĩhĩ tãã syi, ma pe tũhũ. Te ncasur carle ya n ta pe n sya fua yir.» ");
INSERT INTO xrb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu naa n gaha Yurusalɛm wo. Tuu naa n tɛr kungbãhã nkãy wo, tesẽ kusyĩmbɛhɛ nkãy ne, u nawee- klaha naa n gaha too byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Waa n ba u yey ma yee: «Yĩŋfua, nawee- mpãy pe n pai sya yaha pe dye Yãhã fla wo, pe saa syar ye, cĩĩnde sẽ na?» Yesu n u yɛ̃ sya, ma pe yar ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Yãhã fla wãdye wĩĩ waha mii nwonyɛ̃ gii dyaŋ ke fĩhĩ. -Ye yii waha ye dye koo ne! Ta n ye yar, nawee- busãã ga ba yee poo ga dye, pe -sẽ ga ba gblihi laa. ");
INSERT INTO xrb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Koo nwonyɛ̃ nge kahafua ma ba yir, ma ke nwonyɛ̃ gbãã tã, yaa ba yii yãã nkur ye, ye naa ke kããnklihi gbã ye yee: ‹Yĩŋfua, nwonyɛ̃ yãr wo kẽ!› U ga ye yɛ̃ sya u yee: ‹N sẽ ye yisaha cã ye.› ");
INSERT INTO xrb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Loo na, yaa u pye ye yee: ‹Wii me too wãã naa n di ma ne, ma maha wãã naa n wɔ ma ne. Ma naa nawee- klaha wo klo wo, nanihi teebɛhɛ wo.› ");
INSERT INTO xrb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","U ga maha ye pye u yee: ‹N sẽ ye cã ye kapeepyefa mii, ye ma n crã ra na ye!› ");
INSERT INTO xrb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Loo yale wo, ye ga ba faale wãlɛ Brama ye yãã, Yãhã yai klo wo, tesẽ Yisyake ne, Dyakuba ne, ma suhu pe faale Yãhã kaplãŋ tɔ̃rfa byɛ ne. Yii -sẽ ga ba pye nkur ye, ye naa n wũn wãwũn, ye laam ga ba war ye n sya naa nkãhã gbã! ");
INSERT INTO xrb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nawee- ga ba yir yaidar kuɛ ye, tesẽ ke dyetɛr kuɛ ye, tesẽ kãntraha teebɛhɛ byɛ wo, pe pa Yãhã Yai gbar na, pe ba dir di. ");
INSERT INTO xrb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Loo na, mpãy pe ma kur ye yagaa, poo mpãy ga ba yahasee fla yãã. Mpãy pe -sẽ ma yahasee fla wo yagaa, poo mpãy ga ba nii kur ye.» ");
INSERT INTO xrb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Loo yale wo, Farisyɛ̃ mpãy n yũhũ crã Yesu na, ma u pye ma yee: «Tɛr kãã, ka fla ngaa na. Yɛrɔte n traha u ta pe n ma boo.» ");
INSERT INTO xrb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu n pe yɛ̃ sya ma yee: «-Ye ka, yaa kacãmpuai nwo yar ye yee: Ta tẽn ne kãntraha nge na sãndãpee wãkar ne, yanfa wãjaa ne. N ma le na nanga tesẽ sukũhũ ne, le tẽn n sya ba kua. ");
INSERT INTO xrb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","N yai n ta tɛr ta yrãhã ne nanga, sukũhũ, n sya ga nɔ. Ye sẽ yãã, Yãhã kaplãŋ tɔ̃rfua sẽ yai pe u boo kulaa wo mii Yurusalɛm sẽ kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesu tuu naa pe Yurusalɛmfa wĩĩ pãã, pe fɛn n u yigi, u n yee: «Yurusalɛmfa, Yurusalɛmfa, ye Yãhã kaplãŋ tɔ̃rfa boo, tesẽ nawee- mpãy Yãhã pe nɔ n wãã ye ye, ye pe waa n boo ntẽmbar ne! Yalebyɛ, n n kɛ n ye wãã ta nii tãy, mii nguyĩŋ dyaŋ ke ke pii wãã n ta ke nkaasyir flãhã tãy. Ye sẽ -sẽ le sya yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tee n pye ke syi Yãhã ga ba kur waa ye klo na. Ta n ye yar: Ye saa ra yãã mii per gii sẽ kẽ, tee n pai naa n yee: ‹Mboo wii taa n pai Yĩŋfua Yãhã myaha na, ke kaa taha ma na.› » ");
INSERT INTO xrb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kanii per gaa maha wo, Yesu ba ka Farisyɛ̃ ye yĩŋfua waa kaha wo. Pe ba u yee dir na ke fla na. Mpãy pe pye ke fla na, pe naa Yesu yãŋ kayi ne, ncã u ga pye mii laa? ");
INSERT INTO xrb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dya waa ba yɛr u yahasee ye. Yan pye u dya na, u n ba tẽ. ");
INSERT INTO xrb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu n kapãn gbe, ma pe Farisyɛ̃ yey tesẽ pe Yãhã kaiyarfa ne ma yee: «Kãnde lii Yãhã le ta, wo yai wo yanfua jaa kanii per wo laa, wo sẽ yai wo le syi pye ye?» ");
INSERT INTO xrb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pe n yaha le, pe sẽ sya ma laa wãã sya ye. Loo na, Yesu n u yanfua yigi ma u jaa, ma kãnde wãã u kẽ u n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesu n dur yagaa, ma pe nawee- pye ma yee: «Ye laam wo, waa dya ne too dye u ye kualaŋ laam wo, laa na naha syi, ufua saa u yi la le yalebya wo, le ma sya pye kanii per?» ");
INSERT INTO xrb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Loo kapãn nde na, pe ga u yɛ̃ sya lii ne pe sẽ cã ye, ma yaha le. ");
INSERT INTO xrb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dir disaha wo, nawee- mpãy pe ba yee ba te dir na, pe byɛ naa niisayɔ̃r kɛ. Yesu tuu pe yãã, u n kakuãcran nde pãã pe ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Nawee ma ma yee, taa ga fãn di casyar na, maʼa ka, maʼa n ga ke niisayũhũ yãŋ ma nii ye. Maʼa ga nii koo syi fla wo, laa na pe ma pe nawee waa ter yee te dir na, wii syi tuu tɛr ma yaha ma maha ma yĩŋfua waa. ");
INSERT INTO xrb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wii tuu ye yee ba, mboo tesẽ woo ne, u ga waha pa u ba ma pye: ‹Dya, ah ma saa ke niisayũhũ wãã la u kẽ?› Ma -sẽ ga yir te fyar ne, maa nii kur kuɛ niisaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Maʼa yãã pe ma yee ke syi fla na, maʼa ka, cãã ga nii kur kuɛ niisaha wo. Ke syi ne, wii tuu ma yee ba, u ma ba ma yãã, u ga ma pye: ‹Naambiyã, yir ba nii yahasee ye niisayũhũ fla na.› Taa yir ga wãã nii mpãy ne, pe ga nagboho ta ma na. ");
INSERT INTO xrb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ye sẽ yãã, nawee wii ma u ya ta yĩŋfua draha wo, ufua ga kloŋ. Wii ma -sẽ u ya kloŋ, ufua ga ta yĩŋfua draha wo.» ");
INSERT INTO xrb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dya wii tuu ba Yesu yee ba te dir na, Yesu n wã klaha ma u yar ma yee: «Maʼa ga nawee- yee dir na, maʼa n ma naambiyãm yee ye, tesẽ ma nampyesey ne ye, tesẽ ma nwoŋfa ne ye, tesẽ ma niisahafa mpãy ne pe ma walefa ye. Mii loo sẽ ne ye, pe ga waha yia pe le dur ma kẽ. Kayĩĩ lii raa yee ma pye, le n kua kãã. ");
INSERT INTO xrb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maʼa ga nawee- yee dir na, ma naflam poo yee, tesẽ mpãy ne pe kadye sẽ ke ya kua ye, tesẽ tãnklahafa ne, ma suhu fũũ- ne. ");
INSERT INTO xrb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Poo mii pe saha le dur ma kẽ ye, ma wĩĩ n tãy. Yãhã ga ba ma dãã per gii kasroŋ pyefa ga ba yir gbã wo, pe nii yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mpãy pe naa n di, pe kaplãŋ ngĩĩ luhu wa, poo nen waa n Yesu pye ma yee: «Wii tuu ga ba u dir lay yãã te yãhãyĩŋ gbar wo, u wĩĩ n tãy!» ");
INSERT INTO xrb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu n kakuãcran nde pãã u ye ma yee: «Dya waa ba per gaa yar nabuar raa ye, dingbãn wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te sedi yale n ba nɔ, u n u tẽntẽle lɛhɛ wãã u ga pe nawee- yar, te wãn byɛ pye wa, pe pa. ");
INSERT INTO xrb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","U ma ga wii yãã, ufua ga naa yor raa ter pãã. U tẽntẽle tuu ga cãã dya wii yar, u dya n u pye ma yee: ‹Dya, n ma n tar raa par nii kẽ, fĩhĩ tyii ta n ga te fla yãŋ. Ye ma n tege ra na ye.› ");
INSERT INTO xrb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Waa ter n yee: ‹N ma n tawar nyer sẽnsye par nii kẽ, fĩhĩ tyii ta n ga re pye yãŋ. Ye ma n tege ra na ye.› ");
INSERT INTO xrb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Waa ter n maha yee: ‹N ma n cɔɔ sya yagaa, n wee n ga yãã ka ye.› ");
INSERT INTO xrb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","U tẽntẽle n dur ga, maa ke kaplãŋ tɔ̃r u yĩŋfua ye. U yĩŋfua laam n war, u n u tẽntẽle pye ma yee: ‹Ka le klo teebɛhɛ wo, tesẽ te nanihi fla ne, maa naflam yee ba, tesẽ mpãy ne pe kadye sẽ ke ya kua ye, tesẽ fũũ- ne, ma suhu tãnklahafa ne.› ");
INSERT INTO xrb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","U tẽntẽle n ka, ma dur ba u yĩŋfua pye ma yee: ‹Yĩŋfua, taa lii pãã, n le pye. Niisar raa -sẽ maha ma te kuee› ");
INSERT INTO xrb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","U yĩŋfua n u tẽntẽle pye ma yee: ‹Ka klo kãnkãy wo tesẽ tar kãnkãy ne, maa nawee- ta pe n ba dye, ta kaha n yĩĩ.› » ");
INSERT INTO xrb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yesu n pe nawee- pye ma yee: «Ta n ye yar, mpãy pe ba cãã yee, poo saa too dir nde yãã di ye.» ");
INSERT INTO xrb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Loo kur ye, nabuar naa n yãr Yesu ne, u n ba wã klaha, ma pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Wii ma yee u ga taha ra na u kuãŋ ne, ta wĩĩ yai le naa n gboho u laam wo, le ta tɛr u tuhufua wĩĩ na, u nahafua wĩĩ ne, u cɔɔ wĩĩ ne, u pii wĩĩ ne, u nampyesey wĩĩ ne, tesẽ u ya wĩĩ gɛ ne. Mii loo sẽ ne ye, u saha nii ta kãnyãrwɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wii ma cã u saha wãfãy sya ra wĩĩ na u sya gbãpee ku ra kur ye ye, ufua saha nii ra kãnyãrwɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ye laam wo ye cã, wii ma yee u ga nwongbãŋ fãã, kii syi ke jruhu, u ga cãã tege nii, u yãŋ ke nwongbãŋ wãfãã dir ga war yɛ̃ gii kua, u waha cã poo war yɛ̃ ma ga waha yãã u ye, ke tẽŋ byɛ n waha kua. ");
INSERT INTO xrb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mii loo sẽ ne ye, u ma cãã koo nwongbãŋ nakũy ta, war n ba kloŋ u ye, ke nwongbãŋ sẽ fãã kua ye, mpãy pe loo yãã, pe ga naa u lɛr. ");
INSERT INTO xrb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pe ga yee: ‹-Ye naa n yãŋ dya nwo ne, u nwoŋ wãfãã tẽn fe gbe, ma ba gblihi laa, le tẽn sẽ kua u ye ye.› ");
INSERT INTO xrb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tesẽ, yĩŋfua waa ma yee u ga naan miy yĩŋfua waa ne, u ga cãã tege nii, u le fla yãŋ wa. Tuu ma naan miyfa nawee- nyerbua ya ne, u ga yãŋ, u ma ga waha yigi u nampyeŋ yĩŋfua nwaa ye, tuu -sẽ ma naan miyfa nawee- nyersẽnsye ne, u ga cã. ");
INSERT INTO xrb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","U ma -sẽ cã, u saha yigi u nampyeŋ yĩŋfua nwaa ye ye, u ga cãã nawee- lɛhɛ wãã u ye, pe n ga u crã tã, pe u yey pe ga waha pye mii ke wãhã n kua pe nsoho wo.» ");
INSERT INTO xrb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Loo na Yesu n pe pye ma yee: «Yii waa saha nii ra kãnyãrwɛ mii u sẽ cãã tyii u koho wãn kur byɛ na ye. ");
INSERT INTO xrb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ye sẽ tetege yãã? Tetege ma kayũhũ. Ke ma -sẽ sar, le kua. Waa saha ke ta ke n dur naa n tãy ye. ");
INSERT INTO xrb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Loo yale wo, ke saha kãntraha gbihi, ke saha le nafuhu wo ye. Pe n gaha ke miy wãã nkur ye nafẽnteŋ na. Wii ma n traha u ke yĩntaha cã, u luhu yɔ̃!» ");
INSERT INTO xrb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pe kufar wããfa, tesẽ mpãy ne pe naa kãmpee- yãr, pe byɛ naa n crã Yesu na, ma ba naa u kaplãŋ luhu. ");
INSERT INTO xrb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Le sẽ naa n tãy pe Farisyɛ̃ ye, tesẽ pe Yãhã kaiyarfa ne ye, pe n sya le wlũhũ naa n pãã pe ya ye ma yee: «Dya nwo n tãy kãmpee- yãrfa ne, ma sya wãã n di pe ne.» ");
INSERT INTO xrb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu n pe yɛ̃ sya kakuãcran laa ne ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Mbaa gbeebua syi ga waha pye waa ye ye laam wo. Nen ya ga waha plaha pe wo. Ufua saa pe mbaa gbeeresyar sẽnsye kuaresyar mii ta yaha la nyɛ̃ wo, u ga nen nwo kɛ wii tuu plaha, u sya u yãã? ");
INSERT INTO xrb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U ma u yãã, le ga tãy u ye. U ga u mbua gbe taha kãmayĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","U ga ka kaha wo, u u naambiyãm yee, tesẽ u niisahafa ne, u pe pye: ‹-Ye naa nuhu di ra ne, ta mbua wii tuu ba plaha ra ye, n u yãã.› » ");
INSERT INTO xrb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu n pe yar taha ma yee: «Ta n ye yar, le ma ke syi yãhãyĩŋ wo. Yãhãyĩŋfa nuhu dir ne gboho nawee nen wĩĩ na, wii tuu u kapee- wãpyeŋ miy yaha ma dye kãnyĩĩ wo, ke tɛr nawee- gbeeresyar sẽnsye kuaresyar mpãy yaha, pe n yee poo ma naweeyɔ̃m, kapee- wãmiyaha wee pe na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu n maha kakuãcran laa pãã pe ye ma yee: «Cɔɔ waa ma pye war sẽnsye syi ne, warpua nen ya ne plaha u ye, u saa naaloho tar la, u ke nwoŋ pɛ, u u warpua tay kayi ne u sya ga u yãã? ");
INSERT INTO xrb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","U ma u yãã, u ga u cabiyãm yee ba, tesẽ u niisahafa ne, u pe pye: ‹-Ye naa nuhu di ra ne, ta warpua wii tuu ba plaha ra ye, n u yãã.› » ");
INSERT INTO xrb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu n maha le pãã taha ma yee: «Kapeepyefua nen ya ma yi kãã u kapee- wo, ma kãnyĩĩ gbe wãfuɛ̃, loo nde ga nuhu yigi yãhãyĩŋ tẽnlɛhɛ ye kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu n maha kakuãcran nde pãã taha ma yee: «Dya waa pye naam kicar syãm ne. ");
INSERT INTO xrb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","U dyasyĩnde n ba pe tuhufua pye ma yee: ‹Ta tuhufua, wo wale wãn la, ma ra lay wãã ra kẽ.› U tuhufua n -sẽ u koho wãn la. ");
INSERT INTO xrb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Plii raa n tɛr, u dyasyĩnde n yir, ma u lay wãn byɛ par, ma tɛr pe war ne deydey kulaa wo. U n ga taha kuee gbar ya na, ma u wale byɛ pye klaha- tãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pe war pe ba kua u ye, fããpihi gaa n dye le klo wo, u yɛ̃ digi saha yãã u ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","U n ka ma ga tẽn kɛ klofua waa ye, u n u gbe le u tar wo, u naa kaha tyɛ- naha. ");
INSERT INTO xrb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pe tyɛ- pe naa katyipir rii di, te di laam pye u na, waa sẽ -sẽ naa te wãã u kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Loo na, u n nii u ya wĩĩ ga ma yee: ‹Dir rii gɛ te ma ta tuhufua tẽntẽ- ye, pe saha te di tãŋ ye, ndoo -sẽ nwo tee nde wo, n n ku fãã ne! ");
INSERT INTO xrb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N ga dur ga ra tuhufua ye, n n gaha u yar n yee, ta tuhufua, n kapee- pye Yãhã na, n kapee- pye ma na. ");
INSERT INTO xrb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N sẽ maha yai ma naa ra yãŋ ma dya draha wo ye. Naa ra yigi mii ma tẽntẽle waa dyaŋ.› ");
INSERT INTO xrb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","U n yir, ma kãnde sya ma n tɛr u tuhufua fla na. Tuu ga kaha yãŋ n wãã deydey, u tuhufua n u yãã. U dya fɛn n u sroŋ yigi, u n sya yir fã ga maa u wãã, ma u pua yigi. ");
INSERT INTO xrb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Loo na, u dya n u pye ma yee: ‹Ta tuhufua, n kapee- pye Yãhã na, n kapee- pye ma na. N sẽ maha yai ma naa ra yãŋ ma dya draha wo ye.› ");
INSERT INTO xrb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pe -sẽ ga dye kaha wo, u tuhufua n u tẽntẽ- pye ma yee: ‹Nayroho gii ke yɔ̃ tãŋ te nayrɛ byɛ na, -ye ka farfar, yaa koo gbe ba le u na, -ye kãncrã le u kẽ kɔ̃nde na, -tee maha ntãn le u kẽ trɛ na! ");
INSERT INTO xrb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naampẽŋ gii ke gboho, ye ga ke yigi ba boo, waa nuhu dir di. ");
INSERT INTO xrb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ye sẽ yãã, ta dya nwo tee yãã nwo, le ma mii u ba ku ra ye, ma dur ba yrãŋ na; le ma mii u ba plaha ra ye, ta n u yãã.› Pe n yir gbar na, ma nii nuhu di. ");
INSERT INTO xrb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Loo yale wo, u dyadyaha pye tar wo. Tuu dur n pai ma ba nɔ kaha yɛ̃ na, u n luhu kapẽn mii ye, yɔr ne. ");
INSERT INTO xrb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","U n tẽntẽle waa yee ba, ma ba u yey nwa kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","U tẽntẽle n u yɛ̃ sya ma yee: ‹Ma cĩĩfua kẽ u dur ba. Koo kẽ, naampẽŋ gii ke ba gboho, ma tuhufa ta pe n ke boo, ma yee woo dya dur ba u ye wãwee.› ");
INSERT INTO xrb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","U dyadyaha laam n war, u n sye u sẽ dye kaha wo ye. U tuhufua n yi ma yee, woo ga u laam yĩn u n dye. ");
INSERT INTO xrb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","U dya n u pye ma yee: ‹Yãŋ, ke dyɛ- nii yagaa n kai- pye n wãã ma kẽ. Ma sẽ maha laa pãã yãã ra ye, ta n le sye ye. Ma ra kẽ yãã la sẽmbua gɛ ne, ma yee n sya n ga nuhu dir di ra naambiyãm ne? ");
INSERT INTO xrb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma dya nwo, tuu -sẽ ka maa ma wale byɛ pye klaha- tãŋ canaandi na, ma dur ba, naampẽŋ gii ke ba gboho ma ta pe n koo yigi boo u kẽ!› ");
INSERT INTO xrb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","U tuhufua n u pye ma yee: ‹Ta puee, ma ma ra ne yalebyɛ, wãn tii byɛ te ma ra wãn, ma bya wãn ne. ");
INSERT INTO xrb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ma sẽ yãã, ma cĩĩfua nwo taa yãã nwo, le ma mii u ba ku wo ye, ma dur ba yrãŋ na; le ma mii u ba plaha wo ye, wo n u yãã. Wo yai wo loo gbar nuhu ne, -too dir di wo laam n yĩn!› » ");
INSERT INTO xrb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu n maha kakuãcraŋ pãã u kãnyãrwai ye ma yee: «Walefua waa ba tẽntẽ waa gbe ta u wale yĩŋ na. Pe n ba u walefua pye ma yee, u tẽntẽ ma tuu u wale pye n klaha-. ");
INSERT INTO xrb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","U yĩŋfua n u tẽntẽ yee ba, maa u pye ma yee: ‹N laa luhu ma wĩĩ na, le sẽ yai ra ye ye. N saa maha ma ta ra wale yĩŋ na ye. Taa ra wale pye mii, ke byɛ tɔ̃r ra n cã.› ");
INSERT INTO xrb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","U wale tẽntẽ n laam ga ma yee: ‹Ta yĩŋfua nwo u ga ra tege kãã ra tẽn na. N ga pye mii? Fãnga wee ra na ta n ga waha kãntraha tẽn tẽ ye; n ma yee ndoo ga naa n nar, le ga nii fyar wĩĩ. ");
INSERT INTO xrb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tẽ ga lii pye n le cã yagaa. Ke syi ne, ta tẽn maa klaha- ra ye, mpãy ga waha ra yigi ta pe ya tãy!› ");
INSERT INTO xrb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Loo na, u yĩŋfua foho ke pye mpãy na, u n pe byɛ yee ba nanem. U n u wãcir yey ma yee: ‹Ma yai ma fuɛ lii dãã ra yĩŋfua kẽ?› ");
INSERT INTO xrb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","U n u yɛ̃ sya ma yee: ‹Sẽm- nasuhu gbeebua.› U tẽntẽ n u pye ma yee: ‹Ma myaha fla nge saba wo, tege nii ma sẽm- nasuhu gbeesĩĩ sẽnsye ya yrũhũ.› ");
INSERT INTO xrb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","U n waa ter yey ma yee: ‹Ah mboo, fuɛ lii ne le ma ma na?› U n u yɛ̃ sya ma yee: ‹Dir nfããper kurɛ gbeebua.› U tẽntẽ n u pye ma yee: ‹Ma myaha fla nge saba wo, tege nii ma nfããper kurɛ gbeesĩĩ ya yrũhũ.› » ");
INSERT INTO xrb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yesu n pe yar taha ma yee: «U tẽntẽ wii u sẽ ba sroŋ ye, tuu -sẽ pe fohofa pye ke syi, u yĩŋfua gɛ n u pye ma yee u le pye kacãn ne. Ye sẽ yãã, driyɛ̃fa cir pe ya ne ma sya ta tɛr cããfa na. ");
INSERT INTO xrb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndoo -sẽ ga ye yar laa ne: -Ye ye driyɛ̃ wale ta, ye naa koho le ye nampyeŋ- ye. Ke syi ne, yaʼa ba cɛr kãã le wale na yaliile wo, ye waha niisaha gaa yãã Yãhã yai klo wo. ");
INSERT INTO xrb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wii ma sroŋ kasyĩmbɛhɛ wo, ufua ga sroŋ cĩĩnde wũhũ wo. Wii ma yee u sẽ sroŋ kasyĩmbɛhɛ wo ye, ufua saha sroŋ cĩĩnde wũhũ wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ye ma yee ye sẽ sroŋ driyɛ̃ nangbãn tẽn fla wo ye, Yãhã saa ba ye taha cĩĩnde nangbãn tẽn na ye. ");
INSERT INTO xrb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yaʼa yee ye sẽ sroŋ nawee waa ter koho kla ne ye, Yãhã -sẽ ga ba ye koho kla wãã la ye kẽ? ");
INSERT INTO xrb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tẽntẽ nawee nen saha yĩŋfa nawee- syãm wũhũ wãã le pye ye. Waa wĩĩ ga tãy u ye, le tɛr waa wĩĩ yaha. U ga sroŋ waa ye, tuu waa wĩĩ sye. Le ma ke syi, ye saha nii Yãhã tẽntẽ-, tee maha nii wale tẽntẽ- ye.» ");
INSERT INTO xrb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pe Farisyɛ̃ naa Yesu kaplãŋ ngĩĩ luhu, ma naa u lɛr, wale wĩĩ tee tãy naa n tɛr pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu n pe pye ma yee: «Ye yii ta yii sroŋ, Yãhã -sẽ ye laam wũhũ cã tãŋ. Lii syi le ma yĩŋ nawee- ye, loo -sẽ ne le fũhũ Yãhã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesu n maha pe yar ma yee: «Kãnde lii Yãhã bii le le soho Musa koho wo faale wo, tesẽ faale Yãhã kaplãŋ tɔ̃rfa kai- ne, koo ngĩĩ byɛ kẽ ke naa n klaha nawee- ye, ma sya ba waa Nsãn nawee- tããfua wãpaŋ na. Ma -sẽ gbe Nsãn wãpaŋ cãã na, le Yãhã kapãyĩĩ n pãã nawee- ye, kapãyĩĩ lii le Yãhã Yai wĩĩ pãã. Nawee- byɛ -sẽ pe ya waha, ma n kɛ fãnga ne pe dye Yãhã Yai wo. ");
INSERT INTO xrb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yãhãyĩŋ tesẽ kãntraha ne te wĩĩ ga ba kua kãã. Ma -sẽ yee kãnde lii na Yãhã le ta, le kaplãŋ teelaale gɛ saa miy yaha ye! ");
INSERT INTO xrb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ke syi, naa wii ma u ya koho cɔɔ sye ma waa sya, u kapee pye, u cayɔr pye. Tesẽ cɔɔ wii u puai u sye, mboo wii ma u gbe, ma bya kapee pye, ma cayɔr pye.» ");
INSERT INTO xrb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu n maha kakuãcraŋ pãã pe ye ma yee: «Walefua waa pye, u naa nayreyɔ̃r ya le, tii syi nawãm sẽ naa te dir yey ye. Plii byɛ u naa nuhu di, ma naa diyɔ̃r ya soho. ");
INSERT INTO xrb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Fɛnfua waa -sẽ pye, pe naa u yee Laasar, u kadye byɛ pye nar fla. U sãy naa n nii u walefua kapahayɛ̃ ya na. ");
INSERT INTO xrb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dir rii bir re tege naa n too kãntraha na, u naa n kɛ u re yãã u di. Pãm maha ba u nar lai naa n di u ye. ");
INSERT INTO xrb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","U fɛnfua n ba ku, yãhãyĩŋ tẽnlɛhɛ ye n u gbe ga ta Brama tãy, nakur klo niisayũhũ wo. Loo kur ye, u walefua n ba ku u ya ndoŋ, pe n u tugu le. ");
INSERT INTO xrb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","U walefua naa fɛn sya nakur klo niisapihi wo, naa fla wo. U n yĩntaha kuã yir wãã, ma Brama yãã deydey, Laasar ne u tãy. ");
INSERT INTO xrb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","U n tẽ sya ma yee: ‹Ta tuhufua Brama, ta fɛn di ma Laasar lɛhɛ wãã, u n ga u kɔ̃nde ya kã le car ya loho wo, u ba ra yĩnkãi yĩn ta kẽ. Ma sẽ yãã, ta fɛn gboho tɛr naa nge wo.› ");
INSERT INTO xrb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Brama n -sẽ u pye ma yee: ‹Ta dya, taa pye kãntraha na, ma koho wãn pye la wãkua wãn, Laasar woo sẽ pye la fɛn ya? Le faha la ma na? Yagaa taa nwo fɛn laam wo, u lay kẽ u n di yagaa. ");
INSERT INTO xrb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tesẽ wuhungbãŋ ma wo nsoho wo ye ne. Ma sẽ yãã, mpãy ma yee pe ga yir nwo pe ka ye fla na, pe saha ka ye. Nawee wii ma maha pye ye fla na, u saha pa nwo ye.› ");
INSERT INTO xrb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","U walefua n Brama pye ma yee: ‹Le ma pye ke syi, ma Laasar lɛhɛ wãã ta tuhufua kaha wo, ");
INSERT INTO xrb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nampyesey ma ra ye, wãm bua. U lɛhɛ wãã, u n ga pe yar pe ma syi ra wãŋ syi pye pe ba pa fɛn fla nge wo ta wãŋ syi dyaŋ ye.› ");
INSERT INTO xrb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Brama n u yɛ̃ sya ma yee: ‹Yãhã kaplãŋ nkãy Musa tuu bii cãã yrũhũ yaha, nkãy ne pe Yãhã kaplãŋ tɔ̃rfa pe bii cãã yrũhũ yaha, ke ma ma nampyeŋ- ye kaha wo, pe naa n luhu ke ye.› ");
INSERT INTO xrb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","U walefua n u pye ma yee: ‹Ta tuhufua Brama, loo saha yai ye. Nawee ma yir nakur klo wo nwo, maa pe yar pe ga cã pe kapee- wãpyeŋ sẽ yɔ̃ ye, pe gbihi naa n yãr Yãhã kãnyĩĩ wo.› ");
INSERT INTO xrb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Brama n u pye ma yee: ‹Pe ma yee pe saa luhu Yãhã kaplãŋ nkãy ye ke ma pe ye ye, waa ma sya yir nakur klo wo, ma dur ga yrãŋ na pe ye, pe ga yee woofua bya kaplãŋ wee cĩĩnde ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu n maha u kãnyãrwai pye ma yee: «-Ye yãŋ, kapee- wãpyeŋ saha kua yãã ye. Wii ma -sẽ u nampyeŋ ta u n kapee pye, ufua wĩĩ pee! ");
INSERT INTO xrb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mpãy pe ma pra kicar wãŋ syi, ma ra ta pe Yatɛr, wii ma poo nen waa ta u n yi kãã ra kãnde wo, le ga pee woofua na. Pe ma sya cãã ntẽmbangbãŋ pua woofua yĩntyigi na, ma u gbe miy le wãã langbãŋ wo u sẽ yãã loo kapee nde yãã pye ye, ke puar u na. ");
INSERT INTO xrb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","-Ye yii yigi! Ma nampyeŋ ma laa tee pye ma na, le pãã u ye. U ma le sya u kadugun ma cã le sẽ yɔ̃ ye, tyii u kapee fuɛ na ma kuãŋ ne! ");
INSERT INTO xrb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","U ma sya tee pye ma na tɛhɛ kuasĩĩ per neŋ ya wo, ma -sẽ le sya ke tɛhɛ kuasĩĩ byɛ na ma cã le sẽ yɔ̃ ye, tyii u kapee- foho na ma kuãŋ ne ke tɛhɛ kuasĩĩ ngĩĩ byɛ na.» ");
INSERT INTO xrb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yĩŋfua Yesu tẽnlɛhɛ ye n ba u pye ma yee: «Kaa taha wo na, Yãhã wĩĩ n waha sroŋ gboho wo laam wo.» ");
INSERT INTO xrb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu n pe yɛ̃ sya ma yee: «Ye laam wo, yaʼa Yãhã ta ye Yatɛr carle ya, ye ga waha pãã katyigi nge ne ye yee: Mii kuã kãã tee nde wo, ma ka maa mii sĩĩ langbãŋ wo. Ke katyigi -sẽ ga luhu ye ye, ke le pye cĩĩnde ye yĩnde na.» ");
INSERT INTO xrb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu n maha yee: «Tẽntẽle syi ne pye waa ye ye laam wo, tuu gbe u naa tar war, laa na u naa mbaa naha, u ne u yãã tuu yir tar laam wo ma n pai, u ga u pye la, u pa farfar u ba nii u loho wɔ, tuu di? ");
INSERT INTO xrb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aye rɛhɛ, tuu ga lii pãã u ye u ga yee: ‹Ta sro soho ra kẽ! N ma ba nii maa di yaliile wo, ma ka maa ma tẽntẽ nayrɛ yi kãã, -taa raa le, ma ba naa wãn pye ra kẽ ta n naa n di! N ma ba di wa, ma cã ba di kur kuɛ ye.› ");
INSERT INTO xrb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","U tẽntẽle kẽ u ne, tuu u taha nkãy na u n ke pye, u ga maha syaha wãã la u kẽ nantãŋ? ");
INSERT INTO xrb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ye wĩĩ bya ma ke syi: Tẽ ye taha nkãy byɛ na, yaʼa ba koo byɛ pye kua wa, -ye yee: ‹Tẽntẽ- ya me wo ne; wo tẽn ya sẽ na too tẽ? Ah lii maha kuee?› » ");
INSERT INTO xrb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu n ta tɛr Yurusalɛm kãnde ne. U n ba Syamarifa kãntraha yɛrtɛrsaha fla sya, tesẽ Galɛlɛ kãntraha yɛrtɛrsaha fla ne, ma naa n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","U naa n dye kusyĩnde laa wo, gber- sẽnsye mpãy n u wãã ba, ma ba yɛr deydey. ");
INSERT INTO xrb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Pe n nii n tẽ ma yee: «Yĩŋfua Yesu, wo fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu n pe yãã, ma pe pye ma yee: «-Ye ka, yaa yii yar Yãhã yũndefa na.» Pe n nii n gaha, ma ga jaa kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Poo nen waa, tuu yãã u jaa, u n dur ma nii Yãhã sey n pai fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","U n ba kãnklũy gbãã Yesu trɛ tãy, ma yĩŋ kor le ma syaha wãã u kẽ. U dya pye Syamarifa naa. ");
INSERT INTO xrb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Loo na, Yesu n yɛ̃ kuã ma yee: «Poo sẽnsye mii byɛ pe jaa, pe kuaresyar mii -sẽ ma na? ");
INSERT INTO xrb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Waa sẽ yãã yee gɛ yee u ga dur ba syaha wãã Yãhã kẽ, mii tergaafua nwo ya sẽ kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Loo kur ye, Yesu n u Syamarifa naa pye ma yee: «Yir, ma naa n gaha, taa ra ta ma Yatɛr, loo le ma sya yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pe Farisyɛ̃ n ba Yesu yey Yãhã Yai wãpa yale ne. U n pe yɛ̃ sya ma yee: «Yãhã Yai wãpaŋ sẽ waha yãŋ n cã ye. ");
INSERT INTO xrb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ye yee la le ga ba naa n pãã Yãhã Yai ma nwo, laa na ke ma nwaa? Tee -sẽ le cã ye yee Yãhã Yai ma wa ye telai wo.» ");
INSERT INTO xrb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","U n dur ma u kãnyãrwai pye ma yee: «Cãã gaa ma ke n pai, yaa ba naa u Nawee Puee yĩnfar kɛ, le ma sya ga pye per neŋ wãyãã ya. Ye sẽ -sẽ ga ba u yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ye ga ba naa n luhu nawee- yɛ̃ na, u ma nwo, laa na u ma nwaa. Ye ma n fã taha waa na ye. ");
INSERT INTO xrb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ye sẽ yãã, u Nawee Puee wãdurbaŋ ga ba pye mii yãhã wãyɛhɛ dyaŋ, ke ne yɛhɛ ke ncaha byɛ gbe tã, nawee- byɛ n ke yãã. ");
INSERT INTO xrb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","N -sẽ yai n cãã wãfãy yãã gboho, n yai yagaafa n cãã ra wĩĩ sye. ");
INSERT INTO xrb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kai- nkãy ke naa n pye faale wo Nuwɛ cãã na, koo syi kai- ga ba naa n pye u Nawee Puee wãdurba yale wo. ");
INSERT INTO xrb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Koo cãã na, nawee- naa n di, ma naa n wɔ, ma naa ca sya, ma naa pe pueesyam wãã naam kẽ. Pe naa loo pye, te lafir n sya bii yi tã kãntraha byɛ na ma nawee- byɛ boo tãŋ. Nuwɛ woo n bii sya yaha u salangbãŋ wo, u nna ne. ");
INSERT INTO xrb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kai- nkãy ke naa n pye faale wo Lote cãã na, koo syi kai- ga ba naa n pye u Nawee Puee wãdurba yale wo. Lote cãã na, nawee- naa n di, ma naa n wɔ, ma naa wãn par, ma naa tar war, ma naa nwey fãã. ");
INSERT INTO xrb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per gii Lote yi Sodɔ̃ wo ma tɛr, naangbãŋ tesẽ naatarmiy ne te n yir yãhãyĩŋ kuɛ ye, ma n too le klo na, ma sya pe klofa byɛ suhu boo. ");
INSERT INTO xrb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","U Nawee Puee wãdurba yale wo, ke syi ga ba naa n pye. ");
INSERT INTO xrb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Koo per na, wii ma ba pye u gbegbaha yĩntraha wo, u ma syi yee woo ga tege dye nwoŋ wo, u ga u wãn gbe ke fla na ye. Wii ma ba pye tar wo, u ma syi yee woo ga dur ga u kaha wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","-Ye ye laam too lii na le bii Lote cɔɔ dye. ");
INSERT INTO xrb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wii tuu u ya yĩŋ kɛ, ma suhu u laam wãn ne, woofua ga ba too byɛ kɛ laa; wii tuu -sẽ ga le sya u u yĩŋ kɛ laa, ma suhu u laam wãn ne, woofua kẽ tuu cã ga ba too nde byɛ yãã. ");
INSERT INTO xrb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta n ye yar, koo per na, nawee- syãm ma pye pe wãã sãy nii kasãy wãŋ neŋ na yĩmper wo, pe ga ba nen yigi ba ra fla na, pe tyii u nen na. ");
INSERT INTO xrb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ca syãm ma pye, pe tra tre pe ya tãy, pe ga ba nen yigi ba ra fla na, pe tyii u nen na.  ");
INSERT INTO xrb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Naam syãm ma pye tar wo pe ya tãy, pe ga ba nen yigi ba ra fla na, pe tyii u nen na.» ");
INSERT INTO xrb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Loo na, pe kãnyãrwai n u yey ma yee: «Yĩŋfua, kai- ngĩĩ ga ba pye na?» U n pe yɛ̃ wãã sya plãhã ne ma yee: «Ye sẽ yãã, kakugu ma pye na, yãn ga te ya wãã koo fla na.» ");
INSERT INTO xrb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Loo kur ye, Yesu n maha kakuãcran laa pãã u kãnyãrwai ye, pe waha cã pe naa Yãhã nar yalebyɛ, pe ma syi pe fãy naa n sya loo ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U ba pe pye ma yee: «Klo laa wo, kasãhãfua waa pye. U sẽ naa n fya Yãhã na ye, u sẽ naa nawee yãŋ ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Loo klo nen ya wo, calangusya waa maha pye, u naa n pai u kasãhãfua fla na, u tãhã wĩĩ laa na. U naa u kasãhãfua pye ma yee: ‹Le kai nde sãhã wo nsoho wo ra napĩĩ ne, ta n waha ra tãhã yãã.› ");
INSERT INTO xrb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Le n kuee ma sya ma-, u kasãhãfua sẽ naa n traha u laa pye ye. U n ba u ya pye ma yee: ‹Cĩĩnde ne, n sẽ n fya Yãhã na ye, n sẽ maha nawee yãŋ ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Cɔɔ nwo ra fãy gboho n tɛr, n ga u tãhã wãã u kẽ, nawee- n cã. Mii loo sẽ ne ye, n saa wũũsaha yãã ye.› » ");
INSERT INTO xrb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yĩŋfua Yesu n u kãnyãrwai yar taha ma yee: «Kasãhãfua nwo gɛ tuu sẽ n sroŋ ye, tuu lii pãã ye sẽ le yãã la? ");
INSERT INTO xrb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yãhã nge gɛ mpãy ke pe yãŋ yi, poo mii ma ba n wũn pe tãhã wĩĩ laa na ke yai ke yĩmper, ke saa laa pye la pe kẽ? Ke ga ma- la mii ke sẽ koho le pe ye ye? ");
INSERT INTO xrb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta n ye yar: Ke ga pe tãhã wãã pe kẽ le yalebya wo. Ma -sẽ yee u Nawee Puee ma ba dur ba kãntraha na, u ga ba poosyifa mpãy yãã la mpãy syi pe u sroŋ ta pe Yatɛr?» ");
INSERT INTO xrb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mpãy pe naa pe ya yãŋ ma yee poo sroŋ Yãhã ye, ma yee mpãy pe kuee pe sẽ yɔ̃ ye, Yesu n kaplãŋ ngĩĩ kuã cra pãã pe kẽ ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nawee- syãm mpãy ba dugu ga Yãhã kangbãŋ wo, Yãhã narsaha wo; nen pye Farisyɛ̃ naa, nen nwo -sẽ pye kufar wããfua. ");
INSERT INTO xrb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","U Farisyɛ̃ naa n ga yɛr u ya ya, ma nii Yãhã nar ma yee: ‹Yãhã, nawee- byɛ n yuhu, pe pee ma maha cayɔr le. Ndoo tẽ wee wãcɛŋ pe ne ye, n syaha wãã ma kẽ loo nde wĩĩ na. N sẽ maha wee kufar wããfua nwo dyaŋ ye, n syaha wãã ma kẽ loo wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Plii kuasĩĩ nsoho wo, n ne plii sĩĩ raa yãŋ yi, n ta yɛ̃ tã digi na n saa ngaa di ye. Tesẽ, n ma ngii koo yãã, n ga ke la flɛ sẽnsye, n fla neŋ wãã ma kẽ.› ");
INSERT INTO xrb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","U kufar wããfua woo n fya ma ga dey yɛr, u sẽ sya ma yĩntaha gɛ kuã yir wãã yãhãyĩŋ kuɛ ye ye, ma nii u ya ntraŋ gbã ma yee: ‹Yãhã, n ma kapeepyefua, ta fɛn di, ma fĩhĩ ta kapee- byɛ laha kãã ra yĩŋ na.› » ");
INSERT INTO xrb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu n maha pe nawee- pye ma yee: «Ta n ye yar, u kufar wããfua tuu dur tɛr u kaha wo, Yãhã ba u yãŋ ma yee u sroŋ ma ta tɛr u Farisyɛ̃ naa na. Ye sẽ yãã, wii ma u ya ta yĩŋfua draha wo, ufua ga kloŋ. Wii ma sẽ u ya kloŋ, ufua ga kuã yir yĩŋfua draha wo.» ");
INSERT INTO xrb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nawee- n pa kicaabir ne Yesu fla na, tuu koho taha pe na, u Yãhã nar pe wĩĩ na. Pe kãnyãrwai n pe yãã, ma kuãn pe na. ");
INSERT INTO xrb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu n pe kicaabir yee ba u tãy ma yee: «Ye tyii pe kicaabir na, pe n pa ra ye! Yaʼa n sye pe na ye! Ye sẽ yãã, mpãy pe ma pra poo wãŋ syi dyaŋ, Yãhã Yai ma poo wãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ta n cĩĩnde nde pãã ye ye: Wii ma yee u sẽ Yãhã Yai wĩĩ sya yigi yaha u laam wo kicar wãŋ syi dyaŋ ye, woofua saa dye yãã Yãhã Yai wo ye.» ");
INSERT INTO xrb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yiifee yĩŋfua waa n ba Yesu yey ma yee: «Yĩŋfuayɔ̃, n ga waha lii pye n cĩĩnde yrã yãã, lii wãkuayãã wee le na ye?» ");
INSERT INTO xrb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu n u pye ma yee: «Nwa ta ma n yee n yɔ̃? Waa sẽ yɔ̃ mii Yãhã ya sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ma sẽ Yãhã kãnde kataŋ wũhũ cã la, nkãy ke yar yaha ma yee: ‹Maʼa syi ma cayɔr le ye, maʼa syi ma nawee boo ye, maʼa syi ma yuhu ye, maʼa syi ma kawar fua ye; naa ma tuhufua gboho, ma nahafua ne!› » ");
INSERT INTO xrb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","U dya n u pye ma yee: «Ta kicar wo, n koo ngĩĩ byɛ yigi, ma sya ba waa yagaa na.» ");
INSERT INTO xrb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu tuu kapãn nde luhu, u n u dya pye ma yee: «Katɛ nen laa kuee ma ye. Ka, ma ga ma koho wãn byɛ par tãŋ, -taa pe war byɛ wãã tãŋ nawãm kẽ! Loo na, ma -sẽ ga ba nii nangbãŋ Yãhã ye. -Taa pa, ma ba taha ra na!» ");
INSERT INTO xrb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","U dya tuu kaplãŋ ngĩĩ luhu, u laam byɛ n wlãhã u ye, u tee pye nangbãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu tuu yãã u dya laam ba wlãhã, u n le pãã ma yee: «Nangbãm wãdye wĩĩ Yãhã Yai wo, le war! ");
INSERT INTO xrb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","-Ye yãŋ, yũhũmii wãdyeyitɛr mensãn wihi ne, le ma fãhãfãhã ma tɛr nangbãŋ wãdye yaha Yãhã Yai wo.» ");
INSERT INTO xrb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mpãy pe naa n luhu Yesu ye, pe n u pye, a nangbãm ma yee pe saa waha pe yĩy yi yaha ye, yoo syi -sẽ ma u ga waha u yĩŋ yi yaha? ");
INSERT INTO xrb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu n pe yɛ̃ sya ma yee: «Kai lii le nawee yia, le sẽ Yãhã koo yia ye.» ");
INSERT INTO xrb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Loo na, Pyar n u pye ma yee: «Yĩŋfua, yãŋ, wii mpãy too -sẽ tɛr wo kãnkai- byɛ yaha, ma taha ma na, wo wĩĩ ga ba pye mii?» ");
INSERT INTO xrb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Wii ma tɛr u kaha yaha, tesẽ u cɔɔ ne, u nampyesey ne, u seefa ne, u pii ne, Yãhã Yai wĩĩ na, ");
INSERT INTO xrb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u ga too syi yãã nanga kãntraha nge na, te n sya gboho tɛr. Sukũhũ gaa laam wo, u ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nabuar naa n taha Yesu na, u n ba u kãnyãrwai sẽnsye syãm cɛr yi, ma pe yar ma yee: «-Ye yãŋ, wo dugu n gaha Yurusalɛm wo. Faale Yãhã kaplãŋ tɔ̃rfa pe bii kai- nkãy cãã yrũhũ yar yaha u Nawee Puee wĩĩ na, ke byɛ ga pye yagaa. ");
INSERT INTO xrb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pe ga ba ra wãã mpãy kẽ pe sẽ cĩĩnde Yãhã cã ye. Poo, pe ba naa ra lɛr, pe naa ra tyɛhɛ, pe yɛ̃syɔ̃r tu naa n woo ra na. ");
INSERT INTO xrb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pe ga ba naa ra gbã sãngblã ne, pe ba ra boo. Ta wãku plii tãã wuhu, n ga ba yir gbã wo, n pa gbaafa ye.» ");
INSERT INTO xrb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pe kãnyãrwai sẽ -sẽ laa war nde na ye. Ke kaplãŋ yĩntaha tee ba waha tɛr, pe sẽ ba cã Yesu naa lii pãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu ba dye gbe taha Yerekɔɔ wo, nabuar pye u ne. Fũũ naa waa -sẽ pye, tuu ba tege nii kãnde yɛ̃ na, ma naa n nar. ");
INSERT INTO xrb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","U n luhu nawee- ne pe gble n pai, u n le yey ma yee nwa kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pe n u yar ma yee, a Nasarɛtefa Yesu kẽ u n pai tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tuu loo luhu, u n nii n tẽ ma yee: «Dawide Dya Yesu, ta fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mpãy pe naa n yãr yahasee ye, pe nii n kuãn u na ma yee, tuu yaha le. U n sye, ma cã maha nii n tẽ fãnga ne ma yee: «Dawide Dya, ta fɛn di!» ");
INSERT INTO xrb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu n luhu, ma yɛr, ma pe nawee- pye pe pa u ne u kẽ. Pe n pa u fũũ naa ne, Yesu n u yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ma yee n nwa pye ma kẽ?» U n Yesu yɛ̃ wãã sya ma yee: «Yĩŋfua, ta ra n waha naa n yãŋ faale wãŋ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu n u pye ma yee: «Naa n yãŋ! Taa ra ta ma Yatɛr, loo le ta ma n jaa.» ");
INSERT INTO xrb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","U yĩmpɛ n ta tɛr yãr ke fla byɛ wo, u n nii Yãhã sey, ma nii n taha Yesu na. Pe nawee- byɛ pe loo yãã, pe n nii Yãhã sey pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu n ba dye Yerekɔɔ wo, ma le klo yɔ̃r yi naa n yaha u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Le klo wo dya waa pye, pe naa n yee Sahasye. U pye kufar wããfa yĩŋfua, ma pye walefua. ");
INSERT INTO xrb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U naa n kɛ u Yesu yãã yĩnde ne, u u cã. Nawee- ba wɔ tã Yesu na. U Sahasye pye nagbɛrle, u sẽ waha Yesu yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","U n gblihi laa, ma fã ga yahasee ye, ma ga dugu nii katyigi gaa na, u waha ba Yesu yãã tɛrsaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu tuu ba nɔ ke fla na, u n yĩŋ kuã yir, ma Sahasye pye ma yee: «Sahasye, tege yãŋ farfar, n yai n syã ma kaha wo nanga.» ");
INSERT INTO xrb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sahasye n tege farfar, ma Yesu wãã sya nuhu ne, ma ka u ne u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mpãy byɛ pe le yãã, pe n yee le sẽ yɔ̃ ye, ma nii le pãã, a u dya ka maa nampay le kãmpee yãrfua ne. ");
INSERT INTO xrb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kaha wo, Sahasye n yir yɛr u Yĩŋfua Yesu yahasee ye, ma u pye ma yee: «Yĩŋfua, n ga ra koho wãn byɛ la flɛ sãnsĩĩ, tẽ flɛ naney wãã nawãm kẽ. N ma cã n wii wale sya u ye fufor na, n ga loo syi wale flɛ resyar dãã ufua kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu n u pye ma yee: «Mboo tesẽ ma kahafa ne, ye sya yaha nanga, ma bya ma Brama kur waa mii ndoŋ, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma sẽ yãã, nawee- mpãy pe plaha, u Nawee Puee pa pe wãsyayaha yĩmbui ne.» ");
INSERT INTO xrb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mpãy pe ba naa n luhu Yesu ye, u n maha kaplãŋ nkãy kuã cra pãã pe ye. Tuu ba gbe taha Yurusalɛm na, nawee- naa le ga ma yee, laa na Yãhã Yai ga pa le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yesu n yee: «Nangbãŋ puee waa ba yir, ma ka deydey klo laa wo yĩŋfuangbãŋ fla na, u n gaha fãnga sya u ye, u dur ba nii yĩŋfua u klo wo. ");
INSERT INTO xrb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tuu yee u ga koo yrãhã yi, u n u tẽntẽ- nawee- sẽnsye mpãy yee ba, maa per neŋ tẽn war la klaha pe nanem byɛ kẽ. U n pe pye ma yee: ‹Nawee nawee woo, u naa cãã troho u war ne, ta n sya ba dur ba.› Loo kur ye, u n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","U dya -sẽ nwo, u wĩĩ ba pee u klofa ye. Mpãy n yir ma tẽnlɛhɛ taha u na, pe ga u yĩŋfuangbãŋ yar, a poo wee dya nwo wĩĩ na u nii pe yĩŋfua ye. ");
INSERT INTO xrb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Loo naa byɛ ne, pe n ga yĩnfar wãã u kẽ, u n dur ba u klo wo. Tuu ba war wãã u tẽntẽ- mpãy kẽ, u n pe yee ba loo na, ma ba pe yey pe cãã troho ma war nanii yãã taha. ");
INSERT INTO xrb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","U wãcir n yir ma yee: ‹Yĩŋfua, taa war wãŋ gii wãã ra kẽ, n cãã troho ke ne, ma te syi wãy sẽnsye raa yãã taha.› ");
INSERT INTO xrb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","U nangbãŋ n woo pye ma yee: ‹Le yɔ̃; tẽntẽyɔ̃ kẽ ma ne. Taa sroŋ kasyĩmbɛhɛ wo, n ga ma taha kui sẽnsye raa yĩŋ na.› ");
INSERT INTO xrb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","U tẽntẽ syãŋ wuhu n pa, ma ba yee: ‹Yĩŋfua, taa war wãŋ gii wãã ra kẽ, n cãã troho, ma te syi wãy bua raa yãã.› ");
INSERT INTO xrb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","U nangbãŋ n maha woo ter pye ma yee: ‹Mboo na, n ga ma taha kui bua yĩŋ na.› ");
INSERT INTO xrb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tẽntẽ waa ter n pa, ma ba yee: ‹Yĩŋfua, ma war wãŋ nge. N ba ke gbihi ta fatar wo, ke ma n plaha ye. ");
INSERT INTO xrb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N tee ba fya ma na, ma laam waha tɛr. Ngii ke wee ma myaha wãŋ ye, ma ke yey n sya. Tar rii nawee- pe n war, ma n ta pe ma myaha taha re na.› ");
INSERT INTO xrb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","U nangbãŋ n u pye ma yee: ‹Tẽntẽ nwo, ma sẽ yɔ̃ ye. N ga ma sãhã ma yɛ̃ kaplãŋ ne. Ma yee ra laam waha, a ngii ke wee ta myaha wãŋ ye, n ke yey n sya. Ma maha yee, a tar rii nawee- pe n war, n n ta pe ta myaha taha re na. ");
INSERT INTO xrb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Taa yee ke syi, nwa ma sẽ ka, maa ke war wãŋ wãã fuɛ na war cãtrohosaha wo ye? Loo na tẽ dur ba, n saa ne yãã la u war see, ta n sya?› ");
INSERT INTO xrb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nawee- mpãy pe pye, u n dur yagaa ma poo pye ma yee: ‹-Ye u war wãŋ sya kãã u ye, ye ke wãã te wãy sẽnsyefua kẽ.› ");
INSERT INTO xrb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pe n u pye ma yee: ‹Yĩŋfua, ah woo nwo wee wa la wãy sẽnsye ne?› ");
INSERT INTO xrb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","U n yee: ‹Ta n ye yar, wii ma pye ngaa ne, pe ga ba wãã taha u kẽ. Wii ma -sẽ yee u wee ngaa ne ye, car gii ke ma u koho wo, ke ga ba tyĩn sya kãã u ye. ");
INSERT INTO xrb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ta napĩĩ- mii wĩĩ na, pe ba yee poo wee ra wĩĩ na pe yĩŋfua ye, -ye pe yigi ba nwo, ye ba pe boo ra yĩnde na!› » ");
INSERT INTO xrb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu tuu koo pãã wa, u n ta tɛr yir, ma Yurusalɛm kuɛ kãnde sya. Nabuar naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pe n ga nɔ gbe taha Gbefasyɛ tesẽ Gbetane kusyĩmbɛhɛ kuɛ ye, yãŋ gaa tãy. Katyir raa ter pye ke fla na, pe naa te yee wolifyɛ katyir. Yesu n u kãnyãrwai syãm mpãy lɛhɛ wãã u yahasee ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«-Ye ka kusyĩnde ndaa wo ye yahasee ye! Yaʼa ga n dye, yaa kãnkonyainge gaa yãã, ke pua yaha nii, waa sẽ dugu yãã ke na ye. -Ye ke sãhã ba nwo! ");
INSERT INTO xrb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wii ma ye yey ma yee nwa ye n ke sãhã, -ye ufua pye ye yee, ke wĩĩ ma wo Yĩŋfua na!» ");
INSERT INTO xrb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pe kãnyãrwai syãm n ka. Yesu tuu ba pe cãã yar yaha mii, pe n ga yãã koo syi. ");
INSERT INTO xrb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pe naa ke kãnkonyainge sãhã, kefa n pe yey, a nwa ta pe n ke kãnkoŋ sãhã? ");
INSERT INTO xrb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pe n yee: «Ke wĩĩ ma wo Yĩŋfua na.» ");
INSERT INTO xrb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pe n ka ke kãnkoŋ ne Yesu kẽ, ma pe nayrengbãy taha ta ke na, Yesu n dugu nii te na. ");
INSERT INTO xrb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pe n nii n gaha Yurusalɛm kuɛ ye, nabuar tii te pye te n nii u gboho, ma pe nayrengbãy yaha n gaha le kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesu tuu ba dye gbe taha Yurusalɛm wo kãnde lii ne le n yir ke wolifyɛ katyir yãŋ na, ma tege n gaha le klo wo, nuhu n pe kãnyãrwaibuar yigi. Pe n nii Yãhã sey laanwɔ wũhũ nkãy byɛ wĩĩ na ke pye tɛr, pe n yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pe naa n yee: «Yĩŋfua, mboo wii taa n pai Yãhã myaha ne, Yãhã ke kaa taha ma na. Yãhã yrĩŋ nɔ wãã wo ye, nawee- byɛ pe naa Yãhã miingbãŋ gboho!» ");
INSERT INTO xrb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisyɛ̃ mpãy pye pe nabuar laam wo. Pe n Yesu pye ma yee: «Yĩŋfua, ma nawee- ta pe n yaha le.» ");
INSERT INTO xrb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu n pe yɛ̃ sya ma yee: «Poo ma sya yaha le, ntẽmbar gɛ ga naa n gble pe draha wo!» ");
INSERT INTO xrb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu tuu ba crã Yurusalɛm na ma yĩnde taha ke na, u n nii n wũn le klo wĩĩ na ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Yrĩŋ wĩĩ lii le n pai ma nawee- ye, ke nanga nge na, pe ma ne pye pe ga waha le yãŋ cã pe ya ndoŋ, le ne ga puar pe na! Yagaa, le -sẽ nde, le wũhũ pe na, pe saha le yãŋ cã gbaa na ye! ");
INSERT INTO xrb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Plii raa ma re n pai, ma nawee- napĩĩ- ga ba pe klofa gbey le, pe naa naan miy pe na kuɛ byɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yaliile Yãhã pa ke n pai pe Yurusalɛmfa sya yaha, pe sye ma yee pe sẽ cã ye. Koo kẽ pe napĩĩ- ga ba yia pe na, pe pe boo tãŋ, pe le klo yoho tãŋ migimigi, waa saa ntẽmblaha gaa gɛ yãã ke taha ta nii ke nampyeŋ na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu n ga dye ke Yãhã kangbãŋ laam wo, ma too pe cãtrohofa na, ma nii pe kar n yi. ");
INSERT INTO xrb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","U naa pe pye ma yee: «Le ma le yrũhũ ta Yãhã sabangbãŋ wo ma yee, Yãhã yee: ‹Ta kangbãŋ yai ke nii ta seysaha.› Yii -sẽ ke ta yuhu- dyeniisaha!» ");
INSERT INTO xrb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Plii raa nsoho wo, Yesu naa nawee- klaha ke Yãhã kangbãŋ laam wo. Pe Yãhã yũndefa yĩŋfa, pe Yãhã kaiyarfa ne, tesẽ pe Yiifee- yahaseefa ne, pe naa Yesu kɛ wãboo ne. ");
INSERT INTO xrb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pe ga pye mii pe waha u yigi boo, pe sẽ le cã ye. Pe ba fya pe klofa na, poo naa Yesu kaplãŋ luhu nuhu ne yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Too plii nsoho wo, Yesu naa nawee- klaha Yãhã kangbãŋ laam wo, ma naa le Yãhã kapãyĩĩ wũhũ tɔ̃r pe ye. Pe Yãhã yũndefa yĩŋfa tesẽ pe Yãhã kaiyarfa ne, ma suhu pe wãlɛ ne, poo mii n pa Yesu fla na. ");
INSERT INTO xrb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pe n ba u yey ma yee: «Kai- ngĩĩ byɛ raa n pye, wo yar ma ke pye kãnde lii ne? Yoo kãnde wãã ma kẽ ma naa ke pye?» ");
INSERT INTO xrb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu n pe yɛ̃ sya ma yee: «Ta bya, n ga ye yey katɛ nen laa ne: ");
INSERT INTO xrb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","-Ye ra yar yoo tuu ba Nsãn lɛhɛ wãã, u n ba nawee- tãã naa n yi loho wo? Yãhã laa, nawee-?» ");
INSERT INTO xrb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe n ga nii le klãŋ n pãã pe ya ya ma yee: «Waʼa yee Yãhã kẽ ke ba u nɔ wãã, u ga wo pye, a nwa wo sẽ -sẽ ba u Nsãn kaplãŋ sya cĩĩnde ye? ");
INSERT INTO xrb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wo saha yee nawee- me pe u lɛhɛ wãã ye. Mii loo sẽ ne ye, pe klofa ga wo waa boo ntẽmbar ne, pe byɛ le sya cĩĩnde ma yee Nsãn pye Yãhã kaplãŋ tɔ̃rfua.» ");
INSERT INTO xrb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Loo na, pe n ba Yesu pye ma yee, a wii ruu Nsãn lɛhɛ wãã u ba nawee- tãã naa n yi loho wo, poo sẽ ufua cã ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu n -sẽ pe pye ma yee: «Yaʼa yee ke syi, ta bya, n saa ye yar n kai- ngĩĩ pye kãnde lii na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Loo kur ye, Yesu n kakuãcran pãã pe nabuar ye ma yee: «Dya waa ba defĩĩ katyir tar le, ma te tar yaha tawarfa mpãy ye, ma tɛr yrãhã ye ma n gaha ma-. ");
INSERT INTO xrb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te defĩĩ pii yiyale le ba nɔ, u tarfua n kuee, ma u tẽntẽle waa lɛhɛ wãã pe tawarfa ye, u ga woo lay sya ba. Pe tawarfa n ga u tẽntẽle gbã, ma u dur wãã kãnwai ne. ");
INSERT INTO xrb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","U tarfua n maha tẽntẽle waa lɛhɛ wãã. Pe tawarfa n maha ga woo bya gbã, ma u tyɛhɛ, ma maha u dur wãã kãnwai ne. ");
INSERT INTO xrb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","U tarfua n maha tẽntẽle waa lɛhɛ wãã, ke tɛhɛ tãã wuhu na. Pe n ga woo yigi, ma u duai, ma u gbe miy yi wãã te tar nkur ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Loo na, u tarfua n laam ga ma yee: ‹N ga pye mii? Ta dya nen wii u ntãŋ dye ra tãy, n ga woo lɛhɛ wãã. Laa na, pe n gaha nagboho ta woo na.› U n u lɛhɛ wãã. ");
INSERT INTO xrb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pe tawarfa pe ba u yãã, pe n pe ya pye ma yee: ‹Wii tuu ga ba nii tarfua woo kẽ nwo. -Too u boo, te wãn byɛ n ba nii wo wãn.› ");
INSERT INTO xrb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pe n u gbe miy yi wãã te tar nkur ye, ma u boo.» Yesu n pe yar taha ma yee: «Yagaa u tarfua ga lii pye? ");
INSERT INTO xrb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U ga ba pa, u ba pe tawarfa mii boo kãã, tuu te tar yaha nawee- mpãy ye.» Pe nawee- pe kaplãŋ ngĩĩ luhu, pe n yee: «Yãhã ma n pa le ne ye!» ");
INSERT INTO xrb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu n pe yãŋ, ma pe pye ma yee: «Ye laam wo, kapãn nde yĩntaha kẽ lii ne, kapãn lii le yrũhũ ta Yãhã sabangbãŋ wo ma yee: ‹Ntẽmblaha gii nwonfããfa pe ba sye yaha, koo ntẽmblaha kẽ ke dur yĩŋ yãã ke nwoŋ wãfãã wo.› » ");
INSERT INTO xrb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yesu n pe yar taha ma yee: «Nawee wii ma too tã koo ntẽmblaha nge na, u ga u ya waa yraha ke na. Koo ntẽmblaha ma -sẽ maha too tã wii na, ke ga ufua waa yraha migimigi.» ");
INSERT INTO xrb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu tuu koo kaplãŋ ngĩĩ pãã wa pe nawee- ye, pe Yãhã yũndefa yĩŋfa tesẽ pe Yãhã kaiyarfa ne, pe n nii n kɛ pe Yesu yigi le yalebya wo. Pe tee ba cã poo me Yesu tuu naa n yãŋ ke kakuãcraŋ ngĩĩ ne. Pe -sẽ ba fya pe klofa na. ");
INSERT INTO xrb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pe Yãhã yũndefa yĩŋfa tesẽ pe Yãhã kaiyarfa ne, pe n nii Yesu kihi n yãŋ. U ma laa plaha pye, pe u yigi. Loo na, pe n mpãy lɛhɛ wãã Yesu ye. Maʼa pe yãã maa yee naweeyɔ̃m me. Pe ba pe lɛhɛ wãã ma yee pe ba Yesu plaha yigi kayey laa ne. U ma plaha pãã, pe u yigi ga wãã u klo fãngafua kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pe n ga Yesu yey kayey nde ne ma yee: «Yĩŋfua, wo cã ma yee nkãy byɛ taa n pãã, tesẽ nkãy byɛ ne taa n klaha, ke byɛ sroŋ. Nawee ma sya nii mii syi dyaŋ, le sẽ kai kua ma ye ye. Ma nawee- klaha cĩĩnde ya ne Yãhã kãnde wãyãr wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wo yar nde ne: Wo kãnde na, wo yai la kufar wãwãã ne fãngafa byɛ yĩŋfua kẽ laa, wo sẽ yai te wãwãã ne u kẽ ye?» ");
INSERT INTO xrb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu -sẽ ba le cã wa pe n traha pe u plaha yigi. U n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«-Ye ntẽn war waa yar yãŋ ta na! Yoo yirfua pe pye ta u na nwo, u myaha ne?» Pe n yee, a u fãngafa byɛ yĩŋfua kẽ, u myaha ne. ");
INSERT INTO xrb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Loo na, Yesu n pe pye ma yee: «Ah -ye naa fãngafa byɛ yĩŋfua dãã u myaha wãn ne, -tee naa Yãhã dãã ke myaha wãn ne!» ");
INSERT INTO xrb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pe sẽ laa wãpee yãã u kapãn nde na, ma ga waha u yigi nawee- yĩnde na ye. Le kapãn maha pe laam wɔ, pe n sya yaha le, pe sẽ maha laa pãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yiifee- yahaseefa mpãy pe naa n yee Sadusyɛ̃, poo mpãy n pa Yesu fla na. Poo me pe n yee, a mpãy pe ku wa, pe saa ba yir gbã wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pe n Yesu yey ma yee: «Yĩŋfua, wo faale wãdyaha Musa bii kãnde laa yar wo na, le nde: ‹Naa ma pye cĩĩfua ne, ma ba ku u cɔɔ yaha kicar sẽ kẽ u ye ye, u cĩĩfua yai u u cɔɔ gbe, pe n kicar see u lɛfua kẽ wii tuu ku.› ");
INSERT INTO xrb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ãhã, dya waa -sẽ pye cĩĩfa kuay ne. U dya n ba cɔɔ sya, ma ku u yaha, puee sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","U taha n u calangusya gbe, ma ku u yaha, puee sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","U tãã wuhu n u gbe. Koo syi ya, koo syi ya, poo kuasĩĩ byɛ n ba ku tãŋ u cɔɔ yaha nanem. Nen waa gɛ sẽ puee yãã see u na ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Loo kur ye, u cɔɔ n ba ku u ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mpãy pe ku wa, pe ma ba yir gbã wo per gii, u cɔɔ ga ba nii yoo wũũ pe laam wo? Poo kuasĩĩ byɛ sẽ u yãã cã la cɔɔ?» ");
INSERT INTO xrb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu n pe yɛ̃ sya ma yee: «Driyɛ̃ nge wo, naam tesẽ ca ne, pe pe ya sya. ");
INSERT INTO xrb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ma -sẽ yee, naam mpãy tesẽ ca mpãy ne, pe ku wa driyɛ̃ nge yaha, Yãhã n pe yãŋ yi, ma pe ta pe n yir gbã wo, ma nii yrãŋ na Yãhã tãy, poo mii saa ba naa pe ya sya ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pe saha maha ku nantãŋ ye. Pe ma mii yãhãyĩŋ tẽnlɛhɛ wãŋ syi dyaŋ. Pe yir gbã wo, ma dur ba yrãŋ na Yãhã tãy, pe nii Yãhã pii. ");
INSERT INTO xrb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa gɛ le yar gbaa na ma yee, mpãy pe ku wa pe ga ba yir gbã wo. Tuu lii yãã ngur wambule fla na, ye le cã. Koo fla na, u ma ga Yãhã myaha yee, Yãhã gii ke ma nawee- byɛ Yĩŋfua, u ga yee Brama ye Yãhã, Yisyake ne, Dyakuba ne.» ");
INSERT INTO xrb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Loo na, Yesu n pe yar taha ma yee: «Mpãy pe ku, pe ma yrãŋ Yãhã yĩnde na. Ye sẽ yãã, nawee ma sya ku, u ma yrãŋ Yãhã yĩnde na.» ");
INSERT INTO xrb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Loo na, Yãhã kaiyarfa mpãy n yɛ̃ kuã ma Yesu pye ma yee: «Yĩŋfua, ma le pãã yɔ̃.» ");
INSERT INTO xrb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Waa sẽ maha sɛr Yesu yey laa ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Loo kur ye, Yesu n pe pye ma yee: «Nawee- pye mii ma yee, a u Yãhã Yĩndefua Crise ma wo faale wãdyaha Dawide kur kuɛ puee? ");
INSERT INTO xrb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawide gɛ sẽ bii le pãã la Yãhã wãsey yay saba wo ma yee: ‹Yĩŋfua Yãhã ta Yĩŋfua pye ma yee: Pa tege nii ra kãndigi koho kuɛ ye kai- byɛ yĩŋ na, ");
INSERT INTO xrb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta n sya ba ma napĩĩ- yĩy kor le ma kẽ, pe n nii mii ma tãnde fyãhã tã pe na.› » ");
INSERT INTO xrb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yesu n pe yey ma yee: «Dawide gɛ tuu naa u Yãhã Yĩndefua yee Yĩŋfua, u Yĩŋfua -sẽ ga maha pye mii u nii Dawide kur kuɛ puee?» ");
INSERT INTO xrb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pe nabuar naa n luhu Yesu ye, u n ba u kãnyãrwai pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ye ma syi ye naa n yãŋ Yãhã kaiyarfa na ye, poo mpãy pe pe ya yi pe nayrengbãy ne, pe le n tay. Pe maha n yãŋ pe naa pe syar nangbãsyaha ne nanihi teebɛhɛ wo. Yiifee- yawãhã nwey wo, tesẽ nanihi sedi flɛ wo, niisar rii nawee- byɛ yĩnde le yi n too re na, too syi niisar pe ne kɛ pe nii. ");
INSERT INTO xrb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Poo me pe calangusyam koho wãn byɛ sya n kãã pe ye, pe dur pe pe pe ya ta naweeyɔ̃m dyaŋ, pe Yãhã ka syar kaplãmbuar ne, pe sya ma-. Koo byɛ wãpẽn draha ga ba pe dye, ke la ke sya gboho tɛr.» ");
INSERT INTO xrb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ke Yãhã kangbãŋ laam wo, fla gaa ma nawee- pe ga war le n yaha Yãhã kẽ. Yesu n yãŋ klaha ke kuɛ ye, ma walefa mpãy yãã pe naa pe war le. ");
INSERT INTO xrb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","U n ba calangusya nawũũ waa yãã u ya ndoŋ, tuu ntẽn war puabɛhɛ nkãy le, wãm syãm ya. ");
INSERT INTO xrb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu tuu loo yãã, u n yee: «Ta n cĩĩnde nde pãã ye ye: Calangusya nwo kla le, ma ta tɛr pe nawee- byɛ yaha. ");
INSERT INTO xrb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","War mpãy pe nawee- pe sya le dege, pe wee kla pe yĩnde na ye. Cɔɔ nwo u nawãn ne, tuu car gii le, koo ya ke -sẽ pye u ye. Ngaa sẽ maha wee u ye u n ga di ye.» ");
INSERT INTO xrb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu kãnyãrwai naa ke Yãhã kangbãŋ nayɔ̃r wĩĩ pãã, tesẽ te ntẽmbar nayɔ̃r ne, tii pe ta ma ke fãã, tesẽ te kayɔ̃r tii byɛ ne, nawee- pe wãã Yãhã kẽ pe n ta ta ga ke kangbãŋ na. Yesu n -sẽ pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Plii raa ma re n pai, Yãhã kangbãŋ nge tee n yãã nge, ke ga ba yoho pye klaha-, ke ntẽmblaha neŋ gaa gɛ saa ba pye ke taha ta nii ke nampyeŋ na ye, te byɛ ga ba traha.» ");
INSERT INTO xrb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pe kãnyãrwai n Yesu yey loo na ma yee: «Yĩŋfua, wo yar ke Yãhã kangbãŋ wãtoo yale ne cigege. Kayar lii ga ba ta nawee- n waha ke pyeyale cã?» ");
INSERT INTO xrb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu n pe yɛ̃ sya ma yee: «-Ye naa yii yigi, waa kawar ma syi waha ba ye yĩntar figi ye. Ye sẽ yãã, nawee- busãã ga ba ta myaha taha pe ya na, pe naa kawar fua pe yee, a poo me u Yãhã Yĩndefua, a le yale nɔ wa yagaa. Ye ma syi ye naa n taha pe na ye! ");
INSERT INTO xrb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ye ma ba luhu pe yee naan ma, tesẽ ye ma ba luhu pe yee mpãy wãhã cɛr, ye ma syi ye fya ye. Koo kayĩhĩ yai ke ba cãã dye, le sẽ -sẽ ga ba pye driyɛ̃ wãkuaŋ le yalebya wo ye.» ");
INSERT INTO xrb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu n maha pe yar taha ma yee: «Nawee- tergaafa ga ba naa naan miy ter gaa ne. Yĩŋfua waa ga ba yir u nawee- ne, u ga naan miy yĩŋfua waa ter ne. ");
INSERT INTO xrb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kãntraha wãyɛhɛ ga ba pee. Fããpihi ga ba dye kãntraha teebɛhɛ nkãy wo, tesẽ yampeer ne. Kai- nkãy syi nawee- sẽ yãã yãã ye, pe ga ba ke yãã, pe sya fya. Kai- nkãy ga ba naa n pye yãhãyĩŋ kuɛ ye, nawee- n fya. ");
INSERT INTO xrb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kai- ngĩĩ byɛ yahasee ye, nawee- ga ba ye yigi, pe ye fãy, pe ka ye ne Yiifee- yawãhã nwey wo, pe ga ye sãhã, pe ye le nwompihi wo. Pe ga ba ye yigi ga fãnga na, yĩŋfa mpãy yahasee ye, tesẽ fãngafa mpãy ne, ndoo wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Le ga ba nii ye ye kai laa dyaŋ, ye n waha ra wĩĩ pãã laha pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Loo na, tee ga ba lii pãã ye wlohoyisaha yãã, -ye ma n naa ntãŋ cɛr loo ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pe ma ye yigi ga kasãhãfa fla na, n ga ba kaplãŋ nkãy le ye yɛ̃ wo, tesẽ laantor raa ne ye laam wo. Ye ma ga lii pãã, ye napĩĩ- saha yɛr pe laa cã pãã pe yee, cĩĩnde sẽ ne ye wĩĩ ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ye seefa gɛ ga ba ye yi fãngafa kẽ. Ye nampyesey bya ga ba loo pye ye na, ye nwoŋfa ne, ye naambiyãm ne. Pe ga ba ta pe n mpãy boo ye laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ye wĩĩ ga ba fũhũ nawee- byɛ ye ta wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ye saa ye yĩnyoho neŋ gaa gɛ kɛ laa le na ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","-Ye yii waha, loo le ga ta ye n ba waha cĩĩnde yrã yãã. ");
INSERT INTO xrb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ye ma ba yãã yaliile wo naan miyfa pe Yurusalɛm gbey le, loo yale wo yaa cã, Yurusalɛm yohoyale ne. ");
INSERT INTO xrb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Loo yale wo, mpãy pe ga ba pye Yudɛ wo, pe fã naa n gaha te yãy kuɛ koho na. Mpãy pe ga ba pye Yurusalɛm laam wo, pe fã dey. Mpãy pe ga pye wlɛ wo, pe ma n pa le klo wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yãhã ga ba nawee- sãhã too plii na. Kai- nkãy byɛ ke bii cãã yrũhũ yar yaha Yãhã sabangbãŋ wo, ke byɛ ga pye too plii na. ");
INSERT INTO xrb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Too plii nde na, ca mpãy pe ma laha ne, tesẽ mpãy ne pe ma pii ne pe n wãr, pe fɛn ga ba gboho tɛr. Nawee- ga ba fãy cĩĩnde wãfãy kãntraha nge wo. Yãhã laam ga ba war kãntraha ngefa ne. ");
INSERT INTO xrb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pe ga ba mpãy boo yũntruɛ̃ ne. Mpãy pe ga kuee, pe ga poo yigi fãnga na, pe ga pe cããŋ le wlãhã kãntrahafa byɛ laam wo. Nawee- mpãy pe sẽ cĩĩnde Yãhã cã ye, poo mii ga ba troho tãhã tɛr Yurusalɛm na, koo fãnga n sya ba kua pe ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kakoryar ga ba pye yai kadye wo, yroŋ ne, tesẽ yrompii ne. Kãntraha na, nawee- byɛ ga ba fya muhulangbãŋ wãyɛhɛ mii ne. ");
INSERT INTO xrb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yãhãyĩŋ byɛ ga ba wlãhã nii, ke wãn byɛ n naa n yɛhɛ. Kayĩhĩ nkãy ke ga ba driyɛ̃fa dye, nawee- mpãy ga ba naa koo wĩĩ ga, pe cãã ku fyar koho wo. ");
INSERT INTO xrb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Loo na, nawee- byɛ ga ba u Nawee Puee yãã yãhãsyɔ̃r na, tuu n pai fãnga ne, maha yãhãyĩŋ nayɔ̃r ne kacãn saa pye ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Koo kai- ngĩĩ byɛ ma ba yir wãpyeŋ na, -ye yii waha, ye yĩy kuã yir loo yale wo, ye wãsyayaha yale gbe taha.» ");
INSERT INTO xrb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu n maha pe yar kakuãcran ne ma yee: «Ye sẽ nasar nkugu katyigi yãã la, tesẽ katyir nde byɛ ne? ");
INSERT INTO xrb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yaʼa yãã te wampẽn fe, yaa cã te wãsa yale nɔ gbe taha. ");
INSERT INTO xrb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Koo syi dyaŋ, ye ma kai- ngĩĩ yãã ke n pye, ye -sẽ cã Yãhã Yai wãpa yale gbe taha. ");
INSERT INTO xrb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ta n cĩĩnde nde pãã ye ye: Yagaafa byɛ saa ku tãŋ mii, kai- ngĩĩ sẽ pye poo mpãy yĩnde na ye. ");
INSERT INTO xrb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ke yãhãyĩŋ tesẽ ke kãntraha ne, te ga ba kua kãã te saa ba pye ye. Ta kaplãŋ koo -sẽ na, koo ga nii wãkuayãã saa pye ke na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesu n maha yee: «-Ye naa yii yigi gbar ne, sẽnwɔr ne, tesẽ driyɛ̃ nge laangar ne. Mii loo sẽ ne ye, too nde byɛ ga ba tɛr ye laam kacãn byɛ ne. Yaʼa yee ye sẽ yii yigi ye, Yãhã kasãhã per ga ba ye fe gbe. ");
INSERT INTO xrb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Le ga ba nii mii jɔɔ dyaŋ pe par yaha, ke n too tã kãntrahafa kur byɛ na. ");
INSERT INTO xrb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ye ma syi ye sã wãy faha ye, -ye naa Yãhã nar yalebyɛ! Loo ya ga waha ta ye n fãnga yãã kai- ngĩĩ na, ke ma ba dye, ye waha fɛr sya, ye ba yɛr u Nawee Puee yahasee ye.» ");
INSERT INTO xrb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yai na, Yesu naa nawee- klaha Yãhã kangbãŋ wo. Yai ma -sẽ ba kua, u ga tɛr, u ga syã wolifyɛ katyir yãŋ yĩŋ kãnkãy na. ");
INSERT INTO xrb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yũhũ ma syii, sukũhũntãy pẽmpẽm na, nawee- byɛ naa n pai ke Yãhã kangbãŋ wo, ma ba naa n luhu u ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yiifee- gbar tii pe n yee syayaha gbar, te ba dye gbe taha. Pe maha naa te gbar yee gbar rii ncasur bur sẽ n di ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yãhã yũndefa yĩŋfa tesẽ Yãhã kaiyarfa ne, pe naa Yesu wãboo wĩĩ kɛ, ma -sẽ ba fya pe klofa na. ");
INSERT INTO xrb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Le -sẽ nde, Yuda wii pe naa u yee Syikaryɔte, Setane n dye u laam wo, ma u yĩŋ wã klaha. U pye Yesu kãnyãrwai sẽnsye syãm mii waa. ");
INSERT INTO xrb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda n ka, maa pãã ta pe Yãhã yũndefa yĩŋfa ne tesẽ ke Yãhã kangbãŋ sẽŋfa yĩŋfa ne, tuu ga waha Yesu yi pe kẽ mii syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Le n tãy pe ye, pe n yee pe ga ba u kẽ war yɛ̃ gaa ne. ");
INSERT INTO xrb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda n le sya, ma nii n yãŋ u ga waha Yesu yi pe kẽ mii syi dyaŋ, pe klofa ma n yi le cãŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Te gbar rii Yiifee- sẽ ncasur bur di ye, te n ba nɔ. Koo per cir nawee- yai pe mbapĩy boo, pe te syayaha gbar dir di. ");
INSERT INTO xrb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu n Pyar lɛhɛ wãã loo na Nsãn ne, ma pe pye ma yee: «-Ye ka yaa syayaha gbar dir yĩntaha yi wo kẽ!» ");
INSERT INTO xrb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pe n u yey ma yee: «Ma yee wo ga te yĩntaha yi fla ngii na?» ");
INSERT INTO xrb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","U n pe yar ma yee: «-Ye yãŋ, ye ma ga n dye Yurusalɛm laam wo, ye ga dya waa wãã sya lakugbãi ne tuu tẽŋ yĩŋ na. -Ye naa n taha u na! U ma ga dye kaha gii wo, -ye dye! ");
INSERT INTO xrb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","-Tee u kahafua pye ye yee: ‹Wo Yĩŋfua yee, nwoŋ gii tuu ga syayaha gbar dir di u kãnyãrwai ne, ke ma na?› ");
INSERT INTO xrb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U ga ye yar nwongbãŋ gaa na, ke kaha gbegbaha yĩŋ na. Yaa ke nwoŋ yãã ke laam ne, ke gbihi ta nii wa. Koo fla kẽ tee ga te dir yĩntaha yi wo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesu tuu ba cãã pe yar yaha mii, pe n ka maa yãã koo syi, ma te syayaha gbar dir yĩntaha yi. ");
INSERT INTO xrb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sediyale n ba nɔ, Yesu n nii, ma ga di u tẽnlɛhɛ sẽnsye syãm ne. ");
INSERT INTO xrb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","U n pe pye ma yee: «Tẽ ga syayaha gbar dir nde di ye ne, n cã ra fɛngbãn sya, le sroŋ tãy ra ye! ");
INSERT INTO xrb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta n ye yar, n saa maha te syi raa di ye ne mii nde yĩntaha sẽ ba yi wa Yãhã yai klo wo ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","U n defĩĩ sekuyĩĩ gbe, ma syaha wãã Yãhã kẽ ma yee: «-Ye sekuyĩĩ nde sya, ye wɔ ye byɛ! ");
INSERT INTO xrb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta n ye yar, ma gbe yagaa na n saa defĩĩ wɔ yãã mii Yãhã Yai sẽ ba pa wa ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Loo kur ye, u n bur gbe, ma syaha wãã Yãhã kẽ, ma ke la cɛr wãã pe kẽ ma yee: «-Ye sya di, ke ma ta kadye draha wo, ta kadye gii ke wãã ye wĩĩ na. -Tee ba naa koo syi pye, ke syi ne ye saa faha yãã ra wĩĩ ne ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pe wãdiŋ kur ye, u n maha le defĩĩ sekuyĩĩ wãã pe kẽ pe n wɔ. U n yee: «Defĩĩ nwo ma Yãhã naambiyãrfãn. Too naambiyãrfãn n waha le ye wĩĩ na, ta ntɔ̃r wãwoo kãmay na. ");
INSERT INTO xrb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","-Ye yãŋ, wii tuu ga ba dur yi ra kur ye, u ra yi ta napĩĩ- kẽ, ufua ma nwo tuu wãã n di ra ne! ");
INSERT INTO xrb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cĩĩnde ne, u Nawee Puee ga ku mii le ta mii syi dyaŋ. Wii fɛn te -sẽ ga cã pee, woo kẽ wii ne tuu u yi u napĩĩ- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pe n nii pe ya yey ma yee, poo laam wo yoo kẽ tuu ga ba loo pye? ");
INSERT INTO xrb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Loo kur ye, pe kãnyãrwai n nii kaplãŋ tyĩn pe ya ne, poo ga cã, yoo woo u ma yĩŋ na poo laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu n pe pye ma yee: «Kãntraha nge wo, mpãy pe ma yĩŋ na, nawee- byɛ n luhu pe ye. Poo mpãy pe -sẽ ma fãnga ne pe nawee- yĩŋ na, pe maha n yãŋ pe naa pe yee naweeyɔ̃m. ");
INSERT INTO xrb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ye wĩĩ wee koo syi dyaŋ ye. Wii u tɛr ye byɛ yaha, ufua yai u nii mii ye cĩĩfua dyaŋ. Wii tuu -sẽ ma ye byɛ yĩŋ na, ufua yai u nii mii ye byɛ tẽntẽle dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ye sẽ yãã, wii tuu tege nii sedisaha wo, tesẽ wii ne tuu te dir soho n pai, yoo woo u ma yĩŋ? Wii tuu tege nii sedisaha wo, woo sẽ na u ma yĩŋ? Ndoo woo na tesẽ yii ne, ndoo ma mii ye tẽntẽle dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yii poo na, tẽ pye wãfãy na, ye sẽ yi yãã ra kur ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Koo kẽ, ta Tuhufua Yãhã tuu ke Yai yĩnfar ta ra kẽ mii syi dyaŋ, ta bya n ga ke ta ye kẽ koo syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","N ma ba nii ta yĩnfar na Yãhã yai klo wo yaliile wo, waa ba naa n di wii na, too naa n wɔ wii na ye ne. Ye ga ba nii nangbãniisar wo, ye Yiisrɛ ter sẽnsye syãŋ ngĩĩ nawee- byɛ sãhã.» ");
INSERT INTO xrb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu n Syimu Pyar yee ma yee: «Syimu, naa n luhu! Mii pe sepua wee ma sẽmuhu yi n kãã u wo mii, Setane ye nar sya Yãhã ye, woo ga ye wee yãŋ ke syi. ");
INSERT INTO xrb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","N -sẽ Yãhã nar ma kẽ, ta wĩĩ le waha nii gbãã ma laam wo. Maʼa ba dur n taha ra na, mpãy pe n yãr ra kãnde wo, ma -sẽ fãnga le pe na pe n waha kuee ra kur ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pyar n u pye ma yee: «Tẽ ma teelii wo yagaa, n ga waha ka ma ne nwompihi wo, n sya ku ma ne.» ");
INSERT INTO xrb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu n u yɛ̃ sya ma yee: «Ta n cãã le pãã ma ye, Pyar: Yĩmper nge wo, ngupuai saa ba kui wa ye, maa ba ra wĩĩ kai tɛhɛ tãã, ma yee ma sẽ ndoo cã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu n maha ba pe pye ma yee: «Tẽ ba ye lɛhɛ wãã faale wo, ye sẽ ba war gbe ye, ye sẽ ba nkãnfaha gbe ye, ye sẽ ba ntãy gbe ye. Tee ka ke dyaŋ, ngaa ga kɛ laa la ye ye?» Pe n yee, a ngaa sẽ ga kɛ laa poo ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Loo na, Yesu n pe pye ma yee: «Yagaa, wii ma pye war ne, u pe gbe, wii ma pye nkãnfaha ne, u ke gbe yigi. Wii ma yee u wee naanmiy yũntrũhũ ne ye, u ga u nayrengbãŋ par, -tuu ga koo yũntrũhũ gaa kɛ par! ");
INSERT INTO xrb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ye sẽ yãã, ta n le pãã ye ye, kai laa ma Yãhã sabangbãŋ wo, le bii yrũhũ yaha ra wĩĩ na, le yai le pye. Loo kai ne nde: ‹Pe u tɔ̃r kapeepyefa ne wãcɛŋ.› Lii le bii yrũhũ yaha ra wĩĩ na, le ga pye yagaa.» ");
INSERT INTO xrb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pe kãnyãrwai n u pye ma yee: «Naanmiy yũntruɛ̃ raa nde wãy sĩĩ.» Yesu n pe pye ma yee: «Te yai ke dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu n ba yi kaha wo, ma naa n gaha wolifyɛ katyir yãŋ yĩŋ na, peplii wãŋ syi dyaŋ. Pe kãnyãrwai naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pe ga nɔ ke fla na, u n pe pye ma yee: «-Ye Yãhã nar Setane ma n ba ye tyĩn ga kapee- wãpyeŋ kuɛ ye ye!» ");
INSERT INTO xrb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","U n pe ta yaha, ma faa dey pe na, ma ga kãnklũy gbãã kãntraha na, ma nii n pãã Yãhã ne u ya ya. ");
INSERT INTO xrb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","U naa n pãã ma yee: «Ta Tuhufua Yãhã, le ma tãy ma ye, ma le kayĩhĩ yale kuã tɛr ra na, lii le n pai nde. N -sẽ n traha ma laam wĩĩ loo le pye, n sẽ yee ndoo laam wĩĩ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Loo na, yãhãyĩŋ tẽnlɛhɛ waa n yir yãhãyĩŋ na, ma fãnga gaa taha u na. ");
INSERT INTO xrb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu pye fyar koho wo. U n nii Yãhã gbihi n nar fãnga ne. Ntɔ̃r n wlãhã u kasyã ne, ma nii n woo kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tuu Yãhã nar wa, u n yir ma pa u kãnyãrwai fla na. Pe laam ba wlãhã, pe n ba sã wãy. ");
INSERT INTO xrb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","U n pe pye ma yee: «Nwa ye n sã wãy? -Ye yir, -ye naa Yãhã nar ye ma syi ye ba dye kapee- wãpyeŋ wo ye!» ");
INSERT INTO xrb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu naa n pãã nantãŋ, nabuar raa naa n pai. Yuda pye pe yaha ye. Yesu kãnyãrwai sẽnsye syãm mii waa ba kẽ u ne. U n yũhũ crã Yesu na, woo ga naambiyãr syaha wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu n -sẽ u pye ma yee: «Yuda, maa u Nawee Puee syar la naambiyãr syaha ne, ma u yi u napĩĩ- kẽ?» ");
INSERT INTO xrb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mpãy pe pye Yesu ne, pe yãã lii le ga pye, pe n u yey ma yee: «Yĩŋfua, wo nawee- mii gbã la wo yũntruɛ̃ ne?» ");
INSERT INTO xrb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Loo na, poo nen waa n waa kãndigi kuɛ ndityɛ gbã cɛr kãã u kẽ. Yãhã yũndefa yĩŋfua tẽntẽle ba kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu n pe pye ma yee: «Ye tyii, le yai ke dyaŋ.» U n tɛ u dya ndityɛ na, le n jaa. ");
INSERT INTO xrb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yãhã yũndefa yĩŋfa mpãy, tesẽ ke Yãhã kangbãŋ sẽŋfa yĩŋfa ne, tesẽ wãlɛ mpãy ne, pe pa Yesu yigisaha wo, Yesu n pe pye ma yee: «Tee pa ra yigisaha wo yũntruɛ̃ ne tesẽ kãhã ne, kapeepyefua la ra ne? ");
INSERT INTO xrb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Plii byɛ n pye ye ne Yãhã kangbãŋ wo, ye sẽ -sẽ ra yigi koo fla na ye. Yagaa nge na, ye ga waha ye laam wĩĩ pye Setane fãnga ne. Woo kẽ u ma wam fãnga ne.» ");
INSERT INTO xrb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pe n Yesu yigi, ma ka u ne Yãhã yũndefa yĩŋfua kaha wo. Pyar naa n taha pe na deydey. ");
INSERT INTO xrb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Naa pye le ndyin telai wo. Mpãy pe ba nii klaha ke naa tãy, Pyar n nii wlãhã pe ne. ");
INSERT INTO xrb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tẽntẽsya laale n u yãã, tuu tege nii ke naa tãy. U n u gbihi yãŋ ma yee: «Dya nwo bya pye Yesu ne.» ");
INSERT INTO xrb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pyar n le kai, ma sya le pye ma yee: «Cɔɔ, n sẽ u cã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Saa n pye, waa ter n ba u yãã, ma maha yee: «U Yesu nawee- nen waa kẽ ma bya ne!» Pyar n u dya yɛ̃ wãã sya ma yee: «Dya, n wee poo waa ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Le n ma-, waa ter n maha yir, ma le gbey pãã fãnga ne ma yee: «Dya nwo pye pe ne cĩĩnde, u tee n yi Galɛlɛ wo.» ");
INSERT INTO xrb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pyar n maha woo yɛ̃ wãã sya ma yee: «Dya, taa lii pãã, n sẽ le cã ma ne ye.» Loo yale wo, tuu naa n pãã nantãŋ, ngupuai waa n kui. ");
INSERT INTO xrb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yĩŋfua Yesu n wã klaha, ma Pyar yãŋ wãã. Loo na, Pyar laam n too Yĩŋfua kaplãŋ na, kaplãŋ nkãy tuu ba pãã u ye ma yee: «Ngupa cir saa ba kui wa ye, maa ba ra wĩĩ kai tɛhɛ tãã, ma yee mboo sẽ ra cã ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Loo na, Pyar laam byɛ n wlãhã, u n yir yi ma ga n wũn. ");
INSERT INTO xrb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nawee- mpãy pe naa Yesu sẽŋ, pe naa u lɛr, ma maha naa u gbã. ");
INSERT INTO xrb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pe u yĩmpɛ paha naa n tã, ma naa u yey ma yee: «Yoo u ma gbã? Le cã mii ya, -taa wo yar!» ");
INSERT INTO xrb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pe maha naa u tyɛhɛ kaplãmpee busãã ne. ");
INSERT INTO xrb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yũhũ ke ba syii, pe wãlɛ n pe ya wãã pe Yãhã yũndefa yĩŋfa ne, ma suhu Yãhã kaiyarfa ne. Pe n ka Yesu ne pe kaplãŋ cɛrsaha fla na. ");
INSERT INTO xrb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Pe n ga u yey ma yee: «Mboo la u Yãhã Yĩndefua Crise ne? Le pãã wo ye.» U n pe yɛ̃ sya ma yee: «N ma le pãã ye ye ma yee ndoo kẽ u Yãhã Yĩndefua ne, ye ga yee cĩĩnde sẽ ne ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","N ma maha ye yey kayey laa ne, n cã ye saa ra yɛ̃ sya ye. ");
INSERT INTO xrb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma gbe yagaa na, u Nawee Puee ga ba nii kai- byɛ yĩŋ na, Yãhãngbãŋ kãndigi koho kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Loo na, nawee- byɛ n yɛ̃ kuã ma yee: «Yãhã Dya kẽ ma ne kɛ?» U n pe yɛ̃ sya ma yee: «Tee le pãã mii, le ma ke syi.» ");
INSERT INTO xrb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Loo na, pe n le pãã ma yee: «Wo sẽ maha laa kɛ waa ye u wĩĩ na ye, wii gɛ u yɛ̃ kaplãŋ luhu wa!» ");
INSERT INTO xrb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pe nawee- byɛ n yir, ma Yesu yigi ga fãngafua Pilati fla na. ");
INSERT INTO xrb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Koo fla na, pe n nii kawar fua n taha Yesu na ma yee: «Wo dya nwo yãã, tuu naa wo klofa sũũ. U naa pe pye ma yee, a pe sẽ yai kufar wãdãã ne fãngafa byɛ yĩŋfua kẽ ye. U maha naa le pãã ma yee, a woo gɛ kẽ u Yãhã Yĩndefua Crise ne, wii u ma yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilati n Yesu yey ma yee: «Mboo la pe Yiifee- yĩŋfua?» Yesu n u yɛ̃ sya ma yee: «Ma le pãã.» ");
INSERT INTO xrb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilati n pe Yãhã yũndefa yĩŋfa pye tesẽ pe nabuar ne ma yee: «Ta laam wo, dya nwo sẽ laa kapee pye ye.» ");
INSERT INTO xrb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe Yesu napĩĩ- n le gbihi gbey pãã fãnga ne ma yee: «U nawee- sũũ pe yĩŋfa na u kaklaha ne. U cãã yir le ne Galɛlɛ kãntraha wo, ma ga yi Yudɛ kãntraha ne. Yagaa u nwo u sya ba nɔ nwo.» ");
INSERT INTO xrb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilati tuu kaplãŋ ngĩĩ luhu, u n le yey ma yee: «Dya nwo n yi la Galɛlɛ kãntraha fla wo?» ");
INSERT INTO xrb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pe n u yar, a Yesu n yi Galɛlɛ kãntraha wo. U n u nɔ wãã ke fla yahaseefua Yɛrɔte ye. Yɛrɔte pye Yurusalɛm wo too plii nsoho wo, koo kẽ Pilati n ba Yesu nɔ wãã u ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yɛrɔte tuu Yesu yãã, le n tãy u ye. U ba u wĩĩ luhu, ma naa n kɛ u u wãã sya le yale wãdey. U laam wo u ba yee, laa na Yesu ga yɛ̃kã wĩĩ laa pye, u n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","U n Yesu yey kayey buar ne, Yesu sẽ -sẽ laa wãã sya u ye ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pe Yãhã yũndefa yĩŋfa tesẽ pe Yãhã kaiyarfa ne, pe pye ke fla na, ma kawar fua naa n taha Yesu na fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yɛrɔte tesẽ u seraasyi ne, pe n Yesu lɛr ma u pye nafla wãpyeŋ. Pe la pe nangbãŋ nayreyũhũ le u na, ma u dur wãã Pilati ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yɛrɔte tesẽ Pilati ne pe pye napĩĩfa. Koo per, pe n wã klaha nii naambiyãfa. ");
INSERT INTO xrb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Loo kur ye, Pilati n pe Yãhã yũndefa yĩŋfa wãã, tesẽ le klo yahaseefa ne, ma suhu pe klofa ne. ");
INSERT INTO xrb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","U n pe pye ma yee: «Ye dya nwo yigi ba ra fla na ma yee, u ma u nawee- sũũ. Tee nkãy byɛ pãã taha u na, n u yey ye yĩnde na. Ndoo laam wo, u sẽ laa kapee pye ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Yɛrɔte bya sẽ laa kapee yãã tuu pye ye, ma sya u dur wãã wo kẽ. Ye cã dya nwo sẽ laa kapee pye, pe n ga waha u boo le wĩĩ na ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Loo na, n ga ta pe n u gbã sãngblã ne, tẽ u miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Dyɛ- byɛ, syayaha gbar na, Pilati yai u nwompihifua waa yi yaha Yiifee- kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pe byɛ n nii wãã n tẽ ma yee: «Ta, pe n dya nwo boo, -taa Barebaa woo yi yaha wo kẽ!» ");
INSERT INTO xrb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barebaa ba nawee- mpãy ta pe n wãã yahaseefa ne. U maha ba nawee nen waa boo yãã. Pe ba u Barebaa yigi loo na, ma u tã nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati tuu naa Yesu wãyiyaha wĩĩ kɛ, u n maha u faale kapãntee nen ya pãã pe nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pe n sye, ma nii n tẽ ma yee: «U kuey mar boo trã na, u kuey mar boo trã na!» ");
INSERT INTO xrb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilati n maha yɛ̃ kuã ma le pãã ke tɛhɛ tãã wuhu na, ma pe pye ma yee: «U kapee lii pye? Ndoo sẽ laa kapee yãã tuu pye ye. U sẽ yai u ka boo ke dyaŋ ye. Loo na, n ga ta pe n u gbã sãngblã ne, tẽ u miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pe n maha sye, ma nii n tẽ fãnga ne ma yee, pe Yesu kuey mar boo trã na. Le n sya kuee pe wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilati n yɛr pe wĩĩ wãpyeŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pe naa Barebaa wii wãyiyaha kɛ, Pilati n u yi yaha. Woo kẽ dya wii ne u ba ta wãhã n yir u n sya nawee boo, pe n u le nwompihi wo. Yesu woo na, Pilati n yee pe nawee- laam wĩĩ ga pye u na. ");
INSERT INTO xrb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pe seraasyi pe Yesu yigi naa n tɛr, pe n ga le klo yi yaha, pe nawee- ne. Pe n ga Syirefa naa waa wãã sya, tuu naa n gaha le klo laam wo. Pe seraasyi n u ta u n Yesu kueymartrã tẽŋ fãnga na, ma n taha Yesu na. U myaha ba kẽ Syimu. ");
INSERT INTO xrb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pe klofa busãã naa n taha Yesu na, ca bya pye pe naa Yesu wĩĩ wũn. ");
INSERT INTO xrb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu n wã klaha, ma pe pye ma yee: «Yurusalɛmfasyam, ye ma syi ye naa n wũn ndoo wĩĩ na ye! -Ye naa ye wĩĩ loo wũn tesẽ ye pii wĩĩ ne! ");
INSERT INTO xrb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ye sẽ yãã, plii taa ma te n pai, nawee- ga ba naa n yee: ‹Cayrey, ma suhu mpãy ne pe sẽ yrã ta yãã kicar kẽ ye, poo ca mii, pe wĩĩ n tãy!› ");
INSERT INTO xrb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nawee- ga ba naa n yee: ‹Yãy gɛ ma too tã wo na, loo ga puar wo na. Yãybir nde gɛ ma gbe tã wo na, loo ga tãy wo ye!› ");
INSERT INTO xrb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ye sẽ yãã, nde le syi le n pye nankɔ̃mper na, nankɔ̃nwar wĩĩ loo -sẽ ga ba pye mii?» ");
INSERT INTO xrb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Naam syãm mpãy maha ba pye, pe ba pe yigi pe n gaha pe boo Yesu ne. Kapeepyefa ba me pe ne. ");
INSERT INTO xrb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pe n ga nɔ fla ngaa na pe n yee yĩnkluhu fla. Pe seraasyi n Yesu kuey mar yir yaha trã na koo fla na, ma maha pe kapeepyefa syãm mii bya kuey mar yir yaha trãŋ na, nen nwo u kãndigi koho kuɛ ye, nen nwo u kãmaŋ koho kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Loo na, Yesu n yɛ̃ kuã ma yee: «Ta Tuhufua Yãhã, pe kapee- yee laha kãã pe na; lii pe n pye ra na nde, pe sẽ le cã ye.» Pe seraasyi n pyer raa pye, ma ga cã yoo ga ka u nayrɛ wãn fai lii ne. ");
INSERT INTO xrb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pe klofa pye pe ba yɛr, ma naa n yãŋ. Pe Yiifee- yahaseefa naa Yesu lɛr ma yee: «Pe sẽ yee la u nawee- mpãy sya yaha. Le ma pye cĩĩnde woo kẽ u Yãhã Yĩndefua Crise, u u ya sya yaha kɛ!» ");
INSERT INTO xrb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pe seraasyi bya n nii u lɛr. Pe n yũhũ crã u na, ma defĩĩtãhãpihi ta u kẽ ma yee: ");
INSERT INTO xrb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Maʼa pye Yiifee- yĩŋfua cĩĩnde, mii sya yaha mii ya!» ");
INSERT INTO xrb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","U yĩŋ ncaha kuɛ ye le trã na, pe ba le yrũhũ gbãã yaha ma yee: «nwo kẽ u yiifee- yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kapeepyefa mpãy pe ba kuey mar yaha trãŋ na pe ya wuhu na, poo nen waa n Yesu tyɛhɛ ma yee: «Ma -sẽ yee la ma ma u Crise, mii sya yaha mii ya, -taa wo sya yaha kɛ!» ");
INSERT INTO xrb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","U nen nwo n le kuãn u ye, ma u pye ma yee: «Pe ma kuey mar trã na u wãŋ syi dyaŋ, ma n ga ku ma kapee- wãpye wĩĩ na, ma sẽ maha n fya Yãhã na ye kɛ? ");
INSERT INTO xrb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wii ya dyaŋ pe wo kuey mar trãŋ na wo n ga ku, le yai wo ne. Kapee- nkãy too pye, koo foho kẽ too n dãã. Woo -sẽ yãŋ, u sẽ laa kapee gɛ pye ye.» ");
INSERT INTO xrb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","U n dur ma Yesu pye ma yee: «Yesu, maʼa ba nii nawee- byɛ yĩŋ na, maʼa n ba faha ra wĩĩ na ye.» ");
INSERT INTO xrb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu n u yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ma ye: Ma sukũhũ yãã wa Yãhã yai klo wo ra ne nanga.» ");
INSERT INTO xrb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yaiwlaŋ yale syi ba kẽ, wam mpãy syi n paha tã ke kãntraha kur byɛ na, ma sya ga yai yĩn. Yãhã kangbãŋ nwonuŋ nwonyɛ̃ faasrɛŋ gii ke ba pua tã menmen ke nwonyɛ̃ na, ke n fe jũũ telai wo. ");
INSERT INTO xrb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu n tẽ sya fãnga ne ma yee: «Ta Tuhufua Yãhã, n ta yrã le soho ma koho wo.» Tuu kaplãŋ ngĩĩ pãã wa, u n ku. ");
INSERT INTO xrb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pe seraasyi yĩŋfua tuu kai- ngĩĩ yãã ke pye, u n Yãhã myaha gboho ma yee: «Dya nwo ba sroŋ cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nabuar mpãy byɛ pe ba pa yãŋsaha wo, pe n ke kai- byɛ yãã yĩnde ne. Le sẽ tãy pe ye ye, pe n sya gbã n le pe ya kẽ ntraŋ wo, ma dur n tɛr. ");
INSERT INTO xrb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu nacãŋ byɛ pye, tesẽ ca mpãy ne pe ba yir u ne Galɛlɛ kãntraha na, ma naa n taha u na ma naa tẽŋ nkãy tẽ u kẽ u kãnyãrwai ne. Poo mii byɛ pye, pe ba dey yɛr ma naa ke kai- yãŋ. ");
INSERT INTO xrb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Dya waa pye pe naa n yee Yosɛfe. U naa n yi Yiifee- klo laa wo pe naa n yee Yarimate. Woo dya pye naweeyɔ̃, ma maha ba sroŋ. U laam wo u naa Yãhã Yai wãpaŋ yɛhɛ. U pye Yiifee- yahaseefua waa, ma pye pe kaplãŋ cɛrfa waa. U kaplãŋ cɛrwai pe -sẽ ba lii pãã ta Yesu wãboo wĩĩ na ma sya ba le pye, u yɛ̃ sẽ pye le wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","U n yir, ma ka Pilati fla na, maa Yesu nakugu nar u ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","U n ta pe n Yesu nakugu tege le trã na, ma fai maha tã ke na, maa ke le gbĩĩ laa laam wo, le ba gbã fer ntẽmblaha fla wo. Waa sẽ ba le yãã wa loo gbĩĩ wo ye. ");
INSERT INTO xrb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Koo per -sẽ pye kanii per ga dye koo yainkɔŋ wo. Nawee- yai pe cãã kanii per kai- gbihi yai n cã kua. ");
INSERT INTO xrb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ca mpãy pe ba yir Yesu ne Galɛlɛ kãntraha na, ma naa n taha u na, ma naa tẽŋ tẽ u kẽ u kãnyãrwai ne, pe n ka Yosɛfe ne. Pe n ga le gbĩĩ fla yãŋ, ma Yesu nakugu yãã, tesẽ u wãleŋ ne le gbĩĩ laam wo. ");
INSERT INTO xrb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pe n dur tɛr klɛ wo, maa sẽm- kɛ gbihi ta, lasekole ne, poo ga ba woo Yesu nakugu na. Ke kanii per ke ba nɔ, pe ca n -sẽ nii ma wũũ. Yiifee- kãnde na, le ma ke dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ke cãwãã per cir yĩnwɔŋ wo, pe ca n cãã yir, ma ka le gbĩĩ fla wo, pe sẽm- mpãy ne pe ba pye gbihi ta pe lasekole ne. ");
INSERT INTO xrb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ntẽmbangbãŋ gii ke ba paha tã le gbĩĩ yɛ̃ na, pe n ga yãã le kloŋ kãã le gbĩĩ yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pe n dye le gbĩĩ laam wo, pe sẽ -sẽ Yĩŋfua Yesu nakugu yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pe ca pe ga lii ga, pe sẽ cã ye. Naam syãm mpãy n fe yi pe na, pe nayrɛ ne te n yɛhɛ palpal. ");
INSERT INTO xrb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pe ca ba fya nii, ma yĩŋ kor le. Pe naam n pe pye ma yee: «Wii u ma yrãŋ, nwa ye n ba nii u tay nakur nsoho wo? ");
INSERT INTO xrb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","U wee nwo ye. U yir gbã wo, ma dur ba yrãŋ na gbaafa ye. Tuu pye Galɛlɛ wo, ma ba lii pãã ye ye, -ye ye laam too le na. ");
INSERT INTO xrb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U sẽ ba yee la u Nawee Puee yai u yi kapeepyefa kẽ, pe n ba u kuey mar trã na u n ku, tuu ba yir gbã wo, u dur ba yrãŋ na ke plii tãã wuhu na?» ");
INSERT INTO xrb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Loo na, pe ca laam n cã too Yesu kaplãŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pe n tɛr le gbĩĩ fla yaha, ma ga le pãã pe kãnyãrwai sẽnsye nen ye, tesẽ mpãy byɛ ne pe naa n taha Yesu na. ");
INSERT INTO xrb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Poo ca mii laam wo, Madalafa Maari pye, Syane ne, tesẽ Syake nahafua Maari ne. ");
INSERT INTO xrb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pe kãnyãrwai n yee, pe ca ka n pãã, ma sye pe sẽ pe kaplãŋ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pyar woo n sye, ma yir ma fã ga le gbĩĩ fla na. U n kuɛ tege, ma yãŋ le wãã le gbĩĩ laam wo, ma te faasyĩmbɛhɛ ya yãã, tii pe ba Yesu nakugu maha tã. Tuu ga lii yãã yĩnde ne, le n laam wɔ u kẽ, u n dur tɛr kaha wo. ");
INSERT INTO xrb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Koo per bya, Yesu kãnyãrwai syãm mpãy naa n gaha kusyĩnlaale wo pe n yee Yemawuse. Le klo wãdey pye, maʼa yir Yurusalɛm wo yaiyĩn na, ma n gaha dye ke fla wo yainkɔŋ wo. ");
INSERT INTO xrb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kai- nkãy byɛ ke ba pye, pe koo pãã naa n gaha. ");
INSERT INTO xrb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pe n nii n pãã, Yesu gɛ n ba wãã kũn n tɛr pe ne. ");
INSERT INTO xrb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pe n nii u yãã, le -sẽ nii mii laa dyaŋ pe sẽ maha u yãŋ cã ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu n ba pe yey ma yee, «Lii tee n pãã le kãnde wo?» Pe laam n wlãhã, pe n yɛr. ");
INSERT INTO xrb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nen waa myaha ba kẽ Klɛpasyi. U sẽ cã Yesu ye ma yee: «Kai- nkãy byɛ ke pye tɛr plii nde na, Yurusalɛmfa byɛ le cã. Mboo ya la raa kuee, ma sẽ ke cã ye?» ");
INSERT INTO xrb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu n pe yey ma yee: «Kai- nkãy syi kẽ?» Pe n u yɛ̃ sya ma yee: «Ah Nasarɛtefa Yesu wĩĩ loo sẽ na? U pye Yãhã kaplãŋ tɔ̃rfuangbãŋ. Yãhã yĩnde na nawee- ne, u naa laanwɔ wũhũ pye, ma naa nawee- klaha. ");
INSERT INTO xrb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wo Yãhã yũndefa yĩŋfa tesẽ wo yahaseefa ne, pe u ka yigi sãhã ma yee u yai wãboo ne. Pe n u wãã, pe n ga u kuey mar trã na, u n ku. ");
INSERT INTO xrb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wo laam wo, wo ba yee woo tuu n pai wo Yiisrɛfa byɛ sya yaha. Kai- ngĩĩ byɛ pye, ke plii tãã wuhu -sẽ kẽ nanga. ");
INSERT INTO xrb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ca mpãy pe naa n taha Yesu na wo wãŋ syi dyaŋ, pe n pa, maa wo sroŋ fe gbe laa ne. Nanga sukũhũntãy na, pe cãã yir ga le gbĩĩ fla wo, ");
INSERT INTO xrb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pe sẽ -sẽ ga Yesu nakugu yãã ye. Pe n dur ba, maa wo pye ma yee, yãhãyĩŋ tẽnlɛhɛ mpãy yi poo na, ma pe pye ma yee Yesu ma yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wo nampyeŋ- mpãy n ka le gbĩĩ fla wo, maa yãã pe ca ba le pãã mii. Pe sẽ -sẽ Yesu yãã yĩnde ne ye.» ");
INSERT INTO xrb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Loo na, Yesu n pe pye ma yee: «Yii nawee-, ye kacãn fĩhĩ kloŋ cĩĩnde! Faale Yãhã kaplãŋ tɔ̃rfa pe kai- nkãy cãã yar yaha, ye laam fĩhĩ yĩn tɛr, ye saha ke sya cĩĩnde ye laam wo farfar ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","U Yãhã Yĩndefua Crise sẽ yai la u koo wãfãy ngĩĩ byɛ sya, u cã yĩŋ yãã Yãhã ye?» ");
INSERT INTO xrb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kai- nkãy byɛ ke cãã yrũhũ yaha u wĩĩ na Yãhã sabangbãŋ laam wo, Yesu n dye ke wo ma ke byɛ tɔ̃r yar pe na, ma cãã gbe faale wãdyaha Musa kaplãŋ fla wo, ma ga yi pe Yãhã kaplãŋ tɔ̃rfa mii byɛ kaplãŋ fla wo. ");
INSERT INTO xrb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pe naa n gaha kusyĩnde lii wo, pe n ga dye gbe taha, Yesu n ta mii u ga ta tɛr ga yahasee ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pe n sye u na, ma u pye ma yee: «Kuee, ma syã wo ne, yai kua wa, yĩmper maha nge ke wɔ wa.» Yesu n dye kaha wo ke wãsyã wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","U n ba nii pe ne, ma ga di. U n bur gbe, ma cãã syaha wãã Yãhã kẽ, ma ke bur la cɛr ma wãã pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Loo na, pe yĩntar n cã yãr, pe n u yãŋ cã ma yee Yesu kẽ. U n plaha pe na le yalebya wo, pe sẽ maha waha u yãã ye. ");
INSERT INTO xrb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pe n nii pe ya pye ma yee: «Tuu naa n pãã wo ne kãnde wo, ma Yãhã sabangbãŋ wũhũ tɔ̃r naa n yar wo na, le sẽ pye la mii nuhu cãã- dyaŋ ke naa n tar wo laam wo?» ");
INSERT INTO xrb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pe n yir ke fla byɛ wo, ma dur tɛr Yurusalɛm wo. Pe n ga pe Yesu kãnyãrwai sẽnsye nen yãã pe pye pe nampyeŋ- mpãy ne. ");
INSERT INTO xrb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Poo kãnyãrwai naa le pãã ma yee: «Wo Yĩŋfua yir gbã wo, ma dur ba gbaafa ye cĩĩnde! Syimu u yãã yĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Poo syãm bya n -sẽ pe wĩĩ pãã pe ye, lii le ba pye kãnde wo, tesẽ pe ba Yesu yãŋ cã yaliile wo tuu bur la naa n cɛr pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pe naa n pãã nantãŋ, Yesu n fe gbe yi pe telai wo, ma pe pye ma yee: «Yãhã n yrĩŋ wãã ye kẽ!» ");
INSERT INTO xrb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pe n fya ma sya n sege. Pe laam wo pe ba yee kusrãhã kẽ. ");
INSERT INTO xrb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu n -sẽ pe pye ma yee: «Nwa ye n fya? Lii gɛ ye n nii laalaa pye ra wĩĩ na? ");
INSERT INTO xrb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","-Ye ra kluɛ yãŋ kɛ, ta trɛ ne. Ndoo gɛ kẽ! -Ye tɛ yãŋ ra na, kusrãhã ma la kadye ne ye n ga waha tɛ ke na ta dyaŋ?» ");
INSERT INTO xrb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tuu koo kaplãŋ ngĩĩ pãã wa, u n u kluɛ yar pe na u trɛ ne, pe n te kueysar yãã. ");
INSERT INTO xrb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Le n pe fe gbe, ma nuhu yigi tɛr pe kẽ pe n sya yee cĩĩnde sẽ ne ye. Yesu tuu pe yãã ke dyaŋ, u n pe yey ma yee: «Ngaa ma la ye ye wãdi wãŋ nwo wo?» ");
INSERT INTO xrb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pe n pa u kẽ fuawle ne. ");
INSERT INTO xrb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U n le sya, ma le kaa pe yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","U n pe pye ma yee: «Tẽ pye ye ne nantãŋ, n sẽ naa ye yar la ma yee, kai- nkãy byɛ ke bii cãã yrũhũ yaha ra wĩĩ na, koo ngĩĩ byɛ ga naa n pye ke sya ba kua? Koo kai- kẽ nkãy ne, wo faale wãdyaha Musa bii cãã yrũhũ yaha Yãhã kãnde kataŋ saba laam wo, tesẽ nkãy byɛ ne pe faale Yãhã kaplãŋ tɔ̃rfa bii cãã yrũhũ yaha, tesẽ nkãy ne ke bii cãã yrũhũ yaha Yãhã wãsey yay saba wo.» ");
INSERT INTO xrb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","U n pe yĩntar yãr ke syi, pe n waha ke Yãhã sabangbãŋ kaplãŋ war. ");
INSERT INTO xrb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Loo na, u n pe yar ma yee: «Nkãy ke yrũhũ yar yaha ke ngĩĩ: ‹U Yãhã Yĩndefua Crise yai u fãy gboho, u ba ku, ke plii tãã wuhu u yir gbã wo, u dur ba yrãŋ na gbaafa ye.› ");
INSERT INTO xrb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kai- nkãy tuu naa n yar nawee- na, ke yai ke ba klaha kãntrɛ byɛ nawee- ye, u myaha ne. Le ga fe gbe Yurusalɛm na. Le ga ba yar nawee- na, pe yai pe le sya pe kapee- wãpyeŋ sẽ yɔ̃ ye, pe ke miy yaha, woo -sẽ ga ba pe kapee- gbe kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yii koo ngĩĩ byɛ yãã yĩnde ne, ye yai ye ke byɛ tɔ̃r yar nawee- na. ");
INSERT INTO xrb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yãhã ke bii Yãhã Yrã Fãnga gii wãkẽ wĩĩ pãã, ndoo gɛ ga ba ke tege wãã ye na. Ye yai ye -sẽ kuee ke Yurusalɛm laam wo, koo Fãnga n sya ba tege ye na.» ");
INSERT INTO xrb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Loo kur ye, Yesu n yi pe ne le klo wo, ma ka pe ne kusyĩnlaale tãy pe n yee Gbetane. U n ga yɛr pe ne koo fla na, ma kluɛ kuã yir wãã, ma Yãhã nar ke naa kaa taha pe na. ");
INSERT INTO xrb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tuu nii Yãhã nar u kãnyãrwai kẽ ke syi, Yãhã fãnga n u ta u n kuã yir tɛr fãã yãhãyĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pe kãnyãrwai n u sey ke fla na. Nuhu ba gboho pe laam wo, pe n dur tɛr Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pe naa n gaha yalebyɛ ke Yãhã kangbãŋ laam wo, maa naa Yãhã sey.");
INSERT INTO xrb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Driyɛ̃ wãtãhã yaha, wii tuu ma Yãhã Yɛ̃ Yor u pye lɛ nii wa. U pye Yãhã ne, woo gɛ pye Yãhã. ");
INSERT INTO xrb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ke fegbecãã na, u pye Yãhã ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Woo kãmay na wãn byɛ tãhã; ngaa wee yĩnde na mii woo sẽ kẽ u ta ke n nii ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Woo u ma yrã, yrãŋ wãn byɛ ye, loo yrã n nii cãã- nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Woo wii u ma pe Cããfua, u ba dye wamfa nsoho wo, pe wamfa -sẽ pe cãã- wĩĩ sye. ");
INSERT INTO xrb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yãhã n ba dya waa nɔ wãã, pe naa u yee Nsãn. ");
INSERT INTO xrb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Woo n pa ma ba u Cããfua wĩĩ gbe yi nawee- ye, pe waha u Cããfua ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","U Nsãn woo sẽ kẽ tuu pye u Cããfua ye; woo kẽ Yãhã u nɔ wãã ma yee u ba u Cããfua wĩĩ tɔ̃r yar nawee- na. ");
INSERT INTO xrb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Woo Cããfua nwo ma cĩĩnde cãã- ne. Woo kẽ tuu pa driyɛ̃ wo, ma nii cãã- le nawee- wo. ");
INSERT INTO xrb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Woo kẽ, Yãhã driyɛ̃ tãhã u kãmay na. U pye driyɛ̃ laam wo, pe driyɛ̃fa sẽ ba u yãŋ cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U pa u terfa ye, u terfa sẽ -sẽ ba u sya ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mpãy pe -sẽ u wĩĩ sya cĩĩnde, ma u ta pe Yatɛr, u koho klahasaha wãã poo kẽ, pe waha nii Yãhã pii. ");
INSERT INTO xrb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Poo mpãy pe see ke syi, waa ntɔ̃r kalaa wee ye, waa tyãhã kalaa wee ye, waa syihi wĩĩ sẽ ne ye, Yãhã wĩĩ ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yãhã Yɛ̃ Yor wã klaha nawee, woo kẽ Yãhã Dya Yesu Crise ne. U n tege ba nawee- nsoho wo. U pa Yãhã laantãr wũhũ ne, tesẽ cĩĩnde wũhũ ne, wãkuayãã wee te na ye. Wo sẽ u nayɔ̃r yãŋ naa n yai ye, nayɔ̃r tii syi Yãhã Dyapuai nen ya kẽ u ga waha te yãã u Tuhufua Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nsãn u wĩĩ tẽ yi nawee- ye ma yee: «Woo wĩĩ kẽ tẽ ba pãã ma yee: Wii tuu ga pa ta kur ye, u cɛr yaha ra kẽ, u cãã pye lɛ nii wa ra yaha.» ");
INSERT INTO xrb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wãkuayãã wee u laantãr wũhũ na ye. U ke wãã wo kẽ, ma maha kaa taha wo na, wãkuayãã wee ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wo faale wãdyaha Musa bii ke Yãhã kãnde yar wo na. Ma sẽ yee ke laantãr wũhũ na, tesẽ ke cĩĩnde wũhũ ne, u Yãhã Yĩndefua Yesu Crise woo kẽ tuu pa koo ngĩĩ ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Waa sẽ Yãhã yãã yãã ye, Yesu wii u ma ke Dyapuai nen ya, ma maha ma Yãhã, ma crã nii Yãhã tãy, woo kẽ tuu Yãhã wĩĩ gbe yi nawee- n ke cã. ");
INSERT INTO xrb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Le kungbãy Yurusalɛm laam wo, pe Yiifee- yahaseefa pye. Pe n Yãhã yũndefa mpãy lɛhɛ wãã, tesẽ Lewi kur kuɛ pii mpãy ne Nsãn ye. Pe n yir ke Yurusalɛm wo, ma ga yi u Nsãn na, ma u yey ma yee: «Nwasyifua kẽ ma ne?» ");
INSERT INTO xrb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","U Nsãn sẽ gbã tã pe na ye, u n le tɔ̃r yi gbɛgbɛ pe yĩnde na ma yee: «Ndoo sẽ kẽ u Yãhã Yĩndefua Crise ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pe n maha u yey ma yee: «Ah nwasyifua -sẽ kẽ ma ne? Mboo la Yeli?» Nsãn n pe pye ma yee: «Aye, ndoo sẽ kẽ ye.» Pe n maha u yey taha ma yee: «Mboo la u Yãhã kaplãŋ tɔ̃rfua?» U n maha yee: «Aye». ");
INSERT INTO xrb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pe n u yey taha yahamba ma yee: «Ah nwasyifua -sẽ kẽ ma ne? Wo yai wo laa loo cã ma wĩĩ na, wo ga tɔ̃r mpãy ye pe wo lɛhɛ. Mii tɔ̃r wo yar nawee wii ter syi kẽ ma ne.» ");
INSERT INTO xrb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nsãn n pe pye ma yee: «Yãhã kaplãŋ tɔ̃rfua Yisa bii le pãã yaha Yãhã sabangbãŋ wo ma yee: ‹Waa yĩmbui n yi drawaha fla wo, ma nii n yee: -Ye Yĩŋfua Yãhã wãpaŋ kãnde gbihi yaha ke kẽ!› » Nsãn n maha le pãã pe ye ma yee: «Yĩmbui lii le n yi drawaha fla wo, ndoo yĩmbui ne.» ");
INSERT INTO xrb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pe tẽnlɛhɛ mpãy pe lɛhɛ wãã Nsãn ye, Yiifee- yahaseefa mpãy pe n yee Farisyɛ̃, poo mpãy -sẽ pye pe ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Poo mii n u yey ma yee: «Ke ma pye ma wee u Yãhã Yĩndefua Crise ye, ma wee Yeli ye, ma maha wee u Yãhã kaplãŋ tɔ̃rfua ye, ah nwa -sẽ ta ma n nii nawee- tãã n yi loho wo?» ");
INSERT INTO xrb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nsãn n -sẽ pe pye ma yee: «Ndoo, n nwo, tẽ n nii nawee- tãã loho ne; waa sẽ ma pe nawee- laam wo, tee sẽ cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Woo nwo ga ba le koho yigi ra kur ye. U cɛr yaha ra kẽ, ta syi gɛ sẽ yai u ntãn sale wãfɛr ne u trɛ na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Koo ngĩĩ byɛ pye Gbetane wo, Yurdane lafeŋ kũndi ngaa ye, Nsãn tuu naa nawee- tãã loho ne na. ");
INSERT INTO xrb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Koo yĩŋsyii wo, Nsãn n Yesu yãã tuu n pai u fla na, u n pe nawee- pye ma yee: «U Yãhã Mbapẽnge nwo, wii Yãhã u ta, ma ga driyɛ̃ nawee- kapee- foho gbe kãã pe na. ");
INSERT INTO xrb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Woo wĩĩ kẽ tẽ ba naa n pãã ma yee: Waa ma tuu ga pa ta kur ye, u cɛr yaha ra kẽ. U cãã pye lɛ nii wa ra yaha. ");
INSERT INTO xrb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ndoo bya, n sẽ ba u cã ye. N pa, ma ba nawee- tãã n yi loho wo, loo le ga waha ta, Yiisrɛfa n waha cã yoo kẽ u ne.» ");
INSERT INTO xrb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nsãn n le yãã, ma le pãã ma yee: «N Yãhã Yrã Fãnga yãã, le tege yãhãyĩŋ na kãnsyã waa dyaŋ, ma ba too kuee u yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","N sẽ ba u cã ye, Yãhã gii ke -sẽ ra nɔ wãã ta n ba nii nawee- tãã n yi loho wo, koo ke ba ra pye ma yee: ‹Wii raa ga ba yãã, ta Yrã Fãnga le ga tege kuee u na, woo kẽ u ga ba naa nawee- tãã ta Yrã Fãnga ne.› ");
INSERT INTO xrb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ndoo Nsãn loo nde yãã ra yĩnde ne, ma ga le pãã yi, n ye yar woo kẽ u Yãhã Dya.» ");
INSERT INTO xrb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Koo yĩŋsyii wo, Nsãn maha pye loo teele nen ya wo, u kãnyãrwai syãm mpãy ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","U n maha ba Yesu yãã tuu n tɛr. U n maha yee: «U Yãhã Mbapẽnge nwo!» ");
INSERT INTO xrb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","U Nsãn kãnyãrwai syãm mpãy pe pye u ne, pe u kapãn luhu ke syi, pe n taha Yesu na. ");
INSERT INTO xrb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu n ba klaha yãŋ, ma pe yãã pe u taha n naha, u n pe yey ma yee: «Ah le ma mii?» Pe n u pye pe yor wo ma yee: «Arbi, ma n syã na?» Ke Arbi yĩntaha kẽ kaicãfua. ");
INSERT INTO xrb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","U n pe pye ma yee: «-Ye pa yaa yãŋ!» Pe n ka, maa u syãsaha yãŋ. Ke -sẽ pye yaiyĩn tratra. Pe n koo per yai kua u ne. ");
INSERT INTO xrb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Poo nawee- syãm mii, pe ba Nsãn kaplãŋ luhu, ma dur yi u kur kuɛ ye, ma taha Yesu na pe kuãŋ ne, pe laam wo Syimu Pyar cĩĩfua Andere pye. ");
INSERT INTO xrb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andere n cãã ka, ma ga u lɛfua Syimu wãã, ma u pye ma yee: «Wo u Meesi yãã.» Ke Meesi yĩntaha kẽ: Yãhã Yĩndefua Crise. ");
INSERT INTO xrb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","U Andere n Syimu yigi ga Yesu fla na. Yesu n u yãã ma yee: «Mboo sẽ na Nsãn dya Syimu? Pe naa ma yee yagaa Sefase.» Ke Sefase myaha ma wãcɛŋ Pyar myaha ne. Te myar yĩntaha ntẽmblaha. ");
INSERT INTO xrb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Koo yĩŋsyii wo, Yesu n le ta woo ga ka Galɛlɛ kuɛ kãntraha na. Tuu Filipe wãã sya, u n u pye ma yee: «Naa n taha ra na.» ");
INSERT INTO xrb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","U Filipe -sẽ wãã naa n yi Pyar ne, tesẽ u cĩĩfua Andere ne klo nen wo, lii pe naa n yee Gbesyata. ");
INSERT INTO xrb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Loo kur ye, Filipe n ga Natanelu wãã sya, ma u pye ma yee: «Faale wo, wii wĩĩ Musa tuu yrũhũ le yaha Yãhã sabangbãŋ wo, tesẽ pe Yãhã kaplãŋ tɔ̃rfa u wĩĩ pãã, wo u yãã: Nasarɛtefa Yosɛfe dya Yesu kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanelu n u pye ma yee: «Kayĩĩ lii syi -sẽ ma, le ga waha yi Nasarɛte wo?» Filipe n u pye ma yee: «Pa yãŋ!» ");
INSERT INTO xrb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu tuu Natanelu yãã tuu n pai u fla na, u n nde pãã u wĩĩ na ma yee: «Cĩĩnde Yiisrɛfa naa waa nwo, dawar wee u laam wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanelu n u yey ma yee: «Ma pye mii ma ra cã?» Yesu n u pye ma yee: «N naa ma yãã. Ma sẽ pye la nasar nkugu flãhã tãy, Filipe n cã ga ma yee?» ");
INSERT INTO xrb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Loo na, Natanelu n u pye ma yee: «Yĩŋfua, Yãhã Dya kẽ ma ne, mboo maha ma Yiisrɛ kãntraha Yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu n u pye ma yee: «Tẽ ma pye ma yee, n ma yãã nasar nkugu flãhã tãy, loo ya la le ma ta ma n ra ta ma Yatɛr? Maa maha ba kai- nkãy yãã, ke gboho loo nde na. ");
INSERT INTO xrb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta n cĩĩnde nde pãã ye ye, yaa ba naa yãhãyĩŋ yãã ke yãr n yaha, ye n naa yãhãyĩŋ tẽnlɛhɛ ye yãã pe n dugu, ma dur tege n pai u Nawee Puee fla na.» ");
INSERT INTO xrb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Plii tãã kur ye, pe n nii cafãn taa yigi Galɛlɛ kãntraha na, klo laa wo pe n yee Kana. ");
INSERT INTO xrb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu nahafua pye pe cafãn yigifa ne. Pe n Yesu yee, woo tesẽ u kãnyãrwai ne, pe n ka te cafãn disaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pe n nii te cafãn dir di, defĩĩ n ba kua pe cafãn yigifa ye. Yesu nahafua n u pye ma yee: «Defĩĩ yãŋ, tuu kua pe ye.» ");
INSERT INTO xrb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu n u pye ma yee: «Ah yaa, lii ma wo nsoho wo ma ne? Ta yale sẽ nɔ wa ye.» ");
INSERT INTO xrb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesu nahafua n pe dirlafa pye ma yee: «U ma sya yee tee pye mii, -ye pye ke syi!» ");
INSERT INTO xrb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ke fla -sẽ na, ntẽmbar gbããwɔr kuay raa -sẽ pye, Yiifee- pe ba ta, ma naa pe kãnde kapĩĩ loho ku le naa n yaha. ");
INSERT INTO xrb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu n pe dirlafa pye ma yee: «-Ye loho ku, ye too gbããwɔr nde yĩĩ!» Pe n loho ku te yĩĩ tata. ");
INSERT INTO xrb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Loo na, u n pe pye ma yee: «-Ye kaa ku gblãhã gaa laam wo, ye ga wãã yãŋ diryĩntaha yifua kẽ!» Pe n kaa ku, ma ga wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te lɔr byɛ -sẽ ba wã klaha defĩĩ. U diryĩntaha yifua, tuu u wɔ yãŋ, u defĩĩ wãtãy n u laam wɔ. U sẽ cã woo defĩĩtãhã nwo syi yi na ye, mpãy pe -sẽ ba ke loho ku, poo ba u yisaha cã. U diryĩntaha yifua n u cafãn yigifua yee ba, ");
INSERT INTO xrb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ba u pye ma yee: «Ah ndee ngaa dyaŋ, defĩĩtãhã woo pe ma ne cãã la wãã nawee- kẽ, u ma pe yigi wa pe cã naa ke sahasaha la, ah mboo -sẽ koho far u defĩĩtãhã na u n sya yagaa dye.» ");
INSERT INTO xrb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu u laanwɔ wũhũ wãpyeŋ koho fe yigi koo syi. Le pye Galɛlɛ kãntraha klo nde wo pe n yee Kana. U u ya yi yar ke syi, u kãnyãrwai n u wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Loo kur ye, u n ka Kapornu wo, u nahafua ne u cĩĩfa ne ma suhu u kãnyãrwai ne. Pe n ga kuee ke fla na, ma plii raa pye. ");
INSERT INTO xrb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yiifee- syayaha gbar te ba nɔ gbe taha, Yesu n ka Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yãhã kangbãŋ kãndi wo, u n nyer parfa yãã, mbaa parfa ne, nasar kate parfa ne, ma maha war turfa bya yãã pe tege nii ga pe tabal tãy. ");
INSERT INTO xrb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu n namihi ta, ma sãngblã fan, ma pe byɛ kar yi wãã ke Yãhã kangbãŋ nkur ye, pe mbaa ne, pe nyer ne. Ma dur, ma war turfa tabal tra cããr wãã pe kẽ, pe war n yrãhã, ");
INSERT INTO xrb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ma nasar kate parfa pye ma yee: «-Ye pe gbe yi kãã nwo! Yaʼa syi ta Tuhufua Yãhã kaha ta ye cãtrohosaha ye!» ");
INSERT INTO xrb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesu tuu nde pãã, u kãnyãrwai n Yãhã sabangbãŋ kapãn nde tai cã, nde le n yee: «Yãhã, ma kaha wĩĩ sroŋ gboho ra laam wo, mii naa dyaŋ ke ga ba ra suhu tãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yiifee- yahaseefa pe u yãã nde pyesaha wo, pe n ba u yey ma yee: «Taa nwo taa nde pye ke syi, laanwɔ wĩĩ lii loo taa -sẽ ga pye, wo n waha cã ma tãhã kẽ le wãpyeŋ ne?» ");
INSERT INTO xrb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu n pe pye ma yee: «-Ye Yãhã kangbãŋ nge yoho yãŋ, yaa yãã plii tãã wuhu, n ke fãã le!» ");
INSERT INTO xrb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pe Yiifee- yahaseefa n u pye ma yee: «Yãhã kangbãŋ nge wãfããtãŋ ke dyɛ- gbeesĩĩ wũhũ kuay gbe, mboo ma -sẽ yee, pe ma ke traha, taa ga waha ke dur fãã kua plii tãã ya!» ");
INSERT INTO xrb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu -sẽ nwo, ngii u naa n yãŋ, koo kẽ u ya koho kadye ne. ");
INSERT INTO xrb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Koo kẽ tuu ba ku, plii tãã wuhu u n yir gbã wo, ma pa gbaafa ye, u kãnyãrwai n ke kaplãŋ tai cã, tuu ba nkãy pãã. Loo nde n pe ta pe n Yãhã sabangbãŋ kai- sya cĩĩnde, ma suhu Yesu yɛ̃ kaplãŋ nkãy ne tuu ba tɔ̃r. ");
INSERT INTO xrb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu tuu pye ke dyaŋ Yurusalɛm wo, te syayaha gbar cãã na, laanwɔ wũhũ nkãy tuu naa n pye, koo ngĩĩ n ba ta nawee- mpãy n u wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu sẽ -sẽ ba sya ma koho taha yaha pe wĩĩ na ye. U tee ba pe cã laha, poo tesẽ pe laam wũhũ byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","U sẽ naa n kɛ pe naa nawee wĩĩ tɔ̃r u ye ye; u ma nawee yãŋ, u u laam wũhũ byɛ yãã. ");
INSERT INTO xrb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yiifee- yahaseefua waa -sẽ nwo tuu pye, pe naa n yee Nikodɛmu. Farisyɛ̃ ba kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Per gaa yĩmper wo, u n ba yi Yesu na, ma u pye ma yee: «Yĩŋfua, wo cã Yãhã kẽ ke ma nɔ wãã, taa ba wo klaha. Mii loo sẽ ne ye, laanwɔ wũhũ nkãy taa n pye ngĩĩ, waa wee tuu ga waha ke syi pye Yãhã ma yee ke wee ufua ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu n u pye ma yee: «Ta n cĩĩnde nde pãã ma yee: Waa wee tuu ga waha Yãhã Yai yãã mii u sẽ gbihi dur see ye.» ");
INSERT INTO xrb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛmu n u yey ma yee: «Le ga waha pye mii? Naweedyaha ga maha waha gbihi see la? U ga waha dur dye la u nahafua laam wo, u maha gbihi see?» ");
INSERT INTO xrb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu n u pye ma yee: «Ta n cĩĩnde nde pãã ma ye: Wii ma yee u sẽ see loho ne tesẽ Yãhã Yrã Fãnga ne ye, u saa waha dye Yãhã Yai wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wii ma see kadye sraha na, u ga nii kadye sraha kla ya; wii ma see Yãhã Yrã ne, u ga nii Yãhã Yrã Fãnga kla. ");
INSERT INTO xrb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Maʼa syi ta nde n ma laam wɔ ye, nde tẽ pãã ma yee: Ye yai ye gbihi dur see! ");
INSERT INTO xrb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Teflaha ga naa n gbã teelii ma ke tãy, ma n naa ke gbleŋ luhu, ma sẽ -sẽ ga waha ke yirsaha cã ke kasaha ne ye. Yãŋ, nawee wii ma gbihi dur see Yãhã Yrã Fãnga ne, u ma ke syi.» ");
INSERT INTO xrb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodɛmu n maha u pye ma yee: «Loo nde syi -sẽ ga waha pye mii?» ");
INSERT INTO xrb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu n u pye ma yee: «Mboo wii taa Yiisrɛfa klaha Yãhã kai- ne, ma -sẽ maha pye mii ma sẽ koo ngĩĩ cã ye! ");
INSERT INTO xrb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ta n cĩĩnde nde pãã ma ye: Nkãy too cã, koo too n pãã; nkãy too yãã yĩnde ne, koo too n yar nawee- na. Ye -sẽ koo ngĩĩ byɛ sye yaha wo na. ");
INSERT INTO xrb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N ma nii kãntraha wũhũ tɔ̃r ye ye, ye ma yee ye sẽ -sẽ koo sya ye, ye -sẽ ga ba pye mii ye yãhãyĩŋ wũhũ koo sya ra ye, nkãy yĩŋ ke n yi yãhãyĩŋ na? ");
INSERT INTO xrb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma yi kãã u Nawee Puee na, woo wii u yir yãhãyĩŋ na ma tege ba kãntraha na, waa wee wii tuu dugu ga yãã yãhãyĩŋ na, ma yãhãyĩŋ kai- cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Faale wo, tẽyãfũũ klo wo, Musa sẽ bii kayãrnwoho wra ta la kãi na, ma ke kuã yir ta? U Nawee Puee bya yai u ba kuã yir ta ke syi. ");
INSERT INTO xrb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Loo nde n nii, wii ma u ta u Yatɛr, u cĩĩnde yrã yãã wa, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nawee- ntãŋ sroŋ dye Yãhã tãy, ke n sya ke Dyapuai nen ya yi wãã, nawee wii ma u ta u Yatɛr, u wĩĩ saa klaha- yãã ye, u cĩĩnde yrã yãã wa, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yãhã sẽ ke Dya nɔ wãã driyɛ̃ wo ma yee u ba nawee- sãhã pe kapee- wãpye wĩĩ na ye. Ke u nɔ wãã nawee- wãsyayaha yĩmbui ne. ");
INSERT INTO xrb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wii ma u ta u Yatɛr, ufua saa wãpẽn yãã ye. Wii ma -sẽ kãntuhu le u wo, woofua u ya le wa wãpẽn kãnde wo, u tee sye u saa Yãhã Dyapuai nen ta u Yatɛr ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nwa ta nawee ga ba pẽn u kapee- wãpye wĩĩ na? Wii u ma Cããfua, u pa driyɛ̃ laam wo, wam wĩĩ n -sẽ tãy nawee- ye, ma tɛr cãã- yaha. Pe pyer tee pee tɛr, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nawee wii woo ma kapee- pye n wa, cãã- wĩĩ ma ne fũhũ u ye. U saa pa cãã- fla na ye. U ntãncɛr ma ne gboho u pyerpeer wãyi wĩĩ ne cãã- na, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wii ma -sẽ kayĩĩ yigi, u ga pa cãã- fla na, u ga naa u kai- pye Yãhã yor wo, u troho wãtãhã ter ne, te n naa n yãã cãã- na. ");
INSERT INTO xrb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Loo kur ye, Yesu n ka u kãnyãrwai ne Yudɛ kãntraha na. Pe n kuee koo fla na, ma nawee- tãã naa n yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nsãn bya -sẽ pye, tuu naa nawee- tãã Yɛnɔ wo, loho pye gboho koo fla nge na. Ke Yɛnɔ pye Salimu tãy. Nawee- naa n gaha ke fla na, maa naa n tãã u ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Koo cãã nge na, pe sẽ ba u Nsãn le wa nwompihi wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Per gaa, sãnkɛr n dye Nsãn kãnyãrwai mpãy nsoho wo Yiifee naa waa ne, gbɛgbɛ wãnii wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe n pa Nsãn fla na, ma ba u pye Yesu wĩĩ ne ma yee: «Yĩŋfua, dya wii tuu pye ma ne Yurdane kũndi ngaa ye, wii wĩĩ taa ba yee mboo tɔ̃r ma nawee- yar, awa, u bya nwo tuu yee woo nawee- tãã naa n yi loho wo, nawee- byɛ tɛr n tãŋ u kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nsãn n pe yɛ̃ sya ma yee: «Waa saa waha ngaa ka yãã, mii Yãhã sẽ kẽ ke ke wãã u kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yii gɛ le cã, ye ga waha le tɔ̃r nawee- ye tẽ yee, ndoo sẽ kẽ u Yãhã Yĩndefua Crise ye. Ndoo kẽ tẽ nɔ wãã u yahasee ye.» ");
INSERT INTO xrb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nsãn n nde pãã kakuãcran ne pe ye ma yee: «Cafãn yigifua, cafuɛ̃ ma woo wũũ. U cafãn yigifua naambiyã, woo -sẽ ga yɛr u tãy, u naa u kaplãŋ luhu. U cafãn yigifua yĩmbui ga naa nuhu yigi u kẽ. Too nuhu nde syi ma ndoo wãn, ta laam n flege yi tãŋ. ");
INSERT INTO xrb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesu woo na tesẽ ndoo ne, woo myaha yai ke naa n yi, ndoo wãŋ ke naa n too.» ");
INSERT INTO xrb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wii tuu n yi ncaha ye, u ma wãn byɛ yĩŋ na, nawee- byɛ ne. Wii tuu -sẽ n yi kãntraha na, kãntrahafua kẽ u ne, u kãntraha kai- cã n pãã. Wii tuu n yi yãhãyĩŋ na, woo tuu ma wãn byɛ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nkãy tuu yãã, nkãy ne tuu luhu yãhãyĩŋ na, koo tuu n pãã. Nawee- -sẽ u kaplãŋ sye. ");
INSERT INTO xrb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wii u yi yãhãyĩŋ na, nawee wii ma -sẽ yĩntaha sroŋ woo kaplãŋ ye, ma u troho tãhã u yor wo, ufua le cã ma maha le yar Yãhã wĩĩ ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wii Yãhã u nɔ wãã, Yãhã kaplãŋ koo kẽ u n pãã. Yãhã ke Yrã Fãnga wãã u kẽ wãkuayãã wee ye. ");
INSERT INTO xrb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","U Dya ntãŋ dye u Tuhufua Yãhã tãy, ke n -sẽ ke kai- byɛ le soho u koho wo. ");
INSERT INTO xrb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wii ma u Dya ta u Yatɛr, u cĩĩnde yrã yãã wa, lii wãkuayãã wee le na ye. Wii ma -sẽ yee u sẽ u ya le soho u Dya koho wo ye, u saa loo cĩĩnde yrã yãã ye. Yãhã ncafũhũ ga kuee woofua na yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisyɛ̃ ye n luhu, a ter nawee- naa n taha Yesu na; tesẽ u maha nawee- tãã naa n yi loho wo, ma tɛr Nsãn yaha. ");
INSERT INTO xrb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu gɛ sẽ kẽ u naa pe tãã ye, u kãnyãrwai me pe naa pe tãã. ");
INSERT INTO xrb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu tuu yi nde cãŋ na, u n yi Yudɛ kãntraha na u kãnyãrwai ne, ma tɛr Galɛlɛ kãntraha kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yesu ba yai u tɛr Syamari kãntraha ne. ");
INSERT INTO xrb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","U n ga nɔ gbe taha Syamari kãntraha klo laa na, pe naa n yee Syisyar. Le pye tũntũn tar raa ne, tar rii Dyakuba tuu bii wãã u dya Yosɛfe kẽ faale wo. ");
INSERT INTO xrb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Koo fla nge na, u Dyakuba kualaŋ pye. Yai pye yĩŋ wo, yrãhã n Yesu fãy, u n tege nii ke kualaŋ ngbeŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","U kãnyãrwai ba tɛr le klo laam wo, dir kɛparsaha wo. Syamarifasya waa n -sẽ pa loho kusaha wo. Yesu n u pye ma yee: «Yɔ̃ ra na lawɔŋ ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","U Syamarifasya n Yesu pye ma yee: «Ah ndee Yiifee naa kẽ ma ne. Ah le yigi mii, ma n lawɔŋ kɛ ndoo Syamarifasya ye?» Yiifee- naa n fã Syamarifa na, koo kẽ u cɔɔ n naa n pãã ke syi. ");
INSERT INTO xrb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu n u pye ma yee: «Kayĩĩ lii Yãhã le ta, maʼa ne pye taa le cã, ma suhu wii ne nwo tuu nii lawɔŋ nar ma ye, mboo raa ne ga dur, ma u nar u ma kẽ cĩĩnde loho ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","U cɔɔ n u pye ma yee: «Yĩŋfua, laku kla sẽ -sẽ wee ma ye ye, ke kualaŋ maha n cuhu, mboo -sẽ ga waha pye mii ma koo loho yãã? ");
INSERT INTO xrb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wo faale wãdyaha Dyakuba kẽ, tuu koo kualaŋ nge yaha wo kẽ. Kualaŋ gii tuu loho wɔ ke na, woo, tesẽ u pii ne, ma suhu u yar ne. Mboo laam wo, ma yee la ma tɛr u yaha?» ");
INSERT INTO xrb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu n u pye ma yee: «Wii ma sya kualaŋ nge loho wɔ, loho fãã ga maha ba u yigi. ");
INSERT INTO xrb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wii ma -sẽ loho nge wɔ, kii tẽ ga wãã u kẽ, loho fãã saa u yigi yãã ye. Koo loho gii tẽ ga wãã u kẽ, ke ga nii plege dyaŋ u laam wo, plege gii ke cĩĩnde yrã wãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","U cɔɔ n u pye ma yee: «Yĩŋfua, ta kẽ koo loho nge ne, loho fãã ma n maha ra yigi yãã ye. Loo na, n saa maha pa yãã lakusaha wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu n u pye ma yee: «Ka, ma ga ma puai yee, -taa pa!» ");
INSERT INTO xrb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","U cɔɔ n u yɛ̃ sya ma yee: «Puai wee ra ye ye.» Yesu n u pye ma yee: «Cĩĩnde ne taa pãã nde, puai wee ma ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma nii tɛr wa pa bua ye; taa sya maha ma naa wii ye yagaa, ma puai sẽ kẽ u ne ye. Ma cĩĩnde pãã loo nde ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","U cɔɔ n u pye ma yee: «Yĩŋfua, Yãhã kaplãŋ tɔ̃rfua kẽ ma ne. ");
INSERT INTO xrb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wo faale wãlɛ Yãhã wãã le sey pe ya na yãŋ nge yĩŋ na, ah yii Yiifee- -sẽ yee Yãhã yai ke naa n sey Yurusalɛm ya wo.» ");
INSERT INTO xrb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu n u pye ma yee: «Cɔɔ, koho taha yaha ngĩĩ na tẽ ga tɔ̃r ma ye: Yale laa nde le n pai, Yãhã wãsey sẽ pai nii Yurusalɛm ya wo, ma suhu yãŋ nge fla ya ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yii Syamarifa, tee ngii sey ye sẽ ke cã ye; wii Yiifee- -sẽ mii, too ngii sey wo ke cã, ma cã u Syayahafua yĩŋ yi Yiifee- wo. ");
INSERT INTO xrb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yale laa sẽ ma le n pai, le nɔ wa gɛ nɔ wa, mpãy pe Tuhufua Yãhã sey cĩĩnde, pe ga ba naa ke sey ke Yrã Fãnga ne, ma suhu cĩĩnde ne. Tuhufua Yãhã poosyi Yãhã seyfa kɛ. ");
INSERT INTO xrb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yãhã ma ke Yrã Fãnga. Nawee- yai pe naa ke sey ke Yrã Fãnga ne, ma suhu cĩĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","U cɔɔ n u pye ma yee: «N le cã, u Yãhã Yĩndefua wii pe n yee Crise, u ga pa. U ma pa, u ga ba ke byɛ yĩntaha tɔ̃r u wo yar.» ");
INSERT INTO xrb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu n u pye ma yee: «Ndoo kẽ woo, ndoo wii tẽ n pãã ma ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Loo yale nde -sẽ wo, Yesu kãnyãrwai n ba dye. Pe Yesu yãã tuu n pãã cɔɔ ne, le n pe laam wɔ. Pe sẽ -sẽ sya ma u yey nde ne ma yee, lii raa n pãã u ne laa, nwa ta ma n nii n pãã u ne. ");
INSERT INTO xrb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Loo na, u cɔɔ n u laku kla ta yaha ke fla na, ma dur ga klo laam wo, ma ga nawee- pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«-Ye pa ye ba dya waa syi yãŋ! Kai- nkãy byɛ tẽ pye tɛr, u ke byɛ tɔ̃r ma ra yar. Laa na, woo ga kẽ u Yãhã Yĩndefua Crise ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pe byɛ n yi le klo wo, ma n gaha Yesu fla na. ");
INSERT INTO xrb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yaliile u cɔɔ tuu ba tɛr klo laam wo, Yesu kãnyãrwai naa u nar ma naa n yee: «Yĩŋfua, ngaa sya di.» ");
INSERT INTO xrb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","U n -sẽ pe pye ma yee: «Ndoo, kadiŋ kla gaa ma ra ye, tee sẽ kii cã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pe kãnyãrwai n nii pe ya yey ma yee: «Waa yãã pa la u kẽ digi kla ne?» Yesu n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","«Ta digi kẽ lii ne, n naa n luhu ta Tuhufua Yãhã ye, koo gii ke ra lɛhɛ wãã. Tesẽ, kai- nkãy tuu yee tẽ pye, n koo byɛ pye kua. ");
INSERT INTO xrb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yii sẽ n yee la, a digi ma tãhã le kãntraha wo, mii yrey resyar sẽ kẽ ye, ke sẽ yãã n gbe ye? Ndoo -sẽ ga ye yar, -ye yĩŋ kuã yir ye nabuar nde yãŋ te n pai, te ma mii tar digi dyaŋ ke nɔ wa wãgbeŋ na! ");
INSERT INTO xrb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mii wii dyaŋ tuu dir gbe ma te le pɛn wo, u dããn yãã, wii tuu nawee- wãã ma pe le Yãhã kãnde wo, u ma pe yãã pe cĩĩnde yrã yãã, u nuhu di. Loo ne, wii tuu n tãhã, tesẽ wii ne tuu re gbe, pe nuhu wãã n di pe syãm. ");
INSERT INTO xrb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Cĩĩnde ne pe le pãã ma yee: Nawee waa n tãhã, waa -sẽ re gbe. ");
INSERT INTO xrb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ndoo, n ye nɔ wãã, yaa dir gbe tar wo, tii tee sẽ te tẽn tẽ ye. Mpãy me pe re tẽn tẽ, yii -sẽ ga ta tɛr le tẽn ne.» ");
INSERT INTO xrb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Le klo wo, Syamarifa busãã ba Yesu ta pe Yatɛr. U cɔɔ tuu ba le pãã u klofa ye, a kai- nkãy byɛ woo ba pye tɛr, Yesu ke pãã woo ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Loo ne, pe n pa Yesu fla na, maa u sroŋ nar tuu ga kuee poo ne. U n kuee pe ne plii sĩĩ. ");
INSERT INTO xrb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mpãy pe -sẽ ba u Yesu yɛ̃ kaplãŋ luhu, ma u ta pe Yatɛr, poo wãnihi ba tɛr pe faale wãm yaha. ");
INSERT INTO xrb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pe n nii u cɔɔ pye ma n yee: «Ma kapãn ya sẽ ne le wo ta wo n u ta wo Yatɛr ye. Too lii luhu u ye wii ya, loo bya le wo ta wo n u ta wo Yatɛr. Wo cã cĩĩnde, woo kẽ driyɛ̃fa Syayahafua.» ");
INSERT INTO xrb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu tuu plii sĩĩ pye wa pe Syamarifa fla na, u n yir, ma ka Galɛlɛ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Woo gɛ naa le pãã, a ter Yãhã kaplãŋ tɔ̃rfua woo sẽ fĩhĩ nagboho yãã u kusey wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tuu -sẽ ga dye Galɛlɛ wo, pe Galɛlɛfa n u yigi yɔ̃. Pe ba Yesu yãã pe ya ndoŋ, tuu naa laanwɔ wũhũ pye Yurusalɛm wo, syayaha gbar na. Pe bya ba ka te gbar na. ");
INSERT INTO xrb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","U n dur ba ke syi Kana wo. Koo fla kẽ u ba loho wã klaha defĩĩ. Klokai- yahaseefua waa pye Kapornu wo, u dyale sẽ pye wãwee u ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","U klokai- yahaseefua tuu le luhu, a ter Yesu ma tuu yir Yudɛ kãntraha na, ma pa Galɛlɛ wo, u n yir ga u fla na, ma ga u nar u pa Kapornu wo, u ba woo dya jaa woo kẽ, a u ma tuu kuee wale nen ya ma ga ku. ");
INSERT INTO xrb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu n yee: «Yii poo na, yaʼa yee ye sẽ yɛ̃kã wũhũ yãã laanwɔ wũhũ ne ye, ye saha ra ta ye Yatɛr ye.» ");
INSERT INTO xrb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","U klokai- yahaseefua n u pye ma yee: «Yĩŋfua, pa wo n tɛr ra fla na, ta dyale ma syi le ba ku wo yaha ye.» ");
INSERT INTO xrb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu n u pye ma yee: «Dur ga ma kaha wo, ma dya wloho yi, u ma yrãŋ na.» U yahaseefua n Yesu kapãn sya cĩĩnde, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kãnde wo, u tẽntẽ- mpãy n u wãã, ma u pye ma yee: «Ma dya sẽ yãã ku ye, u yir.» ");
INSERT INTO xrb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","U n pe yey u wãpuar yale ne. Pe n u yɛ̃ wãã sya ma yee: «Niinge yaiwlaŋ kẽ, yrĩŋ ke ne dye u tãy.» ");
INSERT INTO xrb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","U dya tuhufua n cã loo yale ne Yesu u ne u pye u dya wloho yi wa. Woo tesẽ u nna ne, pe n Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu tuu yir Yudɛ wo, ma ka Galɛlɛ wo, ke tɛhɛ syãŋ wuhu ba kẽ tuu laanwɔ wĩĩ pye Galɛlɛ wo. ");
INSERT INTO xrb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Loo kur ye, Yiifee- gbar raa pye, Yesu n dugu ga Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Le klo dyesaha neŋ gaa pye, pe naa ke yee mbaa dyesaha. Loho gaa pye ke fla na, pe naa ke yee yebɛrɛ yor wo Gbesyata. Pe ba ntẽmbar laankɔngbãy wãy bua raa fãã ke loho tãy. ");
INSERT INTO xrb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yanfa sãy naa n nii ke flãhã tãy: Fũũ-, tãnklahafa ne, tãnkurfa ne. Pe naa ke loho wãyir sẽŋ. ");
INSERT INTO xrb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yãhãyĩŋ tẽnlɛhɛ waa pye, yalaale wo u ga tege dye, u ke loho gblaha ke n yir. Ke loho ma yir wa, yanfua wii ma cãã tege dye pe yanfa byɛ yaha, u ga jaa, te ma sya pye yan tii syi ter. ");
INSERT INTO xrb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Koo fla na, yanfua waa pye, ke dyɛ- gbey sẽnsye wĩhĩ kuatãã ba kẽ yan pye u na. ");
INSERT INTO xrb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu tuu ba nɔ ke fla na, u n u yanfua yãã tuu sãy nii, u n cã yan ma- u na. U n u yanfua yey ma yee: «Ma n traha la ma jaa?» ");
INSERT INTO xrb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","U yanfua n u yɛ̃ sya ma yee: «Yĩŋfua, ke loho ma yir, waa wee ma ga ra gbe dye farfar ke laam wo ye. N ma yir ma n gaha, n gaha yãã waa cãã dye ra yaha.» ");
INSERT INTO xrb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu n u pye ma yee: «Yir, ma ma kasãy wãŋ gbe, ma naa n yãr!» ");
INSERT INTO xrb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Le yalebya wo, u dya n jaa, ma u kasãy wãŋ gbe ma n yãr. Koo per pye Yiifee- kanii per. ");
INSERT INTO xrb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wii tuu ba jaa, Yiifee- yahaseefa n u pye ma yee: «Kanii per kẽ nanga, ma sẽ yai ma ma kasãy wãŋ gbe ma naa n yãr ke ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","U n pe yɛ̃ sya ma yee: «Wii u ra jaa, woo u ra pye, n ta kasãy wãŋ gbe, n naa n gaha.» ");
INSERT INTO xrb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pe n u yey ma yee: «Dya wii woo tuu ma pye, ma ma kasãy wãŋ gbe, ma naa n gaha?» ");
INSERT INTO xrb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dya wii tuu ba jaa, u sẽ ba cã yoo kẽ ye. Yesu ba wloho yi pe nabuar laam wo, ma tɛr, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Loo kur ye, Yesu n ba u yãã Yãhã kangbãŋ wo, ma u pye ma yee: «Ma sẽ yãã, ma jaa. Maʼa syi ma kapee- pye nantãŋ ye. Mii loo sẽ ne ye, kapee laa ga waha ma dye, lii le pee tɛr.» ");
INSERT INTO xrb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","U dya n tɛr, maa le pãã pe Yiifee- yahaseefa ye ma yee, a Yesu kẽ tuu ba u jaa. ");
INSERT INTO xrb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Loo nde n ta pe n nii Yesu kɛ yĩntayãhã ne. Pe n ba u yãã ma u pye, a u tee kai- ngĩĩ pye kanii per wo. ");
INSERT INTO xrb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu n -sẽ pe yɛ̃ sya ma yee: «Ta Tuhufua Yãhã ma tẽn na yalebyɛ; ta bya, n ma tẽn na yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pe Yiifee- yahaseefa n yee, a nwa ta Yesu n nii Yãhã yee u Tuhufua, ma yee woo ma wãcɛŋ ke ne. Tuu maha plaha, ma yanfua jaa kanii per wo. Koo ngĩĩ wĩĩ na, pe naa u kɛ wãboo yĩmbui ne. ");
INSERT INTO xrb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu n pe yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ye ye: -Ye yãŋ, u Yãhã Dya saha laa pye u ya kãmay na ye. Tuhufua Yãhã ke lii pye, loo ne u n yãã ma n pye. Lii Tuhufua Yãhã ke n pye, loo cɛŋ ya kẽ ke Dya n pye. ");
INSERT INTO xrb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ye sẽ yãã, u Dya ntãŋ dye Tuhufua Yãhã tãy. Kai- nkãy byɛ ke n pye, ke ke byɛ yar u na. Kai- nkãy ke gbaha ngĩĩ na, ke ga ba ke yar u na, le n yɛ̃ gbãã ye na. ");
INSERT INTO xrb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ye sẽ yãã, Tuhufua Yãhã ke nakur ta te n yir gbã wo, ma dur n pai yrãŋ na gbaafa ye mii syi dyaŋ, wii ntãŋ ma dye ke Dya tãy, u bya ga waha yrã wãã ufua kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tuhufua Yãhã sẽ waa sãhã ye, ke te kasãhã byɛ le soho ke Dya koho wo. ");
INSERT INTO xrb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ke yee nawee- pe naa ke Dya sey, mii pe koo gɛ sey mii syi dyaŋ. Wii ma yee u sẽ ke Dya sey ye, ufua sẽ Tuhufua Yãhã gɛ sey ye, koo gii ke ke Dya nɔ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ta n cĩĩnde nde pãã ye ye: -Ye yãŋ, wii ma ra kaplãŋ luhu, ma maha Tuhufua Yãhã ta u Yatɛr, koo gii ke ra nɔ wãã, ufua cĩĩnde yrã yãã wa, lii wãkuayãã wee le na ye. Ufua saa pẽn nantãŋ ye. U ma mii u ku, ma yir wa gbã wo, ma cĩĩnde yrã yãã wa. ");
INSERT INTO xrb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ta n cĩĩnde nde pãã ye ye: -Ye yãŋ, yalaa ma le n pai, le nɔ wa gɛ nɔ wa, mpãy pe ku wa pe ga ba naa Yãhã Dya yĩmbui luhu. Mpãy ma ba le luhu, pe ga ba cĩĩnde yrã yãã. ");
INSERT INTO xrb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ye sẽ yãã, yrã le n yi Tuhufua Yãhã ye mii, ke ke Dya ta yrã ga waha yi u bya ye koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ye sẽ yãã, nawee- wãsãhã kãnde wãã u Nawee Puee kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ta kaplãŋ ngĩĩ yɛ̃ gbãã la ye na? -Ye yãŋ, yalaa ma le n pai, mpãy pe ku tɛr wa, pe ga ba u Yãhã Dya yĩmbui luhu, pe yir gbã wo, pe nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pe laam wo, mpãy pe naa kayũhũ pye, pe ga ba yir pe cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. Mpãy pe -sẽ naa kapee- pye, poo ga ba yir pe wãpẽn yãã, kii wãkuayãã wee ke na ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","N saha laa pye nii ya ye. Yãhã yee n naa n pye mii syi dyaŋ, n nawee- sãhã koo syi. Ta kasãhã n sroŋ, ta ya laam wĩĩ sẽ ne tẽ n kar ye. Yãhã gii ke ra nɔ wãã, koo laam wĩĩ ne tẽ n kar. ");
INSERT INTO xrb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Le ma pye ndoo ya tẽ nii wĩĩ pãã, nawee- saha cã cĩĩnde ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yãhã ra wĩĩ pãã; n cã ke kaplãŋ ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ye mpãy lɛhɛ wãã Nsãn ye, u n ga le cĩĩnde wĩĩ pãã pe ye ra wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","N sẽ -sẽ n kɛ nawee u naa ra wĩĩ pãã ye. N kai- ngĩĩ pãã ye ye, ye n waha ba sya yaha. ");
INSERT INTO xrb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nsãn pye mii naaloho wãŋ syi dyaŋ ke n tar, ma n yɛhɛ. Ye n pa, ma ba faa ma- pe cãã- na, ma nuhu di. ");
INSERT INTO xrb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kai- nkãy ma ke tɛr Nsãn wũhũ yaha. Ye sẽ yãã, Tuhufua Yãhã tuu ra taha tẽŋ nkãy na, ta n nii n tẽ, koo tẽŋ ngĩĩ le yar ma yee Tuhufua Yãhã kẽ ke ra nɔ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tuhufua Yãhã gii ke ra nɔ wãã, koo gɛ ra wĩĩ pãã. Ye sẽ ke yĩmbui luhu yãã ye, ye sẽ ke yĩntaha yãã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ke ndoo wii nɔ wãã, ye sẽ ra ta ye Yatɛr ye, koo kẽ ye sẽ ke kaplãŋ le yaha ye laam wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ye Yãhã sabangbãŋ wũhũ kal, ma cã ke ga waha ta ye n cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. Koo sabangbãŋ -sẽ kẽ ke ra wĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ye -sẽ maha sye, ye saa pa ra ye, ye ba cĩĩnde yrã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","N sẽ n kɛ nawee- pe naa ra myaha gboho ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N -sẽ cã ma yee, ye laam wo Yãhã wĩĩ sẽ n tãy ye ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","N pa Tuhufua Yãhã myaha ne, ye -sẽ ra wĩĩ sye. Wii syi u n pai u ya myaha na, ye woosyifua wĩĩ sya. ");
INSERT INTO xrb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tee mii, ye myaha kɛ yii ye, ye sẽ myaha kɛ Yãhã ya ye ye, loo ne ye saha ra ta ye Yatɛr ye. ");
INSERT INTO xrb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ye ma syi ye le ga ye yee, ndoo tẽ ga ba ye wãpee wĩĩ pãã ta Tuhufua Yãhã yaha ye ye. Yãhã kãnde nkãy faale wãdyaha Musa ke yar, koo kẽ ke n pai ye yigi, koo nkãy tee koho taha yaha ke na. ");
INSERT INTO xrb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ye sẽ yãã, Musa ra wĩĩ cãã yrũhũ yaha; ye ma ne pye ye u kaplãŋ sya cĩĩnde, yaa ne ra bya kaplãŋ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nkãy tuu cãã yrũhũ yaha, ye ma yee ye sẽ koo sya cĩĩnde ye, ye -sẽ ga pye mii ye ra kaplãŋ sya cĩĩnde?» ");
INSERT INTO xrb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Loo kur ye, Yesu n ka Galɛlɛ langbãŋ kũndi ngaa ye; pe maha ke yee Tyibɛryati langbãŋ. ");
INSERT INTO xrb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nabuar naa n taha u na. Pe naa u yãã u laanwɔ wũhũ pye ma yanfa jaa, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu n dugu nii yãŋ gaa yĩŋ na, u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yiifee- gbar tii pe n yee syayaha gbar, te ba gbe taha. ");
INSERT INTO xrb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu n yee woo ga yãŋ, ma yãã nabuar n nii n pai u ye kacãn wee ye. U n Filipe pye ma yee: «Waa dir yãã na, wo par wãã pe byɛ kẽ pe n di?» ");
INSERT INTO xrb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu tuu ga lii pye, woo gɛ ba le cã wa; u ba Filipe yey yãŋ ke dyaŋ, ncã u ga lii pãã laa. ");
INSERT INTO xrb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipe n u yɛ̃ sya ma yee: «Waʼa sya war nagbey bur yãã par, te saa yai gɛ yai pe byɛ n waha yãã pe pye di yãŋ cacar gɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","U kãnyãrwɛ waa, u myaha Andere, Syimu Pyar cĩĩfua kẽ, woo n Yesu pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Dyalaale ma nwo, bur bua ne tesẽ fua- syãm ne le ye. Te ga waha lii yɔ̃ nabuar nde syi kẽ?» ");
INSERT INTO xrb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu n yee, pe pe nabuar ta pe n tege nii. Nyɛ̃ pye ke fla na busãã. Pe n tege nii. Pe ba naam nyersĩĩ yĩĩbua kua. ");
INSERT INTO xrb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu n te bur gbe, ma Yãhã pye ma yee: «Ma syaha kẽ,» ma te bur la klaha mpãy byɛ kẽ pe ba tege nii. U n maha fua- wãã pe kẽ koo syi. Pe byɛ n dir yãã busãã, pe laam wãyãã. ");
INSERT INTO xrb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pe ba di, ma di yai. Yesu n u kãnyãrwai pye ma yee: «Dir rii pe di yaha, -ye te gbe, ngaa ma n kuee ye!» ");
INSERT INTO xrb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe byɛ pe ba di yai wa, pe n te bur bua gbɛr wãã gbe, ma sya takũyĩhĩ sẽnsye syãŋ yĩĩ. ");
INSERT INTO xrb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yesu tuu laanwɔ wĩĩ nde pye, pe nabuar n le yãã yĩnde ne, pe n nii le pãã ma yee: «U Yãhã kaplãŋ tɔ̃rfua wii tuu ne yai u pa driyɛ̃ wo, woo kẽ dya nwo ne!» ");
INSERT INTO xrb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu n cã pe ga ba u gbe fãnga na, pe u ta pe fla kãntraha yĩŋfua. U n maha wloho yi pe laam wo, ma ga nii ke yãŋ yĩŋ na u ya ya. ");
INSERT INTO xrb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Loo kur ye, yai ke ba kua wa, Yesu kãnyãrwai n tege ga ke langbãŋ yɛ̃ tãy. ");
INSERT INTO xrb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pe n dugu dye salangbãŋ gaa laam wo, ma dii n gaha Kapornu kuɛ ye. Yĩmper n ba wɔ, Yesu sẽ ba taha ga wa pe na ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Teflahangbãŋ gaa n yir, ma nii n fua, ma ke langbãŋ loho gblaha fãnga ne. ");
INSERT INTO xrb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pe n ba fã ma- ke salangbãŋ ne, ke langbãŋ yĩŋ na, ma sya dey. Pe n Yesu yãã, tuu yãr n pai ke langbãŋ loho na, ke salangbãŋ kuɛ ye. Pe n fya. ");
INSERT INTO xrb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu n pe pye ma yee: «Ndoo kẽ, ye ma n fya ye!» ");
INSERT INTO xrb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pe n yee, poo ga u gbe ke salangbãŋ wo, ma yãã ke tɛ kãntraha na. Pe ba dye wa pe kasaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ke yĩŋsyii wo, pe nabuar mpãy pe ba kuee ke langbãŋ kũndi ngaa na, pe ba cã ma yee ke salangbãŋ neŋ gii ke pye, Yesu kãnyãrwai ba dugu dye ke wo pe ya ya, ma tɛr. Yesu sẽ -sẽ ba dye pe ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Salangbãy taa -sẽ ba yir klo laa wo pe n yee Tyibɛryati, ma ba yɛr fla ngii na, Yesu ba syaha cãã wãã Yãhã kẽ te bur wĩĩ na, ma te la pe nabuar kẽ pe n di. ");
INSERT INTO xrb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pe nabuar pe sẽ Yesu yãã u kãnyãrwai ne ye, pe n dugu dye too salangbãy nde wo, ma ka Kapornu wo Yesu taysaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Loo kur ye, pe nabuar n ga Yesu yãã ke langbãŋ kũndi ngaa na, ma u pye ma yee: «Yĩŋfua, ma pa nwo yaliile wo?» ");
INSERT INTO xrb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu n pe yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ye ye: Ye bur yãã di ma sya di yai, koo kẽ ye n nii ra fla kɛ. Laanwɔ wũhũ ngĩĩ tẽ n pye, le sẽ nii mii ye koo kẽ yĩntaha war, koo kẽ ye n nii ra fla kɛ ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","-Ye yãŋ, digi gii ke n klaha-, ye ma syi ye naa tẽn tẽ koo wĩĩ na ye! Digi gii ke sẽ n klaha- ye, ma cĩĩnde yrã wãã nawee kẽ, lii wãkuayãã wee le na ye, -ye naa tẽn tẽ koo wĩĩ na! Koo digi nge, u Nawee Puee kẽ u ga ba ke wãã ye kẽ. Ye sẽ yãã, Yãhã u lɛhɛ wãã loo wĩĩ na, ma loo fãnga wãã u kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Loo na, pe n u yey ma yee: «Kai- nkãy ke n tãy Yãhã ye, wo yar ke ne wo n naa ke pye.» ");
INSERT INTO xrb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu n pe yɛ̃ sya ma yee: «Kai lii le n tãy Yãhã ye, ke n yee ye yai ye naa le pye, loo ne nde: Ke wii lɛhɛ wãã, -ye u ta ye Yatɛr!» ");
INSERT INTO xrb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pe n u pye ma yee: «Ma ga waha kai lii pye laanwɔ wĩĩ, wo n yãã yĩnde ne, wo ma ta wo Yatɛr? Ma ga kai lii loo pye? ");
INSERT INTO xrb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wo faale wãlɛ bii digi gaa di tẽyãfũũ klo wo, pe naa n yee man. Loo ne le yrũhũ yaha Yãhã sabangbãŋ wo ma yee: ‹Ke yãhãyĩŋ digi tege wãã pe kẽ pe n di.› » ");
INSERT INTO xrb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu n pe yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ye ye: Musa sẽ kẽ tuu bii ke yãhãyĩŋ digi wãã ye wãlɛ kẽ faale wo ye, ta Tuhufua Yãhã bii kẽ. Ta Tuhufua Yãhã maha kẽ ke cĩĩnde yãhãyĩŋ digi wãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ye sẽ yãã, Yãhã digi gii wãã ke yir yãhãyĩŋ na, ma ba cĩĩnde yrã wãã driyɛ̃fa kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Loo na, pe n u pye ma yee: «Yĩŋfua, naa koo digi nge wãã wo kẽ yalebyɛ.» ");
INSERT INTO xrb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu n pe yar ma yee: «Ndoo tẽ ma koo digi nge, koo digi gii ke cĩĩnde yrã wãã nawee kẽ. Wii ma pa ra ye, fãã saa ufua yigi yãã ye; tesẽ wii ma ra ta u Yatɛr, loho fãã saa ufua yigi yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","N ye yar le ne, ye maha ra yãã, ye sẽ -sẽ ra ta ye Yatɛr ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Tuhufua ke mpãy ta ra wãm, pe ga pa ra ye; tesẽ wii ma pa ra ye, n saa ufua sye ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ye sẽ yãã, n sẽ yir yãhãyĩŋ na, ma tege ba nii laam wĩĩ pyesaha wo ye; Yãhã gii ke ra lɛhɛ wãã, n pa koo laam wĩĩ pyesaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Koo gii ke ra lɛhɛ wãã, ke laam wĩĩ le -sẽ ma lii ne, mpãy byɛ ke le soho ra koho wo, n ma syi poo nen waa n plaha ra ye ye, n ba pe byɛ ta pe n yir gbã wo, pe dur ba yrãŋ na, driyɛ̃ plii kuaper na. ");
INSERT INTO xrb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta Tuhufua Yãhã laam wĩĩ le ma lii ne, wii woo ma ra yãã ma ra ta u Yatɛr, u ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. N ga ba ufua ta u n yir gbã wo, u dur ba yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu tuu yee woo kẽ cĩĩnde digi gii ne ke yir yãhãyĩŋ na, ma tege ba, pe Yiifee- n nii wlũhũ n pãã pe ya nsoho wo loo wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pe naa n yee: «Yosɛfe dya Yesu sẽ na u ne? Wo byɛ u tuhufua cã u nahafua ne; u pye mii ma yee woo yir yãhãyĩŋ na, ma tege ba kãntraha na?» ");
INSERT INTO xrb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu n pe yɛ̃ sya ma yee: «Ye tee wlũhũ n pãã ye nsoho wo. ");
INSERT INTO xrb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Waa saha pa ra ye mii ta Tuhufua Yãhã sẽ kẽ ke ufua yee ba ra kẽ ye, ta Tuhufua Yãhã gii ke ra lɛhɛ wãã. Ufua ma -sẽ pa ra ye, ndoo ga ba u ta u n yir gbã wo, u dur ba yrãŋ na, driyɛ̃ plii kuaper na. ");
INSERT INTO xrb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Faale Yãhã kaplãŋ tɔ̃rfa le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, nawee- byɛ ga ba klaha Yãhã kaklaha ne. Wii ma luhu ta Tuhufua Yãhã ye, ma u kaklaha sya, ufua n pai ra ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Waa sẽ Tuhufua Yãhã yãã yãã ye, ma yi kãã wii na tuu yir Yãhã tãy ma pa, woo Tuhufua Yãhã yãã. ");
INSERT INTO xrb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ta n cĩĩnde nde pãã ye ye: Wii ma ra ta u Yatɛr, ufua cĩĩnde yrã yãã wa, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ndoo kẽ digi gii ne ke cĩĩnde yrã wãã nawee kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ke yãhãyĩŋ digi gii pe naa n yee man, ye faale wãlɛ n bii ke di tẽyãfũũ klo wo, pe ba kuee la mii pe sẽ ku ye? Pe ba ku. ");
INSERT INTO xrb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Cĩĩnde digi gii ke yir yãhãyĩŋ na, ma tege ba, koo kẽ nge; wii ma ke di, ufua saa ku yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ndoo kẽ ke cĩĩnde digi gii ne ke yir yãhãyĩŋ na, ma tege ba kãntraha na. Wii ma koo digi nge di, ufua ga kuee yai tãŋ yrãŋ na u kuãŋ ne, u saa ku yãã ye. Digi gii tẽ ga ba wãã, koo kẽ ta koho kadye ne; n ga ke wãã driyɛ̃fa n waha cĩĩnde yrã yãã, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Loo nde na, pe Yiifee- n nii pe ya kɛ ma yee: «U ga waha u ya koho kadye wãã wo kẽ wo n di mii syi dyaŋ?» ");
INSERT INTO xrb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Ye ma yee ye sẽ u Nawee Puee kadye di ma u ntãŋ wɔ ye, cĩĩnde yrã wee ye ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wii ma ra kadye di ma ra ntãŋ wɔ, ufua ma cĩĩnde yrã ne, lii wãkuayãã wee le na ye. N ga ba u ta u n yir gbã wo, u dur ba yrãŋ na, driyɛ̃ plii kuaper. ");
INSERT INTO xrb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ye sẽ yãã, ta kadye ma cĩĩnde digi, ta ntãŋ ma cĩĩnde lawɔŋ. ");
INSERT INTO xrb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wii ma ta kadye di ma ra ntãŋ wɔ, ufua ga nii loho saa naa n yi u nsoho wo ra ne ye, n -sẽ ga nii loho saa naa n yi ra nsoho wo u ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yrã kur byɛ n yi ta Tuhufua Yãhã ye, koo gii ke ra lɛhɛ wãã, n ma cĩĩnde yrã ne koo kãmay na. Ke syi, wii ma ra kadye di, ufua ga cĩĩnde yrã yãã ra kãmay na. ");
INSERT INTO xrb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cĩĩnde digi gii ke yir yãhãyĩŋ na, ma tege ba kãntraha na, koo wĩĩ kẽ tẽ n pãã ye ye. Ke wee mii faale digi nge dyaŋ pe naa n yee man ye. Ye faale wãlɛ pe bii ke man di, pe sẽ kuee mii pe sẽ ku ye. Wii ma cĩĩnde digi nge di, ufua ga kuee yai tãŋ yrãŋ na u kuãŋ ne.» ");
INSERT INTO xrb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu naa nawee- klaha, ma naa kai- ngĩĩ pãã pe ye Kapornu wo, Yiifee- yawãhã nwoŋ wo. ");
INSERT INTO xrb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu tuu ba pãã wa, u kãnyãrwai busãã mpãy n yir ma yee: «Kaplãŋ ngĩĩ waha tɛr, yoo ma u ga waha naa ke syi luhu?» ");
INSERT INTO xrb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu tuu le cã u laam wo, a pe ma pe wlũhũ n pãã ke syi, u n pe pye ma yee: «Kaplãŋ ngĩĩ ma la wãpee ye ye? ");
INSERT INTO xrb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ah ye ma -sẽ ba u Nawee Puee yãã tuu dugu ga tuu pye na faale wo, ye ga pye mii? ");
INSERT INTO xrb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yãhã Yrã Fãnga ne le cĩĩnde yrã wãã nawee kẽ; nawee ya dyaŋ, u saha laa pye u ya ya ye. Kaplãŋ nkãy tẽ pãã ye ye, Yãhã Yrã Fãnga ma ke na, ke cĩĩnde yrã wãã nawee kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mpãy -sẽ ma ye laam wo, pe sẽ ra ta pe Yatɛr ye.» Ma gbe ke kai- fegbecãã na, mpãy pe sẽ Yesu ta pe Yatɛr ye, u ba pe cã wa, poo tesẽ wii gɛ ne u ga ba woo Yesu yi u napĩĩ- kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","U n maha pe pye ma yee: «Loo ne ta n ye yar ma yee, waa saha pa ra ye mii ta Tuhufua Yãhã sẽ loo ta ye.» ");
INSERT INTO xrb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tuu loo pãã wa, u kãnyãrwai busãã n dur yi u kur ye, pe sẽ maha naa n taha u na nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Loo na, u n u kãnyãrwai sẽnsye syãm pye ma yee: «Ah yii, ye saa tɛr la ra yaha yii ndoŋ?» ");
INSERT INTO xrb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Syimu Pyar n u yɛ̃ sya ma yee: «Yĩŋfua, ma yee wo ka yoo woo ye? Mboo kaplãŋ cĩĩnde yrã wãã nawee kẽ, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wo le sya cĩĩnde, ma maha cã mboo kẽ u Crise, u Yãhã Yĩndefua.» ");
INSERT INTO xrb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu n pe yɛ̃ sya ma yee: «Ye cã ndoo kẽ tẽ ye yãŋ yi, yii sẽnsye syãm mii! Waa -sẽ ma ye laam wo, sãndũpee kẽ u ne!» ");
INSERT INTO xrb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Syikaryɔtefa Syimu dya Yuda wĩĩ ne u naa n pãã. Woo kẽ tuu ga ba Yesu yi u napĩĩ- kẽ; u pye pe kãnyãrwai sẽnsye syãm mii waa. ");
INSERT INTO xrb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Loo kur ye, Yesu naa n tay Galɛlɛ kãntraha kui wo. U sẽ naa n kɛ u naa n tay Yudɛ kãntraha kui wo ye; pe Yiifee- yahaseefa naa u wãboo wĩĩ kɛ, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yiifee- ngbaabir gbar pye, te yale ba gbe taha. ");
INSERT INTO xrb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu cĩĩfa n u pye ma yee: «Yir, ma ka Yudɛ kãntraha wo. Ma kãnyãrwai mpãy pe ma ke fla na, pe bya n waha ma yãã ma tẽn na pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wii ma n traha u myaha ke yi nawee- byɛ n u cã, ufua sẽ u kai- wũhũ waa na ye. Maʼa ke syi kai- pye, ke pye naa n yar nawee- byɛ na mii ya.» ");
INSERT INTO xrb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","U cĩĩfa bya sẽ ba u ta pe Yatɛr ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu n pe pye ma yee: «Ta yale sẽ nɔ wa ye. Yii poo na, yalebyɛ yai ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ye wĩĩ saha fũhũ driyɛ̃fa ye ye; ndoo wĩĩ fũhũ pe ye, n pe yar n laha pe pyer sẽ yɔ̃ ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yii poo na, -ye dugu ga te gbar na! Ndoo sẽ n gaha yagaa ye, ta yale sẽ nɔ wa ye, koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tuu koo pãã wa pe ye, u n kuee Galɛlɛ kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu cĩĩfa pe ba dugu ga wa te gbar na, u bya n dugu ga; u sẽ -sẽ u ya yar nanihi wo ye, ma ta waa sẽ yi le cãŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yiifee- yahaseefa naa u kɛ te gbar na, ma naa le yey u ma na. ");
INSERT INTO xrb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pe nabuar naa u wĩĩ pãã. Mpãy naa n yee naweeyɔ̃ kẽ u ne, mpãy -sẽ naa n yee, a u nawee- plaha n le kãmpee wo. ");
INSERT INTO xrb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nawee- -sẽ naa n fya pe Yiifee- yahaseefa na, pe sẽ waha naa Yesu wĩĩ pãã pe laam ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te gbar plii ba la cɛr wa, Yesu n dugu ga ke Yãhã kangbãŋ wo, ma ga nii nawee- klaha. ");
INSERT INTO xrb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Le n pe Yiifee- yahaseefa fe gbe, pe n sya nii n yee, a u pye mii ma Yãhã sabangbãŋ wũhũ cã, woo wii u sẽ klaha yãã waa ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu n pe pye ma yee: «Tẽ nawee- klaha kai- nkãy ne, ta ya wũhũ sẽ kẽ ye. Yãhã gii ke ra nɔ wãã, koo wũhũ kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wii ma yee u ga Yãhã laam wĩĩ pye, ufua ga cã, le ma pye Yãhã kaklaha tẽ n klaha; le ma pye ta ya wĩĩ ne tẽ n klaha, u ga maha le cã. ");
INSERT INTO xrb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wii tuu u ya wĩĩ pãã, u n kɛ u ya myaha ke gboho; wii u nɔ wãã, u ma nii u nɔwããfua myaha gboho, woofua cĩĩnde pãã, u wĩĩ laa wee kawar wĩĩ ye, u wĩĩ laa wee le kããŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kãnde lii Yãhã le ta, Musa le yar ye na; yii nawee nen waa gɛ sẽ -sẽ wee u le yãr ye. Nwa ye n nii ra wãboo wĩĩ kɛ?» ");
INSERT INTO xrb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pe nabuar n u yɛ̃ sya ma yee: «Sãndũpee ma ma yĩŋ na. Yoo ma u ma wãboo wĩĩ kɛ?» ");
INSERT INTO xrb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu n pe yɛ̃ sya ma yee: «N kai laa pye kanii per wo, le n ye fe gbe. ");
INSERT INTO xrb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Wãkũũ nge gii faale wãlɛ pe cãã yir le ne, kur kuɛ ye, Musa bii le wãpye kãnde ta ye n nii le pye. Ah ndee, wãkũũ per gii ma sroŋ kanii per ne, ye ma ne le pye koo kanii per wo? ");
INSERT INTO xrb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tee -sẽ wãkũũ kũũ kanii per na, ma yee loo sroŋ Musa kãnde na, ah nwa ta ye n nii ra kɛ yĩntayãhã ne, ma yee n tee nawee ta u n jaa kanii per wo? ");
INSERT INTO xrb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ye ma syi ye nawee sãhã kai ne ke dyaŋ, mii ye sẽ le kai war ye! Ye yai ye yãŋ le le kai wo, -tee maha sroŋ ye cã ufua sãhã!» ");
INSERT INTO xrb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yurusalɛmfa mpãy naa le pãã ma yee: «Wii wãboo wĩĩ pe n kɛ, woo sẽ na nwo? ");
INSERT INTO xrb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","U nwo u nii n pãã pra, pe sẽ maha laa gɛ pãã u ne ye! Pe yahaseefa ga pye pe le yãŋ cã cĩĩnde ma yee, woo kẽ u Yãhã Yĩndefua Crise ne. ");
INSERT INTO xrb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wo -sẽ dya nwo woo yisaha cã; Crise woo -sẽ na, woo ma ba pa, waa saa ba u yisaha cã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu pye pe nawee- wãklaha na ke Yãhã kangbãŋ wo, u n tẽ sya ma yee: «Ye yee ye ra cã, ma maha ra yisaha cã! N sẽ pa nii ya wãpaŋ na ye. Koo gii ke -sẽ ra nɔ wãã, cĩĩnde na ke ma; ye sẽ ke cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndoo ke cã, n yir koo fla na, koo maha kẽ ke ra nɔ wãã.» ");
INSERT INTO xrb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pe n nii u yigisaha kɛ, waa sẽ -sẽ koho taha u na ye; u yale sẽ ba nɔ wa ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe nabuar mpãy n u ta pe Yatɛr, ma nii le pãã ma yee, a u Crise ma ba pa, u ga ba laanwɔ wũhũ pye la u ta tɛr nwo yaha? ");
INSERT INTO xrb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pe nabuar pe naa kai- ngĩĩ wlũhũ naa n pãã Yesu wĩĩ na, pe Farisyɛ̃ n ke luhu. Loo na, pe Yãhã yũndefa yĩŋfa n yir pe Farisyɛ̃ ne, ma Yãhã kangbãŋ sẽŋfa nɔ wãã pe ba Yesu yigi. ");
INSERT INTO xrb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu tuu yãã ke syi, u naa mpãy klaha, u n pe yar ma yee: «N ga faa kuee ye ne n ba yalaa dye, tẽ ba tɛr kii fla na ke ra nɔ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ye ga ba naa ra kɛ, ye sẽ -sẽ ga ba ra yãã ye. Tẽ ga ba pye fla ngii na, ye saha ka ke fla na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pe Yiifee- yahaseefa pe loo luhu, pe n nii pe ya yey ma yee: «U ga ba ka na, wo saa ba u yãã ye? Yiifee- mpãy pe cããŋ ma ga nii Jrɛkefa fla na, u ga ba ka la poo fla na, u ga naa pe klaha? ");
INSERT INTO xrb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","U maha le pãã ma yee, too ga ba naa woo kɛ, wo sẽ -sẽ ga ba u yãã ye, tuu ga ba pye fla ngii na, wo saha ka ke fla na ye. Koo kaplãŋ ngĩĩ yĩntaha kẽ lii ne?» ");
INSERT INTO xrb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te gbar kuaper, koo gii ke ma te gbar perngbãŋ, Yesu n yir yɛr pe nawee- telai wo, ma tẽ sya ma yee: «Loho fãã ma wii yigi, u pa ra ye u ba wɔ. ");
INSERT INTO xrb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wii ma ra ta u Yatɛr, loho gii ke cĩĩnde yrã wãã nawee kẽ, ke ga ba fã naa n dye ufua laam wo, mii le ma le yrũhũ yaha Yãhã sabangbãŋ wo mii.» ");
INSERT INTO xrb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yãhã Yrã Fãnga ne Yesu u naa n yãŋ, loo lii mpãy pe ba u ta pe Yatɛr, pe ne ga ba le yãã, pe sẽ -sẽ ba le yãã wa ye. Loo yale wo, le Yãhã Yrã Fãnga sẽ ba kẽ wa ye. Yãhã sẽ ba Yesu miingbãŋ ta ke n yi wa ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pe nabuar pe ba Yesu kaplãŋ luhu, mpãy naa n yee, a Yãhã kaplãŋ tɔ̃rfua kẽ u ne cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mpãy naa n yee, a u Yãhã Yĩndefua Crise kẽ u ne. Mpãy naa n yee: «U Crise yai la u yi Galɛlɛ kãntraha wo cĩĩnde? ");
INSERT INTO xrb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Le sẽ yrũhũ yaha la Yãhã sabangbãŋ wo, a u Crise ga ba nii wo faale yĩŋfua Dawide kur kuɛ puee waa, u yi klo nde wo pe n yee Betelɛmu, Dawide u pye na?» ");
INSERT INTO xrb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pe nabuar kaplãŋ n nii ke ya wuhu na Yesu wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mpãy n yee poo ga u yigi; waa sẽ -sẽ koho taha u na ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pe Yãhã yũndefa yĩŋfa, tesẽ pe Farisyɛ̃ ne, pe ba Yãhã kangbãŋ sẽŋfa mpãy nɔ wãã pe ga Yesu yigi. Pe n dur ba pe fla na kãnwai ne, pe n pe yey nwa ta pe sẽ u Yesu yigi ba ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pe n pe yɛ̃ sya ma yee, poo sẽ waa yãã yãã tuu n pãã Yesu wãŋ syi dyaŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pe Farisyɛ̃ n pe pye ma yee: «Ye bya yãã u kaplãŋ luhu u n ye yĩy wã klaha? ");
INSERT INTO xrb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Yahaseefua waa yãã u ta u Yatɛr laa, Farisyɛ̃ naa waa? ");
INSERT INTO xrb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nabuar nde, te sẽ Yãhã kãnde cã ye, yoosẽn ma pe na!» ");
INSERT INTO xrb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛmu wii tuu ba yir yĩmper wo, ma ka Yesu fla na, u pye pe Yiifee- yahaseefa nen waa. U n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Wo kãnde na, pe ga waha wãpẽn ta la nawee na, mii pe sẽ cã u lii pye ye, mii pe sẽ maha u yɛ̃ yor luhu ye?» ");
INSERT INTO xrb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pe n u pye ma yee: «Ma bya ma la Galɛlɛfa naa? Maʼa le yãŋ Yãhã sabangbãŋ wo, maa yãã Yãhã kaplãŋ tɔ̃rfua sẽ yi yãã Galɛlɛ kãntraha na ye.»  ");
INSERT INTO xrb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Loo kur ye, nawee- byɛ n tɛr pe klɛ wo, ");
INSERT INTO xrb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu n -sẽ ka wolifyɛ yãŋ yĩŋ na. Katyir raa ter pye ke fla na, pe naa te yee wolifyɛ katyir. ");
INSERT INTO xrb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ke yĩŋsyii wo, sukũhũntãy na, u n maha dur ga ke Yãhã kangbãŋ wo, nawee- byɛ n pe ya wãã ba u fla na. U n tege nii, ma nii pe klaha. ");
INSERT INTO xrb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pe Yãhã kaiyarfa, tesẽ pe Farisyɛ̃ ne, pe n pa cɔɔ waa ne, pe ba u tã yigi naa ne. Pe n u cɔɔ le pe nabuar telai wo, ");
INSERT INTO xrb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ma Yesu pye ma yee: «Yĩŋfua, wo cɔɔ nwo tã yigi naa ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musa kãnde na le yee, cɔɔ nwo syi yai pe u waa boo ntẽmbar ne. Ah mboo -sẽ yee mii?» ");
INSERT INTO xrb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pe naa n kɛ pe u le namihi wo, u ma plaha pãã, pe waha yee u tee pye. Yesu ba yĩŋ kor le, ma naa n yrũhũ kɔ̃nde ne kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pe kuee naa u yĩntaha war ke kayey ne, u n ba yĩŋ kuã yir, ma pe pye ma yee: «Ye laam wo, wii ma pye kapee laa wee u yĩŋ na ye, u cãã u cɔɔ waa yãŋ ntẽmblaha ne.» ");
INSERT INTO xrb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","U n maha yĩŋ kor le, ma nii n yrũhũ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pe nawee- pe kaplãŋ ngĩĩ luhu, laam sẽ sya pe ye ye, pe n nii n tɛr nanem nanem, ma cãã gbe pe wãlɛ na, ma sya ga kua. U cɔɔ ya n ba kuee Yesu ne, cɔɔ wii pe ba le telai wo. ");
INSERT INTO xrb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu n ba yĩŋ kuã yir loo na, ma u cɔɔ ya yãã, ma u pye ma yee: «Cɔɔ, mpãy pe le kai nde pãã taha ma na, pe ma na? Waa sẽ ngaa pye la ma na?» ");
INSERT INTO xrb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","U cɔɔ n yee: «Aye, Yĩŋfua.» Yesu n u pye ma yee: «Ta bya, n saa laa pye ma na ye; ka, maʼa syi ma kapee pye nantãŋ ye!» ");
INSERT INTO xrb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Loo kur ye, Yesu n maha te nabuar pye ma yee: «Ndoo tẽ ma cãã- driyɛ̃ wo. Wii ma n taha ra na, u saa naa n yãr wam wo ye, ufua ga cãã- yãã, cãã- mpãy pe cĩĩnde yrã wãã nawee kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pe Farisyɛ̃ n u pye ma yee: «Ma ya wĩĩ ne raa n pãã mii ya; ma kapãn saha nii cĩĩnde ye.» ");
INSERT INTO xrb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu n pe yɛ̃ sya ma yee: «Tẽ sya nii wĩĩ pãã nii ya, ta kapãn ma cĩĩnde; ye sẽ yãã, n ta yisaha cã, ma maha ra kasaha cã; yii sẽ -sẽ ra yisaha cã ye, ye sẽ maha ra kasaha cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ye nawee sãhã ke dyaŋ ye laam wũhũ ya ne. Ndoo sẽ wee tẽ waa sãhã ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","N ma sya waa sãhã, ta kaplãŋ ma cĩĩnde, ndoo ya yɛ̃ kaplãŋ sẽ kẽ ye; ta Tuhufua Yãhã gii ke ra nɔ wãã, ke ma ra ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ye wãlɛ kãnde na, le ma le yrũhũ yaha ma yee, nawee- syãm yɛ̃ kaplãŋ ma pye wãcɛŋ, pe kapãn ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","N ta wĩĩ pãã nii ya, ta Tuhufua Yãhã gii ke ra nɔ wãã, ke bya maha ra wĩĩ pãã.» ");
INSERT INTO xrb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Loo na, pe n u pye ma yee: «Ma Tuhufua ma na?» U n pe yɛ̃ sya ma yee: «Ye sẽ ra cã ye, ye sẽ ra Tuhufua bya cã ye. Ye ma ne pye ye ra cã, yaa ne ra Tuhufua bya cã.» ");
INSERT INTO xrb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu pye Yãhã kangbãŋ wo, war lesaha fla tãy, ma naa ke kaplãŋ pãã. Waa gɛ sẽ koho taha u na ma yee u ga u yigi ye. U yale sẽ ba nɔ wa ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu n maha pe yar ma yee: «N ga ba tɛr. Ye ga ba naa ra kɛ, ye sẽ -sẽ ga ba ra yãã ye. Ye ga ba ku ye kapee- koho wo. Tẽ ga ba ka fla ngii na, ye saha ka ke fla na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pe Yiifee- yahaseefa n yee: «Tuu yee woo ga ba ka fla ngii na, wii saha ka ke fla na ye, ah u yãã ga u ya boo, ma n pãã ke syi?» ");
INSERT INTO xrb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu n pe pye ma yee: «Kãntraha nge nawee- me ye ne, ndoo -sẽ yi yãhãyĩŋ na. Driyɛ̃ nge nawee- me ye ne, ndoo sẽ -sẽ yi driyɛ̃ nge wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Loo ne, ta n ye pye ma yee, yaa ku ye kapee- koho wo. Tẽ ma ngii, ye ma yee ye sẽ loo sya cĩĩnde ma ra ta ye Yatɛr ye, ye ga ku ye kapee- koho wo.» ");
INSERT INTO xrb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pe n u yey ma yee: «Nwa kẽ ma ne?» Yesu n pe yɛ̃ sya ma yee: «Tẽ cãã lii pãã ye ye, loo ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kai- busãã ma tẽ ga pãã ye wĩĩ na, tesẽ kai- busãã ne tẽ ga sãhã ye wĩĩ na; wii tuu -sẽ ra nɔ wãã, u wĩĩ ma cĩĩnde; tẽ lii luhu u ye, loo ne tẽ n pãã driyɛ̃fa ye.» ");
INSERT INTO xrb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pe sẽ ba cã ma yee u Tuhufua Yãhã wĩĩ ne u n pãã pe ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu n pe pye loo na ma yee: «Ye ma ba ndoo u Nawee Puee kuã yir ta, yaa cã cã n ma ngii. Ye ga maha cã, ta ya wũhũ sẽ kẽ tẽ n pye ye. Ta Tuhufua Yãhã ke ra klaha kai- nkãy ne, koo kẽ tẽ n pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Koo gii ke ra nɔ wãã, ke ma ra ne. Ke sẽ ra ta yaha nii ya ye, lii le n tãy ke ye, n loo pye yalebyɛ, koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu tuu koo kaplãŋ pãã ke syi, nawee- busãã n u ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yiifee- mpãy pe ba Yesu wĩĩ sya cĩĩnde, u n pe pye ma yee: «Ye ma ra kapãn le yaha ye laam wo, ye ma ra kãnyãrwai cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ye ga ba le cĩĩnde wĩĩ cã, le n ye yi kãã yãmpar wo.» ");
INSERT INTO xrb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pe n u yɛ̃ sya ma yee: «Wo faale Brama kur me wo ne, wo sẽ nii yãã waa yãmpa ye; ma -sẽ maha pye mii ma yee, wo n pai yi kãã yãmpar wo?» ");
INSERT INTO xrb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu n pe yɛ̃ sya ma yee: «Ta n cĩĩnde nde pãã ye ye: Wii u kapee- pye, u ma kapee- wãpyeŋ yãmpuai. ");
INSERT INTO xrb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yãmpuai sẽ kuee yai n tãŋ u yĩŋfua kaha na ye. U yĩŋfua dya woo na, woo kuee yai n tãŋ ke kaha wo u kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","U Yãhã Dya ma ye yi kãã kapee- wãpyeŋ yãmpar wo, ye ga tefay yãã ye kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N cã ma yee Brama kur kuɛ pii me ye ne; ye -sẽ ra wãboo wĩĩ kɛ, ta kaplãŋ sẽ n tãy ye ye ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tẽ lii yãã ra Tuhufua Yãhã ye, loo ne tẽ n pãã. Yii, tee -sẽ lii luhu ye tuhufua ye, loo ne tee n pye.» ");
INSERT INTO xrb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pe n Yesu pye ma yee, poo tuhufua kẽ Brama ne. Yesu n pe pye ma yee: «Ye ma ne pye Brama pii, tuu naa kai- nkãy pye, ye ne ga naa koo pye. ");
INSERT INTO xrb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yagaa, ye mii ye ndoo wãboo wĩĩ kɛ, ndoo wii tẽ le cĩĩnde pãã ye ye, cĩĩnde lii tẽ luhu Yãhã ye. Ye wĩĩ nde, Brama sẽ loo pye ye rɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye tuhufua wĩĩ ne tee n pye.» Pe n u pye ma yee, tããndya pii sẽ me poo ne ye, a tuhufua nen ya u ma poo ye, woo kẽ Yãhã ne. ");
INSERT INTO xrb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu n pe pye ma yee: «Yãhã ma ne pye ye Tuhufua, ta ntãŋ ne ga dye ye tãy. Ye sẽ yãã, n yi Yãhã fla na, koo fla kẽ tẽ yir, ma pa. N sẽ pa nii ya wĩĩ na ye, koo ke ra nɔ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nwa ta ye sẽ ra kaplãŋ war ye? Ke wãluhu laam wee ye na ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye tuhufua kẽ sãndãpee yĩŋfua Setane ne. Ye n kɛ ye naa ye tuhufua laam wĩĩ pye. U yir u naboor ne ke kai- fegbecãã na, u sẽ tãhã n yɛr cĩĩnde fla na ye. Woo gɛ, u wĩĩ laa wee cĩĩnde ye. Kawar wãfua koo ke ma woo tẽn. Ye sẽ yãã, u ma kawarfuafua, ma maha ma kawar tuhufua. ");
INSERT INTO xrb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ndoo wii tẽ -sẽ cĩĩnde pãã ye ye, ye sẽ ra wĩĩ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ye laam wo, yoo ma u ga waha yee n kapee pye? Tẽ cĩĩnde pãã ye ye, nwa ta ye sẽ ra wĩĩ sya cĩĩnde ye? ");
INSERT INTO xrb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wii u ma Yãhã wũũ, ufua ke kaplãŋ luhu; yii sẽ n luhu ke ye ye, ye wee ke wãm ye, koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pe Yiifee- yahaseefa n u pye ma yee: «Wo tãhã sẽ na, too ne yee Syamarifa naa kẽ ma ne, ma maha n yee, a sãndũpee ma ma yĩŋ na?» ");
INSERT INTO xrb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu n pe pye ma yee: «Ngaa sãndũpee wee ra yĩŋ na ye. N ta Tuhufua Yãhã miingbãŋ gboho, ye -sẽ ra tyɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","N sẽ n kɛ ra myaha ke yi ye; waa -sẽ ma u n kɛ ra myaha ke yi, u kasãhã ma nawee- na. ");
INSERT INTO xrb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ta n cĩĩnde nde pãã ye ye: Wii ma ra kapãn sya, ufua saa ku yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pe Yiifee- n u pye ma yee: «Yagaa taa nde pãã, wo cã sãndũpee ma ma yĩŋ na. Wo faale wãdyaha Brama ku, pe faale Yãhã kaplãŋ tɔ̃rfa byɛ ku; mboo -sẽ yee, a wii ma mboo kapãn sya, ufua saa ku yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wo wãdyaha Brama wii tuu ku, ma tɛr la u yaha? Pe Yãhã kaplãŋ tɔ̃rfa gɛ, pe byɛ sẽ ku la? Mboo -sẽ mii ta nwasyifua?» ");
INSERT INTO xrb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu n pe yɛ̃ sya ma yee: «N ma pye n nii myaha sey nii ya, koo wee ngaa ye. Ta Tuhufua Yãhã kẽ ke ra myaha sey, koo gii tee ne yee ke ma ye Yãhã, ");
INSERT INTO xrb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ye sẽ maha ke cã ye. Ndoo ke cã; n ma yee n sẽ ke cã ye, n ga nii kawarfuafua ye wãŋ syi dyaŋ. N ke cã, n ke kaplãŋ le n yaha ra laam wo. ");
INSERT INTO xrb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wo wãdyaha Brama cãã cã, u ga ba ra wãpaŋ yãã; le n tãy u ye. U n -sẽ ba ke yãã, ma sya nuhu di le na.» ");
INSERT INTO xrb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pe n u pye ma yee: «Ma sẽ dyɛ- gbeesĩĩ sẽnsye gɛ yãã wa ye, ma -sẽ yee, a mboo wo faale Brama yãã!» ");
INSERT INTO xrb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu n pe pye ma yee: «Ta n cĩĩnde nde pãã ye ye: Brama sẽ bii see wa ye, ndoo -sẽ cãã pye wa.» ");
INSERT INTO xrb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pe Yiifee- pe nde luhu, pe n yee poo ga u waa ntẽmbar ne. Yesu n plaha pe na ke Yãhã kangbãŋ wo, ma yi tɛr. ");
INSERT INTO xrb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Per gaa, Yesu naa n tɛr, ma ba fũũ naa waa yãã. U ba see ke dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesu kãnyãrwai n Yesu yey ma yee: «Yĩŋfua, fũũ naa nwo tuu see ke syi, yoo kapee wãpyeŋ kẽ le ta loo nde n u dye? Woo tuu kapee pye, laa u seefa?» ");
INSERT INTO xrb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu n pe yɛ̃ sya ma yee: «Le sẽ nii mii u kapee pye, laa na u seefa ye. U see ke syi, Yãhã ga laa pye u na, nawee- byɛ n le yãã yĩnde ne, pe ke miingbãŋ gboho. ");
INSERT INTO xrb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Koo gii ke ra nɔ wãã, n yai n ke tẽn tẽ yagaa, yai ke sẽ kua wa ye. Yĩmper ma ke ga ba wɔ. Waa wee u tẽn tẽ yĩmper wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tẽ nwo driyɛ̃ laam wo, n ma cãã- driyɛ̃fa ye.» ");
INSERT INTO xrb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu tuu koo pãã wa, u n yɛ̃syɔ̃r tu kãntraha na, ma poor tũhũ, ma te pye ta u fũũ naa yĩmpɛ na, ");
INSERT INTO xrb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ma u pye ma yee: «Ka, maa ma yĩntaha yee loho nge wo pe n yee Syilwee.» Ke Syilwee yĩntaha kẽ: Wii pe u nɔ wãã. U fũũ n ka, maa u yĩntaha yee ke wo. Tuu dur ga kaha wo, u naa n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","U kasohofa, ma suhu mpãy ne pe ba u cã, ma cã u naa n nar, pe u yãã pe n nii n yee: «Wii u ba tege nii naa nawee- nar, woo sẽ na?» ");
INSERT INTO xrb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mpãy naa n yee woo kẽ, mpãy -sẽ naa n yee, a u tayfua kẽ. Woo -sẽ naa pe yar ma yee woo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pe n u yey loo na ma yee: «Ma yĩmpɛ pye mii ma jaa ma ye, ma n waha n yãŋ?» ");
INSERT INTO xrb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","U n pe yɛ̃ sya ma yee: «Dya wii pe n yee Yesu, woo u poor pye ta ra yĩmpɛ na, ma ra pye n ga ra yĩntaha yee loho nge na pe n yee Syilwee. Ta n ka, maa ra yĩntaha yee, ma yãã n waha n yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pe n u yey ma yee, u dya ma na. U n yee woo cã na. ");
INSERT INTO xrb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dya wii tuu pye fũũ, pe n ka u ne Farisyɛ̃ ye fla na. ");
INSERT INTO xrb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kanii per -sẽ ba kẽ Yesu tuu ba te poor ta, ma u yĩmpɛ jaa u kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pe Farisyɛ̃ n maha u yey ma yee, u pye mii ma waha jaa, ma n yãŋ. U n pe pye ma yee: «U poor pye ta ra yĩmpɛ na, ta n ga ra yĩntaha yee, ma yãã n n yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Loo na, Farisyɛ̃ mpãy n le pãã ma yee, Yãhã sẽ kẽ ke dya nwo nɔ wãã ye, a u ke kanii per kapĩĩ wĩĩ pye n klaha-. Mpãy n -sẽ yee, a kapeepyefua ga waha laanwɔ wũhũ ngĩĩ syi pye mii? Pe yɛ̃ kaplãŋ n nii ke ya wuhu na. ");
INSERT INTO xrb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","U dya wii tuu pye fũũ, pe n maha u yey ma yee: «U dya wii tuu ma yĩmpɛ jaa ma kẽ, mboo yee nwasyifua kẽ u ne?» U n pe yɛ̃ sya ma yee: «Yãhã kaplãŋ tɔ̃rfua kẽ u ne.» ");
INSERT INTO xrb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pe sẽ le sya cĩĩnde ma yee u pye fũũ, ma ba jaa ma waha n yãŋ ye; pe n sya ta pe n u seefa yee ba. ");
INSERT INTO xrb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pe n pe yey ma yee: «Ye dya wii tee yee u see fũũ, woo la nwo? Ah u pye mii ma waha n yãŋ yagaa?» ");
INSERT INTO xrb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","U dya seefa n pe yɛ̃ sya ma yee: «Wo cã wo dya kẽ u ne, u see fũũ. ");
INSERT INTO xrb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tuu -sẽ pye mii ma waha n yãŋ yagaa, tesẽ yoo tuu u jaa, loo too sẽ cã ye. -Ye woo gɛ yey, kicar sẽ kẽ u ne ye, u ga waha u ya yĩŋ wĩĩ pãã.» ");
INSERT INTO xrb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","U seefa naa n fya pe Yiifee- yahaseefa na, koo kẽ pe n ba pãã ke syi. Pe Yiifee- yahaseefa ba le pãã ta wa ma yee, wii ma yee Yesu kẽ u Yãhã Yĩndefua Crise ne, ufua saa naa n dye pe Yiifee- yawãhã nwoŋ wo nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Koo kẽ u dya seefa n ba yee pe u dya gɛ yey, a kicar sẽ kẽ u ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","U dya wii tuu pye fũũ, pe Farisyɛ̃ n u yey ke tɛhɛ syãŋ wuhu na ma yee: «Yãhã yãŋ, ma cĩĩnde pãã. Wo cã kapeepyefua kẽ dya nwo ne.» ");
INSERT INTO xrb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","U n pe yɛ̃ sya ma yee: «U ma pye kapeepyefua, n sẽ waha loo cã ye. Lii ya tẽ cã, n pye fũũ, yagaa n n yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pe n u pye ma yee, Yesu u pye mii, u u yĩmpɛ jaa mii? ");
INSERT INTO xrb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","U n pe yɛ̃ sya ma yee: «N le pãã wa ye ye, ye sẽ ra kapãn luhu la? Ye yee yaa maha le luhu ye nwa pye? Ye n traha la ye nii u kãnyãrwai?» ");
INSERT INTO xrb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pe n u tyɛhɛ, ma dur ma u pye ma yee: «Mboo kẽ raa ma u kãnyãrwɛ, wii ma wo faale wãdyaha Musa kãnyãrwai. ");
INSERT INTO xrb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wo cã Yãhã bii pãã Musa ne; nwo woo na, wo sẽ u yisaha cã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","U dya n pe yɛ̃ sya ma yee: «Tee yee ye sẽ u yisaha cã ye, le yɛ̃ gbãã ra na; woo -sẽ kẽ u ta ra yĩmpɛ n jaa. ");
INSERT INTO xrb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mpãy pe ma kapee- wãpyeŋ wo, wo cã Yãhã wee ke n luhu poo wãnar ye ye. Wii tuu -sẽ ke myaha gboho, ma ke laam wũhũ pye, ke n luhu woofua wãnar ye. ");
INSERT INTO xrb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ma gbe driyɛ̃ wãtãhã na, waa sẽ le luhu yãã pe yee waa fũũ yĩmpɛ jaa yãã ye, wii syi u see fũũ. ");
INSERT INTO xrb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ke ma ne pye Yãhã sẽ kẽ ke dya nwo nɔ wãã ye, u saa ne waha laa gɛ pye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pe n u pye ma yee: «Ma see yi tãŋ kapee- wãpyeŋ wo, yoo raa yee maa klaha?» Pe n u tã pe Yiifee- yawãhã nwoŋ wãdyeŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu n u dya wãkar wĩĩ luhu, u n u yãã, maa u pye ma yee: «Ma u Nawee Puee ta la ma Yatɛr?» ");
INSERT INTO xrb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","U n u yɛ̃ sya ma yee: «Yĩŋfua, yoo kẽ u ne? U yar ra na, ra n u ta ra Yatɛr.» ");
INSERT INTO xrb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu n u pye ma yee: «Ma u yãã; woo gɛ kẽ tuu n pãã ma ne yagaa.» ");
INSERT INTO xrb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","U dya n kãnklũy gbãã Yesu yaha ye, ma u pye ma yee: «Yĩŋfua, n ma ta ra Yatɛr.» ");
INSERT INTO xrb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Loo kur ye, Yesu n yee: «N pa driyɛ̃ wo, n n pai kasãhã raa yĩntaha yi, n ta, mpãy pe sẽ n yãŋ ye, pe waha naa n yãŋ; tesẽ, mpãy pe yee poo n yãŋ, pe nii fũũ- wãŋ syi.» ");
INSERT INTO xrb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisyɛ̃ mpãy pe pye u ne, pe kaplãŋ ngĩĩ luhu, pe n u pye ma yee: «Wo bya ma la fũũ- wãŋ syi?» ");
INSERT INTO xrb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu n pe pye ma yee: «Ye ma ne pye fũũ- wãŋ syi dyaŋ, kapee saa ne pye ye yĩŋ na ye; tee -sẽ yee yii n yãŋ, ye kapee- ga kuee ye yĩŋ na.» ");
INSERT INTO xrb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Loo kur ye, Yesu n maha kaplãŋ kuã cra pãã pe nawee- ye ma yee: «Ta n cĩĩnde nde pãã ye ye: Wii ma yee u sẽ dye mbaa naklaha yɛ̃ ne ye, ma teele laa yãŋ ke kãnkãy na ma dugu dye, yuhu naboofua kẽ woosyifua nwo ne. ");
INSERT INTO xrb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma -sẽ yee wii woo na tuu n dye ke mbaa naklaha yɛ̃ ne, u mbanaha kẽ woo ne. ");
INSERT INTO xrb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yuhu- sẽŋfua pe mbaa na, u n sya ma ke naklaha yɛ̃ yãr u mbanaha kẽ. Pe mbaa byɛ, pe n sya ma n luhu u ye. U myaha taha pe mbaa byɛ na, ma pe yee te ne, pe n yi n taha u na nkur ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","U ma ta u mbaa byɛ n yi taha tãŋ wa u na nkur ye, pe mii pe u yĩmbui cã wa, u ga naa n yãr pe yahasee ye, pe n naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pe saa sya pe taha naweetee na ye, wii pe sẽ cã ye. Pe sẽ woo yĩmbui cã ye, pe ga fã dey u na.» ");
INSERT INTO xrb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu tuu kakuãcran nde tɔ̃r pe nawee- ye, pe sẽ laa gɛ war le wĩĩ na u ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu n maha yee: «Ta n cĩĩnde nde pãã ye ye: Ndoo tẽ ma pe mbaa naklaha yɛ̃. ");
INSERT INTO xrb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mpãy byɛ pe cãã pa ra yaha, pe pye yuhu- naboofa. Pe mbaa sẽ -sẽ naa n luhu pe ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ndoo kẽ ke naklaha yɛ̃. Wii ma ra ta u Yatɛr, ma dye ra kuɛ koho ye, u yĩŋ pahasaha yãã. U ga waha naa n dye u laam, tuu dur naa n yi, tuu naa u digi yãã. ");
INSERT INTO xrb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yuhu woo n pai wãyuhu troho ne, wãboo yĩmbui ne, kaklaha- koho ne. Ma -sẽ yee ndoo woo na, n pa ma yee, mpãy byɛ pe ga naa n dye ra kuɛ koho ye, n ga cĩĩnde yrã wãã pe kẽ; tesẽ, ngaa saa kɛ laa pe ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yesu n maha yee: «Ndoo tẽ ma u mbanahayɔ̃. U mbanahayɔ̃ u mbaa gbã ku. ");
INSERT INTO xrb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tẽntẽle ma pye mbaa na, u tẽn tẽ wale myaha na. Woo sẽ -sẽ kẽ u mbanaha ye; woo sẽ kẽ u mbaafua ye. U ma waygapyãhã yãã, ke n pai pe mbaa ye, u ga fã tɛr pe yaha, ke n ba dye yigi pe laam wo, ke pe ta pe n fã cããŋ. ");
INSERT INTO xrb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Lii le ma ne usyifua ta u n le pye ke syi, wale wĩĩ ya le ma ne pye u na, u kalaa sẽ ma ne pye pe mbaa poo na ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ndoo kẽ u mbanahayɔ̃. N ta mbaa wĩĩ cã, pe bya ra wĩĩ cã. ");
INSERT INTO xrb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ta Tuhufua Yãhã ke ra wĩĩ cã mii syi dyaŋ, ta n -sẽ u wĩĩ cã mii, n ma ke syi ra mbaa ne. N ga pe gbã ku. ");
INSERT INTO xrb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mbaa mpãy maha ma ra ye. Poo ter wee naklaha nge wo ye. N yai n ga pe bya kuar ba le taha, n ba naa n naha. Pe ga ba naa ra yĩmbui luhu. Pe byɛ ga ba wãã le, pe nii naklaha neŋ, mbanaha nen ne. ");
INSERT INTO xrb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ta ntãŋ dye ra Tuhufua Yãhã tãy. N yɛr ta yrã wãwãã wĩĩ na, n ku, tẽ ba dur, n maha le sya. Loo ne, ta ntãŋ n dye ta Tuhufua Yãhã tãy. ");
INSERT INTO xrb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nawee waa sẽ kẽ tuu ga waha ta yrã sya ra ye ye. Le tãy ra ye, koo kẽ n ga le wãã, n ku. Le wãwãã fãnga ma ra ye, le wãsya fãnga ne. Ta Tuhufua Yãhã ke ra taha lii na, loo kẽ loo nde ne.» ");
INSERT INTO xrb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu kaplãŋ n maha ta, Yiifee- n nii n pãã wuhu na crɛŋcrɛŋ. ");
INSERT INTO xrb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Poo busãã naa n yee: «Sãndũpee waa u yĩŋ wũhũ wlãhã, u n sroŋ cɔ̃ŋ. Waa ma n ndityuhu yaha u ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mpãy, ma -sẽ naa n yee: «Sãndũpeefua kaplãŋ sẽ kẽ ngĩĩ ye. Nawee wii sãndũpee ma u yĩŋ na, u ga waha fũũ yĩmpɛ yãr la u kẽ, u n waha naa n yãŋ?» ");
INSERT INTO xrb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pe ba naa ke Yãhã kangbãŋ wãfãã gbar gbar, dyadyɛ wãŋ syi dyaŋ, Yurusalɛm wo. Le pye wɛr cãã. ");
INSERT INTO xrb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu -sẽ pye, u naa n tay ke Yãhã kangbãŋ wo, ntẽmbar laankɔngbãŋ gaa flãhã tãy, pe naa ke yee Salmuu laankɔŋ. ");
INSERT INTO xrb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pe Yiifee- yahaseefa n pa, ma ba u gbey le, ma u pye ma yee: «Le ma pye mboo kẽ u Yãhã Yĩndefua Crise ne, le pãã laha wo ye. Ma sẽ yãã, ma wo ta wo n nii laalaa pye n tɛr ma wĩĩ na.» ");
INSERT INTO xrb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu n pe yɛ̃ sya ma yee: «N le pãã wa ye ye, ye sẽ -sẽ ra wĩĩ sya cĩĩnde ye. Ta Tuhufua Yãhã kai- ngĩĩ wãpyeŋ kãnde wãã ra kẽ; loo nde gɛ ra wĩĩ pãã n laha ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ye sẽ -sẽ ra wĩĩ sya cĩĩnde ye; ye wee ra mbaa ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta mbaa ra yĩmbui luhu. Ndoo pe cã, pe n taha ra na. ");
INSERT INTO xrb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N cĩĩnde yrã wãã pe kẽ, lii wãkuayãã wee le na ye. Pe wĩĩ saa klaha- yãã ye, waa saha pe tyĩn sya ra koho wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ta Tuhufua Yãhã gii ke pe le soho ra koho wo, koo kẽ ke ma fãnga byɛ yĩŋ na, waa saha pe tyĩn sya ke koho wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ndoo, tesẽ ra Tuhufua Yãhã ne, wo ma nen.» ");
INSERT INTO xrb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Loo na, pe Yiifee- yahaseefa n maha yee poo ga u waa ntẽmbar ne. ");
INSERT INTO xrb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu n pe pye ma yee: «N kayũhũ busãã pye yar ye na, ta Tuhufua Yãhã kãmay na. Ye yee yaa ra waa ntẽmbar ne koo kayũhũ ngĩĩ lii loo wĩĩ na?» ");
INSERT INTO xrb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pe n u yɛ̃ sya ma yee: «Wo sẽ yee waa ma waa ntẽmbar ne kayĩĩ laa wĩĩ na ye, wo yee ma n gbar Yãhã ne, koo kẽ; taa ma nawee, ma sẽ yai ma yee ma ma Yãhã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu n pe yɛ̃ sya ma yee: «Yãhã sabangbãŋ wo, le ma le yrũhũ yaha ma yee, Yãhã yee: ‹Ye ma Yãhã pii.› ");
INSERT INTO xrb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wo cã Yãhã sabangbãŋ ma lii pãã, le saha kuã kãã ye. Le Yãhã kapãn le pãã wãã nawee- mpãy kẽ koo fla na, Yãhã yee pe ma Yãhã pii. ");
INSERT INTO xrb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yãhã ma -sẽ yee pe ma Yãhã pii, ndoo wii Yãhã ra yãŋ yi, ma ra nɔ wãã driyɛ̃ wo, ye pye mii ma yee n n gbar Yãhã ne, a n tee yee n ma Yãhã Dya? ");
INSERT INTO xrb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Le ma pye ra Tuhufua Yãhã kai- sẽ kẽ tẽ n pye ye, ye ma syi ye ra kaplãŋ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","N ma -sẽ ke pye, ye ma sya yee ye saa ra kaplãŋ sya cĩĩnde ye, tẽ -sẽ kai- nkãy pye, -ye koo sya cĩĩnde! Loo na, ye ga le cã laha ye yee, ndoo tesẽ ta Tuhufua Yãhã ne, loho sẽ n yi wo nsoho wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pe n maha yee, poo ga u yigi, u n wloho yi pe laam wo ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Loo kur ye, Yesu n ka maa kuee Yurdane lafeŋ kũndi ngaa ye. Koo fla kẽ Nsãn tuu cãã pye, ma ba naa nawee- tãã naa n yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nabuar n pa Yesu fla na, ma ba nii le pãã pe ya ye ma yee: «Nsãn sẽ ba laanwɔ wĩĩ laa pye ye, tuu -sẽ ba kai- nkãy byɛ cãã pãã yaha dya nwo wĩĩ na, ke byɛ nii cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nawee- busãã n Yesu ta pe Yatɛr ke fla na. ");
INSERT INTO xrb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yan ba dya waa yigi, u myaha Laasar. U pye klo laa wo pe naa n yee Gbetane. U syafa pye ke fla na, Maari ma suhu u lɛfua Marti ne. ");
INSERT INTO xrb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Woo Maari nwo kẽ tuu ba lasekole woo Yesu na, ma u yĩnyor ta ma Yesu trɛ kluã u kẽ. Woo laŋ Laasar kẽ tuu pye yanfua. ");
INSERT INTO xrb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","U syafa n lɛhɛ wãã, pe ga Yesu yar u naambiyãbua wee wãwee ye. ");
INSERT INTO xrb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu tuu le luhu, u n yee: «Laasar yan nde saha u boo ye; te ga ta nawee- n Yãhã fãngangbãŋ yãã yĩnde ne, loo nde kãmay na Yãhã Dya myaha ga yi.» ");
INSERT INTO xrb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Marti ma suhu u cĩĩfua Maari ne, ma suhu Laasar ne, pe byɛ ntãŋ ba dye Yesu tãy. ");
INSERT INTO xrb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu tuu u Laasar yan wĩĩ luhu, tuu pye teelii wo, u n kuee ma plii sĩĩ pye ke fla na, ");
INSERT INTO xrb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ma ba u kãnyãrwai pye ma yee, pe dur ga Yudɛ kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","U kãnyãrwai n u pye ma yee: «Yĩŋfua, yagaa ya pe Yiifee- naa n kɛ pe ma waa boo ntẽmbar ne ke fla na, ma maha yee mboo ga dur ga ke fla na!» ");
INSERT INTO xrb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu n pe yɛ̃ sya kakuãcran ne ma yee: «Per neŋ laam wo, yai wee la lɛr sẽnsye syãm, ma gbe sukũhũntãy na, ma sya ga waa yainkɔŋ wo? Wii u n yãr yai na, u sẽ n kũn ye, u yãhãcãã- yãã, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wii u -sẽ n yãr yĩmper wo, u n kũn, cãã- wee u na ye, koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu tuu koo kaplãŋ pãã wa pe ye, u n pe pye ma yee: «Wo naambiyã Laasar sã n wãy; n n gaha u gbã yir.» ");
INSERT INTO xrb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","U kãnyãrwai n u pye ma yee: «Yĩŋfua, u ma sã n wãy, u ga kãhã yir.» ");
INSERT INTO xrb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","U Laasar wãku wĩĩ ne Yesu tuu ba pãã pe ye, pe sẽ le war ye, ma yee cĩĩnde wãy Yesu u n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu n le pãã laha pe ye loo na ma yee: «Laasar ku. ");
INSERT INTO xrb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Too sẽ pye ke fla na ye, le tãy ra ye. Loo ga ta ye n ta sroŋ ta ye Yatɛr. -Too ka u fla na!» ");
INSERT INTO xrb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Loo na, Tema wii pe naa n yee Didim, koo yĩntaha wuhuwãã, u n pe kãnyãrwai mii pye ma yee: «Wo bya, -too yir taha u na, waa ku u ne.» ");
INSERT INTO xrb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu n ga dye gbe taha, ma luhu pe Laasar le wa gbĩĩ wo ke plii resyar kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Gbetane ke -sẽ pye Yurusalɛm tãy kilo tãã syi, ");
INSERT INTO xrb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yiifee- busãã n ba pa Marti ye fla na Maari ne, maa pe laŋ gbã syar pe ye. ");
INSERT INTO xrb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marti tuu luhu Yesu ma u n pai, u n ka maa u wãã; Maari -sẽ pye u ba tege nii kaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marti n Yesu pye ma yee: «Yĩŋfua, maʼa ne pye nwo, ta laŋ saa ne ku ye. ");
INSERT INTO xrb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ke yagaa nge gɛ na, n cã, maʼa ngii nar Yãhã ye, ke ga le pye ma kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu n u pye ma yee: «Ma laŋ ga yir gbã wo, u dur ba yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marti n u yɛ̃ sya ma yee: «Driyɛ̃ ma ba kua per gii, nawee- n ga yir gbã wo, pe nii yrãŋ na, n cã Laasar bya ga ba yir gbã wo, u nii yrãŋ na.» ");
INSERT INTO xrb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu n u pye ma yee: «Ndoo tẽ ma gbã yiafua, tesẽ ndoo tẽ ma yrã wããfua. Wii ma ra ta u Yatɛr, u ma sya ku, u ga ba nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tesẽ, wii ma pye yrãŋ na, ma ra ta u Yatɛr, ufua saa ku yãã ye. Ma loo nde sya la cĩĩnde?» ");
INSERT INTO xrb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marti n u yɛ̃ sya ma yee: «Ãwã Yĩŋfua, n cã mboo kẽ u Yãhã Yĩndefua Crise ne, woo wii u ma Yãhã Dya, woo wii u wãpaŋ bii cãã pãã yaha driyɛ̃ nge wo.» ");
INSERT INTO xrb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marti tuu koo pãã wa, u n tɛr, ma ga u cĩĩfua Maari yee, u sẽ ta waa n yi le cãŋ na ye, ma u pye ma yee: «U Yĩŋfua ma nwo, u ma yee.» ");
INSERT INTO xrb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maari tuu kaplãŋ ngĩĩ luhu, u n yir farfar, ma ka Yesu fla na. ");
INSERT INTO xrb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu sẽ ba dye wa le klo wo ye. Marti tuu ba u wãã sya teelii wo, u pye nantãŋ koo fla na. ");
INSERT INTO xrb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yiifee- mpãy pe pye Maari ne kaha wo, ma naa u flaŋ, pe yãã u yir yi farfar, pe n taha u na, ma yee u yi n tɛr u n gaha wũn le gbĩĩ fla wo. ");
INSERT INTO xrb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maari tuu ga nɔ Yesu fla na, ma u yãã yĩnde ne, u n kãnklũy gbãã Yesu yaha ye, ma u pye ma yee: «Yĩŋfua, maʼa ne pye nwo, ta laŋ saa ne ku ye.» ");
INSERT INTO xrb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maari naa n wũn, woo ma suhu pe Yiifee- mpãy ne pe ba pa u ne. Yesu tuu pe yãã, u laam byɛ n wlãhã. ");
INSERT INTO xrb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","U n pe yey ma yee, pe u le na? Pe n u pye ma yee: «Yĩŋfua, pa ma ba yãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu yĩntãm n yi. ");
INSERT INTO xrb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pe Yiifee- pe loo yãã, pe n yee u dya ntãŋ dye Yesu tãy cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Poo mpãy n -sẽ le pãã ma yee: «Woo wii tuu u fũũ naa yĩmpɛ jaa u n waha n yãŋ, u saa ne pye la u ta, dya nwo ma n ku ye?» ");
INSERT INTO xrb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu n ka le gbĩĩ fla na, u laam maha ba wlãhã u ye. Le gbĩĩ pye nkɔŋ dyaŋ yãŋ mpĩy ntẽmblaha fla na. Ntẽmbangbãŋ gaa pye, ke ba paha tã le gbĩĩ yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu n yee pe ke ntẽmbangbãŋ kloŋ kãã. U Laasar syafua Marti n Yesu pye ma yee, ke nakugu dugu n yi, pe ke le le gbĩĩ wo ke plii resyar nanga. ");
INSERT INTO xrb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu n u pye ma yee: «N sẽ ma pye la maʼa ra ta ma Yatɛr, maa Yãhã fãngangbãŋ yãã yĩnde ne?» ");
INSERT INTO xrb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pe n ke ntẽmbangbãŋ kloŋ kãã. Yesu n yĩntaha kuã yir wãã yãhãyĩŋ kuɛ ye ma yee: «Ta Tuhufua Yãhã, taa ra wãnar sya, n syaha wãã ma kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N cã ma ra wãnar sya yalebyɛ. N le pãã nabuar mii wĩĩ na, pe ra gbey le, pe n waha cã mboo ma ra nɔ wãã.» ");
INSERT INTO xrb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu tuu koo pãã wa, u n tẽ sya fãnga ne ma yee: «Laasar, yir yi!» ");
INSERT INTO xrb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Laasar wii u ba ku, u n yir yi, te trɛ ne tesẽ te kluɛ ne te maha tã faasyĩmbɛhɛ taa ne; u yĩntaha ba maha tã fai wo. Yesu n pe nawee- pye ma yee: «-Ye u sãhã yaha, tee tyii u na u n tɛr!» ");
INSERT INTO xrb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pe Yiifee- mpãy pe ba pa Maari ye fla na, poo busãã pe Yesu yãã tuu nde pye, pe n u wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mpãy n -sẽ yir, ma ka Farisyɛ̃ ye fla na, maa le pãã pe ye Yesu lii pye. ");
INSERT INTO xrb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Loo na, pe Yãhã yũndefa yĩŋfa n yir pe Farisyɛ̃ ne, ma pe kaplãŋ cɛrfa wãã, ma le pãã ma yee: «Waa pye mii dya nwo ne? Ye sẽ yãã, u laanwɔ wũhũ busãã pye. ");
INSERT INTO xrb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Waa tyii u na, nawee- byɛ ga ba u wĩĩ sya cĩĩnde, Wɔrmefa ga ba wo Yãhã kangbãŋ yoho pye klaha-, pe wo ter byɛ boo tãŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mpãy pe ba pe ya wãã, poo nen waa pye, u myaha Kayifu, woo kẽ tuu pye pe Yãhã yũndefa yĩŋfua loo dyɛ. U n yir ma pe pye ma yee: «Ye sẽ laa cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ye sẽ laam ga ye. Le puar wo dya nen nwo ya boo, u n ku nawee- kur byɛ wĩĩ na, wo terfa byɛ ma n ku tãŋ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kapãn nde le sya yi u yɛ̃ wo, u sẽ cã ma yee u ya laam kapãn sẽ ne le ba yi u yɛ̃ wo ye. Tuu pye Yãhã yũndefa yĩŋfua loo dyɛ, koo kẽ Yãhã n u ta u n kapãn nde cãã pãã yaha ma yee, Yesu yai u ku pe klofa wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Le sẽ maha pye pe terfa ya wĩĩ na ye. Le pye Yãhã laampii kur byɛ wĩĩ na, pe nii yĩmbui nen na, Yãhã laampii mpãy byɛ pe cããŋ driyɛ̃ teebɛhɛ byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Koo per na, pe n Yesu wãboo wĩĩ ta. ");
INSERT INTO xrb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Loo n ta Yesu sẽ maha naa u ya yar gbaa na pe Yiifee- na ye; u n ka tũntũn kusyĩnde laa wo, tẽyãfũũ klo tãy, pe le yee Yɛflami, maa kuee ke fla na u kãnyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yiifee- syayaha gbar ba gbe taha. Nawee- busãã n yir kui byɛ wo, ma dugu ga Yurusalɛm wo, pe n gaha pe kapĩĩ loho wey, pe nii gbɛgbɛ te gbar n cã dye. ");
INSERT INTO xrb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe pye Yãhã kangbãŋ wo, ma naa Yesu fla kɛ, ma nii pe ya yey, ncã u ga pa te gbar na laa? ");
INSERT INTO xrb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pe Yãhã yũndefa yĩŋfa tesẽ pe Farisyɛ̃ ne, pe ba yee, wii ma Yesu niisaha cã, u le pãã pe n ga u yigi. ");
INSERT INTO xrb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te syayaha gbar ba kuee plii kuay, Yesu n ka klo nde wo pe n yee Gbetane, Laasar fla na, wii Yesu ba u ta u n yir gbã wo, ma nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pe n u nampay yi. Marti naa te dir yĩntaha yi, Laasar pye pe sedifa ne Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maari n lasekole waa gbe bui laa wo, le faa gboho. Pe woo lasekole yee nardi, nawãm sẽ u dir yey ye. U n woo lasekole gbe, ma u woo Yesu trɛ na, ma dur ma u yĩnyor ta ma Yesu trɛ kluã; ke kaha byɛ n ga nii u lasekole dugu fla. ");
INSERT INTO xrb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu kãnyãrwɛ waa pye, Syikaryɔtefa Yuda, woo kẽ u n pai Yesu yi u napĩĩ- kẽ. U n le pãã ma yee, ");
INSERT INTO xrb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","a nwa pe sẽ u lasekole par war nagbey sẽnsye syi, ma pe war wãã fɛnfa kẽ ye? ");
INSERT INTO xrb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Le sẽ nii mii u naa fɛnfa fɛn di koo u n kapãn nde pãã ye, u naa n yuhu, koo kẽ. Pe kãnyãrwai war sakole pye woo ye, pe ma war le, u ga mpãy yuhu yi. ");
INSERT INTO xrb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu n u pye ma yee: «Tyii cɔɔ nwo na, ta kadye kẽ tuu gbihi wa wãleŋ na gbĩĩ wo ke syi. ");
INSERT INTO xrb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Fɛnfa ya dyaŋ, pe ma ye ne yalebyɛ. Ndoo -sẽ nwo, n saa ba pye ye ne per gaa ye.» ");
INSERT INTO xrb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yiifee- busãã n Yesu wãpa wĩĩ luhu ke Gbetane na, ma pa le klo wo. Le sẽ -sẽ ba nii mii pe pa Yesu ya wĩĩ na ye; pe ba pa pe n pai Laasar bya yãã yĩnde ne, woo wii Yesu ba u ta u n yir gbã wo, ma nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pe Yãhã yũndefa yĩŋfa n Laasar bya wãboo wĩĩ pãã ta. ");
INSERT INTO xrb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","U wĩĩ ba Yiifee- busãã ta pe n dur naa n yi poo kur ye, ma naa Yesu woo ta pe Yatɛr, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ke yĩŋsyii wo, nabuar mpãy pe ba ka te gbar wĩĩ na, pe n luhu Yesu ma u n pai ke Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pe n mpẽŋ wan gbe, ma yi ga Yesu wãã, ma nii nuhu di, ma nii le gble ma n yee: «Yĩŋfua mboo wii taa n pai Yãhã myaha ne, Yãhã ke kaa taha ma na, mboo wii taa ma Yiisrɛfa Yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu n kãnkonyainge gaa yãã, ma dugu nii ke na ma n gaha, mii le bii cãã yrũhũ yaha Yãhã sabangbãŋ wo ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Syɔ̃ klofa, ye ma n fya ye, ye yĩŋfua nwo u n pai, kãnkonyainge gaa na, tuu dugu nii.» ");
INSERT INTO xrb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu kãnyãrwai n kai- ngĩĩ yãã wãyãã ya, pe sẽ waha ke yĩntaha war le yale wo ye. Kur kuɛ ye, Yesu tuu ba kuã yir ga yãhãyĩŋ na nayɔ̃r ne, pe n cã le tai cã ma yee, le ma le bii cãã yrũhũ yaha wa Yãhã sabangbãŋ wo ma yee, nawee- ga ba Yesu sey, koo kẽ pe n ba le yãã le pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesu tuu ba Laasar yee le gbĩĩ laam wo, ma u ta u n yir gbã wo, ma nii yrãŋ na, mpãy byɛ pe ba pye ke fla na, pe naa Yesu wĩĩ pãã le ne. ");
INSERT INTO xrb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Loo nde n ta, pe nabuar pe le luhu ma yee Yesu laanwɔ wĩĩ nde pye, pe n pe ya wãã ga ta u yahasee ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pe Farisyɛ̃ n nii pe ya pye ma yee: «Ye sẽ yãã, nawee- byɛ n gaha u ye, nde saa laa yɔ̃ wo kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jrɛkefa mpãy ba pa te gbar na Yurusalɛm wo, Yãhã seysaha wo. ");
INSERT INTO xrb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Poo mpãy n pa Filipe fla na, u n yi klo nde wo pe naa n yee Gbesyata, Galɛlɛ kãntraha na. Pe n Yesu wĩĩ yey waha u ye ma yee: «Yĩŋfua, wo n kɛ wo Yesu yãã.» ");
INSERT INTO xrb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipe n le pãã Andere ye, pe n ka pe syãm, maa le pãã Yesu ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Loo kur ye, Yesu n pe pye ma yee: «U Nawee Puee myaha yiyale nɔ wa. ");
INSERT INTO xrb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta n kakuãcran nde pãã ye ye: Sepua nen le ya ya, le ma yee le sẽ tãhã le kãntraha wo ma fĩy ye, le -sẽ ga kuee le ya ya. Le ma -sẽ tãhã le kãntraha wo, ma ku, ma fĩy, le ga pii buar see. ");
INSERT INTO xrb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wii ma yee u ya yĩŋ wãkɛ wĩĩ ya le n tãy u ye, woofua ga ba u yĩŋ kɛ laa; wii tuu -sẽ ga u ya yĩŋ wãkɛ wĩĩ sye driyɛ̃ nge wo, woofua ga ba cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wii ma yee u ga ra wĩĩ pye, u naa n taha ra na; n ma pye na, u bya ga pye ke fla na. Wii ma ra wĩĩ pye, ta Tuhufua Yãhã ga ta u myaha n yi. ");
INSERT INTO xrb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yagaa, ta laam byɛ ma pe wlãhã nii ra ye. Tẽ ga lii gɛ pãã n sẽ cã ye; n yee la Yãhã ta Tuhufua, le wãfãy yale kuã tɛr ra na, lii le n pai nde? Aye, n saa loo pãã ye. N pa koo wãfãy nge wĩĩ na, n ga ke sya. ");
INSERT INTO xrb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta Tuhufua Yãhã, ma miingbãŋ ta ke n gboho!» Yĩmbui laa n yir yãhãyĩŋ na ma yee: «N ke gboho wa, n ga maha ke ta ke n gboho.» ");
INSERT INTO xrb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nabuar rii te pye ke fla na, ma ba le yĩmbui luhu, te n yee, a yãhãgbãã tẽŋ kẽ. Mpãy naa n yee, a yãhãyĩŋ tẽnlɛhɛ waa kẽ tuu pãã Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu n pe pye ma yee: «Yĩmbui nde sẽ pãã ndoo wĩĩ na ye, le pãã yii wĩĩ na ma yee ye le luhu. ");
INSERT INTO xrb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yagaa, Yãhã kasãhã ga too driyɛ̃fa na. Yãhã ga driyɛ̃ nge yĩŋfua Setane kar wãã. ");
INSERT INTO xrb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ndoo ma ba kuã yir ta, n ga ba ta, nawee- ter byɛ n pa ra ye.» ");
INSERT INTO xrb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu kaplãŋ ngĩĩ naa le yar, gbã mpãy ter syi u n pai ku. ");
INSERT INTO xrb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pe nabuar n u yɛ̃ sya ma yee: «Kãnde lii Yãhã le ta, le ma le yrũhũ yaha ma yee, u Yãhã Yĩndefua Crise saa ku yãã ye. Mboo -sẽ pye mii ma yee, u Nawee Puee ga ba kuã yir ta? Yoo kẽ u Nawee Puee ne?» ");
INSERT INTO xrb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu n pe yɛ̃ sya ma yee: «U Cããfua ga maha yalaale ya dye ye nsoho wo. Tee -sẽ ma u Cããfua ne, ye naa n yãr u ne, wam ma syi pe ba ye fe gbe ye. Wii u n yãr wam wo, u sẽ u ya kakuɛ cã ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tee ma u Cããfua ne, -ye u ta ye Yatɛr, ye nii cããfa.» Yesu tuu koo pãã wa, u n tɛr, maa wũhũ pe na deydey. ");
INSERT INTO xrb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu tuu sya laanwɔ wũhũ busãã pye pe nawee- yĩnde na, pe sẽ -sẽ u ta pe Yatɛr ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Loo gɛ -sẽ ne faale Yãhã kaplãŋ tɔ̃rfua Yisa bii cãã pãã yaha. U bii yee: «Too ke Yãhã wũhũ pãã, yoo ke sya wo ye? Yoo Yãhã koho fãnga yãã, ma le sya cĩĩnde?» ");
INSERT INTO xrb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Poofa mii wĩĩ na, u Yisa maha bii le cãã pãã yaha ma yee: ");
INSERT INTO xrb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Yãhã pe ta fũũ- wãŋ syi; ke maha pe ta pe laam n waha. Mii loo sẽ ne ye, pe ma n yãŋ, pe ga ke kai- yãã yĩnde ne, pe ga ke war pe laam wo. Pe ga ka Yãhã ye, ke n pe jaa yi kãã pe kapee- wãpyeŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yisa tuu bii Yesu nayɔ̃r yãã, koo kẽ u n bii kaplãŋ ngĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pe yahaseefa mpãy -sẽ ba Yesu wĩĩ sya cĩĩnde. Pe sẽ -sẽ le pãã ye. Pe ba fya pe Farisyɛ̃ na, ma yee poo ma le pãã, pe ga pe kar tã ke Yiifee- yawãhã nwoŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ye sẽ yãã, pe naa myaha kɛ nawee- ye, pe sẽ naa myaha kɛ Yãhã ye ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu -sẽ ba le gbey pãã pe ye ma yee: «Wii ma ra wĩĩ sya cĩĩnde ma ra ta u Yatɛr, ndoo ya sẽ kẽ u ta u Yatɛr ye, ufua ra Nɔwããfua bya ta u Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wii ma ra yãã, ufua ra Nɔwããfua bya yãã. ");
INSERT INTO xrb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","N pa driyɛ̃fa ye cãã- wãŋ syi dyaŋ, wii ma ra ta u Yatɛr, ufua ma n kuee wam wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wii ma ra kaplãŋ luhu, ma -sẽ ke sye, ndoo sẽ kẽ tẽ ga ufua sãhã ye. Ye sẽ yãã, n sẽ pa driyɛ̃fa wãsãhã yĩmbui ne ye, n pa pe wãsyayaha yĩmbui ne. ");
INSERT INTO xrb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wii ma ra sye, ma maha ra kaplãŋ sye, u sãhãfua ma; kaplãŋ nkãy tẽ n pãã, koo kẽ ke n pai u sãhã, driyɛ̃ ma ba kua. ");
INSERT INTO xrb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ye sẽ yãã, ta ya wĩĩ sẽ ne tẽ n pãã ye; ta Tuhufua Yãhã gii ke ra nɔ wãã, koo gɛ ra yar kai- nkãy ne, n yai n ke tɔ̃r yar nawee- na. ");
INSERT INTO xrb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N -sẽ cã ke kai- nkãy ta, ke cĩĩnde yrã wãã nawee kẽ. Loo ne, ta Tuhufua Yãhã ke ke kai- yar ra na mii, n ke yar nawee- na koo syi.» ");
INSERT INTO xrb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te syayaha gbar te ba gbe taha, Yesu n cã u yale nɔ wa, yale lii tuu ga yir driyɛ̃ nge wo, u ka u Tuhufua Yãhã fla na. Driyɛ̃fa mpãy byɛ pe ntãŋ dye u tãy, pe n nii u wãm, u n ta pe ntãŋ n dye kuee yai u tãy. ");
INSERT INTO xrb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu pye u kãnyãrwai ne dir na yĩmper wo. Syikaryɔtefa Syimu dya Yuda -sẽ nwo, sãndãpee yĩŋfua Setane ba Yesu wãyi wĩĩ le wa u laam wo, u Yesu yi u napĩĩ- kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu ba cã, woo Yesu yi Yãhã fla na, u ga maha dur ga Yãhã fla na, tesẽ Yãhã kai- byɛ le soho u koho wo. ");
INSERT INTO xrb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesu n yir dir na, ma nayroho fɛr, ma lawey fai laa gbe maha nsĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Loo kur ye, u n loho le tasangbãŋ wo, ma nii u kãnyãrwai trɛ yee pe kẽ, ma te kluã lawey fai lii ne, tuu ba gbe maha nsĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","U n ba nɔ Syimu Pyar na, u n u pye ma yee: «Yĩŋfua, mboo yai la ma ra trɛ yee?» ");
INSERT INTO xrb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu n u yɛ̃ sya ma yee: «Lii tẽ n pye nde, ma sẽ le war ye, maa ba le war kur kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pyar n u pye ma yee: «Aye, n saa sya yãã ma n ta trɛ yee ye.» Yesu n u pye ma yee: «N ma yee n sẽ ma yee ye, ma saa ba ma lay yãã ra ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Syimu Pyar n u pye loo na ma yee: «Yĩŋfua, le ma pye ke syi, ta trɛ yee, maha ra kluɛ bya ne, ta yĩŋ bya ne.» ");
INSERT INTO xrb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu n u pye ma yee: «Wii ma wey laha, u trɛ ya ne te yai te yee, u n nii tãŋ gbɛgbɛ. Ye nii wa gbɛgbɛ, ye byɛ sẽ -sẽ me ye.» ");
INSERT INTO xrb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ba cã wii u n pai u yi u napĩĩ- kẽ, koo kẽ u n yee pe byɛ sẽ me pe ma gbɛgbɛ ye. ");
INSERT INTO xrb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu tuu pe trɛ yee wa, ma u nayroho le wa, u n dur ga tege nii u niisaha wo, ma pe pye ma yee: «Tẽ lii pye ye na, ye le war la? ");
INSERT INTO xrb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ye ra yee kaicãfua, ma maha ra yee yĩŋfua. Le sroŋ, n ma koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndoo wii n ma ye yĩŋfua, ma maha ma ye kaicãfua, yaʼa yãã ndoo tẽ ye trɛ yee, ye bya ye yai ye naa ye trɛ yee yii kẽ! ");
INSERT INTO xrb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ye sẽ yãã, kai ne tẽ pye yar ye na ma yee tẽ ye pye mii, ye bya yai ye naa nii yii ne koo syi! ");
INSERT INTO xrb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta n cĩĩnde nde pãã ye ye, tẽntẽle sẽ tɛr u yĩŋfua yaha ye, tesẽ tẽnlɛhɛ sẽ tɛr u lɛhɛfua yaha ye. ");
INSERT INTO xrb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ye ma kai- ngĩĩ cã, ye wĩĩ n tãy, -tee -sẽ naa koo pye! ");
INSERT INTO xrb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ye byɛ sẽ me tẽ n yãŋ ye. Mpãy tẽ yãŋ yi, n pe cã. Lii le -sẽ cãã yrũhũ yaha Yãhã sabangbãŋ wo, loo ne le n pye yagaa. Le ma le yrũhũ yaha ma yee: ‹Wii u wãã n di ra ne, u wã klaha ma nii ra napĩĩ.› ");
INSERT INTO xrb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","N ga cãã naa ke kai- tɔ̃r ye ye, ke ma ba nii n pye, ye waha cã ndoo ma ngii, ye le sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta n cĩĩnde nde pãã ye ye: N ma nawee lɛhɛ wãã, wii ma ga u wĩĩ sya, ndoo gɛ wĩĩ kẽ tuu sya. Wii ma -sẽ ra wĩĩ sya, Yãhã gii ke ra lɛhɛ wãã, koo gɛ wĩĩ ne tuu sya.» ");
INSERT INTO xrb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu tuu koo kaplãŋ ngĩĩ pãã wa, u laam byɛ n wlãhã, u n yee: «Ta n cĩĩnde nde pãã ye ye: Ye laam wo, waa ma u ga ra yi ta napĩĩ- kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","U kãnyãrwai n nii pe ya yãŋ n klaha, pe sẽ ba cã yoo kẽ u naa n yãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","U Yesu kãnyãrwɛbua -sẽ pye, u ba nii Yesu tãy. ");
INSERT INTO xrb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Syimu Pyar n koho yãhã wãã u ye, u Yesu yey yoo kẽ u n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Woo kãnyãrwɛ nwo n u ya kããŋ Yesu kuɛ ye, ma u pye ma yee: «Yĩŋfua, yoo kẽ?» ");
INSERT INTO xrb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu n u yɛ̃ sya ma yee: «Tẽ ga dir pãhã wãã wii kẽ, woo kẽ.» U n dir raa gbe, ma te pãhã, ma te wãã Syikaryɔtefa Syimu dya Yuda kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda tuu te dir sya wa, sãndãpee yĩŋfua Setane n dye u laam wo. Yesu n u pye ma yee: «Taa yee ma ga lii pye, le pye farfar.» ");
INSERT INTO xrb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mpãy byɛ pe pye te dir na, pe sẽ le war nwa Yesu n le pãã Yuda ye ke dyaŋ ye. ");
INSERT INTO xrb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mpãy naa le ga, a u Yuda tuu ma pe war sakole ne, laa na Yesu yee, wãn tii byɛ wĩĩ te ga ba pye poo na te gbar nde na tẽ n pai, u te byɛ par. Pe maha naa le ga, a laa na Yesu Yuda pye u ngaa wãã nawãm kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda tuu te dir sya wa, u n ta tɛr yi ma tɛr. Yĩmper ba wɔ wa. ");
INSERT INTO xrb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda tuu yi tɛr wa, Yesu n u kãnyãrwai pye ma yee: «Yagaa, u Nawee Puee miingbãŋ ga yi, Yãhã miingbãŋ bya ga yi u kãmay na. ");
INSERT INTO xrb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yãhã miingbãŋ ma yi u kãmay na, Yãhã bya ga ba u miingbãŋ yi ke ya kãmay na; ke ga ba le pye yagaa. ");
INSERT INTO xrb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta cĩĩfa, yalaale ga maha ra yãã ye ne. Loo kur ye, ye ga ba naa ra kɛ. Tẽ ba pe Yiifee- yahaseefa yar lii ne, n ga maha ye yar loo wĩĩ nen ya ne. Tẽ n gaha na, ye saha ka ke fla na ye; n ga ye bya yar le ne yagaa. ");
INSERT INTO xrb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","N ga kãnfuɛ̃ laa yar ye na: Ye tyii ye ntãŋ n naa n dye yii tãy; ye ntãŋ pe dye ra tãy mii, ye bya ye tyii ye ntãŋ n naa n dye yii tãy koo syi! ");
INSERT INTO xrb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ye ntãŋ ma dye yii tãy, nawee- byɛ ga cã pe yee ta kãnyãrwai me ye ne.» ");
INSERT INTO xrb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Loo kur ye, Syimu Pyar n Yesu yey ma yee: «Yĩŋfua, ma n gaha na?» Yesu n u yɛ̃ sya ma yee: «Tẽ n gaha na, maa ba taha ra na kur kuɛ ye, yagaa sẽ -sẽ kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pyar n u pye ma yee: «Yĩŋfua nwa ma n yee, n saha taha ma na yagaa ye? N ma sya ga gbã yãã ma wĩĩ na, n yɛr le na.» ");
INSERT INTO xrb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu n u yɛ̃ sya ma yee: «Ma sẽ yee la maa ku ra wĩĩ na? Ta n -sẽ cĩĩnde nde pãã ma ye: Ngupuai saa kui wa ye, ma ga ba ta wĩĩ kai wa tɛhɛ tãã, ma yee ma sẽ ndoo cã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu n maha u kãnyãrwai pye ma yee: «Ye ma syi ye laam n wlãhã ye ye ye! -Ye koho taha yaha Yãhã na, -tee -sẽ koho taha yaha ra bya na! ");
INSERT INTO xrb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Tuhufua Yãhã fla na, niisar nihi. Le ma ne pye cĩĩnde sẽ ne ye, n ne ga pye n le pãã ye ye. Ye sẽ yãã, n n gaha niisar gbihi ye kẽ ke fla na. ");
INSERT INTO xrb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","N ma ba ka, maa ye niisar gbihi wa, n ga dur ba ye ye, n ba ye gbe ga ta nii tãy koo fla na. Loo na, ndoo tẽ ma na, ye bya ga ba pye koo fla na. ");
INSERT INTO xrb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kãnde lii le n gaha ta kasaha wo, ye loo kãnde cã.» ");
INSERT INTO xrb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tema n u pye ma yee: «Yĩŋfua, too sẽ -sẽ ma kasaha cã ye, wo ga pye mii wo koo fla kãnde cã?» ");
INSERT INTO xrb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu n u yɛ̃ sya ma yee: «Ndoo tẽ ma le kãnde; ndoo tẽ ma le cĩĩnde; ndoo tẽ ma le yrã. Waa saha ka Yãhã fla na mii ndoo kãmay sẽ ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ye ma ndoo cã, ye ga ra Tuhufua Yãhã bya cã. Ke yagaa nge gɛ na, ye ke cã wa gɛ cã wa, ye maha ke yãã wa yĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipe n yee: «Yĩŋfua, ma Tuhufua Yãhã yar wo na, loo ya ga tãy wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu n u yɛ̃ sya ma yee: «N ma ye ne le yale syi ma na? Loo naa byɛ ne, ma sẽ maha ra cã ye Filipe! Wii ma ra yãã, ufua ta Tuhufua Yãhã yãã. Ma -sẽ pye mii ma yee, n ta Tuhufua Yãhã yar ye na? ");
INSERT INTO xrb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ma sẽ cã la ma yee, ndoo tesẽ ra Tuhufua Yãhã ne, wo ma nen? Ta Tuhufua Yãhã, tesẽ ndoo ne, wo ma nen. Kaplãŋ nkãy tẽ n pãã ye ye, ndoo yɛ̃ kaplãŋ sẽ kẽ ye; ta Tuhufua Yãhã gii, koo ndoo ne, wo ma nen, koo kẽ ke koo kai- ngĩĩ byɛ pye. ");
INSERT INTO xrb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","N yee, ndoo tesẽ ra Tuhufua Yãhã ne, wo ma nen, -ye le sya cĩĩnde! Ye ma yee ye sẽ ra kaplãŋ sya cĩĩnde ye, kai- nkãy ke n pye, -ye koo sya cĩĩnde! ");
INSERT INTO xrb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta n cĩĩnde nde pãã ye ye: Wii ma ra ta u Yatɛr, kai- nkãy tẽ n pye, ufua bya ga waha koo pye. Tẽ nwo n n gaha ta Tuhufua Yãhã fla na, loo ga ta ufua n waha kai- nkãy pye, ke tɛr gɛ tɛr ra wũhũ yaha. ");
INSERT INTO xrb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kai- nkãy byɛ tee ga ba nar ra myaha ne, n ga ba ke pye ye kẽ, ta Tuhufua Yãhã miingbãŋ n yi ta kãmay na, ndoo wii n ma ke Dya. ");
INSERT INTO xrb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ye ma ngii nar ra myaha ne, n ga ke pye ye kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu n maha yee: «Ta ntãŋ ma dye ye tãy, ye ga ra kaplãŋ le yaha ye laam wo, -ye naa koo pye! ");
INSERT INTO xrb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","N ga ra Tuhufua Yãhã nar ke Koholefua waa nɔ wãã ye kẽ. Woo kẽ Yãhã Yrã Fãnga ne. Le ga ba pye ye ne yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Loo cĩĩnde Yrã saha pye yãã driyɛ̃fa ye ye. Pe saha le yãã yĩnde ne ye, pe saha le cã ye, koo kẽ. Yii poo na, ye le cã; ye sẽ yãã, le ma ye ne, le ga dye ye laam wo, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N saa tɛr n ye yaha yii ya mii ncir- wãŋ syi dyaŋ ye; n ga dur ba ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yalaale wo, driyɛ̃fa saa ra yãã nantãŋ ye. Yii -sẽ ga ba naa ra yãã. Ye sẽ yãã, n ma yrãŋ na, koo kẽ ye bya ga ba nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Koo per ma nɔ, ye ga le war ye yee, ndoo tesẽ ra Tuhufua Yãhã ne, wo ma nen; tesẽ yii ndoo ne, wo ma nen; ndoo yii ne, wo ma nen. ");
INSERT INTO xrb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wii ma ra kaplãŋ le yaha u laam wo, ma nii u troho tãhã koo kãnde na, woo kẽ ta ntãŋ dye u tãy. Woofua ntãŋ -sẽ ga dye ra Tuhufua Yãhã tãy, ndoo bya, u ntãŋ ga dye ra tãy, n ga ta u n ta yãã.» ");
INSERT INTO xrb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda wii, Syikaryɔtefa Yuda sẽ kẽ woo ne ye, u n Yesu pye ma yee: «Yĩŋfua, maa pye mii ma ta wii n ma yãã, pe driyɛ̃fa poo saa ma yãã ye?» ");
INSERT INTO xrb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu n u yɛ̃ sya ma yee: «Ta ntãŋ ma dye wii tãy, ufua ga ra kaplãŋ le yaha u laam wo; u ntãŋ -sẽ ga dye ra Tuhufua Yãhã tãy. Ta Tuhufua Yãhã tesẽ ndoo ne, waa pa ufua ye, wo ba wo niisaha ta u ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wii ma -sẽ yee ta ntãŋ sẽ dye u tãy ye, ufua saa ra kaplãŋ sya ye. Kaplãŋ nkãy byɛ tẽ n pãã ye ye, ndoo yɛ̃ wũhũ sẽ kẽ ye, ta Tuhufua Yãhã gii ke ra nɔ wãã, koo yɛ̃ kaplãŋ kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tẽ nwo n ma ye ne nantãŋ, n koo kaplãŋ ngĩĩ byɛ pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yãhã Yrã Fãnga gii ke n pai nii ye Koholefua, Yãhã ga ba ke nɔ wãã ye ye ta draha wo. Loo Yãhã Yrã Fãnga nde ga ba naa ye klaha kai- byɛ ne, le ga ba naa ye laam too kaplãŋ nkãy byɛ ne tẽ pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Tẽ nwo n n tɛr, n ga yrĩŋ yaha ye na. Yrĩŋ mpãy pe ma ndoo wãm, n ga maha poo wãã ye kẽ. Ndoo yrĩŋ wee mii driyɛ̃fa yrĩŋ dyaŋ ye. Ye ma syi ye laam n wlãhã ye ye ye, ye ma n fya ye! ");
INSERT INTO xrb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tẽ ye yar ma yee n ga tɛr, tẽ ba dur ba ye ye, ye le luhu wa. Ta ntãŋ ma dye ye tãy cĩĩnde, ye ga ne naa nuhu di ta wãka wĩĩ na ta Tuhufua Yãhã fla na. Ye sẽ yãã, ta Tuhufua Yãhã tɛr ndoo yaha. ");
INSERT INTO xrb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yagaa, n ye cãã yar wa koo kai- ngĩĩ ne. Loo na, ke ma ba nii n pye yaliile wo, ye ga le sya cĩĩnde ne tẽ naa n pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Draha sẽ gboho ra ye nantãŋ ta n ga kaplãmbuar pãã ye ne ye. Ye sẽ yãã, driyɛ̃ yĩŋfua Setane ma u n pai ra fla na. U saha yia ra na laa ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","N -sẽ yai n ta, driyɛ̃fa n cã pe yee ta Tuhufua Yãhã ntãŋ dye ra tãy, ke kai- nkãy byɛ yar ra na, koo kẽ tẽ n pye. -Ye yir yi nwo, wo n tɛr!» ");
INSERT INTO xrb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu n maha u kãnyãrwai yar ma yee: «Ndoo tẽ ma cĩĩnde defĩĩ katyigi tepeŋ, ta Tuhufua Yãhã koo ke ma ke gbihifua. ");
INSERT INTO xrb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kayay rii te ma ra na, te ma yee te sẽ n sa ye, ke re cɛr n kãã. Tii ma -sẽ n sa, ke too sã ma te gbihi, ma n ta kaa n taha te wãsa na. ");
INSERT INTO xrb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yii mpãy tee mii kayay tii dyaŋ te gbihi wa, ta kapãn ne le ye ta koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Loho ke sẽ waha n yi ra nsoho wo ye wĩĩ ne ye mii, -ye bya ye nii ra wĩĩ ne ke syi. Ye katyigi kayaŋ gaa yãã yãã la, pe cɛr miy yaha, ke n sa yãã? Yii ma yee ye sẽ ra yigi, wo n nii loho sẽ n yi wo nsoho wo ye, yaa nii koo kayaŋ nge wãŋ syi, ye saa sa yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ndoo tẽ ma ke tepeŋ, yii -sẽ ma te kayay. Wii ma nii loho sẽ n yi u nsoho wo ra wĩĩ ne ye, ta bya n -sẽ nii loho sẽ n yi ra nsoho wo u bya wĩĩ ne ye, woofua nwo na u ga kayũhũ sa gboho. Wii ma -sẽ u ya cɛr kãã ra na, woo saa waha naa n yigi laa gɛ ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wii ma sye, u sẽ ta wo n nii loho sẽ waha n yi wo nsoho wo ye, woofua nwo ga nii mii ke kayaŋ wãŋ syi dyaŋ, kayaŋ gii pe ma ne cɛr, pe gbe ga miy yaha, ke n waha. Ke ma waha wa, pe ke pãã ga le naa wo, ke n suhu. ");
INSERT INTO xrb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yaʼa ra wĩĩ yigi, loho sẽ waha n yi ye nsoho wo ra ne ye, yaʼa sya lii syi nar Yãhã ye, ke ga le pye ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yaʼa sya ma kayũhũ sa gboho, loo nde ga ra Tuhufua Yãhã miingbãŋ yi. Nawee- ga maha cã pe yee, ye ma ra kãnyãrwai. ");
INSERT INTO xrb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ta ntãŋ pe dye ra Tuhufua Yãhã tãy mii, ye byɛ ntãŋ dye ra tãy koo syi dyaŋ. Ye tyii ye ntãŋ n dye kuee yai tãŋ ra tãy! ");
INSERT INTO xrb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tẽ ra Tuhufua Yãhã kaplãŋ sya, loo le ta ra ntãŋ n dye kuee u tãy. Ye bya, yaʼa ra kaplãŋ sya, ma nii ke pyefa, ye ntãŋ ga dye kuee ra tãy koo syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","N loo nde pãã ye ye, ye n waha ta nuhu ter syi yãã, ye laam byɛ n nii nuhu fla ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lii tẽ n kɛ ye ye loo ne nde: Ye ntãŋ pe dye ra tãy mii syi, ye tyii ye ntãŋ n dye yii tãy koo syi! ");
INSERT INTO xrb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Maʼa ma naambiyãm gbã sya ma ku pe draha wo, ntãŋ mpãy wãdye saa waha tɛr loo nde yaha ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lii tẽ n pãã ye ye, ye ma ke sya ma nii ke pyefa, ye ga kuee yai tãŋ ra naambiyãm. ");
INSERT INTO xrb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N sẽ ye yãŋ ra tẽntẽbir ye, n ma ne pye tẽ ye yãŋ ta tẽntẽbir, n ga ne ta laam wũhũ tɔ̃r naa n yar la ye na? N ye yãŋ ra naambiyãm, mii loo sẽ ne ye, n saa ne ta ye ne ta wĩĩ laa gɛ cã ta Tuhufua Yãhã wĩĩ ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yii la tee ra yãŋ yi? Ndoo sẽ na tẽ ye yãŋ yi, ma yee kayay tii syi te sa n gboho, -ye nii koo syi dyaŋ, ye naa kayũhũ pye, kayũhũ nkãy ke n ma-? Ye ma ngii ngii nar ra Tuhufua Yãhã ye ra myaha ne, ke ga ke pye ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","N yee, ye tyii ye ntãŋ na pe n dye ga pe ya tãy, loo ne tẽ sroŋ n kɛ ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu n maha yee: «Driyɛ̃fa ma napĩr le ye ne, ye le cã pe cãã napĩr le wa ra ne, ma cã ba nɔ ye na. ");
INSERT INTO xrb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ke ma ne pye ye ma driyɛ̃fa ne yĩmbui nen na, pe ga ne naa n tãy ye ne. Pe ga ne ye tɔ̃r naa n yigi pe ya ne. Tẽ -sẽ nwo, tẽ ye tyɔ̃r yi kãã driyɛ̃fa kuɛ koho ye, ye n nii ye sẽ n tɔ̃r pe ne ye, loo ne le pe ta ye wĩĩ n fũhũ pe ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","-Ye ye laam too nde na tẽ ba ye pye ma yee: Tẽntẽle sẽ tɛr u yĩŋfua yaha ye. Pe ma ra ka n nuhu, pe ga ba naa ye bya pye ke syi. Pe ma ra kaplãŋ sya, pe ga ba naa ye bya wũhũ sya. ");
INSERT INTO xrb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ta myaha ga ta, pe n koo kai- ngĩĩ byɛ pye ye na. Pe tee mii pe sẽ Yãhã cã ye, koo gii ke ra lɛhɛ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ke ma ne pye n sẽ pa ma ba Yãhã laam wũhũ tɔ̃r pe ye ye, kapee- saa ne pye pe yĩŋ na ye. Yagaa tẽ -sẽ nwo tẽ Yãhã laam wũhũ tɔ̃r pe ye, pe saha yee poo sẽ laa cã wa, ma naa kapee- pye ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ta wĩĩ ma fũhũ wii ye, ta Tuhufua Yãhã wĩĩ bya fũhũ ufua ye. ");
INSERT INTO xrb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ke ma ne pye, n sẽ laanwɔ wũhũ pye pe n yãã yĩnde ne ye, nkãy syi nawee waa sẽ ke pye yãã ye, kapee saa ne pye pe yĩŋ na ye. Yagaa n -sẽ nwo tẽ laanwɔ wũhũ pye pe n yãã, wo wĩĩ n maha fũhũ pe ye, ndoo, tesẽ ra Tuhufua Yãhã ne. ");
INSERT INTO xrb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kai- ngĩĩ byɛ n pye, kapãn lii le bii cãã yrũhũ ta Yãhã sabangbãŋ wo, loo ne le n pye. Loo kapãn nde: ‹Ta wĩĩ fĩhĩ ka fũhũ pe ye ke dyaŋ, laa sẽ ne laa ne ye.› ");
INSERT INTO xrb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Koholefua wii u ma paŋ na, woo kẽ Yãhã Yrã lii ne pe n yee Yãhã Cĩĩnde Yrã. N ga ba le nɔ wãã ye kẽ Yãhã kãmay na, le n ba ra wĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ye bya, tee -sẽ mii ra ne ta tẽn fegbesaha wo, ye ga ba naa ra wĩĩ pãã yii ndoŋ.» ");
INSERT INTO xrb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu n maha u kãnyãrwai pye ma yee: «N koo ngĩĩ byɛ tɔ̃r ma ye yar, ke ma ba nii ye dye, ye ma n ba dur yi ra kur ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pe ga ba ye tã Yiifee- yawãhã nwey na. Yalaa ga ba nɔ, ye boofa gɛ ga ba naa le ga, a poo Yãhã laam wũhũ pye ke syi. ");
INSERT INTO xrb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pe tee mii pe sẽ Yãhã cã war ye, pe sẽ maha ra bya cã war ye, pe ga ba tee naa n pye ke syi. ");
INSERT INTO xrb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","N koo ngĩĩ byɛ tɔ̃r ma ye yar, yalaale wo pe ma ba yir ke wãpyeŋ na, ye waha le cã ye yee, n ba le cãã tɔ̃r wa ye ye. N sẽ ba cãã koo ngĩĩ tɔ̃r ye ye ye, n pye ye ne yalebyɛ, koo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yesu n maha yee: «Yagaa, n nwo tẽ ga tɛr ra Tuhufua Yãhã fla na, koo gii ke ra nɔ wãã. Yii waa gɛ sẽ -sẽ ra yey ma yee ma n gaha na ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","N le cã nkãy tẽ n pãã ye ye, koo kẽ ke ye laam wlãhã. ");
INSERT INTO xrb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cĩĩnde -sẽ ne tẽ n yar ye na; n ma tɛr, ke ga puar ye na. N ma yee n sẽ tɛr ye, u Koholefua wii u yai u pa ye ye, u saa pa ye. N ma -sẽ tɛr, n n gaha u nɔ wãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Woo nwo ma ba pa, u ga ba driyɛ̃fa yar pe n cã pe plaha pe kapee- wãpyeŋ kuɛ ye, pe plaha nkãy kuɛ ye ke sroŋ, pe maha plaha Yãhã kasãhã kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pe kapee- wãpyeŋ kuɛ ye, pe plaha. Pe sẽ ra ta pe Yatɛr ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kai- nkãy ke sroŋ, pe plaha koo kuɛ ye. N n gaha ra Tuhufua Yãhã tãy, waa saa ra yãã nantãŋ ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yãhã kasãhã kuɛ ye, pe maha plaha. U driyɛ̃ yĩŋfua Setane sãhã wa, u fãnga pye klaha- wa, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Kai- busãã ma ra yɛ̃ na wãtɔ̃r wũhũ ye ye, ye sẽ -sẽ ga waha ke yĩntaha war yagaa ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yãhã Yrã lii le ma cĩĩnde ne, le ma ba pa, loo le ga waha ba naa ye sroŋ ke cĩĩnde byɛ wo. Le ya laam wũhũ sẽ kẽ le n pai ta le naa n tɔ̃r ye ye ye. Kai- nkãy byɛ le luhu Yãhã ye, koo kẽ le n pai tɔ̃r naa ye yar, tesẽ nkãy ne ke ga ba dye kur ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Le ga ba naa ra kai- sya ra ye, le ba tɔ̃r naa ye yar. Le ga ba ta ra myaha n yi koo syi ne. ");
INSERT INTO xrb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lii ma pye ra Tuhufua Yãhã wĩĩ, le ma ra bya wĩĩ. Loo ne ra n yee, Yãhã Yrã Fãnga ga ba ra kai- sya ra ye, le ba tɔ̃r naa ye yar.» ");
INSERT INTO xrb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu n maha yee: «Saa ma pye, ye saa ba ra yãã ye. Loo kur ye, saa ma maha pye, yaa ra yãã.» ");
INSERT INTO xrb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","U kãnyãrwai mpãy n pe ya yey le ne ma yee: «Ye nde yĩntaha cã la u ne tuu n tɔ̃r, ma nii wo pye ma yee: ‹Saa ma pye, ye saa ba ra yãã ye. Loo kur ye, saa ma maha pye, yaa ra yãã.› Ma suhu nde ne tuu maha yee: ‹N n gaha ra Tuhufua Yãhã tãy.› ");
INSERT INTO xrb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tuu yee saa, saa gii gɛ kẽ koo ne u n yãŋ? Nkãy ter tuu n tɔ̃r wo ye ngĩĩ, waa sẽ ke yĩntaha cã u ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu tuu cã pe u kaplãŋ yĩntaha kɛ u ye, u n pe pye ma yee: «Nde tẽ tɔ̃r yar ye na ma yee, saa ma pye, ye saa ba ra yãã ye. Loo kur ye, saa ma maha pye, yaa ra yãã. Loo nde syi wĩĩ la tee nii yii yey le yĩntaha ne? ");
INSERT INTO xrb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ta n cĩĩnde nde pãã ye ye: Ye mii yaa ba naa kayaaŋ miyãhã wũn ta wĩĩ na. Loo ga ba nuhu yigi driyɛ̃fa kẽ. Cĩĩnde, ye laam ga ba wlãhã. Kur ye, ye laanwlaŋ ga ba wã klaha nii nuhu. ");
INSERT INTO xrb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ta n laa tɔ̃r yar ye na: Lai ma cɔɔ yigi u n ga see, u ma u ya fɛn yãŋ, u laam ga wlãhã. U ma -sẽ waha see wa, ma ke pẽyãhã yãŋ, u ga faha te fɛn byɛ yaha, tii tuu sya. U ma yãŋ u ga yãã u nawee see le driyɛ̃ wo, loo nde n nuhu yigi u kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ye byɛ sẽ na ke syi yagaa, ye laam pe wlãhã ye ye? Waa maha ba wii yãã yahamba, ye laam n nii nuhu fla, waa gɛ saa waha poo nuhu yi kãã ye laam wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Koo cãã nge ma ba nɔ, ye saa maha ba ra yey laa ne ye. Ta n cĩĩnde yar ye na, yaʼa ba nii nkãy nar Yãhã ye ra myaha ne, ke ga ba naa ke pye ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ma sya ba waa yagaa na, ye sẽ ngaa nar yãã Yãhã ye ra myaha ne ye. -Ye naa ke nar, ke ga ye kẽ, ye laam n nii tãŋ ye ye nuhu fla.» ");
INSERT INTO xrb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesu n maha yee: «N koo ngĩĩ byɛ tɔ̃r ye ye kakuãcraŋ ne. Yalaale -sẽ nde le n pai, le ma ba nɔ, n saa ba ra Tuhufua Yãhã wĩĩ laa tɔ̃r ye ye kakuãcraŋ ne nantãŋ ye. N ga ba ke byɛ tɔ̃r naa n yi ye ye gbaa na. ");
INSERT INTO xrb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Koo cãã nge ma ba nɔ, ndoo ya sẽ kẽ tẽ ga ba naa ra Tuhufua Yãhã nar ye kẽ ye. Ye byɛ ga ba waha naa Yãhã nar yii ya ra myaha ne. ");
INSERT INTO xrb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ye sẽ yãã, ye ntãŋ dye ta Tuhufua Yãhã tãy. Ta ntãŋ dye ye tãy, ye maha le sya n yi ke tãy, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N yi ra Tuhufua Yãhã tãy, ma pa driyɛ̃ wo. N nwo, yagaa tẽ ga yir driyɛ̃ wo, n dur ga ra Tuhufua Yãhã tãy.» ");
INSERT INTO xrb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","U kãnyãrwai n u pye ma yee: «Yagaa woo sẽ na taa tyii kakuãcraŋ wãpãã na, ma gbihi pãã n yi gbɛgbɛ? ");
INSERT INTO xrb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yagaa woo, wo fĩhĩ le sroŋ cã laha taa kai- byɛ cã tãŋ, nawee laam wĩĩ laa sẽ wũhũ ma na ye. Koo syi kẽ, wo n ma ta wo Yatɛr, ma cã ma yi Yãhã tãy.» ");
INSERT INTO xrb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu n pe pye ma yee: «Yagaa woo la tee ra ta ye Yatɛr? ");
INSERT INTO xrb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","N -sẽ cã, yale laa nde le n pai, le nɔ wa gɛ nɔ wa, ye byɛ ga ba fã cããŋ tɛr ra yaha, yii wuhu na, ra n kuee nii ya. N -sẽ cã, n saa ba kuee nii ya ye, ta Tuhufua Yãhã ga ba pye ra ne. ");
INSERT INTO xrb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","N koo ngĩĩ byɛ pãã ye ye, ye waha yrĩŋ yãã. Yaa fɛn yãã driyɛ̃ koho wo, -tee -sẽ tetege le yii na, n yia wa driyɛ̃ na.» ");
INSERT INTO xrb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu tuu pãã wa ke syi, u n yĩntaha kuã yir wãã ncaha ye, ma u Tuhufua Yãhã pye ma yee: «Ta Tuhufua, le yale nɔ wa, ta ma Dya miingbãŋ n yi, u bya n -sẽ ta ma miingbãŋ n yi. ");
INSERT INTO xrb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ma nwo, taa fãnga byɛ wãã u kẽ, ma yee nawee- mpãy taa wãã u kẽ, u waha pe ta pe n cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Cĩĩnde yrã, le wĩĩ le ma lii ne loo ne nde: Nawee- n waha ma cã, mboo wii ya taa ma cĩĩnde Yãhã, pe maha Yesu Crise cã, woo wii taa nɔ wãã pe ye. ");
INSERT INTO xrb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","N ma myaha gboho kãntraha na. Taa ra taha lii na, n le byɛ yĩntaha yi. ");
INSERT INTO xrb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta Tuhufua, cãã gii cãã driyɛ̃ sẽ bii tãhã wa ye, n pye ma tãy ma nayɔ̃r wo. Yagaa, ta, ra miingbãŋ n yi, -taa ra gbe ga ta mii tãy too nayɔ̃r wo! ");
INSERT INTO xrb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nawee- mpãy raa tyĩn sya driyɛ̃ koho wo, pe ma ma wãm, ma pe wãã ra kẽ, pe n nii ra wãm. N ta pe n ma miingbãŋ cã. Pe ma kapãn le yaha pe laam wo. ");
INSERT INTO xrb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yagaa, pe cã ngii taa wãã ra kẽ, ke yi ma fla na. ");
INSERT INTO xrb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma sẽ yãã, kaplãŋ nkãy taa pãã ra ye, n ba ke byɛ tɔ̃r pe ye, pe n ke sya. Pe mii pe le yãŋ cã ma yee, tẽ sroŋ yi ma fla na, ma maha yee, a mboo taa ra nɔ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","N ma nar poo nawee- mii wĩĩ na. N sẽ ma nar driyɛ̃fa wĩĩ na ye. Mpãy taa wãã ra kẽ, n ma nar poo wĩĩ na. Pe ma ma wãm. ");
INSERT INTO xrb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ta kla, ma kla; ma kla, ra bya kla kẽ. Ta miingbãŋ n yi poo kãmay na. ");
INSERT INTO xrb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","N nwo, yagaa tẽ ga ka ma fla na. N wee tẽ n tɔ̃r kãntrahafa ne nantãŋ ye, poo -sẽ mii pe n tɔ̃r kãntrahafa ne. Ta Tuhufua Yãhã, mboo wii ma kai- laha, koho paha tã pe na ma myaha wĩĩ na, myaha gii raa wãã ra kẽ, pe n waha wãã le, pe nii yĩmbui nen ne ma dyaŋ ra ne. ");
INSERT INTO xrb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tẽ pye pe ne, mpãy taa wãã ra kẽ, n paha pe na ma myaha fãnga kãmay na. Waa gɛ sẽ plaha ye, ma yi kãã wii na tuu ba yai wãplaha ne, loo ne Yãhã sabangbãŋ ke le cãã tɔ̃r yaha. ");
INSERT INTO xrb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yagaa tẽ ga ka ma fla na, koo syi kẽ ta nii n pãã ke syi, tẽ nwo nantãŋ kãntraha na pe ne. Loo n waha ta pe laam n nii tãŋ ta nuhu ne. ");
INSERT INTO xrb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N ma kapãn tɔ̃r yar pe na, pe wĩĩ n fũhũ driyɛ̃fa ye. Pe wee driyɛ̃fa kãnde wo ye, mii ta dyaŋ tẽ wee driyɛ̃fa kãnde wo ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","N sẽ ma nar taa pe gbe yi kãã driyɛ̃ wo ye, n ma nar, ma naa pe paha sãndãpee yĩŋfua Setane na. ");
INSERT INTO xrb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Pe wee driyɛ̃fa kãnde wo ye, mii ta dyaŋ tẽ wee driyɛ̃fa kãnde wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pe ta pe n sroŋ nii ma wãm, ma cĩĩnde kãmay na. Ma kapãn loo ne le ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","N pe lɛhɛ wãã driyɛ̃ wo, mii taa ra lɛhɛ wãã driyɛ̃ wo mii syi. ");
INSERT INTO xrb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","N nii wãã n tãŋ ma kẽ poo wĩĩ na, ke syi pe byɛ n waha sroŋ nii ma wãm pe ya ndoŋ, ma cĩĩnde kãmay na. ");
INSERT INTO xrb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","N sẽ -sẽ ma nar poo ya wĩĩ ne ye. Mpãy byɛ pe ga ba poo kaplãŋ sya, pe ra ta pe Yatɛr, n ma nar pe bya wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","N ma nar pe byɛ n waha wãã le, pe nii yĩmbui nen na. Too nii nen wii wo syãm ma ne, n ma nar pe waha nii koo syi dyaŋ, poo tesẽ wo syãm ne. Driyɛ̃fa n loo yãã, pe cã pe yee, mboo taa ra lɛhɛ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nayɔ̃r rii taa wãã ra kẽ, n te syi wãã pe kẽ, pe n waha nii nen mii wo dyaŋ too ma nen. ");
INSERT INTO xrb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wo ma nen, mboo ra ne; tesẽ wo ma nen, ndoo poo ne. Loo ga ta pe n wãã le, pe nii yĩmbui nen na. Ke syi, driyɛ̃fa ga cã pe yee, mboo ma ra lɛhɛ wãã, tesẽ ra ntãŋ pe dye ma tãy mii, ta nawee- bya ntãŋ dye ma tãy koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ta Tuhufua, mpãy taa wãã ra kẽ, n n traha pe ba pye ra ne fla ngii na n n pai pye. Koo syi, pe ga waha ra nayɔ̃r yãã yĩnde ne, tii taa wãã ra kẽ. Driyɛ̃ sẽ bii tãhã wa ye, ta ntãŋ bii dye ma tãy, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ta Tuhufua, mboo wii taa sroŋ, driyɛ̃fa sẽ ma cã ye, ndoo -sẽ ma cã, ta nawee- bya cã mboo taa ra lɛhɛ wãã. ");
INSERT INTO xrb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N ta poo n ma myaha cã, n ga ta kaa naa n taha ke wãcãŋ na pe ye. Koo syi, ta ntãŋ pe dye ma tãy mii, pe bya n waha nii ke syi, ta wĩĩ n maha nii pe laam wo.» ");
INSERT INTO xrb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu tuu ba Yãhã nar wa, u n ka u kãnyãrwai ne Sedrɔ̃ lankloŋ kũndi ye. Katyir lankua waa pye ke fla na. Pe n dye u katyir lankua laam wo. ");
INSERT INTO xrb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pe naa n gaha koo fla na sɔɔ. Yuda wii tuu yi Yesu kur ye, u bya ba ke fla saha cã. U n ke fla saha yar Yesu napĩĩ- na. ");
INSERT INTO xrb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","U n ka Wɔrmefa seraasyi ndreŋ ne, ma suhu ke Yãhã kangbãŋ sẽŋfa ne u katyir lankua wo. Pe Yãhã yũndefa yĩŋfa, tesẽ pe Farisyɛ̃ ne, poo me pe ba pe lɛhɛ wãã. Terbuhu pye pe ye, tesẽ naaloho ndyan ne, ma suhu naanmiy wãn ne. ");
INSERT INTO xrb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu tuu -sẽ ba cã wa lii le ga ba u dye, u n pe wãã ga, maa pe yey: «Yoo tee n kɛ?» ");
INSERT INTO xrb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pe n u pye ma yee: «Nasarɛtefa Yesu too n kɛ.» Yesu n yee: «Ndoo tẽ ma woo.» Loo yale wo Yuda pye u ba yɛr pe ne, Yuda wii tuu pye Yesu yifua u napĩĩ- kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yaliile Yesu le pãã ma yee, ndoo tẽ ma woo, pe n kũn dur kur kuɛ ne, ma laha n too. ");
INSERT INTO xrb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","U n pe yey yahamba: «Ah yoo tee n kɛ?» Pe n maha u pye: «Nasarɛtefa Yesu.» ");
INSERT INTO xrb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","U n yee: «N sẽ le pãã wa la ye ye, ma yee ndoo tẽ ma woo? Ke ma pye ndoo tee n kɛ, ye tyii ta kãnyãrwai na, pe n tɛr.» ");
INSERT INTO xrb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tuu loo pãã ke syi, lii u naa n pãã Yãhã ye ke yĩmper wo, loo ne le pye. Loo ne nde: «Yãhã, nawee- mpãy taa ba wãã ra kẽ, nawee nen gɛ sẽ plaha ra ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Syimu Pyar -sẽ pye yũntrũhũ ne. U n le tyĩn yi yũnsyihi wo, ma Yãhã yũndefa yĩŋfua tẽntẽ Malsyii kãndigi ndityɛ gbã cɛr. ");
INSERT INTO xrb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Loo na, Yesu n u Syimu Pyar pye ma yee: «Ma yũntrũhũ le yũnsyihi wo. Ma sẽ cã la n yai n ke kayĩhĩ sya, kii ra Tuhufua Yãhã tuu wãã ra kẽ?» ");
INSERT INTO xrb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesu tuu kãhã loo nde pãã wa, nawee- mpãy pe pye Yuda ne, pe n Yesu yigi, ma u pua, ");
INSERT INTO xrb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ma cãã ka u ne Yana fla na, Yãhã yũndefa yĩŋfa mpãy waa. Loo dyɛ Kayifu woo tuu ba Yãhã yũndefa yĩnfar yãã. U ba Yana pueesya sya cɔɔ. ");
INSERT INTO xrb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Woo kẽ tuu maha ba Yiifee- yahaseefa pye ma yee, a ter nawee nen ma ku nabuar wĩĩ na, koo ke puar. ");
INSERT INTO xrb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Syimu Pyar tesẽ Yesu kãnyãrwɛ waa ne, pe n taha Yesu na, ma ka Yana fla na. Yãhã yũndefa yĩŋfua ba u kãnyãrwɛ nen nwo cã lɛ wa, woo n waha dye u Yãhã yũndefa yĩŋfua kangbãŋ ndyin wo. ");
INSERT INTO xrb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Syimu Pyar ya n kuee kãndi wo kapahayɛ̃ na. U kãnyãrwɛ wii tuu u Yãhã yũndefa yĩŋfua cã, u n ka maa pãã u kapahayɛ̃ sẽŋsyale ne, ma Syimu Pyar yigi dye loo na. ");
INSERT INTO xrb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ke kapahayɛ̃ sẽŋsyale n u yey ma yee: «Ah ndee, dya nwo kãnyãrwai waa kẽ ma bya ne!» Pyar n yee: «Aye, poo waa sẽ kẽ ra ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wɛr tii naa n pai ke dyaŋ, pe tẽntẽ- tesẽ pe Yãhã kangbãŋ sẽŋfa mpãy ne pe pye ke fla na, pe ba naa tar, ma naa n waha. Pyar bya pye pe ne, ma naa naa waha. ");
INSERT INTO xrb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","U Yãhã yũndefa yĩŋfua Yana n Yesu yey ma yee: «Mpãy poo pe ma ma kãnyãrwai? Kai- nkãy syi koo taa nawee- klaha?» ");
INSERT INTO xrb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu n u yɛ̃ wãã sya ma yee: «N ba naa nawee- klaha Yiifee- yawãhã nwey wo, tesẽ Yãhã kangbãŋ wo, Yiifee- byɛ naa pe ya wãã too flɛ nde wo. N ke kai- byɛ pãã naa n yi, n sẽ kaplãŋ nkãy wũhũ naa n pãã ye, nawee- byɛ ke cã. ");
INSERT INTO xrb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nwa ta ma n nii le yey ndoo ye? Le ma pye ke dyaŋ, mpãy pe naa ta kaplãŋ luhu, le yey poo ye, poo le cã.» ");
INSERT INTO xrb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tuu naa n pãã ke dyaŋ, pe Yãhã kangbãŋ sẽŋfa mpãy pe pye ke fla na, poo nen waa n u fey, ma u pye ma yee: «Nwa ta ma n nii n pãã Yãhã yũndefa yĩŋfua ne ke dyaŋ?» ");
INSERT INTO xrb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu n u pye ma yee: «N ma tee pãã, le tɔ̃r ra ye lii tẽ pãã wãpee. Ke ma -sẽ pye cĩĩnde tẽ pãã, nwa ta ma n ta fey?» ");
INSERT INTO xrb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Loo kur ye, Yana n Yesu nɔ wãã u Yãhã yũndefa yĩŋfua Kayifu fla na. Ke namihi pye u na nantãŋ, pe ba u pua yigi. ");
INSERT INTO xrb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pyar woo -sẽ pye u naa naa waha. Waa n u yey yahamba: «Ah ndee, u dya nwo kãnyãrwɛ waa kẽ ma ne?» Pyar n maha le kai ma yee: «Aye, poo waa sẽ kẽ ra ne ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","U Pyar tuu -sẽ ba dya wii ndityɛ gbã cɛr Yesu yigiyale wo, u dya pye Yãhã yũndefa yĩŋfua tẽntẽ waa nwoŋfua. Woo tẽntẽ n Pyar yey yahamba: «Ah, n sẽ ma yãã la Yesu ne katyir lankua wo?» ");
INSERT INTO xrb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pyar n maha le kai ma yee u sẽ Yesu cã ye. Ngupuai n -sẽ ta tɛr kui. ");
INSERT INTO xrb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ke yĩŋsyii sukũhũntãy yĩŋ na, pe n Yesu yigi yi Kayifu fla na, pe byɛ n wãã ga u ne u fãngafua tẽntẽsaha wo, kangbãŋ gaa ba kẽ. U fãngafua myaha ba kẽ Pilati. Pe Yiifee- sẽ -sẽ ba dye ke kangbãŋ laam wo ye, u fãngafua tee pye kulaafua. Pe ma ne dye, pe saa ne waha te syayaha gbar dir di ye. ");
INSERT INTO xrb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Loo na Pilati n yi u kaha wo, ma ka pe kuɛ ye, maa pe yey ma yee: «Lii kapee ne u dya tuu pye?» ");
INSERT INTO xrb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pe n u yɛ̃ wãã sya ma yee: «Dya nwo ma ne yee u wee kapeepyefua ye, wo saa ne pye too u yigi ba ma fla na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilati n pe pye ma yee: «Le ma pye ke dyaŋ, ye u sãhã ye klo kai- kãnde na.» Pe n yee: «Ye kãnde na, wii Yiifee-, wo sẽ yai wo nawee boo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Pe loo pãã ke syi, kai- nkãy Yesu tuu ba cãã pãã yaha faale wo u ya gbã wĩĩ na, koo kai- kẽ ke nii n pye loo yale wo. ");
INSERT INTO xrb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilati n dur dye tɛr u nangbãŋ kaha wo, ma ta pe n Yesu yee ba. U n ba u yey ma yee: «Mboo la pe Yiifee- yĩŋfua?» ");
INSERT INTO xrb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu n -sẽ u yey: «Ma le cã mii ya laa, mpãy me pe le pãã ma ye?» ");
INSERT INTO xrb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilati n u pye ma yee: «N wee Yiifee- terfua ye. Ma terfa Yiifee-, tesẽ Yãhã yũndefa yĩŋfa ne, poo pe ma yigi ba wãã ra kẽ. Le pãã ra ye lii taa pye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu n u pye ma yee: «Ta yĩnfar wee driyɛ̃ nge wo ye. Le ma ne pye ke dyaŋ, ta nawee- ga ne naan miy ta draha wo, ta napĩĩ- ma n waha ra yigi ye. Ta yĩnfar sẽ -sẽ wee driyɛ̃ nge wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Loo na Pilati n -sẽ u pye ma yee: «Jaha ma ma yĩŋfua?» Yesu n u yɛ̃ wãã sya ma yee: «Ãwã, taa le pãã mii, n ma yĩŋfua. N see nawee, ma pa driyɛ̃ laam wo, ma ba cĩĩnde yar nawee- na. Cĩĩnde le n tãy nawee- mpãy ye, pe n luhu ra ye.» ");
INSERT INTO xrb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilati n u pye ma yee: «Ah nwa kẽ cĩĩnde ne?» Pilati tuu loo pãã wa, u n yi ga maa Yiifee- wãã sya kãndi wo, ma pe pye ma yee: «Ye dya nwo yigi ba ra kẽ, n sẽ -sẽ laa kapee yãã u na ye. ");
INSERT INTO xrb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dyɛ- byɛ syayaha gbar na, ye sẽ ne pa la, ye yee ndoo n nwompihifua waa yi yaha ye kẽ? Yaʼa sya, n ga Yiifee- yĩŋfua yi yaha ye kẽ naandyɛ.» ");
INSERT INTO xrb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pe Yiifee- n nii n tẽ ma yee: «Aye, wo wee woo wĩĩ na ye, wo n traha ma Barebaa woo yi yaha wo kẽ.» U Barebaa -sẽ pye yuhu naboofua. ");
INSERT INTO xrb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Loo kur ye, Pilati n ta pe n Yesu gbã sãngblã ne. ");
INSERT INTO xrb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pe seraasyi n nii u lɛr, ma yĩŋfua nayreyãhã le u na, ma ngur maha ta u yĩŋ na yĩŋfua nkifai dyaŋ, ");
INSERT INTO xrb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ma dur ma nii yũhũ n crã u na, ma nii u lɛr yĩŋfua syaha ne ma yee: «Yiifee- yĩŋfua wo ma syar», ma -sẽ maha nii u fey. ");
INSERT INTO xrb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Loo kur ye, Pilati n maha yi ba pe Yiifee- fla na, maa pe pye ma yee: «Ye tyii, pe n yi ba u ne kãndi wo. N n traha n -sẽ le pãã ye ye, ndoo sẽ laa kapee yãã u na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Loo na, Yesu n yi ke yĩŋfua nayreyãhã ne, tesẽ ke ngur nkifai ne u yĩŋ na. Pilati n -sẽ pe pye ma yee: «U dya nwo.» ");
INSERT INTO xrb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yaliile pe Yãhã yũndefa yĩŋfa, tesẽ pe nawee- ne pe u yãã, pe nii n tẽ ma yee: «U kuey mar boo trã na! U kuey mar boo trã na!» Pilati n pe pye ma yee: «-Ye u kuey mar boo yii ya, ndoo sẽ laa kapee yãã u na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pe n u yɛ̃ wãã sya ma yee: «Wo kãnde na u yai u ku, u tee yee woo ma Yãhã Dya.» ");
INSERT INTO xrb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilati tuu pe kaplãŋ luhu Yesu wĩĩ na, u n fya ma ta tɛr faale yaha. ");
INSERT INTO xrb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","U n dye ga u tẽntẽsaha kangbãŋ wo, maa Yesu yey ma yee: «Ah ma n yi na cigege?» Yesu sẽ -sẽ u yɛ̃ wãã sya ye. ");
INSERT INTO xrb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilati n -sẽ u pye ma yee: «Ah ma saa ndoo gɛ yɛ̃ wãã sya la? Ma sẽ cã la fãnga ma ra ye, ta n ga waha ma yi yaha, le ma maha tãy ra ye, n ta pe n ma kuey mar boo trã na?» ");
INSERT INTO xrb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu n u yɛ̃ wãã sya ma yee: «Ma saha fãnga wĩĩ laa pye ra na ye, n sẽ sye Yãhã ma fĩhĩ lii wãã ma kẽ. Koo syi, wii tuu ra yigi wãã ma kẽ, woo kapee tɛr ma wĩĩ yaha.» ");
INSERT INTO xrb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Loo yale wo, Pilati naa Yesu wãyiyaha wĩĩ kɛ. Pe Yiifee- poo -sẽ nii n tẽ fãnga ne ma yee: «Maʼa u dya miy yaha, ma wee fãngafa byɛ yĩŋfua naambiyã ye. Nawee nawee ma u ya ta yĩŋfua, u ma fãngafa byɛ yĩŋfua napĩĩ.» ");
INSERT INTO xrb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilati tuu koo kaplãŋ luhu wa, u n ta pe n Yesu yigi ga kãndi wo. Pilati n pa, maa tege nii kasãhãfua niisaha wo, draha gii pe naa n yee ntẽmbapai fla, pe naa ke yee Gabata yebɛrɛ yor wo, Yiifee- yor kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te syayaha gbar ne ga dye koo per yĩŋsyii wo. Koo per yaiwlaŋ yale ba kẽ, Pilati tuu pye u ba tege nii kasãhãfua niisaha wo, u n Yiifee- pye ma yee: «Ye yĩŋfua nwo.» ");
INSERT INTO xrb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe n -sẽ nii n tẽ ma yee: «U boo, u boo, u kuey mar boo trã na!» Pilati n pe pye ma yee: «Ah ye yĩŋfua kẽ, ye -sẽ yee, n u kuey mar mii syi?» Pe Yãhã yũndefa yĩŋfa n yee, a yĩŋfua waa wee poo ye, mii u fãngafa byɛ yĩŋfua sẽ kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Loo na, Pilati n pe laam wĩĩ pye, ma Yesu wãã seraasyi kẽ, pe ga u kuey mar yaha trã na. Pe seraasyi n Yesu yigi tɛr, ");
INSERT INTO xrb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ma yi u ne le klo wo. U n u kueymartrã tẽŋ u ya ya. Teelii fla pe n yee Gblegbeta Yiifee- yor wo, le yĩntaha kẽ yĩnkluhu fla, pe n ka koo fla na. ");
INSERT INTO xrb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Koo fla pe Yesu kuey mar yir yaha trã na, ma maha nawee- syãm mpãy kuey mar yir yaha u kãnkãy na pe ya wuhu na, Yesu pye pe telai wo. ");
INSERT INTO xrb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati n ta pe n wãŋ gaa gbe, ma yrũhũ ke na, ma ga ke gbãã yaha le trã na ncaha ye. Pe ba yrũhũ ta ma yee: «nasarɛtefa yesu, yiifee- yĩŋfua kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ke kaplãŋ ba yrũhũ ta yor flɛ tãã wo, Yiifee- yor, tesẽ Wɔrmefa yor ne, ma suhu Jrɛkefa yor ne. Draha gii pe ba Yesu kuey mar yir yaha trã na, ke fla pye klo tãy tũntũn. Ke n ta Yiifee- busãã n ke wãŋ yãã, ma kal. ");
INSERT INTO xrb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pe Yãhã yũndefa yĩŋfa n ka Pilati fla na, maa u pye ma yee: «Kaplãŋ ngĩĩ ke yrũhũ ta nii ma yee, Yiifee- yĩŋfua kẽ u ne, ma sẽ yai ma tyii ke na ye, ma yai ma ta pe n yrũhũ ta, a dya nwo yee woo ma Yiifee- yĩŋfua.» ");
INSERT INTO xrb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilati n pe pye ma yee: «Tẽ lii yrũhũ ta, le ga kuee loo na.» ");
INSERT INTO xrb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pe seraasyi pe Yesu kuey mar yir yaha wa le trã na, pe n u nayrɛ gbe, ma la flɛ resyar. Pe byɛ n fla naneŋ gbe. Pe n maha u nayrengbãŋ gbe, pãhãsaha sẽ pye ke na ye. Ke ba tyĩn fai nen ya. ");
INSERT INTO xrb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Seraasyi n pe ya pye ma yee: «Wo ma syi wo ke nayrengbãŋ tyĩn jũũ ye, -too pyer raa pye, wo cã ke ga nii wii wãŋ.» Pe koo pye wa ke syi, kapãn lii le bii cãã yrũhũ ta nii Yãhã sabangbãŋ wo, loo ne le pye loo yale wo. Loo kapãn ne nde: «Pe ra nayrɛ la pe ya nsoho wo; ta nayrengbãŋ koo na, pe pyer raa pye, maa cã ke ga nii wii wãŋ.» Pe seraasyi -sẽ le pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yesu nahafua pye u ba yɛr Yesu kueymartrã tãy, tesẽ Yesu nahafuasyĩnde ne, ma suhu Klopa cɔɔ Maari ne, tesẽ Madalafa Maari ne. ");
INSERT INTO xrb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu tuu u nahafua yãã, tesẽ u kãnyãrwɛbua ne, pe yir yɛr u kueymartrã tãy, u n u nahafua pye ma yee: «Yaa, dya nwo woo ma ma dya yagaa.» ");
INSERT INTO xrb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","U n u kãnyãrwɛ pye ma yee: «Nwo woo ma ma nahafua yagaa.» Koo per u kãnyãrwɛ n Yesu nahafua yigi ga ta u ya tãy u kuãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu ba cã kai- nkãy ke ne ga u dye, ke byɛ u yãã wa yagaa. U n yee: «Loho fãã ra yigi.» Tuu loo pãã wa ke syi, kapãn lii le ba cãã yrũhũ ta nii Yãhã sabangbãŋ wo u wĩĩ na, loo ne le pye loo yale wo. ");
INSERT INTO xrb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gblãhã gaa pye ke fla na, ke ba yĩĩ defĩĩtãhãpihi ne. Seraasyi n flũhũflũhũ wãŋ gaa gbe, ma kã le ke defĩĩtãhãpihi wo, ma ke wra ta katyigi gaa kayaŋ na, ke katyigi myaha yisope. Pe n ke wãŋ kuã yir ta Yesu yɛ̃ tãy. ");
INSERT INTO xrb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu tuu ke defĩĩtãhãpihi wãr wa, u n yee: «Ke kai- byɛ kua wa,» ma yĩŋ kuɛ tege, ma ku. ");
INSERT INTO xrb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pe Yiifee- yahaseefa sẽ naa n traha te nakur n yai kua ke trãŋ na ye, pe kanii per ga ne fe gbe yainkɔŋ wo, koo kẽ. Koo kanii per ba wãã dye pe syayaha gbar ne. Koo syi kẽ, pe n ka klo laam wo, maa Pilati nar ma yee, a nawee- mpãy pe kuey mar nii trãŋ na, tuu kãnde wãã seraasyi kẽ, pe n ga pe trɛ gbã ka pe n ku farfar, pe n pe tege kãã ke trãŋ na. Pilati n kãnde wãã seraasyi kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nawee- syãm mpãy pe ba kuey mar yir yaha trãŋ na pe ya wuhu na Yesu tãy, pe sẽ ba ku wa ye. Pe seraasyi n -sẽ ga pe trɛ gbã ka. ");
INSERT INTO xrb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yaliile pe ga nɔ Yesu na, maa yãã tuu ku wa, pe sẽ woo trɛ gbã ka ye. ");
INSERT INTO xrb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Seraasyi nen waa n -sẽ Yesu mpĩy kã fer u ncɛŋ ne, ntɔ̃r n ta tɛr yi ma suhu loho ne. ");
INSERT INTO xrb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wii tuu koo kai- ngĩĩ yãã, u ke yar nawee- na. Kai- nkãy tuu yar ke ma cĩĩnde, u cã u cĩĩnde pãã, loo na ye byɛ n waha Yesu wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Koo kai- pe seraasyi pe pye, kaplãŋ nkãy ke bii cãã yrũhũ ta nii Yãhã sabangbãŋ wo, koo kẽ ke naa n pye loo yale wo. Koo kaplãŋ ngĩĩ: «Pe saa u kacrihi neŋ gɛ yoho ye.» ");
INSERT INTO xrb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yãhã sabangbãŋ kapãn laa maha nde: «Wii pe kã fer, pe ga ba u yãã.» ");
INSERT INTO xrb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Dya waa pye, u myaha ba kẽ Yosɛfe, Yarimatefa naa waa ba kẽ. U pye Yesu kãnyãrwai waa, u sẽ -sẽ ba ta waa n yi le cãŋ na ye, u tee naa n fya Yiifee- yahaseefa na. U n pa, maa Yesu nakugu nar Pilati ye. U n kãnde wãã u kẽ. U Yosɛfe n ka, maa ta pe n Yesu nakugu tege le trã na. ");
INSERT INTO xrb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛmu wii u ba ka faale wo Yesu fla na yĩmper wo, u n ka sẽm- ter gbengbeyĩhĩ syãŋ syi ne. Pe sẽm- ba gbihi katyir sĩĩ wãn ne, myer katyigi, tesẽ yaluee katyigi ne. ");
INSERT INTO xrb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","U Yosɛfe, tesẽ u Nikodɛmu ne, pe syãm n Yesu nakugu gbe, ma nii ke tuhu pe miy ne, ma nii ke maha faasyĩmbɛhɛ ne. Yiifee- kãnde wo, pe maa nakugu le, pe ne ke gbihi koo syi. ");
INSERT INTO xrb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Draha gii pe ba Yesu kuey mar trã na, katyir lankua pye ke fla na. Gbĩĩfuɛ̃ pye ke fla na, le ba gbã fer ntẽmblaha fla wo, pe sẽ ba nakugu gaa le yãã le wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Le pye tũntũn. Pe n dye Yesu nakugu ne, ma ke sãy ta le gbĩĩfuɛ̃ laam wo. Pe yai pe ne pye farfar, yainkɔŋ wo kanii per ga ne nɔ, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ke cãwãã per cir yĩnwɔŋ wo, Madalafa Maari ye n ka le gbĩĩ fla na, maa yãã ntẽmbangbãŋ gii ke ba tã le gbĩĩ yɛ̃ na, ke gbe kãã. ");
INSERT INTO xrb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuu le yãã ke dyaŋ, u n fã ga Syimu Pyar fla na, tesẽ u Yesu kãnyãrwɛbua ne, maa pe pye ma yee: «Eh, pe wo Yĩŋfua nakugu yi kãã le gbĩĩ wo, wo sẽ cã pe u ta na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pyar tesẽ woo kãnyãrwɛ ne, pe n yi, ma n gaha le gbĩĩ fla na. ");
INSERT INTO xrb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pe naa n fã pe syãm pe ya tãy, u kãnyãrwɛ nwo naa n fã farfar ma tɛr Pyar yaha; woo n ga cãã dye le gbĩĩ fla na. ");
INSERT INTO xrb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","U n kuɛ tege, ma yãŋ le wãã ma faasyĩmbɛhɛ yãã le gbĩĩ wo, nkãy pe ba Yesu nakugu maha tã ke ne. U sẽ -sẽ dye ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Syimu Pyar n pa u kur kuɛ ye, maa ta tɛr dye le gbĩĩ wo, ma ke faasyĩmbɛhɛ yãã ke fla na, ");
INSERT INTO xrb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma suhu fai lii ne pe ba maha Yesu yĩŋ na, le pye le ya ya, le sẽ pye ngĩĩ ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Loo na, u kãnyãrwɛ wii tuu ba cãã dye le gbĩĩ fla na, u bya n -sẽ dye le laam wo u ya ndoŋ. Tuu ke faasyĩmbɛhɛ yãã ke dyaŋ, u n Yesu wĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pe kãnyãrwai sẽ -sẽ ba Yãhã sabangbãŋ kaplãŋ war wa ye, nkãy ke yee, a Yesu ga yir gbã wo, u dur ba yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pe kãnyãrwai syãm n dur tɛr pe fla na. ");
INSERT INTO xrb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maari n dur ga le gbĩĩ fla na, ma ga nii n wũn. Tuu naa n wũn, ma kuee yãŋ le n wãã le gbĩĩ wo, ");
INSERT INTO xrb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","u n yãhãyĩŋ tẽnlɛhɛ syãm mpãy yãã. Pe kale wãn pye wãfir. Pe ba tege nii teelii wo Yesu nakugu ba sãy ta. Nen pye yĩŋ kuɛ ye, u syãŋ wuhu -sẽ pye trɛ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pe n u pye ma yee: «Cɔɔ, lii raa n wũn?» U n pe yɛ̃ wãã sya ma yee: «Waa ra Yĩŋfua nakugu gbe kãã, n sẽ -sẽ cã u ke ta na ye.» ");
INSERT INTO xrb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yaliile Maari tuu naa n pãã, u n wã klaha, ma Yesu yãã tuu yir yɛr ke fla na, u sẽ -sẽ ba cã Yesu kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu n u pye ma yee: «Cɔɔ, lii raa n wũn, yoo raa n kɛ?» Maari n le ga ma yee katyir lankua sẽŋfua kẽ. U n u pye ma yee: «Ke ma pye mboo raa u nakugu gbe, le pãã ra ye taa ke ta na, ta n ga ke gbe ba le.» ");
INSERT INTO xrb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu n u myaha yee ma yee: «Maari.» Maari n klaha yãŋ, ma u pye Yiifee- yor wo: «Arbuni,» koo yĩntaha kẽ yĩŋfua. ");
INSERT INTO xrb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu n u pye ma yee: «Maʼa n ta yigi yaha ye! Ma sẽ yãã, n sẽ dugu ga wa ra Tuhufua Yãhã fla na ye. -Taa -sẽ ka ra nampyeŋ- fla na, maa pe pye, a ndoo ga dugu ga ra Tuhufua fla na, wii u ma ye byɛ Tuhufua, ma maha ma Yãhã ra ye, tesẽ ye bya ye.» ");
INSERT INTO xrb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maari n ka, maa le pãã pe kãnyãrwai ye, a woo u Yĩŋfua Yesu yãã. U n maha Yĩŋfua Yesu tẽnlɛhɛ byɛ tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Koo per yĩmper wo, ke pye cãwãã per cir, pe kãnyãrwai ba pe ya wãã ta nwongbãŋ gaa wo, ma te kããnklee gbãã tã, pe tee naa n fya pe Yiifee- yahaseefa na. Yesu n fer gbe yi pe laam wo, ma pe syar ma yee: «Yãhã n yrĩŋ wãã ye kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tuu ba pãã wa ke dyaŋ, u n u kluɛ yar pe na, tesẽ u mpĩy ne. Pe kãnyãrwai n too yãã, ma u yãŋ cã, pe laam n fĩhĩ flege. ");
INSERT INTO xrb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","U n maha pe pye: «Yãhã n yrĩŋ wãã ye kẽ. Ta Tuhufua Yãhã tuu ra lɛhɛ wãã mii syi, ndoo bya n -sẽ ga ye lɛhɛ wãã koo syi.» ");
INSERT INTO xrb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tuu loo pãã wa, u n tefay fua woo pe na, ma pe pye ma yee: «Ye tyii Yãhã Yrã Fãnga n dye ye laam wo! ");
INSERT INTO xrb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yaʼa mpãy kapee- laha kãã pe na, ke ga kua pe na, yaʼa -sẽ mpãy kapee- sye yaha pe na, ke ga kuee pe na.» ");
INSERT INTO xrb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesu tuu ba u ya yar u kãnyãrwai na, Tema wii pe naa n yee Didim, koo yĩntaha wuhuwãã, woo sẽ pye pe laam wo ye. Pe kãnyãrwai sẽnsye syãm mii waa ba kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pe kãnyãrwai mii n -sẽ le pãã u ye, poo u Yĩŋfua yãã. U n -sẽ pe pye ma yee: «N ma yee n sẽ pe puɛ̃nte kueysar yãã u kluɛ na, ma ta kãnde tɛ te na ye, tesẽ n ma yee n sẽ ra koho le u mpĩy nadyaha fla na ye, n saa le sya u yir gbã wo ye.» ");
INSERT INTO xrb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Plii kuatãã n ba nɔ, pe kãnyãrwai n maha ba pe ya wãã ta ke nwongbãŋ wo, Tema pye pe ne. Te kããnklee ba gbãã tã, Yesu n fer gbe yi pe nsoho wo, ma pe syar ma yee: «Yãhã ke yrĩŋ wãã ye kẽ.» ");
INSERT INTO xrb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","U n Tema pye ma yee: «Tema, ta kluɛ yãŋ, pa ma ba tɛ yãŋ te na! Ma koho yũhũ ba le ta mpĩy fla na; ma tee ba yee ma sẽ ta wĩĩ sya cĩĩnde ye. Yagaa le sya cĩĩnde, ndoo yir gbã wo!» ");
INSERT INTO xrb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tema n u yɛ̃ wãã sya ma yee: «Mboo ta Yĩŋfua, mboo ta Yãhã.» ");
INSERT INTO xrb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu n u pye ma yee: «Taa ra yãã, koo kẽ ma n le sya cĩĩnde. Mpãy pe sẽ le yãã ye, ma -sẽ le sya cĩĩnde, poo wĩĩ n tãy.» ");
INSERT INTO xrb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Cãã gii byɛ Yesu tuu pye u kãnyãrwai ne, u ba laanwɔ wũhũ busãã pye, koo byɛ sẽ yrũhũ saba nwo wo ye. ");
INSERT INTO xrb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kai- ngĩĩ -sẽ yrũhũ ta saba nwo wo, ma yee ye le sya cĩĩnde Yesu woo kẽ u Yãhã Yĩndefua Crise. U maha ma Yãhã Dya. Yaʼa u ta ye Yatɛr, ye ga cĩĩnde yrã yãã, lii wãkuayãã wee le na ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Loo kur ye, Yesu n u ya yar u kãnyãrwai na Galɛlɛ langbãŋ yɛ̃ na, klo laa tãy pe naa n yee Tyibɛryati. Tuu u ya yar pe na mii syi, le nde. ");
INSERT INTO xrb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Per gaa, Syimu Pyar, tesẽ Tema ne wii pe naa n yee wuhuwãã, ma suhu Natanelu ne, u naa n yi Kana wo Galɛlɛ kuɛ ye, tesẽ Sewede dyam ne, ma suhu kãnyãrwai syãm mpãy ne pe pye pe ya ne. ");
INSERT INTO xrb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Syimu Pyar n pe pye ma yee: «Ndoo n gaha fuayigisaha wo.» Pe n u pye ma yee: «Wo bya ga ka ma ne.» Pe n yi, maa dugu dye salangbãŋ wo, ma nii jɔɔ miy yahasee ye. Koo yĩmper byɛ wo, pe sẽ ngaa yãã ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yũhũ ke ba syii, Yesu n pa, maa yɛr langbãŋ yɛ̃ na. Pe kãnyãrwai n u yãã, pe sẽ -sẽ ba cã woo kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","U n pe pye ma yee: «Ta cĩĩfa, ye sẽ fua- yãã yigi la?» Pe n yee: «Aye, wo sẽ ngaa yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tuu loo luhu, u n pe pye ma yee: «-Ye u jɔɔ miy le yagaa ke salangbãŋ kãndigi kuɛ ye, ye ga yigi!» Pe n -sẽ u jɔɔ miy le, ma yãã pe saha u jɔɔ tyĩn ba le ke salangbãŋ wo ye, u ba yĩĩ fua- ne, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pe loo yãã, u Yesu kãnyãrwɛbua n Syimu Pyar pye ma yee: «Eh, wo Yĩŋfua kẽ.» Pyar -sẽ pye kadyepua ne. Tuu loo luhu, u n u nayroho gbe le, ma too loho wo, ma ga ka farfar. ");
INSERT INTO xrb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Loo yale wo, pe kãnyãrwai sẽ ba dey langbeŋ na ye. Pe n nii n pai ke salangbãŋ ne, ma nii u jɔɔ tyĩn n taha pe ya na, u ba yĩĩ fua- ne. ");
INSERT INTO xrb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pe ga tege kãntraha na, pe n fua- yãã naankãhã na, bur ne kãnkãy na. ");
INSERT INTO xrb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu n pe pye ma yee: «Ta cĩĩfa, fua- mpãy tee yigi, -ye pa mpãy ne!» ");
INSERT INTO xrb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Syimu Pyar n dugu dye ke salangbãŋ wo, ma u jɔɔ fle yi. U ba yĩĩ fuababai gbeekuasĩĩ sẽnsye tãã ne. Pe fua- wãnihi naa byɛ ne, u jɔɔ sẽ cɛr ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu n pe pye ma yee: «-Ye pa yaa di!» Pe ba u yãŋ cã, waa sẽ u yey ma yee yoo kẽ u ne ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","U n yũhũ dye pe tãy, ma bur gbe ma naha ka la pe kẽ, fua- ne. ");
INSERT INTO xrb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tuu ku ma yir gbã wo, u tɛhɛ tãã wuhu kẽ tuu u ya yar u kãnyãrwai na. ");
INSERT INTO xrb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yaliile pe ba di wa, Yesu n Syimu Pyar yey: «Nsãn dya Syimu, ta ntãŋ dye la ma tãy, ma ta tɛr mii mii yaha?» U n u yɛ̃ wãã sya ma yee: «Ãwã, Yĩŋfua, ma cã ma wĩĩ n tãy ra ye.» Yesu n -sẽ u pye ma yee: «Ta nawee- yigi yɔ̃ mbanaha wãŋ syi dyaŋ u mbapĩy ne!» ");
INSERT INTO xrb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","U n u yey tɛhɛ syãŋ wuhu na ma yee: «Nsãn dya Syimu, ta ntãŋ dye la ma tãy?» U n u yɛ̃ wãã sya ma yee: «Ãwã, Yĩŋfua, ma cã ma wĩĩ n tãy ra ye.» Yesu n u pye ma yee: «Naa ra nawee- yãŋ mbanaha wãŋ syi dyaŋ u mbapĩy ne!» ");
INSERT INTO xrb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ke tɛhɛ tãã wuhu na u n u yey: «Nsãn dya Syimu, ta wĩĩ n tãy la ma ye?» Pyar laam n wlãhã, tuu u yey ke tɛhɛ tãã wuhu na, a u wĩĩ n tãy la u ye. U n u pye ma yee: «Yĩŋfua, mboo taa kai- byɛ cã, ma cã ma wĩĩ n tãy ra ye.» Yesu n u pye ma yee: «Ta mbapĩy yigi yɔ̃! ");
INSERT INTO xrb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta n kapãn laa pãã ma ye, taa pye naanfuɛ̃, ma naa mii pua mii ya, ma naa n gaha teelii ma ma tãy. Maʼa -sẽ ba lɛ, maa ba kluɛ kuã naa n yir, waa n naa ma pua nayrɛ wãn ne, u naa n gaha ma ne teelii le sẽ n tãy ma ye ye.» ");
INSERT INTO xrb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kaplãŋ ngĩĩ le yar, Pyar ga ba gbã mpãy ter ku, u Yãhã myaha gboho ke syi. Yesu tuu loo pãã wa, u n u pye ma yee: «Naa n taha ra na ma kuãŋ ne!» ");
INSERT INTO xrb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pyar n klaha yãŋ kur kuɛ ye, ma Yesu kãnyãrwɛbua yãã tuu n taha pe na. Per gii pe ba kur kuɛ digi wãã di Yesu n cã ku, woo kãnyãrwɛ kẽ tuu ba yũhũ dye Yesu tãy, ma u pye ma yee tuu le pãã woo ye, a wii woo tuu ga ba yi kãã u kur ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pyar tuu ba u yãã, u n Yesu yey ma yee: «Yĩŋfua, ah woo, lii loo le ga ba u dye?» ");
INSERT INTO xrb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu n u yɛ̃ wãã sya ma yee: «N ma sya n traha u kuee driyɛ̃ wo ta n sya ba dur ba, ma kalaa wee ye. Mboo, naa n taha ra na ma kuãŋ ne!» ");
INSERT INTO xrb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesu nawee- n nii le pãã pe ya nsoho wo, a u kãnyãrwɛ saa ku yãã ye. Yesu sẽ -sẽ ba le pãã Pyar ye, a u kãnyãrwɛ saa ku yãã ye. U ba yee, a le ma tãy woo ye u kuee driyɛ̃ wo woo n sya ba dur ba, u kalaa wee ye. ");
INSERT INTO xrb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Woo kãnyãrwai kẽ tuu kai- ngĩĩ tɔ̃r nawee- ye, ma ke yrũhũ ta. Wo byɛ, wo cã lii tuu pãã le ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu maha kai- busãã pye. Pe ma ne ke byɛ yrũhũ naa n ta sabar wo, n sẽ le sya te tasar ga ne yãã driyɛ̃ kur byɛ wo ye.");
INSERT INTO xrb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ta naambiyã Tohofile, Yesu tuu fe yir, u naa nawee- klaha kai- busãã ne, ma maha naa yɛ̃kã wũhũ pye, ma cã ba dugu ga yãhãyĩŋ na. Koo ngĩĩ byɛ kẽ, tẽ yrũhũ wãã ma kẽ ta saba cir laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Per gii Yesu tuu ga ka yãhãyĩŋ na, u kãnyãrwai mpãy tuu ba yãŋ yi, koo per u pe ta u tẽnlɛhɛ ma pe klaha ta Yãhã Yrã Fãnga kãmay na. Tuu loo pye wa, Yãhã n u ta u n dugu ga yãhãyĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tuu fɛngbãn tii sya ma ku, loo kur ye, u n ba naa u ya yar u tẽnlɛhɛ na, ma kãnkai- sroŋ pye pe waha cã pe yee, u yir gbã wo, ma dur ba yrãŋ na gbaafa ye cĩĩnde. Plii gbeesĩĩ tuu pye wãyi ne pe na, ma naa Yãhã Yai wĩĩ pãã pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Per gaa u pye pe ne, ma ba pe klaha ta nde ne ma yee: «Ta Tuhufua tuu yɛ̃ tɛr kla gii wãwãã wĩĩ ne faa ye kẽ, koo kla ma yee ke sẽ yãã wa ye ye ye, yaʼa n yi kãã Yurusalɛm wo ye, -ye ke sẽŋ! ");
INSERT INTO xrb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nsãn woo nawee tãã yi loho wo, ndoo -sẽ ga ye tãã Yãhã Yrã ne plii nde na.» ");
INSERT INTO xrb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mpãy pe ba pe ya wãã ta Yesu tãy, pe n u yey ma yee: «Yĩŋfua, yagaa la, taa ga Yiisrɛ terfa kar sya yaha nampay fãnga koho wo?» ");
INSERT INTO xrb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu n pe yɛ̃ wãã sya ma yee: «Ke per wãcãŋ tesẽ le yale ne, ye kalaa wee le na ye. Yãhã ya kẽ, ke koo per ta tesẽ le yale ne, ke laam wãtaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Tee yai lii ne loo ne nde: Yãhã Yrã ga ba tege dye ye laam wo. Loo nde ga ba fãnga wãã ye kẽ, ye n ka ye ga naa ta yɛ̃ kaplãŋ tɔ̃r nawee- ye tesẽ kai- nkãy byɛ ne tẽ pye tɛr. Yii mpãy tee ke yãã yĩnde ne, ma maha ke yãã luhu, ye ga ba naa koo ngĩĩ byɛ tɔ̃r Yurusalɛm wo, Yudɛ kui byɛ ne, Syamari kui ne, deydey kui byɛ ne kãntraha nge na.» ");
INSERT INTO xrb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu tuu loo pãã wa, Yãhã fãnga n ta u n kuã yir tɛr fãã, yãhãyĩŋ kuɛ ye pe tẽnlɛhɛ byɛ yĩnde na, pe n yɛr ma u waha yãŋ n wãã, u n sya ga paha yãhãfyãhã gaa na pe na. ");
INSERT INTO xrb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pe sẽ yãã yĩntar gɛ gbe kãã wa yãhãyĩŋ wãyãŋ na ye, nayrefirfa syãm mpãy syi n fer gbe yi pe tãy, ");
INSERT INTO xrb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ma pe pye ma yee: «Galɛlɛ naam! Le ma mii ye n yɛr yãhãyĩŋ tẽŋ n yãŋ? Tee u Yesu wãtɛr yãã mii, u wãdur ga ba nii ke syi.» ");
INSERT INTO xrb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kai- ngĩĩ -sẽ pye yãŋ gaa yĩŋ na pe n yee wolifyɛ katyir fla yãŋ. Ke fla pye Yurusalɛm tãy tũntũn ya. Pe tẽnlɛhɛ, pe pe naam syãm mii kaplãŋ luhu wa, pe n yir ke yãŋ yĩŋ na, ma dur ga Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pe ga dye Yurusalɛm wo, pe ga dugu dye gbegbaha yĩŋ nwongbãŋ gaa wo. Yesu kãndeyãrfa yawãhã fla ba kẽ ke ne. Mpãy pe ba pe ya wãã, pe myar nde: Pyar, Nsãn, Syake, Andere, Filipe, Tema, Bateremi, Matɛhɛ, Alefɛ dya Syake ne, Syimu Selote, Syake dya Yudi ne. ");
INSERT INTO xrb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ca mpãy bya pye ke fla na, Yesu nahafua Maari ne, tesẽ Yesu cĩĩfa bya ne. Pe byɛ naa pe ya wãã yĩmbui nen na, ma naa n pãã Yãhã ne yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Per gaa, pe n ba pe ya wãã peplii wãŋ syi, ma pe ya wãnihi yãã nawee- gbeekuay. Pyar n yir yɛr pe telai wo ");
INSERT INTO xrb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","ma pe pye: «Wo nna, yii mpãy tee Yesu ta ye Yatɛr, kai- ngĩĩ ke pye ngĩĩ, le sẽ pye wãkuãtɛr wĩĩ mii le sẽ pye ye. Yuda wii tuu sya nii tɛrfua Yesu napĩĩ- yaha ye, pe n ga u yigi, Yãhã Yrã bii u wĩĩ cãã yar wo faale wãdyaha Dawide na, u n le yrũhũ le yaha Yãhã sabangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda pye wo nklãŋ wo, ma ba u tẽn lay yãã. ");
INSERT INTO xrb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yuda tuu -sẽ loo kapee pye Yesu na, ma wale lii yãã loo kur ye, u tar sya le ne. Naniicã n u yigi, u n ga tege too yĩŋ ne, ma lar waa crãhã yi u ya kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yurusalɛmfa byɛ n le luhu, ma myaha taha te tar na pe yor wo ma yee: Hakɛledam, ke yĩntaha kẽ, ntɔ̃r tar. ");
INSERT INTO xrb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yãhã sabangbãŋ wo, Yãhã wãsey yay fla wo, kapãn laa ma, le yrũhũ yaha ma yee: ‹U kaha ke too, nawee nen gɛ ma n nii ke wo ye.› Le maha ma le yrũhũ yaha ma yee: ‹Waa ter u u draha gbe.› ");
INSERT INTO xrb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Mpãy pe naa n taha wo na, ma gbe Yĩŋfua Yesu wãtãã cãã na loho wo Nsãn ye, ma ba waa u wãkuãyirtɛr yale na yãhãyĩŋ na, poo waa yai u Yuda draha gbe. Ufua tuu yãã yĩnde ne, Yesu yir gbã wo, ma dur ba yrãŋ na gbaafa ye, u ga ba naa loo tɔ̃r nawee- ye wo wãŋ syi dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pe n naam syãm mpãy yãŋ yi: Matyase ma suhu Yosɛfe wii ne pe naa n yee Gbarsabaha, pe maha naa u yee Yituse. ");
INSERT INTO xrb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pe Yesu kãndeyãrfa byɛ n yĩmbui wãã le, ma Yãhã nar ma yee: «Yĩŋfua, mboo wii, maʼa nawee yãã, ma ne u laam wũhũ byɛ yãã gbaa na, wo yar nde ne: ");
INSERT INTO xrb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Le nde Yuda le kɛ, ma yũhũ kãã draha gii wo raa wãã u kẽ, ma ka u ya ya draha wo kii tuu ma yagaa. Naam syãm mii mii, too yar ma na, wii raa yãŋ yi, u n ga Yuda draha gbe, ma n waha u lɛhɛ ma wĩĩ ne nawee- ye, u yar wo na.» ");
INSERT INTO xrb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Loo kur ye pe n ntĩhĩ syãŋ wãã miy: Nen nde Matyase myaha wĩĩ, nen nde Yosɛfe myaha wĩĩ. Matyase myaha wĩĩ loo n cãã too. Pe n Matyase ta u Yuda draha wo. ");
INSERT INTO xrb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yiifee- gbar gii pe naa n yee pããnkɔti, ke per ba nɔ, Yesu kãndeyãrfa byɛ n pe ya wãã pe peplii yawãhã saha wo. ");
INSERT INTO xrb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gbleŋ gaa ter n ba fe gbe yi yãhãyĩŋ kuɛ ye. Gbleŋ gii maʼa luhu ke ye, maa yee teflahangbãŋ ke n gbã. Ke n gble ba dye taha pe na ke nwoŋ wo, ke n nii gbleŋ fla ya. ");
INSERT INTO xrb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pe Yesu kãndeyãrfa n yãŋ ma yãã mii naa yĩnkãmbɛhɛ dyaŋ ke wãã ta, ma nii n tar blayblay. Ke sẽ -sẽ maha wee cĩĩnde naawraŋ ye. Ke n ba fe cããŋ, ma too pe byɛ na nanem. ");
INSERT INTO xrb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yãhã Yrã n dye pe laam wo, ma pe nanem ta pe n nii yor tee naneŋ pãã gbɛgbɛ, yor tii gɛ pe sẽ cã yãã faale wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Teebɛhɛ byɛ Yiifee- mpãy pe naa Yãhã kɛ, pe byɛ ba pe ya wãã Yurusalɛm wo koo per, ke pããnkɔti gbar wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ke gbleŋ ke yi ke syi, pe n ga pe ya wãã ta ke fla na. Laa n pe fe gbe, ma ga ta tɛr. Pe laam wo nawee nawee woo, ma naa n luhu u klo yor ye Yesu kãndeyãrfua waa yɛ̃ na, le n yɛ̃ kã pe na. ");
INSERT INTO xrb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Le n kacãn faha pe kẽ, pe yĩnde n yi too pe na, pe n nii n yee: «Galɛlɛ gbentee nen nawee- sẽ na Yesu kãndeyãrfa ne? Ah pe pye gɛ pye mii, wo byɛ n nii wo kui yor luhu pe yɛ̃ wo wii wuhu na? ");
INSERT INTO xrb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Too yɛr mii, wo laam wo Patifa ma, Madefa ne, Lamitefa ne, Otamifa ne, Yudɛfa ne, Kapadafa ne, Pɔ̃nfa ne, Yasyifa ne, ");
INSERT INTO xrb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firsyifa ne, Pããfilefa ne, Syiptefa ne, Lebi kãnkãyaha ngaafa ne kii ke crã Syirɛ̃ na, ma suhu Wɔrmefa ne, Kartifa ne ma suhu Arabifa ne. Wo laam wo mpãy ma pe see Yiifee-, mpãy ter -sẽ maha ma pe pe ya le Yiifee- kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wo wãnihi naa byɛ ne, wo byɛ -sẽ n luhu pe Yãhã kangbãhã pãã wo yor wo wii wuhu na.» ");
INSERT INTO xrb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Loo n fĩhĩ ga pe laam sroŋ wɔ, pe n nii, lii gɛ pe n ga, pe sẽ le cã ye, ma nii pe ya yey ma yee: Nde yĩntaha gɛ kẽ lii ne? ");
INSERT INTO xrb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pe laam wo, mpãy ter -sẽ maha pye, pe naa Yesu kãndeyãrfa lɛr ma naa n yee: «Ye cã la, sẽm me pe tɛr pe koho ne?» ");
INSERT INTO xrb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Loo na, Pyar n yir yɛr u tẽnlɛhɛwai sẽnsye nen telai wo, ma u yĩmbui yir, ma pe nanihi pye ma yee: «Yiifee-, yii tẽ n yãŋ ma suhu mpãy ne pe pa Yurusalɛm wo te gbar wĩĩ na. -Ye ndityuhu yaha, ye nde luhu yɔ̃ tẽ ga tɔ̃r ye ye! ");
INSERT INTO xrb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nwa ta ye n yee, a sẽm ndoo tẽnlɛhɛwai yigi? Yalii pe pe yãã ma wɔ wa, pe n sya pe yigi sukũhũntãy yĩŋ nge syi na, ntãŋ kuãyale gɛ sẽ yãã ta tɛr wa ye? ");
INSERT INTO xrb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ye yai ye le cã faale Yãhã kaplãŋ tɔ̃rfua Yɔwɛl tuu bii kai- nkãy cãã tɔ̃r yaha, koo kẽ ke n pye nanga. U bii yee: ");
INSERT INTO xrb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yãhã yee: ‹Lii le ga ba yãã driyɛ̃ kuayale plii na, le nde: N ga ba ta Yrã tege cããŋ le nawee- laam wo. Ye pii tesẽ ye pueesyam ne, pe ga ba naa kaplãŋ tɔ̃r, nkãy tẽ ga ba naa n yar pe na. Ye naanfãm ga ba naa kai- yãã wãytãã wo, ye wãlɛ ga ba naa kai- yãã mluɛ̃ wo. ");
INSERT INTO xrb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mpãy byɛ pe ma ra tẽn na, pe naam tesẽ pe ca ne, cĩĩnde, n ga ba ra Yrã tege cããŋ le pe laam wo. Pe ga ba naa kaplãŋ tɔ̃r too plii nde na, nkãy tẽ ga ba naa n yar pe na. ");
INSERT INTO xrb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tẽ ta, laanwɔ wũhũ n naa n pye yãhãyĩŋ na, yɛ̃kã wũhũ ne kãntraha na. Ntɔ̃r ga ba pye, naa ne, naawur ne yãhãsyɔ̃r dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yai ga ba wɔ tã, yroŋ ga ba yrãhã cor ntɔ̃r dyaŋ. Loo na Yĩŋfua ga cã pa fãnga ne tesẽ nayɔ̃r ne. ");
INSERT INTO xrb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Loo yale wo, nawee wii nawee wii woo ma Yĩŋfua myaha yee ma u nar, Yĩŋfua ga ufua yi le wo.› ");
INSERT INTO xrb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yiisrɛfa, -ye luhu, n ga nde pãã ye ye: Yãhã Yesu fãnga yar ye na ma u ta, u n yɛ̃kã wũhũ ter byɛ pye tesẽ laanwɔ wũhũ ter byɛ ne, ye n yãã yĩnde ne. Ye koo byɛ cã. ");
INSERT INTO xrb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Loo naa byɛ ne, ye Yesu yigi, ma sya u wãã mpãy kẽ pe sẽ Yãhã cã ye, pe n u kuey mar boo trã na. Yaʼa yãã tee waha loo kapee nde pye, Yãhã bii loo nde cãã ta wa. Koo kẽ le n pye. ");
INSERT INTO xrb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yãhã gbã naankãn gbe kãã u na, ma u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. U wãyigiyaha nakur klo wo, loo fãnga sẽ pye gbã ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wo wãdyaha Dawide gɛ bii loo cãã pãã wa u wĩĩ na faale wo ma yee: ‹N u Yĩŋfua yãã ra yahasee ye yalebyɛ. Tuu nwo ra tãy, n sẽ n sege fyar koho wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Loo ne ta laam n tãy, ta kaplãŋ n nii nuhu fla. Ta kadye ma sya ba fãy ma nii mlũhũmlũhũ, ta n sãy nii ta gbã kafɛhɛ na, le saa kai kua ra ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","N cã, ma saa ra ta yaha nakur klo wo ye. Ndoo wii raa yãŋ yi, n cã, ma saa sya ra n fũhũ nii gbĩĩ laam wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kãnde lii le cĩĩnde yrã wãã nawee- kẽ, ma loo yar ra na. Tẽ ga ba pye ma tãy, le ga ba nii ra ye nuhu wĩĩ.› ");
INSERT INTO xrb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Wo nna, ye cã n ga waha wo faale wãdyaha Dawide wĩĩ pãã laha ye ye. Tuu ku, pe u le gbĩĩ lii wo, loo sẽ na nde nantãŋ too n yãŋ? ");
INSERT INTO xrb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawide kai- ngĩĩ cãã pãã yaha mii Yãhã kaplãŋ tɔ̃rfua dyaŋ u ne. U bii le cã ma yee, Yãhã bii yɛ̃ tɛr u ye, koo ga ba u kur kuɛ puee ta yĩŋfua u wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yãhã ke wii ta ke Yĩndefua, u wãyir gbã wo tesẽ u wãdurba yrãŋ na gbaafa ye, Dawide bii loo cãã cã wa. Koo kẽ u n bii le cãã pãã yaha u wĩĩ na ma yee: ‹Yãhã sẽ u ta yaha nakur klo wo ye, u kadye sẽ fũhũ nii gbĩĩ laam wo ye.› ");
INSERT INTO xrb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","U Yesu wii wĩĩ tẽ n pãã, Yãhã u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye, wo byɛ loo yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yãhã n u kuã yir, ma u ta ke kãndigi koho kuɛ ye, u n nii kai- byɛ Yĩŋfua. Yesu ba yɛ̃ tɛr nawee- ye Yãhã Yrã wãkẽ ne, Yãhã n le wãã u kẽ, u n le tege le wo laam wo. Loo ne tee n yãã, ma maha n luhu. ");
INSERT INTO xrb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ye cã Dawide tuu bii ku, Yãhã sẽ u ta u n kuã yir tɛr yãhãyĩŋ na ye. U -sẽ bii yee: ‹Yĩŋfua Yãhã ra Yĩŋfua pye ma yee: Pa tege nii ra kãndigi koho kuɛ ye kai- byɛ yĩŋ na, ");
INSERT INTO xrb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ta n sya ba ma napĩĩ- yĩy kor le ma kẽ, pe n nii mii ma tãnde fyãhã tã pe na.› ");
INSERT INTO xrb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yiisrɛfa, ye yai ye le cã laha, Yesu wii tee kuey mar boo trã na, woo kẽ Yãhã u ta Yĩŋfua, ma maha u ta ke Yĩndefua.» ");
INSERT INTO xrb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mpãy pe Pyar kaplãŋ ngĩĩ luhu, kadye byɛ n muãy pe ye, pe laam n wlãhã nii. Pe n u Pyar yey u nampyeŋ- ne ma yee: «Wo nna, le nde le nii ke dyaŋ, wo yai wo lii loo pye?» ");
INSERT INTO xrb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pyar n pe yɛ̃ wãã sya ma yee: «-Ye le sya ye cã ye kapee- sẽ yɔ̃ ye, -tee ke wãpyeŋ miy yaha, -tee sya pe n ye tãã yi loho wo Yesu myaha na. Loo na, ye kapee- ga yee laha kãã ye na, tesẽ Yãhã ga ke Yrã Fãnga wãã ye kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ye sẽ yãã, koo katɛ- syãŋ ngĩĩ, Yãhã yɛ̃ tɛr ke wãkẽ ne nawee- mpãy kẽ, ke n pai yãŋ yi nawee- ter byɛ laam wo, yii tesẽ ye kur kuɛ pii ne ma suhu mpãy bya ne pe n yi deydey kui wo.» ");
INSERT INTO xrb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pyar n maha kaplãŋ nkãy tɔ̃r pe ye, nkãy syi ke ga waha pe ta, pe n Yesu kãnyĩĩ draha fla yãã, u ntãŋ n dye pe tãy u kãnde wãgbe wĩĩ n maha tãy pe ye. Pyar naa pe yar ma yee: «-Ye ye wãsyayaha kãnde gbe! Mpãy pe sẽ Yãhã cã ye, ye ma n naa n yãr poo kãnde wo ye!» ");
INSERT INTO xrb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pe laam wo, mpãy pe yɛr Pyar kaplãŋ kur ye, pe ba syar. Pe n sya pe n pe tãã yi loho wo Yesu myaha na. Koo per, mpãy pe Yesu kãnde yãã cĩĩnde, ma pe ya le taha u kãndeyãrfa na, pe pye nawee- naha yĩĩbua. ");
INSERT INTO xrb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pe nafãm mii kur byɛ, pe naa pe ya yaha, ma naa ndityuhu cre Yesu tẽnlɛhɛ kaklaha ye. Pe ba pe yĩŋ wũhũ wãã le, ma maha sya, ma Yesu wãku cãã dir syi wãã naa n di pe ya ne, ma naa pe ya laam too u wãku wĩĩ na. Pe maha naa pe ya wãã, ma naa Yãhã nar, ma maha naa ke sey. ");
INSERT INTO xrb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pe Yesu tẽnlɛhɛ naa laanwɔ wũhũ pye busãã tesẽ yɛ̃kã wũhũ ne. Pe nawee- naa koo ngĩĩ byɛ yãã, ma sya naa n fya. ");
INSERT INTO xrb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pe Yesu kãndeyãrfa byɛ ba wãã le, ma pe koho wãn ta te n nii nanihi wãn. ");
INSERT INTO xrb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pe maha naa pe tar par pe klɛ ne ma suhu pe koho wãn ne, ma naa n pai pe war ne, pe byɛ n naa pe la pe ya kẽ pe gbãhã wuhu na. ");
INSERT INTO xrb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Plii wuhu na, pe naa pe ya wãã Yãhã kangbãŋ wo. Pe naa n di pe ya ye pe klɛ wo, ma naa pe ya laam too Yesu wãku wĩĩ na. Pe naa n di nuhu ne, pe sẽ pe kai- tyɔ̃r naa n pye ye. ");
INSERT INTO xrb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pe naa Yãhã sey, pe wĩĩ naa n tãy nawee- byɛ ye. Mpãy pe naa Yesu wĩĩ sya ma naa u ta pe Syayahafua, u Yĩŋfua poo le naa n taha Yesu kãndeyãrfalɛ na plii byɛ. ");
INSERT INTO xrb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Per gaa yaiyĩn tratra, Pyar ye naa n gaha pe syãm Nsãn ne yaiyĩn Yãhã narsaha wo Yãhã kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ke Yãhã kangbãŋ kapahayɛ̃ neŋ gaa pye, pe naa n yee kapahayɛ̃yũhũ. Tãnkahafua waa pye, tuu naa n nii koo kapahayɛ̃ na. U ba see ke dyaŋ. Plii wuhu na, pe u gbe ga naa n ta ke fla na, u n naa war nar nawee- ye, nawee- mpãy pe naa n dye koo kapahayɛ̃ ne ke Yãhã kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pyar ye n ba nɔ pe syãm Nsãn ne ke kapahayɛ̃ na, ma yee poo ga dye, u tãnkahafua n pe yãã ma pe nar. ");
INSERT INTO xrb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pyar ye n nii u waha n yãŋ pe syãm Nsãn ne. Pyar n ba u pye: Naa wo yãŋ! ");
INSERT INTO xrb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","U dya n nii pe kihi n yãŋ, u laam wo, a pe ma pe ga woo kẽ war ne. ");
INSERT INTO xrb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pyar n u pye: War pua nen gɛ wee ra ye. Ngii ke ma ra ye tẽ ga ma kẽ, ke nge: Nasarɛtefa Yesu myaha na, yir naa n yãr! ");
INSERT INTO xrb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Loo na, Pyar n u yigi koho na, ma u ta u n yir. U dya tãnkaha n ta tɛr sãhã u ye, te yĩnyũhũ byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","U n fẽŋ yir, ma tãhã yɛr u trɛ na, laa wee ye, ma nii n yãr. U n dye Pyar ye ne pe syãm Nsãn ne ke Yãhã kangbãŋ wo, ma yãr n tay, ma kur n ye, ma nii Yãhã sey. ");
INSERT INTO xrb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ke Yãhã kangbãŋ nabua n u yãã tuu n yãr ma nii Yãhã sey. ");
INSERT INTO xrb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pe n u yãŋ cã, ma cã woo kẽ u tãnkahafua wii ne tuu nii naa n nar ke Yãhã kangbãŋ kapahayɛ̃yũhũ fla na. Pe u yãã ke dyaŋ, le n pe fe gbe, ma maha kacãn kua pe na. ");
INSERT INTO xrb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","U dya tuu kãhã yir, ma Pyar ye taha naa n naha pe syãm Nsãn ne, wãcɛr wee pe na ye, le n kacãn faha nawee- mpãy byɛ kẽ pe pye ke Yãhã kangbãŋ laam wo. Pe n fã taha ba pe na Yãhã kangbãŋ laankɔngbãŋ gaa flãhã tãy, pe naa n yee Salmuu laankɔŋ. ");
INSERT INTO xrb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pyar tuu yãã ke dyaŋ, u n pe nawee- pye ma yee: «Yiisrɛfa, nwa ta u dya wãkãhãyir wĩĩ n yɛ̃ kã ye na? Nwa ta ye n nii wo yãŋ mii wii koho fãnga wĩĩ laa dyaŋ le waha yia, ma u dya kãhã yir? Laa, ye le ga la ma yee, wo wãlaha wĩĩ loo kẽ Yãhã kãnde wo, le waha u kãhã yir? ");
INSERT INTO xrb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Faalefa Brama ye Yãhã, Yisyake ne, Dyakuba ne, wo wãlɛ byɛ ne, koo kẽ ke ke tẽntẽle Yesu myaha kuã yir. Woo Yesu kẽ, tee yigi ga le nangbãy koho wo, ma sya ka u ne fãngafua Pilati fla na. Pilati yee, woo ga u miy yaha, ye n sye. ");
INSERT INTO xrb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Woo wii tuu ba sroŋ, u kai- maha laha, ye u wãmiyaha wĩĩ sye, ma dur ma u Pilati ta, u n naboofua waa yi miy yaha. ");
INSERT INTO xrb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yesu wii tuu pa cĩĩnde yrã ne, yii kẽ tee u boo koo syi. Yãhã u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. Wo byɛ loo yãã yĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yesu wãta Yatɛr, koo kẽ ke ta, Yesu fãnga n ta u tãnkahafua n fãnga yãã ma yir. Ye byɛ u cã laha, u nwo, tee n yãŋ nwo. Yesu wãta Yatɛr, loo le u ta u n jaa ma nii korkor. Ye byɛ loo yãã, ma cã cĩĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","N -sẽ cã wo nna, yii ye yĩŋfa ne, tee nde pye Yesu na, ye sẽ le war ye. ");
INSERT INTO xrb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lii Yãhã ke bii tɔ̃r yaha pe faale Yãhã kaplãŋ tɔ̃rfa yɛ̃ ne ma yee, koo Yĩndefua ga ba kayĩhĩ yãã, loo ne le pye nde. ");
INSERT INTO xrb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","-Tee -sẽ le sya ye cã ye kapee- sẽ yɔ̃ ye, tee ke wãpyeŋ miy yaha, tee ye yĩntar sroŋ Yãhã kuɛ ye, ke n ye kapee- yee laha kãã ye na gbɛgbɛ. ");
INSERT INTO xrb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yãhã -sẽ ga tefay tege ye na. Ke ga maha ke Yĩndefua nɔ wãã ye kẽ, wii ke bii yãŋ yi ye myaha na, woo kẽ Yesu Crise ne. ");
INSERT INTO xrb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yagaa woo, Yesu ma yãhãyĩŋ na. U yai u kuee ke fla na le yale n sya ba nɔ, yaliile Yãhã ga ba ke kai- byɛ yĩntaha wã klaha. Faale Yãhã kaplãŋ tɔ̃rfa mpãy bii loo nde cãã pãã yaha. ");
INSERT INTO xrb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Wo faale wãdyaha Musa gɛ bii yee: ‹Ye Yĩŋfua Yãhã ga ba ta syi Yãhã kaplãŋ tɔ̃rfua waa nɔ wãã ye ye. U ga ba nii ye ter, ye ba naa n luhu nkãy byɛ ye tuu ga ba tɔ̃r naa ye yar. ");
INSERT INTO xrb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wii ma ba yee, u sẽ n luhu woo Yãhã kaplãŋ tɔ̃rfa nwo ye ye, u ga tɔ̃r yi kãã Yãhã kãndefa nawee- wo, tuu gbã yãã le na.› ");
INSERT INTO xrb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pyar n maha yee: Ma gbe Samuyɛl na, Yãhã kaplãŋ tɔ̃rfa mpãy pe taha pe ya na, pe byɛ naa too plii nde wĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yãhã ke lii pãã pe Yãhã kaplãŋ tɔ̃rfa yɛ̃ ne, loo nde ma ye wĩĩ. Tesẽ Yãhã bii yɛ̃ tɛr Brama ye ma yee: ‹Kãntrahafa byɛ ga kaa wãtaha yãã pe ya na ra koho wo ma kur kuɛ pii kãmay na.› Loo nde maha ma ye wĩĩ. ");
INSERT INTO xrb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Loo ne Yãhã n ke tẽntẽfua yi, ma u nɔ wãã yii poo kẽ, ma yee u ba kaa taha ye na, u ye ta ye n ye kapee- wãpyeŋ miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pyar ye pye kapãn na nantãŋ ke Yãhã kangbãŋ wo pe syãm Nsãn ne nawee- ye. Yãhã yũndefa n ba dye, Yãhã kangbãŋ sẽŋfa yĩŋfua ne, ma suhu mpãy ter ne pe naa yee Sadusyɛ̃. ");
INSERT INTO xrb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pyar ye naa nawee- klaha, ma maha naa Yesu wĩĩ pãã tuu yir gbã wo, ma dur ba yrãŋ na gbaafa ye. Loo na nawee- ga waha cã pe yee, nakur byɛ ga ba yir gbã wo. Pe kaplãŋ ngĩĩ naa pe Sadusyɛ̃ laam war. ");
INSERT INTO xrb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pe n Pyar ye yigi Nsãn ne. Yai ke ba kua wa, pe n pe tã nwompihi wo, ma yĩŋsyii sẽŋ. ");
INSERT INTO xrb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Le -sẽ nde, mpãy pe ba ke Yãhã kaplãŋ luhu ma yɛr le wĩĩ na, pe ba nihi. Pe Yesu kãndeyãrfa wo, pe naam pye nawee- nyersĩĩ yĩĩbua. ");
INSERT INTO xrb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Koo yĩŋsyii wo, Yiifee- yahaseefa, Yiifee- wãlɛ ne, ma suhu Yãhã kaiyarfa ne, pe n pe ya wãã Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pe laam wo faale Yãhã yũndefa yĩŋfua Yana pye, yagaa wũũ Kayifu ne, Nsãn ne, Lesyããnder ne ma suhu u Yãhã yũndefa yĩŋfua kahafa ne. ");
INSERT INTO xrb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pe n Pyar ye le pe syãm Nsãn ne pe ya telai wo, ma pe yey ma yee: «Ye waha yia yoo fãnga ne ma u dya kãhã yir? Ye u kãhã yir yoo myaha fãnga ne?» ");
INSERT INTO xrb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pyar laam ba yĩĩ Yãhã Yrã Fãnga ne, u n pe pye ma yee: «Yiifee- klo yĩŋfa, Yiifee- wãlɛ ne, ");
INSERT INTO xrb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","pe mii pe nii wo yey nanga kayĩĩ wãpyeŋ ne tãnkahafua kẽ ma yee, le pye mii u n waha kãhã yir? ");
INSERT INTO xrb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ye yai loo nde wãcãŋ ne, Yiisrɛfa kur byɛ ne: U tãnkahafua tuu jaa, ma sya n yãr ye yahasee ye nwo korkor, Nasarɛtefa Yesu fãnga kẽ, ke u kãhã yir. Yesu wii ree kuey mar boo trã na, Yãhã u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. U tãnkahafua jaa woo Yesu myaha kãmay na. ");
INSERT INTO xrb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu wĩĩ ne, le pãã yaha Yãhã sabangbãŋ wo ma yee: ‹Ntẽmblaha gii pe nwonfããfa ba ke sye yaha, Yãhã ke gbe ma ke ta, ke n dur yĩŋ yãã ke nwonfãã na.› ");
INSERT INTO xrb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nawee ga waha sya yaha Yesu ya myaha ne; driyɛ̃ kur byɛ laam wo, Yãhã sẽ waa ter yãŋ yi yãã wii tuu ga waha nawee ta, u n sya yaha mii woo ya sẽ kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Le kapãn yahaseefa pe yãã Pyar nii n pãã laanyĩn ne, u kaplãŋ n maha n sroŋ, le n yɛ̃ gbãã pe na. Pyar ye tee pye Nsãn ne, pe sẽ pye nangbãm ye, pe sẽ ba saba cã ga yaha ye ye. Le maha ba yãŋ naa n cã pe na ma yee, pe pye Yesu kãnyãrwai. ");
INSERT INTO xrb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pe yĩnde maha pye u tãnkahafua na tuu jaa, ma yir yɛr pe tãy, pe yahaseefa n nii, pe saa waha laa gɛ wãã sya ye. ");
INSERT INTO xrb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Loo na, pe n pe yigi yi kãã ke kasãhã nwoŋ wo, ma dur nii pe ya yey ");
INSERT INTO xrb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ma yee: «Nwa roo ga waha pye naam mii na? Yurusalɛmfa byɛ tee mii, pe pe laanwɔ wĩĩ nde cã laha, le n nii wo saa waha le kai ye. ");
INSERT INTO xrb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Waʼa -sẽ cã ma yee, wii ga ta le ma n cããŋ dye ga yahasee ye, nawee- byɛ n yi le cãŋ na ye, wo yai wo yĩntaha yrãhã pe na, -too sã waha pe na, wo pe tã Yesu wĩĩ wãpãã na nawee- ye.» ");
INSERT INTO xrb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pe n pe dur yee dye ba, maa sã waha pe na ma yee, a pe ma syi naa Yesu wũhũ klaha nawee- ye ye, tesẽ u wĩĩ laa ma n yi yãã pe yɛ̃ wo nantãŋ ye! ");
INSERT INTO xrb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pyar ye n -sẽ pe pye pe syãm Nsãn ne ma yee: «Yii gɛ, -ye yãŋ le yãŋ le laam wo, lii loo gɛ le ga yai Yãhã ye: Wo naa n luhu yii ye, -too tyii Yãhã wĩĩ na laa, wo yai wo naa n luhu Yãhã ye, -too tyii yii wĩĩ na? ");
INSERT INTO xrb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wii poo na, wo saa waha ye wĩĩ sya wo loo tɛr yahasee ye, -too tyii Yĩŋfua Yãhã wũhũ nkãy na too luhu, ma maha ke yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pe kasãhã yahaseefa n maha yĩntaha yrãhã pe na, ma sã waha pe na ma cã pe miy yaha. Pe sẽ ba wãpee laa yãã pe wĩĩ na car gɛ, ma ga waha pe pẽn ye. Ke fla gbenteefa byɛ tee naa Yãhã sey u tãnkahafua wãjaa wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","U dya wii tuu -sẽ ba ke laanwɔ wãjaa jaa, u pye dyɛ- gbeesĩĩ, tahar ne. ");
INSERT INTO xrb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pe Pyar ye miy yaha wa pe syãm Nsãn ne, pe n ka pe nampyeŋ- fla na, maa ke kai- tɔ̃r yar pe na, kai- nkãy Yãhã yũndefa yĩŋfa naa n pãã pe ye ma suhu Yiifee- wãlɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yesu kãndeyãrfa pe kaplãŋ ngĩĩ luhu wa, pe n yĩmbui wãã le, ma Yãhã nar ma yee: «Yĩŋfua Yãhã, mboo kẽ raa yãhãyĩŋ tãhã kãntraha ne, muhulangbãŋ ne, tesẽ wãn tii byɛ ne te ma te laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wo faale wãdyaha Dawide wii u ma ma tẽntẽle, mboo kẽ, taa le pãã woo yɛ̃ wo Yãhã Yrã kãmay na ma yee: ‹Nwa ta, mpãy pe wee Yiifee- ye, pe n yataŋ ta pe ya na, ma nii n wãã ma ne? Nwa ta pe n maha yĩmbui wãã le, ma nii Yãhã wãtoo wĩĩ kɛ wam wo? ");
INSERT INTO xrb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kãntraha fãngafa yɛr naan wãmiy na Yãhã na. Kãntraha yĩŋfa bya wɔ toho Yĩŋfua Yãhã na ke Yĩndefua ne.› ");
INSERT INTO xrb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tesẽ le cĩĩnde, loo ne le n pye nanga nge na, wo klo nde laam wo! Yĩŋfua Yɛrɔte tesẽ fãngafua Pɔ̃syi Pilati ne, tesẽ Wɔrmefa byɛ ne, tesẽ Yiifee- byɛ ne, poo mii byɛ, pe wɔ toho ma Dya Yesu na, woo wii u ma ma tẽntẽle. ");
INSERT INTO xrb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ma laam wĩĩ lii taa bii cãã pãã yaha ma fãnga kãmay na, loo ne pe n pye yagaa. ");
INSERT INTO xrb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yĩŋfua, naa n yãŋ, pe pee tã nii wo na yagaa. Wo ta wo laam n tege nii tee nen wo, wo n waha naa ma kapãn pãã laanyĩn ne. ");
INSERT INTO xrb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ma fãnga wãã wo kẽ, wo n waha naa nawee- jaa ma kãmay na, tesẽ wo n waha naa laanwɔ wũhũ pye, tesẽ yɛ̃kã wũhũ ne Yesu myaha ne, woo wii taa yãŋ yi u n nii ma tẽntẽyɔ̃.» ");
INSERT INTO xrb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pe Yãhã nar wa, teelii fla pe ba pe ya wãã ta, ke fla n sege. Yãhã Yrã n maha pe laam yĩĩ, ma fãnga gaa taha pe na, pe laam n tege nii tee nen wo, pe n nii Yãhã kapãn pãã laanyĩn ne nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu kãndeyãrfa byɛ pye yĩmbui nen na laantee nen ne. Pe laam wo, waa sẽ naa u koho wãn yigi u ya ya ye, pe naa re ta te n naa n nii pe nanihi wãn. ");
INSERT INTO xrb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yãhã fãnga pye pe Yesu tẽnlɛhɛ kaplãŋ na, pe naa Yesu wãyir wĩĩ pãã gbã wo nawee- ye, mii pe yĩnde le yãã mii. Yãhã n -sẽ naa kaa taha pe na yaryar. ");
INSERT INTO xrb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pe ba pe koho wãn ta nanihi wãn, pe laam wo ngaa sẽ naa n waha waa na ye. Tarfa naa pe tar par, klɛfa naa pe klɛ par. ");
INSERT INTO xrb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Pe byɛ naa n pai poo war mii byɛ ne, ma ba naa n wãã pe Yesu tẽnlɛhɛ kẽ, pe n naa pe sya, ma pe la naa n cããŋ Yesu kãndeyãrfa byɛ nsoho wo gbãhã wuhu na. ");
INSERT INTO xrb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mpãy pe koho wãn kẽ ke syi, pe laam wo dya waa pye pe naa n yee Yosɛfe, Lewi kur kuɛ puee waa. U naa n yi teelaa wo, pe n yee Syiper, kãntraha gaa kẽ muhulangbãŋ ke gbey le. Pe Yesu tẽnlɛhɛ ba yasey myaha taha u Yosɛfe na, ma naa u yee Barnabaase; ke myaha yĩntaha kẽ, wii u laantor le nawee- laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Woo dya nwo, u ba u tar raa par, ma pa tãŋ pe war byɛ ne, maa wãã pe Yesu tẽnlɛhɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Dya waa -sẽ pye Yesu kãndeyãrfa ne u myaha Nanayase, u cɔɔ myaha Safra. Poo mii ba pe myaha tar raa par. Pe n yĩmbui wãã le pe syãm u cɔɔ ne, ma war mpãy cɛr yi ta pe ya tãy. War mpãy pe kuee, Nanayase n poo gbe, maa wãã pe Yesu tẽnlɛhɛ kẽ, ma yee poo tar war byɛ me. ");
INSERT INTO xrb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pyar n u pye ma yee: «Nanayase, ma pye mii ma ta Setane n waha yia ma na? Taa sya war mpãy cɛr yi ma tar war na, nwa ta ma n ba kawar fua Yãhã Yrã ye ma yee, pe war byɛ me? ");
INSERT INTO xrb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ma ntraŋ kla, ma kla sẽ na? Nanayase, waa la tuu te wãpar wĩĩ le ma laam wo? Taa sya maha te par wa, pe war, ma wãm sẽ na, lii ma ne yai ma ye, ma naa n pye. Ma -sẽ pye mii ma waha kapee- nde syi ga yigi ma laam wo, ma yee pe war byɛ me? Kawar nde raa fua nde, ma sẽ re fua nawee- ye ye, ma re fua Yãhã Yrã ye.» ");
INSERT INTO xrb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nanayase n kaplãŋ ngĩĩ luhu ma too, ma ku u kuãŋ ne. Mpãy pe pye ma naa n luhu, pe n sroŋ fya. ");
INSERT INTO xrb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Naanfãm mpãy pye ke fla na, pe n yir ma u maha tã, ma u gbe ga tugu le. ");
INSERT INTO xrb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","U Nanayase cɔɔ sẽ pye kai- ngĩĩ pyeyale wo ye. Lɛr tãã syi n tɛr, u n cã ba dye. U sẽ ba cã lii pye ye. ");
INSERT INTO xrb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pyar n pãã u ne ma yee: «Ma puai yee, tee ye tar par yɛ̃ nge na, cĩĩnde la?» U n yee: «Ãwã, koo yɛ̃ kẽ.» ");
INSERT INTO xrb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Loo na, Pyar n u pye ma yee: «Mboo, ma puai ne, ye pye mii ma yĩmbui wãã le ma yee, yaa Yãhã Yrã yɛ̃ yigi yãŋ? Yãŋ, mpãy pe ga ma puai tugu le, pe mii kapahayɛ̃ na, pe dur ba wa, pe n pai ma bya gbe tɛr.» ");
INSERT INTO xrb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Le yalebya wo, u cɔɔ n too u Yesu tẽnlɛhɛ yaha ye ma ku. Pe naanfãm n dye ma yãã u ku. Pe n u gbe ga tugu le u puai tãy. ");
INSERT INTO xrb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Mpãy pe pye ke fla na, tesẽ mpãy ne pe ba le luhu kur kuɛ ye, pe byɛ n sroŋ fya. ");
INSERT INTO xrb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pe Yesu tẽnlɛhɛ naa laanwɔ wũhũ busãã pye tesẽ yɛ̃kã wũhũ ne le klofa yĩnde na. Pe Yesu kãndeyãrfa ba pe ya wãã naa n ta Yãhã kangbãŋ laankɔngbãŋ nge flãhã tãy, laankɔŋ gii pe naa n yee Salmuu laankɔŋ. ");
INSERT INTO xrb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Plii wuhu na, nafãm mpãy naa Yesu ta pe Yatɛr, naam tesẽ ca ne, ma ba pe ya le naa n taha pe Yesu kãndeyãrfa na, pe n naa n syar. Mpãy pe sẽ ba Yesu ta wa pe Yatɛr ye, pe sẽ sɛr naa pe ya wlãhã pe ne ye. Nawee- -sẽ naa pe Yesu kãndeyãrfa sey. ");
INSERT INTO xrb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pe Yesu tẽnlɛhɛ pe naa laanwɔ wũhũ pye yɛ̃kã wũhũ ne, loo nde n ta, nawee- n sya nii pe yanfa gbe ba naa n ta kãnde wo kasãy wãn na, ma yee Pyar ma ba n tɛr, u yirfua yĩm n waha paha tã mpãy na. ");
INSERT INTO xrb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nabuar raa naa n yir Yurusalɛm kãnkãy kui wo, ma naa n pai yanfa ne ma suhu nawee- mpãy ne, sãndãpee naa pe fãy. Pe byɛ naa n jaa. ");
INSERT INTO xrb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pe Yesu tẽnlɛhɛ wĩĩ naa laanyar yigi u Yãhã yũndefa yĩŋfua kẽ tesẽ mpãy ne pe naa n taha u na, poo me pe Sadusyɛ̃ ne. ");
INSERT INTO xrb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pe n yir ma Yesu tẽnlɛhɛ yigi ga le nanihi nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yĩmper n wɔ, yãhãyĩŋ tẽnlɛhɛ waa n pa, maa ke nwompihi nwonyɛ̃ yãr pe Yesu tẽnlɛhɛ na, pe n yi, u n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«-Ye ka Yãhã kangbãŋ wo, ye ga naa nawee- klaha Yesu kãnfuɛ̃ wĩĩ ne, lii le ga waha ta, nawee n sukũhũ yãã.» ");
INSERT INTO xrb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pe Yesu tẽnlɛhɛ n luhu u yãhãyĩŋ tẽnlɛhɛ ye, ma yir ga dye sukũhũntãy pẽmpẽm na Yãhã kangbãŋ wo, ma nii nawee- klaha. U Yãhã yũndefa yĩŋfua -sẽ nwo, yĩŋ ke syii wa, woo tesẽ mpãy ne pe pye u kur ye, pe n Yiifee- wãlɛ yee ba tesẽ pe kaplãŋ cɛrfa ne, pe n pe ya wãã Yesu tẽnlɛhɛ wĩĩ na. Loo kur ye, pe n Yãhã kangbãŋ sẽŋfa mpãy lɛhɛ wãã, pe ga pe Yesu tẽnlɛhɛ yi ke nwompihi wo, pe pa pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pe n ka ke nwompihi wo, ma ga pe Yesu tẽnlɛhɛ fla yãã wãwaha. Pe n dur maa le tɔ̃r pe yawãhãfa ye ");
INSERT INTO xrb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ma yee: «Wo ga ke nwompihi yãã te nwonyɛ̃r ne te sroŋ gbãã tã nii te ya kai na, pe nwompihi sẽŋfa ne pe yɛr ga pe yɛrsar wo te yɛ̃r na. Too te nwonyɛ̃r yãr, wo sẽ -sẽ waa yãã te laam wo ye.» ");
INSERT INTO xrb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","U Yãhã kangbãŋ sẽŋfa yĩŋfua tesẽ pe Yãhã yũndefa yĩŋfa ne, pe nde luhu, pe ga lii pãã pe Yesu tẽnlɛhɛ wãplaha wĩĩ na, pe sẽ le cã ye. Pe n nii pe ya yey ma yee, ncã nde n gaha yi lii na laa? ");
INSERT INTO xrb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Waa ter n sur ba dye ma pe pye: «-Ye yãŋ! Naam mpãy tee le nwompihi wo, pe ma Yãhã kangbãŋ wo pe nii nawee- klaha.» ");
INSERT INTO xrb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pe Yãhã kangbãŋ sẽŋfa n ka pe yĩŋfua ne, pe n ga pe Yesu tẽnlɛhɛ yigi. Pe -sẽ ba fya, ma yee naweetee- ga pe miy ntẽmbar ne. Loo n ta, pe sẽ sya ma fãnga yar pe na ye. ");
INSERT INTO xrb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pe n pa pe ne pe kaplãŋ cɛrfa yahasee ye, u Yãhã yũndefa yĩŋfua n nii pe yey ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Wo sẽ ba sã waha la ye na, tee ma syi naa nawee- klaha dya nwo myaha ne ye? Le maha yigi mii ye n ye kaklaha nge ta, ke n cããŋ Yurusalɛm byɛ wo, ma maha n kɛ, yii ga u dya wãboo wĩĩ taha ta wo yĩŋ na?» ");
INSERT INTO xrb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pyar tesẽ u Yesu tẽnlɛhɛwai ne pe n yee: «Wo yai wo naa Yãhã laam wĩĩ loo pye, -too tyii nawee- laam wũhũ na. ");
INSERT INTO xrb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yii kẽ, tee u Yesu kuey mar boo trã na. Wo wãlɛ Yãhã -sẽ u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye, ");
INSERT INTO xrb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ma u kuã yir ta ke kãndigi koho kuɛ ye, ma u ta u n nii Kaiyahaseefua, ma maha nii Syayahafua. Woo kãmay na Yiisrɛfa ga waha le sya pe cã pe kapee- sẽ yɔ̃ ye, pe ke wãpyeŋ miy yaha. Loo na pe kapee- ga yee laha kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wo yĩnde taha koo ngĩĩ na. Wo nii wo saa waha ke yaha le ye, wii tesẽ le Yãhã Yrã ne, Yãhã Yrã lii Yãhã le wãã mpãy kẽ pe n luhu ke ye.» ");
INSERT INTO xrb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pe kaplãŋ cɛrfa pe kaplãŋ ngĩĩ luhu, ncafũhũ n pe yigi, pe n nii pe Yesu tẽnlɛhɛ wãboo kɛ. ");
INSERT INTO xrb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pe laam wo, Yãhã kaiyarfua waa -sẽ pye, pe naa n yee Kamayɛl. U pye Farisyɛ̃, u wĩĩ naa n tãy klofa byɛ ye. Woo n yir yɛr pe kaplãŋ cɛrfa telai wo, ma ta pe n pe Yesu tẽnlɛhɛ yigi, ma yi ga nkur ye pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Loo na, u n pe yawãhãfa pye: «Yiisrɛfa, heii! -Ye yii yigi naam mii ne! ");
INSERT INTO xrb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ye sẽ yãã, le sẽ ma- sye tɛr ye, Teedasu sẽ ba yir la, ma u ya ta naweeyɔ̃ waa. Nawee- yĩĩsyãm n sya yir taha u na, ma n luhu u ye. Loo kur ye, pe n ba u boo, pe nawee- yĩĩsyãm n fã cããŋ. Kai lii tuu ba ga yigi, le sẽ too la? ");
INSERT INTO xrb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Woo kur ye, Galɛlɛ naa waa pye pe naa n yee Yuda. U n ba yir u ya ndoŋ nayrũhũ cãã na. Nabuar n yir taha u bya na. Loo kur ye, pe sẽ u bya boo la, mpãy pe ba taha u na, pe n cããŋ. Kai lii tuu ba ga yigi, le sẽ too la? ");
INSERT INTO xrb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yagaa wĩĩ nde na, n ga ye yar laa ne: Ye tyii mii na pe n naa n pye, yaʼa syi naa pe yãŋ ye. Le ma pye naweetee laam wĩĩ ne pe yigi, ma nii tẽn nde tẽ, le ga ba klaha-. ");
INSERT INTO xrb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Le ma -sẽ pye Yãhã laam wĩĩ ne pe yigi cĩĩnde, -ye cã ye yee, ye saa waha le klaha- ye. Loo na, -ye yii yigi, le ma syi le ba nii mii Yãhã gɛ kẽ tee n wãã ke ne ye!» ");
INSERT INTO xrb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pe kaplãŋ cɛrfa n u Kamayɛl yɛ̃ yor sya. Pe n pe Yesu tẽnlɛhɛ yee dur ba, ma ba ta pe n pe gbã. Pe n maha sã waha pe na, a pe ma syi Yesu wĩĩ laa n maha yi yãã pe yɛ̃ wo ye. Loo na, pe n cã pe miy yaha. ");
INSERT INTO xrb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pe Yesu tẽnlɛhɛ n yi pe yawãhãfa telai wo ma tɛr. Yãhã ke pe yãŋ yi pe n wãfãy yãã Yesu myaha wĩĩ na, loo nde n nuhu yigi pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Loo kur ye, pe -sẽ maha naa nawee- klaha plii byɛ, ma maha naa le kapãyĩĩ wĩĩ pãã pe ye, kapãyĩĩ lii le u Yãhã Yĩndefua Crise wĩĩ pãã. Pe naa koo pye ke Yãhã kangbãŋ laam wo tesẽ pe klɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Koo cãã na, Yesu kãndeyãrfa naa n syar. Pe laam wo Yiifee- terfa mpãy pe naa jrɛke yor pãã, pe n pe ya tẽ pe klo Yiifee- na, ma le kuãn ma yee, a plii byɛ dir layale ma nɔ, pe wee pe poo calangusyam gbihi n la ye. ");
INSERT INTO xrb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Loo na, pe Yesu tẽnlɛhɛ sẽnsye syãm n ke fla Yesu kãndeyãrfa byɛ yee ba, ma pe pye ma yee: «Wii Yesu tẽnlɛhɛ, waʼa tyii Yesu kapãyĩĩ wãpãã na nawee- ye, ma taha kuee dir wĩĩ ya na, le sẽ yɔ̃ ye. ");
INSERT INTO xrb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Wo nna, ye yai ye naam kuasĩĩ mpãy yãŋ yi ye laam wo. Mpãy pe miiyũhũ ke n yee, tesẽ Yãhã Yrã maha pe laam yĩĩ, tesẽ laantor kacãn ma pe ye. -Ye poosyifa yãŋ yi wo n pe taha dir wũhũ na. ");
INSERT INTO xrb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Loo nde ma pye ke syi wii poo na, waa waha nii yalebyɛ, wo naa n pãã Yãhã ye, too naa le Yesu kapãyĩĩ yar nawee- na.» ");
INSERT INTO xrb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ke fla Yesu kãndeyãrfa byɛ n yɛr loo nde wãpyeŋ na. Pe n Yɛtyɛn yãŋ yi. U ba Yesu sroŋ ta u Yatɛr laantee nen ne. U laam maha ba yĩĩ Yãhã Yrã ne. Pe n Filipe yãŋ yi taha woo na, ma maha Perkua yãŋ yi, Niikanuhu ne, Tyihimu ne, Parpẽna ne, ma suhu Niikluasu ne. U Niikluasu nwo naa n yi Yãtɔɔsyi wo, u ba u ya le Yiifee- kãnde wo faale na. ");
INSERT INTO xrb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pe n poo yar pe Yesu tẽnlɛhɛ na, pe n kluɛ taha pe na, ma Yãhã nar pe kẽ pe tẽn wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yãhã kapãn naa n cããŋ plii wuhu na. Yurusalɛm wo pe Yesu kãndeyãrfa n ba sroŋ syar naa n gaha. Yãhã yũndefa mpãy bya naa n sya ma naa Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yãhã ba ke laantãr ta Yɛtyɛn na, ma maha ba ke Yrã Fãnga le u laam wo, u n naa laanwɔ wũhũ pye yɛ̃kã wũhũ ne, pe klofa yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","U wĩĩ -sẽ ba sye naam mpãy ye. Poo pye Yiifee- yawãhã nwoŋ gaafa ne. Poofa mii pye yãã yãmpa faale wo, ma ba yi le wo. Mpãy pye Syirɛ̃ kãntraha wo tesẽ Lesyããndi kãntraha ne ma ba pa. Mpãy maha pye Sersyi kãntraha wo tesẽ kui nkãy ne, kãntraha gaa wo pe n yee Yasyi, ma ba pa pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pe sẽ -sẽ waha yia Yɛtyɛn na ma u pãã yigi ye. Yãhã Yrã naa laantor le u laam wo, u n naa kacãn kaplãŋ ya pãã pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Loo na, pe n naam mpãy dãã, ma pe ta pe n kawar fua taha u na ma yee: «Wo wo faale wãdyaha Musa wãpee luhu u yɛ̃ na ma suhu Yãhã bya ne.» ");
INSERT INTO xrb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pe n klofa sũũ le u na ke syi, pe Yiifee- wãlɛ ne ma suhu Yãhã kaiyarfa ne. Loo na, pe n sur dye u Yɛtyɛn na, ma u yigi ma ka u ne kaplãŋ cɛrfa yahasee ye. ");
INSERT INTO xrb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pe n maha ga pa mpãy ter ne, pe ba kawar fua taha u na. Pe n ba yee: «Naa nwo sẽ tyii wo Yãhã kangbãŋ miipihi wãyee na, ma suhu wo wãdyaha Musa kãnde ne ye, lii Yãhã le ta. ");
INSERT INTO xrb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wo luhu tuu n yee, a Nasarɛtefa Yesu ga ba Yãhã kangbãŋ traha, tuu dur u wo wãdyaha Musa kãnde yĩntaha wã klaha wo kẽ.» ");
INSERT INTO xrb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mpãy byɛ pe pye pe ba tege nii ke yawãhã nwoŋ wo, pe yĩnde pye u Yɛtyɛn na, pe n u yĩntaha yãã ke n yɛhɛ palpal yãhãyĩŋ tẽnlɛhɛ yĩntaha wãŋ syi dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yãhã yũndefa yĩŋfua n Yɛtyɛn yey ma yee: «Cĩĩnde la pe n pãã?» ");
INSERT INTO xrb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yɛtyɛn n u yɛ̃ wãã sya ma u pye: «Yii mpãy ye ma ra nampyeŋ-, ta tuhufa ne, -ye ndityuhu yaha ra ye! Ye cã ma yee, wo faale wãdyaha Brama see kãntraha nge wo pe naa n yee Otami. Pe koo kãntraha ngefa yee Syadeefa. Tuu sẽ bii yir wa u kusey nde wo ma ka Syahara wo ye, Yãhã gii koo myaha gboho tãŋ myar byɛ na, ke n bii ke ya yar u na, ");
INSERT INTO xrb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ma u pye ma yee: ‹Ma klo yãã, taa le ta yaha ma tuhufua nna ne, ma ga nii teelii wo, tẽ ga yar ma na.› ");
INSERT INTO xrb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Loo na, Brama n -sẽ yir ke Otami wo, ma ga nii klo laa wo pe naa n yee Syahara. U tuhufua pye u ne. U tuhufua tuu bii ku ke Syahara wo, Yãhã n maha u ta, u n yir ke fla na ma pa kãntraha nge wo, kii ree mii ke laam wo yagaa. ");
INSERT INTO xrb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yãhã sẽ bii teelaa wãã u kẽ kãntraha nge wo ye. Ke sẽ bii teelaa gɛ wãã u kẽ u waha mploho gɛ fãã ye, ma -sẽ bii yɛ̃ tɛr u ye, koo ga ba ke kãntraha kur byɛ wãã u kẽ, ke n nii pe wãŋ u kur byɛ ne. Koo cãã na, puee nen gɛ sẽ -sẽ pye Brama myaha na ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Loo nde kur ye, Yãhã n maha bii nde pãã u ye ma yee: ‹Ma kur ga ba ka, pe ga nii nampay kãntraha gaa wo. Koo kãntraha ngefa ga ba pe ta yãmpa, pe pe nuhu dyɛ- yĩĩsyãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Loo nde wĩĩ na, n -sẽ ga ba koo kãntraha ngefa sãhã. N ga ba ta, ma kur n dur ba kãntraha nge na nwo, pe ba naa diŋ yi ra kẽ.› ");
INSERT INTO xrb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Loo kur ye, Yãhã n naambiyãr le Brama ne, ma u pye ma yee, loo nde wĩĩ na Brama yai u wãkũũ wĩĩ koho yigi. Loo na u n bii Yisyake see, plii kuatãã wuhu u n u kũũ. Yisyake n bii lɛ dye ma Dyakuba see, ma u kũũ plii kuatãã wuhu u ya ndoŋ. Dyakuba n -sẽ u naam kicar sẽnsye syãm kũũ. Poo me, pe nii wo ter sẽnsye syãŋ ngĩĩ wãlɛ. ");
INSERT INTO xrb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Laanyar bii Dyakuba pii yigi, pe n sya pe cĩĩfua Yosɛfe yigi par yãmpuai Syiptefa ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Yãhã -sẽ pye u Yosɛfe kur ye. Ke n dye u kuɛ ye, ma u yĩŋ yi kawlaŋ wo, ma ta koo fla kãntraha kui yĩŋfua n u yee ba ta u yahasee ye. Yãhã n maha laantor le u laam wo ma u ta, u n kacãyor cã pãã u Syipte kãntraha yĩŋfua yahasee ye. U wĩĩ n sya tãy u ye. U Syipte yĩŋfua n u ta, u n nii ke kãntraha kai- kur byɛ yahasee ye u kaha bya ne. ");
INSERT INTO xrb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Loo kur ye, fãã n dye ke Syipte wo, Kanaa bya ne, pe naa wo kãntraha yee koo syi. Fɛn n gboho, ngaa sẽ yãã wo wãlɛ ye wãdi wãŋ ye. Wo faale wãdyaha Dyakuba tuu luhu, ");
INSERT INTO xrb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","a bur blokũũ ma Syipte wo, u n u pii nɔ wãã ke fla na pe n ga u bur blokũũ waa kɛ ba. ");
INSERT INTO xrb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pe n maha bii dur ga ke tɛhɛ syãŋ wuhu na, Yosɛfe n ga u yĩŋ yi pe na, pe n u yãŋ cã pe cĩĩfua. Le klo yĩŋfua bya n -sẽ u Yosɛfe nna cã. ");
INSERT INTO xrb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Loo na, Yosɛfe n kãnde wãã pe n ga u tuhufua yigi ba u fla na u nna byɛ ne. U tuhufua kaha nawee- pye gbeetãã sẽnsye nawee- bua. ");
INSERT INTO xrb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dyakuba ka koo syi Syipte wo. U n bii ku ke fla na, u pii sẽnsye syãm bya ne. ");
INSERT INTO xrb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pe pe nakur gbe ga naa n le klo nde wo pe n yee Sihisyɛm. Koo fla nge na, teelaa fla ma gbĩĩ ne ke fla na, Brama tuu bii par Amuɔr pii ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Yãhã ke bii yɛ̃ tɛr Brama ye lii ne, loo nde pyeyale le bii nɔ gbe taha, wo klofa pe pye ke Syipte wo, pe nii n syar. ");
INSERT INTO xrb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Dyɛ- buar n tɛr, yĩŋfa busãã n ku tɛr pe yai ne ke Syipte wo. Yĩŋfua waa ter n bii yir u yai ne. Woo yĩŋfua nwo cãŋ sẽ pye Yosɛfe wĩĩ laa na ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","U n wo wãlɛ byɛ ta ma nii n nuhu, ma pee tã pe na, ma sya yee pe pe pẽyãr miy yaha, pe n naa n ku, pẽyãr rii te pye naam kicar. ");
INSERT INTO xrb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Koo cãã nge kẽ, Musa tuu see yi u nayɔ̃r ne ma pye Yãhã laanfua. U nna n u yɛ̃ woo yrey tãã. ");
INSERT INTO xrb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te yrey tãã kur ye, u nna n u gbe ga miy yaha, mii u Syipte yĩŋfua bii le pãã ta mii. Ke kãntraha yĩŋfua pueesya n bii u yãã, ma u kɛ gbe, ma u yigi mii u ya koho pesey dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Koo ke ta, pe n naa Musa klaha Syiptefa kai- ne tesẽ pe kacãn ne. Tuu bii lɛ dye, u fãnga n gboho, kacãn n maha gboho u ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","U wãlɛ ke bii nɔ dyɛ- gbeesĩĩ na, Musa n le ta woo ga ka, u ga u terfa Yiisrɛfa yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","U n ga Syiptefa naa waa yãã, tuu nii poo Yiisrɛfa naa waa nuhu; u n dye u dya kuɛ ye, ma u Syipte naa boo u kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U naa n traha woo nampyeŋ- Yiisrɛfa n le cã, a woo kẽ Yãhã ke taha u pe sya yaha. Pe sẽ -sẽ le war ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Koo yĩŋsyii wo, u Musa n ga Yiisrɛfa syãm yãã, pe nii n wãã. U n yee, woo ga pe syii ma pe pye: ‹Naambiyãm, ye ma klo nen yafa. ");
INSERT INTO xrb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nwa ke -sẽ maha ye taha yii wãnuhu na.› Wii ruu -sẽ naa u nampyeŋ nuhu, u n Musa tra wãã ma u pye: ‹Yoo tuu ma ta wo yĩŋfua, ma naa wo sãhã? ");
INSERT INTO xrb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Maa ra boo la mii taa ne Syipte naa nwo boo mii niinge na?› ");
INSERT INTO xrb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa tuu kaplãŋ ngĩĩ luhu, u n fã yi ke Syipte wo ma ga kuee kãntraha gaa na pe naa n yee Madaha. Koo fla nge na, u n cɔɔ yãã, ma kicar syãm see u na. ");
INSERT INTO xrb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Dyɛ- gbeesĩĩ n tɛr. Musa pye tẽyãfũũ fla wo yãŋ gaa tãy, pe n yee Senayi. Yãhãyĩŋ tẽnlɛhɛ waa n yi Musa na, wambule laa wo, naa naa n tar le laam wo, le sẽ -sẽ naa n suhu ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Loo nde wãyãã n Musa laam wɔ. Tuu yũhũ crã ke na, woo ga gbihi yãŋ, u n luhu Yãhã yĩmbui ne le n yee: ");
INSERT INTO xrb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Ndoo kẽ, ma wãlɛ Yãhã. Ndoo kẽ, Brama ye Yãhã, Yisyake ne, Dyakuba ne.› Fyar koho wo Musa n yɛr n sege, u sẽ sɛr naa n yãŋ nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Yãhã n u pye: ‹Ma ntãy fɛr kãã, draha gii raa yɛr nge, ke ma gbɛgbɛ ma maha nii Yãhã wãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","N ta nna wãfãy yãã Syipte wo, n luhu pe wãsĩĩ ne, ta n tege pe wãsyayaha yĩmbui ne. Loo ne ta n yee, n ga ma lɛhɛ Syipte wo.› ");
INSERT INTO xrb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Woo Musa wii pe Yiisrɛfa pe bii sye yaha, ma bii u pye ma yee: ‹Yoo tuu ma ta wo yĩŋfua, ma naa wo sãhã?› Woo Musa cɛŋ ya kẽ, Yãhã u nɔ wãã pe kẽ syayahafua, ma maha u ta pe yĩŋfua. Yãhã n ke yãhãyĩŋ tẽnlɛhɛ waa lɛhɛ wãã Musa ye loo nde wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Woo Musa kẽ tuu laanwɔ wũhũ pye yɛ̃kã wũhũ ne Syipte laam wo, ma sya waha Yiisrɛfa yigi yi ke laam wo. U maha laanwɔ wũhũ pye yɛ̃kã wũhũ ne ke muhulangbãyãhã telai wo ma suhu le tẽyãfũũ klo ne, koo fla gii pe dyɛ- gbeesĩĩ pye. ");
INSERT INTO xrb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Woo Musa kẽ tuu maha bii Yiisrɛfa pye ma yee: ‹Yãhã ga ba ke Yãhã kaplãŋ tɔ̃rfua waa nɔ wãã ye kẽ mii ra dyaŋ. U ga ba yi ye ter laam wo.› ");
INSERT INTO xrb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Pe Yiisrɛfa pe bii pe ya wãã ta tẽyãfũũ klo wo, ke yãŋ nge flãhã tãy pe n yee Senayi, woo Musa maha kẽ tuu pye wo wãlɛ ne ke fla na. Yãhãyĩŋ tẽnlɛhɛ waa naa n pãã u ne koo yãŋ yĩŋ na. Kaplãŋ nkãy ke cĩĩnde yrã wãã nawee kẽ, u yãhãyĩŋ tẽnlɛhɛ n ke yar u na, u n -sẽ pa, maa ke tɔ̃r yar wo na. ");
INSERT INTO xrb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wo wãlɛ n yee poo saa luhu u ye ye, ma u wĩĩ sye, ma pe laam wĩĩ ta ma yee, poo ga dur tɛr Syipte wo. ");
INSERT INTO xrb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pe n maha bii Yarɔ̃ pye ma yee: ‹Wãŋ gaa fãã wo kẽ ke n nii wo yãhã, wo n ke ta wo yatɛr. Musa wii tuu wo yigi yi Syipte wo, wo tee mii, wo sẽ cã lii u yãã ye.› ");
INSERT INTO xrb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Pe n naancɛŋ gaa fãã ta, ma ke tẽŋ ma nuhu di ke wĩĩ ne, koo gii pe fãã pe ya ya pe kluɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yãhã n dur yi pe kur ye, ma tyii pe na pe n nii yãhãyĩŋ wãn tẽŋ. Loo ne le yrũhũ yaha Yãhã kaplãŋ tɔ̃rfa saba wo ma yee, Yãhã yee: ‹Yiisrɛfa, tee pye u tẽyãfũũ klo wo, ke dyɛ- gbeesĩĩ ngĩĩ na, ndoo la, tee naa n tẽŋ yraha ne? Ye naa diŋ yi la ndoo kẽ? ");
INSERT INTO xrb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ye cã ndoo sẽ kẽ ye. Ye yãhã nge tee n yee Moloke, koo kẽ ree gbe naa n tay ke fai nwonge wo. U yrompua nwo pe n yee Arefaha, ye maha ba usyi pye ma u ta ye yãhã. Too wãn nde ne, tee ba fãã ma naa te tẽŋ. Loo ne, n ga ye gbe ga miy yaha teelaa wo deydey, koo fla dey Babilɔn gɛ na.› ");
INSERT INTO xrb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tẽyãfũũ klo wo, wo wãlɛ bii ke Yãhã nwonge gbihi. Kãnde lii Yãhã le ta, le wũhũ bii yrũhũ ta ntẽmbapai raa na. Too nde pye wo wãlɛ pe bii gbe le yaha ke fai nwonge wo. Musa bii ke nwonge gbihi mii Yãhã bii u yar le ne mii. Ke nwonge pye pe ye. Yãhã naa n pãã pe ne ke laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mpãy pe yir wo wãlɛ mii kur kuɛ ye, pe bya n ke Yãhã nwonge yãã ma ke gbe ma tɛr ke ne. Yosua woo ruu pye pe yĩŋ na. Yãhã ke bii yɛ̃ tɛr Brama kur ye kãntraha gii ne, Yãhã n ta pe n bii waha koo kãntraha ngefa kar wãã; poo ter mii sẽ pye Yiifee- ye. Koo Yãhã nwonge n kuee, kur mpãy ma yir pe yai ne, pe ga ke yãã. Koo syi ya, ma sya ba Dawide yai cãã dye. ");
INSERT INTO xrb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yãhã n kaa taha u Dawide na, u n -sẽ kãnde nar ke ye, woo ga kaha fãã ke kẽ, koo gii ke ma Dyakuba Yãhã. ");
INSERT INTO xrb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yãhã n sye, ma bii u dya Salmuu woo ta u n bii ke Yãhã kaha fãã . ");
INSERT INTO xrb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nwey tii nawee- pe n fãã pe kluɛ ne, Yãhã sẽ n syã te laam wo ye, koo gii ke ma ncaha ye yãhãyĩŋ na. Yãhã kaplãŋ tɔ̃rfua waa loo pãã ma yee, Yãhã yee: ");
INSERT INTO xrb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Yãhãyĩŋ kẽ ke ma ra nangbãŋ niisaha, kãntraha -sẽ ma kãnamberge dyaŋ, tẽ trɛ taha ta. Yii -sẽ ga waha koo nwoŋ fãã mii syi dyaŋ? Draha gii syi -sẽ ma, ke ga waha ra niisaha kua? ");
INSERT INTO xrb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ndoo sẽ na, tẽ too nde byɛ fãã, ke yãhãyĩŋ tesẽ ke kãntraha ne?› » ");
INSERT INTO xrb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yɛtyɛn tuu pe faalefa wĩĩ tɔ̃r yar wa pe na, u n maha le pãã pe ye ma yee: «Yii laangbãnfa mii, ye laam waha, ye sye ma ye ndityuhu gbãã tã ye saa luhu Yãhã ye ye. Ye sye, ye sẽ n luhu Yãhã Yrã ye ye. Ye ma mii ye wãlɛ dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yãhã kaplãŋ tɔ̃rfua wii woo u kuee mii, pe sẽ u nuhu ye? Mpãy pe u kasroŋfua wãpa wĩĩ pãã, pe pe boo. Yagaa u kasroŋfua tuu pa, ye u wĩĩ sye ma sya ba u boo. ");
INSERT INTO xrb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yii mpãy, Yãhã yãhãyĩŋ tẽnlɛhɛ ta, pe n le kãnde tɔ̃r yar ye na, kãnde lii Yãhã le ta, ye sẽ -sẽ le yãr ye.» ");
INSERT INTO xrb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pe kaplãŋ cɛrfa pe Yɛtyɛn kaplãŋ ngĩĩ luhu, ncafũhũ n pe yigi, pe n sya nii n sege. ");
INSERT INTO xrb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","U Yɛtyɛn woo -sẽ nwo, Yãhã Yrã Fãnga le u yĩĩ, u n yãhãyĩŋ tẽŋ yãŋ, ma Yãhã nayɔ̃r yãã, Yesu ne tuu yir yɛr ke Yãhã kãndigi koho kuɛ ye, kai- byɛ fãnga ne u ye. ");
INSERT INTO xrb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","U n yee: «-Ye luhu, n nwo, tẽ yãhãyĩŋ yãã ke yãr yaha nii. Nawee Puee yir yɛr Yãhã kãndigi koho kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pe n tẽ sya, ma ndityuhu gbãã tã, ma sur dye u Yɛtyɛn na ma u yigi. ");
INSERT INTO xrb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pe nawee- n u tyĩn ga le klo kãnkãy na, ma ga ntẽmbar ta, ma nii u miy u wãboo yĩmbui ne. Mpãy pe ba cãã u miy, pe ba pe nayrengbãy fɛr ma ta yaha dya waa kẽ pe naa n yee Sɔl, u naa te yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pe sya naa Yɛtyɛn miy ntẽmbar ne, u Yɛtyɛn woo -sẽ pye, tuu naa Yesu nar ma n yee: «Yĩŋfua Yesu, ta yrã sya!» ");
INSERT INTO xrb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Loo na, u n kãnklũy gbãã, ma tẽ sya fãnga ne ma yee: «Yĩŋfua, maʼa n tyii kapee nde na pe yĩŋ na ye!» Tuu koo kaplãŋ ngĩĩ pãã wa, u n ku. ");
INSERT INTO xrb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Koo per pe n yir Yesu kãndeyãrfa wãnuhu ne ke Yurusalɛm wo. Pe Yesu kãndeyãrfa byɛ n fã cããŋ tɛr Yudɛ kui wo, Syamari kui ne. Pe Yesu tẽnlɛhɛ poo n kuee. ");
INSERT INTO xrb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mpãy pe -sẽ naa n luhu Yãhã ye, pe n Yɛtyɛn nakugu gbe ga le, ma u gbã wĩĩ wũn. ");
INSERT INTO xrb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔl woo -sẽ pye, tuu naa kaa taha u ya fãnga na pe Yesu kãndeyãrfa wĩĩ wãpyeklaha- wĩĩ ne. U naa n tay klɛ wo, ma Yesu kãndeyãrfa fyãhã naa n yigi, naam tesẽ ca bya ne, ma ga naa pe le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mpãy pe ba fã cããŋ, pe naa n tay teebɛhɛ byɛ wo, ma naa Yesu kapãyĩĩ pãã nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipe n ka Syamari kungbãy wo, ma ga u Yãhã Yĩndefua Crise wĩĩ tɔ̃r pe nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pe nawee- pe Filipe kaplãŋ luhu, ma maha ke laanwɔ wũhũ yãã tuu n pye, pe byɛ naa ndityuhu yaha, ma naa n luhu u kaplãŋ ye kayi ne. ");
INSERT INTO xrb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sãndãpee naa n tẽ, ma tege naa n kãã nawee- busãã yĩŋ na, tãnklahafa busãã maha naa n jaa. ");
INSERT INTO xrb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Loo nde n pe klofa ta, nuhu n pe yigi. ");
INSERT INTO xrb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Le klo wo, dya waa -sẽ pye lɛ wa, pe naa u yee Syimu. Woo dya nwo pye caifua, ma naa pe Syamarifa laam wɔ kai- nkãy ne. U naa u ya yãŋ, usyi wee ye. ");
INSERT INTO xrb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ke fla nawee- byɛ, ma gbe pe kicar syĩmbir na, ma ga waa pe wãlɛ na, pe byɛ -sẽ naa nagboho ta u na cĩĩnde, ma sya naa n yee: «Dya nwo, Yãhã fãnga gɛ kẽ ke ma u ye, fãnga gii pe n yee cĩĩnde fãngangbãŋ.» ");
INSERT INTO xrb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U tee ba ma- tɛr le klo wo, ma naa pe nawee- laam wɔ u pyer ne, koo syi kẽ pe n naa u fya, ma maha naa nagboho ta u na. ");
INSERT INTO xrb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pe klofa pe -sẽ ba le kapãyĩĩ luhu Filipe yɛ̃ na, kapãyĩĩ lii le Yãhã Yai wĩĩ tɔ̃r tesẽ Yesu Crise wĩĩ ne, pe naa loo sya cĩĩnde, ma naa Yesu ta pe Yatɛr. Pe n -sẽ pe byɛ tãã naa n yi loho wo, pe naam tesẽ pe ca ne. ");
INSERT INTO xrb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Syimu bya n Yesu kapãyĩĩ sya cĩĩnde. Loo kur ye, pe n u tãã yi loho wo, u n naa n kuee Filipe tãy. Filipe naa yɛ̃kã wũhũ pye, ma maha naa laanwɔ wũhũ pye Yesu myaha ne. Syimu naa koo ngĩĩ bya yãã, ke n -sẽ naa laam wɔ u kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yesu tẽnlɛhɛ mpãy pe pye Yurusalɛm wo, pe n ba luhu, a Yesu kapãyĩĩ ma, le dye Syamari laam wo, pe n Pyar ye nɔ wãã ke fla na pe syãm Nsãn ne. ");
INSERT INTO xrb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pe syãm pe ga dye ke Syamari wo, pe n Yãhã nar pe Yesu kãndeyãrfa kẽ ma yee, Yãhã ke ta Yãhã Yrã n dye pe laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pe tee ba tãã yi wãtããyi ya loho wo Yesu myaha ne, Yãhã Yrã sẽ ba dye wa pe laam wo ye, koo syi kẽ pe n ba Yãhã nar pe kẽ loo wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Loo na, Pyar tesẽ Nsãn ne, pe n kluɛ taha pe na, Yãhã Yrã n dye pe laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Syimu tuu yãã Yãhã Yrã le dye pe Yesu kãndeyãrfa laam wo, yaliile wo Yesu tẽnlɛhɛ pe kluɛ taha pe na, u n war yi ma Pyar ye pye pe syãm Nsãn ne ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«-Ye ra bya kẽ ke syi fãnga ne ta n nii, n ma kluɛ taha wii na, Yãhã Yrã le dye ufua laam wo.» ");
INSERT INTO xrb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pyar n u yɛ̃ wãã sya ma yee: «Ma war pe ka ma ne, ma tee le wũũ, a Yãhã laantãr wĩĩ n sya ke ye wale ne. ");
INSERT INTO xrb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ma lay wee nwo ye, ma sẽ maha yai loo nde syi wãyãã ne ye, ma laam tee mii, pe wee gbɛgbɛ Yãhã ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mii dur yi kãã ma kapee nde wo, -taa Yãhã nar, ke ma sya ke ma kapee nde kua kãã ma na. Ma pye gɛ pye mii ma waha nde syi wũũ, ma sya le pãã yi. ");
INSERT INTO xrb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tẽ ma yãã mii, ngaa kapihi ma ma yĩŋ na, ma ta ma kapee- n nihi ga ta tɛr, ma ta ma saha laa kayĩĩ gɛ pye ye.» ");
INSERT INTO xrb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","U Syimu n Pyar ye pye pe syãm Nsãn ne ma yee: «Yii gɛ, -ye Yãhã nar ra kẽ, laa ma n faha ra dye nde kur ye tee pãã ye.» ");
INSERT INTO xrb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yesu tuu naa kai- nkãy pye pe n naa n yãã yĩnde ne, ma suhu nkãy ne tuu naa n pãã pe naa n luhu, Pyar ye pe loo kapãyĩĩ tɔ̃r yar wa pe nawee- ye, pe n dur tɛr Yurusalɛm wo. Kãnde wo, pe le kapãyĩĩ tɔ̃r naa n gaha Syamari kãntraha kusyĩmbɛhɛ busãã wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yãhãyĩŋ tẽnlɛhɛ waa n Filipe pye: «Ka yainsaha dar kuɛ kãndigi koho kuɛ ye. Kãnde laa ma ke kuɛ dragba wo, le n yir Yurusalɛm wo ma n gaha klo nde wo pe n yee Gbasa. Ka loo kãnde fla na.» ");
INSERT INTO xrb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipe -sẽ yãã ta tɛr yir tɛr le kãnde kuɛ ye. U n ga dya waa yãã le kãnde wo. U pye Yɛtyɔpe yahaseefua waa, ma maha pye Yɛtyɔpe yĩŋfasya war kluhu yĩŋ na. U ba ka Yurusalɛm wo Yãhã seysaha wo, ma dur naa n tɛr u niisaha wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","U pye u ba dye nii u kafãŋ wo, ma naa Yãhã kaplãŋ tɔ̃rfua Yisa kaplãŋ kal ke Yãhã sabangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yãhã Yrã n Filipe pye ma yee: «Yũhũ dye u dya kafãŋ tãy.» ");
INSERT INTO xrb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipe n fã yũhũ dye, ma luhu u Yɛtyɔpe naa tuu nii Yãhã kaplãŋ kal, nkãy Yãhã kaplãŋ tɔ̃rfua Yisa tuu yrũhũ. Filipe n u yey ma yee: «Kai- nkãy taa n kal ngĩĩ, ma ke war la?» ");
INSERT INTO xrb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","U dya n u yɛ̃ wãã sya ma yee: «N ga waha pye mii, n naa ke war, waa ma yee u wee ma nii ke yĩntaha tɔ̃r ma ra yar ye?» U n Filipe nar, u n dye nii u tãy ke kafãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yãhã kaplãŋ nkãy u naa n kal, koo kẽ ngĩĩ: «U nii mii mbua wii syi dyaŋ pe yigi n gaha boosaha wo. U nii mii mbua wii syi dyaŋ pe u yor kur, u n yaha le tete. U sẽ yɛ̃ kua ma laa gɛ pãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pe u kloŋ, dyefua sẽ yãã u kuɛ ye ye. Pe mii, pe u boo kãntraha nge na, kur wãm ga ba yir na u ye pe naa u wĩĩ pãã?» ");
INSERT INTO xrb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","U Yɛtyɔpe naa n Filipe yey ma yee: «Dya, kace ra yar, yoo wĩĩ -sẽ kẽ, u Yãhã kaplãŋ tɔ̃rfua tuu tɔ̃r loo ne? U ya koho wĩĩ laa, waa wĩĩ?» ");
INSERT INTO xrb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipe n kapãn gbe ma u Yãhã kaplãŋ tɔ̃rfua kaplãŋ ngĩĩ yĩntaha yar u dya na, ma sya ba le Yesu kapãyĩĩ tɔ̃r yar u na. ");
INSERT INTO xrb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pe naa n tɛr ke dyaŋ le kãnde wo, pe n ga nɔ loho fla gaa na. U Yɛtyɔpe naa n u pye: «Loho nge! Nwa -sẽ maha ma ke kuee ta wãtããyi na loho wo?»  ");
INSERT INTO xrb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipe n u pye: «Ke ma pye ma Yesu ta ma laam wo ma cĩĩnde Yatɛr, ma ga waha tãã yi loho wo.» U Yɛtyɔpe naa n u pye: «N le sya cĩĩnde, woo kẽ tuu ma Yãhã Dya cĩĩnde.» ");
INSERT INTO xrb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Loo kur ye, u Yɛtyɔpe naa n ta pe n ke kafãŋ yɛr. U n tege woo tesẽ Filipe ne. Pe n dye ke loho wo. Filipe n u tãã yi ke loho wo. ");
INSERT INTO xrb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pe yi ke loho wo, Yãhã Yrã Fãnga n Filipe gbe tɛr. U Yɛtyɔpe naa sẽ maha u yãã yãã nantãŋ ye, ma u kãnde sya, ma n tɛr, nuhu fla. ");
INSERT INTO xrb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipe n ga u ya yãã klo laa wo pe naa n yee Asuhute. U n nii Yesu kapãyĩĩ tɔ̃r n gaha kui wo, ma sya ga dye Syesarɛ wo. ");
INSERT INTO xrb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sɔl -sẽ nwo, u pye ma naa Yesu kãndeyãrfa kɛ wãboo ya ne. U n ba yir ma ka Yiifee- Yãhã yũndefa yĩŋfua fla na, ");
INSERT INTO xrb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","maa saba mpãy sya u ye, saba mpãy syi pe ga waha kãnde wãã u kẽ u n ka Damasu na, te Yiifee- yawãhã nwey wo. U maa nawee- mpãy yãã ke fla na, naam woo, ca woo, pe ma yee wa pe n yãr Yesu kãnde wo, u waha pe yigi, u pe pua, u pa pe ne Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","U n yir koo na, ma kãnde sya, ma n gaha ke Damasu na. Tuu ga nɔ gbe taha le klo na, u n yee woo ga yãŋ, ma yãã cãã- mpãy ter syi pe yi yãhãyĩŋ kuɛ ye, ma ba yɛhɛ u na. ");
INSERT INTO xrb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","U kadye n sege, u n laha too kãntraha na, ma luhu yĩmbui laa ne, le u pye ma yee: «Sɔl, Sɔl, n lii wãpee pye, ma n nii ra nuhu yĩntayãhã ne?» ");
INSERT INTO xrb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","U n wãã sya ma yee: «Yĩŋfua, mboo wii raa n pãã ra ne, ma myaha mii?» Le yĩmbui n u yɛ̃ wãã sya ma yee: «Ndoo Yesu kẽ taa n nuhu yĩntayãhã ne. ");
INSERT INTO xrb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mboo, yir, ma dye le klo wo. Taa yai ma lii pye, pe ga le yar ma na.» ");
INSERT INTO xrb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nawee- mpãy pe wãã naa n yãr Sɔl ne, pe byɛ ba yɛr pe sẽ sya naa laa pãã ye. Pe naa n luhu le yĩmbui gbleŋ ne, pe sẽ -sẽ naa waa yãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔl n yir, ma tãhã yɛr kãntraha na. U n yĩmpɛ yãr, u sẽ -sẽ waha ngaa yãã nantãŋ ye. Pe n u yigi koho na ma ka u ne ke Damasu na. ");
INSERT INTO xrb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U n plii tãã pye, u sẽ waha naa n yãŋ ye, u sẽ ngaa di ye, u sẽ maha ngaa wɔ ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ke Damasu wo, Yesu kãndeyãrfua waa pye, pe naa n yee Nanayase. U pye mii wãytãã dyaŋ u na, ma Yĩŋfua yãã tuu u yee ma yee: «Nanayase.» U n u yɛ̃ wãã sya ma yee: «Yĩŋfua, n nwo, n n luhu ma ye.» ");
INSERT INTO xrb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","U Yĩŋfua n u pye ma yee: «Yir yagaa, kãnde lii pe n yee kãndigi, ma loo sya, ma ka Yuda kaha wo, maa Tarsufa naa waa wĩĩ yey, pe u yee Sɔl. ");
INSERT INTO xrb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","U ma gɛ ma u nii Yãhã nar. U bya pye mii wãytãã dyaŋ u na, ma ma yãã, taa dye ga maa koho taha u na, ma yee u waha maha naa n yãŋ faale dyaŋ.» ");
INSERT INTO xrb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nanayase n loo wãã sya ma yee: «Yĩŋfua, nawee- busãã dya nwo wĩĩ tɔ̃r ra ye. Tuu Yesu kãndeyãrfa nuhu wãnuhu gii ne Yurusalɛm wo, n le luhu. ");
INSERT INTO xrb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yãhã yũndefa yĩŋfua kãnde wãã u kẽ, u pa nwo wo, u ba nawee- yigi pua, poo mpãy pe koho taha yaha Yesu na.» ");
INSERT INTO xrb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","U Yĩŋfua n -sẽ maha u pye ma yee: «Ka, n dya nwo yãŋ yi, ma yee u ta wĩĩ tɔ̃r yar driyɛ̃fa byɛ na tesẽ yĩŋfa byɛ ne tesẽ Yiisrɛfa ne. ");
INSERT INTO xrb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tuu yai u wãfãy gii fãy ta wĩĩ na, u ta, nawee- n ra wĩĩ cã, n ga u yar koo byɛ na.» ");
INSERT INTO xrb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Loo na, Nanayase n yir, ma ka Yuda kaha wo. Tuu ga dye ke kaha wo, u n kluɛ taha Sɔl na ma u pye ma yee: «Sɔl, ma ma Yesu kãndeyãrfua mii ta dyaŋ. Taa naa n pai kãnde wo, Yĩŋfua Yesu wii tuu ba yi ma na, woo u ra lɛhɛ wãã, n ba ma ta ma n waha naa n yãŋ faale dyaŋ, tẽ ma ta, Yãhã Yrã Fãnga n ma laam yĩĩ.» ");
INSERT INTO xrb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Loo yalebya wo, wãn raa n kuã kãã Sɔl yĩmpɛ na mii sawor dyaŋ, u n nii n yãŋ faale dyaŋ. U n yir, pe n u tãã yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Loo kur ye, u n di, u kadye n cã fãnga yãã. Loo kur ye, Yesu kãndeyãrfa mpãy pe pye Damasu na, Sɔl n kuee pe ne, ma faa plii raa pye, ");
INSERT INTO xrb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ma nii Yesu wĩĩ pãã nawee- ye Yiifee- yawãhã nwey wo ma yee, Yãhã Dya kẽ Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mpãy byɛ pe u kaplãŋ luhu, le n pe fe gbe, pe n nii le yey ma yee: «Dya nwo woo sẽ na, tuu naa Yesu kãndeyãrfa kɛ wãboo ne yĩntayãhã ne Yurusalɛm wo, poo mpãy pe koho taha yaha Yesu myaha na. U sẽ yir la ma pa nwo, woo n pai tee nde Yesu kãndeyãrfa yigi pua, u ga pe yi Yãhã yũndefa yĩŋfua kẽ?» ");
INSERT INTO xrb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sɔl -sẽ naa Yesu wĩĩ pãã nawee- ye. Kaa naa n taha u kaplãŋ wãlaha na tesẽ ke fãnga ne. Yiifee- mpãy pe pye Damasu na, Sɔl pe gbihi yar naa n laha Yesu wĩĩ ne ma naa pe yar, Yesu woo u ma u Yãhã Yĩndefua Crise, le n sya naa yɛ̃ gbãã pe na. ");
INSERT INTO xrb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Koo syi kẽ plii raa kur ye, Yiifee- n pãã ta poo ga Sɔl boo. ");
INSERT INTO xrb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sɔl n -sẽ loo nde yãã luhu. Le klo pye, pe ba ncaha fãã, ma le klaha tã. Nawee- naa le klo kapahayɛ̃r byɛ sẽŋ, ke yai ke yĩmper, pe ma u Sɔl yãã pe u boo. ");
INSERT INTO xrb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sɔl pye Yesu kãndeyãrfa mpãy ne nwoŋ gaa laam wo, ke ba fãã gbra le klo ncaha na. Fenaatɛr gaa -sẽ pye ke nwoŋ wo ke ba yi ke ncaha ne. Pe n yir yĩmper wo, ma u Sɔl gbe le takũy laam wo, ma namihi pua le na, ma u Sɔl yoŋ tege wãã fenaatɛr ne le klo ncaha kur kuɛ ye. Sɔl n waha wloho yi ke syi, ma fã tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔl n ga dye Yurusalɛm wo, ma yee woo ga dye wlãhã Yesu kãndeyãrfa ne. Pe byɛ -sẽ ba fya u na, pe sẽ ba le sya cĩĩnde ma yee, u wã klaha ma nii Yesu kãndeyãrfua ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yesu kãndeyãrfua wii pe naa n yee Barnabaase, woo n Sɔl yigi loo na, ma ka u ne pe Yesu tẽnlɛhɛ fla na. Sɔl tuu ba u Yĩŋfua wãã sya mii le kãnde wo, u n kaplãŋ nkãy pãã u ye, Barnabaase n loo nde tɔ̃r pe Yesu tẽnlɛhɛ ye. Sɔl tuu pye Damasu na, ma naa Yãhã kapãn pãã Yesu myaha ne pe nawee- ye laanyĩn ne, Barnabaase n maha koo bya tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Loo yale nde wo, Sɔl n cã waha u ya wlãhã pe ne. U n nii n tay ke Yurusalɛm wo, ma Yãhã kapãn pãã naa n laha Yĩŋfua myaha ne nawee- ye laanyĩn ne. ");
INSERT INTO xrb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yiifee- mpãy pe naa jrɛke yor luhu, u naa n pãã pe bya ne, ma naa kaplãŋ tyĩn pe ne. Poo -sẽ naa u wãboo kɛ. ");
INSERT INTO xrb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pe Yesu kãndeyãrfa pe loo cã, pe n Sɔl yigi ga Syesarɛ na, maa u ta u n ka Tarsu na . ");
INSERT INTO xrb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Loo na, Yesu kãndeyãrfa yawãhãfa mpãy pe pye Yudɛ wo, Galɛlɛ ne tesẽ Syamari ne, pe n cã yrĩŋ yãã. Yĩŋfua Yesu wĩĩ naa n gboho pe laam wo plii wuhu na. Pe maha naa u laam wũhũ pye yalebyɛ. Yãhã Yrã kãmay na, kaa naa n taha pe yawãhãfa wãnihi na. ");
INSERT INTO xrb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pyar naa n tay kui byɛ wo, ma naa Yesu kãndeyãrfa yãŋ. U n ba ka klo laa wo pe naa n yee Liide, Yesu kãndeyãrfa yãŋsaha wo, ");
INSERT INTO xrb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ma ga dya waa yãã le klo wo. Pe naa u yee Yɛnɛ. U dyɛ- kuatãã ba kẽ tãnkur yan ne kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pyar n u pye ma yee: «Yɛnɛ, Yesu Crise ma, u ma jaa yagaa. Yir, ma ma kasãy wãŋ gbe!» Yɛnɛ n ta tɛr yir. ");
INSERT INTO xrb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liide klofa byɛ tesẽ Sarãŋ ngbãŋfa byɛ ne, pe n loo yãã, ma pe troho wãtãhã ter wã klaha, ma nii Yĩŋfua kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Klo laa pye tũntũn, pe naa n yee Yopɛ. Cɔɔ waa pye ke fla na, u myaha Tagbihita. U pye pe Yesu kãndeyãrfa ne. Jrɛke yor wo ke Tagbihita myaha nge n yee Dɔɔkase, ke yĩntaha kẽ kafaa. U cɔɔ naa kayĩĩ pye yalebyɛ, ma maha naa koho le nawãm ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","U n ba too yan na, ma ku. Pe n u nakugu yee, ma ke gbe ga ta nwoŋ gaa laam wo gbegbaha yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pe Yesu kãndeyãrfa mpãy pe pye ke Yopɛ wo, pe ba le luhu ma yee, Pyar ma tũntũn Liide na. Pe n nawee- syãm lɛhɛ wãã u ye pe ga u yar, poo ma pe u nar, u pa poo fla na, u ma n nii kuee ye. ");
INSERT INTO xrb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pe n ga dye Pyar fla na, ma re tẽnlɛhɛ tɔ̃r u ye, u n yir wãã kũn pe ne le yalebya wo. Tuu ga dye, pe n u yigi ga ke nwoŋ laam wo gbegbaha yĩŋ na. Calangusyam mpãy pye ke fla na. Pe byɛ n ba yɛr Pyar tãy, ma nii n wũn. Dɔɔkase tuu pye yrãŋ na, ma ba nayrɛ tii gbihi, tesẽ nayrengbãy tii ne, pe n too nde gbe n yar Pyar na. ");
INSERT INTO xrb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pyar n pe nawee- byɛ ta pe n yi nwoŋ wo, u n dur ma kãnklũy gbãã kãntraha na, ma Yãhã nar. U n ba wã klaha ke nakugu kuɛ ye ma yee: «Tagbihita, yir!» U n u yĩmpɛ yãr, ma Pyar yãã, ma yir nii. ");
INSERT INTO xrb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pyar n u yigi koho na, ma u ta u n yir yɛr. Loo kur ye, mpãy pe Yesu ta pe Yatɛr tesẽ pe Yesu kãndeyãrfa calangusyam ne, u n poo yee ba, maa u yar pe na yrãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pe n le cã tãŋ ke Yopɛ wo, loo n ta, nawee- busãã n u Yĩŋfua ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pyar n faa ma- Yopɛ na. U ba kuee ke Yopɛ wo sraha tẽntẽfua waa fla na, pe naa n yee Syimu. ");
INSERT INTO xrb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Syesarɛ laam wo, dya waa pye pe naa n yee Kɔrnee. U pye seraasyi yĩŋfua, ma pye Wɔrmefa seraasyi ndreŋ gaa yĩŋ na, pe naa n yee Yitale seraasyi ndreŋ. ");
INSERT INTO xrb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","U dya naa Yãhã kãnde kɛ. U naa n gaha Yãhã narsaha wo u nna byɛ ne. Yiifee- mpãy pe pye nawãm, u naa koho le pe ye, ma naa Yãhã nar plii byɛ. ");
INSERT INTO xrb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Per gaa yaiyĩn yale wo, Yiifee- Yãhã naryale ba kẽ, u n yãã mii wãytãã dyaŋ u na. U n yãhãyĩŋ tẽnlɛhɛ waa yãã gbaa na, tuu dye ba u fla na, maa u pye ma yee: «Kɔrnee». ");
INSERT INTO xrb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U n u yãhãyĩŋ tẽnlɛhɛ yãŋ, ma fya, ma u pye ma yee: «Yĩŋfua, nwa ma?» U yãhãyĩŋ tẽnlɛhɛ n u yɛ̃ wãã sya ma yee: «Taa naa Yãhã nar, ma maha naa koho le nawãm ye, Yãhã koo byɛ sya ma ye. Ke sẽ faha ma wĩĩ ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","-Taa -sẽ nawee- lɛhɛ yagaa, pe n ka Yopɛ na, pe ga dya waa ta u n pa, u myaha Syimu, nawee- byɛ u yee Pyar. ");
INSERT INTO xrb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","U n syã sraha tẽntẽfua waa ye, u myaha Syimu. U kaha ma muhulangbãŋ yɛ̃ tãy.» ");
INSERT INTO xrb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","U yãhãyĩŋ tẽnlɛhɛ n loo pãã u ye ma tɛr. Le yalebya wo, Kɔrnee n u tẽntẽ- syãm mpãy yee ba tesẽ u seraasyi naa waa ne, tuu pye mpãy yĩŋ na. Woo bya ba naa Yãhã kãnde kɛ, u wĩĩ ba waha Kɔrnee ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kai lii le pye, u n le gbe ma tɔ̃r pe ye, ma pe lɛhɛ wãã ke Yopɛ na. ");
INSERT INTO xrb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ke yĩŋsyii wo, pe naa n gaha ma sya ga nɔ gbe taha ke Yopɛ na. Pyar -sẽ pye, u ba dugu u kaha gbegbaha yĩŋ na yaiwlaŋ yale wo, ma yee woo ga Yãhã nar. ");
INSERT INTO xrb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Fãã n u yigi u n yee woo ga ngaa di. Yalii pe yee poo ga ngaa soho u kẽ, u n yãã mii wãytãã dyaŋ u na. ");
INSERT INTO xrb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","U n yãhãyĩŋ yãã ke fe yãr, kla gaa n nii tege n pai tãã ye kãntraha na: Ke kla pye mii faangbãŋ gaa dyaŋ. Ke yɛ̃r resyar ba wãã tã. ");
INSERT INTO xrb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ke laam wo trɛresyar wãn ter byɛ pye tesẽ kahakaha wãn ter byɛ ne ma suhu kãnsyãm ter byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yĩmbui laa n u pye ma yee: «Pyar, yir, ma wãn nde boo, ma naa n kaa!» ");
INSERT INTO xrb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pyar n wãã sya le yĩmbui ye ma yee: «Yĩŋfua, too wãn nde sẽ yɔ̃ ye; wo Yiifee- kãnde na, wo n fã wãn nde na.» ");
INSERT INTO xrb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Le yĩmbui n maha u pye ma yee: «Yãhã yee te yɔ̃, ma tee n fã re na.» ");
INSERT INTO xrb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pyar tuu too wãn yãã, ma luhu le yĩmbui ne, saa te n tɛr. Saa, u n maha te yãã. Yãhã te gbe yi u na koo syi tɛhɛ tãã, ke faangbãŋ n cã dugu tɛr yãhãyĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pyar tuu koo yãã pe wãytãã wo ke syi, u sẽ -sẽ waha le yĩntaha cã ye. Le yale -sẽ nwo, Kɔrnee tuu ba nawee- mpãy lɛhɛ wãã u Pyar ye u Syimu kaha wo, pe ba ke kaha yey naa n gaha, ma sya ga nɔ ke kapahayɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pe n yĩmbui yir ma le yey ma yee: «Syimu wii pe n yee Pyar, u n syã la nwo?» ");
INSERT INTO xrb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Yãhã ke ba wãn tii gbe yi u Pyar na ke yĩmbui lii ne tuu ba luhu, u Pyar pye nantãŋ u naa le ga. Yãhã Yrã n u pye ma yee: «Yãŋ! Nawee- tãã ma nwo, pe ma kɛ. ");
INSERT INTO xrb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yir, ma tege ke gbegbaha yĩŋ na, ma ka pe ne, maʼa n laalaa pye ye, ndoo tẽ pe lɛhɛ wãã.» ");
INSERT INTO xrb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Loo na, Pyar n tege ba pe nawee- mii fla na, maa pe pye ma yee: «Wii tee n kɛ, woo kẽ ra ne. Ah ye pa lii na?» ");
INSERT INTO xrb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pe n u yɛ̃ wãã sya ma yee: «Seraasyi yĩŋfua Kɔrnee kẽ tuu wo lɛhɛ wãã. Nawee wii kẽ u ne, u n sroŋ, Yãhã wĩĩ gboho u laam wo, Yiifee- byɛ u miiyũhũ yee. Yãhãyĩŋ tẽnlɛhɛ waa kẽ, u u Kɔrnee klaha, ma u yar ma yee, u ma ta ma n ka u fla na, maa ma yɛ̃ kapãn pãã u n luhu.» ");
INSERT INTO xrb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pyar n pe yigi dye u kaha wo, ma syãsaha wãã pe kẽ. Ke yĩŋsyii wo, pe n yir ma kãnde sya, ma dur tɛr. Pyar pye pe ne. Yopɛ Yesu kãndeyãrfa mpãy n yir ke Yopɛ wo, ma Pyar wãr ga. ");
INSERT INTO xrb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ke yĩŋsyii wo, pe n ga dye ke Syesarɛ wo. Kɔrnee naa u sẽŋ u kaha wo. U ba u nwoŋfa mpãy yee ba loo wĩĩ na, tesẽ u naambiyãbuam mpãy ne. ");
INSERT INTO xrb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Yaliile Pyar naa n pai dyesaha wo, Kɔrnee n ka, maa u wãã, ma kãnklũy gbãã u yaha ye, ma yee woo ga u syar nangbãŋ syaha ne. ");
INSERT INTO xrb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pyar n sye ma u kuã yir, ma u pye ma yee: «Danda, yir! Taa yãã, nawee ya kẽ ra bya ne.» ");
INSERT INTO xrb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","U n nii n pãã Kɔrnee ne, maa dye ke kaha wo, ma nabuar mpãy yãã pe wãã nii. ");
INSERT INTO xrb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","U n pe pye ma yee: «Ye cã ma yee Yiifee- kãnde na, Yiifee naa sẽ yai u naa n crã nawee wii na u wee Yiifee ye. U sẽ maha yai u naa n dye u kaha wo ye. Yagaa, Yãhã -sẽ ndoo klaha, ma ra yar ma yee, n sẽ yai n naa fã nawee waa ter na ye, n sẽ yai n naa waa ter yãŋ mii nawee wii syi dyaŋ, u sẽ yai pe naa n crã u na ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Koo kẽ, tee ra yee, n sẽ sye ye, n pa. Tee ra yee ba lii na, ye waha le pãã ra ye yagaa.» ");
INSERT INTO xrb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrnee n yee: «Ke plii resyar nanga, le pye yagaa syi yaiyĩn na. N pye n naa Yãhã nar ta kaha wo. Dya waa n ba yɛr ra tãy u kale wãn ne te n yɛhɛ palpal, ma ra pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‹Kɔrnee, taa naa Yãhã nar lii ne, ke le sya ma ye. Taa maha naa wãn tii byɛ wãã nawãm kẽ, le sẽ faha Yãhã na ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Loo nde na, waa lɛhɛ wãã Yopɛ na, u n ga Syimu yee ba, Syimu wii pe n yee Pyar. U ma dya wii kaha wo, u bya myaha Syimu u ya ndoŋ, u sraha tẽn tẽ, u ma muhulangbãŋ yɛ̃ tãy.› ");
INSERT INTO xrb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ta n ta tɛr waa lɛhɛ wãã ma ye, ma n le sya ma pa. Le yɔ̃. Wo byɛ mii Yãhã yaha ye yagaa. U Yĩŋfua tuu ma pye, ma ba wo yar lii ne, le pãã wo ye, wo ma wo n luhu ma ye.» ");
INSERT INTO xrb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Loo na, Pyar n yɛ̃ kuã ma yee: «Cĩĩnde ne, n cã Yãhã wee ke nawee waa puar nawee waa na ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Maʼa sya yi teelii teelii, maʼa pye wa ma n luhu Yãhã ye, ma maha kasroŋ pye, ma wĩĩ ga naa n tãy ke ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yãhã le kapãyĩĩ nɔ wãã Yiifee- ye, kapãyĩĩ lii le n yee nawee- byɛ ga ba yrĩŋ yãã Yesu Crise kãmay na, woo wii u ma wo byɛ Yĩŋfua. ");
INSERT INTO xrb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nsãn tuu nawee- yee naa n pai, maa naa pe yar, pe le sya pe cã, pe kapee- wãpyeŋ sẽ yɔ̃ ye, pe ke miy yaha, ma pe tãã naa n yi loho wo, ye koo ngĩĩ byɛ cã. Loo kur ye, lii le cãã pye Galɛlɛ kãntraha kur byɛ na, ma sya ka Yudɛ kãntraha na, ye maha loo nde bya cã. ");
INSERT INTO xrb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yãhã fãnga wãã Yesu kẽ, Yesu wii u n yi Nasarɛte wo, ma maha Yãhã Yrã wãã u kẽ, u n waha naa n gaha teebɛhɛ byɛ wo, ma naa kayĩĩ pye nawee- kẽ. Mpãy pe pye, Setane naa pe fãy fãnga ne, Yesu u Setane kar tege naa n kãã pe yĩŋ na. Yãhã pye u kur ye. Ye maha koo byɛ cã. ");
INSERT INTO xrb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tuu kai- nkãy byɛ pye Yiifee- klo Yurusalɛm wo ma suhu pe Yiifee- kui byɛ ne, wo ke yãã wo yĩnde ne. Loo kur ye, pe Yiifee- gɛ u kuey mar boo trã na. ");
INSERT INTO xrb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ke plii tãã na, Yãhã n u ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. ");
INSERT INTO xrb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","U sẽ -sẽ u ya yar nawee- byɛ na ye, u u ya yar wii poo na, wii mpãy Yãhã wo yãŋ yi, ma yee too u yãã wo yĩnde ne. Yesu tuu dur ba yrãŋ na gbaafa ye, wii kẽ too u yãã, ma sya wãã di u ne, ma loho bya wãã wɔ u ne. ");
INSERT INTO xrb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U n wo pye ma yee, too ga naa le Yesu kapãyĩĩ pãã pe nawee- ye, wo pe yar laha wo yee, woo Yesu kẽ Yãhã u yãŋ yi, u nawee- byɛ sãhã, mpãy pe ma yrãŋ na tesẽ mpãy bya ne pe ma gbã wo. ");
INSERT INTO xrb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Faale Yãhã kaplãŋ tɔ̃rfa byɛ bii le pãã u wĩĩ na ma yee, cĩĩnde ne, wii ma u Yãhã Yĩndefua ta u Yatɛr, Yãhã ga ufua kapee- gbe kãã u yĩŋ na Yesu myaha kãmay na.» ");
INSERT INTO xrb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pe nawee- pye pe naa Pyar kaplãŋ luhu, Yãhã Yrã n tege dye pe byɛ laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Yiifee- mpãy pe ba Yesu ta pe Yatɛr, ma pa Pyar ne, pe n yãã Yãhã Yrã tege dye pe nawee- mii laam wo, mpãy pe wee Yiifee- ye. Loo nde n pe Yiifee- mii fe gbe. Yãhã Yrã ba pe laam yĩĩ, pe n sya naa yor ter raa pãã, ma naa Yãhã sey. ");
INSERT INTO xrb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Loo na, Pyar n le pãã ma yee: «Ah mpãy pe Yãhã Yrã yãã wo wãŋ syi dyaŋ, pe bya sẽ yai la pe tãã yi loho wo pe ya ndoŋ?» ");
INSERT INTO xrb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Loo na, u n yee, pe pe tãã yi loho wo Yesu Crise myaha na. Pe wãtããyi kur ye, pe nawee- n maha u nar, u kuee u plii raa pye poo ne. U n le sya. ");
INSERT INTO xrb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mpãy pe wee Yiifee- ye, poo byɛ Yesu kapãyĩĩ sya cĩĩnde ke syi. Pe Yesu tẽnlɛhɛ mpãy pe pye Yudɛ wo tesẽ ke fla Yesu kãndeyãrfa ne, pe n le luhu, a mpãy pe wee Yiifee- ye, poo bya Yesu kapãyĩĩ sya cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pyar n ba dugu ba Yurusalɛm wo. Pe Yiifee- mpãy pe pye Yesu kãndeyãrfa, poo mii n le kuãn u ye ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Mpãy pe wee Yiifee- ye, ma ga dye pe kaha wo, ma sya wãã di pe ne.» ");
INSERT INTO xrb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kai- nkãy ke pye, Pyar n dye ke laam wo, ma ke byɛ tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","U n pe pye ma yee: «N pye klo nde wo pe n yee Yopɛ. N pye n naa Yãhã nar, ma ba yãã mii wãytãã dyaŋ ra na, ta n nii ngaa yãã: Ke kla pye mii faangbãŋ gaa dyaŋ, ke yɛ̃r resyar ba wãã pua tã. Ke n yir yãhãyĩŋ wo, ma sya tege ba nɔ ra na. ");
INSERT INTO xrb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ta n nii ke waha n yãŋ, ma kãntraha trɛresyar wãn raa yãã ke laam wo, wlaha wãn ne, kahakaha wãn ne tesẽ syir wãn ne. ");
INSERT INTO xrb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ta n luhu yĩmbui laa ne, le ra pye ma yee: ‹Pyar, yir, ma wãn nde boo, ma naa n kaa!› ");
INSERT INTO xrb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ta n sye ma yee: ‹Aye, Yĩŋfua, wãn nde syi sẽ yɔ̃ ye. Wo Yiifee- kãnde na, wo n fã re na. Te syi sẽ dye yãã ra yɛ̃ wo ye.› ");
INSERT INTO xrb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Le yĩmbui n maha yir yãhãyĩŋ wo ke tɛhɛ syãŋ na, ma ra pye ma yee: ‹Yãhã yee te yɔ̃, ma tee re yãŋ ma yee te sẽ yɔ̃ ye.› ");
INSERT INTO xrb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tẽ too wãn nde yãã ke syi, ma luhu le yĩmbui ne, pe wãytãã n caa ra na, ma maha pa ra ye, ta n maha yãã koo syi ya. Ke n tã tɛhɛ tãã, te wãn byɛ n dugu tɛr yãhãyĩŋ na, pe wãytãã n caa tãŋ ra na. ");
INSERT INTO xrb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Le yalebya wo, naam tãã n ba yɛr ke kaha kapahayɛ̃ na, kaha gii tẽ pye. Pe ba pe lɛhɛ wãã ra na, pe n yir Syesarɛ wo, ma pa ra fla na. ");
INSERT INTO xrb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yãhã Yrã n ta pye, n ka pe ne, n ma n laalaa pye ye. Pe Yesu kãndeyãrfa kuay mii tee yãã mii, pe ra wãr ga wo n sya ga dye Kɔrnee kaha wo. ");
INSERT INTO xrb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Too ga dye u Kɔrnee kaha wo, u n u yãhãyĩŋ tẽnlɛhɛ wĩĩ pãã wo ye. U yãhãyĩŋ tẽnlɛhɛ tuu ba u ya yar u Kɔrnee na mii syi dyaŋ, ma maha lii tɔ̃r u ye, u n dye ke laam wo, ma ke byɛ tɔ̃r wo ye. U yãhãyĩŋ tẽnlɛhɛ ba u pye ma yee: ‹Waa lɛhɛ wãã klo nde wo pe n yee Yopɛ, u n ga Syimu ta u pa ma fla na, Syimu wii pe n yee Pyar. ");
INSERT INTO xrb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kai- nkãy ke ga waha mboo Kɔrnee ta ma n waha sya yaha, mboo tesẽ ma kahafa byɛ ne, u ga ba ke yar ma na.› ");
INSERT INTO xrb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ndoo Pyar pye n naa n pãã nantãŋ pe nawee- ne, Yãhã Yrã n ba tege dye pe byɛ laam wo, mii wo wãŋ syi dyaŋ ke per cir na, per gii Yãhã Yrã ke fe tege, ma tege dye wo laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ta laam n too Yĩŋfua kapãn nde na tuu ba yee: ‹Nsãn ye tãã yi loho ya wo. Ndoo Yesu, n ga ye tãã yi Yãhã Yrã gɛ ne.› ");
INSERT INTO xrb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wii Yiifee- mpãy too Yĩŋfua Yesu Crise ta wo Yatɛr, Yãhã n kayĩĩ lii wãã wo kẽ, ke loo bya wãã mpãy kẽ, pe wee Yiifee- ye. Ndoo ga waha Yãhã wĩĩ sye la?» ");
INSERT INTO xrb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pe Yudɛ Yesu kãndeyãrfa, pe kaplãŋ ngĩĩ luhu wa, pe n pe laam yĩn, ma nii Yãhã sey, ma nii le pãã ma yee: «Le ma pye ke dyaŋ, mpãy pe wee Yiifee- ye, Yãhã ta poo bya ma waha le sya ma cã pe kapee- sẽ yɔ̃ ye, ma ke wãpyeŋ miy yaha, ke ga cĩĩnde yrã wãã pe bya kẽ, lii wãkuayãã wee le na ye.» ");
INSERT INTO xrb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cãã gii cãã na pe ba yir Yesu kãndeyãrfa wãnuhu na yĩntayãhã ne, ma sya ba u Yɛtyɛn boo, mpãy ba fã cããŋ, ma sya ka Fenise wo, Yãtɔɔsyi ne, Syiper ne. Ke Syiper nge, kãntraha gaa kẽ muhulangbãŋ ke gbey le. Pe n ga nii koo kui ngĩĩ wo, ma nii le Yesu kapãyĩĩ tɔ̃r Yiifee- poo ya ye. ");
INSERT INTO xrb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yesu kãndeyãrfa mpãy pye pe naa n yi Syiper wo tesẽ Syirɛ̃ ne, ma ba pa Yãtɔɔsyi wo. Poo mii -sẽ naa Yĩŋfua Yesu Crise kapãyĩĩ tɔ̃r mpãy ye pe wee Yiifee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yĩŋfua fãnga pye pe kaplãŋ na, nabuar n naa pe kaplãŋ sya cĩĩnde, ma pe kãnlɛ miy naa n yaha ma naa pe ya le Yesu kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","Yesu kãndeyãrfa mpãy pe pye Yurusalɛm wo, ma naa pe ya wãã, pe ba Yãtɔɔsyi Yesu kãndeyãrfa wĩĩ luhu. Pe n Barnabaase woo lɛhɛ wãã ke fla na. U pye naweeyɔ̃, Yãhã Yrã ba u laam yĩĩ, u maha ba Yesu ta u Yatɛr u laam byɛ ne. Tuu ga dye ke fla na ma yãã Yãhã kayĩĩ lii pye, le n nii u ye nuhu. U n pe nawee- yar laha pe pe laam ta wãcɛŋ, pe pe ya waha pe ma n cɛr Yĩŋfua na ye. Nabuar n maha naa n pai, maa pe ya le naa n soho Yĩŋfua koho wo. ");
INSERT INTO xrb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Loo kur ye, Barnabaase n ka Tarsu wo Sɔl fla na. ");
INSERT INTO xrb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","U n ga Sɔl yãã, ma u yigi ba Yãtɔɔsyi wo. Pe n kuee ke fla na dyɛwee, ma nii yawãhã pye ke fla Yesu kãndeyãrfa ne, ma maha nii nawee- busãã klaha. Myaha cãã taha Yesu kãndeyãrfa na ke Yãtɔɔsyi goo laam wo, ma nii pe yee Cretyɛ̃; koo yĩntaha kẽ, Crise nna. ");
INSERT INTO xrb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ke cãã na, Yãhã kaplãŋ tɔ̃rfa mpãy n yir Yurusalɛm wo, ma tege ga Yãtɔɔsyi na. ");
INSERT INTO xrb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Poo nen waa pye, u myaha Agabise. Yãhã Yrã n u ta u n yir, ma le pãã nawee- ye ma yee, fããpihi ga ba too Yudɛ kuɛ kãntraha kur byɛ na. Ke fããpihi n ba dye, ma yai Klode woo ne tuu pye kãntrɛ fãngafa byɛ yĩŋfua. ");
INSERT INTO xrb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pe Yãtɔɔsyi Yesu kãndeyãrfa n yir, ma yee poo ga war wãã, wii ma waha yia yɛ̃ gii na u pa, pe n wãã le pe nɔ wãã Yudɛfa mpãy kẽ pe ma Yesu kãndeyãrfa. ");
INSERT INTO xrb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","War mpãy pe yãã, pe n pe byɛ le soho Barnabaase koho wo tesẽ Sɔl ne, pe n ga pe wãã pe Yesu kãndeyãrfa yawãhã yahaseefa kẽ Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Koo cãã nsoho wo, fãnga pye Yɛrɔte Agiriba woo ye. U n nii Yesu kãndeyãrfa nuhu yĩntayãhã ne. ");
INSERT INTO xrb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U n sya ta pe n Syake yĩŋ gbã cɛr yũntrũhũ ne; Nsãn lɛfua ba kẽ woo ne. ");
INSERT INTO xrb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tuu yãã le tãy Yiifee- ye, u n maha ta pe n Pyar yigi. Too plii pye Yiifee- syayaha gbar plii, ncasur bur sẽ n di too plii na ye. ");
INSERT INTO xrb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Yɛrɔte n ta, pe n Pyar le nwompihi wo, ma seraasyi nawee- resyar yãŋ yi, poo syi flɛ resyar, pe n nii u Pyar yãŋ ma pe ya kẽ. Yɛrɔte naa n traha te syayaha gbar plii ma tɛr, u ta pe n Pyar sãhã nanihi wo, pe u boo. ");
INSERT INTO xrb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pyar pye ke nwompihi laam wo pe seraasyi ne, mpãy pe naa u yãŋ. Pe Yesu kãndeyãrfa sẽ naa n faha Yãhã wãnar wĩĩ ne u Pyar kẽ ye. ");
INSERT INTO xrb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ke pye yĩmper, Pyar pye u ba sã wãy seraasyi syãm mpãy nsoho wo, ntẽn wãn taa ne pe ta, ma u pua gbra pe ya na. Mpãy maha pye ke nwompihi nwonyɛ̃ na, ma naa ke sẽŋ. Pyar sãhãper -sẽ pye koo yĩŋsyii wo. ");
INSERT INTO xrb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Koo yĩmper wo, Yĩŋfua yãhãyĩŋ tẽnlɛhɛ waa n ba fe yi ke nwompihi wo, cãã- gaa n yɛhɛ palpal ke laam wo. U n Pyar gbã yir, ma u pye ma yee: «Yir farfar!» Tuu ba loo pãã wa, te ntẽn wãn n -sẽ fɛr Pyar koho na ma laha too. ");
INSERT INTO xrb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","U yãhãyĩŋ tẽnlɛhɛ n maha u pye ma yee: «Ma sapaha pua, -taa ma ntãy gbe le.» Pyar n u sapaha pua, ma u ntãy gbe le. U yãhãyĩŋ tẽnlɛhɛ n maha u pye ma yee: «Ma nayrengbãŋ gbe le, -taa naa n taha ra na.» ");
INSERT INTO xrb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pyar n yi ke nwompihi nwompua laam wo, ma nii n taha u na. Lii u yãhãyĩŋ tẽnlɛhɛ tuu naa n pye nde, Pyar sẽ ba le sya wa ma yee cĩĩnde ne ye. U naa le ga ma yee, wãytãã wĩĩ laa syi ne. ");
INSERT INTO xrb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Seraasyi mpãy pye pe naa tɛrsaha sẽŋ. Pe n ga tɛr pe tãy, ma maha ga seraasyi mpãy yãã yaha ye, ma maha tɛr pe tãy ma cã ga nɔ ke kapahayɛ̃ na. Ke kããnklihi pye ntẽn wãŋ. Nawee ma yi koo ne, u yi kua ke nwompihi wo. Pe n koo kããnklihi yãã ke yãr ke ya ya. Pe n yi kua ke nwompihi laam wo, ma kãnde laa sya, ma faa yãr, u yãhãyĩŋ tẽnlɛhɛ n plaha u na. ");
INSERT INTO xrb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pyar yĩntaha n ba too, u n u ya pye ma yee: «Yagaa woo, n le cã laha ma yee, Yĩŋfua kẽ tuu u yãhãyĩŋ tẽnlɛhɛ nɔ wãã, u n ba ra sya yaha Yɛrɔte koho wo, tesẽ wãnuhu gii ne pe Yiifee- pe n kɛ maa ra nuhu.» ");
INSERT INTO xrb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","U n laam ga, ma Maari kaha kãnde sya ma ka. Nsãn nahafua ba kẽ u ne, Nsãn wii pe naa n yee Marɛkɛ. Nawee- busãã pye pe ba pe ya wãã ke kaha wo, ma naa Yãhã nar. ");
INSERT INTO xrb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tuu ga nɔ ke kaha na, u n ke kapahayɛ̃ gbã, tẽntẽsya laale n pa loo n pai gbihi luhu, le myaha ba kẽ Ɔrde. ");
INSERT INTO xrb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Le tẽntẽsyale n le yĩmbui luhu, ma cã Pyar kẽ. Le n nuhu yigi tɛr Ɔrde kẽ, u sẽ yɛr gɛ yɛr ma ke kapahayɛ̃ yãr Pyar kẽ ye, ma fã tɛr, maa cãã le pãã pe nawee- ye ma yee, Pyar ma kapahayɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pe n u pye ma yee, u yĩŋ wee ye. U n sye ma yee cĩĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pe n maha yee, a Pyar yirfua kẽ. Pyar -sẽ pye u naa ke kapahayɛ̃ gbã. Pe n ga ke yãr ma yãã woo kẽ, le n pe byɛ fe gbe. ");
INSERT INTO xrb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pyar n koho kuã yir, ma yee pe yaha le. Yĩŋfua tuu u yi yaha ke nwompihi wo mii, u n le tɔ̃r pe ye. U n maha pe pye ma yee: «-Ye ga le pãã Yesu cĩĩfua Syake ye tesẽ Yesu kãndeyãrfa mpãy ne pe ma u Syake ne.» Tuu koo pãã wa, u n yi ma tɛr kuɛ ngaa ye. ");
INSERT INTO xrb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yĩŋ n syii, seraasyi n nii fã gbey n klaha Pyar wĩĩ ne, ncã u pye mii laa? ");
INSERT INTO xrb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Yɛrɔte n ta pe n u tay, pe sẽ u yãã ye. U n ta pe n pe seraasyi yey, seraasyi mpãy pe naa Pyar yãŋ, pe sẽ waha laa cã pãã ye. U n ta pe n poo seraasyi yigi ga boo. Loo kur ye, Yɛrɔte n yir Yudɛ wo, ma tege ga Syesarɛ wo, maa kuee ke fla na, ma faa ma-. ");
INSERT INTO xrb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yɛrɔte laam ba war Tyirfa ne tesẽ Syidɔ̃fa ne. Koo kui syãŋ ngĩĩ n pãã ta, ma pa poo n pai Yɛrɔte nar, pe n wãã le. Pe tee naa dir wãn busãã gbe Yɛrɔte woo kãntraha na, ma naa n gaha te ne pe kui wo. Pe n cãã ka, maa Blatise woo nar, u n yɛr le na. Woo pye u ga waha kai yar Yɛrɔte na u n le sya. Woo kẽ u pye Yɛrɔte kaha tẽntẽ- byɛ yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pe ba per gii ta, pe n gaha pãã pe wãã le, koo per n ba nɔ. Yɛrɔte n u nangbãn nayrɛ le koo per, maa tege nii u nangbãŋ niisaha wo. U n kaplãntãhã pãã nanihi wo nawee- kẽ, nuhu n sya pe yigi. ");
INSERT INTO xrb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pe nawee- n nii n tẽ ma yee: «Yãhã kẽ ke nii n pãã, nawee gɛ sẽ kẽ ye.» ");
INSERT INTO xrb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Le yalebya wo, Yĩŋfua yãhãyĩŋ tẽnlɛhɛ waa n koho tɛ u Yɛrɔte na. U tee ba Yãhã myaha sya, ma ke ta u wãŋ. Fyãr n dye u wo u n ku. ");
INSERT INTO xrb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Loo kur ye, le Yĩŋfua kapãyĩĩ -sẽ naa n gaha deydey, tesẽ mpãy pe naa n dye Yesu kãnde wo, pe naa n syar. ");
INSERT INTO xrb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabaase tesẽ Sɔl ne, pe ba poo war yĩntaha yi wa, pe n yir ke Yurusalɛm wo ma dur tɛr ke Yãtɔɔsyi wo. Pe ba Nsãn yigi taha pe ya na, Nsãn wii pe naa n yee Marɛkɛ. ");
INSERT INTO xrb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pe Yãtɔɔsyi Yesu kãndeyãrfa yawãhãfa nsoho wo, mpãy pye Yãhã kaplãŋ tɔ̃rfa. Mpãy maha pye pe naa nawee- klaha Yãhã kaplãŋ ne. Barnabaase pye pe ne, Syimu ne, Syimu wii pe naa n yee Nawɔ, ma suhu Lususe ne wii u n yi Sirɛnɛ wo, Sɔl ne, Manayɛ̃ ne, Manayɛ̃ wii tuu ba wãã lɛ fãngafua Yɛrɔte ne kaha neŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Per gaa, pe ba pe yɛ̃ tã digi na, ma pe ya wãã ta ma nii naa Yĩŋfua sey, Yãhã Yrã n ba pe pye ma yee: «-Ye Barnabaase yãŋ yi ra kẽ tesẽ Sɔl ne. Tẽn laa ma, n n yãŋ pe ga le tẽ.» ");
INSERT INTO xrb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pe n kuee koo yɛ̃ wãtã na digi na, ma kluɛ taha pe na ma Yãhã nar pe kẽ, ma kãnde wãã pe kẽ, pe n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yãhã Yrã le Barnabaase ye lɛhɛ wãã Sɔl ne, pe n yi Yãtɔɔsyi wo ma tege ga Seliise na. Pe n kuee ke fla na, ma salangbãŋ gbe, ma ka Syiper na. Koo kãntraha nge, muhulangbãŋ ke gbey le. ");
INSERT INTO xrb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pe ga nɔ ke Syiper na, klo lii pe cãã dye, pe naa le yee Salami. Pe n nii Yãhã kapãn pãã ke fla na Yiifee- yawãhã nwey wo. Nsãn Marɛkɛ pye pe ne, ma ba naa koho le pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pe n ke kãntraha yãr plaŋ, ma sya ga nɔ ke kuasaha fla na. Klo laa pye ke fla na pe naa n yee Pafɔsu. Pe n caifua waa yãã loo klo nde wo, pe naa u yee Gbara Yesu. Jrɛke yor wo u myaha ba kẽ Yɛlimase. U pye Yiifee. U ba u ya ta, woo ma Yãhã kaicãfua. ");
INSERT INTO xrb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","U ba nii u kãntraha fãngafua tãy. U fãngafua myaha ba kẽ Sɛrsye Pɔl. U ba kai- cã. Woo kẽ u ta, pe n Barnabaase ye yee ba Sɔl ne. U naa n traha u Yãhã kaplãŋ luhu. ");
INSERT INTO xrb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","U caifua Yɛlimase n nii n kɛ woo ga yɛr tã Barnabaase ye na Sɔl ne, ma maha nii n kɛ woo ga u fãngafua yĩŋ wã klaha u ma n le Yãhã kapãyĩĩ sya cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sɔl wii pe maha u yee Pɔl, yagaa Yãhã Yrã le u laam yĩĩ, u n nii u caifua waha n yãŋ, ");
INSERT INTO xrb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ma ba u pye ma yee: «Ma mii ta tɛr kacãŋ, ma pee tɛr, sãndũpee dya kẽ ma ne, ma wee yãã wãyĩĩ wĩĩ na ye! Yĩŋfua Yãhã ke kai- nkãy ta, ma tee yee, maa ke pye klaha-. ");
INSERT INTO xrb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Naa n luhu yagaa: Yĩŋfua Yãhã ga koho tɛ ma na, ma n nii fũũ, ma yalaale pye, ma cã maha ba naa yai cãã- yãã.» Le yalebya wo, Yɛlimase yĩmpɛ n wɔ tã u na, u n u ya yãã yĩmperwoho laam wo. U n nii figi gbey n klaha ke fla na ma nii waa kɛ u u yigi koho na. ");
INSERT INTO xrb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","U kãntraha fãngafua tuu nde yãã le pye nde, u n Yesu ta u Yatɛr. Ke kaklaha ter ngĩĩ ba yɛ̃ gbãã u na, kaklaha nkãy ke Yĩŋfua Yesu wĩĩ pãã nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl ye n salangbãŋ gbe u nampyeŋ- ne Pafɔsu wo, ma ka klo laa wo pe n yee Pɛrsye. Loo klo nde pye kãntraha gaa na pe n yee Pããfile. Nsãn Marɛkɛ n pe yaha koo fla na, ma dur tɛr Yurusalɛm wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɔl tesẽ Barnabaase ne, pe n ta tɛr pe yrãhã ye, ma yir ke Pɛrsye wo, ma ka klo laa wo pe n yee Yãtɔɔsyi. Loo klo nde pye kãntraha gaa na pe naa n yee Pisidi. Kanii per, pe n ga dye nii ke Yiifee- yawãhã nwoŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mpãy n ba kaplãŋ kal Yãhã kãnde kataŋ saba wo tesẽ Yãhã kaplãŋ tɔ̃rfa saba ne. Loo kur ye, pe Yiifee- yawãhã nwoŋ yahaseefa n ta pe n ga Pɔl ye yar ma yee: «Wo nna, laa ma pye ye ye, tee ga pãã pe yawãhãfa ye, ye laantor le pe laam wo tesẽ fãnga ne, ye ga waha le pãã yagaa.» ");
INSERT INTO xrb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pɔl n yir, ma koho kuã yir pe nawee- ye, pe yaha le. U n pe pye ma yee: «Yii Yiisrɛfa tesẽ yii mpãy ne tee ba Yãhã nar yawãhã nwoŋ nge wo, ye byɛ -ye luhu ra ye! ");
INSERT INTO xrb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yiisrɛfa, Yãhã bii wo wãlɛ poo yãŋ yi. Ke pe yaha nampay Syipte kãntraha na, ma pe ta pe n syar ke fla na. Ke n maha bii yɛr ke fãnga na, ma pe ta pe n waha fã yi ke Syipte wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pe n ga dyɛ- gbeesĩĩ pye tẽyãfũũ klo wo, Yãhã n maha naa pe kẽ digi ne ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Mpãy pye pe sẽ bii Yãhã cã ye, Yãhã n poo ter kuasĩĩ wĩĩ kua kãntraha nge na pe naa n yee Kanaa, ma koo kãntraha nge wãã ke nna kẽ, wo wãlɛ me. Koo kãntraha n nii pe wãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Koo kai- ngĩĩ, ke gbe ma ga pye kua, ke waha dyɛ- yĩĩsyãŋ tesẽ dyɛ- gbeesĩĩ sẽnsye syi kua. Loo kur ye, Yãhã n kaplãŋ cɛrfa ta wo wãlɛ yĩŋ na, ma sya ga waa u Yãhã kaplãŋ tɔ̃rfua Samuyɛl yai na. ");
INSERT INTO xrb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Loo kur ye, pe n yee poo ma yĩŋfua wĩĩ na, wii tuu ga nii pe kãntraha kui kur byɛ yĩŋ na. Yãhã n Sawile ta pe yĩŋfua. Kisi dya bii kẽ u ne. Bɛ̃syamɛ kaha kur waa bii kẽ u ne. U n nii ye wãlɛ yĩŋ na dyɛ- gbeesĩĩ. ");
INSERT INTO xrb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Yãhã n bii Sawile ta u saha nii pe yĩŋ na ye, ma u miy yaha, ma Dawide ta pe yĩŋfua. Yãhã n u wĩĩ pãã ma yee: ‹N Yisay dya Dawide yãŋ yi. Ta laanfua kẽ u ne. U ga ba ta laam wũhũ byɛ pye.› ");
INSERT INTO xrb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dawide kur waa kẽ Yesu ne. Yãhã bii yɛ̃ tɛr Yiisrɛfa ye, koo ga ba Syayahafua nɔ wãã pe kẽ, woo Syayahafua kẽ Yesu ne. ");
INSERT INTO xrb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nsãn n ba cãã yir Yesu yaha. U naa le pãã Yiisrɛfa byɛ ye, pe le sya pe cã pe kapee- sẽ yɔ̃ ye, pe ke wãpyeŋ miy yaha, pe cã pa u n ba pe tãã yi loho wo, nawee- byɛ yĩnde na pe n cã. ");
INSERT INTO xrb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nsãn kuyale ke ba gbe taha, u naa nawee- yar ma naa n yee: ‹Wii wãpaŋ tee n sẽŋ, woo sẽ kẽ ndoo ne ye. Ufua ma u n pai ra kur ye. Ta syi sẽ yai u ntãn sale wãfɛr ne u trɛ na ye.› ");
INSERT INTO xrb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Wo nna, yii mpãy tee ma Brama kur wãm, ma suhu mpãy byɛ ne pe pa ke Yãhã nar yawãhã nge wo, yii me tee yai ye cãã le kapãyĩĩ luhu, le kapãyĩĩ lii le u Syayahafua wĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ye sẽ yãã, Yurusalɛmfa tesẽ pe yahaseefa ne, pe sẽ ke kai- war ye, kai- nkãy wo faale Yãhã kaplãŋ tɔ̃rfa pe bii cãã yrũhũ yaha u Syayahafua wĩĩ na. Pe sẽ maha ba cã yoo kẽ u Yesu ne ye. Pe ta pe n u boo. Kai- ngĩĩ ke u Syayahafua dye yagaa poo pyer kãmay na, koo kai- kẽ wo faale Yãhã kaplãŋ tɔ̃rfa pe bii cãã yrũhũ yaha. Pe sẽ maha ke cã ye. Koo kai- -sẽ kẽ pe n kal pe ye cãwãã cãwãã, Yiifee- kanii per wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pe ba u sãhã, pe sẽ laa wãpee gɛ yãã tuu pye ye. Pe n sye ma yee, fãngafua Pilati n ta pe n u boo. ");
INSERT INTO xrb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kai- nkãy byɛ, ke bii cãã yrũhũ yaha u wĩĩ na, ke n pai u dye, pe koo byɛ pye wa u na, pe n u tege u kueymartrã na, ma ga u le gbĩĩ wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yãhã n -sẽ ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mpãy pe ba yir u ne Galɛlɛ kãntraha na ma ka u ne Yurusalɛm wo, u n plii buar raa pye wãyiŋ ne pe na. Yesu tuu naa kai- nkãy pye pe n naa n yãã yĩnde ne, ma suhu nkãy ne tuu naa n pãã pe n naa n luhu ndityɛ ne, koo kai- ngĩĩ byɛ kẽ pe pãã n tay nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Koo kẽ wo n nii loo kapãyĩĩ nde tɔ̃r n yar ye na. Yãhã ke bii yɛ̃ tɛr wo wãlɛ ye lii ne faale wo, loo ne le kapãyĩĩ nde ne. ");
INSERT INTO xrb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yãhã le pye wii poo kẽ, wii mpãy too ma pe kur kuɛ pii. Ke Yesu ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye, wo cã yagaa, ke bii yɛ̃ tɛr wo ye lii ne, ke le pye wa wo kẽ. Le ma le yrũhũ yaha ke Yãhã wãsey yay syãŋ fla wo ma yee: ‹Mboo kẽ, ma ma ra Dyapuai, ma gbe nanga na, nawee- ga cã, n ma ma Tuhufua.› ");
INSERT INTO xrb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yãhã bii yee, koo ga ba u ta u n yir gbã wo, u dur ba yrãŋ na gbaafa ye, tesẽ gbã ma n maha waha yia yãã u na ye. Ke naa loo pãã kaplãŋ ngĩĩ ne ma yee: ‹Tẽ bii yɛ̃ tɛr Dawide ye kayũhũ nkãy ne, n ga ke wãã ye kẽ cĩĩnde.› ");
INSERT INTO xrb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Le maha ma le yrũhũ yaha ke Yãhã wãsey yay teelaa fla wo ma yee: ‹Ma nawee wii raa yãŋ yi, ma saa sya u n fũhũ nii gbĩĩ laam wo ye.› ");
INSERT INTO xrb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dawide woo na, tuu yir u yai ne, u u tẽn lay tẽ le Yãhã laam wĩĩ wãpye wĩĩ na. Tuu -sẽ bii ku, pe n u le u wãlɛ ne, u kuee gbĩĩ laam wo ma fũhũ. ");
INSERT INTO xrb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yãhã ke -sẽ wii ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye, woo sẽ kuee gbĩĩ laam wo ma fũhũ ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Wo nna, -ye cã loo na ye yee, woo kãmay ne, le kapãyĩĩ n nii n tɔ̃r nawee- ye, lii le n yee, Yãhã pe kapee- gbe n kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Musa tuu le Yãhã kãnde kataŋ nkãy tɔ̃r, koo saha ye ta, ye n sroŋ Yãhã yĩnde na ye. Wii woo u -sẽ Yesu ta u Yatɛr, Yesu ga ufua ta, u n sroŋ Yãhã yĩnde na. ");
INSERT INTO xrb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yãhã kaplãŋ tɔ̃rfa pe lii pãã yaha, -ye yii yigi, ye ma syi ye wĩĩ n nii koo syi ye! Pe bii le pãã yaha ma yee: Yãhã yee: ");
INSERT INTO xrb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹-Ye yãŋ, yii mpãy tee tee n pãã Yãhã wĩĩ na, -ye yãŋ lii ne tẽ ga ba pye, le ga ba nii ye ye yɛ̃gbãã wĩĩ, ye ga ba kuee le wo. N ga ba loo pye ye yĩnde na, ye saa ba ku wa ye. Wãtɔ̃r wĩĩ syi dyaŋ pe ne ga ba loo nde tɔ̃r ye ye, yaa yee, cĩĩnde sẽ ne ye.› » ");
INSERT INTO xrb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔl tesẽ Barnabaase ne, pe ba pãã wa ma yi ke Yiifee- yawãhã nwoŋ wo, nawee- n pe nar, pe maha dur ba koo kaplãŋ cɛŋ ya pãã kanii per gaa, kii ke n pai. ");
INSERT INTO xrb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Naweetee- mpãy pe naa Yiifee- Yãhã kãnde yãr, poo busãã mpãy ma suhu Yiifee- busãã mpãy ne, pe n nii n taha Pɔl ye na Barnabaase ne. Pɔl tesẽ Barnabaase ne, pe n pãã pe ne, ma pe gbihi yar, ma pe pye ma yee, Yãhã ke laantãr wĩĩ lii pye pe kẽ, pe le yigi kluɛ sĩĩ. ");
INSERT INTO xrb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Cãwãã gaa n taha. Koo cãwãã kanii per, pe klofa byɛ n nii mii, pe pa tãŋ pe n pai ke Yãhã kaplãŋ luhu. ");
INSERT INTO xrb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pe Yiifee- yahaseefa ma suhu Yiifee- mpãy ne, pe pe nabuar yãã pe n luhu Pɔl ye ye, laanyar n pe yigi pe n nii Pɔl yɛ̃ kaplãŋ kai, ma maha nii u tyɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔl tesẽ Barnabaase ne, pe n pe Yiifee- yar laha laanyĩn ne ma yee: «Le Yãhã kapãyĩĩ yai le ne cãã tɔ̃r yii poo ye. Tee -sẽ le wĩĩ sye ma yee, ye sẽ yai cĩĩnde yrã wãyãã ne ye, wo mii, too wã klaha mpãy kuɛ ye, mpãy pe wee Yiifee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yĩŋfua gɛ wo yar le ne ma yee: ‹N ma yãŋ yi, ma ma ta cãã- wãŋ syi dyaŋ mpãy ye pe wee Yiifee- ye. N ma yãŋ yi, ma yee ma le wãsyayaha kapãyĩĩ tɔ̃r ga yi deydey kui byɛ ne kãntraha nge na.› » ");
INSERT INTO xrb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mpãy pe wee Yiifee- ye, pe kaplãŋ ngĩĩ luhu, pe n nii nuhu di, ma nii le Yĩŋfua kapãyĩĩ sey. Yãhã ke mpãy ta, pe waha ba cĩĩnde yrã yãã, poo byɛ n le kapãyĩĩ sya, ma Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Le Yĩŋfua kapãyĩĩ naa n cããŋ koo kuɛ kãntraha byɛ wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Canangbãy tii te naa Yiifee- wãlɛ kãnde yãr, ma suhu le klo yahaseefa ne, pe Yiifee- n poo mii sũũ le Pɔl ye na Barnabaase ne, pe n pe nuhu, ma sya pe kar yi kãã pe kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔl tesẽ Barnabaase ne, pe n pe trɛ mplẽm kor yaha koo fla Yiifee- na, ma tɛr klo laa wo pe n yee Yikɔ̃. ");
INSERT INTO xrb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pɔl ye pe tɛr, ma pe Yesu kãndeyãrfa mpãy ta yaha ke fla na, Yãhã Yrã n pe laam yĩĩ, pe n nii nuhu ya di. ");
INSERT INTO xrb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔl ye n ga dye Yikɔ̃ wo Barnabaase ne, ma ka koo fla Yiifee- yawãhã nwoŋ wo, ma Yãhã kapãn pãã nawee- ye. Yiifee- busãã tesẽ nawee- busãã mpãy ne pe sẽ pye Yiifee- ye, Pɔl ye kaplãŋ n tãy pe ye pe n sya Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yiifee- mpãy -sẽ ba sye, poo saa Pɔl ye kaplãŋ sya cĩĩnde ye. Poo mii n nawee- mpãy sũũ, mpãy pe sẽ pye Yiifee- ye, pe n sya nii wãpee ga pe Yesu kãndeyãrfa wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pɔl ye n kuee Barnabaase ne ke Yikɔ̃ wo, ma faa ma-. Pe ba pe koho taha yaha Yĩŋfua na, ma naa pe kaplãŋ pãã laanyĩn ne. Yĩŋfua naa fãnga wãã pe kẽ, pe n waha naa laanwɔ wũhũ pye tesẽ yɛ̃kã wũhũ ne nawee- n waha naa n cã, kapãyĩĩ lii pe n pãã nde Yĩŋfua laantãr wĩĩ na, cĩĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pe kaplãŋ n pe klofa ta, pe sẽ nii yĩmbui nen na ye. Mpãy n kuee Yiifee- kur ye, mpãy n -sẽ taha pe Yesu tẽnlɛhɛ na. ");
INSERT INTO xrb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pe Yiifee- tesẽ pe naweetee- mpãy ne pe sẽ pye Yiifee- ye, poo mii tesẽ pe yahaseefa ne, pe naa pe ya gbihi, poo ga Pɔl ye nuhu Barnabaase ne, pe pe waa boo ntẽmbar ne. ");
INSERT INTO xrb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pe naam syãm n yi le cãŋ na, ma ta tɛr fã ga Liiser kuɛ ye Darbu ne, ma suhu koo kui syãŋ ngĩĩ kãnkãy kusyĩmbɛhɛ ne. Kãntraha gaa kui ba kẽ, pe naa ke yee Lakoni. ");
INSERT INTO xrb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pe n nii le Yesu kapãyĩĩ tɔ̃r koo fla na. ");
INSERT INTO xrb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Loo klo nde wo pe naa n yee Liiser, tãkurfua waa pye, u naa n nii wãnii ya. U ba see u tãkur ne ke dyaŋ, u sẽ ba yir yɛr yãã, ma yãr yãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","U naa Pɔl kaplãŋ luhu. Pɔl n u waha yãŋ, ma le yãŋ cã u dya yĩntaha na ma yee, u dya laam wo u le sya wa laantee nen ne Yesu ga waha u jaa. ");
INSERT INTO xrb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Loo na, Pɔl n yĩmbui yir, ma u pye ma yee: «Yir, ma gbihi tãhã yɛr ma trɛ na!» U dya n kur ye tãhã yɛr u trɛ na, ma nii n yãr. ");
INSERT INTO xrb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pe nabuar pe yãã Pɔl lii pye, pe n tẽ sya Lakonifa yor wo ma yee: «Te mpar te ya wã klaha nawee-, ma tege ba wo ye!» ");
INSERT INTO xrb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pe n nii Barnabaase yee Yeepeta, ma yee Pɔl woo ma kaplãŋ pããfua, ma nii u yee Makur, pe klo mpar myar ne. ");
INSERT INTO xrb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mpar rii pe n yee Yeepeta, te kangbãŋ pye le klo dyesaha fla na. Ke yũndefua n napa mpãy yãŋ yi ma faasyĩmbir raa gbihi maha pe na, ma ka pe ne, ke kapahayɛ̃ kuɛ ye. U naa n kɛ, u ga pe napa boo, u Pɔl ye tẽŋ Barnabaase ne. Pe nabuar bya maha naa pe wãtẽŋ wĩĩ kɛ. ");
INSERT INTO xrb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pe Yesu tẽnlɛhɛ syãm pe le luhu, le sẽ tãy pe ye ye, pe n sya pe ya nayrɛ tyĩn jũũ, ma fã dye pe nabuar laam wo, ma nii n tẽ, ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Naambiyãm, nwa ye n nii loo nde pye? Naweetee- ya me wo ne ye dyaŋ. Wo pa le Yãhã kapãyĩĩ ne ye kẽ, ma yee ye nekla wãn nde tee ta ye mpar ma n tẽŋ, -ye re gbe ga miy yaha, tee ye yĩntar sroŋ cĩĩnde Yãhã ya ye, cĩĩnde Yãhã gii ke ma yrãŋ na yalebyɛ, koo gii ke yãhãyĩŋ ta, kãntraha ne, muhulangbãŋ ne tesẽ wãn tii byɛ ne te ma te laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nawee- terfa mpãy pe wee Yiifee- ye, faale wo Yãhã bii tyii pe na pe n naa pe laam kãnde yãr. ");
INSERT INTO xrb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ke sẽ -sẽ tyii ke ya wĩĩ wãyar na ye na ke kayũhũ wãpyeŋ ne ye kẽ ye: Yalebyɛ ke ga ta sesaha n yir yãhãyĩŋ na ke too, yĩnwoho cãã n dye ye n dir yãã busãã. Koo kẽ ke ye yɛ̃ digi yi, ma maha ye laam ta nuhu fla.» ");
INSERT INTO xrb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pe Yesu tẽnlɛhɛ pe sya kaplãŋ ngĩĩ pãã, pe -sẽ maha fãy, ma cã waha yɛr tã pe nabuar na, pe sẽ pe tẽŋ ye. ");
INSERT INTO xrb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Yiifee- mpãy -sẽ yir Pisidi Yãtɔɔsyi wo tesẽ Yikɔ̃ ne, ma pa ke Liiser wo. Pe n pe nabuar sũũ, ma pe byɛ wlaŋ taha pe ya na, pe n nii Pɔl waa ntẽmbar ne, poo ga u waa boo. Pe n yee u ku, ma u fle ga miy yaha le klo kãnkãy na. ");
INSERT INTO xrb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yaliile pe Yesu kãndeyãrfa poo ya pe ba wɔ tã u na, u n cã yir loo na, ma wlãhã dye pe ne le klo wo. Ke yĩŋsyii wo pe n yir Barnabaase ne pe syãm, ma ka klo nde wo pe n yee Darbu. ");
INSERT INTO xrb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pe n le Yesu kapãyĩĩ pãã koo fla na nawee- busãã n le luhu, ma Yesu ta pe Yatɛr. Loo kur ye, pe n dur ga Liiser wo ma suhu Yikɔ̃ ne, tesẽ Yãtɔɔsyi ne Pisidi kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pe naa pe Yesu kãndeyãrfa laam yĩn, ma naa pe yar, pe pe ya plãhã Yesu wãta wĩĩ ne pe Yatɛr. Pe naa pe yar ma yee: «Wii ma yee u ga dye Yãhã Yai wo, ufua ga cãã kayĩhĩ yãã wa.» ");
INSERT INTO xrb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yesu kãndeyãrfa yawãhãfa ma pye na, Pɔl tesẽ Barnabaase ne, pe ga mpãy yãŋ yi pe laam wo, pe pe ta pe yawãhãfa yahaseefa. Loo na, pe ga pe yɛ̃ tã digi na pe Yãhã nar, pe pe le soho Yĩŋfua koho wo, woo wii pe ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Loo kur ye, pe n dye yi tɛr Pisidi kãntraha kui nkãy wo, ma ga yi Pããfile kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pe n le Yãhã kapãyĩĩ pãã koo fla na, klo laa wo pe n yee Pɛrsye, ma ka tũntũn klo laa wo pe n yee Yatale. ");
INSERT INTO xrb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pe n ga salangbãŋ gbe koo fla na, ma dur ga Yãtɔɔsyi wo, Syire kãntraha na. Loo klo nde ne, pe Yesu kãndeyãrfa ba Yãhã nar pe kẽ, ke naa laantãr wĩĩ pye pe kẽ, pe n waha le Yãhã tẽn tẽ. Loo tẽn ne, pe ga tẽ kua, ma dur ba. ");
INSERT INTO xrb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pe ga dye ke Yãtɔɔsyi wo, pe n pe Yesu kãndeyãrfa yawãhãfa yee wãã ta. Pe ba tẽn lii tẽ Yãhã kãmay na, tesẽ mpãy pe wee Yiifee- ye, Yãhã ke ba pye mii, ma poo mii bya ta pe n waha Yesu ta pe Yatɛr, pe n koo byɛ tɔ̃r yar pe Yesu kãndeyãrfa na. ");
INSERT INTO xrb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Loo kur ye, Pɔl tesẽ Barnabaase ne, pe n faa nii ma- loo klo nde wo, pe Yesu kãndeyãrfa ne. ");
INSERT INTO xrb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yiifee- Yesu kãndeyãrfa mpãy pe pye Yudɛ wo, pe n yir ma pa Yãtɔɔsyi wo, ma ba nii Yesu kãndeyãrfa klaha nde ne, ma pe pye ma yee: «Ye ma yee ye sẽ kũũ mii Musa kãnde le yar wo na mii ye, ye saa waha sya yaha ye.» ");
INSERT INTO xrb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl tesẽ Barnabaase ne, pe sẽ yɛr pe kaklaha nge na ye, le n sya nii kaplãŋ wãtyĩn pe nsoho wo. Pe n le pãã ta ma yee, Pɔl, Barnabaase ne, ma suhu Yãtɔɔsyifa mpãy ne, pe ka Yurusalɛm wo pe ga le yey yãŋ pe Yesu tẽnlɛhɛ ye tesẽ pe Yesu kãndeyãrfa yawãhãfa yahaseefa ne. ");
INSERT INTO xrb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pe Yesu kãndeyãrfa yawãhãfa n pe wãr wãã kãnde wo. Pe n dye yi tɛr kui nkãy wo, kãntraha gaa na pe naa n yee Fenise, ma suhu Syamari kui nkãy ne. Mpãy pe wee Yiifee- ye, ma ba dye Yesu kãnde wo, pe poo wĩĩ tɔ̃r naa n gaha nawee- ye, le n naa nuhu yigi Yesu kãndeyãrfa byɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pe ga dye Yurusalɛm wo, pe Yesu kãndeyãrfa yawãhãfa byɛ n pe wãã, pe Yesu tẽnlɛhɛ ne pe yawãhãfa yahaseefa ne. Yãhã ke ba Pɔl ye ta ma tẽn lii tẽ, Pɔl ye n koo byɛ tɔ̃r pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Farisyɛ̃ mpãy pe Yesu ta pe Yatɛr, poo mpãy -sẽ pye ke fla na. Pe n yir ma yee: «Yesu kãndeyãrfa mpãy pe wee Yiifee- ye, poo yai wãkũũ ne. Pe maha yai pe naa n yãr le kãnde wo, lii Yãhã le yar Musa na.» ");
INSERT INTO xrb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pe Yesu tẽnlɛhɛ n pe ya wãã pe Yesu kãndeyãrfa yawãhãfa yahaseefa ne, poo ga le fla yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pe n kaplãŋ tyĩn ma-. Pyar n yir ma yee: «Wo nna, ye cã ma yee, Yãhã ba ra yãŋ yi le yale dey ma ra ta, ta n ga le Yesu kapãyĩĩ yar mpãy na pe wee Yiifee- ye, pe le luhu pe Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yãhã gii ke nawee- byɛ laam wũhũ cã tãŋ, ke pe sya, ma sya Yãhã Yrã le pe laam wo wo wãŋ syi dyaŋ. Loo nde ta wo n waha cã, Yãhã pe bya kuɛ yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pe Yesu ta pe Yatɛr, Yãhã pe byɛ ta wo ne koho neŋ na, ma pe kapee- yee laha kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ye -sẽ pye mii yagaa ma yee, yaa Yãhã pye yãŋ, ma n kɛ yii ga teger ta Yesu kãndeyãrfa na, teger rii syi wo wãlɛ tesẽ wii gɛ ne, waa sẽ waha te syi tẽŋ yãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Wo nanem byɛ sẽ n yee la, Yĩŋfua Yesu laantãr kãmay ne too sya yaha? Poo wĩĩ bya wee la koo syi?» ");
INSERT INTO xrb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Loo na, pe nawee- byɛ n yaha le, ma n luhu Barnabaase ye kaplãŋ ye, Pɔl ne. Yãhã ke ba Barnabaase ye ta Pɔl ne, ma yɛ̃kã wũhũ nkãy pye tesẽ laanwɔ wũhũ nkãy ne, pe nawee- mpãy nsoho wo, mpãy pe wee Yiifee- ye, pe n koo ngĩĩ byɛ tɔ̃r yar pe nawee- na. ");
INSERT INTO xrb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Poo nawee- syãm mii pe ba pãã wa, Syake n kapãn gbe ma yee: «Wo nna, -ye luhu ra ye! ");
INSERT INTO xrb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Mpãy pe wee Yiifee- ye, Yãhã pe kuɛ yãŋ faale wo, ma nawee- mpãy yãŋ yi pe laam wo pe nii u wãm. Pyar loo nde tɔ̃r yar wo na ke yagaa nge na. ");
INSERT INTO xrb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pe Yãhã kaplãŋ tɔ̃rfa kaplãŋ gɛ maha n gaha koo kuɛ ye. Ye cã, le ma le yrũhũ yaha Yãhã sabangbãŋ wo ma yee, Yĩŋfua le pãã ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Loo kur ye, n ga ba dur ba. Faale Dawide yĩnfar wee nantãŋ u kur kuɛ pii ye ye, mii kaha dyaŋ ke too. N -sẽ ga maha ba too yĩnfar nde wãã u kur kuɛ puee waa kẽ, le n nii mii kaha dyaŋ ke ba too, ta n ke gbihi fãã. ");
INSERT INTO xrb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Loo na, nawee- mpãy pe kuee, pe ga ba naa Yĩŋfua fla kɛ, pe naa n taha u na. Nawee- terfa mpãy byɛ pe wee Yiifee- ye, poo mii, tẽ mpãy yãŋ yi pe laam wo, pe nii ra wãm, pe byɛ ga ba naa Yĩŋfua fla kɛ, pe naa n taha u na. ");
INSERT INTO xrb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yĩŋfua kapãn ne nde. U loo yar yaha le yale dey.› » ");
INSERT INTO xrb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Syake n maha pe yar taha ma yee: «Loo ne, ta laam wo, mpãy pe wee Yiifee- ye, ma nii Yesu kãndeyãrfa, teger raa sẽ yai te taha pe na ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wo ga waha saba waa yrũhũ wãã pe kẽ, wo pe yar, waa ma kla gii boo le soho mpar koho wo, pe ma n ke kaa ye. Tesẽ, pe ma kla gii boo pe sẽ ke kuãy ye, pe ma n ke kaa ye. Tesẽ, pe ma n naa ntãŋ kaa ye. Tesẽ, pe ma n naa tyatyãhã pye ca kuɛ ye tesẽ naam kuɛ ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ye cã ma yee, ma gbe wo yahasee wãlɛ mpãy cãã na, ma sya ba waa yagaa na, kãnde lii Yãhã le yar Musa na, le n kal kanii per kanii per, wo Yiifee- yawãhã nwoŋ wo.» ");
INSERT INTO xrb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Loo na, Yesu tẽnlɛhɛ tesẽ Yesu kãndeyãrfa yawãhãfa yahaseefa ne, ma suhu pe Yesu kãndeyãrfa byɛ ne, pe n pãã ta ma yee, poo ga nawee- mpãy yãŋ yi pe ya laam wo pe pe lɛhɛ wãã Yãtɔɔsyi wo Pɔl ye ne pe syãm Barnabaase ne. Yudi wii pe naa n yee Gbarsabaha ma suhu Silaasyi ne, poo mpãy pe Yesu kãndeyãrfa naa pe miiyũhũ yee, pe n poo yãŋ yi, ma pe lɛhɛ wãã Yãtɔɔsyi wo Pɔl ne. ");
INSERT INTO xrb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pe ba pe lɛhɛ wãã pe ga saba wii kẽ, u ba yrũhũ ma yee: «Wii Yesu tẽnlɛhɛ, wii Yesu kãndeyãrfa yawãhãfa yahaseefa, wii mpãy too ma ye Yesu kãndeyãrwai Yurusalɛm wo nwo, wo saba nwo yrũhũ nɔ wãã ye kẽ, yii mpãy tee wee Yiifee- ye, ma ma Yesu kãndeyãrfa, ma nii Yãtɔɔsyi klo wo kãntrɛ nde ne pe n yee Syire, ma suhu Sersyi ne. Wo syaha ma ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wo le luhu pe yee nawee- mpãy yir wo fla na, ma ga ye laam wlãhã ntãncɛr kaplãŋ nkãy ne. Wii sẽ kẽ too pe lɛhɛ wãã ye ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Loo ne, wo n yĩmbui wãã le, ma nawee- mpãy yãŋ yi ma pe lɛhɛ wãã ye ye. Poo pe ga wo naam- biyãbua syãm mii wãr ga, Pɔl tesẽ Barnabaase ne, ");
INSERT INTO xrb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","poo mpãy pe gbã yɛ̃ nder ma pe ya plãhã ma kuee Yesu tẽn wo. ");
INSERT INTO xrb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yudi tesẽ Silaasyi ne, poo me too lɛhɛ wãã ye ye. Nkãy too yrũhũ saba laam wo pe ga ke gbihi pãã ye n luhu. ");
INSERT INTO xrb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ye sẽ yãã, le Yãhã Yrã ma suhu wii gɛ ne, wo yee wo saa teger raa ta ye na ye. Kai- ngĩĩ too ga yar ye na, nawee- byɛ yai pe koo gbihi yigi. ");
INSERT INTO xrb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Koo kẽ ngĩĩ: Pe ma kla gii boo le soho mpar wãn koho wo, ye ma syi ke kaa ye. Tesẽ, kla gii ne pe ma yee pe sẽ ke kuãy ye, ye ma n ke kaa ye. Tesẽ, ye ma n naa ntãŋ kaa ye. Tesẽ, ye ma n naa tyatyãhã pye ca kuɛ ye tesẽ naam kuɛ ye ye. Ye ma koo ngĩĩ gbihi yigi, le yɔ̃. Wo byɛ ye syar tãŋ.» ");
INSERT INTO xrb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pe mpãy lɛhɛ, pe n kãnde wãã pe kẽ, pe n ka ke Yãtɔɔsyi wo. Pe n ga dye, ma pe Yesu kãndeyãrfa byɛ wãã, ma u saba le soho pe koho wo. ");
INSERT INTO xrb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pe n u saba kal, ke kaplãŋ n tãy pe ye ma maha pe laam yĩn. Loo nde n nii pe ye nuhu. ");
INSERT INTO xrb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudi tesẽ Silaasyi ne, pe pye Yãhã kaplãŋ tɔ̃rfa, poo n kapãn gbe, ma pãã ma- pe Yesu kãndeyãrfa ne, ma pe laam yĩn, ma maha pe laam gbihi ta. ");
INSERT INTO xrb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pe n faa ma- koo fla na. Loo kur ye, pe Yesu kãndeyãrfa n ba Yãhã nar ke kãnde yigi pe kẽ, pe n dur ga pe nna fla na Yurusalɛm wo, pe nna mpãy pe pe lɛhɛ wãã.  ");
INSERT INTO xrb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silaasyi woo n kuee ke fla na, ma yee le tãy woo ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔl tesẽ Barnabaase ne, poo byɛ n kuee ke Yãtɔɔsyi wo. Pe naa nawee- klaha, ma naa le kapãyĩĩ tɔ̃r nawee- ye, kapãyĩĩ lii le Yĩŋfua wĩĩ pãã. Mpãy maha pye pe ne loo tẽn nde na. ");
INSERT INTO xrb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Per gaa, Pɔl n ba Barnabaase pye ma yee: «Too ba Yĩŋfua kapãyĩĩ pãã kui nkãy wo, -too dur ga, waa ke fla Yesu kãndeyãrfa yãŋ, pe ma mii.» ");
INSERT INTO xrb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nsãn wii pe n yee Marɛkɛ, Barnabaase naa n traha u u yigi taha pe na. ");
INSERT INTO xrb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pɔl n -sẽ yee: «Woo sẽ na, u ba tɛr wo yaha, per gii too pye Pããfile kãntraha na. U sẽ maha ba kaa taha yãã wo na ma ka teelaa wo le tẽn wĩĩ na ye.» ");
INSERT INTO xrb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yɛ̃croho n dye pe nsoho wo, pe n sya cããŋ pe ya na. Barnabaase n Marɛkɛ yigi taha u ya na, pe n salangbãŋ gbe, ma tɛr Syiper kãntraha kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔl n Silaasyi yãŋ yi, pe Yesu kãndeyãrfa n Yãhã nar ma pe le soho Yãhã laantãr koho wo. Pe n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔl ye n tɛr Syire kãntraha na tesẽ Sersyi kãntraha ne, ma nii pe Yesu kãndeyãrfa laam yĩn, ma nii pe yar pe pe laam waha Yesu wãta wĩĩ ne pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔl n ga dye Darbu wo, ma yir ke fla na, ma ga dye Liiser wo. Loo klo nde wo, Yesu kãndeyãrfua waa pye, u myaha ba kẽ Timuti; u nahafua pye Yiifeesya, ma Yesu ta u Yatɛr, ma sroŋ le kãnde wo. U tuhufua sẽ pye Yiifee ma ba wãkũũ kãnde cã ye. ");
INSERT INTO xrb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yesu kãndeyãrfa mpãy pe pye Liiser wo tesẽ Yikɔ̃ ne, pe naa u Timuti wãyĩĩ pãã. ");
INSERT INTO xrb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","U wĩĩ n tãy Pɔl ye, u n sya u yigi taha u ya na. Yiifee- mpãy pe -sẽ pye koo kuɛ kãntrɛ na, pe byɛ ba cã ma yee, u tuhufua wee Yiifee ye. Loo n ta Pɔl n u kũũ. ");
INSERT INTO xrb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kai- nkãy pe Yesu tẽnlɛhɛ pe pãã ta Yurusalɛm Yesu kãndeyãrfa yawãhãfa yahaseefa ne, Pɔl ye ma ga dye klo lii wo, pe ga loo byɛ pãã pe Yesu kãndeyãrfa ye, pe maha pe yar pe naa n pye koo syi. ");
INSERT INTO xrb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pe Yesu kãndeyãrfa yawãhãfa naa pe ya plãhã Yesu wãta wĩĩ ne pe Yatɛr. Kaa maha naa n taha pe wãnihi na, plii wuhu na. ");
INSERT INTO xrb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Yãhã Yrã sẽ sya Pɔl ye n le Yãhã kapãyĩĩ pãã Yasyifa ye ye. Pe n dye yi tɛr Firsyi kãntraha ne tesẽ Galasyi kãntraha ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pe ga nɔ gbe taha Miisyi kãntraha na, pe n yee poo ga ka Bitini kãntraha na. Yãhã Yrã sẽ le sya pe ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pe n dye yi tɛr Miisyi kãntraha wo, ma ka klo laa wo pe naa n yee Toosa; le klo pye muhulangbãŋ tãy. ");
INSERT INTO xrb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yĩmper wo, Pɔl n ba yãã mii wãytãã dyaŋ u na, u n Maseduanfa naa waa yãã tuu yir yɛr, ma nii u nar ma yee: «Pa Maseduan kãntraha na, ma ba wo sya yaha!» ");
INSERT INTO xrb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔl tuu u dya yãã pe wãytãã wo ke syi, poo, tesẽ ndoo Luke ne, wo n cã ma yee, Yãhã wo yee too ka wo ga le Yesu kapãyĩĩ yar Maseduanfa na. Wo n nii wãkaŋ kɛ koo fla na. ");
INSERT INTO xrb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wo n salangbãŋ gbe Toosa na, ma sroŋ ka kãntraha gaa na pe naa n yee Samotraasi. Muhulangbãŋ koo kãntraha nge gbey le. Ke yĩŋsyii wo, wo n ka klo laa wo pe naa n yee Naplosyi. ");
INSERT INTO xrb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Naplosyi wo, wo n yi ke salangbãŋ wo, ma ka Maseduan klo laa wo pe naa n yee Filipe; le ba gboho. Wɔrmefa maha ba nihi loo klo nde wo. Wo n plii raa pye ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kanii per, wo n yi le klo wo ma ka ke fla lafende fla na, ma yee laa na waa teelaa fla yãã Yiifee- pe pe ya wãã na, ma Yãhã sey. Wo n ga ca mpãy yãã pe pe ya wãã nii, wo n tege nii ma pãã pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pe laam wo, cɔɔ waa pye, u myaha ba kẽ Liidi, u naa n yi klo laa wo pe naa n yee Tadir, u naa wangbãhã fahawãn taa cãã troho, te pye wãyɛ̃r. U naa Yãhã kɛ. U naa ndityuhu yaha wo kaplãŋ na, Yĩŋfua n u laam ta u n nii Pɔl kaplãŋ luhu kayi ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Loo kur ye, u n le sya u kahafa byɛ ne, pe n pe tãã yi loho wo. Loo le pye wa, u n wo yee ma yee: «Ye ma cã, n Yĩŋfua ta ra Yatɛr cĩĩnde, -ye ba kuee ra kaha wo!» U n tãhã yɛr le na, wo n le sya u ye. ");
INSERT INTO xrb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Per gaa, too naa n gaha Yãhã narsaha wo, tẽntẽsya laale n wo wãã ba: Sãndũpee pye u yĩŋ na, ma u ta u n waha kai- yãŋ naa n cã, ma waha ke cãã tɔ̃r naa n yaha. U naa loo pye, ma war busãã sya naa n gaha u yĩŋfa kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","U n nii n taha wo na, Pɔl tesẽ wii ne, ma nii n tẽ ma n yee: «Yãhã gii ke ma ncaha ye, koo tẽntẽ- me naam mii ne! Kãnde lii ya le ga waha nawee sya yaha, loo kãnde kapãyĩĩ ne pe n yar ye na.» ");
INSERT INTO xrb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","U naa loo pye plii byɛ. Per gaa, le n sya ba sye Pɔl ye, u n wã klaha, ma sã u sãndũpee na ma yee: «Yesu Crise myaha na, n yee, ma tege kãã u yĩŋ na!» U sãndũpee n tege kãã u tẽntẽsyale yĩŋ na le yalebya wo. ");
INSERT INTO xrb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Le tẽntẽsyale yĩŋfa pe yãã, u saha laa yãŋ cã tɔ̃r nantãŋ u war sya pe kẽ ye, pe n Pɔl ye yigi ga fãnga na Silaasyi ne nanihi fla wo, pe klo yahaseefa fla na. ");
INSERT INTO xrb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pe n ka pe ne pe klo fãngafa yahasee ye, ma ga le pãã ma yee: «Naam mii ma, pe kai- wlãhã wo klo laam wo. Yiifee- me pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wii mpãy too ma Wɔrmefa, wo kãnde le yee lii sẽ yɔ̃ ye, too ma n naa le pye ye, loo ne pe ta ma nawee- klaha.» ");
INSERT INTO xrb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pe nabuar bya n yee, pe tee pye. Pe klo fãngafa n ta, pe n Pɔl ye nayrɛ fɛr kãã pe na, Silaasyi ne, ma pe gbã sãngblã ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pe n pe kã gbã, ma pe tã nwompihi wo, ma u nwompihi sẽŋfua pye, u pe yãŋ naa n yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pe u nwompihi sẽŋfua yar waha ke syi, u n ga pe le wãã ke nwompihi nwonuŋ gaa laam wo, ma pe trɛ pua yigi yaha katyir wãn taa laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yĩndyaha nsoho wo, Pɔl ye n nii Yãhã nar Silaasyi ne, ma nii yay le ma Yãhã sey. Pe nwompihifa byɛ naa pe yĩmbuhu luhu. ");
INSERT INTO xrb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yalaale wo, kãntraha n yɛhɛ fãnga ne, ke nwompihi nakũy byɛ n sya yɛhɛ. Te kããnklee byɛ n ta tɛr yãr te ya ya. Ntẽn wãn tii pe ba ta ma pe nwompihifa pua, te byɛ n ta tɛr sãhã te ya ya. ");
INSERT INTO xrb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","U nwompihi sẽŋfua n yir wãy na; tuu yãã ke nwompihi kããnklee te yãr yaha, u n yee pe nwompihifa ga pye pe fã tɛr, ma u yũntrũhũ tyĩn kuã, woo ga u ya boo. ");
INSERT INTO xrb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pɔl n tẽ sya fãnga ne ma yee: «Maʼa syi ma kapee pye mii na ye, wo byɛ ma nwo!» ");
INSERT INTO xrb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ke pye yĩmper wo, u nwompihi sẽŋfua n naa nar sya, ma fã dye ke nwompihi nwonuŋ laam wo, maa too kãnklũy na, Pɔl ye yahasee ye Silaasyi ne, ma nii n sege fyar koho wo. ");
INSERT INTO xrb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","U n ta, pe n yi, u n pe yey ma yee: «Lɛfa, n ga waha pye mii, n waha sya yaha?» ");
INSERT INTO xrb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pe n u yɛ̃ sya ma yee: «Yĩŋfua Yesu ta ma Yatɛr, maa sya yaha, mboo tesẽ ma nna byɛ ne.» ");
INSERT INTO xrb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Loo na, pe n u Yĩŋfua kapãyĩĩ pãã laha u ye, woo tesẽ u kahafa byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","U nwompihi sẽŋfua n pe yigi ga ke yĩmper wo le yalebya wo, maa pe nar yee pe kẽ. Pɔl n ta tɛr u tãã yi loho wo, woo tesẽ u nna byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","U n Pɔl ye yee, pe n dugu dye u ne u nwoŋ wo, ma di. U dya tuu Yãhã ta u Yatɛr, woo tesẽ u nna byɛ ne, le n nii u ye nuhu. ");
INSERT INTO xrb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Yĩŋ n syii, pe klo fãngafa n pe tẽntẽ- mpãy lɛhɛ wãã, pe n ba u nwompihi sẽŋfua pye ma yee, u naam mii yi yaha. ");
INSERT INTO xrb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","U nwompihi sẽŋfua n le pãã Pɔl ye ma yee: «Pe klo fãngafa nawee- lɛhɛ wãã, ma yee n ye yi yaha. Laa wee ye, ye ga waha yi ye tɛr pra.» ");
INSERT INTO xrb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pɔl n -sẽ pe fãngafa tẽntẽ- pye ma yee: «Pe ta pe n wo gbã nanihi laam wo, pe sẽ cãã wo sãhã laa gɛ ne ye, wii mpãy too n tɔ̃r Wɔrmefa ne! Pe n maha wo tã nwompihi wo. Yagaa, pe n traha pe wo yuhu yi yaha, waa ma n yi le cãŋ na ye. Wo saa le sya ye! Pe pa pe ya ya, pe ba wo yi yaha!» ");
INSERT INTO xrb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pe tẽntẽ- n ka, maa le pãã pe klo fãngafa ye. Pe le luhu ma yee, Pɔl ye ma Wɔrmefa Silaasyi ne, pe n fya. Pe Wɔrmefa kãnde na, waa sẽ yai u Wɔrme naa gbã ye. ");
INSERT INTO xrb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pe n pa loo na, maa kace nar Pɔl ye ye, ma cã pe yi yaha, ma pe nar pe tɛr le klo yaha. ");
INSERT INTO xrb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔl ye, pe yi ke nwompihi wo Silaasyi ne, pe n ka Liidi kaha wo, ma ga Yesu kãndeyãrfa yãã. Pe n pe laam yĩn, ma pe yar pe pe ya plãhã Yesu kãnde wo. Loo kur ye, pe n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔl ye n ta tɛr Silaasyi ne kui nkãy wo pe naa n yee Amplɔsyi tesẽ Apoloni ne, ma ga dye klo nde wo pe naa n yee Tesaloni. Yiifee- yawãhã nwoŋ gaa pye ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔl pye, u ma ga dye klo lii loo wo, u ma ne ka koo fla Yiifee- yawãhã nwoŋ wo. Pe ga dye Tesaloni wo, pe n ka ke fla na. Kanii per kanii per, u ne ka ke fla Yiifee- yawãhã nwoŋ wo, u ga naa Yãhã kaplãŋ pãã pe ye. U loo pye cãwãy tãã syi, maa naa Yãhã kaplãŋ pãã nawee- mpãy ye, pe pye ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ke kaplãŋ ke yrũhũ ta mii ke Yãhã sabangbãŋ wo, u naa pe klaha koo ne. U maha naa pe yar ma yee, u Yãhã Yĩndefua Crise wĩĩ ma, le cãã yrũhũ yaha ma yee, u yai u fãy gboho, u ba ku, tuu ba yir gbã wo, u dur ba yrãŋ na gbaafa ye. U maha naa pe yar ma yee: «Yesu nwo wii wĩĩ tẽ n pãã ye ye, woo kẽ u Crise ne.» ");
INSERT INTO xrb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yiifee- car mpãy ya n le sya, ma taha Pɔl ye na, Silaasyi ne. Mpãy pe sẽ -sẽ pye Yiifee- ye, ma naa Yãhã kãnde kɛ, poo busãã n le Yesu kapãyĩĩ sya, ma taha Pɔl ye na, Silaasyi ne. Poo, ma suhu ca busãã mpãy ne nawee- naa nagboho ta pe na. ");
INSERT INTO xrb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yiifee- mpãy pe sye, pe loo yãã, pe n nii mii, laanyar ga pe boo. Pe n natay taa yãŋ yi pe nabuar laam wo, ma pe ta pe n pe ya wãã, ma sya gbleŋ yir le klo wo. Loo na, pe n yir, ma ka Yasɔ̃ kaha wo, poo n gaha Pɔl ye yigi Silaasyi ne, pe ga pe sãhã nanihi fla wo. ");
INSERT INTO xrb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pe ga dye, pe sẽ pe yãã ye, pe n u Yasɔ̃ woo yigi, ma suhu Yesu kãndeyãrfa mpãy ne, ma ka pe ne le klo yahaseefa fla na, ma ga nii n tẽ ma yee: «Naam mii driyɛ̃ kur byɛ wlãhã tãŋ. Nanga, pe mii pe ba yi nwo! ");
INSERT INTO xrb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasɔ̃ syãsaha wãã pe kẽ u kaha wo. Kãntrɛ fãngafa byɛ yĩŋfua kãnde na, lii le sẽ yai le pye ye, loo ne nawee- mii pe n pye. Ye sẽ yãã, pe yee yĩŋfua waa maha ma, pe n yee Yesu.» ");
INSERT INTO xrb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pe kaplãŋ ngĩĩ n pe nawee- laam war ma suhu le klo yahaseefa ne, le n sya nii gbleŋ. ");
INSERT INTO xrb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","U Yasɔ̃ tesẽ mpãy ne pe ba yigi ba, pe n gblihi laa ma yɛ̃ tɛr klo yahaseefa ye ma yee, poo ga Pɔl ye ta Silaasyi ne pe n tɛr; pe n cã pe miy yaha. ");
INSERT INTO xrb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yĩmper ke ba wɔ, pe Yesu kãndeyãrfa n Pɔl ye ta pe n yrãhã yi, ma ga ka klo laa wo pe naa n yee Beree. Pe ga dye, pe n ka ke Yiifee- yawãhã nwoŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Koo fla Yiifee- laam ba yɔ̃ ma tɛr Tesaloni klo Yiifee- yaha. Pe n le Yãhã kapãyĩĩ sya laanfir ne. Plii byɛ pe naa Yãhã kaplãŋ saba yãŋ kayi ne, pe cã Pɔl kaplãŋ ma wãã le ke saba kaplãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Poo busãã n le kapãyĩĩ sya. Mpãy ter pe sẽ pye Yiifee- ye, poo tesẽ ca mpãy ne nawee- naa nagboho ta pe na, poo busãã n le kapãyĩĩ sya. ");
INSERT INTO xrb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yiifee- mpãy pe pye Tesaloni wo, pe ba luhu ma yee, Pɔl ma u le Yãhã kapãyĩĩ pãã Beree bya wo, pe n ka ke fla na, maa nii pe klofa sũũ, ma pe gblaha Pɔl ye ne. ");
INSERT INTO xrb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Loo n ta, pe Yesu kãndeyãrfa n ta tɛr Pɔl ta u n tɛr muhulangbãŋ kuɛ ye, u ga salangbãŋ gbe u tɛr. Silaasyi ye poo n kuee ke Beree wo Timuti ne. ");
INSERT INTO xrb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Beree Yesu kãndeyãrfa mpãy pe Pɔl wãr ga, pe n ka u ne ma sya ga dye Atɛn wo. Pe wãdur na, Pɔl n pe lɛhɛ, pe ma ga dye pe klo wo, pe ga Silaasyi ye yar Timuti ne pe pa u fla na, pe ma n nii kuee ye. Loo kur ye, pe Beree Yesu kãndeyãrfa n dur tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔl naa Silaasyi ye sẽŋ Timuti ne ke Atɛn wo. U n wãn busãã yãã le klo laam wo nawee- pe fãã ta wãtẽŋ wãn. Loo nde n nuhu byɛ kua kãã u laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ke Yiifee- yawãhã nwoŋ wo, u naa kaplãŋ pãã pe Yiifee- ne ma suhu mpãy ne pe sẽ pye Yiifee- ye ma naa Yãhã kɛ. Plii byɛ, nawee- mpãy tuu wãã naa n sya nanihi teebɛhɛ wo, u maha naa kaplãŋ pãã pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mpãy kaklaha ke n yee nawee sẽ yai wãfãy ne ye, ma suhu mpãy kaklaha ne ke n yee nawee yai u naa u ya waha yĩŋ wĩĩ na, poo yĩŋfa mpãy n pa maa nii kaplãŋ tyĩn u ne. Mpãy naa n yee, a lii u kaplãmbuarfua u n pãã? Mpãy maha naa n yee, a yãhãfãm mpãy wĩĩ ne tuu n tɔ̃r. Poo ba luhu Pɔl ye tuu naa Yesu wĩĩ pãã pe ye tesẽ u wãyir wĩĩ ne gbã wo, tuu yir ma dur ba yrãŋ na gbaafa ye, koo kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Le klo yawãhãfa mpãy pe naa pe ya wãã yãmpũnde lii yĩŋ na pe n yee Yɛropaase, pe n Pɔl yigi ga ke fla na, maa u pye ma yee: «Ma saa wo yar la, kaklaha nkãy ter syi wĩĩ taa n pãã wo ye? ");
INSERT INTO xrb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ma sẽ yãã, kai- nkãy taa n tɔ̃r wo ye, wo sẽ ke cã ye, wo n traha wo ke yĩntaha war.» ");
INSERT INTO xrb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pe Atɛnfa ma suhu nampay mpãy ne pe ba nii wlãhã pe ne, pe tẽn pye wãcɛŋ: Loo ne pe nii naa kafũhũ tɔ̃r pe naa n luhu pe ya ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔl n yir yɛr pe klo yawãhãfa telai wo ma yee: «Atɛnfa, tẽ ye yãã mii, Yãhã wĩĩ gboho ye laam wo kacãn wee ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ye sẽ yãã, n naa n tay ye klo wo ma naa ye katẽŋ wãn yãŋ, ma ga ye yãhã tẽŋsaha fla gaa yãã pe yrũhũ ta ke yĩŋ na ma yee: ‹Yãhã gaa wãŋ kẽ, wo sẽ ke cã ye.› -Ye yãŋ! Yãhã gii ree n tẽŋ ye sẽ ke cã ye; koo wĩĩ ne tẽ n pai pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Yãhã gii ke driyɛ̃ tãhã ke laam wãn byɛ ne, ke ma yãhãyĩŋ Yĩŋfua ma suhu kãntraha bya ne. Yãhã kangbãy tii nawee- te fãã, ke sẽ n syã te wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nawee- saa waha laale gɛ pye Yãhã kẽ, pe kaa taha ke na ye. Koo kẽ ke yrã wãã nawee- byɛ kẽ, wũũ ne, ma suhu wãn byɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ke cãã nawee nen ya tãhã u n syar, nawee- ter byɛ n yi, ke n pe ta ta ga kãntraha teebɛhɛ byɛ na. Ke wãn byɛ dyeyale ta dyɛ laam wo, ma nawee- kãntrɛ yɛrsar ta pe byɛ kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yãhã loo pye ma yee, nawee- pe koo fla kɛ. Pe pe ya waha pe naa ke kɛ, laa na pe ga ba ke yãã cã. Le cĩĩnde -sẽ na, Yãhã sẽ dey wo byɛ na ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ye sẽ yãã, koo kẽ ke wo ta wo n nii yrãŋ na, wo n waha kai- pye, wo n nii kla. Ye kaicãfa mpãy sẽ loo nen ya pãã la ma yee: ‹Wo byɛ maha ma ke pii.› ");
INSERT INTO xrb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Too -sẽ ma ke pii, wo sẽ yai wo naa le ga wo yee, Yãhã ga waha nii kla gaa syi dyaŋ, nawee- pe laam ga ma pe kluɛ ta ma ke gbihi sãn ne, wargbɛ syi ne, ntẽmblaha syi ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Faale cãã na, nawee- pe sẽ ba laa cã ye, Yãhã sẽ loo yãŋ nantãŋ ye, yagaa ke n kɛ nawee- ter byɛ pe le sya pe cã pe kapee- sẽ yɔ̃ ye, pe ke wãpyeŋ miy yaha. ");
INSERT INTO xrb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ye sẽ yãã, ke per gaa yãŋ yaha, ma maha nawee nen waa yãŋ yi u ba driyɛ̃fa sãhã koo per na. Ke loo nde yar nawee- byɛ na, ma woo nawee nen nwo ta u n yir gbã wo, ma dur ba yrãŋ na gbaafa ye!» ");
INSERT INTO xrb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pe luhu Pɔl tuu wãyir wĩĩ pãã gbã wo, wãdurba wĩĩ ne gbaafa ye, mpãy n nii u lɛr, mpãy n u pye ma yee: «Waa ba naa loo nde luhu ma ye per gaa.» ");
INSERT INTO xrb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Loo n ta, Pɔl n kãnde nar pe ye ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nanem mpãy -sẽ u kaplãŋ sya cĩĩnde, ma dye Yesu kãnde wo. Pe laam wo, dya waa pye pe naa n yee Denisu. U pye le klo kaplãŋ cɛrfa waa. Cɔɔ waa pye pe naa n yee Damarisi. Nawee- mpãy maha pye. ");
INSERT INTO xrb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Loo kur ye, Pɔl n yir ke Atɛn wo, ma ka klo laa wo pe naa n yee Kɔrnti. ");
INSERT INTO xrb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yiifee naa waa pye ke fla na, u myaha Yakilasu. U -sẽ ba see kãntraha gii wo, pe naa ke yee Pɔ̃n. U ba yir u cɔɔ Persyile ne kãntraha nge na pe n yee Yitale ma pa ke Kɔrnti wo. Kãntrɛ fãngafa byɛ yĩŋfua wii pe naa n yee Klode, u ba yee pe Yiifee- mpãy byɛ pe ma Yitale kungbãy nde wo, pe n yee Wɔrme, pe yi kãã le klo wo. Pɔl n u Yakilasu yãã ke Kɔrnti wo, ma ka u kaha wo. ");
INSERT INTO xrb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pɔl tuu ba koho tẽn lii tẽ cã, u bya naa loo tẽn tẽ. Sraha tẽn ba kẽ. Loo n ta, Pɔl n kuee pe fla na, pe n wãã naa n tẽ. ");
INSERT INTO xrb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kanii per ma nɔ, Pɔl ga ka Yiifee- yawãhã nwoŋ wo u ga naa le Yãhã kapãyĩĩ pãã pe Yiifee- ye tesẽ mpãy ne pe wee Yiifee- ye. U naa n kɛ pe waha le kapãyĩĩ cĩĩnde war. ");
INSERT INTO xrb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silaasyi ye n ba yir ke Maseduan kãntraha wo Timuti ne ma pa Kɔrnti wo. Pɔl n waha fãnga yãã loo na, ma nii le Yãhã kapãyĩĩ pãã yalebyɛ ma nii pe Yiifee- yar ma yee, Yesu woo u ma u Yãhã Yĩndefua Crise. ");
INSERT INTO xrb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pe Yiifee- -sẽ u kapãn sye ma nii u tyɛhɛ; Pɔl n u nayrɛ mplẽm kor yaha pe na, ma pe yar ma yee: «Ye ma ba ye yĩŋ kɛ laa, yii gɛ ye le kɛ, ndoo kalaa wee ye. Ma gbe yagaa na, mpãy pe wee Yiifee- ye, n ga naa n gaha poo kuɛ ye.» ");
INSERT INTO xrb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","U n tyii pe Yiifee- na ke yawãhã nwoŋ wo. Loo kur ye, u naa n gaha dya waa fla na pe naa n yee Yituse. U naa Yãhã myaha gboho, u kaha pye ke Yiifee- yawãhã nwoŋ tãy. ");
INSERT INTO xrb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ke Yiifee- yawãhã nwoŋ yahaseefua Kirpusu n Yĩŋfua Yesu ta u Yatɛr, woo tesẽ u kahafa byɛ ne. Kɔrntifa busãã naa Pɔl kapãn luhu, ma naa Yesu ta pe Yatɛr, pe n pe tãã naa n yi loho wo. ");
INSERT INTO xrb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Per gaa yĩmper wo, Pɔl n yãã mii wãytãã dyaŋ u na, u n Yĩŋfua yãã tuu u pye ma yee: «Maʼa n fya ye, naa le Yesu kapãyĩĩ pãã, maʼa n yaha le ye! ");
INSERT INTO xrb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ma sẽ yãã, n ma ma ne. Waa saa waha ba ma yigi u kapee pye ma na ye, nawee- busãã ma klo nde wo, pe n pai ra ta pe Yatɛr.» ");
INSERT INTO xrb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔl n kuee dyɛ nen gblihi ne ke Kɔrnti wo, ma nii nawee- klaha Yãhã kaplãŋ ne. ");
INSERT INTO xrb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Cãã gii cãã na Galyɔ̃ pye Yakayi kãntraha fãngafua, pe Yiifee- n yĩmbuhu wãã le ma yee, poo ga wãã Pɔl ne, ma u yigi ga kaplãŋ cɛrfa fla na, ");
INSERT INTO xrb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ma ga le pãã ma yee: «Dya nwo n traha u nawee- wlaŋ pe n naa diŋ yi Yãhã kẽ kaa ter syi, pe wo Yiifee- kãnde wũhũ miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔl ba yee woo ga yɛ̃ kuã u pãã, u Galyɔ̃ n pe Yiifee- pye ma yee: «Yii Yiifee- mii, le ma ne pye naboo wĩĩ laa syi dyaŋ, kaa na kapee laa syi, n ne ga yee n ga luhu ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Le -sẽ nii kaplãŋ ya tee n tyĩn kapãn nen laa wĩĩ na tesẽ myar wĩĩ ne, tesẽ ye Yiifee- kãnde wĩĩ ne, ye yai ye waha loo nde war yii ya. Ndoo saa nii kai- ngĩĩ syi sãhãfua ye!» ");
INSERT INTO xrb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","U n pe pye pe yir ke kasãhã saha fla wo pe naa n gaha. ");
INSERT INTO xrb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dya wii u pye ke Yiifee- yawãhã nwoŋ yahaseefua, u myaha ba kẽ Sohotãn, nawee- mpãy n yir loo na, ma u yigi, ma nii u gbã ke kasãhã fla na. U Galyɔ̃ sẽ -sẽ le ta kai ye. ");
INSERT INTO xrb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Loo kur ye, Pɔl n maha kuee Kɔrnti wo, ma faa ma-. U n ba kãnde nar pe Kɔrnti Yesu kãndeyãrfa ye, ma salangbãŋ gbe, woo tesẽ Persyile ne ma suhu Yakilasu ne. Pe n tɛr Syire kuɛ ye. Pɔl tuu -sẽ ba yɛ̃ tɛr Yãhã ye laa ne ma le pye wa, u n ta pe n u yĩŋ kur Sãncrihi wo, pe n cã tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","20","Pe n ga dye klo laa wo pe naa n yee Yefɛsyi. Persyile ye n kuee loo klo nde wo u puai Yakilasu ne. Pɔl n ka le klo Yiifee- yawãhã nwoŋ wo, maa Yãhã kaplãŋ pãã pe Yiifee- ye. Pe n u nar u nii ma- pe ne, u n sye, ");
INSERT INTO xrb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ma tɛr ma yee, Yãhã ma sya woo ga ba dur ba pe fla na. U n yir ke Yefɛsyi wo, ma salangbãŋ gbe ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Tuu ga tege Syesarɛ na, u n ka Yurusalɛm wo maa ke fla Yesu kãndeyãrfa yawãhãfa syar, ma dur tɛr Yãtɔɔsyi wo. ");
INSERT INTO xrb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","U n plii yɛ̃ gaa pye ke fla na, ma tɛr Galasyi kãntraha ne, Firsyi kãntraha ne, ma pe Yesu kãndeyãrfa yar naa n gaha, pe naa pe ya plãhã le Yesu kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yiifee naa waa ba pa Yefɛsyi wo. U myaha ba kẽ Apolosu, u ba see Lesyããndi wo. U yɛ̃ naa n tãy kaplãŋ ne, u maha ba Yãhã kaplãŋ saba wũhũ cã. ");
INSERT INTO xrb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Pe ba u klaha Yĩŋfua kãnde wũhũ ne. Ke Yãhã kapãyĩĩ wãpãã wĩĩ naa n tãy u ye, u naa nawee- klaha kayi ne Yesu wũhũ nkãy ne, u ba ke cã laha. Nsãn nawee- wãtãã wĩĩ ya tuu -sẽ ba cã. ");
INSERT INTO xrb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","U n nii n pãã laanyĩn ne ke Yiifee- yawãhã nwoŋ wo. Persyile ye n luhu u ye Yakilasu ne. Pe u kaplãŋ luhu, pe n u yigi ga pe kaha wo, maa u Yĩŋfua kãnde wũhũ gbihi yar u na. ");
INSERT INTO xrb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Loo kur ye, Apolosu n ba yee woo ga ka Yakayi kãntraha na. Pe Yesu kãndeyãrfa n yee, le yɔ̃. Pe n sya saba waa yrũhũ nɔ wãã pe Yakayi Yesu kãndeyãrfa kẽ ma yee, u Apolosu ma ba ka pe fla na, pe u yigi yɔ̃. Tuu ka ke fla na, mpãy pe ba Yesu ta pe Yatɛr Yãhã laantãr kãmay na, u naa laa yɔ̃ pe kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Lii u naa n pye, u ba cĩĩnde wũhũ cã, ma naa ke pãã pe Yiifee- ye, ma naa pe plahasaha fla yar pe na nawee- byɛ yĩnde na. U naa Yãhã kaplãŋ saba ta, ma pe yar naa n laha ma yee, Yesu woo u ma u Yãhã Yĩndefua Crise. ");
INSERT INTO xrb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosu pye nantãŋ Kɔrnti wo, Pɔl n yir Firsyi kãntraha na, ma Yasyi yãy fla yɔ̃r yi ma ka Yefɛsyi wo. U n ga Yesu kãndeyãrfa mpãy yãã. ");
INSERT INTO xrb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","U n pe yey ma yee: «Tee Yãhã kaplãŋ sya cĩĩnde, ye Yãhã Yrã Fãnga yãã la?» Pe n u yɛ̃ sya ma yee: «Wo sẽ le Yãhã Yrã Fãnga wĩĩ gɛ luhu yãã gɛ luhu yãã ye.» ");
INSERT INTO xrb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Loo na, Pɔl n pe yey ma yee: «Tee ba tãã yi loho wo, ye laam wo, ye ba yee le yĩntaha lii ne?» Pe n u yɛ̃ sya ma yee: «Nsãn tuu naa lii pãã nawee- ye ma cã pe tãã naa n yi loho wo, loo ne too cã.» ");
INSERT INTO xrb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔl n pe pye ma yee: «Mpãy pe naa n sya, ma pe kãmpee- miy naa n yaha, Nsãn poo tãã naa n yi loho wo. U maha naa Yiisrɛfa yar ma yee, wii u n pai pa woo kur ye, Yesu kẽ u ne, pe u ta pe Yatɛr.» ");
INSERT INTO xrb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pe kaplãŋ ngĩĩ luhu, pe n ta pe n pe tãã yi Yĩŋfua Yesu myaha ne. ");
INSERT INTO xrb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔl n koho taha pe na, Yãhã Yrã Fãnga n dye pe laam wo. Pe n nii n pãã yor ter taa wo. Kaplãŋ nkãy Yãhã Yrã naa ke le pe laam wo, pe naa koo tɔ̃r. ");
INSERT INTO xrb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Poo nawee- mii kur byɛ pye nawee- sẽnsye syãm syi. ");
INSERT INTO xrb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Loo kur ye, Pɔl n ka Yiifee- yawãhã nwoŋ wo, ma ga nii Yãhã kapãn pãã laanyĩn ne. U n yrey tãã pye ma nii Yãhã Yai wũhũ tɔ̃r ma naa n kɛ, nawee- n cã cĩĩnde ne. ");
INSERT INTO xrb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yiifee- mpãy pe -sẽ pye kasyerfa, pe sẽ naa ke kaplãŋ sya cĩĩnde ye, ma naa le pãã pe nanihi ye ma yee, Yĩŋfua kãnde wee kayĩĩ ye. Pɔl n tyii pe na, ma pe Yesu kãndeyãrfa yigi tɛr ma ga nii Yãhã kaplãŋ pãã pe ye plii byɛ, kaha gii wo Tyiranuhu u naa nawee- klaha na. ");
INSERT INTO xrb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U n kuee loo na dyɛ- syãŋ, ma ta mpãy pe pye Yasyi kãntraha wo, pe Yiifee- ma suhu mpãy ne pe sẽ pye Yiifee- ye, pe byɛ n Yĩŋfua kapãyĩĩ yãã luhu. ");
INSERT INTO xrb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yãhã ba Pɔl ta ma naa yɛ̃kã wũhũ pye, nkãy syi waa sẽ ke yãã yãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pe n sya naa Pɔl kadye nayrɛ wãn wãã yanfa kẽ tesẽ u fatar ne, pe n naa n jaa, sãndãpee n maha tege naa n kãã mpãy yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Yiifee- mpãy pe naa n tay ma sãndãpee kar tege naa n kãã nawee- yĩŋ na, pe n yee, poo ga le pye yãŋ Yĩŋfua Yesu myaha ne. Mpãy pe naa loo nde pye, pe Yãhã yũndefa yĩŋfa waa pii kuasĩĩ ba me. Pe tuhufua myaha ba kẽ Seewa. Pe n sãndũpee waa pye ma yee: «Yesu wii Pɔl u wĩĩ pãã, n ga ma yar woo myaha na, tege kãã dya nwo yĩŋ na!» ");
INSERT INTO xrb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","U sãndũpee n pe yɛ̃ wãã sya ma yee: «N Yesu wĩĩ cã, n maha cã yoo kẽ Pɔl ne; ah yii, mpãy me ye ne?» ");
INSERT INTO xrb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","U dya wii sãndũpee pye u yĩŋ na, u n fãnga yãã ma tɛr pe byɛ yaha. U n pe tee pye wãpyeŋ gaa ne, ma pe duai, pe n fã yi u kaha wo nayreyar ne. ");
INSERT INTO xrb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yiifee- mpãy pe pye Yefɛsyi wo tesẽ mpãy ne pe wee Yiifee- ye, pe byɛ n le luhu, ma fya. Pe n nii Yesu myaha gboho. ");
INSERT INTO xrb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Mpãy pe ba Yĩŋfua Yesu ta pe Yatɛr, poo busãã naa n pai, maa pe kapee- pãã naa n yi gbaa na, ma yee Yãhã n ke laha kãã pe yĩŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mpãy pe pye wamfa, sabar rii pe pe wam kai- yrũhũ le yaha pe laam wo, poo busãã n pe sabar nde gbe ba suhu nawee- byɛ yĩnde na. Te sabar nde byɛ dir ga waha war milyɔ̃ gbeesĩĩ sẽnsye kua. ");
INSERT INTO xrb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Yĩŋfua kapãyĩĩ cããŋ naa n yi koo syi dyaŋ fãnga ne, ma maha naa ke fãnga wũhũ yar nawee- na. ");
INSERT INTO xrb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Koo kai- ngĩĩ kur ye, Pɔl n yee woo ga Maseduan kãntraha kui yɔ̃r yi tesẽ Yakayi kãntraha kui ne u ka Yurusalɛm wo. U naa n yee: «N ma ba ka ke fla na, n yai n sya ba ka Wɔrme bya wo.» ");
INSERT INTO xrb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Loo na, u n u koholefa syãm mpãy lɛhɛ wãã u yahasee ye Maseduan wo, Timuti ma suhu Yerasyi ne. Woo n maha faa nii kuee Yasyi kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Koo cãã na, wãhã n yir Yĩŋfua Yesu kãnde wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Yefɛsyi wo kangbãŋ gaa pye, pe ba cɔɔ waa fãã ta ma yee, yãhã kẽ, ma naa u tẽŋ. U myaha ba kẽ Ndyan: Dya waa -sẽ pye wargbɛ wãn fããfua, u myaha ba kẽ Demetrise. U naa u Ndyan kangbãŋ nge syi wãpuabir fãã wargbɛ ne, ma naa ke par nawee- ye. Mpãy byɛ pe naa tẽn tẽ u ne, pe byɛ naa wangbãy yãã le na. ");
INSERT INTO xrb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","U Demetrise n u tẽntẽ- wãã ta, ma suhu mpãy byɛ ne pe naa loo tẽn nde syi tẽ, ma pe pye ma yee: «Naambiyãm, ye cã wo wale yĩŋ n yi tẽn nde wo. ");
INSERT INTO xrb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Dya nwo pe -sẽ n yee Pɔl, tuu lii pye, ye le luhu ma maha le yãã. U le pãã ma yee, wãn tii nawee- pe n gbihi, ma yee yãhã kẽ mii Ndyan ye dyaŋ, Yãhã sẽ kẽ te ne ye. Nawee- busãã n sya yɛr le na wo klo wo, Yefɛsyi wo nwo, ma suhu kui nkãy byɛ ne ke ma Yasyi kãntraha nge wo. Ye cã kapee ne nde. ");
INSERT INTO xrb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yaʼa yee ye sẽ cã ye, nde ga waha wo tẽn klaha- wo kẽ, le maha ta yãhãsya Ndyan kangbãŋ myaha n too. Loo nde ga ta nagboho saa naa n ta Ndyan na nantãŋ ye, woo wii Yasyi kãntraha byɛ u gboho tesẽ driyɛ̃fa byɛ ne.» ");
INSERT INTO xrb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pe nawee- pe kaplãŋ ngĩĩ luhu, ncafũhũ n pe yigi pe n nii n tẽ ma yee: «Yefɛsyifa, Ndyan myaha koo yai ke naa n gboho!» ");
INSERT INTO xrb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Koo gbleŋ n cããŋ le klo byɛ wo. Pe nawee- n fã ga ke nanihi fla yĩĩ, ma Pɔl yrãhãyãrwai syãm mpãy yigi, Kayusu tesẽ Arisarkɛ ne; Maseduanfa ba kẽ pe ne. ");
INSERT INTO xrb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔl ba yee woo ga ka pe nabuar fla na, Yesu kãndeyãrfa n yɛr tã u na. ");
INSERT INTO xrb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yasyi kãntraha yahaseefa mpãy pye Pɔl naambiyãm, pe n lɛhɛ wãã u ye, u ma n ka ke nanihi fla wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Loo yale wo, pe nabuar pye pe ba pãã naa n wlãhã, ma nii n gble: Mpãy ga nde pãã, mpãy ga laa ter pãã. Pe fãnga gɛ sẽ ba ke yawãhã yĩŋ cã ye. ");
INSERT INTO xrb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pe Yiifee- n dya waa tra naa n wãã yaha ye, u myaha Lesyããnder. Pe n woo yi u pãã pe nabuar ye. U n koho kuã yir pe nabuar ye, ma yee pe yaha le, woo ga pãã. ");
INSERT INTO xrb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pe nabuar pe ba u yãŋ cã ma yee, u ma Yiifee, pe n yir gbleŋ ne lɛr syãŋ syi ma nii n yee: «Yefɛsyifa, Ndyan myaha koo yai ke naa n gboho!» ");
INSERT INTO xrb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wɔrme naa wii u pye Yefɛsyi klo yahaseefua, woo n pa ma ba pe nawee- ta, pe n yaha le. U n pe pye ma yee: «Yefɛsyifa, nawee- byɛ cã ma yee, Yefɛsyi ne le n sẽŋ Ndyanngbãŋ kangbãŋ na, woo wii u yirfua yir yãhãyĩŋ na ma ba too kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Waa saha yee loo wee cĩĩnde ye. Loo na, ye yai ye ye laam yĩn, ye tyii ye ma n laa tee pye ye. ");
INSERT INTO xrb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tee naam mii yigi ba nwo, pe sẽ -sẽ Ndyanngbãŋ kangbãŋ kla gaa yuhu gbe ye, pe sẽ Ndyan wãpee pãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrise tesẽ u tẽntẽfa ne, laa ma pye pe nsoho wo waa ne, kasãhã plii ma, kasãhãfa maha ma. Pe yai pe ga le pãã koo fla na! ");
INSERT INTO xrb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Laa ma maha pye waa ye, waa ba le fla yãŋ nanihi wo, le klo kai- kãnde na. ");
INSERT INTO xrb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ye sẽ yãã, gbleŋ wĩĩ na pe ga waha yee, wo ma too wãhã yir le klo yĩŋfa ne. Too wii wãã mma, yĩŋ wee le na ye, waa waha lii pãã?» ");
INSERT INTO xrb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tuu kaplãŋ ngĩĩ pãã wa, u n pe nawee- dur wãã pe klɛ wo. ");
INSERT INTO xrb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ke gbleŋ wĩĩ le ba kua wa gbɛgbɛ, Pɔl n pe Yesu kãndeyãrfa byɛ wãã, ma fãnga le pe laam wo kaplãyũhũ ne, ma pe syar, ma tɛr Maseduan na. ");
INSERT INTO xrb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","U Yãhã kapãyĩĩ pãã naa n gaha pe Yesu kãndeyãrfa ye ma sya ga ke fla kãntraha yi yaha. Loo kur ye, u n ka Jrɛsyi kãntraha wo, ");
INSERT INTO xrb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","maa kuee yrey tãã. Tuu yrey tãã pye wa, u ba yee woo ga salangbãŋ gbe u ka Syire na, ma -sẽ luhu Yiifee- ma, pe pãã ta poo ga kapee laa pye u na. Loo ne le ta, u n Maseduan kãnde dur gbe ma ga ka Syire na. ");
INSERT INTO xrb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yesu kãndeyãrfa mpãy naa Pɔl wãr u yrãhã na, pe laam wo Sopatɛri pye, Bereefa naa Perusu dya kẽ u ne; ma suhu Tesalonifa Arisarkɛ ye ne Sekunduhu ne; ma suhu Darbufa Kayusu ne, ma suhu Yasyifa Tesyihi ye ne Toofĩĩ ne; ma suhu Timuti bya ne. ");
INSERT INTO xrb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pe ba dye Filipe wo, pe n tɛr wo yaha ye Toosa na, ndoo Luke tesẽ Pɔl ne. Pe n wo sẽŋ yaha ke Toosa na. ");
INSERT INTO xrb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yiifee- syayaha gbar rii ncasur bur sẽ n di ye, too kur ye wo n salangbãŋ gbe ke Filipe wo ma taha pe na. Wo n fã plii bua ma ga pe yãã ke Toosa wo, ma plii kuasĩĩ pye ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ke Yiifee- cãwãã per cir yainkɔŋ wo, wo ba wii wãã ma ga Yesu wãku cãã dir syi di, wo wii laam too wo Syayahafua wãku wĩĩ na. Pɔl ne yai u tɛr koo yĩŋsyii wo. U n pãã pe Yesu kãndeyãrfa ne ma sya ga yĩndyaha dye. ");
INSERT INTO xrb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ke kaha gbegbaha yĩŋ na, too ba wii wãã nwoŋ gii laam wo, naalɔr pye te ba nihi. ");
INSERT INTO xrb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Naanfuɛ̃ waa pye, pe naa u yee Yeetuse. U ba tege nii fenaatɛr na. Pɔl tuu ba pãã ma-, u n sã wãy faha. Le pye gbegbaha yĩŋ tãã wuhu na, pe wãy n u ta u n tege too kãntraha na. Pe n tege ma u kuã yir, ma yãã u ku. ");
INSERT INTO xrb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pɔl n tege kãntraha na, ma kuɛ tege, ma u gbe yigi u kluɛ wo ma yee: «Ye ma n fya ye, u ma yrãŋ na!» ");
INSERT INTO xrb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Loo kur ye, u n dugu ga ncaha ye maa bur la cɛr pe n di. U n maha pãã ma-, yai n sya ba dar, u n cã tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pe n tɛr u naanfuɛ̃ ne yrãŋ u kaha wo, nawee- byɛ laam n yĩn. ");
INSERT INTO xrb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Per gii too yir Toosa wo, wo cãã salangbãŋ gbe Pɔl yaha ma ka Asosa na. Koo fla too ne ga Pɔl gbe. U ba yee woo ga naa n yãr trɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tuu ga wo yãã Asosa na, wo n u gbe ke salangbãŋ wo ma ka Metilɛni na. ");
INSERT INTO xrb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wo n yir koo fla na; ke yĩŋsyii, wo n nɔ Syoho tãy. Koo yĩŋsyii, wo n nɔ Samusi na; koo yĩŋsyii, wo n tege Melɛti na. ");
INSERT INTO xrb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔl ba yee woo ga tɛr Yefɛsyi tãy u saa yɛr ye, mii loo sẽ ne ye, u ga ma- tɛr Yasyi kãntraha na. U naa n gber woo ga cãã dye Yurusalɛm wo pããnkɔti gbar per. ");
INSERT INTO xrb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Loo n ta, Pɔl n kuee Melɛti na, ma tẽnlɛhɛ nɔ wãã Yefɛsyi Yesu kãndeyãrfa yahaseefa ye pe pa. ");
INSERT INTO xrb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pe n pa u fla na, u n pe pye ma yee: «Per gii tẽ ka Yasyi kãntraha na, tẽ naa ra troho tãhã mii ye fla na ma sya ba waa yagaa na, ye le cã. ");
INSERT INTO xrb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N naa nii tege tãã ye, ma naa Yĩŋfua tẽn tẽ. Pe Yiifee- pe naa ra kɛ, ma pãã naa n ta, koo wãfãy nge byɛ pye ra na, ma suhu te laangar ne, yĩntãm n sya naa n yi ra ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nkãy ke ga waha laa yɔ̃ ye kẽ, n sẽ ke wũhũ ye na ye: N ke byɛ pãã ye ye, ma maha ye klaha ke ne nanihi fla wo tesẽ ye klɛ ne. ");
INSERT INTO xrb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pe Yiifee- ma suhu mpãy byɛ ne pe wee Yiifee- ye, n pe byɛ yar, pe pe kapee- wãpyeŋ miy yaha pe Yãhã kãnde gbe, pe u Yĩŋfua Yesu ta pe Yatɛr. ");
INSERT INTO xrb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","N nwo, n n tɛr Yurusalɛm wo yagaa; Yãhã Yrã le yee n loo pye, n sẽ -sẽ cã lii le n pai ra dye ke fla na ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kui byɛ wo, Yãhã Yrã ra yar ma yee, nwompihi ra sẽŋ ke fla na ma suhu wãfãy ne. Loo ya tẽ cã. ");
INSERT INTO xrb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","N -sẽ cã ma yee, ta yrã wee ngaa ra ye ye. Lii tẽ n kɛ, n waha ra fyaha byɛ fã tãŋ. Ye sẽ yãã, wo Yĩŋfua Yesu u tẽn lii le soho ra koho wo, n waha le tẽ tãŋ. Loo tẽn ne, Yãhã ke laantãr wĩĩ lii pye wo kẽ, n loo kapãyĩĩ pãã nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","N ga yi ye byɛ na ma Yãhã Yai wĩĩ pãã ye ye. N -sẽ cã yagaa ma yee, yii nawee nen waa gɛ saa maha ra yãã yãã nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Loo ne, n ga le pãã ye ye nanga: Yii nawee nen waa ma plaha, ndoo sẽ kẽ n u ta u n plaha ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ye sẽ yãã, n Yãhã wũhũ byɛ tɔ̃r ye ye, n sẽ laa wũhũ ye na ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","-Ye naa n sẽŋ yii na tesẽ nawee- mpãy byɛ ne Yãhã Yrã pe le soho ye koho wo, -ye pe gbihi naa n yigi mii mbanaha dyaŋ u mbaa ne. Poo mii, Yãhã pe par sya ke Dya ntãŋ wãwoo kãmay na. ");
INSERT INTO xrb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N cã ma yee, n ma ba tɛr wa, nawee- mpãy ga ba dye ye laam wo. Pe ga ba pee tã ye na mii waygapyãr dyaŋ mbaa na. ");
INSERT INTO xrb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yii gɛ laam wo mpãy ma, pe ga ba yir kawar wãfua ne poo ga pe Yesu kãndeyãrfa wlaŋ taha pe ya na. ");
INSERT INTO xrb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ye ma n sã wãy faha ye, -ye naa ye laam too ke dyɛ- tãã nkãy na tẽ pye ye ne ma naa yii nanem byɛ yar ke kai- ne ke yai ke yĩmper, ma sya naa yĩntãm gɛ yi. ");
INSERT INTO xrb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yagaa, n ye le soho Yĩŋfua Yãhã koho wo. Ke kapãn lii le Yãhã laantãr yar nawee- na, le ga ye laam yĩn. Koo ya ke ga waha fãnga wãã ye kẽ ye n yii plãhã Yesu kãnde wo, ke maha ke kayĩĩ wãã ye kẽ, ke kayĩĩ lii ke n wãã mpãy byɛ kẽ pe ma ke wãm. ");
INSERT INTO xrb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N sẽ naa waa wale yãŋ yĩnde ne ye, tesẽ waa sãn ne ye, tesẽ waa kale wãn ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Yii gɛ cã ma yee, n naa tẽn tẽ ra kluɛ ne, ma naa wo yɛ̃ digi kɛ, ndoo tesẽ ra yrãhãyãrwai ne. ");
INSERT INTO xrb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","N kai- byɛ pye ma yee, ye ra pyer yãŋ ye cã, wo yai wo naa tẽn tẽ, koo syi wo ga waha naa kayĩĩ pye fɛnfa kẽ, too maha naa wo laam too Yĩŋfua Yesu yɛ̃ kaplãŋ ngĩĩ na tuu yee: ‹Pe ma ma kẽ, le yɔ̃; mboo ma -sẽ waha yia ma waa kẽ, wãyĩĩ ma le na ma ta tɛr.› » ");
INSERT INTO xrb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔl tuu kaplãŋ ngĩĩ pãã wa, u n kãnklũy gbãã pe ne, pe n Yãhã nar pe ya kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Pe byɛ naa n wũn ma Pɔl wɔ naa n yigi pe kluɛ ne, poo ga u wãtɛr syaha wãã u kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pɔl tuu ba yee woo sẽ n pai maha pe yãã yãã nantãŋ ye, loo le ba pe laam wlãhã, le sẽ ba tãy pe ye ye. Loo kur ye, pe n u wãr ga ke salangbãŋ fla na. ");
INSERT INTO xrb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Too cããŋ wii na pe ne, wo n salangbãŋ gbe, ma sroŋ ka Kosyi na. Ke yĩŋsyii wo, wo n ka Ordesyi na, ma yir koo fla na ma ka Patara na. ");
INSERT INTO xrb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Koo fla na, wo n salangbãŋ gaa yãã ke naa n gaha Fenise wo; wo n dye ke wo ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Wo n ga nɔ Syiper tãy, kãntraha gaa kẽ muhulangbãŋ ke gbey le. Wo waha naa ke Syiper yãã ke salangbãŋ laam wo; wo n tɛr ke yainde dar kuɛ kãndigi kuɛ ye ma ka Syire kuɛ ye. Wo n ga ke salangbãŋ yɛr Tyir langbeŋ na, pe n ke teger yi ke wo ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Wo n Yesu kãndeyãrfa fla kɛ, ma mpãy yãã ke fla na ma kuee pe ne plii kuasĩĩ. Yãhã Yrã n ba pe yar laa ne Pɔl yrãhã wĩĩ na ke Yurusalɛm wo. Pe n Pɔl pye, u ma n ka ke Yurusalɛm wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Too plii kuasĩĩ te -sẽ ba tɛr, wo n wo yrãhã kãnde gbe. Pe n wo wãr pe ca ne, pe pii ne, ma sya ga le klo yi yaha. Wo n kãnklũy gbãã muhulangbãŋ yɛ̃ na ma wo laam wũhũ tɔ̃r Yãhã ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Loo kur ye, wo n syaha wãã wii kẽ. Wo n dugu dye ke salangbãŋ wo, poo n -sẽ dur tɛr pe klɛ wo. ");
INSERT INTO xrb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Too yir Tyir wo, maa dye Toolemasyi wo, wo muhulangbãŋ yrãhã n kua ke fla na. Koo fla na, wo n Yesu kãndeyãrfa syar ma kuee pe ne per neŋ. ");
INSERT INTO xrb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ke yĩŋsyii wo, wo n yir maa dye Syesarɛ wo. Koo fla na, wo n ga syã Filipe kaha wo, Filipe wii u Yesu kapãyĩĩ pãã nawee- ye. Naam kuasĩĩ mpãy pe ba yãŋ yi Yurusalɛm wo, poo nen waa ba kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U pye pueesyam resyar ne, pe sẽ pye wa naam ye ye. Kaplãŋ nkãy Yãhã Yrã naa ke le u pueesyam laam wo, pe naa koo tɔ̃r nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Wo ba plii raa yãã wa ke fla na, Yãhã kaplãŋ tɔ̃rfua Agabise n ba yir Yudɛ na ma pa. ");
INSERT INTO xrb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","U n pa wo fla na, maa Pɔl sapaha sya, ma u ya trɛ pua u kluɛ ne ma yee: «Yãhã Yrã lii pãã, le nde: Yiifee- ga ba sapaha ngefua pua mma ma syi dyaŋ Yurusalɛm wo, pe dur pe u yi nampay kẽ.» ");
INSERT INTO xrb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Too kaplãŋ ngĩĩ luhu, wii gɛ ma suhu pe Syesarɛfa ne, wo n Pɔl nar u ma n ka Yurusalɛm wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","U n sye ma yee: «Nwa ye n nii n wũn, ma n kɛ yii ga ra laam wlãhã? Ndoo na, n nii gbihi ta wa ra wãpuaŋ na, ma suhu ra wãboo ne ke Yurusalɛm wo Yĩŋfua Yesu wĩĩ na.» ");
INSERT INTO xrb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Too ba pãã laa u ne, wo n tyii u wãnar na ma yee: «Yĩŋfua wĩĩ le naa n pye!» ");
INSERT INTO xrb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wo n plii raa pye ke fla na, ma wii cããŋ, ma Yurusalɛm kãnde sya. ");
INSERT INTO xrb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Syesarɛ Yesu kãndeyãrfa mpãy n wo wãr ga dye Yurusalɛm wo. Pe n ka wo ne dya waa kaha wo, wo n ga syã ke fla na. U myaha ba kẽ Menasũũ, u naa n yi Syiper wo. U pye Yesu kãndeyãrfua, le yale ba dey. ");
INSERT INTO xrb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Too ga dye Yurusalɛm wo, pe Yesu kãndeyãrfa n wo wãã nuhu ne. ");
INSERT INTO xrb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ke yĩŋsyii wo, Pɔl n ka wo ne Syake kaha wo; pe Yesu kãndeyãrfa yawãhãfa yahaseefa ba pe ya wãã ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔl n pe syar. Mpãy pe wee Yiifee- ye, tuu ba tẽn lii tẽ pe nsoho wo Yãhã kãmay na, u n koo byɛ tɔ̃r pe yahaseefa mii ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pe u kaplãŋ luhu kua, pe n Yãhã sey. Loo kur ye, pe n Pɔl pye ma yee: «Ma ma wo Yesu kãndeyãrwɛ; ma cã wo fla na nwo, Yiifee- mpãy pe Yesu ta pe Yatɛr, pe nihi tɛr, pe yɛ̃ saha cã ye. Faale kãnde lii Yãhã ke cãã bii le ta ma le le soho Musa koho wo, pe byɛ pua yaha le na. ");
INSERT INTO xrb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Waa ma gblaha poo Yiifee- mii ne ma yee, a Yiifee- mpãy pe ma pe wlãhã nii ter raafa ne, mboo pe byɛ klaha, pe le Musa kãnde miy yaha, pe ma n naa pe pii kũũ ye, pe ma n Yiifee- wãlɛ kãnde yãr nantãŋ ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Waa pye mii pe n cã ma sẽ le syi pãã ye? Taa nwo, ma pa, pe ga le luhu. ");
INSERT INTO xrb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Yãŋ, too ga ma yar mii, pye koo syi! Ma sẽ yãã, naam resyar mpãy ma wo ne nwo, pe yɛ̃ gbe Yãhã ye ma nii ke wũhũ pye. Te plii tã wa pe n ga wãn boo Yãhã kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Le Yiifee- kãnde na, nawee- yai pe lii pye, ka, maa le pye pe ne, ye n nii gbɛgbɛ. Ka maa war yi, ma te kaboo wãn par pe kẽ, pe n pe yĩy kur, ke yɛ̃ wãgbe wĩĩ n kua. Loo na, nawee- byɛ ga cã pe yee, pe lii pãã ma wĩĩ na cĩĩnde sẽ ne ye. Pe maha cã, mboo gɛ sẽ Musa kãnde wũhũ sye ye. ");
INSERT INTO xrb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yesu kãndeyãrfa mpãy na, pe wee Yiifee- ye, wo saba yrũhũ nɔ wãã pe kẽ, ma pe yar kai- nkãy ne pe yai pe naa n pye. Pe ma n naa mpar kaboo wãn kaa ye. Pe ma n naa ntãŋ kaa ye. Kla gii pe sẽ ke kuãy ye, pe ma n ke kar kaa ye. Tesẽ, pe ma n naa tyatyãhã pye ca kuɛ ye tesẽ naam kuɛ ye ye.» ");
INSERT INTO xrb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Loo na, Pɔl n pe naam resyar yigi ga pe ga Yiifee- kãnde wũhũ pye, pe n nii gbɛgbɛ. Loo kur ye, u n ka Yãhã kangbãŋ wo u Yãhã yũndefa yĩŋfua fla na, u nawee- yar pe yɛ̃ wãgbe plii ga kua per gii wo, u n waha diŋ yi pe nawee- resyar mii nanem byɛ myaha ne. ");
INSERT INTO xrb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Te yɛ̃ wãgbe plii kuasĩĩ naa n gaha kuasaha wo, Yasyi kuɛ kãntraha Yiifee- n Pɔl yãã Yãhã kangbãŋ wo te diŋ wãn war kẽsaha wo. Pe n pe nabuar sũũ, pe Pɔl yigi. ");
INSERT INTO xrb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Pe n nii n tẽ ma yee: «Yiisrɛfa, -ye ba wo sya yaha! Dya wii tuu Yiisrɛfa wãpee pãã n tay teebɛhɛ byɛ wo, ma suhu Musa kãnde wãpee ne tesẽ Yãhã kangbãŋ nge wãpee ne, u nwo. Mpãy pe wee Yiifee- ye, pe sẽ yai pe dye Yãhã kangbãŋ teelii wo ye, u nwo yagaa tuu pe gbe ba le koo teele wo, ma ke wĩĩ pye klaha- Yãhã yĩnde na!» ");
INSERT INTO xrb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Toofĩĩ wii u n yi Yefɛsyi wo, pe ba u yãã Pɔl ne le klo laam wo, loo ne pe n naa koo kaplãŋ pãã, ma naa le ga, Pɔl ba dye u ne Yãhã kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ke gbleŋ n ka le klo teebɛhɛ byɛ wo, nawee- n yi teebɛhɛ byɛ wo ma fã ba. Pe n Pɔl yigi, ma u fle yi ke Yãhã kangbãŋ wo, ma te nwonyɛ̃r byɛ tã tã. ");
INSERT INTO xrb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pe naa n kɛ pe Pɔl boo; loo yale wo, Wɔrmefa seraasyi yĩŋfa yĩŋfuangbãŋ n le luhu, a gbleŋ ma ke yir Yurusalɛm byɛ laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Le yalebya wo, u n seraasyi yĩŋfa mpãy tyɔ̃r yi ma suhu seraasyi mpãy ne, pe n wãã kũn ga pe ya na pe nabuar fla na. Pe u yĩŋfuangbãŋ yãã pe seraasyi ne, pe n tyii Pɔl wãgbãŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Loo na, u seraasyi yĩŋfuangbãŋ n yũhũ crã Pɔl na ma ta pe n u yigi, ma u pua ntẽn wãn ne. U n u yey yoo kẽ u ne tesẽ u nwa pye pe n u yigi. ");
INSERT INTO xrb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pe nabuar laam wo, nawee- byɛ naa n tẽ; mii ma pe nde pãã, mii ma pe laa ter pãã. U seraasyi yĩŋfuangbãŋ sẽ waha naa laa war ke wlãhãwlãhã nge laam wo ye. U n ta pe n Pɔl yigi ga ke seraasyi kangbãŋ laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pɔl tuu ga nɔ pe ne ke seraasyi kangbãŋ dugudyesaha fla na, pe seraasyi n gblihi laa ma u tẽŋ, pe nabuar tee ba pee tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Pe byɛ naa n taha u na ma naa n tẽ ma yee: «-Ye u boo!» ");
INSERT INTO xrb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Yaliile pe ba dugu wa, ma yee pe ga dye Pɔl ne ke seraasyi kangbãŋ wo, Pɔl n u seraasyi yĩŋfuangbãŋ pye jrɛke yor wo ma yee: «N ga waha laa pãã la ma ye?» U yĩŋfuangbãŋ n u yey ma yee: «Ma waha jrɛke yor pãã kɛ? ");
INSERT INTO xrb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ke yagaa nge na, Syipte naa wii tuu nawee- ta pe n wãhã yir le klo yahaseefa ne, ma naboofa nyersĩĩ yigi ga dragba wo, ndoo cã woo sẽ kẽ ma ne ye rɛhɛ?» ");
INSERT INTO xrb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pɔl n u yɛ̃ sya ma yee: «Syipte naa sẽ kẽ ra ne ye. Yiifee naa kẽ ra ne, n see Tarsu na Sersyi kãntraha na; kungbãy laa kẽ. N ma nar, tyii ra n waha pãã pe nabuar ye.» ");
INSERT INTO xrb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","U seraasyi yĩŋfuangbãŋ n le sya u ye. Pɔl n yɛr ke kangbãŋ dugudyesaha ncaha ye, ma koho yãhã wãã pe nawee- ye. Yaliile pe ba yaha le, Pɔl n kapãn gbe yebɛrɛ yor wo ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Yii mpãy ye ma ra nampyeŋ- tesẽ ra tuhufa ne, -ye luhu ra ye, n ga ra wĩĩ pãã ye ye, ye n cã, n sẽ laa gɛ tee pye ye.» ");
INSERT INTO xrb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pe nabuar pe yãã u n pãã pe ne pe klo yor wo, loo n ta pe n gbihi yaha le. Loo na, Pɔl n pe pye ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Yiifee naa kẽ ra ne, n see Tarsu na Sersyi kãntraha wo, n lɛ nwo wo, Yurusalɛm wo, Kamayɛl woo u pye ra klahafua, ma wo wãlɛ kãnde gbihi yar ra na. Ta bya, n sẽ ba fãy sya Yãhã tẽn wĩĩ na mii ye dyaŋ nanga ye. ");
INSERT INTO xrb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mpãy pe naa Yĩŋfua Yesu kãnde yãr, n naa pe nuhu yĩntayãhã ne, ma sya naa pe boo. N naam mpãy yigi ca mpãy ne, maa pe le nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","U Yãhã yũndefa yĩŋfua ma suhu pe wãlɛ ne, pe ga waha ye yar, cĩĩnde ne tẽ n pãã. Per gaa, pe saba mpãy yrũhũ wãã ra kẽ, n ga wãã Damasu Yiifee- kẽ ma yee, ndoo ma n n gaha ke fla Yesu kãndeyãrfa yigi, n pa pe ne Yurusalɛm wo, pe n ba pe pẽn. ");
INSERT INTO xrb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","N pye n naa n yãr kãnde wo, ma sya ba gbe taha Damasu na. Le pye yaiwlaŋ yale. Yalaale wo, cãã- mpãy n fe gbe yi yãhãyĩŋ na ma ba n yɛhɛ ra na palpal. ");
INSERT INTO xrb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ta n too kãntraha na ma luhu yĩmbui laa ne, le ra pye ma yee: ‹Sɔl, Sɔl, n lii wãpee pye, ma n nii ra nuhu yĩntayãhã ne?› ");
INSERT INTO xrb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ta n yey ma yee: ‹Yĩŋfua mboo wii raa n pãã, ma myaha mii?› Le yĩmbui n ra pye ma yee: ‹Ndoo Nasarɛtefa Yesu kẽ taa n nuhu yĩntayãhã ne.› ");
INSERT INTO xrb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mpãy pe pye ra ne, pe ba pe cãã- yãã, yĩmbui lii le -sẽ naa n pãã ra ne, pe sẽ naa ke kaplãŋ war ye. ");
INSERT INTO xrb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Loo na, ta n yey ma yee: ‹Yĩŋfua, n yai n lii pye?› Yĩŋfua n ta pye ma yee: ‹Yir, ma ka Damasu na. Yãhã yee taa ga lii pye, pe n pai ma yar le ne ke fla na.› ");
INSERT INTO xrb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pe cãã- palpal ke ba gboho tɛr, ma ba ra ta ra n fũũ, ta nampyeŋ- n ta yigi koho na, ma ka ra ne ke Damasu na. ");
INSERT INTO xrb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Dya waa pye ke fla na, u myaha ba kẽ Nanayase. Yãhã wĩĩ ba gboho u laam wo, u naa Yãhã kãnde kataŋ yãr kayi ne. U wĩĩ naa n tãy Damasu Yiifee- byɛ ye. ");
INSERT INTO xrb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","U n pa ra fla na, maa tege nii ra tãy, ma ra pye ma yee: ‹Sɔl, ma ma Yesu kãndeyãrfua ra ne wãcɛŋ. Naa n yãŋ ma yĩmpɛ ne, ma faale dyaŋ!› Le yalebya wo, ta n waha n yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","U n maha yee: ‹Wo wãlɛ Yãhã kẽ ke ma cãã yãŋ yi, ma ma ta ma n waha ke laam wĩĩ cã. Wii ya u sroŋ, Yãhã ma ta ma n u yãã, ma maha u yɛ̃ kapãn luhu. ");
INSERT INTO xrb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Taa lii yãã ma maha lii luhu ndityɛ ne, mboo raa koo cã. Yãhã yee, ma koo tɔ̃r yar nawee- byɛ na. ");
INSERT INTO xrb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yagaa, maa maha nwa sẽŋ? Yir, pe n ma tãã yi loho wo, -taa naa Yĩŋfua Yesu nar u n ta Yãhã n ma kapee- laha kãã ma na.› ");
INSERT INTO xrb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Loo kur ye, per gaa Yurusalɛm wo, n ba nii naa n pãã Yãhã ye Yãhã kangbãŋ wo, ma yãã mii wãytãã dyaŋ ra na. ");
INSERT INTO xrb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ta n Yĩŋfua Yesu yãã u n ta pye ma yee: ‹Yir farfar, ma yi kãã Yurusalɛm wo, taa lii pãã ra wĩĩ na, pe klofa sẽ n pai le sya ye.› ");
INSERT INTO xrb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ta n u yɛ̃ sya ma yee: ‹Yĩŋfua Yesu, pe le cã laha ma yee, mpãy pe naa ma kãnde yãr, n naa n gaha Yiifee- yawãhã nwey wo maa pe yigi naa n tã nwompihi wo, ma naa pe gbã. ");
INSERT INTO xrb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Yɛtyɛn wii tuu ma wĩĩ cã, pe naa u boo per gii, ta bya pye. N ba yee u boofa ma tẽyĩĩ na, ma sya ba pe nayrɛ sya maha yigi pe kẽ.› ");
INSERT INTO xrb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Loo naa byɛ ne, Yĩŋfua n -sẽ ra pye ma yee: ‹Ka, n ga ma lɛhɛ wãã deydey mpãy ter kuɛ ye, mpãy pe wee Yiifee- ye.› » ");
INSERT INTO xrb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pe nabuar n Pɔl kaplãŋ ngĩĩ byɛ luhu ga kua; pe n maha sye, ma nii n tẽ ma yee: «-Ye dya nwo yigi kãã nawee- yahasee ye! -Ye u boo! U sẽ yai u kuee yrãŋ na ye!» ");
INSERT INTO xrb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pe naa n tẽ, ma pe nayrɛ yãhã naa n wãã, ma tẽyãhã pãã kuee miy naa n wãã ncaha ye. ");
INSERT INTO xrb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","U Wɔrmefa seraasyi yĩŋfuangbãŋ n yee, pe Pɔl yigi dye ke seraasyi kangbãŋ wo, pe u gbã u n le cĩĩnde pãã, lii le ta pe nabuar n nii n tẽ u wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Pe n u pua, ma yee pe ga u gbã sãngblã ne. Seraasyi yĩŋfua wii u pye ke fla na, Pɔl n u pye ma yee: «Wii u ma Wɔrme naa, ye ga waha ta tɛr la ye naa u gbã, mii ye sẽ u sãhã gɛ sãhã wa laa ne ye? Loo kãnde ma la ye ye?» ");
INSERT INTO xrb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","U seraasyi yĩŋfua tuu kaplãŋ ngĩĩ luhu, u n ga le pãã u yĩŋfuangbãŋ ye ma yee: «Ah maa le pye mii? Wɔrme naa kẽ dya nwo ne!» ");
INSERT INTO xrb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","U yĩŋfuangbãŋ n yir, ma pa Pɔl fla na, maa u yey ma yee: «Ta yar, Wɔrme naa la ma ne?» Pɔl n u yɛ̃ sya ma yee: «Ãwã». ");
INSERT INTO xrb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Loo na, u seraasyi yĩŋfuangbãŋ n yee: «Ndoo, n wangbãy yi pe n cã ra ta Wɔrme naa.» Pɔl n yee: «Ndoo woo na, n see Wɔrme naa.» ");
INSERT INTO xrb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Le yalebya wo, mpãy pe ne ga u gbã pe u ta u n pãã, pe n tyii u na, ma yũhũ kãã. U seraasyi yĩŋfuangbãŋ tuu ba cã Pɔl ma Wɔrme naa, u n fya. U tee ba ta pe n u pua ntẽn wãn ne. ");
INSERT INTO xrb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","U seraasyi yĩŋfuangbãŋ naa n traha u cã, Pɔl kai lii pye pe Yiifee- n nii u kɛ yĩntayãhã ne. Loo n ta ke yĩŋsyii wo, u n ta pe n te ntẽn wãn sãhã kãã u na, ma dur ma pe Yiifee- yahaseefa wãã, pe Yãhã yũndefa yĩŋfa, ma suhu pe kaplãŋ cɛrfa ne. U n Pɔl yigi ga ta pe yahasee ye. ");
INSERT INTO xrb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔl n yĩntaha sroŋ pe yawãhãfa ne, ma pe pye ma yee: «Ta nampyeŋ-, n ta troho tãhã Yãhã yahasee ye; kai- nkãy tẽ cã ke sroŋ, n naa koo pye, ma sya ba waa yagaa na.» ");
INSERT INTO xrb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","U Yãhã yũndefa yĩŋfua myaha ba kẽ Nanayase. Mpãy pe pye Pɔl tãy, u n yee pe Pɔl gbã ke yɛ̃ na. ");
INSERT INTO xrb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pɔl n -sẽ u pye ma yee: «Yãhã gɛ kẽ, ke ga mboo gbã, ma mii ta naweeyɔ̃ draha wo, ma laam -sẽ wo ma pee. Taa nwo, raa tege nii nwo, pe sẽ yee la, ma ra sãhã Yãhã kãnde na? Taa -sẽ yee pe ra gbã, ma Yãhã kãnde plaha!» ");
INSERT INTO xrb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mpãy pe pye Pɔl tãy, pe n u yãŋ yĩhĩ ne ma u pye ma yee: «Ma sẽ cã la Yãhã yũndefa yĩŋfua kẽ raa n tyɛhɛ!» ");
INSERT INTO xrb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔl n pe yɛ̃ wãã sya ma yee: «Ta nampyeŋ-, n sẽ ba cã woo kẽ Yãhã yũndefa yĩŋfua ye. N cã ma yee, le ma le yrũhũ yaha Yãhã sabangbãŋ wo ma yee: ‹Ma sẽ yai ma ma klofa yĩŋfua wãpee pãã ye.› » ");
INSERT INTO xrb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔl ba cã ma yee, pe yawãhãfa pye Sadusyɛ̃ tesẽ Farisyɛ̃ ne. Pe kaklaha ter sẽ ba wãã le ye. Loo ne, Pɔl n le gbey pãã yi pe ye ma yee: «Ta nampyeŋ-, n ma Farisyɛ̃, Farisyɛ̃ naa dya kẽ ra ne. N n yee, nakur ga ba yir gbã wo pe dur nii yrãŋ na, loo ne pe ra sãhã.» ");
INSERT INTO xrb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tuu koo pãã, pe Sadusyɛ̃ tesẽ pe Farisyɛ̃ ne, pe n gbe kaplãŋ wãtyĩn na pe ya nsoho wo, ke yawãhã n la cɛr flɛ sĩĩ. ");
INSERT INTO xrb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadusyɛ̃ n yee, a ku sẽ n pai yir pe nii yrãŋ na ye, ma maha n yee, a yãhãyĩŋ tẽnlɛhɛ wee ye, ngii pe n yee sãndũũ woo bya wee ye. Pe Farisyɛ̃ -sẽ mii, poo n yee koo katɛ- tãã ngĩĩ byɛ ma. ");
INSERT INTO xrb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kaa naa n taha pe nawee- gbleŋ na, Yãhã kaiyarfa mpãy pe -sẽ pye Farisyɛ̃ ye kuɛ ye, pe n yir ma le sye waha ma yee: «Wo sẽ laa kapee yãã dya nwo yĩŋ na ye. Sãndũũ waa ga pye u laa pãã u ye, laa na yãhãyĩŋ tẽnlɛhɛ waa syi!» ");
INSERT INTO xrb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ke kaplãŋ wãtyĩn yĩntaha n ba kã pee, u Wɔrmefa seraasyi yĩŋfuangbãŋ n sya fya, ma yee pe ga Pɔl yoho pye klaha-. U n ta u seraasyi ye n tege ga ke yawãhã fla wo, maa Pɔl yigi yi pe nawee- nsoho wo, ma dur ba u ne ke seraasyi kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Koo per yĩmper wo, Yĩŋfua n u ya yar Pɔl na, ma u pye ma yee: «Mii plãhã, tẽ kai- nkãy pye tɛr, ma n ke yãã yĩnde ne, tesẽ nkãy ne taa luhu ndityɛ ne, ma ke pãã Yurusalɛm wo nwo. Ma yai ma ka, maa ke pãã Wɔrme bya wo.» ");
INSERT INTO xrb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ke yĩŋsyii sukũhũntãy na, Yiifee- mpãy n laa pãã ta: Pe ba yɛ̃ tɛr ma yee, poo saa ngaa di, pe saa maha ngaa wɔ mii poo sẽ Pɔl yãã boo wa ye. ");
INSERT INTO xrb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mpãy pe ba loo pãã ta, pe ba tɛr nawee- gbeesĩĩ yaha. ");
INSERT INTO xrb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pe n ka Yãhã yũndefa yĩŋfa fla na ma suhu wãlɛ ne, maa pe pye ma yee: «Wo yɛ̃ tɛr ma le pãã waha ma yee, wo saa ngaa di mii, wo sẽ Pɔl yãã boo wa ye. ");
INSERT INTO xrb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yii ma suhu pe kaplãŋ cɛrfa byɛ ne, ye ga le pãã u Wɔrmefa seraasyi yĩŋfuangbãŋ ye ye yee, ye n traha ye Pɔl wĩĩ gbihi sroŋ yãŋ Yãhã kãnde na, u u yi wãã ye kẽ. Wii -sẽ ga wii gbihi ta, wo u boo kãnde wo, u saa nɔ gɛ nɔ nwo ye.» ");
INSERT INTO xrb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pɔl syafua dya n loo kapãn nde yãã luhu. U n ka ke seraasyi kangbãŋ wo, maa Pɔl yar le ne. ");
INSERT INTO xrb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Loo na, Pɔl n seraasyi yĩŋfua waa yee ba, maa u pye ma yee: «Ka naanfuɛ̃ nwo ne u seraasyi yĩŋfuangbãŋ fla na, u n gaha laa pãã u ye.» ");
INSERT INTO xrb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","U seraasyi yĩŋfua n ka u ne pe yĩŋfuangbãŋ fla na, maa u pye ma yee: «Pɔl wii u ma nwompihi wo, woo u yee, n pa naanfuɛ̃ nwo ne ma fla na, u n ba laa pãã ma ye.» ");
INSERT INTO xrb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","U seraasyi yĩŋfuangbãŋ n u naanfuɛ̃ yigi koho na, ma ka u ne kãnkãy na, maa u yey ma yee: «Ma yee maa lii pãã ra ye?» ");
INSERT INTO xrb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","U n u yɛ̃ wãã sya ma yee: «Pe Yiifee- ma pe pãã ta, poo n pai ma nar, ma ka Pɔl ne sukũhũ sukũhũntãy na, pe yawãhã yĩŋfa fla na, a ter poo n traha pe u wĩĩ gbihi sroŋ yãŋ Yãhã kãnde na. ");
INSERT INTO xrb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Maʼa n pe kapãn sya cĩĩnde ye! Ma sẽ yãã, poo mpãy ga ba wũhũ kãnde wo, pe u yigi boo; pe tɛr nawee- gbeesĩĩ yaha. Pe yɛ̃ tɛr ma yee, poo saa ngaa di, pe saa ngaa wɔ mii pe sẽ u yãã boo ye. Yagaa, pe pe ya gbihi ta wa, mboo yɛ̃ kapãn ya pe n sẽŋ.» ");
INSERT INTO xrb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","U seraasyi yĩŋfuangbãŋ n u naanfuɛ̃ pye, u ma n kapãn nde pãã waa ye ye, ma kãnde wãã u kẽ, u n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Loo kur ye, u seraasyi yĩŋfuangbãŋ n u seraasyi yĩŋfa syãm mpãy yee ba, maa pe pye ma yee: «-Ye seraasyi kurɛ wãã, tesẽ seraasyi mpãy ne pe n dugu nsyãy na, poo nawee- gbeetãã sẽnsye, tesẽ seraasyi kurɛ mpãy ne sãŋ ne pe kluɛ wo. Pe byɛ ma wãã le seraasyi yĩĩsyãm gbeetãã sẽnsye. Ye byɛ -ye yii gbihi poo seraasyi mii ne, nanga yĩmper wo, yaa ka Syesarɛ wo. ");
INSERT INTO xrb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","-Ye nsyãy taa gbihi, ye Pɔl gbe ga wãwee wo kuɛ kãntraha yahaseefua Felise fla na.» ");
INSERT INTO xrb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","U n maha saba nwo yrũhũ ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Ndoo Klode Lesyase, n syaha nɔ wãã mboo nangbãŋ Felise kẽ, mboo wii taa ma ke kãntraha yahaseefua. ");
INSERT INTO xrb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yiifee- ba dya nwo yigi, ma yee poo ga u boo, ta n ba le cã ma yee, Wɔrme naa kẽ u ne, ta n nii le le wo, ndoo tesẽ ra seraasyi ne, ma u sya yaha. ");
INSERT INTO xrb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","N ba yee ndoo ga cã, pe naa u wãboo wĩĩ kɛ yĩŋ gii na, ma u yigi ga pe yawãhã yĩŋfa fla na. ");
INSERT INTO xrb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ta n ga yãã pe ya koho Yãhã kãnde wĩĩ ne, pe naa u kɛ wãboo ne. Le sẽ nii mii kai laa u tee pye, le n nɔ u wãleŋ na nwompihi wo, u wãboo wĩĩ syi ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Loo kur ye, ta n ba le luhu ma yee, Yiifee- ma, pe pãã ta poo ga u boo. Ta n ta tɛr yee, ndoo ga u nɔ wãã ma fla na, ma maha pe Yiifee- yar, tuu lii pye wãpee, pe ba le pãã ma ye.» ");
INSERT INTO xrb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tuu ba pe seraasyi yar pe pye mii, pe n pye koo syi: Pe n Pɔl yigi koo yĩmper bya wo, ma ka u ne Yããmpaterse gɛ na. ");
INSERT INTO xrb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ke yĩŋsyii wo, seraasyi mpãy pe pye trɛ na, poo n dur ga ke seraasyi kangbãŋ wo, pe nsyãyfa n ta tɛr Pɔl ne ke yrãhã ye. ");
INSERT INTO xrb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pe nsyãyfa pe ga nɔ Syesarɛ na, pe n u saba wãã kãntraha fãngafua kẽ, ma Pɔl le soho u koho wo. ");
INSERT INTO xrb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","U kãntraha fãngafua n u saba kal, ma dur, ma Pɔl yey u n yi na. Tuu le luhu u n yi Sersyi kãntraha na, ");
INSERT INTO xrb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","u n u pye ma yee: «Mpãy pe yee ma kapee pye, pe maa pa wa, n ga cã ba ma yey kai- ne.» U n yee pe Pɔl le yaha faale fãngafua Yɛrɔte kangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Plii bua kur ye, u Yãhã yũndefa yĩŋfua Nanayase n pa Syesarɛ wo, ma suhu wãlɛ mpãy ne, ma suhu kasãhãfua waa ne, u myaha Tɛtuhu. Pɔl u kapee lii pye, pe n ka pe n gaha le pãã u kãntraha fãngafua Felise ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pe n u Pɔl yee ba. Tɛtuhu n gbe, ma nii ke kai- pãã n taha Pɔl na u Felise ye ma yee: «Wo nangbãŋ, mboo kãmay na, wo ma yrĩŋ na, kacãn wee ye. Ma kacãn tẽn kãmay na, ma ta pe n kai- wã klaha pe kãntrahafa kur byɛ wãyɔ̃ wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Koo ngĩĩ byɛ too n yãã yalebyɛ teebɛhɛ byɛ wo, ke wĩĩ sẽ n faha wo na ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","N sẽ n traha n ma yigi yaha kaplãmbuar ne ye, n ma nar, ma yɔ̃ wo na, ma le kapãngbɛrle luhu wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Wo ba le yãŋ cã, ma yãã dya nwo tẽn pee: U kai- wlãhã driyɛ̃ Yiifee- kur byɛ nsoho wo, ma pe ta pe n cɛr pe ya na. Nasarɛtefa pe ma yĩmbui nen na pe kãmpee lii wo, woo u ma pe yĩŋfua. ");
INSERT INTO xrb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","U sya ba yee woo ga ke Yãhã kangbãŋ wĩĩ pye klaha- Yãhã yĩnde na, wo n u yigi. Wo ba yee, wii ga u sãhã wo kãnde na, ");
INSERT INTO xrb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","u seraasyi yĩŋfuangbãŋ Lesyase n ba u tyĩn sya wo kluɛ wo, fãnga na. ");
INSERT INTO xrb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Mpãy pe yee u kapee pye, Lesyase n ba yee pe pa ma fla na. Maʼa dya nwo yey, mboo gɛ maa cã ma yee, too yee u kapee- nkãy pye, cĩĩnde ne.» ");
INSERT INTO xrb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pe Yiifee- wãlɛ n yee, u dya tuu nkãy pãã taha Pɔl na, ke byɛ ma cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","U kãntraha fãngafua Felise n Pɔl ta u pãã. Pɔl n gbe ma yee: «N cã mboo raa ma kãntraha nge kur byɛ kasãhã yĩŋfua, ke dyɛ- yɛ̃ nihi. Loo ne, ta n ga ra wĩĩ pãã ma ye laanyĩn ne. ");
INSERT INTO xrb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mboo gɛ taa le yãã, tẽ ka Yãhã seysaha wo Yurusalɛm wo, ke sẽ tɛr plii sẽnsye sĩĩ yaha ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","N sẽ kaplãŋ tyĩn waa ne ye. N sẽ maha gbleŋ yir nabuar laam wo ye. Pe sẽ ra yãã yãã koo ngĩĩ pyesaha wo Yãhã kangbãŋ wo, Yiifee- yawãhã nwoŋ ne, klo teelaa fla ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nawee- mii pe yee, n kapee pye, nwa ba le ta cĩĩnde? Pe ga waha koo kla yar la ma na yagaa? ");
INSERT INTO xrb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lii rẽ cã, loo ne tẽ ga pãã ma ye: N wo wãlɛ Yãhã tẽn tẽ le kãnfuɛ̃ na, kãnfuɛ̃ lii Yesu le yar wo na. Poo n yee, le wee cĩĩnde ye. Kãnde lii Yãhã le ta, ma suhu pe faale Yãhã kaplãŋ tɔ̃rfa kaplãŋ ne, koo ngĩĩ ke yrũhũ le yaha Yãhã sabangbãŋ wo, n cã cĩĩnde wũhũ kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tẽ koho taha yaha lii na, poo bya gɛ koho taha yaha loo wĩĩ nen ya na ma yee, nawee- byɛ, pe wãyɔ̃m tesẽ pe wãpee- ne, pe byɛ ga ba yir gbã wo, pe nii yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Loo ne, ta n nii plãhã, lii le sroŋ Yãhã ye nawee- ne, n loo pye, ta laam n nii ra ye tee nen wo. ");
INSERT INTO xrb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","N ba dyɛ- nkãy pye, n sẽ pye Yurusalɛm wo ye. Ta n dur ba ndoo n pai ra klofa koho soho wale ne, n maha diŋ yi Yãhã kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","N pye nawee- mpãy yɛ̃ wãgbe wĩĩ na Yãhã kangbãŋ wo te diŋ wãn war kẽsaha wo, pe n ba ra yãã ke fla na. Nabuar sẽ pye ra ne ye, ngaa gbleŋ sẽ maha pye ke fla na ye. ");
INSERT INTO xrb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yasyi kuɛ kãntraha Yiifee- mpãy ya pe pye ke fla na. Le ma ne pye n kapee pye cĩĩnde, poo me pe yai pe ne pye ma yaha ye nwo, pe yee n kapee pye. ");
INSERT INTO xrb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Pe kaplãŋ cɛrfa pe ba ra sãhã, le ma pye, pe ba kapee laa yãã ra na, nawee- mii pe -sẽ ma nwo wo, pe le pãã. ");
INSERT INTO xrb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","N le gbey pãã pe yaha ye ma yee: ‹N le sya ma yee, nakur ga ba yir gbã wo, pe nii yrãŋ na, loo ne pe n nii ra sãhã ma yaha ye!› Ma yi kãã loo na, pe sẽ kapee laa yãã ra na ye.» ");
INSERT INTO xrb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felise tuu -sẽ ba Yesu kãnde wũhũ yãã luhu, u n te kasãhã dur ta per gaa na, ma pe pye ma yee: «U seraasyi yĩŋfua Lesyase maa dur ba, n ga ba laa pãã kapãn nde wĩĩ na.» ");
INSERT INTO xrb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Pɔl u pye seraasyi yĩŋfua wii koho wo, Felise n u pye, u maha Pɔl le yaha ke nwongbãŋ wo, tuu -sẽ naa kãnde wãã Pɔl kẽ, u n waha naa kai- nkãy pye, tesẽ u naambiyãm pe waha ba naa u syar, pe waha naa kai- pye u kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Plii raa kur ye, Felise n pa Pɔl yãŋsaha wo u cɔɔ Dursile ne, u pye Yiifeesya. U n ta pe n pa Pɔl ne, u n ba u kaplãŋ luhu Yesu Crise wãta Yatɛr wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nawee yai u naa u troho tãhã mii le n naa n sroŋ Yãhã kãnde na, tesẽ u waha naa n yia u ya na mii, ma suhu Yãhã kasãhã tii ne te n pai, Pɔl n nii koo katɛ- tãã ngĩĩ pãã pe ye. Felise n fya ma yee: «Maa waha ka yagaa. N ma ba draha yãã, n ga ma yee ba.» ");
INSERT INTO xrb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","U maha naa le ga ma yee, laa na Pɔl ga ba war wãã u kẽ, koo kẽ u n Pɔl yee naa n pai, maa naa far yaha u ne yalebyɛ. ");
INSERT INTO xrb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Dyɛ- syãŋ n tɛr, koo syi ya. Loo kur ye, pe n ba Parsyu Fɛhɛtuse ta u n ba pa Felise draha wo, maa nii kãntraha fãngafua. Felise tuu -sẽ naa n traha u Yiifee- laam yĩn, u n tyii Pɔl na ke nwompihi wo. ");
INSERT INTO xrb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","U Fɛhɛtuse n pa koo fla kãntraha wo. Plii tãã n tɛr, u n yir Syesarɛ wo ma ka Yurusalɛm na. ");
INSERT INTO xrb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Koo fla na, pe Yãhã yũndefa yĩŋfa ma suhu Yiifee- yahaseefa ne pe n yir, maa Pɔl wĩĩ pãã u ye ma yee, a u ma u tee pye. Pe n Fɛhɛtuse nar ");
INSERT INTO xrb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","u ta Pɔl n pa Yurusalɛm wo. Pe -sẽ mii, pe ba pãã ta ma yee, poo ga u boo kãnde wo. ");
INSERT INTO xrb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛhɛtuse n pe yɛ̃ wãã sya ma yee, Pɔl ma wa nwompihi wo Syesarɛ wo, woo gɛ ga ba dur tɛr ke fla na yagaa. Pɔl ga kuee ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","U n maha pe pye ma yee: «Ye ma yee dya nwo kapee pye, ye tyii ye yĩŋfa n ka ra ne Syesarɛ wo pe ga le pãã.» ");
INSERT INTO xrb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛhɛtuse n plii kuatãã, plii sẽnsye syi pye pe ne, ma ba dur tɛr Syesarɛ wo. Ke yĩŋsyii wo, u n ga tege nii kasãhã saha wo ma yee, pe pa Pɔl ne. ");
INSERT INTO xrb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔl n pa, Yiifee- mpãy pe ba yir Yurusalɛm wo ma pa, pe n ba wɔ toho u na ma nii kapee- busãã kɛ gbe pãã n taha u na. Pe sẽ -sẽ waha naa le yar, nwa ke ta cĩĩnde ye. ");
INSERT INTO xrb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔl n -sẽ u yɛ̃ kapãn pãã ma yee: «N sẽ laa tee pye yãã Yiifee- wãlɛ kãnde wĩĩ laa kuɛ ye ye, n sẽ laa tee pye yãã Yãhã kangbãŋ wĩĩ laa na ye, n sẽ laa tee pye yãã kãntrɛ fãngafa byɛ yĩŋfua na ye.» ");
INSERT INTO xrb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛhɛtuse tuu ba yee woo ga pe Yiifee- laam yĩn, u n Pɔl yey ma yee: «Ma n traha la ma ka ra ne Yurusalɛm wo, maa sãhã le kapãn na?» ");
INSERT INTO xrb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔl n u yɛ̃ sya ma yee: «Ye ra sãhã nwo wo kãntrɛ fãngafa byɛ yĩŋfua Wɔrme naa kãnde na. Ye yai ye ra sãhã loo kãnde na. Mboo gɛ le cã ma yee, n sẽ laa kapee pye Yiifee- na ye. ");
INSERT INTO xrb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","N ma kapee laa pye, lii le ga waha ra wãboo wĩĩ kua, n saa ra wãboo wĩĩ sye ye. Pe Yiifee- pe yee n kapee- nkãy pye, le ma pye cĩĩnde sẽ kẽ ye, waa saha ra wãã pe kẽ ye. N n traha n ga sãhã kãntrɛ fãngafa byɛ yĩŋfua Wɔrme naa fla na.» ");
INSERT INTO xrb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Loo na, Fɛhɛtuse n wã klaha ma pãã u kasãhã koholefa ne, ma dur ma Pɔl pye ma yee: «Taa yee maa sãhã u kãntrɛ fãngafa byɛ yĩŋfua Wɔrme naa fla na, maa ka u fla na.» ");
INSERT INTO xrb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Plii raa kur ye, yĩŋfua Agiriba n pa u cɔɔ Berenise ne Syesarɛ wo, u n pai Fɛhɛtuse syar. ");
INSERT INTO xrb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Tuu ba plii raa pye ke fla na, Fɛhɛtuse n Pɔl wĩĩ gbe, ma tɔ̃r u ye ma yee: «N pa Felise draha wo ma ba yãã, u tɛr ma dya waa ta yaha nwompihi wo nwo. ");
INSERT INTO xrb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Tẽ ba ka Yurusalɛm wo, pe Yãhã yũndefa yĩŋfa ma suhu pe wãlɛ ne, pe ba pa maa ra pye, a u ma u kapee- pye, a ndoo n u wãboo wĩĩ ta. ");
INSERT INTO xrb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ta n pe pye ma yee: ‹Tee yee nawee kapee pye, pe ma yee pe sẽ kapãn wãã ufua kẽ u n -sẽ u yɛ̃ kapãn pãã ye yĩnde na ye, ye ga waha yee la pe ufua pẽn? Wɔrmefa ye le wee koo syi ye.› ");
INSERT INTO xrb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Loo na, pe n pa ra ne nwo. N sẽ maha taha kuee laa na ye, ke yĩŋsyii bya wo, ta n ga nii kasãhã saha wo, ma ta pe n pa u dya ne. ");
INSERT INTO xrb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Mpãy pe yee u kapee pye, pe n pa. Tẽ naa u dya wĩĩ ga kapee- nkãy syi ne, pe sẽ le syi laa tɔ̃r ye. ");
INSERT INTO xrb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kaplãŋ wãtyĩn ya le pye pe nsoho wo u dya ne pe ya koho Yãhã kãnde wãyãr wĩĩ na, ma suhu waa wĩĩ ne pe n yee Yesu. U Yesu ku, Pɔl n yee u ma yrãŋ na. ");
INSERT INTO xrb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tẽ ne ga kaplãŋ ngĩĩ syi yĩntaha war mii, n sẽ le cã ye, ta n gblihi laa ma Pɔl yey, u ma ga ka Yurusalɛm wo, u ga sãhã koo fla na, le kapãn nde wĩĩ na. ");
INSERT INTO xrb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pɔl n sye ma yee, woo n traha kãntrɛ fãngafa byɛ yĩŋfua n ba laa pãã woo wĩĩ na. Ta n -sẽ yee, pe u tã yaha nwompihi wo, ta n ba u nɔ wãã u kãntrɛ fãngafa byɛ yĩŋfua Wɔrme naa fla na.» ");
INSERT INTO xrb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Fɛhɛtuse tuu pãã wa, Agiriba n u pye ma yee: «Ndoo gɛ n traha u dya n pãã, ra n luhu.» Fɛhɛtuse n u yɛ̃ wãã sya ma yee: «Sukũhũ, maa luhu u yɛ̃ kapãn ye.» ");
INSERT INTO xrb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ke yĩŋsyii wo, nawee- n Agiriba ye wãr ga Berenise ne nangbãŋ wãwãr, pe n ga dye ke kasãhã nwoŋ laam wo, pe seraasyi yĩŋfa ne, ma suhu le klo nangbãy ne. Fɛhɛtuse n ta pe n pa Pɔl ne. ");
INSERT INTO xrb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Loo kur ye, Fɛhɛtuse n kapãn gbe ma yee: «Mboo yĩŋfua Agiriba, ma suhu yii mii byɛ ne, ye sẽ dya nwo yãã. Pe Yiifee- kur byɛ pe ya wãã ba ra fla na Yurusalɛm wo ma suhu tee nde wo, maa yee, a ter u dya kapee pye, u yai wãboo ne. ");
INSERT INTO xrb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ndoo ya dyaŋ, n sẽ laa kapee yãã tuu pye, lii le u wãboo wĩĩ kua ye. Woo gɛ tuu -sẽ yee woo n gaha sãhã kãntrɛ fãngafa byɛ yĩŋfua fla na, n ga ba u nɔ wãã u fla na. ");
INSERT INTO xrb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lii tẽ -sẽ ga yrũhũ nɔ wãã u kãntrɛ fãngafa byɛ yĩŋfua kẽ Pɔl wĩĩ na, n sẽ le cã laha ye. Loo ne, ta n u yee ba yii mii byɛ yahasee ye, tesẽ mboo Agiriba ne, mboo wii raa ma yĩŋfua. Ye ma ba u yey, u n lii pãã, n ga waha laa cã u wĩĩ na, n yrũhũ nɔ wãã u kãntrɛ fãngafa byɛ yĩŋfua kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Maa waha nwompihifua nɔ wãã la waa fla na wãsãhã na, mii kai- nkãy pe pãã taha u na, ma sẽ koo cã laha ma ke yar ufua na ye? Ndoo laam wo, naklãŋ tẽn ne loo ne.» ");
INSERT INTO xrb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiriba n Pɔl pye ma yee: «Maa waha ma yɛ̃ kapãn pãã, kai- ngĩĩ wĩĩ na pe pãã taha ma na.» Pɔl n u koho kuã yir, ma kapãn gbe ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Yĩŋfua Agiriba, pe Yiifee- pe kai- nkãy pãã taha ra na, le tãy ra ye ta n ga waha ra yɛ̃ kapãn pãã nanga ma n luhu. ");
INSERT INTO xrb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Taa nwo, raa Yiifee- wũhũ cã, pe kaplãŋ tyĩn kai- nkãy na, ma maha ke cã, loo ne ta n ga ma nar ma ra kaplãŋ luhu laanyĩn ne. ");
INSERT INTO xrb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ma gbe ra naanfãn cãã na maa waa yagaa na, Yiifee- byɛ ra troho wãtãhã ter cã. N pye ra Yiifeewai ne Yurusalɛm laam wo. ");
INSERT INTO xrb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ta cãyale dey pe ye. Wãlɛ Yãhã kãnde na, n pye Farisyɛ̃ ye ne, poo mpãy pe kapĩĩ wũhũ waha ma ga ta tɛr. Le ma tãy pe Yiifee- ye, poo gɛ ga waha loo pãã ye ye. ");
INSERT INTO xrb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nanga, n nwo pe ra sãhã ma yee, n tee koho taha yaha kayĩĩ lii na Yãhã bii yɛ̃ tɛr wo wãlɛ ye. Loo kayĩĩ ne u Syayahafua wĩĩ ne. ");
INSERT INTO xrb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Pe Yiisrɛfa ter sẽnsye sĩĩ ndefa byɛ loo kayĩĩ nde wãpaŋ yɛhɛ ma nii Yãhã tẽn tẽ pe laam fãnga byɛ ne, ke yai ke yĩmper. Yĩŋfua Agiriba, n koho taha yaha loo kayĩĩ nde na, loo ne pe Yiifee- n yee, ndoo kapee pye. ");
INSERT INTO xrb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ah yii Yiifee-, nwa -sẽ ta ye n yee, ye sẽ le kayĩĩ sya yagaa ye, kayĩĩ lii Yãhã ga ba nakur ta pe n yir gbã wo pe dur nii yrãŋ na? ");
INSERT INTO xrb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ndoo gɛ pye ye wãŋ syi dyaŋ; n naa le ga ma yee, mpãy, Nasarɛtefa Yesu myaha n yi pe yɛ̃ wo, n yai n kai- byɛ pye n pe kar naa n tã loo na. ");
INSERT INTO xrb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Loo gɛ -sẽ ne tẽ naa n pye Yurusalɛm wo. Yãhã yũndefa yĩŋfa ba fãnga wãã ra kẽ, ta n Yesu kãndeyãrfa busãã yigi naa n tã nwompihi wo. Pe ma naa pe wãboo wĩĩ ta, n naa n yee le yɔ̃. ");
INSERT INTO xrb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","N maha naa Yiifee- yawãhã nwey byɛ tay. N ma mpãy yãã pe Yesu ta pe Yatɛr, n ne naa pe pẽn, ndoo ga pe ta pe n yi kãã Yesu kãnde wo. Yiifee- mpãy pe pye nampay kukui wo, ma pye Yesu kãndeyãrfa, n poo byɛ tay naa n nuhu. ");
INSERT INTO xrb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Loo syi laa pyesaha tẽ naa n gaha Damasu na. Pe Yãhã yũndefa yĩŋfa ba loo fãnga wãã ra kẽ, ma ra lɛhɛ loo klo nde wo. ");
INSERT INTO xrb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Yĩŋfua Agiriba, ta n ma yar: N pye kãnde wo ma naa n gaha, le pye yaiwlaŋ yale, cãã- mpãy n fe gbe yi yãhãyĩŋ na, ma ba yɛhɛ palpal ra na, ndoo tesẽ ra yrãhãyãrwai ne. Poo cãã- mii wãyɛhɛ ba tɛr yai wãm yaha. ");
INSERT INTO xrb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wo byɛ n too kãntraha na, ta n luhu yĩmbui laa ne, le ra pye yebɛrɛ yor wo ma yee: ‹Sɔl, Sɔl, nwa ta ma n nii ra ka n nuhu? Maʼa yee ma sẽ tyii ye, ma ga mii duai mii kaha kla dyaŋ ke ne yɛr naan na, ke trɛ fẽŋ ke yigifua kãi na, ke ke ya duai le kãi na.› ");
INSERT INTO xrb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ta n yey ma yee: ‹Yĩŋfua, mboo wii raa pãã ra ne, ma myaha mii?› Yĩŋfua n ta yɛ̃ wãã sya ma yee: ‹Ndoo Yesu kẽ, Yesu wii taa ka n nuhu. ");
INSERT INTO xrb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yir yɛr ncaha ye. N nii yar ma na, ma yee n ga ma ta ra tẽntẽle. Taa ra yãã wãyãã gii na nanga, ma suhu kai- nkãy ne taa n pai yãã yĩnde ne, maa ba naa koo tɔ̃r nawee- ye. ");
INSERT INTO xrb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mpãy pe wee Yiifee- ye, ma suhu pe Yiifee- ne, n ga ba ma sya naa n yaha pe koho wo. Mpãy pe wee Yiifee- ye, n ga ma lɛhɛ wãã pe ye, ");
INSERT INTO xrb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ma n ga kacãn yar pe na, taa pe gbe yi wam wo, ma ka pe ne cãã- fla wo. Tesẽ, ma pe yi kãã Setane sãndãpee yĩŋfua fãnga koho wo, ma pe le soho Yãhã koho wo. Ke syi pe ma ra ta pe Yatɛr, Yãhã ga pe kapee- gbe kãã pe yĩŋ na; pe ga tɔ̃r mpãy ne Yãhã pe yãŋ yi.› ");
INSERT INTO xrb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Yĩŋfua Agiriba, ma yãã, tẽ ba lii yãã wãytãã dyaŋ ma maha ba lii luhu yãhãyĩŋ kuɛ ye, loo ne tẽ n pye. ");
INSERT INTO xrb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N -sẽ cãã le Yãhã kapãyĩĩ pãã Damasu Yiifee- ye ma ba le pãã Yurusalɛmfa ye, Yudɛ kuɛ kãntrahafa ne, ma suhu mpãy ne pe wee Yiifee- ye. N naa pe yar, pe le sya pe yee pe kapee- wãpyeŋ sẽ yɔ̃ ye, pe ke miy yaha, pe pe yĩntaha sroŋ Yãhã kuɛ ye, pe naa kayũhũ pye, nawee- n cã pe kapee- wãpyeŋ miy yaha cĩĩnde. ");
INSERT INTO xrb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Loo ne, yaliile wo tẽ pye Yãhã kangbãŋ wo, pe Yiifee- n pa maa ra yigi, ma naa n traha pe ra boo. ");
INSERT INTO xrb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Yãhã n -sẽ yɛr ra kur ye ma sya ba waa ke nanga nge na, nkãy byɛ tẽ yãã ma suhu nkãy ne tẽ luhu, ta n waha ke pãã wãlɛ ye ma suhu kicar ne. Pe faale Yãhã kaplãŋ tɔ̃rfa ma suhu poo nen wii ne pe naa n yee Musa, pe yee kai- nkãy n pai dye, koo ya kẽ tẽ n pãã, n sẽ maha laa ter pãã n taha loo na ye: ");
INSERT INTO xrb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Pe naa le pãã ma yee, u Yãhã Yĩndefua Crise yai u ba fãy gboho, woo kẽ u ga ba cãã yir gbã wo, u dur nii yrãŋ na gbaafa ye. Cãã- mpãy pe ga nawee- sya yaha, woo kẽ u n pai pe wĩĩ pãã wii Yiifee- ye, ma suhu terfa mpãy byɛ ne, pe wee Yiifee- ye.» ");
INSERT INTO xrb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔl naa u yɛ̃ kapãn pãã Fɛhɛtuse n ba gbey pãã u ye ma yee: «Pɔl, ma fãã! Saba wãcã tẽn ta tɛr ma ne, ma ma fãã!» ");
INSERT INTO xrb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pɔl n u yɛ̃ sya ma yee: «Wo nangbãŋ, n sẽ fãã ye. Kaplãŋ nkãy tẽ n pãã ke ma cĩĩnde, ma maha sroŋ. ");
INSERT INTO xrb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Yĩŋfua Agiriba gɛ kai- ngĩĩ cã, n ga waha naa ke pãã laanyĩn ne, u naa n luhu. N le cã laha ma yee, u ke naneŋ byɛ cã, ke kãnkai- sẽ pye mii waa sẽ yi le cãŋ na ye. ");
INSERT INTO xrb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Yĩŋfua Agiriba, ma laam wo, pe faale Yãhã kaplãŋ tɔ̃rfa pe kai- nkãy pãã yaha, cĩĩnde la ke ne? N cã, ma laam wo cĩĩnde ne!» ");
INSERT INTO xrb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agiriba n Pɔl pye ma yee: «Le kuee car, ma ga ra ta gɛ ta ra n nii Yesu kãndeyãrfua yagaa nge na!» ");
INSERT INTO xrb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pɔl n u yɛ̃ wãã sya ma yee: «Le tãy le pye yagaa woo, le tãy le ma- le cã ba pye, lii rẽ n nar Yãhã ye, mboo tesẽ mii byɛ ne, yii mpãy tee n luhu ra ye nanga, ye nii ra wãŋ syi dyaŋ, n sẽ -sẽ yee pe ba ye le nwompihi wo ye.» ");
INSERT INTO xrb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","U yĩŋfua ma suhu u klo fãngafua ne, Berenise ne, ma suhu mpãy byɛ ne pe pye, pe byɛ n yir ga kãnkãy na. ");
INSERT INTO xrb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pe n ga nii pe ya pye ma yee: «Dya nwo sẽ kapee pye lii le ga waha u wãboo wĩĩ kua, tesẽ u wãtã ne nwompihi wo ye.» ");
INSERT INTO xrb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiriba n Fɛhɛtuse pye ma yee: «Dya nwo ma ne pye u sẽ yee, woo n gaha sãhã kãntrɛ fãngafa byɛ yĩŋfua fla na ye, u ne ga waha miy yaha.» ");
INSERT INTO xrb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Loo kur ye pe n ba yee, waa salangbãŋ gbe wo ka Yitale kãntraha na. Pe nwompihifa ba le soho seraasyi yĩŋfua waa koho wo, u myaha ba kẽ Yuluse. Pɔl pye pe nwompihifa nen waa. U Yuluse pye Wɔrmefa seraasyi ndreŋ gaa yĩŋ na, pe naa ke yee fãngafa byɛ yĩŋfua seraasyi ndreŋ. ");
INSERT INTO xrb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Salangbãŋ gaa ba yir Adarmite wo ma naa n gaha Yasyi kãntraha kui kuɛ ye, kui nkãy ke ma salangbãy yɛrsaha fla ne. Wo n ke gbe ma tɛr. U Maseduan kãntrahafa naa ba pye wo ne, wii pe naa n yee Arisarkɛ. U naa n yi Tesaloni klo wo. ");
INSERT INTO xrb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ke yĩŋsyii wo, wo n ga dye Syidɔ̃ wo. Yuluse ba Pɔl yigi naa n yɔ̃, u n kãnde wãã u kẽ, u ga u naambiyãm yãŋ, wãn tii wĩĩ te pye u na, u ga re sya pe ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Loo kur ye, wo n yir ke fla na. Teflaha ke -sẽ naa wo wãã, wo n klãŋ tɛr Syiper langbeŋ tãy, koo kuɛ ba paha nii ke teflahangbãŋ na. Ke Syiper, kãntraha gaa kẽ muhulangbãŋ ke gbey le. ");
INSERT INTO xrb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ke muhulangbãŋ teelii fla ke ma Sersyi tãy, Pããfile ne, wo n koo fla fã plaŋ, ma nɔ klo laa wo pe naa n yee Mira, le ma Lesyi kãntraha wo. ");
INSERT INTO xrb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Koo fla na, u seraasyi yĩŋfua n salangbãŋ gaa yãã, ke ba yir Lesyããndi wo, ma naa n gaha Yitale kãntraha na. U n ta wo n dye ke wo. ");
INSERT INTO xrb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wo n plii buar pye, ma naa n fã yambaa, teflaha tee naa wo wãã. Wo n ba fãy ma cã nɔ klo laa na pe naa n yee Niide. Teflahangbãŋ ke naa wo wãã, wo saha ka yaha ye ye, wo n gblihi laa ma ka kur kãmaŋ kuɛ ye, ma tɛr Samuni kãntraha tãy, ma ga tɛr Karti kãntraha kuɛ gii ye, ke naa teflaha paha wo na. Karti kãntraha, muhulangbãŋ ke gbey le mii Samuni kãntraha bya dyaŋ. ");
INSERT INTO xrb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Teflaha n maha nii n fua. Ke salangbãŋ wãfãŋ sẽ naa n tãy Karti langbeŋ na ye, wo n gblihi gblihi, ma sya ga nɔ teelaa fla na pe naa n yee salangbãy yɛrsayũhũ. Ke fla pye klo laa tãy pe naa n yee Lasɛhɛ. ");
INSERT INTO xrb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wo ba ma- tɛr ke yrãhã ne. Yiisrɛfa yɛ̃ wãtã yale digi na, too plii ba tɛr wa. Wɛrngbãn cãã ba gbe taha. Koo cãã nge syi draha wo, salangbãŋ wãfãŋ muhulangbãŋ na, kapee- busãã ga waha dye. Loo n ta Pɔl n pe yar waha ma yee: ");
INSERT INTO xrb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Naambiyãm, n cã yrãhã nge ga pee wo na. Kapee- ga ke salangbãŋ dye ke laam wãn byɛ ne. Yaʼa yee ye sẽ cã ye, wii gɛ ga kuee le wo.» ");
INSERT INTO xrb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","U seraasyi yĩŋfua Wɔrme naa sẽ Pɔl kaplãŋ ta kai ye. U naa n luhu ke salangbãŋfua woo ye tesẽ ke fãfa ne. ");
INSERT INTO xrb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Salangbãy yɛrsayũhũ fla sẽ ba yɔ̃ salangbãŋ ke kuee ke fla na wɛrngbãn cãã nge syi na ye. Loo nde n ta pe nawee- busãã mpãy pe pye ke salangbãŋ wo, pe n yee pe tɛr kãã ke fla yaha: Pe naa n kɛ, le ma ga waha pye, pe ga dye Fenise wo, pe kuee ke fla na, wɛrngbãn cãã n tɛr. Salangbãy yɛrsaha gaa ba pye Fenise wo; ke bya pye Karti kãntraha na, teflaha sẽ naa n fua fãnga ne ke Fenise wo ye. Koo fla wɛr sẽ ba pee tɛr ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Per gaa, teflaha gaage ba yir yainde dyetɛr kuɛ kãndigi kuɛ syi ye, ma fua naa n pai. Pe nawee- n yee, laa wee ye, lii poo ga yigi le ga waha pye. Pe n yir ke salangbãŋ ne ma ke Karti kãntraha langbeŋ yɛ̃ sya, ma n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Saa sẽ pye gɛ pye ye, teflahangbãŋ gaa n yir. Pe ke yee yainsaha dar kuɛ kãmaŋ kuɛ teflahangbãŋ. Ke n yir ke kãntraha yãy yĩŋ na, ma fua n pai. ");
INSERT INTO xrb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ke n ke salangbãŋ tra n wãã ke muhulangbãŋ yĩŋ na, ke wãyɛr wĩĩ n wo yia, wo n gblihi laa ma tyii ke n wo gbe n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wo n ga tɛr kãntraha gaage yainsaha dar kuɛ kãndigi kuɛ ye, muhulangbãŋ ke gbey le. Pe naa ke yee Klada. Ke ba faa wo paha ke teflahangbãŋ na. Salampuage gii ke pua yaha ke salangbãŋ na, ke wo fãy wo n cã waha yia ke na. ");
INSERT INTO xrb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ke salangbãŋ fãfa n ke tyĩn dugu ke salangbãŋ wo, ma dur ma namihi nkãy pua maha klaha ke salangbãŋ na ke ma n fe yoho ye. Ke teflahangbãŋ naa ke salangbãŋ teflaha fai fua fãnga ne ma ke tra naa n wãã yainsaha dar kuɛ kãndigi kuɛ ye. Pe naa n fya ma yee, laa na poo n gaha sugu gbãã fãnga ne Libi kãntraha langbeŋ flã mbui laa na le n nii kaklaha-. Pe n gblihi laa ma ke salangbãŋ teflaha fai tege, ma n gaha yambaa. ");
INSERT INTO xrb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ke teflahangbãŋ naa wo yɛhɛ fãnga ne, pe n sya yir ke yĩŋsyii wo, ma ke salangbãŋ teger byɛ gbe miy yi wãã ke muhulangbãŋ wo, ke n waha ta naa n yir loho na. ");
INSERT INTO xrb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Koo yĩŋsyii wo, pe n maha gblihi laa, ma ke salangbãŋ laam wãn taa gbe miy yi wãã. ");
INSERT INTO xrb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Plii buar raa nsoho wo, waa sẽ naa yai yãã, yrompii ne ye. Ke teflahangbãŋ -sẽ maha naa n fua fãnga ne, wo n sya ba yee wo saa yi le wo ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Mpãy pe pye ke salangbãŋ wo, le yale ba dey pe sẽ waha naa ngaa di ye. Pɔl n yir yɛr pe yĩŋ na, ma pe pye ma yee: «Naambiyãm, ye ma ne pye ye yɛr ra kapãn na, ma kuee Karti kãntraha wo, wãfãy nge saa ne wo yãã tesẽ kaklaha- nde ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Yagaa, -ye ye laam waha, waa saa ku ye laam wo ye, ke salangbãŋ ya ke ga klaha-. ");
INSERT INTO xrb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ye sẽ yãã, n ma Yãhã gii wũũ, ma nii tẽn tẽ ke myaha na, koo yãhãyĩŋ tẽnlɛhɛ waa yi ra na ");
INSERT INTO xrb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ma ba ra pye ma yee: ‹Pɔl, maʼa n fya ye, ma yai ma ka kãntrɛ fãngafa byɛ yĩŋfua yahasee ye. Mpãy byɛ pe ma ma ne ke salangbãŋ wo, le tãy Yãhã ye, ke n ga pe byɛ sya yaha.› ");
INSERT INTO xrb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ta naambiyãm, loo ne ta n ye yar, -ye ye laam byɛ sãhã yaha, Yãhã lii yar ra na, n sẽ laalaa pye le ne ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wo -sẽ n gaha sugu gbãã kãntraha gaa langbeŋ na, muhulangbãŋ ke gbey le.» ");
INSERT INTO xrb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Le pye wo yĩmplii sẽnsye resyar wuhu, ke teflahangbãŋ wo gbe naa n tɛr ke muhulangbãŋ teelaa fla yĩŋ na pe n yee Yadria. Yĩndyaha wo ke salangbãŋ fãfa n yãã mii, wo nɔ gbe taha kãntraha gaa na. ");
INSERT INTO xrb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Pe n ntẽn wãŋ gaa miy le wãã ke muhulangbãŋ wo, namii ne ke na ma ke muhulangbãŋ wãcuhu yãã miiter gbey sẽnsye kuasĩĩ koo fla na. Pe n maha ga kaa miy le yahasee ye, ma ke fla wãcuhu yãã miiter gbey tesẽ kuatãã. ");
INSERT INTO xrb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Pe naa n fya ma yee, laa na ke salangbãŋ n gaha sugu gbãã ntẽmblaha syi na kii loho tã tã ke na. Pe n yee poo ga ke salangbãŋ yɛr ma ntẽn wãn taa tege le wãã ntẽn namihi ne ke muhulangbãŋ laam wo ke salangbãŋ kur kuɛ ye wãy resyar, too n ke ta ke n yɛr. Pe n kuee ke fla na, ma nii yĩŋsyii sẽŋ ke syii farfar. ");
INSERT INTO xrb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ke salangbãŋ fãfa -sẽ naa n kɛ pe yi ke salangbãŋ wo, pe fã tɛr. Pe n ke salampuage yi tege le wãã ke muhulangbãŋ wo, ma yee ter poo ga tege, pe ga wãn taa miy le ke muhulangbãŋ wo ke salangbãŋ yahasee kuɛ ye ke n gbihi yɛr. ");
INSERT INTO xrb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pɔl n cã pe ne, ma le pãã u seraasyi yĩŋfua ye, ma suhu pe seraasyi ne ma yee: «Nawee- mii ma yee pe sẽ kuee ke salangbãŋ wo ye, ye saha sya yaha ye.» ");
INSERT INTO xrb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Loo na, namihi nkãy ke ba ke salampuage yigi yaha ke wãngbãŋ na pe seraasyi n ke namihi cɛr ke n tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Yĩŋ wãsyii ba kuee car, Pɔl n pe byɛ yar pe ngaa di, ma pe pye ma yee: «Ke plii sẽnsye resyar nanga tee ma ke salangbãŋ wo, ye sẽ ngaa di ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","N ye nar -ye ngaa di, loo na, ye ga waha fãnga yãã ye sya yaha, waa yĩnyoho neŋ gɛ saa kɛ laa ye.» ");
INSERT INTO xrb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔl tuu koo kaplãŋ ngĩĩ pãã wa, u n bur gbe, ma syaha cãã wãã Yãhã kẽ, ma ke naha ka, ma nii n di. ");
INSERT INTO xrb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Pe byɛ n pe laam sãhã yaha loo na, ma di pe ya ndoŋ. ");
INSERT INTO xrb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wo pye nawee- kurɛ gbeetãã sẽnsye kuay. ");
INSERT INTO xrb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pe byɛ pe ba di yai wa, dir wãn tii te naa ke salangbãŋ ndege, pe n te byɛ gbe miy wãã ke muhulangbãŋ wo. ");
INSERT INTO xrb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Yĩŋ ke ba syii wa, ke salangbãŋ fãfa sẽ waha cã kãntraha gii kẽ ye. Pe n langbeŋ fla gaa yãã ke loho dye ga yahasee ye, ma yɔ̃ nii trahatraha, flã ne ke fla na busãã. Pe n yee poo ga ka yãŋ ke salangbãŋ ne ke fla na. ");
INSERT INTO xrb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Kandege wãn tii pe tege le wãã ntẽn namihi ne ke muhulangbãŋ laam wo, te n ke salangbãŋ yɛr, pe n ke namihi sãhã yaha te wãn ne ke langbãŋ laam wo. Pai tii te ke salangbãŋ sroŋ, pe n maha too byɛ sãhã yaha koo syi. Pe n teflaha fai laa yir ke salangbãŋ ncaha kuɛ syi ye, teflaha n nii ke tra n wãã ke langbeŋ kuɛ ye. ");
INSERT INTO xrb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Pe yĩŋ n pee, ke salangbãŋ n ga fã dye kuee flã mbui laam wo, loho tã tã le na. Ke salangbãŋ yahasee kuɛ n dye kuee u flã mbui wo, ke saha yɛhɛ gɛ yɛhɛ ye. Ke muhulangbãŋ yir naa n pai fãnga ne, ke n ke salangbãŋ kur kuɛ sugu yoho pye klaha-. ");
INSERT INTO xrb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Pe seraasyi n yee, poo ga pe nwompihifa byɛ boo, mii loo sẽ ne ye, pe ga yɛ̃y plaha pe na. ");
INSERT INTO xrb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pe seraasyi yĩŋfua -sẽ naa n kɛ u Pɔl sya yaha, u n sye pe seraasyi ma n le pye ye. U n yee, mpãy pe yɛ̃y cã, pe cãã too pe yɛ̃y ga kãntraha na. ");
INSERT INTO xrb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Mpãy pe sẽ yɛ̃y cã ye, poo -sẽ ga sa tẽmpai na tesẽ ke salangbãŋ katyir wãn taa ne, pe taha pe na. Pe byɛ n waha ka kãntraha na koo syi, kapee laa sẽ waa dye ye. ");
INSERT INTO xrb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Yãhã ke wo sya yaha ke muhulangbãŋ wo ke syi, loo kur ye, wo n cã kãntraha nge, muhulangbãŋ ke gbey le, pe ke yee Malti. ");
INSERT INTO xrb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ke flafa n wo yigi yɔ̃. Sesaha naa n too, wɛr n pye. Pe n naa tar wo kẽ, wo byɛ n ga nii klaha ke tãy. ");
INSERT INTO xrb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔl n nankɔ̃yãhã raa gbe le ke naa laam wo, ke karwran n nwɔpihi gaa ta ke n yi te nankɔ̃yãhã wo, ma sɛŋ kuee Pɔl koho na nkãhã ne. ");
INSERT INTO xrb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ke flafa pe ke nwoho yãã ke sɛŋ kuee Pɔl koho na, pe n nii pe ya pye ma yee: «Naboofua kẽ dya nwo ne. Ye sẽ yãã, tuu sya waha yi ke muhulangbãŋ wo, te nasãhã yee u sẽ yai u kuee yrãŋ ye.» ");
INSERT INTO xrb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pɔl n u koho sege, ke nwoho n too dye ke naa wo, ngaa gɛ sẽ u yãã ye. ");
INSERT INTO xrb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Pe nawee- n yee u ga tẽ, laa na u ku le yalebya wo. Le n ma-, pe n yãã ngaa gɛ sẽ u pye ye, pe n wã klaha ma nii n yee, a yãhã gaa kẽ u ne. ");
INSERT INTO xrb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ke fla kãntraha nangbãŋ kaha sẽ ba dey ke fla ne ye. U myaha ba kẽ Pebuisu. U n wo yigi yɔ̃, ma syãsaha wãã wo kẽ plii tãã. ");
INSERT INTO xrb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Too pye u Pebuisu kaha wo, u tuhufua pye u ba sãy nii. U kadye ba war u ye, tɔgɔtɔgɔni pye u na. Pɔl n ka maa u yãŋ, ma koho taha u na, ma Yãhã nar u n jaa. ");
INSERT INTO xrb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Loo kur ye, koo fla kãntraha yanfa byɛ n pa, Pɔl n pe jaa. ");
INSERT INTO xrb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Pe n nagboho ter byɛ ta wo na. Wo tɛryale n ba nɔ, wãn tii byɛ te wĩĩ ga ba pye wo na kãnde wo, pe n te wãã wo kẽ. ");
INSERT INTO xrb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Salangbãŋ gaa pye ke fla na, pe naa ke yee Dyakuri, ke myaha yĩntaha kẽ wuhuwãã. Ke salangbãŋ fãfa ba wuhuwãã fãã ta ke salangbãŋ yahasee ye, ma yee poo mpar. Koo salangbãŋ nge ba yir Lesyããndi wo, ma ba te wɛr cãã byɛ pye ke Malti kãntraha fla na, ma ba yir koo ga tɛr Yitale kuɛ ye. Wo ba yrey tãã pye wa ke fla na, wo n dye koo salangbãŋ wo, ma tɛr. ");
INSERT INTO xrb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wo n ga dye klo laa wo pe n yee Syirakuse, ma kuee ke fla na plii tãã. ");
INSERT INTO xrb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Wo n yir, ma langbeŋ sya, ma sya ga dye klo laa wo pe n yee Yɛrsyiɔ. Koo yĩŋsyii wo, teflaha naa n yir yainsaha dar kuɛ kãndigi kuɛ ye, ma wo fua naa n wãã, wo n plii sĩĩ ya pye ke langbãŋ yĩŋ na, ma dye klo laa wo pe n yee Pusɔle. ");
INSERT INTO xrb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Too yi ke salangbãŋ wo, wo n Yesu kãndeyãrfa mpãy yãã ke fla na, pe n wo ta wo n kuee poo ne plii kuasĩĩ. Loo kur ye, wo n yir trɛ ne ma n gaha ke Wɔrme wo. ");
INSERT INTO xrb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yesu kãndeyãrfa mpãy pe pye Wɔrme wo, pe n wo wĩĩ luhu. Mpãy n sya wo wãã ba klo laa cãã wo, pe le yee Apyusu. Loo kur ye, mpãy maha ba wo wãã ba klo laa wo, pe loo yee syãsar tãã klo. Pɔl tuu kãhã pe yãã, u n syaha wãã Yãhã kẽ, ma u laam sãhã yaha. ");
INSERT INTO xrb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Too ga dye Wɔrme wo, pe n le sya ma kãnde wãã Pɔl kẽ, u n ga nwoŋ gaa gbe, kaha gaa wo, seraasyi naa waa ne, woo n nii u yãŋ. ");
INSERT INTO xrb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Plii tãã kur ye, Pɔl n Wɔrme Yiifee- yahaseefa yee ba yawãhã na u kaha wo. Pe n ba pe ya wãã, u n pe pye ma yee: «Ta nampyeŋ-, tẽ sẽ laa pye klaha- wo terfa na, ma suhu wo wãlɛ wũhũ ne ye, pe ra yigi Yurusalɛm wo, ma ra wãã Wɔrmefa kẽ. ");
INSERT INTO xrb_vpl VALUE