﻿USE sofia;
DROP TABLE IF EXISTS sofia.xon_vpl;
CREATE TABLE xon_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xon_vpl WRITE;
INSERT INTO xon_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo aamaal ponn ni aayimbil le bi kigbaŋ kee ponn ni. U nan ye Ubɔr David aayaabil la. David mu nan ye Abraham aayaabil. ");
INSERT INTO xon_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham le nan ma Aisak, Aisak mu ma Jakob, Jakob mu ma Juda ni unaabitiib. ");
INSERT INTO xon_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda mu ma Peres ni Sera. Bina aayimbil le nan ye Tamar. Peres mu ma Hesronn, Hesronn mu ma Ram, ");
INSERT INTO xon_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram mu ma Aminadab, Aminadab mu ma Nasonn, Nasonn mu ma Salmonn, ");
INSERT INTO xon_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonn mu ma Boas. Una aayimbil nan ye Rahab la. Boas mu ma Obed. Una aayimbil nan ye Ruf la. Obed mu ma Jese, ");
INSERT INTO xon_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese mu ma Ubɔr David. David mu ma Solomonn. Una nan ye Yuraya aapuu la, le David kpan u. ");
INSERT INTO xon_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonn mu ma Rehoboam, Rehoboam mu ma Abija, Abija mu ma Asa, ");
INSERT INTO xon_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mu ma Jehosafat, Jehosafat mu ma Joram, Joram mu ma Usia, ");
INSERT INTO xon_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia mu ma Jotam, Jotam mu ma Ahas, Ahas mu ma Hesekia, ");
INSERT INTO xon_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia mu ma Manase, Manase mu ma Amonn, Amonn mu ma Josia, ");
INSERT INTO xon_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia mu ma Jekonia ni unaabitiib buyoonn baadim nan faa bi butɔb ki chuu bi buen Babiloŋ na. ");
INSERT INTO xon_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baah chuu bi ki di buen Babiloŋ ni na, nee aapuwɔb le Jekonia ma Sealtiel, Sealtiel mu ma Serubabel, ");
INSERT INTO xon_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel mu ma Abiud, Abiud mu ma Eliakim, Eliakim mu ma Asor, ");
INSERT INTO xon_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor mu ma Sadok, Sadok mu ma Akim, Akim mu ma Eliud, ");
INSERT INTO xon_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mu ma Eleasar, Eleasar mu ma Matann, Matann mu ma Jakob, ");
INSERT INTO xon_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob mu ma Josef, u ye Mari aachal na. Mari mu ma Yesu u bi yin u ke Kristo u ga gaa binib lii na. ");
INSERT INTO xon_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham yoonn ki yoor kina ki ti saa Ubɔr David yoonn na nan ye yaajatiib kipiik ni binaa la. David yoonn ki yoor ki ti saa buyoonn baadim chuu bi ki di buen Babiloŋ aatiŋ ni na nan ye yaajatiib kipiik ni binaa la. Buyoonn baadim chuu bi ki di buen Babiloŋ ni na ki yoor ki ti saa Kristo yoonn na nan ye yaajatiib kipiik ni binaa la. ");
INSERT INTO xon_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Baah ga nan ma Yesu Kristo na, le bi nan puu ke bi ga di una Mari ki di tii Josef. Baa nan kee kunn u, le bi kan ke u kpa lipuul Uwumbɔr Aafuur Nyaan pu. ");
INSERT INTO xon_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uchal Josef aah ye uninyaan na, le waa ban ke u jinn u inimɔɔn. U ŋa nlandak ke u loon ki yii u. ");
INSERT INTO xon_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Waah dakl tibɔr ngbaan kina na, le u kan Uwumbɔr aatuun ubaa tidaŋ ponn ni. Le Uwumbɔr aatuun ngbaan bui u, “Josef, Ubɔr David aayaabil, taa yii ke saan joo Mari u li ye aapuu; ba pu? Uwumbɔr Aafuur Nyaan le tii u lipuul ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U ga maa ubijabo, le aa ga yin u ke Yesu; ba pu? uma le ga nyan waanib baatunwanbir ni.” ");
INSERT INTO xon_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nimina mɔmɔk nan ŋa ke ni gbiin Uwumbɔr aah nan cha waabɔnabr len pu na ke, ");
INSERT INTO xon_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Usapɔɔn u kaa nyi uja na ga nan dek lipuul ki maa ubijabo, bi ga li yin u ke Imanuel.” (Imanuel aatataa le ye ke “Uwumbɔr bi ti chee”.) ");
INSERT INTO xon_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Le Josef finn ki fii le ki nan ŋa Uwumbɔr aatuun aah tuk u ke u ŋa pu na, le ki yoor Mari di ŋa upuu. ");
INSERT INTO xon_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Waa nan doon u chee le u nin ma waajan aabijabo. Le Josef yin u ke Yesu. ");
INSERT INTO xon_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bi nan ma Yesu, Betlehem aatiŋ ponn ni la, ki bi Judea aatiŋ ni na, n‑yoonn mu Herod ye ubɔr na. Baah ma Yesu na, le bilankpalb bibaa nyan ni liwipuul wɔb ki dan Jerusalem, ");
INSERT INTO xon_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ki nan baa ke, “Baah ma ubo u ye Juu yaab aabɔr na, u bi la chee? Ti kan waaŋmabil liwipuul wɔb, le ti dan ke ti nan doon u.” ");
INSERT INTO xon_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ubɔr Herod, ni Jerusalem aatiŋ aanib mɔmɔk aah ŋun tibɔr ngbaan na, le ti muk bi. ");
INSERT INTO xon_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Le u yin Uwumbɔr aatotoorninkpiib ni Uwumbɔr aakaal aamɔmɔkb mɔmɔk, le ki nan baa bi, “Bi ga maa Kristo u ga gaa binib lii na la chee?” ");
INSERT INTO xon_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Le bi tuk u, “Betlehem aatiŋ, ki bi Judea aatiŋ ni na; ba pu? Uwumbɔr aabɔnabr aah nan ŋmee pu na sɔ: ");
INSERT INTO xon_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sin Betlehem aatiŋ, ki bi Judea aatiŋ ni na, saa ye kitiwaatiir Judea aatim ponn ni; ba pu? uyidaan ga nyan aa ponn ni, ki ga li ye Uwumbɔr aanib Israel yaab aayidaan.’” ");
INSERT INTO xon_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Le Herod yin bilankpalb ngbaan libɔɔl ni, le ki baa bi, “Liŋmabil ngbaan nan nyan ni bayoonn?” Le bi tuk u. ");
INSERT INTO xon_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Le u tun bi ke bi buen Betlehem, ki tuk bi, “Li cha man ki ti bee ubo ngbaan aabɔr mbamɔm. Ni yaa ti kan u kan, ni gir ni man ki nan tuk mi, aan m mu buen ti doon u.” ");
INSERT INTO xon_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Waah len kina doo na, le bi siir ki cha. Baah siir ki cha na, le bi kan liŋmabil li bi nan kan liwipuul wɔb na loln bi pu nsan, ki ti fuu ubo ngbaan aah bi nin chee na, le ki sil nima chee paacham. ");
INSERT INTO xon_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Baah kan liŋmabil ngbaan na, le bi kpa mpopiin sakpen ki mɔɔni. ");
INSERT INTO xon_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Le bi koo lidichal ngbaan ni, ki ti kan ubo ngbaan ni una Mari. Bi nan gbaan kitiŋ ki doon ubo ngbaan, le ki chuu piir baataakɔr ki tii u ipiin. Bi nan tii u salmaa, ni tulalee u bi yin u ke frankinsense, ni tulalee u bi yin u ke mir na. ");
INSERT INTO xon_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Le Uwumbɔr nan tuk bi tidaŋ ponn ni ke bi taa ki gir buen ubɔr Herod chee. Nima pu na, bi nan dii nsan yayan le ki kun. ");
INSERT INTO xon_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Baah nan chaa kun na, Josef nan kan Uwumbɔr aatuun tidaŋ ponn ni. Le Uwumbɔr aatuun ngbaan bui u, “Fiin ki yoor ubo ngbaan ni una ki san buen Ijipt aatiŋ ni, ki ti li bi nima ki kiir bundaln m ga nan tuk si ke aa nya nima na. Ubɔr Herod ga li ban ubo ngbaan ke u ku u.” ");
INSERT INTO xon_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","N‑yaayoonn ngbaan le Josef fii le ki yoor ubo ngbaan ni una kinyeek, ki nyan nima ki buen Ijipt, ");
INSERT INTO xon_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ki ti bi nima le Herod ti kpo. Nimina nan ŋa kina ke ni gbiin Uwumbɔr aah nan cha waabɔnabr len pu na, ke Uwumbɔr bui ke, “M yin Maabo ke u nyan ni Ijipt aatiŋ ni.” ");
INSERT INTO xon_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Le Herod bee ke bilankpalb ngbaan ŋmann u la. Le u gee liŋuul sakpen, ki cha waajab ku mbijabim bi mɔmɔk ye ŋibin ŋilee aabim, ni bi mu kaa fuu kina na, ki bi Betlehem, ni Betlehem aatingbaan ni na. U nan baa bilankpalb ngbaan ke bi kan liŋmabil ngbaan bayoonn. Nima le cha u bee Yesu aabin aah saa pu na. ");
INSERT INTO xon_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Waah ku mbim ngbaan pu na, le ni gbiin Uwumbɔr aabɔnabr Jeremia aah nan len pu na ke, ");
INSERT INTO xon_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bi ŋun kifuuk Rama aatiŋ ni, ki ye ikpowiil aafuuk la. Rachel le wii waabim pu, bi mɔmɔk kpo a, le ubaa aan ŋmaa sɔŋ usui.” ");
INSERT INTO xon_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ni bi cha le Herod ti kpo. Waah kpo na, le Josef, u nan bi Ijipt aatiŋ ni na, kan Uwumbɔr aatuun tidaŋ ni. ");
INSERT INTO xon_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Le Uwumbɔr aatuun ngbaan bui u, “Fii ki yoor ubo ngbaan ni una ki gir buen Juu yaab aatiŋ ni. Binib bi nan ban bi ku ubo ngbaan na kpo a.” ");
INSERT INTO xon_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Le u fii ki yoor ubo ngbaan ni una, ki ti fuu Juu yaab aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Le u ŋun ke Ubɔr Herod aabo Akelaus jin ute aanaan Judea aatiŋ ni. Nima pu na, Josef nan san ijawaan, kaa ban u buen nima. Le Uwumbɔr tuk u tidaŋ ni waah ga li cha nin chee na. ");
INSERT INTO xon_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Le u buen kitiŋ kibaa ni, bi yin ki ke Nasaref, ki bi Galilee aatiŋ ni na. Waah ŋa kina na, le ni gbiin Uwumbɔr aabɔnabr aah nan len pu na, ke bi ga yin Yesu ke Nasaref aatiŋ aanii la. ");
INSERT INTO xon_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","N‑yoonn ngbaan le Jɔnn u muini binib nnyun ni na bi nteersakpiin ni, Judea aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","le ki mooni, “Kpeln nimi aabimbin man. Uwumbɔr aanaan peen ni a.” ");
INSERT INTO xon_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uwumbɔr aabɔnabr Aisaya nan len Jɔnn aabɔr ke, “Unii ubaa bi nteersakpiin ni ki tar ke: ‘Toor Uwumbɔr aasan man, ki ŋa waasan mu li tok ki tii u.’” ");
INSERT INTO xon_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔnn nan pee kikpalk ki bi nan di laakumii aakor luu ki na, ki di ligbapapaln buu uchaŋ ni. Waajikaar nan ye itoon ni tisiir la. ");
INSERT INTO xon_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Le binib nyan ni Jerusalem, ni Judea aatim mɔmɔk ni, ni Jɔɔdann aamɔɔl aatingbaan ni, ki dan u chee, ");
INSERT INTO xon_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","le ki nan kpiir baatunwanbir tuk Uwumbɔr. Le Jɔnn muin bi nnyun ni, Jɔɔdann aamɔɔl ni. ");
INSERT INTO xon_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Le Jɔnn kan Farisii yaab ni Sajusii yaab pam dan u chee ke u muin bi nnyun ni. Le u baa bi, “Nimi ijagen aabim, ŋma sur nimi ke ni nya ntafadaan mu choo na ni? ");
INSERT INTO xon_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ni li tun lituln li ga mɔk ke ni sil kpeln nimi aabimbin na, ");
INSERT INTO xon_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ki taa bui ke niyaaja aah ye Abraham na, nima le ga cha ni nyan ntafadaan ni. M tuk nimi la, Uwumbɔr ga ŋmaa di ŋitakpal ŋimina kpaln Abraham aayaabitiib, ");
INSERT INTO xon_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","hali dandana wee Uwumbɔr toor kichɔk ke u ti gaa isui. Isui imɔk kaa lu ŋisubil ŋi ŋan na, u ga gaa i, ki di ŋa mmii ni. ");
INSERT INTO xon_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mma muini nimi nnyun ni la, ki mɔk ke ni kpeln nimi aabimbin. Unii u paa ni m pu na jer mi. Maa ŋeer m chuu takl waanaatak tii u. Uma le ga nan muin nimi Uwumbɔr Aafuur Nyaan, ni mmii ni. ");
INSERT INTO xon_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U joo waayikpimbik uŋaal ni, u ti chaar waajikaar, ki ga di njikaabim ŋa lipil ni, ki di tigbengbir see mmii mu kaan junn na ni.” ");
INSERT INTO xon_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","N‑yoonn ngbaan le Yesu nyan ni Galilee, ki dan Jɔnn chee, Jɔɔdann aamɔɔl ni, ki ban ke Jɔnn muin u nnyun ni. ");
INSERT INTO xon_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Le Jɔnn aa kii, le ki len ke, “Ni ŋan si le muin mi nnyun ni, le aa ban ke m muin si.” ");
INSERT INTO xon_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Le Yesu bui u ke, “Kii kina n‑yoonn mue. Ni ŋan ke ti ŋa Uwumbɔr aah ban pu na mɔmɔk.” Le Jɔnn kii ki muin u nnyun ni. ");
INSERT INTO xon_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Waah muin u doo na, libuul ngbaan ni le Yesu nyan ni nnyun ni. Le kitaapaak chuu piir. Le u kan Uwumbɔr Aafuur Nyaan sunn ni ki naahn linanjel, ki nan tɔŋ u pu. ");
INSERT INTO xon_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Le u ŋun nneel len paacham ke, “Njapɔɔn u m gee u na sɔ. Nnimbil gbiin u.” ");
INSERT INTO xon_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","N‑yoonn ngbaan le Uwumbɔr Aafuur Nyaan cha Yesu buen nteersakpiin ni ke kinimbɔŋ ti tɔŋ u. ");
INSERT INTO xon_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu nan lul bumɔb nwiin pu ni kinyeek iwiin imonko ilee. Iwiin imonko ilee ngbaan aah jer na, le nkon chuu u. ");
INSERT INTO xon_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Le kinimbɔŋ u tɔŋni binib na dan u chee, le ki nan bui u, “Aa yaa ye Uwumbɔr Aajapɔɔn kan, bui ŋitakpal ŋimina aan ŋi kpaln tijikaar.” ");
INSERT INTO xon_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Le Yesu bui ki ke, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Tijikaar baanja aan ŋmaa tii unii limɔfal. Limɔboln limɔk nyan ni Uwumbɔr aamɔb ni na le ga tii unii limɔfal.’” ");
INSERT INTO xon_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Le kinimbɔŋ di Yesu buen Jerusalem, le ki ti di u tɔŋ Uwumbɔr Aadichal paab, ");
INSERT INTO xon_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","le ki bui u, “Aa yaa ye Uwumbɔr Aajapɔɔn kan, lir ni kitiŋ. Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘U ga tuk waatuuntiib ke bi li lik si, le bi ga li joo si biŋaal ni, aataal taa gbeer litakpal.’” ");
INSERT INTO xon_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Le Yesu bui ki ke, “Ni ki ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Taa tɔŋ Aadindaan Uwumbɔr.’” ");
INSERT INTO xon_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Le kinimbɔŋ ki yoor u buen lijool li fɔk sakpen na paab, le ki ti mɔk u dulnyaa aanaan mɔmɔk, ni mu aanyaan, ");
INSERT INTO xon_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","le ki bui u, “Aa yaa gbaan kitiŋ ki pak mi kan, m ga di nimina mɔmɔk di tii si.” ");
INSERT INTO xon_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Le Yesu bui ki ke, “Kinimbɔŋ, li cha. Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Li pak Aadindaan Uwumbɔr ki dii uma baanja.’” ");
INSERT INTO xon_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Le kinimbɔŋ siir cha u. Le Uwumbɔr aatuuntiib dan nan ter u. ");
INSERT INTO xon_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu nan ŋun ke bi chuu Jɔnn ki di ŋa kiyondiik ni. Nima le u nan nyan nima ki gir buen Galilee. ");
INSERT INTO xon_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","U nan cha Nasaref le ki buen ti kal Kapenaum, kitiŋ ki bi nnyusakpem chee na ni. Ki ye Sebulunn aanib ni Naftali aanib aatiŋ la. ");
INSERT INTO xon_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Waah kal nima na, le ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan len pu na ke, ");
INSERT INTO xon_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulunn aanib ni Naftali aanib aatiŋ ki bi Jɔɔdann aamɔɔdapuul, nnyusakpem wɔb, aan bi yin ki ke Galilee aatiŋ, ŋinibol mɔmɔk aabɔŋ aah ŋmal tɔb ponn ni nin chee na, ");
INSERT INTO xon_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","nima aanib bi bi mbɔmbɔɔn ni na kan nwiihn sakpiin. Binib bi bi mbɔmbɔɔn ni, ki san nkun ijawaan na, nwiihn woln bi pu.” ");
INSERT INTO xon_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","N‑yoonn ngbaan ki joo cha le Yesu piin ki mooni binib ke, “Kpeln nimi aabimbin man. Uwumbɔr aanaan peen ni a.” ");
INSERT INTO xon_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu nan chuun kpak Galilee Aanyusakpem aagbaan le ki ti kan naabitiib bilee, bi yin ubaa ke Simonn ki dulni u ke Piita, le ki yin unaal ke Andru. Bi nan bi mae kipɔɔk nnyun ni. Bi nan ye bijanbam la. ");
INSERT INTO xon_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Le Yesu bui bi, “Dii mi man, aan m cha ni ban binib ki nan tii Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Waah len kina na, libuul ngbaan ni le bi siir cha baapɔr le ki dii u. ");
INSERT INTO xon_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Le u foor siib kpee, le ki ki kan naabitiib bilee, Jems ni unaal Jɔnn, bi ye Sebedee aajapɔtiib na. Bi ni bite Sebedee nan bi buŋɔb ni, ki bi leŋni baapɔr. Le Yesu yin bi. ");
INSERT INTO xon_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Libuul ngbaan ni le bi siir cha buŋɔb ngbaan ni bite le ki dii u. ");
INSERT INTO xon_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Le Yesu bɔ dii Galilee aatim mɔmɔk ni, ki koo mmeen aadir ni, ki tuk binib Uwumbɔr aabɔr ki mooni Uwumbɔr aanaan aabɔnyaan tee, le ki cha bibum bi kpa iween aabɔŋ mɔmɔk na, ni binib bimɔk kaa pɔɔ na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Le waayimbil moon Siria aatim mɔmɔk ni. Le bi joo ni bibum mɔmɔk u chee, binib bi iween aabɔŋ joo bi na, ni binib bi tiyayaar joo bi na, ni binib bi ŋibimbik joo bi na, ni binib bi aawon faan na. Le u cha bi mɔmɔk pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Le kinipaak nyan ni Galilee aatingbaan ni, ni kitiŋ ki bi yin ki ke Ntim Kipiik na ni, ni Jerusalem aatiŋ ni, ni Judea aatingbaan ni, ni Jɔɔdann aamɔɔdapuul, ki dii u. ");
INSERT INTO xon_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu aah kan kinipaak ngbaan na, le u jon ligongoln paab, le ki kal. Le waadidiliib kuun u chee. ");
INSERT INTO xon_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Le u waar umɔb ki bui bi ke: ");
INSERT INTO xon_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Binib bi nyi ke bi ye bigiim Uwumbɔr wɔb na, waanyoor bi bi pu. Bima le yeh Uwumbɔr aanaan. ");
INSERT INTO xon_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Binib bi kpa mpombiin baatunwanbir pu na, Uwumbɔr aanyoor bi bi pu; u ga sɔŋ bisui. ");
INSERT INTO xon_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Binib bi sunn bibaa taab na, Uwumbɔr aanyoor bi bi pu. Bima le ga li yeh dulnyaa wee. ");
INSERT INTO xon_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Binib bi aanimbil man ke bi li ye bininyaam na, Uwumbɔr aanyoor bi bi pu. Binimbil ga gbiin. ");
INSERT INTO xon_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Binib bi kpa linimbaasaln na, Uwumbɔr aanyoor bi bi pu. U mu ga san bi kinimbaak. ");
INSERT INTO xon_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Binib bi dii Uwumbɔr ni bisui mɔmɔk na, waanyoor bi bi pu. Bima le ga kan uma Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Binib bi par kijaak na, Uwumbɔr aanyoor bi bi pu. U ga len ke bi ye waabim. ");
INSERT INTO xon_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Binib bi ji falaa Uwumbɔr aasan aadiim pu na, waanyoor bi bi pu. Bima le yeh uma Uwumbɔr aanaan. ");
INSERT INTO xon_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Binib yaa sii nimi ki ŋa nimi falaa ki mɔln inyamɔn mɔmɔk aabɔŋ ki paan nimi, ki bii nimi, min Yesu pu kan, Uwumbɔr aanyoor bi ni pu. ");
INSERT INTO xon_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ni li kpa mpopiin sakpen, ba pu? ni ga nan kan tinyoor sakpen paacham. Kina le bi nan ŋa Uwumbɔr aabɔnabtiib bi nan bi n‑yaayoonn na falaa.” ");
INSERT INTO xon_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nimi maadidiliib le ye dulnyaa wee ni aayaan. N‑yaan yaa bii, ki yaa kaa ki mɔ kan, nibaa aa bi ki ga ki ŋmaa ŋa mu aan mu mɔɔk. Mu aa ki bi tibɔr tibaa ni. Bi ga di mu kpir la. Le binib ga taa mu pu ki jer. ");
INSERT INTO xon_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nimi le ye dulnyaa wee ni aawiihn, ni woln binib aanimbil. Kitisakpeŋ ki bi ligongoln paab na aan ŋmaa bɔr. ");
INSERT INTO xon_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Unii yaa see karyaa kan, waan di lisambil chiŋ u pu. U ga di u tɔŋ tiwan paab la, le u woln kidiik mɔmɔk ponn ni nwiihn. ");
INSERT INTO xon_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ni li bi kina man. Cha binib mɔmɔk kan nimi aawiihn aah wiin pu na, aan bi kan nimi aatunyaan aan ki pak Nite Uwumbɔr u bi paacham na.” ");
INSERT INTO xon_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ni taa dak ke m dan m nan kuln Uwumbɔr aakaal ni Waabɔnabr aabɔr. Maa dan ke m nan kuln ti. M dan ke m nan ŋa taah len pu na mɔmɔk chub la. ");
INSERT INTO xon_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","M tuk nimi mbamɔn la, nkaal ngbaan mubaa aan jer, see mu aah len pu na mɔmɔk ŋa. Buyoonn paacham ni dulnyaa ga li bi na, nkaal ngbaan mɔmɔk ga li beenin bi. ");
INSERT INTO xon_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nima pu na, unii umɔk yii nkaal ngbaan ponn ni siib na, ki mɔk binib kina na, u ga li ye uwaatiir Uwumbɔr aanaan ni. Unii umɔk kii nkaal ngbaan, ki mɔk binib kina na, u ga li ye unikpaan Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","M tuk nimi la, nimi aabimbin yaa kaa ŋan ki jer Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab aabimbin kan, naan koo ni Uwumbɔr aanaan ni.” ");
INSERT INTO xon_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ni ŋun ke bi nan tuk n‑yaayoonn na aanib, ‘Taa ku unii, ke unii ubaa yaa ku uken kan, bi ga ji u tibɔr.’ ");
INSERT INTO xon_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Min le tuk nimi ke unii umɔk gee liŋuul una aabo pu na, bi ga ji u tibɔr. Unii umɔk tuk una aabo, ‘Saa bi tibɔr tibaa ni,’ bibɔjirb aaninkpiib ga ji u tibɔr. Unii umɔk tuk una aabo ke, ‘Si ujɔr’ na, u ŋeer u koo mmii mu kaan junn na ni. ");
INSERT INTO xon_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aa yaa bi Uwumbɔr Aadichal ni ki ban aa tii Uwumbɔr ipiin, ki teer ke aa koo aana aabo ubaa aataani ni kan, ");
INSERT INTO xon_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","di saapiin di bil nima, ki buen ti chuu utaal waahr, aan ki nin gir ni ki nan tii Uwumbɔr ipiin ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Aa ni unii yaa kpa tibɔr, u ban u di ti buen kooti ni kan, chuu utaal mala aan ni taa kee fuu nima, u taa di si ŋa ubɔjir aaŋaal ni, ubɔjir mu taa di si ŋa kiyondiik aaninkpel aaŋaal ni, ke u di si ŋa kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","M tuk si mbamɔn la, saan nyan nima ki nan saa buyoonn aa ga pa kooti ni aamombil mɔmɔk doo na.” ");
INSERT INTO xon_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ni ŋun ke bi nan tuk n‑yaayoonn na aanib, ‘Taa gɔr kidagook.’ ");
INSERT INTO xon_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Min le tuk nimi ke unii umɔk kan upii aan usui koo u ni kan, u kpaan gɔr kidagook usui ni la. ");
INSERT INTO xon_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aa yaa gee tiwan ke saah gee aanimbigiil pu na kan, tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Saawan nibaa yaa bee yɔli kan, ni soor ni tiwon mɔmɔk koo mmii mu kaan junn na ni. ");
INSERT INTO xon_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aa yaa gee tiwan ke saah gee aaŋangii pu na kan, tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Saawan nibaa yaa bee yɔli kan, ni soor ni tiwon mɔmɔk koo mmii mu kaan junn na ni.” ");
INSERT INTO xon_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“N‑yaayoonn na aanib nan ki len ke ‘Uja yaa jenn upuu lii kan, u ŋmee kigbaŋ, ki di tii u ki mɔk ke u jenn u.’ ");
INSERT INTO xon_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Min le tuk nimi ke upii yaa kaa gɔr kidagook kan, uchal yaa jenn u lii kan, u ŋa u upiidagoor le na. Uja u yoor baah jenn upii u lii na mu ye udagoor la.” ");
INSERT INTO xon_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ni ŋun ke bi nan tuk n‑yaayoonn na aanib ke, ‘Taa puu Uwumbɔr nnyamɔn pu, ke aa yaa puu Uwumbɔr kan, ŋa saah len pu na.’ ");
INSERT INTO xon_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Min le tuk nimi: ni taa puu Uwumbɔr. Ni taa puu paacham mu; ba pu? paacham ye Uwumbɔr aabɔrjal la. ");
INSERT INTO xon_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni taa puu kitiŋ mu; ba pu? kitiŋ ye Uwumbɔr aataa aajal la. Ni taa puu Jerusalem mu; ba pu? Jerusalem ye Uwumbɔr u ye Ubɔrkpaan na aatiŋ la. ");
INSERT INTO xon_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taa puu aayil; ba pu? saan ŋmaa kpeln kiyikpirk kibaa, ki li ye kiyikpipiin, kaan ŋmaa kpeln kibaa ki li ye kiyikpibɔŋ. ");
INSERT INTO xon_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ni po len ke ‘Een’, bee ‘Aayii’. Ni yaa ki kpee nibaa kan, naa ŋan.” ");
INSERT INTO xon_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ni ŋun ke bi nan tuk n‑yaayoonn na aanib, ‘Unii yaa chuu lokr aanimbil kan, bi chuu lokr u mu yaal. Unii yaa gbaa fenn aanyin kan, bi chuu fenn u mu yaan.’ ");
INSERT INTO xon_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Min le tuk nimi: unii yaa ŋa si bakaa kan, taa giin u waah ŋa si pu na. Unii yaa faa si aaŋangii aataapak kan, aa cha u faa aaŋangan aataapak mu. ");
INSERT INTO xon_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Unii yaa ban u di si buen bibɔjirb chee ke u ti gaa saabɔkul kan, tiin u saakekeln mu. ");
INSERT INTO xon_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Uja yaa muk si ke aa cheen u mal ubaa kan, cheen u mal bilee. ");
INSERT INTO xon_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Unii yaa mee si tiwan kan, tiin u. Unii yaa ban ke aa pinn u tiwan kan, taa yii.” ");
INSERT INTO xon_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ni ŋun ke bi nan tuk n‑yaayoonn na aanib, ‘Li gee aana aabo ki nan saadin.’ ");
INSERT INTO xon_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Min le tuk nimi: ni li gee nimi aadim man, ki bui binib bi seei nimi na ke, ‘Uwumbɔr ŋa tinyoor ŋa ni pu;’ ki ŋa binib bi nan nimi na tiŋann, ki mee Uwumbɔr ki tii binib bi ŋani nimi falaa ki muk nimi na. ");
INSERT INTO xon_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ni yaa ŋani kina kan, ni ga li ye Nite Uwumbɔr u bi paacham na aabim; uma le cha waawiin puur ki woln tiniwanbir ni bininyaam pu, ki cha utaal nu ki tii binib bi ŋan na, ni binib bi kaa ŋan na. ");
INSERT INTO xon_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni yaa gee binib bi gee nimi na baanja kan, ni kpa tinyoor Uwumbɔr chee ee? Bilampoogaab mu gee binib bi gee bi na la. ");
INSERT INTO xon_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni yaa dooni ninaabitiib baanja kan, ni ŋan ki jer biken aa? Aayii. Binib bi kaa dii Uwumbɔr aasan na mu ŋani kina la. ");
INSERT INTO xon_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nima pu na, ni li bi mbamɔm, ke Nite Uwumbɔr u bi paacham na aah bi pu na.” ");
INSERT INTO xon_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ni li nyi man, ki taa tun nimi aatunyaan binib aanimbil ni, ke bi kan aan ki pak nimi. Ni yaa ŋani kina kan, naan kan tinyoor Nite Uwumbɔr u bi paacham na chee. ");
INSERT INTO xon_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Aa yaa tii ugiin tiwan kan, taa joo kiloŋ gbaa ke biŋmaŋmannim aah ŋani pu mmeen aadir ni, ni kitiŋ ponn ni, ke binib pak bi na. M tuk nimi mbamɔn la, bi kan baapal le na. ");
INSERT INTO xon_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aa yaa tii ugiin tiwan kan, taa cha aaŋangan li nyi aaŋangii aah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tii u libɔɔl ni. Le Aate Uwumbɔr u kan saah ŋa pu libɔɔl ni na ga pa si binib aanimbil ni.” ");
INSERT INTO xon_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ni yaa mee Uwumbɔr kan, ni taa mee u ke biŋmaŋmannim na aah mee u pu na. Bi gee ke bi sil mmeen aadir ni, ni kitiŋ ponn ni ki mee Uwumbɔr, aan binib kan bi. M tuk nimi mbamɔn la, bi kan baapal le na. ");
INSERT INTO xon_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sin ma kan, aa yaa mee Uwumbɔr kan, koo saadiik ni, ki di jaaleŋ piin, ki mee Aate Uwumbɔr u bi libɔɔl ni na. Le Aate Uwumbɔr u kan saah ŋani pu libɔɔl ni na ga tii si tinyoor. ");
INSERT INTO xon_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ni yaa mee Uwumbɔr kan, ni taa len yɔl yɔl aabɔr ke binib bi kaa dii Uwumbɔr aasan na aah len pu na. Bi dak ke bi yaa len sakpen kan, nima le ga cha Uwumbɔr ŋun. ");
INSERT INTO xon_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni taa ŋani ke baah ŋani pu na; Nite Uwumbɔr nyi naah ban tiwan ni na, naa kee mee u. ");
INSERT INTO xon_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ni yaa mee Uwumbɔr kan, bui ke, ‘Tite Uwumbɔr u bi paacham na, cha binib li san saayimbil. ");
INSERT INTO xon_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Saanaan dan. Bi li ŋani saageehn dulnyaa wee ni ke baah ŋani paacham pu na. ");
INSERT INTO xon_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tiin timi din aawiin aajikaar. ");
INSERT INTO xon_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cha timi aataani ki pinn timi, ke ti mu aah di cha pinn binib bi koo timi aataani ni pu na. ");
INSERT INTO xon_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taa cha ti kan ntɔŋ. Nyan timi kinimbɔŋ aaŋaal ni. Si le yeh nnaan, ni mpɔɔn, ni mpakm n‑yoonn mu kaa kpa ndoon na.’ ");
INSERT INTO xon_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ni yaa di cha pinn binib baataani kan, Nite Uwumbɔr u bi paacham na mu ga di cha pinn nimi. ");
INSERT INTO xon_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ni yaa kaa di cha pinn binib baataani kan, Nite Uwumbɔr mu aan di cha pinn nimi aatunwanbir.” ");
INSERT INTO xon_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ni yaa lul bumɔb kan, ni taa bii ninimbil wɔb ke biŋmaŋmannim aah ŋani pu na; bi bii binimbil wɔb ke binib bee ke bi lul bumɔb. M tuk nimi mbamɔn la, bi kan baapal la. ");
INSERT INTO xon_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sin ma kan, aa yaa lul bumɔb kan, finn aanimbil wɔb, ki di nkpan ŋmir aayil, ");
INSERT INTO xon_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","aan binib taa bee ke aa lul bumɔb. Aate Uwumbɔr u bi libɔɔl ni na le ga bee. Le Aate Uwumbɔr u kan saah ŋa pu libɔɔl ni na ga tii si tinyoor.” ");
INSERT INTO xon_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ni taa kuun liwankpal bil dulnyaa wee ni. Idundur ni ŋipulaaleen ga bii ni. Binaayukb mu ga loon koo ni ki nan sun ni. ");
INSERT INTO xon_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ni di liwankpal bil Uwumbɔr do. Idundur ni ŋipulaaleen aan bii li nima. Binaayukb mu aan koo ni nima ki nan sun li. ");
INSERT INTO xon_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Saawankpal aah bi nin chee na, aasui mu bi nima la.” ");
INSERT INTO xon_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Linimbil ye tiwon aakaryaa la. Aanimbil yaa wiin kan, saabimbin mɔmɔk ga li gbii nwiihn la. ");
INSERT INTO xon_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Aanimbil yaa jɔb kan, saabimbin mɔmɔk ga li gbii mbɔmbɔɔn la. Aanimbil li tii si nwiihn na yaa bɔɔn kan, aa bi mbɔmbɔɔn sakpiin ni la.” ");
INSERT INTO xon_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Unii ubaa aan ŋmaa li ye dindatiib bilee aanaagbiija; u ga li nan ubaa, le ki gee uken; u ga li si ubaa aachaŋ ni, le ki lik uken fam. Naan ŋmaa dii Uwumbɔr ni liwankpal mu. ");
INSERT INTO xon_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nima le m tuk nimi ke ni taa cha nimi aalandak muk nimi tiwon aawan pu, ki taa li dak: ‘Ti ga ji ba? Ti ga nyu ba? Ti ga peen ba?’ Limɔfal bi tijikaar baanja pu la aa? Tiwon bi tiwanpeenkaan baanja pu la aa? ");
INSERT INTO xon_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lik inyoon i laani paacham na aah bi pu na. Yaa ko tijikaar ki mu aa chee, ki mu aa faa njikaabim fuu ŋipil ni. Nite Uwumbɔr u bi paacham na le kpiini i. Naa jer i ii? ");
INSERT INTO xon_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni ponn ni ubaa ga ŋmaa muk waalandak aan ki yunn jer Uwumbɔr aah siin pu na aa? ");
INSERT INTO xon_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ba pu ni cha ilandak muk nimi tiwanpeenkaan pu? Dakl lik mmopuun aah bi pu na man. Mu aa tun lituln, ki mu aa fik tikokonn. ");
INSERT INTO xon_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","M tuk nimi la, Ubɔr Solomonn u nan peeni tiwanpeenkaan nyaan na aawanpeenkaan aa nan ŋan ke mmopuun aah ŋan pu na. ");
INSERT INTO xon_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Timoor bi din ki ga fe wu mmii fen, le Uwumbɔr ŋa ti mmopuun mu ŋan na. Waan tii nimi tiwanpeenkaan aa? Naa gaa Uwumbɔr ki kii mbamɔm la. U ga tii nimi. ");
INSERT INTO xon_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nima pu na, ni taa cha ilandak muk nimi, ki taa li dak: ‘Ti ga ji ba? Ti ga nyu ba? Ti ga peen ba?’ ");
INSERT INTO xon_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tiwan ngbaan mɔmɔk pu le binib bi kaa dii Uwumbɔr aasan na aanimbil man. Nite Uwumbɔr u bi paacham na nyi ke ni ban tiwan ngbaan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ni li ban Uwumbɔr aanaan, ni waasanyaan le waahr; le u ga di tiwan ngbaan mɔmɔk kpee nimi. ");
INSERT INTO xon_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nima pu na, ni taa cha fen u choo na aabɔr muk nimi. Fen le ni ga fe dak fen aabɔr. Ni yaa dakl din aabɔr din kan, ni ŋeer kina la.” ");
INSERT INTO xon_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ni taa galn binib, aan Uwumbɔr mu taa galn nimi. ");
INSERT INTO xon_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Naah galni binib pu na, Uwumbɔr mu ga galn nimi kina la. Naah tii binib pu na, Uwumbɔr mu ga giin kina le ki tii nimi. ");
INSERT INTO xon_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ba ŋa aa lik ki waa lidɔchɔl li bi aana aabo aanimbil ni na, kaa tee waa jaatɔlk u bi aayaan ni na? ");
INSERT INTO xon_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aa tee ŋa kinye ki bui aana aabo, ‘Cha m nyan lidɔchɔl li bi aanimbil ni na,’ ka jaatɔlk bi aayaan ni? ");
INSERT INTO xon_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sin uŋmaŋmann umina, chuu nyan jaatɔlk ngbaan aanimbil ni waahr, aan ki li waa mbamɔm, aan ki nan nyan aana aabo yaan ni lidɔchɔl. ");
INSERT INTO xon_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ni taa di tiwan ni bi chain na di tii ibɔ. I ga gir nan junn nimi. Ni taa di nleenyaan di tii igbeer. I ga taa taa mu pu.” ");
INSERT INTO xon_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ni li mee Uwumbɔr man, le u ga tii nimi. Ni li ban Uwumbɔr chee man, le ni ga kan. Ni li kpaar jaaleŋ man, le u ga piir tii nimi. ");
INSERT INTO xon_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Unii umɔk mee Uwumbɔr na, u ga tii u. Unii umɔk ban na, u ga kan. Unii umɔk kpaar jaaleŋ na, u ga piir tii u. ");
INSERT INTO xon_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tɔ, ubo ubaa yaa mee ute maab kan, u ga di litakpal tii u uu? ");
INSERT INTO xon_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","U yaa mee u ujan kan, u ga di ukuub tii u uu? ");
INSERT INTO xon_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nimi titunwanbirdam yaa tee nyi ipiin i ŋan na ki tii nimi aabim kan, ŋmaninkabaa Nite Uwumbɔr u bi paacham na le aan di tiwan ni ŋan na ki di tii binib bi mee u na aa? ");
INSERT INTO xon_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nima pu na, naah ban ke binib li ŋani nimi pu na mɔmɔk, ni mu li ŋani bi kina. Uwumbɔr aakaal ni waabɔnabr aabɔr le mɔk kina.” ");
INSERT INTO xon_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ni li dii mbisamɔb mu kaa waa na. Nsan mu cha mmii mu kaan junn na ni na waa la. Nsan ngbaan aabisamɔb mu waa la. Binib bi dii mu na, bi wiir la. ");
INSERT INTO xon_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nsan mu cha limɔfal li kaa kpa ndoon na ni na aa waa. Nsan ngbaan aabisamɔb mu aa waa. Binib bi dii mu na aa wiir.” ");
INSERT INTO xon_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ni li nyi binyamɔndam bi ŋmanni ke bi ye Uwumbɔr aabɔnabr na. Bi ŋmanni ke bi ye ipiih, le ki tee ye ŋisapol ŋi ga bii nimi na. ");
INSERT INTO xon_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Baatuln pu le ga cha ni bee bi. Bukokom ga ŋmaa lu nkakan aa? Ichakpeejagar ga ŋmaa lu saasaa aa? ");
INSERT INTO xon_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Isui imɔk ŋan na ga lu ŋisubil ŋi ŋan na la. Isui i kaa ŋan na ga lu ŋisubil ŋi kaa ŋan na la. ");
INSERT INTO xon_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Busub bu ŋan na aan ŋmaa lu ŋisubil ŋi kaa ŋan na. Busub bu kaa ŋan na mu aan ŋmaa lu ŋisubil ŋi ŋan na. ");
INSERT INTO xon_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Busub bumɔk kaa lu ŋisubil ŋi ŋan na kan, bi ga gaa bu, ki di ŋa mmii ni. ");
INSERT INTO xon_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nima pu na, baah ŋa pu na le ga cha ni bee biŋmaŋmannim bi ŋmanni ke bi ye Uwumbɔr aabɔnabtiib na.” ");
INSERT INTO xon_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Naa ye binib bimɔk yin mi ke ‘Dindaan, Dindaan’ na le ga koo Uwumbɔr aanaan ni. Binib bi ŋani Nte Uwumbɔr u bi paacham na aah gee pu na le ga koo waanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Liyaadaal ngbaan le binib pam ga bui mi, ‘Tidindaan, Tidindaan, ti nan nabr Uwumbɔr aabɔr saayimbil pu, ki nyan tiyayaar binib ni, saayimbil pu, ki tun lijinjiir aatun saayimbil pu.’ ");
INSERT INTO xon_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Le m ga tuk bi, ‘Nimi titunwanbirdam, maa nyi nimi. Siir m chee man.’” ");
INSERT INTO xon_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nima pu na, unii umɔk ŋun maabɔr ngbaan ki ŋani kina na, naahn unii u kpa nlan, ki maa waadiik litakpal pu na. ");
INSERT INTO xon_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Utaal nun, le nwam nyan, le libuln daar, le ki pee kidiik ngbaan. Kaah si litakpal pu na, le kaa lir. ");
INSERT INTO xon_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Unii umɔk ŋun maabɔr ngbaan, kaa ŋani kina na, naahn unii u kaa kpa nlan ki maa waadiik litambol pu na la. ");
INSERT INTO xon_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Utaal nun, le nwam nyan, le libuln daar ki pee kidiik ngbaan; le ki lir. Ki lir kookoo la.” ");
INSERT INTO xon_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu nan len doo. Waah tuk bi tibɔr ti na, le ni gar kinipaak ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","U tuk bi ke unii u kpa Uwumbɔr aapɔɔn na la, kaa tuk bi ke Uwumbɔr aakaal aamɔmɔkb aah tuk bi pu na. ");
INSERT INTO xon_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu nan sunn ni ligongoln na taab. Le kinipaak sakpeŋ dii u. ");
INSERT INTO xon_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Le ukɔndaan ubaa dan u chee ki nan gbaan unimbiin ni, le ki doon u ki bui u, “Ndindaan, aa yaa gee kan, aa ga ŋmaa cha m pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Le Yesu taln uŋaal, ki meeh u, le ki bui u, “M gee. Aa pɔɔk a.” Libuul ngbaan ni le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Le Yesu bui u, “Li nyi, ki taa tuk unii ubaa. Li cha Uwumbɔr aatotoor chee ki ti di aabaa mɔk u, ki toor kitork tii Uwumbɔr, Moses aakaal aah len pu na. Nima le ga mɔk binib ke aa pɔɔk a.” ");
INSERT INTO xon_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu nan koo Kapenaum aatiŋ ni. Le butɔb aajab nkub aaninkpel ubaa dan u chee ki nan gaŋ u ki bui u, ");
INSERT INTO xon_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ndindaan, maatutunn dɔ linampal. Uwon faan ki wu sakpen a.” ");
INSERT INTO xon_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Le Yesu bui u, “M ga dan ki nan cha waaween sɔŋ.” ");
INSERT INTO xon_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Le u bui u, “Ndindaan, maa ŋeer aa dan ndo ki nan koo maadichal ni. Aa yaa po len ke ‘Pɔɔk’ kan, maatutunn ngbaan ga pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Min mbaa kii maaninkpel aamɔb, ki mu ye butɔb aajab aaninkpel la, le ki bui ubaa, ‘Li cha,’ le u buen; ki bui ubaa mu, ‘Dan,’ le u dan; ki bui maanaagbiija, ‘Ŋa kina,’ le u ŋa.” ");
INSERT INTO xon_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu aah ŋun waah len pu na, le ni gar u pam. Le u bui binib bi dii u na ke, “M tuk nimi mbamɔn la, maa kee kan unii ubaa bi Israel yaab ponn ni ki gaa mi ki kii mbamɔm kina. ");
INSERT INTO xon_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","M tuk nimi la, binib pam ga nya ni liwipuul wɔb, ni liwilir wɔb, ki nan kal, ki ji Abraham, ni Aisak, ni Jakob chee tijikaar Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Le Juu yaab bi ba ga koo ni na, Uwumbɔr ga chuu nyan bi lipaal mbɔmbɔɔn aah bi nin chee na. Bi ga wii ki ŋmɔ ŋinyin nima chee.” ");
INSERT INTO xon_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tɔ, le u bui butɔb aajab aaninkpel ngbaan, “Li dii saasan. Saah gaa mi ki kii mbamɔm pu na, ni ŋa kina ki tii si.” Yesu aah len kina na, libuul ngbaan ni le uninkpel ngbaan aatutunn pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu nan buen Piita aadichal ni, le ki ti kan Piita aapuu aana bun ki dɔ kidiik ni. Le uwon ton. ");
INSERT INTO xon_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Le Yesu meeh uŋaal. Le uwon sɔŋ. Le u fii, ki chann u tichann. ");
INSERT INTO xon_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kijook aah joor na, le binib dan Yesu chee, ki joo ni binib bi tiyayaar joo bi na pam. Yesu nan po len tibɔr baanja la, le tiyayaar ngbaan nyan bi ni. Le u cha bibum mɔmɔk mu pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U ŋa kina ke ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan len pu na ke, “Uma ubaa le nyan ni iween, ni tibunbunn timi aawon ni.” ");
INSERT INTO xon_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu nan kan ke kinipaak ki dii u na wiir sakpen a. Nima pu le u nan tuk waadidiliib ke u ban u puur nnyusakpem la. ");
INSERT INTO xon_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Le Uwumbɔr aakaal aamɔmɔkr ubaa nan dan u chee ki nan bui u, “Umɔmɔkr, m ga dii si, saah cha nin chee na mɔk.” ");
INSERT INTO xon_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Le Yesu bui u, “Iŋɔk kpa yaah koo ibuu i ponn ni na. Inyoon i laani paacham na mu kpa yaadil. Min Unibɔn Aabo ma aa kpa maah ga doon nin chee na.” ");
INSERT INTO xon_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Le waadidiir ubaa mu bui u, “Ndindaan, m mee si nsan, cha m buen ti sub nte waahr, aan ki nan dii si.” ");
INSERT INTO xon_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Le Yesu bui u, “Dii mi dandana wee, ki cha bitekpiib sub tɔb.” ");
INSERT INTO xon_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Le Yesu koo buŋɔb ni. Le waadidiliib mu dii u. ");
INSERT INTO xon_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Baah chuun nnyun ni cha na le kibuŋ ti fii ki bi daar, le tinyunkpenn fii ti ti biin buŋɔb pu. Yesu nan dɔ geen. ");
INSERT INTO xon_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Le waadidiliib dan ki nan gbaa finn u ki bui u, “Tidindaan, ter timi. Ti ga bee nnyun ni.” ");
INSERT INTO xon_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Le u bui bi, “Ba ŋa ni san ijawaan? Naa gaa mi ki kii mbamɔm.” Le u fii ki kae kibuŋ ni nnyun. Le kibuŋ ni nnyun mɔk ŋmin chii. ");
INSERT INTO xon_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ni nan gar bi pam. Le bi baa tɔb, “Ba aanibol le na? Hali kibuŋ ni nnyun kii waamɔb.” ");
INSERT INTO xon_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Le bi fuu nnyusakpem aadapuul, Gadarene yaab aatiŋ ni. Baah fuu nima na le biwaab bilee nyan ni baah sui binib titakpalunn ti ponn ni na, ki tooh u nsan ni. Biwaab ngbaan yaa nan kan unii kan, bi ga gbaa u la. Nima pu na, ubaa aa nan ŋmaa jer nima chee. ");
INSERT INTO xon_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Baah kan Yesu na, le bi teen ke, “Sin, Uwumbɔr Aajapɔɔn, aa ban ba ti chee? Aa dan do ke aa nan ŋa timi falaa n‑yoonn aah kaa kee ŋeer buyoonn aa?” ");
INSERT INTO xon_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Le igbeer i wiir na bi dandar ki chuun ji. ");
INSERT INTO xon_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Le tiyayaar ti bi bijab ngbaan ni na gaŋ Yesu, “Aa yaa nyan timi binib ngbaan ponn ni kan, cha ti ti koo igbeer ngbaan ni.” ");
INSERT INTO xon_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Le Yesu bui ti, “Li cha man.” Le ti nyan binib ngbaan ni, le ki ti koo igbeer na ni. Libuul ngbaan ni, le igbeer ngbaan mɔmɔk san sunn limɔɔgongoln taab, le ki ti koo nnyun ni ki kpo. ");
INSERT INTO xon_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Le bijab bi kiir igbeer ngbaan na san buen kitiŋ ni, ki ti tuk binib Yesu aah cha biwaab ngbaan pɔɔk pu na, ni tibɔr ngbaan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kitiŋ ngbaan aanib aah ŋun kina na, le bi mɔmɔk dan ki nan tooh Yesu nsan ni. Baah kan u na, le bi gaŋ u ke u nyan baatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Le u gir koo buŋɔb ni, ki ki puur nnyusakpem ki kun udo aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Le bijab bibaa luln ni uja u aawon faan na likekeln ni Yesu chee. Le Yesu kan baah gaa u ki kii mbamɔm pu na, le ki bui uja u aawon faan na, “Maabo, chuu aabaa, m di cha saatunwanbir pinn si.” ");
INSERT INTO xon_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Waah len kina na, le Uwumbɔr aakaal aamɔmɔkb bibaa dakl bisui ni ke, “Uja wee sii Uwumbɔr la.” ");
INSERT INTO xon_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Le Yesu bee baalandak, le ki baa bi, “Ba ŋa ni dak ilandak i kaa ŋan na nisui ni? ");
INSERT INTO xon_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maah len ke m di cha waatunwanbir pinn u na le pɔɔ aan m yaa len ke ‘Fii ki li chuun’ le pɔɔ? ");
INSERT INTO xon_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","M ga mɔk nimi ke min Unibɔn Aabo kpa mpɔɔn dulnyaa wee ni ke m di cha pinn titunwanbir.” Waah len kina na, le u bui uja u aawon faan na ke, “Fiin ki yoor saawandookaan ki li chaa kun.” ");
INSERT INTO xon_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Libuul ngbaan ni le uja ngbaan fii ki chaa kun. ");
INSERT INTO xon_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kinipaak ngbaan aah kan kina na, le bi san ijawaan, ki nyuŋ Uwumbɔr u tii unibɔn mpɔɔn kina na. ");
INSERT INTO xon_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Le Yesu siir nima ki buen. Waah cha na, le u kan ulampoogaar ubaa bi yin u ke Matiu. U ka baah gaal lampoo nin chee na. Le Yesu bui u, “Li dii mi.” Le u fii ki dii u. ");
INSERT INTO xon_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Le Yesu ni waadidiliib nan kal Matiu do ki jin tijikaar. Le bilampoogaab ni titunwanbirdam bi wiir na dan nan jin bi chee tijikaar. ");
INSERT INTO xon_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisii yaab aah kan kina na, le bi baa waadidiliib, “Ba ŋa nimi aamɔmɔkr ji bilampoogaab ni titunwanbirdam chee tijikaar?” ");
INSERT INTO xon_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Le Yesu ŋun baah len pu na, le ki bui ke, “Binib bi kpa laafee na aa ban dɔkta, see binib bi bun na le ban dɔkta. ");
INSERT INTO xon_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uwumbɔr Aagbaŋ len ke waa ban ke binib toor kitork baanja ki tii u. U ban ke bi li san tɔb kinimbaak la. Li cha ki ti bae tibɔr ngbaan aatataa. Maa dan ke m nan yin bininyaam. M dan ke m nan yin titunwanbirdam ke bi nan kpeln baabimbin.” ");
INSERT INTO xon_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Le Jɔnn aadidiliib dan Yesu chee, le ki nan bui u, “Ti ni Farisii yaab lul bumɔb kpakpaayuk la. Ba pu saadidiliib ma aa lulni bumɔb?” ");
INSERT INTO xon_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Le u baa bi, “Bicham bi dan bi nan ji ubɔndinn aajim na ga ŋmaa li kpa mpombiin buyoonn upiidinn bi bi chee na aa? Aayii. N‑yoonn choo, le bi ga nan chuu nyan upiidinn na bi chee mpɔɔn. N‑yoonn ngbaan le bi ga lul bumɔb.” ");
INSERT INTO xon_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu nan ki len ke, “Ubaa aan di likekepɔln aageln leŋ libɔkukpokl. U yaa ŋa kina kan, likekepɔln aageln na ga kar libɔkukpokl na. Liboln ngbaan ga jer njan yaan. ");
INSERT INTO xon_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ubaa mu aan di ndawiin ki di ŋa kilookpok ponn ni. U yaa ŋa kina kan, kilook ngbaan ga puu, ki bii. Ndaan mu ga kpir. Bi ga di ndawiin ki di ŋa kiloopɔŋ ni la. Le ndaan aan kpir. Kilook ngbaan mu aan bii.” ");
INSERT INTO xon_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu aah bi len kina na, le uninkpel ubaa dan nan gbaan unimbiin ni ki doon u, le ki bui u, “Mbisal kpo a. Dan nan di aaŋaal paan u pu, le u ga fikr.” ");
INSERT INTO xon_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Le Yesu fii ki dii u. Waadidiliib mu dii u. ");
INSERT INTO xon_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Le upii u fu tipiir ŋibin kipiik ni ŋilee taa door na nan bi nima, ki dan Yesu aapuwɔb, le ki nan meeh waabɔkul aamɔjuul; ");
INSERT INTO xon_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ba pu? u nan dak usui ni ke u yaa po meeh Yesu aabɔkul kan, u ga pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Le Yesu fenn ki kan u, le ki bui u, “Mbisal, chuu aabaa. Saah gaa mi ki kii mbamɔm pu na, nima le cha aa pɔɔk.” Libuul ngbaan ni le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Le Yesu fuu uninkpel ngbaan aadichal ni, ki ti koo li ponn ni, ki kan kinipaak nima. Bi nan wii ikpowiil, ki pii ŋiwul, ki faa kifuuk. ");
INSERT INTO xon_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Le u bui bi, “Nyan lipaal man. Upiibo ngbaan aa kpo. U geen la.” Le bi laa u sakpen. ");
INSERT INTO xon_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Baah nyan kinipaak ngbaan lipaal na, le u koo ni upiibo ngbaan aah bi kidiik ki ponn ni na, le ki ti chuu uŋaal, le u fii. ");
INSERT INTO xon_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Le bi mooni tibɔr ngbaan itingbaan mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu nan siir nima. Waah cha na le bijoom bilee dii u, ki tar ke, “David Aayaabil, san timi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Le u ti koo kidiik ni. Le bijoom ngbaan mu koo ni u chee. Le u baa bi, “Ni pak ke m ga ŋmaa likr ninimbil aa?” Le bi kii, “Tidindaan, een.” ");
INSERT INTO xon_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Baah len kina na, le u meeh binimbil, le ki bui bi, “Naah gaa mi ki kii pu na, ni ŋa kina ki tii nimi.” ");
INSERT INTO xon_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Le binimbil likr. Le u sur bi mbamɔm ke bi taa tuk unii ubaa. ");
INSERT INTO xon_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Le bi buen ki ti joo waayimbil mooni itingbaan mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bijoom ngbaan aah nyan ni Yesu chee na, le binib bibaa nan joo ni ubir u tiyayaar joo u na. ");
INSERT INTO xon_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Le Yesu nyan tiyayaar u ni. Le u len, kaa ki ye ubir. Le ni gar kinipaak ngbaan pam. Le bi len ke, “Taa kee kan kina timi Israel yaab aatiŋ ni.” ");
INSERT INTO xon_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Le Farisii yaab bui ke tiyayaar aayidaan le tii u mpɔɔn ke u nyan tiyayaar binib ni. ");
INSERT INTO xon_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu nan bɔ dii ntisakpem, ni ntiwaatiir ni, le ki koo mmeen aadir ni, ki tuk binib Uwumbɔr aabɔr, ki mooni Uwumbɔr aanaan aabɔnyaan tee, le ki cha bibum bi kpa iween aabɔŋ mɔmɔk na, ni binib bimɔk kaa pɔɔ na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Waah kan kinipaak ngbaan na, le u san bi kinimbaak sakpen; ba pu? bi naahn ipiih i yɔl ki dɔ kitiŋ, kaa kpa upihkpaal na la. ");
INSERT INTO xon_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Le u bui waadidiliib, “Idi biir a, ki wiir. Bidicheeliib ma aa wiir. ");
INSERT INTO xon_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nima pu na, ni li mee kisaak Aadindaan man ke u tun ni bidicheeliib bi nan chee waajikaar.” ");
INSERT INTO xon_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu nan yin waakpambalb kipiik ni bilee ke bi dan u chee, le ki nan tii bi mpɔɔn ke bi ti nyan tiyayaar binib ni, ki cha bibum bi kpa iween aabɔŋ mɔmɔk na, ni binib bimɔk kaa pɔɔ na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Waakpambalb kipiik ni bilee ngbaan aayimbil sɔ: njan, Simonn u bi yin u ke Piita na, ni Andru u ye Simonn aanaal na; Jems u ye Sebedee aajapɔɔn na, ni Jɔnn u ye Jems aanaal na; ");
INSERT INTO xon_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, ni Batolomiu; Tomas, ni Matiu u nan gaal lampoo na; Jems u ye Alfeus aajapɔɔn na, ni Tadeus; ");
INSERT INTO xon_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ni Simonn u nan ban u kuln waatiŋ aadim na, ni Judas Iskariot u ga nan kooh Yesu na. ");
INSERT INTO xon_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu nan tun waakpambalb kipiik ni bilee ngbaan bi ti moon Uwumbɔr aabɔr ki bui bi, “Ni taa buen binib bi kaa ye Juu yaab na aatiŋ ni, ki taa buen Samaria yaab aatiŋ kibaa ni. ");
INSERT INTO xon_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Li cha man Israel yaab bi yenn Uwumbɔr aasan ni na aatim ni, ");
INSERT INTO xon_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ki ti li mooni Uwumbɔr aabɔr ke waanaan peen ni a, ");
INSERT INTO xon_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ki cha bibum pɔɔk, ki li fikr binib bi kpo na, ki cha bikɔndam pɔɔk, ki nyan tiyayaar ni bipɔnib binib ni. Ni kan mpɔɔn, kaa pan nibaa. Ni mu li tii bibum laafee, ki taa li ban tipar. ");
INSERT INTO xon_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ni taa li joo ŋimombil tikpalɔnn ni, ");
INSERT INTO xon_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ki taa li tu lituln, ki taa li joo libɔkul ki kpee naah pee li na pu, ki taa li joo ŋinaatak, ki taa li joo tijaangbar; ba pu? ni ŋan ke ututunn mɔmɔk ji waatuln pu la. ");
INSERT INTO xon_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ni yaa fuu kitiŋ kibaa ni kan, ni li ban uninyaan u ga gaa nimi waadiik ni na, ki li bi nima ki ti saa buyoonn ni ga nan nya nima na. ");
INSERT INTO xon_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni yaa koo lidichal libaa ni kan, ni doon bi ki bui bi ke Uwumbɔr aanyoor bi bi pu. ");
INSERT INTO xon_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lidichal ngbaan aanib yaa gaa nimi kan, Uwumbɔr aanyoor ga li bi bi pu. Bi yaa kaa gaa nimi kan, waanyoor aan li bi bi pu. ");
INSERT INTO xon_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lidichal libaa aanib, bee kitiŋ kibaa aanib yaa kaa gaa nimi, ki yaa kaa kii nimi aabɔr kan, ni nyan nima ki kpaar nitaa aatatan ki lii nima. ");
INSERT INTO xon_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","M tuk nimi mbamɔn la, bundaln Uwumbɔr ga nan ji binib tibɔr na, binib ngbaan aatafadaan ga jer Sodom ni Gomora aatim aanib aatafadaan.” ");
INSERT INTO xon_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“M ga tun nimi, ni ti moon Uwumbɔr aabɔr. Ni ga li bi ke ipiih i bi ŋisapol aakaasisik ni na la. Ni li kpa nlan ke iwaa aah kpa nlan pu na, ki li bi suuna ke ŋinanjel aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ni li nyi man. Bi ga nan chuu nimi ki ji nimi tibɔr, ki gbaa nimi ŋinaalab mmeen aadir ni. ");
INSERT INTO xon_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","M pu, le ntim aaninkpiib ni bibɔrb ga ji nimi tibɔr. Le ni ga tuk Juu yaab, ni bi kaa ye Juu yaab na tibɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bi yaa chuu nimi kan, ni taa baa nisui ni ke ni ga len kinye; n‑yoonn ngbaan yaa nan fuu ni kan, Uwumbɔr Aafuur Nyaan le ga tuk nimi naah ga len pu na; ");
INSERT INTO xon_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","naa ye nimi le ga len, Nite Uwumbɔr Aafuur Nyaan le ga cha ni len. ");
INSERT INTO xon_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Binib ga di binaabitiib ŋa binib aaŋaal ni, ke bi ti ku bi. Tetiib mu ga di baabim ŋa binib aaŋaal ni, ke bi ti ku bi. Binib mu ga yii bitetiib ni binatiib, ki cha binib ku bi. ");
INSERT INTO xon_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Le binib mɔmɔk ga li nan nimi m pu. Unii umɔk jin limɔr ki dii mi ki ti saa limɔfal aadoon na, uma le ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bi yaa ŋa nimi falaa kitiŋ kibaa ni kan, ni san buen kitiŋ kiken ni. M tuk nimi mbamɔn la, buyoonn min Unibɔn Aabo ga nan gir ni na, naan kee bɔ dii Israel yaab aatim mɔmɔk ni, ki doo. ");
INSERT INTO xon_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Unii u bae mbaem na aa jer waamɔmɔkr. Unaagbiija ubaa mu aa jer udindaan. ");
INSERT INTO xon_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Unii u bae mbaem na yaa bi ke waamɔmɔkr aah bi pu na kan, cha unimbil gbiin kina. Unaagbiija yaa bi ke udindaan na kan, cha unimbil gbiin kina. Bi yaa yin udichadaan kinimbɔŋdaan kan, baan yin waachiln ni aanib mu kinimbɔŋdam aa?” ");
INSERT INTO xon_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ni taa san binib ijawaan man. Tibɔbɔrkaan mɔmɔk ga kpiir. Tibɔr timɔk bɔɔ na, ti ga nyan mpaan pu. ");
INSERT INTO xon_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Maah tuk nimi tibɔr ti libɔɔl ni na, ni li mooni ti binib ni. Maah loon tibɔr ti nitafal ni na, ni li mooni ti lipaal. ");
INSERT INTO xon_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ni taa san binib ijawaan man. Bi ga ŋmaa ku nimi aawon baanja la. Baan ŋmaa ku nimi aawiin. Ni li san Uwumbɔr u ga ŋmaa bii tiwon ni nwiin mɔmɔk mmii mu kaan junn na ponn ni na. ");
INSERT INTO xon_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bi kooh iyaar ilee janjan ubaa la. Nite Uwumbɔr yaa kaa kii kan, uyaar ubaa aan lir ni kitiŋ. ");
INSERT INTO xon_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Uwumbɔr nyi nimi aayikpir aakahm. ");
INSERT INTO xon_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nima pu na, ni taa san ijawaan man. Ni jer iyaar pam.” ");
INSERT INTO xon_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Unii umɔk len binib aanimbil ni ke u ye miyoo na, m mu ga len Nte Uwumbɔr u bi paacham na aanimbil ni ke udaan ngbaan le ye miyoo. ");
INSERT INTO xon_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Unii umɔk len binib aanimbil ni ke waa ye miyoo na, m mu ga len Nte Uwumbɔr u bi paacham na aanimbil ni ke udaan ngbaan aa ye miyoo.” ");
INSERT INTO xon_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Maah dan dulnyaa wee ni na, ni taa dak ke nima le ga cha binib mɔmɔk li kpaa kimɔbaan. M pu, le butɔb ga li bi. ");
INSERT INTO xon_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M pu, uja ga kpak ute kinikpakpak, usapɔɔn mu ga kpak una, upii mu ga kpak uchapii. ");
INSERT INTO xon_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Unii aadim ga li ye waachiln ni aanib la. ");
INSERT INTO xon_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Unii umɔk gee ute, bee una ki jer mi na, waa ŋeer u le ye maadidiir. Unii umɔk gee ujapɔɔn, bee ubisal ki jer mi na, u mu aa ŋeer u le ye maadidiir. ");
INSERT INTO xon_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Unii umɔk kaan yoor waadɔpuinkoo ki dii mi na kan, waa ŋeer u le ye maadidiir. ");
INSERT INTO xon_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Unii yaa kaa kii ke u kpo m pu kan, waamɔfal ga bee yɔli la. Unii yaa kpo m pu kan, u ga kan limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Unii yaa gaa nimi maanib kan, u gaa mi le na. Unii yaa gaa mi kan, u gaa Uwumbɔr u tun ni mi na le na. ");
INSERT INTO xon_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Unii yaa gaa Uwumbɔr aabɔnabr kan, waah ye Uwumbɔr aabɔnabr na pu le cha u gaa u, nima na, u ga kan Uwumbɔr aabɔnabr aapal. Unii yaa gaa uninyaan kan, waah ye uninyaan na pu le cha u gaa u, nima na, u ga kan uninyaan aapal. ");
INSERT INTO xon_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","M tuk nimi mbamɔn la, unii umɔk tii maadidiir waatiir ubaa nnyunyunkoo baanja na kan, waah ye maadidiir pu na le cha u tii u, nima na, u ga kan tiyaapar.” ");
INSERT INTO xon_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu aah tuk waadidiliib kina ki ti doo na, le u siir nima, ki buen ti moon Uwumbɔr aabɔr itingbaan ni. ");
INSERT INTO xon_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Le Jɔnn u muini binib nnyun ni na bi kiyondiik ponn ni ki ŋun Yesu Kristo aah tun pu na. Le u tun ni waadidiliib u chee ");
INSERT INTO xon_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ke bi ti baa u ke u ye unii u Uwumbɔr aabɔnabtiib nan len ke u ga dan na aan waa ye? Bi li ban uken aa? ");
INSERT INTO xon_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Le Yesu bui bi, “Gir buen Jɔnn chee ki ti tuk u naah ŋun pu na, ni naah kan pu na: ");
INSERT INTO xon_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ke m likr bijoom aanimbil, ki cha biwɔb, ni bikɔndam, ni bitafakpaab pɔɔk, ki fikr binib bi kpo na nkun ni, ki tuk bigiim Uwumbɔr aabɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Unii u kaa joo mi beeni na, Uwumbɔr aanyoor bi u pu.” ");
INSERT INTO xon_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Le Jɔnn aadidiliib ki gir buen u chee. Baah cha na, le Yesu len kinipaak ngbaan chee Jɔnn aabɔr ke, “Naah nan buen Jɔnn chee nteersakpiin ni na, ni nan buen ni ti kan ba? Lipul li libuln fiini li na aa? Aayii. ");
INSERT INTO xon_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ni nan buen ni ti kan ba? Uja u pee tiwanyaan na aa? Aayii. Binib bi pee tiwanyaan na bi bibɔrb aadichal ni la. ");
INSERT INTO xon_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ni nan buen ni ti kan ba? Uwumbɔr aabɔnabr aa? Mbamɔn, m tuk nimi la, ni nan kan unii u jer Uwumbɔr aabɔnabr na. ");
INSERT INTO xon_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr bui ke, ‘Maatutunn sɔ. M tun ni u ke u loln ni nsan ki nan toor nsan ki siin si.’ Jɔnn le ye ututunn ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","M tuk nimi mbamɔn la, baa kee ma unii ubaa u jer Jɔnn u muini binib nnyun ni na. Le unii u ye uwaatiir Uwumbɔr aanaan ni na jer Jɔnn. ");
INSERT INTO xon_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Buyoonn Jɔnn nan fuu ni ki nan saa dandana na, le binib aanimbil man ke bi ti koo Uwumbɔr aanaan ni, le ki koo mpɔɔn pu. ");
INSERT INTO xon_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Uwumbɔr aakaal ni waabɔnabr aaliin nan len Uwumbɔr aanaan aah ga li bi pu na, ki nan saa Jɔnn aayoonn. ");
INSERT INTO xon_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni yaa ban ke ni pak baah nan len pu na kan, ni ga bee ke Jɔnn ye Uwumbɔr aabɔnabr Elaija u bi nan len ke u ga fuu ni na la. ");
INSERT INTO xon_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","U kpa litafal u ŋun na kan, u ŋun. ");
INSERT INTO xon_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“M ga di ba ŋaŋ dandana aanib ngbaan? Bi bi ke mbim mu ka kinyaŋ ni ki bui biŋeen aatɔtiib, ");
INSERT INTO xon_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ti pii ŋiwul tii nimi, le naa saar. Ti wii ikpowiil, le naa kaani.’ ");
INSERT INTO xon_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Dandana aanib ngbaan mu bi kina la; Jɔnn dan ki nan lulni bumɔb, kaa nyu ndaan, le bi len ke u kpa kinimbɔŋ. ");
INSERT INTO xon_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Min Unibɔn Aabo dan le ki ji ki nyu, le bi len ke m ye upusakpiindaan ki ye udanyur, ki jɔnni bilampoogaab ni titunwanbirdam. Tɔ, nlan aah tun pu na le mɔk ke mu ŋan.” ");
INSERT INTO xon_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","N‑yoonn ngbaan le Yesu piin ki bi len ki kae ntim mubaa aanib. U nan tun lijinjiir aatun pam ntim ngbaan ponn ni, le baa kpeln baabimbin. Nima le cha u kae bi. ");
INSERT INTO xon_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","U nan len ke, “Korasinn aatiŋ aanib, tibɔbir bi ni pu. Betseda aatiŋ aanib, tibɔbir bi ni mu pu; ba pu? m yaa ba nan tun lijinjiir aatun Taya aatiŋ ponn ni, ni Saidonn aatiŋ ponn ni ke maah tun ni ponn ni pu na kan, bi ba ga kpeln baabimbin ni yunn a, ki li pee tiwanpeenkaan ni saak kuub na, ki di nfatan puk biyil, aan ki mɔk ke bisui bii baatunwanbir pu. ");
INSERT INTO xon_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","M tuk nimi la, bundaln Uwumbɔr ga ji binib tibɔr na, nimi aatafadaan ga jer Taya ni Saidonn aatim aanib aatafadaan. ");
INSERT INTO xon_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nimi Kapenaum aatiŋ aanib, bi ga yoor nimi paacham aa? Aayii. Bi ga sunn nimi kitekpiitiŋ ni; ba pu? m yaa ba nan tun lijinjiir aatun Sodom aatiŋ ponn ni ke maah tun ni ponn ni pu na kan, kitiŋ ngbaan ba ga li bi ki nan saa dandana wee. ");
INSERT INTO xon_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","M tuk nimi la, bundaln Uwumbɔr ga ji binib tibɔr na, nimi aatafadaan ga jer Sodom aatiŋ aanib aatafadaan.” ");
INSERT INTO xon_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","N‑yoonn ngbaan le Yesu bui ke, “Nte Uwumbɔr, u ye paacham ni taab Aadindaan na, aa bɔr tibɔr timina bilankpalb ni binimbiwolm, le ki di mɔk chapɔntiib, nima pu le m pak si. ");
INSERT INTO xon_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nte, saageehn le na, nima le cha aa ŋa kina. ");
INSERT INTO xon_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tɔ, Nte Uwumbɔr le tii mi tiwan mɔmɔk. Ubaa aa nyi min Uwumbɔr Aajapɔɔn, see Nte Uwumbɔr. Ubaa mu aa nyi Nte Uwumbɔr, see min Ujapɔɔn. Binib bi m ban ke m di Uwumbɔr mɔk bi na, bi mu nyi u. ");
INSERT INTO xon_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nimi bimɔk tun lituln ki ti bak na, dan m chee man, le m ga tii nimi lifuur. ");
INSERT INTO xon_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gaa maatuln man, ki bae mbaem m chee; m bi suuna, ki sunn mbaa taab. Ni ga kan lifuur; ");
INSERT INTO xon_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ba pu? maamɔkm aa pɔɔ. Maatuln mu aa nyuun.” ");
INSERT INTO xon_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","N‑yoonn ngbaan le Yesu ni waadidiliib bɔ dii kisaak kibaa ponn ni, Juu yaab aakpaakool daal. Nkon nan joo waadidiliib, le bi piin ki bi chur tijikaar ki geei ki per ki ŋmɔ. ");
INSERT INTO xon_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Le Farisii yaab kan baah ŋani pu na, le ki bui Yesu, “Lik saadidiliib aah ŋani pu na. Timi aakaal aa kii ke bi ŋa kina likpaakool daal.” ");
INSERT INTO xon_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Le u baa bi, “Naa karn Ubɔr David aah nan ŋa pu na aa? Nkon nan joo u ni waanib. ");
INSERT INTO xon_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Le u koo Uwumbɔr Aadichal ni. Le u ni bi ŋman Uwumbɔr aaboroboro. Baah ŋman boroboro ngbaan na, le bi bii Moses aakaal mu len ke Uwumbɔr aatotoorb baanja le ga ŋmɔ boroboro ngbaan na. ");
INSERT INTO xon_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tɔ, likpaakool daal mɔmɔk Uwumbɔr aatotoorb bi bi waadichal ni na mu bii likpaakool daal aakaal, le ubaa aa galni bi. Naah kee karn kina Nkaal aagbaŋ ni ii? ");
INSERT INTO xon_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","M tuk nimi la, unii u jer Uwumbɔr Aadichal na bi do. ");
INSERT INTO xon_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Uwumbɔr Aagbaŋ len ke waa ban ke binib toor kitork baanja ki tii u. U ban ke bi li san tɔb kinimbaak. Ni yaa ba nyi iliin ngbaan aatataa kan, naa ba ga galn binib bi kaa kpa taani na. ");
INSERT INTO xon_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tɔ, min Unibɔn Aabo le ye likpaakool daal mu Aadindaan.” ");
INSERT INTO xon_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Le u siir nima, ki koo baameen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Le uja u aaŋaal faan na bi nima. Le bi ban ke bi galn Yesu, le ki baa u, “Timi aakaal kii ke unii li tei bibum likpaakool daal aa?” ");
INSERT INTO xon_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Le u baa bi, “Ni ponn ni ubaa yaa kpa upiih ubaa aan u yaa lir liboln ni likpaakool daal kan, saan nyan u uu? ");
INSERT INTO xon_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Unibɔn aa jer upiih ii? Nima le mɔk ke timi aakaal kii ke ti ŋani ni ŋan na likpaakool daal.” ");
INSERT INTO xon_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Waah len kina na, le u bui uja u aaŋaal faan na, “Taln aaŋaal.” Le u taln uŋaal. Le mu naar, ki pɔɔk ke muken na. ");
INSERT INTO xon_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Le Farisii yaab nyan lipaal, le ki kpokl baah ga ŋa pu ki ku Yesu na. ");
INSERT INTO xon_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu nan bee baah kpokl pu na, le ki siir nima. Kinipaak nan dii u, le u cha bibum mɔmɔk pɔɔk, ");
INSERT INTO xon_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","le ki bui bi ke bi taa li joo u mooni. ");
INSERT INTO xon_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Waah ŋa kina na, le ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan len pu na, ke Uwumbɔr len ke, ");
INSERT INTO xon_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Maatutunn u m lee u na sɔ. M gee u, le u gbiin nnimbil. M ga di Maafuur Nyaan gbiin u. Le u ga tuk ŋinibol mɔmɔk maah ga ji binib tibɔr pu na. ");
INSERT INTO xon_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waan li kpak kinikpakpak, kaan li tar, kaan li kpa kifuuk ntim ni, ");
INSERT INTO xon_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","kaan koo lidabil li boon na, kaan junn karyaa u kaa wiin mbamɔm na. U ga kan linyaŋ, ki tii binib mɔmɔk baabamɔn. ");
INSERT INTO xon_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","U pu, le ŋinibol aanib mɔmɔk ga li kpa limakl.” ");
INSERT INTO xon_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Le binib bibaa joo ni unii u tiyayaar ŋa u ujoon ni ubir na Yesu chee. Le Yesu cha u pɔɔk, le u len, unimbil mu likr. ");
INSERT INTO xon_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Le ni gar kinipaak ngbaan mɔmɔk pam. Le bi bi baa tɔb, “Uja ngbaan sil ye Ubɔr David Aayaabil aa?” ");
INSERT INTO xon_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisii yaab aah ŋun kina na, le bi len ke Beelsebul, u ye tiyayaar aayidaan na, le tii u mpɔɔn ke u nyan tiyayaar binib ni. ");
INSERT INTO xon_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Le Yesu bee baalandakbir ngbaan, le ki bui bi, “Nnaan mubaa ni aanib yaa jaa tɔb kijaak kan, nnaan ngbaan ga bee yɔli la. Kitiŋ kibaa ni aanib mu yaa jaa tɔb kijaak kan, kitiŋ ngbaan ga bee yɔli. Lidichal libaa ni aanib mu yaa jaa tɔb kijaak kan, lidichal ngbaan ga bee yɔli. ");
INSERT INTO xon_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tiyayaar aayidaan yaa nyan tiyayaar binib ni kan, u jan ubaa kijaak la. Waanaan ga ŋa kinye aan ki sil? ");
INSERT INTO xon_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni yaa len ke tiyayaar aayidaan Beelsebul le tii mi mpɔɔn ke m nyan tiyayaar binib ni kan, ke ŋma tii nimi aanib mu mpɔɔn ke bi nyan tiyayaar binib ni? Nimi aanib aah ŋani pu na le ga mɔk ke ni kpa mbamɔn bee naa kpa. ");
INSERT INTO xon_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tɔ, Uwumbɔr Aafuur Nyaan le tii mi mpɔɔn le m nyani tiyayaar binib ni. Nima le mɔk ke Uwumbɔr aanaan fuu ni ni chee.” ");
INSERT INTO xon_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ubaa aan ŋmaa koo mpɔɔndaan aadichal ni ki bii waawan, see u puen buu u le waahr, le ki nin bii waadichal. ");
INSERT INTO xon_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Unii umɔk kaa dii mi na, u ye maadin la. Unii umɔk kaa kuuni binib tii mi na, u yaal bi la. ");
INSERT INTO xon_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","M tuk nimi la, Uwumbɔr ga di cha pinn binib aatunwanbir ni baasiibil mɔmɔk. Tɔ, unii yaa sii Uwumbɔr Aafuur Nyaan ma kan, Uwumbɔr aan di cha pinn udaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Unii yaa bii min Unibɔn Aabo kan, Uwumbɔr ga di cha pinn u. Unii yaa bii Uwumbɔr Aafuur Nyaan kan, Uwumbɔr aan di cha pinn u dulnyaa wee ni, kaan di cha pinn u paacham mu.” ");
INSERT INTO xon_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Busub yaa ŋan kan, bu aasubil ga li ŋan. Bu yaa kaa ŋan kan, bu aasubil mu aan li ŋan. Bu aasubil pu le aa ga bee bu aah ye busub bu na. Kina le unii aatuln pu le ga cha aa bee ke u ŋan aan waa ŋan. ");
INSERT INTO xon_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nimi ikuub aabim, ni ye titunwanbirdam la. Ni ga ŋa kinye ki len iliin i ŋan na? Ilandak i gbii unii aasui ni na, ima le u ga len. ");
INSERT INTO xon_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ilandak nyaan bi uninyaan aasui ni, nima le u ga len iliin i ŋan na. Ilandak i kaa ŋan na bi unii u kaa ŋan na aasui ni, nima le u ga len iliin i kaa ŋan na. ");
INSERT INTO xon_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“M tuk nimi la, bundaln Uwumbɔr ga ji binib tibɔr na, liyaadaal ngbaan le bi ga kpiir baah nan len tibɔr yɔl yɔl ti na mɔmɔk ki tuk Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Saamɔliin le ga nyan si. Saamɔliin mu le ga bii si.” ");
INSERT INTO xon_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","N‑yoonn ngbaan le Uwumbɔr aakaal aamɔmɔkb bibaa ni Farisii yaab bibaa bui Yesu, “Umɔmɔkr, ti ban ke aa tun lijinjiir aatuln, aan tinimbil kan, aan ti gaa si ki kii.” ");
INSERT INTO xon_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Le u bui bi, “Nimi dandana aanib, ni ye titunwanbirdam la, kaa dii Uwumbɔr, nima le ni ban lijinjiir aatuln. Uwumbɔr aabɔnabr Jona aah nan bi ujan sakpiin aaponn ni iwiin itaa ni tinyer titaa pu na, ");
INSERT INTO xon_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","kina le min Unibɔn Aabo mu ga li bi kitiŋ ponn ni iwiin itaa ni tinyer titaa. Lijinjiir aatuln limina baanja le ni ga kan. ");
INSERT INTO xon_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jona nan tuk Ninefa aatiŋ aanib Uwumbɔr aabɔr. Le bi kpeln baabimbin. Min, u jer Jona na, le tuk nimi Uwumbɔr aabɔr, le naa kpeln nimi aabimbin. Bundaln Uwumbɔr ga ji binib tibɔr na, Ninefa aatiŋ aanib aah nan kpeln baabimbin pu na, nima le ga mɔk ke nimi aabɔr bii. ");
INSERT INTO xon_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Seba aapiibɔr nan nyan ni dandar ke u nan ŋun Ubɔr Solomonn aalan aaliin. Min u jer Solomonn na bi do la, le naa ŋun maaliin. Bundaln Uwumbɔr ga ji binib tibɔr na, upiibɔr ngbaan aah nan ŋa pu na, nima le ga mɔk ke nimi aabɔr bii.” ");
INSERT INTO xon_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tiyayaar yaa nyan unii ni kan, ti ga li chuun gɔr nnyun aah kaa bi kipɔɔk ki ponn ni na, ki ban taah ga kal nin chee ki fuur na, kaan kan. ");
INSERT INTO xon_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Le ti ga len ke ti ga gir kun taah nyan unii u ponn ni na la. Le ti ga gir ni, le ki nan kan ke bi toor taakookoo yaan ki ŋa mu mbamɔm, nibaa aa bi ni ni. ");
INSERT INTO xon_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Le ti ga buen ki ti joo ni tiyayaar tilole ti bir ki jer ti na. Le ti mɔmɔk ga nan koo unii ngbaan ponn ni, ki ga li bi u ponn ni, le ki bii u ki jer waah nan bi njan pu na. Kina le ni ga li bi dandana aanib bi kaa ŋan na chee.” ");
INSERT INTO xon_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu aah bi len kinipaak ngbaan chee na, le una ni unaatiib dan nan sil lipaal ki ban ke bi len u chee. ");
INSERT INTO xon_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Le kinipaak ngbaan ponn ni ubaa tuk u, “Aana ni aanaatiib si lipaal ki ban bi len aa chee.” ");
INSERT INTO xon_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Le u baa bi, “Ŋma ye nna? Bilabi ye nnaatiib?” ");
INSERT INTO xon_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","le ki taln uŋaal mɔk waadidiliib, le ki bui ke, “Lik, nna ni nnaatiib sɔ. ");
INSERT INTO xon_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ba pu? unii umɔk ŋani Nte Uwumbɔr u bi paacham na aah gee pu na, uma le ye nnaal, ni nninkpan, ni nna.” ");
INSERT INTO xon_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Liyaadaal ngbaan le Yesu nyan lipaal, le ki buen ki ti kal nnyusakpem aagbaan. ");
INSERT INTO xon_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Le kinipaak sakpeŋ dan u chee, ki wiir. Nima le u koo buŋɔb ni, nnyun ni, le ki kal bu ponn ni. Kinipaak ngbaan mɔmɔk mu si lipaal. ");
INSERT INTO xon_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Le u tuk bi tibɔr pam ŋiyataŋak ponn ni, le ki bui ke, “Ukpaal ubaa le nan buen u ti yaa njikaabim. ");
INSERT INTO xon_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Waah yaa na, le mubaa lir nsan ponn ni. Le inyoon dan nan peei jin. ");
INSERT INTO xon_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Le mubaa mu lir ntakpateer paab, titan aah kaa wiir nin chee na. Titan aah kaa wiir na, le mu guu puln mala. ");
INSERT INTO xon_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Le nwiin puu, ki ton, ki see mu. Mu aah kaa kpa inyaan mbamɔm na, le mu yɔl. ");
INSERT INTO xon_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Le mubaa mu lir ikokon ponn ni. Le ikokon muun le ki ku mu. ");
INSERT INTO xon_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Le mubaa mu lir kitiŋ ki ŋan na ponn ni le ki mar. Ngem lun nkub nkub, ngem mu lun imonko itata, ngem mu lun piitaa piitaa. ");
INSERT INTO xon_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Le waadidiliib dan nan baa u, “Ba pu aa ŋak bi ŋiyataŋak?” ");
INSERT INTO xon_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Le u bui bi, “Nimi le Uwumbɔr cha ni bee waanaan aabɔbɔrkaan, kaa cha bima bee. ");
INSERT INTO xon_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Unii u kpa nlan ki bee Uwumbɔr aanaan aabɔr na, Uwumbɔr ga kpee u, le u li kpa sakpen. Unii u kaa kpa na, Uwumbɔr ga chuu gaa waah kpa mu pɔkaa na. ");
INSERT INTO xon_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kinipaak ngbaan lik, kaa waa, ki pel kaa ŋun, kaa bee maaliin aatataa. Nima le cha m ŋak bi ŋiyataŋak. ");
INSERT INTO xon_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Baah bi pu na, le ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan len pu na ke, ‘Bi ga pel ki pel, kaan bee Uwumbɔr aaliin aatataa. Bi ga lik ki lik kaan li waa. ");
INSERT INTO xon_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ba pu? binib ngbaan aasui aa bi nibaa ni. Bitafal kpaa la. Bi ŋub binimbil, kaa ban ke binimbil woln, kaa ban ke bitafal ŋun, kaa ban ke bisui bee Uwumbɔr aaliin aatataa, kaa ban ke bi kpeln baabimbin ki dii Uwumbɔr aasan ke u tii bi laafee.’ ");
INSERT INTO xon_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nimi maadidiliib, Uwumbɔr aanyoor bi ni pu; ba pu? ninimbil woln, nitafal mu ŋun. ");
INSERT INTO xon_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","M tuk nimi mbamɔn la, Uwumbɔr aabɔnabtiib pam ni bininyaam pam nan ban bi kan naah kan tiwan ni na, kaa kan. Bi nan ban bi ŋun naah ŋun tibɔr ti na, kaa ŋun ti.” ");
INSERT INTO xon_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Li pel man aan m tuk nimi unii u yaa njikaabim na aayataŋakl aatataa. ");
INSERT INTO xon_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Binib yaa ŋun Uwumbɔr aanaan aabɔr kaa bee taatataa kan, le kinimbɔŋ ga dan nan nyan tibɔr ti bi bisui ni na. Njikaabim mu lir nsan ponn ni na le na. ");
INSERT INTO xon_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Njikaabim mu lir ntakpateer pu na mu ye binib bi ŋun tibɔr ngbaan, ki gaa ti mala ni mpopiin na. ");
INSERT INTO xon_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bi mu aa gaa ti mbamɔm bisui ni. Bi ga li joo ti ni yunn siib. Bi yaa kan limukl ti pu kan, bee binib yaa ŋa bi falaa ti pu kan, libuul ngbaan ni, le bi ga di ti lii. ");
INSERT INTO xon_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Binib ngem mu bi ke njikaabim mu lir ikokon ponn ni na la. Bi ŋun tibɔr ngbaan la. Le bitafal bi baabimbin ni, ni liwankpal ni. Nima le ku tibɔr ngbaan bisui ni, le taa mar. ");
INSERT INTO xon_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Binib bi ŋun tibɔr ngbaan ki bee taatataa, ki kii ti na, bima le bi ke njikaabim mu lir kitiŋ ki ŋan na ponn ni, ki mar na. Ngem lun nkub nkub, ngem mu lun imonko itata, ngem mu lun piitaa piitaa.” ");
INSERT INTO xon_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nan ki ŋakl bi liyataŋakl liken ke, “Uwumbɔr aanaan naahn ukpaal u yaa ipui i ŋan na waakpaab ni na la. ");
INSERT INTO xon_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kinyeek kibaa daal, binib aah dɔ geen na, le waadin dan nan di timoor yaa ŋmal ipui ngbaan ponn ni, le ki buen. ");
INSERT INTO xon_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ipui aah muun ki mar na le bi kan ke timoor mu bi i ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Le ukpaal ngbaan aatutum dan nan baa u, ‘Timi aaninkpel, saa nan di ipui i ŋan na le di yaa saakpaab ni ii? Timoor ngbaan mu nyan ni la?’ ");
INSERT INTO xon_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Le u bui bi, ‘Maadin ubaa le ŋa kina.’ Le bi baa u, ‘Aa ban ke ti buen ti ŋɔi nyan timoor ngbaan aa?’ ");
INSERT INTO xon_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Le u bui bi, ‘Aayii. Di cha ti man. Ni yaa ŋɔi nyan timoor ngbaan kan, nibaakan, ipui ibaa mu ga li kpaan ŋɔi ki dii ti. ");
INSERT INTO xon_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cha man ipui ngbaan ni timoor ngbaan kpaan muun, aan ki nan biir. Ni yaa nan ŋeer lipuicheel kan, m ga tuk bipuicheeb: Puen ŋɔi nyan man timoor ngbaan waahr, aan ki buu ti, ki di see mmii, aan ki nin chee ipui ki di fu maapil ponn ni.’” ");
INSERT INTO xon_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu nan ki ŋakl bi liyataŋakl liken ke, “Uwumbɔr aanaan naahn linaanyiimbil li uja ubaa nan di bun waakpaab ni na la. ");
INSERT INTO xon_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tisufar ngbaan aabil le ye liwaatiir, ŋibil mɔmɔk filk jer lima la. Bi yaa di libil ngbaan bun kan, li ga puln ki muun, ki jer tisufar mɔmɔk, ki ga ŋa busub la. Le inyoon i laani paacham na dan nan ter yaadil bu aabon pu.” ");
INSERT INTO xon_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu nan ki ŋakl bi liyataŋakl liken ke, “Uwumbɔr aanaan naahn boroboro aanyɔk mu upii nan di ŋa boroboro aayon ponn ni, aan boroboro ngbaan mɔk duun na la.” ");
INSERT INTO xon_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kina le Yesu ŋakl ŋiyataŋak ki tuk kinipaak ngbaan, kaa len tibaa bi chee see ŋiyataŋak ŋmeen. ");
INSERT INTO xon_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Waah ŋa kina na, le ni gbiin Uwumbɔr aabɔnabr aah nan len pu na ke, “M ga waar mmɔb ki ŋakl ŋiyataŋak, ki len tibɔbɔrkaan ti nan bɔr buyoonn Uwumbɔr nan naan dulnyaa wee ki nan saa dandana wee na.” ");
INSERT INTO xon_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu nan siir cha kinipaak ngbaan, ki gir buen kidiik ni. Le waadidiliib dan u chee, ke u tuk bi timoor ti bi ipui ponn ni na aayataŋakl aatataa. ");
INSERT INTO xon_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Le u bui bi, “Ukpaal u yaa ipui i ŋan na le ye min Unibɔn Aabo. ");
INSERT INTO xon_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Bukpaab ngbaan le ye dulnyaa wee. Ipui i ŋan na le ye Uwumbɔr aanaan ni aanib. Timoor ngbaan le ye kinimbɔŋ aanib. ");
INSERT INTO xon_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ukpaal aadin u yaa timoor ngbaan na le ye kinimbɔŋ. Lipuicheel le ye dulnyaa aadoon. Bipuicheeb ngbaan le ye Uwumbɔr aatuuntiib. ");
INSERT INTO xon_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Baah nan ŋɔi timoor ti ki di see mmii ponn ni na, dulnyaa aadoon ga nan li bi kina la. ");
INSERT INTO xon_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Min Unibɔn Aabo ga tun ni maatuuntiib dulnyaa wee ni, bi nan chuu titunwanbirdam, ni bitɔtɔŋ mɔmɔk, aan ki nyan bi maanaan ni, ");
INSERT INTO xon_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ki di ti ŋa mmii sakpiin ni. Bi ga wii ki ŋmɔ ŋinyin nima chee. ");
INSERT INTO xon_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","N‑yoonn ngbaan le bininyaam ga li bi Bite Uwumbɔr aanaan ni, ki wiin ke nwiin aah wiin pu na. U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Uwumbɔr aanaan naahn liwankpal li bɔɔ bukpaab ni, kitiŋ ponn ni na la. Le uja ti kan liwankpal ngbaan, le ki ki di biin li pu. Le ni mɔ u ki ti nyaŋ. Le u buen ke u ti kooh waawan mɔmɔk, ki gir ti daa bukpaab ngbaan.” ");
INSERT INTO xon_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Uwumbɔr aanaan naahn uwankooh u chuun ban nleen mam mu ŋan na ke u daa na la, ");
INSERT INTO xon_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","le ki ti kan nleenyaan mu kpa kidaak sakpen na, le ki buen ti kooh waawan mɔmɔk, ki ti daa nleenyaan ngbaan.” ");
INSERT INTO xon_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Uwumbɔr aanaan naahn kipɔɔk ki bijanbam di mee nnyun ni ki chuu ijan mɔk aabɔŋ na la. ");
INSERT INTO xon_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kaah gbiin ijan na, le bi dar ki nyan lipaal, le ki kal ki gann ijan i ŋan na ki di ŋa tibɔɔkur ni, ki cha i kaa ŋan na, ki di mee. ");
INSERT INTO xon_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Dulnyaa aadoon mu ga nan li bi kina la. Uwumbɔr aatuuntiib ga nan dan dulnyaa ni, ki nan gann titunwanbirdam bininyaam ponn ni, ");
INSERT INTO xon_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ki ti di ŋa mmii sakpiin ni, binib aah wii ki ŋmɔ ŋinyin nin chee na.” ");
INSERT INTO xon_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Le Yesu baa bi, “Ni bee tibɔr timina mɔmɔk aatataa aa?” Le bi kii, “Een.” ");
INSERT INTO xon_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Le u bui bi, “Unii u tuk binib Uwumbɔr aakaal na yaa dii mi kan, u naahn udichadaan u nyan ni waawankpal ponn ni tiwankpokr ni tiwapɔnn.” ");
INSERT INTO xon_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Waah nan ŋakl ŋiyataŋak ngbaan ti doo na, le u siir nima, ");
INSERT INTO xon_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","le ki gir kun udo aatiŋ Nasaref ni, le ki ti koo mmeen aadiik ni, ki tuk binib Uwumbɔr aabɔr. Waah tuk bi pu na, le ni gar bi. Le bi baa tɔb, “Uja wee kan nlan mue la chee? U kan mpɔɔn mue la chee ki tun lijinjiir aatun ngbaan? ");
INSERT INTO xon_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Waa ye kapenta na aabo la aa? Una aa ye Mari la aa? Unaatiib aa ye Jems, ni Josef, ni Simonn, ni Judas la aa? ");
INSERT INTO xon_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Uninkpatiib mɔmɔk aa bi do chee na la aa? U kan nlan mue, ni mpɔɔn mue la chee?” ");
INSERT INTO xon_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bi nan len kina le ki yii u. Le Yesu bui bi, “Binib pak Uwumbɔr aabɔnabtiib see bido aatiŋ ni aanib, ni baachiln ni aanib baanja le aa pak bi.” ");
INSERT INTO xon_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Baah kaa gaa u ki kii na, waa nan tun lijinjiir aatun pam nima chee. ");
INSERT INTO xon_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","N‑yoonn ngbaan le Ubɔr Herod ŋun Yesu bɔr, ");
INSERT INTO xon_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","le ki bui waatutum ke, “Jɔnn u nan muini binib nnyun ni na le na. U fikr nkun ni la. Nima le cha u kpa mpɔɔn, ki tun lijinjiir aatun.” ");
INSERT INTO xon_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Budabu pu Herod len kina na le ye ke u nan chuu Jɔnn ki buu u tikululn ki di u ŋa kiyondiik ni. Taani u cha u nan chuu u na le ye ke Jɔnn nan bui u ");
INSERT INTO xon_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ke waah joo unaal aapuu Herodias na, naa ŋan, ke u bii Uwumbɔr aakaal la. ");
INSERT INTO xon_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jɔnn aah nan len kina na, le Herod ban ke u ku u, le ki san Juu yaab ijawaan. Bi nan len ke Jɔnn ye Uwumbɔr aabɔnabr la. ");
INSERT INTO xon_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Le Herod aamaaldaal aawiin fuu ni. Le u ŋa tijiir ke bi ji. Le Herodias aabisal dan nan waa liwaal, Ubɔr Herod ni waanib aanimbiin ni. Le ni mɔɔr Herod sakpen. ");
INSERT INTO xon_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Le u puu tipuur ke u ga tii u waah ban pu na. ");
INSERT INTO xon_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Le una bui u ke u bui Ubɔr Herod ke u tii u Jɔnn aayil likusambil ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Usapɔɔn ngbaan aah bui u kina na, le Ubɔr Herod aasui bii. Waah puu tipuur ti bicham aanimbil ni na pu, waa ban ke ti bee. ");
INSERT INTO xon_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nima le u tun unii ke u li cha kiyondiik ponn ni ki ti gii ni Jɔnn aayil. ");
INSERT INTO xon_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Le u ti joo ni uyil likusambil ponn ni ki nan di tii usapɔɔn ngbaan. Le u mu di ti tii una. ");
INSERT INTO xon_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Le Jɔnn aadidiliib dan nan yoor linikpol ngbaan ki ti sub, le ki buen ti tuk Yesu. ");
INSERT INTO xon_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu aah ŋun kina na, le u koo buŋɔb ni, le ki buen kipɔɔk ni, binib aah kaa bi nin chee na. Le kinipaak ngbaan ŋun ke u buen, le ki nyan baatim ni, ki chuun kitiŋ ki buen u chee. ");
INSERT INTO xon_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Waah nyan buŋɔb ni na, le u kan kinipaak sakpeŋ, le ki san bi kinimbaak, le ki cha bi ponn ni bi ye bibum na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Naah joor na, le waadidiliib dan nan bui u, “Ti bi kipɔɔk ni la. Ni jer tijikaar aajim yoonn a. Cha kinipaak ngbaan buen itingbaan ni ki ti daa tijikaar ji.” ");
INSERT INTO xon_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Le u bui bi, “Taa cha bi buen man. Nimi nibaa tii bi tijikaar bi ji man.” ");
INSERT INTO xon_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Le bi bui u, “Ŋiboroboro kpin ŋiŋmu ni ijan ilee baanja le bi.” ");
INSERT INTO xon_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Le u bui bi, “Li joo ni tii ni mi man,” ");
INSERT INTO xon_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","le ki bui kinipaak ngbaan, “Kal kitiŋ timosɔnn pu man,” le ki yoor ŋiboroboro kpin ŋiŋmu ni ijan ilee ngbaan, ki waan lik paacham, ki doon Uwumbɔr, le ki gii boroboro ni ijan ngbaan, ki di tii waadidiliib. Le bi yakr siin kinipaak ngbaan mɔk aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bi mɔmɔk nan ŋman ki bab. Baah ŋman ki bab ki gur ni na, le Yesu aadidiliib nan yoor tijikaar ti gur na ki gbiin tibɔɔkur kipiik ni tilee. ");
INSERT INTO xon_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bijab bi jin tijikaar ngbaan na ga nan li fuu ŋichur ŋiŋmu. Baa nan kahn bipiib ni mbim kpee. ");
INSERT INTO xon_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Libuul ngbaan ni le Yesu muk waadidiliib ke bi koo buŋɔb ni ki loln u pu nsan ki puur nnyusakpem na. Le u tuk kinipaak ngbaan ke bi li chaa kun. ");
INSERT INTO xon_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Waah tuk bi kina na, le u jon lijool paab ubaa, u ti mee Uwumbɔr. Le ni mue. Le u bi nima chee ubaa. ");
INSERT INTO xon_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waadidiliib mu bi buŋɔb ni nnyusakpem aakaasisik ni. Libuln nan daar sakpen ki tok bi, tinyunkpenn mu yeŋni baaŋɔb. ");
INSERT INTO xon_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ikooja aah wii buyoonn na, le u chuun nnyun paab, ki buen bi chee, ki ti ŋaŋ bi. ");
INSERT INTO xon_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Waadidiliib aah kan u chuun nnyun pu na, le ijawaan chuu bi sakpen, le bi len ke ni ye utekpiir aawiin la, le ki faa ikuun tɔn tɔn. ");
INSERT INTO xon_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Libuul ngbaan ni le Yesu bui bi, “Chuu nibaa man. Min ye. Ni taa san ijawaan man.” ");
INSERT INTO xon_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Le Piita bui u, “Ndindaan, ni yaa sil ye si kan, bui mi ke m chuun nnyun pu ki dan aa chee.” ");
INSERT INTO xon_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Le Yesu bui u, “Li chuun choo.” Le Piita nyan buŋɔb ni, ki chuun nnyun paab ki cha Yesu chee. ");
INSERT INTO xon_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Le u kan libuln aah daar ki feeni tinyunkpenn pu na, le ki san ijawaan, le ki piin ki bi muini cha, le ki teen ke, “Ndindaan, nyan mi.” ");
INSERT INTO xon_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Libuul ngbaan ni le Yesu taln uŋaal ki chuu u, le ki bui u, “Saa gaa mi ki kii mbamɔm. Ba ŋa aa joo mi beeni?” ");
INSERT INTO xon_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Le bi mɔmɔk bilee koo buŋɔb ni. Libuul ngbaan ni le libuln ŋmin. ");
INSERT INTO xon_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Le binib bi bi buŋɔb ponn ni na gbaan Yesu aanimbiin ni, ki dooni u, le ki len ke, “Mbamɔn, aa sil ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Le bi fuu nnyusakpem aadapuul, Genesaret aatiŋ chee, le ki nyan buŋɔb ni. ");
INSERT INTO xon_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Le kitiŋ ngbaan aanib bee u, le ki buen itingbaan mɔmɔk ni, ki ti yoor bibum mɔmɔk, ki joo ni bi Yesu chee, ");
INSERT INTO xon_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ki nan mee u ke u cha bibum ngbaan meeh waabɔkul aamɔjuul. Binib bimɔk meeh li na pɔɔk libuul ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","N‑yoonn ngbaan le Farisii yaab, ni Uwumbɔr aakaal aamɔmɔkb nyan ni Jerusalem ni ki dan Yesu chee, le ki nan baa u, ");
INSERT INTO xon_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ba ŋa saadidiliib bii tiyaajatiib aakaal, kaa ŋir biŋaal aan ki nin ji tijikaar?” ");
INSERT INTO xon_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Le Yesu baa bi, “Ba ŋa ni mu bii Uwumbɔr aakaal, nimi aakaal pu? ");
INSERT INTO xon_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uwumbɔr len ke, ‘Aa li pak aate ni aana,’ ki ki len ke, ‘Unii yaa len tibɔbir lii ute bee una pu kan, ni ku u.’ ");
INSERT INTO xon_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tɔ, nimi le len ke unii yaa bui ute, bee una, ‘Maah ba ga tii si ni na, maan ki ŋmaa tii si. M di tii Uwumbɔr a,’ ");
INSERT INTO xon_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ki yaa kaa pak ute kan, ni len ke naa kpa taani. Naah len kina na, le ni yii Uwumbɔr aabɔr nimi aakaal pu. ");
INSERT INTO xon_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ni ye biŋmaŋmannim la. Uwumbɔr aabɔnabr Aisaya aah nan len nimi aabɔr pu na, u nan len mbamɔn la, ke, ");
INSERT INTO xon_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Binib ngbaan pak Uwumbɔr bumɔb ni la. Bisui daa u chee. ");
INSERT INTO xon_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bi dooni u yɔli la, ki mɔk binib biyaajatiib aakaal ke ni ye waakaal la.’” ");
INSERT INTO xon_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Le Yesu yin kinipaak ngbaan, ki nan bui bi, “Li pel man, aan ki bee man maah ga tuk nimi pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tijikaar ti koo unii aamɔb ni na aan ŋmaa ŋa u titunwanbirdaan. Tiwan ni nyan umɔb ni na, nima le ŋani u titunwanbirdaan.” ");
INSERT INTO xon_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Le Yesu aadidiliib dan nan baa u, “Saa nyi ke saah len pu na le cha Farisii yaab gee liŋuul aa?” ");
INSERT INTO xon_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Le u bui bi, “Tisufar timɔk Nte Uwumbɔr aa bun ti na, u ga chuu ŋɔi ti la. ");
INSERT INTO xon_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Taa gar bi man. Bi ye bisanmɔkb bi jɔb na la. Ujoon yaa mɔk ujoon nsan kan, bi mɔmɔk bilee ga lir libuul ponn ni la.” ");
INSERT INTO xon_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Le Piita bui Yesu, “Tuk timi liyataŋakl ngbaan aatataa.” ");
INSERT INTO xon_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Le Yesu baa bi, “Ni mu aa kee bee maaliin aatataa aa? ");
INSERT INTO xon_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tiwan ni koo unii aamɔb ni na koo lipuul ni, le u ti sɔnn. Naa nyi kina aa? ");
INSERT INTO xon_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tiwan ni nyan unii aamɔb ni na, ni nyan usui ni, ki ŋani u titunwanbirdaan la. ");
INSERT INTO xon_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tiwan ni nyan binib aasui ni na le ye ilandak i kaa ŋan na, ni linikul, ni kidagook aatuln, ni kinaayuk, ni linyamɔngee, ni ŋisiibil. ");
INSERT INTO xon_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nimina le ŋani unii titunwanbirdaan. U yaa kaa ŋir uŋaal ki ji tijikaar kan, nima le aan ŋa u titunwanbirdaan.” ");
INSERT INTO xon_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Le Yesu nyan nima, ki buen Taya ni Saidonn aatingbaan ni. ");
INSERT INTO xon_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Le upii u ye Kanaann aabo na bi nima, le ki dan nan teen ke, “Ndindaan, si u ye Ubɔr David Aayaabil na, san mi kinimbaak. Tiyayaar le joo mbisal ki muk u sakpen a.” ");
INSERT INTO xon_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Le Yesu aa len tibaa. Le waadidiliib dan nan gaŋ Yesu ke u jenn u, u paa bi pu ki kpa kifuuk sakpen a. ");
INSERT INTO xon_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Le Yesu bui bi, “Uwumbɔr tun ni mi ke m nan ter Israel yaab bi yenn Uwumbɔr aasan ni na baanja la.” ");
INSERT INTO xon_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Waah len kina na, le upii ngbaan dan ki nan gbaan unimbiin ni ki doon u, le ki bui u, “Ndindaan, ter mi.” ");
INSERT INTO xon_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Le Yesu bui u, “Ti yaa di mbim aajikaar ki di tii ibɔ kan, naa ŋan.” ");
INSERT INTO xon_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Le u bui u, “Ndindaan, ni ye mbamɔn la; ibɔ mu tee ji ŋijikaabol ŋi nyan ni idindaan aateebul pu ki lir ni kitiŋ na.” ");
INSERT INTO xon_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Le Yesu bui u, “Upii, aa gaa mi ki kii mbamɔm la. Saah ban pu na, ni ŋa kina ki tii si.” Libuul ngbaan ni le ubisal pɔɔk, kaa ki bun. ");
INSERT INTO xon_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu nan siir nima ki bɔ dii Galilee Aanyusakpem ni, le ki ti jon lijool paab, le ki kal kitiŋ. ");
INSERT INTO xon_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Le kinipaak sakpeŋ joo ni biwɔb, ni bijoom, ni bibirb, ni bitaageeb, ni bibum aabɔŋ, ki nan di bil Yesu aanimbiin ni. Le u tii bi mɔmɔk laafee. ");
INSERT INTO xon_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Le ni gar kinipaak ngbaan pam; bi kan bibirb len tibɔr, ni bitaagendam pɔɔk ki chuun, ni biwɔb mu fii chuun, ni bijoom aanimbil likr. Le bi pak Israel yaab Aawumbɔr. ");
INSERT INTO xon_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu nan yin waadidiliib ke bi dan u chee, le ki bui bi, “M san kinipaak ngbaan kinimbaak la; bi bi m chee iwiin itaa, kaa kpa nibaa bi ji. Maa ban m tuk bi ke bi li chaa kun, kaa puen tii bi tijikaar ke bi ji. Nibaakan, bi ga ti fik nsan ponn ni.” ");
INSERT INTO xon_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Le waadidiliib bui u, “Ti bi kipɔɔk ni la. Ti ga kan tijikaar la chee aan ki tii kinipaak ngbaan aan bi ji bab?” ");
INSERT INTO xon_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Le u baa bi, “Ni kpa ŋiboroboro kpin ŋiŋa?” Le bi bui u, “Ti kpa ŋiboroboro kpin ŋilole, ni njanbim siib.” ");
INSERT INTO xon_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Le u bui kinipaak ngbaan, “Kal kitiŋ man,” ");
INSERT INTO xon_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","le ki yoor ŋiboroboro kpin ŋilole ni njanbim ngbaan, le ki doon Uwumbɔr, ki gii gii, ki di tii waadidiliib, le bi yakr siin kinipaak ngbaan mɔmɔk aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Le bi mɔmɔk ŋman ki bab. Baah ŋman ki bab na, le waadidiliib yoor tijikaar ti gur na, ki gbiin tibɔɔkur tilole. ");
INSERT INTO xon_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bijab bi nan jin tijikaar ngbaan na nan ye bijab ŋichur ŋinaa la. Baa nan kahn bipiib ni mbim kpee. ");
INSERT INTO xon_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Le u bui kinipaak ngbaan, “Li chaa kun man,” le ki koo buŋɔb ni, ki buen Magadann aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisii yaab ni Sajusii yaab bibaa nan dan Yesu chee, ki ban bi tɔŋ u, le ki bui u, “Tun lijinjiir aatuln Uwumbɔr aapɔɔn pu, aan ti kan.” ");
INSERT INTO xon_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Le u bui bi, “Paacham yaa maln kijook kan, le ni bui ke utaal aan nu. ");
INSERT INTO xon_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Paacham yaa maln ki bɔln kichakpiik ni kan, le ni bui ke utaal ga nu din. Paacham pu, le ni beer ke utaal ga nu aan waan nu. Le naa bee Uwumbɔr aah ŋani pu dandana na. ");
INSERT INTO xon_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nimi dandana aanib, ni ye titunwanbirdam la, kaa dii Uwumbɔr, nima le ni ban lijinjiir aatuln. Uwumbɔr aah nan ŋa lijinjiir aatuln ki ŋa waabɔnabr Jona pu na, lituln limina aaboln le ni ga kan. Maan mɔk nimi lijinjiir aawan niken kpee.” Waah len kina na, le u siir nima ki cha bi. ");
INSERT INTO xon_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Le u ni waadidiliib puur nnyusakpem. Le waadidiliib suln, kaa joo boroboro. ");
INSERT INTO xon_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Le Yesu bui bi, “Ni li nyi man Farisii yaab ni Sajusii yaab aaboroboro aanyɔk bɔr.” ");
INSERT INTO xon_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Le bi bui tɔb, “Taah kaa joo boroboro na, nima le cha u len kina.” ");
INSERT INTO xon_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Le Yesu bee baah len tɔb chee pu na, le ki baa bi, “Ba pu ni len tɔb chee ke naa joo boroboro? Naa gaa mi ki kii mbamɔm. ");
INSERT INTO xon_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Naa kee bee maabimbin aa? Naa teer maah nan di ŋiboroboro kpin ŋiŋmu kpiin bijab ŋichur ŋiŋmu pu na aa? Ni nan yoor tijikaar ti gur na tibɔɔkur tiŋa? ");
INSERT INTO xon_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naa teer maah nan di ŋiboroboro kpin ŋilole kpiin bijab ŋichur ŋinaa pu na aa? Ni nan yoor tijikaar ti gur na tibɔɔkur tiŋa? ");
INSERT INTO xon_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ba pu naa bee ke maa len boroboro aabɔr? M len ke ni li nyi Farisii yaab ni Sajusii yaab aaboroboro aanyɔk aabɔr la.” ");
INSERT INTO xon_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Waah len kina na, le bi bee ke waa len boroboro aabɔr. U len ke bi li nyi ki taa dii Farisii yaab ni Sajusii yaab aamɔkm la. ");
INSERT INTO xon_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Le Yesu buen Siisarea Filipi aatingbaan ni. Waah bi nima na, le u baa waadidiliib, “Binib bui ke min Unibɔn Aabo ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Le bi bui u, “Bibaa len ke aa ye Jɔnn u nan muini binib nnyun ni na la, le biken mu len ke aa ye Uwumbɔr aabɔnabr Elaija u nan bi n‑yaayoonn na la, le biken mu len ke aa ye Uwumbɔr aabɔnabr Jeremia, bee Uwumbɔr aabɔnabr ubaa la.” ");
INSERT INTO xon_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Le u baa bi ke, “Nimi, ni len ke m ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Le Simonn Piita bui u, “Aa ye Kristo u ga gaa binib lii na. Aa ye Uwumbɔr u fu na Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Le Yesu bui u, “Simonn, Jɔnn aajapɔɔn, Uwumbɔr aanyoor bi aa pu la. Naa ye unibɔn le kpiir kina mɔk si. Nte Uwumbɔr u bi paacham na le kpiir kina mɔk si. ");
INSERT INTO xon_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Piita, m tuk si la, aa ye litakpal la. Litakpal limina pu le m ga di maanib siin. Le nkun aapɔɔn aan nyaŋ bi. ");
INSERT INTO xon_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","M ga tii si mpɔɔn Uwumbɔr aanaan ni. Tiwan ni aa ga buu dulnyaa wee ni na, nima le buu paacham mu. Tiwan ni aa ga buur lii dulnyaa wee ni na, nima le buur lii paacham mu.” ");
INSERT INTO xon_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Le Yesu sur waadidiliib ke bi taa tuk unii ubaa ke u ye Kristo ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","N‑yoonn ngbaan le Yesu piin ki bi kpiir tuk waadidiliib, “See m buen Jerusalem ki ji falaa sakpen. Juu yaab aaninkpiib, ni Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb ga ŋa mi falaa sakpen, le ki ku mi. Iwiin itaadaal le Uwumbɔr ga fikr mi nkun ni.” ");
INSERT INTO xon_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Le Piita di u nyan n‑gbaan, le ki ti sur u ke, “Ndindaan, Uwumbɔr cha ni ŋa libuln ki daa jer. U taa cha ni pii si.” ");
INSERT INTO xon_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Le Yesu fenn lik Piita le ki bui u, “Kinimbɔŋ, siir foor m chee. Aa ye lisugeln la, le ki lek mi nsan. Aa dak ke unibɔn aah dak pu na la, kaa dak ke Uwumbɔr aah dak pu na.” ");
INSERT INTO xon_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu nan bui waadidiliib, “Unii yaa ban u dii mi kan, cha u yii ubaa, ki yoor waadɔpuinkoo aan ki li dii mi. ");
INSERT INTO xon_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Unii umɔk kaan ŋmaa kpo m pu na kan, waamɔfal ga bee yɔli la. Unii umɔk ga ŋmaa kpo m pu na kan, u ga kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unii yaa kan dulnyaa wee ni aawan mɔmɔk ki lann waamɔfal kan, ba aanyoor le u kan? Unii tee ga di ba ki daa waamɔfal? ");
INSERT INTO xon_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Min Unibɔn Aabo ga fuu ni ki ga li kpa Nte Uwumbɔr aapɔɔn. Le Uwumbɔr aatuuntiib ga li dii mi. N‑yoonn ngbaan le m ga tii binib mɔmɔk lipal, baatuln aah ŋeer pu na. ");
INSERT INTO xon_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","M tuk nimi mbamɔn la, binib bi si do na ponn ni bibaa aan kpo see bi puen kan min Unibɔn Aabo jin maanaan waahr.” ");
INSERT INTO xon_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iwiin iloob aah jer na, le u di Piita, ni Jems, ni unaal Jɔnn, ki jon lijool fɔfɔk libaa paab, bibaa. ");
INSERT INTO xon_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Le uwon kpeln binimbil ni. Unimbil wɔb wiin ke nwiin aah wiin pu na. Le waawanpeenkaan kpaln tiwanpipinn ke nwiihn aah piin pu na. ");
INSERT INTO xon_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Le bi kan n‑yaayoonn na aabɔnabtiib Moses ni Elaija bi len u chee tibɔr. ");
INSERT INTO xon_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Le Piita bui u, “Ndindaan, taah bi do na, ni ŋan. Aa yaa gee kan, cha m ŋa ŋiboo ŋitaa, ki di libaa tii si, ki di liken tii Moses, ki di liken tii Elaija.” ");
INSERT INTO xon_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waah beenin bi len kina na, libuul ngbaan ni le ntaalangbapiin dan nan biin bi pu. Le nneel len ntaalangbapiin na ponn ni ke, “Njapɔɔn u m gee u na sɔ. Nnimbil gbiin u. Li ŋun waah len pu na man.” ");
INSERT INTO xon_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Waadidiliib aah ŋun nneel ngbaan pu na, le bi san ijawaan sakpen, le ki lir kitiŋ lichichikr. ");
INSERT INTO xon_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Le Yesu dan nan meeh bi, ki bui bi, “Fii man. Taa san ijawaan man.” ");
INSERT INTO xon_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Le bi waan lik paacham, kaa ki kan ubaa see Yesu baanja. ");
INSERT INTO xon_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Le bi gir sunn ni lijool ngbaan taab. Baah bi sunni na, le Yesu bui bi, “Ni taa tuk ubaa naah kan pu na, ki nan saa buyoonn min Unibɔn Aabo ga fikr nkun ni na.” ");
INSERT INTO xon_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Le bi baa u, “Ba pu Uwumbɔr aakaal aamɔmɔkb len ke Elaija le ga puen dan le Kristo nin fuu ni?” ");
INSERT INTO xon_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Le u bui bi, “Mbamɔn, see Elaija fuu ni, ki nan toor tiwan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","M tuk nimi la, Elaija puun fuu ni a. Le baa nyi u, ki ŋa u baah ban pu na. Baah ŋa u falaa pu na, kina le bi ga ŋa min Unibɔn Aabo mu falaa.” ");
INSERT INTO xon_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu aah len Elaija aabɔr kina na, le waadidiliib bee ke u len Jɔnn u nan muini binib nnyun ni na aabɔr la. ");
INSERT INTO xon_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Le bi fuu kinipaak ngbaan aah bi nin chee na. Baah fuu ni na, le uja ubaa dan nan gbaan unimbiin ni, ");
INSERT INTO xon_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","le ki bui u, “Ndindaan, san maabo kinimbaak. Libimbikl le joo u, ki ŋani u falaa sakpen, ki cha u lir mmii ni, ni nnyun ni kpala kpala. ");
INSERT INTO xon_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","M joo ni u saadidiliib chee, le baa ŋmaa nyan libimbikl na u ni.” ");
INSERT INTO xon_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Le Yesu bui ke, “Nimi dandana aanib, naa gaa Uwumbɔr ki kii, ki mu aa dii u mbamɔm. Ni ban ke m yunn ni chee kinye pu, aan ki li kpa limɔr ni pu, aan ni gaa mi ki kii? Li joo ni ubo ngbaan m chee.” ");
INSERT INTO xon_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Baah joo ni u na, le Yesu kae libimbikl li joo u na. Le li nyan u ni. Libuul ngbaan ni le u pɔɔk, kaa ki bun. ");
INSERT INTO xon_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Le Yesu aadidiliib dan u chee bibaa, le ki nan baa u, “Ba pu taa ŋmaa nyan libimbikl ngbaan u ni?” ");
INSERT INTO xon_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Le u bui bi, “Naa gaa Uwumbɔr ki kii mbamɔm. Nima le naa ŋmaa nyan li. M tuk nimi mbamɔn la, ni yaa gaa Uwumbɔr ki kii siib kina kan, ni ga bui lijool limina ke, ‘Fii nima chee,’ le li ga fii. Nibaa aan li pɔɔ ni chee.  ");
INSERT INTO xon_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Libimbikl limina aaboln ma kan, ni yaa kaa lul bumɔb ki mee Uwumbɔr kan, naan ŋmaa nyan li.” ");
INSERT INTO xon_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Waadidiliib mɔmɔk aah nan bi Galilee aatiŋ ni na, le u bui bi, “Bi ga di min Unibɔn Aabo ŋa binib aaŋaal ni, ");
INSERT INTO xon_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","le bi ku mi. Le iwiin itaadaal Uwumbɔr ga fikr mi nkun ni.” Le biponn bii sakpen. ");
INSERT INTO xon_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ni waadidiliib aah fuu Kapenaum aatiŋ ni na, le binib bi gaal Uwumbɔr Aadichal aamombil na dan nan baa Piita, “Saamɔmɔkr aa pa Uwumbɔr Aadichal aamombil aa?” ");
INSERT INTO xon_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Le u bui bi ke, “U pa la.” Piita aah fuu linampal na, le Yesu puen len u chee ke, “Simonn, dulnyaa wee ni aabɔrb gaal baatiŋ aanib chee lampoo aan bicham chee? Aa dak kinye?” ");
INSERT INTO xon_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Le u bui u, “Bicham chee.” Le Yesu bui u, “Kina kan, baatiŋ aanib aa pa. ");
INSERT INTO xon_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tɔ, taa ban ti koo baataani ni. Li cha nnyusakpem ni ki ti di njapiin lii nnyun ni. Saah ga chuu njan aajan u na, yoor u ki chuu waar umɔb. Aa ga kan limombil umɔb ponn ni. Nyan li ki ti pa tii bi, m ni si pu.” ");
INSERT INTO xon_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","N‑yoonn ngbaan le Yesu aadidiliib dan nan baa u, “Uwumbɔr aanaan ni, ulau tee ye uninyuun?” ");
INSERT INTO xon_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Le u yin ubo ke u dan u chee, ki di u siin bikaasisik ni, ");
INSERT INTO xon_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","le ki bui bi, “M tuk nimi mbamɔn la, ni yaa kaa kpeln ki bi ke bibilb waatiir aah bi pu na kan, naan koo Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Unii umɔk sunn ubaa taab ki bi ke ubo waatiir umina aah bi pu na kan, udaan ngbaan le ye uninyuun Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Unii umɔk gaa ubo umina aaboln maayimbil pu na, u gaa mi le na.” ");
INSERT INTO xon_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Unii yaa tɔŋ mbim bi gaa mi ki kii na ponn ni ubaa ke u tun titunwanbir kan, tibɔbir ga li bi u pu. Bi yaa ba tee di kinaak sakpeŋ ki di tul leen uneen ni, ki tur u lii nnyusakpem ni, nin chee nyoo na kan, ni ba soor ki tii u, ni u tɔŋ ubo ubaa. ");
INSERT INTO xon_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ntɔŋ pu, tibɔbir bi dulnyaa wee ni aanib pu. Tɔ, ntɔŋ ga li bi. Tibɔbir mu bi unii u tɔŋ binib ke bi tun titunwanbir na pu. ");
INSERT INTO xon_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Aa yaa gee tiwan ke saah gee aaŋaal, bee aataal pu na kan, tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Aa yaa lann ŋŋaal mubaa, bee litaal libaa, ki kan limɔfal li kaa kpa ndoon na kan, ni soor ni aa li kpa iŋaal ilee ni ŋitaa ŋilee ki ti li bi mmii mu kaan junn na ni. ");
INSERT INTO xon_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aa yaa gee tiwan ke saah gee aanimbil pu na kan, tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Aa yaa lann linimbil libaa, ki kan limɔfal li kaa kpa ndoon na kan, ni soor ni aa li kpa ŋinimbil ŋilee, ki ti li bi mmii mu kaan junn na ni.” ");
INSERT INTO xon_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Li nyi man ki taa lik bibilb ponn ni ubaa fam. M tuk nimi la, baatuuntiib bi paacham Nte Uwumbɔr aanimbiin ni n‑yoonn mɔmɔk.  ");
INSERT INTO xon_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Min Unibɔn Aabo dan dulnyaa wee ni ke binib bi wɔŋ na ŋmar la. ");
INSERT INTO xon_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Unii yaa kpa ipiih nkub, i ponn ni ubaa yaa wɔŋ kan, ni dak ke u ga ŋa kinye? U ga di cha ipiih imonko inaa ni kipiik ni iwae na ligongoln paab, ki buen ti ban upiih u wɔŋ na la. ");
INSERT INTO xon_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","M tuk nimi mbamɔn la, u yaa ti kan u kan, u ga li mɔɔni upiih ngbaan pu, ki jer waah ga li mɔɔni ipiih imonko inaa ni kipiik ni iwae i kaa wɔŋ na pu na. ");
INSERT INTO xon_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kina le Nite Uwumbɔr u bi paacham na aa ban ke bibilb waatiib ngbaan ponn ni ubaa wɔŋ.” ");
INSERT INTO xon_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aana aabo yaa ŋa si bakaa kan, pɔɔn aabaa ki buen ti kan u n‑gbaan suuna ki tuk u waataani. U yaa ŋun tii si kan, aa giin u ki siin waabuul ni la. ");
INSERT INTO xon_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","U yaa yii, kaa kii tii si kan, pɔɔn aabaa ki ban unii ubaa, bee bilee, ki ki buen u chee ki ti kan u, aan binib bilee, bee bitaa ngbaan ŋun tibɔr ngbaan mɔmɔk ki li ye saaseeraadam. ");
INSERT INTO xon_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","U yaa yii, kaa kii tii bi mu kan, nyan ti mpaan pu ki tuk Uwumbɔr aanib. U yaa yii, kaa kii tii bi mu kan, ni lik u ke ulampoogaar, bee unii u kaa dii Uwumbɔr aasan na. ");
INSERT INTO xon_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“M tuk nimi mbamɔn la, tiwan ni, ni ga buu dulnyaa wee ni na, nima le buu paacham. Tiwan ni, ni ga buur lii dulnyaa wee ni na, nima le buur lii paacham mu. ");
INSERT INTO xon_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Cha m moo tuk nimi man, ni ponn ni bilee yaa kpaan kimɔbaan dulnyaa wee ni, ki mee Nte Uwumbɔr u bi paacham na kan, u ga ŋa naah ban pu na ki tii nimi. ");
INSERT INTO xon_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Binib bilee, bee bitaa, yaa kuun tɔb chee maayimbil pu kan, m ga li bi bikaasisik ni.” ");
INSERT INTO xon_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Le Piita dan nan baa Yesu, “Ndindaan, nna aabo yaa ŋani mi bakaa kan, m ga di cha pinn u nfum muŋa? Nfum mulole ee?” ");
INSERT INTO xon_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Le Yesu bui u, “Maa tuk si ke nfum mulole. Cha pinn u imonko itaa ni kipiik nfum mulole. ");
INSERT INTO xon_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ba pu? Uwumbɔr aanaan naahn ubɔrkpaan u nan ban u bee waatutum aah joo waapɔln pu na la. ");
INSERT INTO xon_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Waah piin ki bi lik kina na, le bi joo ni waatutunn ubaa u joo waapɔln tikunabr aamombil ŋichur ŋichur kipiik. ");
INSERT INTO xon_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Waah kaa kpa ŋimombil ŋibaa ki ga pa lipɔln ngbaan na, le udindaan bui ke bi di u ni upuu, ni waabim, ni waah kpa tiwan ni na mɔmɔk, ki di kooh, aan ki di ŋimombil ngbaan pa lipɔln ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Le ututunn ngbaan gbaan udindaan aanimbiin ni, ki gaŋ u ke, ‘Ndindaan, pɔɔn aabaa ki ji limɔr. M ga pa si maah jin saapɔln li mɔk na.’ ");
INSERT INTO xon_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Le udindaan san u kinimbaak, ki di cha pinn u lipɔln ngbaan, le ki di u lii. ");
INSERT INTO xon_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Le ututunn ngbaan nyan lipaal, ki ti kan waatutuŋeer u joo waapɔln kpakpaln nkub na, le ki chuu u, le ki chuu uneen ni, ki bui u ke, ‘Pa mi saah joo maapɔln li na.’ ");
INSERT INTO xon_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Le waatutuŋeer ngbaan gbaan unimbiin ni, ki gaŋ u ke, ‘Pɔɔn aabaa ki ji limɔr. M ga pa si.’ ");
INSERT INTO xon_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Le waa kii, le ki chuu u ti ŋa kiyondiik ni, u li bi nima ki ti saa buyoonn u ga pa lipɔln ngbaan na. ");
INSERT INTO xon_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waatutuŋeertiib aah kan kina na, le ni bii bisui sakpen. Le bi dan nan tuk bidindaan waah ŋa pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Le bidindaan yin u, ki nan bui u, ‘Aa ye bakadaan la. Saah gaŋ mi na, le m di cha pinn si saapɔln mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aa mu ba ga san saatutuŋeer kinimbaak ke maah san si pu na la.’ ");
INSERT INTO xon_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Udindaan aah gee liŋuul u pu sakpen pu na, le u cha bi ti ŋani u falaa kiyondiik ni, ki ti saa buyoonn u ga pa lipɔln ngbaan mɔmɔk doo na. ");
INSERT INTO xon_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tɔ, unii umɔk kaa di cha pinn una aabo usui ponn ni na kan, Nte Uwumbɔr u bi paacham na mu ga daa utafal kina la.” ");
INSERT INTO xon_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu aah len kina ti doo na, le u nyan Galilee aatiŋ ni, ki buen Judea aatiŋ ki bi Jɔɔdann aamɔɔdapuul na ni. ");
INSERT INTO xon_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Le kinipaak sakpeŋ dii u. Le u cha bi ponn ni bi ye bibum na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Le Farisii yaab bibaa nan dan u chee, ki ban bi tɔŋ u, le ki baa u, “Uja yaa jenn upuu lii waageehn pu kan, timi aakaal kii kina aa?” ");
INSERT INTO xon_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Le Yesu baa bi, “Naa karn Uwumbɔr Aagbaŋ aah len pu na aa? Ni ŋmee ke Uwumbɔr u naan bi na, u nan naan uja ni upii, ");
INSERT INTO xon_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","le ki len ke waah naan uja ni upii na, uja yaa yoor upii kan, bi ga nya cha bitetiib ni binatiib, ki kpaan tɔb chee, ki ŋa unibaan. ");
INSERT INTO xon_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nima pu na, baa ki ye binib bilee, bi ye unibaan la. Uwumbɔr aah kpaan bi na, unibɔn taa yakr bi.” ");
INSERT INTO xon_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Le Farisii yaab ngbaan baa u, “Ni yaa ye kina kan, ba pu Moses nan len ke uja yaa ban u jenn upuu kan, u ŋmee kigbaŋ ponn ni ke u jenn u, ki di tii u, ki nin jenn u?” ");
INSERT INTO xon_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Le Yesu bui bi, “Nitafal aah pɔɔ pu na, nima le cha Moses tii nimi nsan ke ni jenn nipuutiib. N‑yoonn mu Uwumbɔr nan naan tiwan mɔmɔk ki nan saa dandana wee na, waa tii bi nsan kina. ");
INSERT INTO xon_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","M tuk nimi la, upii yaa kaa gɔr kidagook, aan uchal jenn u lii ki ki yoor upii uken kan, uja ngbaan kpaln udagoor la. Upii aachal yaa jenn u lii, uja uken yaa yoor upii ngbaan kan, uja ngbaan kpaln udagoor la.” ");
INSERT INTO xon_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Le Yesu aadidiliib bui u, “Uja ni upuu aabɔr yaa ye kina kan, uja yaa kaa yoor upii kan, ni soor.” ");
INSERT INTO xon_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Le Yesu bui bi, “Bijab mɔmɔk aan ŋmaa gaa naah len pu na ki yii bipiib mɔmɔk. Bijab bi Uwumbɔr tii bi mpɔɔn ke bi yii bipiib na, bima le ga ŋmaa yii bi. ");
INSERT INTO xon_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bibaa bi, baah ma bi na, baa ye bijab. Bibaa mu bi, bi kpaa bi la. Bibaa mu bi, ki yii bipiib mɔmɔk Uwumbɔr aanaan aatuln pu. Uja umɔk ga ŋmaa gaa tibɔr ngbaan ki yii bipiib mɔmɔk na, u gaa ti.” ");
INSERT INTO xon_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Le binib joo ni mbim ki di dan Yesu chee ke u nan di uŋaal paan bi pu, ki mee Uwumbɔr tii bi. Le waadidiliib kae bi. ");
INSERT INTO xon_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Le Yesu bui bi, “Cha mbim ngbaan dan m chee man. Taa ki jenn bi man. Binib bi aabimbin bi ke mbim aah bi pu na, bima le yeh Uwumbɔr aanaan.” ");
INSERT INTO xon_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Le u di uŋaal paan bi pu, le ki siir nima. ");
INSERT INTO xon_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Unachipɔɔn ubaa nan dan Yesu chee le ki nan baa u, “Umɔmɔkr, m ga tun litunyaan bayaar aan ki kan limɔfal li kaa kpa ndoon na?” ");
INSERT INTO xon_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Le Yesu baa u, “Ba pu aa baa mi litunyaan pu? Uwumbɔr baanja le ŋan. Aa yaa ban limɔfal li kaa kpa ndoon na kan, kii waakaal.” ");
INSERT INTO xon_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Le u ki baa u, “Mulakaal?” Le Yesu bui u, “Taa ku binib; taa gɔr kidagook; taa su kinaayuk; taa li ye nnyamɔn aaseeraadaan; ");
INSERT INTO xon_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","li pak aate ni aana; li gee aana aabo ke saah gee aabaa pu na.” ");
INSERT INTO xon_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Le unachipɔɔn ngbaan bui u, “M joo ikaal imina mɔmɔk tibir ni la. Ba gur?” ");
INSERT INTO xon_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Le Yesu bui u, “Aa yaa ban ke aa li bi mbamɔm kan, buen ti kooh saah kpa tiwan nimɔk na, ki di ŋimombil ngbaan di tii bigiim, aan ki li kpa liwangol paacham, aan ki dan nan dii mi.” ");
INSERT INTO xon_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Unachipɔɔn ngbaan aah ŋun kina na, le ni ŋa u mpombiin; ba pu? u nan kpa liwankpal sakpen a. Le u siir nima. ");
INSERT INTO xon_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Le Yesu bui waadidiliib, “M tuk nimi mbamɔn la, ni pɔɔ uwankpadaan koo Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cha m moo tuk nimi man, uwankpadaan aah ga koo Uwumbɔr aanaan ni pu na, ni pɔɔ jer laakumii aah ga koo seerkaa aaboln ni pu na.” ");
INSERT INTO xon_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Waadidiliib aah ŋun kina na, le ni gar bi pam. Le bi baa u, “Ni yaa ye kina kan, ŋma ga tee ŋmar?” ");
INSERT INTO xon_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Le Yesu lik bi le ki bui bi, “Ni pɔɔ binib le chee. Nibaa aa pɔɔ Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Le Piita bui u, “Lik, ti nan di timi aawan mɔmɔk di lii ki dii si. Ti ga kan ba aanyoor?” ");
INSERT INTO xon_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Le Yesu bui bi, “M tuk nimi mbamɔn la, min Unibɔn Aabo ga kal libɔrjal pu, ki kan mpakm sakpen dulnyaapɔɔn ponn ni. N‑yoonn ngbaan, nimi bi dii mi na mu ga kal ŋibɔrjal kipiik ni ŋilee pu, ki ga ji Israel yaab aanibol kipiik ni ŋilee tibɔr. ");
INSERT INTO xon_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Unii umɔk di cha waadichal, bee ukpetiib, bee unaatiib, bee uninkpatiib, bee ute, bee una, bee waabim, bee tisar, maayimbil pu na kan, u ga kan kina nfum nkub, ki ga li kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tɔ, binib bi ye bisalolm na pam ga nan ŋa puwɔb yaab. Binib bi ye puwɔb yaab na pam ga nan ŋa bisalolm.” ");
INSERT INTO xon_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Uwumbɔr aanaan naahn ukpaal u nan pue kichakpinaanyeek ni u ti ban paatiib bi nan tun waasaak ni aatuln na la. ");
INSERT INTO xon_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Waah kan njan yaab bi na, u nan tuk bi, ‘M ga pa nimi tikunabr aamombil libaa nwiin ni mu aalirn.’ Bi nan kii tii waah siin bi pu na. Le u mɔk bi waasaak ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Le ni saa tikur tiwae yoonn, le u ki buen kinyaŋ ni ki ti mui bijab bibaa si nima, kaa kpa lituln libaa. ");
INSERT INTO xon_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Le u bui bi, ‘Buen maasaak ponn ni ki ti tun man. Naah tun pu na, m ga pa nimi kina la.’ ");
INSERT INTO xon_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Le bi buen. Nwiin aah ti saa sisik ni na, le u ki gir buen kinyaŋ ni, le ki ti ki mui bijab bibaa mu si nima. Le u tuk bi mu kina. Nwiin aah ti kpar na, le u ki gir buen kinyaŋ ni, le ki ki ŋa kina. ");
INSERT INTO xon_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nwiin aah ti taln ŋitaa ki ban mu lir na, le u ki gir buen kinyaŋ ni, le ki ti ki mui bijab bibaa mu si nima. Le u baa bi, ‘Ba pu ni si kina nwimɔn, kaa tun nibaa?’ ");
INSERT INTO xon_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Le bi bui u, ‘Taa kan unii u ga tii timi lituln aan ti tun na.’ Le u bui bi, ‘Ni mu li cha maasaak ponn ni, ki ti tun man.’ ");
INSERT INTO xon_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nwiin aah lir kijoobɔŋ na, le ukpaal ngbaan tuk bitutum aaninkpel, ‘Yin ni paatiib ngbaan ki nan pa bi baapal. Piin ki pa bijab bi gbiln puwɔb na, aan ki ti pii bisalolm.’ ");
INSERT INTO xon_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Le bijab bi gbiln puwɔb na aah dan bi nan gaa baapal na, u pan bi tikunabr aamombil libaabaa. ");
INSERT INTO xon_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bisalolm aah dan bi nan gaa baapal na, bi dak ke bi ga kan ki jer puwɔb yaab na, le u pan bi mu tikunabr aamombil libaabaa. ");
INSERT INTO xon_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Baah gaa baapal na, le bi ŋul ukpaal ngbaan pu, ");
INSERT INTO xon_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ki len ke, ‘Bijab bi gbiln puwɔb na tun kikurk kibaa baanja la. Timi le boo ko nwimɔn. Ntoton ŋun timi la. Le ti ni baapal ki ŋak.’ ");
INSERT INTO xon_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Le ukpadaan bui bi ponn ni ubaa, ‘Njɔ, maa jin si pem pem. Aa ba kii ke aa ga gaa tikunabr aamombil libaa la. Naa ye kina aa? ");
INSERT INTO xon_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yoor saamombil ki li chaa kun linampal. M ban m tii puwɔb yaab ke maah tii si pu na la. ");
INSERT INTO xon_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maa kpa nsan ke m di maamombil ŋa maah gee pu na aa? Maah kpa tibulchinn pu na le cha aa kpa lipiipoln aa?’ ");
INSERT INTO xon_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Liyataŋakl limina aatataa le ye ke puwɔb yaab ga nan ŋa bisalolm. Bisalolm mu ga nan ŋa puwɔb yaab.” ");
INSERT INTO xon_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ni waadidiliib ni kinipaak nan cha Jerusalem. Waah cha na le u di waadidiliib kipiik ni bilee na nyan n‑gbaan, le ki bui bi, ");
INSERT INTO xon_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Li pel man, ti yaa ti fuu Jerusalem kan, bi ga di min Unibɔn Aabo ŋa Uwumbɔr aatotoorninkpiib ni Uwumbɔr aakaal aamɔmɔkb aaŋaal ni, le bi ji mi tibɔr, ki ga len ke ni ŋeer bi ku mi, ");
INSERT INTO xon_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","le ki ga di mi ŋa binib bi kaa ye Juu yaab na aaŋaal ni ke bi yook mi, ki lue mi ŋinaalab, ki kpaa mi ndɔpuinkoo pu. Le iwiin itaadaal Uwumbɔr ga fikr mi nkun ni.” ");
INSERT INTO xon_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","N‑yoonn ngbaan le Sebedee aajapɔtiib bilee na, ni bina, nan dan Yesu chee, le bina nan gbaan unimbiin ni, ki doon u, ki mee u ke u ter u. ");
INSERT INTO xon_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Le u baa u, “Aa ban ba?” Le u bui u, “Aa yaa jin saanaan kan, cha njapɔtiib bilee ngbaan li ka aa chee, ubaa li ka aaŋangii wɔb, uken mu li ka aaŋangan wɔb.” ");
INSERT INTO xon_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Le Yesu bui binachipɔm ngbaan, “Naa nyi naah mee mi pu na aatataa. Ni ga ŋmaa ji falaa ke maah ga ji pu na aa?” Le bi bui u, “Ti ga ŋman.” ");
INSERT INTO xon_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Le u bui bi, “Ni mu ga sil ji falaa ke maah ga ji pu na. Binib bi ga kal ŋŋangii ni ŋŋangan wɔb na ma kan, naa ye min le ga lee bi. Nte Uwumbɔr le leer binib bi ga kal nima chee na.” ");
INSERT INTO xon_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Le waadidiliib kipiik bi gur na aah ŋun Sebedee aajapɔtiib aah bui Yesu pu na, bi gee liŋuul bi pu. ");
INSERT INTO xon_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Le Yesu yin bi mɔmɔk ke bi dan u chee, le ki nan bui bi, “Ni nyi ke dulnyaa ni aanib aayidam yoor bibaa paacham la. Binib bi kpa tininkpir na mu joo baanib mpɔɔn pu la. ");
INSERT INTO xon_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nima taa li bi kina man. Ni ponn ni ubaa yaa ban ke u li ye uninyuun kan, u ŋa ubaa ni mɔmɔk aatutunn. ");
INSERT INTO xon_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ubaa yaa ban ke u li ye usaloln kan, u ŋa ubaa ni mɔmɔk aanaagbiija, ");
INSERT INTO xon_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ki li bi ke min Unibɔn Aabo aah bi pu na; maa dan dulnyaa wee ni ke bi nan tun lituln tii mi, m dan ke m nan tun lituln tii binib, ki kpo ke m gaa binib pam lii la.” ");
INSERT INTO xon_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ni waadidiliib nan nyan Jeriko aatiŋ ponn ni. Le kinipaak sakpeŋ dii bi. ");
INSERT INTO xon_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Baah cha na, le bijoom bilee ka nsan aamɔgbeln, le ki ŋun ke Yesu ban u jer. Le bi tar ke, “Tidindaan u ye Ubɔr David Aayaabil na, san timi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Le kinipaak ngbaan kae bi ke bi ŋmin. Le bi moo tar ke, “Tidindaan u ye Ubɔr David Aayaabil na, san timi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Le Yesu sil nsan ni, ki yin bi ke bi dan, le ki nan baa bi, “Ni ban ba?” ");
INSERT INTO xon_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Le bi bui u, “Tidindaan, ti ban ke aa likr tinimbil tii timi la.” ");
INSERT INTO xon_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Le kinimbaak chuu Yesu. Le u meeh binimbil. Libuul ngbaan ni le binimbil likr, le bi dii u. ");
INSERT INTO xon_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bi nan peen Jerusalem, ki fuu Befej aatiŋ, ki bi lijool li bi yin li ke Olif aasui aajool na paab. Baah ti fuu nima chee na, ");
INSERT INTO xon_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","le Yesu bui waadidiliib ponn ni bilee, “Li cha man naah si gbɔk kitiŋ ki na ni. Ni yaa koo ki ponn ni kan, libuul ngbaan ni, ni ga kan ubon si gbin, waabo si u chee. Chuu gbiln ubon ngbaan, ki li joo ni u ni waabo m chee man. ");
INSERT INTO xon_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Unii ubaa yaa len tibaa kan, ni bui u, ‘Tidindaan le ban i,’ le u ga cha ni li joo ni i libuul ngbaan ni.” ");
INSERT INTO xon_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nimina le gbiin Uwumbɔr aabɔnabr aah nan len pu na ke, ");
INSERT INTO xon_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tuk Sionn aatiŋ aanib, Lik, nimi aabɔrkpaan choo ni chee la. U sunn ubaa taab le ki dik ubon pu, u dik ubon u laa diin na pu la.” ");
INSERT INTO xon_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Le Yesu aadidiliib buen ki ti ŋa waah len pu na, ");
INSERT INTO xon_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ki joo ni ubon ngbaan ni waabo, le ki di baakeken paan u pu. Le Yesu diŋ u pu. ");
INSERT INTO xon_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kinipaak ngbaan nan di baakeken ter nsan ponn ni. Bibaa mu bar tisufar ki di ter nsan ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Le binib bi loln u pu nsan na, ni binib bi paa puwɔb na nan bi tar ke, “Hosiana, pakn Ubɔr David Aayaabil man. Uwumbɔr ŋa tinyoor ŋa unii u choo waayimbil ni na pu. Hosiana bi paacham.” ");
INSERT INTO xon_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu aah fuu Jerusalem ni na, le kitiŋ ngbaan aanib mɔmɔk fii ki bi baa tɔb, “Ŋma ye umina?” ");
INSERT INTO xon_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Le kinipaak ngbaan bui bi, “U ye Uwumbɔr aabɔnabr Yesu u nyan ni Nasaref aatiŋ ki bi Galilee aatiŋ ponn ni na la.” ");
INSERT INTO xon_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu nan ti koo Uwumbɔr Aadichal ni, le ki jenn nyan binib bimɔk kooh tiwan ki daa tiwan li ponn ni na, ki labr bilikpelm aateebul mam chiŋ, le ki labr binib bi kooh ŋinanjel na mu aajal ki di chiŋ, ");
INSERT INTO xon_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","le ki bui bi, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr len ke, ‘Bi ga yin Maadichal ke Mmeen Aadichal la;’ nimi le ŋani li bififiirb aakakaa chee.” ");
INSERT INTO xon_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bijoom ni biwɔb nan dan Yesu chee Uwumbɔr Aadichal ni, le u cha bi pɔɔk. Le mbim mu bi Uwumbɔr Aadichal ni na tar ke, “Hosiana, pakn Ubɔr David Aayaabil man.” ");
INSERT INTO xon_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Uwumbɔr aatotoorninkpiib ni Uwumbɔr aakaal aamɔmɔkb aah ŋun kina, ki kan Yesu aah tun lijinjiir aatun pu na, le bi gee liŋuul, ");
INSERT INTO xon_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","le ki baa Yesu ke, “Saa ŋun mbim ngbaan aah len pu na aa?” Le Yesu bui bi ke, “M ŋun. Naa kee karn Uwumbɔr Aagbaŋ ni ii? ke, ‘Mbim ni mbipɔm ga pak Uwumbɔr mbamɔm.’” ");
INSERT INTO xon_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu aah len kina na, le u siir cha bi, le ki nyan Jerusalem, ki buen Betani aatiŋ ni, u ti doon nima. ");
INSERT INTO xon_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Naah ki woln kitaak na, le u gir buen Jerusalem. Waah cha na, le nkon joo u. ");
INSERT INTO xon_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Le u kan likakaln si nsan aamɔgbeln, le ki buen bu taab, kaa kan lisubil libaa bu pu, see tifar ŋmeen. Le u bui busub ngbaan, “Saan ki lu ŋisubil n‑yoonn mu kaa kpa ndoon na.” Libuul ngbaan ni le busub ngbaan mɔmɔk kuur. ");
INSERT INTO xon_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Waadidiliib aah kan kina na, le ni gar bi pam. Le bi baa ke, “Ba pu busub ngbaan kuur mala kina?” ");
INSERT INTO xon_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Le Yesu bui bi, “M tuk nimi mbamɔn la, ni yaa gaa Uwumbɔr ki kii, kaa joo beeni kan, ni mu ga ŋmaa ŋa kina. Naa ye nimina baanja le ni ga ŋa. Ni yaa po bui lijool limina ke li fii ki ti lir nnyusakpem ni kan, ni ga ŋa kina. ");
INSERT INTO xon_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ni yaa mee Uwumbɔr ki yaa pak ke u ga ŋa naah mee u pu na kan, u ga ŋa kina tii nimi.” ");
INSERT INTO xon_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu nan koo Uwumbɔr Aadichal ni, le ki tuk binib Uwumbɔr aabɔr. Waah ŋani kina na, le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib dan u chee ki nan baa u, “Aa kpa nsan ke aa ŋa saah ŋani pu na aa? Ŋma tii si nsan ngbaan?” ");
INSERT INTO xon_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Le u bui bi, “M mu ga baa nimi mbaan. Ni yaa ŋmaa gar kan, m mu ga tuk nimi maah kpa nsan pu ki ŋani maah ŋani pu na. ");
INSERT INTO xon_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔnn aah nan muin binib nnyun ni na, ŋma nan tii u nsan? Uwumbɔr aan binib?” Le bi kpokl tɔb ke, “Ti yaa bui ke Uwumbɔr le tii u nsan kan, u ga baa timi ke ba ŋa taa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ti yaa ki len ke binib le tii u nsan kan, ti san kinipaak ngbaan ijawaan baah ga ŋa timi pu na la; ba pu? bi mɔmɔk len ke Jɔnn nan ye Uwumbɔr aabɔnabr la.” ");
INSERT INTO xon_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nima le bi bui Yesu, “Taa nyi.” Le Yesu bui bi, “M mu aan tuk nimi maah kpa nsan pu ki ŋani maah ŋani pu na.” ");
INSERT INTO xon_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Dakl lik man maah ga tuk nimi pu na aatataa. Uja ubaa nan kpa japɔtiib bilee, le ki dan nan bui u ye upol na, ‘Maabo, buen kisaak ponn ni din ki ti tun.’ Le u bui u, ");
INSERT INTO xon_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Maan buen.’ Naah kpee siib na, le u jer waalandak ki buen kisaak. ");
INSERT INTO xon_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Le uja ngbaan buen uwaatiir mu chee le ki bui u, ‘Maabo, buen kisaak ponn ni din ki ti tun.’ Le u bui u, ‘Maaninkpel, m ga buen,’ ki mu aa buen. ");
INSERT INTO xon_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mbim bilee ngbaan ponn ni, ulau ŋa bite aageehn?” Le bi bui u, “Njan yoo.” Le u bui bi, “M tuk nimi mbamɔn la, bilampoogaab ni bipiidagoob koo Uwumbɔr aanaan ni, ki cha nimi. ");
INSERT INTO xon_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ba pu? Jɔnn nan dan ni chee ki nan tuk nimi nsan mu ŋan na. Le naa gaa u ki kii. Bilampoogaab ni bipiidagoob le gaa u ki kii. Ni nan kan baah gaa u ki kii pu na, le naa kpeln nimi aabimbin, kaa gaa u ki kii.” ");
INSERT INTO xon_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Li pel man liyataŋakl liken. Udichadaan ubaa le nan bi le ki naan kisaak, le ki ŋum isui i lu ŋisubil na ki ponn ni, le ki di idɔ gob kisaak ngbaan, le ki gbii libuul li bi ga di ŋisubil ŋa li ponn ni na aan ki mueni nyani ŋaanyun na, le ki maa libimbifɔfɔŋ ke unii li ka li paab ki kiir kisaak ngbaan, le ki yin bikpaab bibaa, le ki di kisaak ngbaan ŋa biŋaal ni, ke bi li lik ki. Isui ngbaan yaa nan lun ŋisubil kan, bi ker ki tii u, aan ki ker bibaa mu. Waah ŋa kina na, le u siir ki buen kitiŋ ki daa na ni. ");
INSERT INTO xon_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Buyoonn ŋisubil nan puir na, le u di waatutum tun bikpaab ngbaan chee, bi ti gaa ni waasubil kisaak ngbaan ponn ni, ki li joo ni. ");
INSERT INTO xon_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Le bikpaab ngbaan ti chuu waatutum ngbaan, ki gbaa ubaa, ki ku ubaa mu, ki yur ubaa mu ŋitakpal u ti kpo. ");
INSERT INTO xon_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Le usadaan ngbaan ki tun bitutum bi wiir ki jer njan yaab na. Le bikpaab ngbaan ŋa bi mu kina. ");
INSERT INTO xon_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kookoo yaan le u di ujapɔɔn tun ni bi chee, le ki bui ke ‘Bi ga pak uma la.’ ");
INSERT INTO xon_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bikpaab ngbaan aah kan waabo ngbaan na, le bi bui tɔb, ‘Uma le ye waafaajil. Cha ti ku u man aan ki ji waafaal.’ ");
INSERT INTO xon_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Le bi chuu u, ki di nyan n‑gbaan, le ki ti ku u. ");
INSERT INTO xon_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Kina pu na, usadaan yaa nan fuu ni kan, u ga ŋa bikpaab ngbaan kinye?” ");
INSERT INTO xon_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Le bitotoorninkpiib ni Juu yaab ngbaan bui ke, “U ga sil ku titunwanbirdam ngbaan, ki di kisaak ngbaan tii bikpaab bi ga li bilni u waasubil ŋibin mɔmɔk na.” ");
INSERT INTO xon_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Le Yesu baa bi, “Naah kee karn Uwumbɔr Aagbaŋ aah len pu na aa? ke, ‘Litakpal li bidimaab yii li na, lima le ye litakpajal. Uwumbɔr le ŋa kina, le ni gar timi pam.’ ");
INSERT INTO xon_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“M tuk nimi la, Uwumbɔr ga nyan ni chee waanaan, ki di tii linibol li ga dii waah ban pu na.  ");
INSERT INTO xon_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Unii u lir litakpal ngbaan pu na, u ga kool. Unii u litakpal ngbaan lir u pu na, li ga nan u ke ntayon na.” ");
INSERT INTO xon_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Uwumbɔr aatotoorninkpiib ni Farisii yaab aah ŋun kina na, le bi bee ke Yesu di liyataŋakl ngbaan ŋaŋ bima la. ");
INSERT INTO xon_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Le bi ban ke bi chuu u, ki mu san kinipaak ngbaan ijawaan; ba pu? kinipaak ngbaan len ke Yesu ye Uwumbɔr aabɔnabr la. ");
INSERT INTO xon_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Le Yesu ki ŋakl bi liyataŋakl ke, ");
INSERT INTO xon_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Uwumbɔr aanaan naahn ubɔrkpaan u ŋa ubɔndinn aajikaar ki tii ujapɔɔn, ");
INSERT INTO xon_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ki tun waatutum ke bi yin binib bi u ban ke bi dan nan ji na. Baah yin bi na, le bi yii, kaa dan. ");
INSERT INTO xon_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Le u ki tun bitutum biken ke bi ti yin bi ki tuk bi, ‘Ubɔrkpaan len ke u gor tijikaar mɔmɔk doo a. U kɔr inaaja ni tiwakor ti filk na, ki gor tiwan mɔmɔk doo a,’ ke bi dan. ");
INSERT INTO xon_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Le baa gar waatutum. Bi nan beenin tun baatuln; ubaa nan buen kisaak, uken mu buen u ti tiir kitiir. ");
INSERT INTO xon_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bi gur na chuu bitutum ngbaan, ki gbaa bi ki ku bi. ");
INSERT INTO xon_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Le ubɔrkpaan ngbaan gee liŋuul sakpen, le ki tun waajab le bi ti ku binikurb ngbaan, le ki see baatiŋ mmii. ");
INSERT INTO xon_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Le u bui waatutum, ‘Ubɔndinn aajikaar gor a. Binib bi m yin bi na aa ŋeer bi ji tijikaar ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Li cha kitiŋ ponn ni aasan ni man, ki ti yin ni naah ga kan binib bimɔk na, bi dan ki nan ji ubɔndinn aajikaar ngbaan.’ ");
INSERT INTO xon_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Le waatutum buen kitiŋ ponn ni aasan ni, ki ti yin ni baah kan bi na mɔmɔk, binib bi ŋan na ni bi kaa ŋan na mɔmɔk. Le bi nan gbiin kidiik ki bi ji tijikaar ki ponn ni na. ");
INSERT INTO xon_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Le ubɔrkpaan ngbaan koo ni u nan lik binib bi dan bi nan ji tijikaar ngbaan na, le ki kan uja u kaa pee tibɔndinn aawanpeenkaan na. ");
INSERT INTO xon_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Le ubɔrkpaan ngbaan baa u, ‘Njɔ, aa ŋa kinye ki koo ni do, kaa pee tibɔndinn aawanpeenkaan?’ Le u si ŋmin. ");
INSERT INTO xon_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Le ubɔrkpaan ngbaan bui waatutum ke bi chuu u, ki buu uŋaal ni utaa, ki nyan u, ki ti di mee lii lipaal mbɔmbɔɔn ni. U ga wii ki ŋmɔ ŋinyin nima chee. ");
INSERT INTO xon_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Liyataŋakl ngbaan aatataa le ye ke baah yin bi na wiir, le baa nyan bi na aa wiir.” ");
INSERT INTO xon_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Le Farisii yaab buen bi ti kpokl baah ga peei Yesu nlan pu aan ki chuu u na. ");
INSERT INTO xon_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Le bi tun baadidiliib ni Ubɔr Herod aanib bibaa Yesu chee, le bi ti bui u, “Umɔmɔkr, ti bee ke aa len mbamɔn la, ki mɔk timi Uwumbɔr aasan mbamɔm, kaa san unii ubaa ijawaan, kaa pak ubaa ki jer uken. ");
INSERT INTO xon_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tuk timi saah dak pu na. Ni ŋan ti pa lampoo ki tii Ubɔrkpaan Siisa aan naa ŋan?” ");
INSERT INTO xon_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Le Yesu bee baah bir pu na, le ki baa bi, “Nimi biŋmaŋmannim, ba ŋa ni tɔŋ mi? ");
INSERT INTO xon_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mɔk mi lampoo aamombil.” Le bi joo ni limombil nan mɔk u. ");
INSERT INTO xon_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Le u baa bi, “Ŋma aanaŋ ni liyimbil bi li pu?” ");
INSERT INTO xon_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Le bi bui u, “Siisa yaan.” Le u bui bi, “Nima pu na, di ni ye Siisa yaan na, ki di tii u man, ki di ni ye Uwumbɔr yaan na, ki di tii Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Baah ŋun kina na, le ni gar bi pam. Le bi di cha u ki buen. ");
INSERT INTO xon_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Liyaadaal ngbaan le Sajusii yaab dan u chee. Bima le len ke binib aan fikr nkun ni. ");
INSERT INTO xon_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Le bi bui u, “Umɔmɔkr, Moses nan len ke uja yaa kpo, kaa kpa mbim kan, unaal di ukpopii ngbaan kpan, ki maa mbim tii ukpel. ");
INSERT INTO xon_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naabitiib bilole nan bi ti ponn ni. Le upol din upii, ki kpo, kaa kpa ubo. Le unaal di ukpopii ngbaan kpan, ");
INSERT INTO xon_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ki mu kpo, kaa kpa ubo. Le u paa u pu na mu ŋa kina. Le bimɔk bilole kpan upiibaan, ki kpo doo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kookoo yoo, le ukpopii ngbaan mu kpo. ");
INSERT INTO xon_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kina pu na, binib yaa nan fikr nkun ni kan, upii ngbaan ga li ye ŋma aapuu? Bi mɔmɔk bilole nan joo u la.” ");
INSERT INTO xon_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Le Yesu bui bi, “Naa bee Uwumbɔr Aagbaŋ aah len pu na, kaa bee Uwumbɔr aah kpa mpɔɔn pu na. Nima le cha ni yenn nimi aaliin ni. ");
INSERT INTO xon_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Binib yaa nan fikr nkun ni kan, baan yoor bipiib, bipiib mu aan mɔn bijab. Bi ga li bi ke Uwumbɔr aatuuntiib bi bi paacham na aah bi pu na la. ");
INSERT INTO xon_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Joo cha binib aah ga fikr nkun ni pu na aabɔr kan, naa karn Uwumbɔr aah nan len pu na aa? ");
INSERT INTO xon_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ke uma le ye Abraham, ni Aisak, ni Jakob Aawumbɔr. Uwumbɔr yaa len ke u ye binib bi kpo na Aawumbɔr kan, nima le mɔk ke bi kpa limɔfal.” ");
INSERT INTO xon_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kinipaak ngbaan aah ŋun Yesu aah tuk bi pu na, le ni gar bi pam. ");
INSERT INTO xon_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Le Farisii yaab ŋun ke Yesu len tibɔr ki jin Sajusii yaab. Le bi kuun ki dan Yesu chee. ");
INSERT INTO xon_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Le bi ponn ni ubaa, u nyi Uwumbɔr aakaal mbamɔm na, ban ke u pen Yesu nlan, le ki baa u, ");
INSERT INTO xon_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Umɔmɔkr, Uwumbɔr aakaal ponn ni, mulakaal jer ikaal mɔmɔk?” ");
INSERT INTO xon_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Le Yesu bui u, “‘Aa li gee Aadindaan Uwumbɔr aasui mɔmɔk ni, ni saawiin mɔmɔk, ni saalandak mɔmɔk.’ ");
INSERT INTO xon_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nkaal mumina le ye nkaalkpaan ki jer ikaal mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Leler aakaal naahn nkaal ngbaan la, ‘Aa li gee aana aabo ke saah gee aabaa pu na.’ ");
INSERT INTO xon_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses aakaal mɔmɔk, ni Uwumbɔr aabɔnabr aabɔr mɔmɔk si ikaal ilee yee le pu.” ");
INSERT INTO xon_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisii yaab aah kuun tɔb chee pu na, le Yesu baa bi mbaan mubaa ke, ");
INSERT INTO xon_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kristo u ga gaa binib lii na aabɔr pu, ni dak kinye? Ŋma aayaabil ye u?” Le bi bui u, “David aayaabil ye.” ");
INSERT INTO xon_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Le u baa bi, “Kristo ngbaan yaa ye David aayaabil kan, ba pu Uwumbɔr Aafuur Nyaan nan cha David yin u ke Udindaan? David nan len ke, ");
INSERT INTO xon_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Uwumbɔr bui Ndindaan ke: Kal ŋŋangii wɔb, ki ti saa buyoonn m ga nyaŋ saadim mɔmɔk na.’ ");
INSERT INTO xon_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tɔ, David aah nan yin Kristo ngbaan ke Udindaan kina na, Kristo ga li ŋmaa ye uyaabil aa?” ");
INSERT INTO xon_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu aah baa bi kina na, le ubaa aa ŋmaa gar mbaan ngbaan, ki mu aa ki kaa bi baa u mbaan muken daalbaadaal. ");
INSERT INTO xon_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu nan bui kinipaak ngbaan ni waadidiliib, ");
INSERT INTO xon_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab tuk nimi Moses aakaal aatataa. ");
INSERT INTO xon_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nima pu na, baah tuk nimi pu na mɔmɔk, ni kii kina man, ki li ŋani kina. Ni mu taa ŋakni baah tun pu na. ");
INSERT INTO xon_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bi mɔk nimi ni ŋan na la, kaa dii ni. Bi di nkaal mu pɔɔ sakpen na, le ki di kpee Uwumbɔr aakaal pu, ki tuk binib ke bi li dii kina. Bima bibaa aa ter bi ke bi dii kina. ");
INSERT INTO xon_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Baah tun pu na mɔmɔk, bi ban ke binib kan aan ki pak bi. Bi di Uwumbɔr aabɔr tam biyigbeer pu, ki ŋa baabɔkur aamɔgbeln ni fɔk, ke binib kan aan ki pak bi. ");
INSERT INTO xon_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bi gee ke bi kal bininyuum aakakaa yaan njim chee, ni mmeen aadir ni, ");
INSERT INTO xon_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ki gee ke binib doon bi mbamɔm kinyaŋ ni, ki yin bi ke ‘Umɔmɔkr.’ ");
INSERT INTO xon_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nimi, ni taa li ban ke binib yin nimi ke ‘Umɔmɔkr;’ ba pu? ni kpa Umɔmɔkr ubaa baanja la. Ni mɔmɔk ye naabitiib la. ");
INSERT INTO xon_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni taa yin ubaa ke ‘Nite’ dulnyaa wee ni; ba pu? ni kpa te ubaa la, le u bi paacham. ");
INSERT INTO xon_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni taa li ban ke ubaa yin nimi ke Dindaan; ba pu? ni kpa dindaan ubaa la. Uma le ye Kristo u gaa binib lii na. ");
INSERT INTO xon_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni ponn ni ubaa yaa ban ke u li ye usaloln kan, u li ye nimi aatutunn. ");
INSERT INTO xon_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Unii umɔk nyuŋ ubaa na, Uwumbɔr ga sunn u taab. Unii umɔk sunn ubaa taab na, Uwumbɔr ga nyuŋ u.” ");
INSERT INTO xon_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu; ni kiir binib ke bi taa koo Uwumbɔr aanaan ni. Nimi nibaa aa koo ni, ki mu aa kii ke binib bi ban bi koo ni na koo ni.  ");
INSERT INTO xon_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu; ni ji bikpopiib pem pem, le ki mee Uwumbɔr ni yunni, ni ŋmanni ke ni ye bininyaam. Nima pu na, Uwumbɔr ga daa nitafal ki jer waah ga daa biken aatafal pu na. ");
INSERT INTO xon_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu; ni puur nnyusakpem ki chuun ntim mɔmɔk ni ke ni kan unii ubaa ki ŋa u nimi aadidiir. Ni yaa ti kan u kan, le ni ŋa u titunwanbirdaan ki jer nimi nibaa aah ye pu na. ");
INSERT INTO xon_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nimi bisanmɔkb bi jɔb na, tibɔbir bi ni pu; ni len ke ‘Unii yaa puu Uwumbɔr aadiik pu kan, naa ye nibaa, ke u yaa puu ilik i bi ki ni na pu kan, see u gbiin tipuur ngbaan.’ ");
INSERT INTO xon_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nimi bijɔrb bi jɔb na, nilani jer niken, ilik ngbaan le aan Uwumbɔr aadiik ki ŋa ilik ngbaan chain na? ");
INSERT INTO xon_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni ki len ke ‘Unii yaa puu Uwumbɔr aatork aabimbiln pu kan, naa ye nibaa, ke u yaa puu ipiin i bi li paab na pu kan, see u gbiin tipuur ngbaan.’ ");
INSERT INTO xon_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nimi bijoom, nilani jer niken, ipiin ngbaan le aan Uwumbɔr aatork aabimbiln li ŋa ipiin ngbaan chain na? ");
INSERT INTO xon_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nima pu na, unii yaa puu Uwumbɔr aatork aabimbiln pu kan, u puu tiwan nimɔk bi li pu na mu la. ");
INSERT INTO xon_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Unii yaa puu Uwumbɔr aadiik pu kan, u puu Uwumbɔr u bi ki ni na mu la. ");
INSERT INTO xon_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Unii yaa puu paacham pu kan, u puu Uwumbɔr aabɔrjal, ni Uwumbɔr u ka li pu na mu la. ");
INSERT INTO xon_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, tibɔbir bi ni pu; ni yakr tikpifar nfum kipiik ki nyan nibaa na ki di tii Uwumbɔr, ki muk nibaa ke ni joo Uwumbɔr aakaal mumina, ki yii nkaal mu ye nkaalkpaan na. Ni yii, kaa ŋani ni ŋan na, kaa san binib kinimbaak, kaa dii Uwumbɔr mbamɔm. Ni ŋan ke ni li joo nkaal ngbaan, ki yakr nimi aawan mu ki di tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ni ye bisanmɔkb bi jɔb na la. Kisibirk waatiir yaa bi tiwanyukaan ni kan, ni yak nyani ki. Laakumii ma yaa bi kan, ni kpaan nyu laakumii ni tiwanyukaan mɔk la. ");
INSERT INTO xon_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu; ni ŋir tiyir ni ŋisambil aapuwɔb mbamɔm, kaa ŋir ni ponn ni. Kina le ni ban ke binib bui ke ni ye bininyaam. Le nisui ponn ni gbii kinaayuk aatuln, ni iniman aatuln. ");
INSERT INTO xon_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nimi Farisii yaab bi jɔb na, puen nyan kinaayuk aatuln, ni iniman nisui ni waahr, aan lipaal yaan li ŋan. ");
INSERT INTO xon_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu. Ni naahn ŋikaakul ŋi bi di ikukuun aayon ki piir ŋi na la, le lipaal ŋan, ponn ni mu gbii inikpab, ni tiwan ni bur na, ni tijɔŋ mɔk aabɔŋ. ");
INSERT INTO xon_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ni mu bi kina la. Ni ŋmanni ke ni ye bininyaam la, le ni ponn ni gbii inyamɔn, ni titunwanbir.” ");
INSERT INTO xon_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nimi Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, bi ye biŋmaŋmannim na, tibɔbir bi ni pu; ni maa ŋikaakul ki tii Uwumbɔr aabɔnabtiib bi nan bi n‑yaayoonn na, ki di ikukuun aayon ki piir bininyaam aakaakul, ");
INSERT INTO xon_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","le ki len ke ni yaa ba nan bi niyaajatiib yoonn ngbaan kan, naa ba ga ŋa baah nan ŋa pu ki ku Uwumbɔr aabɔnabtiib ngbaan na. ");
INSERT INTO xon_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naah len pu na le mɔk ke ni ye binib bi nan ku Uwumbɔr aabɔnabtiib ngbaan na aayaabitiib la. Nima le nimi aabɔr bii. ");
INSERT INTO xon_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Niyaajatiib aah nan tun titunwanbir ti na, ni mu ga tun tima la, le ki ti doo. ");
INSERT INTO xon_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nimi iwaa, bi ye ijagen aabim na, ni ga ŋa kinye ki nya ntafadaan mu ga pii nimi, mmii mu kaan junn na ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nima pu le m ga tun ni Uwumbɔr aabɔnabtiib ni bilankpalb ni bimɔmɔkb ni chee. Le ni ga ku bibaa, ki kpaa bibaa mu idɔpuinkee pu, ki gbaa bibaa mu ŋinaalab nimi aameen aadir ni, ki ŋa bi falaa ntim mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","N‑yoonn mɔmɔk binib nan ku bininyaam la. Njan bi nan ku Abel u nan ye uninyaan na, le ki ku bininyaam ki joo cha, ki ti pii Barakia aabo Sakaria, u bi nan ku u Uwumbɔr aadiik ni na. Bininyaam ngbaan mɔmɔk aakun pu, le ntafadaan ga pii nimi. ");
INSERT INTO xon_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","M tuk nimi mbamɔn la, ntafadaan ngbaan ga pii nimi dandana aanib la.” ");
INSERT INTO xon_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem aanib, nsui bii ni pu la. Ni ku Uwumbɔr aabɔnabtiib, ki yur waatutum ŋitakpal ki ku bi. N‑yoonn mɔmɔk le m nan ban m kuun nimi ki di kpaan mbaa chee ke ukɔla aah kuuni waakoobi pu ki ŋani ufeen ni na, le naa kii. ");
INSERT INTO xon_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lik, Uwumbɔr siir cha nimi. ");
INSERT INTO xon_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","M tuk nimi la, naan ki kan mi ki nan saa bundaln ni ga bui ke ‘Uwumbɔr ŋa tinyoor ŋa unii u choo waayimbil ni na pu.’” ");
INSERT INTO xon_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nan nyan Uwumbɔr Aadichal ni. Waah nyan ki cha na, le waadidiliib dan ki nan mɔk u, “Lik Uwumbɔr Aadichal aah wiir pu na.” ");
INSERT INTO xon_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Le u bui bi, “Ni kan tiwan nimina mɔmɔk aa? M tuk nimi la, bi ga nan gbaa wii lidichal limina mɔmɔk. Litakpal libaa aan ki li paa liken pu.” ");
INSERT INTO xon_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Le u buen ti kal Olif aasui aajool paab. Le waadidiliib dan u chee bibaa, ki nan bui u, “Tuk timi, bi ga ŋa kina bayoonn? Ba ga li ye limɔkl ki mɔk timi ke ni ŋeer aa fuu ni, ki ŋeer dulnyaa aadoon?” ");
INSERT INTO xon_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Le u bui bi, “Ni li nyi man, ubaa taa ŋmann nimi. ");
INSERT INTO xon_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Binib pam ga nan dan ki nan pur maayimbil ke bima le ye Kristo u ga gaa binib lii na, ki ŋmann binib pam. ");
INSERT INTO xon_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ni ga ŋun ke binib to butɔb kɔnkɔni do, ni dandar mu. Ni taa cha ni li muk nimi man. Uwumbɔr le siin ke nimina mɔmɔk ga ŋa. Nima le aan mɔk ke dulnyaa wee ga doo libuul ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Linibol libaa ga to linibol liken butɔb. Nnaan mubaa aanib ni nnaan muken aanib ga to tɔb butɔb. Nkon ga lir ntim pam ponn ni. Kitiŋ ga deŋ ŋipepel pam. ");
INSERT INTO xon_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nimina mɔmɔk le ga li ye njan aafalaa. ");
INSERT INTO xon_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“N‑yoonn ngbaan bi ga chuu nimi, ki ŋa nimi falaa, ki ga ku nimi. M pu, le ŋinibol mɔmɔk ga li nan nimi. ");
INSERT INTO xon_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","N‑yoonn ngbaan le binib pam ga di maasan lii, ki ga kooh tɔb, ki ga li nan tɔb. ");
INSERT INTO xon_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Le binib bi ŋmanni ke bi ye Uwumbɔr aabɔnabtiib na ga li wiir ki ŋmanni binib pam. ");
INSERT INTO xon_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Le titunwanbir ga li wiir. Nima le binib pam aan ki li gee mi ke baah nan gee mi njan pu na. ");
INSERT INTO xon_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Unii umɔk ji limɔr ki dii mi ki ti saa limɔfal aadoon na, uma le ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bi ga moon Uwumbɔr aanaan aabɔnyaan tee itingbaan kookoo ni waahr, aan ŋinibol mɔmɔk ŋun, le dulnyaa ga nin doo.” ");
INSERT INTO xon_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ni ga kan tiwanbir ni bii tiwan nimɔk bi chain na si Uwumbɔr Aadichal ni, ke Uwumbɔr aabɔnabr Daniel aah nan len pu na.” Tɔ, nimi bi karni na, ni li beer nimina aatataa. ");
INSERT INTO xon_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“N‑yoonn ngbaan yaa nan fuu ni kan, binib bi bi Judea aatiŋ ponn ni na, bi san buen ŋijoo paab. ");
INSERT INTO xon_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Unii yaa bi kidiik paab kan, u taa ki koo waadiik ni u ti yoor waawan, u san mala. ");
INSERT INTO xon_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Unii yaa bi kisaak kan, u taa gir kun linampal ke u ti yoor waakekeln. ");
INSERT INTO xon_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","N‑yoonn ngbaan, bipiib bi kpa ŋipuu na, ni bipiib bi kpa mbim bi laa ŋaa libiil na ga li kpa kinimbaak. ");
INSERT INTO xon_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mee Uwumbɔr man, aan u taa cha ni san kakab aayoonn, bee likpaakool daal. ");
INSERT INTO xon_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","N‑yoonn ngbaan binib ga ji falaa pam. Buyoonn Uwumbɔr nan naan dulnyaa wee ki nan saa dandana wee na, baa kee jin falaa ngbaan aaboln, ki mu aan ki ji falaa kina. ");
INSERT INTO xon_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Uwumbɔr yaa kaa bar falaa ngbaan aayoonn aawiin kan, ubaa aan ŋmar. Le waanib aanimbaasaln pu u ga bar falaa ngbaan aayoonn aawiin. ");
INSERT INTO xon_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“N‑yoonn ngbaan, unii yaa bui nimi ke ‘Lik, Kristo u gaa binib li na sɔ,’ ki yaa ki bui ke ‘U bi nima chee’ kan, ni taa gaa waah len pu na man. ");
INSERT INTO xon_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ba pu? biŋmaŋmannim ga li bi. Bibaa ga bui ke bi ye Kristo ngbaan la. Biken mu ga bui ke bi ye Uwumbɔr aabɔnabtiib la. Le bi ga tun lijinjiir aatun pam, ki ŋmann binib. Hali, bi ga pɔɔn bibaa ke bi ti ŋmann binib bi Uwumbɔr nyan bi na. ");
INSERT INTO xon_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Li pel man, m puen tuk nimi la. ");
INSERT INTO xon_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nima pu na, bi yaa tuk nimi ke Kristo ngbaan bi nteersakpiin ni kan, taa buen ti lik man. Bi yaa ti ki tuk nimi ke u bi kidiik ni kan, taa gaa man. ");
INSERT INTO xon_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Min Unibɔn Aabo yaa gir ni kan, ni ga li bi ke utaal aah moor liwipuul ki cha liwilir pu na, unii mɔmɔk ga kan. ");
INSERT INTO xon_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Liwankpol aah bi nin chee na, nangba mam mu kuuni nima chee la.” ");
INSERT INTO xon_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“N‑yoonn ngbaan aafalaa aapuwɔb, le paacham aawan aan ki li bi mbamɔm. Nwiin ga bɔln. Uŋmal mu aan ki li wiin. Iŋmabi mu ga lir. ");
INSERT INTO xon_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","N‑yoonn ngbaan le binib ga kan limɔkl li ga li bi paacham ki mɔk bi ke min Unibɔn Aabo choo na. N‑yoonn ngbaan le ŋinibol ŋimɔk bi dulnyaa wee ni na ga wii. Bi ga kan min Unibɔn Aabo bi ntaalangbam ni ki choo, ki wiin chain, ki joo mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Le kakaan ga wii mpɔɔn pu. Le m ga tun ni maatuuntiib ke bi buen liwipuul, ni liwilir, ni ŋŋangan, ni ŋŋangii, ki ti kuun ni maanib mɔmɔk, ki di dan m chee.” ");
INSERT INTO xon_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Bukpasɔm le ye liyataŋakl ki tii nimi. Bu aabon yaa bi ŋani tifar kan, ni bee ke ni yaa kpee siib kan, kiseek ga seer. ");
INSERT INTO xon_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kina na, ni yaa kan nimina mɔmɔk bi ŋani kan, ni bee ke ni yaa kpee siib kan, m ga gir ni. ");
INSERT INTO xon_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","M tuk nimi mbamɔn la, dandana aanib aan jer le tiwan nimina mɔmɔk puen ŋa. ");
INSERT INTO xon_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Paacham ni taab ga jer. Maamɔbon ma aan jer.” ");
INSERT INTO xon_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ubaa aa nyi buyoonn m ga gir ni na. Uwumbɔr aatuuntiib bi bi paacham na aa nyi. Min Uwumbɔr Aajapɔɔn mu aa nyi. Nte Uwumbɔr baanja le nyi. ");
INSERT INTO xon_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Min Unibɔn Aabo aah ga nan gir ni buyoonn na, ga li bi ke naah nan bi Nowa aayoonn pu na la. ");
INSERT INTO xon_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa aayoonn ngbaan, buyoonn nnyusakpem aa nan kee jin kitiŋ na, binib nan bi, ki ji, ki nyu, bijab yoor bipiib, bipiib mu mɔn bijab, ki ti saa bundaln Nowa nan koo buŋɔb ni na. ");
INSERT INTO xon_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Baa nan nyi ke nibaa ga ŋa bi, ki ti saa buyoonn nnyusakpem nan jin kitiŋ mɔmɔk na. Le bi mɔmɔk nan bee nnyun ni. Buyoonn min Unibɔn Aabo ga nan gir ni na, ni ga li bi kina la. ");
INSERT INTO xon_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","N‑yoonn ngbaan bijab bilee ga li boo kisaak ko. M ga nan yoor ubaa ki di buen, ki cha uken. ");
INSERT INTO xon_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bipiib bilee ga li boo nan idi. M ga nan yoor ubaa ki di buen, ki cha uken. ");
INSERT INTO xon_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ni li nyi man. Naa nyi bundaln min Nidindaan ga gir ni na. ");
INSERT INTO xon_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ni li nyi ke udichadaan yaa ba nyi buyoonn unaayuk ga fuu ni na kan, waa ba ga doon geen. U ba ga li ka lik, unaayuk ngbaan taa koo waadichal ni. ");
INSERT INTO xon_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nima pu na, ni mu li gor man; ba pu? buyoonn naan li dak ke m ga gir ni na, n‑yoonn ngbaan le m ga gir ni.” ");
INSERT INTO xon_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Uyidaan ubaa yaa tii waatutunn ubaa tininkpir ke u li lik waachiln ni aanib ki tii bi tijikaar naah ŋeer buyoonn na kan, ututunn ngbaan ga ŋa kinye ki li kpa nlan, ki li tun waatuln mbamɔm? ");
INSERT INTO xon_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Udindaan yaa nan fuu ni ki mui waatutunn ŋani uma udindaan aah ban pu na kan, Uwumbɔr aanyoor ga li bi ututunn ngbaan pu. ");
INSERT INTO xon_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","M tuk nimi mbamɔn la, u ga tii u tininkpir u li lik waawan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tɔ, ututunn yaa ye titunwanbirdaan kan, u ga dakl usui ni ke udindaan ga yunn, ");
INSERT INTO xon_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ki ga piin ki gbaa ututuŋeen aatɔtiib, ki ga dii bidagbiib, ki ji, ki nyu ndaan ki gbii. ");
INSERT INTO xon_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Le udindaan ga gir ni buyoonn waan li dak ke u ga gir ni na, ");
INSERT INTO xon_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ki ga gbaa u ŋinaalab mbamɔm, ki ga di u ŋa biŋmaŋmannim aah bi nin chee na. U ga wii ki ŋmɔ ŋinyin nima chee.” ");
INSERT INTO xon_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Uwumbɔr aanaan naahn bisapɔm kipiik bi nan joo baakaryaa mam, bi ti tooh upiidinn nsan ponn ni na la. ");
INSERT INTO xon_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bi ponn ni biŋmu nan ye bijɔrb, biŋmu mu nan ye bilankpalb. ");
INSERT INTO xon_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bijɔrb na nan joo baakaryaa mam, kaa joo nkpan. ");
INSERT INTO xon_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Bilankpalb na joo baakaryaa mam, ki joo nkpan mu. ");
INSERT INTO xon_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Le upiidinn ngbaan yunn. Le bi mɔmɔk dɔ geen. ");
INSERT INTO xon_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kinyetaasiik le bi ŋun bi teen mpɔɔn pu ke, ‘Upiidinn choo. Nya ki tooh u nsan ni man.’ ");
INSERT INTO xon_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Le bisapɔm kipiik ngbaan mɔmɔk fii ke bi toor baakaryaa mam. ");
INSERT INTO xon_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Le bijɔrb biŋmu na bui bilankpalb biŋmu na, ‘Tii timi nkpan man. Timi aakaryaa mam ban bi junn la.’ ");
INSERT INTO xon_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Le bilankpalb ngbaan bui bi, ‘Nibaakan, timi aakpan ngbaan aan ŋeer ti ni nimi. Li cha man binib bi kooh nkpan na chee ki ti daa ŋa man.’ ");
INSERT INTO xon_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Baah buen bi ti daa na, le upiidinn fuu ni. Le bilankpalb biŋmu bi gor na dii upiidinn ngbaan, ki koo waadiik ni, bi ti ji upiidinn aajikaar. Le bi laŋ kidiik ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Le bijɔrb ngbaan mu nan fuu ni, le ki bui ke, ‘Tidindaan, Tidindaan, chuu piir tii timi.’ ");
INSERT INTO xon_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Le u bui bi, ‘M tuk nimi mbamɔn la, maa nyi nimi.’” ");
INSERT INTO xon_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tɔ, Yesu aah ŋakl bi liyataŋakl ngbaan doo na, le u bui ke, “Nima pu na, ni li nyi man. Naa nyi bundaln m ga gir ni na.” ");
INSERT INTO xon_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Uwumbɔr aanaan naahn uja u nan cha nsan, ki yin waatutum ki nan di waawan mɔmɔk ŋa biŋaal ni na la. ");
INSERT INTO xon_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U nan di salmaa aakur aamombil ŋichur ŋiŋmu ki di tii ubaa, ki di ŋichur ŋilee ki di tii uken, ki di lichur libaa ki di tii uken mu. U nan tii bi mɔmɔk baah ga ŋmaa tun pu na, le ki nyan buen. ");
INSERT INTO xon_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ututunn u nan joo ŋichur ŋiŋmu na, libuul ngbaan ni le u tiir kitiir, ki kan tinyoor ŋichur ŋiŋmu ki di kpee. ");
INSERT INTO xon_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ututunn u joo ŋichur ŋilee na mu tiir kitiir ki kan tinyoor ŋichur ŋilee ki kpee. ");
INSERT INTO xon_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ututunn u nan joo lichur libaa na ma nan buen ti gbii libuul, le ki di udindaan aamombil sub nima. ");
INSERT INTO xon_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ni joo cha ki ti yunn, le bitutum ngbaan aadindaan fuu ni, ki ban u lik bimɔk aah tun pu na. ");
INSERT INTO xon_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Le ututunn u nan gaa salmaa aakur aamombil ŋichur ŋiŋmu na nan joo ŋi, ni ŋichur ŋiŋmu ki kpee, ki nan bui u, ‘Ndindaan, aa nan tii mi ŋichur ŋiŋmu la. M mu tiir kitiir ki kan tinyoor ŋichur ŋiŋmu kpee.’ ");
INSERT INTO xon_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Le udindaan bui u, ‘Nfaan, aa ye ututunn la, ki tun lituln mbamɔm. Maah nan tii si tiwan ni siib na, aa joo ni mbamɔm. M ga ŋa si tiwan sakpenn aaninkpel. Ji maamɔɔn.’ ");
INSERT INTO xon_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Le ututunn u nan joo ŋichur ŋilee na mu yoor ŋi, le ki nan bui u, ‘Ndindaan, aa nan tii mi ŋichur ŋilee la. M tiir kitiir ki kan tinyoor ŋichur ŋilee ki kpee.’ ");
INSERT INTO xon_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Le udindaan bui u, ‘Nfaan, aa ye ututunn la, ki tun lituln mbamɔm. Maah nan tii si tiwan ni siib na, aa joo ni mbamɔm. M ga ŋa si tiwan sakpenn aaninkpel. Ji maamɔɔn.’ ");
INSERT INTO xon_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Le ututunn u nan joo lichur libaa na yoor li, ki nan bui u, ‘Ndindaan, m nyi aabɔr, ke aa chur binib mpɔɔn la. Saah kaa bun ni na, aa chee nima la. Saah kaa poo tijikaar ti na, aa faa tima la. ");
INSERT INTO xon_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nima le m san ijawaan, ki gbii libuul, ki di saamombil sub. Lik, saamombil sɔ.’ ");
INSERT INTO xon_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Le udindaan bui u, ‘Utunwanbirdaan umina, ugbanyakdaan umina, aa bui ke aa nyi mbɔr ke maah kaa bun ni na, m chee nima la, maah kaa poo ti na, m faa tima la. ");
INSERT INTO xon_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Saah nyi kina na, ba ŋa saa di maamombil ti bil banki ponn ni? Maah fuu ni na, m ba ga kan maamombil ni tinyoor ki kpee,’ le ki bui biken, ");
INSERT INTO xon_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Chuu gaa lichur libaa li u kpa na man, ki di kpee ututunn u joo ŋichur kipiik na. ");
INSERT INTO xon_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Unii umɔk kpa na, bi ga kpee u, le u li kpa sakpen. Unii u kaa kpa na, bi ga chuu gaa waah kpa ni pɔkaa na. ");
INSERT INTO xon_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chuu ututunn u kaa kpa tinyoor ngbaan na, ki nyan u ki ti di u lii lipaal, mbɔmbɔɔn ni. U ga wii ki ŋmɔ ŋinyin nima chee.’” ");
INSERT INTO xon_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Min Unibɔn Aabo ni maatuuntiib ga fuu ni. Le m ga li kpa mpɔɔn sakpen ki kal maabɔrjal pu ke ubɔrkpaan na. ");
INSERT INTO xon_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Le bi ga kuun ni dulnyaa wee ni aanib mɔmɔk nnimbiin ni. Le m ga yakr bi ke upihkpaal aah yakr ipiih ni iŋoob pu na, ");
INSERT INTO xon_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ki ga di bininyaam siin ŋŋangii wɔb, ki di tiniwanbir siin ŋŋangan wɔb. ");
INSERT INTO xon_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Le min, u ye Ubɔrkpaan ngbaan na, ga bui binib bi si ŋŋangii wɔb na, ‘Nimi bi Nte Uwumbɔr ŋa tinyoor ŋa ni pu na, dan nan ji nnaan mu u nan toor siin nimi, buyoonn u nan naan dulnyaa wee na. ");
INSERT INTO xon_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ba pu? nkon nan joo mi, le ni nan tii mi tijikaar m ji. Nnyunyuu nan joo mi, ni nan tii mi nnyun m nyun. M nan ye uchaan la, le ni nan gaa mi. ");
INSERT INTO xon_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","M nan chuun ŋŋmeen la, le ni nan tii mi tiwanpeenkaan m peen. M nan bun la, le ni dan nan mann mi. M nan bi kiyondiik ni, le ni dan nan lik mi.’ ");
INSERT INTO xon_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Le bininyaam ngbaan ga baa mi, ‘Tidindaan, bayoonn ti nan kan si nkon joo si, ti tii si, aa jin? Bayoonn ti nan kan si, nnyunyuu joo si, ti tii si, aa nyun? ");
INSERT INTO xon_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bayoonn ti nan kan si, aa ye uchaan, ti gaa si? Bayoonn ti nan kan si, aa chuun aaŋmeen, ti peen si? ");
INSERT INTO xon_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bayoonn ti nan kan si, aa bun, ti dan nan mann si? Bayoonn ti nan kan si, aa bi kiyondiik ni, ti dan nan lik si?’ ");
INSERT INTO xon_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Le min Ubɔrkpaan ngbaan ga bui bi, ‘M tuk nimi mbamɔn la, naah nan ŋa kina ki tii nnaabitiib, biwaatiib bimina na, ni nan ŋa tii mi le na.’ ");
INSERT INTO xon_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Le m ga bui binib bi si ŋŋangan wɔb na, ‘Nimi bi Uwumbɔr puun lii ni pu na, nya m chee man, ki ti koo mmii mu kaan junn, aan Uwumbɔr nan tuur siin kinimbɔŋ ni kaawanbir mɔmɔk na. ");
INSERT INTO xon_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ba pu? nkon nan joo mi, naa nan tii mi tijikaar m ji. Nnyunyuu nan joo mi, naa nan tii mi nnyun, m nyun. ");
INSERT INTO xon_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","M nan ye uchaan, naa nan gaa mi. M nan chuun ŋŋmeen, naa nan peen mi. M nan bun, naa nan dan nan mann mi. M nan bi kiyondiik ni, naa nan dan nan lik mi.’ ");
INSERT INTO xon_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Le bi mu ga baa mi, ‘Tidindaan, bayoonn ti nan kan si, nkon joo si, bee nnyunyuu joo si, bee aa ye uchaan, bee aa chuun aaŋmeen, bee aa ye ubun, bee aa bi kiyondiik ni, kaa ter si?’ ");
INSERT INTO xon_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Le m ga bui bi, ‘M tuk nimi mbamɔn la, naah kaa nan ter nnaabitiib, biwaatiib bimina na, naa nan ter mi le na.’ ");
INSERT INTO xon_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Le bi ga kan ntafadaan n‑yoonn mu kaa kpa ndoon na. Le bininyaam ngbaan ga kan limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu aah len kina ki ti doo na, le u bui waadidiliib, ");
INSERT INTO xon_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ni nyi ke ni gur iwiin ilee le bi ga ji Lakr‑jer aajim. N‑yoonn ngbaan le bi ga di min Unibɔn Aabo ŋa binib aaŋaal ni, le bi ti kpaa mi ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tɔ, n‑yoonn ngbaan le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib nan kuun Uwumbɔr aatotoorninkpel Kayafas aachiln ni, ");
INSERT INTO xon_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","le ki kpokl ke bi ga loon chuu Yesu ki ku u, ");
INSERT INTO xon_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","le ki bui tɔb, “Ti taa chuu u njim ngbaan aayoonn man. Ti yaa chuu u n‑yoonn ngbaan kan, kinipaak ngbaan ga ŋma tijar.” ");
INSERT INTO xon_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tɔ, Yesu nan bi Betani aatiŋ ni, ki bi Simonn u nan ye ukɔndaan na do, ki bi ji tijikaar. ");
INSERT INTO xon_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Waah bi ji tijikaar kina na, le upii ubaa joo ni tulalee u kpa kidaak sakpen na ki nan di kpir Yesu aayil paab. Tulalee ngbaan nan bi kpalba nyaan u bi yin u ke alabasta na ponn ni la. ");
INSERT INTO xon_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Waadidiliib aah kan kina na, le bi gee liŋuul, ki len ke, “Ba ŋa u bii tulalee ngbaan kina? ");
INSERT INTO xon_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ti ba ga ŋmaa di u kooh ki kan ilik sakpen ki di tii bigiim.” ");
INSERT INTO xon_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu nan bee baah len pu na, le ki baa bi, “Ba ŋa ni muk upii ngbaan kina? U tun lituln li ŋan na le ki tii mi. ");
INSERT INTO xon_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bigiim ga li bi ni chee n‑yoonn mɔmɔk. Mma aan li bi ni chee n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Waah di tulalee ngbaan kpir nwon pu na, u toor mi ke bi ti sub mi la. ");
INSERT INTO xon_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","M tuk nimi mbamɔn la, baah ga moon tibɔnyaan tee nin chee itingbaan mɔmɔk ni na, bi ga len waah ŋa pu na ke binib li teer waabɔr.” ");
INSERT INTO xon_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Le Yesu aadidiliib kipiik ni bilee ponn ni ubaa, bi yin u ke Judas Iskariot, buen Uwumbɔr aatotoorninkpiib chee, ");
INSERT INTO xon_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","le ki ti baa bi, “M yaa di Yesu ŋa niŋaal ni kan, ni ga tii mi ba?” Le bi kahn tikur aamombil piitaa ki di tii u. ");
INSERT INTO xon_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Liyaadaal ngbaan le u piin ki bi ban nsan mu u ga di Yesu ŋa biŋaal ni na. ");
INSERT INTO xon_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lakr‑jer aajim, buyoonn bi ga ŋmɔ boroboro u kaa kpa nnyɔk na aajan aawiindaal, le Yesu aadidiliib dan nan baa u, “Aa ban ke ti gor njim ngbaan aajikaar la chee ki tii si?” ");
INSERT INTO xon_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Le u bui bi, “Ni li cha kitiŋ ngbaan ni, uja ubaa chee man, ki ti bui u, ‘Umɔmɔkr bui ke waayoonn fuu a. U ni waadidiliib ga dan nan ji Lakr‑jer aajim aado.’” ");
INSERT INTO xon_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Le Yesu aadidiliib ŋa waah tuk bi pu na, le ki gor njim ngbaan aajikaar. ");
INSERT INTO xon_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kijook aah joor na, le Yesu ni waadidiliib kipiik ni bilee nan kal ke bi ji tijikaar ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Baah bi ji na, le u bui bi, “M tuk nimi mbamɔn la, ni ponn ni ubaa ga kooh mi.” ");
INSERT INTO xon_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Waah len kina na, le bisui bii sakpen. Le bi mɔmɔk baa u ubaabaa ubaabaa, “Ndindaan, ni ye min la aa?” ");
INSERT INTO xon_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Le u bui bi, “M ni unii u kpaani ji lisambil libaa ni na le ga kooh mi. ");
INSERT INTO xon_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Min Unibɔn Aabo ga kpo ke naah ŋmee Uwumbɔr Aagbaŋ ponn ni ke m ga kpo pu na. Uja u ga kooh mi na ma kan, tibɔbir ga li bi u pu; bi yaa kaa ba ma u kan, ni ba soor ki tii u.” ");
INSERT INTO xon_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Le Judas, u ga kooh u na, baa u, “Umɔmɔkr, ni ye min la aa?” Le Yesu bui u, “Ni ye saah len pu na.” ");
INSERT INTO xon_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Baah bi ji tijikaar na, le Yesu yoor boroboro, le ki doon Uwumbɔr, ki gii, ki di tii waadidiliib, ki bui bi, “Gaa ki li ŋmɔ man. Nwon le na.” ");
INSERT INTO xon_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","U nan yoor kiyinyook mu, le ki doon Uwumbɔr, ki di tii bi, le ki bui bi, “Ni mɔmɔk nyu man. ");
INSERT INTO xon_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Maasin le na. Maasin pu, le Uwumbɔr puu tipuupɔln ki tii nimi. Maasin ga nya binib pam aatunwanbir pu, aan Uwumbɔr di cha pinn bi. ");
INSERT INTO xon_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","M tuk nimi la, maan ki nyu ŋisubil aanyun ngbaan, ki ti saa bundaln m ni nimi ga kpaan nyu mu nsanpɔɔn ni, Nte Uwumbɔr aanaan ni na.” ");
INSERT INTO xon_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Le bi gaa Uwumbɔr aalahn, ki buen Olif aasui aajool paab. ");
INSERT INTO xon_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu nan bui bi, “Kinyeek kee, ni mɔmɔk ga san ki cha mi. Ni ŋmee Uwumbɔr Aagbaŋ ni ke ‘Uwumbɔr ga ku upihdaan, le ipiih yaa.’ ");
INSERT INTO xon_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Buyoonn Uwumbɔr ga fikr mi nkun ni na, le m ga loln ni pu nsan ki buen Galilee aatiŋ ni.” ");
INSERT INTO xon_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Le Piita bui u, “Bi mɔmɔk yaa san ki cha si kan, mma aan san cha si.” ");
INSERT INTO xon_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Le Yesu bui u, “M tuk si mbamɔn la, kinyeek kimina, aa ga len nfum mutaa ke saa nyi mi le ukooja nin wii.” ");
INSERT INTO xon_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Le Piita bui u, “Bi yaa po ban bi ku m ni si kan, maan len ke maa nyi si.” Le waadidiliib mɔmɔk mu len kina. ");
INSERT INTO xon_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","U ni waadidiliib nan ti fuu nibaa chee, le bi yin nima chee ke Getsemane. Le u bui bi, “Kal do man, aan m buen nibaa chee ki ti mee Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Le u di Piita ni Sebedee aajapɔtiib bilee na buen. Le usui bii sakpen ki ti nyaŋ. ");
INSERT INTO xon_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Le u bui bi, “Nsui bii ki ti nyaŋ. Ni wu ke nkun aah wu pu na. Kaln do man, ki li lik man.” ");
INSERT INTO xon_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Le u foor siib, ki doon lichichikr, le ki mee Uwumbɔr, “Nte, aa yaa kii kina kan, nyan mi falaa u choo na ni. Tɔ, ŋa saageehn, ki taa ŋa maageehn.” ");
INSERT INTO xon_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Le u gir buen waadidiliib bitaa ngbaan chee, ki ti mui bi dɔ geen; le u baa Piita, “Naa ŋmaa li ka lik kikurk kibaa aa? ");
INSERT INTO xon_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ni li ka lik man, aan ki li mee Uwumbɔr, aan ki taa koo ntɔŋ ni. Nisui ban ke ni li lik, le tiwon aa pɔɔ.” ");
INSERT INTO xon_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Le u ki foor siib, ki ki mee Uwumbɔr, le ki bui ke, “Nte, ni yaa kaa ye m nyan falaa u choo na ni kan, cha saageehn ŋa.” ");
INSERT INTO xon_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Le u ki gir buen waadidiliib chee, ki ti mui bi ki dɔ geen; ngeen nan joo bi sakpen a. ");
INSERT INTO xon_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Le u siir cha bi, le ki ki foor siib, ki ki mee Uwumbɔr taataa, ki ki bui u tibɔr tichachaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Le u ki gir buen waadidiliib chee, ki ti baa bi, “Ni beenin fuur, ki dɔ geen la aa? Lik man, n‑yoonn fuu a. U kooh min Unibɔn Aabo ki di ŋa titunwanbirdam aaŋaal ni la. ");
INSERT INTO xon_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fii, ti li cha man. Lik, uja u kooh mi na peeni a.” ");
INSERT INTO xon_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Waah laa bi len kina na, le Judas u ye waadidiliib kipiik ni bilee ponn ni ubaa na fuu ni. Le kinipaak dii u. Bi nan joo kijaak aajum ni jagbaali mam. Bi nan nyan ni Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib chee la. ");
INSERT INTO xon_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas u kooh Yesu na nan bui kinipaak ngbaan ke bi yaa ti kan u moor unii u aatakpiln na kan, uma le na, bi chuu u. ");
INSERT INTO xon_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Baah fuu ni Yesu ni waadidiliib aah bi nin chee na, le Judas kpaan buen Yesu chee, le ki ti bui u, “Umɔmɔkr, aa pɔɔ ɔɔ?” le ki moor utakpiln. ");
INSERT INTO xon_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Le Yesu bui u, “Njɔ, aa chuun kinye?” Le bi dan nan chuu Yesu mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Le Yesu aadidiliib ponn ni ubaa yoor waajaak aajuk ki gaa per Uwumbɔr aatotoorninkpel aanaagbiija aatafal. ");
INSERT INTO xon_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Le Yesu bui u, “Di saajuk ngbaan ki di fu kijuchook ni. Binib bimɔk yoor kijaak aajuk na, kijaak aajuk le ga ku bi. ");
INSERT INTO xon_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Saa nyi ke m yaa mee Nte Uwumbɔr kan, u ga tun ni bituuntiib bi jer ŋichur kipiik ni ŋilee na m chee dandana aa? ");
INSERT INTO xon_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","M mu yaa ŋa kina kan, maan gbiin Uwumbɔr Aagbaŋ aah len pu na ke m ga ji falaa u choo na.” ");
INSERT INTO xon_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","N‑yoonn ngbaan le u baa kinipaak ngbaan, “Ni joo kijaak aajum, ni ŋichakukul ni nan chuu mi ke maah ye ufifiir le na aa? M nan bi Uwumbɔr Aadichal ni iwiin mɔmɔk, ki tuk binib Uwumbɔr aabɔr, le naa chuu mi. ");
INSERT INTO xon_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tɔ, nimina mɔmɔk ŋa ke ni gbiin Uwumbɔr aabɔnabtiib aah nan ŋmee pu na.” Le waadidiliib mɔmɔk san cha u. ");
INSERT INTO xon_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Binib bi nan chuu Yesu na nan di u buen Uwumbɔr aatotoorninkpel Kayafas aadichal ni, Uwumbɔr aakaal aamɔmɔkb ni Juu yaab aaninkpiib aah kuun nin chee na. ");
INSERT INTO xon_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Le Piita paa Yesu pu, ki bi dandar, le ki ti fuu Uwumbɔr aatotoorninkpel aachiln ni, le ki koo ni, ki ti kal butɔb aajab chee ke u lik naah ga ti doo pu na. ");
INSERT INTO xon_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Le Uwumbɔr aatotoorninkpiib ni bibɔjirb aaninkpiib mɔmɔk ban binib bi ga mɔln inyamɔn ki paan Yesu na, aan bi kan waataani ki ti ku u na. Le biseeraadam pam dan nan mɔln inyamɔn paan u. ");
INSERT INTO xon_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bi mu aa kan waataani. Kookoo yaan le binyamɔndam bilee dan nan bui bi ");
INSERT INTO xon_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ke uja ngbaan bui ke u ga ŋmaa gbaa wii Uwumbɔr Aadichal, ki ki maa ki iwiin itaa daal. ");
INSERT INTO xon_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Le Uwumbɔr aatotoorninkpel fii sil, ki baa Yesu, “Saan len tibaa aa? Binib ngbaan aah bii si pu na, ti gbii aan taa gbii?” ");
INSERT INTO xon_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Le Yesu si ŋmin. Le Uwumbɔr aatotoorninkpel bui u, “Puu Uwumbɔr u fu na pu, aa ye Uwumbɔr Aajapɔɔn Kristo u Uwumbɔr lee u na aan saa ye?” ");
INSERT INTO xon_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Le Yesu bui u, “Ni ye saah len pu na. M tuk nimi la, n‑yoonn mu choo na, ni ga kan min Unibɔn Aabo ka Uwumbɔr aaŋangii wɔb, ki ga kan mi ntaalangbam ni paacham ki choo.” ");
INSERT INTO xon_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Waah len kina na, le Uwumbɔr aatotoorninkpel chuu kar ubaa aawanpeenkaan, le ki bui ke, “U di ubaa ŋaŋ Uwumbɔr la. Taa ki ban seeraadam. Ni ŋun waah sii Uwumbɔr pu na. ");
INSERT INTO xon_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ni dak kinye?” Le bi bui ke, “U ŋeer ti ku u la.” ");
INSERT INTO xon_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Le bi teei timɔɔtan ŋa unimbil wɔb, le ki gbaa u. Bibaa mu gbaa u ntapam, ");
INSERT INTO xon_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ki bui u, “Kristo ngbaan, lem Uwumbɔr aabɔnabr aaliin ki tuk timi, ulau faa si.” ");
INSERT INTO xon_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piita nan ka lichiln ni. Le usapɔɔn u ye ututunn na dan nan bui u, “Aa mu nan bi Yesu u ye Galilee aatiŋ aanii na chee.” ");
INSERT INTO xon_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Le u nee bi mɔmɔk aanimbil ni ki bui u, “Maa nyi saah len pu na aatataa,” le ki buen kikaakpaak ni. ");
INSERT INTO xon_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Le usapɔɔn uken mu ti kan u, le ki bui binib bi bi nima chee na, “Uja wee mu nan bi Yesu u ye Nasaref aatiŋ aanii na chee.” ");
INSERT INTO xon_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Le u ki nee ki puu Uwumbɔr ke waa nyi u. ");
INSERT INTO xon_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Le ni kpee siib, le binib bi si nima chee na dan nan bui u, “Ni ye mbamɔn, aa ye waadidiliib ponn ni ubaa la; saaliin ni baaliin kpaan la.” ");
INSERT INTO xon_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Le u ki puu Uwumbɔr, le ki bui ke, “Maa nyi uja ngbaan. M yaa mɔn nnyamɔn kan, Uwumbɔr daa ntafal.” Libuul ngbaan ni le ukooja wii. ");
INSERT INTO xon_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Le Piita teer Yesu aah ba tuk u pu na ke, “Aa ga len nfum mutaa ke saa nyi mi, le ukooja nin wii.” Piita nan nyan lipaal, ki ti wii sakpen. ");
INSERT INTO xon_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ki woln kitaak le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib mɔmɔk kpokl baah ga ŋa pu ki ku Yesu na. ");
INSERT INTO xon_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Le bi buu u tikululn, ki di u buen kitiŋ ngbaan aaninkpel chee, bi yin u ke Pailat, ki ti di ŋa uŋaal ni. ");
INSERT INTO xon_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tɔ, Judas u kooh Yesu na aah kan ke bi ga ku Yesu na, le u jer waalandak, le ki ki giin ni tikur aamombil piitaa ngbaan ke u ti di tii Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib, ");
INSERT INTO xon_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","le ki bui bi, “M tun titunwanbir la. M kooh unii u kaa kpa taani na ke bi ti ku u.” Le bi bui u, “Naa ye timi aabɔr. Ni ye saabɔr la.” ");
INSERT INTO xon_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Le u di ŋimombil ngbaan di lii Uwumbɔr Aadichal ni, ki siir cha bi, le ki buen ti leen ubaa ŋŋmin le ki kpo. ");
INSERT INTO xon_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Le Uwumbɔr aatotoorninkpiib pii ŋimombil ngbaan ki bui ke, “Ni ye nsin aamombil la. Timi aakaal aa kii ke ti di kina aamombil ŋa Uwumbɔr aamombil ni.” ");
INSERT INTO xon_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Le bi kpokl baah ga ŋa ŋi pu na, le ki di ŋi daa Kiyakmaabuuk aapepel ke bi ti li sui bicham nima. ");
INSERT INTO xon_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nima pu, le bi yin nima chee ke “Nsin aatiŋ” ki nan saa dandana wee. ");
INSERT INTO xon_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Le ni gbiin Uwumbɔr aabɔnabr Jeremia aah nan len pu na ke, “Bi di tikur aamombil piitaa le daa kiyakmaabuuk aapepel, Uwumbɔr aah tuk bi pu na. Ŋimombil ngbaan ye unii aadaak, Israel yaab ngem aah len ke bi ga daa u pu na.” ");
INSERT INTO xon_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bi nan di Yesu ti siin kitiŋ ngbaan aaninkpel Pailat aanimbiin ni. Le Pailat baa u, “Aa ye Juu yaab aabɔr la aa?” Le u bui u, “Saah len pu na, ni ye kina.” ");
INSERT INTO xon_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib bii Yesu. Le waa len tibaa. ");
INSERT INTO xon_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Le Pailat baa u, “Saa ŋun baah bii si sakpen pu na aa?” ");
INSERT INTO xon_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Le Yesu si ŋmin, kaa len tibaa. Le ni gar Pailat pam. ");
INSERT INTO xon_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Njim ngbaan aayoonn yaa nan saa kan, Pailat ga nyan unaagbiija u kinipaak ban u na ki lii. ");
INSERT INTO xon_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","N‑yoonn ngbaan unaagbiija u kpa liyimbil na nan bi kiyondiik ni. Bi nan yin u ke Barabas. ");
INSERT INTO xon_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kinipaak aah kuun na, le Pailat baa bi, “Ni ban m nyan ŋma kiyondiik ni? Barabas le aan Yesu u bi yin u ke Kristo ngbaan na?” ");
INSERT INTO xon_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat nan bee ke bi kpa lipiipoln Yesu pu, nima le cha bi di u ŋa uŋaal ni. ");
INSERT INTO xon_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Buyoonn u bi ji Yesu tibɔr na, Pailat aapuu nan di unii tun ni, ke u li nyi ki taa ŋa uja nyaan ngbaan nibaa; ke uja ngbaan pu, u daŋ tidaŋ ti muk u sakpen na kinyeek na. ");
INSERT INTO xon_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib bui kinipaak ngbaan ke bi tuk Pailat ke u di Barabas lii, ki ku Yesu. ");
INSERT INTO xon_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tɔ, le Pailat ki baa bi, “Bijab bilee ngbaan ponn ni, m ga di ulau lii?” Le bi bui u, “Di Barabas lii.” ");
INSERT INTO xon_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Le Pailat baa bi, “Yesu u bi yin u ke Kristo ngbaan na, m ga ŋa u kinye?” Le bi mɔmɔk bui u, “Kpaa u ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Le u ki baa bi, “Ba ŋa? U tun bakaa bayoo?” Le bi moo tar mpɔɔn pu ke, “Kpaa u ndɔpuinkoo pu,” le ki ban bi ŋma tijar. ");
INSERT INTO xon_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat mu kan ke waan ŋmaa ŋa nibaa, le ki ban nnyun, ki ŋir uŋaal binimbil ni, ki len ke, “Uja nyaan ngbaan aasin aa bi ŋŋaal ni. Ni ye nimi aabɔr la.” ");
INSERT INTO xon_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Le bi mɔmɔk bui u, “Cha waasin li bi timi, ni timi aabim aaŋaal ni.” ");
INSERT INTO xon_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Le Pailat nyan Barabas lii, ki cha waajab lue Yesu ŋinaalab, le ki di u ŋa biŋaal ni, bi ti kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Butɔb aajab ngbaan nan di Yesu koo Pailat aadichal ni, le ki kuun ni bijab bi gur na ki nan gob u. ");
INSERT INTO xon_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Le bi chuu peer waawanpeenkaan, ki di libɔkumaln peen u, ");
INSERT INTO xon_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","le ki di ikokon luu kiyikpupuk, ki di chiŋ u, ki di lidabil ŋum uŋangii ni ke ubɔr na, le ki gbaan unimbiin ni, ki ŋa u mbɔnyun, ki bui u, “Juu yaab Aabɔr, aa pɔɔ ɔɔ?” ");
INSERT INTO xon_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","le ki teei timɔɔtan lɔe u, le ki gaa lidabil ngbaan ki di faa uyil paab. ");
INSERT INTO xon_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Baah ŋa u mbɔɔnyun ki ti doo na, le bi chuu peer libɔkumaln ngbaan, le ki di waawanpeenkaan peen u, le ki joo u cha, bi ti kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Baah cha na, le bi kan uja ubaa, u ye Sairene aatiŋ aanii, aan bi yin u ke Simonn na. Le bi chuu u mpɔɔn ke u tun Yesu aadɔpuinkoo. ");
INSERT INTO xon_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Le bi ti fuu nibaa chee. Bi yin nima chee ke Golgota. Golgota aatataa le ye ke “Kiyikpaŋ aapepel.” Baah fuu nima chee na, ");
INSERT INTO xon_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","le binib bibaa di ndaan ni nnyɔk ki di ŋmal tɔb ponn ni, ki di tii Yesu ke u nyun. Waah lak lik na, le u yii, kaa nyun. ");
INSERT INTO xon_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Le butɔb aajab ngbaan kpaa u ndɔpuinkoo pu, ki di waawanpeenkaan ti yakr tɔb, le ki too inaan ke bi lik bimɔk aah ga kan ni na, ");
INSERT INTO xon_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","le ki ka lik u. ");
INSERT INTO xon_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bi nan ŋmee kigbaŋ budabu cha bi ku u na, ki di tam waadɔpuinkoo pu, uyil paab. Kigbaŋ ngbaan len ke, “Yesu u ye Juu yaab Aabɔr na le na.” ");
INSERT INTO xon_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Le bi di bififiirb bilee mu kpaa idɔpuinkee pu. Bi nan di ubaa kpaa uŋangii wɔb, ki di uken kpaa uŋangan wɔb. ");
INSERT INTO xon_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Le binib bi jer nima chee na sii u, ki gbakr biyil, ");
INSERT INTO xon_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","le ki bui u, “Si u len ke aa ga gbaa wii Uwumbɔr Aadichal ki ki maa li iwiin itaa na, aa yaa ye Uwumbɔr Aajapɔɔn kan, sunn ni ndɔpuinkoo pu, ki ŋmar.” ");
INSERT INTO xon_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni Juu yaab aaninkpiib mu ŋa u mbɔɔnyun, ki bui ke, ");
INSERT INTO xon_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“U nan gaal biken lir, kaan ŋmaa gaa ubaa lii ki ŋmar. U yaa ye Juu yaab Aabɔr kan, u sunn ni ndɔpuinkoo pu, aan ti gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U gaa Uwumbɔr ki kii, ki bui ke u ye Uwumbɔr Aajapɔɔn. Uwumbɔr yaa ban u kan, cha u gaa u lii dandana.” ");
INSERT INTO xon_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Le bififiirb bi bi di kpaa u chee idɔpuinkee pu na mu sii u kina. ");
INSERT INTO xon_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nwiin kaasisik ni le itingbaan mɔmɔk bɔln, ki ti saa nwiin aah kpar pu na. ");
INSERT INTO xon_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nwiin aah kpar na, le Yesu teen mpɔɔn pu, “Eli, Eli, lama sabaktani.” Naatataa le ye ke, “Maawumbɔr, Maawumbɔr, ba pu aa siir cha mi?” ");
INSERT INTO xon_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Binib bi si nima chee na aah ŋun waah teen pu na, le bibaa bui ke, “Uja ngbaan yin Elaija la.” ");
INSERT INTO xon_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Libuul ngbaan ni le bi ponn ni ubaa san buen ki ti yoor nkiisuk, ki nan di bɔn ndaan mu mɔɔn na ni, le ki di ŋa lidabil pu ki di ŋa umɔb chee ke u moor. ");
INSERT INTO xon_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Le binib bi gur na bui ke, “Di cha. Cha ti lik ke Elaija ga dan nan gaa u lii aan waan dan.” ");
INSERT INTO xon_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Le Yesu ki teen mpɔɔn pu, le ki cha waawiin nyan, le ki kpo. ");
INSERT INTO xon_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","N‑yoonn ngbaan, le likekeln li yakr Uwumbɔr aadiik ni nfum mulee na chuu kar paacham ki ti saa kitiŋ. Le kitiŋ deŋ, le ŋitakpasakpiin chuu war. ");
INSERT INTO xon_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ŋikaakul ngem mu chuu piir, le Uwumbɔr aanib bi nan kpo na pam fikr nkun ni, ki nyan ŋikaakul ngbaan ponn ni. ");
INSERT INTO xon_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Buyoonn Yesu fikr nkun ni na, le bi koo Jerusalem aatiŋ ni, ki di bibaa mɔk binib pam. ");
INSERT INTO xon_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Butɔb aajab aaninkpel, ni binib bi bi u chee ki si kii Yesu na aah kan kitiŋ aah deŋ pu na, ki kan tiwan nimɔk ŋa na, le ijawaan chuu bi sakpen. Le bi bui ke, “Mbamɔn, u sil ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bipiib pam mu nan bi nima, ki si dandar, ki si lik. Bi nan ye bipiib bi nyan ni Galilee aatiŋ ni ki dii Yesu, ki tun lituln ki ter u na. ");
INSERT INTO xon_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Bi ponn ni ubaa ye Mari Magdalene; uken mu ye Mari, u ye Jems ni Josef aana na; uken mu ye Sebedee aajapɔtiib aana. ");
INSERT INTO xon_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kijook aah joor na, le uwankpadaan ubaa, u ye Arimatea aatiŋ aanii na fuu ni. Bi yin u ke Josef. U mu nan dii Yesu. ");
INSERT INTO xon_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Le uja ngbaan buen Pailat chee ki ti bui u, “Tiin mi Yesu aawon.” Le Pailat bui waajab ke bi di ti tii u. ");
INSERT INTO xon_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Le Josef yoor Yesu aawon, ki di poo likekenyaan ni, ");
INSERT INTO xon_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ki di ti sub kitakpaluŋ ni. Kitakpaluŋ ngbaan le Josef nan cha bi gbii ki, uma ubaa pu. Baa nan kee sub unii ubaa ki ponn ni. Waah di Yesu sub na, le u di litakpasakpeln li pee na, ki di leŋ mbisamɔb, le ki buen. ");
INSERT INTO xon_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Le Mari Magdalene ni Mari uken mu bi nima chee, ki ka gbɔk kitakpaluŋ ngbaan. ");
INSERT INTO xon_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Le ki woln Juu yaab aakpaakool daal, le Uwumbɔr aatotoorninkpiib ni Farisii yaab kuun Pailat chee, ");
INSERT INTO xon_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","le ki bui u, “Timi aaninkpel, ti teer ke unyamɔndaan ngbaan aah nan bi na, u nan bui ke u yaa kpo kan, iwiin itaadaal u ga fikr nkun ni. ");
INSERT INTO xon_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nima pu na, cha bijab li kii waakaakul, ki ti saa iwiin itaa daal, waadidiliib taa dan nan kur u, ki bui binib ke u fikr nkun ni la. Bi yaa ŋa kina kan, kookoo aanyamɔn mue ga jer njan yoo.” ");
INSERT INTO xon_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Le Pailat bui bi, “Tɔ, yoor bikikiirb, ki li cha man, ki ti cha bi li kii waakaakul naah ban pu na.” ");
INSERT INTO xon_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Le bi buen ki ti dab litakpal li leŋ likaakul aamɔb na, ki cha bikikiirb ka kii li. ");
INSERT INTO xon_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juu yaab aakpaakool aah jin ki woln kitaak na, le Mari Magdalene ni Mari uken na buen ti lik likaakul ngbaan kichakpinaanyeek ni. ");
INSERT INTO xon_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Le kitiŋ deŋ sakpen; ba pu? Uwumbɔr aatuun ubaa nan nyan ni paacham, le ki nan chuu lekr litakpal ngbaan, le ki kal li pu. ");
INSERT INTO xon_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U nan moor lak lak ke utaal aah moor pu na. Waawanpeenkaan piin chain ke nkokoyon na. ");
INSERT INTO xon_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bikikiirb aah kan u na, le ijawaan chuu bi sakpen, le biwon gbaa, le bi lir ki fik. ");
INSERT INTO xon_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Le Uwumbɔr aatuun ngbaan bui bipiib ngbaan, “Ni taa san ijawaan man. M nyi ke ni ban Yesu u bi nan kpaa u ndɔpuinkoo pu na la. ");
INSERT INTO xon_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Waa bi do. U fikr nkun ni, waah nan len pu na. Dan man ki nan lik waah ba dɔ nin chee na, ");
INSERT INTO xon_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","aan ki buen mala ki ti tuk waadidiliib ke u fikr nkun ni a, ki loln bi pu nsan ki cha Galilee aatiŋ ni. Bi ga ti kan u nima. Nimina le m ban m tuk nimi.” ");
INSERT INTO xon_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bipiib ngbaan nan san ijawaan, ki mu tee kpa mpopiin pam. Le bi siir likaakul chee mala, ki san buen ke bi ti tuk Yesu aadidiliib Uwumbɔr aatuun ngbaan aah tuk bi pu na. ");
INSERT INTO xon_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Baah cha na, le Yesu ton bi nsan ni, le ki doon bi. Le bi gbaan unimbiin ni, ki joo u, le ki dooni u. ");
INSERT INTO xon_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Le u bui bi, “Taa san ijawaan man. Li cha ki ti tuk maadidiliib ke bi li cha Galilee. Bi ga ti kan mi nima chee.” ");
INSERT INTO xon_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bipiib ngbaan aah cha na, le bikikiirb bi nan kii Yesu aakaakul na buen Jerusalem, ki ti tuk Uwumbɔr aatotoorninkpiib tiwan nimɔk ŋa na. ");
INSERT INTO xon_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib kuun tɔb chee, le ki kal ki kpokl, le ki nyan ŋimombil pam, ki di tii bikikiirb ngbaan, ");
INSERT INTO xon_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","le ki bui bi, “Li cha man ki ti ŋmann binib ke naah dɔ geen kinyeek na, le waadidiliib dan ki nan nyan u likaakul ni. ");
INSERT INTO xon_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kitiŋ aaninkpel yaa ŋun ke ni len ke ni dɔ geen, ki yaa jin nimi tibɔr kan, ti ga nyan nimi.” ");
INSERT INTO xon_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Le bikikiirb ngbaan gaa ŋimombil ngbaan, le ki buen ti tuk binib ke Yesu aadidiliib dan nan nyan waawon likaakul ni a. Nima pu le Juu yaab beenin len kina ki nan saa din. ");
INSERT INTO xon_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu aadidiliib kipiik ni ubaa na nan buen lijool libaa paab, Galilee aatiŋ ni, Yesu aah nan mɔk bi nin chee na. ");
INSERT INTO xon_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Le Yesu fuu ni bi chee. Baah kan u na, le bi gbaan unimbiin ni ki doon u. Le bibaa mu joo beeni. ");
INSERT INTO xon_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Le Yesu bui bi, “Uwumbɔr tii mi mpɔɔn mɔmɔk, paacham ni taab. ");
INSERT INTO xon_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Li cha man ŋinibol mɔmɔk chee, ki ti ŋa bi maadidiliib, ki muin bi nnyun ni, Nte Uwumbɔr, ni min Ujapɔɔn, ni Nfuur Nyaan aayimbil pu, ");
INSERT INTO xon_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ki tuk bi ke bi li keei maah tuk nimi pu na mɔmɔk. Teer man ke m bi ni chee n‑yoonn mɔmɔk, ki nan saa dulnyaa aadoon.”");
INSERT INTO xon_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tibɔr timina le ye Uwumbɔr Aajapɔɔn Yesu Kristo aabɔnyaan. ");
INSERT INTO xon_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Uwumbɔr aabɔnabr Aisaya nan ŋmee waabɔr ngbaan aah ga piin pu na. U nan ŋmee ke Uwumbɔr bui Waabo ke, “‘Maatutunn sɔ. M tun ni u ke u loln ni nsan, ki nan toor nsan ki siin si.’ ");
INSERT INTO xon_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Unii ubaa bi nteersakpiin ni ki tar ke, ‘Toor Uwumbɔr aasan man, ki ŋa waasan mu li tok ki tii u.’” ");
INSERT INTO xon_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kina le uja ubaa nyan sil nteersakpiin ni, bi yin u ke Jɔnn. U nan muini binib nnyun ni, le ki mooni ke, “Kpeln nimi aabimbin man aan Uwumbɔr di cha nimi aatunwanbir pinn nimi, le m ga muin nimi nnyun ni.” ");
INSERT INTO xon_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Le kinipaak nyan Judea aatim mɔmɔk ni, ni Jerusalem aatiŋ ni, ki dan u chee, ki nan kpiir baatunwanbir tuk Uwumbɔr. Le Jɔnn muin bi nnyun ni, Jɔɔdann aamɔɔl ni. ");
INSERT INTO xon_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔnn nan pee kikpalk ki bi nan di laakumii aakor luu ki na. U nan di ligbapapaln buu uchaŋ ni. Waajikaar nan ye itoon ni tisiir la. ");
INSERT INTO xon_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U nan mooni kinipaak ngbaan ke, “Unii u jer mi na paan ni m pu la. Maa ŋeer ke m gbiln waanaatak aaŋmin ki tii u. ");
INSERT INTO xon_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mma muin nimi nnyun ni la. Uma le ga nan di Uwumbɔr Aafuur Nyaan gbiin nimi.” ");
INSERT INTO xon_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","N‑yoonn ngbaan le Yesu nyan Nasaref, kitiŋ ki bi Galilee ni na, ki dan Jɔnn chee. Le Jɔnn muin u nnyun ni, Jɔɔdann aamɔɔl ni. ");
INSERT INTO xon_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu aah nyan nnyun ni na, le u kan kitaapaak chuu piir, le ki kan Uwumbɔr Aafuur Nyaan sunn ni ki nan tɔŋ u pu, ki naahn linanjel. ");
INSERT INTO xon_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Le nneel nyan ni paacham ki len ke, “Aa ye Njapɔɔn u m gee si na la. Nnimbil gbiin si.” ");
INSERT INTO xon_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","N‑yoonn ngbaan le Uwumbɔr Aafuur Nyaan di Yesu buen nteersakpiin ni. U nan ti bi nima iwiin imonko ilee la. Le kinimbɔŋ tɔŋni u nima. ");
INSERT INTO xon_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Timoor ni aapeel mu nan bi nima. Le Uwumbɔr aatuuntiib nyan ni paacham ki dan nan ŋa u tiŋann. ");
INSERT INTO xon_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Le binib nan chuu Jɔnn ki di u ŋa kiyondiik ni. Nee aapuwɔb, le Yesu buen Galilee aatiŋ ni, ki ti mooni Uwumbɔr aabɔnyaan, ");
INSERT INTO xon_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","le ki bui ke, “N‑yoonn fuu a. Uwumbɔr aanaan peen ni a. Kpeln nimi aabimbin man, ki gaa tibɔnyaan tee ki kii man.” ");
INSERT INTO xon_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu nan chuun kpak Galilee Aanyusakpem aagbaan, le ki ti kan Simonn ni unaal Andru bi mae kipɔɔk nnyun ni; bi ye bijanbam la. ");
INSERT INTO xon_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Le Yesu bui bi, “Dii mi man, aan m cha ni ban binib ki nan tii Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Waah len kina na, libuul ngbaan ni le bi siir cha baapɔr, ki dii u. ");
INSERT INTO xon_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Le u foor siib ki kpee, le ki kan Jems ni unaal Jɔnn, bi ye Sebedee aajapɔtiib na. Bi nan bi baaŋɔb ponn ni, ki bi leŋni baapɔr. ");
INSERT INTO xon_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Libuul ngbaan ni le Yesu yin bi. Le bi siir cha bite Sebedee ni waatutum buŋɔb ngbaan ponn ni, le ki dii Yesu. ");
INSERT INTO xon_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Le bi ti fuu Kapenaum aatiŋ ni. Juu yaab aakpaakool daal, le Yesu koo mmeen aadiik ni, ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Waah tuk bi tibɔr ti na, le ni gar bi pam. U tuk bi ke unii u kpa Uwumbɔr aapɔɔn na la, kaa tuk bi ke Uwumbɔr aakaal aamɔmɔkb aah tuk bi pu na. ");
INSERT INTO xon_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Le uja u tiyayaar joo u na bi mmeen aadiik ngbaan ni, ");
INSERT INTO xon_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","le ki teen ke, “Sin Yesu u ye Nasaref aatiŋ aanii na, aa ban ba ti chee? Aa dan aa nan ŋa timi fam la aa? M nyi si. Aa ye Uwumbɔr aanii u ye chain na la.” ");
INSERT INTO xon_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Le Yesu kae tiyayaar ngbaan, ki len ke, “Ŋmim. Di uja ngbaan lii.” ");
INSERT INTO xon_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Le tiyayaar ngbaan cha uja ngbaan aawon gbaa, le ki teen mpɔɔn pu, ki di u lii. ");
INSERT INTO xon_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Le ni gar bi mɔmɔk pam. Le bi baa tɔb, “Ba sɔ? Ni ye mmɔkm pɔɔn la aa? U kpa mpɔɔn, le ki tuk tiyayaar ke ti di binib lii, le ti kii waamɔb.” ");
INSERT INTO xon_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nima pu na, Yesu aayimbil nan moon Galilee aatingbaan mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ni binib bi dii u na nan nyan mmeen aadiik ngbaan ni, le ki buen Simonn ni Andru aadichal ni. Jems ni Jɔnn mu nan dii bi. ");
INSERT INTO xon_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Le Simonn aapuu aana bun, ki dɔ kidiik ni. Le uwon ton. Le bi tuk Yesu ke u bun la. ");
INSERT INTO xon_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Le Yesu buen u chee, ki ti chuu uŋaal, ki fiin u kaan. Le uwon sɔŋ. Le u chann bi tichann. ");
INSERT INTO xon_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Liyaadaal aajook, buyoonn nwiin lir na, binib nan dan Yesu chee, le ki joo ni bibum mɔmɔk, ni tiyayaar aah joo binib bi na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kitiŋ ngbaan aanib mɔmɔk nan kuun nima, Simonn ni Andru do linampal. ");
INSERT INTO xon_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bibum ngbaan nan wiir pam ki nan kpa iween aabɔŋ aabɔŋ na, le Yesu cha bi pɔɔk, ki nyan tiyayaar aah joo binib bi na mu. Tiyayaar ngbaan aah nan nyi waah ye unii u na, waa nan tii ti nsan ke ti len tibaa. ");
INSERT INTO xon_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Njan aakooja aah wii na, le Yesu fii ki nyan lipaal, ki buen nibaa chee, le ki ti bi nima ubaa ki mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Naah woln kichakpiik ni na, le Simonn ni ujɔtiib mu fii ki nyan, ki bi ban u, ");
INSERT INTO xon_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","le ki ti kan u, le ki bui u ke, “Binib mɔmɔk bi ban si la.” ");
INSERT INTO xon_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Le u bui bi, “Cha ti buen ntim muken ni, aan m ti tuk bi mu Uwumbɔr aabɔr. Nima le cha m nyan ni Uwumbɔr do.” ");
INSERT INTO xon_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Le u buen Galilee aatim mɔmɔk ni, ki koo mmeen aadir ni, ki tuk binib Uwumbɔr aabɔr, le ki nyan tiyayaar binib ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ukɔndaan ubaa nan dan Yesu chee, le ki nan gbaan unimbiin ni, ki gaŋ u ke u ter u, le ki bui u ke, “Aa yaa gee kan, aa ga ŋmaa cha m pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Le kinimbaak chuu Yesu. Le u taln uŋaal, ki meeh u, ki bui u, “M gee. Aa pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Libuul ngbaan ni le u pɔɔk, kaa ki ye ukɔndaan. ");
INSERT INTO xon_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Le Yesu bui u ke u li cha, ki sur u mbamɔm ke, ");
INSERT INTO xon_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Li nyi ki taa tuk unii ubaa. Li cha Uwumbɔr aatotoor chee, ki ti di aabaa mɔk u, ki toor kitork tii Uwumbɔr ke Moses aakaal aah len pu na. Nima le ga mɔk binib ke aa pɔɔk a.” ");
INSERT INTO xon_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Le uja ngbaan buen, ki joo tibɔr ngbaan tuk binib mɔmɔk. Waah ŋa kina na, le Yesu aa ki ŋmaa koo kitiŋ kibaa ni, binib aanimbil ni. U nan gur bi kipɔɔk ni la. Le binib nya itingbaan mɔmɔk ni, ki chaa u chee. ");
INSERT INTO xon_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iwiin ilee aah jer na, le Yesu ki gir buen Kapenaum aatiŋ ni. Le binib ŋun ke u bi linampal. ");
INSERT INTO xon_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Le kinipaak kuun ni nima chee. Baah wiir pu na, mpaan aa nan ki gur mbisamɔb chee, ubaa ki sil. Le u tuk bi Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Waah bi tuk bi Uwumbɔr aabɔr na, le binib bibaa fuu ni, ki luln ni unii u aawon faan na likekeln ni. Binib binaa le nan luln ni u. ");
INSERT INTO xon_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kinipaak ngbaan pu, baa nan ŋmaa koo ni Yesu chee. Le bi jon kidiik paab, ki chee liboln ki tuur waah si nin chee kidiik ponn ni na, le ki di baah luln ni unii u likekeln ni na ŋa liboln ngbaan ponn ni, ki di u bil Yesu aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Le Yesu kan baah gaa u ki kii mbamɔm pu na, le ki bui uja u aawon faan na ke, “Maabo, m di cha pinn saatunwanbir.” ");
INSERT INTO xon_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Uwumbɔr aakaal aamɔmɔkb bibaa nan ka nima, le ki bi dak bisui ni ke, ");
INSERT INTO xon_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ba ŋa uja wee len kina? U sii Uwumbɔr la. Ubaa aan ŋmaa di cha pinn titunwanbir, see Uwumbɔr baanja.” ");
INSERT INTO xon_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Le Yesu bee baah dak pu na, le ki baa bi, “Ba ŋa ni dak kina nisui ni? ");
INSERT INTO xon_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maah bui uja u aawon faan na ke m di cha waatunwanbir pinn u na le pɔɔ, aan m yaa bui u ke u fiin ki yoor waawandookaan ki li chuun, le pɔɔ? ");
INSERT INTO xon_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","M ga mɔk nimi ke min, Unibɔn Aabo kpa mpɔɔn dulnyaa wee ni ke m di cha pinn titunwanbir.” Waah len kina na, le u bui uja u aawon faan na ke, ");
INSERT INTO xon_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“M bui si la, fiin, ki yoor saawandookaan, ki li chaa kun.” ");
INSERT INTO xon_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Libuul ngbaan ni le u fii sil, ki yoor waawandookaan, ki nyan lipaal bi mɔmɔk aanimbil ni. Le ni gar bi mɔmɔk pam. Le bi nyuŋ Uwumbɔr ki bui ke, “Taa kee kan kina.” ");
INSERT INTO xon_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu nan ki gir buen nnyusakpem ni. Le kinipaak dan u chee. Le u tuk bi Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Waah cha na, le u kan ulampoogaar ubaa u ka baah gaal lampoo nin chee na. Bi yin u ke Liifai, le ute ye Alfeus. Le Yesu bui u, “Li dii mi.” Le u fii, ki dii u. ");
INSERT INTO xon_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nee aapuwɔb, le Yesu bi Liifai do, ki bi ji tijikaar. Le bilampoogaab ni titunwanbirdam nan wiir, ki dii Yesu. Le bi ponn ni pam mu ka u ni waadidiliib chee, ki bi ji tijikaar. ");
INSERT INTO xon_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Le Uwumbɔr aakaal aamɔmɔkb bibaa, bi ye Farisii yaab na aah kan ke Yesu bi ji bilampoogaab ni titunwanbirdam chee tijikaar na, le bi baa waadidiliib, “Ba ŋa u ji bilampoogaab ni titunwanbirdam chee tijikaar?” ");
INSERT INTO xon_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Le Yesu ŋun baah len pu na, le ki bui bi, “Binib bi kpa laafee na aa ban dɔkta, see bi bun na le ban dɔkta. Maa dan ke m nan yin bininyaam. M dan ke m nan yin titunwanbirdam bi nan kpeln baabimbin la.” ");
INSERT INTO xon_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Le Jɔnn aadidiliib ni Farisii yaab nan bi lulni bumɔb. Le binib bibaa dan nan bui Yesu ke, “Jɔnn aadidiliib ni Farisii yaab aadidiliib lulni bumɔb la. Ba pu saadidiliib ma aa lulni?” ");
INSERT INTO xon_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Le u baa bi, “Bicham bi dan bi nan ji ubɔndinn aajim na ga ŋmaa lul bumɔb buyoonn upiidinn bi bi chee na aa? Aayii. Buyoonn upiidinn bi bi chee na, baan ŋmaa lul bumɔb. ");
INSERT INTO xon_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","N‑yoonn mu choo, le bi ga chuu nyan upiidinn na bi chee mpɔɔn. N‑yoonn ngbaan le bi ga lul bumɔb. ");
INSERT INTO xon_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ubaa aan di likekepɔln aageln, ki di leŋ libɔkukpokl. U yaa ŋa kina kan, likekepɔln aageln na ga kar libɔkukpokl na. Liboln ngbaan ga waar ki jer njan yaan. ");
INSERT INTO xon_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ubaa mu aan di ndawiin, ki di ŋa kilookpok ponn ni. U yaa ŋa kina kan, kilookpok na ga puu, ki bii. Ndaan na mu ga kpir. Bi ga di ndawiin ki di ŋa kiloopɔŋ ni la.” ");
INSERT INTO xon_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juu yaab aakpaakool libaa daal, le Yesu ni waadidiliib bɔ dii kisaak kibaa ponn ni. Baah chuun ki cha na, le waadidiliib joo tijikaar na geei, bi ti ŋmɔ. ");
INSERT INTO xon_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Le Farisii yaab nan baa Yesu ke, “Ba ŋa saadidiliib ŋani kina? Timi aakaal aa kii ke bi ŋa kina likpaakool daal.” ");
INSERT INTO xon_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Le u baa bi, “Naa karn Ubɔr David aah nan ŋa pu na aa? Nkon nan joo u ni waanib. Baa nan kpa tijikaar. ");
INSERT INTO xon_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Le u koo Uwumbɔr Aadichal ni, buyoonn Abiatar nan ye Uwumbɔr aatotoorninkpel na, le ki di Uwumbɔr aaboroboro ŋman, ki joo ti tii waanib mu, bi ŋman. Baah ŋa kina na, le bi bii Moses aakaal mu len ke Uwumbɔr aatotoorb baanja le ga ŋmɔ boroboro ngbaan na. ");
INSERT INTO xon_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“M tuk nimi la, unibɔn pu le likpaakool daal bi, naa ye likpaakool daal pu le unibɔn bi. ");
INSERT INTO xon_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Min Unibɔn Aabo le ye likpaakool daal mu Aadindaan.” ");
INSERT INTO xon_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Le u ki gir buen mmeen aadiik ni. Le uja u aaŋaal faan na bi nima. ");
INSERT INTO xon_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Le bi lik Yesu, ke u ga cha uja ngbaan pɔɔk likpaakool daal aan waan cha u pɔɔk. Ba pu? bi ban bi kan nsan aan ki galn u ke u bii likpaakool daal. ");
INSERT INTO xon_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Le Yesu bui uja u aaŋaal faan na ke, “Nan sil tikaasisik ni,” ");
INSERT INTO xon_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","le ki baa bi, “Likpaakool daal kan, ti ga ŋa ni ŋan na aan ni kaa ŋan na? Ti ga tii unii limɔfal aan ti ga ku u? Timi aakaal mɔk timi kinye?” Le baa len tibaa. ");
INSERT INTO xon_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Le u lik bi mɔmɔk, le ki gee liŋuul bi pu. Bitafal aah pɔɔ pu na, le ni bii usui. Le u bui uja u aaŋaal faan na ke, “Taln aaŋaal.” Le u taln uŋaal. Le mu pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Le Farisii yaab ngbaan nyan lipaal, le ki buen Ubɔr Herod aanib chee, le ki kpokl baah ga ŋa pu ki ku Yesu na. ");
INSERT INTO xon_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ni waadidiliib nan buen Galilee Aanyusakpem ni. Le kinipaak dii u. Bi nyan ni Galilee aatim ni la, ni Judea aatim ni, ");
INSERT INTO xon_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ni Jerusalem, ni Idumea aatim ni, ni ntim mu bi Jɔɔdann aamɔɔdapuul na, ni Taya ni Saidonn aatingbaan ni. Bi nan wiir sakpen a. Bi ŋun Yesu aah tun lijinjiir aatun pu na. Nima le cha bi dan u chee. ");
INSERT INTO xon_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Le u bui waadidiliib ke bi di buŋɔb deen nnyun pu, nnyusakpem aagbaan chee, aan u koo ni, kinipaak ngbaan taa muen u. ");
INSERT INTO xon_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","U nan tii binib pam laafee. Nima le bibum mɔmɔk tur tɔb, bi ti fuu u chee aan ki di biŋaal meeh u. ");
INSERT INTO xon_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tiyayaar ti joo binib na aah kan u na, le ti cha bi gbaan unimbiin ni, le ki teen ke, “Aa ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Le Yesu kae tiyayaar ngbaan ke, “Taa li joo mi mooni man.” ");
INSERT INTO xon_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu nan jon lijool paab, le ki yin waah ban binib bi na ke bi dan u chee. Le bi dan u chee. ");
INSERT INTO xon_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Le u nyan bijab kipiik ni bilee, bi ti li bi u chee. Le u yin bi ke waakpambalb. U nyan bi ke u tun bi, aan bi ti tuk binib Uwumbɔr aabɔr, ");
INSERT INTO xon_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ki li kpa mpɔɔn ki nyan tiyayaar binib ni. ");
INSERT INTO xon_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Waah nyan bijab kipiik ni bilee bi na aayimbil sɔ: Simonn, le Yesu duln u ke Piita; ");
INSERT INTO xon_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jems ni unaal Jɔnn bi ye Sebedee aajapɔtiib na, le Yesu duln bi ke Boanejes. Boanejes aatataa le ye ke “Binib bi tar ke utaal na”; ");
INSERT INTO xon_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ni Andru, ni Filip, ni Batolomiu, ni Matiu, ni Tomas, ni Jems u ye Alfeus aajapɔɔn na; ni Tadeus; ni Simonn u nan ban u kuln waatiŋ aadim na; ");
INSERT INTO xon_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ni Judas Iskariot, u ga nan kooh uma Yesu na. ");
INSERT INTO xon_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Le Yesu chaa kun. Le kinipaak ki kuun ni u chee. Nima pu na, u ni waadidiliib aa nan kpa nsan bi ji tijikaar. ");
INSERT INTO xon_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Udoyaab aah ŋun kina na, le bi dan bi nan chuu u; ba pu? bi ŋun binib len ke u waar la. ");
INSERT INTO xon_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Uwumbɔr aakaal aamɔmɔkb bi nyan ni Jerusalem na le bui ke kinimbɔŋ, ki bi yin ki ke Beelsebul, u ye tiyayaar aayidaan na, le joo u ki tii u mpɔɔn ke u nyan tiyayaar binib ni. ");
INSERT INTO xon_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Baah len kina na, le Yesu yin bi ke bi dan u chee, le ki ŋak bi ŋiyataŋak ke, “Kinimbɔŋ ga ŋa kinye ki nyan kima kinimbɔŋ binib ni? ");
INSERT INTO xon_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kitiŋ kibaa ni aanib yaa yakr ki yaa jaa kijaak kan, kitiŋ ngbaan ga bee yɔli. ");
INSERT INTO xon_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lidichal libaa ni aanib yaa yakr ki jaa kijaak kan, lidichal ngbaan ga bee yɔli. ");
INSERT INTO xon_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kinimbɔŋ aanaan yaab yaa yakr ki jaa kijaak kan, kaan ki ŋmaa sil. Kaanaan ga doo.” ");
INSERT INTO xon_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ubaa aan ŋmaa koo mpɔɔndaan aadichal ni, ki bii waawan, see u puen buu u le waahr, le ki nin bii waadichal. ");
INSERT INTO xon_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“M tuk nimi mbamɔn la, Uwumbɔr ga di cha binib aatunwanbir mɔmɔk ki pinn bi. Bi yaa sii u kan, u ga di cha pinn bi. ");
INSERT INTO xon_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Uwumbɔr Aafuur Nyaan ma kan, unii yaa sii muma kan, Uwumbɔr aan di cha pinn u. U ga li kpa taani n‑yoonn mu kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Binib bibaa nan bui ke tiyayaar le joo Yesu. Nima le cha u len kina. ");
INSERT INTO xon_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Le Yesu aana ni unaatiib fuu ni ki si lipaal, le ki tun unii ke u ti yin Yesu. ");
INSERT INTO xon_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Le kinipaak ka gob Yesu. Le bi tuk u, “Lik, aana ni aanaatiib si lipaal ki ban si la.” ");
INSERT INTO xon_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Le u baa bi ke, “Ŋma ye nna? Bilabi ye nnaatiib?” ");
INSERT INTO xon_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","le ki fenn toŋ waadidiliib bi ka gob u na, le ki bui ke, “Lik, nna ni nnaatiib sɔ. ");
INSERT INTO xon_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ba pu? unii umɔk ŋani Uwumbɔr aah gee pu na, uma le ye nnaal, ni nninkpan, ni nna.” ");
INSERT INTO xon_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu nan ki gir buen Galilee aanyusakpem aagbaan, ki ti tuk binib Uwumbɔr aabɔr. Le kinipaak sakpeŋ ki kuun ni u chee. Baah wiir pu na, le u koo kal buŋɔb ni, nnyun ni. Kinipaak ngbaan mu nan si nnyusakpem aagbaan. ");
INSERT INTO xon_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Le u tuk bi tibɔr pam ŋiyataŋak ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","U nan bui bi ke, “Li pel man, ukpaal ubaa le nan buen u ti yaa njikaabim. ");
INSERT INTO xon_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waah yaa njikaabim ngbaan na, le mubaa lir nsan ni. Le inyoon dan, ki nan peei jin. ");
INSERT INTO xon_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Le mubaa mu lir ntakpateer paab, titan aah kaa wiir nin chee na. Titan aah kaa wiir na, le mu guu punn mala. ");
INSERT INTO xon_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Le nwiin puu, ki ton, ki see mu. Mu aah kaa kpa inyaan mbamɔm na, le mu yɔl, ki kpo. ");
INSERT INTO xon_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Le mubaa mu lir ikokon ponn ni. Le ikokon muun, le ki ku mu, le mu aa mar. ");
INSERT INTO xon_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Le mubaa mu lir kitiŋ ki ŋan na ponn ni, ki punn, le ki muun, ki mar. Ngem lun piitaa piitaa, ngem mu lun imonko itata, ngem mu lun nkub nkub. ");
INSERT INTO xon_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu aah bi ubaa na, le waadidiliib kipiik ni bilee na, ni binib bi nan bi u chee na nan dan ki nan baa u waayataŋak ngbaan aatataa. ");
INSERT INTO xon_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Le u bui bi ke, “Uwumbɔr le cha ni bee waanaan aabɔbɔrkaan. Binib bi kaa bi waanaan ni na, u ŋak bima le ŋiyataŋak, ");
INSERT INTO xon_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Aan bi lik ki lik, kaa waa, ki pel ki pel, kaa beer naatataa. Bi yaa ŋun ki bee naatataa kan, nibaakan bi ga kpeln baabimbin, aan Uwumbɔr di cha baatunwanbir ki pinn bi.’” ");
INSERT INTO xon_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Le Yesu baa bi ke, “Naa bee liyataŋakl ngbaan aatataa aa? Ni ga ŋa kinye ki bee ŋiyataŋak ŋiken aatataa? ");
INSERT INTO xon_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Liyataŋakl ngbaan aatataa le ye ke ukpaal ngbaan le ŋaŋ unii u tuk binib Uwumbɔr aabɔr na. ");
INSERT INTO xon_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ndibim mu lir nsan ni na le ŋaŋ binib bi ŋun Uwumbɔr aabɔr na. Libuul ngbaan ni le kinimbɔŋ dan ki nan nyan ti bisui ni. ");
INSERT INTO xon_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mu lir ntakpateer pu na le ŋaŋ binib bi ŋun tibɔr ngbaan, ki gaa ti mala ni mpopiin na. ");
INSERT INTO xon_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bi mu aa gaa ti bisui ni mbamɔm, kaa joo ti ni yunn. Bi yaa kan limukl ti pu kan, bee binib yaa ŋa bi falaa ti pu kan, libuul ngbaan ni le bi ga di ti lii. ");
INSERT INTO xon_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Binib bibaa mu bi ke njikaabim mu lir ikokon ponn ni na la. ");
INSERT INTO xon_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bi ŋun tibɔr ngbaan la. Le dulnyaa wee ni aabɔr, ni liwankpal aakɔrk, ni tiwan aabɔŋ aakɔrk mu koo bisui ni, le ki ku tibɔr ngbaan bisui ni, le taa mar. ");
INSERT INTO xon_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mu lir kitiŋ ki ŋan na ponn ni na le ŋaŋ binib bi ŋun tibɔr ngbaan, ki gaa ti, le ki mar. Ngem mar piitaa piitaa, ngem mu mar imonko itata, ngem mu mar nkub nkub.” ");
INSERT INTO xon_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Le u baa bi ke, “Unii yaa see karyaa kan, u ga di lisambil chiŋ u pu uu? U ga di siin tiwandookaan aataab la aa? Waan di tɔŋ tiwan nibaa pu la aa? ");
INSERT INTO xon_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tibɔr timɔk bɔɔ na, ti ga kpiir. Tibɔbɔrkaan mɔmɔk mu ga nyan mpaan pu. ");
INSERT INTO xon_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","U kpa litafal na kan, u ŋun. ");
INSERT INTO xon_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Cha nitafal li bi naah ŋun ti na ni man. Naah tii pu na, Uwumbɔr mu ga giin kina le ki tii nimi. U ga tii nimi ki jer naah tii pu na. ");
INSERT INTO xon_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Unii umɔk kpa na, Uwumbɔr ga kpee u. Unii u kaa kpa na, Uwumbɔr ga chuu gaa waah kpa ni pɔkaa na. ");
INSERT INTO xon_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","“Uwumbɔr aanaan naahn njikaabim mu uja bun waasaak ni na la. ");
INSERT INTO xon_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","U geeni kinyeek, kitaak yaa woln kan, u fii. Le njikaabim ngbaan ga punn, ki muun. Waa nyi mu aah ŋa pu ki punn, aan ki muuni na. ");
INSERT INTO xon_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kitiŋ ngbaan le cha tijikaar ŋa. Njan le mu punn, le ki nin muun ki poo, le ki mar. ");
INSERT INTO xon_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti yaa nan biir kan, ni ŋeer lijikaacheel la. Nima pu na, u ga di gɔrk, ki buen ti chee ti.” ");
INSERT INTO xon_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu nan baa bi ke, “M ga di ba ki di ŋaŋ Uwumbɔr aanaan? M ga di liyataŋakl bayaar ki di ŋaŋ mu? ");
INSERT INTO xon_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mu naahn linaanyiimbil la. Libil ngbaan le ye libil waatiir, ŋibil mɔmɔk filk jer lima la. ");
INSERT INTO xon_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bi yaa di li bun kan, li ga punn ki muun ki jer tisufar mɔmɔk, ki ŋa ibon i filk na. Le inyoon i laani paacham na ga ŋmaa ter yaadil ibon ngbaan pu.” ");
INSERT INTO xon_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kina le Yesu di ŋiyataŋak ŋimina aaboln pam tuk bi Uwumbɔr aabɔr. U ŋak bi ŋiyataŋak ki ti ŋeer baah ga ŋmaa pel pu na la. ");
INSERT INTO xon_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waa len tibaa bi chee, see ŋiyataŋak ŋmeen. U ni waadidiliib aah bi bibaa na, le u ŋeer ŋiyataŋak ngbaan aatataa tuk bi. ");
INSERT INTO xon_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nwiin ngbaan daal aajook, le u bui waadidiliib ke, “Cha ti puur nnyusakpem man.” ");
INSERT INTO xon_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Le bi siir kinipaak ngbaan chee, ki koo u chee buŋɔb ni. Iŋɔi iken mu nan bi nima chee. ");
INSERT INTO xon_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baah cha na, le kibuŋ ti fii ki bi daar. Le tinyunkpenn fii yeŋni, ki koo buŋɔb ngbaan ponn ni, le bu ban bu liin. ");
INSERT INTO xon_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu mu dɔ liyikukur pu geen, liŋɔjuul wɔb. Le bi dan nan finn u, le ki bui u ke, “Umɔmɔkr, ti yaa bee nnyun ni kan, aatafal aa bi ti ni ii?” ");
INSERT INTO xon_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Le u fii ki kae kibuŋ ngbaan, le ki bui nnyun ngbaan ke, “Doon suuna.” Libuul ngbaan ni, le kibuŋ ngbaan ŋmin, nnyun mu doon suuna, ni mɔmɔk ŋmin chii. ");
INSERT INTO xon_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Le u baa bi, “Ba ŋa ni san ijawaan? Naa kee gaa mi ki kii mbamɔm aa?” ");
INSERT INTO xon_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tɔ, ijawaan nan chuu bi sakpen, le bi baa tɔb ke, “Ba aanibol bi na? Kibuŋ ni nnyun mu kpaan kii waamɔb.” ");
INSERT INTO xon_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Le bi fuu nnyusakpem aadapuul, Gerasiin yaab aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Le uwaar ubaa nan bi nima. ");
INSERT INTO xon_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Waakookoo yaan nan ye baah sui binib titakpalunn ti ponn ni na la. Ubaa aa ŋmaa baa u kaan. Bi yaa buu u tikululn kan, u keei ti la. ");
INSERT INTO xon_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bi nan joo idɔribi ni tikululn buu u kpala kpala. Le u keei tikululn ngbaan, ki gbaa wiir idɔribi mu. Ubaa aa ŋmaa tiŋ u. ");
INSERT INTO xon_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nwiin pu ni kinyeek, u po bi ŋikaakul ngbaan ni, ni ŋigongon paab, ki tar, ki joo ŋitakpal geei ubaa. ");
INSERT INTO xon_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu aah nyan buŋɔb ni na, le uwaar ngbaan bi dandar, ki kan u, ki san nan tooh u nsan ni, le ki nan gbaan unimbiin ni, ki doon u. ");
INSERT INTO xon_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Le Yesu bui ke, “Tiyayaar, nyan uja ngbaan ni.” Le u teen ki len mpɔɔn pu ke, “Yesu, si u ye Uwumbɔr u kaa kpa ŋeen aatɔ na Aajapɔɔn na, aa ban ba m chee? M gaŋ si Uwumbɔr pu, taa ŋa mi falaa.” ");
INSERT INTO xon_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Le Yesu baa u, “Bi yin si ke ba?” Le u bui u, “Ti ye tiyayaar ti wiir na la, nima le bi yin mi ke Kipaak,” ");
INSERT INTO xon_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","le ki gaŋ u sakpen ke u taa jenn nyan ti kitiŋ kee ni. ");
INSERT INTO xon_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Igbeer ibaa mu nan bi nima chee, ki wiir, ki chuun ji limɔɔgongoln paab. ");
INSERT INTO xon_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Le tiyayaar ngbaan gaŋ Yesu ke, “Cha ti ti koo igbeer ngbaan ni.” ");
INSERT INTO xon_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Le u kii. Le ti nyan uja ngbaan ni, ki ti koo igbeer na ni. Le igbeer mɔmɔk san sunn limɔɔgongoln taab, ki ti koo nnyun ni, ki bee nnyun ni. I ga nan li fuu ŋichur ŋilee. ");
INSERT INTO xon_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Le bijab bi kii igbeer ngbaan na san buen kitiŋ ni, ni itingbaan ni, ki ti tuk binib tibɔr ngbaan. Binib aah ŋun kina na, le bi dan bi nan lik budabu ŋa na, ");
INSERT INTO xon_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","le ki fuu ni Yesu chee, ki kan uja u tiyayaar ti wiir na nan joo u na ka nima. U cheer, ki pee tiwanpeenkaan, kaa ki chuun uŋmeen. Le ijawaan chuu bi. ");
INSERT INTO xon_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Binib bi kan Yesu aah nyan tiyayaar uja ngbaan ni pu na nan tuk bi Yesu aah ŋa pu na, ki tuk bi naah ŋa igbeer ngbaan mu pu na. ");
INSERT INTO xon_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Le bi gaŋ Yesu ke u nya baatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Le u gir ti koo buŋɔb na ni. Waah gir u ti koo buŋɔb ni na, le uja u tiyayaar nan joo u na gaŋ u ke u cha u dii u. ");
INSERT INTO xon_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Le u yii, le ki bui u, “Gir kun, ki ti tuk aadoyaab Uwumbɔr aah san si kinimbaak ki tun litukpaan tii si pu na.” ");
INSERT INTO xon_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Le u buen, ki di bɔ dii kitiŋ ki bi yin ki ke Ntim Kipiik na ni, le ki tuk binib Yesu aah tun litukpaan pu ki tii u na. Le ni gar bi mɔmɔk pam. ");
INSERT INTO xon_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu nan ki gir puur nnyusakpem aadapuul, buŋɔb na ni. Waah ti fuu nima na, le kinipaak sakpeŋ kuun ni u chee. Le u si nnyun aagbaan. ");
INSERT INTO xon_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Le uja ubaa dan u chee. U ye mmeen aadiik ni aaninkpel ubaa la. Le bi yin u ke Jairus. Waah kan Yesu na, le u nan gbaan unimbiin ni, ");
INSERT INTO xon_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ki gaŋ u sakpen le ki bui u ke, “Ni yaa ki kpee siib na kan, mbisal ga kpo. M gaŋ si la, dan nan di aaŋaal ki di paan u pu, aan u pɔɔk ki taa kpo.” ");
INSERT INTO xon_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Le Yesu dii u buen. Le kinipaak ngbaan mu dii Yesu, ki mueni u. ");
INSERT INTO xon_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Le upii u fu tipiir ŋibin kipiik ni ŋilee taa door na, mu bi nima chee. ");
INSERT INTO xon_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U nan chaa biteteeb chee, ki kan falaa aabɔŋ mɔmɔk, ki jin waamombil mɔmɔk doo, le naa soor. U nan moo buŋni la. ");
INSERT INTO xon_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Le u ŋun Yesu aabɔr, le ki len usui ni ke u yaa po meeh waawanpeenkaan kan, u ga pɔɔk. Le u bɔ kinipaak ngbaan ponn ni, ki paan Yesu aapuwɔb, ki taln uŋaal, ki meeh waawanpeenkaan. ");
INSERT INTO xon_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Libuul ngbaan ni, le u pɔɔk, ki bee uwon ponn ni ke iween ngbaan doo a. ");
INSERT INTO xon_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Le Yesu bee usui ni ke mpɔɔn ngem nyan u ni a. Le u fenn kinipaak ngbaan ni, ki baa ke, “Ŋma meeh maawanpeenkaan?” ");
INSERT INTO xon_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Le waadidiliib bui u, “Aa kan kinipaak ngbaan aah kpei si pu na, le aa baa ke ŋma meeh si?” ");
INSERT INTO xon_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Le u fenn, ki lik ŋipepel mɔmɔk ke u kan udaan u meeh u na. ");
INSERT INTO xon_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Le upii ngbaan bee tiwan ni ŋa u na. Ijawaan mu chuu u, le uwon gbaa. Le u dan nan gbaan Yesu aanimbiin ni, ki tuk u waabɔr mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Le Yesu bui u, “Mbisal, saah gaa mi ki kii mbamɔm pu na, nima le cha aa pɔɔk. Li cha ni mpopiin. Saaween ngbaan aan ki fii.” ");
INSERT INTO xon_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu aah len kina na, le binib bibaa nyan ni Jairus do, ki tooh ni bi nsan ni, ki nan bui Jairus ke, “Aabisal kpo a. Taa ki cha Umɔmɔkr ngbaan ŋani falaa ki cha aado.” ");
INSERT INTO xon_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu nan ŋun baah len pu na, le ki bui Jairus, “Tii mi naadii, ki taa san ijawaan.” ");
INSERT INTO xon_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu aa nan cha ubaa ki dii u ki kpee Piita ni Jems, ni Jems aanaal Jɔnn pu. ");
INSERT INTO xon_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yesu nan fuu Jairus do le ki ŋun kifuuk pu. Binib bi nima ki wiir, ki wii ikpowiil, ki kaani. ");
INSERT INTO xon_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Le u koo lidichal ngbaan ni. Waah koo ni na, le u baa bi, “Ba ŋa ni kpa kifuuk kina, ki wii? Ubo ngbaan aa kpo. U geen la.” ");
INSERT INTO xon_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Le bi laa u sakpen. Le u jenn nyan bi mɔmɔk lipaal, ");
INSERT INTO xon_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ki di ubo ngbaan aate ni una, ni waadidiliib bitaa na, ki di koo waah bi kidiik ki ponn ni na, le ki ti chuu uŋaal, ki bui u ke, “Upiibo, m bui si la, fiin.” ");
INSERT INTO xon_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Libuul ngbaan ni, le u fii sil, ki chuun gonni. U nan ye ŋibin kipiik ni ŋilee aabo la. Le ni gar bi ki ti nyaŋ. ");
INSERT INTO xon_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Le Yesu bui bi ke bi taa tuk unii ubaa, le ki bui bi ke bi tii upiibo ngbaan tijikaar u ji. ");
INSERT INTO xon_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu nan siir nima chee, ki gir buen udo aatiŋ ni. Le waadidiliib dii u. ");
INSERT INTO xon_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Likpaakool daal, le u buen mmeen aadiik ni, ki ti tuk binib Uwumbɔr aabɔr. Kinipaak ki bi nima na aah ŋun waaliin na, ni gar bi pam. Le bi baa tɔb ke, “Uja wee kan nimina mɔmɔk la chee? U tee kpa ba aalanboln na? Waah tun lijinjiir aatun pu na, u ŋani kinye ki tun ŋi? ");
INSERT INTO xon_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Waa ye kapenta na aa? Waa ye Mari aajapɔɔn la aa? Waa ye Jems, ni Joses, ni Judas, ni Simonn aakpel la aa? Uninkpatiib aa bi do chee na la aa?” Binib ngbaan nan len kina ki yii u. ");
INSERT INTO xon_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Le u bui bi, “Binib pak Uwumbɔr aabɔnabtiib la, see bido aatiŋ ni aanib, ni baamaal, ni baachiln ni aanib baanja le aan pak bi.” ");
INSERT INTO xon_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Le u di uŋaal paan bibum siib pu, ki cha bi pɔɔk, kaa ki ŋmaa tun lijinjiir aatuln liken nima chee; ba pu? baa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Baah kaa gaa u ki kii na, le ni gar u pam. U nan bɔ dii itingbaan ni, le ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Le u yin waadidiliib kipiik ni bilee na ke u tun bi nibaa chee, bilelee, bilelee. U tii bi mpɔɔn ke bi ti nyan tiyayaar binib ni, ");
INSERT INTO xon_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","le ki bui bi, “Ni taa tun lisachuln aatuln libaa. Ni taa li joo nibaa see kijaangbeek baanja. Ni taa li joo tijikaar, ki taa li joo litaakɔr, ki taa li joo ŋimombil tikpalɔnn ni, ki taa li joo libɔkul ki kpee naah pee li na pu. ");
INSERT INTO xon_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ni li tak ŋinaatak man. ");
INSERT INTO xon_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Naah ti koo lidichal li ponn ni na, ni li bi li ponn ni ki ti saa bundaln ni ga nyan kitiŋ ngbaan ponn ni na, ki taa ki kpeln lidichal. ");
INSERT INTO xon_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kitiŋ kibaa aanib yaa kaa gaa nimi, ki yaa yii nimi aabɔr kan, ni nya nima, ki kpaar nitaa aatatan lii nima. Nimina le ga li ye nsurm ki tii bi.” ");
INSERT INTO xon_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Waadidiliib ngbaan nan buen, le ki ti bui binib, “Kpeln nimi aabimbin man.” ");
INSERT INTO xon_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bi nan nyan tiyayaar binib pam ponn ni, ki di nkpan nuk binib pam aayil, le bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu aayimbil nan moon ŋipepel mɔmɔk ni. Le Ubɔr Herod mu ti ŋun u pu, le ki bui ke Jɔnn u nan muini binib nnyun ni na le fikr nkun ni, nima le cha u kpa mpɔɔn ki tun lijinjiir aatun ngbaan. ");
INSERT INTO xon_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Le biken mu bui ke u ye Uwumbɔr aabɔnabr Elaija u nan bi n‑yaayoonn na la. Le biken mu bui ke u ye Uwumbɔr aabɔnabr ke bibɔnabtiib bi nan bi n‑yaayoonn na la. ");
INSERT INTO xon_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tɔ, Ubɔr Herod aah ŋun Yesu aabɔr na, le u bui ke, “U ye Jɔnn, u m nan chuu gii uyil na la. U fikr nkun ni la.” ");
INSERT INTO xon_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Budabu pu Ubɔr Herod len kina na le ye ke u nan tun waajab bi ti chuu Jɔnn, ki buu u tikululn, ki di u ŋa kiyondiik ni. Taani u cha u chuu u na, le ye ke Jɔnn nan bui u ke waah ŋa pu na, naa ŋan. Ba pu? Ubɔr Herod nan kpa naal ubaa, bi yin u ke Filip, le u nan gaa unaal ngbaan aapuu u chee. Bi yin upii ngbaan ke Herodias. ");
INSERT INTO xon_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Le Jɔnn bui Ubɔr Herod ke waah gaa unaal aapuu na, u bii Uwumbɔr aakaal. ");
INSERT INTO xon_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nima pu le Herodias nan nann Jɔnn, ki ban u ku u, kaa ŋman; ");
INSERT INTO xon_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ba pu? Ubɔr Herod aa nan cha u ŋa u nibaa. Herod san Jɔnn ki bee ke u ye uninyaan u bi chain na la. Nima pu na, Herod nan gee u li pel waabɔr. Waah nan ŋun waabɔr ti na nan ŋa u ilandak sakpen a. ");
INSERT INTO xon_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Le Ubɔr Herod aamaal aawiin daal nan fuu. Le u ŋa tijikaar pam, ki yin bininyuum, ni waajab aaninkpiib, ni Galilee aatiŋ aaninkpiib ke bi dan nan ji. ");
INSERT INTO xon_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baah bi ji tijikaar ngbaan na, le Herodias aabisal dan nan waa liwaal bi mɔmɔk aanimbiin ni. Le ni mɔɔr Ubɔr Herod, ni binib bimɔk nan bi ji u chee tijikaar na. Le Ubɔr Herod bui u ke u ga tii u ipiin. U yaa len waah ban pu na kan, nima le u ga tii u. ");
INSERT INTO xon_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U nan puu Uwumbɔr ke u ga tii u waah ban pu na; ni yaa po ye waanaan ligeln kan, u ga tii u. ");
INSERT INTO xon_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Le usapɔɔn ngbaan buen ti baa una ke, “M ga bui u ke u tii mi ba?” Le una Herodias kan nsan mu u ga di ku Jɔnn na, le ki bui waabo ke, “Li cha ti bui u ke aa ban Jɔnn u muini binib nnyun ni na aayil la.” ");
INSERT INTO xon_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Le u gir buen Ubɔr Herod chee mala, ki ti bui u ke, “M ban ke aa di Jɔnn u muini binib nnyun ni na aayil, ki di ŋa likusambil ponn ni, ki di tii ni mi dandana wee.” ");
INSERT INTO xon_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Waah len kina na, le ni bii Ubɔr Herod aasui sakpen. Waah puu tipuur ti bicham aanimbil ni na, nima le waa ban ke ti bee. ");
INSERT INTO xon_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Libuul ngbaan ni le u tun waajab ponn ni ubaa ke u ti li joo ni Jɔnn aayil. Le uja ngbaan buen kiyondiik ni, ki ti chuu gii ni Jɔnn aayil, ");
INSERT INTO xon_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ki di ŋa likusambil ponn ni, ki joo ni nan di tii usapɔɔn ngbaan. Le u mu di ti tii una. ");
INSERT INTO xon_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jɔnn aadidiliib aah ŋun kina na, bi dan nan yoor linikpol ngbaan, ki ti di sub. ");
INSERT INTO xon_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu aakpambalb nan ki gir ni u chee, ki nan tuk u baah tuk binib Uwumbɔr aabɔr, ki tun lituln mɔmɔk pu na. ");
INSERT INTO xon_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Binib mu nan bi nima chee ki wiir, bibaa choo, biken mu gir. Nima pu na, u ni waadidiliib aa nan kpa mpaan bi ji tijikaar. Le u bui bi, “Cha ti buen kipɔɔk ni, binib aah kaa bi nin chee na, ki ti li bi tibaa, ki kal ki fuur.” ");
INSERT INTO xon_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Le bi koo buŋɔb ni, ki kpak nnyusakpem aagbaan, ki ti bi kipɔɔk ni bibaa. ");
INSERT INTO xon_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Binib nan kan baah cha pu na. Le bi ponn ni pam bee bi, le ki nyan itingbaan mɔmɔk ni, ki san kpak nnyusakpem aagbaan, ki ti puen bi fuu nima. ");
INSERT INTO xon_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu aah nan ti fuu nima ki nyan buŋɔb ni na, u kan kinipaak sakpeŋ. Bi nan bi ke ipiih i chuun kaa kpa upihkpaal na. Nima le u san bi kinimbaak, ki tuk bi Uwumbɔr aabɔr pam. ");
INSERT INTO xon_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kijook aah joor na, le waadidiliib dan nan bui u ke, “Ti bi kipɔɔk ni la. Kijook mu joor a. ");
INSERT INTO xon_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cha binib ngbaan buen itingbaan ni ki ti daa tijikaar ki ji.” ");
INSERT INTO xon_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Le u bui bi, “Nimi nibaa tii bi tijikaar bi ji man.” Le bi baa u, “Ti ga di iwiin ikui ilee aapal ki daa tijikaar ki nan tii bi, bi ji ii?” ");
INSERT INTO xon_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Le u baa bi, “Ni kpa ŋiboroboro kpin ŋiŋa? Li cha ti lik man.” Le bi buen ti lik, ki gir ni nan tuk u ke, “Ti kpa ŋiboroboro kpin ŋiŋmu ni ijan ilee.” ");
INSERT INTO xon_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Le u bui kinipaak ngbaan mɔmɔk ke, “Kaln kitiŋ timosɔnn pu man, ŋikpuk ŋikpuk.” ");
INSERT INTO xon_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Le bi kal nkub nkub, ikuul piiŋmu pu. ");
INSERT INTO xon_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Le u yoor ŋiboroboro kpin ŋiŋmu, ni ijan ilee ngbaan, ki waan lik paacham, ki doon Uwumbɔr, le ki gii gii boroboro ngbaan, ki di tii waadidiliib ke bi yakr siin binib ngbaan aanimbiin ni. Le u yakr ijan ilee ngbaan mu, ki di tii bi mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Le bi mɔmɔk ŋman ki bab. ");
INSERT INTO xon_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Baah ŋman ki bab na, le waadidiliib kuun boroboro ni ijan i gur na, ki gbiin tibɔɔkur kipiik ni tilee. ");
INSERT INTO xon_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bijab bi jin tijikaar ngbaan na nan ye ŋichur ŋiŋmu la. ");
INSERT INTO xon_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Libuul ngbaan ni, le Yesu muk waadidiliib ke bi gir koo buŋɔb na ni, ki loln u pu nsan, ki puur nnyusakpem aadapuul, ki buen Betseda aatiŋ ni. Le u tuk kinipaak ngbaan ke bi li cha kun. ");
INSERT INTO xon_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Waah chɔi bi na, le u jon lijool paab, u ti mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Le ni mue. Le u bi nima, ubaa. Waadidiliib mu nan bi buŋɔb ni, nnyusakpem aakaasisik ni. ");
INSERT INTO xon_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Libuln mu daar ki tok bi sakpen ki muk bi. Le Yesu kan ke ni pɔɔ sakpen baah ga ŋaal buŋɔb pu aan bu chuun na. Ikooja aah wii buyoonn na, le u chuun nnyun paab, ki buen bi chee, ki ti ŋaŋ bi. U ba ga nan jer bi pu. ");
INSERT INTO xon_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Le bi mɔmɔk kan u chuun nnyun pu. Baah kan u na, le bi dak ke ni ye utekpiir aawiin la. Le ijawaan chuu bi sakpen. Le bi faa ikuun. Libuul ngbaan ni le u bui bi, “Chuu nibaa man. Min ye. Ni taa san ijawaan man,” ");
INSERT INTO xon_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","le ki koo buŋɔb ni bi chee. Waah koo buŋɔb ni na, le libuln ŋmin. Le ni gar bi ki ti nyaŋ; ");
INSERT INTO xon_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ba pu? bitafal aah pɔɔ pu na, nima le baa bee waah fe di boroboro tun lijinjiir aatuln pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Le bi fuu nnyusakpem aadapuul, Genesaret aatiŋ chee, le ki nyan buŋɔb ni, ki di bu gbin. ");
INSERT INTO xon_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Baah ti nyan buŋɔb ni na, libuul ngbaan ni le binib bee Yesu, ");
INSERT INTO xon_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ki san buen itingbaan mɔmɔk ni, ki luln ni bibum ŋikeken ni, ki joo ni bi u chee. Bi yaa ŋun waah bi nin chee na kan, le bi joo ni bibum u chee. ");
INSERT INTO xon_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","U yaa buen ntisakpem ni, bee itingbaan ni kan, bi joo ni bibum, ki nan bilni kinyaŋ ni, le ki mee u ke u cha bibum meeh waabɔkul aamɔjuul. Bimɔk meeh li na, libuul ngbaan ni le bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Le Farisii yaab ni Uwumbɔr aakaal aamɔmɔkb bibaa nyan Jerusalem, ki dan nan kuun Yesu chee. ");
INSERT INTO xon_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bi nan kan ke waadidiliib bibaa aah ji tijikaar pu na, bi bii baakaal; ba pu? baa ŋir biŋaal. ");
INSERT INTO xon_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisii yaab ni Juu yaab biken dii biyaajatiib aakaal la. Bi yaa kaa ŋir biŋaal mbamɔm kan, baan ji tijikaar. ");
INSERT INTO xon_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bi yaa nyan kinyaŋ ni kan, baan ji nibaa see bi puen fu nnyun waahr, le ki dii ikaal aabɔŋ aabɔŋ ke nimina na, ki ŋir ŋisambil, ni ŋibuu, ni tiyir, ni tiwandookaan, baakaal aah dii pu na. ");
INSERT INTO xon_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Le Farisii yaab, ni Uwumbɔr aakaal aamɔmɔkb ngbaan baa Yesu ke, “Ba ŋa saadidiliib aa dii tiyaajatiib aakaal? Bi ji tijikaar kaa ŋir biŋaal.” ");
INSERT INTO xon_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Le u bui bi, “Nimi biŋmaŋmannim, Uwumbɔr aabɔnabr Aisaya aah nan len nimi aabɔr na, u nan len mbamɔn la ke, ‘Binib ngbaan pak Uwumbɔr bumɔb ni la. Bisui daa u chee. ");
INSERT INTO xon_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bi dooni u yɔli la, ki mɔk binib biyaajatiib aakaal, ke ni ye waakaal la.’” ");
INSERT INTO xon_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu nan ki tuk bi ke, “Ni di Uwumbɔr aakaal lii, le ki joo binib yaan. ");
INSERT INTO xon_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Ni tee yii Uwumbɔr aakaal, le ki dii niyaajatiib aakaal. ");
INSERT INTO xon_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses nan len ke, ‘Aa li pak aate ni aana,’ ki ki len ke, ‘Unii yaa len tibɔbir lii ute, bee una pu kan, ni ku u.’ ");
INSERT INTO xon_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Le nima len ke unii yaa bui ute, bee una ke, ‘Maah ba ga tii si ni na, maan ki ŋmaa tii si. M di tii Uwumbɔr a,’ ");
INSERT INTO xon_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ki yaa kaa tii ute ni una nibaa kan, ni kii kina la. ");
INSERT INTO xon_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nimina ponn ni, ni yii Uwumbɔr aabɔr, le ki dii niyaajatiib aakaal, ki tuk binib ke bi mu li dii kina. Ni ŋani tiwan nimina mɔmɔk aabɔŋ pam.” ");
INSERT INTO xon_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","U nan ki yin kinipaak ngbaan, le ki bui bi, “Ni mɔmɔk li pel man, aan ki bee maah ga tuk nimi pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tiwan ni unii di ŋa umɔb ni u di nab na nibaa aan ŋmaa ŋa u titunwanbirdaan. Tiwan ni nyani umɔb ni na, nima le ŋani u titunwanbirdaan.  ");
INSERT INTO xon_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Le u siir kinipaak ngbaan chee, ki kun. Waah koo kidiik ni na, le waadidiliib baa u waayataŋakl ngbaan aatataa. ");
INSERT INTO xon_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Le u baa bi, “Ni mu aa kee bee maaliin aatataa aa? Naa nyi ke unii aah ji tiwan ni na aan ŋmaa ŋa u titunwanbirdaan aa? ");
INSERT INTO xon_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Waah ji ni na aa koo usui ni. Ni koo lipuul ni la, le u ti sɔnn.” Yesu aah len kina na, ni mɔk ke tijikaar tibaa aa kɔ. ");
INSERT INTO xon_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Le u nan ki tuk bi, “Tiwan ni nyan unii aamɔb ni na, nima le ŋani u titunwanbirdaan. ");
INSERT INTO xon_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tiwan ni nyani binib aasui ni na le ye ilandak i kaa ŋan na, ni kidagook aatuln, ni kinaayuk, ni linikul, ");
INSERT INTO xon_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ni iniman, ni mbiin, ni linyamɔngee, ni inimpoo, ni lipiipoln, ni ŋisiibil, ni kalmbaani, ni kijɔrk aatuln. ");
INSERT INTO xon_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tiwanbir nimina mɔmɔk nyan ni unii aasui ni la, le ki ŋani u titunwanbirdaan.” ");
INSERT INTO xon_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Le Yesu siir nima, ki buen Taya ni Saidonn aatingbaan ni, ki ti koo lidichal libaa ni, kaa gee ke unii ubaa li nyi ke u bi nima. U mu aa ŋmaa bɔr. ");
INSERT INTO xon_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Upii ubaa nan bi nima chee. Waa ye Juu yaab aanii ponn ni ubaa. Bi nan ma u Fonisia aatiŋ ni, Siria aatingbaan ni la. Le tiyayaar joo ubisal. Le upii ngbaan ŋun Yesu pu, ki dan nan gbaan unimbiin ni, ki gaŋ u ke u nyan tiyayaar ti joo waabo na. ");
INSERT INTO xon_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Le Yesu bui u, “Cha ti kpiin mbim waahr. Ti yaa di mbim aajikaar ki di tii ibɔ kan, naa ŋan.” ");
INSERT INTO xon_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Le u bui u, “Ndindaan, ni ye mbamɔn la; ibɔ mu tee dɔ teebul taab ki ji mbim aajikaabol ŋi lir kitiŋ na.” ");
INSERT INTO xon_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Le Yesu bui u, “Saah len mbamɔn pu na, nima le cha m nyan tiyayaar ngbaan saabo ni. Aa ga ŋmaa gir kun.” ");
INSERT INTO xon_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Le u gir kun linampal, ki ti kan ke tiyayaar ngbaan sil nyan waabo ni. U nan dɔ kidiik ni la. ");
INSERT INTO xon_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Le Yesu ki nyan Taya aatingbaan ni, ki di bɔn dii Saidonn aatiŋ ni, ki ti bɔn dii kitiŋ ki bi yin ki ke Ntim Kipiik na ni, ki ti fuu Galilee Aanyusakpem ni. ");
INSERT INTO xon_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Le binib bibaa joo ni ubir u chee. Utafal mu kpaa. Le bi gaŋ Yesu ke u di uŋaal paan u pu. ");
INSERT INTO xon_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Le Yesu di u nyan kinipaak ngbaan ponn ni, ki di buen n‑gbaan, ki ti di uŋanbim meeh utafakpaa ngbaan aatafal, ki tii timɔɔtan meeh utafakpaa ngbaan aalambil, ");
INSERT INTO xon_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","le ki waan lik paacham, ki fuur lii uponn ni, le ki bui u ke, “Efata.” Efata aatataa le ye ke “Kpaar.” ");
INSERT INTO xon_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Libuul ngbaan ni, le u ŋun. Ulambil mu lɔkr, le u piin ki bi len tibɔr mbamɔm. ");
INSERT INTO xon_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu nan bui bi ke bi taa tuk ubaa. U yaa bui bi ke bi taa tuk ubaa kan, le bi moo mooni ti. ");
INSERT INTO xon_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ni nan gar binib ki ti nyaŋ, le bi len ke, “Waah ŋani nimɔk na, ni ŋan. U cha bitafakpaab ŋun, ki cha bibirb mu len.” ");
INSERT INTO xon_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","N‑yoonn ngbaan le kinipaak ngbaan ki kuun ni Yesu chee. Baa nan kpa nibaa bi ji. Le u yin waadidiliib ke bi dan u chee, le ki bui bi ke, ");
INSERT INTO xon_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“M san kinipaak ngbaan kinimbaak la; bi bi m chee iwiin itaa, kaa kpa nibaa bi ji. ");
INSERT INTO xon_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Bibaa nyan ni dandar la. M yaa kaa tii bi tijikaar, ki bui bi ke bi li chaa kun kan, bi ga ti fik nsan ponn ni.” ");
INSERT INTO xon_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Le waadidiliib bui u, “Ti bi kipɔɔk ni la. Ti ga kan tijiir la chee aan ki di tii binib ngbaan mɔmɔk aan bi ji bab?” ");
INSERT INTO xon_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Le u baa bi, “Ni kpa ŋiboroboro kpin ŋiŋa?” Le bi bui u ke, “Ŋilole.” ");
INSERT INTO xon_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Le u bui kinipaak ngbaan, “Kaln kitiŋ man.” Le u yoor ŋiboroboro kpin ŋilole ngbaan, ki doon Uwumbɔr, ki gii gii, ki di tii waadidiliib ke bi yakr siin kinipaak ngbaan aanimbiin ni. Le bi yakr siin binimbiin ni. ");
INSERT INTO xon_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bi nan kpa njanbim siib mu. Le u yoor ijan ngbaan mu, ki doon Uwumbɔr, le ki bui bi ke bi di i mu ki di yakr siin binimbiin ni. ");
INSERT INTO xon_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Le bi mɔmɔk ŋman ki bab. ");
INSERT INTO xon_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bi ga nan li fuu ŋichur ŋinaa. Baah ŋman ki gur na, le waadidiliib peei ki gbiin tibɔɔkur tilole. Le u bui kinipaak ngbaan ke bi li chaa kun. ");
INSERT INTO xon_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Libuul ngbaan ni, le u ni waadidiliib koo buŋɔb ni, ki buen Dalmanuta aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Le Farisii yaab dan, ki nan kpak Yesu kinikpakpak. Bi nan ban bi tɔŋ u la, le ki bui u ke u tun lijinjiir aatuln Uwumbɔr aapɔɔn pu, aan bi kan. ");
INSERT INTO xon_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Le Yesu fuur lii uponn ni, ki baa bi, “Nimi dandana aanib, ba ŋa ni ban ke m tun lijinjiir aatuln aan ni kan? M tuk nimi mbamɔn la, maan tun lijinjiir aatuln aan ni kan.” ");
INSERT INTO xon_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Le u siir nima ki cha bi. Le u ni waadidiliib ki gir koo buŋɔb ngbaan ni ke bi puur nnyusakpem. ");
INSERT INTO xon_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waadidiliib nan suln kaa joo boroboro. Boroboro kpiln libaa baanja le nan bi baaŋɔb ni. ");
INSERT INTO xon_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Le u bui bi, “Ni li nyi man Farisii yaab, ni Ubɔr Herod aaboroboro aanyɔk.” ");
INSERT INTO xon_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Le bi bui tɔb, “Taah kaa joo boroboro na, nima le cha u len kina.” ");
INSERT INTO xon_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Le Yesu bee baah len tɔb chee pu na, le ki baa bi, “Ba ŋa ni len tɔb chee ke naa joo boroboro? Naa kee bee maabimbin aa? Naa bee maah len pu na aatataa aa? Nitafal pɔɔ la aa? ");
INSERT INTO xon_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ni kpa ŋinimbil, kaa waa aa? ki kpa ŋitafal, kaa ŋun aa? ");
INSERT INTO xon_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Maah nan di ŋiboroboro kpin ŋiŋmu ki gii yakr binib ŋichur ŋiŋmu na, ni nan peei ni gur na tibɔɔkur tiŋa? Naa teer la aa?” Le bi bui u, “Kipiik ni tilee.” ");
INSERT INTO xon_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Le u ki gir baa bi, “Maah nan di ŋiboroboro kpin ŋilole ki gii yakr tii binib ŋichur ŋinaa na, ni nan peei ni gur na tibɔɔkur tiŋa?” Le bi bui u, “Tilole.” ");
INSERT INTO xon_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Le u ki baa bi, “Naa kee nin bee maah len pu na aatataa aa?” ");
INSERT INTO xon_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Le bi fuu Betseda aatiŋ ni. Le binib bibaa joo ni ujoon Yesu chee, ki nan gaŋ u ke u di uŋaal meeh u. ");
INSERT INTO xon_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Le Yesu chuu uŋaal, ki dar u ki di nyan kitiŋ ngbaan ni, le ki ti tii timɔɔtan ŋa ujoon ngbaan aanimbil ni, ki di uŋaal paan u pu, ki baa u, “Aa waa aa?” ");
INSERT INTO xon_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Le u lik, le ki bui ke, “M waa binib chuun ki naahn isui la.” ");
INSERT INTO xon_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Le Yesu ki gir di uŋaal paan unimbil pu. Le u lik mbamɔm, ki pɔɔk, ki waa tiwan mɔmɔk chain. ");
INSERT INTO xon_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Le Yesu bui u ke u li tak nsan chaa kun. U taa bɔ dii kitiŋ ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ni waadidiliib nan siir nima ki di buen Siisarea Filipi aatingbaan ni. Baah cha na, le u baa bi, “Binib bui ke m ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Le bi bui u, “Bibaa len ke aa ye Jɔnn u nan muini binib nnyun ni na. Biken mu len ke aa ye Uwumbɔr aabɔnabr Elaija u nan bi n‑yaayoonn na la. Biken mu len ke aa ye n‑yaayoonn na aabɔnabtiib ponn ni ubaa la.” ");
INSERT INTO xon_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Le u ki baa bi, “Nima len ke m ye ŋma?” Le Piita bui u, “Aa ye Kristo u Uwumbɔr lee u na la.” ");
INSERT INTO xon_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Le Yesu sur bi ke bi taa tuk unii ubaa. ");
INSERT INTO xon_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Le u piin ki tuk waadidiliib ke, “Min Unibɔn Aabo ga ji falaa sakpen. Juu yaab aaninkpiib, ni Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb ga yii mi, ki ku mi. Iwiin itaa daal le m ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","U tuk bi tibɔr ngbaan chain la. Le Piita di u nyan n‑gbaan, ki ti sur u mbamɔm ke u taa len kina. ");
INSERT INTO xon_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Le Yesu fenn ki toŋ waadidiliib biken, le ki kae Piita, ki bui ke, “Kinimbɔŋ, siir foor m chee. Saa dak ke Uwumbɔr aah dak pu na. Aa dak ke binib aah dak pu na la.” ");
INSERT INTO xon_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Le Yesu yin kinipaak ngbaan ni waadidiliib, le ki bui bi, “Unii yaa ban u dii mi kan, cha u yii ubaa, ki yoor waadɔpuinkoo, aan ki li dii mi. ");
INSERT INTO xon_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Unii umɔk kaan ŋmaa kpo m pu na kan, waamɔfal ga bee yɔli la. Unii umɔk ga ŋmaa kpo m pu, ni tibɔnyaan tee pu na kan, u ga kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Unii yaa kan dulnyaa wee ni aawan mɔmɔk, ki lann waamɔfal kan, ba aanyoor le u kan? ");
INSERT INTO xon_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Unii tee ga di ba ki daa waamɔfal? ");
INSERT INTO xon_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dandana aanib ye titunwanbirdam la, kaa dii Uwumbɔr. Unii yaa san inimɔɔn m ni maabɔr chee ke u di tuk biken kan, min Unibɔn Aabo ga nan yii udaan ngbaan. M ga gir ni, ki li kpa Nte Uwumbɔr aapɔɔn. Uwumbɔr aatuuntiib bi ye chain na, mu ga dii mi. N‑yoonn ngbaan le m ga yii udaan ngbaan.” ");
INSERT INTO xon_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","U nan ki tuk bi, “M tuk nimi mbamɔn la, binib bi si do na ponn ni bibaa aan kpo see bi puen kan Uwumbɔr aanaan fuu ni ni mpɔɔn.” ");
INSERT INTO xon_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iwiin iloob nan jer, le Yesu di Piita, ni Jems, ni Jɔnn, ki jon lijool fɔfɔk paab, bibaa. Le uwon kpeln binimbil ni. ");
INSERT INTO xon_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Waawanpeenkaan nan kpaln tiwanpipiln, ki wiin chain. Ubaa aa bi dulnyaa wee ni, ki ga ŋmaa ŋa likekeln li li piin kina. ");
INSERT INTO xon_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Le bi kan n‑yaayoonn na aabɔnabtiib Elaija ni Moses bi len Yesu chee tibɔr. ");
INSERT INTO xon_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Le ijawaan chuu waadidiliib sakpen. Piita aa nan nyi waah ga len pu na, le ki bui Yesu ke, “Umɔmɔkr, taah bi do na, ni ŋan. Cha ti ŋa ŋiboo ŋitaa, ki di libaa tii si, ki di liken tii Moses, ki di liken tii Elaija.” ");
INSERT INTO xon_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Le ntaalangbam dan nan biin bi pu. Le nneel len ntaalangbam ngbaan ni ke, “Njapɔɔn u m gee u na sɔ. Li ŋun waah len pu na man.” ");
INSERT INTO xon_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Le bi fenn lik mala, kaa kan unii ubaa, see Yesu baanja. ");
INSERT INTO xon_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Le bi gir sunn ni lijool ngbaan taab. Baah bi sunni na, le Yesu bui bi, “Ni taa tuk ubaa naah kan pu na, ki nan saa buyoonn min Unibɔn Aabo ga fikr nkun ni na.” ");
INSERT INTO xon_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Le bi kii kina. Bi mu nan baa tɔb ke, “Waah len ke u ga fikr nkun ni na, naatataa ye kinye?” ");
INSERT INTO xon_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Le bi baa u, “Ba pu Uwumbɔr aakaal aamɔmɔkb len ke Elaija le ga puen dan, le Kristo nin fuu ni?” ");
INSERT INTO xon_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Le u bui bi, “Mbamɔn, see Elaija puen fuu ni ki nan toor tiwan mɔmɔk. Ni mu ŋmee Uwumbɔr Aagbaŋ ni ke min Unibɔn Aabo ga ji falaa sakpen. Binib mu ga yook mi. ");
INSERT INTO xon_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","M tuk nimi la, Elaija puun fuu ni a. Le binib ŋa u bakaa, baah gee pu na. Bi ŋa u naah ŋmee pu Uwumbɔr Aagbaŋ ni ke bi ga ŋa u pu na.” ");
INSERT INTO xon_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Le bi fuu waadidiliib biken aah bi nin chee na, ki kan kinipaak sakpeŋ si gob bi. Uwumbɔr aakaal aamɔmɔkb bibaa mu bi kpak bi kinikpakpak. ");
INSERT INTO xon_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Le kinipaak ngbaan kan Yesu. Baah kan u na, le ni gar bi mɔmɔk pam. Le bi san buen u chee, ki ti doon u. ");
INSERT INTO xon_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Le u baa waadidiliib, “Ni ni bi kpak ba pu?” ");
INSERT INTO xon_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Le kinipaak ngbaan ponn ni, uja ubaa bui u ke, “Umɔmɔkr, m joo ni maabo le aa chee. Libimbikl le joo u, ki ŋa u ubir. ");
INSERT INTO xon_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Li yaa ti chuu u nin chee na kan, li di u lii kitiŋ la. Le umɔb ponn ni puk tipupukr, le u ŋmɔ ŋinyin. Le uwon chaar ki pɔɔk. Le m gaŋ saadidiliib ke bi nyan libimbikl ngbaan. Bi mu aa ŋmaa nyan li.” ");
INSERT INTO xon_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Le Yesu bui bi, “Nimi dandana aanib, naa gaa Uwumbɔr ki kii. Ni ban ke m yunn ni chee kinye pu, aan ki li kpa limɔr ni pu, aan ni gaa Uwumbɔr ki kii. Li joo ni ubo ngbaan m chee.” ");
INSERT INTO xon_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Le bi joo ni u Yesu chee. Libimbikl ngbaan aah kan Yesu na, le li cha ubo ngbaan aawon gbaa sakpen. Le u lir kitiŋ, ki binni. Le umɔb puk tipupukr. ");
INSERT INTO xon_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Le Yesu baa ute ke, “Libimbikl ngbaan aah chuu saabo ngbaan na, ni yunn kinye?” Le ute bui u ke, “Li chuu u tibir ni la. ");
INSERT INTO xon_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Li lir u mmii ni, ni nnyun ni kpala kpala, ki ban li ku u. Aa yaa ga ŋman kan, san timi kinimbaak ki ter timi.” ");
INSERT INTO xon_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Le Yesu bui u ke, “Aa len ke m yaa ga ŋman kan. Nibaa aa pɔɔ unii u gaa mi ki kii na chee.” ");
INSERT INTO xon_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Libuul ngbaan ni le uja ngbaan teen ke, “M gaa si ki kii la. Ter mi aan m gaa si ki kii mbamɔm.” ");
INSERT INTO xon_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Le Yesu kan ke kinipaak ngbaan san choo, ki kuuni, ki goi bi. Le u kae libimbikl ngbaan, le ki bui li ke, “Libimbikl li ŋa u ubir ni utafakpaa na, m bui si la, nyan u ni, ki taa ki chuu u daalbaadaal.” ");
INSERT INTO xon_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Le libimbikl ngbaan teen, ki cha ubo ngbaan aawon gbaa sakpen, ki nyan u ni. Le u gur dɔ ki naahn linikpol. Bi ponn ni pam nan bui ke u kpo a. ");
INSERT INTO xon_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Le Yesu chuu uŋaal, ki fiin u. Le u fii sil. ");
INSERT INTO xon_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Le Yesu koo lidichal ni. Waah koo ni na, le waadidiliib nan dan u chee bibaa, ki nan baa u, “Ba pu taa ŋmaa nyan libimbikl ngbaan u ni?” ");
INSERT INTO xon_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Le u bui bi, “Naan ŋmaa nyan libimbikl limina aaboln, see ni mee Uwumbɔr ki lul bumɔb.” ");
INSERT INTO xon_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Le bi siir nima, ki bɔ dii Galilee aatingbaan ni. Waa ban ke ubaa li nyi waah bi nin chee na; u ban ke u ni waadidiliib li bi bibaa, aan u tuk bi tibɔr tibaa. ");
INSERT INTO xon_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","U bui bi ke, “Bi ga di min Unibɔn Aabo, ki di ŋa binib aaŋaal ni, le bi ku mi. Bi yaa ku mi kan, iwiin itaa daal le m ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waadidiliib aa nan bee waah len pu na aatataa, kaa kaa bi baa u. ");
INSERT INTO xon_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Baah chuun nsan ni na, le waadidiliib kpak tɔb ke, “Ti ponn ni, ulau tee ye uninyuun?” Le bi fuu Kapenaum aatiŋ ni, ki koo lidichal libaa ni. Baah bi kidiik ni na, le u baa bi, “Naah ba chuun nsan ni na, ni ba kpak ba pu?” Le bi si ŋmin. ");
INSERT INTO xon_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Le u kal, ki yin waadidiliib kipiik ni bilee ngbaan mɔmɔk, ki bui bi ke, “Unii yaa ban ke u li ye usaloln kan, u ŋa puwɔb yoo, ki li ye ni mɔmɔk aatutunn.” ");
INSERT INTO xon_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Le u di ubo siin bikaasisik ni, ki yoor u uŋaal ni, ki bui bi, ");
INSERT INTO xon_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Unii umɔk gaa ubo umina aaboln maayimbil pu na, u gaa mi le na. Unii umɔk gaa mi na, naa ye mi baanja le u gaa, u gaa Uwumbɔr u tun ni mi na la.” ");
INSERT INTO xon_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Le Jɔnn bui u ke, “Umɔmɔkr, ti kan unii ubaa nyan tiyayaar binib ponn ni saayimbil pu. U mu aa dii timi, nima le ti bui u ke u di cha.” ");
INSERT INTO xon_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Le Yesu bui bi, “Ni taa ki tuk u ke u di cha. Unii yaa tun lijinjiir aatuln maayimbil pu kan, waan ŋmaa len tibɔbir m pu mala. ");
INSERT INTO xon_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ba pu? unii u kaa ye timi aadin na si tichaŋ ni la. ");
INSERT INTO xon_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","M tuk nimi mbamɔn la, unii yaa tii nimi nnyunyunkoo kan, naah ye maanib pu na le cha u tii nimi, u ga sil kan tiyaapar.” ");
INSERT INTO xon_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Unii yaa tɔŋ mbim bi gaa mi ki kii na ponn ni ubaa ke u tun titunwanbir kan, tibɔbir ga li bi u pu. Bi yaa ba tee di kinaak sakpeŋ, ki di tul leen uneen ni, ki tur u lii nnyusakpem aabuul li nyoo na ni kan, ni ba soor ki tii u, ni u tɔŋ ubo ubaa. ");
INSERT INTO xon_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aa yaa gee tiwan ke saah gee aaŋaal pu na aan tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Aa yaa lann ŋŋaal mbaa, ki kan limɔfal li kaa kpa ndoon na kan, ni soor ni aa li kpa iŋaal ilee, ki koo mmii mu kaan junn na ni.  ");
INSERT INTO xon_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nima chee, ‘ŋikpaambil ŋi ŋmɔ biwon na aan kpo daalbaadaal, le mmii mu wu bi na mu aan junn.’ ");
INSERT INTO xon_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aa yaa gee tiwan ke saah gee aataal pu na aan tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Aa yaa lann litaal libaa, ki kan limɔfal li kaa kpa ndoon na kan, ni soor ni aa li kpa ŋitaa ŋilee, ki ti li bi mmii mu kaan junn na ni.  ");
INSERT INTO xon_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nima chee, ‘ŋikpaambil ŋi ŋmɔ biwon na aan kpo daalbaadaal, le mmii mu wu bi na mu aan junn’. ");
INSERT INTO xon_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aa yaa gee tiwan ke saah gee aanimbil pu na aan tiwan ngbaan yaa tɔŋ si ke aa tun titunwanbir kan, di ni lii. Aa yaa lann linimbil libaa ki koo Uwumbɔr do kan, ni soor ni aa li kpa ŋinimbil ŋilee, ki ti li bi mmii mu kaan junn na ni. ");
INSERT INTO xon_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nima chee, ‘ŋikpaambil ŋi ŋmɔ biwon na aan kpo daalbaadaal, le mmii mu wu bi na mu aan junn.’ ");
INSERT INTO xon_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mmii ga ŋa unii mɔmɔk chain ke n‑yaan aah ŋani kitork aanann chain pu na. ");
INSERT INTO xon_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","N‑yaan ŋan la. Tɔ, mu yaa bii ki yaa kaa ki mɔ kan, nibaa aa bi ki ga ki ŋmaa ŋa mu aan mu mɔɔk. Ni li bi ke n‑yaan aah mɔ pu na, ki li bi suuna tɔb chee man.” ");
INSERT INTO xon_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu nan siir nima, ki di buen Judea aapepel, le ki puur Jɔɔdann aamɔɔdapuul. Le kinipaak ki kuun ni u chee. Le u tuk bi Uwumbɔr aabɔr, waah ŋani pu n‑yoonn mɔmɔk na. ");
INSERT INTO xon_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Le Farisii yaab bibaa dan u chee, ki ban bi tɔŋ u, le ki baa u ke, “Uja yaa jenn upuu lii kan, timi aakaal kii kina aa?” ");
INSERT INTO xon_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Le u baa bi, “Moses nan len kinye?” ");
INSERT INTO xon_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Le bi bui ke, “Moses nan len ke uja yaa ban u jenn upuu kan, u ga ŋmaa ŋmee kigbaŋ pu ke u jenn u a, ki di tii u, le ki nin jenn u.” ");
INSERT INTO xon_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Le Yesu bui bi, “Nitafal aah pɔɔ pu na, nima le Moses nan ŋmee nkaal mue tii nimi. ");
INSERT INTO xon_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Uwumbɔr le aa len kina. Buyoonn u nan naan dulnyaa wee na, u nan naan uja ni upii. ");
INSERT INTO xon_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nima pu na, uja yaa yoor upii kan, bi ga nya cha bitetiib ni binatiib, ki kpaan tɔb chee, ");
INSERT INTO xon_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ki ŋa unibaan. Nima pu na, baa ki ye binib bilee, bi ye unibaan la. ");
INSERT INTO xon_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uwumbɔr aah di bi kpaan na, unibɔn taa yakr bi.” ");
INSERT INTO xon_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Le Yesu ni waadidiliib koo lidichal libaa ni. Baah bi kidiik ni na, le waadidiliib ki baa u tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Le u bui bi, “Uja umɔk jenn upuu lii, ki ki yoor upii uken na, uja ngbaan ye udagoor la. ");
INSERT INTO xon_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Upii mu yaa yii uchal, ki ki mɔn uja uken kan, upii ngbaan ye udagoor la.” ");
INSERT INTO xon_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","N‑yoonn ngbaan le binib bibaa joo ni mbim Yesu chee, ki ban ke u di uŋaal paan bi pu. Le waadidiliib kae bi. ");
INSERT INTO xon_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Waah kan ke bi kae bi na, le u gee liŋuul, ki bui waadidiliib ke, “Cha mbim ngbaan dan m chee man. Taa ki jenn bi man. Binib bi aabimbin bi ke mbim aah bi pu na, bima le yeh Uwumbɔr aanaan. ");
INSERT INTO xon_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","M tuk nimi mbamɔn la, unii umɔk kaa gaa Uwumbɔr aanaan ke ubo aah gaal tiwan pu na, waan koo mu ni.” ");
INSERT INTO xon_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Le u yoor mbim ngbaan ŋmam, ki di uŋaal paan bi pu, ki ŋa Uwumbɔr aanyoor ŋa bi pu. ");
INSERT INTO xon_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu aah nyan nima chee na, le uja ubaa san choo u chee, le ki nan gbaan unimbiin ni, ki baa u ke, “Umɔmɔkr nyaan, m ga ŋa kinye ki kan limɔfal li kaa kpa ndoon na?” ");
INSERT INTO xon_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Le Yesu baa u ke, “Ba pu aa yin mi ke Umɔmɔkr nyaan? Ubaa aa ŋan, see Uwumbɔr baanja. ");
INSERT INTO xon_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aa nyi Uwumbɔr aakaal: ‘Taa ku binib; taa gɔr kidagook; taa su kinaayuk; taa li ye nnyamɔn aaseeraadaan; taa ji binib pem pem; li pak aate ni aana.’” ");
INSERT INTO xon_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Le uja ngbaan bui u ke, “Umɔmɔkr, m joo ikaal imina mɔmɔk tibir ni la.” ");
INSERT INTO xon_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Le Yesu lik u, ki gee u, le ki bui u ke, “Tiwan nibaa le gur. Buen ti kooh saah kpa tiwan nimɔk na, ki di ŋimombil ngbaan tii bigiim, aan ki li kpa liwangol paacham, aan ki dan nan li dii mi.” ");
INSERT INTO xon_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesu aah len kina na, le uja ngbaan aanimbil wɔb ŋa gbilngbiln. Ni ŋa u mpombiin; ba pu? u kpa liwankpal sakpen a. Le u siir nima. ");
INSERT INTO xon_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Le Yesu fenn lik waadidiliib, ki bui bi ke, “Ni pɔɔ sakpen ke binib bi kpa liwankpal na koo Uwumbɔr aanaan ni.” ");
INSERT INTO xon_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Waah len kina na, le ni gar waadidiliib pam. Le u ki bui bi, “Maabim, ni pɔɔ sakpen ke binib bi tii liwankpal naadii na koo Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Uwankpadaan aah ga koo Uwumbɔr aanaan ni pu na, ni pɔɔ ki jer laakumii aah ga koo seerkaa aaboln ni pu na.” ");
INSERT INTO xon_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Le ni gar bi ki ti nyaŋ. Le bi baa tɔb ke, “Ni yaa ye kina kan, ŋma ga tee ŋmar?” ");
INSERT INTO xon_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Le Yesu lik bi, ki bui bi ke, “Ni pɔɔ binib le chee. Naa pɔɔ Uwumbɔr chee; nibaa aa pɔɔ Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Le Piita bui u ke, “Tima kan, ti nan di tiwan mɔmɔk di lii, ki dii si la.” ");
INSERT INTO xon_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Le Yesu bui bi, “M tuk nimi mbamɔn la, unii umɔk di cha waadichal, bee ukpetiib, bee unaatiib, bee uninkpatiib, bee una, bee ute, bee waabim, bee waasaak, m pu, ni tibɔnyaan tee pu na, ");
INSERT INTO xon_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u ga kan ŋidichal, ni kpetiib, ni naatiib, ni ninkpatiib, ni natiib, ni mbim, ni tisar, ni mɔmɔk nfum nkub dandana aayoonn. Binib mu ga ŋa u falaa, le n‑yoonn mu choo na, u ga nan kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tɔ, binib bi ye bisalolm na pam le ga nan ŋa puwɔb yaab. Binib bi ye puwɔb yaab na pam le ga nan ŋa bisalolm.” ");
INSERT INTO xon_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ni waadidiliib nan dii nsan ki cha Jerusalem. Le Yesu loln bi pu nsan. Le ni gar waadidiliib. Binib bi dii bi na mu san ijawaan. Le u di waadidiliib kipiik ni bilee na nyan n‑gbaan, ki tuk bi binib aah ga ŋa u pu na. ");
INSERT INTO xon_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","U nan bui bi, “Li pel man, ti yaa fuu Jerusalem kan, bi ga di min Unibɔn Aabo ki di ŋa Uwumbɔr aatotoorninkpiib ni Uwumbɔr aakaal aamɔmɔkb aaŋaal ni, le bi ji mi tibɔr, ki ga len ke ni ŋeer bi ku mi, ki ga di mi ŋa binib bi kaa ye Juu yaab na aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Le bi ga yook mi, ki teei timɔɔtan ŋa m pu, ki lue mi ŋinaalab, le ki nin ku mi. Iwiin itaa daal le m ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","N‑yoonn ngbaan le Sebedee aajapɔtiib Jems ni Jɔnn nan dan Yesu chee, ki nan bui u ke, “Umɔmɔkr, ti ban ke aa ŋa taah ga mee si pu na le ki tii timi.” ");
INSERT INTO xon_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Le u baa bi ke, “Ni ban ke m ŋa ba ki tii nimi?” ");
INSERT INTO xon_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Le bi bui u, “Aa yaa ji saanaan ki kan mpɔɔn kan, cha ti ponn ni ubaa li ka aaŋangii wɔb, uken mu li ka aaŋangan wɔb.” ");
INSERT INTO xon_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Le u bui bi ke, “Naa nyi naah mee mi pu na aatataa. Ni ga ŋmaa ji falaa ke maah ga ji falaa pu na aa?” ");
INSERT INTO xon_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Le bi bui u, “Ti ga ŋman.” Le u bui bi, “Ni ga sil ji falaa ke maah ga ji pu na. ");
INSERT INTO xon_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tɔ, binib bi ga kal ŋŋangii, ni ŋŋangan wɔb na ma kan, Uwumbɔr le ga lee bi; naa ye min le ga lee bi.” ");
INSERT INTO xon_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Le waadidiliib kipiik bi gur na ŋun Jems ni Jɔnn aah tuk u pu na. Baah ŋun kina na, le bi gee liŋuul bi pu. ");
INSERT INTO xon_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Le u yin bi mɔmɔk ke bi dan u chee, le ki nan bui bi, “Ni nyi ke dulnyaa wee ni aanib aayidam yoor bibaa paacham la. Binib bi kpa tininkpir na mu joo baanib mpɔɔn pu la. ");
INSERT INTO xon_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nima taa li bi kina man. Ni ponn ni ubaa yaa ban ke u li ye uninyuun kan, u ŋa ubaa ni mɔmɔk aatutunn. ");
INSERT INTO xon_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ubaa yaa ban ke u li ye usaloln kan, u ŋa ubaa ni mɔmɔk aanaagbiija. ");
INSERT INTO xon_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Min Unibɔn Aabo aa dan dulnyaa wee ni ke bi nan tun lituln tii mi. M dan ke m nan tun lituln tii binib, ki kpo ke m gaa binib pam lii.” ");
INSERT INTO xon_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Le Yesu ni waadidiliib fuu Jeriko aatiŋ ni, ki jer cha. Le kinipaak sakpeŋ dii bi. Baah cha na, le ujoon u ye uwanmeer na, ka nsan aamɔgbeln, bi yin u ke Batimeus, u ye Timeus aajapɔɔn na. ");
INSERT INTO xon_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Le u ŋun ke Yesu u ye Nasaref aatiŋ aanii na ban u jer. Le u tar ke, “Yesu, u ye Ubɔr David aayaabil na, san mi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Le binib pam kae u ke u ŋmin. Le u moo tar ke, “Ubɔr David aayaabil, san mi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Le Yesu sil nsan ni, ki bui bi, “Yin ni u.” Le bi yin u ke u dan, le ki bui u, “Li kpa mpopiin, ki fii sil. U yin si la.” ");
INSERT INTO xon_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Le u chuu peer waakekeln, ki fii mala, ki dan Yesu chee. ");
INSERT INTO xon_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Le Yesu baa u ke, “Aa ban ba?” Le u bui u ke, “Umɔmɔkr, m ban ke aa likr nnimbil le tii mi.” ");
INSERT INTO xon_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Le Yesu bui u ke, “Saah tii mi naadii na le cha aa likr. Li dii saasan.” Libuul ngbaan ni le unimbil likr, le u dii Yesu nsan ni nima. ");
INSERT INTO xon_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Le bi peen Jerusalem, ki fuu Befej ni Betani aatim, mu bi lijool li bi yin li ke Olif aasui aajool na paab. ");
INSERT INTO xon_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Baah ti fuu nima chee na, le u bui waadidiliib ponn ni bilee ke, “Li cha man naah si gbɔk kitiŋ ki na ni. Ni yaa koo ki ponn ni kan, libuul ngbaan ni, ni ga kan ubon u laa diin na si gbin. Ubaa aa kee diŋ u pu. Chuu gbiln u, ki li joo ni u m chee man. ");
INSERT INTO xon_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Unii ubaa yaa baa nimi, ‘Ba ŋa ni chuu gbiln u?’ kan, ni bui u, ‘Tidindaan le ban u. U ga giin ni u dandana wee.’” ");
INSERT INTO xon_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Le bi buen ki ti kan ubon u laa diin na gbin lipaal, mbisamɔb chee, ki mal nsan. Le bi chuu gbiln u. ");
INSERT INTO xon_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Le binib bi si nima chee na bibaa baa bi ke, “Ba ŋa ni chuu gbiln ubon ngbaan?” ");
INSERT INTO xon_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Le bi tuk bi Yesu aah tuk bi baah ga bui bi pu na. Le binib ngbaan cha bi buen. ");
INSERT INTO xon_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Le bi joo ni ubon ngbaan Yesu chee, ki di baakeken biin u pu. Le Yesu diŋ u pu. ");
INSERT INTO xon_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Le binib pam di baakeken ter nsan ponn ni. Bibaa mu koo timoor ni, ki bar tisufar ki di ter nsan ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Le binib bi loln nsan na, ni bi paan puwɔb na nan tar ke, “Hosiana, Uwumbɔr ŋa tinyoor ŋa unii u choo waayimbil ni na pu. ");
INSERT INTO xon_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uwumbɔr aanyoor bi tiyaaja David aanaan mu choo na pu. Hosiana bi paacham.” ");
INSERT INTO xon_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Le Yesu fuu Jerusalem, ki koo Uwumbɔr Aadichal ni, ki lik tiwan mɔmɔk. Le nwiin ban mu lir. Nima pu na, u nan nyan, le u ni waadidiliib buen Betani aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Naah woln kitaak na, le bi nyan Betani aatiŋ ni. Baah cha na, le nkon joo u. ");
INSERT INTO xon_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Le u kan likakaln li kpa tifar na si dandar. Le u buen u ti lik ke ŋisubil bi aan ŋaa bi. Waah ti fuu bu taab na, waa kan nibaa see tifar ŋmeen. Naa nan kee ŋeer ŋikakan lu. ");
INSERT INTO xon_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Le u bui busub ngbaan ke, “Ubaa aan ki kan lisubil libaa aa pu ki ŋmɔ n‑yoonn mu kaa kpa ndoon na.” Le waadidiliib ŋun waah len pu na. ");
INSERT INTO xon_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Le bi fuu Jerusalem. Le u koo Uwumbɔr Aadichal ni, ki jenn nyan binib bi kooh tiwan ki daa tiwan na li ponn ni, ki labr bilikpelm aateebul mam chiŋ, ki labr binib bi kooh ŋinanjel na mu aajal chiŋ. ");
INSERT INTO xon_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Waa nan kii ke unii ubaa ki li tu lituln ki dii Uwumbɔr Aadichal ponn ni jer. ");
INSERT INTO xon_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Le u bui bi ke, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr len ke, ‘Maadichal ga li ye mmeen aadichal, nin chee ŋinibol mɔmɔk mee mi na la;’ le nimi di li ŋa bififiirb aakakaa chee.” ");
INSERT INTO xon_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb ŋun Yesu aah ŋa pu na. Nima le bi kpokl baah ga ŋa pu ki ku u na. Bi nan san u ijawaan, ba pu? waah tuk kinipaak ngbaan Uwumbɔr aabɔr pu na, ni gar bi mɔmɔk pam. ");
INSERT INTO xon_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nwiin aah ban mu lir na, le Yesu ni waadidiliib ki nyan Jerusalem aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Naah woln kitaak kichakpinaanyeek ni, aan bi chuun nsan ni ki ti jer likakaln ngbaan aah bi nin chee na, le bi mui busub ngbaan kuur ki nan saa taab. ");
INSERT INTO xon_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Le Piita teer Yesu aah fe ŋa pu na, le ki bui u ke, “Umɔmɔkr, lik, saah fe puun lii busub bu pu na, bu kuur a.” ");
INSERT INTO xon_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Le Yesu bui bi, “Tii Uwumbɔr naadii man. ");
INSERT INTO xon_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","M tuk nimi mbamɔn la, unii umɔk ga bui lijool limina ke li fii ki ti lir nnyusakpem ni na, u yaa pak ke ni ga ŋa waah len pu na, ki yaa kaa joo beeni usui ni kan, ni ga ŋa kina ki tii u. ");
INSERT INTO xon_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","M tuk nimi la, naah ga mee Uwumbɔr tiwan nimɔk na, ni tii u naadii ke ni kan ni, le ni ga sil kan. ");
INSERT INTO xon_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ni yaa bi mee Uwumbɔr kan, di cha pinn binib bimɔk tun nimi taani na. Ni yaa di cha pinn bi kan, Nite Uwumbɔr u bi paacham na mu ga di cha pinn nimi aatunwanbir.  ");
INSERT INTO xon_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ni yaa kaa di cha pinn biken kan, Nite Uwumbɔr u bi paacham na mu aan di cha pinn nimi aatunwanbir.” ");
INSERT INTO xon_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Le bi ki fuu Jerusalem. Waah chuun Uwumbɔr Aadichal ni na, le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni Juu yaab aaninkpiib dan u chee, ");
INSERT INTO xon_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","le ki nan baa u ke, “Aa kpa nsan ke aa ŋa saah ŋani pu na aa? Ŋma tii si nsan ngbaan ke aa ŋa kina?” ");
INSERT INTO xon_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Le u bui bi, “M mu ga baa nimi mbaan. Ni yaa ŋmaa gar kan, m mu ga tuk nimi maah kpa nsan pu ki ŋa maah ŋani pu na. ");
INSERT INTO xon_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jɔnn aah nan muin binib nnyun ni na, ŋma nan tii u nsan? Uwumbɔr aan binib? Tuk mi man.” ");
INSERT INTO xon_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Le bi kpokl tɔb ke, “Ti yaa bui ke Uwumbɔr le tii u nsan kan, u ga baa timi ke ba ŋa taa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Taah san kinipaak ngbaan ijawaan pu na, taan ŋmaa len ke binib le tii u nsan, ba pu? bi mɔmɔk len ke Jɔnn nan ye Uwumbɔr aabɔnabamɔnn la.” ");
INSERT INTO xon_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nima le bi bui Yesu ke, “Taa nyi.” Le Yesu bui bi ke, “M mu aan tuk nimi maah kpa nsan pu ki ŋani maah ŋani pu na.” ");
INSERT INTO xon_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Le Yesu ki ŋakl bi ŋiyataŋak ke, “Uja ubaa le nan naan kisaak, le ki ŋum isui i lu ŋisubil na ki ponn ni, le ki di idɔ gob kisaak ngbaan, le ki gbii libuul li bi ga di ŋisubil ŋa li ponn ni aan ki muen nyan ŋaanyun na, le ki maa libimbifɔfɔŋ ke unii li ka li paab ki kiir kisaak ngbaan, le ki yin bikpaab bibaa, ki di kisaak ngbaan ŋa biŋaal ni ke bi li lik ki. Isui ngbaan yaa nan lun ŋisubil kan, bi ker tii u, aan ki ker bibaa mu. Waah ŋa kina na, le u siir ki buen kitiŋ ki daa na ni. ");
INSERT INTO xon_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Buyoonn ŋisubil ngbaan nan puir na, le u di unaagbiija tun bikpaab ngbaan chee, u ti gaa ni waasubil kisaak ngbaan ponn ni, ki li joo ni. ");
INSERT INTO xon_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Le bi ti chuu u, ki gbaa u, ki giin ni u, kaa tii u nibaa. ");
INSERT INTO xon_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Le usadaan ngbaan ki di unaagbiija uken tun bi chee. Le bi ti gbaa u mu aayil wɔb, ki yook u. ");
INSERT INTO xon_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Le usadaan na ki di unaagbiija uken tun bi chee. Le bi ti ku u. Le u ki di binaagbiib pam tun bi chee; le bi gbaa bibaa, ki ku bibaa mu. ");
INSERT INTO xon_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Unii ubaa le ti gur u chee. Ujapɔnbaal u, u gee u na le gur. Kookoo yaan le u di ujapɔɔn ngbaan tun bikpaab ngbaan chee, le ki bui ke, ‘Bi ga pak njapɔɔn ma.’ ");
INSERT INTO xon_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Le bikpaab ngbaan kpokl tɔb, ‘Uma le ye waafaajil. Cha ti ku u man, aan ki ji waafaal.’ ");
INSERT INTO xon_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Le bi chuu u, ki ku u, le ki di linikpol ngbaan nyan n‑gbaan. ");
INSERT INTO xon_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Tɔ, usadaan ngbaan ga ŋa kinye? U ga dan nan ku bikpaab ngbaan, ki di kisaak na tii bikpaab biken. ");
INSERT INTO xon_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Naa karn Uwumbɔr Aagbaŋ aah len pu na aa? ke, ‘Litakpal li bidimaab yii li na, lima le ye litakpajal. ");
INSERT INTO xon_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uwumbɔr le ŋa kina, le ni gar timi pam.’” ");
INSERT INTO xon_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Le Juu yaab aaninkpiib bee ke Yesu di liyataŋakl ngbaan ŋaŋ bima la. Nima pu le bi nan ban bi chuu u, ki mu san kinipaak ngbaan ijawaan, ki di cha u, ki siir. ");
INSERT INTO xon_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Le bi di Farisii yaab bibaa, ni Ubɔr Herod aanib bibaa tun Yesu chee bi ti pen u nlan. ");
INSERT INTO xon_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baah fuu ni u chee na, le bi bui u ke, “Umɔmɔkr, ti bee ke aa len mbamɔn la, kaa san ubaa ijawaan, kaa pak ubaa ki jer uken. Aa mɔk timi Uwumbɔr aasan mbamɔm la. Ni ŋan ti pa lampoo tii Ubɔrkpaan Siisa aan naa ŋan? Ti pa aan ti taa pa?” ");
INSERT INTO xon_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Le u bee ke bi ban bi pen u nlan la, le ki baa bi, “Ba ŋa ni tɔŋ mi? Li joo ni limombil m lik man.” ");
INSERT INTO xon_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Le bi joo ni li. Le u baa bi, “Ŋma aanaŋ ni liyimbil bi li pu?” Le bi bui u ke, “Siisa yaan.” ");
INSERT INTO xon_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Le u bui bi ke, “Di ni ye Siisa yaan na, ki di tii u man, ki di ni ye Uwumbɔr yaan na tii Uwumbɔr.” Waah len kina na, le ni gar bi pam. ");
INSERT INTO xon_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Le Sajusii yaab bibaa dan u chee. Bima le len ke binib aan fikr nkun ni na. ");
INSERT INTO xon_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Le bi bui u ke, “Umɔmɔkr, Moses nan ŋmee nkaal ki di tii timi ke, ‘Uja yaa kpo, ki cha upuu, kaa kpa ubo kan, unaal di ukpopii ngbaan kpan, ki ma mbim ki tii ukpel.’ ");
INSERT INTO xon_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tɔ, naabitiib bilole nan bi. Upol nan yoor upii, le ki kpo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Le unaal di ukpopii ngbaan kpan, ki mu kpo, kaa kpa ubo. Le utatar mu di ukpopii ngbaan kpan ki mu kpo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bijab ngbaan mɔmɔk bilole mu ŋa kina, ki kpo doo, kaa nan kpa ubo. Kookoo yoo le upii ngbaan mu kpo. ");
INSERT INTO xon_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Binib yaa nan fikr nkun ni kan, upii ngbaan ga li ye ŋma aapuu? Bi mɔmɔk bilole nan joo u la.” ");
INSERT INTO xon_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Le Yesu bui bi, “Naa bee Uwumbɔr Aagbaŋ aah len pu na, kaa bee Uwumbɔr aah kpa mpɔɔn pu na. Nima le cha ni yenn nimi aaliin ni. ");
INSERT INTO xon_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Binib yaa nan fikr nkun ni kan, baan yoor bipiib, bipiib mu aan mɔn bijab. Bi ga li bi ke Uwumbɔr aatuuntiib bi bi paacham na aah bi pu na la. ");
INSERT INTO xon_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Joo cha binib aah ga fikr nkun ni pu na aabɔr, naa karn Moses aah nan ŋmee busub bu nan gaal mmii na aabɔr nin chee na aa? Nima chee le ni ŋmee ke Uwumbɔr nan bui Moses, ‘Min le ye Abraham, ni Aisak, ni Jakob Aawumbɔr.’ ");
INSERT INTO xon_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uwumbɔr yaa len ke u ye binib bi kpo na Aawumbɔr kan, nima le mɔk ke bi kpa limɔfal. Nimi, naah len ke binib aan fikr nkun ni na, ni yenn sakpen a.” ");
INSERT INTO xon_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Le Uwumbɔr aakaal aamɔmɔkb ponn ni ubaa nan bi nima, le ki ŋun baah gbaa tɔb chee tibɔr pu na, ki bee ke Yesu aah len pu na, u gar bi mbamɔm la. Le u dan Yesu chee, ki nan baa u ke, “Mulakaal ye nkaal kpaan?” ");
INSERT INTO xon_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Le Yesu bui u ke, “Nkaal kpaan le ye ke, ‘Israel yaab, li ŋun man, Tidindaan Uwumbɔr ye Dindaan baan la. ");
INSERT INTO xon_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Aa li gee Aadindaan Uwumbɔr aasui mɔmɔk ni, ni saawiin mɔmɔk, ni saalandak mɔmɔk, ni saapɔɔn mɔmɔk.’ ");
INSERT INTO xon_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nkaal mu paa na le ye ke, ‘Aa li gee aana aabo ke saah gee aabaa pu na.’ Nkaal mubaa aa jer ikaal ilee yee.” ");
INSERT INTO xon_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Le u bui Yesu ke, “Umɔmɔkr, aa len mbamɔn la. Saah bui ke Uwumbɔr ye Uwumbɔr baan na, ti gbii la. Ubaa aa bi ki kpee u pu. ");
INSERT INTO xon_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Unii yaa gee Uwumbɔr usui mɔmɔk ni, ni waalandak mɔmɔk, ni waapɔɔn mɔmɔk, ki gee una aabo ke waah gee ubaa pu na kan, nima le ŋan ki jer u di tiwakor toor kitork ki see mmii ni tii Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Le Yesu bee ke u len nlan aabɔr la. Le u bui u, “Saa daa Uwumbɔr aanaan ni.” Baah len tibɔr ngbaan doo na, ubaa aa ki kaa u baa Yesu mbaan kpee. ");
INSERT INTO xon_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu nan bi Uwumbɔr Aadichal ni, ki tuk binib Uwumbɔr aabɔr, ki baa bi, “Uwumbɔr aakaal aamɔmɔkb ŋa kinye pu ki bui ke Kristo u ga gaa binib lii na ga li ye Ubɔr David aayaabil? ");
INSERT INTO xon_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Uwumbɔr Aafuur Nyaan nan cha Ubɔr David ubaa len ke, ‘Uwumbɔr bui Ndindaan ke: Kal ŋŋangii wɔb ki ti saa buyoonn m ga nyaŋ saadim mɔmɔk na.’ ");
INSERT INTO xon_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ubɔr David ubaa aah nan yin Kristo ngbaan ke Udindaan kina na, Kristo ga li ŋmaa ye uyaabil aa?” Le kinipaak ngbaan pel Yesu aah len pu na, ki nan kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Waah tuk bi Uwumbɔr aabɔr na, le u bui bi, “Ni li nyi man Uwumbɔr aakaal aamɔmɔkb aabɔr. Baageehn le ye ke bi li pee ŋibɔkul fɔfɔk, ki gee ke binib doon bi mbamɔm kinyaŋ ni, ");
INSERT INTO xon_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ki ban ke bi kal bininyuum aakakaa chee mmeen aadir ni, ni njim chee. ");
INSERT INTO xon_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bi ji bikpopiib durm la, le ki mee Uwumbɔr ni yunni ke bi ŋmann ke bi ye bininyaam la. Uwumbɔr ga daa bitafal ki jer waah ga daa binib biken aatafal pu na.” ");
INSERT INTO xon_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu nan ka mal Uwumbɔr aapiin aadakaa, ki lik kinipaak ngbaan aah joo ŋimombil ŋani dakaa ngbaan ponn ni pu na. Le biwankpadam pam nan di ŋimombil pam ŋa u ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Le ukpopiigiin ubaa mu dan nan di janjan mam bilee, ni ye kpakpaln na, ki di ŋa u ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Le Yesu yin waadidiliib, ki bui bi, “M tuk nimi mbamɔn la, ukpopiigiin wee tii ŋimombil ki jer bi mɔmɔk aah tii pu na. ");
INSERT INTO xon_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bi mɔmɔk tii, ki gur ŋimombil sakpen a. U ye ugiin la, le ki di waamombil mɔmɔk tii, kaa ki gur nibaa.” ");
INSERT INTO xon_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu nan nyan Uwumbɔr Aadichal ngbaan ni. Waah nyan ni na le waadidiliib ponn ni ubaa bui u ke, “Umɔmɔkr, lik ŋitakpal ŋi bi di maa lidichal lee na aah ŋan pu na, lik tidir tee aah wiir pu na.” ");
INSERT INTO xon_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Le Yesu bui u, “Aa kan tidir sakpiin tee ee? Bi ga nan gbaa wii lidichal limina mɔmɔk. Litakpal libaa aan ki li paa liken pu.” ");
INSERT INTO xon_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Le u buen ki ti kal Olif aasui aajool li bi tok Uwumbɔr Aadichal na paab. Le Piita, ni Jems, ni Jɔnn, ni Andru dan u chee bibaa, ki nan bui u ke, ");
INSERT INTO xon_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuk timi, bi ga ŋa kina bayoonn? Ba ga li ye limɔkl ki mɔk timi ke ni ŋeer bi ŋa kina?” ");
INSERT INTO xon_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Le u bui bi ke, “Ni li nyi man, ubaa taa ŋmann nimi. ");
INSERT INTO xon_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Binib pam le ga nan dan, ki pur maayimbil, ke bima le ye min Yesu, ki ŋmann binib pam. ");
INSERT INTO xon_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ni ga ŋun ke binib to butɔb kɔnkɔni do, ni dandar mu. Ni taa cha ni li muk nimi man. Uwumbɔr le siin ke nimina mɔmɔk ga ŋa. Nima le aan mɔk ke dulnyaa wee ga doo libuul ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Linibol libaa ga to linibol liken butɔb. Nnaan mubaa aanib ni nnaan muken aanib ga to tɔb butɔb. Kitiŋ ga deŋ ŋipepel, ŋipepel. Nkon ga lir ntim pam ponn ni. Nimina mɔmɔk le ga li ye njan aafalaa. ");
INSERT INTO xon_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nimi nibaa, li nyi man. Bi ga nan chuu nimi, ki di buen bibɔjirb chee. Bi ga gbaa nimi mmeen aadir ni. M pu, le ntim aaninkpiib ni bibɔrb ga ji nimi tibɔr. Le ni ga tuk bi tibɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Binib ga di tibɔnyaan tee tuk ŋinibol mɔmɔk waahr, aan dulnyaa wee nin doo. ");
INSERT INTO xon_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bi yaa chuu nimi, ki di buen bibɔjirb chee kan, ni taa puen dak nisui ni ke ni ga len kinye. N‑yoonn ngbaan yaa nan fuu ni kan, ni len Uwumbɔr aah ga tuk nimi pu na. Naa ye nimi le ga len. Uwumbɔr Aafuur Nyaan le ga len. ");
INSERT INTO xon_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","N‑yoonn ngbaan le unii ga di una aabo ŋa binib aaŋaal ni ke bi ti ku u. Tetiib mu ga di baabim ŋa binib aaŋaal ni ke bi ti ku bi. Binib mu ga yii bitetiib ni binatiib, ki cha binib ku bi. ");
INSERT INTO xon_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","M pu, le binib mɔmɔk ga li nan nimi. Unii umɔk jin limɔr ki dii mi ki ti saa limɔfal aadoon na, uma le ga ŋmar.” ");
INSERT INTO xon_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ni ga kan tiwanbir ni bii tiwan nimɔk bi chain na si naah kaa ba ga li si nin chee na.” (Tɔ, nimi bi karni na, ni li beer nimina aatataa.) “N‑yoonn ngbaan yaa nan fuu ni kan, binib bi bi Judea aatiŋ ponn ni na san buen ŋijoo paab. ");
INSERT INTO xon_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Unii yaa bi kidiik paab kan, u taa ki koo waadiik ni ke u ti yoor nibaa, u san mala. ");
INSERT INTO xon_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Unii yaa bi kisaak kan, u taa ki gir kun linampal ke u ti yoor waakekeln. ");
INSERT INTO xon_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","N‑yoonn ngbaan kan, bipiib bi kpa ŋipuu na, ni bipiib bi kpa mbim bi laa ŋaa libiil na ga li kpa kinimbaak. ");
INSERT INTO xon_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mee Uwumbɔr man ke u taa cha tibɔr tee ŋa kakab aayoonn. ");
INSERT INTO xon_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","N‑yoonn ngbaan, binib ga ji falaa sakpen a. Buyoonn Uwumbɔr nan naan dulnyaa na, ki nan saa dandana wee na, baa kee jin falaa ngbaan aaboln, ki mu aan ki ji falaa kina. ");
INSERT INTO xon_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Uwumbɔr yaa kaa bar falaa ngbaan aayoonn aawiin pu kan, ubaa aan ŋmar. Le waanigeekaab aanimbaasaln pu na, u ga bar falaa ngbaan aayoonn aawiin pu. ");
INSERT INTO xon_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“N‑yoonn ngbaan unii ubaa yaa bui nimi ke, ‘Lik, Kristo u ga gaa binib lii na sɔ,’ ki yaa ki bui ke, ‘U bi nima chee’ kan, ni taa gaa waah len pu na man. ");
INSERT INTO xon_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ba pu? biŋmaŋmannim ga li bi. Bibaa ga bui ke bi ye Kristo la. Biken ga bui ke bi ye Uwumbɔr aabɔnabtiib la. Bi ga tun lijinjiir aatun ki ŋmann binib; bi ga pɔɔn bibaa ke bi ŋmann Uwumbɔr aanib mu. ");
INSERT INTO xon_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ni li nyi man. M puun tuk nimi tibɔr timina mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","“N‑yoonn ngbaan aafalaa aapuwɔb, le paacham aawan aan ki li bi mbamɔm. Nwiin ga bɔln. Uŋmal mu aan ki li wiin. Iŋmabi mu ga lir. ");
INSERT INTO xon_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","N‑yoonn ngbaan le ni ga kan min Unibɔn Aabo bi ntaalangbam ni ki choo, ki wiin chain, ki joo mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","N‑yoonn ngbaan le m ga tun Uwumbɔr aatuuntiib dulnyaa wee ponn ni mɔmɔk, liwipuul, ni liwilir, ni ŋŋangan, ni ŋŋangii wɔb, bi ti kuuni maanib mɔmɔk, ki di dan m chee.” ");
INSERT INTO xon_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Bukpasɔm le ye liyataŋakl ki tii nimi. Bu aabon yaa bi ŋani tifar kan, ni bee ke ni yaa kpee siib na kan, kiseek ga seer. ");
INSERT INTO xon_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kina na, ni yaa kan nimina bi ŋani kan, ni bee ke ni yaa kpee siib na kan, m ga gir ni. ");
INSERT INTO xon_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","M tuk nimi mbamɔn la, dandana aanib aan jer le tiwan nimina mɔmɔk puen ŋa. ");
INSERT INTO xon_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Paacham ni taab ga jer. Maamɔbon ma aan jer.” ");
INSERT INTO xon_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ubaa aa nyi buyoonn m ga gir ni na. Uwumbɔr aatuuntiib bi bi paacham na aa nyi. Min Uwumbɔr Aajapɔɔn mu aa nyi. Nte Uwumbɔr baanja le nyi. ");
INSERT INTO xon_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ni li nyi man, ki li ka lik man, aan ki li mee Uwumbɔr; ba pu? naa nyi buyoonn m ga gir ni na. ");
INSERT INTO xon_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni naahn uja u nan ban u chuun nsan, ki tuk waatutum ke bi li joo waadichal mbamɔm, ki mɔk bi mɔmɔk baah ga tun lituln li na, ki tuk ukikiir na ke u li kii, le ki nin buen. ");
INSERT INTO xon_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ni mu li nyi man. Naa nyi bundaln min Nidindaan ga gir ni na, nibaakan kijoobɔŋ, nibaakan kinyetaasiik, nibaakan ikooja aah wii buyoonn na, nibaakan lichakpitaawoln. ");
INSERT INTO xon_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ni li nyi man, aan m yaa lir nimi ki fuu ni kan, maan nan muin ni dɔ geen. ");
INSERT INTO xon_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Maah tuk nimi pu na, m tuk binib mɔmɔk la, li nyi man.” ");
INSERT INTO xon_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","N‑yoonn ngbaan, ni nan gur iwiin ilee, bi kuun ki ti ji njim mu bi yin mu ke Lakr‑jer aajim na. N‑yoonn ngbaan, le bi ŋmɔ boroboro u kaa kpa nnyɔk na. Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb nan kal ki kpokl baah ga ŋa pu ki loon chuu Yesu ki ku u na, ");
INSERT INTO xon_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","le ki bui tɔb ke, “Ti taa chuu u njim ngbaan aayoonn man. Ti yaa chuu u n‑yoonn ngbaan kan, kinipaak na ga ŋmɔ tijar.” ");
INSERT INTO xon_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tɔ, Yesu nan bi Betani aatiŋ ni, ki bi Simonn u nan ye ukɔndaan na do, ki ka ji tijikaar. Waah ka ji tijikaar kina na, le upii ubaa koo ni ki joo ni tulalee u kpa kidaak sakpen na, bi yin mu ke naad, ki bi kpalba nyaan u bi yin u ke alabasta na ponn ni. Upii ngbaan nan chuu gii kpalba ngbaan aaneen ni, ki di tulalee na mɔmɔk kpir Yesu aayil pu. ");
INSERT INTO xon_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waah ŋa kina na, le bi ponn ni bibaa gee liŋuul, ki baa tɔb ke, “Ba ŋa u bii tulalee ngbaan kina? ");
INSERT INTO xon_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ti ba ga ŋmaa di u kooh ki kan ilik ni jer iwiin ikui itaa aapal na, ki di tii bigiim.” Le bi ŋulni u pu. ");
INSERT INTO xon_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Le Yesu bui bi, “Di cha u man. Ba ŋa ni muk u kina? U tun lituln li ŋan na le ki tii mi. ");
INSERT INTO xon_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bigiim ga li bi ni chee n‑yoonn mɔmɔk. Naah ga li ban ni ter bi buyoonn na kan, ni ga ŋmaa ter bi. Mma aan li bi ni chee n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","U ŋa waah ga ŋmaa ŋa pu na la. U di tulalee ngbaan kpir m pu ki puen toor nwon ke bi ti sub mi la. ");
INSERT INTO xon_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","M tuk nimi mbamɔn la, baah ga moon tibɔnyaan tee nin chee itingbaan mɔmɔk ni na, bi ga len waah ŋa pu na ke binib li teer waabɔr.” ");
INSERT INTO xon_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Le Yesu aadidiliib kipiik ni bilee ponn ni ubaa, bi yin u ke Judas Iskariot, buen Uwumbɔr aatotoorninkpiib chee, ki ti tuk bi ke u ban u di Yesu ŋa biŋaal ni la. ");
INSERT INTO xon_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Baah ŋun kina na, le ni ŋa bi mpopiin. Le bi puu tipuur ke bi ga tii u ŋimombil. Le u ban nsan mu u ga di Yesu ŋa biŋaal ni na. ");
INSERT INTO xon_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lakr‑jer aajim, buyoonn bi ga ŋmɔ boroboro u kaa kpa nnyɔk na aajan aawiindaal, bundaln bi ga kɔr upihbo na, le Yesu aadidiliib dan nan baa u ke, “Aa ban ke ti gor njim ngbaan aajikaar la chee ki tii si?” ");
INSERT INTO xon_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Le u bui waadidiliib ponn ni bilee ke, “Ni li cha kitiŋ ngbaan ponn ni man. Ni yaa koo ki ponn ni kan, uja u tu nnyun na ga ton nimi nsan ponn ni. ");
INSERT INTO xon_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ni li dii u man, ki ti koo waah ga koo lidichal li ponn ni na, ki bui udichadaan ngbaan, ‘Umɔmɔkr bui ke u ni waadidiliib ga ji njim ngbaan aajikaar kiladiik ni?’ ");
INSERT INTO xon_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Le u ga mɔk nimi paacham aadisakpeŋ ki bi puun toor ki na. Ni gor njim ngbaan aajikaar nima chee ki tii timi.” ");
INSERT INTO xon_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Le bi siir, ki buen kitiŋ ngbaan ni, ki ti kan Yesu aah tuk bi ke bi ga kan pu na. Le bi gor njim ngbaan aajikaar. ");
INSERT INTO xon_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kijook aah joor na, le Yesu ni waadidiliib kipiik ni bilee na koo kidiik ngbaan ponn ni, ki kal ke bi ji. ");
INSERT INTO xon_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Baah bi ji na, le u bui bi, “M tuk nimi mbamɔn la, ni ponn ni ubaa ga kooh mi. Nimi bi bi ji m chee na ponn ni ubaa le ga ŋa kina.” ");
INSERT INTO xon_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bisui nan bii. Le bi baa u ubaabaa ubaabaa, “Ni ye min la aa?” ");
INSERT INTO xon_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Le u bui bi, “Nimi kipiik ni bilee bimina ponn ni ubaa le ga ŋa kina. Ni ye m ni unii u kpaan bi ji lisambil libaa ponn ni na la. ");
INSERT INTO xon_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Min Unibɔn Aabo ga kpo ke naah ŋmee Uwumbɔr Aagbaŋ ponn ni ke m ga kpo pu na. Tibɔbir mu ga li bi uja u ga kooh mi na pu. Bi yaa kaa ba ma u kan, ni ba soor ki tii u.” ");
INSERT INTO xon_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baah bi ji tijikaar na, le Yesu yoor boroboro, le ki doon Uwumbɔr, ki gii, ki di tii waadidiliib, le ki bui ke, “Gaa man. Maawon le na.” ");
INSERT INTO xon_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Le u yoor kiyinyook, ki doon Uwumbɔr, ki di tii bi. Le bi mɔmɔk nyun. ");
INSERT INTO xon_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Le u bui bi, “Maasin le na. Maasin pu, le Uwumbɔr puu tipuupɔln tii nimi. Binib pam aatunwanbir pu le maasin ngbaan ga nya. ");
INSERT INTO xon_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","M tuk nimi mbamɔn la, maan ki nyu ŋisubil aanyun ngbaan ki ti saa bundaln m ga ti nyu ŋisubil aanyunpɔm Uwumbɔr aanaan ni na.” ");
INSERT INTO xon_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Le bi gaa Uwumbɔr aalahn, ki buen Olif aasui aajool paab. ");
INSERT INTO xon_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Le Yesu ti bui bi, “Ni mɔmɔk ga san cha mi. Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Uwumbɔr ga ku upihdaan, le ipiih yaa.’ ");
INSERT INTO xon_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Buyoonn Uwumbɔr ga fikr mi nkun ni na, le m ga loln ni pu nsan, ki buen Galilee.” ");
INSERT INTO xon_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Le Piita bui u, “Bi mɔmɔk yaa san ki cha si kan, mma aan san cha si.” ");
INSERT INTO xon_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Le Yesu bui u, “M tuk si mbamɔn la, kinyeek kimina, aa ga len nfum mutaa ke saa nyi mi le lelee aakooja nin wii.” ");
INSERT INTO xon_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Le Piita po beenin len ke, “Bi yaa po ban bi ku m ni si kan, maan len ke maa nyi si.” Le waadidiliib mɔmɔk mu len kina. ");
INSERT INTO xon_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Le bi ti fuu nibaa chee, bi yin nima chee ke Getsemane. Le u bui waadidiliib, “Kal do man, m buen ti mee Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Le u di Piita, ni Jems, ni Jɔnn buen. Le usui bii pam. Mpombiin ni nsuugar nan muk u sakpen. ");
INSERT INTO xon_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Le u bui bi, “Nsui bii sakpen, ki ti nyaŋ. Ni wu ke nkun aah wu pu na. Kal do ki li lik man.” ");
INSERT INTO xon_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Le u foor siib, ki doon kitiŋ lichichikr, ki mee Uwumbɔr ke ni yaa ga ŋmaa ŋa aan u taa ji falaa u choo na kan, u taa cha u ji falaa ngbaan, ");
INSERT INTO xon_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ki bui ke, “Nte, aa ga ŋmaa ŋa tiwan mɔmɔk. Nyan mi falaa u choo na ni. Aa mu tee ŋa saageehn, ki taa ŋa maageehn.” ");
INSERT INTO xon_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Le u gir buen waadidiliib bitaa ngbaan chee, ki ti muin bi dɔ geen; le u bui Simonn Piita ke, “Simonn, aa dɔ geen la aa? Saa ŋmaa li ka lik kikurk kibaa aa? ");
INSERT INTO xon_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ni li ka lik man, aan ki li mee Uwumbɔr, aan ki taa koo ntɔŋ ni. Nisui ban ni li lik, le tiwon aa pɔɔ.” ");
INSERT INTO xon_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Le u ki foor siib ki ti mee Uwumbɔr, ki ki bui u tibɔr tichachaan ngbaan, ");
INSERT INTO xon_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","le ki ki gir buen waadidiliib chee, ki ti muin bi ki dɔ geen la; ngeen nan joo bi sakpen. Le baa nyi baah ga len pu na. ");
INSERT INTO xon_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Le u ki buen ti mee Uwumbɔr, ki ki gir ni taataa, ki ki muin bi dɔ geen; le u baa bi, “Ni beenin fuur ki dɔ geen la aa? Ni ŋeer a. N‑yoonn fuu a. U kooh min Unibɔn Aabo, ki di ŋa titunwanbirdam aaŋaal ni la. ");
INSERT INTO xon_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fii, ti li cha man. Lik, unii u kooh mi na peen ni a.” ");
INSERT INTO xon_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waah laa bi len kina na, le Judas u ye waadidiliib kipiik ni bilee ponn ni ubaa na fuu ni. Le kinipaak dii u. Bi nan joo kijaak aajum ni jagbaali mam. Bi nan nyan ni Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni Juu yaab aaninkpiib chee la. ");
INSERT INTO xon_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas u kooh Yesu na, nan bui kinipaak ngbaan ke bi yaa ti kan u moor unii u aatakpiln na kan, uma le na. Bi chuu u mpɔɔn, ki di u buen. ");
INSERT INTO xon_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas aah fuu ni na, le u kpaan buen Yesu chee, ki ti bui ke, “Umɔmɔkr,” le ki moor utakpiln. ");
INSERT INTO xon_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Le bi chuu Yesu mpɔɔn pu. ");
INSERT INTO xon_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Waadidiliib ponn ni ubaa nan yoor waajaak aajuk ki gaa per Uwumbɔr aatotoorninkpel aanaagbiija aatafal. ");
INSERT INTO xon_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Le Yesu baa binib bi dan bi nan chuu u na ke, “Ni joo kijaak aajum ni jagbaali mam ke ni nan chuu mi ke maah ye ufifiir le na aa? ");
INSERT INTO xon_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iwiin mɔmɔk m nan bi ni chee Uwumbɔr Aadichal ni, ki tuk binib Uwumbɔr aabɔr, le naa chuu mi. Tɔ, nimina ŋa ke ni gbiin Uwumbɔr Aagbaŋ aah len pu na la.” ");
INSERT INTO xon_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Le waadidiliib mɔmɔk san cha u. ");
INSERT INTO xon_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Unachipɔɔn ubaa nan bi nima chee, ki pee likekepiln, ki paani Yesu pu. Le bi laan chuu unachipɔɔn ngbaan aakekeln. ");
INSERT INTO xon_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Le u san cha waakekeln, ki san cha uŋmeen. ");
INSERT INTO xon_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Le bi di Yesu buen Uwumbɔr aatotoorninkpel aadichal ni. Uwumbɔr aatotoorninkpiib, ni Juu yaab aaninkpiib, ni Uwumbɔr aakaal aamɔmɔkb mu kuun ni nima chee. ");
INSERT INTO xon_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Le Piita paa Yesu pu, ki bi dandar, le ki ti fuu Uwumbɔr aatotoorninkpel aachiln ni, ki koo, ki ti kal bikikiirb chee wol mmii. ");
INSERT INTO xon_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Le Uwumbɔr aatotoorninkpiib ni bibɔjirb aaninkpiib mɔmɔk ban biseeraadam bi ga bii Yesu aan bi ku u na. ");
INSERT INTO xon_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Le biseeraadam pam mɔln inyamɔn paan u, ki bii u. Baah len pu na, naa kpaan. Nima pu na, baa kan waataani. ");
INSERT INTO xon_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Le bijab bibaa fii sil, ki mɔln inyamɔn paan u, le ki bui ke, ");
INSERT INTO xon_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ti ŋun u len ke u ga gbaa wii Uwumbɔr Aadichal li binib maa li na, ki ki maa liken li binib aa maa li na, iwiin itaa.” ");
INSERT INTO xon_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Le bijab bimina mu aah len pu na, naa kpaan. ");
INSERT INTO xon_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Le Uwumbɔr aatotoorninkpel ngbaan fii sil bi mɔmɔk aanimbiin ni, le ki baa Yesu, “Saan len tibaa aa? Binib ngbaan aah bii si pu na, ti gbii aan taa gbii?” ");
INSERT INTO xon_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Le Yesu si ŋmin, kaa len tibaa. Le Uwumbɔr aatotoorninkpel ki baa u, “Aa ye Kristo u ga gaa binib lii na aan saa ye? Aa ye Uwumbɔr u ti pak u na Aajapɔɔn aa?” ");
INSERT INTO xon_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Le Yesu bui ke, “M ye. Ni ga kan min Unibɔn Aabo ka Uwumbɔr aaŋangii wɔb. Ni ga kan m bi ntaalangbam ni paacham ki choo.” ");
INSERT INTO xon_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Waah len kina na, le Uwumbɔr aatotoorninkpel chuu kar ubaa aawanpeenkaan, le ki bui ke, “Taa ki ban seeraadam. U di ubaa ŋaŋ Uwumbɔr la. ");
INSERT INTO xon_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni ŋun waah sii Uwumbɔr pu na. Ni dak kinye?” Le bi mɔmɔk bui ke u ŋeer bi ku u la. ");
INSERT INTO xon_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Le bi ponn ni bibaa piin ki bi teei timɔɔtan ŋani u pu, le ki di likekeln poo unimbil, ki gbaa u, ki baa u ke, “Ulau faa si?” Bikikiirb ngbaan mu nan gaa u ki gbaa u. ");
INSERT INTO xon_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piita aah nan bi lichiln ngbaan ni na, le Uwumbɔr aatotoorninkpel aanaagbiipii ubaa dan ");
INSERT INTO xon_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ki nan kan Piita bi wol mmii. Le u lik u mbamɔm, le ki bui u, “Aa mu nan bi Yesu u ye Nasaref aatiŋ aanii na chee.” ");
INSERT INTO xon_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Le Piita nee, ki bui u, “Maa bee saah len pu na aatataa,” le ki nyan lipaal kikaakpaak ponn ni. N‑yoonn ngbaan le ukooja wii. ");
INSERT INTO xon_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Le unaagbiipii ngbaan ki kan u, le ki bui binib bi si nima chee na ke, “Umina ye Yesu aadidiliib ponn ni ubaa la.” ");
INSERT INTO xon_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Le Piita ki nee lelee. Le ni ki kpee siib, le binib bi si u chee na bui u ke, “Ni ye mbamɔn, aa ye Yesu aadidiliib ponn ni ubaa la; aa mu ye Galilee aatiŋ aanii la.” ");
INSERT INTO xon_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Le Piita puu Uwumbɔr, ki bui ke, “Maa nyi naah len unii u na. M yaa mɔn nnyamɔn kan, Uwumbɔr daa ntafal.” ");
INSERT INTO xon_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Libuul ngbaan ni, le lelee aakooja wii. Le Piita teer ke Yesu ba bui u ke, “Aa ga len nfum mutaa ke saa nyi mi le lelee aakooja nin wii.” Piita aah teer kina na, le u wii pam. ");
INSERT INTO xon_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kichakpinaanyeek ni le Uwumbɔr aatotoorninkpiib, ni Juu yaab aaninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni bibɔjirb aaninkpiib mɔmɔk kal ki kpokl baah ga ŋa pu na. Le bi buu Yesu tikululn, ki di u buen kitiŋ ngbaan aaninkpel u bi yin u ke Pailat na chee, ki di u ŋa uŋaal ni. ");
INSERT INTO xon_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Le Pailat baa u, “Aa ye Juu yaab aabɔr la aa?” Le u bui u, “Saah len pu na, ni ye kina.” ");
INSERT INTO xon_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Le Uwumbɔr aatotoorninkpiib ngbaan bii u sakpen. ");
INSERT INTO xon_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Le Pailat ki baa u, “Saan len tibaa aa? Li pel baah bii si sakpen pu na.” ");
INSERT INTO xon_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Le Yesu aa ki len tibaa. Waah kaa len tibaa na, le ni gar Pailat pam. ");
INSERT INTO xon_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Njim ngbaan aayoonn nan saa kan, Pailat ga nyan unaagbiija u kinipaak ban u na lii. ");
INSERT INTO xon_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","N‑yoonn ngbaan, unaagbiija ubaa nan bi kiyondiik ni, bi yin u ke Barabas. U ni bakadam bi nan dii u na nan tukni kitiŋ ngbaan aaninkpiib, ki ku binib. Nima pu le bi nan di bi ŋa kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Le kinipaak ngbaan dan Pailat chee, ki bui u ke u ŋa waah ti ŋani pu njim ngbaan yoonn mɔmɔk na, ki nyan unaagbiija ubaa lii. ");
INSERT INTO xon_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Le u baa bi, “Ni ban m nyan ni Juu yaab aabɔr la aa?” ");
INSERT INTO xon_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat bee ke Uwumbɔr aatotoorninkpiib kpa lipiipoln Yesu pu, nima le cha bi di u ŋa uŋaal ni. ");
INSERT INTO xon_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Le Uwumbɔr aatotoorninkpiib bui kinipaak ngbaan ke bi tuk Pailat ke u nyan Barabas lii, naa ye Yesu. ");
INSERT INTO xon_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kinipaak ngbaan aah tuk Pailat kina na, le u ki baa bi, “Kina kan, uja u ni yin u ke Juu yaab aabɔr na, m ga ŋa u kinye?” ");
INSERT INTO xon_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Le bi teen ke, “Kpaa u ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Le Pailat baa bi, “Ba ŋa? U tun bakaa bayoo?” Le bi moo tar sakpen ke, “Kpaa u ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Le Pailat ban ke u sɔŋ bisui. Kina pu na, u nan nyan Barabas lii, le ki cha waajab lue Yesu ŋinaalab, ki di u ŋa biŋaal ni, bi ti kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Le butɔb aajab ngbaan di u buen Pailat aachiln ni, ki yin bijab biken ke bi kuun ni. ");
INSERT INTO xon_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Le bi chuu peer waawanpeenkaan, le ki di libɔkumaln peen u, ki di ikokon luu kiyikpupuk ki di chiŋ u, ");
INSERT INTO xon_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","le ki doon u ke, “Juu yaab aabɔr, aa pɔɔ ɔɔ?” ");
INSERT INTO xon_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ki joo lidabil gbaa uyil paab, le ki teei timɔɔtan lɔe u, ki gbaan unimbiin ni ki doon u. ");
INSERT INTO xon_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Baah ŋa u mbɔnyun ki ti doo na, le bi chuu peer libɔkumaln ngbaan, ki di waawanpeenkaan peen u, ki di u nyan, bi ti kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Baah cha na, le bi ton uja ubaa nsan ni, bi yin u ke Simonn, u ye Sairene aatiŋ aanii la. U nyan ni ntingbaan ni, le ki choo Jerusalem. U nan ye Aleksanda ni Rufus aate la. Le bi chuu u mpɔɔn ke u tun Yesu aadɔpuinkoo. ");
INSERT INTO xon_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Le bi di Yesu buen nibaa chee, bi yin nima chee ke Golgota. Golgota aatataa le ye ke “Kiyikpaŋ aapepel.” ");
INSERT INTO xon_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baah ti fuu nima chee na, le binib bibaa ban bi tii Yesu ndaan mu nnyɔk ŋmal mu ponn ni na ke u nyun. Le u yii, kaa nyun. ");
INSERT INTO xon_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Le butɔb aajab ngbaan kpaa u ndɔpuinkoo pu, ki di waawanpeenkaan yakr tɔb. Bi nan too inaan ke bi lik bimɔk aah ga kan ni na. ");
INSERT INTO xon_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ni nan ye kichakpiik ni, tikur tiwae yoonn la, le bi kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Le bi ŋmee kigbaŋ budabu cha bi ku u na, ki di tam waadɔpuinkoo pu, uyil paab. Bi nan ŋmee ke, “Juu yaab aabɔr.” ");
INSERT INTO xon_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bi nan di bififiirb bilee kpaa idɔpuinkee pu. Bi di ubaa kpaa uŋangii wɔb, ki di uken kpaa uŋangan wɔb.  ");
INSERT INTO xon_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Le ni gbiin Uwumbɔr Aagbaŋ aah len pu na ke, “Bi ŋa u ke baah ŋani titunwanbirdam pu na.” ");
INSERT INTO xon_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Waah lee ndɔpuinkoo pu na, le binib bi jer nima chee na seei u, ki gbakr biyil, le ki bui u, “Aa mu. Si u len ke aa ga gbaa wii Uwumbɔr Aadichal ki ki maa li iwiin itaa na, ");
INSERT INTO xon_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","sunn ni ndɔpuinkoo ngbaan pu ki ŋmar.” ");
INSERT INTO xon_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb mu ŋa u mbɔnyun, ki bui tɔb ke, “U gaal biken le bi ŋmar, kaan ŋmaa gaa ubaa lii. ");
INSERT INTO xon_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo u ga gaa binib lii ki ye Juu yaab aabɔr na, u sunn ni ndɔpuinkoo pu dandana wee, aan ti kan ki gaa u ki kii.” Le baah di bififiirb bilee bi kpaa u chee idɔpuinkee pu na, bi mu sii u. ");
INSERT INTO xon_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nwiin kaasisik ni, le itingbaan mɔmɔk bɔln, ki ti saa nwiin aah kpar pu na. ");
INSERT INTO xon_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nwiin aah kpar na, le Yesu teen mpɔɔn pu ke, “Eloi, eloi, lama sabaktani.” Naatataa le ye ke “Maawumbɔr, Maawumbɔr, ba pu aa siir cha mi?” ");
INSERT INTO xon_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Binib bi nan si nima chee na ŋun waah teen pu na, le bibaa bui ke, “Li pel man, u yin Elaija la.” ");
INSERT INTO xon_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Le bi ponn ni ubaa san buen ki ti yoor nkiisuk, ki nan di bɔn ndaan mu mɔɔn na ni, le ki di ŋa lidabil pu, ki di ŋa Yesu aamɔb chee ke u moor, le ki bui ke, “Di cha man, aan ti lik ke Elaija ga dan ki nan sunn ni u aan waan dan.” ");
INSERT INTO xon_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Le Yesu ki teen mpɔɔn pu, le ki kpo. ");
INSERT INTO xon_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Le likekeln li yakr Uwumbɔr aadiik ni nfum mulee na, chuu kar paacham ki ti saa kitiŋ. ");
INSERT INTO xon_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Le butɔb aajab aaninkpel u si ndɔpuinkoo ngbaan taab na kan Yesu aah kpo pu na, le ki bui ke, “Mbamɔn, uja ngbaan sil ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bipiib bibaa mu nan bi nima chee, ki si dandar, ki si lik. Bi ponn ni ubaa ye Mari Magdalene, uken mu ye Salome, uken mu ye Mari u ye Jems waatiir ni Joses aana na. ");
INSERT INTO xon_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu aah nan bi Galilee na, le bipiib ngbaan nan dii u, ki tun lituln ter u. Bipiib bi wiir ki nan dii u dan Jerusalem na mu nan bi nima chee. ");
INSERT INTO xon_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kijook aah joor na, le uja ubaa fuu ni, bi yin u ke Josef. U nan ye Arimatea aatiŋ aanii la, ki ye bibɔjirb aaninkpiib ponn ni ubaa, ki kpa liyimbil. ");
INSERT INTO xon_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","U mu nan bi kii Uwumbɔr aanaan aah ga fuu ni buyoonn na. Ni nan ye kitaak ki ga woln Juu yaab aakpaakool daal na, buyoonn bi gor ke bi ji likpaakool daal na. Le Josef buen Pailat chee ni lipobil, ki ti bui u, “Tii mi Yesu aawon.” ");
INSERT INTO xon_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat aah ŋun ke u kpo na, le ni gar u. Le u yin ni bijab aaninkpel na, ki nan baa u ke, “Yesu aah kpo na, ni yunn aa?” ");
INSERT INTO xon_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Le u tuk u waah kpo buyoonn na. Pailat aah ŋun ke u kpo na, le u tii Josef nsan ke u yoor waawon. ");
INSERT INTO xon_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef nan daa likekenyaan, ki nyan Yesu aawon ndɔpuinkoo pu, ki di u poo likekeln ngbaan ni, ki di u ti sub kitakpaluŋ ni. Bi nan gbii kitakpaluŋ ngbaan litakpasakpeln libaa aasikakl ni la. Le u di litakpapapaln leŋ mbisamɔb. ");
INSERT INTO xon_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Le Mari Magdalene, ni Mari u ye Joses aana na, kan baah di Yesu aawon sub nin chee na. ");
INSERT INTO xon_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juu yaab aakpaakool daal aajook, le Mari Magdalene ni Salome, ni Mari u ye Jems aana na, buen ti daa tulalee, bi ti di ŋa Yesu aawon pu. ");
INSERT INTO xon_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Le ki woln kitaak kichakpinaanyeek ni, nwiin aah laa puu na, le bi buen likaakul ngbaan chee. ");
INSERT INTO xon_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tɔ, litakpal li lek kitakpaluŋ ngbaan aamɔb na ye lisakpeln la. Nima pu na, baah cha na, le bi baa tɔb ke, “Ŋma ga ti biln litakpal na tii timi?” ");
INSERT INTO xon_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Le bi lik, ki kan ke litakpal na aa ki lek. ");
INSERT INTO xon_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Le bi koo likaakul na ponn ni ki kan unachipɔɔn ubaa ka ŋŋangii wɔb ki pee libɔkupiln fɔfɔk. Le ni gar bi pam. ");
INSERT INTO xon_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Le u bui bi, “Ni taa cha ni gar nimi man. Ni ban Yesu u ye Nasaref aatiŋ aanii u bi nan kpaa u ndɔpuinkoo pu na la. U fikr nkun ni a. Waa bi do. Lik man baah nan di u bil nin chee na. ");
INSERT INTO xon_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ni li cha ki ti tuk Piita ni waadidiliib biken ke u loln bi pu nsan, ki cha Galilee aatiŋ ni. Bi ga ti kan u nima, waah nan tuk bi pu na.” ");
INSERT INTO xon_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Le ni gar bipiib na pam, le biwon gbaa. Le bi nyan likaakul na ni, ki san. Ijawaan aah chuu bi na, le baa tuk unii ubaa.  ");
INSERT INTO xon_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Juu yaab aakpaakool daal aah jin ki woln kitaak na aachakpitaawoln, Yesu aah fikr nkun ni na, le u puen di ubaa mɔk Mari Magdalene. Mari le ye upii u Yesu nan nyan tiyayaar tilole u ni na. ");
INSERT INTO xon_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Le Mari buen binib bi nan dii Yesu na chee. Bi nan kpa mpombiin ki ka wii. Le Mari tuk bi ke u kan Yesu, u fikr nkun ni a. ");
INSERT INTO xon_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Baah ŋun kina na, le baa pak ti. ");
INSERT INTO xon_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nimina aapuwɔb, le bi ponn ni bilee nan chuun cha ntingbaan ni. Baah cha na, le Yesu nan di ubaa mɔk bi. Waa nan bi ke waah nan bi pu buyoonn Mari Magdalene kan u na. ");
INSERT INTO xon_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Le bi gir buen biken chee, ki ti tuk bi ke bi kan Yesu. Le baa pak baah len pu na. ");
INSERT INTO xon_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nimina aapuwɔb, le waadidiliib kipiik ni ubaa ka ji tijikaar. Baah bi ji na, le Yesu di ubaa mɔk bi, le ki kae bi, ke ba ŋa baa pak binib bi kan u, waah fikr nkun ni aapuwɔb na aah len pu na, ke bitafal le pɔɔ. Baa gaa u ki kii mbamɔm. ");
INSERT INTO xon_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Le u ki tuk bi, “Ni li cha dulnyaa mɔmɔk ni, ki di tibɔnyaan tee tuk binib mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Unii u gaa mi ki kii, ki cha bi muin u nnyun ni na, u ga ŋmar. Unii u kaa gaa mi ki kii na, Uwumbɔr ga bui ke waabɔr bii. ");
INSERT INTO xon_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Binib bi gaa mi ki kii na ga tun lijinjiir aatun. Maayimbil pu le bi ga nyan tiyayaar binib ni; bi ga len iliin yayan; ");
INSERT INTO xon_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","bi ga chuu iwaa, le yaan ŋa bi nibaa. Bi yaa nyu liluul kan, laan ŋa bi nibaa. Bi ga di biŋaal paan bibum pu, le bi ga pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tidindaan Yesu aah len bi chee tibɔr doo na, le Uwumbɔr di u buen paacham, le u ti kal uŋangii wɔb. ");
INSERT INTO xon_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Le waadidiliib buen ŋipepel mɔmɔk ni, ki ti tuk binib tibɔnyaan tee. Le Tidindaan ter bi, ki cha bi tun lijinjiir aatun. Baah tun lijinjiir aatun na, nima le mɔk binib ke baah len tibɔnyaan ti na, ti gbii. Amii.");
INSERT INTO xon_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Maaninkpel Teofilus, binib pam nan pɔɔn bibaa ki ŋmee kigbaŋ ponn ni tibɔr ti nan ŋa tikaasisik ni na. ");
INSERT INTO xon_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Binib bi kan tibɔr ngbaan aah piin ki ti doo pu na mooni ti, ki tuk timi. Le bi ŋmee baah tuk timi pu na. ");
INSERT INTO xon_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Min Luk, m mu bee mbamɔm tibɔr ngbaan aah piin pu ki ti doo pu na. Nima le m dak ke ni ŋan m mu ŋmee ti, taah piin ki ti saa pu na, ki tii si, ");
INSERT INTO xon_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aan aa mu bee baah tuk si tibɔr ti na aabamɔn. ");
INSERT INTO xon_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Buyoonn Herod nan ye Judea aatiŋ aabɔr na, le Uwumbɔr aatotoor ubaa nan bi, bi nan yin u ke Sekaria. U nan ye Abija aamaal ponn ni aanii la. Upuu aayimbil nan ye Elisabef. U mu nan ye Uwumbɔr aatotoor Aaronn aamaal ponn ni aanii ubaa la. ");
INSERT INTO xon_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaria ni upuu mɔmɔk nan ye bininyaam Uwumbɔr chee, ki dii waakaal mɔmɔk, ki ŋani waah ban pu na, kaa kpa taani ubaa. ");
INSERT INTO xon_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Baa nan kpa ubo. Elisabef nan ye upiiŋoob la. Bi mɔmɔk mu nan por la. ");
INSERT INTO xon_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Uwumbɔr aatotoorb aakaal aah dii pu na, le bi lee Sekaria, u ti koo Uwumbɔr Aadichal ni ki see tulalee aayon. Waayoonn aah fuu ni na, le u koo Uwumbɔr Aadichal ni, u ti tun lituln limina. ");
INSERT INTO xon_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Buyoonn u bi seer tulalee aayon ngbaan tii Uwumbɔr na, le kinipaak sakpeŋ bi lipaal, ki mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Le u kan Uwumbɔr aatuun, baah seer tulalee aayon libimbiln li paab na aaŋangii wɔb. ");
INSERT INTO xon_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaria aah kan u na, le ni muk u, le ijawaan chuu u. ");
INSERT INTO xon_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Le Uwumbɔr aatuun ngbaan bui u, “Sekaria, taa san ijawaan. Uwumbɔr ŋun saameen a. Aapuu Elisabef ga maa ubijabo, ki tii si. Le aa ga yin u ke Jɔnn. ");
INSERT INTO xon_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","U yaa ma u kan, le aa ga li kpa mpopiin pam. Binib pam mu ga li mɔɔni. ");
INSERT INTO xon_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","U ga li ye uninyuun Uwumbɔr chee. Waan nyu ŋisubil aadaan, ki mu aan nyu ndaan mubaa. U ga li gbii Uwumbɔr Aafuur Nyaan buyoonn bi ga maa u na, ki li joo cha. ");
INSERT INTO xon_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","U ga cha nimi Israel yaab pam gir ti dii Bidindaan Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","U ga li kpa Uwumbɔr Aafuur Nyaan, ni mpɔɔn, ke Uwumbɔr aabɔnabr Elaija aah nan kpa pu na, ki ga loln ni Tidindaan pu nsan. U ga cha tetiib ni baabim ki kpaan. U ga cha binib bi kaa kii Uwumbɔr aamɔb na li kpa nlan, aan bi kpeln, ki li dii bininyaam aah dii pu na. U ga toor binib, bi li ye binib bi gor ki kii Uwumbɔr na.” ");
INSERT INTO xon_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Le Sekaria bui Uwumbɔr aatuun ngbaan, “M por a, mpuu mu por a; m ga ŋa kinye ki bee ke saah len pu na ga sil ŋa.” ");
INSERT INTO xon_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Le Uwumbɔr aatuun ngbaan bui u, “M ye Gabriel u si Uwumbɔr aanimbiin ni na la. U tun ni mi ke m nan tuk si tibɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ni yaa nan ŋeer kan, maah len pu na ga gbiin. Saah kaa pak maah len pu na, le aa ga ŋa ubir, kaan ki ŋmaa len tibɔr ki ti saa buyoonn tiwan nimina ga ŋa na.” ");
INSERT INTO xon_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Le kinipaak ngbaan si lipaal, ki si kii buyoonn Sekaria ga nya ni Uwumbɔr Aadichal ni na. U nan yunn kaa nyan ni, le ni gar bi pam. ");
INSERT INTO xon_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Waah nan nyan ni na, waa ŋmaa len bi chee tibɔr. Nima le cha bi bee ke u kan lijinjiir aawan Uwumbɔr Aadichal ni. Le u beenin len libir, kaa ŋmaa len tibɔr. ");
INSERT INTO xon_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Waawiin aah ye pu u tun lituln Uwumbɔr Aadichal ni na aah doo na, le u kun. ");
INSERT INTO xon_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ni bi ki cha, le upuu Elisabef dek lipuul, ki di ubaa bɔr iŋmal iŋmu, ");
INSERT INTO xon_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","le ki bui ke, “Uwumbɔr lik maah bi pu na la, le ki ŋa mi tibulchinn kina ki tii mi, ki nyan mi inimɔɔn ni.” ");
INSERT INTO xon_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lipuul aah ŋa iŋmal iloob aapuul na, le Uwumbɔr tun waatuun Gabriel ke u buen Galilee aatiŋ kibaa ni, bi yin ki ke Nasaref, ");
INSERT INTO xon_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ke u buen usapɔɔn ubaa chee, bi yin u ke Mari. Waa nyi uja. Bi nan puu ke bi ga tii u tichar. Bi yin uchal Josef, u ye Ubɔr David aamaal ponn ni aanii ubaa la. ");
INSERT INTO xon_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Le Uwumbɔr aatuun ngbaan fuu ni Mari chee ki doon u, le ki bui u, “Uwumbɔr ŋa si tibulchinn sakpen a, ki bi aa chee, ki ŋa tinyoor ŋa aa pu ki jer waah ŋa bipiib mɔmɔk pu na.” ");
INSERT INTO xon_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Waah len kina na, le ni gar Mari sakpen. Le u dakl lik waah len pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Le u ki bui u, “Mari, taa san ijawaan. Uwumbɔr ŋa si tibulchinn la. ");
INSERT INTO xon_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aa ga dek lipuul, ki maa ubijabo ki yin u ke Yesu. ");
INSERT INTO xon_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","U ga li ye uninyuun la. Bi ga yin u Uwumbɔr u kaa kpa ŋeen aatɔ na Aajapɔɔn. Tidindaan Uwumbɔr ga tii u uyaaja Ubɔr David aanaan. ");
INSERT INTO xon_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U ga li ye uyaaja Jakob aayaabitiib aabɔr n‑yoonn mu kaa kpa ndoon na. Waanaan aan doo.” ");
INSERT INTO xon_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Le Mari baa Uwumbɔr aatuun ngbaan ke, “Maah kaa nyi uja na, m ga ŋa kinye ki maa ubo?” ");
INSERT INTO xon_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Le u bui u, “Uwumbɔr Aafuur Nyaan ga sunn ni aa pu. Uwumbɔr u kaa kpa ŋeen aatɔ na aapɔɔn ga cha aa dek lipuul. Nima pu na, saah ga maa ubo u na ga li ye chain. Bi ga yin u ke Uwumbɔr Aajapɔɔn la. ");
INSERT INTO xon_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lik, aana aabo Elisabef, u por na, u mu pil ubijabo aapuul. Baah nan yin u ke upiiŋoob na kpa iŋmal iloob aapuul la; ");
INSERT INTO xon_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","nibaa aa pɔɔ Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Le Mari bui Uwumbɔr aatuun ngbaan, “M ye Uwumbɔr aanaagbiipii la. Saah len pu na, u cha ni ŋa kina.” Le Uwumbɔr aatuun ngbaan buen. ");
INSERT INTO xon_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","N‑yoonn ngbaan le Mari gor mala ki buen ŋijoo ponn ni, le ki ti buen kitiŋ kibaa ni, ki bi Juda aatiŋ ponn ni, ");
INSERT INTO xon_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","le ki koo Sekaria do, ki doon Sekaria aapuu Elisabef. ");
INSERT INTO xon_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabef aah ŋun idoon pu na, le waabo fii uponn ni. Le Uwumbɔr Aafuur Nyaan gbiin Elisabef. ");
INSERT INTO xon_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Le u len mpɔɔn pu ki bui Mari, “Uwumbɔr ŋa tinyoor ŋa aa pu ki jer waah ŋa bipiib mɔmɔk pu na, ki ŋa tinyoor ŋa ubo u bi aaponn ni na mu la. ");
INSERT INTO xon_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ba ŋa Uwumbɔr nyuŋ mi kina ki cha Ndindaan aana dan nan mann mi? ");
INSERT INTO xon_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ntafal aah ŋun saadoon na, le maabo fii mponn ni, waah kpa mpopiin pu na. ");
INSERT INTO xon_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Si u gaa Uwumbɔr ki kii na, u ŋa tinyoor ŋa aa pu la, ki ga ŋa waah nan tuk si ke u ga ŋa pu na.” ");
INSERT INTO xon_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Le Mari bui ke, “M nyuŋni Uwumbɔr nsui ni la. ");
INSERT INTO xon_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","M kpa mpopiin sakpen, Uwumbɔr u gaa mi lii na pu. ");
INSERT INTO xon_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","U teer mi u ye waanaagbiipiigiin na bɔr. Dandana ki joo cha, binib mɔmɔk ga len ke Uwumbɔr ŋa tinyoor ŋa m pu la, ");
INSERT INTO xon_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ba pu? Uwumbɔr u kpa mpɔɔn na tun litukpaan ki tii mi. Waayimbil ye chain la. ");
INSERT INTO xon_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Binib bi san u na, u san bi kinimbaak, ni biyaabitiib, ni biyaabisɔsɔk ponn ni ki joo cha. ");
INSERT INTO xon_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U mɔk binib waapɔɔn, ki jenn kalmbaanidam bi dak ke bi ye bininyuum na. ");
INSERT INTO xon_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U nyan bibɔrkpaam baanaan ni, ki nyuŋ bigiim. ");
INSERT INTO xon_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Binib bi nkon joo bi na, u tii bi tijikaar nyaan, bi ji bab. U cha biwankpadam chuun ni iŋaalpeen. ");
INSERT INTO xon_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Waah nan puu tipuur ti tii tiyaajatiib na, u ŋa kina la, ki ter waatutum Israel yaab. ");
INSERT INTO xon_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","U teer ki san Abraham ni uyaabitiib kinimbaak n‑yoonn mu kaa kpa ndoon na la.” ");
INSERT INTO xon_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tɔ, Mari nan bi Elisabef do iŋmal itaa, le ki nin gir kun. ");
INSERT INTO xon_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Le ni ŋeer Elisabef maa ubo. Le u ma ubijabo. ");
INSERT INTO xon_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Le udoyaab ŋun ke Uwumbɔr san u kinimbaak sakpen. Le u ni bi kpaan ki mɔɔni. ");
INSERT INTO xon_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Waabo aawiin iniin daal, le bi dan bi nan gii uchakpaln, le ki ban bi yin u ke Sekaria ke baah yin ute pu na. ");
INSERT INTO xon_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Le una aa kii, ki bui ke bi ga yin u ke Jɔnn la. ");
INSERT INTO xon_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Le bi bui u, “Unii ubaa aa kpa liyimbil limina nimi aamaal ponn ni.” ");
INSERT INTO xon_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Le bi di biŋaal len ute chee, ki baa u ke u ban ke bi yi waabo kinye. ");
INSERT INTO xon_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Le u bui bi ke bi tii u kigbaŋ. Baah tii u na, le u ŋmee ke, “Waayimbil le ye Jɔnn.” Le ni gar bi mɔmɔk pam. ");
INSERT INTO xon_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Libuul ngbaan ni le Sekaria aalambil lɔkr. Le u piin ki bi len ki pak Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Le ijawaan chuu bidoyaab mɔmɔk. Le Judea aatim mumɔk bi ŋijoo ponn ni na aanib ŋun tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ni nan ŋa binib bimɔk ŋun ti na ilandak. Le bi baa ke, “Ubo ngbaan ga li ye ba aanibol?” Ba pu? Uwumbɔr aaŋaal nan bi u pu. ");
INSERT INTO xon_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Le Uwumbɔr Aafuur Nyaan gbiin Sekaria, u ye Jɔnn aate na, le ki cha u len Uwumbɔr aabɔr: ");
INSERT INTO xon_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cha ti pak Tidindaan u ye timi Israel yaab Aawumbɔr na. U dan nan ter waanib, ki nyan bi tinaagbiir ni, ");
INSERT INTO xon_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ki tii timi unii u ga gaa timi lii, ki kpa mpɔɔn, ki ye waatutunn Ubɔr David aamaal ponn ni aanii ubaa na. ");
INSERT INTO xon_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","U nan cha waabɔnabtiib chain len kina n‑yaayoonn na ki joo cha. ");
INSERT INTO xon_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","U nan puu tipuur ke u ga nyan timi, timi aadim aaŋaal ni, ni bimɔk nan timi na aaŋaal ni, aan ti ŋmar. ");
INSERT INTO xon_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","U nan len ke u ga san tiyaajatiib kinimbaak, ki teer waah puu tipuur ti ye chain na bɔr. ");
INSERT INTO xon_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","U nan puu tipuur tii tiyaaja Abraham, ");
INSERT INTO xon_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ke u ga nyan timi, timi aadim aaŋaal ni, aan ti dii u ki taa li san ijawaan, ");
INSERT INTO xon_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ki li bi chain, ki li kpa mbimbinyaan u chee n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Si, maabo, bi ga yin si ke Uwumbɔr u kaa kpa ŋeen aatɔ na aabɔnabr. Aa ga loln ni Tidindaan pu nsan, ki toor nsan tii u, ");
INSERT INTO xon_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ki tuk waanib ke u ga di cha baatunwanbir pinn bi, ki gaa bi lii; ");
INSERT INTO xon_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ba pu? timi Aawumbɔr kpa tibulchinn, ki san timi kinimbaak. U yaa gaa timi lii kan, ni ga li bi ke nwiin aah puu ni pu na. ");
INSERT INTO xon_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ni ga woln binib bi bi mbɔmbɔɔn ni ki san nkun ijawaan na pu, ni ga mɔk timi nsan mu ga tii timi nsuudoon na.” ");
INSERT INTO xon_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Le ubo ngbaan muun, ki dii Uwumbɔr ni usui mɔmɔk, le ki nan bi nteersakpiin ni, ki ti saa buyoonn u piin ki bi tuk Israel yaab Uwumbɔr aabɔr na. ");
INSERT INTO xon_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","N‑yoonn ngbaan le Ubɔrkpaan Siisa Agustus len ke binib mɔmɔk kuun ni ki nan ŋmee baayimbil, u lik baah wiir pu na. ");
INSERT INTO xon_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Baah kahn binib kina njan pu na, Kirinius le nan ye Siria aatiŋ aaninkpel. ");
INSERT INTO xon_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Le binib mɔmɔk buen bido aatiŋ ni, bi ti ŋmee baayimbil. ");
INSERT INTO xon_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josef nan ye Ubɔr David aamaal ponn ni aanii ubaa la. Nima pu na, u nan nyan Nasaref, kitiŋ ki bi Galilee aatiŋ ni na, le ki buen Ubɔr David aatiŋ, ki bi yin ki ke Betlehem, ki bi Judea aatiŋ ni na. ");
INSERT INTO xon_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Le u ni upuu Mari, u kpa lipuul na, buen bi ti ŋmee baayimbil. ");
INSERT INTO xon_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Baah bi Betlehem aatiŋ ni na, le ni ŋeer u maa ubo. ");
INSERT INTO xon_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Le u ma waajan aabijabo, ki di u poo likekeln ni, ki di u di ŋa tiwakor aah ŋmɔ timoor dakaa u ponn ni na; mpaan aa nan ki bi bicham aadiik ponn ni ke bi koo. ");
INSERT INTO xon_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bipihdam bibaa nan bi nima chee timoor ni, ki kpaa baapiih ki lik i kinyeek. ");
INSERT INTO xon_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Le Uwumbɔr aatuun dan bi chee. Le Uwumbɔr aawiihn woln bi pu. Le ijawaan chuu bi sakpen. ");
INSERT INTO xon_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Le Uwumbɔr aatuun ngbaan bui bi, “Taa san ijawaan man. M joo ni tibɔnyaan ti ga tii binib mɔmɔk mpopiin sakpen na la. ");
INSERT INTO xon_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kinyeek kee bi ma unii u ga gaa nimi lii na, Ubɔr David aatiŋ ni. Uma le ye Tidindaan Kristo. ");
INSERT INTO xon_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ni ga kan ubo ngbaan aah poo ŋikeken ni, ki dɔ tiwakor aah ŋmɔ timoor dakaa u ponn ni na. Nima le ga li ye limɔkl ki tii nimi.” ");
INSERT INTO xon_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Libuul ngbaan ni le Uwumbɔr aatuuntiib bi wiir sakpen na fuu ni ntuun ngbaan chee, le ki pak Uwumbɔr, ki len ke, ");
INSERT INTO xon_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Cha ti nyuŋ Uwumbɔr u bi paacham na. Lifuur ga li bi dulnyaa wee ni. Uwumbɔr san binib kinimbaak la.” ");
INSERT INTO xon_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Le Uwumbɔr aatuuntiib ngbaan gir buen paacham. Le bipihdam ngbaan bui tɔb, “Cha ti buen Betlehem aatiŋ ni dandana, ki ti lik Uwumbɔr aah tuk timi ke tiwan ni ŋa nima na.” ");
INSERT INTO xon_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Le bi buen mala, ki ti kan Mari, ni Josef, ni ubo ngbaan. Ubo ngbaan dɔ tiwakor aah ŋmɔ timoor dakaa u ponn ni na. ");
INSERT INTO xon_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bipihdam ngbaan aah kan u na, le bi tuk binib Uwumbɔr aatuun ngbaan aah tuk bi ubo ngbaan aabɔr pu na. ");
INSERT INTO xon_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Binib bimɔk ŋun bipihdam ngbaan aah len pu na, le ni gar bi. ");
INSERT INTO xon_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari le teer tibɔr timina mɔmɔk, ki dakl lik taatataa usui ni. ");
INSERT INTO xon_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Le bipihdam ngbaan gir buen baapiih chee timoor ni. Baah cha na, le bi nyuŋni Uwumbɔr ki pak u, baah kan ki ŋun pu na mɔmɔk pu; bi kan ki ŋun Uwumbɔr aatuun ngbaan aah tuk bi pu na. ");
INSERT INTO xon_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ubo ngbaan aawiin iniin daal le ni ŋeer bi gii uchakpaln. Le bi yin u ke Yesu. Buyoonn Mari aa nan kee dek lipuul na, le Uwumbɔr aatuun ngbaan nan bui u ke bi yin u kina. ");
INSERT INTO xon_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Buyoonn ni ŋeer bi ŋa Mari chain, Moses aakaal aah mɔk pu na, le bi di ubo ngbaan buen Jerusalem, bi ti di u tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ni ŋmee Uwumbɔr aakaal aagbaŋ ni ke bi di njan aabijabo mɔk ki di tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Le Josef ni Mari toor kitork ki tii Uwumbɔr, waakaal aah len pu na. Nkaal ngbaan len ke bi di ŋinanjel ŋilee, bee mbɔrnanjibim mulee ki di toor kitork ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Uja ubaa nan bi Jerusalem aatiŋ ni. Bi nan yin u ke Simeonn. U nan ye uninyaan la, ki dii Uwumbɔr aakaal mɔmɔk mbamɔm, ki lik bundaln Uwumbɔr ga nyan Israel yaab baafalaa ni na. Uwumbɔr Aafuur Nyaan nan bi u chee, ");
INSERT INTO xon_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ki nan mɔk u ke waan kpo, see u kan Uwumbɔr aanii Kristo u ga gaa binib lii na waahr. ");
INSERT INTO xon_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Uwumbɔr Aafuur Nyaan nan cha u koo Uwumbɔr Aadichal ni, le Yesu aate ni una joo ni Yesu ki di koo ni Uwumbɔr Aadichal ni, bi ti di u tii Uwumbɔr. Buyoonn bi di u koo ni na ");
INSERT INTO xon_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","le Simeonn gaa u uŋaal ni, le ki pak Uwumbɔr, ki bui ke, ");
INSERT INTO xon_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Uwumbɔr, aa ga ŋmaa cha saatutunn nya dulnyaa wee ni, nsuudoon ni; ba pu? dandana aa ŋa saah nan len pu na, ");
INSERT INTO xon_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ki cha nnimbil kan Saabo u ga gaa timi lii na. ");
INSERT INTO xon_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aa nan len ke aa ga tun ni u dulnyaa wee ni. Dandana wee u ga nya, aan binib mɔmɔk bee waabɔr. ");
INSERT INTO xon_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","U ye nwiihn ki ga woln binib bi kaa ye Israel yaab na aanimbil. U pu, le binib ga nyuŋ saanib Israel yaab.” ");
INSERT INTO xon_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonn aah len ubo ngbaan aabɔr kina na, le ni gar ute ni una. ");
INSERT INTO xon_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Le Simeonn ŋa Uwumbɔr aanyoor ŋa bi pu, le ki bui ubo ngbaan aana Mari, “Uwumbɔr nyan ubo ngbaan ke u sunn timi Israel yaab ponn ni pam taab, ki nyuŋ ti ponn ni pam mu. U ye limɔkl li binib pam ga yii li na. ");
INSERT INTO xon_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nima le ga kpiir baah dak pu bisui ni na. Aasui mu ga bii sakpen a, ki ga li wu ke unyoohn na.” ");
INSERT INTO xon_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Le upininkpel ubaa, u ye Uwumbɔr aabɔnabpii, aan bi yin u ke Ana na, mu nan bi. U nan ye Fanuel aabisal, ki ye Aser aanibol ponn ni aanii ubaa la. U nan por sakpen a. U nan bi uchal chee ŋibin ŋilole, le uchal kpo cha u, le u ye ukpopii. ");
INSERT INTO xon_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","U nan ye ŋibin imonko inaa ni ŋinaa aanii la. U nan bi Uwumbɔr Aadichal ni n‑yoonn mɔmɔk, ki dooni u nwiin pu ni kinyeek, ki lulni bumɔb, ki mee u. ");
INSERT INTO xon_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","N‑yoonn ngbaan le u mu fuu ni, ki dooni Uwumbɔr ubo ngbaan pu, le ki di waabɔr tuk Jerusalem aanib bimɔk lik buyoonn Uwumbɔr ga gaa bi lii na. ");
INSERT INTO xon_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu aate ni una nan ŋa Uwumbɔr aakaal aah len pu na mɔmɔk, le ki gir kun bido aatiŋ Nasaref ki bi Galilee aatiŋ ni na. ");
INSERT INTO xon_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Le ubo ngbaan muun, ki moo kan mpɔɔn, ki kpa nlan sakpen. Le Uwumbɔr aanyoor nan bi u pu. ");
INSERT INTO xon_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Libiln mɔk, ute ni una nan chaa Jerusalem, buyoonn Juu yaab ji Lakr‑jer aajim ");
INSERT INTO xon_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu aah nan ti saa ŋibin kipiik ni ŋilee na, le bi buen Jerusalem bi ti ji njim ngbaan, baah ŋani pu ŋibin mɔmɔk na. ");
INSERT INTO xon_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bi nan bi nima ki ti saa buyoonn njim ngbaan aawiin doo na, le ki gir chaa kun. Le Yesu u nan laa ye ubo na gaar Jerusalem ni. Ute ni una mu aa nyi. ");
INSERT INTO xon_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bi dak ke u bi usachun ŋeen aatɔtiib ponn ni. Le bi chuun nwimɔn aasachuln, le ki nin ban u bidoyaab ponn ni, kaa kan u. ");
INSERT INTO xon_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Baah kaa kan u na, le bi gir buen Jerusalem ponn ni, ki ti chuun ban u. ");
INSERT INTO xon_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iwiin itaa daal le bi ti kan u Uwumbɔr Aadichal ni. U ka bimɔmɔkninkpiib aakaasisik ni, ki pel baah len pu na, ki mu baa bi mbaan, ");
INSERT INTO xon_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ki kpa nlan ki bee baah len pu na aatataa, ki giin kii bi mbamɔm. Nima le ni gar binib bimɔk ŋun na. ");
INSERT INTO xon_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ute ni una aah kan u na, le ni gar bi pam. Le una baa u, “Maabo, ba ŋa aa ŋa timi kina? M ni aate ban si ni mpombiin.” ");
INSERT INTO xon_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Le u baa bi, “Ba pu ni ban mi? Naa nyi ke ni ye ke m li bi Nte Uwumbɔr aatuln ni ii?” ");
INSERT INTO xon_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Le baa bee waah len pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Le u dii bi ki gir Nasaref aatiŋ ni, le ki kii bimɔi. Le una joo tibɔr timina mɔmɔk usui ni. ");
INSERT INTO xon_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nan muun ki moo kan nlan, le ki kan kipak binib ni Uwumbɔr mu chee. ");
INSERT INTO xon_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Buyoonn Ubɔrkpaan Tiberius Siisa nan jin waanaan ŋibin kipiik ni ŋiŋmu ni, aan Pontius Pailat mu ye Judea aatiŋ aaninkpel, Herod mu ye Galilee aabɔr, aan unaal Filip mu ye Iturea aatiŋ, ni Trakonitis aatiŋ aabɔr, Lisanius mu ye Abilene aatiŋ aabɔr, ");
INSERT INTO xon_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","aan Anas ni Kayafas mu ye Uwumbɔr aatotoorninkpiib na, n‑yoonn ngbaan le Jɔnn u ye Sekaria aajapɔɔn na nan bi nteersakpiin ni. Le Uwumbɔr len u chee tibɔr nima. ");
INSERT INTO xon_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Le u bɔ dii Jɔɔdann aamɔɔl aatingbaan ni, ki mooni ke, “Kpeln nimi aabimbin man, aan m muin nimi nnyun ni, le Uwumbɔr ga di cha nimi aatunwanbir pinn nimi.” ");
INSERT INTO xon_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Waah ŋa kina na, le ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan ŋmee pu Uwumbɔr Aagbaŋ ni na ke, “Unii ubaa bi nteersakpiin ni ki tar, ‘Toor Uwumbɔr aasan man ki ŋa waasan mu li tok ki tii u. ");
INSERT INTO xon_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bi ga di titan gbiin tifatann mɔmɔk, ki ber ŋijoo ni ŋigongon mɔmɔk lii taab, ki naar isan imɔk gɔr na, ki ŋa isan imɔk kaa joon na, i li joon tii u. ");
INSERT INTO xon_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Binib mɔmɔk ga kan Uwumbɔr aah ga gaa bi lii pu na.’” ");
INSERT INTO xon_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Le kinipaak nan dan Jɔnn chee, ki ban ke u muin bi nnyun ni. Le u baa bi, “Nimi ijagen aabim, ŋma sur nimi ke ni nya ntafadaan mu choo na ni? ");
INSERT INTO xon_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ni li tun lituln li ga mɔk ke ni sil kpeln nimi aabimbin na, ki taa bui ke niyaaja aah ye Abraham na, nima le ga cha ni nyan ntafadaan ni. M tuk nimi la, Uwumbɔr ga ŋmaa di ŋitakpal ŋimina kpaln Abraham aayaabitiib. ");
INSERT INTO xon_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dandana wee Uwumbɔr toor kichɔk ke u ti gaa isui imɔk kaa lu ŋisubil ŋi ŋan na, ki di ŋa mmii ni.” ");
INSERT INTO xon_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Le kinipaak ngbaan baa u, “Kina kan, ti ga ŋa kinye?” ");
INSERT INTO xon_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Le u bui bi, “Unii u kpa ŋibɔkul ŋilee na, u tii unii u kaa kpa libaa na. Unii u mu kpa tijikaar na, u yakr tii unii u kaa kpa na.” ");
INSERT INTO xon_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bilampoogaab mu nan dan u chee, ki ban ke u muin bi nnyun ni, le ki baa u, “Umɔmɔkr, ti mu ga ŋa kinye?” ");
INSERT INTO xon_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Le u bui bi, “Ni taa gaa ŋimombil ki jer baah siin nimi pu na.” ");
INSERT INTO xon_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Le butɔb aajab mu baa u, “Ti mu ga ŋa kinye?” Le u bui bi, “Ni taa gaa unii ubaa aamombil mpɔɔn man, ki taa galn unii u kaa kpa taani na. Cha ninimbil gbiin nimi aapal.” ");
INSERT INTO xon_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jɔnn pu, le binib aalandak fii. Bi mɔmɔk baa bisui ni ke, “U ye Kristo u ga gaa timi lii na aan waa ye?” ");
INSERT INTO xon_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Le Jɔnn bui bi mɔmɔk, “Mma muin nimi nnyun ni la. Tɔ, unii u jer mi na mu choo. Maa ŋeer ke m gbiln waanaatak aaŋmin ki tii u. Uma le ga muin nimi Uwumbɔr Aafuur Nyaan, ni mmii ni. ");
INSERT INTO xon_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U joo waayikpimbik uŋaal ni, u ti chaar waajikaar, ki di njikaabim ŋa lipil ni, ki di tigbengbir see mmii mu kaan junn na ni.” ");
INSERT INTO xon_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kina le Jɔnn nan sur binib ngbaan, ki di ŋimɔbon aabɔŋ kpee ki sur bi, ki mooni tibɔnyaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","U nan sur Ubɔr Herod mu. Herod nan gaa unaal aapuu Herodias, ki ki tun titunwanbir sakpen ki kpee. Nima le cha Jɔnn nan sur u. ");
INSERT INTO xon_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Le Herod ki tun titunwanbir tiken ki kpee, ki chuu Jɔnn laŋ kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jɔnn aah nan muin binib nnyun ni na, le u muin Yesu mu nnyun ni. Le Yesu mee Uwumbɔr. Waah bi mee Uwumbɔr na, le kitaapaak chuu piir. ");
INSERT INTO xon_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Le Uwumbɔr Aafuur Nyaan sunn ni, ki nan tɔŋ u pu, ki naahn linanjel. Le nneel nyan ni paacham ki len, “Aa ye Njapɔɔn u m gee si na la. Nnimbil gbiin si.” ");
INSERT INTO xon_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Buyoonn Yesu naahn ke waah ŋa ŋibin piitaa aanii na, le u piin ki tuk binib Uwumbɔr aabɔr. Binib nan dak ke u ye Josef aajapɔɔn la. Josef nan ye Heli aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mu nan ye Matat aajapɔɔn, Matat mu nan ye Liifai aajapɔɔn, Liifai mu nan ye Melki aajapɔɔn, Melki mu nan ye Janai aajapɔɔn, Janai mu nan ye Josef aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef mu nan ye Matatias aajapɔɔn, Matatias mu nan ye Amos aajapɔɔn, Amos mu nan ye Nahum aajapɔɔn, Nahum mu nan ye Esli aajapɔɔn, Esli mu nan ye Nagai aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mu nan ye Maaf aajapɔɔn, Maaf mu nan ye Matatias aajapɔɔn, Matatias mu nan ye Semeinn aajapɔɔn, Semeinn mu nan ye Josek aajapɔɔn, Josek mu nan ye Joda aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda mu nan ye Joanann aajapɔɔn, Joanann mu nan ye Resa aajapɔɔn, Resa mu nan ye Serubabel aajapɔɔn, Serubabel mu nan ye Sealtiel aajapɔɔn, Sealtiel mu nan ye Neri aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mu nan ye Melki aajapɔɔn, Melki mu nan ye Adi aajapɔɔn, Adi mu nan ye Kosam aajapɔɔn, Kosam mu nan ye Elmadam aajapɔɔn, Elmadam mu nan ye Er aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mu nan ye Josua aajapɔɔn, Josua mu nan ye Elieser aajapɔɔn, Elieser mu nan ye Jorim aajapɔɔn, Jorim mu nan ye Matat aajapɔɔn, Matat mu nan ye Liifai aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liifai mu nan ye Simeonn aajapɔɔn, Simeonn mu nan ye Juda aajapɔɔn, Juda mu nan ye Josef aajapɔɔn, Josef mu nan ye Jonam aajapɔɔn, Jonam mu nan ye Eliakim aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim mu nan ye Melea aajapɔɔn, Melea mu nan ye Mena aajapɔɔn, Mena mu nan ye Matata aajapɔɔn, Matata mu nan ye Natann aajapɔɔn, Natann mu nan ye Ubɔr David aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ubɔr David mu nan ye Jese aajapɔɔn, Jese mu nan ye Obed aajapɔɔn, Obed mu nan ye Boas aajapɔɔn, Boas mu nan ye Salmonn aajapɔɔn, Salmonn mu nan ye Nasonn aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonn mu nan ye Aminadab aajapɔɔn, Aminadab mu nan ye Adminn aajapɔɔn, Adminn mu nan ye Arni aajapɔɔn, Arni mu nan ye Hesronn aajapɔɔn, Hesronn mu nan ye Peres aajapɔɔn, Peres mu nan ye Juda aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda mu nan ye Jakob aajapɔɔn, Jakob mu nan ye Aisak aajapɔɔn, Aisak mu nan ye Abraham aajapɔɔn, Abraham mu nan ye Tera aajapɔɔn, Tera mu nan ye Nahor aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor mu nan ye Serug aajapɔɔn, Serug mu nan ye Reu aajapɔɔn, Reu mu nan ye Peleg aajapɔɔn, Peleg mu nan ye Eber aajapɔɔn, Eber mu nan ye Sela aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela mu nan ye Kainann aajapɔɔn, Kainann mu nan ye Afaksad aajapɔɔn, Afaksad mu nan ye Sem aajapɔɔn, Sem mu nan ye Nowa aajapɔɔn, Nowa mu nan ye Lamek aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mu nan ye Metusela aajapɔɔn, Metusela mu nan ye Enok aajapɔɔn, Enok mu nan ye Jared aajapɔɔn, Jared mu nan ye Mahalaleel aajapɔɔn, Mahalaleel mu nan ye Kenann aajapɔɔn, ");
INSERT INTO xon_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenann mu nan ye Enos aajapɔɔn, Enos mu nan ye Sef aajapɔɔn, Sef mu nan ye Adam aajapɔɔn, Uwumbɔr le nan naan Adam. ");
INSERT INTO xon_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu, u nan gbii Uwumbɔr Aafuur Nyaan na nan nyan Jɔɔdann aamɔɔl chee. Le Uwumbɔr Aafuur Nyaan cha u buen nteersakpiin ni, ");
INSERT INTO xon_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","le kinimbɔŋ ti tɔŋ u nima, iwiin imonko ilee. Iwiin imonko ilee ngbaan Yesu aa jin nibaa. Le iwiin ngbaan aah jer na, nkon chuu u. ");
INSERT INTO xon_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Le kinimbɔŋ bui u, “Aa yaa ye Uwumbɔr Aajapɔɔn kan, bui litakpal limina aan li kpaln tijikaar.” ");
INSERT INTO xon_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Le Yesu bui ki ke, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Tijikaar baanja aan ŋmaa tii unii limɔfal.’” ");
INSERT INTO xon_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Le kinimbɔŋ di u buen lijool li fɔk na paab, ki ti mɔk u dulnyaa wee ni aanaan mɔmɔk libuul ngbaan ni, ");
INSERT INTO xon_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","le ki bui u, “M ga di mpɔɔn mumina mɔmɔk, ni mu aawangol tii si. Bi nan di ni mɔmɔk tii mi la. M mu ga ŋmaa di ni tii unii u m ban na. ");
INSERT INTO xon_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aa yaa gbaan nnimbiin ni ki pak mi kan, sin le ga li yeh ni mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Le Yesu bui ki ke, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Li pak Aadindaan Uwumbɔr ki dii uma baanja.’” ");
INSERT INTO xon_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Le kinimbɔŋ di u buen Jerusalem, ki ti di u tɔŋ Uwumbɔr Aadichal paab, le ki bui u, “Aa yaa ye Uwumbɔr Aajapɔɔn kan, lir ni kitiŋ; ");
INSERT INTO xon_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘U ga tuk waatuuntiib ke bi li lik si. ");
INSERT INTO xon_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Le bi ga li joo si biŋaal ni, aataal taa gbeer litakpal.’” ");
INSERT INTO xon_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Le Yesu bui ki ke, “Uwumbɔr Aagbaŋ len ke, ‘Taa tɔŋ Aadindaan Uwumbɔr.’” ");
INSERT INTO xon_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kinimbɔŋ aah tɔŋ Yesu ntɔŋ mɔmɔk ki ti doo na, le ki laa siir cha u. ");
INSERT INTO xon_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","N‑yoonn ngbaan le Yesu gir kun Galilee aatiŋ ni. Uwumbɔr Aafuur Nyaan aapɔɔn mu bi u ni. Le waayimbil moon Galilee aatingbaan mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Le u koo mmeen aadir ni, ki tuk binib Uwumbɔr aabɔnyaan. Le binib mɔmɔk nyuŋ u. ");
INSERT INTO xon_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu nan ti fuu Nasaref aatiŋ, baah nan kpiin u nin chee na. Juu yaab aakpaakool daal, le u koo mmeen aadiik ni, waah ŋani pu n‑yoonn mɔmɔk na. Le u fii sil ke u karn Uwumbɔr Aagbaŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Le bi nan di Uwumbɔr aabɔnabr Aisaya aagbaŋ di tii u. Le u kpar kigbaŋ ngbaan, ki kan nin chee ŋmee ke, ");
INSERT INTO xon_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uwumbɔr Aafuur Nyaan bi m ni; u nyan mi ke m tuk bigiim tibɔnyaan tee. U tun ni mi ke m nan sɔŋ binib bi kpa mpombiin na aasui, ki tuk binaagbiib ke m gaa bi lii la, ki tuk bijoom ke m likr binimbil, ki nyan bifalaadam baafalaa ni, ");
INSERT INTO xon_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ki tuk binib ke buyoonn Uwumbɔr ga gaa waanib lii na fuu ni.” ");
INSERT INTO xon_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Le Yesu ki kpab kigbaŋ ngbaan, ki ki giin ki tii mmeen aadiik ni aatotoor ngbaan, le ki kal. Le binib bimɔk bi mmeen aadiik ni na aanimbil kal u pu. ");
INSERT INTO xon_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Le u bui bi, “Naah ŋun Uwumbɔr Aagbaŋ ni aabɔr ti din wee na gbiin la.” ");
INSERT INTO xon_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Le bi mɔmɔk pak u. Waah len iliinyaan pu na, le ni gar bi pam. Le bi baa tɔb, “Waa ye Josef aajapɔɔn la aa?” ");
INSERT INTO xon_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Le u bui bi, “M bee ke ni ga bui mi liyataŋakl limina, ‘Dɔkta, tii aabaa laafee.’ Ni ga ki bui mi, ‘Ti ŋun saah tun lijinjiir aatun Kapenaum aatiŋ ni pu na. Tun kina do chee na, saatiŋ ponn ni.’ ");
INSERT INTO xon_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","M tuk nimi mbamɔn la, binib aan nyuŋ Uwumbɔr aabɔnabr ubaa udo aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Li pel man, Elaija aayoonn na, utaal aa nan nun ŋibin ŋitaa ni iŋmal iloob. Le nkon sakpem lir kitiŋ ngbaan ni. N‑yoonn ngbaan Israel yaab ponn ni bikpopiib nan bi ki wiir. ");
INSERT INTO xon_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Uwumbɔr mu aa nan tun Elaija u ti ter bi ponn ni ubaa. U nan tun u Sarefaf aatiŋ, ki bi Saidonn aatiŋ ni na, ke u ti ter ukpopii u bi nima na. ");
INSERT INTO xon_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Uwumbɔr aabɔnabr Elaisa aayoonn na, bikɔndam nan bi Israel yaab ponn ni ki wiir; le Uwumbɔr aa cha bi ponn ni ubaa pɔɔk. Naamann, u nan ye Siria aatiŋ aanii na baanja le u nan cha u pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu aah len kina na, le binib bimɔk bi mmeen aadiik ni na gee liŋuul sakpen, ");
INSERT INTO xon_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","le ki fii, ki chuu nyan u kitiŋ ngbaan ni, ki di u buen baatiŋ aah bi lijool li paab na, bi ti di u lii lijool ngbaan aataab. ");
INSERT INTO xon_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Le u bɔ dii bikaasisik ni ki buen. ");
INSERT INTO xon_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","U nan fuu Kapenaum, kitiŋ ki bi Galilee aatiŋ ni na. Le Juu yaab aakpaakool daal u koo mmeen aadiik ni, ki ti tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Waah tuk bi tibɔr ti na, le ni gar bi pam. Ba pu? waabɔr nan kpa mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Le uja u tiyayaar joo u na bi mmeen aadiik ngbaan ni, le ki teen mpɔɔn pu ke, ");
INSERT INTO xon_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Sin Yesu u ye Nasaref aatiŋ aanii na, aa ban ba ti chee? Aa dan aa nan ŋa timi yɔli la aa? M nyi si. Aa ye Uwumbɔr aanii u ye chain na la.” ");
INSERT INTO xon_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Le Yesu kae tiyayaar ngbaan, ki len ke, “Ŋmim. Di uja ngbaan lii.” Le tiyayaar ngbaan di u lii kitiŋ, ki nyan cha u. Taah lii u kitiŋ na, naa ŋa u nibaa. ");
INSERT INTO xon_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Le ni gar bi mɔmɔk pam. Le bi baa tɔb, “Ba aabɔboln sɔ? U kpa yiko ni mpɔɔn le ki tuk tiyayaar ke ti di binib lii. Le ti kii waamɔb.” ");
INSERT INTO xon_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Le Yesu aayimbil moon ŋipepel mɔmɔk, nima chee. ");
INSERT INTO xon_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu nan nyan mmeen aadiik ni, ki buen Simonn aadichal ni. Le Simonn aapuu aana aawon toŋ sakpen. Le bi mee Yesu ke u ter u. ");
INSERT INTO xon_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Le Yesu dan nan sil jonn u pu, le ki kae iween i joo u na. Le uwon sɔŋ. Libuul ngbaan ni le u fii, ki chann bi tichann. ");
INSERT INTO xon_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tɔ, nwiin aah bi lir na, le binib bimɔk kpa bibum bido na joo ni bi Yesu chee. Le iween aabɔŋ aabɔŋ joo bi. Le u di uŋaal paan bi mɔmɔk pu, ki cha bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Le tiyayaar mu di binib pam lii, ki teen ke, “Aa ye Uwumbɔr Aajapɔɔn la.” Tiyayaar ngbaan bee ke u ye Kristo u gaa binib lii na. Nima pu le u kae ti, kaa cha ti len tibaa. ");
INSERT INTO xon_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Naah woln kichakpinaanyeek ni na, le u nyan nima, ki buen nibaa chee, ki ti bi ubaa. Le kinipaak ngbaan bi ban u. Baah ti kan u na, le bi gaŋ u ke u taa buen cha bi. ");
INSERT INTO xon_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Le u bui bi, “See m buen ntim muken ponn ni, ki ti tuk bi mu Uwumbɔr aanaan aabɔnyaan. Nima le cha Uwumbɔr tun ni mi.” ");
INSERT INTO xon_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","U nan bɔ dii Juu yaab aatim ni, le ki koo mmeen aadir ni, ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Daalbaadaal le Yesu nan si Genesaret Aanyusakpem aagbaan, le kinipaak gob u, ki mueni u, bi ŋun Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Le u kan iŋɔi ilee nnyusakpem aagbaan. Bijanbam aa bi i ponn ni. Bi nan bi nibaa chee, ki bi finni baapɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Le Yesu koo buŋɔb bubaa ponn ni, bu ye Simonn yaab na, le ki bui u ke u foor buen nnyun ponn ni siib. Baah foor siib na, le u kal nima chee buŋɔb na ponn ni, le ki tuk kinipaak ngbaan Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Waah tuk bi ti doo na, le u bui Simonn, “Buen nnyun aah nyoo nin chee na, aan ni ti mee tipɔr ngbaan ki chuu ijan.” ");
INSERT INTO xon_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Le Simonn bui u, “Ndindaan, ti ban ijan kinyeek na mɔk linimaln, kaa kan nibaa. Tɔ, saah len pu na, m ga mee tipɔr na nnyun ni.” ");
INSERT INTO xon_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Le bi mee tipɔr, ki chuu ijan pam. Le tipɔr ngbaan ban ti kar. ");
INSERT INTO xon_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Le bi kab biŋaal ki yin biŋeen aatɔtiib bi bi buŋɔb buken ponn ni na ke bi dan nan ter bi. Le bi dan, ki nan nyan ijan ki gbiin iŋɔi ilee ngbaan mɔmɔk. Nima le cha iŋɔi ngbaan ban i muin. ");
INSERT INTO xon_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simonn Piita aah kan kina na, le u gbaan Yesu aanimbiin ni, ki bui u, “Ndindaan, siir m chee. M ye titunwanbirdaan la.” ");
INSERT INTO xon_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Baah chuu ijan sakpen pu na, le ni gar Simonn ni binib bimɔk bi u chee na, ");
INSERT INTO xon_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ni Sebedee aajapɔtiib Jems ni Jɔnn bi nan ye Simonn aatutuŋeertiib na. Le Yesu bui Simonn, “Taa san ijawaan. Dandana ki joo cha, aa ga li ban binib tii Uwumbɔr la.” ");
INSERT INTO xon_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Le bi dar baaŋɔi cha n‑gbaan, ki di cha ni mɔmɔk, ki dii Yesu. ");
INSERT INTO xon_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu nan bi kitiŋ kibaa ni. Ukɔndaan ubaa mu bi nima. Waah kan Yesu na, le u dan nan gbaan unimbiin ni, ki di unimbil chiŋ kitiŋ, ki gaŋ u, le ki bui u, “Ndindaan, aa yaa gee kan, aa ga ŋmaa cha m pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Le Yesu taln uŋaal ki meeh u, ki bui u, “M gee. Aa pɔɔk.” Libuul ngbaan ni, le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Le Yesu bui u, “Taa tuk unii ubaa. Li cha Uwumbɔr aatotoor chee, ki ti di aabaa mɔk u, ki toor kitork tii Uwumbɔr ke Moses aakaal aah siin pu na. Nima le ga mɔk binib ke aa pɔɔk a.” ");
INSERT INTO xon_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Le Yesu aayimbil moo moon ŋipepel mɔmɔk. Le kinipaak sakpeŋ kuun u chee ke bi ŋun waah len pu na, ki ban ke u cha bi ponn ni bi ye bibum na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","N‑yoonn, n‑yoonn kan, le u ti nya bi chee, ki buen kipɔɔk ni, u ti mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","N‑yoonn ngbaan le Yesu nan bi tuk binib Uwumbɔr aabɔr. Le Farisii yaab ni ikaal aamɔmɔkb bi nyan ni Galilee aatingbaan ni, ni Judea aatingbaan ni, ni Jerusalem na, nan ka u chee. Uwumbɔr aapɔɔn nan bi u chee, le u cha bibum pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Le bijab bibaa luln ni uja u aawon faan na likekeln ni, ki ban bi di u koo ni kidiik ni, ki di u bil Yesu aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Binib aah nan wiir pu na, baa kan mpaan bi koo ni. Le bi jon kidiik ngbaan paab, le ki chee liboln, ki di u di luln ni, ki di u bil kidiik ponn ni, Yesu aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Le Yesu kan baah gaa u ki kii pu na, le ki bui uja u aawon faan na, “Njɔ, m di cha saatunwanbir pinn si.” ");
INSERT INTO xon_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Waah len kina na, le Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab dak bisui ni ke, “U ye ŋma ki sii Uwumbɔr? Ubaa aan ŋmaa di cha pinn titunwanbir see Uwumbɔr baanja.” ");
INSERT INTO xon_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu nan bee baah dak pu na, le ki baa bi, “Ba pu ni dak kina nisui ni? ");
INSERT INTO xon_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Maah len ke m di cha waatunwanbir pinn u na le pɔɔ aan m yaa len ke ‘Fiin ki li chuun’ le pɔɔ? ");
INSERT INTO xon_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","M ga mɔk nimi ke min Unibɔn Aabo kpa mpɔɔn dulnyaa wee ni ke m di cha pinn titunwanbir.” Waah len kina na, le u bui uja u aawon faan na, “M bui si la, fii ki yoor saawandookaan ki li chaa kun.” ");
INSERT INTO xon_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Libuul ngbaan ni le u fii binimbil ni, ki yoor waawandookaan, ki chaa kun, le ki chuun nyuŋni Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Le ni gar bi mɔmɔk pam. Le bi nyuŋ Uwumbɔr, ki san ijawaan, ki bui ke, “Din, le ti kan lijinjiir aawan.” ");
INSERT INTO xon_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nee aapuwɔb, le Yesu nyan nima. Waah cha na le u kan ulampoogaar ubaa, bi nan yin u ke Liifai. U ka baah gaal lampoo nin chee na. Le Yesu bui u, “Li dii mi.” ");
INSERT INTO xon_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Le u di cha waawan mɔmɔk ki fii, ki dii u. ");
INSERT INTO xon_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Le Liifai ŋa tijikaar sakpen waadichal ni ki tii Yesu. Le bilampoogaab pam ni binib biken dan nan ka ji bi chee tijikaar. ");
INSERT INTO xon_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Le Farisii yaab ni Uwumbɔr aakaal aamɔmɔkb bi mu ye Farisii yaab na bi ŋulni, le ki baa Yesu aadidiliib, “Ba ŋa ni ni bilampoogaab ni titunwanbirdam kpaan ki ji tijikaar ki nyu?” ");
INSERT INTO xon_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Le Yesu bui bi, “Binib bi kpa laafee na aa ban dɔkta, see bi bun na le ban dɔkta. ");
INSERT INTO xon_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Maa dan ke m nan yin bininyaam. M dan ke m nan yin titunwanbirdam ke bi nan kpeln baabimbin la.” ");
INSERT INTO xon_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Binib bibaa nan dan ki nan tuk Yesu, “Jɔnn aadidiliib ni Farisii yaab aadidiliib lulni bumɔb kpala kpala, ki mee Uwumbɔr. Le saadidiliib ma ji ki nyu.” ");
INSERT INTO xon_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Le u baa bi, “Ni ga ŋmaa cha bicham bi dan bi nan ji ubɔndinn aajim na lul bumɔb buyoonn upiidinn bi bi chee na aa? Aayii. ");
INSERT INTO xon_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","N‑yoonn choo, le bi ga chuu nyan upiidinn na bi chee mpɔɔn. N‑yoonn ngbaan le bi ga lul bumɔb.” ");
INSERT INTO xon_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Le u ki ŋakl bi liyataŋakl ke, “Ubaa aan chuu gii lekr libɔkupɔln aakekengeln ki ti di leŋ libɔkukpokl. U yaa ŋa kina kan, u ga bii lipɔln na. Libɔkupɔln aageln ni libɔkukpokl ngbaan aa ŋak. ");
INSERT INTO xon_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ubaa mu aan di ndawiin ki di ŋa kilookpok ponn ni. U yaa ŋa kina kan, kilookpok ngbaan ga puu ki bii. Ndaan na mu ga kpir. ");
INSERT INTO xon_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","See bi di ndawiin ŋa kiloopɔŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Unii mu yaa nyu ndakpaan kan, waan ki ban ndapɔm. U ga len ke mu kpok na le mɔ.” ");
INSERT INTO xon_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Juu yaab aakpaakool libaa daal, le Yesu ni waadidiliib bɔ dii kisaak kibaa ponn ni. Le waadidiliib geei tijikaar ki per ki ŋmɔ. ");
INSERT INTO xon_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Le Farisii yaab bibaa nan baa bi, “Ba ŋa ni ŋani kina? Timi aakaal aa kii ke ni ŋa kina likpaakool daal.” ");
INSERT INTO xon_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Le Yesu baa bi, “Naa karn Ubɔr David aah nan ŋa pu na aa? Nkon nan joo u ni waanib. ");
INSERT INTO xon_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Le u koo Uwumbɔr Aadichal ni, ki di Uwumbɔr aaboroboro ŋman, ki joo tii waanib mu, bi ŋman. Baah ŋa kina na, le bi bii Moses aakaal mu len ke Uwumbɔr aatotoorb baanja le ga ŋmɔ boroboro ngbaan na. ");
INSERT INTO xon_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Tɔ, min Unibɔn Aabo le ye likpaakool daal mu Aadindaan.” ");
INSERT INTO xon_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Juu yaab aakpaakool liken daal, le Yesu ki koo mmeen aadiik ni, ki tuk binib Uwumbɔr aabɔr. Le uja u aaŋangii faan na bi nima. ");
INSERT INTO xon_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Le Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab lik Yesu, ke u ga cha u pɔɔk likpaakool daal aan waan cha u pɔɔk. Bi ban bi kan nsan aan ki galn u, ke u bii likpaakool daal. ");
INSERT INTO xon_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Le Yesu bee baalandak, le ki bui uja u aaŋaal faan na, “Dan nan sil do binib aanimbiin ni.” Le u fii ti sil nima. ");
INSERT INTO xon_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Le Yesu baa bi, “Likpaakool daal kan, ti ŋa ni ŋan na aan ni kaa ŋan na? Ti tii unii limɔfal aan ti ku u? Timi aakaal mɔk timi kinye?” ");
INSERT INTO xon_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Le u lik bi mɔmɔk, le ki bui uja u aaŋaal faan na, “Taln aaŋaal.” Le u taln uŋaal. Le mu pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Le bi gee liŋuul Yesu pu pam, le ki kpokl baah ga ŋa u pu na. ");
INSERT INTO xon_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","N‑yoonn ngbaan le Yesu jon lijool paab, u ti mee Uwumbɔr, le ki mee u kinyeek ngbaan ki ti woln kitaak. ");
INSERT INTO xon_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Naah woln kichakpinaanyeek ni na, le u yin waadidiliib ke bi dan u chee, le ki nyan bi ponn ni bijab kipiik ni bilee, ki yin bi ke waakpambalb. ");
INSERT INTO xon_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Baayimbil sɔ; Simonn u Yesu duln u ke Piita na, ni unaal Andru; ni Jems, ni Jɔnn, ni Filip, ni Batolomiu, ");
INSERT INTO xon_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ni Matiu, ni Tomas, ni Jems u ye Alfeus aajapɔɔn na; ni Simonn u nan ban u kuln waatiŋ aadim na; ");
INSERT INTO xon_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ni Judas u ye Jems aajapɔɔn na; ni Judas Iskariot u ga nan kooh Yesu na. ");
INSERT INTO xon_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Le Yesu sunn ni lijool ngbaan paab, ki nan sil nin chee ŋak na. Waakpambalb ngbaan mu bi u chee. Binib bi dii u na mu bi u chee ki wiir. Kinipaak ki nyan ni Judea aatingbaan mɔmɔk ni, ni Jerusalem, ni nnyusakpem aatim Taya ni Saidonn aatingbaan ni na, mu bi nima. ");
INSERT INTO xon_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bi dan ke bi nan ŋun waaliin, ki ban ke u tii bi ponn ni bi ye bibum na laafee. Le u cha bi pɔɔk, ki cha binib bi tiyayaar joo bi na mu pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Le kinipaak ngbaan mɔmɔk ban ke bi di biŋaal meeh u; ba pu? mpɔɔn nyan u ni, ki cha bi mɔmɔk pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu nan lik waadidiliib le ki bui ke: “Nimi bi ye bigiim na, Uwumbɔr aanyoor bi ni pu; nimi le yeh Uwumbɔr aanaan. ");
INSERT INTO xon_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nimi bi nkon joo nimi dandana na, Uwumbɔr aanyoor bi ni pu; ni ga nan ji ki bab. Nimi bi wii dandana na, Uwumbɔr aanyoor bi ni pu; ni ga nan laa. ");
INSERT INTO xon_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Binib yaa nan nimi, ki yakr ni chee, ki sii nimi, ki yin nimi mbiindam, min Unibɔn Aabo pu kan, Uwumbɔr aanyoor bi ni pu. ");
INSERT INTO xon_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bi yaa ŋa nimi kina kan, ni li kpa mpopiin sakpen ki li mɔɔni; ba pu? ni ga nan kan tinyoor sakpen paacham. Kina le biyaajatiib nan ŋa Uwumbɔr aabɔnabtiib falaa. ");
INSERT INTO xon_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nimi biwankpadam, tibɔbir ga li bi ni pu; ba pu? ni puen kan ni mɔ na la. ");
INSERT INTO xon_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nimi bi ji babr dandana na, tibɔbir ga li bi ni pu. Nkon ga nan chuu nimi. Nimi bi laa dandana na, tibɔbir ga li bi ni pu. Ni ga nan li kpa mpombiin ki li wii. ");
INSERT INTO xon_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Binib mɔmɔk yaa pak nimi kan, tibɔbir ga li bi ni pu. Kina le biyaajatiib nan pak biŋmaŋmannim bi nan ŋmanni ke bi ye Uwumbɔr aabɔnabtiib na.” ");
INSERT INTO xon_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“M tuk nimi bi pel na, ni li gee nimi aadim man, ki ŋa binib bi nan nimi na tiŋann, ");
INSERT INTO xon_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ki ŋa Uwumbɔr aanyoor ŋa binib bi seei nimi na pu, ki mee Uwumbɔr tii binib bi ŋa nimi bakaa na. ");
INSERT INTO xon_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Unii yaa faa si kitapak kibaa kan, cha u faa kiken mu. Unii yaa gaa saakekeln aa chee kan, di saabɔkul mu ki kpee u. ");
INSERT INTO xon_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Unii umɔk mee si tiwan na kan, tiin u. Unii yaa yoor saawan kan, taa bui u ke u giini ni. ");
INSERT INTO xon_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Naah ban ke binib li ŋani nimi pu na, ni mu li ŋani bi kina. ");
INSERT INTO xon_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ni yaa gee binib bi gee nimi na baanja kan, ni kpa tinyoor Uwumbɔr chee ee? Titunwanbirdam mu gee binib bi gee bi na la. ");
INSERT INTO xon_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni yaa ter binib bi ter nimi na baanja kan, ni kpa tinyoor Uwumbɔr chee ee? Titunwanbirdam mu ŋani kina la. ");
INSERT INTO xon_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni yaa pinn binib bi ga giin tii nimi na baanja kan, ni kpa tinyoor Uwumbɔr chee ee? Titunwanbirdam mu pinni titunwanbirdam ke bi ki giin baah pinn bi pu na tii bi. ");
INSERT INTO xon_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ni ma kan, ni li gee nimi aadim, ki ŋa bi tiŋann, ki pinn binib tiwan, ki taa ki li ban ni. Le Uwumbɔr ga tii nimi tinyoor sakpen. Ni ga li ye Uwumbɔr u kaa kpa ŋeen aatɔ na aabim. Uma le ŋani titunwanbirdam ni binib bi kaa dooni u na tibulchinn. ");
INSERT INTO xon_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ni li kpa linimbaasaln ke Nite Uwumbɔr aah kpa pu na.” ");
INSERT INTO xon_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ni taa ji binib tibɔr, le Uwumbɔr mu aan ji nimi tibɔr. Ni taa galni binib, le Uwumbɔr mu aan galn nimi. Ni di cha pinn binib man, le Uwumbɔr mu ga di cha pinn nimi. ");
INSERT INTO xon_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tiin binib man, le Uwumbɔr mu ga tii nimi. U ga tii nimi sakpen. Mbamɔn, u ga lee gbiin nimi lisambil, le ki yek yek, ki ki lee kpee, le ki nyii nyii ki moo lee kpee aan li ti bar kpir, aan ki di tii nimi. Naah tii binib pu na, Uwumbɔr mu ga giin kina le ki tii nimi.” ");
INSERT INTO xon_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Le Yesu ŋakl bi liyataŋakl ke, “Ujoon ga ŋmaa mɔk ujoon nsan aa? Bi mɔmɔk bilee aan lir libuul ponn ni ii? ");
INSERT INTO xon_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Unii u bae mbaem na aa jer waamɔmɔkr. Unii umɔk bae mbaem ki chikr na ga li bi ke waamɔmɔkr aah bi pu na la. ");
INSERT INTO xon_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ba ŋa aa lik ki waa lidɔchɔl li bi aana aabo aanimbil ni na, kaa tee waa jaatɔlk u bi aayaan ni na? ");
INSERT INTO xon_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aa yaa kaa waa jaatɔlk u bi aabaa aanimbil ni na kan, aa ga tee ŋa kinye ki bui aana aabo ke, ‘Nna aabo, cha m nyan lidɔchɔl li bi aanimbil ni na?’ Sin uŋmaŋmann, chuu nyan jaatɔlk u bi aanimbil ni na waahr, aan ki li waa mbamɔm, aan ki nan nyan aana aabo yaan ni lidɔchɔl.” ");
INSERT INTO xon_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Busub bu ŋan na aan lu ŋisubil ŋi kaa ŋan na. Busub bu kaa ŋan na mu aan lu ŋisubil ŋi ŋan na. ");
INSERT INTO xon_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Busub aasubil pu, le aa ga bee bu aah ye busub bu na. Binib aa ker saasaa bukokom pu, kaa ker nkakan ichakpeejagar pu. ");
INSERT INTO xon_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ilandak nyaan bi uninyaan aasui ni, le ki cha u len ni ŋan na. Ilandakbir bi mbiindaan aasui ni, le ki cha u len ni bir na. Ba pu? ilandak i gbii unii aasui ni na, ima le u ga len.” ");
INSERT INTO xon_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ba pu ni yin mi ke ‘Dindaan, Dindaan,’ kaa ŋani maah tuk nimi ke ni ŋa pu na? ");
INSERT INTO xon_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Unii umɔk dan m chee, ki ŋun maaliin, ki ŋani kina na, m ga mɔk nimi waah naahn udaan u na. ");
INSERT INTO xon_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U naahn uja u ban u maa kidiik, ki gbii ni nyoo, ki maa lidinyikl ŋitakpal pu na la. Le nwam nyan, ki puu ki yur kidiik ngbaan, le kaa deŋni; ba pu? u maa ki mbamɔm. ");
INSERT INTO xon_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Unii u ŋun maaliin, kaa ŋani kina na naahn uja u maa kidiik kitiŋ pu, kaa puen gbii mbuu ki maa lidinyikl na la. Le nwam nyan ki puu yur ki. Libuul ngbaan ni le ki lir kookoo.” ");
INSERT INTO xon_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Waah len tibɔr timina binib aatafal ni ki ti doo na, le u buen Kapenaum aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Le butɔb aajab nkub aaninkpel ubaa nan kpa unaagbiija ubaa ki gee u sakpen. Le unaagbiija ngbaan bun, ki ban u kpo. ");
INSERT INTO xon_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Le butɔb aajab aaninkpel ngbaan ŋun Yesu aabɔr, le ki tun ni Juu yaab aaninkpiib u chee, bi nan bui u ke u dan nan cha waanaagbiija pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Juu yaab aaninkpiib ngbaan aah fuu ni Yesu chee na, le bi gaŋ u ki bui ke, “Butɔb aajab aaninkpel ŋeer ke aa ter u. ");
INSERT INTO xon_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","U gee timi aanib, ki maa mmeen aadiik tii timi.” ");
INSERT INTO xon_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Le Yesu dii bi buen. Waah ti peen butɔb aajab aaninkpel ngbaan aadichal na, le uninkpel ngbaan tun ni ujɔtiib ke bi tooh u nsan ni, ki ti bui u, “Tidindaan, butɔb aajab aaninkpel ke: Taa ki ŋani falaa, ke waa ŋeer aa dan udo ki koo waadiik ni. ");
INSERT INTO xon_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","U mu aa dak ke u ŋeer u dan aa chee. Aa yaa po sil nsan ni ki len kan, waanaagbiija ga pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Uma ubaa kii uninkpel aamɔb, ki mu ye butɔb aajab aaninkpel la, le ki bui ubaa, ‘Li cha,’ le u buen; ki bui ubaa mu, ‘Dan,’ le u dan; le ki bui waanaagbiija, ‘Ŋa kina,’ le u ŋa.” ");
INSERT INTO xon_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu aah ŋun waah len pu na, le ni gar u pam. Le u fenn ki toŋ kinipaak ki dii u na, le ki bui bi, “M tuk nimi la, maa kee kan unii u bi Israel yaab ponn ni ki gaa mi ki kii mbamɔm kina na.” ");
INSERT INTO xon_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Le binib bi tooh Yesu nsan ponn ni na gir kun butɔb aajab aaninkpel do, le ki ti mui waanaagbiija ngbaan pɔɔk a. ");
INSERT INTO xon_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Naa yunn le Yesu buen kitiŋ kibaa ni, bi yin ki ke Neenn. Le waadidiliib ni kinipaak pam dii u. ");
INSERT INTO xon_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waah peen kitiŋ ngbaan aagoln aabisamɔb na, le u kan uja ubaa kpo, bi tu ni u. Una nan ye ukpopii la. U mu ye ujapɔnbaal la. Le waatiŋ aanib pam mu dii u ki wiir. ");
INSERT INTO xon_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tidindaan aah kan ukpopii ngbaan na, le kinimbaak chuu u. Le u bui u, “Taa ki wii,” ");
INSERT INTO xon_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","le ki too foor duun linikpol na aawandookaan chee, ki meeh ni. Le binib bi tu ni u na sil. Le Yesu bui ke, “Unachipɔɔn, m bui si, fiin.” ");
INSERT INTO xon_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Le uja u kpo na fii kal, ki piin ki bi len. Le Yesu di u tii una. ");
INSERT INTO xon_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Le ijawaan chuu bi mɔmɔk. Le bi nyuŋni Uwumbɔr, ki bui ke, “Uwumbɔr aabɔnabr kpaan bi tikaasisik ni. Uwumbɔr dan u nan ter waanib la.” ");
INSERT INTO xon_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Le bi mooni tibɔr timina itingbaan i bi nima chee na ni, ni Judea aatingbaan mɔmɔk ni, ki mooni Yesu aayimbil. ");
INSERT INTO xon_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jɔnn aadidiliib nan tuk u Yesu aah ŋani pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Le u yin bi ponn ni bilee, le ki tun bi ke bi buen Tidindaan chee, ki ti baa u ke u ye unii u Uwumbɔr aabɔnabtiib nan len ke u ga dan na aan waa ye? Bi ga li ban uken aa? ");
INSERT INTO xon_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Le Jɔnn aadidiliib ngbaan fuu ni Yesu chee ki nan bui u ke, “Jɔnn u muini binib nnyun ni na tun ni timi aa chee ti nan baa si ke, ‘Aa ye unii u Uwumbɔr aabɔnabtiib nan len ke u ga dan na aan saa ye, bee ti ga li ban uken la aa?’” ");
INSERT INTO xon_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","N‑yoonn ngbaan le Yesu cha bibum pam pɔɔk, ki nyan tiyayaar binib ni, ki likr bijoom bi wiir na aanimbil; ");
INSERT INTO xon_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","le ki bui Jɔnn aadidiliib, “Gir buen Jɔnn chee, ki ti tuk u naah ŋun pu ki kan pu na, ke m likr bijoom aanimbil, ki cha biwɔb, ni bikɔndam, ni bitafakpaab pɔɔk, ki fikr binib bi kpo na nkun ni, ki tuk bigiim Uwumbɔr aabɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Unii u kaa joo mi beeni na, Uwumbɔr aanyoor bi u pu.” ");
INSERT INTO xon_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Le Jɔnn aadidiliib aah buen na, Yesu len kinipaak ngbaan chee Jɔnn aabɔr ke, “Naah nan buen Jɔnn chee nteersakpiin ni na, ni nan dak ke ni ga kan kinye? Ni nan dak ke ni ga kan lipul li libuln fiini li na la aa? ");
INSERT INTO xon_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ni nan buen ni ti kan uja u pee tiwanyaan na la aa? Binib bi pee tiwanyaan ki ji mmɔɔn na bi bibɔrb aadichal ni la. ");
INSERT INTO xon_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ni nan buen ni ti kan Uwumbɔr aabɔnabr la aa? Mbamɔn, m tuk nimi la, u jer Uwumbɔr aabɔnabr. ");
INSERT INTO xon_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr bui ke, ‘Maatutunn sɔ. M tun ni u ke u loln ni nsan, ki nan toor nsan siin si.’ Jɔnn le ye ututunn ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","M tuk nimi la, baa kee ma unii ubaa u jer Jɔnn. Le unii u ye uwaatiir Uwumbɔr aanaan ni na jer Jɔnn.” ");
INSERT INTO xon_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Binib mɔmɔk ni bilampoogaab nan ŋun Jɔnn aaliin, ki cha u muin bi nnyun ni. Nima le mɔk ke bi kii ki tii Uwumbɔr aabamɔn. ");
INSERT INTO xon_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farisii yaab ni Uwumbɔr aakaal aamɔmɔkb aa nan cha u muin bi nnyun ni. Nima le mɔk ke bi yii Uwumbɔr aamɔboln. ");
INSERT INTO xon_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tɔ, Yesu nan ki bui kinipaak ngbaan ke, “M ga di ba ki di ŋaŋ dandana aanib ngbaan? Bi bi ke ba na? ");
INSERT INTO xon_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bi bi ke mbim mu ka kinyaŋ ni ki tuk biŋeen aatɔtiib, ‘Ti pii ŋiwul le ki tii nimi, le naa saar. Ti wii ikpowiil, le naa kaani.’ ");
INSERT INTO xon_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Dandana aanib ngbaan mu bi kina la; Jɔnn nan dan ki nan lul bumɔb, kaa nyu ndaan, le bi bui ke u kpa kinimbɔŋ. ");
INSERT INTO xon_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Min Unibɔn Aabo dan le ki ji ki nyu, le bi bui ke m ye upusakpiindaan ki ye udanyur, ki jɔnni bilampoogaab ni titunwanbirdam la. ");
INSERT INTO xon_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tɔ, binib bimɔk kpa nlan mbamɔm na, bi bee ke Uwumbɔr aah ŋani pu na, ni ŋan.” ");
INSERT INTO xon_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisii aanii ubaa nan bui Yesu ke u dan nan ji u chee tijikaar. Le u koo waadichal ni, ki kal ki bi ji. ");
INSERT INTO xon_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Le upii u ye titunwanbirdaan na bi kitiŋ ngbaan ni, ki ŋun ke Yesu ka ji tijikaar Farisii aanii ngbaan do. Le u joo ni nkpan mu nun mɔ na, kpalba nyaan u bi yin u ke alabasta na ponn ni, ");
INSERT INTO xon_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","le ki dan nan sil Yesu aapuwɔb, utaa chee, le ki wii, ki cha tinyunyunn lir Yesu aataa pu, ki finn utaa, le ki joo waayikpir per utaa, ki moor utaa, ki di tulalee ngbaan ŋmir utaa. ");
INSERT INTO xon_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisii aanii ngbaan aah kan kina na, le u dak usui ni ke, “Uja wee yaa sil ye Uwumbɔr aabɔnabr kan, u ba ga bee upii u meeh u na aabimbin aah bi pu na, ke u ye titunwanbirdaan la.” ");
INSERT INTO xon_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Le Yesu tuk Farisii aanii ngbaan ke, “Simonn, m ban m bui si tibɔr tibaa la.” Le u bui u, “Umɔmɔkr, lem.” ");
INSERT INTO xon_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Le Yesu bui u, “Bijab bilee le nan bi, le ki joo uwankpadaan aapɔln. Ubaa joo waapɔln ŋimombil ŋi ŋeer iwiin ikui iŋmu aapal na, ubaa mu joo waapɔln ŋimombil ŋi ŋeer iwiin piiŋmu aapal na. ");
INSERT INTO xon_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bi mɔmɔk bilee aah kaa kpa nibaa bi giin tii u na, le u di cha pinn bi mɔmɔk. Bijab bilee ngbaan ponn ni, ulau ga li gee u ki jer uken?” ");
INSERT INTO xon_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Le Simonn bui u, “Waah di cha pinn unii u aapɔln wiir na le ga li gee u ki jer u aapɔln kaa wiir na.” Le Yesu bui u, “Aa len mbamɔn la,” ");
INSERT INTO xon_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","le ki fenn toŋ upii ngbaan, ki bui Simonn, “Aa kan upii wee ee? M koo ni saadichal ni, le saa tii mi nnyun ke m finn ntaa. Upii wee ma kan, u di tinyunyunn le finn ntaa, ki di waayikpir per ntaa. ");
INSERT INTO xon_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Saa moor ntakpiln. Uma le moor ntaa buyoonn m koo ni na ki nan saa dandana. ");
INSERT INTO xon_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Saa di nkpan ŋmir n‑yil. Uma le di tulalee ŋmir ntaa. ");
INSERT INTO xon_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","M tuk si la, m di cha waatunwanbir ti wiir na ki pinn u. Nima le cha u gee mi sakpen. M yaa di cha pinn unii titunwanbir siib na kan, udaan ga li gee mi siib la.” ");
INSERT INTO xon_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu nan bui Simonn kina, le ki tuk upii ngbaan, “M di cha pinn si saatunwanbir la.” ");
INSERT INTO xon_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Le binib bi bi ji u chee tijikaar na baa bibaa bisui ni, “U ye ŋma ki di cha pinn titunwanbir?” ");
INSERT INTO xon_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Le Yesu bui upii ngbaan, “Saah gaa mi ki kii pu na, nima le cha aa ŋmar. Li cha ki li kpa nsuudoon.” ");
INSERT INTO xon_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Naa yunn le Yesu bɔ dii ntisakpem ni ntiwaatiir ni, ki mooni Uwumbɔr aanaan aabɔnyaan tee. Waakpambalb kipiik ni bilee mu dii u. ");
INSERT INTO xon_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bipiib bi u nan cha bi pɔɔk na mu dii u. Iween le nan joo bibaa. Tiyayaar mu nan joo biken. Bi ponn ni ubaa nan ye Mari, u bi yin u ke Magdalene na. Tiyayaar tilole le nan joo u, le Yesu nan jenn nyan ti u ni. ");
INSERT INTO xon_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bi ponn ni ubaa mu ye Joana, u ye Ubɔrkpaan Herod aatutunn Chusa aapuu na. Ubaa mu ye Susana. Bipiib biken mu nan bi ki dii u ki wiir. Le bi mɔmɔk di baawan ter u ni waakpambalb. ");
INSERT INTO xon_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Le binib nyan itingbaan mɔmɔk ni, ki dan Yesu chee, ki ŋa kinipaak sakpeŋ. Le u ŋakl bi liyataŋakl: ");
INSERT INTO xon_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ukpaal ubaa nan buen u ti yaa njikaabim. Waah yaa na, le mubaa lir nsan ponn ni. Le binib taa taa mu pu. Le inyoon i laani paacham na dan nan peei jin. ");
INSERT INTO xon_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Le mubaa mu lir ntakpateer pu. Le mu guu punn mala, ki mu ki yɔl mala; ba pu? nima chee aa soon. ");
INSERT INTO xon_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Le mubaa mu lir ikokon ponn ni. Le mu ni ikokon kpaan muun. Le ikokon ku mu. ");
INSERT INTO xon_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Le mubaa mu lir kitiŋ ki ŋan na ponn ni, ki muun, ki mar, ki lu nkub nkub.” Yesu aah len kina ti doo na, le u teen ke, “U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Le waadidiliib dan ki nan baa u liyataŋakl ngbaan aatataa. ");
INSERT INTO xon_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Le u bui bi, “Uwumbɔr le cha ni bee waanaan aabɔbɔrkaan. Biken ma kan, u ŋak bi ŋiyataŋak, aan bi lik, kaan li waa, ki pel, kaan bee naatataa.” ");
INSERT INTO xon_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Liyataŋakl ngbaan aatataa le ye ke njikaabim ngbaan le ye Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mu lir nsan ponn ni na le ye binib bi ŋun Uwumbɔr aabɔr na. Le kinimbɔŋ dan nan nyan ti bisui ni, bi taa gaa Uwumbɔr ki kii, ki ŋmar. ");
INSERT INTO xon_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mu lir ntakpateer pu na le ye binib bi ŋun Uwumbɔr aabɔr ki gaa ti ni mpopiin na. Bi mu aa gaa ti bisui ni mbamɔm. Bi gaa Uwumbɔr ki kii ni yunn siib; tɔ, ntɔŋ yaa pii bi kan, le bi ga di u lii. ");
INSERT INTO xon_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mu lir ikokon ponn ni na le ye binib bi ŋun Uwumbɔr aabɔr aan ki cha bitafal bi liwankpal ni, ni dulnyaa ni aawan ni mɔ na ni, ni baabimbin aabɔr ni na. Nima le ku tibɔr ngbaan bisui ni. Le taa mar. ");
INSERT INTO xon_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mu lir kitiŋ ki ŋan na ponn ni na le ye binib bi aasui ŋan ki ye mbamɔn na, ki ŋun Uwumbɔr aabɔr, ki joo ti mbamɔm, ki kpa limɔr, ki dii Uwumbɔr kaa di cha na.” ");
INSERT INTO xon_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Unii yaa see karyaa kan, waan di lisambil ki di chiŋ u pu, kaan di siin tiwandookaan aataab. U ga di u tɔŋ tiwan paab la, le u li wiin aan binib bimɔk koo ni na li waa. ");
INSERT INTO xon_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Tibɔr timɔk bɔɔ na, ti ga kpiir. Tibɔbɔrkaan mɔmɔk mu ga nyan mpaan pu. ");
INSERT INTO xon_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Cha nitafal li bi naah ŋun pu na ni man. Unii u kpa na, Uwumbɔr ga kpee u. Unii u kaa kpa na, Uwumbɔr ga chuu gaa waah dak ke u kpa ti na.” ");
INSERT INTO xon_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu aana ni unaatiib nan fuu ni ki ban u. Kinipaak ngbaan pu le baa ŋmaa koo ni u chee. ");
INSERT INTO xon_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Le bibaa tuk u, “Aana ni aanaatiib si lipaal ki ban si la.” ");
INSERT INTO xon_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Le u bui bi, “Nna ni nnaatiib le ye binib bi ŋun Uwumbɔr aabɔr ki ŋani taah len pu na.” ");
INSERT INTO xon_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","N‑yoonn ngbaan le Yesu ni waadidiliib koo buŋɔb ni. Le u bui bi, “Cha ti puur nnyusakpem man.” Le bi buen. ");
INSERT INTO xon_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Buŋɔb na aah cha na, le u dɔ bu ponn ni geen. Le kibuŋ piin ki daar. Le nnyun feei ki koo buŋɔb na ni, le bu ban bu gbii. Ni nan ye linimaln la. ");
INSERT INTO xon_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Le bi dan ki nan finn Yesu ki bui ke, “Tidindaan, Tidindaan, ti ga bee nnyun ni.” Le u finn, ki kae kibuŋ ni tinyunkpenn. Le kibuŋ ni tinyunkpenn ŋmin chii. ");
INSERT INTO xon_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Le u baa bi, “Ba pu naa gaa mi ki kii?” Yesu aah ŋa pu na, le ni gar bi pam. Le ijawaan chuu bi. Le bi baa tɔb, “Ba aanibol bi na, ki kae kibuŋ ni nnyun mu, aan ni kii waamɔb.” ");
INSERT INTO xon_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bi nan fuu Gerasiin yaab aatiŋ ki bi Galilee Aanyusakpem aadapuul na. ");
INSERT INTO xon_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Le uwaar ubaa nan bi nima, ki chuun uŋmeen ni yunn, ki koo baah sui binib titakpalunn ti ponn ni na, kaa kii u li bi linampal. Tiyayaar chur u kpala kpala. Le udoyaab nan di idɔribi ni tikululn buu u ke bi kiir u. Le u nan keei tikululn ni idɔribi ngbaan. Tiyayaar ngbaan le di u buen nteersakpiin ni. Le Yesu aah nyan buŋɔb ni na, uja ngbaan dan nan tooh u nsan pu. Le Yesu tuk tiyayaar ngbaan, “Nyan u ni.” Nima pu na, waah kan Yesu na, le u teen, ki gbaan kitiŋ, unimbiin ni, le ki len mpɔɔn pu ke, “Yesu, sin u ye Uwumbɔr u kaa kpa ŋeen aatɔ na Aajapɔɔn na, aa ban ba m chee? M gaŋ si, taa ŋa mi falaa.” ");
INSERT INTO xon_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Le Yesu baa u, “Bi yin si ke ba?” Tiyayaar pam aah bi u ni na, nima le u bui ke bi yin u ke Kipaak. ");
INSERT INTO xon_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Le tiyayaar ngbaan gaŋ Yesu ke u taa bui ti ke ti buen libuul li nyoo na ni. ");
INSERT INTO xon_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Igbeer nan bi nima chee ki wiir, ki chuun ji limɔɔgongoln paab. Le tiyayaar ngbaan gaŋ Yesu ke u cha ti koo igbeer ngbaan ni. Le u kii. ");
INSERT INTO xon_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Le ti nyan uja ngbaan ni, ki ti koo igbeer na ni. Le igbeer ngbaan mɔmɔk san sunn ni limɔɔgongoln taab, ki ti koo nnyun ni, ki bee nnyun ni. ");
INSERT INTO xon_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tɔ, bijab bi kii igbeer ngbaan na aah kan kina na, le bi san buen kitiŋ ni, ni itingbaan ni, le ki ti tuk binib tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Binib aah ŋun kina na, le bi dan bi nan lik budabu ŋa na, le ki fuu ni Yesu chee, ki kan uja u tiyayaar nyan u ni na ka Yesu chee ki cheer ki pee tiwanpeenkaan, kaa ki chuun uŋmeen. Le ijawaan chuu bi. ");
INSERT INTO xon_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Le binib bi kan Yesu aah cha uja ngbaan pɔɔk pu na, tuk bi waah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Le Gerasiin aatiŋ aanib, ni itingbaan mɔmɔk aanib san ijawaan pam. Nima le bi gaŋ Yesu ke u nya baatiŋ ni. Le u koo buŋɔb ni ke u gir buen nnyusakpem aadapuul. ");
INSERT INTO xon_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Le uja u tiyayaar nyan u ni na gaŋ Yesu ke u cha u dii u. Le Yesu aa kii, ki bui u, ");
INSERT INTO xon_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gir kun ki ti tuk binib Uwumbɔr aah tun litukpaan tii si pu na.” Le u siir, ki bɔ dii waatiŋ ngbaan ni, ŋipepel mɔmɔk, ki tuk binib Yesu aah tun litukpaan pu tii u na. ");
INSERT INTO xon_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu aah puur nnyusakpem na, kinipaak nan si kii u nima, ki kpa mpopiin ki gaa u. ");
INSERT INTO xon_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Le uja ubaa, u ye mmeen aadiik ni aaninkpel, aan bi yin u ke Jairus na, dan nan gbaan kitiŋ Yesu aanimbiin ni, ki gaŋ u ke u dan udo, ");
INSERT INTO xon_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ke ubisabaan, u ye ŋibin kipiik ni ŋilee na bun, ki ban u kpo. Le Yesu dii u ki buen. Waah cha na, le kinipaak dii u ki mueni u. ");
INSERT INTO xon_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Le upii u fu tipiir ŋibin kipiik ni ŋilee taa door na bi nima. U nan chaa biteteeb chee, ki jin waamombil mɔmɔk doo. Bi ponn ni ubaa mu aa ŋmaa cha u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Le u dan Yesu aapuwɔb, le ki nan meeh waabɔkul aamɔjuul. Libuul ngbaan ni le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Le Yesu baa ke, “Ŋma meeh mi?” Le bi mɔmɔk nee ke baa meeh u. Le Piita ni binib bi bi u chee na bui u, “Ndindaan, kinipaak ngbaan mɔmɔk bi aa chee ki mueni si kina, le aa baa ke ŋma meeh si?” ");
INSERT INTO xon_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Le Yesu bui ke, “Unii ubaa le meeh mi. M bee ke mpɔɔn nyan m ni.” ");
INSERT INTO xon_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Le upii ngbaan nan bee ke waa bɔr. Ijawaan nan chuu u, le uwon gbaa. Le u dan nan gbaan Yesu aanimbiin ni, ki tuk u binib mɔmɔk aanimbil ni, budabu cha u meeh u na, ni waah pɔɔk libuul ngbaan ni pu na. ");
INSERT INTO xon_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Le Yesu bui u, “Mbisal, saah gaa mi ki kii na, nima le cha aa pɔɔk. Li cha ni mpopiin.” ");
INSERT INTO xon_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu aah len kina na, le unii ubaa nyan ni Jairus do ki tooh Jairus nsan pu, ki nan tuk u ke, “Aabisal kpo a. Taa ki cha Umɔmɔkr ngbaan ŋani falaa ki cha aado.” ");
INSERT INTO xon_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Le Yesu ŋun waah len pu na, ki bui Jairus, “Taa san ijawaan. Aa yaa ŋa naadii baanja kan, u ga pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu aah fuu Jairus do na, le waa cha unii ubaa dii u ki koo ni, see Piita, ni Jɔnn, ni Jems, ni upiibo ngbaan aate ni una. ");
INSERT INTO xon_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Le binib bi mɔmɔk bi lichiln ni na bi wii ikpowiil ki kaani. Le Yesu bui bi, “Taa wii man. Waa kpo. U geen la.” ");
INSERT INTO xon_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Le bi laa u pam. Bi bee ke u kpo la. ");
INSERT INTO xon_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Le Yesu chuu uŋaal ki bui u, “Upiibo, fiin.” ");
INSERT INTO xon_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","56","Libuul ngbaan ni le waawiin ki gir koo u ni, le u fii. Le ni gar ute ni una pam. Le Yesu bui bi ke bi taa tuk unii ubaa waah ŋa pu na, le ki bui bi ke bi tii ubo ngbaan tijikaar u ji. ");
INSERT INTO xon_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu nan yin ni waadidiliib kipiik ni bilee ke bi kuun ni u chee, le ki tii bi mpɔɔn bi ti nyan tiyayaar aabɔŋ mɔmɔk binib ni, ki mu cha bibum pɔɔk; ");
INSERT INTO xon_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","le ki tun bi, bi ti li tuk binib Uwumbɔr aanaan aabɔr, ki cha bibum pɔɔk, le ki bui bi, ");
INSERT INTO xon_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Ni taa li tu lisachuln aatuln libaa. Ni taa li joo kijaangbeek, ki taa li joo litaakɔr, ki taa li joo tijikaar, ki taa li joo ŋimombil, ki taa li joo ŋibɔkul ŋilee. ");
INSERT INTO xon_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Naah ti koo lidichal li ponn ni na, ni li bi li ponn ni ki ti saa bundaln ni ga nyan kitiŋ ngbaan ponn ni na. ");
INSERT INTO xon_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kitiŋ kibaa aanib yaa kaa gaa nimi kan, ni nyan nima ki kpaar nitaa aatatan ki lii nima. Nimina le ga li ye nsurm ki tii bi.” ");
INSERT INTO xon_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesu aah tuk waadidiliib kina ki doo na, le bi siir ki bɔ dii ntim ni, ki mooni tibɔnyaan tee. Baah buen nimɔk na, le bi cha bibum pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ubɔr Herod nan ŋun Yesu aah ŋa pu na, kaa nyi waah ye udaan u na. Bibaa len ke Jɔnn le fikr nkun ni, ");
INSERT INTO xon_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bibaa mu len ke Elaija, bibaa mu len ke n‑yaayoonn na aabɔnabr ubaa le fikr. ");
INSERT INTO xon_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Le Herod bui ke, “M nan chuu gii Jɔnn aayil. Maah ŋun u aabɔr na, u ye ŋma?” le ki ban ke u kan u. ");
INSERT INTO xon_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Le Yesu aakpambalb ki gir ni, ki nan tuk u baah ŋa pu na. Le u di bi buen Betseda aatiŋ ni, bima bibaa. ");
INSERT INTO xon_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Le kinipaak ngbaan ŋun ke u buen nima. Le bi mu paan u pu. Le u gaa bi, ki tuk bi Uwumbɔr aanaan aabɔr, le ki cha bi ponn ni bi ye bibum na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nwiin aah ban mu lir na, le waakpambalb kipiik ni bilee na dan nan bui u, “Ti bi kipɔɔk ni la; cha kinipaak ngbaan buen itingbaan ni, ki ti ban tijikaar ni nkookoo yaan.” ");
INSERT INTO xon_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Le u bui bi, “Nimi nibaa tii bi tijikaar man, bi ji.” Le bi bui u, “Ŋiboroboro kpin ŋiŋmu ni ijan ilee baanja le bi. Aa ban ke ti buen ti daa tijikaar ti ga ŋeer binib ngbaan mɔmɔk na aa?” ");
INSERT INTO xon_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bijab ngbaan ga nan li fuu ŋichur ŋiŋmu. Le u bui waakpambalb ke bi cha kinipaak ngbaan kal kitiŋ ŋikpuk ŋikpuk, piiŋmu piiŋmu. ");
INSERT INTO xon_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Le waakpambalb ŋa kina, ki cha bi mɔmɔk kal. ");
INSERT INTO xon_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Le u yoor ŋiboroboro kpin ŋiŋmu, ni ijan ilee ngbaan, le ki waan lik paacham, ki doon Uwumbɔr, ki gii, le ki di tii waakpambalb ke bi yakr siin kinipaak ngbaan mɔmɔk aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Le bi mɔmɔk ŋman ki bab. Baah ŋman ki bab ki gur ni na, le waakpambalb yoor tijikaar ti gur na, ki gbiin tibɔɔkur kipiik ni tilee. ");
INSERT INTO xon_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kitaak kibaa daal, le Yesu nan bi mee Uwumbɔr ubaa. Waadidiliib mu bi u chee. Le u baa bi, “Kinipaak ngbaan bui ke m ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Le bi bui u, “Bibaa len ke aa ye Jɔnn u nan muini binib nnyun ni na, le biken mu len ke aa ye Uwumbɔr aabɔnabr Elaija u nan bi n‑yaayoonn na la; biken mu len ke n‑yaayoonn na aabɔnabr ubaa le fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Le u baa bi, “Nimi nibaa len ke m ye ŋma?” Le Piita bui u, “Aa ye Uwumbɔr Aanii Kristo u ga gaa timi lii na la.” ");
INSERT INTO xon_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Le u sur bi mbamɔm ke bi taa tuk unii ubaa, ");
INSERT INTO xon_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","le ki bui bi, “Min Unibɔn Aabo ga ji falaa sakpen. Juu yaab aaninkpiib, ni Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb ga yii mi, ki ku mi. Iwiin itaa daal le Uwumbɔr ga fikr mi nkun ni.” ");
INSERT INTO xon_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tɔ, u nan bui waadidiliib ni kinipaak ngbaan, “Unii yaa ban u dii mi kan, u yii ubaa, ki yoor waadɔpuinkoo iwiin mɔmɔk aan ki li dii mi. ");
INSERT INTO xon_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Unii umɔk kaan ŋmaa kpo m pu na kan, waamɔfal ga bee yɔli la. Unii umɔk ga ŋmaa kpo m pu na kan, u ga kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Unii yaa kan dulnyaa wee ni aawan mɔmɔk, ki lann waamɔfal, ki wɔŋ kan, ba aanyoor le u kan? ");
INSERT INTO xon_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Unii yaa san inimɔɔn m ni maaliin chee u tuk binib biken kan, min Unibɔn Aabo ga nan yii udaan ngbaan. M ga gir ni, ki li kpa m ni Nte Uwumbɔr aapɔɔn. Uwumbɔr aatuuntiib bi ye chain na mu ga nyuŋ mi. N‑yoonn ngbaan le m ga yii udaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","M tuk nimi mbamɔn la, binib bi si do na ponn ni bibaa aan kpo see bi puen kan Uwumbɔr aanaan waahr.” ");
INSERT INTO xon_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Waah len kina na, ni naahn iwiin iniin aapuwɔb le u di Piita, ni Jɔnn, ni Jems, ki di jon lijool paab, u ti mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waah bi mee Uwumbɔr na, le unimbil wɔb kpeln. Le waawanpeenkaan mu kpaln tiwanpipiln ni ga li deer aanimbil na. ");
INSERT INTO xon_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Le bi kan bijab bilee bi wiin chain na bi len u chee tibɔr. Bi nan ye n‑yaayoonn na aabɔnabtiib Moses ni Elaija la. Bi nan len waah ga ŋa Uwumbɔr aageehn ki kpo Jerusalem ponn ni pu na. ");
INSERT INTO xon_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Le ngeen joo Piita mam. Baah finn na, le bi kan Yesu aah wiin chain pu na, ki kan bijab bilee bi si u chee na. ");
INSERT INTO xon_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bijab bilee ngbaan aah siir cha u na, le Piita bui u, “Ndindaan, taah bi do na, ni ŋan. Cha ti ŋa ŋiboo ŋitaa, ki di libaa tii si, ki di liken tii Moses, ki di liken tii Elaija.” Piita aah len kina na, waa nyi waah len ti cha ni wɔb na. ");
INSERT INTO xon_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Waah laa bi len kina na, le ntaalangbam dan nan biin bi pu. Mu aah biin bi pu na, le ijawaan chuu Yesu aadidiliib ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Le nneel len ntaalangbam na ni ke, “Maabo u m lee u na sɔ. Li ŋun waah len pu na man.” ");
INSERT INTO xon_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nneel ngbaan aah len ki ti doo na, bi nan kan Yesu baanja le si. Le bi joo tibɔr ngbaan bima baanja, kaa tuk unii ubaa n‑yoonn ngbaan baah kan pu na. ");
INSERT INTO xon_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kitaak aah woln na, le bi sunn ni lijool ngbaan taab. Le kinipaak sakpeŋ tooh u nsan ni. ");
INSERT INTO xon_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Le kinipaak ngbaan ponn ni uja ubaa teen ke, “Umɔmɔkr, m gaŋ si, san njapɔɔn kinimbaak. U ye maabobaal la. ");
INSERT INTO xon_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Libimbikl le lir u ki cha u tar, ki cha uwon gbaa, le umɔb ponn ni puk tipupukr, ki liin u nsin sakpen, kaa ban li di u lii. ");
INSERT INTO xon_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","M gaŋ saadidiliib ke bi nyan u libimbikl ngbaan. Bi mu aa ŋmaa nyan u.” ");
INSERT INTO xon_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Le Yesu bui ke, “Nimi dandana aanib, naa gaa Uwumbɔr ki kii, ki mu aa dii u mbamɔm. Ni ban ke m yunn ni chee kinye pu, aan ki li kpa limɔr ni pu?” le ki tuk ubo ngbaan aate, “Li joo ni aajapɔɔn ngbaan m chee.” ");
INSERT INTO xon_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Le ubo ngbaan aah choo na, libimbikl lii u kitiŋ, le ki cha uwon gbaa sakpen. Le Yesu kae libimbikl ngbaan, ki cha ubijabo ngbaan pɔɔk, le ki di u giin tii ute. ");
INSERT INTO xon_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Baah kan Uwumbɔr aah kpa mpɔɔn sakpen pu na, le ni gar kinipaak ngbaan mɔmɔk pam. Naah gar binib ngbaan mɔmɔk kina na, le Yesu bui waadidiliib, ");
INSERT INTO xon_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Bi ga di min Unibɔn Aabo ŋa binib aaŋaal ni la. Cha tibɔr timina koo nitafal ni man.” ");
INSERT INTO xon_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Le baa bee taatataa. Uwumbɔr le bɔr taatataa ke bi taa bee. Le baa kaa ke bi baa Yesu taatataa. ");
INSERT INTO xon_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Le waadidiliib kpak tɔb kinikpakpak ke ulau ye uninyuun bi ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Le Yesu bee baah dak pu na, le ki di ubo siin ubaa chee, ");
INSERT INTO xon_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","le ki tuk bi, “Unii umɔk gaa ubo wee maayimbil pu na kan, u gaa mi le na. Unii umɔk gaa mi na kan, u gaa Uwumbɔr u tun ni mi na le na. Unii u ye uwaatiir ni ponn ni na, uma le ye uninyuun.” ");
INSERT INTO xon_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Le Jɔnn tuk Yesu, “Ndindaan, ti kan unii ubaa nyan tiyayaar binib ponn ni, saayimbil pu. U mu aa dii timi, nima le ti bui u ke u di cha.” ");
INSERT INTO xon_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Le Yesu bui u, “Taa ki tuk u ke u di cha. Unii u kaa ye nimi aadin na si nichaŋ ni la.” ");
INSERT INTO xon_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bundaln Yesu ga gir buen paacham na peen ni. Le u pɔɔk ubaa ke u buen Jerusalem, ");
INSERT INTO xon_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","le ki tun bitutum ke bi loln u pu nsan. Le bi buen, le ki ti fuu Samaria yaab aatiŋ kibaa ponn ni, bi ti gor kiir u. ");
INSERT INTO xon_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Le kitiŋ ngbaan ni aanib kan ke u ban u buen Jerusalem. Nima le bi yii u. ");
INSERT INTO xon_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Waadidiliib Jems ni Jɔnn aah kan ke bi yii u na, le bi baa u, “Tidindaan, aa ban ke ti mee Uwumbɔr aan mmii nyan paacham ki gaa bi ke Elaija aah nan ŋa pu na aa?” ");
INSERT INTO xon_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu nan fenn toŋ Jems ni Jɔnn le ki kae bi, ki bui bi, “Naa nyi Mfuur Nyaan mu yeh nimi na aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Min Unibɔn Aabo aa dan m nan ku binib. M dan ke m nan gaa bi lii la.” Le bi buen kitiŋ kiken ni. ");
INSERT INTO xon_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Baah cha na, le uja ubaa dan nan bui Yesu, “M ga dii si saah cha nin chee na mɔk.” ");
INSERT INTO xon_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Le Yesu bui u, “Iŋɔk kpa yaah koo ibuu i ponn ni na. Inyoon i laani paacham na mu kpa yaadil. Min Unibɔn Aabo aa kpa maah ga doon nin chee na.” ");
INSERT INTO xon_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Le Yesu tuk uja uken, “Li dii mi.” Le u bui u, “Ndindaan, m mee si nsan, cha m buen ti sub nte waahr, aan ki nan dii si.” ");
INSERT INTO xon_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Le Yesu bui u, “Cha bitekpiib sub tɔb. Si ma kan, aa li cha ti moon Uwumbɔr aanaan aabɔr.” ");
INSERT INTO xon_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Le uja uken mu tuk Yesu, “Ndindaan, m ga dii si la. M mu mee si nsan, cha m buen ti chɔi maachiln ni aanib waahr, aan ki nan dii si.” ");
INSERT INTO xon_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Le Yesu bui u, “Unii yaa joo unaaja ko kisaak ki lik puwɔb kan, waa ŋeer Uwumbɔr aanaan ni aatuln.” ");
INSERT INTO xon_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nee aapuwɔb le Tidindaan nyan bijab imonko itaa ni kipiik ki kpee, le ki tun bi bilelee ke bi loln u pu nsan, ki ti koo waah ga buen ntim mu mɔmɔk ni na. ");
INSERT INTO xon_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","U bui bi, “Idi biir le ki wiir. Bidicheeb aa wiir. Nima pu na, ni li mee kisaak aadindaan man ke u tun bidicheeb bi ti chee waajikaar. ");
INSERT INTO xon_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Li cha man. Maah tun nimi na, ni ga li bi ke ipihbi i bi ŋisapol aakaasisik ni na la. ");
INSERT INTO xon_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni taa li joo ŋimombil aataakɔr, ki taa tun ŋitun, ki taa li joo ŋinaatak, ki taa sil nsan ni ki doon unii ubaa. ");
INSERT INTO xon_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ni yaa koo lidichal ni kan, njan aawan le ye ke ni bui bi, ‘Uwumbɔr aanyoor bi lidichal lee aanib pu.’ ");
INSERT INTO xon_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uninyaan yaa bi nima chee kan, Uwumbɔr aanyoor ga li bi u pu. Uninyaan yaa kaa bi kan, Uwumbɔr aanyoor ga gir ni ni pu. ");
INSERT INTO xon_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lidichal libaa aanib yaa gaa nimi kan, ni li bi nima ki ti saa buyoonn ni ga nan nya na, ki taa jir lidichal. Ni li ji ki li nyu baah ga tii nimi ni na; ututunn mɔmɔk ŋeer waapar. ");
INSERT INTO xon_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ni yaa koo kitiŋ kibaa ni aan bi gaa nimi kan, ni li ji baah ga tii nimi ni na, ");
INSERT INTO xon_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ki bui bi ke, ‘Uwumbɔr aanaan peen ni nimi la,’ ki cha bibum bi bi nima na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ni yaa koo kitiŋ kibaa ni, aan baa gaa nimi kan, ni bɔ dii ki ponn ni ki bui ke, ");
INSERT INTO xon_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nimi aatiŋ aatatan ti bi titaapɔtan ni na, tima le ti kpaar lii do chee na, ni li ye nsurm ki tii nimi. Ni li nyi ke Uwumbɔr aanaan peen ni, le ni yii.’ ");
INSERT INTO xon_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","M tuk nimi la, bundaln Uwumbɔr ga ji binib tibɔr na, binib ngbaan aatafadaan ga jer Sodom aatiŋ aanib aatafadaan.” ");
INSERT INTO xon_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasinn aatiŋ aanib, tibɔbir bi ni pu. Betseda aatiŋ aanib, tibɔbir bi ni mu pu; ba pu? m yaa ba nan tun lijinjiir aatun Taya ni Saidonn aatim aanib aakaasisik ni ke maah tun lijinjiir aatun nikaasisik ni pu na kan, bi ba ga kpeln baabimbin ni yunn, ki li pee tiwanpeenkaan ni saak kuub na, ki di nfatan puŋ biyil, aan ki mɔk ke bisui bii baatunwanbir pu. ");
INSERT INTO xon_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bundaln Uwumbɔr ga ji binib tibɔr na, nimi aatafadaan ga jer Taya aatiŋ aanib ni Saidonn aatiŋ aanib aatafadaan. ");
INSERT INTO xon_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nimi Kapenaum aatiŋ aanib ma kan, bi ga yoor nimi paacham aa? Aayii. Bi ga sunn nimi tataab tataab la.” ");
INSERT INTO xon_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu nan tuk waadidiliib, “Unii u ŋun nimi aabɔr na kan, u ŋun maabɔr le na. Unii u yii nimi na kan, u yii mi le na. Unii u yii mi na kan, u yii Uwumbɔr u tun ni mi na le na.” ");
INSERT INTO xon_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Le bijab imonko itaa ni kipiik ngbaan gir ni Yesu chee ni mpopiin, ki nan bui u, “Tidindaan, tiyayaar mu kii timi aamɔb, saayimbil pu.” ");
INSERT INTO xon_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Le u bui bi, “M kan kinimbɔŋ nyan ni paacham ki ŋa yɔli ke utaal aah moor ki lir pu na. ");
INSERT INTO xon_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Lik man, m tii nimi mpɔɔn, ni ti taa ikuub ni inyoohn pu, ki tii nimi mpɔɔn, ni nyaŋ timi aadin kinimbɔŋ aapɔɔn mɔmɔk, le tiwan nibaa aan ŋmaa ŋa nimi nibaa. ");
INSERT INTO xon_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tɔ, tiyayaar aah kii nimi aamɔb na, ni taa cha nima baanja le li ye nimi aapopiin. Nimi aayimbil aah ŋmee paacham na le ye mpopiin mbamɔm.” ");
INSERT INTO xon_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","N‑yoonn ngbaan le Uwumbɔr Aafuur Nyaan cha Yesu kpa mpopiin pam, ki bui ke, “Nte Uwumbɔr u ye paacham ni taab Aadindaan na, aa bɔr tibɔr timina bilankpalb ni binimbiwolm, le ki di mɔk chapɔntiib, nima le m pak si. Nte, saageehn le na, nima le cha aa ŋa kina. ");
INSERT INTO xon_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nte Uwumbɔr le tii mi tiwan mɔmɔk. Ubaa aa nyi min Uwumbɔr Aajapɔɔn aah ye udaan u na, see Nte Uwumbɔr. Ubaa mu aa nyi Nte Uwumbɔr aah ye udaan u na, see min Ujapɔɔn. Binib bi m ban ke m di Uwumbɔr mɔk bi na, bi mu nyi u.” ");
INSERT INTO xon_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Le u fenn ki toŋ waadidiliib, ki bui bi libɔɔl ni, “Uwumbɔr aanyoor bi ni pu, ninimbil aah kan tiwan ni na pu. ");
INSERT INTO xon_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","M tuk nimi la, Uwumbɔr aabɔnabtiib ni bibɔrb bi wiir na nan ban bi kan naah kan tiwan ni na, kaa kan. Bi nan ban bi ŋun naah ŋun tibɔr ti na, kaa ŋun ti.” ");
INSERT INTO xon_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Le uja u nyi Uwumbɔr aakaal mbamɔm na ubaa fii sil ki pen Yesu nlan, ki baa u, “Umɔmɔkr, m ga ŋa kinye ki kan limɔfal li kaa kpa ndoon na?” ");
INSERT INTO xon_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Le Yesu baa u, “Ni ŋmee kinye Uwumbɔr aakaal ponn ni? Aa karn kinye?” ");
INSERT INTO xon_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Le u bui u, “Ni ŋmee ke, ‘Aa li gee Aadindaan Uwumbɔr aasui mɔmɔk ni, ni saawiin mɔmɔk, ni saapɔɔn mɔmɔk, ni saalandak mɔmɔk, ki li gee aana aabo ke saah gee aabaa pu na.’” ");
INSERT INTO xon_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Le Yesu bui u, “Aa len mbamɔn la. Li ŋani kina, le aa ga kan limɔfal.” ");
INSERT INTO xon_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Le u ban ke u li kpa mbamɔn, le ki baa Yesu, “Ŋma ye nna aabo?” ");
INSERT INTO xon_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Le Yesu bui u, “Uja ubaa nan nyan Jerusalem ki cha Jeriko. Waah cha na, le u ti lir bififiirb aaŋaal ni. Le bi chuu peer waawanpeenkaan ki gbaa u, le u ti ban u kpo. Le bi siir cha u. ");
INSERT INTO xon_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naah kpee siib na, le Uwumbɔr aatotoor ubaa mu jer nima, ki kan u. Waah kan u na, le u gɔln u ki jer. ");
INSERT INTO xon_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Le Liifai aanii ubaa mu paan ni, ki nan jer nima, le ki kan u, le ki mu gɔln u ki jer. ");
INSERT INTO xon_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Le Samaria aatiŋ aanii ubaa mu cha waasachuln, ki nan fuu nima chee. Waah kan u na, le kinimbaak chuu u. ");
INSERT INTO xon_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Le u buen u chee, ki di nnyɔk ni nkpan meen ibuun ngbaan, ki di ŋitan poo u, le ki di u diŋ uma ubaa aabon pu, ki di u buen tichaandir ponn ni, ki ti lik u nima. ");
INSERT INTO xon_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Le ni woln kitaak le u di ŋimombil tii tichaandirdaan, le ki bui u, ‘Lik u tii mi. Aa yaa jin ŋimombil ŋi jer ŋimina kan, m nan gir ni kan, m ga nan pa si.’” ");
INSERT INTO xon_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Le Yesu baa nkaal aamɔmɔkr ngbaan, “Uja u lir bififiirb aaŋaal ni na, bijab bitaa ngbaan ponn ni, ulau tee ye una aabo? Aa dak kinye?” ");
INSERT INTO xon_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Le u bui u, “Unii u san u kinimbaak na le ye una aabo.” Le Yesu bui u, “Li cha ki mu li ŋani kina.” ");
INSERT INTO xon_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tɔ, Yesu ni waadidiliib aah chuun lisachuln pu na, le bi ti fuu kitiŋ kibaa ponn ni. Le upii u bi yin u ke Mata na gaa u waadichal ni. ");
INSERT INTO xon_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata nan kpa naal ubaa, bi yin u ke Mari. Le Mari ka Yesu chee, ki pel waah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata le tun tichann aatuln ki bi gonni ki ti bak. Nima le u dan nan bui Yesu, “Ndindaan, nnaal cha mi baanja le channi nimi tichann kaa ter mi. Aatafal aa bi ni ni ii? Bui u ke u ter mi.” ");
INSERT INTO xon_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Le Tidindaan bui u, “Mata, Mata, aa cha tiwan sakpen le muk si ki ŋa si ilandak. ");
INSERT INTO xon_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tiwan nibaa baanja le aa lann. Mari aah lee ni na le ŋan. Ubaa aan nyan waah lee ni na u chee.” ");
INSERT INTO xon_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kitaak kibaa daal, le Yesu nan bi nibaa chee ki bi mee Uwumbɔr. Waah mee u ti doo na, le waadidiliib ponn ni ubaa bui u, “Ndindaan, mɔk timi taah ga mee Uwumbɔr pu na, ke Jɔnn u nan muini binib nnyun ni na aah nan mɔk waadidiliib pu na.” ");
INSERT INTO xon_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Le Yesu bui bi, “Ni yaa mee Uwumbɔr kan, ni bui ke, ‘Tite Uwumbɔr u bi paacham na, cha binib li san saayimbil; cha saanaan dan. Bi li ŋani saageehn dulnyaa wee ni, ke baah ŋani paacham pu na. ");
INSERT INTO xon_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tiin timi din aawiin aajikaar. ");
INSERT INTO xon_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cha timi aatunwanbir pinn timi; ba pu? ti mu di cha pinn binib bimɔk koo timi aataani ni na. Taa cha ti kan ntɔŋ. Nyan timi tibɔbir ni.’” ");
INSERT INTO xon_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Le Yesu ki bui bi, “Ni ponn ni ubaa yaa buen aajɔ do kinyetaasiik ki ti sil lipaal ki bui u, ‘Njɔ, pinn mi ŋiboroboro kpin ŋitaa; ");
INSERT INTO xon_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","njɔ ubaa chuun fuu ni ndo; m mu aa kpa tijiir tibaa m tii u’ kan, ");
INSERT INTO xon_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","le aajɔ u bi kidiik ni na ga bui si, ‘Taa muk mi. M ni maabilb doon ki laŋ kidiik a. Maan ŋmaa fii ki tii si.’ ");
INSERT INTO xon_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Naa ye kijɔtiik pu le u ga fii ki tii si. Aa yaa gaŋni u ki gaŋni u ki muk u kan, nima le ga cha u fii ki tii si saah ban pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nima pu na, m tuk nimi la, ni li mee Uwumbɔr man, le u ga tii nimi. Ni li ban Uwumbɔr chee man, le ni ga kan. Ni li kpaar jaaleŋ man, le u ga piir tii nimi. ");
INSERT INTO xon_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Unii umɔk mee Uwumbɔr na, u ga tii u. Unii umɔk ban na, u ga kan. Unii umɔk kpaar jaaleŋ na, u ga piir tii u. ");
INSERT INTO xon_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ni ponn ni ubaa aabo yaa mee si maab kan, aa ga di litakpal tii u uu? U yaa mee si ujan kan, aa ga di uwaa tii u uu? ");
INSERT INTO xon_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","U yaa mee si likoojiln kan, aa ga di unyoohn tii u uu? ");
INSERT INTO xon_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nimi titunwanbirdam yaa tee nyi ipiin i ŋan na ki tii nimi aabim kan, ŋmaninkabaa Nite Uwumbɔr u bi paacham na le aan di Waafuur Nyaan tii binib bi mee u ki ban mu na aa?” ");
INSERT INTO xon_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uja u tiyayaar cha u ŋa ubir na nan bi nima chee. Le Yesu nyan tiyayaar ngbaan u ni, le u len, kaa ki ye ubir. Le ni gar kinipaak ngbaan pam. ");
INSERT INTO xon_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bi ponn ni bibaa mu bui ke kinimbɔŋ ki bi yin ki ke Beelsebul, u ye tiyayaar aayidaan na, le tii u mpɔɔn ke u nyan tiyayaar binib ni. ");
INSERT INTO xon_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bibaa mu tɔŋ u ki ban ke u tun lijinjiir aatuln ki mɔk bi ke u ye Uwumbɔr Aanii. ");
INSERT INTO xon_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Le u bee baah dak pu na, le ki bui bi, “Nnaan mubaa ni aanib yaa jaa tɔb kijaak kan, nnaan ngbaan ga bee yɔli la. Lidichal libaa ni aanib mu yaa jaa tɔb kijaak kan, bi ga lir la. ");
INSERT INTO xon_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ni len ke Beelsebul u ye tiyayaar aayidaan na le tii mi mpɔɔn ke m nyan tiyayaar binib ni. Tiyayaar aayidaan kinimbɔŋ yaa ŋa kina kan, ki jan kibaa kijaak la. Kaanaan ga ŋa kinye aan ki sil? ");
INSERT INTO xon_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ni yaa len ke tiyayaar aayidaan Beelsebul le tii mi mpɔɔn ke m nyan tiyayaar binib ni kan, ŋma tii nimi aanib mu mpɔɔn ke bi nyan tiyayaar binib ni? Nimi aanib aah ŋani pu na le ga mɔk ke ni kpa mbamɔn aan naa kpa. ");
INSERT INTO xon_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mma kan, Uwumbɔr aapɔɔn pu le m nyani tiyayaar binib ni. Nima le mɔk ke Uwumbɔr aanaan fuu ni ni chee. ");
INSERT INTO xon_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Liwɔkl li kpa tijawan sakpen na yaa lik waadichal kan, ubaa aan bii waawan. ");
INSERT INTO xon_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Le unii u kpa mpɔɔn jer u na yaa lir u pu ki nyaŋ u kan, u ga gaa waajawan ti ter u na mɔmɔk, ki ji waawan. ");
INSERT INTO xon_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Unii u kaa dii mi na kan, u ye maadin la. Unii u mu kaa kuuni binib tii mi na kan, u yaani bi la.” ");
INSERT INTO xon_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tiyayaar yaa nyan unii ni kan, ti ga li chuun gɔr nnyun aah kaa bi kipɔɔk ki ponn ni na, ki ban taah ga kal nin chee ki fuur na, kaan kan. Le ti ga len ke, ‘M ga gir kun maah nan nyan unii u ponn ni na la.’ ");
INSERT INTO xon_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Le ti ga gir ni ki nan kan ke bi toor taakookoo yaan, le ni ŋan. ");
INSERT INTO xon_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Le ti ga buen ki ti joo ni tiyayaar tilole ti bir ki jer ti na. Le ti mɔmɔk ga koo unii ngbaan ponn ni, ki ga li bi u ponn ni, le ki ŋa u yɔli ki jer waah nan bi njan na pu na.” ");
INSERT INTO xon_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu aah len kina na, le kinipaak ngbaan ponn ni upii ubaa len mpɔɔn pu, “Uwumbɔr aanyoor bi upii u ma si ki tii si libiil na pu.” ");
INSERT INTO xon_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Le Yesu bui ke, “Binib bi ŋun Uwumbɔr aabɔr ki kii ti na, Uwumbɔr aanyoor bi bima le pu.” ");
INSERT INTO xon_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kinipaak aah kuun ni Yesu chee na, le u bui ke, “Dandana aanib ye binib bi bir na la. Bi ban ke m mɔk bi lijinjiir aawan, aan bi nin gaa mi ki kii. Uwumbɔr aah nan ŋa lijinjiir aatuln ki ŋa waabɔnabr Jona pu na, lituln limina aaboln le bi ga kan. Maan mɔk bi lijinjiir aawan niken. ");
INSERT INTO xon_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Uwumbɔr aah nan ŋa Jona pu na, ni nan ye limɔkl le ki tii Ninefa aatiŋ aanib. Kina le waah ga ŋa min Unibɔn Aabo pu na ga li ye limɔkl ki tii dandana aanib ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Seba aatiŋ aapiibɔr nan nyan ni dandar ke u nan ŋun Ubɔr Solomonn aalan aaliin. Min u jer Solomonn na bi do la, le naa ŋun maaliin. Bundaln Uwumbɔr ga ji binib tibɔr na, upiibɔr ngbaan aah nan ŋa pu na, nima le ga mɔk ke dandana aanib aabɔr bii. ");
INSERT INTO xon_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jona nan tuk Ninefa aatiŋ aanib Uwumbɔr aabɔr, le bi kpeln baabimbin. Min, u jer Jona na le tuk dandana aanib Uwumbɔr aabɔr, le baa kpeln baabimbin. Bundaln Uwumbɔr ga ji binib tibɔr na, Ninefa aatiŋ aanib aah nan kpeln baabimbin pu na, nima le ga mɔk ke dandana aanib aabɔr bii.” ");
INSERT INTO xon_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Unii yaa see karyaa kan, waan di u di bɔr, kaan di lisambil chiŋ u pu. U ga di u tɔŋ tiwan paab la, le u li wiin binib bimɔk koo ni na chee, bi li waa. ");
INSERT INTO xon_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aanimbil ye saawon aakaryaa la. Aanimbil yaa woln ke aa dii Uwumbɔr aasan kan, saabimbin mɔmɔk gbii nwiihn la. Aanimbil yaa kaa woln kan, saabimbin gbii mbɔmbɔɔn la. ");
INSERT INTO xon_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Li nyi ki taa cha nwiihn mu bi aa ni na li ye mbɔmbɔɔn. ");
INSERT INTO xon_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Saabimbin mɔmɔk yaa gbii nwiihn, kaa bɔɔn nibaa chee kan, aa ga li bi nwiihn ni mbamɔm. Ni ga li bi ke karyaa u wiin chain na aah ga woln saah bi nin chee na pu na la.” ");
INSERT INTO xon_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu aah len kina ki ti doo na, le Farisii aanii ubaa bui u ke u dan udo ki nan ji tijikaar. Le u koo waadichal ni, ki kal ki bi ji. ");
INSERT INTO xon_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Le Farisii aanii ngbaan kan ke Yesu ji kaa ŋir uŋaal. Le ni gar u. ");
INSERT INTO xon_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Le Tidindaan bui u, “Nimi Farisii yaab, ni ŋir tiyir ni ŋisambil aapuwɔb mbamɔm, kaa ŋir ni ponn ni. Kina le ni ban ke binib bui ke ni ye bininyaam; nisui ponn ni mu gbii kinaayuk aatuln ni titunwanbir. ");
INSERT INTO xon_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nimi bijɔrb bimina, Uwumbɔr u nan naan tiwon na, uma le naan nisui mu. ");
INSERT INTO xon_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Di naah kpa tiwan ni na tii bigiim, ki di nibaa mu tii bi. Ni yaa ŋa kina kan, tijɔŋ tibaa aan ki li bi ni chee. ");
INSERT INTO xon_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nimi Farisii yaab, tibɔbir bi ni pu; ba pu? ni yakr tikpifar nfum kipiik le ki nyan nibaa le di tii Uwumbɔr, kaa ŋani ni ŋan na, kaa gee Uwumbɔr. Ni ŋan ke ni li ŋani ni ŋan na, ki li gee Uwumbɔr, ki yakr nimi aawan mu ki di tii u. ");
INSERT INTO xon_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nimi Farisii yaab, tibɔbir bi ni pu; ba pu? ni gee ke ni kal bininyuum aakakaa chee mmeen aadir ni, ki gee ke binib doon nimi mbamɔm kinyaŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tibɔbir bi ni pu. Ni naahn ŋikaakul ŋi bɔɔ na, ŋi binib chuun taar ŋi pu, kaa nyi na.” ");
INSERT INTO xon_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Le Uwumbɔr aakaal aamɔmɔkr ubaa bui u, “Umɔmɔkr, saah len kina na, aa sii ti mu la.” ");
INSERT INTO xon_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Le Yesu bui ke, “Nimi Uwumbɔr aakaal aamɔmɔkb, tibɔbir bi ni mu pu. Ni di nkaal mu pɔɔ sakpen na, le ki di kpee Uwumbɔr aakaal pu, ki tuk binib ke bi li dii kina. Ni mu aa ter bi ke bi dii kina. ");
INSERT INTO xon_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tibɔbir bi ni pu; ba pu? ni maa ŋikaakul ki tii Uwumbɔr aabɔnabtiib bi nan bi n‑yaayoonn na. Niyaajatiib le nan ku bi. ");
INSERT INTO xon_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ni mu nyi baah nan ku bi pu na, ki mu kii baah nan ŋa pu na. Niyaajatiib le nan ku bi. Ni mu maa ŋikaakul tii bi. ");
INSERT INTO xon_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nima pu le Uwumbɔr aah kpa nlan pu na, u bui ke, ‘M ga tun bibɔnabr ni bitutum bi chee. Le bi ga ku ngem ki ŋa biken mu falaa.’ ");
INSERT INTO xon_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Buyoonn dulnyaa wee nan piin ki joo cha na, binib nan ku Uwumbɔr aabɔnabtiib. Linikul ngbaan mɔmɔk pu le Uwumbɔr ga daa dandana aanib aatafal. ");
INSERT INTO xon_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Njan, bi nan ku Abel, le ki ku bininyaam ki joo cha, ki ti pii Uwumbɔr aabɔnabr Sekaria, u bi nan ku u, kitork aabimbiln ni Uwumbɔr Aadichal aakaasisik ni na. Mbamɔn, m tuk nimi la, linikul ngbaan mɔmɔk pu le Uwumbɔr ga daa dandana aanib aatafal. ");
INSERT INTO xon_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nimi Uwumbɔr aakaal aamɔmɔkb, tibɔbir bi ni pu. Naa mɔk binib Uwumbɔr aakaal mbamɔm. Nimi nibaa aa dii mu, le ki tee leŋ binib bi ban bi dii mu na nsan.” ");
INSERT INTO xon_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu aah nyan nima chee na, le Uwumbɔr aakaal aamɔmɔkb, ni Farisii yaab kpak u kinikpakpak pam, ki baa u mbaan tibɔr ti wiir na pu, ");
INSERT INTO xon_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ki ban bi pen u nlan ki kan waataani aan ki galn u. ");
INSERT INTO xon_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Binib churbaka aah nan kuun Yesu chee ki ti taar tɔb pu pu na, le u bui waadidiliib, “Ni li nyi Farisii yaab aabimbin aah bi pu na, ki taa li bi kina man. Bi ŋmanni ke bi ye bininyaam, kaa ye. ");
INSERT INTO xon_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tibɔbɔrkaan mɔmɔk ga kpiir. Tibɔr timɔk bɔɔ na, ti ga nyan mpaan pu. ");
INSERT INTO xon_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Naah loon len tibɔr ti mbɔmbɔɔn ni na, binib ga ŋun ti nwiihn pu. Naah loon tibɔr ti binib aatafal ni kidiik ponn ni na, bi ga di ti moon lipaal.” ");
INSERT INTO xon_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nimi bi ye njɔtiib na, m tuk nimi la, ni taa san binib ijawaan man. Bi ga ŋmaa ku nimi aawon baanja la. Baan ki ŋmaa ŋa nimi nibaa. ");
INSERT INTO xon_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","M sur nimi naah ga li san u ijawaan na. Ni li san Uwumbɔr. U yaa ku binib kan, u kpa mpɔɔn ke u di bi ŋa mmii mu kaan junn na ni. Mbamɔn, m tuk nimi la, ni li san uma. ");
INSERT INTO xon_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Bi kooh iyaar iŋmu janjan bilee la. Le Uwumbɔr aa suln i ponn ni ubaa aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ni taa san ijawaan man. Ni jer iyaar pam. Uwumbɔr nyi nimi aayikpir aakahm.” ");
INSERT INTO xon_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“M tuk nimi la, unii umɔk len binib aanimbil ni ke min le ye Udindaan na, min Unibɔn Aabo mu ga len Uwumbɔr aatuuntiib aanimbil ni ke udaan ngbaan le ye miyoo. ");
INSERT INTO xon_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Unii umɔk yii mi binib aanimbil ni na, m mu ga yii udaan ngbaan Uwumbɔr aatuuntiib aanimbil ni. ");
INSERT INTO xon_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Unii yaa bii min Unibɔn Aabo kan, Uwumbɔr ga ŋmaa di cha pinn u. Unii yaa sii Uwumbɔr Aafuur Nyaan kan, Uwumbɔr aan di cha pinn u. ");
INSERT INTO xon_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bi yaa chuu nimi, ki di ŋa mmeen aadir ni, bee ntim aaninkpiib aanimbiin ni, bi ti ji nimi tibɔr kan, ni taa baa nisui ni ke ni ga len kinye aan ki nyan nibaa tibɔr ni. ");
INSERT INTO xon_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","N‑yoonn ngbaan yaa fuu ni kan, Uwumbɔr Aafuur Nyaan le ga mɔk nimi naah ga len pu na.” ");
INSERT INTO xon_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kinipaak ngbaan ponn ni le uja ubaa tuk Yesu, “Umɔmɔkr, bui nkpel ke u yakr tite aafaal ki di min yaan tii mi.” ");
INSERT INTO xon_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Le Yesu bui u, “Uja, ŋma tii mi nsan ke m ji nimi tibɔr ki yakr lifaal tii nimi?” ");
INSERT INTO xon_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","le ki tuk kinipaak ngbaan, “Ni li nyi man ki taa li kpa iniman. Unii yaa kpa liwangol li wiir na kan, nima le aan tii u limɔfal.” ");
INSERT INTO xon_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu nan ŋakl bi liyataŋakl ke, “Uwankpadaan ubaa aasaak nan ŋa tijikaar ti wiir na. ");
INSERT INTO xon_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Le u dak usui ni, ‘Maa ki kpa maah ga di maajikaar ŋa tiwan ni ponn ni na. M ga ŋa kinye? ");
INSERT INTO xon_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","M ga ŋa kina la; m ga gbaa wii maapil mɔmɔk, ki ki maa ŋipil ŋi filk ki jer ŋimina na. M ga di maajikaar mɔmɔk ŋa ŋi ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Le m ga bui mbaa, M kpa tijikaar ti ga fuu mi ŋibin sakpen na. M ga fuur, ki ji, ki nyu, ki li mɔɔni.’ ");
INSERT INTO xon_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tɔ, le Uwumbɔr bui u, ‘Si ujɔr wee, kinyeek kee le aa ga kpo. Saah kuun liwangol limɔk siin na, ŋma ga li yeh li?’ ");
INSERT INTO xon_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Kina le unii umɔk di liwangol bil kiir ubaa, kaa kpa liwangol Uwumbɔr chee na, u mu ye ujɔr.” ");
INSERT INTO xon_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Le Yesu bui waadidiliib, “Nima le m tuk nimi, ni taa cha nimi aalandak li muk nimi tiwon aawan pu, ki taa li dak ke, ‘Ti ga ji ba? Ti ga peen ba?’ ");
INSERT INTO xon_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Limɔfal bi tijikaar baanja pu la aa? Tiwon bi tiwanpeenkaan baanja pu la aa? ");
INSERT INTO xon_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dakl lik ŋikakaa aah bi pu na. Ŋaa ko tijikaar, ki mu aa chee ti, kaa kpa ŋipil, kaa kpa ŋiboo. Uwumbɔr le kpiini ŋi. Naa jer ŋi sakpen aa? ");
INSERT INTO xon_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni ponn ni ubaa ga ŋmaa muk waalandak aan ki yunn ki jer Uwumbɔr aah siin pu na aa? ");
INSERT INTO xon_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Naah kaa ŋmaa ŋa tiwan ni kaa pɔɔ na, ba pu ni cha ilandak muk nimi ni gur na pu? ");
INSERT INTO xon_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Dakl lik mmopuun aah bi pu na. Mu aa tun lituln, ki mu aa fik tikokonn. M tuk nimi la, Ubɔr Solomonn u nan pee tiwanpeenkaan nyaan na aawanpeenkaan aa nan ŋan ke mmopuun aah ŋan pu na. ");
INSERT INTO xon_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Timoor bi din, ki ga fe wu mmii fen, le Uwumbɔr ŋa ti mmopuun mu ŋan na. Waan tii nimi tiwanpeenkaan aa? Naa gaa Uwumbɔr ki kii mbamɔm. U ga tii nimi. ");
INSERT INTO xon_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ni taa cha ninimbil li man tijikaar ni tiwanyukaan pu, ki taa cha ilandak li muk nimi. ");
INSERT INTO xon_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tiwan ngbaan mɔmɔk pu le dulnyaa wee ni aanib bi kaa dii Uwumbɔr aasan na aanimbil man. Nite Uwumbɔr nyi ke ni ban tiwan ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ni cha ninimbil li man Uwumbɔr aanaan pu, le u ga di tiwan ngbaan mɔmɔk kpee nimi.” ");
INSERT INTO xon_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Maanib bi bi siib na, ni taa san ijawaan man. Nite Uwumbɔr le ban ke u tii nimi nnaan. Waageehn le na. ");
INSERT INTO xon_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ni kooh naah kpa tiwan ni na man, ki di ŋimombil ngbaan tii bigiim, aan ki li kpa ŋimombil ŋi kaan doo na. Ni ga li kpa liwankpal li kaan doo na paacham. Unaayuk ubaa aan buen nima. Ŋikpaambil aan li bi nima ki bii ni. ");
INSERT INTO xon_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Saawankpal aah bi nin chee na, aasui mu bi nima chee la.” ");
INSERT INTO xon_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ni gor nibaa pu man, ki see nimi aakaryaa mam, ");
INSERT INTO xon_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ki li bi ke bitutum bi si kii buyoonn bidindaan ga nya tibɔndinn aajikaar aajim ni, ki fuu ni na. U yaa nan fuu ni ki kpaar jaaleŋ kan, libuul ngbaan ni le bi ga chuu piir tii u. ");
INSERT INTO xon_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bitutum bi lik bidindaan aah ga fuu ni pu na, Uwumbɔr aanyoor bi bi pu. M tuk nimi mbamɔn la, u ga cha bi kal, ki ga di tijikaar siin binimbiin ni. ");
INSERT INTO xon_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","U yaa fuu ni kinyetaasiik, bee u yaa fuu ni likoojawiil yoonn, ki kan ke bi gor kan, Uwumbɔr aanyoor bi bi pu la. ");
INSERT INTO xon_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ni nyi ke udichadaan yaa ba nyi buyoonn unaayuk ga fuu ni na kan, waa ba ga doon ki geen, u ba ga li ka lik, unaayuk ngbaan taa koo ni waadichal ni. ");
INSERT INTO xon_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ni mu gor man; ba pu? buyoonn naan li dak ke m ga gir ni na, n‑yoonn ngbaan le m ga gir ni.” ");
INSERT INTO xon_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Le Piita baa Yesu, “Ndindaan, aa ŋakl liyataŋakl ngbaan ki tii timi baanja le aan aa ŋakl ki tii binib mɔmɔk la?” ");
INSERT INTO xon_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Le Tidindaan bui u, “Uyidaan ubaa yaa tii waatutunn ubaa tininkpir ke u li lik waachiln ni aanib ki tii bi tijikaar naah ŋeer buyoonn na kan, ututunn ngbaan ga ŋa kinye ki li kpa nlan, ki li tun waatuln mbamɔm? ");
INSERT INTO xon_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Udindaan yaa nan fuu ni ki mui waatutunn ŋani uma udindaan aah ban pu na kan, Uwumbɔr aanyoor bi ututunn ngbaan pu. ");
INSERT INTO xon_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","M tuk nimi mbamɔn la, u ga tii u tininkpir u li lik waawan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tɔ, ututunn ngbaan mu yaa dak usui ni ke udindaan ga yunn, ki yaa piin ki gbaa ututuŋeen aatɔtiib, bijab ni bipiib mɔmɔk, ki ji ki nyu ndaan gbii kan, ");
INSERT INTO xon_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","udindaan ga gir ni buyoonn waan li dak ke u ga gir ni na, ki ga gbaa u ŋinaalab mbamɔm, ki ga di u ŋa binib bi yii waamɔb na aah bi nin chee na. ");
INSERT INTO xon_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ututunn u nyi udindaan aah ban pu na, kaa gor, kaa ŋani kina na, bi ga gbaa u sakpen. ");
INSERT INTO xon_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ututunn u kaa nyi udindaan aah ban pu na, ki tun lituln li ŋeer ŋinaalab aagbaan na kan, bi ga gbaa u siib la. Uwumbɔr yaa tii unii nlan sakpen kan, u ga li ban ke u di nlan ngbaan tun litunyaan jer biken. Uwumbɔr yaa tii unii tininkpir kan, u ga li ban ke udaan ngbaan tun ki jer biken aah tun pu na.” ");
INSERT INTO xon_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“M dan m nan tuur mmii dulnyaa wee ni. Mu yaa puun gaal kan, m ba gee. ");
INSERT INTO xon_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","M ga ji falaa ki ti nyaŋ. Nsui aan doon see m jin falaa ngbaan ki ti doo. ");
INSERT INTO xon_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Maah dan dulnyaa wee ni na, ni dak ke nima le ga cha binib mɔmɔk li kpaan kimɔbaan aa? Aayii. M tuk nimi la, m pu le bi ga yakr tɔb chee. ");
INSERT INTO xon_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dandana ki joo cha, binib biŋmu yaa bi lidichal libaa ni kan, bi ga yakr tɔb chee la. Bitaa ga kpak bilee bi gur na. Bilee ngbaan mu ga kpak bitaa na. ");
INSERT INTO xon_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uja ga yakr ujapɔɔn chee; japɔɔn mu ga yakr ute chee; upii mu ga yakr ubisal chee; bisal mu ga yakr una chee; upii mu ga yakr ubipuu chee; bipuu mu ga yakr uchapii chee.” ");
INSERT INTO xon_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Le Yesu bui kinipaak ngbaan, “Ni yaa kan utaal yun ki bɔln liwilir wɔb kan, libuul ngbaan ni le ni ga bui ke, ‘Utaal ga nu la,’ le u nu. ");
INSERT INTO xon_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Libuln yaa nyan ni ŋŋangii aasikakl wɔb kan, le ni ga bui ke, ‘Kitotoŋ koo a,’ le ki koo. ");
INSERT INTO xon_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nimi biŋmaŋmannim, kitiŋ ni paacham pu le cha ni beer naah ga li bi pu na. Ba ŋa naa bee Uwumbɔr aah ŋani pu dandana na?” ");
INSERT INTO xon_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ba ŋa naa ŋmaa dakl lik ki bee ni ŋan na? ");
INSERT INTO xon_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aa ni unii yaa kpa tibɔr, u ban u di ti buen bibɔjirb chee kan, chuu utaal mala, u taa kee fuu bi chee, ki taa di si ŋa biŋaal ni, bi di si ŋa kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","M tuk si la, saan nya nima ki nan saa buyoonn aa ga pa kooti ni aamombil mɔmɔk doo na.” ");
INSERT INTO xon_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","N‑yoonn ngbaan le binib bibaa dan nan bui Yesu ke Galilee aatiŋ aanib aah nan bi toor kitork tii Uwumbɔr na, Pailat nan ku bi. ");
INSERT INTO xon_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Le Yesu baa bi, “Ni dak ke Galilee aatiŋ aanib ngbaan nan ye titunwanbirdam ki jer Galilee yaab biken aa? Nima le cha u ku bi ii? ");
INSERT INTO xon_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aayii. M tuk nimi la, ni yaa kaa kpeln nimi aabimbin kan, ni mɔmɔk ga kpo kina la. ");
INSERT INTO xon_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tɔ, libimbifɔfɔŋ aah nan lir ki ku bijab kipiik ni biniin Siloam aatiŋ ni na, ni dak ke bi nan kpa taani ki jer Jerusalem aanib mɔmɔk aa? ");
INSERT INTO xon_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aayii. M tuk nimi la, ni yaa kaa kpeln nimi aabimbin kan, ni mɔmɔk ga kpo kina la.” ");
INSERT INTO xon_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Le u ŋakl bi liyataŋakl ke, “Uja ubaa nan bun busub bubaa waasaak ponn ni; ki joo cha, le u dan nan lik ke ŋisubil bi aa ŋaa bi, le kaa kan nibaa. ");
INSERT INTO xon_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Le u bui waatutunn, ‘Ŋibin ŋitaa le na, le m choo m nan lik busub bue. Maa kan lisubil libaa. Gaa bu lii. Taa cha bu li si ki gaa kitiŋ yɔli.’ ");
INSERT INTO xon_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Le ututunn ngbaan bui u, ‘Ndindaan, di cha bu libiln lee, m gbii bu taab, ki ban tinaabin ki bil bu. ");
INSERT INTO xon_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Libiln li choo na, bu yaa lun kan, ni ŋan. Bu yaa kaa lun kan, aa gaa bu lii.’” ");
INSERT INTO xon_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Juu yaab aakpaakool daal le Yesu bi mmeen aadiik ni, ki bi tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Le upii ubaa bi nima. Tiyayaar le joo u ki ŋa u ubun ŋibin kipiik ni ŋiniin. U boo gui, kaa ŋmaa yaar. ");
INSERT INTO xon_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu aah kan u na, le u yin u ke u dan u chee, le ki bui u, “Upii, aa kan aabaa saaween chee,” ");
INSERT INTO xon_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","le ki di uŋaal paan u pu. Libuul ngbaan ni le u yaar, le ki nyuŋ Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesu aah cha upii ngbaan pɔɔk likpaakool daal na, nima le cha mmeen aadiik ni aaninkpel gee liŋuul Yesu pu, le ki bui kinipaak ngbaan, “Iwiin iloob le bi likpaakool aakaasisik ni, ti li tun lituln, ki cha likpaakool daal. Nima pu na, ni dan iwiin iloob ngbaan aakaasisik ni aan u cha ni pɔɔk. Ni taa ki dan nan ban laafee likpaakool daal.” ");
INSERT INTO xon_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Le Tidindaan bui u, “Nimi biŋmaŋmannim, likpaakool daal kan, ni ga chuu gbiln nimi aanaaja, bee nimi aabon, ki di u buen nkpen ni ke u ti nyu nnyun. ");
INSERT INTO xon_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Upii wee ye Abraham aayaabil la, le kinimbɔŋ buu u ŋibin kipiik ni ŋiniin le ki ŋa u u boo gui na. Maah chuu buur u likpaakool daal na, naa ŋan aa?” ");
INSERT INTO xon_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu aah len kina na, le inimɔɔn chuu binib bimɔk kpak u kinikpakpak na. Waah tun lijinjiir aatun pam pu na, le kinipaak ngbaan mɔmɔk nan kpa mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Le Yesu baa bi, “Uwumbɔr aanaan naahn ba? M ga di ba ki di ŋaŋ mu? ");
INSERT INTO xon_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mu naahn linaanyiimbil li uja ubaa nan di bun waakpaab ni na la. Le li muun ki ŋa busub. Le inyoon i laani paacham na dan nan ter yaadil bu aabon pu.” ");
INSERT INTO xon_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu nan ki baa bi, “M ga di ba ki di ŋaŋ Uwumbɔr aanaan? ");
INSERT INTO xon_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mu naahn nnyɔk mu bi joo ŋani boroboro ni aan upii ubaa nan di ŋa boroboro aayon ponn ni na, le boroboro ngbaan mɔk duun.” ");
INSERT INTO xon_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Le Yesu cha Jerusalem. Waah cha na, le u bɔ dii ntisakpem ni ntiwaatiir ni, le ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Le unii ubaa baa u, “Ndindaan, binib bi ŋmar na le bi siib aa?” ");
INSERT INTO xon_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","Le Yesu bui bi, “Cha ninimbil li man ni li dii mbisamɔb mu kaa waa na. M tuk nimi la, buyoonn udichadaan na ga nan fii ki laŋ kidiik na, nee aapuwɔb le binib pam ga li ban bi koo ni, kaan ŋmaa koo ni. Ni ga li si lipaal, ki kpaar jaaleŋ, ki bui ke, ‘Tidindaan, chuu piir tii timi.’ Le u ga bui nimi, ‘Maa nyi nimi. Ni nyan ni la chee?’ ");
INSERT INTO xon_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Le ni ga bui ke, ‘Ti ni si le nan kpaan ji ki nyun. Aa nan tuk binib Uwumbɔr aabɔr timi aatiŋ ni la.’ ");
INSERT INTO xon_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Le u ga ki bui nimi, ‘M tuk nimi la, maa nyi nimi. Ni nyan ni la chee? Nimi titunwanbirdam, ni mɔmɔk siir m chee man.’ ");
INSERT INTO xon_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Le u ga jenn nimi. Le ni ga li waa Abraham, ni Aisak, ni Jakob, ni Uwumbɔr aabɔnabtiib mɔmɔk Uwumbɔr aanaan ni. Ni ga li bi lipaal, ki wii ki ŋman ŋinyin nima chee. ");
INSERT INTO xon_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Binib ga nya liwipuul wɔb, ni liwilir wɔb, ni isikakl mɔk, ki ga li ka ki ji tijikaar Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Li pel man, puwɔb yaab bibaa ga nan ŋa bisalolm. Bisalolm bibaa mu ga nan ŋa puwɔb yaab.” ");
INSERT INTO xon_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","N‑yoonn ngbaan le Farisii yaab bibaa dan Yesu chee, ki nan bui u, “Nya do chee, ki li cha. Ubɔr Herod ban u ku si la.” ");
INSERT INTO xon_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Le Yesu bui bi, “Ni li cha ti tuk uŋɔk ngbaan, ‘Din ni fen le m ga nyan tiyayaar binib ni, ki cha bibum pɔɔk. Iwiin itaa daal le maatuln ga doo.’ ");
INSERT INTO xon_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nima le m cha Jerusalem din, ni fen, ni daalpu. Baan ku Uwumbɔr aabɔnabr ubaa nibaa chee, see Jerusalem ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem aanib, nsui bii ni pu la. Ni ku Uwumbɔr aabɔnabtiib, ki yur waatutum ŋitakpal ki ku bi. N‑yoonn mɔmɔk le m nan ban m kuun nimi ŋa mbaa chee ke ukɔla aah kuuni waakoobi pu ki ŋani ufeen ni na, le naa kii. ");
INSERT INTO xon_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lik, Uwumbɔr siir cha nimi. M tuk nimi la, naan ki kan mi ki nan saa bundaln ni ga nan bui ke, ‘Uwumbɔr aanyoor bi unii u choo uma Uwumbɔr aayimbil ni na pu.’” ");
INSERT INTO xon_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juu yaab aakpaakool daal le Yesu nan buen Farisii yaab aaninkpel ubaa do, u ti ji tijikaar. Le bi lik waah ga ŋa pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Le uja u taakpachoo fuukoo nan chuu u na mu bi nima, le ki dan Yesu chee. ");
INSERT INTO xon_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Le Yesu baa Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab, “Timi aakaal kii ke unii cha bibum pɔɔk likpaakool daal aa?” ");
INSERT INTO xon_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Le baa len tibaa. Le Yesu chuu uja ngbaan ki ti cha waaween doo, ki cha u buen. ");
INSERT INTO xon_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Le u baa bi, “Unii ubaa aabon, bee waanaaja yaa lir nnyunbun ni likpaakool daal kan, waan nyan u likpaakool daal ngbaan aa?” ");
INSERT INTO xon_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Le baa ki ŋmaa len tibaa. ");
INSERT INTO xon_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Le Yesu kan ke binib bi dan bi nan ji tijikaar na buen ti kal bininyuum aakakaa chee. Nima le u ŋak bi liyataŋakl: ");
INSERT INTO xon_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Unii ubaa yaa yin si ke aa dan nan ji u chee tijikaar kan, taa kal bininyuum aakakaa chee. Nibaakan, unii u jer si na ga fuu ni. ");
INSERT INTO xon_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Le udichadaan ngbaan ga dan nan bui si, ‘Cha uja wee kal do chee.’ Le inimɔɔn ga chuu si. Le aa ga fii ki ti kal uwaatiir aakakaa chee. ");
INSERT INTO xon_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Unii yaa yin si ke aa dan nan ji u chee tijikaar kan, ti puen kal unii waatiir aakakaa chee. Le udichadaan ngbaan ga dan nan bui si, ‘Njɔ, nan kal nkakaa mu ŋan na chee.’ Le binib bimɔk ji aa chee tijikaar na ga nyuŋ si. ");
INSERT INTO xon_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naatataa le ye ke unii umɔk nyuŋ ubaa na, Uwumbɔr ga sunn u taab. Unii umɔk sunn ubaa taab na, Uwumbɔr ga nyuŋ u.” ");
INSERT INTO xon_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Le Yesu bui Farisii yaab aaninkpel u yin u ke u dan nan ji tijikaar na, “Aa yaa ŋa njim kan, taa yin aajɔtiib, bee saamaal aanib, bee aanaabitiib, bee aaŋeen aatɔtiib bi ye biwankpadam na, ke bi dan nan ji; ba pu? bi mu ga ki yin si ke aa nan ji bi chee tijikaar ki teen. ");
INSERT INTO xon_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aa yaa ŋa njim kan, yin bigiim, ni bitaageeb, ni biwɔb, ni bijoom, ke bi dan nan ji. ");
INSERT INTO xon_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bima le aa kpa nibaa ke bi ki giin tii si. Uwumbɔr le ga ŋa tinyoor ŋa aa pu. Buyoonn bininyaam ga fikr nkun ni na, le Uwumbɔr ga tii si saapal.” ");
INSERT INTO xon_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Binib bi ji u chee tijikaar na ponn ni ubaa ŋun waah len pu na, le ki bui u, “Binib bi ga ji tijikaar Uwumbɔr aanaan ni na, waanyoor bi bi pu la.” ");
INSERT INTO xon_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Le Yesu bui u, “Uja ubaa nan bui binib pam ke u ga ŋa tijikaar bi dan nan ji. Le u ŋa tijikaar pam. ");
INSERT INTO xon_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tijikaar aajim yoonn, le u tun waatutunn u ti bui bi, ‘Ni ŋeer a. Dan man.’ ");
INSERT INTO xon_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Waah bui bi kina na, le bi mɔmɔk kpaan yii. Njan yoo na bui u, ‘M daa bukpaab la, ki ban ke m buen ti lik bu aah bi pu na. M ŋa si gafara la.’ ");
INSERT INTO xon_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Le ubaa mu bui u, ‘M daa inaaja i ko kisaak na kipiik la. M cha m ti lik yaah bi pu na la. M ŋa si gafara.’ ");
INSERT INTO xon_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Le ubaa mu bui u, ‘M laa kunn upii la, le kaan ŋmaa dan.’ ");
INSERT INTO xon_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Le ututunn ngbaan gir kun udindaan chee, ki ti tuk u bi mɔmɔk aah len pu na. Le liŋuul chuu u. Le u bui waatutunn ngbaan, ‘Li cha kinyaŋ ni mala, ki ti yin ni bigiim, ni bitaageeb, ni bijoom, ni biwɔb, ke bi dan nan ji.’ ");
INSERT INTO xon_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Le waatutunn ŋa kina, ki dan nan bui u, ‘Ndindaan, m ŋa saah len pu na. Mpaan gur bi.’ ");
INSERT INTO xon_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Le udindaan bui u, ‘Li cha isan ni, ki ti gaŋ binib ke bi dan nan ji, aan maadichal gbiin. ");
INSERT INTO xon_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","M tuk nimi la, binib bi m nan puen bui bi ke bi dan nan ji na, bi ponn ni ubaa aan lak maajikaar.’” ");
INSERT INTO xon_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Le kinipaak pam dii Yesu. Le u fenn toŋ bi, ki bui bi, ");
INSERT INTO xon_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Unii yaa dan u nan dii mi, ki yaa kaa gee mi ki jer waah gee ute ni una, ni upuu, ni waabim, ni unaatiib, ni ukpetiib, ni uninkpatiib, ni waamɔfal pu na kan, waan ŋmaa dii mi. ");
INSERT INTO xon_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Unii umɔk kaan yoor waadɔpuinkoo ki dii mi na kan, waan ŋmaa li ye maadidiir. ");
INSERT INTO xon_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ni ponn ni ubaa yaa ban ke u maa kidifɔfɔŋ kan, u ga puen dakl lik ke waamombil ga fuu aan ŋaan fuu. ");
INSERT INTO xon_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","U yaa piin ki bi maa kidiik, kaa puen dakl lik waamombil aah bi pu na kan, nibaakan, waamombil aan fuu. Le waan ŋmaa maa kidiik ngbaan doo. Binib bimɔk kan na ga laa u, ki bui ke, ");
INSERT INTO xon_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Uja wee nan piin ki bi maa kidiik, kaan ŋmaa doo.’ ");
INSERT INTO xon_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tɔ, ubɔr u kpa butɔb aajab ŋichur kipiik na yaa ban u buen ti to ubɔr u kpa butɔb aajab ŋichur moninko na butɔb kan, u ga puen dakl lik ke u ga ŋman aan waan ŋman. ");
INSERT INTO xon_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","U yaa nyi ke waan ŋmaa nyaŋ u kan, waah laa bi ni daa na, u ga tun bitutum bi ti tooh u nsan ni, ki bui u ke u pɔɔk ubaa aan bi ti kpokl ki kuln kijaak ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ŋiyataŋak ngbaan aatataa le ye ke aa yaa kaa yii saah kpa nimɔk na kan, saan ŋmaa dii mi.” ");
INSERT INTO xon_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tɔ, n‑yaan ŋan la. Mu yaa bii, ki yaa kaa ki mɔ kan, nibaa aa bi ki ga ki ŋmaa ŋa mu aan mu mɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mu ŋa yɔli le na. Mu aan ki li kpa nterm tii nibaa. Bi ga di kpir la. U kpa litafal na kan, u ŋun.” ");
INSERT INTO xon_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bilampoogaab ni titunwanbirdam pam nan bi kuuni Yesu chee ke bi ti pel waah len tibɔr ti na. ");
INSERT INTO xon_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Le Farisii yaab ni Uwumbɔr aakaal aamɔmɔkb ŋulni u pu ke, “Uja wee gaal titunwanbirdam ki ji bi chee tijikaar.” ");
INSERT INTO xon_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nima pu le Yesu ŋakl bi liyataŋakl, ");
INSERT INTO xon_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ni ponn ni ubaa yaa kpa ipiih nkub, ubaa yaa wɔŋ kan, u ga di cha ipiih imonko inaa ni kipiik ni iwae i gur na timoor ni, ki buen ti ban upiih u wɔŋ na, ki ti saa buyoonn u ga kan u na. ");
INSERT INTO xon_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U yaa ti kan u kan, u ga li mɔɔni, ki di u buŋ usil, ki chaa kun. ");
INSERT INTO xon_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","U yaa ti fuu linampal kan, le u ga yin ni ujɔtiib ni udoyaab, ki nan bui bi, ‘Maapiih u wɔŋ na, m kan u. Cha ti li mɔɔni man.’ ");
INSERT INTO xon_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Liyataŋakl lee aatataa le ye ke titunwanbirdaan ubaa yaa kpeln waabimbin kan, paacham yaab ga li mɔɔni unii u kpeln waabimbin na pu, ki jer baah ga li mɔɔni bininyaam imonko inaa ni kipiik ni biwae bi kaa ban bi kpeln baabimbin na pu.” ");
INSERT INTO xon_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Upii ubaa yaa kpa tikunabr aamombil kipiik, libaa yaa wɔŋ kan, u ga see karyaa, le ki ŋal lidichal ni, ki lik mbamɔm ki ti kan li. ");
INSERT INTO xon_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tɔ, u yaa ti kan li kan, u ga yi ni unaakoontiib ni udoyaab, ki nan bui bi, ‘Maamombil li wɔŋ na, m kan li. Cha ti li mɔɔni man.’ ");
INSERT INTO xon_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Liyataŋakl lee aatataa le ye ke titunwanbirdaan ubaa yaa kpeln waabimbin kan, u pu le Uwumbɔr aatuuntiib ga li mɔɔni paacham.” ");
INSERT INTO xon_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu nan ki bui bi, “Uja ubaa nan bi ki nan kpa japɔtiib bilee. ");
INSERT INTO xon_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Le uwaatiir na bui u ke, ‘Nte, yakr maafaal ki di tii mi dandana.’ Le ute yakr bimɔk aafaal ki di tii bi. ");
INSERT INTO xon_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iwiin ilee aah jer na, le uwaatiir na kuun waafaal mɔmɔk, ki di buen kitiŋ ki daa na ni. Waah ti bi nima na, le u jin waafaal mɔmɔk yɔl yɔl, le li ti doo. ");
INSERT INTO xon_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Waah jin ni mɔmɔk ti doo na, le nkon sakpem lir nima chee. Igiin le nan gur joo u. ");
INSERT INTO xon_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Le u di ubaa ti kpaan kitiŋ ngbaan ni aanii ubaa chee. Le u tun u igbeer chee timoor ni ke u ti li ŋani i tijikaar. ");
INSERT INTO xon_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nkon aah joo u sakpen pu na, u ga ŋmaa ŋmɔ igbeer ngbaan aajikaar. Unii ubaa mu aa tii u nibaa. ");
INSERT INTO xon_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Le u ŋa nlan le ki bui ke, ‘Nte aatutum mɔmɔk ji ki gur. Le nkon ban mu ku mi do chee na. ");
INSERT INTO xon_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","M ga gir kun nte do, ki ti bui u ke, Nte, m koo aa ni Uwumbɔr mɔk aataani ni. ");
INSERT INTO xon_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Naa ki ŋan ke aa yin mi aajapɔɔn. Ŋa mi saah ŋani saatutum pu na.’ ");
INSERT INTO xon_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Le u fii ki cha ute do. “Waah laa bi ni daa na, le ute waa u, ki san u kinimbaak, le ki san tooh u nsan ni, ki ti di uŋaal kpal u, le ki moor utakpiln. ");
INSERT INTO xon_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Le ujapɔɔn bui u, ‘Nte, m koo aa ni Uwumbɔr mɔk aataani ni. Naa ki ŋan ke aa yin mi aajapɔɔn.’ ");
INSERT INTO xon_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Le ute bui waatutum, ‘Li cha mala ki ti yoor ni lininkpebɔkul nyaan na, ki nan di peen u, ki di kibɔmbik ŋmaan u, ki di ŋinaatak taŋ u, ");
INSERT INTO xon_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ki li joo ni unaabo u filk na, ki nan kɔr u, aan ti ji ki li mɔɔni. ");
INSERT INTO xon_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","M nan nyi ke njapɔɔn umina kpo a, le u bi. U nan wɔŋ a, le m ki kan u.’ Le bi piin ki bi mɔɔni. ");
INSERT INTO xon_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tɔ, ujapɔpol na nan bi kisaak. Waah nyan ni kisaak ki peen ni linampal na, le u ŋun bi gbaa tibar ki gaa ilahn. ");
INSERT INTO xon_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Le u yin bitutum ponn ni ubaa, le ki nan baa u, ‘Ni ye kinye?’ ");
INSERT INTO xon_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Le u bui u, ‘Aanaal na fuu ni a. Waah fuu ni ni laafee na, le aate cha bi kɔr unaabo u filk na.’ ");
INSERT INTO xon_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ukpel aah ŋun kina na, le u gee liŋuul, kaa ban u koo ni. Le ute nyan ni lipaal, ki nan gaŋ u ke u koo ni. ");
INSERT INTO xon_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Le u bui ute, ‘Lik, m tun lituln ŋibin sakpen le ki tii si, kaa kee yii saamɔb. Le saa po tii mi uŋobo ke m ni njɔtiib ji ki li mɔɔni. ");
INSERT INTO xon_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Aajapɔɔn umina le nan dii bipiidagoob ki ti bii saawangol mɔmɔk doo, le waah fuu ni na, aa kɔr unaabo u filk na ki tii u.’ ");
INSERT INTO xon_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Le ute bui u, ‘Maabo, aa bi m chee n‑yoonn mɔmɔk la. Sin le yeh maah kpa tiwan ni na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aanaal umina, m nan nyi ke u kpo a, le u bi. U nan wɔŋ a, le m ki kan u. Nima le ni ŋan ke ti li mɔɔni ki li kpa mpopiin.’” ");
INSERT INTO xon_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tɔ, Yesu nan bui waadidiliib, “Uwankpadaan ubaa le nan bi ki kpa ututunn u lik waawan mɔmɔk na. Le bibaa dan nan bii u udindaan aanimbiin ni ke u joo waawan ji la. ");
INSERT INTO xon_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Le udindaan yin u ki nan baa u, ‘Maah ŋun saabɔr ti na, ti ye kinye? Mɔk mi saah ŋa maawan pu na mɔmɔk. Saan ki li ye maatutunn.’ ");
INSERT INTO xon_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Le ututunn ngbaan dak usui ni, ‘Ndindaan ga nyan mi waatuln ni. M ga ŋa kinye? Maan ŋmaa ko kisaak. M mu yaa kpaln uwanmeer kan, inimɔɔn ga li joo mi. ");
INSERT INTO xon_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","M nyi maah ga ŋa pu na, aan ndindaan yaa nyan mi waatuln ni kan, bibaa gaa mi baadichal ni.’ ");
INSERT INTO xon_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Le u buen ti yin ni binib bi joo udindaan aapɔln na ke bi dan u chee ubaabaa ubaabaa, le ki baa njan yoo na, ‘Aa joo ndindaan aapɔln iŋa?’ ");
INSERT INTO xon_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Le u bui u, ‘Nkpan ankɔra nkub.’ Le u bui u, ‘Yoor saapɔln aagbaŋ ki kal mala ki ŋmee ankora piiŋmu.’ ");
INSERT INTO xon_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Le u baa uken, ‘Si, aa mu joo waapɔln iŋa?’ Le u bui u, ‘Idi bɔtɔ nkub.’ Le u bui u, ‘Yoor saapɔln aagbaŋ ki ŋmee bɔtɔ imonko inaa.’ ");
INSERT INTO xon_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tɔ, ututunn u kaa ŋan na aadindaan aah ŋun ni pu na, le u pak u, ke waah ŋa pu na, u kpa nlan la. Naatataa le ye ke dulnyaa wee aanib kpa nlan baabɔr ni ki jer Uwumbɔr aanib aah kpa pu na. ");
INSERT INTO xon_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“M tuk nimi la, ni di dulnyaa wee ni aawankpal ter bigiim, aan ni yaa doo kan, ni ga koo nkookoo yaan mu ga li bi ki cha n‑yoonn mu kaa kpa ndoon na ni. ");
INSERT INTO xon_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Unii u tun lituwaatiir mbamɔm na, u ga tun litusakpeln mu mbamɔm. Unii u kaa tun lituwaatiir mbamɔm na, waan tun litusakpeln mu mbamɔm. ");
INSERT INTO xon_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ni yaa kaa joo dulnyaa wee ni aawankpal mbamɔm kan, ŋma ga di Uwumbɔr aatuln ŋa aaŋaal ni? ");
INSERT INTO xon_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ni yaa kaa ŋa dulnyaa wee ni aawan mbamɔm kan, Uwumbɔr aan tii nimi paacham aawan. ");
INSERT INTO xon_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Unaagbiija ubaa aan ŋmaa tun lituln ki tii dindatiib bilee. U ga li nan ubaa, le ki li gee uken. U ga li si ubaa aachaŋ ni, le ki lik uken fam. Naan ŋmaa li dii Uwumbɔr ni liwankpal mu.” ");
INSERT INTO xon_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Le Farisii yaab, bi gee ŋimombil sakpen na, ŋun Yesu aah len tibɔr timina mɔmɔk pu na, le ki laa u. ");
INSERT INTO xon_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Le u bui bi, “Nimi le ban ke binib li dak ke ni ye bininyaam. Uwumbɔr le nyi nisui ni aah bi pu na. Binib aah nyuŋni tiwan ni na ye fam le Uwumbɔr chee. ");
INSERT INTO xon_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Uwumbɔr aakaal ni waabɔnabtiib aaliin nan joo binib ki nan saa Jɔnn u nan muini binib nnyun ni na aayoonn. Waayoonn ngbaan ki joo cha, le bi mooni Uwumbɔr aanaan aabɔnyaan tee. Le binib mɔk aabɔŋ koo Uwumbɔr aanaan ni mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Uwumbɔr aakaal mubaa aah ga ŋa yɔli pu na, ni pɔɔ ki jer paacham ni taab aah ga jer pu na. ");
INSERT INTO xon_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Uja umɔk jenn upuu lii ki ki yoor upii uken na, uja ngbaan kpaln udagoor la. Upii aachal yaa jenn u lii aan uja uken ki yoor u kan, uja ngbaan mu kpaln udagoor la.” ");
INSERT INTO xon_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tɔ, uwankpadaan ubaa nan bi, ki peeni tiwanpeenkaan nyaan, ki ji tijikaar ti mɔ na iwiin mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Le uwanmeer ubaa mu nan bi, bi nan yin u ke Lasarus. Le ibusoon joo u. Le bi joo u ti bilni uwankpadaan ngbaan aabisamɔb chee. ");
INSERT INTO xon_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Le u ban ke u li peei ŋisaabol ŋi nyan uwankpadaan ngbaan aateebul paab ki lir kitiŋ na ji. Le ibɔ mu choo nan lakr waabuun ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Naah joo cha na, le uwanmeer ngbaan nan kpo. Le Uwumbɔr aatuuntiib dan nan yoor u ki di buen paacham, Abraham chee. ");
INSERT INTO xon_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Le uwankpadaan ngbaan mu nan kpo. Le binib di u ti sub. Waah kpo na, le u ti bi mmii mu kaan junn na ni, ki ji falaa sakpen, le ki waan lik paacham, ki waa Abraham dandar, ki waa Lasarus mu bi u chee nima. ");
INSERT INTO xon_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Le u teen, ‘Nte Abraham, m ji falaa sakpen mmii mue ponn ni; san mi kinimbaak, ki tun Lasarus u ti di uŋanbik tu nnyun ki nan di meeh nlambil aan li sɔŋ.’ ");
INSERT INTO xon_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Le Abraham bui u, ‘Maabo, teer ke saah nan bi limɔfal ni na, aa nan bi ji saamɔɔn la. Lasarus mu nan bi ji falaa la. Dandana wee Lasarus aasui sɔŋ do chee na. Aa mu bi ji falaa la. ");
INSERT INTO xon_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Libuusakpeln mu bi ti ni saakaasisik ni, aan binib bi ban bi nyan do ki puur buen aa chee na taa ŋmaa puur, ubaa mu taa nyan aa chee ki dan do chee na.’ ");
INSERT INTO xon_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Le uwankpadaan ngbaan bui u, ‘Nte, ni yaa ye kina kan, m gaŋ si, tun Lasarus u buen nte do ");
INSERT INTO xon_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ki ti sur nnaatiib biŋmu bi gur na, bi taa dan do chee na, ki mu nan ji falaa wee.’ ");
INSERT INTO xon_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Le Abraham bui u, ‘Bi kpa Uwumbɔr Aagbaŋ. Bi li ŋun kigbaŋ ngbaan aah len pu na.’ ");
INSERT INTO xon_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Le u bui ke, ‘Nte Abraham, aayii, baan ŋun; unii yaa fikr nkun ni ki buen bi chee kan, nima le bi ga kpeln baabimbin.’ ");
INSERT INTO xon_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Le Abraham bui u, ‘Bi yaa kaa ŋun Uwumbɔr Aagbaŋ aah len pu na kan, unii yaa fikr nkun ni kan, nima le aan cha bi kpeln baabimbin.’” ");
INSERT INTO xon_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu nan bui waadidiliib, “Ntɔŋ ga sil li bi; tibɔbir mu bi unii u tɔŋni binib ke bi tun titunwanbir na pu. ");
INSERT INTO xon_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bi yaa ba tee di kinaasakpeŋ ki di tul leen uneen ni, ki tur u lii nnyusakpem nin chee nyoo na ni kan, ni ba soor ki tii u, ni u tɔŋ maadidiliib ponn ni uwaatiir ubaa u tun titunwanbir. ");
INSERT INTO xon_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ni li nyi man. “Aana aabo yaa ŋa si bakaa kan, sur u. U yaa kpeln waabimbin kan, di cha pinn u. ");
INSERT INTO xon_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","U yaa ŋa si bakaa nfum mulole nwiin mbaa ponn ni, ki yaa dan aa chee nfum mulole ki nan bui si, ‘M ŋa si gafara la,’ kan, aa di cha pinn u.” ");
INSERT INTO xon_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Le waakpambalb bui u, “Tidindaan, too kpee timi aanaadii pu.” ");
INSERT INTO xon_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Le u bui bi, “Ni yaa gaa Uwumbɔr ki kii siib na kan, ni ga ŋmaa bui busub ngbaan ke bu ŋɔb libuul ngbaan ni ki ti ŋum nnyusakpem ponn ni, le bu ga kii nimi aamɔb.” ");
INSERT INTO xon_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tɔ, ni ponn ni ubaa yaa kpa unaagbiija u ko kisaak, bee u kpaa ipiih na kan, u yaa nyan ni kisaak kan, saan bui u libuul ngbaan ni, ‘Nan ji tijikaar.’ ");
INSERT INTO xon_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aa ga bui u, ‘Ŋa tijikaar ki siin mi aan m ji ki nyu. M yaa jin doo kan, aa mu ga ji ki nyu.’ ");
INSERT INTO xon_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Saanaagbiija yaa ŋa saah ban pu na kan, aa ga doon u ke u ni lituln aa? Aayii. ");
INSERT INTO xon_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ni mu bi ke unaagbiija ngbaan aah bi pu na la. Ni yaa ŋa Uwumbɔr aah tuk nimi ke ni ŋa pu na mɔmɔk kan, ni bui ke, ‘Taa ŋeer ubaa pak timi. Ti po ŋa taah ba ga ŋa pu na la.’” ");
INSERT INTO xon_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu aah cha Jerusalem na, le u dii Samaria ni Galilee aatiŋ aanaanmɔk. ");
INSERT INTO xon_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Waah bi koo kitiŋ kibaa ni na, le bikɔndam kipiik ton u nsan ni, ki si ni daa siib, ");
INSERT INTO xon_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","le ki teen ke, “Tidindaan Yesu, san timi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu aah waa bi na, le u bui bi, “Li cha Uwumbɔr aatotoortiib chee, aan bi ti ŋaŋ nimi.” Baah cha na, le bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Le bi ponn ni ubaa aah kan ke u pɔɔk na, u gir ni, ki nyuŋni Uwumbɔr mpɔɔn pu, ");
INSERT INTO xon_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","le ki nan gbaan Yesu aanimbiin ni, ki doon u. ");
INSERT INTO xon_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Uja ngbaan nan ye Samaria aatiŋ aanii la. Le Yesu baa ke, “Maa cha bikɔndam kipiik pɔɔk la aa? ke biwae na bi la chee? ");
INSERT INTO xon_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ubaa aa gir ni u nan nyuŋ Uwumbɔr see uwɔwɔnja ngbaan baanja aa?” ");
INSERT INTO xon_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","le ki bui u, “Saah gaa mi ki kii na, nima le cha aa pɔɔk. Fiin ki li dii saasan.” ");
INSERT INTO xon_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Le Farisii yaab nan baa u, “Uwumbɔr aanaan ga fuu ni bayoonn?” Le u bui bi, “Uwumbɔr aanaan aah ga fuu ni pu na, binib aanimbil aan li waa mu. ");
INSERT INTO xon_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Baan ŋmaa bui ke, ‘Lik, mu bi do,’ kaan ŋmaa bui ke, ‘Mu bi nima la.’ Uwumbɔr aanaan bi ni ni.” ");
INSERT INTO xon_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Le u tuk waadidiliib, “N‑yoonn choo, le ninimbil ga li man min Unibɔn Aabo aah ga gir ni bundaln na, kaan kan. ");
INSERT INTO xon_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Le bi ga bui nimi, ‘Lik, u bi nima,’ ki ga ki bui ke, ‘Lik, u bi do.’ Ni taa buen ti lik, ki taa dii bi man. ");
INSERT INTO xon_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bundaln min Unibɔn Aabo ga nan gir ni na, ni ga li bi ke utaal aah moor ki wolni paacham mɔmɔk pu na, aan binib mɔmɔk ga li waa pu na la. ");
INSERT INTO xon_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dandana aanib ga yii mi, le m ga ji falaa sakpen waahr, aan ki nin buen paacham aan ki gir ni. ");
INSERT INTO xon_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Min Unibɔn Aabo aah ga gir ni buyoonn na ga li bi ke Nowa aayoonn aah nan bi pu na la. ");
INSERT INTO xon_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bi nan ji ki nyu, bijab nan yoor bipiib, bipiib mu nan mɔn bijab, ki ti saa bundaln Nowa nan koo buŋɔb ni na, le nnyusakpem fuu ni ki nan jin bi mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tɔ, maah ga gir ni bundaln na mu ga li bi ke Lot aayoonn aah nan bi pu na la. Bi nan ji ki nyu, ki daa tiwan ki kooh, ki bu tijikaar, ki maa tidir. ");
INSERT INTO xon_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bundaln Lot nyan Sodom aatiŋ ni na, le mmii ni chirbil nyan ni paacham ki lir ni, ki ku bi mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kina le ni ga li bi bundaln min Unibɔn Aabo ga nan nya ni mpaan pu na. ");
INSERT INTO xon_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“N‑yoonn ngbaan, unii yaa bi kidiik paab kan, u taa koo waadiik ponn ni u ti yoor waawan ni bi ki ponn ni na. Unii u bi kisaak na mu taa gir kun. ");
INSERT INTO xon_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Teer man tibɔr ti nan ŋa Lot aapuu na. ");
INSERT INTO xon_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Unii umɔk kaa di ubaa tii Uwumbɔr na kan, waamɔfal ga bee yɔli la. Unii umɔk di ubaa tii Uwumbɔr na kan, u ga kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","M tuk nimi la, buyoonn m ga gir ni na, binib bilee ga li dɔ kidiik kibaa ponn ni kinyeek. M ga nan yoor ubaa ki di buen, ki cha uken. ");
INSERT INTO xon_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bipiib bilee ga li boo nan idi. M ga nan yoor ubaa ki di buen, ki cha uken.  ");
INSERT INTO xon_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bijab bilee ga li bi kisaak. M ga nan yoor ubaa ki di buen, ki cha uken.” ");
INSERT INTO xon_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Le waadidiliib baa u, “Tidindaan, la chee?” Le u bui bi, “Liwankpol aah bi nin chee na, nangba mam mu kuuni nima chee la.” ");
INSERT INTO xon_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Le Yesu ŋakl bi liyataŋakl, u di mɔk bi ke ni ŋan bi li mee Uwumbɔr n‑yoonn mɔmɔk, ki taa cha bitaakpab yɔl. ");
INSERT INTO xon_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ubɔjir ubaa nan bi kitiŋ kibaa ni, kaa san Uwumbɔr, ki mu aa pak binib. ");
INSERT INTO xon_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ukpopii ubaa mu nan bi kitiŋ ngbaan ponn ni, le ki choo u chee n‑yoonn mɔmɔk, ki nan bui u ke u nyan u waadin aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","N‑yoonn mɔmɔk le u yiil ni ti yunn. Naah joo cha kina na, le u ti len usui ni, ‘Maa san Uwumbɔr, ki mu aa pak binib. ");
INSERT INTO xon_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Tɔ, ukpopii wee mu aah choo m chee n‑yoonn mɔmɔk ki nan muk mi sakpen pu na, m ga tii u waabamɔn, u taa ki beenin choo nan muk mi kina aan nsui ti nyan mbaa ponn ni.’” ");
INSERT INTO xon_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Le Yesu ki bui waadidiliib, “Li ŋun man ubɔjir u kaa ŋan na aah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Waah len ke u ga tii u waabamɔn pu na, Uwumbɔr aan tii waanib bi mee u n‑yoonn mɔmɔk nwiin pu ni kinyeek na baabamɔn aa? U ga taan aa? ");
INSERT INTO xon_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","M tuk nimi la, u ga tii bi baabamɔn mala. Min Unibɔn Aabo mu yaa nan gir ni kan, m ga kan binib beenin tii mi naadii dulnyaa wee ni ii?” ");
INSERT INTO xon_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Le Yesu ŋakl liyataŋakl tii binib bi dak ke bima le ŋan ki jer unibɔn mɔmɔk, kaa lik pak ubaa na ke, ");
INSERT INTO xon_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bijab bilee nan koo Uwumbɔr Aadichal ni ke bi ti mee Uwumbɔr. Ubaa nan ye Farisii aanii la, uken mu nan ye ulampoogaar. ");
INSERT INTO xon_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisii aanii na nan sil ubaa ki mee Uwumbɔr ki bui ke, ‘Uwumbɔr, m doon si ke maa bi ke binib mɔmɔk aah bi pu na. Maa kpa iniman, kaa tun lituln li kaa ŋan na, kaa gɔr kidagook, kaa bi ke ulampoogaar umina aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Likpaakool mɔmɔk ponn ni, m lulni bumɔb iwiin ilee la. Maah kan tinyoor timɔk na, m yakr nfum kipiik ki nyan tibaa tii si.’ ");
INSERT INTO xon_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ulampoogaar ngbaan nan sil dandar, kaa kaa u waan lik paacham. U nan po si jik uyil, le ki bui ke, ‘Uwumbɔr, san mi titunwanbirdaan kinimbaak,’ le ki siir kun. ");
INSERT INTO xon_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","M tuk nimi la, Uwumbɔr len ke ulampoogaar ngbaan aabɔr le ŋan, waa len ke Farisii aanii ngbaan aabɔr ŋan; ba pu? unii umɔk nyuŋ ubaa na, Uwumbɔr ga sunn u taab. Unii umɔk sunn ubaa taab na, Uwumbɔr ga nyuŋ u.” ");
INSERT INTO xon_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Le binib bibaa joo ni mbipɔm, ki di dan Yesu chee, ki ban ke u di uŋaal paan bi pu. Waadidiliib aah kan kina na, le bi kae bi. ");
INSERT INTO xon_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Le Yesu yin mbim ngbaan ke bi dan u chee, le ki bui waadidiliib, “Cha mbim ngbaan dan m chee man. Taa ki jenn bi man. Binib bi aabimbin bi ke mbim aah bi pu na, bima le yeh Uwumbɔr aanaan. ");
INSERT INTO xon_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","M tuk nimi mbamɔn la, unii umɔk kaa gaa Uwumbɔr aanaan ke ubo aah gaal tiwan pu na aan koo mu ni.” ");
INSERT INTO xon_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uyidaan ubaa nan baa Yesu, “Umɔmɔkr nyaan, m ga ŋa kinye ki kan limɔfal li kaa kpa ndoon na?” ");
INSERT INTO xon_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Le Yesu baa u, “Ba pu aa yin mi ke Umɔmɔkr nyaan? Ubaa aa ŋan, see Uwumbɔr baanja. ");
INSERT INTO xon_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aa nyi Uwumbɔr aakaal: ‘Taa gɔr kidagook; taa ku binib; taa su kinaayuk; taa li ye nnyamɔn aaseeraadaan; li pak aate ni aana.’” ");
INSERT INTO xon_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Le u bui u, “M joo nkaal mumina mɔmɔk tibir ni la.” ");
INSERT INTO xon_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu aah ŋun kina na, le u bui u, “Tiwan nibaa le gur. Kooh saah kpa tiwan ni na mɔmɔk, ki di ŋimombil ngbaan tii bigiim, aan ki li kpa liwangol paacham, aan ki dan nan dii mi.” ");
INSERT INTO xon_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Waah ŋun kina na, le ni ŋa u mpombiin sakpen; ba pu? u nan kpa liwankpal pam. ");
INSERT INTO xon_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu aah kan kina na, le u bui ke, “Ni pɔɔ sakpen binib bi kpa liwankpal na koo Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Uwankpadaan aah ga koo Uwumbɔr aanaan ni pu na, ni pɔɔ ki jer laakumii aah ga koo seerkaa aaboln ni pu na.” ");
INSERT INTO xon_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Le binib bi ŋun kina na bui ke, “Ni yaa ye kina kan, ŋma ga tee ŋmar?” ");
INSERT INTO xon_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Le Yesu bui ke, “Tiwan ni pɔɔ binib chee na aa pɔɔ Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Le Piita bui u, “Tima kan, ti nan di taah kpa nimɔk na ki di lii, ki dii si la.” ");
INSERT INTO xon_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Le Yesu bui bi, “M tuk nimi mbamɔn la, unii umɔk di cha waadichal, bee upuu, bee unaabitiib, bee ute, bee una, bee waabim, Uwumbɔr aanaan pu na kan, ");
INSERT INTO xon_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u ga kan ki jer waah di cha tiwan nimɔk na sakpen dandana wee. N‑yoonn mu choo na, u ga nan kan limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu nan di waadidiliib kipiik ni bilee na nyan n‑gbaan, le ki ti bui bi, “Li pel man, ti yaa fuu Jerusalem kan, bi ga ŋa min Unibɔn Aabo ke Uwumbɔr aabɔnabtiib aah nan ŋmee ke bi ga nan ŋa mi pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bi ga di mi ŋa binib bi kaa ye Juu yaab na aaŋaal ni, bi ti ŋa mi mbɔnyun, ki yook mi, ki teei timɔɔtan ŋani m pu, ");
INSERT INTO xon_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ki lue mi ŋinaalab, ki ga ku mi. Iwiin itaa daal le m ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Le baa bee iliin imina aatataa. Uwumbɔr le bɔr yaatataa. Nima le baa bee waah len pu na aatataa. ");
INSERT INTO xon_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Le Yesu aah peen Jeriko aatiŋ ni na, ujoon ubaa ka nsan aamɔgbeln, ki mee binib tiwan. ");
INSERT INTO xon_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Le u ŋun kinipaak aah choo pu na, ki baa ke, “Ba ŋa?” ");
INSERT INTO xon_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Le bi bui u, “Yesu u ye Nasaref aatiŋ aanii na le choo.” ");
INSERT INTO xon_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Le u teen ke, “Yesu, u ye Ubɔr David aayaabil na, san mi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Le binib bi loln Yesu pu nsan na kae u ke u ŋmin. Le u moo tar, “Ubɔr David aayaabil, san mi kinimbaak.” ");
INSERT INTO xon_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Le Yesu sil nsan ni, le ki bui bi, “Li joo ni u man.” Waah duun ni u na, le Yesu baa u, ");
INSERT INTO xon_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Aa ban ba?” Le u bui u, “Ndindaan, m ban ke aa likr nnimbil le tii mi.” ");
INSERT INTO xon_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Le u bui u, “Aa likr a. Saah gaa mi ki kii na, nima le cha aanimbil likr.” ");
INSERT INTO xon_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Libuul ngbaan ni le unimbil likr, le u dii u, le ki nyuŋni Uwumbɔr. Binib ngbaan mɔmɔk aah kan kina na, le bi pak Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu nan koo Jeriko aatiŋ ni, ki bɔ dii ki ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Uja ubaa nan bi nima, bi nan yin u ke Sakeus, u ye bilampoogaab aaninkpel, ki mu ye uwankpadaan la. ");
INSERT INTO xon_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Le u ban ke u kan Yesu aah bi pu na, ki mu ye kinigengeŋ. Kinipaak ngbaan pu, waa ŋmaa kan Yesu. ");
INSERT INTO xon_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Le u san ki loln kinipaak ngbaan pu nsan, le ki ti jon likakaln aasub pu ke u li waa Yesu aah ga jer nima chee pu na. ");
INSERT INTO xon_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu aah nan fuu ni nima chee na, le u waan lik, ki bui u, “Sakeus, sunn ni mala. Din, m ga doon aado.” ");
INSERT INTO xon_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Le u sunn ni mala, ki gaa u, ki kpa mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kinipaak ngbaan aah kan ke u koo Sakeus do na, le bi mɔmɔk ŋul u pu, ke u buen titunwanbirdaan do la. ");
INSERT INTO xon_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tɔ, Sakeus nan fii sil, ki bui u, “Ndindaan, lik, m ga di maawankpal ligeln tii bigiim la. Maah nan jin binib bi aawan na, m ga giin kina nfum munaa le ki di tii bi.” ");
INSERT INTO xon_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Le Yesu bui u, “Din le lidichal limina aanib ŋmar; ba pu? aa mu ye Abraham aayaabil la. ");
INSERT INTO xon_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Min Unibɔn Aabo dan m nan ban binib bi wɔŋ na ke bi ŋmar la.” ");
INSERT INTO xon_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu nan ŋakl binib bi ŋun tibɔr timina na liyataŋakl, bi taa li dak ke waah peen Jerusalem na Uwumbɔr aanaan ga fuu ni libuul ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","U nan bui bi, “Uyidaan ubaa nan ban u buen kitiŋ ki daa na ni, u ti ji nnaan ki gir ni. ");
INSERT INTO xon_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Le u yin waatutum kipiik, le ki di salmaa aamombil kipiik, ki di yakr bi ubaabaa, le ki bui bi, ‘Li joo tiir kitiir man, ki ti saa buyoonn m ga nan gir ni na,’ le ki buen. ");
INSERT INTO xon_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Le waatiŋ ni aanib nan nan u, ki tun binib ke bi paan u pu ki ti bui ubɔrkpaan na, ‘Taa ban ke uja ngbaan le ye timi aabɔr.’ ");
INSERT INTO xon_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Le u jin nnaan ngbaan, le ki gir kun, ki yin waatutum bi u nan tii bi ŋimombil ngbaan na, ke bi dan u chee, aan u lik bimɔk aah tiir kitiir ki kan tinyoor pu na. ");
INSERT INTO xon_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Le njan yoo dan nan bui u, ‘Ndindaan, saah nan tii mi limombil libaa li na, m kan tinyoor ŋimombil kipiik ki kpee.’ ");
INSERT INTO xon_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Le u bui u, ‘Nfaan. Aa ye ututunn nyaan la. Saah joo tiwan waatiir mbamɔm na, m ga ŋa si ntisakpem kipiik ni aaninkpel la.’ ");
INSERT INTO xon_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Le lelee yoo mu dan nan bui u, ‘Ndindaan, aa nan tii mi limombil libaa la. M kan tinyoor ŋimombil ŋiŋmu le ki kpee.’ ");
INSERT INTO xon_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Le u bui u mu, ‘M ga ŋa si ntisakpem muŋmu ni aaninkpel la.’ ");
INSERT INTO xon_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Le uken na mu dan nan bui u, ‘Ndindaan, lik, saamombil le na. M nan di likekegeln le poo li, ki di bil. ");
INSERT INTO xon_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aa ye unii u chur binib mpɔɔn na la. Aa gaal saah kaa yeh tiwan ni na, ki chee saah kaa nan bun tijikaar ti na. Nima le m san si ijawaan.’ ");
INSERT INTO xon_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Le u bui u, ‘Si ututunn u kaa ŋan na, saah len pu na, nima le bii si. Aa bui ke aa nyi ke m ye unii u chur binib mpɔɔn na ki gaal maah kaa yeh tiwan ni na, ki chee maah kaa nan bun tijikaar ti na. ");
INSERT INTO xon_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Saah nyi kina na, ba ŋa saa nan di maamombil ti bil banki ponn ni? Maah fuu ni na, m ba ga kan maamombil ni tinyoor ki kpee,’ ");
INSERT INTO xon_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","le ki bui binib bi si u chee na, ‘Chuu gaa waamombil libaa ngbaan man, ki di kpee ututunn u joo ŋimombil kipiik na.’ ");
INSERT INTO xon_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Le bi bui u, ‘Tidindaan, u kpa ŋimombil kipiik la.’ ");
INSERT INTO xon_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Le u bui bi, ‘M tuk nimi la, unii umɔk kpa na, bi ga kpee u. U kaa kpa na, bi ga chuu gaa waah kpa ni pɔkaa na. ");
INSERT INTO xon_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tɔ, maadim bi kaa nan ban ke m li ye baabɔr na, li joo ni bi do chee na, ki nan ku bi nnimbiin ni.’” ");
INSERT INTO xon_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu aah ŋakl bi liyataŋakl ngbaan ti doo na, le u loln bi pu nsan ki cha Jerusalem. ");
INSERT INTO xon_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Waah nan peen ni Befej ni Betani aatim mu bi lijool li bi yin li ke Olif aasui aajool paab na, ");
INSERT INTO xon_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","le u tuk waadidiliib ponn ni bilee, “Li cha man naah si gbɔk kitiŋ ki na. Ni yaa koo ki ponn ni kan, ni ga kan ubon u laa diin na si gbin. Ubaa aa kee diŋ u pu. Chuu gbiln u, ki li joo ni u m chee man. ");
INSERT INTO xon_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Unii ubaa yaa baa nimi, ‘Ba ŋa ni chuu gbiln u?’ kan, ni bui u, ‘Tidindaan le ban u.’” ");
INSERT INTO xon_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu aah tun bi pu na, le bi buen, ki ti kan ubon u laa diin na waah tuk bi ke bi ga kan pu na. ");
INSERT INTO xon_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Baah bi gbilni u na, le binib bi yeh u na baa bi, “Ba ŋa ni bi gbilni ubon ngbaan?” ");
INSERT INTO xon_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Le bi bui bi, “Tidindaan le ban u,” ");
INSERT INTO xon_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","le ki joo ni u Yesu chee, ki di baakeken paan u pu, ki di Yesu diŋ u pu. ");
INSERT INTO xon_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Le waah cha na, kinipaak ngbaan di baakeken ter nsan ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Le u peen Jerusalem, ki fuu baah sunni Olif aasui aajool nin chee na. Baah fuu nima chee na, le kinipaak kimɔk dii u na piin ki bi mɔɔni. Baah kan u tun lijinjiir aatun mɔmɔk pu na, le bi pak Uwumbɔr mpɔɔn pu, ");
INSERT INTO xon_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ki bui ke, “Uwumbɔr aanyoor bi Ubɔrkpaan u choo waayimbil ni na pu. Lifuur bi paacham. Ni li nyuŋni Uwumbɔr paacham man.” ");
INSERT INTO xon_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Le Farisii yaab bi bi kinipaak ngbaan ponn ni na bibaa bui Yesu, “Umɔmɔkr, tuk saadidiliib ngbaan ke bi kpa kifuuk.” ");
INSERT INTO xon_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Le Yesu bui bi, “M tuk nimi la, bi yaa ŋmin kan, ŋitakpal ŋimina ga li tar la.” ");
INSERT INTO xon_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu aah peen Jerusalem aatiŋ na, le u waa ki, ki wii sakpen ki pu, ");
INSERT INTO xon_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ki bui ke, “Jerusalem aatiŋ aanib, ni yaa ba nyi nsuudoon aasan din kan, ni ba ga li ŋan ki tii nimi. Dandana wee, mu bɔr ke ninimbil taa li waa mu. ");
INSERT INTO xon_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Buyoonn Uwumbɔr ban u ter nimi na, ni yii a. Nima le nimi aadim ga nan gob nimi aatiŋ, ki yuu lakr kaagoln pu, ");
INSERT INTO xon_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ki kuln ni mɔmɔk, ki gbaa wii nimi aadir mɔmɔk. Tidir ngbaan aatakpal ŋilee aan ki li bi ki tok tɔb pu.” ");
INSERT INTO xon_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu nan koo Uwumbɔr Aadichal ponn ni, le ki jenn nyan binib bi kooh tiwakor na, ");
INSERT INTO xon_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","le ki tuk bi, “Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr len ke, ‘Bi ga yin maadichal ke Mmeen Aadichal;’ tɔ, nimi le ŋa li bififiirb aakakaa chee.” ");
INSERT INTO xon_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iwiin mɔmɔk Yesu nan bi Uwumbɔr Aadichal ponn ni, ki tuk binib Uwumbɔr aabɔr. Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni Juu yaab aaninkpiib ka ki kpokl baah ga ŋa pu ki ku Yesu na, ");
INSERT INTO xon_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kaa ŋmaa kan baah ga ku u pu na; ba pu? binib ngbaan mɔmɔk aanimbil man ke bi ŋun waah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kitaak kibaa daal, le waah bi Uwumbɔr Aadichal ni ki tuk binib Uwumbɔr aaliin, ki mooni tibɔnyaan tee na, le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb, ni Juu yaab aaninkpiib dan u chee, ");
INSERT INTO xon_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","le ki nan baa u, “Aa kpa nsan ke aa ŋa saah ŋani pu na aa? Ŋma tii si nsan ngbaan? Tuk timi.” ");
INSERT INTO xon_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Le u bui bi, “M mu ga baa nimi mbaan. ");
INSERT INTO xon_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jɔnn aah nan muini binib nnyun ni na, ŋma nan tii u nsan? Uwumbɔr aan binib? Tuk mi man.” ");
INSERT INTO xon_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Le bi kpokl tɔb, “Ti yaa bui ke Uwumbɔr le nan tii u nsan kan, u ga baa timi ke ba ŋa taa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ti yaa ki len ke binib le tii u nsan kan, binib ngbaan mɔmɔk ga mae timi ŋitakpal; bi mɔmɔk len ke Jɔnn nan ye Uwumbɔr aabɔnabr la.” ");
INSERT INTO xon_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nima le bi bui Yesu ke baa nyi udaan u tii Jɔnn nsan na. ");
INSERT INTO xon_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Le Yesu bui bi, “M mu aan tuk nimi maah kpa nsan pu ki ŋani maah ŋani pu na.” ");
INSERT INTO xon_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Le u ŋakl binib ngbaan liyataŋakl, “Uja ubaa nan naan kisaak, ki ŋum isui i lu ŋisubil na ki ponn ni, le ki yin bikpaab bibaa, ki di kisaak ngbaan ŋa biŋaal ni ke bi li lik ki. Isui ngbaan yaa nan lun ŋisubil kan, bi ker tii u, aan ki ker bibaa mu. Waah ŋa kina na, le u siir ki buen kitiŋ ki daa na ni, ki ti yunn nima. ");
INSERT INTO xon_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Buyoonn ŋisubil ngbaan nan puir na, le u di unaagbiija ubaa tun bikpaab ngbaan chee ke bi tii ni u kisaak ngbaan ponn ni aasubil. Le bi gbaa u, ki giin ni u, kaa tii u nibaa. ");
INSERT INTO xon_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Le u ki di unaagbiija uken tun bi chee. Le bi ti gbaa u mu, ki yook u, le ki giin ni u, kaa tii u nibaa. ");
INSERT INTO xon_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Le u ki tun unaagbiija tatar bi chee. Le bi ti gbaa u mu, ni ti ŋa u iween, le ki jenn nyan u nima. ");
INSERT INTO xon_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Le usadaan ngbaan bui ke, ‘M ga ŋa kinye? M ga di maabogeehn le tun bi chee. Nibaakan, bi ga pak uma.’ ");
INSERT INTO xon_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Le bikpaab ngbaan aah kan waabo ngbaan choo na, le bi kpokl tɔb, ‘Uma le ye waafaajil. Cha ti ku u man, aan ki ji waafaal.’ ");
INSERT INTO xon_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Le bi chuu u, ki di nyan n‑gbaan, le ki ti ku u. “Kina pu na, usadaan ngbaan ga ŋa bi kinye? ");
INSERT INTO xon_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U ga dan nan ku bikpaab ngbaan, ki di kisaak ngbaan tii bikpaab biken.” Kinipaak ngbaan aah ŋun kina na, le bi bui ke, “Uwumbɔr taa cha ni pii bi.” ");
INSERT INTO xon_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Le Yesu lik bi, ki bui bi, “U yaa kaa ŋa bi kina kan, Uwumbɔr Aagbaŋ aah len pu na aatataa ye kinye? ke, ‘Litakpal li bidimaab yii li na, lima le ye litakpajal.’ ");
INSERT INTO xon_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Unii umɔk lir litakpal ngbaan pu na, u ga kool. Unii u litakpal ngbaan lir u pu na, li ga nan u, u ŋa ke ntayon na.” ");
INSERT INTO xon_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Uwumbɔr aakaal aamɔmɔkb, ni Uwumbɔr aatotoorninkpiib nan bee ke Yesu di liyataŋakl ngbaan ŋaŋ bima la. Nima pu, le bi nan ban bi chuu u libuul ngbaan ni, ki mu san kinipaak ngbaan ijawaan. ");
INSERT INTO xon_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Le bi ban nsan mu pu bi ga chuu u na, ki di bipepekb tun u chee, bi ti ŋmann ke bi ye bininyaam la, aan ki pen u nlan, aan ki chuu u, ki di ŋa kitiŋ ngbaan aayidaan aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Le bi dan nan bui u, “Umɔmɔkr, ti nyi ke aa len mbamɔn, ki tuk binib Uwumbɔr aabɔr mbamɔm, kaa pak ubaa ki jer uken. Aa po mɔk bi Uwumbɔr aasan mbamɔm la. ");
INSERT INTO xon_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tuk timi, ni ŋan ti pa lampoo ki di tii Ubɔrkpaan Siisa aan naa ŋan?” ");
INSERT INTO xon_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Le Yesu bee ke bi pen u nlan la, le ki bui bi, ");
INSERT INTO xon_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mɔk mi limombil man.” Baah mɔk u na le u baa bi, “Ŋma aanaŋ ni liyimbil bi li pu?” Le bi bui u, “Siisa yaan.” ");
INSERT INTO xon_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Le u bui bi, “Nima pu na, ni di ni ye Siisa yaan na tii u man, ki di ni ye Uwumbɔr yaan na tii Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu aah len kina na, le ni gar bi pam. Baa ŋmaa chuu u taani waabɔlen pu, binib aanimbil ni. Le bi ŋmin. ");
INSERT INTO xon_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Le Sajusii yaab bibaa dan u chee. Bima le len ke binib aan fikr nkun ni na. ");
INSERT INTO xon_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Le bi bui u, “Umɔmɔkr, Moses nan ŋmee nkaal tii timi ke, ‘Uja yaa kpa puu ki yaa kpo, kaa kpa ubo kan, unaal di ukpopii ngbaan kpan, ki maa mbim tii ukpel.’ ");
INSERT INTO xon_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tɔ, naabitiib bilole nan bi. Upol na nan yoor upii, le ki kpo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Le unaal di ukpopii ngbaan kpan, ki mu kpo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Le u paa u pu na mu ŋa kina. Le bijab bilole ngbaan mɔmɔk ŋa kina, ki kpo doo, kaa kpa ubo. ");
INSERT INTO xon_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kookoo yoo le upii ngbaan mu kpo. ");
INSERT INTO xon_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kina pu na, binib yaa nan fikr nkun ni kan, upii ngbaan ga li ye ŋma aapuu? Bi mɔmɔk bilole nan joo u la.” ");
INSERT INTO xon_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Le Yesu bui bi, “Dulnyaa wee ponn ni, bijab yoor bipiib la. Bipiib mu mɔn bijab la. ");
INSERT INTO xon_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Binib bi ŋeer ke bi fikr nkun ni ki li bi dulnyaa u choo na ni na aan yoor bipiib. Bipiib mu aan mɔn bijab. ");
INSERT INTO xon_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bi ga li bi ke Uwumbɔr aatuuntiib aah bi pu na, kaan ki kpo. Baah ga fikr nkun ni na, bi ga li ye Uwumbɔr aabim la. ");
INSERT INTO xon_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tɔ, Moses mu nan mɔk timi ke binib bi kpo na ga fikr nkun ni. Buyoonn u nan bi busub bu gaal mmii na chee na, u nan yin Uwumbɔr ke Abraham, ni Aisak, ni Jakob Aawumbɔr la. ");
INSERT INTO xon_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uwumbɔr yaa len ke u ye binib bi kpo na Aawumbɔr kan, nima le mɔk ke bi kpa limɔfal. Bi mɔmɔk ye binifuub Uwumbɔr chee la.” ");
INSERT INTO xon_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Le Uwumbɔr aakaal aamɔmɔkb bibaa bui Yesu, “Umɔmɔkr, saah len pu na, ni ŋan la.” ");
INSERT INTO xon_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Le baa kaa bi ki baa u mbaan. ");
INSERT INTO xon_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Le Yesu baa bi, “Binib ŋa kinye pu ki bui ke Kristo u ga gaa binib lii na ye Ubɔr David aayaabil? ");
INSERT INTO xon_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ubaa nan len Uwumbɔr aalahn aagbaŋ ponn ni ke, ‘Uwumbɔr bui Ndindaan ke: Kal ŋŋangii wɔb, ");
INSERT INTO xon_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ki ti saa buyoonn m ga nyaŋ saadim mɔmɔk na.’ ");
INSERT INTO xon_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David aah nan yin Kristo ngbaan ke Udindaan kina na, Kristo ga li ŋmaa ye uyaabil aa?” ");
INSERT INTO xon_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kinipaak ngbaan aah pel Yesu aah len pu na, le u bui waadidiliib, ");
INSERT INTO xon_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ni li nyi man Uwumbɔr aakaal aamɔmɔkb aabɔr. Baageehn le ye ke bi li pee ŋibɔkul fɔfɔk, ki gee ke binib li dooni bi kinyaŋ ni, ki gee ke bi kal bininyuum aakakaa chee mmeen aadir ni, ni njim chee. ");
INSERT INTO xon_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bi ji bikpopiib durm la, le ki mee Uwumbɔr ni yunni ke bi ŋmann ke bi ye bininyaam la. Uwumbɔr ga daa bitafal ki jer waah ga daa binib biken aatafal pu na.” ");
INSERT INTO xon_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu nan yaar lik, ki kan biwankpadam joo ŋimombil pam ŋani Uwumbɔr aapiin aadakaa ni, ");
INSERT INTO xon_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ki kan ukpopiigiin ubaa mu di janjan bilee ki di ŋa u ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Le Yesu bui ke, “M tuk nimi mbamɔn la, ukpopiigiin wee tii ŋimombil ki jer bi mɔmɔk aah tii pu na. ");
INSERT INTO xon_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bi mɔmɔk tii ki gur ŋimombil sakpen. U ye ugiin la, le ki di waamombil mɔmɔk tii, kaa ki gur nibaa.” ");
INSERT INTO xon_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tɔ, binib bibaa nan bi len Uwumbɔr Aadichal aah ŋan pu na, ki kpa ŋitakpanyaan, ni ipiin i binib tii Uwumbɔr na. ");
INSERT INTO xon_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Le Yesu bui bi, “N‑yoonn choo, bi ga nan gbaa wii lidichal limina mɔmɔk. Litakpal libaa aan ki li paa liken pu.” ");
INSERT INTO xon_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Le Yesu aadidiliib baa u, “Umɔmɔkr, bi ga ŋa kina bayoonn? Ba ga li ye limɔkl ki mɔk timi ke ni ŋeer bi ŋa kina?” ");
INSERT INTO xon_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Le u bui bi, “Ni li nyi man, aan ubaa taa ŋmann nimi. Binib pam ga nan dan ki pur maayimbil ke bima le ye min Yesu, ki ga bui ke ni ŋeer a. Ni taa dii bi man. ");
INSERT INTO xon_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ni yaa ŋun ke ntim mubaa aanib to tɔb butɔb, aan ntim muken aanib kpa tibɔr kan, ni taa san ijawaan man. Uwumbɔr le siin ke nimina mɔmɔk ga ŋa. Nima le aan mɔk ke dulnyaa wee ga doo libuul ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Linibol libaa ga to linibol liken butɔb. Nnaan mubaa aanib ni nnaan muken aanib ga to tɔb butɔb. ");
INSERT INTO xon_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kitiŋ ga deŋ sakpen ŋipepel ŋipepel. Nkon mu ga lir. Iween mu ga lir, ki ku binib pam ntim ntim ponn ni. Lijinjiir aawan, ni tiwan ni faani binib na mu ga li bi paacham. ");
INSERT INTO xon_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nimina mɔmɔk aa kaa kee ŋa buyoonn na, le bi ga chuu nimi, ki ŋa nimi falaa, ki di nimi ŋa mmeen aadir ni ki ji nimi tibɔr, ki di nimi ŋa kiyondiik ponn ni. M pu, le bi ga di nimi siin bibɔrb ni ntim aaninkpiib aanimbiin ni ke bi ji nimi tibɔr. ");
INSERT INTO xon_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nima le ga tii nimi nsan le ni tuk bi tibɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ni di ŋa nisui ni man ke naan puen baa nisui ni ke ni ga len kinye? ");
INSERT INTO xon_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","M ga tuk nimi naah ga len pu na, aan nimi aadim ubaa taa ki ŋmaa kpak nimi, kaan ki ŋmaa len tibaa. ");
INSERT INTO xon_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nitetiib, ni ninatiib, ni ninaabitiib, ni nidoyaab, ni nijɔtiib, ga kooh nimi. Le binib ga ku ni ponn ni bibaa. ");
INSERT INTO xon_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Binib mɔmɔk ga li nan nimi m pu. ");
INSERT INTO xon_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ni mu aan bee yɔli; nimi aayikpirk kibaa le aan bee yɔli. ");
INSERT INTO xon_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ni yaa ji limɔr falaa mɔmɔk ponn ni kan, ni ga kan limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ni yaa kan butɔb aajab si gob Jerusalem aatiŋ kan, ni li nyi man, naan yunn, le bi ga bii kitiŋ ngbaan doo. ");
INSERT INTO xon_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","N‑yoonn ngbaan yaa nan fuu ni kan, binib bi bi Judea aatiŋ ponn ni na san buen ŋijoo paab. Binib bi bi Jerusalem ponn ni na mu li nya ki ni. Binib bi bi itingbaan ni na, bi taa koo ni Jerusalem aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","N‑yoonn ngbaan le Uwumbɔr ga daa Jerusalem aatiŋ aanib aatafal, aan ni gbiin waagbaŋ aah ŋmee pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","N‑yoonn ngbaan, bipiib bi kpa ŋipuu na, ni bipiib bi kpa mbim bi laa ŋaa libiil na ga li kpa kinimbaak; ba pu? Uwumbɔr ga gee liŋuul sakpen kitiŋ ngbaan aanib pu. Bi ga ji falaa pam. ");
INSERT INTO xon_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bi ga di kijaak aajum ku bibaa, ki ga chuu bibaa mu tinaagbiir ki di buen ŋinibol mɔmɔk aakaasisik ni. Le binib bi kaa ye Juu yaab na ga bii Jerusalem ki ti saa baayoonn aah ga doo pu na.” ");
INSERT INTO xon_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Lijinjiir aawan ga li bi nwiin, ni uŋmal, ni ŋiŋmabil ponn ni. Nnyusakpem ga ŋa tinyunkpenn sakpiin, ki faa kifuuk sakpen, ki ŋa binib ilandak. Baan ki li nyi baah ga ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Paacham aawan aan ki li bi mbamɔm. Nima le binib ga lik naah ga li bi pu dulnyaa wee ni na, ki ga san ijawaan ki ti fik. ");
INSERT INTO xon_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","N‑yoonn ngbaan le bi ga kan min Unibɔn Aabo bi ntaalangbam ni ki choo, ki wiin chain, ki joo mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ni yaa kan tiwan nimina mɔmɔk bi ŋani kan, chuu nibaa man, ki pɔɔk nitaakpab. Naan yunn le ni ga ŋmar.” ");
INSERT INTO xon_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu nan ŋakl bi liyataŋakl ke, “Ni li lik bukpasɔm ni isui mɔmɔk man. ");
INSERT INTO xon_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ni yaa nan kan yaabon bi ŋani tifar kan, ni bee ke ni yaa kpee siib kan, kiseek ga seer. ");
INSERT INTO xon_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kina na, ni yaa kan nimina bi ŋani kan, ni bee ke ni yaa kpee siib kan, Uwumbɔr aanaan ga fuu ni. ");
INSERT INTO xon_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“M tuk nimi mbamɔn la, dandana aanib aan jer le tiwan nimina mɔmɔk puen ŋa. ");
INSERT INTO xon_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Paacham ni taab ga jer. Maamɔbon ma aan jer.” ");
INSERT INTO xon_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ni li nyi man, ki taa nyu ndaan gbii ki li kpa ndaan aaween, ki taa cha nimi aabimbin aabɔr gbiin nimi aalandak mɔmɔk, aan maagirndaal taa yuk nipobil. ");
INSERT INTO xon_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maagirndaal kan, dulnyaa wee ni aanib mɔmɔk aapobil ga yuk ke gaawɔb aah chuu upeel kan, upobil yukr pu na. ");
INSERT INTO xon_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Li nyi man n‑yoonn mɔmɔk, ki mee Uwumbɔr u tii nimi mpɔɔn ke ni nya falaa umɔk choo na ni, ki nan sil min Unibɔn Aabo aanimbiin ni.” ");
INSERT INTO xon_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iwiin mɔmɔk le Yesu nan bi Uwumbɔr Aadichal ni, ki tuk binib Uwumbɔr aabɔr. Tinyer mɔmɔk le u buen Olif aasui aajool paab ki ti dɔ geen. ");
INSERT INTO xon_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kichakpinaanyeek ni mɔmɔk le binib chaa u chee Uwumbɔr Aadichal ni, bi ti ŋun waah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","N‑yoonn ngbaan, naa nan ki daa ke bi ji Lakr‑jer aajim, ki ŋmɔ boroboro u kaa kpa nnyɔk na. ");
INSERT INTO xon_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb nan kpokl baah ga ŋa pu ki ku Yesu na. Bi mu nan san binib na ijawaan. ");
INSERT INTO xon_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Le kinimbɔŋ koo Judas Iskariot aasui ni. Judas nan ye Yesu aadidiliib kipiik ni bilee na ponn ni ubaa. ");
INSERT INTO xon_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kinimbɔŋ aah koo Judas aasui ni na, le u buen Uwumbɔr aatotoorninkpiib, ni Uwumbɔr Aadichal aakikiirb aaninkpiib chee, u ti kpokl bi waah ga ŋa pu ki di Yesu ŋa biŋaal ni na. ");
INSERT INTO xon_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Le bi nan kpa mpopiin, ki puu tipuur ke bi ga tii u ŋimombil. ");
INSERT INTO xon_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Le u kii, ki ban nsan mu u ga di Yesu ŋa biŋaal ni, buyoonn kinipaak ngbaan aa bi u chee na. ");
INSERT INTO xon_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lakr‑jer aajim, buyoonn bi ga ŋmɔ boroboro u kaa kpa nnyɔk na aawiin mu daal bi ga kɔr upihbo na, ");
INSERT INTO xon_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","le Yesu bui Piita ni Jɔnn, “Li cha ti gor njim ngbaan aajikaar aan ti ji.” ");
INSERT INTO xon_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Le bi baa u, “Aa ban ke ti gor ti la chee?” ");
INSERT INTO xon_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Le u bui bi, “Ni yaa koo kitiŋ ngbaan ni kan, uja u tu nnyun na ga ton nimi nsan ponn ni. Ni li dii u man, ki ti koo waah ga koo lidichal li ponn ni na, ");
INSERT INTO xon_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ki bui udichadaan na, ‘Umɔmɔkr bui ke u ni waadidiliib ga ji njim ngbaan aajikaar kiladiik ni?’ ");
INSERT INTO xon_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Le u ga mɔk nimi paacham aadisakpeŋ ki bi puen toor ki na. Ni gor njim ngbaan aajikaar nima chee.” ");
INSERT INTO xon_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Le bi buen, ki ti kan Yesu aah tuk bi ke bi ga kan pu na. Le bi gor njim ngbaan aajikaar. ");
INSERT INTO xon_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tijikaar aajim yoonn aah fuu ni na, le Yesu ni waadidiliib dan nan kal. ");
INSERT INTO xon_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Le u bui bi, “Nnimbil nan man ke m ni nimi kpaan ji njim mue waahr aan m nin ji maafalaa ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","M tuk nimi la, maan ki ji njim mue ki ti saa buyoonn Uwumbɔr ga nan ŋa mu aah mɔk pu na waanaan ni.” ");
INSERT INTO xon_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu nan yoor kiyinyook, le ki doon Uwumbɔr, le ki bui bi, “Gaa man ki yakr tɔb. ");
INSERT INTO xon_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","M tuk nimi la, maan ki nyu ŋisubil aanyun ngbaan ki ti saa buyoonn Uwumbɔr aanaan ga fuu ni na.” ");
INSERT INTO xon_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Le u yoor boroboro, le ki doon Uwumbɔr, ki gii, ki di tii waadidiliib ki bui bi, “Maawon le na. Nimi aatunwanbir pu le m tii tiwon tee. Ni li ŋmɔ kina aan ki li teer mbɔr.” ");
INSERT INTO xon_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Baah jin tijikaar ngbaan ti doo na, le u yoor kiyinyook, ki doon Uwumbɔr, ki di tii bi, le ki bui bi, “Tiwanyukaan ngbaan ye maasin aamɔkl la. Maasin ga nya nimi aatunwanbir pu la. Maasin pu, le Uwumbɔr puu tipuupɔln tii nimi. ");
INSERT INTO xon_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lik, unii u ga kooh mi na, m ni uma le aaŋaal kpaan bi lisambil ni na. ");
INSERT INTO xon_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Min Unibɔn Aabo ga sil kpo, Uwumbɔr aah nan len ke m ga kpo pu na. Tibɔbir mu ga li bi uja u ga kooh mi na pu.” ");
INSERT INTO xon_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Le waadidiliib baa tɔb, “Ti ponn ni, ulau ga tee ŋa kina?” ");
INSERT INTO xon_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tɔ, Yesu aadidiliib nan kpak tɔb kinikpakpak ke ulau tee ye uninyuun bi ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Le u bui bi, “Dulnyaa wee ni aanibol aabɔrb yoor bibaa paacham la. Binib bi kpa tininkpir na, baanib yin bi baateterb la. ");
INSERT INTO xon_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nimi, ni taa li bi kina man. Unii u ye uninyuun ni ponn ni na kan, u ŋa ubaa ke uwaatiir na. Unii u ye usaloln na kan, u ŋa ubaa ke nimɔk aatutunn na. ");
INSERT INTO xon_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Unii u ŋa tijikaar na, ni unii u ji na, ŋma jer uken? Naa ye unii u ji na aa? Mma kan, m bi ke ututunn na le ni ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Tɔ, maah bi ntɔŋ ni na, nimi le sil nchaŋ ni. ");
INSERT INTO xon_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","M ga ŋa nimi bibɔrb ke Nte Uwumbɔr aah ŋa mi ubɔr pu na. ");
INSERT INTO xon_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Le ni ga ji tijikaar ki nyu nnyun m chee maanaan ni, ki kal ŋibɔrjal pu, ki ji Israel yaab aanibol kipiik ni ŋilee tibɔr.” ");
INSERT INTO xon_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Le Yesu bui Simonn Piita, “Simonn, Simonn, lik, kinimbɔŋ kan nsan ke ki tɔŋ nimi, aan ni lir. ");
INSERT INTO xon_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Le m mee Uwumbɔr tii si, aa taa di cha maasan. Aa yaa ki gir ni ki nan dii mi kan, pɔɔn aanaabitiib aataakpab.” ");
INSERT INTO xon_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Le Piita bui u, “Ndindaan, m ga ŋmaa kpaan aa chee kiyondiik ni. M ni si ga ŋmaa kpaan ki kpo.” ");
INSERT INTO xon_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Le Yesu bui u, “Piita, m tuk si la, din, aa ga len nfum mutaa ke saa nyi mi, le ukooja nin wii.” ");
INSERT INTO xon_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tɔ, Yesu nan baa bi, “Maah nan tun nimi ki nan bui nimi ke ni taa li joo ŋimombil aataakɔr, ki taa li joo litaakɔr mu, ki taa li joo ŋinaatak na, ni nan lann nibaa aa?” Le bi bui u, “Taa nan lann nibaa.” ");
INSERT INTO xon_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Le u bui bi, “Dandana wee, naa ki bi ke naah nan bi pu na. Unii u kpa ŋimombil aataakɔr na kan, u li joo li. Unii u kpa litaakɔr mu na kan, u li joo li. Unii u kaa kpa kijaak aajuk na kan, u di waabɔkul kooh, ki daa kibaa. ");
INSERT INTO xon_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","M tuk nimi la, ni ŋmee Uwumbɔr Aagbaŋ ponn ni ke bi ga ŋa mi ke baah ŋani titunwanbirdam pu na. Le bi ga sil ŋa mi kina. Baah nan ŋmee maabɔr pu na, ni mɔmɔk bi gbiini la.” ");
INSERT INTO xon_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Le bi bui u, “Ndindaan, lik, ti kpa kijaak aajum mulee la.” Le u bui bi, “Ni ŋeer a.” ");
INSERT INTO xon_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Le u nyan nima, le ki buen Olif aasui aajool paab, waah chaa nima n‑yoonn mɔmɔk pu na. Waadidiliib mu dii u. ");
INSERT INTO xon_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Waah ti fuu nima chee na, le u bui bi, “Ni li mee Uwumbɔr man, aan ki taa koo ntɔŋ ni.” ");
INSERT INTO xon_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Le u siir cha bi, ki foor siib, le ki gbaan kitiŋ ki mee Uwumbɔr ke, ");
INSERT INTO xon_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Nte, ni yaa ye saageehn kan, nyan mi falaa u choo na ni. Tɔ, ŋa saageehn, ki taa ŋa maageehn.” ");
INSERT INTO xon_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Le Uwumbɔr aatuun nyan ni paacham ki dan u chee ki nan pɔɔk utaakpab. ");
INSERT INTO xon_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Le Yesu aasui ponn ni wu ki ti nyaŋ. Le u ki mee Uwumbɔr linimaln. Le kitotoŋ naa u, ki ye nsin ki tuu lir kitiŋ. ");
INSERT INTO xon_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Le u mee Uwumbɔr ti doo, le ki fii, ki gir buen waadidiliib chee, ki ti mui bi dɔ geen, mpombiin pu. ");
INSERT INTO xon_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Le u baa bi, “Ba ŋa ni dɔ geen? Fiin, ki li mee Uwumbɔr man, aan ki taa koo ntɔŋ ni.” ");
INSERT INTO xon_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Waah laa bi len kina na, le kinipaak fuu ni bi chee. Judas u ye waadidiliib kipiik ni bilee ponn ni ubaa na, loln kinipaak ngbaan pu nsan, le ki buen Yesu chee ke u moor utakpiln. ");
INSERT INTO xon_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Le Yesu baa u, “Judas, aa moor ntakpiln ke aa kooh min Unibɔn Aabo oo?” ");
INSERT INTO xon_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu aadidiliib aah kan ke binib ngbaan ban bi chuu u na, le bi baa u, “Tidindaan, ti di kijaak aajum jan bi ii?” ");
INSERT INTO xon_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Le waadidiliib ponn ni ubaa di kijaak aajuk ki gaa per Uwumbɔr aatotoorninkpel aatutunn aatafagiir. ");
INSERT INTO xon_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Le Yesu bui bi, “Di cha kina man,” le ki di uŋaal meeh utafal le ki cha li pɔɔk. ");
INSERT INTO xon_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Le Yesu baa Uwumbɔr aatotoorninkpiib, ni Uwumbɔr Aadichal ni aakikiirb, ni Juu yaab aaninkpiib bi dan bi nan chuu u na, “Ni joo kijaak aajum ni jagbaali mam ke ni nan chuu mi, ke maah ye ufifiir le na aa? ");
INSERT INTO xon_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","M nan bi ni chee Uwumbɔr Aadichal ni iwiin mɔmɔk, le naa nan chuu mi. Tɔ, dandana wee le ye n‑yoonn mu Uwumbɔr siin ki tii nimi ni kinimbɔŋ ki tun mbɔmbɔɔn aatuln na.” ");
INSERT INTO xon_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Le bi chuu Yesu ki di u buen Uwumbɔr aatotoorninkpel aadichal ni. Le Piita paa u pu ki bi dandar. ");
INSERT INTO xon_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Le bi tuur mmii lichiln ngbaan ni, ki ka gob mu. Piita mu nan ti kal bi chee ki ka bikaasisik ni. ");
INSERT INTO xon_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mmii aah woln unimbil wɔb na, le usapɔɔn u ye ututunn na kan u, ki ka lik u sulm, le ki ti bui ke, “Uja umina mu nan bi Yesu chee.” ");
INSERT INTO xon_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Le u nee, ki bui u, “Upii, maa nyi u.” ");
INSERT INTO xon_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Le ni kpee siib, le unii uken mu kan u, ki mu bui u, “Aa mu ye bi ponn ni ubaa la.” Le Piita bui u, “Uja, maa ye.” ");
INSERT INTO xon_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Le ni ki kpee siib, le uja uken bui ke, “Ni ye mbamɔn, uja wee mu nan bi u chee. U mu ye Galilee aatiŋ aanii la.” ");
INSERT INTO xon_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Le Piita bui u, “Uja, maa nyi saah len pu na aatataa.” Waah laa bi len kina na, libuul ngbaan ni, le ukooja wii. ");
INSERT INTO xon_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tidindaan nan fenn ki lik Piita. Le Piita teer Tidindaan aah ba tuk u pu na ke, “Din, aa ga len nfum mutaa ke saa nyi mi le ukooja nin wii.” ");
INSERT INTO xon_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Le Piita nyan lipaal, ki ti wii pam. ");
INSERT INTO xon_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Le bijab bi joo Yesu na ŋa u mbɔnyun, le ki gbaa u, ");
INSERT INTO xon_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ki di likekeln poo unimbil, le ki baa u, “Uwumbɔr aabɔnabr, ulau faa si?” ");
INSERT INTO xon_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","le ki seei u ŋisiibil pam. ");
INSERT INTO xon_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ki woln kitaak kichakpiik ni, le Juu yaab aaninkpiib, ni Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb kuun ni tɔb chee, le ki di Yesu siin binimbiin ni, ");
INSERT INTO xon_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","le ki baa u, “Aa ye Kristo u ga gaa timi lii na aa? Tuk timi.” Le u bui bi, “M yaa tuk nimi kan, naan li pak maah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","M mu yaa baa nimi mbaan kan, naan giin tii mi, kaan di mi lii. ");
INSERT INTO xon_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dandana ki joo cha, min Unibɔn Aabo ga kal Uwumbɔr u yeh mpɔɔn mɔmɔk na aaŋangii wɔb.” ");
INSERT INTO xon_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Le bi mɔmɔk baa u, “Aa ye Uwumbɔr Aajapɔɔn la aa?” Le u bui bi, “Ni ye naah len pu na la.” ");
INSERT INTO xon_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Le bi bui ke, “Taa ki ban seeraadam. Timi tibaa ŋun waah len umɔb ni pu na.” ");
INSERT INTO xon_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bi mɔmɔk nan fii, le ki di Yesu buen kitiŋ ngbaan aaninkpel chee, bi nan yin u ke Pailat, ");
INSERT INTO xon_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","le ki piin ki bi galni u, ki bui ke, “Ti kan uja wee ŋmanni timi aanibol la. U tuk bi ke bi taa ki pa lampoo tii Ubɔrkpaan Siisa, ke uma ubaa le ye Kristo u ga gaa binib lii na, ki ye Ubɔr.” ");
INSERT INTO xon_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Le Pailat baa u, “Aa ye Juu yaab aabɔr la aa?” Le u bui u, “Saah len pu na, ni ye kina.” ");
INSERT INTO xon_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Le Pailat bui Uwumbɔr aatotoorninkpiib ni kinipaak ngbaan, “Maa kan uja wee aataani ubaa.” ");
INSERT INTO xon_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Le bi moo galni u, ki bui ke, “U tuk binib waaliin la, le bi ŋma tijar. U nan piin Galilee aatiŋ ni, le ki bɔ dii Judea aatim mɔmɔk ni, ki nan fuu ni kitiŋ kee ni.” ");
INSERT INTO xon_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat aah ŋun kina na, le u baa bi, “U ye Galilee aatiŋ aanii la aa?” ");
INSERT INTO xon_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tɔ, Ubɔr Herod le nan joo Galilee aatiŋ aanib. Pailat aah ŋun ke Yesu nyan nima na, le u di u tun Herod chee. U mu nan bi Jerusalem aatiŋ ni n‑yoonn ngbaan. ");
INSERT INTO xon_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ubɔr Herod aah kan Yesu na, le u kpa mpopiin sakpen. U nan ŋun waabɔr, ki ban u kan u ni yunn, ki mak ke u ga tun lijinjiir aatuln aan u kan. ");
INSERT INTO xon_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Le u baa Yesu mbaan pam. Yesu ma aa len tibaa. ");
INSERT INTO xon_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Le Uwumbɔr aatotoorninkpiib, ni Uwumbɔr aakaal aamɔmɔkb mu si nima ki galni u mpɔɔn pu. ");
INSERT INTO xon_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Le Ubɔr Herod ni waatɔb aajab lik u fam, ki ŋa u mbɔnyun, ki di kikpalk nyaan peen u, ki di u giin Pailat chee. ");
INSERT INTO xon_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Liyaadaal ngbaan le Herod ni Pailat ki ŋa kijɔtiik. Bi nan ye tɔb aadim la. ");
INSERT INTO xon_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat nan yin Uwumbɔr aatotoorninkpiib, ni Juu yaab aaninkpiib, ni kinipaak ngbaan, ");
INSERT INTO xon_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","le ki bui bi, “Ni joo ni uja wee m chee, ki bui ke u ŋmanni binib la. Le m jin u tibɔr ninimbil ni. Nimi aagalm ngbaan ponn ni, maa kan u ŋa tibaa. ");
INSERT INTO xon_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ubɔr Herod mu aa kan waataani, le u di u giin ni ti chee. Waa ŋa nibaa ni ŋeer u nkun. ");
INSERT INTO xon_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","M ga cha bi lue u ŋinaalab, le ki di u lii.”  ");
INSERT INTO xon_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Njim ngbaan mɔmɔk yoonn kan, see Pailat nyan unaagbiija ubaa lii. ");
INSERT INTO xon_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Le bi mɔmɔk kpaan ki teen ke, “Ku uja wee. Di Barabas di lii.” ");
INSERT INTO xon_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nan tukni kitiŋ ngbaan aaninkpiib, ki ku binib, le bi laŋ u kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat nan ban u di Yesu lii, nima pu le u ki len kinipaak ngbaan chee. ");
INSERT INTO xon_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Le bi ki teen ke, “Kpaa u ndɔpuinkoo pu. Kpaa u ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Le Pailat baa bi, “Ba ŋa? U tun bakaa bayoo? Maa kan u ŋa nibaa ni ŋeer u nkun. M ga cha bi lue u ŋinaalab, le ki di u lii.” ");
INSERT INTO xon_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Le bi beenin tar mpɔɔn pu, “Kpaa u ndɔpuinkoo pu.” Baah tar kina na, le bi nyaŋ Pailat. ");
INSERT INTO xon_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Le u kii ke u ga ŋa baah ban pu na, ");
INSERT INTO xon_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","le ki di Barabas u nan tukni kitiŋ ngbaan aaninkpiib ki ku binib, ki bi kiyondiik ni na lii, baah ban pu na, le ki di Yesu ŋa biŋaal ni, bi ti ŋa u baah ban pu na. ");
INSERT INTO xon_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Le butɔb aajab di Yesu buen. Baah cha na, le bi ton uja u nyan ni ntingbaan ni na nsan ni. Bi nan yin u ke Simonn, u ye Sairene aatiŋ aanii na. Le bi chuu u ke u tun Yesu aadɔpuinkoo ki li paan u pu. ");
INSERT INTO xon_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Le kinipaak sakpeŋ paa Yesu pu. Bi ponn ni bibaa ye bipiib bi wii ki kaani u pu na. ");
INSERT INTO xon_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Le Yesu fenn ki toŋ bi, le ki bui bi, “Jerusalem aatiŋ aapiib, ni taa wii m pu. Ni li wii nimi nibaa ni nimi aabim pu; ");
INSERT INTO xon_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ba pu? falaa aayoonn choo. N‑yoonn ngbaan le bi ga len ke, ‘Bipiiŋoob bi kaa ma mbim kaa tii bi libiil na, bima le kpa mpopiin.’ ");
INSERT INTO xon_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","N‑yoonn ngbaan le bi ga bui ŋijoo ni ŋigongon, ‘Lir ti pu, ki biin ti pu.’ ");
INSERT INTO xon_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bi yaa di ndɔsoon ŋa mmii ni aan mu gaa kan, ndɔkuun ga li bi kinye?” ");
INSERT INTO xon_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Le bi di bakadam bilee kpee Yesu pu, ki di buen ke bi ti ku bi mu. ");
INSERT INTO xon_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Le bi ti fuu nibaa chee, bi yin nima chee “Kiyikpaŋ.” Baah ti fuu nima na, le bi di u kpaa ndɔpuinkoo pu, le ki di bakadam bilee na mu kpaa idɔpuinkee pu. Bi kpaa ubaa uŋangii wɔb, ki kpaa uken uŋangan wɔb. ");
INSERT INTO xon_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Baah bi kpaa Yesu ndɔpuinkoo pu na, le u bui ke, “Nte Uwumbɔr, di cha pinn bi. Baa nyi baah ŋani pu na.” Le butɔb aajab ngbaan yoor waawanpeenkaan bi ti yakr tɔb, le ki too inaan ke bi lik bimɔk aah ga kan ni na. ");
INSERT INTO xon_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Le kinipaak ngbaan si ki lik u. Le Juu yaab aaninkpiib sii u, ki bui ke, “U gaal biken le bi ŋmar; u yaa ye Kristo u ga gaa timi lii, aan Uwumbɔr nyan u na kan, u gaa ubaa mu lii.” ");
INSERT INTO xon_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Butɔb aajab ngbaan mu nan ŋa u mbɔnyun, ki di ndaan mu mɔɔn na nyunn u, ");
INSERT INTO xon_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","le ki bui u, “Aa yaa ye Juu yaab aabɔr kan, gaa aabaa lii.” ");
INSERT INTO xon_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bi nan ŋmee kigbaŋ tam waadɔpuinkoo pu, uyil paab. Ni ŋmee ke, “Juu yaab Aabɔr le na.” ");
INSERT INTO xon_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Le baah nan kpaa bakadam bilee bi idɔpuinkee pu na ponn ni ubaa mu sii u, ki baa u, “Saa ye Kristo u ga gaa binib lii na aa? Gaa aabaa lii aan ki gaa ti mu lii.” ");
INSERT INTO xon_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Le bakadaan uken na kae u, le ki bui u, “Saa san Uwumbɔr aa? Aa ni u kpaan kan ntafadaan mubaa la. ");
INSERT INTO xon_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Timi le ŋeer ntafadaan ngbaan. Bi ŋa timi, timi aatuln aah ŋeer pu na la. Uma le aa ŋa bakaa ubaa,” ");
INSERT INTO xon_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","le ki bui Yesu, “Ndindaan, aa yaa jin saanaan kan, aa teer mbɔr.” ");
INSERT INTO xon_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Le Yesu bui u, “M tuk si mbamɔn la, din aa ga li bi m chee Paradais ni.” ");
INSERT INTO xon_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ni nan ye nwiin kaasisik ni. Le dulnyaa mɔk bɔln, ki ti saa nwiin aah kpar pu na. ");
INSERT INTO xon_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nwiin aa ki wiin. Le likekeln li yakr Uwumbɔr aadiik ni nfum mulee na chuu kar paacham, ki ti saa kitiŋ. ");
INSERT INTO xon_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Le Yesu teen mpɔɔn pu, le ki bui ke, “Nte Uwumbɔr, m di maawiin ŋa aaŋaal ni la.” Waah len kina na, le u kpo. ");
INSERT INTO xon_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tɔ, butɔb aajab aaninkpel aah kan naah ŋa pu na, le u nyuŋ Uwumbɔr, le ki bui ke, “Uja ngbaan sil ye uninyaan la.” ");
INSERT INTO xon_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Le kinipaak kimɔk kuun nima chee ke bi lik na aah kan tiwan ni mɔmɔk ŋa na, bi nan kpa mpombiin ki labr kun. ");
INSERT INTO xon_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Le ujɔtiib mɔmɔk, ni bipiib bi nyan ni Galilee aatiŋ ni ki dii u na si dandar, ki waa ni mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Uja ubaa nan bi, bi nan yin u ke Josef, u nyan ni Juu yaab aatiŋ ki bi yin ki ke Arimatea na ni. U nan ye uninyaan la, ki kii Uwumbɔr aanaan aah ga fuu ni buyoonn na. U nan ye bibɔjirb aaninkpiib ponn ni ubaa la. Le waa kii baah kpokl pu ki ku Yesu na. ");
INSERT INTO xon_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Le u buen Pailat chee, ki ti bui u, “Di Yesu aawon tii mi.” ");
INSERT INTO xon_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Le Pailat kii. Le u nyan waawon ndɔpuinkoo pu, le ki di u poo likekenyaan ni, ki di u ti sub kitakpaluŋ ni. Bi nan gbii kitakpaluŋ ngbaan litakpasakpeln aasikakl ni la. Baa nan kee sub unii ubaa ki ponn ni. ");
INSERT INTO xon_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ni nan ye kitaak ki ga woln Juu yaab aakpaakool daal na la. ");
INSERT INTO xon_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Le bipiib bi nan nyan Galilee aatiŋ ni ki dii Yesu na paan Josef pu, le ki ti kan kitakpaluŋ ngbaan, ki kan baah di Yesu aawon ki di ŋa ki ponn ni pu na. ");
INSERT INTO xon_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Le bipiib ngbaan gir kun, ki ti ban tulalee ni nkpan mu nun mɔ na. Juu yaab aakpaakool daal, le bi fuur, baakaal aah len pu na. ");
INSERT INTO xon_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Juu yaab aakpaakool aah jin ki woln kitaak na, le bipiib ngbaan yoor tulalee ni nkpan ngbaan bi ti toor Yesu aawon, ki di buen likaakul ngbaan chee kichakpinaanyeek ni. ");
INSERT INTO xon_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Baah ti fuu nima na, le bi kan ke litakpal li bi nan di leŋ kitakpaluŋ aamɔb na, aa ki bi. ");
INSERT INTO xon_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Le bi koo, le kaa kan Tidindaan Yesu aawon. ");
INSERT INTO xon_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baa nyi baah ga li dak pu na. Libuul ngbaan ni le bijab bilee bi aawanpeenkaan wiin chain na sil bi chee. ");
INSERT INTO xon_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Le ijawaan chuu bipiib ngbaan, le bi gbaan kitiŋ binimbiin ni. Le bijab ngbaan baa bi, “Ba pu ni ban unifuub bitekpiib ponn ni? ");
INSERT INTO xon_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Waa bi do. U fikr nkun ni a. Teer man waah nan tuk nimi pu buyoonn u nan laa bi Galilee ni na, ");
INSERT INTO xon_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ke Uwumbɔr siin ke bi ga di uma Unibɔn Aabo, ki di ŋa titunwanbirdam aaŋaal ni, bi ti kpaa u ndɔpuinkoo pu, ke iwiin itaa daal u ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Le bipiib ngbaan teer waabɔr timina. ");
INSERT INTO xon_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Le bi nyan kitakpaluŋ ngbaan chee, ki gir kun, le ki di tibɔr timina tuk waakpambalb kipiik ni ubaa na, ni waadidiliib bi gur na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bipiib ngbaan aayimbil le nan ye Mari Magdalene, ni Joana, ni Mari u ye Jems aana na. Bi ni bipiib bi nan dii bi na nan di tibɔr timina tuk waakpambalb. ");
INSERT INTO xon_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Le waakpambalb aa pak baah len pu na. Bi dak ke ni ye kijɔrk aaliin la. ");
INSERT INTO xon_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Le Piita fii ki san buen kitakpaluŋ ngbaan chee, ki ti boon ki gbuun lik, le ki muin ŋikeken ngbaan baanja le dɔ. Ni nan gar u pam. Le u gir kun. ");
INSERT INTO xon_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Liyaadaal ngbaan le bi ponn ni bilee cha kitiŋ ki bi yin ki ke Emaus na ni. Kitiŋ ngbaan ni Jerusalem aah daa tɔb chee pu na ye mal bilole la. ");
INSERT INTO xon_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baah cha na, le bi gbaa tɔb chee tibɔr, le ki len tiwan nimɔk ŋa na. ");
INSERT INTO xon_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Baah gbaa tɔb chee tibɔr kina na, le Yesu ubaa pii bi nsan ni, ki dii bi. ");
INSERT INTO xon_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Le Uwumbɔr doŋ binimbil ke bi taa bee u. ");
INSERT INTO xon_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Le u baa bi, “Naah chuun gbaa tɔb chee tibɔr ti na, ti ye bɔr bayaar, aan ninimbil wɔb bi gbilngbiln kina?” ");
INSERT INTO xon_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Le bi ponn ni ubaa, bi nan yin u ke Kleopas, baa u, “Bicham bi bi Jerusalem ponn ni na, si baanja le aa nyi tibɔr ti ŋa nima chee dandana na aa?” ");
INSERT INTO xon_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Le u baa bi, “Tilabɔr?” Le bi bui u, “Yesu u nan ye Nasaref aatiŋ aanii na aabɔr. U nan ye Uwumbɔr aabɔnabr la. U nan kpa mpɔɔn ki tun lijinjiir aatun; waaliin mu nan kpa mpɔɔn. U piir Uwumbɔr ni binib mɔmɔk aasui. ");
INSERT INTO xon_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Le Uwumbɔr aatotoorninkpiib ni timi Israel yaab aaninkpiib di u ŋa binib aaŋaal ni, ke u ŋeer nkun. Le bi kpaa u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti nan kpa limakl ke uma le ga gaa timi Israel yaab lii. Baah nan ŋa u kina na, din le ye iwiin itaa. ");
INSERT INTO xon_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ti ponn ni bipiib bibaa mu tuk timi tibɔr ti gar timi sakpen na. Bi buen kitakpaluŋ ngbaan chee kichakpinaanyeek ni, ");
INSERT INTO xon_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kaa ti kan waawon, le ki gir ni ki nan tuk timi ke bi kan Uwumbɔr aatuuntiib bi tuk bi ke u fikr na. ");
INSERT INTO xon_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Le ti ponn ni bibaa buen kitakpaluŋ ngbaan chee, ki ti kan ni bi ke bipiib ngbaan aah len pu na. Uma le baa kan.” ");
INSERT INTO xon_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Le Yesu bui bi, “Nimi aalan par la. Naa gaa Uwumbɔr aabɔnabtiib aah nan len pu na mɔmɔk mala. ");
INSERT INTO xon_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Uwumbɔr le nan siin ke Kristo u ga gaa binib lii na ga ji falaa kina, le ki nin kan mpɔɔn.” ");
INSERT INTO xon_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Le Yesu ŋeer waabɔr ti ŋmee Uwumbɔr Aagbaŋ ni na mɔmɔk tuk bi. Njan u tuk bi Moses aah nan ŋmee ti pu na, le ki nin tuk bi Uwumbɔr aabɔnabtiib mɔmɔk aah nan ŋmee ti pu na. ");
INSERT INTO xon_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Le bi duun baah cha kitiŋ ki na ni. Le Yesu ŋa ke waah ga piln jer le na. ");
INSERT INTO xon_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Le bi gaŋ u, “Doon ti chee. Kijook joor a. Naan yunn le ni ga mue.” Le u koo ni bi chee. ");
INSERT INTO xon_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Le bi ti kal ke bi ji tijikaar. Waah kal bi chee ke u ji tijikaar na, le u yoor boroboro, ki doon Uwumbɔr, ki gii, ki di tii bi. ");
INSERT INTO xon_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Le Uwumbɔr likr binimbil ke bi bee u. Libuul ngbaan ni le baa ki kan u. ");
INSERT INTO xon_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Le bi bui tɔb, “Waah dii timi nsan ni ki len ti chee ki ŋeer Uwumbɔr Aagbaŋ aaliin aatataa tuk timi na, tisui aa ba piin u pu sakpen aa?” ");
INSERT INTO xon_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Libuul ngbaan ni, le bi fii, ki gir buen Jerusalem, ki ti kan Yesu aakpambalb kipiik ni ubaa na, ni waadidiliib biken kuun tɔb chee, ");
INSERT INTO xon_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ki bi len ke, “Tidindaan sil fikr nkun ni. Simonn le kan u.” ");
INSERT INTO xon_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Le waadidiliib bilee ngbaan mu tuk bi Yesu aah pii bi nsan ni pu na, ni baah bee u buyoonn u gii boroboro na. ");
INSERT INTO xon_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Baah len tɔb chee tibɔr kina na, libuul ngbaan ni le Yesu ubaa sil bikaasisik ni, le ki bui bi, “Ni li kpa nsuudoon man.” ");
INSERT INTO xon_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Le bipobil yuk; ijawaan chuu bi sakpen a. Bi nan dak ke bi kan utekpiir aawiin la. ");
INSERT INTO xon_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Le u baa bi, “Ba ŋa ni san ijawaan? Ba ŋa ni beeni nisui ni? ");
INSERT INTO xon_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lik ŋŋaal ni ntaa, ki bee ke m sil ye. Taln niŋaal ki di meeh mi ki lik man. Utekpiir aawiin aa kpa tinann ni ŋikpab ke naah kan m kpa pu na.” ");
INSERT INTO xon_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Waah len kina na, le u mɔk bi baah nan kpaa uŋaal ni utaa ponn ni ipiin pu na. ");
INSERT INTO xon_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bi nan kpa mpopiin sakpen, ki mu aa kee gaa kii mbamɔm. Ni nan gar bi pam. Le u baa bi, “Tijikaar tibaa bi do oo?” ");
INSERT INTO xon_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Le bi tii u lijangeln li bi pul li mmii ni na. ");
INSERT INTO xon_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Le u gaa, ki ŋman li binimbil ni. ");
INSERT INTO xon_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","U nan bui bi, “Maabɔr timɔk ŋmee Moses aakaal ponn ni, ni Uwumbɔr aabɔnabtiib aagbann ni, ni Uwumbɔr aalahn aagbaŋ ni na, Uwumbɔr le siin ke ni mɔmɔk ga gbiin. Maah nan laa bi ni chee na, m nan tuk nimi kina la.” ");
INSERT INTO xon_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Le u woln binimbil ke bi bee Uwumbɔr Aagbaŋ aaliin aatataa, ");
INSERT INTO xon_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","le ki bui bi, “Ni ŋmee ke Kristo u ga gaa binib lii na ga ji falaa, ki fikr nkun ni, iwiin itaa daal. ");
INSERT INTO xon_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ni li mooni binib maayimbil pu, ke bi yaa kpeln baabimbin kan, Uwumbɔr ga di cha baatunwanbir pinn bi. Ni piin ki li mooni Jerusalem aatiŋ aanib ni, aan ki nin moon ŋinibol mɔmɔk mu ni. ");
INSERT INTO xon_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nimi le ye maabɔr mɔmɔk aaseeraadam. ");
INSERT INTO xon_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nte Uwumbɔr aah puu tipuur ti ke u ga tii nimi Waafuur Nyaan na, m ga tun ni Nfuur Nyaan ngbaan ni chee. Ni li bi Jerusalem ni ki ti saa bundaln ni ga kan mpɔɔn mu ga nyan ni paacham na.” ");
INSERT INTO xon_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Le Yesu di bi buen Betani aatiŋ chee. Baah ti fuu nima na, le u yoor uŋaal paacham, ki ŋa Uwumbɔr aanyoor ŋa bi pu. ");
INSERT INTO xon_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Waah laa bi ŋani kina na, le u nyan bi chee, Uwumbɔr di u buen paacham. ");
INSERT INTO xon_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Le bi gbaan kitiŋ ki doon u, ki nin gir buen Jerusalem ni, ki kpa mpopiin sakpen, ");
INSERT INTO xon_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ki pak Uwumbɔr, waadichal ponn ni, n‑yoonn mɔmɔk.");
INSERT INTO xon_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uwumbɔr aah kaa nan kee naan dulnyaa na, ubaa nan bi, bi yin u ke Limɔboln. U nan bi Uwumbɔr chee, ki bi ke Uwumbɔr aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","U nan bi Uwumbɔr chee ki nyan ni mpiin la. ");
INSERT INTO xon_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Uwumbɔr nan cha u naan tiwan mɔmɔk. Tiwan nibaa aa gur waa naan ni. ");
INSERT INTO xon_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uma le ye umɔfadaan. Limɔfal ngbaan tii binib nwiihn mu woln binimbil na. ");
INSERT INTO xon_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nwiihn ngbaan wolni mbɔmbɔɔn ni. Mbɔmbɔɔn aa junn nwiihn ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uwumbɔr nan tun ni uja ubaa, bi nan yin u ke Jɔnn. ");
INSERT INTO xon_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U dan ke u nan tuk binib nwiihn ngbaan aabɔr, aan binib mɔmɔk ŋun waah len pu na, aan ki gaa nwiihn ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jɔnn aa nan ye nwiihn ngbaan. U dan ke u nan tuk binib nwiihn ngbaan aabɔr la. ");
INSERT INTO xon_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nwiihn ngbaan le ye nwiihn bamɔnn, le ki dan dulnyaa wee ni ki nan woln binib mɔmɔk aanimbil. ");
INSERT INTO xon_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Baah yin u ke Limɔboln na nan naan dulnyaa, ki dan nan bi dulnyaa ni, le dulnyaa aanib aa bee u. ");
INSERT INTO xon_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","U dan udo aatiŋ ni, le udo aatiŋ ni yaab yii u. ");
INSERT INTO xon_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Binib bimɔk gaa u na, u tii bi nsan ke bi kpaln Uwumbɔr aabim. Bima le ye binib bi gaa u ki kii na. ");
INSERT INTO xon_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Baah kpaln Uwumbɔr aabim na, naa ye ke binibɔm le ma bi Uwumbɔr aamaal ni, kaa ye binibɔm aageehn pu. Uwumbɔr le ma bi waamaal ponn ni. ");
INSERT INTO xon_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Baah yin u ke Limɔboln na nan kpaln unibɔn, ki nan bi tikaasisik ni. U gee binib chob, ki len ibamɔn baanja la. Le ti kan waah kpa mpɔɔn pu na. Waah ye Uwumbɔr Aajapɔnbaal na, u kpa mpɔɔn ke Ute Uwumbɔr aah kpa pu na. ");
INSERT INTO xon_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔnn nan tuk binib waabɔr, ki len ke, “M nan tuk nimi ke unii u ga paan ni mpuwɔb na jer mi; baah kaa nan kee ma mi na, u nan bi. Uma le na.” ");
INSERT INTO xon_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Uwumbɔr aah bi pu na, u mu bi kina le chob. Le ti mɔmɔk gaa waabimbin. U ŋa Uwumbɔr aanyoor ŋa ti pu, ki beenin ŋani timi tinyoor n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Uwumbɔr nan tuk Moses waakaal ke u di tuk timi. Yesu Kristo dan nan tuk timi Uwumbɔr aah gee timi pu na, ki tuk timi tibɔr ti ye mbamɔn na. ");
INSERT INTO xon_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ubaa aa kee kan Uwumbɔr. Ujapɔnbaal Yesu Kristo, u bi ke Ute Uwumbɔr aah bi pu na, ki bi u chee na, uma le tuk timi Uwumbɔr aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juu yaab bi nan bi Jerusalem aatiŋ ni na nan tun ni Uwumbɔr aatotoorb ni Liifai yaab Jɔnn chee ke bi ti baa u, “Aa ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Le Jɔnn tuk bi mbamɔn, kaa gur tibaa. U nan tuk bi mbamɔn, ki len ke, “Maa ye Kristo u ga gaa binib lii na.” ");
INSERT INTO xon_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Le bi ki baa u ke, “Aa ye ŋma? Aa ye Elaija aa?” Le u bui bi, “Maa ye.” Bi nan ki baa u ke, “Aa ye Uwumbɔr aabɔnabr u bi bui ke u ga dan aa?” Le u bui bi, “Aayii.” ");
INSERT INTO xon_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nima pu na, bi nan ki baa u ke, “Aa ye ŋma? Tuk timi, aan ti ti tuk binib bi tun ni timi na. Aa ga len saabɔr ngbaan kinye?” ");
INSERT INTO xon_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","U nan bui ke, “M ye nneel mu tar nteersakpiin ni na ke: ‘Toor Uwumbɔr aasan man.’” Uwumbɔr aabɔnabr Aisaya nan len kina la. ");
INSERT INTO xon_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Binib bi nan baa Jɔnn mbaan ngbaan na nyan ni Farisii yaab chee la. ");
INSERT INTO xon_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Le bi ki baa u ke, “Saah kaa ye Kristo u ga gaa timi lii na, kaa ye Elaija, kaa ye Uwumbɔr aabɔnabr ngbaan mu na, ba pu aa muini binib nnyun ni?” ");
INSERT INTO xon_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Le u bui bi, “Mma muini binib nnyun ni la. Ubaa mu bi nikaasisik ni. Nimi le aa nyi u. ");
INSERT INTO xon_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","U ye unii u paan ni mpuwɔb na. Maa ŋeer ke m chuu gbiln waanaatak aaŋmin tii u.” ");
INSERT INTO xon_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Bi nan len tɔb chee tibɔr ngbaan Betani aatiŋ, ki bi Jɔɔdann aamɔɔdapuul, Jɔnn aah muini binib nnyun ni nin chee na ni. ");
INSERT INTO xon_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ki woln kitaak le Jɔnn kan Yesu choo u chee, le u bui ke, “Lik, Uwumbɔr Aapihbo u nyani dulnyaa ni aanib aatunwanbir na. ");
INSERT INTO xon_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","M nan len ke uja ubaa paan ni mpuwɔb ki mu tee jer mi; baah kaa nan kee ma mi na, u nan bi. Uma le na. ");
INSERT INTO xon_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Min mbaa aa nan nyi u; m muini binib nnyun ni ke nimi Israel yaab bee u la.” ");
INSERT INTO xon_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Le Jɔnn jin seeraa ki tuk binib, “M kan Uwumbɔr Aafuur Nyaan nyan ni paacham ki naahn linanjel, ki nan tɔŋ u pu. ");
INSERT INTO xon_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Min mbaa aa nan nyi u; Uwumbɔr u tun ni mi ke m nan muin binib nnyun ni na, uma le bui mi ke m ga kan Waafuur Nyaan sunn ni ki nan tɔŋ uja ubaa pu, ke uma le ye unii u ga gbiin binib Uwumbɔr Aafuur Nyaan na. ");
INSERT INTO xon_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Le m kan kina, ki ji seeraa ki tuk binib ke uma le ye Uwumbɔr Aajapɔɔn.” ");
INSERT INTO xon_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ki woln kitaak le Jɔnn ni waadidiliib bilee nan ki bi nima, ");
INSERT INTO xon_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ki kan Yesu bi chuun nima. Jɔnn nan lik u, le ki len ke, “Lik, Uwumbɔr Aapihbo.” ");
INSERT INTO xon_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jɔnn aadidiliib bilee ngbaan ŋun waah len pu na, le ki di paan Yesu pu. ");
INSERT INTO xon_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Le Yesu fenn, ki kan bi paan ni u pu. Le u baa bi, “Ni ban ba?” Le bi baa u, “Umɔmɔkr, aa koo la chee?” ");
INSERT INTO xon_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Le u bui bi, “Dan ki nan ti lik man.” Le bi dii u ki ti kan waah koo nin chee na. Ni nan ye tikur tinaa aayoonn la, le bi nan doon udo liyaadaal ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bijab bilee bi nan ŋun Jɔnn aah len pu aan ki dii Yesu na, bi yin bi ponn ni ubaa ke Andru, u nan ye Simonn Piita aanaal na. ");
INSERT INTO xon_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Libuul ngbaan ni le u buen ti kan ukpel Simonn, ki tuk u, “Ti kan Masiya u ga gaa timi lii na.” Masiya ni Kristo ye liyimbibaan la. ");
INSERT INTO xon_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Le u di u dan Yesu chee. Le Yesu lik Piita, ki bui u, “Bi yin si le ke Simonn, Jɔnn aajapɔɔn. Bi ga li gur yin si ke Siifas la.” Siifas aatataa le ye ke “litakpal.” Siifas ni Piita ye liyimbibaan la. ");
INSERT INTO xon_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ki woln kitaak le Yesu ban u buen Galilee aatiŋ ni, ki kan Filip, le ki bui u, “Li dii mi.” ");
INSERT INTO xon_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip do le ye Betseda aatiŋ ni. U ni Andru ni Piita nyan ni kitinbaan ni la. ");
INSERT INTO xon_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip mu nan ti kan Natanael le ki tuk u, “Ti kan unii u Moses ni Uwumbɔr aabɔnabtiib mu nan ŋmee waabɔr Uwumbɔr aakaal aagbaŋ ni na. Uma le ye Josef aajapɔɔn Yesu, u ye Nasaref aatiŋ aanii na.” ");
INSERT INTO xon_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Le Natanael baa u, “Tiwanyaan nibaa ga ŋmaa nyan ni Nasaref aatiŋ ni ii?” Le Filip bui u, “Dan nan lik.” ");
INSERT INTO xon_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu nan waa Natanael choo u chee, le ki bui ke, “Lik, Israel aabobamɔnn. Nnyamɔn aa bi u ni.” ");
INSERT INTO xon_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Le Natanael baa u, “Aa ŋa kinye ki ti nyi mi?” Le Yesu bui u, “Saah ba bi likakaln taab na, m puen kan si, Filip aa kee yin si.” ");
INSERT INTO xon_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Le Natanael bui u, “Umɔmɔkr, aa sil ye Uwumbɔr Aajapɔɔn. Aa ye Israel yaab Aabɔrkpaan la.” ");
INSERT INTO xon_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Le Yesu baa u, “Maah bui ke m kan si likakaln taab na, nima le cha aa gaa mi ki kii ii? Aa ga kan lijinjiir aawan ki jer nimina. ");
INSERT INTO xon_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","M tuk nimi mbamɔn la, ni ga kan kitaapaak chuu piir, ki ga kan Uwumbɔr aatuuntiib cha paacham ki ki sunni, min Unibɔn Aabo pu.” ");
INSERT INTO xon_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Iwiin itaa daal le bi nan ji ubɔndinn aajim Kana aatiŋ ki bi Galilee ni na. Yesu aana mu nan bi nima. ");
INSERT INTO xon_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bi nan yin Yesu ni waadidiliib ke bi mu dan nan ji. ");
INSERT INTO xon_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ni nan bi cha, le ŋisubil aadaan na ti doo. Le Yesu aana bui u, “Baa ki kpa ndaan.” ");
INSERT INTO xon_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Le Yesu bui u, “Nna, ni ye maabɔr aa? Maayoonn aa kee fuu.” ");
INSERT INTO xon_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Le una bui bitutum na, “U yaa tuk nimi pu na kan, ni ŋa kina.” ");
INSERT INTO xon_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ikin sakpiin iloob nan si nima. Galoŋ piitaa, bee moninko ga ŋmaa koo mubaa ponn ni. Juu yaab joo ikin ngbaan aanyun le finni bibaa, baakaal aah dii pu na. ");
INSERT INTO xon_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Le Yesu tuk bitutum ngbaan, “Ban nnyun gbiin ikin ngbaan man.” Le bi ban nnyun gbiin i mɔmɔk paapaa. ");
INSERT INTO xon_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Le u tuk bi ke bi kab ti tii njim aaninkpel. Le bi kab ti tii u. ");
INSERT INTO xon_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Baah kab nnyun ngbaan ti tii u na, le mu kpaln ndaan. Le u wub lik, kaa nyi mu aah nyan nin chee na. Bitutum bi kab tii u na le nyi. Le u yin uja u din upii na, ");
INSERT INTO xon_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ki nan bui u, “Binib mɔmɔk yaa ban bi tii ndaan kan, bi puen tii mu mɔ na la. Binib yaa nyun ti bab kan, le bi nin tii bi ndaan mu kaa mɔ na. Si ma kan, saah tii bi mu puwɔb na le mɔ ki jer saah puen tii bi mu na.” ");
INSERT INTO xon_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nima le ye njan aajinjiir aatuln li Yesu tun na. U nan tun lituln ngbaan Kana aatiŋ ki bi Galilee ni na ni la. Le binib kan waah kpa Uwumbɔr aapɔɔn pu na. Le waadidiliib gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ubɔndinn aajim ngbaan aah doo na, le u ni una ni unaatiib ni waadidiliib buen Kapenaum aatiŋ ni, ki ti ŋa iwiin ilee nima. ");
INSERT INTO xon_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ni nan gur siib ke Juu yaab ji Lakr‑jer aajim. Le Yesu buen Jerusalem aatiŋ ni ");
INSERT INTO xon_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ki ti koo Uwumbɔr Aadichal ni, le ki kan binib ka nima ki kooh inaaja, ni ipiih, ni ŋinanjel. Binib bi kpelni ŋimombil na mu ka nima. ");
INSERT INTO xon_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Le u di iŋmin ŋa linaalab, ki di jenn nyan inaaja, ni ipiih ngbaan mɔmɔk lipaal, le ki labr binib bi kpelni ŋimombil na aateebul tiib chiŋ, le ŋimombil yaa tɔb chee. ");
INSERT INTO xon_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","U nan tuk binib bi kooh ŋinanjel na, “Di ŋinanjel ngbaan nyan lipaal man. Ni taa ki di Nte Uwumbɔr Aadichal ŋa kinyaŋ.” ");
INSERT INTO xon_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Le waadidiliib teer ke ni ŋmee Uwumbɔr Aagbaŋ ni ke, “Uwumbɔr, maah neen saadichal pu na bi ke mmii le aah wu mponn ni na.” Le bi bee ke ni ye Yesu aabɔr la. ");
INSERT INTO xon_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Le Juu yaab baa u, “Aa ga ŋa ba aajinjiir aawan ki mɔk timi ke aa kpa nsan ke aa ŋa saah ŋani pu na?” ");
INSERT INTO xon_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Le u bui bi, “Gbaa wii Uwumbɔr Aadichal limina, aan m di iwiin itaa ki fiin li.” ");
INSERT INTO xon_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Le bi bui ke, “Ŋibin imonko ilee ni ŋiloob le bi nan di maa Uwumbɔr Aadichal ngbaan. Le aa bui ke aa ga di iwiin itaa fiin li ii?” ");
INSERT INTO xon_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tɔ, u mu aa nan len Uwumbɔr Aadichal aabɔr la. Uma ubaa aawon le u nan len. ");
INSERT INTO xon_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","N‑yoonn mu u fikr nkun ni na, le waadidiliib teer ke u nan len kina. Le bi pak waah len pu na, ni Uwumbɔr Aagbaŋ aah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu aah bi Jerusalem aatiŋ ni, njim ngbaan aayoonn na, le kinipaak kan waah tun lijinjiir aatun pu na, le ki gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Uma aa tee gaa bi ki kii; ");
INSERT INTO xon_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ba pu? u nyi binib mɔmɔk aabimbin. Waa ban ke ubaa nyaa u binib aabɔr. Uma ubaa nyi binib aasui ni aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Uja ubaa mu nan bi nima, bi nan yin u ke Nikodemus, u nan ye Farisii aanii la, ki ye Juu yaab aaninkpel ubaa. ");
INSERT INTO xon_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Le u buen Yesu chee kinyeek ki nan bui u ke, “Umɔmɔkr, ti nyi ke aa ye Umɔmɔkr u nyan ni Uwumbɔr chee na la; ba pu? ubaa aan ŋmaa tun lijinjiir aatun ke saah tun pu na, see Uwumbɔr bi u chee.” ");
INSERT INTO xon_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Le Yesu bui u, “M tuk si mbamɔn la, bi yaa kaa ma unii lelee kan, waan ŋmaa koo Uwumbɔr aanaan ni.” ");
INSERT INTO xon_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus nan baa u, “Unii yaa por kan, bi ga ŋa kinye ki ki ma u lelee? U ga ŋmaa gir koo una aaponn ni aan bi ki ma u uu?” ");
INSERT INTO xon_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Le Yesu bui u, “M tuk si mbamɔn la, Uwumbɔr Aafuur Nyaan yaa kaa ma unii lelee aan bi muin u nnyun ni kan, waan ŋmaa koo Uwumbɔr aanaan ni. ");
INSERT INTO xon_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Unibɔn aah ma u na ye unibɔn la. Uwumbɔr Aafuur Nyaan aah ma u na ye Uwumbɔr Aafuur Nyaan yoo la. ");
INSERT INTO xon_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","M tuk si la, see bi ki ma nimi lelee. Maah tuk si pu na, taa cha ni gar nimi. ");
INSERT INTO xon_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Libuln daar cha laah ban nin chee na, le aa ŋun laah kpa kifuuk pu na, kaa nyi laah nyan ni nin chee na, ki mu aa nyi laah cha nin chee na. Ni bi kina le ki tii unii umɔk Uwumbɔr Aafuur Nyaan ma u na.” ");
INSERT INTO xon_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Le Nikodemus baa u, “Ni ga ŋa kinye aan ki ŋa kina?” ");
INSERT INTO xon_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Le Yesu baa u, “Aa ye unii u mɔk Israel yaab Uwumbɔr aakaal na, le kaa bee maah len pu na aatataa aa? ");
INSERT INTO xon_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","M tuk si mbamɔn la, ti len taah nyi pu na la, ki tuk binib tinimbil aah kan pu na, le naa gaa taah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","M tuk nimi dulnyaa wee ni aabɔr, le naa pak ti, ka m yaa tuk nimi paacham aabɔr kan, ni ga ŋa kinye ki pak ti? ");
INSERT INTO xon_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ubaa aa kee buen paacham see min Unibɔn Aabo u bi paacham ki nyan ni paacham na. ");
INSERT INTO xon_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Moses aah nan di uwaa fin ndɔ pu ki di chɔɔn paacham nteersakpiin ni pu na, see bi di min Unibɔn Aabo mu chɔɔn paacham kina, ");
INSERT INTO xon_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","aan unii umɔk gaa mi ki kii na li kpa limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Uwumbɔr aah gee dulnyaa aanib sakpen pu na, nima le u di Ujapɔnbaal tii ni ke unii umɔk gaa u ki kii na taa kpo, u li kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uwumbɔr tun ni Ujapɔɔn dulnyaa ni. Waa tun ni u ke u nan ji dulnyaa wee ni aanib tibɔr, u tun ni u ke u gaa bi lii la. ");
INSERT INTO xon_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Unii umɔk gaa u ki kii na, Uwumbɔr aa len ke waabɔr bii. Unii umɔk kaa gaa u ki kii na, Uwumbɔr len ke waabɔr bii a. Waah kaa gaa Uwumbɔr Aajapɔnbaal ki kii na, nima le cha Uwumbɔr len ke waabɔr bii. ");
INSERT INTO xon_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uwumbɔr aah ga ji bi tibɔr pu na le ye ke nwiihn dan dulnyaa ni, le binib yii mu, le ki gee mbɔmbɔɔn ni; ba pu? baatuln aa ŋan. ");
INSERT INTO xon_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Unii umɔk tun lituln li kaa ŋan na, u nan nwiihn la, kaan dan nwiihn ponn ni, binib taa kan waah tun pu na. ");
INSERT INTO xon_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Unii umɔk tun lituln li ŋan na kan, u choo nwiihn ponn ni ke unii mɔmɔk nan kan waah tun pu na, ke u tun Uwumbɔr aah gee pu na la. ");
INSERT INTO xon_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yesu aah len tibɔr timina ki ti doo na, le u ni waadidiliib buen Judea aatiŋ ni, ki ti bi nima ki muini binib nnyun ni. ");
INSERT INTO xon_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔnn mu nan bi muini binib nnyun ni. U nan bi Enonn aatiŋ ni, Salim aatiŋ chee, nnyun aah wiir nima chee pu na. Le binib choo u chee, le u muini bi nnyun ni. ");
INSERT INTO xon_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Baa nan kee chuu u ŋa kiyondiik ni n‑yoonn ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Le Jɔnn aadidiliib ni Juu aanii ubaa nan kpak tɔb kinikpakpak, baah muini binib nnyun ni pu na pu. ");
INSERT INTO xon_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Le bi dan Jɔnn chee ki nan tuk u, “Umɔmɔkr, lik, unii u nan bi aa chee Jɔɔdann aamɔɔdapuul na, aan aa nan tuk binib waabɔr na, u mu gur bi muini binib nnyun ni, le binib mɔmɔk gur chaa u chee.” ");
INSERT INTO xon_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Le Jɔnn bui bi, “Ubaa aan ŋmaa ŋa nibaa see Uwumbɔr le tii u. ");
INSERT INTO xon_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nimi nibaa ŋun m len ke maa ye Kristo u ga gaa binib lii na; Uwumbɔr tun ni mi ke m li ye Kristo aasaloln ki toor nsan tii u. ");
INSERT INTO xon_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Usapɔɔn yaa kun uchal do kan, uchal le yeh u. Le uchal aajɔ u si u chee ki ŋun waaneel na kpa mpopiin pam. Nima le cha m mu kpa mpopiin mbamɔm. ");
INSERT INTO xon_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni ŋan ke uma Kristo li moo kani mpɔɔn, le m ma gur.” ");
INSERT INTO xon_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Uma u nyan ni paacham na le jer binib mɔmɔk. Unii u nyan ni dulnyaa ni na ye dulnyaa ni aanii la, ki len dulnyaa ni aabɔr la. Yesu u nyan ni paacham na le jer binib mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","U tuk binib waah kan pu na, ni waah ŋun pu na. Ubaa mu aa gaa waah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Unii umɔk gaa waah len pu na, u kii ke Uwumbɔr ye mbamɔndaan la. ");
INSERT INTO xon_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yesu u Uwumbɔr tun ni u na le len uma Uwumbɔr aabɔr; ba pu? Uwumbɔr di Waafuur Nyaan mu kaa kpa ŋŋaŋ na gbiin u. ");
INSERT INTO xon_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Uwumbɔr gee Ujapɔɔn Yesu ki di mpɔɔn mɔmɔk ŋa uŋaal ni. ");
INSERT INTO xon_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Unii umɔk gaa Uwumbɔr Aajapɔɔn ki kii na le kpa limɔfal li kaa kpa ndoon na. Unii umɔk kaa kii Uwumbɔr Aajapɔɔn aamɔb na, waan kan limɔfal li kaa kpa ndoon na. Uwumbɔr gee liŋuul u pu n‑yoonn mu kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Le Farisii yaab ŋun ke Yesu ŋa binib waadidiliib ki muin bi nnyun ni ki jer Jɔnn aah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Yesu ubaa mu aa muin binib nnyun ni. Waadidiliib na le muini bi. ");
INSERT INTO xon_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tɔ, waah bee ke Farisii yaab ŋun kina na, le u nyan Judea aatiŋ ni, ki ki gir buen Galilee aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Waah cha na, le u neen ke u dii Samaria aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Le u ti fuu Samaria aatiŋ kibaa ni, bi yin ki ke Saika. Bukpaab bu Jakob nan di tii ujapɔɔn Josef na aa daa nima chee. ");
INSERT INTO xon_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jakob aanyunbun mu bi nima chee. Le Yesu aah chuun na, u bak a. Nima le u kal nnyunbun ngbaan aamɔgbeln pu. Nwiin nan bi kaasisik ni. ");
INSERT INTO xon_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Le Samaria aapii ubaa dan u nan lu nnyun. Le Yesu bui u, “Pu mi nnyun m nyu.” ");
INSERT INTO xon_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Waadidiliib na puun buen kitiŋ ponn ni bi ti daa tijikaar. ");
INSERT INTO xon_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Le upii ngbaan bui u, “Aa ye Juu aanii la, m mu ye Samaria aapii la. Ba pu aa bui mi ke m tii si nnyun?” Juu yaab ni Samaria yaab aa kpaani tɔb chee, nima le cha u len kina. ");
INSERT INTO xon_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Le Yesu bui u, “Aa yaa ba nyi Uwumbɔr aah tii binib pu na, ki yaa ba nyi unii u mee si nnyun na kan, aa ba ga bui u ke u tii si nnyun mu ye limɔfal aanyun na, le u ba ga tii si.” ");
INSERT INTO xon_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Le upii ngbaan bui u, “Maaninkpel, saa kpa goomaa, nnyunbun ngbaan nyoo, aa ga kan limɔfal aanyun ngbaan la chee? ");
INSERT INTO xon_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tiyaaja Jakob, ni ujapɔtiib, ni waawakor nan nyu nnyunbun ngbaan ni la. Uma le nan tii timi nnyunbun ngbaan. Aa jer uma la aa?” ");
INSERT INTO xon_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Le Yesu bui u, “Unii umɔk nyu nnyun mue na, nnyunyuu ga ki chuu u. ");
INSERT INTO xon_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Unii umɔk nyun maah ga tii u nnyun mu na, nnyunyuu aan ki chuu u. Maah ga tii u nnyun mu na, mu ga li ye nnyunbun mu bu u ponn ni kaan foor na, mu ga tii u limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Le upii ngbaan bui u, “Maaninkpel, tii mi nnyun ngbaan aan nnyunyuu taa ki chuu mi, aan m taa ki dan do nan lu nnyun.” ");
INSERT INTO xon_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Le Yesu bui u, “Li cha ki ti yin ni aachal, aan ki gir ni.” ");
INSERT INTO xon_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Le u bui u, “Maa kpa chal.” Le Yesu bui u, “Saah len ke saa kpa chal na, ni ye mbamɔn la. ");
INSERT INTO xon_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aa nan kpa chatiib biŋmu la. Saah bi uja u chee dandana na aachal aa ye u. Saah len pu na, aa len mbamɔn la.” ");
INSERT INTO xon_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Le upii ngbaan bui u, “Maaninkpel, m bee ke aa ye Uwumbɔr aabɔnabr la. ");
INSERT INTO xon_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Timi Samaria yaab aayaajatiib nan dooni Uwumbɔr lijool limina paab la, le nimi Juu yaab ma bui ke ni ŋan ke binib li dooni Uwumbɔr Jerusalem aatiŋ ni.” ");
INSERT INTO xon_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Le Yesu bui u, “Upii, pakn maah ga len pu na, n‑yoonn choo, binib aan nan ki doon Tite Uwumbɔr lijool limina paab, ki mu aan ki doon u Jerusalem aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nimi Samaria yaab dooni Uwumbɔr u naa nyi u na. Timi Juu yaab ma dooni Uwumbɔr u ti nyi u na la. Unii u ga gaa dulnyaa ni aanib lii na nyan ni Juu yaab aakaasisik ni la. ");
INSERT INTO xon_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","N‑yoonn choo, ki mu fuu ni a, le binib bi dooni Tite Uwumbɔr mbamɔm na ga li dooni u bisui ni, Waafuur Nyaan aapɔɔn pu. Uwumbɔr ban binib kina aaboln le bi li dooni u. ");
INSERT INTO xon_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uwumbɔr ye kifuurk la. Le binib bimɔk dooni u na li dooni u bisui ni, Waafuur Nyaan aapɔɔn pu.” ");
INSERT INTO xon_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Le upii ngbaan bui u, “M nyi ke Masiya u bi yin u ke Kristo na ga dan. U yaa fuu ni kan, u ga nan tuk timi tiwan mɔmɔk aah bi pu na.” ");
INSERT INTO xon_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Le Yesu bui u, “Min u bi len aa chee na, m ye uma.” ");
INSERT INTO xon_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Libuul ngbaan ni le waadidiliib fuu ni. Baah nan mui u ni upii bi len tɔb chee tibɔr na, le ni gar bi pam; ubaa mu aa baa upii ngbaan, “Aa ban ba?” kaa baa Yesu mu, “Ba pu aa len u chee tibɔr?” ");
INSERT INTO xon_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Le upii ngbaan di waanyunbuul siin, ki buen kitiŋ ni, ki ti bui binib ke, ");
INSERT INTO xon_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dan nan lik man uja u tuk mi maah nan tun pu na mɔmɔk na. Uja ngbaan ga li ye Kristo u ga gaa timi lii na la aa?” ");
INSERT INTO xon_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Le bi nyan kitiŋ ni ki cha u chee. ");
INSERT INTO xon_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Upii ngbaan aah gir buen kitiŋ ni na, le Yesu aadidiliib nan bi gaŋni u ke, “Umɔmɔkr, ji tijikaar.” ");
INSERT INTO xon_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Le u bui bi, “M kpa tijikaar ti naa nyi tibɔr na m ji.” ");
INSERT INTO xon_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Waah len kina na le waadidiliib baa tɔb, “Ubaa le taanin joo ni tijikaar nan tii u uu?” ");
INSERT INTO xon_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Le u bui bi, “Maajikaar le ye ke m ŋa Uwumbɔr u tun ni mi na aah gee pu na, ki tun waatuln doo. ");
INSERT INTO xon_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ni ŋakl liyataŋakl ke, ‘Ni gur iŋmal inaa le ni ŋeer lijikaacheel.’ Tɔ, m tuk nimi la, yaar lik man, tijikaar ŋeer licheel a. ");
INSERT INTO xon_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Unii u chee na ga kan tipar, ki ga di binib koon Uwumbɔr aanaan ni, aan bi kan limɔfal li kaa kpa ndoon na. Nima le ga cha unii u bun na, ni unii u chee na mɔmɔk li kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bi len ke ‘Ubaa bun, le uken chee,’ le ti gbii; ");
INSERT INTO xon_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ba pu? m tun nimi, ni ti chee tijikaar ti naa tun taatuln na. Biken aatuln pu, le ni jin tinyoor.” ");
INSERT INTO xon_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Le upii ngbaan tuk Samaria yaab bi bi kitiŋ ngbaan ni na ke Yesu tuk u waah nan tun pu na mɔmɔk, nima le cha bi ponn ni pam gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Le bi dan u chee, ki gaŋ u ke u li bi bi chee. Le u ŋa bi chee iwiin ilee. ");
INSERT INTO xon_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Le binib bi gaa u ki kii waaliin pu na wiir ki jer binib bi gaa u ki kii upii ngbaan aaliin pu na. ");
INSERT INTO xon_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Le bi tuk upii ngbaan, “Ti gaa u ki kii la; naa ki ye saaliin pu le ti gaa u ki kii. Timi tibaa ŋun waah len pu na, ki bee ke u sil ye Kristo u ga gaa dulnyaa ni aanib lii na.” ");
INSERT INTO xon_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu aah bi bi chee iwiin ilee na, le u nyan nima ki buen Galilee aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uma ubaa le len ke Uwumbɔr aabɔnabr ma kan, udo aatiŋ ni aanib aan nyuŋ u. ");
INSERT INTO xon_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Waah ti fuu Galilee aatiŋ ni na le bi gaa u; ba pu? bi mu nan buen Jerusalem bi ti ji njim ngbaan, ki kan waah tun lijinjiir aatun ŋimɔk na, njim ngbaan yoonn. ");
INSERT INTO xon_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Le u ki dan Galilee aatiŋ kibaa ni, bi yin ki ke Kana, waah nan cha nnyun kpaln ndaan nin chee na. Le ubɔrkpaan aakpambalb ponn ni ubaa bi Kapenaum aatiŋ ni. Le ujapɔɔn bun. ");
INSERT INTO xon_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Uninkpel ngbaan nan ŋun ke Yesu nyan ni Judea aatiŋ ni ki bi Galilee aatiŋ ni. Le u buen Yesu chee, le ki ti gaŋ u ke u dan udo, ki nan cha ujapɔɔn u ban u kpo na aaween sɔŋ. ");
INSERT INTO xon_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Le Yesu bui u, “Ni yaa kaa kan lijinjiir aatun kan, naan gaa mi ki kii.” ");
INSERT INTO xon_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Le uninkpel ngbaan bui u, “Ndindaan, dan mala. Aa yaa taan kan, aa ga nan mui maabo kpo a.” ");
INSERT INTO xon_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Le Yesu bui u, “Li dii saasan. Aajapɔɔn kan limɔfal la.” Le uja ngbaan pak Yesu aah len pu na, ki labr kun. ");
INSERT INTO xon_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Waah paan ni nsan pu na le waatutum tooh ni u nsan ni ki nan bui u ke waabo na kan limɔfal a. ");
INSERT INTO xon_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Le u baa bi, “Bayoonn ni sɔŋ?” Le bi bui u, “Fen na, nwiin aah kpar buyoonn na, le uwon sɔŋ.” ");
INSERT INTO xon_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Le uja ngbaan mu bee ke n‑yoonn mu Yesu fe bui u ke ujapɔɔn kan limɔfal na le na. Kina pu le cha u ni waachiln ni aanib mɔmɔk gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nimina le nan ŋa lijinjiir aatuln leler le u tun waah nyan ni Judea aatiŋ ni ki bi Galilee ni na. ");
INSERT INTO xon_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nee aapuwɔb le Juu yaab aajim mubaa nan bi. Le Yesu buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ponn ni le nnyunbun mu waa na bi ipiih aabisamɔb chee. Juu yaab aaliin ponn ni bi yin nnyunbun ngbaan ke Betsata. Tinaamboln tiŋmu nan si gob nnyunbun ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Le bibum wiir ki dɔ tinaamboln ngbaan ponn ni. Bi nan ye bijoom, ni biwɔb, ni binib bi aawon faan na, ki dɔ kii buyoonn nnyun ga fii yeŋ na; ");
INSERT INTO xon_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ba pu? nwiin nwiin le Uwumbɔr aatuun ubaa sunn ni ki nan koo nnyunbun ni, ki ti kur nnyun. Bundaln u yaa ti dan nan kur nnyun na kan, ubun u puen koo nnyun ni na kan, le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Le uja ubaa bi nima ki bun ŋibin piitaa ni ŋiniin. ");
INSERT INTO xon_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Le Yesu kan u, u dɔ nima, le ki bee ke u bun ni yunn. Le u baa u, “Aa ban aa pɔɔk aa?” ");
INSERT INTO xon_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Le u bui u, “Ndindaan, nnyun yaa fii yeŋ kan, maa kpa unii u ga di mi koon nnyun ni na. M yaa ban m koo nnyun ni kan, le ubaa puen mi ki koo.” ");
INSERT INTO xon_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Le Yesu bui u, “Fiin ki yoor saawandookaan ki li chuun.” ");
INSERT INTO xon_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Libuul ngbaan ni le u pɔɔk, le ki yoor waawandookaan, ki bi chuun. Liyaadaal ngbaan nan ye Juu yaab aakpaakool daal la. ");
INSERT INTO xon_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nima pu le Juu yaab bui uja u pɔɔk na, “Din ye likpaakool la. Saah yoor saawandookaan na, aa bii timi aakaal.” ");
INSERT INTO xon_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Le u bui bi, “Uja u tii mi laafee na, uma le bui mi ke m yoor maawandookaan ki li chuun.” ");
INSERT INTO xon_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Le bi baa u, “Ŋma ye u bui si ke aa yoor saawandookaan ki li joo chuun na?” ");
INSERT INTO xon_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Le uja u pɔɔk na aa nyi unii u ye na; ni ba ye kinipaak ni la, le Yesu nyan nima ki buen. ");
INSERT INTO xon_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nee aapuwɔb le Yesu kan u Uwumbɔr Aadichal ni le ki bui u, “Lik, aa pɔɔk a. Aa taa ki tun titunwanbir aan ki taa ki kan falaa u jer saah kan u na.” ");
INSERT INTO xon_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Le uja ngbaan buen ti tuk Juu yaab ke Yesu le ye uja u cha u pɔɔk na. ");
INSERT INTO xon_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nima pu le Juu yaab nan muk Yesu, ke ba ŋa u tii ubun laafee likpaakool daal. ");
INSERT INTO xon_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Le Yesu bui bi, “Nte Uwumbɔr beenin tun lituln le ki nan saa dandana wee, le m mu bi tun.” ");
INSERT INTO xon_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Waah len kina na, le Juu yaab moo ban bi ku u; ba pu? naa ye waah bii likpaakool daal aakoobil na baanja, u yin Uwumbɔr ke Ute. Waah yin u ke Ute na, u di ubaa ŋaŋ Uwumbɔr la. ");
INSERT INTO xon_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Le Yesu bui bi, “M tuk nimi mbamɔn la, min Uwumbɔr Aajapɔɔn aa ŋmaa ŋa nibaa mbaa pu. Maah kan Nte Uwumbɔr aah ŋani pu na, le m ŋani; waah ŋani pu na, le min Ujapɔɔn mu ŋani kina; ");
INSERT INTO xon_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ba pu? Nte Uwumbɔr gee mi Ujapɔɔn, ki mɔk mi waah tun pu na mɔmɔk. U ga mɔk mi lituln li jer limina na ke m tun, aan ni moo gar nimi. ");
INSERT INTO xon_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nte Uwumbɔr aah fikr binib bi kpo na nkun ni, ki tii bi limɔfal pu na, kina le min Ujapɔɔn mu tii maah lee bi na limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nte Uwumbɔr aa ji unii ubaa tibɔr, u cha min Ujapɔɔn le ji binib mɔmɔk aabɔr, ");
INSERT INTO xon_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","aan binib mɔmɔk nyuŋ min Ujapɔɔn ke baah nyuŋ Nte Uwumbɔr pu na. Unii umɔk kaa nyuŋ min Uwumbɔr Aajapɔɔn na, waa nyuŋ Uwumbɔr u tun ni mi na le na. ");
INSERT INTO xon_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“M tuk nimi mbamɔn la, unii umɔk ŋun maaliin ki gaa Uwumbɔr u tun ni mi na ki kii na, u kpa limɔfal li kaa kpa ndoon na. Uwumbɔr aan ji u tibɔr. U nyan nkun ni, ki kan limɔfal a. ");
INSERT INTO xon_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","M tuk nimi mbamɔn la, n‑yoonn choo, ki mu fuu ni a, le binib bi kpo na ga ŋun min Uwumbɔr Aajapɔɔn aaneel pu, le bi ŋun na ga kan limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nte Uwumbɔr ye Umɔfadaan la, le ki ŋa min Ujapɔɔn mu Umɔfadaan, ");
INSERT INTO xon_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ki tii mi mpɔɔn ke m ji binib tibɔr; ba pu? m ye Unibɔn Aabo la. ");
INSERT INTO xon_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ni taa cha nimina gar nimi man. N‑yoonn choo, le binib bimɔk bi ŋikaakul ni na ga ŋun maaneel pu, ");
INSERT INTO xon_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ki nyan ni. Binib bi nan tun lituln li ŋan dulnyaa wee ni na ga fikr ki kan limɔfal li kaa kpa ndoon na. Binib bi nan tun lituln li kaa ŋan na ga fikr ki kan ntafadaan.” ");
INSERT INTO xon_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Maa ŋmaa ŋa nibaa mbaa pu. M ji binib tibɔr, Uwumbɔr aah tuk mi pu na la. Maah ji bi tibɔr pu na, ni ŋan; ba pu? maa ban maageehn, m ban Uwumbɔr u tun ni mi na aageehn la. ");
INSERT INTO xon_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“M yaa tuk nimi maah ye pu na kan, ni ga len ke taa gbii. ");
INSERT INTO xon_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ubaa mu bi ki len maah ye pu na. Uma le ye Uwumbɔr. M nyi ke waah len pu na, ti gbii. ");
INSERT INTO xon_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ni nan tun binib Jɔnn chee. U mu nan tuk nimi maah ye pu na, ki tuk nimi mbamɔn. ");
INSERT INTO xon_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Naa ye ke m ban unibɔn aaseeraa la. M ban ke ni ŋmar, nima le cha m teer nimi Jɔnn aah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔnn nan bi ke karyaa u gaal mmii ki wiin na la. Ni nan gee ke ni li bi waawiihn ni, ni yunn siib, ki nan kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jɔnn nan tuk nimi maah ye pu na. Tiwan nibaa mu bi ki ji seeraa ki tii mi, ki jer Jɔnn aaseeraa. Nte Uwumbɔr tii mi lituln ke m tun li ki doo. Lima le m tun. Lituln ngbaan le ji seeraa ki tii mi ke Nte Uwumbɔr tun ni mi dulnyaa wee ni. ");
INSERT INTO xon_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nte Uwumbɔr u tun ni mi na, uma ubaa le ji seeraa ki tii mi. Naa kee ŋun waaneel, ki mu aa kee kan unimbil wɔb. ");
INSERT INTO xon_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Waaliin aa bi nisui ni; u tun ni mi ni chee, le naa pak maah len pu na; nima le mɔk ke waaliin aa bi nisui ni. ");
INSERT INTO xon_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ni karni Uwumbɔr Aagbaŋ ke ni bee kaah len pu na; ba pu? ni dak ke ni ga kan limɔfal li kaa kpa ndoon na ki ponn ni. Kigbaŋ ngbaan len maabɔr le na. ");
INSERT INTO xon_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Le naa kii ke ni dan m chee, aan ki kan limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“U nyuŋni mi na aa ye unibɔn. ");
INSERT INTO xon_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","M nyi nimi ke naa gee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","M dan ni chee Nte Uwumbɔr aayimbil pu, le naa gaa mi. Ubaa mu yaa dan ni chee uma ubaa aayimbil pu kan, ni ga gaa uma. ");
INSERT INTO xon_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ni nyuŋni tɔb la, kaa ban ke Uwumbɔr, u ye Uwumbɔr baan na, li nyuŋni nimi. Ni ga ŋa kinye aan ki gaa mi ki kii? ");
INSERT INTO xon_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ni taa dak ke m ga bii nimi Nte Uwumbɔr chee. Ubaa le bi ki ga bii nimi. Uma le ye Moses. Ni mak ke ni ga ŋmar waamɔbon pu. ");
INSERT INTO xon_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tɔ, ni yaa ba pak waamɔbon kan, ni ba ga pak m mu aaliin; ba pu? maabɔr le u ŋmee. ");
INSERT INTO xon_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ni yaa kaa pak waah ŋmee pu na kan, ni ga ŋa kinye ki pak maah len pu na?” ");
INSERT INTO xon_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yesu aah len kina ki ti doo na, le u puur Galilee Aanyusakpem. Bi yin mu ke Galilee, le ki ki yin mu ke Tiberias. ");
INSERT INTO xon_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kinipaak nan dii u. Bi kan waah tun lijinjiir aatun ki tii bibum laafee pu na, nima le cha bi dii u. ");
INSERT INTO xon_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Le u jon lijool paab, le u ni waadidiliib kal kitiŋ nima. ");
INSERT INTO xon_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ni nan gur siib Juu yaab ji njim mu bi yin mu ke Lakr‑jer aajim na. ");
INSERT INTO xon_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Le Yesu yaar lik, le ki kan kinipaak choo u chee. Le u baa Filip, “Ti ga daa tijikaar la chee aan binib ngbaan ji?” ");
INSERT INTO xon_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uma ubaa nyi waah ga ŋa pu na, le ki baa Filip kina ke u lik ke u ga len kinye. ");
INSERT INTO xon_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Le Filip bui u, “Ti yaa di iwiin ikui ilee aapal daa tijikaar kan, taan fuu bi mɔmɔk kan siisii ki ji.” ");
INSERT INTO xon_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Le waadidiliib ponn ni ubaa, bi yin u ke Andru aan u ye Simonn Piita aanaal na, bui u ke, ");
INSERT INTO xon_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Unachipɔnbo ubaa bi do ki joo ŋiboroboro kpin ŋiŋmu ni njanbim mulee; binib ngbaan mu aah wiir pu na, nimina ga ŋa bi ba?” ");
INSERT INTO xon_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Le Yesu bui bi, “Cha binib ngbaan kal kitiŋ.” Timosɔnn nan wiir nima chee. Le bi kal kitiŋ. Bijab ga nan li fuu ŋichur ŋiŋmu. ");
INSERT INTO xon_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","U nan yoor ŋiboroboro kpin ŋiŋmu ngbaan, le ki doon Uwumbɔr, ki geei geei ki tii binib bi ka kitiŋ na, le ki geei geei njanbim mulee na mu, ki tii bi, bimɔk aah ban pu na. ");
INSERT INTO xon_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Le bi mɔmɔk ŋman ki ti bab. Baah ŋman ki ti bab na, le u bui waadidiliib, “Kuun ni baah ŋman gur ni na man, nibaa taa bii.” ");
INSERT INTO xon_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Baah ŋman ŋiboroboro kpin ŋiŋmu ki ti bab ki gur ni na, bi nan kuun ni gbiin tibɔɔkur kipiik ni tilee la. ");
INSERT INTO xon_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Binib ngbaan aah kan Yesu aah tun lijinjiir aatuln ngbaan pu na, le bi bui ke, “Uja wee sil ye Uwumbɔr aabɔnabr u bi nan len ke u ga dan dulnyaa wee ni na la.” ");
INSERT INTO xon_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu nan bee ke bi ban bi chuu u mpɔɔn ki di ŋa baabɔr. Nima pu le u nyan bi chee, ki ki buen lijool ngbaan paab ubaa. ");
INSERT INTO xon_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kijook aah joor na, le waadidiliib buen nnyusakpem ni, ");
INSERT INTO xon_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ki ti koo buŋɔb ni, ki cha nnyusakpem aadapuul, Kapenaum aatiŋ ni. Waa nan kee fuu bi chee, le ni mue. ");
INSERT INTO xon_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Le libuln daar ki pɔɔ sakpen, le tinyunkpenn feeni. ");
INSERT INTO xon_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Baah ŋaal buŋɔb ki pii mal bitaa, bee binaa na, le bi kan u chuun nnyun pu ki choo, ki duun ni baaŋɔb chee. Le ijawaan chuu bi. ");
INSERT INTO xon_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Le u bui bi, “Min ye. Taa san ijawaan man.” ");
INSERT INTO xon_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Waah len kina na, le bi nan kpa mpopiin ki yoor u ŋa buŋɔb na ni. Libuul ngbaan ni le bi fuu baah cha kitiŋ ki ni na. ");
INSERT INTO xon_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ki woln kitaak le kinipaak ki gur nnyusakpem aadapuul na kan ke buŋɔb bubaa aa ki bi bi chee nima, ki nyi ke buŋɔb bubaa baanja le fe bi nima, ki nyi ke Yesu aa fe koo buŋɔb ngbaan ni, waadidiliib chee, bi fe buen bibaa la. ");
INSERT INTO xon_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Le iŋɔi nyan ni Tiberias aatiŋ ni, ki duun ni nin chee Yesu fe doon Uwumbɔr ki tii bi tijikaar bi ji na. ");
INSERT INTO xon_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kinipaak ngbaan kan ke Yesu ni waadidiliib aa ki bi. Nima pu le bi koo iŋɔi ni, ki cha nnyusakpem aadapuul, Kapenaum aatiŋ ni, bi ti ban Yesu. ");
INSERT INTO xon_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Le bi ti kan u nnyusakpem aadapuul, le ki baa u ke, “Umɔmɔkr, aa fuu ni do bayoonn?” ");
INSERT INTO xon_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Le u bui bi, “M tuk nimi mbamɔn la, naah fe jin tijikaar bab na, nima le ni ban mi, naa ye ke ni bee lijinjiir aatun ngbaan aatataa la. ");
INSERT INTO xon_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni taa cha ninimbil li man tijikaar ti ga bii na pu. Ninimbil li man tijikaar ti ga tii nimi limɔfal li kaa kpa ndoon na pu. Min Unibɔn Aabo le ga tii nimi tijikaar ngbaan; ba pu? min Unibɔn Aabo le Nte Uwumbɔr mɔk ke m ye Waanii.” ");
INSERT INTO xon_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Le bi baa u, “Ti ga ŋa kinye aan ki tun Uwumbɔr aatuln waah ban pu na?” ");
INSERT INTO xon_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Le Yesu bui bi, “Ni gaa mi, u Uwumbɔr tun ni na, ki kii man. Uwumbɔr aatuln le na.” ");
INSERT INTO xon_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Le bi baa u, “Aa ga tun lijinjiir aatuln bayaar, aan ti kan ki pak saah len pu na? Aa ga tun bayaar? ");
INSERT INTO xon_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tiyaajatiib nan ji tijikaar ti bi yin ti ke mana na, nteersakpiin ni; ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘U tii bi tijikaar ti nyan ni paacham na ke bi ji.’” ");
INSERT INTO xon_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Le Yesu bui bi, “M tuk nimi mbamɔn la, naa ye Moses le nan tii bi tijikaar ti nyan ni paacham na. Nte Uwumbɔr le tii nimi tijikaar bamɔnn ti nyan ni paacham na. ");
INSERT INTO xon_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tijikaar ti Uwumbɔr tii nimi na le ye tijikaar ti nyan ni paacham ki tii dulnyaa ni aanib limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Le bi bui u, “Tidindaan, li tii timi tijikaar ngbaan n‑yoonn mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Le u bui bi, “Min le ye limɔfal aajikaar. Unii umɔk dan m chee na kan, nkon aan ki chuu u. Unii umɔk gaa mi ki kii na, nnyunyuu aan ki chuu u. ");
INSERT INTO xon_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","M nan tuk nimi ke ni kan mi, ki mu aa gaa mi ki kii. ");
INSERT INTO xon_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Binib bimɔk Uwumbɔr di bi tii mi na, bi ga dan m chee. Unii umɔk dan m chee na, maan yii u, m ga gaa u. ");
INSERT INTO xon_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","M nyan ni paacham ke m nan ŋa Uwumbɔr u tun ni mi na aageehn la. Maa dan m nan ŋa mbaa aageehn. ");
INSERT INTO xon_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uwumbɔr aah tii mi binib bimɔk na, u ban ke m taa cha bi ponn ni ubaa wɔŋ. U ban ke m fikr bi mɔmɔk nkun ni, kookoo aataadaal. Waageehn le na. ");
INSERT INTO xon_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","U ban ke unii umɔk bee ke m ye Ujapɔɔn, ki gaa mi ki kii na, u li kpa limɔfal li kaa kpa ndoon na. Le m ga fikr u nkun ni, kookoo aataadaal. Nte Uwumbɔr aageehn le na.” ");
INSERT INTO xon_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Le Juu yaab ŋul u pu, ke ba ŋa u bui ke u ye tijikaar ti nyan ni paacham na. ");
INSERT INTO xon_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Le bi baa tɔb ke, “Uja wee aa ye Josef aajapɔɔn Yesu uu? Ti nyi ute ni una. Ba ŋa u len ke u nyan ni paacham?” ");
INSERT INTO xon_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Le Yesu bui bi, “Ni taa ŋulni tɔb chee man. ");
INSERT INTO xon_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Unii ubaa aan ŋmaa dan m chee see Nte Uwumbɔr u tun ni mi na daa foor ni u m chee. Unii umɔk dan m chee na le m ga fikr u nkun ni, kookoo aataadaal. ");
INSERT INTO xon_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Uwumbɔr aabɔnabtiib nan ŋmee ke Uwumbɔr ga mɔk bi mɔmɔk waasan. Unii umɔk ŋun Nte Uwumbɔr aah len pu na, ki bae waakaal na, u ga dan m chee. ");
INSERT INTO xon_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ubaa aa kee kan Nte Uwumbɔr. Min u nyan ni u chee na baanja le kan u. ");
INSERT INTO xon_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","M tuk nimi mbamɔn la, unii umɔk gaa mi ki kii na kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Min le ye limɔfal aajikaar. ");
INSERT INTO xon_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Niyaajatiib bi nan jin mana ngbaan nteersakpiin ni na, bi kpo a. ");
INSERT INTO xon_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Unii umɔk ji tijikaar ti nyan ni paacham na aan kpo. ");
INSERT INTO xon_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Min le ye tijikaar ti nyan ni paacham ki tii binib limɔfal na. Unii yaa ji tijikaar ngbaan kan, u ga li bi n‑yoonn mu kaa kpa ndoon na. Tijikaar ti m ga tii u na, tima le ye maawon. M ga di maawon tii dulnyaa ni aanib, aan bi kan limɔfal.” ");
INSERT INTO xon_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Waah len kina na, le Juu yaab kpak tɔb kinikpakpak, “Uja ngbaan ga ŋa kinye ki tii timi waawon, aan ti ji?” ");
INSERT INTO xon_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Le u bui bi, “M tuk nimi mbamɔn la, ni yaa kaa ji min Unibɔn Aabo aawon, kaa nyu maasin kan, naa kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Unii umɔk ji maawon ki nyu maasin na, u kpa limɔfal li kaa kpa ndoon na, le m ga nan fikr u nkun ni, kookoo aataadaal. ");
INSERT INTO xon_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maawon ye tijikaar bamɔnn la. Maasin ye tiwanyukaan bamɔnn la. ");
INSERT INTO xon_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Unii umɔk ji maawon ki nyu maasin na, u bi m ni, le m mu bi u ni. ");
INSERT INTO xon_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nte Uwumbɔr u ye limɔfal daan ki tun ni mi na, u pu le m kpa limɔfal. Unii umɔk ji mi na, m pu le u mu ga li kpa limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Timina le ye tijikaar ti nyan ni paacham na. Unii umɔk ji ti na ga li bi, ki nan saa n‑yoonn mu kaa kpa ndoon na. Tijikaar timina aa bi ke tijikaar ti niyaajatiib nan jin ti na; tijikaar ngbaan aa nan tii bi limɔfal li kaa kpa ndoon na.” ");
INSERT INTO xon_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu nan bi mmeen aadiik ni, Kapenaum aatiŋ ni, le ki len kina. ");
INSERT INTO xon_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Binib bi dii u na aah ŋun kina na, le bi ponn ni pam bui ke, “Ti ye tibɔr ti pɔɔ na la. Ubaa aa ŋmaa pel ti.” ");
INSERT INTO xon_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Le u bee usui ni ke bi ŋulni tibɔr ngbaan pu, le ki baa bi, “Timina le kiir nimi maasan ni ii? ");
INSERT INTO xon_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ni yaa ti kan min Unibɔn Aabo gir buen paacham maah nan bi nin chee na kan, ni ga len kinye? ");
INSERT INTO xon_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Uwumbɔr Aafuur Nyaan le tii binib limɔfal. Tiwon aa kpa tinyoor tibaa. Tibɔr ti m len ni chee na le tii nimi Nfuur Nyaan ni limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ni ponn ni bibaa mu aa gaa mi ki kii.” Yesu aah nan piin waatuln buyoonn na, u nan nyi binib bi kaa gaa u ki kii na, ki nyi udaan u ga nan di u kooh waadim pu na. ");
INSERT INTO xon_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Le u ki bui bi, “Nima le cha m tuk nimi ke ubaa aa ŋmaa dan m chee, see Nte Uwumbɔr cha u dan.” ");
INSERT INTO xon_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nee aapuwɔb le binib bi dii u na ponn ni pam gir puwɔb kaa ki dii u. ");
INSERT INTO xon_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Le u baa waadidiliib kipiik ni bilee na, “Ni mu ga buen cha mi ii?” ");
INSERT INTO xon_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Le Simonn Piita bui u, “Ndindaan, ti ga buen ŋma chee? Sin le kpa limɔfal li kaa kpa ndoon na aaliin. ");
INSERT INTO xon_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ti pak saah len pu na, ki bee ke aa ye Uwumbɔr Aanii u ye Chain na la.” ");
INSERT INTO xon_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Le u bui bi, “M nyan nimi binib kipiik ni bilee, le ni ponn ni ubaa ye kinimbɔŋ aanii.” ");
INSERT INTO xon_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","U len Judas u ye Simonn Iskariot aajapɔɔn na aabɔr la; uma Judas mu nan ye waadidiliib kipiik ni bilee na ponn ni ubaa, u ga nan di Yesu kooh waadim pu na. ");
INSERT INTO xon_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nee aapuwɔb le Yesu bɔ dii Galilee aatingbaan ni. Waa gee u bɔ dii Judea aatingbaan ni; ba pu? Juu yaab bi bi nima na ban ke bi ku u la. ");
INSERT INTO xon_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ni nan gur siib, Juu yaab ji njim mu bi yin mu ke Tikakar Aajim na. ");
INSERT INTO xon_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Le unaatiib bui u, “Siir do, ki li cha Judea aatiŋ ni, aan binib bi dii si na mu ti kan saah tun lijinjiir aatun pu na. ");
INSERT INTO xon_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Unii u ban u li kpa liyimbil na, waan bɔr waah tun pu na. Aa yaa tun lijinjiir aatun kan, cha binib mɔmɔk kan saah tun pu na.” ");
INSERT INTO xon_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Unaatiib mu aa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Le u bui bi, “Maayoonn aa kee fuu. Nimi aayoonn bi n‑yoonn mɔmɔk la. ");
INSERT INTO xon_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dulnyaa aanib aa ŋmaa li nan nimi. Bi nan mi la; ba pu? m tuk bi ke baatuln aa ŋan. ");
INSERT INTO xon_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ni li cha ti ji njim ngbaan. Maan kee buen; maayoonn aa kee fuu.” ");
INSERT INTO xon_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","U nan len bi chee kina, ki gaar Galilee aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Unaatiib aah buen bi ti ji njim ngbaan na, le u mu paan. Waa dii nsan binib aanimbil ni, ubaa aa nyi ubɔr. ");
INSERT INTO xon_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Le Juu yaab aaninkpiib ban u binib bi ji njim na ponn ni, ki baa ke u bi la. ");
INSERT INTO xon_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Le kinipaak na looni len waabɔr tɔb chee. Bibaa len ke u ye unibamɔnn la. Biken len ke waa ye, u ŋmanni binib la. ");
INSERT INTO xon_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ubaa mu aa len waabɔr lipaal; bi san Juu yaab aaninkpiib ijawaan la. ");
INSERT INTO xon_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Njim ngbaan aakpaakool aakaasisik ni le Yesu koo Uwumbɔr Aadichal ni, le ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Le ni gar Juu yaab aaninkpiib, ke uja ngbaan aa bae mbaem; u ŋa kinye ki nyi kigbaŋ? ");
INSERT INTO xon_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Le u bui bi, “Maah mɔk binib na, naa ye min mbaa aamɔkm, ni ye Uwumbɔr u tun ni mi na aamɔkm la. ");
INSERT INTO xon_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Unii ubaa yaa ban ke u ŋa Uwumbɔr aageehn kan, u ga bee ke maah mɔk binib pu na, ni ye Uwumbɔr aamɔkm la, naa ye min mbaa aamɔkm. ");
INSERT INTO xon_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Unii u len ubaa pu na, u ban ke binib nyuŋ u la. Unii u ban ke binib nyuŋ unii u tun ni u na, uma le ye mbamɔndaan, kaa ŋmanni binib. ");
INSERT INTO xon_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses nan tii nimi nkaal. Ni ponn ni ubaa aa dii nkaal ngbaan. Ba ŋa ni ban ni ku mi?” ");
INSERT INTO xon_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Le kinipaak ngbaan bui u, “Aa kpa kinimbɔŋ la. Ŋma ban u ku si?” ");
INSERT INTO xon_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Le u bui bi, “Maah tun lijinjiir aatuln libaa likpaakool daal na, le ni gar ni mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses nan tii nimi nkaal ke ni li geei ŋichakpan. Tɔ, naa ye Moses le puen tii nimi nkaal ngbaan, niyaajatiib le nan puen tii nimi. Likpaakool daal, ubo u ŋeer ni gii uchakpaln na kan, ni geei la. ");
INSERT INTO xon_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ni geei ubo aachakpaln likpaakool daal ke ni taa bii Moses aakaal. Le maah cha ubun aawon mɔmɔk pɔɔk likpaakool daal na, ni gee liŋuul m pu uu? ");
INSERT INTO xon_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ni taa bii unii, kaa nyi tibɔr ti bi usui ni na. Puen bee tiwan ni bi usui ni na, aan ki nin len waabɔr mbamɔm.” ");
INSERT INTO xon_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yesu aah len kina na, le Jerusalem yaab bibaa baa ke, “Uja wee le bi ban bi ku u na aa? ");
INSERT INTO xon_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lik waah len binib aanimbil ni pu na, le ubaa aa len tibaa. Ni ye ke timi aaninkpiib sil nyi ke u ye Kristo u ga gaa timi lii na aa? ");
INSERT INTO xon_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kristo na yaa fuu ni kan, ubaa aan bee waah nyan nin chee na. Uja wee ma kan, ti mɔmɔk nyi waah nyan nin chee na.” ");
INSERT INTO xon_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu nan bi Uwumbɔr Aadichal ni, ki bi tuk binib waaliin, le ki len mpɔɔn pu, “Ni sil nyi mi ii? Ni nyi maah nyan nin chee na aa? Maa dan mbaa pu. U tun ni mi na ye mbamɔndaan la. Le naa nyi u. ");
INSERT INTO xon_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Min le nyi u; uma le tun ni mi. M nyan ni u chee la.” ");
INSERT INTO xon_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Waah len kina na, le bi ban bi chuu u. Ubaa mu aa ŋa u nibaa; ba pu? waayoonn aa nan kee fuu. ");
INSERT INTO xon_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kinipaak ngbaan ponn ni binib pam le gaa u ki kii, le ki bui ke, “Kristo yaa fuu ni kan, waan tun lijinjiir aatun ki jer uja ngbaan aah tun pu na.” ");
INSERT INTO xon_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisii yaab nan ŋun kinipaak ngbaan looni len Yesu aabɔr kina. Le bi ni Uwumbɔr aatotoorninkpiib tun baatutum ke bi ti chuu ni u. ");
INSERT INTO xon_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","U nan bui kinipaak ngbaan, “M ga li bi ni chee ni yunn siib, le ki nin gir buen u tun ni mi na chee. ");
INSERT INTO xon_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ni ga nan ban mi, kaan kan mi. Maah ga ti li bi nin chee na, naan ŋmaa buen nima chee.” ");
INSERT INTO xon_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juu yaab nan baa tɔb ke, “Uja ngbaan ga buen la chee, aan taan kan u? U ga buen Juu yaab aah yaa nin chee Griik yaab aatingbaan ni na, ki ti tuk Griik yaab Uwumbɔr aabɔr aa? ");
INSERT INTO xon_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","U len ke ti ga ban u, kaan kan u, kaan ŋmaa buen waah ga li bi nin chee na. Waah len pu na aatataa ye kinye?” ");
INSERT INTO xon_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bundaln njim ga doo na, liyaadaal le nan ye njim sakpem. Liyaadaal ngbaan le Yesu sil ki len mpɔɔn pu, “Nnyunyuu yaa chuu u na kan, udaan dan m chee ki nan nyu. ");
INSERT INTO xon_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Uwumbɔr Aagbaŋ len ke, ‘Unii umɔk gaa mi ki kii na, limɔfal aanyun ga puu nyan ni usui ni.’” ");
INSERT INTO xon_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Waah len pu na aatataa le ye ke binib bi gaa u ki kii na, bi ga gaa Uwumbɔr Aafuur Nyaan. N‑yoonn ngbaan Uwumbɔr aa nan kee tii binib Waafuur Nyaan; ba pu? waa nan kee yoor Yesu paacham. ");
INSERT INTO xon_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kinipaak ngbaan aah ŋun Yesu aah len pu na, le bibaa bui ke, “Uja ngbaan sil ye Uwumbɔr Aabɔnabr na la.” ");
INSERT INTO xon_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bibaa mu bui ke u ye Kristo u ga gaa binib lii na la. Biken mu bui ke, “Waa ye, ke Kristo aan nyan ni Galilee aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uwumbɔr Aagbaŋ len ke u ga li ye tiyaaja David aayaabil, ki ga nyan ni Betlehem aatiŋ ni, kitiŋ ki ye David do na.” ");
INSERT INTO xon_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kinipaak ngbaan mɔk aamɔi nan bi ibaabaa la le Yesu aabɔr pu. ");
INSERT INTO xon_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bibaa mu nan ban bi chuu u mpɔɔn. Ubaa mu aa ŋa u nibaa. ");
INSERT INTO xon_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Uwumbɔr aatotoorninkpiib ni Farisii yaab aah tun bitutum ke bi ti chuu ni Yesu na, le bitutum ngbaan gir ni bi chee. Le bi baa bi, “Ba ŋa naa chuu ni u?” ");
INSERT INTO xon_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Le bi bui bi, “Unii ubaa aa kee len ke waah len pu na.” ");
INSERT INTO xon_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Le Farisii yaab na baa bi, “U ŋmann ni mu la aa? ");
INSERT INTO xon_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Timi Farisii yaab ni nimi aaninkpiib ponn ni ubaa gaa u ki kii ii? ");
INSERT INTO xon_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kinipaak bi kaa nyi Uwumbɔr aakaal na ma kan, tibɔbir bi bi pu la.” ");
INSERT INTO xon_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemus u nan buen Yesu chee kinyeek na, u mu nan ye Farisii yaab ponn ni ubaa, le ki baa bi, ");
INSERT INTO xon_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Timi aakaal aah dii pu na, ti ga ŋmaa bii unii kaa puen jin u tibɔr ki bee waah tun pu na aa?” ");
INSERT INTO xon_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Le Farisii yaab na baa u, “Aa mu nyan ni Galilee aatiŋ ni la aa? Aa yaa karn Uwumbɔr Aagbaŋ ni kan, aa ga bee ke Uwumbɔr aabɔnabr ubaa aa nyan ni nima.”  ");
INSERT INTO xon_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Le bi mɔmɔk kun. ");
INSERT INTO xon_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu nan buen lijool libaa paab, bi yin li ke Olif aasui aajool. ");
INSERT INTO xon_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Le ki woln kitaak kichakpinaanyeek ni, le u gir buen Uwumbɔr Aadichal ni. Le kinipaak kuun u chee, le u kal ki tuk bi Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Le Uwumbɔr aakaal aamɔmɔkb ni Farisii yaab joo ni upii u bi pii u, u bi ŋani kidagook na, le ki di u siin kinipaak ngbaan aanimbiin ni, ");
INSERT INTO xon_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ki bui Yesu, “Umɔmɔkr, upii wee bi ŋani kidagook, le bi pii u. ");
INSERT INTO xon_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses aakaal len ke unii yaa ŋa kina kan, bi yur u ŋitakpal ki ku u, tɔ, aa len waabɔr kinye?” ");
INSERT INTO xon_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Baah baa Yesu kina na, bi nan bi tɔŋni u ke bi kan waataani aan ki galn u. Le u boon ki joo uŋanbil ŋmee kitiŋ. ");
INSERT INTO xon_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bi nan beenin baa u, le u yaar ki bui bi, “Ni ponn ni u kaa kpa taani na kan, u puen mee upii wee litakpal,” ");
INSERT INTO xon_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ki ki boon ki joo uŋanbil ki ŋmee kitiŋ. ");
INSERT INTO xon_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Baah ŋun u len kina na, le bi mɔmɔk bolni ubaabaa; ba pu? baalandak galn bi. U ye uninkpel na puen boln siir, le bi mɔmɔk bolni ubaabaa, ki ti cha upii ngbaan si Yesu aanimbiin ni. ");
INSERT INTO xon_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Le Yesu yaar ki baa u, “Upii, bi bi la chee? Ubaa aa galn si ii?” ");
INSERT INTO xon_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Le u bui u, “Ndindaan, ubaa aa galn mi.” Le Yesu bui u, “M mu aan galn si. Li cha, ki taa ki tun titunwanbir.” ");
INSERT INTO xon_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu nan ki len kinipaak ngbaan chee ki bui bi, “Min le ye dulnyaa ni aawiihn ki wolni binib aanimbil. Unii umɔk dii mi na aan li bi mbɔmbɔɔn ni. U ga li kpa limɔfal, ki ga li bi nwiihn ni.” ");
INSERT INTO xon_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Waah len kina na, le Farisii yaab bui u, “Aa ji seeraa ki tii aabaa la. Saaseeraa aa ye mbamɔn.” ");
INSERT INTO xon_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Le u bui bi, “M yaa ji seeraa ki tii mbaa kan, maaseeraa ye mbamɔn; ba pu? m nyi maah nyan ni nin chee na, ki nyi maah cha nin chee na mu. Nimi le aa nyi maah nyan ni nin chee na, kaa nyi maah cha nin chee na mu. ");
INSERT INTO xon_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ni len maabɔr binibɔm aah len tibɔr pu na la. Maa len unii ubaa aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","M yaa len binib aabɔr kan, m len mbamɔn la; ba pu? naa ye min baanja le len baabɔr, m ni Uwumbɔr u tun ni mi na le len. ");
INSERT INTO xon_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nimi aakaal ponn ni, ni ŋmee ke binib bilee yaa ji seeraa ki len tibɔbaan kan, baaseeraa ye mbamɔn la. ");
INSERT INTO xon_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","M ji seeraa ki tii mbaa la. Nte u tun ni mi na mu ji seeraa ki tii mi.” ");
INSERT INTO xon_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Le bi baa u, “Aate bi la?” Le u bui bi, “Naa nyi mi, kaa nyi Nte mu. Ni yaa ba nyi mi kan, ni ba ga li nyi Nte mu.” ");
INSERT INTO xon_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Waah len kina na, u nan bi Uwumbɔr Aadichal ni, baah tii Uwumbɔr ŋimombil nin chee na. Le ubaa aa chuu u; ba pu? waayoonn aa kee fuu. ");
INSERT INTO xon_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Le u ki tuk bi, “M ga buen nibaa chee. Ni ga ban mi, kaan kan mi, ki ga nan kpo; le Uwumbɔr aan di cha pinn nimi. Maah cha nin chee na, naan ŋmaa buen nima chee.” ");
INSERT INTO xon_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Le Juu yaab baa tɔb, “U ga ku ubaa la aa? U len ke waah cha nin chee na, taan ŋmaa buen nima chee.” ");
INSERT INTO xon_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Le u bui bi, “Ni nyan ni taab, le m ma nyan ni paacham. Ni ye kitiŋ pu yaab la. Maa ye kitiŋ pu yoo. ");
INSERT INTO xon_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nima le cha m tuk nimi ke ni ga kpo, le Uwumbɔr aan di cha pinn nimi; ba pu? ni yaa kaa gaa mi ki kii ke m ye maah tuk nimi pu na kan, ni ga kpo, le Uwumbɔr aan di cha pinn nimi.” ");
INSERT INTO xon_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Le bi baa u, “Aa ye ŋma?” Le u bui bi, “Maah tuk nimi n‑yoonn mɔmɔk pu na, m ye kina la. ");
INSERT INTO xon_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","M ga ŋmaa len tibɔr sakpenn ti ga bii nimi na. U tun ni mi na ye ubamɔndaan la. Le m ŋun waah len pu na, ki tuk dulnyaa ni aanib.” ");
INSERT INTO xon_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu aah len kina na, baa bee ke u len Ute Uwumbɔr aabɔr la. ");
INSERT INTO xon_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nima pu le u bui bi, “Ni yaa nan yoor min Unibɔn Aabo kitiŋ paacham kan, ni ga bee ke m ye maah ye u na. Ni ga bee ke maa tun nibaa mbaa pu. M len Nte Uwumbɔr aah tuk mi pu na la. ");
INSERT INTO xon_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","U tun ni mi na bi m chee la. Waa cha m bi mbaa; ba pu? n‑yoonn mɔmɔk m tun lituln li piir usui na la.” ");
INSERT INTO xon_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu aah len kina na, le binib pam gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Le u tuk Juu yaab bi gaa u ki kii na, “Ni yaa beenin joo maamɔbon kan, ni sil ye maadidiliib la. ");
INSERT INTO xon_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Le ni ga li beer tibɔbamɔnn. Tibɔbamɔnn tee le ga nya nimi tinaagbiir ni.” ");
INSERT INTO xon_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Le bi bui u, “Ti ye Abraham aayaabitiib la. Ubaa aa kee chuu timi tinaagbiir. Ba ŋa aa bui ke ti ga nya tinaagbiir ni?” ");
INSERT INTO xon_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Le u bui bi, “M tuk nimi mbamɔn la, unii umɔk tun titunwanbir na kan, u ye titunwanbir aanaagbiija la. ");
INSERT INTO xon_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Unaagbiija aan li bi udindaan do n‑yoonn mɔmɔk. Udindaan aajapɔɔn ma ga li bi n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nima pu na, min Uwumbɔr Aajapɔɔn yaa nyan nimi tinaagbiir ni kan, ni ga sil nya tinaagbiir ni. ");
INSERT INTO xon_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","M nyi ke ni ye Abraham aayaabitiib, le ki tee ban ni ku mi. Ni yii maaliin la. Nima le cha ni ban ni ku mi. ");
INSERT INTO xon_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","M tuk nimi maah kan Nte Uwumbɔr chee pu na la. Ni mu ŋani naah ŋun nite chee pu na la.” ");
INSERT INTO xon_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Le bi bui u, “Tite le ye Abraham.” Le u bui bi, “Ni yaa ba ye Abraham aabibamɔm kan, ni ba ga tun waah nan tun pu na. ");
INSERT INTO xon_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","M ŋun tibɔbamɔnn Uwumbɔr chee, le ki tuk nimi. Le ni ban ni ku mi. Abraham aa nan ŋani kina. ");
INSERT INTO xon_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ni ŋani ke nite aah ŋani pu na la.” Le bi bui u, “Taa ye mbɔnbim. Tite ye ubaa la. Uma le ye Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Le u bui bi, “Nite yaa ba sil ye Uwumbɔr kan, ni ba ga li gee mi; ba pu? m nyan ni u chee le ki dan do. Maa dan mbaa pu. Uma le tun ni mi. ");
INSERT INTO xon_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ba ŋa naa bee maah len pu na aatataa? Ni ye ke naa gee ke ni ŋun maaliin la. ");
INSERT INTO xon_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kinimbɔŋ aabim le ye nimi, kima le ye nite. Le ni ban ni li ŋani kaah gee pu na. Dulnyaa aah nan piin buyoonn ki nan saa dandana na, ki ye unikur la. Kaa len ibamɔn. Mbamɔn aa bi ki ni. Ki yaa len inyamɔn kan, ki len tibɔr ti bi ki ni na la. Ki ye unyamɔndaan la. Kima le naan inyamɔn. ");
INSERT INTO xon_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","M ma len ibamɔn la. Nima le cha naa pak maaliin. ");
INSERT INTO xon_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni ponn ni, ŋma ga ŋmaa mɔk maatunwanbir? M len ibamɔn la. Ba ŋa naa pak maah len pu na? ");
INSERT INTO xon_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Unii umɔk ye Uwumbɔr yoo na kan, uma le ŋun waaliin. Nimi le aa ŋun waaliin. Ba pu? Naa ye waanib. Nima le cha naa ŋun waaliin.” ");
INSERT INTO xon_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Le bi bui u, “Taah len ke aa ye Samaria aatiŋ aanii ki kpa kinimbɔŋ na, ti len mbamɔn la.” ");
INSERT INTO xon_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Le u bui bi, “Maa kpa kinimbɔŋ. M nyuŋ Nte Uwumbɔr la. Le ni sii mi. ");
INSERT INTO xon_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Min le aa nyuŋni mbaa; Uwumbɔr le nyuŋni mi. Uma le ga ji binib tibɔr. ");
INSERT INTO xon_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","M tuk nimi mbamɔn la, unii yaa joo maaliin kan, waan kpo.” ");
INSERT INTO xon_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Le bi bui u, “Dandana wee ti bee ke aa kpa kinimbɔŋ la. Tiyaaja Abraham nan kpo. Uwumbɔr aabɔnabtiib mu nan kpo, le aa len ke unii yaa joo saaliin kan, waan kpo. ");
INSERT INTO xon_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aa jer tiyaaja Abraham la aa? U nan kpo. Uwumbɔr aabɔnabtiib mu nan kpo. Aa len ke aa ye ŋma?” ");
INSERT INTO xon_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Le u bui bi, “M yaa nyuŋni mbaa kan, ni ye fam la; Nte le nyuŋni mi. Uma le ni len ke u ye nimi Aawumbɔr. ");
INSERT INTO xon_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Le naa nyi u. Min le nyi u. M yaa len ke maa nyi u kan, m ga li ye unyamɔndaan la, ke naah ye binyamɔndam pu na. M sil nyi u, ki joo waaliin. ");
INSERT INTO xon_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Niyaaja Abraham nan mɔɔni; ba pu? u ga nan kan buyoonn m ga dan na. Waah sil kan n‑yoonn mue na, nima le u nan kpa mpopiin.” ");
INSERT INTO xon_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Le bi baa u, “Saa ye ŋibin piiŋmu aanii, ki bui ke aa nyi Abraham aa?” ");
INSERT INTO xon_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Le u bui bi, “M tuk nimi mbamɔn la, baah kaa nan kee ma Abraham buyoonn na, m nan bi.” ");
INSERT INTO xon_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Le bi yoor ŋitakpal bi ti mae u. Le u miln ki nyan Uwumbɔr Aadichal ni. ");
INSERT INTO xon_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Waah chuun cha na, le u kan ujoon ubaa. Baah ma u na, u nan ye ujoon la. ");
INSERT INTO xon_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Le Yesu aadidiliib baa u, “Umɔmɔkr, uja ngbaan le tun titunwanbir, aan ute ni una le tun, aan bi ma u ujoon.” ");
INSERT INTO xon_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Le Yesu bui bi, “Naa ye uja ngbaan aatunwanbir pu, ki mu aa ye ute, bee una aatunwanbir pu. U ye ujoon aan binib kan Uwumbɔr aah ga tun lijinjiir aatuln pu ki tii u na. ");
INSERT INTO xon_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ni ŋan ke ti tun Uwumbɔr u tun ni mi na aatuln nwiihn aah laa bi pu na; mbɔmbɔɔn choo, le ubaa aan ki ŋmaa tun. ");
INSERT INTO xon_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Maah laa bi dulnyaa ni na, m ye dulnyaa ni aawiihn ki wolni binib aanimbil la.” ");
INSERT INTO xon_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Waah len kina ki ti doo na, le u tii timɔɔtan lii kitiŋ, ki di uŋaal lee, le ni ŋa titan, le ki di pɔl ujoon ngbaan aanimbil, ");
INSERT INTO xon_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ki bui u, “Li cha ki ti finn aanimbil nnyunbun mu bi yin mu ke Siloam na ni.” Siloam aatataa le ye ke “Bi tun u.” Le ujoon ngbaan buen ti finn unimbil, le unimbil likr, le u gir ni. ");
INSERT INTO xon_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Le udoyaab, ni binib bi nyi ke u ye uwanmeer na baa tɔb, “Naa ye uja wee le nan ka ki mee na aa?” ");
INSERT INTO xon_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bibaa bui ke u ye. Biken mu bui ke bi naahn la, waa ye. Le uma ubaa bui ke u ye. ");
INSERT INTO xon_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Le bi baa u, “Aa ŋa kinye aan ki likr?” ");
INSERT INTO xon_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Le u bui bi, “Uja u bi yin u ke Yesu na, uma le nan di titan pɔl nnimbil, le ki bui mi ke m li cha Siloam aanyunbun ni ki ti finn nnimbil. Le m buen ti finn, le nnimbil likr.” ");
INSERT INTO xon_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Le bi baa u, “U bi la chee?” Le u bui bi, “Maa nyi.” ");
INSERT INTO xon_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Le bi di u buen Farisii yaab chee. ");
INSERT INTO xon_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bundaln Yesu ŋa titan ki likr unimbil na nan ye Juu yaab aakpaakool daal la. ");
INSERT INTO xon_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Le Farisii yaab baa uja u nan ye ujoon na, “Aa ŋa kinye aan ki ti likr?” Le u bui bi, “U di titan le pɔl nnimbil, le m finn, le nnimbil likr.” ");
INSERT INTO xon_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Le Farisii yaab bibaa bui ke, “Uja ngbaan aa joo likpaakool daal aakaal, nima le mɔk ke waa nyan ni Uwumbɔr chee.” Le biken mu bui ke, “Unii yaa ye utunwanbirdaan kan, u ga ŋa kinye ki tun lijinjiir aatuln ke waah tun pu na?” Le bi mɔmɔk aamɔi nan bi ibaabaa. ");
INSERT INTO xon_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Le bi ki baa uja u nan ye ujoon na, “Waah likr aanimbil na, aa len waabɔr kinye?” Le u bui bi, “U ye Uwumbɔr aabɔnabr la.” ");
INSERT INTO xon_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Le baa pak ke u nan ye ujoon le ki likr. Le bi yin ni ute ni una, ");
INSERT INTO xon_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ki nan baa bi, “Nijapɔɔn le na aa? Naah ma u na, u ye ujoon la aa? tɔ, u ŋa kinye ki likr dandana wee?” ");
INSERT INTO xon_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Le ute ni una bui bi, “Ti nyi ke tijapɔɔn ye. Taah nan ma u na, u ye ujoon la. ");
INSERT INTO xon_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ti mu aa nyi waah ŋa pu ki likr dandana wee na, ki mu aa nyi udaan u likr unimbil na. U mu aa ki ye ubo. Baa u man. U ga tuk nimi waabɔr.” ");
INSERT INTO xon_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Budabu cha bi len kina na le ye ke bi san Juu yaab aaninkpiib ijawaan; ba pu? Juu yaab aaninkpiib nan puun len ke unii yaa bui ke Yesu le ye Kristo u ga gaa binib lii na kan, bi ga nyan udaan mmeen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nima le ute ni una bui ke, “Waa ki ye ubo. Baa u man.” ");
INSERT INTO xon_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Le Farisii yaab ki yin uja u nan ye ujoon na, le ki nan bui u, “Nyuŋ Uwumbɔr. Ti nyi ke uja ngbaan le ye titunwanbirdaan.” ");
INSERT INTO xon_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Le u bui bi, “Maan ŋmaa bee ke u ye titunwanbirdaan, bee waa ye. Maah nyi ni na le ye ke m nan ye ujoon la. Dandana wee nnimbil likr a.” ");
INSERT INTO xon_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Le bi baa u, “U ŋa kinye aan ki likr aanimbil?” ");
INSERT INTO xon_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Le u bui bi, “Dandana wee le m tuk nimi. Le naa gee ke ni ŋun. Ba pu ni ban ke m ki gir tuk nimi? Ni mu ban ke ni ŋa waadidiliib la aa?” ");
INSERT INTO xon_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Waah len kina na, le bi sii u, ki bui u, “Aa ye waadidiir la. Tima kan, ti ye Moses aadidiliib la. ");
INSERT INTO xon_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ti nyi ke Uwumbɔr nan len Moses chee tibɔr. Uja ngbaan ma kan, taa nyi waah nyan nin chee na.” ");
INSERT INTO xon_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Le u bui bi, “U likr nnimbil la. Le naa nyi waah nyan nin chee na. Ni gar mi pam. ");
INSERT INTO xon_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti nyi ke Uwumbɔr aan ŋun titunwanbirdam aameen. Unii yaa dii Uwumbɔr ki ŋa Uwumbɔr aageehn kan, uma le Uwumbɔr ga ŋun waameen. ");
INSERT INTO xon_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dulnyaa aah piin ki nan saa din na, baa kee ŋun ke unii likr unii u bi ma u ijoon ni na aanimbil. ");
INSERT INTO xon_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Uja ngbaan yaa kaa nyan ni Uwumbɔr chee kan, waa ba ga ŋmaa ŋa nibaa.” ");
INSERT INTO xon_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Le bi bui u, “Bi ma si aa ye titunwanbirdaan la. Aa ye ŋma ki mɔk timi?” le ki jenn nyan u mmeen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu nan ŋun ke bi nyan u. Le u ti kan u, le ki baa u, “Aa gaa Uwumbɔr Aajapɔɔn ki kii ii?” ");
INSERT INTO xon_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Le u baa u, “Ndindaan, ŋma ye Uwumbɔr Aajapɔɔn? Tuk mi aan m gaa u ki kii.” ");
INSERT INTO xon_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Le Yesu bui u, “Aa waa u. Uma le len aa chee tibɔr na.” ");
INSERT INTO xon_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Le u bui u, “Ndindaan, m gaa si ki kii,” le ki gbaan unimbiin ni, ki pak u. ");
INSERT INTO xon_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Le Yesu bui ke, “M dan dulnyaa wee ni, m nan ji binib tibɔr, ki woln binib bi aanimbil aa woln na aanimbil, ki jɔb binib bi aanimbil woln na aanimbil.” ");
INSERT INTO xon_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Le Farisii yaab bi bi u chee na ŋun waah len pu na, le ki baa u, “Ti mu aanimbil aa woln aa?” ");
INSERT INTO xon_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Le u bui bi, “Ninimbil yaa kaa ba woln kan, naa ba ga li kpa ngalm. Le ni len ke ninimbil woln, nima pu le ni kpa ngalm.” ");
INSERT INTO xon_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“M tuk nimi mbamɔn la, unii u loon ki koo ipiih aabɔkpuŋ ni, kaa dii mbisamɔb na, u ye unaayuk la, ki ga peel ipiih mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Unii u dii mbisamɔb koo ni na, uma le ye upihdaan. ");
INSERT INTO xon_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Unii u kii mbisamɔb na ga piir tii u. Le ipiih ŋun waaneel. U yin uma ubaa aapiih aayimbil, le i nyan ni. ");
INSERT INTO xon_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","U yaa nyan waapiih mɔmɔk kan, le u loln nsan, le i paa u pu; ba pu? i nyi waaneel. ");
INSERT INTO xon_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yaan dii uniyayan. I ga san u chee; ba pu? yaa nyi waaneel.” ");
INSERT INTO xon_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ŋak bi liyataŋakl ngbaan, le baa bee laatataa. ");
INSERT INTO xon_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Baah kaa bee liyataŋakl ngbaan aatataa na, le u ki bui bi, “M tuk nimi mbamɔn la, min le ye ipiih aabɔkpuŋ aabisamɔb. ");
INSERT INTO xon_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Binib bimɔk puen mi ki dan na, bi nan ye binaayukb la, ki nan ban bi peel ipiih mpɔɔn. Ipiih aa nan pel baaneel. ");
INSERT INTO xon_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Min le ye Uwumbɔr aanaan ni aabisamɔb. Unii yaa dii mi ki koo ni kan, u ga ŋmar, ki ga koo ki nya ki gir koo, ki ga kan timosoon la. ");
INSERT INTO xon_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Unaayuk yaa dan kan, u ban ke u su ipiih, ki ku i, ki bii i la. M dan m nan tii binib limɔfal li kaa kpa ndoon na la. ");
INSERT INTO xon_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Min le ye upihdaanyaan na. Upihdaanyaan ga ŋmaa kpo waapiih pu. ");
INSERT INTO xon_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Unii u kpaa ipiih ŋimombil pu, kaa ye upihdaan na, u yaa kan lisapol choo kan, u ga san cha i. Lisapol ga chur i, ki cha i yaa. ");
INSERT INTO xon_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","U kpaa ipiih ŋimombil pu la. Utafal aa bi i ni. Nima le cha u san cha i. ");
INSERT INTO xon_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Min le ye upihdaanyaan na, ki nyi maapiih. Le maapiih mu nyi mi, ");
INSERT INTO xon_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ke Nte Uwumbɔr aah nyi mi pu na, kina le m mu nyi u. Le m ga kpo maapiih pu; ba pu? m ye upihdaanyaan na la. ");
INSERT INTO xon_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M kpa ipiih iken i kaa ye kibɔkpuŋ kee ponn ni aapiih na. M ga li joo ni i mu. Le i ga ŋun maaneel. I mɔmɔk ga ŋa ipihbaan la, ki ga li kpa upihdaan ubaa la. ");
INSERT INTO xon_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“M ga di maamɔfal bil maanib pu, ki ga fikr nkun ni. Nima le cha Nte Uwumbɔr gee mi. ");
INSERT INTO xon_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ubaa aan nyan maamɔfal m chee. M ga di li bil maageehn pu la. M kpa mpɔɔn ke m di li bil, ki kpa mpɔɔn ke m ki yoor li. Nte Uwumbɔr le tuk mi ke m ŋa kina.” ");
INSERT INTO xon_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesu aah len kina ki ti doo na, le Juu yaab aamɔi bi ibaabaa. ");
INSERT INTO xon_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bi ponn ni pam nan bui ke, “Tiyayaar le joo u. U waar la. Ba ŋa ni pel waah len pu na?” ");
INSERT INTO xon_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Le biken mu len ke waah len pu na, naa ye unii u tiyayaar joo u na aaliin, ke unii u tiyayaar joo u na aan ŋmaa likr bijoom aanimbil. ");
INSERT INTO xon_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","N‑yoonn ngbaan le Juu yaab ji njim Jerusalem ponn ni, ki teer baah nan toor Uwumbɔr Aadichal buyoonn na. Ni nan ye kakab aayoonn la. ");
INSERT INTO xon_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Le Yesu nan bi chuun Solomonn aakaakpaak ki bi Uwumbɔr Aadichal ni na ni. ");
INSERT INTO xon_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Le Juu yaab kuun ki si gob u, le ki baa u, “Aa ga cha ti li joo beeni ni yunn aa? Aa yaa ye Kristo u ga gaa timi lii na kan, tuk timi mbamɔn.” ");
INSERT INTO xon_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Le u bui bi, “M nan tuk nimi, le naa pak maah len pu na. M tun lituln Nte Uwumbɔr aayimbil pu. Lituln ngbaan le mɔk maah ye udaan u na. ");
INSERT INTO xon_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nimi, naa ye maanib. Nima le cha naa pak maah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Maanib ŋun maaneel, le m nyi bi, le bi dii mi. ");
INSERT INTO xon_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","M tii maanib limɔfal li kaa kpa ndoon na. Baan kpo, ubaa mu aan ŋmaa nyan bi ŋŋaal ni. ");
INSERT INTO xon_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nte Uwumbɔr u di bi tii mi na aapɔɔn jer mpɔɔn mɔmɔk. Ubaa aan ŋmaa nyan bi uma Uwumbɔr aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","M ni Nte Uwumbɔr ye unibaan la.” ");
INSERT INTO xon_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Waah len kina na, le Juu yaab ki yoor ŋitakpal bi ti mae u. ");
INSERT INTO xon_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Le u bui bi, “M tun litunyaan pam Nte Uwumbɔr aapɔɔn pu ninimbil ni. Lilatuln pu ni ban ni mae mi ŋitakpal?” ");
INSERT INTO xon_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Le Juu yaab bui u, “Naa ye litunyaan pu le cha ti ban ti mae si ŋitakpal. Aa sii Uwumbɔr la. Aa po ye unibɔn, le ki len ke aa ye Uwumbɔr la.” ");
INSERT INTO xon_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Le u bui bi, “Ni ŋmee nimi aakaal ponn ni ke Uwumbɔr len ke, ‘Ni ye maabim la.’ Ubaa aan ŋmaa ŋa Uwumbɔr aaliin yɔli. ");
INSERT INTO xon_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Waah di waaliin ŋa binib bi aaŋaal ni na, u bui ke bi ye waabim. ");
INSERT INTO xon_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","M ma kan, Uwumbɔr nyan mi ki tun ni mi dulnyaa wee ni, le maah len ke m ye Ujapɔɔn na, ni bui ke m sii u uu? ");
INSERT INTO xon_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","M yaa kaa tun Nte Uwumbɔr aatuln kan, ni taa pak maah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ni yaa kaa pak maah len pu na kan, ni gaa mi ki kii Uwumbɔr aatuln li m tun na pu, aan ki bee mbamɔm ke Nte Uwumbɔr bi m ni, m mu bi u ni.” ");
INSERT INTO xon_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Waah len kina na, le bi ki ban bi chuu u mpɔɔn, le u miln bi chee. ");
INSERT INTO xon_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Le u ki puur Jɔɔdann aamɔɔdapuul, le ki ti fuu nin chee Jɔnn nan muin binib nnyun ni njan na, ki nan bi nima. ");
INSERT INTO xon_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Le kinipaak dan u chee, ki nan bui ke, “Jɔnn aa nan tun lijinjiir aatuln; tɔ, u mu aah len uja wee aabɔr ti na mɔmɔk gbii.” ");
INSERT INTO xon_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Le binib gaa u ki kii nima chee, ki wiir. ");
INSERT INTO xon_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tɔ, uja ubaa nan bi, le ki bun, bi nan yin u ke Lasarus. U ni uninkpatiib Mari ni Mata nan bi kitiŋ kibaa ni, bi yin ki ke Betani. ");
INSERT INTO xon_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari ngbaan le ye upii u nan di tulalee kpir Tidindaan aataa pu, ki di waayikpir per na. Uma le aaninja Lasarus nan bun. ");
INSERT INTO xon_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Waah bun na, le uninkpatiib tun unii u ti tuk Yesu, “Tidindaan, unii u aa gee u na bun.” ");
INSERT INTO xon_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu aah ŋun kina na, le u bui ke, “Iween ngbaan aadoon aan li ye nkun. Yaadoon le ga cha binib nyuŋ Uwumbɔr aan ki nyuŋ min Ujapɔɔn mu.” ");
INSERT INTO xon_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tɔ, Yesu nan gee Mata, ni unaal, ni Lasarus. ");
INSERT INTO xon_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Waah ŋun ke u bun na, le u gaar waah bi nin chee na iwiin ilee. ");
INSERT INTO xon_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iwiin ilee ngbaan aah jer na, le u bui waadidiliib, “Cha ti ki gir buen Judea aatiŋ ni man.” ");
INSERT INTO xon_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Le waadidiliib baa u, “Umɔmɔkr, naa ye dandana le Juu yaab ban bi mae si ŋitakpal nima aa? Le aa ki ban aa gir buen nima aa?” ");
INSERT INTO xon_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Le u baa bi, “Nwiin mubaa aa ye tikur kipiik ni tilee ee? Unii yaa chuun nwiin pu kan, waan gbeer ki lir; ba pu? dulnyaa ni aawiihn le cha u waa. ");
INSERT INTO xon_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Unii mu yaa chuun kinyeek kan, u ga gbeer ki lir; ba pu? nwiihn aa ki bi u chee.” ");
INSERT INTO xon_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu aah len kina ki ti doo na, le u ki len ke, “Tijɔ Lasarus dɔ geen. M cha m ti finn u la.” ");
INSERT INTO xon_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Le waadidiliib bui u, “Tidindaan, u yaa geen le kan, u ga pɔɔk.” ");
INSERT INTO xon_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu mu aah len pu na le ye ke u kpo a. Waadidiliib ma nyi ke waah len pu na le ye ke u dɔ geen ngeenbamɔm la. ");
INSERT INTO xon_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nima le Yesu nin tuk bi chob chob, “Lasarus kpo a. ");
INSERT INTO xon_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ni ŋa mi mpopiin maah kaa nan bi u chee aan u kpo na; ba pu? nima le ga cha ni moo gaa mi ki kii. Cha ti li cha u chee man.” ");
INSERT INTO xon_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Le waadidiliib ponn ni ubaa, u bi yin u ke Tomas ki ki yin u ke Kijaan na le bui biken, “Cha ti mu dii u man, bi yaa ti ku u kan, ti mu kpo u chee.” ");
INSERT INTO xon_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Le bi buen. Yesu aah ti fuu Betani aatiŋ ni na, le bi bui u, “Taah sub Lasarus na, iwiin inaa le na.” ");
INSERT INTO xon_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalem ni Betani aa daa tɔb, naa pii mal bilee. ");
INSERT INTO xon_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Juu yaab pam le nan nyan nima, ki dan Mata ni Mari chee, bi nan sɔŋ bisui, bininja aah kpo pu na. ");
INSERT INTO xon_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Le Mata ŋun ke Yesu choo, le u tooh u nsan ni. Mari ma beenin ka kidiik ni. ");
INSERT INTO xon_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Le Mata ti bui Yesu, “Ndindaan, aa yaa ba bi do kan, nninja aa ba ga kpo. ");
INSERT INTO xon_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dandana wee mu, m nyi ke aa yaa mee Uwumbɔr tiwan nimɔk pu na kan, u ga tii si.” ");
INSERT INTO xon_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Le Yesu bui u, “Aaninja ga fikr nkun ni.” ");
INSERT INTO xon_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Le Mata bui u, “M nyi ke u ga nan fikr nkun ni, kookoo aataadaal, bundaln binib mɔmɔk ga fikr nkun ni na.” ");
INSERT INTO xon_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Le Yesu bui u, “U fikr binib nkun ni, ki tii bi limɔfal na le ye min. Unii umɔk gaa mi ki kii na, u yaa kpo kan, u ga li kpa limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Unii umɔk bi ki gaa mi ki kii na, waan kpo. Aa pak maah len pu na aa?” ");
INSERT INTO xon_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Le u kii ke, “Een, Ndindaan, m pak ke aa ye Uwumbɔr Aajapɔɔn. Aa ye Kristo u bi nan len ke u ga dan dulnyaa ni na.” ");
INSERT INTO xon_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata aah len kina na, le u buen ti loon yin unaal Mari, le ki bui u, “Umɔmɔkr fuu ni, ki yin si.” ");
INSERT INTO xon_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari aah ŋun kina na, le u kpaan fii mala, ki buen u chee; ");
INSERT INTO xon_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu aa nan kee fuu ni kitiŋ ni, u nan laa bi nsan ni, Mata aah tooh u nin chee na. ");
INSERT INTO xon_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juu yaab bi nan bi lidichal ni Mari chee ke bi sɔŋ usui na aah kan ke u kpaan fii nyan lipaal na, le bi mu fii paan u pu. Bi nan nyi ke u cha likaakul chee le u ti wii. ");
INSERT INTO xon_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Le u ti fuu Yesu aah bi nin chee na. Waah kan u na, le u gbaan unimbiin ni, ki bui u, “Ndindaan, aa yaa ba bi do kan, nninja aa ba ga kpo.” ");
INSERT INTO xon_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Le Yesu kan ke u bi wii. Juu yaab bi mu dii u na, mu bi wii. Le usui bii. Le u fuur kaa lii u ponn ni, ");
INSERT INTO xon_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","le ki baa bi, “Ni sub u la chee?” Le bi bui u, “Ndindaan, dan nan lik.” ");
INSERT INTO xon_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Le Yesu wii. ");
INSERT INTO xon_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Le Juu yaab bui ke, “Lik waah gee u sakpen pu na.” ");
INSERT INTO xon_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Le bibaa mu bui ke, “Uja u likr ujoon aanimbil na, waa ba ga ŋmaa cha Lasarus taa kpo oo?” ");
INSERT INTO xon_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Le Yesu ki fuur kaa lii u ponn ni, le ki ti fuu likaakul na chee. Ni nan ye kitakpadandaŋ aakaakul la. Le litakpal lek mbisamɔb. ");
INSERT INTO xon_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Le u bui bi, “Chuu lekr litakpal na man.” Mata, u ye uja u kpo na aaninkpan na nan bui u, “Ndindaan, waah kpo na, iwiin inaa din. Naah saa pu na, u ga li nuŋ a.” ");
INSERT INTO xon_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Le Yesu baa u, “Maa tuk si ke aa yaa gaa mi ki kii kan, aa ga kan Uwumbɔr aah kpa mpɔɔn pu na aa?” ");
INSERT INTO xon_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Waah len kina na, le bi chuu lekr litakpal na. Le u waan lik paacham ki bui ke, “Nte Uwumbɔr, maah len aa chee pu na, aa ŋun la. Nima le m dooni si. ");
INSERT INTO xon_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","M nyi ke n‑yoonn mɔmɔk aa ŋun maah len aa chee pu na. Kinipaak ki si do na pu, le m len kina, ke bi pak ke sin le tun ni mi.” ");
INSERT INTO xon_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Waah len kina na, le u teen mpɔɔn pu, “Lasarus, nya ni.” ");
INSERT INTO xon_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Le utekpiir ngbaan fikr, ki nyan ni likaakul ni. Likekeln beenin poo uŋaal, ni utaa, ni unimbil wɔb. Le Yesu bui bi, “Chuu poor likekeln ngbaan man, ki cha u li cha.” ");
INSERT INTO xon_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tɔ, Juu yaab bi dii Mari ki kan Yesu aah tun lijinjiir aatuln ngbaan pu na, bi ponn ni pam le nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bi ponn ni bibaa mu nan buen Farisii yaab chee ki ti tuk bi waah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisii yaab aah ŋun kina na, le bi ni Uwumbɔr aatotoorninkpiib yin bibɔjirb aaninkpiib, le bi kuun ni bi chee. Le bi baa bi, “Ti ga ŋa kinye? Uja ngbaan tun lijinjiir aatun pam. ");
INSERT INTO xon_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ti yaa cha u beenin ŋani kina kan, binib mɔmɔk ga gaa u ki kii, le Rom yaab ga dan nan bii timi aatiŋ, ki kuln timi aatimbol aanib mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bi yin bi ponn ni ubaa ke Kayafas; uma le nan ye Uwumbɔr aatotoorninkpel libiln ngbaan; le u bui biken, “Naa nyi nibaa, ");
INSERT INTO xon_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","kaa nyi ke ni ŋan ke uja ubaa kpo binib mɔmɔk pu, aan litimbol ngbaan mɔmɔk taa kuln.” ");
INSERT INTO xon_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Waah len pu na, naa ye ubaa pu le u len. U nan ye Uwumbɔr aatotoorninkpel le libiln ngbaan. Nima pu na, Uwumbɔr Aafuur Nyaan nan cha u len ke Yesu ga kpo litimbol ngbaan aanib mɔmɔk pu. ");
INSERT INTO xon_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Naa ye litimbol ngbaan baanja pu le u ga kpo. U ga kpo ki kuun Uwumbɔr aanib bi yaa ki bi ŋipepel mɔmɔk ni na, ki kpaan bi ke bi ŋa unibaan. ");
INSERT INTO xon_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Uwumbɔr aatotoorninkpel ngbaan aah len kina na, liyaadaal ngbaan ki joo cha, bi nan kpokl baah ga ŋa pu ki ku Yesu na. ");
INSERT INTO xon_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nima pu le Yesu aa nan ki chuun mpaan pu Juu yaab aatiŋ ni. U nan nyan nima ki buen kitiŋ kibaa ni, bi yin ki ke Efraim, le u ni waadidiliib ti bi nima. Kaa daa nteersakpiin chee. ");
INSERT INTO xon_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tɔ, ni nan gur siib le Juu yaab ji njim mu bi yin mu ke Lakr‑jer aajim na. Njim aawiin aa nan kee fuu, le kinipaak nyan itingbaan ni ki buen Jerusalem, bi ti ŋa bibaa chain. ");
INSERT INTO xon_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Le bi ban Yesu. Baah si Uwumbɔr Aadichal ni na, le bi baa tɔb, “Ni dak kinye? U ga tee dan njim mue ni aan waan dan?” ");
INSERT INTO xon_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Le Uwumbɔr aatotoorninkpiib ni Farisii yaab nan bui bi ke unii ubaa yaa nyi waah bi nin chee na kan, u mɔk bi, aan bi buen ti chuu u. ");
INSERT INTO xon_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tɔ, ni nan gur iwiin iloob le Juu yaab ji Lakr‑jer aajim ngbaan, le Yesu buen Betani aatiŋ ni. Lasarus, u Yesu nan fikr u nkun ni na, mu nan bi nima. ");
INSERT INTO xon_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Le bi ŋa tijikaar ti ŋan na nima tii Yesu. Mata nan yoor tijikaar ngbaan siin bi. Lasarus nan ye binib bi nan ji Yesu chee tijikaar na ponn ni ubaa. ");
INSERT INTO xon_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Le Mari yoor tulalee u kpa kidaak sakpen na kpalba ubaa, ki di ŋmir Yesu aataa, ki di uyikpir per utaa. Tulalee ngbaan aah nu mɔ na, waabaam gaa kidiik ni. Bi yin tulalee ngbaan ke naad. ");
INSERT INTO xon_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Le Yesu aadidiliib ponn ni ubaa, bi yin u ke Judas Iskariot, u ga nan kooh Yesu na, baa ke, ");
INSERT INTO xon_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ba ŋa baa di tulalee ngbaan kooh ki kan ŋimombil ŋi ŋeer iwiin ikui itaa aapal ki di tii bigiim?” ");
INSERT INTO xon_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas aatafal aa nan bi bigiim ni. U nan ye unaayuk la, ki nan ye unii u joo ŋimombil aataakɔr na, ki su baah di ŋimombil ŋi ŋa li ponn ni na. Nima le cha u len kina. ");
INSERT INTO xon_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Le Yesu bui Judas, “Di cha Mari. U joo tulalee wee u toor mi kiir maasub daal la. ");
INSERT INTO xon_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bigiim ga li bi ni chee n‑yoonn mɔmɔk. Mma aan li bi ni chee n‑yoonn mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tɔ, Juu yaab pam nan ŋun ke Yesu bi Betani aatiŋ ni, le ki choo u chee. Naa ye Yesu baanja pu le bi dan. Bi nan ban bi kan Lasarus, u Yesu nan fikr u nkun ni na mu. ");
INSERT INTO xon_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nima pu le Uwumbɔr aatotoorninkpiib kpokl ke bi ga ku Lasarus mu; ");
INSERT INTO xon_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ba pu? u pu le Juu yaab pam gaa Yesu ki kii, kaa ki dii bima Uwumbɔr aatotoorninkpiib. ");
INSERT INTO xon_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ki woln kitaak le kinipaak ki bi Jerusalem ke bi ti ji njim na ŋun ke Yesu choo. ");
INSERT INTO xon_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Le bi yoor tibɔkpafar ki ti tooh u nsan ni, le ki tar, “Hosiana, Uwumbɔr ŋa tinyoor ŋa unii u choo waayimbil ni na pu. Uwumbɔr ŋa tinyoor ŋa Israel yaab Aabɔrkpaan pu.” ");
INSERT INTO xon_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Le Yesu kan ubonsal ki diŋ u pu ke Uwumbɔr Aagbaŋ aah len pu na ke, ");
INSERT INTO xon_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sionn aatiŋ aanib, taa san ijawaan man. Lik man, nimi Aabɔrkpaan choo ki dik ubon u laa diin na pu.” ");
INSERT INTO xon_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kinipaak ngbaan aah tooh Yesu nsan pu kina na, n‑yoonn ngbaan le waadidiliib aa bee naatataa. Uwumbɔr aah yoor Yesu paacham na, n‑yoonn ngbaan le bi teer ke ni ŋmee Uwumbɔr Aagbaŋ ni ke bi ga ŋa u kina, le ki teer kinipaak ngbaan aah nan ŋa u pu na. ");
INSERT INTO xon_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kinipaak ki nan bi Yesu chee bundaln u yin Lasarus ke u nyan likaakul ni ki fikr u nkun ni na le nan mooni tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Le binib pam ŋun waah tun lijinjiir aatuln ngbaan pu na. Nima le cha bi tooh u nsan ni. ");
INSERT INTO xon_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisii yaab aah kan kina na, le bi bui tɔb, “Ni kan aa? Taa ki kpa tinyoor tibaa. Dulnyaa ni aanib mɔmɔk dii uma la.” ");
INSERT INTO xon_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Binib bi dan Jerusalem bi nan ji njim ngbaan ki doon Uwumbɔr na, bi ponn ni bibaa nan ye Griik yaab. ");
INSERT INTO xon_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Le bi dan Filip chee. Filip nan ye Betseda aatiŋ ki bi Galilee aatiŋ ni na aanii la. Le bi bui u, “Uninkpel, ti ban ti kan Yesu.” ");
INSERT INTO xon_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Le Filip buen ti tuk Andru. Le bi mɔmɔk bilee buen ti tuk Yesu. ");
INSERT INTO xon_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Le u bui bi, “Buyoonn Uwumbɔr ga yoor min Unibɔn Aabo paacham na fuu ni a. ");
INSERT INTO xon_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","M tuk nimi mbamɔn la, bi yaa di lidibil libaa bun kan, li ga kpo le ki nin ŋa tijikaar sakpen; bi yaa kaa di li bun kan, laan kpo, ki mu aan ŋa tijikaar, li ga li ye libil libaa la. ");
INSERT INTO xon_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Unii umɔk gee waamɔfal ki jer min Yesu na, waamɔfal ga bee yɔli la. Unii umɔk gee min ki jer waamɔfal dulnyaa wee ni na, u ga li kpa limɔfal li kaa kpa ndoon na, kaan bee yɔli. ");
INSERT INTO xon_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Unii yaa ban ke u tun lituln tii mi kan, udaan li dii mi. Maah bi nin chee na, maatutunn mu ga li bi nima. Unii yaa tun lituln tii mi kan, Nte Uwumbɔr ga nyuŋ udaan.” ");
INSERT INTO xon_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Dandana, nsui bii sakpen a. M ga len kinye? M ga len ke, ‘Nte, nyan mi falaa u choo na ni ii?’ Maan len kina; ba pu? ŋitaa ŋi pu m dan dulnyaa wee ni na le ye ke m ji falaa ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nte, cha binib nyuŋ si.” Waah len kina na, le nneel nyan ni paacham ki len ke, “M cha bi nyuŋ mi, ki ga ki cha bi nyuŋ mi.” ");
INSERT INTO xon_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kinipaak ki si u chee ki ŋun nneel ngbaan pu na, bi ponn ni bibaa nan bui ke utaal le gbenni, biken mu bui ke Uwumbɔr aatuun le len u chee. ");
INSERT INTO xon_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Le u bui bi, “Nneel ngbaan aa len m chee min baanja pu la. Mu len ni mu pu la. ");
INSERT INTO xon_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Dandana wee, Uwumbɔr ga ji dulnyaa wee ni aanib tibɔr, ki ga jenn nyan kinimbɔŋ ki ye dulnyaa aanib aayidaan na, ki ŋa ki yɔli. ");
INSERT INTO xon_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bi yaa yoor mi kitiŋ paacham kan, m ga daa foor binib mɔmɔk dan mbaa chee.” ");
INSERT INTO xon_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","U nan len kina ke bi bee waah ga kpo pu na. ");
INSERT INTO xon_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Le kinipaak ngbaan bui u, “Ti ŋun Uwumbɔr Aagbaŋ len ke Kristo u ga gaa timi lii na ga li bi n‑yoonn mɔmɔk. Aa ŋa kinye ki len ke bi ga yoor Unibɔn Aabo kitiŋ paacham? Ŋma ye Unibɔn Aabo ngbaan?” ");
INSERT INTO xon_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Le u bui bi, “Min u ye nwiihn na, maan ki li bi nikaasisik ni, ni yunn. Dii nwiihn mu aah laa bi pu na man, aan mbɔmbɔɔn taa pii nimi. Unii umɔk chuun mbɔmbɔɔn ni na kan, waa nyi waah cha niwɔb na. ");
INSERT INTO xon_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Buyoonn min u ye nwiihn na laa bi ni chee na, gaa mi ki kii man, aan ki ŋa nwiihn ni aabim.” Yesu aah len kina na, le u nyan nima ki bɔr ke bi taa ki kan u. ");
INSERT INTO xon_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","U nan tun lijinjiir aatun pam binimbil ni. Bi mu aa nan gaa u ki kii. ");
INSERT INTO xon_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Baa gaa u ki kii, aan ni gbiin Uwumbɔr aabɔnabr Aisaya aah nan len pu na ke, “Uwumbɔr, ŋma pak taah len pu na? Ŋma bee saah kpa mpɔɔn pu na?” ");
INSERT INTO xon_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aisaya aah len kina na, le baa ŋmaa gaa Yesu ki kii; Aisaya mu ki len ke, ");
INSERT INTO xon_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Uwumbɔr jɔb binimbil ke bi taa li waa; ki cha bitafal pɔɔ, bi taa bee waaliin aatataa, ki taa fenn dan uwɔb ke u tii bi laafee.” ");
INSERT INTO xon_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya nan len kina; ba pu? u nan kan Yesu aah nyuun sakpen pu na, le ki len waabɔr. ");
INSERT INTO xon_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tɔ, Juu yaab aaninkpiib pam nan gaa Yesu ki kii; Farisii yaab pu, le baa len lipaal ke bi gaa u ki kii. Bi yaa len ke bi gaa u ki kii kan, Farisii yaab ngbaan ga nyan bi mmeen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nima le mɔk ke Juu yaab aaninkpiib ngbaan gee binib aapak ki jer Uwumbɔr yaan. ");
INSERT INTO xon_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Le Yesu teen ke, “Unii umɔk gaa mi ki kii na kan, naa ye min baanja le u gaa ki kii, u gaa u tun ni mi na mu ki kii. ");
INSERT INTO xon_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Unii umɔk kan mi na kan, u kan Uwumbɔr u tun ni mi na mu. ");
INSERT INTO xon_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","M ye nwiihn le ki dan dulnyaa ni ke m nan woln binib aanimbil, aan unii umɔk gaa mi ki kii na kan, waan ki li bi mbɔmbɔɔn ni. ");
INSERT INTO xon_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Unii yaa ŋun maaliin, ki yaa kaa kii i kan, maan ji u tibɔr; maa dan ke m nan ji dulnyaa ni aanib tibɔr, m dan ke m gaa bi lii la. ");
INSERT INTO xon_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Unii umɔk yii mi, kaa gaa maaliin na kan, tiwan nibaa bi ki ga mɔk ke waabɔr bii a. Kookoo aataadaal kan, maaliin le ga mɔk ke waabɔr bii, ");
INSERT INTO xon_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ba pu? maa len mbaa pu. Nte Uwumbɔr u tun ni mi na, uma le tuk mi maah ga len pu na. ");
INSERT INTO xon_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","M bee ke unii umɔk kii waaliin na ga li kpa limɔfal li kaa kpa ndoon na. Nima pu na, waah tuk mi pu na, m len kina la.” ");
INSERT INTO xon_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ni nan ye kitaak ki ga nan ji aan ki woln Lakr‑jer aajim daal na. Le Yesu nyi ke ni ŋeer u nya dulnyaa wee ni, ki buen Ute Uwumbɔr chee. N‑yoonn mɔmɔk u nan gee waanib bi bi dulnyaa ni na. U gee bi mbamɔm ki ti saa ndoon. ");
INSERT INTO xon_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Le ni ŋeer bi ji kijook aajikaar. Le kinimbɔŋ dan nan koo Judas Iskariot u ye Simonn aajapɔɔn na aasui ni ke u kooh Yesu. ");
INSERT INTO xon_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nyi ke Ute Uwumbɔr tii u mpɔɔn mɔmɔk, ki nyi ke u nyan ni Uwumbɔr chee, ki ga ki gir buen u chee la. ");
INSERT INTO xon_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","U ni waadidiliib nan kal ke bi ji tijikaar, le u fii sil, ki chuu peer waawanpeenkaan, ki di linaapuul buu uchaŋ ni, ");
INSERT INTO xon_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","le ki ban nnyun ŋa lisambil ni, ki piin ki bi finni waadidiliib aataa, ki joo linaapuul li bi uchaŋ ni na per bitaa. ");
INSERT INTO xon_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Waah ti fuu Simonn Piita chee na le Simonn Piita bui u, “Ndindaan, sin le tee labr finn ntaa aa?” ");
INSERT INTO xon_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Le Yesu bui u, “Dandana, saa bee maah ŋani pu na aatataa. N‑yoonn choo le aa ga nan bee.” ");
INSERT INTO xon_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Le Piita bui u, “Saan finn ntaa daalbaadaal.” Le Yesu bui u, “M yaa kaa finn aataa kan, saan ki li ye maanii.” ");
INSERT INTO xon_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Le Simonn Piita bui u, “Ndindaan, kina kan, taa finn ntaa baanja. Finn ŋŋaal ni n‑yil mu.” ");
INSERT INTO xon_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Le Yesu bui u, “Unii yaa fu nnyun kan, waan ki li ban u finn uwon, see utaa baanja le u ga finn; ba pu? uwon mɔmɔk bi chain. Tɔ, nimi le bi chain; ni mu aa ye ni mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu nyi ke udaan u ga kooh u na bi bi ponn ni, nima le cha u len ke naa ye bi mɔmɔk le bi chain. ");
INSERT INTO xon_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Waah finn bitaa ti doo, ki ki peen waawanpeenkaan, ki gir kal waakakaa chee na, le u baa bi, “Ni bee maah ŋa pu na aatataa aa? ");
INSERT INTO xon_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ni yin mi ke Umɔmɔkr, ki ki yin mi ke Nidindaan. Ni len mbamɔn la; ba pu? m ye kina la. ");
INSERT INTO xon_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tɔ, min u ye Nidindaan ni nimi Aamɔmɔkr na aah finn nitaa pu na, ni ŋan ke ni mu li finni tɔb aataa kina. ");
INSERT INTO xon_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","M mɔk nimi limɔkl la, ke ni mu li ŋani tɔb ke maah ŋa nimi pu na. ");
INSERT INTO xon_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","M tuk nimi mbamɔn la, unaagbiija ubaa aa jer udindaan. Unii u bi tun ni u na ubaa aa jer unii u tun u na. ");
INSERT INTO xon_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni yaa bee maah len pu na aatataa, ki yaa ŋani kina kan, ni ga li kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Maa len ni mɔmɔk pu. M nyi maah nyan bi na aasui ni aah bi pu na, ki nyan nimi ke ni gbiin Uwumbɔr Aagbaŋ aah len pu na ke, ‘M ni unii u kpaan ni ji lisambil ni na, uma le fii sil m pu.’ ");
INSERT INTO xon_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","M tuk nimi tiwan ni kaa kee ŋa na aabɔr dandana, ke ni yaa nan ŋa kan, ni ga pak ke m ye maah ye u na. ");
INSERT INTO xon_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","M tuk nimi mbamɔn la, unii yaa gaa maah ga tun unii u na, u gaa mi le na. Unii yaa gaa mi kan, u gaa Uwumbɔr u tun ni mi na le na.” ");
INSERT INTO xon_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu aah len kina na, le usui bii sakpen. Le u bui bi, “M tuk nimi mbamɔn la, ni ponn ni ubaa ga kooh mi.” ");
INSERT INTO xon_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Le waadidiliib lik tɔb, kaa bee waah len u na. ");
INSERT INTO xon_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Waadidiliib ponn ni ubaa, u Yesu gee u na nan ka gbɔk u ki ji tijikaar. ");
INSERT INTO xon_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Le Simonn Piita di uŋaal mɔk u ke u baa Yesu ke u len ŋma. ");
INSERT INTO xon_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Le udidiir ngbaan foor duun Yesu ki baa u, “Ndindaan, ŋma ye?” ");
INSERT INTO xon_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Le Yesu bui u, “M yaa war bisaa, ki di ŋa tikpin ni, ki di tii u na kan, uma le na.” Waah len kina na, le u war bisaa ki di ŋa tikpin ni, ki di tii Judas, u ye Simonn Iskariot aajapɔɔn na. ");
INSERT INTO xon_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas aah gaa bisaa ngbaan na, le kinimbɔŋ koo usui ni. Le Yesu bui u, “Saah ga ŋa pu na kan, ŋa mala.” ");
INSERT INTO xon_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Binib bi nan bi ji tijikaar na ponn ni ubaa aa nyi ŋitaa ŋi pu Yesu tuk u kina na. ");
INSERT INTO xon_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas le joo ŋimombil aataakɔr. Nima pu le bibaa dak ke Yesu tuk u ke u buen ti daa baah ban njim aajikaar ti na la. Le biken mu dak ke Yesu tuk u ke u buen ti tii bigiim le ŋimombil. ");
INSERT INTO xon_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas aah gaa bisaa ngbaan na, libuul ngbaan ni le u nyan kidiik ni. Ni nan ye kinyeek la. ");
INSERT INTO xon_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas aah nyan na, le Yesu bui bi, “Dandana, Uwumbɔr ga nyuŋ min Unibɔn Aabo. M pu, le binib ga nyuŋ Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bi yaa nyuŋ Uwumbɔr m pu kan, Uwumbɔr mu ga nyuŋ mi ubaa chee. U ga nyuŋ mi dandana wee la. ");
INSERT INTO xon_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Maabim, m ga li bi ni chee ni yunn siib la. Ni ga li ban mi. Maah nan tuk Juu yaab pu na, kina le m ki tuk ni mu dandana, ke naan ŋmaa buen maah cha nin chee na. ");
INSERT INTO xon_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","M tii nimi nkaal pɔɔn la, ke ni li gee tɔb. Maah gee nimi pu na, ni mu li gee tɔb kina. ");
INSERT INTO xon_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni yaa gee tɔb kan, nima le ga cha binib mɔmɔk bee ke ni ye maadidiliib.” ");
INSERT INTO xon_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Le Simonn Piita baa u, “Ndindaan, aa ga buen la chee?” Le Yesu bui u, “Maah cha nin chee na, saan ŋmaa dii mi dandana. N‑yoonn choo, le aa ga nan buen.” ");
INSERT INTO xon_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Le Piita baa u, “Ndindaan, ba pu maan ŋmaa dii si dandana? M ga ŋmaa kpo aa pu.” ");
INSERT INTO xon_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Le Yesu baa u, “Aa ga sil ŋmaa kpo m pu uu? M tuk si mbamɔn la, aa ga len nfum mutaa ke saa nyi mi, le ukooja nin wii.” ");
INSERT INTO xon_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ni taa cha ilandak li muk nimi. Ni gaa Uwumbɔr ki kii man, ki gaa m mu ki kii man. ");
INSERT INTO xon_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tidir wiir Nte Uwumbɔr do. Ti yaa kaa ba wiir kan, m ba ga tuk nimi. M cha m ti toor nkookoo yaan ki kiir nimi la. ");
INSERT INTO xon_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","M yaa buen ti toor nkookoo yaan ki kiir nimi kan, m ga gir ni, ki nan yoor nimi buen mbaa chee, ni ti li bi maah ga li bi nin chee na. ");
INSERT INTO xon_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ni nyi maah cha nin chee na aasan.” ");
INSERT INTO xon_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Le Tomas bui u, “Ndindaan, taa nyi saah cha nin chee na. Ti ga ŋa kinye ki li nyi nsan mu cha nima na?” ");
INSERT INTO xon_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Le Yesu bui u, “Min le ye nsan ngbaan, ni mbamɔn, ni limɔfal. Ubaa aan dan Nte Uwumbɔr chee, see u dii mi. ");
INSERT INTO xon_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni yaa ba nyi mi kan, ni ba ga li nyi Nte Uwumbɔr mu. Dandana ni nyi u, ki kan u.” ");
INSERT INTO xon_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Le Filip bui u, “Ndindaan, mɔk timi Aate. Nima le tinimbil ga gbiin.” ");
INSERT INTO xon_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Le Yesu baa u, “Filip, m bi ni chee ni yunn kina, le saa bee mi ii? Unii umɔk kan mi na, u kan Nte Uwumbɔr mu le na. Ba pu aa bui mi ke m mɔk nimi Nte? ");
INSERT INTO xon_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","M bi Nte Uwumbɔr ni, Nte Uwumbɔr mu bi m ni. Saa pak kina aa? Maah tuk nimi iliin i na, maa len mbaa pu. Nte Uwumbɔr u bi m ni na le cha m tun waatuln. ");
INSERT INTO xon_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Ni li pak ke m bi Nte Uwumbɔr ni, Nte Uwumbɔr mu bi m ni. Ni yaa kaa pak maah len pu na kan, gaa mi ki kii lituln ngbaan pu man. ");
INSERT INTO xon_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","M tuk nimi mbamɔn la, unii umɔk gaa mi ki kii na kan, u ga tun lituln ke maah tun pu na. U mu ga tun lituln li jer lituln ngbaan na; ba pu? m cha Nte Uwumbɔr chee la. ");
INSERT INTO xon_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni yaa mee Uwumbɔr tiwan nimɔk maayimbil pu na kan, m ga ŋa naah ban pu na tii nimi, aan binib nyuŋ Uwumbɔr, min Ujapɔɔn pu. ");
INSERT INTO xon_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ni yaa mee mi tiwan maayimbil pu kan, m ga ŋa naah ban pu na tii nimi.” ");
INSERT INTO xon_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ni yaa gee mi kan, ni ga kii maamɔb, ");
INSERT INTO xon_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","le m ga mee Nte Uwumbɔr, le u ga tii nimi Uteter uken, u li bi ni chee n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uma le ye Uwumbɔr Aafuur Nyaan mu ye mbamɔn na. Dulnyaa aanib aa ŋmaa gaa mu; ba pu? baa waa mu, ki mu aa nyi mu. Nimi le nyi mu; ba pu? mu bi ni chee, ki ga li bi ni ni. ");
INSERT INTO xon_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Maan di nimi lii nibaa. M ga gir ni ni chee. ");
INSERT INTO xon_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ni gur siib le dulnyaa aanib aan ki kan mi. Nimi le ga kan mi. Maah kpa limɔfal na, nima pu le ni mu ga li kpa limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Liyaadaal ngbaan le ni ga bee ke m bi Nte Uwumbɔr ni, le ni mu bi m ni, le m mu bi ni ni. ");
INSERT INTO xon_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Unii umɔk nyi maakaal ki kii mu na, uma le gee mi. Unii yaa gee mi kan, Nte Uwumbɔr ga li gee udaan ngbaan. M mu ga li gee u, ki ga di mbaa mɔk u.” ");
INSERT INTO xon_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Le Judas uken na, naa ye Judas Iskariot, baa u, “Ndindaan, ba pu aa ga di aabaa mɔk timi, kaan di mɔk dulnyaa ni aanib?” ");
INSERT INTO xon_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Le Yesu bui u, “Unii yaa gee mi kan, u ga kii maaliin, le Nte Uwumbɔr ga li gee u, le ti ga dan u chee, ki ga li bi u chee. ");
INSERT INTO xon_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Unii yaa kaa gee mi kan, waan kii maaliin. Maah tuk nimi iliin i na aa ye maaliin, i ye Uwumbɔr u tun ni mi na aaliin la. ");
INSERT INTO xon_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Maah laa bi ni chee na, le m tuk nimi tibɔr timina. ");
INSERT INTO xon_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nte Uwumbɔr ga tun ni Uteter, maayimbil pu. Uteter ngbaan ye Waafuur Nyaan la. Uma le ga mɔk nimi tibɔr mɔmɔk aatataa, ki ga teer nimi maah tuk nimi tibɔr timɔk na. ");
INSERT INTO xon_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“M tii nimi nsuudoon la. Maah kpa nsuudoon pu na, kina le m tii nimi. Dulnyaa aawan aa ŋmaa tii nimi nsuudoon ke maah tii nimi pu na. Ni taa cha ilandak li muk nimi, ki taa san ijawaan man. ");
INSERT INTO xon_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni ŋun m len ke m ga buen ki ga ki gir ni, ni chee. Ni yaa gee mi kan, ni ba ga li kpa mpopiin ke m buen Nte Uwumbɔr chee; ba pu? Nte jer mi. ");
INSERT INTO xon_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","M tuk nimi tiwan ni kaa kee ŋa na aabɔr dandana, ke ni yaa nan ŋa kan, ni gaa mi ki kii. ");
INSERT INTO xon_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Maan ki len ni chee tibɔr ni yunn; ba pu? dulnyaa wee aayidaan kinimbɔŋ le choo. Ki mu aan ŋmaa ŋa mi nibaa. ");
INSERT INTO xon_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","M ban ke dulnyaa ni aanib bee ke m gee Nte Uwumbɔr, nima le m ŋani waah tuk mi pu na mɔmɔk. “Fiin, ti li cha man.” ");
INSERT INTO xon_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Min le ye ndaan aasubil aasupuul bamɔnn na. Nte Uwumbɔr le ye ukpaal u lik busub ngbaan na. ");
INSERT INTO xon_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ibon imɔk bi m pu kaa lu ŋisubil na, u ga per i lii. Ibon imɔk lu ŋisubil na, u ga toor i, i moo lu ŋisubil. ");
INSERT INTO xon_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Maah tuk nimi maaliin na, ima le toor nimi aabimbin. ");
INSERT INTO xon_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ni li kpaan m chee man, m mu kpaan ni chee. Mbon yaa bi mubaa, kaa tuu busub pu kan, mu aan ŋmaa lu ŋisubil. Kina le ni mu yaa kaa kpaan m chee kan, naan ŋmaa li ŋani tinyoor tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Min le ye lisupuul ngbaan. Le ni ye ibon. Unii umɔk kpaan m chee, m mu kpaan u chee na, udaan ngbaan ŋani tinyoor sakpen tii mi; ni mu yaa kaa kpaan m chee kan, naan ŋmaa ŋa nibaa. ");
INSERT INTO xon_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Unii yaa kaa kpaan m chee kan, u ga ŋa yɔli ke mbon mu kaa tuu busub pu na aah kuur pu na la. Le Uwumbɔr ga mee u lii ke binib aah peei ibokuun pu ki joo tuur mmii na. ");
INSERT INTO xon_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni yaa kpaan m chee, ki yaa joo maaliin nisui ni kan, mee Uwumbɔr naah ban pu na man, le u ga ŋa kina tii nimi. ");
INSERT INTO xon_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni yaa ŋani tinyoor sakpen tii Nte Uwumbɔr kan, nima le ga nyuŋ u, ki ga mɔk ke ni sil ye maadidiliib. ");
INSERT INTO xon_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nte Uwumbɔr aah gee mi pu na, kina le m mu gee nimi. Ni li beenin ye maah gee bi na. ");
INSERT INTO xon_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","M ŋani Nte Uwumbɔr aah tuk mi pu na, le u beenin gee mi. Ni mu yaa ŋani maah tuk nimi pu na kan, m mu ga li beenin gee nimi. ");
INSERT INTO xon_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“M tuk nimi tibɔr timina ke ni li kpa mpopiin ke maah kpa pu na. M ban ke ni li kpa mpopiin mbamɔm. ");
INSERT INTO xon_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Maakaal le ye ke ni li gee tɔb ke maah gee nimi pu na. ");
INSERT INTO xon_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Unii yaa kpo ujɔtiib pu kan, ubaa aa ki bi, ki kpa ngeehm ki ti jer kina. ");
INSERT INTO xon_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni yaa ŋani maah tuk nimi pu na kan, ni ye njɔtiib la. ");
INSERT INTO xon_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Maan ki yin nimi ke bitutum; m yin nimi ke njɔtiib la. Ututunn aa nyi udindaan aabɔr mɔmɔk; m tuk nimi tibɔr timɔk m ŋun Nte Uwumbɔr chee na. ");
INSERT INTO xon_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nimi le aa nyan mi. Min le nyan nimi, ki siin ke ni li ŋani tinyoor ti ga li bi n‑yoonn mu kaa kpa ndoon na, ke ni yaa mee Nte Uwumbɔr tiwan maayimbil pu kan, u ga tii nimi. ");
INSERT INTO xon_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ni li gee tɔb. Maah tii nimi nkaal mu na le na.” ");
INSERT INTO xon_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Dulnyaa aanib yaa nan nimi kan, ni li nyi ke bi puen nan mi la, le ki nin nan ni mu. ");
INSERT INTO xon_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ni yaa ba ye dulnyaa yaab kan, dulnyaa yaab ba ga li gee nimi ke baah gee tɔb pu na; ni mu aa ye dulnyaa yaab. M nyan nimi dulnyaa ni aanib aakaasisik ni, nima le cha dulnyaa yaab nan nimi. ");
INSERT INTO xon_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Teer man maah nan tuk nimi pu na ke, ‘Unaagbiija ubaa aa jer udindaan.’ Bi yaa nan ŋa mi falaa kan, bi ga ŋa ni mu falaa. Bi yaa nan kii maaliin kan, bi ga kii nimi aaliin mu. ");
INSERT INTO xon_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Baa nyi Uwumbɔr u tun ni mi na. Nima le bi ga ŋa nimi falaa m pu. ");
INSERT INTO xon_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","M yaa kaa ba dan dulnyaa ni ki nan tuk bi maabɔr kan, baa ba ga li kpa taani; naah bi pu na, bi kpa taani; ba pu? maah tuk bi maabɔr na, baan ki ŋmaa len ke baa nyi ti. ");
INSERT INTO xon_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Unii yaa nan mi kan, naa ye min baanja le u nan, u nan Nte Uwumbɔr mu la. ");
INSERT INTO xon_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","M tun lijinjiir aatun binimbil ni. Ubaa aa ki bi, ki ga ŋmaa tun lijinjiir aatun kina. M yaa kaa ba tun lijinjiir aatun ngbaan binimbil ni kan, baa ba ga li kpa taani; naah bi pu na, bi kpa taani; ba pu? bi kan maah tun pu na, ki nan m ni Nte Uwumbɔr mɔk. ");
INSERT INTO xon_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bi nan timi kina ke ni gbiin Uwumbɔr Aagbaŋ aah len pu na ke, ‘Bi po nan mi fam la, naa ye ke m ŋa bi nibaa.’ ");
INSERT INTO xon_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Tɔ, Uteter na ga fuu ni. Uma le ye Nte Uwumbɔr Aafuur Nyaan mu ye mbamɔn, ki nyan ni Uwumbɔr chee na. Min le ga tun ni mu ni chee. Muma le ga nan tuk nimi maabɔr. ");
INSERT INTO xon_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ni mu ga tuk binib maabɔr; ba pu? ni nan bi m chee, maah piin maatuln buyoonn ki nan saa dandana na. ");
INSERT INTO xon_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“M tuk nimi binib aah ga nan ŋa nimi falaa pu na, ke ni yaa nan ŋa kan, ni taa gir puwɔb. ");
INSERT INTO xon_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bi ga nyan nimi mmeen aadir ni; n‑yoonn mbaa mu choo, unii yaa ku nimi kan, u ga li dak ke u tun Uwumbɔr aatuln le na. ");
INSERT INTO xon_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Baa nyi Nte Uwumbɔr, kaa nyi m mu. Nima le ga cha bi ŋa nimi kina. ");
INSERT INTO xon_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","M tuk nimi baah ga ŋa nimi pu na, ke n‑yaayoonn yaa nan fuu ni kan, ni ga teer ke m nan tuk nimi kina.” “Maah nan bi ni chee na, nima le cha maa nan puen tuk nimi tibɔr tee. ");
INSERT INTO xon_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dandana, m ga ki gir buen u tun ni mi na chee, le ni ponn ni ubaa aa baa mi ke m cha la chee. ");
INSERT INTO xon_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Maah bui ke m ga buen cha nimi na, nima pu le nisui bii sakpen. ");
INSERT INTO xon_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","M tuk nimi mbamɔn la, m yaa buen kan, ni ŋan ki tii nimi; ba pu? m yaa kaa buen kan, Uteter ngbaan aan dan. M yaa buen kan, m ga tun ni u ni chee. ");
INSERT INTO xon_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","U yaa fuu ni kan, u ga mɔk dulnyaa ni aanib ke bi ye titunwanbirdam, ki ga mɔk bi ke m ye uninyaan la, ki ga mɔk bi ke Uwumbɔr ga ji bi tibɔr. ");
INSERT INTO xon_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","U ga mɔk bi ke bi ye titunwanbirdam; ba pu? baa gaa mi ki kii. ");
INSERT INTO xon_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","U ga mɔk bi ke m ye uninyaan la; ba pu? m ga buen Nte Uwumbɔr chee, le naan ki kan mi. ");
INSERT INTO xon_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","U ga mɔk bi ke Uwumbɔr ga ji bi tibɔr; ba pu? u jin kinimbɔŋ ki ye dulnyaa wee ni aayidaan na tibɔr. ");
INSERT INTO xon_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“M kpa tibɔr pam ki ga tuk nimi; ti mu ye nnan aabɔr la, naan ŋmaa gaa ti dandana. ");
INSERT INTO xon_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Uwumbɔr Aafuur Nyaan mu ye mbamɔn na yaa nan fuu ni kan, mu ga tuk nimi mbamɔn mɔmɔk; mu aan len mubaa pu; mu aah ŋun Uwumbɔr chee ti na, tima le mu ga len, ki ga tuk nimi budabu ga nan ŋa n‑yoonn mu choo na na. ");
INSERT INTO xon_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mu ga nyuŋ mi; mu ga di maabɔr tuk nimi. ");
INSERT INTO xon_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nte Uwumbɔr aabɔr mɔmɔk ye maabɔr la. Nima le cha m bui nimi ke mu ga di maabɔr tuk nimi.” ");
INSERT INTO xon_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ni yaa kpee siib kan, naan ki kan mi. Le ni ki kpee siib kan, ni ga ki kan mi.” ");
INSERT INTO xon_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Le waadidiliib bibaa baa tɔb, “Waah len pu na aatataa ye kinye? U bui ke ni yaa kpee siib kan, taan ki kan u, ni ki kpee siib kan, ti ga ki kan u, ki bui ke u ga buen Ute Uwumbɔr chee. ");
INSERT INTO xon_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Ni kpee siib’ aatataa ye kinye? Taa nyi waah len pu na aatataa.” ");
INSERT INTO xon_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Le u bee ke bi ban bi baa u tibɔr ngbaan aatataa. Le u bui bi, “M len ke ni yaa kpee siib kan, naan ki kan mi, ni ki kpee siib kan, ni ga ki kan mi. Ni baa tɔb maah len pu na aatataa la aa? ");
INSERT INTO xon_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","M tuk nimi mbamɔn la, nimi le ga li kaani ki wii; dulnyaa aanib ma ga li kpa mpopiin. Ni ga li kpa mpombiin; nimi aapombiin ngbaan mu ga nan kpaln mpopiin. ");
INSERT INTO xon_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Upii yaa ban u maa ubo kan, u ga li kpa mpombiin waafalaa pu. U ti ma ubo doo kan, waan ki teer falaa ngbaan aabɔr, u ga li kpa mpopiin la; ba pu? unipɔɔn koo ni udo. ");
INSERT INTO xon_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ni bi kina le ni mu chee. Dandana, ni kpa mpombiin la. M ni nimi ga nan ki kan tɔb, le ni ga li kpa mpopiin. Ubaa aan ŋmaa nyan mpopiin ngbaan nisui ni. ");
INSERT INTO xon_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Liyaadaal ngbaan, naan ki baa mi tiwan nibaa pu. M tuk nimi mbamɔn la, ni yaa mee Nte Uwumbɔr tiwan nimɔk maayimbil pu na kan, u ga tii nimi. ");
INSERT INTO xon_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Naa kee mee Uwumbɔr tiwan nibaa maayimbil pu, ki nan saa din. Ni li mee u, le ni ga kan, ki li kpa mpopiin mbamɔm.” ");
INSERT INTO xon_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“M ŋakl ŋiyataŋak le ki tuk nimi tibɔr timina. N‑yoonn choo, maan ki ŋakl ŋiyataŋak tuk nimi. M ga di iliin i diin na le tuk nimi Nte Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Liyaadaal ngbaan le ni ga mee Uwumbɔr maayimbil pu. Maa len ke m ga mee Nte Uwumbɔr ki tii nimi; ");
INSERT INTO xon_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","uma ubaa le gee nimi; ba pu? ni gee mi, ki pak ke m nyan ni u chee. ");
INSERT INTO xon_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tɔ, m nyan ni Nte Uwumbɔr chee, le ki dan dulnyaa ni. Dandana, m ga nya dulnyaa ni, ki gir buen Nte Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Le waadidiliib bui u, “Dandana, aa len iliin i diin na. Saa ki ŋakl ŋiyataŋak. ");
INSERT INTO xon_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dandana ti bee ke aa nyi tiwan mɔmɔk. Binib aa kee baa si, le aa bee baah ban bi baa si pu na. Nima le cha ti pak ke aa nyan ni Uwumbɔr chee.” ");
INSERT INTO xon_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Le u baa bi, “Ni sil gaa mi ki kii dandana wee la aa? ");
INSERT INTO xon_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","N‑yoonn mbaa choo, ki mu fuu ni a, le ni mɔmɔk ga yaa, ki kun, ki cha mi mbaa; m mu aa bi mbaa, Nte Uwumbɔr bi m chee. ");
INSERT INTO xon_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","M tuk nimi tibɔr timina ke ni li kpa nsuudoon m pu. Ni ga kan falaa dulnyaa ni. Ni li kpa lipobil man; ba pu? m nyaŋ dulnyaa a.” ");
INSERT INTO xon_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu aah len kina na, le u waan lik paacham, ki bui ke, “Nte Uwumbɔr, n‑yoonn fuu ni a. Nyuŋ min Aajapɔɔn, le m mu nyuŋ si Nte; ");
INSERT INTO xon_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ba pu? aa ŋa mi binib mɔmɔk Aadindaan ke m di limɔfal li kaa kpa ndoon na, ki di tii saah tii mi binib bi na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sin baanja le ye Uwumbɔr bamɔnn. Binib bi nyi si, ki nyi mi Yesu Kristo u aa tun ni u na, bima le kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","M nyuŋ si dulnyaa wee ni; m tun saah tii mi lituln li na ki doo. ");
INSERT INTO xon_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nte Uwumbɔr, dulnyaa aah kaa nan kee bi buyoonn na, m nan bi aa chee, le aa nyuŋ mi. Nte, ki nyuŋ mi kina aa chee. ");
INSERT INTO xon_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“M mɔk bijab bimina saah bi pu na. Aa nyan bi dulnyaa ni aanib ponn ni ki di tii mi la. Bi nan ye saanib la, le aa di bi tii mi, le bi joo saaliin. ");
INSERT INTO xon_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Dandana bi bee ke saah tii mi tiwan nimɔk na, ni nyan ni aa chee la; ");
INSERT INTO xon_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ba pu? m tuk bi saah tuk mi tibɔr ti na, le bi gaa ti, ki nyi ke ni ye mbamɔn ke m nyan ni aa chee, ki pak ke si le tun ni mi. ");
INSERT INTO xon_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“M mee si tii bi. Maa mee si tii dulnyaa aanib. M mee si tii binib bi aa tii mi na la; ba pu? bi ye saanib la. ");
INSERT INTO xon_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maanib mɔmɔk ye saanib la. Le saanib mu ye maanib. Le bi nyuŋ mi. ");
INSERT INTO xon_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Dandana, m choo aa chee la. Maan ki li bi dulnyaa ni; bima le ga li bi dulnyaa ni. Nte Uwumbɔr u ye chain na, aa tii mi saayimbil. Cha liyimbil ngbaan aapɔɔn li lik bi, bi li ye unibaan ke m ni si aah ye unibaan pu na. ");
INSERT INTO xon_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Maah bi bi chee buyoonn na, m lik bi saayimbil li aa tii mi na aapɔɔn pu la. M lik bi, le bi ponn ni ubaa aa bee yɔli, see nifam na baanja. Waah bee fam na, ni gbiin Uwumbɔr Aagbaŋ aah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dandana m choo aa chee la. Maah laa bi dulnyaa ni na, nima le m len aa chee tibɔr timina ke bi li kpa mpopiin ke maah kpa pu na. ");
INSERT INTO xon_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","M tuk bi saaliin. Maah kaa ye dulnyaa yoo na, kina le bi mu aa ye dulnyaa yaab. Nima le cha dulnyaa aanib nan bi. ");
INSERT INTO xon_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Maa mee si ke aa nyan bi dulnyaa ni. M mee si ke aa taa cha kinimbɔŋ ŋa bi nibaa. ");
INSERT INTO xon_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Maah kaa ye dulnyaa yoo na, kina le bi mu aa ye dulnyaa yaab. ");
INSERT INTO xon_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ŋa bi chain. Cha saaliin i ye mbamɔn na ŋa bi chain. ");
INSERT INTO xon_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Saah tun ni mi dulnyaa wee ni pu na, kina le m mu tun bi dulnyaa ni. ");
INSERT INTO xon_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bi pu le m di mbaa tii si ke bi mu li ye saanib bi bi chain mbamɔm na. ");
INSERT INTO xon_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Maa mee si tii bijab bimina baanja. M mee si tii binib bi ga gaa mi ki kii baaliin pu na la. ");
INSERT INTO xon_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","M mee si ke bi mɔmɔk li ye unibaan. Nte Uwumbɔr, aa bi m ni, le m mu bi aa ni. Cha bi mu li bi ti ni, aan dulnyaa ni aanib pak ke aa sil tun ni mi. ");
INSERT INTO xon_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Saah tii mi saabimbinyaan pu na, kina le m mu tii bi, aan bi li ye unibaan ke m ni si aah ye unibaan pu na. ");
INSERT INTO xon_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","M bi bi ni, le aa mu bi m ni, ke bi kpaan unibaan mbamɔm, aan dulnyaa ni aanib bee ke aa tun ni mi, ki bee ke aa gee saanib ke saah gee mi pu na. ");
INSERT INTO xon_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nte Uwumbɔr, saah tii mi binib bi na, m ban bi mu li bi maah bi nin chee na, ki kan saah nyuŋ mi pu na; saah kaa nan kee naan dulnyaa buyoonn na, aa nan gee mi. ");
INSERT INTO xon_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nte Uwumbɔr u ŋani ni ŋan na, dulnyaa aanib aa nyi si. Min le nyi si. Binib bimina mu bee ke aa tun ni mi la. ");
INSERT INTO xon_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","M mɔk bi saah bi pu na, ki ga li beenin mɔk bi, ke bi mu li gee tɔb ke saah gee mi pu na, aan m mu li bi bi ni.” ");
INSERT INTO xon_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu aah len kina ki ti doo na, le u ni waadidiliib puur nkpen mu bi yin mu ke Kidronn na. Isui i lu ŋisubil jikee na aasaak kibaa bi nima chee. Le bi koo kisaak ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Le Judas, u ga kooh Yesu na, mu nyi nima chee; Yesu ni waadidiliib nan kuuni nima chee kpala kpala. ");
INSERT INTO xon_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Le Judas nan di butɔb aajab ni bitutum bi nyan ni Uwumbɔr aatotoorninkpiib ni Farisii yaab chee na, ki buen kisaak ngbaan ni bi ti chuu Yesu. Bi nan joo ni karyaa mam, ni tijawan. ");
INSERT INTO xon_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Le Yesu nyi budabu ga ŋa u na. Le u tooh bi nsan ni, le ki ti baa bi, “Ni ban ŋma?” ");
INSERT INTO xon_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Le bi bui u, “Ti ban Yesu u ye Nasaref aatiŋ aanii na la.” Le u bui bi, “Min ye.” Judas u kooh u na mu nan si butɔb aajab ngbaan chee. ");
INSERT INTO xon_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu aah len ke uma ye na, le bi sur puwɔb, ki lir kitiŋ. ");
INSERT INTO xon_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nima le u ki baa bi, “Ni ban ŋma?” Le bi bui ke, “Yesu u ye Nasaref aatiŋ aanii na.” ");
INSERT INTO xon_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Le u bui bi, “M tuk nimi ke min ye. Ni yaa ban mi kan, ni cha maadidiliib na li cha.” ");
INSERT INTO xon_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","U len kina ke ni gbiin waah len pu na, ke Uwumbɔr aah tii u binib bi na, waa cha bi ponn ni ubaa bee fam. ");
INSERT INTO xon_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Le Simonn Piita joo kijaak aajuk, le ki di gaa per Uwumbɔr aatotoorninkpel aanaagbiija aatafagiir. Bi yin unaagbiija ngbaan ke Malkus. ");
INSERT INTO xon_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Le Yesu bui Piita, “Di saajuk ngbaan fu kijuchook ni. M taa ji falaa u Nte Uwumbɔr siin mi na aa?” ");
INSERT INTO xon_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Le butɔb aajab, ni baaninkpel, ni bitutum ngbaan chuu Yesu ki buu uŋaal, ");
INSERT INTO xon_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","le ki pue di u buen Anas chee. Anas nan ye Kayafas aachool la. Kayafas nan ye Uwumbɔr aatotoorninkpel le libiln ngbaan, ");
INSERT INTO xon_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ki ye uja u nan tuk Juu yaab ke ni ŋan ke unibaan kpo binib mɔmɔk pu na. ");
INSERT INTO xon_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Baah di Yesu buen na, le Simonn Piita ni Yesu aadidiir ubaa paan u pu. Uwumbɔr aatotoorninkpel nyi Yesu aadidiir ngbaan. Nima le u dii Yesu ki koo ni Uwumbɔr aatotoorninkpel aachiln ni. ");
INSERT INTO xon_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Le Piita nan sil mbisamɔb chee lipaal. Le Yesu aadidiir u Uwumbɔr aatotoorninkpel nyi u na buen ti len usapɔɔn u si kii mbisamɔb na chee, le ki di Piita koo ni. ");
INSERT INTO xon_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Le usapɔɔn ngbaan baa Piita, “Aa mu ye uja ngbaan aadidiir ubaa la aa?” Le u bui u, “Maa ye.” ");
INSERT INTO xon_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tiwoor nan bi. Le Uwumbɔr aatotoorninkpel aatutum, ni Juu yaab aatutum nan di nkoon tuur mmii, ki si wol. Le Piita mu si bi chee, ki si wol mmii. ");
INSERT INTO xon_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Le Uwumbɔr aatotoorninkpel baa Yesu waadidiliib aabɔr, ki baa u waah mɔk binib pu na aabɔr. ");
INSERT INTO xon_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Le Yesu bui u, “N‑yoonn mɔmɔk, le m len binib mɔmɔk aanimbil ni, ki tuk bi Uwumbɔr aaliin, mmeen aadir ni, ni Uwumbɔr Aadichal ni, Juu yaab mɔmɔk aah kuuni nin chee na. Maa len tibɔr tibaa libɔɔl ni. ");
INSERT INTO xon_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ba ŋa aa baa mi? Baa binib bi ŋun maah len pu na ke m tuk bi kinye. Bi nyi maah len pu na.” ");
INSERT INTO xon_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu aah len kina na, le ututunn u si u chee na di uŋaal faa u, le ki baa u, “Uwumbɔr aatotoorninkpel chee le aa len kina aa?” ");
INSERT INTO xon_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Le Yesu bui u, “M yaa len tibɔbir kan, mɔk binib ngbaan taah bir pu na. Maah len pu na yaa ŋan kan, ba ŋa aa faa mi?” ");
INSERT INTO xon_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Le Anas di Yesu tun Kayafas u ye Uwumbɔr aatotoorninkpel na chee. Tikululn beenin buu uŋaal. ");
INSERT INTO xon_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simonn Piita aah si wol mmii pu na, le bi baa u, “Aa mu ye waadidiliib ponn ni ubaa la aa?” Le u nee ki bui ke waa ye. ");
INSERT INTO xon_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Le Uwumbɔr aatotoorninkpel aanaagbiib ponn ni ubaa, u ye uja u Piita gaa per utafal na aana aabo ubaa na, baa u, “Maa ba kan si Yesu chee kisaak ngbaan ni ii?” ");
INSERT INTO xon_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Le Piita ki nee. Libuul ngbaan ni le ukooja wii. ");
INSERT INTO xon_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Le bi di Yesu nyan Kayafas aadichal ni, ki di u buen kitiŋ ngbaan aaninkpel aadichal ni, bi yin u ke Pailat. Ni nan ye lichakpitaawoln la. Juu yaab aaninkpiib nan ban ke bi li bi chain ki ji Lakr‑jer aajim, nima le baa nan koo ni lidichal ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nima pu le Pailat nyan lipaal bi chee, ki ti baa bi, “Ni galn uja ngbaan kinye?” ");
INSERT INTO xon_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Le bi bui u, “Uja ngbaan yaa kaa ba ye bakadaan kan, taa ba ga chuu u ŋa aaŋaal ni.” ");
INSERT INTO xon_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Le Pailat bui bi, “Nimi nibaa gaa u ki ti ji u tibɔr, nimi aakaal aah dii pu na.” Le bi bui u, “Taa kpa nsan ti ku unii.” ");
INSERT INTO xon_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Baah len kina na, ni gbiin Yesu aah nan len pu ki mɔk binib waah ga nan kpo pu na. ");
INSERT INTO xon_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Le Pailat ki labr koo lidichal na ni, le ki yin Yesu, ki nan baa u, “Sin le ye Juu yaab aabɔr aa?” ");
INSERT INTO xon_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Le Yesu baa u, “Saah len pu na, aa len aabaa pu le aan binib le tuk si ke m ye Juu yaab aabɔr.” ");
INSERT INTO xon_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Le Pailat baa u, “M ye Juu yaab aanii la aa? Sin aabaa aanib ni Uwumbɔr aatotoorninkpiib le di si ŋa ŋŋaal ni. Aa ŋa ba?” ");
INSERT INTO xon_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Le Yesu bui u, “Maanaan aa ye dulnyaa wee ni aanaan. Maanaan yaa ba ye dulnyaa wee ni aanaan kan, maadidiliib ba ga jan kijaak, Juu yaab taa ŋmaa chuu mi. Maanaan aa ye dulnyaa wee ni aanaan.” ");
INSERT INTO xon_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Le Pailat baa u, “Aa sil ye ubɔr la aa?” Le Yesu bui u, “Ni ye saah len pu na. M dan dulnyaa wee ni ke m nan tuk binib mbamɔn la. Nima le cha bi ma mi. Unii umɔk ban mbamɔn na kan, u ga kii maah len pu na.” ");
INSERT INTO xon_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Le Pailat baa u, “Mbamɔn ye kinye?” Pailat aah len kina na, le u ki nyan lipaal Juu yaab chee, ki ti bui bi, “Maa kan waataani ubaa. ");
INSERT INTO xon_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nimi aakaal le ye ke m nyan unaagbiija ubaa lii Lakr‑jer aajim yoonn. Ni ban ke m di Yesu, u ye Juu yaab Aabɔr na lii ii?” ");
INSERT INTO xon_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Le bi teen, “Taa di uja ngbaan lii. Di Barabas lii.” Barabas nan ye ufifiir la. ");
INSERT INTO xon_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Le Pailat di Yesu ŋa waatɔb aajab aaŋaal ni ke bi lue u ŋinaalab. ");
INSERT INTO xon_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Le bi luu ikokon aayikpupuk ki di chiŋ u, ki di libɔkumaln peen u, ");
INSERT INTO xon_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","le ki choo ki nan dooni u, ki bui u, “Juu yaab Aabɔr, aa doon aa?” le ki joo biŋaal gbaa u. ");
INSERT INTO xon_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Le Pailat ki nyan lipaal, ki ti bui Juu yaab, “M ga di u nyan ni lipaal ni chee, aan ni bee ke maa kan waataani ubaa.” ");
INSERT INTO xon_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Le Yesu nyan ni lipaal, ki beenin chik ikokon aayikpupuk ki pee libɔkumaln ngbaan. Le Pailat bui bi, “Lik man, uja ngbaan sɔ.” ");
INSERT INTO xon_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Uwumbɔr aatotoorninkpiib ni baatutum aah kan u na, le bi teen ke, “Kpaa u ndɔpuinkoo pu, kpaa u ndɔpuinkoo pu.” Le Pailat bui bi, “Nimi nibaa kpaa u ndɔpuinkoo pu man. Maa kan waataani ubaa.” ");
INSERT INTO xon_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Le bi bui u, “Ti kpa nkaal la. Nkaal ngbaan aah dii pu na, u ŋeer nkun; ba pu? u len ke u ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat aah ŋun ke Yesu bui ke u ye Uwumbɔr Aajapɔɔn na, le ijawaan moo chuu u. ");
INSERT INTO xon_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Le u ki gir koo lidichal ngbaan ni, ki ti baa Yesu, “Aa nyan ni la chee?” Le Yesu aa len tibaa. ");
INSERT INTO xon_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Le Pailat baa u, “Saan gar mi tibaa aa? Li nyi. M kpa mpɔɔn, ki ga ŋmaa di si lii, ki kpa mpɔɔn ki ga ŋmaa kpaa si ndɔpuinkoo pu.” ");
INSERT INTO xon_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Le Yesu bui u, “Uwumbɔr yaa kaa tii si mpɔɔn kan, saan ŋmaa li kpa mpɔɔn ki ŋa mi nibaa. Nima pu na, unii u di mi ŋa aaŋaal ni na, waatunwanbir jer siyaan.” ");
INSERT INTO xon_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Waah len kina na, nima le Pailat ban ke u di u lii; le Juu yaab teen ke, “Aa yaa di uja ngbaan lii kan, saa ye Ubɔrkpaan Siisa aajɔ; unii umɔk len ke u ye ubɔr na, u ye Siisa aadin la.” ");
INSERT INTO xon_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat aah ŋun kina na, le u ki nyan Yesu lipaal ki ti kal ubɔjir aajal pu, bi yin nima chee ke “Ntakpateer paab.” Juu yaab aaliin ponn ni, bi yin nima chee ke “Gabata.” ");
INSERT INTO xon_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ni nan ye Lakr‑jer aajim yoonn la. Liyaadaal ngbaan nan ye kitaak ki ga ji ki woln Juu yaab aakpaakool daal na la. Ni nan ye kichakpiik ni, ki naahn tikur tiloob yoonn. Le Pailat bui Juu yaab, “Lik man, nimi aabɔr sɔ.” ");
INSERT INTO xon_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Le bi teen, “Nyan u nima, nyan u nima, kpaa u ndɔpuinkoo pu.” Le Pailat baa bi, “M di nimi aabɔr kpaa ndɔpuinkoo pu uu?” Le Uwumbɔr aatotoorninkpiib bui u, “Taa ki kpa ubɔr ubaa ki kpee Siisa pu.” ");
INSERT INTO xon_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Baah len kina na, le u di Yesu ŋa biŋaal ni, bi ti kpaa u ndɔpuinkoo pu. Le bi gaa u, ");
INSERT INTO xon_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ki cha u yoor waadɔpuinkoo, le bi di u nyan kitiŋ ponn ni, ki buen nibaa chee, bi yin nima chee ke “Kiyikpaŋ aapepel.” Juu yaab aaliin ponn ni, bi yin nima chee ke “Golgota.” ");
INSERT INTO xon_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Le butɔb aajab ngbaan kpaa u ndɔpuinkoo pu nima chee, le ki kpaa bijab bilee mu idɔpuinkee pu. Bi kpaa ubaa uŋangan wɔb, ki kpaa uken uŋangii wɔb. Le Yesu nan bi bikaasisik ni. ");
INSERT INTO xon_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat nan ŋmee ŋŋmeen ke, “Yesu u ye Nasaref aatiŋ aanii, ki ye Juu yaab Aabɔr na,” le ki di ŋŋmeen ngbaan tam waadɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ni ŋmee Juu yaab aaliin ponn ni, ni Rom yaab aaliin ponn ni, ni Griik yaab aaliin ponn ni. Baah nan kpaa Yesu ndɔpuinkoo pu nin chee na aa daa kitiŋ ni, nima pu na, Juu yaab pam le nan karn ŋŋmeen ngbaan. ");
INSERT INTO xon_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Le Juu yaab aatotoorninkpiib bui Pailat, “Taa ŋmee ke u ye Juu yaab Aabɔr. Ŋmeen ke uma le len ke u ye Juu yaab Aabɔr.” ");
INSERT INTO xon_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Le Pailat bui bi, “Maah ŋmee pu na, ni ŋmee a.” ");
INSERT INTO xon_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Le butɔb aajab bi kpaa u ndɔpuinkoo pu na yakr waawanpeenkaan nfum munaa, bima binib binaa; le ki yoor waakpalk mu. Kikpalk ngbaan nan ye litamuln, kaa kpa baah ŋal nin chee na. ");
INSERT INTO xon_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nima pu le bi bui tɔb, “Taa cha ti kar kikpalk ngbaan. Cha ti too inaan, ki lik ke ulau ga ji ki.” Baah ŋa pu na, ni gbiin Uwumbɔr Aagbaŋ aah len pu na ke: “Bi di maawanpeenkaan yakr tii tɔb, ki too inaan maakpalk pu.” Nima le cha butɔb aajab ngbaan ŋa kina. ");
INSERT INTO xon_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Le Yesu aana, ni unawaa, ni Mari u ye Klopas aapuu na, ni Mari Magdalene, nan si gbɔk Yesu aadɔpuinkoo. ");
INSERT INTO xon_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Le Yesu kan una ni waadidiir u u gee u na si gbɔk u. Le u bui una, “Nna, lik, aajapɔɔn sɔ,” ");
INSERT INTO xon_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","le ki bui waadidiir ngbaan mu, “Lik, aana sɔ.” Liyaadaal ngbaan, le udidiir ngbaan di Yesu aana koon waachiln ni. ");
INSERT INTO xon_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Le Yesu bee ke u tun waatuln doo a. Le u bui ke, “Nnyunyuu chuu mi.” Waah len kina na, ni gbiin Uwumbɔr Aagbaŋ aah len pu na. ");
INSERT INTO xon_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Le tiwanyukaan ni mɔɔn na gbii lisambil ki si nima chee. Le bi di nkiisuk bɔn ni ni, ki di ŋa ndɔ pu, ki di ŋa umɔb ni ke u moor. ");
INSERT INTO xon_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Waah moor ni na, le u bui ke, “Maatuln doo a,” le ki gaa tiin, ki cha waawiin nyan, le u kpo. ");
INSERT INTO xon_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ni nan ye kitaak ki ga woln Juu yaab aafuur daal na la. Likpaakool daal ngbaan nan ye nwiin sakpiin daal la. Nima le Juu yaab aa ban ke ŋinikpol li beenin bi idɔpuinkee pu likpaakool daal. Nima le bi bui Pailat ke u cha waajab ti gbaa kool bitaa, aan bi kpo mala, aan bi chuu nyan bi idɔpuinkee pu. ");
INSERT INTO xon_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Le waajab dan nan gbaa kool bijab bi lee idɔpuinkee pu Yesu chee na aataa. Bi gbaa kool ubaa aataa, ki ti gbaa koo uken mu aataa. ");
INSERT INTO xon_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Baah ti fuu Yesu chee na, bi mui u kpo a, nima le baa gbaa kool utaa. ");
INSERT INTO xon_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Le butɔb aaja ubaa di kigbalk saa Yesu aasikakl. Libuul ngbaan ni, le nsin ni nnyun nyan. ");
INSERT INTO xon_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uja u kan kina na tuk binib waah kan pu na, aan ni mu tii naadii. Waah len pu na, ti gbii. U nyi ke u len mbamɔn la. ");
INSERT INTO xon_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bi ŋa Yesu kina ke ni gbiin Uwumbɔr Aagbaŋ aah len pu na ke, “Waakpab ponn ni libaa aan koo.” ");
INSERT INTO xon_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Uwumbɔr Aagbaŋ ki len ke, “Bi ga lik uja u bi saa u na.” ");
INSERT INTO xon_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tɔ, Josef, u nan ye Arimatea aatiŋ aanii na, mu nan bi nima. U nan ye unii u dii Yesu na, ki mu san Juu yaab ijawaan, kaa cha binib nyi. Uja ngbaan nan buen ti mee Pailat ke u cha u nyan Yesu aawon ndɔpuinkoo pu. Le Pailat kii. Le u buen ti nyan u ndɔpuinkoo pu. ");
INSERT INTO xon_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, u nan dan Yesu chee njan kinyeek na, mu nan fuu ni, ki joo ni tulalee. Ni nan ye tulalee u bi yin u ke mir na, ni tulalee u bi yin u ke alos na, aan bi di ŋmal tɔb ni la. Tulalee ngbaan aanyunyuun ga pii bɔtɔmɔn. ");
INSERT INTO xon_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Le bi di likekenyaan ni tulalee ngbaan poo Yesu aawon. Juu yaab yaa ban bi sub linikpol kan, bi ŋani kina la. ");
INSERT INTO xon_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Baah kpaa Yesu nin chee na, ŋisubil aasui aasaak kibaa nan bi nima. Bi nan gbii kitakpaluŋ kibaa nima chee. Baa nan kee sub unii ubaa ki ponn ni. ");
INSERT INTO xon_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kitakpaluŋ ngbaan aah kaa daa nima chee na, le bi di Yesu aawon ti sub ki ponn ni. Ni nan ye kitaak ki ga woln Juu yaab aakpaakool daal na la. ");
INSERT INTO xon_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Juu yaab aakpaakool daal aah jin ki woln kitaak na, le Mari Magdalene buen likaakul ngbaan chee. Ni nan ye lichakpitaawoln, ki laa bɔɔn. Waah ti fuu likaakul chee na, le u kan ke litakpal li bi nan di leŋ likaakul aamɔb na, aa ki bi. ");
INSERT INTO xon_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Le u san buen Simonn Piita ni Yesu aadidiir uken u Yesu gee u na chee, le ki ti bui bi, “Bi nyan Tidindaan aawon likaakul ni a. Taa nyi baah di ti ŋa nin chee na.” ");
INSERT INTO xon_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Le Piita ni Yesu aadidiir uken ngbaan fii san buen likaakul ngbaan chee. ");
INSERT INTO xon_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Le Yesu aadidiir uken ngbaan san jer Piita ki puen fuu li chee, ");
INSERT INTO xon_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","le ki ti boon ki gbuun lik, ki mui ŋikeken ngbaan le dɔ. Waa koo likaakul na ni. ");
INSERT INTO xon_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Le Simonn Piita, u paan ni puwɔb na mu fuu ni, le ki koo likaakul na ni, ki mui ŋikeken ngbaan dɔ. ");
INSERT INTO xon_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","U mui likekeln li bi nan di poo uyil na kpab, ki dɔ libaa. ");
INSERT INTO xon_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Le Yesu aadidiir u puen fuu ni likaakul chee na mu koo, ki kan, le ki tii naadii. ");
INSERT INTO xon_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Baa nan kee bee Uwumbɔr Aagbaŋ aah len pu na aatataa, ke Yesu ga fikr nkun ni. ");
INSERT INTO xon_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Le bi gir kun. ");
INSERT INTO xon_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tɔ, Mari nan beenin si likaakul na chee ki wii. Waah si wii na, le u boon ki gbuun lik li ponn ni, ");
INSERT INTO xon_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","le ki kan Uwumbɔr aatuuntiib bilee bi pee tiwanpiln na ka Yesu aawon aah ba dɔ nin chee na. Ubaa nan ka uyil aah ba bi ni wɔb na, le uken mu ka utaa aah ba bi ni wɔb na. ");
INSERT INTO xon_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Le bi baa u, “Upii, ba ŋa si aa wii?” Le u bui bi, “Bi nyan Ndindaan aawon la. Maa nyi baah di ti ŋa nin chee na.” ");
INSERT INTO xon_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Waah len kina na, le u fenn lik upuwɔb, ki mui Yesu si, kaa nyi ke Yesu ye. ");
INSERT INTO xon_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Le Yesu baa u, “Upii, ba ŋa si aa wii? Aa ban ŋma?” Mari nan nyi ke uja u kii kisaak na ye. Le u bui u, “Maaninkpel, aa yaa di waawon ŋa nin chee na kan, mɔk mi, m ti yoor.” ");
INSERT INTO xon_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Le Yesu bui u ke, “Mari.” Le u fenn, ki bui u Juu yaab aaliin ni ke, “Raboni.” Naatataa le ye ke “Umɔmɔkr.” ");
INSERT INTO xon_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Le Yesu bui u, “Taa meeh mi. Maa kee buen paacham, Nte Uwumbɔr chee. Li cha ki ti tuk nnaabitiib ke m cha paacham, Nte u ye Maawumbɔr na chee la, u ye ni mu Aate, ki ye ni mu Aawumbɔr na.” ");
INSERT INTO xon_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Le Mari Magdalene buen ti tuk bi, “M kan Tidindaan a,” le ki tuk bi Yesu aah tuk u tibɔr ti na. ");
INSERT INTO xon_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tɔ, Juu yaab aakpaakool daal aah jin ki woln kitaak na aajook le Yesu aadidiliib bi kidiik ni, ki laŋ; ba pu? bi nan san Juu yaab ijawaan. Le Yesu dan nan sil bikaasisik ni, le ki bui bi, “Ni li kpa nsuudoon man.” ");
INSERT INTO xon_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Waah len kina na, le u taln uŋaal ki mɔk bi baah nan kpaa uŋaal ponn ni ipiin pu na, le ki mɔk bi baah nan saa usikakl kigbalk pu na. Waadidiliib aah kan u na, le bi kpa mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Le u ki bui bi, “Ni li kpa nsuudoon man. Nte Uwumbɔr aah tun ni mi pu na, kina le m mu tun nimi.” ");
INSERT INTO xon_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Waah len kina na, le u fuur lii bi pu, le ki bui bi, “Gaa Uwumbɔr Aafuur Nyaan man. ");
INSERT INTO xon_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni yaa di cha pinn binib baatunwanbir kan, bi ga kan chapinn. Ni yaa kaa di cha pinn bi kan, baan kan chapinn.” ");
INSERT INTO xon_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, u bi yin u ke Kijaan, aan u ye Yesu aadidiliib kipiik ni bilee ponn ni ubaa na, aa nan bi bikaasisik ni buyoonn Yesu dan na. ");
INSERT INTO xon_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Le Yesu aadidiliib biken tuk u, “Ti kan Tidindaan a.” Le u bui bi, “M yaa kaa kan baah nan kpaa uŋaal ponn ni ipiin pu na aabue, ki di ŋŋanbik baan ŋibue ngbaan ponn ni, ki di ŋŋaal baan baah nan saa usikakl kigbalk pu na aabuer ponn ni kan, maan pak naah len pu na.” ");
INSERT INTO xon_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tɔ, le iwiin iniin jer. Le Yesu aadidiliib nan ki bi kidiik ni. Tomas mu nan bi bi chee. Bi nan laŋ kidiik a. Le Yesu dan nan sil bikaasisik ni, le ki bui ke, “Ni li kpa nsuudoon man,” ");
INSERT INTO xon_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","le ki bui Tomas, “Di aaŋanbik baan ŋŋaal aabue ponn ni, ki di aaŋaal baan nsikakl aabuer mu ponn ni, aan ki gaa mi ki kii, aan ki taa ki beeni.” ");
INSERT INTO xon_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas nan bui u, “Aa ye Ndindaan ni Maawumbɔr la.” ");
INSERT INTO xon_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Le Yesu bui u, “Saah kan mi na le aa gaa mi ki kii. Uwumbɔr aanyoor bi binib bi kaa kan mi aan ki gaa mi ki kii na pu.” ");
INSERT INTO xon_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tɔ, Yesu nan tun lijinjiir aatun ŋiken pam waadidiliib aanimbil ni. Ni mɔmɔk mu aa bi kigbaŋ kee ni. ");
INSERT INTO xon_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bi ŋmee nimina ke ni pak ke Yesu le ye Kristo u gaa timi lii na, ki ye Uwumbɔr Aajapɔɔn. Ni yaa gaa u ki kii kan, u pu le ni ga li kpa limɔfal. ");
INSERT INTO xon_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nee aapuwɔb le Yesu di ubaa mɔk waadidiliib nnyusakpem chee, bi yin mu ke Tiberias (ki ki yin mu ke Galilee). Kina le u nan di ubaa mɔk bi. ");
INSERT INTO xon_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simonn Piita ni Tomas u bi yin u ke Kijaan na, ni Natanael u nyan ni Kana aatiŋ ki bi Galilee aatiŋ ni na, ni Sebedee aajapɔtiib bilee na, ni Yesu aadidiliib bilee biken nan bi tɔb chee. ");
INSERT INTO xon_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","N‑yoonn ngbaan le Simonn Piita bui bi, “M cha m ti chur ijan la.” Le bi bui u, “Ti mu ga dii si.” Le bi buen ti koo buŋɔb ni, ni di ti woln, baa kan nibaa. ");
INSERT INTO xon_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nwiin aah laa puu ni na, le Yesu sil nnyun aagbaan. Bididiliib ngbaan aa nan nyi ke Yesu ye. ");
INSERT INTO xon_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Le u baa bi, “Binachipɔm, naa kan ijan aa?” Le bi bui u, “Taa kan.” ");
INSERT INTO xon_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Le u bui bi, “Di kipɔɔk ngbaan di mee buŋɔb aaŋangii wɔb man, le ni ga kan.” Le bi mee ki chuu ijan pam, le kaa ŋmaa yoor. ");
INSERT INTO xon_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Le Yesu aadidiir u Yesu gee u na bui Piita, “Tidindaan ye.” Baah nan bi ban ijan na, bi nan yii ŋikpatambinn baanja la. Simonn Piita aah ŋun ke Tidindaan ye na, le u yoor waabɔkul ki di peen, le ki lir nnyun ni ki cha u chee. ");
INSERT INTO xon_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Waadidiliib bi gur na nan bi buŋɔb ngbaan ni ki dar kipɔɔk ki gbii ijan na, ki choo nnyun aagbaan. Nnyun aagbaan aa nan daa. Ni naahn ŋisaŋ ikui ilee la. ");
INSERT INTO xon_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Baah ti fuu nnyun aagbaan ki nyan buŋɔb ni na, bi mui nkoon aamii bi, ujan pu mu ni, le boroboro mu bi. ");
INSERT INTO xon_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Le Yesu bui bi, “Li joo ni naah chuu ijan i na ngem.” ");
INSERT INTO xon_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Le Simonn Piita ki koo buŋɔb na ni ki ti gbiln kipɔɔk na, ki joo dar cha n‑gbaan. Kipɔɔk ngbaan nan gbii ijan sakpiin. Ijan ngbaan nan ye nkub ni piiŋmu ni itaa. Yaah po wiir kina na, kipɔɔk ngbaan aa nan kar. ");
INSERT INTO xon_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Le Yesu bui bi, “Dan nan ji man.” Waadidiir ubaa aa nan kaa u baa u, “Si ŋma ye?” ba pu? bi nyi ke Tidindaan ye. ");
INSERT INTO xon_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Le Yesu dan nan yoor boroboro ni ijan ki di tii bi. ");
INSERT INTO xon_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu aah nan fikr nkun ni ki joo ubaa mɔk waadidiliib na, nimina le nan ŋa taataa. ");
INSERT INTO xon_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baah jin tijikaar ngbaan doo na, le Yesu baa Simonn Piita, “Simonn, Jɔnn aajapɔɔn, aa gee mi ki jer tiwan nimina aa?” Le u bui u, “Ndindaan, een, aa nyi ke m gee si.” Le Yesu bui u, “Kpiin maapihbi,” ");
INSERT INTO xon_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","le ki ki baa u lelee, “Simonn, Jɔnn aajapɔɔn, aa gee mi ii?” Le u ki bui u, “Ndindaan, een, aa nyi ke m gee si la.” Le Yesu bui u, “Li kii maapiih,” ");
INSERT INTO xon_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","le ki ki baa u taataa, “Simonn, Jɔnn aajapɔɔn, aa gee mi ii?” Le Simonn Piita aasui bii; ba pu? u nan baa u nfum mutaa mɔk, “Aa gee mi ii?” Le u bui u, “Ndindaan, aa nyi tiwan mɔmɔk. Aa nyi ke m gee si.” Le Yesu bui u, “Kpiin maapiih. ");
INSERT INTO xon_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","M tuk si mbamɔn la, saah nan ye unachipɔɔn na, aa nan peeni saawanpeenkaan, ki chaa saah gee nin chee na. Aa yaa ti por kan, aa ga taln aaŋaal, unii ubaa le ga peen si, ki yoor si buen saah kaa gee nin chee na.” ");
INSERT INTO xon_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","U nan bui Piita kina ke u mɔk u, uma Piita aah ga kpo ki nyuŋ Uwumbɔr pu na. Waah len kina na, le u bui u, “Li dii mi.” ");
INSERT INTO xon_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Le Piita fenn upuwɔb, ki kan Yesu aah gee waadidiir u na paa ni bi pu. Waadidiir ngbaan ye unii u nan foor duun Yesu, baah nan bi ji tijiir buyoonn na, ki nan baa u ke, “Ndindaan, ŋma ga kooh si?” na. ");
INSERT INTO xon_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piita aah kan u paani bipuwɔb na, le u baa Yesu, “Ndindaan, ba ga ŋa uja wee?” ");
INSERT INTO xon_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Le Yesu bui u, “M yaa gee ke u li bi ki nan saa buyoonn m ga nan gir ni na kan, ti ye saabɔr aa? Li dii mi.” ");
INSERT INTO xon_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nima le Yesu aanib bui ke waadidiir ngbaan aan kpo. Yesu ma aa bui ke waan kpo, u po bui le ke, “M yaa gee ke u li bi ki nan saa buyoonn m ga nan gir ni na kan, ti ye saabɔr aa?” ");
INSERT INTO xon_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Waadidiir ngbaan le ye unii u tuk binib tibɔr tee, ki ŋmee ti kigbaŋ kee ni na. Ti bee ke waah len pu na gbii. ");
INSERT INTO xon_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tiwan pam aabɔŋ le Yesu ŋa, bi mu aa ŋmee ni mɔmɔk. Bi yaa ba ŋmee ni mɔmɔk kan, maa dak ke bi ba ga kan mpaan dulnyaa ni ki bil baah ŋmee tigbann ti na.");
INSERT INTO xon_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Njɔ Teofilus, min Luk nan ŋmee njan aagbaŋ ke m tuk si Yesu aah nan ŋa pu na mɔmɔk, ni waah mɔk binib pu na mɔmɔk, n‑yoonn mu u nan piin waatuln ");
INSERT INTO xon_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ki ti saa n‑yoonn mu Uwumbɔr di u buen paacham na. Waah nan bi dulnyaa wee ni na, le u lee waakpambalb. Uwumbɔr Aafuur Nyaan aapɔɔn pu le u nan tuk waakpambalb ngbaan baah ga ŋa pu na, le Uwumbɔr nin di u buen paacham. ");
INSERT INTO xon_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Waah kpo ki fikr nkun ni na, le u di ubaa mɔk bi n‑yoonn n‑yoonn, le ki ti saa iwiin imonko ilee, ki mɔk bi chain ke u sil kpa limɔfal. Binimbil nan kan u. Le u len bi chee, ki tuk bi Uwumbɔr aanaan aah bi pu na. ");
INSERT INTO xon_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Waah nan laa bi bi chee na, le u bui bi, “Ni taa nya Jerusalem ni. Ni li bi nima, ki ti saa bundaln Nte Uwumbɔr ga tii nimi Waafuur Nyaan, waah nan puu tipuur ti na. Ni nan ŋun tipuur ngbaan pu m chee la. ");
INSERT INTO xon_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mbamɔn, Jɔnn nan muin binib nnyun ni. Naan ki yunn, le m ga di Uwumbɔr Aafuur Nyaan gbiin nimi.” ");
INSERT INTO xon_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu aakpambalb aah kuun u chee na, le bi baa u, “Tidindaan, dandana wee, aa ga nyan timi Israel yaab timi aadim aaŋaal ni, ki ki giin timi aanaan tii timi ii?” ");
INSERT INTO xon_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Le Yesu tuk bi, “Bundaln Nte Uwumbɔr ga ŋa waah ban pu na, aa ye nimi aabɔr. Ti bi u chee la. ");
INSERT INTO xon_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Waafuur Nyaan yaa nan gbiin nimi kan, ni ga li kpa waapɔɔn, ki ga li ye maaseeraadam Jerusalem ponn ni, ni Judea aatim mɔmɔk ni, ni Samaria aatim ni, ni dulnyaa aanaan mɔmɔk ni.” ");
INSERT INTO xon_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Waah len kina na, le Uwumbɔr di u buen paacham, binimbil ni. Le ntaalangbam biin u pu. Baa ki waa u. ");
INSERT INTO xon_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Le bi beenin si lik waah cha paacham pu na. Libuul ngbaan ni, le bijab bilee nan sil bi chee, ki pee ŋikekepipiin, ");
INSERT INTO xon_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ki baa bi, “Galilee aanib, ba pu ni si lik paacham kina? Yesu, u Uwumbɔr nyan u ni chee buen paacham na, u ga gir ni. Ni kan waah buen pu na. Kina, le u ga nan ki gir ni.” ");
INSERT INTO xon_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","N‑yoonn ngbaan, Yesu aakpambalb nan bi lijool libaa paab, bi yin li ke Olif aasui aajool. Naa daa Jerusalem. Ni naahn limalgeln la. Le bi nyan nima, ki gir buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Baah ti fuu Jerusalem na, le bi koo baah koo kidiik ki ponn ni na. Kidiik ngbaan nan ye paacham aadiik la. Le Piita, ni Jɔnn, ni Jems, ni Andru, ni Filip, ni Tomas, ni Batolomiu, ni Matiu, ni Jems u ye Alfeus aajapɔɔn na, ni Simonn u nan ban u kuln waatiŋ aadim na, ni Judas u ye Jems aajapɔɔn na, mɔmɔk nan bi kidiik ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Le bi ni Mari u ye Yesu aana na, ni bipiib bibaa, ni Yesu aanaatiib, mɔmɔk kuuni tɔb chee, ki kpaani kimɔbaan, ki mee Uwumbɔr n‑yoonn mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","N‑yoonn ngbaan, le binib bi dii Yesu na nan kuun tɔb chee. Bi ga nan li fuu binib nkub ni moninko. Le Piita fii sil bikaasisik ni, ki bui bi, ");
INSERT INTO xon_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nnaabitiib, n‑yaayoonn na, Uwumbɔr Aafuur Nyaan nan cha Ubɔr David len Judas aabɔr. Ni ŋmee Uwumbɔr Aagbaŋ ponn ni. Naah ŋmee pu Uwumbɔr Aagbaŋ ponn ni na, see ni ŋa kina. Judas le nan mɔk binib Yesu aah bi nin chee na, le bi ti chuu u. ");
INSERT INTO xon_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas nan ye timi Yesu aakpambalb ponn ni ubaa la. Yesu nan nyan u, ke u tun Uwumbɔr aatuln ti chee.” ");
INSERT INTO xon_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","U ŋa tiwan ni kaa ŋan na, le ki kan ŋimombil, ki daa bukpaab. Le u lir kitiŋ bukpaab ngbaan ponn ni, ki kpo. Upuul nan puu, le tineer mɔmɔk nyan. ");
INSERT INTO xon_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Binib bimɔk bi Jerusalem na nan ŋun waabɔr. Nima pu na, baaliin ponn ni, bi yin bukpaab ngbaan ke Akeldama aakpaab. Naatataa le ye ke “Nsin aakpaab.” ");
INSERT INTO xon_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“N‑yaayoonn na, Ubɔr David nan ŋmee Judas aabɔr, Uwumbɔr aalahn aagbaŋ ponn ni ke, ‘Taa cha tiwan nibaa ki li bi waadichal ni. Taa cha unii ubaa ki li bi li ponn ni.’ U nan ki ŋmee Judas aabɔr ke, ‘Cha unii uken leŋ waaleleŋ.’” ");
INSERT INTO xon_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Piita nan ki len ke, “Nima pu na, ni ŋeer ke unii ubaa ki kpee ti pu, ki li ye seeraadaan, ki tuk binib ke Tidindaan Yesu fikr nkun ni. Ti ban unii u nan chuun ŋisachun ti ni Tidindaan Yesu chee, n‑yoonn mu Jɔnn nan muin Yesu nnyun ni na, ki ti saa bundaln Uwumbɔr nyan Yesu ti chee ki di u buen paacham na.” ");
INSERT INTO xon_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piita aah len kina na, le bi nyan bijab bilee. Bi yin ubaa ke Josef Basabas Justus ki yin uken ke Matias. ");
INSERT INTO xon_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Le bi mee Uwumbɔr ke, “Tidindaan, aa nyi binib mɔmɔk aasui ni aah bi pu na. Mɔk timi unii u aa lee u na bijab bilee ngbaan ponn ni aan u li ye saakpambal ki gaa lituln li Judas nan di cha ki buen nin chee ŋeer u na.” ");
INSERT INTO xon_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Baah mee Uwumbɔr doo na, le bi di ŋitakpabil tii bi, ke bi lik baah ga lee uja u na. Nimina nan mɔk bi ke bi ga lee Matias la. Le bi di u kpee Yesu aakpambalb kipiik ni ubaa na pu. ");
INSERT INTO xon_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Juu yaab aawinyaan mubaa nan saa. Bi yin mu ke Pentekost daal. Le binib bi dii Yesu na mɔmɔk bi kidiik kibaa ni. ");
INSERT INTO xon_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Libuul ngbaan ni, le bi ŋun kifuuk nyan ni kitaapaak. Ni nan bi ke libuln pɔpɔɔl aah kpa kifuuk pu na, ki nan gbiin lidichal li bi ka li ponn ni na. ");
INSERT INTO xon_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Le bi kan tiwan nibaa, ni bi ke imiigaal na, ki nan tɔŋ bi mɔmɔk aayil paab. ");
INSERT INTO xon_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Le Uwumbɔr Aafuur Nyaan gbiin bi mɔmɔk. Le bi len iliin yayan, Uwumbɔr Aafuur Nyaan aah cha bi len pu na. ");
INSERT INTO xon_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","N‑yoonn ngbaan le Juu yaab nan bi Jerusalem ni. Bi nan ye binib bi pak Uwumbɔr na, ki nyan ni ŋinibol mɔmɔk ponn ni dulnyaa wee ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Le bi ŋun Yesu aanib len iliin yayan. Le bi kuun ni nima, ki wiir. Le bi mɔmɔk ŋun bi len baaliin ibaabaa. Le ni muk bi nima chee, ki gar bi pam. ");
INSERT INTO xon_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Le bi bui ke, “Bijab bi len kina na mɔmɔk ye Galilee aatiŋ aanib la. ");
INSERT INTO xon_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bi ŋa kinye aan ki len timi aaliin aabɔŋ kina? Ti ŋun bi len ti mɔmɔk aaliin ibaabaa la. ");
INSERT INTO xon_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Timi bibaa nyan ni Patia aatiŋ ni, bibaa mu nyan ni Media aatiŋ ni, bibaa mu nyan ni Elam aatiŋ ni, bibaa mu nyan ni Mesopotamia aatiŋ ni, bibaa mu nyan ni Judea aatiŋ ni, bibaa mu nyan ni Kapadosia aatiŋ ni, bibaa mu nyan ni Pontus aatiŋ ni, bibaa mu nyan ni Asia aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bibaa mu nyan ni Frijia aatiŋ ni, bibaa mu nyan ni Pamfilia aatiŋ ni, bibaa mu nyan ni Ijipt aatiŋ ni, bibaa mu nyan ni Libia aatim mu bi Sairene aatiŋ chee na, bibaa nan ye Juu yaab, ni Biniyayam bi kpeln bibaa ki dii Juu yaab aasan na, ki nyan ni Rom aatiŋ ni na, ");
INSERT INTO xon_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","bibaa mu nyan ni Krete aatiŋ ni, bibaa mu nyan ni Arabia aatiŋ ni. Ti mɔmɔk ŋun bi len timi aaliin ki mooni Uwumbɔr aah tun lijinjiir aatun pu na.” ");
INSERT INTO xon_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Le ni gar bi mɔmɔk, ki cha bilan ŋmal. Le bi baa tɔb, “Naatataa ye kinye?” ");
INSERT INTO xon_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Le bibaa mu ŋani bi mbɔnyun ki bui ke bi nyun ndaan le ki gbii. ");
INSERT INTO xon_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Le Piita ni Yesu aakpambalb kipiik ni ubaa na fii sil. Le Piita len mpɔɔn pu, ki tuk kinipaak ngbaan, “Nnaabitiib, Juu yaab, ni nimi bimɔk bi Jerusalem ni na, ni li pel mbamɔm, ki ŋun maah ga len pu na. ");
INSERT INTO xon_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni dak ke binib ngbaan nyun ndaan gbii la. Baa nyun. Dandana, ni ye tikur tiwae kichakpiik ni la. Nima pu na, baa nyun ndaan. ");
INSERT INTO xon_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Baah len iliin yayan pu na, ni ye Uwumbɔr aabɔnabr Joel aah nan len pu na la. Joel nan len ke Uwumbɔr len ke: ");
INSERT INTO xon_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘N‑yoonn mu choo na, m ga di Maafuur Nyaan ŋa binib mɔmɔk pu. Nijapɔtiib ni nibisatiib ga nabr min Uwumbɔr aah len pu na. Nimi aanachipɔm ga kan lijinjiir aawan. Nimi aaninkpiib ga daŋ tidaŋ. ");
INSERT INTO xon_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","N‑yoonn ngbaan, m ga nan di Maafuur Nyaan ŋa maanaagbiijab ni maanaagbiipiib mu pu, le bi ga nabr maah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","M ga ŋa lijinjiir aatun kitaapaak ni, ni kitiŋ pu; nsin, ni mmii, ni iŋmanyuu ga li bi; ");
INSERT INTO xon_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","nwiin ga bɔln, le uŋmal mann ke nsin na, waahr aan Uwumbɔr aawiin daal nin fuu ni. Mu ga li ye nwiin sakpiin mu kpa liyimbil na. ");
INSERT INTO xon_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Liyaadaal ngbaan, unii umɔk mee Uwumbɔr na le ga ŋmar.’” ");
INSERT INTO xon_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tɔ, Piita ki len ke, “Israel yaab, li pel man. Uwumbɔr ban ke u mɔk binib ke uma le tun ni Yesu, u ye Nasaref aatiŋ aanii na. Nima pu le u cha u ŋani lijinjiir aatun, ni lituln li kpa liyimbil na, nimi ponn ni. Nimi nibaa nyi kina. ");
INSERT INTO xon_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Uwumbɔr aageehn pu le bi nan di Yesu ŋa niŋaal ni. Uwumbɔr nan nyi ke bi ga ŋa kina. Le ni di u ŋa mbiindam aaŋaal ni ke bi ti kpaa u ndɔpuinkoo pu, ki ku u. Nima pu na, nimi le ku u. ");
INSERT INTO xon_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Uwumbɔr le fikr u nkun ni ki bii nkun aapɔɔn, kaa cha nkun joo u. ");
INSERT INTO xon_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ubɔr David nan len Yesu aabɔr ke, ‘M nan kani Tidindaan m chee n‑yoonn mɔmɔk. U bi ŋŋangii wɔb, ki biin m pu, ke tiwan nibaa taa muk mi. ");
INSERT INTO xon_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nima pu na, m kpa mpopiin, ki len mpopiin aaliin, ");
INSERT INTO xon_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","le ki kpa limakl ke saan cha maawiin bee kitekpiitiŋ ni. M ye saabo u ye chain na, le saan cha maawon bur. Nima le m bi dulnyaa wee ni ki kpa nsuudoon. ");
INSERT INTO xon_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Aa nan mɔk mi limɔfal aasan. Saah bi m chee pu na, le m kpa mpopiin pam.’” ");
INSERT INTO xon_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Le Piita ki len ke, “Nnaabitiib, m ban m tuk nimi tiyaaja David aabɔr chain la. U nan kpo, le bi sub u. Din pu na, waakaakul bi do. ");
INSERT INTO xon_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","U nan ye Uwumbɔr aabɔnabr ubaa la, ki nyi ke Uwumbɔr puu tipuur ke u ga ŋa uma David uyaabil ubaa ubɔr, ke uma David aah ye ubɔr pu na. ");
INSERT INTO xon_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David nan nyi Uwumbɔr aah ga ŋa pu na. Nima pu na, u nan len ke Uwumbɔr ga nan fikr Kristo u gaa timi lii na nkun ni, kaan cha u bee kitekpiitiŋ ni. Waawon aa bur. ");
INSERT INTO xon_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Uwumbɔr fikr Yesu nkun ni. Tinimbil kan u, le ti tuk binib. ");
INSERT INTO xon_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Uwumbɔr nyuŋ Yesu, ki di u kaan uŋangii wɔb. U gaa Nfuur Nyaan Ute Uwumbɔr chee, uma Uwumbɔr aah nan puu tipuur ti ke u ga tii u na. Naah kan pu na, ni naah ŋun pu dandana wee na, ye Uwumbɔr Aafuur Nyaan le u di ŋa ti ni. ");
INSERT INTO xon_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David aa nan buen paacham. U mu nan len ke, ‘Uwumbɔr bui Ndindaan ke: Kal ŋŋangii wɔb, ");
INSERT INTO xon_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ki ti saa buyoonn m ga nyaŋ saadim mɔmɔk na.’” ");
INSERT INTO xon_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Le Piita ki len ke, “Israel yaab mɔmɔk, m ban ke ni sil bee ke ni ye Yesu aabɔr le m len. Nimi le kpaa u ndɔpuinkoo pu. Uwumbɔr le mɔk ke uma Yesu le ye Kristo u gaa timi lii na, ki ye Tidindaan.” ");
INSERT INTO xon_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kinipaak ngbaan aah ŋun Piita aah len pu na, le ni muk bi sakpen. Le bi baa Piita ni Yesu aakpambalb biken na, “Tinaabitiib, ti ga ŋa kinye?” ");
INSERT INTO xon_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Le Piita bui bi, “Ni mɔmɔk kpeln nimi aabimbin, ki cha ti muin nimi nnyun ni, Yesu Kristo aayimbil pu. Le Uwumbɔr ga di cha nimi aatunwanbir pinn nimi, ki tii nimi ipiin i ye Waafuur Nyaan na. ");
INSERT INTO xon_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tidindaan Uwumbɔr nan puu tipuur ke u ga di Waafuur Nyaan tii nimi, ni nimi aabim, ni binib bi bi ni daa na: u ga tii binib bi u ga yin bi na mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Le Piita di tibɔr ti wiir na tuk bi Yesu aabɔr, le ki sur bi ki bui bi, “Pɔɔn nibaa man ki ŋmar, ki nya ntafadaan mu ga pii titunwanbirdam ngbaan na ni.” ");
INSERT INTO xon_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Le bi muin binib bi gaa Piita aah len pu na nnyun ni. Liyaadaal ngbaan le binib ŋichur ŋitaa ŋmar, ki kpee bi pu. ");
INSERT INTO xon_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Binimbil nan man ke bi bae Yesu aabɔr, waakpambalb chee. Bi mɔmɔk nan kpaan kimɔbaan, ki ji tɔb chee tijikaar, ki kpaani tɔb chee ki mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Uwumbɔr nan cha Yesu aakpambalb tun lijinjiir aatun pam. Nima pu na, binib mɔmɔk nan san Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Le binib bimɔk gaa Yesu ki kii na kpaan tɔb chee, ki di baawan yakr tɔb. ");
INSERT INTO xon_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Binib nan kooh baah kpa tiwan ni na, ki di ŋimombil ngbaan yakr tɔb, baah ban pu na. ");
INSERT INTO xon_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Idaa mɔmɔk bi nan kuuni Uwumbɔr Aadichal ni, ki kpaani bido ki ji tijikaar, ki pak Uwumbɔr, ki kpa mpopiin, ni tibulchinn. Le binib mɔmɔk pak bi. Tidindaan nan joo binib bi ŋmar na kpae waanib pu idaa mɔmɔk la. ");
INSERT INTO xon_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Daalbaadaal, tikur titaa yoonn, Piita ni Jɔnn nan buen Uwumbɔr Aadichal ni. Ni nan ye limeel yoonn la. ");
INSERT INTO xon_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Uja ubaa nan bi nima ki ye uwɔb. Baah nan ma u na, u nan ye uwɔb la. Bi nan yoor u kaani Uwumbɔr Aadichal aabisamɔb chee idaa mɔmɔk. Bi yin mbisamɔb ngbaan ke “Mbisamɔb Nyaan.” Bi nan joo u kaani nima chee ke u li mee binib bi koo ni Uwumbɔr Aadichal ni na, ke bi tii u ŋimombil. ");
INSERT INTO xon_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Le u kan Piita ni Jɔnn bi koo Uwumbɔr Aadichal ni. Waah kan bi na, le u mee bi ke bi tii u tiwan. ");
INSERT INTO xon_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Le Piita ni Jɔnn lik u. Le Piita bui u, “Lik timi.” ");
INSERT INTO xon_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Le u lik bi, ki dak ke bi ga tii u tiwan la. ");
INSERT INTO xon_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Le Piita bui u, “Maa kpa ŋimombil. M ga tii si maah kpa ni na la. Yesu Kristo u ye Nasaref aatiŋ aanii na aayimbil pu, m tuk si la, fii chuun.” ");
INSERT INTO xon_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Le Piita chuu uŋangii, ki fiin u. Le u fii sil. Libuul ngbaan ni, le utaagben pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Le u fii yuk, ki sil utaa pu, ki piin ki chuun gonni, le ki dii bi, ki koo Uwumbɔr Aadichal ni, ki bi chuun, ki yukr, ki pak Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Le kinipaak mɔmɔk kan u bi chuun ki pak Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Le bi bee ke u ye uwanmeer u nan ka Uwumbɔr Aadichal aabisamɔb nyaan chee na. Waah pɔɔk na, le ni gar bi pam. ");
INSERT INTO xon_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Uja ngbaan aah laa joo Piita ni Jɔnn na, le binib ngbaan mɔmɔk san buen bi chee kikaakpaak kibaa ni, bi yin ki ke “Solomonn aakaakpaak.” Ni nan gar bi pam. ");
INSERT INTO xon_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tɔ, Piita aah kan bi na, le u baa bi, “Israel yaab, ba pu ni gar nimi? Ba pu ni lik timi kina? Ni dak ke ni ye tibaa aapɔɔn le cha uja wee pɔɔk aa? Ni dak ke ni ye timi aabimbin mu bi chain na pu uu? Ni mu aa ye kina. ");
INSERT INTO xon_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Uwumbɔr le cha u pɔɔk. Abraham, ni Aisak, ni Jakob Aawumbɔr, u ye tiyaajatiib Aawumbɔr na, nyuŋ Waabo Yesu la. Nimi le nan di Yesu kooh, le ki yii u Pailat chee. Pailat nan ban u di u lii, le naa kii. ");
INSERT INTO xon_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yesu le ye unii u Uwumbɔr nyan u aan u ye uninyaan na. Le ni yii u, ki bui Pailat ke u di unikur lii. ");
INSERT INTO xon_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ni ku Yesu u tii timi limɔfal na. Le Uwumbɔr fikr u nkun ni. Timi le ye waaseeraadam ke u fikr nkun ni a. ");
INSERT INTO xon_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ni kan uja wee, ki bee u. Yesu aayimbil le kpa mpɔɔn, le ki cha u pɔɔk. Waah ŋa Yesu aayimbil naadii pu na, nima le cha u pɔɔk. U gaa Yesu ki kii, le uma Yesu tii u laafee ninimbil ni. ");
INSERT INTO xon_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nnaabitiib, m nyi ke ni ni nimi aaninkpiib aah ku Yesu pu na, naa nyi naah tun lituln li na. ");
INSERT INTO xon_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","N‑yaayoonn na, Uwumbɔr nan cha waabɔnabtiib mɔmɔk len ke Waanii Kristo ga nan ji falaa. Baah len pu na, le Uwumbɔr cha ni ŋa kina. ");
INSERT INTO xon_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nima pu na, kpeln nimi aabimbin man, ki dii Uwumbɔr aasan. Ni yaa ŋa kina kan, Uwumbɔr ga di cha pinn nimi aatunwanbir, ki tii nimi lifuur, ");
INSERT INTO xon_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ki ki tun ni Yesu ni chee, aan ni ŋmar. Uma le ye Kristo, u Uwumbɔr nan puu tipuur ke u ga tii nimi na. ");
INSERT INTO xon_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Uma Yesu le ga li bi Uwumbɔr do ki ti saa n‑yoonn mu Uwumbɔr ga toor tiwan mɔmɔk na. N‑yaayoonn na, Uwumbɔr aabɔnabtiib bi bi chain na nan len tibɔr timina. ");
INSERT INTO xon_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Uwumbɔr aabɔnabr Moses nan len ke, ‘Nidindaan Uwumbɔr ga tun ni ubɔnabr ubaa ni chee, ke waah tun ni mi pu na. U mu ga li ye ninaabitiib ponn ni ubaa la. Li keei waah ga len tibɔr ti na mɔmɔk man. ");
INSERT INTO xon_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Unii umɔk kaa kii ubɔnabr ngbaan aah ga len pu na, Uwumbɔr ga yakr u, ki nyan ni u waanib ponn ni, ki ku u.’ ");
INSERT INTO xon_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Uwumbɔr aabɔnabtiib bimɔk nan len tibɔr na, Samuel ni bibɔnabr bi mu nan paan ni u pu na, mu nan len tibɔr timina. ");
INSERT INTO xon_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nimi le ye bibɔnabtiib ngbaan aayaabitiib. Uwumbɔr nan puu tipuur tii niyaajatiib. Nimi le yeh tipuur ngbaan. Uwumbɔr nan tuk Abraham ke u ga ŋa tinyoor ŋa ŋinibol ŋimɔk bi dulnyaa wee ni na pu, uma Abraham aayaabil pu. ");
INSERT INTO xon_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nima pu na, Uwumbɔr nan nyan Waabo, ki nan tun ni u ni chee njan, ke u nan ŋa nimi tinyoor; u cha ni di cha nimi aatunwanbir; tinyoor ngbaan le na.” ");
INSERT INTO xon_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Piita ni Jɔnn nan laa beenin len tibɔr kinipaak ngbaan chee, ki tuk bi ke Yesu fikr nkun ni a, ke waah fikr nkun ni na, binib bi kpo na mu ga nan fikr nkun ni. Le Uwumbɔr aatotoortiib, ni Uwumbɔr Aadichal aakikiirb aaninkpel, ni Sajusii yaab mu fuu ni nima, kaa gee Piita ni Jɔnn aah tuk kinipaak ngbaan pu na, ");
INSERT INTO xon_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","le ki gee liŋuul bi pu, ki chuu bi, ki di ŋa kiyondiik ni. Naah ye kijook na, le bi cha bi bi kiyondiik ni, ki ti woln kitaak. ");
INSERT INTO xon_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Binib bi ŋun Piita ni Jɔnn aah len pu na, bi ponn ni pam nan gaa Yesu ki kii. Bijab bi gaa u ki kii na ga nan li fuu ŋichur ŋiŋmu. ");
INSERT INTO xon_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Naah woln kitaak na, le Juu yaab aayidam, ni bibɔjirb aaninkpiib, ni Uwumbɔr aakaal aamɔmɔkb nan kuun Jerusalem ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bi ni Uwumbɔr aatotoorninkpel u bi yin u ke Anas na, ni Kayafas, ni Jɔnn, ni Aleksanda, ni utotoorninkpel do yaab biken, nan kuun tɔb chee. ");
INSERT INTO xon_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Le bi cha Piita ni Jɔnn sil binimbiin ni, le ki baa bi, “Ni ŋa kinye aan ki cha uwɔb ngbaan pɔɔk? Ni kpa ba aapɔɔn? Ni di ŋma aayimbil ki tii u laafee?” ");
INSERT INTO xon_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Le Uwumbɔr Aafuur Nyaan fir Piita pu. Le u bui bi, “Juu yaab aayidam, ni bibɔjirb aaninkpiib, ");
INSERT INTO xon_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","taah ter uwɔb ngbaan na, le ni ji timi tibɔr din, ki baa timi ke ti ŋa kinye ki cha u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","M ban ke nimi ni Juu yaab biken mɔmɔk bee ke Yesu Kristo, u ye Nasaref aatiŋ aanii na, waayimbil aapɔɔn le cha uja wee pɔɔk. Uma Yesu pu, le u kpa laafee mbamɔm, ki si ninimbiin ni. Nimi le kpaa Yesu ndɔpuinkoo pu, le Uwumbɔr fikr u nkun ni. ");
INSERT INTO xon_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu aabɔr ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Litakpal li bidimaab yii li na, lima le ye litakpajal.’ ");
INSERT INTO xon_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uma Yesu pu, le ti ga ŋmar. Uwumbɔr di Yesu aayimbil tii timi, ke ti ŋmar. Ubaa aa bi dulnyaa wee ni ki ga ŋmaa gaa timi lii, see Yesu baanja. Uma baanja pu, le ti ga ŋmar.” ");
INSERT INTO xon_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bininkpiib ngbaan nan bee ke Piita ni Jɔnn aa ye binib bi nyuun na, kaa bae mbaem, le ki kpa lipobil ki len. Baah kpa lipobil pu na, le ni gar bininkpiib ngbaan. Bi bee ke bi nan ye Yesu aajɔtiib la. ");
INSERT INTO xon_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bi kan uja u Piita ni Jɔnn cha u pɔɔk na si bi chee. Nima pu na, baa nan ki ŋmaa kpak bi. ");
INSERT INTO xon_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Le bi tuk bi ke bi nya kidiik ngbaan ni. Baah nyan kidiik ngbaan ni na, le bininkpiib ngbaan kpokl tɔb baah ga ŋa pu na, ");
INSERT INTO xon_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ki baa tɔb, “Ti ga ŋa bijab ngbaan kinye? Binib bimɔk bi Jerusalem ni na nyi ke bi tun lijinjiir aatuln li kpa liyimbil na. Taan ŋmaa nee. ");
INSERT INTO xon_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ti mu aa ban ke tibɔr ngbaan ki moon. Nima pu na, cha ti faan bijab ngbaan aan bi taa ki tuk binib Yesu aabɔr, ki taa ki pur waayimbil.” ");
INSERT INTO xon_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Le bi yin bi ke bi gir koo ni, le ki nan kpaa bi pu ke bi taa ki tuk binib Yesu aabɔr, ki taa ki pur waayimbil. ");
INSERT INTO xon_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Le Piita ni Jɔnn bui bi, “Ti yaa kii nimi aamɔb, bee ti yaa kii Uwumbɔr aamɔb le kan, nilani ŋan Uwumbɔr chee? Ni dakl ki lik. ");
INSERT INTO xon_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti ga li beenin tuk binib taah kan pu na, ni taah ŋun pu na. Taan ŋmaa yii.” ");
INSERT INTO xon_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Baah len kina na, le bininkpiib ngbaan ki faan bi, le ki di bi lii. Kinipaak ngbaan pu le baa ŋmaa daa bitafal. Kinipaak ngbaan mɔmɔk nan bi nyuŋni Uwumbɔr, lijinjiir aatuln ngbaan pu. ");
INSERT INTO xon_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Uja u bi cha u pɔɔk na nan jer ŋibin imonko ilee aanii. Nima pu le ni gar kinipaak ngbaan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Baah di Piita ni Jɔnn lii na, le bi gir buen bijɔtiib chee, ki ti tuk bi Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib aah tuk bi pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Baah ŋun kina na, le bi mɔmɔk kpaan kimɔbaan, ki mee Uwumbɔr, ki len ke, “Mpɔɔnsakpiindaan, sin le nan naan paacham, ni kitiŋ, ni nnyusakpem, ni tiwan nimɔk bi ni mɔmɔk ponn ni na. ");
INSERT INTO xon_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","N‑yaayoonn na, aa nan cha tiyaaja Ubɔr David len saabɔr. U nan ye saatutunn la. Saafuur Nyaan aapɔɔn pu le u nan len ke, ‘Binib bi kaa ye Juu yaab na gee liŋuul fam la. Ŋinibol mu dakl ilandak i kaa kpa tinyoor na. ");
INSERT INTO xon_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Dulnyaa wee ni aabɔrb gor bibaa, binib aayidam kuun tɔb chee, bi ti jan Uwumbɔr ni Waanii Kristo kijaak.’ ");
INSERT INTO xon_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tɔ, David aah nan len pu na, ni ye mbamɔn la. Ubɔr Herod, ni Pontius Pailat, ni Juu yaab, ni binib bi kaa ye Juu yaab na nan kuun kitiŋ kee ponn ni, ke bi nan ku Saatutunn Yesu u ye chain na. Uma le aa nyan ke u gaa timi lii. ");
INSERT INTO xon_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bi nan kuun bi ti ŋa saah nan len ke bi ga ŋa pu na. Saapɔɔn, ni saageehn pu, le aa nan siin ke bi ga ŋa kina. ");
INSERT INTO xon_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Uwumbɔr, lik baah faani timi nfaan pu na. Ter timi saatutum, ki tii timi lipobil, aan ti di tuk binib saabɔr. ");
INSERT INTO xon_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Di saapɔɔn tii bibum laafee. Cha ti tun lijinjiir aatun, ki mɔk binib ke Saabo Yesu u ye chain na aayimbil kpa mpɔɔn.” ");
INSERT INTO xon_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Baah mee Uwumbɔr doo na, le baah bi kidiik ki ponn ni na deŋ. Le Uwumbɔr Aafuur Nyaan gbiin bi mɔmɔk. Le bi kan lipobil, le ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Binib bimɔk nan gaa Yesu ki kii na nan kpaan kimɔbaan, ni nlandakbaan. Ubaa aa len ke waawan nibaa le ye uyaan. Le bi mɔmɔk yakr baawan mɔmɔk, ki di tii tɔb. ");
INSERT INTO xon_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Le Yesu aakpambalb kpa mpɔɔn ki jin seeraa ke Tidindaan Yesu sil fikr nkun ni. Le Uwumbɔr ter bi mɔmɔk sakpen. ");
INSERT INTO xon_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Binib nan kooh baah kpa tisar ni ŋidichal ŋi na, ki joo ni ŋimombil ŋi bi kan na, ki nan di tii Yesu aakpambalb. Le bi yakr tii bimɔk aah ban pu na. Ubaa aa ki bi bi ponn ni ki lann nibaa. ");
INSERT INTO xon_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Uja ubaa nan bi bi ponn ni, bi yin u ke Josef, le Yesu aakpambalb duln u ke Banabas. Naatataa le ye ke, “U sɔŋni binib aasui na”. U nan ye Liifai yaab aanii ubaa la. Bi nan ma u Saiprus aatiŋ ni la. ");
INSERT INTO xon_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","U nan kpa kisaak, ki kooh, ki di ŋimombil ŋi u kan na, ki nan tii Yesu aakpambalb. ");
INSERT INTO xon_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uja uken nan bi nima, bi nan yin u ke Ananias, ki yin upuu ke Safaira. U nan kpa kisaak, ki kooh ki, ki kan ŋimombil, ");
INSERT INTO xon_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ki di ngem nan tii Yesu aakpambalb, ki gur ubaa mu ngem. Upuu mu nan nyi waah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Le Piita baa u, “Ananias, ba ŋa aa cha kinimbɔŋ koo aasui ni, ki cha aa ban ke aa ŋmann Uwumbɔr Aafuur Nyaan, ki gur aabaa ŋimombil ngem? ");
INSERT INTO xon_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kisaak ngbaan aah nan bi aa chee na, ki nan ye siyaan la. Saah kooh ki na, ŋimombil ngbaan mu ye siyee la. Ba ŋa aa dak aasui ni ke aa ga ŋa kina? Saa mɔn nnyamɔn ki tuk binib baanja. Uwumbɔr le aa mɔn nnyamɔn tuk u.” ");
INSERT INTO xon_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias aah ŋun waah len pu na, le u kpo ki lir kitiŋ. Le ijawaan chuu binib bimɔk ŋun tibɔr ngbaan na. ");
INSERT INTO xon_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Le binachipɔm nan di likekeln poo u, ki yoor u nyan lipaal, ki ti di sub. ");
INSERT INTO xon_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ni nan kpee siib, le upuu mu koo ni, kaa nyi tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Le Piita baa u, “Naah kooh kisaak ngbaan na, ŋimombil ngbaan mɔmɔk le na aa?” Le u kii ke, “Een, ŋima le na.” ");
INSERT INTO xon_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Le Piita baa u, “Ba ŋa aa ni aachal mɔmɔk kpaan kimɔbaan ke ni ga tɔŋ Uwumbɔr Aafuur Nyaan? Lik, binachipɔm bi sub aachal na fuu ni mbisamɔb. Le bi ga yoor aa mu ki nya lipaal.” ");
INSERT INTO xon_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Libuul ngbaan ni, le u mu kpo, ki lir kitiŋ, unimbiin ni. Le binachipɔm ngbaan koo ni ki kan u kpo a. Le bi yoor u mu, ki ti di sub uchal chee. ");
INSERT INTO xon_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Le Yesu aanib mɔmɔk, ni binib bimɔk ŋun tibɔr ngbaan na san ijawaan sakpen. ");
INSERT INTO xon_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu aakpambalb nan tun lijinjiir aatun pam. Lijinjiir aatun ngbaan le mɔk binib ke Uwumbɔr bi bi chee. Le binib bimɔk gaa Yesu ki kii na kuun tɔb chee, Solomonn aakaakpaak ni, Uwumbɔr Aadichal ni. ");
INSERT INTO xon_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Binib bi kaa gaa Yesu ki kii na aa nan kaar ke bi li kpaani bi chee. Binib mɔmɔk mu nan pak bi. ");
INSERT INTO xon_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Binib pam nan gaa Tidindaan ki kii, ki kpae n‑yoonn mɔmɔk, ki kpaani bi chee. Bi nan ye bijab ni bipiib mu, ki wiir. ");
INSERT INTO xon_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yesu aakpambalb aah tun lijinjiir aatun pu na, le binib yoor bibum paan ikan pu, ni tiwandookaan pu, ki di kaan nsan ni, ki ban ke Piita yaa chuun jer kan, waajunjuŋ pinn jer bi pu, ki cha bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Le kinipaak mu nyan ni Jerusalem aatingbaan ni, ki joo ni bibum, ni binib bi tiyayaar joo bi na. Le Yesu aakpambalb cha bi mɔmɔk pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Le Uwumbɔr aatotoorninkpel, ni binib bimɔk dii u ki nan ye Sajusii yaab na, nan kpa lipiipoln Yesu aakpambalb pu, ");
INSERT INTO xon_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","le ki dan nan chuu bi, ki di laŋ kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kinyeek ngbaan le Uwumbɔr aatuun dan nan chuu piir kiyondiik aajaaleŋ, le ki nyan bi, ki bui bi, ");
INSERT INTO xon_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Li cha ti sil Uwumbɔr Aadichal ni, ki tuk binib limɔfal ngbaan aabɔr mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Le bi kii Uwumbɔr aatuun ngbaan aamɔb. Kichakpinaanyeek ni, le bi koo ni Uwumbɔr Aadichal ni, ki nan tuk binib limɔfal aabɔr na. Le Uwumbɔr aatotoorninkpel, ni binib bi dii u na dan nan yin bibɔjirb aaninkpiib, ni Juu yaab aaninkpiib mɔmɔk, le ki tun bikikiirb, ke bi buen kiyondiik ni ki ti li joo ni Yesu aakpambalb. ");
INSERT INTO xon_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Baah ti fuu nima kaa kan bi na, le bi labr ki nan tuk bibɔjirb aaninkpiib, ");
INSERT INTO xon_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ti fuu kiyondiik ni, ki kan ni lak mbamɔm. Bikikiirb mu si kii jaaleŋ mam chee. Le ti chuu piir kidiik, kaa kan unii ubaa ni ni.” ");
INSERT INTO xon_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uwumbɔr Aadichal aakikiirb aaninkpel, ni Uwumbɔr aatotoorninkpiib aah ŋun kina na, le ni muk bi pam. Baa ki nyi baah ga ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","N‑yoonn ngbaan le unii ubaa koo ni, ki nan bui bi, “Lik, bijab bi ni di ŋa kiyondiik ni na bi Uwumbɔr Aadichal ni, ki bi tuk binib Yesu aabɔr.” ");
INSERT INTO xon_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Le Uwumbɔr Aadichal aakikiirb ni baaninkpel buen ti joo ni Yesu aakpambalb ngbaan. Bi nan joo ni bi suuna, kaa chuu bi mpɔɔn; ba pu? bi san ijawaan ke kinipaak na ga mae bi ŋitakpal. ");
INSERT INTO xon_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Baah joo ni Yesu aakpambalb kidiik ponn ni na, le bi di bi siin bibɔjirb aaninkpiib aanimbiin ni. Le Uwumbɔr aatotoorninkpel bui bi, ");
INSERT INTO xon_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ti tuk nimi ke ni taa ki tuk binib Yesu aabɔr, ki taa ki pur waayimbil. Le ni beenin mooni waabɔr Jerusalem mɔmɔk ni, ki len ke waasin bi tiŋaal ni la.” ");
INSERT INTO xon_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Le Piita ni Yesu aakpambalb biken na bui bi, “Ni ye ke ti kii Uwumbɔr aamɔb la, naa ye binib aamɔb. ");
INSERT INTO xon_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nimi le kpaa Yesu ndɔpuinkoo pu, ki ku u. Le tiyaajatiib Aawumbɔr fikr u nkun ni, ");
INSERT INTO xon_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ki nyuŋ u, ki di u kaan uŋangii wɔb, u li ye timi Aayidaan u gaal timi lir, ki tii timi Israel yaab nsan ke ti kpeln timi aabimbin na, aan Uwumbɔr di cha timi aatunwanbir pinn timi. ");
INSERT INTO xon_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Timi ni Uwumbɔr Aafuur Nyaan le ye Yesu aaseeraadam ki tuk binib tibɔr ngbaan. U di Waafuur Nyaan tii binib bi kii waamɔb na.” ");
INSERT INTO xon_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bibɔjirb aaninkpiib aah ŋun baah len pu na, le bi gee liŋuul sakpen, ki ban bi ku bi. ");
INSERT INTO xon_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Le bibɔjirb aaninkpiib ponn ni ubaa fii sil binimbiin ni. Bi nan yin u ke Gamaliel. U nan ye Farisii yaab aanii ubaa la, ki mu ye Uwumbɔr aakaal aamɔmɔkb aaninkpel, ki kpa liyimbil Juu yaab mɔmɔk chee. Le u tuk bi ke bi di Yesu aakpambalb ngbaan nyan lipaal siib. ");
INSERT INTO xon_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Baah nyan lipaal na, le u bui bi, “Israel yaab, ni li nyi naah ga ŋa bijab ngbaan pu na. ");
INSERT INTO xon_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","N‑yaayoonn na, uja ubaa nan bi, bi yin u ke Tudas. U nan yoor ubaa ke uma le ye uninyuun, le bijab ikui inaa nan dii u. Binib nan ku u, le bijab bimɔk dii u na nan yaa, ki bee fam. ");
INSERT INTO xon_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Uja umina aayoonn aah jer na, le Galilee aatiŋ aanii ubaa nan yoor ubaa paacham, bi yin u ke Judas. U nan bi buyoonn bi nan chuun kahn binib na. Kinipaak nan dii u. Le bijab ku u mu. Waadidiliib bimɔk dii u na mu yaa. ");
INSERT INTO xon_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nima le m tuk nimi, nyan niŋaal bijab ngbaan aabɔr ni, ki taa ŋa bi nibaa. Baah kpokl pu na, ni baah tun lituln pu na, yaa ye binibɔm aatuln kan, li ga bee yɔli. ");
INSERT INTO xon_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ni yaa ye Uwumbɔr aatuln kan, naan ŋmaa nyaŋ bi. Ni yaa jan bi kijaak kan, ni li nyi man, nibaakan, ni ga kan ke ni jan Uwumbɔr le kijaak.” Bi nan kii Gamaliel aah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Le bi yin Yesu aakpambalb ngbaan, ke bi gir koo ni, le ki gbaa bi, ki tuk bi ke bi taa ki tuk binib Yesu aabɔr daalbaadaal, ki taa ki pur waayimbil, le ki di bi lii. ");
INSERT INTO xon_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Le Yesu aakpambalb ngbaan siir bi chee, ki nan kpa mpopiin; ba pu? Uwumbɔr pak bi ke bi ye binib bi ga ŋmaa ji inimɔɔn Yesu aayimbil pu na. ");
INSERT INTO xon_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Idaa mɔmɔk le bi chaa Uwumbɔr Aadichal ni, ni binib do, ki ti tuk binib Uwumbɔr aabɔr ki mooni tibɔnyaan tee, ke Yesu le ye Kristo u gaa binib lir na. ");
INSERT INTO xon_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Binib nan gaal Yesu ki keei idaa mɔmɔk ki kpae waadidiliib pu. N‑yoonn ngbaan le Juu yaab bi len Griik aaliin na ŋulni Juu yaab bi len Juu aaliin na pu, le ki bui ke baah yakr tijikaar idaa mɔmɔk na, bi sulni baakpopiib bɔr. ");
INSERT INTO xon_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Le Yesu aakpambalb kipiik ni bilee na yin Yesu aadidiliib mɔmɔk, ki nan bui bi, “Naa ŋan ti li yakr tijikaar ki di cha Uwumbɔr aaliin. ");
INSERT INTO xon_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nnaabitiib, nima pu na, ni nyan ni ponn ni bijab bilole bi gbiin Uwumbɔr Aafuur Nyaan, ki kpa nlan mbamɔm, ki kpa liyimbil na, ki cha bi li ye lituln ngbaan aaninkpiib. ");
INSERT INTO xon_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tima aanimbil ga li man limeel, ni Uwumbɔr aabɔr aamoon pu la.” ");
INSERT INTO xon_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yesu aakpambalb aah len pu na, le ni piir bi mɔmɔk aasui. Le bi nyan uja ubaa, bi yin u ke Stiifen, u gaa Yesu ki kii mbamɔm ki gbii Uwumbɔr Aafuur Nyaan na. Bi nan nyan Filip, ni Prokorus, ni Nikanor, ni Timonn, ni Pamenas, ni Nikolas, u nan ye Antiok aatiŋ aanii na mu. Nikolas aa nan ye Juu aanii. U nan kpeln le ki dii Juu yaab aasan. ");
INSERT INTO xon_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Le bi nyan bijab bilole bimina, ki cha bi sil Yesu aakpambalb aanimbiin ni. Le bi mee Uwumbɔr tii bi, ki di biŋaal paan bi pu. ");
INSERT INTO xon_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Le Uwumbɔr aabɔr nan mooni ŋipepel mɔmɔk. Le binib moo gaal Yesu ki keei, ki kpae waadidiliib pu ki wiir, Jerusalem ponn ni. Uwumbɔr aatotoorb pam mu nan gaa Yesu aabɔnyaan tee ki kii. ");
INSERT INTO xon_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Uwumbɔr nan ter Stiifen mbamɔm, ki tii u mpɔɔn sakpen, ki cha u tun lijinjiir aatun Juu yaab aakaasisik ni. ");
INSERT INTO xon_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Le Juu yaab bibaa fii ki kpak u. N‑yoonn mubaa, Juu yaab ngbaan nan ye binaagbiib, ki nan gaa bibaa. Bi nyan ni Sairene aatiŋ ni, ni Aleksandria aatiŋ ni, ni Silisia aatiŋ ni, ni Asia aatiŋ ni. Bijab ngbaan le kpak Stiifen kinikpakpak. ");
INSERT INTO xon_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Uwumbɔr Aafuur Nyaan aah tii Stiifen nlan sakpen pu na, baa ŋmaa len ki nyaŋ u. ");
INSERT INTO xon_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nima pu le bi tii bijab bibaa ŋimombil ke bi mɔln inyamɔn paan u. Le bijab ngbaan len ke bi ŋun u sii Moses ni Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Baah len pu na, le Juu yaab, ni baaninkpiib, ni Uwumbɔr aakaal aamɔmɔkb gee liŋuul Stiifen pu. Bi dan nan chuu u mpɔɔn, ki di u siin bibɔjirb aaninkpiib aanimbiin ni, ");
INSERT INTO xon_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","le ki joo ni binib bi ga mɔln inyamɔn paan u na. Le bi len ke, “N‑yoonn mɔmɔk uja wee bii Moses aakaal, ki seei Uwumbɔr Aadichal. ");
INSERT INTO xon_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ti ŋun u len ke Yesu, u ye Nasaref aatiŋ aanii na, ga gbaa wii Uwumbɔr Aadichal ngbaan, ki kpeln Moses aah nan tii timi ikaal i mɔmɔk na.” ");
INSERT INTO xon_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Le bibɔjirb aaninkpiib mɔmɔk lik Stiifen ki kan ke unimbil wɔb wiin chain ke Uwumbɔr aatuun aanimbil wɔb na. ");
INSERT INTO xon_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Uwumbɔr aatotoorninkpel nan baa Stiifen, “Baah len pu na, ti gbii ii?” ");
INSERT INTO xon_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Le Stiifen bui ke, “Ntetiib ni nnaabitiib, ni li pel man. Uwumbɔr u nyuun na nan dan tiyaaja Abraham chee. Waah nan dan u chee na, u nan laa bi Mesopotamia aatiŋ ni, kaa kee buen Harann aatiŋ ni, ke u ti kal nima. ");
INSERT INTO xon_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Le Uwumbɔr bui u, ‘Nya aado yaab aatiŋ ni, ni saanib chee, ki li cha maah ga mɔk si kitiŋ ki na ponn ni.’ ");
INSERT INTO xon_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nima pu le u fii Kaldii yaab aatiŋ ni, ki buen Harann aatiŋ ni, ki nan ti bi nima. Waah bi nima na, le ute kpo. Ute aah kpo na, le Uwumbɔr nyan u nima chee, ki di u dan taah bi kitiŋ ki ponn ni dandana wee na. ");
INSERT INTO xon_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","N‑yoonn ngbaan, Uwumbɔr aa nan tii u kitiŋ kibaa do chee na. Waa nan po tii u lisaŋ libaa. U nan puu tipuur tii u ke u ga di kitiŋ kee tii u ni uyaabitiib. N‑yoonn mu Uwumbɔr nan puu tipuur tee tii u na, Abraham aa nan kee kpa ubo. ");
INSERT INTO xon_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Le Uwumbɔr bui u, ‘Aayaabitiib ga li ye bicham kitiyayaŋ ponn ni. Kitiŋ ngbaan aanib ga di bi ŋa binaagbiib, ki ŋa bi bakaa ŋibin ikui inaa. ");
INSERT INTO xon_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kitiŋ ngbaan aanib aah ga di bi ŋa binaagbiib na, le m ga daa bitafal. N‑yoonn ngbaan le aayaabitiib ga nya kitiŋ ngbaan ni, ki dan kitiŋ kee ponn ni, ki nan li dooni mi do chee na.’ ");
INSERT INTO xon_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Le Uwumbɔr puu tipuur tii Abraham, ki tii u nkaal, ke u ni uyaabitiib mɔmɔk gii ŋichakpan, aan ni mɔk ke bi kii uma Uwumbɔr aah puu tipuur ti na. Le Abraham ma ubijabo, ki yin u ke Aisak, le ki gii uchakpaln, u nan laa ye iwiin iniin aabo la. Le Aisak ma waabo Jakob. Jakob mu ma japɔtiib kipiik ni bilee bi ye tiyaajaninkpiib na. Le bi mɔmɔk gii ŋichakpan. ");
INSERT INTO xon_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Le Jakob aajapɔtiib nan kpa lipiipoln binaal Josef pu, ki di u kooh binib pu, u li ye unaagbiija kitiŋ kibaa ponn ni, bi yin ki ke Ijipt. Le Uwumbɔr mu nan bi u chee, ");
INSERT INTO xon_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ki ter u, ki nyan u waafalaa mɔmɔk ponn ni. N‑yoonn ngbaan Faro nan ye Ijipt aatiŋ aabɔr. Le Uwumbɔr tii Josef nlan, ki cha Faro gee waabɔr. Le Faro di u ŋa kitiŋ ngbaan aayidaan, ni waachiln aayidaan. ");
INSERT INTO xon_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","N‑yoonn ngbaan le nkon lir Ijipt aatiŋ ni, ni Kanaann aatiŋ ni. Binib nan kan falaa sakpen. Tiyaajatiib nan bi Kanaann aatiŋ ni. Baa nan kan tijikaar. ");
INSERT INTO xon_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Le bite Jakob ŋun ke tijikaar bi Ijipt aatiŋ ni. Nima pu na, u nan cha ujapɔtiib buen nima chee bi ti daa tijikaar. Le bi buen ti daa, ki gir ni, ki ki buen lelee. ");
INSERT INTO xon_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Baah buen lelee na, le Josef ti di ubaa mɔk bi, le ki di waamaal mu mɔk Ubɔr Faro, ");
INSERT INTO xon_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","le ki tun bi ute Jakob chee, ke bi ti yin ni u ni waamaal mɔmɔk, bi dan u chee Ijipt aatiŋ ni. Bi nan ye binib imonko itaa ni kipiik ni biŋmu la. ");
INSERT INTO xon_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Le bi mɔmɔk buen u chee Ijipt aatiŋ ni, ki nan bi nima kina ki ti kpo. ");
INSERT INTO xon_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Baah kpo na, le bi yoor bi ki di dan Sekem aatiŋ ki bi do chee na ni, ki ti di bi sub. Bi nan sub bi nfal mu Abraham nan di ŋimombil daa Hamor yaab chee na ponn ni la. ");
INSERT INTO xon_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tɔ, Uwumbɔr nan puu tipuur tii Abraham. Le n‑yoonn mu u ga ŋa waah puu tipuur ti na peen ni. N‑yoonn ngbaan le Israel yaab too pɔr kpee Ijipt aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ni nan yunn pam, le ubɔrkpaan u kaa nan nyi Josef aabɔr na jin nnaan Ijipt aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Le u nan ŋmanni tiyaajatiib ki ŋani bi bakaa, le ki tuk waanib ke bi di tiyaajatiib aabim mee timoor ni aan bi kpo. ");
INSERT INTO xon_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","N‑yoonn ngbaan le bi ma Moses, u nan ye ubo u ŋan sakpen na la. Le bi kpiin u ute do iŋmal itaa. ");
INSERT INTO xon_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Waah ŋa iŋmal itaa aabo na, le bi di u bil timoor ni. Le Faro aabisal ti kan u, ki yoor u, ki kpiin u, ki di u ŋa waabo. ");
INSERT INTO xon_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Le bi mɔk u Ijipt yaab aalan aabɔŋ aabɔŋ. Le u kpaln unii u nyi tibɔr na, ki tun lituln li kpa liyimbil na. ");
INSERT INTO xon_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Waah ŋa ŋibin imonko ilee aaja na, u nan ban ke u mann unaabitiib Israel yaab. ");
INSERT INTO xon_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Le u mann bi, ki kan Ijipt aanii ubaa ŋa Israel aanii ubaa bakaa. Le u buen ti ter Israel yaab aanii ngbaan, ki gbaa Ijipt aanii ngbaan teen ki ku u. ");
INSERT INTO xon_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U nan dakl ke unaabitiib ga bee ke Uwumbɔr ga cha u nyan bi baadim aaŋaal ni. Le baa bee. ");
INSERT INTO xon_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Le ni woln le u ti kan Israel yaab bilee bi jaa. U nan ban ke u par bi, le ki bui bi, ‘Njɔtiib, ni ye naabitiib la. Ba ŋa ni ŋani tɔb bakaa?’ ");
INSERT INTO xon_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Le unii u ŋa uŋeen aatɔ bakaa na nan tur Moses foor bibaa chee, ki bui u, ‘Ŋma ŋa si timi aayidaan ni ubɔjir? ");
INSERT INTO xon_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aa ban ke aa ku mi ke saah fe ku Ijipt aaja na pu na la aa?’ ");
INSERT INTO xon_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Waah len kina na, le Moses san nyan Ijipt aatiŋ ni, ki buen Midiann aatiŋ ni, ki nan ti ye uchaan nima. Le upuu ma mbijabim bilee nima. ");
INSERT INTO xon_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ŋibin imonko ilee aah jer na, le Uwumbɔr aatuun di ubaa mɔk Moses. N‑yoonn ngbaan le Moses nan bi nteersakpiin ni, lijool li bi yin li ke Sainai na chee. Uwumbɔr aatuun ngbaan nan bi mmii ponn ni, busub bu bi ke bu aah gaal mmii le na pu. ");
INSERT INTO xon_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses aah kan ni na, le ni gar u pam. Le u foor mal mmii ngbaan u ti lik. Waah foor mal mu na, le u ŋun Uwumbɔr aaneel len ke, ");
INSERT INTO xon_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Min le ye aayaajatiib Abraham, ni Aisak, ni Jakob Aawumbɔr.’ Ijawaan chuu Moses, le uwon gbaa. Waa ki kaa u ki lik. ");
INSERT INTO xon_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Le Uwumbɔr bui u, ‘Saah si nin chee na ye kitiŋ ki bi chain na la. Chuu takl saanaatak ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","M kan maanib Israel yaab aah bi ji falaa sakpen Ijipt aatiŋ yaab aaŋaal ponn ni pu na, ki ŋun baah wii pu na, le m sunn ni ke m nan gaa bi lii. Li pel, m ga tun si Ijipt aatiŋ ni, aa ti nyan bi nima chee.’ ");
INSERT INTO xon_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Tɔ, Moses le ye unii u Israel yaab nan yii u, ki bui u ke, ‘Ŋma ŋa si timi aayidaan ni ubɔjir?’ Uma le Uwumbɔr nan tun waatuun u chee, busub bu bi ke bu aah gaal mmii le na pu, u ti tuk u ke u buen ti nyan ni waanib tinaagbiir ni, ki li joo ni bi. ");
INSERT INTO xon_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Uma Moses le nyan bi Ijipt aatiŋ ni, ki tun lijinjiir aatun nima chee, ni Limɔɔkal Aanyusakpem ni, le ki ti nin tun lijinjiir aatun timoor ni, ŋibin imonko ilee. ");
INSERT INTO xon_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Uma Moses le tuk Israel yaab, ‘Uwumbɔr ga tun ni ubɔnabr ubaa ni chee, ke waah tun ni mi pu na. U mu ga li ye ninaabitiib ponn ni ubaa la.’ ");
INSERT INTO xon_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uma Moses, ni tiyaajatiib, ni Uwumbɔr aatuun nan bi nteersakpiin ni, Sainai aajool chee, le Uwumbɔr aatuun len u chee tibɔr lijool ngbaan paab, ki tuk u limɔfal aabɔr ke u nan tuk timi. ");
INSERT INTO xon_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Le tiyaajatiib aa gee ke bi kii waamɔb. Bi yii u, ki ban ke bi ki labr buen Ijipt aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","le ki bui Moses aanaal Aaronn, ‘Maa ŋiwaa tii timi, ti li dii ŋi. Moses u nyan ni timi Ijipt aatiŋ ni na, taa ki nyi waah bi niwɔb na.’ ");
INSERT INTO xon_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","N‑yoonn ngbaan le bi di salmaa mɔɔ unaabo, le ki toor kitork tii u. Baah mɔɔ unaabo ngbaan na, le bi jin njim ki mɔɔni sakpen. ");
INSERT INTO xon_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Le Uwumbɔr daak bi chee, le ki siir cha bi, le bi dooni ŋiŋmabil ŋi bi kitaapaak na. Uwumbɔr aabɔnabr nan ŋmee tibɔr ngbaan Uwumbɔr Aagbaŋ ponn ni, ke Uwumbɔr len ke, ‘Israel yaab, ni nan kɔr tiwakor ki toor kitork ŋibin imonko ilee timoor ni. Naah toor kitork na, ni toor tii min aa? Aayii. ");
INSERT INTO xon_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ni nan yoor liwaal li bi yin li ke Molek na aabool, ni liwaal Refann li ye liŋmabil aanaŋ na. Ni nan mɔɔ ŋiwaa ŋimina, ke ni li dooni ŋi. Nima pu na, m ga di nimi buen tinaagbiir ni, kitiŋ ki bi Babiloŋ aatiŋ aapuwɔb na ni.’ ");
INSERT INTO xon_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tɔ, tiyaajatiib nan joo ngban aabool timoor ni. Uwumbɔr nan joo ubaa mɔk bi libool ngbaan ponn ni la. U nan tuk Moses waah ga ŋa pu ki ŋa libool ngbaan na. Le Moses ŋa li Uwumbɔr aah mɔk u pu na. ");
INSERT INTO xon_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tiyaajatiib nan di libool ngbaan tii baabim. Baabim ni baayidaan Josua mu nan yoor libool ngbaan, le ki buen bi ti gaa kitiŋ ki Uwumbɔr jenn binib nima na. Le libool ngbaan nan bi nima, ki ti saa Ubɔr David aayoonn. ");
INSERT INTO xon_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uwumbɔr nan gee Ubɔr David. Le David nan ban ke u maa lidichal tii Uwumbɔr, u nan ye uyaaja Jakob Aawumbɔr na. David mu aa nan maa lidichal tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ujapɔɔn Solomonn le nan maa lidichal tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Tɔ, Uwumbɔr u kaa kpa ŋeen aatɔ na aa bi binib aah maa ŋidichal ŋi na ponn ni baanja. Uwumbɔr aabɔnabr nan len ke Uwumbɔr len ke, ");
INSERT INTO xon_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kitaapaak le ye maabɔrjal, le kitiŋ ye ntaa aah taa ni pu na: ni ga maa ba aadichal aaboln ki tii mi? Ba aapaan ni ga kan tii mi aan m li koo nima? ");
INSERT INTO xon_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Min mbaa le nan naan tiwan nimina mɔmɔk.’” ");
INSERT INTO xon_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tɔ, Stiifen nan ki len ke, “Nitafal pɔɔ, naa dii Uwumbɔr aasan nisui ni, kaa pel waaliin. N‑yoonn mɔmɔk ni ban ni yii Uwumbɔr Aafuur Nyaan, ke niyaajatiib aah nan yii mu pu na. ");
INSERT INTO xon_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Niyaajatiib nan muk Uwumbɔr aabɔnabtiib mɔmɔk, le ki ku binib bi tuk bi ke Uwumbɔr Aatutunyaan ga dan na. U fuu ni, le ni kooh u, ki ku u. ");
INSERT INTO xon_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Uwumbɔr nan tun ni waatuuntiib bi nan tii nimi waakaal. Le ni yii, kaa kii nkaal ngbaan.” ");
INSERT INTO xon_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stiifen aah len kina na, le liŋuul chuu binib ngbaan, le bi ŋmɔ ŋinyin. ");
INSERT INTO xon_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Le Stiifen u Uwumbɔr Aafuur Nyaan gbii u na, waan lik paacham, le ki kan Uwumbɔr aah wiin chain pu na, le ki kan Yesu si uŋangii wɔb. ");
INSERT INTO xon_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Le u bui ke, “Lik, m kan kitaapaak chuu piir, ki kan Unibɔn Aabo na si Uwumbɔr aaŋangii wɔb.” ");
INSERT INTO xon_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Waah len kina na, le bi teen mpɔɔn pu, ki di biŋaal ŋeeb bitafal, le ki kpaan ber bi ti chuu u, ");
INSERT INTO xon_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ki nyan u kitiŋ ponn ni, ki di buen n‑gbaan, ki ti mae u ŋitakpal. Le biseeraadam ngbaan chuu peer baabɔkul, ki di bil unachipɔɔn ubaa chee, bi yin u ke Sɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Le bi mae Stiifen ŋitakpal u ti kpo. Baah bi mae u ŋitakpal na, le u mee Tidindaan ke, “Tidindaan Yesu, gaa maawiin,” ");
INSERT INTO xon_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","le ki gbaan utaaŋaayil pu, le ki teen mpɔɔn pu, “Tidindaan, taa teen bi baah ŋa bakaa u na.” Waah len kina na, le u kpo. ");
INSERT INTO xon_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Baah ku u pu na, le Sɔɔl kii. Liyaadaal ngbaan le bi piin ki bi muk Yesu aanib bi bi Jerusalem ni na, ki ŋa bi falaa sakpen. Nima pu na, bi mɔmɔk nan yaa, ki buen Judea ni Samaria aatim mɔmɔk ponn ni. Yesu aakpambalb baanja le nan gur Jerusalem ponn ni, kaa yaa. ");
INSERT INTO xon_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Le bijab bi san Uwumbɔr na sub Stiifen ki wii mpɔpɔɔn pu. ");
INSERT INTO xon_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Le Sɔɔl pɔɔn ubaa, u ti bii Yesu aanib ki ŋa bi fam. U nan koo ŋidichal ŋidichal ponn ni ki ban bi, ki chuu nyan bijab ni bipiib mpɔɔn, ki ti di ŋa kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tɔ, binib bi dii Yesu na nan yaa koo ntim mɔmɔk ni, le ki tuk binib waabɔnyaan. ");
INSERT INTO xon_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Le Filip buen Samaria aatiŋ ni ki ti tuk binib Kristo u gaa binib lii na aabɔr, ");
INSERT INTO xon_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ki tun lijinjiir aatun. Baah kan lijinjiir aatun ngbaan ki ŋun waah len pu na, le kinipaak pel waabɔr ngbaan mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","U nan nyan tiyayaar binib pam ponn ni, le ti teen mpɔɔn pu, ki nyan biwon ni. Le binib bi aawon faan na, ni biwɔb mu pam kan laafee. ");
INSERT INTO xon_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nima pu le Samaria aatiŋ aanib nan kpa mpopiin sakpen. ");
INSERT INTO xon_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Le uja ubaa nan bi nima bi nan yin u ke Simonn; u nan ye ubɔɔ la, ki tun lijinjiir aatun ŋi gar Samaria aatiŋ aanib na pam, le ki yoor ubaa ke uma le ye uninyuun. ");
INSERT INTO xon_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Le binib mɔmɔk, bigiim ni bipɔɔndam kii tii u, ki len ke u kpa Uwumbɔr aapɔɔn, ki yin u ke Mpɔɔn Sakpiindaan. ");
INSERT INTO xon_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","U nan tun inyɔk aatun ni yunn, ki cha ni gar binib pam. Nima pu na, bi nan kii tii u. ");
INSERT INTO xon_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Le Filip dan nan tuk bi Uwumbɔr aanaan aabɔnyaan, ni Yesu Kristo aabɔnyaan ngbaan. Le bi kii waah len pu na. Baah kii waah len pu na, le u muin bi nnyun ni, bijab ni bipiib mɔk. ");
INSERT INTO xon_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Le Simonn, u ye ubɔɔ ngbaan na, mu kii Filip aah len pu na. Le Filip muin u nnyun ni. Le u dii Filip idaa mɔmɔk, ki kan u tun lijinjiir aatun pam. Le ni gar u ki ti nyaŋ. ");
INSERT INTO xon_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Le Yesu aakpambalb bi bi Jerusalem ni na ŋun ke Samaria aatiŋ aanib gaa Uwumbɔr aaliin. Baah ŋun kina na, le bi cha Piita ni Jɔnn buen bi chee. ");
INSERT INTO xon_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Le Piita ni Jɔnn ti fuu nima, ki mee Uwumbɔr tii binib bi gaa Uwumbɔr aaliin na, ke u tii bi Waafuur Nyaan. ");
INSERT INTO xon_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Waafuur Nyaan aa nan kee sunn ni bi ponn ni ubaa pu. Filip nan muin bi nnyun ni baanja, Tidindaan Yesu aayimbil pu la. ");
INSERT INTO xon_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nima pu na, Piita ni Jɔnn nan mee Uwumbɔr tii bi, le ki di biŋaal paan bi pu. Baah ŋa kina na, le Uwumbɔr Aafuur Nyaan gbiin binib ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Le Simonn kan ke Yesu aakpambalb aah di biŋaal paan binib pu na, Uwumbɔr tii binib ngbaan Waafuur Nyaan. Waah kan kina na, le u ban ke u pa bi ŋimombil, ");
INSERT INTO xon_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bi tii u mpɔɔn mumina, ke u yaa di uŋaal paan binib pu kan, bi ga kan Uwumbɔr Aafuur Nyaan. ");
INSERT INTO xon_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Le Piita baa u, “Aa dak ke aa ga ŋmaa di ŋimombil daa Uwumbɔr aapiin aa? Saah dak pu na, naa ŋan. Aa ni saamombil bee fam. ");
INSERT INTO xon_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aasui aa ŋan Uwumbɔr chee. Aaŋaal aa bi waabɔnyaan ni. ");
INSERT INTO xon_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kpeln aapobil, ki di cha saatunwanbir ngbaan, ki mee Uwumbɔr ke u di cha saalandakbir pinn si. ");
INSERT INTO xon_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","M kan ke aasui to sakpen a. Titunwanbir le joo si.” ");
INSERT INTO xon_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Le Simonn bui Piita ni Jɔnn, “Mee Uwumbɔr tii mi, aan saah len tibɔr ti na, ti taa pii mi.” ");
INSERT INTO xon_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tɔ, Piita ni Jɔnn nan tuk Samaria aatiŋ aanib Tidindaan aabɔr, ki sur bi mbamɔm, le ki nin gir buen Jerusalem. Baah chuun ki cha na, le bi bɔ dii Samaria aatim pam ponn ni, ki tuk binib Yesu aabɔnyaan. ");
INSERT INTO xon_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","N‑yoonn ngbaan le Uwumbɔr aatuun tuk Filip ke u gor ki dii ŋŋangii wɔb, ki dii timoor ni aasan mu nyan Jerusalem ki cha Gasa aatiŋ ni na. Dandana wee, nsan ngbaan ŋa nsankpok a. ");
INSERT INTO xon_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Le Filip fii ki cha. Uja ubaa nan ka itaan aah dar tɔroku sakpiin u na ponn ni, nsan ni. U nan ye Itiopia aatiŋ aanii la, ki mu ye unii u bi lee nyan ŋikookpimbil na, ki mu ye uninyuun la. Uma le nan lik Itiopia aatiŋ aamombil mɔmɔk, ki kpa mpɔɔn sakpen, ki tun lituln tii Itiopia aabɔrpii, u bi yin u ke Kandake na. Uja ngbaan nan dan Jerusalem u nan doon Uwumbɔr, ki labr cha, ki laa beenin bi nsan ni. Filip aah kan u na, u nan bi waatɔroku sakpiin ponn ni, ki karni kigbaŋ ki Uwumbɔr aabɔnabr Aisaya nan ŋmee ki na. ");
INSERT INTO xon_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Le Uwumbɔr Aafuur Nyaan tuk Filip ke u li cha tɔroku ngbaan chee. ");
INSERT INTO xon_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Le Filip san buen u chee ki ti ŋun u bi karni kigbaŋ ki Uwumbɔr aabɔnabr Aisaya nan ŋmee ki na. Le Filip baa u, “Saah bi karni kigbaŋ ki na, aa bee naatataa aa?” ");
INSERT INTO xon_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Le u bui ke, “Unii yaa kaa mɔk mi kan, m ga ŋa kinye ki bee?” le ki tuk Filip ke u koo ni u chee ki nan kal tɔroku na ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tɔ, waah bi karni Uwumbɔr Aagbaŋ ponn ni nin chee na ŋmee ke, “Bi yaa chuu upiih bi ti kɔr u kan, waa wii. Bi yaa chee upihbo aakokor pu kan, u mu aa wii. U mu bi kina la. Baah chuu u mpɔɔn pu na, waa len tibaa ke u nyan ubaa tibɔr ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bi nan di u ŋa bibɔjirb chee, ki mɔln inyamɔn paan u, ki jinn u inimɔɔn. Bi nan ku u, le unii ubaa aan ŋmaa len uyaabitiib pu.” ");
INSERT INTO xon_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tɔ, le uja ngbaan baa Filip, “Uwumbɔr aabɔnabr aah nan len pu na, u len ŋma aabɔr? U len ubaa aabɔr le aan u len uken aabɔr la?” ");
INSERT INTO xon_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Le Filip tuk u ŋŋmeen ngbaan aatataa, ke ni ye Yesu aabɔr la, le ki tuk u tibɔnyaan na. ");
INSERT INTO xon_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Baah bi tɔroku na ponn ni ki cha na, le bi ti fuu nkpen mubaa ni, le ki kan nnyun dɔ. Le uja ngbaan bui Filip, “Lik, nnyun sɔ. Aa ga ŋmaa muin mi nnyun ni dandana wee ee?”  ");
INSERT INTO xon_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Le Filip bui u, “Aa yaa gaa Yesu ki kii mbamɔm kan, m ga ŋmaa muin si nnyun ni.” Le u bui u, “M pak ke Yesu Kristo ye Uwumbɔr Aajapɔɔn la.” ");
INSERT INTO xon_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Le u cha waatɔroku sil. Le u ni Filip mɔmɔk bilee sunn sil ni kitiŋ, ki koo nnyun ni. Le Filip muin u nnyun ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Le bi nyan ni nnyun ni. Baah nyan ni nnyun ni na, le Uwumbɔr Aafuur Nyaan yoor Filip, ki di u buen. Uja ngbaan aa ki kan u. Le u ki koo waatɔroku ponn ni, ki cha, ki nan kpa mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Binib nan kan Filip kitiŋ kibaa ni, bi yin ki ke Asotus. Le u bɔ dii ntim mɔmɔk ni, nima chee, ki tuk binib Yesu aabɔnyaan, le ki ti fuu Siisarea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Sɔɔl ma nan beenin kpa liŋuul Tidindaan aadidiliib pu, ki ban ke u chuu bi ki ku bi. U nan ban ke u buen Damaskus aatiŋ ni, ki ti ban bi, bijab ni bipiib mɔmɔk, ki chuu bi mpɔɔn, ki di tikululn buu bi, ki di gir dan Jerusalem. Le u buen Uwumbɔr aatotoorninkpel chee, ke u ŋmee kigbaŋ tii u. U yaa ti fuu Damaskus aatiŋ ni kan, u ga di kigbaŋ ngbaan mɔk mmeen aadir aaninkpiib, ke bi cha u chuu binib bi dii Yesu aasan na. ");
INSERT INTO xon_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tɔ, le u siir ki cha. Waah laa bi nsan ni ki ti peen Damaskus aatiŋ ni na, libuul ngbaan ni le nwiihn nyan ni paacham, ki woln ki mann gonn u. ");
INSERT INTO xon_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Le u lir kitiŋ, ki ŋun nneel len ke, “Sɔɔl, Sɔɔl, ba ŋa aa ŋani mi falaa?” ");
INSERT INTO xon_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Le Sɔɔl baa u, “Ndindaan, ŋma ye?” Le u bui u, “Min le ye Yesu, u aa ŋa u falaa na. ");
INSERT INTO xon_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fii sil, ki li cha kitiŋ ngbaan ni. Aa yaa ti fuu kan, bi ga tuk si saah ga ŋa pu na.” ");
INSERT INTO xon_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Binib bi nan dii Sɔɔl na si ŋmin, kaa ŋmaa len tibaa. Bi ŋun nneel len, kaa waa unii. ");
INSERT INTO xon_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Le Sɔɔl fii sil, ki likr unimbil, kaa ki waa. Le bi chuu uŋaal, ki dar u cha Damaskus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Waa nan waa ki ti saa iwiin itaa, kaa ki ji, kaa ki nyu mu. ");
INSERT INTO xon_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Le Yesu aadidiir ubaa nan bi Damaskus aatiŋ ni, bi nan yin u ke Ananias. Le Tidindaan len u chee tidaŋ ponn ni, ki bui u, “Ananias.” Le u bui ke, “Ndindaan, m sɔ.” ");
INSERT INTO xon_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Le Tidindaan bui u, “Fiin, ki li cha nsan mu bi yin mu ke Nsan Mu Tok na ni, ki li cha Judas do, ki li ban uja u bi yin u ke Sɔɔl, aan u ye Tasus aatiŋ aanii na. U bi mee Uwumbɔr, ");
INSERT INTO xon_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","le ki daŋ tidaŋ ki kan uja u bi yin u ke Ananias na koo ni u chee, ki nan di uŋaal paan u pu, ke unimbil ki likr.” ");
INSERT INTO xon_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Le Ananias bui ke, “Ndindaan, binib pam tuk mi uja ngbaan aabɔr, ke u ŋani saanib bakaa sakpen Jerusalem ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","U fuu ni do, ki kpa nsan mu Uwumbɔr aatotoorninkpiib tii u ke u chuu saanib mɔmɔk, ki buu bi tikululn na.” ");
INSERT INTO xon_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Le Tidindaan bui u, “Li cha u chee. M nyan u la, u ti li joo maabɔr tuk bibɔrb, ni Juu yaab, ni binib bi kaa ye Juu yaab na, ki cha bi bee mbɔr. ");
INSERT INTO xon_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Min mbaa ga mɔk u waah ga ji falaa u mɔmɔk maayimbil pu na.” ");
INSERT INTO xon_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Le Ananias fii ki buen Judas do, ki ti koo Sɔɔl chee, ki di uŋaal paan u pu, le ki bui u, “Nna aabo Sɔɔl, Tidindaan le tun ni mi aa chee. Yesu u di ubaa mɔk si, saah bi nsan ponn ni ki choo na, uma le tun ni mi, ke m cha aa ki likr, ki gbiin Uwumbɔr Aafuur Nyaan.” ");
INSERT INTO xon_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Waah len kina na, libuul ngbaan ni le tiwan ni naahn tijanpɔkr na nyan Sɔɔl aanimbil ni. Le unimbil ki likr, le u fii sil. Le bi muin u nnyun ni. ");
INSERT INTO xon_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Le u jin tijikaar, ki ki kan mpɔɔn. Sɔɔl nan laa bi Yesu aadidiliib chee iwiin ilee, Damaskus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Libuul ngbaan ni le u koo mmeen aadir ni, ki ti tuk binib Yesu aabɔr, ke u ye Uwumbɔr Aajapɔɔn la. ");
INSERT INTO xon_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Le ni gar binib bimɔk ŋun waah len pu na. Le bi baa tɔb, “Naa ye uja ngbaan le nan ŋa Yesu aanib falaa Jerusalem ponn ni ii? U dan do, ke u nan chuu bi, ki di tikululn buu bi, ki di bi buen Jerusalem, ki ti di bi ŋa Uwumbɔr aatotoorninkpiib aaŋaal ni.” ");
INSERT INTO xon_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sɔɔl nan moo kani mpɔɔn u di tuk binib Yesu aabɔr, le ki len ki nyaŋ Juu yaab bi bi Damaskus aatiŋ ni na, ki mɔk bi ke Yesu sil ye Kristo u gaa binib lii na. ");
INSERT INTO xon_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ni nan ŋa iwiin ilee, le Juu yaab kuun tɔb, ki kpokl baah ga ŋa pu ki ku Sɔɔl na. ");
INSERT INTO xon_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Idaa mɔmɔk, kinyeek ni nwiin pu, le bi ka kii kitiŋ ngbaan aagoln aabisamɔb chee, ke Sɔɔl yaa nan nyan ni kan, bi chuu u ki ti ku u. Le Sɔɔl ŋun baah kpokl pu na. ");
INSERT INTO xon_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kitiŋ ngbaan aagoln nan kpa takolu mam. Le Sɔɔl aadidiliib yoor u ŋa kibɔɔkuuk sakpeŋ ponn ni, ki di u dii takolu nyan. ");
INSERT INTO xon_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Le Sɔɔl buen Jerusalem. Waah ti fuu nima na, le u ban u kpaan Yesu aadidiliib chee. Le bi san u ijawaan, kaa pak ke u ye Yesu aadidiir ubaa. ");
INSERT INTO xon_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Le Banabas dan nan di u buen Yesu aakpambalb chee, ki ti tuk bi ke Sɔɔl nan kan Tidindaan nsan ni, ke Tidindaan nan len u chee, ke Sɔɔl nan kpa lipobil ki di Yesu aabɔr tuk binib bi bi Damaskus aatiŋ ni na. ");
INSERT INTO xon_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas aah tuk bi kina na, le bi cha Sɔɔl kpaan bi chee. Le u dii bi baah cha nin chee na Jerusalem ponn ni, ki kpa lipobil u tuk binib Tidindaan aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","N‑yoonn, n‑yoonn le u ni Juu yaab bi len Griik aaliin na kpak tɔb kinikpakpak, le bi ban bi ku u. ");
INSERT INTO xon_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Le Yesu aanib ŋun ke bi ban bi ku u. Baah ŋun kina na, le bi yoor u buen Siisarea aatiŋ ni, ki cha u kun Tasus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nima pu na, Yesu aanib bi nan bi Judea aatim ni, ni Galilee aatim ni, ni Samaria aatim ni na nan gaa bibaa. Unii ubaa aa ki muk bi. Le bi moo bae Tidindaan aaliin n‑yoonn mɔmɔk, ki pak u. Le Uwumbɔr Aafuur Nyaan ter bi, ki cha binib moo kpee bi pu. ");
INSERT INTO xon_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tɔ, Piita nan bɔ dii ntim mɔmɔk ponn ni nima chee. U nan buen Lida aatiŋ mu ni, ki mann Uwumbɔr aanib bi bi nima na. ");
INSERT INTO xon_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Waah bi nima na, le u kan uja ubaa, bi yin u ke Eneas, u nan ye uja u aawon faan na la. Ŋibin ŋiniin u po dɔ kidiik ni la, kaa ŋmaa fii. ");
INSERT INTO xon_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Le Piita bui u, “Eneas, Yesu Kristo tii si laafee dandana wee. Fii sil, ki kpab saawandookaan.” Libuul ngbaan ni, le u kpaan fii sil. ");
INSERT INTO xon_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Le binib bimɔk bi Lida aatiŋ ni, ni Saronn aatiŋ ni na kan u, ki kpeln baabimbin, ki dii Tidindaan aasan. ");
INSERT INTO xon_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kitiŋ kibaa mu bi, ki bi gbɔk nima chee, bi yin ki ke Jɔpa. Upii u dii Yesu aasan na nan bi nima, bi yin u ke Tabita. Griik aaliin ponn ni, bi yin u ke Dokas. Waayimbil aatataa le ye ke upeeyun. U nan ye litunyaandaan la. ");
INSERT INTO xon_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","N‑yoonn ngbaan le u buŋ, ki kpo. Le bi fu linikpol ngbaan nnyun, ki di u ti bil paacham aadiik ni. ");
INSERT INTO xon_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jɔpa aatiŋ, ni Lida aatiŋ aa daa tɔb. Le Yesu aadidiliib bi bi Jɔpa aatiŋ ni na ŋun ke Piita bi Lida aatiŋ ni. Le bi tun bijab bilee, ke bi ti yin ni Piita, ke u pɔɔn ubaa ki dan mala. ");
INSERT INTO xon_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Le Piita fii dii bi. Waah ti fuu ni nima na, le bi di u buen paacham aadiik ngbaan ni. Le bikpopiib kuun nima, ki si Piita chee, ki wii, le ki mɔk u ŋibɔkul ŋi Dokas nan ŋa tii bi, waah nan bi na. ");
INSERT INTO xon_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Le Piita jenn nyan bi mɔmɔk kidiik ngbaan ni, le ki gbaan utaaŋaayil pu, ki mee Uwumbɔr, le ki lik linikpol ngbaan ki len ke, “Tabita, fii sil.” Le u likr unimbil. Waah kan Piita na, le u fii kal. ");
INSERT INTO xon_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Le Piita chuu uŋaal, ki ter u, u fii sil, le ki yin Uwumbɔr aanib ni bikpopiib ngbaan, ki di u mɔk bi, ke u fikr a. ");
INSERT INTO xon_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Le binib bimɔk bi Jɔpa aatiŋ ni na ŋun tibɔr ngbaan. Nima pu na, binib pam nan gaa Tidindaan ki kii. ");
INSERT INTO xon_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piita nan bi Jɔpa aatiŋ ni, ki yunn. U nan koo uja u bi yin u ke Simonn, aan u ye ugbanjab na do la. ");
INSERT INTO xon_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tɔ, uja ubaa nan bi Siisarea aatiŋ ni, bi nan yin u ke Konelius. U nan ye butɔb aajab nkub aaninkpel la. Bi yin butɔb aajab ngbaan ke “Itali aatiŋ aajab.” ");
INSERT INTO xon_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konelius nan ye uninyaan la. U ni waachiln ni aanib mɔmɔk pak Uwumbɔr. U nan ŋani Juu yaab aagiim tiŋann sakpen, ki mee Uwumbɔr idaa mɔmɔk la. ");
INSERT INTO xon_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Le kijook wɔb, tikur titaa aayoonn, u daŋ tidaŋ ki kan Uwumbɔr aatuun koo ni u chee ki nan bui ke, “Konelius.” ");
INSERT INTO xon_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Waah kan Uwumbɔr aatuun ngbaan na, le u san ijawaan, ki baa u, “Maaninkpel, aa ban ba?” Le Uwumbɔr aatuun ngbaan bui u, “Uwumbɔr ŋun saameen, ki nyi saah ter bigiim pu na, ki teer aa bɔr. ");
INSERT INTO xon_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","U ban ke aa cha bijab bibaa buen Jɔpa aatiŋ ni, ki ti yin ni uja ubaa, bi yin u ke Simonn Piita. ");
INSERT INTO xon_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","U koo ugbanjab ubaa aadichal ni, bi yin u ke Simonn. Waadichal bi nnyusakpem na aagbaan.” ");
INSERT INTO xon_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Le Uwumbɔr aatuun ngbaan ki gir buen. Waah buen na, le Konelius yin waatutum ponn ni bilee, ni butɔb aaja u ye uninyaan ki bi u chee idaa mɔmɔk ki tun lituln tii u na. ");
INSERT INTO xon_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konelius nan tuk bi waah kan pu na mɔmɔk, le ki tun bi, ke bi buen Jɔpa aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naah woln kitaak na, le bi bi nsan ni, ki peen Jɔpa aatiŋ ni. Nwiin kaasisik ni, le Piita jon kidiik paab u ti mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Le nkon chuu u, le u ban u ji tijikaar. Baah bi mɔn bisaa ke bi tii u na, ");
INSERT INTO xon_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","le u daŋ tidaŋ ki kan kitaapaak chuu piir, ki kan tiwan nibaa sunn ni kitiŋ. Ni nan naahn likekeln ki pee. Le bi joo ikekefeen inaa pu, ki sunn ni kitiŋ. ");
INSERT INTO xon_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ipeel, ni iwaa, ni tiwan nimɔk baar kitiŋ na, ni inyoon mɔmɔk aabɔŋ nan bi likekeln ngbaan pu. ");
INSERT INTO xon_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Le nneel len ke, “Piita, fii, ki ku ki ŋmɔ.” ");
INSERT INTO xon_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Le Piita bui ke, “Ndindaan, aayii. Maa kee ŋman tiwan ni kɔ ke nee na.” ");
INSERT INTO xon_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Le nneel ngbaan ki len ke, “Uwumbɔr yaa len ke aa ga ŋmaa ji tiwan ni na kan, aa taa bui ke ni kɔ.” ");
INSERT INTO xon_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Le ni ŋa kina nfum mutaa. Le tiwan ngbaan gir buen paacham. ");
INSERT INTO xon_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Le Piita dakl lik ke u bee lijinjiir aawan ngbaan aatataa. Ni nan ŋa u ilandak. N‑yoonn ngbaan binib bi nyan ni Konelius do na baa binib, ki bee Simonn do, ki si mbisamɔb chee, ");
INSERT INTO xon_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","le ki teen ke, “Simonn Piita bi do oo?” ");
INSERT INTO xon_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Le Piita laa beenin bi kidiik paab, ki bi dak lijinjiir aawan ngbaan aatataa. Le Uwumbɔr Aafuur Nyaan bui u, “Lik, bijab bitaa fuu ni do, ki ban si. Min le tun ni bi. ");
INSERT INTO xon_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fii ki sunn ni, ki dii bi, ki taa joo beeni.” ");
INSERT INTO xon_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Le Piita sunn ni kitiŋ, ki bui bijab ngbaan, “Min le ye unii u ni ban na. Ni chuun kinye?” ");
INSERT INTO xon_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Le bi bui u, “Konelius, u ye butɔb aajab nkub aaninkpel na le tun ni timi. U ye unibamɔnn u pak Uwumbɔr na. Juu yaab mɔmɔk pak u sakpen. Le Uwumbɔr aatuun mubaa tuk u ke u yin si, ke aa dan udo, u nan pel saah ga len pu na.” ");
INSERT INTO xon_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Le Piita bui bi ke bi koo ni, le ki chann bi tichann. Le bi doon udo. Naah woln kitaak na, le u gor ki dii bi. Le Yesu aanib bi nan bi Jɔpa aatiŋ ni na bibaa mu dii u. ");
INSERT INTO xon_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ki woln kitaak, le bi fuu Siisarea aatiŋ ni. Le Konelius nan yin waamaal, ni ujɔtiib dan udo, ki nan ka kii Piita. Le Piita ti fuu ki koo bi chee. ");
INSERT INTO xon_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Waah koo ni na, le Konelius dan nan gbaan unimbiin ni, ki doon u. ");
INSERT INTO xon_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Le Piita fiin u, ki bui u, “Fii sil. M po ye unibɔn la.” ");
INSERT INTO xon_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piita nan beenin bi len u chee le ki ti koo kidiik ni, ki kan binib pam kuun nima chee. ");
INSERT INTO xon_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Le Piita bui bi, “Ni nyi ke timi Juu yaab aakaal aa kii ke ti mann binib bi kaa ye Juu yaab na, kaa kii ke ti kpaan bi chee. Le Uwumbɔr mu mɔk mi ke m taa li dak ke unii ubaa kɔ. ");
INSERT INTO xon_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nima pu na, naah yin mi pu na, le m dan, kaa yii. Ni yin mi ba pu?” ");
INSERT INTO xon_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Le Konelius bui u, “Daanab na, tikur titaa kijook wɔb, kinakokoona, le m nan bi maadiik ni, ki bi mee Uwumbɔr. Maah bi mee Uwumbɔr na, le m kan uja u pee likekeln li wiin chain na si nnimbiin ni ");
INSERT INTO xon_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ki bui ke, ‘Konelius, Uwumbɔr ŋun saameel, ki teer saah ter bigiim pu na. ");
INSERT INTO xon_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","U ban ke aa cha binib buen Jɔpa aatiŋ ni, bi ti yin ni uja u bi nima aan bi yin u ke Simonn Piita na, ke u koo ugbanjab ubaa do, bi yin u ke Simonn na. Waadichal bi nnyusakpem na aagbaan.’ ");
INSERT INTO xon_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Waah tuk mi kina na, libuul ngbaan ni le m tun binib bi ti yin si. Saah dan pu na, ni ŋan. Dandana wee, ti mɔmɔk bi do, Uwumbɔr aanimbiin ni. Ti ban ti ŋun tibɔr ti Tidindaan tuk si ke aa tuk timi na.” ");
INSERT INTO xon_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Le Piita bui bi, “M bee ke ni ye mbamɔn ke Uwumbɔr aa pak ubaa ki jer uken. U po pak ti mɔmɔk la. ");
INSERT INTO xon_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ŋinibol mɔmɔk ponn ni, unii yaa bi, ki pak Uwumbɔr ki tun lituln li ŋan na kan, u piir Uwumbɔr aasui. ");
INSERT INTO xon_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ni nyi ke Uwumbɔr tuk Israel yaab tibɔnyaan. Tibɔnyaan tee le ye ke Uwumbɔr ga tii bi nsuudoon Yesu Kristo pu. Uma le ye ti mɔmɔk Aadindaan. ");
INSERT INTO xon_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jɔnn nan tuk binib ke bi yaa kpeln baabimbin kan, u ga muin bi nnyun ni. N‑yoonn ngbaan aah jer na, le Yesu u ye Nasaref aatiŋ aanii na piin ki bi tun waatuln Galilee aatim ni, ki bɔ dii Judea aatim mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ni nyi waabɔr. Uwumbɔr nan nyan u, ki di Waafuur Nyaan gbiin u ki tii u mpɔɔn, ki nan bi u chee. Uwumbɔr aah bi u chee na, le u buen ŋipepel mɔmɔk, ki tun lituln li ŋan na, ki cha binib bimɔk nan bi kinimbɔŋ aaŋaal ni na pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ti kan waah ŋani tiwan nimɔk Jerusalem ni Juu yaab aatim mɔmɔk ponn ni na. Le bi kpaa u ndɔpuinkoo pu, ki ku u. ");
INSERT INTO xon_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iwiin itaa daal, le Uwumbɔr fikr u nkun ni, ki cha binib kan u. ");
INSERT INTO xon_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Naa ye binib mɔmɔk le kan u. Uwumbɔr nyan timi le ke ti kan u, ki li ye waaseeraadam. Waah fikr nkun ni na, ti ni u kpaan jin tijikaar, ki kpaan ki nyu nnyun. ");
INSERT INTO xon_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U tuk timi ke ti buen ŋipepel mɔmɔk, ki ti tuk binib waabɔr, ki ji seeraa ke Uwumbɔr nyan u, u ti ji binifuub ni bitekpiib tibɔr. ");
INSERT INTO xon_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","N‑yaayoonn na, Uwumbɔr aabɔnabtiib mɔmɔk nan len Yesu aabɔr, ke unii umɔk gaa u ki kii na, Uwumbɔr ga di cha pinn u, uma Yesu aayimbil pu.” ");
INSERT INTO xon_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tɔ, Piita aah laa bi len kina na, le Uwumbɔr Aafuur Nyaan sunn ni ki nan gbiin binib bimɔk ŋun waah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yesu aanib bi nyan Jopa ki dii Piita na nan ye Juu yaab, le ni gar bi pam, ba pu? Uwumbɔr di Waafuur Nyaan tii binib bi kaa ye Juu yaab na mu, ");
INSERT INTO xon_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","le bi ŋun bi len iliin yayan ki nyuŋni Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Tɔ, Piita bui ke, “Uwumbɔr di Waafuur Nyaan tii binib bimina, ke waah tii timi pu na. Ubaa ga ŋmaa len ke ti taa muin bi nnyun ni ii?” ");
INSERT INTO xon_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Waah len kina na, le u bui bi ke bi muin bi nnyun ni, Yesu Kristo aayimbil pu. Tɔ, Konelius mam nan gaŋ Piita ke u ŋa bi chee iwiin ilee. ");
INSERT INTO xon_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu aakpambalb ni Judea aatiŋ aanib bi nan gaa Yesu ki kii na, nan ŋun ke binib bi kaa ye Juu yaab na mu gaa Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Le Juu yaab bibaa len ke binib bi kaa ye Juu yaab na yaa gaa Uwumbɔr aabɔr kan, ni ŋan ke bi gii ŋichakpan. Le Piita ki gir buen Jerusalem. Waah ti fuu nima na, le Juu yaab ngbaan kpak u kinikpakpak, ");
INSERT INTO xon_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ke ba ŋa u mann binib bi kaa ye Juu yaab na, ki jin bi chee tijiir, Juu yaab aah kɔ pu na. ");
INSERT INTO xon_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Le Piita ŋeer tibɔr mɔmɔk aah piin ki ti saa pu na, ki tuk bi: ");
INSERT INTO xon_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“M nan bi Jɔpa aatiŋ ni, ki bi mee Uwumbɔr, le ni ŋa mi ke tidaŋ pu na, le m kan tiwan nibaa nyan ni paacham. Ni naahn likekeln, ki pee. Le bi joo ikekefeen inaa pu, ki sunn ni kitiŋ m chee. ");
INSERT INTO xon_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Le m lik ni mbamɔm, ki kan tiwakor, ni ipeel, ni iwaa, ni tiwan nimɔk baar kitiŋ na, ni inyoon, ni pu. ");
INSERT INTO xon_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Le m ŋun nneel len ke, ‘Piita, fii, ki ku ki ŋmɔ.’ ");
INSERT INTO xon_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Le m len ke, ‘Ndindaan, aayii. Maa kee ŋman tiwan ni kɔ ke nee na.’ ");
INSERT INTO xon_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Le nneel ngbaan ki len paacham ke, ‘Uwumbɔr yaa len ke aa ga ŋmaa ji tiwan ni na kan, aa taa bui ke ni kɔ.’ ");
INSERT INTO xon_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Le ni ŋa kina nfum mutaa. Le tiwan ngbaan ki gir buen paacham. ");
INSERT INTO xon_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Libuul ngbaan ni le bijab bitaa fuu ni maah bi lidichal li ni na aabisamɔb chee. Bi nan nyan ni Siisarea aatiŋ ni la. Konelius le tun ni bi, ke bi nan yin mi. ");
INSERT INTO xon_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Le Uwumbɔr Aafuur Nyaan bui mi, ‘Dii bi, ki taa joo beeni.’ Le m dii bi. Le Yesu aanib biloob bimina mu dii mi, le ti buen Siisarea aatiŋ ni, ki ti fuu ki koo Konelius do. ");
INSERT INTO xon_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Le Konelius tuk timi ke u nan kan Uwumbɔr aatuun si udo ki tuk u ke u cha binib buen Jɔpa aatiŋ ni, ki ti yin uja ubaa, bi yin u ke Simonn Piita, ");
INSERT INTO xon_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","u ga tuk u tibɔr ti ga cha u ni waachiln ponn ni aanib mɔmɔk ŋmar na. ");
INSERT INTO xon_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Le m piin ki bi tuk bi Yesu aabɔr. Maah laa bi tuk bi na, le Uwumbɔr Aafuur Nyaan sunn ni bi pu, ke mu aah nan sunn ni ti pu njan pu na. ");
INSERT INTO xon_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Le m teer ke Tidindaan nan tuk timi ke, ‘Jɔnn nan muin binib nnyun ni. Mma ga gbiin nimi Uwumbɔr Aafuur Nyaan.’ ");
INSERT INTO xon_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tɔ, Uwumbɔr di Waafuur Nyaan tii timi bi gaa Tidindaan Yesu Kristo ki kii na, le ki tii binib bi kaa ye Juu yaab na mu, ke waah tii timi pu na. M mu ye ŋma ki ga ŋmaa yii Uwumbɔr?” ");
INSERT INTO xon_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Juu yaab ngbaan aah ŋun Piita aah len pu na, le baa ki kpak u. Bi nan nyuŋ Uwumbɔr, le ki bui ke, “Kina pu na, Uwumbɔr cha binib bi kaa ye Juu yaab na mu kpeln baabimbin ki kan limɔfal.” ");
INSERT INTO xon_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tɔ, binib bi ku Stiifen na nan muk Yesu aanib ki ŋani bi falaa. Le bi yaa, ki buen ntim mɔmɔk ni, ki ti saa Fonisia aatiŋ ni, ni Saiprus aatiŋ ni, ni Antiok aatiŋ ni, ki joo Yesu aabɔr tuk Juu yaab baanja. ");
INSERT INTO xon_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Le Yesu aanib bibaa, bi nyan ni Saiprus aatiŋ ni, ni Sairene aatiŋ ni na mu buen Antiok aatiŋ ni, ki ti tuk binib bi kaa ye Juu yaab na mu Tidindaan Yesu aabɔnyaan. ");
INSERT INTO xon_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tidindaan aapɔɔn nan bi bi chee, le binib pam gaa Tidindaan ki kii, ki kpeln baabimbin, ki dii waasan. ");
INSERT INTO xon_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yesu aanib bi nan bi Jerusalem na ŋun bi pu. Nima pu le bi tun Banabas ke u buen Antiok aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","U nan ye unibamɔnn, ki gaa Yesu ki kii mbamɔm, ki gbii Uwumbɔr Aafuur Nyaan. Le u di ti fuu nima. Waah ti fuu nima, ki kan Uwumbɔr aah san binib ngbaan kinimbaak pu pu na, le ni ŋa u mpopiin. Le u sur bi mɔmɔk ke bi cha binimbil li man bi dii Tidindaan aasan mbamɔm. Le binib pam gaa Tidindaan ki kii ki kpee waanib pu. ");
INSERT INTO xon_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Le Banabas buen Tasus aatiŋ ni, u ti ban Sɔɔl, ");
INSERT INTO xon_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","le ki ti kan u, ki di u dan Antiok aatiŋ ni. Libimɔln le Banabas, ni Sɔɔl, ni Yesu aanib nan kuuni nima chee; le bi tuk binib pam Uwumbɔr aabɔr, Antiok aatiŋ ni, le bi naan Yesu aadidiliib liyimbil lee, ke Kristo Yaab. ");
INSERT INTO xon_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","N‑yoonn ngbaan le Uwumbɔr aabɔnabtiib bibaa nyan ni Jerusalem, ki dan Antiok aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bi yin ubaa ke Agabus. Le Uwumbɔr Aafuur Nyaan cha u len ke nkon sakpem ga lir dulnyaa wee ponn ni. Ubɔrkpaan Klɔdius aayoonn le mu nan lir. ");
INSERT INTO xon_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agabus aah len kina na, le Yesu aadidiliib len ke bi mɔmɔk ga tii ŋimombil, baah ga ŋmaa tii pu na, ki di tii Yesu aanib bi bi Judea aatiŋ ni na. ");
INSERT INTO xon_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Le bi mɔmɔk tii kina. Le Banabas ni Sɔɔl di ŋimombil ngbaan buen Judea, ti di tii Yesu aanib aaninkpiib. ");
INSERT INTO xon_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","N‑yoonn ngbaan le Ubɔr Herod piin ki bi ŋani Yesu aanib bibaa falaa. ");
INSERT INTO xon_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U cha binib di kijaak aajuk ku Jems u ye Jɔnn aakpel na. ");
INSERT INTO xon_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Waah ŋa kina na, le ni piir Juu yaab aasui. Nima pu le u cha binib chuu Piita mu. Ni nan ye n‑yoonn mu Juu yaab ji Lakr‑jer aajim ki ŋmɔ boroboro u kaa kpa nnyɔk na. ");
INSERT INTO xon_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Baah chuu Piita na, le bi di u ŋa kiyondiik ni. Le butɔb aajab kipiik ni biloob si kii u. Binaa yaa kiir ki ti saa tikur titaa kan, le binaa mu nan gaa. Ubɔr Herod nan len ke Lakr‑jer aajim ngbaan yoonn yaa jer kan, u ga nyan Piita kiyondiik ni, ki di u siin Juu yaab aanimbiin ni, ki ji u tibɔr. ");
INSERT INTO xon_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piita aah laa bi kiyondiik ni na, le Yesu aanib mu nan bi mee Uwumbɔr linimaln, ki tii u. ");
INSERT INTO xon_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kinyeek ngbaan yaa woln kan, Ubɔr Herod ga nyan Piita ki ji u tibɔr. Le Piita dɔ geen bikikiirb bilee aakaasisik ni. Bi nan di tikululn buu uŋaal mɔmɔk ilee, ki di tibaa gbin dar ukikiir wee, ki di tiken gbin dar uken. Le bikikiirb biken si kii mbisamɔb chee. ");
INSERT INTO xon_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kinyeek ngbaan, le Tidindaan aatuun dan ki nan sil u chee. Le nwiihn woln kidiik ponn ni. Le u gbaa finn Piita, ki bui u ke, “Fii sil mala mala.” Waah len kina na, le tikululn ngbaan chuu leer lir. ");
INSERT INTO xon_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Le Tidindaan aatuun ngbaan bui u, “Di saagbapapaln buu aachaŋ, ki di saanaatak taŋ.” Le Piita ŋa kina. Le u ki bui u, “Di saakekeln peen, ki dii mi.” ");
INSERT INTO xon_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Le Piita dii u ki buen, ki dak ke ni ye tidaŋ la. Waa dak ke ni sil ye ibamɔn. ");
INSERT INTO xon_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Baah cha na, le bi jer ukikiir ubaa, ki ki foor, le ki ki jer uken, ki ti fuu tikur aajaaleŋ u lek lipaal aabisamɔb na. Le jaaleŋ ngbaan piir ubaa pu. Le bi nyan, ki bɔ dii nsan mubaa. Libuul ngbaan ni le Tidindaan aatuun ngbaan buen, ki cha Piita. ");
INSERT INTO xon_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Le Piita aanimbil woln. Le u len ke, “M bee ke ni sil ŋa kina. Tidindaan tun ni waatuun ke u nan nyan mi Ubɔr Herod aaŋaal ni, ki nyan mi Juu yaab aah ban bi ŋa mi pu na ni.” ");
INSERT INTO xon_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tɔ, Piita nan bee waabɔr aah bi pu na, le ki buen Mari, u ye Jɔnn Mak aana na do. Kinipaak nan bi nima, ki bi mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Le Piita kpaar lipaal aajaaleŋ. Le ututunn u ye upii aan bi yin u ke Roda na, dan nan lik udaan u kpaar jaaleŋ na, ");
INSERT INTO xon_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","le ki bee Piita aaneel. Le ni ŋa u mpopiin sakpen. Le u gir buen biken chee, kaa piir jaaleŋ, ki ti tuk bi ke Piita si lipaal. ");
INSERT INTO xon_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Le bi tuk u ke u waar la. Le u beenin len ke ni ye mbamɔn. Le bi bui u ke ni ga li ye Piita aawiin la. ");
INSERT INTO xon_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Le Piita beenin si kpaar jaaleŋ. Le bi piir jaaleŋ, ki kan u. Baah kan u na, le ni gar bi sakpen. ");
INSERT INTO xon_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Le Piita yoor uŋaal ki nyii bi pu, ke bi ŋmin, le ki tuk bi Tidindaan aah ŋa pu ki nyan u kiyondiik ni na, ki bui bi ke bi tuk Jems ni Yesu aanib biken. Piita aah len kina na, le u siir buen nibaa chee. ");
INSERT INTO xon_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kitaak aah woln na, le bikikiirb ngbaan aapobil yuk. Le bi baa tɔb budabu ŋa Piita na. ");
INSERT INTO xon_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Le Ubɔr Herod bui bi ke bi ban u. Le bi ban u, kaa kan u. Le Herod yin bikikiirb ngbaan, ki nan baa bi tibɔr ngbaan, le ki len ke baabɔr bii, ki ku bi. Tɔ, Herod nan nyan Judea aatiŋ ni, ki buen Siisarea aatiŋ ni, ki ti yunn nima siib. ");
INSERT INTO xon_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod nan gee liŋuul ki ŋa Taya aatiŋ aanib, ni Saidonn aatiŋ aanib pu. Le bi mɔmɔk kuun ki buen u chee. Bi nan puen buen uja ubaa chee la. Bi yin u ke Blastus, u ye Herod aatutum aaninkpel la. Le Taya aanib ni Saidonn aanib buen u chee bi ti jɔnn u kijɔtiik, le ki nin buen Ubɔr Herod chee, ki ti mee u ke u taa cha bi li kpa kijaak. Bi gaal baajikaar Ubɔr Herod aatiŋ ni la. Nima pu na, baa ban ke bi li kpa kijaak. ");
INSERT INTO xon_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Le Herod siin nwiin mundaln bi ga kuun tɔb na. Liyaadaal le u di waabɔrkekeln peen, ki kal waabɔrjal pu, le ki len bi chee tibɔr. ");
INSERT INTO xon_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Waah len tibɔr pu na, le bi mɔmɔk tar ke, “Ni ye Uwumbɔr aaneel la, naa ye unibɔn.” ");
INSERT INTO xon_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tɔ, libuul ngbaan ni le Tidindaan aatuun cha iween chuu u; ba pu? waa tii Uwumbɔr lisil. Le ŋikpaambil ŋman u, le u kpo. ");
INSERT INTO xon_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tɔ, Uwumbɔr aabɔr nan moo mooni ŋipepel mɔmɔk. Le binib too kpae ki gaal i. ");
INSERT INTO xon_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ni Sɔɔl ma kan, baah nan di ŋimombil tii Yesu aanib aaninkpiib na, le bi di Jɔnn Mak nyan Jerusalem ni, ki labr buen Antiok aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Yesu aanib bibaa nan bi Antiok aatiŋ ni. Bi ponn ni bibaa nan ye Uwumbɔr aabɔnabtiib, bibaa mu nan ye Yesu aabɔr aamɔmɔkb. Bi yin ubaa ke Banabas, ki yin uken ke Simeonn, ki ki yin u ke Unibɔmbɔn, ki yin uken ke Lusius, u nan ye Sairene aatiŋ aanii na, ki yin uken ke Manaenn u Ubɔr Herod aate nan kpiin u na, ki yin uken ke Sɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Le bi mɔmɔk dooni Uwumbɔr ki lul bumɔb. Baah ŋani kina na, le Uwumbɔr Aafuur Nyaan tuk bi ke bi nya Banabas ni Sɔɔl bi ti tun waah siin bi lituln li na. ");
INSERT INTO xon_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Le Yesu aanib lul bumɔb, ki mee Uwumbɔr, ki di biŋaal paan bi pu, le ki cha bi buen. ");
INSERT INTO xon_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tɔ, Uwumbɔr Aafuur Nyaan aah tun Banabas ni Sɔɔl pu na, le bi buen, ki ti fuu kitiŋ kibaa ni, bi yin ki ke Selusia, le ki koo buŋɔb ni, ki puur ki ti fuu lidikl pu, bi yin lidikl ngbaan ke Saiprus, ");
INSERT INTO xon_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","le ki fuu kitiŋ ki bi lidikl ngbaan paab na, bi yin ki ke Salamis. Baah fuu nima na, le bi koo Juu yaab aameen aadir ni, ki tuk binib Uwumbɔr aabɔr. Jɔnn Mak mu nan dii bi, ki ter bi. ");
INSERT INTO xon_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Le bi ki buen lidikl ngbaan aapepel liken wɔb, ki ti fuu kitiŋ kibaa ni, bi yin ki ke Pafos. Baah ti fuu nima na, le bi kan ubɔɔ ubaa, bi yin u ke Bariyesu. U nan ye Juu yaab aanii le ki ŋmann ke u ye Uwumbɔr aabɔnabr la. ");
INSERT INTO xon_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Lidikl ngbaan aatim aaninkpel mu nan bi nima, bi yin u ke Sejius Pɔɔlus. U nan ye unii u kpa nlan na la. Ubɔɔ ngbaan aajɔ le nan bi na. Le uninkpel ngbaan yin Banabas ni Sɔɔl ke bi dan u chee, ki ban u ŋun Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ubɔɔ ngbaan aayimbil leler nan ye Elimas la. Elimas aatataa le ye ke ubɔɔ. Le u kpak Banabas ni Sɔɔl kinikpakpak, ki pɔɔni ubaa ke uninkpel ngbaan taa gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Le Uwumbɔr Aafuur Nyaan fir Sɔɔl, u bi duln u ke Pɔɔl na pu, le u lik Elimas mbamɔm, ");
INSERT INTO xon_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","le ki bui u, “Sin u ye kinimbɔŋ aajapɔɔn na, aa ye litunyaan mɔmɔk aadin la, ki ŋmanni binib n‑yoonn mɔmɔk, ki kpa mbiin sakpen, ki ban aa bii Tidindaan aasan mu tok na. ");
INSERT INTO xon_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Uwumbɔr ga daa aatafal, ki cha aa jɔb, kaan ki li waa, ki ti saa n‑yoonn mu Uwumbɔr gee na.” Libuul ngbaan ni le likpakpal bɔmbɔln biin unimbil pu, le u jɔb, ki chuun mann gonni ki ban unii u ga chuu uŋaal ki dar u na. ");
INSERT INTO xon_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Uninkpel ngbaan aah kan kina, ki bae Tidindaan aah bi pu na, le ni gar u pam. Le u gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔɔl mam nan nyan Pafos aatiŋ ni, le ki koo buŋɔb ni, ki ti puur, ki ti fuu kitiŋ kibaa ni, bi yin ki ke Pega, ki bi Pamfilia aapepel ni la. Baah ti fuu nima na, le Jɔnn Mak gir buen Jerusalem ki cha bi. ");
INSERT INTO xon_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Le bi nyan Pega aatiŋ ni, ki buen ti fuu Antiok aatiŋ ki bi Pisidia aapepel ni na. Juu yaab aakpaakool daal, le bi koo kal mmeen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Le unii ubaa karn Uwumbɔr Aagbaŋ ponn ni. U karn Moses ni Uwumbɔr aabɔnabtiib aah nan ŋmee pu na. Waah karn doo na, le mmeen aadiik aaninkpiib tun unii bi chee, ke u ti tuk bi ke bi yaa ban bi tuk binib tibɔr ti ga pɔɔk bitaakpab na kan, bi tuk bi. ");
INSERT INTO xon_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Le Pɔɔl fii sil ki yoor uŋaal ki len ke, “Israel yaab, ni nimi bi kaa ye Israel yaab ki pak Uwumbɔr na, li pel man: ");
INSERT INTO xon_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Timi Israel yaab Aawumbɔr nan nyan tiyaajatiib. Bi nan ye bicham le Ijipt aatiŋ ni. Baah bi nima na, le Uwumbɔr ter bi, ki cha bi pɔr. Le Uwumbɔr nyan bi Ijipt aatiŋ ni, ki mɔk Ijipt aatiŋ aanib waapɔɔn sakpiin. ");
INSERT INTO xon_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ŋibin imonko ilee le Uwumbɔr kpiin tiyaajatiib timoor ni, ");
INSERT INTO xon_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","le ki nin jenn nyan ŋinibol ŋilole Kanaann aatiŋ ni, ki di kitiŋ ngbaan yakr ke lifaal na tii bi. Buyoonn bi nan koo Ijipt aatiŋ ni na, ki ti saa bundaln bi nan gaa Kanaann aatiŋ na, nan ye ŋibin ikui inaa ni piiŋmu la. ");
INSERT INTO xon_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“N‑yoonn ngbaan le u tii bi bibɔjirb, bi li joo bi, ki ti saa waabɔnabr Samuel aayoonn. ");
INSERT INTO xon_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","N‑yoonn ngbaan le bi len ke bi ban ubɔr, u li joo bi. Baah len kina na, le Uwumbɔr nyan Sɔɔl, u nan ye Kis aajapɔɔn na, u li ye baabɔr. U nan ye Benjaminn aanibol ponn ni aanii, ki nan joo bi ŋibin imonko ilee la. ");
INSERT INTO xon_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nee aapuwɔb le Uwumbɔr nyan u bi chee, ki di David ŋa baabɔr, ki len ke, ‘David u ye Jese aajapɔɔn na bi maah gee pu na. U ga li ŋani maah gee pu na mɔmɔk.’ ");
INSERT INTO xon_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tɔ, Uwumbɔr nan puu tipuur ke u ga tun unii Israel yaab chee, ke u gaa bi lii. Yesu le u tun ni u bi chee, ke u gaa bi lii. Uma le ye Ubɔr David aayaabil ubaa. ");
INSERT INTO xon_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jɔnn u nan muini binib nnyun ni na nan loln nsan ki fuu ni, le Yesu nin paan ni. Yesu aah kaa nan kee piin waatuln na, le Jɔnn tuk Israel yaab ke bi yaa kpeln baabimbin kan, u ga muin bi nnyun ni. ");
INSERT INTO xon_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jɔnn aah kaa nan kee tun waatuln doo na, le u baa bi, ‘Ni dak ke m ye ŋma? Maa ye Kristo u ga gaa binib lii na. Uma le paan ni mpuwɔb. Maa ŋeer m chuu gbiln waanaatak aaŋmin.’” ");
INSERT INTO xon_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tɔ, Pɔɔl nan ki bui bi, “Nnaabitiib, Abraham aayaabitiib, ni binib bi kaa ye Juu yaab ki pak Uwumbɔr na, timi chee le Uwumbɔr nan tun ni tibɔnyaan ke u ga gaa timi lii. ");
INSERT INTO xon_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Binib bi bi Jerusalem ni na, ni baaninkpiib aa nyi ke Yesu le ga gaa bi lii. Likpaakool mɔmɔk daal, bi karni Uwumbɔr Aagbaŋ ponn ni, Uwumbɔr aabɔnabtiib aah nan len pu na, kaa bee naatataa. Le bi jin Yesu tibɔr ki len ke waabɔr bii. Uwumbɔr aabɔnabtiib nan len ke bi ga ŋa kina. ");
INSERT INTO xon_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Juu yaab nan mee Pailat nsan ke bi ku Yesu. Bi mu aa kan waataani ki ga ŋmaa len ke u ŋeer bi ku u. ");
INSERT INTO xon_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ni ŋmee Uwumbɔr Aagbaŋ ponn ni baah ga nan ŋa Yesu pu ki ku u na. Le bi nan ŋani naah ŋmee pu na mɔmɔk, le ki nyan u ndɔpuinkoo pu, ki di u sub kitakpaluŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Le Uwumbɔr fikr u nkun ni. ");
INSERT INTO xon_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Le u di ubaa mɔk binib bi nan dii u Galilee ki nan saa Jerusalem na. Le bi kan u iwiin pam. Dandana wee, bima le ye waaseeraadam, ki tuk Juu yaab waabɔr. ");
INSERT INTO xon_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Timi le joo ni tibɔnyaan ngbaan nan tuk nimi. Uwumbɔr nan puu tipuur tii tiyaajatiib. Timi le ye tiyaajatiib aayaabitiib. Waah puu tipuur ti tii tiyaajatiib na, u gbiin tipuur ngbaan dandana wee tii timi, ki fikr Yesu nkun ni. Uwumbɔr aalahn aagbaŋ ponn ni, ŋiyil ŋilee, le Uwumbɔr len Yesu chee ke, ‘Sin le ye Maabo, din wee le m ma si.’ ");
INSERT INTO xon_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","35","Tɔ, Uwumbɔr ki bui ke: ‘M ga sil ŋa tinyoor ti bi chain na ŋa ni pu, ke maah puu tipuur tii Ubɔr David pu na.’ Uwumbɔr ki len kigbaŋ kibaa ponn ni: ‘Maan cha maabo u ye chain na aawon bur.’” Tɔ, Pɔɔl nan ki len ke, “Uwumbɔr aah len pu na, naatataa le ye ke u fikr Yesu nkun ni. Waan ki kpo. Waawon aan bur. ");
INSERT INTO xon_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ubɔr David aah nan bi na, u nan tun Uwumbɔr aatuln, le ki ti kpo. Le bi sub u uyaajatiib chee, le u bur. ");
INSERT INTO xon_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yesu u Uwumbɔr fikr u nkun ni na, uma aawon aa bur. ");
INSERT INTO xon_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Tijɔtiib, ti tuk nimi ke Uwumbɔr ga di cha nimi aatunwanbir pinn nimi Yesu pu. Binib bimɔk gaa Yesu ki kii na, Uwumbɔr ga di cha pinn bi, ki nyan bi baatunwanbir ni. Moses aakaal aa ŋmaa di cha pinn binib, kaa ŋmaa nyan bi baatunwanbir ni. Ti ban ke ni li nyi tibɔr timina mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Uwumbɔr aabɔnabtiib nan len ke Uwumbɔr len ke: ‘Mbɔnyundam, lik, m bi tun lituln libaa nimi aayoonn. Unii yaa tuk nimi ke m tun lituln limina kan, naan tii naadii la. Cha ni gar nimi man, aan ki bee yɔli.’” Tɔ, Pɔɔl nan ki tuk bi, “Ni li nyi aan Uwumbɔr aabɔnabtiib aah len pu na, ni taa ŋa nimi.” ");
INSERT INTO xon_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔɔl aah len doo na, le u ni Banabas nyan ni mmeen aadiik ni. Baah nyan ni na, le binib bui bi ke likpaakool li choo na daal bi ki gir ni, ki nan ki tuk bi tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Binib mɔmɔk aah nyan mmeen aadiik ni na, le Juu yaab, ni binib bi nan kpeln ki dii Juu yaab aasan na pam nan dii Pɔɔl ni Banabas. Le Pɔɔl ni Banabas len bi chee ki tuk bi ke Uwumbɔr aah san bi kinimbaak pu na, bi li beenin dii waasan. ");
INSERT INTO xon_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tɔ, likpaakool li paan ni na daal, le binib bimɔk bi kitiŋ ngbaan ni na nan kuun ni bi nan ŋun Tidindaan aabɔr. Ubaabaa baanja le nan gur linampal. ");
INSERT INTO xon_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Juu yaab aah kan kinipaak ngbaan kuun kina na, le bi kpa lipiipoln sakpen, ki kpak Pɔɔl kinikpakpak, ki seei u. ");
INSERT INTO xon_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Le Pɔɔl ni Banabas kpa lipobil ki bui Juu yaab ngbaan, “Ni ŋan ke ti puen tuk nimi Uwumbɔr aabɔr. Le ni yii, kaa kii, kaa dak ke ni ŋeer ni kan limɔfal li kaa kpa ndoon na. Kina pu na, ti ga di cha nimi, ki tuk binib bi kaa ye Juu yaab na Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Uwumbɔr tuk timi waagbaŋ ponn ni ke ti ŋa kina. U nan len ke, ‘M nyan si la, ke aa woln binib bi kaa ye Juu yaab na aanimbil, ki tii dulnyaa wee ni aanib mɔmɔk nsan ke bi ŋmar.’” ");
INSERT INTO xon_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tɔ, binib bi kaa ye Juu yaab na aah ŋun baah len pu na, le bi kpa mpopiin sakpen, le ki bui ke Uwumbɔr aabɔr ŋan sakpen a. Le binib bi Uwumbɔr nyan bi ke bi kan limɔfal li kaa kpa ndoon na gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Le Uwumbɔr aabɔr moon itingbaan mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Le bipiib bi kpa mpɔɔn ki pak Uwumbɔr na bi kitiŋ ngbaan ponn ni. Kitiŋ ngbaan aaninkpiib mu nan bi. Le Juu yaab ŋa, ki cha bi ŋma tijar Pɔɔl ni Banabas pu, ki ŋa bi falaa, ki nyan bi baatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Le Pɔɔl ni Banabas kpaar bitaa aatatan lii nima, ni ye nsurm le ki tii bi, ki nyan ni nima, ki buen kitiŋ kibaa ni, bi yin ki ke Ikonium. ");
INSERT INTO xon_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Le Uwumbɔr Aafuur Nyaan gbiin binib bi gaa Yesu ki kii Antiok aatiŋ ni na. Le bi nan kpa mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔɔl ni Banabas nan ti fuu Ikonium aatiŋ ni, ki koo mmeen aadiik ni, ki kpa mpɔɔn ki tuk binib Uwumbɔr aabɔr. Nima pu na, binib pam nan gaa Yesu ki kii, bi ye Juu yaab, ni bi kaa ye Juu yaab na mu. ");
INSERT INTO xon_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Le Juu yaab bibaa yii Uwumbɔr aabɔr, ki bii Yesu aanib, ki cha binib bi kaa ye Juu yaab na bibaa gee liŋuul bi pu. ");
INSERT INTO xon_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Le Pɔɔl ni Banabas nan bi nima ki yunn, ki nan kpa lipobil ki tuk binib Tidindaan aabɔr, ke u gee bi. Le Tidindaan cha bi tun lijinjiir aatun, ki mɔk ke baah len pu na, ti gbii. ");
INSERT INTO xon_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Le kitiŋ ngbaan aanib aa kpa kimɔbaan. Bibaa nan si Juu yaab aapuwɔb, biken mu si Yesu aakpambalb aapuwɔb. ");
INSERT INTO xon_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Le Juu yaab ni baaninkpiib, ni binib bi kaa ye Juu yaab na bibaa kpokl ke bi ga ŋa Yesu aakpambalb bakaa ki mae bi ŋitakpal. ");
INSERT INTO xon_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Le Yesu aakpambalb ŋun baah ban bi ŋa bi pu na, ki san ŋmar, ki buen Listra aatiŋ ni, ni Debe aatiŋ ni, ni itingbaan i bi nima na. Listra aatiŋ, ni Debe aatiŋ mɔmɔk bi Likonia aapepel ni la. ");
INSERT INTO xon_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Le bi tuk nima chee aanib tibɔnyaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Uja ubaa nan bi Listra aatiŋ ni, le utaafar faan. Una aah nan ma u na, u nan ye uwɔb la. Waa nan chuun. ");
INSERT INTO xon_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","U nan ka pel Pɔɔl aah len pu na, le Pɔɔl bee ke u gaa Yesu ki kii, nima le u ga ŋmaa tii u laafee. Le Pɔɔl lik u sulm, ");
INSERT INTO xon_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ki len mpɔɔn pu, “Fii sil aataa pu.” Le uja ngbaan fii yuk sil, le ki chuun gonni. ");
INSERT INTO xon_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Le kinipaak ngbaan kan Pɔɔl aah ŋa pu na. Le bi teen Likonia aatiŋ aanib aaliin ponn ni, “Ŋiwaa le kpaln binib ki dan ti chee do.” ");
INSERT INTO xon_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Le bi yin Banabas ke Seus. Pɔɔl nan len tibɔr jer Banabas. Nima pu le bi yin u ke Hemes. ");
INSERT INTO xon_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Liwaal Seus aadichal nan bi kitiŋ ngbaan aagoln aabisamɔb chee la. Le unii u toor kitork tii liwaal ngbaan na joo ni inaaja ni nsupuun ki di dan kitiŋ ngbaan aagoln aabisamɔb chee. U ni kinipaak ngbaan nan ban ke bi toor kitork tii Uwumbɔr aakpambalb Banabas ni Pɔɔl la. ");
INSERT INTO xon_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Le Banabas ni Pɔɔl ŋun baah ban bi ŋa pu na. Baah ŋun kina na, le bi chuu kar baabɔkur, le ki san koo kinipaak ngbaan aakaasisik ni, ki tar ke, ");
INSERT INTO xon_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Njɔtiib, ba pu ni ŋani kina? Ti po ye binibɔm ke naah ye pu na la. Ti dan ti nan tuk nimi tibɔnyaan la. Di cha man, ki taa ki dii ŋiwaa man. Ŋi ye fam la. Ni li dii Uwumbɔr u fu na. Uma le nan naan paacham ni kitiŋ, ni nnyusakpem, ni tiwan mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","N‑yaayoonn na, u nan cha ŋinibol mɔmɔk ŋani baah gee pu na. ");
INSERT INTO xon_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","N‑yoonn mɔmɔk u mu ŋani nimi tiŋann, ki tii nimi utaal, ki cha tijikaar ŋani, ki kpiini nimi, ki cha ni kpa mpopiin, u mɔk nimi ke u bi.” ");
INSERT INTO xon_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Le Pɔɔl ni Banabas len kina ki pɔɔni bibaa ke bi taa cha kinipaak ngbaan toor kitork ngbaan tii bi, le baa ki toor ki tii bi. ");
INSERT INTO xon_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Le Juu yaab bibaa nyan ni Antiok aatiŋ ni, ni Ikonium aatiŋ ni, ki dan Listra aatiŋ ni, bi nan bii Pɔɔl ni Banabas ki cha binib gee liŋuul bi pu. Le bi mae Pɔɔl ŋitakpal, ki dar fuul u nyan kitiŋ ni, ki ti di bil, ki dak ke u kpo, le ki siir cha u. ");
INSERT INTO xon_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Le Yesu aadidiliib dan nan sil gob u. Baah sil gob u na, le u fii sil, ki labr buen kitiŋ ngbaan ni. Kitaak aah woln na, le Pɔɔl ni Banabas siir buen Debe aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ki ti tuk nima chee aanib tibɔnyaan ngbaan. Le binib pam gaa ti, ki dii Yesu aasan. Le Pɔɔl ni Banabas nyan nima ki ki labr buen Listra aatiŋ ni, ni Ikonium aatiŋ ni, ni Antiok aatiŋ ki bi Pisidia aapepel ni na. ");
INSERT INTO xon_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Baah dii ntim ngbaan ni na, le bi pɔɔk Yesu aanib aataakpab, ki toor tuk bi Uwumbɔr aabɔr, le ki tuk bi ke bi sil Yesu aachaŋ ni, ke binib yaa ban bi koo Uwumbɔr aanaan ni kan, bi ga ji falaa sakpen le ki nin koo ni. ");
INSERT INTO xon_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ntim mɔmɔk ni, bi nan leer Yesu aanib ponn ni bininkpiib ke bi li joo bi, le ki lul bumɔb, ki mee Uwumbɔr tii bi. Baah gaa Tidindaan ki kii na, le bi di bi ŋa uŋaal ponn ni, ke u li lik bi. ");
INSERT INTO xon_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Le bi bɔ dii Pisidia aatim ponn ni, ki ti ki fuu Pamfilia aapepel ni, ");
INSERT INTO xon_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","le ki ti fuu Pega aatiŋ ni, ki tuk binib Yesu aabɔr, le ki buen Atalia aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Baah ti fuu nima na, le bi koo buŋɔb ni, ki puur nnyusakpem ki gir buen Antiok aatiŋ ni, kitiŋ ki bi nan nyan ni ki ni na. Baah nan ban bi nyan kitiŋ ngbaan ponn ni na, Yesu aanib nan mee Uwumbɔr tii bi, ki di bi ŋa uŋaal ni, ke u ter bi waatuln ponn ni. Baah ti tun lituln ngbaan doo na, le bi ki gir ni nima. ");
INSERT INTO xon_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Baah fuu ni na, le bi yin Yesu aanib ke bi kuun ni, le ki tuk bi tiwan nimɔk Uwumbɔr cha bi ŋa na, ki tuk bi waah ŋa pu ki tii binib bi kaa ye Juu yaab na nsan ke bi gaa Yesu ki kii na. ");
INSERT INTO xon_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔɔl ni Banabas nan ti bi nima, Yesu aadidiliib chee, ki yunn. ");
INSERT INTO xon_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tɔ, bijab bibaa nan nyan ni Judea aatiŋ ni, ki dan Antiok aatiŋ ni, le ki nan tuk Yesu aanib ke bi yaa kaa gii ŋichakpan, Moses aakaal aah mɔk pu na kan, baan ŋmar. ");
INSERT INTO xon_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Le bijab ngbaan kpak Banabas ni Pɔɔl kinikpakpak sakpen tibɔr ngbaan pu. Nima pu na, bi mɔmɔk nan kii ke bi ga tun Pɔɔl ni Banabas ni binib bibaa aan bi buen Jerusalem, ki ti baa Yesu aakpambalb ni Yesu aanib aaninkpiib bi bi nima na, ki lik. ");
INSERT INTO xon_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yesu aanib nan ter bi, le bi gor ki buen. Baah cha na, le bi bɔ dii Fonisia aatim ni, ni Samaria aatim ni, ke bi ti mann Yesu aanib, ki tuk bi ke binib bi kaa ye Juu yaab na mu gaa Yesu ki kii. Le ni tii bi mɔmɔk mpopiin sakpen. ");
INSERT INTO xon_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Le Pɔɔl ni Banabas ti fuu Jerusalem. Baah ti fuu nima na, le Yesu aanib ni baaninkpiib ni Yesu aakpambalb doon bi ni mpopiin. Le Pɔɔl ni Banabas tuk bi tiwan nimɔk Uwumbɔr cha bi ŋa na, ki tuk bi waah ter bi pu na. ");
INSERT INTO xon_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Le Farisii yaab bibaa, bi dii Yesu na, fii sil, le ki len ke binib bi kaa ye Juu yaab na yaa dii Yesu kan, ni ŋan ke bi gii ŋichakpan, ki kii Moses aakaal. ");
INSERT INTO xon_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Le Yesu aakpambalb ni Yesu aanib aaninkpiib kuun tɔb chee, ke bi kpokl tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Baah kpokl ki ti yunn na, le Piita fii sil ki bui ke, “Nnaabitiib, ni nyi ke n‑yoonn mu jer na Uwumbɔr nan lee mi ni ponn ni, ke m buen binib bi kaa ye Juu yaab na chee, ki ti tuk bi tibɔnyaan ngbaan, aan bi ŋun ki gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Uwumbɔr u nyi binib mɔmɔk aasui ni aah bi pu na nan di Waafuur Nyaan tii binib bi kaa ye Juu yaab na, ke waah tii timi pu na. ");
INSERT INTO xon_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Waah ŋa kina na, u mɔk ke u pak binib bi kaa ye Juu yaab na mu. Waa yakr timi. U po dak ke binib mɔmɔk ye tiwanbaan la. Baah gaa u ki kii na, le u finn bisui ni titunwanbir. ");
INSERT INTO xon_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nima pu na, ba pu ni muk bi, ki tɔŋni Uwumbɔr? Timi ni tiyaajatiib aah nan ban ti dii Moses aakaal na, ni nan pɔɔ ti chee. Taa ŋmaa dii. Ni bi ke lituln li nyuun na la. Ba pu ni ban ke Yesu aadidiliib ngbaan dii kina? ");
INSERT INTO xon_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Binib bi kaa ye Juu yaab na yaa gaa Tidindaan Yesu ki kii kan, waanimbaasaln pu le u ga gaa bi lii. Kina le u ga gaa ti mu lii.” ");
INSERT INTO xon_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piita aah len kina na, le bi mɔmɔk ŋmin, ki pel Banabas ni Pɔɔl aah len pu na. Le bi tuk bi Uwumbɔr aah ŋa pu ki cha bi tun lijinjiir aatun binib bi kaa ye Juu yaab na aakaasisik ni na. ");
INSERT INTO xon_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Banabas ni Pɔɔl aah len ti doo na, le Jems bui ke, “Nnaabitiib, li pel man. ");
INSERT INTO xon_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Dandana wee, Simonn Piita tuk timi Uwumbɔr aah ŋa pu njan na, ki mɔk ke utafal bi binib bi kaa ye Juu yaab na ni, ki lee bi ponn ni binib bibaa, ke bi li ye waanib. ");
INSERT INTO xon_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Uwumbɔr aabɔnabtiib nan len ke u ga ŋa kina. Ni ŋmee Uwumbɔr Aagbaŋ ponn ni ke ");
INSERT INTO xon_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Uwumbɔr len ke: Ubɔr David aanaan aah lir na, m ga gir ni aan ki nan fiin waanaan ngbaan. M ga ŋa mu nnaanpɔm, ki cha mu sil mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nima pu na, binib bi gur na ga li ban min Uwumbɔr. Ŋinibol ŋimɔk ye maanib na ga li ban mi. ");
INSERT INTO xon_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Uwumbɔr le len kina. N‑yaayoonn na ki joo cha, u nan tuk binib tibɔr timina.’” ");
INSERT INTO xon_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems nan ki bui ke, “M dak ke ti taa ki muk binib bi kaa ye Juu yaab ki kpeln baabimbin ki dii Uwumbɔr aasan na. ");
INSERT INTO xon_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Cha ti ŋmee kigbaŋ tii bi, ki tuk bi ke bi taa ki ŋmɔ kitork aanann, ki taa ki gɔr kidagook, ki taa ki ŋmɔ tiwan ni bi tab ku ni na, ki taa ki ŋmɔ nsin. ");
INSERT INTO xon_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tiyaajatiib yoonn ki di nan saa din, bi tuk binib Moses aakaal ntim mɔmɔk ponn ni. Likpaakool daal mɔmɔk bi po karni Moses aakaal mmeen aadir ni.” ");
INSERT INTO xon_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jems aah len ti doo na, le Yesu aakpambalb, ni Yesu aanib mɔmɔk, ni baaninkpiib kpokl ke bi ga nya bi ponn ni bijab bibaa, ki di kpee Pɔɔl ni Banabas pu, ki tun bi Antiok aatiŋ ni, bi ti di kigbaŋ ngbaan tii bi. Le bi nyan bijab bilee. Bi yin ubaa ke Judas Basabas, ki yin uken ke Sailas. Bijab bilee ngbaan nan ye biyidam le Yesu aanib ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Le bi ŋmee kigbaŋ ki di tun bi, bi di buen ti tii binib bi kaa ye Juu yaab na. Bi ŋmee ke: “Tinaabitiib bi kaa ye Juu yaab ki bi Antiok aatiŋ ni, ni Siria aatiŋ ni, ni Silisia aatiŋ ni na, ti dooni nimi. Timi Yesu aakpambalb, ni Yesu aanib aaninkpiib dooni nimi. ");
INSERT INTO xon_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ti ŋun ke bijab bibaa nyan ti ponn ni, ki dan ni chee, ki ti tuk nimi tibɔr ti muk nimi ki ŋa nimi ilandak na. Taa nan tuk bi ke bi tuk nimi kina. ");
INSERT INTO xon_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nima pu na, ti kuun tɔb ki kpaan kimɔbaan, ki nyan ti ponn ni bijab bilee, ke ti tun ni bi ni chee. Bi ni tijɔtiib Banabas ni Pɔɔl, bi ti gee bi na, le ti ga tun ni bi ni chee. ");
INSERT INTO xon_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Banabas ni Pɔɔl nan di baamɔfal paan talmaa Tidindaan Yesu Kristo pu. ");
INSERT INTO xon_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bijab bi ti nyan bi na le ye Judas ni Sailas. Bi mu ga tuk nimi tibɔr ngbaan aah ŋmee pu na. ");
INSERT INTO xon_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ti ni Uwumbɔr Aafuur Nyaan kpaan kimɔbaan, kaa ban ti di nkaal mu pɔɔ na kpee nimi. ");
INSERT INTO xon_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ni ŋan ke ni taa ki ŋmɔ kitork aanann, ki taa ki ŋmɔ nsin, ki taa ki ŋmɔ tiwan ni bi tab ku ni na, ki taa ki gɔr kidagook. Ni yaa kii kina kan, nima le ŋan. Uwumbɔr ter nimi.” ");
INSERT INTO xon_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Le bi di kigbaŋ ngbaan tii Banabas mam, ke bi di buen Antiok aatiŋ ni. Baah ti fuu nima na, bi nan kuun ni Yesu aanib mɔmɔk, ki di kigbaŋ ngbaan tii bi. ");
INSERT INTO xon_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Baah karn kigbaŋ ngbaan ponn ni na, le ni ŋa bi mpopiin. Ni nan ye tibɔr ti pɔɔk bitaakpab na la. ");
INSERT INTO xon_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Le Judas ni Sailas, bi ye Uwumbɔr aabɔnabtiib na, tuk bi Uwumbɔr aabɔr pam ki pɔɔk bitaakpab, ki ter bi, bi li dii mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bi nan yunn nima siib. Baah nan yunn nima siib na, le bi chɔi bi, ki gir buen Yesu aakpambalb chee.  ");
INSERT INTO xon_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sailas ma nan gaar Antiok aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔɔl ni Banabas nan ti bi Antiok aatiŋ ni, ni yunn siib. Le bi ni binib pam tuk binib Tidindaan aabɔnyaan, ki mɔk bi baah ga dii u mbamɔm pu na. ");
INSERT INTO xon_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Naah yunn siib na, le Pɔɔl bui Banabas, “Cha ti gir buen taah nan tuk binib Tidindaan aabɔr ntim mu mɔmɔk ni na, ki ti mann Yesu aanib ki lik ke bi joo Yesu aabɔr kinye?” ");
INSERT INTO xon_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Le Banabas ban ke Jɔnn Mak dii bi. ");
INSERT INTO xon_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Le Pɔɔl aa kii; ba pu? baah nan bi Pamfilia aatiŋ ni na, Jɔnn Mak nan labr kun ki cha bi, kaa ki ter bi lituln na ponn ni. Nima pu na, Pɔɔl aa nan kii ke u ki dii bi. ");
INSERT INTO xon_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Le Pɔɔl ni Banabas kpak kinikpakpak ki yakr tɔb chee, kaa ki dii tɔb. Le Banabas ni Jɔnn Mak koo buŋɔb ni, ki buen lidikl libaa pu, bi yin li ke Saiprus. ");
INSERT INTO xon_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Le Pɔɔl nyan Sailas ke u dii u. Le Yesu aanib mee Uwumbɔr tii bi, ki di bi ŋa Uwumbɔr aaŋaal ni, u ter bi. Le bi buen, ");
INSERT INTO xon_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ki bɔ dii Siria aatim ni, ni Silisia aatim ni, ki pɔɔk Yesu aanib aataakpab, ki toor tuk bi Uwumbɔr aaliin. ");
INSERT INTO xon_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔɔl mam nan ti fuu Debe aatiŋ ni, ni Listra aatiŋ ni. Le Yesu aadidiir ubaa nan bi nima. Bi yin u ke Timoti. Una nan ye Juu yaab aabo la, ki mu gaa Yesu ki kii. Ute nan ye Griik aanii la. ");
INSERT INTO xon_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yesu aanib bimɔk bi Listra aatiŋ ni, ni Ikonium aatiŋ ni na mɔmɔk nan pak Timoti. ");
INSERT INTO xon_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Le Pɔɔl ban ke Timoti li dii u. Juu yaab bimɔk bi nima na nan nyi ke Timoti aate ye Griik aanii la. Nima pu na, Pɔɔl nan gii Timoti aachakpaln ke Juu yaab aah geei pu na, le ki cha u dii bi. ");
INSERT INTO xon_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Le bi bɔ dii ntim ngbaan ponn ni, ki mann Yesu aanib. Pɔɔl mam aah nan bi Jerusalem ni na, le Yesu aakpambalb, ni Yesu aanib aaninkpiib bi nan bi nima na nan kpokl, binib bi kaa ye Juu yaab ki dii Yesu na aah ga ŋa pu na. Le Pɔɔl tuk bi baah nan kpokl ki len pu na, ke bi kii kina. ");
INSERT INTO xon_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nima pu na, Yesu aanib aataakpab nan pɔɔk waasan ni. Idaa mɔmɔk le binib biken mu gaal u ki kii, ki kpae waanib pu. ");
INSERT INTO xon_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Uwumbɔr Aafuur Nyaan aa nan kii ke Pɔɔl mam buen Asia aatiŋ ni ki ti tuk binib Yesu aabɔr. Le bi bɔ dii Frijia aatim ni, ni Galasia aatim ni, ");
INSERT INTO xon_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ki ti fuu Misia aatiŋ mɔk, ki ban bi buen Bitinia aatim ni. Le Yesu Aafuur Nyaan aa kii. ");
INSERT INTO xon_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Le bi bɔ dii Misia aatim ni, ki ti fuu Troas aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kinyeek ngbaan le Pɔɔl daŋ tidaŋ ki kan Masedonia aatiŋ aanii ubaa si u chee ki gaŋni u ke u dan Masedonia aatim ni ki nan ter bi. ");
INSERT INTO xon_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔɔl aah daŋ tidaŋ ngbaan kina na, le min Luk ni Pɔɔl mam gor ke ti buen Masedonia aatim ni. Ti nan bee ke Uwumbɔr le yin timi ke ti buen ki ti tuk kitiŋ ngbaan aanib tibɔnyaan na. ");
INSERT INTO xon_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ti nan koo buŋɔb, Troas aatiŋ ni, ki puur nnyusakpem na ki ti jer lidikl libaa, bi yin li ke Samotres. Naah woln kitaak na, le ti fuu Neapolis aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Le ti nyan buŋɔb ni, ki chuun kitiŋ ki ti fuu Filipi aatiŋ ni. Ki ye Masedonia aatiŋ kibaa, ki ye kitisakpeŋ. Rom yaab nan bi nima, ki joo kitiŋ ngbaan. Ti nan bi kitiŋ ngbaan ponn ni, ki pii iwiin ilee. ");
INSERT INTO xon_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Juu yaab aakpaakool daal, le ti nyan kitiŋ ngbaan ponn ni, ki buen limɔɔl aagbaan. Ti nan dak ke likpaakool daal mɔmɔk Juu yaab kuuni nima ke bi mee Uwumbɔr. Le ti kan bipiib kuun nima. Le ti kal ki tuk bi Uwumbɔr aaliin. ");
INSERT INTO xon_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Upii ubaa nan bi nima ki ŋun taah len pu na. Bi nan yin u ke Lidia. U nan ye Tiataira aatiŋ aapii la, ki chuun kooh ŋitanyaan aakeken ŋi kpa kidaak na. U nan ye upii u pak Uwumbɔr na la. Le Tidindaan piir usui ke u pel mbamɔm, ki gaa Pɔɔl aah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Le bi muin u ni waachiln ni aanib nnyun ni. Le u tuk timi, “Ni yaa dak ke m sil gaa Tidindaan ki kii kan, ni dan nan mann mi, ki li bi ndo.” Le u gaŋ timi, le ti buen. ");
INSERT INTO xon_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ti nan ki buen baah mee Uwumbɔr nin chee na. Taah cha na, le usapɔɔn ubaa ton timi nsan ni. U nan ye unaagbiibo la. Bininkpiib nan dii u, ki cha u tuk binib tiwan ni choo ki ga nan ŋa na aabɔr. Waah ŋani kina na, le u kan ŋimombil pam ki tii udindatiib. ");
INSERT INTO xon_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Le u paan ni ti ni Pɔɔl aapuwɔb, ki tar ke, “Bijab bimina le ye Uwumbɔr u kaa kpa ŋeen aatɔ na aanaagbiib. Bi tuk nimi naah ga ŋa pu ki ŋmar na.” ");
INSERT INTO xon_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Usapɔɔn ngbaan nan ŋani kina iwiin mɔmɔk. Waah ŋani kina na, le Pɔɔl gee liŋuul, ki fenn lik u, ki tuk bininkpiib bi dii u na, “M tuk nimi Yesu Kristo aayimbil pu, nya u ni man.” Libuul ngbaan ni le bininkpiib ngbaan nyan u ni. ");
INSERT INTO xon_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tɔ, bininkpiib ngbaan aah nyan u ni na, le udindatiib gee liŋuul. Bi bee ke waan ki kan ŋimombil tii bi. Le bi chuu Pɔɔl ni Sailas ki dar bi mpɔɔn, ki di buen kitiŋ ngbaan aabɔjirb aanimbiin ni, ");
INSERT INTO xon_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ki ti len ke, “Bijab bimina ye Juu yaab, ki muk do aanib, ");
INSERT INTO xon_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ki tuk bi nkaal mubaa. Taah ye Rom yaab na, naa ŋan ke ti gaa nkaal mue ki dii mu.” ");
INSERT INTO xon_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Baah len kina na, le kinipaak ngbaan mu gee liŋuul Pɔɔl ni Sailas pu. Le bibɔjirb ngbaan chuu peer baawan, ki tuk baatutum ke bi di ŋidabil gbaa bi. ");
INSERT INTO xon_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Le bi gbaa bi pam, ki tur bi ti ŋa kiyondiik ni, ki tuk kiyondiik aaninkpel ke u li kii bi mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Baah tuk u kina na, le u tur bi ŋa ponn ni aadiik ni, kiyondiik ni, ki baa bi ŋibaa. ");
INSERT INTO xon_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kinyetaasiik le Pɔɔl ni Sailas bi mee Uwumbɔr, ki gaa ilahn ki pak u. Le binaagbiib biken ka pel. ");
INSERT INTO xon_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Libuul ngbaan ni le kitiŋ deŋ sakpen, ki cha kiyondiik aadinyikl mu deŋ. Libuul ngbaan ni le kiyondiik aajaaleŋ mam mɔmɔk chuu piir. Le binaagbiib mɔmɔk aakululn chuu gbiln lir. ");
INSERT INTO xon_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Le kiyondiik aaninkpel finn, ki kan ke jaaleŋ mam mɔmɔk piir a. U nan dak ke binaagbiib mɔmɔk nyan a. Le u yoor waajaak aajuk ke u ku ubaa. ");
INSERT INTO xon_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Le Pɔɔl teen ke, “Taa ku aabaa. Ti mɔmɔk bi do.” ");
INSERT INTO xon_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Le kiyondiik aaninkpel teen ke, “Li joo ni karyaa,” ki san koo ni, le ki nan gbaan Pɔɔl ni Sailas aanimbiin ni, le uwon gbaa. ");
INSERT INTO xon_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Le u nyan bi lipaal, ki baa bi, “Ndindatiib, m ga ŋa kinye aan ki ŋmar?” ");
INSERT INTO xon_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Le bi bui u, “Aa yaa gaa Tidindaan Yesu ki kii kan, aa ga ŋmar, le saachiln ponn ni aanib mu ga ŋmar.” ");
INSERT INTO xon_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Le bi tuk u ni waachiln ni aanib mɔmɔk Tidindaan aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","N‑yoonn ngbaan le u di nnyun char baabuun ngbaan, baah fe gbaa lakr bi pu na. Le bi muin u ni waachiln ni aanib mɔmɔk nnyun ni. ");
INSERT INTO xon_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Le u di Pɔɔl ni Sailas buen waadichal ni, ki ti tii bi tijikaar ke bi ji. U ni waachiln ni aanib aah nan gaa Uwumbɔr ki kii na, ni ŋa bi mpopiin pam. ");
INSERT INTO xon_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Naah woln kitaak na, le bibɔjirb ngbaan tun baatutum ke bi buen ti tuk kiyondiik ni aaninkpel ke u di bijab na lii aan bi li cha. ");
INSERT INTO xon_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Le kiyondiik aaninkpel tuk Pɔɔl, “Bibɔjirb ngbaan len ke m di aa ni Sailas lii, ni li cha. Ni nya suuna ki li cha.” ");
INSERT INTO xon_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Le Pɔɔl aa kii kina. U nan bui bitutum ngbaan, “Bibɔjirb ngbaan aah ŋa pu na, naa ŋan. Timi tibaa mu po ye Rom yaab la. Baa jin timi tibɔr, kaa kan timi aataani, le ki gbaa timi binib aanimbil ni, ki di timi laŋ kiyondiik ni. Baah ŋa timi Rom yaab kina na, naa ŋan. Dandana wee, bi ban ke ti li cha, ubaa taa li nyi. Taan kii kina. Cha bibɔjirb ngbaan bibaa dan nan nyan timi.” ");
INSERT INTO xon_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Le bitutum ngbaan buen ti tuk bibɔjirb ngbaan Pɔɔl aah len pu na. Baah ŋun ke Pɔɔl ni Sailas ye Rom yaab na, le ijawaan chuu bi. ");
INSERT INTO xon_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Le bi buen Pɔɔl ni Sailas chee ki ti sɔŋ bisui, ki nyan bi kiyondiik ni, le ki gaŋ bi ke bi nya kitiŋ ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Le Pɔɔl ni Sailas siir nima chee, ki buen Lidia aadichal ni, ki ti doon Yesu aanib, ki len bi chee ki pɔɔk bitaakpab, le ki nin siir nima. ");
INSERT INTO xon_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Baah siir nima na, le bi bɔ dii Amfipolis aatiŋ ni, ni Apolonia aatiŋ ni, le ki ti fuu Tesalonika aatiŋ ni. Juu yaab aameen aadiik nan bi nima. ");
INSERT INTO xon_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Le Pɔɔl ti koo mmeen aadiik ngbaan ni, waah ti ŋani pu ŋikpaakoo mɔmɔk na. U nan di ŋikpaakoo ŋitaa le tuk bi Uwumbɔr Aagbaŋ aah len pu na aatataa, ");
INSERT INTO xon_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ki mɔk bi ke ni ye Kristo u gaa binib lii na aabɔr, ke Uwumbɔr Aagbaŋ len ke see Kristo na jin falaa, ki kpo, ki fikr nkun ni, le ki len ke waah tuk bi Yesu u aabɔr na, uma le ye Kristo ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Le Juu yaab bibaa, ni Griik yaab bi pak Uwumbɔr na ponn ni pam, ni bipiib bi ye mpɔɔndam na kii tii Pɔɔl aah len pu na, ki kpaan u ni Sailas chee. ");
INSERT INTO xon_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Le Juu yaab bi kaa kii tii u na nan kpa lipiipoln u pu, ki kuun ni binib bi kaa ŋan, kaa bi tibɔr tibaa ni na, ki cha kitiŋ ngbaan aanib mɔmɔk gee liŋuul, ki kpa kifuuk, ki ŋma tijar, le ki buen uja u bi yin u ke Jasonn na do, ki ban bi koo ni. Le waa kii. Le bi koo mpɔɔn, ki ti bi ban Pɔɔl ni Sailas, ke bi nyan bi buen kinipaak ngbaan chee, ");
INSERT INTO xon_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","le kaa kan bi. Baah kaa kan bi na, le bi chuu Jasonn ni Yesu aanib bibaa mpɔɔn, ki di buen kitiŋ ngbaan aaninkpiib chee, le ki ti teen ke, “Pɔɔl mam bi muk binib ntim mɔmɔk ponn ni na dan do mu, ");
INSERT INTO xon_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","le Jasonn cha bi bi udo. Bi bii Ubɔrkpaan Siisa aakaal mɔmɔk ki len ke ubɔr uken bi, bi yin u ke Yesu.” ");
INSERT INTO xon_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Juu yaab aah len kina na, le kinipaak, ni kitiŋ ngbaan aaninkpiib gee liŋuul Pɔɔl ni Sailas pu. ");
INSERT INTO xon_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Le bi cha Jasonn mam pan ŋimombil ke bi di bi lii. Le bi pan, le bi di bi lii. ");
INSERT INTO xon_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kinyeek ngbaan le Yesu aanib cha Pɔɔl ni Sailas siir buen Berea aatiŋ ni. Baah ti fuu na, le bi buen Juu yaab aameen aadiik ni. ");
INSERT INTO xon_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Le binib bi bi nima na pel Pɔɔl aah len pu na. Binib ngbaan ye binib ki jer Tesalonika aatiŋ ni yaab. Le binimbil man Pɔɔl aah len pu na pu. Idaa mɔmɔk bi nan kpar Uwumbɔr Aagbaŋ ponn ni, ki karni ke bi lik ke ti gbii aan taa gbii. ");
INSERT INTO xon_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nima pu na, bi ponn ni pam nan gaa Yesu ki kii. Griik yaab bi nan ye bininyuum na, bijab ni bipiib, mu gaa u ki kii ki wiir. ");
INSERT INTO xon_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Le Juu yaab bi bi Tesalonika aatiŋ ni na ŋun ke Pɔɔl bi Berea aatiŋ ni ki bi tuk binib Uwumbɔr aabɔr. Le bi mu buen nima ki ti cha kinipaak na ŋma tijar Pɔɔl pu. ");
INSERT INTO xon_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Libuul ngbaan ni, le Yesu aanib cha Pɔɔl siir buen ki dii nsan mu cha nnyusakpem aagbaan na. Sailas ni Timoti ma nan bee Berea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Le Yesu aanib bi cheen Pɔɔl na nan cheen u ti saa Atens aatiŋ ni. Le Pɔɔl tuk bi ke bi ti tuk Sailas ni Timoti ke bi chuun mala ki dan u chee. Waah tuk bi kina na, le binib bi cheen u na gir buen Berea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Le Pɔɔl ti bi Atens aatiŋ ni, ki ka kii Sailas ni Timoti. Waah bi nima na, le u kan ŋiwaa pam kitiŋ ngbaan ponn ni. Le ni bii usui sakpen. ");
INSERT INTO xon_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Likpaakool daal le u koo mmeen aadiik ni, ki tuk Juu yaab, ni binib bi pak Uwumbɔr na Yesu aabɔr. Le bi gbaa tɔb chee tibɔr ngbaan. Idaa mɔmɔk u nan chaa kinyaŋ ni, ki ti tuk binib bi bi nima na Yesu aabɔr. Le u ni bi gbaa tɔb chee tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Binib bibaa mu nan bi kitiŋ ngbaan ponn ni. Bi yin bibaa ke Epikurus aanib, ki yin bibaa mu ke Stoik aanib. Baah ŋun Pɔɔl aah len pu na, le bibaa baa tɔb, “Ulambidaan ngbaan len kinye?” Le bibaa mu bui ke bi dak ke u len ŋiwaa yayan ŋibaa aabɔr la. Pɔɔl ma nan bi len Yesu aabɔnyaan, ke u fikr nkun ni. ");
INSERT INTO xon_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bi nan yin kitiŋ ngbaan aaninkpiib ke Areopagus aanib. Le bi di Pɔɔl buen bininkpiib ngbaan chee, le ki ti bui u ke waah tuk binib tibɔchann ti na, bi ban ke u tuk bi mu, bi bee, ");
INSERT INTO xon_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ke waah len pu na, ni gar bi, bi ban ke u tuk bi mu taatataa. ");
INSERT INTO xon_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atens aatiŋ aanib, ni bicham bi nan bi nima na, nan gee ke bi li kuun ni ki gbaa tɔb chee tibɔchann n‑yoonn mɔmɔk. Nima pu le bi ban bi ŋun Pɔɔl yaar mu. ");
INSERT INTO xon_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Le Pɔɔl sil bikaasisik ni, ki len ke, “Atens aatiŋ aanib, m bee ke nitafal bi ŋiwaa aabɔr ni pam. ");
INSERT INTO xon_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","M chuun nimi aatiŋ ponn ni ki kan naah dooni ŋiwaa pu na, le ki kan bi nan ŋmee ŋŋmeen naah toor kitork nin chee na. Bi ŋmee ke, ‘Taah kaa nyi Uwumbɔr u na.’ Ni dooni Uwumbɔr, ki mu aa nyi u. Waabɔr le m ban m tuk nimi dandana wee. ");
INSERT INTO xon_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Uwumbɔr nan naan dulnyaa wee, ni tiwan nimɔk bi ni ponn ni na. Uma le ye paacham ni taab Aadindaan. Waa bi liwaal aadiik ni. ");
INSERT INTO xon_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Uma ubaa le tii binib mɔmɔk limɔfal, ni libuln li ti fuur na, ni tiwan mɔmɔk. Waah ban pu na, u kpa. Unii yaa tun lituln tii uma Uwumbɔr kan, naa kpae Uwumbɔr nibaa. ");
INSERT INTO xon_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Njan u nan naan uja ubaa, uma le ye ŋinibol mɔmɔk aayaaja. Uma Uwumbɔr le cha ŋinibol mɔmɔk bi dulnyaa wee mɔmɔk ponn ni. U nan siin n‑yoonn mu binib mɔmɔk ga li bi na, ki siin nin chee bi mɔmɔk ga li bi na. ");
INSERT INTO xon_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Waah nan naan binib na, u ban ke bi li ban u. U dak ke nibaakan bi ga baa ki ban u, ki kan u. Waa daa unii ubaa chee. U po mal timi la. ");
INSERT INTO xon_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Uma pu le ti fu, ki chuun, ki bi. N‑yaayoonn na, nimi aalankpalb bibaa nan len ke, ‘Ti ye Uwumbɔr aabim la.’ Baah len pu na, ti gbii. ");
INSERT INTO xon_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Taah ye Uwumbɔr aabim na, taa cha ti li dak ke Uwumbɔr aabimbin bi ke ŋiwaa na. Ŋiwaa po ye ŋitakpal le bi kpii ŋi, bee salmaa, bee tikunabr le bi di mɔɔ ŋi. ");
INSERT INTO xon_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Binib aah kaa nan kee nyi Uwumbɔr aasan buyoonn na, waa nan gar baah ŋani pu na. Dandana wee le u len ke u ban ke binib bimɔk bi dulnyaa wee mɔmɔk ponn ni na kpeln baabimbin ki dii waasan. ");
INSERT INTO xon_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ba pu? u siin nwiin bundaln u ga ji binib mɔmɔk tibɔr na, ki ti saa baah ŋa ki ŋeer pu na. U nyan uja u ga ji binib tibɔr na. U nan fikr uja ngbaan nkun ni, nima le ye limɔkl tii binib mɔmɔk.” ");
INSERT INTO xon_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Binib ngbaan aah ŋun Pɔɔl len ke Uwumbɔr fikr unii nkun ni na, le bibaa ŋani u mbɔnyun. Le bibaa mu len ke bi ban bi ki ŋun tibɔr ngbaan. ");
INSERT INTO xon_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Le Pɔɔl siir nima ki buen. ");
INSERT INTO xon_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Le bijab bibaa gaa Yesu ki kii, ki kpaan Pɔɔl chee. Bi yin ubaa ke Dionisius, u nan ye Areopagus aanii ubaa na. Uken mu nan ye upii u bi yin u ke Damaris na. Binib biken mu nan gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔɔl nan siir Atens aatiŋ ni, ki di buen Korint aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Waah bi nima na, le u kan Juu yaab aaja ubaa, bi yin u ke Akuila. Bi nan ma u Pontus aatiŋ ni la. Bi yin upuu ke Prisila. Bi nan bi Itali aatisakpeŋ Rom ni. Le Ubɔrkpaan Klɔdius nan siin nkaal ke Juu yaab mɔmɔk nya Rom aatiŋ ponn ni. Nima pu le Akuila ni Prisila nan nyan nima, ki dan Korint aatiŋ ni. Bi nan fuu ni naa yunn, le Pɔɔl nan ti kan bi. ");
INSERT INTO xon_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Uja ngbaan ni upuu nan jab igban le ki gaal ŋiboo. Baatuln le nan bi na. Pɔɔl aatuln ni baatuln kpaa la. Nima pu le u nan ti bi bido. Le bi tun lituln ngbaan tɔb chee. ");
INSERT INTO xon_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Likpaakool daal mɔmɔk kan, Pɔɔl nan chaa mmeen aadiik ni. Juu yaab ni Griik yaab mu nan bi nima. Le u ni bi gbaa tɔb chee Yesu aabɔr. Le u pɔɔni ubaa ki ban ke bi gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas ni Timoti nan nyan ni Masedonia aatim ni, ki fuu ni Pɔɔl chee. Baah fuu ni na, le Pɔɔl mooni Yesu aabɔr linimaln, kaa ki tun lituln liken. U nan ŋeer tuk Juu yaab ke Yesu le ye Kristo u gaa binib lii na. ");
INSERT INTO xon_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Le bi kpak u kinikpakpak, ki seei u. Baah ŋa kina na, le Pɔɔl chuu waakekeln gbuk ki nyan kitangbaak, ni ye nsurm le ki tii bi, le ki bui bi, “Ni yaa kaa ŋmar kan, nimi aasin ga li bi nimi nibaa aaŋaal ni la, naa ye maataani. M ga di cha nimi, ki tuk binib bi kaa ye Juu yaab na le Yesu aabɔr.” ");
INSERT INTO xon_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Le u siir cha bi, ki buen unii ubaa do, bi yin u ke Titius Justus, u nan ye unii u pak Uwumbɔr na. Udo ni mmeen aadiik si gbɔk tɔb la. ");
INSERT INTO xon_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mmeen aadiik aaninkpel u bi yin u ke Krispus na, ni waachiln ni aanib mɔmɔk gaa Tidindaan ki kii. Le Korint aatiŋ aanib pam mu ŋun Yesu aabɔr, ki gaa u ki kii. Le bi muin bi nnyun ni. ");
INSERT INTO xon_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kinyeek kibaa daal, le Pɔɔl daŋ tidaŋ, le Tidindaan bui u, “Taa ki san ijawaan. Aa li beenin tuk binib tibɔnyaan ngbaan. Taa di cha. ");
INSERT INTO xon_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","M bi aa chee. Ubaa aan ŋmaa ŋa si nibaa. Kitiŋ kee ponn ni, binib pam ye maanib la.” ");
INSERT INTO xon_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kina pu na, Pɔɔl nan bi nima ki ti saa libiln libaa ni ligeln, ki tuk binib Uwumbɔr aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Korint aatiŋ nan bi Akaya aapepel ni la. Akaya ngbaan mɔmɔk aaninkpel nan ye uja u bi yin u ke Galio na. Waayoonn ngbaan le Juu yaab kuun ki nan chuu Pɔɔl, ki di u buen uma Galio aanimbiin ni, ");
INSERT INTO xon_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ki len ke Pɔɔl tuk bi baah ga ŋa pu ki doon Uwumbɔr na, kaa tuk bi mbamɔm, ke u bii baatiŋ aakaal la. ");
INSERT INTO xon_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔɔl aah ban ke u len na, le Galio tuk Juu yaab, “U yaa ba ŋa bakaa ni kinimbɔŋ kibaa kan, m ba ga ji u tibɔr. U mu aa ŋa nibaa. ");
INSERT INTO xon_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nimi Juu yaab, ni kpak tɔb iliin pu, ni binib aabɔr pu, ni nimi aakaal pu la. Ni bi ni chee la, naa ye maabɔr. Maan ji tibɔr ngbaan.” ");
INSERT INTO xon_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Le u jenn nyan bi bibɔjirb aadiik ni. ");
INSERT INTO xon_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Le bi mɔmɔk chuu mmeen aadiik aaninkpel u bi yin u ke Sosenes na, le ki gbaa u libɔjil aadiik chee. Le Galio aatafal aa nan bi ni ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔɔl nan bi Korint aatiŋ ni ki yunn. Waah bi nima ki yunn na, le u chɔi Yesu aanib. Le u ni Prisila ni Akuila buen Senkrea aatiŋ ni. Pɔɔl aah ti bi nima na, le u kuu uyikpir lii. Ni mɔk ke waah nan puu tipuur ti tii Uwumbɔr na le na. Le bi nan ti koo buŋɔb ni, ke bi puur nnyusakpem na ki buen Siria aatim ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Le bi ti fuu Efesus aatiŋ ni, ki nyan buŋɔb na ni. Le Pɔɔl buen mmeen aadiik ni. Le u ni Juu yaab ti gbaa tɔb chee Yesu aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Le bi ban ke u yunn bi chee. Le waa kii, ");
INSERT INTO xon_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","le ki chɔi bi, ki tuk bi ke Uwumbɔr yaa kii kan, u ga ki gir ni bi chee. Le u ki labr ti koo buŋɔb ni, ki cha Prisila ni Akuila nima, ki buen, ki ti fuu Siisarea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Waah ti fuu nima na, le u nyan buŋɔb na ni, ki buen Jerusalem, ki ti doon Yesu aanib bi nan bi nima na, le ki nyan buen Antiok aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ki ti yunn nima siib, le ki bɔ dii Galasia aatim ni, ni Frijia aatim ni, ki mann Yesu aanib, ki pɔɔk bitaakpab. ");
INSERT INTO xon_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juu yaab aanii ubaa nan bi, bi yin u ke Apolos. Bi nan ma u Aleksandria aatiŋ ni la. Le u dan Efesus aatiŋ ni. U nan ye unii u nyi tibɔr aalem na, ki nyi tibɔr ti ŋmee Uwumbɔr Aagbaŋ ni na mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Binib nan tuk u Tidindaan Yesu aasan aabɔr, le unimbil man tibɔr ngbaan pu. U nan len binib chee, ki tuk bi Yesu aabɔr mbamɔm. U mu aa nyi Yesu aah gbiini binib Uwumbɔr Aafuur Nyaan pu na. U po nyi Jɔnn aah nan muini binib nnyun ni pu na la. ");
INSERT INTO xon_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Le Apolos koo mmeen aadiik ni, ki tuk binib Yesu aabɔr ni lipobil. Le Prisila ni Akuila ŋun waah tuk bi pu na. Baah ŋun na, le bi di u di buen bido, ki ti toor tuk u Uwumbɔr aasan aabɔr mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","28","Tɔ, Apolos nan ban ke u buen Akaya aatim ni. Le Yesu aanib bi bi Efesus aatiŋ ni na ter u, ke u buen, le ki ŋmee kigbaŋ tii u ke u ti tii Yesu aanib bi bi Akaya aatim ni na, ke bi chann u tichann. Waah ti fuu nima na, le Juu yaab bi bi nima na nan kpak u kinikpakpak. Le u len tibɔr nyaŋ bi, ki mɔk bi binib aanimbil ni ke Uwumbɔr Aagbaŋ len ke Yesu sil ye Kristo u gaa binib lii na. Apolos aah ŋa kina na, u nan ter binib bi kan Uwumbɔr aanimbaasaln ki gaa Yesu ki kii na. ");
INSERT INTO xon_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","N‑yoonn mu Apolos nan laa bi Korint aatiŋ ni na, le Pɔɔl bɔ dii ŋijoo aatiŋ ni, ki ti fuu Efesus aatiŋ ni. Waah ti fuu nima na, le u kan Yesu aanib bibaa. ");
INSERT INTO xon_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Le u baa bi, “Naah gaa Yesu ki kii na, ni gbii Uwumbɔr Aafuur Nyaan aa?” Le bi bui u, “Taa kan, ki mu aa ŋun ke Uwumbɔr Aafuur Nyaan bi.” ");
INSERT INTO xon_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Le Pɔɔl baa bi, “Ni yaa ye kina kan, bi muin nimi nnyun ni kinye?” Le bi bui u, “Bi muin timi nnyun ni ke Jɔnn aah nan ŋani pu na la.” ");
INSERT INTO xon_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Le Pɔɔl bui bi, “Jɔnn nan muin binib bi kpeln baabimbin na nnyun ni, ki tuk bi ke bi gaa unii u ga paan ni upuwɔb na ki kii. Uma le bi yin u ke Yesu.” ");
INSERT INTO xon_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pɔɔl aah tuk bi kina na, le bi cha u muin bi nnyun ni, Tidindaan Yesu aayimbil pu. ");
INSERT INTO xon_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Le u di uŋaal paan bi pu. Le Uwumbɔr Aafuur Nyaan sunn ni bi pu. Le bi len iliin yayan, le ki nabr Uwumbɔr aah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bi ga nan li fuu bijab kipiik ni bilee. ");
INSERT INTO xon_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Likpaakool mɔmɔk daal kan, Pɔɔl nan chaa mmeen aadiik ni, ki ti saa iŋmal itaa, ki len binib chee ni lipobil, le ki tuk bi Uwumbɔr aanaan aabɔr. Le bi ni Pɔɔl gbaa tɔb chee tibɔr ngbaan. Pɔɔl nan pɔɔni ubaa ke u mɔk bi ke waah len ti na gbii. ");
INSERT INTO xon_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Le bi ponn ni bibaa aatafal pɔɔ. Baa kii tii waaliin, le ki len tibɔr ti kaa ŋan na Tidindaan aasan pu, kinipaak aanimbil ni. Kina pu le Pɔɔl siir cha bi, ki di binib bi dii Yesu aasan na buen uja u bi yin u ke Tiranus na aadisakpeŋ ki ponn ni binib ŋmaa kuun ni na. Idaa mɔmɔk le u ni binib gbaa tɔb chee Yesu aabɔr nima. ");
INSERT INTO xon_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U nan ŋani kina ki ti saa ŋibin ŋilee. Waah ŋa kina ŋibin ŋilee ngbaan pu na, le Asia aatiŋ aanib mɔmɔk, bi ye Juu yaab na, ni bi kaa ye Juu yaab na mɔmɔk ŋun Tidindaan aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Uwumbɔr nan cha Pɔɔl tun lijinjiir aatun ki ti nyaŋ. Binib aa nan kee kan kina. ");
INSERT INTO xon_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Le bi yoor Pɔɔl aakekengen ŋi u joo per unimbil wɔb na, ni ŋikeken ŋi u joo biini unimbiin ni na, ki ti di paan bibum pu, ni tiyayaar aah joo bi na mu pu. Baah ŋani kina na, libuul ngbaan ni le bi pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Tɔ, Juu yaab aanii ubaa mu nan bi nima. Bi yin u ke Skefa. U nan ye Uwumbɔr aatotoorninkpel ubaa la, ki nan kpa japɔtiib bilole. Ujapɔtiib nan chuun chaa ntim ntim ponn ni, ki nyani tiyayaar binib ni. Le bi ban ke bi di Tidindaan Yesu aayimbil nyan tiyayaar uja ubaa ni, le ki bui tiyayaar ngbaan, “M tuk nimi Yesu u Pɔɔl mooni waabɔr na aayimbil pu, nya li cha man.” ");
INSERT INTO xon_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Le tiyayaar ngbaan bui bi, “M nyi Yesu, ki nyi Pɔɔl. Nimi ma kan, ŋma ye nimi?” ");
INSERT INTO xon_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Le uja u tiyayaar joo u na nan chuu bi, ki gbaa lakr bi, ki gaa baawanpeenkaan ki nyaŋ bi. Le bi mɔmɔk san biŋmeen ki nyan udo. ");
INSERT INTO xon_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Le Efesus aatiŋ aanib bi ye Juu yaab na, ni bi kaa ye Juu yaab na mɔmɔk ŋun tibɔr ngbaan. Le ijawaan chuu bi mɔmɔk. Le bi nyuŋ Tidindaan Yesu. ");
INSERT INTO xon_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","19","Le binib bi gaa Yesu ki kii na pam nan dan Pɔɔl chee, ki nan kpiir ki tuk u binib aanimbil ni, baah nan ŋani inyɔk pu na. Bi ponn ni pam nan kpa inyɔk aagbann. Le bi di inyɔk aagbann ngbaan see mmii ni, binib mɔmɔk aanimbil ni. Le bi kahn inyɔk aagbann ngbaan aadaak, le ni ye iwiin ŋichur piiŋmu aapal. ");
INSERT INTO xon_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Le Tidindaan aaliin moo moon ŋipepel mɔmɔk, ki moo kan mpɔɔn. ");
INSERT INTO xon_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nee aapuwɔb, le Pɔɔl nan ban ke u bɔ dii Masedonia aatim ni, ni Akaya aatim ni, ki nin buen Jerusalem. Le u ŋa nlandak ke u yaa buen Jerusalem aatiŋ ni kan, u ga ti buen Rom aatiŋ mu ni. ");
INSERT INTO xon_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Le u nyan binib bi ter u na ponn ni bilee, bi yin ubaa ke Timoti, ki yin uken ke Erastus, le ki cha bi loln u pu nsan ki cha Masedonia aatiŋ ni. Uma Pɔɔl nan laa beenin bi Asia aatiŋ ni, ki yunn siib. ");
INSERT INTO xon_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","N‑yoonn ngbaan, le Efesus aatiŋ aanib ŋma tijar Tidindaan aasan pu. ");
INSERT INTO xon_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Unii ubaa nan bi nima, bi yin u ke Demetrius. U nan di tikunabr le mɔɔ ŋidichal waatiir ŋi bi ke liwaal li bi yin li ke Atemis na aadichal na, aan ki joo kooh binib pu. Le binib pam mu tun lituln ngbaan, ki kan tinyoor pam. ");
INSERT INTO xon_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Le Demetrius kuun binib bimɔk tun lituln ngbaan na, ki bui bi ke, “Njɔtiib, ni nyi ke timi aatuln kpa tinyoor pam. ");
INSERT INTO xon_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pɔɔl mu bi bii timi aatuln la. Ni kan aa? Ni ŋun waah len pu na. U len ke ŋiwaa ŋi binib mɔɔ ŋi na aa ye nibaa. Binib bi bi Efesus aatiŋ ni do, ni Asia aapepel mɔmɔk ponn ni na pam pak waah len pu na, kaa ki dii ŋiwaa. ");
INSERT INTO xon_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","U yaa beenin ŋani kina kan, u ga bii timi aatuln. Atemis, li ye liwaal sakpeln na aadichal ga bee fam. Atemis li Asia aatim aanib, ni dulnyaa ni aanib mɔmɔk dooni li na, mu ga ŋa fam, kaan ki li bi tibɔr tibaa ni.” ");
INSERT INTO xon_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Binib ngbaan aah ŋun kina na, le bi gee liŋuul sakpen, ki tar ke, “Atemis li ye Efesus aatiŋ aanib aawaal na ye liwaal sakpeln la.” ");
INSERT INTO xon_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Le kitiŋ ngbaan aanib mɔmɔk kpa kifuuk ki ŋma tijar, le ki chuu Pɔɔl aajɔtiib bilee, Gayus ni Aristakus, ki di san mala buen binib aah kuuni nin chee na, mpaan sakpiin ni. Gayus ni Aristakus nan ye Masedonia aatiŋ aanib bilee bi dii Pɔɔl waasachuln ponn ni na la. ");
INSERT INTO xon_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Le Pɔɔl ubaa nan ban ke u buen kinipaak na aah kuun nin chee na, u ti len bi chee. Le Yesu aanib aa cha u buen. ");
INSERT INTO xon_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Kitiŋ ngbaan aaninkpiib ponn ni bibaa nan ye Pɔɔl aajɔtiib la. Bi mu nan tun unii Pɔɔl chee ke u ti tuk u ke u taa buen kinipaak ngbaan aah kuun nin chee na. ");
INSERT INTO xon_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kinipaak ngbaan nan kpa kifuuk sakpen; bibaa nan tar ki len tibaa, bibaa mu nan tar ki len tiken. Baa nyi budabu pu bi kuun ni nima chee na. ");
INSERT INTO xon_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Le Juu yaab bi nan bi nima na nan nyan uja ubaa bi yin u ke Aleksanda, ke u sil kinipaak ngbaan aanimbiin ni. Nima pu na, binib bibaa mu nan dak ke ni ye uma Aleksanda aabɔr la. Le u yoor uŋaal ki nyii bi pu, ki ban ke u tuk bi ke naa ye Juu yaab aabɔr. ");
INSERT INTO xon_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kinipaak ngbaan aah bee ke u ye Juu yaab aanii na, le bi kpaan ki teen nfumbaa ke, “Atemis li ye Efesus aatiŋ aanib aawaal na ye liwaal sakpeln la.” Bi nan tar kina ki ti saa tikur tilee. ");
INSERT INTO xon_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Le kitiŋ ngbaan aaninkpel ubaa dan nan nyii bi pu, ke bi di cha kifuuk. Baah di cha na, le u len ke, “Efesus yaab, binib mɔmɔk nyi ke nimi Efesus yaab lik Atemis ni laadichal pu la, ki nyi ke Atemis ye liwaal sakpeln li nyan ni kitaapaak ki sunn ni kitiŋ na. ");
INSERT INTO xon_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ubaa aan ŋmaa nee ke taa gbii. Sɔŋ nisui man, ki taa tun lituln fam. ");
INSERT INTO xon_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nimi le joo ni bijab ngbaan do chee na. Baa sun tiwan liwaal aadichal ponn ni, kaa sii timi aawaal. ");
INSERT INTO xon_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrius mam ni unii ubaa yaa kpa tibɔr kan, bibɔjirb bi, libɔjil daal mu bi. Cha bi buen nima ki ti len. ");
INSERT INTO xon_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nimi aaninkpiib mu yin binib ki kuun bi, ke bi nan ji tibɔr. Ni yaa kpa tibɔr kpee kan, bi ga len ti mu. ");
INSERT INTO xon_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ni kpa kifuuk ki ŋma tijar din. Nibaakan, timi aatiŋ aaninkpiib ga ji timi tibɔr kifuuk ngbaan pu. Nibaa aa bi ni ponn ni, ni po kpa kifuuk fam la. Bi yaa baa timi kifuuk ngbaan pu kan, taa nyi taah ga len pu na.” ");
INSERT INTO xon_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Waah len kina na, le u cha bi mɔmɔk siir. ");
INSERT INTO xon_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kifuuk ngbaan aah ti ŋmin na, le Pɔɔl yin Yesu aanib ke bi dan u chee, ki nan len bi chee tibɔr, ki pɔɔk bitaakpab, ki chɔi bi, le ki buen Masedonia aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Le u bɔ dii ntim mu bi nima na ni, ki mann Yesu aanib bi bi nima na, ki len bi chee tibɔr pam, ki pɔɔk bitaakpab, ki ti fuu Griis aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ki nan bi nima ki pii iŋmal itaa, le ki ban u koo buŋɔb ni, ki buen Siria aatiŋ ni. Le u ŋun ke Juu yaab kpokl ke u yaa koo buŋɔb na ni kan, bi ga ku u. Waah ŋun kina na, le waa buen, ki len ke u ga labr jer Masedonia aatim. ");
INSERT INTO xon_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Le binib bibaa nan dii u. Binib bi nan dii u na aayimbil nan ye Sopata, u nan ye Berea aatiŋ aanii, ki nan ye Pirus aajapɔɔn na; ni Aristakus, ni Sekundus, bi nan ye Tesalonika aatiŋ aanib na; ni Gayus, u nan ye Debe aatiŋ aanii na; ni Tikikus, ni Trofimus, bi nan ye Asia aatiŋ aanib na; ni Timoti. ");
INSERT INTO xon_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Le bi mɔmɔk loln nsan ki buen Troas aatiŋ ni, ki ti kii timi nima. ");
INSERT INTO xon_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Le ti nan bi Filipi aatiŋ ni, ki ti saa bundaln Juu yaab ji njim ki ŋmɔ boroboro u kaa kpa nnyɔk na. Liyaadaal ngbaan aah jer na, le ti koo buŋɔb ni ki buen. Ti di iwiin iŋmu le fuu Troas aatiŋ ni, ki ti pii tijɔtiib nima. Le ti nan bi nima ki ti saa iwiin ilole. ");
INSERT INTO xon_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Likpaakool ponn ni, njan aawiin daal, le ti kuun tɔb chee ke ti nan ji Tidindaan aajikaar. Le Pɔɔl len bi chee Uwumbɔr aabɔr le kitaak ti siir. U nan ban ke kitaak yaa woln kan, u buen cha bi. Nima le cha u len bi chee tibɔr kitaak ti siir. ");
INSERT INTO xon_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Taah kuun paacham aadiik ni na, karyaa mam nan wiir ki ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Unachipɔɔn ubaa nan bi nima, bi yin u ke Yutikus. U nan ka kiditatar aatakolu pu, le ngeen chuu u. Pɔɔl aah bi len tibɔr ki yunn na, le u geen, ki ker lir kitiŋ. Le bi mɔmɔk nyan ni, ki sunn ti yoor u. U mu kpo a. ");
INSERT INTO xon_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Le Pɔɔl mu nyan ni, ki sunn buen bi chee, ki ti doon paan u pu, le ki di uŋaal kpal u, le ki bui bi, “Chuu nibaa man. Waa kpo. U bi.” ");
INSERT INTO xon_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Le Pɔɔl gir koo paacham aadiik ngbaan ni, ki ti jin bi chee tijikaar, ki ki len bi chee tibɔr ki yunn, hali ki ti woln kitaak. Naah woln na, le u buen cha bi. ");
INSERT INTO xon_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Le bi yoor unachipɔɔn ngbaan di buen udo. Waah fikr na, le bisui sɔŋ mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Le ti loln nsan ki koo buŋɔb ni, ki puur buen Asos aatiŋ ni. Pɔɔl ma nan chuun kitiŋ, ki mu buen nima, le ti ti keln tɔb. Pɔɔl nan tuk timi ke u mu ga koo buŋɔb na ni nima. ");
INSERT INTO xon_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Waah ti pii timi Asos aatiŋ ni na, le ti yoor u ŋa buŋɔb na ni, le ti di buen Mitilene aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ti nan nyan nima ki nabr buen. Naah woln kitaak na, le ti fuu lidikl libaa chee, bi yin li ke Kios, ki ki woln kitaak, le ti fuu lidikl liken chee, bi yin li ke Samos, ki ki woln kitaak le ti nan fuu Miletus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Le Pɔɔl ban u fuu Jerusalem mala. U nan ban ke u pɔɔn ubaa ki fuu nima Pentekost aawiindaal. Nima pu na, waa nan ban ke u yunn Asia aatiŋ ni. Le u bui ke u ga gɔln Efesus aatiŋ, waan dii nima. ");
INSERT INTO xon_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Le Pɔɔl tun unii ke u buen Efesus aatiŋ ni ki ti yin ni Yesu aanib aaninkpiib, ke bi dan u chee Miletus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Baah fuu ni u chee na, le u bui bi, “Maah nan fuu Asia aatiŋ ni, ki nan bi ni chee na, ni nan bee maabimbin aah nan bi pu n‑yoonn ngbaan mɔmɔk na. ");
INSERT INTO xon_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ni nan bee ke m sunn mbaa taab, ki tun Tidindaan aatuln ni tinyunyunn, ki kan falaa Juu yaab chee, baah kpokl n‑yoonn mɔmɔk ke bi ŋa mi bakaa pu na. ");
INSERT INTO xon_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","M buen binib aah kuuni nin chee na, ki buen nido mu, ki tuk nimi Yesu aabɔr. M tuk nimi tibɔr timɔk ga ter nimi na, kaa gur tibaa. ");
INSERT INTO xon_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","M sur Juu yaab ni binib bi kaa ye Juu yaab na mu, ke bi kpeln baabimbin ki dii Uwumbɔr aasan ki gaa Tidindaan Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Dandana wee m kii Uwumbɔr Aafuur Nyaan aamɔb le ki cha Jerusalem ni, kaa nyi baah ga ti ŋa mi nima chee pu na. ");
INSERT INTO xon_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","M po nyi ke ntim mɔmɔk ponn ni, Uwumbɔr Aafuur Nyaan sur mi ke bi ga di mi ŋa kiyondiik ni, ki ŋa mi falaa. ");
INSERT INTO xon_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tɔ, m yaa kpo, bee m yaa bi kan, ntafal aa bi ni ni. Tidindaan Yesu tii mi lituln, ke m tuk binib tibɔnyaan ngbaan, ke Uwumbɔr gee bi. Ntafal bi lituln ngbaan ponn ni, ke m tun li ti doo. ");
INSERT INTO xon_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Maah nan bi ni chee na, m nan chuun tuk nimi Uwumbɔr aanaan aabɔr. M nyi ke ni ponn ni ubaa aan ki kan mi. ");
INSERT INTO xon_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Din, m tuk nimi mbamɔn la, unii ubaa ni ponn ni yaa kaa kan limɔfal li kaa kpa ndoon na kan, naa ye maataani. ");
INSERT INTO xon_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","M tuk nimi Uwumbɔr aabɔr mɔmɔk, kaa gur tibaa. ");
INSERT INTO xon_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ni li nyi man, ki taa cha unii ubaa ŋmann nimi. Ni li ter Yesu aanib, ki taa cha unii ubaa ŋmann bi mu. Uwumbɔr Aafuur Nyaan nan ŋa nimi waanib aaninkpiib. Ni li joo waanib ngbaan mbamɔm. Waabo nan dan nan kpo bi pu, ke bi kpaln waanib la. ");
INSERT INTO xon_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","M nyi ke m yaa kaa ki bi ni chee kan, binib ga dan nan bii nimi, ke ŋisapol aah chuun chur ipiih pu na. ");
INSERT INTO xon_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Binib bibaa mu bi ni ponn ni, ki ga bii Uwumbɔr aaliin ke bi ŋmann Yesu aanib, bi taa ki li dii waasan. Bi ga li ban ke bi dii bima la. ");
INSERT INTO xon_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nima pu na, ni li nyi man, ki li teer ke ŋibin ŋitaa le na, m nan bi ni chee ki sur nimi ni tinyunyunn, nwiin pu ni kinyeek. ");
INSERT INTO xon_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Nnaabitiib, m di nimi ŋa Uwumbɔr aaŋaal ni, ke u li lik nimi. M tuk nimi waaliin i mɔk timi waah gee timi pu na. Waaliin ngbaan ga ter nimi, ke ni dii waasan mbamɔm. U ga di lifaal tii nimi, ni binib bimɔk bi chain na. ");
INSERT INTO xon_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Maah nan bi ni chee na, maa nan ban unii ubaa aamombil, kaa ban unii ubaa aawanpeenkaan. ");
INSERT INTO xon_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","M ni njɔtiib yaa nan ban tiwan ni na kan, min mbaa le nan tun lituln, le ki kan taah ban tiwan ni na. Nimi nibaa nyi kina. ");
INSERT INTO xon_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Maah tun lituln kina na, m mɔk nimi ke ni mu li tun kina, ki ter bibum, ki li teer ke Tidindaan Yesu ubaa nan len ke, ‘Uwumbɔr aanyoor bi unii u tii na pu ki jer u gaa na pu.’” ");
INSERT INTO xon_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔɔl aah len doo na, le bi mɔmɔk gbaan bitaŋaayil pu, ki mee Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Le bi mɔmɔk ubaabaa chaa ki ti joo biŋaal kpalni Pɔɔl, ki joo bumɔb moor utakpiln, ki wii. ");
INSERT INTO xon_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Waah tuk bi ke baan ki kan u na, le ni bii bisui sakpen. Le bi cheen u buen u ti gir koo buŋɔb ngbaan ni. ");
INSERT INTO xon_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tɔ, ti nan chɔi bi, le ki koo buŋɔb ngbaan ni, le ki puur ki ti fuu lidikl libaa chee, bi yin li ke Kos; ki woln kitaak, le ti fuu Rodes aatiŋ ni, ki nyan nima, ki buen Patara aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","le ki ti kan buŋɔb bu ga buen Fonisia aatiŋ ni na. Le ti nyan ti koo bu ponn ni, ki cha. ");
INSERT INTO xon_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Taah cha na, le ti jer lidikl libaa bi yin li ke Saiprus, li bi ŋŋangan wɔb na, le ki ti fuu Taya, kitiŋ ki bi Siria aatiŋ ni na. Taah ti fuu nima na, le bi ban bi bi nima ni yunn siib, bi ti nyan ŋitun. ");
INSERT INTO xon_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Le ti nyan buŋɔb na ni, ki buen kitiŋ ponn ni, ti ti ban Yesu aanib. Ti nan ti kan bi, ki nan bi bi chee ki ti saa iwiin ilole. Taah bi bi chee na, le Uwumbɔr Aafuur Nyaan cha bi tuk Pɔɔl ke u taa buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Iwiin ilole ngbaan aah jer na, le ni ŋeer ti gir koo buŋɔb na ni. Taah gir cha ti ti koo buŋɔb ni na, le bi mɔmɔk, ni bipuutiib, ni baabim cheen timi, ki nyan ni kitiŋ ngbaan ni. Le ti mɔmɔk gbaan nnyusakpem na aagbaan, ki mee Uwumbɔr, ");
INSERT INTO xon_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ki chɔi tɔb. Le bi gir kun. Le ti mu koo buŋɔb na ni, ");
INSERT INTO xon_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ki ti nyan Taya aatiŋ ni, ki puur buen Tolemais aatiŋ ni. Taah ti fuu nima na, le ti nyan buŋɔb na ni, ki buen ti doon Yesu aanib bi bi nima na, ki nan bi bi chee nwiin mubaa. ");
INSERT INTO xon_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Naah woln kitaak na, le ti nyan kitiŋ ngbaan ni, ki ti fuu Siisarea aatiŋ ni. Taah ti fuu nima na, ti nan buen Filip do, ki ti koo udo. U nan ye unii u tuk binib Yesu aabɔnyaan na la. Baah nan nyan bijab bilole bi Jerusalem ponn ni, ke bi li yakr tijikaar tii Yesu aanib na, u nan ye bijab bilole ngbaan ponn ni ubaa. ");
INSERT INTO xon_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ubisatiib nan ye binaa, kaa kpa chatiib. Le Uwumbɔr Aafuur Nyaan cha bi nabr Uwumbɔr aah len pu na. ");
INSERT INTO xon_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ti nan bi nima ki yunn siib. Le Uwumbɔr aabɔnabr ubaa nyan ni Judea ki fuu ni ti chee nima, bi yin u ke Agabus. ");
INSERT INTO xon_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Le u gaa Pɔɔl aagbapapaln, ki di buu ubaa aataa ni uŋaal, ki tuk Pɔɔl ke Uwumbɔr Aafuur Nyaan bui ke Juu yaab bi bi Jerusalem na ga nan di udaan u yeh ligbapapaln ngbaan na buu utaa ni uŋaal kina, ki di u ŋa binib bi kaa ye Juu yaab na aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Taah ŋun kina na, le ti ni binib bi bi nima na nan gaŋ Pɔɔl ke u taa buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Le Pɔɔl baa bi, “Ni ŋani ba kina, ki wii, ki bii nsui? Bi yaa ga ti buu mi Jerusalem ni, bee bi yaa ga ti ku mi nima Tidindaan Yesu pu kan, m ga buen. Maan di cha.” ");
INSERT INTO xon_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Taa nan ŋmaa chuu u ke u taa buen, le ki len ke, “Cha Tidindaan ŋa waah gee pu na,” le ki ŋmin, kaa ki len tibaa. ");
INSERT INTO xon_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ti nan bi nima ki yunn siib, le ki gor ke ti buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Le Yesu aanib bi nyan ni Siisarea aatiŋ ni na bibaa mu dii timi, ki di buen Jerusalem, uja ubaa do, ki ti koo nima. Bi nan yin u ke Menasonn, u ye Saiprus aatiŋ aanii, ki nan dii Yesu ni yunn. ");
INSERT INTO xon_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Taah ti fuu Jerusalem na, Yesu aanib nan gaa timi ki nan kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Naah woln kitaak na, ti ni Pɔɔl nan buen ti ti doon Jems. Yesu aanib aaninkpiib mɔmɔk mu nan bi nima. ");
INSERT INTO xon_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Le Pɔɔl doon bi, ki ŋeer tuk bi Uwumbɔr aah ŋa tiwan nimɔk na, binib bi kaa ye Juu yaab na aakaasisik ni, uma Pɔɔl aatuln pu. ");
INSERT INTO xon_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Baah ŋun kina na, le bi mɔmɔk nyuŋ Uwumbɔr, ki bui Pɔɔl, “Tina aabo, aa nyi ke Juu yaab ŋichur pam le gaa Yesu ki kii. Bi mɔmɔk aanimbil man Moses aakaal pu. ");
INSERT INTO xon_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Le bi ŋun ke aa mɔk Juu yaab bimɔk bi Biniyayam aatim ni na ke bi taa ki dii Moses aakaal, ki taa ki geei baabim aachakpan, ki taa ki dii Juu yaab aakaal. ");
INSERT INTO xon_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bi ga ŋun ke aa fuu ni. Ti ga ŋa kinye? ");
INSERT INTO xon_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ti ga tuk si saah ga ŋa pu na. Bijab binaa bibaa bi do. Bi nan puu tipuur tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bi ga buen Uwumbɔr Aadichal ni, bi ti ŋa bibaa chain. Aa mu li dii bi cha, ki mu ti ŋa aabaa chain, ki tii bi ŋimombil, aan bi ti daa tiwan ki nan toor kitork tii Uwumbɔr, ki kuu baayikpir. Aa yaa ŋa kina kan, binib mɔmɔk ga bee ke aa mu dii Moses aakaal. Bi ga bee ke binib bi len ke saa dii Moses aakaal na aa len mbamɔn. ");
INSERT INTO xon_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tɔ, binib bi kaa ye Juu yaab ki gaa Yesu ki kii na ma kan, ti nan ŋmee kigbaŋ tii bi, ki tuk bi taah kpokl pu na, ke bi taa ki ŋmɔ kitork aanann, ki taa ki ŋmɔ nsin, ki taa ki ŋmɔ tiwan ni bi tab ku ni na, ki taa ki gɔr kidagook.” ");
INSERT INTO xon_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tɔ, Pɔɔl nan kii baah tuk u pu na. Ki woln kitaak le u yoor bijab binaa ngbaan, le u ni bi ti ŋa bibaa chain. Le u koo Uwumbɔr Aadichal ni, ki ti tuk Uwumbɔr aatotoor bundaln bi ga ŋa chain doo aan ki toor kitork tii Uwumbɔr na. Iwiin ilole daal, le bi ga ŋa chain doo. ");
INSERT INTO xon_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tɔ, iwiin ilole ngbaan aa nan kee fuu, le Juu yaab bibaa, bi nyan ni Asia aatim ni na, kan Pɔɔl Uwumbɔr Aadichal ni. Le bi cha kinipaak ŋma tijar Pɔɔl pu, ki chuu u mpɔɔn, ki tar ke, ");
INSERT INTO xon_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Israel yaab, ter timi man. Uja wee ye unii u buen ŋipepel mɔmɔk na, ki tuk binib mɔmɔk ke bi taa li pak timi Juu yaab, ki taa li pak Moses aakaal, ki taa li pak Uwumbɔr Aadichal. U mu joo ni binib bi kaa ye Juu yaab na, ki di bi koo ni Uwumbɔr Aadichal li ye chain na ni, ki bii li.” ");
INSERT INTO xon_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bi nan kan Pɔɔl ni Trofimus, u ye Efesus aatiŋ aanii na chuun dii kitiŋ ngbaan ponn ni. Le bi dak ke Pɔɔl di u koo ni Uwumbɔr Aadichal ni. Nima pu le bi len ke u joo ni binib bi kaa ye Juu yaab na koo ni Uwumbɔr Aadichal ni. ");
INSERT INTO xon_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Le kitiŋ ngbaan aanib mɔmɔk ŋma tijar, ki san kuuni tɔb chee, ki chuu Pɔɔl ki dar nyan ni u Uwumbɔr Aadichal ni. Libuul ngbaan ni le Uwumbɔr Aadichal aakikiirb piin jaaleŋ mam. ");
INSERT INTO xon_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Le kinipaak na pɔɔn bibaa bi gbaa ku Pɔɔl. Le unii ubaa buen Rom aatɔb aajab aapol chee, le ki tuk u ke Jerusalem aanib mɔmɔk bi ŋmɔ tijar la. ");
INSERT INTO xon_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Libuul ngbaan ni le upol ngbaan di butɔb aajab bibaa ni baaninkpiib, ki san buen kinipaak ngbaan chee. Baah kan butɔb aajab ngbaan ni baapol na, le bi di cha Pɔɔl, kaa ki gbaa u. ");
INSERT INTO xon_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Le upol ngbaan buen Pɔɔl chee, ki ti chuu u, ki tuk waajab ke bi di tikululn tilee buu u, le ki baa ke, “Ŋma ye uja wee? U ŋa kinye?” ");
INSERT INTO xon_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Le bibaa tar baah gee pu na, le biken mu tar baah gee pu na. Kifuuk ngbaan pu, le upol ngbaan aa ŋmaa bee budabu ŋa na. Le u tuk waajab ke bi di Pɔɔl buen butɔb aajab aadichal ni. ");
INSERT INTO xon_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Le bi di u buen ti fuu ŋibimbin ŋi bi maa tam lidichal ngbaan na. Baah joo u cha na, le kinipaak ngbaan naa naa ke bi ti chuu nyan u. Nima pu na, baah ti fuu ŋibimbin taab na, le butɔb aajab ngbaan yoor u paacham, le binib aa ki pii u. ");
INSERT INTO xon_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Le bi mɔmɔk paa bipuwɔb ki tar, “Ku u man.” ");
INSERT INTO xon_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Le bi ti fuu lidichal ngbaan aabisamɔb chee, ki ban bi koo. Le Pɔɔl bui upol ngbaan Griik aaliin ponn ni, “Cha m tuk si tibɔr tibaa.” Le upol ngbaan baa u, “Aa ŋun Griik aaliin aa? ");
INSERT INTO xon_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","M nyi ke aa ye Ijipt aatiŋ aanii u nan cha kinipaak tukni timi aatiŋ aaninkpiib, ki di binikurb ŋichur ŋinaa buen nteersakpiin ni na la.” ");
INSERT INTO xon_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Le Pɔɔl bui u, “M ye Juu yaab aanii la. Bi nan ma mi Tasus aatiŋ ki bi Silisia aatiŋ ni na; ki ye kitiŋ ki kpa liyimbil na la. Pɔɔk aabaa ki cha m len kinipaak ngbaan chee.” ");
INSERT INTO xon_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Le u kii ke u len. Le Pɔɔl sil ŋibimbin paab, ki di uŋaal nyii bi pu. Baah ŋmin na, le u len bi chee bima Juu yaab aaliin ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","U nan len ke, “Ntetiib ni nnaabitiib, li pel man, ki cha m tuk nimi maabamɔn.” ");
INSERT INTO xon_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Baah ŋun ke u len bima bibaa aaliin na, le bi sil chii. Le Pɔɔl len ke, ");
INSERT INTO xon_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“M ye Juu yaab aanii la. Bi nan ma mi Tasus aatiŋ ki bi Silisia aatiŋ ponn ni na la. M nan bae mbaem Jerusalem ni, do chee na la. Gamaliel le nan mɔk mi. M nan bae tiyaajatiib aakaal mbamɔm. Nnimbil nan man Uwumbɔr aatuln pu, ke ni mɔmɔk aah bi pu dandana wee na. ");
INSERT INTO xon_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","M nan ŋa binib bi dii Yesu aasan na falaa, ki ban m ku bi. M nan chuu bijab ni bipiib mpɔɔn, ki di tikululn buu bi, ki di bi ŋa tiyondir ni. ");
INSERT INTO xon_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Uwumbɔr aatotoorninkpel ni Juu yaab aaninkpiib ga ŋmaa tuk nimi ke m len mbamɔn la. Bi nan ŋmee kigbaŋ tii Juu yaab bi bi Damaskus aatiŋ ni na, ke bi tii mi nsan m ti chuu Yesu aanib bi bi nima na, ki di tikululn buu bi, ki di bi dan Jerusalem, ke m nan daa bitafal. Le m nan buen.” ");
INSERT INTO xon_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“M nan bi nsan ni ki ti peen Damaskus aatiŋ. Nwiin kaasisik ni, le nwiihn nyan ni paacham, ki nan woln ki mann gonn mi, ki wiin chain. ");
INSERT INTO xon_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Le m lir kitiŋ, ki ŋun nneel len ke, ‘Sɔɔl, Sɔɔl, ba ŋa aa ŋa mi falaa?’ ");
INSERT INTO xon_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Le m baa u, ‘Ndindaan, ŋma ye?’ Le u bui mi, ‘Min le ye Yesu u ye Nasaref aatiŋ aanii na. Aa ŋani mi le falaa.’ ");
INSERT INTO xon_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bijab bi nan si m chee na nan kan nwiihn ngbaan, kaa ŋun udaan u len m chee na aaneel. ");
INSERT INTO xon_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Le m baa u, ‘Ndindaan, m ga ŋa kinye?’ Le u bui mi, ‘Fii sil ki li cha Damaskus aatiŋ ni. Unii ubaa bi nima, ki ga ti tuk si tiwan nimɔk Uwumbɔr ban ke aa ŋa na.’ ");
INSERT INTO xon_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nwiihn ngbaan aah nan deer nnimbil na, le m jɔb, kaa ki waa. Le binib bi dii mi na dar mi di buen Damaskus aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Uja ubaa nan bi nima, bi nan yin u ke Ananias. U dii Uwumbɔr aasan mbamɔm, ki kii timi aakaal. Juu yaab bimɔk bi nima na pak u. ");
INSERT INTO xon_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Le u dan nan sil m chee ki bui mi, ‘Nna aabo Sɔɔl, likr.’ Libuul ngbaan ni, le nnimbil kpaan likr, le m kan u, kaa ki ye ujoon. ");
INSERT INTO xon_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Le u bui mi, ‘Tiyaajatiib Aawumbɔr nyan si, ke aa bee waageehn, ki kan Waabonyaan, ki ŋun waaneel len aa chee. ");
INSERT INTO xon_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Aa ga li ye waaseeraadaan, ki tuk binib mɔmɔk saah kan pu na, ni saah ŋun pu na. ");
INSERT INTO xon_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Taa taan. Fiin, ki yin waayimbil ki mee u, ki cha m muin si nnyun ni, ki finn aapobil saatunwanbir pu.’” ");
INSERT INTO xon_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nimina aah jer na, le m nan gir buen Jerusalem, ki ti koo Uwumbɔr Aadichal ni, ki mee Uwumbɔr. Maah mee Uwumbɔr na, ");
INSERT INTO xon_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","le m kan lijinjiir aawan; m kan Tidindaan, ki ŋun u bui mi ke, ‘Fiin, ki nya Jerusalem ni mala. Aa yaa tuk do chee na aanib maabɔr kan, bi ga yii, kaan gaa ti.’ ");
INSERT INTO xon_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Le m bui u, ‘Ndindaan, bi nyi ke m nan buen mmeen aadir ni, ki chur binib bi gaa si ki kii na, ki gbaa bi. ");
INSERT INTO xon_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Binib aah nan ku saaseeraadaan Stiifen na, m mu nan bi nima, ki kii ke ni ŋan, ki joo binib bi ku u na aabɔkul.’ ");
INSERT INTO xon_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Le Tidindaan bui mi, ‘Li cha. M ga tun si ni daa na, binib bi kaa ye Juu yaab na chee.’” ");
INSERT INTO xon_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pɔɔl aah len kina na, le kinipaak ngbaan aa ki pel. Le bi mɔmɔk teen mpɔɔn pu, “Ku u man. Naa ŋan ke u ki li bi dulnyaa wee ni.” ");
INSERT INTO xon_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Le bi mɔmɔk tar, ki joo baabɔkul feeni paacham, ki leer titan mae paacham, le kitangbaak feei. ");
INSERT INTO xon_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Le butɔb aajab aapol ngbaan tuk waajab ke bi di Pɔɔl koon ni kidiik ponn ni, ki ti gbaa u ŋinaalab, aan ki nin baa u waah ŋa budabu na, ke bi bee budabu ŋa aan Juu yaab ŋma tijar u pu na. ");
INSERT INTO xon_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Le bi di tikululn buu u, bi ti gbaa u ŋinaalab. Le Pɔɔl bui butɔb aajab aaninkpel u si u chee na, “Naah ban ni gbaa mi na, nkaal kii kina aa? Naa jin mi tibɔr, ki mu aa kan maataani. M ye Rom aanii la.” ");
INSERT INTO xon_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uninkpel ngbaan aah ŋun kina na, le u buen upol ngbaan chee, ki ti bui u, “Li nyi saah ga ŋa pu na. Uja ngbaan ye Rom aanii la.” ");
INSERT INTO xon_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Le upol ngbaan buen Pɔɔl chee, ki ti baa u, “Aa ye Rom aanii la aa?” Le Pɔɔl kii ke u ye. ");
INSERT INTO xon_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Le upol ngbaan bui u, “M nan pan ŋimombil pam, le ki kpaln Rom aanii.” Le Pɔɔl bui u, “M ye Rom aabo la.” ");
INSERT INTO xon_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pɔɔl aah len kina na, le bijab bi ban bi gbaa u na aa ki kaa u, le ki sur bipuwɔb. Upol ngbaan aah bee ke Pɔɔl ye Rom aanii na, le u mu san ijawaan. U bee ke waah di tikululn buu u na, naa ŋan. ");
INSERT INTO xon_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tɔ, upol ngbaan nan ban u bee mbamɔm Juu yaab aah len Pɔɔl aah ŋa pu na. Ki woln kitaak, le u chuu buur tikululn ti bi di buu Pɔɔl na, le ki tuk Uwumbɔr aatotoorninkpiib, ni bibɔjirb aaninkpiib mɔmɔk ke bi kuun ni, le ki di Pɔɔl nan siin binimbiin ni. ");
INSERT INTO xon_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Le Pɔɔl lik bi, ki len ke, “Nnaabitiib, m bee nsui ni ke maabimbin le ŋan Uwumbɔr chee ki nan saa din.” ");
INSERT INTO xon_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Waah len kina na, le Uwumbɔr aatotoorninkpel Ananias tuk binib bi si Pɔɔl chee na ke bi faa umɔb. ");
INSERT INTO xon_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Le Pɔɔl bui u, “Uwumbɔr ga faa si. Aa bi ke ligoln li kaa ŋan, aan bi di pente pipiin pente li na la. Aa ka do, ke aa ji mi tibɔr, nkaal aah dii pu na. Saah tuk binib ke bi faa mi na, sin le bii nkaal ngbaan.” ");
INSERT INTO xon_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Le binib bi si Pɔɔl chee na baa u, “Aa sii Uwumbɔr aatotoorninkpel la aa?” ");
INSERT INTO xon_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Le Pɔɔl len ke, “Nnaabitiib, maa nyi ke u ye Uwumbɔr aatotoorninkpel. M yaa ba nyi kan, maa ba ga len kina; ba pu? ni ŋmee Uwumbɔr Aagbaŋ ni ke, ‘Taa len saanib aaninkpel tibɔbir.’” ");
INSERT INTO xon_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tɔ, Pɔɔl nan bee ke bi ponn ni bibaa ye binib bi dii Sajusii yaab aamɔkm na, bibaa mu ye binib bi dii Farisii yaab aamɔkm na. Le u teen ke, “Nnaabitiib, m ye unii u dii Farisii yaab aamɔkm na la. Nte mu nan ye unii u dii Farisii yaab aamɔkm na la. M kpa limakl ke binib bi kpo na ga fikr nkun ni. Limakl ngbaan pu, le bi ji mi tibɔr.” ");
INSERT INTO xon_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Waah len kina na, le binib bi dii Farisii yaab aamɔkm na, ni binib bi dii Sajusii yaab aamɔkm na yakr tɔb chee, ki kpak tɔb kinikpakpak. ");
INSERT INTO xon_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sajusii yaab len ke binib aan fikr nkun ni, ke Uwumbɔr aatuuntiib aa bi, ke unii aawiin mu aa bi. Farisii yaab mu len ke binib ga fikr nkun ni, Uwumbɔr aatuuntiib bi, unii aawiin mu bi. ");
INSERT INTO xon_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Le bi kpak tɔb kinikpakpak, ki tar mpɔɔn pu, ki kpa kifuuk. Le Uwumbɔr aakaal aamɔmɔkb ponn ni bibaa, bi ye Farisii yaab na fii sil, ki kpak sakpen, le ki len ke, “Taa kan uja wee aataani. Nibaakan, Uwumbɔr aatuun, bee unii aawiin le sil len u chee.” ");
INSERT INTO xon_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Le Farisii yaab ni Sajusii yaab kpak tɔb kinikpakpak sakpen, ki ŋma tijar. Le butɔb aajab aapol ngbaan dak ke bi ga chuu daa par Pɔɔl. Le u tuk waajab ke bi buen ti gaa ni Pɔɔl, ki nyan u bi chee, ki nan di u ŋa baadichal ni. ");
INSERT INTO xon_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kinyeek ngbaan, le Tidindaan dan nan sil Pɔɔl chee, ki nan bui u, “Chuu aabaa, ki taa san ijawaan. Saah tuk binib maabɔr Jerusalem ponn ni pu na, kina le aa ga tuk bi maabɔr Rom aatiŋ mu ni.” ");
INSERT INTO xon_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Naah woln kitaak kichakpiik ni na, le Juu yaab bibaa kuun tɔb chee, ki kpokl, le ki puu ke baan ji tijikaar, kaan nyu nnyun mu see bi ku Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Binib bi nan kpokl kina na jer bijab imonko ilee. ");
INSERT INTO xon_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bi nan buen Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib chee, ki ti bui bi, “Ti puu ke taan ji nibaa see ti ku Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ti ban ke ni ni bibɔjirb aaninkpiib tun unii ke u buen butɔb aajab aaninkpel chee, ki ti tuk u ke u li joo ni Pɔɔl ni chee, ke ni ban ni nan ki baa u tibɔr tiken kpee la. Bi yaa joo u choo kan, waan fuu ni do. Ti ga ku u nsan ponn ni.” ");
INSERT INTO xon_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Le Pɔɔl aaninkpan aajapɔɔn ŋun baah kpokl pu na. Le u koo butɔb aajab aadichal ni, ki ti tuk Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Le Pɔɔl yin butɔb aajab aaninkpel ubaa, ki tuk u ke u di unachipɔɔn na buen butɔb aajab aapol chee, aan u ti tuk u tibɔr tibaa. ");
INSERT INTO xon_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Le uninkpel ngbaan di u buen butɔb aajab aapol chee, ki ti bui u, “Unaagbiija Pɔɔl le yin mi, ke m dan u chee, le ki ti tuk mi ke m di unachipɔɔn wee dan aa chee, u nan tuk si tibɔr tibaa.” ");
INSERT INTO xon_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Le upol ngbaan chuu uŋaal ki dar u buen n‑gbaan, ki ti baa u, “Aa ban aa tuk mi bayaar?” ");
INSERT INTO xon_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Le u bui u, “Juu yaab na kpokl ke bi ga tuk si ke aa fe li joo ni Pɔɔl bibɔjirb aaninkpiib chee, ke bi nan baa u tibɔr tiken kpee. ");
INSERT INTO xon_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bi yaa bui si kina kan, aa taa kii. Bijab bi jer imonko ilee na ga bɔr ki kiir Pɔɔl bi nan ku u. Bi mɔmɔk puu ke baan ji tijikaar kaan nyu nnyun mu, see bi ku u. Dandana wee bi gor ke bi ku u, ki kiir ke bi ŋun saah ga len pu na.” ");
INSERT INTO xon_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Le butɔb aajab aapol bui unachipɔɔn ngbaan, “Taa ki tuk unii ke aa tuk mi tibɔr ngbaan,” le ki cha u buen. ");
INSERT INTO xon_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Le upol ngbaan yin waajab aaninkpiib ponn ni bilee, ke bi dan u chee, le ki nan tuk bi ke bi ban butɔb aajab ikui ilee, ni bitandam imonko itaa ni kipiik, ni butɔb aajab bi joo tikpaatunn na ikui ilee, aan bi gor ki nan buen kinyeek ngbaan tikur tiwae Siisarea aatiŋ ni, ");
INSERT INTO xon_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ki ban itaan tii Pɔɔl aan u li diŋ ni, ki di u buen Ubɔr Feliks chee, u nyan chakb, nibaa taa ŋa u. ");
INSERT INTO xon_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Upol ngbaan nan ŋmee kigbaŋ ke bi ti tii Ubɔr Feliks. U nan ŋmee ke: ");
INSERT INTO xon_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Min Klɔdius Laisias, m doon si Ubɔrkpaan Feliks. ");
INSERT INTO xon_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Juu yaab nan chuu uja wee, ki gbaa u ki ti ban bi ku u. M ŋun ke u ye Rom aanii la. Maah ŋun kina na, le m di butɔb aajab buen aan ti ti nyan ni u, ");
INSERT INTO xon_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ki kpaan di u buen Juu yaab aabɔjirb aaninkpiib chee. M nan ban ke m ti bee baah len ke u ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Baah jin u tibɔr na, le m bee ke waah ŋa pu na, naa ŋeer ti ku u, kaa ŋeer ti di u ŋa kiyondiik ni. Baakaal pu, le bi galn u. Bi len ke u bii baakaal. ");
INSERT INTO xon_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Le unii ubaa tuk mi ke Juu yaab kpokl ke bi ti ku u. Maah ŋun kina na, libuul ngbaan ni le m di u tun ni aa chee, ki tuk binib bi galn u na, ke bi mu dan aa chee ki nan tuk si waah ŋa pu na.” ");
INSERT INTO xon_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tɔ, butɔb aajab ngbaan nan ŋa baapol aah tuk bi pu na. Kinyeek ngbaan, le bi nan di Pɔɔl buen Antipatris aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Naah woln kitaak na, le butɔb aajab bi chuun kitiŋ na labr kun baadichal ni, Jerusalem ponn ni. Le bitandam ngbaan cheen Pɔɔl buen Siisarea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Baah ti fuu nima na, le bi di kigbaŋ ngbaan tii Ubɔr Feliks, ki di Pɔɔl kaan u chee. ");
INSERT INTO xon_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ubɔr ngbaan nan karn kigbaŋ ngbaan, le ki baa Pɔɔl, “Aa nyan ni kilatiŋ ni?” Le Pɔɔl mu bui u, “M nyan ni Silisia aatiŋ ni la.” Waah ŋun ke u nyan ni Silisia aatiŋ ni na, ");
INSERT INTO xon_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","le u bui u, “Binib bi galn si na yaa fuu ni kan, m ga ji si tibɔr,” le ki tuk waatɔb aajab ke bi di Pɔɔl ŋa lidichal li Ubɔr Herod nan maa li na ni, ki cha bi li kii u. ");
INSERT INTO xon_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iwiin iŋmu nan jer, le Uwumbɔr aatotoorninkpel Ananias dan Siisarea aatiŋ ni. Le Juu yaab aaninkpiib bibaa ni lɔya ubaa dii u. Bi yin lɔya ngbaan ke Tetulus. Bi nan sil Ubɔr Feliks aanimbiin ni, ki bii Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Le bi yin Pɔɔl ke u dan. Waah fuu ni na, le Tetulus piin ki bi bii u, le ki bui Ubɔr Feliks: “Timi aaninkpel, ti pak si. Aa joo timi tiŋann, ki cha timi aatiŋ kee mɔ. Aa kpa nlan, ki ter timi aanib sakpen. ");
INSERT INTO xon_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ti mɔmɔk nyi saah ŋani pu na, ki dooni si mbamɔm. ");
INSERT INTO xon_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Maan len tibɔr ti li wiir. Maa ban ke ni ŋun si. Pɔɔn aabaa, ki li pel maah ban m len pu na. ");
INSERT INTO xon_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ti nyi ke Pɔɔl muk binib sakpen. U muk Juu yaab bi bi dulnyaa wee mɔmɔk ni na, ki cha bi ŋmɔ tijar. Binib bibaa bi, ki dii Yesu u ye Nasaref aatiŋ aanii na aasan. Pɔɔl ye bi ponn ni aaninkpel ubaa la. ");
INSERT INTO xon_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","U nan ban u bii Uwumbɔr Aadichal. Nima pu le ti chuu u. Ti nan ban ti ji u tibɔr, timi aakaal aah dii pu na. ");
INSERT INTO xon_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Le butɔb aajab aapol Laisias dan nan nyan u mpɔɔn ti chee, ");
INSERT INTO xon_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ki tuk binib bi galn u na, ke bi li choo aa chee ki nan len waah ŋa pu na. Aa yaa jin u tibɔr ngbaan kan, sin aabaa ga bee tibɔr ngbaan aah bi pu na.” ");
INSERT INTO xon_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tetulus aah len pu na, le Juu yaab kpaan kii, ke ti gbii. ");
INSERT INTO xon_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Le Feliks yoor uŋaal ki tii Pɔɔl nsan ke u len. Le Pɔɔl bui ke, “M nyi ke aa joo maanib ngbaan ŋibin pam. Kina pu na, m kpa mpopiin ke m tuk si maabamɔn. ");
INSERT INTO xon_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","M nan buen Jerusalem m ti doon Uwumbɔr. Naa jer iwiin kipiik ni ilee. Aa ga ŋmaa baa binib ke ti gbii aan taa gbii. ");
INSERT INTO xon_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Maah nan bi Uwumbɔr Aadichal ni, ni mmeen aadir ni, ni kitiŋ ni na, Juu yaab aa kan mi m kpak unii ubaa kinikpakpak, kaa kan mi m muk unii ubaa. ");
INSERT INTO xon_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bi bii mi la, ki mu aa ŋmaa mɔk ke baah len pu na gbii. ");
INSERT INTO xon_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","M kii ke ti gbii ke maah dooni tiyaajatiib Aawumbɔr pu na, m dii Yesu aasan la. Juu yaab len ke nsan ngbaan aa ye mbamɔn. M kii Moses aakaal mɔmɔk mu, ki kii tii Uwumbɔr aabɔnabtiib aah nan ŋmee pu na mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","M kpa limakl ke Uwumbɔr ga fikr binib bi ŋan na, ni bi kaa ŋan na mɔmɔk nkun ni. Juu yaab mu kpa limakl kina la. ");
INSERT INTO xon_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","N‑yoonn mɔmɔk m pɔɔni mbaa ke m taa li kpa taani Uwumbɔr ni binib chee. ");
INSERT INTO xon_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ŋibin ŋibaa le maa nan bi Jerusalem. M nan ki buen nima m ti tii maanib bi ye bigiim na ŋimombil, ki toor kitork tii Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","M nan buen Uwumbɔr Aadichal ni, m ti ŋa mbaa chain, aan ki toor kitork tii Uwumbɔr. Maah ŋa kina na, le Juu yaab kan mi Uwumbɔr Aadichal ni. Kinipaak aa nan bi m chee. Kifuuk mu aa nan bi m chee. ");
INSERT INTO xon_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Le Juu yaab bibaa, bi nyan ni Asia aatim ni na mu nan bi nima. Bi yaa kaa gee maah ŋa pu na kan, ni ŋan ke bima bibaa dan aa chee, ki nan tuk si maah ŋa pu na. ");
INSERT INTO xon_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bibɔjirb aaninkpiib jin mi tibɔr Jerusalem ponn ni. Bi yaa kan maataani kan, cha binib ngbaan tuk si. ");
INSERT INTO xon_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Maah nan si bi chee na, le m teen ke, ‘M pak ke Uwumbɔr ga fikr bi kpo na nkun ni. Nima pu le ni ji mi tibɔr din.’ Maah len kina na, nibaakan bi dak ke naa ŋan.” ");
INSERT INTO xon_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks nan nyi Yesu aasan aabɔr. Le u bui bi, “M ga di cha kina la. Butɔb aajab aapol Laisias yaa fuu ni kan, m ga lik maah ga ŋa tibɔr ngbaan pu na.” ");
INSERT INTO xon_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","U tuk butɔb aajab nkub aaninkpel ke u cha waajab li kii Pɔɔl, ki taa joo u mpɔɔn, ki cha ujɔtiib li ter u ki tii u waah ban pu na. ");
INSERT INTO xon_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iwiin ilee aah jer na, le Ubɔr Feliks ni upuu Drusila fuu ni. Upuu nan ye Juu aabo la. Le Feliks tun unii ke u ti yin ni Pɔɔl ke u dan nan len tibɔr ngbaan aan bi pel. Le Pɔɔl tuk bi baah ga ŋa pu ki gaa Yesu Kristo ki kii, ");
INSERT INTO xon_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ki ŋa bininyaam, ki li chur bibaa, ki taa tun titunwanbir na; ba pu? Uwumbɔr ga ji binib mɔmɔk tibɔr. Pɔɔl aah len kina na, le ijawaan chuu Feliks. Le u bui Pɔɔl, “Ni ŋeer aa di cha kina. M yaa kan nfaawom kan, m ga yin si.” ");
INSERT INTO xon_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Le Feliks dak ke nibaakan Pɔɔl ga tii u ŋimombil, aan u piir u lii. Nima pu na, n‑yoonn mɔmɔk kan, u ti yin ni u ki nan len u chee tibɔr. ");
INSERT INTO xon_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ŋibin ŋilee nan jer. Le ubɔr u bi yin u ke Posius Festus na dan nan leŋ Feliks aaleleŋ. Feliks nan ban ke u piir Juu yaab aasui. Nima pu na, waa nan nyan Pɔɔl kiyondiik ni. U nan cha u beenin pii, le ki buen. ");
INSERT INTO xon_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ubɔr Festus nan fuu Siisarea aatiŋ ni, u nan leŋ Ubɔr Feliks aaleleŋ. Waah bi nima iwiin itaa na, le u buen Jerusalem. ");
INSERT INTO xon_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Waah ti bi nima na, le Uwumbɔr aatotoorninkpiib ni Juu yaab aaninkpiib dan u chee, ki nan bii Pɔɔl, ki gaŋ Ubɔr Festus ");
INSERT INTO xon_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ke u pɔɔn ubaa ki tun binib bi ti yoor ni Pɔɔl ki di dan Jerusalem. Bi nan puen kpokl ke u yaa choo kan, bi ga ku u nsan ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Le Festus bui bi, “Ti laa beenin joo u Siisarea aatiŋ ni. Ni yaa kpee siib kan, m mu ga ki labr buen nima. ");
INSERT INTO xon_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","U yaa kpa taani kan, cha nimi aaninkpiib dii mi nima, aan ki ti galn u.” ");
INSERT INTO xon_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus nan bi bi chee ki ti saa iwiin kipiik, bee iniin, le ki gir cha Siisarea aatiŋ ni, ki ti fuu nima. Naah woln kitaak na, le u koo libɔjil aadiik ni, ki ti kal ubɔjir aajal pu, le ki tun ke bi ti li joo ni Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Juu yaab bi nyan ni Jerusalem na mu nan bi nima. Pɔɔl aah fuu ni na, le bi sil goln u, ki bii u ki ti nyaŋ. Le baa ŋmaa mɔk ke baah len pu na gbii. ");
INSERT INTO xon_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Le Pɔɔl bui ke, “Maa bii Juu yaab aakaal, kaa bii Uwumbɔr Aadichal, kaa bii Rom yaab Aabɔrkpaan Siisa.” ");
INSERT INTO xon_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Le Festus ban ke u piir Juu yaab aasui. Nima pu le u baa Pɔɔl, “Aa ga li gee ke aa buen Jerusalem m ti ji si tibɔr nima aa?” ");
INSERT INTO xon_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Le Pɔɔl bui u, “M bi Ubɔrkpaan Siisa aabɔjir aadiik ni, nin chee ni ŋeer bi ji mi tibɔr na. Sin aabaa nyi ke maa ŋa Juu yaab bakaa. ");
INSERT INTO xon_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","M yaa ba ŋa bakaa, bee m yaa ti ki ŋa tiwan ni ŋeer nkun na kan, maa ba ga ban ke m ŋmar. Baah bii mi pu na yaa kaa gbii kan, ubaa aan ŋmaa di mi ŋa biŋaal ni. M ban ke Ubɔrkpaan Siisa ji mi tibɔr.” ");
INSERT INTO xon_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Le Ubɔr Festus len waakpambalb chee ke u lik waah ga ŋa pu na, nee aapuwɔb le u tuk Pɔɔl, “Aa len ke aa ban ke Siisa ji si tibɔr. Aa ga buen u chee, ni ti len ti.” ");
INSERT INTO xon_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Naah ŋa iwiin ilee na, le Ubɔr Agripa ni uninkpan Beniis dii ni, ki dan Siisarea aatiŋ ni, bi nan doon Ubɔr Festus. ");
INSERT INTO xon_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Baah bi nima iwiin ilee na, le Festus tuk u Pɔɔl aabɔr ke, “Uja ubaa bi do. Feliks nan buen le ki cha u beenin pii kiyondiik ni. ");
INSERT INTO xon_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","M nan buen Jerusalem. Maah nan bi nima na, le Uwumbɔr aatotoorninkpiib, ni Juu yaab aaninkpiib dan nan galn uja ngbaan. Bi ban ke m len ke waabɔr bii. ");
INSERT INTO xon_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Le m tuk bi ke timi Rom yaab aa ŋani kina. Binib yaa galn unii kan, ti cha bi kuun ni tɔb la, aan u ti ŋun baah galn u pu na, ki cha u mu len waabamɔn aah bi pu na. Taan daa unii aatafal see ti puen jin u tibɔr kina. ");
INSERT INTO xon_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Maah tuk bi kina na, le bi nan dan do. Baah fuu ni na, maa taan. Naah woln kitaak na, m nan buen libɔjil aadiik ni, ki ti kal ubɔjir aajal pu, ki tun binib ke bi ti li joo ni Pɔɔl. ");
INSERT INTO xon_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Waah fuu ni na, le binib bi galn u na fii ke bi bii u. M nan dak ke bi ga len ke u ŋa bakaa ki ti nyaŋ la. Ni mu aa ye kina. ");
INSERT INTO xon_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Baah kpak u pu na, ni ye baakaal aabɔr, ki mu ye uja u bi yin u ke Yesu na aabɔr pu la. Bi len ke u kpo. Pɔɔl mu beenin len ke u bi. ");
INSERT INTO xon_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Maa nan nyi maah ga ŋa pu ki bee tibɔr ngbaan na. Le m baa Pɔɔl ke u kii ke u buen Jerusalem aan bi ti ji u tibɔr nima aan waa kii? ");
INSERT INTO xon_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Le u len ke u ban ke Ubɔrkpaan Siisa ji u tibɔr. Nima pu le m cha butɔb aajab kii u, ke ni saa bundaln m ga cha bi di u buen Ubɔrkpaan chee na.” ");
INSERT INTO xon_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Le Ubɔr Agripa bui Festus, “M ban ke m ŋun uja ngbaan aah ga len pu na.” Le Festus bui u, “Aa ga fe ŋun fen.” ");
INSERT INTO xon_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Naah woln kitaak na, le Ubɔr Agripa ni uninkpan Beniis dan ke bininyuum na. Le butɔb aajab aaninkpiib, ni kitiŋ ni aaninkpiib dii bi, ki nyuŋni bi. Le bi mɔmɔk koo kidisakpeŋ kibaa ni. Kidiik ngbaan ni, le bi ji binib tibɔr. Baah fuu ni na, le Festus tuk binib ke bi li joo ni Pɔɔl. Le bi joo ni u. ");
INSERT INTO xon_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Le Festus bui ke, “Ubɔr Agripa ni nimi bimɔk bi do na, ti mɔmɔk kan uja wee. Juu yaab nan dan m chee Jerusalem ponn ni, ki ki dan m chee do chee na mu, ki nan tar ke ni ŋeer ti ku u. ");
INSERT INTO xon_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Le m jin u tibɔr. Maah jin u tibɔr na, le m bee ke waa ŋa tiwan ni ŋeer ke ti ku u na. Le uma ubaa len ke u ban ke Ubɔrkpaan na ji u tibɔr. Nima pu le m ga cha u buen. ");
INSERT INTO xon_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Le m ban ke m ŋmee kigbaŋ tii maaninkpel ki tuk u Pɔɔl aabɔr. M mu aa nyi maah ga ŋmee pu na. Nima pu le m joo ni u, u nan tuk nimi waabɔr. Ubɔr Agripa, m ban ke aa lik waabɔr ngbaan aah bi pu na, aan ki tuk mi maah ga ŋmee pu na. ");
INSERT INTO xon_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","M yaa cha bi di unaagbiija buen Ubɔrkpaan na chee, ki yaa kaa tuk u baah galn u pu na kan, naa ŋan.” ");
INSERT INTO xon_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tɔ, Ubɔr Agripa nan bui Pɔɔl, “Aa ga ŋmaa tuk timi saabɔr aah ye pu na.” Le Pɔɔl yoor uŋaal ki doon u, ki bui ke, ");
INSERT INTO xon_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ubɔr Agripa, maah bi do din ke m tuk si maabamɔn na, m kpa mpopiin pam. Juu yaab galn mi sakpen a. ");
INSERT INTO xon_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","M nyi ke aa nyi Juu yaab aakaal aah bi pu na. Aa nyi baah kpak tɔb budabu pu baakaal pu na. Kina pu na, maah kpa nsan m tuk si maabamɔn pu na, le m kpa mpopiin. M gaŋ si ke aa li kpa limɔr ki li pel maah ga len pu na. ");
INSERT INTO xon_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Maah nan ye unachipɔɔn na, m nan bi maanib ponn ni, ni Jerusalem ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Juu yaab mɔmɔk nan nyi maabimbin n‑yoonn ngbaan. Bi nyi ke n‑yoonn ngbaan mɔmɔk m nan dii Farisii yaab aasan. M nan ye binib bi dii Moses aakaal mbamɔm na ponn ni ubaa la. Bi yaa gee kan, bi ga ŋmaa tuk si kina. ");
INSERT INTO xon_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","M kpa limakl ke Uwumbɔr ga gbiin tipuur ti u nan puu tii tiyaajatiib na. Nima le cha ni ji mi tibɔr din. ");
INSERT INTO xon_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Timi Juu yaab aanibol kipiik ni ŋilee dooni Uwumbɔr nwiin pu ni kinyeek, ki mu kpa limakl ke bi ga kan tipuur ngbaan. Ubɔr Agripa, m mu kpa limakl ngbaan, nima le cha Juu yaab galn mi. ");
INSERT INTO xon_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ba ŋa ni dak ke Uwumbɔr aan ŋmaa fikr binib nkun ni? ");
INSERT INTO xon_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“N‑yoonn mubaa, min mbaa nan dak ke ni ŋan ke m pɔɔk mbaa ki bii Yesu u ye Nasaref aatiŋ aanii na aayimbil. ");
INSERT INTO xon_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Le m nan ŋa kina Jerusalem ponn ni. M nan buen Uwumbɔr aatotoorninkpiib chee, ke bi tii mi nsan ke m chur Uwumbɔr aanib ki di ŋa tiyondir ni. Juu yaab yaa nan len ke bi ga ku bi kan, m mu nan keei la. ");
INSERT INTO xon_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","N‑yoonn mɔmɔk m nan chaa mmeen aadir ni ki ti dar bitafal, ki mukr bi ke bi sii Yesu. M nan gee liŋuul sakpen bi pu; nima pu na, m nan buen ntim muken ponn ni, ki ti ŋa bi falaa.” ");
INSERT INTO xon_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Le Uwumbɔr aatotoorninkpiib nan tii mi nsan ke m ti chuu Yesu aanib bi nan bi Damaskus aatiŋ ni na. Le m nan buen nima. ");
INSERT INTO xon_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ubɔr Agripa, maah nan bi Damaskus aasan pu ki cha nima na, le nwiin kaasisik ni, nwiihn nyan ni paacham, ki wiin jer nwiin, ki woln ki mann gonn m ni bijab bi dii na. ");
INSERT INTO xon_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Le ti mɔmɔk lir kitiŋ. Le m ŋun nneel len Juu yaab aaliin ponn ni ke, ‘Sɔɔl, Sɔɔl, ba ŋa aa ŋa mi falaa? Ni pɔɔ aa di aataal lee ikokon.’ ");
INSERT INTO xon_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Le m baa u, ‘Ndindaan, ŋma ye?’ Le u bui mi, ‘Min le ye Yesu u aa ŋa u falaa na. ");
INSERT INTO xon_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Fii sil. M dan aa chee, ke m lee si aan aa tun maatuln, ki ji seeraa, ki tuk binib saah kan mi pu na, ki tuk bi maah ga mɔk si n‑yoonn mu choo na pu na. ");
INSERT INTO xon_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","M ga nyan si Juu yaab aaŋaal ni, ni binib bi kaa ye Juu yaab na aaŋaal ni, ki cha aa buen bi chee, ");
INSERT INTO xon_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","aan ki ti tuk bi maaliin, ki cha binimbil woln, ki nyan bi mbɔmbɔɔn ni, ki cha bi li bi nwiihn ni, ki nyan bi kinimbɔŋ aaŋaal ni, ki di bi ŋa Uwumbɔr aaŋaal ni, aan ki cha bi gaa min Yesu ki kii, aan Uwumbɔr di cha pinn bi baatunwanbir, ki ŋa bi waanib ponn ni bibaa, baah gaa min Yesu ki kii pu na pu.’” ");
INSERT INTO xon_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ubɔr Agripa, maah kan lijinjiir aawan paacham pu na, le m kii Yesu aamɔb. ");
INSERT INTO xon_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Njan, m tuk binib bi nan bi Damaskus aatiŋ ni na, ke bi kpeln baabimbin ki dii Uwumbɔr aasan, ki tun lituln li ga mɔk ke bi sil kpeln baabimbin na. Njan, m nan tuk bi kina Damaskus aatiŋ ni, le ki nin buen Jerusalem, ki nin bɔ dii Judea aatim mɔmɔk ponn ni, le ki nin buen binib bi kaa ye Juu yaab na aatim ponn ni, ki ti tuk bi mu kina. ");
INSERT INTO xon_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nima pu le Juu yaab chuu mi Uwumbɔr Aadichal ni, ki ban bi ku mi. ");
INSERT INTO xon_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Le Uwumbɔr mu ter mi n‑yoonn mɔmɔk ki nan saa din, ki cha m si do, ki ye waaseeraadaan, ki tuk binib aabɔŋ mɔmɔk waabɔr. M po tuk bi Uwumbɔr aabɔnabtiib ni Moses aah nan len pu na. Bi nan len tiwan ni ga nan ŋa na, ");
INSERT INTO xon_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ke Kristo u ga gaa binib lii na ga nan ji falaa, ki li ye unii u ga puen fikr nkun ni na, ki tuk Juu yaab ni binib bi kaa ye Juu yaab na tibɔr ti ga woln binimbil na.” ");
INSERT INTO xon_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔɔl aah len kina na, le Festus teen ke, “Pɔɔl, aa ye uwaar la. Saah bae mbaem sakpen na le cha aa waar.” ");
INSERT INTO xon_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Le Pɔɔl bui u, “Ubɔr Festus, maa ye uwaar. Maah len pu na, ni ye mbamɔn la. Naa ye uwaar aaliin. ");
INSERT INTO xon_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ubɔr Agripa nyi tibɔr ngbaan. Nima pu le m di lipobil len unimbiin ni, m nyi ke u nyi tibɔr timina, tibaa aa bɔr u. Tibɔr ngbaan nan ŋa binib aanimbil ni la. ");
INSERT INTO xon_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ubɔr Agripa, aa gaa Uwumbɔr aabɔnabtiib aah nan len pu na ki kii ii? M nyi ke aa gaa kii.” ");
INSERT INTO xon_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Le Agripa baa Pɔɔl, “Aa dak ke naa pɔɔ m ŋa Kristo yoo la aa?” ");
INSERT INTO xon_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Le Pɔɔl bui u, “M mee Uwumbɔr ke ni pɔɔye naa pɔɔye, aa ni binib bimɔk pel maah len pu dandana wee na, ŋa Kristo yaab ke min na. M mu aa ban ke bi buu nimi tikululn, ke min na.” ");
INSERT INTO xon_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Le Ubɔr Agripa, ni Ubɔr Festus, ni Beniis, ni binib bi ka bi chee na, fii nyan lipaal. ");
INSERT INTO xon_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Baah nyan lipaal na, le bi ti bui tɔb, “Uja ngbaan aah ŋa pu na, naa ŋeer ti ku u, kaa ŋeer ti di u ŋa kiyondiik ni.” ");
INSERT INTO xon_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Le Agripa bui Festus, “Uja ngbaan yaa kaa ba len ke u ban ke Ubɔrkpaan Siisa ji u tibɔr kan, ti ba ga ŋmaa di u lii.” ");
INSERT INTO xon_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tɔ, bi nan len ke ti ga buen Ubɔrkpaan Siisa chee, Itali aatiŋ ni. Le bi di Pɔɔl ni binaagbiib biken tii butɔb aajab aaninkpel u bi yin u ke Julius na. Butɔb aajab ngbaan aayimbil nan ye ke “Ubɔrkpaan aajab.” ");
INSERT INTO xon_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Le ti koo buŋɔb ni. Buŋɔb ngbaan nyan ni kitiŋ kibaa ni, bi yin ki ke Adramitium. Bi nan gor ke bi di bu buen Asia aatiŋ ni la. Le ti koo ki buen. Uja ubaa mu nan dii timi, bi yin u ke Aristakus. U nan ye Masedonia aatiŋ aanii, ki nyan ni Tesalonika aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Naah woln kitaak na, le ti fuu kitiŋ kibaa ni, bi yin ki ke Saidonn. Le butɔb aajab aaninkpel Julius gee Pɔɔl aabɔr, ki cha u buen ujɔtiib chee nima, u ti kan waah ban pu na. ");
INSERT INTO xon_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tɔ, ti nan nyan nima, le libuln daar took timi. Nima pu le ti peŋ lidikl libaa, bi yin li ke Saiprus, le libuln aa ki pii timi. ");
INSERT INTO xon_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Le ti jer Silisia aatiŋ, ni Pamfilia aatiŋ, ki ti fuu Mira aatiŋ ki bi Lisia aatiŋ ni na. ");
INSERT INTO xon_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Taah ti fuu nima na, le butɔb aajab aaninkpel ngbaan kan buŋɔb bu nyan ni Aleksandria aatiŋ ni, ki ga buen Itali aatiŋ ni na. Le u cha ti mɔmɔk koo buŋɔb ngbaan ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Buŋɔb ngbaan aa nan chuun mala. Ni nan pɔɔ la. Bu nan yunn nsan ni siib, le ki ti fuu Kenaidus aatiŋ chee. Libuln aa nan kii le ti nan ti bee nsan ponn ni. Nima pu na, ti nan ti peŋ lidikl libaa, bi yin li ke Krete. Le ti jer Salmone aatiŋ, ");
INSERT INTO xon_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ki kpak nnyusakpem na aagbaan. Ni nan pɔɔ sakpen a. Le ti nan ti fuu kiloloŋ kibaa ni, bi yin ki ke Kiloloŋ Nyaan. Nima chee aa daa Lasea aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ti nan yunn nsan ngbaan ponn ni, ki ti pii Juu yaab aamɔlul daal, buyoonn kibuŋ ga ŋmaa fii na. Naa ba nan ŋan ke ti ki li joo buŋɔb. Ni nan kpa linimaln sakpen. Le Pɔɔl sur bi ke, ");
INSERT INTO xon_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Njɔtiib, ti yaa ki joo buŋɔb kan, m nyi ke ti ga kan linimaln. Ŋitun ni buŋɔb na ga bii. Binib pam mu ga kpo ti ponn ni.” ");
INSERT INTO xon_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Le butɔb aajab aaninkpel aa kii Pɔɔl aah len pu na. U kii uŋɔdaan ni biŋɔŋaab aaninkpel aah len pu na la. ");
INSERT INTO xon_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Libuln ni utaal aayoonn yaa ti fuu ni n‑yoonn mu na kan, naa ŋan ti li bi kiloloŋ ngbaan ponn ni. Nima le ti ponn ni binib pam bui ke ni ŋan ti nyan kiloloŋ ngbaan ponn ni, ki pɔɔk tibaa ke ti fuu Fiiniks, kitiŋ ki bi Krete aadikl paab na. Kiloloŋ bi nima mu. Libuln ni utaal yaa fuu ni n‑yoonn mu na kan, ni ŋan ke timi aaŋɔb li bi ki ponn ni. Kiloloŋ ngbaan aah bi liwilir wɔb pu na, nima le libuln aan ŋmaa pii timi nima. ");
INSERT INTO xon_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Le libuln li kaa pɔɔ na nyan ni ŋŋangii wɔb. Le bi bui ke ni ŋeer ke ti nyan kiloloŋ ngbaan ponn ni. Le bi chuu gbiln buŋɔb na, le ki di siir. Bi nan joo bu kpak Krete aadikl ngbaan chee la. ");
INSERT INTO xon_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Naah kpee siib na, le libupɔpɔɔl nyan ni ŋŋangan wɔb ki daar choo, ");
INSERT INTO xon_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ki daar yeŋni buŋɔb na, ki cha bu sil. Libuln daar tooh bu la. Nima pu na, bu aa nan ŋmaa chuun. Le ti cha bu jɔnn libuln. ");
INSERT INTO xon_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Le ti ti fuu lidikl libaa chee, bi yin li ke Kɔda, li bi ŋŋangan wɔb. Ti nan peŋ lidikl ngbaan, le libuln aa ki pii timi ki pɔɔ. Le timi aaŋɔsakpem dar buŋɔb waatiib bubaa. Taah peŋ lidikl ngbaan na, le ti chuu yoor buŋɔb waatiib na ŋa busakpem ni. ");
INSERT INTO xon_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Bi nan di iŋmin gbin punn punn busakpem na. Litambol nan dɔ nnyun ni, Libia aatiŋ chee, le bi dak ke nibaakan buŋɔb na ga dii litambol ngbaan paab. Nima pu na, bi nan chuu gbiln buŋɔb aakekeln li nan bi paacham na, ki cha bu jɔnn libuln. ");
INSERT INTO xon_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Libuln nan beenin daar ki pɔɔ, le buŋɔb na yeŋni. Naah woln kitaak na, le bi chuu nyan ni ŋitun na ki di mee lii nnyun ni; ");
INSERT INTO xon_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ki ki woln kitaak, le ti chuu nyan buŋɔb aawan mu ki di lii nnyun ni. ");
INSERT INTO xon_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Taah nan bi bu ponn ni na, ni nan yunn le taa ŋmaa kan nwiin, kaa waa ŋiŋmabil mu, ntaalangbam pu. Libuln mu nan beenin daar, ki pɔɔ. Taa nan ki dak ke ti ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tɔ, baa nan ki ji tijikaar, ni ti yunn. Baah kaa ki ji tijikaar ni yunn na, le Pɔɔl fii sil binimbiin ni, ki bui bi, “Njɔtiib, ni yaa ba pel maah nan len pu na, ki yaa kaa ba nyan ni Krete aadikl ni kan, ni ba ga li ŋan. Timi aawan aa ba ga bii. ");
INSERT INTO xon_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Tɔ, m gaŋ nimi la, chuu nibaa man. Ti ponn ni unii ubaa aan kpo. Buŋɔb ngbaan baanja le ga bii. ");
INSERT INTO xon_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","M ye Uwumbɔr aanii, le ki dooni u. Kinyeek na, le waatuun ubaa dan nan sil m chee, ");
INSERT INTO xon_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ki bui mi, ‘Pɔɔl, taa san ijawaan. Aa ga sil Ubɔrkpaan Siisa aanimbiin ni. Uwumbɔr ga cha binib bimɔk bi buŋɔb bue ponn ni na ŋmar, saanimbaak pu.’ ");
INSERT INTO xon_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Njɔtiib, nima pu na, chuu nibaa man. M pak ke Uwumbɔr ga ŋa waah tuk mi pu na. ");
INSERT INTO xon_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Libuln mu ga daa buŋɔb na ti tam lidikl libaa, ki bii bu.” ");
INSERT INTO xon_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tɔ, libupɔpɔɔl ngbaan nan daar iwiin kipiik ni inaa. Kinyeek, le libuln nan buenin joo timi nnyusakpem na ponn ni. Bi yin nnyusakpem ngbaan ke Adria. Kinyetaasiik, le biŋɔŋaab dak ke ti yak kitiŋ kibaa ni. ");
INSERT INTO xon_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Le bi ban bi tɔŋ lik nnyun aah nyoo pu na. Bi nan di ŋŋmin di gbin tikur ti nyuun na, ki di lii nnyun ni, ki tɔŋ lik, ki ŋaŋ ŋitaa nkub ni moninko. Le bi too foor kpee, le ki ki tɔŋ lik, ki ŋaŋ ŋitaa imonko inaa ni kipiik. ");
INSERT INTO xon_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Le bi dak ke nibaakan buŋɔb ngbaan ga duur ŋitakpal ki bii. Nima pu na, bi nan di tikur tinaa gbin iŋmin inaa pu, ki di gbin liŋɔjuul, le ti doon tam kitiŋ, ki joo bu. Bu aan ki ŋmaa chuun. Baah ŋa kina na, le bi mee Uwumbɔr ke u cha kitaak woln. ");
INSERT INTO xon_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Le biŋɔŋaab ban ke bi loon nyan buŋɔb na ni. Le bi chuu nyan buŋɔb waatiib na di deen nnyun pu, ki ŋmann ke bi chuu nyan tikur tibaa le liŋɔyil pu. ");
INSERT INTO xon_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Tɔ, Pɔɔl nan bee baah ban bi ŋa pu na, le ki bui butɔb aajab ni baaninkpel, “Biŋɔŋaab ngbaan yaa nyan buŋɔb ngbaan ponn ni kan, naan ŋmaa ŋmar.” ");
INSERT INTO xon_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Waah len kina na, le butɔb aajab chuu buŋɔb waatiib na aaŋmin gii, ki di bu lii, ki cha busakpem na. ");
INSERT INTO xon_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kichakpinaanyeek ni le Pɔɔl gaŋ bi mɔmɔk ke bi pɔɔk bibaa ki ji tijikaar, ki bui bi, “Iwiin kipiik ni inaa le na, nimi aalandak muk nimi, le ni lul bumɔb. ");
INSERT INTO xon_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ni pɔɔk nibaa ki ji pɔkaa man. Ni ga ter nimi, ni kan mpɔɔn. Nibaa aan ŋa unii ubaa do ponn ni.” ");
INSERT INTO xon_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔɔl aah len kina na, le u yoor boroboro, ki doon Uwumbɔr bi mɔmɔk aanimbil ni, ki gii ki ŋman. ");
INSERT INTO xon_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Waah ŋa kina na, le bi mɔmɔk chuu bibaa, ki mu jin tijikaar. ");
INSERT INTO xon_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ti nan ye binib ikui ilee ni imonko itaa ni kipiik ni biloob le buŋɔb ngbaan ponn ni. ");
INSERT INTO xon_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Le bi mɔmɔk ŋman ti bab. Baah ŋman bab na, le bi di tijikaar ti gur na di mee nnyun ni. Bi nan ban ke buŋɔb ngbaan yook la. ");
INSERT INTO xon_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kitaak aah woln na, le ti kan kitiŋ. Le biŋɔŋaab aa nyi kitiŋ ngbaan ni. Le bi kan kiloloŋ. Litambol mu dɔ kiloloŋ ngbaan aagbaan. Le bi len ke bi ga pɔɔn bibaa ki cha buŋɔb na ti nyal litambol ngbaan paab. ");
INSERT INTO xon_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Le bi chuu geei tikur na aaŋmin, le ti bee nnyun ni. Le bi chuu gbiln tiŋɔpann aaŋmin, ki nan di likekeln gbin liŋɔyil ndɔ pu paacham. Libuln aah daar na, le bi ban ke likekeln ngbaan li joo buŋɔb chuun cha nnyun aagbaan. Le bu chuun buen. ");
INSERT INTO xon_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Litambol libaa nan dɔ nnyun ponn ni, le baa waa li, ki di dii lipaab. Le liŋɔyil chɔb lipaab, kaan ki ŋmaa chuun. Tinyunkpenn nan gbaa buŋɔb na le liŋɔjuul ti wii. ");
INSERT INTO xon_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Tɔ, butɔb aajab nan dak ke nibaakan binaagbiib na ga yuk lir nnyun ni, ki wo nyan, aan ki san ŋmar. Kina pu na, bi nan ban bi ku bi mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Butɔb aajab aaninkpel aa nan ban ke bi ku Pɔɔl, nima pu le waa kii. U nan tuk bi ke binib bi ŋmaa wo nnyun na puen yuk lir nnyun ponn ni, ki wo buen nnyun aagbaan, ki ti nyan; ");
INSERT INTO xon_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ke binib bi kaa ŋmaa wo nnyun na nyoon ŋikpan, ni ŋiŋɔbɔk, ki li cha nnyun aagbaan, ki ti nyan. Le ti ŋa kina. Le ti mɔmɔk ti nyan. ");
INSERT INTO xon_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Taah nyan nnyun ngbaan ni na, le bi tuk timi ke bi yin lidikl ngbaan ke Malta. ");
INSERT INTO xon_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Le kitiŋ ngbaan aanib gaa timi ki ŋa timi tiŋann pam. Le utaal piin ki bi nu, le tiwoor bi. Le bi tuur mmii tii timi. ");
INSERT INTO xon_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Le Pɔɔl ti peei ni idɔ nan di ŋa mmii ni. Waah di i ŋa mmii ni na, le i toŋ. Le uwaa nyan i ni, ki juu dab uŋaal, ki jɔn. ");
INSERT INTO xon_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Waah juu dab uŋaal ki jɔn na, le kitiŋ ngbaan ponn ni aanib kan, ki bui tɔb ke uja ngbaan ye unikur, le ki nyan ni nnyusakpem ni; Uwumbɔr mu aan cha u ŋmar. ");
INSERT INTO xon_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Tɔ, Pɔɔl nan gbɔk uŋaal, le uwaa na lir mmii ni. Naa ŋa u nibaa. ");
INSERT INTO xon_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bi dak ke ni ga duun la, ni yaa kaa ye kina kan, u ga kpo. Bi nan lik le ni ti yunn, ki mu aa kan nibaa ŋa u. Le bi ki dak ke u ye liwaal la, le ki kpaln unii. ");
INSERT INTO xon_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tɔ, kitiŋ ngbaan aanib aaninkpel mu nan bi. Bi yin u ke Publius. Waasaak aa nan daa taah bi nin chee na. Le u gaa timi, ki chann timi tichann ki ŋa timi tibulchinn iwiin itaa. ");
INSERT INTO xon_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ute nan bun, ki dɔ kidiik ni. Uwon nan ton, le u peel nsin. Pɔɔl nan koo u chee kidiik ni, ki ti mee Uwumbɔr tii u, ki ti di uŋaal paan u pu, le u pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pɔɔl aah ŋa kina na, le bibum biken bi bi lidikl ngbaan aatiŋ ni na mu dan Pɔɔl chee, le u cha bi mu pɔɔk. ");
INSERT INTO xon_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Le bi tii timi ipiin pam. Taah nan ban ti buen na, bi nan ki tii timi, timi aasachuln aapiin. ");
INSERT INTO xon_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ti nan bi nima iŋmal itaa, le buŋɔb bubaa nan bi nima tiwoor ni libuln yoonn. Bu nyan ni kitiŋ kibaa ni, bi yin ki ke Aleksandria. Bi nan yin buŋɔb ngbaan ke “Bijaam.” Le ti koo bu ni, ki buen. ");
INSERT INTO xon_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ti nan ti fuu kitiŋ kibaa ni, bi yin ki ke Sirakus, ki nan bi nima iwiin itaa, ");
INSERT INTO xon_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","le ki nyan nima, ki buen ki ti fuu kitiŋ kibaa ni, bi yin ki ke Regium. Naah woln kitaak na, le libuln nyan ni tipuwɔb, ki daar choo. Le ti nyan nima, ki buen. Iwiin ilee le ti nan ti fuu kitiŋ kibaa ni, bi yin ki ke Puteoli. ");
INSERT INTO xon_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ti nan kan Yesu aanib bibaa nima. Le bi gaŋ timi ke ti li bi bi chee ki ti saa iwiin ilole. Iwiin ilole ngbaan aah jer na, le ti chuun kitiŋ ki buen Rom aatiŋ ni. ");
INSERT INTO xon_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Yesu aanib bi nan bi Rom aatiŋ ni na nan ŋun ke ti choo. Le bi tooh ni timi nsan pu. Bibaa nan tooh ni timi Apius Aanyaŋ ponn ni, le bibaa mu tooh ni timi Tidir Daakaan Titaa na chee. Pɔɔl aah kan bi na, le u doon Uwumbɔr, ki kan lipobil. ");
INSERT INTO xon_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Tɔ, ti nan ti fuu Rom aatiŋ ni. Taah fuu nima na, le bi cha Pɔɔl koo kidiik kibaa ni, le butɔb aaja ubaa si kii u. ");
INSERT INTO xon_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Iwiin itaa aah jer na, le Pɔɔl yin Juu yaab aaninkpiib ke bi kuun ni u chee. Baah kuun ni u chee na, le u bui bi, “Nnaabitiib, maa ŋa timi aanib bakaa, kaa bii tiyaajatiib aakaal. Bi po chuu mi Jerusalem ni ki di mi ŋa Rom yaab aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bi nan jin mi tibɔr, le ki bee ke maa ŋa bakaa, naa ŋeer bi ku mi. Le bi ban ke bi di cha mi. ");
INSERT INTO xon_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Le Juu yaab aa kii ke bi di cha mi. Nima pu na, m len ke m ban ke Ubɔrkpaan Siisa le ji mi tibɔr ngbaan. Naa ye ke m ban ke m galn maanib u chee. ");
INSERT INTO xon_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nima pu le m yin nimi ke ni dan m chee, aan ti nan len tɔb chee tibɔr. Timi Israel yaab kpa limakl ke unii u ga gaa timi lii na ga dan. Limakl ngbaan pu, le bi buu mi tikululn tee.” ");
INSERT INTO xon_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Le bi bui u, “Judea aatiŋ aanib aa ŋmee saabɔr kigbaŋ ni tii ni timi. Tina aabo ubaa aa nyan ni nima, ki nan tuk timi saabɔr, kaa len tibɔbir aa pu. ");
INSERT INTO xon_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ti nyi ke bi len ntim mɔmɔk ponn ni ke saah dii nsan mu na aa ŋan. Nima pu na, ti ban ti ŋun tibɔr ti bi aamɔb ni na.” ");
INSERT INTO xon_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Le bi siin bundaln bi ga ki kuun Pɔɔl chee na. Liyaadaal aah fuu ni na, bi nan ki kuun ni waadiik ni, ki wiir pam. U nan len bi chee tibɔr kichakpiik ni ki nan saa kijook, ki tuk bi Uwumbɔr aanaan aabɔr, ke Moses ni Uwumbɔr aabɔnabtiib nan ŋmee Yesu aabɔr, Uwumbɔr Aagbaŋ ponn ni. Pɔɔl nan pɔɔni ubaa ke bi gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Juu yaab bibaa kii tii waah len pu na, bibaa mu aa kii tii. ");
INSERT INTO xon_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Le bi kpak tɔb kinikpakpak. Baah ban bi nyan Pɔɔl aadiik ni na, le u bui bi, “Uwumbɔr Aafuur Nyaan nan cha waabɔnabr Aisaya tuk niyaajatiib mbamɔn. ");
INSERT INTO xon_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","U nan tuk Aisaya ke, ‘Li cha ti tuk binib ngbaan ke Uwumbɔr len ke: Ni ga pel ki pel, kaan bee maaliin aatataa. Ni ga lik ki lik, kaan li waa. ");
INSERT INTO xon_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Binib ngbaan aasui aa bi nibaa ni. Bitafal kpaa la. Bi ŋub binimbil, kaa ban ke binimbil woln, kaa ban ke bitafal ŋun, kaa ban ke bisui bee maaliin aatataa, kaa ban ke bi kpeln baabimbin ki dii maasan, aan m tii bi laafee.’” ");
INSERT INTO xon_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pɔɔl nan ki bui bi, “M ban ke ni bee ke Uwumbɔr tun mi ke m buen binib bi kaa ye Juu yaab na chee, ki ti tuk bi waabɔr, aan bi mu ŋmar. Bima le ga ŋun.”  ");
INSERT INTO xon_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔɔl aah len kina na, le Juu yaab ngbaan nyan waadiik ni, ki beenin kpak tɔb kinikpakpak sakpen. ");
INSERT INTO xon_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔɔl nan bi kidiik ngbaan ponn ni ŋibin ŋilee. U nan pan ki pu, le ki bi ki ni. Le binib choo nan manni u nima. Le u gaa bi mɔmɔk ni mpopiin. ");
INSERT INTO xon_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","U nan beenin tuk binib Uwumbɔr aanaan aabɔr, ni Tidindaan Yesu Kristo aabɔr, ki nan kpa lipobil ki len. Ubaa mu aa bui ke u di cha.");
INSERT INTO xon_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Min Pɔɔl le ŋmee kigbaŋ kee. M ye Yesu Kristo aatutunn la. Uwumbɔr nan yin mi ke m li ye Yesu aakpambal, ki nyan mi ke m moon waabɔnyaan tee. ");
INSERT INTO xon_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","N‑yaayoonn na, Uwumbɔr nan puu tipuur ke u ga tii timi tibɔnyaan tee. Le waabɔnabtiib ŋmee ti waagbaŋ ki ye chain na ponn ni. ");
INSERT INTO xon_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tibɔnyaan ngbaan le ye Ujapɔɔn aabɔr. Uma le ye Tidindaan Yesu Kristo. Waah nan kpaln unibɔn na, bi nan ma u Ubɔr David aamaal ponn ni. ");
INSERT INTO xon_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Uwumbɔr nan fikr u nkun ni, le Waafuur Nyaan mɔk ke u ye uma Uwumbɔr Aajapɔɔn u kpa mpɔɔn na. ");
INSERT INTO xon_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","U pu le Uwumbɔr ŋa tinyoor ŋa m pu, le ki ŋa mi waakpambal, ke m tuk ŋinibol mɔmɔk ke ni ŋan ke bi tii u naadii, ki kii waamɔb. ");
INSERT INTO xon_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nimi bi bi Rom aatiŋ ni na, Uwumbɔr yin ni mu, ke ni li ye Yesu Kristo aanib. ");
INSERT INTO xon_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nima le m ŋmee kigbaŋ kee m tii nimi bimɔk bi Rom aatiŋ ni na. Uwumbɔr gee nimi ki yin nimi ke ni li ye waanib. Tite Uwumbɔr ni Tidindaan Yesu Kristo ŋa tinyoor ŋa ni pu, ki tii nimi nsuudoon. ");
INSERT INTO xon_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Yesu Kristo pu, le m dooni Maawumbɔr ni mɔmɔk pu; ba pu? binib bimɔk bi dulnyaa ni na ŋun naah gaa Yesu Kristo ki kii pu na. ");
INSERT INTO xon_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","M di nsui mɔmɔk tun lituln tii Uwumbɔr, ki tuk binib Ujapɔɔn Yesu Kristo aabɔnyaan ngbaan. Uma Uwumbɔr le nyi ke ni ye mbamɔn, m teer nibɔr maameen mɔmɔk ponn ni, ");
INSERT INTO xon_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ki mee u n‑yoonn mɔmɔk ke ni yaa ye waageehn kan, u tii mi nsan ke m dan nan mann nimi dandana wee. ");
INSERT INTO xon_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","M ban ke m kan nimi, ki ter nimi aan ni kan Uwumbɔr Aafuur Nyaan aapiin i ga pɔɔk nitaakpab na. ");
INSERT INTO xon_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Maah len pu na le ye ke m ni nimi aah gaa Yesu Kristo ki kii pu na, ti ga pɔɔk tɔb aataakpab. ");
INSERT INTO xon_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nnaabitiib, m ban ke ni bee ke n‑yoonn mɔmɔk m nan ban ke m dan ni chee, le kaa kee ŋmaa dan. M ban ke m cha binib gaa Yesu ki kii Rom aatiŋ ni, ke maah ŋa pu ntim muken ponn ni na. ");
INSERT INTO xon_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ni ye limukl le ke m di tibɔnyaan tee tuk binib mɔmɔk, bi aanimbil woln na, ni bi aanimbil kaa woln na, ni bi bae mbaem na, ni bi kaa bae mbaem na. ");
INSERT INTO xon_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nima le m ban ke m tuk nimi bi bi Rom aatiŋ ni na mu tibɔnyaan ngbaan. ");
INSERT INTO xon_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Maa san inimɔɔn Yesu aabɔnyaan tee pu. Tibɔnyaan ngbaan kpa Uwumbɔr aapɔɔn. Binib bimɔk ŋun ti ki gaa Yesu Kristo ki kii na ga ŋmar; njan, bi ye Juu yaab na ga ŋmar, le bi kaa ye Juu yaab na mu ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Tibɔnyaan ngbaan mɔk timi ke unii yaa gaa Yesu Kristo ki kii kan, Uwumbɔr ga len ke waabɔr ŋan. Ni ŋmee Uwumbɔr Aagbaŋ ni ke, “Uninyaan aah gaa Uwumbɔr ki kii na, u ga li kpa limɔfal.” ");
INSERT INTO xon_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Uwumbɔr mɔk binib ke u gee liŋuul titunwanbirdam pu; bi tun lituln li kaa ŋan na, kaa dii u. Baabiin pu le bi yii mbamɔn. ");
INSERT INTO xon_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Uwumbɔr gee liŋuul bi pu la; ba pu? waabɔr ti binib ga ŋmaa bee ti na bi mpaan pu. Uwumbɔr le di ti mɔk bi. ");
INSERT INTO xon_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Buyoonn Uwumbɔr nan naan dulnyaa wee ki nan saa dandana wee na, binib kani waabimbin aah bi pu na. Naa ye ke binimbil le kan u. Bi kan tiwan ni u naan ni na, ki kan ke u kpa mpɔɔn mu kaan doo na, ki sil ye Uwumbɔr. Nima le baan ŋmaa len ke baa nyi. ");
INSERT INTO xon_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bi nyi ke u bi, ki mu aa nyuŋni u waah ŋeer pu na, ki mu aa dooni u waaterm pu. Nima le baalandak bee fam. Bisui ni bɔɔn la, kaa kpa nlan. ");
INSERT INTO xon_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bi len ke bi ye bilankpalb, le ki tee ye bijɔrb. ");
INSERT INTO xon_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Baa ki dooni Uwumbɔr u nyuun ki bi n‑yoonn mu kaa kpa ndoon na. Bi ŋa binibɔm aanaŋ, ni inyoon aanaŋ, ni iwaa aanaŋ, ki dooni ŋiwaa ngbaan. ");
INSERT INTO xon_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nima le Uwumbɔr di cha bi, le bi dii bisui aah ban pu na, ki tun tijɔŋ aatuln, ki tun lituln li jinni biwon inimɔɔn na. Bi yii Uwumbɔr u ye mbamɔn na, ki dii ŋiwaa. ");
INSERT INTO xon_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bi dooni tiwan ni Uwumbɔr naan ni na, ki dii ni, kaa dooni Uwumbɔr u naan tiwan mɔmɔk na, kaa dii u. Uma Uwumbɔr le yeh mpakm n‑yoonn mu kaa kpa ndoon na. Amii. ");
INSERT INTO xon_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Baah yii Uwumbɔr na, nima le u siir cha bi. Le bi tun inimɔɔn aatuln, bisui aah ban pu na. Bipiib di biŋeen aatɔtiib kpaln bijab, ki doo bi chee. ");
INSERT INTO xon_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bijab mu yii bipiib, ki chuun ban bijab, ki di biŋeen aatɔtiib kpaln bipiib ki tun inimɔɔn aatuln, le Uwumbɔr daa bitafal, baatunwanbir aah ŋeer pu na. ");
INSERT INTO xon_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Baah kaa gee ke bi li nyi Uwumbɔr na, le u siir cha bi. Le bi dak ilandak i ye fam na, ki tun lituln li kaa ŋan na, ");
INSERT INTO xon_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ki gbii titunwanbir aabɔŋ mɔmɔk. Bi gɔr kidagook ki tun baka baka, ki kpa iniman, kaa gee tɔb, ki kpa lipiipoln, ki jaa kijaak, ki ku tɔb, ki ŋmanni tɔb, ki nan tɔb, ki bii tɔb libɔɔl ni, ");
INSERT INTO xon_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ni mpaan pu. Bi nan Uwumbɔr, le ki seei tɔb, ki kpa kalmbaani, ki puk kipupuk. Bi po dak baah ga ŋa pu ki moo tun titunwanbir na la. Bi yii bite ni bina aamɔi. ");
INSERT INTO xon_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Baa kpa nlan. Bi yaa puu tipuur kan, baa gbiini ti. Baa gee baamaal aanib, kaa cha pinni binib, kaa san binib kinimbaak. ");
INSERT INTO xon_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bi nyi ke Uwumbɔr len ke binib bi ŋani kina na ŋeer nkun, le bi tee beenin ŋani kina, ki len ke binib yaa ŋani kina kan, naa bir. ");
INSERT INTO xon_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Tɔ, si u galni binib biken na, saan ŋmaa len tibaa ki nyan aabaa tibɔr ni Uwumbɔr chee; ba pu? aa mu ŋani kina la. Saah galni bi na, le ni mɔk ke saabɔr mu bii; ba pu? si u galni bi na, aa mu ŋani ke baah ŋani pu na la. ");
INSERT INTO xon_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ti nyi ke Uwumbɔr yaa daa binib bi ŋani kina na aatafal kan, ni ŋan. ");
INSERT INTO xon_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Si u ŋani kina na, ki galni biken bi ŋani kina na, aa dak ke Uwumbɔr aan daa aatafal aa? ");
INSERT INTO xon_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","U ŋa si tibulchinn sakpen, ki kpa limɔr ni suklaa aa pu. Ba ŋa aa lik u fam? Saa nyi ke Uwumbɔr ban ke aa kpeln saabimbin aa? Nima le cha u ŋa si tibulchinn. ");
INSERT INTO xon_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Le aatafal pɔɔ. Saa ban ke aa kpeln aasui. Nima le Uwumbɔr ga moo daa aatafal, bundaln u ga gee liŋuul binib aanimbil ni ki ji bi tibɔr mbamɔm na. ");
INSERT INTO xon_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","U ga ŋa binib mɔmɔk baatuln aah ŋeer pu na. ");
INSERT INTO xon_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Binib bi kpa limɔr ki tun lituln li ŋan na, ki ban mpakm, ni nnyuŋ, ni limɔfal li kaa kpa ndoon na, bima le Uwumbɔr ga tii bi limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Binib bi ban tibɔr, ki yii mbamɔn, ki dii nsan mu kaa ŋan na, bima le Uwumbɔr gee liŋuul sakpen bi pu. ");
INSERT INTO xon_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Binib bimɔk tun titunwanbir na ga kan falaa ni limukl. Njan, Juu yaab ga kan, le binib bi kaa ye Juu yaab na mu ga kan. ");
INSERT INTO xon_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Binib bimɔk tun lituln li ŋan na, Uwumbɔr ga nyuŋ bi, ki pak bi, ki tii bi nsuudoon. Njan, u ga tii Juu yaab, le ki ga tii binib bi kaa ye Juu yaab na mu; ");
INSERT INTO xon_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ba pu? Uwumbɔr aa pak ubaa ki jer uken. ");
INSERT INTO xon_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Binib bimɔk kaa nyi Moses aakaal ki tun titunwanbir na aan kan limɔfal li kaa kpa ndoon na. Uwumbɔr aan baa bi ke bi dii Moses aakaal aan baa dii. Binib bimɔk nyi Moses aakaal ki tun titunwanbir na, Uwumbɔr ga baa bi tibɔr nkaal ngbaan aah dii pu na, ki ga daa bitafal. ");
INSERT INTO xon_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Uwumbɔr aan len ke binib bi nyi waakaal kaa dii mu na aabɔr ŋan. U ga len ke binib bi dii waakaal na le aabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Binib bi kaa ye Juu yaab na aa nyi Moses aakaal. Bi yaa ŋani Moses aakaal aah len pu na baageehn pu, ki mu aa nyi nkaal ngbaan kan, baalandak le mɔk bi baah ga dii pu na. ");
INSERT INTO xon_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Baah ŋani pu na, nima le mɔk ke Moses aakaal aah len pu na bi bisui ni. Bisui ponn ni, bi nyi ni ŋan na, ni ni kaa ŋan na. Nima le baalandak bii bi n‑yoonn mubaa, ki pak bi n‑yoonn mubaa mu. ");
INSERT INTO xon_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ni ga li bi kina le bundaln Uwumbɔr ga cha Yesu Kristo ji binib tibɔr, ki baa bi tibɔbɔrkaan ti bi bisui ni na aabɔr. Maah tuk binib tibɔnyaan ti na le mɔk kina. ");
INSERT INTO xon_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tɔ, aa len ke aa ye Juu aanii la, ki dak ke saah nyi Moses aakaal na, nima le ga cha aa ŋmar; aa kpa kipupuk ke aa nyi Uwumbɔr, ");
INSERT INTO xon_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ki nyi waah gee pu na, ki bae Moses aakaal, ki nyi lituln li ŋan na, ni li kaa ŋan na, ");
INSERT INTO xon_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ki dak ke aa ye usanmɔkr le ki tii bijoom, ki ga ŋmaa woln binib bi kaa waa na aanimbil, ");
INSERT INTO xon_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ki ga ŋmaa mɔk bijɔrb nlan, ki ga ŋmaa mɔk mbim mmɔkm. Saah nyi Moses aakaal mu na, aa dak ke aa nyi tiwan mɔmɔk, ki dak ke saah len pu na mɔmɔk ye mbamɔn. ");
INSERT INTO xon_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tɔ, si u mɔk biken na, ba ŋa saa mɔk aabaa? Si u tuk binib ke bi taa su kinaayuk na, ba ŋa aa su? ");
INSERT INTO xon_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Si u len ke binib taa gɔr kidagook na, ba ŋa aa gɔr? Si u yii ŋiwaa na, ba ŋa aa su ŋaadir ni aawan? ");
INSERT INTO xon_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Si u kpa kipupuk Uwumbɔr aakaal pu ki bii nkaal ngbaan na, aa jinn u inimɔɔn la. ");
INSERT INTO xon_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ni ŋmee Uwumbɔr Aagbaŋ ponn ni ke, “Nimi Juu yaab aah ŋani titunwanbir pu na, nima le cha binib bi kaa ye Juu yaab na len Uwumbɔr tibɔbir.” ");
INSERT INTO xon_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Tɔ, aa yaa joo Moses aakaal kan, lichakpangeei kpa tinyoor. Aa mu yaa gii lichakpaln ki bii Moses aakaal kan, ni mɔk ke saa gii le na. ");
INSERT INTO xon_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Binib bi kaa gii ŋichakpan na yaa joo Uwumbɔr aakaal kan, Uwumbɔr aan yii bi, ke baa gii ŋichakpan. ");
INSERT INTO xon_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Binib bi kaa gii ŋichakpan na yaa joo Uwumbɔr aakaal kan, bi ŋan jer nimi Juu yaab bi gii ŋichakpan Moses aakaal aah mɔk pu na, ki bii nkaal muken na. ");
INSERT INTO xon_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Unii u ye Juu aanii mpaan pu baanja na aa ye Juu aanibamɔnn. Unii u gii lichakpaln kaa kpeln waabimbin na, naa ye lichakpangeei bamɔnn. ");
INSERT INTO xon_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Unii u gii lichakpaln, kaa kpeln waabimbin na aa piir Uwumbɔr aasui. Unii u dii Uwumbɔr usui ni na, uma le ye Juu aanibamɔnn. Unii u Uwumbɔr Aafuur Nyaan bi u ni na, nima le ye lichakpangeei bamɔnn. Uwumbɔr le ga pak udaan, naa ye binib. ");
INSERT INTO xon_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Lichakpangeei aanyoor ye ba? Juu yaab jer binib bi kaa ye Juu yaab na aa? ");
INSERT INTO xon_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Een, bi jer bi tiwan aabɔŋ ni la. Ni jer tiwan mɔmɔk na le ye ke Uwumbɔr nan di waabɔr ŋa bima le aaŋaal ni. ");
INSERT INTO xon_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Bi ponn ni bibaa yaa kaa gaa Uwumbɔr ki kii kan, ni ye ba? Baah kaa gaa u ki kii na, Uwumbɔr aan gbiin waa puu tipuur ti na aa? ");
INSERT INTO xon_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","U ga gbiin ti. Binib mɔmɔk yaa ye binyamɔndam kan, Uwumbɔr ma ye mbamɔndaan la. Ni ŋmee waagbaŋ ni ke, “Bi ga kan ke saah len pu na ye mbamɔn, Aa yaa jin binib tibɔr kan, aa kpa mbamɔn la.” ");
INSERT INTO xon_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Timi aatunwanbir yaa mɔk ke Uwumbɔr ŋani ni ŋan na kan, ti ga len ke Uwumbɔr yaa daa titafal kan, u ŋa ni kaa ŋan na aa? Binib bi kaa dii Uwumbɔr na le baa kina. ");
INSERT INTO xon_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","U ŋa ni ŋan na la; ba pu? ni yaa kaa ŋan kan, u ga ŋa kinye ki ji dulnyaa ni aanib tibɔr? ");
INSERT INTO xon_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ubaa ga baa ke, “Maah gee nnyamɔn na yaa mɔk ke Uwumbɔr ye mbamɔndaan ki ga cha binib nyuŋ u kan, ba ŋa u daa ntafal ke m ye titunwanbirdaan?” ");
INSERT INTO xon_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ti ga tun titunwanbir aan ni kpaln tiwan ni ŋan na aa? Taan ŋa kina kpala. Binib bibaa seei timi ki bui ke ti len kina la. Binib ngbaan ga kan ntafadaan mu ŋeer bi na. ");
INSERT INTO xon_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tɔ, timi Juu yaab ŋan ki jer binib bi kaa ye Juu yaab na aa? Taa jer bi. M nan mɔk nimi ke binib bi ye Juu yaab na, ni bi kaa ye Juu yaab na mɔmɔk ye titunwanbirdam la. ");
INSERT INTO xon_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ni ŋmee kina le Uwumbɔr Aagbaŋ ni ke, “Unii ubaa aa ye uninyaan, ");
INSERT INTO xon_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ubaa aa kpa nlan, ubaa aa ban Uwumbɔr, ");
INSERT INTO xon_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","bi mɔmɔk di cha waasan, bi mɔmɔk bee fam la. Ubaa aa bi ki tun lituln li ŋan na, ubaa baanja aa bi. ");
INSERT INTO xon_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Baaliin po ye iliin i bir na la. Bi geei inyamɔn ki ŋmanni binib. Baaliin bii binib ke ujagen aaluul aah bii binib pu na la. ");
INSERT INTO xon_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Baamɔi gbii ŋisiibil ni kinanaŋ la. ");
INSERT INTO xon_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Bi yaa ban bi ku binib kan, naa pɔɔ. ");
INSERT INTO xon_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bi muk binib ki ŋani bi falaa n‑yoonn mɔmɔk la. ");
INSERT INTO xon_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Bi chuun ban tibɔr la. ");
INSERT INTO xon_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Baa san Uwumbɔr.” ");
INSERT INTO xon_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tɔ, ti nyi ke nkaal aah len pu na mɔmɔk len binib bi bi mu chee na la. Nima le dulnyaa wee ni aanib mɔmɔk aabɔr bii Uwumbɔr chee. Ubaa aan ŋmaa len tibaa ke u nyan ubaa tibɔr ni Uwumbɔr chee. ");
INSERT INTO xon_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ubaa aan ŋmaa len ke waah joo Uwumbɔr aakaal mbamɔm pu na, waabɔr ŋan Uwumbɔr chee. Uwumbɔr aakaal le mɔk binib ke bi ye titunwanbirdam la. ");
INSERT INTO xon_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Dandana wee, Uwumbɔr mɔk timi waah ga ŋa pu ki len ke timi aabɔr ŋan na. Waakaal ni waabɔnabtiib aaliin le bi waagbaŋ ponn ni, ki mu tuk timi kina la. Naa ye ke ti dii waakaal mbamɔm le cha u len. ");
INSERT INTO xon_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Binib bimɔk gaa Yesu Kristo ki kii na, bima le Uwumbɔr len ke baabɔr ŋan. Baah gaa Yesu Kristo ki kii na, nima le cha Uwumbɔr len ke baabɔr ŋan. Ubaa aa bi ubaa, ki cha biken; ");
INSERT INTO xon_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","binib mɔmɔk tun titunwanbir la, kaa gbiin Uwumbɔr aanimbil. ");
INSERT INTO xon_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Le Yesu Kristo daa timi, ki gaa timi lii. Timi bi kpaan u chee na, le Uwumbɔr len ke timi aabɔr ŋan. Waabulchinn pu le u len, naa ye ke ti ŋan la. ");
INSERT INTO xon_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","U nan di Yesu siin binib aanimbil ni, ke u nan kpo, aan uma Uwumbɔr taa ki gee liŋuul ti pu. Ti yaa gaa Yesu ki kii kan, waasin pu le Uwumbɔr ga di cha pinn timi. Nima le mɔk ke Uwumbɔr ŋani ni ŋan na; ba pu? u nan kpa limɔr, kaa bii binib bi tun titunwanbir buyoonn Yesu Kristo aa kee dan dulnyaa wee ni na. ");
INSERT INTO xon_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Tɔ, dandana wee, u len titunwanbir aabɔr ki bui ke binib bi gaa Yesu ki kii na aabɔr ŋan u chee. Nimina le mɔk ke uma Uwumbɔr si chob. ");
INSERT INTO xon_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tɔ, ba pu aan ti ga li kpa kipupuk? Taan li kpa kipupuk nibaa pu. Ba pu? Naa ye ke ti dii Uwumbɔr aakaal mbamɔm le cha u gaa timi lii, taah gaa Yesu ki kii na, nima le cha u gaa timi lii. ");
INSERT INTO xon_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nima pu na, ti bee ke ti yaa gaa Yesu ki kii kan, Uwumbɔr ga len ke timi aabɔr ŋan. Naa ye ke ti joo waakaal mbamɔm le cha u len kina. ");
INSERT INTO xon_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Uwumbɔr ye Juu yaab baanja Aawumbɔr la aa? Waa ye binib bi kaa ye Juu yaab na mu Aawumbɔr aa? Mbamɔn, u ye. ");
INSERT INTO xon_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Uwumbɔr ye Uwumbɔrbaan la. Juu yaab yaa gaa Yesu ki kii kan, Uwumbɔr ga len ke baabɔr ŋan. Bi mu kaa ye Juu yaab na yaa gaa Yesu ki kii kan, Uwumbɔr ga len ke bi mu aabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ti yaa len ke binib yaa gaa Yesu ki kii ki ga ŋmar kan, ti yii Uwumbɔr aakaal aa? Naa bi kina kpala. Ti ŋa mu tibɔkpaan la. ");
INSERT INTO xon_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tɔ, cha ti lik tiyaaja Abraham aabɔr aah nan bi pu na: ");
INSERT INTO xon_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ni yaa ba ye waatunyaan pu le cha Uwumbɔr len ke waabɔr ŋan kan, u ba ga ŋmaa li kpa kipupuk. U mu aa ŋmaa li kpa kipupuk Uwumbɔr chee. ");
INSERT INTO xon_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Uwumbɔr Aagbaŋ len ke, “Abraham nan gaa Uwumbɔr aamɔboln ki kii, kina pu na le Uwumbɔr gaa u ke u ye uninyaan u chee.” ");
INSERT INTO xon_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Unii u tun lituln ki kan tipar na, tipar ngbaan aa ye ipiin, ni ye waapar la. ");
INSERT INTO xon_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Tɔ, unii u kaa joo nkaal na yaa gaa Uwumbɔr u di cha pinn titunwanbirdam na ki kii kan, waah gaa Uwumbɔr ki kii na, nima le Uwumbɔr ga len ke waabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Ubɔr David mu nan len ke binib bi Uwumbɔr len ke baabɔr ŋan na le kpa mpopiin. Bi gaa Uwumbɔr ki kii, nima le cha u len ke baabɔr ŋan, naa ye ke bi tun litunyaan le cha u len kina. Ubɔr David nan len ke, ");
INSERT INTO xon_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Binib bi Uwumbɔr di cha baatunwanbir pinn bi na le kpa mpopiin. Uwumbɔr aah di cha binib bi aataani pinn bi na le kpa mpopiin. ");
INSERT INTO xon_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Binib bi Uwumbɔr aan len ke baabɔr bii na, bima le kpa mpopiin.” ");
INSERT INTO xon_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","U len ke Juu yaab baanja le kpa mpopiin ngbaan aa? Waa len kina. Binib bi kaa ye Juu yaab na mu kpa. Ti len ke Abraham nan gaa Uwumbɔr aamɔboln ki kii, nima le cha Uwumbɔr gaa u ke u ye uninyaan u chee. ");
INSERT INTO xon_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Bayoonn Uwumbɔr len ke waabɔr ŋan? Buyoonn u nan gii lichakpaln na le aan buyoonn waa nan kee gii na? Buyoonn waa nan kee gii na. ");
INSERT INTO xon_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Waah gii lichakpaln na, nima le nan ye limɔkl ki mɔk ke u gaa Uwumbɔr ki kii, nima le Uwumbɔr gaa u ke u ye uninyaan u chee, buyoonn waa nan kee gii lichakpaln na. Nima pu le Abraham ye binib bimɔk gaa Uwumbɔr ki kii, kaa gii ŋichakpan na aate. Baah gaa Uwumbɔr ki kii na, nima le Uwumbɔr gaa bi ke bi ye bininyaam u chee. ");
INSERT INTO xon_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Binib bi gii ŋichakpan, ki tak Abraham aataabuu ponn ni, ki gaa Uwumbɔr ki kii ke Abraham aah nan gaa u ki kii pu, buyoonn waa nan kee gii lichakpaln na, bima mu le Abraham ye bite. ");
INSERT INTO xon_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Uwumbɔr nan puu tipuur tii Abraham ni uyaabitiib, ke bima le ga li yeh dulnyaa. Naa ye ke bi joo Uwumbɔr aakaal le ga cha bi kan tipuur ngbaan. Bi gaa Uwumbɔr ki kii la, le u len ke baabɔr ŋan. Nima le ga cha bi kan tipuur ngbaan. ");
INSERT INTO xon_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Uwumbɔr yaa ba puu tipuur ke binib bi joo waakaal na le ga li yeh dulnyaa kan, naadii aa ba ga li kpa tinyoor. Tipuur ngbaan mu aa ba ga gbiin; ba pu? ubaa aan ŋmaa joo nkaal mɔmɔk mbamɔm. ");
INSERT INTO xon_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Binib aah bii nkaal na, le Uwumbɔr gee liŋuul bi pu. Nkaal aah kaa bi nin chee na, binib aa bii nkaal. ");
INSERT INTO xon_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nima le Uwumbɔr puu tipuur tii binib bi gaa u ki kii na. Uwumbɔr aah gee binib pu na, nima le u tii Abraham aayaabitiib mɔmɔk waah nan puu tipuur ti na. U ga tii Abraham aayaabitiib bi ye Juu yaab ki gaa u ki kii na, ni binib bi kaa ye Juu yaab ki mu gaa u ki kii na ke Abraham aah nan gaa u ki kii pu na. Abraham ye timi bimɔk gaa Uwumbɔr ki kii na aayaaja la. ");
INSERT INTO xon_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ni ŋmee Uwumbɔr Aagbaŋ ponn ni ke Uwumbɔr bui Abraham, “M ŋa si ŋinibol pam aayaaja la.” Abraham le ye tite Uwumbɔr chee. U nan tii Uwumbɔr naadii. Uma Uwumbɔr le fikr binib bi kpo na nkun ni, le ki yin binib bi kaa kee bi na, ke baah bi le na. ");
INSERT INTO xon_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","U nan puu tipuur tii Abraham ke u ga ŋa u ŋinibol pam aayaaja, ke uyaabitiib ga li wiir ke iŋmabi aah wiir pu na. Ni nan bi ke tipuur ngbaan aah kaan ŋmaa gbiin le na. Abraham mu nan tee kpa limakl ke ti ga nan gbiin. ");
INSERT INTO xon_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ni nan gur siib u pii ŋibin nkub. Waah nan por pu na, ni nan naahn ke waan ki ŋmaa maa ubo. Upuu Sara mu nan jer timar. Le Abraham pak Uwumbɔr aah tuk u pu na, kaa joo beeni. ");
INSERT INTO xon_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Uwumbɔr aah puu tipuur ti tii u na, tima le gur ye waalandak. Le u pak tipuur ngbaan mbamɔm, kaa joo beeni ke ti ga gbiin bee taan gbiin? U nan moo gaa Uwumbɔr ki kii le ki nyuŋ u, ");
INSERT INTO xon_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ki sil nyi ke Uwumbɔr aah puu tipuur ti na, u ga ŋmaa ŋa kina. ");
INSERT INTO xon_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Waah nan gaa Uwumbɔr aamɔboln ki kii kina na, nima le Uwumbɔr gaa u ke u ye uninyaan u chee. ");
INSERT INTO xon_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","Ni ŋmee kina le Uwumbɔr Aagbaŋ ni. Timi pu le bi nan ŋmee kina, naa ye Abraham baanja pu; ba pu? timi bi gaa Uwumbɔr u nan fikr Tidindaan Yesu nkun ni ki kii na, le u ga len ke timi aabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yesu nan kpo timi aatunwanbir pu, le ki fikr nkun ni. Nima le Uwumbɔr len ke timi aabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Taah gaa Uwumbɔr ki kii pu na, nima le u len ke timi aabɔr ŋan. Tidindaan Yesu Kristo pu le ti ni Uwumbɔr kpaan kijɔtiik. ");
INSERT INTO xon_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yesu Kristo pu, le Uwumbɔr len ke timi aabɔr ŋan. Le ti mɔɔni ki kpa limakl ke ti ga yakr u chee Uwumbɔr aamɔɔn. ");
INSERT INTO xon_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Naa ye nima baanja pu le ti mɔɔni. Falaa mu pu le ti mɔɔni. Ba pu? falaa le tii timi suklaa. ");
INSERT INTO xon_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Suklaa mu tii timi mbimbinyaan. Mbimbinyaan mu tii timi limakl. ");
INSERT INTO xon_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Limakl ngbaan aan jinn timi inimɔɔn. Ba pu? Uwumbɔr aah tii timi Waafuur Nyaan na, Nfuur Nyaan ngbaan le cha ti bee tisui ni waah gee timi sakpen pu na. ");
INSERT INTO xon_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Naah nan ŋeer na, le Kristo nan kpo timi bi ye titunwanbirdam na pu, taah kaa kpa mpɔɔn buyoonn na. ");
INSERT INTO xon_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ni pɔɔ ke unii kpo ke u nyan unii u dii mbamɔm na nkun ni. Nibaakan, unii ubaa ga kaa ki kpo uninyaan pu. ");
INSERT INTO xon_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Tima kan, buyoonn ti nan laa ye titunwanbirdam na le Kristo nan kpo ti pu. Nima le mɔk timi Uwumbɔr aah gee timi sakpen pu na. ");
INSERT INTO xon_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kristo aasin pu le Uwumbɔr len ke timi aabɔr ŋan. Ŋmaninkabaa taah ga nya ntafadaan mu ponn ni u pu na? ");
INSERT INTO xon_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Buyoonn ti nan ye Uwumbɔr aadim na, le Ujapɔɔn nan kpo ti pu. U pu, le ti ni Uwumbɔr kpaan kijɔtiik. Ti ni Uwumbɔr aah kpaan kijɔtiik na, ŋmaninkabaa taah ga ŋmar waamɔfal pu pu na? ");
INSERT INTO xon_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Naa ye nima baanja pu le ti mɔɔni. Tidindaan Yesu Kristo pu le ti bee Uwumbɔr aah ŋan pu na, le ki mɔɔni. U pu le ti ni Uwumbɔr kpaan kijɔtiik. ");
INSERT INTO xon_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Unibaan le nan joo ni titunwanbir dulnyaa ni, le titunwanbir ngbaan joo ni nkun. Binib mɔmɔk aah tun titunwanbir na, le nkun yaa gaa dulnyaa mɔmɔk ni. ");
INSERT INTO xon_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Buyoonn Moses aa nan kee tuk binib Uwumbɔr aakaal na, titunwanbir nan bi. Nkaal aah kaa bi nin chee na, Uwumbɔr aan len ke bi bii mu. ");
INSERT INTO xon_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Adam aayoonn ki ti saa Moses aayoonn le nkun pii binib. Bi nan tun titunwanbir la. Baatunwanbir ni Adam u nan yii Uwumbɔr aamɔb na aatunwanbir aa kpaan. Nkun mu pii bi la. Ti mɔmɔk kan Adam aatunwanbir aatafadaan. Kina le ti mɔmɔk yakr Kristo aatunyaan aanyoor mu. ");
INSERT INTO xon_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Uwumbɔr aah tii timi ipiin i na aa bi ke Adam aatunwanbir na. Ni ye mbamɔn ke unibaan aatunwanbir pu le nkun pii binib mɔmɔk. Yesu Kristo aanimbaasaln pu, le Uwumbɔr san binib mɔmɔk kinimbaak, ki tii bi ipiin i ye limɔfal na. ");
INSERT INTO xon_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Uwumbɔr aapiin aah ŋa timi pu na aa bi ke Adam aatunwanbir aah ŋa timi pu na. Adam aatunwanbirbaan pu, le binib aabɔr bii. Uninyaan ubaa u ye Yesu na pu, le Uwumbɔr di cha pinn titunwanbirdam pam, ki len ke baabɔr ŋan. Waapiin le na. ");
INSERT INTO xon_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Unibaan u bi yin u Adam na aatunwanbir pu, le nkun pii binib mɔmɔk. Unibaan Yesu Kristo na pu, le binib ga kan Uwumbɔr aaterm sakpen. U ga len ke baabɔr ŋan. Nima le ye waapiin. Bi ga li kpa limɔfal li kaa kpa ndoon na, ki kan linyaŋ. ");
INSERT INTO xon_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Unibaan aatunwanbir pu, le binib mɔmɔk aabɔr bii. Yesu aatunyaan pu, le Uwumbɔr ga len ke binib bimɔk gaa Yesu ki kii na aabɔr ŋan, ki ga tii bi limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Unibaan Adam aah nan yii Uwumbɔr aamɔb na, nima le binib mɔmɔk aabɔr bii Uwumbɔr chee. Yesu aah nan kii Uwumbɔr aamɔb na, nima le binib bimɔk gaa uma Yesu ki kii na aabɔr ŋan Uwumbɔr chee. ");
INSERT INTO xon_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Moses nan tuk binib Uwumbɔr aakaal. Nkaal ngbaan mɔk bi ke baatunwanbir wiir sakpen. Le titunwanbir aah wiir nin chee na Uwumbɔr aanimbaasaln wiir ki jer titunwanbir. ");
INSERT INTO xon_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Titunwanbir pu le binib kpo. Tidindaan Yesu Kristo pu, le Uwumbɔr san timi kinimbaak, ki len ke timi aabɔr ŋan, le ti kan limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Kina pu na, ti ga len kinye? Ti ga li beenin tun titunwanbir aan Uwumbɔr aanimbaasaln kpee ee? Taan li ŋani kina kpala. ");
INSERT INTO xon_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ti kpo ke titunwanbir taa ki li joo timi la. Ti yaa beenin tun titunwanbir kan, naa ŋan. ");
INSERT INTO xon_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Baah muin timi nnyun ni, Yesu Kristo aayimbil pu na, nima le mɔk ke ti ni Yesu Kristo kpaan la. Nima pu na, waah nan kpo na, ti mu kpo u chee la. Naa bee kina aa? ");
INSERT INTO xon_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Baah muin timi nnyun ni na, nima le mɔk ke ti kpo, le bi sub timi u chee. Uwumbɔr aapɔɔn pu le u fikr Kristo nkun ni. Waapɔɔn mu pu le ti kpa mbimbipɔm ki ŋani ni ŋan na. ");
INSERT INTO xon_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Ti ni u aah kpaan pu na, ti kpo ke waah kpo pu na. Ti mu ga fikr nkun ni, ke waah fikr pu na. ");
INSERT INTO xon_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ti bee ke baah kpaa u ndɔpuinkoo pu na, bi kpaa timi aabimbikpok mu u chee, ke mbimbikpok mu kaa ŋan na taa ki li bi, aan ti taa ki li ye titunwanbir aanaagbiib. ");
INSERT INTO xon_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Unii u kpo na nyan titunwanbir ni. ");
INSERT INTO xon_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Taah kpo Kristo chee na, ti ŋa naadii ke ti ga li kpa limɔfal u chee. ");
INSERT INTO xon_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ti nyi ke waah fikr nkun ni na, waan ki kpo. Nkun aa ki kpa mpɔɔn u chee. ");
INSERT INTO xon_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Waah kpo na, u kpo ke u kuln titunwanbir nfum mubaa, aan titunwanbir taa ki li joo timi. Waah kpa limɔfal dandana wee na, u bi ke u nyuŋ Uwumbɔr la. ");
INSERT INTO xon_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Kina pu na, ni mu li nyi ke ni kpo ke titunwanbir taa ki li joo nimi la. Naah kpaan Yesu Kristo chee pu na, le ni mu kpa limɔfal ke ni nyuŋ Uwumbɔr. ");
INSERT INTO xon_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nima pu na, ni taa ki cha titunwanbir li joo nimi aawon ti ga kpo na, ki taa ki kii tii tiwon aah ban pu na. ");
INSERT INTO xon_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ni taa di nimi aawon tii titunwanbir, ki taa tun lituln li kaa ŋan na. Ni di nibaa tii Uwumbɔr, ke binib bi fikr nkun ni na, ki di nimi aawon tii Uwumbɔr, ke ni tun lituln li ŋan na ki tii u. ");
INSERT INTO xon_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nkaal aa ki joo nimi. Uwumbɔr aanimbaasaln le joo nimi. Nima le titunwanbir aan ki li ye nimi aadindaan. ");
INSERT INTO xon_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Nkaal aah kaa ki joo timi aan Uwumbɔr aanimbaasaln joo timi na, ti ga tun titunwanbir aa? Taan ŋa kina kpala. ");
INSERT INTO xon_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Aa yaa di aabaa tii unii aan ki kii waamɔb kan, aa ye waanaagbiija la. Naa bee kina aa? Aa yaa kii tii titunwanbir kan, aa ye titunwanbir aanaagbiija la, le ki ga kpo. Aa yaa kii Uwumbɔr aamɔb kan, u ga bui ke saabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","N‑yoonn mubaa, ni nan ye titunwanbir aanaagbiib la. Ti dooni Uwumbɔr sakpen, ke baah mɔk nimi waasan pu na, ni dii nsan ngbaan nisui mɔmɔk ni, ");
INSERT INTO xon_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ki nya ni titunwanbir aanaagbiir ni, ki ŋa litunyaan aanaagbiib. ");
INSERT INTO xon_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","M di binibɔm aabimbin ŋaŋ Uwumbɔr aabɔr ke ni bee maah len pu na aatataa mbamɔm la. Ni nan joo nimi aawon tun tijɔŋ aatuln, ni titunwanbir aabɔŋ mɔmɔk la. Dandana wee, ni di nimi aawon tun lituln li ŋan na man, aan ki ŋa binib bi bi chain na. ");
INSERT INTO xon_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Naah nan ye titunwanbir aanaagbiib na, nitafal aa nan bi litunyaan ni. ");
INSERT INTO xon_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ni yaa teer naah tun titunwanbir ti na kan, ni jinni nimi inimɔɔn dandana wee la. Tinyoor nan bi titunwanbir ngbaan ni ii? Aayii. Titunwanbir ngbaan aadoon ye nkun la. ");
INSERT INTO xon_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Uwumbɔr nyan nimi titunwanbir aanaagbiir ni la. Dandana wee, ni ye uma Uwumbɔr aanaagbiib la. Nimi aanyoor ye mbimbin mu bi chain na la. Naadoon ga li ye limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Titunwanbir aapar ye nkun la. Tidindaan Yesu Kristo pu le Uwumbɔr aapiin ye limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nnaabitiib, ni mɔmɔk nyi nkaal aah bi pu na. Nima le ga cha ni bee maah ga len pu na aatataa. Nkaal dii unii buyoonn u bi na baanja la. U yaa kpo kan, nkaal aa ki dii u. ");
INSERT INTO xon_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nkaal pu le upii u kpa chal na ye uchal yoo n‑yoonn mumɔk uchal bi na. Uchal yaa kpo kan, nkaal mu len ke u ye uchal yoo na aa ki dii u. ");
INSERT INTO xon_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Upii yaa ban uja uken buyoonn uchal bi na kan, bi ga len ke u ye upiidagoor la. Uchal yaa kpo kan, nkaal ngbaan aa ki dii u. U yaa mɔn uja uken kan, waa ye upiidagoor. ");
INSERT INTO xon_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nnaabitiib, nimi aabɔr mu bi kina la. Kristo aah nan kpo ndɔpuinkoo pu na, ni mu nan kpo; nkaal aa ki dii nimi. Ni kpaan Kristo u fikr nkun ni na chee la, le ki dii Uwumbɔr aasan. ");
INSERT INTO xon_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Taah kaa nan dii Uwumbɔr buyoonn na, tisui nan gee Uwumbɔr aakaal aah kɔ pu na, ki cha ti tun titunwanbir ki dii nkun aasan. ");
INSERT INTO xon_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Dandana wee, taah kpo na, nkaal na aa ki dii timi, ki mu aa ki joo timi tinaagbiir. Le Uwumbɔr Aafuur Nyaan tii timi mbimbipɔm, ke ti tun lituln tii Uwumbɔr. Nkaal na aa ki joo timi. ");
INSERT INTO xon_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Nima pu na, ti ga len ke Moses aakaal aa ŋan aa? Mu ŋan. Nkaal na yaa kaa ba bi kan, maa ba ga bee titunwanbir. Nkaal na yaa kaa ba len ke “Taa li kpa iniman” kan, maa ba ga bee ke iniman ye titunwanbir. ");
INSERT INTO xon_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Nkaal aah len kina na, le titunwanbir ti bi nsui ni na yii nkaal ngbaan, ki cha m kpa iniman aabɔŋ aabɔŋ. Nkaal yaa kaa bi kan, titunwanbir aa fu. ");
INSERT INTO xon_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","N‑yoonn mubaa m nan bi, kaa nyi nkaal aatataa mbamɔm. Buyoonn m bee nkaal aatataa mbamɔm na, le titunwanbir fikr nsui ni. Le m bee ke m ŋeer nkun. ");
INSERT INTO xon_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Uwumbɔr nan tii timi waakaal ke ti dii mu, aan ki kan limɔfal. Le m bee ke maah kaa ŋmaa joo waakaal mɔmɔk na, m ŋeer nkun. ");
INSERT INTO xon_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nkaal pu le titunwanbir ti bi nsui ni na nan kpa nsan ki ŋmann mi, ki cha m ŋeer nkun. ");
INSERT INTO xon_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Uwumbɔr aakaal bi chain la. Uwumbɔr aah tuk timi ke ti ŋa pu na le bi chain, ki bi mbamɔm, ki ŋan. ");
INSERT INTO xon_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Waakaal mu ŋan na le ku mi ii? Aayii. Titunwanbir le ku mi. Nkaal mu ŋan na pu, le titunwanbir ku mi, ki cha ti bee ke titunwanbir aa ŋan. Nkaal na le mɔk timi titunwanbir aah bir sakpen pu na. ");
INSERT INTO xon_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ti bee ke Uwumbɔr aakaal mɔk timi Uwumbɔr aah ban pu na. M mu aa ŋani kina; ba pu? m ye titunwanbir aanaagbiija la. ");
INSERT INTO xon_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Maah ŋani pu na, maa kii kina nsui ni. Maah kaa gee ke m li ŋani tiwan ni na, m ŋani nima la. Maah nan tiwan ni na, nima le m tee ŋani. ");
INSERT INTO xon_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","M yaa ŋani maah kaa gee ke m li ŋani tiwan ni na kan, nima le mɔk ke m kii ke Uwumbɔr aakaal ŋan. ");
INSERT INTO xon_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Naa ye ke min le ŋani kina, titunwanbir ti bi nsui ni na le cha m ŋani. ");
INSERT INTO xon_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","M bee ke tiwan ni ŋan na aa bi maabimbikpok ni; m ban ke m tun lituln li ŋan na, kaa ŋmaa tun. ");
INSERT INTO xon_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Maah ban m tun litunyaan li na, maa tun kina. Maah kaa ban m tun titunwanbir ti na, m tun tima la. ");
INSERT INTO xon_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","M yaa tun maah kaa gee m tun pu na kan, naa ye ke min le tun kina, titunwanbir ti bi nsui ni na le cha m tun. ");
INSERT INTO xon_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Naah ye pu na, m yaa ban m tun lituln li ŋan na kan, titunwanbir bi m chee la. ");
INSERT INTO xon_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","M gee Uwumbɔr aakaal nsui ni. ");
INSERT INTO xon_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","M mu kan nkaal muken maawon ni. Nkaal ngbaan jaa Uwumbɔr aakaal mu bi nsui ni na kijaak la. Nima le titunwanbir aakaal i bi maawon ni na joo mi tinaagbiir. ");
INSERT INTO xon_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","M kpa kinimbaak. Titunwanbir bi tiwon tee ni, ki ga ku mi. Ŋma ga nyan mi titunwanbir ngbaan ni? ");
INSERT INTO xon_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","M dooni Uwumbɔr u nyan mi titunwanbir ngbaan ni, Tidindaan Yesu Kristo pu na. Mma kan, maalandak baanja le dii Uwumbɔr aakaal. Maabimbikpok dii titunwanbir aakaal la. ");
INSERT INTO xon_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nima pu na, Uwumbɔr aan len ke binib bi kpaan Yesu Kristo chee na aabɔr bii. ");
INSERT INTO xon_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Taah kpaan Yesu Kristo chee na, le Uwumbɔr Aafuur Nyaan aapɔɔn tii timi limɔfal; Nfuur Nyaan aapɔɔn ngbaan le nyan mi titunwanbir ni nkun aapɔɔn ni. ");
INSERT INTO xon_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nkaal aan ŋmaa ŋa kina; ba pu? binib aa kpa mpɔɔn ke bi joo nkaal ngbaan. Le Uwumbɔr ŋa waakaal aah kaa ŋmaa ŋa pu na; timi aatunwanbir pu le u nan tun ni Ujapɔɔn Yesu dulnyaa wee ni, ke u di tiwon ti naahn timi titunwanbirdam aawon na bii titunwanbir ti bi tisui ni na aapɔɔn, ");
INSERT INTO xon_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ki tii timi bi dii Waafuur Nyaan kaa ki dii mbimbikpok na mpɔɔn ke ti li dii waakaal mbamɔm. ");
INSERT INTO xon_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Binib bi dii mbimbikpok na, bitafal bi mbimbikpok aabɔr ni la. Binib bi dii Uwumbɔr Aafuur Nyaan na, bitafal bi Nfuur Nyaan aabɔr ni la. ");
INSERT INTO xon_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Binib bi aatafal bi mbimbikpok aabɔr ni na ga kpo la. Binib bi aatafal bi Uwumbɔr Aafuur Nyaan aabɔr ni na ga kan limɔfal, ni nsuudoon. ");
INSERT INTO xon_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Binib bi aatafal bi mbimbikpok aabɔr ni na, bi ye Uwumbɔr aadim la; ba pu? baa dii waakaal, ki mu aa ŋmaa dii mu. ");
INSERT INTO xon_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Binib bi dii mbimbikpok aah ban pu na aan ŋmaa piir Uwumbɔr aasui. ");
INSERT INTO xon_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Tɔ, Uwumbɔr Aafuur Nyaan yaa bi ni ni kan, naa dii mbimbikpok aah ban pu na, ni dii Nfuur Nyaan aah ban pu na la. Kristo Aafuur Nyaan yaa kaa bi unii ni kan, udaan ngbaan aa ye Kristo yoo. ");
INSERT INTO xon_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Titunwanbir pu, le nimi aawon ga kpo. Kristo yaa bi ni ni kan, Uwumbɔr Aafuur Nyaan tii nimi limɔfal; ba pu? u len ke nimi aabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Uwumbɔr nan fikr Yesu nkun ni. Uwumbɔr u fikr Yesu nkun ni na Aafuur Nyaan yaa bi ni ni kan, uma Uwumbɔr u fikr Yesu Kristo nkun ni na ga fikr nimi aawon ti ga kpo na mu. Waafuur Nyaan mu bi ni ni na aapɔɔn pu, le u ga fikr nimi nkun ni. ");
INSERT INTO xon_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nnaabitiib, nima pu na, ni ŋan ke ti dii Uwumbɔr Aafuur Nyaan aah ban pu na, ki taa dii unibɔn aabimbin aah ban pu na. ");
INSERT INTO xon_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ni yaa dii unibɔn aabimbin aah ban pu na kan, ni ga kpo la. Ni yaa kuln nimi aawon aatunwanbir, Uwumbɔr Aafuur Nyaan aapɔɔn pu kan, ni ga li kpa limɔfal li kaa kpa ndoon na. ");
INSERT INTO xon_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Binib bimɔk dii Uwumbɔr Aafuur Nyaan aah ban pu na, bima le ye Uwumbɔr aabim. ");
INSERT INTO xon_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nfuur Nyaan mu Uwumbɔr tii nimi na, mu aa joo nimi tinaagbiir ke ni san ijawaan. Waafuur Nyaan le ŋa nimi waabim, le ki cha ti yin u ke “Nte.” ");
INSERT INTO xon_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Waafuur Nyaan le kpaan timi aawiin chee, le ki ji seeraa ke ti ye Uwumbɔr aabim. ");
INSERT INTO xon_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Taah ye Uwumbɔr aabim na, ti ga kan Uwumbɔr aah di tiwanyaan ni bil kiir timi paacham na. Ti ni Kristo ga kpaan kan tiwanyaan ngbaan. Ti yaa ji falaa u pu kan, ti ni u ga nan kpaan ji mmɔɔn paacham. ");
INSERT INTO xon_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","M nyi ke dandana aafalaa aan ŋmaa ŋaŋ mpopiin mu ti ga nan kan mu paacham na. ");
INSERT INTO xon_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Tiwan ni Uwumbɔr naan ni na mɔmɔk aanimbil man ke ni kan bundaln Uwumbɔr ga nyan waabim mpaan pu na. ");
INSERT INTO xon_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Buyoonn Adam nan tun titunwanbir na, Uwumbɔr nan len ke tiwan ni u naan ni na, ni ga li bi, ki bi fam la. Waageehn pu, le u len kina. Naa ye tiwan ni u naan ni na aageehn. ");
INSERT INTO xon_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Uwumbɔr mu tii tiwan ni u naan ni na limakl ke ni ga ŋa tiwan ni kaan bur na, ki kan lifuur nyaan ke Uwumbɔr aabim aah kan pu na. ");
INSERT INTO xon_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ti nyi ke Uwumbɔr aah naan tiwan nimɔk na wu ke imalween aah wu pu na, ki du ki nan saa dandana. ");
INSERT INTO xon_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Naa ye tiwannaankaan baanja le wu; timi bi Uwumbɔr puen tii timi Waafuur Nyaan na, ti mu du tisui ni, ki kii bundaln Uwumbɔr ga mɔk ke ti sil ye waabim, ki ga tii timi tiwon ti kaan kpo na. ");
INSERT INTO xon_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Taah ŋmar pu na, le ti kpa limakl. Unii yaa kpa limakl ke u ga kan tiwan kan, ni mɔk ke waa kee kan la. U yaa kan ni kan, waan ki li kpa limakl ni pu. ");
INSERT INTO xon_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Tɔ, ti yaa kpa limakl ke ti ga kan tiwan ni tinimbil aa waa ni na kan, le ti ga li kpa limɔr ki kii bundaln ti ga kan ni na. ");
INSERT INTO xon_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Le Uwumbɔr Aafuur Nyaan ter timi, timi aadabur ni. Taa nyi taah ga mee u mbamɔm pu na, le Waafuur Nyaan mee u tii timi, ki du, ubaa aah kaa ŋmaa len pu na. ");
INSERT INTO xon_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Uwumbɔr u lik binib aasui ni aah bi pu na nyi Waafuur Nyaan aalandak aah bi pu na; ba pu? Nfuur Nyaan mee u tii waanib waah ban pu na. ");
INSERT INTO xon_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ti nyi ke tiwan nimɔk pii timi na, Uwumbɔr le cha ni mɔmɔk kpaln tiwan ni ŋan na ki tii binib bi gee u na. Waageehn pu le u nan yin bi. ");
INSERT INTO xon_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","U nan nyi binib bimɔk ga kii tii u na, le ki nan nyan bi, ke bi kpaln Ujapɔɔn Yesu Kristo aah bi pu na, aan u li ye njan aabo, naabitiib pam ponn ni. ");
INSERT INTO xon_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Binib bi Uwumbɔr nyan bi na, le u yin bi. Binib bi u yin bi na, le u len ke baabɔr ŋan, ki nyuŋ bi. ");
INSERT INTO xon_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Uwumbɔr aah ŋa kina mɔmɔk na, ti ga len kinye? Uwumbɔr aah si tichaŋ ni na, ubaa aan ŋmaa ŋa timi nibaa. ");
INSERT INTO xon_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Uwumbɔr aa yii ke waan tii timi Ujapɔɔn. U nan di Ujapɔɔn ŋa binib aaŋaal ni ke u ti kpo ti mɔmɔk aatunwanbir pu la. Waah tii timi Ujapɔɔn na, u ga ki tii timi tiwan mɔmɔk ki kpee. ");
INSERT INTO xon_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ŋma ga ŋmaa galn binib bi Uwumbɔr nyan bi na? Uwumbɔr ubaa len ke baabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nima le ubaa aan ŋmaa galn timi. Yesu Kristo nan kpo ti pu, ki fikr nkun ni, ki bi Uwumbɔr aaŋangii wɔb, ki mee u ki tii timi. ");
INSERT INTO xon_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ba ga ŋmaa nyan timi Kristo u gee timi na aaŋaal ni? Falaa aa? Tibɔr aa? Limukl aa? Nkon aa? Igiin aa? Linimaln aa? Nkun aa? Aayii. ");
INSERT INTO xon_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ni ŋmee Uwumbɔr Aagbaŋ ni ke, “Sin pu le bi ku timi iwiin mɔmɔk, le ti naahn ipiih i bi ban bi ti kɔr i na la.” ");
INSERT INTO xon_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Tɔ, Yesu Kristo u gee timi na aapɔɔn pu, le ti kan linyaŋ kookoo. ");
INSERT INTO xon_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Tidindaan Yesu Kristo pu, le Uwumbɔr gee timi. M sil bee ke nibaa aa bi ki ga ŋmaa yakr ti ni waageehm. Nkun, limɔfal, Uwumbɔr aatuuntiib, kinimbɔŋ aapɔɔn, dandana aabɔr, daalbaadaal aabɔr, mpɔɔn, paacham aawan, taab aawan, tiwan nimɔk bi na, ni mɔmɔk aan ŋmaa yakr ti ni Uwumbɔr aageehm. ");
INSERT INTO xon_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Tɔ, maah ye Kristo aanii na, m len mbamɔn la. Maa gee nnyamɔn. Maalandak ni Uwumbɔr Aafuur Nyaan ji seeraa ke m len mbamɔn la. ");
INSERT INTO xon_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","M kpa mpombiin sakpen. Nsui bii n‑yoonn mɔmɔk, mmaal aanaabitiib Juu yaab pu la. ");
INSERT INTO xon_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","M ga li ŋmaa ban ke m bee fam Kristo chee, bima taa bee. ");
INSERT INTO xon_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bi ye Israel yaab la. Uwumbɔr nan ŋa bi waabim, ki nyuŋ bi, ki puu tipuur tii bi, ki tii bi waakaal, ki mɔk bi baah ga li dooni u pu na, ki bui bi waah ga ŋa tinyoor pu ki ŋa bi pu na. ");
INSERT INTO xon_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Biyaajatiib ye tiyaajaninkpiib la. Kristo aah nan ŋa unibɔn na, u nan ye bi ponn ni ubaa la. Uma le yeh mpɔɔn mɔmɔk. Cha ti pak Uwumbɔr n‑yoonn mu kaa kpa ndoon na. Amii. ");
INSERT INTO xon_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Uwumbɔr aah puu tipuur ti tii Israel yaab na, maa len ke waa gbiin tipuur ngbaan. Bi ye Israel aayaabitiib la. Ni mu aa ye bi mɔmɔk le ye Israel yaab bamɔm. ");
INSERT INTO xon_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Bi ye Abraham aayaabitiib la. Ni mu aa ye bi mɔmɔk le ye uyaabitiib bamɔm. Uwumbɔr nan tuk Abraham ke waabo Aisak aayaabitiib baanja le ga li ye uyaabitiib bamɔm. ");
INSERT INTO xon_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nima le mɔk ke Abraham aayaabitiib ngem aa ye Uwumbɔr aabim. Mbim bi Uwumbɔr nan puu tipuur ke Abraham ga maa na, bima le ye uyaabitiib bamɔm. ");
INSERT INTO xon_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Uwumbɔr nan puu tipuur tii u ke ni yaa nan ŋeer kan, u ga dan u chee, le upuu Sara ga maa ubijabo. ");
INSERT INTO xon_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Naa ye nimina baanja. Rebeka aabijabim mulee nan kpa te ubaa, u ye tiyaaja Aisak la. ");
INSERT INTO xon_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Le Uwumbɔr nan bui Rebeka ke ubo u ye uwaatiir na ga jer ukpel. Buyoonn Uwumbɔr bui u kina na, waa nan kee ma mbim ngbaan. Baa nan kee ŋa ni ŋan na, bee ni kaa ŋan na. Uwumbɔr nyan mbim mulee ngbaan ponn ni ubaa, waageehn pu, naa ye baatuln pu. Nima le mɔk ke Uwumbɔr aageehn pu le u nyan waah ban unii u na. ");
INSERT INTO xon_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ni ŋmee Uwumbɔr Aagbaŋ ponn ni ke u len ke u gee Jakob ki jer Esɔ. ");
INSERT INTO xon_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Kina kan, ti ga len kinye? Ti ga len ke Uwumbɔr ŋa ni kaa ŋan aa? Taan len kina kpala. ");
INSERT INTO xon_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","U nan bui Moses ke binib bi u ban u san bi kinimbaak na, u ga san bi kinimbaak la. ");
INSERT INTO xon_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Naa ye binib aageehn pu, kaa ye baatuln pu; Uwumbɔr aanimbaasaln pu, le u san bi kinimbaak. ");
INSERT INTO xon_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ni ŋmee Uwumbɔr Aagbaŋ ni ke Uwumbɔr nan bui Ubɔr Faro, “M ŋa si ubɔr ke m mɔk binib maah kpa mpɔɔn ki chiin si pu na, aan maayimbil nya paacham, dulnyaa aapepel mɔmɔk ni.” ");
INSERT INTO xon_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Nima le binib bi u ban u san bi kinimbaak na, u san bi kinimbaak. Binib bi u ban ke u cha bi gaa biyil na, u cha bi gaa la. ");
INSERT INTO xon_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Nibaakan, aa ga baa mi, “Ni yaa ye kina kan, ba pu Uwumbɔr galn binib? Ŋma ga ŋmaa yii waageehn?” ");
INSERT INTO xon_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Njɔ, aa ye ŋma ki kpak Uwumbɔr? Tiwanaankaan aan baa unii u naan ni na, “Ba ŋa aa naan mi kina?” ");
INSERT INTO xon_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Uyakmaal ga ŋmaa yakr tiyakr waageehn pu, ki di tibaa ti maa lisil aasambil, ki di tiken maa lisambil li kaa ye lisil aasambil na. ");
INSERT INTO xon_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Uwumbɔr aah ŋa pu na, ni bi kina la. U nan ban ke u mɔk binib ke u gee liŋuul titunwanbir pu, ki ban ke bi bee waah kpa mpɔɔn pu na. Nima le u ji limɔr pam binib bi ŋa u liŋuul ki ŋeer ntafadaan na pu. ");
INSERT INTO xon_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","U mu ban ke binib bee waah ŋan sakpen pu na, ki san timi kinimbaak, ki ŋa timi mpopiin pam. U nan naan timi ke u ŋa timi kina la, ");
INSERT INTO xon_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ki yin timi bi ye Juu yaab na, ni binib bi kaa ye Juu yaab na mu. ");
INSERT INTO xon_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ni ŋmee Hosea aagbaŋ ni ke Uwumbɔr bui ke, “Binib bi kaa nan ye maanib na, m ga yin bi maanib. Ŋinibol ŋi maa nan gee ŋi na, m ga yin ŋi maanigeehm la. ");
INSERT INTO xon_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Baah nan tuk bi ke baa ye maanib nin chee na, nima chee le bi ga yin bi ke min Uwumbɔr u fu na aabim.” ");
INSERT INTO xon_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Tɔ, Uwumbɔr aabɔnabr Aisaya nan len Israel yaab aabɔr; u nan len ke Israel yaab wiir ke nnyusakpem aatambol aah wiir pu na, le bi ponn ni, binib siib baanja ga ŋmar; ");
INSERT INTO xon_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ba pu? Uwumbɔr ga daa dulnyaa aanib aatafal, waah nan len pu na, kaan taan. ");
INSERT INTO xon_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ni bi ke Aisaya aah nan ki len pu na ke, “Uwumbɔr Mpɔɔnsakpiindaan yaa kaa ba gur timi yaabitiib siib kan, ti mɔmɔk ba ga kuln ke Sodom aatiŋ aanib ni Gomora aatiŋ aanib aah nan kuln pu na la.” ");
INSERT INTO xon_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Nima pu na, ti ga len kinye? Binib bi kaa ye Juu yaab na aanimbil aa nan man ke Uwumbɔr len ke baabɔr ŋan. Dandana wee, baah gaa Yesu ki kii na, nima le Uwumbɔr len ke baabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Israel yaab aanimbil nan man ke bi li joo nkaal, aan Uwumbɔr len ke baabɔr ŋan. Bi mu aa nan ŋmaa joo mu; ");
INSERT INTO xon_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ba pu? baa gaa Uwumbɔr ki kii. Bi dak ke baatuln pu le Uwumbɔr ga len ke baabɔr ŋan. Bi yii Yesu Kristo le ki lir; ");
INSERT INTO xon_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","bi gbeer lifaakuul li Uwumbɔr Aagbaŋ len laabɔr na ke, “U di lifaakuul bil Sionn aatiŋ ni. Binib ga gbeer li ki lir. Le unii umɔk gaa u ki kii na aan ji inimɔɔn.” ");
INSERT INTO xon_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Nnaabitiib, m mee Uwumbɔr tii maanib Israel yaab ke bi ŋmar. M ban kina le nsui mɔmɔk. ");
INSERT INTO xon_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","M ga ŋmaa ŋa bi seeraa ke binimbil man Uwumbɔr aatuln pu. Bi mu aa bee u mbamɔm. ");
INSERT INTO xon_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Baa nyi Uwumbɔr aah ŋa pu aan ki len ke binib aabɔr ŋan u chee na. Bi nan ban ke bi dii nkaal aan ki ŋmar, ki yii Uwumbɔr aah ŋa pu ki cha binib aabɔr ŋan u chee na. ");
INSERT INTO xon_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kristo fuu ni ke binib bi gaa u ki kii na aabɔr li ŋan. Naa ye ke baah dii nkaal pu na le cha baabɔr ŋan. ");
INSERT INTO xon_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moses nan ŋmee ke unii yaa kii nkaal aah mɔk pu na kan, Uwumbɔr ga len ke waabɔr ŋan. U nan ŋmee ke “Unii yaa ŋa nkaal aah mɔk pu na kan, u ga kan limɔfal.” ");
INSERT INTO xon_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Timi bi gaa Yesu ki kii na, Uwumbɔr len ke timi aabɔr ŋan. Nima pu le ti len ke, “Taa baa aabaa aasui ni ke, ‘Ŋma ga buen paacham u ti li joo ni Kristo?’ ");
INSERT INTO xon_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ki taa baa ke, ‘Ŋma ga buen bitekpiib do ki ti fikr Kristo nkun ni?’” ");
INSERT INTO xon_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ti len ke, “Uwumbɔr aaliin aa daa aa chee. I bi aamɔb ni, ni aasui ni.” Iliin ngbaan le ti mooni ke aa gaa Yesu ki kii. ");
INSERT INTO xon_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Aa yaa len binib aanimbil ni ke Yesu le ye Aadindaan, ki yaa ŋa naadii aasui ni ke Uwumbɔr fikr u nkun ni kan, aa ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ti gaa u ki kii tisui ni la, nima le Uwumbɔr len ke timi aabɔr ŋan. Ti len binib aanimbil ni ke ti gaa u ki kii, nima le ti ŋmar. ");
INSERT INTO xon_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Uwumbɔr Aagbaŋ len ke unii umɔk gaa u ki kii na aan ji inimɔɔn. ");
INSERT INTO xon_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Binib bi ye Juu yaab na, ni binib bi kaa ye Juu yaab na mɔmɔk kpaan la. Uwumbɔr le ye bi mɔmɔk Aadindaan, ki ŋa tinyoor sakpen ŋa binib bimɔk mee u ke bi ŋmar na pu. ");
INSERT INTO xon_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Waagbaŋ len ke unii umɔk mee Uwumbɔr ke u gaa bi lii na kan ga ŋmar. ");
INSERT INTO xon_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bi yaa kaa gaa u ki kii kan, bi