﻿USE sofia;
DROP TABLE IF EXISTS sofia.xnn_vpl;
CREATE TABLE xnn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xnn_vpl WRITE;
INSERT INTO xnn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Naay nan kaibagaan din alal-apon Jesu Kristo. Siya nan apon din si Ali David ay apon abes din si Abraham. ");
INSERT INTO xnn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham et siya nan aman din si Isaac. Si Isaac et aman Jacob. Si Jacob et aman din si Juda ya nan bebsatna. ");
INSERT INTO xnn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda et aman da Pares ken Zara et din si Tamal nan inada. Si Pares et aman Esrom ya si Esrom et aman Aram. ");
INSERT INTO xnn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram et aman Aminadab ya si Aminadab et aman Naason ya si Naason et aman Salmon. ");
INSERT INTO xnn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon et aman Booz et si Rahab nan inana. Si Booz et aman Obed et si Ruth nan inana. Si Obed et aman Jesse. ");
INSERT INTO xnn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jesse et aman Ali David. Si David et aman Solomon. Nan inana et din asawan din si Urias. ");
INSERT INTO xnn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Solomon et aman Roboam. Si Roboam et aman Abias. Si Abias et aman Asa. ");
INSERT INTO xnn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa et aman Josafat. Si Josafat et aman Joram. Si Joram et aman Ozias. ");
INSERT INTO xnn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Ozias et aman Joatam. Si Joatam et aman Acaz. Si Acaz et aman Ezekias. ");
INSERT INTO xnn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezekias et aman Manases. Si Manases et aman Amon. Si Amon et aman Josias. ");
INSERT INTO xnn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias et aman Jeconias ya nan bebsatna et issan deey ay timpo nan nang-alaan nan iBabilonia isnan Judio ay baa daida. ");
INSERT INTO xnn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isdin kad-an nan Judio id Babilonia et naiyanak si Salatiel ay si Jeconias nan amana. Si Salatiel et aman Zorobabel. ");
INSERT INTO xnn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel et aman Abiud. Si Abiud et aman Eliakim. Si Eliakim et aman Azor. ");
INSERT INTO xnn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Azor et aman Sadoc. Si Sadoc et aman Akim. Si Akim et aman Eliud. ");
INSERT INTO xnn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud et aman Eleazar. Si Eleazar et aman Matan. Si Matan et aman Jacob. ");
INSERT INTO xnn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob et siya nan aman Jose ay nang-asawa ken Maria ay nangiyanak ken Jesus ay makwani en Kristo ay inbaan Apo Dios ay mangisalakan ken datako. ");
INSERT INTO xnn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Isonga simpoo ya epat nan kaap-owan ay nagapo ken Abraham enggana ken David. Ya wada abes nan simpoo ya epat ay kaap-owan ay nagapo ken David enggana isdin nang-alaan nan iBabilonia isnan Judio. Ya wada abes nan simpoo ya epat ay kaap-owan ay ninlogi isdin ninteanda id Babilonia enggana ay naiyanak nan Kristo. ");
INSERT INTO xnn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Siya na nan inommat isnan naiyanakan Jesu Kristo. Si Maria ay awnit mangiyanak ken Jesus et naitoya ay makiasawa ken Jose. Ngem sadapay mentipon et naliton si Maria gapo isnan kabaelan nan Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose et nalinteg ay ipogaw ngem adina layden ay maibabain si Maria isonga adina kayten ay mangidalom ken siya nodi kanana en apedna isiyan si Maria ay maid mangtek. ");
INSERT INTO xnn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngem idi nemnemnemena pay nan ikkana dat menpaila ken siya isnan iitawna nan anghel ay nagapo ken Apo Dios ay mangwani en, “Jose, ay apon Ali David, adika madanagan ay mang-asawa ken Maria tay nan malitonana et gapo isnan kabaelan nan Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Awnit omanak siya is lalaki dakayot ngadnan siya is Jesus tay siya nan awnit mangisalakan isnan kaipoipogaw ta adida kadosdosa gapo isnan basbasolda.” ");
INSERT INTO xnn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inommat am-in dana tapno matongpal din inpasolat Apo Dios isdin mamadtona id kasin en, ");
INSERT INTO xnn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Awnit maliton nan babai dapay maid nangiseyseyep ken siya et awnit omanak is lalaki ay mangadanan is Emmanuel. Nan kanan nan naay ay ngadan et wada si Apo Dios ken datako.” ");
INSERT INTO xnn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Magido pay si Jose danat tongpalen san kinwanin san anghel ken siya ay asawaena si Maria. ");
INSERT INTO xnn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ngem egayna inid-idlen si Maria engganay binmala nan anakna. Dat ngadnan Jose siya is Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isdin kaalin Herod et siya nan naiyanakan Jesus id Betlehem ay esay ili isnan probinsiya ay Judea. Issan deey ay timpo et inmey id Jerusalem nan mamasilib ay aamam-a ay nagapo isnan balaan di agew. Daida nan mang-ad-adal isnan maipanggep nan talaw. Omdanda pay dadat sooten, ");
INSERT INTO xnn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Into nan onga ay naiyanak ay awnit men-ali isnan Judio? Tay isnan kad-anmi isnan balaan di agew et inilami nan talaw ay nangipagtek ken dakami isnan naiyanakana isonga inmali kami ay mangdayaw ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Issan nangdengngan Ali Herod issan kinwanida dat pilmi nan egyatna tay kanana en waay awnit masokatan siya ay ali ya madanaganda abes nan kailiyana id Jerusalem isnan awnit ommat. ");
INSERT INTO xnn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Danat padagop nan menkangangato ay papadi ya nan men-is-isolo isnan linteg Apo Dios et sootena ken daida mo into nan maiyanakan nan makwani en Kristo ay insolat din mamadton Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dadat ibaga en, “Id Betlehem isnan naay probinsiya ay Judea tay siya na nan insolat din mamadton Apo Dios id sang-adom ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nan ili ay Betlehem isnan probinsiya ay Judea et awnit siya nan kadadayawan isnan am-in ay ili isnan Judea tay isdi nan awnit maiyanakan nan mentolay isnan ipogawko ay Judio et siya nan mang-ay-ayowan ken daida.’” ");
INSERT INTO xnn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dinngen pay Herod di danat ayagan san bisita ay mamasilib ay aamam-a et sootena ken daida ay maiwed mangdedenge no ngan nan timpo ay binmalaan nan talaw. ");
INSERT INTO xnn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Idi gintek Herod danat ibaa daida id Betlehem danapay ibaga ken daida en, “Anapenyo ay gawis san onga. No das-anyo siya dakayot somagong isna ta ipagtekyo ken sak-en tapno omeyak abes ay mangdayaw ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Dadat menlobwat ay omey id Betlehem. Issan mendad-aananda dadat ilaen kasin san talaw isonga palalo nan gasingda. Dat ipangpangon san talaw daida engganay inomdanda isnan kad-an san onga. ");
INSERT INTO xnn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Omdanda pay dadat songgep isnan baey et ilaenda san onga ya si Maria ay inana. Dadat menpalintomeng ay mangdayaw issan onga dadapay ited ken siya nan ninkangingina ay sagotda ay balitok ya nan menbango ay insinso ya mira. ");
INSERT INTO xnn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nakwas di dat ipaiitaw Apo Dios issan mamasilib ay adida somagsagong isnan baey Herod. Isonga dadat idaan isnan teken ay daan ay somaa isnan ilida. ");
INSERT INTO xnn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Idi kinmaan san mamasilib dat kasin menpaila nan anghel Apo Dios isnan iitaw Jose ay mangwani ken siya en, “Bomangonka ta eyeymo ay dagos nan onga yas inana id Egipto dakayot mentee isdi engganay ibagak en somagong kayo kasin. Tay ipaan-anap Herod nan onga ta ipapateyna.” ");
INSERT INTO xnn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dat bomangon si Jose isnan tengan di labi et ilobwatna san onga ya si inana et omeyda id Egipto. ");
INSERT INTO xnn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dadat mentee isdi engganay natey si Ali Herod et siya nan natongpalan din inpasolat Apo Dios isnan mamadtona en, “Awnit ayagak nan Anakko ay magapo id Egipto.” ");
INSERT INTO xnn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Issan nanggetkan Herod ay sinikapan san mamasilib ay aamam-a siya dat dadama nan ligetna isonga danat ibilin ay mapatey am-in ay oongong-a ay lalaki id Betlehem ya isnan am-in ay ili ay sag-ena. Pinateyda am-in ay lalalaki ay kabalbala engganay mentew-en is dowa tay doway tew-en san nallos issan nang-ilaan san mamasilib ay aamam-a issan talaw. ");
INSERT INTO xnn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Isonga natongpal tet-ewa din insolat din mamadto ay kangadan is Jeremias ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Adoado nan men-ag-aga isnan ili id Rama. Men-ag-aga nan iin-a ay aap-on Rakel tay natey nan an-akda. Et adida polos maliwliwa tay epdas natey nan an-akda.” ");
INSERT INTO xnn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Idi natey si Herod dat menpaila kasin nan anghel isnan iitaw Jose id Egipto ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Bomangonka ta isaam nan onga ya si inana id Israel tay nateyda et nan mangwani en mangpatey isnan onga.” ");
INSERT INTO xnn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bomangon pay si Jose danat eyey san onga ya si inana id Israel. ");
INSERT INTO xnn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngem dat dengngen Jose ay si Arkelao ay anak Herod nan mentolay id Judea isonga dat omegyat siya ay somagong isdi. Ngem dat kasin menpaiitaw si Apo Dios ken siya et ibagana en omeyda isnan probinsiya ay Galilea ta isdi nan menteanda. ");
INSERT INTO xnn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dadat omey mentee isnan esa ay ili ay makwani en Nazaret. Et siya nan natongpalan nan kinwanin din deeyday mamadto id kasin maipanggep ken Jesus en, “Awnit kananda en siya nan iNazaret.” ");
INSERT INTO xnn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nakwas pay nan kaat ay tew-en dat omey si Juan ay Menbonbonyag isnan bilbilig id Judea et ilogina ay mangibagbaga isnan ipogaw en, ");
INSERT INTO xnn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ibabawiyo nan ngawi ay ik-ikkanyo tay nganngani ay omali nan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan et siya nan inbagan din mamadto id sang-adom ay si Isaias ay mangwani en, “Wada isnan bilbilig nan mangibogbogaw en, ‘Isaganayo nan daanen nan Apo tako ay awnit omali. Pagawisenyo nan daan ay mendaanana.’” ");
INSERT INTO xnn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nan badon Juan et inabe ay dotdot di camel ay badon di kodo ya kodil nan balikesna ya nan menkatagona et dodon ya dilo. ");
INSERT INTO xnn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Adoado nan om-omey isnan kad-ana tapno dengngenda nan it-itdona. Wadada nan nagapo id Jerusalem ya isnan probinsiya ay Judea ya isnan kailiili ay sag-en nan ginawang ay Jordan. ");
INSERT INTO xnn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dadat ibabawi nan basbasolda tapno mapakawanda ken Apo Dios dadapay menpabonyag ken Juan isnan ginawang ay Jordan. ");
INSERT INTO xnn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngem isnan nang-ilaan Juan isnan adoado ay Fariseo ya Saduceo ay omey menpabonyag ken siya danat kanan ken daida en, “Dakayo ay aginsosolot ken Apo Dios, ay kananyo en omanay nan mabonyaganyo is kaisalakananyo isnan awnit mendosaan Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngem adi kayo aped mabonyagan mo adiyo dokogan nan ngawi ay ogaliyo tay masapol ay ipailayo ay tet-ewa ay inbabawiyo nan basbasolyo. ");
INSERT INTO xnn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Et adiyo kanan en mailisi kayo isnan dosan Apo Dios gapo tay apoyo din si Abraham ay nangtongtongpal ken Apo Dios. Ngem baken di is mangilisi ken dakayo tay olay nan bato ay naay et mabalin ay menbalinen Apo Dios is ap-on Abraham.” ");
INSERT INTO xnn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dat itoloy Juan ay mangwani en, “Nan awnit idosan Apo Dios et siya nan kaneg nan wasay ay naisasagana ay mangpoyo isnan kaiw. Am-in ay kaiw ay adi bomgas is gawis et mapoyo dat mapoowan. Et dakayo nan kaneg nan kaiw ay adi bomgas.” ");
INSERT INTO xnn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Danat itoloy ay mangwani en, “Danom nan ibonyagko ken dakayo ay mangipagtek en inbabawiyo nan basbasolyo. Ngem wada nan wedweda mo sak-en ay omon-onod et gapo isnan kawedwedana et adiyak maibilang ay mangkaan isnan sapatosna. Siya nan awnit mangibonyag ken dakayo isnan Ispirito Santo ya nan apoy. ");
INSERT INTO xnn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","No omali siya awnitna mensiyanen nan mamati ken siya isnan adi mamati et kaneg waday ligao ay mangtap-ana isnan pagey danat idolin isnan agamang nan mabgas danapay igwa nan kipit isnan apoy ay adi katkatkatey.” ");
INSERT INTO xnn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Daan ay menbonbonyag si Juan isnan ginawang ay Jordan dat omdan si Jesus ay nagapo id Galilea ay menpabonyag ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ngem kinwanin Juan en, “Ay sak-en nan mangbonyag ken sik-a dapay lebbengna ay sik-a koma nan mangbonyag ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ngem dat kanan Jesus, “Olay, tay gawis no ikkanta nan layden Apo Dios.” Isonga dat bonyagan Juan si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nabonyagan pay si Jesus daet domaka isnan ginawang daet mapewak id daya danat ilaen nan Ispirito Santo ay lomayog ken siya ay kaneg kalapati et pomatong ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dat wada nan kali ay nagapo id daya ay mangwani en, “Si tona nan Anakko ay laylaydek. Men-galalasingak gapo ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nakwas pay di dat ipangon nan Ispirito Santo si Jesus isnan bilbilig tapno dologen Satanas siya. ");
INSERT INTO xnn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Epatpoo ay agewna isdi ay egay nangnangan isonga naowaowat siya. ");
INSERT INTO xnn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dat ilogin Satanas ay mangdolog ken siya ay mangwani en, “No tet-ewa ay Anak Apo Dios sik-a dakan adi kanan ta maboliw nan naayda ay bato is makan?” ");
INSERT INTO xnn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dat songbatan Jesus ay mangwani en, “Kanan nan naisolat ay kalin Apo Dios en baken makan et kedeng di katagowan di ipogaw nodi masapol ay patiyenda am-in nan kankanan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dat ipangon Satanas si Jesus id Jerusalem danat eyey siya isnan toktok di Templo ");
INSERT INTO xnn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","danat kanan ken siya, “No tet-ewa ay Anak Apo Dios sik-a kadya lomabtokka isna. Tay kanan nan naisolat ay kalin Apo Dios en bilinena nan aanghelna ta ayowananda ay mangtapaya ken sik-a ta adi masogatan nan dapanmo isnan bato.” ");
INSERT INTO xnn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ngem dat songbatan Jesus siya ay mangwani en, “Nan naisolat ay kalin Apo Dios et kanana gedan en adiyo dologen si Apo Dios ay Apoyo.” ");
INSERT INTO xnn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nakwas di dat ipangon kasin Satanas si Jesus isnan ataatakdag ay bilig et ipailana nan am-in ay ili isnan batawa ya nan kinabaknangda. ");
INSERT INTO xnn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Danat kanan, “Idyak am-in dana ken sik-a no menpalintomengka ay mangdayaw ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dat kanan Jesus, “Komaanka Satanas tay kanan nan naisolat ay kalin Apo Dios en sak-en ay Diosyo nan daydayawenyo ya mensilsilbiyanyo et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dat komaan si Satanas dapay domateng nan aanghel Apo Dios et badanganda si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Idi dinngen Jesus ay naibalod si Juan ay Menbonbonyag, sinmagong siya isnan probinsiya ay Galilea ay men-isolo. ");
INSERT INTO xnn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ngem egay nintee id Nazaret ay ilina nodi inmey id Capernaum ay esay ili isnan benget di baybay ay Galilea isnan sakopen nan dagan Zabulon ya dagan Neftali. ");
INSERT INTO xnn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Naikkan dana tapno matongpal din insolat din mamadto ay si Isaias id sang-adom ay naay, ");
INSERT INTO xnn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Id Galilea isnan dagan da Zabulon ken da Neftali isnan benget di baybay ya isnan bas-ang di ginawang ay Jordan et siya gedan nan kad-an di baken Judio. ");
INSERT INTO xnn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nan ipogaw isdi et menbolinget nan nemnemda isonga kanegda natey tay adida getken si Apo Dios. Ngem awnit isdi nan mentanggewan nan silaw tay omey nan mangisolo ken daida et awnit matanggewan nan nemnemda.” ");
INSERT INTO xnn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Natongpal san deey ay kali tay isnan deey ay timpo inlogin Jesus ay men-isolo ay mangmangwani en, “Ibabawiyo nan basbasolyo tay nganngani ay omali nan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Isnan esa ay agew ay mendad-aan si Jesus isnan benget di baybay ay Galilea danat ilaen nan doway sin-agi ay da Simon ay makwani en Pedro ya si Andres. Mensidsidokda isnan baybay tay siya nan oblada. ");
INSERT INTO xnn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Dat kanan Jesus ken daida en, “Akayo ta maitapi kayo ken sak-en. Id kawni ninsidok kayo is ikan ngem id wani isolok abes nan ikkanyo ay mensidok is ipogaw ta maitapida isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dadat taynan nan sidokda et ikamoda ay omonod ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Idi mendad-aanda dat ilaen Jesus da Santiago ken Juan yas amada ay Zebedeo ay mangitotokdo isnan bangkada ay mang-es-eset isnan sidokda. Dat ayagan Jesus da Santiago ken Juan ta maitapida abes ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dadat taynan abes nan bangkada yas amada et ikamoda ay omonod ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Inmey si Jesus isnan il-ili isnan probinsiya ay Galilea et men-is-isolo isnan kasinasinagoga. Inpagpagtekna nan gawis ay damag ay maipanggep isnan mentolayan Apo Dios ya pinagawisna nan natkenatken ay saksakit di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nindinamag nan inikkan Jesus isnan am-in ay ili ay sakop nan Siria isonga dadat eyey ken siya nan ipogaw ay wada nan sakitda ay kaneg nan kinapet di anito ya nan menkedas ya nan napilay et inpagawisna am-in daida. ");
INSERT INTO xnn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Isonga inmonod nan adoado ay ipogaw ken siya. Wadada nan nagapo isnan probinsiya ay Galilea ya Judea ya wadada gedan nan nagapo id Jerusalem ya Decapolis ya isnan bas-ang nan ginawang ay Jordan. ");
INSERT INTO xnn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Inilan Jesus nan adoado ay ipogaw ay omey ken siya dat tomikid isnan bilig danat itokdo et somag-en nan papasolotna ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Dat ilogin Jesus ay men-isolo ken daida ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nagasat nan mangtek ay kolang nan kabaelana ay mang-ikkan isnan layden Apo Dios tay daida nan awnit maitapi isnan mentolayana. ");
INSERT INTO xnn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nagasat nan menseseg-ang gapo isnan basbasolda tay awnit liwliwaen Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nagasat nan mangipabababa isnan nemnemda tay awnit ited Apo Dios nan am-in ay inkalina ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nagasat nan manglaylayad ay mang-ikkan isnan layden Apo Dios tay awnit mapnekda. ");
INSERT INTO xnn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nagasat nan managseg-ang isnan iib-ada tay awnit seg-angan Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nagasat nan ipogaw ay kedeng nan layden Apo Dios is nemnemnemenda ay ikkan tay awnitda ilaen siya. ");
INSERT INTO xnn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nagasat nan mang-ol-olnos isnan iib-ada tay awnitda maibilang ay an-ak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nagasat nan mang-it-itpe isnan ligat gapo isnan mang-ik-ikkananda isnan layden Apo Dios tay awnitda maitapi isnan mentolayana id daya. ");
INSERT INTO xnn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nagasat kayo no aamisen di ipogaw dakayo ya palpaligatenda dakayo dadapay kanan am-in nan ngawi maipanggep ken dakayo gapo isnan mangpatpatiyanyo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Men-gasing kayo od tay olay no adoado nan ligatyo id wani et awnit dakkel nan ganabenyo ay idyan Apo Dios ken dakayo ay insaganana id daya. Tay nan ikkanda id wani ken dakayo et siya gedan nan inik-ikkan din alal-apoda id sang-adom isdin mamadton Apo Dios isonga men-galalasing kayo isnan maiyisowanyo ken daida.” ");
INSERT INTO xnn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Dat itoloy Jesus ay men-isolo et kanana, “Gawis nan asin ay os-osalen tako tay pagawisena nan makan. Et dakayo ay mamati ken sak-en et kaneg dakayo nan asin di kaipoipogaw isnan batawa tay nan mangisolsolowanyo ken daida et pagawisenyo nan ogalida. Ngem no epdas tinmamnay nan asin et adi mabalin ay makaasin ya maid silbina nodi maiwasit ay gatgatinan nan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dat kasin kanan Jesus, “Nan ili isnan bilig et adi polos maigago. Siya nan kanegyo tay dakayo nan kaneg silaw ay mangtanggew isnan nemnem di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Maid mangpasged is silaw danat salinan is timba tasiyay adi kaila nan silangna nodi ipatangna tapno masilawan am-in nan baey. ");
INSERT INTO xnn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Et siya abes nan masapol ay ikkanyo ta adiyo igagago nan mangsolsolotanyo ken Apo Dios nodi ipailayo tapno getken nan kaipoipogaw nan gawis ay ogaliyo dadat mendayaw ken Amayo id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dat kanan Jesus en, “Adiyo nemnemnemen ay inmaliyak ay mangpamaid isnan linteg Moses ya nan insolsolon nan mamadto nodi inmaliyak tapno tongpalek nan am-in ay inbagbagada. ");
INSERT INTO xnn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ibagak ken dakayo nan tet-ewa ay engganay wada pay laeng nan batawa ya nan daya et adi polos mabalin ay mamaid nan linteg Apo Dios is olay bassit engganay matongpal nan am-in. ");
INSERT INTO xnn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Et nan ipogaw ay adi mangtongpal isnan olay teeteen ay linteg Apo Dios ya mangisolo isnan iib-ana tapno makiikkanda abes ken daida et awnit siya nan kababaan isnan mentolayan Apo Dios. Ngem nan ipogaw ay mangtongpal isnan linteg Apo Dios ya mangisolo isnan iib-ana tapno tongpalenda abes et awnit siya nan kaaamedan isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Isonga ibagak ken dakayo en adi kabalin ay maitapi kayo isnan mentolayan Apo Dios no baken napaspasnek nan ikkanyo ay mangtongpal isnan laydena mo nan ik-ikkan nan Fariseo ya nan men-is-isolo is linteg.” ");
INSERT INTO xnn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Intoloy Jesus ay mangwani, “Getkenyo nan naibaga isnan linteg id sang-adom ay adi kayo menpatpatey tay nan ipogaw ay menpatey et maiyeyda isnan pagbistaan. ");
INSERT INTO xnn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngem ibagak ken dakayo ay nan ipogaw ay makaliget isnan ib-ana et awnit maiyeyda isnan pagbistaan. Ya nan ipogaw ay mangiiyaw isnan ib-ana et awnit maiyeyda isnan nangatngato pay ay pagbistaan. Ya nan ipogaw ay mangbab-aos isnan ib-ana et awnit omey isnan kad-an di apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Isonga no wada nan itedyo isnan Templon Apo Dios dayot nemnemen omona no waday mangliliget ken dakayo ");
INSERT INTO xnn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","et masapol ay taynanyo nan itedyo ken Apo Dios ta enkayo omona makitoya isnan mangliliget ken dakayo sakayopay omey ited nan itedyo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","No wada pay gedan di mangidalom ken dakayo dakayot omey omona ken siya tapno aliglowenyo sadapay eyey dakayo isnan pagbalodan. Tay no epdasda eyey dakayo isnan howis et waay itedna dakayo isnan polis et ibalodna dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Et adi kayo makabala isnan pagbalodan engganay bayadanyo am-in nan moltayo.” ");
INSERT INTO xnn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Dinngeyo gedan nan kinkinwanida id sang-adom en adi kayo makikamkamolala. ");
INSERT INTO xnn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngem ibagak na ken dakayo, no wada ken dakayo nan mang-ila isnan babai danat nemnemnemen ay mangiseyep ken siya et law-en Apo Dios tay kaneg gedan mamabai. ");
INSERT INTO xnn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Isonga no nan pang-ilan nan esa ay matam is makabasolam et gawis no soklatem laengen tay gag-awis no es-esang nan matam id wani ngem wada nan biyagmo ken Apo Dios ay enggana mo nan awakmo ay maid kolangna ngem omey isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wenno nan ikkan nan esa ay ledengmo di makabasolam et gawis no pokolam ta iwasitmo tay gag-awis no es-esa nan ledengmo mo nan awakmo ay maid kolangna ngem omey isnan apoy ay adi katkatey.” ");
INSERT INTO xnn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kinkinwanida id sang-adom abes en nan lalaki ay makiidang et masapol ay waday kasolatan is mangipagtek ay ninsiyanda. ");
INSERT INTO xnn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngem ibagak ken dakayo en bomasol nan lalaki ay aped makiidang dapay egay makikamkamolala nan babai. Tay no makiasawa kasin san babai et bomasol san asawana tay pinabalina siya ay makilalalaki. Ya nan maikadwa ay asawaena et bomasol gedan tay kanega mamabai.” ");
INSERT INTO xnn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Getkenyo gedan nan linteg id sang-adom ay adiyo dokdokogan nan insapatayo tay no waday insapatayo ken Apo Dios et masapol tongpalenyo. ");
INSERT INTO xnn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ngem ibagak ken dakayo en no waday ibagayo is ikkanyo et adi kayo mensapsapata. Adi kayo aped mensapsapata id daya tay siya nan kad-an Apo Dios ");
INSERT INTO xnn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wenno isnan batawa tay siya nan men-gagatinan nan sikina wenno id Jerusalem tay siya nan ilin nan kangatowan ay Apo. ");
INSERT INTO xnn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Olay nan oloyo et adiyo gedan isapsapata tay maid kabaelanyo ay mangipapolaw wenno mangipangitit is olay esay book. ");
INSERT INTO xnn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nodi gag-awis no kananyo en owen no tet-ewa wenno adi no baken tay magapgapo ken Satanas nan kompolmi ay itaptapiyo.” ");
INSERT INTO xnn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Dinngeyo abes nan kinkinwanida id sang-adom ay no waday mangtedkaw isnan matan nan ib-ana et awnitda tedkawen abes nan matana ya no waday mangpogopog isnan bab-an nan ib-ana et awnitda pogopogen abes nan bab-ana. ");
INSERT INTO xnn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngem ibagak ken dakayo en adi kayo ibab-aes nan kompolmi ay ikkan nan ib-ayo ken dakayo. Nodi no waday mangtipak isnan ipingmo dakat idoo nan topakna. ");
INSERT INTO xnn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No waday mangidalom ken dakayo ta mamolta kayo is bado dakayot agtan is abito gedan. ");
INSERT INTO xnn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No waday mangipapati ken dakayo en awitenyo nan awitna is esay kilometro dakayot awiten is doway kilometro. ");
INSERT INTO xnn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ya no waday menkedaw dakayot agtan ya no waday menbolod dakayot pabolodan. ");
INSERT INTO xnn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Getkenyo abes ay naibaga id sang-adom ay laylaydenyo nan iib-ayo dayopay adyan nan mang-aamis ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngem ibagak ken dakayo en masapol ay laylaydenyo nan olay mang-aamis ken dakayo dayopay ilowalowan nan mangpalpaligat ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tay no siya dana nan ik-ikkanyo et ipailayo dadlo ay an-ak Ama tako id daya dakayo. Tay ipalpalobos Apo Dios nan agew ay mangtangtanggew isnan am-in ay ipogaw ay gawis nan ogalida ya nan ngawi gedan. Kaneg abes nan odan et it-itedna isnan kaipoipogaw ay gawis nan ik-ikkanda ya isnan ngawi gedan. ");
INSERT INTO xnn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ay kananyo ngen en it-it-ek Apo Dios dakayo no kedeng nan manglaylayad ken dakayo is laylaydenyo? Tay olay nan mensingsingil is bowis ay sowitik et siya abes nan ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngan ngalod di katekenyo isnan adi mamati no kedeng nan iib-ayo is toytoyaenyo ay gawis dapay olay nan adi mangtek ken Apo Dios et ik-ikkanda gedan. ");
INSERT INTO xnn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Si Ama tako id daya et kedeng nan gawis is ik-ikkana isonga masapol ay siya nan solsoloten tako tapno menbalin tako ay kaneg ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Intoloy Jesus ay men-isolo et kanana, “Makailanyo ta baken kedeng isnan mangiilaan nan ipogaw ken dakayo is mang-ik-ikkananyo is gawis. Tay no siya na nan wada isnan nemnemyo et awnit maid polos ganabenyo is ited Amayo id daya ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Isonga no waday badanganyo isnan kodokdo et adiyo ipapaila ya iwalwalagawag ay kaneg nan ik-ikkan nan aginsisingpet ay ipogaw. Tay ipagpagtekda nan gawis ay ik-ikkanda isnan sinagoga ya nan tap-in di om-ombonan di ipogaw tapno dayawenda daida. Ibagak ken dakayo en nan tet-ewa et epdasda ginanab nan ligaloda. ");
INSERT INTO xnn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ngem no waday badanganyo isnan iib-ayo et adiyo ipagpagtek isnan olay bebsatyo ");
INSERT INTO xnn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tapno maid polos makagtek. Et si Apo Dios ay mangtek isnan am-in ay ik-ikkanyo et siya nan mang-ited isnan ganabenyo.” ");
INSERT INTO xnn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“No menlowalo kayo et adiyo koma toltoladen nan ik-ikkan nan aginsisingpet ay ipogaw. Tay gagalaenda ay tomakdeg ay menlowalo isnan paggimonganda ya isnan tengan nan daan tapno boyaen nan ipogaw. Ibagak ken dakayo en nan tet-ewa et epdasda ginanab nan ligaloda. ");
INSERT INTO xnn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ngem dakayo no menlowalo kayo ken Apo Dios et songgep kayo isnan baeyyo dayot emban tapno maid mangiila ken dakayo. Et si Apo Dios ay mangiila isnan am-in et awnitna agtan dakayo is ligaloyo. ");
INSERT INTO xnn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Isnan menlowalowanyo et adi kayo andoandowen ay kaneg nan ik-ikkan nan adi mamati ken Apo Dios tay kananda en no andoandowenda et madnge nan lowaloda. ");
INSERT INTO xnn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adiyo toltoladen daida tay getken Amayo id daya nan masapolyo sayopay ilowalo. ");
INSERT INTO xnn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Isnan menlowalowanyo ngalod ken Apo Dios et siya na nan kananyo, ‘Amami ay wada id daya, Madaydayaw koma nan ngadanmo. ");
INSERT INTO xnn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Omdan koma ay dagos nan mentolayam tapno matongpal nan laydem isnan batawa ay kaneg id daya. ");
INSERT INTO xnn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Agtam dakami is menkatagomi isnan inagew. ");
INSERT INTO xnn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakawanem nan basbasolmi ay kaneg nan mangpakawananmi abes isnan nakabasol ken dakami. ");
INSERT INTO xnn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Adim ipalobos dakami ay bomasol nodi badangam dakami ta adi kami madoldolog.’” ");
INSERT INTO xnn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Dat itoloy Jesus ay mangwani, “No pakawanenyo nan makabasol ken dakayo et pakawanen abes Amayo id daya nan basbasolyo. ");
INSERT INTO xnn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ngem no adiyo pakawanen daida et adi abes pakawanen Amayo id daya nan basbasolyo.” ");
INSERT INTO xnn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Dat itoloy Jesus ay mangwani en, “Isnan menteptepeanyo no menlowalo kayo ken Apo Dios et adiyo koma toltoladen nan ik-ikkan nan aginsisingpet. Tay isnan menteptepeanda et laydenda ay getken nan ipogaw nan ik-ikkanda isonga adida mendad-aop ya mensagsagaysay dadapay aginseseg-ang. Ibagak ken dakayo en nan tet-ewa et epdasda dinawat nan ligaloda. ");
INSERT INTO xnn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ngem no mentepe kayo et mendaop kayo dayopay sagaysayen nan bookyo ");
INSERT INTO xnn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tapno adi madlaw ay menteptepe kayo nodi kedeng si Apo Dios ay adi kaila is mangtek tay siya nan mangiila isnan am-in ya siya abes nan mang-ited isnan ganabenyo.” ");
INSERT INTO xnn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Dat itoloy Jesus ay mangwani en, “Adi kayo nemnemnemen ay men-ol-olnong is bomaknanganyo isnan kad-anyo isnan naay batawa. Tay nan kokwayo isnan batawa et nalaka ay dadaelen nan ataming ya lati ya akewen pay nan mangakew. ");
INSERT INTO xnn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Isonga nan layden Apo Dios di ik-ikkanyo koma tay no siya di nan ikkanyo et awnit wada nan kinabaknangyo id daya ay maid polos makaakew ya makadadael. ");
INSERT INTO xnn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tay no id daya nan kad-an nan kinabaknangyo et siya gedan nan kad-an nan nemnemyo ngem no isnan batawa nan kad-ana et siya abes nan kad-an nan nemnemyo.” ");
INSERT INTO xnn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Dat itoloy Jesus et kanana en, “Nan mata et siya nan kaneg nan silaw nan awak isonga no gawis nan pangiilam isnan ib-am et kaneg menpat-a nan awakmo tay gawis nan wada isnan nemnemmo. ");
INSERT INTO xnn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ngem no ngawi nan pangiilam isnan ib-am et kaneg menbolinget nan awakmo tay ngawi nan wada isnan nemnemmo.” ");
INSERT INTO xnn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Intoloy Jesus ay mangwani en, “Nan baa et adi mabalin ay madodowa nan apona tay awnitna laylayden nan esa danapay aamisen nan esa isonga wada nan paam-amdena ken daida. Kaneg abes ken dakayo ay no nan kinabaknangyo nan nemnemnemenyo et adi kayo et makaikkan isnan layden Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Siya di nan gapo ay ibagak ken dakayo en adi kayo madanagan is menkatagoyo ya is ibadoyo tay wedweda nan biyag mo nan makan ya nan awak mo nan bado. ");
INSERT INTO xnn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ilaenyo pod nan koyat. Adida menmola ya men-ani et maid agamangda is mangidoldolinanda is menkatagoda dapay kayet pakpakanen Amayo id daya daida. Ay baken am-amed nan mang-ayowanana ken dakayo? Napatpateg kayo adi mo nan koyat. ");
INSERT INTO xnn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Olay enka mennemnenemnem ngem aykeka makaipaan-ando is biyagmo is olay esay olas? ");
INSERT INTO xnn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dakayon abes aped madanagan is ibadoyo? Ilaenyo pod nan sabsabong ay tomotobo isnan bilbilig. Adida men-obla ya adida men-abe is badoda. ");
INSERT INTO xnn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ngem ibagak ken dakayo en palalo ay mabmabgew nan sabsabong mo din kagawisan ay badon din si Ali Solomon ay kabaknangan id sang-adom. ");
INSERT INTO xnn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","No gawis nan nemnem Apo Dios isnan sabsabong isnan tomotobowanda is sin-awyan dadat maango et mapoowanda, ay adi am-amed nan mangnemnemana ay mangbado ken dakayo? Kolang bawet nan talekyo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Isonga adi kayo madanagan is kanenyo ya badoyo. ");
INSERT INTO xnn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tay siya na nan nenenenemnemen nan adi mamati ken Apo Dios. Ngem dakayo et gegetken Amayo id daya nan am-in ay masapolyo. ");
INSERT INTO xnn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Isonga paam-amdenyo kayet ay mangnemnem isnan mentolayan Apo Dios ya nan laydena ay ikkanyo et awnitna ited ken dakayo nan am-in ay masapolyo. ");
INSERT INTO xnn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Isonga adi kayo madanagan id wani isnan ligat ay waay awnit ommat is wakgat. Awni ta mawakgat. Tay amedyo taptapiyan nan ligatyo id wani no itaptapiyo ay mangnemnemnem isnan ligat ay awnit ommat is wakgat.” ");
INSERT INTO xnn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Intoloy Jesus ay men-isolo ay mangwani en, “Adiyo pabasbasolen nan ib-ayo tapno adi abes pabasolen Apo Dios dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tay nan ikkanyo ay mangpabasol isnan ib-ayo et siya abes nan ikkan Apo Dios ay mangpabasol ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dat menpangngalig si Jesus maipanggep isnan menkalkali is basol di ib-ada et kanana, “Damen delawen nan bota isnan matan nan besatmo dapay adim madlaw nan kega sindomet ay bota isnan matam? ");
INSERT INTO xnn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ngan nan ikkam ay mangwani en, ‘Pangaasim besatko ta kaanek nan bota isnan matam,’ dapay wada nan kega domet ay bota isnan matam? ");
INSERT INTO xnn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sik-a ay aginsisingpet. Kaanem omon-ona nan dakkel ay bota isnan matam tapno makaila ay gawis esakapay kaanen nan teeteen ay bota isnan matan nan besatmo.” ");
INSERT INTO xnn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dat itoloy Jesus, “Adiyo ipapati ay mangisolo isnan kalin Apo Dios isnan adi mangidnge tay kanegda aso ay olay gawis nan itedyo et ketbanda kayet dakayo. Ya kanegda gedan beteg ay mo maitep-a nan napateg ay oway isnan sagangda dadat aped gatigatinan.” ");
INSERT INTO xnn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dat kanan Jesus pay, “No waday masapolyo, menlowalo kayo ay mendawat ken Apo Dios et awnitna ited nan masapolyo ta no waday an-anapenyo et awnityo datngan. Kaneg no menkogkog kayo isnan segpan et tokabana ta songgep kayo. ");
INSERT INTO xnn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tay am-in ay kadadanawat ya kalalanowalo ken Apo Dios et awnitna agtan. Ya nan kakakanogkog et awnitna tokaban nan eneb ta songgepda. ");
INSERT INTO xnn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Waay maid ama ken dakayo is mang-idya is bato isnan anakna no mendawat siya is kanena ");
INSERT INTO xnn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","wenno agtana siya is oweg no mendawat is ikan. ");
INSERT INTO xnn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Adi, tay olay no ngawi kayo ay ama et getkenyo ay mang-ited is gawis isnan an-akyo. Isonga am-amed nan ikkan Amayo id daya ay mang-ited isnan gawis ken daida ay mendawat ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Isonga ikkanyo isnan ib-ayo nan kaytenyo ay ikkanda ken dakayo. Tay siya nan osto ay kayat ay kanan nan linteg din si Moses ya siya nan init-itdon din mamadton Apo Dios id sang-adom.” ");
INSERT INTO xnn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kinwanin Jesus gedan en, “Masapol ay songgep kayo isnan nalipit ay segpan tay siya nan omey isnan kad-an di biyag ay maid patenggana. Nan segpan ay omey isnan apoy ay adi katkatey et nalawa dapay nalaklaka nan daan isonga adoado nan ipogaw ay om-omey isdi. ");
INSERT INTO xnn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngem nan segpan ay omey isnan kad-an di biyag ay maid patenggana et nalipit dapay naligat ay masolotan nan daan isonga at-atik nan makaey.” ");
INSERT INTO xnn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Intoloy Jesus ay mangwani en, “Makailanyo nan baken tet-ewa ay mamadton Apo Dios ay omali ken dakayo. Tay naanos nan kaiilaanda ay kaneg nan kalnilo ngem nan tet-ewa et kanegda naangnganga ay aso. ");
INSERT INTO xnn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Isonga nan ik-ikkanda ay baken gawis et siya nan mangilasinanyo ken daida. Kaneg isnan kaiw ay nan begasna nan mangilasinanyo. Tay adi mabalin ay bomgas nan kawayan is papaya ya nan sibit is alomani. ");
INSERT INTO xnn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nan gawis ay kaiw et gawis nan ibgasna ngem nan ngawi ay kaiw et ngawi nan ibgasna. ");
INSERT INTO xnn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tay nan gawis ay kaiw et adi kabalin ay bomgas is ngawi ya siyang na gedan isnan ngawi et adi makabegas is gawis. ");
INSERT INTO xnn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Am-in ay kaiw ay adi bomgas is gawis et awnit mapoyo dat mapoowan. ");
INSERT INTO xnn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Isonga mabalin ay mailasinanyo nan baken tet-ewa ay mamadton Apo Dios gapo isnan ik-ikkanda.” ");
INSERT INTO xnn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Baken am-in nan mangwani en sak-en nan Apoda is maitapi isnan mentolayan Apo Dios nodi kedkedeng nan mang-ik-ikkan isnan layden Ama id daya nan awnit maitapi. ");
INSERT INTO xnn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Isnan awnit mangbanagan Apo Dios isnan kaipoipogaw et ado nan awnit mangmangwani en, ‘Apo, itapim dakami isnan mentolayam tay insolsolomi nan maipanggep ken sik-a ya inosalmi nan ngadanmo ay nang-ikkan isnan ado ay kaskasdaaw ya nangpakak-aan isnan anito ay kinmapet isnan ipogaw.’ ");
INSERT INTO xnn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngem awnit kanak ken daida en, ‘Adiyak getgetken dakayo. Komaan kayo ay managbasol.’” ");
INSERT INTO xnn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Dat itoloy Jesus ay mangwani en, “Am-in ay mangidnge ya mangpati isnan ibagbagak et kanegda nan masilib ay ipogaw ay ninsaad ay nangikaob ay gawis isnan tokodna enggana ay maipegnad isnan bato esanapay saaden nan baeyna. ");
INSERT INTO xnn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Isonga no lomemlem ya men-inewang et adi polos maiyanod nan baeyna tay naipegnad isnan bato. ");
INSERT INTO xnn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngem am-in ay mangdenge ngem adida patiyen nan ibagbagak et kanegda nan ipogaw ay nangsaad isnan baeyna isnan lota ay egayna pegnadan is bato. ");
INSERT INTO xnn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Isonga no lomemlem ya men-inewang et makibet ay matokang san baeyna tay egayna pegnadan ay gawis.” ");
INSERT INTO xnn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Issan nakwasan san inbagan Jesus et nasdaaw am-in nan ipogaw ay nadagop isdi ");
INSERT INTO xnn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tay nan insolsolona et naiitken mo nan insolsolon nan men-is-isolo isnan linteg tay maila nan lebbeng Jesus isnan ikkana ay men-isolo. ");
INSERT INTO xnn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Issan kinmaanan Jesus isnan bilig ay deey et inmonod nan adoado ay ipogaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dat somag-en nan am-ama ay nakolit isnan kad-an Jesus dat menpalintomeng ay mangwani en, “Apo, getkek ay kabaelam ay mangkaan isnan sakitko no kayatmo.” ");
INSERT INTO xnn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dat gen-an Jesus siya danapay kanan, “Kayatko ay maagasanka.” Dat dagos ay makaan nan kolitna. ");
INSERT INTO xnn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Danat kanan ken siya, “Adim ibagbaga nan inikkak ken sik-a. Basta idadawesmo ta enka menpaila isnan padi damet idya nan limosmo ay mapalti ay kaneg din inbilin Moses ta pangtekan nan ipogaw ay ginmawiska.” ");
INSERT INTO xnn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Idi inomdan si Jesus id Capernaum dat sab-aten nan esa ay iRoma ay kapitan di ado ay soldado. Inmey ken Jesus ay menseg-ang ken siya en, ");
INSERT INTO xnn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Apo, wada nan baak id baey ay pilmi nan sakitna et adi makakiwi.” ");
INSERT INTO xnn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Dat kanan Jesus ken siya, “Owen, omaliyak ta pagawisek siya.” ");
INSERT INTO xnn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ngem dat kanan san kapitan, “Olay adika omali tay adi maibagay ay songgepka isnan baeyko tay bakenak Judio. Omanay nan kalim ay mangipagawis ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tay olay sak-en et wada nan nangatngato ay opisyal ay mangbab-aa ken sak-en. Et wada gedan nan sosoldado ay bab-aaek et patiyenda nan kankanak. No ibagak isnan esa en, ‘Omeyka,’ dat omey ay dagos ya no ibagak isnan esang en, ‘Omalika,’ dat omali ya no ibagak isnan esa en, ‘Ikkam na,’ danat ikkan tet-ewa. Isonga getkek ay omanay nan kalim is mangpagawis ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nasdaaw si Jesus isnan dinngena danat kanan isnan ipogaw ay omon-onod ken siya en, “Ibagak ken dakayo en maid polos dinasdas-ak is napigpigsa ay talek isnan Judio ay kaneg nan talek nan naay kapitan. ");
INSERT INTO xnn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Et ibagak ken dakayo en adoado ay ipogaw ay baken Judio ay magapo isnan natkenatken ay ili nan awnit maitapi isdin alal-apo tako ay da Abraham, Isaac yas Jacob isnan men-gasgasinganda isnan mentolayan Apo Dios id daya. ");
INSERT INTO xnn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ngem nan bebsatko ay Judio ay maitapi koma isnan mentolayan Apo Dios et awnitda maitep-a isnan kad-an nan menbolinget et men-ag-ag-agada dadapay men-owakis isdi tay pilmi nan ligatda.” ");
INSERT INTO xnn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dat kanan Jesus isnan kapitan en, “Somaaka tay gapo isnan talekmo et matongpal nan dawdawatem.” Et tinmet-ewa tay issan menkalkaliyan Jesus et ginmawis ay dagos nan sakit san baa. ");
INSERT INTO xnn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Dat omey si Jesus isnan baey Pedro et inilana ay pomopodan nan katogangan Pedro ay babai tay menpodpodot. ");
INSERT INTO xnn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Dat sag-enen Jesus siya et gen-ana nan ledengna dat maganawis siya. Dat bomangon et pakanena daida. ");
INSERT INTO xnn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Isnan sedemna dadat iyey ken Jesus nan ipogaw ay kinapet di anito. Et olay no kali nan inosalna et kedeng et inpakaana am-in ay anito ya pinagawisna gedan nan masaksakit. ");
INSERT INTO xnn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nan inikkana ay naayda et siya nan natongpalan din insolat di mamadto ay si Isaias ay mangwani en, “Siya ay mismo nan manglak-am isnan ligat tako ya mangkaan isnan sakit tako.” ");
INSERT INTO xnn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Isnan esa ay sedem et al-alibongbongan kayet di adoado ay ipogaw si Jesus isonga danat ibaga isnan papasolotna en omeyda isnan bas-ang di baybay. ");
INSERT INTO xnn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngem sadapay menlobwat dat somag-en ken siya nan esay men-is-isolo isnan linteg et kanana, “Apo, omon-onodak ken sik-a olay intoy omay-ayam.” ");
INSERT INTO xnn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dat kanan Jesus ken siya en, “Owen, ngem nemnemem ay gawis tay naligat nan ik-ikkak. Tay nan motit ya nan koyat et wada nan baeyda dapay sak-en ay Iyon-an Am-in di Ipogaw et maiwed osto is baeyko is omil-illengak.” ");
INSERT INTO xnn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dat kanan nan esay pasolot Jesus en, “Apo, awnika od ta makilebenak ken Ama sakpay omonod ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ngem dat kanan Jesus ken siya, “Gag-awis no id wani nan mang-onodam ken sak-en. Tay nan iib-an amam ay adi mamati ken Apo Dios et kanegda natey isonga olay daida nan mangileben isnan ib-ada.” ");
INSERT INTO xnn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dat menlogan si Jesus ya nan papasolotna isnan bangka. ");
INSERT INTO xnn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Idi om-omeyda dat maseyep si Jesus. Dat domateng nan napigsa ay dagem et masepyatan nan bangkada et nganngani ay malimonda. ");
INSERT INTO xnn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dat omegyat nan papasolot Jesus et gidowenda siya dadapay kanan en, “Apo, isalakam dakami tay naay malimon tako.” ");
INSERT INTO xnn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dat kanan Jesus, “Dakayon omegyat? Atiatik obpay nan talekyo.” Dat tomakdeg et ipakin-ena nan dagem ya nan danom et omnengda. ");
INSERT INTO xnn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nasdanasdaawda am-in et kananda en, “Manakabalin obpay nan ipogaw ay naay tay olay nan dagem ya nan danom et tongpalenda siya.” ");
INSERT INTO xnn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Issan inomdan da Jesus isnan demang di baybay ay lakon di Gadareno dat sab-aten nan dowa ay lalalaki ay kinapet di anito ay nagapo isnan liyang ay kad-an di natey. Pilmi nan kedseda isonga omegyat nan ipogaw ay mendaan isdi. ");
INSERT INTO xnn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Dadat ibobogaw ay mangwani ken Jesus en, “Sik-a nan Anak Apo Dios, ay ngan di ngotom ken dakami isna? Ay inmalika ta dosaem dakami id wani dapay egay omdan nan osto ay timpo?” Siya nan inpakalin nan anito ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dat wada nan adoado ay beteg ay mangmangan isnan pondag ay sag-enda ");
INSERT INTO xnn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","isonga dat menseg-ang san anito ken Jesus et kananda en, “No pakaanem dakami et ipalobosmo ngalod ta nan deeyday beteg nan kaptenmi.” ");
INSERT INTO xnn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Dat kanan Jesus en, “Enkayo.” Dadat taynan san lalalaki et kaptenda san deeyday beteg. Dat kanega naong-ong san kabetebeteg et kasida tatagtag ay omey isnan deppas dadat matekdag isnan baybay et malimonda. ");
INSERT INTO xnn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","San mangbanbantay issan deeyday beteg et tinmagtagda ay somaa isnan ilida dadat ibaga san inommat issan dowa ay lalalaki ay kinapet di anito. ");
INSERT INTO xnn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dat omey nan omili ken Jesus et dawatenda ay taynana nan ilida. ");
INSERT INTO xnn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isonga dat menlogan da Jesus isnan bangkada et somagongda isnan bas-ang di baybay isnan ilina. ");
INSERT INTO xnn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Idi omdanda isdi dat domateng nan mangaatangay isnan lalaki ay napalalais. Gintek Jesus ay talkenda siya isonga danat kanan issan napalalais en, “Adika omegyat tay napakawan et nan basolmo.” ");
INSERT INTO xnn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dat kankanan nan men-is-isolo isnan linteg isnan nemnemda en, “Aytay dan iyiison tona nan awakna ken Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Gintek Jesus nan wada isnan nemnemda danat kanan en, “Dayon nenemnemen nan ngawi? ");
INSERT INTO xnn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ay ngan nan nalaklaka ay kanan, nan ‘Mapakawan nan basolmo,’ wenno nan ‘Ibangonmo ta mendaanka?’ ");
INSERT INTO xnn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ngem gapo tay adiyo patiyen et paneknekak ngalod ken dakayo ay wada nan kalebbengak isnan batawa ay mangpakawan is basol tay sak-en nan makwani en Iyon-an Am-in di Ipogaw.” Isonga danat kanan issan napalalais en, “Ibangonmo. Alaem nan dayonmo ta somaaka.” ");
INSERT INTO xnn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dat mabanangon san am-ama et somaa. ");
INSERT INTO xnn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Am-in san wada isdi ay nangiila et nasdaawda dadapay inmegyaegyat. Isonga dadat dayawen si Apo Dios is nang-itedana is kaneg todi ay kabaelan isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kinmaan si Jesus isdi et issan mendad-aanana et inilana si Mateo ay esay mensingsingil is bowis ay mangitotokdo isnan kabaybayadan di bowis. Dat kanan Jesus ken siya en, “Omalika ta maitapika ken sak-en.” Daet tet-ewa omonod et maitapi ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Inmey da Jesus ya nan papasolotna isnan baey Mateo ay makikan. Dat domateng nan ado ay ib-an Mateo ay mensingsingil is bowis ya nan tap-in di managbasol et makikanda. ");
INSERT INTO xnn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Idi inilan nan Fariseo daida dadat kanan isnan papasolot Jesus en, “Dan makikikan nan apoyo isnan sanada ay mensos-owitik ay mensingsingil is bowis ya nan managbasol?” ");
INSERT INTO xnn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dinngen Jesus nan kankananda danat songbatan isnan pangngalig et kanana en, “Nan ipogaw ay maid sakitda et adida masapol nan doktol ngem nan ipogaw ay mensakit et daida nan makasapol isnan doktol. ");
INSERT INTO xnn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Isonga inmaliyak isnan batawa tapno badangak nan mangtek ay nakabasolda ngem baken nan mangnenemnem en gawisda. Nemnenemnemenyo tapno maawatanyo nan inpasolat Apo Dios en, ‘Nan mangseg-anganyo isnan iib-ayo nan laylaydek mo nan apedyo menpalpaltiyan ta tongpalenyo nan linteg.’” ");
INSERT INTO xnn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nakwas di dat omey nan papasolot Juan ay Menbonbonyag ken Jesus dadat sooten ken siya en, “Dan wada nan mentepeanmi ya nan Fariseo dapay nan papasolotmo et adida mentepe?” ");
INSERT INTO xnn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Dat menpangngalig si Jesus ta ilawlawagna nan gapo ay adi menteptepe nan papasolotna et kanana, “Ay kananyo en adi makikan nan nadkat no daan nan nadawak ken daida? Adi mabalin. Ngem no omdan nan agew ay maapitan nan lalaki ay nadawak et siya di nan mentepeanda gapo isnan seg-angda.” ");
INSERT INTO xnn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Intoloy Jesus ay mensodok ta ipagtekna ken daida en adi kabalin ay maitapi nan nabayag ay sinoloda isnan isolsolona. Kanana, “Maid mangitakop is balo ay galot isnan logak ay bado tay no malabaan dat komsen nan takop et am-amed mabisngat nan natakopan. ");
INSERT INTO xnn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Siya gedan isnan tapey. Maid mang-igwa is kabobobod ay tapey isnan naosal ay kodil tay epdas kinmenteg dapay no menlowag nan tapey et bomtak nan kodil et makawas nan tapey ya nan kodil gedan. Nan balo ay tapey et masapol ay maigwa isnan balo abes ay kodil tay mabinbinat et maid makawas.” ");
INSERT INTO xnn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Daan ay menkalkali si Jesus dat omey nan esay apon di Judio ken siya. Dat menpalintomeng isnan sagang Jesus et kanana en, “Katkatey nan anakko ay babai ngem omalika kad Apo, ta gen-am siya ta matago.” ");
INSERT INTO xnn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dat makkey si Jesus ya nan papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dat wada nan in-ina ay egay somalsaldeng nan basana is simpoo ya doway tew-en. Inmey isnan dodokogan Jesus issan mendad-aananda danat sikgaden nan benget nan badon Jesus ");
INSERT INTO xnn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","tay kanana isnan nemnemna en, “Olay no apedak sikgaden nan badona et gomawisak.” ");
INSERT INTO xnn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ngem gintek Jesus ay wada nan nangsikgad ken siya isonga dat menligos et ilaena san in-ina. Danat kanan en, “Laton sa. Gomawiska gapo isnan pammatim ken sak-en.” Dat maganawis siya. ");
INSERT INTO xnn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Inomdan da Jesus isnan baey san apon di Judio danat ilan nan menbaybayao ya nan adoado ay ipogaw isnan pantew ay menseseg-ang ya men-ag-aga. ");
INSERT INTO xnn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Danat kanan ken daida en, “Komaan kayo tay egay katey nan onga ay sana nodi maseseyep et kedeng.” Dadat sayoten siya. ");
INSERT INTO xnn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Danat pabalaen daida et songgep siya. Danat gen-an nan ledeng san onga daet bomangon siya. ");
INSERT INTO xnn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dat mendinamag nan inikkan Jesus isnan am-in ay il-ili isdi. ");
INSERT INTO xnn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kinmaan si Jesus isdi dat issan mendad-aanana et inmonod nan dowa ay kowap ay lalaki ay mangibogbogaw en, “Sik-a ay apon din si Ali David, seg-angam kad dakami.” ");
INSERT INTO xnn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngem dat itoltoloy kayet Jesus ay mendaan engganay inomdan isnan baey dat songgep dat makisgep nan dowa ay kowap gedan. Dat sooten Jesus ken daida, “Ay mamati kayo ay makaipagawisak ken dakayo?” Dadat kanan, “Owen Apo.” ");
INSERT INTO xnn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dat kapposen Jesus nan matada et kanana en, “Gapo isnan pammatiyo et matongpal nan laydenyo.” ");
INSERT INTO xnn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dadat makaila. Dat bilinen Jesus daida et kanana, “Adiyo ibagbaga isnan iib-ayo nan inikkak ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ngem dadat komaan et enda ipagtek isnan kailiili nan inikkan Jesus ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Issan komak-aanan nan dowa ay lalaki dat wada nan mang-eyey ken Jesus isnan am-ama ay inomel di anito. ");
INSERT INTO xnn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dat pakaanen Jesus san anito et dadlo makakali san am-ama. Nasdaaw san nangiila isdi et kananda en, “Maid polos inilami isnan am-in ay iyIsrael is kaneg nan inikkana.” ");
INSERT INTO xnn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ngem kanan nan Fariseo ay wada isdi en, “Nan kabaelana ay mangipakaan isnan dimonyo et nagapo ken Satanas ay apon di dimonyo.” ");
INSERT INTO xnn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nakwas di dat omey si Jesus isnan il-ili ay men-isolsolo isnan kasinasinagoga. Inpagpagtekna nan gawis ay damag maipanggep isnan mentolayan Apo Dios ya pinagawisna nan natkenatken ay saksakit di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Isnan nang-ilaan Jesus isnan kaipoipogaw dat maseg-ang siya isnan maligligatanda tay kanegda kalnilo ay maid mang-ay-ayowan ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dat kanan Jesus isnan papasolotna en, “Adoado nan egay pay laeng namati ken Apo Dios et kanegda nan pagey ay maani. Dakayo ay mangisolsolo isnan kalin Apo Dios et kanegyo nan men-ani ngem atiatik kayo. ");
INSERT INTO xnn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Isonga dawatenyo ken Apo Dios ay kakwa isnan maani ta omibaa is mangbadang ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nakwas di dat ayagan Jesus nan simpoo ya dowa ay papasolotna danat agtan daida is kabaelan ay mangipakaan is anito ya mangipagawis isnan natkenatken ay saksakit. ");
INSERT INTO xnn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Siya na nan ngadngadan nan simpoo ya dowa ay apostolis Jesus. Si Simon ay makwani en Pedro yas Andres ay besatna, da Santiago ken Juan ay an-ak Zebedeo, ");
INSERT INTO xnn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","da Felipe ken Bartolome, da Tomas ken Mateo ay mensingsingil is bowis ya si Santiago ay anak Alfeo. Si Tadeo, ");
INSERT INTO xnn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon ay mangisaksakit isnan ilida ya si Judas Iscariote ay awnit mangisipsip ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Inbaan Jesus daida et kanana en, “Enkayo ngem adi kayo om-omey isnan il-ili id Samaria ya isnan tap-in di ili ay kad-an di baken Judio ");
INSERT INTO xnn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nodi omey kayo isnan iib-a tako ay Judio tay kanegda nan naamas ay kalnilo. ");
INSERT INTO xnn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ibagayo ken daida en nganngani ay omali nan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Intedko nan kabaelanyo isonga pagawisenyo gedan nan masaksakit ya tagowenyo nan natey. Pagawisenyo nan nakolit ya pakaanenyo nan anito ay kinmapet isnan ipogaw. Maid inbayadyo isnan am-in ay wada ken dakayo isonga adiyo abes ipabaybayad nan ibadangyo. ");
INSERT INTO xnn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Adi kayo omikawkawit is siping ");
INSERT INTO xnn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ya makan ya is mensokatanyo ay bado ya sapatos ya is sokodyo. Tay lebbengna ay ited nan ipogaw nan masapolyo tay badbadanganyo daida. ");
INSERT INTO xnn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","No omdan kayo isnan esa ay ili dakayot omanap is makayat ay mangsangaili ken dakayo dakayot mentee ken daida engganay taynanyo nan ili ay deey. ");
INSERT INTO xnn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","No songgep kayo isnan esa ay baey dakayot kanan en, ‘Si Apo Dios nan mangbadang ken dakayo.’ ");
INSERT INTO xnn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Et no men-gasingda ay mangsangaili ken dakayo et tet-ewa ay badangan Apo Dios daida. Ngem no adida sangailiyen dakayo et somagong ken dakayo nan badang Apo Dios ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ngem no nan omayanyo ay ili wenno baey et adida idnge dakayo dakayot komaan dayopay pokpoken nan tapok isnan dapanyo ta ipailayo ay adyanda nan isoloyo. ");
INSERT INTO xnn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ibagak ken dakayo nan tet-ewa, isnan mangbanagan Apo Dios isnan ipogaw et am-amed nan dosan nan mang-adi isnan insoloyo mo nan iSodoma ya iGomora ay pinoowan Apo Dios id sang-adom gapo isnan dadama ay basolda.” ");
INSERT INTO xnn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Intoloy Jesus ay mangwani, “Dengngenyo na. Ibaak dakayo ay kaneg nan naanos ay kalnilo ngem nan omayanyo et kanegda nan makedse ay aso isonga masapol ay makailanyo dayopay gagawisen nan ikkanyo. ");
INSERT INTO xnn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Makailanyo tay awnit wada nan mangdepap ken dakayo dadat eyey dakayo isnan pagbistaan dadapay baigen dakayo isnan sinagogada. ");
INSERT INTO xnn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gapo isnan pammatiyo ken sak-en et awnitda idalom dakayo isnan aali ya gogobilnadol et siya di nan wayayo ay mangibaga isnan gawis ay damag isnan Judio ya nan baken Judio. ");
INSERT INTO xnn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","No somalyaenda dakayo et adi kayo madanagan isnan awnityo isongsongbat tay kigad si Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Isonga nan awnityo kankanan et baken isnan nemnemyo is magapowana nodi isnan Ispiriton Apo Dios ay Amayo. ");
INSERT INTO xnn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Isnan deey ay timpo et awnit idalom nan ipogaw nan olay besatna ay mangipapatey ken siya. Olay nan am-a et awnit papateyda nan an-akda ya awnit pabasolen nan an-ak nan am-ada dadat ipapatey daida. ");
INSERT INTO xnn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Awnit aamisen nan ipogaw dakayo gapo isnan pammatiyo ken sak-en. Ngem nan mang-an-anos ay olay ngan di ommat engganay makwas nan am-in et isalakan Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","No wada nan mangpaligat ken dakayo isnan esa ay ili dakayot men-aton isnan teken. Tay ibagak ken dakayo et tet-ewa ay adiyo lepasen nan inbagak ay ikkanyo isnan am-in ay ili id Israel engganay omali nan Iyon-an Am-in di Ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Dat itoloy Jesus ay men-isolo maipanggep isnan awnit ommat ken daida et kanana en, “Maid maisolsolowan is nangatngato mo nan men-is-isolo ken siya ya maid baa is nangatngato mo nan apona. ");
INSERT INTO xnn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Isonga masapol ay maawatanyo ay nan awnit ommat isnan men-is-isolo et paliso nan ommat isnan isolsolowana. Kaneg isnan baa et awnit ommat ken siya nan kaneg nan ommat isnan apona. Isonga no kananda en Satanasak et am-amed nan pangwanida ken dakayo ay papasolotko. ");
INSERT INTO xnn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ngem adi kayo omeg-egyat ken daida. Tay nan am-in ay ikkan nan ipogaw ay adi kagtek et awnit magtek met laeng. ");
INSERT INTO xnn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nan ibagak ken dakayo id wani ay maid makadenge et masapol ay awnityo ibaga tapno dengngen nan am-in ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Adi kayo omeg-egyat isnan menpatpatey tay kedeng nan awak is pateyenda nodi si Apo Dios nan omegyatanyo tay siya nan wada nan kalebbengana ay mang-igwa isnan awak ya nan ab-abiik di ipogaw isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngem dakdak-e abes nan layadna tay olay nan biding ay malakowan nan dowa is esay siping et adi kalkalingkingan Apo Dios daida tay no matey nan esang ken daida et getkena. ");
INSERT INTO xnn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Am-amed kayo ay ipogaw et nenemnemen Apo Dios dakayo tay olay nan bookyo et getkena nan kabibilangda. ");
INSERT INTO xnn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Isonga adi kayo omegyat tay am-amed kayo is ipatpateg Apo Dios mo nan adoado ay biding.” ");
INSERT INTO xnn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Intoloy Jesus ay mangwani en, “Nan mangibagbaga isnan kaipoipogaw en mamati ken sak-en et awnitko ibaga abes ken Ama id daya en ipogawko daida. ");
INSERT INTO xnn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ngem nan mangibagbaga ay adyana sak-en et awnitak adyan abes siya ken Ama id daya. ");
INSERT INTO xnn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Adiyo kanan en inmaliyak ay mangiyali is talna isnan batawa. Tay baken talna nan inyalik nodi nan mensiyanan nan kaipoipogaw tay mamati nan tap-ina ken sak-en dapay adi mamati nan tap-ina. ");
INSERT INTO xnn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Isonga awnit men-innapos nan sin-am-a ya sin-in-a. Et men-innapos gedan nan menkakatogangan. ");
INSERT INTO xnn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Et awnit nan kasapen nan ipogaw et nan met laeng pamilyana. ");
INSERT INTO xnn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Isonga kanak en nan mangpaam-amed isnan amana ya inana mo sak-en et adi maibagay ay pasolotko. Olay nan mangpaam-amed isnan anakna mo sak-en et adi maibagay gedan ay pasolotko. ");
INSERT INTO xnn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Et nan adi makaitpe isnan ado ay ligat ay olay matey gapo isnan pammatina ken sak-en et adi mabalin gedan ay menpasolotko. ");
INSERT INTO xnn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nan ipogaw ay kedeng nan awakna is nemnemnemena et awnit matey met laeng. Ngem nan ipogaw ay adi mangnemnemnem isnan awakna gapo ken sak-en et awnit matey ngem matagotago ken Apo Dios ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Intoloy Jesus ay mangwani en, “Am-in ay mangsangaili ken dakayo et kaneg sak-en nan sinangailida ya nan nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Et nan mangsangaili isnan mamadton Apo Dios gapo tay si Apo Dios nan men-ob-oblaana et awnit makiganab isnan ganaben san mamadto. Ya nan mangsangaili isnan ipogaw ay gawis nan ogalina tay getkena ay tet-ewa ay nagapo ken Apo Dios nan kagawisna et awnit makiganab isnan ganaben san gawis nan ogalina. ");
INSERT INTO xnn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ibagak ken dakayo en olay nan aped mangpainom is danom isnan kababaan ay pasolotko gapo tay pasolotko et awnit wada nan ganabena.” ");
INSERT INTO xnn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nakwas pay ay binilin Jesus nan simpoo ya dowa ay apostolisna dadat komaan dapay omey si Jesus isnan il-ili ay naisasag-en et men-isolo. ");
INSERT INTO xnn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Daan ay naibabalod si Juan ay Menbonbonyag ngem isnan nangdengngana isnan ik-ikkan Kristo danat ibaa nan papasolotna ken siya ta sootenda en, ");
INSERT INTO xnn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ay sik-a nan masmas-ed ay magapo ken Apo Dios wenno waday teken is sedsed-enmi?” ");
INSERT INTO xnn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Dat kanan Jesus ken daida, “Somagong kayo ken Juan ta ibagayo nan dinngeyo ya nan inilayo ay ik-ikkak. ");
INSERT INTO xnn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tay nan kowap et makailada, nan pilay et makadaanda, nan nakolit et ginmawisda. Nan toweng et makadngeda, nan natey et natagoda ya olay nan kodokdo et dinngeda nan naibagbaga ay gawis ay damag. ");
INSERT INTO xnn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kananyo gedan ken siya en mabindisyonan nan ipogaw ay adi mendowadowa ay mamati ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Issan kinmaanan san papasolot Juan dat kanan Jesus isnan kaipoipogaw, “Isdin inmayanyo isdin kad-an Juan isnan bilig ay ngan nan kaytenyo ay ilaen? Ay ninemnemyo ay si Juan et kanegna nan goon ay pakiwkiwiyen di dagem? ");
INSERT INTO xnn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Baken. Ay ngan ngalod nan enkayo inila? Ay esa ay ipogaw ay ninbado is gawigawis? Baken gedan tay nan ipogaw ay menbabado is gawigawis et nan makitetee isnan ali. ");
INSERT INTO xnn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ay ngan ngalod nan enkayo inila? Ay esay mamadton Apo Dios? Owen, ngem ibagak ken dakayo ay nan inilayo et nangatngato mo is mamadto. ");
INSERT INTO xnn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tay si Juan nan kakwaniyan nan naisolat ay kalin Apo Dios id kasin en, ‘Wada nan ibaak ay omon-ona ay mangisagana isnan daanem.’” ");
INSERT INTO xnn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dat itoloy Jesus, “Ibagak ken dakayo en isnan am-in ay ipogaw et maid nangatngato mo si Juan. Ngem nan kababaan isnan mentolayan Apo Dios et nangatngato mo si Juan. ");
INSERT INTO xnn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Isnan login nan men-is-isolowan Juan enggana id wani et dadama nan panglayad nan ipogaw ay maitapi isnan mentolayan Apo Dios. Et olay nan mang-ik-ikkan is ngawi et ipapatida abes ay maitapi. ");
INSERT INTO xnn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Am-in nan mamadton Apo Dios ya nan lintegna ay insolatda et ibagada nan maipanggep isnan mentolayan Apo Dios ay awnit omali. Dat domateng si Juan ay inmona ay mangtongpal isnan inbagada. ");
INSERT INTO xnn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tay no patiyenyo nan tet-ewa et maawatanyo ay si Juan nan Elias ay inbagada en awnit omali. ");
INSERT INTO xnn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Isonga dakayo ay mangdedenge et nenemnemenyo nan dinngeyo.” ");
INSERT INTO xnn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Intoloy Jesus en, “Ay ngan nan mangidiligak ken dakayo ay ipogaw id wani? Men-ap-apos et kedeng nan getkenyo. Kaneg kayo nan oongong-a ay adi polos mapnek. Tay no men-ay-ayamda isnan malkitan et kankanan nan ib-ada ken daida en, ");
INSERT INTO xnn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nin-ganggangsa kami ngem egay kayo ninsala. Nin-ag-aga kami ngem egay kayo nakiaga.’ ");
INSERT INTO xnn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kanak en kanegyo daida tay adi kayo polos mapnek. Inmali si Juan et at-atik nan kinkinana ya egay polos inmin-inom is bomoteng ay mainom dakayot kanan en, ‘Matawtawaw siya.’ ");
INSERT INTO xnn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Inmaliyak abes et nakikikanak ya nakiin-inomak ken dakayo. Dakayot kanan en, ‘Ilaenyo kod nan ipogaw ay naay. Bokatot ya men-inom danapay gayyem nan mensos-owitik ay mensingsingil is bowis ya nan managbasol.’ No siya ngalod sa is kankananyo et maid mabalin is ikkanmi ken Juan ay mangpagasing ken dakayo. Ngem olay no adyanyo nan initdok ya nan init-itdon Juan et mailanto isnan ogalin nan mamati ken Apo Dios ay nan it-itdomi et siya nan silib Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dat sagiiten Jesus nan mentetee isnan il-ili ay nang-ikkanana isnan adoado ay kaskasdaaw tay daida nan nang-il-ila dadapay egay inbabawi nan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kanana en, “Kaseseg-ang kayo ay iCorazin ya iBetsaida tay egayyo inbabawi nan basbasolyo. Id sang-adom et palalo nan dosan Apo Dios isnan iTiro ya isnan iSidon ngem no daida koma nan nang-ila isnan kaskasdaaw ay inik-ikkak isna waay nabayag ay ninbadoda is mensampet ay sako dadapay itotokdo isnan dapo ay mangipaila en inbabawida nan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ibagak ken dakayo nan tet-ewa, no omdan nan mangbanagan Apo Dios isnan ipogaw et awnit am-amed nan dosayo mo nan iTiro ya iSidon. ");
INSERT INTO xnn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Dakayo abes ay iCapernaum ay mangipapangato isnan nemnemyo et awnit kayo maibkas isnan kad-an di apoy ay adi katkatey. Tay no naikkan nan adoado ay kaskasdaaw id Sodoma ay kaneg nan inikkak isnan iliyo et waay inbabawida nan basbasolda et egay pinoowan Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ibagak ken dakayo nan tet-ewa en no omdan nan mangbanagan Apo Dios isnan ipogaw et awnit am-amed nan dosayo mo nan iSodoma.” ");
INSERT INTO xnn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dat menlowalo si Jesus et kanana en, “Ama, sik-a nan Apo id daya ya isnan batawa. Men-iyamanak ken sik-a tay inpagtekmo isnan egay nakaadal nan tet-ewa ay maipanggep ken sak-en ngem egaymo inpagtek isnan mangwani en nalaing ya masilib tapno adida maawatan. ");
INSERT INTO xnn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Owen Ama, tay siya nan kayatmo ay maikkan.” ");
INSERT INTO xnn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nakalowalo si Jesus danat kanan isnan papasolotna en, “Inyalin Ama nan am-in ay wada ken sak-en. Maid ipogaw is mangtek isnan am-in ay maipanggep ken sak-en nodi kedeng si Ama ya maid gedan mangtek isnan am-in ken Ama nodi kedengak ay Anakna ya nan pinilik ay mangipagtek isnan maipanggep ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Danat kanan en, “Dakayo ay nabbay ya mapalpaligatan et omali kayo ken sak-en ta paibbayek dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Dawatenyo nan it-itdok et solowenyo nan am-in ay maipanggep ken Apo Dios tay siya nan mangdatnganyo isnan tet-ewa ay talna ay nagapo ken sak-en. Tay isnan men-it-itdowak et naanosak ya adiyak ipapangato nan awakko. ");
INSERT INTO xnn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Et nalaka ay tongpalenyo nan ibagbagak tay adiyak palpaligaten dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sinabado ay obayan di Judio et issan esay Sabado indaan da Jesus isnan paypayewan. Naowat nan papasolotna dadat menlosing is kotimenda. ");
INSERT INTO xnn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Idi inilan nan Fariseo dadat kanan ken Jesus en, “Ilam pod nan ik-ikkan nan papasolotmo. Dadan menlosing is kotimenda dapay law-en nan linteg tako nan men-ani isnan obaya?” ");
INSERT INTO xnn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dat kanan Jesus, “Aytay dayon pabasolen daida? Ay egayyo polos binasa din inikkan da David isdin linmayawanda? Naowaowatda ");
INSERT INTO xnn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","isonga dadat songgep isnan baey Apo Dios dat alaen David nan tinapay ay pala ken Apo Dios danat kanen danapay agtan nan iib-ana. Dapay kanan nan linteg tako en adi mabalin ay maipakan nan tinapay ay pala ken Apo Dios isnan ipogaw no bakenda padi. Ngem gapo tay naowatda et egay pabasolen Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nan esa pay et ay egayyo polos binasa din insolat Moses en law-enda no men-obla nan ipogaw isnan obaya tako? Dapay am-amed nan obaya is men-oblaan nan papadi isnan Templo ngem adi pabasolen Apo Dios daida tay masapol ay ikkanda nan oblada. ");
INSERT INTO xnn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngem ibagak ken dakayo en nan wada isna id wani et napatpateg mo nan Templo. ");
INSERT INTO xnn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Naisolat isnan kalin Apo Dios en, ‘Nan managseg-anganyo isnan iib-ayo nan laylaydek mo nan menpalpaltiyanyo ay mangtongpal isnan linteg.’ No maawatanyo nan kayat tona ay kaliyen et egayyo idalom nan maid basolda. ");
INSERT INTO xnn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tay sak-en ay Iyon-an Am-in di Ipogaw nan kalebbeng isnan mabalin ay maik-ikkan isnan obaya.” ");
INSERT INTO xnn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nakwas pay di dat komaan si Jesus et omey isnan sinagoga. ");
INSERT INTO xnn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wada isdi nan am-ama ay nabingoy ya wada isdi gedan nan mangkayat ay mangidalom ken Jesus isonga dadat kanan, “Ay law-en nan linteg tako nan men-agas is sakit isnan obaya?” ");
INSERT INTO xnn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Dat kanan Jesus, “Ngan nan ikkanyo no waday talakenyo is natekdag isnan tengey isnan obaya? Ay adiyo en alaen? ");
INSERT INTO xnn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Napatpateg nan ipogaw mo nan talaken isonga ipalobos nan linteg tako ay badangan tako nan ib-a tako ay olay no obaya.” ");
INSERT INTO xnn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Danat kanan isnan nabingoy en, “Oyadem nan ledengmo.” Inoyadna dat maoyad tet-ewa ay kaneg nan esa ay ledengna. ");
INSERT INTO xnn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ngem mamaslat nan Fariseo dadapay komaan et omeyda mentotya no ngan nan ikkanda ay mangpatey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Gintek Jesus ay kaytenda ay mangpatey ken siya danat taynan nan ili ay deey. Dat omonod nan adoado ay ipogaw et pagawisena daida am-in. ");
INSERT INTO xnn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ngem binilina daida ay adida ibagbaga isnan iib-ada nan maipanggep ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Et siya nan natongpalan din inpasolat Apo Dios isnan mamadtona ay si Isaias ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ilaenyo nan naay ay pinilik ay inbaak. Siya nan laylaydek ya siya nan mangipagasgasing ken sak-en. Itedko ken siya nan Ispiritok ta siya nan mangipadamag isnan tet-ewa ay maipanggep ken sak-en isnan baken Judio abes. ");
INSERT INTO xnn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Adina ibib-iyad nan kalina ay makisongbat isnan iib-ana isnan om-ombonanda ya adina bogbogawan daida. ");
INSERT INTO xnn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Adina dokogan nan ipogaw ay teteteteen nan pammatida ya badangana nan kaseseg-ang. Itoltoloyna engganay abakena nan am-in ay ngawi isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Et siya et kedeng nan namnamaen nan am-in ay ipogaw ay mangisalakan ken daida.” ");
INSERT INTO xnn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Isnan esa ay agew inyeyda ken Jesus nan am-ama ay adi makaila ya adi makakali tay kinapet di anito. Dat pakaanen Jesus nan anito et makakali ya makaila dadlo nan am-ama. ");
INSERT INTO xnn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nasdaaw san nangiila isnan inikkan Jesus dadat kanan en, “Ay siya ngen nan apon David ay sedsed-en tako?” ");
INSERT INTO xnn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ngem idi dinngen nan Fariseo san kinwanida dadat kanan, “Baken, tay si Beelzebub ay Satanas ay apon di dimonyo nan nang-idya ken tosa isnan kabaelana ay mangipakpakaan isnan dimonyo.” ");
INSERT INTO xnn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Gintek Jesus nan nemnemda isonga danat kanan, “Iyalig tako isnan sinpangbon. No mensaspe nan sinpangbon et adi mentoloy nan om-ombonanda. Kaneg abes nan sinbaey ya nan kakailiyan ay no maid olnosda et mabokada. ");
INSERT INTO xnn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isonga adi mabalin ay sapeen Satanas nan bab-aana tay getkena ay no isapena daida awnit mamaid nan tolayna. ");
INSERT INTO xnn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kananyo en si Satanas nan nangiyali isnan kabaelak ay mangipakpakaan is anito. No siya di, into pay nagapowan nan kabaelan nan iib-ayo ay Judio ay mangipakak-aan is anito? Tay nan ik-ikkan nan iib-ayo et siya nan mangipaila ay baken si Satanas is mangbadbadang ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Siya nan kagtekana ay si Apo Dios nan nangiyali isnan kabaelak ay mangipakpakaan is anito. Et siya gedan nan mangipagtek ay inmali nan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Dat mensodok si Jesus ta ipagtekna en napigpigsa nan panakabalina mo si Satanas. Kanana, “Nan mangakew et adi mabalin ay songgep isnan baey nan napigsa ay ipogaw ay mang-ala isnan napateg ay kowana no adina omon-ona galotan dat mabalin et ay alaena nan kayatna. ");
INSERT INTO xnn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Am-in ay adi maitapi ken sak-en et daida nan mang-ap-apos ken sak-en. Ya am-in ay adi bomadbadang ay mangponok isnan ipogaw et daida nan mangipaad-addawi isnan ipogaw ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tet-ewa nan kanak ken dakayo en mabalin ay mapakawan am-in nan basbasol di ipogaw ken Apo Dios ya nan mangmangwani isnan ngawi maipanggep ken siya. Ngem nan komalkali is ngawi maipanggep isnan Ispirito Santo et adi mabalin ay mapakawan ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Olay nan mangmangwani is ngawi maipanggep ken sak-en ay Iyon-an Am-in di Ipogaw et mabalin ay mapakawan nan basolna ngem nan menkalkali is ngawi maipanggep isnan Ispirito Santo et adi mabalin ay mapakawan tay basolna ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Dat menpangngalig si Jesus ay mangwani en, “Nan gawis ay kaiw et gawis nan ibgasna ngem no ngawi nan kaiw et ngawi abes nan ibgasna. Tay nan begasna nan mangipaila isnan kakaiwna. ");
INSERT INTO xnn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ay apo kayo ay ngananganangwi. Ayke mabalin ay kananyo nan gawis dapay ngawi nan nemnemyo? Tay nan kalin di ipogaw et ipailana nan wada isnan nemnemna. ");
INSERT INTO xnn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Isonga nan gawis nan nemnemna et gawis gedan nan kankanana. Ngem nan ngawi nan nemnemna et ngawi gedan nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ibagak ken dakayo nan tet-ewa ay isnan agew ay mangbanagan Apo Dios isnan ipogaw et wasdin kigad ay mangsongbat isnan am-in ay ngawi ay kinkinwanina. ");
INSERT INTO xnn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tay am-in ay kinkinwaniyo et siya nan mangipaila no awnit madosa kayo wenno adi.” ");
INSERT INTO xnn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Et wada isdi nan men-is-isolo isnan linteg ya nan Fariseo ay mangwani en, “Apo, kadya omipailaka is kaskasdaaw tapno getkenmi ay tet-eway nagapoka ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ngem dat kanan Jesus, “Palalo nan kangawin nan ipogaw id wani tay dinokoganda si Apo Dios. Kaytenyo ay omipailaak is kaskasdaaw sakayopay mamati ken sak-en ngem maid polos ipailak nodi kedeng nan kaneg din kaskasdaaw ay inommat isdin si Jonas. ");
INSERT INTO xnn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tay din si Jonas et nintee isnan eges di dakkel ay ikan isnan tolo ay agew. Kaneg abes ken sak-en ay Iyon-an Am-in di Ipogaw et awnitak maikakaob is tolo ay agew. ");
INSERT INTO xnn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Isonga isnan mangbanagan Apo Dios isnan ipogaw et pabasolen nan iNineve dakayo tay inbabawida nan basbasolda isnan nangdengnganda isdin insolsolon Jonas dapay nan inmali ken dakayo et nangatngato mo din si Jonas dapay adiyo kayet patiyen. ");
INSERT INTO xnn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Et isnan mangbanagan Apo Dios isnan ipogaw et wada abes nan in-ina ay reyna id Seba ay mangpabasol ken dakayo tay id sang-adom et nagapo siya isnan addaaddawi ay ili ngem inmey kayet ay mangdenge isnan insolsolon nan kasiliban ay ali ay din si Solomon. Isonga pabasolena dakayo tay adiyo polos idnge ya patiyen nan inmali ken dakayo dapay nangatngato mo din si Solomon.” ");
INSERT INTO xnn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Dat itoloy Jesus ay mensodok ay mangwani en, “Wada nan ipogaw ay kinapet di anito dat taynan san anito san ipogaw et omey isnan bilbilig ay maid polos danom et men-an-an-anap is omillengana ngem maid dinatngana. ");
INSERT INTO xnn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Isonga kanana en, ‘Somagongak isnan ipogaw ay nagapowak.’ Dat somagong et datngana san nagapowana ay maid mentetee dapay nadalos. ");
INSERT INTO xnn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dat omey kasin men-ayag is pito ay anito ay makedkedse mo siya et komapetda issan ipogaw ay tinaynana. Dat am-amed ngawi et nan ommat issan ipogaw mo san damo. Et kaneg todi gedan ken dakayo ay ngawi ay ipogaw id wani tay awnit am-amed nan kangawiyanyo mo adiyo dawaten nan gawis.” ");
INSERT INTO xnn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Daan ay menkalkali si Jesus dat omdan da inana ya nan bebsatna. Idi wadada isnan pantew dadat ipaayag si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dat wada nan mangwani ken siya en, “Wada da inam ya nan bebsatmo isnan pantew ay mangpaay-ayag ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dat kanan Jesus en, “Owen, ngem sinoda pay nan inak ya bebsatko?” ");
INSERT INTO xnn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Danat tamaangen nan papasolotna et kanana en, “Ilaenyo naayda nan kanegko ina ya bebsat. ");
INSERT INTO xnn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tay am-in nan mamati ay mang-ikkan isnan layden Ama id daya et kanegko gedan ina ya bebsat.” ");
INSERT INTO xnn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Issan agew ay deey kinmaan si Jesus isnan baey dat omey isnan benget di baybay. Danat itokdo et ilogina ay men-isolo isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Adoadoda ay nadagop ken siya isonga dat omey tomokdo isnan bangka et tomatakdeg nan mendenge isnan benget di baybay. ");
INSERT INTO xnn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dat menpangngalig si Jesus ay men-isolo et kanana en, “Wada nan am-ama ay en ninbonobon isnan om-a. ");
INSERT INTO xnn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Idi insapowakna nan bonobon isnan om-a dat maekdag nan tap-ina isnan daan. Dat topken di koyat. ");
INSERT INTO xnn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nan tap-ina et naekdagda isnan kabatbatowan dadat dalas ay tomobo tay baken adaem nan lota. ");
INSERT INTO xnn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngem idi naagewanda dadat maango tay nalabaw nan linmamotanda. ");
INSERT INTO xnn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nan tap-ina et naekdagda isnan ginsatan ay sibit. Dat solinen di sibit nan tinmobo et mateyda. ");
INSERT INTO xnn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ngem nan tap-ina ay naekdag isnan gawis ay lota et tinmobo dadapay bomgas am-in. Wada nan binomgas is sin-gagsot, nan tap-ina et sag-eenempoo ya nan begas nan tap-ina et sagtotolompoo. ");
INSERT INTO xnn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dakayo ay mangdedenge isnan sodokko et dengngenyo no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nakasodok pay si Jesus dat sooten nan papasolotna en, “Daen pangngalig nan osalem ay men-isolo isnan ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Dat kanan Jesus, “Owen, tay naipagtek ken dakayo nan egay naipagtek id kasin ay maipanggep isnan mentolayan Apo Dios ngem egay naipagtek isnan tap-in di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tay nan mamati isnan isolsolok ta maawatana et taptapiyan Apo Dios nan getkena. Ngem nan adi mangidnge et awnit mamaid nan atiatik ay getkena. ");
INSERT INTO xnn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Et pangngalig nan ik-ikkak ay mangisolo ken daida tay olay no iilanda adida getken nan tet-ewa ya olay no dedengngenda et adida maawatan. ");
INSERT INTO xnn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isonga natongpal din inpasolat Apo Dios ken Isaias ay mamadtona ay mangwani en, ‘Olay no dengedengenda et adida maawatan. Ya ilailaenda ngem adida makaimaton isnan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Owen, tay adida layden ay mangnemnem isnan tet-ewa isonga totowengenda dadapay bobolagen. Tay no adida ikkan dadi modiyet makailada ya makadengeda adi pay maawatanda nan tet-ewa dadat menbabawi et pakawanek nan basolda.’” ");
INSERT INTO xnn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dat itoloy Jesus ay mangwani, “Ngem dakayo et nagasat kayo tay makaila kayo ya makadnge kayo isnan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ibagak ken dakayo ay adoado din mamadton Apo Dios ya nan tap-in di ipogaw id sang-adom ay nangtongtongpal isnan laydena et kakakayatda ay mang-ila isnan il-ilaenyo id wani ngem egayda naila ya kaytenda gedan ay mangdenge isnan dengdengenyo ngem egayda nakadnge.” ");
INSERT INTO xnn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Danat itoloy ay mangwani, “Dengngenyo tay siya na nan kayat ay kanan san sinodokko ay ninbonobon. ");
INSERT INTO xnn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nan daan ay natekdagan di bonobon et kanegna nan mangdedenge isnan maipanggep isnan mentolayan Apo Dios ngem adina maawatan. Dat omey si Satanas et kaanena isnan nemnemna san dinngena tapno adina patiyen. ");
INSERT INTO xnn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nan kabatbatowan et kanegna nan ipogaw ay mangdenge ya men-galalasing ay mangdawat isnan kalin Apo Dios ");
INSERT INTO xnn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ngem adi lomamot nan kalin Apo Dios isnan nemnemna tay patiyena is sin-awyan danat dokogan ay dagos no mapaligatan gapo isnan pammatina. ");
INSERT INTO xnn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nan ginsatan ay sibit et kanegna nan mangdenge isnan kalin Apo Dios ngem makolkol nan nemnemna tay wedweda nan bomaknangana ya men-gasgasingana is nenemnemena isonga adi bomgas tay nasolin nan kalin Apo Dios et kalingkingana. ");
INSERT INTO xnn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ngem nan gawis ay lota ay natekdagan di bonobon et kanegna nan ipogaw ay mangdedenge isnan kalin Apo Dios danat is-ek ay gawis isnan nemnemna danapay itotoloy ay mangpatpati engganay bomgas isonga nan kaad-adon nan gawis ay ik-ikkana et siya nan kaneg nan begasna.” ");
INSERT INTO xnn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Dat kasin menpangngalig si Jesus isnan kaipoipogaw et kanana en, “Nan ommat isnan mentolayan Apo Dios et kanegna nan inommat isnan gawis ay padog ay intoned nan esa ay am-ama isnan payewna. ");
INSERT INTO xnn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Isnan esa ay labi ay maseseyepda dat omey nan bosona et men-esek is logam issan natondan. ");
INSERT INTO xnn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dat tomobo nan pagey et menlogi ay bomgas dapay maigiddan abes san logam ay tomobo. ");
INSERT INTO xnn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Isonga dat omey nan baa isnan apoda et kananda en, ‘Apo, ay baken gawis nan padog ay intoned tako isnan payewmo? Into pay nan nagapowan nan tinmobo ay logam?’ ");
INSERT INTO xnn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Dat kanan san apoda, ‘Wada nan men-apos ay nang-ikkan issa.’ Dat kanan san baana, ‘Ay omey kami menlogam?’ ");
INSERT INTO xnn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ngem kanan san apoda en, ‘Adi, ta maid magabot isnan tinoned ");
INSERT INTO xnn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","isonga bay-anyo nan logam ay makisiken isnan pagey engganay maani. Awnitko ibaga isnan men-ani ta nan logam di omon-ona is gabotenda dadat bedbeden ta poowanda esadapay aniyen nan pagey et kapinenda isnan agamangko.’” ");
INSERT INTO xnn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Dat kasin menpangngalig si Jesus et kanana en, “Naay pay di esay sodok ay mangibaga isnan kaneg nan mentolayan Apo Dios ya nan adoado ay awnit maitapi ken siya. Nan kanegna et nan masikenan nan teeteen ay bowa ay inis-ek nan am-ama isnan om-ana. ");
INSERT INTO xnn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Siya di nan kateteenan isnan am-in ay bowa ngem no masiken et siya nan kadakkelan isnan am-in ay esek engganay kanega kadakkelan ay kaiw. Isonga mabalin ay bomaey nan koykoyat isnan pangana.” ");
INSERT INTO xnn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Dat kasin menpangngalig et kanana en, “Naay pay abes nan kaneg nan mentolayan Apo Dios. Kanegna nan bobod ay intapin nan in-ina isnan tinapay ay olay bassit et bomma isnan kaibobodana.” ");
INSERT INTO xnn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pangngalig nan os-osalen Jesus ay men-isolo isnan kaipoipogaw et maid polos nangisolowana ken daida ay egay ninpangngalig. ");
INSERT INTO xnn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Et siya na nan natongpalan din insolat di esay mamadto id kasin ay mangwani en, “Pangngalig nan awnitko osalen ay menkali ken daida. Awnit ibagak ken daida nan egay naipagtek isdin nawad-an nan batawa enggana id wani.” ");
INSERT INTO xnn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nakwas pay di dat taynan Jesus nan adoado ay ipogaw daet songgep isnan baey ay mamakkey nan papasolotna. Dadat sooten ken siya, “Ibagam kad ken dakami nan kayat ay kanan san pangngalig ay maipanggep issan logam isnan payew.” ");
INSERT INTO xnn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Dat kanan Jesus en, “San am-ama ay inmey mentoned et sak-en ay Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","San payew nan naiyaligan nan batawa. Nan gawis ay padog et daida nan an-ak Apo Dios tay naitapida isnan mentolayana. Nan logam et daida nan ipogaw Satanas. ");
INSERT INTO xnn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nan boso ay nin-esek is logam et si Satanas. Nan panag-ani et siya nan mangbanagan Apo Dios isnan ipogaw. Nan men-ani et daida nan aanghel. ");
INSERT INTO xnn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Isnan mangponokan nan baa isnan logam ay mapoowan et siya nan kaneg nan awnit ommat isnan adi mamati isnan mangbanagan Apo Dios isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tay sak-en ay Iyon-an Am-in di Ipogaw et awnitko ibaa nan aanghelko ay omey mangdagop isnan am-in ay nangipabasbasol isnan ipogaw ya nan am-in ay nang-ik-ikkan is ngawi. ");
INSERT INTO xnn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dadat itep-a daida isnan apoy ay adi katkatey et men-ag-ag-agada dadapay men-owakis isdi tay pilmi nan ligatda. ");
INSERT INTO xnn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngem nan an-ak Apo Dios et awnitda makitee ken siya ay Amada id daya. Et awnitda somilang ay kaneg nan agew tay nakaan am-in nan basbasolda. Isonga dakayo ay mangdedenge et dengngenyo no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Intoloy Jesus ay men-isolo ay mangwani en, “Nan kagawis nan maitapiyan di ipogaw isnan mentolayan Apo Dios et kanegna nan napateg ay gameng ay naikakaob isnan om-a. Dinatngan nan esay am-ama et palalo nan gasingna danat igago kasin ta omeyna on-ona ilako am-in ay kowana esapay somagong et lakowana san deey om-a. ");
INSERT INTO xnn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Naay gedan nan kaneg nan kagawis nan maitapiyan di ipogaw isnan mentolayan Apo Dios. Kanegna nan ipogaw ay oman-anap is kanginaan ay apang. ");
INSERT INTO xnn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","No waday ilaena is kagawisan ay apang dat somagong et ilakona am-in ay kowana esanapay lakowan san apang.” ");
INSERT INTO xnn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nan mentolayan Apo Dios et kaneg nan ommat isnan mensidsidok is adoado ay kalasin di ikan. ");
INSERT INTO xnn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No mapno nan sidok dadat goyoden et idakada dadat piliyen nan gawis et igwada isnan labbada dadapay iwasit nan adyanda. ");
INSERT INTO xnn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Awnit kaneg todi nan ommat isnan mangbanagan Apo Dios isnan ipogaw. Omey nan aanghel ay mangisiyan isnan kaipoipogaw ay gawis nan ogalida isnan ngawi nan ogalida. ");
INSERT INTO xnn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dadat iwasit nan ngawi nan ogalida isnan apoy ay adi katkatey et men-ag-ag-agada dadapay men-oowakis isdi tay pilmi nan ligatda.” ");
INSERT INTO xnn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dat sooten Jesus isnan papasolotna, “Ay maawatanyo nan kayat ay kanan nan sodsodokko?” Dadat kanan “Owen, maawatanmi.” ");
INSERT INTO xnn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Danat kanan, “Isonga maawatanyo gedan ay nan men-is-isolo isnan linteg no patiyena nan isolsolok ay maipanggep isnan mentolayan Apo Dios et kanegna nan kabaey ay mangtek ay mang-osal isnan indodolina ay logak ya balo ay maosal.” ");
INSERT INTO xnn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nakasodok pay si Jesus dat komaan ");
INSERT INTO xnn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","et omey isnan ilina. Dat omey ay men-isolo isnan sinagogada et nasdaaw san ipogaw ay nangdenge issan insolsolona dadat kanan, “Into nan aped nang-alaan tona isnan silibna ya nan kabaelana ay mang-ikkan isnan kaskasdaaw? ");
INSERT INTO xnn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ay baken kad anak Jose ay alawagi si tona? Ay baken anak Maria ya besat da Santiago, Jose, Simon, yas Judas? ");
INSERT INTO xnn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Et nan bebsatna ay bababai et wadada gedan isna. Into ngen nan nangsolowana isnan am-in ay getkena?” ");
INSERT INTO xnn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Isonga dadaet adi mamati ken siya. Dat kanan Jesus ken daida, “Am-in ay ipogaw et patpatgenda nan mamadto ay bakenda kailiyan ngem nan osto ay kailiyanda et adi patpatgen nan kakailiyana ya nan papamilyana.” ");
INSERT INTO xnn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Et gapo tay adida mamati ken siya egay inmipaila si Jesus is ad-ado ay kaskasdaaw ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Isnan deey ay timpo dinngen Herod ay mentoltolay id Galilea nan ik-ikkan Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Danat kanan isnan opisyalna en, “Nan naay ipogaw et waay din si Juan ay Menbonbonyag ay kasin natago isonga mabalin ay ik-ikkana nan kaskasdaaw.” ");
INSERT INTO xnn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kinwanin Herod di tay nan inommat id kasin et inpabalodna si Juan gapo tay iniyaw Juan siya isnan nang-asawaana isnan aydona ay si Herodias dapay daan nan asawana ay innodin Herod ay si Felipe. ");
INSERT INTO xnn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Isonga kayten Herod ay ipapatey si Juan ngem omegyat isnan ipogaw tay kananda en mamadton Apo Dios si Juan. ");
INSERT INTO xnn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dat omdan nan agew ay kanemnemneman nan naiyanakan Herod isonga dadat lagsakan. Dat songgep nan babassang ay anak Herodias et mensala isnan sagang nan kaipoipogaw. Dat gomasing si Herod isnan ninsalaana ");
INSERT INTO xnn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","isonga dat mensapata si Herod ken siya et kanana en, “Idyak ken sik-a nan kompolmi ay ibagam.” ");
INSERT INTO xnn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dat ibagan inana isnan babassang ta kanana ken Herod en, “Paiyalim ngalod nan olon Juan ay Menbonbonyag ay mapapalato.” ");
INSERT INTO xnn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Menseseg-ang si Herod ngem gapo tay adoado nan nangdedenge isnan sapatana et inbilina ay matongpal san kinwanin san babassang ");
INSERT INTO xnn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ay mapotowan nan olon Juan isnan pagbalodan. ");
INSERT INTO xnn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dadat ippey isnan palato et idyada issan babassang danat eyey ken inana. ");
INSERT INTO xnn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Idi dinngen nan papasolot Juan dadat omey et alaenda san awakna et ikaobda. Dadat omey ibaga ken Jesus nan inommat. ");
INSERT INTO xnn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Issan nangdengngan da Jesus issan damag ay maipanggep ken Juan dadat komaan et menloganda isnan bangka ay gomdang ta omey isnan pondag tapno makekedengda koma isdi. Ngem idi gintek nan ipogaw nan inmayan Jesus dadat mendaan isnan benget di baybay ay omey isnan inmayana. ");
INSERT INTO xnn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Idi domaka da Jesus et inilana nan kaipoipogaw ay inmonod ken siya isonga dat maseg-ang ken daida et pagawisena nan wada nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Masmasdem pay dat omey nan papasolotna ken siya ay mangwani en, “Nasdem datakopay wada kayet isnan pondag. Ibagam kad ken datona ta was-in omey isnan naisasag-en ay il-ili ta lomakoda is kanenda.” ");
INSERT INTO xnn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ngem dat kanan Jesus ken daida en, “Adi masapol ay omeyda nodi dakayo nan mangpakan ken daida.” ");
INSERT INTO xnn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Dadat kanan en, “Limlima ay tinapay ya dod-owa ay ikan nan wada ken dakami et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Dat kanan Jesus, “Iyaliyo ngalod ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Danat patokdowen nan kaipoipogaw. Danat alaen san limay tinapay ya nan doway ikan dat mentangad id daya et men-iyaman ken Apo Dios esanapay amam-asen danat idya isnan papasolotna et iwatwatda. ");
INSERT INTO xnn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dadat mangan am-in et nabsogda dapay napno kayet nan simpoo ya doway lowa isnan binay-anda ay tinogop san papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Et waay limay libo ay lalalaki san nangan isdi ay egay naibilang nan bababai ya oongong-a. ");
INSERT INTO xnn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nakwas di dat ibaan Jesus nan papasolotna ay menlogan isnan bangka ta omon-onada isnan demang nan baybay danapay pasaaen nan ipogaw ay nadagop isdi. ");
INSERT INTO xnn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Idi inpasaana daida daet mentikid isnan bilig ta menlowalo. Nalabi et daan si Jesus isnan bilig ");
INSERT INTO xnn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","dapay nan papasolotna et wadada et isnan tengan di baybay ngem adida makaipadaan isnan bangkada tay napigsa nan dagem ya dalloyon. ");
INSERT INTO xnn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Natan-o pay dat mendaan si Jesus isnan danom ay mangsab-at isnan papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dadat ilaen siya ay mendad-aan isnan danom dat palalo nan egyatda tay kananda en waay anito. Dadat kabanogaw gapo isnan egyatda. ");
INSERT INTO xnn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ngem dat komali si Jesus ay mangwani en, “Laton, laton sa. Sak-en na. Adi kayo omegyat.” ");
INSERT INTO xnn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dat kanan Pedro, “Apo, no tet-ewa ay sik-a sa ipalobosmo es sak-en ay mendaan isnan danom ta enak datngan sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Dat kanan Jesus, “Aka isna.” Dat tet-ewa domaka si Pedro isnan bangka et omey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngem idi liknaena ay napigsa nan dagem dat omegyat et ilogina ay malimon. Dat kabanogaw en, “Apo, badangam sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dat dagos ay gen-an Jesus siya et kanana, “Kolang pay laeng obpay nan talekmo. Dakan mendowadowa kayet ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dadat somakyat isnan bangka dat somaldeng nan dagem. ");
INSERT INTO xnn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dat dayawen nan papasolotna siya ay mangmangwani, “Tet-ewa ay sik-a nan Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nakagdangda pay et omdanda isnan dagan di Genesaret ");
INSERT INTO xnn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","dat inmamatonan nan ipogaw isdi si Jesus. Dadat ipadamag isnan il-ili ay eyeyda nan masaksakit ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dadat menseg-ang ta olay kedeng nan benget nan badona is sikgaden nan masaksakit daet am-in ay nangsikgad et ginmawisda. ");
INSERT INTO xnn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Isnan esay agew inmey ken Jesus nan Fariseo ya nan men-is-isolo isnan linteg ay nagapo id Jerusalem. Dadat sooten ken siya en, ");
INSERT INTO xnn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dan adi tongpalen nan papasolotmo nan ogalin din alal-apo tako tay adida menboo sadapay mangan dapay lawa di ken datako?” ");
INSERT INTO xnn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Dat kanan Jesus, “Dakayo pay, dayon adi tongpalen abes nan linteg Apo Dios dapay nan isolsolon di ipogaw et tongtongpalenyo? ");
INSERT INTO xnn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tay kanan nan linteg Apo Dios en, ‘Masapol ay tongpalenyo da amayo ken inayo,’ ya kanana gedan en, ‘Nan komali is ngawi isnan amana wenno inana et maipapatey.’ ");
INSERT INTO xnn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ngem nan apedyo isolsolo et kananyo en mabalin ay alaen nan ipogaw nan ibadangna koma isnan amana ya inana dat menlason ken daida en, ‘Epdasko inted ken Apo Dios.’ ");
INSERT INTO xnn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","No siya di nan ikkana et adi pay adiyet masapol ay badangana da amana. Isnan mang-ik-ikkananyo is dana et dokdokoganyo nan linteg Apo Dios dayopay tongtongpalen nan aped isolsolon di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Dakayo ay aginsosolot ken Apo Dios. Tet-ewa nan kalin Apo Dios maipanggep ken dakayo ay inpasolatna ken Isaias id sang-adom ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nan naayda ay ipogaw et daydayawenda sak-en isnan kalida ngem addaaddawi nan nemnemda ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Maid kapaayan nan mangdaydayawanda ken sak-en tay nan isolsoloda et nan aped bilin di ipogaw dadat aped kankanan en siya nan lintegko.’” ");
INSERT INTO xnn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nakwas ay kinwanin Jesus di danat ayagan nan kaipoipogaw et kanana ken daida en, “Dengngenyo tapno maawatanyo nan ibagak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Baken nan songgep isnan topek di ipogaw is mangipangawi ken siya nodi nan bomala isnan topekna.” ");
INSERT INTO xnn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dat somag-en nan papasolotna ken siya et kananda en, “Ay egaymo gintek ay naokos nan Fariseo isnan nangdengnganda isnan kinwanim?” ");
INSERT INTO xnn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dat kanan Jesus, “Awnit magabot am-in ay esek ay egay inis-ek Ama id daya. ");
INSERT INTO xnn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Isonga bay-anyo san deeyday Fariseo tay kanegda nan nakowap ay mangipangpango isnan ib-ada ay kowap isnan daan et no siya di et maekdagda ay dowa isnan ketang.” ");
INSERT INTO xnn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Dat kanan Pedro en, “Ibagam kad ken dakami no ngan nan kayat ay kanan nan songgep isnan topek di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Dat kanan Jesus, “Ay adiyo maawatan kayet? ");
INSERT INTO xnn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ay adiyo getken ay nan songgep isnan topek et kedeng nan makan isonga omey isnan eges dat bomala kasin. ");
INSERT INTO xnn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ngem nan ngawi ay kali ay bomala isnan topek di ipogaw et siya nan wada isnan nemnemna et siya nan mangipangawi ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tay nan nemnem di ipogaw nan magapgapowan nan am-in ay dakes ay ik-ikkana ay kaneg nan pomatey, lomalaki ya mamabai, mangakew ya nan menkamkampot ya menpabpabasol isnan ib-ana. ");
INSERT INTO xnn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Siya dana am-in nan mangipangawi isnan ipogaw. Ngem nan mangan ay adi menboo et baken di is mangipangawi ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nakwas pay dadi dat komaan da Jesus et omeyda isnan sakop nan ili ay Tiro ya Sidon. ");
INSERT INTO xnn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dat omey ken siya nan in-ina ay iCanaan ay baken Judio danat ibibiyad ay mangwani en, “Apo, ay apon din si Ali David, maseg-angka ken sak-en tay pilmi nan ligat nan anakko ay babai ay kinapet di anito.” ");
INSERT INTO xnn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ngem egay inkaskason Jesus siya dat kanan nan papasolotna, “Pakaanem kitdin ta adi tomaktak tay omon-on-onod ken datako dapay menbogbogbogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dat kanan Jesus, “Nan nangibaaan Apo Dios ken sak-en et kedeng isnan Judio tay kanegda naamas ay kalnilo.” ");
INSERT INTO xnn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngem inpapatin san in-ina ay omey ken Jesus et menpalintomeng isnan sagangna danapay kanan, “Apo, badangam adi sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ngem dat kanan Jesus, “Baken osto no maipakan nan kanen di an-ak isnan aso.” ");
INSERT INTO xnn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dat kanan san in-ina en, “Tet-ewa sa, Apo. Ngem olay nan aso et kanenda nan kamogay ay matekdag isnan dao.” ");
INSERT INTO xnn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dat kanan Jesus, “Ina, napigsa nan talekmo ken sak-en isonga ikkak nan laydem.” Dat tet-ewa maganawis san anakna. ");
INSERT INTO xnn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kinmaan si Jesus isdi dat mendaan isnan benget di baybay ay Galilea. Dat tomikid isnan bilig et tomokdo. ");
INSERT INTO xnn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dat omey nan adoado ay ipogaw ken siya ya nan inbobowegda ay masaksakit. Wada nan pilay, nan bingoy, nan kowap, nan omel ya nan tap-ina. Inyeyda daida isnan sagang Jesus danat pagawisen am-in daida. ");
INSERT INTO xnn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nasdanasdaaw san nadadagop isdi. Dadat dayadayawen si Apo Dios ay nangbadbadang isnan Judio tay menkalkali et nan omel ya ginmawis nan bingoy, nan pilay et makadaan ya nan kowap et makaila. ");
INSERT INTO xnn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Maikatlo ay agew ay daanda isdi dat ayagan Jesus nan papasolotna et kanana ken daida en, “Maseg-angak isnan naayda ay ipogaw tay tolo ay agewda isna dapay naamin et nan baonda. No ipasaak daida waay maolawda is owatda isnan somaaanda.” ");
INSERT INTO xnn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dat kanan nan papasolotna en, “Into pay omalaanmi is makan is omanay is ipakanmi isnan naayday kaipoipogaw dapay ilit isna?” ");
INSERT INTO xnn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dat kanan Jesus, “Kaat nan tinapay ay wada ken dakayo?” Dadat kanan, “Pito ay tinapay ya nan atiatik ay ikan.” ");
INSERT INTO xnn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dat ipatokdon Jesus nan kaipoipogaw ");
INSERT INTO xnn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","danat alaen san pito ay tinapay ya san ikan et men-iyaman ken Apo Dios esanapay amam-asen danat idya isnan papasolotna et iwatwatda. ");
INSERT INTO xnn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dadat mangan am-in et nabsogda. Dat togopen nan papasolotna nan binay-anda et napno kayet nan pito ay lowa. ");
INSERT INTO xnn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Waay epat ay libo ay lalalaki san nangan isdi ay egay naibilang nan bababai ya oongong-a. ");
INSERT INTO xnn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dat pasaaen Jesus daida dapay menlogan da Jesus isnan bangka et omeyda isnan sakop di Magadan. ");
INSERT INTO xnn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Isnan esa ay agew wada nan inmey ay Fariseo ya Saduceo ken Jesus tay laydenda ay allilawen siya. Kinwanida en omipaila koma is kaskasdaaw ay mangpaila ay siya nan tet-ewa ay inbaan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ngem dat kanan Jesus, “No men-gadangdang nan daya isnan masdem dakayot kanan en maegew is wakgat. ");
INSERT INTO xnn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Isnan abes wakgawakgat no men-gadangdang nan daya ya bomobolinget dakayot kanan en waay omodan. Mabalinyo ay ibaga no awnit omodan wenno adi no ilaenyo nan daya ngem adiyo maimatonan nan sinyal Apo Dios isnan ommat id wani. ");
INSERT INTO xnn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Palalo nan kangawin nan ipogaw id wani ay timpo tay adida polos nemnemen si Apo Dios. Laydenyo ay omipailaak is kaskasdaaw ngem maid polos maipaila ken dakayo nodi kedeng nan kaneg nan kaskasdaaw ay inommat ken Jonas id sang-adom.” Kinwanin Jesus di danat taynan daida. ");
INSERT INTO xnn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Isnan inomdanan da Jesus isnan demang di baybay dat nemnemen nan papasolotna ay kinalingkinganda ay omala is baonda ay tinapay. ");
INSERT INTO xnn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Dat kanan Jesus ken daida, “Makail-ilanyo nan bobod di Fariseo ya Saduceo.” ");
INSERT INTO xnn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dat men-asikwani nan papasolotna en, “Waay kinwanina di tay kinalingkingan tako ay omala is baon.” ");
INSERT INTO xnn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Getken Jesus nan kankananda danat kanan ken daida en, “Kolang nan talekyo. Dayon aped ap-apaten nan kamaid di kanenyo? ");
INSERT INTO xnn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ay adiyo kayet maawatan nan kabaelak? Kanegyo kinalingkingan din limay tinapay ay inpaad-adok ta komdeng isdin solok is limay libo ay ipogaw. Dapay kaat ay lowa nan pinnoyo isdin nabay-an? ");
INSERT INTO xnn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Et san pito ay inpaad-adok ta komdeng isdin epat ay libo ay ipogaw, kaat gedan ay lowa nan pinnoyo isdin nabay-an? ");
INSERT INTO xnn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aytay dan adiyo kayet maawatan ay baken makan nan kankanak issan nangibagaak ken dakayo en makail-ilanyo nan bobod di Fariseo ya Saduceo?” ");
INSERT INTO xnn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dadat maawatan en baken obpay nan bobod di tinapay is ipanemnemnemna nodi makail-ilanda nan baken osto ay isolsolon di Fariseo ya Saduceo. ");
INSERT INTO xnn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dat itoloy da Jesus isnan sakop nan ili ay Cesarea Filipos. Wadada pay isdi dat sooten Jesus isnan papasolotna, “Ay ngan nan pangwanin nan ipogaw ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dat kanan nan papasolotna en, “Wada nan mangwani en sik-a din si Juan ay Menbonbonyag. Nan tap-in di ipogaw et kananda en sik-a din si Elias dapay kanan kayet nan tap-ina en sik-a din si Jeremias wenno din ib-an di mamadton Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dat sooten Jesus ken daida, “Dakayo pay abes ay ngan nan pangwaniyo ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Dat kanan Simon Pedro en, “Sik-a si Kristo ay Anak Apo Dios ay inbagana en awnit omali ay men-apo.” ");
INSERT INTO xnn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Dat kanan Jesus en, “Nagasatka Simon ay anak Jonas tay baken nan ipogaw is nagapowan nan mangtekam ken sak-en nodi si Amak id daya nan nangipanemnem ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Isonga ngadanak sik-a is Pedro tay kanegka bato. Et nan kinwanim ay maipanggep ken sak-en et siya nan kanega bato ay maipegnadan nan pammatin nan am-in ay maitapi ken sak-en. Et gapo isnan pammatida et maid polos makaabak ken daida ay olay nan tetey. ");
INSERT INTO xnn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Et agtak sik-a is lebbengem ay kaneg mamanggen isnan tolbek ay manglokat isnan mentolayan Apo Dios. Et am-in ay iyadim ay maikkan isnan batawa et maiyadi abes id daya. Ya am-in ay ipalobosmo ay maikkan isnan batawa et maipalobos abes id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dat ibilin Jesus isnan papasolotna en adida ibagbaga isnan olay sino ay ipogaw ay siya si Kristo ay inbaan Apo Dios ay omali ay men-apo. ");
INSERT INTO xnn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Enggana isnan deey ay timpo et inbagan Jesus isnan papasolotna nan awnit ommat ken siya. Kinwanina ken daida, “Masapol ay omeyak id Jerusalem et awnit paligaten nan aamam-an di Judio ya nan menkangangato ay papadi ya nan men-is-isolo isnan linteg sak-en ya awnitda mangipapatey ngem isnan katlon di agew et kasinak matago.” ");
INSERT INTO xnn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dat ipagay-ed Pedro si Jesus et kanana ken siya, “Apo, adi koma ipalobos Apo Dios dana ay ommat ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dat kanan Jesus, “Taynam sak-en tay nan kinwanim et kalin Satanas. Adim dologen sak-en ay adi mang-ikkan isnan kayat Apo Dios. Nan ninemnemmo et baken adi si Apo Dios is nagapowana nodi isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dat kanan Jesus isnan papasolotna en, “No sino nan manglayad ay maitapi ken sak-en et masapol ay ibilangna ay natey et nan awakna ta baken nan laydena is ik-ikkana nodi nan laydek ta itoledna nan ligat ay kaneg nan mang-aw-awit isnan krosna ta omonod ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tay nan ipogaw ay kedeng nan awakna is nemnemnemena et awnit matey met laeng ngem no baken nan awakna is nemnemnemena gapo isnan mangsolsolotana ken sak-en et awnit matey ngem matagotago ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ay waday ganaben di ipogaw ay mangkowa is am-in ay kinabaknang isnan batawa no matey daet adi dawaten Apo Dios? Maid adi. Tay maid polos kinabaknang di ipogaw is makasokat isnan biyagna. ");
INSERT INTO xnn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Awnitak omali ay Iyon-an Am-in di Ipogaw. Isnan omaliyak et somilangak ay mangipaila isnan kangaton Ama et mamakkey nan aanghelko. Et awnitak sobalitan nan kaipoipogaw ay menbasal isnan inik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tet-ewa nan ibagak, wada ken dakayo nan matatago pay laeng engganay ilaenda nan omaliyak ay Iyon-an Am-in di Ipogaw ay mentolay.” ");
INSERT INTO xnn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nallos nan enem ay agew dat ayagan Jesus si Pedro ya nan sin-agi ay da Santiago ken Juan ta ikekedengda ay omey isnan atakdag ay bilig. ");
INSERT INTO xnn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dat tomeken nan mangiilaanda ken Jesus id isdi tay mensilsilang nan angasna ay kaneg nan agew ya pinmolapolaw nan badona ay kaneg silang di silaw. ");
INSERT INTO xnn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dadat men-ila da Moses ken Elias ay makitoytoya ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dat kanan Pedro ken Jesus, “Apo, gawis tay wada tako isna. No kayatmo omesetak is tolo ay bawi ta pala ken sik-a nan esa, pala ken Moses nan esa ya pala ken Elias nan esa.” ");
INSERT INTO xnn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Daan ay menkalkali si Pedro daet mawanada nan somili ay liboo ay manglingeb ken daida. Dadat dengngen nan kali ay nagapo isnan liboo ay mangwani, “Si tona nan Anakko ay laylaydek. Men-galalasingak gapo ken siya isonga dengngenyo nan kankanana.” ");
INSERT INTO xnn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Isnan nangdengngan nan papasolotna isnan kali dat dadama nan egyatda et menlokbobda isnan lota. ");
INSERT INTO xnn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Dat somag-en si Jesus et kapposena daida et kanana, “Bomangon kayo. Adi kayo omegyat.” ");
INSERT INTO xnn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mentangadda pay dat maid teken is inilada nodi kedeng si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Issan lomayoganda isnan deey ay bilig dat ibilin Jesus ken daida en, “Adiyo polos ibagbaga san inilayo engganay matagowak kasin.” ");
INSERT INTO xnn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dat sooten nan papasolotna, “Owen. Ngem dakan kanan en matagoka kasin dapay kanan nan men-is-isolo isnan linteg en masapol ay omon-ona ay omali si Elias mo si Kristo?” ");
INSERT INTO xnn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dat kanan Jesus, “Owen, tet-ewa ay omali omon-ona si Elias ta isaganana nan am-in. ");
INSERT INTO xnn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ngem epdas inmali si Elias dapay egay inmatonan nan ipogaw isonga inik-ikkanda nan ngawi ken siya. Et awnit kaneg todi gedan nan ikkanda ay mangpaligat ken sak-en ay Iyon-an Am-in di Ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dat maawatan nan papasolotna ay si Juan ay Menbonbonyag nan kankanana en Elias. ");
INSERT INTO xnn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Issan linmayoganda et dinatnganda nan adoado ay ipogaw dat omey nan esay am-ama ken Jesus et menpalintomeng isnan sagangna danapay kanan, ");
INSERT INTO xnn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Apo, seg-angam kad nan anakko ay menkedas. Tay no domateng nan kedasna et palalo nan ligatna et namin ado ay naek-ekdag isnan apoy ya isnan danom. ");
INSERT INTO xnn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inyeyko ay mangipaagas isnan papasolotmo ngem adida kabaelan.” ");
INSERT INTO xnn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Dat kanan Jesus, “Palalo kayo od ay ipogaw id wani. Baken osto nan nemnemyo tay nabayagak ay nakitetee ken dakayo et palalo nan anosko ngem adi kayo kayet pomati.” Danat kanan issan aman san onga, “Iyalim isna.” ");
INSERT INTO xnn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dat bilinen Jesus nan anito ta komaan isonga dat maganawis san onga ay lalaki. ");
INSERT INTO xnn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maaw-awni pay dat ikekedeng nan papasolot Jesus ay omey mensoot ken siya en, “Aytay dakamin adi makaipakaan issan deey ay anito?” ");
INSERT INTO xnn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Dat kanan Jesus, “Gapo tay kolang pay laeng nan pammatiyo ken Apo Dios. Ngem ibagak nan tet-ewa et no waday pammatiyo ken siya ay olay teeteen ay kaneg nan kateteenan ay esek et mabalin ay kananyo isnan bilig ay naay en, ‘Omeyka isdi,’ dat tet-ewa omey. Maid polos adi mabalin is adiyo ikkan. ");
INSERT INTO xnn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ngem nan kaneg todi ay anito et adi maipakaan no adiyo ipapasnek ay menlolol-owalo ay olay adi kayo mangan.” ");
INSERT INTO xnn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Isnan namingsan ay nadagop nan papasolot Jesus ken siya id Galilea danat kanan, “Nganngani ay maitedak ay Iyon-an Am-in di Ipogaw isnan mangdepap ken sak-en ");
INSERT INTO xnn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","et awnitda mangpatey. Ngem awnitak matago kasin isnan maikatlo ay agew.” Dat dadama ay menseseg-ang nan papasolotna isnan inbagana ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Inomdan pay da Jesus id Capernaum dat omey nan mensingsingil is bowis di Templo ken Pedro et sootenda, “Ay menbaybayad is bowis di Templo nan apom?” ");
INSERT INTO xnn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Owen,” insongbat Pedro. Idi sinonggep si Pedro isnan baey ay kad-an Jesus dat menkali omon-ona si Jesus ay mangwani, “Pedro, ay ngan nan nemnemmo, ay into nan men-alaan di aali is sipingda? Ay isnan an-akda wenno isnan teken ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dat kanan Pedro, “Nan teken ay ipogaw adi.” Dat kanan Jesus, “No siya sa et adi masapol ay menbayad nan an-akna. ");
INSERT INTO xnn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ngem adita koma paligten nan ipogaw isna isonga enka laengen menbanniit isnan baybay. Et nan damo ay banniitam dakat takawen nan topekna ta das-am nan siping ay omanay is maibayad. Dakat alaen et enka bayadan nan bowista.” ");
INSERT INTO xnn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Isnan deey ay agew dat omey nan papasolot Jesus ken siya et kananda, “Sino ken dakami nan kapatgan isnan mentolayan Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dat ayagan Jesus nan esa ay onga et ipatakdegna isnan sagang nan papasolotna ");
INSERT INTO xnn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","danat kanan, “Ilaenyo nan naay onga et adina polos nemnemnemen ay ipangato nan awakna. Ibagak ken dakayo nan tet-ewa no adiyo sokatan nan nemnemyo ta kaneg nan nemnem di onga et adi kayo polos maitapi isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isonga nan kapatgan isnan mentolayan Apo Dios et nan mangipabababa isnan awakna ay kaneg nan naay onga. ");
INSERT INTO xnn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Et nan manglayad ya mang-ayyew isnan kaneg nan naay ay onga gapo isnan pammatina ken sak-en et siya gedan nan kaneg nan layadna ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ngem no wada nan mang-aw-awis isnan esa ay kapatpati ken sak-en ay menbasol et gag-awis no maitaked nan losongan ay bato isnan bagangna dat maibkas isnan baybay mo nan mangipaypay-owana ay menbasol nan ib-ana. ");
INSERT INTO xnn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kaseseg-ang am-in nan ipogaw isnan batawa tay adoado nan maaw-awisanda ay bomasbasolanda. Kanayon ay wada nan mang-aw-awis ay mangipabasbasol isnan ipogaw ngem kaseseg-ang nan mang-aw-awis isnan iib-ana tay palalo nan dosana. ");
INSERT INTO xnn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","No nan ikkan nan ledengmo wenno sikim di makabasolam et gawis no pokolam ta iwasitmo. Tay gag-awis no makolangka isnan ledeng wenno siki id wani basta wada nan biyagmo ay eng-enggana mo nan dowa nan ledengmo ya nan sikim dakat mapaligatan isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Et no nan pang-ilan nan esa ay matam di makabasolam gawis no soklatem laengen. Tay gag-awis no es-esa nan matam et kedeng mo nan dowa nan matam dakat mapaligatan isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Et maipanggep abes isnan oongong-a ay naayda et makailanyo ta adiyo aamisen daida. Tay ibagak ken dakayo ay nan aanghel Apo Dios ay mang-ay-ayowan ken daida et wawawadada isnan sagang Apo Dios id daya. ");
INSERT INTO xnn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Et sak-en gedan ay Iyon-an Am-in di Ipogaw et inmaliyak ay mangisalakan isnan adi mangtek ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kinwas Jesus ay nangwani is dana danat itoloy ay menpangngalig et kanana, “Ngan nan ikkan nan ipogaw ay wada nan sin-gasot ay kalnilona dat maamas nan esa? Ay adina taynan nan siyampoo ya siyam isnan pagpastolan ta ena anapen san naamas? ");
INSERT INTO xnn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ibagak ken dakayo nan tet-ewa en isnan mangdatngana isnan naamas ay daan ay natatago et dadama nan gasingna mo nan gasingna isnan siyampoo ya siyam ay egay naamas. ");
INSERT INTO xnn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Paliso abes ken Amayo id daya tay adina layden no waday maisiyan ken siya is esa ay olay no nan kababaan ay ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“No wada nan ib-am ay mamati ken Apo Dios ay nakabasol ken sik-a dakat omey ta mentoya kayo ay dowa ta ibagam ken siya nan basolna. No idngena nan ibagam ya maawatana ay basolna et mabalin ay men-gayyem kayo kasin. ");
INSERT INTO xnn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngem no adyana nan ibagam dakat omayag is esa wenno dowa ay ib-am ay makkey ken sik-a isnan omayam kasin ay makitoya ken siya tapno matongpal nan naisolat ay bilin ay masapol ay wada nan dowa wenno tolo ay mang-aboloy isnan tet-ewa ay kankanam. ");
INSERT INTO xnn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Et no adyana pay laeng ay idnge daida dakat ipagtek isnan iib-am ay mamati isnan pagdagdagopanyo. Ngem no adyana kayet nan kanan nan iib-am ay mamati dakayot ibilang siya ay kaneg nan adi mamati ay ngawi nan ogalina. ");
INSERT INTO xnn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ibagak ken dakayo nan tet-ewa. Nan am-in ay iyadiyo ay maikkan isnan batawa et maiyadi abes id daya. Ya am-in ay ipalobosyo ay maikkan isnan batawa et maipalobos abes id daya. ");
INSERT INTO xnn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Wada pay nan ibagak ken dakayo. No eesaen nan dowa ay mamati nan dawatenda et awnit ikkan Amak id daya. ");
INSERT INTO xnn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tay olay no kedkedeng nan dowa wenno tolo is madagop gapo isnan mamatiyanda ken sak-en et wadaak gedan ken daida.” ");
INSERT INTO xnn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nakwas pay di dat omey si Pedro ken Jesus et kanana en, “Apo, no wada nan ib-ak ay mang-ik-ikkan is ngawi ken sak-en et mamin kaat ay pakawanek siya? Ay mamin pito?” ");
INSERT INTO xnn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Dat kanan Jesus, “Adiyak kanan en mamin pito et kedeng ay pakawanenyo nan ib-ayo nodi olay mamin ado pay. ");
INSERT INTO xnn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tay no iyaligko nan mentolayan Apo Dios et kaneg nan esay ali ay makitolag isnan ipogawna gapo isnan otangda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kailoglogina ay makitolag dat omey ken siya nan esa ay kalibolibo nan otangna. ");
INSERT INTO xnn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngem adi makabayad isnan otangna isonga inbilin san ali ay mailako siya ya nan asawana ya nan an-akda tapno menbalinda is baa. Et masapol abes ay mailako am-in ay kowana tapno maibayad isnan otangna. ");
INSERT INTO xnn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dat menpalintomeng san am-ama isnan sagang san ali et mendawat ken siya ay mangwani en, ‘No maseg-angka ken sak-en et awnitak bayadan am-in nan otangko.’ ");
INSERT INTO xnn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Dat maseg-ang san ali issan am-ama ay deey isonga pinakawana nan otangna et pinalobosana siya. ");
INSERT INTO xnn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Issan nangtaynanan san am-ama issan baey san ali danat ilaen nan esay ib-ana ay nakaotang ken siya is kolang ay sin-gasot. Danat ikawe siya danapay seen ay mangwani en, ‘Bayadam nan otangmo ken sak-en.’ ");
INSERT INTO xnn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dat menpalintomeng nan ib-ana isnan sagangna et mendawat ken siya ay mangwani en, ‘Maseg-angka ken sak-en et awnitak bayadan nan otangko ken sik-a.’ ");
INSERT INTO xnn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ngem egayna idnge san kinwanin san ib-ana nodi inpabalodna siya engganay bayadana nan otangna. ");
INSERT INTO xnn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Idi inilan nan iib-ana nan inikkan san am-ama dat mensakit nan nemnemda isonga dadat omey ibaga issan ali nan inommat. ");
INSERT INTO xnn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Dat ayagan san ali san am-ama et kanana ken siya en, ‘Ngawingawi nan ogalim. Am-in ay otangmo et pinakawanko tay nindawatka ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aytay damen egay seg-angan san ib-am ay nindawat ken sik-a ay kaneg nan inikkak ay nangseg-ang ken sik-a?’ ");
INSERT INTO xnn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dat makaliget san ali et ipabalodna san am-ama et paligatenda siya ta engganay bayadana am-in nan otangna.” ");
INSERT INTO xnn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Dat kanan Jesus en, “Keg todi nan ikkan Amak id daya no adi kayo pakawanen ay tet-ewa nan basol di ib-ayo ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nakwas si Jesus ay nin-isolo danat taynan nan probinsiya ay Galilea et omey isnan bas-ang di ginawang ay Jordan ay sakop di Judea. ");
INSERT INTO xnn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Adoado nan ipogaw ay inmonod ken siya et inpagawisna nan wada nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Isnan esa ay agew et wada nan Fariseo ay inmey ken Jesus tay kaytenda ay mangsikap ken siya. Dadat kanan, “Ay kanam en ipalobos nan linteg tako ay idangan nan lalaki nan asawana isnan kompolmi ay lason?” ");
INSERT INTO xnn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Dat kanan Jesus, “Ay egayyo binasa isnan kalin Apo Dios ay isnan login di batawa et isnan nangboliwana isnan ipogaw et sinapona nan lalaki ya babai. ");
INSERT INTO xnn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dat kanan Apo Dios en gapo is dana et taynan nan lalaki nan amana ya inana et maitapi isnan asawana et menbalinda ay esa. ");
INSERT INTO xnn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Et bakenda et dowa nodi es-esangda. Isonga baken osto no men-idang nan tinipon Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dat kanan san Fariseo, “Owen, ngem aytay dan insolat ngalod Moses nan linteg ay mangwani en mabalin ay men-ited nan lalaki is kasolatan ken asawana ay mangipagtek ay nin-idangda danat pakaanen siya?” ");
INSERT INTO xnn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Dat kanan Jesus, “Gapo tay nasokil kayo isonga inpalobos Moses ay makiidang kayo ngem enggana isdin damo et adi layden Apo Dios di. ");
INSERT INTO xnn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ibagak ken dakayo nan tet-ewa. Nan lalaki ay makiidang dapay egay makikamkamolala nan asawana et kaneg mamabai no makiasawa is teken.” ");
INSERT INTO xnn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dat kanan nan papasolot Jesus, “No keg todi ngalod nan sin-asawa et gag-awis no adiyet makias-asawa.” ");
INSERT INTO xnn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dat kanan Jesus, “Owen, ngem baken am-in ay ipogaw nodi kedeng isnan deeyda ay nang-itedan Apo Dios is makaanos. ");
INSERT INTO xnn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tay wada nan natkenatken ay gapo ay adi makiasawa nan ipogaw. Nan esa ay gapo et naiyanakda ay kanegda naibobotowan ya nan tap-ina et inbotowan nan ipogaw daida. Ya nan tap-ina et adida makiasawa tapno itoltoloyda ay mangibagbaga isnan maipanggep ken Apo Dios. Nan makaanos ay mangsolot et daida koma nan mang-ikkan.” ");
INSERT INTO xnn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Isnan esay agew et wadada nan nangyey isnan oongong-a ken Jesus tapno kapposena ya ilowalowana daida ngem inyadin nan papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ngem dat kanan Jesus, “Palobosanyo nan oongong-a ay omali ken sak-en. Adiyo iyadi daida tay nan mangtalek ken sak-en ay kaneg nan naayday oongong-a et daida nan maitapi isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dat kapposen Jesus daida dat komaan. ");
INSERT INTO xnn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Isnan namingsan et wada nan esa ay ipogaw ay inmey ken Jesus et kanana, “Apo, ngan nan osto ay ikkak tapno matagotagowak ken Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Dat kanan Jesus, “Damen sos-ooten ken sak-en nan maipanggep isnan gawis dapay kedkedeng si Apo Dios is gawis? Ngem no kayatmo ay matagotago ken Apo Dios et masapol ay tongpalem nan lintegna.” ");
INSERT INTO xnn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dat kasin sooten san lalaki, “Ngan pay ay linteg?” Dat kanan Jesus, “Adika menpatpatey, adika mamabai, adika menpabpabasol isnan ib-am. ");
INSERT INTO xnn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Masapol ay tongpalem da amam ken inam ya laylaydem nan iib-am ay keg nan pananglayadmo isnan awakmo.” ");
INSERT INTO xnn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Dat kanan san lalaki, “Tinongtongpalko met am-in dana. Ngan pay laeng di masapol ay ikkak?” ");
INSERT INTO xnn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Dat kanan Jesus, “No kayatmo ay ikkan nan ostoosto et ilakom am-in nan kokwam damet ipakdaw nan lakona isnan kodokdo. Dakat mang-onod ta maitapika ken sak-en et awnit wada nan kinakadangyanmo id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Idi dinngen san lalaki nan kinwanin Jesus dat komaan ay menseseg-ang tay adina kayten ay taynan nan kinakadangyana. ");
INSERT INTO xnn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dat kanan Jesus isnan papasolotna en, “Tet-ewa nan ibagak ken dakayo, naligat nan maitapiyan di kadangyan isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Owen, kasinak kanan en nalaklaka pay nan songgepan nan dakkel ay camel isnan lokaw di dagom mo nan maitapiyan di kadangyan isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nasdaaw nan papasolotna isnan nangdengnganda issan kinwanin Jesus dadat sooten, “Sino pay obpay nan mabalin ay maisalakan?” ");
INSERT INTO xnn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dat inenengneng Jesus daida danapay kanan, “Nan adi mabalin ay ikkan di ipogaw et mabalin ay ikkan Apo Dios tay maid polos adina kabaelan isonga am-in ay mangpati ken siya et maisalakan, kadangyan man wenno kodo.” ");
INSERT INTO xnn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dat kanan Pedro, “Ilam dakami et tinaynanmi am-in ay kokwami ta maitapi kami ken sik-a. Ngan pay es nan awnitmi ganaben?” ");
INSERT INTO xnn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Dat kanan Jesus, “Ibagak ken dakayo nan tet-ewa, awnit ipabalon Apo Dios nan batawa et awnit sak-en nan mentolay et dakayo ay simpoo ya dowa ay papasolotko nan tomokdo isnan tokdowan di ali ay mangbanag isnan am-in ay Judio ay aap-on din simpoo ya doway an-ak din si Israel. ");
INSERT INTO xnn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nan am-in ay mangtaynan isnan baeyna, nan bebsatna, da amana, nan an-akna ya nan payewna gapo isnan maitapiyana ken sak-en et adoado nan ganabena dapay wada nan biyagna ay maid patenggana. ");
INSERT INTO xnn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ngem ado isnan kapapatgan id wani et awnit daida nan kababaan. Ya ado isnan kababaan id wani et awnit daida nan kapapatgan.” ");
INSERT INTO xnn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Intoloy Jesus ay menpangngalig et kanana en, “Nan awnit ited Apo Dios isnan ipogaw isnan mentolayana et kaneg nan ikkan nan kakwa isnan adoado ay payew. Isnan esa ay wisngit dat omey men-anap is agagena ");
INSERT INTO xnn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","dat makitolag isnan deeyday dinas-ana isnan osto ay lagbo isnan sin-agew dadat lomokso. ");
INSERT INTO xnn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Idi napatpat-a dat omey kasin san am-ama isnan pag-ag-aggongan danat ilaen ay wadada nan men-ag-aggong tay maid oblada. ");
INSERT INTO xnn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Danat kanan ken daida en, ‘Enkayo abes makiobla isnan payewko et awnitak ited nan osto ay lagboyo.’ ");
INSERT INTO xnn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dadat tet-ewa omey. Idi nakag-aw dat omey kasin san am-ama isnan pag-ag-aggongan danat paeyen kasin san deeyday dinatngana isdi. Idi alas tres danat ikkan kasin. ");
INSERT INTO xnn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nasdem pay dat kasin omey danat ilaen ay wadada kayet nan men-ag-aggong. Danat sooten ken daida en, ‘Aytay dakayon men-ag-aggong? Ay egay kayo linmokso?’ ");
INSERT INTO xnn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Maid met mangipaobla ken dakami,’ insongbatda. Dat kasin kanan san am-ama ken daida en, ‘Enkayo ngalod men-obla isnan payewko.’ ");
INSERT INTO xnn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Maaw-awni pay dat kanan san am-ama isnan apon di baana en, ‘Ayagam nan men-ob-obla ta bayadam nan lagboda. Ilogim isnan naodi ay inmey enggana isnan inmona.’ ");
INSERT INTO xnn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dat omey san kaodiyan ay nin-obla et nan lagbo isnan sin-agew nan inlagbona ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Isonga ninemnem san ninlogi issan wisngit en ad-ado nan lagboda ngem dat obpay paliso isnan lagbon nan naod-odi. ");
INSERT INTO xnn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inalada nan lagboda dadat iyagotoot san nangipaobla ken daida ");
INSERT INTO xnn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ay mangwani en, ‘Nan deeyda et es-esa ay olas nan nin-oblaanda dapay dakami et dadama nan poos dakami pay inmaagew. Into nan ikkana ay aped paliso nan lagbomi?’ ");
INSERT INTO xnn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dat kanan san nangipaobla issan esa, ‘Owen gayyem, ngem egayak logiyen dakayo tay nintolag tako isnan osto ay inagewyo. ");
INSERT INTO xnn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Alaem bawet nan lagbom dakat somaa. No kayatko ay paliso nan lagbo nan naodi is ken dakayo ay ngan di ngotoyo od? ");
INSERT INTO xnn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ay maid kalintegak ay mang-ikkan isnan kayatko isnan sipingko? Ay mensakit nan nemnemmo tay manag-itedak?’” ");
INSERT INTO xnn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dat itoloy Jesus ay mangwani, “Siya di nan kaneg nan mentolayan Apo Dios tay nan ipogaw ay kababaan id wani et awnit daida nan kapatgan. Et nan ipogaw ay kapatgan id wani et awnit daida nan kababaan.” ");
INSERT INTO xnn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isnan omay-ayan da Jesus id Jerusalem danat ipaigid san simpoo ya dowa ay papasolotna ");
INSERT INTO xnn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","danat kanan ken daida en, “Dengngenyo. Omey tako id Jerusalem et maidyaak ay Iyon-an Am-in di Ipogaw isnan menkangangato ay papadi ya nan men-is-isolo isnan linteg. Et awnit kananda en masapol ay maipapateyak. ");
INSERT INTO xnn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dadat idya sak-en isnan baken Judio et awnit mangselaselatda ya mangbaibaigda dadat omilansa isnan kros. Ngem awnitak kasin matago isnan maikatlo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nakwas di dat omey ken Jesus nan asawan Zebedeo ya nan dowa ay an-akna dat menpalintomeng san in-ina isnan sagang Jesus ta mendawat koma. ");
INSERT INTO xnn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Dat sooten Jesus, “Ngan nan kayatmo?” Danat kanan, “Apo, no mabalin ta isnan mentolayam et makitokdo koma nan doway an-akko ken sik-a isnan makanawan ya nan makanigidmo.” ");
INSERT INTO xnn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dat kanan Jesus issan dowa ay an-ak Zebedeo ay papasolotna en, “Adiyo getken nan dawdawatenyo. Ay makaitoled kayo ay mang-okmon isnan ligat ay awnitko ligaten?” Dadat kanan, “Owen. Makaitoled kami.” ");
INSERT INTO xnn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Dat kanan Jesus en, “Tet-ewa ay awnit kayo maligatan ay kanegko. Ngem bakenak is kalebbeng ay menpili is tomokdo isnan makanawan ya makanigidko. Tay si Amak nan kalebbeng ay mangpili is tomokdo is dana.” ");
INSERT INTO xnn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Issan nangdengngan san simpoo ay ib-ada ay pasolotna isnan dinawat san sin-agi ya nan inada dadat ligten daida. ");
INSERT INTO xnn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dat ayagan Jesus daida am-in et kanana en, “Getkenyo nan maik-ikkan isnan aali ya nan tap-in di mentolay isnan batawa. Igagatinda nan ipogawda gapo tay wada nan kalinteganda ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ngem adi kabalin ay kaneg todi ken dakayo nodi nan manglayad ay ngomato ken dakayo et masapol ay siya nan menpababa ta badangana nan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Owen, nan manglayad ay kapatgan ken dakayo et masapol ay mensilbi ay kaneg baa isnan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tay kaneg sak-en ay Iyon-an Am-in di Ipogaw et egayak inmali ay masilbiyan nodi tapno mensilbiyak isnan ipogaw. Isonga awnitak matey tapno masbot nan kaipoipogaw gapo isnan basbasolda.” ");
INSERT INTO xnn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Isnan nangtaynan da Jesus id Jerico et adoado nan inmonod ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Et wada nan dowa ay kowap ay tinmotokdo isnan benget nan daan. Issan nangdengnganda ay lomaos da Jesus dadat menbogaw ay mangwani en, “Sik-a ay apon din si David, seg-angam kad dakami.” ");
INSERT INTO xnn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dat sagiiten nan ipogaw daida ta igiginekda. Ngem am-amedda kayet ninbogaw ay mangwani en, “Sik-a ay apon din si David, seg-angam kad dakami.” ");
INSERT INTO xnn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dat isaldeng Jesus et ayagana daida danat kanan, “Ay ngan nan kayatyo ay ikkak ken dakayo?” ");
INSERT INTO xnn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dadat kanan en, “Apo, kayatmi ay makaila koma.” ");
INSERT INTO xnn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dat seg-angan Jesus daida et kapposena nan matada dadat maganawis et makailada dadlo. Dadat makkey ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Issan sinmag-enan da Jesus id Jerusalem et nganngani ay omdanda isnan ili ay Betfage ay sag-en nan bilig ay Olivo dat ibaan Jesus nan dowa ay papasolotna ");
INSERT INTO xnn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","et kanana, “Enkayo isnan ili ay deey et awnit ilanyo nan kabayo ay wada nan anakna. Dayot okasen nan baodda ta iyaliyo isna. ");
INSERT INTO xnn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","No waday mensoot isnan ik-ikkanyo dayot kanan en masapol nan apoyo et ipalobosna ay dagos.” ");
INSERT INTO xnn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Naikkan dana ta matongpal nan inbagan nan esay mamadton Apo Dios en, ");
INSERT INTO xnn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ibagayo isnan iJerusalem en, ‘Ilaenyo. Naay omal-ali nan Aliyo ay nangipababa isnan awakna ay mensasakay isnan anak di kabayo.’” ");
INSERT INTO xnn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dat omey nan papasolotna et ikkanda nan inbagan Jesus ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inyeyda nan kabayo ya nan anakna dadat ap-apan isnan badbadoda dat sakayan Jesus san anak di kabayo. ");
INSERT INTO xnn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dat iyaplag nan kaipoipogaw nan badbadoda isnan daanen Jesus dapay iyaplag nan tap-ina nan tobon di kaiw ta ipailada ay daydayawenda si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nan inmon-ona ya naod-odi et menbogbogawda ay mangmangwani en, “Hosanna. Madaydayaw nan naay Ali tako ay apon din si David. Mabindisyonan nan inbaan Apo Dios ay mentolay ken datako. Madaydayaw nan ngadan Apo Dios id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Issan inomdanan da Jesus id Jerusalem dat men-giyaw nan omili isdi ay mangmangwani, “Sino nan ipogaw ay deey?” ");
INSERT INTO xnn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dat kanan nan ipogaw ay nakkey ken siya en, “Siya na si Jesus ay mamadton Apo Dios ay nagapo id Nazaret isnan probinsiya ay Galilea.” ");
INSERT INTO xnn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Id Jerusalem et sinonggep si Jesus isnan Templo danat pabalaen nan men-il-ilako ya lomaklako is awnitda ited ken Apo Dios danapay tokangen nan lamisaan di mensoksokat is siping ya nan tokdowan di men-ilaklako is kalapati. ");
INSERT INTO xnn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Danat kanan ken daida en, “Naisolat isnan kalin Apo Dios en, ‘Nan baeyko et paglol-owalowan di ipogaw.’ Siya di nan inbagan Apo Dios ngem ngan nan ik-ikkanyo? Dakayon aped os-osalen ay pagsos-owitikan?” ");
INSERT INTO xnn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dat omey nan kowap ya nan pilay ken Jesus issan Templo. ");
INSERT INTO xnn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ngem issan nang-ilaan nan menkangangato ay papadi ya nan men-is-isolo isnan linteg issan kaskasdaaw ay inikkan Jesus et dadama nan ligetda. Dadat am-amed lomiget issan nangdengnganda isnan oongong-a ay menbogbogaw isnan Templo ay mangmangwani en, “Dayawen tako nan apon din si David.” ");
INSERT INTO xnn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Dadat sooten ken Jesus, “Ay adim dengngen nan kankanan nan oongong-a?” Dat kanan Jesus, “Dedengngek ya. Ay egayyo binasa nan naisolat isnan kalin Apo Dios en initdowana nan oongong-a tapno ostoosto nan mangdaydayawanda ken siya?” ");
INSERT INTO xnn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kinwanin Jesus di danat taynan daida et omey omapa id Betania. ");
INSERT INTO xnn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kawakgatana isnan sinmagongan da Jesus id Jerusalem et naowat siya. ");
INSERT INTO xnn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Danat ilaen nan esay kaiw ay higos dat omey ta ilana no waday begasna ngem kedeng nan tobona is wada. Danat kanan, “Adika kasin bombomgas.” Dat maango ay dagos san kaiw. ");
INSERT INTO xnn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nasdaaw nan papasolotna isnan nang-ilaanda et kananda en, “Ine. Dan aped naango ay dagos nan naay ay kaiw?” ");
INSERT INTO xnn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Dat kanan Jesus, “Ibagak ken dakayo no mamati kayo ken Apo Dios ay maid dowadowana et makaikkan kayo abes isnan kaneg nan inikkak isnan naay ay kaiw. Baken pay kedeng di is maikkanyo nodi mabalin ay ibagayo isnan deey ay bilig en men-aton isnan baybay et men-aton tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tay no ostoosto nan pammatiyo ken Apo Dios et am-in ay dawatenyo ken siya et tongpalena.” ");
INSERT INTO xnn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Dat somagong si Jesus isnan Templo ay men-isolo dat omey ken siya nan aamam-a ya nan menkangangato ay papadi et kananda en, “Ibagam kad ken dakami no ngan nan kalebbengam ay mang-ik-ikkan isnan am-in ay ik-ikkam. Ay sino nan nang-ited ken sik-a isnan lebbengmo?” ");
INSERT INTO xnn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Dat songbatan Jesus daida en, “Sootek na od ken dakayo et no makasongbat kayo daket ibaga abes nan nagapowan nan lebbengko. ");
INSERT INTO xnn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Siya na nan sootek. Into nan nagapowan din kalebbengan Juan ay Menbonbonyag? Ay ken Apo Dios wenno isnan ipogaw?” Dadat men-asisoot et kananda en, “Ay sino nan isongbat tako? No kanan tako en nagapo ken Apo Dios et awnit kanana en, ‘Ayta ngalod dayon egay pinatpati din si Juan?’ ");
INSERT INTO xnn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngem no kanan tako en nagapo isnan ipogaw et kaeegyat nan ikkan nan ipogaw ken datako tay kananda en tet-ewa ay mamadton Apo Dios din si Juan.” ");
INSERT INTO xnn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Isonga dadat kanan en, “Adimi getken.” Dat kanan Jesus, “Adiyak ngalod abes ibagbaga nan nagapowan nan kalebbengak ay mang-ik-ikkan isnan ik-ikkak.” ");
INSERT INTO xnn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Dat menpangngalig si Jesus et kanana en, “Ngan nan nemnemyo isnan naay? Wada nan esay am-ama ay doway lalalaki nan anakna. Kinwanina isnan iyon-a en, ‘Kadya enka mensaba.’ ");
INSERT INTO xnn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Adiyak,’ insongbatna. Ngem maaw-awni pay danat sokatan nan nemnemna et omey men-obla. ");
INSERT INTO xnn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dat omey nan am-ama isnan innodi et paliso nan inbagana ken siya. Danat kanan ken amana en, ‘Owen Ama, omeyak.’ Ngem egay obpay inmey. ");
INSERT INTO xnn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sino issan dowa nan nangtongpal isnan bilin amada?” Dadat kanan, “Nan iyon-a adi.” Dat kanan Jesus, “Owen et ibagak ken dakayo ay aap-apon di Judio, nan managbasol ay kaneg nan mensingsingil is bowis ya nan makilalalaki et awnitda maitapi isnan mentolayan Apo Dios esakayopay maitapi. ");
INSERT INTO xnn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tay inmali si Juan ay Menbonbonyag et inbagana ken dakayo nan osto ay ikkanyo tapno gomawis nan ogaliyo ngem egayyo pinati siya dapay pinatin nan mensingsingil is bowis ya nan makilalalaki siya. Olay no inilayo nan ninbabawiyanda et egayyo sinokatan nan nemnemyo ta patiyenyo nan inbagan Juan.” ");
INSERT INTO xnn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Dat sodoken Jesus na, “Dengngenyo nan tap-in di pangngalig. Wada nan esay am-ama ay nin-esek is adoado ay onas. Danat bakden nan om-ana dat omset is paglebkan is mangsetset isnan danom di onas dapay mensaad is atakdag ay baey is mentean di menbanbantay. Danat ipaayowan isnan ipogaw esapay omey isnan addaaddawi ay ili. ");
INSERT INTO xnn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Inomdan pay nan maapitan nan onas dat ibaan san kakwa nan baana ta enda alaen nan pigasna. ");
INSERT INTO xnn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ngem dinpap san men-ay-ayowan san inbaana et baibaigenda nan esa dadat pateyen nan esa dadapay gayangen nan esa. ");
INSERT INTO xnn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dat kasin omibaa san kakwa is ad-ado mo san damo ngem paliso nan inikkan san men-ay-ayowan ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Isonga danat ibaa nan anakna tay kanana en sigolado ay siya nan idngeda. ");
INSERT INTO xnn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ngem issan nang-ilaan san men-ay-ayowan issan anak san kakwa dadat mentotya et kananda en, ‘Naay omali nan awnit mangtawid isnan naay om-a. Pateyen tako bawet siya ta datako nan mangkowa isnan tawidna.’ ");
INSERT INTO xnn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Isonga dadat depapen et ibalada isnan onasan dadat pateyen.” ");
INSERT INTO xnn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Dat kanan Jesus isnan mangdedenge en, “No omali san kakwa isnan deey ay onasan ay ngan ngata nan ikkana isnan deeyda ay men-ay-ayowan?” ");
INSERT INTO xnn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dadat kanan, “Kaeegyat nan ikkana ay mangpatey ken daida tay palalo nan kangawida danat ipaayowan nan onasana isnan teken ay matalek ya makaited isnan pigasna.” ");
INSERT INTO xnn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Dat kanan Jesus ken daida en, “Tet-ewa sa. Ngem ay egayyo binasa nan naisolat isnan kalin Apo Dios ay mangwani en, ‘Nan bato ay inadyan di nangsaad isnan baey et siya nan kapatgan tay ipakekenegna nan baey. Inikkan Apo Dios na et pilmi ay kaskasdaaw ken datako.’” ");
INSERT INTO xnn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Intoloy Jesus en, “Ibagak ken dakayo en olay no nan Judio nan pinilin Apo Dios id sang-adom ngem gapo isnan mang-adyananyo isnan inbaana et adi kayo et maitapi isnan mentolayana nodi nan ipogaw ay mangtongtongpal isnan kayatna. ");
INSERT INTO xnn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Et nan maipakpak isnan deey ay kapatgan ay bato ay naiyaligak et masogasogatan ya no matekdag gedan san deey ay bato et mamekmemekmek nan pontaana.” ");
INSERT INTO xnn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Isnan nangdengngan nan menkangangato ay papadi ya nan Fariseo isnan pangngalig Jesus et naawatanda ay daida nan kankanana ay nang-adi isnan inbab-aan nan kakwa issan onasan ya nan napateg ay bato tay adyanda siya. ");
INSERT INTO xnn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Isonga laydenda ay depapen siya ay dagos ngem omegyatda isnan ipogaw tay kananda en mamadton Apo Dios siya. ");
INSERT INTO xnn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Dat kasin menpangngalig si Jesus ken daida et kanana en, ");
INSERT INTO xnn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nan awnit maitapiyan nan ipogaw isnan mentolayan Apo Dios et kaneg nan ikkan nan esay ali ay mangisagana isnan bomayasan nan anakna. ");
INSERT INTO xnn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Insaganana nan am-in danat ibaa nan baana ay omey mendekat ngem adyan nan nadkat ay omey. ");
INSERT INTO xnn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Isonga inbaana kasin nan tap-in di baana ta ibagada en, ‘Kadya, omali kayo tay pinaltimi nan baka ya nan tap-in di menlalmes ay talakenmi. Nakasagana et am-in isonga omali kayo et.’ ");
INSERT INTO xnn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ngem nan inayaganda et adida polos idnge nodi itoltoloyda kayet nan ik-ikkanda. Wada nan linmokso ya wada nan inmey nin-ilako ");
INSERT INTO xnn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","dapay depapen nan tap-ina san deeyday baa et baigenda ay mangpatey ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Dadama nan liget san ali issan nangdengngana is dadi isonga danat ibaa nan sosoldadona ay omey mangpatey isnan ngawi ay ipogaw dadapay poowan nan ilida. ");
INSERT INTO xnn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dat kasin kanan san ali isnan baana en, ‘Naisagana nan am-in isnan babayas ngem nan inayagak et adida maibagay ay maitapi. ");
INSERT INTO xnn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Enkayo ngalod isnan madagdagopan di ipogaw ta ayaganyo am-in daida.’ ");
INSERT INTO xnn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Isonga dadat omey ayagan am-in nan das-anda olay no ngawi wenno gawis nan ogalina daet napno nan baey san ali. ");
INSERT INTO xnn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Maaw-awni pay dat songgep san ali ay makitoya isnan sangailina danat ilaen nan esa ay egay nangibado isnan pala bodana. ");
INSERT INTO xnn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Dat kanan san ali ken siya en, ‘Gayyemko, aytay dakan wada isna dakapay egay ninbado isnan pala bodam?’ Ngem aped gomiginek san am-ama. ");
INSERT INTO xnn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dat kanan san ali isnan baana en, ‘Ogdenyo nan naay ipogaw dayot itep-a siya isnan menbolinget. Et men-ag-ag-aga ya men-oowakis isdi gapo isnan pilmi ay ligatna.’” ");
INSERT INTO xnn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dat kanan Jesus en, “Adoado nan ayagan Apo Dios ngem atiatik nan mapili ay maitapi ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nakwas di dat komaan nan Fariseo ta enda mentotya is ikkanda ay mangsikap koma ken Jesus isnan mensootanda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dadat ibaa nan iib-ada ya nan ib-an Ali Herod ta omeyda ken Jesus. Dadat kanan, “Apo, getkenmi ay adika polos al-allilawen nan ipogaw nodi isolsolom nan osto ay layden Apo Dios ay ikkanda ya maid paam-amdem isnan nangato ya nababa ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Isonga ibagam kad ken dakami no ngan nan kanam isnan naay. Ay iyadin nan linteg tako nan mangbayadanmi is bowis ken Cesar ay ali id Roma?” ");
INSERT INTO xnn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngem getken Jesus ay siksikapanda siya isonga danat kanan, “Dakayo ay aginsosolot ken Apo Dios, aytay dayon layden ay mangsikap ken sak-en? ");
INSERT INTO xnn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Omyali kayo is siping ay maibayad is bowis.” Dadat idya ken siya nan siping ");
INSERT INTO xnn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","danat sooten, “Sino nan kaangas ya kangadan isna?” ");
INSERT INTO xnn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Si Cesar,” insongbatda. Dat kanan Jesus ken daida en, “No siya ngalod sa et kowan Cesar nan siping isonga ikkanyo ken Cesar nan kalebbengana dayopay abes ikkan ken Apo Dios nan kalebbengana.” ");
INSERT INTO xnn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nasdaaw san Fariseo issan nangdengnganda isnan kinwanin Jesus isonga dadat komaan. ");
INSERT INTO xnn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Isnan deey ay agew et wada nan Saduceo abes ay inmey ken Jesus ay mangpadas ay mangsikap ken siya. Datona nan Judio ay adi mamati ay kasin matago nan natey. ");
INSERT INTO xnn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kinwanida ken Jesus, “Apo, insolat Moses id sang-adom en no matey nan lalaki ay inmasawa dapay maid anakda et masapol ay asawaen nan besat san natey nan balo tasiyay omanakda et maibilang ay kaneg anak san natey. ");
INSERT INTO xnn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kadya, id kasin et wada nan pito ay sin-ag-i ay lalalaki ay omili isna. Inmasawa nan iyon-a dat matey ay maid anakda. Dat asawaen nan maisned san aydona ");
INSERT INTO xnn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","dat matey gedan ay maid anakda. Et siya gedan nan inommat isnan maikatlo enggana isnan maikapito. Nateyda am-in ay maid anakda. ");
INSERT INTO xnn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kaodiyan ay natey san balo. ");
INSERT INTO xnn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naay nan sootenmi, isnan katagowan nan natey ay sino pay nan osto ay asawan san babai issan pito ay sin-ag-i tay inasawada am-in siya?” ");
INSERT INTO xnn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dat songbatan Jesus et kanana, “Baken osto nan nemnemyo tay adiyo od getken nan naisolat isnan kalin Apo Dios ya adiyo gedan getken nan kabaelana. ");
INSERT INTO xnn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tay isnan matagowan nan natey et menbalinda ay kaneg nan aanghel id daya ay adi makias-asawa. ");
INSERT INTO xnn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Et maipanggep isnan matagowan nan natey ay egayyo binasa nan naisolat isnan kalin Apo Dios? Tay kanana en, ");
INSERT INTO xnn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sak-en nan Dios ay daydayawen da Abraham ken Isaac ya si Jacob.’ Ngem epdas natey da Abraham issan nangwaniyan Apo Dios isdi. Et siya di nan manggetkan tako ay matatago kayet nan natey ay ipogaw Apo Dios tay adi kabalin ay kanan Apo Dios en daydayawenda siya kayet no egayda natago kasin.” ");
INSERT INTO xnn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dat nasdaaw nan ipogaw isnan nangdengnganda isnan isolsolon Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Issan nangdengngan nan Fariseo ay inabak Jesus nan Saduceo isnan mensos-ootanda dadat omey abes ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dat padasen nan esay men-is-isolo isnan linteg ay mangsikap ken Jesus et kanana en, ");
INSERT INTO xnn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Apo, ngan nan kapatgan isnan linteg tako?” ");
INSERT INTO xnn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Dat kanan Jesus, “Masapol ay laylaydenyo ay ostoosto si Apo Dios ay Apoyo isnan nemnem ya posoyo ya isnan am-in ay ik-ikkanyo. ");
INSERT INTO xnn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Siya na nan kapatgan isnan am-in ay linteg. ");
INSERT INTO xnn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Et nan maikadwa ay kapatgan et laylaydenyo nan iib-ayo ay kaneg nan pananglaylayadyo isnan awakyo. ");
INSERT INTO xnn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nan naay dowa et daida nan poon nan am-in ay linteg Moses ya nan am-in ay isolsolon nan mamadton Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Esapay komaan san deeyday Fariseo et ninsoot abes si Jesus ken daida et kanana, ");
INSERT INTO xnn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ngan nan pangwaniyo ken Kristo ay inbagan Apo Dios ay awnitna ibaa ay mentolay? Sino nan kaapo ken siya?” Dadat kanan, “Apon din si David.” ");
INSERT INTO xnn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dat kanan Jesus, “No apon din si David si Kristo ayta ngalod dan kanan din si David en si Kristo nan Ap-apona? Tay inpakalin nan Ispiriton Apo Dios si David ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kinwanin Apo Dios ken Kristo ay Ap-apok en tomokdoka isnan makanawanko engganay abakek am-in nan bosom.’” ");
INSERT INTO xnn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dat kasin mensoot si Jesus ken daida et kanana, “No kanan David en Ap-apona si Kristo, dayon aped kanan en alapon Kristo si David? Ay baken Ap-apon David si Kristo?” ");
INSERT INTO xnn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dadat adi makasongbat isnan soot Jesus isonga enggana issan agew ay deey et egayda et kasin ninsos-oot ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dat ibagan Jesus isnan ipogaw ay nadagop ya isnan papasolotna en, ");
INSERT INTO xnn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nan men-is-isolo isnan linteg ya nan Fariseo et daida nan kalebbeng ay mangisolo isnan linteg Apo Dios ay insolat din si Moses ");
INSERT INTO xnn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","isonga masapol ay tongpalenyo am-in ay isoloda ken dakayo. Ngem adiyo solsoloten nan ik-ikkanda tay adida ik-ikkan nan isolsoloda. ");
INSERT INTO xnn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tay taptapiyanda is adoado ay bilin nan linteg engganay mapaligatan nan mangtongpal ay kanegda men-ipaaw-awit is mendagsen dadapay adi polos badangan daida. ");
INSERT INTO xnn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Am-in nan ik-ikkanda et ikkanda isnan mangiilaan di ipogaw tapno it-it-ekda daida. Isonga inpadakdak-eda nan papil ay naisolatan nan kalin Apo Dios ay ibebedbedda isnan kitongda ya isnan takkayda dadapay ipaando nan pagaypay nan badoda ta ipailada isnan ipogaw nan kagawisda. ");
INSERT INTO xnn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pilpiliyenda pay nan kagawisan ay tokdowan isnan enda makikanan ya isnan sinagoga. ");
INSERT INTO xnn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kaytenda abes ay malispito isnan enda menpasyalan ya kaytenda abes ay makmakwani en mistolo. ");
INSERT INTO xnn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ngem dakayo et adiyo ipalobos nan ib-ayo ay mangwani ken dakayo en mistolo tay sinbebsat kayo am-in et kedengak is mistoloyo. ");
INSERT INTO xnn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Et adiyo abes kankanan isnan ib-ayo isnan naay batawa en Ama tay wada nan es-esay amayo ay si Apo Dios id daya. ");
INSERT INTO xnn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Adiyo gedan ipalobos nan ib-ayo ay mangwani en Apo ken dakayo tay sak-en ay Kristo nan Apoyo ay inbaan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nan kapatgan ken dakayo et masapol ay siya nan mangbadbadang isnan ib-ana. ");
INSERT INTO xnn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Et nan mangipapangato isnan awakna et awnit maipagowab met laeng. Ngem nan mangipabababa isnan awakna et awnit maipangato.” ");
INSERT INTO xnn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Dat itoloy Jesus ay mangwani en, “Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo tay aginsosolot kayo ken Apo Dios. Seseyatanyo nan maitapi koma isnan mentolayan Apo Dios gapo isnan isolsoloyo ya isnan ik-ikkanyo. Adi kayo polos maitapi gapo isnan ogaliyo dayopay adi ipalobos nan mangkayat ay maitapi. ");
INSERT INTO xnn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Tay tagikowaenyo nan kokwan di nabalo ay bababai. Dayot lingban nan ngawi ay ik-ikkanyo isnan mang-andoandowanyo isnan lowaloyo. Ngem gapo is dana et awnit am-amed nan dosayo. ");
INSERT INTO xnn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Tay nan ikkanyo et olay nan baybay isnan teken ay ili et bas-angenyo ta omanap kayo is olay es-esa ay awisenyo ta men-ib-ayo. Ngem no waday awisenyo et am-amedyo ipangawi isonga am-amed nan maipaeyana isnan apoy ay adi katkatey mo dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aye nan awnityo dosa tay dakayo koma nan men-isolo ngem kanegyo nan kowap ay mangipangpango isnan ib-ada. Tay isolsoloyo en no waday mangisapata isnan Templon Apo Dios et baken basol no adina tongpalen. Ngem kananyo en no nan balitok isnan Templo nan isapatana et masapol ay tongpalena nan sapatana. ");
INSERT INTO xnn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tet-ewa ay nakowap kayo ya maid nemnemyo. Ngan nan kapatgan, nan balitok wenno nan Templo ay kabindisyonan nan balitok? ");
INSERT INTO xnn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kananyo abes en no nan mangisapata isnan altar ay maipaypay-an nan maited ken Apo Dios et baken basol no adina tongpalen ngem nan mangisapata isnan naited ken Apo Dios et masapol ay tongpalena nan insapatana. ");
INSERT INTO xnn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tet-ewa ay nakowap kayo ya maid getkenyo. Ay ngan nan kapatgan, nan naited ken Apo Dios wenno nan naipay-ana ay kabindisyonan nan naited? ");
INSERT INTO xnn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ngem no isapatan nan ipogaw isnan naipay-an nan naited ken Apo Dios et itapina abes nan naited ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Et no isapatana abes nan Templon Apo Dios et isapatana gedan si Apo Dios ay wada isdi. ");
INSERT INTO xnn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Et no wada nan mangisapata isnan daya ay kad-an Apo Dios et isapatana abes si Apo Dios ay mentotolay isdi. ");
INSERT INTO xnn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Tet-ewa ay dalonyo tongpalen nan linteg Apo Dios ay kaneg nan mang-ag-agtanyo ken siya is bingayna ay olay nan kaatikan ay ap-apitenyo ay mangipabango isnan madengdeng ngem kalingkinganyo nan kaam-amedan isnan lintegna ay nan osto ay ikkanyo isnan ipogaw ya nan mangbadanganyo isnan makasapol is badang ya nan mang-ikkananyo isnan ikkan di matalek. Gawis nan mang-it-itedanyo isnan bingayna ngem masapol ay adiyo kalkalingkingan nan naayda ay kaam-amedan isnan linteg. ");
INSERT INTO xnn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Tet-ewa ay kowap kayo ay men-ipangpango. Kanegyo nan mangsagat is lingew isnan inomena danapay men-okmon nan baka tay eestenyo ay mang-ik-ikkan isnan kababaan ay bilin dayopay adi tongpalen nan kapatgan. ");
INSERT INTO xnn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Kanegyo nan mang-owas isnan tasa ya nan palato ay kedkedeng nan maiila is owasana. Kanegyo datona tay gawis nan ipap-ailayo ngem adiyo dalosan nan ngawi isnan nemnemyo ay kinaagom ya sowitik. ");
INSERT INTO xnn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Dakayo ay Fariseo et kaneg kayo kowap. Masapol ay dalosanyo omon-ona nan ngawi ay adi mamaila ta madalosan abes nan mamaila. ");
INSERT INTO xnn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Kanegyo nan pantiyong ay napintolan is polaw. Gawis nan boyana ngem isnan leemna et kaingiingit di natey nan mentetee dapay menpeleleteg. ");
INSERT INTO xnn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Siya di tet-ewa nan kanegyo tay isnan mangiilaan nan ipogaw et gawis kayo ngem kedeng nan ngawi is wada isnan nemnemyo.” ");
INSERT INTO xnn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Intoloy Jesus ay mangwani ken daida en, “Aye nan awnityo dosa, dakayo ay men-is-isolo isnan linteg ya Fariseo ay aginsosolot ken Apo Dios. Tay om-omset kayo is gawis ay pantiyong isnan naikaoban din mamadton Apo Dios dayopay altialtiyan nan tap-in di naikaoban din gawis di ogalida. ");
INSERT INTO xnn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dayopay kanan en, ‘No wada kami koma issan timpon din alal-apomi et egay kami nakiik-ikkan isdin inik-ikkanda ay nangipapatey isdin mamadton Apo Dios.’ ");
INSERT INTO xnn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Siya nan kananyo na ngem gapo isnan ngawi ay nemnemyo et ipailayo ay dakayo nan tet-ewa ay aap-on din nangpatey isdin mamadton Apo Dios id sang-adom. ");
INSERT INTO xnn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sigi ngalod. Kewasenyo et ay mang-ikkan isnan inlogin din alal-apoyo id sang-adom. ");
INSERT INTO xnn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kaneg kayo oweg tay nasikap ya manag-allilaw kayo. Ay kananyo en mailisi kayo isnan dosa isnan apoy ay adi katkatey? Ngem adi. ");
INSERT INTO xnn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tay awnitak ibaa nan mamadto ya nan mamasilib ya nan men-isolsolo ay mangisolo koma ken dakayo. Ngem awnityo pateyen ya ilansa isnan kros nan tap-ina. Nan tap-ina et baigenyo isnan sinagoga dayopay kedagen nan tap-ina ay mangpaligat olay intoy omayanda. ");
INSERT INTO xnn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Isonga dakayo nan awnit mangikalo isnan dosan nan nangpatpatey isnan am-in ay ipogaw ay maid basolda menlogi isdin napateyan Abel ay esay lalaki ay gawis nan ogalina enggana isdin napateyan din anak Barakias ay si Zacarias isnan pantew ay ninbaetan nan Templo ya nan altar. ");
INSERT INTO xnn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ibagak ken dakayo ay tet-ewa en awnit madosa nan ipogaw id wani gapo ken daida am-in ay napatpatey.” ");
INSERT INTO xnn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Dat kanan Jesus en, “Dakayo ay i Jerusalem et maseg-angak ken dakayo tay ginaygayangyo ya pinatpateyyo nan mamadto ay inbaan Apo Dios ay mangisolo ken dakayo. Namin kaat ay kayatko ay ponoken dakayo koma ay kaneg nan mangsakokowan nan manok isnan an-akna ngem adyanyo. ");
INSERT INTO xnn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Isonga id wani kigad kayo et tay adiyet mentetee si Apo Dios ay mangbadang ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ibagak ken dakayo en adi kayo kasin mang-il-ila engganay kananyo en, ‘Madaydayaw si Kristo ay inmali isnan ngadan Apo Dios.’” ");
INSERT INTO xnn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isnan kinmaanan Jesus isnan Templo dat somag-en nan papasolotna ken siya ay mangipaila isnan kagawis nan Templo ya nan bab-aey ay sag-ena. ");
INSERT INTO xnn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ngem dat kanan Jesus, “Owen, ilanyo am-in nan naayda ngem awnit domateng nan timpo ay maid polos mabaybay-an is olay esa ay batona tay awnit mapokada am-in.” ");
INSERT INTO xnn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Isnan nangtaynan da Jesus id Jerusalem dadat omey isnan bilig ay Olivo. Idi wadada isdi dat ikekedeng nan papasolotna ay omey ken siya et kananda en, “Kadya, ibagam ken dakami no tongona nan maikkanan san kinwanim id kawni. Ngan nan awnit kailasinana ta getkenmi ay nganngani nan omaliyam ya nan menpatenggaan nan batawa?” ");
INSERT INTO xnn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dat kanan Jesus ken daida en, “Makailanyo ta maid mang-al-allilaw ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tay adoado nan awnit omali ay mangwani en daida nan Kristo ay inbaan Apo Dios et awnit allilawenda nan ado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Awnit dengngenyo nan ngalawngaw di gobat ay maisasag-en ken dakayo ya nan damag ay wada nan gobat isnan ad-addawi ay ili. Ngem adi kayo makibkibtot tay masapol ay ommat dana ngem baken di is menpatenggaan nan batawa. ");
INSERT INTO xnn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Awnit men-asigobat nan kailiili ya kaneg abes nan kagobigobilno ya awnit wada gedan nan kabitibitil ya yegyeg isnan natkenatken ay il-ili. ");
INSERT INTO xnn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Am-in dana et siya nan menlogiyan nan ligat ay kaneg nan damo ay menpasikalan nan omanak. ");
INSERT INTO xnn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Et awnit aamisen nan ipogaw dakayo gapo isnan pammatiyo ken sak-en. Et awnit depapenda dakayo dadapay paligaten nan ib-ayo ya pateyen nan tap-iyo. ");
INSERT INTO xnn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gapo is dana et ado nan mangdokog isnan pammatida dadat men-inamis dadapay isipsip nan ib-ada. ");
INSERT INTO xnn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Et awnit omdan ken dakayo nan mamadto ay baken tet-ewa ay mamadton Apo Dios et allilawenda nan ado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gapo isnan kapalalon nan ngawi isnan batawa et awnit mamaid nan layad nan ipogaw isnan ib-ada. ");
INSERT INTO xnn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ngem nan makaanos ay adi mangdokdokog isnan pammatina engganay makwas nan am-in et wada nan biyagna ay maid patenggana. ");
INSERT INTO xnn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Et awnit maibaga isnan kaipoipogaw isnan batawa nan gawis ay damag maipanggep isnan mentolayan Apo Dios engganay dengngenda am-in et siya dinto et nan menpatenggaan nan batawa.” ");
INSERT INTO xnn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Dat itoloy Jesus ay mangwani en, “Wada nan inbagan din si Daniel ay esay mamadton Apo Dios id sang-adom en, ‘Awnit ilaenyo nan kadodogis isnan pangiilaan Apo Dios ay tomakdeg isnan Templo ay adina bagay ay tomakdegan.’ (Nan mangbasa isnan naay et maawatanyo koma.) ");
INSERT INTO xnn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Isonga isnan mang-ilaanyo is dana et masapol ay nan ipogaw id Judea et menbakwitda isnan bilbilig. ");
INSERT INTO xnn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Et nan wada isnan pantewna et adiyet songgep ay mang-ala isnan bonagna. ");
INSERT INTO xnn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kaneg abes nan epdas linmokso et adiyet makasaa isnan baeyna ay mang-ala isnan badona. ");
INSERT INTO xnn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Am-amed kaseseg-ang nan maliton ya nan mensaskot isnan omdanan nan deey ay timpo. ");
INSERT INTO xnn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Isonga menlowalo kayo ken Apo Dios tapno baken isnan timpon di lemlem wenno isnan obaya nan ommatana. ");
INSERT INTO xnn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tay nan ligat isnan deey ay timpo et siya nan kaam-amedan isnan am-in ay ligat ninlogi isdin naboliwan di batawa ay enggana id wani dat maid et kasin domatdateng is kaneg todi isnan batawa ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngem maseg-ang si Apo Dios isnan pinilina ay ipogaw isonga inat-atikna nan agew ay menligatan tay no egayna geddengan nan agew et maid mabay-an isnan batawa.” ");
INSERT INTO xnn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Intoloy Jesus ay mangwani en, “Isonga no wada nan mangwani en, ‘Ilam, naay si Kristo,’ wenno ‘Deey siya,’ et adi kayo kadi patpatiyen. ");
INSERT INTO xnn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tay awnit wadada nan mangwani en daida kano si Kristo ya nan tap-ina et kananda en mamadton Apo Dios kano daida. Et awnit omipailada is kaskasdaaw ay kabaelanda tapno men-allilawda pati nan pinilin Apo Dios ay ipogawna no mabalin. ");
INSERT INTO xnn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ipaon-onak ay mangibaga ken dakayo isnan naayda tapno nenemnemenyo ta adi kayo maal-allilaw. ");
INSERT INTO xnn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Isonga no kananda en, ‘Ilam, wada si Kristo isnan bilig,’ dakayot adi kadi om-omey isdi. Ya no kananda en, ‘Wada isna ay mentatabon,’ dayot adi kadi patpatiyen. ");
INSERT INTO xnn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tay isnan omaliyak kasin ay Iyon-an Am-in di Ipogaw et kaneg nan kimat ay menpangsilaw isnan daya. ");
INSERT INTO xnn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Awnit matongpal dana tay kaneg nan kananda en, ‘No intoy kad-an di natey ay egay naikaob et siya nan maponokan di koyat ta topekenda.’” ");
INSERT INTO xnn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Intoloy Jesus ay mangwani en, “Isnan makwasan san deey ay ligat et awnit bomolinget nan agew ya adiyet somilang nan bowan. Matekdag nan talaw ya maikiweg nan am-in ay wada id daya. ");
INSERT INTO xnn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Et siya na nan mailaan nan sinyal id daya ay somagongak. Et am-in nan ipogaw isnan batawa et pilmi nan egyatda ya men-agada isnan mang-ilaanda ken sak-en. Tay siya na nan lomayogak ay Iyon-an Am-in di Ipogaw ay maitatapi isnan liboo ay magapo id daya et somisilangak ay mangipaila isnan kangaton Apo Dios ya nan kabaelan ay wada ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Et wada nan tanggoyob ay napigsa daket ibaa nan aanghelko isnan am-in ay kad-an di ipogaw isnan batawa ta dagopenda am-in nan ipogaw ay pinilin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nemnemenyo nan kaiw ay higos tay wada nan masoloyo. No sombo nan tobona et getkenyo ay nganngani nan pinag-odan. ");
INSERT INTO xnn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kaneg abes no ilaenyo nan om-ommat isnan batawa ay kaneg san inbagak ken dakayo et getkenyo ay nganngani nan omaliyak. ");
INSERT INTO xnn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ibagak ken dakayo nan tet-ewa et ommat san inbagak esapay matey nan am-in ay ipogaw ay matatago id wani. ");
INSERT INTO xnn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Olay no mamaid nan batawa ya nan wada id daya ngem nan am-in ay kankanak et mawawada kayet ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Maid polos mangtek isnan osto ay agew ya olas ay ommat san inbagak. Olay nan aanghel et adida getken ya olay sak-en ay Anak Apo Dios et adiyak getken gedan nodi kedeng si Ama is mangtek. ");
INSERT INTO xnn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Din inik-ikkan nan ipogaw isdin timpon din si Noah et siya gedan nan ikkan nan ipogaw isnan awnitak omaliyan kasin. ");
INSERT INTO xnn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tay esapay mapsong nan batawa et maid egyatda nodi ginan-ganasda nan biyagda ay apedda mangmangan dadapay omin-inom ya men-as-asawa engganay sinonggep da Noah isnan bapor. ");
INSERT INTO xnn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Egayda ninemnemnem nan ommat ken daida engganay linmayos nan batawa et nalimonda am-in. Et awnit kaneg todi gedan nan ommat no somagongak. ");
INSERT INTO xnn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tay isnan deey ay timpo et no wada nan doway lalalaki isnan payewda et maala nan esa dapay mataynan nan esa. ");
INSERT INTO xnn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Et no wada nan doway babai ay menbaybayo et maala gedan nan esa dapay mataynan nan esa. ");
INSERT INTO xnn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Isonga mensasagana kayo ay kanayon tay adiyo getken nan osto ay agew ay omaliyan nan Apoyo. ");
INSERT INTO xnn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tay kaneg nan mangakew, no getken nan akinbaey nan osto ay olas ay omaliyana et adi polos kaseyep ta adi makasgep nan mangakew. ");
INSERT INTO xnn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Isonga dakayo abes et masapol ay kanayon ay mensasagana kayo tay maid mangtek no tongona nan omaliyak ay Iyon-an Am-in di Ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Dat menpangngalig si Jesus maipanggep nan somagongana isnan batawa et kanana en, “Nan matalek ya masilib ay baa et siya nan pinilin nan apona ay mangipangpango isnan iib-ana ay baa ta siya nan kigad ay mang-ited isnan kanenda. ");
INSERT INTO xnn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Men-gasing nan sanay baa isnan domatngan nan apona no inikkana nan inbilina. ");
INSERT INTO xnn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ibagak ken dakayo nan tet-ewa et gapo tay matalek siya et awnit siya nan mangitalkan nan apoda isnan am-in ay kowana. ");
INSERT INTO xnn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ngem nan adi katalek ay baa et nenemnemena ay waay madmadney nan somaaan nan apoda ");
INSERT INTO xnn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","isonga ngawi nan ikkana tay baigena nan ib-ana ay baa ya aped makikikan isnan ipogaw dapay menboteng. ");
INSERT INTO xnn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dat somaa nan apoda isnan agew ay adi getgetken san baana. ");
INSERT INTO xnn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Daet dosaen nan apoda siya et itapina siya isnan dosan nan aginsosolot ken Apo Dios isnan kad-an nan pilmi ay ligat. Et men-ag-ag-aga dapay men-oowakis isdi gapo isnan pilmi ay ligatna.” ");
INSERT INTO xnn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Dat itoloy Jesus et kanana en, “Iyaligko nan ikkan di nakasagana ya nan egay isnan somagongak. Kanegda nan simpoo ay bababassang ay mang-ala isnan silawda ta enda sab-aten nan lalaki ay makiasawa. ");
INSERT INTO xnn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nan lima et adida osalen nan nemnemda ngem nan lima et masilibda. ");
INSERT INTO xnn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","San lima ay egay nang-osal isnan nemnemda et inmeyda ay egayda inmaala is pondon di silawda. ");
INSERT INTO xnn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ngem san lima ay masilib et inmaalada is pondon di silawda. ");
INSERT INTO xnn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nalabiyan ay inmey san lalaki ay makiasawa isonga dadat mentom-e. ");
INSERT INTO xnn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tengan di labi esapay wada nan menbogaw ay mangwani en, ‘Naay omali nan makiasawa. Omaliyo sab-aten.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Isonga dat mabanangon san simpoo ay bababassang et isaganada nan silawda. ");
INSERT INTO xnn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dat kanan san limay maid pondoda isnan iib-ada ay masilib en, ‘Agtanyo kad dakami is tap-in nan igasyo tay matmatdok nan igas nan silawmi.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ngem sinmongbat san limay masilib en, ‘Adi kabalin tay adi omanay nan pondomi ken datako am-in. Omey kayo lomako isnan masapolyo.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dadat omey. Wadada isnan daan dapay omdan san sesed-enda. Dat makkey san limay nakasagana ay makikan dat maemban nan segpan. ");
INSERT INTO xnn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Maaw-awni pay dat domateng san limay en linmako is igas dadat menbogaw isnan segpan et kananda en, ‘Apo, songgep kami kad.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ngem sinmongbat san lalaki en, ‘Adi kayo, tay adiyak getgetken dakayo.’” ");
INSERT INTO xnn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Dat kanan Jesus isnan papasolotna en, “Isonga masapol ay mensasagana kayo tay adiyo getken nan agew ay omaliyak kasin.” ");
INSERT INTO xnn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Dat itoloy Jesus ay mangwani en, “Iyaligko kasin nan ommat isnan awnitak omaliyan. Kanegna nan inikkan nan kadangyan ay ninsagana isnan omayana isnan addawi ay ili. Esapay omey et inayagana nan kabaabaana ta ibagana nan ikkanda isnan gamengna. ");
INSERT INTO xnn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nan esang et inagtana is limay libo ay siping, nan maikadwa et doway libo ya nan maikatlo et sinlibo tay sigon isnan kabaelan di wasdin esa ken daida. Dat komaan san kadangyan. ");
INSERT INTO xnn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","San naagtan is limay libo et inigosyona ay dagos dat men-galansiya is limay libo abes. ");
INSERT INTO xnn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Siyang na gedan nan inikkan san naagtan is doway libo et doway libo abes nan galansiyana. ");
INSERT INTO xnn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ngem san naagtan is sinlibo et inkaobna san inalana ta igagona. ");
INSERT INTO xnn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nabayag pay dat somaa san apoda danat paayagan san deeyday baana ta sootena nan inikkanda issan siping. ");
INSERT INTO xnn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dat omey san naagtan is limay libo et kanana en, ‘Apo, inagtam sak-en is limay libo et naay gedan nan limay libo ay inyanakna.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Dat kanan san apoda, ‘Gawis nan inikkam. Tet-ewa ay matalekka ay baa. Gapo tay matalekka isnan atiatik et taptapiyak nan kalebbengam isnan ado ya makigasingka isnan gasingko.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dat omey abes san naagtan is doway libo et kanana en, ‘Apo, inagtam sak-en is doway libo et naay gedan nan doway libo ay inyanakna.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Dat kasin kanan san apoda, ‘Gawis nan inikkam. Tet-ewa ay matalekka abes ay baa. Gapo tay matalekka isnan atiatik et taptapiyak abes nan kalebbengam isnan ado ya makigasingka gedan isnan gasingko.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Dat abes omey san naagtan is sinlibo et kanana en, ‘Apo, getkek ay makedseka tay ap-apitem nan egaymo inis-ek dakapay men-galansiyaan nan egaymo ninligatan. ");
INSERT INTO xnn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Isonga daket ikaob nan sipingmo tay omegyatak ken sik-a et naay isagongko et ken sik-a nan sipingmo.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dat kanan san apoda en, ‘Ngawika is baa tay sadotka ay pilmi. Getkem ay ap-apitek nan egayko inis-ek ya men-galansiyaak nan egayko ninligatan. ");
INSERT INTO xnn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ayta damen egay ngalod inbangko tapno no somagongak damet isagong nan sipingko ya nan binisna?’ ");
INSERT INTO xnn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Danat kanan isnan tap-in di baana en, ‘Alaenyo san intedko ken siya ta itedyo issan baa ay nakasimpoo ay libo. ");
INSERT INTO xnn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tay nan matalek isnan naidya ken siya et mataptapiyan pay is ad-ado ngem nan adi katalek et olay nan atiatik ay wada ken siya et mamaid. ");
INSERT INTO xnn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nan naay pay maid silbina ay baa et itep-ayo isnan kad-an nan menbolinget et men-ag-ag-aga dapay men-oowakis isdi tay pilmi nan ligatna.’” ");
INSERT INTO xnn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Intoloy Jesus ay mangwani en, “Isnan omaliyak ay men-ali et mamakkey nan aanghel ta maila nan kangaton Apo Dios ken sak-en daket tomokdo isnan tokdowan di mentolay. ");
INSERT INTO xnn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dat madagop isnan sagangko nan am-in ay ipogaw isnan batawa. Daket mensiyanen daida ay kaneg nan ikkan nan menpaspastol ay mangisiyan isnan kalnilo isnan kalding. ");
INSERT INTO xnn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Daket ipaey nan ipogaw ay gawis nan ogalida isnan makanawanko ya nan ngawi nan ogalida et ipaeyko abes isnan makanigidko. ");
INSERT INTO xnn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Daket kanan isnan wada isnan makanawanko en, ‘Akayo tay dakayo nan binadangan Amak ta maitapi kayo isnan mentolayana ay naisasagana enggana isdin naboliwan di batawa. ");
INSERT INTO xnn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tay isdin naow-owatak ya naew-ewewak et nangpakpakan kayo ya nangpap-ainom kayo. Ya isnan inmay-ayak isdin il-iliyo et sangsangailiyak dayopay inayagan kayet sak-en isnan bab-aeyyo. ");
INSERT INTO xnn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Et isdin kamaid badok et nangbadbado kayo gedan ya nang-ay-ayowan kayo isdin nasaksakitak dakayo pay inmal-ali ay nangtoytoya isdin naibalbalodak.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Dat kanan san gawis nan ogalida ken sak-en en, ‘Tongona nan nang-ilaanmi ken sik-a ay maid kanem ya inomem dakamit pinakan ya pinainom sik-a? ");
INSERT INTO xnn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tongona nan nangsangailiyanmi ya nangbadowanmi ken sik-a? ");
INSERT INTO xnn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tongona nan nasakitam ya naibalodam dakamit omey ay makitoytoya ken sik-a?’ ");
INSERT INTO xnn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sak-en ay ali et awnitak kanan ken daida en, ‘Ibagak ken dakayo et tet-ewa ay olay no nan kababaan ay mamati ken sak-en nan nang-ikkananyo et kaneg sak-en gedan nan naikkanana.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Daket kanan abes isnan wada isnan makanigidko en, ‘Komaan kayo tay dakayo nan dosaen Apo Dios. Maitep-a kayo isnan apoy ay adi katkatey ay naisagana ken Satanas ya nan baana ay aanghel ay nangdokog ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tay isdin naow-owatak ya naew-ewewak et egay kayo nangpakpakan ya nangpap-ainom. ");
INSERT INTO xnn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Isdin sangsangailiyak et egay kayo nang-ayag dakayo pay egay nangbadbado isdin kamaid badok ya egay kayo nang-ay-ayowan isdin nasaksakitak ya naibalbalodak.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dadat kanan en, ‘Apo, tongona nan nang-ilaanmi ken sik-a ay naow-owat ya naew-ewew ya sangsangailika dakapay ninlalabos, nasaksakit ya naibalbalod damipay egay badangan sik-a?’ ");
INSERT INTO xnn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Daket kanan ken daida en, ‘Ibagak ken dakayo nan tet-ewa et isdin nang-adyanyo ay badangan nan kababaan ay mamati ken sak-en et kaneg sak-en nan inadyanyo.’ ");
INSERT INTO xnn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Isonga datona nan omey isnan dosa ay maid patenggana. Ngem nan gawis nan ogalida et matagotagoda ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kinwas Jesus ay mangibaga is dana isnan papasolotna danat kanan ken daida en, ");
INSERT INTO xnn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gegetkenyo ay isnan dowa ay agew et omdan et nan Fiestan di Linmaosan di Anghel. Isnan deey ay agew et sak-en ay Iyon-an Am-in di Ipogaw et maitedak ay mailansa isnan kros.” ");
INSERT INTO xnn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Isnan deey gedan ay timpo et naponok isnan baey Caifas ay kangatowan ay padi nan am-in ay menkangangato ay papadi ya menlelebbeng ay aamam-a ");
INSERT INTO xnn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta mentotyada isnan ikkanda ay mangdepap ay mangpatey ken Jesus ay maid mangtek is ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tay kananda en, “Adi mabalin ay ikkan tako na isnan timpon di fiesta modatya golowen nan ipogaw datako.” ");
INSERT INTO xnn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Issan kawad-an da Jesus id Betania isnan baey Simon ay inpagawisna nan kolitna ");
INSERT INTO xnn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","dadat mangan. Dat songgep nan esay babai ay nananggen isnan gawigawis ay palanggo ay kad-an di nangina ay bangbanglo danat ibokbok am-in isnan olon Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dat menkakaslat nan papasolotna et kananda en, “Ayyew pay na. Kawas nan bangbanglo. ");
INSERT INTO xnn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","No mailako koma adi di et ado nan bayadna ay maited isnan kodo.” ");
INSERT INTO xnn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngem getken Jesus nan kankananda danat kanan, “Bay-anyo siya tay gawigawis nan inikkana ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Olay ket wawawawada nan kodo ken dakayo ngem sak-en et adiyak mabayag ay makitetee ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nan nangibokbokana et isaganana nan awakko isnan maikaobak. ");
INSERT INTO xnn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Osto nan ibagak ken dakayo, olay no into nan maiwalasan nan gawis ay damag isnan batawa et maipagpagtek abes nan inikkana ta kanemnemnemana.” ");
INSERT INTO xnn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dat omey isnan menkangangato ay papadi si Judas Iscariote ay esa isnan simpoo ya dowa ay pasolot Jesus ");
INSERT INTO xnn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","danat kanan, “Kaat nan ilagboyo ken sak-en no itedko si Jesus ken dakayo?” Dadat bilangen nan tolompoo ay napateg ay pilak et itedda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ninlogi isdi dat mennemnemnem si Judas is gawis ay timpo is mangipadepapana ken Jesus is ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isnan omona ay agew nan Fiestan di Linmaosan di Anghel et siya nan mangkakananda is egay kabobodan ay tinapay ya siya gedan nan mangpaltiyanda is kalnilo ay kaneg din inikkan din alal-apoda ay Judio isdin nanglaosan di anghel isnan bab-aeyda id Egipto tapno adina itapi ay mangpatey ken daida. Inmey nan papasolot Jesus ay mangsoot ken siya en, “Into nan laydem ay enmi mangisaganaan isnan kanen tako is fiesta?” ");
INSERT INTO xnn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Dat kanan Jesus, “Omey kayo isnan esay am-ama id Jerusalem dakayot kanan ken siya en, ‘Kanan nan Apo tako en nganngani kano nan mateyana. Omali kano siya ya dakami ay papasolotna isnan baeymo ta isna nan mang-isdaanmi isnan kalnilo.’” ");
INSERT INTO xnn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dat omey nan papasolotna et ikkanda nan inbagana ken daida ay mangisagana isnan kanenda. ");
INSERT INTO xnn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nasdem pay dat menlikob da Jesus ya nan simpoo ya doway papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mangmanganda dat kanan Jesus ken daida, “Ibagak ken dakayo en awnit isipsip nan esa ken dakayo sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dadat madanagan ay pilmi dadapay men-asisoot en, “Ay sak-en ngen di mang-ikkan, Apo?” ");
INSERT INTO xnn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Dat kanan Jesus, “Maid teken is mang-ikkan nodi nan makisiwsiwsiw isnan kanena ken sak-en isnan malakong. ");
INSERT INTO xnn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sak-en ay Iyon-an Am-in di Ipogaw et tet-ewa ay awnitak matey tay siya nan naisolat id kasikasin ngem kaseseg-ang nan sanay awnit mangisipsip ken sak-en. Gepgepes et di egay kaiyanak siya.” ");
INSERT INTO xnn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dat kanan Judas Iscariote, “Apo, ay sak-en nan mang-ikkan is dana?” Dat kanan Jesus, “Sinoy teken nodi sik-a?” ");
INSERT INTO xnn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mangmanganda pay laeng dat omala si Jesus isnan tinapay et men-iyaman ken Apo Dios danat amam-asen et idyana isnan papasolotna. Danat kanan, “Alaenyo na ta kanenyo tay siya na nan awakko.” ");
INSERT INTO xnn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Danat abes alan nan inomenda dat men-iyaman ken Apo Dios. Danat idya isnan papasolotna danapay kanan, “Ominom kayo am-in. ");
INSERT INTO xnn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tay siya na nan basak ay mangipaila isnan balo ay nakitolagan Apo Dios isnan ipogaw. Ipailana nan men-ayosan nan basak ay mang-owas isnan basbasol nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Et ibagak ken dakayo en adiyak kasin omin-inom is basi engganay kasin tako menkakadwa ay ominom isnan balo ay basi isnan mentolayan Amak id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dadat menkanta ay mangdayaw ken Apo Dios dadat bomala et omeyda isnan bilig ay Olivo. ");
INSERT INTO xnn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Isnan omay-ayanda dat kanan Jesus ken daida en, “Isnan labi met laeng ay naay et awnit lomayaw kayo am-in ay mangtaynan ken sak-en. Et siya nan matongpalan nan naisolat isnan kalin Apo Dios ay mangwani en, ‘Awnitko pateyen nan mang-ay-ayowan isnan kakalnilo et maiwakatda am-in.’” ");
INSERT INTO xnn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dat itoloy Jesus ay mangwani, “Ngem isnan matagowak et awnitak omon-ona id Galilea daket sesed-en dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dat kanan Pedro ken Jesus en, “Olay no lomayaw am-in nan iib-ak et adiyak kayet taytaynan sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Dat kanan Jesus, “Ngem ibagak ken sik-a, esapay mentan-o nan manok is wakgat et mamitlo ay mangisotka en adika mangtek.” ");
INSERT INTO xnn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dat kayet kanan Pedro, “Adi polos mabalin ay awnitak ikkan sa tay olay no maitapiyak ken sik-a ay matey.” Et paliso nan kinwanin nan am-in ay papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dat omey si Jesus ya nan papasolotna id Getsemani. Danat kanan ken daida en, “Sosom-ed kayo isna ta omeyak menlowalo isnan gaygay-edna issa.” ");
INSERT INTO xnn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inkawitna si Pedro ya nan sin-agi ay an-ak Zebedeo. Dat liknaen Jesus nan pilmi ay seg-ang isnan nemnemna gapo isnan awnit ommat ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Danat kanan ken daida en, “Pilmi nan seg-ang nan nemnemko et nganngani ay omisokba. Mentee kayo isna ta mangkakadwa kayo.” ");
INSERT INTO xnn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Inaddawiyana bassit daida dat menlokbob et menlowalo ay mangwani en, “Ama, no mabalin et kaanem koma nan naay ligatko. Ngem baken kadi nan laydek is matongpal nodi nan laydem.” ");
INSERT INTO xnn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dat somagong isnan kad-an san tolo ay ib-ana danat ilan daida ay naseseyep. Danat gidowen si Pedro et kanana en, “Dakan adi makaitpe obpay ay makilowalo is olay esa ay olas? ");
INSERT INTO xnn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Makailanyo ay gawis ya menlowalo kayo tapno adi kayo kadolog ay menbasol tay kayat nan nemnemyo ay mang-ikkan isnan gawis ngem nan awakyo et nakapsot.” ");
INSERT INTO xnn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dat kasin en menlowalo si Jesus ay mangwani en, “Ama, no masapol ay liliknaek nan mendagsen ay ligat ay naay et ikkak tapno maikkan am-in nan laydem.” ");
INSERT INTO xnn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Idi kasin mensagong isnan kad-an nan iib-ana danat ilan ay maseseyepda kasin tay adida makaitpe isnan seyepda. ");
INSERT INTO xnn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dat kasin taynan Jesus daida et omey menlowalo isnan maikatlo et paliso met laeng nan linowalona. ");
INSERT INTO xnn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Idi kasin mensagong danat ilan ay daanda ay maseseyep danat kanan, “Ay daan kayo pay laeng ay omiilleng ya maseseyep aya? Inomdan et nan maitedak ay Iyon-an Am-in di Ipogaw isnan managbasol. ");
INSERT INTO xnn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ibangonyo ta omey takot tay naay omal-ali nan mangisipsip ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Daan ay menkalkali si Jesus dat domateng si Judas ay esa isnan simpoo ya doway papasolotna. Inpangolona nan adoado ay iib-ana ay inbaan nan menkangangato ay papadi ya aamam-an di Judio ay nananggen isnan ispada ya pat-o. ");
INSERT INTO xnn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Esadapay omdan isnan kad-an da Jesus et inbagan Judas isnan iib-ana en, “Nan bisitowek et siya nan depapenyo.” ");
INSERT INTO xnn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Dat menneneknek si Judas ken Jesus et kanana en, “Apo,” danat bisitowen siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Dat kanan Jesus ken siya en, “Sigi, gayyem. Ikamom ay mang-ikkan isnan ikkam.” Dat depapen nan sosoldado si Jesus et ikaweda. ");
INSERT INTO xnn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dat asoten nan esay ib-an Jesus nan ispadana et menpingasana nan ingan nan esay baan nan kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ngem dat kanan Jesus ken siya en, “Isiklangmo nan ispadam tay nan mang-os-osal isnan ispada et ispada met laeng nan mangpatey ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ay adiyo getken ay no mendawatak is badang et ipaalin Amak nan adoado ay aanghel? ");
INSERT INTO xnn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ngem no ikkak di et adi matongpal nan naisolat isnan kalin Apo Dios en ommat.” ");
INSERT INTO xnn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dat kanan Jesus isnan deeyda ay wada isdi en, “Aykeak pomatey ta men-aalmas kayo ay mangdepap ken sak-en? Kaageagew ay tomotokdowak ay men-is-isolo isnan Templon Apo Dios et egay kayo nangdepdepap. ");
INSERT INTO xnn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ngem masapol ay ommat dana tapno maikkan nan insolat nan mamadto isnan kalin Apo Dios.” Dat lomayaw am-in nan papasolotna et taynanda siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dadat eyey si Jesus isnan baey Caifas ay kangatowan ay padi ay nadadagopan nan men-is-isolo isnan linteg ya aamam-an di Judio. ");
INSERT INTO xnn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Omon-onod si Pedro ngem maiyaaddawi. Inomdanda pay isnan nangyanda ken Jesus dat makitokdo si Pedro isnan pantew ay kad-an di sosoldado tapno getkena nan ommat. ");
INSERT INTO xnn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dat men-anap nan menkangangato ay papadi ya nan aamam-an di Judio is ikkanda ay mangipabasol ken Jesus tapno waday gapo ay ipapateyda siya. ");
INSERT INTO xnn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ngem maid maanapanda olay no ado nan en mangpabpabasol ken siya. Dat omey nan dowa ay lalaki ");
INSERT INTO xnn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","et kananda, “Kinwanin nan naay ay ipogaw ay mabalin ay bakasena nan Templon Apo Dios danat kasin kano kewasen ay mangsaad isnan maikatlo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dat tomakdeg nan kangatowan ay padi et kanana ken Jesus, “Ay maid isongbatmo isnan kinwanin nan mangipabasbasol ay naayda ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ngem aped igiginek Jesus. Dat kasin kanan nan kangatowan ay padi, “Isapatam isnan ngadan nan natatago ay Dios ta ibagam no sik-a si Kristo ay Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Dat kanan Jesus, “Tet-ewa nan kinwanim. Ngem ibagak ken dakayo ay no makwas na et ilaenyo sak-en ay Iyon-an Am-in di Ipogaw ay tomotokdo isnan makanawan Apo Dios ay manakabalin ya maitaptapi isnan liboo ay magapo id daya.” ");
INSERT INTO xnn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Idi dinngen san kangatowan ay padi san kinwanin Jesus danat mensingat nan badona tay dadama nan ligetna danapay kanan, “Adi masapol pay laeng di mangpaneknek isnan basolna tay dinngeyo et ay apedna ipapangato nan awakna tay kankanana en siya nan Anak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngan nan kananyo?” Dadat kanan, “Nakabasol adi et masapol ay matey.” ");
INSERT INTO xnn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dadat tobbatobbaan dadapay tipatipaken nan angasna. Dat kanan san nangtipak ken siya, ");
INSERT INTO xnn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Sik-a ay Kristo kano. No tet-ewa ay mamadtoka, kadya ibagam no sino met laeng nan nangtipak ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Daan ay tomotokdo si Pedro isnan pantew dat somag-en nan esay babai ay baan di padi et kanana, “Esaka samet ay ib-an Jesus ay iGalilea.” ");
INSERT INTO xnn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ngem dat isot Pedro tay adoado nan ipogaw isdi et kanana, “Maid getkek isnan ibagbagam.” ");
INSERT INTO xnn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dat men-aton isnan malilingban. Dat abes ilaen nan esay babai ay baa danat kanan isnan lalalaki isdi en, “Ib-an Jesus sa ay iNazaret.” ");
INSERT INTO xnn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ngem kasin inisot Pedro et kanana en, “Isapatak ay adiyak getgetken si tosa.” ");
INSERT INTO xnn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Maaw-awni pay dat kanan nan deeyday tomatakdeg isdi ken Pedro en, “Tet-ewa ay ib-ana sik-a. Adi mabalin ay is-isotmo tay mamagtek isnan menkalkaliyam.” ");
INSERT INTO xnn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dat kanan Pedro en, “Dosaen Apo Dios sak-en no menkamkampotak. Tet-ewa ay adiyak getgetken nan lalaki ay sana.” Dat katanan-o nan manok. ");
INSERT INTO xnn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Dat nanemnem Pedro san inbagan Jesus en, “Esapay mentan-o nan manok et nangisotka is mamitlo.” Dat dadama nan babawin Pedro issan nangisotana ken Jesus dat bomala et men-ogaog. ");
INSERT INTO xnn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kawakgatana dat mentotya nan menkangangato ay papadi ya nan aamam-a no ngan nan ikkanda ay mangpatey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dadat galoten nan ledengna esadapay eyey ken Pilato ay gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dat si Judas ay nangisipsip ken Jesus et menbabawi isnan ngawi ay inikkana issan nangtekana ay pateyenda et si Jesus. Danat isagong nan tolompoo ay siping isnan menkangangato ay papadi ya nan aamam-a ");
INSERT INTO xnn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","danapay kanan, “Binmasolak tet-ewa tay insipsipko nan ipogaw ay maid basolna.” Ngem dadat kanan, “Ngan di ngotomi is inikkam. Kigadka adi.” ");
INSERT INTO xnn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dat men-ibkas Judas san siping isnan Templo dat komaan et omey mensakkey. ");
INSERT INTO xnn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dat piditen nan menkangangato ay papadi san siping et kananda en, “Iyadin nan linteg tako ay maitapi nan naay isnan siping di Templo tay naibayad isnan biyag di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dadat mentotya is mang-osalanda issan siping dadat lakowan nan om-an nan esay men-al-alamid is banga ta maikak-aoban nan matey ay baken Judio. ");
INSERT INTO xnn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Et nangadanan san deey ay om-a is om-a ay nabasaan enggana id wani tay nan siping ay inbayadda et bayad di biyag di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Siya na nan natongpalan din insolat din si Jeremias ay mamadton Apo Dios id sang-adom ay mangwani en, “Inalada nan tolompoo ay siping ay osto ay bayadna isnan panangkalkolon di Judio ");
INSERT INTO xnn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","dadat lakowan nan om-an di men-al-alamid is banga tay siya di nan kinwanin Apo Dios en awnit ommat.” ");
INSERT INTO xnn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Inyeyda si Jesus ken Pilato ay gobilnadol danat sooten ken siya en, “Ay sik-a nan alin di Judio?” Dat somongbat si Jesus et kanana en, “Osto nan kinwanim.” ");
INSERT INTO xnn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ngem olay no pabasbasolen nan menkangangato ay papadi ya nan aamam-a et egay sinmongsongbat. ");
INSERT INTO xnn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Isonga dat kanan Pilato en, “Ay adim dedengngen nan ipabasbasolda ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ngem egay sinmongsongbat si Jesus isnan adoado ay ipabasbasolda ken siya isonga am-amed nasdaaw san gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tinew-en ay Fiestan di Linmaosan di Anghel et wada nan ogalida ay omipalobos nan gobilnadol is esay balod ay piliyen nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Isnan deey ay timpo et wada nan kangadan is Jesus Barabas ay getgetken am-in nan ipogaw gapo isnan ngawi ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Isonga isnan nadagopan nan ipogaw dat sooten san gobilnadol en, “Sino nan kayatyo ay ipalobosko? Ay si Jesus Barabas wenno si Jesus ay makwani en Kristo?” ");
INSERT INTO xnn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ngem gegetkena ay nan nang-itedanda ken Jesus is ken siya et gapo isnan apalda isnan inik-ikkan Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Daan si Pilato isnan pagbistaan dat wada nan bilin asawana ay mangwani en, “Adika makidosdosa isnan lalaki ay maid basolna. Tay isnan iitawko id labi et napaligatak maipanggep ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ngem nan menkangangato ay papadi ya nan aamam-a et dinologda nan kaipoipogaw ay mendawat ken Pilato ta si Barabas di palobosana dapay maipapatey si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ngem dat kasin sooten Pilato ken daida, “Sino ken datona ay dowa nan kayatyo ay palobosak?” Dadat kanan en, “Si Barabas.” ");
INSERT INTO xnn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Dat kanan Pilato, “Ngan ngalod nan ikkak ken Jesus ay makwani en Kristo?” “Ipalansam isnan kros,” insongbatda. ");
INSERT INTO xnn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dat kasin kanan Pilato ken daida en, “Aytay? Ngan nan ngawi ay inikkana?” Dadat amed men-giyaw ay mangwani en, “Ipalansam isnan kros.” ");
INSERT INTO xnn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Gintek Pilato ay maid teken is mabalin ay ikkana modatya am-amed menngalawngaw nan ipogaw isonga dat omala is danom et menboo isnan sagangda danapay kanan, “Siya na nan ikkak tapno ipailak ay maid bibiyangko isnan maipapateyan nan naay ipogaw nodi dakayo nan kigad.” ");
INSERT INTO xnn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dadat ibobogaw ay mangwani en, “Olay tay dakami ya nan aap-omi nan manglikna no wada nan dosa isnan maipapateyana.” ");
INSERT INTO xnn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dat ipalobos Pilato si Barabas danapay ipabaig si Jesus danat ited isnan sosoldado ta ilansada isnan kros. ");
INSERT INTO xnn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dat isgep nan sosoldadon Pilato si Jesus isnan baey di gobilnadol et madagopda am-in ay sosoldado isdi. ");
INSERT INTO xnn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dadat kaanen nan badona et sokatanda is men-gadangdang ay kaneg nan badon di ali. ");
INSERT INTO xnn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dadat komawikaw is sibit et ipabedbedda ken siya. Dadat omipag-en is pao ay kaneg nan ikakkan di ali. Dadat menpalintomeng isnan sagangna ay mangsayot ken siya ay mangwani en, “Madayaw kano nan alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dadat tobbatobbaan siya dadapay alan nan pao ay ginegen-ana et ibaigda isnan toktokna. ");
INSERT INTO xnn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Idi nakwas nan mangsaysayotanda ken siya dadat kaanen nan men-gadangdang ay bado et ipabadoda kasin san sigod ay badona dadat eyey ay mangilansa isnan kros. ");
INSERT INTO xnn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Isnan omay-ayanda et sinab-atda nan esay lalaki ay si Simon ay iCirene dat ipapati nan sosoldado ay mangipaawit isnan kros Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dadat itoloy engganay inomdanda id Golgota ay makwani en ingit di toktok. ");
INSERT INTO xnn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dadat painomen si Jesus isnan basi ay natapiyan is menpait ay agas ay mangpaon-onina isnan mensakit. Pinadasna ngem adyana ay mang-inom. ");
INSERT INTO xnn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dadat ilansa siya isnan kros. Dat menbobonot nan sosoldado ay mangbingay isnan badona. ");
INSERT INTO xnn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nakwas pay di dadat tomokdo ay mangseed isnan kateyana. ");
INSERT INTO xnn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Inpaeyda isnan ngangatowen nan toktokna nan naisolat ay mangibaga isnan inpabasolda ken siya ay mangwani en, “Siya na si Jesus ay alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wada gedan nan doway mangakew ay inlansada isnan krosda isnan makanawan Jesus ya isnan makanigidna. ");
INSERT INTO xnn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nan lomal-aos et iwegwegda nan toktokda dadapay gilgilawen si Jesus ");
INSERT INTO xnn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ay mangmangwani en, “Sik-a nan nangwani en bakasem nan Templon Apo Dios esakapay kasin esten isnan maikatlo ay agew. No tet-ewa ay sik-a met laeng nan Anak Apo Dios kadya isalakanmo nan awakmo ta lomayogka isnan krosmo.” ");
INSERT INTO xnn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Paliso gedan nan ik-ikkan nan menkangangato ay papadi ya nan men-is-isolo isnan linteg ya nan aamam-an di Judio. ");
INSERT INTO xnn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kankananda en, “Insalakana kano nan tap-in di ipogaw ngem adi makaisalakan isnan awakna dapay siya kano nan alin di Judio. No lomayog siya isnan krosna id wani et mamati kami ay siya nan Kristo ay alin di Judio. ");
INSERT INTO xnn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Talkena si Apo Dios kano isonga ilaen tako kadya no kayten Apo Dios ay mangisalakan ken siya. Tay kinkinwanina en siya nan tet-ewa ay Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Olay nan mangakew ay nailalansa isnan krosda et maitaptapida gedan ay makisaysayot ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kag-aw ay tinmenga nan agew dat bomolinget nan batawa engganay inmalas tres isnan sedem. ");
INSERT INTO xnn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dat menbogaw si Jesus ay mangwani en, “Eli Eli lama sabaktani.” Nan kayatna ay kanan et, “Apo Dios ay Diosko, aytay damen taynan sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Et nan nangdedenge ay wada isdi et kananda en, “Kanegna ay-ayagan din si Elias.” ");
INSERT INTO xnn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dat ikakamon nan esa ay omala is galot et itab-awna isnan basi danat igalot isnan pao danat ipangato ken Jesus ta sopsopana koma. ");
INSERT INTO xnn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ngem kinwanin nan iib-ana en, “Awnika od ta ilaen tako no omali si Elias ay mangisalakan ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dat kasin menbogaw si Jesus dat maoyos nan leng-agna. ");
INSERT INTO xnn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Isnan Templo et nan menselelede ay koltina ay manglilingeb isnan nasantowan ay kowalto et aped mabisngat ay menlogi isnan ngato ay menpababa. Dapay menyegyeg et magpak nan dadadadakke ay bato. ");
INSERT INTO xnn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Dat malokatan nan lil-iyang ay naikaoban nan natnatey ay ipogaw Apo Dios et matagoda kasin ");
INSERT INTO xnn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","dadat taynan nan naikaobanda. Issan natagowan kasin Jesus dadat omey id Jerusalem et adoado nan ipogaw ay nang-ila ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nan kapitan ya nan sosoldadona ay mangbanbantay ken Jesus et liniknada nan yegyeg ya inilada nan am-in ay inommat dat dadama nan egyatda. Dadat kanan en, “Tet-ewa obpay ay Anak Apo Dios siya.” ");
INSERT INTO xnn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wadada gedan nan ado ay bababai isdi ngem egayda sinmag-en. Daida nan naknakkey ya nangbadbadang ken Jesus isdin nagapowana id Galilea. ");
INSERT INTO xnn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Et nan iib-ada et da Maria Magdalena ya si Maria ay inan da Santiago ken Jose ya nan asawan Zebedeo. ");
INSERT INTO xnn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nasdem pay dat omdan si Jose ay iyArimatea ay esay baknang ya pasolot Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dat omey ken Pilato ay mangdawat isnan awak Jesus. Dat ibilin Pilato ta itedda. ");
INSERT INTO xnn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dat omey si Jose ay mang-ala isnan awak Jesus et bongonena isnan balo ay galot. ");
INSERT INTO xnn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Danat eyey isnan nakakaongan ay bato ay egay kaos-osal. Nan bato ay naay et siya nan awnitna koma maikaoban no matey. Danat seyatan is dakkel ay bato nan segpana dat komaan. ");
INSERT INTO xnn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena ya nan ib-ana ay Maria et wadada isdi ay tomotokdo ay mangsasagang isnan segpana. ");
INSERT INTO xnn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kawakgatana ay Sabado et obayan di Judio dat omey nan menkangangato ay papadi ya nan Fariseo ken Pilato ");
INSERT INTO xnn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","et kananda, “Apo, ninemnemmi nan inbagan san deey managkampot esapay matey en isnan maikatlo ay agew et kasin matago kano. ");
INSERT INTO xnn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Isonga gawis no bomilinka is omey mangbantay isnan naikaobana enggana isnan maikatlo ay agew. Tay waay awnit omey nan papasolotna ay mang-ala isnan awakna dadat aped kanan en kasin natago. No siya na nan ommat et maam-amed nan komampotanda mo isdin damo.” ");
INSERT INTO xnn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Dat kanan Pilato, “Owen, ayaganyo ngalod nan sosoldado isdi ta bantayanda ay gawis.” ");
INSERT INTO xnn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Isonga dat omey nan menkangangato ay papadi ya nan aamam-a et estenda ay gawis san seyatna dadapay malkaan tapno getkenda no waday mangkaan isnan bato ay segpan dadat komaan dapay mataynan nan sosoldado ay menbantay. ");
INSERT INTO xnn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nakwas nan obayada ay Sabado dat omey da Maria Magdalena ya nan esay kangadan is Maria isnan naipay-an Jesus isnan wisngit di Domingo. ");
INSERT INTO xnn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dat menyegyeg is napigsa dat wada nan anghel Apo Dios ay nagapo id daya ay nang-olin isnan bato ay segpan danat tokdowan. ");
INSERT INTO xnn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mensilsilang nan angasna ya mapomapolaw nan badona. ");
INSERT INTO xnn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Issan nang-ilaan nan menbanbantay ken siya dadat menpayegpeg gapo isnan dadama ay egyatda dadat matomba ay kaneg natey. ");
INSERT INTO xnn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dat kanan san anghel isnan iinin-a id isdi en, “Adi kayo omegyat. Getkek ay an-anapenyo si Jesus ay nailansa isnan kros ");
INSERT INTO xnn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ngem maid siya isna tay kasin natago ay kaneg din inbagana ken dakayo. Akayo isna ta ilaenyo nan nangipopodanana. ");
INSERT INTO xnn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dakayot ikamo ay omey ay mangibaga isnan papasolotna en tet-ewa ay kasin natago si Jesus et inmon-ona et id Galilea et sayo ilaen id isdi. Adiyo kalkalingkingan nan inbagak ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dadat bomala ay dagos. Omeegyatda ngem wada abes nan gasingda. Dadat tomagtag ay omey mangibaga isnan papasolot Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ngem isnan mentagtagtaganda dat sab-aten Jesus daida et kanana en, “Menlamlamnin kayo.” Isnan nang-ilaanda ken siya dadat menpalintomeng ay dagos isnan sagangna ay mangdayaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dat kanan Jesus ken daida en, “Adi kayo omegyat. Enkayo ibaga isnan bebsatko ta omeyda id Galilea ta men-asiila kami id isdi.” ");
INSERT INTO xnn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Issan kinmaanan san iinin-a dapay abes omey nan tap-in di menbanbantay id Jerusalem ta ibagada isnan menkangangato ay papadi nan am-in ay inommat. ");
INSERT INTO xnn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Daet madagop nan menkangangato ay papadi ya nan aamam-a et mentotyada is ikkanda. Dadat agtan is siping san deeyda ay menbanbantay ");
INSERT INTO xnn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","et ibagada ken daida en, “Siya na nan kananyo isnan ipogaw, ‘Naseseyep kami dat omali nan papasolot Jesus isnan tengan di labi et alaenda nan awak Jesus.’ ");
INSERT INTO xnn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","No dengngen nan gobilnadol nan naay et kigad kami tay dakami nan mangtoya ken siya tapno maid dosayo.” ");
INSERT INTO xnn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dat alaen san menbanbantay san siping et tongpalenda nan naibilin ken daida. Isonga enggana id wani et siya nan maipagpagtek isnan Judio. ");
INSERT INTO xnn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Inmey nan simpoo ya esa ay papasolot Jesus id Galilea isnan esay bilig ay inbagan Jesus ay mangsab-atana ken daida. ");
INSERT INTO xnn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Issan nang-ilaanda ken siya dadat dayawen. Ngem nan tap-ina et kanegda adi mamati ay siya si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dat somag-en si Jesus ken daida et kanana, “Naited ken sak-en nan am-in ay kabaelan id daya ya isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Isonga omey kayo isnan kaipoipogaw isnan am-in ay il-ili isnan batawa ta isolowanyo daida tapno mamatida ken sak-en. Dakayot bonyagan daida isnan ngadan Ama ya is ken sak-en ay Anakna ya isnan Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Isolowanyo ay gawis daida tapno tongpalenda am-in nan inbagak ken dakayo. Ya adiyo kalkalingkingan ay wadaak ken dakayo ay eng-enggana.”");
INSERT INTO xnn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Naay nan gawis ay damag ay maipanggep ken Jesu Kristo ay Anak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nan logiyana et kaneg din insolat Isaias ay mamadton Apo Dios id sang-adom isnan nangwaniyan Apo Dios isnan Anakna en, “Wada nan ibaak ay omon-ona ay mangisagana isnan daanem isnan omayam. ");
INSERT INTO xnn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Et siya nan wada isnan bilbilig ay mangibogbogaw en isaganayo nan daanen nan Apo tako ay awnit omali. Pagawisenyo nan daan ay mendaanana.” ");
INSERT INTO xnn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Et natongpal di tay inmey si Juan isnan bilig ay nin-isolsolo ya ninbonbonyag. Kankanana, “Masapol ay dokoganyo nan basbasolyo dakayopay menpabonyag tay siya nan kailasinan nan ninbabawiyanyo tapno pakawanen Apo Dios dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dat omey nan adoado ay i Judea ya i Jerusalem ay mangdenge ken Juan. Dadat ibaga nan basbasolda tapno mapakawanda ken Apo Dios dadapay menpabonyag ken Juan isnan ginawang ay Jordan. ");
INSERT INTO xnn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nan badon Juan et inabe ay dotdot di camel ay badon di kodo ya kodil nan balikesna ya nan menkatagona et dodon ya dilo. ");
INSERT INTO xnn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Siya na nan kinwanina, “Wada nan wedweda mo sak-en ay omon-onod et gapo isnan kawedwedana et adiyak maibilang ay mangkaan isnan sapatosna. ");
INSERT INTO xnn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Danom nan ibonyagko ken dakayo. Ngem siya nan awnit mangibonyag ken dakayo isnan Ispirito Santo.” ");
INSERT INTO xnn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Issan menbonbonyagan Juan dat wada si Jesus ay nagapo id Nazaret ay ili isnan probinsiya ay Galilea ay omey menpabonyag ken siya isnan ginawang di Jordan. ");
INSERT INTO xnn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nakwas pay ay mabonyagan si Jesus dat domaka isnan danom et ilaena ay mapewak id daya dat lomayog nan Ispirito Santo ken siya ay kaneg kalapati. ");
INSERT INTO xnn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dat kanan Apo Dios, “Sik-a nan Anakko ay laylaydek. Men-galalasingak gapo ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Dat dagos ay ipangon nan Ispirito Santo si Jesus isnan bilig ay kad-an di ayawan dat mentetee isdi is epatpoo ay agew. Isnan kakad-ana isdi et pinadpadas Satanas ay mangdoldolog ken siya ngem egay patpatiyen Jesus siya. Wadada nan aanghel ay mangbadang ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Naibalod et si Juan dat omey si Jesus id Galilea ay mangibagbaga isnan gawis ay damag ay nagapo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kanana en, “Inomdan et nan osto ay timpo tay nganngani ay omali nan mentolayan Apo Dios. Isonga ibabawiyo nan basbasolyo ta patiyenyo nan ibagbagak ay gawis ay damag.” ");
INSERT INTO xnn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Issan mendad-aanan Jesus isnan benget di baybay id Galilea et inilana nan doway sin-agi ay da Simon ken Andres ay mensidsidok isnan baybay tay siya nan oblada. ");
INSERT INTO xnn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Dat kanan Jesus ken daida, “Akayo ta maitapi kayo ken sak-en. Ninsidsidok kayo is ikan ngem id wani isolok abes nan ikkanyo ay mensidok is ipogaw ta maitapida isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dadat taynan ay dagos nan sidokda et makkeyda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ginmaygay-edda dat ilaen Jesus da Santiago ken Juan ay an-ak Zebedeo ay mang-es-eset isnan sidokda isnan bangkada ");
INSERT INTO xnn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","dat ayagan Jesus daida dadat taynan da Zebedeo ya nan men-ob-oblaenda et makkeyda ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inmey da Jesus id Capernaum. Sinabado nan obayan di Judio isonga isnan Sabado dat omey da Jesus isnan sinagoga dat men-isolo siya. ");
INSERT INTO xnn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nasdaaw nan nangdenge isnan insolsolona tay naiitken mo nan insolsolon nan men-is-isolo isnan linteg dapay maila nan kabaelan Jesus isnan ikkana ay men-isolo. ");
INSERT INTO xnn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sinonggep isnan sinagoga nan am-ama ay kinapet di makedse ay anito dat menbogaw ");
INSERT INTO xnn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ay mangwani, “Jesus ay iNazaret, ay ngan di ngotom ken dakami? Ay dadaelem dakami? Getkek sik-a. Sik-a nan napateg ay inbaan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ngem dat kanan Jesus issan anito, “Igiginekmo. Taynam bawet si tosa.” ");
INSERT INTO xnn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dat menkedas san ipogaw dapay men-oowakis nan anito ay mangtayan ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nasdaaw nan nangiila dadapay men-asikwani, “Ay ngan ngen nan wada ken tosa? Ay balbalo sa is solsolo? Dan kabaelana ay mangbilin isnan anito et patiyenda?” ");
INSERT INTO xnn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dat masodsodok isnan kailiili id Galilea nan inik-ikkana ay kaskasdaaw. ");
INSERT INTO xnn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kinmaan da Jesus isnan sinagoga et makkey da Santiago ken Juan dadat omey am-in isnan baey da Simon ken Andres. ");
INSERT INTO xnn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nan katogangan Simon et inpopodana tay menpodpodot dadat ipagtek ay dagos ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dat sag-enen Jesus san in-ina et gen-ana nan ledengna ay mangpatokdo dat maganawis siya. Dat bomangon et pakanena daida. ");
INSERT INTO xnn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Isnan sedemna dat iyey nan kaipoipogaw nan am-in ay masaksakit ya nan deeyday kinapet di anito. ");
INSERT INTO xnn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nab-on nan am-in ay omili isnan pantew nan baey da Simon ");
INSERT INTO xnn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","dat pagawisen Jesus nan wada nan sakitda danapay pakaanen nan anito issan kinapetda. Inyadina pay nan komaliyan nan anito ta bakenda is mangipagtek ay siya nan nagapo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Isnan tan-o dat bomangon si Jesus et omey isnan bilig ay menlowalo. ");
INSERT INTO xnn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bomangon pay da Simon dadat ilaen ay maid si Jesus isonga dadat omey anapen siya. ");
INSERT INTO xnn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Das-anda pay dadat kanan ken siya, “An-anapen nan kaipoipogaw sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dat kanan Jesus, “Entako et isnan tap-in di ili ta men-isolowak abes isdi tay siya nan gapo ay inmaliyak.” ");
INSERT INTO xnn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Dadat omey isnan il-ili id Galilea et men-isolo si Jesus isnan kasinasinagoga danapay pakaanen nan kaanianito. ");
INSERT INTO xnn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dinmateng nan esay nakolit isnan kad-an Jesus dat menpalintomeng ay menseg-ang en, “Apo, getkek ay kabaelam ay mangkaan isnan sakitko no kayatmo.” ");
INSERT INTO xnn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Naseg-ang si Jesus danat gen-an siya danapay kanan, “Kayatko ay maagasanka.” ");
INSERT INTO xnn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dat dagos ay makaan nan kolitna. ");
INSERT INTO xnn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ngem esanapay papikaen siya et binilina omon-ona ");
INSERT INTO xnn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ay mangwani, “Adim ibagbaga nan inikkak ken sik-a. Basta idadawesmo ta enka menpaila isnan padi damet idya nan limosmo ay mapalti ay kaneg din inbilin Moses ta pangtekan nan ipogaw ay ginmawiska.” ");
INSERT INTO xnn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngem sinodokna kayet et naiwalagawag nan inommat ken siya. Siya et di nan gapo ay adi menlanoy nan songgepan Jesus isnan il-ili. Isonga isnan ilit nan inmay-ayana ngem in-inmey kayet nan ipogaw ken siya ay nagapo isnan kailiili. ");
INSERT INTO xnn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nallos nan kaat ay agew dat somagong da Jesus id Capernaum et nindinamag isnan ipogaw ay sinmaada. ");
INSERT INTO xnn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dat madagop nan kaipoipogaw engganay maid tean olay isnan segpan ya nan pantew. Dat isolon Jesus nan gawis ay damag ay maipanggep isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dat domateng nan epat ay nang-aatangay isnan lalaki ay napalalais. ");
INSERT INTO xnn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ngem adida makasag-en ken Jesus tay napno nan baey isonga dadat ikay-at isnan atep. Dadat lokawan nan babatogen Jesus et oy-oyenda nan abek ay nangipopodanana isnan sagang Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Getken Jesus ay talkenda siya isonga danat kanan issan napalalais en, “Gayyemko, napakawan et nan basolmo.” ");
INSERT INTO xnn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wadada isdi nan men-is-isolo isnan linteg Apo Dios ay mangnemnemnem en, ");
INSERT INTO xnn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sino pay na? Aytay dan iyiison tona nan awakna ken Apo Dios dapay kedkedeng si Apo Dios is makapakawan is basol?” ");
INSERT INTO xnn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngem getken Jesus nan nenemnemenda danat kanan, “Ngan nan apedyo nemnemnemen? ");
INSERT INTO xnn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ay ngan nan nalaklaka ay kanan, nan ‘Mapakawan nan basolmo’ wenno nan, ‘Ibangonmo. Alam nan dayonmo ta somaaka.’ ");
INSERT INTO xnn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ngem gapo tay adiyo patiyen et paneknekak ngalod ken dakayo ay wada nan kalebbengak isnan batawa ay mangpakawan is basol tay sak-en nan makwani en Iyon-an Am-in di Ipogaw.” Isonga danat kanan isnan napalalais en, ");
INSERT INTO xnn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ibangonmo. Alam nan dayonmo ta somaaka.” ");
INSERT INTO xnn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dat bomangon et alaena nan dayona daet bomala. Am-in san wada isdi ay nangiila et nasdaawda dadat daydayawen si Apo Dios ay mangmangwani, “Kedengna is nakail-an tako is makapabangon is napalalais.” ");
INSERT INTO xnn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Inmey kasin si Jesus isnan benget di baybay dat madagop nan ipogaw danat isolowan daida. ");
INSERT INTO xnn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Maaw-awni pay dat mendaan si Jesus et ilaena nan mensingsingil is bowis ay anak Alfeo ay si Levi ay mangitotokdo isnan kabaybayadan di bowis. Dat kanan Jesus ken siya en, “Omalika ta maitapika ken sak-en.” Daet tet-ewa omonod et maitapi ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Inmey da Jesus isnan baey da Levi ay makikan dat domateng nan ado ay ib-an Levi ay mensingsingil is bowis ya nan tap-in di managbasol ay makikan gedan tay ado nan inmon-onod ken Jesus ay kaneg datona. ");
INSERT INTO xnn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nan ib-an di Fariseo ay men-is-isolo isnan linteg et inilada si Jesus ay makikikan isnan mensingsingil is bowis ya isnan tap-in di managbasol. Dadat sooten isnan papasolot Jesus, “Dan makikikan nan apoyo isnan sanada ay mensos-owitik ay mensingsingil is bowis ya nan managbasol?” ");
INSERT INTO xnn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dinngen Jesus nan kankananda danat songbatan isnan pangngalig et kanana en, “Nan ipogaw ay maid sakitda et adida masapol nan doktol ngem nan ipogaw ay mensakit et daida nan makasapol isnan doktol. Isonga inmaliyak isnan batawa tapno badangak nan mangtek ay nakabasolda ngem baken nan mangnenemnem en gawisda.” ");
INSERT INTO xnn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Isnan namingsan et nintepe nan papasolot Juan ay Menbonbonyag ya nan papasolot nan Fariseo tay menngilinda. Dat wada nan omey ken Jesus ay mangsoot, “Dan dakami ya nan Fariseo et mentepe kami dapay nan papasolotmo et adida menteptepe?” ");
INSERT INTO xnn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Dat menpangngalig si Jesus ta ilawlawagna nan gapo ay adi menteptepe nan papasolotna. Et kanana, “Ay kananyo en adi makikan nan nadkat no daan nan nadawak ken daida? Adi mabalin tay adi mentepe nan nadkat no daan nan nadawak ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngem no omdan nan agew ay maapitan nan lalaki ay nadawak et siya di nan mentepeanda gapo isnan seg-angda.” ");
INSERT INTO xnn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Intoloy Jesus ay mensodok ta ipagtekna ken daida en adi kabalin ay maitapi nan nabayag ay sinoloda isnan isolsolona. Kanana, “Maid mangitakop is balo ay galot isnan logak ay bado tay no malabaan dat komsen nan takop et am-amed mabisngat nan natakopan. ");
INSERT INTO xnn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Siya gedan isnan tapey. Maid mang-igwa is kabobobod ay tapey isnan naosal ay kodil tay epdas kinmenteg dapay no menlowag nan tapey et bomtak nan kodil et makawas nan tapey ya nan kodil gedan. Nan balo ay tapey et masapol ay maigwa isnan balo abes ay kodil tay mabinbinat et maid makawas.” ");
INSERT INTO xnn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Issan esay Sabado ay obayan di Judio et indaan da Jesus isnan paypayewan dat menlosing nan papasolotna is kotimenda. ");
INSERT INTO xnn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dat kanan nan Fariseo ken Jesus en, “Ilam pod nan ik-ikkan nan papasolotmo. Dadan menlosing is kotimenda dapay law-en nan linteg tako nan men-ani isnan obaya?” ");
INSERT INTO xnn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dat kanan Jesus, “Aytay dayon pabasolen daida? Ay egayyo polos binasa nan inikkan da David isdin linmayawanda isdin timpon padi Abiatar? ");
INSERT INTO xnn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Naowaowatda isonga dadat songgep isnan baey Apo Dios dat alaen David nan tinapay ay pala ken Apo Dios danat kanen danapay agtan nan iib-ana. Dapay kanan nan linteg tako en adi mabalin ay maipakan nan tinapay ay pala ken Apo Dios isnan ipogaw no bakenda padi. Ngem gapo tay naowatda et egay pabasolen Apo Dios daida.” ");
INSERT INTO xnn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Danat itoloy ay mangwani, “Egay aped boliwen Apo Dios nan ipogaw ta matongtongpal nan obaya nodi sinapona nan obaya pala isnan ipogaw ta waday omillenganda. ");
INSERT INTO xnn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Et sak-en ay Iyon-an Am-in di Ipogaw nan kalebbeng isnan mabalin ay maik-ikkan isnan obaya.” ");
INSERT INTO xnn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kasin inmey si Jesus isnan sinagoga danat ilan nan nabingoy ay am-ama. ");
INSERT INTO xnn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wada isdi nan mangkayat ay mangidalom ken Jesus isonga sis-iimenda siya mo agasana san nabingoy tapno pabasolenda siya tay law-enda nan men-obla isnan obaya ay olay nan men-agas. ");
INSERT INTO xnn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dat kanan Jesus issan nabingoy, “Omalika isna.” ");
INSERT INTO xnn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Danat sooten isnan deeyday ipogaw, “Ngan nan linteg tako isnan obaya? Ay ikkan nan gawis wenno nan ngawi? Ay ayyewan nan biyag wenno kawasen?” Ngem apedda igiginek. ");
INSERT INTO xnn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Dat mainge si Jesus isnan nang-il-ana ay maid somongbat ken daida tay ikekedseda ngem seg-angana met laeng daida. Danat kanan isnan nabingoy, “Oyadem nan ledengmo.” Inoyadna dat maoyad tet-ewa tay naagasan et. ");
INSERT INTO xnn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dat komaan nan Fariseo et enda makitoya isnan papasolot Ali Herod mo ngan nan ikkanda ay mangpatey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kinmaan da Jesus ya nan papasolotna isdi dadat omey isnan benget di baybay. Et inmonod ken daida nan adoado ay i Galilea ya i Judea. ");
INSERT INTO xnn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Adoda ay i Jerusalem ya iyIdumea. Wada pay nan nagapo isnan bas-ang nan ginawang ay Jordan ya nan i Tiro ya i Sidon. Inmonodda tay didinngeda nan am-in ay inik-ikkan Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gapo tay adoado nan ipogaw et inbagan Jesus isnan papasolotna ta isaganada nan bangka isnan danom ay tomokdowana ta adi lipiten di kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tay inagasan Jesus nan adoado ay ipogaw isonga men-innipit nan mensaskit ay omey manggeen ken siya ta moke makaan nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Issan nang-il-an nan kinapet di anito ay ipogaw si Jesus dadat menpalintomeng ay mangibogbogaw en, “Sik-a nan Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ngem binilin Jesus nan deeyday anito ta adida ipagtek siya. ");
INSERT INTO xnn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Isnan namingsan et tinmikid si Jesus isnan bilig danat ayagan nan tap-in di ipogawna. Omeyda pay ");
INSERT INTO xnn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","danat piliyen nan simpoo ya dowa ay nginadnana is apostolis. Danat kanan, “Pinilik dakayo ay makitee ken sak-en. Awnitak bab-aaen dakayo ta enyo ibagbaga nan gawis ay damag ");
INSERT INTO xnn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dakpay idya ken dakayo nan kabaelan ay mangipakaan isnan anito.” ");
INSERT INTO xnn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Datona nan simpoo ya dowa ay pinilina. Si Simon ay nginadnan Jesus is Pedro, ");
INSERT INTO xnn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nan dowa ay an-ak Zebedeo ay da Santiago ken Juan ay nginadnan Jesus is Boanerges ay makwani en an-ak di kido ");
INSERT INTO xnn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ya si Andres, si Felipe, si Bartolome, si Mateo, si Tomas ya si Santiago ay anak Alfeo, si Tadeo ya si Simon ay mangisaksakit isnan ilida ");
INSERT INTO xnn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya si Judas Iscariote ay awnit mangisipsip ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nakwas di dat somaa da Jesus et madagop kasin nan ipogaw isonga maid wayada ay mangan. ");
INSERT INTO xnn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dinngen pay nan ag-ina ay adi mangmangan si Jesus dadat omey ayagan koma siya tay wada nan mangmangwani en naong-ong siya. ");
INSERT INTO xnn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wadada abes nan nagapo id Jerusalem ay men-is-isolo isnan linteg ay mangmangwani en, “Linoganan Satanas ay apon di dimonyo et siya nan nang-idya isnan kabaelana ay mangipakpakaan isnan anito.” ");
INSERT INTO xnn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Dat ayagan Jesus nan deeyday ipogaw dat men-apat ay mangwani, “Ayke sapeen Satanas nan awakna met laeng? ");
INSERT INTO xnn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iyalig tako isnan sinpangbon. No mensaspe nan sinpangbon et adi mentoloy nan om-ombonanda. ");
INSERT INTO xnn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaneg abes nan sinbaey ay no maid olnosda et mabokada. ");
INSERT INTO xnn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Isonga adi mabalin ay sapeen Satanas nan bab-aana tay getkena ay no isapena daida awnit mamaid nan tolayna.” ");
INSERT INTO xnn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dat itoloy Jesus ay mensodok ta ipagtekna en napigpigsa nan panakabalina mo si Satanas. Kanana, “Nan mangakew et adi mabalin ay songgep isnan baey nan napigsa ay ipogaw ay mang-ala isnan napateg ay kowana no adina omon-ona ogden siya tapno mabalin ay alaena nan kayatna. ");
INSERT INTO xnn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tet-ewa nan kanak ken dakayo, mabalin ay mapakawan am-in nan basbasol di ipogaw ken Apo Dios ya nan kankananda ay ngawi maipanggep ken siya ");
INSERT INTO xnn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ngem nan komalkali is ngawi maipanggep isnan Ispirito Santo et adi mabalin ay mapakawan ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Siya di nan songbat Jesus tay wada nan mangwani en nan kabaelana et baken nan Ispirito Santo is nang-idya nodi si Satanas. ");
INSERT INTO xnn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dat domateng da inan Jesus ya nan bebsatna. Wadada isnan pantew dadat ipaayag si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dat kanan nan ipogaw ay manglilikob ken siya, “Wada da inam ya nan bebsatmo isnan pantew ay mangpaay-ayag ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dat kanan Jesus, “Owen, ngem sinoda pay nan inak ya nan bebsatko?” ");
INSERT INTO xnn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Danat tamaangen nan deeyday tomotokdo danapay kanan, “Ilanyo, naayda nan kanegko ina ya bebsat ");
INSERT INTO xnn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","tay am-in nan mamati dadapay ikkan nan layden Apo Dios et kanegko gedan ina ya bebsat.” ");
INSERT INTO xnn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kasin nin-isolo si Jesus isnan benget di baybay daet madagop nan kaipoipogaw isonga tinmokdo si Jesus isnan bangka ay wada isnan danom dapay nan kaipoipogaw et wadada isnan benget di baybay. ");
INSERT INTO xnn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Adoado nan insolon Jesus isnan pangngalig. Dat men-isolo et kanana, ");
INSERT INTO xnn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dengngenyo pod. Wada nan am-ama ay en ninbonobon isnan om-a. ");
INSERT INTO xnn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Idi insapowakna nan bonobon dat maekdag nan tap-ina isnan daan dat topken nan koyat. ");
INSERT INTO xnn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nan tap-ina et naekdagda isnan kabatbatowan dadat dalas ay tomobo ");
INSERT INTO xnn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ngem idi naagewanda dadat maango tay nalabaw nan linmamotanda. ");
INSERT INTO xnn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nan tap-ina et naekdagda isnan ginsatan ay sibit dat solinen di sibit nan tinmobo et mateyda isonga egayda bomgas. ");
INSERT INTO xnn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nan tap-ina et naekdagda isnan gawis ay lota dadat tomobo dadapay menliliton et bomgasda am-in. Wada nan binomgas is sin-gagsot, nan tap-ina et sag-eenempoo ya nan tap-ina et sagtotlompoo. ");
INSERT INTO xnn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dakayo ay mangdedenge isnan sodokko et dengngenyo no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kinmaan nan adoado ay ipogaw dapay san deeyda ay simpoo ya dowa ay papasolot Jesus ya nan tap-in di ipogaw ay nabay-an et inpootda ken Jesus no ngan nan kayat ay kanan nan sinodokna. ");
INSERT INTO xnn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dat kanan Jesus, “Owen, naipagtek ken dakayo nan egay naipagtek id kasin ay maipanggep isnan mentolayan Apo Dios. Ngem isnan tap-ina et pangngalig nan ik-ikkak ay mangisolo ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Isonga iilanda ngem adida getken nan tet-ewa ya dedengngenda ngem adida maawatan tay adyanda ay somagong ken Apo Dios ta mapakawan nan basolda.” ");
INSERT INTO xnn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Danat sooten ken daida, “Ay adiyo es maawatan nan naay sinodokko? Into pay ngalod esayo ikkan ay mang-awat isnan tap-in di sodsodok? Nan kanan nan sinodokko et siya na. ");
INSERT INTO xnn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nan kalin Apo Dios et siya nan inbonobona. ");
INSERT INTO xnn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nan daan ay natekdagan di bonobon et siya nan kaneg nan ipogaw ay mamannge isnan kalin Apo Dios dat omey si Satanas et kaanena isnan nemnemna san dinngena tapno adina patiyen. ");
INSERT INTO xnn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nan kabatbatowan et kanegna nan mangdenge ya men-gasgasing ay mangdawat isnan kalin Apo Dios ");
INSERT INTO xnn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ngem adi lomamot isnan nemnemna isonga patiyena is sin-awyan danat dokogan ay dagos no mapaligatan gapo isnan pammatina. ");
INSERT INTO xnn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nan ginsatan ay sibit et kanegna nan mangdenge isnan kalin Apo Dios ");
INSERT INTO xnn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ngem makolkol nan nemnemna tay wedweda nan bomaknangana ya nan men-gasgasingana is nenemnemena dapay omanap kayet is tap-in di mangipagasing ken siya. Isonga adi bomgas tay nasolin nan kalin Apo Dios et kalingkingana. ");
INSERT INTO xnn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ngem nan gawis ay lota ay natekdagan di bonobon et kanegna nan ipogaw ay mangdedenge isnan kalin Apo Dios danat is-ek ay gawis isnan nemnemna danapay itoltoloy ay mangpatpati engganay bomgas isonga nan kaad-adon nan gawis ay ik-ikkana et siya nan kaneg nan begasna.” ");
INSERT INTO xnn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Dat itoloy Jesus ay mangwani, “No pasgedan tako nan silaw, ayke tako ippey isnan timba wenno isnan silok di kama? Ipatang tako adi tapno makasilaw. ");
INSERT INTO xnn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Siya abes nan kaneg nan epdas naikkan ay olay egay kagtek et awnit magtek met laeng. ");
INSERT INTO xnn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dakayo ay mangdedenge, dengngenyo ngalod no waday ingayo. ");
INSERT INTO xnn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Masapol ay ikkanyo nan dinngeyo tay no siya nan ikkanyo et am-amed mataptapiyan nan panang-awatyo isnan dengdengngenyo. ");
INSERT INTO xnn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tay nan mamati isnan isolsolok ta maawatana et taptapiyan Apo Dios nan getkena. Ngem nan adi mangidnge et olay nan atiatik ay getkena et mamaid.” ");
INSERT INTO xnn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kasin ninsodok si Jesus ay mangwani, “Nan ikkan nan mentolayan Apo Dios ay somika et kaneg nan ikkan di esek ay tomobo ay adi kagtek. ");
INSERT INTO xnn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tay no epdas inis-ek di ipogaw et kigad san esek ay tomobo tay olay no ngan di ik-ikkan san nin-esek ay maseyep wenno bomangon siya et tomobo kayet nan inis-ekna ay adi kagtek nan inikkana ay tinmobo. ");
INSERT INTO xnn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nan lota nan makigad isnan am-in ay tomobo. Bomgi nan esek dat tomobo dat maliton dat bomgas. ");
INSERT INTO xnn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mo pay mensedang dat kanan nan nin-esek, ‘Entako men-ani.’” ");
INSERT INTO xnn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Dat itoloy Jesus ay mangwani, “Naay nan kaiyaligan nan kaneg nan mentolayan Apo Dios ya nan adoado ay awnit maitapi ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nan kanegna et nan kateteenan ay bowa. ");
INSERT INTO xnn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ngem no nais-ek dat tomobo et siya nan kadakkelan ay kaiw isonga malilinongan nan bomaey ay koyat.” ");
INSERT INTO xnn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Adoado nan kaneg tona ay sinodsodok Jesus isnan ipogaw maipanggep isnan kalin Apo Dios. Insolona isnan getkena ay mabalin ay maawatanda. ");
INSERT INTO xnn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Maid polos nin-isolowana ay egay ninpangngalig. Ngem no makekedengda isnan papasolotna danat ikwani am-in nan kayatna ay kaliyen ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nagisbet pay dat kanan Jesus isnan papasolotna, “Entakot isnan bas-ang nan baybay.” ");
INSERT INTO xnn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dadat taynan nan adoado ay ipogaw et menloganda issan bangka ay nintotokdowan Jesus et omeyda am-in. Wada gedan nan tap-in di bangka ay nangboboweg ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dat domateng nan napigsa ay dagem dat menkeyasaw nan danom et maisepyat isnan bangka et nganngani ay malimonda. ");
INSERT INTO xnn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dapay maseseyep kayet si Jesus isnan solin di bangka ay ninpopongan. Dadat bangonen ay mangwani, “Apo, ay maseseyepka kayet dapay naay malimon tako?” ");
INSERT INTO xnn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dat bomangon si Jesus et bilinena nan dagem ya danom ay mangwani, “Ikin-eyo.” Dat ikin-en nan dagem dapay omneng nan danom. ");
INSERT INTO xnn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Danat kanan isnan papasolotna, “Dakayon omegyat? Atiatik obpay nan talekyo ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nasdanasdaawda isnan inikkana dadat men-asikwani, “Manakabalin obpay si tona tay tongpalen nan dagem ya nan danom nan kanana.” ");
INSERT INTO xnn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Inomdan da Jesus isnan demang di baybay isnan lakon di Geraseno ");
INSERT INTO xnn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","et issan dinmakaanda isnan bangka dat sab-aten nan am-ama ay kinapet di anito. ");
INSERT INTO xnn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tawaw nan inidyada ken siya isonga nan lil-iyang ay kad-an di natey nan nintet-eeana. Maiwed makaikawe ken siya olay mo kawalanda. ");
INSERT INTO xnn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Namin ado ay binalbalodda nan ledengna ya nan sikina ngem apedna soksokpoten nan kawal di ledengna danapay engewen nan balod di sikina. Maiwed makaipakin-e ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inagew ya linabi ay menbogbogaw isnan liyang ya nan bilig dapay apedna tegtegtegen nan awakna is bato. ");
INSERT INTO xnn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Issan nang-il-ana ken Jesus et naiyaaddawi siya isonga dat tomagtag et en ninlokbob isnan sagang Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dat kanan Jesus, “Sik-a ay anito, taynam siya.” Dat menbogaw san am-ama, “Jesus ay Anak Apo Dios ay kangatowan, ay ngan di ngotom ken sak-en? Maseg-angka ta adika mangdosdosa.” ");
INSERT INTO xnn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dat sooten Jesus isnan anito, “Sino nan ngadanmo?” Dat kanan nan anito, “Nan ngadanko et Linibo tay adoado kami.” ");
INSERT INTO xnn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dat menseg-ang nan kaanianito ta adina palayawen daida isnan lakon di ili ay deey. ");
INSERT INTO xnn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Adoado ay beteg nan mangmangan isnan deey pondag ");
INSERT INTO xnn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","isonga dat kanan nan anito ken Jesus, “Ipalobosmo ta nan deeyday beteg nan kaptenmi.” ");
INSERT INTO xnn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dat ipalobos Jesus et taynanda san am-ama et kaptenda nan kabetebeteg. Dat kanega naong-ong san kabetebeteg et asida tatagtag ay omey isnan deppas dadat matekdag am-in isnan baybay et malimonda. Waay doway libo nan kabibilang san beteg ay natey. ");
INSERT INTO xnn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dat maboka nan menbanbantay isnan kabetebeteg dadat asitatagtag ay omey mangibaga isnan kailiili. Dat omey san deeyday nangdenge ta ilaenda mo ngan nan inommat. ");
INSERT INTO xnn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dadat datngan da Jesus dadapay ilaen san am-ama ay kinapet di anito ay ninbabado dadlo dapay ginmawis nan nemnemna. Dadat menkakikibtot. ");
INSERT INTO xnn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dat sodoken san nang-ila nan inommat isnan am-ama ya nan kabetebeteg ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dadat ipapati ay komaan da Jesus isnan ilida gapo isnan inommat. ");
INSERT INTO xnn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sinmagong pay da Jesus isnan bangkada dat menseg-ang nan am-ama ay kinapet di anito ken Jesus ta makkey koma ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ngem dat iyadin Jesus et kanana, “Somaaka bawet ta ibagam isnan agiyo nan gawis ay inikkan Apo Dios ya nan nangseg-angana ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dat somaa san am-ama et ipagtekna isnan lakon di Decapolis nan inikkan Jesus ken siya. Et nasdaaw am-in nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Issan nanggedangan da Jesus isnan baybay ay omey isnan demangna et nadagop nan adoado ay ipogaw isdi. ");
INSERT INTO xnn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Dat domateng nan am-ama ay kangadan is Jairo ay esay apon di sinagoga. Inmey ken Jesus dat menpalintomeng isnan sagangna ");
INSERT INTO xnn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","et menseg-ang ken siya en, “Apo, matmatey nan anakko. Omalika kad ta gen-am siya ta gomawis.” ");
INSERT INTO xnn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dat makkey si Jesus dapay omon-onod kayet nan kaipoipogaw ay mang-al-alibongbong ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wada gedan nan in-ina isdi ay egay somalsaldeng nan basana is simpoo ya doway tew-en. ");
INSERT INTO xnn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dadama ay naligatan isnan adoado ay nang-ag-agas ken siya et naamin nan kokwana dapay kayet adi kaagasan nan sakitna nodi ket aped masepsep. ");
INSERT INTO xnn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dinngena nan damag ay maipanggep ken Jesus isonga dat omey isnan dodokogan Jesus danat sikgaden nan badona. ");
INSERT INTO xnn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tay kanana isnan nemnemna en, “Olay no apedak sikgaden nan badona et gomawisak.” ");
INSERT INTO xnn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Idi sinikgadna nan badon Jesus dat masanaldeng nan basana danat liknaen ay nakaan nan sakitna. ");
INSERT INTO xnn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Dat liknaen abes Jesus ay wada nan pinagawis nan panakabalina danat sagongen nan kaipoipogaw et sootena, “Ay sino nan nangsikgad isnan badok?” ");
INSERT INTO xnn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dat kanan nan papasolotna, “Iilam ay kaipoipogaw nan mang-al-alibongbong ken sik-a. Damen kayet sooten mo sino nan nangsikgad isnan badom?” ");
INSERT INTO xnn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ngem nintamaang kayet ay mangimatmaton mo sino nan nangsikgad ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gintek san in-ina nan inommat isnan awakna dat omey ay menpaypayegpeg is egyatna. Dat menpalintomeng isnan sagang Jesus et ibagana nan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dat kanan Jesus ken siya, “Ina, ginmawiska gapo isnan pammatim ken sak-en. Somaaka ay menlamlamnin tay adi kasin somagsagong nan sakitmo.” ");
INSERT INTO xnn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Daan ay mentoytoya da Jesus issan in-ina dat domateng nan nagapo issan baey Jairo et kananda ken siya, “Somaa tako bawet Jairo, ta adim taktaken nan Apo tako.” Danat getken ay natey et san anakna. ");
INSERT INTO xnn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ngem dinngen Jesus san kinwanida danat kanan ken Jairo, “Adika menseseg-ang. No waday talekmo ken sak-en et awnit gomawis siya.” ");
INSERT INTO xnn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kedeng da Pedro ya nan sin-ag-i ay da Santiago ken Juan is pinakkeyna ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Idi inomdanda isnan baey Jairo dadat dengngen nan ngalawngaw ya nan agan di ado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dat songgep si Jesus et kanana ken daida, “Dakayon menngalawngaw ya men-ag-aga? Egay katey nan sana ay onga nodi aped maseseyep.” ");
INSERT INTO xnn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dadat sayoten siya isonga dat pabalaen Jesus daida danat ayagan san tolo ay papasolotna ya nan sin-asawa ay kaanak issan onga et omeyda isnan kad-an san onga. ");
INSERT INTO xnn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dat gen-an Jesus nan ledeng san onga danapay kanan isnan kalida, “Talita kom.” Nan kayatna ay kanan et, “Ibangonmo ay anakko.” ");
INSERT INTO xnn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dat mabanangon san babassang ay simpoo ya dowa nan tew-ena et mendaan. Dat masdamasdaaw nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Dat ipoot Jesus ken da amana ya nan inana ta adida ap-apaten isnan ipogaw danapay ibaga en pakanenda san onga. ");
INSERT INTO xnn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kinmaan da Jesus ya nan papasolotna isdi dadat somaa isnan ilina. ");
INSERT INTO xnn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Isnan Sabado dat men-isolo si Jesus isnan sinagoga et masdaaw nan adoado ay wada isdi ay nangdedenge dadat kanan, “Into nan aped nang-alaan tona isnan isolsolona? Into ngen nan inikkana ay nang-ala isnan silibna? Kaskasdaaw pay am-in nan ik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ay baken kad siya san alawagi ay anak Maria ya besat da Santiago, Jose, Judas ya si Simon? Wada pay nan bebsatna ay bababai id isna.” Isonga dadaet adi mamati ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dat kanan Jesus ken daida, “Am-in ay ipogaw et patpatgenda nan mamadto ay bakenda kailiyan ngem nan osto ay kailiyanda et adi patpatgen nan kakailiyana ya nan pangbona ya nan bebsatna.” ");
INSERT INTO xnn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gapo tay adida mamati ken siya et egay omipaila si Jesus is ado ay kaskasdaaw. Kedeng nan atiatik ay masasakit ay mamati ken siya is ginen-ana ta makaan nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nasdaaw si Jesus tay adi patiyen nan ipogaw siya. Inmey si Jesus isnan kailiili ay men-is-isolo ");
INSERT INTO xnn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","danat ayagan nan simpoo ya dowa ay papasolotna et ibaana daida ay sindodwa et inagtana daida is panakabalin ay mangipakaan is anito. ");
INSERT INTO xnn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Danat ibaga ken daida ta kedeng nan soksokodda is gegen-anda isnan menbaatanda. Adida mensengsenget, mensangsangi ya adida omikawkawit is siping ");
INSERT INTO xnn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ya adida omikawkawit is mensokatanda ya sapatos. ");
INSERT INTO xnn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kinwanina pay ken daida en, “No waday mangsangaili ken dakayo isnan baeyda dakayot adi men-at-aton engganay taynanyo nan ili ay deey. ");
INSERT INTO xnn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ngem no adida idnge dakayo isnan ili ay omayanyo dakayot komaan dayopay pokpoken nan tapok isnan dapanyo ta ipailayo ay adyanda nan isoloyo.” ");
INSERT INTO xnn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dat omey nan papasolotna ay mangibagbaga isnan ipogaw ta dokoganda nan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inpakaanda nan adoado ay anito dadapay lanaan nan wada nan sakitda ta pagawisenda daida. ");
INSERT INTO xnn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gintek et am-in nan ipogaw nan ik-ikkan Jesus tay nasodsodok isonga dinngen et Herod ay alin di Judio nan maipanggep ken Jesus. Wada nan nangwani, “Nan naay ipogaw et si Juan ay din ninbonbonyag ay kasin natago isonga mabalin ay ik-ikkana nan kaskasdaaw.” ");
INSERT INTO xnn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nan tap-in di ipogaw abes et kananda en siya si Elias ay kasin natago. Nan tap-ina et kananda en si Jesus et mamadton Apo Dios ay kaneg nan deeyda ay mamadto id kasin. ");
INSERT INTO xnn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngem isnan nangdedengngan Herod isnan inikkan Jesus danat kanan, “Nan ipogaw ay deey et si Juan ay pinapotok ay kasin natago.” ");
INSERT INTO xnn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kinwanin Herod di tay siya nan nangipabalod ken Juan id kasin tay iniyaw Juan siya isnan nang-asawaana isnan aydona ay si Herodias dapay daan nan asawana ay innodin Herod ay si Felipe. ");
INSERT INTO xnn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Isonga dat nakaliget si Herodias ken Juan et laydena ay ipapatey siya. Ngem adi mabalin ");
INSERT INTO xnn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tay iyegyat Herod od si Juan tay getkena ay gawis nan kaipogaw Juan isonga inbalbaliwana. Makokolkol nan nemnem Herod no dedengngena nan kankanan Juan ngem laydena kayet ay dengngen. ");
INSERT INTO xnn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dat omdan nan agew ay lagsakanda nan naiyanakan Herod danat paayagan am-in nan oopisyal ya nan ap-apon di soldado ya nan kakadangyan id Galilea. Et siya nan nawayaan Herodias ay mangipapatey ken Juan ");
INSERT INTO xnn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","tay dat songgep nan anak Herodias ay babassang ay mensala. Dat gomasing da Herod ya nan ib-ana isonga danat kanan isnan babassang, “Ngan nan laydem? Ibagam ta idyak ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dalos ninsapata ay mangwani, “Olay ngan di ibagam et idyak olay mo nan kagedwan di kinakadangyanko.” ");
INSERT INTO xnn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dat bomala nan babassang et sootena ken inana en, “Ay ngan di dawatek?” Dat kanan inana en, “Nan olon Juan ay Menbonbonyag nan dawatem.” ");
INSERT INTO xnn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dat ikakamon tet-ewa san babassang ay songgep et ibagana ken Herod en, “Laydek ay paiyalim nan olon Juan ay Menbonbonyag ay napapalato.” ");
INSERT INTO xnn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Menseseg-ang nan ali ngem gapo tay adoado nan nangdedenge isnan sapatana et mabain ay teknena nan kinwanina. ");
INSERT INTO xnn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Isonga dagos ay binaana nan esay soldado ta alana nan olon Juan. Dat omey et potowana nan olon Juan isnan pagbalodan. ");
INSERT INTO xnn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Danat ippey nan olo isnan palato et idyana isnan babassang danat es idya ken inana. ");
INSERT INTO xnn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Idi dinngen nan papasolot Juan nan inommat dadat omey alaen nan awakna et ikaobda. ");
INSERT INTO xnn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sinmagong nan papasolot Jesus ay binaana dadat ibaga am-in nan inik-ikkanda ya nan insolsoloda. ");
INSERT INTO xnn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dat kanan Jesus ken daida, “Ikekedeng tako ay omey isnan maid ipogaw ta omilleng kayo is sin-awyan.” Tay adoado nan om-omey isnan kad-anda et maid wayada is ikkanda ay mangan. ");
INSERT INTO xnn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dadat menlogan isnan bangka ta makekedengda koma isnan omayanda. ");
INSERT INTO xnn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ngem inmamatonan kayet nan ado ay ipogaw nan ninlologan isnan bangka isonga dadat tomagtag ay magapo isnan il-ilida et las-iyanda daida et omon-onada isnan omayan da Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Idi domaka da Jesus dadat ilaen nan kaipoipogaw dat maseg-ang ken daida tay kanegda kalnilo ay maid mang-ay-ayowan ken daida. Danat ilogi ay men-isolo et adoado nan insolsolona ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Masdem pay dat omey nan papasolotna ken siya ay mangwani, “Naay masdem datakopay wada kayet isnan pondag. ");
INSERT INTO xnn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ibagam et ken datona ta was-in omey isnan naisagsag-en ay il-ili ya isnan bab-aey isnan ilit ta enda lomako is kanenda.” ");
INSERT INTO xnn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ngem kinwanin Jesus ken daida, “Dakayo nan mangpakan ken daida.” Dadat sooten, “Ay enkami lomako is tinapay is pasal di dowanggasot ay ipakanmi ken daida?” ");
INSERT INTO xnn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Danat sooten ken daida, “Kaat nan tinapay ay wada ken dakayo? Kadya enkayo ilan.” Enda pay ilan dadat kanan, “Limlima ay tinapay ya dod-owa ay ikan nan wada et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Danat patokdowen nan kaipoipogaw isnan logam et malikobda. ");
INSERT INTO xnn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nalikob nan tap-ina is sin-gagsot ya nan tap-ina is sinlilmampoo. ");
INSERT INTO xnn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Dat alan Jesus san limay tinapay ya nan doway ikan dat mentangad id daya et men-iyaman ken Apo Dios. Danat amam-asen et idyana isnan papasolotna et iwatwatda. Danat es ipawatwat nan ikan ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dadat mangan am-in et nabsogda ");
INSERT INTO xnn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","dapay napno kayet nan simpoo ya doway lowa isnan tinogopda ay nabay-an ay tinapay ya ikan. ");
INSERT INTO xnn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Waay limay libo ay lalalaki san nangan isdi ay egay kaibilang nan oongong-a ya bababai. ");
INSERT INTO xnn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nakwas di dat ibagan Jesus isnan papasolotna ta menloganda isnan bangka ta omon-onada ay omey isnan demangna ay id Betsaida ta danapay es pasaaen nan ipogaw ay nadadagop isdi. ");
INSERT INTO xnn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nakapakadada pay ken siya dat omey si Jesus isnan bilig ta menlowalo. ");
INSERT INTO xnn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nalabi et dapay daan nan papasolotna isnan tengan di baybay ya si Jesus et daan es isnan bilig. ");
INSERT INTO xnn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dat ilan Jesus daida ay adida makaipadaan isnan bangka tay napigsa nan dagem. Natan-o pay dat mendaan si Jesus isnan danom ay mangsab-at ken daida. Laosana koma daida ");
INSERT INTO xnn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ngem inilada siya ay mendad-aan isnan danom dat palalo nan egyatda tay kananda en waay anito. Dadat kabanogaw ");
INSERT INTO xnn_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","is egyatda issan nang-il-anda am-in ken siya. Ngem dat komali si Jesus ken daida ay mangwani, “Laton, laton sa. Sak-en na. Adi kayo omegyat.” ");
INSERT INTO xnn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dat somakyat isnan bangka et kasanaldeng nan dagem. Dadat am-amed masdaaw ");
INSERT INTO xnn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tay adida maawatan nan kabaelan Jesus olay no inilada nan inikkana ay nangipaad-ado isnan tinapay tay adida makaipasnek ay gawis isnan nemnemda. ");
INSERT INTO xnn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nakagdangda pay et omdanda isnan dagan di Genesaret dadat ipad-an nan bangkada isnan lota isnan benget di baybay. ");
INSERT INTO xnn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Issan dinmakaanda dat inmatonan ay dagos nan ipogaw si Jesus ");
INSERT INTO xnn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","dadat asitatagtag isnan bab-aey ay kad-an di masakit ta dangeyenda daida ay mangyey isnan olay intoy getkenda ay kad-an Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Et olay mo into nan omayan Jesus ay dadakkel ay ili wenno baban-eg ya olay mo isnan bab-aey isnan ilit et inyeyda kayet nan masaksakit isnan malkitan di ili ay inmayana. Dadapay menseg-ang ken siya ta olay kedeng nan benget nan badona is sikgaden nan masaksakit daet am-in ay nangsikgad et ginmawisda. ");
INSERT INTO xnn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nakilikob ken Jesus nan deeyda Fariseo ya nan men-is-isolo isnan linteg ay nagapo id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dadat ilaen ay egay ninboo nan tap-in di papasolot Jesus esadapay mangan ay kaneg nan ogalin di Judio. ");
INSERT INTO xnn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tay nan Fariseo ya nan tap-in di Judio et adida mangan no adida menboo omon-ona ta makaan nan lawada tay siya nan ogalin din alal-apoda. ");
INSERT INTO xnn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nan esa pay et adida kanen nan minalkitanda engganay owasanda omon-ona. Et wada pay nan nateketeken ay ogalida isnan mang-owasanda isnan tasa ya nan banga ya nan kandiloda. ");
INSERT INTO xnn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Isonga san deeyda ay Fariseo ya nan men-is-isolo isnan linteg et kinwanida ken Jesus en, “Dan adi tongpalen nan papasolotmo nan ogalin di alal-apo tako? Tay manganda dapay adida menboo omon-ona dapay lawa.” ");
INSERT INTO xnn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Dat kanan Jesus ken daida, “Tet-ewa nan kalin Apo Dios ay maipanggep ken dakayo ay aginsosolot ken siya isnan inpasolatna ken Isaias id sang-adom ay mangwani en, ‘Nan naayda ay ipogaw et daydayawenda sak-en isnan kalida ngem addaaddawi nan nemnemda ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Maid kapaayan nan mangdaydayawanda ken sak-en tay nan isolsoloda et nan aped bilin di ipogaw dadat aped kankanan en siya nan lintegko.’ ");
INSERT INTO xnn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Et tet-ewa ay ik-ikkanyo nan insolat Isaias ay naay tay baybay-anyo nan linteg Apo Dios tapno tongpalenyo nan isolon nan aped ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Danat itoloy ay mangwani, “Ipipinoyo ay mangisiksikap isnan kaadyan nan linteg Apo Dios ta nan ogaliyo nan ik-ikkanyo. ");
INSERT INTO xnn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tay inbagan din si Moses isdin inpasolat Apo Dios ken siya en, ‘Masapol ay tongpalenyo da amayo ken inayo,’ ya kanana gedan en, ‘Nan komali is ngawi isnan amana wenno inana et maipapatey.’ ");
INSERT INTO xnn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ngem nan apedyo isolsolo et kananyo en mabalin ay alaen nan ipogaw nan ibadangna koma isnan amana ya inana dat menlason ken daida en, ‘Korban nan naay,’ et siya nan mangwaniyana en intedna et san inalana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","No siya di nan ikkana dayot tet-ewa itan-oy nan adina et mangbadangan ken da amana. ");
INSERT INTO xnn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Isnan mang-ik-ikkananyo is dana et dokdokoganyo nan linteg Apo Dios tay nan isolsolon di ipogaw nan apedyo tongtongpalen ya ado pay nan kaneg tona ay ik-ikkanyo.” ");
INSERT INTO xnn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kasin inayagan Jesus nan ipogaw danat kanan ken daida, “Am-in kayo et dengngenyo ta maawatanyo nan ibagak. ");
INSERT INTO xnn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Baken nan songgep isnan topek di ipogaw is mangipangawi ken siya nodi nan bomala isnan topekna. ");
INSERT INTO xnn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dakayo ay mangdedenge et dengngenyo no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dadat taynan nan ipogaw et songgepda isnan baey. Dat sooten nan papasolotna no ngan nan kayat ay kanan san kinwanina. ");
INSERT INTO xnn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Danat kanan, “Ay adiyo es maawatan? Ay adiyo getken ay baken nan songgep isnan topek di ipogaw is mangipangawi ken siya? ");
INSERT INTO xnn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tay nan makan et baken nan nemnemna is omayana nodi omey isnan egesna dat bomala kasin.” Isnan nangwaniyan Jesus isdi et siya nan mang-itdowana en maid lawa isnan makan. ");
INSERT INTO xnn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Danat itoloy ay mangwani, “Nan ngawi ay kali ay bomala isnan topek ya nan ngawi ay ikkana et siya nan mangipangawi isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tay nan nemnem di ipogaw nan magapgapowan nan am-in ay dakes ay ik-ikkana ay kaneg nan lomalaki ya nan mamabai, nan mangakew, nan pomapatey, nan makikamkamolala, ");
INSERT INTO xnn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nan men-ag-agom ya nan am-in ay natkenatken ay sokil. Magapo am-in dadi isnan nemnem. Wada abes nan men-al-allilaw, nan somisikap, nan men-ap-apal, nan men-ap-apos, nan men-et-etek ya nan adi mang-osal isnan nemnemna. ");
INSERT INTO xnn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Datona am-in nan ngawi ay ik-ikkan di ipogaw ay magapo isnan nemnemda et siya dana nan mangipangawi isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kinmaan si Jesus isdi dat omey isnan sakop di Tiro. Dat songgep isnan esay baey tay adina layden ay waday mangtek isnan kad-ana tasiyay makailleng ngem adi kabalin ay men-gago. ");
INSERT INTO xnn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wada nan esay in-ina isdi ay kinapet di anito nan anakna ay babai. Issan nangdengngana ay wada si Jesus isdi dat omey menpalintomeng isnan sagangna. ");
INSERT INTO xnn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Baken Judio san in-ina tay id Fenisia id Siria nan ilina ngem ninseg-ang kayet ken Jesus ta pagawisena nan anakna. ");
INSERT INTO xnn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ngem dat kanan Jesus, “Masapol ay mangan nan an-ak omon-ona tay baken osto no maipakan nan kanen di an-ak isnan aso.” ");
INSERT INTO xnn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naawatan nan in-ina nan kinwanina ay masapol ay badangana nan Judio esanapay badangan nan tap-in di ipogaw isonga danat kanan, “Owen Apo, ngem olay nan aso et kanenda nan kamogay nan an-ak.” ");
INSERT INTO xnn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dat kanan Jesus, “Osto nan insongbatmo. Somaaka tay kinmaan nan anito et ginmawis nan anakmo.” ");
INSERT INTO xnn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dat somaa nan in-ina et datngana nan anakna ay maseseyep isnan kama tay tet-ewa ay tinaynan nan anito. ");
INSERT INTO xnn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tinaynan Jesus id Tiro danat laosan id Sidon ya id Decapolis et omey kasin isnan baybay id Galilea. ");
INSERT INTO xnn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dat wadada nan mangyey isnan am-ama ay awew dadat menseg-ang ken Jesus ta gen-ana siya. ");
INSERT INTO xnn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Dat ayagan Jesus san awew et omeyda ay dowa isnan kamaid ipogaw. Dat pay-en Jesus nan gomotna isnan ingan san am-ama dat mentobba danat kapposen nan dilan san am-ama. ");
INSERT INTO xnn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dat mentangad id daya et menpog-es danapay kanan isnan kalida, “Eppata.” Nan kayatna ay kanan et makadngeka. ");
INSERT INTO xnn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dat tet-ewa makadnge ya makadiladil dapay domawes nan menkaliyana. ");
INSERT INTO xnn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dat ibilin Jesus ta adida sodsodoken nan inommat. Ngem am-amedda sodsodoken nan inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nasdanasdaaw san nangdedenge dadat kanan, “Ay-ay. Gawigawis am-in nan ik-ikkana. Olay nan natoweng et makadngeda ya nan omel et makakalida.” ");
INSERT INTO xnn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Isnan namingsan ay agew et kasin nadagop nan adoado ay ipogaw ken Jesus dat naamin nan kanenda. Dat ayagan Jesus nan papasolotna et kanana ken daida, ");
INSERT INTO xnn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maseg-angak isnan ipogaw ay naayda tay tolo ay agewda isna dapay naamin et nan baonda. ");
INSERT INTO xnn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","No ipasaak daida dadapay egay nangan et waay maolawda is owatda isnan daan dapay addaaddawi nan saaen nan tap-ina.” ");
INSERT INTO xnn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dat kanan nan papasolotna, “Into pay nan mang-al-an tako is makan isnan naay bilig?” ");
INSERT INTO xnn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dat kanan Jesus, “Kaat nan tinapay ay wada ken dakayo?” “Pitpito,” kinwanida. ");
INSERT INTO xnn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dat ipatokdon Jesus nan kaipoipogaw danat alaen san tinapay et men-iyaman ken Apo Dios danat amam-asen danat ipawatwat isnan papasolotna ta kanen san kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wada gedan nan nagabis ay baban-eg ay ikan. Dat men-iyaman ken Apo Dios danat ipawatwat es isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Waay epat ay libo nan kabibilangda ay nangan dadapay nabsog. Dadat togopen nan nabay-an et napno nan pito ay lowa. Danat pasaaen nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dat menlogan da Jesus isnan bangka et omeyda isnan sakop di Dalmanuta. ");
INSERT INTO xnn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Dinmateng nan Fariseo ay mensoot ken Jesus ta padpadasenda siya. Kananda en omipaila is kaskasdaaw ay mangipaila ay siya nan tet-ewa ay inbaan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ninpog-es si Jesus danat kanan, “Dan aped is kaskasdaaw nan dawdawaten nan ipogaw id wani ay timpo? Tet-ewa nan ibagak ay maid polos maipaila is kaskasdaaw ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dat taynan et da Jesus daida isdi dadapay kasin menlogan isnan bangka et omeyda isnan demangna. ");
INSERT INTO xnn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kinalingkingan nan papasolot Jesus ay omala is baonda et es-esa ay tinapay nan inkakawitda isnan bangka. ");
INSERT INTO xnn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Dat bagbagaan Jesus daida ay mangwani, “Makail-ilanyo nan bobod Herod ya nan deeyda ay Fariseo.” ");
INSERT INTO xnn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dat men-asikwani nan papasolotna en, “Waay kinwanina di tay kinalingkingan tako ay omala is baon.” ");
INSERT INTO xnn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gintek Jesus nan kankananda danat kanan, “Dayon aped ap-apaten nan kamaid di baonyo? Ay adi kayo kayet maawatan nan kabaelak? Ay maid maiyoloyo? ");
INSERT INTO xnn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wada nan iilanyo dayopay adi maimatonan. Wada nan dedengngenyo dayopay adi maawatan. Ay kinalingkinganyo ");
INSERT INTO xnn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","din limay tinapay ay inpaad-adok ta komdeng isdin limay libo ay ipogaw? Kaat ay lowa din nangtogopanyo isdin nabay-an?” “Simpoo ya dowa,” kinwanida. ");
INSERT INTO xnn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Din pay es pito ay tinapay ay inpaad-adok ta komdeng isdin epat ay libo ay ipogaw et kaat ay lowa din nabay-an isdi?” “Pito ay lowa,” kinwanida. ");
INSERT INTO xnn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Danat kanan, “Ay adiyo kayet maawatan ay baken makan nan kankanak nodi nan baken osto ay isolsolon di Fariseo?” ");
INSERT INTO xnn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Inmey da Jesus id Betsaida dat wada nan nangyey ken siya isnan kowap dadat menseg-ang ta kapposena nan matana ta makaila. ");
INSERT INTO xnn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Dat pedngen Jesus et ipangona isnan benget di ili. Dat tobbaan Jesus nan matana danat kapposen. Danat sooten, “Ay waday mailam?” ");
INSERT INTO xnn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Daet mentamaang san kowap danat kanan, “Wada. Iilak nan ipogaw ngem kanegda kaiw ay mendad-aan.” ");
INSERT INTO xnn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dat kasin kapposen Jesus nan matana. Dat menbotag san kowap et pinmat-a dadlo nan iilaena. ");
INSERT INTO xnn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dat pasaaen Jesus ay mangwani, “Somaaka ngem adika somagsagong isnan ili ay tinaynanta.” ");
INSERT INTO xnn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Inmey si Jesus ya nan papasolotna isnan kailiili id Cesarea Felipe. Issan nindad-aananda dat sooten Jesus en, “Ay ngan nan pangwanin nan ipogaw ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dadat kanan, “Wada nan mangwani en sik-a din si Juan ay Menbonbonyag. Nan tap-in di ipogaw et kananda en sik-a din si Elias dapay kanan nan tap-ina en sik-a nan esa isdin tap-in di mamadton Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dat sooten Jesus ken daida, “Dakayo pay abes, ay ngan nan pangwaniyo ken sak-en?” Dat kanan Pedro, “Sik-a si Kristo ay Anak Apo Dios ay inbagana en awnit omali ay men-apo.” ");
INSERT INTO xnn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dat bilinen Jesus daida ta adida ibagbaga isnan olay sino ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Inlogin Jesus ay men-isolo ken daida ay masapol ay mapaligatan siya ay Iyon-an Am-in di Ipogaw tay nan aamam-an di Judio ya nan menkangangato ay papadi ya nan men-is-isolo isnan linteg et awnit adyanda siya dadapay ipapatey siya ngem is katlon di agew et matago kasin. ");
INSERT INTO xnn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inpootna pay ay mangibaga. Dat ipagay-ed Pedro siya et yamyamana si Jesus gapo isnan inbagana ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dat menligos si Jesus danat ilan nan papasolotna danapay abes yamyaman si Pedro et kanana, “Taynam sak-en tay nan kinwanim et kalin Satanas. Nan ninemnemmo et baken adi si Apo Dios is nagapowana nodi isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dat ayagan Jesus nan papasolotna ya nan ado ay ipogaw et kanana ken daida, “No sino nan manglayad ay maitapi ken sak-en et masapol ay ibilangna ay kaneg natey et nan awakna ta baken nan laydena is ik-ikkana nodi nan laydek ta itoledna nan ligat ay kaneg nan mang-aw-awit isnan krosna ta omonod ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tay nan mangnemnemnem isnan awakna et kedeng et awnit matey met laeng. Ngem nan adi mangnemnemnem isnan awakna gapo ken sak-en ya nan mangibagaana isnan gawis ay damag et olay no matey ngem matagotago ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ay waday ganaben di ipogaw ay mangkowa isnan am-in ay kinabaknang isnan batawa no matey daet adi dawaten Apo Dios? Maid adi. ");
INSERT INTO xnn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tay maid polos kinabaknang di ipogaw is makasokat isnan biyagna. ");
INSERT INTO xnn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngawingawi nan ipogaw id wani tay ado nan mangdokdokog ken Apo Dios. Isonga no sinoy mang-adi ken sak-en ya nan it-itdok et awnitko abes adyan daida isnan omaliyak ay mangipaila isnan kangatok ya nan kangaton Ama ya nan kaangheanghelna.” ");
INSERT INTO xnn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Danat kanan pay ken daida, “Tet-ewa nan ibagak, wada ken dakayo nan matatago pay laeng engganay ilaenda nan panakabalin Apo Dios isnan mentolayana.” ");
INSERT INTO xnn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nallos nan enem ay agew dat ayagan Jesus da Pedro ken Santiago ya si Juan danat ipango daida isnan atakdag ay bilig. Dat tomeken nan kaiilaan Jesus ken daida ");
INSERT INTO xnn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","et pinmolapolaw ay sinmilang nan badona ay maid is-isona isnan batawa ");
INSERT INTO xnn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","dat menpaila da Elias ken Moses ay makitoytoya ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dat kanan Pedro ken Jesus, “Apo, gawis tay wada tako isna. Omset kami is toloy bawi ta pala ken sik-a nan esa, pala ken Moses nan esa ya pala ken Elias nan esa.” ");
INSERT INTO xnn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ngem apedna kinwani di tay pilmi ay nasngangda et adina getken nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dadat malilingban isnan liboo dadat dengngen nan kali ay nagapo isnan liboo ay mangwani, “Si tona nan Anakko ay laylaydek. Dengngenyo nan kankanana.” ");
INSERT INTO xnn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dat menpangatamaang da Pedro ngem daet nakekedeng si Jesus ay maid da Elias ken Moses. ");
INSERT INTO xnn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Issan lomaylayoganda issan deey ay bilig dat ibilin Jesus ken daida en, “Adiyo polos ibagbaga nan inilayo engganay kasinak matago.” ");
INSERT INTO xnn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Egayda sinodsodok ngem asida popoot mo ngan nan kankanana ay kasina matagowan. ");
INSERT INTO xnn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dadat sooten abes ken Jesus en, “Dakan kanan en kasinka matago dapay kanan nan men-is-isolo isnan linteg Apo Dios en masapol ay omon-ona ay omali si Elias mo si Kristo?” ");
INSERT INTO xnn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dat kanan Jesus, “Tet-ewa ay omali omon-ona si Elias ta isaganana nan am-in. Ngem ayta ngalod dan naisolat isnan kalin Apo Dios en masapol ay mapaligatanak ya maamisak? ");
INSERT INTO xnn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ibagak ken dakayo ay epdas inmali si Elias ngem inikkan nan deeyday ipogaw nan kinaykayatda ken siya tay pinateyda ay kaneg nan naisolat id kasin ay ommat ken siya.” ");
INSERT INTO xnn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sinmagong da Jesus issan kad-an san tap-in di papasolotna dadat ilaen ay adoado nan ipogaw dapay makisongsongbat nan men-is-isolo isnan linteg issan deeyday papasolot Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaanila nan ipogaw ken Jesus dadat nasdaaw dadapay tomagtag ay mangsab-at ya mangtoya ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dat kanan Jesus ken daida, “Ngan nan mangsongsongbatanyo ken da todi?” ");
INSERT INTO xnn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dat kanan nan esay am-ama, “Apo, iyalik koma ken sik-a nan naay anakko tay wada nan anito ay mang-om-omel ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No kapten san anito siya danat tokangen et omosab nan topekna dat menngilet nan bab-ana dapay komenteg nan awakna. Inbagak isnan papasolotmo en pakaanenda nan anito ngem adida kabaelan.” ");
INSERT INTO xnn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dat kanan Jesus ken daida. “Dakayo od id wani et adi kayo polos mamati. Nabayagak ay nakitetee ken dakayo et palalo nan anosko ngem adi kayo kayet pomati. Aye pay di anosko ken dakayo. Iyaliyo isna.” ");
INSERT INTO xnn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dadat eyey san onga ken Jesus. Idi inilan nan anito si Jesus danat pakedasen san onga et matokang dat menbalibalin dapay men-osab nan topekna. ");
INSERT INTO xnn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dat kanan Jesus, “Tongona nan nangkapetan nan anito ken tona?” Dat kanan san aman di onga, “Enggana isdin kaong-ongana. ");
INSERT INTO xnn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Namin ado ay binkasna siya isnan apoy no baken et isnan danom ta matey koma. Maseg-angka ta badangam nan anakko no kabaelam.” ");
INSERT INTO xnn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Dat kanan Jesus, “Damen aped kanan en no kabaelak? Nan mamati ken Apo Dios et maid adi mabalin is maikkana.” ");
INSERT INTO xnn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dat pigsaan san am-ama nan kalina ay mangwani, “Mamatiyak. Ngem kolang nan pammatik isonga mangbadangka ta maanayan nan pammatik.” ");
INSERT INTO xnn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dat ilan Jesus ay madagdagop nan ipogaw ay manglikob ken daida danat bilinen nan anito ay mangwani, “Sik-a ay toweng ya omel ay anito, taynam siya ta adim kasin kapkapten.” ");
INSERT INTO xnn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dat men-owakis nan anito et dadama nan ikkana ay mangpakedas issan onga dat komaan et taynana siya. Dat kega natey nan kaiil-an san onga isonga kanan san deeyday ipogaw en natey. ");
INSERT INTO xnn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ngem dat gen-an Jesus nan ledengna danat bangonen et tomakdeg. ");
INSERT INTO xnn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Dat makekedeng da Jesus ya nan papasolotna ay songgep isnan baey dat sooten nan papasolotna, “Aytay dakamin adi makaipakaan issan deey ay anito?” ");
INSERT INTO xnn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Dat kanan Jesus, “Nan anito ay kaneg todi et adi maipakaan no adiyo ipapasnek ay menlowalo.” ");
INSERT INTO xnn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kinmaan da Jesus isdi dadat laosan id Galilea tay kayat Jesus ay maid mangtek isnan menteteanda ");
INSERT INTO xnn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ta isolowana nan papasolotna. Danat ibaga ken daida en, “Nganngani ay maitedak ay Iyon-an Am-in di Ipogaw isnan mangdepap ken sak-en et awnitda mangpatey. Ngem isnan maikatlo ay agew et awnitak matago kasin.” ");
INSERT INTO xnn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Egayda maawatan nan kayatna ay kanan ngem mabainda ay mangsoot. ");
INSERT INTO xnn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Inomdanda pay id Capernaum dadat songgep isnan baey dat sooten Jesus no ngan nan kinkinwanida isnan daan. ");
INSERT INTO xnn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ngem igiginekda tay nan kinkinwanida et mo sino nan kapatgan ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dat tomokdo si Jesus et palikobena daida ay simpoo ya dowa ken siya. Danat isolowan daida ay mangwani, “Nan manglayad ay siya nan kapatgan ken dakayo et masapol ay iyoy-oyana danapay badbadangan am-in ay ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Danat ayagan nan esay onga et daingena danapay kanan, ");
INSERT INTO xnn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nan manglayad ya mang-ayyew isnan kaneg nan naay ay onga gapo isnan pammatina ken sak-en et siya nan kaneg nan layadna ken sak-en. Et nan manglayad ken sak-en et bakenak kedeng is laydena nodi laydena gedan nan nangbaa ken sak-en ay si Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Dat kanan Juan, “Apo, inilami nan esay am-ama ay mangipakpakaan is anito isnan ipogaw gapo isnan pammatina kano ken sik-a. Ngem inyadimi tay baken tako ib-a.” ");
INSERT INTO xnn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dat kanan Jesus, “Adiyo iyadi siya tay nan mang-osal isnan ngadanko ay mang-ikkan is kaskasdaaw et adi mabalin ay aposena sak-en ay dagos. ");
INSERT INTO xnn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tay nan adi mang-ap-apos ken datako et daida nan bomadbadang. ");
INSERT INTO xnn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tet-ewa nan ibagak ken dakayo en olay nan aped mangpainom is danom ken dakayo gapo tay ib-ayo sak-en ay si Kristo et awnit wada nan ganabena.” ");
INSERT INTO xnn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ngem no wada nan mang-aw-awis ay menbasol nan esa ay kapatpati ken sak-en et gag-awis no maitaked nan losong ay bato isnan bagangna dat maibkas isnan baybay.” ");
INSERT INTO xnn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dat itoloy Jesus en, “Mo nan ikkan nan ledengmo di makabasolam et gawis no pokolam ta iwasitmo tay gag-awis no kolang nan ledengmo id wani basta wada nan biyagmo ken Apo Dios ay eng-enggana mo nan dowa nan ledengmo id wani dakat mapaligatan isnan impilno ay kad-an di apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO xnn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ya no nan ikkan nan esa ay sikim di makabasolam, gag-awis no pokolam. Tay gag-awis mo es-esang nan sikim id wani basta wada nan biyagmo ken Apo Dios ay eng-enggana mo nan dowa nan sikim dakapay omey isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO xnn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Et no gapo abes nan pang-ilan nan esay matam is makabasolam et gawis no soklatem laengen. Tay gag-awis no es-esang nan matam id wani basta wada nan biyagmo ken Apo Dios ay eng-enggana mo nan dowa nan matam dakat omey isnan apoy ay adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tay id isdi ay impilno et adi katkatey nan bogis isnan awakda ya adi kasebsebseban nan apoy ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kaneg nan mang-osalan nan ipogaw isnan asin ay mangpagawis is makan et nan ligat abes nan osalen Apo Dios ay mangpagawis isnan ogalin di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Gawis nan asin ngem no epdas nakaan nan sidekna et maid et kaosalana. Isonga dakayo et menpinagawis kayo ta menbinadang kayo ay kaneg nan mangipaimisan nan asin isnan makan.” ");
INSERT INTO xnn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kinmaan da Jesus isdi dadat omey isnan bas-ang nan ginawang ay Jordan ay sakop di Judea. Dat kasin madagop nan kaipoipogaw ken siya danat isolowan daida tay siya nan sigod ay ogalina. ");
INSERT INTO xnn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Dat wada abes nan tap-in di Fariseo ay omey mangpadas ay mangsikap ken Jesus isonga dadat kanan, “Ay ipalobos nan linteg tako ay idangan nan lalaki nan asawana?” ");
INSERT INTO xnn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Dat kanan Jesus, “Ngan nan bilin ay insolat din si Moses?” ");
INSERT INTO xnn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dadat kanan, “Inpalobosna met. Ngem masapol kano ay men-ited nan lalaki is kasolatan ken asawana ay mangipagtek ay nin-idangda sanapay pakaanen siya.” ");
INSERT INTO xnn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dat abes kanan Jesus, “Gapo tay gintekna od ay adi kayo maisolowan isonga siya nan insolatna. ");
INSERT INTO xnn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ngem wada isnan naisolat ay maipanggep isdin login di batawa en, ‘Binoliw Apo Dios nan ipogaw ay lalaki ya babai. ");
INSERT INTO xnn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Isonga taynan nan lalaki da amana ken inana et maitapi ken asawana. ");
INSERT INTO xnn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Et nan deeyda ay sin-asawa, menbalinda ay es-esang,’ kanana. Tet-ewa bakenda dowa nodi es-esang. ");
INSERT INTO xnn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Isonga baken osto no men-idang nan tinipon Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sinmagongda isnan baey dat sooten nan papasolotna no ngan san kayatna ay ibaga issan kinwanina. ");
INSERT INTO xnn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Danat kanan ken daida, “Nan lalaki ay makiidang dat makiasawa is teken et kaneg gedan mamabai. ");
INSERT INTO xnn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kaneg abes nan babai et makabasol no makiidang dat makiasawa is teken.” ");
INSERT INTO xnn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wadada nan nangyey is oongong-a ken Jesus ta mokena kapposen daida ta mabindisyonanda ngem inyadin nan papasolot Jesus daida. ");
INSERT INTO xnn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngem idi inilan Jesus danat sagiiten daida ay mangwani, “Palobosanyo nan oongong-a ay omali ken sak-en. Adiyo iyadi daida tay nan mangtalek ken sak-en ay kaneg nan naayday oongong-a et daida nan maitapi isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tet-ewa nan ibagak ken dakayo, maid teken is maitapi isnan mentolayan Apo Dios nodi nan mangtalek ken siya ay kaneg nan mangtalkan nan oongong-a isnan am-ada.” ");
INSERT INTO xnn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Danat sag-es-angen ay manglak-ey isnan oongong-a et ipatangna nan ledengna isnan oloda ay mangwani en, “Bindisyonan Apo Dios dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isnan nalobwatan da Jesus et nintagtag nan esay lalaki dat menpalintomeng isnan sagang Jesus danat kanan, “Apo, gawigawiska ay ipogaw isonga ibagam kad no ngan nan osto ay ikkak ta matagotagowak ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Dat kanan Jesus, “Dakan aped kanan en gawigawisak dapay si Apo Dios et kedeng nan kagawisan. ");
INSERT INTO xnn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Getkem met nan linteg Apo Dios ay kanana, ‘Adika menpatpatey, adika mamabai, adika mangak-akew, adika menpabpabasol isnan ib-am, adika men-al-allilaw ya masapol ay tongpalem da amam ken inam.’” ");
INSERT INTO xnn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dat kanan san lalaki, “Apo, am-in dana et tinongtongpalko enggana isdin kaongak.” ");
INSERT INTO xnn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Palalo nan layad Jesus issan nang-ilaana ken siya danat kanan, “Wada pay nan esang ay kolangmo. Enka ilako am-in nan kokwam damet ipakdaw isnan kokodokdo nan lakona dakat omali et maitapika ken sak-en. Tay no siya nan ikkam et awnit wada nan kinakadangyanmo id daya.” ");
INSERT INTO xnn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ngem isnan nangdengngana issan kinwanin Jesus et maiila isnan angasna ay menbabawi nan nemnemna. Dat menseseg-ang ay komaan tay adina kayat ay taynan nan kinakadangyana. ");
INSERT INTO xnn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dat menligos si Jesus ay mang-ila isnan papasolotna danat kanan, “Naligat nan maitapiyan di kadangyan isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nasdaaw nan papasolotna issan kinwanina. Dat kasin kanan Jesus, “Gagayyemko, tet-ewa ay naligat nan kaitapiyan nan ipogaw isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nalaklaka pay nan songgepan nan camel isnan lokaw di dagom mo nan maitapiyan nan kadangyan isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dadat am-amed masdaaw dadat kanan, “Apo, sino pay obpay nan mabalin ay maisalakan?” ");
INSERT INTO xnn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dat iilan Jesus daida danapay kanan, “Nan adi mabalin ay ikkan di ipogaw et mabalin ay ikkan Apo Dios tay maid polos adina kabaelan isonga am-in ay mangpati ken siya et maisalakan, kadangyan man wenno kodo.” ");
INSERT INTO xnn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dat kanan Pedro, “Ilam dakami. Tinaynanmi nan am-in ta maitapi kami ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Dat kanan Jesus, “Owen. Ibagak nan tet-ewa ken dakayo et nan mangtayan isnan baeyna, bebsatna, inana, amana, an-akna ya nan payewna isnan maitapiyana ken sak-en ya nan mangibagaana isnan gawis ay damag Apo Dios ");
INSERT INTO xnn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","et awnitda maagtan is am-amed id wani ay timpo. Maagtanda is ad-ado ay baey, bebsat, in-a, an-ak ya paypayew mo nan tinaynanda ngem mapaligatanda abes. Ngem maagtanda abes is biyag ken Apo Dios ay maid patenggana. ");
INSERT INTO xnn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Et ado isnan kapapatgan id wani et awnit daida nan kababaan ya ado isnan kababaan id wani et awnit daida nan kapapatgan.” ");
INSERT INTO xnn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Issan omay-ayanda id Jerusalem et inyon-onan Jesus ay mangidadawes. Nasdaaw nan papasolotna ya omeegyat am-in nan ipogaw ay nangboboweg tay omey si Jesus id Jerusalem ay kad-an nan bosona. Dat kasin ayagan Jesus san simpoo ya dowa ay papasolotna danat ibaga ken daida nan awnit ommat ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kanana, “Dengngenyo, naay omey tako id Jerusalem et maidyaak ay Iyon-an Am-in di Ipogaw isnan menkangangato ay papadi ya nan men-is-isolo isnan linteg. Awnitda kanan en masapol ay maipapateyak esadapay idya sak-en isnan baken Judio. ");
INSERT INTO xnn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Et awnitda mangsaysayot, mangtobbatobba ya mangbaibaig esadapay mangpatey. Ngem awnitak matago kasin isnan maikatlo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Inmey da Santiago ken Juan ay an-ak Zebedeo ken Jesus dadat kanan, “Apo, wada koma nan dawatenmi ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dat kanan Jesus, “Ngan nan laydenyo ay ikkak ken dakayo?” ");
INSERT INTO xnn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dadat kanan, “Apo, no mabalin ta isnan men-aliyam et tomokdo kami koma isnan makanawan ya nan makanigidmo.” ");
INSERT INTO xnn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ngem dat kanan Jesus, “Adiyo getken nan dawdawatenyo. Ay makaitoled kayo ay mang-okmon isnan ligat ay awnitko ligaten? Ay makatoled kayo isnan tetey ay kaneg nan ikateyko?” ");
INSERT INTO xnn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dadat kanan, “Owen. Makaitoled kami.” Dat kanan Jesus, “Tet-ewa ay awnit kayo maligatan ay kanegko. Et awnityo itoled nan tetey ay ikateyko. ");
INSERT INTO xnn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ngem bakenak is kalebbeng ay menpili is tomokdo isnan makanawan ya makanigidko tay si Apo Dios nan mangpili isnan tomokdo is dana.” ");
INSERT INTO xnn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Issan nangdengngan nan simpoo ay ib-ada ay papasolotna isnan dinawat da Santiago dadat ligten daida. ");
INSERT INTO xnn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Isonga dat ayagan Jesus daida am-in et kanana, “Getkenyo nan maik-ikkan isnan makwani en apo ya nan tap-in di mentolay isnan batawa. Igagatinda nan ipogawda gapo tay wada nan kalinteganda ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ngem adi kabalin ay kaneg todi ken dakayo nodi nan manglayad ay ngomato ken dakayo et masapol ay siya nan menpababa ta badangana nan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Owen, nan manglayad ay kapatgan ken dakayo et masapol ay mensilbi ay kaneg baa isnan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tay kaneg sak-en ay Iyon-an Am-in di Ipogaw et egayak inmali ay masilbiyan nodi tapno mensilbiyak isnan ipogaw. Isonga awnitak matey tapno masbot nan kaipoipogaw gapo isnan basbasolda.” ");
INSERT INTO xnn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inomdan da Jesus ya nan papasolotna id Jerico dapay kayet on-onoden nan adoado ay ipogaw. Isnan kinmaananda isdi et wada nan esay kowap ay anak Timeo ay si Bartimeo ay nangitotokdo isnan benget di kalsa ay menlimlimos. ");
INSERT INTO xnn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Issan nangdengngana ay si Jesus ay iNazaret nan lomaos dat menbogbogaw ay mangmangwani, “Jesus ay apon din si David, seg-angam kad sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dat ibagan nan ado ay ipogaw ta iginekna. Ngem am-amed kayet ninbogaw en, “Apon din si David, seg-angam adi sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dat itakdeg Jesus et kanana, “Ayaganyo siya.” Dadat ayagan san kowap ay mangwani, “Gomasingka tay naay paayagana sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Danat men-itep-a nan ewesna et katanakdeg dat omey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dat kanan Jesus ken siya, “Ay ngan nan kayatmo ay ikkak ken sik-a?” Danat kanan, “Apo, kaytek ay makaila koma.” ");
INSERT INTO xnn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dat kanan Jesus, “Enka. Gomawiska gapo isnan pammatim ken sak-en.” Dat maganawis nan matana et makaila dadlo dat makkey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Issan om-omdanan da Jesus id Jerusalem ay ngannganida laosan id Betfage ya id Betania ay gogowaben nan bilig ay Olivo dat ibaan Jesus nan dowa ay pasolotna ");
INSERT INTO xnn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ay mangwani, “Enkayo isnan ili ay deey et awnityo ilaen nan koyaw di kabayo ay egay kasaksakayan ay naibabaod. Dayot okasen nan baodna ta iyaliyo isna. ");
INSERT INTO xnn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No waday mangsoot en, ‘Dayon aped alaen sa?’ dayot kanan en, ‘Masapol nan apo tako ngem sin-awyan danat ipasagong.’” ");
INSERT INTO xnn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inmeyda dadat tet-ewa datngan nan koyaw di kabayo isnan kalsa ay naibabaod isnan segpan di baey dadat okasen nan baodna. ");
INSERT INTO xnn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Wadada nan nang-ila dadat sooten, “Dakayon kak-aanen nan baod tosa?” ");
INSERT INTO xnn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Dadat ibaga san kinwanin Jesus dat itan-oy san nang-ila ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inyeyda san kabayo ken Jesus dadat iyap-ap nan badbadoda isnan edeg san kabayo dat mensakay si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dat iyaplag nan kaipoipogaw nan badbadoda isnan daan ay daanen Jesus ta mangipaila ay daydayawenda siya. Nan tapina et inmalada isnan lamos ay tinmotobo isnan benget di daan et iyaplagda isnan daanena. ");
INSERT INTO xnn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dat menbogbogaw nan ipogaw ay inmon-ona ya nan omon-onod ay mangmangwani, “Hosanna. Madayaw nan naay Ali tako. Mabindisyonan nan inbaan Apo Dios ay mentolay ken datako ");
INSERT INTO xnn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ya gawigawis abes nan mentolayana tay awnitna isagong din nintolayan din alapo tako ay si Ali David. Madaydayaw si Apo Dios id daya.” ");
INSERT INTO xnn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Dadat omdan id Jerusalem et songgep si Jesus isnan Templo danat tamaangen am-in nan wada isdi. Gapo tay nasdem dadat komaan ay omey id Betania ay nanakkey nan simpoo ya dowa ay papasolotna. ");
INSERT INTO xnn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kawakgatana isnan nagapowanda id Betania ay omey kasin id Jerusalem et naowat si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Danat ilaen isnan naiyad-addawi nan kaiw ay higos ay adoado nan tobona. Isonga dat omey si Jesus ay mang-ila no waday begasna tay nan higos et bomgas isnan bomalaan nan tobona. Ngem idi ilaena dat maid polos begasna tay baken timpon di panagbebegas di higos. ");
INSERT INTO xnn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Danat kanan, “Adika kasin makabegas.” Didinngen nan papasolotna nan kinwanina. ");
INSERT INTO xnn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Isnan inomdanda id Jerusalem dat kasin omey si Jesus isnan Templo. Danat pabalaen nan men-il-ilako ya nan lomaklako isnan awnitda ited ken Apo Dios danapay tokangen nan lamisaan di mensoksokat is siping ya nan tokdowan di men-ilaklako is kalapati. ");
INSERT INTO xnn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inyadina gedan nan men-aawit ay mangidaan isnan Templo. ");
INSERT INTO xnn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Danat isolowan daida ay mangwani en, “Naisolat isnan kalin Apo Dios en, ‘Nan baeyko et paglol-owalowan am-in di ipogaw.’ Siya di nan inpasolat Apo Dios ngem ngan nan ik-ikkanyo? Dakayon aped os-osalen ay pagsos-owitikan nan baeyna?” ");
INSERT INTO xnn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dinngen pay nan menkangangato ay papadi ya nan men-is-isolo isnan linteg dadat anapen nan ikkanda ay mangpatey ken Jesus. Ngem omegyatda ay mang-ikkan tay nasdaaw am-in nan ipogaw isnan insolona. ");
INSERT INTO xnn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nasdem pay di dat taynan da Jesus nan ili. ");
INSERT INTO xnn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Issan kawakgatana et linaosanda kasin san kaiw ay higos ay maid begasna. Ilan pay nan papasolotna ay naango enggana isnan lamotna ");
INSERT INTO xnn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","dat nemnemen Pedro din kinwanin Jesus danat kanan, “Apo, ilam pod san kaiw ay binaosmo et naango.” ");
INSERT INTO xnn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Dat kanan Jesus ken daida, “Nenemnemenyo nan kanak. No mamati kayo ay maid dowadowana ken Apo Dios et mabalin ay ibagayo isnan deey ay bilig en men-aton isnan baybay et men-aton tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Isonga ibagak ken dakayo, olay mo ngan nan dawatenyo ken Apo Dios, no talkenyo siya awnit tongpalena tet-ewa nan dawatyo. ");
INSERT INTO xnn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya abes no menlowalo kayo et masapol ay pakawanenyo nan nakabasol ken dakayo ta pakawanen abes Amayo id daya nan basbasolyo.” ");
INSERT INTO xnn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO xnn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Inmeyda id Jerusalem kasin dat isnan mendad-aanan Jesus isnan Templo et inmey ken siya nan menkangangato ay papadi ya nan men-is-isolo isnan linteg ya nan aamam-a. ");
INSERT INTO xnn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Dadat sooten, “Ibagam kad ken dakami no ngan nan kalebbengam ay mang-ik-ikkan isnan am-in ay ik-ikkam? Ay sino nan nang-ited ken sik-a isnan lebbengmo?” ");
INSERT INTO xnn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Danat kanan abes ken daida, “Sootek od na ken dakayo et no makasongbat kayo daket ibaga abes nan nagapowan nan lebbengko. Siya na nan sootek. ");
INSERT INTO xnn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Into nan nagapowan din kalebbengan Juan ay Menbonbonyag? Ay ken Apo Dios wenno isnan ipogaw? Ibagayo.” ");
INSERT INTO xnn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dadat men-asisoot ay mangwani, “Ay ngan nan isongbat tako? Mo kanan tako en nagapo ken Apo Dios et awnit kanana en, ‘Ayta ngalod dayon egay pinatpati din si Juan?’ ");
INSERT INTO xnn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ngem ayke tako kanan en nagapo isnan ipogaw?” Siya nan kinwanida tay omegyatda isnan kaipoipogaw tay kananda en tet-ewa ay mamadton Apo Dios din si Juan. ");
INSERT INTO xnn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Isonga dadat kanan en, “Adimi getken.” Daet kanan Jesus, “Adiyak ngalod abes ibagbaga nan nagapowan nan kalebbengak ay mang-ik-ikkan isnan ik-ikkak.” ");
INSERT INTO xnn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dat menpangngalig si Jesus ken daida ay mangwani, “Wada nan am-ama ay nin-esek is adoado ay onas danat bakden nan om-a. Dat omset is paglebkan ay mangsetset isnan danom di onas dapay mensaad is atakdag ay baey ay mentean di menbanbantay. Danat ipaayowan esapay omey isnan addaaddawi ay ili. ");
INSERT INTO xnn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Inomdan pay nan kaapitan nan onas dat ibaan san kakwa nan esay baana ta ena alaen nan pigasna. ");
INSERT INTO xnn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ngem dinpap san men-ay-ayowan san inbaana dadat baibaigen esadapay ipasaa ay maid polos ginegen-ana. ");
INSERT INTO xnn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dat kasin omibaa san kakwa is esa. Ngem ginongayanda nan olona dadapay baibainan siya. ");
INSERT INTO xnn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dat kasin omibaa nan kakwa is teken. Dadat pateyen. Et adoado pay nan inik-ikkanda ay ngawi isnan tap-in di baan di kakwa. Binaigda nan tap-ina ya pinateyda nan tap-ina. ");
INSERT INTO xnn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kamaodiyana et kedeng nan kalalayadna ay anak is nabay-an danat ibaa tay kanana en modatya siya nan idngeda. ");
INSERT INTO xnn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ngem kanan san deeyda ay mang-ay-ayowan en, ‘Naay omali nan awnit mangtawid isnan naay om-a. Pateyen tako bawet siya ta datako nan mangkowa isnan tawidna.’ ");
INSERT INTO xnn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Isonga dadat depapen et pateyenda dadat ibala isnan onasan.” ");
INSERT INTO xnn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Dat itoloy Jesus ay mangwani, “Ngan pay nan ikkan et san kakwa ken daida? Awnit omey et pateyena nan deeyday mang-ay-ayowan danat ipaayowan isnan teken ay ipogaw san om-a. ");
INSERT INTO xnn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Waay binasayo met nan naisolat isnan kalin Apo Dios ay mangwani en, ‘Nan bato ay inadyan di nangsaad isnan baey et siya nan kapatgan tay ipakekenegna nan baey. Inikkan Apo Dios na et pilmi ay kaskasdaaw ken datako.’” ");
INSERT INTO xnn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gintek san deeyday aap-apon di Judio ay daida nan kankanan Jesus ay nang-adi issan inbab-aan nan kakwa issan onasan ya nan napateg ay bato tay adyanda siya. Isonga laydenda ay depapen siya. Ngem omegyatda isnan ipogaw isonga dadat komaan et taynanda si Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nakwas di dadat ibaa nan tap-in di Fariseo ya nan ib-an Ali Herod ta enda sikapan koma si Jesus isnan mensootanda ta waday mangipabasolanda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inomdan san nabaa ken Jesus dadat kanan, “Apo, getkenmi ay tet-ewa am-in nan kankanam tay adika polos al-allilawen nan ipogaw nodi isolsolom nan layden Apo Dios ay ikkanda ya maid paam-amdem isnan nangato ya nababa ay ipogaw. Isonga ibagam kad ken dakami no iyadin nan linteg tako nan mangbayadan tako is bowis ken Cesar ay ali id Roma. ");
INSERT INTO xnn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ay menbayad kami wenno adi?” Ngem getken Jesus ay agindasosoot isonga danat kanan, “Aytay dayon padpadasen ay mangsikap ken sak-en? Omyali kayo is esay siping ta ilaek.” ");
INSERT INTO xnn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dadat omidya. Dat sooten Jesus, “Sino nan kaangas ya kangadan isna?” Dadat kanan, “Si Cesar.” ");
INSERT INTO xnn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Dat kanan Jesus en, “No siya ngalod sa et kowan Cesar nan siping isonga ikkanyo ken Cesar nan kalebbengana dayopay abes ikkan ken Apo Dios nan kalebbengana.” Dadat masdaaw gapo isnan laingna ay somongbat. ");
INSERT INTO xnn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Inmey ken Jesus nan tap-in di Saduceo ay mangpadas ay mangsikap ken siya. Datona nan tap-in nan Judio ay adi mamati en kasin matago nan natey. ");
INSERT INTO xnn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kinwanida ken Jesus, “Apo, insolat Moses id sang-adom en mo matey nan lalaki ay inmasawa dapay maid anakna et masapol ay asawaen nan besat san natey nan balo ta omanakda et maibilang ay kaneg anak san natey. ");
INSERT INTO xnn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kadya, id kasin et wada nan pito ay sin-ag-i ay lalalaki ay omili isna. Inmasawa nan iyon-a dat matey ay maid anakda. ");
INSERT INTO xnn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dat asawaen nan maisned san aydona ay balo dat matey abes ay maid anakda. Et siya gedan nan inommat isnan maikatlo ");
INSERT INTO xnn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","enggana isnan maikapito. Nateyda am-in ay maid anakda. Kaodiyan ay natey san balo. ");
INSERT INTO xnn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Naay nan sootenmi, isnan katagowan nan natey ay sino pay nan osto ay asawan san babai issan pito ay sin-ag-i tay inasawada am-in siya?” ");
INSERT INTO xnn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Dat songbatan Jesus daida ay mangwani, “Baken osto nan nemnemyo tay adiyo od maawatan nan naisolat isnan kalin Apo Dios ya adiyo getken abes nan kabaelana. ");
INSERT INTO xnn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tay isnan matagowan nan natey et menbalinda ay kaneg nan aanghel id daya ay adi makias-asawa. ");
INSERT INTO xnn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Et maipanggep isnan matagowan nan natey, ay egayyo binasa nan insolat din si Moses? Inpagtekna ay gintekna ay kasin matago nan natey isdin nangisolatana isnan inommat isdin nakikaliyan Apo Dios ken siya isdin menbidbidang ay kaiw. Tay insolatna nan kinwanin Apo Dios ken siya en, ‘Sak-en nan Dios ay daydayawen da Abraham ken Isaac ya si Jacob.’ ");
INSERT INTO xnn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Siya na nan insolatna dapay epdas natey da Abraham issan nangwaniyan Apo Dios isdi. Et siya di nan manggetkan tako ay matago kasin nan natey ay ipogaw Apo Dios tay adi kabalin ay kanan Apo Dios en daydayawenda siya kayet no egayda natago kasin. Isonga tet-ewa ay naillado kayo.” ");
INSERT INTO xnn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Inmey ken Jesus nan esay men-is-isolo isnan linteg. Dinngena nan kinkinwanin san Saduceo et gintekna ay gawis nan insongbat Jesus ken daida isonga danat sooten, “Apo, ngan nan kapatgan ay linteg Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dat kanan Jesus, “Nan kapatgan ay linteg Apo Dios et siya na. ‘Dakayo ay Judio, dengngenyo. Nan Ap-apo tako ay si Apo Dios et siya nan Dios ay maid teken. ");
INSERT INTO xnn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Masapol ay laylaydenyo siya ay ostoosto isnan nemnem ya posoyo ya isnan am-in ay ik-ikkanyo ya isnan kabaelanyo.’ ");
INSERT INTO xnn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nan maikadwa ay kapatgan et, ‘Laylaydenyo nan iib-ayo ay kaneg nan pananglaylayadyo isnan awakyo.’ Maid teken is napatpateg ay linteg Apo Dios mo datona.” ");
INSERT INTO xnn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dat kanan san men-is-isolo isnan linteg, “Osto Apo. Tet-ewa nan kinwanim en esa et kedeng si Apo Dios ay maid teken is dios. ");
INSERT INTO xnn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Et tet-ewa abes ay masapol ay laylayden tako siya isnan nemnem, poso ya nan am-in ay kabaelan tako. Et osto gedan nan kinwanim ay masapol ay laylayden tako nan ib-a tako ay kaneg nan manglaylaydan tako isnan awak tako. Tet-ewa ay napatpateg di is ikkan tako mo nan am-in ay ik-ikkan tako ay men-id-idya is pala ken Apo Dios ay kaneg nan mapalti ya nan tap-ina.” ");
INSERT INTO xnn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gintek Jesus ay nanemneman di ay ipogaw tay gawis nan songbatna isonga danat kanan, “Ngannganika ay maitapi isnan mentolayan Apo Dios.” Inmegyat et nan tap-in di ipogaw ay mensos-oot ken Jesus tay gawis am-in nan songbatna. ");
INSERT INTO xnn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Issan nin-isolowan Jesus isnan Templo et sinootna en, “Dan kanan nan men-is-isolo isnan linteg en alapon Kristo din si David ");
INSERT INTO xnn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","37","dapay inbagan David nan initdon Ispirito Santo ken siya ay kanana en Ap-apona si Kristo? Tay siya na nan kinwanin David, ‘Kinwanin Apo Dios ken Kristo ay Ap-apok en tomokdoka isnan makanawanko engganay abakek am-in nan bosom.’” Dat itoloy Jesus en, “No kanan David en Ap-apona si Kristo, dadan aped kanan en alapon Kristo si David? Ay baken Ap-apon David si Kristo?” Men-gasing nan deeyday kaipoipogaw ay mangdedenge isnan kankanan Jesus ");
INSERT INTO xnn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","danat itoloy ay men-isolo et kanana, “Makail-ilanyo nan deeyda ay men-is-isolo isnan linteg. Tay laylaydenda ay menbabado is gawigawis ay maisagsagayad tasiyay mailalasinda ya laydenda abes ay lislispitowen nan ipogaw daida ay mangmangwani en, ‘Omayanyo, Apo?’ no enda menpasyal. ");
INSERT INTO xnn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pilpiliyenda pay nan kagawisan ay tokdowan isnan sinagoga ya kagawisan ay kad-an no enda makikan. ");
INSERT INTO xnn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dadapay tagikowaen nan kokwan di nabalo ay bababai. Ngem kayatda ay lingban nan ngawi ay ik-ikkanda isonga andoandowenda nan lowaloda. Ngem gapo is dana et awnit am-amed nan dosada.” ");
INSERT INTO xnn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tinmokdo si Jesus et sagangena nan maig-igwaan di siping isnan Templo danat ilan nan mang-ip-ippey isnan siping. Ado ay kakadangyan nan mang-ip-ippey is sag-aado ay siping. ");
INSERT INTO xnn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Dat omey abes nan balo ay babai ay kodokodo et ippeyna nan dod-owa ay galak ay sipingna. ");
INSERT INTO xnn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dat ayagan Jesus nan papasolotna et kanana ken daida, “Ibagak ken dakayo en ad-ado nan inippey nan naay kodokodo ay balo mo san inigwan am-in san tap-ina. ");
INSERT INTO xnn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tay kedeng nan soblan di kinabaknangda is inidyada ngem san balo et olay kodokodo et inigwana am-in ay menkatagona.” ");
INSERT INTO xnn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Issan binmalaan da Jesus isnan Templo dat kanan nan esay pasolotna, “Apo, ilam pod nan naayda ay ganaganagwis ay bato ay naisaad isnan ganagwis ay bab-aey ya Templo.” ");
INSERT INTO xnn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Dat kanan Jesus, “Owen, ilam nan naayda menbebgew ay baey ngem awnit domateng nan timpo ay maid polos mabaybay-an is olay esa ay batona tay awnit mapokada am-in.” ");
INSERT INTO xnn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Isnan nangtaynan da Jesus id Jerusalem dadat omey isnan bilig ay Olivo et tomokdo si Jesus ay mangdedemang isnan Templo. Dat somag-en da Pedro, Santiago, Juan ya si Andres ken Jesus et kananda, ");
INSERT INTO xnn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kadya, ibagam ken dakami mo tongona nan omdanan san kinwanim id kawni ya nan kailasinan nan omdanana.” ");
INSERT INTO xnn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dat ilogin Jesus ay men-isolo et kanana, “Makailanyo ta maid mang-al-allilaw ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tay ado nan awnit omali ay aped mangwani en daida si Kristo et awnit adoado nan allilawenda. ");
INSERT INTO xnn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Awnit dengngenyo nan ngalawngaw di gobat ay maisasag-en ken dakayo ya nan damag ay wada nan gobat isnan ad-addawi ay ili. Ngem adi kayo makibkibtot tay masapol ay ommat dana ngem baken di is menpatenggaan nan batawa. ");
INSERT INTO xnn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Awnit men-asigogobat nan kailiili ya kaneg abes nan kagobigobilno ya awnit wada gedan nan adoado ay yegyeg ya kabitibitil isnan natkenatken ay il-ili. Am-in dana et siya nan menlogiyan di ligat ay kaneg nan menpasikalan di omanak. ");
INSERT INTO xnn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dakayo abes, makailanyo nan ikkanyo tay awnit wada nan mangdepap ken dakayo dadat eyey dakayo isnan pagbistaan dadapay baigen dakayo isnan sinagoga. Gapo isnan pammatiyo ken sak-en et awnitda idalom dakayo isnan gogobilno ya aali et siya nan wayayo ay mangipagtek isnan gawis ay damag ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tay masapol ay maipagtek nan gawis ay damag isnan am-in ay kailiili isnan batawa esapay omdan nan menpatenggaana. ");
INSERT INTO xnn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No somalyaenda dakayo et adi kayo madanagan isnan awnityo isongsongbat tay kigad si Apo Dios. Isonga nan awnityo kankanan et baken nan nemnemyo is magapowana nodi isnan Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Isnan deey ay timpo et awnit idalom nan ipogaw nan olay besatna ay mangipapatey. Olay nan am-a et awnit ipapateyda nan an-akda ya awnit pabasolen nan an-ak nan am-ada dadat ipapatey daida. ");
INSERT INTO xnn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Awnit aamisen nan ipogaw dakayo gapo isnan pammatiyo ken sak-en. Ngem nan mang-an-anos ay olay ngan di ommat engganay makwas nan am-in et isalakan Apo Dios daida.” ");
INSERT INTO xnn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Dat itoloy Jesus, “Awnit ilanyo nan kadodogis isnan pangiilaan Apo Dios ay tomakdeg isnan Templo ay adina bagay ay tomakdegan. (Nan mangbasa isnan naay et maawatanyo koma.) Isonga isnan mang-ilaanyo is dana et masapol ay nan ipogaw id Judea et menbakwitda isnan bilbilig. ");
INSERT INTO xnn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Et nan wada isnan pantewna et adiyet songgep ay mang-ala isnan bonagna. ");
INSERT INTO xnn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kaneg abes nan epdas linmokso et adiyet makasaa isnan baeyna ay mang-ala isnan badona. ");
INSERT INTO xnn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Am-amed kaseseg-ang nan maliton ya nan mensaskot isnan omdanan nan timpo ay deey. ");
INSERT INTO xnn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Isonga dawatenyo ken Apo Dios ta adi kaitimpo nan ligat isnan pinaglemlem. ");
INSERT INTO xnn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tay nan ligat isnan deey ay timpo et awnit siya nan kaam-amedan isnan am-in ay ligat ninlogi isdin naboliwan di batawa ay enggana id wani dat maidet kasin domatdateng is kaneg todi isnan batawa ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No egay geddengan Apo Dios nan agew ay menligatan et awnit maid mabay-an is ipogaw isnan batawa ngem gapo tay maseg-ang siya isnan pinilina ay ipogaw isonga awnit at-atikena nan agew ay menligatanda. ");
INSERT INTO xnn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Isonga no wada nan mangwani ken dakayo, ‘Ilam. Naay si Kristo,’ wenno ‘Deey siya,’ et adiyo kadi patpatiyen. ");
INSERT INTO xnn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tay awnit wadada nan mangwani en daida kano si Kristo ya nan tap-ina et kananda en mamadton Apo Dios kano daida. Et awnit omipailada is kaskasdaaw ay kabaelanda tapno men-allilawda pati nan pinilin Apo Dios ay ipogawna no mabalin. ");
INSERT INTO xnn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Makailanyo. Ipaon-onak ay mangibaga ken dakayo isnan am-in tapno nenemnemenyo ta adi kayo maal-allilaw.” ");
INSERT INTO xnn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Intoloy Jesus ay mangwani, “Ngem isnan makwasan nan deey ay ligat et awnit malingban nan agew et bomolinget ya adiyet somilang nan bowan. ");
INSERT INTO xnn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nan talaw et awnit maekdagda ya nan am-in ay wada id daya et awnit maikiweg. ");
INSERT INTO xnn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Et siya na nan mang-ilaan nan kaipoipogaw ken sak-en ay Iyon-an Am-in di Ipogaw isnan lomayogak ay maitatapi isnan liboo ay magapo id daya et somilangak ay mangipaila isnan kangaton Apo Dios ya nan kabaelana ay wada ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Esak ibaa nan aanghelko isnan am-in ay kad-an di ipogaw isnan batawa ta dagopenda am-in nan ipogaw ay pinilin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Dat itoloy Jesus ay mangwani, “Nemnemenyo nan kaiw ay higos tay wada nan masoloyo. No sombo nan tobona et getkenyo ay nganngani nan pinag-odan. ");
INSERT INTO xnn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kaneg abes no ilanyo nan om-ommat isnan batawa ay kaneg san inbagak et getkenyo ay nganngani nan omaliyak. ");
INSERT INTO xnn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ibagak ken dakayo nan tet-ewa et ommat san inbagak esapay matey nan am-in ay ipogaw ay matatago id wani. ");
INSERT INTO xnn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Olay no mamaid nan batawa ya nan wada id daya ngem nan am-in ay kankanak et mawawada kayet ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Maid polos mamangtek isnan osto ay agew ya olas ay ommatan san inbagak. Olay nan aanghel et adida getken ya olay sak-en gedan ay Anak Apo Dios et adiyak getken nodi kedeng si Ama isnan mangtek. ");
INSERT INTO xnn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Isonga mensasagana kayo ay kanayon ya makail-ilanyo tay adiyo gegetken nan ommatana. ");
INSERT INTO xnn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nan is-isona et kaneg nan ipogaw ay menbaat ay esapay komaan et ibilina omon-ona nan biyang di wasdin esa ken esa isnan baana danat abes ibaga isnan gowaldiya ta adi aped maseyseyep nodi sesed-ena nan somaaana. ");
INSERT INTO xnn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Isonga mensasagana kayo ay kanayon tay adiyo getken nan somaan nan kabaey no sedem, tengan di labi, tan-o wenno wakgat. ");
INSERT INTO xnn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mensagana kayo ta no golpi nan omaliyak et adi kayo kadatngan ay maseseyep. ");
INSERT INTO xnn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nan ibagak ken dakayo et ibagak abes isnan am-in ay ipogaw ta wasdin mensasagana.” ");
INSERT INTO xnn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nan Fiestan di Linmaosan di Anghel et siya gedan di nan agew ay mangkakananda is tinapay ay egay kabobodan. Doway agew esapay omdan nan fiesta dat anapen nan menkangangato ay papadi ya nan men-is-isolo isnan linteg nan ikkanda ay mangdepap ay mangpatey ken Jesus ay maid mangtek is ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tay kananda en, “Masapol ay adi tako iyas-aspo isnan timpon di fiesta ta modatya golowen nan ipogaw datako.” ");
INSERT INTO xnn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wada da Jesus id Betania isnan baey da Simon ay din nakolit ay inpagawisna. Isnan mangmangananda dat songgep nan esay babai ay nananggen isnan gawigawis ay palanggo ay kad-an di nangina ay bangbanglo danat gepaken nan olon di palanggo ay mangtokab esanapay ibokbok am-in isnan olon Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngem naslat nan tap-in di ipogaw et kananda en, “Ayyew pay sa. Danan aped kawkawasen nan bangbanglo? ");
INSERT INTO xnn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mo nailako di koma et waay solok ay lagbo is makatew-en ta maibadang koma isnan kodo.” Dadat iyawen san babai. ");
INSERT INTO xnn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ngem dat kanan Jesus ken daida, “Bay-anyo siya tay gawigawis nan inikkana ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Olay ket wawawawada nan kodo ken dakayo et ado ay agew nan mabalin ay mangbadanganyo ken daida. Ngem sak-en pay et adiyak mabayag ay makitetee ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Isonga inikkana nan kabaelana ken sak-en. Nan nangibokbokana et isaganana nan awakko isnan maikaobak. ");
INSERT INTO xnn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tet-ewa nan ibagak ken dakayo, olay no into nan maiwalasan nan gawis ay damag isnan batawa et maipagpagtek abes nan inikkana ay kanemnemnemana.” ");
INSERT INTO xnn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nalpas am-in dadi dat omey si Judas Iscariote ay esa isnan simpoo ya dowa ay papasolot Jesus isnan menkangangato ay papadi et makitolag ay awnitna isipsip si Jesus ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Palalo nan gasing san papadi isnan nangdengnganda isnan kinwanin Judas dadat tolagen siya ay awnitda agtan is siping. Dat ilogin Judas ay mennemnem is gawis ay timpo is mangipadepapana ken Jesus is ken daida. ");
INSERT INTO xnn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Inomdan et nan agew ay mangkakanan di Judio is egay kabobodan ay tinapay. Et siya gedan nan mangpaltiyanda is kalnilo ay kaneg din inikkan din alal-apoda ay Judio isdin nanglaosan di anghel isnan bab-aeyda id Egipto tapno adina itapi ay mangpatey ken daida. Dat kanan nan papasolot Jesus ken siya, “Into nan laydem ay enmi mangisaganaan isnan kanen tako is fiesta?” ");
INSERT INTO xnn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dat baaen Jesus nan dowa ay papasolotna et kanana, “Enkayo id Jerusalem et awnityo sab-aten nan mangbobolig is sinakdona dayot onoden siya ");
INSERT INTO xnn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","isnan baey ay segpena dayot kanan isnan kabaey, ‘Kinwanin nan Apo tako en into kano nan kowalto ay esana manganan ya nan papasolotna is fiesta?’ ");
INSERT INTO xnn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Et awnit itdon nan kabaey ken dakayo nan dakedake ay kowalto isnan maikadwa ay galado dayot isagana nan kanen tako tay wada am-in nan masapol tako isdi.” ");
INSERT INTO xnn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dat omey san dowa ay papasolot Jesus isnan ili et naikkan san kinwanina dadat isagana nan kanenda. ");
INSERT INTO xnn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nasdem pay dat omey da Jesus ya nan simpoo ya dowa ay papasolotna issan baey. ");
INSERT INTO xnn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mangmanganda pay dat kanan Jesus ken daida, “Ibagak ken dakayo nan tet-ewa et wada nan esang ay makikikan ken datako isna ay awnit mangisipsip ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dadat menseseg-ang dapay wasdin mensoot ken siya, “Ay sak-en ngen?” ");
INSERT INTO xnn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Dat kanan Jesus, “Owen, nan esa ken dakayo ay simpoo ya dowa ay makisiwsiwsiw isnan tinapayna ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sak-en ay Iyon-an Am-in di Ipogaw et tet-ewa ay awnitak matey tay siya nan naisolat id kasikasin ngem kaseseg-ang nan sanay awnit mangisipsip ken sak-en. Gepgepes et di egay kaiyanak siya.” ");
INSERT INTO xnn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mangmanganda dat alaen Jesus nan tinapay et men-iyaman ken Apo Dios esanapay amam-asen et idyana ken daida. Danat kanan, “Alaenyo na ta kanenyo tay siya na nan awakko.” ");
INSERT INTO xnn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Danat alaen abes nan inomenda et men-iyaman ken Apo Dios. Danat idya ken daida am-in et inomenda. ");
INSERT INTO xnn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dat kanan Jesus ken daida, “Naay nan basak ay mangipaila isnan balo ay nakitolagan Apo Dios isnan ipogaw. Ipailana nan omayosan nan basak ay mangsakbot isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tet-ewa nan ibagak ken dakayo et adiyak kasin omin-inom is basi engganay omdan nan agew ay ominomak isnan balo ay basi isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dadat menkanta ay mangdayaw ken Apo Dios esadapay bomala ay omey isnan bilig ay Olivo. ");
INSERT INTO xnn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Issan mendad-aananda dat kanan Jesus ken daida, “Awnit lomayaw kayo am-in ay mangtaynan ken sak-en et siya nan matongpalan din naisolat isnan kalin Apo Dios ay, ‘Awnitak pateyen nan mang-ay-ayowan isnan kalnilo et maiwakatda am-in.’” ");
INSERT INTO xnn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dat itoloy Jesus et kanana, “Ngem isnan matagowak kasin et awnitak omon-ona id Galilea daket sesed-en dakayo.” ");
INSERT INTO xnn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dat kanan Pedro, “Olay no lomayaw am-in nan iib-ak et adiyak kayet taytaynan sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Dat kanan Jesus, “Ngem ibagak ken sik-a en id wani ay labi esapay mentan-o nan manok is mamin dowa et namitlo ay mangisotka ay adika mangtek.” ");
INSERT INTO xnn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dat kayet kanan Pedro, “Adi mabalin ay awnitak ikkan sa tay olay no maitapiyak ken sik-a ay matey.” Et siya gedan nan kinkinwanin nan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Inmeyda id Getsemani dat kanan Jesus isnan papasolotna, “Sosom-ed kayo isna ta omeyak menlowalo ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Danat ipakkey da Pedro ken Santiago ya si Juan. Dat liknaen Jesus nan dadama ay seg-ang ya sakit di nemnemna gapo isnan awnit ommat ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Danat kanan ken daida, “Palalo ay menseseg-ang nan nemnemko ay nganngani ay omisokba. Mentee kayo isna ta mangkakadwa kayo.” ");
INSERT INTO xnn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dat gomay-ed si Jesus et menlokbob ay mendawat ken Apo Dios ta no mabalin et adi matoloy nan nganngani ay ommat ken siya ");
INSERT INTO xnn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","et kanana, “Ama, Ama. Maid adi mabalin ken sik-a. Kaanem koma nan naay ligatko. Ngem baken nan laydek is matongpal nodi nan laydem.” ");
INSERT INTO xnn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dat somagong si Jesus et ilana ay maseseyep san tolo ay papasolotna danat gidowen si Pedro et kanana en, “Simon, ay maseseyepka? Ay adika makakadwa ken sak-en is olay esay olas? ");
INSERT INTO xnn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Makailanyo ay gawis ya menlowalo kayo tapno adi kayo kadolog ay menbasol tay kayat nan nemnemyo ay mang-ikkan isnan gawis ngem nan awakyo et nakapsot.” ");
INSERT INTO xnn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dat kasin omey si Jesus ay mendawat ken Apo Dios ay kaneg san dinawatna issan damo. ");
INSERT INTO xnn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dat somagong et ilaena nan papasolotna ay maseseyep kasin. Dadat adi makanemnem is kananda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Dat omey menlowalo is maikatlo esapay kasin mensagong et ilaena nan papasolotna danat kanan, “Ay daan kayo pay laeng ay omiilleng ay maseseyep aya? Ad-o sa tay inomdan et nan maitedak ay Iyon-an Am-in di Ipogaw isnan managbasol. ");
INSERT INTO xnn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ibangonyo ta entakot tay naay omal-ali et nan mangisipsip ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Daan ay menkalkali si Jesus dat domateng si Judas ay esa isnan simpoo ya dowa ay pasolotna. Ipapangolona nan ado ay iib-ana ay inbaan nan menkangangato ay papadi, nan men-is-isolo isnan linteg ya nan aamam-an di Judio et gegen-anda nan ispada ya pat-o. ");
INSERT INTO xnn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Esadapay omdan isnan kad-an da Jesus et inbagan Judas isnan bowegna en, “Nan bisitowek et siya nan depapenyo dayot ikaan et bantayanyo ay gawis.” ");
INSERT INTO xnn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Idi inomdanda dat idadawes Judas ken Jesus et kanana, “Apo,” danat bisitowen siya. ");
INSERT INTO xnn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dadat depapen et ikakaweda. ");
INSERT INTO xnn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ngem inasot nan esay pasolot Jesus nan ispadana et menpingasana nan ingan nan esay baan nan kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dat kanan Jesus isnan deeyda ay wada isdi en, “Aykeak pomatey is ipogaw ta men-aalmas kayo ay mangdepap ken sak-en? ");
INSERT INTO xnn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaageagew ay nin-isolowak ken dakayo isnan Templo et egay kayo nangdepdepap. Ngem olay ta matongpalan nan naisolat isnan kalin Apo Dios id kasin.” ");
INSERT INTO xnn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dat lomayaw am-in nan papasolotna et taynanda siya. ");
INSERT INTO xnn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngem wada kayet nan omon-onod ken Jesus ay baballo ay nin-eewes et kedeng. Pinadas nan sosoldado ay mangdepap ken siya ");
INSERT INTO xnn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dat matekdag nan ewesna ngem linmayaw kayet ay ninlalabos. ");
INSERT INTO xnn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Inyeyda si Jesus isnan baey di kangatowan ay padi ay nadadagopan am-in nan menkangangato ay papadi, nan aamam-an di Judio ya nan men-is-isolo isnan linteg. ");
INSERT INTO xnn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Inmon-onod si Pedro ken daida ngem maiyaaddawi engganay inomdanda isnan pantew danat itokdo et makianido isnan gogowaldiya. ");
INSERT INTO xnn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nan menkangangato ay papadi ya nan menlelebbeng ay Judio et men-anapda is mangipabasolanda ken Jesus tapno maipapatey siya ngem maid maanapanda. ");
INSERT INTO xnn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wada nan ado ay nin-ibagbaga is baken tet-ewa ay maipanggep ken Jesus ngem adi men-iiso nan kankananda. ");
INSERT INTO xnn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dat tomakdeg nan tap-in di ipogaw et menkampotda ay mangwani, ");
INSERT INTO xnn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Dinngemi nan kinwanina ay awnitna bakasen kano nan Templo ay sinaad di ipogaw danat sa kasin saaden isnan katlon di agew ay awnit baken ipogaw nan mangsaad.” ");
INSERT INTO xnn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ngem olay da todi et egay napalloy nan kinwanida. ");
INSERT INTO xnn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dat tomakdeg nan kangatowan ay padi ay mangsagang ken daida et kanana ken Jesus, “Ay maid isongbatmo isnan kinwanin da tona ay mangipabasbasol ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ngem igiginek Jesus. Dat kasin sooten nan kangatowan ay padi, “Ay sik-a si Kristo ay Anak nan madaydayaw ay si Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Dat kanan Jesus, “Sak-en. Et awnityo ilan sak-en ay Iyon-an Am-in di Ipogaw ay tomotokdo isnan makanawan Apo Dios ay manakabalin. Et awnityo ilan gedan nan omaliyak ay maitatapi isnan liboo ay magapo id daya.” ");
INSERT INTO xnn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Idi dinngen san kangatowan ay padi san kinwanin Jesus danat mensingat nan badona tay dadama nan ligetna danapay kanan, “Adi masapol pay laeng di mangpaneknek isnan basol tona ");
INSERT INTO xnn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","tay dinngeyo ay apedna kanan en siya nan Anak Apo Dios. Ngan nan kananyo?” Dadat am-in kanan en masapol ay matey. ");
INSERT INTO xnn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dat ilogin nan tap-in di ipogaw ay mangtobba ken Jesus dadat komonan nan matana et tipakenda siya dadapay kanan, “No tet-ewa ay mamadtoka, kadya ibagam no sino nan nangtipak ken sik-a.” Dat maitapi nan gogowaldiya et sogtowenda siya. ");
INSERT INTO xnn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Daan kayet si Pedro isnan pantew dat lomaos nan babassang ay baan nan kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Issan nang-ilaana ken Pedro ay men-an-anido danat inengneng siya danapay kanan, “Esaka samet ay ib-an san iNazaret ay si Jesus.” ");
INSERT INTO xnn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ngem dat isot Pedro ay mangwani, “Bakenak. Adiyak getken nan kankanam.” Dat men-aton si Pedro isnan segpan nan pantew. Dat mentan-o nan manok. ");
INSERT INTO xnn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dat kasin ilan san babai et kanana isnan mentetee isdi, “Nan sana ay ipogaw et siya nan esay ib-an Jesus.” ");
INSERT INTO xnn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ngem dat kasin isot Pedro. Maaw-awni pay dat kanan nan wada isdi, “Tet-ewa ay ib-ana sik-a tay iGalileaka.” ");
INSERT INTO xnn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dat kanan Pedro en, “Dosaen Apo Dios sak-en no menkamkampotak. Tet-ewa ay adiyak polos getken nan lalaki ay sana.” ");
INSERT INTO xnn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dat pomindowa ay mentan-o nan manok daet maipanemnem ken Pedro din kinwanin Jesus en, “Esapay pomindowa ay mentan-o nan manok et epdasmo inisot sak-en is namitlo.” Dat menbabawi si Pedro issan nangisotana ken Jesus dat bomala et men-aga. ");
INSERT INTO xnn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wiit dat kasin madagop nan menkangangato ay papadi ya nan aamam-a ya nan men-is-isolo isnan linteg ya nan tapin di menlelebbeng nan Judio ta mentotolagda is esada ikkan. Dadat galotan nan ledeng Jesus esadapay eyey ken Pilato ay gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Dat sooten Pilato ken Jesus, “Ay sik-a nan alin di Judio?” Dat kanan Jesus, “Osto nan kinwanim.” ");
INSERT INTO xnn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nan deeyday menkangangato ay papadi et adoado nan mangpabasbasolanda ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Dat kanan Pilato ken Jesus, “Ay maid isongbatmo? Ilam et adoado nan mangpabasbasolanda ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ngem egay sinmongbat si Jesus isonga am-amed nasdaaw si Pilato. ");
INSERT INTO xnn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tinew-en isnan Fiestan di Linmaosan di Anghel et nan ogalida et omipalobos nan gobilnadol is esay balod ay piliyen di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","(-) ");
INSERT INTO xnn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Isonga nadagop nan adoado ay ipogaw ay mendawat ken Pilato ta palobosana nan esay balod. ");
INSERT INTO xnn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dat kanan Pilato ken daida, “Ay laydenyo ta nan lobosak et nan naay alin di Judio?” ");
INSERT INTO xnn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tay gintekna ay aped inbalod nan menkangangato ay papadi si Jesus gapo is apalda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ngem nan deeyday menkangangato ay papadi et dinologda nan nadagop ay ipogaw ta si Barabas nan dawatenda ay bomala ta baken si Jesus. (v 7) Si Barabas et nakitapi ay nakigobat isnan gobilno isonga nabalod et wada nan pinateyna isnan nin-golowanda. ");
INSERT INTO xnn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dat kanan Pilato kasin isnan nadagop, “Ngan pay ngalod nan ikkak isnan kananyo en alin di Judio?” ");
INSERT INTO xnn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dadat asigigiyaw ay mangwani, “Ipalansam isnan kros.” ");
INSERT INTO xnn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ayta ay? Ngan nan ngawi ay inikkana?” kinwanin Pilato. Ngem am-amedda men-giyaw, “Ipalansam isnan kros.” ");
INSERT INTO xnn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kayten Pilato ay mapnek nan ipogaw isonga inpalobosna si Barabas danapay ipabaig si Jesus danat ited isnan sosoldado ta ilansada isnan kros. ");
INSERT INTO xnn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dat eyey nan sosoldado si Jesus isnan makwani en Preterio ay bangsal nan baey di gobilnadol. Dadat ayagan nan iib-ada ay sosoldado ");
INSERT INTO xnn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","dadat badowan si Jesus isnan men-gadangdang ay bado ay kaneg nan badon di ali. Dadat komawikaw is sibit et ipabedbedda isnan olona. ");
INSERT INTO xnn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dadat kankanan en, “Madayaw kano nan alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dadat menpalintomeng ay agindadayaw ken siya. Dadat ibaibaig nan pao isnan olona dadapay tobbatobbaan siya. ");
INSERT INTO xnn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Naomada pay ay mangselselat ken siya dadat kaanen san men-gadangdang ay badona et kasinda ipabado san sigod ay badona esadapay eyey ay mangilansa isnan kros. ");
INSERT INTO xnn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Issan mendad-aananda et sinab-atda nan esay lalaki ay si Simon ay iCirene ay aman da Alejandro ken Rufo. Nagapo si Simon isnan ilit ay omey koma id Jerusalem ngem dat ipapatin nan sosoldado ay mangipaawit ken siya isnan kros Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dadat eyey si Jesus id Golgota ay makwani en ingit di toktok. ");
INSERT INTO xnn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dadat painomen koma si Jesus is basi ay natapiyan is agas ay mira ay mangpaon-onina is sakit di awakna ngem adyana. ");
INSERT INTO xnn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dadat ilansa siya isnan kros. Dat menbobonot nan sosoldado is mangbingay isnan badona. ");
INSERT INTO xnn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nakag-aw ay alas nowibi nan nangilansaanda ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Inippeyda isnan ngangatowen nan olona nan naisolat ay basolna ay mangwani en, “Alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wada abes nan dowa ay mangakew ay inlansada isnan krosda isnan makanawan ya makanigid Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO xnn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nan lomal-aos et gilgilawenda si Jesus dadapay iwegweg nan oloda dadapay kanan, “Essem, sik-a od nan nangwani en bakasem nan Templon Apo Dios esakapay kasin esten isnan maikatlo ay agew. ");
INSERT INTO xnn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kadya, lomayogka isnan krosmo ta isalakam nan awakmo.” ");
INSERT INTO xnn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nan menkangangato ay papadi ya nan men-is-isolo isnan linteg et sinaysayotda si Jesus gedan dadapay kankanan, “Insalakana kano nan tap-in di ipogaw ngem adi makaisalakan isnan awakna. ");
INSERT INTO xnn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","No lomayogka isnan krosmo id wani et mamati kami ay sik-a si Kristo ay alin di Judio.” Olay nan dowa ay nailansa isnan krosda et nakisaysayotda gedan ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kag-aw ay tinmenga nan agew dat bomolinget nan batawa enggana ay inmalas tres isnan sedem. ");
INSERT INTO xnn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dat menbogaw si Jesus ay mangwani, “Eli, Eli lama sabaktani.” Nan kayatna ay kanan et, “Apo Dios ay Diosko, aytay damen taynan sak-en?” ");
INSERT INTO xnn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Et nan nangdedenge ay wada isdi et kananda, “Kanegna ay-ayagan din si Elias.” ");
INSERT INTO xnn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dat ikakamon nan esa ay omala is galot et itab-awna isnan basi danat igalot isnan pao danat ipangato ken Jesus ta sopsopana. Danapay kanan, “Ilaen tako mo omali si Elias ay mangkaan ken siya isnan krosna.” ");
INSERT INTO xnn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dat kasin menbogaw si Jesus dat maoyos nan leng-agna. ");
INSERT INTO xnn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Isnan Templo et nan menselelede ay koltina ay manglilingeb isnan nasantowan ay kowalto et aped mabisngat ay menlogi isnan ngato ay menpababa. ");
INSERT INTO xnn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nan kapitan di sosoldado ay tomatakdeg isnan sagang nan kros Jesus et inilana nan nakateyana danat kanan, “Tet-ewa obpay ay Anak Apo Dios siya.” ");
INSERT INTO xnn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wada abes nan bababai ay naiyaaddawi ay mangiila ken siya, ay da Maria Magdalena ya si Maria ay inan da Jose ken Santiago ya si Salome. ");
INSERT INTO xnn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Daida nan naknakkey ya nangbadbadang ken Jesus isdin nagapowana id Galilea. Wada gedan nan tap-in di bababai et daida nan nang-on-onod ken Jesus isnan inmayana id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Esapay magisbet isnan Biyalnis ay mensaganaan di Judio pala isnan obayada ");
INSERT INTO xnn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","et intotoled Jose ay iyArimatea ay omey ken Pilato ay mangdawat isnan awak Jesus. Si Jose et wada nan saadna tay esay ap-apon di Judio. Siya abes nan nangses-eed isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nasdaaw si Pilato issan nangwaniyana en natey et si Jesus isonga danat ayagan nan kapitan di sosoldado ta sootena no tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kinwanin nan kapitan en natey et si Jesus dat ipalobos Pilato ay alaen Jose nan awak Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Danat kaanen si Jesus isnan krosna et bongonena isnan linakowana ay balo ay galot danat eyey isnan nakakaongan ay bato. Danat seyatan nan segpana is dakdake ay bato. ");
INSERT INTO xnn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wada da Maria Magdalena ken Maria ay inan Jose ay mangiila isnan nangipay-ana. ");
INSERT INTO xnn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nakwas nan obayada ay Sabado dat omey da Maria Magdalena ken Maria ay inan Santiago ya si Salome ay lomako is agas ay menbango ta iyapowapda isnan awak Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wiit pay isnan Domingo dadat omey isnan naipay-an nan awak Jesus dadat omdan isdi isnan ostoy bomala nan agew. ");
INSERT INTO xnn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nintoytoyada isnan mendad-aananda ay mangwani, “Sino ngen nan mang-olin isnan bato ay naitangeb isnan liyang?” ");
INSERT INTO xnn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ngem idi dinmangda dadat ilan ay naolin san dakedake ay bato. ");
INSERT INTO xnn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dadat songgep isnan liyang dadat men-ila nan baballo ay tomotokdo isnan makanawan ay ninbabado is andoando ay polaw dadat ninkakikibtot. ");
INSERT INTO xnn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Danat kanan ken daida, “Adi kayo omegyat. Getkek ay an-anapenyo si Jesus ay iNazaret ay nailansa isnan kros ngem maid siya isna tay kasin natago. Ilanyo nan naipay-ana et maiwed siya. ");
INSERT INTO xnn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Enkayo et ta ibagayo ken da Pedro ya nan tap-in nan papasolot Jesus ta onodenda tay inmon-ona id Galilea. Et isdi nan mang-il-anda ken siya ay kaneg met laeng san inbagbagana ken daida.” ");
INSERT INTO xnn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dat bomala ay dagos san iinin-a dadat lomayaw tay menpaypayegpegda ya nasngangda. Ngem in-giginekda et maid polos nangibagaanda gapo isnan egyatda. ");
INSERT INTO xnn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Issan kasin natagowan Jesus ay wiit issan Domingo et nan inmona ay ninpail-ana et si Maria Magdalena ay din nangipakaanana isnan pito ay anito. ");
INSERT INTO xnn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dat omey si Maria issan papasolot Jesus ay daanda ay menseseg-ang ya men-ag-aga danat ibaga nan nang-il-ana ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngem olay dinngeda nan nangwaniyana en inilana si Jesus et egayda kayet patiyen ay kasin natago. ");
INSERT INTO xnn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nakwas pay di dat menpaila si Jesus isnan dowa ay papasolotna ay nindaan isnan ilit ngem natken nan nang-il-anda ken siya. ");
INSERT INTO xnn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Dadat somagong ay mangibaga isnan iib-ada ngem egayda patiyen. ");
INSERT INTO xnn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dat menpaila si Jesus isnan simpoo ya esa ay papasolotna isnan mangmangananda. Danat sagiiten daida tay egayda patiyen nan kinwanin nan inmona ay nang-ila ken siya ay kasin natago. Kega kinmenteg nan oloda. ");
INSERT INTO xnn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Danat kanan, “Omey kayo isnan kailiili isnan batawa ay mangibaga isnan gawis ay damag isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nan mangpati isnan gawis ay damag dadat mabonyagan et maisalakanda ta makiteteeda ken Apo Dios ay eng-enggana. Ngem nan adi mangpati et madosada tay awnit dosaen Apo Dios daida tay egay nakaan nan basolda. ");
INSERT INTO xnn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Et nan mangpati ken Apo Dios et awnitda ik-ikkan nan kaskasdaaw tapno maipagtek ay naitapi si Apo Dios ken daida. Siya dana nan awnitda ik-ikkan, pakaanenda nan anito ay kinmapet isnan ipogaw gapo isnan kabaelan nan ngadanko dadapay makakali isnan teken ay kali ay egayda solowen ");
INSERT INTO xnn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ya no bangten nan oweg daida ya no ominomda is kedet et maid ommat ken daida. Ya mo gen-anda nan awak nan mensakit et gomawisda.” ");
INSERT INTO xnn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nakwas ay binagbagaan Apo Jesus nan papasolotna dat ipangaton Apo Dios siya id daya et tomotokdo si Jesus isnan makanawana. ");
INSERT INTO xnn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dat omey nan papasolotna ay mangibaga isnan gawis ay damag isnan kailiili et badbadangan Apo Jesus daida ay mang-idya isnan kabaelana ken daida ay mang-ikkan isnan kaskasdaaw ta kagtekana ay tet-ewa nan ibagbagada. Siya dadi nan inom-ommat.");
INSERT INTO xnn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Gayyem Teofilo, Naay di sodsodok ay maipanggep ken Jesus ay isolatko ken sik-a. Nan ipogaw ay naknakkey ken Jesus ay nang-il-ila isnan am-in ay inik-ikkana enggana isdin damo et daida nan nangibaga isnan am-in ay inom-ommat isdin kad-ana isna tay daida nan nangipagpagtek isnan kaipoipogaw maipanggep ken Jesus. Issan nangdengngak is dana daket ipoot ay gawis ay mangsolo isnan am-in ay inom-ommat enggana isdin logiyana tay getkek ay adoado nan nangisolat isna ngem kanak en gawis no sak-en nan mang-eset ay mangisolat abes tapno getkem ay tet-ewa am-in nan dindinngem. ");
INSERT INTO xnn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Naay da nan inom-ommat. Isdin nintolayan Herod isnan probinsiya ay Judea et wada nan esay padi ay kangadan is Zacarias ay ib-an nan papadi ay kaapo isdin si Abias. Nan asawan Zacarias et si Elisabet ay anak gedan di padi. ");
INSERT INTO xnn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Gawis nan ogalida ay sin-asawa isnan pangiilaan Apo Dios tay pinatpatida am-in nan bilina. ");
INSERT INTO xnn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ngem maid anakda tay adi makaanak si Elisabet dadapay gedan nain-ina ya naam-ama. ");
INSERT INTO xnn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Isnan esay agew inomdan nan biyang da Zacarias ay mensilbi isnan Templo. ");
INSERT INTO xnn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nan ogalin di papadi et menbonotda no sino nan songgep isnan Templo ay mangpoo isnan insinso ay menbango et si Zacarias san nabonotan. ");
INSERT INTO xnn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Idi pop-oowana nan insinso, menlol-owalo abes nan kaipoipogaw isnan pantew. ");
INSERT INTO xnn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dat menpaila nan esay anghel Apo Dios ken siya ay tinmatakdeg isnan makanawan nan kapop-oowan nan insinso. ");
INSERT INTO xnn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nasngang si Zacarias isnan nang-ilaana ya palalo nan egyatna. ");
INSERT INTO xnn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ngem dat kanan san anghel ken siya, “Adika omegyat Zacarias. Inmaliyak ay mangibaga ken sik-a en dinngen Apo Dios nan lowalom et awnit omanak si Elisabet ay asawam is lalaki dakat ngadanan is Juan. ");
INSERT INTO xnn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Isnan maiyanakana et men-galalasing kayo ya nan ado ay ipogaw ");
INSERT INTO xnn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","tay awnit madaydayaw siya ken Apo Dios. Masapol ay adi omin-inom is bomoteng. Olay isnan kaililitonana et wada et nan Ispirito Santo ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Awnit adoado nan pasagongena ay Judio ken Apo Dios ay Diosda. ");
INSERT INTO xnn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Siya nan ibaan Apo Dios ay mangisagana isnan kaipoipogaw isnan esa omaliyan Kristo ay mangisalakan. Kaneg nan kabaelan ya silib din si Elias ay mamadton Apo Dios id kasin nan kabaelana. Awnit paolnosena nan nasis-iyan ay sin-am-a et pasagongena nan ipogaw ay adi mamati tapno gomawis nan nemnemda. Siya di nan ikkana ay mangipasagana isnan kaipoipogaw isnan omaliyan nan Apoda.” ");
INSERT INTO xnn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dat kanan Zacarias issan anghel, “Ay ngan di manggetkak ay tet-ewa ay ommatna dapay naam-amaak ya nain-ina si asawak?” ");
INSERT INTO xnn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kinwanin san anghel en, “Getkem tay sak-en si Gabriel ay esay bab-aaen Apo Dios et binaana sak-en ay mangibaga ken sik-a isnan naay gawis ay ommat. ");
INSERT INTO xnn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ngem gapo tay adika patiyen nan kinwanik et maomelka enggana ay omdan nan agew ay ommatana tay tet-ewa ay ommat isnan osto ay timpona.” ");
INSERT INTO xnn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Isnan pantew di Templo et masmasdaaw nan kaipoipogaw ay mangses-eed ken Zacarias tay adi bomalbalbala. ");
INSERT INTO xnn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngem issan binmalaana dat mensinsinyas ken daida tay adi makakali isonga getkenda ay wada nan ninpaila ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nakwas pay san talabakona isnan Templo dat somaa. ");
INSERT INTO xnn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Egay pay nabayag daet maliton si Elisabet et limay bowan ay ninlolololokok is baeyda. ");
INSERT INTO xnn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Danat kanan, “Men-gasingak tay sineg-angan Apo Dios sak-en et kinaana nan maibabainak isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Issan maikan-em ay bowan nan liton Elisabet dat kasin ibaan Apo Dios si Gabriel ay anghel isnan ili ay Nazaret isnan probinsiya ay Galilea ");
INSERT INTO xnn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ta omey isnan babassang ay kangadan is Maria ay naitoya ay makiasawa ken Jose ay esay apon din si Ali David. Dat menpaila si Gabriel ken Maria et kanana, ");
INSERT INTO xnn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","“Men-gasingka. Nagasatka ay babai tay sik-a nan pinilin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pilmi ay madanagan si Maria issan inbagan san anghel et nemnemnemena mo ngan nan kayatna ay kanan. ");
INSERT INTO xnn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ngem dat kanan san anghel, “Adika omegyat Maria tay tet-ewa ay pinabolan Apo Dios sik-a. ");
INSERT INTO xnn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Awnit malitonka et omanakka is lalaki dakayot ngadnan is Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Awnit kangangatowan siya ay makwani en Anak Apo Dios ay kangatowan ya patolayen Apo Dios siya ay kaneg din alapona ay si Ali David id kasin ");
INSERT INTO xnn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","et siya nan men-alin di Judio ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Dat kanan Maria issan anghel, “Ngem intoy ikakkana ay malitonanak dapay maid polos kaseyseyepko is lalaki?” ");
INSERT INTO xnn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dat kanan san anghel, “Nan Ispirito Santo nan awnit omali ken sik-a isonga nan panakabalin Apo Dios nan mangtakdo ken sik-a. Siya na nan kakwaniyan nan anakmo en Anak Apo Dios ay maid polos basbasolna. ");
INSERT INTO xnn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kaneg si Elisabet ay agiyo ay makwani en adi omanak et enem ay bowan nan litona id wani dapay nain-ina. ");
INSERT INTO xnn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tay am-in et kabaelan Apo Dios ay ikkan.” ");
INSERT INTO xnn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Dat owenan Maria et kanana, “Owen. Maikkan ken sak-en nan inbagam tay baan Apo Dios sak-en.” Dat komaan san anghel. ");
INSERT INTO xnn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nakwas pay nan kaat ay agew dat ikakamon Maria et omey isnan baey da Zacarias ay wada isnan esay ili id Judea isnan bilbilig. ");
INSERT INTO xnn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Omdan pay danat kanan ken Elisabet, “Inmaliyak ay mang-ila ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Issan nangdengngan Elisabet isnan kalin Maria dat menkiwi nan onga isnan egesna et takdowen nan Ispirito Santo siya ay mang-itdo isnan kanana. ");
INSERT INTO xnn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dat ibiyad Elisabet ay mangwani, “Isnan am-in ay bababai et sik-a nan kagasatan tay sik-a nan pinilin Apo Dios ya nan awnitmo iyanak abes nan kagasatan. ");
INSERT INTO xnn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nagasatak tay inmalika ay inan Kristo ay Apok. ");
INSERT INTO xnn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tay nan nangdengngak isnan kalim dat menkiwi nan onga isnan egesko gapo isnan gasingna. ");
INSERT INTO xnn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kaneg ken sik-a abes men-gasingka tay patiyem ay awnit tomet-ewa nan inbagan Apo Dios ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dat kanan Maria, “Dadama nan panangdayawko ken Apo Dios ");
INSERT INTO xnn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","et men-gasingak ken siya ay mangisalsalakan ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tay nenemnemena sak-en ay baana. Et menlogi id wani kanan am-in nan ipogaw en nagasatak ");
INSERT INTO xnn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gapo isnan kaskasdaaw ay inikkan nan manakabalin ay Dios ken sak-en isonga madaydayaw nan ngadana. ");
INSERT INTO xnn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maseg-ang isnan am-in ay mangdayaw ken siya enggana isnan ipogaw id sang-adom ya nan awnit maiyanak. ");
INSERT INTO xnn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inpailana nan panakabalina danapay bokaen nan ipogaw ay mangipapangato isnan nemnemda ya nan nemnemnemenda ay ikkan. ");
INSERT INTO xnn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inpababana nan ninkangangato ay ali danapay pangatowen nan napakombaba ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Inagtana nan kaseseg-ang is masapolda danapay pakaanen nan babaknang ay maid polos gegen-anda. ");
INSERT INTO xnn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Badbadangan Apo Dios nan ipogawna ay datako ay Judio ay eng-enggana tay egayna kinalkalingkingan din inkalina ken Abraham ya nan an-akna ay alal-apo tako. Tay kinwanina en seg-angana daida ya datako ay ap-oda ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nakitetee si Maria is toloy bowan ken da Elisabet esapay somaa. ");
INSERT INTO xnn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Inomdan nan omanakan Elisabet dat omanak is lalaki. ");
INSERT INTO xnn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Issan nangdengngan nan sagsagogongda ya nan ag-ida issan kaskasdaaw ya kagagasing ay inikkan Apo Dios ken siya dadat omey am-in makigasgasing. ");
INSERT INTO xnn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nan ogalin di Judio et no maikawao ay agew nan onga dat madagop nan ag-ida et segyatanda dadapay ngadnan. Sinegyatanda san onga et ipangadanda koma nan ngadan amana ay Zacarias ");
INSERT INTO xnn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ngem dat kanan inana en, “Baken sa. Nan ngadana et Juan.” ");
INSERT INTO xnn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dadat kanan ken siya, “Ayta? Dapay maid polos apo tako is kangadan is Juan.” ");
INSERT INTO xnn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dadat isinyas ken amana ay mangsoot no sino nan kayatna ay ngadan nan onga. ");
INSERT INTO xnn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dat menpaala si Zacarias is mensolatana et isolatna, “Nan ngadana et Juan.” Et nasdaawda am-in ay wada isdi issan nangbasaanda. ");
INSERT INTO xnn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dat makanali si Zacarias ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Am-in nan sagogongda et nasdaawda isnan inommat dadat ibaag isnan am-in ay il-ili isnan bilig id Judea. ");
INSERT INTO xnn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Am-in nan nangdenge et getkenda ay wada nan panakabalin Apo Dios ken Juan dadat men-asisoot, “Ay ngan ngata nan menbalinan nan onga ay naay?” ");
INSERT INTO xnn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si aman Juan ay Zacarias et tinakdon nan Ispirito Santo danat kanan en, ");
INSERT INTO xnn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Madaydayaw si Apo Dios ay Dios tako ay Judio tay inmali ay mangbadang isnan ipogawna danapay sobten daida ta adida madosdosa gapo isnan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Inbaana nan manakabalin ay apon din si David ay mangisalakan ken datako. ");
INSERT INTO xnn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","72","Si tona din inbagana id kasin ay awnit mangisalakan ken datako isnan am-in ay mang-aamis. Tay inbagan Apo Dios id kasin ay kanan din mamadtona en awnit badbadangana nan alal-apo tako et adina kalkalingkingan nan nasantowan ay tolagda. ");
INSERT INTO xnn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Inkalin Apo Dios id sang-adom ken Abraham ay alapo tako ay siya nan awnit mangilisi isnan mang-aamis ken datako tasiyay adi tako omegyat ay mensilbi ken siya ya ta maid il-ilaena is kolang wenno ngawi ay ik-ikkan tako engganay matey tako.” ");
INSERT INTO xnn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dat itoloy Zacarias ay mangwani, “Sik-a ay anakko et awnitka makwani en mamadton nan Kangatowan ay si Apo Dios. Tay awnit mang-on-onaka mo nan Apo tako ta isaganam nan ipogaw isnan omaliyana ");
INSERT INTO xnn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","tay omeyka ay mangibaga isnan ipogawna en awnit maisalakanda isnan kapakawanan nan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Nan Dios tako et managseg-ang ya naanos. Isonga awnit omali nan mangisalakan ken datako. Kaneg siya nan silaw ay nagapo id daya tay silawana nan ipogaw ay kaneg natey ay maisisiyan ken Apo Dios tay menbolinget nan nemnemda. Et siya nan mangsilaw isnan daan tako ay omey isnan gawis,” kinwanin Zacarias. ");
INSERT INTO xnn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nasiken si Juan ay masilib ya mamati ken Apo Dios dat omey mentetee isnan bilig engganay inomdan nan menpailaana ay men-isolo isnan Judio. ");
INSERT INTO xnn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Isdin nawad-an Juan et wada nan bilin nan ali id Roma ay si Cesar Augusto ay omey am-in nan ipogaw ay menpalista isnan il-ilida. ");
INSERT INTO xnn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siya na din damdamo ay ninpalistaan di ipogaw isdin kagobilnadol Kirenio isnan probinsiya ay Siria. ");
INSERT INTO xnn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Daet wasdin omey menpalista isnan ilin di alal-apoda id sang-adom. ");
INSERT INTO xnn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Jose abes ay nagapo id Nazaret ay esay ili id Galilea et inmey menpalista id Betlehem ay esay ili id Judea ay ilin din si Ali David. Siya nan inmayana tay siya et apon din si Ali David. ");
INSERT INTO xnn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Si Maria et nakkey ken Jose ay menpalista tay naitoya ay men-asawada. Maliton si Maria ");
INSERT INTO xnn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","et isnan kawad-anda id Betlehem dat padongen san onga ay bomala ");
INSERT INTO xnn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ngem maid somya is menteanda isnan pag-abangan ay baey tay nanapno is ipogaw isonga dadat omey isnan kolongan di bakbaka. Et isdi nan nangiyanakana isnan damo ay anakna ay lalaki danat ewesan et papodanena isnan pangpanganan di baka. ");
INSERT INTO xnn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Issan labi issan deey ay ili et wadada nan menpaspastol isnan pondag ay mangbanbantay isnan kakalnikalniloda. ");
INSERT INTO xnn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dat menpaila nan esay anghel Apo Dios ken daida et matanggewanda isnan silang Apo Dios dat palalo nan egyatda. ");
INSERT INTO xnn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ngem dat kanan san anghel ken daida, “Adi kayo omegyat. Tay wada nan gawis ay ipadamagko ken dakayo ay mangpagasing isnan am-in ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Siya na nan ipadamagko, id wani ay labi et naiyanak si Kristo ay Apo tako isnan ilin din si David et siya nan mangisalakan isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nan pangilasinanyo et nan awnityo datngan ay onga ay naeewesan ay aped naipapapodan isnan pangpanganan di baka.” ");
INSERT INTO xnn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Daet menpaila nan adoado ay anghel ay mangdaydayaw ken Apo Dios ay mangmangwani en, ");
INSERT INTO xnn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Madaydayaw si Apo Dios ay wada id daya tay binmala si Kristo ay mangipasingpa isnan ipogaw isnan batawa ay mangipagasing ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Issan ninsagongan san aanghel id daya et nin-asikwani san menpaspastol en, “Omey tako ilan nan onga id Betlehem ay inpagtek Apo Dios ken datako.” ");
INSERT INTO xnn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dadat ikakamo ay omey et datnganda da Maria ken Jose ya san onga ay naipapapodan isnan pangpanganan di baka. ");
INSERT INTO xnn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Issan nang-ilaanda issan onga dadat sodoken san inbagan san anghel maipanggep ken siya ");
INSERT INTO xnn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","et nasdaaw am-in nan nangdenge. ");
INSERT INTO xnn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngem si Maria et ninenemnemna am-in nan inommat ya nan inbagan nan menpaspastol. ");
INSERT INTO xnn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dat somaa san deeyday menpaspastol ay menkankanta ay mangdaydayaw ken Apo Dios tay inilada san onga et tet-ewa am-in san inbagan san anghel ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Issan maikawao ay agew san onga dadat segyatan dadapay ngadnan tay siya nan ogalin di Judio. Nan inpangadanda et Jesus tay siya san inbagan di anghel esapay mainginaw. ");
INSERT INTO xnn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Inomdan pay nan mangtongpalan da Jose ken Maria isnan bilin Apo Dios ay insolat din si Moses id kasin maipanggep isnan babai ay kaan-anak dadat omey id Jerusalem. Tay kanan san bilin en masapol ay omyeyda is ilimosda is mapalti ay doway tala wenno doway anak di kalapati isnan Templo tay siya nan kadalosan nan kaan-anak. Inyeyda gedan si Jesus ta idatonda ken Apo Dios. Tay nan bilin Apo Dios et am-in ay damo ay anak ay lalaki et masapol ay maidaton ken siya ay kaneg siya nan kaanak. ");
INSERT INTO xnn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Id Jerusalem wada nan esay am-ama ay kangadan is Simeon ay mangses-eed isnan kaisalakanan nan Judio. Gawigawis nan ogalina tay patiyena nan bilin Apo Dios ya daydayawena siya. Tinakdon nan Ispirito Santo siya ");
INSERT INTO xnn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ay nangipagtek ken siya en adi matmatey enggana ay ilana nan inkalin Apo Dios ay awnit omali ay si Kristo. ");
INSERT INTO xnn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Issan kad-an da Jose ken Maria id Jerusalem inpangon nan Ispirito Santo si Simeon isnan Templo dat isgep abes da Maria ken Jose si Jesus ta ikkanda nan linteg ay inbilin Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dat akwaen Simeon nan onga dapay mendayaw ken Apo Dios ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Apo, id wani et tinmet-ewa nan inpagtekmo gapo isnan naay onga isonga mang-apitka et tay naay inilak nan inbagam ay awnit omali ay mangisalakan isnan ipogaw, ay siya nan inbaam tapno getken am-in nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kaneg siya nan silaw ay mang-itdo olay isnan baken Judio tapno ilaenda nan daan ay omey ken sik-a. Isonga gapo isnan onga ay naay awnit madayaw nan Judio.” ");
INSERT INTO xnn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nasdaaw da Jose ken Maria isnan kinwanin Simeon maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Binindisyonan Simeon daida danapay kanan ken Maria, “Nan onga ay naay et siya nan kadadaelan nan ado ay Judio ya kaisalakanan nan tap-ina. Maila gedan ken siya ay tet-etet-ewa nan am-in ay inbagan Apo Dios ngem adoado nan mang-adi ken siya et siya nan kagtekan nan ngawi ay nemnemda. Ngem ken sik-a, Maria, awnitmo liknaen nan sakit di nemnem ay kanega waday naitbek isnan pagaewmo gapo isnan ommat ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wada id sidi gedan si Ana ay nain-iin-ina ay mamadton Apo Dios. Siya et anak Panuel ay apon din si Aser. Pitoy tew-en ay nin-aasawa da Ana ken asawana ");
INSERT INTO xnn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","et waompoo ya epat ay tew-ena ay nabalo. Wedweda ay mentetee isnan Templo tay inagew ya linabi ay menteptepe ay menlol-owalo ya mendaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Isdin nangisgepanda ken Jesus et wada gedan si Ana isdi ay nin-iyaman ken Apo Dios maipanggep isnan onga danat sodsodoken nan onga isnan ipogaw ay mangses-eed isnan mangsobotan Apo Dios isnan ipogaw id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Issan nakwasan san inkanda ay inbagan san linteg Apo Dios et sinmagongda isnan ilida id Nazaret ay sakop di probinsiya ay Galilea. ");
INSERT INTO xnn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nasiken si Jesus ay napigsa ya masilib tay nan badang Apo Dios et wada ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tinew-en ay omey da Jose ken Maria id Jerusalem isnan Fiestan di Linmaosan di Anghel. ");
INSERT INTO xnn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Et issan maikasimpoo ya doway tew-en Jesus, inmeyda kasin tay siya nan ogalida. ");
INSERT INTO xnn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Issan nakwasan san fiesta dadat menlobwat ay somaa ngem dat obpay mataynan si Jesus id Jerusalem et adi getken da inana ay nataynan ");
INSERT INTO xnn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","tay kananda en waay naiboweg isnan bowegda. Esay agew nan nindaananda esadapay getken ay maid siya dadat omey anapen isnan ag-ida ngem maid. ");
INSERT INTO xnn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dadat somagong id Jerusalem ay mang-anap ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Isnan maikatlo ay agew, dinas-anda siya isnan Templo ay makitotokdo isnan men-is-isolo isnan linteg. Dedengngena nan kankananda dapay mensos-oot ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nasdaaw am-in nan mangdedenge ken siya gapo isnan silibna tay ostoosto nan isongsongbatna ya kankanana. ");
INSERT INTO xnn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nasdaaw gedan da inana issan nang-ilaanda ken siya danat kanan, “Anakko, dakan egay naiboweg ken dakami? Madadanagan kami ken amam ay mang-an-anap ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ngem dat kanan Jesus, “Dakayon mang-an-anap? Ay adiyo getken ay masapol ay wadaak isnan baey Ama?” ");
INSERT INTO xnn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ngem adida maawatan nan kankanana ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dat makkey si Jesus ken da inana et somaada id Nazaret et pinatpatina am-in nan inbagbagada ken siya. Si inana et egayna kinalkalingkingan am-in nan inom-ommat. ");
INSERT INTO xnn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nasiken si Jesus ay napigsa ya masilib et laylayden Apo Dios ya nan kaipoipogaw siya. ");
INSERT INTO xnn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Isdin maikasimpoo ya lima ay tew-en ay mentolayan Cesar Tiberio et wada nan inpaliknan Apo Dios isnan anak Zacarias ay si Juan ay mentetee isnan bilig. Siya na gedan din kagobilnadol nan epat ay naayda; si Poncio Pilato id Judea, si Herod id Galilea, nan besat Herod ay si Felipe id Iturea ya id Traconite ya si Lisanias id Abeline. Nan kangatowan ay papadi id Jerusalem issan deey ay tew-en et da Anas ken Caifas. ");
INSERT INTO xnn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Si Juan et inmeyna sinolsol am-in nan sakop nan ginawang ay Jordan ay mangibagbaga, “Masapol ay dokoganyo nan basbasolyo dakayopay menpabonyag tay siya nan kail-an nan kakaanan di basol.” ");
INSERT INTO xnn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nan inikkan Juan et siya nan nangtongpalana isnan insolat din si Isaias ay mamadton Apo Dios ay kanana en, “Wada isnan bilbilig nan mangibogbogaw en isaganayo nan daanen nan Apo tako ay awnit omali. Pagawisenyo nan daan ay mendaanana. ");
INSERT INTO xnn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","No nadodontog ya nakakaongan et masapol ay simpaenyo. No abes natikotiko et paletgenyo ya nan ngawi ay daan et estenyo. ");
INSERT INTO xnn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tapno am-in ay ipogaw et ilaenda nan ibaan Apo Dios ay mangisalakan ken daida.” ");
INSERT INTO xnn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Adoado nan ipogaw ay inmey ken Juan ay menpabonyag danat kanan ken daida, “Dakayo ay aginsosolot ken Apo Dios, ay kananyo en omanay nan mabonyaganyo is kaisalakananyo isnan awnit mendosaan Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngem adi kayo aped mabonyagan mo adiyo dokogan nan ngawi ay ogaliyo tay masapol ay ipailayo ay tet-ewa ay inbabawiyo nan basbasolyo. Et adiyo kanan en mailisi kayo isnan dosan Apo Dios gapo tay apoyo din si Abraham ay baan Apo Dios. Ngem baken di is mangilisi ken dakayo tay olay nan bato ay naay et mabalin ay menbalinen Apo Dios is ap-on Abraham.” ");
INSERT INTO xnn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dat itoloy Juan ay mangwani en, “Nan awnit idosan Apo Dios et siya nan kaneg nan wasay ay naisagsagana ay mangpoyo isnan kaiw. Am-in ay kaiw ay adi bomgas is gawis et mapoyo dat mapoowan. Et dakayo nan kaneg nan kaiw ay adi bomgas.” ");
INSERT INTO xnn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dat sooten nan kaipoipogaw ken siya, “Ay ngan ngalod nan ikkanmi?” ");
INSERT INTO xnn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sinmongbat si Juan, “Nan dowa nan badona et idyana nan esa isnan maid badona ya nan wada nan kanenda et agtanda nan ib-ada ay maid kanenda.” ");
INSERT INTO xnn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Inmey abes nan ib-an di mensingsingil is bowis ay menpabonyag dadat sooten ken Juan, “Apo, ay ngan nan masapol ay ikkanmi?” ");
INSERT INTO xnn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Adi kayo mensingsingil is sobla nodi nan ostoosto nan singilenyo,” insongbatna ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dat abes sooten nan sosoldado, “Dakami pay abes ay ngan nan ikkanmi?” Danat kanan, “Adiyo paeg-egyaten ya pabasbasolen nan ipogaw ay aped mangkikikil ken daida ya masapol od ay mapnek kayo isnan lagboyo.” ");
INSERT INTO xnn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","San kaipoipogaw ay nangdenge issan kinkinwanin Juan et nasdaawda ya inpagalopda ay siya nan Kristo ay inbagan Apo Dios id sang-adom en awnit omali. ");
INSERT INTO xnn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ngem kinwanin Juan ken daida, “Bakenak si Kristo. Ngem wada siya ay omon-onod et gapo isnan kawedwedana et adiyak maibilang ay mangkaan isnan sapatosna. Danom nan ibonyagko ken dakayo ngem awnit bonyagana dakayo isnan Ispirito Santo ya nan apoy. ");
INSERT INTO xnn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","No omali siya et awnitna mensiyanen nan mamati ken siya isnan adi mamati et kaneg waday ligao ken siya ay mangtap-ana isnan pagey danat idolin isnan agamang nan mabgas danapay igwa nan kipit isnan apoy ay adi katkatkatey.” ");
INSERT INTO xnn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Siya na ya adoado pay nan inbagbagan Juan isnan kaipoipogaw isnan mang-it-itdowana ken daida isnan gawis ay damag tapno getkenda ay mensagana isnan omaliyan Kristo. ");
INSERT INTO xnn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Olay si Gobilnadol Herod et iniyaw Juan gedan tay apedna inasawa nan aydona ay si Herodias dapay daan nan asawana ay innodin Herod ya iniyawna gedan nan tap-in di ngawi ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ngem dat am-amed somokil si Herod et paibalodna si Juan. ");
INSERT INTO xnn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Issan nangbonyagan Juan issan kaipoipogaw dat menpabonyag abes si Jesus. Issan nabonyagan Jesus dat menlowalo ken Apo Dios et issan menlol-owalowana et napewak id daya dat lomayog nan Ispirito Santo ay kaneg kalapati et pomatong ken siya. Dat wada nan kali ay nagapo id daya ay mangwani en, “Sik-a nan Anakko ay laylaydek. Men-galalasingak gapo ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Si Jesus et waay tolompoo nan tew-ena esanapay ilogi ay men-isolo. Siya nan anak Jose, kanan nan kaipoipogaw. Naay nan ngadngadan nan alal-apon Jose. Si Jose, anak Eli. ");
INSERT INTO xnn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Eli, anak Matat; si Matat, anak Levi; si Levi, anak Melki; si Melki, anak Jane; si Jane, anak Jose; ");
INSERT INTO xnn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","si Jose, anak Matatias; si Matatias, anak Amos; si Amos, anak Nahum; si Nahum, anak Esli; si Esli, anak Nage; ");
INSERT INTO xnn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","si Nage, anak Maat; si Maat, anak Matatias; si Matatias, anak Semei; si Semei, anak Jose; si Jose, anak Juda; ");
INSERT INTO xnn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","si Juda, anak Joana; si Joana, anak Resa; si Resa, anak Zorobabel; si Zorobabel, anak Salatiel; si Salatiel, anak Neri; ");
INSERT INTO xnn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","si Neri, anak Melki; si Melki, anak Adi; si Adi, anak Cosam; si Cosam, anak Elmodam; si Elmodam, anak Er; ");
INSERT INTO xnn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","si Er, anak Josue; si Josue, anak Eliezer; si Eliezer, anak Jorim; si Jorim, anak Matat; si Matat, anak Levi; ");
INSERT INTO xnn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","si Levi, anak Simeon; si Simeon, anak Judas; si Judas, anak Jose; si Jose, anak Jonan; si Jonan, anak Eliakim; ");
INSERT INTO xnn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","si Eliakim, anak Melea; si Melea, anak Mena; si Mena, anak Matata; si Matata, anak Natan; si Natan, anak David; ");
INSERT INTO xnn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","si David, anak Jesse; si Jesse, anak Obed; si Obed, anak Booz; si Booz, anak Salmon; si Salmon, anak Naason; ");
INSERT INTO xnn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","si Naason, anak Aminadab; si Aminadab, anak Aram; si Aram, anak Arni; si Arni, anak Esron; si Esron, anak Fares; si Fares, anak Juda; ");
INSERT INTO xnn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","si Juda, anak Jacob; si Jacob, anak Isaac; si Isaac, anak Abraham; si Abraham, anak Tare, si Tare, anak Nacor; ");
INSERT INTO xnn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","si Nacor, anak Serug; si Serug, anak Ragau; si Ragau, anak Peleg; si Peleg, anak Heber; si Heber, anak Selah; ");
INSERT INTO xnn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","si Selah, anak Cainan; si Cainan, anak Arfaxad; si Arfaxad, anak Sem; si Sem, anak Noah; si Noah, anak Lamec; ");
INSERT INTO xnn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","si Lamec, anak Matusalem; si Matusalem, anak Enoc; si Enoc, anak Jared; si Jared, anak Mahalaleel; si Mahalaleel, anak Cainan; ");
INSERT INTO xnn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","si Cainan, anak Enos; si Enos, anak Set; si Set, anak Adam; si Adam, anak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tinakdon nan Ispirito Santo si Jesus issan nabonyagana isnan ginawang ay Jordan danat ipango siya isnan bilig. ");
INSERT INTO xnn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Omdan pay issan bilig dat padasen Satanas ay mangdoldolog ken siya isnan epatpoo ay agew. Egay nangnangan si Jesus isnan deeyday agew et naowaowat siya issan nakwasana. ");
INSERT INTO xnn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dat ilogin Satanas ay mangdolog ken siya ay mangwani en, “No tet-ewa ay Anak Apo Dios sik-a dakat kanan ta maboliw nan naay bato is makan.” ");
INSERT INTO xnn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dat songbatan Jesus ay mangwani en, “Kanan nan naisolat ay kalin Apo Dios en baken makan et kedeng di katagowan di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dat ipangon Satanas si Jesus isnan ataatakdag ay bilig danat ipaila ken siya is sin-awyan nan am-in ay ili isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Dat kanan Satanas, “Idyak ken sik-a am-in dana ya nan kinabaknangda tay kowak am-in datona et mabalin ay idyak isnan olay sino ay laydek ay mang-idyaan. ");
INSERT INTO xnn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kowam am-in datona no sak-en nan dayawem ay apom.” ");
INSERT INTO xnn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ngem sinmongbat si Jesus et kanana, “Kanan nan naisolat ay kalin Apo Dios en, ‘Sak-en ay Diosyo nan daydayawenyo ya mensilsilbiyanyo et kedeng.’” ");
INSERT INTO xnn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dat kasin ipangon Satanas si Jesus id Jerusalem danat eyey siya isnan toktok di Templo danat kanan ken siya, “No tet-ewa ay Anak Apo Dios sik-a, kadya lomabtokka isna. ");
INSERT INTO xnn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tay kanan nan naisolat ay kalin Apo Dios en bilinena nan aanghelna ta ayowananda ay ");
INSERT INTO xnn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mangtapaya ken sik-a ta adi masogatan nan dapanmo isnan bato.” ");
INSERT INTO xnn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ngem dat songbatan Jesus siya ay mangwani, “Nan naisolat ay kalin Apo Dios et kanana gedan en adiyo dologen si Apo Dios ay Apoyo.” ");
INSERT INTO xnn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nakwas pay san nangpadpadasan Satanas ay nangdoldolog ken Jesus danat taynan siya ta enggana is mamingsan kasin. ");
INSERT INTO xnn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sinmagong si Jesus id Galilea et wada nan kabaelan nan Ispirito Santo ken siya isonga mendinamag isnan kailiili nan inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nin-is-isolo siya isnan kasinasinagoga et daydayawenda am-in siya. ");
INSERT INTO xnn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Inmey si Jesus isnan nasiknana ay ili ay Nazaret. Sinabado ay obayan di Judio dat isnan esay Sabado et inmey siya isnan sinagoga tay siya nan sigod ay ogalina. Dat tomakdeg ay mangibasa isnan kalin Apo Dios ");
INSERT INTO xnn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","isonga dadat ited nan insolat nan mamadto ay din si Isaias danat bilagen et datngana nan naisosolat ay naay, ");
INSERT INTO xnn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wada nan Ispirito Santon Apo Dios ken sak-en tay pinilina sak-en ay mangipagtek isnan gawis ay damag isnan kodokdo. Inbaana sak-en ay mangbadang isnan maligligatan ta mapalobosan nan balod ya makaila kasin nan kollaw ");
INSERT INTO xnn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ya mangipagtek isnan awnitna mangisalakanan isnan ipogawna.” ");
INSERT INTO xnn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Linolon Jesus san mabasbasa danat isagong isnan mensilsilbi dat tomokdo et men-isolo. Am-in nan ipogaw issan sinagoga et inenengnengda siya. ");
INSERT INTO xnn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Danat ilogi ay mangwani ken daida, “Tinmet-ewa id wani ay agew san dinngeyo ay binasak ay naisosolat ay kalin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Laylayden am-in nan ipogaw siya gapo isnan gawis ay inbagbagana ngem nasdaawda dadat kanan, “Ay baken kad na san anak Jose ay kailiyan tako?” ");
INSERT INTO xnn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Danat kanan ken daida, “Waay nenemnemenyo nan kankanan nan ipogaw isna ay nan men-ag-agas et masapol ay agasana nan awakna esapay mamati nan ipogaw isnan agasna. Kaneg todi nan nemnemyo tay kaytenyo ay ikkak abes isna nan dinngeyo ay inik-ikkak id Capernaum. ");
INSERT INTO xnn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ngem kanak ken dakayo en am-in ay ipogaw et patpatgenda nan mamadto isnan nateketeken ay ili ngem isnan osto ay ilina et adi patgen nan kailiyana siya. ");
INSERT INTO xnn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kaneg din timpon Elias ay mamadto ay egay polos omod-odan is toloy tew-en ya kagedwa dat menbitil am-in ay ili id Israel. Wada nan ado ay balo issan deey ay ilida ");
INSERT INTO xnn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ngem egay inbaan Apo Dios si Elias ay mangbadang ken daida ay Judio nodi kedeng nan esa ay balo ay iSerepta is binadangana isnan ili id Sidon. ");
INSERT INTO xnn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dat kaneg abes din timpon Eliseo ay esay mamadto et ado nan nakolit ay kailiyana id Israel dapay maid olay esa ken daida is inpagawisna nodi kedkedeng si Naaman ay iSiria is pinagawisna.” ");
INSERT INTO xnn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Palalo nan liget am-in nan ipogaw issan sinagoga issan nangdengnganda issan kinwanin Jesus tay kailiyana daida. ");
INSERT INTO xnn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dadat tomakdeg et goyodenda si Jesus ay mangibala dadat iyey isnan toktok di bilig ay benget di ilida ta tekdagenda koma siya isnan deppas. ");
INSERT INTO xnn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ngem dat kayet idaan Jesus isnan tengan nan napoponokanda et komaan. ");
INSERT INTO xnn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Linmayog si Jesus id Capernaum ay esay ili isnan probinsiyan di Galilea dat men-isolo isnan sinagoga isnan Sabado ay obayan di Judio. ");
INSERT INTO xnn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nasdaawda issan inikkan Jesus ay men-isolo tay inpailana nan kabaelana. ");
INSERT INTO xnn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Issan deey ay sinagoga et wada nan am-ama ay kinapet di makedse ay anito dat menbogaw is napinapigsa, ");
INSERT INTO xnn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ine. Jesus ay iNazaret, ay ngan di ngotom ken dakami? Ay dadaelem dakami? Getkek sik-a. Sik-a nan nasantowan ay inbaan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ngem dat kanan Jesus issan anito, “Igiginekmo. Taynam si tosa.” Dat men-idogos san anito san am-ama et matokang isnan sasagangenda danapay taynan siya ay maid inommat. ");
INSERT INTO xnn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nasdaawda am-in san nangiila dapay wasdin mangwani, “Ay ngan ngen nan wada ken tona? Dan kabaelana ay mangipakaan isnan makedse ay anito?” ");
INSERT INTO xnn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Siya di nan inikkan Jesus isonga nindinamag isnan am-in ay ili isdi. ");
INSERT INTO xnn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tinaynan Jesus san sinagoga et omey isnan baey da Simon. Nan katogangan Simon isdi et menpodpodot dadat ibaga ken Jesus en mensakit siya. ");
INSERT INTO xnn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Dat sag-enen Jesus san in-ina et pagawisena san podotna dat mabanangon san in-ina et pakanena daida. ");
INSERT INTO xnn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nakwas et nan obayada issan naonogan di agew isonga dat iyey nan omili nan am-in ay wada nan sakitda ken Jesus danat sag-es-aen ay mang-egen ken daida dat gomawis nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nan anito gedan et tinaynanda nan ipogaw ay kinapetda dadapay ibogbogaw, “Sik-a nan Anak Apo Dios.” Daet paginken Jesus daida tay adina layden ay daida nan mangipagtek en siya nan Kristo. ");
INSERT INTO xnn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Issan kawakgatana et nasapa si Jesus ay inmey isnan bilig ngem omey kayet an-anapen nan ipogaw siya. Dadat datngan siya et adida ipalobos ay taynana daida. ");
INSERT INTO xnn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ngem danat kanan, “Masapol ay omeyak abes isolo isnan teken ay ili nan gawis ay damag maipanggep isnan mentolayan Apo Dios tay siya nan nangibaaana ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Isonga dat omey men-isolo isnan kasinasinagoga ay paggimongan di Judio. ");
INSERT INTO xnn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Issan namingsan ay nin-isolowan Jesus isnan benget di baybay id Genesaret et natogop nan kaipoipogaw isnan kad-ana et mendindinogosda tay kayatda ay dengngen nan kalin Apo Dios ay isolona. ");
INSERT INTO xnn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Maid somya is tomakdegan Jesus danat ilaen nan doway bangka ay ninbebenget isnan baybay ay tinaynan nan mensidsidok tay inmeyda inowasan nan sidokda. ");
INSERT INTO xnn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dat omey si Jesus issan bangkan nan esay mensidsidok ay si Simon danat ibaga ken siya ta iyad-addawina is bassit isnan benget di baybay tasiyay tomokdowana ay mangisolo isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nakwas pay ay nin-isolo danat kanan ken Simon, “Ipagawgawam nan bangkam isnan kaadaeman nan baybay ta mensidok kayo.” ");
INSERT INTO xnn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dat kanan Simon, “Apo, inlalabimi ay ninsidsidok dapay maid polos inalami ngem no siya say kanam et ikkanmi.” ");
INSERT INTO xnn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dadat oy-oyen nan sidok et adoado nan inalada ay ikan et nganngani ay mabakas nan sidok isonga adida makaipangato. ");
INSERT INTO xnn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dadat wag-eyan san iib-ada issan esay bangka ta badanganda daida. Inmeyda binadangan daida et pinopinoda san doway bangka is ikan et gistayda malimon. ");
INSERT INTO xnn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Idi inilan Simon Pedro san inommat dat menpalintomeng ken Jesus et kanana, “Apo, mabainak ken sik-a tay managbasolak isonga taynam sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nasdaaw am-in san wada issan bangkan Simon issan nang-ilaanda isnan kaad-adon san sinidokanda ");
INSERT INTO xnn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ya olay gedan san ib-an Simon issan esay bangka ay da Santiago ken Juan ay an-ak Zebedeo. Dat kanan Jesus ken Simon, “Adi kayo mabain ay maitapi ken sak-en. Ninsidsidok kayo is ikan ngem id wani isolok abes nan ikkanyo ay mensidok is ipogaw ta maitapida isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Isonga dadat ipakni nan bangkada dadapay taynan am-in nan kowada et omonodda ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isnan namingsan ay kad-an Jesus isnan esay ili et sinmag-en nan am-ama ay nabayag ay nakolit dat menlokbob ay menseg-ang, “Apo, getkek ay kabaelam ay mangkaan isnan sakitko no kayatmo.” ");
INSERT INTO xnn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dat gen-an Jesus siya danapay kanan, “Kayatko ay maagasanka.” Dat dagos ay makaan nan kolitna. ");
INSERT INTO xnn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Danat kanan ken siya, “Adim ibagbaga nan inikkak ken sik-a isnan teken ay ipogaw. Basta idadawesmo ta enka menpaila isnan padi damet idya nan limosmo ay mapalti ay kaneg din inbilin Moses ta pangtekan nan ipogaw ay ginmawiska.” ");
INSERT INTO xnn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ngem dinngen kayet nan kaipoipogaw san inikkan Jesus ken siya dadat omey et enda dengngen nan kankanana ya ta pagawisena nan wada nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ngem no mamingsan et komaan si Jesus tay omey isnan bilig ay menlowalo. ");
INSERT INTO xnn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Issan esay agew ay men-is-isolowan Jesus isnan esay baey et wadada nan nangitotokdo ay Fariseo ya nan men-is-isolo isnan linteg ay nagapo isnan probinsiya ay Galilea ya Judea ya isnan ili ay Jerusalem. Nan panakabalin Apo Dios ay mangipagawis isnan sakit et wada ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dat domateng nan mang-aatangay isnan napalalais ay kayatda ay eyey issan baey ay kad-an Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ngem nanapno nan baey is ipogaw et maid polos ikkanda ay mangisgep ken siya isonga insakyatda isnan atep san baey ay nadadata dadat lokaben nan atep dadat oy-oyen san napalalais et ompa issan tengan nan ipogaw ay sasagangen Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Getken Jesus ay talkenda siya isonga danat kanan issan am-ama, “Gayyem, napakawan et nan basolmo.” ");
INSERT INTO xnn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dat kasiaagasaas nan men-is-isolo isnan linteg ya nan Fariseo ay mangwani en, “Sino pay nan lalaki ay naay? Ayta dan iyiison tona nan awakna ken Apo Dios dapay kedkedeng si Apo Dios is makapakawan is basbasol?” ");
INSERT INTO xnn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ngem getken Jesus nan kankananda danat kanan, “Ngan nan apedyo nemnemnemen? ");
INSERT INTO xnn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ay ngan nan nalaklaka ay kanan, nan ‘Mapakawan nan basolmo’ wenno nan ‘Ibangonmo ta mendaanka?’ ");
INSERT INTO xnn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ngem gapo tay adiyo patiyen et paneknekak ken dakayo ay wada nan kalebbengak isnan batawa ay mangpakawan is basol tay sak-en nan makwani en Iyon-an Am-in di Ipogaw.” Isonga danat kanan issan napalalais en, “Ibangonmo. Alaem nan dayonmo ta somaaka.” ");
INSERT INTO xnn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nabanangon et san am-ama danat alaen san dayona et somaa ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Am-in san wada isdi ay nangiila et nasdaawda dadapay inmegyaegyat dadat dayawen si Apo Dios ay mangwani en, “Kaskasdaaw nan inilami id wani.” ");
INSERT INTO xnn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nakwas pay san nin-agasan Jesus dat bomala et ilana si Levi ay esay mensingsingil is bowis ay mangitotokdo isnan kabaybayadan di bowis. Dat kanan Jesus, “Omalika ta maitapika ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dat taynan Levi nan oblana ya am-in ay kokwana isnan opisina daet omonod ken Jesus et maitapi ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Inmeyda isnan baey Levi dat menpalti siya ta makikan da Jesus ya nan iib-an Levi ay mensingsingil is bowis ya nan tap-in di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Idi inilan san ib-an san Fariseo ya san men-is-isolo is linteg ay makikikanda dadat kanan issan papasolot Jesus, “Aytay dakayon makikikan isnan sanada ay mensos-owitik ay mensingsingil is bowis ya nan managbasol?” ");
INSERT INTO xnn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ngem si Jesus nan sinmongbat et kanana ay mangiyalig, “Nan ipogaw ay maid sakitna et adina masapol nan doktol ngem nan ipogaw ay mensakit et daida nan makasapol isnan doktol. ");
INSERT INTO xnn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Isonga inmaliyak tapno badangak nan mangtek ay nakabasol tapno menbabawida ngem baken nan mangnenemnem ay gawisda.” ");
INSERT INTO xnn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sinootda ken Jesus ay mangwani en, “Nan papasolot Juan et wada nan mentepeanda ay adi mangan isnan obaya dadapay menlol-owalo ay kaneg abes nan papasolot nan Fariseo dapay nan papasolotmo et adida mentepe.” ");
INSERT INTO xnn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Dat menpangngalig si Jesus ta ilawlawagna nan gapo ay adi menteptepe nan papasolotna et kanana, “Ay kananyo en adi makikan nan nadkat no daan pay nan nadawak ken daida? Adi mabalin. ");
INSERT INTO xnn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ngem no omdan nan agew ay maapitan nan lalaki ay nadawak et siya di nan mentepeanda gapo isnan seg-angda.” ");
INSERT INTO xnn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Intoloy Jesus ay mensodok ta ipagtekna ken daida en adi kabalin ay maitapi nan nabayag ay sinoloda isnan isolsolona. Kanana, “Maid mangitakop is balo ay bado isnan logak. No ikkana na et kawasena nan balo ay bado dapay gedan nan baloy galot et adi maibagay ay maitakop isnan logak. ");
INSERT INTO xnn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Siya gedan isnan tapey. Maid mang-igwa is kabobobod ay tapey isnan naosal ay kodil tay epdas kinmenteg dapay mo menlowag nan tapey et bomtak nan kodil et makawas nan tapey ya nan kodil gedan. ");
INSERT INTO xnn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nan balo ay tapey et masapol ay maigwa isnan balo abes ay kodil tay mabinbinat et maid makawas. ");
INSERT INTO xnn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maid abes mangkayat ay ominom is olay gawis ay kapewpewak ay tapey no epdas inminom isnan nabayag ay tapey tay kanana en gawgawis nan nabayag mo nan balo.” ");
INSERT INTO xnn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sinabado ay obayan di Judio et isnan esay Sabado indaan da Jesus isnan paypayewan. Dat menlosing nan papasolotna is kotimenda. ");
INSERT INTO xnn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dat kanan nan tap-in di Fariseo, “Aytay dakayon menlosing is kotimenyo dapay lawaen nan linteg tako nan men-ani isnan obaya?” ");
INSERT INTO xnn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dat kanan Jesus, “Ayta dayon pabasolen daida? Ay egayyo binasa din inikkan da David isdin linmayawanda? Naowaowatda ");
INSERT INTO xnn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","isonga dadat songgep isnan baey Apo Dios et alaen David nan tinapay ay pala ken Apo Dios danat kanen danapay agtan nan iib-ana. Dapay kanan nan linteg tako en adi mabalin ay maipakan nan tinapay ay pala ken Apo Dios isnan ipogaw no bakenda padi. Ngem gapo tay naowatda et egay pabasolen Apo Dios daida.” ");
INSERT INTO xnn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dat itoloy Jesus ay mangwani, “Sak-en ay Iyon-an Am-in di Ipogaw nan kalebbeng isnan mabalin ay maik-ikkan isnan obaya.” ");
INSERT INTO xnn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Isnan esay Sabado kasin, sinonggep si Jesus isnan sinagoga ay men-isolo. Dat wada nan am-ama ay nabingoy nan kanawan ay ledengna. ");
INSERT INTO xnn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nan men-is-isolo isnan linteg ya nan Fariseo, kaytenda ay mangidalom ken Jesus isonga sis-iimenda siya no pagawisena nan nabingoy tay lawaenda nan men-agas is sakit isnan obaya tay kananda en obla di. ");
INSERT INTO xnn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ngem getken Jesus nan nenemnemenda isonga danat kanan issan nabingoy, “Omalika ta itakdegmo isnan sasagangenmi.” Dat omey san nabingoy. ");
INSERT INTO xnn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dat sooten Jesus ken daida, “Ngan nan linteg tako isnan obaya? Ay ikkan nan gawis wenno nan ngawi? Ay ayyewan nan biyag wenno kawasen?” ");
INSERT INTO xnn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Danat inengneng daida danat kanan issan nabingoy, “Oyadem nan ledengmo.” Inoyadna dat maoyad tet-ewa tay naagasan et. ");
INSERT INTO xnn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ngem mamaslat nan Fariseo ya nan men-is-isolo isnan linteg dadapay men-asitoya no ngan nan ikkanda ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Issan esay agew tinmikid si Jesus isnan bilig ta omey menlowalo danat ilalabi ay menlol-owalo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kawakgatana pay danat ayagan nan papasolotna et piliyena nan simpoo ya dowa ay nginadnana is aapostolis. ");
INSERT INTO xnn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Datona nan ngadngadan nan pinilina. Si Simon ay nginadanan Jesus is Pedro ya nan besatna ay si Andres ya da Santiago ken Juan, si Felipe, si Bartolome, ");
INSERT INTO xnn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo, si Tomas, si Santiago ay anak Alfeo, si Simon ay mangisaksakit isnan ilida, ");
INSERT INTO xnn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas ay anak Santiago ya si Judas Iscariote ay awnit mangisipsip ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Linmayog si Jesus ya nan papasolotna ay nagapo issan bilig et omdanda pay isnan nasisimpa dat isaldeng Jesus ya nan ado ay pasolotna. Wadada gedan nan adoado ay nagapo id Judea ya id Jerusalem ya isnan il-ili isnan benget di baybay ay id Tiro ya Sidon. ");
INSERT INTO xnn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inmeyda ay mangdenge isnan kankanana dapay ta pagawisena nan wada nan sakitda et olay nan deeyday pinalpaligat di anito ay inmey et ginmawisda gedan. ");
INSERT INTO xnn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Am-in nan ipogaw et kaytenda ay somag-en ay mangsikgad ken siya tay wada nan panakabalina ay magapo ken siya ay mangpagawis isnan am-in ay sakitda. ");
INSERT INTO xnn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Inilan Jesus san papasolotna danat kanan, “Nagasat kayo ay mangtek isnan kolangyo tay awnit kayo maitapi isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nagasat kayo ay manglaylayad ay mang-ikkan isnan layden Apo Dios tay awnit kayo mapnek. Nagasat kayo ay menseseg-ang gapo isnan basolyo tay awnit kayo men-gasgasing. ");
INSERT INTO xnn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nagasat kayo no kaliliget nan ipogaw dakayo ya aamisenda ya bab-ainanda dadapay kanan en ngawi kayo gapo isnan mangpatpatiyanyo ken sak-en ay Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Men-gasing kayo tay olay no adoado nan ligatyo id wani et awnit dakkel nan ganabenyo ay idyan Apo Dios ken dakayo ay insaganana id daya. Tay nan ik-ikkanda id wani ken dakayo et siya gedan nan inik-ikkan din alal-apoda id sang-adom isdin mamadton Apo Dios isonga men-galalasing kayo isnan maiisowanyo ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ngem kaseseg-ang kayo ay kedeng nan kinabaknangyo is nenemnemenyo tay epdasyo ginanaganas nan biyagyo. ");
INSERT INTO xnn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaseseg-ang kayo ay mamapnek id wani tay awnit kayo maowat. Kaseseg-ang kayo ay men-gasgasing id wani tay awnit kayo menseseg-ang ya men-ag-aga. ");
INSERT INTO xnn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kaseseg-ang kayo no it-it-ek nan ipogaw dakayo olay baken tet-ewa ay kaneg din inik-ikkan din alal-apoyo ay nang-it-it-ek isdin baken tet-ewa ay mamadto.” ");
INSERT INTO xnn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Dakayo ay mendedenge isnan kankanak et masapol ay laylaydenyo nan mang-aamis ken dakayo ya ipailayo gedan nan gawis isnan mangliliget ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","No waday mang-aamis ken dakayo kananyo en badangan Apo Dios daida dayopay ilowalowan daida. ");
INSERT INTO xnn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","No waday mangtipak isnan esa ay ipingmo dakat idoo nan topakna ya no waday mang-ala isnan abitom, bay-am ta alaena gedan nan badom. ");
INSERT INTO xnn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No waday menkedaw ken sik-a dakat agtan ya no waday mang-ala isnan osalmo adim kankanan en isagongna. ");
INSERT INTO xnn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ikkanyo isnan ib-ayo nan kaytenyo ay ikkanda ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ay kananyo ngen en it-it-ek Apo Dios dakayo no kedeng nan manglaylayad ken dakayo is laylaydenyo? Adi tay olay nan adi mamati ken Apo Dios et laylaydenda gedan nan manglaylayad ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ngan ngalod nan naitkenanyo no kedeng nan mang-ikkan is gawis ken dakayo nan mang-ikkananyo abes is gawis? Olay nan adi mamati ken Apo Dios et siya gedan di nan ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ya no kedeng nan mangisagsagong isnan bolodenda ken dakayo is pabolbolodanyo ay it-it-ek ngen Apo Dios dakayo? Olay nan adi mamati et menpabolodda gedan isnan ib-ada tay getkenda ay maisagong met laeng san inpabolodda. ");
INSERT INTO xnn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Isonga baken dana is ikkanyo koma nodi laylaydenyo nan mang-aamis ken dakayo dayopay ikkan nan gawis ken daida. Menpabolod kayo olay getkenyo ay adida isagong nan bolodenda tay no siya dana nan ik-ikkanyo et ipailayo dadlo ay an-ak Apo Dios dakayo et awnit gawis nan idyana ken dakayo. Tay maseg-ang siya olay isnan adi mangtek ay men-iyaman ya nan naimot. ");
INSERT INTO xnn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Masapol abes ay managseg-ang kayo ay kaneg nan Amayo ay managseg-ang.” ");
INSERT INTO xnn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Adiyo banbanagen nan ib-ayo ta adi abes banagen Apo Dios dakayo. Adiyo abes pabasbasolen nan ib-ayo ta adi gedan pabasolen Apo Dios dakayo. Nodi pakawanenyo nan ib-ayo ta pakawanen abes Apo Dios dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Agtanyo nan ib-ayo et agtan gedan Apo Dios dakayo. Tay nan kaad-adon nan in-intedyo et siya gedan nan kaad-adon nan idyana ngem nasolsolok pay tay olay itamtamedna ya ibasbasbasna ay mangisedsed et lomoslosoy kayet.” ");
INSERT INTO xnn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dat sodoken Jesus nan naay, “Nan kowap et adi makaipango isnan kanegna ay kowap tay no ikkana na et maekdagda ay dowa isnan ketang. ");
INSERT INTO xnn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maiwed maisolsolowan is nangatngato mo nan men-is-isolo ken siya ngem am-in nan oskila ay mangkewas isnan ad-adalena et awnit kanegna abes nan mistolona.” ");
INSERT INTO xnn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dat menpangngalig si Jesus maipanggep isnan menkalkali is basol di ib-ada et kanana, “Damen delawen nan bota isnan matan nan besatmo dapay adim madlaw nan kega sindomet ay bota isnan matam? ");
INSERT INTO xnn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ngan nan ikkam ay mangwani en, ‘Pangaasim besatko ta kaanek nan bota isnan matam,’ dapay adim malikna nan kega sindomet ay bota isnan matam? Sik-a ay aginsisingpet. Kaanem omon-ona nan dakkel ay bota isnan matam tasiyay makailaka ay gawis esakapay kaanen nan teeteen ay bota isnan matan nan besatmo.” ");
INSERT INTO xnn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nan gawis ay kaiw et adi bomgas is ngawi ya adi abes bomgas nan ngawi is gawis. ");
INSERT INTO xnn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nan kailasinan nan am-in ay kaiw et nan ibgasda tay adi mabolas nan papaya isnan kawayan wenno nan alomani isnan sibit. ");
INSERT INTO xnn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kaneg abes datako ay ipogaw, no nan gawis nan nemnemna et gawis nan ik-ikkana ngem no nan ngawi nan nemnemna et ngawi abes nan ik-ikkana. Tay nan kalin di ipogaw et ipailana nan wada isnan nemnemna.” ");
INSERT INTO xnn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Dayon kankanan en sak-en nan Apoyo dakayopay adi patpatiyen nan ibagbagak? ");
INSERT INTO xnn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Am-in ay omali ken sak-en ay mangidnge ya mangpati isnan ibagbagak et siya na nan kaiyaligana. ");
INSERT INTO xnn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kanegna nan esa ay ipogaw ay ninsaad is baeyna. Inkaobna ay gawis nan tokod enggana ay maipegnad isnan bato sanapay saaden nan baeyna. Isonga no men-inewang et dalaposena san baey ngem egay natokang tay menkeneg. ");
INSERT INTO xnn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ngem nan ipogaw ay mangdedenge isnan kankanak danapay adi patiyen et kanegna nan nangsaad is baeyna isnan lota ngem egayna pegnadan is bato ay menpatangan nan tokodna. Isonga idi men-inewang dat makibbek ay matokang san baeyna tay egay kasaad ay gawis.” ");
INSERT INTO xnn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Issan nakwasan pay san am-in ay kayatna ay ibaga isnan kaipoipogaw dat omey si Jesus id Capernaum. ");
INSERT INTO xnn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Id sidi et wada nan iRoma ay kapitan di adoado ay soldado. Wada nan baana ay laylaydena ay matmatey. ");
INSERT INTO xnn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dinngen san kapitan nan maipanggep ken Jesus danat ibaa nan aamam-a ay Judio ta enda ayagan si Jesus ta omeyna pagawisen nan baana. ");
INSERT INTO xnn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Dadat omey ken Jesus ay menseg-ang ay mangwani en, “Nan naay kapitan et olay baken Judio ngem laylaydena datako ay Judio dapay gedan ninpasaad is sinagoga isonga gawis abes no badangam siya.” ");
INSERT INTO xnn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dat makkey si Jesus ken daida. Idi naisag-enda isnan baey san kapitan, inbaan san kapitan nan gagayyemna ay mangibaga ken Jesus en, “Apo, olay adika kano songgep tay mabain ken sik-a ");
INSERT INTO xnn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","isonga baken siya is nangsab-at ken sik-a. Getkena gedan ay omanay nan kalim is mangipagawis isnan baana ");
INSERT INTO xnn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","tay siya kano et kanegmo gedan ay wada nan nangatngato ay opisyal ay mangbab-aa ken siya ngem wada gedan nan sosoldadona ay bab-aaena. Et no ibagana isnan esay bab-aaena en, ‘Omeyka,’ dat omey ay dagos, ya no ibagana isnan esang en, ‘Omalika,’ dat omali, ya no ibagana is esa en, ‘Ikkam na,’ danat ikkan tet-ewa. Isonga getkena ay omanay nan kalim is mangpagawis ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nasdaaw si Jesus issan dinngena dat menligos ay mangwani isnan ipogaw ay omon-onod ken siya, “Ibagak ken dakayo en maid polos dinasdas-ak is napigpigsa ay talek isnan Judio ay kaneg nan talek nan sana ay kapitan.” ");
INSERT INTO xnn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dat somagong et san deeyda ay binaan san kapitan issan baey dadat datngan ay ginmawis san baa ay masaksakit. ");
INSERT INTO xnn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Egay pay nabayag dat omey si Jesus isnan ili ay Nain et nakkey nan papasolotna ya nan adoado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Omdanda pay isnan soban di ili dadat sab-aten nan mabob-oweg ay omey mangikaob isnan natey. San deey lalaki ay natey et dalos kedkedeng is anak nan esay balo isonga adoado nan omili ay binmadang. ");
INSERT INTO xnn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Olay si Jesus et palalo gedan nan seg-angna isnan nang-ilaana issan balo. Danat kanan ken siya, “Laton sa. Adika men-ag-aga.” ");
INSERT INTO xnn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Daet somag-en si Jesus et gen-ana san inaawitda ay koong dat itakdeg san deeyday mang-aawit. Dat kanan Jesus, “Baballo, bomangonka.” ");
INSERT INTO xnn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dat tet-ewa mabanangon san natey dapay komali. Dat kanan Jesus issan balo, “Naay san anakmo.” ");
INSERT INTO xnn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Am-in ay wada isdi et palalo nan egyatda dadat dayawen si Apo Dios ay mangmangwani en, “Esay mamadton Apo Dios nan naay inmali ken datako.” Dapay kanan es nan ib-ana, “Inmali si Apo Dios ay mangisalakan ken datako ay ipogawna.” ");
INSERT INTO xnn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Daet maibaag san inik-ikkan Jesus id Judea ya isnan am-in ay naliliwes ay il-ili. ");
INSERT INTO xnn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Si Juan ay Menbonbonyag et wada isnan pagbalodan ngem getkena met laeng san ik-ikkan Jesus tay ibagbagan san papasolotna. ");
INSERT INTO xnn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Danat ayagan san dowa et ibaana daida ta omeyda sooten ken Jesus no siya nan Kristo ay inbaan Apo Dios wenno waday teken is awnit omali is mamas-ed. ");
INSERT INTO xnn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Idi inomdanda ken Jesus kinwanida en, “Inbaan Juan ay Menbonbonyag dakami ta sootenmi no sik-a nan masmas-ed ay magapo ken Apo Dios ay si Kristo wenno waday teken is sedsed-enmi.” ");
INSERT INTO xnn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Issan inmayanda ken Jesus et adoado nan pagawgawisena ay masaksakit ya ipakak-aana nan anito ay kinmapet ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Danat kanan issan papasolot Juan, “Somagong kayo ken Juan ta ibagayo nan dinngeyo ya nan inilayo ay ik-ikkak. Tay nan kowap et makailada, nan pilay et makadaanda, nan nakolit et ginmawisda, nan toweng et makadngeda, nan natey et natagoda ya olay nan kodokdo et dinngeda nan naibagbaga ay gawis ay damag. ");
INSERT INTO xnn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kananyo gedan ken siya en mabindisyonan nan ipogaw ay adi mendowadowa ay mamati ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Issan kinmaanan san papasolot Juan dat kanan Jesus issan kaipoipogaw, “Isdin inmayanyo isdin kad-an Juan isnan bilig, ay ngan nan kaytenyo ay ilaen? Ay ninemnemyo ay si Juan et kanegna nan goon ay pakiwkiwiyen di dagem? Baken. ");
INSERT INTO xnn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ay ngan ngalod nan enkayo inila? Ay esay ipogaw ay ninbado is gawigawis? Baken gedan tay nan ipogaw ay menbabado is gawigawis ya naganas nan biyagna et nan makitetee isnan ali. ");
INSERT INTO xnn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ay ngan ngalod nan enkayo inila? Ay esay mamadton Apo Dios? Owen, ngem ibagak ken dakayo ay nan inilayo et nangatngato mo is mamadto. ");
INSERT INTO xnn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tay si Juan nan kakwaniyan nan naisolat ay kalin Apo Dios id kasin en, ‘Wada nan ibaak ay omon-ona ay mangisagana isnan daanem isnan omaliyam.’” ");
INSERT INTO xnn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Dat itoloy Jesus, “Ibagak ken dakayo en isnan am-in ay ipogaw et maid nangatngato mo si Juan. Ngem nan kababaan isnan mentolayan Apo Dios et nangatngato mo si Juan. ");
INSERT INTO xnn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nan adoado ay ipogaw ya olay nan mensingsingil is bowis et dinngeda san kinkinwanin Juan. Da tona nan nangtongpal isnan kayten Apo Dios isonga dadat menpabonyag ken Juan. ");
INSERT INTO xnn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ngem nan Fariseo ya nan men-is-isolo isnan linteg et egayda tinongpal nan kayten Apo Dios ay ikkanda isonga adyanda ay menpabonyag ken Juan.” ");
INSERT INTO xnn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dat itoloy Jesus ay mangwani, “Ay ngan nan mangidiligak ken dakayo ay ipogaw id wani? Men-ap-apos et kedeng nan getkenyo. ");
INSERT INTO xnn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kaneg kayo oongong-a ay adi polos mapnek tay no men-ay-ayamda isnan malkitan et kankanan nan ib-ada ken daida en, ‘Nin-ganggangsa kami ngem egay kayo ninsala. Nin-ag-aga kami ngem egay kayo nakiaga.’ ");
INSERT INTO xnn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kanak en kanegyo daida tay adi kayo polos mapnek. Inmali si Juan ay Menbonbonyag et at-atik nan kinkinana ya egay polos inmin-inom is bomoteng ay mainom dakayot kanan en, ‘Matawtawaw siya.’ ");
INSERT INTO xnn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Inmaliyak abes et nakikikanak ya nakiin-inomak ken dakayo dakayot kanan en, ‘Ilaenyo pod nan ipogaw ay naay. Bokatot ya men-inom danapay gayyem nan mensos-owitik ay mensingsingil is bowis ya nan managbasol.’ No siya ngalod sa di kankananyo et maid mabalin is ikkanmi ken Juan ay mangpagasing ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ngem olay no adyanyo nan initdok ya nan init-itdon Juan et mailanto isnan ogalin nan mamati ken Apo Dios ay nan it-itdomi et siya nan silib Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Inayagan nan esay Fariseo ay kangadan is Simon si Jesus ta omey makikan isnan baeyna. Dat omey si Jesus et makilikob. ");
INSERT INTO xnn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Issan deey ay ili et wada nan babai ay managbasol. Idi dinngena ay wada si Jesus ay makikikan issan baey di Fariseo dat omey ay mangikakawit isnan gawigawis ay palanggo ay kad-an di nangina ay bangbanglo. ");
INSERT INTO xnn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dat menpalintomeng isnan kad-an Jesus ay men-ag-aga dat mentedted nan agana isnan sikin Jesus. Danat ponasan isnan bookna danat bisitowen danapay bokbokan is bangbanglo. ");
INSERT INTO xnn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","San Fariseo ay nang-ayag ken Jesus et inilana danat kanan isnan nemnemna, “No tet-ewa ay mamadtona et getkena koma no ngan nan kaipogaw nan babai ay naay ay manggeg-een ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dat kanan Jesus, “Simon, wada nan ibagak ken sik-a.” Dat kanan Simon, “Apo, ay ngan di ibagam?” ");
INSERT INTO xnn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dat kanan Jesus, “Wada nan doway aamam-a ay nin-otang is siping isnan kadangyan. Nan esa et limang gasot nan otangna ya nan esang abes et limampoo. ");
INSERT INTO xnn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ngem gapo tay adida makabayad danat kaanen san otangda. Kadya ibagam ken sak-en no sino ken daida ay dowa nan dakdake nan layadna issan kadangyan?” ");
INSERT INTO xnn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sinmongbat si Simon en, “Kanak en waay san ad-ado nan otangna ay nakaan.” “Tet-ewa nan songbatmo,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dat ilaen Jesus san babai danat kanan ken Simon, “Ay iilaem nan babai ay naay? Sinangailim sak-en isnan baeymo ngem maid inbaam is mang-owas isnan sikik dapay siya nan ogali tako ngem si tona et inowasana nan sikik isnan agana danapay iponas nan bookna. ");
INSERT INTO xnn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Egaymo sinab-at sak-en ay mangbisito ay kaneg gedan nan ogali tako ngem siya et egay somalsaldeng ay mangbisbisito isnan sikik enggana issan inmaliyak. ");
INSERT INTO xnn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Egaymo linanaan nan bookko ay kaneg nan ogali tako ngem siya et binokbokana nan sikik is nangina ay bangbanglo. ");
INSERT INTO xnn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ibagak ngalod ken sik-a, gapo tay getkena ay adoado nan basolna ay mapakawan isonga siya na nan inikkana ay mangipaila isnan dakkel ay layadna ken sak-en. Ngem nan ipogaw ay mangwani en bassit nan basolna ay napakawan et bassit abes nan layadna.” ");
INSERT INTO xnn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dat kanan Jesus issan babai, “Napakawan nan basbasolmo.” ");
INSERT INTO xnn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nan ib-ada ay mangmangan et kinwanida isnan nemnemda, “Ay sino ngen nan ipogaw ay naay ay olay nan basol et pakawanena?” ");
INSERT INTO xnn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ngem dat kanan Jesus issan babai, “Nan pammatim nan nangisalakan ken sik-a. Somaaka et ay menlamlamnin.” ");
INSERT INTO xnn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Egay pay nabayag dat omey si Jesus isnan kailiili ay mangibagbaga isnan gawis ay damag maipanggep isnan mentolayan Apo Dios. Nakkey san simpoo ya dowa ay pasolotna ");
INSERT INTO xnn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ya san pinagawis Jesus ay iinin-a ay nasaksakit ya tinoyan di anito. Naay nan ngadanda. Si Maria Magdalena ay tinaynan di pito ay anito, ");
INSERT INTO xnn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana ay asawan Cusa ay ap-apo isnan baey Herod ya si Susana ya nan adoado pay ay iinin-a ay nang-idya isnan tap-in di kokwada ta badanganda si Jesus ya nan papasolotna. ");
INSERT INTO xnn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Inmali nan kaipoipogaw ay nagapo isnan natkenatken ay ili dadat madagop tay kaytenda ay dengngen nan kalin Jesus. Dat mensodok si Jesus ken daida et kanana, ");
INSERT INTO xnn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wada nan am-ama ay en ninbonobon isnan om-a. Idi insapowakna nan bonobon isnan om-a, naekdag nan tap-ina isnan daan et gatgatinan nan ipogaw dapay topken di koyat. ");
INSERT INTO xnn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nan tap-ina et naekdagda isnan kabatbatowan dat tomobo ngem namgaan nan lota isonga dadat maango. ");
INSERT INTO xnn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nan tap-ina et naekdagda isnan ginsatan ay sibit dat solinen di sibit nan tinmobo et mateyda. ");
INSERT INTO xnn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ngem nan tap-ina ay natekdag isnan gawis ay lota et tinmoboda dadapay bomgas is adoado.” Dat ibiyad Jesus ay mangwani en, “Dengngenyo ngalod no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Dat sooten nan papasolot Jesus ken siya nan kayat ay kanan nan sinodokna. ");
INSERT INTO xnn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sinmongbat si Jesus ay mangwani, “Owen tay naipagtek ken dakayo nan egay naipagtek id kasin ay maipanggep isnan mentolayan Apo Dios ngem isnan tap-ina et ipangpangngaligko nan ikkak ay mangisolo ken daida tasiyay olay il-ilaenda et adida getken nan tet-ewa ya olay dengdengngenda et adida maawatan. ");
INSERT INTO xnn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Siya na nan kayat ay kanan san sinodokko. Nan bonobon et siya nan kanega kalin Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nan daan ay natekdagan di bonobon et kanegna nan ipogaw ay mangdenge isnan kalin Apo Dios ngem dat omey si Satanas et kaanena isnan nemnemna san dinngena tapno adi mamati ya maisalakan. ");
INSERT INTO xnn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nan kabatbatowan et kanegna nan ipogaw ay mangdenge ya men-gasgasing ay mangdawat isnan kalin Apo Dios. Ngem adi lomamot nan kalin Apo Dios isnan nemnemna tay patiyena is sin-awyan danat dokogan ay dagos no mapaligatan gapo isnan pammatina. ");
INSERT INTO xnn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nan ginsatan ay sibit et siya nan mangdenge isnan kalin Apo Dios ngem makolkol nan nemnemna tay wedweda nan bomaknangana ya men-gasgasingana is nenemnemena isonga adi bomgas tay nasolin nan kalin Apo Dios et kalingkingana. ");
INSERT INTO xnn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ngem nan gawis ay lota ay natekdagan di bonobon et siya nan ipogaw ay mangdedenge isnan kalin Apo Dios danat is-ek ay gawis isnan nemnemna danapay itoltoloy ay mangpatpati engganay bomgas nan kalin Apo Dios isnan biyagna.” ");
INSERT INTO xnn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Danat itoloy ay mensodok, “Maid mangpasged is silaw danat salinan is timba wenno igwana isnan silok di podanan tasiyay adi kaila nan silangna nodi ipatangna tapno menpat-a no songgep nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Siya abes nan kaneg nan epdas naikkan ay olay egay kagtek et awnit maipabala ya nan nenemnemen nan ipogaw et awnit magtek met laeng. ");
INSERT INTO xnn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Isonga dengngenyo ay gawis nan isolok tay nan mamati isnan isolsolok et masilawan nan nemnemna ta maawatana dat taptapiyan Apo Dios nan getkena. Ngem nan ipogaw ay adi mangidnge ya adi mamati et awnit mamaid nan atiatik ay getkena.” ");
INSERT INTO xnn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inmey si inan Jesus ya nan bebsatna isnan kad-ana ngem adida makasag-en ken siya tay adoado nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Dat wada nan mangwani ken Jesus, “Wada da inam ya nan bebsatmo isnan pantew ay mangpaay-ayag ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dat kanan Jesus ken daida am-in en, “Owen, ngem bakenda kedeng is inak ya bebsatko tay am-in nan mangidnge isnan kalin Apo Dios et daida gedan nan inak ya bebsatko.” ");
INSERT INTO xnn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Isnan namingsan et ninlogan si Jesus ya nan papasolotna isnan bangka tay kinwanin Jesus en omeyda isnan bas-ang di baybay. ");
INSERT INTO xnn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idi om-omeyda dat maseyep si Jesus. Dat domateng nan napigsa ay dagem et masepyatan nan bangka et nganngani ay malimonda dat omegyat nan papasolotna ");
INSERT INTO xnn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","isonga dadat gidowen si Jesus ay mangwani, “Apo, Apo, naay malimon tako.” Dat bomangon siya et ipakin-ena nan dagem ya dalloyon. ");
INSERT INTO xnn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Danat kanan isnan papasolotna, “Dakayon omegyat? Ay maid talekyo ken Apo Dios?” Ngem nasdaawda ya nakibtotda am-in dadat men-asikwani, “Manakabalin obpay nan ipogaw ay naay. Danan bilinen nan dagem ya danom dadat tet-ewa tongpalen?” ");
INSERT INTO xnn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Intoloyda ay men-gedang isnan baybay id Galilea ay omey isnan dedemangena ay lakon di Geraseno. ");
INSERT INTO xnn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Dinmaka si Jesus isnan benget di baybay dat sab-aten nan esay lalaki ay kinapet di anito. Tawaw nan inidyada issan lalaki et nabayag ay aped menlalabos ya adi kasala isnan baey ay aped nan lil-iyang ay kad-an di natey nan nintet-eeana. Et nabayag ay pinalpaligat san anito siya et olay ibalodda ya galotenda nan ledengna ya sikina is kawal, mensokpotna kayet dat patagtagen san anito siya isnan pondag. Issan nang-ilaana ken Jesus nin-owakis dapay menlokbob isnan sasagangena danapay ibibiyad ay mangwani, “Jesus ay Anak Apo Dios ay kangatowan, ay ngan di ngotom ken sak-en? Maseg-angka ta adika mangdosdosa.” Kinwanina di tay inbilin Jesus en komaan san makedse ay anito ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dat sooten Jesus ken siya, “Ay sino nan ngadanmo?” “Nan ngadanko et Linibo,” kinwanina tay kalibolibo nan anito ay kinmapet ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Dat menseg-ang san kaanianito ken Jesus en adina paeyen daida isnan longok ay kadosdosaanda. Ngem isnan sasag-enenda adoado nan beteg ay mangmangan isnan bilig isonga dat kanan san kaanianito ken Jesus en palobosana daida tasiyay enda kapten nan kabetebeteg. Danat palobosan daida ");
INSERT INTO xnn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","isonga dadat taynan san lalaki et kaptenda san kabetebeteg. Dat kanega naong-ong am-in san beteg et kasida tatagtag ay omey isnan deppas dadat matekdag isnan baybay et malimonda. ");
INSERT INTO xnn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Issan nang-ilaan san mangbanbantay isnan beteg issan inommat dadat tomagtag et omeyda ibaga isnan kailiili. ");
INSERT INTO xnn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dat omey nan nangdenge et enda ilan nan inommat dadat datngan san lalaki ay tinaynan di anito ay tinmotokdo isnan sag-en Jesus et ninbabado dadlo dapay gawis nan nemnemna dadat menkakikibtot am-in. ");
INSERT INTO xnn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","San deeyda ay nang-ila et inbagada isnan kadatdateng ay ipogaw nan inkakkan san lalaki ay ginmawis. ");
INSERT INTO xnn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gapo isnan dadama ay egyat san iGeraseno et inbagada ken Jesus en olay komaan isnan ilida. ");
INSERT INTO xnn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ngem san lalaki ay tinaynan di kaanianito et ninseg-ang ken Jesus en makaey koma ken siya. Ngem dat kanan Jesus ken siya, “Somaaka bawet ta enka ibaga nan gawis ay inikkan Apo Dios ken sik-a.” Dat menlogan da Jesus issan bangka et taynanda daida. Dat somaa san lalaki et ena ibaga isnan am-in ay kailiyana san inikkan Jesus ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sinmagong da Jesus isnan demang di baybay dat men-gasing nan kaipoipogaw isdi tay sisin-edda siya. ");
INSERT INTO xnn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dat domateng nan am-ama ay kangadan is Jairo ay esay apon di sinagoga isdi. Dat menpalintomeng isnan sagang Jesus ay menseg-ang ken siya ta omey id baeyda ");
INSERT INTO xnn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tay matmatey nan bogtong ay anakday babai ay simpoo ya dowa nan tew-ena. Dat makkey si Jesus et omon-onod kayet nan kaipoipogaw ay mang-al-alibongbong ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dat wada gedan nan in-ina isdi ay egay somalsaldeng nan basana is simpoo ya doway tew-en. Inamina am-in nan kokwana ay inbaybayadna is mang-agas ken siya ngem maid polos nakaagas. ");
INSERT INTO xnn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Inmey isnan dodokogan Jesus danat sikgaden nan benget nan badon Jesus dat masanaldeng nan basana. ");
INSERT INTO xnn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dat sooten Jesus, “Ay sino nan nangsikgad ken sak-en?” Dat was-in mangwani isnan kaipoipogaw isdi en bakenda. Dat kanan Pedro, “Apo, adoado nan mang-al-alibongbong ken sik-a isonga nasikgadka adi.” ");
INSERT INTO xnn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ngem dat kanan kayet Jesus, “Wada nan teken ay nangsikgad ken sak-en tay gegetkek ay wada nan masaksakit ay pinagawis nan panakabalinko.” ");
INSERT INTO xnn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Gintek san in-ina ay nasokalan siya dat menpaypayegpeg ay omey menpalintomeng isnan sasagangen Jesus. Et isnan sasagangen am-in di ipogaw, inbagana ken Jesus nan gapo ay nangsikgadana ken siya ya nan dagos ay ginmawisan nan sakitna. ");
INSERT INTO xnn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dat kanan Jesus ken siya, “Ina, ginmawiska gapo isnan pammatim ken sak-en. Somaaka ay menlamlamnin.” ");
INSERT INTO xnn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Daan ay mentoytoya da Jesus issan in-ina dat domateng nan nagapo issan baey Jairo et kanana ken siya, “Somaa tako bawet Jairo, ta adim aped taktaken nan Apo tako.” Danat getken ay natey san anakna. ");
INSERT INTO xnn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngem dinngen Jesus san kinwanina danat kanan ken Jairo, “Adika menseseg-ang. No waday talekmo ken sak-en et awnit gomawis siya.” ");
INSERT INTO xnn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Inomdanda issan baey et maid inpasgep Jesus is teken ay ipogaw nodi kedeng da Pedro, Juan, Santiago ya san aman ya inan nan onga. ");
INSERT INTO xnn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Men-ag-aga am-in nan ipogaw issan pantew ngem dat kanan Jesus, “Adi kayo men-ag-aga tay egay katey nan onga ay sana nodi maseseyep et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dadat sayoten siya tay getkenda ay natey et. ");
INSERT INTO xnn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ngem dat songgep si Jesus et gen-ana nan ledeng san onga danat kanan, “Anakko, ibangonmo.” ");
INSERT INTO xnn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dat somagong nan ab-abiikna et bomangon tet-ewa. Dat ibagan Jesus en pakanenda. ");
INSERT INTO xnn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nasdaaw da amana ngem inbagan Jesus ken daida en adida ibab-aag isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Issan esay agew inayagan Jesus san simpoo ya dowa ay apostolisna danat agtan daida is panakabalin ay mangipagawis isnan masaksakit ya mangipakaan isnan am-in ay anito. ");
INSERT INTO xnn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Danat ibaa daida ta omeyda ay mangibaga ay nganngani ay omali nan mentolayan Apo Dios dadapay pagawisen gedan nan masaksakit. ");
INSERT INTO xnn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Inbagana ken daida en, “Adi kayo omikawkawit is olay sokod, sangi, makan, siping ya mensokatanyo no menbaat kayo. ");
INSERT INTO xnn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","No waday mangsangaili ken dakayo isnan baeyda dakayot adi men-at-aton enggana ay taynanyo nan ili ay deey. ");
INSERT INTO xnn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngem no adida idnge dakayo isnan ili ay omayanyo dakayot komaan dakayopay pokpoken nan tapok isnan dapanyo ta ipailayo ay adyanda nan isoloyo.” ");
INSERT INTO xnn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dat omey san papasolotna isnan am-in ay il-ili ay mangibagbaga isnan gawis ay damag dadapay pagawisen nan wada nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Si Herod ay mentoltolay id Galilea et dinngena am-in nan inik-ikkan Jesus et nakolkol nan nemnemna tay wada nan mangwani en si Jesus et waay siya din si Juan ay Menbonbonyag ay kasin natago. ");
INSERT INTO xnn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kanan nan ib-ana en siya din si Elias ay ninpaila dapay kanan kayet nan ib-ana en siya din esa ay mamadto id kasin ay natago. ");
INSERT INTO xnn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dat kanan Herod, “Dakpay inpapoto nan olon Juan ngem ay sino ngata nan ipogaw ay ibagbagada ay sana?” Enggana isdi et kaytena ay mang-ila ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Issan sinmagongan san simpoo ya doway apostolis ay inbaan Jesus dadat ibaga ken siya am-in nan inik-ikkanda. Danat ipakkey daida et kedkedengda is inmey isnan pondag id Betsaida ");
INSERT INTO xnn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ngem idi gintek nan ipogaw ay inmeyda dadat omonod. Dat ayagan Jesus daida et isolowana daida isnan maipanggep nan mentolayan Apo Dios danapay pagawisen nan masaksakit. ");
INSERT INTO xnn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Masmasdem pay dat omey san simpoo ya doway pasolot Jesus ken siya et kananda en, “Nasdem datakopay daan isnan pondag. Ibagam kad ken da tona ta was-in omey isnan naisagsag-en ay il-ili ya isnan bab-aey isnan il-ilit ta enda makilang-ay dadapay omapa.” ");
INSERT INTO xnn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ngem dat kanan Jesus ken daida, “Dakayo nan mangpakan ken daida.” Dadat kanan, “Limlima ay tinapay ya dod-owa ay ikan nan wada ken dakami et kedeng. Ay omey kami lomako is kanen nan naayda ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dat ibilin Jesus isnan papasolotna ta patokdowenda daida is saglilimampoo. Waay limay libo ay lalalaki san wada isdi ngem egay kaibilang nan bababai ya nan oongong-a. ");
INSERT INTO xnn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dadat patokdowen nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Dat alaen Jesus san limay tinapay ya doway ikan dat mentangad id daya et men-iyaman ken Apo Dios esanapay amam-asen danat idya isnan papasolotna et iwatwatda. ");
INSERT INTO xnn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dadat mangan am-in et nabsogda dapay napno kayet nan simpoo ya doway lowa isnan binay-anda ay tinogop san papasolotna. ");
INSERT INTO xnn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Isnan namingsan ay kedkedeng da Jesus ya nan papasolotna dat menlowalo si Jesus. Nakwas pay ay makalowalo danat sooten ken daida, “Ay ngan nan pangwanin nan ipogaw ken sak-en?” ");
INSERT INTO xnn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dadat kanan, “Wada nan mangwani en sik-a din si Juan ay Menbonbonyag. Kanan nan tap-ina en sik-a din si Elias dapay kanan kayet nan tap-ina en kasin natago nan esa isdin mamadto id kasin.” ");
INSERT INTO xnn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Dakayo pay abes, ay ngan nan pangwaniyo ken sak-en?” sinootna ken daida. Dat kanan Pedro, “Sik-a si Kristo ay din inbagan Apo Dios ay awnit omali ay men-apo.” ");
INSERT INTO xnn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dat ibilin Jesus ken daida en masapol ay adida ibagbaga isnan olay sino ay ipogaw ");
INSERT INTO xnn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","danat itoloy ay mangwani, “Sak-en ay Iyon-an Am-in di Ipogaw et masapol ay awnitak mapaligatan. Nan aamam-an di Judio ya nan menkangangato ay papadi ya nan men-is-isolo isnan linteg et awnit adyanda sak-en dadapay mangipapatey ngem kasinak matago isnan maikatlo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Isnan namingsan et kinwanina ken daida am-in, “No sino nan manglayad ay maitapi ken sak-en et masapol ay ibilangna ay natey et nan awakna ta baken nan laydena is ik-ikkana nodi nan laydek ta itoledna nan ligat ay kaneg nan mang-aw-awit isnan krosna ta omonod ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tay nan ipogaw ay kedeng nan awakna is nemnemnemena et awnit matey met laeng ngem nan adi mangnemnemnem isnan awakna gapo ken sak-en et awnit matey ngem matagotago ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ay waday ganaben di ipogaw ay mangkowa is am-in ay kinabaknang isnan batawa no matey daet adi dawaten Apo Dios? Maid adi. ");
INSERT INTO xnn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","No sinoy mang-adi ken sak-en ya nan it-itdok et awnitko abes adyan daida isnan omaliyak ay mangipailaan isnan kangatok ya nan kangaton Ama ya nan kaangheanghelna. ");
INSERT INTO xnn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tet-ewa nan ibagak, wada ken dakayo nan matatago pay laeng engganay ilaenda nan panakabalin Apo Dios isnan mentolayana.” ");
INSERT INTO xnn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nallos nan waay esay domingo dat ayagan Jesus da Pedro, Juan ya si Santiago et omeyda menlowalo isnan bilig. ");
INSERT INTO xnn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Issan menlol-owalowan Jesus daet mateken nan angasna ya nan badona et pinmolapolaw ay mensilsilap. ");
INSERT INTO xnn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Dat nawanada nan ninpaila ay mensilsilang ay doway amam-a ay makitoytoya ken Jesus ay da Moses ken Elias ay ap-on di Judio id kasin. San kankananda et maipanggep isnan nganngani ay kateyan Jesus id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Da Pedro et naseypanda ngem dadat magido et ilanda ay mensilsilang si Jesus ya san dowa ay amam-a ay makitatakdeg ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Idi komak-aan san doway amam-a issan kad-an Jesus, kinwanin Pedro ken siya, “Apo, gawis tay wada tako isna. Omset kami is tolo ay bawi ta pala ken sik-a nan esa, pala ken Moses nan esa ya pala ken Elias nan esa.” Ngem aped kinwanin Pedro di tay nasngang et adina getken nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Daan ay menkalkali si Pedro daet kanaliboo et lingbana daida isonga inmegyat san papasolot Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dadat dengen nan kali ay nagapo isnan liboo ay mangwani, “Siya na nan Anakko ay pinilik ay mentolay isonga dengngenyo nan kanana.” ");
INSERT INTO xnn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Idi sinmaldeng san kali, kedeng si Jesus is inilada. San papasolotna et egayda inbagbaga san inilada engganay sokod natago kasin si Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kawakgatana ay ninlayogan da Jesus issan bilig et adoado nan ipogaw ay nangsab-at ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dat wada nan esay am-ama ay mangibogbogaw, “Apo, seg-angam kad nan naay kedkedeng ay anakko ");
INSERT INTO xnn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","tay wada nan anito ay mangkakapet ken siya et aped menbogbogaw dapay menkedas et tomaltalabotab nan topekna. Pakalokalowena ay adina taytaynan siya. ");
INSERT INTO xnn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mensegseg-angak isnan papasolotmo ta pakaanenda koma nan anito ngem adida kabaelan.” ");
INSERT INTO xnn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Dat kanan Jesus, “Palalo kayo od ay ipogaw id wani. Baken osto nan nemnemyo tay nabayagak ay nakitetee ken dakayo et palalo nan anosko ngem adi kayo kayet pomati.” Danat kanan issan aman san onga, “Iyalim nan anakmo isna.” ");
INSERT INTO xnn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Idi somagsag-en san onga ken Jesus dat pakedasen san anito danapay ibkas siya. Ngem dat bilinen Jesus san anito ta komaan isonga dat gomawis san onga dat kanan Jesus ken amana, “Naay nan anakmo.” ");
INSERT INTO xnn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Am-in san nang-ila et nasdaawda isnan panakabalin Apo Dios. Daan ay masmasdaaw nan kaipoipogaw issan am-in ay inikkan Jesus danat kanan issan papasolotna, ");
INSERT INTO xnn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Adiyo kalkalingkingan nan naay ibagak ken dakayo. Sak-en ay Iyon-an Am-in di Ipogaw et nganngani ay maitedak isnan mangdepap ken sak-en et kigadda ay mang-ikkan isnan kaytenda ay ikkan ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ngem adi getken nan papasolotna nan kayatna ay kanan tay egayna inpagtek ken daida. Ngem mabainda ay mangsoot ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nan papasolot Jesus et nintotyada no sino nan kapatgan ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngem getken Jesus nan kankananda isonga danat ayagan nan esay onga et patakdegena isnan sag-ena ");
INSERT INTO xnn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","danat kanan ken daida, “Nan manglayad ya mang-ayowan isnan kaneg nan naay onga gapo isnan pammatina ken sak-en et siya gedan nan kaneg nan layadna ken sak-en. Et nan manglayad ken sak-en, laydena abes nan nangbaa ken sak-en ay si Apo Dios. Tay nan kababaan ken dakayo et siya nan kapatgan ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dat kanan Juan, “Apo, inilami nan esay am-ama ay mangipakpakaan is anito isnan ipogaw gapo isnan pammatina kano ken sik-a. Ngem inyadimi siya tay baken tako ib-a.” ");
INSERT INTO xnn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dat kanan Jesus ken siya ya isnan iib-ana, “Adiyo iyad-adi siya tay nan adi mang-ap-apos ken dakayo et daida nan bomadang.” ");
INSERT INTO xnn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Idi nganngani nan kateyan Jesus ya nan katagowana kasin ya nan maipangatowana id daya, ninemnemna ay masapol ay omey siya id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isonga inpaon-onana nan papasolotna ay mangisagana isnan awnitda omapaan isnan esay ili isnan probinsiya ay Samaria tay laosanda ay omey id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ngem nan ipogaw isdi et adyanda ay omapa da Jesus tay id Jerusalem nan omayanda dapay adi patiyen nan iSamaria ay id Jerusalem nan osto ay pangdayawan ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Issan nangtekan san papasolotna ay da Santiago ken Juan ay adyan nan iSamaria daida dadat kanan ken Jesus, “Apo, ay dawatenmi ken Apo Dios ta poowana daida?” ");
INSERT INTO xnn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Danat sagongen daida et sagiitena daida ");
INSERT INTO xnn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","dadat omey isnan teken ay ili. ");
INSERT INTO xnn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Issan mendad-aananda kinwanin nan esay am-ama ken Jesus, “Omon-onodak ken sik-a olay intoy omay-ayam.” ");
INSERT INTO xnn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dat kanan Jesus ken siya, “Owen, ngem nemnemem ay gawis tay naligat nan ik-ikkak tay nan motit ya nan koyat et wada nan baeyda dapay sak-en ay Iyon-an Am-in di Ipogaw et maiwed osto is baeyko is omil-illengak.” ");
INSERT INTO xnn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Danat kanan abes isnan teken ay am-ama, “Omonodka ken sak-en.” Ngem kanan san am-ama, “Apo, awnika od ta makilebenak ken ama sakpay omonod ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dat kanan Jesus, “Nan iib-an amam ay adi mamati ken Apo Dios et kanegda natey isonga olay daida nan mangileben isnan iib-ada. Ngem sik-a, omeyka bawet ibagbaga nan maipanggep isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wada kayet nan esay am-ama ay nangwani ken Jesus, “Apo, makkeyak abes ken sik-a ngem omeyak od ipagtek isnan ag-ik.” ");
INSERT INTO xnn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ngem daet kanan Jesus, “Nan mensamsama ay mangsagosagong isnan dokogna et baken gawis nan samaena. Kaneg abes nan makmakkey ken sak-en ay mangsagosagong isnan dodokogana et adida mappay isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nakwas pay di dat piliyen Jesus nan teken ay pitompoo ya dowa ay pasolotna danat ibaa daida ay sindodwa ta omon-onada ay omey men-isolo isnan tonggal ili ay awnitna omayan. ");
INSERT INTO xnn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dat mensodok si Jesus en, “Adoado nan egay namati ken Apo Dios et kanegda nan pagey ay maani. Dakayo ay mangisolsolo isnan kalin Apo Dios et kanegyo nan men-ani ngem atiatik kayo isonga dawatenyo ken Apo Dios ay kakwa isnan maani ta omibaa is mangbadang ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Enkayo. Ibaak dakayo ay kanegyo nan naanos ay kalnilo ngem nan omayanyo et kanegda nan makedse ay aso. ");
INSERT INTO xnn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Adi kayo omikawkawit is siping, sangi ya sapatos dakayot idadawes ay adi kayo mensaldesaldeng ay makitoya isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","No songgep kayo isnan esay baey kananyo en, ‘Inmali kami ay mangipagtek isnan gawis ay biyag ay maid patenggana tapno tet-ewa ay menlamnin kayo.’ ");
INSERT INTO xnn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No waday manglayad ay mamati isnan isoloyo et dawatena ken Apo Dios nan gawis ay biyag ngem no adida patiyen et maid silbin nan insoloyo ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","No waday mangsangaili ken dakayo isnan baeyda dakayot mentetee isdi ay adi kayo men-atoaton is teken ay baey. Nan idyada ken dakayo et kanenyo ya inomenyo tay lebbengna ay itedda nan kanegyo lagbo ay men-isolo. ");
INSERT INTO xnn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Isonga siya nan ikkanyo isnan omayanyo isnan teken ay ili. Kanenyo nan idyada ");
INSERT INTO xnn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","dayopay pagawisen nan masaksakit ya ibagayo ken daida en, ‘Ipagtekmi ken dakayo ay inomdan nan mentolayan Apo Dios tapno maitapi kayo ken siya.’ ");
INSERT INTO xnn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngem no omey kayo isnan esay ili ya adyanda dakayo, omey kayo isnan kaponponokan nan ipogaw dakayot kanan, ");
INSERT INTO xnn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pokpokenmi nan tapok ay pinomket isnan sikimi isnan iliyo ta mangipaila en maid teken is ikkanmi ken dakayo nodi inmali kami ay mangipagtek en inomdan nan mentolayan Apo Dios ngem gapo tay adyanyo nan isolsolomi et adi kayo maitapi ken siya.’ ");
INSERT INTO xnn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ibagak ken dakayo en isnan mangbanagan Apo Dios isnan ipogaw et am-amed nan dosan san mang-adi isnan isoloyo mo nan iSodoma ay pinoowan Apo Dios id sang-adom gapo isnan dadama ay basolda.” Siya di nan kinwanin Jesus issan pitompoo ya doway pasolotna. ");
INSERT INTO xnn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dat itoloy Jesus ay mangwani, “Aye nan awnityo dosa ay iCorazin ya iBetsaida. Tay inilayo nan kaskasdaaw ay inik-ikkak isnan iliyo dayopay egay inbabawi nan basbasolyo. Id sang-adom palalo nan dosan Apo Dios id Tiro ya id Sidon ngem no daida koma nan nang-ila isnan kaskasdaaw ay inik-ikkak isna waay nabayag ay ninbadoda is mensampet ay sako dadapay itotokdo isnan dapo ay mangipaila en inbabawida nan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Isonga no omdan nan mangbanagan Apo Dios isnan ipogaw et am-amed nan dosayo mo nan iTiro ya iSidon. ");
INSERT INTO xnn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Dakayo pay abes ay iCapernaum ay mangipapangato isnan nemnemyo et awnit kayo maibkas isnan kad-an di apoy ay adi katkatkatey.” ");
INSERT INTO xnn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dat kanan Jesus isnan papasolotna, “Nan mangidnge ken dakayo et sak-en nan idngeda, et nan mang-adi ken dakayo, sak-en nan adyanda ya nan mang-adi ken sak-en et si Apo Dios abes ay nangibaa ken sak-en nan adyanda.” ");
INSERT INTO xnn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Adi pay issan nadandan dat men-galalasing ay mensagong san pitompoo ya dowa ay inbaan Jesus dadat kanan ken siya, “Apo, olay nan anito et pinatida dakami gapo isnan panakabalin ay wada ken dakami.” ");
INSERT INTO xnn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dat kanan Jesus, “Getkek ay epdas naabak si Satanas tay inilak ay naekdag ay nagapo id daya ay kaneg nan ikkan di kimat nan naekdagana. ");
INSERT INTO xnn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inidyak od nan panakabalinyo tasiyay olay gatgatinanyo nan oweg ya nan minoong et maid ngawi is om-ommat ken dakayo ya abakenyo gedan nan kabaelan Satanas. ");
INSERT INTO xnn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ngem baken nan mangpatiyan nan anito ken dakayo is men-gasinganyo nodi nan men-gasinganyo et nan naisolatan nan ngadanyo isnan listaan di ngadan id daya tay siya nan kail-ana ay matagotago kayo ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Idi nakwas san ibagbagan Jesus ken daida dat menlowalo ken Apo Dios tay inpagasing nan Ispirito Santo siya et kanana en, “Ama, sik-a nan Apo id daya ya isnan batawa. Men-iyamanak ken sik-a tay inpagtekmo isnan egay nakaadal nan tet-ewa ay maipanggep ken sak-en ngem egaymo inpagtek isnan mangwani en nalaing ya masilib tapno adida maawatan. Owen Ama, tay siya nan kayatmo ay maikkan.” ");
INSERT INTO xnn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Danat kanan isnan ipogaw isdi, “Inyalin Ama nan am-in ay wada ken sak-en. Maid ipogaw is mangtek isnan am-in ay maipanggep ken sak-en nodi kedeng si Amak ya maid gedan mangtek isnan am-in ken Ama nodi kedengak ay Anakna ya nan pinilik ay mangipagtek isnan maipanggep ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dat sagongen Jesus san papasolotna et kedengda isnan nangwaniyana en, “Dakayo et iilaenyo nan ik-ikkak ya dedengngenyo nan kankanak ");
INSERT INTO xnn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","isonga nagasat kayo mo nan adoado ay mamadton Apo Dios ya ali id kasin tay kakakayatda ay mang-ila isnan il-ilaenyo id wani ngem egayda inila ya kaytenda abes ay mangdenge isnan dengdengngenyo id wani ngem egayda nakadnge.” ");
INSERT INTO xnn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dat wada nan esay men-is-isolo isnan linteg Apo Dios ay inmey ken Jesus tay kayatna ay sikapan siya danat sooten, “Apo, ay ngan nan masapol ay ikkak ta matagowak ay eng-enggana ken Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Dat sooten abes Jesus ken siya, “Ngan nan kanan nan linteg isnan liblon Apo Dios? Ngan nan mang-awatam?” ");
INSERT INTO xnn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dat songbatan san men-is-isolo, “Masapol ay laylayden tako ay ostoosto si Apo Dios ay Apo tako isnan nemnem ya poso tako ya isnan am-in ay ik-ikkan tako ya masapol gedan ay laylayden tako abes nan iib-a tako ay kaneg nan pananglayad tako isnan awak tako.” ");
INSERT INTO xnn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dat kanan Jesus, “Nan songbatmo et osto. Ikkam na et awnit matagotagoka.” ");
INSERT INTO xnn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ngem tapno adi kabainan san men-is-isolo sinootna kasin ken Jesus, “Sino nan iib-ak?” ");
INSERT INTO xnn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dat mensodok si Jesus et kanana, “Wada nan am-ama ay Judio ay nagapo id Jerusalem ay lomaylayog id Jerico dat sab-aten nan mangakew et sogtosogtowenda dadapay pat-opat-owan dadat alaen am-in nan kowana ya nan badona dadat taynan ay matmatey. ");
INSERT INTO xnn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dat wada nan Judio ay padi ay lomaos et inilana san matmatey ay am-ama ngem dat omigid et teken nan idaana. ");
INSERT INTO xnn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dat wada kasin nan lomaos ay bomadbadang isnan Templon Apo Dios ay makwani en Levite et dinatngana san matmatey ay am-ama danat aped ilaen siya danapay laosan et kedeng. ");
INSERT INTO xnn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wada pay nan lomaos ay iSamaria ay kaliliget nan Judio et idi inilana san am-ama dat dadama nan seg-angna. ");
INSERT INTO xnn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Dat omey et agasana nan nasogatan danapay bedbeden danat isakay san am-ama isnan kabayona et eyeyna isnan pag-abangan danat ay-ayowanan siya. ");
INSERT INTO xnn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kawakgatana dat agtan san iSamaria is siping san kabaey isnan pag-abangan danat ibaga ken siya en, ‘Banbantayam siya ta no somagongak kasin isna ya no waday kolangna et awnitak anayan.’” ");
INSERT INTO xnn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dat sooten Jesus issan men-is-isolo isnan linteg Apo Dios en, “Ken sik-a, sino ken da tona ay tolo nan kanam en ib-an san am-ama ay pinaligat di mangakew?” ");
INSERT INTO xnn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Danat kanan, “San nangseg-ang adi ken siya.” Dat kanan Jesus, “Omeyka et, ta ikkam abes nan gawis ay kaneg san inikkan san iSamaria.” ");
INSERT INTO xnn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isnan nindad-aanan da Jesus ya san papasolotna, dinatnganda nan esay ili ay kad-an nan in-ina ay kangadan is Marta ay nangsangaili ken da Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wada nan innodin Marta ay si Maria ay mangdedenge isnan isolsolon Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dapay kedkedeng si Marta is mensonsoni ay mang-ik-ikkan isnan obla isonga nabbay dat omey ken Jesus et kanana, “Apo, kedkedengak is mensonsoni ay mang-ik-ikkan isnan obla isonga no maseg-angka ken sak-en et ibagam ken innodik ta omali ay bomadang.” ");
INSERT INTO xnn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dat kanan Jesus, “Marta, Marta, dakan aped madanagan is mensonsoniyam et kedeng ay adika od mendenge ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Si Maria et pinilina nan mapaay tay mendedenge ken sak-en et adi makaan san dinngena.” ");
INSERT INTO xnn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Isnan namingsan et ninlowalo si Jesus ken Apo Dios. Dat kanan nan esay pasolotna ken siya, “Apo, itdowam dakami ay menlowalo ay kaneg nan inikkan Juan ay nang-itdo isnan papasolotna.” ");
INSERT INTO xnn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dat kanan Jesus ken daida, “No menlowalo kayo siya na nan kananyo. Ama, madaydayaw koma nan ngadanmo. Omdan koma ay dagos nan mentolayam. ");
INSERT INTO xnn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Agtam dakami is menkatagomi isnan inagew. ");
INSERT INTO xnn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakawanem nan basbasolmi dakami pay pakawanen abes nan nakabasol ken dakami. Ya adim ipalobos dakami ay madoldolog ay menbasol.” ");
INSERT INTO xnn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Dat mensodok si Jesus ay mangwani, “Kadya no waday gayyemmo dakat omey isnan baeyna isnan tengan di labi dakat kanan ken siya, ‘Gayyem, kadya omatedka is binay-anyo tay wada nan dinmag-os ay sangailik dapay maid ipakanko.’ ");
INSERT INTO xnn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ngem sinmongbat san gayyemmo ay wada isnan baey, ‘Adika mangtawtaw tay epdas kami nindakig ya inpodanmi isnan an-akko et adiyak layden ay bomangon.’ ");
INSERT INTO xnn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","No ipapatim ay ngan ngata nan ikkana? Ibagak ken dakayo, olay no gayyemmo, adi bomangon ay mang-ated ken sik-a isnan masapolmo ngem gapo tay ipapatim et kapilitan ay bomangon et itedna nan am-in ay masapolmo. ");
INSERT INTO xnn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kaneg todi nan ikkanyo ay menlowalo ken Apo Dios. No waday masapolyo dayot dawaten ken siya et awnit itedna nan masapolyo. No waday an-anapenyo et awnityo datngan. No menkogkogkog kayo isnan segpan et awnit tokabana ta songgep kayo. ");
INSERT INTO xnn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tay am-in ay kadadanawat ya kalalanowalo ken Apo Dios et awnitna agtan ya am-in ay menkogkog et awnit tokabana nan eneb ta songgepda. ");
INSERT INTO xnn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ken dakayo waay maid ama is en mang-idya is oweg isnan anakna no mendawat is ikan ");
INSERT INTO xnn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","wenno agtana siya is gayaman no mendawat is itlog. ");
INSERT INTO xnn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Adi, tay olay no ngawi kayo ay ama et getkenyo ay mang-ited isnan an-akyo is gawis. Ngem am-amed adi nan ikkan Ama tako id daya tay nan itedna isnan mendawat et nan Ispirito Santo.” ");
INSERT INTO xnn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wada nan am-ama ay inomel di anito. Inilan Jesus danat pakaanen san anito et kasin dadlo menkali san am-ama. Nasdaaw san nang-ila ");
INSERT INTO xnn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ngem kanan nan tap-ina en, “Si Beelzebub ay Satanas ay apon di dimonyo nan nang-idya ken tosa isnan kabaelana ay mangipakaan is dimonyo.” ");
INSERT INTO xnn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nan tap-ina et kayatda ay allilawen si Jesus isonga kananda en kasin omipaila is kaskasdaaw no tet-ewa ay si Apo Dios nan wada ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ngem getken Jesus nan nenemnemenda isonga danat kanan ken daida, “Iyalig tako isnan sinpangbon. No mensaspe nan sinpangbon et adi mentoloy nan om-ombonanda. Kaneg abes nan sinbaey, no maid olnosda et mabokada. ");
INSERT INTO xnn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Isonga adi mabalin ay sapeen Satanas nan bab-aana tay getkena ay no isapena daida awnit mamaid nan tolayna. Ay kananyo en si Satanas nan nangyali isnan kabaelak ay mangipakak-aan is anito? ");
INSERT INTO xnn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","No siya di into pay nan nagapowan nan kabaelan nan iib-ayo ay Judio ay mangipakaan is anito? Tay nan ik-ikkan nan ib-ayo et siya nan mangipaila ay baken si Satanas is mangbadbadang ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Siya nan kagtekana ay si Apo Dios nan nangyali isnan kabaelak ay mangipakpakaan is anito. Et siya gedan nan mangipagtek ay inmali nan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Dat mensodok si Jesus ta ipagtekna en napigpigsa nan panakabalina mo si Satanas. Kanana, “Si Satanas et kanegna nan napigsa ay ipogaw ay mangbanbantay isnan baeyna et menbabalbeg ya men-gagamig siya ta maid mangakew isnan bonagna. ");
INSERT INTO xnn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ngem no sapeen ya abaken nan napigpigsa ay ipogaw san mangbanbantay is baeyna maalana nan balbeg ya gamig ay mangsalsalaknib koma issan kasapena danat alaen gedan nan bonag san inabakna et iwalasna isnan iib-ana. ");
INSERT INTO xnn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Isonga am-in ay adi maitapi ken sak-en, daida nan mang-ap-apos ken sak-en. Am-in nan adi bomadang ay mangponok isnan ipogaw et daida nan mangipaad-addawi isnan ipogaw ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Dat itoloy Jesus ay mensodok ay mangwani, “Wada nan am-ama ay kinapet di anito dat taynan san anito san ipogaw et omey isnan bilbilig ay maid polos danom et men-an-an-anap is omillengana ngem maid datngana isonga danat kanan en, ‘Somagongak issan ipogaw ay nagapowak.’ ");
INSERT INTO xnn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Dat somagong et datngana san nagapowana ay nadalosan. ");
INSERT INTO xnn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dat omey kasin men-ayag is pito ay anito ay makedkedse mo siya et komapetda issan ipogaw ay tinaynana. Dat am-am-amed ngawi et nan ommat issan ipogaw mo san damo.” ");
INSERT INTO xnn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Idi menkalkali si Jesus, inbiyad nan esay in-ina ay makikib-on isnan ipogaw ay mangwani en, “Nagasat nan ina ay nangiyanak ya nang-ay-ayowan ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dat kanan Jesus, “Nagasgasat kayet nan ipogaw ay mangidnge ya mamati isnan kalin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Inaalibongbongan nan kaipoipogaw si Jesus danat itoloy ay mangwani, “Palalo nan kangawin di ipogaw id wani ay timpo tay laydenda ay omipailaak is kaskasdaaw sadapay mamati ken sak-en. Ngem maid polos ipailak nodi kedeng nan kaneg din kaskasdaaw ay inommat isdin si Jonas. ");
INSERT INTO xnn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tay din si Jonas et nintetee isnan eges di dakkel ay ikan is toloy agew et siya nan pangilaslasinan nan iNineve ay siya nan inbaan Apo Dios ay mangibaga isnan kalina. Kaneg abes ken sak-en ay Iyon-an Am-in di Ipogaw et nan awnit ommat ken sak-en nan pangilaslasinan nan ipogaw id wani. ");
INSERT INTO xnn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Isnan awnit mabanagan nan ipogaw et wada nan in-ina ay reyna id Seba ay mangpabasol ken dakayo tay id kasikasin et nagapo siya isnan addaaddawi ay ili. Ngem inmey kayet ay mangdenge isnan insolon nan kasiliban ay ali ay din si Solomon. Isonga pabasolena dakayo tay adiyo polos idnge ya patiyen nan inmali ken dakayo dapay nangatngato mo si Solomon. ");
INSERT INTO xnn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Isnan mabanagan nan ipogaw et pabasolen gedan nan iNineve dakayo tay inbabawida nan basbasolda issan nangdengnganda isdin insolsolon din si Jonas dapay nan inmali ken dakayo et nangatngato mo si Jonas dapay adiyo kayet patiyen.” ");
INSERT INTO xnn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Dat itoloy Jesus, “Maiwed mangpasged is silaw danat igwa isnan masasalinan wenno tangbana is sokong nodi masapol ay ipatangna tapno menpat-a no songgep nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nan mata et siya nan kaneg nan silaw nan awak isonga no gawis nan pangiilam isnan ib-am et kaneg menpat-a nan awakmo tay gawis nan wada isnan nemnemmo. Ngem no ngawi nan pangiilam isnan ib-am et kaneg menbolinget nan awakmo tay ngawi nan wada isnan nemnemmo. ");
INSERT INTO xnn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Makailanyo ngalod ta masilawan ay gawis nan nemnemyo. ");
INSERT INTO xnn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tay no gawis nan nemnemyo ay maiwed ngawi is ik-ikkanyo et menpat-a nan awakyo ay kaneg nan kapat-an nan sisilangan nan silaw.” ");
INSERT INTO xnn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nakakali pay si Jesus dat ayagan nan esay Fariseo siya ta omeyda mangan isnan baeyda. Dat omey si Jesus et makilikob. ");
INSERT INTO xnn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ngem nasdaaw san nang-ayag ken siya isnan nang-ilaana ay egay ninboo si Jesus ay kaneg nan ogalida esadapay mangan. ");
INSERT INTO xnn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Isonga dat kanan Jesus ken siya, “Dakayo ay Fariseo et kanegyo nan mang-owas isnan tasa ya nan palato ay kedkedeng nan maiila is owasana. Siya di nan kanegyo tay menboo kayo ngem adiyo dalosan nan ngawi isnan nemnemyo ay kinaagom ya sowitik. ");
INSERT INTO xnn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ong-ong kayo. Si Apo Dios ay nangsapo isnan awak ay daldalosanyo et sinapona gedan nan nemnem. ");
INSERT INTO xnn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Isonga masapol ay dalosanyo nan nemnemyo tapno getkenyo ay mangseg-ang isnan ib-ayo. Tay no gawis nan nemnemyo ay adi kaiila et gawis abes nan ik-ikkanyo ay maiila. ");
INSERT INTO xnn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aye nan awnityo dosa dakayo ay Fariseo tay tet-ewa ay dalonyo tongpalen nan linteg Apo Dios ay kaneg nan mang-ag-agtanyo ken siya is bingayna ay olay nan kaatikan ay ap-apitenyo ay mangpabango isnan madengdeng ngem kalingkinganyo nan osto ay ikkanyo isnan ipogaw ya nan mangipailaanyo ay laylaydenyo si Apo Dios. Gawis nan mang-it-itedanyo isnan bingayna ngem masapol ay adiyo kalkalingkingan nan naayda ay kaam-amedan isnan linteg. ");
INSERT INTO xnn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Aye nan awnityo dosa dakayo ay Fariseo. Kaykayatyo ay dakayo nan wedweda ay tomokdo isnan kagawisan ay tokdowan isnan paggimonganyo ya madaydayaw isnan kad-an nan adoado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kaseseg-ang kayo. Kanan nan ipogaw en gawis no makikib-ada ken dakayo ngem adida getken ay apedda maalisan isnan ngawi ay ogaliyo,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dat kanan nan esay men-is-isolo isnan linteg ken Jesus, “Apo, isnan mangmangwaniyam issa et maitaptapi kami ay mabab-ainan.” ");
INSERT INTO xnn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Dat kanan Jesus, “Aye nan awnityo dosa dakayo gedan ay men-is-isolo isnan linteg. Kanegyo ipaawit isnan ipogaw nan mendagsen ay awit tay ipapatiyo ay ikkanda nan lintegyo ay adi mabalin ay maikkan dayopay adi badangan daida. ");
INSERT INTO xnn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kaseseg-ang kayo. Tay isapsapowanyo is pantiyong din mamadton Apo Dios id kasin ay pinatpatey din alal-apoyo. ");
INSERT INTO xnn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nan pantiyong ay sapsapowenyo et siya nan kail-ana ay iyoowogyo din nangpatpateyan din alal-apoyo isdin mamadto id kasin. ");
INSERT INTO xnn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Siya na nan mangipaila ay tet-ewa nan kinwanin Apo Dios id kasin ay naay, ‘Awnitak ibaa nan mamadtok ya nan papasolotko ay mangisolsolo isnan ipogaw ngem awnitda pateyen nan tap-ina dadapay aposen nan tap-ina.’ ");
INSERT INTO xnn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Isonga nan ipogaw id wani et awnit madosada gapo isnan napatpateyan nan am-in ay mamadto enggana isdin nakaboliwan nan batawa ");
INSERT INTO xnn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ay menlogi isdin napateyan Abel enggana isdin napateyan Zacarias ay pinateyda isnan pantew ay ninbaetan nan Templo ya nan altar. Owen, ibagak ken dakayo ay awnit madosa nan ipogaw id wani gapo ken daida am-in ay napatpatey. ");
INSERT INTO xnn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aye nan awnityo dosa dakayo ay men-is-isolo isnan linteg tay dakayo nan lebbengna ay mangisolo isnan kalin Apo Dios ngem egayyo insolo tay adi kayo od mamati ken siya dakayo pay iyad-adi nan ipogaw ay manglayad ay mamati,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Idi binmala si Jesus isnan baey di Fariseo, linmiget san deeyday Fariseo ya nan men-is-isolo is linteg isonga siya nan ninlogiyan nan adoado ay sos-ootenda ken siya ");
INSERT INTO xnn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tay kaytenda ay depapen no waday kanana is ngawi ta waday gapo is mangipabasolanda ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Napoposek nan ipogaw ay mang-al-alibongbong ken da Jesus isonga men-gin-ginatinda. Dat kanan Jesus issan papasolotna, “Makail-ilanyo ta adi kayo maalisan isnan aginsisingpet ay Fariseo ay kaneg nan bobod ay mang-alis isnan kaibobodana ay tinapay. ");
INSERT INTO xnn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kananda en maid mangtek isnan ogalida ngem awnit gedan magtek. Tay nan am-in ay egay kagtek ay naikkan et awnit magtek met laeng. ");
INSERT INTO xnn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ya olay nan kankananyo isnan labi et awnit magtek isnan kag-aw ya nan am-in ay inyag-agasaasyo isnan naeemban ay kowalto et awnit maipabala isnan pag-ag-aggongan.” ");
INSERT INTO xnn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ibagak ken dakayo ay gagayyemko, adi kayo omeg-egyat isnan menpatpatey tay kedeng nan awak di ipogaw is pateyenda. ");
INSERT INTO xnn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Si Apo Dios koma nan omegyatanyo tay no matey nan ipogaw et wada nan kalebbengana ay mang-igwa ken daida id impilno. Owen, siya nan masapol ay omegyatanyo. ");
INSERT INTO xnn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ngem dakdake abes nan layadna tay olay nan biding ay maiwed banolna ay malakowan nan lima is dowa ay galak et adi kalingkingan Apo Dios daida. ");
INSERT INTO xnn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Am-amed kayo ay ipogaw et nenemnemen Apo Dios dakayo tay olay nan bookyo et getkena nan kabibilangda. Isonga adi kayo omegyat tay am-amed kayo is ipatpateg Apo Dios mo nan adoado ay biding.” ");
INSERT INTO xnn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ibagak ken dakayo, nan mangibagbaga isnan kaipoipogaw en mamati ken sak-en ay Iyon-an Am-in di Ipogaw et awnitko abes ibaga isnan aanghel Apo Dios en ipogawko daida. ");
INSERT INTO xnn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ngem nan mangibagbaga ay adyana sak-en et awnitak adyan abes siya isnan aanghel Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Am-in ay menkalkali is ngawi maipanggep ken sak-en et mabalin ay mapakawan nan basolna ngem nan menkalkali is ngawi maipanggep isnan Ispirito Santo et adi mabalin ay mapakawan. ");
INSERT INTO xnn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","No idalomda dakayo isnan apon di Judio ya isnan howis gapo isnan pammatiyo ken sak-en et adi kayo madadanagan is awnityo isongsongbat isnan sos-ootenda ken dakayo ");
INSERT INTO xnn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","tay nan Ispirito Santo nan awnit mangipagtek isnan isongbatyo,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nan esay lalaki ay nakikib-on isnan kaipoipogaw et kinwanina ken Jesus, “Apo, ibagam kad isnan besatko ta agtana sak-en is kowak isnan tawidmi ta adina bobokodan.” ");
INSERT INTO xnn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ngem dat kanan Jesus, “Kigad kayo adi tay egayak inmali ay mangbanag isnan tawidyo.” ");
INSERT INTO xnn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Danat itoloy ay mangwani ken daida am-in, “Makail-ilanyo ta adi kayo men-ap-apal. Tay nan tet-ewa ay katagowan di ipogaw et baken nan kaad-adon di bonagna is kagapowana.” ");
INSERT INTO xnn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dat sodoken Jesus ken daida nan naay, “Wada nan esay kadangyan ay gawis nan ap-apitena. ");
INSERT INTO xnn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Danat nemnemen, ‘Maiwed somya is mangidolinak isnan am-in ay ap-apitek. Ay ngan ngen nan ikkak? ");
INSERT INTO xnn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","A, siya na gayam nan ikkak. Bakasek am-in nan agamangko ta mensaadak is dadadakke tasiyay omanay nan mangidolinak isnan am-in ay ap-apitek ya nan bonagko gedan. ");
INSERT INTO xnn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Daket kanan isnan awakko en nagasatak tay wada am-in nan gawis ay masapolko is katew-etew-en. Isonga mabalin ay gan-ganasek nan biyagko. Owen. Manganak, ominomak, dakpay gan-ganasen et kedeng.’ ");
INSERT INTO xnn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ngem dat kanan Apo Dios ken siya, ‘Tollolka tay mateyka is labi et sino ngen di esa mang-ala isnan am-in ay kokwam?’” ");
INSERT INTO xnn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dat kanan Jesus, “Siya na nan maikkan isnan deeyda ay ipogaw ay aped mangbobokod isnan kinabaknangda ngem bakenda baknang isnan pangiil-an Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dat kanan Jesus isnan papasolotna, “Siya na nan gapo ay ibagak ken dakayo en adi kayo madanagan is menkatagoyo ya is ibadoyo. ");
INSERT INTO xnn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tay wedweda nan biyag mo nan makan ya nan awak mo nan bado. ");
INSERT INTO xnn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ilaenyo pod nan gayang. Adida menmola ya men-ani et maid agamangda dapay pakanen kayet Apo Dios daida. Am-amed nan mang-ayowanana ken dakayo tay napatpateg kayo mo nan koyat. ");
INSERT INTO xnn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Olay enka mennemnenemnem ngem aykeka makaipaan-ando is biyagmo is olay esay olas? ");
INSERT INTO xnn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","No nan bassit et maid mabalinanyo is ikkan dakayon aped madanagan is teken? ");
INSERT INTO xnn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ilaenyo pod nan sabsabong ay tomobtobo. Adida men-obla ya adida men-abe is badoda. Ngem ibagak ken dakayo en mabmabgew nan sabsabong mo nan kagawisan ay badon din si Ali Solomon ay kabaknangan id sang-adom. ");
INSERT INTO xnn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","No gawis nan nemnem Apo Dios isnan sabsabong isnan tomotobowanda is sin-awyan dat maango et mapoowan, am-am-amed nan mangnemnemana ay mangbado ken dakayo. Kolang bawet nan talekyo. ");
INSERT INTO xnn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Adi kayo ngalod madadanagan is kanenyo. ");
INSERT INTO xnn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tay siya nan pilmi ay nenemnemen nan adi mamati ken Apo Dios. Ngem dakayo et getken Amayo id daya nan am-in ay masapolyo. ");
INSERT INTO xnn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Isonga paam-amdenyo kayet ay mangnemnem isnan mentolayan Apo Dios et awnit itedna ken dakayo nan am-in ay masapolyo.” ");
INSERT INTO xnn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Dakayo ay papasolotko ay ay-ayowanak, adi kayo omegyat olay at-atik kayo tay si Amayo id daya et men-gasing ay mangitapi ken dakayo isnan mentoltolayana. ");
INSERT INTO xnn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Isonga ilakoyo nan kokwayo dayopay ited nan lakona isnan kokodokdo et kanegyo isagana nan sopot ay adi madondonot tay id daya nan kad-an di kinabaknangyo et isdi adi makeskesayan ya maiwed mangakew is makasag-en ya maiwed ataming is mangbotbot. ");
INSERT INTO xnn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tay no id daya nan kad-an nan kinabaknangyo et siya gedan nan kad-an nan nemnemyo ngem no isnan batawa nan kad-ana et siya abes nan kad-an nan nemnemyo.” ");
INSERT INTO xnn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Intoloy Jesus ay mangwani isnan papasolotna, “Masapol ay mensagana kayo ay kaneg nan mabab-aa ay mangses-eed isnan apoda ay inmey nakibabayas. Menbabadoda ya mensisilawda ta no somaa nan apoda ya menkogkog et ikakamoda ay mangtokab isnan eneb. ");
INSERT INTO xnn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Men-galalasing nan mabab-aa no nagigidoda ya nakasaganada ay datngan nan apoda. Ibagak ken dakayo en awnit patokdowen nan apoda daida isnan pagkakanan danat pakanen daida. ");
INSERT INTO xnn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Olay no tengan di labi wenno maladladaw pay nan somaan nan apoda et men-galalasing kayet nan sanaday mabab-aa no nagigidoda. ");
INSERT INTO xnn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Adiyo kalkalingkingan nan naay, no getken nan akinbaey nan osto ay olas ay omaliyan nan mangakew, adi polos kaseyep ta adi makasgep nan mangakew. ");
INSERT INTO xnn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Isonga dakayo et kanayon ay masapol ay mensasagana kayo abes tay maid mangtek no tongona nan omaliyak ay Iyon-an Am-in di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dat kanan Pedro, “Apo, ay dakami ngen nan mangibagbagaam isnan sodsodokem wenno nan am-in ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Dat kanan Jesus, “Nan matalek ya masilib ay baa et siya nan piliyen nan apoda ay mangipangpango isnan iib-ana ay baa ta siya nan kigad ay mang-ited isnan kanenda. ");
INSERT INTO xnn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Men-gasing nan sanay baa isnan domatngan nan apoda no inikkana nan inbilin nan apoda ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ibagak ken dakayo nan tet-ewa, gapo tay matalek siya et awnit siya nan mangitalkan nan apoda isnan am-in ay kowana. ");
INSERT INTO xnn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ngem nan adi katalek ay baa et nenemnemena ay waay madmadney nan somaaan nan apona isonga ngawi nan ikkana tay baigena nan ib-ana ay baa ay lalalaki ya bababai ya aped makikikan isnan ipogaw dapay menboteng. ");
INSERT INTO xnn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Daet somaa san apoda isnan agew ay adi getgetken san baa daet dosaen nan apoda siya et ipaliknana ken siya nan dosan di adi katalek ay baa danat pateyen. ");
INSERT INTO xnn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nan baa ay mangtek isnan kayat nan apona ay ikkan ngem adina tongpalen et madosa siya is mendagsen. ");
INSERT INTO xnn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ngem nan baa ay adi mangtek isnan kayat nan apona ay ikkan dat bomasol, mayapyap-ew nan dosana. Tay nan kaad-adon nan nait-ited ken siya et siya abes nan kaad-adon nan magamgam ken siya. Isonga no ad-ado nan nait-ited ken siya mo nan ib-ana et awnit ad-ad-ado pay nan magamgam ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Getkek ay nan inmaliyak isnan batawa et siya nan gapo ay makawas nan olnos nan kaipoipogaw tay masis-iyanda ay kaneg nan ikkan nan apoy ay mangkawas isnan poowana isonga kaytek ay epdas makwas koma. ");
INSERT INTO xnn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ngem masapol ay mapaligatak omon-ona et maol-olawak enggana ay makwas. ");
INSERT INTO xnn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ay kananyo ngen en inmaliyak ay mangiyali is talna isnan batawa? Ngem baken nodi inmaliyak ay mangsis-iyan isnan kaipoipogaw tay mamati nan tap-ina ken sak-en dapay adi mamati nan tap-ina. ");
INSERT INTO xnn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Menlogi id wani, nan sinbaey no limada et awnitda masis-iyan tay men-innaposda et aposen nan tolo nan dowa, ya aposen abes nan dowa nan tolo. ");
INSERT INTO xnn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Olay nan sin-ama ya sin-ina et awnit men-innaposda am-in ya olay nan an-akda. Olay nan sinkatogangan et men-innaposda gedan.” ");
INSERT INTO xnn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Dat kanan gedan Jesus issan kaipoipogaw, “No ilaenyo nan menngitiyan ay liboo ay magapgapo isnan kaonogan di agew kananyo en awnit omodan dat omodan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No abes getkenyo ay magapgapo nan dagem isnan abagatan kananyo en awnit palalo abes nan atong dat pomoos tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aginlalaing kayo tay mabalinyo ay ibaga nan timpo no ilaenyo nan batawa ya nan daya. Ngem dakayon adi getken nan sinyal Apo Dios isnan ommat id wani.” ");
INSERT INTO xnn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Dakayo ay aginsisingpet, dayon adi nemnemen nan masapol ay ikkanyo? ");
INSERT INTO xnn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Id wani mabalin pay ay ibabawiyo nan basbasolyo ta mamati kayo ken sak-en. Tay kanegyo nan nakaotang ay awnit maidalom gapo isnan otangna. Esanapay idalom sik-a et masapol ay ipakatmo nan kabaelam ay makialiglo tapno adina eyey sik-a isnan howis tay nan howis et awnit eyeyna sik-a isnan polis et nan polis awnit ibalod daka. ");
INSERT INTO xnn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ibagak ken sik-a en adika makabala isnan pagbalodan enggana ay bayadam am-in nan otangmo. Kaneg todi nan awnit ikkan Apo Dios ken dakayo no adiyo ibabawi nan basbasolyo esapay omdan nan pinagdosa.” ");
INSERT INTO xnn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Issan nin-isolowan Jesus et wada nan tap-in di ipogaw ay inmey ken siya ay mangibaga isnan inikkan Gobilnadol Pilato tay inpapateyna nan iGalilea isnan mangpalpaltiyanda isnan idatonda ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dat kanan Jesus ken daida, “No napateyda ay keg todi, waay kananyo en siya nan mangipaila ay am-amed nan basolda mo nan ib-ada ay iGalilea. ");
INSERT INTO xnn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngem ibagak ken dakayo en baken sa tay no adi kayo ibabawi nan basbasolyo et awnit matey kayo am-in ay kanegda. ");
INSERT INTO xnn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ngan pay abes nan kananyo isnan simpoo ya wao ay nagat-onan ay natey id Siloe ay sakop di Jerusalem? Ay kananyo ngen en am-amed nan basolda mo nan tap-in di kailiyanda? ");
INSERT INTO xnn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngem baken gedan. Ibagak kasin ken dakayo, no adi kayo ibabawi nan basbasolyo et awnit matey kayo am-in ay kanegda.” ");
INSERT INTO xnn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dat ibagan Jesus nan naay sodsodok ken daida, “Wada nan kaiw ay makwani en higos ay inis-ek nan esay am-ama. Idi omdan nan bomgasana koma dat omey et ena ilaen no waday begasna ngem maid. ");
INSERT INTO xnn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Isonga danat kanan issan mangbanbantay issan om-ana, ‘Ilam, toloy tew-en ay inmal-aliyak ay nang-il-ila isnan mola ay naay dapay maid polos begasna is dinasdas-ak. Poyowem na. Ay aped obpay tomotobona ay mang-amin isnan abonon nan lota?’ ");
INSERT INTO xnn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ngem dat kanan san mangbanbantay, ‘Apo, bay-am kadya ta kaobak od nan liliwesena daket abonowan ");
INSERT INTO xnn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","et no is tew-en dat bomgas, gawis, ngem no adi dakat ipapoyo.’” Siya na nan sinodok Jesus tay nan kaiw ay adi bombomgas et siya nan kaneg nan Judio ay adi mamati ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sinabado ay obayan di Judio. Issan esay Sabado men-is-isolo si Jesus isnan sinagoga ");
INSERT INTO xnn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","dat wada nan in-ina ay binakog di anito is simpoo ya wao ay tew-en et adi polos makatakdeg ay menleteg. ");
INSERT INTO xnn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Issan nang-ilaan Jesus ken siya danat ayagan et kanana, “Ina, gomawis nan sakitmo.” ");
INSERT INTO xnn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dat gen-an Jesus siya dat tomakdeg et menleteg dadlo danapay dayawen si Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ngem nan ap-apo isnan sinagoga et nakaliget ken Jesus tay apedna pinagawis san in-ina dapay obaya. Isonga danat kanan isnan kaipoipogaw, “Enem ay agew nan men-oblaan tako et siya dadi ay agew nan omaliyanyo ay menpaagasan ay baken nan obaya.” ");
INSERT INTO xnn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ngem dat kanan Jesus ken siya, “Dakayo ay aginsisingpet. Isnan obaya et men-obla kayo gedan tay ipokayyo nan nowangyo ya bakayo ay mangipainom ken daida. No siya di nan ikkanyo, ");
INSERT INTO xnn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ay ngawi ngen no men-oblaak isnan obaya ta pagawisek nan in-ina ay naay ay apon din si Abraham dapay pinalpaligat Satanas is simpoo ya wao ay tew-en?” ");
INSERT INTO xnn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gapo isnan kinwanin Jesus, nabainan am-in san mang-ap-apos ken siya. Ngem san tap-in di ipogaw et men-gasingda isnan am-in ay kaskasdaaw ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dat itoloy Jesus ay mangwani, “Naay di sodsodokko ay mangibaga isnan kaneg nan mentolayan Apo Dios ya nan adoado ay awnit maitapi ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nan kanegna et nan teeteen ay bowa ay nais-ek dat tomobo et pomanga is dadadadakke et masasalinan nan bomaey ay koyat.” ");
INSERT INTO xnn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Danat kasin kanan, “Naay pay nan kaneg nan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kanegna nan bobod ay intapin nan in-ina isnan tinapay ay olay bassit et bomma isnan kaibobodana.” ");
INSERT INTO xnn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Issan inmayan Jesus id Jerusalem et nin-isolsolo isnan linal-aosana ay il-ili. ");
INSERT INTO xnn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dat wada nan mensoot ken siya, “Apo, ay awnit atiatik nan maisalakan ay adi omey id impilno ay kadosdosaan di ipogaw?” Dat kanan Jesus ken daida, ");
INSERT INTO xnn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nan segpan isnan mentolayan Apo Dios et nalipit. Isonga ipakatyo nan kabaelanyo ay songgep id wani tay tet-ewa ay awnit adoado nan mangpadas ay songgep ");
INSERT INTO xnn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ngem no epdas inemban nan kabaey et adi kayo makasgep. Olay no menkogkog kayo dakayo pay mensegseg-ang en, ‘Apo, tokabam kad ta songgep kami,’ ngem awnit kanana ken dakayo, ‘Adiyak getken dakayo.’ ");
INSERT INTO xnn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dakayot kanan kayet, ‘Dapay nakikikan kami ken sik-a ya insolsolowam dakami isnan ilimi.’ ");
INSERT INTO xnn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ngem danat kasin kanan, ‘Adiyak getken no sino kayo tay bakenak ib-a dakayo. Komaan kayo issa, dakayo am-in ay mang-ik-ikkan is ngawi.’ ");
INSERT INTO xnn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Awnit men-aga kayo dakayo pay men-owakis no ilaenyo da Abraham, Isaac ya si Jacob ay alal-apoyo ya nan am-in ay mamadto isnan mentolayan Apo Dios tay adi kayo makasgep. ");
INSERT INTO xnn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Madagop gedan nan ipogaw isnan kailiili isnan batawa et manganda isnan mentolayan Apo Dios ngem adi kayo kayet maitapi. ");
INSERT INTO xnn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tay nan kananyo en adi mapaay ay ipogaw et daida nan maitapi ken Apo Dios ngem nan kananyo en mapaay ay ipogaw et daida nan adi maitapi ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Issan olas ay deey inmey nan tap-in di Fariseo ken Jesus dadat kanan, “Gag-awis no komaanka isna tay kayat kano Ali Herod ay mangipapatey ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Dat kanan Jesus ken daida, “Enkayo ibaga isnan sanay nasikap ay ali en isnan madandan ay agew et pakak-aanek nan anito dakpay pagawgawisen nan masaksakit et nganngani ay kewasek nan oblak.” ");
INSERT INTO xnn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Danat itoloy ay mangwani, “Masapol ay omeyak od id Jerusalem tay isdi nan kateyan nan am-in ay mamadton Apo Dios isonga masapol ay isdi nan kateyak gedan. ");
INSERT INTO xnn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Mensakit nan nemnemko isnan ipogaw id Jerusalem. Kaseseg-ang kayo ay iJerusalem tay ginaygayangyo ya pinatpateyyo nan mamadto ay inbaan Apo Dios ay mangisolo ken dakayo. Namin kaat ay kayatko ay ponoken dakayo ay kaneg nan ikkan nan manok ay mangsakoko isnan an-akna ngem adyanyo. ");
INSERT INTO xnn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Isonga id wani kigad kayo et tay si Apo Dios et adiyet mentetee ay mangbadang ken dakayo. Ibagak ken dakayo en adi kayo kasin mang-il-ila enggana ay kananyo en, ‘Madaydayaw si Kristo ay inmali isnan ngadan Apo Dios.’” ");
INSERT INTO xnn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Esay Sabado ay obayan di Judio kasin dat omey si Jesus ay makikan isnan baey di esay apon di Fariseo dat sis-iimen nan ipogaw isdi siya ");
INSERT INTO xnn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tay wada nan am-ama isdi ay nabotot. ");
INSERT INTO xnn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dat sooten Jesus isnan men-is-isolo isnan linteg ya nan Fariseo, “Ay lawaen nan linteg tako ay maipagawis nan masaksakit isnan obaya?” ");
INSERT INTO xnn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ngem apedda igiginek. Dat kayet gen-an Jesus san am-ama et gomawis danat pasaaen. ");
INSERT INTO xnn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Dat kanan Jesus issan men-is-isolo isnan linteg ya nan Fariseo, “Kadya, no waday anakyo wenno bakayo is matekdag isnan bobon, ay adiyo ngen padakaen isnan agew di obaya?” ");
INSERT INTO xnn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ngem adida makasongbat issan kinwanina. ");
INSERT INTO xnn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Inilan Jesus nan tap-in di ipogaw issan baey di Fariseo ay mangpilpili is kagawisan is mentokdowanda isonga danat bagbagaan daida et kanana en, ");
INSERT INTO xnn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“No waday mangdekat ken daita isnan babayas, adita pilpiliyen nan kagawisan ay tokdowan modatya waday nadkat is nangatngato pay mo daita. ");
INSERT INTO xnn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tay mabainanta no kanan san nangdekat ken daita en, ‘Kadya ikoyam nan tokdowam ken tona,’ datat en tomokdo isnan kaasiyan ay tokdowan. ");
INSERT INTO xnn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Isonga gawgawis no tomokdota isnan kaasiyan ay tokdowan tapno kanan san nangdekat ken daita en, ‘Gayyem, omalika isnan gawgawis ay tokdowan.’ Et no siya di nan ikkam et ibilang daka isnan ipogaw isdi ay nangatngato. ");
INSERT INTO xnn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tay nan mangipapangato isnan awakna et awnit maipagowab. Nan abes mangipabababa isnan awakna et awnit maipangato.” ");
INSERT INTO xnn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dat kanan Jesus abes isnan nang-awis ken siya, “No men-ayagka is makikan isnan baeymo, baken kedeng nan makasobalit ay gagayyemmo, bebsatmo, ag-im ya nan baknang ay sag-ogongmo is ay-ayagam. ");
INSERT INTO xnn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nodi nan gawis ay ikkam et ayagam nan kaseseg-ang ay kaneg nan nababakog ya nan kowap ");
INSERT INTO xnn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tay adida makasobalit ken sik-a isnan ikkam ken daida et awnitka men-galalasing tay si Apo Dios nan kigad ay mangsobalit isnan inikkam ken daida no kasin matago nan nangpatpati ken siya.” ");
INSERT INTO xnn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dinngen nan esa ay makioobong san inbagan Jesus en kasin matago nan mangpatpati ken Apo Dios danat kanan ken siya, “Aye, nagasat nan awnit makiobong isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dat kanan Jesus ken siya, “Tet-ewa nan kanam ngem olay no adoda ay naayagan et adida am-in makikan tay kanegda nan naay. Wada nan am-ama ay nangisagsagana is laglagsak danat paayagan nan adoado ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nganngani pay nan panangan danat ibaa nan baana ay omey mendekat isnan sangailiyena. ");
INSERT INTO xnn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ngem san deeyda ay naayagan was-inda ninlason. Nan damo ay naayagan et kinwanina issan nabaa, ‘Ibagam kad en adiyak makaey tay wada nan linakowak ay payew et masapol ay omeyak ilaen id wani.’ ");
INSERT INTO xnn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nan esa et kinwanina, ‘Ibagam isnan apoyo en laydek ay omey ngem wada nan linakowak ay simpoo ay nowang et masapol ay omeyak padasen ay mangisama ken daida.’ ");
INSERT INTO xnn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nan esa et kinwanina abes, ‘Adiyak mabalin ay omey tay kaas-asawaak.’ ");
INSERT INTO xnn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dat somagong san nabaa et ibagana issan apona san kinkinwanin san ena inayagan. Dat makaliget san apona danapay kanan, ‘Ala, ikakamom ngalod ta omeyka isnan kaseseg-ang ay kodokdo ya olay nan nababakog, kowap ya nan pilay ta ibagam en omalida ay makikan.’ ");
INSERT INTO xnn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Isonga inmey san baana ngem issan inmaliyan san deeyday inayagana et inilana ay adoado kayet nan naisagana danat ipagtek isnan apona. ");
INSERT INTO xnn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Dat kanan san apona ken siya, ‘Omeyka kasin omayag is tap-ina ta mapno nan baeyko. ");
INSERT INTO xnn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tay maid polos olay esa issan damo ay naayagan is esa mangtamtam isnan insagsaganak ay makan.’” ");
INSERT INTO xnn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Issan omay-ayan Jesus id Jerusalem et adoado nan ipogaw ay mang-on-onod ken siya. Danat sagongen daida et kanana, ");
INSERT INTO xnn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nan mangkayat ay maitapi ken sak-en et masapol ay paam-amdena sak-en mo nan am-in, ay kaneg da amana, nan asawana ya an-akna, nan bebsatna ya olay pay nan awakna. ");
INSERT INTO xnn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nan adi makaitpe isnan ado ay ligat ay olay matey gapo isnan pammatina ken sak-en et adi mabalin ay menpasolotko. Isonga nan maitapi ken sak-en et masapol ay nemnemena omon-ona nan ligat sapay omonod. ");
INSERT INTO xnn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kaspangaligan no waday mensaad ken dakayo is baey et koblalena omon-ona nan banolna no omanay nan sipingna is gastowena enggana ay makwas. ");
INSERT INTO xnn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngem no adina nemnemen danat aped saaden dapay adi omanay nan sipingna awnit adi makwas nan baey et am-in ay mang-ila et ammenganda siya ");
INSERT INTO xnn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ya kananda en, ‘Ilanyo kod nan aped nangilogi ay mensapo is baey danat adi kewasen.’ ");
INSERT INTO xnn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kaneg abes no omey makigobat nan ali ay simpooy libo nan soldadona isnan ali ay dowampoy libo nan soldadona. Ay adina ngen nemnemen omon-ona no makaabak isnan kagobatna? ");
INSERT INTO xnn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Dat no adi makaabak et omibaa is mangsab-at isnan ali ay kagobatna ta mensoot no ngan nan ikkanda ta adida men-gobat. ");
INSERT INTO xnn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Isonga kaneg todi nan ikkanyo gedan ta nemnemenyo omon-ona ay masapol ay taynanyo am-in nan laylaydenyo esakayopay omonod ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nan mangmangwani en onodena sak-en ngem egayna tinaynan nan laylaydena et kanegna nan mentamnay ay asin tay gawis nan asin ngem no epdas tomamnay et adi kasin somidek. ");
INSERT INTO xnn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Isonga maid kaosalana nodi maiwasit tay olay isnan lota wenno nan abono et adi kappay nan asin. Kaneg todi ay maid kapaayan nan pasolotko no adina paam-amden sak-en. Dengngenyo ngalod no waday ingayo.” ");
INSERT INTO xnn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nan mensingsingil is bowis ya nan ib-ada ay managbasol et om-omeyda ay mangdengdenge isnan isolsolon Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Dat menlili nan Fariseo ya nan men-is-isolo isnan linteg ay mangwani en, “Ilanyo kod nan ipogaw ay naay et laylaydena ay makitoytoya isnan naayda ay managbasol ya aped makikikan ken daida.” ");
INSERT INTO xnn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isonga dat sodoken Jesus nan naay ta ipagtekna nan layad Apo Dios isnan managbasol ay mangibabawi isnan basolna. ");
INSERT INTO xnn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kadya, no wada ken dakayo nan kakwa is sin-gasot ay kalnilo dat maamas nan esa, ay ngan nan ikkana? Ay adina taynan nan siyampoo ya siyam isnan pagpastolan ta ena anapen san naamas enggana ay datngana? ");
INSERT INTO xnn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","No datngana san naamas ay daan ay natatago et men-galalasing. Danat boligan ");
INSERT INTO xnn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","et isaana danat ayagan nan gagayyemna ya nan sag-ogongna et kanana, ‘Men-gasgasing tako tay dinatngak nan naamas ay kalnilok.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Idiligko san gasing san kakwa isnan kalnilo isnan gasing Apo Dios id daya tay am-amed nan gasingna no menbabawi nan esa ay managbasol mo nan gasingna isnan siyampoo ya siyam ay ipogaw ay mangwani en adi masapol ay menbabawida.” ");
INSERT INTO xnn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Intoloy Jesus ay mensodok, “Kadya, no waday simpoo ay nabanol ay palatan di in-ina danat amasen nan esa, ay sino ngen nan ikkana? Pasgedana nan silaw danapay iyaamma ay mensigid ta anapena enggana ay datngana. ");
INSERT INTO xnn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Et no datngana danat ayagan nan gagayyemna ya nan sagogongna et kanana en, ‘Makigasgasing kayo ken sak-en tay naay dinatngak san palatak ay naamas.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ibagak ken dakayo ay kaneg tona nan ikkan nan aanghel Apo Dios tay men-gasingda no menbabawi nan managbasol.” ");
INSERT INTO xnn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Dat itoloy Jesus ay mensodok, “Wada nan am-ama ay kaanak is doway lalalaki. ");
INSERT INTO xnn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dat kanan nan innodi ken amana, ‘Ama, iyalim nan tawidko.’ Isonga dat pigasen amada nan tawidda ay sin-agi. ");
INSERT INTO xnn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Adi pay nan nadandan dat ilakon san innodi am-in san tawidna danat alaen nan lakona et komaan. Inmey siya isnan addaaddawi ay ili danat gastogastowen san sipingna is komkompolmi. ");
INSERT INTO xnn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Idi naamin san sipingna dat domateng nan bitil isnan ili ay kad-ana et maiwed polos nabay-an is ilakona is kanena. ");
INSERT INTO xnn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Isonga dat omey menpabaa isnan esay baey di kadangyan isdi et pala banbantay di beteg. ");
INSERT INTO xnn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Maoooowat siya et kayatna ay mangan isnan kankanen di beteg tay egay polos inag-agtan san kabeteg siya is kanena. ");
INSERT INTO xnn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dat dadlo mennemnem et kanana en, ‘Am-in nan baan Ama et mapnekda ay mangan dapay apedak wada isna ay matmatey is owatko. ");
INSERT INTO xnn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Somagongak gayam ken Ama ta kanak, “Ama, nakabasolak ken Apo Dios ya ken sik-a abes ");
INSERT INTO xnn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","isonga adiyak et makwani en anakmo. Ngem alaem kad sak-en ta maitapiyak isnan baam.”’ ");
INSERT INTO xnn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Issan sinmagongana isnan kad-anda et egay pay laeng omdan dat ilaen amana ay omal-ali et palalo nan seg-angna dat tomagtag ay mangsab-at ken siya et sektena danapay bisitowen. ");
INSERT INTO xnn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Danat tet-ewa kanan ken amana, ‘Ama, nakabasolak ken Apo Dios ya ken sik-a abes isonga adiyak et makwani en anakmo.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ngem dat bogawan amana san baana, ‘Ikamoyo ta alaenyo nan kagawisan ay bado ta ipabadoyo dayot pay-an nan ledengna is singsing dayopay pasapatosen. ");
INSERT INTO xnn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Omey kayo gedan alaen nan menlames ay koyaw di baka ta paltiyenyo ta isda tako datakopay men-gasgasing ");
INSERT INTO xnn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tay nan naay anakko kanak en natey ngem wada obpay ay matmatago. Naamas siya ngem kasin dinmateng.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ngem maiwed san iyon-ana tay linmokso. Idi somas-aa, dinngena ay wada nan men-ganggangsa isnan baeyda. ");
INSERT INTO xnn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Isonga danat ayagan nan baada et sootena no dadan aped men-ganggangsa. ");
INSERT INTO xnn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dat kanan nan baada en, ‘Men-gasgasingda tay dinmateng dadlo nan innodim. Isonga inpapaltin amam nan menlames ay baka tay sinmagong nan anakna ay maid inom-ommat ken siya.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dat makaliget nan iyon-a et adiyet songgep isnan baeyda. Isonga dat bomala si amana et ayakena ta songgep. ");
INSERT INTO xnn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ngem danat kanan ken amana, ‘Ilam, kaat ay tew-en ay nin-ob-oblaak ken sik-a ya pinatpatik nan inbilbilinmo ken sak-en ngem maid inyalim is olay anak di kalding tapno waday igasingko is mang-ayagak isnan gagayyemko. ");
INSERT INTO xnn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Domateng pay nan anakmo ay inmeyna aped inam-amas nan menkatagom ay ena inbababai dakat aped ipaltiyan is baka.’ ");
INSERT INTO xnn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dat kanan amana en, ‘Anakko, adim kankanan sa. Wadaka ay mentetee ken sak-en ay enggana. Sik-a am-in nan kakwa isnan wada ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ngem gawgawis no men-gasgasing tako tay dinmateng nan naamas ay innodim ay kanak en natey dat obpay daan ay matmatago.’” ");
INSERT INTO xnn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nakwas di dat kanan Jesus abes isnan papasolotna, “Wada nan baa ay am-ama ay mamanggen isnan am-in ay kowan nan esay kadangyan ngem dat wada nan nangipagtek issan kadangyan en nan baana et apedna gasgastowen nan siping ay ipapag-ena. ");
INSERT INTO xnn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Isonga danat paayagan et kanana, ‘Ayta dan dinngek ay keg todi nan ik-ikkam? Iyalim am-in nan listaan nan ay-ayowanam ay kokwak tay kaanek et sik-a isnan oblam.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Dat kanan san baa isnan nemnemna, ‘Ngan di esak pay ik-ikkan no kaanen nan apok sak-en isnan oblak? Adiyak kabaelan ay menkamanilo ya mabainak gedan ay menlimos. ");
INSERT INTO xnn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, owen, siya gayam na nan ikkak tasiyay waday gagayyemko is awnit mang-aw-awis ken sak-en isnan bab-aeyda olay no makaanak isnan oblak.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Isonga danat ayagan ay sin-es-a nan nakaotang isnan apona. Kinwanina isnan omona, ‘Kaat nan inotangmo isnan apok?’ ");
INSERT INTO xnn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dat kanan san nakaotang, ‘Sin-gasot ay bolnay ay mantika.’ ‘Naay ngalod di lisibom. Itokdom ta isolatmo en limampoo et kedeng.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Naisoblat san esa danat es kanan, ‘Sik-a pay abes, kaat nan inotangmo?’ Danat isongbat en, ‘Sinlibo ay sako ay pagey.’ ‘Naay di lisibom. Isolatmo en waoy gasot,’ kinwanin san baa. ");
INSERT INTO xnn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","San apona et init-ekna nan kinasikap san baana. Tay nan ipogaw isnan naay batawa ay adi mamati ken Apo Dios et nasiksikapda isnan ik-ikkanda mo nan mamati,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Danat itoloy ay mangwani, “Isonga ibagak ken dakayo en osalenyo nan kinabaknangyo ay mangbadang isnan ib-ayo tay olay no maamin ngem maitapi kayo isnan biyag ay maid patenggana. ");
INSERT INTO xnn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tay nan mang-ikkan is gawis isnan naited ken siya olay no bassit et matalek isnan dadakke ngem nan adi katalek isnan bassit ay banag et adi katalek isnan dadakke. ");
INSERT INTO xnn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","No ngalod adi kayo katalek ay mang-ayowan isnan kinabaknang isnan batawa, intoy ikkana ay maitalek ken dakayo nan tet-ewa ay kinabaknang ay wada ken Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No adi kayo matalek isnan bakenyo kowa et maid mang-ited ken dakayo is awnityo menkowa. ");
INSERT INTO xnn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nan baa et adi mabalin ay madodowa nan apona tay awnit laylaydena nan esa danapay aamisen nan esa isonga wada nan paam-amdena ken daida. Kaneg abes ken dakayo ay no nan kinabaknangyo nan nemnemnemenyo et adi kayo et makaikkan isnan layden Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","San deeyday Fariseo et dinngeda san kinwanin Jesus isonga dadat sayoten siya tay dadama nan layadda isnan siping. ");
INSERT INTO xnn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Dat kanan Jesus ken daida, “Dakayo nan aped mangmangwani isnan ipogaw en gawis kayo ngem getken Apo Dios nan kaipogawyo. Tay olay nan mapaay isnan ipogaw et adi paayen Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nan linteg Apo Dios ay insolat din si Moses ya din mamadto id sang-adom et siya nan osto ay nasolsolot engganay nawada si Juan ay Menbonbonyag. Ngem id wani et maibagbaga nan gawis ay damag maipanggep isnan mentolayan Apo Dios isnan kaipoipogaw isonga adoda nan aped mangkayat ay maitapi olay ngawi kayet nan ogalida. ");
INSERT INTO xnn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngem nalaklaka ay mamaid nan batawa ya nan daya mo nan esay kali isnan linteg Apo Dios ay mangibaga isnan osto ay maikkan. ");
INSERT INTO xnn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Naay nan esa ay adi mabalin ay mamaid. Nan lalaki ay makiidang isnan asawana dat makiasawa is teken et kaneg makikamkamolala gedan ya olay es nan lalaki ay mang-asawa isnan babai ay nakiidang.” ");
INSERT INTO xnn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Dat mensodok si Jesus en, “Wada nan esay kadangyan ay menbababado is kanginaan ay bado ya inagew ay gan-ganasena nan biyagna. ");
INSERT INTO xnn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wada abes nan kodokodo ay si Lazaro ay nakikilop nan awakna is yam-an. Tinaynanda siya isnan segpan san kadangyan ");
INSERT INTO xnn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ta kanena koma nan iwaswasit san kadangyan. Olay nan aso et omeyda dildildilan nan yam-ana. ");
INSERT INTO xnn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Dat matey san kodokodo et eyey nan aanghel nan ab-abiikna isnan kad-an Abraham id daya. Matey pay san kadangyan dadat ikaob ");
INSERT INTO xnn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","et mapalpaligatan nan ab-abiikna id impilno. Idi mentangad danat ilaen si Abraham isnan addaaddawi et wada gedan si Lazaro isnan kad-ana. ");
INSERT INTO xnn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Isonga dat menbogaw, ‘Amay Abraham. Maseg-angka ken sak-en. Ibaam kad si Lazaro ta itab-awna nan gomotna isnan danom ta tedtedana nan dilak tay palalo nan ligatko ay mapopop-oowan isnan apoy.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ngem dat kanan Abraham, ‘Nemnemem anakko, issan natatagowam et wada am-in nan kaykayatmo dapay si Lazaro et napalpaligatan ngem id wani gan-ganasena isna dapay ta mapalpaligatanka abes issa. ");
INSERT INTO xnn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Baken pay kedeng sa. Wada nan deppas isnan baet tako tapno nan mangkayat ay omey isnan kad-am ay magapo isna et adi makaey ya adi abes makaali isna nan magapo isnan kad-am.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Dat kanan san kadangyan, ‘Dawatek ngalod ken sik-a, Ama, ta ibaam si Lazaro isnan baey amak ");
INSERT INTO xnn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ay kad-an nan limay bebsatko. Kanam ta omeyna bagbagaan daida tapno adida awnit omal-ali isna ay kad-an di ligat.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dat kanan Abraham, ‘Nan bebsatmo et wada nan insolat din si Moses ya din mamadton Apo Dios ay mangbagbaga ken daida. Bay-am nan bebsatmo ta kigadda ay mangdenge isnan kankananda.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sinmongbat san kadangyan, ‘Adi omanay sa, Amay Abraham. Ngem no waday matago is natey dat omey ken daida, et balbaliwanda nan ngawi ay ik-ikkanda.’ ");
INSERT INTO xnn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ngem dat kanan kayet Abraham, ‘No adida patiyen nan insolat din si Moses ya din mamadton Apo Dios, adida kayet mamati olay no waday matago is natey.’” ");
INSERT INTO xnn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nakwas di dat kanan Jesus isnan papasolotna, “Tet-ewa ay wada nan maawisan di ipogaw ay menbasol ngem kaseseg-ang nan mang-aw-awis isnan iib-ana ay menbasol tay mendalalagsen nan dosana. ");
INSERT INTO xnn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gawgawis pay no naitaked nan losongan ay bato isnan bagangna dat maibkas isnan baybay mo nan mangipaypay-owana ay menbasol isnan esang ay kapatpati ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Isonga makail-ilanyo ta adiyo aw-awisen nan ib-ayo ay mang-ikkan is ngawi. No makabasol nan ib-am, sagiitem. Dat no menbabawi et pakawanem. ");
INSERT INTO xnn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Olay no mamin pito ay bomasol ken sik-a isnan sin-agew ngem no tonggal makabasol ay omey ken sik-a ay mangwani, ‘Ibabawik nan basolko,’ masapol ay pakawanem.” ");
INSERT INTO xnn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dat kanan nan apostolis, “No siya sa ngalod, padakdakkelem nan pammatimi tapno mabalin esa ay ikkanmi.” ");
INSERT INTO xnn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Dat kanan Jesus ken daida, “Baken nan kadakdaken di pammati is masapol nodi nan tet-ewa ay pammati tay olay no teeteen nan pammatiyo ay kaneg nan kateteenan ay esek et mabalin ay kananyo isnan kaiw en, ‘Gabotem nan lamotmo dakat omey isnan baybay tasiyay tomobowam,’ danat tet-ewa tongpalen. ");
INSERT INTO xnn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kadya, no waday esa ken dakayo is waday baana is mensamsama wenno mangipaspastol is kalnilo, no domateng ay magapo isnan payew, ay kanam ken siya en, ‘Ikamom ta manganka’? ");
INSERT INTO xnn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Adi. Nodi kanam ken siya, ‘Mensokatka dakat isagana nan kanek dakat mangseed enggana ay makakanak esakapay mangan abes.’ Siya nan ikkam tay baam siya. ");
INSERT INTO xnn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Et adi masapol ay men-iyaman nan kabaa isnan baana no tongtongpalena nan maibab-aa ken siya tay siya nan oblana. ");
INSERT INTO xnn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kaneg abes ken dakayo no kinwasyo am-in nan inbagan Apo Dios ay ikkanyo et adiyo it-it-ek nodi kananyo en, ‘Aped tako is nabab-aa et inikkan tako et kedeng nan masapol ay ikkan tako.’” ");
INSERT INTO xnn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Issan inmayan da Jesus id Jerusalem et indaana isnan baet nan Samaria ya Galilea. ");
INSERT INTO xnn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nganngani ay omdanda isnan esay ili dat sab-aten nan simpoo ay nakolit daida. Tinmakdegda isnan ad-addawi bassit ");
INSERT INTO xnn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","dadat menbogaw, “Apo Jesus, maseg-angka kad ken dakami.” ");
INSERT INTO xnn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Inilan Jesus daida danat kanan, “Enkayo ipaila nan awakyo isnan padi.” Issan mendad-aananda ay omey dat gomawis nan kolitda. ");
INSERT INTO xnn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Issan nang-il-an nan esa ken daida ay ginmawis nan awakna dat mensagong ken Jesus danapay ibibiyad nan kalina ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dat menpalintomeng isnan sasagangen Jesus dapay men-iyaman ken siya. San sinmagong et iSamaria. ");
INSERT INTO xnn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Dat kanan Jesus, “Ay kedeng nan sangaili ay naay is makaali? Ay egay obpay ginmawis am-in san simpoo ay lalalaki? Into pay san siyam? Ay adida makaali ta men-iyamanda abes ken Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dat kanan Jesus ken siya, “Ginmawiska gapo isnan pammatim ken sak-en. Itakdegmo ta somaaka.” ");
INSERT INTO xnn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Isnan namingsan et sinoot nan tap-in di Fariseo ken Jesus no tongon nan omaliyan nan mentolayan Apo Dios. Dat kanan Jesus, “Baken nan mata nan osalen tako ay mangtek isnan omaliyan nan mentolayan Apo Dios ");
INSERT INTO xnn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","tay adi kaila. Isonga adi kabalin ay kanan nan ipogaw en, ‘Ilam, naay,’ wenno, ‘Ilam, deey nan mentolayan Apo Dios.’ Ngem nan tet-ewa et epdas inmali tay wada isna.” ");
INSERT INTO xnn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Danat kanan isnan papasolotna, “Awnit wada nan agew ay kayakayatyo ay ilaen sak-en ay Iyon-an Am-in di Ipogaw is olay sin-awyan ngem adi kayo makaila. ");
INSERT INTO xnn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wadada nan awnit mangwani en, ‘Deey si Jesus. Ilaem kod isdi,’ wenno, ‘Ilaem kod isna.’ Ngem adi kayo kadi patpatiyen. ");
INSERT INTO xnn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tay nan omaliyak kasin et kaneg nan kimat ay menpangsilaw isnan daya. ");
INSERT INTO xnn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ngem masapol ay menligatak omon-ona tay mang-adi nan ipogaw id wani. ");
INSERT INTO xnn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Din inik-ikkan nan ipogaw isnan batawa isdin timpon Noah et siya nan ikkan nan ipogaw isnan awnitak omaliyan kasin. ");
INSERT INTO xnn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tay esapay mapsong nan batawa ay manglimon ken daida am-in et kaneg maid egyatda nodi ginan-ganasda nan biyagda ay aped mangmangan dadapay omin-inom ya men-as-as-awa enggana issan agew ay sinonggepan da Noah issan bapor. ");
INSERT INTO xnn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kaneg abes isdin timpon Lot id Sodoma. Am-in nan ipogaw et maid idngeda is kalin Apo Dios nodi apedda mangmangan dadapay omin-inom, lomaklakoda dadapay ilaklako, men-es-esekda ya mensas-aadda ");
INSERT INTO xnn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","enggana issan agew ay tinaynan da Lot id Sodoma dat wada nan apoy ya asopli ay kaneg niket ay nagapo id daya et mapoowanda am-in. ");
INSERT INTO xnn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kaneg todi abes nan ommat isnan agew ay kasinak omaliyan ay Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Et isnan agew ay deey, nan wada isnan pantewna et adiyet songgep ay mang-ala isnan bonagna. Kaneg abes nan epdas linmokso et adiyet makasaa isnan baeyna. ");
INSERT INTO xnn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nemnemenyo din inommat isdin asawan Lot tay natey isdin nangsagongana ay mang-ila isnan ilida. ");
INSERT INTO xnn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nan ipogaw ay kedeng nan awakna is ay-ayyewana et awnit matey met laeng ngem nan adi mang-ayyew isnan awakna gapo ken sak-en et awnit matey ngem matagotago ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ibagak ken dakayo ay isnan labi ay omaliyak et no waday dowa ay lalalaki ay maseseyep isnan kama et maala nan esa ay maitapi ken sak-en dapay mataynan nan esa. ");
INSERT INTO xnn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","No wada abes di doway bababai is menbaybayo et maala nan esa dapay mataynan nan esa. ");
INSERT INTO xnn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","No waday doway lalalaki gedan isnan payew et maala nan esa dapay mataynan nan esa.” ");
INSERT INTO xnn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dat sooten nan papasolotna ken siya, “Apo, intoy sana maikkanan?” Dat kanan Jesus, “No intoy kad-an di natey ay egay kaikaob et siya nan maponokan di koyat ta topkenda.” ");
INSERT INTO xnn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dat mensodok si Jesus ken daida ta itdona ay masapol ay menlol-owaloda ay kanayon ya adida somadsadot. ");
INSERT INTO xnn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kinwanina en, “Wada nan esay howis isnan esay ili ay adi polos omegyat ken Apo Dios ya maid gedan baina isnan ib-ana ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Et isnan deey ay ili et wada gedan nan esay balo ay babai ay kanayon ay omey issan howis ay menseg-ang isnan kalintegana ay mangmangwani en, ‘Badangam sak-en isnan mangbosboso ken sak-en.’ ");
INSERT INTO xnn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nabayag ay egay inkaskason san howis ngem omanono pay danat kanan isnan nemnema, ‘Olay no adiyak omegyat ken Apo Dios ya maid bainko isnan ib-ak ay ipogaw ");
INSERT INTO xnn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ngem gawgawis no idyak et nan dawdawatena tay no adi, awnit gedan omaliali ay mangtaktataktak et maamin nan anosko.’” ");
INSERT INTO xnn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dat itoloy Jesus, “Ilanyo san inikkan san ngawi ay howis. Olay no maid seg-angna et binadangana kayet san balo ta adi omeomey ay mangtaktataktak ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Isonga si Apo Dios et am-amedna badangan nan ipogawna no mensegseg-angda ken siya is inagew ya linabi ");
INSERT INTO xnn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","et itedna ay dagos nan dawatenda. Ngem olay no adoado nan badangan Apo Dios et waay atiatik kayet nan mamati ken sak-en isnan kasinak omaliyan ay Iyon-an Am-in di Ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Naay di sodsodok Jesus isnan ipogaw ay mangnemnemnem ay gawisda ya men-iyaiyaw isnan ib-ada. ");
INSERT INTO xnn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Danat kanan, “Wada nan doway lalaki ay inmey ninlowalo isnan Templo. Nan esa et Fariseo ya nan esa et mensingsingil is bowis. ");
INSERT INTO xnn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tinmakdeg san Fariseo dat menlowalo ay mangwani en, ‘Men-iyamanak ken sik-a Apo Dios tay bakenak kaneg nan ib-ak ay ipogaw tay agomda, lastogda ya makibababaida. Bakenak kaneg gedan nan naay sowitik ay mensingsingil is bowis. ");
INSERT INTO xnn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Gapo ken sik-a et dinomingo ay adiyak mangmangan is doway agew ya id-idyak abes nan pigasmo ay pagkasimpoon nan lagbok.’ ");
INSERT INTO xnn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ngem san mensingsingil is bowis et tinmakdeg isnan ad-addawi dapay egay nintangad id daya tay mabain danapay aped kegkegkegen nan pagaewna gapo isnan sakit di nemnemna ay mangmangwani en, ‘Apo Dios, maseg-angka ken sak-en tay adoado nan basolko.’” ");
INSERT INTO xnn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kinwanin et Jesus, “Ibagak ken dakayo esapay somaa san mensingsingil is bowis et pinakawan Apo Dios siya ngem san Fariseo et egay napakawan. Tay nan mangipapangato isnan awakna et awnit maipagowab met laeng ngem nan mangipabababa isnan awakna et awnit maipangato.” ");
INSERT INTO xnn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Issan esay agew et wadada nan nangyey isnan an-akda ken Jesus tapno kapposena daida ta mabindisyonanda. Ilaen pay san papasolot Jesus dadat iyadi ta adida taktaken siya. ");
INSERT INTO xnn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ngem dat ayagan kayet Jesus san oongong-a danat kanan isnan papasolotna en, “Palobosanyo nan oongong-a ay omali ken sak-en. Adiyo iyadi daida tay nan mangtalek ken sak-en ay kaneg nan naayday oongong-a et daida nan maitapi isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tet-ewa nan ibagak ken dakayo, maid teken is maitapi isnan mentolayan Apo Dios nodi nan mangtalek ken siya ay kaneg nan onga ay mangtalek isnan amana.” ");
INSERT INTO xnn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wada nan esay ap-apon di Judio ay nangwani ken Jesus en, “Apo, gawigawiska ay ipogaw, isonga ibagam kad no ngan nan osto ay ikkak tapno matagotagowak ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Dat kanan Jesus, “Dakan aped kanan en gawigawisak dapay si Apo Dios et kedeng nan kagawisan. ");
INSERT INTO xnn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Getkem nan linteg Apo Dios ay kanana en, ‘Adika mamabai, adika menpatpatey, adika men-ak-akew, adika menpabpabasol isnan ib-am ya masapol ay tongpalem da amam ken inam.’” ");
INSERT INTO xnn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dat kanan san lalaki, “Enggana isdin kaongak, tinongtongpalko am-in nan naayday linteg.” ");
INSERT INTO xnn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dinngen pay Jesus danat kanan, “Wada pay nan esang ay kolangmo. Ilakom am-in nan kokwam damet ipakdaw isnan kokodokdo nan lakona dakat mang-onod ta maitapi ken sak-en et awnit wada nan kinakadangyanmo id daya.” ");
INSERT INTO xnn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Idi dinngen san lalaki nan kinwanin Jesus dat menseseg-ang tay adina kayat ay taynan nan kinakadangyana. ");
INSERT INTO xnn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Inilan Jesus ay menseseg-ang san kadangyan danat kanan, “Naligat nan maitapiyan di kadangyan isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nalaklaka pay nan songgepan nan dakkel ay camel isnan lokaw di dagom mo nan maitapiyan nan kadangyan isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dinngen nan ipogaw san kinwanin Jesus dadat sooten, “Apo, sino pay obpay nan maisalakan?” ");
INSERT INTO xnn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dat kanan Jesus, “Nan adi mabalin ay ikkan nan ipogaw et mabalin ay ikkan Apo Dios tay maid polos adina kabaelan isonga am-in ay mangpatpati ken siya et maisalakan, kadangyan man wenno kodo.” ");
INSERT INTO xnn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Isonga dat kanan Pedro, “Ilam dakami et tinaynanmi nan bab-aeymi ta maitapi kami ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Dat kanan Jesus, “Owen. Ibagak ken dakayo nan tet-ewa. Nan mangtaynan isnan baeyna, nan asawana, nan bebsatna, da amana wenno nan an-akna gapo isnan maitapiyana isnan mentolayan Apo Dios ");
INSERT INTO xnn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","et adoado nan ganabena ken Apo Dios isnan naay batawa mo san tinaynana dapay wada nan biyagna ken Apo Dios ay maid patenggana.” ");
INSERT INTO xnn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nakwas ay kinwanin Jesus di danat ipaigid san simpoo ya doway pasolotna danat kanan ken daida, “Dengngenyo. Omey tako id Jerusalem ay matongpalan am-in din insolsolat din mamadto id sang-adom maipanggep ken sak-en ay Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Maidyaak isnan baken Judio et awnitda mangselselat, mangbaibain dadapay mangtobbatobba. ");
INSERT INTO xnn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Awnitda mangbaibaig sadapay mangpatey. Ngem awnitak kasin matago isnan maikatlo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ngem adi polos getken san papasolotna san inbagbagana tay adida maawatan nan kayatna ay kanan. ");
INSERT INTO xnn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nganngani ay omdan da Jesus id Jerico et wada nan kowap ay tinmotokdo isnan benget di daan ay menlimlimos. ");
INSERT INTO xnn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dinngena nan lomal-aos ay kaipoipogaw danat sooten no ngan nan maik-ikkan. ");
INSERT INTO xnn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dadat ibaga ken siya, “Naay lomaos si Jesus ay iNazaret.” ");
INSERT INTO xnn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dat ibogaw san kowap, “Jesus ay apon din si David, seg-angam kad sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dat islat san nang-on-ona ay mendad-aan et kananda en igiginekna. Ngem am-amed kayet ninbogaw ay mangwani, “Apon din si David, seg-angam kad sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dat isaldeng Jesus et kanana en padangenda san kowap ta isag-enda ken siya. Naisag-en pay san kowap dat sooten Jesus ken siya, ");
INSERT INTO xnn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ay ngan nan kayatmo ay ikkak ken sik-a?” Dat kanan nan kowap, “Apo, kaytek ay makaila koma.” ");
INSERT INTO xnn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Makailaka et,” kinwanin Jesus. “Nan pammatim ken sak-en nan gapo ay makailaka kasin.” ");
INSERT INTO xnn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dat maganawis et makaila dadlo daet omonod ken Jesus ay mangdaydayaw ken Apo Dios. Issan nang-ilaan san kaipoipogaw issan inommat dadat abes dayawen si Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isnan mendad-aanan da Jesus id Jerico ");
INSERT INTO xnn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","et wada nan kangadan is Zakeo ay baknang tay siya nan apon di mensingsingil is bowis. ");
INSERT INTO xnn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kayatna ay ilaen no sino nan kaneg Jesus ngem maid somya tay adoado nan ipogaw dapay gedan aptiaptik siya et adi makaila. ");
INSERT INTO xnn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Isonga dat tomagtag et omey komaab isnan esay kaiw ay sikamolo tasiyay makaila isnan lomaosan Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wada pay ay maibatog si Jesus issan kad-an Zakeo danat tangaden siya et kanana, “Zakeo, ikamom ay lomayog tay is baeyyo nan omeyak omapaan.” ");
INSERT INTO xnn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dat malanayog si Zakeo issan kinokomabana ay kaiw et men-galalasing ay mangipango ken Jesus isnan baeyda. ");
INSERT INTO xnn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Am-in san nang-ila issan inommat et men-ag-agotootda ay mangmangwani en, “Dan aped omey si Jesus isnan baey nan managbasol ay deey?” ");
INSERT INTO xnn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ngem si Zakeo, tinmakdeg et kanana ken Jesus, “Ilam Apo, ipakdawko isnan kokodokdo nan kagedwan nan kokwak. No wada abes di inallilawko et isagongko is mamin epat nan kaad-adona mo san inalak.” ");
INSERT INTO xnn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Dat kanan Jesus, “Id wani ay agew maisalakan kayo ay sinbaey isnan dosa ay maid patenggana tay nan ikkam et kaneg din inikkan Abraham ay nangtalek ken Apo Dios. Siya di nan kagtekana ay tet-ewa ay apon din si Abraham sik-a. ");
INSERT INTO xnn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nan gapo ay inmaliyak ay Iyon-an Am-in di Ipogaw et ta ayagak nan ipogaw ay adi mamati ken Apo Dios tapno maisalakanda.” ");
INSERT INTO xnn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dandaney omdan da Jesus id Jerusalem et inpagalop nan nanangnge ken siya en nganngani ay menpaila nan mentolayan Apo Dios. Dat sodoken Jesus nan naay ta getkenda ay egay kayet ninpaila. ");
INSERT INTO xnn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kanana, “Wada nan nangato ay ipogaw ay inmey isnan addaaddawi ay ili ta dotokanda siya ay men-ali isnan ilina. ");
INSERT INTO xnn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ngem esapay omey, inayagana nan simpoo ay baana et agtana daida is sag-es-a ay palata ay balitok. Danat ibaga ken daida en, ‘Ipaanakyo nan naay siping isnan kamaidko.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ngem kaliliget nan kailiyana siya isonga dadat omibaa is mang-onod ken siya ta enda ibaga isnan mangdotok ay adida layden siya is men-alida. ");
INSERT INTO xnn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ngem nadotokan kayet ay ali dat somaa danat ayagan san babaana ay inagtana is siping tay kayatna ay getken no kaat nan inyanak nan intedna ay siping ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dat omey nan esa et kanana en, ‘Apo, inmanak is simpoo ay palata ay balitok san inyalim.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dat kanan san ali en, ‘Gawis nan inikkam. Gawiska obpay is baa. Isonga gapo tay matalekka isnan atiatik ay inpaikkak ken sik-a et mentolayka isnan simpoo ay ili ay sakop nan mentolayak.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dat abes omey nan maikadwa ay baa et kanana en, ‘Apo, inmanak is lima ay palata ay balitok san inyalim.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Dat kanan san ali ken siya en, ‘Sik-a abes et mentolayka isnan lima ay ili.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Dat omey san esa ay baa et kanana en, ‘Apo, naay san inyalim ay siping. Binongonko isnan panyo daket idolin. ");
INSERT INTO xnn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Omegyatak od ken sik-a tay getkek ay masapol ay matongpal nan kankanam dakapay men-galansiyaan nan egaymo ninligatan ya ap-apitem gedan nan egaymo inis-ek.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dat kanan san ali en, ‘Ngawika is baa. Moltaek sik-a isnan am-in ay kinwanim. Getkem ngalod ay masapol ay matongpal nan kanak et men-galansiyaak nan egayko ninligatan ya apitek nan egayko gedan inis-ek. ");
INSERT INTO xnn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aytay ngalod damen egay ibangko ta no somaaak damet isagong nan siping ya nan binisna.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dat kanan et san ali issan deeyday tomatakdeg isdi en, ‘Alaenyo nan siping ken siya ta itedyo isnan nangipaanak is simpoo.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dadat kanan issan ali en, ‘Apo, dapay wada nan simpoo ay sipingna.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ngem kinwanin san ali en, ‘Ibagak ken dakayo no sino nan matalek isnan naidya ken siya et mataptapiyan pay is ad-ado ngem nan adi katalek et olay nan atiatik ay wada ken siya et mamaid.’ ");
INSERT INTO xnn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Danat kanan pay, ‘Nan deeyda ay mangbosboso ay adi mangkayat ay men-aliyak et iyaliyo daida ta pateyenyo isnan sasagangek.’” ");
INSERT INTO xnn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nakwas ay ninkali si Jesus dat omon-ona ay omey id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wada nan doway ili ay Betfage ya Betania ay gogowaben nan bilig ay makwani en Olivo tay adoado nan olivo ay kak-aiw et isnan inomdanan da Jesus isdi danat ibaa nan dowa ay pasolotna et kanana, ");
INSERT INTO xnn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Enkayo isnan ili ay deey et awnit datnganyo nan koyaw di kabayo ay egay kasaksakayan ay naibabaod. Dayot okasen nan baodna ta iyaliyo isna. ");
INSERT INTO xnn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No waday mensoot no dayon kak-aanen nan baodna dayot kanan en masapol nan apoyo.” ");
INSERT INTO xnn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dadat omey isdi et datnganda tet-ewa am-in san inbagan Jesus ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Isnan mang-ok-okasanda isnan baodna dat kanan nan kakwa, “Dakayon kak-aanen nan baod tosa?” ");
INSERT INTO xnn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dadat kanan “Owen tay masapol nan apo tako.” ");
INSERT INTO xnn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dadat eyey ken Jesus dadat iyap-ap nan badbadoda isnan edeg nan kabayo dadat ipasakay si Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Issan mendad-aanan san kabayo ay mensasakayan Jesus dat iyaplag nan kaipoipogaw nan badbadoda isnan daan ay daanena ta mangipaila ay daydayawenda siya. ");
INSERT INTO xnn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Inomdan pay da Jesus isnan dedemangen di Jerusalem ay menpalayog isnan bilig ay Olivo dat ilogin nan kaipoipogaw ay omon-onod ken Jesus ay mangibibiyad isnan kalida ay men-iyaman ken Apo Dios dadapay dayawen siya gapo isnan kaskasdaaw ay inilada ay inik-ikkan Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kankananda en, “Hosanna. Mabindisyonan nan naay Ali tako. Madaydayaw nan ngadan Apo Dios isnan natalna ay daya.” ");
INSERT INTO xnn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nan tap-in nan Fariseo ay makikib-on isnan kaipoipogaw et adyanda ay madayaw si Jesus isonga kinwanida ken siya, “Mistolo, paginkem nan papasolotmo.” ");
INSERT INTO xnn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ngem dat kanan Jesus, “Ibagak ken dakayo en no iginekda et olay nan bato et mangdayawda gedan.” ");
INSERT INTO xnn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Issan sinmag-enan Jesus id Jerusalem dat men-aga gapo isnan seg-angna isnan ipogaw isdi ");
INSERT INTO xnn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","danapay kanan, “Ay-ayyewka ay Jerusalem. No getkem koma id wani nan masapol tapno tomalnaka ngem id wani adika et makaila. ");
INSERT INTO xnn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Awnit domateng nan agew ay menligatka tay awnit likoben nan bosom sik-a is baked et maseyatanka ya nan am-in ay solsolim. ");
INSERT INTO xnn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Awnitda dadaelen sik-a ya nan ipogawmo et paapokenda am-in nan batbatom tay inadyam nan inmaliyan Apo Dios ay mangisalakan ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Inomdan si Jesus id Jerusalem dat omey isnan Templo danat pabalaen san men-il-ilako isnan awnit ited nan ipogaw ken Apo Dios ");
INSERT INTO xnn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","danat kanan ken daida, “Naisolat isnan kalin Apo Dios en, ‘Nan baeyko et paglol-owalowan di ipogaw.’ Siya di nan inbagan Apo Dios ngem ngan nan ik-ikkanyo? Dakayon aped os-osalen is pagsos-owitikan?” ");
INSERT INTO xnn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dat men-is-isolo et si Jesus isnan Templo ay inagew. Ngem nan menkangangato ay papadi, nan men-is-isolo isnan linteg ya nan ap-apon di ipogaw et kayatda ay pateyen siya ");
INSERT INTO xnn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ngem maid somya is ikkanda ay mangpatey ken siya tay am-in nan ipogaw et laylaydenda ay dengdengngen am-in nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Isnan esay agew ay kad-an Jesus issan Templo ay men-isolsolo ya mangibagbaga isnan gawis ay damag dat omey ken siya nan menkangangato ay papadi, nan men-is-isolo isnan linteg ya nan aamam-a ");
INSERT INTO xnn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","et kananda, “Ibagam kad ken dakami no ngan nan kalebbengam ay mang-ik-ikkan isnan am-in ay ik-ikkam. Ay sino nan nang-ited ken sik-a isnan lebbengmo?” ");
INSERT INTO xnn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Dat songbatan Jesus daida en, “Sootek na od ken dakayo. Ibagayo ken sak-en ");
INSERT INTO xnn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ay into nan nagapowan din kalebbengan Juan ay Menbonbonyag? Ay ken Apo Dios wenno isnan ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dadat men-asisoot et kananda, “Ay sino nan isongbat tako? No kanan tako en nagapo ken Apo Dios et awnit kanana en, ‘Ayta ngalod dayon egay pinatpati din si Juan.’ ");
INSERT INTO xnn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ngem no kanan tako abes en nagapo isnan ipogaw et am-in nan ipogaw ay naayda et awnit gomayangda engganay matey tako tay kananda en tet-ewa ay mamadton Apo Dios din si Juan.” ");
INSERT INTO xnn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Isonga dadat kanan en adida getken nan nagapowan nan kalebbengan din si Juan ay Menbonbonyag. ");
INSERT INTO xnn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dat kanan Jesus, “Adiyak ngalod abes ibagbaga nan nagapowan nan kalebbengak ay mang-ik-ikkan isnan ik-ikkak.” ");
INSERT INTO xnn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dat sodoken Jesus na isnan kaipoipogaw, “Wada nan esay am-ama ay nin-esek is adoado ay onas danat ipaayowan isnan ipogaw esapay omey isnan addaaddawi ay ili tay mabayag isdi. ");
INSERT INTO xnn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Inomdan pay nan maapitan san onas dat ibaan san kakwa nan esa ay baana ta ena alaen nan pigasna. Ngem sinogtosogton san mang-ay-ayowan san baa dadat ipasaa ay maid polos ginegen-ana is onas. ");
INSERT INTO xnn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Binaana kasin nan esay baana ngem am-amed nan inikkanda ken siya mo san damo. Binaibainanda pay esadapay pasaaen ay maid intedda gedan ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pinitlowana ay nangibaa isnan baana ngem sinogatanda dadat ipabala isnan onasan. ");
INSERT INTO xnn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Dat kanan et san kakwa issan onasan, ‘Ay ngan ngen et di ikkak? Ibaak gayam nan laylaydek ay bogtong ay anakko et getkek ay awnitda idnge siya.’ ");
INSERT INTO xnn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ngem isnan nang-ilaan san mang-ay-ayowan issan onasan ken siya dadat mentotya et kananda, ‘Naay omali nan awnit mangtawid isnan naay om-a. Pateyen tako bawet siya ta datako nan mangkowa isnan tawidena.’ ");
INSERT INTO xnn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dadat ibala isnan onasan et pateyenda.” Siya na nan sinodok Jesus danat kanan ken daida, “Ay ngan ngata nan ikkan nan kakwa isnan onasan isnan deeyda ay mang-ay-ayowan? ");
INSERT INTO xnn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Awnit omey et pateyena daida danat ipaayowan nan om-ana isnan teken ay ipogaw.” Dinngen san kaipoipogaw dadat kanan, “Ay inayan. Baken koma keg tosa abes nan ommat ken dakami.” ");
INSERT INTO xnn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dat inengneng Jesus daida et kanana, “Ay sino ngalod nan kayat ay kanan din naisolat id kasin ay naay, ‘Nan bato ay inadyan di nangsaad isnan baey et siya nan kapatgan tay ipakekenegna nan baey.’ ");
INSERT INTO xnn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Et nan maipakpak isnan naay ay bato et masogasogatan ya no matekdag gedan nan naay ay bato et mamekmemekmek nan pontaana.” ");
INSERT INTO xnn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Getken nan men-is-isolo isnan linteg ya nan menkangangato ay papadi ay daida nan kankanan Jesus ay nang-adi isnan inbab-aan nan kakwa issan onasan ya san napateg ay bato tay adyanda siya. Isonga kaytenda ay depapen ay dagos ngem omegyatda isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Enggana isdi et ninses-eedda is gawis ay timpo ay mangdepapanda ken siya. Linagbowanda nan tap-in di lalalaki dadat ibaa daida ta omeyda aginsisingpet ay mang-allilaw ken Jesus tapno waday ikkanda ay mangdepap ken siya ta eyeyda isnan gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dat omey san lalalaki ken Jesus et kananda en, “Apo, getkenmi ay ostoosto am-in nan kankanam ya it-itdom ya maid paam-amdem isnan nangato ya nababa ay ipogaw nodi isolsolom nan tet-ewa ay kayat Apo Dios ay ikkan di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Isonga ibagam kad no iyadin nan linteg tako nan mangbayadanmi is bowis ken Cesar ay ali id Roma.” ");
INSERT INTO xnn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ngem getken Jesus ay siksikapanda siya isonga danat kanan, ");
INSERT INTO xnn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Omyali kayo is esay siping. Ay sino nan kaangas ya kangadan isnan naay siping?” ");
INSERT INTO xnn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Si Cesar,” insongbatda. Dat kanan Jesus, “No siya sa ngalod et kowan Cesar nan siping isonga ikkanyo ken Cesar nan kalebbengana dayopay abes ikkan ken Apo Dios nan kalebbengana.” ");
INSERT INTO xnn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Egayda nakaallilaw ken siya isnan kad-an nan adoado ay ipogaw ya nasdaawda isnan insongsongbatna isonga dadat igiginek. ");
INSERT INTO xnn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Inmey abes nan tap-in di Saduceo ken Jesus ay mangpadas ay mangsikap ken siya. Datona nan tap-in di Judio ay adi mamati ay kasin matago nan matey. Kinwanida ken siya, ");
INSERT INTO xnn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Apo, insolat din si Moses id sang-adom en no matey nan lalaki ay inmasawa dapay maid anakda et masapol ay asawaen nan besat san natey nan balo tasiyay omanakda et maibilang ay kaneg anak san natey. ");
INSERT INTO xnn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kadya, id kasin et wada nan pitoy sin-ag-i ay lalalaki. Inmasawa nan iyon-a dat matey ay maid anakda. ");
INSERT INTO xnn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dat asawaen nan maisned san aydona ay balo dat matey gedan ay maid anakda. ");
INSERT INTO xnn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Et siyang na gedan nan inommat isnan maikatlo enggana isnan maikapito. Nateyda am-in ay maid anakda. ");
INSERT INTO xnn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kaodiyan ay natey san balo. ");
INSERT INTO xnn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naay nan sootenmi, isnan katagowan nan natey, ay sino pay nan osto ay asawan san babai issan pito ay sin-ag-i tay inasawada am-in siya?” ");
INSERT INTO xnn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Dat songbatan Jesus et kanana, “Men-as-as-awa nan ipogaw id wani ");
INSERT INTO xnn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ngem adi men-as-as-awa nan awnit tagowen kasin Apo Dios ay paayena ay makitetee ken siya ");
INSERT INTO xnn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","tay kanegda nan aanghel ay adi katkatey isonga adi masapol di omanakda. Daida nan an-ak Apo Dios tay kasinda matago. ");
INSERT INTO xnn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Adiyo patiyen nan kasin katagowan nan ipogaw ay natey ngem pinaneknekan din si Moses ay kasin matago nan natey isdin nangisolatana isnan inommat isdin nakikaliyan Apo Dios ken siya isnan menbidbidang ay kaiw en, ‘Sak-en nan Dios ay daydayawen da Abraham, Isaac ya si Jacob.’ Siya na nan insolat Moses dapay epdas natey da Abraham issan nangwaniyan Apo Dios isdi. ");
INSERT INTO xnn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Et siya di nan manggetkan tako ay matatago kayet nan natey ay ipogaw Apo Dios tay adi kabalin ay kanan Apo Dios en daydayawenda siya kayet no egayda natago kasin.” ");
INSERT INTO xnn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nan tap-in san men-is-isolo isnan linteg et kinwanida ken siya, “Apo, gawis nan insongbatmo,” ");
INSERT INTO xnn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","tay adida et maitoled ay mensoot ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dat sooten Jesus ken daida en, “Dadan kanan en alapon Kristo din si David ");
INSERT INTO xnn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","dapay kanan David en madaydayaw ay Ap-apona si Kristo isnan nangisolatana isnan naay isnan liblo ay Salmo, ‘Kinwanin Apo Dios ken Kristo ay Ap-apok en tomokdoka isnan makanawanko ");
INSERT INTO xnn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","engganay abakek am-in nan bosom.’” ");
INSERT INTO xnn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dat kasin sooten Jesus ken daida en, “No kanan David en Ap-apona si Kristo, dadan aped kanan en alapon Kristo si David? Ay baken Ap-apon David si Kristo?” ");
INSERT INTO xnn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Issan nangdengan san kaipoipogaw dat kanan Jesus isnan papasolotna, ");
INSERT INTO xnn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Makail-ilanyo nan men-is-isolo isnan linteg. Kaykaytenda ay menbabado is gawigawis ay maisagsagayad tasiyay mailalasinda ya kaytenda ay lislispitowen nan ipogaw daida ay mangwani, ‘Omayam, Apo?’ no omeyda menpasyal. Pilpiliyenda pay nan kagawisan ay tokdowan isnan sinagoga ya nan kagawisan ay kad-an no enda makikan. ");
INSERT INTO xnn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dadapay tagikowaen nan kokwan di nabalo ay bababai. Ngem kaytenda ay malingban nan ngawi ay ik-ikkanda isonga andoandowenda nan lol-owaloda. Ngem gapo is dana et awnit am-amed nan dosada.” ");
INSERT INTO xnn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Issan ninmoliyan Jesus danat ilaen nan babaknang ay mang-ip-ippey isnan sipingda isnan maig-igwaan di siping issan Templo. ");
INSERT INTO xnn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Inilana gedan nan kodokodoy babai ay balo ay nang-ippey isnan dod-owa ay galak ay sipingna. ");
INSERT INTO xnn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dat kanan Jesus, “Ibagak ken dakayo en ad-ado nan inippey nan naay kodokodo ay balo mo san inigwan am-in san tap-ina. ");
INSERT INTO xnn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tay kedeng nan soblan di kinabaknangda is inigwada ngem san balo et olay kodokodo et inigwana am-in ay menkatagona.” ");
INSERT INTO xnn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nan tap-in san pasolotna et sodsodokenda nan Templo tay naalkosan is ganaganagwis ay batbato ya nan inig-igwada ay igasingda ken Apo Dios. Ngem dat kanan Jesus en, ");
INSERT INTO xnn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Owen. Ilanyo am-in nan naayda ngem awnit domateng nan timpo ay maid polos mabaybay-an is olay esay batona tay awnit mapokada am-in.” ");
INSERT INTO xnn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dadat sooten ken Jesus, “Apo, ay tongon nan maikkanana? Ngan nan kailasinana no ommat sa?” ");
INSERT INTO xnn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Dat kanan Jesus, “Makailanyo ta adi kayo maallilaw. Tay adoado nan awnit omali ay mangwani en daida nan Kristo ay inbaan Apo Dios ya kanan nan tap-ina en nganngani ay omdan nan omaliyan kasin Kristo. Ngem adiyo patpatiyen daida tay baken tet-ewa nan kankananda. ");
INSERT INTO xnn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Awnit dengngenyo ay wada nan gobat ya golo ngem adi kayo makibkibtot tay masapol ay ommat da tona ngem baken di is menpatenggaan di batawa.” ");
INSERT INTO xnn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Danat itoloy ay mangwani en, “Awnit men-asigobat nan kailiili ya kaneg abes nan kagobigobilno. ");
INSERT INTO xnn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Awnit wada gedan nan adoado ay kaeegyat ay yegyeg, kabitibitil ya sakit ay mangpatey isnan adoado ay ipogaw isnan natkenatken ay il-ili. Id daya et wada abes nan kaeegyat ya kaskasdaaw ay kailasinan di awnit om-ommat. ");
INSERT INTO xnn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ngem esapay ommat da tona kayman awnit depapen ya paligaten nan ipogaw dakayo. Awnit idalomda dakayo isnan sinagoga ay pagdalomanda ta maibalod kayo. Gapo isnan pammatiyo ken sak-en et awnit kayo maidalom isnan aali ya gogobilno. ");
INSERT INTO xnn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ngem olay tay awnit siya di nan wayayo ay mangibaga isnan gawis ay damag. ");
INSERT INTO xnn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ipasnekyo isnan nemnemyo ta adi kayo madadanagan is awnityo isongsongbat ");
INSERT INTO xnn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","tay sak-en nan awnit mang-itdo isnan kankananyo ya silibyo et adi polos masopyat ya masongbatan. ");
INSERT INTO xnn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nan tap-ina ken dakayo et awnit idalom nan in-ayo ya am-ayo, nan bebsatyo, nan ag-iyo ya nan gagayyemyo ya awnitda ipapatey dakayo. ");
INSERT INTO xnn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Awnit aamisen am-in nan ipogaw dakayo gapo isnan kaitapiyanyo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ngem no anosanyo olay ngan di ik-ikkanda ken dakayo et adi kayo mabalin ay maisiyan ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“No ilaenyo ay likoben di sosoldado id Jerusalem et getkenyo ay nganngani ay madadael ");
INSERT INTO xnn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","et masapol ay nan ipogaw id isna Judea et menbakwitda isnan bilbilig. Isonga nan mentetee id Jerusalem masapol ay komaanda ya nan linmokso abes et masapol ay adida somaa id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tay siya na nan pinagdodosa ay matongpalan nan am-in ay insolat din mamadto id kasin. ");
INSERT INTO xnn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Am-amed kaseseg-ang nan maliton ya nan mensaskot isnan omdanan nan timpo ay naay tay domateng nan kaeegyat ay om-ommat isnan naay ay ili tay dosaen Apo Dios nan naayda ay Judio. ");
INSERT INTO xnn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Awnit mabetbet nan tap-ina ay mapatey dapay maiyey nan tap-ina isnan natkenatken ay il-ili ta menbalinda ay baa. Dadaelen nan baken Judio id Jerusalem engganay pasaldengen Apo Dios daida.” ");
INSERT INTO xnn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dat itoloy Jesus ay mangwani, “Awnit wada pay nan kaeegyat ay ommat isnan agew, isnan bowan ya isnan taltalaw. Am-in ay ipogaw isnan batawa et awnitda omegyat isnan dakkel ay dalloyon ya napigsapigsa ay ngengen nan baybay. ");
INSERT INTO xnn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Matalimodawda gapo isnan egyatda tay adida getken nan awnit ommat pay isnan batawa tay am-in ay wada id daya et maikiwegda. ");
INSERT INTO xnn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Et siya na nan mang-ilaan nan kaipoipogaw ken sak-en ay Iyon-an Am-in di Ipogaw isnan lomayogak ay maitatapi isnan liboo ay magapo id daya. Et somisilangak ay mangipaila isnan kangaton Apo Dios ya wada ken sak-en am-in nan kabaelana. ");
INSERT INTO xnn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","No ommat nan naayda et adi kayo omeg-egyat nodi gomasing kayo tay siya nan manggetkanyo ay nganngani ay mapalobosan kayo isnan ligatyo.” ");
INSERT INTO xnn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dat sodoken Jesus na ken daida, “Nemnemenyo nan kaiw ay higos ya nan tap-in nan kak-aiw ");
INSERT INTO xnn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","tay no sombo nan toboda et getkenyo ay nganngani nan pinag-odan. ");
INSERT INTO xnn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kaneg abes no ilanyo nan om-ommat isnan batawa ay kaneg san inbagak ken dakayo et getkenyo ay nganngani ay omali nan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ibagak ken dakayo nan tet-ewa et ommat san inbagak esapay matey nan am-in ay ipogaw ay matatago id wani. ");
INSERT INTO xnn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Olay no mamaid nan batawa ya nan wada id daya ngem nan am-in ay kankanak et mawawada kayet ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Makail-ilanyo ta baken nan masapolyo isnan batawa is paam-amdenyo ya adi kayo menbaybayanggodaw ya menboteboteng modatya madanatengak ay adiyo getgetken. ");
INSERT INTO xnn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tay no omaliyak et awnit makibtot am-in nan ipogaw isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Isonga gawis no mensasagana kayo dakayo pay kanayon ay menlol-owalo tasiyay waday pigsayo ya toledyo ay mang-itpe isnan awnit om-ommat tapno maitapi kayo ken sak-en ay Iyon-an Am-in di Ipogaw isnan omaliyak kasin.” ");
INSERT INTO xnn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Inagew ay nin-isolsolo si Jesus isnan Templo ngem no malabi dat omey omapa isnan bilig ay Olivo. ");
INSERT INTO xnn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Winakgat ay masapasapa ay omey nan kaipoipogaw isnan Templo ta dengngenda nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nganngani ay omdan nan Fiestan di Linmaosan di Anghel. Siya gedan di nan agew ay mangkakananda is tinapay ay egay kabobodan. ");
INSERT INTO xnn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nan menkangangato ay papadi ya nan men-is-isolo isnan linteg et nintotyada is ikkanda ay mangipapatey ken Jesus tay omegyatda ay mangpatey ken siya no iilaen nan kaipoipogaw tay laylayden nan ipogaw si Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Daet kapeten Satanas si Judas Iscariote ay esa isnan simpoo ya dowa ay pasolot Jesus ");
INSERT INTO xnn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","et ena tolagen nan menkangangato ay papadi ya nan aap-apon nan gowaldiyan di Templo ay awnitna isipsip si Jesus ken daida dadapay mentotolag isnan ikkanda ay mangdepap ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Palalo nan gasingda issan kinwanin Judas dadat kanan en awnitda agtan siya is siping. ");
INSERT INTO xnn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Inowenan Judas danat ilogi ay mennemnem is gawis ay timpo ay mangipadepapana ken Jesus ta adi iilaen nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Inomdan et nan agew ay mangkakanan di Judio is egay kabobodan ay tinapay et siya gedan nan mangpaltiyanda is kalnilo ay kaneg din inikkan din alal-apoda ay Judio isdin nanglaosan di anghel isnan bab-aeyda id Egipto tapno adina itapi ay mangpatey ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dat baaen Jesus da Pedro ken Juan ay mangwani en, “Enkayo isagana nan kanen tako is fiesta.” ");
INSERT INTO xnn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Dadat kanan, “Into pay nan laydem ay omey kami mensaganaan?” ");
INSERT INTO xnn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Dat kanan Jesus, “Enkayo id Jerusalem et awnityo sab-aten isdi nan lalaki ay mangbobolig is sinakdona. Dayot onoden isnan baey ay segpena ");
INSERT INTO xnn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","dayot kanan isnan kabaey en, ‘Inbaan nan apo tako dakami ta sootenmi no into nan kowalto ay awnitmi manganan.’ ");
INSERT INTO xnn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Et awnit itdona ken dakayo nan dakedake ay kowalto isnan maikadwa ay galado dayot isagana nan kanen tako tay wada am-in nan masapol tako isdi.” ");
INSERT INTO xnn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dadat omey et naikkan nan kinwanin Jesus dadat isagana nan kanenda. ");
INSERT INTO xnn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Inomdan nan osto ay olas ay mangananda dat malikob da Jesus ya nan aapostolisna. ");
INSERT INTO xnn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Danat kanan ken daida, “Esakpay menligat et palalo nan layadko ay makiobong ken dakayo isnan naay manganan tako ay mangipanemnem isdin inommat id Egipto. ");
INSERT INTO xnn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ibagak ken dakayo en adiyak kasin mangmangan isnan keg tona ay kikan enggana ay matongpal nan tet-ewa ay kakwaniyana isnan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Danat alaen nan inomenda dat men-iyaman ken Apo Dios danat kanan ken daida, “Alaenyo na ta wasdin ominom ");
INSERT INTO xnn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","tay ibagak ken dakayo en adiyak kasin omin-inom is basi enggana ay omali nan mentolayan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Danat alaen abes nan tinapay et men-iyaman ken Apo Dios danat amam-asen et idyana ken daida ay mangmangwani, “Siya na nan awakko ay maidya ay mangisalakan ken dakayo. Et siya na nan awnityo ik-ikkan ay mangnemnemnem ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Issan nakakananda danat idya kasin ken daida nan inomenda et kanana, “Siya na nan mangipaila isnan balo ay nakitolagan Apo Dios isnan ipogawna. Ipailana nan awnit men-ayosan nan basak ay mang-owas isnan basbasolyo.” ");
INSERT INTO xnn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Danat kanan, “Ngem ilaenyo. Nan awnit mangisipsip ken sak-en et wada isna ay makioobong. ");
INSERT INTO xnn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sak-en ay Iyon-an Am-in di Ipogaw et tet-ewa ay awnitak matey ta matongpal nan naisolat id sang-adom ay ommat ken sak-en ngem kaseseg-ang nan sanay awnit mangisipsip ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dat men-asisoot san aapostolis no sinoy awnit mangisipsip ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Maaw-awni pay dat mentotya nan papasolot Jesus no sino ken daida nan makwani en kangatowan. ");
INSERT INTO xnn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ngem dat kanan Jesus ken daida, “Nan ali isnan batawa et wada nan kalinteganda isnan ipogaw dapay nan mentolay abes et kayatda ay daydayawen di ipogaw daida. ");
INSERT INTO xnn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ngem adi kabalin ay kaneg todi ken dakayo nodi nan kangatowan koma ken dakayo nan mangbadbadang isnan ib-ana ay kaneg nan ik-ikkan nan baa. ");
INSERT INTO xnn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sino aya nan nangatngato, ay nan tomotokdo ay mapakpakan wenno nan baana ay mang-id-idya is kanena? Ay baken nan masilbiyan? Ngem sak-en pay ay apoyo et mensilsilbiyak ken dakayo ay kanega baa. ");
INSERT INTO xnn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nakitetee kayo ken sak-en et inan-anosanyo nan ligatko ya egay kayo nangtaytaynan. ");
INSERT INTO xnn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Isonga awnitko mentolayen dakayo ay kaneg nan inikkan Ama ay nangyali isnan kalebbengak ay mentolay ");
INSERT INTO xnn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tapno makiobong kayo isnan manganak isnan mentolayak, dakayopay tomokdo isnan tokdowan di ali ay mangbanag isnan am-in ay Judio ay aap-on din simpoo ya doway an-ak din si Israel.” ");
INSERT INTO xnn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Dat itoloy Jesus ay mangwani, “Dengngem pod Simon. Layden Satanas ay mangdolog ken dakayo tasiyay masis-iyan kayo ay kaneg nan matap-an ay pagey et komaan nan taep dapay mataynan nan begasna. ");
INSERT INTO xnn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ngem inlol-owalowak sik-a, Simon, tapno adi mamaid nan pammatim. Getkek ay awnitka mangdokog ngem no somagongka et masapol ay papigsaem nan iib-am.” ");
INSERT INTO xnn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ngem dat kanan Simon Pedro, “Apo, sak-en et adi kamam-aid nan pammatik et olay pay no maitapiyak ken sik-a isnan pagbalodan ya maitapiyak ken sik-a ay matey.” ");
INSERT INTO xnn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Dat kanan Jesus, “Ngem ibagak ken sik-a, Pedro, esapay mentan-o nan manok is wakgat et mamitlo ay mangisotka en adika mangtek.” ");
INSERT INTO xnn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dat kanan Jesus ken daida en, “Isdin nangibab-aaak ken dakayo ay maid inkawityo is sangi, siping ya sapatosyo, ay waday ninkolanganyo?” Dadat kanan, “Maid.” ");
INSERT INTO xnn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dat kanan Jesus, “Owen, maid tay laylayden nan ipogaw sak-en isdi isonga inid-idyada nan masapolyo ngem id wani adyanda sak-en isonga nan wada nan sangina ya sipingna danat ikkawit. Nan maid gamigna danat ilako nan badona no maid sipingna ta lomako. ");
INSERT INTO xnn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tay masapol matongpal din naisolat id kasin ay maipanggep ken sak-en isnan kalin Apo Dios ay mangwani en, ‘Siya et naitapi isnan dosan nan ninpatpatey’ et naay nganngani ay matongpal.” ");
INSERT INTO xnn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Dat kanan nan papasolotna, “Apo, naay di dowa ay gamig.” Dat kanan Jesus, “Osto et sa.” ");
INSERT INTO xnn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kinmaan si Jesus ya nan papasolotna issan ili dadat omey isnan bilig ay Olivo tay siya nan ogalina. ");
INSERT INTO xnn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Inomdanda pay danat kanan ken daida, “Menlowalo kayo tasiyay adi kayo kadolog ay menbasol.” ");
INSERT INTO xnn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dat omad-addawi si Jesus ken daida dat menpalintomeng et menlowalo ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama, no mabalin et kaanem koma nan naay ligatko. Ngem baken nan laydek is matongpal nodi nan laydem.” ");
INSERT INTO xnn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dat menpaila ken siya nan anghel ay nagapo id daya ay mangipapigsa ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gapo isnan palalo ay ligatna danat ipapasnek ay menlowalo et kaneg basa nan lingetna ay nintedted isnan lota. ");
INSERT INTO xnn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nakalowalo pay dat somagong isnan kad-an san papasolotna danat ilaen ay maseseyepda tay nabbayda gapo isnan dadama ay seg-angda ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dat kanan Jesus ken daida, “Dakayon aped maseseyep? Igidoyo ta menlowalo kayo tasiyay adi kayo kadolog ay menbasol.” ");
INSERT INTO xnn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Daan ay menkalkali si Jesus dat domateng nan kaipoipogaw ay inpangolon Judas ay esa isnan simpoo ya dowa ay pasolotna. Dat somag-en ken Jesus ta bisitowena ");
INSERT INTO xnn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ngem dat kanan Jesus, “Judas, ay mangbisitoka tapno ipailam ay sak-en ay Iyon-an Am-in di Ipogaw nan depapenda?” ");
INSERT INTO xnn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wada pay ay ilaen nan papasolotna nan ommat ken Jesus dadat kanan, “Apo, ay makibinetbet kami?” ");
INSERT INTO xnn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dat menpingasan nan esay pasolotna nan kanawan ay ingan nan baan nan kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ngem dat kanan Jesus, “Ad-o sa.” Danat kapposen nan ingan san baa dat gomawis. ");
INSERT INTO xnn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dat kanan Jesus isnan menkangangato ay papadi, nan aap-apon nan gowaldiyan di Templo ya nan aamam-a ay inmey mangdepap ken siya en, “Aykeak pomatey ta men-aalmas kayo ay omali ay mangdepap ken sak-en? ");
INSERT INTO xnn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaageagew ay nin-isolsolowak ken dakayo isnan Templo et egay kayo nangdepdepap. Ngem id wani inpalobos Apo Dios dakayo ay mangdepap isonga nan layden Satanas ya nan laydenyo nan matongpal.” ");
INSERT INTO xnn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinpapda si Jesus dadat eyey isnan baey san kangatowan ay padi et omon-onod si Pedro ngem omaaddawi. ");
INSERT INTO xnn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dinentanda nan pag-anidowan isnan pantew dat makianido si Pedro. ");
INSERT INTO xnn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dat ilaen nan esay baa si Pedro ay sisilangan nan apoy danat inengneng siya danapay kanan, “Naay di esay ib-an Jesus.” ");
INSERT INTO xnn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dat isot Pedro ay mangwani isnan babai en, “Dapay adiyak getken si todi ay ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Maaw-awni pay dat imatonan kasin nan esay lalaki si Pedro danat kanan, “Esaka gedan ken daida.” Ngem dat kanan Pedro, “Bakenko ib-a daida.” ");
INSERT INTO xnn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Maid pay esay olas dat wada kasin nan lalaki ay mangipapati en, “Tet-ewa ay ib-an nan lalaki ay naay si Jesus tay iGalilea siya gedan.” ");
INSERT INTO xnn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dat kasin kanan Pedro, “Adiyak polos getken nan kankanam.” Daan ay menkalkali dat matanan-o nan manok. ");
INSERT INTO xnn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dat sagongen Jesus si Pedro et inengnengna. Dat maipanemnem ken Pedro san inbagan Jesus en, “Esapay mentan-o nan manok id wani ay agew et mamitlo ay nangisotka.” ");
INSERT INTO xnn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Menbabawi si Pedro issan nangisotana ken Jesus isonga dat bomala et men-ogaog. ");
INSERT INTO xnn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dat ilogin nan mangbanbantay ken Jesus ay mangselselat dadapay tipaken siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kinobotanda nan matana dadat kanan, “Ibagam no sino nan nangtipak ken sik-a no tet-ewa ay mamadtoka.” ");
INSERT INTO xnn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Adoado pay nan kinkinwanida ay nangbaibain ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kawakgatana pay dat madagop nan menlelebbeng ay Judio ay menkangangato ay papadi ya nan men-is-isolo isnan linteg dat maeyey si Jesus isnan kad-anda et somalyaenda siya. ");
INSERT INTO xnn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Dadat kanan, “Kadya, ibagam no sik-a si Kristo ay inbaan Apo Dios.” Dat kanan Jesus, “No ibagak et adi kayo met laeng patiyen sak-en ");
INSERT INTO xnn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ya no mensootak et adi kayo met laeng songbatan. ");
INSERT INTO xnn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ngem enggana id wani et tomokdo nan Iyon-an Am-in di Ipogaw ay mentolay isnan makanawan Apo Dios ay manakabalin.” ");
INSERT INTO xnn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dadat kanan am-in, “Adi pay sik-a ngalod nan Anak Apo Dios?” Danat kanan, “Osto nan inbagayo.” ");
INSERT INTO xnn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dadat kanan, “Adi masapol pay laeng di mangpaneknek isnan basolna tay dinnge tako am-in ay apedna kankanan en Anak Apo Dios siya.” ");
INSERT INTO xnn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Am-in san wada isdi ay nangidalom ken Jesus et tinmakdegda dadat eyey si Jesus ken Pilato ay gobilnadol ");
INSERT INTO xnn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","et kasinda idalom ken siya ay mangmangwani en, “Sinokalanmi si tona ay mang-al-allilaw isnan kailiyanmi ta adida kano baybayadan nan bowis ken Cesar danapay kankanan en siya si Kristo ay ali.” ");
INSERT INTO xnn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Dat sooten Pilato, “Ay sik-a nan alin di Judio?” Dat kanan Jesus, “Osto nan kinwanim.” ");
INSERT INTO xnn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Isonga dat kanan Pilato isnan menkangangato ay papadi ya nan kaipoipogaw, “Maid met masokalak is basol nan naay lalaki.” ");
INSERT INTO xnn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ngem ipapatida kayet ay mangwani en, “Dapay it-itdona isnan ipogaw en men-goloda. Inlogina id Galilea et enggana id isna Judea.” ");
INSERT INTO xnn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Issan nangdengan Pilato isna danat sooten no iGalilea siya. ");
INSERT INTO xnn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Issan nangtekana ay nagapo si Jesus isnan ili ay sakop di Galilea ay mentoltolayan Herod danat paeyen siya ken Herod tay wada si Herod id Jerusalem issan fiesta. ");
INSERT INTO xnn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Men-galalasing si Herod isnan nang-ilaana ken Jesus tay nabayag ay dinngena nan maipanggep ken siya isonga laydena ay mang-ila isnan kaskasdaaw ay ik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Adoado nan sinos-oot Herod ngem egay polos sinmongsongbat si Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nan menkangangato ay papadi ya nan men-is-isolo isnan linteg et tinmakdegda ay mangpabasbasol ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dat saysayoten ya selselaten da Herod ya nan sosoldadona si Jesus. Dadat badowan siya is badon di ali esadapay pasagongen ken Pilato. ");
INSERT INTO xnn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Enggana isdi ay agew dat men-gayyem da Herod ken Pilato dapay ninbinbinosoda id kasin. ");
INSERT INTO xnn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Dat paayagan Pilato nan menkangangato ay papadi ya nan ib-ada ay menlelebbeng ay Judio ya nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Danat kanan ken daida, “Indalomyo si tona ken sak-en ay mangwani en ipangpangolona nan ipogaw ay manggolo isnan gobilno. Ngem sinomalyak ay iilaenyo et maid nasokalak is ngawi ay mangipabasbasolanyo ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Olay si Herod et maid sinokalana is basolna tay inpasagongna siya ken dakami. Maid basol tona is apedna kapateyan. ");
INSERT INTO xnn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ipasaplitko et kedeng esakpay palobosan.” ");
INSERT INTO xnn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kinwanina di tay nan ogalida et tinew-en isnan fiesta ay deey et omipalobos nan gobilnadol is esay balod. ");
INSERT INTO xnn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dat igig-iyaw nan kaipoipogaw en, “Ipapateymo kayet siya. Tay si Barabas nan kayatmi ay palobosam.” ");
INSERT INTO xnn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabas et naibalod gapo tay nin-golo id Jerusalem dapay ninpatey. ");
INSERT INTO xnn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gapo tay kayten Pilato ay mangipalobos ken Jesus isonga nakikali kasin ken daida ");
INSERT INTO xnn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ngem in-giyawda kayet en, “Pailansam isnan kros. Pailansam isnan kros.” ");
INSERT INTO xnn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dat pitlowan Pilato ay mangwani ken daida, “Aytay? Ay ngan pay di basolna? Maid getkek is inikkana is gapo is kapateyana. Pasaplitko et kedeng daket palobosan.” ");
INSERT INTO xnn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ngem am-amedda in-giyaw en mailansa si Jesus isnan kros et nangabakda. ");
INSERT INTO xnn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Isonga dat tongpalen Pilato nan laydenda. ");
INSERT INTO xnn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pinalobosana san nin-golo ya ninpatey tay siya nan laydenda danapay kanan en mapatey si Jesus ay kaneg nan inbagada. ");
INSERT INTO xnn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Inkaanda si Jesus ay omey mangilansa isnan kros dadat sab-aten nan esay lalaki ay si Simon ay iCirene ay nagapo isnan ilit. Omey koma id Jerusalem ngem inpapatida ay mangipabolig isnan kros ken siya dadat ipaonod ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Adoado nan ipogaw ay inmonod ken Jesus et nan tap-in di bababai et men-ag-agada gapo isnan seg-angda ken siya. ");
INSERT INTO xnn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ngem dat sagongen Jesus daida et kanana, “Dakayo ay bababain di iJerusalem et adiyo ag-agaan sak-en nodi nan aw-awakyo ya nan an-akyo bawet nan agaanyo. ");
INSERT INTO xnn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tay awnit omdan nan timpo ay menligat nan ipogaw isonga awnit kananda en nagasat nan bababai ay maid an-akda tay awnit maid ilaenda is menligatan di an-akda. ");
INSERT INTO xnn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Siya di gedan nan awnitda mangwaniyan isnan bilbilig en gawgawis no magday ta gab-onanda daida gapo isnan palalo ay ligatda. ");
INSERT INTO xnn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tay no siya di nan ikkanda ken sak-en ay maid basolna et awnit am-amed nan ikkanda ken dakayo ay managbasol,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wada gedan nan dowa ay mangakew ay inbowegda ta mapateyda ay maigisan ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wada pay ay omdanda isnan bilig ay makwani en ingit di toktok wenno Calvary dadat ilansa si Jesus isnan kros. Inlansada gedan san dowa ay mangakew isnan krosda et wada nan esa isnan makanawan Jesus ya nan esa isnan makanigidna. ");
INSERT INTO xnn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dat kanan Jesus, “Ama, pakawanem nan mang-ik-ikkan isnan ngawi ken sak-en tay adida getken nan ik-ikkanda.” Daet menbobonot nan sosoldado esadapay pigasen nan badon Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","San kaipoipogaw et tomatakdegda ay mangboyboya dapay saysayoten nan aap-apon di Judio ay mangmangwani en, “Insalakana kano nan tap-in di ipogaw. Isonga isalakana koma abes nan awakna no tet-ewa ay siya si Kristo ay inbaan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sinaysayot gedan nan sosoldado. Sinmag-enda ken Jesus et agindaiidya is basi ");
INSERT INTO xnn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","dadapay kanan, “Isalakanmo nan awakmo no sik-a tet-ewa nan alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kinwanida di tay wada nan naisosolat isnan ngangatowena ay, “Si tona nan alin di Judio.” ");
INSERT INTO xnn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","San esa abes ay mangakew ay nailansa et saysayotena si Jesus ay mangmangwani, “Ay baken sik-a si Kristo? Isalakanmo ngalod nan awakmo dakat abes isalakan dakami.” ");
INSERT INTO xnn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ngem san ib-ana ay mangakew et iniyawna san ib-ana ay mangwani, “Ay adika omegyat ken Apo Dios? Nais-o tako am-in ay madosdosa ");
INSERT INTO xnn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ngem lebbengna ay madosata gapo isnan inikkanta. Ngem si tona et maid ngawi is inikkana dapay aped madosdosa.” ");
INSERT INTO xnn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Danat kanan ken Jesus, “Apo, mangnenemnemka no awnitka omali ay men-ali.” ");
INSERT INTO xnn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Dat kanan Jesus ken siya, “Ibagak ken sik-a, id wani ay agew maitapika ken sak-en ay makigasgasing id daya.” ");
INSERT INTO xnn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kag-aw ay tinmenga nan agew dat bomolinget nan batawa engganay inmalas tres isnan sedem. ");
INSERT INTO xnn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Isnan Templo et nan menselelede ay koltina ay manglilingeb isnan nasantowan ay kowalto et aped nabisngat ay makadwa. ");
INSERT INTO xnn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dat ibiyad Jesus nan kalina, “Ama, idyak nan ab-abiikko ken sik-a.” Osto ay kinwanina di dat maoyos nan leng-agna. ");
INSERT INTO xnn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nan kapitan di sosoldado et inilana san inommat dat mendayaw ken Apo Dios ay mangwani, “Tet-ewa obpay ay maid basol nan ipogaw ay naay.” ");
INSERT INTO xnn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Inilan gedan san kaipoipogaw ay inmey ninboya san inommat dadat somaa ay dadama nan seg-angda. ");
INSERT INTO xnn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ngem am-in san iib-an Jesus ya nan bababai ay naknakkey ken siya enggana id Galilea et nataynanda tay kayatda ay ilaen nan om-ommat. ");
INSERT INTO xnn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wada nan am-ama ay kangadan si Jose ay iyArimatea ay sakop di Judea. Siya et gawis ay ipogaw tay osto nan ik-ikkana et sedsed-ena nan menlogiyan nan mentolayan Apo Dios. Siya et esay ap-apon di Judio ngem egay naitapi isnan ngawi ay inik-ikkan nan iib-ana ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inmey si Jose ken Pilato ay mangdawat isnan awak Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Danat kaanen nan awak Jesus isnan krosna et bongonena isnan balo ay galot danat ippey isnan nakakaongan ay bato ay egay kaos-osal. ");
INSERT INTO xnn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nganngani ay magisbet isnan Biyalnis et mensagana nan Judio tay siya nan menlogiyan nan obayada engganay magisbet kasin isnan Sabado. ");
INSERT INTO xnn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","San bababai ay nang-on-onod ken Jesus enggana id Galilea et inmonodda ken Jose ta ilaenda nan maipay-an nan awak Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dadat somaa ay mangisagana isnan lana ya nan menbango ay agas ay awnitda iyapowap isnan awakna. Inomdan nan obaya isonga dadat omilleng tay siya nan bilin nan lintegda. ");
INSERT INTO xnn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wakgawakgat isnan Domingo dat omey san bababai issan naipay-an san awak Jesus et inkawitda nan menbango ay agas. ");
INSERT INTO xnn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dinatnganda ay naolin nan bato ay tangeb san naipay-an Jesus ");
INSERT INTO xnn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","isonga dadat songgep ngem maid dinatnganda issan awakna. ");
INSERT INTO xnn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nasngangda isnan inommat dat mawanada nan doway lalalaki ay mensilsilang nan badoda. ");
INSERT INTO xnn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Dadat menlokbob gapo isnan dadama ay egyatda ngem dat kanan san lalalaki ken daida en, “Aytay dayon an-anapen nan natago isnan kad-an di natey? ");
INSERT INTO xnn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Maiwed si Jesus isna tay kasin natago. Ay kinalingkinganyo din inbagana ken dakayo isdin kad-ana id Galilea en ");
INSERT INTO xnn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","siya ay Iyon-an Am-in di Ipogaw et masapol ay maidya isnan managbasol et ilansada isnan kros ngem dat kasin matago isnan maikatlo ay agew?” ");
INSERT INTO xnn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ninemnem san bababai din inbagan Jesus ");
INSERT INTO xnn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","isonga dadat somaa et ibagada issan simpoo ya esay pasolotna ya san iib-ada san inommat. ");
INSERT INTO xnn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Naay da san bababai ay nangibaga isnan aapostolis issan inommat, si Maria Magdalena, si Juana ya si Maria ay inan Santiago ya nan tap-ida ay bababai. ");
INSERT INTO xnn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ngem egay pinatin san aapostolis daida tay kananda en waay baken tet-ewa nan inbagada. ");
INSERT INTO xnn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ngem si Pedro et tinmagtag ay omey issan naipay-an Jesus danat osdongan et tet-ewa ay kedeng nan galot is inilana. Dat somaa ay mangnemnemnem isnan inommat. ");
INSERT INTO xnn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Issan deey met laeng ay agew et mendad-aan nan dowa ay pasolot Jesus ay omey isnan ili ay Emaus. Waay nasolok ay simpoo ya esa ay kilometro nan kaad-addawina id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Sodsodokenda nan am-in ay inom-ommat ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Issan menkalkaliyanda dat somag-en si Jesus et maiboweg ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inilada siya ngem egayda nakaimaton. ");
INSERT INTO xnn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dat kanan Jesus ken daida, “Ay ngan nan sodsodokenyo isnan mendad-aananyo?” Dadat itakdeg et maiila isnan angasda ay menseseg-angda. ");
INSERT INTO xnn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nan esa ken daida ay kangadan is Cleofas et kinwanina ken Jesus, “Waay kedengka is mentetee id Jerusalem is adi mangtek isnan inom-ommat isdi isnan nadandan ay agew.” ");
INSERT INTO xnn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Dat sooten Jesus, “Ay ngan di inom-ommat?” Dadat kanan, “San inikkanda ken Jesus ay iNazaret. Siya nan tet-ewa ay mamadton Apo Dios tay inilan am-in nan ipogaw nan panakabalina isnan kinagawis nan insolsolona ya nan nakaskasdaaw ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ngem nan menkangangato ay papadi ya nan menlelebbeng isnan ili tako et indalomda siya isnan gobilnadol dadat pailansa isnan kros. ");
INSERT INTO xnn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dapay kananmi en siya koma nan mangisalakan id Israel. Owen, et baken kedeng di. Id wani nan maikatlo ay agew enggana isdin nateyana. ");
INSERT INTO xnn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nan tap-in nan bababaimi et tinaada dakami tay inmeyda issan wakgawakgat issan naipay-an Jesus ");
INSERT INTO xnn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ngem egayda kano dinatngan nan awakna. Dadat mensagong ay mangmangwani en ninpaila kano nan aanghel ay nangwani en natago siya. ");
INSERT INTO xnn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Inmey gedan nan iib-ami issan naipay-ana et pinaneknekanda ay tet-ewa san kinwanin san bababai ay egayda inila si Jesus.” ");
INSERT INTO xnn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dat kanan Jesus ken daida, “Ay apo, menkenteg nan toktokyo. Naligat nan mangpatiyanyo isnan am-in ay inbagbagan din mamadto. ");
INSERT INTO xnn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ay baken aya masapol ay menligat si Kristo esapay omey id daya?” ");
INSERT INTO xnn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Danat ibaga nan maipanggep ken siya isnan naisolat id kasin ay kalin Apo Dios enggana isnan liblon Moses ya nan insolsolat din mamadto. ");
INSERT INTO xnn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Inomdanda pay issan ili ay omayanda dat itoloy Jesus ay mendaan ");
INSERT INTO xnn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ngem dadat ipakod siya ay mangmangwani, “Omapaka isna tay naay bomolinget.” Isonga dat makkey ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wada pay ay manganda danat alaen nan tinapay et men-iyaman ken Apo Dios danat amasen et idyana ken daida. ");
INSERT INTO xnn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dat kaneg natokaban nan matada et imatonanda siya ngem dat aped namanaid si Jesus. ");
INSERT INTO xnn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Dadat men-asikwani en, “Tet-ewa obpay ay siya si Jesus iso gayam nga gawis nan nemnemta issan daan issan nangibagbagaana isnan maipanggep ken siya ay wada isnan liblon Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dadat ikakamo ay mensagong id Jerusalem dadat datngan san simpoo ya esay pasolot ya nan tap-ina ay nadagop isdi ");
INSERT INTO xnn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ay mangmangwani en, “Tet-ewa obpay ay natago si Apo Jesus tay ninpaila ken Simon.” ");
INSERT INTO xnn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dat abes ibagan san dowa san inommat issan daan ya san nangimatonanda ken Jesus issan nang-amasana issan tinapay. ");
INSERT INTO xnn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Daan ay sodsodokenda na ken daida dat mawanada si Jesus et kanana ken daida, “Somingpa nan nemnemyo.” ");
INSERT INTO xnn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dat dadama nan egyatda tay kananda en ab-abiik Jesus nan iilanda. ");
INSERT INTO xnn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ngem dat kanan Jesus ken daida, “Dakayon omegyat ya mendowadowa no sak-en wenno bakenak? ");
INSERT INTO xnn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ilaenyo nan sikik ya adpak et sak-en tet-ewa. Mangkappos kayo tasiyay mapnek kayo. Tay nan ab-abiik et maid awakna ya ingitna ngem wada ken sak-en ay iilanyo.” ");
INSERT INTO xnn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kinwanina di danapay ipaila nan nalansaan ay adpana ya sikina. ");
INSERT INTO xnn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Masmasdaawda ya men-galalasingda ngem mendodowada kayet isonga dat sooten Jesus, “Ay waday makan isna?” ");
INSERT INTO xnn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dadat agtan is dinawkis ay ikan ");
INSERT INTO xnn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","danat isda dadapay iilaen. ");
INSERT INTO xnn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Danat kanan ken daida, “Nan nateyak ya nan natagowak kasin et siya din inbagbagak isdin kawad-ak ken dakayo. Tay masapol ay matongpal am-in din naisolat ay maipanggep ken sak-en isnan insolat din si Moses ya din tap-in di mamadton Apo Dios ya nan naisolat gedan isnan liblo ay Salmo.” ");
INSERT INTO xnn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Danat ipalawag ken daida nan naisolat ay kalin Apo Dios id kasin ta maawatanda ");
INSERT INTO xnn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","danat kanan, “Siya na nan naisolat ay maipanggep ken sak-en, ‘Masapol ay menligat si Kristo esapay matey dat matago isnan maikatlo ay agew ");
INSERT INTO xnn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","isonga am-in ay mamati ken siya dadapay ibabawi nan basbasolda et pakawanen Apo Dios daida.’ Masapol ay maibagbaga nan naay gawis ay damag isnan am-in ay il-ili isnan batawa menlogi id isna Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Et dakayo ay nang-ila is dadi et masapol ay dakayo nan mangibagbaga en tet-ewa da tona. ");
INSERT INTO xnn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngem sesed-enyo id Jerusalem enggana ay dawatenyo nan panakabalin ay magapo id daya tay awnitak ibaa nan Ispirito Santo ay inbagan Amak.” ");
INSERT INTO xnn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Danat eyey nan papasolotna id Betania danat ipangato nan ledengna et bindisyonana daida. ");
INSERT INTO xnn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Daan ay binbindisyonana daida danat taynan daida et maipangato id daya. ");
INSERT INTO xnn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dinaydayawda siya dadat somagong id Jerusalem ay dadama nan gasingda. ");
INSERT INTO xnn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kanayon ay omeyda isnan Templo ay mendaydayaw ken Apo Dios.");
INSERT INTO xnn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Isdin loglogina ay esapay mawada nan batawa et nawawada nan Kali ay si Kristo et nawawada ken Apo Dios san Kali ya Dios gedan siya. ");
INSERT INTO xnn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Owen, nawawada siya ken Apo Dios esapay mawada nan naboliw. ");
INSERT INTO xnn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Inpaboliw Apo Dios ken siya nan am-in et maiwed nawada no egayna boliwen. ");
INSERT INTO xnn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Magapo ken siya nan biyag ya siya nan mangtangtanggew isnan nemnem di ipogaw ay kaneg silaw. ");
INSERT INTO xnn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tatanggewan nan silaw nan menbolinget et adi polos makaabak nan bolinget isnan silaw. ");
INSERT INTO xnn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wada gedan nan inbaan Apo Dios ay kangadan is Juan. ");
INSERT INTO xnn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Inmali ay mangipagtek issan silaw tasiyay dengen am-in di ipogaw dadat patiyen san silaw. ");
INSERT INTO xnn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Baken si Juan san silaw ngem inmali ay mangipagtek issan silaw ay si Jesu Kristo. ");
INSERT INTO xnn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Owen, siya nan tet-ewa ay silaw ay inmali isnan batawa ay mangtanggew isnan am-in ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Inmali san makwani en Kali isnan batawa et olay no naboliw gapo ken siya et egay kayet inmatonan nan ipogaw siya. ");
INSERT INTO xnn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Inmali isnan osto ay ilina ngem inadyan nan kailiyana siya. ");
INSERT INTO xnn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ngem wadada nan nangdawat ya nangpati ken siya et daida nan inagtana is kalintegan ay menbalin ay an-ak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Et baken kaneg nan ikkan nan sin-asawa ay omanak is ikkanda ay menbalin ay an-ak Apo Dios nodi isnan kabaelana ay Amada. ");
INSERT INTO xnn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","San Kali et ninbalin is ipogaw ay si Jesu Kristo dat makitee ken dakami. Am-in ay kinkinwanina et tet-ewa ya gawigawis nan inik-ikkana ay nangipaila isnan layadna. Inilami nan panakabalina ay inidyan Amana ken siya ay kedkedeng is Anakna. ");
INSERT INTO xnn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Siya nan inpagtek Juan isdin nangwaniyana en, “Si tona din inbagak ken dakayo en awnit wada nan somosokat ken sak-en ay nangatngato mo sak-en tay nawawada esakpay mawada.” ");
INSERT INTO xnn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gapo isnan dadama ay layadna ken datako et id-id-idyana nan gawis ken datako. ");
INSERT INTO xnn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nan linteg Apo Dios nan inpagtek din si Moses ngem nan inpagtek Jesu Kristo et nan kinatet-ewan nan maipanggep ken Apo Dios ya nan layadna ken datako. ");
INSERT INTO xnn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maiwed nakail-ila ken Apo Dios nodi nan kedkedeng ay Anakna ay makitetee ken Amana et siya nan nangipagtek. ");
INSERT INTO xnn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Naay nan inommat isdin nangipagtekan Juan isnan maipanggep ken Jesus. Inbaan nan aap-apon di Judio id Jerusalem nan papadi ya nan iib-ada ay makwani en Levite ta sootenda ken Juan no sino siya. ");
INSERT INTO xnn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Dat songbatan Juan et ibagana nan tet-ewa ay mangwani en, “Bakenak si Kristo ay inbaan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ngem dadat kayet sooten, “Sinoka pay obpay? Ay sik-a din si Elias ay mamadto ay kasin natago?” “Bakenak,” kinwanin Juan. “Ay sik-a nan mamadto ay inbaan Apo Dios ay sesed-enmi?” kinwanida. “Baken,” kinwanin Juan. ");
INSERT INTO xnn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dadat kanan, “Ibagam ngalod ken dakami no sinoka tay masapol ay ibagami isnan nangbaa ken dakami. Ay ngan pay nan pangwanim isnan awakmo?” ");
INSERT INTO xnn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dat kanan Juan, “Sak-en nan mangtongpal isdin kinwanin Isaias ay mamadto id kasikasin ay nangwani en, ‘Wada isnan bilbilig nan mangibogbogaw en enkayo menletgen nan daanen nan Apo tako ay awnit omali.’” ");
INSERT INTO xnn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dat kayet sooten nan Fariseo ay tap-in di inbaan nan aap-apon di Judio en, ");
INSERT INTO xnn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Ngan nan kalebbengam ay menbonbonyag no bakenka si Kristo, si Elias ya no bakenka san mamadto?” ");
INSERT INTO xnn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Dat kanan Juan, “Ibonyagko nan danom ngem wada nan naiddom ken dakayo ay adiyo getgetken ");
INSERT INTO xnn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","et siya nan awnit mangsokat ken sak-en. Et gapo isnan kawedwedana et adiyak maibilang ay mangkaan isnan olay sapatosna.” ");
INSERT INTO xnn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inommat am-in dana id Betania ay dedemangen di ginawang ay Jordan ay menbonbonyagan Juan. ");
INSERT INTO xnn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kawakgatana dat ilaen Juan si Jesus ay somagsag-en danat kanan, “Si todi nan mangkaan isnan basbasol di ipogaw isnan batawa gapo isnan awnitna kateyan. Inyalin Apo Dios siya ay kaneg kalnilo ay mapalti ta kaanena nan basol. ");
INSERT INTO xnn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Si todi san kinwanik en awnit wada nan mangsokat ken sak-en ay nangatngato mo sak-en tay nawawada esakpay mawada. ");
INSERT INTO xnn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Egayak gintek no sino siya ngem inmaliyak ay mangibonbonyag is danom tasiyay ipagtekko siya isnan Judio.” ");
INSERT INTO xnn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Danat kanan ay mangipagtek isnan inommat, “Egayak gintek siya ay sokod inbagan Apo Dios ay nangibaa ken sak-en en, ‘Awnitmo ilaen nan Ispirito Santo ay lomayog ay pomatong isnan esay lalaki et siya nan awnit mangibonbonyag isnan Ispirito Santo.’ Et tinmet-ewa tay inilak nan Ispirito Santo ay linmayog ay nagapo id daya ay kaneg kalapati dat pomatong ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Siya nan inilak isonga ipaneknekko ken dakayo ay siya tet-ewa nan Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kawakgatana kasin dat wada da Juan ya nan dowa ay pasolotna ");
INSERT INTO xnn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","danat inenengneng si Jesus ay lomaos danapay kanan, “Ilaenyo. Si tona nan kalnilon Apo Dios ay mangkaan isnan basbasol di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dinngen pay san doway pasolotna san kinwanina dadat omonod ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dat mensagong si Jesus et ilaena daida ay omon-onod danat sooten, “Ay waday ibagayo?” Dadat kanan, “Rabbi, ay into nan menteteam?” (Nan kanan nan Judio isnan rabbi et mistolo.) ");
INSERT INTO xnn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Danat kanan ken daida, “Akayo ta entako ilaen.” Isonga dadat makkey ken siya et enda ilaen nan menteteana dadat makitetee ken siya issan sedem engganay nagisbet. ");
INSERT INTO xnn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","San esa ken daida ay dowa et si Andres ay besat Simon Pedro. ");
INSERT INTO xnn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dat ikakamon Andres ay mang-anap ken Simon ta ibagana en, “Dinas-anmi nan Mesias.” Nan kayatna ay kanan et dinas-anda si Kristo ay sedsed-enda tay inbagan Apo Dios en awnitna ibaa. ");
INSERT INTO xnn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dat bowegen Andres si Simon et omeyda ken Jesus. Dat inengneng Jesus siya danat kanan, “Sik-a si Simon ay anak Juan ngem menngadanmo et nan Cefas.” (Nan ngadan ay naay isnan kalin di Judio et paliso nan kanana isnan ngadan ay Pedro ay makwani en bato.) ");
INSERT INTO xnn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Issan kawakgatana dat kanan Jesus en omey isnan probinsiya ay Galilea. Dinatngana si Felipe danat kanan, “Makkeyka ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe et kailiyan da Andres ken Pedro ay nagapo id Betsaida id Galilea. ");
INSERT INTO xnn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dat anapen Felipe si Natanael danat kanan, “Dinas-anmi nan ipogaw ay insolat Moses isnan liblo ay naisolatan nan linteg ya din insolat din mamadto. Siya si Jesus ay iNazaret ay anak Jose.” ");
INSERT INTO xnn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Ayke waday gawis is magapo id Nazaret?” kinwanin Natanael. Dat kanan Felipe, “Aka bawet ta enta ilaen.” ");
INSERT INTO xnn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Issan nang-ilaan Jesus ken Natanael ay om-omey isnan kad-ana danat kanan, “Naay di tet-ewa ay Judio ay maid ngawi isnan nemnemna.” ");
INSERT INTO xnn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Dat sooten Natanael, “Ngan di mangtekam ken sak-en?” Dat kanan Jesus, “Inilak sik-a issan kad-am issan poon di kaiw esapay omey ayagan Felipe sik-a.” ");
INSERT INTO xnn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dat kanan Natanael, “Apo, sik-a od nan Anak Apo Dios. Sik-a nan ali ay sedsed-enmi isna id Israel.” ");
INSERT INTO xnn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Dat kanan Jesus, “Ay nan mamatiyam et gapo tay inbagak en inilak sik-a isnan poon di kaiw? Ngem awnit wada pay nan ilaem ay kaskasdaaw mo nan naay. ");
INSERT INTO xnn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ibagak et tet-ewa ay awnityo ilaen ay matokaban id daya et om-omey ya omal-ali nan aanghel Apo Dios ken sak-en ay makwani en Iyon-an Am-in di Ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Issan maikatlo ay agew et wada nan babayas id Cana ay sakop di Galilea. Wada si inan Jesus isdi ");
INSERT INTO xnn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","dapay nadkat gedan si Jesus ya san papasolotna. ");
INSERT INTO xnn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naamin pay nan tapey dat kanan inan Jesus ken siya, “Naamin et nan tapeyda.” ");
INSERT INTO xnn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Dat kanan Jesus, “Ina, adi masapol ay ibagam nan ikkak. Egay pay omdan nan mang-ikkanak isnan inbilin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngem dat ibagan inana isnan deeyday baa isdi en, “Tongpalenyo am-in nan ibagana ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nan Judio et wada nan abigda isnan menboowanda isonga wada nan enem ay bolnay isdi ay maipaypay-an di danom et waay limay boti nan malaon di esa. ");
INSERT INTO xnn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Dat kanan Jesus issan deeyday baa, “Ponowenyo dana is danom.” Dadat ponowen san deeyday bolnay ");
INSERT INTO xnn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","danat kanan, “Ala, gomaod kayo ta eyeyyo isnan apowen di baey ay naay.” Siya di nan inikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dat tamtaman san apowen di baey san danom ay ninbalin is tapey daet masdaaw tay gawigawis. Ngem adina getken nan nagapowana tay kedengda ay baa is mangtek tay daida nan nang-ala. Danat ayagan san lalaki ay binommey ");
INSERT INTO xnn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","et kanana, “Nan ogalin di ipogaw et nan kagawisan ay tapey nan iyapagda omon-ona isnan sangailida et no maamin nan kagawisan dadat iyapag nan kaasiyan. Ngem sik-a et apay nga inpaod-odim ay nangiyapag isnan kagawisan ay tapey?” ");
INSERT INTO xnn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nan naay inikkan Jesus id Cana ay esay ili id Galilea et siya nan damo ay kaskasdaaw ay inikkana ay nangipailaana isnan panakabalina dat omam-amed nan pammatin nan papasolotna ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nakwas pay san babayas dat omey da Jesus ken da inana, nan bebsatna ya nan papasolotna id Capernaum dadat mentetee isdi isnan nadandan ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nganngani nan Fiestan di Linmaosan di Anghel ay mangnemneman di Judio isdin nangbadangan Apo Dios isdin alal-apoda id sang-adom isonga inmey da Jesus id Jerusalem ay makifiesta. ");
INSERT INTO xnn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dadat omey isnan Templo et datnganda nan men-ilaklako is baka, kalnilo ya kalapati ay awnit mapalti ay iboyag nan ipogaw ken Apo Dios. Wada gedan isdi nan mensoksokat is siping. ");
INSERT INTO xnn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dat somalapid si Jesus is saplit et abowena am-in san bakbaka ya kakalnilo ta bomalada danapay tokangen nan lamisaan di mensoksokatanda is siping et maiwakat san sipingda. ");
INSERT INTO xnn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Danat ibilin issan men-ilaklako is kalapati, “Ibalayo am-in dana. Ay inayan kayo pay, ay dakayon pabalinen ay pag-ilakowan nan baey Amak?” ");
INSERT INTO xnn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Dat nemnemen san papasolotna nan naisolat ay kalin Apo Dios id kasin ay naay, “Apo Dios, dadama nan sakit di nemnemko tay adida polos paayen nan baeymo.” ");
INSERT INTO xnn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gapo isnan inikkan Jesus isnan Templo dat kanan nan aap-apon di Judio, “Ngan di kaskasdaaw ay ikkam ta kail-ana ay waday kalintegam ay mang-ikkan isna?” ");
INSERT INTO xnn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Dat kanan Jesus, “No bakasenyo nan baey Apo Dios ay naay et pasagongek kasin isnan tolo ay agew.” ");
INSERT INTO xnn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dat kanan san deeyday Judio, “Aykeka makasaad kasin isna is tolo ay agew? Dapay epatpoo ya enem ay tew-en nan nasaadan nan Templo ay naay.” ");
INSERT INTO xnn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ngem nan baey Apo Dios ay kankanan Jesus et nan awakna. ");
INSERT INTO xnn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Isonga idi natey si Jesus dat kasin matago et ninemnem san papasolotna ay tinmet-ewa nan kinwanina dadat patiyen nan naisolat id kasin ay kalin Apo Dios ya din inbagan Jesus isnan awnitna katagowan. ");
INSERT INTO xnn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Issan kawad-an Jesus id Jerusalem ay makifiesta et adoado nan mamati ken siya tay inilada nan kaskasdaaw ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ngem getkena ay kolang kayet nan pammatida ken siya tay gegetkena nan kaipogawda ");
INSERT INTO xnn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","et adi masapol di waday mang-itdo ken siya maipanggep isnan ipogaw tay gegetkena nan nemnemda am-in. ");
INSERT INTO xnn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wada nan esay ap-apon di Judio ay Fariseo ay kangadan is Nikodemo. ");
INSERT INTO xnn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Isnan esay labi inmey ken Jesus et kanana, “Apo, getkenmi ay si Apo Dios nan nangibaa ken sik-a ay mangisolo ken dakami tay maiwed makaikkan isnan kaskasdaaw ay ik-ikkam malaksig no wada si Apo Dios ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Dat kanan Jesus, “Tet-etet-ewa nan ibagak ken sik-a, maiwed makasgep isnan mentolayan Apo Dios no adi maiyanak kasin.” ");
INSERT INTO xnn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dat kanan Nikodemo, “Ayke mabalin ay maiyanak kasin nan ipogaw ay naeteng? Ay daan di songgepana isnan eges inana esapay bomala kasin?” ");
INSERT INTO xnn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Dat kanan kasin Jesus, “Ibagak ken sik-a nan tet-ewa, adi mabalin ay maitapi nan ipogaw isnan mentolayan Apo Dios no adida maiyanak isnan danom ya Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nan iyanak nan ipogaw et awatena nan nangiyanak ken siya ay ipogaw. Et nan ipogaw ay iyanak nan Ispirito Santo et awatena abes nan nangiyanak ken siya ay Ispirito Santo isonga menbalinda ay an-ak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Isonga adika masdaaw no ibagak en masapol ay maiyanak kayo kasin. ");
INSERT INTO xnn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kaneg nan dagem et adi kaila ngem menpoypoyopoy isnan laylaydena. Dedengngem nan ngengena ngem adim getken nan magapgapowana ya nan omay-ayana. Siya na nan kaneg nan am-in ay maiyanak isnan Ispirito Santo.” ");
INSERT INTO xnn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Intoy ikakkana?” sinoot Nikodemo. ");
INSERT INTO xnn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Dat kanan Jesus, “Esaka ay nangato ay mangisolsolo ken datako ay Judio dakapay adi getken na? ");
INSERT INTO xnn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ibagbagak met nan tet-ewa ay getkek ya inilak ngem adiyo kayet patiyen nan kankanak. ");
INSERT INTO xnn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Inpagtekko nan maipanggep isnan wada isnan batawa ngem adiyo patiyen. Intoy ikkanyo ngalod ay mangpati no ibagak ken dakayo nan maipanggep isnan wada id daya? ");
INSERT INTO xnn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maiwed ipogaw is in-inmey id daya ay makaibaga isnan wada isdi nodi kedengak ay Iyon-an Am-in di Ipogaw tay nagapowak id daya. ");
INSERT INTO xnn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Et awnitak maipangato ay Iyon-an Am-in di Ipogaw ay kaneg din inikkan din si Moses ay nangilansa isnan sinang-oweg isnan sokod danat ipangato isnan kad-anda issan bilbilig tay masapol ay awnitak mailansa abes esakpay maipangato ");
INSERT INTO xnn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tasiyay am-in ay mamati ken sak-en et matagotagoda ay eng-enggana ken Apo Dios.” Siya di nan kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gapo tay dadama nan layad Apo Dios isnan ipogaw isnan batawa et inpaiyalina nan kedkedeng ay Anakna tasiyay am-in ay mamati ken siya et adida kadosdosa nodi matagotagoda ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tay egay inbaan Apo Dios nan Anakna ay mangpabasol ken datako ay ipogaw nodi ta isalakana datako ");
INSERT INTO xnn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","tay am-in ay mamati isnan Anakna et adida madosa ngem nan adi mamati et awnit madosada is maid patenggana tay adida patiyen nan kedkedeng ay Anak Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nan kapabasolanda et inmali nan silaw isnan batawa ngem pawedwed-en kayet nan ipogaw nan menbolinget mo nan menpat-a gapo isnan ngawi ay ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tay adyan nan mang-ik-ikkan is ngawi nan menpat-a isonga adida somag-en isnan silaw tay adida layden ay maila nan ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ngem nan mang-ik-ikkan isnan gawis et somag-enda isnan silaw tasiyay ipailada ay si Apo Dios nan mangbadbadang isnan gawis ay ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nakwas pay di dat omey si Jesus ya nan papasolotna isnan tap-in di ili isnan probinsiya ay Judea. Ninteeda isdi isnan nadandan ay agew et menbonbonyagda. ");
INSERT INTO xnn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan et menbonbonyag abes id Enon ay sag-en di Salim tay adoado nan danom isdi. Men-inonod nan ipogaw ay omey ken siya danat bonyagan daida. ");
INSERT INTO xnn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Egay pay naibalod si Juan issan deey ay menbonbonyagana. ");
INSERT INTO xnn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Issan esay agew et wada nan inmey ay nakisongbat isnan papasolot Juan maipanggep isnan bonyag ay kakaanan di basol. ");
INSERT INTO xnn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Isonga dadat omey ken Juan et kananda, “Apo, din ib-am issan demang di ginawang ay Jordan ay inbagam ken dakami et menbonbonyag id wani et siya nan omay-ayan am-in nan kaipoipogaw isonga atiatik nan omal-ali isna.” ");
INSERT INTO xnn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Dat kanan Juan, “Adi mensakit nan nemnemko olay no atiatik nan omali isna tay si Apo Dios nan mang-idya isnan kalebbengan di ipogaw ay ikkan. ");
INSERT INTO xnn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Dakayo met laeng nan mangpaneknek isdin kinwanik en bakenak si Kristo nodi inbaan Apo Dios sak-en ay mangipagtek ken siya tasiyay mamatida ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nan kaidiligana et kaneg nan mangisagana is omasawaan nan gayyemna. No omey nan lalaki isnan babai ay asawaena et dadama nan gasing nan gayyemna tay men-asawada tet-ewa. Et siya nan kanegko abes ay nangisagana isnan omaliyan Jesus isonga dadama nan gasingko tay inmali et siya. ");
INSERT INTO xnn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Et siya nan masapol ay maipawedweda dakpay maipababa.” ");
INSERT INTO xnn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nan magapo isnan batawa et ibatawa isonga nan getkena et nan maipanggep isnan batawa ngem nan magapo id daya et siya nan kangatowan isnan am-in. ");
INSERT INTO xnn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ibagbagana nan inil-ilana ya nan dindinngena ngem atiatik nan mangpati isnan kankanana olay no siya nan kangatowan. ");
INSERT INTO xnn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ngem nan mangidnge isnan ibagbagana et paneknekana ay tet-ewa nan kankanan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tay si Jesu Kristo ay inbaan Apo Dios et kankanana nan kalin Apo Dios tay inidyan Apo Dios nan am-in ay panakabalin di Ispirito Santo ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Si Apo Dios et laylaydena nan Anakna isonga inidyana nan kabaelana ta makigad isnan am-in. ");
INSERT INTO xnn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nan mamati isnan Anakna et matagotago ken Apo Dios ngem nan adi mamati et adi matagotago nodi dosaen Apo Dios ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nan Fariseo et mamaslatda issan nangdenganda ay adoado nan om-omey ken Jesus ay menpabonyag ay amed ad-ado mo nan om-omey ken Juan. ");
INSERT INTO xnn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ngem nan kinatet-ewana et egay ninbonbonyag si Jesus nodi kedeng nan papasolotna.) ");
INSERT INTO xnn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Idi gintek da Jesus ay mamaslat nan Fariseo dadat komaan id Judea et somagongda id Galilea ");
INSERT INTO xnn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","et nan daanda ay omey et isnan probinsiya ay Samaria. ");
INSERT INTO xnn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Kag-aw nan inomdananda id Sicar ay esay ili id Samaria ay sag-en di om-a ay inpatawid din si Jacob ken Jose ay anakna id sang-adom. Wada gedan isdi nan bobon din si Jacob. Nabbay si Jesus ay nindad-aan dat omey tomokdo isdi ");
INSERT INTO xnn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","dapay omey san papasolotna isnan ili ay lomako is kanenda. Dat wada nan somakdo ay babai ay iSamaria dat kanan Jesus ken siya, “Omyalika kad is inomek.” ");
INSERT INTO xnn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nasdaaw san babai issan kinwanin Jesus tay nan Judio et aamisenda nan iSamaria isonga danat kanan, “Judioka dakapay aped makiin-inom ken sak-en ay iSamaria?” ");
INSERT INTO xnn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dat kanan Jesus, “No getkem koma nan idyan Apo Dios ya no sinowak ay mangmangwani en painomem et ibagam koma tapno agtak sik-a isnan danom ay mang-idya is biyag.” ");
INSERT INTO xnn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dat kanan san babai, “Apo, maid met igaodmo dapay adaadaem nan naay ay bobon. Ay intoy apedmo mang-alaan is danom ay mang-idya is biyag? ");
INSERT INTO xnn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Inpatawid din alapo tako ay si Jacob nan naay bobon. Siya na nan sakdowanda isdin an-akna ya nan inmin-inoman din talakena. Ay kanam en nangatngatoka mo din si Jacob?” ");
INSERT INTO xnn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ngem dat kanan Jesus, “Nan mang-inom isnan danom ay naay et maewew kasin ");
INSERT INTO xnn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ngem nan mang-inom isnan idyak ay danom et adi kaew-ewew. Tay nan danom ay idyak et menbalin ay kaneg balaan ay adi katkatdok isnan awakna ay mang-idya ken siya is biyag ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dat kanan san babai, “Apo, iyalim ngalod nan sanay danom tasiyay adiyak kasin maew-ewew ya mabmabbay ay somakdo isna.” ");
INSERT INTO xnn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Dat kanan Jesus, “Enka ayagan si asawam dakayot omali isna.” ");
INSERT INTO xnn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Dat kanan san babai, “Dapay maid asawak.” Dat kanan Jesus, “Tet-ewa nan inbagam ay maid asawam. ");
INSERT INTO xnn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Namin limaka ay nakias-asawa et nan lalaki ay ibabaeymo id wani et bakenmo asawa. Tet-ewa nan inbagam.” ");
INSERT INTO xnn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dat kanan san babai, “Apo, mamadtoka obpay. ");
INSERT INTO xnn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ay into ngalod nan osto ay mangdayawan tako ken Apo Dios? Tay nan bilig ay naay nan nangdaydayawan di alal-apomi ay iSamaria ken siya ngem dakayo et kananyo en id Jerusalem nan kadayawan Apo Dios et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Dat kanan Jesus, “Patiyem nan kanak, awnit omdan nan timpo ay baken nan bilig ay naay ya baken gedan id Jerusalem is mangdaydayawan nan ipogaw ken Apo Dios ay Ama. ");
INSERT INTO xnn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Dakayo ay iSamaria et adiyo getken no sino nan daydayawenyo ngem dakami ay Judio et getkenmi nan daydayawenmi tay nagapo isnan Judio nan awnit mangisalakan. ");
INSERT INTO xnn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ngem inomdan nan timpo ay nan ikkan nan tet-ewa ay mangdayaw ken Apo Dios et dayawenda ay ostoosto isnan nemnemda ya isnan tet-etet-ewa ay pammatida tay si Apo Dios ay Ama et siya di nan laydena ay ikkan di mangdayaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Si Apo Dios et manakabalin ay adi kaila isonga olay no intoy kad-am et wada siya isonga masapol ay dayawenda siya isnan kinatet-ewa ya isnan osto ay nemnemda.” ");
INSERT INTO xnn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Dat kanan san babai, “Getkek ay awnit omali nan Mesias ay makwani en Kristo et awnit ipagtekna nan am-in ken datako.” ");
INSERT INTO xnn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dat kanan Jesus, “Nan kankanam ay awnit omali et sak-en ay makikalkali ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Daan ay makikalkali si Jesus dat domateng san papasolotna et nasdaawda tay dinatnganda siya ay makitoytoya isnan babai. Ngem maid makasoot no ngan di masapol san babai ya dan aped makitoytoya ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dat taynan san babai nan kalambana et somagong isnan ili danat kanan isnan kakailiyana, ");
INSERT INTO xnn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Akayo pod ta entako ilaen nan lalaki ay nangibaga isnan am-in ay inik-ikkak. Ay baken ngen siya di nan Kristo?” ");
INSERT INTO xnn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Isonga dadat menlobwat ay omey issan kad-an Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Issan kinmaanan san babai isnan kad-an da Jesus dat kanan san papasolotna ken siya, “Apo, aka ta manganka od.” ");
INSERT INTO xnn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ngem danat kanan, “Wada nan kanek ay adiyo getken.” ");
INSERT INTO xnn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dat men-asikwani san papasolotna, “Ay wada ngen di nangyali is kanena?” ");
INSERT INTO xnn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dat kanan Jesus, “Nan kanek et nan mangtongpalak isnan layden nan nangibaa ken sak-en ya nan mangkewasak isnan ipaoblana. ");
INSERT INTO xnn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Olay kananyo en epat pay ay bowan esapay aani ngem ibagak ken dakayo en mentamaang kayo et ilaenyo nan ado ay egay mamati ken Apo Dios tay kanegda pagey ay maani et. ");
INSERT INTO xnn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Dakayo ay mangisolsolo id wani nan kaneg nan men-ani et malagbowan kayo tay togopenyo nan nabgasan tapno waday biyagda ay maid patenggana. Nan nin-isolo id kasin et daida nan nintoned isonga maigiddanda ay makigasing ken dakayo ay men-ani. ");
INSERT INTO xnn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tay tet-ewa nan pangwanida id kasin en teken nan mentoned ya teken nan men-ani. ");
INSERT INTO xnn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ibaak dakayo ay men-ani isnan egayyo ninbannogan. Teken nan nangibannog ngem makilak-am kayo isnan ninbannoganda.” ");
INSERT INTO xnn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Adoado ay iSamaria nan namati ken Jesus issan deey ay ili gapo isnan nangwaniyan san babai en, “Inbagana ken sak-en nan am-in ay inik-ikkak.” ");
INSERT INTO xnn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Isonga inmeyda ken Jesus dadat ipapati ay makitee da Jesus ken daida dadat makitee is doway agew ");
INSERT INTO xnn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","et adoado pay nan namati ken siya gapo isnan insolsolona. ");
INSERT INTO xnn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kinwanida issan babai, “Mamati kami et baken gapo isnan inbagam nodi tay dinngemi abes nan kankanana et getkenmi ay siya tet-ewa nan mangisalakan isnan ipogaw isnan batawa tay idyana nan biyag ay maid patenggana.” ");
INSERT INTO xnn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nakwas nan doway agew dat komaan da Jesus id Samaria et omeyda isnan probinsiya ay Galilea. ");
INSERT INTO xnn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Id kasin kinwanin Jesus en, “Nan mamadto et adi maipateg isnan ilina,” ");
INSERT INTO xnn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ngem issan inomdanda id Galilea ay nasiknana dat dayawen obpay nan kailiyana siya tay issan inmayanda id Jerusalem issan Fiestan di Linmaosan di Anghel et inilada am-in nan inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dat omey da Jesus id Cana ay esay ili id Galilea ay din nangipabalinana is tapey nan danom. Id Capernaum et wada nan opisyal ay masaksakit nan anakna ay lalaki. ");
INSERT INTO xnn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Dinngena ay wada si Jesus id Galilea ay nagapo id Judea isonga dat omey menseg-ang ken siya ta ena koma pagawisen nan anakna ay matmatey. ");
INSERT INTO xnn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ngem dat kanan Jesus, “Ay adi kayo mamati no maid ilaenyo is kaskasdaaw?” ");
INSERT INTO xnn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dat kanan san opisyal, “Apo, pangaasim ta enta esapay matey nan anakko.” ");
INSERT INTO xnn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Dat kanan Jesus, “Somaaka tay ginmawis nan anakmo.” Pinatin san opisyal san inbagan Jesus dat somaa. ");
INSERT INTO xnn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Issan kawakgatana ay egay kayet omdan dat sab-aten nan baana ay mangibaga en ginmawis nan anakna. ");
INSERT INTO xnn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Danat sooten no tongona nan ginmawisana dadat kanan en, “Nabaew nan podotna issan nakwasan di kakan isnan kag-aw id kob-a.” ");
INSERT INTO xnn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nasdaaw siya tay ninemnemna ay siya di san osto ay nangwaniyan Jesus ken siya en, “Ginmawis nan anakmo.” Isonga dadat mamati ay sinbaey ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Siya na nan maikadwa ay kaskasdaaw ay inikkan Jesus id Galilea isnan nagapowana id Judea. ");
INSERT INTO xnn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nakwas pay di dat fiestan di Judio id Jerusalem isonga dat omey si Jesus ay makifiesta. ");
INSERT INTO xnn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wada nan pag-emsan isdi ay nginadnan di Judio is Betsaida isnan sag-en di segpan nan kakalnilo. Isnan bengetna et wada nan limay bawi ");
INSERT INTO xnn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ay mangipodpodanan nan adoado ay masaksakit ay kollaw, pilay ya nan napalalais (tay sedsed-enda nan menkiwiyan nan danom ");
INSERT INTO xnn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tay mamin ado kano ay lomayog isnan pag-emsan nan esay anghel et pakiwiyena nan danom et nan omon-ona ay manggatin isnan pag-emsan et gomawis kano nan kompolmi ay sakitna.) ");
INSERT INTO xnn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wada isdi nan lalaki ay nasasasakit is tolompoo ya wao ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Issan nang-ilaan Jesus ken siya ay nangipopodan isdi et gintekna ay nabayag ay nasasakit isonga danat kanan, “Ay laydem ay gomawis?” ");
INSERT INTO xnn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dat kanan san masaksakit, “Apo, maiwed od mangippey ken sak-en isnan pag-emsan no menkiwi nan danom tay no kanak en omeyak dat wada et nan epdas inmey.” ");
INSERT INTO xnn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dat kanan Jesus, “Bomangonka. Alaem nan abekmo ta mendaanka.” ");
INSERT INTO xnn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dat maganawis san mensakit danat alaen nan abekna et mendaan et. Sinabado ay obayan di Judio et issan agew ay deey et Sabado ");
INSERT INTO xnn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","isonga kinwanin nan aap-apon di Judio issan lalaki ay ginmawis, “Obaya id wani et lawaen nan linteg tako nan mangaawitam isnan abekmo.” ");
INSERT INTO xnn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Danat kanan, “Dapay inbagan san ipogaw ay nangipagawis ken sak-en en alaek nan abekko ta mendaanak.” ");
INSERT INTO xnn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dadat sooten ken siya, “Ay sino nan ipogaw ay sana ay nangwani issa?” ");
INSERT INTO xnn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ngem adi getken san lalaki san nangipagawis ken siya tay adoado nan ipogaw et kinmaan si Jesus ay egayda getken. ");
INSERT INTO xnn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Maaw-awni pay dat anapen Jesus san lalaki ay deey danat datngan siya isnan Templo danat kanan, “Ilam, ginmawiska et. Adika bomasbasol kasin modatya waday ommat ken sik-a is am-am-amed ngawi.” ");
INSERT INTO xnn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dat komaan san lalaki et ena ibaga issan aap-apon di Judio en si Jesus obpay nan nangipagawis isnan sakitna. ");
INSERT INTO xnn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gapo isnan naay et kaliligetda si Jesus tay inpagawisna nan masaksakit isnan obaya. ");
INSERT INTO xnn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Issan nang-ilaan pay Jesus ken daida danat kanan en, “Nan kananyo et no obaya datakot adi men-obla. Ngem si Apo Dios ay Amak, et adina isalsaldeng ay mang-ay-ayowan isnan ipogaw olay no obaya isonga masapol ay kaneg todi abes nan ikkak.” ");
INSERT INTO xnn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Isnan kinwanina ay naay et am-amed ginmege nan aap-apon di Judio ay mangwani en mangpatey ken siya tay baken kedeng di egayna nangtongpalan isnan lintegda isnan obaya nodi iyis-isona nan awakna ken Apo Dios ay mangwani en Amana siya. ");
INSERT INTO xnn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isonga dat kanan Jesus ken daida en, “Ibagak nan tet-ewa ken dakayo, sak-en ay Anak Apo Dios et maiwed mabalinko is ikkan no makekedengak nodi ikkak et kedeng nan ilaek ay ik-ikkan Ama. Tay am-in ay ik-ikkan Ama et siya abes nan ik-ikkak. ");
INSERT INTO xnn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tay si Ama et laylaydena sak-en ay Anakna isonga ipailana ken sak-en nan am-in ay ik-ikkana et awnitna ipaikkan ken sak-en nan am-amed kaskasdaaw no da tona isonga awnit kayo masdaaw. ");
INSERT INTO xnn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Si Ama et tagowena nan natey et siya abes nan ikkak ay Anakna tay agtak is biyag nan laydek ay agtan. ");
INSERT INTO xnn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tay baken si Ama is mangbanag isnan ipogaw nodi inyalina ken sak-en ay Anakna nan kalebbengak ay mangbanag isnan ipogaw ");
INSERT INTO xnn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tasiyay dayawenda am-in sak-en ay Anakna ay kaneg nan panangdayawda ken Ama. Nan adi mangpateg ken sak-en et adina gedan patgen si Ama ay nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Dat itoloy Jesus ay mangwani, “Ibagak nan tet-ewa, am-in ay mangidnge isnan ibagbagak ya mamati isnan nangibaa ken sak-en et matagotago ay eng-enggana ya adi kadosdosa. Napakawan et nan basbasolna isonga makitetee ken Apo Dios ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ibagak nan tet-ewa ken dakayo et kaneg nan natey nan kaipoipogaw tay maisisiyanda ken Apo Dios ngem enggana id wani et dengngenda nan kalik ay Anakna et nan mangidnge et awnit matagotagoda. ");
INSERT INTO xnn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tay si Ama nan kagapowan di biyag isonga inyalina nan kalebbengak ay mang-idya gedan is biyag. ");
INSERT INTO xnn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Inyalina gedan nan kalebbengak ay mangbanag isnan ipogaw tay sak-en nan Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Adi kayo masdaaw isnan inbagak tay awnit omdan nan timpo ay am-in ay natey et dengngenda nan kalik ");
INSERT INTO xnn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","et awnitda bomala isnan naipay-anda. Am-in ay gawis nan inik-ikkanda et awnit matagotagoda ay eng-enggana ken Apo Dios ngem nan ngawi nan inik-ikkanda et awnit maid patenggan nan dosada.” ");
INSERT INTO xnn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Dat itoloy Jesus ay mangwani, “No makekedengak et maiwed maikkak isonga kedeng nan ibagan Ama ken sak-en is banagek. Osto nan ikkak ay mangbanag isnan ipogaw tay baken nan laylaydek is ik-ikkak nodi kedeng nan layden Ama ay nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","No sak-en met laeng nan mangpanpaneknek isnan awakko et waay baken kapapati nan kankanak. ");
INSERT INTO xnn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngem si Ama nan mangpaneknek ken sak-en et getkek ay tet-ewa nan ibagana maipanggep ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wadada nan inbaayo ay inmey ken Juan et inbagana nan tet-ewa ay maipanggep ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Adiyak od masapol di ipogaw is mangpaneknek ken sak-en ngem apedko ipanemnem ken dakayo din inbagan Juan tasiyay mamati kayo koma daket agtan dakayo is biyag ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan et siya nan kaneg silaw ay menbidbidang tay tangtanggewana nan nemnem di ipogaw ngem apedyo ginanas is sin-awyan nan insolsolona. ");
INSERT INTO xnn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ngem wada nan mangpaneknek ken sak-en ay am-am-amed no si Juan. Nan naayday ik-ikkak ay ipaik-ikkan Ama et siya nan mangpaneknek isnan maipanggep ken sak-en ya mangipaila gedan ay si Ama nan nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Isonga si Ama ay nangibaa ken sak-en et siya gedan nan nangibaga isnan maipanggep ken sak-en ngem egayyo dindinnge nan kalina ya egayyo gedan inil-ila nan kanegna ");
INSERT INTO xnn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ya adiyo ipateg nan inbagana tay adiyo patiyen sak-en ay inbaana. ");
INSERT INTO xnn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Solsolowenyo nan kalin Apo Dios ay naisolat id kasin isnan liblo tay kananyo en no siya nan patiyenyo et matagotago kayo ay eng-enggana dapay sak-en nan kankanan san liblo. ");
INSERT INTO xnn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ngem dayon ngalod adyan ay mamati ken sak-en tapno matagotago kayo ay eng-enggana? ");
INSERT INTO xnn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Adiyak masapol nan dayaw di ipogaw ");
INSERT INTO xnn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","tay getkek nan gapo ay mang-adyanyo ken sak-en. Owen, tay maiwed layadyo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inmaliyak gapo isnan kalebbengan Ama ngem mang-adi kayo. Ngem no waday aped omali is teken ay wada nan kabaelana ay egay inbaan Apo Dios et siya nan dawatenyo. ");
INSERT INTO xnn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ayke kayo od mamati? Tay laydenyo ay mendindinayaw ngem adyanyo ay mang-ikkan is gawis tasiyay dayawen nan kedkedeng ay Dios ay si Apo Dios dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngem adiyo kanan en sak-en nan awnit mangpabasol ken dakayo ken Ama tay nan awnit mangpabasol ken dakayo et nan insolat din si Moses ay nangitalkanyo isnan namnamayo ay maisalakan. ");
INSERT INTO xnn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tay no pinatpatiyo din si Moses et patiyenyo abes sak-en tay din insolat Moses et sak-en nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ngem gapo tay adiyo patiyen nan insolsolatna, intoy ikkanyo ay mangpati isnan ibagbagak?” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nallos nan kaat ay agew dat gedangen da Jesus nan baybay ay Galilea ay makwani gedan en baybay ay Tiberias. ");
INSERT INTO xnn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Adoado nan ipogaw ay nang-onod ken siya gapo tay inilada nan kaskasdaaw ay inik-ikkana issan nangipagawisana isnan masaksakit. ");
INSERT INTO xnn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tinmikid si Jesus ya nan papasolotna isnan bilig dadat tomokdo. ");
INSERT INTO xnn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Issan deey ay timpo et nganngani nan kapatgan ay fiestan di Judio ay makwani en Linmaosan di Anghel. ");
INSERT INTO xnn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nintamaang si Jesus danat ilaen nan kaipoipogaw ay om-omey isnan kad-ana isonga danat kanan ken Felipe, “Ay into ngen lomakowan tako is kanen am-in nan ipogaw ay naayda?” ");
INSERT INTO xnn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Getken Jesus nan awnitna ikkan ngem apedna kinwani di ta ilaena no ngan nan ikkan Felipe. ");
INSERT INTO xnn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Dat kanan Felipe, “Isnan kaad-adoda et adi omanay nan kaat ay gasot ay pisos is mailako is tinapay ay kanenda olay no sin-at-ikenda ay mangpigpigas.” ");
INSERT INTO xnn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dat kanan nan esay pasolotna ay si Andres ay besat Simon Pedro, ");
INSERT INTO xnn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wada nan esay baballo ay kabaon is limay tinapay ya doway ikan. Ngem ayke omanay di isnan naayda ay kaipoipogaw?” ");
INSERT INTO xnn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dat kanan Jesus, “Kadya patokdowenyo daida.” Isonga dat tomokdo am-in san ipogaw isnan kaloglogaman isdi et waay limay libo nan lalalaki ay egay kaibilang nan bababai ya nan oongong-a. ");
INSERT INTO xnn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dat alan Jesus nan deeyday tinapay et men-iyaman ken Apo Dios danat ipawatwat isnan adoado ay tinmokdo. Siya di gedan nan inkana issan ikan et nanganda engganay nabsogda. ");
INSERT INTO xnn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Idi nabsogda am-in danat kanan isnan papasolotna, “Togopenyo nan binay-an ta maid makawas.” ");
INSERT INTO xnn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Isonga dadat togopen am-in san binay-anda issan limay tinapay et napno nan simpoo ya dowa ay lowa. ");
INSERT INTO xnn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Issan nang-ilaan san kaipoipogaw issan kaskasdaaw ay inikkan Jesus dadat kanan, “Waay siya na nan tet-ewa ay mamadto ay inbaan Apo Dios isnan batawa.” ");
INSERT INTO xnn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gintek Jesus ay ipapatida ay mang-ala ken siya ta menbalinenda ay alida isonga dat makekedeng ay omey isnan bilig. ");
INSERT INTO xnn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nagisbet pay dat lomayog san papasolotna issan baybay. ");
INSERT INTO xnn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nalabi et dapay maid kayet si Jesus isnan kad-anda isonga dadat menlogan isnan bangka et men-gedangda koma ay omey id Capernaum ");
INSERT INTO xnn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ngem dat domateng nan napigsa ay dagem et mendalloyon. ");
INSERT INTO xnn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Idi lima wenno enem ay kilometro nan nallosanda dadat ilaen si Jesus ay mendad-aan isnan danom ay omey isnan bangka daet palalo nan egyatda. ");
INSERT INTO xnn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ngem dat komali si Jesus ay mangwani en, “Adi kayo omegyat tay sak-en na.” ");
INSERT INTO xnn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dadat men-galalasing ay mangipalogan ken siya isnan bangka dadat maanedan isnan omayanda. ");
INSERT INTO xnn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Issan kawakgatana et wada kayet nan adoado ay ipogaw issan kad-an san nin-iyamanan Jesus ay nangananda is tinapay. Kananda en waay wada kayet si Jesus isdi tay inilada ay es-esang ay bangka nan ninloganan nan papasolotna dapay egay nakilogan si Jesus. Ngem idi inilada ay maiwed si Jesus wenno san papasolotna isdi dadat et menlogan isnan bangka tay wada nan tap-in di bangka ay nagapo id Tiberias dadat omey anapen siya id Capernaum. ");
INSERT INTO xnn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Issan nangdatnganan san kaipoipogaw ken Jesus issan demang di baybay dadat kanan ken siya, “Apo, ay tongona nan inmaliyam isna?” ");
INSERT INTO xnn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dat kanan Jesus, “Ibagak ken dakayo nan tet-ewa et mang-an-anap kayo gapo tay napnek kayo isnan tinapay ay kinanyo ay baken gapo tay naawatanyo nan kayat ay kanan nan kaskasdaaw ay inpailak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Adi kayo koma aped menligligat gapo isnan makan ay adi menbayag nodi anapenyo nan makan ay mang-ited isnan biyag ay maid patenggana. Sak-en ay Iyon-an Am-in di Ipogaw nan mang-idya ken dakayo isnan makan ay naay tay si Apo Dios ay Amak nan nangyali isnan kalebbengak.” ");
INSERT INTO xnn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Isonga dadat sooten, “Ngan pay nan ikkanmi ay mangtongpal isnan kayat Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Dat kanan Jesus, “Siya na nan layden Apo Dios ay ikkanyo, patiyenyo sak-en tay sak-en nan inbaana.” ");
INSERT INTO xnn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Dadat kanan, “Ngan ngalod di kaskasdaaw is ipailam tasiyay mamati kami ken sik-a? Ay ngan nan ikkam? ");
INSERT INTO xnn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tay din si Moses et pinakana din alal-apo tako isnan bilbilig is makan ay makwani en manna tay kanan nan naisolat id kasin ay kalin Apo Dios en, ‘Inagtana daida is makan ay nagapo id daya.’” ");
INSERT INTO xnn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Dat kanan Jesus, “Ibagak ken dakayo nan tet-ewa, baken si Moses is nang-idya isnan makan ay nagapo id daya nodi si Amak tay siya nan mang-idya isnan tet-ewa ay makan ay magapo id daya. ");
INSERT INTO xnn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Et nan makan ay idyan Apo Dios et siya nan magapo id daya ay mang-idya is biyag isnan kaipoipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Dadat kanan, “Apo, agtam kad dakami ay kanayon isnan sanay makan.” ");
INSERT INTO xnn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Dat kanan Jesus, “Sak-en nan makan ay mang-idya is biyag tay nan omali ay maitapi ya mamati ken sak-en et adi kaoowat ya adi kaew-ewew. ");
INSERT INTO xnn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngem ibagak kasin din kinwanik en olay no mang-il-ila kayo et adi kayo kayet mamati. ");
INSERT INTO xnn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Am-in nan ipogaw ay iyalin Ama ken sak-en et awnitda mamati ken sak-en. Et nan omali ken sak-en et adiyak polos ad-adyan. ");
INSERT INTO xnn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tay egayak nagapo id ngato ay omali ay mang-ikkan isnan laylaydek nodi nan layden nan nangibaa ken sak-en nan ikkak. ");
INSERT INTO xnn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Et siya na nan layden nan nangibaa ken sak-en ay ikkak, masapol ay aayewak ta maid maamas is olay esa isnan am-in ay inyalina ken sak-en nodi tagowek daida isnan kaodiyan ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tay siya na nan layden Amak, am-inda ay mangtek ya mangpati ay sak-en nan inbaan Apo Dios et agtak daida is biyag ay maid patenggana ken Apo Dios et sak-en nan mangtago ken daida isnan kaodiyan ay agew.” ");
INSERT INTO xnn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nan Judio et mamaslatda ken Jesus gapo isnan nangwaniyana en siya nan makan ay nagapo id daya. ");
INSERT INTO xnn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Dadat kanan, “Ay baken siya na si Jesus ay anak Jose? Getken tako da amana ken inana danat aped kankanan id wani en nagapo id daya?” ");
INSERT INTO xnn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Dat kanan Jesus, “Adi kayo men-ag-agotoot. ");
INSERT INTO xnn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maid makaali ken sak-en no adi paaliyen Ama ay nangibaa ken sak-en et siya nan awnitak tagowen isnan kaodiyan ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Insolat din deeyday mamadto en, ‘Am-in nan ipogaw et itdowan Apo Dios,’ ya nan am-in ay mangidnge ken Ama et daida nan omali ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngem adiyak kanan en waday nang-ila ken Ama tay maiwed nakaila ken siya nodi kedengak ay nagapo ken Apo Dios ay Amak. ");
INSERT INTO xnn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tet-ewa nan ibagak ken dakayo ay nan mamati ken sak-en et matagotago ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sak-en nan makan ay mang-idya is biyag. ");
INSERT INTO xnn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Din alal-apo tako et olay no kinanda nan makan ay manna isnan bilbilig ngem nateyda met laeng. ");
INSERT INTO xnn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ngem nan mangan isnan makan ay nagapo id daya et adi katkatey. ");
INSERT INTO xnn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sak-en nan makan ay nagapo id daya ay mang-idya is biyag. Et nan mangkakan isnan naay ay makan et maagtan is biyag ay eng-enggana. Nan awakko et siya nan makan ay idyak isnan ipogaw isnan batawa tasiyay matagotagoda.” ");
INSERT INTO xnn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dat mamaslat nan Judio dadapay men-asikwani en, “Into nan aped ikkan tosa ay mangiyali isnan awakna ta kanen tako?” ");
INSERT INTO xnn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dat kasin kanan Jesus, “Ibagak ken dakayo nan tet-ewa, no adiyo kanen nan awakko ya no adiyo inomen nan basak ay Iyon-an Am-in di Ipogaw et maiwed biyag ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tay nan mangkakan isnan awakko ya mang-inom isnan basak et daida nan matagotago ay eng-enggana ken Apo Dios et daida abes nan awnitak tagowen isnan kaodiyan ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tay nan awakko nan tet-ewa ay makan ya nan basak nan tet-ewa ay mainom. ");
INSERT INTO xnn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nan mangkakan isnan awakko ya mang-inom isnan basak et makitetee ken sak-en ya makiteteeak abes ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tay si Amak ay nangibaa ken sak-en et siya nan kagapowan di biyag isonga matatagowak gapo ken siya. Siya di nan kaneg nan mangkakan ken sak-en et matatago abes gapo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tay sak-en nan makan ay nagapo id daya ay baken kaneg din makan ay kinan din alal-apo tako id kasin dadat matey met laeng. Ngem nan mangkakan ken sak-en et matagotago ay eng-enggana ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Inbagan Jesus na issan nin-isolsolowana isnan sinagoga id Capernaum. ");
INSERT INTO xnn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Adoado nan naknakkey ken Jesus ay nangdedenge isnan inbagbagana ngem dadat kanan, “Adi kaokmon obpay nan naay isolsolona. Ayke ngen waday mangpati?” ");
INSERT INTO xnn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Olay no maiwed nangibaga ken Jesus et gegetkena nan kankananda isonga danat kanan ken daida, “Ay mensakit obpay nan nemnemyo gapo isnan naay? ");
INSERT INTO xnn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ngan ngen pay nan nemnemyo no ilaenyo sak-en ay Iyon-an Am-in di Ipogaw ay somagong id daya ay nagapowak? ");
INSERT INTO xnn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nan mang-idya is biyag et nan Ispirito et nan ipogaw et maid maikkana isonga no patiyenyo nan kankanak et idyan Apo Dios ken dakayo nan biyag ay maid patenggana. ");
INSERT INTO xnn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ngem wada kayet ken dakayo nan adi mamati.” Tay sigod ay getken Jesus nan adi mamati ya nan awnit mangisipsip ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Danat itoloy ay mangwani en, “Siya na nan gapo ay inbagak ken dakayo en maiwed makaali ken sak-en no adi paaliyen Ama.” ");
INSERT INTO xnn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Gapo isnan kinwanina et adoado nan kinmaan ay naknakkey ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Isonga danat kanan issan simpoo ya dowa ay pasolotna, “Dakayo pay, ay mangtaynan kayo abes?” ");
INSERT INTO xnn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Dat kanan Simon Pedro, “Apo, ay sinoy teken is omayanmi dapay sik-a nan mangibagbaga isnan kali ay mang-idya is biyag ay eng-enggana? ");
INSERT INTO xnn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Et id wani mamati kami et ay sik-a nan nasantowan ay inbaan Apo Dios ay mangisalakan.” ");
INSERT INTO xnn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dat kanan Jesus, “Sak-en nan nangpili ken dakayo ay simpoo ya dowa ngem wada kayet ken dakayo nan esa ay baan Satanas.” ");
INSERT INTO xnn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","San kankanana et si Judas ay anak Simon Iscariote tay siya nan awnit mangisipsip ken siya olay no esa siya ken daida ay simpoo ya dowa ay pasolotna. ");
INSERT INTO xnn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nakwas pay di dat kedeng id Galilea is sinolsol Jesus ay egay inmey id Judea tay getkena ay layden nan aap-apon di Judio isdi ay mangpatey ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nganngani nan fiestan di Judio ay makwani en Fiestan di Bawbawi ");
INSERT INTO xnn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","isonga dat ibagan nan bebsat Jesus ken siya en, “Komaanka isna ay Galilea ta omeyka id Judea ay kad-an di adoado ay ipogaw ");
INSERT INTO xnn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","tay no laydem ay mait-it-ek et baken isna ay teeteen ay ili is apedmo mentetean. Enka koma adi isnan dakkel ay ili tasiyay ilaen am-in nan ipogaw nan kaskasdaaw ay ik-ikkam.” ");
INSERT INTO xnn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kinwanida di tay olay bebsat Jesus daida et adida mamati ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Dat kanan Jesus ken daida, “Egay pay inomdan nan menpailaak id Jerusalem. Ngem dakayo, omey kayo tay ikkanyo nan laydenyo is olay ngan tosa ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Adi mabalin ay kaliliget nan adi mamati ken Apo Dios dakayo ngem kaliligetda sak-en tay ibagbagak ay ngawi nan ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Enkayo bawet makifiesta. Adiyak makkey tay egay inomdan nan menpailaak.” ");
INSERT INTO xnn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Inbagana na ken daida dat kayet mentetee id Galilea. ");
INSERT INTO xnn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Idi nallos san bebsatna ay omey makifiesta id Jerusalem dat abes omey si Jesus isdi ngem egayna inpagpagtek. ");
INSERT INTO xnn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nan aap-apon di Judio et an-anapenda siya issan pagfiestaan no into nan kad-ana. ");
INSERT INTO xnn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nan kaipoipogaw ay nadagop id Jerusalem et sodsodokenda si Jesus maipanggep isnan ik-ikkana. Wada nan mangmangwani en, “Siya et gawis ay ipogaw.” Ngem nan tap-ina kananda en, “Baken, tay sos-owitikena nan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ngem inyaammada nan kalida tay omegyatda ay dengngen nan aap-apon di Judio. ");
INSERT INTO xnn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nintenga pay nan fiesta dat omey si Jesus isnan Templo et men-isolo. ");
INSERT INTO xnn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nasdaaw nan aap-apon di Judio isnan laingna dadat kanan, “Dan aped adoado nan getken nan ipogaw ay naay dapay egay nin-adal?” ");
INSERT INTO xnn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Issan nangdengngan Jesus isnan kinwanida danat kanan, “Nan isolsolok et baken nan nemnemko is kagapgapowana nodi ken Apo Dios ay nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nan manglayad ay mang-ikkan isnan layden Apo Dios et getkena no sak-en nan kagapgapowan nan kankanak wenno si Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tay nan mangibagbaga isnan maipanggep isnan awakna et it-it-ekna nan awakna. Ngem nan manglayad ay mangidayaw isnan nangibaa ken siya et adi menlaslastog ya tet-ewa am-in ay kankanana. ");
INSERT INTO xnn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Inidyan din si Moses nan linteg ken dakayo ngem maiwed olay esa ken dakayo is mangtongpal isnan linteg tay dakayon kanan en mangpatey kayo?” ");
INSERT INTO xnn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dat kanan nan kaipoipogaw, “Maong-ong-ongka samet. Ay sinoy mangwani en pateyen dakaet en?” ");
INSERT INTO xnn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Dat kanan Jesus, “Isdin namingsan et naslat kayo tay Sabado nan nangpagawisak isnan masaksakit dapay obaya. ");
INSERT INTO xnn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ngem dakayo et segyatanyo nan an-akyo isnan maikawao ay agewna olay no Sabado ay obaya tapno tongpalenyo din inbilin Moses isnan kasegyatan di onga. (Ngem baken si Moses is nangibilin isnan kasegyatan di onga nodi din alal-apona.) ");
INSERT INTO xnn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","No segyatanyo nan onga isnan obaya tasiyay tongpalenyo nan linteg Moses dakayon aped mamaslat ken sak-en gapo isnan nangipagawisak isnan masaksakit isnan obaya? ");
INSERT INTO xnn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Adi kayo aped menpabpabasol gapo isnan il-ilaenyo et kedeng nodi nemnemenyo ay osto esakayopay menpabasol.” ");
INSERT INTO xnn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nan tap-in di iJerusalem et kinwanida en, “Ay baken kad si tona nan laydenda ay pateyen? ");
INSERT INTO xnn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ilaenyo. Menkalkali siya isnan kad-an nan kaipoipogaw dapay maid makasopyat ken siya. Ay getken ngen nan aap-apo tako ay siya tet-ewa nan Kristo ay inbaan Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ngem waay baken tay getken tako met am-in nan nagapowan tona ngem no omali si Kristo et maiwed mangtek kano is kagapowana.” ");
INSERT INTO xnn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ngem issan men-isolsolowan Jesus isnan Templo et inbibiyadna ay mangwani, “Kananyo kayman en mangtek kayo ya getkenyo nan nagapowak. Ngem adiyo getken adi tay bakenak is kanemnem ay aped inmali nodi wada nan nangibaa ken sak-en et siya nan tet-ewa ay nagapowak. Adiyo getken siya ngem ");
INSERT INTO xnn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","getkek siya tay siya nan nagapowak ya siya gedan nan nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Idi kinwanina di dat depapen koma nan aap-apon di Judio siya ngem egay inpalobos Apo Dios isonga egayda nakadpap ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ngem olay no kaneg todi et adoado kayet nan mamati ken siya dadat kanan, “Waay siya tet-ewa si Kristo. Tay no baken siya, ay wada ngen teken ay omali ay menpaila is am-amed kaskasdaaw mo nan inikkan tona?” ");
INSERT INTO xnn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dinngen nan Fariseo nan kankanan nan kaipoipogaw maipanggep ken Jesus isonga dat ibaan nan Fariseo ya nan aap-apon di papadi nan gogowaldiyan di Templo ta enda depapen si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ngem dat kanan Jesus, “Makiteeak ken dakayo is sin-awyan pay esakpay somagong isnan nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Et awnit kayo mang-an-anap ngem adi kayo makadateng tay nan omayak et adi kayo makaali.” ");
INSERT INTO xnn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Dat men-asikwani nan aap-apon di Judio en, “Ay into ngen nan awnitna omayan tasiyay adi tako datngan? Ay omeyna ngen isolowan nan baken Judio isnan il-ilida ay inmayan nan ib-a tako ay Judio? ");
INSERT INTO xnn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ay ngan ngen nan kayat ay kanan nan inbagana en awnit tako an-anapen siya ngem adi tako makadateng ya nan inbagana gedan en adi tako makaey isnan omayana?” kinwanida. ");
INSERT INTO xnn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nan kaodiyan ay agew isnan Fiestan di Bawbawi et siya nan kawedwedaan. Issan deey ay agew tinmakdeg si Jesus danat ibibiyad ay mangwani, “No sino nan maewew dat omali ken sak-en ta ominom. ");
INSERT INTO xnn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tay kanan nan naisolat ay kalin Apo Dios id kasin en, ‘Nan mamati ken sak-en et mawada ken siya nan kaneg balaan ay adi katkatdok ay mang-idya is biyag ay eng-enggana.’” ");
INSERT INTO xnn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nan kayat ay kanan nan inbagan Jesus et nan Ispirito Santo ay nganngani ay dawaten nan mamati ken siya ngem egay kayet naidya tay masapol ay somagong si Jesus isnan kadayawana id daya esapay maidya. ");
INSERT INTO xnn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nan tap-in nan nangdenge isnan naay ay inbagan Jesus et kinwanida en, “Tet-ewa obpay ay siya na nan mamadto ay sinsin-ed tako.” ");
INSERT INTO xnn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nan tap-ina et kananda en, “Siya na si Kristo ay inbaan Apo Dios.” Ngem nan tap-ina et kananda en, “Baken tay id Galilea nan nagapowana dapay baken kano isdi is kagapowan di Kristo. ");
INSERT INTO xnn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tay kanan nan kalin Apo Dios ay naisolat id kasin en magapo kano si Kristo isnan ap-on David et maiyanak id Betlehem ay ilin din si David.” ");
INSERT INTO xnn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Isonga nateketeken nan pangwanin nan kaipoipogaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nan tap-ina et kayatda ay depapen siya ngem maiwed nakaitoled is mangikawe ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","San gogowaldiyan di Templo et sinmagongda isnan aap-apon di papadi ya nan Fariseo dat sooten nan nangibaa ken daida en, “Dayon egay inyali siya no?” ");
INSERT INTO xnn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Dat kanan san gogowaldiya, “Kaskasdaaw od nan kankanana tay maiwed makaikkan isnan ikkana ay men-isolo.” ");
INSERT INTO xnn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Dat gilawen nan Fariseo daida ay mangwani, “Ay olay dakayo et naallilaw kayo gedan? ");
INSERT INTO xnn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayke kad waday ap-apo wenno Fariseo is mamati ken siya? ");
INSERT INTO xnn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nan sanaday ninkanenengneng et adida od getken nan linteg Moses isonga nayaw-awanda.” ");
INSERT INTO xnn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dat menkali nan esa ken daida ay si Nikodemo. Siya din inmey nakikali ken Jesus. Kinwanina ken daida en, ");
INSERT INTO xnn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kanan nan linteg tako en adi mabalin ay pabasolen tako nan ipogaw no adi tako somalyaen tasiyay getken tako nan inikkana.” ");
INSERT INTO xnn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dadat kanan ken siya, “Dakan aped badbadangan siya? Ay kailiyam siya ay iGalilea? Basaem kod nan kalin Apo Dios ay naisolat id kasin et awnit getkem ay maiwed polos mamadto is magapo id Galilea.” ");
INSERT INTO xnn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dadat somaa am-in. ");
INSERT INTO xnn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Inmey si Jesus isnan bilig ay Olivo ay omapa ");
INSERT INTO xnn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","dat issan kawakgatana et nasapa ay sinmagong isnan Templo dat alibongbongan nan ipogaw siya isonga danat itokdo et isolowana daida. ");
INSERT INTO xnn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dat iyey nan men-is-isolo isnan linteg ya nan Fariseo nan babai ay dinatnganda ay makiseyseyep isnan bakena asawa dadat patakdegen isnan sasagangenda am-in. ");
INSERT INTO xnn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Dadat kanan ken Jesus, “Mistolo, dinatnganmi nan naay babai ay makiseyseyep isnan bakena asawa dapay wada nan asawana. ");
INSERT INTO xnn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Isnan linteg tako et inbilin Moses en nan kaneg tona ay babai et masapol ay magayang ta matey. Ay ngan nan kanam?” ");
INSERT INTO xnn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kinwanida di tay kaytenda ay waday kanan Jesus is mangidalomanda ken siya. Ngem dat aped menyodong si Jesus et isolatna nan gomotna isnan lota. ");
INSERT INTO xnn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ngem kasasanootda od isonga dat tomakdeg si Jesus et kanana ken daida, “Nan maiwed ngalod basolna ken dakayo et siya nan omon-ona ay manggayang ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dat kasin menyodong et mensolat. ");
INSERT INTO xnn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Issan nangdengnganda isnan kinwanina dadat masonson ay komaan ngem nan kaam-amaan nan inmon-ona ay kinmaan. Et kedeng si Jesus ya san babai ay tinmatakdeg is nataynan isdi. ");
INSERT INTO xnn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tinmakdeg si Jesus danat kanan issan babai, “Ay into da todi? Ay maid nataynan is manggayang ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Maiwed, Apo,” kinwanin san babai. Dat kanan Jesus, “Olay sak-en et adiyak dosaen sik-a. Somaaka et ngem adika kasin menbasbasol.” ");
INSERT INTO xnn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kasin ninkali si Jesus isnan kaipoipogaw danat kanan, “Sak-en nan silaw ay mangtanggew isnan nemnem di ipogaw isnan batawa. Nan mamati ken sak-en dat mang-onod et matanggewan siya ta makaan nan menbolinget isnan nemnemna tasiyay maagtan is biyag ay maid patenggana.” ");
INSERT INTO xnn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Dat kanan nan Fariseo ken siya, “Kaneg baken kapapati nan ibagbagam tay sik-a met laeng nan mangpanpaneknek isnan awakmo.” ");
INSERT INTO xnn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Dat kanan Jesus, “Olay no sak-en nan mangpanpaneknek isnan awakko et tet-ewa nan kankanak. Tay gegetkek nan maipanggep ken sak-en dakpay getken nan nagapowak ya nan somagongak ngem dakayo et adiyo getken. ");
INSERT INTO xnn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aped kayo menpabpabasol gapo isnan maiila ay iilanyo. Sak-en et adiyak menpabpabasol ");
INSERT INTO xnn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ngem no pabasolek dakayo et tet-ewa nan ikkak ay mangipabasol tay bakenak kedeng nodi dowa kami ken Ama ay nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tay tet-ewa nan kanan nan lintegyo en no menpaliso nan kanan nan doway tistigo et mapati nan kananda. ");
INSERT INTO xnn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Et dowa kami ken Ama ay nangibaa ken sak-en ay mangpaneknek isnan awakko.” ");
INSERT INTO xnn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dadat sooten, “Ay into obpay di kad-an di amam is kankanam?” Dat kanan Jesus, “Adi kayo mangmangtek ya adiyo gedan getgetken si Ama. No mangmangtek kayo koma, getgetkenyo koma abes si Amak.” ");
INSERT INTO xnn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Inbagan Jesus am-in dana issan men-isolsolowana isnan mentetean nan maipaypay-an di siping isnan Templo. Ngem maid nangdepap ken siya tay egay pay inpalobos Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Intoloy kasin Jesus ay mangwani en, “No komaanak et awnit kayo mang-an-anap ngem adi kayo makadateng tay awnit kayo matey dapay egay kapakawan nan basbasolyo isonga adi kayo makaey isnan omayak.” ");
INSERT INTO xnn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Isonga nin-asikwani nan Judio, “Aytay ngen danan kanan en adi tako makadateng ken siya? Ay awnitna pateyen ngen nan awakna?” ");
INSERT INTO xnn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Dat kanan Jesus, “Ibatawa kayo od et maipanggep isnan batawa nan getkenyo et kedeng. Ngem sak-en et idayaak isonga nan maipanggep abes isnan daya nan ibagbagak. ");
INSERT INTO xnn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Isonga inbagak en awnit matey kayo dapay egay kapakawan nan basbasolyo et maisisisisiyan kayo ken Apo Dios no adi kayo mamati ay sak-en nan inbaana.” ");
INSERT INTO xnn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dadat sooten, “Ay sinoka obpay?” Dat kanan Jesus, “Kanayon ngalod ay ibagak ken dakayo enggana isdin damo ay nin-isolsolowak. ");
INSERT INTO xnn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","No maipanggep ken dakayo et adoado nan mabalin ay kanak ay mangipabasol ken dakayo ngem adiyak ikkan nodi nan ibagbagak isnan ipogaw isnan batawa et nan tet-ewa ay dengdengngek ay kankanan nan nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ngem daida egayda naawatan ay si Apo Dios ay Amana nan kinwanina ");
INSERT INTO xnn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","isonga dat kanan Jesus ken daida, “No ipangatoyo sak-en ay Iyon-an Am-in di Ipogaw isnan kros et siya nan mangtekanyo ay sak-en nan inbaan Apo Dios ya maiwed teken is ikkak nodi nan it-itdon Ama ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nan nangibaa ken sak-en et kanayon ay wada ken sak-en ay mangbadbadang tay adina taytaynan sak-en ay maeesa tay nan laydena et kedeng nan ik-ikkak.” ");
INSERT INTO xnn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Adoado ay Judio nan namati ken Jesus gapo isnan kinwanina ");
INSERT INTO xnn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","isonga danat kanan ken daida, “No patpatiyenyo nan isolsolok et dakayo nan tet-ewa ay papasolotko. ");
INSERT INTO xnn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Daket ipagtek nan tet-ewa ay maipanggep ken sak-en tasiyay mawayaan kayo.” ");
INSERT INTO xnn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Dadat kanan, “Ap-on din si Abraham dakami et enggana id kasin maiwed kabaa ken dakami. Damen aped kanan en awnit kami mawayaan?” ");
INSERT INTO xnn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Dat kanan Jesus, “Ibagak nan tet-ewa ken dakayo, am-in ay bomasol et baan di basol. ");
INSERT INTO xnn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nan baa et mabalin ay maipakaan isnan baey nan kabaa ken siya ngem nan anak et adi mabalin ay aped maipakaan isnan baey nan amana tay wada nan kalebbengana. ");
INSERT INTO xnn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ngem no sak-en ay Anak Apo Dios nan mangwaya ken dakayo isnan basol et mawayaan kayo tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Getkek ay ap-on din si Abraham dakayo ngem laydenyo pay laeng ay mangpatey tay adiyo patiyen nan isolsolok. ");
INSERT INTO xnn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Isolsolok nan inpailan Amak ken sak-en ngem dakayo et nan ik-ikkanyo et nan ibagbagan amayo.” ");
INSERT INTO xnn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Dadat kanan, “Dapay si Abraham din amami.” Dat kanan Jesus, “No tet-ewa ay an-ak Abraham dakayo et ikkanyo koma nan kaneg nan inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngem dakayon aped layden ay mangpatey dapay sak-en nan mangibagbaga ken dakayo isnan tet-ewa ay dinngek ken Apo Dios? Maiwed kaneg tosa is inik-ikkan din si Abraham nodi ");
INSERT INTO xnn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","nan ogaliyo et kaneg nan ogalin amayo.” Dadat kanan, “Baken kami nailistog tay es-esa nan Amami ay si Apo Dios et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Dat kanan Jesus, “No tet-ewa ay amayo si Apo Dios et manglaylayad kayo koma tay naayak ay nagapo ken siya. Egayak aped inmali nodi inbaana sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngem aytay dayon adi maawatan nan kankanak? Owen, gapo tay totowengenyo nan ibagbagak. ");
INSERT INTO xnn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dakayo nan an-ak Satanas ay amayo isonga laydenyo ay mangtongtongpal isnan laydena. Enggana isdin damo et ninpatpatey siya. Maiwed tet-ewa is kankanana tay siya di nan sigod ay ogalina ay menlaslastog. Isonga siya nan kagapowan nan am-in ay kinalastog. ");
INSERT INTO xnn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Siya na nan gapo ay adi kayo mangpati olay no ibagak nan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ay wada ken dakayo di mangpaneknek en binmasolak? Maid tay maiwed basolko. Isonga no ibagak nan tet-ewa, dakayon pay adi mangpati? ");
INSERT INTO xnn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nan an-ak Apo Dios et idngeda nan ibagbagana. Ngem nan gapo ay adiyo idnge siya et tay bakena an-ak dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dat kanan nan deeyday Judio ken Jesus, “Tet-ewa nan kananmi en iSamariaka tay ap-aposem dakami ay Judio. Waay obpay naan-anitowanka.” ");
INSERT INTO xnn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ngem dat kanan Jesus, “Egayak kaan-anitowan. Patpatgek si Amak ngem aped ngawi nan kankananyo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Adiyak oman-anap is mangdaydayaw ken sak-en ngem si Apo Dios ay mangbanbantay ken sak-en et siya nan mangpaneknek ay gawisak. ");
INSERT INTO xnn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngem ibagak nan tet-ewa ken dakayo ay nan mangtongpal isnan ibagbagak et adi katkatey.” ");
INSERT INTO xnn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Dat kanan nan Judio, “Id wani getkenmi ay tet-ewa ay naan-anitowanka. Tay din si Abraham ya din mamadto et nateyda id sang-adom dakapay aped kanan en adi katkatey di mangtongpal isnan kalim? ");
INSERT INTO xnn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Natey din napateg ay alapo tako ay si Abraham ya din mamadto. Ay kanam en nangatngatoka no daida? Ay sinoka et en?” ");
INSERT INTO xnn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Dat kanan Jesus, “No idaydayawko nan awakko et maiwed silbina. Nan mangidayaw ken sak-en et si Amak ay apedyo kankanan en Diosyo. ");
INSERT INTO xnn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngem adiyo getken siya. Sak-en pay et getkek tay no kanak en adiyak getken et kampotanak ay kanegyo. Ngem tet-ewa ay getkek siya isonga tongtongpalek nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Men-gasing din si Abraham ay alapoyo tay kanana en awnit mang-ila isnan omaliyak et id wani men-galalasing tay nang-ila.” ");
INSERT INTO xnn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Dat kanan nan Judio, “Maiwed pay limampoo is tew-enmo damet aped kanan en inilam si Abraham?” ");
INSERT INTO xnn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Dat kanan Jesus, “Ibagak nan tet-ewa ken dakayo, nawadaak esapay naiyanak si Abraham.” ");
INSERT INTO xnn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dadat menpidit is bato ay igayangda koma ken siya ngem dat itabonan Jesus daida et komaan isnan Templo. ");
INSERT INTO xnn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Issan mendad-aanan Jesus et inilana nan esay lalaki ay naiyanak ay kowap. ");
INSERT INTO xnn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dat sooten nan papasolotna ken siya, “Apo, ay sino nan kabasol isnan naiyanakana ay kowap? Ay siya ngen wenno nan makin-anak?” ");
INSERT INTO xnn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ngem dat kanan Jesus, “Nan nakowapana et baken gapo isnan basbasolna wenno nan makin-anak. Nakowap siya tasiyay maipaila nan panakabalin Apo Dios isnan mangpagawisana ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Masapol ay ikkan tako nan ipaik-ikkan nan nangibaa ken sak-en tay daan ay kag-aw et wada pay laeng nan waya tako. Tay no matey tako et maiwed mabalin is ikkan tako ay kaneg nan labi ay adi tako men-obla. ");
INSERT INTO xnn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Et isnan kawad-ak isnan batawa et sak-en nan silaw ay mangtanggew isnan nemnem di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kinwanina di dat mentobba isnan lota danat pekken et ipoklatna isnan matan san kowap ");
INSERT INTO xnn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","danapay kanan, “Enka mendaop isnan pag-emsan id Siloe.” (Nan kayat ay kanan nan Siloe et naibaa.) Isonga dat omey mendaop san lalaki dat makaila et ay somaa. ");
INSERT INTO xnn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ilaen pay nan sag-ogongna ya nan nang-il-ila ken siya isdin menlimlimosana dadat kanan, “Ay baken si tona din tomotototokdo isna ay menlimlimos?” ");
INSERT INTO xnn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nan tap-ina et kananda en, “Owen, siya si tosa,” ngem nan tap-ina et kananda en, “Baken. Ngem kanekanegna et kedeng.” Isonga dat kanan san lalaki, “Owen, tet-ewa ay sak-en din menlimlimos.” ");
INSERT INTO xnn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dadat sooten, “Dakan aped makaila? Ay into nan inkakkam ay ginmawis?” ");
INSERT INTO xnn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Danat kanan, “Nan kangadan is Jesus et inlaokna nan tobbana isnan lota danat ipoklat isnan matak danat kanan en omeyak mendaop id Siloe isonga daket omey et issan nakadaopak daket tet-ewa makaila.” ");
INSERT INTO xnn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Into pay nan kad-ana?” sinootda. Danat kanan, “Adiyak getken.” ");
INSERT INTO xnn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","15","Dadat eyey san ginmawis ay kowap isnan deeyday Fariseo. Dat sooten nan Fariseo nan inkakkan nan matana ay ginmawis. Danat kanan, “Pinoklatana nan matak is lota daket mendaop daket makaila.” San agew ay nangsapowan Jesus isnan lota danat iyagas isnan matan san kowap et Sabado ay obayan di Judio ");
INSERT INTO xnn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","isonga kinwanin nan tap-in di Fariseo en, “Nan nang-ikkan isna adi et egay kagapo ken Apo Dios tay adina tongpalen nan linteg di obaya.” Ngem nan tap-ina et kananda baw en, “Ayke makaikkan di managbasol is kaskasdaaw ay kaneg nan naayda?” Dadat mensinopyat am-in. ");
INSERT INTO xnn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Isonga dat kanan kasin nan Fariseo issan lalaki, “Kanam en inpagawisna nan matam. Et ngan ngalod nan pangwanim ken siya?” “Siya et mamadton Apo Dios,” kinwanina. ");
INSERT INTO xnn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ngem san deeyday aap-apon di Judio et adida patiyen ay kowap siya dat makaila isonga dadat paayagan da amana ");
INSERT INTO xnn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","et sootenda, “Ay si todi san anakyo? Ay tet-ewa ay kowap isdin naiyanakana? Dan aped makaila id wani no?” ");
INSERT INTO xnn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Dat kanan da amana, “Owen, anakmi di et tet-ewa ay kowap isdin binmalaana. ");
INSERT INTO xnn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ngem maipanggep isnan makailaana id wani et adimi getken no ngan nan inikkana ya no sino nan nangpagawis isnan matana. Sootenyo baw ken siya tay naetngan met siya et getkena nan kankanana.” ");
INSERT INTO xnn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Siya di nan kinwanida tay omegyatda isnan aap-apon di Judio tay kananda en no sinoy mangwani en si Jesus nan Kristo ay inbaan Apo Dios et adida ipalobos ay maitapida isnan sinagoga. ");
INSERT INTO xnn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Isonga siya na nan gapo ay kinwanin da amana en sootenda ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Dat kasin paayagan san Fariseo san lalaki et kananda en, “Isapatam ngalod ken Apo Dios en inbagam nan tet-ewa tay getkenmi ay managbasol nan nangpagawis ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Dat kanan san lalaki, “Adiyak getken no managbasol siya. Basta nan getkek et kowapak daket makaila.” ");
INSERT INTO xnn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dadat sooten, “Ngem ngan nan inkana ay nangipagawis isnan matam?” ");
INSERT INTO xnn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Danat kanan, “Inbagak et ngalod ken dakayo ngem adiyo patiyen. Dayon layden ay dengngen kasin? Ay laydenyo abes ay menbalin ay pasolotna?” ");
INSERT INTO xnn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Iniyawda siya ay mangwani en, “Sik-a adi nan pasolotna tay papasolot Moses dakami. ");
INSERT INTO xnn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Getkenmi ay makikalkali si Apo Dios ken Moses ngem nan ipogaw ay deey et adimi pay getken no intoy nagapowana.” ");
INSERT INTO xnn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dat kanan san lalaki, “Katakatataa obpay sa. Adiyo obpay getken nan nagapowana danapay inpagawis nan matak. ");
INSERT INTO xnn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Getken tako met ay adi id-idngen Apo Dios nan kankanan di managbasol ngem idngena nan mangdaydayaw ken siya ya nan mang-ikkan isnan laydena. ");
INSERT INTO xnn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Enggana isdin naboliwan nan batawa et maiwed nadnadnge is nangipagawgawis is naiyanak ay kowap. ");
INSERT INTO xnn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","No egay kagapo ken Apo Dios et adi koma makaikkan isna.” ");
INSERT INTO xnn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Dadat kanan, “Naiyanakka ay managbasol dakapay aped isolsolowan dakami?” Dadat pakaanen siya. ");
INSERT INTO xnn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Issan nangdengan Jesus ay inpakaanda san lalaki danat anapen siya et kanana, “Ay mamatika isnan Iyon-an Am-in di Ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dat kanan san lalaki, “Apo, ibagam od no sino siya tasiyay mamatiyak ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Dat kanan Jesus, “Siya nan iilaem ay makikalkali ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Mamatiyak et ken sik-a, Apo,” kinwanin san lalaki dat menpalintomeng ay mangdayaw ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dat kanan Jesus, “Inmaliyak isnan batawa tasiyay mailasinan nan mamati ya adi mamati ken Apo Dios. Nan adi mamati ken Apo Dios et kanegda kowap ngem awnitak pagawisen daida no mamatida. Ngem nan aped mangmangwani en makailada tay getkenda kano si Apo Dios et daida nan kowap.” ");
INSERT INTO xnn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nan tap-in di Fariseo ay wada isdi et dinngeda san kinwanina dadat sooten, “Ay kanam en kowap kami abes?” ");
INSERT INTO xnn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Dat kanan Jesus, “No getkenyo koma ay kowap kayo et pagawisen Apo Dios dakayo tasiyay mangpatiyanyo ken siya ta adina pabasolen dakayo. Ngem gapo tay apedyo kankanan en getkenyo si Apo Dios isonga siya nan mangipabasolana ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dat menpangngalig si Jesus ay mangwani en, “Ibagak nan tet-ewa ken dakayo, nan ipogaw ay mangsakyat isnan baked kakalnilo ay baken nan segpana is segpena et mangakew. ");
INSERT INTO xnn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tay nan mang-ay-ayowan isnan kakalnilo et kedeng nan segpan is segsegpena ");
INSERT INTO xnn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","tay wada nan mangbanbantay isnan segpan ay mangtokab isnan eneb no songgep nan mang-ay-ayowan isnan kakalnilo. No ayagana nan ngadngadan nan kalnilona et gegetkenda nan kalina danat ipabala daida. ");
INSERT INTO xnn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","No inpabalana daida dat mang-on-ona et onoden nan kakalnilona siya tay imamatonanda nan kalina. ");
INSERT INTO xnn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Adida aped omon-onod isnan teken ay ipogaw nodi itagtaganda tay adida getken nan kalina.” ");
INSERT INTO xnn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sinodok Jesus di ken daida ngem egayda naawatan nan kayat ay kanan nan ibagbagana ken daida ");
INSERT INTO xnn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","isonga dat kasin kanan Jesus, “Ibagak nan tet-ewa ken dakayo, sak-en nan kanega segpan di pokokan di kalnilo. ");
INSERT INTO xnn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngem am-in ay inmal-ali esakpay omali et kanegda mangakew tay baken tet-ewa nan insolsoloda. Ngem nan mamati ken sak-en et egayda id-idnge daida ");
INSERT INTO xnn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","tay sak-en nan segpan et am-in ay omali ken sak-en et awnitak isalakan daida et kanegda nan kalnilok ay songsonggep ya bomalbala ay mangmangan is gawis ay menkatagoda. ");
INSERT INTO xnn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nan mangakew et aped omali ta men-akew, menpalti ya mendadael et kedeng ngem inmaliyak tasiyay agtak nan ipogaw is gawis ay biyag et siya na nan biyag ay maid kolangna ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Dat itoloy Jesus ay mangwani, “Sak-en nan kagawisan ay mangbanbantay isnan kakalnilo. Nan gawis ay menbanbantay et olay matey gapo is ayyewna isnan kalnilona. ");
INSERT INTO xnn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ngem nan malaglagbowan ay menbanbantay et taynana nan kalnilo no waday ilaena is dakkel ay atap ay aso ay omala is isdana isnan banbantayana tay bakena kowa daida. Isonga isdan san atap ay aso nan tap-ina danapay patagtagen nan tap-ina ta mabokada. ");
INSERT INTO xnn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Siya nan gapo ay lomayaw nan menbanbantay tay aped malaglagbowan et kedeng isonga adina paayen nan kalnilo. ");
INSERT INTO xnn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngem sak-en nan kagawisan ay menbanbantay tay nan ikkanmi ken Ama ay men-gin-ginetek et siya nan kaneg nan kalnilok tay getkek daida ya mangtekda abes. Et olay mateyak basta matago nan kalnilok. ");
INSERT INTO xnn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wada pay nan tap-in di kalnilok ay egay naitatapi isnan naayda ay naipopokok et masapol ay iyalik daida isna ta idngeda abes nan kalik tasiyay maaam-inda ya ta maeesa nan mangbanbantay ken daida. ");
INSERT INTO xnn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Laylayden Ama sak-en tay ikkak nan laydena ay olay siya nan kateyak tapno matagowak kasin. ");
INSERT INTO xnn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maiwed makapatey ken sak-en no adiyak ipalobos tay sak-en et kedeng nan kalebbeng isnan kateyak ya sak-en gedan nan kalebbeng isnan matagowak kasin. Siya na nan inbilin Ama ay ikkak,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nan deeyday Judio et ninsisinopyatda kasin gapo isnan kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Adoado nan mangmangwani en, “Matawtawaw siya tay naan-anitowan. Dayon aped dengdengngen nan kankanana?” ");
INSERT INTO xnn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngem nan tap-ina et kankananda en, “Nan naan-anitowan et adi makakali is kaneg tona. Ayke kad makaipagawis di anito is kowap?” ");
INSERT INTO xnn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Isnan pinagtedek et siya nan Fiestan di Daton id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Wada si Jesus issan fiesta et mendad-aan isnan makwani en Bangsal Solomon isnan Templo ");
INSERT INTO xnn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","dat likoben nan Judio siya et kananda, “Tongona pay nan mangibagaam isnan tet-ewa ken dakami? Ibagam kad no sik-a nan Kristo ay inbaan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dat kanan Jesus, “Inbagak et ken dakayo ngem adi kayo mangpati. Nan ik-ikkak gapo isnan panakabalin Ama et siya dana nan mangipagpagtek ken sak-en ");
INSERT INTO xnn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ngem adi kayo mamati tay bakenko kalnilo dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tay nan kalnilok et idngeda nan kalik ya getkek gedan daida isonga mang-on-onodda. ");
INSERT INTO xnn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Agtak daida is biyag ken Apo Dios ay eng-enggana et adida maisis-iyan ken siya ya maiwed makagowad ken daida ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Si Ama nan nangyali ken daida ken sak-en et siya nan kangatowan isnan am-in isonga maiwed makagowad isnan banbantayana. ");
INSERT INTO xnn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Dakami ken Ama et es-esa kami.” ");
INSERT INTO xnn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dat kasin menpidit nan Judio is bato ta igayangda koma ken siya ");
INSERT INTO xnn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","isonga dat kanan Jesus, “Ngan nan gapo ay manggayang kayo? Adoado nan gawis ay inpail-ilak ken dakayo ay inpaik-ikkan Ama et into isnan naayda nan gapo ay manggayanganyo?” ");
INSERT INTO xnn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Dat kanan nan Judio, “Adimi gayangen sik-a gapo isnan gawis ay inik-ikkam nodi nan mangiyiisowam isnan awakmo ken Apo Dios dakapay aped ipogaw et kedeng.” ");
INSERT INTO xnn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Dat kanan Jesus, “Ngem naisosolat isnan liblo isnan kalin Apo Dios ay mangwani en, ‘Kaneg kayo dios gedan.’ ");
INSERT INTO xnn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Isonga kinwanina en dios din aap-apoyo ay nangisolsolowana isnan linteg id sang-adom et adi mabalin ay sokatan tako din kinwanin Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sak-en nan pinilin Ama ay inbaana isnan batawa isonga dayon aped kanan en ap-aposek si Apo Dios gapo isnan nangwaniyak en sak-en nan Anakna? ");
INSERT INTO xnn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No baken nan ipaik-ikkan Ama is ik-ikkak et adiyo koma patpatiyen sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngem no nan ipaikkan Ama nan ik-ikkak et olay no adiyo patiyen nan kankanak et patiyenyo koma nan gawis ay inik-ikkak tasiyay getkenyo ay tet-ewa ay wada si Ama ken sak-en ya wadaak abes ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kananda kasin en depapenda siya ngem danat men-ikolipet ay komaan. ");
INSERT INTO xnn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dat kasin somagong si Jesus isnan demang di ginawang ay Jordan ay ninbonbonyagan Juan et mentee isdi. ");
INSERT INTO xnn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Adoado nan ipogaw ay inmey ken siya dadat men-asikwani, “Maiwed kaskasdaaw is inik-ikkan Juan ngem tet-ewa nan am-in ay inbagbagana maipanggep ken Jesus.” ");
INSERT INTO xnn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Et adoado nan namati ken siya isdi. ");
INSERT INTO xnn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Wada id Betania ay ili id Judea nan tolo ay sin-ag-i ay kangadan is Maria, Marta, ya Lazaro. Si Maria ay naay et siya nan nangibokbok isnan menbango ay lana isnan sikin Apo Jesus danapay iponas nan bookna. Ninsakit si Lazaro ");
INSERT INTO xnn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","dat omibaa da Maria ken Marta is omey mangibaga ken Jesus en, “Apo, nan gayyemmo ay laylaydem et mensaksakit.” ");
INSERT INTO xnn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Issan nangdengan Jesus isna danat kanan, “Nan sakit Lazaro et adina ikatey nodi ta maipaila nan panakabalinko ta madaydayaw si Apo Dios ya sak-en abes ay Anakna.” ");
INSERT INTO xnn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Si Jesus et laylaydena san tolo ay sin-agi ");
INSERT INTO xnn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ngem issan nangdengngana ay mensaksakit si Lazaro dat mentee kayet issan kad-ana is doway agew ");
INSERT INTO xnn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","danat kanan isnan papasolotna, “Somagong tako id Judea.” ");
INSERT INTO xnn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dadat kanan, “Apo, egay nabayag din manggayangan koma nan Judio ken sik-a dakat aped kasin somagong isdi?” ");
INSERT INTO xnn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ngem dat kanan Jesus, “Olay, tay simpoo ya dowa ay olas nan sin-agew isonga wada pay nan waya tako ay mang-ikkan isnan ikkan tako. Kanegna nan mendad-aanan nan ipogaw isnan kag-aw et adi maisagaw tay menpat-a ");
INSERT INTO xnn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ngem no mendad-aan isnan labi et maisagaw tay menbolinget.” ");
INSERT INTO xnn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Dat itoloy Jesus ay mangwani, “Nan gayyem tako ay si Lazaro et naseyep ngem omeyak ay manggido.” ");
INSERT INTO xnn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Dat kanan nan papasolotna, “Apo, gawis no naseyep tay awnit gomawis.” ");
INSERT INTO xnn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kananda en waay tet-ewa ay naseseyep si Lazaro ngem nan kayat Jesus ay kanan et natey et ");
INSERT INTO xnn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","isonga danat kanan, “Natey si Lazaro ");
INSERT INTO xnn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ngem men-gasingak tay maiwedak isnan kad-ana isnan nateyana tasiyay pomigsa nan pammatiyo no ilaenyo nan ikkak. Entako bawet ilaen siya.” ");
INSERT INTO xnn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas ay makwani en Ipi et kinwanina isnan iib-ana ay pasolot en, “Makkey tako ken Jesus id Judea ta olay no maitapi tako ken siya ay matey.” ");
INSERT INTO xnn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Issan inomdanan da Jesus id Betania et dinatnganda ay epdas naikaob si Lazaro is epat ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Toloy kilometro nan kaad-addawina id Jerusalem ");
INSERT INTO xnn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","isonga adoado nan Judio ay inmey nangliwliwaliw ken da Marta ken Maria gapo isnan nateyan nan besatda. ");
INSERT INTO xnn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Issan nangdengan Marta ay omal-ali si Jesus danat omey sab-aten siya ngem si Maria et nataynan isnan baeyda. ");
INSERT INTO xnn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dat kanan Marta ken Jesus, “Apo, no wadaka isna et egay koma katey nan besatko. ");
INSERT INTO xnn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ngem getkek ay olay id wani et idyan Apo Dios ken sik-a nan dawatem ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Dat kanan Jesus, “Awnit matago san besatmo.” ");
INSERT INTO xnn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Dat kanan Marta, “Owen tay getkek ay awnit matago siya isnan katagowan kasin di am-in ay natey isnan kaodiyan ay agew.” ");
INSERT INTO xnn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dat kanan Jesus, “Sak-en nan mangtago isnan natey tay sak-en nan mang-idya is biyag. Am-in ay mamati ken sak-en olay no matey et awnit matago kasin ");
INSERT INTO xnn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","et daida ay matatago gapo isnan pammatida ken sak-en et adida kaisis-iyan ken Apo Dios. Ay patiyem na?” ");
INSERT INTO xnn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Danat kanan, “Owen, Apo. Mamatiyak ay sik-a nan sinsin-edmi ay omali isnan batawa ay si Kristo ay Anak Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kinwanin Marta di dat somaa et wag-eyena si Maria ta iyagasaasna ay mangwani, “Inmali nan Apo tako et paay-ayagana sik-a.” ");
INSERT INTO xnn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Issan nangdengan Maria isna danat ikakamo et ena sab-aten si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","San deeyda ay Judio ay wada isnan baey da Maria ay mangliwliwaliw ken siya et inonodda siya tay kananda en waay omey isnan naikaoban nan besatna ay men-aga. Ngem baken obpay is inmayana nodi issan kad-an Jesus tay egay kayet inomdan issan ili tay daan issan nangsab-atan Marta ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Inomdan pay si Maria issan kad-an Jesus dat menlokbob isnan sasagangena danapay kanan, “Apo, no wadaka isna et egay koma katey nan besatko.” ");
INSERT INTO xnn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Inilan Jesus ay men-ag-aga siya ya nan Judio ay nakkey ken siya dat dadama nan seg-angna ");
INSERT INTO xnn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","danat sooten, “Ay into nan nangikaobanyo ken siya?” Dadat kanan, “Apo, aka ta entako ilaen.” ");
INSERT INTO xnn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dat men-aga abes si Jesus ");
INSERT INTO xnn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","isonga dat kanan nan Judio, “Ilaenyo kod et dadama nan layadna ken Lazaro.” ");
INSERT INTO xnn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ngem nan tap-ina et kinwanida, “Inpagawisna met san kowap. Ay maid ngen mabalin is inkana tasiyay egay katey koma si Lazaro?” ");
INSERT INTO xnn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Inmam-amed nan seg-ang Jesus issan sinmag-enana isnan liyang ay naipay-an san natey ay naeemban is bato. ");
INSERT INTO xnn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Danat ibilin en, “Kaanenyo nan bato.” Ngem dat kanan Marta ay besat san natey, “Apo, adi tay menpeleleteg tay maikap-at ay agew id wani isnan naikaobana.” ");
INSERT INTO xnn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dat kanan Jesus ken siya, “Ay kinalingkingam nan inbagak en no mamatika et ilaem nan panakabalin Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dadat kaanen san bato dat mentangad si Jesus danapay kanan, “Ama, men-iyamanak tay id-idngem sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Getkek ay id-idngem sak-en ngem kanak na tasiyay nan mangdedenge ay naayda et mamatida ay sik-a nan nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kinwanina na danat ibibiyad ay mangwani en, “Lazaro, bomalaka.” ");
INSERT INTO xnn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dat bomala ay nabebedbedan nan ledengna ya sikina ya nakokomonan nan angasna is galot. Dat kanan Jesus, “Kaanenyo nan naibebedbed ken siya tasiyay makadaan ay gawis.” ");
INSERT INTO xnn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Adoado issan deeyday Judio ay inmey nangliwaliw ken da Maria et namatida ken Jesus issan nang-ilaanda isnan kaskasdaaw ay inikkana. ");
INSERT INTO xnn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ngem nan tap-ina et sinmagongda isnan Fariseo ta ibagada san inikkan Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Isonga nan Fariseo ya nan menkangangato ay papadi et inpadagopda nan aap-apon di Judio dadat kanan, “Ay ngan nan ikkan tako ken Jesus tay adoado nan kaskasdaaw ay ik-ikkana? ");
INSERT INTO xnn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","No adi tako pasaldengen nan ik-ikkana et mamati nan am-in ay ipogaw ken siya daet siya nan men-apoda et awnit omali nan menlelebbeng ay iRoma et bakasenda nan Templo ya nan il-ili tako.” ");
INSERT INTO xnn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ngem si Caifas ay kangatowan ay padi issan deey ay tew-en et kinwanina, “Maiwed polos getkenyo. ");
INSERT INTO xnn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ay adiyo getken en gawgawis no matey nan esa tapno matago nan kaipoipogaw isnan il-ili tako?” ");
INSERT INTO xnn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aped kinwanin Caifas di ay baken nan nemnemna is nagapowana ngem tay siya nan kangatowan ay padi isonga siya nan nangipanemneman Apo Dios en nganngani ay matey si Jesus ta kaanena nan basol di am-in ay Judio ");
INSERT INTO xnn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ngem bakenda kedeng ay Judio nodi nan am-in ay an-ak Apo Dios ay mamati ken siya ay naiwakat isnan batawa tasiyay maeesada. ");
INSERT INTO xnn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Enggana issan deey ay agew et ninemnemnem nan aap-apon di Judio nan ikkanda ay mangpatey ken Jesus ");
INSERT INTO xnn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","isonga egay ninpail-ila si Jesus ya nan papasolotna id Judea nodi inmeyda nintee isnan ili ay Efraim ay sag-en di bilig. ");
INSERT INTO xnn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nganngani nan Fiestan di Linmaosan di Anghel isonga adoado nan ipogaw ay nintikid id Jerusalem tasiyay ikkanda nan lintegda ay masapol ay men-emesda ta makaan nan dakes esapay omdan nan fiesta. ");
INSERT INTO xnn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Anaanapenda si Jesus et issan nadagopanda isnan Templo dadat men-asikwani, “Ay ngan nan kananyo? Ay omali ngata siya isnan fiesta?” ");
INSERT INTO xnn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ngem nan menkangangato ay papadi ya nan Fariseo et inbilinda en no waday mangtek isnan kad-an Jesus danat ibaga ken daida ta depapenda. ");
INSERT INTO xnn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Enem pay ay agew esapay menlogi nan fiesta dat omey si Jesus id Betania ay ilin Lazaro ay tinagona. ");
INSERT INTO xnn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nakikan da Jesus isnan insagsaganada ay makan et binmadang si Marta ay mangpakan ken daida dapay makioobong si Lazaro ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dat alaen Maria nan esay palanggo ay nangina ay menbango ay lana ay makwani en naldo et ibokbokna isnan sikin Jesus danat ponasan isnan bookna daet napno nan baey isnan bangon nan lana. ");
INSERT INTO xnn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ngem nan esay pasolot Jesus ay si Judas Iscariote ay awnit mangisipsip ken siya et kinwanina en, ");
INSERT INTO xnn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dan egay kitdi nailako nan lana ay naay is tolong gasot ta maidya isnan kodokdo?” ");
INSERT INTO xnn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kinwanina di ngem baken gapo tay isakitna nan kodokdo nodi tay siya nan manggegeen isnan sipingda et apedna gasgastowen no laydena tay siya di nan ogalina. ");
INSERT INTO xnn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ngem dat kanan Jesus, “Bay-am si Maria. Tay nan inikkana ken sak-en et insaganana nan awakko isnan awnitak maikaoban. ");
INSERT INTO xnn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Olay ket wawawawada nan kodokdo ay mabalin ay badanganyo ngem sak-en et adiyak makitetee ken dakayo ay eng-enggana.” ");
INSERT INTO xnn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dinngen nan adoado ay Judio ay wada si Jesus id Betania dadat omey isdi. Inmeyda ngem baken si Jesus et kedeng nan gapona nodi ta ilaenda si Lazaro ay tinagona. ");
INSERT INTO xnn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Isonga dat mentotolag nan deeyday menkangangato ay papadi ta pateyenda gedan si Lazaro ");
INSERT INTO xnn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tay isnan natagowana et adoado nan Judio ay naisiyan isnan aap-apoda ta mamatida ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Issan kawakgatana nan kaipoipogaw ay inmey makifiesta et dinngeda ay domatdateng si Jesus id Jerusalem ");
INSERT INTO xnn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","isonga dadat omala is lamos ay iyap-apda isnan daanen Jesus isnan enda mangsab-atan ken siya dadapay ibogbogaw ay mangmangwani en, “Hosanna. Madaydayaw nan naay Ali tako. Mabindisyonan nan inbaan Apo Dios ay omali mentolay ken datako ay Judio.” ");
INSERT INTO xnn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Si Jesus et mensasakay isnan anak di kabayo. Et siya nan katongpalan nan kalin Apo Dios ay naisolat id kasin ay naay, ");
INSERT INTO xnn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Dakayo ay iJerusalem, adi kayo omeg-egyat tay naay omal-ali nan Aliyo ay mensasakay isnan anak di kabayo.” ");
INSERT INTO xnn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nan papasolotna et egayda naawatan nan kayatna ay kanan ngem isnan sinmagongan Jesus id daya et siya nan nangnemnemanda isdin naisolat id kasin maipanggep ken siya tay tinmet-ewa ay naikkan ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nan nang-ila isdin nang-ayagan Jesus ken Lazaro isnan liyang ay nangtagowana ken siya et inpadamagda nan inommat. ");
INSERT INTO xnn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Siya di nan gapona ay adoado nan nangsab-at ken Jesus tay dinngeda nan inikkana ay kaskasdaaw. ");
INSERT INTO xnn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ngem nan Fariseo et nin-asikwanida kayet en, “Ilaenyo, maid maikkan tako tay omon-on-onod ken siya nan am-in ay ipogaw isnan batawa.” ");
INSERT INTO xnn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wadada nan baken Judio ay nagapo id Grecia ay inmey id Jerusalem ay makifiesta dadapay mendayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dadat omey ken Felipe et kananda en, “Apo, laydenmi ay mang-ila ken Jesus.” (Si Felipe san iBetsaida id Galilea.) ");
INSERT INTO xnn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dat omey ibagan Felipe ken Andres ta omeyda ipagtek ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dat kanan Jesus, “Nganngani nan kateyak ya nan kaipangatowak ay Iyon-an Am-in di Ipogaw. ");
INSERT INTO xnn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nan awnitak maikaoban et siya nan kaneg nan mais-ekan nan esay bowa tay no adi kais-ek et adi bomgas ngem no mais-ek et awnit bomgas is adoado. Kaneg nan awnitak mateyan et awnit adoado nan maisalakan. ");
INSERT INTO xnn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nan ipogaw ay kedeng nan awakna is ay-ayyewana et awnit matey met laeng. Ngem nan adi mang-ayyew isnan awakna isnan naay batawa gapo ken sak-en et awnit matey ngem matagotago ken Apo Dios ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nan manglayad ay menpabaa ken sak-en et masapol ay mang-on-onod tasiyay olay intoy kad-ak et wada siya abes isdi. Tay am-in ay menpabaa ken sak-en et awnit patpatgen Ama.” ");
INSERT INTO xnn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Dat itoloy Jesus ay mangwani, “Id wani et mangangawngaw nan nemnemko. Ngan ngata nan kanak ken Ama? Ay kanak ngen en, ‘Ama, ilisim koma sak-en isnan naay ommat ken sak-en?’ Ngem adi tay siya na nan gapo ay inmaliyak.” ");
INSERT INTO xnn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Danat kanan ken Apo Dios en, “O Ama, ipailam nan kadayawan nan ngadanmo.” Dat wada nan kali ay nagapo id daya ay mangwani en, “Inpailak nan kadayawak isnan inik-ikkam et awnitak ipaila kasin.” ");
INSERT INTO xnn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","San tinmatakdeg isdi et dinngeda san kali ngem kananda en waay ninkido. Nan tap-ina et kinwanida en nakitoya nan esay anghel ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ngem dat kanan Jesus, “San kali ay dinngeyo et bakenak is maipadngeana nodi ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Id wani et nan menlogiyan nan kabanagan nan ipogaw isnan batawa ya id wani nan kaabakan Satanas ay ap-apon di adi mamati. ");
INSERT INTO xnn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","No maipangatowak et awisek am-in nan kaipoipogaw ta mamatida ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kinwanina na ta ipagtekna nan kateyana ay mailansa siya isnan kros. ");
INSERT INTO xnn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dadat kanan, “Damen kanan en masapol ay maipangato ta matey nan Iyon-an Am-in di Ipogaw dapay kanan nan linteg en nan Kristo et matatago ay eng-enggana? Ay sino obpay nan Iyon-an Am-in di Ipogaw? Ay baken siya nan Kristo?” ");
INSERT INTO xnn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dat kanan Jesus, “Sak-en nan silaw et sin-awyan pay et kedeng nan menteak ken dakayo. Isonga omali kayo isnan silaw tay kakad-ana pay ken dakayo ta adi kayo kalabiyan. Tay nan mendad-aan isnan menbolinget et adina getken nan omay-ayana. ");
INSERT INTO xnn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iso ngalod nga mamati kayo ken sak-en ay silaw isnan kakad-ak ken dakayo tapno matatanggewan nan nemnemyo.” Kinwanin Jesus di dat komaan et itabonana daida. ");
INSERT INTO xnn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Olay no inpailana nan adoado ay kaskasdaaw isnan kad-anda et egayda kayet namati ken siya ");
INSERT INTO xnn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","et siya nan katongpalan din insolat Isaias ay mamadton Apo Dios id sang-adom ay naay, “Apo, maiwed namati isnan inbagbagami ya maiwed gedan namati isnan inpail-ilam ay panakabalinmo.” ");
INSERT INTO xnn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nan gapo ay egayda namati et insolat gedan din si Isaias en, ");
INSERT INTO xnn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kaneg kinollaw Apo Dios nan dalon mang-adi ay mamati ya inpakentegna nan toktokda tay adida layden ay mangnemnem isnan tet-ewa isonga bobolagenda dadapay totowengen tay adida layden ay omali ken sak-en ta pakawanek nan basolda.” ");
INSERT INTO xnn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kinwanin Isaias na tay inilana nan kinadios Kristo id sang-adom danat ibaga nan maipanggep ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ngem olay no kaneg todi et ado nan aap-apon di Judio ay namati ken Jesus ngem egayda inpapagtek tay omegyatda isnan Fariseo tay no getkenda et adida ipalobos ay maitapida isnan sinagogada ");
INSERT INTO xnn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ya tay laylaydenda ay madaydayaw isnan ipogaw mo nan madayawanda ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dat kasin menkali si Jesus et ibibiyadna ay mangwani en, “Nan mamati ken sak-en et bakenak kedeng is patiyenda nodi nan nangibaa gedan ken sak-en ");
INSERT INTO xnn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","tay nan nang-ila ken sak-en et inilana gedan nan nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inmaliyak ay silaw isnan batawa ta tanggewak nan nemnem am-in nan mamati ken sak-en ta adida mentetee isnan menbolinget. ");
INSERT INTO xnn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nan mangdenge isnan kalik danat adi tongpalen et bakenak is mangipabasol ken siya tay egayak inmali isnan batawa ay mangipabasol isnan ipogaw nodi inmaliyak ay mangisalakan ken daida. ");
INSERT INTO xnn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngem wada nan mangpabasol isnan mang-adi ken sak-en ya nan kankanak tay nan mangpabasol ken daida et siya nan tet-ewa ay kinkinwanik isonga awnit madosada isnan kaodiyan ay agew. ");
INSERT INTO xnn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tay bakenak is kanemnem isnan kinkinwanik nodi inbilin Ama ay nangibaa ken sak-en nan masapol ay kanak. ");
INSERT INTO xnn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tay getkek ay nan bilin Ama nan mang-idya is biyag ay maid patenggana isonga nan inbilin Ama nan ibagbagak.” ");
INSERT INTO xnn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nganngani nan Fiestan di Linmaosan di Anghel et getken Jesus ay siya nan komaanana isnan batawa ay somagongana ken Amana. Et siya na nan timpo ay mangipailaana ay maid kolang di layadna isnan ipogawna isnan batawa tay enggana isdin damo et linaylayadna daida. ");
INSERT INTO xnn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Idi mangmangan si Jesus ya nan papasolotna isnan labi dat ipanemnem Satanas ken Judas ay anak Simon Iscariote en id wani ay labi nan mangisipsipana ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ngem si Jesus et getkena ay inidyan Amana nan am-in ay panakabalin ken siya ya getkena gedan ay si Apo Dios nan nagapowana ya nan somagongana. ");
INSERT INTO xnn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Dat tomakdeg et kaanena nan nin-ooson ay badona dat men-ibalikes is towalya. ");
INSERT INTO xnn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Danat pay-an nan palanggana is danom et denasana nan papasolotna danapay ponasan issan towalya ay inbalikesna. ");
INSERT INTO xnn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Idi inomdan si Jesus ken Simon Pedro dat kanan Pedro, “Apo, ay sik-a nan mangdenas ken sak-en dapay apomi sik-a?” ");
INSERT INTO xnn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Dat kanan Jesus, “Adim pay maawatan nan naay ay ik-ikkak ngem awnit to met laeng getkem.” ");
INSERT INTO xnn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dat kanan Pedro, “Adiyak layden ay sik-a nan mangdenas ken sak-en.” Dat kanan Jesus, “Ngem no adiyak denasan sik-a et adika et maibilang ay pasolotko.” ");
INSERT INTO xnn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Apo, baken ngalod kedeng nan sikik is owasam nodi nan ledengko ya nan toktokko gedan,” kinwanin Pedro. ");
INSERT INTO xnn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ngem dat kanan Jesus, “Nan epdas nin-emes et adi masapol ay men-emes kasin tay nadalos et nodi kedeng nan sikina is madenasan. Dakayo et nadalos kayo malaksig nan esa.” ");
INSERT INTO xnn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Getken Jesus nan awnit mangisipsip ken siya isonga siya nan gapo ay kinwanina en bakenda nadalos am-in. ");
INSERT INTO xnn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Idi dinenasana daida dat menbado kasin et makitokdo ken daida. Danat sooten, “Ay maawatanyo san inikkak ken dakayo? ");
INSERT INTO xnn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kankananyo ken sak-en en Mistolo ya Apo et osto nan kananyo tay tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iso ngalod nga no sak-en ay Apoyo ya Mistoloyo et ipababak nan awakko ta denasak dakayo et masapol abes ay mendinenas kayo ya adiyo pangangatowen nan awakyo. ");
INSERT INTO xnn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","16","Ibagak ken dakayo nan tet-ewa, maiwed baa is nangatngato mo nan apona ya maiwed naibaa is nangatngato mo nan nangibaa ken siya. Isonga sak-en ay apoyo et inpailak di ken dakayo tasiyay ikkanyo abes nan inikkak. ");
INSERT INTO xnn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","No getkenyo ya maawatanyo dana et nagasat kayo no tongpalenyo.” ");
INSERT INTO xnn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ngem baken kayo am-in is pangwaniyak en nadalos kayo tay getkek nan nemnemyo ay pinilik. Ngem masapol ay maikkan na ta matongpal din naisolat ay kalin Apo Dios id kasin ay naay, ‘Nan esa ay nakikan ken sak-en et nangisipsip.’ ");
INSERT INTO xnn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ibagak na ken dakayo esapay ommat tasiyay no matongpal et awnit mamati kayo ay sak-en nan Kristo ay inbaan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ibagak nan tet-ewa ken dakayo, nan mangidnge isnan ibaak et mangidnge gedan ya nan mangidnge et idngena gedan nan nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kinwanin Jesus di dat dadama ay mangangawngaw nan nemnemna isonga danat kanan, “Ibagak nan tet-ewa et mangisipsip nan esa ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Dat men-asiila nan papasolotna tay adida getken no sino ken daida nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nan tomotokdo isnan sag-en Jesus et siya nan pasolot ay laylaydena ");
INSERT INTO xnn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","dat sinyasan Simon Pedro siya ta sootena ken Jesus no sino ken daida nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Isonga dat somag-en ken Jesus san deey pasolot et sadagana siya danapay sooten, “Apo, ay sino ken dakami nan kankanam?” ");
INSERT INTO xnn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Dat kanan Jesus ken siya et kedeng, “Siya nan mang-idyaak isnan itab-awko ay tinapay.” Isonga dat omala is tinapay et itab-awna danat idya ken Judas ay anak Simon Iscariote. ");
INSERT INTO xnn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Idi alaen Judas san tinapay dat kapten Satanas siya. Dat kanan Jesus ken siya, “Ikkam ay dagos nan wada isnan nemnemmo.” ");
INSERT INTO xnn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","San kinwanin Jesus ken Judas et egay naawatan nan papasolotna ay mangmangan ");
INSERT INTO xnn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ngem gapo tay si Judas nan manggegeen isnan sipingda et inpagalopda en inbagan Jesus en omey lomako is osalenda isnan fiesta wenno agtana nan kodokdo. ");
INSERT INTO xnn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kinan pay Judas san tinapay dat bomala. San kinmaanana et nalabi. ");
INSERT INTO xnn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Issan kinmaanan Judas dat kanan Jesus, “Maipaila nan kadayawak id wani ay Iyon-an Am-in di Ipogaw ya siya abes nan maipailaan nan kadayawan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Et no maipaila nan madayawan Apo Dios gapo ken sak-en et siya met laeng nan mail-an nan kinadayawko ay Anakna et maikkan ay dagos. ");
INSERT INTO xnn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","An-akko, sin-awyan pay et kedeng nan kawad-ak ken dakayo. Awnit kayo mang-an-anap ngem ibagak ken dakayo id wani din inbagak isnan aap-apon di Judio en adi kayo makaey isnan omayak. ");
INSERT INTO xnn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Naay di balbalo ay bilin ay ipagtekko ken dakayo. Masapol ay menlilinayad kayo. Kaneg nan pananglayadko ken dakayo nan ikkanyo koma ay menlilinayad. ");
INSERT INTO xnn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","No menlilinayad kayo et siya nan mangipagtek isnan am-in ay ipogaw en tet-ewa ay papasolotko dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dat sooten Simon Pedro, “Apo, ay intoy omayam et en?” “Adi mabalin ay omonodka ken sak-en id wani ngem esaka met laeng omonod,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Dat kayet sooten Pedro, “Apo, ayta dan adi mabalin ay omonodak ken sik-a id wani dapay olay mateyak gapo isnan pammatik ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dat kanan Jesus, “Kanam en olay no mateyka gapo isnan pammatim ken sak-en ngem ibagak nan tet-ewa ken sik-a et esapay mentan-o nan manok et mamitloka ay mangisot.” ");
INSERT INTO xnn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dat itoloy Jesus ay mangwani ken daida, “Olay no ngan di ommat et adi kayo koma mendanag nodi mamati kayo ken Apo Dios ya mamati kayo gedan ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tay nan kad-an Ama et omanay ay mentean di kaipoipogaw et omeyak ay mangisagana isnan menteanyo. Egayak koma inbagana no baken tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Et isnan omayak ay mangisagana isnan awnityo mentean, awnitak somagong ay mang-ayag ken dakayo tasiyay makitee kayo isnan kad-ak. ");
INSERT INTO xnn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Getkenyo met nan daan ay omey isnan omayak.” ");
INSERT INTO xnn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dat kanan Tomas ken siya, “Apo, adimi getken nan omayam isonga adimi gedan getken nan daan ay omey isdi.” ");
INSERT INTO xnn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Dat kanan Jesus, “Sak-en nan daan tay kedengak is kagapowan di biyag ya kedengak is mangibagbaga isnan tet-ewa et maiwed makaey ken Ama no adi mendaan ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No tet-ewa ay mangtek kayo et getkenyo gedan si Ama et enggana id wani kanegyo inila siya tay nang-ila kayo.” ");
INSERT INTO xnn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Dat kanan Felipe, “Apo, ipailam ngalod si Amam ken dakami ta mapnek kami.” ");
INSERT INTO xnn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Dat kanan Jesus, “Felipe, nabayag ay wadaak ken dakayo dakapay adi mangtek kayet? Nan nang-ila ken sak-en et inilana gedan si Ama. Ngem dakan kayet kanan en ipailak si Ama? ");
INSERT INTO xnn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ay adim patiyen ay wadaak ken Ama ya wada abes si Ama ken sak-en? Nan inbagbagak ken dakayo et bakenak is nagapowana nodi si Ama tay siya nan mangipakalkali ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mamati kayo koma ay wadaak ken Ama ya wada abes si Ama ken sak-en. Ngem no adi kayo mamati isnan ibagbagak et mamati kayo koma gapo isnan naayda ay ik-ikkak. ");
INSERT INTO xnn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ibagak nan tet-ewa ken dakayo, nan mamati ken sak-en et awnit ikkana nan ik-ikkak. Owen, dadakke pay mo da tona nan ikkana tay omeyak ken Ama. ");
INSERT INTO xnn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Isonga am-in ay dawatenyo gapo isnan mangtalkanyo isnan kabaelak et tongpalek tasiyay maidayaw si Ama isnan ik-ikkak ay Anakna. ");
INSERT INTO xnn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Owen, gapo isnan talekyo ken sak-en et olay am-in ay dawatenyo isnan ngadanko et awnitak ikkan.” ");
INSERT INTO xnn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Intoloy Jesus ay mangwani en, “No laylaydenyo sak-en et tongpalenyo nan bilinko. ");
INSERT INTO xnn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Awnitak dawaten ken Ama ta omibaa is teken ay mangbadang ay makitee ken dakayo ay eng-enggana ");
INSERT INTO xnn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","et siya nan Ispirito Santo ay mangipagtek isnan tet-ewa. Nan adi mamati ken sak-en et adida dawaten nan Ispirito Santo tay adida maimatonan siya. Ngem dakayo et gegetkenyo siya tay wada siya ken dakayo ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Adiyak taynan dakayo ay kaneg ngoso tay awnitak kasin somagong. ");
INSERT INTO xnn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Isnan sin-awyan et awnit adi mang-il-ila nan adi mamati ken sak-en ngem dakayo ay mamati et awnit ilaenyo sak-en. Et gapo tay matagowak kasin isonga awnit kayo abes matagotago. ");
INSERT INTO xnn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","No omdan nan agew ay deey et getkenyo ay wadaak ken Ama et wada kayo ken sak-en ay kaneg nan kawadak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nan mangdenge isnan bilinko danat tongpalen et siya nan manglaylayad ken sak-en. Nan manglaylayad ken sak-en et laylayden Ama ya laylaydek abes isonga awnitak ipagtek ken siya nan am-in ay maipanggep ken sak-en,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dat kanan Judas (baken si Judas Iscariote), “Apo, dakan aped ipagtek nan kaipogawmo ken dakami et kedeng ay baken isnan am-in ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Dat kanan Jesus, “Nan manglaylayad ken sak-en et tongtongpalena nan ibagbagak. Siya gedan et laylayden Ama isonga dakami ken Ama et awnit kami omali ay makitee ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngem nan adi manglaylayad ken sak-en et adina tongtongpalen nan ibagbagak. Bakenak is nagapowan nan kali ay dinngeyo nodi nagapo ken Ama ay nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ibagbagak am-in dana tay daanak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ngem awnit ibaan Ama nan bomadbadang ay si Ispirito Santo ay mangipagtek isnan maipanggep ken sak-en. Awnitna itdo nan maipanggep isnan am-in ay gawis ya ipanemnemna am-in nan inbagbagak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Adi kayo madandanagan ya omeg-egyat tay idyak nan lamnin ken dakayo ta menlamlamnin kayo et nan naay ay lamnin ay magapo ken sak-en et maiwed kaneg di kagawisna isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Dinngeyo san inbagak ay awnitak taynan dakayo ngem awnitak kasin somagong. No linaylayadyo sak-en et men-gasing kayo tay omeyak ken Ama ay nangatngato mo sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Inbagak na id wani ken dakayo esapay ommat tasiyay no ommat et pomigsa koma nan pammatiyo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Adiyak bayabayagen ay makikalkali ken dakayo tay omal-ali si Satanas ay ap-apon di adi mamati ay ipogaw. Maiwed kabaelana ken sak-en ");
INSERT INTO xnn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ngem ipalobosko ay ikkana nan kayatna ay ikkan tasiyay ipailak isnan am-in ay ipogaw ay laylaydek si Ama isonga tongtongpalek am-in ay ibagbagana ken sak-en. Ala, akayo ta entako.” ");
INSERT INTO xnn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Intoloy Jesus ay mangwani, “Sak-en nan kanega kaiw et si Ama nan mang-ay-ayowan. ");
INSERT INTO xnn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kaanena am-in nan panga ay adi bombomgas. Ngem nan bombomgas ay panga kaanena nan pingpingina ay adi bombomgas tasiyay ad-ado nan ibgasda. ");
INSERT INTO xnn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kanegyo nan panga ay bombomgas tay nadalosan kayo tay patiyenyo nan inbagak ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Isonga itoltoloyyo ay mangtaltalek tasiyay menteteeak ken dakayo. Tay no adi kayo mangtaltalek et adi kayo makaikkan is gawis. Kaneg nan panga et adi mabalin ay bomgas mo makaan isnan poona. ");
INSERT INTO xnn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Sak-en nan kanega poon di kaiw et dakayo nan kanegna panga. Nan mangtaltalek ken sak-en et menteteeak ken siya et awnit adoado nan ik-ikkana ay gawis tay no maiwedak et adi kayo makaikkan is gawis. ");
INSERT INTO xnn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Isonga nan adi maitoloy ay mentetee ken sak-en et maiwasit ay kaneg nan panga ay maango dat maponok et mapoowan. ");
INSERT INTO xnn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngem no itoltoloyyo ay mentetee ken sak-en ya idngeyo nan kalik dakayot ibaga nan kayatyo ken Ama et awnit maikkan ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Siya na nan pakaidayawan Ama, no gawis nan ikkanyo et kaneg kayo bomgas is ado ta mangipail-anyo ay pasolotko dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Laylaydek dakayo ay kaneg nan pananglayad Ama ken sak-en isonga adiyo taytaynan nan layadko ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","No tongpalenyo nan bilinko ay kaneg nan ikkak ay mangtongpal isnan bilin Ama et adi makak-aan nan layadko ken dakayo ay kaneg nan layad Ama ken sak-en ay adi makak-aan. ");
INSERT INTO xnn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Inbagak na ken dakayo tasiyay makigasgasing kayo ken sak-en ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Siya na nan ibilinko, menlinlinayad kayo ay kaneg nan ikkak ay manglaylayad ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nan kadakkelan ay layad ay ipailan nan ipogaw et olay matey siya basta matago nan gagayyemna ");
INSERT INTO xnn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","et dakayo nan gagayyemko no tongpalenyo nan bilinko. ");
INSERT INTO xnn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Id wani gagayyem nan pangwanik ken dakayo tay inbagak ken dakayo nan am-in ay dinngek ken Ama isonga baken et baa nan pangwanik ken dakayo tay nan baa et adina getken nan ik-ikkan nan apona. ");
INSERT INTO xnn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Baken kayo is nangpili ken sak-en ay mangisolo ken dakayo nodi sak-en nan nangpili ken dakayo. Pinilik dakayo ay omey mang-ikkan is gawis et siya nan kanegyo begas ay adi kaam-am-amin et ited Ama ken dakayo nan am-in ay dawatenyo isnan ngadanko tay mamati kayo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ibagak kasin san inbagak ken dakayo, menlinlinayad kayo.” ");
INSERT INTO xnn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kinwanin pay Jesus en, “Adi kayo masdaaw no aamisen nan adi mamati ken sak-en dakayo tay inilayo nan inkanda ay nang-aamis ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No kanegyo koma nan adi mamati et laylaydenda dakayo tay ib-ada dakayo. Ngem bakenyo kaneg daida tay pinilik dakayo ay mamati ken sak-en isonga siya na nan gapo ay aamisenda dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nenemnemenyo nan inbagak ken dakayo ay maiwed baa is nangatngato mo nan apona. No inaamisda sak-en et awnitda aamisen abes dakayo. Ngem no tinongtongpalda koma nan inbagbagak et tongpalenda abes nan ibagbagayo. ");
INSERT INTO xnn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ngem awnit ikkanda na am-in ken dakayo gapo ken sak-en tay adida od mamati ken Apo Dios ay nangibaa ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","No egayak koma inmali ay ninkali ken daida et bakenda basol nan adida mangpatiyan ken sak-en. Ngem id wani maiwed et ilasonda isnan basbasolda. ");
INSERT INTO xnn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tay nan mang-adi ken sak-en et adyana gedan si Ama. ");
INSERT INTO xnn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bakenda koma basol nan adida mangpatiyan ken sak-en no egayak inpaila ken daida nan kaskasdaaw ay maiwed polos makaikkan. Ngem id wani ay olay inilada nan inik-ikkak et adyanda kayet dakami ken Ama isonga dadama nan basolda. ");
INSERT INTO xnn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ngem masapol ay ommat dana tasiyay matongpal nan insolat din mamadto id kasin ay naay, ‘Adyanda sak-en ay maiwed gapo na.’ ");
INSERT INTO xnn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Awnitak ibaa ken dakayo nan Ispirito Santo ay magapo ken Ama tasiyay badbadangana dakayo ay eng-enggana. Siya nan mangpaneknek isnan tet-ewa ay maipanggep ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Et dakayo abes nan mangibaga isnan maipanggep ken sak-en tay naiboboboboweg kayo ken sak-en engganay inlogik ay men-isolo et getkenyo nan kaipogawko. ");
INSERT INTO xnn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Inbagak na ken dakayo tasiyay adiyo kalkalingkingan nan pammatiyo olay ngan di awnitda ik-ikkan ken dakayo ");
INSERT INTO xnn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","tay awnit adida ipalobos ay maitapi kayo isnan sinagogada gapo isnan pammatiyo ken sak-en. Owen, awnit omdan nan timpo ay nan mangpatey ken dakayo et kananda en nan inikkanda et siya nan layden Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Siya na nan ikkanda ken dakayo tay adida getken si Ama ya sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ngem ibagbagak na tasiyay mo ikkanda na ken dakayo dayot manemnem nan inbagbagak.” “Egayak inbaga na id kasin tay daanak ken dakayo ");
INSERT INTO xnn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ngem id wani ibagak na tay somagongak et isnan nangibaa ken sak-en. Ngem dan maiwed mensoot ken dakayo no intoy somagongak? ");
INSERT INTO xnn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Getkek ay menseseg-ang kayo gapo isnan inbagbagak ");
INSERT INTO xnn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ngem ibagak nan tet-ewa ken dakayo, pagawisanyo met laeng nan komaanak tay no adiyak komaan et adi mabalin ay omali nan Ispirito Santo ken dakayo ngem isnan komaanak et ibaak siya ta badbadangana dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Et isnan omaliyana awnit ipagtekna isnan adi mamati ken sak-en nan maipanggep isnan basolda. Ipagtekna gedan nan maipanggep isnan kinagawisko ya ipagtekna gedan nan maipanggep isnan mangbanagan Apo Dios isnan ipogaw isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nan maipanggep isnan basol et nan mangtekanda ay nakabasolda isnan egayda nangpatiyan ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nan maipanggep nan kinagawisko et nan mangtekanda ay sak-en nan pinilin Apo Dios ay mang-ikkan isnan laydena ya nan omayak ken siya ay awnit adi kayo mang-il-ila. ");
INSERT INTO xnn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nan maipanggep isnan mangbanagan Apo Dios isnan ipogaw et nan mangtekanda isnan nabanagan Satanas ay ap-apon di adi mamati ya nan am-in ay baana. ");
INSERT INTO xnn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Adoado pay nan ibagak koma ken dakayo ngem id wani adiyo pay laeng maawatan. ");
INSERT INTO xnn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ngem olay tay no omali nan Ispirito Santo et siya nan mangipagtek ken dakayo isnan am-in ay tet-ewa. Nan awnitna it-itdo et baken nan nemnemna is kagapgapowana nodi nan dengngena ay ibagbagan Apo Dios danapay ipagpagtek nan awnit om-ommat. ");
INSERT INTO xnn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Madayawak gapo ken siya tay awnit id-ana nan kayatko ay ibaga ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tay nan nemnem Ama et siya abes nan nemnemko isonga inbagak en awnit id-an nan Ispirito Santo nan kayatko ay ibaga ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Intoloy Jesus ay mangwani, “Isnan madandan ay agew awnit adiyo il-ilaen sak-en ngem adi mabayag et awnit mang-ila kayo kasin.” ");
INSERT INTO xnn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dat kanan nan tap-in nan pasolot Jesus isnan iib-ada, “Ngan ngen nan kayat ay kanan nan inbagana en isnan madandan ay agew et adi tako il-ilan siya ngem adi mabayag datakot ilaen kasin siya ya nan kinwanina gedan en omayana ken Amana?” ");
INSERT INTO xnn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Dadat men-asisoot en, “Ngan nan kayatna ay kanan isnan madandan ay agew? Adi tako maawatan nan ibagbagana.” ");
INSERT INTO xnn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Getken Jesus ay kayatda ay sooten ken siya isonga danat kanan ken daida, “Ay men-as-asisoot kayo gapo isnan inbagak en isnan madandan awnityo adi il-ilaen sak-en ngem adi mabayag dakayot mang-ila kasin? ");
INSERT INTO xnn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Dengenyo pay nan ibagak ken dakayo, awnit kayo men-aga dakayopay menseseg-ang gapo isnan awnit ommat ken sak-en dapay men-gasgasing nan adi mamati. Owen, awnit kayo menseseg-ang ngem awnit kayo kasin gomasing. ");
INSERT INTO xnn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kaneg nan omanakan nan babai et kaseseg-ang nan ilana gapo isnan menpasikalana ngem no epdas binmala nan onga et kalingkingana et nan sakitna gapo isnan gasingna isnan onga. ");
INSERT INTO xnn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kaneg abes ken dakayo, id wani menseseg-ang kayo ngem nan awnitak mang-ilaan kasin ken dakayo et awnit kayo men-galalasing. Owen, gasing ay maiwed makakaan ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ngem no mang-ila kayo kasin et bakenak is mendawdawatanyo nodi ken Ama. Owen, itedna nan am-in ay dawatenyo ken siya no iyosalyo nan ngadanko. ");
INSERT INTO xnn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Enggana id wani et maiwed dinawatyo ken Ama ay maipoon isnan pammatiyo ken sak-en. Mendawat kayo et awnit maagtan kayo tasiyay maid kolang di gasingyo.” ");
INSERT INTO xnn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Intoloy Jesus ay mangwani, “Pangngalig nan inik-ikkak ay nangsodsodok is dana ken dakayo ngem awnit omdan nan timpo ay adi masapol ay menpangngaligak ay mensodsodok ken dakayo nodi ipapadawesko ay mangipagtek isnan tet-ewa maipanggep ken Ama. ");
INSERT INTO xnn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","No omdan nan timpo ay deey awnit siya nan mendawdawatanyo tay idyak nan kalebbenganyo ay mendawat et adiyet masapol ay idawdawatak dakayo ");
INSERT INTO xnn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tay laylayden Ama dakayo isonga itedna nan dawatenyo. Laylaydena dakayo gapo tay laylaydenyo sak-en ya patiyenyo ay nagapowak ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nagapowak ken Ama daket omali isnan batawa ngem id wani et taynak nan batawa tay somagongak ken Ama.” ");
INSERT INTO xnn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dat kanan nan papasolotna ken siya, “Ilaem, maawatanmi nan kankanam id wani tay adim dadlo ipapangngalig. ");
INSERT INTO xnn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Id wani getkenmi ay getkem am-in isonga adi masapol ay mensoot kami ken sik-a tay getkem nan wada isnan nemnemmi. Siya na nan mangpatiyanmi ay nagapoka ken Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dat kanan Jesus, “Ay mamati kayo dadlo id wani? ");
INSERT INTO xnn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngem nganngani ay omdan nan timpo ay awnit kayo masis-iyan tay wasdin somaa et mataynanak ay maeesa. Ngem adiyak kaeesa tet-ewa tay wada si Ama ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Inbagak na ken dakayo tasiyay menlamlamnin kayo isnan maitatapiyanyo ken sak-en tay awnit paligaten nan adi mamati dakayo. Ngem olay, papigsaenyo kayet nan nemnemyo tay inabakko si Satanas ay ap-apon nan adi mamati ya nan am-in ay anito.” ");
INSERT INTO xnn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nakwas pay ay kinwanin Jesus na dat mentangad id daya et kanana, “Ama, inomdan et nan kateyak. Ipailam nan kinapategko tasiyay maipaila abes nan kinapategmo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tay inyalim nan kalebbengak isnan am-in ay ipogaw tasiyay agtak is biyag ay maid patenggana nan am-in ay mamati ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nan gapo ay matagotago nan ipogaw ay eng-enggana et nan pangtekanda ay sik-a et kedkedeng nan tet-ewa ay Dios ya nan pangtekanda ken sak-en ay Kristo ay inbaam. ");
INSERT INTO xnn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inpailak nan kinadiosmo isnan ipogaw isnan batawa tay kinwasko nan inbagam ay ikkak. ");
INSERT INTO xnn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ama, pasagongem sak-en isnan kad-am dakat mangipateg ay kaneg san panangipategmo ken sak-en issan kakad-ak ken sik-a esapay maboliw nan batawa. ");
INSERT INTO xnn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Inpagtekko nan maipanggep ken sik-a isnan ipogaw ay inyalim ken sak-en tay ipogawmo daida dakat iyali ken sak-en. Tinongtongpalda nan kalim ");
INSERT INTO xnn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","et id wani getkenda ay sik-a nan nagapowan am-in nan inik-ikkak. ");
INSERT INTO xnn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Inbagak am-in ken daida nan inbagam ken sak-en et pinatida. Getkenda ay tet-ewa ay nagapowak ken sik-a ya sik-a nan nangibaa ken sak-en ");
INSERT INTO xnn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","isonga ilol-owalowak daida. Baken nan adi mamati is ilol-owalowak nodi nan mamati tay ipogawmo ay inyalim. ");
INSERT INTO xnn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Am-in ay ipogawko et ipogawmo gedan kaneg nan ipogawmo et ipogawko abes et daida nan nangipaila isnan kinapategko. ");
INSERT INTO xnn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Id wani somagongak ken sik-a tay komaanak isnan batawa ngem mataynanda isna. Manakabalin ay Ama, aywanam daida isnan panakabalinmo tasiyay maeesa nan nemnemda ay kanegta. ");
INSERT INTO xnn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Isnan kawadak ken daida et inaywanak daida isnan panakabalinmo ay inyalim. Inaywanak daida et maiwed naisis-iyan nodi kedeng nan esa ay manglayad ay maisiyan tasiyay matongpal din naisolat ay kalim id kasin. ");
INSERT INTO xnn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nganngani ay somagongak ken sik-a isonga ibagak dana ta dengen nan papasolotko esakpay taynan daida tasiyay makigasgasingda ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inpagtekko nan kalim isnan papasolotko ngem inaamis nan adi mamati daida tay bakenda od ib-a daida ay kanegko ay bakenko gedan ib-a daida. ");
INSERT INTO xnn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Adiyak kanan en pakaanem daida isnan batawa nodi dawatek ta aywanam daida isnan panakabalin Satanas. ");
INSERT INTO xnn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tay nan papasolotko et bakenda kaneg nan adi mamati nodi kanegda sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nan kankanam et tet-ewa isonga ipagtekmo ken daida nan maipanggep ken sik-a ta maisiyanda isnan ngawi tasiyay makaikkanda isnan laydek ay ikkanda. ");
INSERT INTO xnn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nan inikkam ay nangibaa ken sak-en et siya abes nan ikkak ay mangibaa ken daida ay omey isnan il-ili isnan batawa ay mangipadamag isnan maipanggep ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gapo ken daida et mensaganaak ay matey tasiyay madalosanda tet-ewa ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Baken kedeng nan naayda ay pasolotko is ilol-owalowak nodi olay nan am-in ay awnit mamati ken sak-en gapo isnan mangisolsolowanda isnan maipanggep ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ilowalowak daida ta maeesa koma nan nemnemda ay kanegta. Maitapida koma ken daita ay kaneg nan kawad-ak ken sik-a ya nan kawad-am ken sak-en tasiyay patiyen nan ipogaw ay inbaam sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Siya nan gapo ay idyak ken daida nan panakabalin ay kaneg nan panakabalin ay inyalim tasiyay maeesada ay kanegta. ");
INSERT INTO xnn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wadaka ken sak-en ya wadaak abes ken daida isonga maeesada tasiyay maipaila isnan ipogaw ay inbaam sak-en ya laylaydem daida ay kaneg nan pananglayadmo ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama, linaylayadmo sak-en esapay maboliw nan batawa et siya nan gapo ay inyalim nan kinadiosmo. Laydek ay daida ay mamati ken sak-en et maitapida ken sak-en id daya ta ilaenda abes nan kinadiosko. ");
INSERT INTO xnn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama ay nalinteg, nan adi mamati ken sak-en et adida getken sik-a ngem getkek sik-a ya getken nan mamati ay inbaam sak-en ");
INSERT INTO xnn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","tay inpailak ken daida nan kinadiosmo et itoltoloyko ay mangipagtek tasiyay menlinlinayadda ay kaneg nan pananglayadmo ken sak-en ya tasiyay wadaak ken daida ay eng-enggana,” kinwanin Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Issan nakalowalowan Jesus danat iboweg nan papasolotna et gomdangda isnan ginawang ay Kidron dadat omey issan kad-an di kak-aiw ay olivo. ");
INSERT INTO xnn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas ay nangisipsip ken Jesus et getkena nan kad-anda tay namin ado ay inmey da Jesus isdi. ");
INSERT INTO xnn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Isonga inmey si Judas isdi ay mangboboweg isnan sosoldado ya nan tap-in di gowaldiyan di Templo ay inbaan nan menkangangato ay papadi ya nan Fariseo. Ninseselewda ya nin-aalmasda ay inmey. ");
INSERT INTO xnn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gegetken Jesus nan awnit ommat ken siya isonga danat sab-aten daida et kanana, “Ay sino nan an-anapenyo?” ");
INSERT INTO xnn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Dadat kanan, “Si Jesus ay iNazaret.” Dat kanan Jesus, “Naayak.” (Si Judas ay nangisipsip et wada ay makitatakdeg ken daida.) ");
INSERT INTO xnn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ngem issan nangwaniyan Jesus en, “Naayak” dadat mensanod dadapay matokang. ");
INSERT INTO xnn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Dat kasin sooten Jesus, “Sino ngalod nan an-anapenyo?” Dadat kasin kanan, “Si Jesus ay iNazaret.” ");
INSERT INTO xnn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Dat kanan Jesus, “Inbagak ngalod ay sak-en. No sak-en nan an-anapenyo, bay-anyo nan iib-ak.” ");
INSERT INTO xnn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Siya di nan kinwanina tasiyay matongpal san inbagana en, “Ama, maid polos naisis-iyan isnan am-in ay inyalim ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Si Simon Pedro et wada nan gamigna danat asoten et pingasana nan kanawan ay ingan Malco ay baan di kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Dat kanan Jesus ken Pedro, “Isiklangmo nan gamigmo. Ay kanam en adiyak maanosan nan ligat ay inyalin Ama?” ");
INSERT INTO xnn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","San sosoldado, san apoda ya san gogowaldiya et dinpapda si Jesus dadat ogden nan ledengna ");
INSERT INTO xnn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","dadat eyey omona ken Anas ay katogangan Caifas ay kangatowan ay padi isdin deey ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas nan nangbagbaga isnan Judio ay gawgawis mo matey nan esay ipogaw gapo isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro ya nan esay ib-ana ay pasolot et inmonodda ken Jesus. San ib-an Pedro et getgetkena si Anas ay kangatowan ay padi isdin nallos ay tew-en isonga nakisgep ken Jesus issan pantew. ");
INSERT INTO xnn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ngem si Pedro et nataynan isnan lowangan di pantew isonga dat somagong san ib-ana et ibagana issan mangbanbantay isnan lowangan ta pasegpena si Pedro. ");
INSERT INTO xnn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dat kanan san babai ken Pedro en, “Ay baken sik-a nan esay pasolot nan ipogaw ay deey?” Dat kanan Pedro, “Baken.” ");
INSERT INTO xnn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Issan labi ay deey et mentedek isonga dat mendenet nan deeyday baa ya san gogowaldiya et men-anidoda dat makianido abes si Pedro ken daida. ");
INSERT INTO xnn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Isnan baey et somsomalyaen san kangatowan ay padi si Jesus maipanggep isnan papasolotna ya nan isolsolona. ");
INSERT INTO xnn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Dat kanan Jesus, “Nan ninkalkaliyak et isnan sagang nan kaipoipogaw tay nan nin-isolsolowak et isnan kaponponokan am-in di Judio ay kasinasinagoga ya isnan Templo. Maiwed polos kinkinwanik is naililimed. ");
INSERT INTO xnn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ngem dan sak-en od nan somsomalyaem ay baken nan naayda ay ipogaw ay nangdedenge ken sak-en is mensootam no ngan nan inbagbagak ken daida tay getkenda?” ");
INSERT INTO xnn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Idi nakakali si Jesus dat tipaken nan esay gowaldiya siya danapay kanan, “Dan aped kaneg tosa nan ikkam ay mangsongbat isnan kangatowan ay padi?” ");
INSERT INTO xnn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Dat kanan Jesus ken siya, “No waday kinwanik is ngawi, ibagam. Ngem no maiwed dakan aped mangtipak?” ");
INSERT INTO xnn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dat paeyey Anas si Jesus ay daan ay nababalod nan ledengna ken Caifas ay kangatowan ay padi. ");
INSERT INTO xnn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Daan ay tomatakdeg si Pedro ay men-an-anido dat kanan nan tap-ina ken siya en, “Ay baken kad sik-a nan esay pasolot todi?” Ngem dat isot Pedro ay mangwani, “Bakenak.” ");
INSERT INTO xnn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nan esay baan di kangatowan ay padi ay agin san piningasan Pedro san ingana et kinwanina en, “Ay baken sik-a san inilak ay ib-an todi issan kad-an di kak-aiw?” ");
INSERT INTO xnn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dat kasin isot Pedro en bakena ib-a si Jesus dat matanan-o nan manok. ");
INSERT INTO xnn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wisngit dat ikaan san aap-apon di Judio si Jesus issan baey Caifas et eyeyda isnan baey Gobilnadol Pilato. Ngem egayda songgep tay nan ogalida et no songgepda isnan baey di baken Judio et adi mabalin ay makikanda isnan Fiestan di Linmaosan di Anghel tay bakenda nadalos. ");
INSERT INTO xnn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Isonga dat bomala si Gobilnadol Pilato et ena sooten, “Ngan nan mangidalomanyo isnan naay ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Dadat kanan, “Adimi aped iyali siya ken sik-a no maiwed basolna.” ");
INSERT INTO xnn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Dat kanan Pilato ken daida, “Kigad kayo ngalod ay mangbanag ken siya ay kaneg isnan lintegyo.” Dat kanan san deeyday Judio, “Ngem dakami ay Judio et maid kalebbenganmi ay mangipapatey is ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Siya di nan inommat ta matongpalan din inbagan Jesus ay ikkakan di kateyana. ");
INSERT INTO xnn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dat songgep kasin si Pilato danat paayagan si Jesus et sootena en, “Ay sik-a nan alin di Judio?” ");
INSERT INTO xnn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Dat kanan Jesus, “Ay sik-a nan kanemnem isnan sinootmo wenno waday nangibaga ken sik-a?” ");
INSERT INTO xnn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Dat kanan Pilato, “Aykeak Judio? Nan kailiyam ya nan menkangangato ay papadiyo nan nangidalom ken sik-a isna. Ay ngan nan basolmo?” ");
INSERT INTO xnn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Dat kanan Jesus, “Baken isnan batawa is men-aliyak. Tay no isnan batawa koma waay makigobat nan ipogawko tasiyay adiyak maidya isnan Judio. Ngem baken isnan batawa is men-aliyak.” ");
INSERT INTO xnn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Isonga dat kanan Pilato, “Adi pay alika obpay?” Dat kanan Jesus, “Sik-a nan nangwani en aliyak. Siya na nan gapo ay naiyanakak isnan batawa ta ibagbagak nan tet-ewa. Et nan manglayad isnan tet-ewa, dengngenda nan ibagbagak.” ");
INSERT INTO xnn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Dat kanan Pilato, “Ay ngan ngen nan kinatet-ewa?” Dat bomala kasin et kanana issan deeyday Judio en, “Maiwed getkek is basol todi is apedna kadosaan. ");
INSERT INTO xnn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ngem gapo isnan ogaliyo ay tonggal Fiestan di Linmaosan di Anghel et omipalobosak is esay balod isonga ay laydenyo ta nan naay alin di Judio nan palobosak?” ");
INSERT INTO xnn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dadat asigigiyaw ay mangmangwani en, “Baken siya nodi si Barabas nan palobosam.” Si Barabas et mangakew. ");
INSERT INTO xnn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Daet ipabaig Pilato si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Dat komawikaw nan sosoldado is sibit et ipabedbedda ken Jesus ay kaneg kalagong di ali dadapay badowan is men-gadangdang ay kaneg badon di ali. ");
INSERT INTO xnn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dadat sag-enen siya ay mangmangwani en, “Madayaw kano nan alin di Judio,” dadapay tipatipaken siya. ");
INSERT INTO xnn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Dat bomala kasin si Pilato et kanana issan kaipoipogaw, “Ilaenyo, ipailak siya ken dakayo tasiyay getkenyo ay maid met masokalak is gapo na ay apedak mangdosaan ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isonga dat bomala si Jesus ay ninbebedbed is sibit ya ninbabado is kaneg badon di ali dat kanan Pilato ken daida, “Ilaenyo, naay san ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Idi inilan san menkangangato ay papadi ya san menlelebbeng ay Judio si Jesus dadat kasigigiyaw en, “Pailansam isnan kros. Pailansam isnan kros.” Ngem dat kanan Pilato ken daida, “Dakayo ngalod nan mangilansa ken siya isnan kros tay maiwed nasokalak is gapo na is apedak mangdosaan ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Dat kanan san deeyday Judio, “Ngem isnan lintegmi et lebbengna ay matey siya tay apedna kankanan en Anak Apo Dios siya.” ");
INSERT INTO xnn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Issan nangdengngan Pilato isnan kinwanida et am-amed inmegyat ");
INSERT INTO xnn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","dat songgep kasin et sootena ken Jesus, “Ay into nan nagapowam?” Ngem egay sinmongbat si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dat kanan Pilato, “Dakan adi somongbat? Ay adim getken ay wada nan kalebbengak ay mangipalobos wenno mangipalansa ken sik-a isnan kros?” ");
INSERT INTO xnn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Dat kanan Jesus, “Maid kalebbengam ken sak-en no egay inidyan Apo Dios ken sik-a. Isonga nan nang-idya ken sak-en ken sik-a et dadama nan basolda.” ");
INSERT INTO xnn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Issan nangdengngan Pilato isna et palalo nan layadna ay mangipalobos koma ken siya. Ngem am-amed inbogaw san deeyday Judio en, “No palobosam si tosa et mamagtek ay bakenmo gayyem si Cesar ay ali tako. Tay nan mangwani en ali nan awakna et ap-aposena si Cesar.” ");
INSERT INTO xnn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Issan nangdengngan Pilato issan kinwanida danat ipabala kasin si Jesus dat omey tomokdo si Pilato isnan tokdowan di howis. San deey ay tokdowan et nadadatil is bato ay kanan nan Judio en Gabata. ");
INSERT INTO xnn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Issan tinmokdowana ay mangbanag ken Jesus et kag-aw esapay menlogi nan fiesta. Dat kanan Pilato issan deeyday Judio, “Naay nan aliyo.” ");
INSERT INTO xnn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dadat kasigigiyaw en, “Papateymo. Papateymo. Pailansam isnan kros.” Dat sooten Pilato ken daida, “Ay laydenyo ay pailansak isnan kros nan aliyo?” Dat kanan san menkangangato ay papadi, “Maiwed teken is alimi nodi kedeng si Cesar.” ");
INSERT INTO xnn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dat idyan Pilato si Jesus ken daida ta mailansa isnan kros. ");
INSERT INTO xnn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Isonga dat alaen san sosoldado si Jesus et ipaboligda nan krosna dadat iyey isnan bilig ay makwani en ingit di toktok ay kanan di Judio en Golgota. ");
INSERT INTO xnn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Isdi nan nangilansaanda ken siya isnan kros. Wada gedan nan doway lalalaki ay nailansa isnan krosda ay nanggagawa ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dat ipasolat Pilato nan naay, “Si Jesus ay iNazaret ay alin di Judio” danat ipapaey isnan kros. ");
INSERT INTO xnn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Adoado nan Judio ay mangbasbasa isna tay san nailansaan Jesus et naisasag-en id Jerusalem dapay naisolat isnan kalin di Judio, kalin di iRoma ya isnan kalin di iGrecia. ");
INSERT INTO xnn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","San deeyday Judio ay menkangangato ay papadi et enda inbaga ken Pilato en, “Sokatam kad nan insolatmo ay, ‘Alin di Judio’ ta isolatmo en, ‘Kankanan tona en siya nan alin di Judio.’” ");
INSERT INTO xnn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ngem dat kanan Pilato, “Nan epdasko insolat et siya nan maisosolat.” ");
INSERT INTO xnn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Idi inlansan san sosoldado si Jesus dadat alaen nan badbadona et pagkap-atenda ay mangpigpigas tay epatda. Inalada gedan nan an-ando ay badona ay inabe ay maid panaitana. ");
INSERT INTO xnn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Isonga dadat kanan, “Gawis no adi tako singsingaten na ta menbonot tako no sinoy mang-ala.” Et siya nan natongpalan din kalin Apo Dios ay naisolat id kasin ay naay, “Pinigpigasda nan badbadok. Ninsosogalda gapo isnan an-ando ay badok.” Et siya di nan inkan san sosoldado. ");
INSERT INTO xnn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Issan sag-en nan kros Jesus et tinmatakdeg da inana ya san besat inana, si Maria ay asawan Cleofas ya si Maria Magdalena. ");
INSERT INTO xnn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Inilan Jesus si inana ya san esay pasolotna ay linaylayadna ay tinmatakdeg isdi isonga dat kanan Jesus ken inana, “Ina, si tosa et nan men-anakmo.” ");
INSERT INTO xnn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Danat abes kanan issan pasolotna, “Si ina et nan men-inam.” Et enggana isdi dat ayagan san pasolot si inan Jesus ta makitee ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Getken Jesus ay nakwas am-in danat kanan, “Naewewak,” ta matongpalan nan naisolat ay kalin Apo Dios id kasin. ");
INSERT INTO xnn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wada isdi nan nalaka ay basi dadat itab-aw nan galot ay naibedbed isnan pao dadat ipangato ta sopsopan Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Sinopsopan Jesus san basi danat kanan, “Nakwas et am-in id wani,” dat maoyos nan leng-agna. ");
INSERT INTO xnn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Issan agew ay deey et Biyalnis et kanan nan Judio ay lawa no taynanda nan nailansa isnan kros isnan agew di obaya tay nan kawakgatana et ngitingit di obaya isonga dat dawaten san aap-apon di Judio ken Pilato en palobosana nan sosoldado ta gopongenda nan siksikin san deeyday nailansa tasiyay epdasda matey ta kakaananda isnan krosda. ");
INSERT INTO xnn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Isonga dat omey san sosoldado et gopongenda san siksikin san dowa ay naitapi ay nailansa ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Omdanda pay ken Jesus dadat ilaen ay epdas natey isonga egayda et gopongen nan sikina. ");
INSERT INTO xnn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ngem nan esay soldado et indoy-okna kayet nan balbegna isnan gitang Jesus dat mabanala ay dagos nan basa ya danom. ");
INSERT INTO xnn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","San nang-ila issan am-in ay inom-ommat et siya nan nangibagbaga isnan tet-ewa tasiyay patiyenyo abes. Tet-ewa nan ibagbagana tay getkena nan inom-ommat. ");
INSERT INTO xnn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Siya na san inommat ta matongpalan din naipagto ay kalin Apo Dios id kasin, “Maiwed esay ingitna is awnit magpong.” ");
INSERT INTO xnn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Wada gedan nan naisolat ay kanana en, “Awnit ilaenda met laeng san dinoy-okda.” ");
INSERT INTO xnn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wada nan am-ama ay si Jose ay iyArimatea. Si Jose et mamati ken Jesus ngem egayna inpagpagtek tay omegyat isnan aap-apon di Judio. Ngem issan nateyan Jesus dat omey ken Pilato ay mangdawat isnan awak Jesus. Dat palobosan Pilato siya ay mang-ala ken Jesus isonga dadat omey ken Nikodemo et alaenda. ");
INSERT INTO xnn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Si Nikodemo san inmey nakitoya ken Jesus isdin esay labi. Issan inmayanda ken Jose et inkakawit Nikodemo nan limampoo ay kilo ay menbango ay agas ay ninlaok nan libon di kaiw ay mira ya alos. ");
INSERT INTO xnn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inalada nan awak Jesus dadat pakbowan issan menbango ay agas dadapay bongonen isnan balo ay galot tay siya di nan ikkan nan Judio isnan natey sadapay ikaob. ");
INSERT INTO xnn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dadat eyey siya isnan kakak-aiwan ay kad-an di nakakaongan ay bato ay egay kaos-osal ay sag-en nan nailansaana. ");
INSERT INTO xnn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Siya di nan nangiyanda tay naisasag-en dapay kamasdemana et menlogi san obayan di Judio. ");
INSERT INTO xnn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wisngit isnan Domingo dat omey da Maria Magdalena issan naipay-an Jesus dadat ilaen ay nakaan san bato ay naitangeb. ");
INSERT INTO xnn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Dadat tomagtag ay omey ken Simon Pedro ya san esay pasolot ay linaylayad Jesus dat kanan Maria, “Inalada man nan Apo tako issan naipay-ana et adimi getken no intoy nangyanda ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Dat omey si Pedro ya san esay pasolot issan naipay-an Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mentagtagtagda ay dowa ngem san ib-an Pedro et makatagtag mo siya isonga inomdan omon-ona ");
INSERT INTO xnn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","danat osdongan et inilana san galot ay naibongon ken Jesus ngem egay sinonggep. ");
INSERT INTO xnn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Omdan pay si Simon Pedro danat idadawes ay songgep danat ilaen san galot ay naibongon ken Jesus ay naibabadeng ");
INSERT INTO xnn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ngem san galot ay naibebedbed issan toktok Jesus et nalolon ay naisisiyan issan galot ay naibongon issan awakna. ");
INSERT INTO xnn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dat abes songgep san ib-an Pedro. Issan nang-il-ana issan galot et siya nan namatiyana ay natago kasin si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ngem egayda kayet naawatan din naisolat ay kalin Apo Dios id kasin ay mangwani en awnit matago kasin. ");
INSERT INTO xnn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dat somaa san doway pasolot ");
INSERT INTO xnn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ngem si Maria Magdalena et nataynan ay men-ag-aga issan kad-an di naipay-an Jesus. Daan ay men-ag-aga dat men-osdong ");
INSERT INTO xnn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","danat ilaen nan doway anghel ay ninbabado is polaw. Tinmotokdoda issan naipay-an san awak Jesus. Nan esa et wada isnan totongowen di toktok ya nan esa isnan sikiyan. ");
INSERT INTO xnn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dadat kanan, “Dakan aped men-ag-aga?” Danat kanan, “Inalada nan Ap-apo et adiyak getken nan nangyanda ken siya.” ");
INSERT INTO xnn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kinwanina di dat menligos danat ilaen si Jesus ay tomatakdeg isdi ngem egayna naimatonan ay si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Dat kanan Jesus, “Dakan aped men-ag-aga? Ay sino nan an-anapem?” Ngem kanan Maria Magdalena en waay siya san mangbanbantay issan kad-an di kak-aiw isonga danat kanan, “Apo, no sik-a nan nang-ala ken siya, ibagam kad no intoy nangyam ta omeyak alaen.” ");
INSERT INTO xnn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria,” kinwanin Jesus. Dat sagongen Maria siya danat kanan, “Rabboni.” (Nan kanan tona isnan kalin di Judio et mistolo.) ");
INSERT INTO xnn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ngem dat kanan Jesus, “Adika mangikawkawe tay egayak kayet ninsagong ken Ama. Omeyka bawet ibaga isnan papasolotko ay bebsatko en somagongak ken Amak ay Diosko ay siya nan Amayo ya Diosyo gedan.” ");
INSERT INTO xnn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Isonga dat omey si Maria Magdalena et ibagana issan papasolot Jesus en inilana si Apo Jesus danapay inbaga san inbagan Jesus ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nalabi issan deey ay Domingo dat matogop san deeyday pasolot Jesus et mendakigda tay omegyatda isnan aap-apon di Judio. Ngem dat mawanada si Jesus issan kad-anda ay tomatakdeg danat kanan, “Menlamlamnin kayo.” ");
INSERT INTO xnn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Danat ipaila nan adpana ya nan gitangna et dadama nan gasing san deeyday papasolotna issan nang-ilaanda isnan Apoda. ");
INSERT INTO xnn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dat kanan kasin Jesus ken daida, “Menlamlamnin kayo. Ibaak dakayo ay kaneg nan inkan Ama ay nangibaa ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Danat sip-oyan daida danapay kanan, “Dawatenyo nan Ispirito Santo. ");
INSERT INTO xnn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","No pakawanenyo nan basbasol di ipogaw et pakawanen Apo Dios daida ngem no adiyo pakawanen daida et adi pakawanen Apo Dios daida.” ");
INSERT INTO xnn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Issan ninpailaan Jesus issan papasolotna et maiwed si Tomas ay makwani en Ipi ay esa issan simpoo ya dowa ");
INSERT INTO xnn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","isonga dat ibagan san iib-ana en inilada nan Apoda. Dat kanan Tomas, “No adiyak ilaen ya kapposen nan kiblat di nalansaan isnan adpana ya adiyak kapposen nan gitangna et adiyak polos patiyen.” ");
INSERT INTO xnn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nakwas nan esay domingo dat maponok kasin san papasolot Jesus isnan baey et wada et si Tomas. Naidadakig nan en-eneb ngem dat mawanada si Jesus ay tomatakdeg isnan kad-anda. Danat kanan, “Menlamlamnin kayo.” ");
INSERT INTO xnn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Danat kanan ken Tomas, “Ilaem nan kiblat isnan adpak dakat kapposen dakapay oyaden nan ledengmo ta kapposem nan gitangko. Adika mendowadowa nodi mamatika.” ");
INSERT INTO xnn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dat kanan Tomas, “Sik-a nan Apok ya nan Diosko.” ");
INSERT INTO xnn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Dat kanan Jesus ken siya, “Mamatika aya tay nang-ilaka? Nan mamati et olay no egayda nang-ila et dadama nan gasingda.” ");
INSERT INTO xnn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Adoado pay nan inik-ikkan Jesus ay kaskasdaaw ay inpail-ilana isnan papasolotna ngem egay naisolat isnan naay ay liblo. ");
INSERT INTO xnn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ngem nan naayda et naisolatda tasiyay patiyenyo ay si Jesus nan Kristo ay Anak Apo Dios et gapo isnan pammatiyo et matagotago kayo ay eng-enggana ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nallos nan kaat ay agew dat kasin menpaila si Jesus isnan papasolotna isnan baybay id Tiberias. Siya na nan inkana ay ninpaila. ");
INSERT INTO xnn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nadadagop da Simon Pedro, Tomas ay makwani en Ipi, Natanael ay iCana ay esay ili id Galilea, san doway an-ak Zebedeo ya nan dowa pay ay ib-ada. ");
INSERT INTO xnn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Dat kanan Simon Pedro issan iib-ana, “Omeyak mensidok.” Dadat kanan, “Makkey kami ken sik-a.” Isonga dadat omey et menloganda isnan bangka ngem maid polos inalada is ikan issan labi ay deey engganay nawakgat. ");
INSERT INTO xnn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Isnan wisngit dat tomakdeg si Jesus issan benget di baybay ngem egay naimatonan san papasolotna siya. ");
INSERT INTO xnn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Danat kanan ken daida, “Gagayyem, ay waday sinidokanyo?” Dadat kanan, “Maiwed polos.” ");
INSERT INTO xnn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Danat kanan ken daida, “Oy-oyenyo nan sidokyo isnan makanawan nan bangka et awnit wada nan alaenyo.” Isonga dadat oy-oyen nan sidok dadat adi makaipadaka isnan sidok tay adoado nan inalada ay ikan. ");
INSERT INTO xnn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dat ibagan san pasolot ay linaylayad Jesus ken Pedro en, “Siya di si Apo Jesus.” Issan nangdengngan Simon Pedro ay siya si Apo Jesus dat menbado tay ninlalabos dat lomabtok isnan danom ta ena datngan si Jesus ");
INSERT INTO xnn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","dapay mataynan san iib-ana isnan bangka ay manggoygoyod ay mangidaka isnan sidok ay nanapno is ikan tay waay siyampoo ay metro et kedeng nan kaad-addawida isnan benget nan baybay. ");
INSERT INTO xnn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kinmay-atda isnan benget nan baybay dadat ilaen nan men-gag-aeb ay gabbang ay naiyooson nan ikan ya wada gedan nan tinapay. ");
INSERT INTO xnn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dat kanan Jesus ken daida, “Omyali kayo isnan kaal-alayo ay ikan.” ");
INSERT INTO xnn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dat omey si Simon Pedro et ipadakana isnan benget di baybay san sidok ay nanapno is dadakke ay ikan. Sin-gasot ya limampoo ya tolo am-in ngem olay no adoado nan ikan et egay nabakas san sidok. ");
INSERT INTO xnn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dat kanan Jesus ken daida, “Akayo ta mangan tako.” Ngem mabainda ay mangsoot no sino siya tay gegetkenda ay siya si Jesus. ");
INSERT INTO xnn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dat alaen Jesus nan tinapay ya nan ikan et idyana ken daida. ");
INSERT INTO xnn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Siya di san maikatlo ay ninpailaan Jesus issan papasolotna enggana isdin natagowana. ");
INSERT INTO xnn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nakakanda pay dat kanan Jesus ken Simon Pedro, “Simon ay anak Juan, ay am-amed nan pananglayadmo ken sak-en mo da tona?” Dat kanan Simon, “Owen, Apo, getkem ay laylaydek sik-a.” Dat kanan Jesus, “No siya sa, banbantayam ngalod nan ipogawko tay daida nan kanegko kakalnilo.” ");
INSERT INTO xnn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pinidwan Jesus ay mangwani, “Simon, ay anak Juan ay manglaylayadka?” Dat kanan kasin Simon, “Owen, Apo, getkem met ay laylaydek sik-a.” Dat kanan Jesus, “No siya sa, banbantayam nan kakalnilok.” ");
INSERT INTO xnn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dat pitlowan Jesus ay mangwani, “Simon, ay anak Juan, ay manglaylayadka tet-ewa?” Dat menseseg-ang si Pedro tay namitlo ay sinoot Jesus no laylaydena siya danat kanan, “Apo, getkem nan am-in et getkem ay laylaydek sik-a.” Dat kanan Jesus ken siya, “Banbantayam ngalod nan kakalnilok. ");
INSERT INTO xnn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ibagak ken sik-a nan tet-ewa, issan kaongam et kigadka ay menbadbado dakat omey is laylaydem ngem no maam-amaka awnit wadada nan mangipadedepa ken sik-a dadapay igalot nan ledengmo dadat eyey sik-a isnan adim layden ay omayan.” ");
INSERT INTO xnn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nan nangwaniyan Jesus isna et tasiyay ipagtekna nan awnit maikkan ken Pedro isnan mateyana ta maidaydayaw si Apo Dios. Dat kanan Jesus ken siya, “Mang-on-onodka.” ");
INSERT INTO xnn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Dat menligos si Pedro et ilaena ay omon-onod san pasolot ay linaylayad Jesus. Siya di san nangsadag ken Jesus isdin deey labi ay nangananda ay nangsoot en no sinoy awnit mangisipsip ken siya. ");
INSERT INTO xnn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Issan nang-ilaan Pedro issan deey ay pasolot danat kanan ken Jesus, “Apo, ay ngan pay nan awnit ommat isnan naay ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ngem dat kanan Jesus, “No laydek ay matatago siya enggana ay omaliyak kasin, ay ngan di pangtom? Basta mang-on-onodka bawet.” ");
INSERT INTO xnn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Issan nangdengngan san papasolot Jesus et kananda en waay adi matmatey nan deey ay pasolot. Ngem egay kinwanin Jesus en adi katkatey nodi kinwanina et kedeng en, “No laydek ay matatago siya enggana ay omaliyak kasin, ay ngan di pangtom?” ");
INSERT INTO xnn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","San deey pasolot ay kankanan Jesus et sak-en ay nangibaga ya nangisolat isnan naayda et getkenmi ay tet-ewa nan insolatko ay naay. ");
INSERT INTO xnn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Owen, adoado pay nan tap-ina ay inik-ikkan Jesus. No maisolatda koma am-in et kanak en adi omanay nan batawa is kaipay-an nan liblo ay kaisolatanda.");
INSERT INTO xnn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Gayyem Teofilo: Isdin damo ay liblo ay insolatko et inbagak am-in din inik-ikkan ya insolon Jesus menlogi isdin logina ");
INSERT INTO xnn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ya enggana isdin nangipangatowan Apo Dios ken siya id daya. Ngem esapay somaa id daya et wada nan inbilina isnan deeyda ay papasolotna ay pinilina ay makwani en apostolis. Nan Ispirito Santo nan nang-itdo ken Jesus isnan inbagbagana ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Namin ado nan ninpap-ailaana isnan aapostolis isnan kasina natagowan enggana ay nalpas nan epat poo ay agew. Adoado gedan nan inik-ikkana tasiyay maid gapona is adida mangpatiyan ay kasin natago. Inil-ilada siya et init-itdowana daida maipanggep isnan mentolayan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Isnan esa ay agew nadagopda. Dat kanan Jesus ken daida, “Din si Juan et danom nan inosalna ay menbonyag ngem awnit nan Ispirito Santo nan ited Apo Dios ken dakayo ay kanegna ibonyag ken dakayo. Isonga adi kayo komak-aan id isna Jerusalem ta sed-enyo tay nganngani ay omali. Siya di nan inkalin Ama ay inbagak abes ken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Isnan namingsan ay nadagopan da Jesus ya nan aapostolis et sinootda en, “Apo, ay id wani nan mangipakaanam isnan iRoma ay mentotolay ken datako tasiyay datako nan kalebbeng ay mentolay isnan am-in ay ili tako ay Judio?” ");
INSERT INTO xnn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Dat kanan Jesus ken daida en, “Nan timpo ay mentolayan tako et adi kabalin ay getkenyo tay si Apo Dios et kedeng nan kalebbeng ay mangtek isnan awnit om-ommat isnan omal-ali ay agew ya nan timpo ay ommatana. ");
INSERT INTO xnn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ngem nan ipagtekko ken dakayo et siya na. Awnit kapten nan Ispirito Santo dakayo et itedna nan kabaelanyo ta tomoled kayo ay mangibagbaga isnan maipanggep ken sak-en id Jerusalem dat isnan kailiili id Judea ya isnan kailiili id Samaria enggana isnan kailiili isnan batawa.” ");
INSERT INTO xnn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nakwas nan initdon Jesus ay deey dadat ilan siya ay maipangato id daya. Nintangadda ay mang-ila ken siya enggana ay nasalinan isnan liboo. ");
INSERT INTO xnn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Daanda pay ay mangiila id daya dat wada nan doway lalalaki ay anghel ay ninbabado is polaw ay natanakdeg isnan kad-an nan aapostolis. ");
INSERT INTO xnn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Dadat kanan, “Dakayo ay iGalilea, dakayon aped tatangaden id daya? Si Jesus ay inilayo ay naipangato id daya et awnityo kasin ilan nan omaliyana ay kaneg nan inmayana id wani.” ");
INSERT INTO xnn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dat somagong nan aapostolis id Jerusalem ay magapo isnan bilig ay Olivo ay esay kilometro nan kaasag-ena. ");
INSERT INTO xnn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Idi inomdan nan aapostolis id Jerusalem et inmeyda isnan baey. Dadat omey isnan maikadwa ay galado ay menteteanda. Siya dana nan ngadngadanda. Da Pedro ken Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago ay anak Alfeo, Simon ay mangisaksakit isnan ilina yas Judas ay anak Santiago. ");
INSERT INTO xnn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Inagew ay enda makilol-owalo tay naeesa nan nemnemda maipanggep isnan pammatida ken Apo Dios. Wada abes nan bababai ay naitapi ken daida ya si Maria ay inan Jesus ya nan bebsat Jesus ay lalalaki. ");
INSERT INTO xnn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Isnan esay agew ay nadagopan nan waay sin-gasot ya dowampoo ay mamati ken Jesus dat tomakdeg si Pedro et kanana, ");
INSERT INTO xnn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","18","“Dakayo ay bebsatko ay mamati ken Jesu Kristo, natongpal et nan inpanemnem nan Ispirito Santo ay insolat din si David ay maipanggep ken Judas tay am-in ay kankanan Apo Dios et masapol ay matongpal. Si Judas et nadotokan ay nakiobla ken dakami ay apostolis. Ib-ami siya ngem siya nan nangipango isnan nangdepap ken Jesus. Linagbowanda siya isnan ngawi ay inikkana dat maosal nan lagbona ay mailako is om-a. Dat mentekdag dat maboslayan nan egesna. ");
INSERT INTO xnn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Idi gintek am-in nan iJerusalem nan inikkan Judas dadat ngadnan san om-a is Aceldama ay makwani en om-a ay nabasaan isnan kalida.” ");
INSERT INTO xnn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Dat itoloy Pedro ay mangwani en, “Siya na nan inpanemnem nan Ispirito Santo id kasikasin ay maipanggep ken Judas et naisolat isnan liblo ay Salmo. Kanana en, ‘Menbayen koma nan baeyna ta maid kasin mentet-ee isdi.’ Wada abes nan naisolat ay mangwani, ‘Maidya koma nan saadna isnan tap-in di ipogaw.’ Siya di nan naisolat.” ");
INSERT INTO xnn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Dat itoloy Pedro ay mangwani en, “Isonga omila tako is maisokat ken Judas ta waday maitapi ken dakami is mangpaneknek isnan kasin natagowan Apo Jesus. Anapen tako nan ipogaw ay nakiib-a ken datako enggana isdin damo. Masapol ay inilana am-in nan inik-ikkan Jesus ay menlogi isdin ninpabonyagana ken Juan et enggana isdin naipangatowana id daya.” Siya di nan kinwanin Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dadat ibaga nan ngadan di doway ipogaw ay da Matias ken Jose ta mapili ken daida nan maisokat ken Judas. Nan tap-in nan ngadan Jose et Barsabas ya Justo. ");
INSERT INTO xnn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dadat menlowalo ay mangwani en, “Apo, gapo tay sik-a nan mangtek isnan nemnem am-in nan ipogaw et ipagtekmo ken dakami nan piliyem ken datona ay dowa ");
INSERT INTO xnn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ta maitapi ken dakami ay mang-ikkan isnan oblami ay aapostolis tasiyay siya nan maisokat ken Judas tay kinmaan ay omey isnan impilno.” Siya di nan lowaloda. ");
INSERT INTO xnn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dadat menbobonot ken datodi ay dowa. Et si Matias nan nabonot. Dat maitapi et maikasimpoo ya dowa ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Idi inomdan nan esay fiestan di Judio ay makwani en Pentecostes daet madagop am-in nan mamati ken Jesu Kristo isnan esay baey. ");
INSERT INTO xnn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dadat madanenge isnan kaneg ngengen di dagem ay nagapo id daya et pinmigsa isnan baey ay nadadagopanda. ");
INSERT INTO xnn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dadat ilan nan adoado ay kanega apoy ay masisiyan ay omey pomatong am-in isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dadat wasdin nakapet isnan Ispirito Santo et wasdin menkali isnan teken ay kali ay egayda solowen tay inpakalin nan Ispirito Santo daida. ");
INSERT INTO xnn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Isnan timpo ay deey wada id Jerusalem nan adoado ay Judio ay mangdaydayaw ken Apo Dios ay nagapo isnan kailiili isnan batawa. ");
INSERT INTO xnn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","8","Idi dinngeda san ninngengenge dadat madagop isnan kad-anda et nasdanasdaawda tay was-in nangdedenge isnan osto ay kalina isnan komalkaliyan nan apostolis. Nasdaawda ay mangwani, “Dan getken nan iGalilea ay naayda nan kalin di kailiili ay nagapowan tako? ");
INSERT INTO xnn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Datako pay iPartia, iMedia, iyElam, iMesopotamia, iJudea, iCapadocia, iPonto ya iyAsia. ");
INSERT INTO xnn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Wada pay nan iFrigia, iPamfilia, iyEgipto ya nan nagapo isnan tapin di ili id Libia ay as-asag-en id Cirene ya nan nagapo id Roma abes. ");
INSERT INTO xnn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nan tapi tako et Judio ngem nan tap-ina et baken Judio ngem solotenda nan ogalin di Judio. Nan tapi tako et iCreta ya nan tap-ina et iyArabia.” Kananda pay, “Dengngen tako ay kalkaliyenda nan nateketeken ay kali tako ay mangibaga isnan kaskasdaaw ay inikkan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nasdanasdaawda dadat men-asitotya ay mangwani, “Ngan nan aped mangtekan datona isnan nateketeken ay kali tako? Ngan nan kayat tona ay ibaga?” ");
INSERT INTO xnn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ngem wadada nan naitapi isnan kaipoipogaw ay mang-oy-oyaw isnan mamati ken Jesu Kristo ay mangwani en nabotengda. ");
INSERT INTO xnn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dat kanan Pedro ay mangipigsa isnan kalina ay mangitakdeg isnan simpoo ya doway apostolis ay mangwani en, “Dakayo ay iJerusalem ya am-in kayo ay ib-ami ay Judio, dedengngenyo pod nan kanak ta ibagak nan kayat tona ay kaliyen. ");
INSERT INTO xnn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Egay kami kaboteng ay kananyo. Getkenyo ay adi kaboteng nan ipogaw isnan olas di alas nowibi isnan wakgat. ");
INSERT INTO xnn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngem nan dinngeyo isnan menkalkaliyanmi isnan nateketeken ay kali et siya na nan inbagan din mamadton Apo Dios ay si Joel isnan nangibagaana isnan kinwanin Apo Dios. Kinwanina en, ");
INSERT INTO xnn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Siya na nan ik-ikkak isnan maod-odi ay agew. Awnitko ipakapet nan Ispiritok isnan kaipoipogaw. Nan an-akyo ay lalalaki ya bababai et awnitda ibagbaga nan itdok ken daida. Nan bababallo et awnit kaskasdaaw nan ipailak ken daida. Nan aamam-a et awnitda iitawen nan itdok ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Isnan siya di ay agew awnitko ipakapet nan Ispirito Santo isnan ibab-aak ay lalalaki ya bababai et enda ibagbaga nan itdok ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Awnit wada nan ipailak ay kaskasdaaw id daya ya isnan batawa tay awnit ipailak nan kabaelak ay kaneg naisoyat ay basa, apoy ya kaeegyat ay asok. ");
INSERT INTO xnn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Awnit bomolinget nan agew ya gomadangdang nan bowan ay kaneg basa. Siya di nan ommat esapay omdan nan napateg ay agew ay omaliyan nan Apo. ");
INSERT INTO xnn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Isonga mo sino nan menpabadang ken sak-en et daida nan maisalakan ay adiyak dosaen.’ Siya di nan kinwanin Apo Dios ay insolat din si Joel.” ");
INSERT INTO xnn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Dat itoloy Pedro ay mangwani en, “Dakayo ay ib-ak ay Judio, dengngenyo pod nan kanak. Si Jesu Kristo ay iNazaret et inpagtek Apo Dios ken dakayo ay siya nan inbaana tay adoado nan kaskasdaaw ay inik-ikkana ay mangipaila isnan kabaelana. Et getkenyo dana tay inilayo nan inpaikkan Apo Dios ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Id kasin et ninenemnem Apo Dios nan ommat ken Jesus. Et natongpal tay inpapateyyo isnan iRoma ay makedse ay ipogaw et inlansada isnan kros. ");
INSERT INTO xnn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ngem si Apo Dios et egayna ipalobos ay maitoloy ay matey si Jesus tay tinagona kasin. Tay nan tetey et maid kabaelana ay mangikawe ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si Jesus nan natongpalan din insolat David ay mangwani, ‘Getkek ay mamamamakkeyka, Apo Dios et olay no waday domateng is ligat adiyak omegyat tay wadaka ay bomadang. ");
INSERT INTO xnn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Isonga men-galalasingak et maila nan gasingko isnan kankanak tay patiyek ay adi madonot nan awakko ");
INSERT INTO xnn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tay getkek ay adika mangkalkalingking isnan kad-an di natey ya adim ipalobos ay madonot nan awakko tay sak-en nan mangtongtongpal ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inpagtekmo nan ikkak tapno matatagowak ay eng-enggana et palalo nan gasingko tay makiteteak ken sik-a.’ Siya di nan insolat din si David.” ");
INSERT INTO xnn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Dat itoloy Pedro, “Dakayo ay bebsatko, laydek ay ipagtekko ay osto ken dakayo nan maipanggep ken David ay ali tako id kasin. Din si David et baken nan awakna is kinwanina tay natey et naikaob. Et daan ay mamaila nan naikaobana id wani. ");
INSERT INTO xnn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ngem gapo tay mamadton Apo Dios din si David isonga gintekna ay awnit tongpalen Apo Dios nan insapatana ay awnit wada nan bomala ay apona ay mangsokat ken siya ay men-ali et si Kristo. ");
INSERT INTO xnn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gintek David ay awnit tomet-ewa nan inbagan Apo Dios maipanggep isnan kasin matagowan nan awnit men-ali ay si Kristo isonga kinwanina en adi kakalkalingkingan ay adi madonot nan awakna isnan kad-an di natey.” ");
INSERT INTO xnn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dat itoloy Pedro ay mangwani en, “Si Jesus din inbagan din si David tay siya nan tinagon Apo Dios. Mabalin ay ibagami ken dakayo tay inilami am-in ay natago siya. ");
INSERT INTO xnn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ngem id wani wada si Jesus id daya isnan makanawan Apo Dios ay Amana ay kad-an di madaydayaw. Et intedna ken Jesus nan epdasna inkali ken siya et siya nan Ispiritona ay inpaalina ken dakami. Isonga dinngeyo ya inilayo nan menkalkaliyanmi isnan nateketeken ay kali. ");
INSERT INTO xnn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Baken nan awakna is kinwanin David tay egay inmey nan awakna id daya nodi si Jesus nan inmey isonga kinwanin David nan maipanggep ken siya ay mangwani en, ‘Kinwanin Apo Dios ken Kristo ay Ap-apok en tomokdoka isnan makanawanko ");
INSERT INTO xnn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","enggana ay abakek am-in nan bosom ta sik-a nan Apo.’” ");
INSERT INTO xnn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Dat itoloy Pedro ay mangwani, “Isonga dakayo ay ib-ami ay Judio, masapol ay getkenyo ay gawis ay si Jesus ay pinateyyo et siya nan pinabalin Apo Dios is Apo tako ya Ali tako ay kanan tako en Kristo.” ");
INSERT INTO xnn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Idi dinngen nan kaipoipogaw nan kinwanin Pedro dat dadama nan seg-angda tay daida nan nangipapatey ken Jesus. Dadat kanan ken da Pedro, “Gagayyem, sino nan ikkanmi tapno makaan nan naay basolmi?” ");
INSERT INTO xnn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Dat kanan Pedro ken daida, “Wasdin mangdokog is basolna dat menpabonyag ay mangipagtek ay apowena si Jesu Kristo tapno pakawanena nan basolyo et itedna nan Ispirito Santo ta komapet ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tay nakitolag si Apo Dios ay mangwani en, ‘Am-in kayo ay ayagak et awnit komapet nan Ispirito Santo ken dakayo ya nan an-akyo ya nan ap-oyo, olay nan ipogaw ay baken Judio olay sino ay ipogaw ay ayagak et makapetda isnan Ispirito Santo.’” ");
INSERT INTO xnn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Menkalkali kayet si Pedro ay mangtogon ken daida ay mangwani en, “Masapol ay dokoganyo nan basolyo ta adi kayo maitapi isnan ipogaw ay madosa isnan impilno ay eng-enggana gapo isnan ngawi ay ik-ikkanda.” ");
INSERT INTO xnn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dat adoado nan mamati ken Jesus et ninpabonyagda. Omey ay tolo ay libo nan bilang nan mamati isnan agew ay deey et maitapida issan deeyda ay namati isnan damo. ");
INSERT INTO xnn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nan mamati et kaageagew ay madagdagopda ta dengngenda nan it-itdon nan aapostolis. Isnan madagdagopanda et makilol-owalo ya makiap-apatda maipanggep isnan kankanan Apo Dios dadapay makikikan isnan kanemneman nan nateyan Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nan aapostolis et adoado nan inik-ikkanda ay kaskasdaaw ay mangipaila isnan kabaelan Apo Dios et inmegyat am-in nan ipogaw isnan il-ilaenda. ");
INSERT INTO xnn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Intoltoloy nan deeyda ay mamati ken Jesus ay madagdagop et pinos-ada am-in nan kok-owada tapno maiwalas ken daida am-in. ");
INSERT INTO xnn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Dadat omilako isnan payewda ya isnan kokwada ta ipigasanda nan ib-ada ay makasapol. ");
INSERT INTO xnn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Intoltoloyda ay madagdagop isnan Templon Apo Dios id isdi Jerusalem ay kaageagew. Makiol-olnosda ay maob-obong ay mangmangan isnan bab-aeyda et dadama nan gasingda tay napopos-a nan nemnemda. ");
INSERT INTO xnn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Daydayawenda si Apo Dios et am-in nan omili id Jerusalem olay nan adi mamati ken Jesus, kananda en gawigawis nan ik-ikkan nan deeyda ay mamati ken Jesus. Inagew ay tapiyan Jesus nan mamati ken siya ay maisalakan. ");
INSERT INTO xnn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Isnan namingsan et inmey da Pedro ken Juan isnan Templo isnan alas tres isnan masdem tay siya nan olas ay menlowalowan di ipogaw isdi. ");
INSERT INTO xnn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Isnan segpan ay nginadnanda is Menbegew et wada nan am-ama ay pilay enggana isdin binmalaana. Winakgat ay aw-awitenda siya ay mang-eyey isnan Templo ta menlimlimos isnan songsonggep. ");
INSERT INTO xnn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Idi ilana da Pedro ken Juan ay songgep isnan Templo daet menlimos ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dadat ikikiyat siya dat kanan Pedro, “Ilam dakami.” ");
INSERT INTO xnn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Danat ilan daida ta baleng waday itedda ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ngem dat kanan Pedro, “Maid polos sipingmi ngem nan kabaelan Apo Jesus ay iNazaret et siya nan wada ay ibadangmi ken sik-a.” Danat kanan, “Mendaanka.” ");
INSERT INTO xnn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dat gen-an Pedro nan kanawan ay ledengna ta patakdegena daet naganawis nan sikina. ");
INSERT INTO xnn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Dat matanakdeg et mendaan ta makkey ken da Pedro yas Juan ay songgep isnan Templo. San napilay et mendad-aan ay menyakyaking ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Am-in nan ipogaw et inilada siya ay mendad-aan ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dadat imatonan ay siya san menlimlimos issan segpan ay makwani en Menbegew. Dadat masdaaw tay makadaan. ");
INSERT INTO xnn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Isnan nanggegen-anan nan napilay ken da Pedro ken Juan dat matanagtag nan kaipoipogaw ay omey isnan kad-anda isnan kanandan Bangsal Solomon tay pilmi ay masdaawda. ");
INSERT INTO xnn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Inilan Pedro nan kaipoipogaw danat kanan ken daida, “Dakayo ay ib-ami ay Judio, dakayon masdaaw ay mangwani en dan makadaan si tona? Dakayon ikikiyat dakami? Ay kananyo en gapo tay gawis kami ay ipogaw wenno nan kabaelanmi nan nangipagawis ken tona? ");
INSERT INTO xnn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Baken dakami tay si Apo Dios ay dinaydayaw din alal-apo tako ay da Abraham ken Isaac yas Jacob nan nangipagawis ken siya ta madayaw si Jesus ay inbaana ken datako. Ngem indalomyo siya isnan iRoma dayopay inadyan isnan nangbistaan Pilato ken siya olay linayad Pilato ay ipalobos siya. ");
INSERT INTO xnn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ay apo kayo, inadyanyo nan gawigawis ay ipogaw ay maid polos basolna dayopay aped piliyen nan ninpatey is ipogaw is kayatyo ay mapalobosan. ");
INSERT INTO xnn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Si Jesus ay mang-ited isnan biyag ay maid patenggana et siya nan pinateyyo. Ngem kasin tinagon Apo Dios siya et ibagbagami ay tet-ewa ay kasin natago tay inilami. ");
INSERT INTO xnn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Gapo isnan kabaelan nan olay ngadan Jesus isonga ginmawis nan pilay nan ipogaw ay naay. Si Jesus nan nangipapigsa isnan nemnemna ay mamati ken siya isonga iilaenyo am-in ay nakaan nan pilayna.” ");
INSERT INTO xnn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Dat itoloy Pedro ay mangwani en, “Dakayo ay bebsatko, getkek ay egayyo getken nan saad Jesus isonga inpapateyyo. Olay nan ap-apoyo et egayda getken. ");
INSERT INTO xnn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nan inikkanyo ay mangpatey ken siya et siya din inbagan Apo Dios isdin mamadtona id kasin tay inbagada en nan pinilin Apo Dios ay mentolay et masapol ay mapaligatan ya matey gapo isnan basbasol di ipogaw. Et siya di nan natongpalan nan kinwanina. ");
INSERT INTO xnn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Isonga dokoganyo nan basolyo ta nemnemenyo si Apo Dios ta kaanena nan basolyo ya itedna nan nasimpa ay nemnem ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","21","Si Jesus et id wani masapol ay id daya nan kad-ana enggana isnan timpo ay kasin pagawisen Apo Dios nan am-in. Ngem awnit ibaana kasin si Jesus is Ali tako ay makwani en Kristo tay siya di nan sigod ay inbagan Apo Dios isdin mamadtona enggana id kasin.” ");
INSERT INTO xnn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Dat itoloy Pedro ay mangwani en, “Olay din si Moses et kinwanina en, ‘Awnit dotokan Apo Dios nan esay ipogaw isnan ib-a tako is mamadto ay kaneg nan inikkana ay nangdotok ken sak-en et ipootyo ay mangdenge am-in isnan kankanana. ");
INSERT INTO xnn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nan ipogaw ay adi mamati isnan kankanan nan mamadton Apo Dios ay deey et awnitda maisiyan isnan ipogawna et madosada ay eng-enggana.’ ");
INSERT INTO xnn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Siya met laeng din kinwanin din am-in ay mamadton Apo Dios ay menlogi ken Samuel. Tay inbagada nan maik-ikkan isnan timpo tako id wani. ");
INSERT INTO xnn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Datako id wani et naitapi tako abes isnan inpabagan Apo Dios isdin mamadtona. Naitapi tako abes isnan nakitolagan Apo Dios isdin alal-apo tako tay kinwanina ken Abraham en, ‘Awnitak osalen nan esa ay Apom ay mangbadang isnan kaipoipogaw isnan batawa’. ");
INSERT INTO xnn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Isonga inbaan Apo Dios nan Anakna ta omali isnan batawa et datako ay Judio nan damdamo ay inmaliyana tay layden Apo Dios ay bomadang ken datako ta dokogan tako nan ngawi ay ik-ikkan tako.” Siya di nan kinwanin Pedro ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Daan ay menkalkali da Pedro isnan kaipoipogaw dat omey nan papadi ya nan apon di gogowaldiyan di Templo ya nan tap-in di Judio ay Saduceo isnan kad-an da Pedro. Nan Saduceo et daida nan mangwani en adi kasin matago nan matey ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Makaligetda tay isolsolon da Pedro en kasin natago si Jesus isonga tet-ewa ay kasin matago nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Isonga dadat ikawe daida et eyeyda isnan pagbalodan. Ngem gapo tay nasdem et, apedda inbalod daida ta mawakgat esadapay masomalya. ");
INSERT INTO xnn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Adoado nan mamati isnan deeyda ay nangdedenge isnan kinkinwanin da Pedro. Nan kabibilang nan aamam-a ay mamati ken Jesus et omey ay limay libo. ");
INSERT INTO xnn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Idi nawakgat nadagop id Jerusalem nan menlelebbeng isnan ilida, nan aamam-a ya nan men-is-isolo isnan linteg Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dadat menmimiting ken da Caifas, Juan ya si Alejandro yas Anas ay kangatowan ay padi ya nan tap-in di agin Anas. ");
INSERT INTO xnn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dadat ipatakdeg da Pedro ken Juan isnan sasagangenda ta somalyaenda daida. Dadat kanan ken daida. “Sino nan kangadan isnan kananyo en nangipagawis isnan napilay ay naay? Sino nan nang-idya isnan kabaelanyo ay mangipagawis ken siya?” ");
INSERT INTO xnn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dat itdowan nan Ispirito Santo si Pedro is isongbatna et kanana, “Dakayo ay ap-apomi ya aam-ami, ");
INSERT INTO xnn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","no maipanggep isnan gawis ay inikkanmi ay nangkaan isnan sakit nan pilay nan isomalyayo ken dakami ya no ngan nan inikkanmi ay nangipagawis ken siya et ");
INSERT INTO xnn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dengngenyo tay masapol ay getkenyo ya nan am-in ay ib-a tako ay Judio. Si Jesu Kristo ay iNazaret nan nang-idya isnan kabaelanmi ay mangkaan isnan sakitna. Et siya nan inlansayo isnan kros ngem tinagon kasin Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nan inpasolat Apo Dios ay mangwani en, ‘Nan bato ay inadyan di ninsaad is baey et siya nan kapatgan tay ipapaknegna nan baey.’ Et si Jesus nan naiyaligana. Owen si Jesus nan kapatgan. ");
INSERT INTO xnn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tay maid teken is mabalin ay mangisalakan ken datako no baken si Jesus tay kedkedeng siya is inbaan Apo Dios ay mangisalakan isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Idi nakakali si Pedro dat kanan nan menlelebbeng, “Dan datona ay dowa nan natoled ay mangsongbat ken datako ay ap-apoda? Egayda nakaadal dadapay getken ay mangsongbat ken datako.” Masdaawda dadat nemnemen en daida nan nakiboweg ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dapay san menlelebbeng et maid isongbatda tay wada san napilay ay makitatakdeg ken da Pedro et mamagtek ay tet-ewa nan kankananda. ");
INSERT INTO xnn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Isonga nan inikkanda et inpabalada da Pedro ken Juan ya san napilay ta ikekedeng nan menlelebbeng is menkalkali. ");
INSERT INTO xnn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Dadat mentototya ay mangwani en, “Ngan di ikkan tako ken datodi tay tet-ewa ay kaskasdaaw nan inikkanda isnan napilay et getken am-in nan omili id Jerusalem isonga adi mabalin ay kanan tako en baken tet-ewa.” ");
INSERT INTO xnn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dadat kanan en, “Ibaga tako ken daida en madosada no kasinda sodsodoken si Jesus ta adi dengngen nan kaipoipogaw modatya patiyenda.” ");
INSERT INTO xnn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dadat kasin ayagan da Pedro et ibagada ken daida ta adida kasin sodsodoken si Jesus ya adida isolsolowan nan ipogaw maipanggep isnan ngadana. ");
INSERT INTO xnn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ngem da Pedro ken Juan et sinmongbatda ay mangwani en, “Nemnemenyo no sino nan layden Apo Dios. Ay dakayo nan osto ay patiyenmi wenno si Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Adi mabalin ay isaldengmi ay mangibagbaga isnan inil-ilami ya dindinngemi ay maipanggep ken Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dat eg-egyaten nan menlelebbeng da Pedro esadapay palobosan daida tay adida getken nan ikkanda ay mangdosa ken daida tay omegyatda isnan kaipoipogaw tay daydayawenda si Apo Dios gapo isnan inikkan da Pedro isnan napilay. ");
INSERT INTO xnn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kaskasdaaw nan ginmawisan nan napilay tay solok is epatpoo nan tew-ena. ");
INSERT INTO xnn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Idi naipalobos da Pedro ken Juan dadat omey isnan ib-ada ay mamati ken Jesus. Dadat ibaga nan kinwanin nan menkangangato ay papadi ya nan aamam-a ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Idi dinnge nan ib-ada dadat makilowalo ay mangdayaw ken Apo Dios ay mangwani en, “Apo, sik-a nan nangboliw isnan daya, nan batawa, nan baybay ya nan am-in ay mentetee. ");
INSERT INTO xnn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Olay din alapomi ay din si David ay esay ipogawmo et inpabagan nan Ispirito Santo ken siya nan insolatna ay, ‘Dan aped menpapangato ken Apo Dios nan ipogaw ay baken Judio? Dan aped nemnemen nan Judio ay mang-ik-ikkan isnan ol-olay ay maid silbina ay mang-apos ken Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mensagana nan alin di kailiili et madagop abes nan menkangangato ay ipogaw ta gobatenda si Apo Dios ya nan Anakna ay makwani en Kristo.’ ");
INSERT INTO xnn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Et natongpal san deey ay kinwanin David tay nadagop nan ib-ami ay Judio ya nan baken Judio ya nan ap-apo ay da Herod ken Poncio Pilato id Jerusalem ta mentotyada ay mangpatey ken Jesus ay mangtongtongpal ken sik-a dapay siya nan dinotokam ay mentolay isnan am-in ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inikkanda ken Jesus nan ninenemnemmo ay ommat gapo isnan kayat ya panakabalinmo. ");
INSERT INTO xnn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Id wani, Apo, ilam pod nan ik-ikkanda ay mangipaegyat ken dakami ay inbaam. Et anayam nan toledmi ay mamati ken sik-a ta ibagbagami kayet nan kankanam. ");
INSERT INTO xnn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pagawisem nan masaksakit ay ipogaw et ipailam nan kaskasdaaw ay maikkan gapo isnan kabaelan Jesus ay mangtongtongpal ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Idi nakalowaloda daet mawedwed nan baey ay menteteanda dat takdowen nan Ispirito Santo daida dadat amed tomoled ay mangibagbaga kayet isnan kankanan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nan am-in ay mamati ken Jesus et makiolnosda isonga am-in nan kok-owada et pinos-ada ta kowada am-in ay maid mangibobokod. ");
INSERT INTO xnn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pilmi nan kabaelan nan aapostolis ay mangibagbaga isnan nang-il-anda ken Apo Jesus ay kasin natago. Et gawigawis nan badang Apo Dios ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Am-in nan mamati et maid kolangda tay nan wada nan payewna wenno baeyna danat ilako et itedna nan lakona ");
INSERT INTO xnn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","isnan aapostolis ta iwalasda isnan makasapol. ");
INSERT INTO xnn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Siya nan inikkan Jose ay esay iChipre ay esay apon din si Levi. Nan inpangadan nan aapostolis ken siya et Bernabe tay nan kayatna ay kanan et ipogaw ay mangipagasing is nemnem di napaligatan. ");
INSERT INTO xnn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nan inikkana et nin-ilako is payewna danat ited nan lakona isnan aapostolis. ");
INSERT INTO xnn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wada pay nan esay am-ama ay kangadan is Ananias ya nan asawana ay si Safira. Inlakona nan ib-an nan kokwada. ");
INSERT INTO xnn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dadat mentoya ay sin-asawa ta igagoda nan tap-in nan lakona. Danat ited nan tap-ina isnan aapostolis ay mangwani, “Naay nan lakon nan kokwami.” ");
INSERT INTO xnn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ngem kinwanin Pedro, “Ananias, damen patiyen nan kanan Satanas ken sik-a? Nan Ispirito Santo nan pinadasmo ay sikapan tay isotmo nan tap-in nan lakona. ");
INSERT INTO xnn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Isnan egayna kailakowan, kokwam. Et sik-a nan kigad is ikkam isnan lakona. Ngem dayon aped nemnemen ay mang-ikkan isnan naay? Baken met aped ipogaw nodi si Apo Dios nan pinadasyo ay sikapan.” ");
INSERT INTO xnn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dinngen Ananias nan kankanan Pedro dat aped matokang et matey. Dat am-in ay mangdedenge isnan inommat ken Ananias et pilmi nan egyatda ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dat pomika nan bababallo et bongonenda nan awakna dadat ibala et ikaobda. ");
INSERT INTO xnn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nallos nan waay toloy olas dat omey nan asawana ngem egayna getken ay natey san asawana. ");
INSERT INTO xnn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dat kanan Pedro ken siya, “Ibagam mo tet-ewa ay siya na nan osto ay lakon nan inlakoyo ay kowayo.” Dat kanan nan babai en, “Tet-ewa ay siya sa.” ");
INSERT INTO xnn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dat kanan Pedro ken siya, “Dakayon nintolag ay mangsiksikap isnan Ispiriton Apo Dios? Ilam, naay omali nan nangikaob ken asawam esadat abes isoblat sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dat matokang et matey abes siya. Sinonggep san deeyda ay bababallo et idi ilaenda ay natey dadat ibala ay en mang-idlen isnan naikaoban asawana. ");
INSERT INTO xnn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Dat nan mamati ken Jesus ya nan am-in ay nangdedenge isnan inommat et inmegyaegyatda. ");
INSERT INTO xnn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nan aapostolis et adoado nan kaskasdaaw ay inik-ikkanda ay inilan nan ipogaw. Nan osto ay nadagopan nan deeyda ay mamati ken Jesus et nan bangsal nan Templon Apo Dios ay makwani en Bangsal Solomon. ");
INSERT INTO xnn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dinayaw am-in nan ipogaw daida ngem omegyatda ay maitapi ken daida no egayda mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ngem inmadoado met laeng nan aamam-a ya iinin-a ay naitapi ay mamati ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gapo isnan inik-ikkan di aapostolis et inpabala nan ipogaw nan masaksakit dadat eyey isnan kalsa dadat ipapodan daida isnan kamada wenno isnan abekda. Tay kananda en ta moke lomaos si Pedro et olay no kedeng nan alin-ewna is manglingeb ken daida et makaan nan sakitda. ");
INSERT INTO xnn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Adoado pay nan nagapo isnan kailiili ay as-asag-en id Jerusalem et ey-eyeyda nan masaksakit ya nan kinapet di anito et ginmawisda am-in. ");
INSERT INTO xnn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gapo isnan kabaelan nan aapostolis et linmiget nan kangatowan ay padi ya nan iib-ana ay Saduceo gapo isnan apalda. ");
INSERT INTO xnn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Dat nan inikkanda et inmeyda ay mangdepap isnan aapostolis dadat eyey daida isnan pagbalodan. ");
INSERT INTO xnn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ngem isnan labi, inmey nan esay anghel Apo Dios et tokabana nan eneb nan pagbalodan danat ipabala daida ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Enkayo isnan Templo ta ibagayo isnan ipogaw nan maipanggep isnan biyag ay maid patenggana.” Siya di nan kinwanin nan anghel. ");
INSERT INTO xnn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Isonga idi pinmat-a dadat omey isnan Templo ay men-isolo. Mawakgat pay dat ayagan nan kangatowan ay padi ya nan iib-ana am-in nan menlelebbeng ya nan aamam-a ta menmitingda. Dadat omibaa is omey isnan pagbalodan ta ayaganda nan aapostolis. ");
INSERT INTO xnn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Omdan pay nan deeyda ay gowaldiya ay inbaada dadat ilaen ay maiwed san aapostolis. Dadat somagong ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nan kananyo ay ayaganmi et maidda. Inilami nan pagbalodan et daan ay naeemban ya daan ay naikakandado. Wada abes nan gowaldiya ay tomatakdeg isnan segpan. Ngem idi tinokabanmi et maid ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Idi dinngen nan menkangangato ay papadi ya nan ap-apon di gogowaldiyan di Templo nan kinwanin nan deeyda ay binaada dadat kanan isnan nemnemda en, “Ngan ngata nan awnit ommat gapo ken daida?” ");
INSERT INTO xnn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dat wada nan inmey ay mangibaga en, “San deeyda ay binalodyo et wadada isnan Templo ay men-is-isolo isnan ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dat omey nan deeyda ay gowaldiya ya nan ap-apoda ay mang-ala ken daida ngem egayda goyoden daida isnan nang-ayaganda ken daida tay omegyatda isnan kaipoipogaw modatya gayangenda daida tay daydayawen nan ipogaw nan aapostolis. ");
INSERT INTO xnn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Dadat eyey nan aapostolis isnan menmitmitingan nan deeyda ay menlelebbeng. Dat kanan nan kangatowan ay padi en, ");
INSERT INTO xnn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Binilbilinmi dakayo ta adiyo isolsolo nan maipanggep ken Jesus. Dapay id wani et maid polos egay nangdenge isnan isolsoloyo id Jerusalem. Et kanegyo layden ay madosa kami isnan nateyan Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sinmongbat da Pedro ya nan iib-ana ay apostolis ay mangwani en, “Masapol ay patiyenmi nan inbagan Apo Dios ken dakami ta ibagbagami nan maipanggep ken Jesus isonga baken nan kananyo ay aped ipogaw is patpatiyenmi. ");
INSERT INTO xnn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tet-ewa ay pinateyyo si Jesus ya inlansayo isnan kros ngem si Apo Dios ay dinaydayaw din alal-apo tako et tinagona kasin siya. ");
INSERT INTO xnn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Danat ipangato siya ta tomokdo isnan makanawana ta siya nan men-ap-apo ya siya nan mangisalsalakan ken datako tasiyay mawayaan tako ay Judio ay menbabawi tapno pakawanen Apo Dios nan basbasol tako. ");
INSERT INTO xnn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Dakami nan nang-ila ay tet-ewa isonga ibagami ken dakayo. Et nan Ispirito Santo ay inpakapet Apo Dios ken dakami ay mamati ken Jesus nan mangpaneknek ay tet-ewa nan kankananmi isnan mangipaik-ikkanana ken dakami isnan kaskasdaaw.” Siya di nan kinwanin Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Isnan nangdengngan nan deeyda ay menlelebbeng isdi et nakaligetda isonga kayatda ay pateyen daida. ");
INSERT INTO xnn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ngem wada nan esay Fariseo ken daida ay kangadan is Gamaliel. Siya nan esay men-is-isolo isnan linteg Apo Dios et siya nan ikabain nan ib-ana. Tinmakdeg ay mangibaga ta ikaanda san aapostolis is sin-awyan. ");
INSERT INTO xnn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Inpabalada daida dat kanan Gamaliel, “Dakayo ay ib-ak ay Judio, nemnemen tako ay gawis nan ikkan tako ken datona. ");
INSERT INTO xnn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nemnemenyo nan inommat id kasin tay no maid si Apo Dios isnan ipogaw et mamaid nan itdoda. Kaneg din binmal-an Teudas ay aped nangipangato isnan awakna issan kaat todi ngen ay tew-en et sinmolot nan waay epat gasot ay ipogaw ken siya. Ngem napatey siya et aped naboka nan papasolotna et namaid nan insolsolona. ");
INSERT INTO xnn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nakwas di dat wada si Judas ay iGalilea isdin timpon di nasinsosan di ipogaw. Adoado abes nan naawis ay nakiboweg ken siya. Ngem napatey abes dat maboka nan namati ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Isonga nan ibagak ken dakayo id wani et adiyo paligaten nan naayda ay ipogaw. Bay-anyo daida tay siya met laeng nan ommat no aped nan nemnemda nan nagapowan nan isolsoloda ya ik-ikkanda tay awnit mamaid abes. ");
INSERT INTO xnn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ngem no si Apo Dios nan nang-idya isnan kabaelanda et adi mabalin ay ipasaldengyo. Isonga adiyo itoltoloy ay mang-aamis ken daida modatya si Apo Dios nan aamisenyo.” Siya di nan kinwanin Gamaliel. ");
INSERT INTO xnn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Et siya di nan pinatida. Isonga kasinda inpaayag daida et ipabaibaigda daida. Dadat kanan, “Adi kayo kasin men-is-isolo isnan maipanggep isnan ngadan Jesus.” Dadat palobosan daida. ");
INSERT INTO xnn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Napalobosanda dadat taynan nan deeyda ay menmitmiting et men-gasingda tay maawatanda ay getken Apo Dios ay adida omegyat olay no mabainanda maipanggep isnan it-itdoda ay maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Isonga winakgat ay om-omeyda kayet isnan Templo ya nan am-in ay bab-aey ay mangisolsolo ay si Jesus nan Kristo ay inbaan Apo Dios ay mentoltolay isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Issan timpo ay deey isnan inmad-adowan nan mamati ken Jesus et nin-asisongbat nan mamati ay Judio ya nan iib-ada ay Judio ay naiyanak isnan teken ay ili ay Griego nan kalida. Dat menlili nan kakali is Griego ay mangwani en, “Apay nga mabaybay-an nan bababaimi ay balo isnan maiwalasan nan makan isnan inagew?” ");
INSERT INTO xnn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Isonga inpaayag nan aapostolis am-iam-in nan deeyda ay mamati ken Jesus dadat kanan, “Adi mabalin ay mataktaktak kami isnan oblami ay mangibagbaga isnan kankanan Apo Dios ay maipanggep ken Jesus ta dakami nan mangiwalwalas is makan. ");
INSERT INTO xnn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Isonga dakayo ay kadwami ay mamati ken Jesus et pomili kayo is pito ay nalaing ay amam-a ay managpati isnan Ispirito Santo ta daida nan dotokanmi ay mangiwalas isnan makan. ");
INSERT INTO xnn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tapno dakami pay ay aapostolis et mabalin ay eesangenmi ay menlol-owalo ya mangibagbaga isnan maipanggep ken Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dat iyoog am-in nan mamati ken Jesus nan kinwanin nan aapostolis. Et datona nan pinilida. Nan esa et si Esteban. Managtongpal isnan Ispirito Santo ya napigsa nan pammatina ken Jesus. Nan ib-ana et da Felipe, Procoro, Nicanor, Timon, Parmenas ya Nicolas ay iyAntiokia. Baken Judio si Nicolas ngem solsolotena nan ogalin di Judio. ");
INSERT INTO xnn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Dadat eyey daida isnan aapostolis. Dat menlowalo nan aapostolis dadapay ipatang nan ledengda isnan olon nan deeyday pito tay siya nan ikkanda ay mangdotok ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Isonga inmad-ado nan nangdengdenge isnan kalin Apo Dios dat omadoado abes ay mamati ken Jesus id Jerusalem. Olay nan papadi et adoadoda ay mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban pay et kaskasdaaw nan inik-ikkana isnan ipogaw tay binadangan Apo Dios siya et adoado nan intedna ay kabaelana. ");
INSERT INTO xnn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ngem wadada nan ipogaw isnan sinagogan di Libertino, ay Judio ay nagapo id Cirene ya id Alejandria ya Judio ay iCilicia ya iyAsia et nakisongbatda ken Esteban. Ngem adida makaabak ken siya tay ");
INSERT INTO xnn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","initdowan nan Ispirito Santo siya isonga nalaing ay komali. ");
INSERT INTO xnn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Dadat lagbowen nan ipogaw ta menkampotda ay mangwani en, “Dinngemi nan kinwanin Esteban et aposena din si Moses yas Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Isonga nan kaipoipogaw ya nan aamam-a ya nan men-is-isolo isnan linteg Apo Dios et nakaligetda ken Esteban gapo isnan kinwanin nan deeyda ay menkampot. Dadat ikawe si Esteban et eyeyda isnan menlelebbeng. ");
INSERT INTO xnn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Dadat ipatakdeg san deeyda ay menkamkampot ay mangwani en, “Si Esteban et adi somalsaldeng ay mang-ap-apos isnan linteg ay initdon din si Moses ya ngawi nan kankanana maipanggep isnan Templo ");
INSERT INTO xnn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","tay dinngemi nan nangwaniyana en awnit dadaelen Jesus ay iNazaret nan Templo tako ya sokatana nan linteg ay initdon din si Moses ay tinawid tako.” ");
INSERT INTO xnn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iilan pay nan deeyda ay menlelebbeng si Esteban dadat ilaen ay somilang nan angasna ay kaneg angas di anghel. ");
INSERT INTO xnn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dat kanan nan kangatowan ay padi ay mangitaktakdeg isnan Judio ken Apo Dios ken Esteban en, “Ay tet-ewa nan kankanan datona?” ");
INSERT INTO xnn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Dat kanan Esteban ay mangwani en, “Dakayo ay ap-apok ya aam-ak ya bebsatko, nemnemenyo pod nan inik-ikkan Apo Dios ken datako ay Judio enggana id kasin. Si Apo Dios ay kangatowan et ninpaila ken Abraham ay din alapo tako isdin ninteteana id Mesopotamia isdin egay pay laeng nin-alisana id Haran. ");
INSERT INTO xnn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Et kanan Apo Dios ken siya, ‘Komaanka isnan iliyo ay naay ta taynam nan agiyo ta enka isnan ili ay awnitko itdo ken sik-a.’ ");
INSERT INTO xnn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Isonga kinmaan si Abraham id Mesopotamia ay mentetean nan ipogaw ay makwani en Caldeo et inmey nintetee id Haran. Idi natey din amana dat ipangon Apo Dios siya isnan naay ili ay mentetean tako id wani. ");
INSERT INTO xnn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Issan inmaliyan Abraham isnan kad-an tako id wani et maid polos inidyan Apo Dios is dagana is olay teeteen. Ngem nakitolag si Apo Dios ay mangwani en awnitna idya ken siya ta ipatawidna isnan anakna ya nan ap-ona. Isnan nangwaniyana isdi et maid pay laeng anak da Abraham. ");
INSERT INTO xnn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Et siya na nan tap-in nan inbagan Apo Dios ken Abraham. Kinwanina en awnit omey nan ap-ona isnan ilin di teken ay ipogaw et awnitda mapilit ay menpabaa ay maid lagboda ya awnit maligligatan am-in nan ap-ona enggana ay makwas nan epat gasot ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ngem kanan Apo Dios en, ‘Awnitko dosaen nan deeyda ay ipogaw ay mangpaligat isnan ap-om. Et gapo isnan madosaanda et awnitda ipalobos nan ap-om ay komaan isdi ay omali kasin ay mangdaydayaw ken sak-en id isna.’” ");
INSERT INTO xnn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dat itoloy Esteban ay mangwani en, “Wada nan inbilin Apo Dios ken daida ta waday mangnemnemnemanda isnan nakitolagan Apo Dios ken daida. Et siya nan nangsegyatanda isnan an-akda ay lalalaki. Isonga idi binmala nan anak Abraham ay si Isaac et isnan maikawao ay agewna siya nan inikkan amana ken siya. Et siya met laeng nan inikkan Isaac isnan anakna ay si Jacob. Siya abes nan inikkan Jacob isnan simpoo ya dowa ay an-akna ay lalalaki ay kanan tako en am-a tako id kasin. ");
INSERT INTO xnn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Din deeyday am-a tako ay an-ak Jacob et inapalanda nan innodida ay si Jose. Isonga inlakoda siya isnan iyEgipto ta eyeyda isnan ilida ta mabab-aa ay adi kalagbo. Ngem si Apo Dios et wada kayet ken siya ");
INSERT INTO xnn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","et binadbadangana siya isnan naligligatana. Gapo tay wada si Apo Dios ken siya ya wada nan intedna ay laingna et laylayden nan alin di Egipto ay makwani en Faro si Jose. Danat dotokan siya ay men-gobilnadol isnan am-in ay ili id Egipto ya men-ap-apo abes isnan am-in ay ipogaw isnan baey Faro. ");
INSERT INTO xnn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dat domateng nan bitil isnan kailiili id Egipto ya id Canaan et napalipaligatan nan ipogaw. Din deeyday am-a tako ay an-ak Jacob et maid ikkanda ay omanap is kanenda. ");
INSERT INTO xnn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Isonga idi dinngen Jacob ay wada nan kasaoyan di makan id Egipto danat ibaa nan iiyon-an Jose ta omeyda manaoy is kanenda. Siya di nan damo ay inmayanda. ");
INSERT INTO xnn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Isnan ikadwa ay inmayanda et ninpagtek si Jose ken daida. Danat ipagtek abes daida ken Faro. ");
INSERT INTO xnn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Danat ipaayag da amana ay si Jacob ya nan am-in ay ag-ida ta omeyda id Egipto. Pitompooda ya lima am-in. ");
INSERT INTO xnn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Inmey da Jacob am-in id Egipto. Et siya nan ninteteana enggana ay natey. Siya abes nan nateyan nan an-akna ay din am-a tako. ");
INSERT INTO xnn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ngem naisas-aa nan awakda id Sikem et naikak-aobda isnan liyang ay linakowan Abraham isnan an-ak Hamor isdi.” ");
INSERT INTO xnn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Dat itoloy Esteban ay mangwani en, “Nganngani ay omdan nan nakitolagan Apo Dios ken Abraham et inmad-ado nan ap-on Jacob ay din alal-apo tako. ");
INSERT INTO xnn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Isdin deey ay timpo et wada nan naisokat ay ali ay egay nangtek isdin gawis ay inik-ikkan din si Jose tay adoado nan nallos ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nan ali et siniksikapana din alal-apo tako et pinaligatna daida ya inpapatina ay mabaybay-an nan kaengaenga ta mateyda tasiyay adida omad-ado. ");
INSERT INTO xnn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Et siya di nan timpo ay naiyanakan Moses ay menbelelegew ay onga et linaylayad Apo Dios siya. Toloy bowan nan nangpasososowan inana ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Idi adida makaigago ken siya dadat baybay-an. Ngem dinatngan nan esay babai ay anak nan ali danat alan et talaknena ay kanegna anak. ");
INSERT INTO xnn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Et naisolowan si Moses isnan am-in ay adal nan iyEgipto et nalailaing ay mangmangwani isnan kankanana ya mang-ik-ikkan isnan ik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Idi epatpoo nan tew-en Moses danat kayten ay omey ilan nan kadalaana ay ap-on Jacob. ");
INSERT INTO xnn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isnan inmayana et inilana ay am-amisen nan esay iyEgipto nan esay kailiyana. Dat omey ta badangana nan napaligatan et pateyena nan iyEgipto. ");
INSERT INTO xnn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tay kanan Moses en waay gintek nan kadalaana ay siya nan pinilin Apo Dios ay mangipalobos ken daida isnan mapalpaligatanda ngem egayda obpay maawatan. ");
INSERT INTO xnn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Idi kasin napseng dat mensape nan doway ipogaw ay ap-on Jacob dat sekaken Moses daida ay mangipagawis koma isnan nemnemda ay mangwani en, ‘Bebsat, dakayon mensapsape dapay sin-ag-i kayo?’ ");
INSERT INTO xnn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ngem indogos nan nakabasol si Moses danat kanan ken siya, ‘Ayke waday lebbengmo ay men-apo ken dakami ya mangibanag isnan ik-ikkanmi? ");
INSERT INTO xnn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ay laydem ay pomateyka ay kaneg nan inikkam isdin iyEgipto id kob-a?’ ");
INSERT INTO xnn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Idi dinngen Moses san kinwanina dat omegyat et linmayaw ay omey id Midian. Nakiasawa isdi et isdi nan naiyanakan nan doway an-akna ay lalalaki. ");
INSERT INTO xnn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nallos nan epatpoo ay tew-en ay nintetean Moses id Midian daet menpaila si Apo Dios ken siya isnan apoy isnan kad-ana isnan pondag ay gogowaben nan bilig ay Sinai. ");
INSERT INTO xnn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Et nasdaaw si Moses tay nan inilana et nan kaiw ay aped menbidbidang ngem adi kanen nan apoy. Idi inmas-asag-en dinngena nan kalin Apo Dios ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Sak-en si Apo Dios ay Dios din alapom ay da Abraham, Isaac yas Jacob.’ Dinngen Moses dat aped menpayegpeg et omegyat ay mang-ila. ");
INSERT INTO xnn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dat kanan Apo Dios ken siya, ‘Kaanem nan sapatosmo, tay napateg nan naay lota ay menteteam tay wadaak isna. ");
INSERT INTO xnn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tet-ewa ay inil-ilak nan mapalpaligatan nan ipogawko id Egipto. Dakpay dengdengngen nan adawagda. Isonga inmaliyak ay mangisalakan ken daida isnan mabab-aaanda. Aka ta ibaak sik-a ay omey id Egipto.’ Siya di nan kinwanin Apo Dios ken Moses.” ");
INSERT INTO xnn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dat itoloy Esteban ay mangwani en, “Din si Moses ay egay dinawat din kadalaana ay nangwaniyanda en, ‘Ayke waday lebbengmo ay men-apo ken dakami ya mangibanag isnan ik-ikkanmi?’ et siya kayet nan inbaan Apo Dios ay men-apo ya mangipalobos ken daida isnan napalpaligatanda. Et nan anghel ay ninpaila ken siya issan kaiw et binadbadangana siya. ");
INSERT INTO xnn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Din si Moses met laeng nan nang-ik-ikkan isnan kaskasdaaw isnan nangipangpangowana ken daida isnan kinmaananda id Egipto ya isnan inikkanda ay ginomdang isnan baybay ay makwani en Gadangdang ya nan inik-ikkana isnan epatpoo ay tew-en ay nindad-aananda isnan pondag. ");
INSERT INTO xnn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Din si Moses abes nan nangibaga isnan deeyda ay ap-on Jacob ay mangwani en, ‘Awnit dotokan Apo Dios nan esay ipogaw isnan ib-a tako is mamadtona kaneg nan inikkana ay nangdotok ken sak-en.’ ");
INSERT INTO xnn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nakidagop met laeng si Moses isdin alal-apo tako isnan bilig ay Sinai ay makitoya ken Apo Dios. Danat dawaten nan naisolat ay linteg ay naidya ken datako ay adi makak-aan ay eng-enggana. ");
INSERT INTO xnn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ngem egay pinatin din alal-apo tako din si Moses. Et inadyanda siya ay men-ap-apo ken daida tay kayatda ay somagong id Egipto. ");
INSERT INTO xnn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Gapo tay nabayag si Moses isnan bilig ay Sinai, kinwanida ken Aaron ay iyon-an Moses en, ‘Somapoka is dios tako is mangipangpango ken datako. Adi tako getken no ngan di inommat ken Moses ay nangipango ken datako issan linmayawan tako id Egipto.’ ");
INSERT INTO xnn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Dadat sapowen nan kanega anak di baka ay kinadiosda. Dadat ipaltiyan ay menlalagsak ya mangdaydayaw isnan sinapoda ay dios. ");
INSERT INTO xnn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Isonga dinokogan Apo Dios daida et binaybay-ana daida ay mangdaydayaw isnan olay talaw id daya. Naisolat isnan liblon din mamadton Apo Dios nan nangwaniyan Apo Dios ken daida en, ‘Dakayo ay nagapo isdin si Israel, ayke sak-en di inpaltiyanyo issan epatpoo ay tew-en ay nindad-aananyo isnan pondag? ");
INSERT INTO xnn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nodi nan sinang didios ay sinapoyo nan dinaydayawyo. Inawityo pay nan baey ay nangipay-anyo isnan sinang didiosyo ay makwani en Moloch. Dayopay daydayawen nan sinapoyo ay sinang tatalaw ay makwani en Refam. Gapo isnan inik-ikkanyo et awnitko pakaanen dakayo isnan iliyo ta omey kayo isnan bas-ang nan ili id Babilonia ta mapaligatan kayo.’ ");
INSERT INTO xnn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ngem din alal-apo tako et egayda dinawat si Apo Dios is men-apo ken daida, olay no sinapoda ya inkawkawitda din inos-osalda ay mangnemnemanda koma ken siya issan nindad-aananda isnan pondag. Sinapon da Moses nan baey ay tolda ay kaneg nan inpailan Apo Dios ay toladena. ");
INSERT INTO xnn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Et siya nan inkawkawitda isdin sinonggepanda isnan ili ay inpatawid Apo Dios ken daida. Isdin timpo ay deey et si Josue nan naisokat ken Moses ay mangipangpango ken daida isdin nangipakaanan Apo Dios isnan nateketeken ay ipogaw ay mentetee. Et isdi nan nintetean san baey Apo Dios enggana isdin timpon din si David ay ali. ");
INSERT INTO xnn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Din ali ay si David et linaylayad Apo Dios siya et sinootna ken Apo Dios no mabalin ay somaad is osto ay baeyna tay siya nan Diosna ay Dios gedan din si Jacob ay alapona id kasin. ");
INSERT INTO xnn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ngem egay inyoog Apo Dios. Nodi si Solomon ay anakna nan kanana en mangsaad. ");
INSERT INTO xnn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Gawis tay sinaadna ngem getken tako ay nan osto ay mentetean Apo Dios ay kangatowan isnan am-in et baken baey ay sinaad di ipogaw olay no gawigawis. Kaneg nan insolat din mamadton Apo Dios ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Sak-en nan ap-apo id daya ya isnan gagatinak ay batawa. Isonga olay ngan nan saadenyo et adi omanay is menteteak. ");
INSERT INTO xnn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tay sak-en nan nangboliw isnan am-in ay wada id daya ya nan wada isnan batawa.’ Siya di din kinwanin Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Dat itoloy Esteban ay mangwani ken daida en, “Ay apo kayo, ikekedseyo ay adi mangpati ken Apo Dios dayopay totowengen nan ibagbagana. Dayopay adyan abes nan Ispirito Santo. Nan inik-ikkan din alal-apo tako et siya kayet nan ik-ikkanyo. ");
INSERT INTO xnn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Maid olay esa isdin mamadton Apo Dios is egay pinaligat din alal-apo tako. Olay din mamadto ay nangibagbaga isnan omaliyan nan napateg ay ipogaw ay si Jesus et pinateyda daida. Dakayo abes, siya met laeng nan inikkanyo tay dinpapyo si Jesus olay no maid basolna dayot ipapatey. ");
INSERT INTO xnn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dapay dakayo nan naitedan nan linteg Apo Dios ay inpaitedna ken Moses isnan aanghel ngem adiyo patpatiyen.” ");
INSERT INTO xnn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Idi dinngen nan deeyda ay menlelebbeng nan kinwanin Esteban et nakaligetda ay pilmi dadapay men-gegege. ");
INSERT INTO xnn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ngem si Esteban et naitakdo nan Ispirito Santo daet mentangad id daya et masili isnan nang-il-ana ken Jesus ay tomatakdeg isnan makanawan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dat kanan Esteban en, “Deey. Iilak ay napewak id daya et wada si Jesus ay Iyon-an Am-in di Ipogaw ay tomatakdeg isnan makanawan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dat menbogaw san deeyda ay menlelebbeng dadapay opopen nan ingada ta adida dedengngen nan kankanana. Dadat mapanika ay mangikawe ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Dadat goyoden et eyeyda isnan benget nan ili ta gayangenda is bato tasiyay matey. San deeyda ay nangipabasol ken Esteban et kinaanda nan badoda et inbadengda isnan sag-en nan esay baballo ay Saulo nan ngadana. Inikkanda di ta bantayana ta makigayangda abes ken Esteban. ");
INSERT INTO xnn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Idi gaygayangenda dat menlowalo si Esteban ay mangwani en, “Apo Jesus, dawatem nan ab-abiikko.” ");
INSERT INTO xnn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dat menpalintomeng et menbogaw ay mangwani, “Apo Jesus, adim pabasolen datona isnan naay ik-ikkanda.” Nakwas di dat matey. Et inyoog Saulo nan nangpateyanda ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Natey si Esteban dat agaan nan amam-a ay mangpatpateg ken Apo Dios dadat ikaob siya. Et esangka ay agew nan nangpateyanda ken Esteban ya nan ninlogiyan nan nangpaligatanda isnan am-in ay mamati ken Jesus id Jerusalem. Dat masis-iyan nan deeyda ay mamati ken Jesus et omeyda isnan probinsiyan di Judea ya Samaria. Et kedeng nan deeyda ay aapostolis is nataynan. ");
INSERT INTO xnn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ngem nan inik-ikkan Saulo et pinalpaligatna nan ipogaw ay mamati ken Jesus. Sinongsonggep isnan kabaebaey ay mangbalod isnan lalalaki wenno bababai ay mamati ken Jesus ta eyeyna isnan pagbalodan tay kayatna ay mamaid nan ipogaw ay mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nan nasis-iyan ay ipogaw ay mamati ken Jesus et inmeyda isnan nateketeken ay ili ay mangibagbaga isnan kankanan Apo Dios ay maipanggep ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe nan esa et inmey isnan esay ili id Samaria et inap-apatna si Jesus ken daida ay mangwani en si Jesus nan inbagan Apo Dios ay omali ay mentolay. ");
INSERT INTO xnn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nan kaipoipogaw id isdi et kaykayatda ay mangdengdenge isnan kankanan Felipe ya mang-il-ila isnan kaskasdaaw ay ik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nan anito ay kinmapet isnan ipogaw et inpakaan Felipe daida dadat men-owakis ay mangtaynan isnan ipogaw ay kinapetda. Adoado abes nan napalalais ya nan napilay ay inpagawis Felipe. ");
INSERT INTO xnn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Isonga men-galalasing nan omili isdi. ");
INSERT INTO xnn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wada abes nan am-ama ay kangadan is Simon ay somasalamangka. Masdaaw nan iSamaria isnan kabaelana. Men-et-etek siya ay mangwani en siya et nangato ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Patiyen am-in nan omili olay sinoy kaipogawna, nangato wenno nababa. Et kananda en napigsa nan kabaelana ay inidyan Apo Dios ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Et pinatpatin am-in nan ipogaw siya tay nabayag ay siniksikapana daida isnan inik-ikkana ay mensalsalamangka. ");
INSERT INTO xnn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ngem idi pinatin nan ipogaw nan inbagbagan Felipe ay masapol ay apowenda si Jesu Kristo esadapay maitapi isnan mentolayan Apo Dios ay maid patenggana dat menpabonyag am-in nan lalalaki ya nan bababai. ");
INSERT INTO xnn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Olay si Simon et namati abes isnan kabaelan Apo Dios dat menpabonyag. Dat makiboweg ken Felipe et nasdaaw isnan kaskasdaaw ay inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Idi dinngen san deeyda ay aapostolis id Jerusalem ay dinawat nan iSamaria nan kalin Apo Dios dadat ibaa da Pedro ken Juan ay omey isdi. ");
INSERT INTO xnn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Idi inomdanda, inlowalowanda nan mamati ken Jesus tasiyay kapten nan Ispirito Santo daida. ");
INSERT INTO xnn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tay issan nabonyaganda et egay kinmapet ken daida tay basta nan ngadan Apo Jesus et kedeng nan ninpabonyaganda. ");
INSERT INTO xnn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dat ipatang da Pedro ken Juan nan ledengda isnan oloda ay mangilowalo ken daida. Dat komapet nan Ispirito Santo ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dat si Simon ay somasalamangka et inilana ay kinmapet nan Ispirito Santo isnan ipogaw ay gen-an nan aapostolis danat pabal-en nan sipingna ");
INSERT INTO xnn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ay mangwani en, “Mang-ated kayo is kabaelak tasiyay olay sino nan gen-ak et kapten nan Ispirito Santo daida.” ");
INSERT INTO xnn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ngem kinwanin Pedro ken siya, “Maitapi nan sipingmo ken sik-a ay mapoowan isnan impilno tay apedmo kanan en mabalin ay malakowan nan badang Apo Dios ay adi kalakowan. ");
INSERT INTO xnn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maid polos biyangmo ay maitapi isnan ik-ikkanmi tay getken Apo Dios ay baken osto nan nemnemmo. ");
INSERT INTO xnn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dokogam nan ngawi ay nemnemmo. Menlowaloka ta moke pakawanen Apo Dios sik-a. ");
INSERT INTO xnn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tay getkek ay palalo ay omapalka ya baan di basol sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dat kanan Simon, “Ilowalowanyo ngalod sak-en ken Apo Dios ta adi ommat ken sak-en nan sana kankanam.” ");
INSERT INTO xnn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nakwas pay ay inbagan da Pedro ken Juan nan inilada maipanggep ken Jesus ya inbagada nan kankanan Apo Dios dadat somaa. Ngem isnan somas-aaanda id Jerusalem et inbagbagada nan gawis ay damag ay maipanggep ken Jesus isnan kailiili ay linal-aosanda id Samaria. ");
INSERT INTO xnn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ngem nan inommat ken Felipe et wada nan anghel Apo Dios ay nakitoya ken siya ay mangwani en, “Ipikam ta omeyka isnan kalsa ay magapo id Jerusalem ay omey id Gaza.” Et an-annawa ay pondag nan madaan. ");
INSERT INTO xnn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Inpikana dat omey. Danat datngan nan iyEtiopia ay nangato ay opisyal nan alida ay babai ay kangadan is Candace. Siya abes nan nang-ay-ayowan isnan kokwana am-in. Nan naay am-ama et nagapo id Jerusalem tay inmey ay nindayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Dat menlogan isnan kalisana ay somaa isnan ilina danapay basbasaen nan tap-in nan liblon Apo Dios ay insolat Isaias ay din mamadton Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Inilan Felipe siya dat kanan nan Ispirito Santo, “Enka ta maisag-enka isnan deey logan.” ");
INSERT INTO xnn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dat tomagtag si Felipe et somag-en isnan logan et dedengngena nan basbasaen nan am-ama ay solat din mamadto ay si Isaias. Danat kanan ken siya, “Ay maawatam nan basbasaem?” ");
INSERT INTO xnn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Adiyak maawatan no maid mang-itdo ken sak-en,” kanan san am-ama. Danat ibaga ken Felipe ta makilogan. ");
INSERT INTO xnn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nan basbasaena isnan liblon Apo Dios et siya na. Kanana en, “Kanegna nan kalnilo ay maeyey ay mapalti. Apedna igiginek ay kaneg nan kalnilo ay mapokpokisan ay maid polos lilina. ");
INSERT INTO xnn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Baibainanda siya dadapay adi somalyaen omona. Olay maid basolna ngem pinateyda kayet. Ngem olay natey et adi kabilang nan awnitna kaneg an-ak.” Siya di nan binasana isnan liblon Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Dat kanan san am-ama ken Felipe, “Kadya, sino nan inap-apat din mamadto ay si Isaias? Ay nan osto ay awakna nan kanana en awnit mapaligatan wenno nan teken ay ipogaw?” ");
INSERT INTO xnn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dat ilogin Felipe ay mangiyispikal ken siya isnan kayat ay kanan nan insolat din si Isaias. Inbagana nan gawis ay damag ay maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Idi wada nan danom ay dinas-anda isnan mendad-aananda dat kanan san am-ama, “Naay di danom. Ay mabalin ay mabonyaganak isna?” ");
INSERT INTO xnn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Dat kanan Felipe, “Mabalin no mamatika ken Jesus.” “Mamatiyak,” kanan san am-ama, “Patiyek ay tet-ewa ay Anak Apo Dios si Jesu Kristo.” ");
INSERT INTO xnn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Danat ipasaldeng nan logan. Dadat lomayog ay dowa et domakdakda isnan danom. Dat bonyagan Felipe siya. ");
INSERT INTO xnn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Idi dinmakada isnan danom dat ikaan nan Ispirito Santo si Felipe et egay kasin inilan san am-ama siya. Ngem men-gasing nan nemnemna danat itoloy ay omey isnan omayana. ");
INSERT INTO xnn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ngem si Felipe et aped wada id Azoto. Danat ibagbaga nan maipanggep ken Jesus isnan kailiili isdi enggana ay inomdan id Cesarea. ");
INSERT INTO xnn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ngem si Saulo et intoltoloyna ay mangpalpaligat isnan mamati ken Jesus tay laydena ay pateyen daida isonga inmey isnan kangatowan ay padi ");
INSERT INTO xnn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ay menpasolat is solat ta eyeyna isnan kasinasinagoga ay madagdagopan di Judio id Damasco. Nan kanan nan solsolat et maidya nan kalintegan Saulo ay mangdepap isnan ipogaw ay lalalaki wenno bababai ay mamati ken Jesus ta eyeyna id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dat pomika si Saulo ay omey id Damasco. Idi inmas-asag-en isnan ili dat menkatatanggewan siya isnan pat-a ay nagapo id daya. ");
INSERT INTO xnn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Dat matokang et dengngena nan kali ay mangmangwani, “Saulo, Saulo, dakan palpaligaten sak-en?” ");
INSERT INTO xnn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Dat kanan Saulo, “Sinoka Apo?” “Sak-en si Jesus ay mangisakit isnan ipogawko ay palpaligatem. ");
INSERT INTO xnn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ibangonmo ta omeyka isnan ili ay omayam et awnit wada nan mangibaga ken sik-a isnan masapol ay ikkam.” ");
INSERT INTO xnn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nan ib-an Saulo et sinmaldengda ya ginminekda tay didinngeda nan kali ngem maid inilada is menkalkali. ");
INSERT INTO xnn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dat bomangon si Saulo ngem idi bitagena nan matana et adi makaila tay nakowap isonga pinadangda ay mangipango id Damasco. ");
INSERT INTO xnn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Toloy agew nan nakowapana et egay mangmangan ya egay omin-inom. ");
INSERT INTO xnn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wada abes id Damasco nan esay am-ama ay kangadan is Ananias ay mamati ken Jesus. Ninpaila si Apo Jesus ken siya ay kaneg iitaw danat kanan, “Ananias.” Dat songbatan Ananias, “Sinoy ibagam, Apo?” ");
INSERT INTO xnn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Dat kanan Apo Jesus, “Ipikam ta omeyka isnan kalsa ay Leteg isnan baey Judas ta ilam si Saulo ay iTarso ay menlol-owalo. ");
INSERT INTO xnn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tay wada nan inpailak ken siya ay kaneg iitaw et inilana sik-a ay sinonggep ay mangkappos isnan matana ta kasin makaila.” ");
INSERT INTO xnn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ngem omegyat si Ananias isonga sinongbatana ay mangwani en, “Apo, adoado nan mangmangwani en dadama nan ik-ikkan Saulo ay mangpalpaligat isnan ib-ami ay mamati ken sik-a id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Id wani kano wada nan solat ay inalana isnan menkangangato ay papadi id Jerusalem ta mabalin ay omali ay mangdepap ken dakami am-in ay mamati ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngem kinwanin Apo Jesus, “Olay, omeyka kayet tay pinilik siya ay en mangibagbaga isnan maipanggep ken sak-en isnan ipogaw ay baken Judio ya nan alida ya nan ib-ayo ay Judio ay daan pay laeng ay egay mamati ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Awnitko ibaga abes ken Saulo nan adoado ay ligat ay masapol ay liknaena gapo tay apowena sak-en.” ");
INSERT INTO xnn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Dat tet-ewa omey si Ananias et songgep isnan baey ay mentetean Saulo. Danat gen-an siya et kanana, “Besat ay Saulo, nan Apo tako ay si Jesus ay ninpaila ken sik-a isnan daan isnan inmaliyam et siya met laeng nan nangibaa ken sak-en ay omaliyak ken sik-a ta kasinka makaila ya ta kapten nan Ispirito Santo sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Dat mapanokyatan nan matana et kasin makaila. Danat ipika et mabonyagan. ");
INSERT INTO xnn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dat mangan et pomigsa nan awakna. Nakitetee si Saulo isnan mamati ken Jesus id Damasco isnan nadandan ay agew. ");
INSERT INTO xnn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dat omey isnan sinagoga ay madagdagopan nan ib-ana ay Judio et ibagbagana ay mangwani en, “Tet-ewa ay Anak Apo Dios si Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nasdaaw am-in nan nangdedenge isnan kankanan Saulo. Dadat kanan, “Ay baken si todi nan nangpalpaligat isnan mamati ken Jesus id Jerusalem? Ay baken nan inmaliyana isna et ta depapena nan mamati ta eyeyna isnan menkangangato ay papadi id Jerusalem?” ");
INSERT INTO xnn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ngem am-amed binmikas si Saulo ay men-isolo isnan ib-ana ay Judio id Damasco isnan maipanggep ken Jesus et adida makaabak ken siya tay nalaing ay mangpaneknek ay si Jesu Kristo nan inbaan Apo Dios ay omali ay mentolay. ");
INSERT INTO xnn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Idi nalalanganan is kaat ay agew dat mentotya nan Judio ay adi mamati is ikkanda ay mangpatey ken Saulo. ");
INSERT INTO xnn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kaageagew ya kalabilabi ay sesed-enda si Saulo isnan segpan nan ilida ta pateyenda no bomala. Ngem wada nan nangipagtek ken Saulo isnan layden nan ib-ana ay ikkan ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Isonga isnan labi et inippey nan ib-ana siya isnan dakedake ay tiklis dadat oy-oyen isnan ataatakdag ay baked nan ilida. Nan nang-oy-oy ken siya et daida nan nangpati isnan kinkinwanin Saulo maipanggep ken Jesus. Et siya di nan inikkan Saulo ay kinmaan isnan ili et egayda pateyen. ");
INSERT INTO xnn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sinmagong si Saulo id Jerusalem et laydena ay maitapi isnan mamati ken Jesus. Ngem omegyatda tay adida patiyen no tet-ewa ay mamati siya ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ngem si Bernabe et inayagana siya ta ibowegna ay omey isnan deeyda ay aapostolis. Danat sodoken ken daida nan am-in ay inommat ken Saulo isnan nang-il-ana ken Jesus isnan daan ya nan dinngena ay kalin Jesus. Inbagana abes nan nangitoledana ay nangibagbaga isnan maipanggep ken Jesus id Damasco. ");
INSERT INTO xnn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Isonga nakibob-oweg si Saulo ken daida id Jerusalem. Natoled abes ay mangibagbaga isnan maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ngem wada abes nan iib-ana ay Judio ay Griego nan kalida ay makisongsongbatan Saulo isnan maipanggep ken Jesus. Ngem kayatda ay pateyen siya. ");
INSERT INTO xnn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Idi gintek nan mamati ken Jesus ay kayatda ay pateyen siya dadat ipango id Cesarea dadat palobwaten ta somaa id Tarso ay ilina. ");
INSERT INTO xnn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dat somingpa nan biyag nan mamati ken Jesus isnan probinsiya id Judea ya id Galilea ya id Samaria tay maid et mang-am-amis ken daida. Dadat omad-ado dapay pomigsa nan pammatida tay apowenda si Jesus ya badangan abes nan Ispirito Santo daida. ");
INSERT INTO xnn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Si Pedro abes et inmey ninpaspasyal isnan kailiili ay kad-an di mamati ken Jesus. Nan esay inmayana et id Lidda. ");
INSERT INTO xnn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dinas-ana isdi nan esay am-ama ay kangadan is Eneas ay napalalais ay ninpopopodan is wao ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Dat kanan Pedro ken Eneas, “Ibangonmo ta lolonem nan kamenmo tay pagawisen Jesu Kristo sik-a.” Dat mabanangon siya. ");
INSERT INTO xnn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nan omili id Lidda ya nan kaipoipogaw ay iSarona et inilada dadat mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wada abes nan kangadan is Tabita ay in-ina ay mamati ken Jesus id Joppe. Nan pangwanida isnan kalin di Griego et Dorcas tay nan kanan nan ngadana et ogsa. Gawis am-in nan inik-ikkana isnan ipogaw danapay badbadangan nan kokodokdo. ");
INSERT INTO xnn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ngem dat mensakit dat matey. Dadat banyosan et papodanenda isnan kowalto isnan maikadwa ay galado. ");
INSERT INTO xnn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ngem gintek nan mamati ken Jesus ay wada si Pedro id Lidda ay sag-en nan ilida dadat ibaa nan dowa ay amam-a ay omey mang-ayag ken siya ay mangwani, “Pangaasim ta ikakamom ay omey id Joppe.” ");
INSERT INTO xnn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Dat mapika si Pedro et makkey ken daida. Idi inomdanda dadat ipango isnan kowalto ay kad-an san natey. Wadada isdi nan adoado ay bababai ay babalo ay men-ag-aga. Inpailada ken Pedro nan sinapon Dorcas ay badbado ya ew-ewes isnan egayna kateyan. ");
INSERT INTO xnn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dat ipabalan Pedro daida am-in dat menpalintomeng ay menlowalo. Danat sagangen nan awak san natey et kanana, “Tabita, ibangonmo.” Dat menbitag nan matan san babai et ilana si Pedro dat bomangon. ");
INSERT INTO xnn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Dat gen-an Pedro nan ledengna et patakdegena siya. Dat ayagan Pedro san deeyda ay bababai ay balo ya nan ib-ada ay mamati ken Jesus ta ilaenda si Dorcas ay kasin natago. ");
INSERT INTO xnn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nan inommat ken Dorcas et nagtek isnan am-in ay omili id Joppe dat omad-ado nan mamati ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nintetee si Pedro id Joppe is nadandan ay agew isnan baey Simon ay mensapsapo is lalat. ");
INSERT INTO xnn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Id Cesarea et wada nan esay am-ama ay baken Judio ay kangadan is Cornelio. Siya nan kapitan di sin-gasot ay sosoldado ay nagapo id Italia. ");
INSERT INTO xnn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Olay no baken Judio si Cornelio et napigsa nan pammatina ken Apo Dios. Si Apo Dios nan daydayawenda ay sinbaey ya adoado nan badangna isnan Judio ay kokodokdo. Kanayon abes ay menlol-owalo. ");
INSERT INTO xnn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Isnan esay agew isnan alas tres isnan kag-aw et inbaan Apo Dios nan esay anghelna ken Cornelio ay mangwani, “Cornelio.” ");
INSERT INTO xnn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Dat omegyat si Cornelio et ikikiyatna. Danat kanan, “Sino nan ibagam, Apo?” Dat kanan nan anghel, “Nenemnemen Apo Dios sik-a tay getkena nan ik-ikkam ay menlowalo ken siya ya getkena gedan nan ik-ikkam ay mangbadbadang isnan kokodokdo ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bomaaka is omey mang-ayag ken Simon Pedro id Joppe. ");
INSERT INTO xnn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Makitetee siya ken Simon ay mensapsapo is lalat ay naisasag-en nan baeyna isnan baybay.” ");
INSERT INTO xnn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kinwanin nan anghel di dat komaan. Dat omayag si Cornelio is doway baana ya nan esay soldado ay kabadangna ay ib-ana ay mangdaydayaw ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Danat sodsodoken am-in nan inommat danat ibaa daida ta omeyda id Joppe. ");
INSERT INTO xnn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Isnan kawakgatana et daan ay mendad-aan nan deeyday tolo ay omas-asag-enda et id Joppe. Esadapay omdan et inmey si Pedro isnan nasisingpa ay atep nan baey ay menteteana. Dat menlowalo isnan alas dosi isnan kag-aw. ");
INSERT INTO xnn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Danat layden ay mangan tay naowat. Ngem egayda makaoto. Dat wada nan inpailan Apo Dios ken siya ay kaneg iitaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nan inilana et napewak id daya. Dat wada nan maoy-oy ay kaneg dakkel ay ewes ay napapadonan nan epat ay solina. ");
INSERT INTO xnn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nan wada isnan ewes et am-iam-in ay menkiwkiwi ay kalasin di animal, oweg ya koyat. ");
INSERT INTO xnn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Danat dengngen nan kali ay mangwani en, “Ibangonmo, Pedro, ta pomaltika is isdam.” Ngem isnan Judio et adoado nan law-enda isnan datodi ay maisda. ");
INSERT INTO xnn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Isonga kinwanin Pedro, “Adi mabalin, Apo, tay maid inis-isdak is malawa ay maisda.” ");
INSERT INTO xnn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dat kasin kanan nan menkalkali, “Adim kanan en lawa tay adi law-en Apo Dios daida id wani.” ");
INSERT INTO xnn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Namitlo ay inilana ya dinngena di dat ngomato nan ewes id daya. ");
INSERT INTO xnn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","20","Dat nemnemen Pedro no sino ngen nan kayatna ay kaliyen. Dat komali nan Ispirito Santo ken siya ay mangwani en, “Dengngem nan ibagak. Wada nan tolo ay mang-an-anap ken sik-a. Ipikam ta lomayogka et adika mendodowa nodi makkeyka ken daida tay sak-en gedan nan nangbaa ken daida.” Dat omdan tet-ewa san deeyday toloy inbaan Cornelio ay mang-an-anap isnan baey Simon. Inomdanda isnan segpan dadat sooten mo siya nan baey ay mentetean Simon Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dat lomayog si Pedro et kanana isnan toloy amam-a, “Sak-en nan an-anapenyo. Dakayon inmali?” ");
INSERT INTO xnn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Dadat kanan en, “Si Kapitan Cornelio nan nangbaa ken dakami. Si Cornelio ay apomi et gawigawis ay ipogaw et si Apo Dios nan daydayawena. Olay nan ib-ayo ay Judio et gawigawis nan kankananda ay maipanggep ken siya. Et wada nan ninpaila ken siya ay esay anghel Apo Dios et inbagana ta ipaayagna sik-a ta dengngena no ngan di ibagam ken siya.” Siya di nan kinwanida. ");
INSERT INTO xnn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dat pasgepen Pedro daida ta isdi nan kaseyepanda. Mawakgat pay dadat menlobwat. Naiboweg abes nan tap-in di mamati ken Jesus ay iJoppe. ");
INSERT INTO xnn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Inomdanda id Cesarea issan maikadwa ay agew et sisin-ed Cornelio daida. Wada abes nan ag-ina ya nan gagayyemna ay makiseseed tay inayagan Cornelio daida. ");
INSERT INTO xnn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Idi inomdan da Pedro dat omey sab-aten Cornelio siya. Dat menpalintomeng ay mangdayaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ngem inpatakdeg Pedro siya ay mangwani, “Itakdegmo tay ipogaw tako am-in. Bakenak dios ta dayawem sak-en.” ");
INSERT INTO xnn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mentoytoyada ay songgep isnan baeyna dat ilan Pedro nan adoado ay nadagop ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dat kanan Pedro ken daida, “Dakayo, getkenyo ay dakami ay Judio et law-enmi ay makiib-a isnan ipogaw ay baken Judio ya law-enmi abes ay songgep isnan baeyda. Ngem inpagtek Apo Dios ken sak-en ay madi no waday adyak is ipogaw gapo tay kanak en bakenda nadalos gapo tay adida solsoloten nan ogalimi. ");
INSERT INTO xnn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Isonga isnan nangipaayaganyo ken sak-en et egayak mendodowa ay omali. Isonga ibagayo kadya no dakayon nangipaayag.” ");
INSERT INTO xnn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Dat kanan Cornelio, “Id sinpang-etewna isnan kaneg tona ay alas tres et ninlowalowak. Dat katanakdeg nan anghel ay somili nan badona. ");
INSERT INTO xnn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kinwanina ken sak-en, ‘Cornelio, dengdengngen Apo Dios nan lowalom ken siya ya getkena nan ik-ikkam ay mangbadbadang isnan kokodokdo ay ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bomaaka is omey id Joppe ta ayagana nan am-ama ay si Simon Pedro. Makitetee siya ken Simon ay mensapsapo is lalat ay maisasag-en nan baeyna isnan baybay.’ ");
INSERT INTO xnn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Siya di nan kinwanina isonga inpaayagko sik-a ay dagos et gawigawis tay inmalika. Et iilaen Apo Dios ay nadagop kami isna ta dengngenmi no ngan di laydena ay itdom ken dakami.” ");
INSERT INTO xnn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Dat ilogin Pedro ay mangibaga en, “Tet-ewa ay maawatak id wani ay si Apo Dios et maid paam-amdena is ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tay olay sino ay ipogaw, Judio wenno baken et no dayawenda si Apo Dios ya gawis nan ik-ikkanda et dawatena daida. ");
INSERT INTO xnn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Inpagtek Apo Dios ken dakami ay Judio ay ap-on din si Israel nan gawis ay damag ay mangwani en nakaan nan ligetna isnan basbasol di ipogaw gapo ken Jesu Kristo ay apon di kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Waay dindinngeyo nan inik-ikkan ya nan insolsolon Jesus ay iNazaret isnan probinsiya id Galilea dat isnan kailiili id Judea issan nakwasan din nin-isolsolowan Juan ay menbonbonyag. ");
INSERT INTO xnn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Isonga maawatanyo nan nangitapiyan Apo Dios isnan Ispiritona ya kabaelana ken Jesus. Olay no into nan inmay-ayana et inpagawisna nan masaksakit ya nan ipogaw ay kinapet di anito tay wada si Apo Dios ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Et dakami nan nang-il-ila isnan am-in ay gawis ay inik-ikkana id Jerusalem ya isnan kailiili id Judea. Inilami abes nan nangilansaanda ken siya isnan kros ay nateyana. ");
INSERT INTO xnn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ngem si Apo Dios et tinagona kasin siya isnan maikatlo ay agew. Et kasin ninpap-aila ken dakami. ");
INSERT INTO xnn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Egay ninpap-aila si Jesus isnan am-in ay ipogaw ngem ninpap-aila ken dakami et nakikikan ya nakiin-inom ken dakami tay dakami nan pinilin Apo Dios ay mangibagbaga isnan inil-ilami. ");
INSERT INTO xnn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Et inbaan Apo Dios dakami ay en mangibagbaga isnan gawis ay damag isnan kaipoipogaw. Ibagbagami gedan ay si Jesus nan pinilina ay mangbanag isnan am-in ay ipogaw olay no epdasda natey wenno matatago kayet isnan kasina omaliyan. ");
INSERT INTO xnn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Olay id kasin et inbagbagan din mamadton Apo Dios en gapo isnan inikkan Jesus et mapakawan nan basbasol nan am-in ay mamati ken siya.” Siya di nan inbagan Pedro ken da Cornelio. ");
INSERT INTO xnn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Daan ay menkalkali si Pedro dat komapet nan Ispirito Santo isnan am-in ay mangdedenge. ");
INSERT INTO xnn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nasdaaw san ib-an Pedro ay Judio ay mamati ken Jesus tay olay nan ipogaw ay baken Judio et kapten nan Ispirito Santo daida. ");
INSERT INTO xnn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nan nangtekanda ay kinmapet nan Ispirito Santo ken daida et kasida kakali is nateketeken ay kali ay mangdaydayaw ken Apo Dios. Dat kanan Pedro, ");
INSERT INTO xnn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Nan naayda ay ipogaw, olay no bakenda Judio et kinmapet nan Ispirito Santo ken daida ay kaneg ken datako met laeng. Isonga adi mabalin ay iyadi tako nan kabonyaganda.” ");
INSERT INTO xnn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Danat kanan ken da Cornelio, “Masapol ay menpabonyag kayo ta ipagtekyo ay ap-apowenyo si Jesus.” Dat kanan da Cornelio en makitee si Pedro ken daida is madandan ay agew. ");
INSERT INTO xnn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Egay nabayag dat nan aapostolis ya nan iib-ada ay mamati ken Jesus ay wada id Judea et dinngeda ay patiyen abes nan ipogaw ay baken Judio nan kanan Apo Dios ay maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dat somaa si Pedro id Jerusalem. Dat wada nan ib-ana ay Judio ay mangipapati ay masapol ay masolot nan linteg Moses olay no mamatida ken Jesus. Dadat delawen si Pedro ");
INSERT INTO xnn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ay mangwani en, “Dakan aped songgep isnan baey di baken Judio? Nakikikanka pay isdi. Dapay law-en nan linteg tako di is maikkan.” ");
INSERT INTO xnn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dat sodoken Pedro am-iam-in nan inommat. ");
INSERT INTO xnn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kinwanina en, “Wadaak id Joppe et menlol-owalowak dat wada nan inpailan Apo Dios ken sak-en ay kanega iitaw et inilak nan maoy-oy-oy ay kanega dakkel ay ewes ay nagapo id daya ay napapadonan nan epat ay solina daet ompa isnan sag-enko. ");
INSERT INTO xnn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Daket isin-eng et am-iam-in ay menkiwkiwi ay kalasin di animal, oweg ya koyat nan mentetee. ");
INSERT INTO xnn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Daket dengngen nan kali ay mangwani en, ‘Ibangonmo, Pedro, ta pomaltika is isdam.’ ");
INSERT INTO xnn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Daket kanan, ‘Adi mabalin Apo, tay maid inis-isdak is malawa ay maisda.’ ");
INSERT INTO xnn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dat kasin kanan nan menkalkali ay nagapo id daya en, ‘Adim kanan en lawa tay adi law-en Apo Dios daida id wani.’ ");
INSERT INTO xnn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Namitlo nan nang-ilaak ya nangdengngak isdi dat ngomato nan ewes. ");
INSERT INTO xnn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Idi nginmato san ewes id daya dat siya nan inomdanan nan tolo ay amam-a ay nabaa ay nagapo id Cesarea. ");
INSERT INTO xnn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Inbagan nan Ispirito Santo en adiyak mendodowa ay makkey ken daida olay bakenda Judio. Nakkey abes nan naayda ay enem ay ib-a tako et inmey kami am-in id Cesarea et sinonggep kami isnan baey da Cornelio. ");
INSERT INTO xnn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dat apaten Cornelio nan nang-il-ana isnan anghel isnan baeyna ya nan inbagan nan anghel ken siya ay mangwani en, ‘Bomaaka is omey mang-ayag ken Simon Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Et awnitna ibaga nan masapol ay patiyenyo ta mapakawan nan basolyo ta maisalakan kayo.’ Siya di nan kinwanin nan anghel ken Cornelio.” ");
INSERT INTO xnn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Dat itoloy Pedro ay mangwani en, “Issan menkalkaliyak et komapet nan Ispirito Santo ken daida ay kaneg met laeng din kinmapetana ken datako isdin damo. ");
INSERT INTO xnn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Daket nemnemen nan kinwanin Apo Jesus ken datako en, ‘Si Juan et binonyagana dakayo is danom ay mangipagtek ay mamati kayo ken Apo Dios ngem id wani ibonyag Apo Dios nan Ispiritona ken dakayo.’ Siya di nan kinwanin Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si Apo Dios nan nangipakapet isnan Ispiritona ken datako isdin namatiyan tako ken Apo Jesu Kristo. Paliso gedan isnan baken Judio et inpakapetna nan Ispiritona ken daida. Et sinowak is mangiyadi ken Apo Dios ay mang-ikkan isdi?” ");
INSERT INTO xnn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Idi dinngeda di dadat somaldeng ay mangdeldelaw ken siya et daydayawenda si Apo Dios. Et kananda en layden Apo Dios obpay ay maidya nan biyag ay maid patenggana isnan olay ipogaw ay baken Judio no ibabawida nan basolda. ");
INSERT INTO xnn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isnan nangpateyan nan Judio ken Esteban et nasis-iyan nan mamati ken Jesus tay pinalpaligat nan adi mamati ay Judio daida. Inomdan nan tap-ina enggana id Fenicia ya id Chipre ya id Antiokia. Inbagbagada kayet nan maipanggep ken Jesus ngem kedkedeng isnan iib-ada ay Judio is nangibagbagaanda. ");
INSERT INTO xnn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ngem wada nan iChipre ya iCirene ay mamati ken Jesus et inmeyda id Antiokia et inbagada abes nan gawis ay damag ay maipanggep ken Apo Jesus isnan baken Judio. ");
INSERT INTO xnn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Inted Apo Dios nan kabaelanda ay men-is-isolo isonga adoado nan nangibabawi isnan basbasolda ta mamatida ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nan mamati ken Jesus ay wada id Jerusalem et dinngeda di. Dadat ibaa si Bernabe ay omey mang-ila ken daida id Antiokia. ");
INSERT INTO xnn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Idi inomdan isdi dat men-gasing isnan nang-il-ana isnan badang Apo Dios ken daida. Danat bagbagaan daida ta itoltoloyda ay mamati ken Apo Jesus olay ngan di om-ommat ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Si Bernabe et gawigawis siya ay ipogaw. Nan Ispirito Santo nan mang-it-itdo isnan ik-ikkana dapay napigsapigsa nan pammatina ken Apo Dios. Et adoado nan naitapi ken Apo Jesus gapo isnan insolona. ");
INSERT INTO xnn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kinmaan si Bernabe id Antiokia dat omey id Tarso ay mang-anap ken Saulo. ");
INSERT INTO xnn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Idi dinatngana danat ayagan et somagongda ay dowa id Antiokia et nakatew-enda isdi ay makibob-oweg isnan ipogaw ay mamati ken Jesus et adoado nan insolsolowanda. Nan mamati ken Jesus id Antiokia et daida nan damo ay makwani en Kristiano. ");
INSERT INTO xnn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Isnan ninteteanda id Antiokia et wadada nan mamadton Apo Dios ay nagapo id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nan esa ay kangadan is Agabo et initdowan nan Ispirito Santo siya danat ibaga en awnit mabtil nan kailiili isnan batawa. Tinmet-ewa nan kinwanina isnan timpon Ali Claudio. ");
INSERT INTO xnn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Et nan deeyda ay mamati ken Jesus et nintotolagda ay mangipaw-it isnan badangda isnan ib-ada ay mamati ken Jesus ay wada id Judea. Nin-itedda isnan wada ay mabalin ay ibadangda. ");
INSERT INTO xnn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nan nangyey isnan badangda et da Bernabe ken Saulo dadat ited isnan amam-an di mamati ken Jesus id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Isnan timpo ay deey inlogin Ali Herod ay mangpaligat isnan tap-in di ipogaw ay mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Inpapotona nan olon Santiago ay besat Juan. ");
INSERT INTO xnn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Idi inilana ay men-gasing nan Judio isnan inikkana danat ipadpap si Pedro. Nan nang-ikkanana isdi et isnan fiesta ay mangananda isnan tinapay ay egay kabobodan. ");
INSERT INTO xnn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Idi nadpap si Pedro dadat ipagowaldiya isnan simpoo ya enem ay sosoldado ngem masin-ep-atda ay mensinsinokat ay menbanbantay. Kanan Herod en ipapateyna siya isnan mangboyaan di kaipoipogaw no makwas nan fiesta. ");
INSERT INTO xnn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Naibalod si Pedro ngem nan ib-ana ay mamati ken Jesus et adida somaldeng ay mangilol-owalo ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nalabi et naseseyep si Pedro isnan betaay nan doway gowaldiya tay kanan Ali Herod en kawakgatana et ipaboyana siya ay maipapatey. Nakakawalan si Pedro is doway kawal ya nagogowaldiyaan abes nan segpan nan pagbalodan. ");
INSERT INTO xnn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Dat aped pomat-a nan kowalto et mawanada nan anghel Apo Dios. Dat iwedwed nan anghel ay manggido ken siya danat kanan, “Ikamom ta bomangonka.” Dat aped natanekdag nan kawal ay naibabalod isnan ledengna. ");
INSERT INTO xnn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dat kanan nan anghel, “Isiglotmo nan balikes nan badom dakat mensapatos.” Inikkan Pedro di dat kasin kanan nan anghel, “Isadleymo nan ewesmo ta omonodka.” ");
INSERT INTO xnn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Dat bomala si Pedro ay omonod isnan anghel ngem nan wada isnan nemnemna et waay baken tet-ewa nodi iitaw et kedeng. ");
INSERT INTO xnn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Linaosanda nan esa ay gowaldiya ya nan maikadwa dadat omdan isnan dakkel ay eneb ay landok isnan segpan ay bomala id deya. Dat aped matokaban ay maid mangtokab dadat bomala. Mendaanda pay isnan esa ay kalsa dat mamaid san anghel. ");
INSERT INTO xnn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nakwas di dat nemnemen Pedro ay tet-ewa obpay nan inommat ken siya. Danat kanan, “Getkek id wani ay tet-ewa ay si Apo Dios nan nangbaa isnan anghelna ay mangisalakan ken sak-en ta adi pomatey si Ali Herod tasiyay adi maikkan nan layden nan Judio ay maikkan ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Danat nemnemen ay omey isnan baey da Maria ay inan Juan ay kangadan abes is Marcos. Siya di nan nadagopan nan mamati ken Jesus ay menlol-owalo. ");
INSERT INTO xnn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Idi inomdan isnan segpan dat menkogkog dat omey nan esay baa ay si Roda ay mangtokab. ");
INSERT INTO xnn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mailalasina nan kalin Pedro ngem kinalingkingana ay mangtokab gapo isnan gasingna dat tomagtag ay en mangibaga ay wada si Pedro isnan segpan. ");
INSERT INTO xnn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ngem egayda patiyen ay kananda en. “Ay naong-ongka?” Ngem inpapatina ay tet-ewa dadat kanan, “Waay nan anghelna.” ");
INSERT INTO xnn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ngem ninkogkog kayet si Pedro enggana ay enda tinokaban dadat ilan ay tet-ewa ay si Pedro dadat masdamasdaaw. ");
INSERT INTO xnn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dat ipaginek Pedro daida et sodokena nan inikkan Apo Dios ay nangipabala ken siya isnan pagbalodan. Danat kanan, “Enkayo ibaga abes is ken da Santiago ya nan iib-a tako ay mamati ken Jesus.” Dat komaan et omey isnan teken ay ili. ");
INSERT INTO xnn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Mawakgat pay dat palalo ay menngalngalawngaw nan men-gogowaldiya isnan pagbalodan tay maid si Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Si Ali Herod pay et inbilina ay anapenda siya ngem adida makadateng. Isonga sinomalyan Ali Herod nan gogowaldiya danat ipapatey daida. Dat komaan si Ali Herod id Judea et omey menpasyal id Cesarea. ");
INSERT INTO xnn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Si Ali Herod et nakaliget isnan ipogaw id Tiro ya id Sidon. Isonga maid somya is ikkanda ay omala is kanenda tay nan ili ay mentolayan Ali Herod nan magapowan nan kanenda. Isonga nin-an-anapda is limidyoda ay mang-ayak ken siya ta makaan nan ligetna. Nan inikkanda et inawisda si Blasto ta gayyemenda ta badangana daida tay siya nan kangatowan ay baan Ali Herod. Et tet-ewa ay binadangana daida ay makitoya ken Ali Herod. Dadat menseg-ang ken siya ta makaan nan ligetna ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Inomdan nan agew ay pinilin Herod ay menpailaana ta itedna nan songbatna ken daida. Dat menbado is nanginangina ay bado ay badon di ali dat omey tomokdo isnan tokdowan di ali et menkali isnan adoado ay ipogaw ay nadagop isdi. ");
INSERT INTO xnn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nakwas di dat menbogaw nan kaipoipogaw ay mangdayaw ken siya ay mangwani en, “Kalin di dios, baken aped kalin di ipogaw.” ");
INSERT INTO xnn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dat dosaen Apo Dios siya tay laylaydena nan mangdayawanda ken siya dapay maid polos panangdayawna ken Apo Dios. Isonga inpa-eyna ay dagos nan esay anghelna ay mangipasakit ken siya. Dat aped mabanogis nan awakna et egay nabayag dat matey. ");
INSERT INTO xnn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ngem nan kalin Apo Dios et naitoltoloy ay maipagtek ya inmad-ad-ado nan ipogaw ay mamati. ");
INSERT INTO xnn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Da Bernabe ken Saulo et nakwas nan oblada id Jerusalem dadat komaan et somagongda id Antiokia. Inkawitda abes si Juan ay kangadan is Marcos. ");
INSERT INTO xnn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Isnan mamati ken Jesus id Antiokia et wada nan naitapi ken daida ay mamadton Apo Dios. Wada abes nan nalaing ay men-is-isolo isnan kalin Apo Dios. Siya dana nan ngadanda. Da Bernabe, si Simeon ay kangadan is Niger, si Lucio ay iCirene yas Manaen ay esa ay tinalaken din aman Herod ay gobilnadol id Galilea yas Saulo. ");
INSERT INTO xnn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Isnan esay agew et menlol-owalo nan mamati ken Jesus dadapay mentepe ay adi mangmangan ta kedeng si Apo Dios is nenemnemenda. Dat kanan nan Ispirito Santo ken daida en, “Dotokanyo da Bernabe ken Saulo ta ikkanda nan ipaoblak ken daida.” ");
INSERT INTO xnn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Isonga kasinda ninlowalo ya nintepe dadat ipatang nan ledengda isnan olon da Bernabe ken Saulo ay mangdotok ken daida. Dadat papikaen daida ta omeyda ikkan nan kayat Apo Dios ay ikkanda. ");
INSERT INTO xnn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Isonga da Bernabe ken Saulo ay inbaan nan Ispirito Santo et inmeyda id Seleucia. Dadat menlogan isnan bapor ay omey id Chipre. ");
INSERT INTO xnn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Inomdanda pay id Salamina ay esay ili id Chipre dadat ibagbaga nan kalin Apo Dios isnan kasinasinagoga ay madagdagopan nan ib-ada ay Judio. Inkawitda si Juan Marcos ay mangbadang ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pinasyalda am-in nan ili id Chipre enggana id Pafo. Dadat datngan nan esay Judio ay mensip-ok ay mangwani en siya nan esay mamadton Apo Dios ay mang-it-itdo isnan ibagbagana ngem baken tet-ewa kadi. Nan ngadana et Barjesus wenno Elimas tay nan kayat ay kanan nan Elimas isnan kalin di Griego et mensip-ok. ");
INSERT INTO xnn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Siya nan esay ib-an nan nalaing ay gobilnadol id Chipre ay si Sergio Paulo. Isnan esay agew et inayagan nan gobilnadol da Bernabe ken Saulo tay laydena ay dengngen nan kanan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Idi makikalkalida ken siya dat taktaken nan mensip-ok daida tasiyay adi patiyen nan gobilnadol si Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dat liknaen Saulo ay kangadan abes is Pablo nan kabaelan nan Ispirito Santo ken siya et ikiyatna si Elimas. ");
INSERT INTO xnn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Danat kanan ken siya, “Sik-a nan anak Satanas tay aposem am-in nan gomawisan nan ipogaw. Nalaingka ay menkamkampot ya mensiksikap. Dakan adi somaldeng ay mangbalbalinsowek isnan kankanan Apo Dios? ");
INSERT INTO xnn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Id wani et dosaen Apo Dios sik-a ta makowapka ta adika makaila is kaat ay agew.” Osto ay kinwanina di dat liknaen nan mensip-ok ay kaneg wada nan mangsasalin isnan matana et menkapkapokap ay omanap is mangpadang ay mangipango ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Inilan nan gobilnadol di dat mamati tay nasdanasdaaw isnan insoloda ay maipanggep ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nakwas pay di dat komaan da Pablo ya nan ib-ana id Pafo et menloganda kasin isnan bapor et omeyda id Perge ay esay ili id Pamfilia. Idi inomdanda isdi dat taynan Juan Marcos daida ay somaa id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ngem intoloy da Pablo ay omey et taynanda id Perge et omeyda isnan teken ay Antiokia ay ili id Pisidia. Wadada isdi isnan Sabado ay agew ay omil-illengan di Judio dadat songgep isnan sinagoga ay madagdagopan di Judio et makitokdoda. ");
INSERT INTO xnn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Idi nakwas nan nangbasaanda isnan tap-in di naisolat ay linteg Moses ya nan naisolat ay kalin di tap-in di mamadton Apo Dios dat kanan nan apon di sinagoga ken da Pablo en, “Dakayo ay gagayyem, no waday isoloyo isnan ipogaw ay naayda, ibagayo.” ");
INSERT INTO xnn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Dat tomakdeg si Pablo et ipaginekna daida danat kanan, “Dakayo ay ib-ami ay Judio ay kaalapo ken Israel ay din apo tako id kasin ya dakayo abes ay baken Judio ay mangpatpateg ken Apo Dios et dengngenyo. ");
INSERT INTO xnn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nan daydayawen tako ay Judio et si Apo Dios. Siya nan nangpili isdin alal-apo tako ay an-ak din si Israel. Et siya gedan nan nangipaad-ado ken daida isdin ninteteanda id Egipto. Siya abes nan nangipaila isnan pigsana ay nangipango ken daida ay komaan id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Isdin ninteteanda isnan pondag et inan-anosana nan inik-ikkanda ay menlilili ken siya enggana ay inmey nan waay epatpoo ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Idi inomdanda id Canaan et binadbadangan Apo Dios daida ay mang-abak isnan ipogaw isnan pito ay ili isdi ta ipatawidna ken daida ay Judio. Nakwas nan epat gasot ya limampoo ay tew-en enggana isdin inmayanda id Egipto. ");
INSERT INTO xnn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nakwas di dat menpilpili si Apo Dios is mangibanbanag ken daida ay mensinsinokat enggana isdin timpon din si Samuel ay esay mamadtona. ");
INSERT INTO xnn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Dat mendawat din alal-apo tako ken Apo Dios is ali ay men-apo ken daida. Isonga pinilin Apo Dios si Saulo ay anak Kis ay kaalapo ken Benjamin. Dat siya nan men-ali is epatpoo ay tew-en. ");
INSERT INTO xnn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dat kaanen Apo Dios si Saulo et isokatna si David ay men-ali ken daida. Naay nan kinwanin Apo Dios ay maipanggep ken David. ‘Nan anak Jesse ay si David nan laylaydek tay gawigawis ay ipogaw siya tay matalek ay mang-ik-ikkan isnan am-in ay laydek.’” ");
INSERT INTO xnn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dat itoloy Pablo ay mangwani, “Din si David nan kaapo isnan mangisalsalakan ken datako ay ap-on din si Israel. Et siya si Jesus ay inkalin Apo Dios ay omali. ");
INSERT INTO xnn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Isnan egay pay laeng ninlogiyan Jesus ay men-isolo et wada si Juan ay menbonbonyag ay mangibagbaga isnan ib-a tako ay ap-on Israel en dokoganda nan basolda ya menpabonyagda. ");
INSERT INTO xnn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nganngani ay makwas nan lebbeng Juan ay men-is-isolo danat kanan isnan kaipoipogaw en, ‘Waay kananyo en sak-en nan inbaan Apo Dios ay mangisalakan ken dakayo ngem baken. Ngem omal-ali ay mangsokat ken sak-en et gapo isnan kawedwedana et adiyak maibagay ay mangkaan isnan sapatosna.’ Kinwanin Juan di.” ");
INSERT INTO xnn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Dat itoloy Pablo ay mangwani en, “Dakayo ay ib-ak ay kaalapo ken Abraham, olay dakayo ay baken Judio ay mangdaydayaw ken Apo Dios et datako am-in nan nangipagtekan Apo Dios isnan maipanggep isnan mangisalakan ken datako. ");
INSERT INTO xnn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ngem nan ib-a tako ay Judio ay iJerusalem ya nan ap-apoda et egayda getken ay si Jesus nan mangisalakan isnan ipogaw. Egayda maawatan ay si Jesus nan sinodsodok din mamadton Apo Dios id kasin olay no sinabado ay basbasaenda din insolatda. Ngem daida nan nangtongpal isnan kinwanin din mamadton Apo Dios tay kinwanida en masapol ay matey si Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Isonga olay maid basolna is gapo ay matey siya ngem inbagada kayet ken Pilato ta ipapateyna. ");
INSERT INTO xnn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Siya di nan inikkanda tapno matongpal am-in nan epdas naisolat ay maipanggep ken siya. Dat wada nan nangkaan isnan awakna isnan kros dadat iliyang. ");
INSERT INTO xnn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ngem tinagon Apo Dios siya kasin. ");
INSERT INTO xnn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Et san nakiboboweg ken siya issan nagapowanda id Galilea ay enggana id Jerusalem et daida nan ninpap-ailaana is nadandan ay agew et daida id wani nan mangipagpagtek ken datako ay Judio ay kasin natago siya. ");
INSERT INTO xnn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Siya di nan inmaliyanmi id wani ta ibagami ken dakayo nan gawis ay damag tay tinmet-ewa isnan timpo tako din nakitolagan Apo Dios isdin alal-apo tako id kasin isnan kasina nangtagowan ken Jesus. Kaneg nan naisolat isnan maikadwa ay Salmo en, ‘Anakko sik-a, isonga id wani ipagtekko ay sak-en nan Amam.’ ");
INSERT INTO xnn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Id kasin abes inbagan Apo Dios nan maipanggep isnan kasin matagowan Jesus ay adi kasin matey ay enggana isnan nangwaniyana en, ‘Ikkak ken sik-a nan badang ay inkalik isdin si David ay adi polos kasoksokat.’ ");
INSERT INTO xnn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tay nan inkalina ken David et naisolat isnan nangwaniyan David en, ‘Adi kabalin ay iyoogmo, Apo, ay madonot nan awakko tay patiyek sik-a.’ ");
INSERT INTO xnn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Tay si David et pinatina am-in nan inbagan Apo Dios ay ikkana isdin timpona. Ngem dat matey dadat ikaob isnan naikaoban din alapona gedan dat madonot nan awakna. ");
INSERT INTO xnn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ngem si Jesus et egay nadonot nan awakna tay kasin tinagon Apo Dios siya. ");
INSERT INTO xnn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Isonga ibagami ken dakayo ay gagayyemmi en gapo isnan inikkan Jesus et mabalin ay pakawanen Apo Dios nan basol tako. ");
INSERT INTO xnn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Olay no patiyen tako am-in nan linteg din si Moses ngem baken kayet gawis nan pangiilaan Apo Dios ken datako. Ngem no si Jesus nan patiyen tako et gawis nan pangiilaana ken datako. ");
INSERT INTO xnn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Makailanyo ta adi ommat ken dakayo din inbagan din mamadton Apo Dios id kasin ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Dakayo ay mang-oy-oyaw isnan kankanan Apo Dios et makailanyo tay awnit kayo masdaaw isnan ikkan Apo Dios dakayot maisiyan ken siya ay matey tay adi kayo mamati. Olay no ipootda ay gawis ay mangibaga ken dakayo et adi kayo met laeng mamati.’ Siya di nan naisolat.” Siya di nan kombos nan inbagan Pablo ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Idi bomala da Bernabe ken Pablo isnan sinagoga dat kanan nan ipogaw en no mabalin koma ta tapiyanda kasin nan insoloda isnan omali ay Sabado. ");
INSERT INTO xnn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Idi nabokada isnan sinagoga dat makiboweg nan adoado ay ipogaw ken da Pablo yas Bernabe. Wada ken daida nan Judio ya wada abes nan baken Judio ay mangsolsolot isnan ogalin di Judio. Dadat kanan ken daida en itoltoloyda ay mamati isnan gawis ay badang Apo Dios ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Idi kasin Sabado dat kanega am-iam-in nan omili id Antiokia nan inmey ay makidenge isnan maitdo ay nagapo ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ngem nan adi mamati ay Judio et pilmi ay inmapalda isnan nang-ilaanda isnan adoado ay ipogaw ay mangdedenge ken da Pablo. Dadat makisongbat ken Pablo dadapay oyawen siya. ");
INSERT INTO xnn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ngem da Pablo ken Bernabe et intoledda ay mangwani en, “Masapol ay dakayo nan damo ay maibagaan nan kalin Apo Dios tay Judio kayo ngem gapo tay adyanyo ya adiyo layden ay matatago ken Apo Dios ay eng-enggana, isonga id wani omey kami isnan baken Judio ta ibagami ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tay siya nan inbilin Apo Dios ken dakami isnan nangwaniyana en, ‘Ibaak sik-a ay omey mang-itdo isnan baken Judio ay manglawag isnan nemnemda ta waday waya ay maisalakan nan am-in ay kaipoipogaw isnan batawa.’ Siya di din inbagan Apo Dios.” ");
INSERT INTO xnn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Idi dinngen nan deeyda ay baken Judio nan kinwanin Pablo dadat men-galalasing. Dadapay dayawen si Apo Dios gapo isnan inbagan da Pablo ay maipanggep ken Jesus. Dat am-in ay pinilin Apo Dios ay manglayad ay mangdawat isnan biyag ay maid patenggana et mamatida. ");
INSERT INTO xnn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Dat maibagbaga nan maipanggep ken Apo Jesus isnan kailiili id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ngem nan Judio ay adi mamati et tinoyada nan amam-a ay kalebbeng isnan ili ya nan babaknang ay inin-a ay mangsolsolot isnan ogalin di Judio ta aposenda da Pablo ken Bernabe. Dadat ilogi ay mangpaligat ken daida dadat ipapati ta komaanda isnan ilida. ");
INSERT INTO xnn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Isonga nan inikkan da Pablo et inpigadda nan sikida ta makaan nan tapok ay mangipagtek ay adida kasin isolsolowan daida tay olay no dinngeda nan kali ay maipanggep ken Jesus et egayda patiyen. Dadat omey id Iconio. ");
INSERT INTO xnn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ngem nan deeyda ay mamati ken Jesus ay nataynan id Antiokia et egay makak-aan nan gasingda. Et wawawawada nan Ispirito Santo ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Id Iconio abes et inmey da Pablo ay men-isolo isnan sinagoga ay madagdagopan nan ib-ana ay Judio. Isnan nin-isolowan Pablo et adoado nan Judio ya nan baken Judio ay namati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ngem nan Judio ay egay namati et inawisda nan baken Judio ta aposenda nan mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ngem nabayag kayet da Pablo ken Bernabe id isdi. Dadapay natoled ay men-is-isolo isnan maipanggep ken Apo Jesus. Et inpagtek Apo Jesus ay tet-ewa nan inbagbagada ay maipanggep isnan badangna isnan ipogaw tay intedna nan kabaelanda ay mang-ik-ikkan isnan kaskasdaaw. ");
INSERT INTO xnn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ngem nagegedwa nan nemnem nan kaipoipogaw ay omili id isdi maipanggep ken da Pablo. Wada nan mangsolot issan Judio ay adi mamati ngem wada abes nan mangsolot ken da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dat mentolag nan Judio ya nan baken Judio ay adi mamati ya nan menlelebbeng ken daida ta aamisenda da Pablo dadat gayangen ta mateyda. ");
INSERT INTO xnn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Idi gintek nan aapostolis dadat lomayaw et inmeyda isnan tap-in di ili id Licaonia ay id Listra ya id Derbe ya isnan tap-in di ili ay naisasag-en isdi. ");
INSERT INTO xnn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dadat isolo kasin nan gawis ay damag ay maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Wada id Listra nan esay am-ama ay pilay et egay polos nindad-aan enggana isdin naiyanakana. ");
INSERT INTO xnn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Dedengngen nan pilay nan kankanan da Pablo dat inengneng Pablo siya et gintekna ay patiyena ay mabalin ay kaanen Apo Dios nan pilayna. ");
INSERT INTO xnn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Danat ibiyad nan kalina ay mangwani, “Itakdegmo.” Dat katanakdeg et mendaan. ");
INSERT INTO xnn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Idi inilan nan kaipoipogaw nan inikkan da Pablo dadat ilogi ay menbogaw, “Dios dana ay ninpaila ay kaneg ipogaw et inmalida ken datako.” Ngem egay maawatan da Pablo tay nan kalida ay iLicaonia nan ikalkalida. ");
INSERT INTO xnn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dadat ngadnan daida isnan ngadan nan diosda. Nginadnanda si Bernabe is Zeus ya si Pablo gapo tay siya nan ninkalkali et nginadnanda is Hermes ay esay diosda gedan. ");
INSERT INTO xnn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nan simbaan ay mangdayawanda isnan diosda ay si Zeus et wada isnan soban nan ili. Et nan padida et wada nan sabsabong ya bakbaka ay inyeyda isnan segpan nan ilida ta paltiyenda ay mangdayaw ken da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ngem idi gintek da Bernabe ken Pablo nan layden nan ipogaw ay ikkan dadat bisngaten nan badoda ay mangipagtek isnan mang-adyanda isnan ikkanda tay ngawi di ken Apo Dios. Dadapay tomagtag ay omey isnan kad-an nan kaipoipogaw ay menbogaw ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Gagayyem, dayon aped ik-ikkan na? Ipogaw kami ay kanegyo met laeng. Inmali kami isna ta ibagbagami nan gawis ay damag ay maipanggep ken Kristo ta taynanyo nan sinang didiosyo ay maid kapaayanda ta patiyenyo si Apo Dios ay naleleng-agan. Si Apo Dios et siya nan nangboliw isnan daya, nan batawa, nan baybay ya nan am-in ay mentetee. ");
INSERT INTO xnn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Id kasin et binaybay-ana nan kaipoipogaw ay mang-ik-ikkan isnan laylaydenda. ");
INSERT INTO xnn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ngem wada met laeng nan mangtekanda ay wada siya gapo isnan gawigawis ay inik-ikkana ay pala ken daida. Tay siya nan mang-it-ited isnan odan ya nan bomgasan di nais-ek ta waday katatagowanyo tasiyay men-gasing kayo.” ");
INSERT INTO xnn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ngem olay dinngeda nan kinwanin Pablo ay deey ngem kayakayatda kayet ay ipaltiyan daida. ");
INSERT INTO xnn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nakwas di dat wada nan Judio ay adi mamati ken Jesus ay iyAntiokia id Pisidia ya nan iyIconio ay inmey id isdi Listra. Dadat awisen nan kaipoipogaw ta gayangenda si Pablo. Idi nakagayangda dadat goyoden ay mangyey isnan soban nan ili tay kananda en natey. ");
INSERT INTO xnn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ngem idi likoben nan mamati ken Jesus siya dat bomangon et somagong isnan ili. Kawakgatana dat komaan da Pablo ken Bernabe ay omey id Derbe. ");
INSERT INTO xnn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Idi inomdan da Pablo id Derbe dadat isolo nan maipanggep ken Jesus isdi et adoado nan mamati. Dadat somagong id Listra ya id Iconio enggana id Antiokia ay ili id Pisidia ");
INSERT INTO xnn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ta papigsaenda nan pammatin nan ipogaw ay mamati ken Jesus issan damo ay inmayanda. Kinwanida en, “Itoltoloyyo kayet ay mamati ken Apo Jesus tay mapaligatan tako is nateketeken ay ligat esatakopay maitapi isnan mentolayan Apo Dios ay maid patenggana.” ");
INSERT INTO xnn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dadat mendotok is kalebbeng ay mangipangpango isnan iib-ada ay mamati isnan tonggal paggimgimongan nan mamati ken Jesus. Dadat mentepe ay mangilowalo ay mangitalek ken daida ken Apo Jesus ay mamatiyanda. ");
INSERT INTO xnn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Dadat idaan isnan probinsiya ay Pisidia et omeyda id Perge ay ili id Pamfilia. ");
INSERT INTO xnn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Insoloda nan maipanggep ken Jesus id Perge dadat omey id Atalia. ");
INSERT INTO xnn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dadat menlogan isnan bapor et somagongda id Antiokia id Siria. Sinmaada isdi isnan nangkewasanda isnan oblada tay siya di din ninlowalowan nan mamati ken Jesus ay nangidawat ken Apo Dios ta ay-ayowanana da Pablo ken Bernabe isnan oblada. ");
INSERT INTO xnn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Idi inomdanda id Antiokia dadat ipadagop nan mamati ken Jesus dadat ibaga am-in nan inpaik-ikkan Apo Dios ken daida. Inbagada abes ay inpalobos Apo Dios nan mangibagbagaanda isnan gawis ay damag isnan baken Judio ta mamatida abes ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nabayag nan nakitetean da Pablo ken Bernabe isnan mamati ken Jesus id isdi Antiokia. ");
INSERT INTO xnn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wada nan Judio ay iJerusalem id Judea ay inmey id isdi Antiokia dadat men-isolsolo isnan ipogaw ay baken Judio ay mamati ken Jesus. Kinwanida en, “Adi isalakan Apo Dios dakayo no adi kayo menpasegyat ay kaneg nan initdon Moses ay ogalimi ay Judio.” ");
INSERT INTO xnn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Isonga da Pablo ken Bernabe et pilmi nan inik-ikkanda ay makisongsongbat ay mangwani en adi masapol ay ikkanda. Isonga inbaan nan iyAntiokia ay mamati ken Jesus da Pablo ken Bernabe ya nan tap-ina ay omey id Jerusalem ta sootenda isnan aapostolis ya nan amam-a no sino nan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dat palobwaten nan mamati ken Jesus daida. Isnan nanglaosanda id Fenicia ya id Samaria et sinodsodokda isnan ib-ada ay Judio ay mamati ken Jesus nan mamatiyan nan baken Judio. Isonga men-galalasingda isnan nangdengnganda isdi. ");
INSERT INTO xnn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Inomdanda id Jerusalem dat men-galalasing nan aapostolis ya nan aamam-a ya am-in nan mamati ken Jesus ay mang-ila ken daida. Dat sodsodoken abes da Pablo nan inik-ikkan Apo Dios ay mangbadang ken daida isnan inmay-ayanda. ");
INSERT INTO xnn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ngem wada nan Fariseo ay mamati ken Jesus et tinmakdegda ay mangwani en, “Masapol ay bilinen tako nan baken Judio ta menpasegyatda ya patiyenda abes am-in nan linteg Moses ay patpatiyen tako ay Judio.” ");
INSERT INTO xnn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Dat menpamiting nan aapostolis ya nan aamam-a ay mangipangpango isnan mamati ta tolagenda nan kinwanin nan Fariseo ay maipanggep isnan linteg Moses. ");
INSERT INTO xnn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nabayag ay mentoltolagda dat tomakdeg si Pedro ay mangwani en, “Bebsatko, getkenyo ay sak-en nan pinilin Apo Dios ken datako id kasin ay en mangisolo isnan baken Judio isnan maipanggep ken Jesus tasiyay dengngenda ta patiyenda. ");
INSERT INTO xnn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Si Apo Dios ay mangtek isnan am-in ay nemnem di ipogaw et inpailana ay dawdawatena nan baken Judio no mamatida ken siya tay inpakapetna nan Ispirito Santo ken daida ay kaneg met laeng nan inikkana ken datako. ");
INSERT INTO xnn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Baken tako kedeng is kaam-amedan di layad Apo Dios. Tay dalosana nan basol nan ipogaw ay baken Judio met laeng no mamatida ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","No epdas inpagtek Apo Dios ay dawatena daida dayon layden ay mangpadas isnan anosna isnan mangmangwaniyanyo en masapol ay tongpalenda nan linteg tako dapay nan linteg ay kananyo en masapol ay tongpalenda et adi tako kabaelan ay mangtongpal? Olay din alal-apo tako id kasin et egayda nakaikkan. ");
INSERT INTO xnn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nodi getken tako ay maisalakan tako gapo isnan badang Apo Jesus ken datako et siya gedan nan maisalakanan nan baken Judio.” Siya di nan kinwanin Pedro. ");
INSERT INTO xnn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nakwas di dat gominek nan kaipoipogaw ta dengngenda nan mangsodokan da Bernabe ken Pablo isnan kaskasdaaw ay inik-ikkan Apo Dios ay mangbadang ken daida isnan nin-isolowanda isnan ipogaw ay baken Judio. ");
INSERT INTO xnn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nakwas abes di dat menkali si Santiago ay mangwani en, “Dakayo ay bebsat, dedengngenyo pod nan kanak. ");
INSERT INTO xnn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sinodsodok Simon Pedro din damo ay nangipailaan Apo Dios isnan layadna isnan ipogaw ay baken Judio tasiyay wada abes ken daida nan menbalin is ipogawna. ");
INSERT INTO xnn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Maiyiso abes nan kinwanin din mamadton Apo Dios ay naisolat id kasin ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kinwanin Apo Dios en, Awnitak kasin somagong ay men-ali et maisagong nan paliso isdin napigsa ay nin-aliyan din si David ");
INSERT INTO xnn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tasiyay mang-anap nan kaipoipogaw olay nan baken Judio ay inawisko ay menbalin is ipogawko. ");
INSERT INTO xnn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Siya di nan kinwanin Apo Dios ay inpagtekna id kasin.’” ");
INSERT INTO xnn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Dat itoloy Santiago ay mangwani en, “Isonga kanak en adi tako paligaten nan baken Judio ay mangdokdokog isnan pinatpatida id kasin ta mamatida ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nodi mensolat tako ken daida ta ibaga tako ta adida is-isda nan naiboyag isnan sinang didios ya adida is-isda nan napalti no egay nakaan nan basana isnan napaltiyana ya adida is-isda nan basa ya adida iseyseyep nan bakenda asawa. Tay no siya dadi nan ik-ikkanda et adi liligten ay pilmi nan Judio daida. ");
INSERT INTO xnn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tay getken am-in nan Judio nan naayda ay linteg ya enggana id kasin insolsoloda nan linteg Moses isnan kasinasinagoga ay madagdagopanda ay sinabado. Isonga gawis no ibaga tako isnan baken Judio ta tongpalenda nan naayda ta adi masaktan nan nemnem di Judio.” Kinwanin Santiago di. ");
INSERT INTO xnn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Dat owenan am-in nan aapostolis ya nan aamam-a ya nan am-in ay mamati ken Jesus. Dadat kanan en pomilida isnan amam-ada ta makkeyda ken da Pablo yas Bernabe ay omey id Antiokia. Nan pinilida et nan dowa ay apoda ay da Judas ay kangadan gedan is Barsabas yas Silas. ");
INSERT INTO xnn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Siya na nan inpaw-itda ay solat ken daida, “Naay di solatmi ay aapostolis, amam-a ya ib-ayo ay mamati ken Jesus id isna Jerusalem ken dakayo ay bebsatmi ay baken Judio id issa Antiokia ya isnan kailiili id Siria ya id Cilicia. ");
INSERT INTO xnn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Dinngemi ay mendodowa kayo gapo isnan insolon nan deeyda ay nagapo id isna ay inmey nangngawngaw isnan nemnemyo issa. Ngem baken kami is nangbaa ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Isonga ninmiting kami isna et ninemnemmi en gawis no piliyenmi nan ibaami ay makkey ken da Pablo yas Bernabe ay gayyem tako. ");
INSERT INTO xnn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Datona ay ipogaw et adida kawanan nan biyagda olay mateyda gapo isnan men-oblaanda ay pala ken Apo Jesu Kristo. ");
INSERT INTO xnn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nan pinilimi ay makkey ken daida et da Judas ken Silas ta ibagada abes nan insolatmi ay naay. ");
INSERT INTO xnn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nan kankananmi isna et inaboloyan abes nan Ispirito Santo. Adimi layden ay paligaten dakayo ay mangipapati ay tongpalenyo nan ogalimi. Basta siya dana nan gawis ay maik-ikkan. ");
INSERT INTO xnn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Adiyo is-isda nan naiboyag isnan sinang didios ya adiyo is-isda nan basa ya adiyo is-isda nan napalti no egay nakaan nan basa isnan napaltiyana. Adiyo abes iseyseyep nan bakenyo asawa. Gawigawis no siya dana nan tongtongpalenyo. Kedeng di is laydenmi ay ibaga ken dakayo issa.” Siya di nan insolatda. ");
INSERT INTO xnn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Idi nakasolatda dat komaan nan nangipaw-itanda isnan solat ay omey id Antiokia. Idi inomdanda dadat ipadagop nan mamati ken Jesus dadat ited nan solat. ");
INSERT INTO xnn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Basaenda pay dat gomasing nan nemnemda isnan gawis ay inbagbagana. ");
INSERT INTO xnn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Da Judas ken Silas et mamadton Apo Dios daida et adoado nan insolsoloda isonga pinmigsa nan pammatida. ");
INSERT INTO xnn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nakwas nan kaat ay agew dat palobwaten nan mamati ken Jesus da Judas. Kinwanida en, “Sapay koma ta bobowegen Apo Dios dakayo isnan omayanyo.” Dadat somagong id Jerusalem ay kad-an di nangbaa ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO xnn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ngem nataynan da Pablo ken Bernabe id Antiokia ay men-isolo ya mangibaga isnan maipanggep ken Jesus ya wada gedan nan iib-ada ay men-is-isolo. ");
INSERT INTO xnn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nakwas nan kaat ay agew dat kanan Pablo ken Bernabe, “Enta pasyalen nan ib-ata ay mamati ken Jesus isnan kailiili ay inmay-ayanta ay nangibaga isnan maipanggep ken Jesus ta ilanta no kas-anoda.” ");
INSERT INTO xnn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Inyoog Bernabe ngem laydena ay makkey si Juan Marcos. ");
INSERT INTO xnn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ngem kanan Pablo en olay adi makkey siya tay siya san linmayaw isdin kad-anda id Pamfilia et egayna itoloy ay mangbadang isnan oblada. ");
INSERT INTO xnn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dadat menbinogtak et mensiyanda. Isonga inboweg Bernabe si Marcos et menloganda isnan bapor ay omey id Chipre. ");
INSERT INTO xnn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ngem si Pablo et pinilina si Silas is kadwana. Dat ilowalowan nan mamati ken Jesus daida ta badangan Apo Dios daida isnan am-in ay omayanda. Dadat omey. ");
INSERT INTO xnn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Inmeyda isnan kailiili id Siria ya id Cilicia ta papigsaenda nan nemnem nan mamati ken Jesus isnan paggimgimonganda id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Inmeyda abes id Derbe ya id Listra. Dadat datngan si Timoteo ay esa ay mamati ken Jesus. Nan inana et Judio ay esa ay mamati abes ngem si amana et Griego. ");
INSERT INTO xnn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Dinayaw am-in nan mamati ken Jesus id Listra ya id Iconio si Timoteo. ");
INSERT INTO xnn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Et layden Pablo ay makkey si Timoteo ken daida ngem gapo tay gintek am-in nan ipogaw ay baken Judio si amana isonga sinegyatana ay kaneg nan ogalin di Judio ta adi masaktan nan nemnem di ib-ada ay Judio isnan il-ili ay omayanda. ");
INSERT INTO xnn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Isnan nangpasyalanda isnan kailiili isdi et inbagbagada san kinwanin nan aapostolis ya amam-a id Jerusalem ta siya di nan solotenda. ");
INSERT INTO xnn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Isonga nan mamati ken Jesus isnan paggimgimonganda et pinmigsa nan pammatida dapay inagew ay omad-adoda. ");
INSERT INTO xnn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nalpas di dadat idaan isnan il-ili id Frigia ya id Galacia tay inyadin nan Ispirito Santo nan omayanda id Asia ay mangibaga isnan maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Idi inomdanda isnan pep-eng nan probinsiya id Misia dadat kanan en omeyda id Bitinia ngem kasin inyadin nan Ispiriton Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Isonga dinaanda id Misia et inmeyda id Troas. ");
INSERT INTO xnn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nalabi dat ipaiitaw Apo Dios ken Pablo nan esay am-ama ay iMacedonia ay tomatakdeg ay menpakpakaasi ken siya ay mangwani en, “Omalika id isna Macedonia ta badangam dakami.” ");
INSERT INTO xnn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Isonga dakamit mensagana ay omey id Macedonia tay gintekmi ay inayagan Apo Dios dakami ay mangibaga isnan maipanggep ken Jesus isnan ipogaw isdi. Et sak-en si Lucas ay nakkey gedan. ");
INSERT INTO xnn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ninlogan kami isnan bapor id Troas dakamit mendagas id Samotracia. Mawakgat pay dakamit omey id Neapolis. ");
INSERT INTO xnn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nindessaag kami isdi dakamit mendaan ay omey isnan ili ay Filipos. Siya nan esay dakkel ay ili id Macedonia ay mentolayan nan iRoma. Nintee kami isdi is nadandan ay agew. ");
INSERT INTO xnn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Isnan Sabado ay omil-illengan di Judio et tinaynanmi nan ili et inmey kami isnan benget di ginawang tay kananmi en waay siya nan madagopan nan ib-ami ay Judio ay menlowalo. Dakamit tomokdo et makitoya kami isnan inin-a ay nadagop isdi. ");
INSERT INTO xnn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wada nan esa ay in-ina ay kangadan is Lydia ay iTiatira ay men-ilaklako is nangina ay lopot ay men-gadangdang. Olay baken Judio siya ngem solsolotena nan ogalin di Judio ay mangpatpateg ken Apo Dios. Idi dinngena nan kankanan Pablo dat ipanemnem Apo Dios ken siya ta patiyena nan inbagana. ");
INSERT INTO xnn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dadat menpabonyag ay sinbaey. Danat kanan ken dakami, “Mo kananyo en tet-ewa ay mamatiyak ken Apo Jesus, omali kayo isnan baeymi ta makitee kayo.” Inpapatina isonga inmey kami. ");
INSERT INTO xnn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Isnan esa ay agew, inmey kami isnan paglowalowan dat maisab-at nan babassang ay kinapet di anito. It-itdowan nan anito siya isonga ibagbagana nan awnit ommat isnan omali ay agew. Nan kabaa ken siya et adoado nan inalada ay lagbon san babassang tay lagbowen nan ipogaw siya no ibagana nan awnit ommat ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Dat omonod ken dakami ken Pablo ay mangibogbogaw en, “Nan naayda ay ipogaw et inbaan di kangatowan ay Dios daida. Ibagada nan masapol ay ikkanyo ta maisalakan kayo.” ");
INSERT INTO xnn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nadandan ay agew nan mang-ik-ikkanana isdi enggana ay naoma si Pablo tay agindadayaw nan anito ken Apo Dios. Isonga dat sagongen Pablo nan babassang et kanana isnan anito en, “Gapo isnan kabaelan nan ngadan Jesu Kristo et ibagak en taynam siya.” Dat tet-ewa komaan nan anito ay dagos. ");
INSERT INTO xnn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Idi gintek nan kabaa ken siya ay maid kasinda omalaan is siping dadat depapen da Pablo ken Silas dadat goyoden daida ay mangyey isnan kad-an di mentolay isnan malkitan. ");
INSERT INTO xnn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Dadat pabasolen daida isnan mentolay ay tinodingan nan iRoma ay mangwani en, “Datona ay Judio et ap-aposenda nan ili tako. ");
INSERT INTO xnn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tay adi mabalin ay soloten tako ay iRoma nan linteg ay isolsoloda.” ");
INSERT INTO xnn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dat nan kaipoipogaw abes et sapsapeenda da Pablo. Dat bisngaten nan mentoltolay nan badon da Pablo ay mangkaan dadat ipabaig daida. ");
INSERT INTO xnn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nakwas ay nabaibaigda dadat ibalod daida. Dadat ibilin isnan gowaldiya ta bantayana daida ay gawis. ");
INSERT INTO xnn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Idi dinngen nan gowaldiya nan kinwanida danat ipa-ey daida isnan kowalto isnan dogon nan pagbalodan danat ippey nan sikida isnan nalolokawan ay kaiw ay pag-ipitan. ");
INSERT INTO xnn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Tengan di labi pay dat menlol-owalo ya menkankanta da Pablo ken Silas ay mangdayaw ken Apo Dios dapay dedengngen nan ib-ada ay balod. ");
INSERT INTO xnn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dat kayanegyeg nan batawa is napigsa et naiwedwed am-in nan pagbalodan. Dat aped matokaban am-in nan segpan ya aped makaan nan kawal ay naitaked isnan kabalobalod. ");
INSERT INTO xnn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Binmangon nan gowaldiya et inilana ay natotokaban nan en-eneb isonga inasotna nan gamigna ay mangpatey isnan awakna tay kanana en waay linmayaw am-in nan balod. ");
INSERT INTO xnn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ngem ninbogaw si Pablo ay mangwani en, “Adim ikkan sa. Wada kami isna am-in.” ");
INSERT INTO xnn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dat ibagan nan gowaldiya ta waday mangyey is silaw. Dat menkakamo ay songgep et omey menpalintomeng ay aped menpaypayegpeg isnan sag-en da Pablo ken Silas. ");
INSERT INTO xnn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Danat pabal-en daida et sootena en, “Apo, sino nan masapol ay ikkak tapno maisalakanak ay maitapi ken Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Masapol ay patiyem si Apo Jesu Kristo ta maitapika ya nan pamilyam ken Apo Dios,” kinwanin Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dat itdowan da Pablo daida am-in ay sinbaey isnan kankanan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Daan pay ay tengan di labi dat ayagan nan gowaldiya daida et owasana nan sogatda isnan nangbaiganda ken daida dadapay menpabonyag am-in ay sinbaey. ");
INSERT INTO xnn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Danat ayagan da Pablo ken Silas isnan baeyda ta pakanena daida. Et men-gasingda am-in ay sinbaey tay ninbalinda is mamati ken Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Mawakgat pay dat ibaan nan mentolay nan polis ta ipalobosda da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dat ibagan san gowaldiya ken Pablo en, “Kanan nan mentolay en maipalobos kayo ken Silas. Isonga enkayo ya sapay koma ta badangan Apo Dios dakayo.” ");
INSERT INTO xnn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ngem kinwanin Pablo isnan polis en, “Adi, tay apedda inpasaplit ya inpabalod dakami dadapay egay nangsomalya on-ona ta getkenda no tet-ewa ay waday basolmi. Dapay paliso nan kalebbenganmi isnan iRoma. Ayke mabalin ay igagoda nan inikkanda ken dakami ay mangwani en aped kami igiginek ay komaan? Gag-awis no daida ay mismo nan omali ay mangipalobos ken dakami.” ");
INSERT INTO xnn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Dat ibagan nan polis nan kinwanin Pablo isnan mentolay. Et inmegyatda isnan nangdengnganda ay iRoma gedan da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Isonga inmeyda isnan pagbalodan ta menpakawanda esadapay ipango daida ay komaan isnan pagbalodan dadapay kanan no mabalin ta komaanda isnan ili. ");
INSERT INTO xnn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Isonga kinmaan da Pablo ken Silas isnan pagbalodan et omeyda isnan baey Lydia. Nakidagopda isnan ib-ada ay mamati ken Jesus et insolowanda daida ta pomigsa kayet nan pammatida. Dadat komaan. ");
INSERT INTO xnn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Linaosan da Pablo ken Silas id Amfipolis ya id Apolonia dadat omdan id Tesalonica et wada isdi nan sinagoga ay madagdagopan di Judio. ");
INSERT INTO xnn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tolo ay Sabado ay in-inmey si Pablo isnan sinagoga ay men-isolo isnan kalin Apo Dios. Tay nan ogalin Pablo no omey isnan teken ay ili et nan sinagoga nan omayana on-ona ay men-isolowan. ");
INSERT INTO xnn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nan insolsolona et nan naisolat ay kankanan Apo Dios ay masapol ay matey si Kristo dat kasin matago. Danat kanan, “Si Jesus ay ibagbagak ken dakayo et siya nan inbaan Apo Dios ay makwani en Kristo.” ");
INSERT INTO xnn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wadada nan Judio ay mamati et naitapida ken da Pablo yas Silas. Adoado abes nan mamati ay baken Judio ay nangsolsolot isnan ogalin di Judio ya nan inin-a ay wada nan kalebbenganda. ");
INSERT INTO xnn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ngem omapal nan Judio dadat dagopen nan mamakedse ay ipogaw ya nan menbaybayanggodaw ta menngalawngawda enggana ay magolo am-in nan omili. Dadat ipapati ay songgep isnan baey Jason ay esay mamati tay siya nan mentetean da Pablo. Tay laydenda ay pabal-en daida ta ilan nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ngem egayda makadateng isonga ginoyodda da Jason ya nan ib-ana ay mamati ken Jesus dadat iyey daida isnan mentolay. Dadat pabasolen daida ay mangwani en, “Wada nan ipogaw ay manggolgolo isnan kailiili et naay inmalida abes isna. ");
INSERT INTO xnn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Dat si Jason ay naay et palanglang-ayena daida. Et am-in nan mangpati ken daida et adida patiyen nan linteg Ali Cesar dadapay kanan en wada nan teken ay ali ay kangadan is Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Idi dinngen nan mentolay ya nan kaipoipogaw nan kinwanida dadat makaliget. ");
INSERT INTO xnn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dadat moltaen da Jason ya nan ib-ana esadapay ipalobos daida. ");
INSERT INTO xnn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nalabi dat palobwaten nan mamati ken Jesus da Pablo ken Silas ta omeyda id Berea. Idi inomdanda isdi dadat omey isnan sinagoga ay madagdagopan nan ib-ada ay Judio. ");
INSERT INTO xnn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nan Judio id Berea et gag-awis nan nemnemda mo nan Judio id Tesalonica tay laylaydenda ay mangdengdenge isnan kankanan Apo Dios. Inagew ay basbasaenda nan naisolat ay liblon Apo Dios ta ilanda no tet-ewa nan isolsolon da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Isonga adoado nan mamati ken Jesus. Adoado abes nan wada nan kalebbenganda ay inin-a ya nan amam-a ay baken Judio ay mamati. ");
INSERT INTO xnn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ngem idi gintek nan Judio id Tesalonica ay inmey da Pablo id Berea ay mangisolo isnan maipanggep ken Jesus dadat omonod. Dadat omawis is ipogaw ta amisenda da Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Isonga nan mamati ken Jesus et inpalobwatda ay dagos si Pablo ta omey isnan ili isnan benget nan baybay ngem nataynan da Silas ken Timoteo id Berea. ");
INSERT INTO xnn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nan nangipango ken Pablo et nakkeyda enggana id Atenas. Dadat somaa id Berea et ibagada ken da Silas yas Timoteo nan kinwanin Pablo ta ikakamoda ay omey mangdateng ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nan kad-an Pablo id Atenas ay mangses-eed ken da Silas et inilana nan adoado ay tinagtago ay sinang didios di ipogaw id isdi et palalo nan sakit nan nemnemna. ");
INSERT INTO xnn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Isonga nakitoytoya isnan Judio ya nan baken Judio ay mangdayaw ken Apo Dios isnan sinagoga. Winakgat abes ay omey isnan malkitan ay makitotya isnan madagdagop isdi. ");
INSERT INTO xnn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dat wada nan omey ay makisongbat ken Pablo. Daida nan mangsolsolot isnan insolon din si Epicureo ya din si Estoicio. Wada ken daida nan mangwani en, “Ngan nan kankanan nan naay ay aped menkalkali is maid paayna?” Kanan abes nan tap-ina en, “Waay nan teken ay dios nan isolsolona.” Kananda di tay insolon Pablo nan maipanggep ken Jesus ya nan kasin matagowan di ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dadat ayagan siya et eyeyda isnan bilig ay kananda en Areopago ay pag-ag-aggongan di amam-a et kananda en, “Mo mabalin ta ipagtekmo ken dakami nan naay balo ay isolsolom. ");
INSERT INTO xnn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nasdaaw kami isnan isolsolom tay teken. Ket no mabalin laydenmi ay getken nan kayat ay kanan nan kankanam.” ");
INSERT INTO xnn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Siya di nan kinwanida tay am-in nan omili id Atenas olay nan nagapo isnan teken ay ili ay nakiili id isdi et iyaagewda ay mangibagbaga wenno mangdengdenge isnan balo ay solsolo. ");
INSERT INTO xnn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Dat tomakdeg si Pablo isnan sasagangen nan ipogaw id isdi Areopago et kanana en, “Dakayo ay iyAtenas, inilak ay pilmi nan mangnemnemnemanyo isnan diosyo ");
INSERT INTO xnn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","tay pinasyalko nan iliyo et inilak nan adoado ay mangdaydayawanyo isnan kadiodiosyo et wada abes nan esa ay inilak ay naisolatan nan kali ay mangwani en, ‘Siya na nan mangdaydayawanmi isnan dios ay adimi getken.’ Nan Dios ay dayawenyo ay adiyo getken et siya nan ipagtekko ken dakayo id wani. ");
INSERT INTO xnn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Et siya si Apo Dios ay nangboliw isnan batawa ya nan am-in ay mentetee. Et baken isnan sinang bab-aey ay sinapon di ipogaw is menteteana tay siya nan Apo isnan am-in, nan daya ya nan batawa. ");
INSERT INTO xnn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Et maid masapolna is mabalin is ibadang tako ay ipogaw ken siya tay siya nan mangiyal-ali isnan biyag tako ya am-iam-in ay masapol tako. ");
INSERT INTO xnn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Es-esang nan ipogaw ay binoliw Apo Dios isdin damo et siya nan poon nan kaipoipogaw isnan am-in ay kailiili isnan batawa. Enggana id kasikasin et pinilin Apo Dios nan timpon nan menlebbengan nan nateketeken ay ipogaw ya nan il-ili ay awnitda mentean. ");
INSERT INTO xnn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Inikkana di tasiyay nemnemnemenda siya koma ta moke siya di nan mangtekanda ken siya tay baken met ad-addawi ken datako. ");
INSERT INTO xnn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kaneg nan esay nangwani en, ‘Si Apo Dios nan nangiyali isnan biyag ken datako. Siya abes nan nangiyali isnan nemnem tako ya wawawawada siya ken datako isnan am-in ay ik-ikkan tako.’ Wada din nakaadal ay ib-ayo abes ay nangwani en, ‘Si Apo Dios nan kaanak ken datako.’ ");
INSERT INTO xnn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Isonga kanak en nan anak et awatenda nan kaanak ken daida. No datako nan anak Apo Dios et adi kabalin ay kanan tako en balitok wenno bato si Apo Dios ay sinapon di nalaing ay ipogaw is tinagtago. ");
INSERT INTO xnn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Id kasin inan-anosan Apo Dios nan inik-ikkan din ipogaw ay egayna dosdosaen daida tay egayda getken siya. Ngem id wani et inbilina ay masapol ay dokogan am-in nan ipogaw nan ngawi ay ik-ikkanda. ");
INSERT INTO xnn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tay epdas ninemnem Apo Dios nan agew ay mangbanagana isnan kaipoipogaw ta ibagana nan maitapi ken siya ya nan adi. Inpagtekna ay si Jesus nan pinilina ay mang-ikkan is dana tay tinagona kasin siya. Si Apo Dios nan mangtek isnan timpo ay mangibanagana isnan kaipoipogaw et nan ikkana ay mangbanag et gawigawis.” ");
INSERT INTO xnn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Idi dinngeda nan nangwaniyan Pablo en wada nan kasin matago ay ipogaw et nin-ammeng nan tap-ina. Ngem nan tap-ina et kinwanida en, “Laydenmi ay dengngen nan kankanam is mamingsan kasin.” ");
INSERT INTO xnn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dat taynan Pablo daida. ");
INSERT INTO xnn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wadada nan naitapi ken Pablo ay mamati ken Jesus. Nan esa et si Dionisio ay esay am-ama ay makipangbon isnan obong di Areopago. Si Damaris ay in-ina nan esa ya wadada abes nan tap-ina. ");
INSERT INTO xnn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nakwas di dat komaan si Pablo id Atenas et omey id Corinto. ");
INSERT INTO xnn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Dinatngana isdi da Akila ken Priscila ay sin-asawa ay iPonto. Judio datona et kadatdatengda ay nagapo id Italia tay inpakaan Ali Claudio am-in nan Judio id Roma ay dakkel ay ili id Italia. Inmey si Pablo ay mang-ila ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Dat makitetee ken daida tay kanegna daida ay mensapsapo is lalat ay baey isonga nakiob-obla ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sinabado ay omey si Pablo ay mangiyis-ispikal isnan maipanggep ken Jesus isnan sinagoga ta mamati koma nan Judio ya nan baken Judio. ");
INSERT INTO xnn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Idi inomdan da Silas ken Timoteo ay nagapo id Macedonia daida nan makiobla dapay eesten Pablo ay mangibagbaga ay inagew isnan maipanggep ken Jesus isnan Judio. Ibagbagana en tet-ewa ay si Jesus nan makwani en Kristo ay inbaan Apo Dios ay mentoltolay. ");
INSERT INTO xnn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ngem inaposda ya inoyawda siya isonga inyagyag Pablo nan badona ta ipagtekna ay adina kasin isolsolowan daida. Kinwanina en, “Kigad kayo is ik-ikkanyo no madosa kayo tay id wani et maid bibiyangko ken dakayo. Isonga taynak dakayo ta omeyak ay mangisolo isnan baken Judio.” ");
INSERT INTO xnn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Dat komaan et egay kasin men-isolo isnan sinagoga ngem inmey isnan baey Tito Justo ay baken Judio ngem si Apo Dios nan daydayawena. Nan baeyna et naisasag-en isnan sinagoga. ");
INSERT INTO xnn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ngem si Crispo ay apon di sinagoga ya nan pamilyana et mamatida ken Jesus. Adoado abes nan iCorinto ay mamati isnan nangdengnganda isnan kinwanin Pablo dadat menpabonyag. ");
INSERT INTO xnn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Isnan esay labi et ninpaiitaw si Apo Dios ken Pablo ay mangwani, “Adika omegyat isnan ipogaw id isna tay adi mabalin ay aamisen daka tay wadaak ken sik-a. Isonga itoltoloymo ay men-isolo tay adoado pay laeng nan egay mamati ay laydek ay maitapi ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Isonga nintetee si Pablo isdi is esay tew-en ya kagedwa ay mangisolsolo isnan kankanan Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Idi men-gobilnadol si Galion id Acaya dat makitoya nan Judio ay adi mamati et eyeyda si Pablo ay mangidalom isnan gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kananda en, “Nan naay am-ama et aw-awisena nan ipogaw ta teken nan ikkanda ay mangdayaw ken Apo Dios ay bakenmi linteg.” ");
INSERT INTO xnn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kanan Pablo ta komali dat kanan Gobilnadol Galion isnan Judio, “No waday inikkan tosa is ngawi et masapol ay dengek nan ibagayo. ");
INSERT INTO xnn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ngem gapo tay maipanggep isnan ogaliyo ya nan mentontonanyo isnan agiyo ya nan lintegyo nan lililiyenyo et adiyak layden ay mangdedenge is dasa. Isonga kigad kayo ay mangnemnem is ikkanyo.” ");
INSERT INTO xnn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Danat ipakaan daida isnan kad-ana isdi. ");
INSERT INTO xnn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dat ikawen nan kaipoipogaw si Sostenes ay ap-apon nan sinagogan di Judio dadat baigen isnan pantew nan mentetean nan gobilnadol. Ngem olay inilan Gobilnadol Galion nan ik-ikkanda et binaybay-ana daida. ");
INSERT INTO xnn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nabayag pay laeng si Pablo id Corinto danat taynan nan ib-ana ay mamati ken Jesus. Nakkey da Akila ken Priscila ken siya. Idi inomdanda id Cencrea dat menpaapolog si Pablo tay siya nan ogalida ta getken nan ib-ana ay wada nan insapatana ken Apo Dios. Dadat menlogan isnan bapor et omeyda id Siria. ");
INSERT INTO xnn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Idi inomdanda id Efeso dat songgep si Pablo isnan sinagoga ay madagdagopan di ib-ada ay Judio ay makitoya ken daida. Laydenda ay makitetee siya ken daida ngem adina layden. Ngem isnan kinmaanana et inbagana ken daida en, “No layden Apo Dios, awnitak kasin omali.” Danat taynan da Akila ay sin-asawa et menlogan isnan bapor ay omey id Siria. ");
INSERT INTO xnn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nindessaag id Cesarea ay esay ili id Siria dat omey id Jerusalem ay mang-ila isnan mamati ken Jesus isnan paggimgimonganda isdi esapay omey id Antiokia id Siria. ");
INSERT INTO xnn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nabayag isdi esapay kasin komaan et pasyalena am-in nan il-ili id Galacia ya id Frigia et men-is-isolo isnan mamati ken Jesus ta pomigpigsa nan pammatida. ");
INSERT INTO xnn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Daan si Pablo id Galacia ya id Frigia dat wada nan esa ay Judio ay iyAlejandria ay inmey id Efeso. Nan ngadana et Apolos. Nalaing siya ay men-isolo et adoado nan getkena maipanggep isnan kalin Apo Dios ay naisolat id kasikasin. ");
INSERT INTO xnn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Et wada din nangisolo ken siya maipanggep ken Apo Jesus ngem kedeng nan inbagan Juan ay din menbonbonyag is insolona. Nagaget si Apolos ay men-isolo isnan maipanggep ken Jesus ngem adina getken am-in. ");
INSERT INTO xnn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Idi tinmoled si Apolos ay men-isolo isnan sinagoga et siya di nan nangdengngan da Akila ken Priscila ken siya. Dadat ayagan ay makkey is baeyda et isoloda nan egayna getken maipanggep ken Jesus ya nan inik-ikkana. ");
INSERT INTO xnn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dat layden Apolos ay omey men-isolo isnan probinsiya id Acaya. Isonga ninsolat nan ib-ana id Efeso isnan mamati ken Jesus id Acaya ta sangailiyenda siya ay gawis. Idi inomdan isdi et adoado nan badangna isnan ipogaw ay mamati gapo isnan nangipailaan Apo Dios isnan layad ya anosna ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nalaing siya ay makisongsongbat isnan Judio ay mang-ap-apos ken siya isonga inabakna daida tay inpailana nan wada isnan naisolat ay kalin Apo Dios ay mangpaneknek ay si Jesus nan Kristo ay inbaan Apo Dios ay mangisalakan isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Daan si Apolos id Corinto ay esay ili id Acaya dat omey si Pablo id Efeso et indaana isnan bilbilig ay magapo id Frigia. Idi inomdan id Efeso dat wada nan dinatngana ay mamati. ");
INSERT INTO xnn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Danat sooten ken daida en, “Ay kinapet nan Ispirito Santo dakayo isnan namatiyanyo?” “Egay,” kinwanida. “Maid getkenmi isnan kanam en Ispirito Santo.” ");
INSERT INTO xnn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Dat kanan Pablo kasin, “Sino nan kaneg din ninpabonyaganyo?” “Kaneg din inikkan Juan ay ninbonyag nan ninpabonyaganmi,” kinwanida. ");
INSERT INTO xnn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dat kanan Pablo, “Nan insolon Juan isdin ninbonyagana et inbagana isnan ipogaw ta menpabonyagda ay mangipaila ay ibabawida nan basbasolda. Ngem inbagana abes en masapol ay patiyen nan ipogaw nan maisokat ken siya ay si Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Idi dinngeda di dadat mamati ken Jesus dadat kasin menpabonyag ngem nan naikadwa ay ninpabonyaganda et gapo isnan pammatida ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Idi inpatang Pablo nan ledengna ken daida dat kapten nan Ispirito Santo daida et komalida is nateketeken ay kali ay mangibaga isnan inpagtek Apo Dios ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Nan kabibilangda et waay simpoo ya dowa. ");
INSERT INTO xnn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tolo ay bowan nan nin-isolowan Pablo isnan sinagoga ay madagdagopan nan ib-ana ay Judio id Efeso. Intoledna ay mangisolo isnan maipanggep isnan mentolayan Apo Dios tasiyay maawisda ta patiyenda gedan si Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ngem wada nan makedse ay ipogaw ay mang-adi ay mamati et oyawenda nan ibagbagan Pablo maipanggep ken Jesus isnan kad-an nan nadagop ay ipogaw. Isonga tinaynan Pablo daida dat makkey ken siya nan mamati ken Jesus. Inmeyda isnan oskilaan Tirano. Dat inagew ay men-isolsolo si Pablo isdi. ");
INSERT INTO xnn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Doway tew-en nan nin-isolsolowana isdi isonga am-in nan ipogaw id Asia ay Judio ya nan baken Judio et dinngeda nan maipanggep ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Si Pablo et adoado nan inpaikkan Apo Dios ken siya ay maid nakail-ila is kanegna. ");
INSERT INTO xnn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Tay olay nan panyo wenno galot ay kapposena dat maiyey isnan masaksakit ya nan kinapet di anito et gomawisda ya taynan nan anito daida. ");
INSERT INTO xnn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ngem wada nan Judio ay mensip-ok ay om-omey ay mangipagawis isnan kinapet di anito. Dadat padasen ay mang-osal isnan ngadan Apo Jesus ay mangwani en, “Sik-a ay anito, komaanka id wani tay si Jesus ay insolon Pablo nan mangipakaan ken sik-a.” Siya di nan kinwanida isnan anito. ");
INSERT INTO xnn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Nan tap-in nan nang-ikkan isdi et nan pito ay an-ak Sceva ay esa isnan menkangangato ay padin di Judio. ");
INSERT INTO xnn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ngem sinongbatan nan anito daida ay mangwani en, “Getkek da Jesus ken Pablo et omegyatak ken daida. Ngem dakayo et adiyak getken dakayo.” ");
INSERT INTO xnn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dat nan ipogaw ay kinapet nan anito et dinpapna daida et gapo isnan pigsan nan anito et inabakna daida am-in dadat lomayaw ay menlalabos ya nakiblakibladan. ");
INSERT INTO xnn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Idi dinngen nan Judio ya nan baken Judio ay mentetee id Efeso dadat omegyat isnan kabaelan Apo Dios dapay omam-amed nan kinapateg nan ngadan Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Dat wada nan namati ken Jesus ay mensip-ok id kasin ay omey ken Pablo ta ipagtekda nan inik-ikkanda esadapay mamati. ");
INSERT INTO xnn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Isonga adoado nan nangibala isnan inos-osalda ay mensip-ok ya mensapsapo. Dadat dagopen am-in et iilaen nan kaipoipogaw nan nangpoowanda. Nan banol nan deeyda et omey is limampoo ay libo. ");
INSERT INTO xnn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Isonga naiwalagawag nan maipanggep ken Jesus et inmad-ado nan mamati ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Idi nakwas di dat nemnemen Pablo ay omey isnan probinsiya id Macedonia ya id Acaya esapay omey id Jerusalem. Kanana abes en masapol ay omey id Roma. ");
INSERT INTO xnn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Isonga inbaana on-ona nan dowa ay kabadangna ay da Timoteo ken Erasto ay omey id Macedonia. Dapay mataynan si Pablo isnan probinsiya id Asia ay kad-an nan ili ay Efeso et mentee isdi is sin-awyan. ");
INSERT INTO xnn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Isnan kawad-ana isdi et siya di nan ninlogiyan nan nin-golowan nan kaipoipogaw maipanggep isnan mamati ken Jesus. Siya na nan inommat. ");
INSERT INTO xnn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wada nan am-ama ay kangadan is Demetrio ay nalaing ay menbesa is balitok. Adoado nan men-oblaena ay mensapsapo is sinang sisimbaan nan diosda ay babai ay nginadnanda is Artemis. Ilaklakoda nan sinang sisimbaan ay deey et dakkel abes nan galansiyada. ");
INSERT INTO xnn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Isonga menpamiting si Demetrio isnan men-ob-oblaena ya nan am-in ay ib-ana ay menbesbesa et kanana en, “Dakayo ay kakadwak, getkenyo ay nan obla tako ay besa nan menkatagowan tako. ");
INSERT INTO xnn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Iilaen tako ya dedengngen tako abes ay adoado nan mamati isnan isolsolon Pablo id isna Efeso ya gistay am-iam-in nan kailiili isnan probinsiya id Asia. Et awisena daida ta dokoganda si Artemis tay kanana en baken tet-ewa ay dios nan aped sinapon nan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Naligat na tay awnit maid mangpaay isnan sapowen tako ay menbesbesa. No ipalobos tako nan ik-ikkan Pablo et baken kedkedeng nan obla tako is adida paayen nodi awnitda kanan abes en maid bilang nan simbaan nan kangatowan ay dios tako ay si Artemis ya mamaid nan panangdayawda ken Artemis dapay siya nan dios nan kaipoipogaw isnan probinsiya id Asia ya nan kailiili isnan batawa.” Siya di nan kinwanin Demetrio. ");
INSERT INTO xnn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Idi dinngen nan menbesbesa nan kinwanina dadat makaliget dadat kasibobogaw ay mangwani en, “Madaydayaw si Artemis ay dios id Efeso.” ");
INSERT INTO xnn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Isonga nagolo am-in nan omili dadat asitatagtag ay omey isnan kadagdagopan di ipogaw dadat depapen da Gayo ken Aristarco ay iMacedonia ay boweg Pablo isnan inmayanda id Efeso. Dadat goyoden daida ay mangyey isnan madagdagopan nan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Si Pablo abes et kanana en ta omey isnan madagdagopan nan kaipoipogaw ngem nan mamati ken Jesus et egayda inpalobos. ");
INSERT INTO xnn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Olay nan gagayyem Pablo ay menlelebbeng isnan probinsiya et inbaada nan omey mangibaga ken Pablo ta adi menpail-ila koma isnan madagdagopanda. ");
INSERT INTO xnn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nan ipogaw isnan madagdagopanda pay et wasdin menbogbogaw is teken tay adi men-iso nan nemnemda tay nan kaadowan ken daida et egayda getken nan poon nan nadagopanda. ");
INSERT INTO xnn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dat ipatakdeg nan Judio nan ib-ada ay si Alejandro isnan kad-an nan kaipoipogaw ta iyispikalna koma nan om-ommat. Isonga tinmakdeg si Alejandro et pinadasna ay mangipaginek isnan ipogaw ta kaliyana daida. ");
INSERT INTO xnn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ngem inmatonanda ay Judio siya dadat eesangen nan ibogbogawda is nganngani ay doway olas ay mangmangmangwani en, “Madaydayaw si Artemis ay dios id Efeso.” ");
INSERT INTO xnn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ngem nan esay nangato ay ipogaw isnan ili et inpaginekna daida danat kanan ken daida, “Dakayo ay kailiyak ay iyEfeso, ayke maid mangtek ay datako nan mangbanbantay isnan simbaan nan madaydayaw ay dios tako ay si Artemis ya nan tinagtago ay bato ay nagapo id daya id kasin? ");
INSERT INTO xnn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Maid mabalin is mangwani en baken tet-ewa na isonga masapol ay igiginekyo ay adi kayo kaneg matawtawaw. ");
INSERT INTO xnn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nan ipogaw ay inyaliyo isna et maid inakewda isnan simbaan tako ya egayda oyawen nan dios tako. ");
INSERT INTO xnn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Isonga no wada nan ipogaw ay idalom da Demetrio ya nan ib-ana et wada nan howis isnan opisinada ya olay nan menlelebbeng isnan probinsiya et wadada abes. Isonga idalomda koma ken daida esapay songbatan abes nan idalomda. ");
INSERT INTO xnn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","No waday tap-in di laydenyo is maibaga et totyaen tako isnan osto ay miting tako. ");
INSERT INTO xnn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tay gapo isnan inikkanyo id wani mabalin ay maidalom tako isnan apo tako id Roma et sino ngen nan isongbat tako tay maid osto is ninpoonan nan nin-golowanyo.” ");
INSERT INTO xnn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kinwanina di danat kanan en mabokada. ");
INSERT INTO xnn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Idi nakwas nan nin-golowan nan menbesbesa dat ayagan Pablo nan mamati ken Jesus ay mangipagaget ken daida isnan pammatida esanapay taynan daida ay omey id Macedonia. ");
INSERT INTO xnn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Isnan nangpaspasyalana isnan kailiili id isdi ay men-is-isolo isnan mamati ken Jesus et ginmasingda dat omey id Acaya. ");
INSERT INTO xnn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tolo ay bowan nan ninteteana id isdi danat kanan en menlogan isnan bapor ta omey koma isnan probinsiya id Siria ngem dat maipagtek nan kanan nan Judio ay adi mamati ken Jesus en pateyenda siya. Isonga ninemnemna ay kasin idaan id Macedonia. ");
INSERT INTO xnn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Idi inomdan kami id Filipos dat omon-ona nan ib-ami ay menlogan isnan bapor ay omey mangseed ken dakami id Troas. Daida da Sopatro ay anak Pirro ay iBerea ken Aristarco yas Segundo ay iTesalonica yas Gayo ay iDerbe yas Timoteo ya da Tikico ken Trofimo ay iyAsia. ");
INSERT INTO xnn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Idi nakwas nan fiesta ay nangananda isnan tinapay ay egay kabobodan dakamit menlogan isnan bapor. Sak-en si Lucas ay nakkey abes. Inmey nan limay agew esamipay datngan nan ib-ami id Troas. Et nakadomingomi isdi. ");
INSERT INTO xnn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Isnan Domingo et nadagop kami am-in ay mamati ken Jesus ta kanenmi nan tinapay ay mangnemnemanmi isnan nateyan Jesus. Dat men-isolo si Pablo enggana isnan tengan di labi tay kanana en komaan isnan kawakgatana. ");
INSERT INTO xnn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Adoado nan silaw isnan kowalto id ngato ay ninteteanmi. ");
INSERT INTO xnn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nan esa ay baballo ay si Eutico et intotokdona isnan tawa. Idi nabayag ay ninkalkali si Pablo dat mentomtom-e si Eutico dat maseyep isonga natekdag ay nagapo isnan maikatlo ay galadon nan baey. Idi enda bangonen dat obpay natey et. ");
INSERT INTO xnn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ngem linmayog abes si Pablo et enna gen-an danat kanan, “Adi kayo madanagan tay natago kasin.” ");
INSERT INTO xnn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dat kasin tomikid si Pablo dakamit mangan isnan tinapay ay mangnemnemanmi isnan nateyan Jesus. Dat kasin makikalkali si Pablo engganay mawakgat dat komaan. ");
INSERT INTO xnn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","San baballo pay et inyeyda isnan baeyda dadat men-galalasing tay daan ay matatago. ");
INSERT INTO xnn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ngem isnan komaananmi et inbilin Pablo ay menlogan kami isnan bapor ay omey id Asson dapay ta mendad-aan siya ay omey isdi esamipay dag-osen siya. ");
INSERT INTO xnn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Idi ninsab-at kami id Asson dat makilogan ken dakami et omey kami am-in id Mitilene. ");
INSERT INTO xnn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Napseng dakamit kasin menlobwat et linaosanmi id Chio. Napseng abes dakamit domag-os id Samos. Kasin mawakgat pay dakamit idadawes ay omey id Mileto ");
INSERT INTO xnn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","tay kananmi en adi kami domag-os id Efeso tay adi layden Pablo ay mabayag kami id Asia tay menkakamo siya ay omdan id Jerusalem esapay omdan nan fiesta ay Pentecostes no mabalin. ");
INSERT INTO xnn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Isonga isnan kad-anmi id Mileto et inbaan Pablo nan omey id Efeso ay mang-ayag isnan mangipangpango isnan mamati ken Jesus id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Idi inmalida danat kanan ken daida en, “Dakayo ay amam-a, getkenyo am-in nan inik-ikkak isnan nakiteteak ken dakayo isnan probinsiyayo id isna Asia enggana isdin damo ay inmaliyak. ");
INSERT INTO xnn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tinongpalko am-in nan inbagan Apo Jesus ken sak-en. Egayak aped ninpapangato. Getkenyo abes ay no mamingsan et mensakit nan nemnemko gapo isnan inik-ikkan nan ib-ak ay Judio ay nangpalpaligat ken sak-en ay mangpatey koma ngem itoltoloyko kayet nan oblak. ");
INSERT INTO xnn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Getkenyo abes ay maid egayak inbagbaga is men-gawisanyo isdin nin-it-itdowak ken dakayo isnan madagdagopanyo ya isnan bab-aeyyo. ");
INSERT INTO xnn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Getkenyo abes ay insetko ay mangibagbaga isnan ib-ak ay Judio ya nan baken Judio ay masapol ay dokoganda nan basolda ta patpatiyenda si Apo Dios ya mamatida ken Apo Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Isonga id wani omeyak id Jerusalem tay siya nan inbagan nan Ispirito Santo ken sak-en. Et adiyak getken am-in nan awnit ommat ken sak-en id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ngem inpagtek nan Ispirito Santo ken sak-en isnan kailiili ay linal-aosanmi ay awnitak maibalod ya mapaligatan id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ngem napatpateg nan bilin Apo Jesus is ikkak mo nan awakko isonga kedeng nan mangkewasak isnan inpaoblan Apo Jesus ken sak-en is nemnemnemek. Et siya nan mangibagbagaak isnan gawis ay damag ay mangipagpagtek isnan dakkel ay badang Apo Dios isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Inbagbagak ken dakayo nan maipanggep isnan mentolayan Apo Dios ay maid patenggana. Ngem menlogi id wani et getkek ay adi kayo kasin il-ilaen sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Isonga ibagak ken dakayo en no waday awnit madosa isnan impilno et adi kabalin ay omipabasol kayo ");
INSERT INTO xnn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","tay maid egayak inbaga isnan layden Apo Dios ay maipagtek ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Isonga dakayo ay amam-a, pagawisenyo koma nan nemnemyo dayot abes banbantayan ay gawis nan ipogaw ay inted nan Ispirito Santo ay biyangyo tapno solsolotenda si Kristo ay osto. Isolowanyo ay gawis nan mamati ken Jesus tay nan nang-itedana isnan awakna ay matey nan insakbotna ken datako. ");
INSERT INTO xnn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Getkek ay no komaanak et awnit omali nan men-isolo isnan baken tet-ewa ay kanegda atap ay animal ay mangpatey isnan talaken. Kanak di tay laydenda ay madadael nan pammatin nan ipogaw Apo Dios ay banbantayanyo. ");
INSERT INTO xnn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Olay ken dakayo ay mamati et wada nan maitatapi ken dakayo ay awnit men-isolo isnan baken tet-ewa ta awisenda nan mamati ken Jesus ta daida nan patiyenda. ");
INSERT INTO xnn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Isonga makailanyo. Nemnemenyo ta toladenyo nan inik-ikkak isnan toloy tew-en ay nakiteteak ken dakayo ay egayak somalsaldeng ay men-isolo ken dakayo ay olay no mamingsan et men-ag-agaak gapo isnan dakkel ay seg-angko ken dakayo. ");
INSERT INTO xnn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Id wani italekko dakayo ken Apo Dios ya isnan mait-itdo maipanggep isnan pilmi ay badangna ken datako. Tay nan mait-itdo ay naay et kabaelana ay mangipapigsa isnan pammati tako ya mang-ited isnan gawis ay it-ited Apo Dios isnan ipogawna. ");
INSERT INTO xnn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sak-en pay et egayak ninkedkedaw is sipingyo wenno badoyo. ");
INSERT INTO xnn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Tay getkenyo ay kigadak ay nin-ob-obla is ninkatagok ya nan ninkatagon nan iib-ak. ");
INSERT INTO xnn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tay siya di gedan nan inpail-ilak ken dakayo et gawis no men-obla tako ta waday ibadang tako isnan makasapol tay nenemnemek nan kinwanin Apo Jesus en, ‘Am-amed nan gasing nan men-ited ay mangbadang isnan makasapol mo nan gasing nan maagtan.’” ");
INSERT INTO xnn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Idi nakakali si Pablo dadat menpalintomeng am-in ay menlowalo. ");
INSERT INTO xnn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Dadat men-aga ay mangikawe koma ken siya tay adida layden ay komaan siya. ");
INSERT INTO xnn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tay pilmi ay menseseg-angda gapo isnan nangdengnganda ay adida kasin esa men-in-inila. Dadat ipango siya enggana isnan bapor. ");
INSERT INTO xnn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Dakami ken da Pablo et idi kasin kami ninlogan ay mangtaynan ken daida et indadawesmi id Coos. Isnan napsengana inmey kami id Rodas. Idi napseng abes dat id Patara. ");
INSERT INTO xnn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Et dinatnganmi isdi nan esay bapor ay omey id Fenicia. Dat siya nan ninlogananmi. ");
INSERT INTO xnn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Isnan omay-ayanmi et linaosanmi id Chipre isnan makanigidmi. Damit indadawes id Tiro ay esay ili isnan probinsiya id Siria dakamit mendessaag tay siya nan nangipadessaaganda isnan kalga. ");
INSERT INTO xnn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Dinatnganmi nan mamati ken Jesus et nakadomingomi ay nakitetee ken daida. Dadat ibaga ken Pablo ta adi omey id Jerusalem tay inpagtek nan Ispirito Santo ken daida en awnit mapaligatan id isdi. ");
INSERT INTO xnn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ngem idi nakwas nan ninteteanmi id isdi dakamit omey kayet. Dadat masinbabaey ay mangipango ken dakami enggana isnan baybay ay benget nan ilida. Dakamit menpalintomeng ay menlowalo. Idi nakapakada kami ken daida dadat palobwaten dakami. ");
INSERT INTO xnn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Dakamit menlogan isnan bapor dadapay somaa isnan bab-aeyda. ");
INSERT INTO xnn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ninlogan kami enggana id Tolemaida ay nagapo id Tiro dakamit mendessaag. Nakiag-aggong kami isnan mamati ken Jesus id isdi et siya nan inmapaanmi. ");
INSERT INTO xnn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Idi nawakgat dakamit komaan ay omey id Cesarea. Nan baey Felipe nan nakiteteanmi id isdi. Siya nan esa isnan pito ay napili ay mangbadang isnan aapostolis id Jerusalem id kasin. Men-is-isolo abes maipanggep ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wada abes nan epat ay an-akda ay bababassang ay mamadton Apo Dios. ");
INSERT INTO xnn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nakitetee kami id isdi is nadandan ay agew dat wada nan am-ama ay mamadton Apo Dios ay kangadan is Agabo ay inmali ay nagapo id Judea. ");
INSERT INTO xnn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Dat omali ay mang-ila ken dakami. Danat alan nan balikes Pablo et ibedbedna isnan ledengna ya nan sikina danat kanan en, “Siya na nan kayat ay ipagtek nan Ispirito Santo. Nan kakwa isnan balikes ay naay et siya nan awnit esa ogden nan Judio id Jerusalem ay kaneg met laeng nan naikkan isnan ledengko ya nan sikik ay nag-od. Awnitda abes idalom isnan baken Judio ay mangipapatey ken siya.” Kinwanin Agabo di. ");
INSERT INTO xnn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Idi dinngemi di dakamit menpakaasi am-in ta adi koma omey si Pablo id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Dat songbatan Pablo ay mangwani en, “Dayon agaan sak-en? Dayon pasakiten nan nemnemko? Nakasaganaak isnan mangibalodanda ken sak-en olay no mangpateyda id Jerusalem maipanggep isnan pammatik ken Apo Jesus.” ");
INSERT INTO xnn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Idi adi kabalin ay ipapatimi nan kayatmi dakamit iginek et kananmi en, “Sapay koma ta nan layden Apo Dios di ommat.” ");
INSERT INTO xnn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nakwas nan ninteteanmi isdi dakamit mensagana ay omey id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wada abes nan mamati ken Jesus ay iCesarea ay nakkey abes id Jerusalem. Dadat ipango dakami isnan baey Nason ay iChipre tay siya nan kananda en menteanmi. Si Nason et nabayag ay mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nan mamati ken Jesus id Jerusalem et ginmasingda isnan inomdananmi isdi. ");
INSERT INTO xnn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Idi napseng dakamit omey ay menpaila ken da Santiago ya nan am-in ay amam-a ay mangipangpango isnan mamati ken Jesus. ");
INSERT INTO xnn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Idi nin-asiinilada dat sodsodoken Pablo am-iam-in nan inpaikkan Apo Dios isnan baken Judio isnan nin-isolowana ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Idi dinngeda di dadat daydayawen si Apo Dios. Ngem kinwanida ken Pablo, “Besatmi, getkem et kalibolibo nan bilang nan Judio ay mamati ken Jesus et am-iam-inda et ipapatida ay mangwani en masapol ay matongpal nan linteg tako ay Judio. ");
INSERT INTO xnn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ngem wada nan nangibaga ken daida en initdowam kano nan Judio ay wada isnan ilin di baken Judio ta taynanda nan linteg tako ay initdon din si Moses. It-itdom kano ta adida segyatan nan an-akda ya adida soloten nan ogali tako. ");
INSERT INTO xnn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","24","Isonga sino nan ikkan tako ta getken nan ib-a tako ay egaymo initdo dadi tay kapilitan ay awnitda dengngen ay wadaka isna? Waay siya ngalod na nan gawis ay ikkam. Makkeyka isnan naayda epat ay amam-a ay wada nan insapatada ken Apo Dios. Et omey kayo isnan Templo ta menpaila kayo isnan padi ta tongpalenyo nan kanan nan linteg tako ay maikkan. No makwas pay nan pitoy agew dakat bayadan nan masapolda ta mabalin ay apologan nan padi daida. Et awnit siya nan mangtekan nan ipogaw en tongpalem gedan nan linteg tako. ");
INSERT INTO xnn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ngem nan baken Judio ay mamati ken Jesus et adimi kanan ta patiyenda nan linteg tako ay Judio. Kedkedeng san bilin ay insolatmi ken daida ta adida is-isda nan naiboyag isnan sinang didios ya adida is-isda nan basa ya adida is-isda nan napalti no egay nakaan nan basana isnan napaltiyana ya adida iseyseyep nan bakenda asawa.” Siya di nan kinwanin da Santiago ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Isonga napseng dat maiboweg si Pablo isnan epat ay amam-a et omeyda isnan Templo et menpailada isnan padi ta ipagtekda nan agew ay kakwasan nan ikkanda esadapay menpalti ya menpaapolog. ");
INSERT INTO xnn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nganngani ay makwas nan pitoy agew dat wadada nan Judio ay nagapo id Asia ay nang-ila ken Pablo isnan Templo. Dadat ibaga isnan kaipoipogaw ta sapeenda si Pablo dadat depapen ");
INSERT INTO xnn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","dadapay menbogaw isnan ib-ada ay Judio ay mangwani en, “Akayo gagayyem. Mangbadang kayo tay si tona nan om-omey isnan kailiili ay men-is-isolo isnan naikakasiyo ken datako ay Judio ya nan Templo tako ya nan linteg tako ay initdon din si Moses. Nan esa pay ay inikkana et padogisena nan Templo tako tay inpasgepna nan baken Judio.” ");
INSERT INTO xnn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kinwanida di tay inilada ay inboboweg Pablo nan esay iyEfeso ay si Trofimo isnan ili id Jerusalem et kananda en waay inisgepna siya isnan Templo. ");
INSERT INTO xnn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Idi dinngen nan omili id Jerusalem di dadat makaliget dadat kasitatagtag ay en mangikawe ken Pablo et goyodenda ay mangibala isnan Templo dadat emban. ");
INSERT INTO xnn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Laydenda ay mangpatey ken siya koma ngem dinngen nan apon di soldado ay iRoma ay mentoltolay id Jerusalem ay men-golgolo am-in nan omili. ");
INSERT INTO xnn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Danat ipaayag nan kakapitan ya nan sosoldadoda dadat asitatagtag ay omey mangdateng isnan kaipoipogaw. Idi ilan nan ipogaw san apo ya san sosoldado dadat isaldeng ay mangbab-aig ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dat ikawen san apo si Pablo et ipag-odna is doway kawal danat sooten isnan kaipoipogaw no sino nan ngadana ya nan basolna. ");
INSERT INTO xnn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ngem nateketeken nan insongbatda dadapay menngalngalawngaw isonga egay maawatan san apo nan kinwanida. Isonga kinwanina en maiyey isnan menteteanda ay sosoldado. ");
INSERT INTO xnn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Idi inomdanda isnan agdan dadat lak-eyen siya ay mangipapangato tay dadama nan inikkan nan kaipoipogaw ");
INSERT INTO xnn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ay nangboboweg ken daida dadapay menbogbogaw ay mangwani en, “Pateyen tako.” ");
INSERT INTO xnn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Si Pablo pay isnan songsonggepanda isnan mentetean di sosoldado et kinwanina issan apo, “No mabalin koma wada nan ibagak ken sik-a.” Dat nasdaaw san apo tay gintek Pablo nan kalina ay Griego tay siya nan inkalina. ");
INSERT INTO xnn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Kanak en sik-a san iyEgipto ay ninpagolo isnan ipogaw id kasin ay apon di epat ay libo ay ninpatey is ipogaw ay nangboboweg ken siya isnan pondag,” kinwanin san apo ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","“Bakenak,” kinwanin Pablo. “Judiowak ay iTarso id Cilicia et waay maid egay nangtek isnan ilimi. Et wada nan kayatko ay ibaga isnan ipogaw ay naayda no mabalin.” ");
INSERT INTO xnn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Dat owenan san apo dat tomakdeg si Pablo isnan agdan danat ipaginek nan kaipoipogaw. Idi ginminekda dat komali si Pablo isnan Hebreo ay kalin nan ib-ana ay Judio. ");
INSERT INTO xnn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Kinwanin Pablo en, “Dakayo ay bebsatko ya am-ak, dengngenyo pod nan isongbatko isnan ipabasolda ken sak-en.” ");
INSERT INTO xnn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Idi dinngeda ay Hebreo nan kalina dadat am-amed gominek. Dat itoloy Pablo ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Sak-en et Judiowak. Naiyanakak id Tarso ay esay ili isnan probinsiya id Cilicia. Ngem id isna Jerusalem nan nasiknak. Si Gamaliel din mistolok ay nangisolo ken sak-en am-in isnan linteg din alal-apo tako ay Judio. Napigsa nan pammatik ken Apo Dios ay kaneg ken dakayo abes id isna. ");
INSERT INTO xnn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tay sak-en abes et pinalpaligatko ya inpapateyko nan mamati ken Jesus. Olay lalalaki wenno bababai et dinpapko daida am-in ay mangipabalod. ");
INSERT INTO xnn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Nan kangatowan ay padi ya nan am-in ay amam-a tako et getkenda nan inik-ikkak. Mabalin ay paneknekanda ay tet-ewa nan ibagbagak tay daida nan nangiyali is solat ay maipaw-it isnan ib-a tako ay Judio id Damasco ta mabalin ay omeyak id isdi ay mangdepap isnan mamati ken Jesus ta iyalik daida id isna Jerusalem ta madosada. ");
INSERT INTO xnn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ngem isnan nganngani ay omdananmi id Damasco et nakag-aw dat aped mapanat-a din kad-ak et masilanganak isnan pat-a ay nagapo id daya. ");
INSERT INTO xnn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Daket matokang daket dengngen nan mangmangwani en, ‘Saulo, Saulo dakan mangpalpaligat?’ ");
INSERT INTO xnn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Daket songbatan, ‘Sinoka, Apo?’ Danat kanan en, ‘Sak-en si Jesus ay iNazaret ay mangisakit isnan ipogawko ay palpaligatem.’ ");
INSERT INTO xnn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nan iib-ak pay et inilada nan pat-a ngem egayda dengngen nan ninkalkali ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Daket kanan, ‘Sino nan masapol ay ikkak, Apo?’ Danat kanan ken sak-en en, ‘Ibangonmo ta omeyka id Damasco ta maipagtek ken sik-a isdi nan awnitak ipaikkan ken sik-a.’ ");
INSERT INTO xnn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ngem adiyak makaila tay nakowapak isnan nasiliyak issan pat-a. Isonga nan iib-ak et pinadangda sak-en ay mangipango enggana ay inomdan kami id Damasco. ");
INSERT INTO xnn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Wada id Damasco nan kangadan is Ananias. Gawis nan inik-ikkana ay mamati isnan linteg Moses isonga lispitowen am-in nan ib-a tako ay Judio id Damasco siya. ");
INSERT INTO xnn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Dat omali siya et tomakdeg isnan sag-enko. Danat kanan ken sak-en, ‘Besatko ay Saulo, mapokyatan nan matam ta makailaka.’ Daket bitagen nan matak et ilak siya. ");
INSERT INTO xnn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Danat kanan ken sak-en, ‘Nan Dios ay dinaydayaw din alal-apo tako et pinilina sik-a ay mang-ila ya mangdenge isnan maibagay ay Anakna tay laydena ay getkem nan ipaikkana ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tay sik-a nan awnit mangipagtek isnan kaipoipogaw isnan inilam ya dinngem. ");
INSERT INTO xnn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sino nan sedsed-em? Ibangonmo ta menpabonyagka. Apowem si Apo Jesus ta makaan nan basolmo.’ Siya di nan inbagan Ananias ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Idi sinmagongak id isna Jerusalem daket menlol-owalo isnan Templo tako dat wada nan kaneg iitaw ay inpailan Apo Dios ken sak-en ");
INSERT INTO xnn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","tay inilak si Jesus ay mangwani ken sak-en en, ‘Ikakamom ay mangtaynan id isna Jerusalem tay awnit adi patiyen nan ib-am ay Judio id isna nan ibagbagam maipanggep ken sak-en.’ ");
INSERT INTO xnn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ngem kinwanik ken siya, ‘Waay mamatida, Apo, tay getkenda ngalod ay id kasin et sak-en nan nangbab-aig ya nangipabalbalod isnan mamati ken sik-a isnan kasinasinagoga ay madagdagopanda. ");
INSERT INTO xnn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Getkenda abes nan gasingko id kasin ay mangbantay isnan nangpateyanda isdin si Esteban ay esay nangibagbaga isnan maipanggep ken sik-a. Sak-en pay nan nanggegeen isnan badon di nangpatey ken siya.’ ");
INSERT INTO xnn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Danat kanan ken sak-en en, ‘Olay, omeyka et tay ibaak sik-a ay omey men-is-isolo isnan baken Judio isnan anaanaddawi ay il-ili.’” Siya di nan inbagan Pablo isnan kaipoipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Et dinngen nan kaipoipogaw siya enggana isnan nangwaniyana en omey isnan baken Judio dadat menbogaw ay mangwani en, “Pateyen tako siya tay gag-awis no matey.” ");
INSERT INTO xnn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Et nakaligetda dadat aped iwasawas nan badbadoda ya itabtab-okda nan tapok gapo isnan ligetda. ");
INSERT INTO xnn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Dat ipasgep nan apon di sosoldado si Pablo isnan menteteanda ta ipabaigna ta ibagana nan tet-ewa no aytay dan aped nakaliget nan kaipoipogaw ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ngem idi ibaodda siya tasiyay baigenda koma dat komali si Pablo isnan kapitan ay tinmatakdeg isnan sag-ena ay mangwani en, “Ayke waday lebbengyo ay mangbaig isnan ipogaw ay waday kalintegana ay kanega iRoma no egay kasomalya on-ona?” ");
INSERT INTO xnn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Idi dinngen nan kapitan nan kinwanina danat omey ibaga isnan apona. Kinwanina en, “Sino nan aped tako ik-ikkan dapay wada nan kalintegan tona ay kanega iRoma?” ");
INSERT INTO xnn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Dat omey nan apo ay mangsoot ken Pablo ay mangwani, “Ibagam no tet-ewa ay iRomaka.” Dat kanan Pablo en, “Owen, tet-ewa.” ");
INSERT INTO xnn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Dat kanan nan apo, “Olay sak-en ngem dakkel nan inbayadko ta mabalin ay maibilangak ay iRoma.” “Ngem sak-en,” kanan Pablo, “maid inbayadko tay naiyanakak ay iRoma abes.” ");
INSERT INTO xnn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Dat nan deeyday mangbaig koma ken siya et kinmaanda ya olay nan apoda et inmegyat isnan nangtekana ay apedna inpabaod nan ipogaw ay wada nan kalintegana ay kanega iRoma. ");
INSERT INTO xnn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Isnan napsengana et kayat nan apo ay getken nan osto ay mangipabasolan nan Judio ken Pablo isonga inpakaana nan naigagalot ken siya danat ipatogop nan menkangangato ay papadi ya nan am-in ay amam-an di Judio. Danat ipatakdeg si Pablo ta komali ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Dat inengneng Pablo nan amam-a et kanana en, “Dakayo ay iib-ak ay Judio, getken Apo Dios ay enggana id wani et ostoosto nan mangsolsolotak ken siya isonga maid babawin nan nemnemko.” ");
INSERT INTO xnn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ngem si Ananias ay kangatowan ay padi et inbagana isnan naisasag-en ken Pablo ta tampikenda nan topekna. ");
INSERT INTO xnn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Dat kanan Pablo ken siya en, “Ayke adi dosaen Apo Dios sik-a abes tay aginngangatoka tay bistaem sak-en maipanggep isnan linteg tako ngem sik-a nan nakabasol tay inpatampikmo sak-en dapay iyadin nan linteg tako di is maikkan.” ");
INSERT INTO xnn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Dat kanan nan naisasag-en ken siya, “Damen aped oyawen nan kangatowan ay padin Apo Dios?” ");
INSERT INTO xnn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Dat kanan Pablo, “Mosaya gintekko ay siya nan kangatowan ay padi, gagayyem, ta egayak koma kinwani di tay kanan nan naisolat ay kalin Apo Dios en adi tako oyawen nan apo tako.” ");
INSERT INTO xnn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Dat ilan Pablo nan amam-a ay wada nan doway dagop ay Fariseo ya Saduceo. Nan Saduceo et daida nan mamati ay adi kasin matago nan ipogaw no epdas natey ya kananda en maid anghel wenno ab-abiik. Ngem nan Fariseo et patiyenda ay wada am-in dadi. Dat nemnemen Pablo nan limidyona. Isonga ibibiyadna nan kalina ay mangwani en, “Gagayyem ay amam-a, sak-en et Fariseowak. Naiyanakak ay Fariseo. Isonga patiyek ya sedsed-ek nan kasin matagowan nan natey ay ipogaw. Dapay siya di nan apedyo mangipabasolan ken sak-en.” Et siya nan nin-asiligtan nan Fariseo ya nan Saduceo tay adi men-iso nan pammatida. ");
INSERT INTO xnn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Isonga ninngangalawngawda ay menbogaw. Dat tomakdeg nan tap-in di Fariseo ay men-is-isolo isnan linteg et ipapatida ay mangwani en, “Maid magtek is basol nan ipogaw ay naay tay waay tet-ewa ay ninpaila nan adi kaila wenno anghel ken siya.” ");
INSERT INTO xnn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Dadat am-amed men-asisongbat isonga inmegyat nan apon di sosoldado moditya men-ginoyodanda si Pablo et maanok-a nan awakna isonga inbilina isnan sosoldado ta enda eyey isnan menteteanda. ");
INSERT INTO xnn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dat isnan labi, ninpaila si Apo Jesus ken Pablo ay mangwani en, “Adika omegyat tay awnitmo ipagtek nan maipanggep ken sak-en id Roma ay kaneg met laeng nan inik-ikkam id isna Jerusalem.” ");
INSERT INTO xnn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Isnan napsengana wada nan epatpoo ay Judio ay adi mamati ken Jesus ay nintotya no sino nan ikkanda ay mangpatey ken Pablo. Ninsapatada am-in ay adida mangmangan ya adida omin-inom engganay pateyenda si Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Dadat omey makitoya isnan menkangangato ay papadi ya nan amam-an di Judio ay mangwani en, “Insapatami ay adi kami mangmangan engganay pateyenmi si Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Isonga dakayo ay amam-ami et kadya ibagayo isnan apon di sosoldado ta iyalina si Pablo isnan naay pagmitinganyo ay kaneg laydenyo tet-ewa ay somalyaen siya ay gawis. Dakamit siimen siya isnan daan ta pateyenmi siya esapay omdan isna.” ");
INSERT INTO xnn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ngem nan kaanakan Pablo et dinngena ay siimen koma san deeyda ay ipogaw si Pablo. Isonga inmey isnan mentetean di sosoldado ay mangibaga ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dat ayagan Pablo nan kapitan danat kanan ken siya, “Eyeymo nan baballo ay naay isnan apoyo tay wada nan ibagana ken siya.” ");
INSERT INTO xnn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Isonga inyey nan kapitan danat kanan, “Nan balod ay si Pablo et inayagana sak-en ta ipangok nan baballo ay naay tay wada kano nan ibagana ken sik-a.” ");
INSERT INTO xnn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Dat padangen nan apo san baballo et gomaygay-edda ta makekedengda danat sooten no sino nan kayatna ay ibaga. ");
INSERT INTO xnn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Dat kanan nan baballo isnan apon di sosoldado en, “Nan Judio et nintotolagda ta ibilinda ken sik-a ta eyeymo si Pablo isnan pagmitinganda is wakgat ta somalyaenda ay gawis kano. ");
INSERT INTO xnn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ngem adim kadi patpatiyen daida tay nasolok is epatpoo ay ipogaw nan mangsis-iim ken siya tay insapatada en adida mangmangan ya adida omin-inom engganay pateyenda siya. Nakasaganada et kedkedeng nan kanam is sesed-enda.” ");
INSERT INTO xnn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Dat kanan nan apo, “Adim ibagbaga ay inbagam nan naay ken sak-en.” Kinwanina di danat pabalaen san baballo. ");
INSERT INTO xnn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Dat ayagan nan apo nan dowa ay kapitan danat kanan ken daida, “Isaganayo nan dowanggasot ay sosoldado ay mangipango ken Pablo id Cesarea ya nan dowanggasot ay menbabalbeg ya nan pitompoo ay mensakay is kabayo. Ngem sokod alas nowibi isnan labi esakayopay menlobwat. ");
INSERT INTO xnn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Pasakayenyo abes si Pablo. Dayot bantayan siya ta maid ommat ken siya enggana ay id-anyo ken Gobilnadol Felix.” Siya di nan inbagana isnan kakapitan. ");
INSERT INTO xnn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ninsolat abes ay mangwani en, ");
INSERT INTO xnn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Apo Gobilnadol Felix, sak-en si Claudio Lisias nan mensolat et komostaka. ");
INSERT INTO xnn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nan ipogaw ay naay et dinpap nan Judio tay kananda en pateyenda. Ngem dakami ya nan sosoldado et dinatnganmi siya. Idi gintekko ay iRoma siya et inbaliwak. ");
INSERT INTO xnn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ngem gapo tay kayatko ay getken no sino nan ipabasolda ken siya et inyeyko isnan aamam-ada. ");
INSERT INTO xnn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Isonga getkek ay maid basolna is gapo ay maibalod wenno mapatey tay maipanggep isnan lintegda nan gapo ay nakaligtanda ken siya. ");
INSERT INTO xnn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Idi wada nan nangipagtek ken sak-en en wada nan mangsiim ken siya daket kanan en gawis no maiyey ay dagos ken sik-a. Inbilinko abes isnan nangidalom ken siya ta omeyda abes issa ta ibagada ken sik-a no sino nan ipabasolda ken siya.” Siya di nan naisolat. ");
INSERT INTO xnn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Idi nalabi dat ipangon nan sosoldado si Pablo enggana id Antipatrisa tay siya nan inbilin nan apoda ken daida. ");
INSERT INTO xnn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kawakgatana dat somagong nan tap-in di sosoldado isnan menteteanda id Jerusalem daet kedeng nan nakasakay is kabayo nan nangiboweg ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Idi id-anda si Pablo id Cesarea dadat iyey siya ya nan solat isnan gobilnadol. ");
INSERT INTO xnn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Idi binasan nan gobilnadol nan solat danat sooten ken Pablo no sino ay probinsiya nan nagapowana dat ibagan Pablo en iCilicia siya. ");
INSERT INTO xnn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Dat kanan nan gobilnadol ken siya en, “Esak somalyaen sik-a no omali nan nangidalom ken sik-a.” Kinwanina di danat ibaga ta magowaldiyaan si Pablo isnan baey ay inpasaad din ali ay si Herod. ");
INSERT INTO xnn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nallos nan limay agew dat omey nan kangatowan ay padi ay si Ananias ya nan tap-in di amam-an di Judio ya nan esay abogadoda ay si Tertulo id Cesarea ta ibagada isnan gobilnadol nan ipabasolda ken Pablo. ");
INSERT INTO xnn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Idi inpaayag nan gobilnadol si Pablo dat ibagan Tertulo nan ipabasolda ken siya. Kanana en, “Madaydayaw ay Apo Gobilnadol. Gapo isnan gawigawis ay ik-ikkam ay mentolay ken dakami et sinmaldeng nan nang-aamis ken dakami dapay adoado nan nas-et isnan kad-anmi. ");
INSERT INTO xnn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Et am-in kami isnan kailiili et getkenmi am-in nan inik-ikkam et men-iyaman kami ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Adiyak layden ay tawtawen sik-a ngem no mabalin ta anosam ay mangdedenge isnan naay atiatik ay ibagami ken sik-a. ");
INSERT INTO xnn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nan ipogaw ay naay et getkenmi ay ngawi siya tay golgolowena am-in nan Judio isnan kailiili isnan batawa. Siya gedan nan esay apon nan obon di ipogaw ay mamati ken Jesus ay iNazaret ay mang-ad-adi ay mangsolot isnan tet-ewa. ");
INSERT INTO xnn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Pinadasna abes ay padogisen nan Templomi ay mangdaydayawanmi ken Apo Dios isonga dinpapmi. ");
INSERT INTO xnn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","(-) ");
INSERT INTO xnn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","No somalyaem et magtek ay tet-ewa am-in nan ibagbagami.” Siya di nan kinwanin Tertulo ken Felix. ");
INSERT INTO xnn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Nan iib-an Tertulo abes et ab-aboloyanda nan kankanana. ");
INSERT INTO xnn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Dat ipakalin Gobilnadol Felix si Pablo. Et siya na nan songbatna. Kanana en, “Getkek ay nabayag nan nintolayam ken dakami ay Judio isonga men-gasingak ay mangsongbat isnan ipabasol datona ken sak-en tay sik-a nan wada. ");
INSERT INTO xnn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nalaka ay getkem ay egay nasolok is simpoo ya doway agew nan ninteak id Jerusalem. Inmeyak isdi ay mangdayaw ken Apo Dios isnan Templona. ");
INSERT INTO xnn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Maid polos nang-il-anda ken sak-en is makisongsongbatak isnan Templo wenno nanggolgolo isnan kaipoipogaw isnan kasinasinagoga wenno isnan kompolmi ay kad-anda. ");
INSERT INTO xnn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Maid polos mabalin is ikkanda ay mangpaneknek isnan naay ay ipabasbasolda ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ngem kedeng na is getkek ay tet-ewa is kinwanida tay tet-ewa ay maitatapiyak isnan mamati ken Jesus ay kananda en teken ay solsolo. Si Apo Dios ay dinaydayaw din alal-apomi nan daydayawek abes ngem nan initdon Jesus nan solsolotek ay mangdaydayaw ken siya. Patiyek pay am-in nan naisolat isnan lintegmi ya nan am-in ay insolat nan mamadton Apo Dios id kasin. ");
INSERT INTO xnn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nan naayda ay amam-ami ay Judio et patpatiyenda ya sedsed-enda gedan nan patpatiyek ya sedsed-ek et siya di nan mangtagowan Apo Dios isnan am-in ay natnatey ay gawis wenno ngawi. ");
INSERT INTO xnn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Gapo tay siya di nan patpatiyek et padpadasek ay mang-ikkan isnan gawis tasiyay adiyak mabainan ken Apo Dios ya isnan ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nabayag ay kinmaanak id Jerusalem et kadatdatengak ay en mang-ited isnan siping ay maibadang isnan ib-ak ay makasapol. Daket omey abes ay menpalti ta maiboyag ken Apo Dios isnan Templona. ");
INSERT INTO xnn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Et maid mabalin is ipabasolda ken sak-en tay siya di san ik-ikkak isnan nangdatngan nan Judio ay iyAsia ken sak-en isnan Templo. Kagapgapowak ay en ninpaila isnan padi. Maid met menngangalawngaw isdi ya maid abes adoado is ipogaw. ");
INSERT INTO xnn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","San deeyda ay iyAsia koma nan inmali ay mangidalom no waday ipabasolda ken sak-en. ");
INSERT INTO xnn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ngem maidda isonga nan naayda ay amam-ami nan mangibaga koma no tet-ewa ay waday getkenda is basolko isnan nangsomalyaanda isnan nadagopan nan amam-a id Jerusalem. ");
INSERT INTO xnn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nan getkek et kedeng ay kananda en basolko et nan inbagak ken daida isnan nangitakdegak ay nangibiyad isnan kalik ay mangwa