﻿USE sofia;
DROP TABLE IF EXISTS sofia.xnj_vpl;
CREATE TABLE xnj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xnj_vpl WRITE;
INSERT INTO xnj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chenichi ndi chitabu cha lukolo lwa Yesu Kilisitu mweavi chiveleku cha Daudi wa chiveleku cha Ibulahimu. ");
INSERT INTO xnj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu amveliki Izaki, Izaki amveliki Yakobo, Yakobo amveliki Yuda na valongo vaki, ");
INSERT INTO xnj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda amveliki Pelisi na Zela, nyina wavi avili Tamali, Felikisi amveliki Heziloni, Heziloni amveliki Lami, ");
INSERT INTO xnj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lami amveliki Aminadabu, Aminadabu amveliki Nashoni, Nashoni amveliki Solomoni, ");
INSERT INTO xnj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Solomoni na Lahabu vamveliki Boazi, Boazi na Lutu vamveliki Obedi, Obedi amveliki Yese, ");
INSERT INTO xnj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","mwene Yese amveliki Nkosi Daudi. Daudi amveliki Solomoni, nyina waki avi mdala wa Uliya, ");
INSERT INTO xnj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni amveliki Lehobohamu, Lehobohamu amveliki Abiya, Abiya amveliki Asa, ");
INSERT INTO xnj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa amveliki Yeoshafati, Yeoshafati amveliki Yolamu, Yolamu amveliki Uzia, ");
INSERT INTO xnj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia amveliki Yotamu, Yotamu amveliki Ahazi, Ahazi amveliki Hezekia, ");
INSERT INTO xnj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia amveliki Menasi, Menasi amveliki Amoni, Amoni amveliki Yosia, ");
INSERT INTO xnj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia amveliki Yekonia na valongo vaki. Lwenulo ndi lwavi lukumbi lwa Vayawudi pavapelikwi kuluhamilu ku Babeli. ");
INSERT INTO xnj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lukumbi Vayawudi pevavi kuluhamilu ku Babeli, Yekonia amveliki Shealitieli, Shealitieli amveliki Zelubabeli, ");
INSERT INTO xnj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli amveliki Abiudi, Abiudi amveliki Eliakimu, Eliakimu amveliki Azoli, ");
INSERT INTO xnj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli amveliki Zadoki, Zadoki amveliki Akimu, Akimu amveliki Eliudi, ");
INSERT INTO xnj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi amveliki Eleazali, Eleazali amveliki Matani, Matani amveliki Yakobo. ");
INSERT INTO xnj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo amveliki Yosefu, mngwana wa Maliya, nyina waki Yesu mweikemiwa Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kwavi na viveleku kumi na mcheche kuhuma Ibulahimu mbaka Daudi, vivelekelu kumi na mcheche kuhuma Daudi mbaka Vayawudi pavatoliwi uvanda wa ku Babeli, viveleku kumi na mcheche kuhuma uvanda mbaka kuvelekewa kwa Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Chenichi ndi cheavelekiwi Yesu Kilisitu. Maliya nyina wa Yesu, achumbiwi na Yosefu. Nambu vakona vangatama ngati mngwana na mdala, Maliya apatili kuvya na ndumbu kwa makakala ga Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ndava Yosefu mngwana wa Maliya avi mundu mbwina palongolo ya Chapanga aganili lepi kumpela soni pavandu ndi aholalili kumleka chamfiyu. ");
INSERT INTO xnj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Peavi akona ihololela lijambu lenilo, Mtumu wa kunani kwa Chapanga amuhumali munjozi na kumjovela, “Yosefu, mwana wa Daudi, ukotoka kuyogopa kumtola Maliya avya mdala waku, muni ndumbu yeavinayu apatili kwa makakala ga Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yati iveleka mwana mgosi hinu veve yati ukumpela liina Yesu ndava mwenuyu yati akuvasangula vandu kuhuma kumbudila Chapanga wavi.” ");
INSERT INTO xnj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mambu goha ago gahumalili muni kutimilisa malovi ga Bambu geajovili munjila ya mlota wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yuwanila! Kamwali yati ivya na ndumbu, yati iveleka mwana mgosi, na veve yati ukumpela liina Emanueli.” Mana yaki “Chapanga avi pamonga na tete.” ");
INSERT INTO xnj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ndi Yosefu peayumwiki mulugono akitili ngati mtumu wa kunani kwa Chapanga cheamjovili, akamtola mdala waki na kuhamba nayu kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambu agonili nayu lepi mbaka Maliya peamveliki mwana mgosi, namwene Yosefu ampeli liina Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hinu Yesu avelikiwi kumuji wa Betelehemu, mulima wa Yudea lukumbi lwa ulongosi wa nkosi Helodi. Bahapo peamali kuvelekwa vevimanya mambu ga ndondo kuhuma kwe lihumila lilanga vabwelili ku Yelusalemu, ");
INSERT INTO xnj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","vakavakota vandu, “Avi koki mwana yula, mweavelikwi kuvya Nkosi wa Vayawudi? Tiyiweni ndondo yaki yeyahumali kwe lihumila lilanga, na tete tibwelii kumgundamila.” ");
INSERT INTO xnj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nkosi Helodi peayuwini ago, akavagaya mwene pamonga na vandu voha vevitama pa Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hinu akavakemela pamonga vamteta vakulu va Chapanga voha na vawula va Malagizu, akavakota, “Wu, Kilisitu Msangula yati ivelekewa koki?” ");
INSERT INTO xnj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Vene vakamyangula, “Muji wa Betelehemu mulima wa Yudea, ngati cheayandiki mlota wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Veve muji wa Betelehemu mulima wa Yudea, veve katu wamdebe lepi mumiji yivaha ya Yudea, muni kwa veve yati ihumila chilongosi, mweilongosa vandu vangu, Isilaeli.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hinu, Helodi avakemili kuchiyepela vandu vala vevimanya mambu ga ndondo avakotakisi lukumbi chakaka ndondo payavaumalili. ");
INSERT INTO xnj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kangi akavatuma kuhamba ku Betelehemu avajovili, “Muhamba mkakotakesa chamugati malovi ga mwana uyo. Ngati mumuwene mbwela kunijovela, muni mewawa na nene niamba kumgundamila.” ");
INSERT INTO xnj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Vala vevimanya mambu ga ndondo, pevamali kumyuwanila nkosi vakahamba. Ndondo yevayiwene kwelihumila lilanga yavalongolili yahambili kuyima panani pandu pala peavi mwana. ");
INSERT INTO xnj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pavayiwene ndondo yila, vavi na luheku neju. ");
INSERT INTO xnj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hinu vakayingila mugati, vakamlola mwana pamonga na Maliya nyina mwana, vakafugama na kumgundamila. Kangi vakawopola tuhaku vakatola njombi na vakampela zahabu na ubani na mahuta gegikemiwa manemane. ");
INSERT INTO xnj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chapanga avabesili munjozi vakotoka kumuwuyila Helodi, ndi vakawuya kumulima wavi munjila yingi. ");
INSERT INTO xnj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pavawukili vayehe vala, mtumu wa kunani kwa Chapanga amuhumalili Yosefu munjozi, akamjovela, “Yimuka! Mtola mwana pamonga na nyina waki, mtilila ku Misili. Mkatama kwenuko mbaka panikuvajovela muni Helodi igana kumkoma mwana uyo.” ");
INSERT INTO xnj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yosefu ayumwiki, akamtola mwana pamonga na nyina waki akawuka kilu yila, akahamba ku Misili. ");
INSERT INTO xnj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Akatama kwenuko mbaka Helodi peafwili. Lijambu lenili lakitiki muni lilovi leajovili Bambu munjila ya mlota wa Chapanga litimilayi, “Namkemili mwana vangu awuya kuhuma ku Misili.” ");
INSERT INTO xnj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helodi peamanyili kuvya vala vevimanya mambu ga ndondo vamkongili, akamema ligoga. Akavatuma vandu vaki vahamba kuvakoma vana vagosi voha pamuji wa Betelehemu na mumihana yaki vevavi na umuli wa miaka yivili na kuhelela vakomiwayi. Akitili genago ndava ya lukumbi lula lweajoviwi na vandu vala vevamanyili mambu ga ndondo. ");
INSERT INTO xnj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndi chagatimili malovi geajovili Yelemia mweavi mlota wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lwami luyuwanika kumuji wa Lama, Chivembu cha mvinisu ukulu na kuwombeleza pamahele, Laheli akuvavembela vana vaki, Na ibela kupoleswa, muni voha vafwili.” ");
INSERT INTO xnj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hinu, Helodi peafwili mtumu wa kunani kwa Chapanga amuhumalili Yosefu munjozi ku Misili kula, ");
INSERT INTO xnj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","amjovili “Wuka! Mtola mwana na nyina waki, uwuya kavili kumulima wa Isilaeli, ndava vevaganayi kumkoma mwana vafwili.” ");
INSERT INTO xnj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yosefu akawuka, akamtola mwana pamonga na nyina waki akawuya pamulima wa Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambu Yosefu peayuwini kuvya Alikelao, mwana wa Helodi, ahalili unkosi wa Yudea pahali pa dadi waki, ayogwipi kuhamba kwenuko. Namwene peamali kubesewa munjozi, akahamba pamulima wa Galilaya, ");
INSERT INTO xnj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akahamalila kumuji weukemelewa Nazaleti. Ndi chagatimalili malovi gegajoviki munjila ya vamlota va Chapanga, “Yati ikemiwa mundu wa ku Nazaleti.” ");
INSERT INTO xnj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lukumbi lwenulo Yohani Mbatizaji ahambili kulugangatu lwa Yudea akatumbula kuvakokosela vandu. ");
INSERT INTO xnj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Akajova, “Mumuwuyila Chapanga muni Unkosi wa Kunani kwa Chapanga uvi papipi.” ");
INSERT INTO xnj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohani mwenuyo ndi yula Isaya mweavi mlota wa Chapanga ajovili, “Mundu ijova kwa lwami kulugangatu, Mumtendelekela Bambu njila yaki, mugolosa njila yaki!” ");
INSERT INTO xnj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohani awalii nyula yevatotili mangoma ga hinyama yeyikemiwa ngamiya, mkungi wa chikumba muchiwunu chaki. Chakulya chaki chavi mambalanguli na wuchi. ");
INSERT INTO xnj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hinu vandu kuhuma ku Yelusalemu na kuhuma milima yoha yeyivii papipi na Yudea na mumihana ya mfuleni Yoludani vamhambalili. ");
INSERT INTO xnj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Vakagajova hotohoto gevambudili Chapanga. Namwene avabatizi mumfuleni Yoludani. ");
INSERT INTO xnj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambu peavaweni Vafalisayu na Vasadukayu vamahele vakumbwelela muni avabatizayi, mwene avajovili, “Nyenye chiveleku cha liyoka! Yani mweavajovili muhotola kutila ligoga la Chapanga lelibwela? ");
INSERT INTO xnj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mulangisa mumatendu ginu kuvya mukotwiki kumbudila kwinu Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nakuhololela mwihotola kutila ligoga la Chapanga cha kujova kuvya ndi nyenye vana va Ibulahimu nikuvajovela chakaka Chapanga ihotola kutola aga maganga na kugakita kuvya vana va Ibulahimu. ");
INSERT INTO xnj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hinu livagu litendelekiwi mumikiga ya mikongo, mkongo wowoha wangapambika matunda gabwina yati udumuliwa na kutagiwa kumotu. ");
INSERT INTO xnj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nene nikuvabatiza kwa manji kulangisa kuvya mkotwiki kumbudila kwinu Chapanga. Nambu mweibwela mumbele ya nene yati akuvabatiza kwa Mpungu Msopi na motu. Mwene anamkakala kuliku nene na nene niganikiwa lepi hati kugega champali zaki. ");
INSERT INTO xnj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mwene ikamula lupalu lwa kupepetela nganu mu mawoko gaki muni apepeta nganu yaki na kuvika muchibana nambu masasa akugayocha pamotu wangajimika.” ");
INSERT INTO xnj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lukumbi lwenulo Yesu ahumili ku Galilaya akahika kumfuleni Yoludani, muni abatiziwa na Yohani. ");
INSERT INTO xnj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambu Yohani alingili kumbesa amjovili, “Wu, veve, ubwela kwa nene? Yikunigana nene nibatiziwayi na veve!” ");
INSERT INTO xnj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambu Yesu akayangula, “Yidakila kukita genaga hinu, kwa njila yeniyi ndi cheiganikiwa kuhenga goha geigana Chapanga.” Bahapo ndi Yohani akayidakila. ");
INSERT INTO xnj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu peamali kubatiziwa na kuhuma mumanji bahapo kunani kwa Chapanga kwadindwiki, akalola Mpungu wa Chapanga ihelela ngati ngunda na kutula panani yaki. ");
INSERT INTO xnj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kangi lwami kuhuma kunani kwa Chapanga lukajova, “Mwenuyu ndi Mwana vangu mganu, mweniganisiwi nayu.” ");
INSERT INTO xnj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kangi Mpungu Msopi wamlongwisi Yesu mbaka kulugangatu muni alingiwa na Setani. ");
INSERT INTO xnj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ajihinisi chakulya lukumbi lwa magono alobaini kilu na muhi pamwishu njala yamvinili. ");
INSERT INTO xnj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hinu Setani akabwela na kumjovela, “Ngati veve wa Mwana wa Chapanga amula aga maganga gavyai libumunda.” ");
INSERT INTO xnj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nambu Yesu akayangula, “Yiyandikwi mu Mayandiku Gamsopi, ‘Mundu itama lepi ndava ya libumunda lene, nambu kwa kulanda kila lilovi leijova Chapanga.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kangi Setani akamtola Yesu mbaka Yelusalemu weuvi muji wa msopi, akamkita ayima panani pa chituvilu cha Nyumba ya Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamjovela, “Ngati veve mwana wa Chapanga ujitagayi pahi, ndava vayandiki, ‘Chapanga akuvalagazila vamitumu va kunani kwa Chapanga ndava yaku, Yati vakukuyanga mu mawoko gavi, ukotoka kujikuvala chigendelu chaku paliganga.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akamyangula, mewawa “Mayandiku Gamsopi gijova, ‘Kotoka kumlinga Bambu Chapanga waku.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kangi Setani akamtola na kuhamba nayu panani pachitumbi chitali, na kumlangisa unkosi woha wa pamulima na ukulu waki, ");
INSERT INTO xnj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akamjovela, “Goha aga yati nikupela, ngati ukunigundamila na kunifugamila.” ");
INSERT INTO xnj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Penapo, Yesu akayangula, “Wuka Setani! Vayandiki, mu Mayandiku Gamsopi yati ‘Umgundamila Bambu Chapanga waku, na kumhengela mwene ndu!’” ");
INSERT INTO xnj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hinu Setani, akamleka Yesu na vamitumu va kunani kwa Chapanga vakabwela vakamhengela. ");
INSERT INTO xnj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu peayuwini kuvya Yohani vamkungili muchifungu akahamba ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akawuka ku Nazaleti akahamba ku Kapelanaumu, muji wa kumwambu ya nyanja Galilaya mumilima ya Zebuloni na Nafutali, akatama kwenuko. ");
INSERT INTO xnj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ndi gatimili gala geajovili Isaya, mweavi mlota wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mulima wa Zebuloni na mulima wa Nafutali, njila ya kuhamba kunyanja mwambu ya mumfuleni Yoludani, Galilaya muji wa vandu vangali Vayawudi! ");
INSERT INTO xnj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Vandu vevatami kuchitita. Vauweni lumuli luvaha. Vene vitama mumuji wa chitita na chimuwili cha lifwa, lumuli luvalangasili.” ");
INSERT INTO xnj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuhumila lukumbi lwenulo Yesu atumbwili kukokosa, “Mumuwuyila Chapanga, muni Unkosi wa kunani kwa Chapanga uvi papipi!” ");
INSERT INTO xnj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu peagendayi mumhana wa nyanja Galilaya, avaweni valongo vavili vevilova somba Simoni, mweikemiwa Petili na Andelea mlongo waki, valova somba na ngwanda munyanja ndava vavi valova. ");
INSERT INTO xnj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu akavajovela, ngati chamwilova somba, “Munilandayi, nene yati nikuvakita nyenye kuvya vakuvaleta vandu kwa Bambu.” ");
INSERT INTO xnj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahapo vazilekili ngwanda zavi, vakamlanda. ");
INSERT INTO xnj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Peahegalili kulongolo, avaweni valongo vangi vavili, Yakobo na Yohani, vana va Zebedayo. Vene vavi mugati ya watu pamonga na dadi wavi Zebedayo, vatengenezayi ngwanda za kulovela somba. Yesu akavakemela, ");
INSERT INTO xnj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","navene kanyata vakauleka watu pamonga na dadi wavi, vakamlanda Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ahambili kila pandu ku Galilaya, iwula munyumba za kukonganekela Vayawudi na kuvakokosela Lilovi la Bwina la Unkosi wa Chapanga. Akavalamisa matamu ndalindali gevavi nagu vandu. ");
INSERT INTO xnj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Malovi gaki gadandasiki pandi zoha za ku Silia. Vandu voha vevavi na matamu na mang'ahiso, mewa vevatalaliwi na mizuka na vevihinduka na vevagogodili higa vavapeliki kwaki na mwene akavalamisa. ");
INSERT INTO xnj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Msambi wa vandu kuhuma ku Galilaya na Dekapoli ndi miji kumi, mewa Yelusalemu na Yudea na kumwambu ya mfuleni Yoludani vakamlanda. ");
INSERT INTO xnj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu peauwene msambi wa vandu, akakwela kuchitumbi, akatama. Vawuliwa vaki vakamlanda, ");
INSERT INTO xnj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mwene akatumbula kuvawula, akajova. ");
INSERT INTO xnj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Vamotisiwa vevavi vangangu mumpungu, muni Unkosi wa kunani kwa Chapanga ndi wavi! ");
INSERT INTO xnj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Vamotisiwa vana mvinisu mumtima ndava vambudili Chapanga, muni Chapanga alavapolesa mitima! ");
INSERT INTO xnj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Vamotisiwa vangolongondi, muni valahala mulima. ");
INSERT INTO xnj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Vamotisiwa vana njala na vevavi na njota ya kukita geigana Chapanga, muni Chapanga alavayukutisa ");
INSERT INTO xnj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vamotisiwi vevavi na lipyana, muni Chapanga alavahengela lipyana. ");
INSERT INTO xnj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Vamotisiwi vevavi na mtima wa msopi, muni yati valamuwona Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Vamotisiwi vatepulanisa, muni yati vikemelewa vana vaki Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Vamotisiwi veving'aiswa ndava ya kukita geigana Chapanga, muni Unkosi wa kunani kwa Chapanga ndi wa vene. ");
INSERT INTO xnj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mumotisiwi nyenye vandu vakavaliga, vakavanyagayi na kuvadetela uhakau ndava ya nene. ");
INSERT INTO xnj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mheka na kululuta muni njombi yinu yivaha kunani kwa Chapanga, chenichi ndi chevavahengili Vamlota va Chapanga vevavalongolili kwakona nyenye.” ");
INSERT INTO xnj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nyenye ndi mwinyu wa pamulima! Nambu luyong'onyo lwaki lwakayaga yati yisopewa kiki? Yivya lepi na lihengu kavili yati kutagika kuvala na vandu vakuyilivatila. ");
INSERT INTO xnj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nyenye ndi ngati lumuli lwa pamulima! Muji weujengiwi panani ya chitumbi ufiyika lepi. ");
INSERT INTO xnj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vandu vipambika lepi hahi na kuigubika na chiviga, muni yivikiwa panani ya chibokoselu kuvalangasa voha vevavi mugati. ");
INSERT INTO xnj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mewawa lumuli lwinu luvalangasa palongolo ya vandu, vagalola matendu ginu gabwina, vamlumbalila Dadi winu mweavi kunani.” ");
INSERT INTO xnj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mkoto kuhololela kuvya nibweli kuwusa malagizu ga Chapanga geampeli Musa amala mawuliwu ga Vamlota va Chapanga. Nibweli lepi kuwusa, ndi nibweli muni kugatimalisa. ");
INSERT INTO xnj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nikujovela chakaka, mbaka kunani na mulima yati zihamba, kawaka hati nukuta yimonga yeyiwusiwa mumalagizu mbaka goha gatimila. ");
INSERT INTO xnj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hinu, mundu yeyoha angayidakila hati mihilu umonga udebe kuliku zoha, na kuvawula vangi vakita ago, mwenuyo yati ivya mdebe neju, Muunkosi wa kunani kwa Chapanga. Nambu mweiyuwanila na kuvawula vangi mwenuyo yati ivya mvaha muunkosi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Muyuwanila, ubwina winu ngati nakuyonjokesa wula wa vawula va malagizu na Vafalisayu, katu nakuyingila mu Unkosi wa kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mmali kuyuwana kuvya vandu va kadeni chavajoviwi, ‘Ukoto kukoma! Mundu yeyoha mweikoma yikumgana ahamuliwa.’ ");
INSERT INTO xnj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambu nene nikuvajovela, mundu yeyoha mweakumyomela mlongo waki, yati ihamuliwa. Mundu yeyoha mweakumvevesa mlongo waki yati vakumtakila kulibanji la mihalu. Mweakumkemela mlongo waki, ‘Myimu! Yati iyingila kumotu wa magono goha wangajimika.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Hinu, ngati upeleka luteta lwaku palongolo ya lusanja lwa luteta, na ukumbwiki kuvya mlongo waku avi na luhonda na veve, ");
INSERT INTO xnj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ululeka luteta lwaku pa lusanja lwa luteta, hamba hoti ukatepulana na mlongo waku kangi uwuya kavili uwusa luteta lwaku.” ");
INSERT INTO xnj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tepulana na mweakutakili kanyata mwakona munjila kuhamba kulibanji la mihalu. Ngati lepi, mweakutakili yati akukugotola mumawoko ga mhamula mihalu, mwene akugotola kwa manjolinjoli na kukungiwa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nikujovela chakaka yati nakuhuma mbaka ulipili sendi ya mwishu.” ");
INSERT INTO xnj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muyuwini kuvya vandu vajoviwi, kotoka kukita ugoni! ");
INSERT INTO xnj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambu nene nikuvajovela, kila mundu mweakumlolokesa mdala cha kumnogela amali kugona nayu mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Hinu, lihu laku la upandi wa kulyelela likakubudisa, ulitupula ukalitaga kutali. Mbanga neju, veve kuyaganisa pandu pamonga pa higa yaku, kuliku higa yaku yoha kutagika pamotu wa magono goha wangajimika. ");
INSERT INTO xnj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ngati chiwoko chaku cha kulyela chikubudisa chidumulai ukatagayi kutali. Mbanga veve kuyaganisa pandu pamonga pa higa yaku kuliku higa yaku yoha yihambi kumotu wa magono goha wangajimika.” ");
INSERT INTO xnj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gamali kujovekwa kuvya, ‘Mundu yeyoha mweakumleka mdala waki, amyandakila balua ya kumleka.’ ");
INSERT INTO xnj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambu nene nikuvajovela, mundu yeyoha mweakumleka mdala waki, nambu ndu ndava ya kumkamula ugoni, akumkita mkemi. Na mgosi akamgegai mdala yula mwealekiwi ikita ugoni nayu.” ");
INSERT INTO xnj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kangi myuwini vandu va kadeni vajoviwi, ‘Ukotoka kudenya chilapu chaku, nambu uganikiwa kutimilisa chilapu chaku kwa Bambu.’ ");
INSERT INTO xnj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambu nene nikuvajovela, katu mkotoka kulapa, hati kunani kwa Chapanga, muni ndi chigoda cha Chapanga cha unkosi waki, ");
INSERT INTO xnj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","amala kulapa kwa mulima muni chigoda cha kuvikila magendelu gaki, amala ku Yelusalemu muni muji wa Nkosi mkulu. ");
INSERT INTO xnj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ukoto kulapa pamutu waku, muni nakuhotola kuuhenga hati luyunju lumonga kuvya lwa msopi amala lutitu. ");
INSERT INTO xnj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mkajovai ‘Ena,’ Ndi yivya ‘Ena,’ Mkajovai, ‘Mbwitu,’ Chakaka yivyai ‘Mbwitu,’ Chochoha chechiyonjokeseka pa genago chihumila kwa Setani.” ");
INSERT INTO xnj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muyuwini kuvya gajoviki. ‘Lihu kwa lihu, linu kwa linu.’ ");
INSERT INTO xnj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambu nene nikuvajovela, ukotoka kumuwuyisila mundu mhakau. Mundu akakupamanda, mulitama la kulyela, mng'anamusila na litama la kumangeya. ");
INSERT INTO xnj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mundu akakutakila igana kukunyaga nyula yaku, mlekela atola mewa na likoti laku. ");
INSERT INTO xnj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu akakukamula kwa makakala ugegai ndwika yaki kilomita yimonga, ugegai kilomita zivili. ");
INSERT INTO xnj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mweakukuyupa mpelai, na ukotoka kumtila mundu mweakuyaika chindu.” ");
INSERT INTO xnj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Myuwini kuvya gajoviki, mgana muyaku, na mvenga likoko waku. ");
INSERT INTO xnj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambu nene nikuvajovela, muvagana makoko vinu na kuvayupila vala vevakuvang'aisa nyenye, ");
INSERT INTO xnj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","muni mpata kuvya vana va Dadi winu mweavi kunani. Muni mwene akuvalangasila lilanga laki vandu makoko na vandu vabwina, na kuvatonyela fula kwa vandu vabwina palongolo yaki na vandu vahakau. ");
INSERT INTO xnj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wu, njombi yoki mwipata kuhuma kwa Chapanga? Ngati mukuvagana vala vevakuvagana nyenye ndu! Kawaka! Muni hati vatola kodi navene vikita mewa! ");
INSERT INTO xnj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngati Mukuvajambusa valongo vinu ndu, mhengili chindu kiki neju kuliku vangi? Muni hati vangammanya Chapanga vikita mewawa. ");
INSERT INTO xnj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mwiganikiwa mkoto kupungula chochoa mukuhenga gabwina ngati Dadi winu wa kunani kwa Chapanga angapungula.” ");
INSERT INTO xnj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mjiyangalila mkoto kukita matendu ginu gabwina pamihu ga vandu, ndava ya kujilangisa kwavi. Ndava muni mwakakita genago mwipata lepi njombi kuhuma kwa Dadi winu mweavi kunani.” ");
INSERT INTO xnj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hinu, mukavatangatila vangangu, ukoto kujikokosa kotoka kukita ngati vandu vevakujikita kuvya vabwina munyumba za kukonganekela Vayawudi na munjila muni vandu vavalumba. Nikuvajovela chakaka venavo vamali kupewa njombi yavi. ");
INSERT INTO xnj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambu veve peukumtangatila mngangu, kita jambu lenilo cha mfiyu hati vandu vangi vakotoka kumanya chewihenga. ");
INSERT INTO xnj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mpela luteta lwaku chamfiyu na Dadi waku akugalola gegafiyiki yati akukupela njombi.” ");
INSERT INTO xnj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pemwiyupa kwa Chapanga, mkotoka kuvya ngati vandu vavakujikita kuvya vabwina, vene vigana kuyima munyumba za kukonganekela Vayawudi na malekanganu ga njila, muni vandu vavalola. Nikuvajovela chakaka vene vamali kupewa njombi yavi. ");
INSERT INTO xnj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambu veve peukumuyupa Chapanga, uyingila muchumba chaku, dinda mlyangu, uyupa kwa Dadi winu mweangalolekana. Mwene Dadi waku akugalola gegafiyiki, yati akukupela njombi. ");
INSERT INTO xnj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pemwikumuyupa Chapanga, mkoto kujovajova malovi gamahele ngati vandu vangammanya Chapanga. Muni vene vihololela kuvya Chapanga alavayuwanila ndava ya malovi gavi gamahele. ");
INSERT INTO xnj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mkoto kuwanangana nawu. Dadi winu achimanyili chamwigana hati mwakona mwangayupa. ");
INSERT INTO xnj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hinu, nyenye pemkuyumpa Chapanga, mjova naha: Dadi witu wewitama kunani, Liina laku lilumbiwa neju. ");
INSERT INTO xnj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Unkosi waku utibwelelai, chewigana veve chikitika, pamulima apa ngati cheyivii kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utipela lelu chakulya chitu cha magono goha. ");
INSERT INTO xnj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utilekekesa tete getihokili, ngati tete chetikuvalekekesa vevatihokili. ");
INSERT INTO xnj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ukotoka kutiyingisa mukulingiwa, nambu utisangula na mhakau yula. Ndava muni Unkosi na ukulu na makakala ndi vyaku hati magono goha gangali na mwishu. ");
INSERT INTO xnj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngati mwakavalekekesa vandu kuhoka kwavi, Dadi winu wa kunani alavalekekesa nyenye mewawa mukumbudila kwinu. ");
INSERT INTO xnj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambu ngati nakuvalekekesa vangi kuhoka kwavi, mewawa Dadi winu alavalekekesa lepi nyenye kumbudila kwinu. ");
INSERT INTO xnj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Pemukujihisa kulya chakulya ndava ya Bambu, mkoto kulangisa ungolongondi ngati vandu vevakujikita kuvya vabwina, vene vikwinyana pamihu pavi, muni vawonekana pavandu ngati vajihinisi kulya chakulya ndava ya Bambu. Nikuvajovela chakaka venavo vamali kupata njombi yavi. ");
INSERT INTO xnj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambu veve peukujihinisa kulya chakulya ndava ya Bambu, samba manji pamihu na unyala mahuta pamutu. ");
INSERT INTO xnj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Muni mundu yeyoha akotoka kumanya kuvya kujihisa kulya chakulya, ndi umanyikana kwa Dadi waku ndu mweangalolekana. Namwene akugalola gegafiyiki, yati akupela njombi. ");
INSERT INTO xnj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mkoto kuvika vibana apa pamulima, ndava vingokoko amala kutu vihalibu na vahiji videnya na kuyiva. ");
INSERT INTO xnj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nambu mjivikila vibana vinu kunani kwa Chapanga kwenuko vingokoko amala kutu nakuhalabika na amala vahiji videnuya lepi na kuyiva. ");
INSERT INTO xnj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Muni pala pemwivika vibana vinu ndi pewivya mtima waku. ");
INSERT INTO xnj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lihu laku ndi hahi ya higa yaku, ngati lihu laku lilola bwina, higa yaku yoha yivya mulumuli, ");
INSERT INTO xnj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","nambu ngati lihu laku lilola lepi bwina, ndi higa yaku yoha yivya muchitita. Hinu, chilanga chechivii mugati yaku chikavya chitita, chakaka cheni ndi chitita chivaha neju! ");
INSERT INTO xnj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Avi lepi mvanda, mweihotola kuvahengela vabambu vavili. Muni yati akumgana mmonga na kumvenga yungi, yati akumgana neju mmonga na kumvevesa yungi. Mwihotola lepi kumhengela Chapanga na bahapo kuhengela vindu vyamahele. ");
INSERT INTO xnj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ndi nikuvajovela, mkoto kutyalatyala ndava ya chakulya na chemwinywa vyamgana muni mutama, amala ndava ya nyula zemwigana ndava ya higa yinu. Wu, wumi chindu chivaha lepi kuliku chakulya? Na higa ndi ya maana lepi kuliku nyula? ");
INSERT INTO xnj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mlola videge, vimija lepi amala kubena mewa vivi lepi na chibana chochoha. Pamonga na ago Dadi winu mweavi kunani akuvapela chakulya. Wu, nyenye chindu chivaha lepi kuliku videge? ");
INSERT INTO xnj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yani pagati yinu ndava ya kutyalatyala neju ihotola kuyonjokesa hati lukumbi ludebe lwa wumi waki? ");
INSERT INTO xnj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ndava kyani, kutyalatyala ndava ya nyula? Mlola maluva ga mudahi cheginyamba. Gihenga lepi lihengu amala gitota lepi nyula. ");
INSERT INTO xnj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambu nikuvajovela, hati mwene Solomoni na unkosi waki awali lepi chakunyamba ngati limonga pagati ya maluva aga. ");
INSERT INTO xnj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ngati Chapanga akuliwalika linyai la kumgunda, nambu lelu livii na chilau kutaga kumotu, wu, nakuvahengela neju nyenye? Nyenye vandu mwemusadika padebe! ");
INSERT INTO xnj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hinu, mkoto kutyalatyala, yati tilya kiki? Yati tinywa kiki? Tiwala kyani? ");
INSERT INTO xnj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Muni ago goha gitangatiliwa na vandu vangamlanda Chapanga. Dadi winu mweavi kunani amanyili kuvya mwigana goha ago. ");
INSERT INTO xnj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndi, mlonda hoti Unkosi waki Chapanga na geigana, na genago goha yati akuvayonjokesa. ");
INSERT INTO xnj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hinu mkoto kutyalatyala ndava ya chilau. Chilau yivii gaki, mang'ahiso ga ligono limonga gakuvakola. ");
INSERT INTO xnj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mkoto kuvahamula vangi, muni na nyenye yati mwihamuliwa lepi na Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ndava muni chemukuvahamula vangi, na nyenye yati mwihamuliwa, na chipimu chilachila cha mwihengela kwa vangi, ndi Chapanga yati avahengela nyenye. ");
INSERT INTO xnj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndava kyani wilola lungoda mulihu la mlongo waku, na kuni wangaluwona lumbagalu mulihu laku? ");
INSERT INTO xnj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Amala yati wijova wuli, kwa mlongo waku, ‘Linda hoti, nikuwusa lungoda mulihu laku,’ Kuni wamwene una lumbagalu mulihu laku? ");
INSERT INTO xnj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Veve mweukujikita kuvya mbwina! Wusa hoti lumbagalu lweluvi mulihu laku. Pena ndi peuhotola kulola bwina kuwusa lungoda mulihu la mlongo waku.” ");
INSERT INTO xnj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mkoto kugapela mabwa vindu vyamsopi vakotoka kung'anamuka na kuvalemasa mwavene, amala mkoto kugapela maguluvi lulu zeziguliswa kwa mashonga gamahele muni vakotoka kulivatila kwa magendelu gavi.” ");
INSERT INTO xnj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Muyupa yati mwipewa, mlondai yati mwipata, muhodisa mlyangu yati vakuvadindulila. ");
INSERT INTO xnj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ndava muni mweiyupa ipewa na mweilonda yati ipata na mweihodisa mlyangu yati idinduliliwa. ");
INSERT INTO xnj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wu, avi mmonga pagati yinu, ngati mwana waki akamuyupa libumunda akumpela liganga? ");
INSERT INTO xnj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amala akamuyupa somba akumpela liyoka? ");
INSERT INTO xnj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngati hinu nyenye, mwavahakau, mwimanya kuvapela vana vinu vindu vyabwina, chakaka Dadi winu wa kunani akuvahengela neju akuvapela vindu vyabwina, vala vevakumuyupa.” ");
INSERT INTO xnj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Goha gemwigana vandu vavahengela nyenye, mvahengela na vene mewawa. Yeniyi ndi maana ya Malagizu ga Bambu geampeli Musa na mawuliwu ga vamlota va Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Muyingila kwa kupitila mlyangu udebe. Ndava muni njila yeyilongosa mukuyongomela ndi yipana na mlyangu waki ndi upana, veviyingila mwenumo ndi vamahele. ");
INSERT INTO xnj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambu njila yeyilongosa kuyingila kuwumi wa magono goha ndi ngalingasi na mlyangu waki ungalingasi, vandu vamahele lepi vevihotola kumanya njila yeniyi.” ");
INSERT INTO xnj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mujiyangalila na vamlota va udese, vene vibwela kwinu vakujilangisa cha kuvala ngati limbelele, nambu chamugati ndi libwa likali la kudahi. ");
INSERT INTO xnj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mukuvamanya ndava ya matendu gavi. Wu, vandu viyava matunda ga zabibu mumkongo wa minga amala tini mumkongo wa minga? ");
INSERT INTO xnj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mewawa ndi kila mkongo wabwina wipambika matunda gabwina, na mkongo uhakau wipambika matunda gahakau. ");
INSERT INTO xnj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mkongo wabwina nakuhotola kupambika matunda gahakau, kavili mkongo mhakau nakupambika matunda gabwina. ");
INSERT INTO xnj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila mkongo wangapambika matunda gabwina yati udumuliwa na kutagiwa kumotu. ");
INSERT INTO xnj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hinu, mukuvamanya ndava ya matendu gavi.” ");
INSERT INTO xnj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Lepi kila mundu mweakunikemela, ‘Bambu, Bambu,’ Yati iyingila Muunkosi wa Chapanga. Nambu ngayula mweihenga geigana Dadi wangu mweavi kunani.” ");
INSERT INTO xnj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Vamahele, “Yati vakunijovela, ‘Ligono lila la uhamula wa Bambu, Bambu! Paliina laku tavakokosili vandu ujumbi waku, na paliina laku tavawusili vandu mizuka na kukita gachinamtiti yamahele.’ ");
INSERT INTO xnj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kangi yati nikuvajovela, katu nakuvamanya nyenye, muwuka palongolo yangu mwemuhenga gahakau!” ");
INSERT INTO xnj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hinu mundu yeyoha mweiyuwana malovi gangu na kugahenga, iwanangana na mundu mweavi na luhala lwabwina, mweajengili nyumba yaki panani ya litalau. ");
INSERT INTO xnj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fula yikatonya na mifuleni yikamema manji gamahele, mpungu wakabwela na kuyitova nyumba yeniyo. Nambu nyumba yeniyo nakugwa ndava yijengiwi panani ya litalau.” ");
INSERT INTO xnj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambu mundu yeyoha mweiyuwana malovi gangu na ibela kugahenga, iwanangana na mundu myimu mweijenga nyumba yaki panani ya msavati. ");
INSERT INTO xnj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Fula yikatonya na mifuleni yikamema manji gamahele na mpungu ukabwela na kuitova nyumba yeniyo, nayene yikagwa na kudenyekana neju!” ");
INSERT INTO xnj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu peamali kujova malovi ago, msambi wa vandu ukakangaswa ndava ya mawuliwu gaki. ");
INSERT INTO xnj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Muni awulayi ngati mundu mweavi na uhotola ndi lepi ngati vawula vavi va malagizu. ");
INSERT INTO xnj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu peahelili kuhuma kuchitumbi, msambi wa vandu wamlandili. ");
INSERT INTO xnj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hinu abwelili mundu mmonga mweavi na mabudi, akamfugamila na kujova, “Bambu, ngati wigana, uhotola kuninyambisa!” ");
INSERT INTO xnj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu akatalambula chiwoko, akampamisa na kujova, “Nigana! Unyambasika!” Bahapo mundu yula akalama mabudi gaki. ");
INSERT INTO xnj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kangi Yesu akamjovela, “Yuwanila! Kotoka kumjovela mundu yeyoha yula, ndi uhamba ukajilangisa kwa mteta wa Chapanga na kumpela teta ngati chealagizi Musa ya kulangisa kuvya unyambiswi.” ");
INSERT INTO xnj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu peayingili ku Kapelanaumu, mkulu wa manjolinjoli mmonga wa Loma akambwelela na kujova amtangatila, ");
INSERT INTO xnj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akamjovela “Bambu mtumisi wangu agonili munyumba, ana utamu wa kupola na iviniswa neju.” ");
INSERT INTO xnj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu akamjovela, “Yati nibwela kumlamisa.” ");
INSERT INTO xnj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mkulu wa manjolinjoli yula akajova, “Bambu, nigana lepi veve kuyingila munyumba yangu. Nambu ujova ndu lilovi na mtumisi wangu yati ilama. ");
INSERT INTO xnj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Muni, hati namwene namundu mwenivii pahi ya uhotola wa vakulu vangu na nivii na manjolinjoli pahi yangu. Nikuvalagiza manjolinjoli vevavi pahi yangu. Nikumjovela mmonga, ‘Amba!’ Ihamba, na yungi, ‘Bwela,’ Ndi ibwela na mtumisi wangu, henga aga! Namwene ihenga mewa.” ");
INSERT INTO xnj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu peayuwini malovi ago akakangasa neju, akavajovela vandu vevamlandai vala, “Nikuvajovela chakaka, niwene lepi mundu mweavi na sadika yivaha ngati mwenuyu pa Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hinu, nikuvajovela vandu vamahele valabwela kuhuma kwe lihumila lilanga na kuhuma kwa litipama lilanga, vene valatama pamselebuko wa chakulya pamonga na Ibulahimu na Izaki na Yakobo. Muunkosi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambu vala vevaganikiwi kuvya muunkosi wenuwo yati vakuvataga kuvala, kuchitita, kwenuko yati vivemba na kuyaga minu.” ");
INSERT INTO xnj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kangi, Yesu amjovili mkulu wa manjolinjoli wa ku Loma, “Wuya kunyumba, gavyai mewa ngati cheusadika.” Ndi mtumisi waki alamili lukumbi lulalula. ");
INSERT INTO xnj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ahikili panyumba ya Petili, amkolili nyina wa mdala waki Petili agonili pachitanda, ndava ya utamu. ");
INSERT INTO xnj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hinu, Yesu akampamisa mau yula chiwoko, na utamu waki wamlekili, akayima kumtelekela. ");
INSERT INTO xnj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Payavi kimihi, vamletili vandu vamahele vevatalaliwi na mizuka, mwene ayivingili mizuka kwa njila ya mawuliwu gaki. Ndi avalamisi vandu voha vevavi na utamu. ");
INSERT INTO xnj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akitili chenicho, muni gatimila malovi geajovili Isaya mweavi mlota wa Chapanga, “Mwene atolili mang'ahiso gitu na ulenda witu, na kugega matamu gitu.” ");
INSERT INTO xnj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paauweni msambi wa vandu umtindili, akavalagiza vawuliwa vaki vakupuka kuhamba kumwambu ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Muwula mmonga wa Malagizu amhambili Yesu, akamjovela, “Muwula, nene yati nikukulanda kwokwoha kwewihamba.” ");
INSERT INTO xnj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu akayangula, “Lihogo lina mbugu na videge vina hisakanilu, nambu Mwana wa Mundu avi lepi na pandu pa kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mundu yungi pagati ya vawuliwa vaki akamjovela, “Bambu, nileka hoti nihamba nikamuzika Dadi wangu.” ");
INSERT INTO xnj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambu Yesu akamyangula, “Unilanda, valeka vevafwili vavazika vandu vavi vevafwili.” ");
INSERT INTO xnj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu akayingila muwatu na vawuliwa vaki vakahamba pamonga nayu. ");
INSERT INTO xnj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bahapo chimbungululu chivaha neju chikahumalila na manji gakatimbugana neju, hati gakatumbula kuugubika watu, nambu Yesu avi mulugono. ");
INSERT INTO xnj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Vawuliwa vakamhambila na kumuyumusa peagonili vakamjovela, “Bambu!” “Utisangula tifwa!” ");
INSERT INTO xnj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu akavajovela, “Nyenye vandu mwemusadika padebe! Ndava kyani muyogopa?” Hinu akayima akahakalila mpungu na manji gakutimbugana neju na nyanja yikaguna kukavya nuu. ");
INSERT INTO xnj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Vandu vakakangasa na kujova “Wu, mundu mwenuyu avi wuli? Hati mpungu na manji gakutimbugana neju vikumyidikila!” ");
INSERT INTO xnj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu peakupwiki kumwambu ya nyanja akahika pamulima wa Wagadala, kwenuko akonganiki na vandu vavili vana mizuka vihumila kumatinda. Vandu venavo vavi na mizuka ya kuyogofya neju. Hati vandu valingili lepi kupita njila yeniyo. ");
INSERT INTO xnj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Vakaywanga vijova, “Una kyani na tete veve Mwana wa Chapanga? Ubweli kutilemasa kwakona hati lukumbi lwitu?” ");
INSERT INTO xnj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Papipi na penapo kwavili na msambi wa maguluvi gegilya. ");
INSERT INTO xnj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Hinu penapo mizuka yila yikamjovela Yesu, “Ngati ukutiwusa, tileka tihamba tikayingili mumsambi wa maguluvi gala.” ");
INSERT INTO xnj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu akayangula “Ena muhamba.” Penapo gakawuka kwa vandu na kugayingila maguluvi. Msambi woha wa maguluvi wajumbili pamuhelelu na kujwigama munyaja, ndi goha gafwili mumanji. ");
INSERT INTO xnj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vala vadimaji va maguluvi, vajumbili na kuhamba kumuji. Ndi vavadandaulili malovi na mambu gegavakolili vandu vavili vala vevatalaliwi na mizuka. ");
INSERT INTO xnj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Hinu, vandu voha pamuji wula, vakawuka vakamhambila Yesu, pevamuweni vakamgana, awukayi pamulima wavi. ");
INSERT INTO xnj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu akayingila muwatu na kukupuka munyanja na kuhika kumuji wavi. ");
INSERT INTO xnj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Penapo vandu vamletili mundu mmonga mweapoli higa, vamgonisi pa lusongwani. Yesu paavaweni chavisadika, akamjovela mundu mweapoli yula, “Jipolesa mtima mwana vangu! Kumbudila kwaku Chapanga ulekekiswi.” ");
INSERT INTO xnj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Vawula vangi va malagizu vakatumbula kuhololela, “Mundu uyu akumliga Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu amanyili maholo gavi akajova, “Ndava kyani mhololela gahakau mumtima winu? ");
INSERT INTO xnj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chinonopa kiki kujova, ‘Ulekekiswi kumbudila Chapanga waku,’ Amala kujova, ‘Yima, ugenda?’ ");
INSERT INTO xnj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Hinu, nigana mmanya kuvya Mwana wa Mundu anauhotola pamulima kuvalekekesa vandu gevambudili Chapanga.” Penapo ndi akamjovela mundu mweapoli yula, “Yima ugega lusongwani lwaku amba kunyumba yaku!” ");
INSERT INTO xnj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na mundu mwenuyo akawuka na kuhamba kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Msambi wa vandu wula pevagaweni ago, vakakangasa na kuyogopa, vakamulumbalila Chapanga mweavapelii vandu uhotola wenuwu. ");
INSERT INTO xnj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu akawuka penapo, ndi peavili mukuhamba amuwene mundu mmonga mweikemiwa Matei, atamili munyumba ya kutolela kodi. Hinu, Yesu amjovili, “Unilanda.” Namwene akayima na kumlanda. ");
INSERT INTO xnj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu peatamili munyumba ya Matei, kulya chakulya, vatola kodi vamahele na vevakumbudila Chapanga vabwelili kulya nayu, pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagati ya Vafalisayu vangi pavagaweni genago, vakavakota vawuliwa vaki, “Ndava kyani muwula winu ilya pamonga na vatola kodi na vandu vevakumbudila Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu akavayuwana, akayangula, “Vandu vangalwala nakugana mlamisa, nambu vana matamu ndi vakumgana mlamisa. ");
INSERT INTO xnj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hinu mukajiwula malovi aga mana yaki kyani, ‘Nigana lipyana, lepi luteta lwa kutinyisa.’ Nibweli lepi kuvakemela vandu vevihenga matendu gabwina palongolo ya Chapanga, nambu ndava ya vevakumbudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kangi, vawuliwa va Yohani Mbatizaji vamubwelili Yesu, vakamkota, “Tete na Vafalisayu tikujihinisa kulya chakulya pamahele ndava ya Bambu. Ndava kyani vawuliwa vaku vakujihinisa lepi kulya chakulya?” ");
INSERT INTO xnj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akayangula, “Wu, vandu vevagongoliwi kumselebuko wa pandowa yihotoleka vatama ngolongondi kuni vavi pamonga na mkolo ndowa? Lepi, nambu lwalabwela lukumbi lwa mkolo ndowa kuwusiwa, lwenulo ndi lukumbi lwavene kujihinisa kulya chakulya.” ");
INSERT INTO xnj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Vandu vitota lepi chilaka cha nyula ya mupya munyula ya lindimula. Muni chilaka chenicho yati chipapula neju nyula lindimula na pandu pala yati piyonjokeseka neju kupapuka. ");
INSERT INTO xnj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vandu nakusopa divayi ya mupya muchihaku cha chikumba chechilali. Ngati vasopii muchihaku cha chikumba chechilali yati chibayuka na divayi yati yiyitika. Nambu vandu visopa divayi ya mupya muchihaku cha chikumba cha mupya. Na vyoha, vihaku na divayi yati visindimala bwina.” ");
INSERT INTO xnj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu peavi akona angamala kujova malovi ago, chilongosi mmonga Myawudi ambwelili, akamfugamila na kujova, “Msikana wangu afwili hinu. Nambu chondi tihamba ukamvikila mawoko gaku yati itama kangi.” ");
INSERT INTO xnj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu akayima na kumlanda na vawuliwa vaki vakamlanda. ");
INSERT INTO xnj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mau mmonga, avi na utamu wa kuhuma ngasi lukumbi lwa miyaka kumi na yivili, amlandili Yesu mumbele, na kupamisa lugunyilu lwa nyula yaki. ");
INSERT INTO xnj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Akitili chenicho ndava ya aholalili mumtima waki kuvya, “Nakapamisa ndu nyula yaki, yati nilama.” ");
INSERT INTO xnj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ang'anamwiki na kumlola akamjovela, “Msikana wangu, kangamala mtima kusadika kwaku kukulamisi.” Mau yula akalama lukumbi lulalula. ");
INSERT INTO xnj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu ayingili munyumba ya chilongosi yula na peavawene vabeta chitolilo na msambi wa vandu, vivembeneka na kugalawuka, ");
INSERT INTO xnj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","avajovili vandu vala “Muwuka pandu apa! Msikana akona mumi, agonili ndu.” Vene vamkamheka. ");
INSERT INTO xnj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hinu msambi wa vandu pavawukili, Yesu akayingila mugati na kumkamula msikana yula chiwoko, na msikana yula akayima. ");
INSERT INTO xnj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Malovi ago gadandasiki neju pamulima wula woha. ");
INSERT INTO xnj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu akawuka pandu penapo, na peavi mukuhamba, vangalola vavili vamlandili na kuywanga, “Mwana wa Daudi utihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu peayingili munyumba, vangalola vala vamhambili namwene avakotili, “Wu, mwisadika kuvya nihotola kuvalamisa?” Vene vakayangula, “Ena, Bambu.” ");
INSERT INTO xnj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Penapo Yesu akavapamisi mumihu gavi na kujova, “Ndi, gavyai mewa kwa nyenye ngati chemwisadika!” ");
INSERT INTO xnj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mihu gavi gadindwiki. Namwene Yesu akavabesa neju, “Mkoto kumjovela mundu yeyoha lijambu lila.” ");
INSERT INTO xnj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambu vene vawukili na kugadandaula malovi ga Yesu pamulima wula woha. ");
INSERT INTO xnj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Vandu pavawukili, vandu vangi vamletili Yesu mundu mmonga ngajova ndava ya kutalaliwa na mzuka. ");
INSERT INTO xnj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bahapo mzuka wula pawavingiwi, mundu yula akatumbula kujova kavili. Vandu voha vakakangasa na kujova “Lijambu ngati lenili kawaka peliwonekini pa Isilaeli!” ");
INSERT INTO xnj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambu Vafalisayu vakajova, “Akuyivinga mizuka kwa makakala ga mkulu wa mizuka.” ");
INSERT INTO xnj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu avi mukugenda mumiji na muhijiji yoha, awulayi munyumba za kukonganekela Vayawudi. Ikokosa Lilovi la Bwina la unkosi wa Chapanga, na kuvalamisa matamu gavi na kuvawusila ng'ani zavi. ");
INSERT INTO xnj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hinu, peauwene msambi wa vandu, avahengili lipyana ndava vatotokili neju changali utangatila, ndi vavi na mtahu ngati mambelele gangali mdimaji. ");
INSERT INTO xnj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kangi akavajovela vawuliwa vaki, “Mabenu gamahele, nambu vabenaji vadebe. ");
INSERT INTO xnj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hinu muyupa mkolo mabenu gaki avatuma vanalihengu vabena mabenu gaki.” ");
INSERT INTO xnj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu avakemili pamonga vawuliwa vaki kumi na vavili, akavapela uhotola wa kuvinga mizuka na kulamisa utamu ndalindali. ");
INSERT INTO xnj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mahina ga vamitumi vaki kumi na vavili vala ndi aga: Kutumbula Simoni mweikemiwa Petili na Andelea mlongo waki na Yakobo mwana wa Zebedayo, na Yohani mlongo waki, ");
INSERT INTO xnj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","vangi ndi Filipi na Batolomei na Tomasi na Matei mtola kodi na Yakobo mwana wa Alufayo na Tadei, ");
INSERT INTO xnj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mweavi mundu wa kukengelela mulima waki na Yuda Isikalioti, mwenuyu ndi mweamng'anamukili Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu avatumili kumi na vavili avo na kuvapela uhotola uwu, “Mkoto kuhamba kwa vandu vangali Vayawudi, mewa mkoto kuyingila kumiji ya Vasamaliya. ");
INSERT INTO xnj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambu mhamba kwa vandu va Isilaeli vevayagili ngati limbelele. ");
INSERT INTO xnj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pemwihamba mvakokosela aga, ‘Unkosi wa kunani kwa Chapanga uvi papipi!’ ");
INSERT INTO xnj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mvalamisa vatamu, muvayusa vandu vevafwili, muvanyambisa vevavi na mabudi, mvinga mizuka. Mupatili waka muwusa waka. ");
INSERT INTO xnj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mkoto kugega zahabu amala feza amala shaba mumahaku ginu. ");
INSERT INTO xnj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mewawa mkoto kugega lihaku la lugendu amala magwanda gavili, amala champali amala mkongojo, mhengalihengu iganikiwa kupewa chakulya.” ");
INSERT INTO xnj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pemwiyingila pamuji wowoha, amala muchijiji chochoha mulonda mundu mweigana kuvapokela kunyumba yaki, ndi mumgendela na mtama kwa mwenuyu mbaka pemwiwuka pandu apo. ");
INSERT INTO xnj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamuyingila panyumba muvajambusa vakolonjinji. ");
INSERT INTO xnj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ngati vandu va nyumba yeniyo vavapokili nyenye, jambusa yeniyo ya uteke yati yitama bahapo. Nambu ngati vavapokili lepi, jambusa yinu yati yikuvawuyila mwavene. ");
INSERT INTO xnj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ngati vakolo nyumba, vabeli kuvapokela amala kuvayuwanila malovi ginu, hinu pemwiwuka munyumba yeniyo amala muji wenuwo muvakung'undila lububu lwa mumagendelu ginu kulangisa kuvya vene vavabeli nyenye. ");
INSERT INTO xnj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nikuvajovela chakaka, pa ligono la uhamula yati yivya mbanga kwa miji ya Sodoma na Gomola kuliku muji wenuwo.” ");
INSERT INTO xnj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hinu nene nikuvatuma nyenye ngati limbelele pagati ya libwa la mudahi. Mvya na luhala ngati liyoka na muvya ngolongondi ngati ngunda. ");
INSERT INTO xnj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mujiyangalila na vandu, muni vakuvatakila nyenye mumabanji ga mihalu na valavatova mchapilu munyumba zavi za kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yati vakuvapeleka palongolo ya vachilongosi na vankosi ndava ya nene, penapo muhotola kuvajovela vandu malovi gangu na vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hinu vakavatakila nyenye mumabanji ga mihalu, mkoto kung'ahika kuholelela tijova kyani, ndava muni yati mwipewa gakujova lukumbi peluhika. ");
INSERT INTO xnj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Muni nyenye lepi mwemjova, nambu Mpungu wa Dadi winu yati wijova mugati yinu.” ");
INSERT INTO xnj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mlongo alamgotola mlongo waki akomiwa na dadi alamgotola mwana waki, mewawa vana yati vakuvang'anamukila vadadi na vanyina vavi na kuvakoma. ");
INSERT INTO xnj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vandu voha vakuvayomela ndava nyenye mukunisadika nene. Nambu mweisindimala mbaka pamwishu yati isanguliwa. ");
INSERT INTO xnj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vandu vakavavinga kumuji umonga mjumbila pamuji wungi. Nikuvajovela chakaka, mwakona kumala mumiji yoha ya Isilaeli kwakona Mwana wa Mundu kubwela.” ");
INSERT INTO xnj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Muwuliwa akumpita lepi muwula waki, mewawa na mtumisi akumpita lepi mkulu waki. ");
INSERT INTO xnj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yikola muwuliwa kuvya ngati muwula waki, mewawa na mvanda kuvya ngati mkulu waki. Ngati vamkemili mkulu mkolo nyumba Belizebuli, wu, yati vakuvakemela lepi vandu vangi va lukolo lwenulo mahina gahakau neju?” ");
INSERT INTO xnj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hinu mkoto kuvayogopa vandu muni chindu chochoha chechigubikwi yati chigubukuliwa na chindu chochoha chechifiyiki yati chifiyuliwa. ");
INSERT INTO xnj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Genikuvajovela nyenye muchitita, mulijovai mululangasa na lijambu lemwayuwini pachinunu, mulikokosa pavandu. ");
INSERT INTO xnj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mkoto kuvayogopa vala vevikoma higa, nambu nakuhotola kukoma mpungu. Mbanga neju kumuyogopa yula mweihotola kukoma higa pamonga na mpungu mumotu wa magono goha wangajimika. ");
INSERT INTO xnj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mayeluyelu gavili gegiguliswa kwa lishonga limonga lidebe. Nambu hati limonga lihotola lepi kugwa pandima changagana Dadi winu. ");
INSERT INTO xnj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambu kwa upandi winu, mwene amanyili mvalangu wa mayunju goha ga mitu yinu. ");
INSERT INTO xnj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hinu mkoto kuyogopa, muni nyenye mwitopeswa neju kuliku mayeluyelu gamahele.” ");
INSERT INTO xnj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila mundu mweakuniyidakila nene palongolo ya vandu, na nene yati nikumyidakila palongolo ya Dadi wangu mweavi kunani. ");
INSERT INTO xnj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambu mundu yeyoha mweakunibela nene palongolo ya vandu, na nene yati nikumbelela palongolo ya Dadi wangu mweavi kunani.” ");
INSERT INTO xnj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mkoto kuhololela ngati nibweli kuleta uteke pamulima. Nibweli lepi kuleta uteke nambu ngondo. ");
INSERT INTO xnj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Muni nivaletili mpechenganu pagati yinu, mwana na dadi waki, msikana na nyina waki na mkamwana na nayala waki. ");
INSERT INTO xnj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na vamakoko va mundu, ndi vala va panyumba yaki.” ");
INSERT INTO xnj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mwene mweakumgana neju dadi amala nyina waki kuliku nene, iganikiwa lepi kuvya muwuliwa wangu. Mewawa mundu yeyoha mweakumgana neju msongolo amala msikana waki kuliku nene, iganikiwa lepi kuvya muwuliwa wangu. ");
INSERT INTO xnj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu angagega msalaba waki mwene na kunilanda nene, iganikiwa lepi kuvya wangu. ");
INSERT INTO xnj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mundu mweikamulila wumi waki yati akuuyagisa, nambu mundu mweakuuyagisa wumi waki ndava ya kunisadika nene yati akugapata.” ");
INSERT INTO xnj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mundu mweavapokela nyenye, akunipokela nene, mundu mweakunipokela nene, akumpokela yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mundu mweakumpokela mlota wa Chapanga, ndava mlota wa Chapanga yati ipokela njombi ya ulota wa Chapanga. Mewawa Mundu mweakumpokela mundu mbwina palongolo ya Chapanga, ndava mundu mbwina yati ipokela njombi ya mundu mbwina. ");
INSERT INTO xnj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nikuvajovela chakaka, mundu yeyoha mweakumpela mmonga pagati ya vandu ava vangamanyikana chikombi cha manji gasisimu ndava mulanda wangu, chakaka ikosa lepi njombi yaki.” ");
INSERT INTO xnj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu peamali kuvapela malagizu vawuliwa vaki, kumi na vavili, akawuka penapo, kuhamba kuwula na kukokosa mumiji yeyavi papipi na Galilaya. ");
INSERT INTO xnj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohani Mbatizaji akungiwi mu jela, peayuwini matendu ga Kilisitu, ndi avatumili vawuliwa vaki, ");
INSERT INTO xnj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","vamkota Yesu, “Wu, veve ndi yula mweibwela, amala timlindila yungi?” ");
INSERT INTO xnj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu akavayangula, “Mhamba, mukamjovela Yohani gala gemukugalola na kuyuwana. ");
INSERT INTO xnj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Vangalola vilola na vangagenda vigenda, na vanamabudi vinyambiswa, na vangayuwa viyuwana na vevafwili viyukiswa na vangangu vikokoselewa Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Amotisiwa mundu yula mwangaleka kunisadika!” ");
INSERT INTO xnj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hinu vawuliwa va Yohani vala pavawuyili, Yesu akavajovela msambi wa vandu wewamtindili, malovi ga Yohani, “Mwahambili kulugangatu kulola kiki? Wu mwaganili kulola linyai chelinyuguswa na mpungu? ");
INSERT INTO xnj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hinu mwahambili kulola kyani? Mundu mweawalili nyula za kunyamba? Lola Vandu veviwala nyula za bwina vitama munyumba za vankosi. ");
INSERT INTO xnj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nambu mweambili kulola kyani? Mlota wa Chapanga? Ena, chakaka neju kuliku mlota wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Mwenuyu ndi Yohani mweajoviwi mu Mayandiku Gamsopi. ‘Yuwanila nene nikumtuma mjumbi wangu akulongolela, kutendelekela njila yaku.’ ");
INSERT INTO xnj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nikuvajovela chakaka, pagati ya vandu vevitama pamulima angahumila mweavi mkulu kuliku Yohani Mbatizaji. Pamonga na ago yula mweavi mdebe neju muunkosi wa Chapanga, ndi mkulu kuliku Yohani. ");
INSERT INTO xnj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuhuma lukumbi lwa Yohani Mbatizaji mbaka lelu, Unkosi wa Chapanga ubelelewa neju, na vandu vevavi na makakala vilinga kuutola kwa makakala. ");
INSERT INTO xnj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mawuliwu goha ga vamlota va Chapanga na vawula va Malagizu mbaka lukumbi ulu lwa Yohani galotili mambu ga lusenje lwa hinu.” ");
INSERT INTO xnj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ngati mwihotola kuyidikila aga, Yohani ndi Eliya mweibwela. ");
INSERT INTO xnj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mweavi na makutu, ndi ayuwana! ");
INSERT INTO xnj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Hinu nichiwanangisa na kyani chiveleku ichi? Ngati vasongolo vevitama pandu pa kugulisila vindu na msambi umonga ujovesana na wungi, ");
INSERT INTO xnj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Titovii ngo'ma nambu mumbeli kukina! Tiyimbili nyimbu za malilu nambu mvembi lepi!’ ");
INSERT INTO xnj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ndava muni Yohani abwelili, aleki kulya chakulya ndava ya Bambu, anganywa divayi, vene vakajova, ‘Ana mzuka.’ ");
INSERT INTO xnj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Mundu abwelili ilya na kunywa vene vakajova, ‘Mumlola mundu uyu! Muhutulu na chigaligali, nkozi wa vatola kodi na vevakumbudila Chapanga!’ Pamonga na genaa luhala lwa Chapanga lumanyikana kuvya labwina ndava ya matendu gaki.” ");
INSERT INTO xnj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kangi Yesu akatumbula kuhakalila vandu miji yeahengili gachinamtiti gamahele nambu valekili lepi kumbudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Mwalachikolela mwavandu va Kolazini! Mwalachikolela mwavandu va Betisaida! Muni, ngati gachinamtiti genihengili kwinu mbanga yagahengiki ku Tilo na ku Sidoni, vandu vaki ngavamali, kuwala magunila na kunyala malyenge vakotwiki kumbudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nambu nikuvajovela mu ligono la uhamula nyenye yati mwihamuliwa neju kuliku vandu va ku Tilo na Sidoni. ");
INSERT INTO xnj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na nyenye mwavandu va Kapelanaumu, wu, yati mukujikwiha mbaka kunani kwa Chapanga? Yati wiheleswa mbaka kuligodi litali langali mwishu! Ndava kuvya gachinamtiti gegahengiki kwa veve, yagahengiki ku Sodoma kula, muji wenuwo ngawasigalili mbaka lelu. ");
INSERT INTO xnj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambu nikuvajovela, ligono la uhamula veve yati wihamuliwa neju kuliku ya vandu va ku Sodoma!” ");
INSERT INTO xnj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lukumbi lwenulo, Yesu ajovili, “Nikusengusa, Dadi, Bambu wa kunani na mulima! Ndava uvafiyili mambu genago vevavi na luhala na vasomaji, ndi uvagubukulii vana vadebe.” ");
INSERT INTO xnj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena, Dadi, ndi cheyikuganisi. ");
INSERT INTO xnj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Dadi wangu anigotolili vindu vyoha. Avi lepi mweamumanyi Mwana nambu Dadi, mewa kawaka mweamumanyi Dadi nambu Mwana, na yeyoha yula ndi Mwana aganili kumgubukulila. ");
INSERT INTO xnj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mbwela mwavoha kwangu, mwemwing'aiswa na kuyegemewa na ndwika na nene yati nikuvapumulisa. ");
INSERT INTO xnj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mjikunga lingolingoli langu, mkajiwula kuhuma kwangu, muni nene ndi nampoli na mngolongondi wa mtima, na nyenye yati mpoleswa mumtima yinu. ");
INSERT INTO xnj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Muni, lingolingoli langu litopa lepi ndwika yangu yiyuyuka.” ");
INSERT INTO xnj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lukumbi ulo, Yesu avi mukupita mumigunda Ligono la Kupumulila, Hinu, vawuliwa vaki njala yavavinili, vakatumbula kudenya nganu na kuyogola ngele zaki na kulya. ");
INSERT INTO xnj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Vafalisayu pevagaweni genago, vakamjovela Yesu, “Lola, vawuliwa vaku vihenga lijambu lelibesiwi kuhenga pa Ligono la Kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu akayangula, “Wu, mwangasoma cheahengili Daudi na vayaki njala peyamvinili? ");
INSERT INTO xnj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mwene ayingili mu Nyumba ya Chapanga na kulya mabumunda gala gegavikwi palongolo ya Chapanga. Mwene hati vayaki kawaka mweayidakiliwi kulya mabumunda genago. Mabumunda ago gaganikiwi kuliliwa na vamteta va Chapanga ndu. ");
INSERT INTO xnj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Amala mwangasoma muchitabu cha Malagizu kuvya kila Ligono la Kupumulila vamteta va Chapanga vakugadenya malagizu ga Musa mu Nyumba ya Chapanga kuni vihololewa lepi kuvya vahokili? ");
INSERT INTO xnj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nambu hinu nikuvajovela kuvya penapa avi mkulu kuliku Nyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuvya mumanyalila mana ya malovi aga ‘Nigana lipyana, nigani lepi teta zinu.’ Ngamuvahamwili lepi vandu vangahoka. ");
INSERT INTO xnj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Muni Mwana wa Mundu ndi Bambu wa Ligono la Kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu akawuka penapo, akahamba munyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kwavi na mundu mmonga mweagogodili chiwoko. Hinu, vandu vamkotili Yesu, “Wu, Malagizu giyidakila kumlamisa mundu pa Ligono la Kupumulila?” Vamlingili ndava vapatayi njila ya kumtakila. ");
INSERT INTO xnj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambu Yesu akavajovela, “Wu, yani pagati yinu mweavi na limbelele laki, ligwilili muligodi, wu, akulihumisa lepi Ligono la Kupumulila? ");
INSERT INTO xnj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mundu itopeswa neju kuliku limbelele! Hinu ndi yiyidakiliwa kuhenga matendu gabwina pa Ligono la Kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kangi Yesu akamjovela mundu yula, “Talambula chiwoko chaku.” Mwene akachitalambula, ndi chalamili ngati chiwoko chingi chila. ");
INSERT INTO xnj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nambu Vafalisayu vakahuma kuvala na kujovesana, ndava ya mpangu wa kumkoma Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambu Yesu amanyalili mpangu wula, akawuka pandu pala. Msambi wa vandu wamlandili, akavalamisa vana matamu voha. ");
INSERT INTO xnj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Avabesili vakotoka kuvajovela vandu mambu gaki, ");
INSERT INTO xnj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","muni lilovi la ajovili Mlota Isaya litimilayi. ");
INSERT INTO xnj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lola, mtumisi mwenimuhagwili, chiganu changu, mweanihekesa neju mtima wangu. Nikuuvika mpungu wangu panani yaki, namwene yati ikokosa uhamula wangu kwa milima yoha. ");
INSERT INTO xnj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Angahutana, amala kuywanga, mewa lwami lwaki nakuyuwanika munjila ");
INSERT INTO xnj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mlahi weupondiki akuwudenya lepi, na utambi wewihuma lyohi wijimika lepi, mbaka kuhamula kwekuganikiwa kulongosa, ");
INSERT INTO xnj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Vandu voha va milima yoha vakumhuvalila mwene.” ");
INSERT INTO xnj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Penapo vandu vamletili Yesu mundu ngalola mewa avi ngajova mweatalaliwi na mzuka. Yesu akamlamisa hati akahotola kujova na kulola. ");
INSERT INTO xnj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Msambi woha wa vandu wewavi penapo ukakangasa na kujova, “Wu, mwenuyu lepi mwana wa Daudi?” ");
INSERT INTO xnj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambu Vafalisayu pevayuwini genago, vakajova, “Mundu uyu ivinga mizuka kwa uhotola wa Belizebuli mkulu wa mizuka.” ");
INSERT INTO xnj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu amanyili maholo gavi akajova, “Unkosi wowoha weulekangini chikundi chikundi wewitovana wene, wangahotola kusindimala mewawa na muji amala vandu va nyumba yimonga vevalekangini chikundi chikundi yati vigwa.” ");
INSERT INTO xnj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ngati Setani akavinga mizuka yaki, akujing'anamukila mwene. Hinu unkosi waki usindimala wuli? ");
INSERT INTO xnj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngati nyenye mwijova nene nikuyivinga mizuka kwa makakala ga Belizebuli, wu, valanda vinu vivinga kwa makakala ga yani? Ndava ya genago vandu vinu ndi vevakuvahamula nyenye! ");
INSERT INTO xnj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambu ngati nivinga mzuka kwa makakala ga Mpungu wa Chapanga, ndi mumanya kuvya Unkosi wa Chapanga umali kuvabwelela. ");
INSERT INTO xnj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ihotola wuli mundu kuizangila nyumba ya mundu mweavi na makakala na kumnyaga vindu vyaki, changali hoti kumkunga mundu ana makakala mwenuyo? Kangi ndi ahotola kumnyaga vindu vyaki.” ");
INSERT INTO xnj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mundu yeyoha mweanganilanda nene, akunibela, na mundu yeyoha mweangayola pamonga na nene, idandasa. ");
INSERT INTO xnj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ndava yeniyo nikuvajovela, vandu yati vilekekeswa kumbudila kwavi Chapanga na maligu gavi goha, nambu yati ilekekeswa lepi yula mweakumliga Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kangi, mundu yeyoha mweijova lilovi la kumbela Mwana wa Mundu yati ilekekeswa, nambu mundu yeyoha mweijova lilovi la kumbela Mpungu Msopi, ilekekeswa lepi pamulima uwu hati pamulima weubwela.” ");
INSERT INTO xnj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mkongo wakavya wabwina na matunda gaki yati givya gabwina mewawa, mkongo wakavya uhakau na matunda gaki givya gahakau mewa. Ndi mkongo umanyikana ndava ya matunda gaki. ");
INSERT INTO xnj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nyenye mwachiveleku cha liyoka! Mwihotola wuli kujova mambu gabwina kuni mwavene mwavahakau? Muni mundu ijova gala gegamemili mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu mbwina iwusa mambu gabwina muchibana chaki chabwina, mewawa mundu mhakau iwusa mambu gahakau muchibana chaki chihakau.” ");
INSERT INTO xnj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Hinu nikuvajovela, ligono la uhamula kila mundu yati ihamuliwa kwa kila lilovi lihakau leajovili. ");
INSERT INTO xnj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Muni malovi gaku wamwene yati wiyidakiliwa umganisi Chapanga, na kwa malovi gaku wamwene yati wihamuliwa kuvya uhokili.” ");
INSERT INTO xnj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kangi pagati ya vawula va malagizu na Vafalisayu vamjovili Yesu, “Muwula tigana kulola ulangisu kuhuma kwa veve.” ");
INSERT INTO xnj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mwene akayangula, “Chiveleku chihakau changali sadika! Mwigana ulangisu, yati mwipata lepi ulangisu, nambu ndi wulawula wa Yona mweavi mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngati Yona cheatamili magono gadatu kilu na muhi mulileme la somba yivaha, mewawa Mwana wa Mundu yati itama mugati ya ndima magono gadatu muhi na kilu. ");
INSERT INTO xnj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ligono la uhamula vandu va ku Ninawi yati viyima pamonga na chiveleku ichi na kuchihamula, ndava muni vene vamali kumng'anamukila Chapanga lukumbi Yona peavakokosili. Hinu apa avi mkulu kuliku Yona! ");
INSERT INTO xnj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nkosi wa chidala wa muji wa Sheba yati ihumila Kwelitipama lilanga lukumbi lwa uhamula wa chiveleku ichi, namwene yati akuchihamula kuvya chihokili. Muni mwene agendili kuhuma kutali, abwelili kuhuma kumulima waki, kuyuwana malovi ga luhala ga Solomoni, kumbi apa avi mkulu kuliku Solomoni.” ");
INSERT INTO xnj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mzuka ngati uvingiwi kwa mundu, ulyungalyunga kulugangatu kulonda pandu pa kupumulila. Akupapata lepi pandu, ");
INSERT INTO xnj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kangi akujijovela, ‘Niwuya kavili kunyumba yangu mwenihumili.’ Peiwuya akuyikolela nyumba yila yivii waka yifyagiliwi na kupambwa. ");
INSERT INTO xnj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kangi ihamba kuyitola mizuka yingi saba, hihakau neju kuliku mwene, yoha ibwela kuyingila kwa mundu yula. Mundu yula ivya mhakau neju kuliku peatumbwili. Hinu ndi yati yivya kwa chiveleku ichi chihakau.” ");
INSERT INTO xnj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu peavi akona ilongela na vandu, lola, nyina waki na valongo vaki vakahika na kuyima kuvala, vagana kulongela nayu. ");
INSERT INTO xnj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hinu mundu mmonga akamjovela, “Yuwanila nyina waku na valongo vaku vavi kuvala, vigana kulongela na veve.” ");
INSERT INTO xnj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nambu Yesu akamyangula mundu yula “Nyina wangu ndi yani? Na valongo vangu ndi vayani?” ");
INSERT INTO xnj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kangi akatalambula chiwoko chaki na kuvalangisa vawuliwa vaki, akajova, “Ava ndi nyina wangu na valongo vangu! ");
INSERT INTO xnj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muni mundu yeyoha mweihenga geigana Dadi wangu mweavili kunani, mwenuyo ndi mlongo wangu mlumbu wangu na nyina wangu.” ");
INSERT INTO xnj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ligono lilolo, Yesu awukili munyumba yila akahamba kutama mumhana ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Msambi uvaha wa vandu wamtindili hati Yesu akakwela muwatu, akatama. Vandu voha vayimili mumhana ya nyanja, ");
INSERT INTO xnj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","namwene Yesu akavajovela mambu ga mahele kwa miluhumu. “Myuwanila, mundu mmija mbeyu ahambili kumija mbeyu. ");
INSERT INTO xnj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Peamijili, mbeyu zingi zikagwilila munjila, na hidege yikabwela yikahola. ");
INSERT INTO xnj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Zingi zakagwilila pamatalau pangali kuvya na ludaka neju. Zalolikini zimeli kanyata ndava ludaka lwavi lwamahele lepi. ");
INSERT INTO xnj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lilanga palaumili, lachonili ndava mikiga yaki yakamwili lepi muludaka, zikanyala. ");
INSERT INTO xnj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu zingi zagwilili mumikongo ya minga, ndi mikongo ya minga yikamela na kuzihinya. ");
INSERT INTO xnj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Zingi zagwili paludaka lwa bwina, zameli na kupambika, yingi mbeyu miya yimoja na yingi mbeyu sitini na yingi mbeyu selasini.” ");
INSERT INTO xnj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu akajova, myuwana nyenye mwemuvi na makutu. ");
INSERT INTO xnj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Vawuliwa va Yesu vamhambili, vakamkota, “Ndava kyani wijova na vandu kwa miluhumu?” ");
INSERT INTO xnj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akavayangula, “Nyenye mpewili uhotola wa kumanya umfiyu wa Unkosi wa kunani kwa Chapanga, nambu vene vapewili lepi. ");
INSERT INTO xnj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Muni mundu mweavi na chindu yati iyonjokesewa neju, nambu mundu angali kuvya na chindu hati cheavi nachu yati chinyagiwa. ");
INSERT INTO xnj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Muni nijova nawu kwa miluhumu, ndava vilolokesa nambu vilola lepi viyuwana nambu vimanya lepi. ");
INSERT INTO xnj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwa vene gatimili malovi gala geajovili Isaya mweavi mlota wa Chapanga, kuyuwana yati mwiyuwana, nambu yati mwimanya lepi, kulola yati mwilola, nambu yati mwiwona lepi, ");
INSERT INTO xnj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","muni mitima ya vandu ava yitopa. Vagadindii makutu gavi, vagubiki mihu gavi. Kuvya lepi, yavaloli na mihu gavi, yavayuwini na makutu gavi, yavamanyalili muluhala lwavi, na kumuwuyila Bambu, na nene nganivalamisi. ");
INSERT INTO xnj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nambu mmotisiwa nyenye, muni mihu ginu gilola na makutu ginu giyuwana. ");
INSERT INTO xnj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nikuvajovela chakaka, vamlota va Chapanga vamahele na vandu va Chapanga vamahele vanogili kugalola gala gemgaloli nambu vagaloli lepi, na kuyuwana gala gemyuwini nambu nakuyuwana.” ");
INSERT INTO xnj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hinu, nyenye myuwana ndava ya luhumu lwenulu lwa mmija mbeyu. ");
INSERT INTO xnj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yeyoha mweiyuwana lilovi la Unkosi wa Chapanga changamanya, iwanangana ngati mbeyu zezagwili munjila, ndi yula mhakau ibwela na kutola chechimijiwi mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zezagwili mulitalau ndi luhumu wa mundu yula mweiyuwana lilovi lenilo na bahapo akulipokela kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambu nakuyingila mugati yaki ndava avi lepi na mikiga, lilovi lenilo litama mulukumbi luhupi na pegihumila man'gaiso na kuhengiwa uhakau ndava ya lilovi la Chapanga, kanyata igwa. ");
INSERT INTO xnj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mewawa na mbeyu yeyagwili pagati ya mikongo ya minga, ndi luhumu lwa mundu mweiyuwana lilovi lenilo, nambu mambu ga pamulima apa na mnogo wa kugana vindu vyamahele vikulitindila lilovi lenilo na ipambika lepi matunda ndi kuhenga gala gakumganisa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nambu mbeyu yeyagwilili muludaka lwabwina ndi luhumu wa mundu mweiyuwana lilovi na kulimanya, ndi yipambika matunda, yimonga matunda miya na yingi matunda sitini na yingi matunda selasini.” ");
INSERT INTO xnj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu avajovili vandu luhumu lungi, “Unkosi wa kunani kwa Chapanga uwanangini na mundu mweamijili mbeyu yabwina mumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hinu vandu pavagonili abwelili mundu likoko na kumija masindi pagati ya nganu na kuwuka. ");
INSERT INTO xnj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Penapo nganu peyameli na kutumbula kuholomola njechela, mewawa masindi gakahumila. ");
INSERT INTO xnj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Vatumisi va mkolo mgunda vamhambili na kumjovela mwene, ‘Bambu, chakaka wamijili mbeyu zabwina kumgunda waku. Hinu masindi gahumili koki?’ ");
INSERT INTO xnj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mwene akavayangula, ‘Mundu likoko ndi mweahengili genago.’ Ndi vatumisi vaki vakamkota wigana tete tikatupulai masindi? ");
INSERT INTO xnj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mwene akavayangula, ‘Lepi,’ Pangi pemwitupula masindi, yati mwitupula na nganu mewa. ");
INSERT INTO xnj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mlekayi vikula pamonga mbaka lukumbi lwa kubena. Lukumbi lwenulo ndi yati nikuvajovela vabenaji, vayola hoti masindi na kugakunga malundu ga kuyocha motu, na nganu mbenai na kuyivika pachibana changu.” ");
INSERT INTO xnj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu avajovili vandu luhumu lungi, “Unkosi wa kunani kwa Chapanga uwanangini na mbeyu yidebe yeyikemiwa haladali mundu ayitolili, na kumija kumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yene yivya yidebe kuliku mbeyu zoha, nambu yikamela na yikula kuvya mkongo uvaha kuliku mimea yoha, hati hidege yibwela na kujenga hisakanilu, mumambanda gaki.” ");
INSERT INTO xnj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu avajovili luhumu lungi, “Unkosi wa kunani kwa Chapanga uwanangini na mau mmonga mweagegili ngemeku, akahangisana na uhembe madebe gavili na lapinga, na uhembe woha watutumwiki.” ");
INSERT INTO xnj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu aujovili msambi wa vandu genago goha kwa miluhumu, kawaka chindu cheajovili changali miluhumu, ");
INSERT INTO xnj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Muni lijambu leajovili mlota wa Chapanga litimilayi, “Yati nijova nawu kwa luhumu, yati nikuvajovela mambu gegafiyiki kutumbula kuwumbwa kwa mulima.” ");
INSERT INTO xnj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kangi Yesu avalagili vandu vala, akayingila munyumba. Vawuliwa vaki vamhambalili vakamjovela, “Utidandaulila luhumu lwa masindi kumgunda.” ");
INSERT INTO xnj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu akavayangula, “Mmija mbeyu zabwina ndi Mwana wa Mundu ");
INSERT INTO xnj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mgunda wula ndi pamulima. Mbeyu zabwina zila ndi vandu vala unkosi ndi wavi. Nambu masindi gala ndi vandu va yula Mhakau. ");
INSERT INTO xnj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mundu likoko yula mweamijili masindi ndi Setani. Mabenu ndi mwishu wa mulima uwu, vabenaji ndi Vamitumu va kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngati chavitupula masindi na kugayocha motu, ndi yati cheyivya pamwishu wa mulima uwu. ");
INSERT INTO xnj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa Mundu yati akuvatuma Vamitumu vaki va Chapanga vavayola kuhuma ku Unkosi waki voha vevibudisa vandu kwa Chapanga na vevavi na matendu gahakau, ");
INSERT INTO xnj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuvataga mulitanulu la motu ukali kwenuko yati vivemba na kuyaga minu. ");
INSERT INTO xnj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kangi, vandu vevihenga matendu gabwina palongolo ya Chapanga yati ving'asima ngati lilanga muunkosi wa Dadi wavi. Hinu mweavi na makutu ndi ayuwana!” ");
INSERT INTO xnj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Unkosi wa kunani kwa Chapanga uwanangana ngati vindu vya mashonga gamahele vyevifiyiki kumgunda. Mundu mmonga ayiwene, akafiya kavili. Ahekili neju, hati akahamba kugulisa vyoha vyeavi navyu na akagula mgunda wula.” ");
INSERT INTO xnj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kavili Unkosi wa kunani kwa Chapanga uwanangana na mgulisa vindu mweilonda chindu cha mashonga gamahele neju chechikemelewa lulu. ");
INSERT INTO xnj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Peapatili lulu yimonga yeyiguliswa kwa mashonga gamahele neju, akahamba, kugulisa vyoha vyeavi navyu na kugula chindu chila.” ");
INSERT INTO xnj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Mewawa Unkosi wa kunani kwa Chapanga uwanangana na ngwanda wa somba weujwigiwi munyanja, kulova somba ndalindali. ");
INSERT INTO xnj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Paumemili, valova somba vahutili pandumba, vakatama na kuhagula somba zabwina na kuvika mumadengu gavi, na somba zezawolili vakataga. ");
INSERT INTO xnj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chenichi ndi cheyivya pamwishu wa mulima uwu, Vamitumu va kunani kwa Chapanga yati vihumila na kupangula vandu vabwina na vandu vahakau, ");
INSERT INTO xnj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kangi yati vakuvataga vandu vahakau mulitanulu la motu, kwenuko ndi yati vivemba na kuyaga minu.” ");
INSERT INTO xnj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu akavakota, “Wu, mukugamanya mambu goha aga?” Vakamyangula, “Ena.” ");
INSERT INTO xnj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mwene akavajovela, “Hinu ndi kila muwula wa malagizu mweajiwulili kuuvala unkosi wa kunani kwa Chapanga, iwanangana ngati mkolo nyumba mweiwusa vindu muchibana vya mashonga gamahele vyamupya na vyakadeni.” ");
INSERT INTO xnj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu peamali kujova miluhumu yeniyo awukili pandu pala, ");
INSERT INTO xnj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akahamba kumuji wavi. Akatumbula kuwula vandu munyumba za kukonganekela Vayawudi, vevamyuwini vakakangasa, vakajova, “Mwenuyu apatili koki luhala ulu?” Na uhotola wa kuhenga gachinamtiti? ");
INSERT INTO xnj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wu, mwenuyu lepi mwana wa yula mhongola mikongo? Na nyina waki ikemiwa lepi Maliya na valongo vaki, lepi Yakobo na Yosefu na Simoni na Yuda? ");
INSERT INTO xnj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Valumbu vaki voha nakutama pamonga na tete? Hinu agapatili koki mambu ago goha? ");
INSERT INTO xnj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Vabeli kumpokela, nambu Yesu akavajovela, “Mlota wa Chapanga itopeswa kila pandu, nambu nakutopeswa pamuji wa kunyumba yaki mwene!” ");
INSERT INTO xnj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hinu ndava ya kubela kumsadika kwavi, Yesu nakuhenga gachinamtiti yamahele kula. ");
INSERT INTO xnj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lukumbi lwenulo, chilongosi Helodi ayuwini malovi ga Yesu ");
INSERT INTO xnj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kangi, akavajovela vatumisi vaki, “Mundu mwenuyo ndi Yohani Mbatizaji, ayukili ndi muni makakala gachinamtiti gihenga lihengu mugati yaki.” ");
INSERT INTO xnj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Muni Helodi ndi mweamkamwili Yohani akamkunga pingu na kumsopa muchifungu, ndava ya Helodiya, mdala wa Filipi, mlongo waki. ");
INSERT INTO xnj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ndava Yohani amjovili Helodi, “Chabwina lepi veve kumgega Helodiya mdala wa mlongo waku!” ");
INSERT INTO xnj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helodi aganili kumkoma Yohani, nambu ayogwipi vandu ndava vandu vammanyili Yohani avi Mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hinu paligono la mselebuko wa kuvelekewa Helodi, msikana wa Helodiya akinili palongolo ya vayehe na Helodi ahekili neju. ");
INSERT INTO xnj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Namwene akamjovela kwa chilapu kumpela msikana mwenuyo chindu chochoha cheiyupa. ");
INSERT INTO xnj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mwene kuni ikohakewa na nyina waki ndi akayupa, “Unipela mutu wa Yohani Mbatizaji mulupalu.” ");
INSERT INTO xnj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nkosi akavya ngolongondi, nambu ndava ya chilapu chaki, na vayehe vala veavagongolili pachakulya, alagizi vampelai. ");
INSERT INTO xnj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hinu, Helodi atumili mundu muchifungu amdumula Yohani mutu. ");
INSERT INTO xnj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Vakavika mutu wa Yohani muchipalu na kumpela msikana yula, namwene akampelekela nyina waki. ");
INSERT INTO xnj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Vawuliwa va Yohani, vakabwela vakatola higa yaki na kuzika. Kangi vakahamba kumjovela Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Peamali kuyuwana ago, Yesu akawuka pandu apo na watu, na kuhamba pandu pachiepela, ngamwene. Nambu vandu vakayuwana ndi vakamlanda na magendelu kuhuma kumiji. ");
INSERT INTO xnj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu peahulwiki kubwani, auwene msambi wa vandu, akavahengela lipyana, akavalamisa vatamu voha. ");
INSERT INTO xnj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Payavi kimihi, vawuliwa vaki vakamhambila vakamjovela Yesu, “Pandu apa ndi palugangatu, na lilanga limali kutipama. Hinu uvalaga vandu vahamba muvijiji vakajigulila vyakulya.” ");
INSERT INTO xnj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nambu Yesu akavayangula “Viganikiwa lepi kuhamba, mvapela nyenye chakulya.” ");
INSERT INTO xnj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambu vene vakajova, “Tivii na mabumunda mhanu na somba zivili ndu.” ");
INSERT INTO xnj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu akavajovela, “Muniletelai apa.” ");
INSERT INTO xnj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ndi akavajovela vandu vatama mumanyai, na Yesu akatola mabumunda gala mhanu na somba zila zivili, akalolokesa kunani kwa Chapanga, akamsengusa Chapanga. Kangi akagametula mabumunda gala, na kuvapela vawuliwa vaki, navene vakavapela vandu. ");
INSERT INTO xnj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vandu voha vakalya na kuyukuta. Na vawuliwa vaki vakanonga hipandi yeyisigalili, na kumemesa madengu kumi na gavili. ");
INSERT INTO xnj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mvalangu wa vandu voha vevalili vavi vagosi elufu mhanu, changavalanga vadala na vana. ");
INSERT INTO xnj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Bahapo Yesu akavalagiza vawuliwa vaki vayingila muwatu, vamlongolela kumwambu ya nyanja lukumbi mwene ilagana na msambi wa vandu. ");
INSERT INTO xnj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Peamali kuvalaga vandu, akakwela kuchitumbi nga mwene kumuyupa Chapanga. Kimihi payahikili Yesu avi mwene ndu penapo, ");
INSERT INTO xnj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","nambu watu wula wamali kuhika pagati ya nyanja, nambu yikakang'wa neju na mtimbunganu wa manji, muni chimbungululu wakang'wayi wiwuya mumbele. ");
INSERT INTO xnj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hamba kucha payahegalili, Yesu avahambili vawuliwa vaki igenda kwa magendelu panani ya manji. ");
INSERT INTO xnj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nambu vawuliwa vaki pavamuwene igenda panani ya manji vakavagaya neju, vakajova “Lihoka!” Vakaywanga cha wogohi. ");
INSERT INTO xnj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bahapo Yesu akalongela nawu, “Mguna, ndi nene mkoto kuyogopa!” ");
INSERT INTO xnj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petili akajova, “Bambu ngati chakaka ndi wamwene, nijovela nibwela kwaku nigenda panani ya manji.” ");
INSERT INTO xnj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akamyangula, “Ena, bwela.” Hinu ndi Petili akahuluka muwatu wula akagenda panani ya manji, akamhambila Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nambu peuweni mpungu wula, akayogopa, akatumbula kujwigama akavemba kwa lwami, “Bambu unisangulayi!” ");
INSERT INTO xnj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Penapo, ndi Yesu akatalambula chiwoko chaki na akamkamula akamjovela, “Veve mweusadika padebe! Ndava kyani uvi na mtahu?” ");
INSERT INTO xnj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndi akayingila muwatu, na mpungu ukaguna. ");
INSERT INTO xnj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Voha vevavi muwatu vamfugamili, vakajova, “Chakaka veve ndi Mwana wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Vakakupuka nyanja vakahika mulima wa ku Genezaleti. ");
INSERT INTO xnj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vandu pevammanyili Yesu, vakadandasa malovi pandu pala poha. Kangi vakamletela vatamu voha, ");
INSERT INTO xnj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","vakamuyupa neju avayidakila vapamisa ndu lugunyilu lwa nyula yaki. Na voha vevapamisi valamili. ");
INSERT INTO xnj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Vafalisayu vangi na vawula va malagizu vakahika kuhuma ku Yelusalemu, vakamhambila Yesu vakamkota, ");
INSERT INTO xnj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ndava kyani vawuliwa vaku vitopesa lepi mawuliwu ga vagogo vitu? Visamba lepi chabwina mawoko kwakona kulya chakulya!” ");
INSERT INTO xnj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akayangula, “Ndava kyani nyenye mwidenya mihilu ya Chapanga, ndava ya kulanda mawuliwu ginu?” ");
INSERT INTO xnj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chapanga amali kujova, uvatopesa dadi waku na nyina waku, na mweampela likoto dadi waki amala nyina waki yikumgana akomiwa. ");
INSERT INTO xnj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambu nyenye mwijova, mundu mweakumjovela dadi waki amala nyina waki kuvya, chochoha chenihotola kukutangatila, nimuwusili Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","iganikiwa lepi kumtangatila dadi waki amala nyina waki. Chenichi ndi chemdenya amuli ya Chapanga kwa kugalanda mawuliwu ginu! ");
INSERT INTO xnj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Nyenye mwemkujikita kuvya vandu vabwina! Isaya alotili chakaka, ndava yinu, peajovili malovi aga! ");
INSERT INTO xnj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Chapanga ijova, vandu ava vakunitopesa kwa malovi ndu, nambu mitima yavi yivii kutali na nene. ");
INSERT INTO xnj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunigundamila kwavi ndi waka, ndava mambu geviwula ndi malagizu ga vandu ndu.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kangi Yesu aukemili msambi wa vandu akaujovela, “Myuwanila na kumanya malovi genikuvajovela! ");
INSERT INTO xnj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chindu chechikumyingisa mundu uhakasa palongolo ya Chapanga lepi chechiyingila mumlomo, nambu ndi chila chechikumuhuma mundu mumlomo.” ");
INSERT INTO xnj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kangi vawuliwa vaki vakamhambila, vakamjovela, “Wu, umanyili kuvya Vafalisayu vayomili pevayuwini malovi gaku?” ");
INSERT INTO xnj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambu mwene akavayangula, “Mbeyu yeyoha angamija Dadi wangu mweavi kunani, yati yitupuliwa. ");
INSERT INTO xnj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mvaleka vene! Vene ndi vangalola, vachilongosi wa vangalola, na ngalola akamlongosa ngalola muyaki, voha vavili yati vidumbukila muligodi.” ");
INSERT INTO xnj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petili akajova, “Utidandaulila luhumu wenuwo.” ");
INSERT INTO xnj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu akajova, “Hati nyenye mwakona mwangagamanya ago? ");
INSERT INTO xnj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wu, mwihotola lepi kumanya chechiyingila mumlomo chihamba mulileme na chiumiswa kuvala kundindima? ");
INSERT INTO xnj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambu mambu gegihumila mumlomo gihuma mumtima, genago ndi gegakumkita mundu akotoka kuyidakiliwa palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ndi mumtima gihuma maholo na ukomaji na ugoni na ukemi na kuyiva na malovi ga udese na maligu. ");
INSERT INTO xnj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Genago ndi gegakumkita mundu kuvya mhakasa palongolo ya Chapanga. Nambu kulya chakulya changasamba nakumuyingisa mundu uhakasa.” ");
INSERT INTO xnj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu awukili pandu penapo akahamba kutama kumuji wa Tilo na Sidoni. ");
INSERT INTO xnj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mau mmonga Mkanani wa mulima wenuwo ambwelili na kuywanga neju, “Bambu Mwana wa Daudi, unihengela lipyana! Msikana wangu ing'ahiswa na mzuka.” ");
INSERT INTO xnj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambu Yesu ayangwili lepi, hinu vawuliwa vaki vakamhambila, vakamjovela, “Mjovela awuka lola akutilanda kuni iywanga.” ");
INSERT INTO xnj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akayangula, “Nitumwili ndu kwa mulima wa Isilaeli, vevavi ngati limbelele leliyagili.” ");
INSERT INTO xnj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nambu mau yula akabwela akamfugamila, akajova “Bambu, unitangatila.” ");
INSERT INTO xnj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu akamyangula “Chabwina lepi kutola chakulya cha vana na kutagila mabwa.” ");
INSERT INTO xnj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hinu mau yula akayangula, “Chakaka, Bambu, nambu hati mabwa gilya masigalilu gegigwa pahi pameza ya bambu wavi.” ");
INSERT INTO xnj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Penapo ndi Yesu akayangula, “Mau veve, sadika yaku yivaha! Uhengewa ngati chaugana.” Msikana waki akalama lukumbi lulalula. ");
INSERT INTO xnj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu akawuka penapo akahamba mumhana wa nyanja Galilaya, akakwela pachitumbi, akatama pahi. ");
INSERT INTO xnj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Msambi wa vandu vambwelili vamletili vevagogodili higa na vangalola na vangajova pamonga na vangi vamahele vevagogodili magendelu vana matamu, vakavavika palongolo ya magendelu gaki, mwene akavalamisa ");
INSERT INTO xnj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Msambi wa vandu ukakangasa neju pavaweni vangajova vijova, vevagogodili higa vilama vevagogodili magendelu vigenda na vangalola vilola, vandu vakamulumba Chapanga wa Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu avakemili vawuliwa vaki na kuvajovela, “Nikuvahengela lipyana vandu ava ndava vatamii pamonga na nene magono gadatu, nivii lepi na chindu chakulya. Nangagana vawuka na njala, muni vakotoka kuinduka munjila.” ");
INSERT INTO xnj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Vawuliwa vaki vakamjovela, “Penapa palukongolo tipata koki chakulya cha kuyukuta msambi woha wa vandu?” ");
INSERT INTO xnj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu akavakota, “Mabumunda gavi galinga?” Vakamyangula “Saba na tusomba tudebe.” ");
INSERT INTO xnj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu akalagiza vandu vatama pahi. ");
INSERT INTO xnj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akatola mabumunda gala saba na tusomba tudebe tula, akalolokesa kunani kwa Chapanga, akamsengusa Chapanga, akavimetula, akavapela vawuliwa vaki, navene vakavagavila vandu. ");
INSERT INTO xnj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Voha vakalya na kuyukuta. Kangi vakayola masigalilu ga hipandi na kumemesa madengu saba. ");
INSERT INTO xnj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vandu vevalili vavi vagosi elufu mcheche changavalanga vadala na vana. ");
INSERT INTO xnj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ndi Yesu akavalaga vandu vala, akayingila muwatu, akahamba kumuji wa Magadani. ");
INSERT INTO xnj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Vafalisayu na Vasadukayu vamhambili Yesu na kumlinga, vamyupili avalangisa ulangisu kuhuma kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambu Yesu akavayangula, “Yikahika kimihi mwijova yati kwivya kwabwina ndava kunani kudung'u! ");
INSERT INTO xnj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na lukela hamba kucha mwijova, ‘Lelu yati kwivya na fula, ndava kunani kudung'u na mahundi gatindili!’ Mwimanya bwina kusoma ulangisu wa kunani, nambu mwangamanya kusoma ulangisu wa lusenje lwa hinu. ");
INSERT INTO xnj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chiveleku changasadika! Chigana ulangisu, chipewa lepi ulangisu, nambu nga wulawula wa Yona mweavi mlota wa Chapanga.” Yesu akavaleka, akawuka. ");
INSERT INTO xnj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Vawuliwa vaki pavamali kukupuka kumwambu ya nyanja vakumbwiki kuvya vakosiwi kugega mabumunda. ");
INSERT INTO xnj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu akavajovela, “Mvya mihu na mujiyangalila na ngemeku ya Vafalisayu na Vasadukayu!” ");
INSERT INTO xnj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nambu vene vakajovesana, “Ijova genaga ndava tigegili lepi mabumunda.” ");
INSERT INTO xnj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu amanyili maholo gavi, akavajovela, “Nyenye vandu mwemsadika padebe, ndava kyani mwijovesana ndava nakuvya na mabumunda? ");
INSERT INTO xnj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mwangamanya? Mwikumbuka lepi mabumunda gala mhanu genavalisili vandu vala elufu mhanu ndi madengu galinga gemwamemisi? ");
INSERT INTO xnj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amala, mabumunda saba gala genavalisili vandu elufu mcheche, wu, madengu galinga ga masigalilu gemwamemisi? ");
INSERT INTO xnj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndava kyani nakumanya, kuvya navi nakulongalela mambu ga mabumunda? Nambu mjiyangalila na ngemeku ya Vafalisayu na Vasadukayu!” ");
INSERT INTO xnj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kangi vawuliwa vakamanya kuvya avi nakujova ndava ya ngemeku ya mabumunda, nambu ndava ya mawuliwu ga Vafalisayu na Vasadukayu. ");
INSERT INTO xnj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu peahikili muji wa Kaisalia Filipi, akavakota vawuliwa vaki, “Vandu vijova Mwana wa Mundu ndi nayani?” ");
INSERT INTO xnj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vakamyangula, “Vangi vijova Yohani Mbatizaji,” “Vangi vijova Eliya na vangi vijova Yelemia, amala mmonga pagati ya Vamlota va Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu akavakota, “Na nyenye mwijova nene ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petili akayangula, “Veve ndi Kilisitu, Mwana wa Chapanga mweavi mumi.” ");
INSERT INTO xnj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akajova, “Umotisiwa veve Simoni mwana wa Yona, ndava muni, kawaka mundu yeyoha mweakugubukuli lijambu lenili, nambu Dadi wangu wa kunani. ");
INSERT INTO xnj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nene nikuvajovela, veve ndi Petili, na panani ya litalau lenili yati nijenga msambi wa vandu vevakumsadika Kilisitu. Hati makakala ga lifwa gihotola lepi. ");
INSERT INTO xnj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yati nikupela fungulu za Unkosi wa kunani kwa Chapanga, chochoha cheudinda pamulima yati chidindiwa kunani kwa Chapanga, mewawa chochoha cheudindula pamulima, yati chidinduliwa kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kangi Yesu avabesili neju vawuliwa vaki vakotoka kumjovela mundu yeyoha yula kuvya mwene ndi Kilisitu Msangula. ");
INSERT INTO xnj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuhumila penapo Yesu atumbwili kuvajovela hotohoto vawuliwa vaki, kuvya yikumgana ahamba ku Yelusalemu, na kwenuko yati inga'iswa pamahele, ndava ya kuyokiswa na vagogo, na vamteta vakulu na vawula va malagizu ga Chapanga geampeli Musa, kuvya yati ikomiwa na paligono la datu yati iyuka. ");
INSERT INTO xnj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petili akamtola pamhana, akatumbula kumhakalila, “Gakotoka kukuhumila Bambu! Lijambu lenilo langakukolela!” ");
INSERT INTO xnj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambu Yesu akang'anamuka, akamjovela Petili, “Uwuka palongolo yangu, Setani! Veve ndi Chipingilu changu, maholo gaku lepi ga Chapanga nambu gachimundu.” ");
INSERT INTO xnj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kangi Yesu akavajovela vawuliwa vaki, “Mundu yeyoha mweigana kuvya mlanda wangu yikumgana ajibela mwene, atola msalaba waki, anilandayi. ");
INSERT INTO xnj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Muni, mundu mweigana kuusangula wumi waki mwene, yati akuuyagisa, nambu mundu mweakuuyagisa wumi waki ndava yangu yati akuupata kavili. ");
INSERT INTO xnj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wu, mundu yati ipata kyani akapata vindu vyoha vya pamulima na kuuyagisa wumi waki? Amala mundu yati iwusa chindu kiki chivya pandu pa wumi waki? ");
INSERT INTO xnj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ndava muni, Mwana wa Mundu yati ibwela na ukulu wa Dadi waki pamonga na vamitumu vaki va kunani kwa Chapanga, penapo ndi peakumuwuyisila kila mundu ndava ya matendu gaki. ");
INSERT INTO xnj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nikujovela chakaka, vavi vangi bahapa, vifwa lepi changamlola Mwana wa Mundu ibwela avi Nkosi.” ");
INSERT INTO xnj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pegamaliki magono sita, Yesu avatoli Petili na Yakobo na Yohani mlongo waki, akahamba nawu ngavene kunani ya chitumbi chitali. ");
INSERT INTO xnj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kwenuko, Yesu ang'anamwiki mlolekanu waki palongolo yavi. Pamihu paki pang'asimi ngati lilanga na nyula zaki zang'asimi ngati lumuli. ");
INSERT INTO xnj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kangi vawuliwa vadatu vala vavawene Musa na Eliya vilongela na Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Penapo petili akamjovela Yesu, “Bambu ndi chabwina tete kuvya apa! Ngati wigana yati nijenga vindanda vidatu chimonga cha veve, chimonga cha Musa na chingi cha Eliya.” ");
INSERT INTO xnj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petili peavi akona ijova ago, lihundi la msopi lavagubiki, na lwami lukayuwanika kuhuma mulihundi, “Mwenuyu ndi mwana vangu mwenikumgana mweniganisiwa nayu mumyuwanilayi.” ");
INSERT INTO xnj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Vawuliwa vala pevayuwini genago, vakayogopa neju, vakagwa chakukupama. ");
INSERT INTO xnj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nambu Yesu akavahambila, akavapamisa, akajova, “Myima mkoto kuyogopa!” ");
INSERT INTO xnj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pavayinula mitu yavi na kulola avi lepi mundu yungi, nambu ndi Yesu mwene. ");
INSERT INTO xnj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hinu, pavahelela kuhuma kuchitumbi, ndi Yesu avabesili, “Mkoto kumjovela mundu mambu gemgaweni mbaka Mwana wa Mundu peiyukiswa.” ");
INSERT INTO xnj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kangi vawuliwa vakamkota “Ndava kyani vawula va malagizu vijova Eliya abwela hoti?” ");
INSERT INTO xnj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akavayangula, “Chakaka, Eliya yati ibwela hoti na kutendelekela mambu goha. ");
INSERT INTO xnj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambu nikuvajovela, Eliya amali kubwela na vene nakummanya, nambu vamhengili chavaganili. Mewawa Mwana wa Mundu yati in'gahiswa mumawoko gavi.” ");
INSERT INTO xnj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kangi vawuliwa vamanyili kuvya akuvajovela kumvala Yohani Mbatizaji. ");
INSERT INTO xnj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pevauhikili kavili msambi wa vandu, mundu mmonga amhambili Yesu, akamfugamila palongolo yaki, ");
INSERT INTO xnj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akajova “Bambu mhengela lipyana mwana vangu muni ihinduka, kangi ing'ahika neju, pamahele mwene igwa pamotu amala mumanji. ");
INSERT INTO xnj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namletili kwa vawuliwa vaku nambu vahotwili lepi kumlamisa.” ");
INSERT INTO xnj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu akayangula, “Nyenye chiveleku changasadika na chechiyagili yati nitama na nyenye mbaka ndali? Yati nikuvasindimalila nyenye mbaka ndali? Mniletela apa mwana mwenuyo.” ");
INSERT INTO xnj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu akahakalila mzuka wula, wene ukamuwuka ndi msongolo yula akalama lukumbi lulalula. ");
INSERT INTO xnj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kangi vawuliwa vakamhambila Yesu pachiepela na kumkota, “Ndava kyani tete tahotwili lepi kuuwusa mzuka?” ");
INSERT INTO xnj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akayangula, “Ndava sadika yinu yidebe. Nikuvajovela chakaka ngati muvi na sadika hati yidebe ngati mbeyu ya haladali. Mwihotola kuchijovela chitumbi ichi, ‘Wuka apa uhamba pala!’ Nachene yati chihamba, kawaka chindu chochoha changahengeka kwinu.” ");
INSERT INTO xnj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambu mzuka ngati uwu nakuhuma, nambu kwa kumuyupa Chapanga na kujihinisa kulya chakulya. ");
INSERT INTO xnj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Vawuliwa va Yesu pevavi pamonga ku Galilaya Yesu akavajovela, “Mwana wa Mundu yati igotolewa kwa vandu. ");
INSERT INTO xnj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yati vakumkoma nambu paligono la datu yati iyukiswa.” Vawuliwa vaki vakavya vakaviniswa mtima. ");
INSERT INTO xnj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pevahikili ku Kapelanaumu vandu vevitola kodi ya Nyumba ya Chapanga vakamhambila Petili, vakamkota, “Wu, muwula winu, ilipa kodi ya Nyumba ya Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petili akavayangula, “Ena, ilipa.” Hinu, petili peayingili munyumba kwakona angajova chindu, Yesu akamkota, “Simoni, veve wihololela wuli? Vankosi va pamulima vitola ushulu amala kodi kuhuma kwa yani? Kuhuma kwa vakolonjinji amala kwa vayehe?” ");
INSERT INTO xnj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petili akayangula “Kwa vayehe.” Yesu akamjovela chakaka, “Vakolonjinji vilipa lepi. ");
INSERT INTO xnj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambu tikotoka kuvayomesa vandu ava. Uhamba kunyanja ukataga luvecha, somba yeutumbwili kulova utola, udindula mlomo waki yati ukolela lishonga utola ulipa kodi ndava yaku na ndava yangu.” ");
INSERT INTO xnj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lukumbi lwenulo vawuliwa vamhambili Yesu, vakamkota, “Yani mweavimvaha Muunkosi wa kunani kwa Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu amkemili mwana mmonga na akamyimika pagati yavi, ");
INSERT INTO xnj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kangi akajova, “Nikuvajovela chakaka, ngati mwing'anamuka lepi na kuvya ngati vana vadebe, katu nakuyingila muunkosi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mundu yeyoha mweakujihelesa pahi ngati mwana, mwenuyo ndi mvaha munkosi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mundu yeyoha mweakumpokela mwana mmonga ngati uyu paliina langu, akunipokela nene.” ");
INSERT INTO xnj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mundu yeyoha mweakumbudisa mmonga pagati ya vadebe vevisadika vabudayi, ngayivii mbanga akungiwa liganga livaha la kuyagila muhingu na kujwigiswa pagati ya nyanja yivaha. ");
INSERT INTO xnj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Valachikolela vandu va mulima ndava ya kuyokisa vangi vagwai. Mabudisa genago yikugagana gahumila, nambu alachikolela mundu yula mweakugabudisa.” ");
INSERT INTO xnj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ngati chiwoko chaku amala chigendelu chaku chikubudisa, chidumulai na kutaga kutali, Mbanga veve kuyingila kuwumi changali chiwoko chimonga amala chigendelu chimonga kuliku veve kuyingila kumotu wa magono goha wangajimika kuni uvi na mawoko gavili amala magendelu gavili. ");
INSERT INTO xnj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lihu laku lakakubudisa, ulitupula na ulitaga kutali. Mbanga veve kuyingila muwumi wa magono goha gangali mwishu kuni uvi na lihu limonga kuliku kuvya na mihu gavili na kutagwa kumotu wa magono goha wangali mwishu wangajimika kuni uvi na mihu gaku gavili.” ");
INSERT INTO xnj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mjiyangalila mkoto kuvavevesa mmonga wa vadebe ava. Nikuvajovela vamitumu vavi kunani kwa Chapanga magono goha vavi palongolo ya Dadi wangu. ");
INSERT INTO xnj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ndava muni Mwana wa Mundu abwelili kusangula chechiyagili.” ");
INSERT INTO xnj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mwihololela wuli? Ngati mundu avi na mambelele miya yimonga, limbele limonga lakayagai. Wu, nakugaleka mambelele tisini na tisa pachitumbi, kuhamba kulonda limonga lelikayagili? ");
INSERT INTO xnj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ngati aliwene, nikuvajovela chakaka yati akulihekelela neju lenilo kuliku gala tisini na tisa gangayaga. ");
INSERT INTO xnj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mewawa, Dadi winu mweavi kunani, nakugana mmonga wa vadebe ava ayaga.” ");
INSERT INTO xnj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mlongo waku akakuhokela umhambila ukamlangisa cheakuhokili muvi mwavene. Akakuyuwana ndi umpati kavili mlongo waku. ");
INSERT INTO xnj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ngati nakukuyuwanila, hamba na mundu yungi mmonga amala vavili muni kwa malovi ga vandu vavili amala vadatu lijambu loloha limaliswa ngati Mayandiku Gamsopi chegijova. ");
INSERT INTO xnj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ngati akabela kuvayuwana venavo, uwujovela msambi wa vandu vevakumsadika Kilisitu, ngati akuvayuwanila lepi avo, kwa veve ndi avya ngati vandu vangammanya Chapanga na vevitola kodi.” ");
INSERT INTO xnj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nikujovela chakaka, chemwibesa pamulima, yati chibesewa kunani kwa Chapanga, mewawa chechiyidakiliwa pamulima yati chiyidakiliwa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nijova kangi, vavili pagati yinu vakayidakilana pamulima ndava ya lijambu loloha la kumuyupa Chapanga, Dadi wangu wa kunani yati akuvahengela lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ndava muni popoha pamuvi vavili amala vadatu kwa liina langu, nene nivii penapo pagati yavi.” ");
INSERT INTO xnj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kangi Petili akamhambila Yesu, akamkota “Bambu, wu, mlongo wangu akanibudilayi, nimulekekesa mala yilinga? Amala mala saba?” ");
INSERT INTO xnj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akayangula, “Nijova lepi nga mala saba, nambu sabini mala saba.” ");
INSERT INTO xnj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndava yeniyi ndi Unkosi wa kunani kwa Chapanga uwanangana na mkulu mmonga mweaganili kuhenga mvalangu wa madeni na vatumisi vaki. ");
INSERT INTO xnj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Peatumbwili kuvalanga, vamletili mundu mweadaiwayi mashonga elufu kumi. ");
INSERT INTO xnj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mundu mwenuyo avi lepi na chindu cha kulipa, mkulu waki akahamula, aguliswai ngati mvanda mwene na mdala waki na vana vaki na vindu vyeavili navyu muni valipa lideni. ");
INSERT INTO xnj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hinu, mtumisi yula. Akagwa pahi, akafugama, akajova, unilindila nene yati nikukulipa lideni loha! ");
INSERT INTO xnj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mkulu yula akamhengela lipyana akamlekekesa lideni lila akamleka ahamba. ");
INSERT INTO xnj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambu mundu yula pawukili, akakonganeka na mtumisi muyaki mweamdayayi mashonga gadebe. Akamkamula akamdodoyola hingu, akumjovela ‘Nilipa lideni laku!’ ");
INSERT INTO xnj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mtumisi muyaki akafugama, akajova, niyupa, ‘Unilindila nene yati nikukulipa lideni laku loha!’ ");
INSERT INTO xnj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nambu mwene angayidakila, ndi akamusopa muchifungu mbaka peilipa lideni lila. ");
INSERT INTO xnj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hinu, vatumisi vayaki pavawene lijambu lelahumalili vakaviniswa mtima, vakahamba kumjovela mkulu wavi kulivala lijambu lelahengiki. ");
INSERT INTO xnj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kangi mkulu yula akamkemela mtumisi mwenuyo, akamjovela, ‘Veve ndi mtumisi mhakau neju! Nikulekekisi lideni laku loha pewaniyupili. ");
INSERT INTO xnj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wu, yakuganili lepi veve kumlekekesa mtumisi muyaku ngati chenikulekekisi nene?’ ");
INSERT INTO xnj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hinu mkulu yula akamema ligoga, akamgotola kwa vang'aisa muchifungu mbaka peilipa lideni laki loha.” ");
INSERT INTO xnj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Na dadi wangu mweavi kunani yati akuvahengela mewawa ngati kila mmonga winu akumlekekesa lepi mlongo waki kwa mtima waki woha.” ");
INSERT INTO xnj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu peamali kujova malovi ago, akawuka kumkoa wa ku Galilaya na kuhamba kumuji wa Yudea kumwambu ya mfuleni Yoludani. ");
INSERT INTO xnj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Msambi uvaha wa vandu wamlandili kwenuko, mwene akavalamisa. ");
INSERT INTO xnj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hinu pagati ya Vafalisayu vangi vakambwelela vakamulinga kumkota, “Wuli, ndi chabwina mgosi kumleka mdala waki ndava ya chindu chochoha chila?” ");
INSERT INTO xnj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akavayangula, “Wu, mwangasoma mu Mayandiku Gamsopi kuvya Chapanga mweawumbili mundu kutumbula kadeni, amuwumbili mundu mgosi na mdala? ");
INSERT INTO xnj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kangi akajova, ‘Ndava yeniyo, mgosi yati akumleka dadi waki na nyina waki na kuwungana na mdala waki, ndi voha vavili yati vivya higa yimonga.’ ");
INSERT INTO xnj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndava yeniyo, ndi lepi kavili vavili, nambu higa yimonga. Cheachiwunganishi Chapanga mundu akoto kuchipangulana.” ");
INSERT INTO xnj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nambu Vafalisayu vakamkota, “Ndava kyani, Musa atilagazili yihotoleka mgosi kumpela mdala waki balua na kumleka?” ");
INSERT INTO xnj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu akayangula, “Musa avalekekisi ndava ya kutopa kwa mitima yinu. Nambu nakuvya chenicho kutumbula Chapanga peawumbili mulima. ");
INSERT INTO xnj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nikuvajovela, mundu yeyoha mweakumleka mdala waki na kugega mdala yungi ikita ugoni nambu ndu ndava ya ukemi ihotola kumleka.” ");
INSERT INTO xnj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vawuliwa vaki vakamjovela, “Ngati mambu ga mgosi na mdala waki ndi ago, mbanga kukotoka kugega.” ");
INSERT INTO xnj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu akavajovela, “Lepi voha vevihotola kuyidakila lilovi lenili, nambu vala vevahotwisi na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Muni gavi mambu ndalindali gegihenga vagosi vakotoka kugega, vavi vevavelikiwi kahumbi kapecha, vangi ndava vahengiwi na vandu kuvya vakahumbi kapecha na vangi vigega lepi ndava ya Unkosi wa kunani kwa Chapanga. Mweihotola kuyidakila lilovi lenilo ayidakilayi.” ");
INSERT INTO xnj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kangi vandu vamletili Yesu vana vadebe muni avavikila mawoko na kuvayupila. Nambu vawuliwa vaki vakavahakalila vandu vala. ");
INSERT INTO xnj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nambu Yesu akavajovela, “Muvaleka vana ava vabwela kwa nene, na mkoto kuvabesa, muni Unkosi wa kunani kwa Chapanga ndi wa vandu ngati vana venava.” ");
INSERT INTO xnj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hinu Yesu peamali kuvavikila mawoko muni avamotisa, ndi akawuka pandu penapo. ");
INSERT INTO xnj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu mmonga amhambili Yesu akamkota, “Muwula, nikita chindu kiki chabwina nivyaa na wumi wa magono goha?” ");
INSERT INTO xnj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akamyangula, “Ndava kyani ukunikota lijambu la bwina? Avi mmonga ndu mweavi mbwina. Ngati wigana kuvya na wumi wa magono goha, uyidakila mihilu.” ");
INSERT INTO xnj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundu yula akamkota, “Mihilu yoki?” Yesu akamyangula, “Ukoto kukoma, kukita ugoni, kuyiva, kujova udese, ");
INSERT INTO xnj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","vatopesayi dadi waku na nyina waku na umgana muyaku ngati cheukujigana wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Msongolo yula akamjovela, “Genago goha nigalandili, hinu nihenga kyani neju?” ");
INSERT INTO xnj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu akamjovela, “Ngati wigana kuvya chakaka mundu mbwina, uhamba ukagulisa vindu vyaku vyoha. Mashonga ago goha uvapela vangangu na veve yati ukujivikila vindu vyamahele kunani kwa Chapanga, kangi ubwela unilandayi.” ");
INSERT INTO xnj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hinu msongolo yula peayuwini malovi gala, akahamba kuni avi ngolongondi neju ndava muni avi na vindu vyamahele aganili lepi kuvilekelesa. ");
INSERT INTO xnj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kangi Yesu akavajovela vawuliwa vaki, “Nikuvajovela chakaka, ndi yinonopa mkolo vindu vyamahele kuyingila muunkosi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nikuvajovela kavili yati yiyeyuka kwa hinyama ngati ngamiya kuholota palibowo la sindanu, kuliku mweavi na vindu vyamahele kuyingila muunkosi wa kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Vawuliwa vala pevayuwini malovi ago vakakangasa neju, vakamkota Yesu, “Hinu ndi yani mweihotola kusanguliwa?” ");
INSERT INTO xnj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akavalolokesa, akavajovela “Lijambu lenili lihotoleka lepi kwa mundu, nambu kwa Chapanga mambu goha gihotoleka.” ");
INSERT INTO xnj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petili akayangula “Lola,” Tete tileki kila chindu ndava ya kukulanda. Yati tipata kyani? ");
INSERT INTO xnj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akavajovela, “Nikuvajovela chakaka, paitama Mwana wa Mundu pachigoda cha ukulu waki, pamulima wa mupya. Mewawa na nyenye mwemunilandili yati mwitama na nene muvigoda kumi na hivili na kuvahamula makabila kumi na gavili ga Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mundu yeyoha mwaalekili nyumba amala mlongo waki amala mlumbu amala dadi amala nyina waki amala vana vaki amala migunda yaki ndava ya nene. Yati ipokela mala miya na kuhala wumi wa magono goha wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambu vamahele vevavi va kutumbula yati vivya va mwishu na vevavi va mwishu yati vivya va kutumbula.” ");
INSERT INTO xnj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Unkosi wa kunani kwa Chapanga uwanangini na mkolo mgunda wa mizabibu, mwealavili lukela kuvalonda vandu valihengu mumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Vayidakilini kulipiwa mashonga ga luhuna lwa muhi umonga, akavatuma kumgunda waki wa mizabibu. ");
INSERT INTO xnj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Akahuma kavili saa datu lukela, na avaweni vandu vangi vayimili pandu pakugulisila vindu, vangali lihengu. ");
INSERT INTO xnj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akavajovela, ‘Mewawa na nyenye mhamba kulihengu kumgunda wangu wa mizabibu,’ Na nene yati nikuvalipa luhuna lwinu lwemganikiwa mupewayi. ");
INSERT INTO xnj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hinu, vakahamba. Kangi mkolo mgunda yula akahuma kangi saa sita, na saa tisa, akawuka kangi mewawa. ");
INSERT INTO xnj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hati Payahikili saa kumi na yimonga kimihi, ahumili kangi na kuvakolela vandu vangi vayimili pandu pa kugulisa vindu, hinu, akavakota. ‘Ndava kyani muyimili muhi woha changali lihengu?’ ");
INSERT INTO xnj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Vakamyangula, ‘Ndava kawaka mundu mweatipeli lihengu,’ Mwene akavajovela, na nyenye mhamba mkahenga lihengu kumgunda wa mizabibu.” ");
INSERT INTO xnj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Payavi kimihi, mkolo mgunda amjovili myimilila lihengu mumgunda, uvakemela vanalihengu uvalipa mashonga gavi, utumbula na vala veuvapeli lihengu pamwishu na umalakisa vala veuvapeli lihengu pakutumbula. ");
INSERT INTO xnj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hinu vevatumbwili lihengu saa kumi na yimonga kimihi, vabwelili na kila mundu apokili mashonga ga luhuna lwa muhi umonga. ");
INSERT INTO xnj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pavabwelili vala vevatumbwili lihengu peatumbwili vaholali kuvya yati vipokela neju, ndi navene vakapokela mashonga ga luhuna lwa muhi umonga kila mundu. ");
INSERT INTO xnj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pavamali kupokela vakamng'ung'utila mkolo mgunda yula. ");
INSERT INTO xnj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Vakamjovela, vandu ava va pamwishu vahengili lihengu nga lisaa limonga, hinu veve uvalipili kuwanangana na tete, kuni tete tiweli na kukangamala mulihengu na lilanga la muhi woha? ");
INSERT INTO xnj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mkolo mgunda yula, akamyangula mmonga wavi, “Yuwanila, mkozi, nikupunjili lepi chindu! Wu, tayidakilini lepi na veve mashonga ga luhuna lwa muhi umonga? ");
INSERT INTO xnj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Hinu tola mashonga ga luhuna lwaku, uhamba. Niganili kumpela wa pamwishu luhuna lwa kuwanangana na veve. ");
INSERT INTO xnj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nihotola lepi kukita chenigana na mashonga gangu? Ukunilolokesa lingele ndava muni nambwina?” ");
INSERT INTO xnj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hinu Yesu amalakisa kwa kujova, “Mewawa wa pamwishu yati vivya wa vakutumbula na vakutumbula yati vivya va pamwishu.” ");
INSERT INTO xnj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu peavi munjila kuhamba ku Yelusalemu, ndi akavatola vawuliwa vaki kumi na vavili vala kuchiyepela, na munjila kuni vigenda akavajovela. ");
INSERT INTO xnj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mlola, tihamba ku Yelusalemu kwenuko ndi Mwana wa Mundu yati igotolewa kwa Vakulu va kuteta na vawula va malagizu ga Chapanga geampeli Musa navene yati vakumhamula lifwa. ");
INSERT INTO xnj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kangi yati vakumgotola kwa vandu vangali Vayawudi, navene yati vakumvevesa na kumtova ndonga, na kumkoma kwa kumvamba pamsalaba nambu paligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Penapo nyina wavi vana va Zebedayo amhambili Yesu pamonga na vana vaki vavili, akamfugamila na kumuyupa chila cheigana. ");
INSERT INTO xnj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu akamkota, “Ugana kyani?” Mau yula akayangula, “Lagazila muunkosi waku vana vangu ava vavili vatama, mmonga upandi waku wa kulyelela na yungi wa kumangeya.” ");
INSERT INTO xnj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu akamyangula, “Nakuchimanya chemwiyupa. Wu, mwihotola kunywelela chikombi cha mang'ahiso cheninywela nene?” Vakamyangula, “Tihotola.” ");
INSERT INTO xnj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Akavajovela, “Chakaka yati mwinywelela chikombi changu, nambu kumtamisa mundu upandi wa kulyelela amala kumangeya ndi lihengu langu lepi, lijambu lenilo yati vipewa vala vevatendelekiwi na Dadi wangu.” ");
INSERT INTO xnj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Vawuliwa kumi vala pevayuwinili genago, vakavayomela vala valongo vavili. ");
INSERT INTO xnj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nambu Yesu akavakemela pamonga na kuvajovela, “Mwimanya kuvya vachilongosi va mulima vakuvalongosa vandu vavi kwa makakala, na vachilongosi vakuvakita vandu avo kuvya vavi. ");
INSERT INTO xnj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambu kwinu yikotoka kuvya genago, nambu mweigana kuvya mkulu pagati yinu yikumgana avyai muhengaji winu, ");
INSERT INTO xnj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na yeyoha mweigana kuvya wa kutumbula pagati yinu, yikumgana avyai mtumisi winu. ");
INSERT INTO xnj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ndava muni Mwana wa Mundu nakubwela kuhengewa, nambu kuvahengela na kuwusa wumi waki ndava ya kuvagombola vandu vamahele.” ");
INSERT INTO xnj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na vawuliwa vaki pavawuyayi ku Yeliko msambi uvaha wa vandu vamlandili. ");
INSERT INTO xnj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ndi vangalola vavili vevatamili pamuhana ya njila, pevayuwini kuvya Yesu ibwela na njila yeniyo, vakajova kwa lwami luvaha, “Bambu, Mwana wa Daudi utihengela lipyana.” ");
INSERT INTO xnj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Msambi wa vandu wula wavahakalili na kuvajovela vagunai. Nambu vene vakayonjokesa kujova kwa lwami luvaha, “Bambu, Mwana wa Daudi utihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu akayima akavakemela na kuvakota, “Wu, mwigana nivahengela kyani?” ");
INSERT INTO xnj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Vakamyangula, “Bambu, tigana kulola.” ");
INSERT INTO xnj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Hinu Yesu avahengili lipyana, ndi akavapamisa mumihu gavi, ndi bahapo vakahotola kulola, vakamulanda. ");
INSERT INTO xnj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na vawuliwa vaki pavahegelili, ku Yelusalemu na kuhika Betifage kuchitumbi cha Mizeituni ndi akavatuma vawuliwa vaki vavili, ");
INSERT INTO xnj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akavajovela, “Muhamba pachijiji cha palongolo yinu yati mwikolela lipunda na mwana waki vakungiwi, muvawopola muniletelayi nene. ");
INSERT INTO xnj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ngati mundu akavakota chochoha, mumjovela, ‘Bambu akumgana,’ Bahapo yati akuvalekela.” ");
INSERT INTO xnj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mambu ago gahengiki muni malovi geajovili Mlota wa Chapanga gatimilayi, ");
INSERT INTO xnj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ujovela muji wa Siyoni, Lola, Nkosi waku akukubwelela! Mngolongondi na akweli panani ya lipunda, mwana wa lipunda hinyama yeyigega ndwika.” ");
INSERT INTO xnj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mewa vawuliwa vaki vakahamba na kukita ngati chevalagaziwi na Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Vamletili lipunda na mwana waki, vakavayambatisa nyula panani yavi, na Yesu akatama panani yaki. ");
INSERT INTO xnj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Msambi uvaha wa vandu vadandisi nyula zavi munjila na vangi vadumwili matutu ga mikongo na kudandasa munjila. ");
INSERT INTO xnj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Msambi wa vandu vevamlongolili na vevamulandili vala vakajova kwa lwami luvaha. “Ulumbiwa Mwana wa Daudi! Amotisiwa mwenuyo mweibwela paliina la Bambu! Chapanga alumbiwa kunani!” ");
INSERT INTO xnj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu peavi mukuyingila ku Yelusalemu, muji woha wakenyemwiki. Vandu vakotanayi, “Mwenuyu ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Vandu vangi pagati ya msambi wula vakayangula, “Mwenuyu ndi Yesu mlota wa Chapanga, kuhuma ku Nazaleti muji wa Galilaya.” ");
INSERT INTO xnj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ayingili paluvanja lwa Nyumba ya Chapanga na kuvavinga vandu voha, vevagulisa na kugula vindu pala, azing'anambwisi meza za vabadilisha mashonga. Pamonga na vigoda vya vagulisa ngunda. ");
INSERT INTO xnj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akavajovela “Yiyandikwi mu Mayandiku Gamsopi, ‘Nyumba yangu yati yikemiwa nyumba ya kumyupila Chapanga.’ Nambu nyenye muyikitili kuvya libokoselu la vanyagaji.” ");
INSERT INTO xnj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vangalola na vachindamile vamhambili Yesu pa Nyumba ya Chapanga, mwene avalamisi. ");
INSERT INTO xnj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nambu Vamteta vakulu va Chapanga na vawula va malagizu vamemili ligoga ndava ya kulola mambu gabwina geahengili Yesu, mewa vana vevajovayi kwa lwami luvaha mu Nyumba ya Chapanga, “Ulumbiwa Mwana wa Daudi.” ");
INSERT INTO xnj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Vakamjovela, “Wu, wiyuwana vana ava chevijova?” Yesu akavayangula, “Ena, niyuwana! Wu, mwangasoma mu Mayandiku Gamsopi? Mumilomo ya vana vadebe na vang'enya ndi ujipatili ulumba kamili.” ");
INSERT INTO xnj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kangi Yesu akavaleka, akawuka pamuji wenuwo, akahamba ku Betania akagona kwenuko. ");
INSERT INTO xnj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chilau yaki lukela Yesu peavi mukuwuya kumuji wenuwo, njala yamvinili. ");
INSERT INTO xnj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Auwene mkongo wa mtini mumuhana ya njila, ndi auhambalili, nambu akolili lepi chindu mumkongo wula nga mahamba gene, ndi aupeli likoto akaujovela gakotoka kupambika matunda kutumbula lelu hati magono goha! Bahapo mkongo wula wanyalili. ");
INSERT INTO xnj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Vawuliwa pavauweni vakakangaswa na lijambu lenilo vakajova, “Ndava kyani mkongo wa mtini unyalili chighafula?” ");
INSERT INTO xnj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu akavayangula, “Nikuvajovela chakaka, ngati mwisadika changali mtahu, yati mwihotola lepi ndu kuhenga ago, nambu hati kuchijovela chitumbi, ‘Utupuka apa, na ukujitaga munyanja,’ Yati yivya mewa. ");
INSERT INTO xnj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na chochoha chemwiyupa kwa kumuyupa Chapanga, mwakasadika yati mwipata.” ");
INSERT INTO xnj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ayingili mu Nyumba ya Chapanga kuwula, hinu peavi mukuwula. Vamteta vakulu na vagogo va vandu vamkotili “Wihenga mambu genago kwa uhotola woki? Ndi yani mweakupeli uhotola wenuwo?” ");
INSERT INTO xnj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akavayangula, “Nene yati nikuvakota likotesi limonga, na ngati muniyangwili ndi nene yati nikuvajovela nihenga mambu aga kwa uhotola woki. ");
INSERT INTO xnj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wu, uhotola wa Yohani Mbatizaji wahumili koki? Wu, wahumili kunani kwa Chapanga amala wahumili kwa vandu?” Nambu vakajovesana vene kwa vene, “Tikajova, ‘Wahumili kunani kwa Chapanga? Yati akutikota, ndava kyani nakusadika?’ ");
INSERT INTO xnj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na ngati tijovili, gahumili kwa vandu, tiyogopa msambi wa vandu muni voha viyidakila kuvya Yohani ndi mlota wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hinu vamyangwili, “Nakumanya!” Namwene Yesu akavajovela na nene nikuvajovela lepi, nihenga mambu aga kwa uhotola woki. ");
INSERT INTO xnj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nyenye mwihololela wuli, mundu mmonga avili na vasongolo vavili. Akatumbula kumjovela yula wa kutumbula, mwana vangu lelu uhamba kumgunda wangu wa mizabibu ukahenga lihengu. ");
INSERT INTO xnj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Msongolo yula akamyangula, ‘Mbwitu,’ Nambu mwanakandahi ang'anamwisi maholo gaki, akahamba kuhenga lihengu. ");
INSERT INTO xnj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yula dadi akamjovela mwana wa pili galagala. Namwene akayidakila ena Dadi, Nambu nakuhamba. ");
INSERT INTO xnj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wu, yani pagati ya vavili venavo mweahengili maganu ga dadi waki?” Vakamyangula, “Mwana wa utumbula yula.” Hinu, Yesu akavajovela, “Nikuvajovela chakaka vatola kodi na vakemi yati vakuvalongolela kuyingila muunkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Muni Yohani abwelili kwinu na kuvalangisa njila ya kumganisa Chapanga, nyenye nakuyisadika, nambu vatola kodi na vakemi vamsadiki. Hati pamonga na kugalola genago goha, nambu nyenye nakumuwuyila Chapanga na kumsadika. ");
INSERT INTO xnj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu akajova, “Myuwana luhumu lungi,” Mundu mmonga mkolo nyumba alimili mgunda wa mizabibu, akatindisila luwumba, na kugima chiliva cha kuminyila divayi na akajenga mnala. Kangi avakodisi valimaji, akahamba mulima wa kutali. ");
INSERT INTO xnj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lukumbi lwa kubena pwalahikili, ndi avatumili vatumisi vaki kwa valimaji vala, muni vakatola lilundu laki la mabenu. ");
INSERT INTO xnj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nambu valimaji vala vavakamwili vatumisi venavo, mmonga vakamtova na yungi vakamkoma, na yungi vakamtova na maganga. ");
INSERT INTO xnj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kangi mkolo mgunda akavatuma vatumisi vangi vamahele neju kuliku vala va kutumbula. Hinu valimajii vala vakavahengela mewawa. ");
INSERT INTO xnj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pamwishu ndi amtumili mwana waki, muni aholalili kuvya. Chakaka yati vakumutopesa mwana vangu. ");
INSERT INTO xnj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambu valimaji vala pevamuwene mwana waki, vakajovesana vene kwa vene, mwenuyu ndi mhali waki, timkoma muni mgunda wenuwu tihala tete! ");
INSERT INTO xnj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hinu, vakamkamula na kumtaga kuvala ya mgunda wa mizabibu, ndi vakamkoma. ");
INSERT INTO xnj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kangi Yesu akavakota “Hinu mkolo mgunda wa mizabibu paibwela yati akuvakita kyani valimaji vala?” ");
INSERT INTO xnj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Vene vakamyangula, yati akuvakoma valimaji venavo na mgunda wula yati akuvapela valimaji vangi vevakumpela lilundu laki la mabenu lukumbi lwa kubena.” ");
INSERT INTO xnj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu akavajovela, “Wu, mwangasoma mu Mayandiku Gamsopi?” Liganga levabeli vakujenga, hinu ndi liganga likulu la kukamulila nyumba Bambu ndi mweahengili lijambu lenili, ndi la kukangasa neju kwitu! ");
INSERT INTO xnj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndava muni nikuvajovela, “Unkosi wa Chapanga yati uwusiwa kwinu na yati vipewa vandu va mulima wungi vala vevihenga gegakumganisa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yeyoha mweigwilila paliganga lenilo yati idenyekana hipandi hipandi na yeyoha mwelikumgwilila yati likumuyaga nyiminyimi. ");
INSERT INTO xnj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ndi vamteta vakulu na Vafalisayu pevayuwini miluhumu ya Yesu ndi vamanyalili kuvya akuvajova vene. ");
INSERT INTO xnj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Vene pevalondili njila ya kumkamula, vayogwipi msambi wa vandu muni vene vammanyili kuvya mwene ndi mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ajovili nawu kavili kwa miluhumu, akajova. ");
INSERT INTO xnj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Unkosi wa kunani kwa Chapanga uwanangini na nkosi mweamtendelekili mwana waki mselebuko wa ndowa. ");
INSERT INTO xnj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Avatumili vatumisi kuvakemela veavagongolili kundowa, nambu vene vabeli kubwela. ");
INSERT INTO xnj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kangi avatumili vatumisi vangi, akajova muvajovela venivagongolili vala, Mselebuko wula nimali kutendelekela, nimali kuhinja ng'ombi yigosi na mpapakasi yeyikulupili, nitendelekili kila chindu, mbwela kundowa! ");
INSERT INTO xnj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambu vevagongoliwi valitopisi lepi lijambu lila, vakahambanila, mmonga kumgunda waki na yungi kumahengu gaki, ");
INSERT INTO xnj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na vangi vavakamwili vatumisi vala vakavaliga na kuvakoma. ");
INSERT INTO xnj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nkosi yula akayoma, ndi akavatuma manjolinjoli vaki vahamba kuvakomekesa vakomaji venavo na kuyocha muji wavi ");
INSERT INTO xnj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kangi akavajovela vatumisi vaki, ‘Mselebuko wa ndowa ndi umali kutendekelewa, nambu venivagongolili vala nakuganikiwa kubwela. ");
INSERT INTO xnj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hinu, mhamba hati munjila, voha vemkuvakolela mvakemela vabwela kundowa.’ ");
INSERT INTO xnj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Vatumisi vala vakawuka na kuhamba munjila, vavakemela vandu voha vevavakolili, vandu vabwina na vahakau, nyumba ya ndowa yikamema vayehe.” ");
INSERT INTO xnj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nkosi avawene paayingili kuvalola vayehe, amuwene mundu mmonga mwaangawala nyula za ndowa. ");
INSERT INTO xnj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nkosi akamkota, ‘Nkozi uyingi wuli penapa changawala nyula za pandowa?’ Nambu mwene agunili. ");
INSERT INTO xnj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kangi nkosi akavajovela vahengaji, ‘Mumkunga magendelu na mawoko mumtaga kuvala kuchitita, kwenuko yati ivemba na kuyaga minu.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu akamalakisila kujova, “Vamahele vagongoliwi, nambu vevahaguliwi vadebe.” ");
INSERT INTO xnj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kangi Vafalisayu vakawuka, vakajovesana ndava ya kumuyonja Yesu kwa malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ndi vavatumili vamulanda vavi pamonga na vamulanda va chikundi cha Helodi. Vamkota, “Muwula,” “Timanyili kuvya veve ndi mundu wa chakaka, wiwula njila ya Chapanga muuchakaka, changayogopa vandu vijova kyani muni ulongosi wa mundu chindu lepi kwa veve. ");
INSERT INTO xnj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hinu tijovela, uholalela wuli? Wu, chabwina amala lepi, tete kulipa kodi kwa nkosi wa ku Loma ndi mewa ikemelewa Kaisali?” ");
INSERT INTO xnj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambu, Yesu amanyili uhakau wavi, akavajovela, “Nyenye vahomela ndava kyani mukunilinga? ");
INSERT INTO xnj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mnilangisa lishonga la kulipila kodi!” Vene vakamlangisa lishonga. ");
INSERT INTO xnj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ndi, Yesu akavakota, “Pamihu apa na liina lenili vyeviyandikwi penapa ndi vya yani?” ");
INSERT INTO xnj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Vakamyangula “Ya nkosi wa ku Loma.” Penapo Yesu akavajovela, “Hinu mumpela nkosi wa ku Loma vyaki nkosi wa ku Loma na mumpela Chapanga vyaki Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pevayuwini genago vakakangasa, vakamleka vakawuka. ");
INSERT INTO xnj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ligono lenilo pagati ya Vasadukayu vangi vevijova vandu vevafwili viyuka lepi, vamhambalili Yesu na kumkota, ");
INSERT INTO xnj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","vakamjovela “Muwula, Musa atijovili mundu mweagegili afwili changaleka vana, yikumgana mlongo waki amhala lipwela mwenuyo, muni ambabakisila vana mlongo waki ");
INSERT INTO xnj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hinu pitu apa pavili na valongo saba. Mwaatumbwili kugega afwili changaleka vana, na mlongo waki amgegili lipwela mwenuyo. ");
INSERT INTO xnj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hinu yavi mewawa kwa valongo vangi wa pili na wa datu, mbaka voha saba. ");
INSERT INTO xnj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pavamali kufwa valongo venavo voha, ndi na mdala yula afwili. ");
INSERT INTO xnj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wu, pa ligono la kuyuka yati ivya mdala wa yani pagati ya valongo vala? Muni voha saba vagegini nayu.” ");
INSERT INTO xnj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu akavayangula “Nyenye mubudili ndava muni nakumanya Mayandiku Gamsopi wala makakala ga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Muni vevafwili paviyuka yati vigega lepi wala kugegewa, ndi vivya ngati vamitumu va kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nambu ndava ya kuyuka kwa vevafwili, wu, mwangasoma geavajovili Chapanga? Avajovili, ");
INSERT INTO xnj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nene ndi Chapanga wa Ibulahimu, Chapanga wa Izaki na Chapanga wa Yakobo.’ Hinu mwene ndi lepi Chapanga wa vevafwili, nambu ndi Chapanga wa vakona wumi.” ");
INSERT INTO xnj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Msambi wa vandu wula pevayuwini malovi ago, ukakangasa ndava ya mawuliwu gaki. ");
INSERT INTO xnj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Vafalisayu pevayuwini kuvya Yesu avagunisi Vasadukayu, vakakonganeka pamonga. ");
INSERT INTO xnj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mmonga pagati yavi, mweavimmanya malagizu bwina, amkotili Yesu cha kumlinga, ");
INSERT INTO xnj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Muwula ndi muhilu woki ukulu mu malagizu?” ");
INSERT INTO xnj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akayangula, “‘Mgana Bambu Chapanga waku, mumtima waku woha, mumpungu waku woha na muluhala lwaku lwoha.’ ");
INSERT INTO xnj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yeniyi ndi muhilu ukulu ndi wa kutumbukana. ");
INSERT INTO xnj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ya pili yeyiwanangana na yeniyi, ‘Ndi mgana muyaku ngati chaukujigana wamwene.’ ");
INSERT INTO xnj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagizu goha ga Musa na mawuliwu ga vamlota va Chapanga gihuvalila mihilu yeniyo yivili.” ");
INSERT INTO xnj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Vafalisayu pavakonganiki pamonga, Yesu avakotili, ");
INSERT INTO xnj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nyenye mwihololela wuli ndava ya Kilisitu? Mwana wa yani?” Vakamyangula “Mwene ndi mwana wa Daudi.” ");
INSERT INTO xnj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu, akavajovela, “Ndava kyani,” Kwa makakala ga Mpungu Msopi? Daudi akumkemela mwene Bambu? Muni ajovili, ");
INSERT INTO xnj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bambu amjovili Bambu wangu, tama muchiwoko changu cha kulyelela, mbaka nivavika vamakoko vaku kuvya pahi ya magendelu gaku. ");
INSERT INTO xnj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hinu, ngati Daudi akumkemela, Kilisitu Bambu, yihotoleka wuli kuvya mwana waki? ");
INSERT INTO xnj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Avi lepi mundu mweahotwili kumyangula lilovi. Kutumbula ligono lenilo kawaka mundu mwalingili kumkota kangi. ");
INSERT INTO xnj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kangi Yesu akaujovela msambi wa vandu pamonga na vawuliwa vaki, ");
INSERT INTO xnj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Vawula va malagizu na Vafalisayu ndi vevavi na uhotola wa kudandaula malagizu ga Musa. ");
INSERT INTO xnj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hinu mugakamula na kugalanda malovi goha gevakuvajovela, nambu mkoto kuyigila matendu gavi, muni vene vihenga lepi gala gevikokosa. ");
INSERT INTO xnj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Vene vikunga ndwika yeyitopa na kuvagegesa vandu mumavega gavi, kuni vene vaganili lepi hati kutalambula lungonji kutangatila kugega. ");
INSERT INTO xnj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vene vihenga kila chindu, ndava kulolekana na vandu, viwala vindu vivaha vyeviyandikiwi malagizu pamihu gavi na mumawoko na kutalambula lugunyilu lwa nyula zavi. ");
INSERT INTO xnj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vigana kutama muvigoda vya palongolo pa mselebuko, na muvigoda vya kulongolo munyumba za kukonganekela Vayawudi, ");
INSERT INTO xnj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","mewawa vigana kujambuswa cha kutopeswa pandu pa kugulisila na kugula vindu na kukemelewa, ‘Muwula.’ ");
INSERT INTO xnj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambu nyenye mkoto kuyidakila kukemelewa ‘Muwula,’ Ndava muni mwavoha nyenye mwavalukolo na Muwula winu ndi mmonga. ");
INSERT INTO xnj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mewa mkoto kumkemela mundu yeyoha pamulima apa dadi, muni Dadi winu ndi mmonga ndu mweavi kunani. ");
INSERT INTO xnj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mkoto kuyidakila kukemelewa vachilongosi, muni chilongosi winu ndi mmonga ndu, ndi Kilisitu Msangula. ");
INSERT INTO xnj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mweavi mvaha pagati yinu yikumgana avyai muhengaji winu. ");
INSERT INTO xnj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na yeyoha mweakujikwiha yati iheleswa, na mweakujihelesa yati ikwihiwa.” ");
INSERT INTO xnj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mwalachikolela nyenye vawula va malagizu ga Chapanga geampeli Musa na Vafalisayu! Mukujikita vabwina! Mwidinda mlyangu wa unkosi wa kunani kwa Chapanga palongolo ya mihu ga vandu, mwavene mwiyingila lepi mugati na kuni mukuvayidakila lepi vevigana kuyingila vayingila. ");
INSERT INTO xnj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mwalachikolela nyenye, vawula va malagizu na Vafalisayu, mukujikita vabwina! Ndava muni mwinyaga vindu vya valipwela na kujilangisa kuvya vandu mwemkumganisa Chapanga, kwa kumuyupa Chapanga mulukumbi lutali, ndava yeniyo uhamula winu yati yivya yivaha neju.” ");
INSERT INTO xnj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mwalachikolela nyenye vawula va malagizu ga Bambu geampeli Musa na Vafalisayu, mukujikita vabwina! Muvi mulugendu munyanja na mundumba, muni mwilonda mundu mmonga alanda njila yinu ya kumuyupa Chapanga. Pemukumpata mukumkita iganikiwa neju kuhamba mumotu wa magono goha wangajimika kuliku mwavene. ");
INSERT INTO xnj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mwalachikolela nyenye vilongosi vangalola! Mwemwijova ngati mundu alapili mu Nyumba ya Chapanga chindu lepi, nambu mundu akalapa kwa zahabu yeyivii mu Nyumba ya Chapanga, ndi chilapu chenicho chikumukamula. ");
INSERT INTO xnj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nyenye mwangalola vayimu! Choki chivaha neju, zahabu amala Nyumba ya Chapanga yeyikuinyambisa zahabu kuvya msopi? ");
INSERT INTO xnj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mwijova kavili mewawa kuvya mundu akalapa pa lusanja lwa luteta ndi chindu lepi, nambu mundu akalapai na luteta lweluvikiwi panani ya lusanja lwenulo ndi chilapu chenicho chikumukamula. ");
INSERT INTO xnj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwangalola nyenye! Choki chivaha neju luteta amala lusanja lwa luteta yeyikita njombi kuvya ya msopi? ");
INSERT INTO xnj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hinu, mundu mweilapa mulusanja lwa luteta, alapili pa lusanja lwa luteta na vindu vyoha vyevivi panani yaki. ");
INSERT INTO xnj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mewawa na mweilapa kwa Nyumba ya Chapanga alapili kwa yeniyo na mwenuyo mwaitama mugati yaki. ");
INSERT INTO xnj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na mweilapa kwa liina la kunani kwa Chapanga, alapili pachigoda cha unkosi wa Chapanga, na kwa mwene mweitama pachigoda chenicho. ");
INSERT INTO xnj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mwalachikolela nyenye vawula va Malagizu na Vafalisayu. Mwavahomela! Mukuvawusa vandu lilundu limonga pagati ya kumi hati panani ya manyahi geginungalila bwina, bizali na ndimbililu, kuni mwileka mambu gavaha ga malagizu ngati kumganisa Chapanga lipyana na sadika. Genago ndi ngamlongolili kuhenga changali kuleka gangi gala. ");
INSERT INTO xnj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vachilongosi ngalola mwiwusa livembe muminyweso, kuni mwimila hinyama yeyikemelewa ngamiya! ");
INSERT INTO xnj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mwalachikolela nyenye vawula va malagizu na Vafalisayu, mwavahomela! Mwisanja chikombi na nkeve cha kuvala, kuni muleka mugati mumemili vindu vyemupatili kwa uhiji na kunota. ");
INSERT INTO xnj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Veve Mfalisayu ngalola! Tumbula hoti kusanja chikombi na nkele mugati na kuvala yati kwinyamba mewa. ");
INSERT INTO xnj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mwalachikolela nyenye, Vawula va malagizu na Vafalisayu, mwemukujikita vabwina! Mwiwanangana ngati matinda gevabakili chokaa gegiloleka kuvala ganyambili, nambu mugati gamemili majege ga mituhi ya vandu vevafwili kwa uhakasa ndalindali. ");
INSERT INTO xnj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mewawa nyenye chakuvala mwiloleka ngati vandu vevakumganisa Chapanga, nambu mugati mumemili uhomela na uhakau.” ");
INSERT INTO xnj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mwalachikolela nyenye vawula va malagizu na Vafalisayu, mwavahomela! Mwijenga matinda ga vamlota va Chapanga na kunyambisa matinda ga vandu vevamganisi Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndi mwijova, ‘Kuvya mutama lusenje lwa vagogo vinu tihanganili lepi nawu, kuvakoma vamlota va Chapanga!’ ");
INSERT INTO xnj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hinu, mwavene mukujilangisa kuvya nyenye ndi vana va vandu vala, vevavakomili vamlota va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hinu mumalakisa lihengu levatumbwili vagogo vinu! ");
INSERT INTO xnj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nyenye mayoka chiveleku cha mayoka! Yani mweakuvajovela muhotola kutila ligono la uhamula wa Chapanga? ");
INSERT INTO xnj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndava yeniyo nikuvapelekela vamlota va Chapanga, na vandu vevana luhala na vawula va malagizu, vangi pagati yavi yati mukuvakoma na kuvavamba mu msalaba na vangi yati mukuvatova ndonga munyumba zinu za kukonganekela Vayawudi, na vangi yati mukuvajumbisa kuhuma muji umonga mbaka muji wungi. ");
INSERT INTO xnj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndi panani yinu mwigega ngasi ya vandu voha vevamganisi Chapanga yeyiyitiki pamulima. Kutumbula kukomiwa kwa Abeli mweangabuda mbaka Zakalia, mwana wa Balakia, mwemwamkomili mu Nyumba ya Chapanga pagati ya pandu pamsopi pa lusanja lwa luteta. ");
INSERT INTO xnj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nikuvajovela chakaka, chiveleku ichi yati chihamuliwa ndava ya mambu genago.” ");
INSERT INTO xnj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu! Veve Yelusalemu ukuvakoma vamlota va Chapanga na kuvatova maganga vala venivatumili kwa veve! Mala yilinga niganilli kuvavika pamonga vana vaku, ngati ng'uku cheyikuvayuvatila vana mumagwaba gaki, nambu mwaganili lepi! ");
INSERT INTO xnj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lola, Nyumba ya Chapanga waku yati yisigalila mang'ova. ");
INSERT INTO xnj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Muni nikuvajovela kutumbula hinu yati nakunilola kavili mbaka mulukumbi pemwijova, ‘Amotisiwa mwenuyo mweibwela kwa liina la Bambu.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu awukili mu Nyumba ya Chapanga, peavi mukuhamba vawuliwa vaki vambwelili na kumlangisa Nyumba ya Chapanga cheyijengiwi. ");
INSERT INTO xnj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu akavajovela, “Ena, mwihotola kugalola goha aga! Nikuvajovela chakaka, kawaka hati liganga limonga lelisigilila panani ya liganga lingi kila limonga yati litagiwa pahi.” ");
INSERT INTO xnj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu peatamili panani ya chitumbi cha mizeituni, vawuliwa vamhambili pachiepela, vakamkota, “Utijovela mambu ago yati gihumila ndali?” Ulangisu woki weulangisa kubwela kwaki na pamwishu wa mulima? ");
INSERT INTO xnj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu akavayangula, mujiyangalila mundu akotoka kuvakonga. ");
INSERT INTO xnj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ndava muni vamahele yati vibwela kwa liina langu, yati vijova nene ndi Kilisitu Msangula! Na kuvakonga vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nambu mwiyuwana malovi ga ngondo na lwami lwa ngondo, nambu mkoto kuyogopa, muni genago goha giganikiwa kuhumila, nambu mwishu wene wakona. ");
INSERT INTO xnj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vandu va mulima umonga yati vitovana na mulima wungi, unkosi umonga yati utovana na unkosi wungi. Kuni na kula yati kwivya na njala na mindendemo ya ndima. ");
INSERT INTO xnj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Genago goha yati givya ngati utumbula wa lipyanda la kuvelekewa mwana. ");
INSERT INTO xnj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kangi yati vakuvagotola mung'aiswa na kukomiwa. Yati mwivya vandu va kuyomewa na vandu va milima yoha ndava ya kunisadika nene. ");
INSERT INTO xnj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lukumbi lwenulo vamahele yati vakuyileka sadika yavi kung'anamukilana na kuyomelana. ");
INSERT INTO xnj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yati vihumila vamlota va udese vamahele yati vakuvakonga vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndava ya kuyonjokeseka neju uhakau ndi uganu wa vandu vamahele yati wipungula. ");
INSERT INTO xnj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambu mweisindimala mbaka pamwishu ndi mweisanguliwa. ");
INSERT INTO xnj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lilovi la Bwina yati likokoselewa pamilima yoha muni vandu voha vayuwanayi kwakona mwishu kuhika.” ");
INSERT INTO xnj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hinu pemwilola ‘Chindu chechiyomesa’ Chechijoviwi na Danieli mweavi mlota wa Chapanga liyimili pandu Pamsopi pa Nyumba ya Chapanga,” Mweisoma na amanyai, ");
INSERT INTO xnj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","penapo ndi vevavi ku Yudea vajumbalila kuchitumbi. ");
INSERT INTO xnj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mweavi kunani ya nyumba yaki akotoka kuhuluka kutola chindu munyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na mundu mweavikumgunda akotoka kuwuya mumbele, kutola nyula yaki. ");
INSERT INTO xnj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lukumbi lwenulo vamau mwemuvi na ndumbu na mwemunyong'esa yati mwing'aika neju! ");
INSERT INTO xnj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ndi mumuyupayi Chapanga kutila kwinu kukotoka kuvya mu ligono la mbepu amala Ligono la Kupumulila! ");
INSERT INTO xnj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ndava muni lukumbi lwenulo yati kwivya na mang'ahiso gakulu gangahumila kuhuma kutumbula kwa mulima mbaka lelu, katu yihumila lepi kavili. ");
INSERT INTO xnj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngati magono genago yagapungwizwi lepi, kawaka mundu mweasanguliwi, nambu ndava ya vevahaguliwi vala ndi magono genago gapungwizi. ");
INSERT INTO xnj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Hinu, magono genago mundu akavajovela, ‘Lola, Kilisitu Msangula!’ ‘Avi apa amala avi pala!’ Mkoto kusadika. ");
INSERT INTO xnj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Muni yati vihumila vakina Kilisitu vangi va udese na vamlota va udese. Yati vihenga ulangisu uvaha na gachinamtiti muni vavakonga yikahotoleka hati vevahaguliwi na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Myuwanila, nimali kuvajovela, kwakona lukumbi kubwela.” ");
INSERT INTO xnj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hinu ngati vakavajovelai mlola Kilisitu Msangula, avi kulugangatu, mkotoka kuhamba, amala mlola ajifiyili mugati, mkoto kusadika, ");
INSERT INTO xnj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndava kubwela kwa Mwana wa Mundu yati kulolekana ngati lumuli lwa mbamba chelumweta kuhuma kwe lihumila lilanga mbaka kwe litipama lilanga. ");
INSERT INTO xnj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pala peuvi mtuhi ndi pagikonganeka manditi.” ");
INSERT INTO xnj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bahapo pegimalika mang'ahiso ga magono ago, lilanga yati lisopiwa chitita, mwehi lwalava lepi na lumuli, ndondo yati zigwa kuhumila kunani kumahundi, na makakala vindu vevivi kunani yati vinyugusika. ");
INSERT INTO xnj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kangi, ulangisu wa Mwana wa Mundu yati yiwonekana kunani, ndi penapo makabila goha ga pamulima apa yati givembeneka kumuyupa Chapanga, yati vakumlola Mwana wa Mundu ibwela kuhuma kunani ku mahundi avi na makakala na ukulu neju. ");
INSERT INTO xnj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lwami luvaha lwa lipenenga yati luyuwanika, mwene akuvatuma vamitumu vaki va kunani kwa Chapanga na kuhamba kuvakemela vala voha vevahaguliwi na Chapanga, kuhuma pandi zoha mcheche za mulima, kuhuma mwishu umonga wa pamulima mbaka mwishu uwu wungi.” ");
INSERT INTO xnj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mujiwula kuhuma mkongo wa mtini, bahapo limbanda laki lakatumbula kumela na kuhomola mahamba, mwimanya kuvya lukumbi lwa kubena luvi papipi. ");
INSERT INTO xnj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mewawa na nyenye pemwilola mambu genago goha chegihumila, mumanya kuvya lukumbi luvi papipi. ");
INSERT INTO xnj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Chakaka nikuvajovela, chiveleku chenichi chipita lepi kwakona mambu genago kuhumila. ");
INSERT INTO xnj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunani kwa Chapanga na pamulima yati ziwuka, nambu malovi gangu katu giwuka lepi.” ");
INSERT INTO xnj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambu kulivala ligono amala lisaa lenilo, avi lepi mundu mwaimanya lubwela ndali, hati vamitumu va kunani amala Mwana. Nga Dadi mwene ndi mweimanya. ");
INSERT INTO xnj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ndava muni ngati chayavi lusenje lwa Nuhu, ndi mewawa cheyivya peibwela Mwana wa Mundu. ");
INSERT INTO xnj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muni lusenje lwenulo kwakona kutonya fula yikulu, vandu vakalilya na kunywa, na vigega na kugegewa, mbaka lukumbi Nuhu peayingili muwatu uvaha weukemiwa Safina. ");
INSERT INTO xnj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Vamanyili lepi chechahumila mbaka fula yikulu payabweli na kuvayola voha. Ndi yivya mewawa paibwela Mwana wa Mundu. ");
INSERT INTO xnj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lukumbi lwenulo vandu vavili yati vivya kumgunda mmonga yati itoliwa na yungi yati ilekewa. ");
INSERT INTO xnj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vamau vavili yati vivya mukuyaga mabenu, mmonga yati itoliwa na yungi ilekewa. ");
INSERT INTO xnj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hinu, mujiyangalila! Ndava muni mmanyi lepi ligono la kubwela Bambu winu. ");
INSERT INTO xnj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nambu mumanya lijambu lenili, ngati mkolo nyumba kuvya amanyai ligono leibwela mhiji, ngaajitendekili, ngaayileki lepi nyumba yaki yidenyewayi na mhiji. ");
INSERT INTO xnj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndava yeniyo, mewawa nyenye mujitendelekela, muni Mwana wa Mundu yati ibwela lisaa mwangalimanya.” ");
INSERT INTO xnj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu akayendelela kujova, “Wu, yani ndi mtumisi msadikika na mweavi na luhala? Mkulu waki amuvikii kuvayimalila vatumisi vayaki, avapela chakulya pa lukumbi lwaki. ");
INSERT INTO xnj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ahekayi mtumisi yula, mkulu waki akawuya yati akumkolela ihenga mewa. ");
INSERT INTO xnj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nikuvajovela chakaka, mkulu waki yati akumvika mtumisi mwenuyo kuvya myimilila wa vindu vyaki vyoha. ");
INSERT INTO xnj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambu ngati mtumisi yula mhakau akahololela mumtima waki kuvya mkulu waki ichelewa kuwuya, ");
INSERT INTO xnj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kangi itumbula kuvatova vatumisi na kutumbula kulya na kunywa pamonga na vachigaligali. ");
INSERT INTO xnj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mkulu waki yati iwuya ligono angalimanya na lisaa angahololela. ");
INSERT INTO xnj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mkulu waki yati akumdumulana neju hipandi na kumvika lilundu limonga na la vandu vevakujikita vabwina kwenuko ndi yati ivemba na kuyaga minu.” ");
INSERT INTO xnj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kangi lukumbi lwenulo, Unkosi wa kunani kwa Chapanga uwanangana na vakamwali kumi vevagegili hahi zavi, vevahambili kumlindila mkolo ndowa. ");
INSERT INTO xnj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mhanu pagati yavi vavi vayimu na mhanu vangi vavi na luhala. ");
INSERT INTO xnj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Vala vayimu vagegii hahi zavi, nambu vagegili lepi mahuta gangi gachibana. ");
INSERT INTO xnj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nambu vevavi na luhala vala vagegili mahuta muchupa na mu hahi zavi. ");
INSERT INTO xnj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ndava muni mkolo ndowa acheliwi kubwela, ndi vasikana vala vatumbwili kutitila na vakagona. ");
INSERT INTO xnj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pagati ya kilu lwami luvaha lwayuwaniki, ‘Yumuka, mkolo ndowa ibwela mhamba mukampokela!’ ");
INSERT INTO xnj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kangi vakamwali vala voha vakayumuka, na kutendelekela hahi zavi. ");
INSERT INTO xnj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vayimu vala vakavajovela vayavi vevavi na luhala, mutitangatila mahuta ginu padebe, ndava muni hahi zitu zijimika. ");
INSERT INTO xnj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambu vevavi na luhala vala vakavayangula, lepi, ‘Gikola lepi, nyenye na tete.’ ‘Mbanga mhamba kuliduka mukajigulila mwavene.’ ");
INSERT INTO xnj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hinu, vakamwali vayimu vala, pevahambili kugula mahuta, mkolo ndowa ndi abwelili, vevajitendelekili vala vayingili munyumba ya ndowa pamonga nayu, kangi mlyangu wadindiwi.” ");
INSERT INTO xnj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mwanakandahi vakawuya vakamwali vangi vala, vakakemela “Mkulu, ‘Mkulu, tidindulila!’ ");
INSERT INTO xnj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nambu mkulu yula akavayangula, ‘Nikuvajovela chakaka, nakuvamanya nyenye.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kangi Yesu akavajovela, “Mujiyangalila! Ndava mwimanya lepi ligono amala lisaa yeibwela Mwana wa Mundu.” ");
INSERT INTO xnj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kangi Unkosi wa kunani kwa Chapanga uwanangana ngati mundu mmonga mweaganili kuhamba lugendu lwa kutali, avakemili vatumisi vaki na kuvagotolela vindu vyaki. ");
INSERT INTO xnj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akavapela kila mundu ngati cheavi na uhotola waki, mmonga mahaku mhanu ga mashonga na yungi mahaku gavili ga mashonga na yungi talanta yimonga ya mashonga akahamba. ");
INSERT INTO xnj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yula mweagotoliwi talanta mhanu za mashonga, bahapo akazihengela lihengu na, kuziyonjokesa mahaku gangi mhanu. ");
INSERT INTO xnj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mewawa yungi mweagotoliwi mahaku gavili ga mashonga, akayonjokesa mahaku gangi gavili. ");
INSERT INTO xnj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambu mtumisi mweagotoliwi talanta yimonga ya lishonga akahamba kugimila pahi, kuyifiya mashonga ga mkulu waki.” ");
INSERT INTO xnj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pagamaliki magono gamahele, mkulu yula awuyili na kutumbula kuvalanga vindu mashonga gaki pamonga nawu. ");
INSERT INTO xnj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yula mtumisi mweagotoliwi mahaku mhanu ga mashonga abwelili kuni agegili mahaku ga mashonga gangi mhanu, ndi akamjovela, ‘Mkulu, wanipeli talanta mashonga mhanu, hinu niyonjokisi talanta zingi mhanu zeniyonjokisi.’ ");
INSERT INTO xnj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mkulu waki, akamjovela ‘Uhengili chabwina, mtumisi msadikika na mbwina.’ Usadikiwi mu mambu gadebe yati nikugotolela mambu gavaha. Bwelayi uhekayi pamonga na mkulu waku!” ");
INSERT INTO xnj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kangi mtumisi yungi mweagotoliwi mahaku gavili ga mashonga, abwelili, na kujova, ‘Mkulu wanigotolili mahaku gavili ga mashonga, lola aga apa mahaku gangi gavili geayonjokisi.’ ");
INSERT INTO xnj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Mkulu waki akamjovela, chabwina, veve mtumisi msadikika na mbwina!’ ‘Ukitili chabwina mu mambu gadebe, yati nikugotolela mambu gavaha, bwelayi uhekayi pamonga na nene.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nambu yula mweagotoliwi talanta yimonga ya lishonga, abwelili akajova, ‘Mkulu nikumanyili veve wa mundu munonopo wibena pewangalima, na kutola pewangadandasa mbeyu. ");
INSERT INTO xnj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndi nayogwipi, nagimili pandima na kufiya lishonga laku. Hinu ndi utola yaku.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“‘Mkulu waki akamyangula veve mtumisi mhakau na mkata! Wimanya kuvya nene nibena panangagaba, na kuyola pala panangadandasa?’ ");
INSERT INTO xnj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ndi yakuganili uvika mashonga gangu kwa vandu vevibadilisha na kuwusa mashonga, ndi nene nganitoli chiyonjokesu na mashonga gangu! ");
INSERT INTO xnj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hinu mumnyaga mashonga genago, na mumpelayi yula mweavi na talanta kumi za mashonga. ");
INSERT INTO xnj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ndava, mundu yeyoha mweavi na chindu yati ipewa na kuyonjokesewa. Nambu yula angali chindu, hati chidebe cheavili nachu yati inyagiwa. ");
INSERT INTO xnj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mtumisi yula angali chiyonjokesu, mtaga kuvala kuchitita kwenuko ndi yati kuvya na luvembu na kuyaga minu.” ");
INSERT INTO xnj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lukumbi Mwana wa Mundu peibwela muukulu waki pamonga na vamitumu vaki va kunani kwa Chapanga, penapo yati itama panani ya chigoda cha unkosi chechivii na ukulu. ");
INSERT INTO xnj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Vandu va milima yoha yati vikonganeka pamonga palongolo yaki. Mwene ndi akuvapangula vandu ngati mdimaji cheipangula mambelele na mene. ");
INSERT INTO xnj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mwene yati ivika mambelele ndi vandu vabwina palongolo ya Chapanga muchiwoko chaki cha kulyela na mene ndi vandu vahakau muchiwoko chaki cha kumangeya.” ");
INSERT INTO xnj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kangi Nkosi akuvajovela vala vevavi upandi waki wa kulyela, mbwela, nyenye mwemumotisiwi na Dadi wangu! Mupokela unkosi wemuvikiwi kutumbula kuwumbwa kwa mulima. ");
INSERT INTO xnj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Muni penavi na njala mwanipeli chakulya, navi na njota mwanipeli manji, avi myehe mwanipokili panyumba yinu, ");
INSERT INTO xnj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","navi nangayatila mwaniwaliki, navi mtamu mwabweli kunilola, navi muchifungu mwanigendelili kunilola. ");
INSERT INTO xnj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Penapo vandu vabwina palongolo ya Chapanga yati vakamyangula ‘Bambu, takuwene ndali njala yikuvina petakupeli chakulya, amala uvi na njota tete takupeli manji? ");
INSERT INTO xnj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndali takuwene wa myehe ndi tete takupokili, amala wavi changayatila takuwaliki? ");
INSERT INTO xnj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ndali patakuwene una utamu amala muchifungu tabweli kukulola?’ ");
INSERT INTO xnj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nkosi yati akuvayangula, ‘Nikuvajovela chakaka, chindu chochoha chamumhengili mmonga wa valongo vangu vadebe ava, mwanihengili nene.’” ");
INSERT INTO xnj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kangi yati akuvajovela vala va upandi wa kumangeya, ‘Muwuka, palongolo yangu nyenye mwempewili likoto mhamba kumotu wangajimika wa magono goha gangali mwishu weutendelekiwi kwa Setani na vamitumu vaki. ");
INSERT INTO xnj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndava njala peyanivili nyenye mwanipeli lepi chakulya, penavi na njota nyenye mwanipeli lepi manji. ");
INSERT INTO xnj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Penavi myehe nyenye mwenipokili lepi, penavi changayatila nyenye mwaniwaliki lepi, penavi mtamu na penavi muchifungu nyenye mwabweli lepi kunilola.’” ");
INSERT INTO xnj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Penapo yati viyangula, ‘Bambu, ndali petakuwene njala yikuvina, amala uvi na njota amala myehe amala changayatila nyula amala mtamu amala muchifungu tete takuhengili lepi?’ ");
INSERT INTO xnj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bambu yati iyangula, ‘Nikuvajovela chakaka, chindu chochoha chamwabeli kumuhengela, mmonga wa vadebe ava, ndi mwabeli kunihengela nene.’ ");
INSERT INTO xnj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hinu, venava yati vihamba kumbunu wa magono goha, nambu vala vandu vabwina palongolo ya Chapanga yati vihamba kuwumi wa magono goha gangali mwishu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu peamalakisi kujova malovi genago, ndi akavajovela vawuliwa vaki, ");
INSERT INTO xnj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mumanyili kuvya gasigalili magono gavili, yati kwivya na mselebuko wa Pasaka, hinu Mwana wa Mundu yati igotolewa muni avambiwa na kufwa pamsalaba.” ");
INSERT INTO xnj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lukumbi lwenulo vakulu va kuteta na vawula va Malagizu vakonganiki pamonga muluvanja lwa mteta mkulu liina laki Kayafa. ");
INSERT INTO xnj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Vakajovesana ndava ya kumkamula Yesu kwa mfiyu na kumkoma. ");
INSERT INTO xnj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Vakajova, nambu tikotoka kuhenga lijambu lenili lukumbi lwa mselebuko wa pasaka, muni vandu vakotoka kuhenga chitututu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu peavi ku Betania, ku nyumba ya Simoni mweavi na mabudi, ");
INSERT INTO xnj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mau mmonga mweavi na kachupa ya alabasta kamahuta geginungalila bwina na ga mashonga gamahele, ambwelili na kumyitila pamutu Yesu peilya chakulya. ");
INSERT INTO xnj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hinu vawuliwa vaki pavagaweni genago vayomili, vakakota, “Luyagu lwenulo lwa kyani?” ");
INSERT INTO xnj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ndava mahuta ago geginungalila bwina ngagaguliswi kwa mashonga gamahele, na kuvapela vangangu mashonga ago!” ");
INSERT INTO xnj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu agamanyili maholo gavi, ndi akavajovela, “Ndava kyani mukumung'aha mau mwenuyu? Mwene anihengili lijambu labwina neju. ");
INSERT INTO xnj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndava muni yati mwivya na vangangu pamonga nawu magono goha, nambu nene yati nakuvya pamonga na nyenye magono goha. ");
INSERT INTO xnj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mau mwenuyu aniyitili mahuta geginungalila bwina ndava kunitendelekeha higa yangu kwa maziku. ");
INSERT INTO xnj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nikuvajovela chakaka, pamulima poha Lilovi la Bwina lenili pelikokoselewa, chitendu cheahengili mau uyu yati chiluwuliwa ndava ya kumkumbuka mwene.” ");
INSERT INTO xnj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kangi mmonga pagati ya vawuliwa vaki kumi na vavili vala mweikemiwa Yuda Isikalioti, akahamba kwa vakulu va kuteta, ");
INSERT INTO xnj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akavakota, “Yati mukunipela kyani ngati nivagotolili Yesu?” Vamvalangili hipandi selasini vya madini ga feza. ");
INSERT INTO xnj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kutumbula ligono lenilo Yuda akalonda nafwasi ya kumng'anamukila. ");
INSERT INTO xnj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ligono la kutumbula kwakona mselebuko wa mabumunda gangali ngemeku, ndi vawuliwa vamhambili Yesu vakamkota, “Wigana koki tikutendelekeha chakulya cha Pasaka?” ");
INSERT INTO xnj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mwene akavayangula, “Mhamba kumuji kwa mgosi mmonga na kumjovela,” Muwula ajovili, ligono laki lihegelili nene na vawuliwa vangu yati tilya chakulya cha Pasaka kwa veve. ");
INSERT INTO xnj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vawuliwa vakatendelekela ngati Yesu cheavalagizili vakatendelekela chakulya cha Pasaka. ");
INSERT INTO xnj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Palatipimi lilanga, Yesu atamili kulya chakulya pamonga na vawuliwa vaki voha kumi na vavili. ");
INSERT INTO xnj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pavavi mukulya, Yesu akavajovela, “Nikuvajovela chakaka mmonga winu yati akuning'anamukila.” ");
INSERT INTO xnj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vawuliwa vakavya vakaviniswa neju mtima, vakatumbula kukotana mmonga mmonga, “Bambu! Wu, ndi nene?” ");
INSERT INTO xnj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu akayangula “Mweijwiga libumunda munkeve pamonga na nene ndi mweakuning'anamukila. ");
INSERT INTO xnj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Mundu yati ifwa ngati chegijova Mayandiku Gamsopi, nambu alachikolela mundu yula mweamng'anamukila! Ngayivii mbanga mundu mwenuyo ngaavelekewi lepi.” ");
INSERT INTO xnj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda ndi mweamung'anamukili, akamkota “Muwula wu, ndi nene?” Yesu akayangula “Ujovili wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pevavi mukulya, Yesu akatola libumunda, akamsengusa Chapanga akayimetula, akavapela vawuliwa vaki akajova, “Mtola mlyayi, yeniyi ndi higa yangu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kangi akatola chikombi cha divayi, akamsengusa, akavapela akajova, “Mnywayi nyenye mwavoha, ");
INSERT INTO xnj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","muni yeniyi ndi ngasi yangu yeyilangisa lilaganu, yeyiyitika ndava kuvalekekesa vandu vamahele kumbudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nikuvajovela, ninywa lepi kavili divayi ya zabibu mbaka pa ligono peninywa ya mupya pamonga na nyenye mu Unkosi wa Dadi wangu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pavamali kuyimba lunyimbu lwa kumlumba Bambu, vakawuka na kuhamba kuchitumbi cha Mizeituni. ");
INSERT INTO xnj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kangi Yesu akavajovela, “Lelu kilu mwavoha nyenye yati mwitila na kunileka namwene, muni ndi chegijova Mayandiku Gamsopi, ‘Yati nikumkoma mdimaji, na msambi woha wa mambelele yati wipechengana.’ ");
INSERT INTO xnj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambu panakayukayi, yati nikuvalongolela ku Galilaya.” ");
INSERT INTO xnj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Penapo Petili akamyangula, “Hati ngati voha yati vakutila, nambu nene katu nikukuleka lepi.” ");
INSERT INTO xnj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu akamyangula Petili, “Nikujovela chakaka, kilu yiyiyi kwakona lijogolo kuvika yati ukunibela mala yidatu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petili akamjovela kavili, “Hati ngati yikunigana nifwayi pamonga na veve katu nikuleka lepi.” Na vala vawuliwa vangi vakajova mewawa. ");
INSERT INTO xnj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kangi Yesu na vawuliwa vaki vakahamba pamonga pandu pepikemelewa Gesemane, ndi akavajovela, “Mtama apa na nene nihamba pala kumuyupa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Avatolili Petili na vana vavili va Zebedayo, Yesu akatumbula kuviniswa mtima na man'gaiso. ");
INSERT INTO xnj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kangi akavajovela, “Niviniswa neju mumtima hati papipi kufwa. Mtama bahapa mkoto kugona pamonga na nene.” ");
INSERT INTO xnj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akahegelela palongolo, akagwa cha kukupama, akamuyupa Chapanga. “Dadi wangu, ngati yihotoleka chikombi ichi cha man'gaiso chiniyepa, nambu lepi chenigana nene, ndi ngati chaugana wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kangi akavawuyila vawuliwa vala, avakolili vavi lugono. Akamkota Petili, “Wu, nakuhotola kutama changagona pamonga na nene hati saa yimonga ndu? ");
INSERT INTO xnj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mkoto kugona mumyupa Chapanga mkoto kugwa mukulingiwa. Mpungu wigana nambu higa yitamu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu akahamba kavili, kumuyupa Chapanga, “Dadi wangu, ngati yihotoleka lepi chikombi cha man'gaiso aga chihamba changanywa nene, hinu mganu waku uhengekayi.” ");
INSERT INTO xnj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Peavawuyili kavili, na kuvakolela vagonili, ndava vavi na lugono neju. ");
INSERT INTO xnj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akavaleka, akahamba kangi mala ya datu kumuyupa Chapanga mu malovi galagala. ");
INSERT INTO xnj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kangi akavahambila vawuliwa vala akavajovela, “Wuli, mwakona mwigona na kupumulila? Mlolayi! Lukumbi lwene luhikili, na Mwana wa Mundu yati igotolewa kwa vandu vevambudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muyima, tihamba. Mlolayi! Mweakunigotola yula avi papipi.” ");
INSERT INTO xnj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lukumbi Yesu akona ilongela nawu, akabwela Yuda, mmonga pagati ya vawuliwa vaki kumi na vavili. Mwene pamonga na vandu vamahele vevagegili mapanga na vibonga vevatumwili na vakulu va kuteta na vagogo va vandu. ");
INSERT INTO xnj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda mweakumng'anamukila Yesu amali kuvalangisa ulangisu “Yula mwenikumkumbatila ndi mumkamula.” ");
INSERT INTO xnj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hinu Yuda akamhegelela Yesu na kumjambusa, “Tukuwoni, Muwula,” Ndi akamkumbatila. ");
INSERT INTO xnj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu akamyangula “Nkozi, kitayi cha ubweli kukita.” Penapo vandu vala vakamhegelela na vakamukamula Yesu, vakamvika muulonda wavi. ");
INSERT INTO xnj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mmonga wa vala vevavi pamonga na Yesu, akaholomola upanga waki akamtova nawu mtumisi wa Mteta mkulu akamdumula likutu. ");
INSERT INTO xnj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Penapo Yesu akamjovela, “Wuyisa upanga waku pachihaku paki, ndava yeyoha mweikoma na upanga yati ifwa na upanga. ");
INSERT INTO xnj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wu, mwihololela lepi nihotola kumuyupa Dadi wangu, mwene ngaaniletili hinu misambi neju ya kumi na yivili va manjolinjoli vamitumu vaki va kunani? ");
INSERT INTO xnj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nambu gitimila wuli Mayandiku Gamsopi gegijova kuvya cheyiganikiwa gavyai?” ");
INSERT INTO xnj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lukumbi lulolo Yesu akaujovela msambi wa vandu vala vevabweli kumkamula, “Wu, mbweli na mapanga na vibonga kunikamula ngati nene mwenangayidakila malagizu? Magono goha navi mu Nyumba ya Chapanga niwula, nambu mwanikamwili lepi. ");
INSERT INTO xnj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambu mambu genaga goha gahengiki muni malovi gegajoviki na vamlota va Chapanga mu Mayandiku Gamsopi gatimilayi.” Kangi vawuliwa voha vakamleka na kutila. ");
INSERT INTO xnj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vandu vala vevamkamwili Yesu vamhindikili kunyumba ya Kayafa Mteta Mkulu, pavakonganiki vawula va malagizu na vagogo va Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nambu Petili amlandili Yesu cha kutali mbaka kuluvanja lwa Mteta Mkulu, akayingila mugati pamonga na valonda muni alola mambu gegihumila. ");
INSERT INTO xnj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hinu vamteta vakulu na vakulu va Luvanja voha vakalonda malovi gaudese ndava ya Yesu muni vamkoma. ");
INSERT INTO xnj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nambu nakupata chindu chochoha pamonga na ago, vabweli vandu vamahele kujova udese, pamwishu vabweli vandu vavili, ");
INSERT INTO xnj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ndi vakajova, “Mundu uyu ajovili, ‘Ihotola kudenya Nyumba ya Chapanga na kujenga kavili mu magono gadatu.’ ” ");
INSERT INTO xnj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mteta Mkulu akayima akamkota Yesu “Wu, wiyangula lepi? Vandu ava vakukutakila kyani kukuvala veve?” ");
INSERT INTO xnj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambu Yesu agunili nuu. Mteta Mkulu, akamjovela, “Nikulapakisa kwa Chapanga mweavimumi, utijovelayi ngati veve ndi Kilisitu, Mwana wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akayangula, “Wamwene umali kujova! Nambu nikuvajovela, kuhuma hinu yati mukumlola Mwana wa Mundu atamili muchiwoko cha kulyelela cha Bambu mweavi na makakala, ibwela panani ya mahundi ga kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Penapo, ndi Mteta Mkulu akapapula nyula zaki, akajova, “Amuligili Chapanga! Tigani lepi mundu yungi wa kumtakila! Hinu niyuwini cheamligili Chapanga! ");
INSERT INTO xnj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nyenye muhololela wuli?” Vene vakamyangula, “Yikumgana akomiwa!” ");
INSERT INTO xnj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kangi vakamuhunyila mata kumihu, vakamtova na vangi vakampamanda ");
INSERT INTO xnj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","vakamkota, “Ulotelayi, veve Kilisitu Msangula! Ndi yani mweakutovili!” ");
INSERT INTO xnj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petili atamili kuvala ya luvanja. Ndi mtumisi mmonga mdala amhambili, akamjovela, “Veve wavi pamonga na Yesu wa ku Galilaya.” ");
INSERT INTO xnj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nambu Petili akabela palongolo ya voha, “Nichimanyi lepi chewijova.” ");
INSERT INTO xnj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petili pahaumayi pamlyangu, mtumisi yungi msikana amuwene, ndi akavajovela vandu vevavi pala. Mundu uyu avi pamonga na Yesu wa ku Nazaleti. ");
INSERT INTO xnj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petili akabela kavili kwa chilapu, “Nimmanyili lepi mundu uyu.” ");
INSERT INTO xnj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mwanakandahi, vandu vevayimili penapo vamhambili Petili, vakamjovela “Chakaka veve mmonga wavi, hati chaujova kukumanyisa.” ");
INSERT INTO xnj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kangi Petili akatumbula kujilapakisa likoto na kulapa ijova, “Nimmanyili lepi mundu uyu!” Bahapo lijogolo likavika. ");
INSERT INTO xnj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petili akumbwiki malovi ga Yesu, geamjovili, “Kwakona lijogolo kuvika, yati ukunibela mala yidatu.” Ndi akahuma kuvala akavembeneka neju. ");
INSERT INTO xnj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lukela pehe, vakulu voha va kuteta, pamonga na vagogo va Chiyawudi vakajovesana ndava ya kumkoma Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hinu vakamukunga, vakamutola na kumgotola kwa Pilatu mweavimkulu wa Loma. ");
INSERT INTO xnj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kangi Yuda, mweamng'anamwikili Yesu paavawene kuvya vamali kumuhamula Yesu, akang'ahika neju mumtima waki, avawuyisili vakulu va kuteta mashonga gala hipandi selasini. ");
INSERT INTO xnj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akavajovela, “Nibudili kumng'anamukila mundu angabuda akomiwa.” Nambu vene, vakayangula, “Lenilo ndi lihengu laku? Umanya wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mwene akataga hipandi ya mashonga gala Munyumba ya Chapanga, akahuma kuvala ya Nyumba ya Chapanga na kuhamba kujikungila. ");
INSERT INTO xnj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Vakulu va kuteta vakatola mashonga genago, vakajova, “Mumbele ya malagizu gitu kuvika muchibana cha Nyumba ya Chapanga ndava muni mashonga gegapatikini kwa kukoma.” ");
INSERT INTO xnj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hinu vakajovesana, vakatola mashonga gala kugula mgunda wa ludaka muni pavyaa pandu pa kuzikila vayehe. ");
INSERT INTO xnj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndava ya genago, hati lelu mgunda wenuwo wikemelewa “Mgunda ngasi mana yaki mgunda weuguliwi kwa ukomaji.” ");
INSERT INTO xnj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndi chagatimalili malovi ga Yelemia mweavi mlota wa Chapanga, “Valotili mashonga hipandi selasini, mashonga ya mwenuyo luhuna lwa vandu va Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Vakahengela kugula mgunda wa madakali, ngati chealagazili Bambu.” ");
INSERT INTO xnj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu akayima palongolo ya mkulu wa Loma, ndi mkulu yula akamkota, “Veve, ndi wa Nkosi wa Vayawudi?” Yesu akayangula, “Genago ndi ujovili wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambu vakulu va kuteta na vagogo pevamtakili, mwene ayangwili lepi lilovi. ");
INSERT INTO xnj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kangi Pilatu akamkota “Wu, wiyuwana lepi matakilu gevakukutakila veve?” ");
INSERT INTO xnj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambu Yesu ayangwili lepi hati lilovi limonga, mkulu wa Loma akakangasa neju. ");
INSERT INTO xnj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hinu yavi mvelu wa mkulu wa Loma lukumbi lwa mselebuko wa Pasaka, kuvadindulila Vayawudi mkungiwa mmonga mwevakumgana. ");
INSERT INTO xnj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lukumbi lwenulo peavili na mkungiwa mmonga mweamanyikini neju, mweikemiwa Balaba. ");
INSERT INTO xnj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndi, vandu pavakonganiki pamonga, Pilatu akavakota, “Mwigana nivadindulilayi yani pagati ya vavili ava, Balaba amala Yesu mweikemiwa Kilisitu?” ");
INSERT INTO xnj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ndava muni amanyili kuvya vachilongosi va chiyawudi vamuwusili Yesu ndava ya wihu. ");
INSERT INTO xnj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatu peatamili pachigoda chaki cha uhamula, mdala waki ampelikili ujumbi, “Ukoto kumhengela chindu chochoa mundu uyu angahoka ndava lelu nin'gaiki neju munjozi ndava ya mwenuyo.” ");
INSERT INTO xnj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nambu vakulu va kuteta na vagogo vakuvakulukisa vandu vamyupa Balaba adinduliwa na Yesu akomiwa. ");
INSERT INTO xnj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilatu akavakota, “Ndi yani pagati ava vavili mwemukumgana nivadindulilayi nyenye?” Vakamyangula mdindulayi, “Balaba!” ");
INSERT INTO xnj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu akavakota kavili, “Hinu nikita kyani na Yesu nweikemiwa Kilisitu?” Voha vakayangula, “Avambiwa pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nambu Pilatu akavakota, “Ndava kyani? Abudili kiki?” Ndi vene vakajova kwa lwami luvaha, “Avambiwa pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hinu, Pilatu paamanyili ngati yihotoleka lepi kuvagunisa, chitutu chitumbula, akatola manji, akasamba mawoko palongolo ya msambi wa vandu, akajova, “Yikunivala lepi ngasi ya mundu uyu, kwali mwavene.” ");
INSERT INTO xnj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Vandu voha vakayangula, “Ngasi yaki yeyitika yivya ndava ya tete na vana vitu!” ");
INSERT INTO xnj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kangi Pilatu akamdindulila Balaba kuhuma muchifungu, na kumtova michapilu akamgotola Yesu avambiwa pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kangi manjolinjoli ga mkulu wa Loma, vamyingisi Yesu mugati ya nyumba ya nkosi, ndi manjolinjoli vakakonganeka msambi woha. ");
INSERT INTO xnj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Vakamuwula nyula zaki, vakamuwalika nyula yidung'u ya chinkosi. ");
INSERT INTO xnj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kangi vakabota njingwa ya minga, vamuwaliki kumutu, vakamvikila mlayi muchiwoko chaki cha kulyela. Vakafugama palongolo yaki ndi vamvevisi vakumjovela, “Tukuwoni Nkosi wa Vayawudi!” ");
INSERT INTO xnj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Vakamuhunyila mata, vakatola mlayi wula, vakamtova nawu kumutu. ");
INSERT INTO xnj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pavamali kumvevesa, vakamuwula ligwanda lenilo, vamuwaliki nyula zaki, kangi vakamhindikila pa kumvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pavavi mukuhamba vamkolili mundu mmonga liina laki Simoni mkolonjinji wa Kulene, kwa makakala vamgegisi msalaba wa Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pavahikili pandu pepikemelewa Goligota, mana yaki “Libangu la Mutu.” ");
INSERT INTO xnj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vakampela divayi yeyihangisini na nyongo. Nambu Yesu peamiyangili akabela kunywa. ");
INSERT INTO xnj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pavamali kumvamba pamsalaba, ndi vakatovela gudugudu kugavana nyula zaki. ");
INSERT INTO xnj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Manjolinjoli vakatama penapo kumulindalila. ");
INSERT INTO xnj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani ya mutu waki pamsalaba, vakayandika matakilu ga kumvala mwene “Mwenuyu ndi Yesu, Nkosi va Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mewawa kwavi na vanyagaji vavili vavambiwi mu misalaba pamonga na Yesu, mmonga upandi waki wa kulyela na yungi upandi wa kumangeya. ");
INSERT INTO xnj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Vandu vevapitayi njila yeniyo vamligili kuni vinyugusa mitu yavi na kujova, ");
INSERT INTO xnj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Veve lepi! Mwewajova wihotola kudenya Nyumba ya Chapanga na kujenga kavili pamagono gadatu? Hinu ujisangula wamwene. Ngati veve wa Mwana wa Chapanga, ndi huluka pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mewawa vakulu va kuteta pamonga na vawula va malagizu na vagogo vamvevisi, na kujova, ");
INSERT INTO xnj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Avasangwili vayaki, ihotola lepi kujisangula mwene! Ati mwene ndi Nkosi wa vandu va Isilaeli! Hinu ahulukayi pamsalaba na tete yati tikumsadika mwene. ");
INSERT INTO xnj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Amhuvalili Chapanga na kujova mwene ndi Mwana wa Chapanga! Ngati Chapanga akumgana ihotola kumsangula!” ");
INSERT INTO xnj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mewawa vala vanyagaji veavambiwi nawu pamsalaba pamonga vamligili. ");
INSERT INTO xnj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kuhumila muhi wa saa sita mbaka saa tisa, chitita chatindili mulima woha. ");
INSERT INTO xnj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hinu payahikili saa tisa, Yesu akavemba neju, “Eloi, Eloi, lama sabakitani?” Mana yaki, “Chapanga wangu, Chapanga wangu, ndava kyani unilekili?” ");
INSERT INTO xnj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nambu vandu vangi vevayimili pala pevayuwini genago vakajova, “Akumkemela Eliya.” ");
INSERT INTO xnj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mmonga wavi akajumba akatola lidodoki, akajwiga mudivayi yivavanu akaivika mumlayi akampela anywai. ");
INSERT INTO xnj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nambu vangi vakajova, “Leka tiloli ngati Eliya ibwela kumsangula.” ");
INSERT INTO xnj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ndi Yesu akavembeneka kwa lwami luvaha, akafwa. ");
INSERT INTO xnj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Penapo lipazia la Nyumba ya Chapanga lapapwiki hipandi hivili kuhumila kunani mbaka pahi, mulima woha wandendimi, na matalahu gakabayuka, ");
INSERT INTO xnj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","matinda gagubwiki na vandu va Chapanga vamahele vevafwili vayukili. ");
INSERT INTO xnj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pevahumili mumatinda gavi, Yesu peamali kuyuka pamonga nawu, vakayingila Pamuji wa Msopi ndi Yelusalemu vawonikini na vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hinu, mkulu yula pamonga na manjolinjoli vevamyangalila Yesu, pavauwene mulima windendema na goha gegahumalili, vakayogopa neju, vakajova, “Chakaka mundu mwenuyu avi Mwana wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pandu penapo kwavi na vadala vamahele vevatamili vilolokesa cha kutali, venavo ndi vevamlandili Yesu kuhuma ku Galilaya vakumhengela. ");
INSERT INTO xnj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pagati yavi avili Maliya kuhuma Magidala na Maliya nyina wavi Yakobo na Yosefu, pamonga na nyina wavi vana va Zebedayo. ");
INSERT INTO xnj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Palatipimi lilanga, abwelili mundu mmonga mkolo vindu vyamahele mkolonjinji wa Alimatei, liina laki Yosefu. Mwenuyu mewa avi muwuliwa wa Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Amhambili Pilatu, akamuyupa higa ya Yesu. Pilatu akahamula vampelayi. ");
INSERT INTO xnj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosefu akayitola higa yila na kuutindisila nyula ya msopi, ");
INSERT INTO xnj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","akauvika mulitinda laki la mupya leahongwili mulitalau, akalibilingisa liganga livaha kudinda mlyangu wa litinda akawuka. ");
INSERT INTO xnj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliya mkolonjinji wa Magidala na Maliya yungi yula vatamili kulolokesa litinda. ");
INSERT INTO xnj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chilau yaki, ndi Ligono la Kupumulila, ndi vakulu vakuteta na Vafalisayu vamhambili Pilatu. ");
INSERT INTO xnj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Vakajova “Mkulu, tikumbwiki kuvya yula mchenjela ajovili peavili mumi kuvya akafwayi yati iyuka pagimalika magono gadatu, ");
INSERT INTO xnj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hinu lagiza valonda valindalila litinda mbaka pegimalika magono gadatu ndava vawuliwa vaki vihotola kumuyiva na kuvajovela vandu kuvya ayukili. Muni udese wa pamwishu wenuwu yati wivya uvaha neju kuliku wa kutumbula.” ");
INSERT INTO xnj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu akavayangula, “Muvi na manjolinjoli, muhamba mukalindila chemwihotola.” ");
INSERT INTO xnj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hinu vakahamba kulindila litinda vakavika vidindilu liganga lila, vakaleka manjolinjoli bahapo vakulilindila. ");
INSERT INTO xnj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ligono la Kupumulila palamaliki, lukela hamba kucha ligono la Dominika, Maliya mkolonjinji wa Magidala na muyaki Maliya yungi yula vahambili kulola litinda lila. ");
INSERT INTO xnj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bahapo mulima woha wandendimi neju, mtumu wa kunani kwa Bambu ahelili kuhumila kunani kwa Chapanga, alibilingisi liganga la pamlyangu na kutamila. ");
INSERT INTO xnj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Awonikini ngati lumwetumwetu lwa mbamba na nyula zaki zavi za msopi pehe. ");
INSERT INTO xnj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Valonda vevalindalila litinda vala vakavagaya neju ndava ya wogohi vavi ngati vamali kufwa. ");
INSERT INTO xnj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nambu mtumu wa kunani kwa Chapanga akavajovela vadala vala, “Nyenye mkoto kuyogopa! Muni nimannyili kuvya mukumulonda Yesu mweavambiwi pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Avi lepi apa muni amali kuyuka ngati cheajovili. Mbwela mlola pandu pevamgonisi. ");
INSERT INTO xnj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hinu mhamba kanyata mkavajovela vawuliwa vaki kuvya amali kuyuka, na hinu akuvalongololela ku Galilaya yati mumkolela kwenuko. Yuwanila, nene nimali kuvajovela.” ");
INSERT INTO xnj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hinu vadala vala kuni viyogopa na kuni viheka neju, vakawuka kanyata palitinda na kujumba kuhamba kuvajovela vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bahapo Yesu akakonganeka nawu, akavajambusa, “Nivawoni.” Vadala vala vakamhegelela na vakamkamula magendelu gaki na kumgundamila. ");
INSERT INTO xnj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kangi Yesu akavajovela, “Mkoto kuyogopa,” “Mhamba mkavajovela valongo vangu vahamba ku Galilaya kwenuko ndi yati vakunilola.” ");
INSERT INTO xnj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pevawukili vadala vala, ndi pagati ya valonda va litinda, vakahamba kumuji kuvadandaulila vateta vakulu mambu goha gevagawene. ");
INSERT INTO xnj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hinu vakakonganeka pamonga na vagogo, na kuvika mpangu, vakavapela mashonga gamahele manjolinjoli vala, ");
INSERT INTO xnj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","vakajova, nyenye mjova kuvya, “Vawuliwa vaki vabweli kilu, vakamuyiva tete petatitili lugono. ");
INSERT INTO xnj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngati mkulu wa Loma akayuwana lijambu lenili tete yati tikuvatangatila tikumkulukisa, muni nyenye mkoto kuvya na mhalu.” ");
INSERT INTO xnj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hinu manjolinjoli vala vakatola mashonga gala, vakahenga ngati chavawuliwi, malovi ago gadandasiki kwa Vayawudi mbaka lelu. ");
INSERT INTO xnj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kangi vawuliwa kumi na mmonga vala vakahamba kuchitumbi chechivii ku Galilaya cheavalagazili Yesu. ");
INSERT INTO xnj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pavamuwene, vakagundama, nambu vangi vavi na mtahu. ");
INSERT INTO xnj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu avahegalili, akavajovela, “Nipewili uhotola woha kunani kwa Chapanga na pamulima. ");
INSERT INTO xnj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hinu mhamba mkavakita vandu va milima yoha kuvya vawuliwa vangu. Kuni mvabatiza kwa liina la Dadi na la Mwana na la Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Muvawula kukamula malovi gangu goha ngati chenivalagizi nyenye, nene nivii pamonga na nyenye magono goha, hati pamwishu wa lusenje.”");
INSERT INTO xnj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wenuwu ndi utumbula wa Lilovi la Bwina la Yesu Kilisitu, Mwana wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yatumbwili ngati chaalotili Isaya mweavi mlota wa Chapanga, “Yuwanila, Chapanga ajovili, ‘Nikumtuma mjumbi wangu akulongolelayi, kukutendelekela njila yaku.’ ");
INSERT INTO xnj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu mmonga ijova kwa lwami luvaha kulugangatu, ‘Mumtendekela Bambu njila yaki, mgolosayi pala peibwela kupita!’ ” ");
INSERT INTO xnj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohani Mbatizaji atamayi kulugangatu, akavakokosela vandu na kuvabatiza, akavajovela, “Mleka kumbudila Chapanga na mubatiziwa na Chapanga yati akuvalekekesa kumbudila kwinu.” ");
INSERT INTO xnj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Vandu vamahele kuhuma pamulima woha wa ku Yudea na kumuji wa Yelusalemu vahambili kumuyuwanila Yohani, vayidakili kuvya vambudili Chapanga, namwene avabatizi mumfuleni Yoludani. ");
INSERT INTO xnj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohani awalili nyula zezatenganizwi kwa mangoma ga hinyama yeikemiwa ngamiya, akungi mkungi wa chikumba muchiwunu, alili mambalanguli na wuchi wa kudahi. ");
INSERT INTO xnj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndi akakokosa akajova, “Mweibwela hinu naha mumbele yangu ana makakala kuliku nene. Nene nakuganikiwa hati kugundama kuwopola nyosi za champali zaki. ");
INSERT INTO xnj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nene nikuvabatiza kwa manji, nambu mwene alavabatiza kwa Mpungu Msopi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Magono genago, Yesu abwelili kuhuma ku Nazaleti, muji wewavi ku Galilaya na akabatiziwa na Yohani mumfuleni Yoludani. ");
INSERT INTO xnj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu pahumili mumanji, akalola kunani kwa Chapanga kudindwiki, na Mpungu Msopi ihelela panani yaki ngati ngunda. ");
INSERT INTO xnj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lwami lwa Chapanga lukayuwanika kuhuma kunani kwa Chapanga, lukajova, “Veve ndi Mwana wa chiganu changu mweniganisiwi nayu.” ");
INSERT INTO xnj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bahapo Mpungu Msopi akamlongosa kuhamba kulugangatu, ");
INSERT INTO xnj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","akatama kwenuko magono alobaini, kuni ilingiwa na Setani. Nambu avi pamonga na hinyama ya mdahi, na vamitumu va kunani kwa Chapanga vakavya kumtangatila. ");
INSERT INTO xnj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohani peakungiwi muchifungu, Yesu akahamba ku Galilaya kuvakokosela vandu Lilovi la Bwina la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akajova, “Lukumbi luhikili, Unkosi wa Chapanga uhegelili, hinu mleka kumbudila Chapanga na kusadika Lilovi la Bwina!” ");
INSERT INTO xnj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu peapitayi mumhana ya nyanja Galilaya avaweni valova somba vavili. Avi Simoni na mlongo waki Andelea valovayi somba kwa ngwanda zavi mumanji. ");
INSERT INTO xnj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu akavajovela, “Munilandayi, na nene yati nikuvapela lihengu la kuvaleta vandu kwangu ngati chemwilova somba.” ");
INSERT INTO xnj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bahapo ndi vakazileka ngwanda zavi vakamulanda. ");
INSERT INTO xnj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu peahegalili cha palongolo akavalola Yohani na mlongo waki Yakobo vana va Zebedayo vavi muwatu wavi vatengeneza ngwanda zavi. ");
INSERT INTO xnj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bahapo Yesu akavakemela, ndi vakamleka dadi wavi Zebedayo na vahenga lihengu vevavi muwatu, vakamulanda Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na vawuliwa vaki vakahamba kumuji wa Kapelanaumu. Ligono la Kupumulila palahikili, Yesu akayingila munyumba ya kukonganekela Vayawudi, akatumbula kuvawula malovi ga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Vandu voha vevamuyuwini vakakangaswa neju namuna ya kuwula kwaki, muni awula lepi ngati Vawula va Malagizu, nambu awulayi ngati mundu mweavi na uhotola. ");
INSERT INTO xnj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ndi lukumbi lulalula, mundu mweatalaliwi na mizuka avi munyumba ya kukonganekela Vayawudi vakaywanga, ");
INSERT INTO xnj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akajova, “Yesu wa ku Nazaleti, ukutiganila kyani tete? Ubweli kutikomakesa? Nikumanyili veve ndi yani, veve ndi Wamsopi wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu akauhakalila mzuka wula. Akaujovela, “Guna, muwuka mundu uyu!” ");
INSERT INTO xnj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mzuka wula ukamnyugusa mundu yula kwa makakala kuni ukavembeneka kwa lwami luvaha, ukamuwuka mundu yula. ");
INSERT INTO xnj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Vandu voha vakakangasa neju na kukotana, “Nakugalola mambu ngati aga? Chakaka mawuliwu aga gana uhotola! Mundu mwenuyu ihotola hati kuvinga mizuka mihakau na yene yeyidakila.” ");
INSERT INTO xnj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kangi malovi gakumvala Yesu gakadandasika kanyata pamuji woha ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na vawuliwa vaki Yakobo na Yohani, vakawuka munyumba za kukonganekela Vayawudi vakahamba pamonga kunyumba ya Simoni na Andelea. ");
INSERT INTO xnj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mkohanu waki Simoni agonili palusongwani ndava alwalayi neju. Yesu pahikili pala ndi kanyata vakamjovela utamu wa mau yula. ");
INSERT INTO xnj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu akamhambila mau yula, akamkamula chiwoko akamuyinula. Ndi utamu ula ukamleka, akatumbula kuvatelekela. ");
INSERT INTO xnj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kimihi, palatipimi lilanga vandu vamuletili Yesu vatamu na vandu vevatalaliwi na mizuka voha. ");
INSERT INTO xnj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vandu vamahele va muji wula vakalundimana kuvala ya mlyangu. ");
INSERT INTO xnj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Namwene akavalamisa vandu vamahele vevalwalai matamu ndalindali, ayivingili mizuka yamahele yeyavatalali vandu, nambu nakuyileka mizuka yijova chindu muni yamanyili mwene ndi yani. ");
INSERT INTO xnj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chilau yaki hambakucha, Yesu akahamba kuchiyepela akatumbula kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ndi Simoni na vayaki vakahamba kumlonda. ");
INSERT INTO xnj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pevamuweni vakamjovela, “Vandu voha vakukulonda.” ");
INSERT INTO xnj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu akavayangula, “Tihamba na mumiji yingi ya papipi nikakokosayi na kwenuko mewa muni nibweli ndava yeniyo.” ");
INSERT INTO xnj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hinu akahamba pandu poha pa Galilaya akakokosa munyumba za kukonganekela Vayawudi na kuyivinga mizuka. ");
INSERT INTO xnj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ligono limonga mundu mmonga mweavi na mabudi, amhambalili Yesu, akafugama, akamuyupa, “Ngati wigana uhotola kuninyambisa.” ");
INSERT INTO xnj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu akamhengela lipyana akatalambula chiwoko na kumpamisa, akamjovela, “Nigana, unyambasikayi!” ");
INSERT INTO xnj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bahapo mabudi gakamuwuka mundu yula akalama. ");
INSERT INTO xnj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kangi Yesu akamjovela, ahamba kanyata na kumlagiza, ");
INSERT INTO xnj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Yuwanila, kotoka kumjovela mundu yoyoha lijambu lenili. Nambu uhamba ukajilangisa kwa Mteta na ukawusa luteta ndava ya kulama kwaku, ngati chehamwili Musa kulangisa kuvya ulamili.” ");
INSERT INTO xnj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nambu mundu yula akahamba, akatumbula kudandaula malovi gala pandi zoha. Ndava yeniyo, hati Yesu nakuhotola kuyingila pamuji wowoha hotohoto, ndi yamuganili kutama kuchiyepela. Pamonga na genago vandu vamuhambalili kuhuma kila upandi. ");
INSERT INTO xnj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gapitili magono Yesu akawuya kavili Kapelanaumu, vandu vakayuwana kuvya avili kunyumba. ");
INSERT INTO xnj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hinu, vandu vamahele vakambwelela vakamema mugati na kuvala hati kawaka nafwasi pamlyangu. Yesu avakokoselayi ujumbi waki. ");
INSERT INTO xnj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lukumbi lwenulo vakabwela vandu mcheche vamletili mundu mweapolili kwa Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nakuhotola kumuhikisa kwa Yesu ndava ya msambi wa vandu. Hinu vakapekenyula kuchituvilu pandu peavili Yesu. Pavamali kubowola pandu pala vakamuhelesa mundu yula kuni agonili pampasa. ");
INSERT INTO xnj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu peayiwene sadika yavi akamjovela mundu mweapoli yula, “Mwana vangu, ulekekiswi kumbudila Chapanga waku.” ");
INSERT INTO xnj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Vawula vangi va Malagizu ga Chapanga geampeli Musa vevatamili penapo vakaholalela mumitima yavi, ");
INSERT INTO xnj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ihotola wuli kujova genaga? Akumliga Chapanga! Kawaka mundu mweihotola kulekekesa kubuda nambu ndi mmonga Chapanga ndu.” ");
INSERT INTO xnj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahapo Yesu agamanyili maholo gavi, akavajovela, “Ndava kyani mwiholalela mumitima yinu mambu ago? ");
INSERT INTO xnj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chindu choki changa hotoleka kumjovela mundu mweapolili, ‘Ulekekiswi kumbudila Chapanga,’ Amala ‘Yimuka, tola mpasa waku Uhambayi?’ ");
INSERT INTO xnj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nambu nigana mumanyayi kuvya Mwana wa Mundu ana uhotola pamulima wa kulekekesa vandu vevakumbudila Chapanga.” Ndi amjovili mwaapoli yula, ");
INSERT INTO xnj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nikukujovela, yimuka, tola mpasa waku uhamba kunyumba yaku!” ");
INSERT INTO xnj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na vandu voha pavamlolokesa mundu yula, balapala akayima na kutola mpasa waki akahamba. Vandu voha vakakangasa na vakamlumbalila Chapanga, vakajova, “Katu nakulilola lijambu ngati lenilo hati padebe!” ");
INSERT INTO xnj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu akawuka penapo akahamba pamuhana ya nyanja ya ku Galilaya. Ndi msambi wa vandu wamulandili, mwene akatumbula kuvawula. ");
INSERT INTO xnj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ndi paagendayi amuweni Lawi mwana wa Alufayo atamili munyumba ya kutolela kodi. Yesu akamjovela, “Bwela nilandayi.” Ndi Lawi akayima akamulanda. ");
INSERT INTO xnj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mwanakandayi Yesu avi kunyumba ya Lawi ilya chakulya. Vatola kodi vamahele na vandu vevajovekini kuvya vakumbudila Chapanga na vevamlandayi Yesu. Na vamahele wavi valili chakulya na Yesu pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hinu, Pagati ya vawula vangi va Malagizu vevavi Vafalisayu pavamuweni Yesu ilya pamonga na vandu vevajovikini kuvya vakumbudila Chapanga na vatola kodi, vakavakota vawuliwa vaki, “Ndava kyani ilya pamonga na vandu ngati ava?” ");
INSERT INTO xnj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu peayuwini akavajovela, “Vangalwala nakumgana mlamisa, nambu vatamu ndi vevakumgana mlamisa. Nabweli lepi kuvakemela vandu vabwina, nambu nabweli ndava ya kuvakemela vevajovikini kuvya vakumbudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lukumbi lumonga vawuliwa va Yohani na Vafalisayu vavi mukujihinisa kulya chakulya. Vandu vangi vakamkota Yesu, “Ndava kyani vawuliwa va Yohani na va Vafalisayu vakujihinisa kulya chakulya nambu vawuliwa vaku nakukita genago?” ");
INSERT INTO xnj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akayangula, “Wu, vevagongoliwi kumselebuko wa ndowa yikuvagana kujihinisa chakulya kuni vavi pamonga na mkolo ndowa? Nakuhotola kujihinisa chakulya lukumbi lwoha pevivya na mkolo ndowa. ");
INSERT INTO xnj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nambu yati lubwela lukumbi lwa mkolo ndowa paiwusiwa pagati yavi, lukumbi ulo ndi pavakujihinisa chakulya.” ");
INSERT INTO xnj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kawaka mundu mweitota chilaka cha nyula ya mupya mulindimula la nyula. Ngati akakita chenichi chilaka cha mupya yati chinyalala na chipapula lindimula lenilo neju. ");
INSERT INTO xnj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Avi lepi mundu mweisopa divayi ya mupya mumahaku gachikumba gegalalili. Ngati akakitayi chenicho, divayi peyitutumuka yati yipapula mahaku ga chikumba gala na divayi pamonga na mahaku ga chikumba yati gipapuka na kuyitika. Divayi ya mupya yisopewa mumahaku gamupya!” ");
INSERT INTO xnj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ligono limonga la Kupumulila, Yesu pamonga na vawuliwa vaki vapitayi mumgunda wa nganu. Vawuliwa vaki vakatumbula kudenya njechela ga nganu kuni vigenda. ");
INSERT INTO xnj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Vafalisayu vakamkota Yesu, “Lola hoti! Ndava kyani vawuliwa vaku vikita lijambu lelibesiwi pa Ligono la Kupumulila?” ");
INSERT INTO xnj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu akavayangula, “Wu, mwangasoma cheakitili Daudi na vayaki njala peyavavinili? ");
INSERT INTO xnj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daudi ayingili mu Nyumba ya Chapanga na kulya mabumunda yeyavikiwi luteta ndava ya Chapanga. Lijambu lenili lakitiki lukumbi Abiasali avili Mteta Mkulu. Kulandana na Malagizu ndi vakulu va kuteta vene ndu vevaganikiwa kulya mabumunda genago. Nambu Daudi alili, na kuvapela vayaki.” ");
INSERT INTO xnj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Hinu, Yesu akavajovela, “Ligono la Kupumulila lavikiwi ndava ya kuvatangatila vandu, lepi vandu kulihengela Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hinu, Mwana wa Mundu ndi Bambu hati pa Ligono la Kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu akayingila kavili munyumba ya kukonganekela Vayawudi na mugati mula kwavili na mundu mweagogodili chiwoko. ");
INSERT INTO xnj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mugati mula kwavi na vandu vangi pagati yavi valindilayi kumlola Yesu, ngati akumlamisa mundu yula Ligono la Kupumulila, muni valonda chindu cha kumtakila. ");
INSERT INTO xnj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu akamjovela mundu yula mweagogodili chiwoko, “Bwela uyima palongolo ya vandu.” ");
INSERT INTO xnj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kangi Yesu akavakota, “Malagizu gitu yijova wuli pa Ligono la Kupumulila? Chabwina kumtangatila mundu amala kumlemasa? Kusangula amala kukoma?” Nambu vene vakaguna. ");
INSERT INTO xnj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu akavalolokesa voha cha ligoga, mtima ukamvina ndava ya kunonopa kwa mitima yavi. Kangi akamjovela mundu yula “Golosayi chiwoko chaku.” Namwene akachigolosa ndi chikalama kavili. ");
INSERT INTO xnj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bahapo Vafalisayu vakahuma kuvala, vakajovesana pamonga na vandu va chikundi cha Helodi ndava ya mpangu wa kumkoma Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na vawuliwa vaki vakawuka penapo, vakahamba pamhana ya nyanja na msambi wa vandu wamulandili. Vandu venavo vahumili ku Galilaya na ku Yudea, ");
INSERT INTO xnj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na ku Yelusalemu na ku Idumea na kumwambu ya mfuleni Yoludani na ku Tilo na Sidoni. Vandu venavo vamahele vamuhambalili Yesu ndava ya kuyuwana mambu gamahele geakitili. ");
INSERT INTO xnj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ndava ya msambi wa vandu Yesu akavajovela vawuliwa vaki vamutendelekela watu udebe, ndava ya kuyepa msambi wa vandu ukoto kumuhinya. ");
INSERT INTO xnj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ndava avalamisi vandu vamahele, hinu voha vevavi na matamu vakavya kumuhinya muni vahotola kumpamisa. ");
INSERT INTO xnj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vandu vevatalaliwi na mizuka mihakau ndi kila pavamuwene Yesu vakagwilingana palongolo yaki, na kuywanga, “Veve ndi Mwana wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nambu Yesu akayihakalila kwa makakala mizuka mihakau yila yikotoka kummanyisa kwa vandu. ");
INSERT INTO xnj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kangi Yesu akahamba kuchitumbi akavakemela veavaganili, ndi vakamhambila, ");
INSERT INTO xnj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","mwene akavahagula vandu kumi na vavili akavakemela vamitumi, muni vavyai pamonga nayu muni avatuma kukokosa, ");
INSERT INTO xnj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","mewa vavyai na uhotola wa kuvinga mizuka. ");
INSERT INTO xnj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hinu, kumi na vavili vevahaguliwi vala. Simoni ndi Yesu ampeli liina la Petili, ");
INSERT INTO xnj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","na Yakobo na Yohani vana va Zebedayo, venavo Yesu avapeli valongo vavili liina lingi avakemili Bonelige, mana yaki “Vana va Kubuluma amala, vandu va chipyau.” ");
INSERT INTO xnj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Vangi vavi Andelea na Filipi na Batolomei na Matei na Tomasi na Yakobo mwana wa Alufayo na Tadayo na Simoni mweikemiwa Zeloti, ndava avili mundu wa kukengelela mulima waki, ");
INSERT INTO xnj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikalioti mweabweli kumugeukila Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kangi Yesu akahamba kunyumba, kwenuko msambi wa vandu ukamlanda kavili, Yesu na vawuliwa vaki nakuvya na nafwasi ya kulya. ");
INSERT INTO xnj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hinu valongo vaki pevayuwini genago, vakawuka kuhamba kumkamula muni vaholalela manya ipenga. ");
INSERT INTO xnj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pagati ya vawula vangi va Malagizu vevahelili kuhuma ku Yelusalemu, vakajova, “Mwenuyu atalaliwi na Belizebuli! Kwa makakala ga mkulu wa mizuka akuyivinga mizuka.” ");
INSERT INTO xnj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu akavakemela akavajovela kwa miluhumu, “Setani ihotola wuli kumvinga Setani? ");
INSERT INTO xnj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ngati unkosi umonga ulekangini chikundi chikundi weutovana, unkosi wenuwo nakuhotola kusindimala. ");
INSERT INTO xnj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ngati vandu va nyumba yimonga valekangini chikundi chikundi yati yigwa. ");
INSERT INTO xnj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hinu ngati, unkosi wa Setani ulekangini chikundi chikundi, wisindimala lepi, ndi wivya lepi na makakala.” ");
INSERT INTO xnj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Avi lepi mundu mweihotola kuzangila nyumba ya mundu mweavi na makakala na kumnyaga vindu vyaki changali hoti kumkunga mundu mwenuyo. Penapo ndi yati ihotola kumnyaga vindu vyaki.” ");
INSERT INTO xnj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Chakaka nikuvajovela, vandu yativilekesewa kumbudila Chapanga kwoha na kumliga kwavi kwoha. ");
INSERT INTO xnj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nambu mweakumliga Mpungu Msopi, katu Chapanga akumlekekesa lepi, ndi ivya mbudingana wa magono goha gangali mwishu.” ");
INSERT INTO xnj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu ajovili genago ndava vandu vajovili kuvya, “Ana mzuka.” ");
INSERT INTO xnj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nyina wa Yesu na valongo vaki vakabwela vakayima pavala, vakamtuma mundu mmonga akamkemela mugati mula. ");
INSERT INTO xnj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Msambi wa vandu watamili kumtindila Yesu mundu mmonga akamjovela, “Lola nyina waku na valongo vaku vavi kuvala, vakukulonda.” ");
INSERT INTO xnj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu akavajovela, “Nyina wangu na valongo vangu ndi vayani?” ");
INSERT INTO xnj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kangi akavalola voha vevatamili kumtindila mwene, akajova “Mlola! Nikuvalola ava ngati Nyina wangu na valongo vangu. ");
INSERT INTO xnj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu yoyoha yula mweihenga gakumganisa Chapanga, mwenuyo ndi mhaja wangu kavili mlumbu wangu mewa nyina wangu.” ");
INSERT INTO xnj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu akatumbula kuvawula kavili kumwambu ya nyanja ya Galilaya. Ndava ya msambi uvaha wa vandu wewamtindili yaganikiwi ayingila muwatu na kutama, vandu voha vasigalili kundumba. ");
INSERT INTO xnj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ndi penapo avawuli mambu gamahele kwa miluhumu, akavajovela. ");
INSERT INTO xnj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Muyuwanila hoti! Mundu mmonga ahambili kumgunda kumija mbeyu. ");
INSERT INTO xnj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hinu paamijayi mbeyu, zingi zikagwilila munjila, videge vikabwela kuhola. ");
INSERT INTO xnj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mbeyu zingi zikagwilila palitalau, zikamela kanyata pandu pangali na ludaka lwamahele. ");
INSERT INTO xnj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lilanga palachonayi zanyalili na kuyuma, muni mikiga yaki yavi lepi na ludaka lwamahele. ");
INSERT INTO xnj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Zingi zagwili pagati ya minga, minga yakulili na kuyihinya hati zapambiki lepi matunda. ");
INSERT INTO xnj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Zingi zagwili paludaka lwa bwina, zikamela zikakula na kupambika yimonga selasini na yingi sitini na yingi miya yimonga.” ");
INSERT INTO xnj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndi akavajovela, “Mweavi na makutu gakuyuwana na amanyayi!” ");
INSERT INTO xnj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu peavili mwene, pagati ya vevamuyuwanili vala na vawuliwa kumi na vavili, vamuhambalili Yesu vakamkota, ndava ya miluhumu yila. ");
INSERT INTO xnj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akavajovela, “Nyenye mupewili kugamanya mambu ga mfiyu ga Unkosi wa Chapanga.” “Nambu vevavi kuvala vala yati vakujiwula kwa miluhumu ndu, ");
INSERT INTO xnj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","muni, ‘Chakaka valolayi, nambu vilola lepi, chakaka vayuwana, nambu vimanya lepi. Manya vamuwuyila Chapanga, namwene ngaavalekekisi.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kangi Yesu akavakota, “Ngati mwimanya lepi mana ya luhumu ulu? Mwihotola wuli kuyimanya mana za miluhumu yingi? ");
INSERT INTO xnj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mweimija mbeyu ndi imija Lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbeyu zingi zagwilili munjila, ndi vandu vala vevayuwini lilovi, Setani akabwela na kuliwusa lilovi lenilo lelimijiwi mumitima yavi. ");
INSERT INTO xnj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mbeyu zila zezamijiwi palitalau ndi ngati vandu vala, veviyuwana lilovi bahapo vakulipokela kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nambu likuvayingila lepi nakuvya na mikiga mugati yavi, vakulikamula mulukumbi luhupi ndu. Na lukumbi lwa mang'ahiso peluhumila ndava ya lilovi lenilo, vikuvanduka na kugwa. ");
INSERT INTO xnj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vandu vangi ndi ngati mbeyu zila zezagwilili pagati ya minga. Wenuwo ndi luhumu lwa vala veviyuwana lilovi lenilo, ");
INSERT INTO xnj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ndava ya mang'ahiso ga mulima uwu, mnogo wa kuvya na vindu vyamahele mnogo wa higa ukuvayingila na kulihinya lilovi lenilo, na vene viyidikila lepi chila chelijova lilovi. ");
INSERT INTO xnj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nambu vandu vangi ngati mbeyu zezimijiwi paludaka lwabwina. Venavo ndi veviyuwana lilovi lenilo, vakuliyidakila na kupambika matunda. Vangi selasini, vangi sitini na vangi miya yimonga.” ");
INSERT INTO xnj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu akavakota, “Mwaloli koki vandu vigubika hahi yeyiyaka na chiviga amala vivika kuhi kulusongwani? Lepi! Vivika panani pachibokoselu. ");
INSERT INTO xnj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hinu, goha gegafiyiki yati givya pawaka na goha gegagubikiwi yati gigubukuliwa. ");
INSERT INTO xnj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mweavi na makutu gakuyuwana na amanyayi!” ");
INSERT INTO xnj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akavajovela kavili, “Myuwanila chipimu chilachila chemukuvapimila vayinu, na nyenye yati mwipimiwa mewawa, na kuyonjokeswa. ");
INSERT INTO xnj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mundu yeyoha mweavi na chindu yati iyonjokesewa neju, nambu mweangavya na chindu hati chidebe ndi hati cheavi nachu yati inyagiwa.” ");
INSERT INTO xnj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu akayendelela kuvajovela, “Unkosi wa Chapanga uvi ngati mundu mweimija mbeyu mumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kilu igona, na muhi ivya mihu na lukumbi lwenulo mbeyu yimela na kukula. Mwene amanyili lepi chechihengeka. ");
INSERT INTO xnj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Muni ludaka lwene lumelesa mbeyu. Yikula na kupambika. Yitumbula kumela linyai, yigelekela njechela na pamwishu mbeyu yikangala. ");
INSERT INTO xnj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbeyu peyikangala mundu mwenuyo itola chikwakwa na kutumbula kubena muni lukumbi lwa mabenu luhikili.” ");
INSERT INTO xnj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu akajova kavili, “Unkosi wa Chapanga tiuwanangisa na kyani? Tiudandaulayi kwa luhumu lwoki? ");
INSERT INTO xnj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uwanangana ngati lumbeyu lwa haladali lweluvili ludebe kuliku mbeyu zoha zezimijiwa mumgunda. ");
INSERT INTO xnj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nambu yikamijiwayi, yimela na kuvya mkongo uvaha kuliku mikongo yoha mumgunda. Mambanda gaki gavaha hati videge vijenga hisakanilu mumambanda gaki.” ");
INSERT INTO xnj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu avakokosili vandu ujumbi waki kwa miluhumu yingi yamahele ngati yeniyo, alongili nawu chavahotwili kumanya. ");
INSERT INTO xnj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Lukumbi lwoha alongili nawu lepi chochoha changali miluhumu nambu paavi na vawuliwa vaki avadandaulili kila chindu. ");
INSERT INTO xnj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lilanga palatipimi ligono lilolo, Yesu akavajovela vawuliwa vaki, “Tikupuka kumwambu.” ");
INSERT INTO xnj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hinu, vawuliwa vakaulaga msambi wa vandu, vakayingila muwatu weavili Yesu na kuwuka pamonga nayu. Na vandu vakayingila muwatu wungi vakamlanda. ");
INSERT INTO xnj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pavakupukayi, mpungu uvaha ukahumila manji gakutimbungana na kuutova watu na manji gakatumbula kumema muwatu. ");
INSERT INTO xnj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Penapo Yesu avi mumbele ya watu kuni agonili pamsagamilu. Ndi vawuliwa vaki vakamuyimusa vakamkota, “Muwula, wuli, tifwaa ukutilolokesa ndu!” ");
INSERT INTO xnj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hinu, akayimuka, akauhakalila mpungu na kuujovela luyuga lwa manji, “Guna!” Ndi penapo mpungu wula ukaleka kubuma na nyanja yikavya nuu. ");
INSERT INTO xnj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu akavajovela vawuliwa vaki, “Mwiyogopa kyani? Wu, mwakona kusadika?” ");
INSERT INTO xnj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ndi penapo vavi na wogohi neju, vakatumbula kukotana, “Mundu uyu yani? Mbaka mpungu na manji gakutimbungana vikumyuwana na kuguna!” ");
INSERT INTO xnj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na vawuliwa vaki vakahika kumwambu ya nyanja ya Galilaya, pamulima wa Vagelasi. ");
INSERT INTO xnj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bahapo Yesu peahulwiki muwatu mula akakonganeka na mundu mweavi na mzuka mweahumili kumatinda. ");
INSERT INTO xnj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu mwenuyo atamayi kumbugu la litinda. Kawaka mundu mweahotwili kumkunga kavili hati kwa minyololo. ");
INSERT INTO xnj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pamahele valingi kumkunga pingu na minyololo mumagendelu na mu mawoko, nambu pamahele adaulini pingu na minyololo. Avi lepi mundu mweavi na makakala gakumhotola. ");
INSERT INTO xnj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kilu na muhi atamayi ku matinda na muvidunda aywangayi na kujidumulana na maganga. ");
INSERT INTO xnj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mundu mwenuyo paamuweni Yesu cha kutali, akamjumbalila, na kumfugamila. ");
INSERT INTO xnj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akajova kwa lwami luvaha, “Yesu, Mwana wa Chapanga mweavi Kunani Neju, una kyani na nene? Kwa liina la Chapanga, nikuyupa kotoka kuning'aha!” ");
INSERT INTO xnj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ajovili genago ndava Yesu amali kumjovela, “Mzuka, muwuka mundu uyu!” ");
INSERT INTO xnj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kangi Yesu akamkota, “Liina laku yani?” Mwene akayangula, “Liina langu ‘Msambi’ Ndava tivii tavamahele!” ");
INSERT INTO xnj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kangi akamuyupa Yesu neju akotoka kuvavinga pamulima pala. ");
INSERT INTO xnj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Papipi na mhelelu wa chitumbi, kwavi na maguluvi gamahele gegalyayi. ");
INSERT INTO xnj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Hinu mizuka yila yikamuyupa Yesu yikajova, “Utiyidakilayi tikagayingila maguluvi gala.” ");
INSERT INTO xnj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Akagayidakila. Ndi mizuka yila yikawuka na kuyingila mumaguluvi gala. Na msambi woha wa maguluvi wavi ngati elufu zivili, ukajumba pamhelelu wa chitumbi na kudumbukila mumanji na kufwa. ");
INSERT INTO xnj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Hinu vadimaji va maguluvi vala vakajumba, kuvadandaulila vandu mambu genago kumuji na kumigunda. Vandu vakavya kubwelenela penapo kugalola mambu genago. ");
INSERT INTO xnj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Vakahika mbaka pala peavi Yesu, vakamlola mundu mweatalaliwi na msambi wa mizuka yula. Atamili pahi na awalili nyula na luhala lwaki lumuwuyili, ndi vakayogopa. ");
INSERT INTO xnj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vandu voha vevaloli lijambu lenilo vakavajovela vayavi mambu gala gegamkolili mundu yula na kugavala maguluvi gala. ");
INSERT INTO xnj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hinu, vakamuyupa Yesu awuka pamulima wavi. ");
INSERT INTO xnj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu paayingila muwatu, mundu mweatalaliwi na mizuka yula akamuyupa neju vahamba voha. ");
INSERT INTO xnj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nambu Yesu akambelelela mundu yula akamjovela, “Uhambayi ukavajovela vandu va kunyumba yaku Bambu gabwina geakukitili na cheakuhengili lipyana.” ");
INSERT INTO xnj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kangi mundu yula akahamba ku Dekapoli kwoha ndi miji kumi, akavadandaulila vandu va mambu goha geahengiwi na Yesu. Na vandu voha vakakangasa. ");
INSERT INTO xnj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akakupuka kavili kumwambu ya nyanja. Peavili kwenuko msambi wa vandu ukambwelenela, mwene avili pamuhana ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Akabwela chilongosi mmonga wa nyumba ya kukonganekela Vayawudi liina laki Yailusi, hinu paamuwene Yesu, akamfugamila pamagendelu gaki, ");
INSERT INTO xnj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akamuyupa neju akamjovela, “Pepayi msikana wangu mdebe avi mulung'olelu. Chondi tihambi ukamuvikila mawoko gaku, muni ihotola kulama na kuvya mumi.” ");
INSERT INTO xnj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu pamonga na mundu yula vakalongosana kuhamba. Msambi wa vandu ukamulanda na kumuhinya pandi zoha. ");
INSERT INTO xnj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pagati yavi kwavili na mdala mmonga, mwealwalayi utamu wa kuhuma ngasi mulukumbi lwa miyaka kumi na yivili. ");
INSERT INTO xnj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mdala mwenuyo amali kung'ahika neju na kumala mashonga gaki goha, kwa valamisa vamahele ndava ya kulonda kulama, nambu utamu waki wayonjokisiki neju. ");
INSERT INTO xnj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mau yula peayuwini kuvya Yesu akuvalamisa vandu ndi akaholota mumbela ya msambi wa vandu wula na kuhamba kupamisa nyula ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Akitili chenicho, muni aholalili kuvya, “Nakahotola kupamisa nyula ya Yesu yati nilama.” ");
INSERT INTO xnj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Peampamisi bahapo akamanya kuvya alamili, muni ngasi yeyahuma yila yikaleka. ");
INSERT INTO xnj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu akamanya ngati makakala gaki zimulamisi mundu. Akang'anamuka, akakota, “Yani mweanipamisi nyula yangu?” ");
INSERT INTO xnj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Vawuliwa vaki vakamyangula, “Ndava kyani wikota yani mweakupamisi? Wu, ukuvalola lepi vandu chevakuhinya?” ");
INSERT INTO xnj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nambu Yesu akayendelela akalolokesa pandi zoha mundu mweampamisi nyula yaki. ");
INSERT INTO xnj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mdala yula kuni imanya gegamkolili akavya na wogohi, akahegelela peavi Yesu kuni ivagaya, ndi akamfugamilila Yesu akamjovela goha kwa uchakaka. ");
INSERT INTO xnj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu akamjovela, “Msikana wangu, sadika yaku yikulamisi, uhambayi na uteke, utamu waku ulamili.” ");
INSERT INTO xnj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu palongelayi na mundu yula, lukumbi lulalula vakabwela vajumbi kuhuma kunyumba ya Yailo chilongosi wa nyumba ya kukonganekela Vayawudi akamjovela. “Msikana waku afwili, kyani kumung'aha Muwula?” ");
INSERT INTO xnj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu agayuwini malovi gala, nambu agavevisi akamjovela mkulu wa nyumba ya kukonganekela Vayawudi yula, “Kotoka kuvya na wogohi, yendelela kusadika.” ");
INSERT INTO xnj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ayidakili lepi kulongosana na mundu yoyoha nambu Petili na Yakobo na Yohani muhaja wa Yakobo. ");
INSERT INTO xnj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pavahikili kunyumba ya Yailo, Yesu avayuwini vandu vivembeneka neju ndava ya malilu. ");
INSERT INTO xnj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Akayingila mugati akavajovela, “Ndava kyani mwiywanga na kuvemba? Msikana uyu afwili lepi, pena agonili ndu.” ");
INSERT INTO xnj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nambu vene vakamuheka. Akavahumisa kuvala vandu voha vevavi mugati mula, akavatola dadi na nyina wa msikana yula, pamonga na vawuliwa vaki vadatu, ndi vakayingila muchumba cheavili msikana yula. ");
INSERT INTO xnj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akamkamula chiwoko, akamjovela, “Talita, kumu,” Mana yaki, “Wamsikana, nikujovela yimuka!” ");
INSERT INTO xnj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bahapo msikana yula akayimuka na kutumbula kugenda, vandu voha vakakangasa neju. Msikana mwenuyo avi na miyaka kumi na yivili. ");
INSERT INTO xnj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nambu Yesu akavabesa vakotoka kumjovela mundu yoyoha yula. Akavajovela vampela chakulya alyayi. ");
INSERT INTO xnj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu na vawuliwa vaki, vakawuka penapo vakahamba kuchijiji chaki cha ku Nazaleti. ");
INSERT INTO xnj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ligono la Kupumulila, atumbwili kuwula munyumba ya kukonganekela Vayawudi. Vamahele vevamuyuwini vakangisi, vakajova, “Wu, agapatili koki mambu aga geijova? Apatili koki luhala ulu? Kavili ikita wuli gachinamtiti? ");
INSERT INTO xnj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wu, mwenuyu lepi selemala, mwana wa Maliya na mlongo wavi Yakobo na Yose na Yuda na Simoni? Wu, valumbu vaki titama nawu lepi bahapa?” Ndi vakabela kumsadika. ");
INSERT INTO xnj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu akavajovela, “Mlota wa Chapanga itopeswa kila pandi, lepi kunyumba yaki, kwa valongo vaki na pamulima waki.” ");
INSERT INTO xnj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ndava yeniyo Yesu akitili lepi mambu gachinamtiti pala, ndi avavikili mawoko vatamu vadebedebe akavalamisa. ");
INSERT INTO xnj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akangisi neju ndava ya vandu vangasadika. Kangi Yesu avigendalili muhijiji ya papipi na kuvawula vandu. ");
INSERT INTO xnj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akavakemela vawuliwa kumi na vavili, akatumbula akavatuma vandu vavili vavili, akavapela uhotola wa kuvinga mizuka. ");
INSERT INTO xnj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akavalagiza akajova, “Kwemwihamba uko, mukotoka kugega chindu chochoha chila ndonga ndu, lepi chakulya, lihaku, amala mashonga pachilolo. ");
INSERT INTO xnj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muwala champali nambu mkotoka kugega ligwanda lingi.” ");
INSERT INTO xnj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Akavajovela, “Nyumba yeyoha yevakuvapokela mutama bahapo mbaka pa ligono lemuwuka. ");
INSERT INTO xnj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kwa vandu vevibela kuvapokela amala kuvayuwanila, penapo ndi muwuka na muvakung'undila lububu lwavi, kulangisa kuvya vene vaubeli ujumbi wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hinu, vakawuka penapo vakahamba kuvakokosela vandu vamuwuyila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vakayivinga mizuka vamahele. Na kuvanyala mahuta ga zeituni vatamu vamahele, vakavalamiswa. ");
INSERT INTO xnj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nkosi Helodi agayuwini goha, muni malovi ga Yesu gayenili pandi zoha. Vandu vangi vajovayi mwenuyu, “Ndi Yohani Mbatizaji ayukili! Ndava muni ihenga gachinamtiti.” ");
INSERT INTO xnj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vangi vakajova, “Mwenuyu ndi Eliya.” Vangi vakajova, “Mwenuyu ndi mmonga wa valota va Chapanga va kadeni.” ");
INSERT INTO xnj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nambu Helodi peayuwini malovi gala akajova, “Yohani namdumwili mutu, hinu ayukili!” ");
INSERT INTO xnj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aholalili genago ndava mu magono ga mumbele, Helodi alagazili Yohani akamuliwa na kukungiwa muchifungu. Genago gahumalili ndava Helodi amgegili Helodiya mdala wa Filipi mweavi mlongo waki. ");
INSERT INTO xnj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohani amjovelayi Helodi, “Chabwina lepi veve kumtola mdala wa mlongo waku.” ");
INSERT INTO xnj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hinu Helodiya, mweavi mdala wa nkosi, amuhakalili neju Yohani, akagana kumkoma, nambu ahotwili lepi. ");
INSERT INTO xnj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helodi amuyogwipi Yohani muni amanyili kuvya Yohani ndi mundu wa msopi na mbwina. Ndava yeniyo amyangalili. Helodi aganayi kumuyuwanila Yohani, pamonga amyuwanili mtima wamvinili. ");
INSERT INTO xnj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ligono limonga mdala wa nkosi apatili fwasi pa ligono la kukumbukwa kwa kuvelekewa Helodi. Hinu akavakemela vagogo va libanji na vachilongosi va Galilaya pamonga na vakulu va manjolinjoli. ");
INSERT INTO xnj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hinu msikana waki Helodiya, akayingila na kutumbula kukina ngo'ma. Hinu akavahekesa neju Helodi na vayehe vaki. Nkosi akamjovela msikana yula, “Uniyupa chindu chochoha chila na nene yati nikupela.” ");
INSERT INTO xnj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kavili akamlapakisa, akamjovela, “Chochoha cheukuniyupa, yati nikupela, hati ngati kugavana upinga wa unkosi wangu.” ");
INSERT INTO xnj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Penapo msikana yula akawuka mugati mu libanji, akahamba kumkota nyina waki. “Wigana niyupa kyani?” Namwene akamyangula, “Mutu wa Yohani Mbatizaji.” ");
INSERT INTO xnj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Msikana yula akawuya kanyata kavili kwa nkosi, akamjovela, “Nigana unipela hinu naha mulupalu mutu wa Yohani Mbatizaji.” ");
INSERT INTO xnj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nkosi peayuwini genago, akavya ngolongondi, nambu muni ajilapakisi mwene, na ndava ya vayehe vaki, ahotwili lepi kumbelelela msikana yula ndi akamyidikila. ");
INSERT INTO xnj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hinu, akamlagiza linjolinjoli akaleta mutu wa Yohani. Linjolinjoli akahamba kuudumula mutu wa Yohani muchifungu mula, ");
INSERT INTO xnj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kangi amletili mutu wula mulupalu akampela msikana, namwene akampelekela nyina waki. ");
INSERT INTO xnj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Vawuliwa va Yohani pevayuwini vakahamba kutola higa yaki vakahamba kuzika. ");
INSERT INTO xnj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vamitumi vakawuya mulugendu lwavi vakamjovela Yesu, mambu goha gavakitili na chavawulili vandu. ");
INSERT INTO xnj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Vandu vamahele neju vabwelayi na kuwuka kwa Yesu, ndi mbaka fwasi ya kulya yavi lepi. Hinu Yesu akavajovela vawuliwa, “Tihamba kuchiyepela mukapumulila padebe.” ");
INSERT INTO xnj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hinu, vakawuka ngavene muwatu vakahamba kuchiyepela. ");
INSERT INTO xnj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nambu vandu vamahele vavaweni pavawukayi, vakavamanya. Ndi vakalongolela kuhika kula kwa magendelu kweahambayi Yesu na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu na vawuliwa vaki pevahulwiki muwatu kumbwani, ndi auweni msambi uvaha wa vandu, akaviniswa mtima, muni vavi ngati limbelele langali mdimaji. Akatumbula kuvawula mambu gamahele. ");
INSERT INTO xnj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lilanga palatipimi, ndi vawuliwa vaki vakahamba kumjovela Yesu, “Penapa palugangatu, lilanga litipama. ");
INSERT INTO xnj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbanga uvalaga vandu vahamba mumigunda na muhijiji ya papipi, vakagula vyakulya.” ");
INSERT INTO xnj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu akavajovela, “Muvapela nyenye chakulya.” Nambu vene vakamkota, “Tivapela kyani? Yati yikutigana tihenga lihengu kwa miyehi yamahele ndi tipatayi mashonga ga kuvagulila chakulya vandu voha ava?” ");
INSERT INTO xnj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu akavakota, “Mabumunda gavi galinga? Muhamba mukalola.” Pevamali kulola vakawuya kumjovela, “Yivii mhanu na somba zivili.” ");
INSERT INTO xnj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu akavalagiza vawuliwa vaki vavatamika vandu voha chikundi chikundi pahi pamanyai. ");
INSERT INTO xnj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Hinu vene vakatama chikundi chikundi, vingi vandu hamsini, na vingi vandu miya. ");
INSERT INTO xnj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kangi Yesu akagatola mabumunda mhanu na somba zila, akalola kunani kwa Chapanga, akamsengusa Chapanga. Ndi akagametula mabumunda gala pamonga na somba zila. Akavapela vawuliwa vaki muni vavagavanisila vandu. ");
INSERT INTO xnj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Vandu voha vevavi penapo valili vakayukuta. ");
INSERT INTO xnj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Hinu, vakanonga masigalilu ga mabumunda na somba vakamemesa madengu kumi na gavili. ");
INSERT INTO xnj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Vevalili chakulya chila, vavi vagosi elufu mhanu. ");
INSERT INTO xnj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahapo Yesu akavalagiza vawuliwa vaki vayingila muwatu valongolela kuhamba kumwambu ya nyanja, kumuji wa Betisaida. Muni mwene avi akona ilagana na msambi wa vandu. ");
INSERT INTO xnj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hati peamali kulagana na vandu, akahamba kuchitumbi kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lilanga palatipimi, Yesu avi mwene kundumba na watu wamali kuhika pagati ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mwene avaweni vawuliwa chaving'ahika muwatu mula na mipundi muni mpungu wavi uvaha ukuvawuyisa mumbele. Hinu hambakucha, Yesu avahegalili kuni igenda mumanji akagana kuvapita. ");
INSERT INTO xnj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nambu pavamuweni igenda panani ya manji vayogwipi, vaholali kuvya lihoka, “Vakaywanga mulete.” ");
INSERT INTO xnj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Voha pavamuweni vayogwipi neju. Bahapo Yesu akajova nawu, “Mjipolesa mtima. Ndi nene. Mkoto kuyogopa!” ");
INSERT INTO xnj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ndi, akayingila muwatu wevavili vawuliwa na mpungu wa luyuga lukaguna lukumbi lulalula. Vawuliwa vakakangasa neju, ");
INSERT INTO xnj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ndava muni vamanyili lepi mana chinamtiti cha kuyonjokeseka chakulya chila ndava ya kunonopa kwa mitima yavi. ");
INSERT INTO xnj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Vakakupuka nyanja, vakahika kumuji wa ku Genezaleti vakahuyimika watu. ");
INSERT INTO xnj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pevahumili muwatu mula, kanyata vandu vakammanya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hinu, kanyata vakahamba kila chijiji pandu pala, vakatumbula kuvatola vatamu vevagonili mumipasa, vakavapeleka kila pevayuwini Yesu avili. ");
INSERT INTO xnj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pandu poha peahambili Yesu, muhijiji na mumiji na mumigunda, vandu vavavikili vatamu pandu pakugulisila vindu, vandu vakamuyupa neju avayidakila vatamu vala, vapamisayi lugunyilu lwa nyula yaki. Ndi voha vevampamisi valamili. ");
INSERT INTO xnj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kangi Vafalisayu vangi na Vawula va Malagizu vevahumili ku Yelusalemu valundumini palongolo ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Vavaweni vawuliwa vangi va Yesu vilya chakulya kwa mawoko changasamba ngati cheyiganikiwa na malagizu. ");
INSERT INTO xnj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Muni Vafalisayu na Vayawudi vangi vayovalili kulanda mivelu ya vagogo wavi, muni valyayi lepi changasamba mawoko bwina. ");
INSERT INTO xnj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kavili vakagula chakulya kuhuma pandu pakugulisila vindu, vilya lepi mbaka vasanja hoti. Mewa vavi na mivelu yingi ya namuna ya kusanja vikombi na viviga na vyombo ya shaba. ");
INSERT INTO xnj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hinu, Vafalisayu na Vawula va Malagizu vangi vakamkota Yesu, “Ndava kyani vawuliwa vaku vilanda lepi mambu ga kadeni kuhuma kwa vagogo vitu, ndava vilya changasamba mawoko?” ");
INSERT INTO xnj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu akavayangula, “Vandu mwavahomela! Isaya mweavi Mlota wa Chapanga, alotili chakaka kuvavala nyenye peayandiki, ‘Chapanga ijova, vandu venava vakunitopesa kwa malovi ndu, nambu mitima yavi yivii kutali na nene. ");
INSERT INTO xnj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kunigundamila kwavi chindu lepi, muni mambu geviwula ndi malagizu ga vandu ndu. Ngati malagizu ga Chapanga.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nyenye mulekili mihilu ya Chapanga na kukamulila mawuliwu ga vandu.” ");
INSERT INTO xnj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu akayendelela kujova, “Nyenye mumanyili kuyepa cha kuchenjela mihilu ya Chapanga na kulanda mivelu yinu! ");
INSERT INTO xnj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muni Musa alagizi, ‘Muvatopesa dadi waku na nyina waku,’ Na, ‘Mweakumliga dadi waki amala nyina waki, yikumugana akomiwa.’ ");
INSERT INTO xnj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nambu nyenye muwula, ngati mundu avi na chindu chakumtangatila dadi waki amala nyina waki, nambu akajova, chindu chenicho ndi ‘Kolibani,’ Mana yaki njombi kwa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","hinu yikumugana lepi kumtangatila dadi waki amala nyina waki. ");
INSERT INTO xnj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chenichi ndi chemukulivevesa Lilovi la Chapanga ndava ya mawuliwu ga kuhalilana. Kangi mkita mambu gamahele ngati genago.” ");
INSERT INTO xnj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu aukemili kangi msambi wa vandu, akavajovela, “Muniyuwanilayi mwavoha na kumanya malovi aga. ");
INSERT INTO xnj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kawaka chakulya cheilya mundu chechihotola kumuhakasa palongolo ya Chapanga. Nambu mambu gegihuma mugati ya mundu ndi gegihotola kumuhakasa. ");
INSERT INTO xnj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mweavi na makutu ga kuyuwana na amanyayi!” ");
INSERT INTO xnj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Paaulekili msambi wa vandu na kuyingila mu nyumba, vawuliwa vaki vakamkota mana ya luhumu lula. ");
INSERT INTO xnj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mwene akavajovela, “Wu, hati nyenye mwimanya lepi? Kawaka chakulya chechikumyingila mundu chihotola lepi, kumuhakasa mundu palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ndava muni chikumyingila lepi mumtima, nambu mulileme, kangi chihumiswa kundindima.” Ndava ya kujova chenicho Yesu ayidikili vyakulya vyoha viliwayi. ");
INSERT INTO xnj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu akayendelela kujova, “Chechihuma mumtima wa mundu chihotola kumuhakasa palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Muni mugati ya mumtima wa mundu, gihuma maholo gahakau, ukemi na kuyiva na kukoma, ");
INSERT INTO xnj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ugoni na unota na udese na uhakau na kuyiva na kunogela vindu vya vangi na luhonda na wihu na ng'omo na uyimu na maligu. ");
INSERT INTO xnj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gahakau goha ago gihuma mumtima wa mundu, genago ndi gakumhakasa mundu palongolo ya Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu awukili penapo akahamba kumuji wa Tilo. Kwenuko ayingili munyumba yimonga, mwene aganili lepi mundu amanyayi kuvya avili mugati, nambu ahotwili lepi kujifiya. ");
INSERT INTO xnj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mdala mmonga, msikana waki avili na mzuka, peayuwini malovi ga Yesu, kanyata akabwela akafugama palongolo ya magendelu ga Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mdala mwenuyo, avi Mgiliki, ndi mkolonjinji wa muji wa Foinike mulima wa ku Silia. Hinu akamuyupa Yesu amuwusa mzuka msikana waki. ");
INSERT INTO xnj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu akavajovela, vana vayukuta hoti, “Chabwina lepi kutola chakulya cha kuvayukutisa vana na kugatagila mabwa.” ");
INSERT INTO xnj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nambu mdala yula akamyangula, “Chakaka, Bambu, hati mabwa gegavi pahi ya meza gilya masigalilu ga chakulya cha vana.” ");
INSERT INTO xnj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu akamjovela, “Ndava ya lilovi lenilo, wuyayi kunyumba yaku. Mzuka umuwukili msikana waku!” ");
INSERT INTO xnj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hinu, akahamba kunyumba yaki, amkolili msikana waki agonili palusongwani, na mzuka wamali kumuwuka. ");
INSERT INTO xnj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kangi Yesu akawuka kumuji wa Tilo, akapitila pagati ya ku Sidoni, akahamba mbaka kunyanja ya Galilaya kuvedukila pamulima wa Dekapoli mana yaki miji kumi. ");
INSERT INTO xnj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ndi vakamletela ngayuwa nambu mewawa avi ngajova kwa Yesu, vakamuyupa amvikilayi mawoko muni amlamisa. ");
INSERT INTO xnj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu akamvika pamuhana na msambi wa vandu mundu uyo. Akamsopa ngonji mumakutu. Kangi akahunya mata mulungoji lwaki na kumpamisa mululimi lwa mundu yula. ");
INSERT INTO xnj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kangi Yesu akalola kunani kwa Chapanga, akakeka kwa likakala, akamjovela, “Efata,” Mana yaki “Dindukayi.” ");
INSERT INTO xnj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lukumbi lulalula akatumbula kuyuwana bwina, mewawa lulimi lwaki lukajova bwina. ");
INSERT INTO xnj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu akavalagiza vakotoka kumjovela mundu lijambu lila. Nambu cheayonjokisi kuvabesa, ndi chevadandisi malovi gala. ");
INSERT INTO xnj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Vandu vakangisi neju, vakajova, “Avakitili goha gabwina hati vangayuwa kuyuwana, na vangajova kujova!” ");
INSERT INTO xnj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lukumbi lwenulo, msambi uvaha wa vandu wakonganiki kavili hinu vavi lepi na chakulya, na Yesu avakemili vawuliwa vaki, akavajovela, ");
INSERT INTO xnj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nikuvahengela lipyana vandu venava muni vatamii na nene mu ligono la datu, nambu vavi lepi na chakulya. ");
INSERT INTO xnj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ngati nikavajovela vawuya kunyumba na njala yati vihinduka munjila, muni vangi vahumili kutali.” ");
INSERT INTO xnj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vawuliwa vaki vakamkota, “Penapa palugangatu yati tipata koki mabumunda ga kuvayukutisa vandu voha ava?” ");
INSERT INTO xnj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu akavakota, “Muvi na mabumunda galinga?” Vakamyangula. “Gavii saba.” ");
INSERT INTO xnj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Hinu, akavalagiza vandu vatama pahi. Akagatola mabumunda gala saba, akamsengusa Chapanga, akayimetula, akavapela vawuliwa vaki vavagavanisilayi vandu, navene vakavagavila. ");
INSERT INTO xnj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vavi mewa na somba zidebedebe. Yesu akayimotisa, mewawa akalagazila vawuliwa vaki vavagavila vandu. ");
INSERT INTO xnj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Vandu valili na kuyukuta. Kangi vawuliwa vakanonga masigalilu na kumemesa madengu saba. ");
INSERT INTO xnj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Vandu vevalili vavi ngati elufu mcheche. Yesu peamali kuvalaga, ");
INSERT INTO xnj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Bahapo Yesu akayingila muwatu pamonga na vawuliwa vaki, vakahamba kumulima wa Dalimanuta. ");
INSERT INTO xnj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vafalisayu vangi vakambwela na kutumbula kujovesana na Yesu. Vamlingili, vamganayi avalangisa ulangisu kuhuma kunani kwa Chapanga, kulangisa kuvya uhotola waki uhumili kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nambu Yesu mtima wamvinili neju na akajova, “Ndava kyani vandu va chiveleku ichi vigana ulangisu? Chakaka nikuvajovela, vandu va chiveleku ichi vipewa lepi ulangisu!” ");
INSERT INTO xnj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kangi akavaleka akayingila kavili muwatu, akakupuka kuhamba kumwambu ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vawuliwa vakosiwi kutola mabumunda yamahele, ndi vavi na libumunda limonga ndu muwatu. ");
INSERT INTO xnj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu akavalagiza, “Mlola neju! Mjiyangalila na ngemeku ya Vafalisayu na ngemeku ya Helodi.” ");
INSERT INTO xnj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Vawuliwa vakatumbula kukotana vene kwa vene, “Ijova chenichi ndava tangali mabumunda.” ");
INSERT INTO xnj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu agamanyili gala gevajovisini akavajovela, “Ndava kyani mkotana ndava ya mabumunda? Wu, mwakona mwangamanya amala mwangalola? Wu, ndava kyani mwiholalela lepi? ");
INSERT INTO xnj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna mihu nambu mwilola lepi? Muvi na makutu nambu mwiyuwana lepi? Wu, mukosiwi ");
INSERT INTO xnj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","lukumbi lula panakametwili mabumunda mhanu na kuvapela vandu elufu mhanu mwamemisi masigalilu madengu galinga?” Vakamyangula, “Madengu kumi na gavili.” ");
INSERT INTO xnj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Akavakota kavili, “Na panametwili mabumunda saba na kuvapela vandu elufu mcheche mwamemisi masigalilu madengu galinga?” Vene vakamyangula, “Madengu saba.” ");
INSERT INTO xnj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Hinu, akavajovela, “Pamonga na ago, wu, mwakona mwangamanya?” ");
INSERT INTO xnj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu ahikili ku Betisaida pamonga na vawuliwa vaki. Kwenuko vandu vakamletela ngalola, vakamuyupa ampamisa muni amlamisa. ");
INSERT INTO xnj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu amkamwili chiwoko ngalola yula, ampeliki kuvala ya chijiji. Akamhunyila mata mumihu, akampamisa mawoko, akamkota “Wu, wihotola kulola chindu?” ");
INSERT INTO xnj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngalola yula akalola, akajova “Nikuvalola vandu vevilolekana ngati mikongo yeyigenda.” ");
INSERT INTO xnj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kangi Yesu akampamisa kavili mawoko mumihu, mwene akamuhutusila mihu, uhotola waki wa kulola ukamuwuyila namwene akalola. ");
INSERT INTO xnj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu akamjovela awuya kunyumba yaki na kumlagiza “Ukotoka kuwuya ku Betisaida.” ");
INSERT INTO xnj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kangi Yesu na vawuliwa vaki vahambili kuvijiji vya pandu ku Kaisalia Filipi. Pevavi munjila, Yesu akavakota vawuliwa vaki, “Vandu vijova nene ndi nayani?” ");
INSERT INTO xnj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vakamyangula, “Vangi vijova veve ndi Yohani Mbatizaji na vangi vijova veve ndi Eliya na vangi vijova veve ndi mmonga wa Valota va Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kangi Yesu akavakota, “Na nyenye mwijova nene kuvya ndi yani?” Petili akamyangula, “Veve ndi Kilisitu, mweuhaguliwi na Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kangi Yesu akavalagiza vakotoka kumjovela mundu yeyoha kuvya mwene ndi Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kangi Yesu atumbwili kuvawula vawuliwa vaki, kuvya yikumgana “Mwana wa Mundu kung'ahika na kubelelewa na vagogo na vakulu va kuteta na Vawula va Malagizu. Kangi yati ikomiwa, nambu pa ligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu avajovili lijambu lenilo hotohoto. Penapo, Petili akamtola pamuhana akatumbula akamhakalila akotoka kujova mambu ago. ");
INSERT INTO xnj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nambu Yesu akang'anamuka akavalolokesa vawuliwa vaki, akamhakalila Petili, akamjovela, “Setani, wuka palongolo yangu! Maholo gaku gihuma lepi kwa Chapanga, nambu ga umundu.” ");
INSERT INTO xnj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kangi Yesu akaukemela msambi wa vandu na vawuliwa vaki akavajovela, “Ngati mundu yeyoha igana kunilanda nene yikumgana ajibela mwene na agega msalaba waki anilandayi. ");
INSERT INTO xnj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndava mundu mweigana kusangula wumi waki, yati akuuyagisa, nambu mundu mweakuuyagisa wumi waki ndava ya nene na ndava ya Lilovi la Bwina, yati akuusangula. ");
INSERT INTO xnj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wu, chiyonjokeseka kyani mundu kupata mulima woha na kuuyagisa fwasi ya kuyingila muwumi wa magono goha? ");
INSERT INTO xnj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mundu yati iwusa chindu kiki muni apatayi wumi wa magono goha? ");
INSERT INTO xnj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ngati mundu yeyoha muvandu va chiveleku ichi chihakau na chechimbudili Chapanga ngati ikola soni kwa nene na malovi gangu, Mwana wa Mundu yati akumulolela soni mundu mwenuyo, lukumbi peibwela muukulu wa Dadi waki pamonga na vamitumu va kunani kwa Chapanga vamsopi.” ");
INSERT INTO xnj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akayendelela kuvajovela, “Chakaka nikuvajovela, vavi vandu vangi penapo yati vifwa lepi changamlola Chapanga ilongosa kwa makakala munjila ndalindali.” ");
INSERT INTO xnj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pegamaliki magono sita, Yesu avatolili Petili na Yakobo na Yohani vene ndu kuhamba kunani ya chitumbi. Kwenuko Yesu ndi agewiki pamihu palongolo yavi. ");
INSERT INTO xnj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nyula zaki yang'asimi yikavya yamsopi pehe, avi lepi mchapa nyula yeyoha pamulima mweihotola kuganyambisa ngati ago. ");
INSERT INTO xnj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kangi vawuliwa vadatu vala vavawene Eliya na Musa vilongela na Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petili akamjovela Yesu, “Muwula wangu, chabwina tete kuvya bahapa. Mbanga tete tijenge vindanda vidatu. Chimonga cha veve na chingi cha Musa na chingi cha Eliya.” ");
INSERT INTO xnj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Amanyili lepi chakujova, ndava mwene na vayaki wogohi wavayingili. ");
INSERT INTO xnj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kangi likahumila lihundi likavagubika, na lwami lukayuwanika kuhuma mulihundi mula, “Mwenuyu ndi Mwana mwenimganili, mumyuwanila.” ");
INSERT INTO xnj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bahapo vawuliwa vala vakalola kuni na kuni, nambu vamuwene lepi mundu yeyoha, nga Yesu pamonga na vene. ");
INSERT INTO xnj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hinu, pavahelelayi kuchitumbi, Yesu akavabesa vakotoka kumjovela mundu mambu gevagaweni mbaka Mwana wa Mundu peiyuka. ");
INSERT INTO xnj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Vakakamula malagizu gala, nambu vakatumbula kukotana vene kwa vene, “Kuyuka mana yaki kyani?” ");
INSERT INTO xnj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kangi vakamkota Yesu, “Ndava kyani Vawula va Malagizu vijova yiganikiwa hoti Eliya abwela?” ");
INSERT INTO xnj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mwene akavayangula, “Ena, Eliya ibwela hoti kutendelekela kila chindu. Pamonga na ago, ndava kyani yiyandikiwi mu Mayandiku Gamsopi kuvya Mwana wa Mundu gakumkolela mang'ahiso neju na kuveveswa? ");
INSERT INTO xnj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nambu nikuvajovela, Eliya amali kubwela, na vene vakamkitili chavaganili ngati Mayandiku Gamsopi chegijova kumvala mwene.” ");
INSERT INTO xnj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lukumbi Yesu na vawuliwa vadatu pavawuyili pandu pevavi vawuliwa vangi vala. Vauweni msambi uvaha wa vandu pamonga na Vawula va Malagizu vijovesana. ");
INSERT INTO xnj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bahapo msambi wa vandu pawamuweni Yesu, vakakangasa neju, vakamjumbalila na kumjambusa. ");
INSERT INTO xnj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu akavakota vawuliwa, “Mjovesana nawu kyani?” ");
INSERT INTO xnj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Penapo mundu mmonga mu msambi wa vandu wula akamyangula, “Muwula, nimletili mwana vangu mweavi na mzuka weumkita kuvya ngajova. ");
INSERT INTO xnj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila peukumkamula ukumgwisa pahi na kumuhumisa lihuluhulu mumlomo, kuni iyaga minu na kuvya myumu higa yoha. Nivayupili vawuliwa vaku vauvinga mzuka wenuwo nambu vahotwili lepi.” ");
INSERT INTO xnj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu akavajovela, “Mwe vandu va chiveleku changali sadika! Yati nitama na nyenye mbaka ndali? Nikuvasindimalila hati ndali? Mumleta kwa nene.” ");
INSERT INTO xnj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Vampeliki msongolo kwa Yesu. Kanyata mzuka wula paumuweni Yesu, wamuhindwisi mwana yula na kumgwisa pahi akabilinduka na kuhuma lihuluhulu mumlomo. ");
INSERT INTO xnj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu akamkota dadi wa msongolo yula, “Mambu genaga gampatili ndali?” Akamyangula, “Gatumbwili kuhuma uwana waki. ");
INSERT INTO xnj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lukumbi lungi mzuka uwu ukumgwisa pamotu na mumanji, muni umkomekesa. Hinu ngati uhotola utihengela lipyana na kutitangatila!” ");
INSERT INTO xnj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akamjovela, “Ukotoka kujova, ‘Ngati nihotola?’ Mambu goha gihotoleka kwa mundu mweisadika.” ");
INSERT INTO xnj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Penapo dadi yula akajova kwa lwami luvaha, “Nisadika, nambu sadika yangu yidebe! Nitangatilayi, sadika yangu yiyonjokesa!” ");
INSERT INTO xnj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pauweni msambi wa vandu wiyonjokeseka kanyata palongolo yaki, akauhakalila mzuka wula, “Mzuka weukumkita mwana kuvya ngayuwa na ngajova, nikulagazila muwukayi mwana uyu kotoka kumyingila kavili!” ");
INSERT INTO xnj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Penapo mzuka wula ukakwesa lwami, ukamgwisa mwana yula pahi na kumuwuka. Mwana awonikini ngati mtuhi, ndi vangi vakajova, “Afwili!” ");
INSERT INTO xnj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nambu Yesu akamkamula chiwoko, akamyinula namwene akayima. ");
INSERT INTO xnj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Hinu Yesu peayingili mu nyumba, vawuliwa vaki vakamkota pachiepela, “Ndava kyani tete tahotwili lepi kuvinga mzuka wula?” ");
INSERT INTO xnj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mwene akavajovela, “Mzuka ngati wenuwu uhotoleka lepi kuwusiwa ndu, nambu kwa njila ya kumuyupa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na vawuliwa vaki vakawuka penapo na kuyendelela na lugendu lwavi kuvedukila mulima wa ku Galilaya. Yesu aganili lepi mundu yeyoha amanyayi kweavili, ");
INSERT INTO xnj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ndava muni avawulayi vawuliwa vaki. Avajovili, “Mwana wa Mundu yati igotolewa kwa vandu vevakumkoma, nambu pa ligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nambu vawuliwa vamanyili lepi mana ya mawuliwu gala. Ndi vakayogopa kumkota. ");
INSERT INTO xnj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hinu, vakahika muji wa Kapelanaumu na kuyingila mu nyumba, Yesu akavakota vawuliwa vaki, “Mwajovisini kyani munjila?” ");
INSERT INTO xnj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nambu vene vakaguna, muni munjila vakalikotana yani mweavi mkulu pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu akatama pahi na kuvakemela vawuliwa kumi na vavili vala, akavajovela, “Mundu akagana kuvya mkulu ndi yikumgana avyai mdebe kavili avyai mtumisi wa voha.” ");
INSERT INTO xnj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ndi akamtola mwana mdebe akamyimika pagati yavi akamkumbatila kangi akavajovela, ");
INSERT INTO xnj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mweakumpokela mwana ngati uyu ndava ya nene, akunipokela nene, na mweakunipokela nene, akunipokela lepi namwene ndu, nambu akumpokela mewa na yula mweanitumili.” ");
INSERT INTO xnj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohani akamjovela Yesu, “Muwula, tamuweni mundu mmonga ivinga mizuka kwa kuhengela liina lako, tikambesa, muni lepi wa chikundi chitu.” ");
INSERT INTO xnj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nambu Yesu akavajovela, “Mkoto kulinga kumbesa, ndava avi lepi mundu mweihenga gachinamtiti kwa liina langu, na bahapo akatumbula kunilongalela gahakau.” ");
INSERT INTO xnj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndava mundu mweangapingana na tete avili upandi witu. ");
INSERT INTO xnj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chakaka nikuvajovela, mundu yeyoha mweakuvapela nyenye chikombi cha manji ga kunywa, ndava nyenye vandu va Kilisitu, chakaka yati ipata njombi yaki. ");
INSERT INTO xnj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ngati mundu yeyoha akumyokesa mmonga wa vadebe ava kuyagisa sadika yaki, ndi mbanga mundu mwenuyo kukungiwa liganga livaha la kuyagila musingu yaki na kutagiwa munyanja kuliku kuhamuliwa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na chiwoko chaku ngati chikubudisa sadika yaku, chidumula! Mbanga kuyingila muwumi changali chiwoko chimonga, kuliku kuvya na mawoko gavili, na kuyingila, kumotu wangajimika magono goha. ");
INSERT INTO xnj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hinu mwenumo masomi gifwa lepi, wala motu waki wijimika lepi. ");
INSERT INTO xnj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na chigendelu chaku ngati chikakubudisai, chidumula! Mbanga kuyingila muwumi changali chigendelu chimonga kuliku kuvya na magendelu goha gavili na kutagiwa kumotu wangajimika magono goha. ");
INSERT INTO xnj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mwenumo masomi gifwa lepi na motu waki wijimika lepi. ");
INSERT INTO xnj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na lihu lako likayagisa sadika yaku litupulai! Ulitaga, mbanga kuyingila Muunkosi wa Chapanga na lihu limonga kuliku kuvya na mihu gavili na kutagiwa kumotu wangajimika wa magono goha. ");
INSERT INTO xnj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mwenumo, masomi gaki gifwa lepi na motu waki wijimika lepi. ");
INSERT INTO xnj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Muni kila mundu yati inyambiswa kwa motu ngati luteta cheyinyambiswa kwa mwinyu.” ");
INSERT INTO xnj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyu wabwina, nambu ngati iyagisi lunyong'onyo lwaki, yati iyonjokeswa na kyani?” “Muvya na mwinyu wa unkozi mugati yinu na kusindimalisa na uteke pagati yinu.” ");
INSERT INTO xnj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu awukili penapo akahamba kumuji wa Yudea, kumwambu ya mfuleni Yoludani. Msambi wa vandu wamuhambalili kavili, mwene akavawula ngati chayavili mvelu waki. ");
INSERT INTO xnj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Vafalisayu vangi vamhambalili vakamkota chakumlinga, “Wu, Malagizu ga Chapanga giyidakila mgosi kumleka mdala waki?” ");
INSERT INTO xnj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akavayangula, “Musa avalagizi kyani?” ");
INSERT INTO xnj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Vene vakajova, “Musa atiyidakili kuvya mgosi ihotola kumpela mdala waki balua na kumleka.” ");
INSERT INTO xnj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nambu Yesu akavajovela, “Musa ayidikili kuvayandikila Mihilu yeniyi, ndava ya unonopa neju wa kuwuliwa kwinu. ");
INSERT INTO xnj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nambu Musa ayandiki kutumbula kuwumbwa kwa mulima, Chapanga awumbili mgosi na mdala. ");
INSERT INTO xnj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ndava yeniyo mgosi yati akumleka dadi na nyina waki, yati iwungana na mdala waki, ");
INSERT INTO xnj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","navene vavili yati vivya higa yimonga. Hinu vene vavili lepi kavili, nambu higa yimonga. ");
INSERT INTO xnj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hinu, mundu akotoka kuchilekanesa chila cheachiwunganisi Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pevayingili kavili mu nyumba, vawuliwa vaki vakamkota ndava ya lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mwene akavajovela, “Mundu yeyoha mweakumleka mdala waki na kugega mdala yungi akumkitila ugoni. ");
INSERT INTO xnj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mewawa na mdala mweakumleka mngwana waki na kugegewa na mgosi yungi ikita ugoni.” ");
INSERT INTO xnj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Vandu vamletili Yesu vana vadebe avapamisa, nambu vawuliwa vaki vakavahakalila vandu vala. ");
INSERT INTO xnj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu paalolili genago akayoma akavajovela, “Mvaleka vana ava vabwela kwangu, mkotoka kuvabesa, muni Unkosi wa Chapanga ndi wa vandu ngati ava. ");
INSERT INTO xnj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chakaka nikuvajovela, mundu yeyoha mweangaupokela Ulongosi wa Chapanga ngati mwana mdebe katu iyingila lepi mwenumo.” ");
INSERT INTO xnj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kangi akavapokela vana vala akavavikila mawoko panani yavi, kuvamotisa. ");
INSERT INTO xnj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu paatumbwili lugendu, mundu mmonga ambwelili, akamfugamila na kumkota, “Muwula mbwina, nikita wuli muni nipokela wumi wa magono goha wangali mwishu?” ");
INSERT INTO xnj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu akamyangula, “Ndava kyani ukunikemela mbwina? Avi lepi mweavili mbwina ndi Chapanga ndu. ");
INSERT INTO xnj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uzimanyili ‘Amuli, ukotoka kukita ugoni na ukoto kukoma na ukoto kuyiva na ukoto kumjovela muyaku gaudese na ukoto kukonga na vatopesa dadi waku na nyina waku.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mwene akamyangula, “Muwula, genago goha nigakamwili kutumbula muusongolo wangu.” ");
INSERT INTO xnj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu akamlolakesa cha uganu, akamjovela, “Upungukiwi na chindu chimonga. Hamba ukagulisa kila chindu cheuvili nachu, uvapela vangangu mashonga ago, ndi veve yati ukujivikila vindu vyaku kunani kwa Chapanga. Kangi ubwela unilandayi.” ");
INSERT INTO xnj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mundu yula peayuwini genago, akavya ngolongondi akahamba kuni akwinyini pamihu muni avili na vindu vyamahele na aganili lepi kuwusa vindu vyaki. ");
INSERT INTO xnj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu akalola pandi zoha akavajovela vawuliwa vaki, “Chakaka yihotoleka lepi kwa vandu vana vindu vyamahele kumlekela Chapanga alongosa wumi wavi!” ");
INSERT INTO xnj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vawuliwa vakakangasa ndava ya malovi gala. Nambu Yesu akavajovela kavili, “Vana vangu mlola cheyinonopa neju kumlekela Chapanga alongosa wumi wavi! ");
INSERT INTO xnj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yihotoleka kuchikita chinyama chechikemiwa ngamiya kuholota mulibowo la sindanu, mewawa yilolekana, yati yinonopa neju kwa mundu mweavi na vindu vyamahele kumlekela Chapanga alongosa wumi waki!” ");
INSERT INTO xnj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Vawuliwa vaki vakayendelela kukangasa neju, hati vakakotana vene kwa vene, “Yani hinu mweihotola kusanguliwa?” ");
INSERT INTO xnj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu akavalola, akavajovela, “Kwa vandu yihotoleka lepi, nambu kwa Chapanga chenicho lepi. Kwa Chapanga kila chindu chihotoleka.” ");
INSERT INTO xnj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kangi Petili akajova, “Lola! Tete talekili vindu vyoha, tikukulanda!” ");
INSERT INTO xnj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu akayangula, “Chakaka nikuvajovela, mundu yeyoha mweailekili nyumba amala valongo amala valumbu amala mau amala dadi amala vana na migunda ndava yangu na ndava ya Lilovi la Bwina, ");
INSERT INTO xnj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yati ipokela mala miya ng'onyo mulukumbi lwa hinu. Yati ipokela nyumba na valongo na vahaja na valumbu na mau, pamonga na mang'ahiso. Na palukumbi lwelubwela yati ipokela wumi wa magono goha wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nambu vamahele vevavi vakulu hinu yati vivya vadebe na vamahele vevavi vadebe hinu yati vivya vakulu.” ");
INSERT INTO xnj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na vawuliwa vaki vavi mulugendu kuhamba ku Yelusalemu, mwene avalongolili. Vawuliwa vaki vakakangasa na vandu vevavalandayi vakavya na wogohi. Yesu akavatola kavili kuchiyepela vawuliwa kumi ni vavili, akatumbula kuvajovela gala gegakumkolela. ");
INSERT INTO xnj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akavajovela, “Muyuwanila! Tihamba ku Yelusalemu. Kwenuko Mwana wa Mundu yati vakumgotola mu mawoko ga vakulu va kuteta na Vawula va Malagizu, navene yati vakamhamula akomiwa na kumgotola kwa vandu vangali Vayawudi, ");
INSERT INTO xnj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","vene yati vakumvevesa, vakumuhunyila mata, yati vakumtova michapilu na kumkoma. Nambu pa ligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo na Yohani, vana va Zebedayo, vamuhambalili Yesu vakamjovela, “Muwula, tigana utihengela chindu chetikuyupa.” ");
INSERT INTO xnj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu akavakota, “Mwigana nivahengela kyani?” ");
INSERT INTO xnj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Vene vakamyangula, “Pewilongosa muukulu waku, utiyidakila kutama mmonga upandi waku wa kulyelela na yungi upandi waku wa kumangeya.” ");
INSERT INTO xnj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu akavajovela, “Mumanyi lepi chemwiyupa! Wu, yati mwihotola kunywelela chikombi cha mang'ahiso cheninywelela? Amala ubatizu ngati wenibatiziwi?” ");
INSERT INTO xnj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Vakamyangula, “Tihotola.” Yesu akavajovela, “Chikombi cha mang'ahiso cheninywelela chakaka yati mwinywelela na kavili yati mbatiziwa ngati chenibatiziwi. ");
INSERT INTO xnj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nambu uhotola wa kuhagula yani atama upandi wa kulyela amala kumangeya. Chapanga alavapela fwasi zenizo vala voha veavatendelekili.” ");
INSERT INTO xnj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Vawuliwa vangi kumi vala pevayuwini ago, vakavayomela vayavi Yakobo na Yohani. ");
INSERT INTO xnj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hinu Yesu akavakemela, akavajovela, “Mumanyili kuvya vala veviholalewa kuvya vakulu va milima vakuvalongosa vandu vavi kwa makakala na vakulu venavo vakuvatalalila vandu vavi. ");
INSERT INTO xnj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nambu kwinu yikoto kuvya chenichi, yula mweigana kuvya mkulu pagati yinu yikumgana avya mtumisi winu. ");
INSERT INTO xnj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mweigana kuvya mkulu kuliku voha, yikumgana avya mvanda wa voha. ");
INSERT INTO xnj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hati Mwana wa Mundu abwelili lepi kuhengewa nambu kuvahengela na kuwusa wumi waki uvya luhuna ndava ya kuvagombola vandu vamahele.” ");
INSERT INTO xnj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Vakahamba mbaka ku Yeliko. Yesu paawukayi pamuji wenuwo pamonga na vawuliwa vaki na msambi uvaha wa vandu. Ngalola mmonga mwana wa Timayo mweikemelewa Batimayo, atamili pamuhana ya njila, iyupa yala. ");
INSERT INTO xnj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Peayuwini kuvya Yesu wa ku Nazaleti ipita pandu pala, akatumbula kukwesa lwami, “Yesu, Mwana wa Daudi, unihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Vandu vamahele vakamlakali kumgunisa, nambu mwene akayonjokesa kukwesa lwami, “Mwana wa Daudi, unihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu akayima, akajova, “Mumkemela.” Hinu vakamkemela ngalola yula, vakamjovela, “Jipolesa mtima! Yima, akukemela.” ");
INSERT INTO xnj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batimayo akataga likoti laki, akahumba kanyata na kumhambila Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu akamkota, “Ugana nikukitila kyani?” Ngalola yula akamyangula, “Muwula, niyupa kulola.” ");
INSERT INTO xnj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu akamjovela, “Hamba, sadika yaku yikulamisi.” Bahapo ngalola yula akahotola kulola, akalongosana na Yesu munjila. ");
INSERT INTO xnj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na vawuliwa vaki pavavi papipi na Yelusalemu muji wa Betifage na Betania, papipi na Chitumbi cha Mizeituni. Penapo avatumili vawuliwa vaki vavili, ");
INSERT INTO xnj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akavajovela, “Muhamba kuchijiji chechivii palongolo yinu. Pemuyingila penapo yati mkumkolela mwanapunda akungiwi, na akona angahengewa na mundu. Mumuwopola mkamleta. ");
INSERT INTO xnj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ngati mundu akuvakota, ‘Ndava kyani muwopola lipunda?’ Mumjovela, ‘Bambu akumgana na yati akumuwuyisa mwanakandahi.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Hinu, vakahamba, vakamkolela mwanapunda akungiwi kuvala ya mlyangu wa nyumba yeyavi pamuhana ya njila. Pevamuwopolayi, ");
INSERT INTO xnj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vandu vangi vevayimili penapo vakavakota, “Ndava kyani muwopola mwanapunda?” ");
INSERT INTO xnj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vawuliwa vakavayangula ngati Yesu cheavalagizi na vene vakavaleka vahamba nayu. ");
INSERT INTO xnj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Vamletili Yesu mwanapunda. Pavamalili kuyambatisa nyula yavi panani ya mwanapunda yula. Yesu akatama panani yaki. ");
INSERT INTO xnj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Vandu vamahele vakadandasa nyula zavi munjila kwa kumtopesa, na vangi vakadandasa matutu gadebe gadebe gavadumwili mumigunda. ");
INSERT INTO xnj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Vandu voha vevalongolili na vala vevalandayi, vakakwesa lwami lwavi vakajova, “Alumbiwa! Amotisiwa mweibwela kwa liina la Bambu! ");
INSERT INTO xnj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Umotisiwa unkosi weubwela wa dadi witu Daudi. Chapanga alumbiwa mweavi kunani!” ");
INSERT INTO xnj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu ayingili pamuji wa Yelusalemu akahamba mbaka mu Nyumba ya Chapanga, akalola vindu vyoha kwa ubwina. Nambu yamali kuvya chitita akahamba ku Betania pamonga na vawuliwa vaki kumi na vavili vala. ");
INSERT INTO xnj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chilau yaki, pavahumili ku Betania, Yesu njala yamvinili. ");
INSERT INTO xnj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hinu auweni mkongo wa mtini chakutali wewavi na mahamba gamahele. Hinu akauhambila aganayi alolayi ngati upambiki matunda. Nambu peahikili, nakugakolela matunda ndi mahamba gene, muni yavi lepi lusenje lwa kupambika matunda. ");
INSERT INTO xnj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Penapo akaujovela mkongo wula, “Kutumbula lelu na magono goha mundu yeyoha akotoka kulya matunda gaku!” Na vawuliwa vaki vagayuwini malovi genago. ");
INSERT INTO xnj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hinu vahikili ku Yelusalemu, Yesu ayingili mu Nyumba ya Chapanga na kutumbula kuvavinga vandu vevagulisai na kugula vindu mwenumo. Azing'anambwisi meza za vala vevagulisana mashonga, na vigoda vya vandu vevagulisa ngunda. ");
INSERT INTO xnj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amyidakili lepi mundu yeyoha kuvedukila mu Nyumba ya Chapanga kuni agegili chindu. ");
INSERT INTO xnj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kangi akavawula, “Yiyandikwi, ‘Nyumba yangu yati yivya msambi wa vandu vevakumsadika Kilisitu ndava ya vandu milima yoha!’ Nambu nyenye mukuikita libokosela la vanyagaji!” ");
INSERT INTO xnj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Vakulu va kuteta na Vawula va Malagizu pevayuwini malovi gala, vakatumbula kulonda njila ya kumkoma. Nambu vayogwipi ndava msambi wa vandu wakangiswi mawuliwu gaki. ");
INSERT INTO xnj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kimihi payahikili, Yesu na vawuliwa vaki vakawuka pamuji wula. ");
INSERT INTO xnj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lukela pavapitayi, vauweni mkongo wa mkuyu wula uyumili hotohoto, kuhuma mumikiga mbaka kunani. ");
INSERT INTO xnj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petili alikumbwiki lijambu lila, akamjovela Yesu, “Muwula, lolayi! Mkongo wa mtini wewaupelili likoto ula uyumili!” ");
INSERT INTO xnj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu akavajovela, “Mumsadika Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nikuvajovela chakaka, mundu akachijovela chitumbi, ‘Tupukayi ukajitaga munyanja,’ Changali kuvya na wogoyi mumtima waki, nambu ngati isadika mambu goha gihengeka yati ihengewa lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ndava yeniyo nikuvajovela, pemukumuyupa Chapanga na kuyupa chindu, musadika kuvya mpokili, na nyenye yati mwipewa. ");
INSERT INTO xnj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pamwiyima kumuyupa Chapanga, mumlekekesa mundu yeyoha mweavakitili gahakau, ndi Dadi winu wa kunani avalekekesa nyenye mabudilu ginu. ");
INSERT INTO xnj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nambu ngati mukuvalekekesa lepi vangi, mewawa na Dadi winu mweavili kunani kwaki akuvalekekesa lepi nyenye mabudilu ginu.” ");
INSERT INTO xnj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Hinu, vahikili kavili ku Yelusalemu. Yesu paagendayi pa Nyumba ya Chapanga, vakulu va kuteta na Vawula va Malagizu na vagogo vamuhambalili, ");
INSERT INTO xnj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","vakamkota, “Ukita mambu genaga kwa uhotola wa yani? Yani mweakupelili uhotola wa kukita mambu genago?” ");
INSERT INTO xnj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nambu Yesu akavajovela, “Yati nikuvakota lijambu limonga. Mukaniyangula, na nene mewa yati nikuvajovela nikita mambu aga kwa uhotola wa Yani. ");
INSERT INTO xnj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wu, Yohani apatili uhotola wa kubatiza kuhuma kwa Chapanga amala kwa vandu? Munijovela.” ");
INSERT INTO xnj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Vakatumbula kukotana, “Tikayangula, ‘Gahumili kwa Chapanga,’ Yati akutikota, ndava kyani mwasadiki lepi? ");
INSERT INTO xnj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na tikayangula, ‘Gahumili kwa vandu,’ Yati yivya wuli?” Vayogwipi vandu, ndava vandu voha wamyidakili kuvya chakaka Yohani avi mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hinu vakamyangula Yesu, “Tete timanyili lepi.” Na Yesu akavajovela, “Na nene mewa nikuvajovela lepi nikita mambu aga kwa uhotola wa yani.” ");
INSERT INTO xnj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu akatumbula kulongela nawu, kwa luhumu akajova, mundu mmonga alimili mgunda wa mizabibu, Atindisili luwumba, na pagati yaki agimili ligodi la kuminyila divayi ajengili mnala, akalikodisha kwa valimaji, akahamba mulima wa kutali. ");
INSERT INTO xnj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lusenje lwa mabenu, amtumili mvanda waki kwa valimaji vala, akamletela pandu paki pa mabenu. ");
INSERT INTO xnj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nambu valimaji vala, vakamkamula mvanda yula, vakamtova vakamuwuyisa mawoko gawaka. ");
INSERT INTO xnj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mkolo mgunda amtumili kavili mvanda yungi. Mewa mwenuyo vakamulemasa kumutu na kumkitila mambu ga soni. ");
INSERT INTO xnj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mewawa, mkolo mgunda yula akamtuma mvanda yungi, mwenuyo vakamkoma. Vangi vamahele veavatumili, vangi pagati yavi vatoviwi na vangi vakomiwi. ");
INSERT INTO xnj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Asigalili mundu mmonga, ndi mwana waki chiganu. Pamwishu amtumili mwenuyo akajova, nimanyili yati vakumtopesa mwana vangu. ");
INSERT INTO xnj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nambu valimaji vala pavamuwene ibwela, vakajovesana, ‘Mwenuyu ndi mhali, ndi timkomayi muni uhali waki uvyai witu!’ ");
INSERT INTO xnj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Hinu vakamkamula, vakamkoma na kumtaga kuvala ya mgunda wa mizabibu wula.” ");
INSERT INTO xnj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Akavakota, hinu mkolo mgunda yati ikita kyani? Yati ibwela kuvakoma valimaji vala na kuvapela mgunda wa mizabibu wula vandu vangi.” ");
INSERT INTO xnj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wu, mwangasoma Mayandiku Gamsopi? Liganga levalibelili vakujenga, hinu ndi liganga lelikamulila nyumba. ");
INSERT INTO xnj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bambu ndi mweakitili lijambu lenili, lenili ndi lachinamtiti neju kwitu! ");
INSERT INTO xnj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Vachilongosi va Vayawudi na Vawula va Malagizu na vagogo, vamanyili kuvya luhumu wenuwo ukuvavala vene. Vaganili kumkamula, nambu vayogwipi msambi wa vandu. Vakamleka vakawuka. ");
INSERT INTO xnj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Vangi pagati ya Vafalisayu na valanda va chikundi cha Helodi vatumwili vamyonjola Yesu kwa malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Vamhambili, vakamjovela, “Muwula, timanyili kuvya veve wamundu wa chakaka mweujova chakaka. Veve ukumlola lepi mundu mwene ndi yani, ukulu wa mundu chindu lepi kwa veve, nambu wiwula chakaka munjila ya Chapanga. Wu, chabwina kulipa kodi kwa nkosi wa ku Loma amala lepi? Tilipayi amala tikotoka kulipa?” ");
INSERT INTO xnj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nambu Yesu amanyili uhomela wavi, akavajovela, “Ndava kyani mukunilinga? Muniletelayi lishonga lene nililolayi.” ");
INSERT INTO xnj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Vakampela lishonga lila, na mwene akavakota, “Pamihu na liina la yani?” Vakamyangula, “Vya nkosi wa ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hinu Yesu akavajovela, “Mumpelayi nkosi wa ku Loma vyevivili vyaki na mumpelayi Chapanga vyevivii vyaki.” Vakakangaswa nayu neju. ");
INSERT INTO xnj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kangi Vasadukayu vevijova kawaka kuyuka vamuhambalili Yesu vakamkota, ");
INSERT INTO xnj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Muwula, Musa atilagazili, mundu akafwayi na kuleka mdala changali mwana mlongo vaki yikumgana amuhala lipwela yula, ndi ambabakisila vana mlongo vaki. ");
INSERT INTO xnj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Leka tijova pavi na valongo saba. Mwealongolili kuvelekewa agegili afwili changaleka mwana. ");
INSERT INTO xnj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mbena waki akamuhala lipwela yula, namwene afwili changaleka mwana, yikavya mewawa na mlongo wa datu. ");
INSERT INTO xnj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Voha saba vafwili changaleka mwana. Kangi lipwela yula afwili. ");
INSERT INTO xnj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hinu ligono vandu paviyuka, mau yula yati ivya mdala wa yani? Ndava voha saba vamgegili.” ");
INSERT INTO xnj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akavayangula, nyenye mbudili ndava mmanyi lepi Mayandiku Gamsopi amala makakala ga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Muni vevafwili peviyuka yati vigega lepi amala kugegewa, yati vivya ngati vamitumu va kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nambu ndava ya kuyuka kwa vevafwili, msomili lepi chitabu cha Musa pandu pepivala dasi yeyiyaka motu? Chapanga amjovili Musa, nene ndi Chapanga wa Ibulahimu na Chapanga wa Izaki na Chapanga wa Yakobo. ");
INSERT INTO xnj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hinu, mwene lepi “Chapanga wa vevafwili, nambu Chapanga wa vevavi wumi. Nyenye mbudili neju!” ");
INSERT INTO xnj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mmonga wa vawula va malagizu abwelili na kayuwana mhutanu wavi. Peaweni Yesu akuvayangula bwina, akamhegelela na kumkota Yesu, “Pagati ya malagizu goha yoki yikulu?” ");
INSERT INTO xnj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akamyangula, “Malagizu gakulu pagati ya goha ndi aga: ‘Myuwanila nyenye vandu wa ku Isilaeli! Bambu Chapanga witu, ngamwene Bambu. ");
INSERT INTO xnj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umgana Bambu Chapanga waku kwa wumi waku woha na mtima waku woha na luhala lwaku lwoha, na makakala gaku goha.’ ");
INSERT INTO xnj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na muhilu wa pili ndi uwu: ‘Umgana muyaku ngati cheukujigana wamwene.’ Gavi lepi malagizu gakulu gangi ngati aga.” ");
INSERT INTO xnj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hinu, muwula wa malagizu yula akamjovela Yesu, “Muwula! Ujovili chakaka kuvya Bambu ndi Chapanga, kawaka yungi nambu mwene. ");
INSERT INTO xnj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na yikumgana mundu kumgana Chapanga kwa mtima woha na luhala lwoha na makakala gaki goha, na kumgana muyaki ngati cheakujigana mwene. Lijambu lenili ndi labwina neju kuliku kumpela Chapanga hinyama ya kutinyisa na teta zozoha zingi.” ");
INSERT INTO xnj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu pealoli mundu yula ayangwili kwa ukekesi, akamjovela, “Veve uvi papipi kumyidakila Chapanga atalalila wumi waku.” Kangi peamali kujova ago kawaka mundu mwealingi kumkota Yesu lilovi. ");
INSERT INTO xnj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lukumbi Yesu iwula mu Nyumba ya Chapanga, akotili, “Ndava kyani Vawula va Malagizu vijova kuvya Kilisitu ndi mmonga ndu pagati ya vana va Daudi? ");
INSERT INTO xnj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwene kwa kulongoswa na Mpungu Msopi ajovili, ‘Bambu amjovili Bambu wangu, tama upandi wangu wa kulyelela, mbaka nivavika vamakoko vaku pahi pa magendelu gaku.’ ");
INSERT INTO xnj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi mwene akumkemela Kilisitu ‘Bambu.’ Yihotoleka wuli hinu kuvya mmonga ndu pagati ya vana vaki?” Msambi wa vandu wamuyuwanila kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mukuwula kwaki, Yesu avajovili, “Mujiyangalila na Vawula va Malagizu, vevigana kugenda kuni vawalili magwanda gatali na kujambuswa na kwa utopesa vandu pandu pakugulisila vindu. ");
INSERT INTO xnj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mewawa vigana kutama palongolo munyumba za kukonganekela Vayawudi na mvigoda vya palongolo pamgongolelu wa chakulya. ");
INSERT INTO xnj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Vene vitola nyumba na vindu vya valipwela kwa kuvakonga, kuni vakujidekesa kumuyupa Chapanga mulukumbi lutali. Ligono la mwishu yati vilipiswa pavaha.” ");
INSERT INTO xnj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu atamili papipi na chijomela cha kusopela luteta mu Nyumba ya Chapanga. Avalolili vandu chavasopa teta muchijomela chila. Vandu vana vindu vyamahele, vasopili mashonga gamahele mugati yaki. ");
INSERT INTO xnj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kangi akabwela lipwela mngangu mmonga, akasopa sendi zivili videbe neju. ");
INSERT INTO xnj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu avakemili vawuliwa vaki akavajovela, “Chakaka nikuvajovela, lipwela uyu mngangu asopili mashonga gamahele muchijomela kuliku vangi voha. ");
INSERT INTO xnj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Muni vandu voha vangi vawusili chiyonjokesu cha vindu, nambu mau uyu mngangu, asopili vindu vyoha vyeviganikwa ndava ya kulama.” ");
INSERT INTO xnj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu peahumayi mu Nyumba ya Chapanga, mmonga wa vawuliwa vaki amjovili, “Muwula, lola maganga na majengu aga chegavili gabwina na kukangasa!” ");
INSERT INTO xnj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu akamyangula, “Wu, ukugalola majengu aga zivaha? Kawaka liganga hati limonga lelisigalila panani ya liganga lingi, kila liganga yati ligwisiwa.” ");
INSERT INTO xnj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu paatamili panani ya chitumbi cha Mizeituni kulolokesa Nyumba ya Chapanga, Petili na Yakobo na Yohani na Andelea vakamkota pevavi ngavene, ");
INSERT INTO xnj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tijovela mambu genago yati gihumila ndali? Na ulangisu woki weulangisa kuvya mambu aga gavi papipi kuhumila?” ");
INSERT INTO xnj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akatumbula kuvajovela, “Mujiyangalilayi mundu akotoka kuvakonga.” ");
INSERT INTO xnj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Muni vamahele yati vibwela na kulihengela liina langu, kila mundu yati ijova kuvya mwene ndi Kilisitu! Vene yati vakuvakonga vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pemyuwana gegivala ngondo na vandu vilongelela mambu ga ngondo mkotoka kuvagaya. Yikugagana mambu genaga kuhumila, nambu mwishu wene wakona. ");
INSERT INTO xnj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vandu va mulima umonga yati utovana na vandu va mulima wungi, unkosi umonga yati utovana na unkosi wungi, yati kwiva na mindendemo ya ndima pamonga na njala. Mambu ago ndi ngati utumbula wa lipyanda la kuveleka mwana. ");
INSERT INTO xnj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nambu nyenye mjiyangalila. Muni yati vakuvatakila mumabanji ga mihalu, na kutovewa munyumba za kukonganekela Vayawudi. Mewawa yati vakuvapeleka palongolo ya vachilongosi na vankosi ndava ya nene, muni mujova ndava yangu. ");
INSERT INTO xnj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nambu yiganikiwa hoti lilovi la Bwina likokosewayi kwa vandu voha kwakona mwishu wangahika. ");
INSERT INTO xnj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na pamwikamuliwa na kupelekwa mumabanji ga mihalu, mkoto kuhololela chakujova. Lukumbi lwenulo. Nambu mjova chechoha chemwipewa kujova, muni yati gihuma kwa Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mlongo yati akumng'anamukila mhaja waki akomiwa na dadi yati akumng'anamukila mwana waki, na vana yati vakuvang'anamukila dadi na nyina vavi vakomewayi. ");
INSERT INTO xnj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Vandu voha yati vakuvagana lepi ndava ya liina langu. Nambu mweisindimala mbaka mwishu ndi Chapanga akumsangula kuhuma uhamula wa magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pemwilola ‘Yomeso lihakau lelilangisa uhalabisu’ Liyimili pandu pangaganikiwa kuvya.” Mweisoma malovi aga amanyalila. Hinu vevavili ku Yudea na vajumbalila kuchitumbi. ");
INSERT INTO xnj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mundu mweavili kuvala ya nyumba yaku akotoka kuyingila mugati kutola chindu, nambu atilayi! ");
INSERT INTO xnj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mewawa mundu mweavili kumgunda akotoka kuwuya kunyumba yaki kutola nyula yaki. ");
INSERT INTO xnj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Niviniswa mtima ndava ya vanandumbu na vevinyong'esa magono ago, ndava yati kwivya na mang'ahiso neju. ");
INSERT INTO xnj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nambu mumuyupayi Chapanga mambu ago gakotoka kuhumila lukumbi lwa mbepu. ");
INSERT INTO xnj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Muni magono ago yati kwiva na mang'ahiso gakulu, gangahumila kuhuma Chapanga kuwumba mulima mbaka lelu, katu yati gihumila lepi kavili. ");
INSERT INTO xnj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngati Bambu ngagapunguziwi lepi magono kawaka hati mundu mmonga wa kusanguliwa. Nambu ndava ya vahaguliwa vaki, Bambu agapungwizi magono ago. ");
INSERT INTO xnj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kangi, mundu akavajovela, lolayi, Kilisitu avili apa! Amala, avili pala, mkotoka kusadika. ");
INSERT INTO xnj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Muni yati vihumalila vakina Kilisitu vaudese na vamlota va udese, yati vikita ulangisu na chinamtiti, ngati yihotoleka ndava ya kuvabudisa hati vahaguliwa va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nambu nyenye mujiyangalila. Nene nivajovili mambu genaga kwakona gangahumila. ");
INSERT INTO xnj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nambu pegimalika magono ago ga mang'ahiso, lilanga yati lisopewa chitita na mwehi yati ulangasa lepi. ");
INSERT INTO xnj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondo yati zigwa kuhuma kunani, na vindu vyoha vya kumahundi yati vinyuguswa. ");
INSERT INTO xnj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Penapo yati vakumlola Mwana wa Mundu, ibwela mulihundi kwa makakala gamahele na ukulu. ");
INSERT INTO xnj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ndi yati akuvatuma vamitumu va kunani kwa Chapanga vavalunda vandu vevahaguliwi na Chapanga, kuhuma pandi mcheche za mulima, na hati kuhuma pandu pa kutali ya mulima woha.” ");
INSERT INTO xnj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mujiwula kuhuma mumkongo wa mtini. Pemwilola mahamba gimela, nyenye mwimanya kuvya lusenje lwa fula luhegalili. ");
INSERT INTO xnj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mewawa na nyenye pemwilola mambu genago gihengeka, mmanya kuvya Mwana wa Mundu avi papipi neju kuhika. ");
INSERT INTO xnj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chakaka nikuvajovela, chiveleku ichi chipita lepi kwakona mambu aga kuhumila. ");
INSERT INTO xnj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hati ngati kunani kwa Chapanga na pamulima yati ziwuka, nambu malovi gangu yati gihumila ngati chenajovili.” ");
INSERT INTO xnj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nambu, avi lepi mundu mweimanya ligono la mwishu yati libwela ndali, hati vamitumu va kunani kwa Chapanga, hati Mwana wa Chapanga. Dadi Chapanga ndu mweamanyili. ");
INSERT INTO xnj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mujiyangalila na mujitendekela, muni mumanyili lepi ligono amala lukumbi peluhumila. ");
INSERT INTO xnj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yati yivya ngati mundu mweahambi lugendu na kuvalekela vahengaji utalalila, kila mundu na lihengu laki, akumjovela mlonda wa mlyangu avyai mihu. ");
INSERT INTO xnj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mujitendelekela, ndava muni mmanyi lepi mkolo nyumba iwuya ndali. Pangi yivya kimihi, pagati ya kilu, hambakucha amala lukela. ");
INSERT INTO xnj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mujitendelekela, muni ngati abwelili cha kukenyemusa, akotoka kuvakolela mgonili. ");
INSERT INTO xnj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Genikuvajovela nyenye, nikuvajovela mwavoha. Muvya mihu!” ");
INSERT INTO xnj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gavili gakona magono gavili kuhika Mselebuko wa Pasaka na Mselebuko wa kulya mabumunda gangali ngemeku. Vakulu va kuteta na Vawula va Malagizu valondayi njila ya kumkamula Yesu cha mfiyu na kumkoma. ");
INSERT INTO xnj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nambu vakajova, “Tikotoka kukita chenicho lukumbi lwa mselebuko, ndava vandu yati vikita chitututu.” ");
INSERT INTO xnj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu avili ku Betania kunyumba ya Simoni mweavi na mabudi. Peavili pameza kulya chakulya, mau mmonga mweavili na kachupa kadebe kaganga ka alabasta kamahuta geginungalilayi neju, mahuta geginungalila bwina gegatenganizwi kwa nado, akabwela. Akayidindula chupa yila, na kumyitila Yesu mahuta gala kumutu. ");
INSERT INTO xnj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Vandu vangi vevavi penapo vayomiswi na chitendu chila vakajijovela, “Ndava kyani kuyagisa waka mahuta geginungalila bwina? ");
INSERT INTO xnj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mahuta ago ngagagulisiwi kwa mashonga gamahele, ngavapewili vangangu!” Vakamywangila mau yula. ");
INSERT INTO xnj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nambu Yesu akavajovela, “Mumleka! Ndava ya kyani mukumung'aha? Anikitili nene lijambu labwina. ");
INSERT INTO xnj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vangangu muvinawu magono goha, muhotola kuvatangatila lukumbi lwolwoha lwa mwigana. Nambu nene yati nivya lepi na nyenye lukumbi lwoha. ");
INSERT INTO xnj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mwene akitili chaehotwili. Alongolili kuniyitila mahuta geginungalila muhiga yangu anitendelekili kwakona kuzikiwa kwangu palongolo. ");
INSERT INTO xnj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chakaka nikuvajovela, pamulima woha Lilovi la Bwina yati likokoswa, chitendu ichi cheakitili yati chiluwuliwa kwa kumkumbuka mdala uyu.” ");
INSERT INTO xnj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kangi Yuda Isikalioti, mmonga wa vawuliwa kumi na vavili vala, akahamba kwa vakulu va kuteta ndava ya kumgotola Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Vakulu va kuteta pevayuwini malovi genago, vahekalili, vayidakilini kumpela mashonga. Ndi, Yuda akatumbula kulonda lukumbi lwa kumgotola Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ligono la kutumbula kwa Mselebuko wa Mabumunda yangali ngemeku, lukumbi lwa kuhinja mwanalimbelele wa Pasaka, vawuliwa vaki vakamkota, “Ugana tikakutendelekelayi koki chakulya cha Pasaka?” ");
INSERT INTO xnj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hinu, Yesu avatumili vawuliwa vaki vavili akavajovela, “Muhambayi kumuji, kwenuko yati mkumkolela mgosi mmonga agegili chihulu cha manji. Mumlanda ");
INSERT INTO xnj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka munyumba yeiyingila, mkamjovelayi mkolo nyumba, ‘Muwula ikota, chivi koki chumba cha vayehe penilya Pasaka pamonga na vawuliwa vangu?’ ");
INSERT INTO xnj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mwene yati akuvalangisa chumba chivaha kunani ya kugolofa chechitendelekiwi. Mtendekelayi mwenumo.” ");
INSERT INTO xnj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hinu, vawuliwa vakawuka, vakahamba kumuji, vakakolela kila chindu chivi bwina ngati Yesu cheavajovili. Ndi vakatendelekela chakulya cha Pasaka. ");
INSERT INTO xnj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Payavili kimihi, Yesu ahikili penapo pamonga na vawuliwa vaki kumi na vavili. ");
INSERT INTO xnj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pevalyayi pamonga, Yesu akajova, “Chakaka nikuvajovela, mmonga winu mweilya pamonga na nene, yati akunigotola.” ");
INSERT INTO xnj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Penapo vawuliwa vaki vakatumbula kuviniswa mitima, vakatumbula kumkota mmonga mmonga, “Wu, ndi nene?” ");
INSERT INTO xnj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu akavajovela, “Ndi mmonga winu pagati yinu nyenye kumi na vavili, mweijwiga libumunda pamonga na nene munkeve. ");
INSERT INTO xnj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chakaka Mwana wa Mundu yati ifwa ngati Mayandiku Gamsopi chegijova. Nambu alachikolela mundu yula mweakumgotola Mwana wa Mundu! Mbanga kwa mundu mwenuyo ngati ngavelekiwi lepi!” ");
INSERT INTO xnj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pevalyayi, Yesu akatola libumunda, akamsengusa Chapanga, akalimetula na kuvapela vawuliwa vaki akajova, “Mtola, yeniyi, ndi higa yangu.” ");
INSERT INTO xnj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kangi akatola chikombi cha divayi, akamsengusa Chapanga, akavapela voha vanywelili divayi muchikombi chila. ");
INSERT INTO xnj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akavajovela, “Yeniyi ndi ngasi yangu yeyilangisa lilaganu la Chapanga kwa vandu vaki, ngasi yeyiyitika ndava ya kulekekesa mabudilu ga vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chakaka nikuvajovela, ninywa lepi kavili divayi mbaka ligono lila peninywa kavili mu Unkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kangi vakayimba lunyimbu lwa kumsengusa Chapanga, vakawuka, vakahamba ku Chitumbi cha Mizeituni. ");
INSERT INTO xnj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu akavajovela vawuliwa vaki, “Mwavoha nyenye yati mwitila na kunileka nene, mu Mayandiku Gamsopi Chapanga ijova, ‘Yati nikumkoma mdimaji, na mambelele yati gipechengana.’ ");
INSERT INTO xnj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nambu nikayukayi, yati nikuvalongolela ku Galilaya.” ");
INSERT INTO xnj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petili akamjovela, “Hati ngati voha yati vakukuleka, nene katu nikukuleka lepi!” ");
INSERT INTO xnj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu akamjovela, “Chakaka nikujovela, kilu iyi, kwakona lijogolo langakokoleka mala zivili, yati ukunibela mala zidatu kuvya unimanyili lepi.” ");
INSERT INTO xnj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nambu Petili akakangamala kujova, “Hati ngati yikunigana nifwa pamonga na veve, katu yati nikukuleka lepi!” Vawuliwa voha vakajova mewawa. ");
INSERT INTO xnj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Hinu, vakahika kulidimba lelikemelewa Gesemane. Yesu akavajovela vawuliwa vaki, “Mtama apa lukumbi penikumuyupa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kangi akavatola Petili na Yakobo na Yohani. Akatumbula kuviniswa mtima na kung'ahika neju. ");
INSERT INTO xnj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akavajovela, “Niviniswa mtima neju hati papipi kufwa. Mtama na muvya mihu.” ");
INSERT INTO xnj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akahamba palongolo padebe akajitaga cha kukupama pahi, akamuyupa Chapanga, kuvya ngati yihotoleka, lukumbi ulo lwa mang'ahiso lumupitila kutali. ");
INSERT INTO xnj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akajova, “Dadi wangu, kwa veve mambu goha gihotoleka. Uniwusilayi chikombi ichi cha mang'ahiso. Nambu lepi ngati chenigana nene, nambu cheugana wamwene.” ");
INSERT INTO xnj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kangi akawuya kwa vawuliwa vadatu vala akavakolela vagonili. Hinu, akamkota Petili, “Simoni, wu, ugonili? Uhotwi lepi kuvya mihu hati lukumbi ludebe?” ");
INSERT INTO xnj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kangi akavajovela, “Muvyai mihu na kumuyupa Chapanga mkotoka kuyingila mukulingiwa. Mpungu ugana, nambu higa yitotokela.” ");
INSERT INTO xnj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akahamba kumuyupa Chapanga kavili akawuyila malovi galagala. ");
INSERT INTO xnj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Peavawuyili vawuliwa vaki avakolili vagonili kavili. Ndava mihu gavi na lugono. Vamanyi lepi chakumyangula. ");
INSERT INTO xnj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Peabwelili mala ya datu akavajovela, “Mwakona mwigona na kupumulila? Hinu yikoli! Lukumbi luhikili! Mwana wa Mundu igotolewa kwa vandu vevambudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Muyimuka, tihambi. Mlolayi yula mweakunigotola ahegalili.” ");
INSERT INTO xnj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu peavi akona ijova, Yuda mmonga wa kumi na vavili vala, akabwela pamonga na msambi wa vandu wewavili na mapanga na vibonga. Vandu venavo vatumwili na vakulu va kuteta, Vawula va Malagizu na vagogo. ");
INSERT INTO xnj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda, yula mweamgotwili Yesu, avapelili ulangisu msambi wa vandu wula, “Kuvya yula mwenikumjambusa cha kumkumbatila, ndi mumkamula na mumpeleka kuni avi muulonda.” ");
INSERT INTO xnj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda peahikili ndu amuhambalili Yesu akamjovela, “Muwula!” Kangi akamjambusa cha kumkumbatila. ");
INSERT INTO xnj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hinu vandu vala vakamkamula Yesu na kumkunga. ");
INSERT INTO xnj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mmonga mweayimili pamonga na Yesu, akaholomola upanga waki, akamdumula likutu mvanda wa Mteta Mkulu. ");
INSERT INTO xnj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu akamjovela, “Wu, mbwelili na mapanga na vibonga kunikamula ngati kuvya nene mnyagaji? ");
INSERT INTO xnj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Magono goha navi pamonga na nyenye, niwula ku Nyumba ya Chapanga, nambu mwanikamwili lepi. Nambu hinu yikugagana Mayandiku Gamsopi gatimilayi.” ");
INSERT INTO xnj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Penapo vawuliwa voha vakamleka na kutila. ");
INSERT INTO xnj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwavili na msongolo mmonga mweamlandayi Yesu awalili chikwinda. Vene valingili kumkamula. ");
INSERT INTO xnj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nambu mwene akalema, akachileka chikwinda chila, akajumba waka. ");
INSERT INTO xnj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Hinu, vampeliki Yesu kunyumba ya Mteta Mkulu, penapo ndi pevakonganiki pamonga vakulu va kuteta voha na vagogo na Vawula va Malagizu. ");
INSERT INTO xnj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petili amlandili Yesu chapatali, akayingila muluvanja lwa nyumba ya Mteta Mkulu. Akatama pamonga na valonda kuyota motu. ");
INSERT INTO xnj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Vakulu va kuteta na libanji loha valondai lilovi la kumtakila Yesu muni vahotola kumkoma, nambu valipati lepi. ");
INSERT INTO xnj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Vandu vamahele vajovili gaudese ndava ya Yesu, nambu malovi gavi gayidakilini lepi. ");
INSERT INTO xnj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kangi vandu vangi vakayima kujova udese ndava ya Yesu, vakajova, ");
INSERT INTO xnj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tete tamuyuwini ijova, ‘Nene yati nigwisa Nyumba ya Chapanga iyi yeyijengiwi na vandu, na mu magono gadatu yati nijenga yingi yangajengewa na vandu.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nambu pamonga na ago, malovi gavi gayidikilini lepi. ");
INSERT INTO xnj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hinu, Mteta Mkulu akayima pagati yavi akamkota Yesu, “Wu, wiyangula lepi lilovi, vandu venava vakukutakila kyani?” ");
INSERT INTO xnj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nambu mwene agunili, ajovili lepi lilovi hati limonga. Mkulu wa kuteta akamkota kavili, “Veve ndi Kilisitu, Mwana wa Chapanga Mmotisa?” ");
INSERT INTO xnj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akayangula, “Ena, ndi nene. Kavili yati mukumlola Mwana wa Mundu atamili upandi wa kulyelela cha Bambu yula mweavi na makakala. Ibwela kuhumila mumahundi ga kunani kwa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Penapo ndi Mteta Mkulu akapapula nyula zaki, akajova, “Tigana lepi kuyuwana malovi gangi ndava ya mundu uyu! ");
INSERT INTO xnj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mumyuwini cheakumliga Chapanga! Nyenye mjova wuli?” Voha vamganili akomiwa. ");
INSERT INTO xnj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hinu, vangi pagati yavi vakatumbula kumuhunyila mata, vakamgubika pamihu vakamtova na kumjovela, “Lotelayi, ndi yani mweakutovili!” Hati valonda vakamtola, vakampamanda. ");
INSERT INTO xnj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petili peavi akona muluvanja lwa nyumba, mtumisi mmonga wa chidala wa Mteta Mkulu abwelili. ");
INSERT INTO xnj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peamuweni Petili iyota motu, amlolili, akamjovela, “Hati veve wavili pamonga na Yesu wa ku Nazaleti.” ");
INSERT INTO xnj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nambu Petili akabela, “Kwali, nakuchimanya cheujova!” Petili akawuka akahamba pamlyangu wa kuyingilila. Penapo ndi lijogolo likakokoleka. ");
INSERT INTO xnj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Muhengaji mdala yula, peamuwene kavili Petili, akatumbula kangi kuvajovela vandu vevavi penapo, “Mundu uyu ndi mmonga wavi.” ");
INSERT INTO xnj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nambu Petili akabela kavili. Mwanakandahi, vandu vevayimili penapo vamjovili Petili, “Chakaka veve ndi mmonga wavi, muni veve mewawa ndi mundu wa ku Galilaya.” ");
INSERT INTO xnj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nambu Petili akatumbula kujova, “Nipewa likoto ngati nijova udese! Nilapa nimmanyili lepi mundu uyu mwemukumuluwula.” ");
INSERT INTO xnj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bahapo lijogolo likakokoleka mala ya pavili. Petili akumbwiki Yesu cheamjovili, “Kwakona lijogolo langakokoleka yati ukunibela mala zidatu.” Petili akajitaga pahi na kuvemba. ");
INSERT INTO xnj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lukela pehe, vakulu va kuteta vayidakilini pamonga na vagogo na Vawula va Malagizu na vanalibanji voha, vakamkunga Yesu, vakampeleka na kumgotola kwa Pilatu. ");
INSERT INTO xnj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu akamkota Yesu, “Wu, veve ndi Nkosi wa Vayawudi?” Yesu akayangula. “Ena, ndi ngati wamwene cheujova.” ");
INSERT INTO xnj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Vakulu va kuteta vamtakili Yesu mambu gamahele. ");
INSERT INTO xnj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Hinu, Pilatu akamkota kavili Yesu, “Wu, wiyangula lepi lilovi? Yuwanila chevakutakila mambu gamahele kukuvala veve.” ");
INSERT INTO xnj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nambu Yesu ayangwili lepi lilovi, hati Pilatu akakangasa. ");
INSERT INTO xnj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila lukumbi lwa mselebuko wa Pasaka, Pilatu avi na mvelu wa kuvadindulila vandu mkungiwa mmonga mwevamganayi. ");
INSERT INTO xnj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lukumbi lwenulo kwavili mundu mmonga liina laki Balaba, mweakungiwi muchifungu pamonga na vayaki ndava ya kukita chitututu na kukoma vandu. ");
INSERT INTO xnj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Vandu vamahele vakamhambila Pilatu vakamuyupa avakitila ngati cheyavili mvelu waki. ");
INSERT INTO xnj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu akavakota, “Wu, mwigana nivadindulilayi Nkosi wa Vayawudi?” ");
INSERT INTO xnj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ajovili chenicho ndava vakulu vakuteta vamgotwili Yesu kwaki, ndava ya wihu. ");
INSERT INTO xnj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nambu vakulu va kuteta vakavakoakesa vandu vamuyupa Pilatu avadindulila Balaba pahali pa Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatu akavakota kavili, “Hinu, mwigana nimkita chindu kiki na mundu uyu mwemkumkemela Nkosi wa Vayawudi?” ");
INSERT INTO xnj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Vandu voha vakajova kavili kwa lwami luvaha, “Mvamba mu msalaba!” ");
INSERT INTO xnj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nambu Pilatu akavakota, “Ndava kyani? Ahokili kyani?” Nambu vene vakayonjokesa kujova kwa lwami luvaha, “Mvamba pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu aganili kuuganisa msambi wa vandu, akamudindulila Balaba kuhuma muchifungu. Kangi akalagizila Yesu vamtova michapilu, kangi akamgotola vamvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kangi manjolinjoli vala vampeliki Yesu mugati ya luvanja lwa nyumba ya Pilatu, mkulu wa mulima, vakavakemela pamonga msambi woha wa manjolinjoli. ");
INSERT INTO xnj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Vamuwaliki nyula za langi ya zambalau ngati nkosi, vabotili njingwa ya minga, vakamuwalika kumutu. ");
INSERT INTO xnj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Vakatumbula kumjambusa, “Tikuwoni, Nkosi wa Vayawudi!” ");
INSERT INTO xnj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vakamtova kumutu na ndonga, vakamuhunyila mata, vakamfugamila na kumgundamila. ");
INSERT INTO xnj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pavamalili kumvevesa, vakamuhula nyula ya zambalau yila, vakamuwalika nyula zaki, kangi vakamuwusa kuvala kumvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pevavi munjila vakonganiki na mundu mmonga liina laki Simoni, mkolonjinji wa Kulene mwene avili dadi wavi Alekizanda na Lufo. Lukumbi lwenulo apitayi kuhuma kuvala ya muji kuyingila pabomani. Manjolinjoli vakamkamula Simoni na kumgegesa msalaba weavi nawu Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kangi vampeliki Yesu mbaka pandu pepikemelewa Goligota, maana yaki “Libangu la Mutu.” ");
INSERT INTO xnj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kangi vakampela divayi yevahangisini na mtela wewukemelewa manemane, nambu Yesu abelili kunywa. ");
INSERT INTO xnj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hinu vakamvamba pamsalaba, vakagavana nyula zaki, kwa gudugudu muni vamanya kila mmonga yati ipata kyani. ");
INSERT INTO xnj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yavili saa yidatu ya lukela pavamvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Panani ya msalaba wula vaviki chibawu, chevayandiki matakilu gaki, mwenuyu ndi, “Nkosi wa Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mewawa vavavambili panani ya pamisalaba vanyagaji vavili, papipi na Yesu, mmonga upandi waki wa kulyelela na yungi upandi waki wa kumangeya. ");
INSERT INTO xnj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mambu aga ndi gitimisa Mayandiku Gamsopi gegijova, “Avikiwi pamonga na vehenga gahakau.” ");
INSERT INTO xnj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Vandu vevapitayi pandu apo vakamliga na kunyugusa mitu yavi na kujova, “Mwe! Veve mweugwisa Nyumba ya Chapanga na kuyijenga kavili mu magono gadatu! ");
INSERT INTO xnj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hinu, huluka pamsalaba ujisangulayi wamwene!” ");
INSERT INTO xnj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mewawa vakulu va kuteta pamonga na vawula va malagizu vamvevisi vajovesana vene kwa vene, “Avasangwili vangi nambu kujisangula mwene itola lepi! ");
INSERT INTO xnj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ati, mwene ndi Kilisitu, Nkosi wa Isilaeli! Hinu ahulukayi kuhuma pamsalaba muni tilola na kumsadika.” Hati vandu vala vevavambiwi pamsalaba papipi nayu, navene mewa vamligili. ");
INSERT INTO xnj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kutumbula saa sita ya muhi mbaka saa tisa, chitita chagubiki mulima woha. ");
INSERT INTO xnj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa muhi Yesu akajova kwa lwami luvaha, akajova, “Eloi, Eloi, lema sabakitani?” Mana yaki “Chapanga wangu, Chapanga wangu, ndava kyani unilekili?” ");
INSERT INTO xnj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Vandu vangi pagati ya vevayimili pala, pevayuwini ago, vakajova, “Yuwanila! Akumkemela Eliya.” ");
INSERT INTO xnj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu mmonga akajumba, akajwiga chindu ngati lidodoki mudivayi yeyivava, akavika panani ya ndonga, akamvikila pamlomo akajova, “Linda tilola ngati Eliya yati ibwela kumuhulusa pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu akakwesa lwami luvaha, afwili. ");
INSERT INTO xnj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hinu, lipazia la Nyumba ya Chapanga likapapuka pagati kuhuma kunani mbaka pahi. ");
INSERT INTO xnj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu mmonga wa msambi wa manjolinjoli mweayimili palongolo yaki peamuwene Yesu cheifwa, akajova, “Chakaka mundu uyu avili Mwana wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kwavili na vadala vevalolayi chakutali, pagati yavi avi Maliya mkolonjinji wa Magidala, na Maliya nyina wavi Yakobo mdebe na Yose mewa na Salome. ");
INSERT INTO xnj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Vadala ava ndi vevamlandili Yesu ku Galilaya ndava ya kumhengela. Kwavili na vadala vangi vamahele vevabwelili ku Yelusalemu pamonga nayu. ");
INSERT INTO xnj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kimihi yamali kuhika, ndi yavili ligono la kutendelekela kwakona Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Penapo abwelili Yosefu mkolonjinji wa ku Alimatei, mmonga pagati ya vanalibanji likulu, mweitopeswa neju. Mwene mewa alindilayi kubwela kwa Unkosi wa Chapanga. Hinu amhambalili Pilatu changali wogohi, akamuyupa apewayi higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatu akakangasa kuyuwana kuvya Yesu amali kufwa. Hinu akamkemela chilongosi wa msambi wa manjolinjoli, akamkota ngati lumali kupita lukumbi lutali kutumbula Yesu peafwili. ");
INSERT INTO xnj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatu peamali kujoviwa uchakaka kuhuma kwa chilongosi wa msambi wa manjolinjoli yula kuvya Yesu amali kufwa, akamyidakila Yosefu atola higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefu akagula nyula ya msopi, akayihulusa pahi higa yila, akayitindisila nyula ya msopi, akayivika mulitinda la mbugu lelahongoliwi palitalau, akabilingisa liganga pamlyangu wa litinda. ");
INSERT INTO xnj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya mkolonjinji wa Magidala na Maliya nyina wa Yose vapawene pandu pala pevayivikili higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palapitili Ligono la Kupumulila, Maliya mkolonjinji wa Magidala, Salome na Maliya nyina waki Yakobo vagulili mahuta gakunungalila bwina ndi vakanyala higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hinu, lukela pehe ligono la Dominika, lilanga palatumbulayi kuhuma, vahikili pa litinda. ");
INSERT INTO xnj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Munjila vakotanayi vene kwa vene, “Yani yati akutiwusila liganga pamlyangu wa litinda?” ");
INSERT INTO xnj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nambu pavalolili, valiweni liganga limali kuwusiwa. Liganga lenilo lavili livaha neju. ");
INSERT INTO xnj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pevayingili mu litinda la mbugu, vamuweni msongolo mmonga awalili nyula yamsopi, atamili upandi wa kulyelela, vakakangasa neju. ");
INSERT INTO xnj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nambu msongolo yula akavajovela, “Mkotoka kukenyemuka. Mukumlonda Yesu wa ku Nazaleti mweavambiwi pamsalaba. Ayukili, avi lepi apa. Mlolayi, pandu pavamgonisi. ");
INSERT INTO xnj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hinu muhambayi mukavajovela vawuliwa vaki pamonga na Petili kuvya, ‘Akuvalongolela ku Galilaya, kwenuko yati mukumlola ngati cheavajovili.’ ” ");
INSERT INTO xnj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndi, vawukili vakajumba kuhuma mulitinda mula, muni vandendimi kwa wogoyi na kukangasa. Vamjovili lepi chindu mundu yeyoha, ndava muni vayogwipi neju. ");
INSERT INTO xnj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu peayukili lukela pehe ligono la Dominika, amuhumalili hoti Maliya mundu wa Magidala, yula mweamuwusili mizuka saba. ");
INSERT INTO xnj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya akahamba kuvajovela vawuliwa vevavili pamonga na Yesu, na lukumbi lwenulo vavembayi na kutinda. ");
INSERT INTO xnj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nambu pevayuwini ngati Yesu avili mumi na kuvya Maliya mkolonjinji wa Magidala amuweni, vasadiki lepi. ");
INSERT INTO xnj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mwanakandayi Yesu avahumalili vawuliwa vavili vevahambayi kuchijiji. Vawuliwa avo hoti vammanyili lepi. ");
INSERT INTO xnj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Vene vakahamba na kuvajovela vayavi, nambu mewawa vayavi vasadiki lepi. ");
INSERT INTO xnj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pamwishu Yesu avahumalili vawuliwa kumi na mmonga pevavi pamonga pameza. Akavaywangila neju ndava vasadiki lepi na ndava ya kunonopa kwa mitima yavi, muni vavasadiki lepi vala vevamuweni peamali kuyuka. ");
INSERT INTO xnj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hinu, akavajovela, “Muhambayi pamulima woha mkakokosa Lilovi la Bwina kwa vandu voha. ");
INSERT INTO xnj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundu yeyoha mweisadika na kubatiziwa Chapanga yati akumsangula, nambu mundu yeyoha angasadika Chapanga yati akumhamula. ");
INSERT INTO xnj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ulangisu uwu yati ulandana na vevisadika, yati vivinga mizuka kwa liina langu na kulongela kwa luga ya mupya. ");
INSERT INTO xnj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Vakakamulayi liyoka amala kunywa chindu chochoha chechikoma yati vifwa lepi. Yati vakuvavikila mawoko vatamu, na yati Chapanga akuvalamisa.” ");
INSERT INTO xnj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hinu, Bambu Yesu peamalili kulongela nawu, akatoliwa kuhamba kunani kwa Chapanga, akatama upandi wa kulyelela wa chiwoko cha Chapanga. ");
INSERT INTO xnj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Vawuliwa vakahamba na kukokosa Lilovi la Bwina kila pandu. Bambu akahenga lihengu pamonga nawu, kukita milangisu, ndava ya kulangisa ujumbi wenuwo kumvala mwene ndi chakaka.");
INSERT INTO xnj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulungu Teofili. Vandu vamahele valingi kuyandika bwina mambu gegahengiki pagati yitu. ");
INSERT INTO xnj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vayandiki ngati chevatijovili vevagaweni penapo pegatumbukini magono ga mumbele mambu genago na kuvakokosela lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mewa na Mkulungu Teofili penamali kulolokesa uchakaka waki kwa magono gamahele, nilola mbanga nikuyandikila veve kwa uchakaka waki. ");
INSERT INTO xnj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nikiti chenichi muni nigana wamwene umanyayi mambu goha gevakuwulili. ");
INSERT INTO xnj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lukumbi Helodi peavi Nkosi wa ku Yudea, ndi pavi na Mteta wa Chapanga mweikemiwa Zakalia wa chikundi cha uteta cha Abiya, na mdala waki avi Elizabeti wa lukolo lwa Aloni. ");
INSERT INTO xnj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Voha vavili vahenga ga kumganisa Chapanga na kuyidakila mihilu na malagizu ga Bambu changabuda. ");
INSERT INTO xnj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Vavi lepi na mwana mbaka muugogolo wavi, ndava Elizabeti avi lepi na chiveleku. ");
INSERT INTO xnj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ligono limonga, Zakalia peavi mukuhenga lihengu laki la uteta mu Nyumba ya Chapanga, ");
INSERT INTO xnj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ngati cheyavili mivelu ya vamteta va Chapanga, Zakalia ahaguliwi kwa gudugudu kuyingila mu Nyumba ya Bambu ndava ya kuhukisa ubani. ");
INSERT INTO xnj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na lukumbi lwa kuhukisa ubani palwahikili, vala voha vevakonganiki kumuyupa Chapanga vavi cha kuvala vayupayi. ");
INSERT INTO xnj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mtumu wa kunani kwa Bambu, akamuhumila na kuyima upandi wa kulyela wa lusanja lwa luteta lwa kuhukisa ubani. ");
INSERT INTO xnj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia peamuweni mtumu wa kunani kwa Chapanga yula, akakenyemuka. ");
INSERT INTO xnj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mtumu wa kunani kwa Chapanga akamjovela, “Zakalia, kotoka kuyogopa muni Bambu ayuwini chawamuyupili, ndava mdala waku Elizabeti yati akubabila mwana mgosi na veve walamkemela Yohani. ");
INSERT INTO xnj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ndi wamwene yati uheka pavaha na vandu vamahele valahekelela ndava ya kuvelekewa kwaki. ");
INSERT INTO xnj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mwenuyo yati ivya mkulu, pamihu ga Bambu, alanywa lepi divayi wala ugimbi, yati ilongoswa na Mpungu Msopi kuhumila mulileme la nyina waki. ");
INSERT INTO xnj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yati akuvawuyisa vandu vamahele wa pa Isilaeli, vamuwuyilayi Bambu Chapanga wavi. ");
INSERT INTO xnj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yati akumlongolela Bambu kuni ilongosiwa na makakala na Mpungu ngati Eliya. Ndava ya kuvatepulanisa vadadi na vana vavi, yati avakita vangamyidakila vavyayi na luhala ngati lwa vala vevakumyidikila, na kumtendelekela Bambu vandu vaki.” ");
INSERT INTO xnj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia akamkota Mtumu wa kunani kwa Chapanga, “Yati nimanya wuli ngati givya chenicho? Muni nene na mdala wangu tavagogolo.” ");
INSERT INTO xnj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mtumu wa kunani kwa Chapanga akayangula, “Nene na Gabulieli na mtumisi wa Chapanga. Ndi anitumili nijova na veve nikujovela lilovi la bwina lenili. ");
INSERT INTO xnj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yuwanila, yati wivya ngajova yati nakuhotola kujova, mbaka ligono lila pegihumila ago ndava ubeli kunisadika malovi gangu gene gihumila palukumbi lwaki.” ");
INSERT INTO xnj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lukumbi lwenulo vandu vevamulindilayi Zakalia kuvala vakakangasa, muni atamakisi lukumbi lutali mu Nyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Peahumili kuvala nakuhotola kujova na vayaki, vayaki vakamanya kuvya mu Nyumba ya Chapanga mula, muyavi agaweni maono ndi akayendelela kulangisa na mawoko muni avi ngajova. ");
INSERT INTO xnj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lukumbi lwaki lwa kuhenga lihengu la uteta palwamaliki, akawuya kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lukumbi luhupi palwamaliki Elizabeti mdala wa Zakalia yula akavya na ndumbu, akawela munyumba miheyi mhanu, ");
INSERT INTO xnj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","kuni ajova “Bambu anitangatili na aniloli, hinu cheaniwusili soni pavandu!” ");
INSERT INTO xnj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mu mwehi wa sita, Chapanga amtumili mtumu waki wa kunani Gabulieli kumuji wa Nazaleti, ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kwa kamwali mmonga mwavamkemela Maliya, Mwenuyo ahongiwi na mgosi mmonga liina laki Yosefu wa lukolo lwa Daudi. ");
INSERT INTO xnj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mtumu wa kunani kwa Chapanga Akamuhegelela akamjambusa, “Tikuwoni! Bambu avi pamonga na veve kangi akugubiki uganu waki!” ");
INSERT INTO xnj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliya peayuwini malovi gala, akakenyemuka, akahololela, jambusa yeniyi mana yaki kyani? ");
INSERT INTO xnj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mtumu wa kunani kwa Chapanga akamjovela, “Kotoka kuyogopa Maliya, muni Chapanga aganisiwi na veve. ");
INSERT INTO xnj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Walavya na ndumbu, walaveleka mwana mgosi, yati ukumkemela liina laki Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mwenuyo yati ivya mkulu, yati ikemelewa Mwana wa Chapanga Mkulu. Bambu Chapanga yati amuvika kuvya Nkosi, ngati cheamuviki Nkosi Daudi mweavi gogo waki. ");
INSERT INTO xnj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ndi yati ivya Nkosi wa lukolo lwa Yakobo magono goha, na unkosi waki wangali na mwishu!” ");
INSERT INTO xnj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliya akamyangula, “Genago galavya wuli, muni nene nangammanya mgosi?” ");
INSERT INTO xnj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mtumu wa kunani kwa Chapanga akayangula, “Mpungu Msopi yati ukuhelelela, na uhotola waki Chapanga Mkulu walakugubika ngati chimuwili, muni mwana mweubwela kumveleka uyo, yati ikemelawa msopi na Mwana wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hati mlongo waku Elizabeti, agegi ndumbu ya mwana mgosi na hinu mumwehi wa sita, pamonga na ugogolo waki, mweamanyikini na vandu kuvya ngaveleka. ");
INSERT INTO xnj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Muni kawaka lilovi langahotoleka kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya akajova, “Nene nivii penapa namvanda wa bambu, nikitiwayi ngati chaukajovili.” Ndi mtumi wa kunani kwa Chapanga akawuka. ");
INSERT INTO xnj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ndi lwapiti lepi lukumbi lutali, Maliya akapanganyika akayumbatika kuhamba kumuji wewavi kuvidunda vya ku Yudea. ");
INSERT INTO xnj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kwenuko akayingila munyumba ya Zakalia akamjambusa Elizabeti. ");
INSERT INTO xnj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bahapo Elizabeti peayuwini jambusa ya Maliya, kamwana kakahumba chaluheku mulileme la Elizabeti. Elizabeti akalongoswa Mpungu Msopi ");
INSERT INTO xnj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","akajova kwa lwami luvaha, “Umotisiwi kuliku vadala voha, na mweubwela kumveleka huyo amotisiwi! ");
INSERT INTO xnj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nene nayani hati nyina wa Bambu wangu anibwelili? ");
INSERT INTO xnj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nikujovela, panayuwini jambusa yaku, kamwana kakahumba mulileme langu chaluheku. ");
INSERT INTO xnj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Umotisiwi veve mweusadika kuvya yati gihumila gala geakujovili Bambu.” ");
INSERT INTO xnj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya akajova, “Mtima wangu ukumlumba Bambu, ");
INSERT INTO xnj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mpungu wangu umhekela Bambu, ndava Msangula wangu. ");
INSERT INTO xnj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Muni aulolili cha lipyana ungolongondi wa mvanda waki! Kutumbula hinu viveleku vyoha yati vakunikemela mwenisangalwiki, ");
INSERT INTO xnj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ndava muni Chapanga ana makakala anihengili gakulu, na liina laki ndi msopi ");
INSERT INTO xnj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chivelekelu mbaka chivelekelu mwene magono goha avi na lipyana kwa vandu vevakumtopesa. ");
INSERT INTO xnj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Alangisi makakala gaki kwa kukita mambu gakulu. Avapechengini vevimeka mumaholo ga mitima yavi. ");
INSERT INTO xnj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Avahelisi vankosi vana makakala kuhumila muvigoda vya kulongosa, na avakwesi vevavi ngolongondi. ");
INSERT INTO xnj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vangangu avayukutisi mambu gabwina, na vana vindu vyamahele avalekili vahamba mawoko gawaka. ");
INSERT INTO xnj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Amtangatili mulima wa Isilaeli mtumi waki. Akumbwiki lipyana laki, ");
INSERT INTO xnj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ngati chaajovili kuvya na lipyana kwa Ibulahimu na chivelekelu chaki, magono goha.” ");
INSERT INTO xnj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya akatama kwa Elizabeti ngati miyehi yidatu, ndi akawuya kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Palwahiki lukumbi lwa Elizabeti kuveleka ndi akavya na mwana mgosi. ");
INSERT INTO xnj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vandu va mu lukolo na veitamanila nawu papipi, pevayuwini Bambu amkitili lipyana neju, voha vakahekelela pamonga nayu. ");
INSERT INTO xnj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ligono la nane vakabwela kumdumula jandu mwana, vaganayi kumpela liina Zakalia, liina la dadi waki. ");
INSERT INTO xnj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nambu nyina waki akajova, “Lepi, mwenuyu ikemelewa Yohani.” ");
INSERT INTO xnj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vakamjovela, “Kawaka mu lukolo lwaki mweavi na liina ngati lenili!” ");
INSERT INTO xnj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hinu vakamkota dadi waki chakumlangisa, muni vamanyayi aganili kumpela liina loki. ");
INSERT INTO xnj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia akayupa chibawu cha kuyandikila, akayandika, “Liina laki Yohani.” Vandu voha vakakangasa! ");
INSERT INTO xnj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bahapo mlomo wa Zakalia akatumbula kulongela kangi akamulumba Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Vandu voha veatama nawu vakavya na wogohi, mambu ago gakalongaleka mulima woha wa vidunda vya ku Yudea. ");
INSERT INTO xnj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vandu voha vevayuwini mambu genago, vakaholalela mumitima yavi na kukotana vene kwa vene mumitima yavi, “Mwe mwana uyu yati ivya wuli?” Chakaka, makakala ga Bambu gavi pamonga na mwene. ");
INSERT INTO xnj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia dadi mwana yula akalongoswa na Mpungu Msopi akatumbula kulotela ulota uwu. ");
INSERT INTO xnj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ulumbiwa Bambu Chapanga wa Isilaeli! Ndava ubweli kuvatangatila vandu vaki na kuvagombola. ");
INSERT INTO xnj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atipeli Msangula mkekesi, mu chiveleku cha Daudi mtumisi waki. ");
INSERT INTO xnj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ndi atijovili kadeni munjila ya vamlota vaki va msopi, ");
INSERT INTO xnj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yati atisangula kuhuma mu mawoko ga makoko gitu, na mumakakala ga voha vavakutihakalila. ");
INSERT INTO xnj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ajovili yati avakitila lipyana vagogo vitu na akulihololela lilaganu laki la msopi. ");
INSERT INTO xnj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Chilapu alapili kwa dadi witu Ibulahimu, kuvya akutitangatila tete ");
INSERT INTO xnj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tigomboka kuhuma mu mawoko ga makoko gitu, na timugundamila changali wogohi, ");
INSERT INTO xnj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","muusopi na kukita gegakumganisa Chapanga, magono goha ga wumi witu.” ");
INSERT INTO xnj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Wamwanangu veve, yati ukemelewa, mlota wa Chapanga mkulu, ndava walamlongolela Bambu kumkwalila njila yaki, ");
INSERT INTO xnj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na kuvakokosela vandu kuvya valasanguliwa kwa kulekekesewa kumbudila Chapanga wavi. ");
INSERT INTO xnj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chapanga witu yati ikita genago ndava lipyana ya mtima waki wa ngolongondi. Usangula waki yati ubwela kuhuma kunani ngati lumuli chelulangasa chelihumila lilanga, ");
INSERT INTO xnj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kuvalangasila voha vevitama muchitita chikulu cha lifwa, na kutilongosa titama wumi wa uteke.” ");
INSERT INTO xnj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana yula akakula, na akakangamala mumpungu waki. Akatama kulugangatu mbaka ligono paajilangisi pavandu va pa Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lukumbi lwenulo, Agusiti mweavi nkosi mkulu wa vankosi va unkosi va ku Loma, alagizili vandu voha vayandikwa muchitabu. ");
INSERT INTO xnj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuyandakiswa kwenuko kwakita kutumbukana, na lukumbi lwenulo Kulenio avi chilongosi wa ku Silia. ");
INSERT INTO xnj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila mundu, akahamba kumuji waki muni ajiyandikisayi. ");
INSERT INTO xnj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na Yosefu mewa akawuka pamuji wa Nazaleti wewavi kumulima wa Galilaya, akahamba kumuji wa Betelehemu wewavi pamulima wa ku Yudea, kweavelikiwi nkosi Daudi. ");
INSERT INTO xnj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akahamba kuyandakiswa pamonga na maliya mweavimchumba waki, mweavi na ndumbu. ");
INSERT INTO xnj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pevavi ku Betelehemu ligono laki likahika akavya na mwana. ");
INSERT INTO xnj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akaveleka mwana waki mtumbulanu mwana mgosi, akamtindisila tunyula twa vana, kangi akamgonesa muwatu wa kulisila mifuya, ndava vapati lepi fwasi munyumba za vayehe. ");
INSERT INTO xnj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pamulima wenuwo kwavi na vadimaji vevatama pandu pa kudimila na kulindalila mambelele gavi cha kupishana kilu. ");
INSERT INTO xnj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mtumu wa Chapanga akavahumila na lumuli lukulu lwa Bambu lwavalangasili, pandu poha. Vayogwipi neju. ");
INSERT INTO xnj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nambu Mtumu wa Chapanga akavajovela, “Mkotoka kuyogopa! Myuwanayi nivaletili lilovi la bwina la luheku neju kwa vandu voha va Paisilaeli. ");
INSERT INTO xnj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Muni lelu pamuji wa Daudi avelikiwi msangula winu, Kilisitu ndi Bambu. ");
INSERT INTO xnj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ulangisu wa kummanya ndi uwu, yati mukumkolela mwana vamtindisili tunyula twa vana vamgonisi muwatu wa kulisila mifuya.” ");
INSERT INTO xnj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bahapo msambi wa vamitumu vangi va kunani vakawungana na mtumi mwenuyo vakamulumba Chapanga na kujova, ");
INSERT INTO xnj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Alumbiwayi Chapanga kunani, na uteke uvyaa pamulima kwa vandu veaganisiwi nawu!” ");
INSERT INTO xnj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pavawuyili Vamitumu vala kunani, ndi vadimaji vakajovesana vene kwa vene, “Tihambayi ku Betelehemu tikagalola geatijovili Bambu aga.” ");
INSERT INTO xnj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Vakayumbatika kuhamba kwenuko, vakamkolela Maliya na Yosefu na vamgonisi mng'enya muwatu wa kulisila mifuya. ");
INSERT INTO xnj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Vadimaji vala pavamuwene mwana yula, vakatumbula kujova goha gavayuwini kuhuma kwa Mtumu wa kunani kumvala mwana uyo. ");
INSERT INTO xnj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Voha vavayuwini gevajoviwi na vadimaji vala, vakakangasa. ");
INSERT INTO xnj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndi Maliya akagavika na kugahololela mambu goha mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vadimaji vala vakawuya, kuni vakumulumbalila Chapanga kwa goha gavayuwini na kugalola, goha ngati chagajoviwi mtumi wa kunani. ");
INSERT INTO xnj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Palapiti lijuma limonga, lukumbi lwa kumdumula mwana jandu lwaihiki, vakampela liina la Yesu, ndi liina la apewili na mtumu wa kunani kwakona nyina waki kuvya na ndumbu. ");
INSERT INTO xnj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Payahikili ligono la Yosefu na Maliya kunyambiswa ngati chayaganikiwi na malagizu ga Chapanga geampelili Musa, ndi vampeliki mwana ku Yelusalemu ndava ya kumvika kwa Bambu. ");
INSERT INTO xnj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngati chaiyandikiwi mu Malagizu ga Musa, “Kila mwana mgosi mwaatumbwili kuvelekewa yati ikemelewa msopi na kubaguliwa ndava ya lihengu la Bambu.” ");
INSERT INTO xnj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ndi vakahamba kuwusa luteta kwa Chapanga, ngunda zivili amala mawela gavili, ngati chayaganikiwi mu Malagizu ga Bambu. ");
INSERT INTO xnj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lukumbi lwenulo ku Yelusalemu kula kwavi na mundu mmonga, liina laki Simioni, mwenuyo akitayi mambu ga kumganisa Chapanga na mwenuyo alindilayi kuhika lukumbi lwa vandu va Isilaeli kupumuliswa mitima. Na mpungu Msopi avi pamonga na mwene. ");
INSERT INTO xnj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mpungu Msopi amgubukuli Simoni yati ifwa lepi changamlola Kilisitu msangula mweahaguliwi yula mweajoviwi na Bambu. ");
INSERT INTO xnj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndi Simoni alongwiswi na Mpungu msopi kuhamba mu Nyumba ya Chapanga, pamonga na dadi na nyina wa Yesu, pavampeliki mwana wavi Yesu ndava ya kukita ngati chayaganikiwi na mivelu ya malagizu ga Chapanga geampeli Musa. ");
INSERT INTO xnj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni akampokela mwana Yesu mu mawoko gaki, kuni akumsengusa Chapanga, akajova. ");
INSERT INTO xnj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hinu, Mkulu, ukitili ngati chewakajovili, unilekayi, nene mvanda waku nihamba cha uteke. ");
INSERT INTO xnj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa mihu gangu niuwene usangula waku, ");
INSERT INTO xnj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ndi uhuletili usangula palongolo ya vandu va milima yoha ulolekayi. ");
INSERT INTO xnj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lwenulo ndi lumuli lwa kuvamanyisa vandu vangali kuvya Vayawudi, na ukulu kwa vandu vaku va ku Isilaeli.” ");
INSERT INTO xnj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dadi na nyina wa Yesu vakakangasa ndava ya malovi gala gegajoviki kumuvala mwana yula. ");
INSERT INTO xnj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndi Simioni akavamotisa, akamjovela Maliya nyina waki Yesu, “Lola mwana uyu avelekiwi ndava ya vandu vamahele va Isilaeli kugwa kwa vandu vamahele na vangi vamahele kuyinuka, mwene yati ivya ulangisu wa kubelekana na vandu, ");
INSERT INTO xnj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","muni maholo ga vandu va mahele galalolekana pawaka. Wamwene lipyanda ngati upanga, ukuhomili mtima waku.” ");
INSERT INTO xnj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwavili na mdala mmonga mgogolo neju, mlota wa Chapanga, liina laki Ana, msikana wa Fanueli wa likabila la Asheli. Paavi msikana agegiwi na kutama na mgwana waki miyaka saba ndu. ");
INSERT INTO xnj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kangi asigalili lipwela mbaka muugogolo wa miyaka semanini na mcheche. Lukumbi lwoha awelai mu Nyumba ya Chapanga, ajihinisi kulya na kuyupa kilu na muhi. ");
INSERT INTO xnj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mdala yula akahumila lukumbi lulalula na kutumbula kumsengusa Chapanga na kuvajovela vandu voha gakumuvala mwana yula, vevalindila kugombolewa na kulekekesewa kwa Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefu na Maliya pavamali kukita goha gegalagiziwi mu Malagizu ga Bambu, vawuyili kumuji wavi Nazaleti wewavi ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana yula akakula na kuvya na makakala, akamema luhala na umotisi wa Chapanga wavi pamonga na mwene. ");
INSERT INTO xnj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila mwaka dadi na nyina waki Yesu vahambili ku Yelusalemu kumselebuko wa Vayawudi wewikemiwa pasaka. ");
INSERT INTO xnj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu peahikisi miaka kumi na yivili, voha vakakwela kuhamba ku Yelusalemu, kumselebuko wa vayawudi wa pasaka ngati chayavi mivelu yavi. ");
INSERT INTO xnj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mselebuko pawamaliki, vakawuya, Yesu asigalili ku Yelusalemu changali dadi na nyina waki kumanya. ");
INSERT INTO xnj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dadi na nyina vaki vaholalili avi pamonga mulugendu, vakagenda muhi woha, kangi vakatumbula kumulonda kwa valongo vaki na vankozi waki. ");
INSERT INTO xnj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Vamuweni lepi, vakawuya ku Yelusalemu vakumulonda. ");
INSERT INTO xnj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ligono la datu la kumlonda, vakamkolela mu Nyumba ya Chapanga, atamii pagati ya vawula va malagizu, akuvayuwanila na kuvakota. ");
INSERT INTO xnj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Voha vevamuyuwanila malovi gaki vakavya kumkangasa ndava ya luhala na kuyangula kwaki. ");
INSERT INTO xnj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na pavamuweni vakakenyemuka, nyina waki akamkota “Wamwana vangu ndava kyani utikitili genaga? Dadi waku na nene ting'ahiki neju kukulonda.” ");
INSERT INTO xnj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu akayangula, “Ndava kyani mukunilonda? Mumanyi lepi ngati yikunigana nene kuvya munyumba ya Dadi wangu?” ");
INSERT INTO xnj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nambu dadi na nyina waki nakugamanya malovi gala geavajovili. ");
INSERT INTO xnj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu akawuya pamonga nawu ku Nazaleti, akuvayuwanila. Nyina waki akayendelela kugaholalela mambu goha mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu akayonjokeseka kukula luhala na higa, akaganisiwa neju na Chapanga na vandu. ");
INSERT INTO xnj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wavi mwaka wa kumi na mhanu wa unkosi waki nkosi wa ku Loma Tibelio, penapo Ponsio Pilatu avi nkosi wa mulima wa ku Yudea. Na Helodi alongosai ku Galilaya, na mhaja waki Filipi alongosa ku Itulea na Tilakoniti. Na Lusania alongosa ku Abilene, ");
INSERT INTO xnj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","lukumbi lwenulo Anasi na Kayafa vavi vamlota vakulu va Chapanga. Penapo ndi lilovi la Chapanga lamhikili Yohani mwana wa Zakalia kulugangatu. ");
INSERT INTO xnj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohani akahamba pamulima woha wewavi mumbaka wa mfuleni Yoludani, akavya kuvakokosela vandu, valekayi kumbudila Chapanga na vabatiziwa, na Chapanga yati akuvalekekesa gevambudili. ");
INSERT INTO xnj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngati chegayandikwi muchitabu cha Isaya mweavi mlota wa Chapanga, “Mundu ikemela kwa lwami luvaha kulugangatu, ‘Mumkwalila Bambu njila yivaha, mukagolosa pala peibwela kupita. ");
INSERT INTO xnj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ligodi loloha lihilaliwayi, Chitumbi chochoa na chitumbi yati chidandasiwayi na pepapindili yati pigoloswa, na njila zina magodi zihilaliwayi. ");
INSERT INTO xnj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na vandu voha va pamulima yati vaulola usangula kuhuma kwa Chapanga.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohani akaujovela msambi wa vandu vevamuhambili ndava ya kubatiziwa. “Nyenye vana va Liyoka! Yani mweavajovili ngati muhotola kutila ligoga la Chapanga yeyivii papipi kubwela? ");
INSERT INTO xnj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngati mikongo ya matunda cheyiganikiwa kupambika, na nyenye mkitayi mambu ga kulangisa, mkotwiki kumbudila Chapanga. Mkotoka kutumbula kujijovela ngati Ibulahimu dadi witu. Chakaka nikuvajovela Chapanga ihotola kugakita maganga aga kuvya vana va Ibulahimu! ");
INSERT INTO xnj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na hinu livagu livi litendekiwi pamikiga ya mkongo, na mkongo wowoha wula wangapambika matunda gabwina yati udumuliwa na kutagiwa kumotu.” ");
INSERT INTO xnj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Msambi wa vandu ukamkota Yesu, “Hinu tikita kyani?” ");
INSERT INTO xnj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohani akavayangula, “Mundu mweavi na nyula zivili ampela muyaki mweangavya nazu, na mweavi na vyakulya na mwene akita mewa.” ");
INSERT INTO xnj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na vatola kodi mewa vabwelili kwa Yohani kubatiziwa, ndi vakamkota “Muwula, hinu tikita wuli tete?” ");
INSERT INTO xnj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Akavajovela, mkotoka kutola kodi kuyonjokesa chemulagaziwi.” ");
INSERT INTO xnj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Manjolinjoli na vene vakamkota, “Na tete tikita wuli?” Akavajovela, “Mkotoka kutola mashonga kwa mundu yoyoha kwa makakala na kumtakila mundu yoyoha ga udese na mukolayi na luhuna zinu.” ");
INSERT INTO xnj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ndava vandu voha valindalilayi kubwela kwa msangula, ndi vakatumbula kukotana vene kwa vene kumvala Yohani, manya mwene ndi Kilisitu msangula mwaatijovili Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohani akavajovela woha, “Nene nikuvabatiza kwa manji, nambu mweibwela ana makakala kuliku nene, kwa mwene, nene chindu lepi nakuganikiwa hati kuwopola nyosi za champali zaki. Mwene yati akuvabatiza kwa Mpungu Msopi na motu. ");
INSERT INTO xnj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mu mawoko gaki akamwili lupalu lwa kupepetela nganu, na nganu ya bwina akuyivika pamonga muchibana, na masasa akugayocha motu wangajima.” ");
INSERT INTO xnj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na kwa malovi gangi gamahele, Yohani akangamili kuvajovela vandu vakotoka kumbudila Chapanga kwa kuvakokosela Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nambu Yohani amuywangili chilongosi Helodi, ndava amtoli Helodiya mdala wa mhaja waki na kumgega, na mambu gahakau gamahele geakitili. ");
INSERT INTO xnj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kangi Helodi akayonjokesa uhakau, kwa kumkunga Yohani muchifungu. ");
INSERT INTO xnj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Vandu voha pavamali kubatiziwa, Yesu namwene abatiziwi na kuni iyendelela kuyupa kwa Chapanga, lihundi la kunani likadinduka. ");
INSERT INTO xnj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ndi Mpungu Msopi ukamuhelela panani yaki wavi ngati higa ya ngunda, na lwami lukayuwanika kuhuma kunani kwa Chapanga, “Veve ndi wamwana vangu mweuniganisi.” ");
INSERT INTO xnj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu peatumbwili kuhenga lihengu lila, ahegalili miyaka selasini. Na vandu vangi vamuholalelayi manya avi mwana wa Yosefu, Yosefu avi mwana wa Heli, ");
INSERT INTO xnj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli avi mwana wa Matati, Matati avi mwana wa Lawi, Lawi avi mwana wa meliki, Meliki avi mwana wa Yanai, Yanai avi mwana wa Yosefu, ");
INSERT INTO xnj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","mweavi mwana wa matatia, mwana wa Amosi, mwana wa Nahumu, mwana wa Esili, mwana wa Nagai, ");
INSERT INTO xnj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Maati, mwana wa Matatia, mwana wa Shemeni, mwana wa Yoseki, mwana wa Yuda, ");
INSERT INTO xnj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","mweavi mwana wa Yohanani, mwana wa Lesa, mwana wa Zelubabeli, mwana wa Shealitieli, mwana wa Neli, ");
INSERT INTO xnj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Meliki, mwana wa Adi, mwana wa Kosamu, mwana wa Elimadamu, mwana wa Eli, ");
INSERT INTO xnj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mweavi mwana wa Yoshua, mwana wa Eliezeli, mwana wa Yolimu, mwana wa Matati, mwana wa Lawi, ");
INSERT INTO xnj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","mweavi mwana wa Simioni, mwana wa Yuda, mwana wa Yosefu, mwana wa Yonamu, mwana wa Eliakimu, ");
INSERT INTO xnj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","mweavi mwana wa Melea, mwana wa Mena, mwana wa Matata, mwana wa Nasani, mwana wa Daudi, ");
INSERT INTO xnj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mweavi mwana wa Yese, mwana wa Obedi, mwana wa Boazi, mwana wa Solomoni, mwana wa Nashoni, ");
INSERT INTO xnj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","mweavi mwana wa Aminadabu, mwana wa Adimini, mwana wa Alini, mwana wa Heziloni, mwana wa Pelisi, mwana wa Yuda, ");
INSERT INTO xnj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mweavi mwana wa Yakobo, mwana wa Izaki, mwana wa Ibulahimu, mwana wa Tela, mwana wa Naholi, ");
INSERT INTO xnj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mweavi mwana wa Selugi, mwana wa Leu, mwana wa Pelegi, mwana wa Ebeli, mwana wa Sala, ");
INSERT INTO xnj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","mweavi mwana wa Kenani, mwana wa Alifakisadi, mwana wa Shemu, mwana wa Nuhu, mwana wa Lameki, ");
INSERT INTO xnj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mweavi mwana wa Metusela, mwana wa Henoki, mwana wa Yeledi, mwana wa Mahalaleli, mwana wa Kenani, ");
INSERT INTO xnj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mweavi mwana wa Enoshi, mwana wa Seti, mwana wa Adamu mwavi mwana wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu akahuma ku Yoludani, kuni amemiswi Mpungu Msopi na kalongoswa nayu kuhamba kulugangatu. ");
INSERT INTO xnj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwenuko Setani amlingili kwa magono alobaini. Magono genago goha atamili changalya chindu, pamwishu njala yikamuvina. ");
INSERT INTO xnj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setani akamjovela, “Ngati veve Mwana wa Chapanga, lijovela liganga lenili livya libumunda.” ");
INSERT INTO xnj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu akamyangula, “Mayandiku Gamsopi gijova, wumi wa mundu uvi lepi ndava ya kulya libumunda lene.” ");
INSERT INTO xnj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kangi mzuka mkulu akamtola mbaka panani neju, kugubika na kugubukula mihu, ndi akamlangisa unkosi woha weuvili pamulima poha. ");
INSERT INTO xnj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Penapo Setani akamjovela, “Yati nikupela kutalalila vindu vyoha ivi na ukulu waki woha. Muni nipewili vindu ivi vyoha, na nene ngati nigana yati nikumpela mundu yoyoha nihotola kumpela. ");
INSERT INTO xnj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yati nikupela ivi vyoha, ngati unifugamila.” ");
INSERT INTO xnj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu akamyangula, “Mayandiku Gamsopi gijova. ‘Yati ukumfugamila Bambu Chapanga na kumhengela mwene ndu.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kangi Mzuka mkulu akamtola mbaka ku Yelusalemu na kuyima panani pa chituvilu cha Nyumba ya Chapanga, akamjovela, “Ngati veve wamwana wa Chapanga, jitagayi pahi. ");
INSERT INTO xnj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Muni Mayandiku Gamsopi gijova, ‘Chapanga yati akulagazila vamitumu va kunani vakuyangalila.’ ");
INSERT INTO xnj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Kangi yati vakuyanga mu mawoko gavi, ukotoka kujikuvala chigendelu chaku muliganga.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nambu Yesu akamyangula, “Mayandiku Gamsopi gijova, ‘Kotoka kumulinga Bambu Chapanga waku.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setani mkulu peamali kumlinga Yesu kwa njila zoha, akamuleka kwa lukumbi. ");
INSERT INTO xnj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kwa kulongoswa na Mpungu msopi Yesu akahamba ku Galilaya. Na ujumbi waki ukadandasika ku Galilaya na mumilima yoha ya papipi. ");
INSERT INTO xnj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu avili mukuwula vandu munyumba za kukonganekela Vayawudi na kulumbiwa na vandu voha. ");
INSERT INTO xnj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu akahamba ku Nazaleti, pandu pealeliwi. Palahiki Ligono la Kupumulila, akayingila munyumba ya kukonganekela Vayawudi, ngati chayavili mvelu waki, akayima muni asomayi Mayandiku Gamsopi. ");
INSERT INTO xnj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Apewili chitabu cheayandiki Isaya mweavi mlota wa Chapanga, ndi akachitalambula na kulonda ndi apawene pandu pepayandikiwi. ");
INSERT INTO xnj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mpungu wa Bambu uvi pamonga na nene, anihagwili nene ndava ya kuvakokosela vangangu Lilovi la Bwina. Anitumili nivakokosela vavanda kulekekeswa kwavi na vangalola vahotola kulola, anitumili nivasangulayi woha veving'ahiswa, ");
INSERT INTO xnj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kukokosa mwaka wa Bambu yati ilangisa ubwina kwa vandu vaki.” ");
INSERT INTO xnj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kangi, akachigubika chitabu akamuwuyisila mtumisi na kutama pahi. Vandu voha vevavi munyumba ya kukonganekela Vayawudi, vakamuhutusila mihu. ");
INSERT INTO xnj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mwene akavajovela, “Lelu Mayandiku aga Gamsopi gahikili pemwaniyuwani penakasomili.” ");
INSERT INTO xnj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Vandu voha vakaganiswa nayu na kukangasa ndava ya Malovi gabwina geajovili. Vakakotana, “Wu, mwenuyu mwana wa Yosefu lepi?” ");
INSERT INTO xnj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu akavajovela, “Nimanyili mukunijovela luhumu ulu, ‘Mlamisa, jilamisa wamwene. Goha getayuwini’ Gawakitili Kapelanaumu gala, Ugakitayi goha penapa pachijiji chaku. ");
INSERT INTO xnj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akayendelela kuvajovela,” “Chakaka nikuvajovela, kawaka Mlota wa Chapanga, mweiyidakiliwa pachijiji chaki.” ");
INSERT INTO xnj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Muyuwanila, chakaka nikuvajovela, vavi valipwela vamehele pamulima wa Isilaeli lukumbi lwa Eliya, lukumbi lwenulo yatonyi lepi fula kwa miyaka yidatu na miyehi sita, na kwavi na njala yivaha pamulima woha. ");
INSERT INTO xnj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nambu Eliya atumiwi lepi kuhamba kwa lipwela yoyoha yula, ndi kwa lipwela mmonga mwaatamayi kumuji wa ku Selefati kumulima wa Sidoni. ");
INSERT INTO xnj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na mulukumbi lwa Elisha mweavi Mlota wa Chapanga, kwavi na vandu vamahele pamulima wa Isilaeli vevavi na mabudi, kawaka mundu mweanyambiswi, nga Naamani mwene, mundu wa ku Silia.” ");
INSERT INTO xnj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vandu voha vevavi munyumba ya kukonganekela vayawudi, pevayuwini genago, vayomili neju. ");
INSERT INTO xnj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Vakayima, vakamuhumisa kuvala ya muji na kumtola mbaka panani pamkingisa wa chitumbi. Ndava muji wavi wajengiwi pachitumbi, Muni vagana kumkang'ila pahi. ");
INSERT INTO xnj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nambu Yesu akaholota pagati yavi, akahamba. ");
INSERT INTO xnj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kangi Yesu akahelela kumuji wa ku Kapelanaumu, mulima wa Galilaya, na Ligono la Kupumulila avawulayi vandu. ");
INSERT INTO xnj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Vakakangasa na mawuliwu gaki, muni ujumbi waki wavi na uhotola. ");
INSERT INTO xnj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hinu munyumba ya kukonganela Vayawudi mula, kwavi na mundu mweavi na mzuka uhakau, akavemba kwa lwami luvaha, ");
INSERT INTO xnj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Mwe! Yesu wa ku Nazaleti Una kyani na tete? Wu, ubweli kutikomakesa? Nene nikumanyili wayani veve, veve wa Msopi wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu akauhakalila mzuka wula akajova, “Guna! Muwuka mundu uyu!” Ndi mzuka wula ukamugwisa pahi palongolo ya vandu, ukamuhuma changalemasa. ");
INSERT INTO xnj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vandu voha vakavya kukangasa, vakajovesana, “Lenili liwulo la chinamtiti, Mundu uyu anauhotola na makakala ya kuvinga mizuka na yene yiwuka!” ");
INSERT INTO xnj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na mambu ga Yesu gakadandasika pandu poha penapo. ");
INSERT INTO xnj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu peahumili munyumba ya kukonganekela Vayawudi mula, akahamba kunyumba ya Simoni. Kwenuko mau mmonga mweavi mkohanu waki Simoni, avi na utamu neju, vakamjovela Yesu amulamisa. ");
INSERT INTO xnj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu, akahamba, akamgundamila mau yula, akauhakalila utamu ula, balapala mau yula akalama, akayimuka na akatumbula kuvatelekela. ");
INSERT INTO xnj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Palatipimi lilanga, mundu yeyoha mweavili na mtamu, wa utamu wowoa wula, ampeliki kwa Yesu, na mwene akampamisa mawoko kila mtamu, na kuvalamisa woha. ");
INSERT INTO xnj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mizuka na yene, yavahumili vandu vamahele, yikaywanga cha kujova, “Veve Mwana waki Chapanga!” Nambu Yesu akayibesa mizuka kujova, muni gammanyili mwene ndi Kilisitu msangula mweahaguliwi na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chilau yaki lukela Yesu akawuka akahamba pandu pachiepela. Vandu vakavya kumulonda, pavamuweni valingili kumbesa akotoka kuwuka. ");
INSERT INTO xnj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nambu mwene akavajovela, “Niganikiwi kukokosa na kumiji yingi mewa Lilovi la Bwina la Unkosi wa Chapanga. Ndava muni chenichi ndi Chapanga chaanitumili nihengayi.” ");
INSERT INTO xnj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndi akayendelela kukokosa vandu Lilovi la Bwina munyumba za kukonganekela Vayawudi pamulima wa ku Yudea. ");
INSERT INTO xnj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ligono limonga, Yesu peayimili mumihana ya nyanja ya ku Genezaleti, msambi wa vandu vamhinyayi kumtindila, muni vayuwanila lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ndi aziweni watu zivili mumuhana ya nyanja, zavazilekili valova somba, muni vene vasanja ngwanda zavi. ");
INSERT INTO xnj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu akayingila muwatu wa mundu mmonga mwavamkemela Simoni, akamjovela Simoni wusayi watu pamuhana hegelesa mumanji palongolo padebe kuhuma pandumba. Yesu akatama muwatu na kutumbula kuwula msambi wa vandu. ");
INSERT INTO xnj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Peamali kuwula, akamjovela Simoni, “Hegelesa watu waku mbaka pamanji gamahele, mukahelesa ngwanda zinu mlova somba.” ");
INSERT INTO xnj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akamyangula, “Bambu, tikangamili kulova somba kilu yoha kawaka chindu chetipati, nambu ndava ujovi veve yati tihamba kuhelesa ngwanda mumanji.” ");
INSERT INTO xnj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ndi pavahelisi ngwanda zavi, vakapata somba zamahele mbaka ngwanda zikatumbula kudauka. ");
INSERT INTO xnj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Vakavakemelela na vayavi vevavi muwatu wungi, vabwelayi kuvatangatila. Vakabwela, vakamemesa watu zoha zivili somba mbaka zikatumbula kudodomela. ");
INSERT INTO xnj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petili pealoli genago, akamfugamila Yesu akajova, “Bambu uwuka palongolo yangu, ndava nene mwenimbudila Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ndava vapatili somba zamahele. Simoni pamonga na vayaki voha vakakangasa, ");
INSERT INTO xnj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mewawa Yakobo na Yohani vana va Zebedayo vevavili valova somba vayavi, pamonga na Simoni na vene vakakangasa. Yesu akamjovela Simoni, “Kotoka kuyogopa, kutumbula hinu wivya lepi mlova somba nambu yati wivya mlova wa vandu ndi kuvaleta vandu kwa Bambu.” ");
INSERT INTO xnj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndi, pavamali kuzivika watu zila mumhana ya nyanja, vakagaleka goha na kumlanda Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ndi Yesu paavi kumuji umonga wa kwenuko, mgosi mmonga anamabudi higa yoha pamuweni Yesu, akamgwilila chakukupama mumagendelu gaki na akamjovela, “Bambu, ngati wigana uhotola kuninyambisa.” ");
INSERT INTO xnj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu akatalambula chiwoko chaki na kumpamisa akamjovela, “Nigana unyambasikayi!” Bahapo akalama mabudi gala. ");
INSERT INTO xnj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu akambesa, “Ukoto kumjovela mundu yeyoha, ndi uhamba ukajilangisa kwa Mteta wa Chapanga, ukawusa luteta ngati cheyilagiza mumhilu ya Chapanga geampeli Musa, muni yimanyikana kwa vene kulangisa kuvya unyambisiwi.” ");
INSERT INTO xnj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nambu Lilovi la Yesu likayendelea kudandasika pandu poha, na misambi ya vandu vakakonganeka muni vamyuwanila na kulamiswa matamu gavi. ");
INSERT INTO xnj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nambu mwene akajibagula kuchiyepela, akavya mukuyupa kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ligono limonga, Yesu peavili mukuwula. Vafalisayu na vawula va malagizu ga Musa kuhuma mukila chijiji cha ku Galilaya na Yudea na Yelusalemu vakavya kutama penapo. Na makakala ga Bambu wavi pamonga nayu, wa kulamisa vatamu. ");
INSERT INTO xnj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ndi lukumbi lulalula, vakabwela vandu vevamugegesini mundu mgosi palusongwani, mwepolili higa agonili lusongwani, vakalinga kumyingisa mugati, vamuvikayi palongolo ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nambu nakuhotola kuyingila nayu mugati ndava ya vandu vamahele. Ndi vakakwela panani ya nyumba vakabowola chipagalu, na vakamuhelesa mweapoli yula pamonga na lusongwani lwaki mbaka peavili Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu peayiweni kusadika kwavi kula, akamjovela mwaalwala yula, “Nkozi wangu, ulekekiswi kumbudila Chapanga waku.” ");
INSERT INTO xnj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Vafalisayu na vawula va malagizu ga Chapanga geampeli Musa vakatumbula kukotana, “Mwenuyu mundu kiki mweakumliga Chapanga? Kawaka mundu mweihotola kulekekesa kubuda ndi nga Chapanga mwene!” ");
INSERT INTO xnj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nambu Yesu amanyili maholo gavi akavakota, “Ndava kyani mukujikota genago mumitima yinu? ");
INSERT INTO xnj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chinonopa kiki, kujova ‘ulekekiswi kumbudila Chapanga waku,’ Amala kujova ‘Yima ugendayi’ ");
INSERT INTO xnj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hinu, nigana mumanyayi, Mwana wa Mundu ana uhotola wa kuvalekekesa vandu pamulima vevakumbudila Chapanga.” Ndi akamjovela mwaalwala yula, “Yima, tola lusongwani lwaku, uhamba kunyumba!” ");
INSERT INTO xnj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bahapo, mundu mweapoli yula akayima akatola, lusongwani lwaki lweagonili na akawuya kunyumba yaki kuni amulumbalila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vandu voha vakakangasa na kuvya na wogohi, kuni vamulumbalilayi Chapanga vakajova, “Tigaweni mambu ga kukangasa lelu!” ");
INSERT INTO xnj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kangi, Yesu akahuma kuvala ndi amuwene mtola kodi mwavamkemela Lawi atamili munyumba ya kutolela kodi. Yesu akamjovela, “Nilandayi!” ");
INSERT INTO xnj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi akayima na kuleka kila chindu, akamlanda. ");
INSERT INTO xnj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kangi, Lawi amgongolili Yesu kunyumba yaki, na msambi wa vatola kodi na vandu vangi vatamili kulya pamonga na Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Vafalisayu na vawula va Malagizu ga Chapanga geampeli Musa vakavang'ung'utila vawuliwa vaki vakajova, “Ndava kyani mwilya na vatola kodi na vandu vevakumbudila Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akavayangula, “Vangalwala vigana lepi mlamisa, nambu vevilwala vigana mlamisa. ");
INSERT INTO xnj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nene nibweli lepi kuvakemela vandu vevikita gegakumganisa Chapanga, nibweli kuvakemela vandu vevakumbudila Chapanga vamuwuyila.” ");
INSERT INTO xnj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Vandu vangi vakamjovela Yesu, “Vawuliwa va Yohani vakujihinisa chakulya na kuyupa, na vawuliwa va Vafalisayu na vene vikita mewa. Nambu vawuliwa vaku vilya na vinywa.” ");
INSERT INTO xnj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akavayangula, “Wu, muhololela kuvya muhotola kuvakita vankozi va mkolo ndowa vajihinisa chakulya kuni vavi pamonga na mkolo ndowa? ");
INSERT INTO xnj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nambu lwalabwela lukumbi lwa Bambu kuwusiwa kuhuma kwavi, ndi penapo yati vakujihinisa kulya.” ");
INSERT INTO xnj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kangi Yesu akavajovela luhumu ulu, “Kawaka mundu mweipapula chilaka munyula ya mupya na kutota mulindimula. Ngati akitili chenichi, yati ayihalabisi nyula yeniyo na chilaka chenicho yati chiwanangana lepi na lindimula lila.” ");
INSERT INTO xnj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kavili kawaka mundu mweisopa divayi ya mupya mulindimula la lihaku lelitengenizwi kwa chikumba, akakita chenicho, mahaku ga chikumba gala gipapuka na divayi yiyitika na mahaku ga chikumba yati gipapuka. ");
INSERT INTO xnj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nambu divayi ya mupya yisopewa mumahaku ga chikumba cha mupya. ");
INSERT INTO xnj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kawaka mundu mweinogela kunywa divayi ya mupya ngati akalongolili kunywa divayi ya kadeni. Muni ijova ya kadeni yila yabwina neju. ");
INSERT INTO xnj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ligono la Kupumulila, Yesu apitayi mumigunda ya nganu. Vawuliwa vaki vakatumbula kudenya njechela za nganu, vakagayogola mumawoko gavi vakalya ngele zaki. ");
INSERT INTO xnj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nambu Vafalisayu vangi vakavakota, “Ndava kyani nyenye mukita chindu chechibesiwi Ligono la Kupumulila?” ");
INSERT INTO xnj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu akavayangula, “Wu! Mwangasoma cheakitili Daudi na vayaki pevavi na njala? ");
INSERT INTO xnj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ayingili mu Nyumba ya Chapanga, akatola mabumunda gegavikiwi pandu pa Chapanga, akalya na akavagavila na vayaki. Mabumunda genago gavi ndava ya vamlota va Chapanga ndu, ndi vevalyayi.” ");
INSERT INTO xnj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kangi akavajovela, “Mwana wa Mundu ndi Bambu wa Ligono la Kupumulila.” ");
INSERT INTO xnj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ligono lingi la Kupumulila, Yesu akahamba munyumba ya kukonganekela Vayawudi kuwula. Kumbi mugati mula avili mundu mmonga mwaapopotwiki chiwoko chaki cha kulyelela. ");
INSERT INTO xnj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Vawula va malagizu ga Chapanga geampeli Musa na Vafalisayu vamlolokisi takataka Yesu, valola ngati akumlamisa mundu Ligono la Kupumulila muni valonda lilovi la kumtakila. ");
INSERT INTO xnj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nambu Yesu agamanyili goha gavaholalela na akamjovela mweagogodili chiwoko yula, “Yimuka, uyima palongolo yavi.” Mundu yula akayima akahamba penapo. ");
INSERT INTO xnj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu akavajovela, “Nikuvakota nyenye, malagizu gitu gijova wuli kuyivala Ligono la Kupumulila? Wu, tihotola kukita lijambu labwina amala tihotola kukita lijambu lihakau? Wu, tihotola kusangula wumi wa mundu amala tihotola kukoma?” ");
INSERT INTO xnj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Akavalolokesa vandu voha vevavili penapo, akamjovela mwaapopotwiki chiwoko yula, “Golosa chiwoko chaku.” Mundu yula akagolosa, na akalama chiwoko chaki. ");
INSERT INTO xnj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nambu vene vakayoma neju, vakajovesana, vamkitila kyani Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lukumbi luhupu palongolo, Yesu akahamba kuchitumbi kuyupa kwa Chapanga, akatama mihu kilu yoha kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chilau yaki lukela, akavakemela vawuliwa vaki, ndi akavahagula vandu kumi na vavili ndi akavakemela vamitumi. ");
INSERT INTO xnj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni mewa mwapewili liina lingi na Yesu la Petili, na mbena waki Andelea mlongo waki na Yakobo na Yohani na Filipi na Batolomei, ");
INSERT INTO xnj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Na Matei na Tomasi na Yakobo mwana wa Alufayo na Simoni mweakemeliwi Zelote, ndava avili mundu wa kukengelela mulima waki, ");
INSERT INTO xnj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Na Yuda mwana wa Yakobo na Yuda Isikalioti mweabweli kumung'anamukila Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu paahelili kuchitumbi pamonga nawu, akayima pamtambu, penapo pavi na vawuliwa vaki na msambi wa vandu vamahele vakuhuma ku Yudea yoha, na ku Yelusalemu na pamulima wa kumbwani ya ku Tilo na ku Sidoni. ");
INSERT INTO xnj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vandu voha vabweli kumyuwanila Yesu na vevavi na utamu vagana valamisiwayi. Mewa ayihakalili mizuka kuhuma kwa vandu venavo. ");
INSERT INTO xnj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ndi kila mundu alingayi kumpamisa, muni makakala gamuhumayi mwene na kuvalamisa vandu voha. ");
INSERT INTO xnj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu akavalola vawuliwa vaki akavajovela, Mhekayi nyenye mwavangangu, muni Unkosi wa Chapanga ndi winu! ");
INSERT INTO xnj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mhekayi nyenye mwemuvi na njala hinu, muni yati mwiyukuta! Mhekayi nyenye mwemvemba hinu, muni yati muheka kwa luheku! ");
INSERT INTO xnj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mhekayi, nyenye, ngati vandu vavagani lepi, amala kuvabagula, amala kuvaliga na kugahakasa mahina ginu ndava ya Mwana wa Mundu! ");
INSERT INTO xnj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lukumbi genago pegihumila, mhekayi na kukina, muni njombi yinu yivaha kunani kwa Chapanga. Ndava muni vagogo vavi vavakitili vamlota va Chapanga mewawa. ");
INSERT INTO xnj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nambu mwalachikolela nyenye mwemuvi na vindu vyamahele hinu, ndava mmali kupoleswa mitima, yati mpoleswa lepi kavili mitima yinu. ");
INSERT INTO xnj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mwalachikolela nyenye mwemwiyukuta hinu, muni njala yati yikuvavina! Mwalachikolela nyenye mwemuheka hinu, mwalavemba na kuvya milyangu.” ");
INSERT INTO xnj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mwalachikolela nyenye ngati vandu voha vakuvalumbalila, muni vagogo vavi vavalumbalili vamlota va Chapanga vaudese mewawa.” ");
INSERT INTO xnj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nambu nikuvajovela nyenye mwemukuniyuwanila, muvagana vandu vevavi makoko vinu, muvakitila gabwina vandu vangavagana nyenye. ");
INSERT INTO xnj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Muvamotisa vala vevalapikisa likoto, muvawombelayi vala vevakuvakitila gahakau. ");
INSERT INTO xnj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ngati mundu yoyoha yula akutovili mulitama, veve mung'anamusila na lingi. Ngati mundu akunyagili likoti laku, mewa veve mulekelayi na nyula. ");
INSERT INTO xnj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mundu yoyoha yula mweakukuyupa chindu veve mpelayi, ngati mudu akunyagi vindu vyaku, veve kotoka kumjovela akuwuyisila. ");
INSERT INTO xnj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngati chemwigana vandu vangi vavakitilayi, na nyenye muvakitila vene mewawa.” ");
INSERT INTO xnj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ngati mukuvagana nga vandu vevakuvagana nyenye mwavene, mwipata njombi yoki? Kawaka! Muni na vevakumbudila Chapanga na vene viganana mewa. ");
INSERT INTO xnj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na, ngati mukuvakitila gakumganisa Chapanga nga vala vevakuvawuyisila, nyenye mwipata njombi yoki? Muni hati vandu vevakumbudila Chapanga, vikita mewawa, ");
INSERT INTO xnj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","na ngati mukuvayaika vandu vemuvahuvalila vavawuyisilayi ndu, mwipata njombi kiki? Muni na vandu vevakumbudila Chapanga vakuvayayika mewawa vayavi, ndava vawuyisiwayi. ");
INSERT INTO xnj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nambu nyenye muvaganayi makoko vinu, mvakitila gabwina, na pemukuvayaika mkotoka kugana kuwuyisiwa kavili. Ndi penapo njombi yinu yati yivya yivaha na nyenye yati mwivya vana va Chapanga Mkulu. Muni mwene akuvagana vandu vangamsengusa na vahakau. ");
INSERT INTO xnj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muvya na lipyana ngati Dadi winu cheavi na lipyana.” ");
INSERT INTO xnj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mkotoka kuvahamula vangi, na Chapanga yati akuvahamula lepi, mkotoka kuvalaumu vayinu na nyenye yati mwilaumiwa lepi, muvalekelekesa vayinu na Chapanga yati avalekelekesa nyenye. ");
INSERT INTO xnj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muvapela vangi gevigana, na Chapanga yati avapela nyenye, ndi mupokela mulihaku linu. Ndava muni chipimu chichocho chemvahengela vangi na nyenye yati mpokela kuhuma kwa Chapanga, chipimu cha bwina cha kumema na kuhindiliwa na kunyuguswa mbaka kuyitika.” ");
INSERT INTO xnj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu akavajovela luhumu ulu, “Wu, ngalola, ihotola kumlongosa ngalola muyaki? Lepi! Voha yati vidumbukila muligodi. ");
INSERT INTO xnj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Muwuliwa mkulu lepi kuliku muwula waki, nambu akawuliwayi na kumanya ndi iwanangana na muwula waki. ");
INSERT INTO xnj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ndava kyani ulola lungoda lweluvi mulihu la mlongo waku, nambu wamwene uvi na lumbagalu mulihu laku? ");
INSERT INTO xnj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Uhotola wuli kumjovela mlongo waku, ‘Chondi nikuwusayi lungoda mulihu laku,’ Kuni nakuluwona lumbagalu mulihu laku wamwene? Mweukujikita mbwina veve! Wusa hoti lumbagalu mulihu laku ndi yati ulola bwina kuwusa kabasi mulihu la mlongo waku.” ");
INSERT INTO xnj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mewawa mkongo wabwina upambika lepi matunda gahakau na wala mkongo uhakau upambika lepi matunda gabwina. ");
INSERT INTO xnj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mkongo wowoha wula umanyikana ndava ya matunda gaki. Muni vandu viyava lepi matunda ga tini mumkongo wa michongoma na wala viyava lepi zabibu mumbigili. ");
INSERT INTO xnj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu mbwina iwusa vindu vyabwina kuhuma muvindu yveavikili muchibana cha mtima waki na mundu mhakau iwusa vindu vihakau kuhuma muchibana cha mtima waki. Ndava muni mundu ilongela gegamemili mumtima waki.” ");
INSERT INTO xnj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ndava kyani mukunikemela ‘Bambu, Bambu,’ Kuni mwihenga lepi chenikuvajovela? ");
INSERT INTO xnj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nikuvapela luhumu lwa mundu yula mweibwela kwa nene, akugayuwana malovi gangu na kuhenga chenijova. ");
INSERT INTO xnj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mwenuyo iwanangana ngati mundu mweijenga nyumba, mwe agimili mkingisa neju mbaka akaukolela litalau, akatumbula kujenga penapo. Peyaumili mfuleni kumema manji gana makakala na kuyitova nyumba yila, nambu nyumba yila yanyugusiki lepi, ndava yajengiwi chakukangamala. ");
INSERT INTO xnj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nambu mundu yula mweiyuwana malovi gangu na ihenga lepi chindu chochoha, mwenuyo iwanangana na mundu mweajengili nyumba panani ya ludaka changali kugima mkingisa neju. Peyahumili mifuleni kumema manji gana makakala, gakayitova nyumba yila, yikagwa na kudenyekana nyiminyimi!” ");
INSERT INTO xnj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu peamali kujova ago kwa vandu akahamba ku Kapelanaumu. ");
INSERT INTO xnj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kwenuko kwavili na mkulu mmonga wa vandu va ngondo va ku Loma, mwenuyo avi na mtumisi, mweamyidikili neju mwealwala mulung'olelu. ");
INSERT INTO xnj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mkulu yula wa Loma peayuwini mambu ga Yesu, akavatuma vagogo vangi va Vayawudi vakamuyupayi abwela kumulamisa mtumisi waki. ");
INSERT INTO xnj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pevahikili kwa Yesu, vakamjovela, “pepayi bambu, mundu mwenuyu, yitakiwa atangatiwayi. ");
INSERT INTO xnj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ndava mwenuyu akuvagana vandu vitu, kangi ndi mweatijengili nyumba ya kukonganekela Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ndi Yesu akahamba nawu. Pavahegalili pa nyumba ya mkulu yula, ndi mkulu akavatuma vankozi vaki vakamjovelayi Yesu, “Bambu, kotoka kujing'aha. Muni nene nakujiwona ngati nabwina hati veve kuyingila mumyumba yangu, ");
INSERT INTO xnj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kangi, nikajiweni nabwina lepi, nene kubwela kwa veve. Nambu jovayi ngalilovi na mtumisi wangu yati ilama. ");
INSERT INTO xnj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndava muni nene mewa, mundu mwenivikiwi pahi ya uhotola wa vakulu vangu nivi na manjolinjoli, nikamjovelayi mmonga, ‘Hambayi!’ Ihamba, nikamjovela yungi, ‘Bwelayi!’ Na mwene ibwela, Nikamjovelayi na mvanda wangu, ‘Kita naha!’ Namwene ikita.” ");
INSERT INTO xnj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu akakangasa paayuwini genago, akaung'anamukila msambi wa vandu wewamlandali, akavajovela, “Niloli lepi sadika yivaha ngati iyi hati pagati ya vandu va Isilaeli!” ");
INSERT INTO xnj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndi vandu vala pavawuyili kunyumba vakamkolela mtumisi yula alamili. ");
INSERT INTO xnj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chilau yaki, Yesu akahamba kumuji umonga weukemelewa Naini, na vawuliwa vaki pamonga na msambi wa vandu ukalongosana nayu. ");
INSERT INTO xnj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ndi pavahegalili papipi na mlyangu mkulu wa muji, vakakonganeka na vandu vavagegili mtuhi wa msongolo mmonga, mwana yuyoyo ndu wa lipwela. Vandu vamahele va pamuji wenuwo vavi pamonga na mau mwenuyo. ");
INSERT INTO xnj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bambu Yesu paamuweni mau yula, akamhengela lipyana akamjovela, “Kotoka kuvemba.” ");
INSERT INTO xnj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kangi Yesu akahamba na kupamisa lusongwani chavagegili mtuhi na vavagegili vala vakayima. Akajova, “Wamsongolo veve! Nijova yimuka!” ");
INSERT INTO xnj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mweafwi yula akayima akatumbula kulongela. Yesu akampela mau yula mwana waki. ");
INSERT INTO xnj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndi vandu voha vakavya na wogohi, vakatumbula kumulumbalila Chapanga. Vakajova, “Mlota mkulu wa Chapanga atihumali pagati yitu, Chapanga abwelili kuvatangila vandu vaki.” ");
INSERT INTO xnj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mambu genago gakadandasika pamulima woha wa Yudea na milima yoha yeyavi papipi. ");
INSERT INTO xnj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vawuliwa vaki Yohani pevamjovili mambu goha. Ndi akavakemela vawuliwa vavili, ");
INSERT INTO xnj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","akavatuma kwa Bambu vakamkotayi, “Veve ndi msangula mweibwela, amala timulindila yungi?” ");
INSERT INTO xnj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pavahikili kwa Yesu, vakamjovela, “Yohani Mbatizaji atitumili tikukotayi, ngati veve ndi msangula mweibwela, amala timlindila yungi.” ");
INSERT INTO xnj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lukumbi lwenulo vamkoli Yesu avalamisayi vandu vamahele vevavi na matamu na vana mizuka yihakau akayiwusa, na vangalola vamahele akavakita kulola. ");
INSERT INTO xnj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndi akavajovela muhamba mukamjovela Yohani goha gemugaweni na kuyuwana. Vangalola vilola, vangagenda vigenda, vanamabudi vinyambiswa, vangayuwa viyuwana, vavafwili vihyukiswa, na vangangu vikokosewa Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ahekayi mundu yula mweangayoma ndava ya nene! ");
INSERT INTO xnj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Vajumbi va Yohani vala pavawukili, ndi Yesu akatumbula kuukota msambi wa vandu gakumuvala Yohani, “Pamwahambili kulugangatu kumlola Yohani, mwaganili kulola kiki? Wu, mwaholalili kumlola mundu mweavi ngati lidete lelinyuguswa na mpungu? ");
INSERT INTO xnj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hinu, mwahambili kulola kiki? Mundu mwaawali nyula za nyililili? Vandu veviwala chakujinyambisa na kutama wumi wabwina, venavo vavi munyumba za vankosi. ");
INSERT INTO xnj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Munijovela chemukahambili kulola? Mlota wa Chapanga? Ena, chakaka kangi neju ya Mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohani mwenuyu ndi malovi gayandikiwi mu Mayandiku kumvala mwene, ‘Lola nene nikumtuma mjumbi wangu akulongolela, ndava ya kukukwalila njila yaku.’ ");
INSERT INTO xnj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu akamalakisila kujova,” “Kawaka mundu, mweavelikiwi na mdala mkulu kuliku Yohani Mbatizaji. Nambu mweavi mdebe muunkosi wa Chapanga, mwenuyo ndi mkulu kuliku mwene.” ");
INSERT INTO xnj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Vandu voha pamonga na vatola kodi vevabatiziwi na Yohani, pevayuwini genago, vakayidakila Chapanga ndi mchakaka. ");
INSERT INTO xnj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nambu Vafalisayu na vawula va Malagizu vala vevabatiziwi lepi na Yohani, ndi vabeli mpangu wa Chapanga ndava ya mambu gavi. ");
INSERT INTO xnj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu akavajovela, “Chiveleku cha vandu ava kwali nivawanangisa na kyani? Vene vandu ava valingini na kiki? ");
INSERT INTO xnj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Vavi ngati vana vevatamii pandu pakugulisila vindu vikemelana, chikundi chimonga na chiyaki, ‘Tivabetili chitolilo nambu nyenye mwanga kina! Tivayimbili nyimbu za malilu nambu muvembi lepi!’ ");
INSERT INTO xnj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohani peabweli, ajihinisi chakulya wala kunywa divayi, mkamjova ‘Mwenuyu anamzuka!’ ");
INSERT INTO xnj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Mundu abwelili, ilya na kunywa, nyenye mujova, ‘Mumlola muhutulu na chigaligali uyu, nkozi wa vatola kodi na vandu vevakumbudila Chapanga!’ ");
INSERT INTO xnj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nambu luhala lwa Chapanga lulangisa, yakuvya chakaka kwa voha vevakuluyidakila.” ");
INSERT INTO xnj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayu mmonga amgongolili Yesu kulya panyumba yaki. Akayingila munyumba ya Mfalisayu yula na kutama kulya. ");
INSERT INTO xnj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ndi pamuji wenuwo avi mdala mmonga wumi waki atamayi kumbudila Chapanga. Akayuwana Yesu avili munyumba ya Mfalisayu uyu, ndi akatola chupa yeyahongoliwi kwa liganga la alabasta yeyavi na mahuta ga kunungalila bwina. ");
INSERT INTO xnj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akayima papipi na magendelu ga Yesu kuni avembayi, na maholi gaki gamudonyokela Yesu mumagendelu, akahungula magendelu ga Yesu na mayunju gaki, akagabusu magendelu gala na kunyala mahuta genago. ");
INSERT INTO xnj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayu mweamugongolili Yesu pealoli genago akaholalela mumtima waki, “Mwe mundu uyu ngaavi chakaka mlota wa Chapanga, ngaammanyi mdala mweampamisi, kuvya mweakumbudila Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu akamjovela mfalisayu yula. “Simoni, chivii chindu chenigana kukujovela.” Simoni, akamyangula, “Ena muwula, jovayi.” ");
INSERT INTO xnj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu akajova, “Vandu vavili vamuyahiki mundu mashonga. Mmonga ayayiki mashonga ga luhuna lwa mwaka umonga na miheyi sita na yungi ayaiki mashonga ga luhuna lwa mwehi umonga na majuma gavili. ");
INSERT INTO xnj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Voha vavili vavilepi na mashonga ga kuwuyisa, mundu yula avahulumili voha. Hinu yani mweakumugana neju bambu yula?” ");
INSERT INTO xnj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni akamyangula, “Chakaka mweahulumiwi mashonga ga mahele yula alamugana neju bambu yula.” Yesu akamjovela, “Uhamwili chabwina.” ");
INSERT INTO xnj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kangi akamng'anamukila mdala yula na akamjovela Simoni, “Umlola mdala uyu? Penikayingili munyumba yaku unipeli lepi manji gakusamba mumagendelu gangu, nambu mdala uyu anitepatisi magendelu gangu na maholi gaki na kuhungula na mayunju gaki. ");
INSERT INTO xnj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Penikayingili unikemili lepi chakunibusu mulitama, nambu mdala uyu kutumbula panakayingila hakotwiki lepi kunijambusa cha kunibusu litama laki mumagendelu gangu. ");
INSERT INTO xnj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uninyalili lepi mahuta ga zeituni kumutu veve, nambu mdala uyu aninyalili mahuta geginungalila bwina mumagendelu gangu. ");
INSERT INTO xnj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nikukujovela, alekekisiwi kumbudila Chapanga pamahele ndava muni alangisi uganu uvaha. Nambu mundu mwealekekiswi kumbudila Chapanga padebe ilangisa uganu udebe.” ");
INSERT INTO xnj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu akamjovela mdala yula, “Ulekekiswi goha geumbudili Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Vandu vala vavatamili na Yesu pakulya pala, vakatumbula kukotana, “Mundu uyu ndi yani? Hati ihotola kulekekesa vandu vevakumbudila Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ndi Yesu akamjovela mdala yula, “Kusadika kwaku kukulamisi, uhamba na uteke.” ");
INSERT INTO xnj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pagamaliki ago Yesu akahamba mumiji na muhijiji hingi kuvajovela vandu Lilovi la Bwina la Unkosi wa Chapanga. Vawuliwa vaki kumi na vavili vakalongosana nayu. ");
INSERT INTO xnj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pamonga na vadala vevawusiwi mizuka na vevalamisiwi matamu na Yesu, venavo vavi, Maliya mkolonjinji wa Magidala mweawusiwi mizuka saba yihakau, ");
INSERT INTO xnj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yoana mdala waki Kuza, Kuza mweavi myimilila nyumba ya Helodi, Susana na vadala vangi vamahele. Vevawusili vindu yavi ndava ya kumtangatila Yesu na vawuliwa vaki vayendelela na lihengu lavi. ");
INSERT INTO xnj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Vandu vamahele vambwelalili Yesu kuhuma kukila muji, na msambi uvaha pawakonganiki, Yesu akavajovela luhumu ulu. ");
INSERT INTO xnj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Mundu mweahambili kumija mbeyu zaki. Na peamija mbeyu, zingi zikagwilila munjila na vandu vakazilivatila, na videge vikahola. ");
INSERT INTO xnj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Zingi zikagwilila paludaka luna maganga pezatumbulayi kumela zikanyala muni pavi lepi na manji. ");
INSERT INTO xnj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Zingi zikagwilila muminga, ndi minga zikamela pamonga nazu, zikazihinya. ");
INSERT INTO xnj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Zingi zagwili paludaka lwabwina, zikamela limonga likapambika ng'onyo. Yesu akamalisila kwa lwami luvaha, “Mweavi na makutu ga kuyuwana ayuwana!” ");
INSERT INTO xnj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vawuliwa vaki vakamkota Yesu, luhumu lula mana yaki kyani. ");
INSERT INTO xnj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mwene akavayangula, “Nyenye muhotiswi kumanya ufiyu wa Unkosi wa Chapanga, nambu lepi kwa avo vangi, vene vijoviwa kwa luhumu, muni vakalolayi nakuhotola kulola na vakayuwana nakumanya.” ");
INSERT INTO xnj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Luhumu ulu mana yaki. Mbeyu ndi lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chechihumili kwa mbeyu zezagwili munjila, ndi luhumu lwa vandu veviyuwana lilovi la Chapanga, kangi Setani peibwela na kuliwusa mumitima yavi vakotoka kusadika na kusanguliwa. ");
INSERT INTO xnj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mewawa chechehumili kwa mbeyu zezagwili pamaganga, ndi luhumu wa vandu veviyuwana lilovi na kulipokela kwa luheku. Nambu vandu vangali mikiga mugati yavi, na lukumbi pevilingiwa vikotoka. ");
INSERT INTO xnj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kangi chechihumili kwa mbeyu zezagwili paminga, ndi luhumu wa vandu veviyuwana lilovi la Chapanga, pa lukumbi luhupi peviyendelela na Lilovi lenilo, vene vihinyiwa na mahengu ga kuvya na vindu vyamahele na mambu ga bwina ga pamulima, ndi na kupambika matunda gakakangala. ");
INSERT INTO xnj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ndi mbeyu zezagwili paludaka lwabwina, ndi luhumu wa vandu vevayuwini lilovi na kulivika mumitima yavi na kuyidakila bwina. Vikangamala mumitima mbaka kupambika matunda.” ");
INSERT INTO xnj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Vandu vipambika lepi hahi na kuyigubika na chiviga amala kuyivika kuhi kuchitanda. Nambu vandu vivika hahi panani pachibokoselu, muni vandu veviyingila mugati valola bwina.” ");
INSERT INTO xnj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Muni chochoha chechifiyiki, yati chigubukuliwa na chindu chochoha cha mfiyu yati chimanyikana na voha.” ");
INSERT INTO xnj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Mujiyangalilayi chemwiyuwana, muni mweavi nachu yati iyonjokeswa, nambu mundu mwanga chindu, hati chila chidebe cheihololela kuvya nachu yati chinyagiwa.” ");
INSERT INTO xnj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyina waki na valongo vaki Yesu vakamuhambalila, ndava ya msambi wa vandu wula nakuhotola kumuhegelela. ");
INSERT INTO xnj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu mmonga akamjovela Yesu, “Nyina waku na valongo vaku vayimili kuvala, vigana kukulola.” ");
INSERT INTO xnj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nambu Yesu akavajovela vandu, “Nyina wangu na valongo vangu ndi vala veviyuwana lilovi la Chapanga na kulikamula.” ");
INSERT INTO xnj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na kavili ligono limonga Yesu peakweli muwatu pamonga na vawuliwa vaki, akavajovela, “Tikupuka kumwambu ya nyanja.” Vakatumbula kukupuka. ");
INSERT INTO xnj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pavahambayi muwatu wula, Yesu agonili lugono. Ndi chimbungululu chikatumbula kutova munyanja mula na manji gakatumbula kuyingila muwatu wavi mkulemala neju. ");
INSERT INTO xnj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Vawuliwa vaki vamhambali vakamuyumusa na vakamjovela, “Bambu, Bambu Tifwa!” Yesu akayumuka, akachilakalila chimbungululu chila na luyuga lwa manji ndi vikaguna na kukavya teke. ");
INSERT INTO xnj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kangi akavajovela vawuliwa vaki, “Kusadika kwinu kuvi koki?” Vene vakakangasa na kuyogopa kuni vijovelana, “Mundu uyu wa namuna yoki? Hati ihotola kugunisa chimbungululu na luyuga na vyene vimyidikila!” ");
INSERT INTO xnj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Vakakupuka na kuhika kumbwani ya kumuji wa mulima wa Vagelasi wewalolasini na Galilaya kumwambu ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu peahulwiki muwatu na kulivatila mbwani, mundu mmonga wa muji wula, mweavi na mizuka ambwelalili. Mundu mwenuyo kwa magono gamahele awala lepi nyula wala atamili lepi munyumba yoyoha yila, ndi atamali mumbugu la kuzikila vandu. ");
INSERT INTO xnj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Peamuweni Yesu akavemba kwa lwami luvaha na kumgwilila pamagendelu, “Wa, Yesu veve Mwana wa Chapanga Mkulu! Una kyani na nene? Pepayi chonde kotoka kuning'aha!” ");
INSERT INTO xnj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ajovili genago muni Yesu amali kuuhakalila mzuka wula umuwukayi mundu yula. Pamahele mzuka wamzangila mundu yula pamonga na vandu kumuvika mugati na kumkunga minyololo mu mawoko na mumagendelu nambu pamahele adenyayi vifungo vyenivyo, na kujumbiswa kwa makakala ga mzuka wenuwo mbaka kulugangatu. ");
INSERT INTO xnj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu akamkota, “Liina laku yani?” Akayangula, “Liina langu Msambi.” Ndava mizuka yamahele yamuyingili. ");
INSERT INTO xnj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mizuka yila yikamjovela Yesu pepayi chonde akotoka kuyipeleka kuligodi langali mwishu. ");
INSERT INTO xnj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kwavi na maguluvi gamahele gevadimayi kuchitumbi pandu penapo, ndi mizuka yila yikamuyupa Yesu yihamba kuyingila mumaguluvi gala. Yesu akayileka yihamba. ");
INSERT INTO xnj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndi mizuka yila yikamuwuka mundu yula yikagayingila maguluvi gala, na msambi wa maguluvi ukahelela munyanja na kuyongomela, gakafwa mumanji. ");
INSERT INTO xnj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vadimaji va maguluvi pevaloli gegahumali vakajumba, kuhamba kumuji na kumigunda kuvajovela vandu ujumbi. ");
INSERT INTO xnj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Vandu vakabwela kulola gegahumalili, vakamuhambalila Yesu, vamuwene mundu mwe yamuhumili mizuka yula, atamili papipi na magendelu ga Yesu, awali nyula, na avi na luhala lwaki bwina. Voha vakayogopa. ");
INSERT INTO xnj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vandu vevagaweni mambu genago, vakavajovela vayavi chealamiswi mundu yula. ");
INSERT INTO xnj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vakolonjinji voha wa ku Gelasi vakavya na wogohi neju. Vakamuyupa Yesu awukayi ahamba kungi. Yesu akakwela muwatu akawuka. ");
INSERT INTO xnj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu mweamuwusi mizuka yula, amuyupili Yesu valongosanayi. Nambu Yesu nakumuyidakila, ndi akamjovela, ");
INSERT INTO xnj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wuya kunyumba yaku ukavajovelayi gaakuhengili Chapanga.” Ndi mundu yula akahamba kila pandu kumuji woha akuvajovela vandu chaamhengili Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu paawuyili kumwambu yingi ya nyanja, avakoli msambi wa vandu vampokali chaluheku, ndava voha vamlindilayi. ");
INSERT INTO xnj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Penapo akabwela mundu mmonga liina laki Yailusi avi chilongosi wa nyumba ya kukonganekela akamfugamila Yesu mumagendelu, akamuyupa Yesu ahamba kunyumba yaki, ");
INSERT INTO xnj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","muni msikana waki ngayuyoyo mmonga, wa miiyaka kumi na yivili avi mtamu papipi kufwa. Yesu avi mukuhamba, msambi wa vandu wavi kumuhinya kila upandi. ");
INSERT INTO xnj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kwavi na mdala mmonga pagati ya msambi wula wa vandu, avi na utamu wa kuhuma ngasi miyaka kumi na yivili, amalili kuwusa vindu vyaki vyoha kuvapela valamisa, kawaka mweahotwili kumlamisa. ");
INSERT INTO xnj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mdala yula akamlanda Yesu mumbele akapamisa lugunyilu lwa pahi lwa nyula ya Yesu. Bahapo akalama. ");
INSERT INTO xnj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu akajova, “Yani mweanipamisi?” Vandu vakajova, Kawaka mundu mwaakupamisi. Petili akajova, “Bambu msambi wa vandu vakutindili na kukuhinya!” ");
INSERT INTO xnj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nambu Yesu akajova, “Avili mundu mweanipamisi, muni nijiyuwini makakala ganihumili.” ");
INSERT INTO xnj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mdala yula paajiloli nakuhotola kujifiha, akabwela kuni hivagaya akamfugamila Yesu mumagendelu. Akamjovela pavandu voha ndava ya kumpamisa Yesu na chaalami bahapo. ");
INSERT INTO xnj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu akamjovela, “Msikana wangu, kusadika kwaku kukulamisi, uhamba na uteke.” ");
INSERT INTO xnj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu paavi akona ilongela, akabwela mundu kuhuma kunyumba ya Yailo, akamjovela Yailo, “Leka kumung'aha Muwula, mwana waku mwene afwili.” ");
INSERT INTO xnj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu peayuwini genago, akamjovela Yailo, “Kotoka kuyogopa, sadika ndu, yati ilama.” ");
INSERT INTO xnj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Peahikili panyumba pala, akavatola Petili na Yohani na Yakobo pamonga na dadi na nyina wa msikana yula akayingila nawu mugati, vandu vangi avalekili kuvala. ");
INSERT INTO xnj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vandu voha vavembayi na malilu kwa lipyanda ndava ya mwana yula. Nambu Yesu akavajovela, “Mkotoka kuvemba, muni mwana uyu afwili lepi, agonili ndu.” ");
INSERT INTO xnj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Voha vakamuheka, muni vamanyili kuvya mwana yula afwili. ");
INSERT INTO xnj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kangi Yesu akamkamula chiwoko mwana yula na kumkemela, “Mwana yimuka!” ");
INSERT INTO xnj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mpungu waki ukamuwuyila, bahapo akayimuka. Yesu akavajovela mumpela chakulya. ");
INSERT INTO xnj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dadi na nyina wa mwana yula vakakangasa, Nambu Yesu akavajovela vakotoka kumjovela mundu yoyoha mambu gala gegahengiki. ");
INSERT INTO xnj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu akavakemela vawuliwa vaki kumi na vavili pamonga akavapela makakala na uhotola panani ya mizuka yoha na kulamisa matamu. ");
INSERT INTO xnj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kangi akavatuma vahamba vakakokosa Unkosi wa Chapanga na kulamisa vatamu. ");
INSERT INTO xnj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akavajovela, “Mkotoka kutola chindu chochoha chila mulugendu lwinu ngati ndonga amala lihaku amala chakulya amala mashonga amala kuvya na magwanda gavili pagati yinu. ");
INSERT INTO xnj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba yeyoha yemwiyingila na vavapokili mutama penapo mbaka pemwiwuka pamuji wenuwo, ");
INSERT INTO xnj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na vandu ngati vabelili kuvapokela, muwukayi pamuji wenuwo, na pemwiwuka muvakung'undila lububu lwa mumagendelu ginu kuvalangisa kuvya vene vahagwili kubela ujumbi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Vawuliwa vakawuka penapo, vakahamba muhijiji na kuvakokosela vandu Lilovi la bwina na kuvalamisa vandu vana matamu. ");
INSERT INTO xnj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hinu, nkosi Helodi peayuwini mambu goha gegahengiki, akavagaya ndava muni vandu vajovayi, “Yohani Mbatizaji ayukili!” ");
INSERT INTO xnj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Vangi vakajova Eliya ahumalili na vangi vakajova mwenuyu mmonga wavi vamlota va Chapanga va kadeni vawuyili pamulima. ");
INSERT INTO xnj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nambu Helodi akajova, “Ngati Yohani namdumwili mutu, hinu yani mwenuyu mweniyuwana malovi gaki?” Akanogela kumlola. ");
INSERT INTO xnj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Vamitumi vala pavawuyili vakamjovela Yesu goha gavahengili. Yesu akavatola vene, akahamba nawu kuchiyepela kumuji wavaukemela Betisaida. ");
INSERT INTO xnj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nambu msambi wa vandu pawamanyili kwa ahambili Yesu vakamlanda. Yesu avapokili, akavajovela malovi ga Unkosi wa Chapanga na kuvalamisa vandu voha vevavi na matamu vakalama. ");
INSERT INTO xnj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lilanga palatumbula kutipama, vawuliwa kumi na vavili vala vakamjovela, “Valagayi vandu vahamba muhijiji na mumigunda ya papipi vakajilondela vyakulya na pandu pa kugona muni petivii palugangatu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nambu Yesu akavajovela, “Muvapelayi nyenye chindu chakulya.” Vakamyangula. “Tete tivii na mabumunda mhanu na somba zivili ndu. Manya tihamba tikavagulila vyakulya msambi uwu woha.” ");
INSERT INTO xnj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Muni vavi vagosi, ngati elufu mhanu. Yesu akavajovela vawuliwa vaki, “Muvajovela vandu vatamayi hikundi ya vandu ngati hamsini hamsini.” ");
INSERT INTO xnj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Vawuliwa vakakita ngati cha avajovili, vakavatamisa voha. ");
INSERT INTO xnj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu akatola mabumunda mhanu na somba zivili zila, akalola kunani, akayimotisa, akayinukula akavapela vawuliwa vaki vavagavanisila vandu. ");
INSERT INTO xnj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vandu voha valili na kuyukuta. Ndi vakanonga na kumemesa madengu kumi na gavili ga hipandi yeyisigalili. ");
INSERT INTO xnj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ligono limonga Yesu ayupayi kwa Chapanga mwene ndu, na vawuliwa vaki vavi papipi. Ndi, akavakota, “Vandu vijova kuvya nene ndi nayani?” ");
INSERT INTO xnj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Vene vakamyangula, “Vangi vijova veve Yohani Mbatizaji na vangi vijova Eliya na vangi vijova wa mmonga wa vamlota va Chapanga va kadeni mweayukili.” ");
INSERT INTO xnj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Penapo Yesu akavakota, “Nambu nyenye mwijova kuvya nene ndi yani?” Petili akamyangula, “Veve ndi Kilisitu Msangula mwauhumili kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kangi Yesu akavalagiza na kuvabesa vakotokayi kumjovela mundu yoyoha yula genago. ");
INSERT INTO xnj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mewa akavajovela, “Mwana wa Mundu iganikiwa kung'ahika neju na kubelelewa na vagogo na Vakulu va Kuteta na vawula va malagizu ga Chapanga geampeli Musa na kukomewa na muligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ndi akavajovela vandu voha, “Mundu yoyoha yula mweigana kunilanda na ajibelayi hoti mwene agega msalaba waki magono goha anilandayi. ");
INSERT INTO xnj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Muni mundu mweigana kuugombola wumi waki yati awuyagisa na yoyoha mweauyagisa wumi waki kwa kunilanda nene yati akuusangula. ");
INSERT INTO xnj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ngati mundu apatili vindu vyoha pamulima apa kuni iyagisa amala kujikomakesa mwene wumi waki, mundu mwenuyo apatili chindu kiki chabwina? ");
INSERT INTO xnj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ndava muni mundu yeyoha yula ngati ikola soni kwa nene na mawuliwu gangu, Mwana wa Mundu, yati ikola soni kwa mundu mwenuyo peibwelayi muukulu waki na wa Dadi waki na mitumu va msopi wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chakaka nikuvajovela, vavi vandu vangi penapa yati vifwa lepi changaulola Unkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Magono nane kuhuma Yesu peavajovili malovi genago, ndi Yesu akavatola Petili na Yohani na Yakobo kuhamba nawu kuchitumbi kumuyupa kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Peavili mukuyupa Chapanga, ulolekanu wa pamihu paki pang'anamwiki na nyula zaki zikavya zamsopi na kung'asima neju. ");
INSERT INTO xnj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bahapo vandu vavili vawonikini kulongela nayu, vandu vene vavi Musa na Eliya, ");
INSERT INTO xnj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","vahumili muukulu, ndi valongela nayu ndava ya lifwa laki, na kukita lihengu lelimalikisila ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petili na vayaki vavi mulugono tipi tipi, nambu pavayimwiki vauwene ukulu wa Yesu, vavawene na vandu veayimili nawu vala. ");
INSERT INTO xnj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pavamlekili, Petili akamjovela Yesu, “Bambu, nilola chabwina tete kutama bahapa! Hinu tijengi tundanda tudatu, chimonga chaku na chingi cha Musa na chingi cha Eliya.” Chakaka mwene nakumanya chavamjovili. ");
INSERT INTO xnj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petili peajovayi ago, bahapo lihundi likahumila na kuvahulukila ndi lihundi palavahulukili vene vavi na wogohi neju. ");
INSERT INTO xnj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lwami lukayuwanika mulihundi mula. “Mwenuyu ndi Mwana vangu mwenimuhagwili, mumyuwanila.” ");
INSERT INTO xnj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lwami lula Palwayuwanika, Yesu awonakini avi mwene. Vawuliwa vaki vakavya nuu mu mambu genago na lukumbi lwenulo kawaka mundu mwavamjovili. Gevagaweni. ");
INSERT INTO xnj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chilau yaki Yesu pamonga na vawuliwa vadatu vala vahelelayi kuhuma kuchitumbi kula, vakakonganeka na msambi wa vandu. ");
INSERT INTO xnj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Penapo mundu mmonga akamkemela na kujova, “Muwula! Chondi mhengela lipyana mwana vangu, muni avili ngayuyu mwene! ");
INSERT INTO xnj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yuwanila mzuka ukumzangila, na bahapo liywanga, kuni litovesa ligoji na lihuluhulu lihuma mumlomo, na likumung'aisa palukumbi lutali changamleka. ");
INSERT INTO xnj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Navayupili vawuliwa vaku vauvinga mzuka wula, nambu nakuhotola.” ");
INSERT INTO xnj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu akayangula, akajova, “Nyenye chiveleku changasadika, na chechiyagili, yati nitama na nyenye na kuvasindimalila mbaka ndali?” Ndi akamjovela mkolo mwana yula, “Mleta mwana waku apa.” ");
INSERT INTO xnj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mwana yula peambwelili Yesu, mzuka ukamgwisa pahi na kumsopa ligoji. Nambu Yesu akauhakalila mzuka wula na kumlamisa mwana yula, akampela dadi waki. ");
INSERT INTO xnj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vandu voha vakakangasa makakala gakulu ga Chapanga. Vandu pavavi vakona vikangasa ndava ya mambu geagahengili, Yesu akavajovela vawuliwa vaki, ");
INSERT INTO xnj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Muyuwanila bwina malovi aga, Mwana wa Mundu ihamba kusopiwa mumawoko ga vandu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nambu vawuliwa vaki vavi nakugamanya malovi gaavajovili muni malovi gala gafiyiki kwavi ndava vakotoka kugamanya. Na vene vavi na wogohi kumkota mana ya malovi ago. ");
INSERT INTO xnj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Vawuliwa va Yesu vakatumbula kukotana veve kwa veve, yani mkulu kuliku voha. ");
INSERT INTO xnj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu amanyili maholo ga mumitima yavi, ndi akamtola mwana mng'enya, akamuvika papipi yaki, ");
INSERT INTO xnj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na akavajovela, “Mundu mweakumpokela mwana mdebe uyu kwa liina langu, mwenuyo akunipokela nene, na mundu yeyoha yula mweakunipokela nene, akumpokela mweanitumili. Muni mundu mweavi mdebe pagati yinu, ndi mkulu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohani akamjovela Yesu, “Bambu, tikamuweni mundu ivinga mizuka kwa liina laku na tete talingili kumbesa ndava mwene alongosini lepi na tete.” ");
INSERT INTO xnj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu akavajovela, “Mkotoka kulinga kumbesa, ndava yeyoha mwangatovana na nyenye avi upandi winu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lukumbi lwa Yesu palwahegalili lwa kutoliwa kuhamba kunani kwa Chapanga, ndi Yesu akagana neju kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na, avatumili vajumbi vamulongolela, vakayingila muchijiji chimonga cha Vasamaliya ndava ya kumtendelekeha bwina kila chindu. ");
INSERT INTO xnj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nambu vakolo njinji va penapo nakugana kumpokela Yesu ndava vamanyili ngati Yesu aganili kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lukumbi vawuliwa vaki vakina Yohani na Yakobo pavaloli genago, vakajova, “Bambu ugana tilagizayi motu kuhuma kunani kwa Chapanga luvatinyisayi?” ");
INSERT INTO xnj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nambu Yesu akavang'anamukila, akavahakalila. ");
INSERT INTO xnj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kangi Yesu na vawuliwa vaki vakahamba kuchijiji chingi. ");
INSERT INTO xnj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pavagendayi munjila, mundu mmonga akamjovela Yesu, “Yati nikulanda kokoha kula kwewihamba.” ");
INSERT INTO xnj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akamjovela, “Mahogo gana mbugu za kugona na videge vina chisakanilu nambu mwana wa Mundu avi lepi na pandu pakupumulila.” ");
INSERT INTO xnj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu akamjovela mundu yungi, “Nilandayi.” Nambu mundu yula akamyangula, “Bambu, nileka hoti nihamba nikamuzika dadi wangu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nambu Yesu akamyangula, “Valeka vevafwili vavazikayi vevafwili vavi, nambu veve uhamba ukakokosa Unkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mundu yungi akamjovela, “Bambu yati nikukulanda, nambu nikuyupa nikavalaga hoti vandu va kunyumba yangu.” ");
INSERT INTO xnj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nambu Yesu akamyangula, “Mundu yeyoha mweikamula ligela kutumbula kulima kuni ilolokesa mumbele, mwenuyo nakuganikiwa muunkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagamaliki genago, Bambu akavahagula vandu vangi sabini na vavili, akavatuma vavili vavili vamulongolela kukila chijiji na kungi kweagana mwene kuhamba. ");
INSERT INTO xnj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akavajovela, “Mabenu gamahele, nambu vabenaji vadebe. Mumuyupa mkolo mgunda avatuma vabenaji kumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hinu muhamba! Mumanya kuvya nikuvatuma nyenye ngati limbelele gegihamba pagati ya libwa la mudahi. ");
INSERT INTO xnj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mkotoka kutola chihaku cha mashonga amala lihaku wala Champali na munjila, mkotoka kumjambusa mundu yoyoha yula. ");
INSERT INTO xnj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nyumba yoyoha yemuyingila, muvajambusa, ‘Uteke uvyayi munyumba iyi.’ ");
INSERT INTO xnj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ngati avi mundu mweigana uteke, ndi uteke winu yati yitama na mwene! Ngati avi lepi, uteke winu yivawuyila mwavene. ");
INSERT INTO xnj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mutama panyumba yeniyo, mlyayi na kunywa vyevakuvapela. Ndava muni mwanalihengu yiganikiwa apewa njombi yaki. Mkotoka kuwuka panyumba iyi na kuhamba panyumba yila. ");
INSERT INTO xnj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pamuji wowoha wemuhikila na vandu ngati vavapokalili, mlyayi vyevakuvapela. ");
INSERT INTO xnj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Muvalamisa vana matamu vevavi kwenuko, muvajovela vandu, Unkosi wa Chapanga uvi papipi na nyenye. ");
INSERT INTO xnj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nambu mukayingili pamuji wowoha wula na vakolo muji nakuvapokela, muwuka penapo, na pemwigenda munjila zavi mujova. ");
INSERT INTO xnj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Pamonga na lububu lwa muji winu lweluvi mumagendelu gitu, tikuvahungulila kulangisa mwavene muhagwili kubela ujumbi wa Chapanga. Nambu, mumanyalila kuvya, Unkosi wa Chapanga uvi papipi na nyenye!’ ");
INSERT INTO xnj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Chakaka nikuvajovela, ligono la muhalu ukulu, Chapanga yati avalipisa pavaha kwa uhakau winu kuliku vandu va ku Sodoma!” ");
INSERT INTO xnj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Walachikolela veve Kolazini! Walachikolela veve Betisaida! Muni, gachinamtiti yeyakitiki kwinu, kuvya nga gakitiki ku Tilo na ku Sidoni, kutumbula penapo vandu vaki ngavamali kuwala nyula za magunila na kutama palyenge kulangisa vamuwuyili Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hinu ligono la muhalu mkulu, Chapanga yati akuvabuna pavaha kuliku vandu va ku Tilo na ku Sidoni. ");
INSERT INTO xnj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na veve Kapelanaumu, yati ukujikwiha mbaka kunani kwa Chapanga? Lepi yati vakuhulusa mbaka kuligodi litali langali mwishu!” ");
INSERT INTO xnj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kangi Yesu akajova, “Mundu mweakuvayuwanila nyenye, akuniyuwanila nene na mundu mweibela kuvapokela nyenye, ibela kunipokela nene. Na mundu yoyoha mweibela kunipokela nene, ibela kumpokela mweanitumili nene.” ");
INSERT INTO xnj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vawuliwa vala sabini na vavili vawuyili kuni visangaluka vakamjovela, “Bambu na mizuka nayene yikatiyidakili petakayihakalili kwa liina laku.” ");
INSERT INTO xnj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mwene akavajovela, “Namuweni Setani ihelela kuhumila kunani ngati lumuli lwa mbamba.” ");
INSERT INTO xnj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Muyuwanila! Nivapeli kuhotola kulivatila liyoka na chipilili, pamonga na kugabesa makakala goha ga likoko kawaka chindu cha kuvalemasa. ");
INSERT INTO xnj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nambu mkotoka kuheka ndava ya mizuka cheyikuvayidakila, ndi muhekelela muni mahina ginu gayandikiwi kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lukumbi lulalula, Mpungu Msopi ammemisi Yesu luheku, akajova, nikusengusa wa Dadi, Bambu wa kunani na pamulima! Muni mambu aga uvafihiyili vevavi na luhala na vamanyaji, ubweli kuvagubukulila vana vadebe. Ena, Dadi ndi chawaganili. ");
INSERT INTO xnj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Akayendelela kujova, “Dadi wangu anipeli vindu vyoha. Avi lepi mweammanyi Mwana nga Dadi na avi lepi mweammanyi Dadi nga Mwana na yoyoha mweaganili kumgubukulila.” ");
INSERT INTO xnj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kangi avang'anamkili vawuliwa vaki akalongela nawu pachiepela, “Mmotisiwa nyenye kwa kulola chenicho chemwilola! ");
INSERT INTO xnj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chakaka, nikuvajovela vamlota va Chapanga na vankosi vanogili kugawona gemukugawona nyenye aga nambu vagaweni lepi, pangi vaganili kuyuwana gemyuwana nyenye aga, nambu vayuwini lepi.” ");
INSERT INTO xnj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mundu mmonga mwamanyili bwina malagizu, ayimili akamkota Yesu cha kugana kumlinga. “Muwula, nikita wuli, muni nipokela wumi wa magono goha?” ");
INSERT INTO xnj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu akamkota, “Kiki chiyandikiwi mu Malagizu ga Musa? Ukuyisoma wuli?” ");
INSERT INTO xnj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mundu yula akamyangula, “Umgana Bambu Chapanga waku kwa mtima waku woha na kwa wumi waku woha na kwa makakala gaku goha na kwa luhala lwaku loha. Na, umganayi muyaku ngati cheujigana wamwene.” ");
INSERT INTO xnj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu akamjovela, “Chabwina! Kakita chenicho na veve yati wilama.” ");
INSERT INTO xnj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nambu mwene aganili kulangisa kuvya amanyili cheachikotili, ndi akamkota Yesu, “Wu, muyangu ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akamyangula akajova, “Kwavi na mundu mmonga mweahelela kuhuma ku Yelusalemu kuhamba ku Yeliko, munjila vanyagaji, vakamzangila na kumtova, na vakamuhula nyula na kumnyaga vindu vyaki vyoha vyeavinavyu, vakamleka penapo avi mulung'olelu. ");
INSERT INTO xnj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na ngipu yene Mteta wa Chapanga mmonga apitayi njila yilayila, peamuweni mundu yula mweazangiwi, akaveduka kumuhana akahamba. ");
INSERT INTO xnj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mewawa mundu Mlawi mmonga, apitili penapo peamuwene mweazangiwi yula akaveduka pamuhana akahamba. ");
INSERT INTO xnj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nambu Msamaliya mmonga mweavi mulugendu ahikili peavi mundu yula ndi peamuwene akamhengela lipyana. ");
INSERT INTO xnj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akamuhegelela, akamnyala mahuta na kumsopa divayi muvilonda vyaki na kuvinyembelela bwina, kangi akamkwesa panani ya punda waki, akahamba nayu ku nyumba ya vayehe, na kumlwasa. ");
INSERT INTO xnj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chilau yaki akawusa mashonga dinali zivili akampela myimilila nyumba ya vayehe, akamjovela, mlwasa mundu uyu, na peniwuyayi yati nikukulipa chochoha cheuyonjokesa.” ");
INSERT INTO xnj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kangi Yesu akakota, “Pagati ya vandu vadatu ava, muyaki wa yula mweazangiwi na vanyagaji ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muwula wa malagizu ga Chapanga geampeli Musa yula akamyangula “Ndi yula mweamhengili lipyana.” Yesu akamjovela, “Uhamba ukakita mewa.” ");
INSERT INTO xnj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na vawuliwa vaki pavavi mulugendu, vakayingila muchijiji chimonga, penapo mdala mmonga mwavamkemela Malita, akavagongolela kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita yula, avi na mlumbu waki mwavamkemela Maliya, mwenuyo atamili papipi na Yesu na kuyuwanila malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nambu Malita ajifwahisa na mahengu gamahele. Ndi, akamuhambila Yesu, akamjovela, “Bambu, nakumlola mlumbu wangu anileki mahengu aga namwene? Hinu mjovelayi anitangatilayi.” ");
INSERT INTO xnj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nambu Bambu akamyangula, “Malita, Malita, Veve ujifwahisa na kujing'aha na mambu gamahele. ");
INSERT INTO xnj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nambu chiganikiwa chindu chimonga ndu. Na Maliya ahagwili lilundu labwina, na kawaka mundu wa kumnyaga.” ");
INSERT INTO xnj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ligono limonga, Yesu avili pandu ayupayi kwa Chapanga. Peamalili, mmonga wa vawuliwa vaki akamjovela, “Bambu, tiwulayi na tete kuyupa kwa Chapanga ngati Yohani chaavawuli vawuliwa vaki.” ");
INSERT INTO xnj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu akavajovela. “Pemuyupa kwa Chapanga, mujova naha, Dadi, Liina laku lilumbiwa, Unkosi waku ubwelayi. ");
INSERT INTO xnj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utipela chakulya chitu cha magono goha. ");
INSERT INTO xnj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utilekekesayi getikubudila Chapanga, ndava muni na tete tikuvalekekesa vevakutibudila. Kotoka kutiyingisa mukulingiwa.” ");
INSERT INTO xnj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kangi akavajovela vawuliwa vaki, “Yani pagati yinu mweavi na nkozi, na akamhambila pagati ya kilu na kumjovela ‘Mlongo wangu, chondi niyayika mabumunda gadatu na kangi yati nikuwuyisila, ");
INSERT INTO xnj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ndava muni nkozi wangu anihikalili kuhuma mulugendu, na nene nivii lepi na chakumpela!’ ");
INSERT INTO xnj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ndi yula wa mugati, ngaamyangwili, ‘Kotoka kuning'aha! Muni, nimali kudinda mlyangu, nene na vana vangu tigonili, nakuhotola kuyimuka kukupela!’ ");
INSERT INTO xnj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nikuvajovela yati iyimuka lepi kuhamba kumpela pamonga na kuvya nkozi waki, nambu ndava ya kukangamala kwaki kuyupa, yati iyimuka na kumpela chochoha cheigana. ");
INSERT INTO xnj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hinu nikuvajovela, muyupa na nyenye yati mwipewa, mulonda yati mwipata, muhodisa mlyangu yati mwidinduliwa. ");
INSERT INTO xnj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Muni mundu yeyoha mweiyupa ipewa na mweilonda ipata na mweihodesa mlyangu idinduliwa. ");
INSERT INTO xnj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Muni yani mweavi dadi ndi mwana waki amuyupili somba wu, yati akumpela liyoka pahali pa somba? ");
INSERT INTO xnj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na ngati amuyupi likang'a yati ampela chipilili? ");
INSERT INTO xnj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hinu nyenye pamonga na uhakau winu, mumanyi kuvapela vana vinu vindu vyabwina, chakaka Dadi winu wa kunani yati ikita na pawaka, muni yati akuvapela Mpungu Msopi vala vevakumuyupa!” ");
INSERT INTO xnj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ligono limonga Yesu avi mukuuvinga mzuka wewamkitili mundu mmonga kuvya ngajova. Ndi, mzuka ukamuwuka, mundu yula akahotola kulongela, hati msambi wa vandu ukakangasa. ");
INSERT INTO xnj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nambu vandu vangi vakajova, “Ivinga mizuka kwa uhotola wa Belizebuli, mkulu wa mizuka.” ");
INSERT INTO xnj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vangi vakamlinga Yesu, vakamgana, akita gachinamtiti kulangisa kuvya uhotola waki uhumili kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nambu Yesu amanyili maholo gavi, akavajovela, Unkosi wowoha wula, weulekangini chikundi chikundi nakuhotola kusindimala, mewawa na vandu va nyumba yimonga vevalekangini yati viyaga. ");
INSERT INTO xnj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngati Setani ana chikundi chechikomana chene kwa chene, unkosi waki yati uyima wuli? Nijova genaga ndava nyenye mukunijova nene nivinga mizuka kwa uhotola wa Belizebuli. ");
INSERT INTO xnj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Vawuliwa vinu vivinga mizuka ngati mewa chenikita nene. Ndava kyani nyenye mwijova nene nivinga mizuka kwa uhotola wa Belizebuli? Hinu venavo ndi yati vakuvahamula nyenye. ");
INSERT INTO xnj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nambu ngati nivinga mizuka kwa uhotola wa Chapanga, ndi mumanya kuvya Unkosi waki umali kuhika kwinu. ");
INSERT INTO xnj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mundu mweavi na makakala, pailindalila nyumba yaki na vindu vya ngondo, vindu vyaki vyoha vivya bwina. ");
INSERT INTO xnj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nambu akabwelayi mundu yungi mweavi na makakala neju na kumzangila na kumnyaga vindu vyaki vya ngondo, mundu mwenuyo ihotola kuvitola vindu vyaki vyoha na kuvigavanisa. ");
INSERT INTO xnj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundu yoyoha yula mwangalongosana na nene, mwenuyo isigana, na yoyoha yula mweibela kunonga pamonga na nene, mwenuyo ipechengana.” ");
INSERT INTO xnj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mzuka ngati uvingiwi kwa mundu, ulyungalyunga kulugangatu mukulonda pandu pa kupumulila. Ngati apapati lepi ukujijovela, ‘Yati niwuya kunyumba yangu kwenikahumili.’ ");
INSERT INTO xnj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Peiwuya ikolela nyumba yila yitendelikiwi na vindu vivikiwi bwina. ");
INSERT INTO xnj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ndi, ihamba kuhitola mizuka hingi saba, yeyivi hihakau kuliku mwene, ndi penapo yoha yikumuyingila mundu yula. Mundu mwenuyo hinu wumi waki wivya uhakau neju, kuliku chaakavili lukumbi lwa kutumbula.” ");
INSERT INTO xnj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Paajovayi genago, mdala mmonga mweavi pagati ya msambi wa vandu akajova kwa lwami luvaha, “Limotisiwayi lileme lelikugegili na livele lelakunyong'isi!” ");
INSERT INTO xnj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu akajova, “Vamotisiwa veviyuwana lilovi la Chapanga na kulikamula!” ");
INSERT INTO xnj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Msambi wa vandu pawayonjokisi, Yesu akavajovela, “Chiveleku ichi ndi chihakau, chigana ulangisu kuhuma kunani kwa Chapanga, nambu yati nakupewa ulangisu wowoha manya ngawula wa Yona. ");
INSERT INTO xnj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mewawa Yona chalolikini kuvya ulangisu kwa vandu va ku Ninawi, ndi na Mwana wa Mundu yati ivya chinamtiti kwa chiveleku ichi. ");
INSERT INTO xnj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nkosi wa chidala wa kusini yati ihumila ligono la muhalu ukulu, lukumbi lwa muhalu wa chiveleku ichi na mwene yati ijova chiveleku ichi chibudili. Muni mwene agendili kuhuma mulima wa kutali kubwela kuyuwanila malovi ga luhala ga Nkosi Solomoni, nambu penapa avi mkulu kuliku Nkosi Solomoni. ");
INSERT INTO xnj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Vandu va ku Ninawi yati vihumila ligono la muhalu ukulu pamonga na vandu va chiveleku ichi yati vijova chibudili. Muni vandu va Ninawi vamuwuyalili Chapanga ndava ujumbi wa Chapanga weakokwisi Yona. Nambu penapa avi mkulu kuliku Yona!” ");
INSERT INTO xnj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kawaka mundu mweipambika hahi na kuyifiya amala kuyigubika na chiviga, nambu hahi ngati yipambikwi vivika kunani kuchibokoselu, muni yilangasayi bwina mugati mwoha na vandu voha veviyingila valola bwina. ");
INSERT INTO xnj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lihu laku ndi hahi ya higa yaku. Ngati lihu laku livi bwina, higa yaku yivi mulumuli. Nambu lihu laku likoywiki, higa yaku yivi mchitita. ");
INSERT INTO xnj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mujilolayi neju, lumuli lweluvi mugati yaku lukoto kuvya chitita. ");
INSERT INTO xnj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndi, ngati higa yaku yoha una lumuli, changali pandu pangi kuvya chitita, higa yaku yati ying'asima ngati hahi cheyilangasa kwa lumuli lwaki.” ");
INSERT INTO xnj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu peamali kujova genago, Mfalisayu mmonga amgongolili Yesu kulya chakulya kunyumba yaki ndi Yesu akahamba kwenuko, na akatama kulya. ");
INSERT INTO xnj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisayu yula akakangasa, muni amuweni Yesu asambili lepi kwakona chakulya. ");
INSERT INTO xnj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bambu akamjovela, “Nyenye Vafalisayu msanja chikombi na nkeve kuvala, nambu mugati mumemili kugana vindu vyamahele na uhakau. ");
INSERT INTO xnj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Vayimu nyenye! Wu, Chapanga awumbili lepi vya kuvala, na kangi awumbili lepi vya mugati? ");
INSERT INTO xnj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nambu muvapela vangangu vyevivili mugati, munkele na muchikombi na kila chindu chivyaa chabwina kwa nyenye.” ");
INSERT INTO xnj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yati muchikolela nyenye Vafalisayu, muni mkumpela Chapanga lilundu limonga pagati ya kumi za ndimbilu na libonongo na mahamba gangi ga likolo. Nambu mwileka kuvakitila vandu gegiganikiwa, na kumgana Chapanga. Yikuvagana kugakamula genago changali kukosiwa na gangi gala.” ");
INSERT INTO xnj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yati muchikolela nyenye Vafalisayu, ndava mwigana kutama muvigoda vya kulongolo munyumba za kukonganekela Vayawudi na kujambuswa na vandu cha kugundamiliwa pavikonganika vandu. ");
INSERT INTO xnj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yati muchikolela, ndava muni muvi ngati matinda gegafiyiki na vandu vigenda panani yaki changamanya.” ");
INSERT INTO xnj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mundu mmonga mweimanya malagizu akamyangula, “Muwula, malovi gaku ukutiliga na tete.” ");
INSERT INTO xnj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akamyangula, “Na nyenye mwemwimanya malagizu yati muchikolela! Muni mukuvagegesa vandu ndwika yeyitopa yangagegeka, na kuni mwavene nakutalambula hata lung'onji kuvatangatila. ");
INSERT INTO xnj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mwalachikolela nyenye! Muni mwijenga matinda ga vamlota va Chapanga, vavakomiwi na vagogo vinu. ");
INSERT INTO xnj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mewawa mwavene mwilangisa chakaka na kuyidakila na matendu ga vagogo vinu, muni vene vavakomili vamlota va Chapanga na nyenye mwijenga matinda gavi. ");
INSERT INTO xnj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ndava ya genago, luhala lwa Chapanga lwajovili naha, ‘Yati nivaletela vamlota na vamitumi, nambu vangi vikomiwa na vangi yati ving'ahiswa.’ ");
INSERT INTO xnj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndi vandu va lukumbi ulu yati viyingila mumuhalu, ndava ya lifwa la vamlota va Chapanga voha vevakomiwi kutumbula kuwumbikiwa kwa mulima, ");
INSERT INTO xnj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kutumbula peakomiwi Abeli mbaka kukomiwa kwa Zakalia mwevamkomili pagati ya lusanja lwa luteta na pandu pamsopi. Ena chakaka, chiveleku ichi chiyingila mumuhalu ndava ya matendu genago.” ");
INSERT INTO xnj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mwalachikolela nyenye mwemumanya Malagizu! Muni mufiyili fungulu wa mlyangu wa kumanya, nyenye mwavene nakuyingila, na muvabelalili vevakaliyigila vakotoka kuyingila!” ");
INSERT INTO xnj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu pawukili penapo, Vafalisayu na vawula va malagizu kutumbula penapo vakamyomela neju na kumlinga kwa kumkota mambu gamahele, ");
INSERT INTO xnj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Muni vagana kumkamula kwa malovi geijova. ");
INSERT INTO xnj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Msambi uvaha wa vandu wanga valangika, pavakonganiki na kutumbula kulivatilana. Yesu avajovili hoti vawuliwa vaki. “Mujiyangalila na ngemeku ya Vafalisayu ndi uhomela wavi. ");
INSERT INTO xnj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chindu chochoha chila chechigubikiwi yati chigubukuliwa na chochoha chechifiyiki yati chimanyikana. ");
INSERT INTO xnj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gala gamwajovili kuchitita, yati giyuwanika pepilangala, na chochoha chamwapwepi mumfiyu mugati kuni milyangu yidindanu, yati chikokoselewa pamulima woha.” ");
INSERT INTO xnj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nikuvajovela, nyenye mwavankozi vangu, mkotoka kuvayogopa vala vevikoma higa, nambu nakuhotola kukita chindu chingi kangi. ");
INSERT INTO xnj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yati nivalangisa wa kuyogopewa, mumuyogopa Chapanga, akamala kukukoma, ihotola kumutaga mundu kumotu wa magono goha wangajimika. Nikuvajovela, mumuyogopa mwenuyo!” ");
INSERT INTO xnj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Yimanyikini kuvya mayeluyelu mhanu ziguliswa kwa mashonga gadebe neju, nambu kawaka hata njasi yimonga yeyikosiwa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hati umahele wa mayunju ga mitu yinu zimanyikini kwa Chapanga. Mukotoka kuyogopa, nyenye mwitopela neju kuliku mayeluyelu gamahele!” ");
INSERT INTO xnj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Chakaka nikuvajovela, mundu yoyoha yula mwaakuniyidakila pavandu kuvya mwene ndi wangu, Mwana wa Mundu yati amuyidakila palongolo ya vamitumu va Chapanga kuvya mwenuyo mundu waki. ");
INSERT INTO xnj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nambu mundu yoyoha yula mwaakunibela pavandu, na Mwana wa Mundu mewawa yati akumbela palongolo ya vamitumu va Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yoyoha yula mweijova lilovi la kumubelelela Mwana wa Mundu, mwenuyo yati ilekekeswa, nambu mweamliga Mpungu Msopi, yati ivya nakulekekeswa.” ");
INSERT INTO xnj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pevakuvapeleka nyenye kwa makakala, munyumba za kukonganekela Vayawudi, amala vahamula mihalu, amala kwa vachilongosi lenili muhamuliwa mkotoka kuvya na wogohi yati myangula kyani amala yati mujova wuli. ");
INSERT INTO xnj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Muni lukumbi lulolo, Mpungu Msopi yati akuvawula gakujova.” ");
INSERT INTO xnj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu mmonga mu msambi wa vandu akamjovela Yesu, “Muwula, mjovela mlongo wangu tigavana vindu vyetihalili kwa dadi witu.” ");
INSERT INTO xnj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akamyangula, “Nkozi wangu, yani mweaniviki nene kuhamula mihalu pagati yinu amala kuvya mtepulanisa?” ");
INSERT INTO xnj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndi, akavajovela voha, “Mujiyangalilayi na kuvya na mtima wa kugana vindu vyamahele, muni wumi wa mundu uvi lepi muvindu vyamahele vyeavi navyu.” ");
INSERT INTO xnj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kangi akavajovela luhumu ulu. Kwavi na mundu mmonga mweavi na vindu vyamahele, mgunda waki wapambiki mabenu gamahele. ");
INSERT INTO xnj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akaholalela mumtima waki na kujova. Hinu nikita wuli muni kawaka pandu pakuvika mabenu gangu? ");
INSERT INTO xnj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ndi, yati nikita aga, yati nidenya chibana changu na kupamanda kangi vivaha na mwenumo yati nivika mabenu gangu goha pamonga na vindu vyangu. ");
INSERT INTO xnj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kangi nikujijovela namwene, hinu uvinavyu vindu vyabwina vyeukuvigana mumiyaka yamahele ndi upumulilayi na ulyayi na unywayi na uheka! ");
INSERT INTO xnj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nambu Chapanga akamjovela, Uhimwiki veve, kilu ya lelu wumi waku yati utoliwa. Na vindu vyeujivikili yati vivya vya yani? ");
INSERT INTO xnj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu akamalisila kujova, “Chenichi ndi cheyivya mundu mweajivikili vindu vyamahele ndava yaki mwene, nambu palongola ya Chapanga ivya mngangu.” ");
INSERT INTO xnj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kangi Yesu akavajovela vawuliwa vaki, “Ndava ya genago, nikuvajovela, mkotoka kung'ahikila ndava ya chakulya chemugana muni mulamayi, amala nyula zemukuzigana ndava ya higa yinu. ");
INSERT INTO xnj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndava muni wumi witopela kuliku chakulya, na higa yitopela kuliku nyula. ");
INSERT INTO xnj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lola makungulu, gimija lepi, wala kubena na gangali chibana. Pamonga na genago, Chapanga agalisa chakulya. Hinu nyenye mwitopela kuliku videge! ");
INSERT INTO xnj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yani mweavi pagati yinu kwa kujing'aha ihotola kujiyonjokesala hati ligono limonga la wumi waki? ");
INSERT INTO xnj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hinu ngati, nakuhotola kuhenga chindu chidebe ngati ichi, ya kyani kujing'aha na mambu gangi? ");
INSERT INTO xnj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mugalola maluva ga mdahi chegikula, nakuhenga lihengu wala giluka lepi nyula. Nambu nikuvajovela nkosi Solomoni pamonga na kuvya na vindu vyamahele, nambu avi lepi na nyula za kunyamba ngati liluva limonga. ");
INSERT INTO xnj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hinu ngati Chapanga akuganyambisa manyahi ga kumgunda, lelu livili na chilau yaki giyochwa pamotu, wu, nakuhotola kuvawalika nyenye? Vandu mwemusadika padebe.” ");
INSERT INTO xnj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Na nyenye mkotoka kuhololela neju ndava ya kung'ahikila kuvya mwilya kyani amala mwinywa kyani. ");
INSERT INTO xnj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Muni vandu vangasadika va milima yingi ya pamulima uwu, vavi mukung'ahika ndava ya genago. Nambu nyenye, Dadi winu avimanyili vindu vyoha vyemugana. ");
INSERT INTO xnj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hinu, mun'gaikila kulonda hoti Unkosi wa Chapanga na genago yati mwipewa kwa kuyonjokeswa.” ");
INSERT INTO xnj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mukotoka kuyogopa nyenye msambi udebe, muni Dadi winu aganisiwi kuvapela Unkosi waki. ");
INSERT INTO xnj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mugulisa vindu vinu, na mashonga gene muvatangatila vangangu. Mujikitila chihaku cha mashonga changalala na kijivikila vindu vinu vyabwina kunani kwa Chapanga kwangapunguka. Kwenuko vahiji nakuhegelela, wala vingokoko na kuhalibisa. ");
INSERT INTO xnj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pechivi chibana chaku ndi maholo na luhala lwa mtima waku yati uvya penapo.” ");
INSERT INTO xnj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mujitendekela na kuhengeka kuni, na hahi zinu ziyaka, ");
INSERT INTO xnj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","muvya ngati vavanda vavamulindila mkulu wavi mweihuma kundowa, vamudindulila mlyangu peihodesa. ");
INSERT INTO xnj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vamotiswa vavanda vala bambu wavi peuwuya akuvakolela vakona mihu! Chakaka nikuvajovela, bambu yula yati ikunga mkungi muchiwunu na kuvajovela vatama pahi pandu pakulyelela na akavahengela. ");
INSERT INTO xnj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vamotisiwa vavanda vala, hati ngati bambu wavi peiwuya pagati ya kilu amala hati hambakucha na kuvakolela vakona mihu! ");
INSERT INTO xnj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mumanyila lijambu lenili, ngati mkolo nyumba ngamanyili lukumbi lwa muhiji kubwela, ngaatamili mihu, ngaileki lepi nyumba yaki yidenyewayi. ");
INSERT INTO xnj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mewawa na nyenye yikuvagana mujitendelekeha, ndava mwangalumanya lukumbi, Mwana wa Mundu peibwela.” ");
INSERT INTO xnj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petili akamkota, “Bambu, luhumu ulu ukutijovela nga tete amala ukuvajovela vandu voha?” ");
INSERT INTO xnj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bambu akayangula. Ndi, yani mweavi mtumisi mbwina na analuhala? Kangi bambu waki amuviki kuvayimalila vavanda vangi na kuvapela chakulya pa lukumbi lwaki. ");
INSERT INTO xnj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Asangaluka mtumisi yula, ngati mkulu waki peiwuyayi yati amkolela ikita chenicho. ");
INSERT INTO xnj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chakaka nikuvajovela, mkulu mwenuyo yati amuvika mtumisi mwenuyo kuyimalila vindu vyaki vyoha. ");
INSERT INTO xnj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nambu muhengaji yula, ngati akujijovela mumtima waki, Mkulu wangu acheliwi kuwuya, ndi itumbula kuvatova vatumisi vayaki, vadala na vagosi, na kulya na kunywa na kugala, ");
INSERT INTO xnj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mkulu waki yati iwuya ligono na lukumbi lwanga manyikana, yati amudumula hipandi hipandi na kumuvika lilundu limonga la vangasadika. ");
INSERT INTO xnj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mvanda mweamanyi gala geigana bambu waki, nambu ajitendelekili lepi kuhenga genago, bambu waki akumtova neju. ");
INSERT INTO xnj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nambu mvanda mweihenga chindu changamanya gala geigana bambu waki, mwenuyo yati itoviwa padebe. Muni yula mweapewili vyamahele, mwenuyo idayiwa vyamahele na yula mweagotoliwi vyamahele neju, yati idayiwa vyamahele neju. ");
INSERT INTO xnj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nibweli kuleta motu pamulima, ndi kuvya uvya ngaumali kuyaka!” ");
INSERT INTO xnj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nambu nivinawu ubatizu weukunigana nibatiziwa, na nene nikuung'akila neju mbaka utimilayi! ");
INSERT INTO xnj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wu! Mwiholalela nibweli kuleta uteke pamulima? Hati padebe, lepi, utekee nambu mpechenganu. ");
INSERT INTO xnj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kutumbula hinu vandu mhanu va nyumba yimonga yati vipechengana upandi vadatu na upandi wungi vavili, na kangi upandi vavili na upandi wungi vadatu. ");
INSERT INTO xnj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yati vipechengana dadi na msongolo waki, msongolo na dadi waki, mau na msikana waki, msikana na nyina waki, nayala na mkamwana waki, mkamwana na nayala waki. ");
INSERT INTO xnj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu akaujovela msambi wa vandu, “Pemukugawona mahundi gihumalila kwelitipama lilanga, bahapo mwijova, yati yitonya fula, na chakaka fula yitonya. ");
INSERT INTO xnj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na pemwilola mpungu upuganisa kuhuma kuupandi wa kusini mujova, lelu yati livya lilanga, Chakaka kwivya na lilanga lachona. ");
INSERT INTO xnj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Vahomela nyenye! Mumanyili kulotela mambu ga lusenje, kwa kulola chekuvi lelu kwa kulola mulima na mahundi, ndava kyani mwihotola lepi kumanya mambu ga lusenje lwa hinu?” ");
INSERT INTO xnj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ndava kyani mwavene mwihotola lepi kuhagula mambu gabwina ga kukita? ");
INSERT INTO xnj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ngati mundu mweakutakili, akukupeleka palibanji la mihalu, mbanga mutepulana mwakona munjila muni akotoka kukupeleka kwa mhamula mihalu, namwene akugotola kwa manjolinjoli na vene vakusopa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chakaka yati wihuma lepi muchifungu, mbaka peumalakisa kulipa sendi ya lishonga la mwishu.” ");
INSERT INTO xnj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lukumbi lwenulo vandu nunuyo, vabweli kumjovela Yesu, mambu ga vandu va ku Galilaya, vevakomiwa na Pilatu, lukumbi vihinja mifuya yavi ndava ya luteta. ");
INSERT INTO xnj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu akavayangula, “Ndava Vagalilaya vala vevakomiwi kwa njila yila mwihololela kuvya Vagalilaya vala, vambudili Chapanga kuliku Vagalilaya vangi, hati gavakolili mambu genago? ");
INSERT INTO xnj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chakaka nikuvajovela, lepi, changamuwuyila Chapanga winu, na nyenye yati mwifwa. ");
INSERT INTO xnj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Amala, kumi na nane vala, vevagwiliwi na mnala kuchijiji cha ku Siloamu, vafwili, ndi mwiholalela kuvya venavo, vahokili kuliku vandu voha vevatama ku Yelusalemu? ");
INSERT INTO xnj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chakaka nikuvajovela, lepi, nambu na nyenye changamuwuyila Chapanga, na nyenye mewawa yati mwifwa.” ");
INSERT INTO xnj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kangi Yesu akavajovela luhumu ulu, “Mundu mmonga avi na mkongo wa mtini mumgunda waki wa mizabubu, mundu mwenuyo akahamba kuyava matunda mumkongo wula, nambu apatili lepi. ");
INSERT INTO xnj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndi akamjovela mhenga lihengu wa mgunda, ‘Lola! Mumiyaka yidatu nakalibwela kuyava matunda mumkongo uwu wa mtini, nambu kawaka chindu chenigana. Hinu uhudumula! Ndava kyani ulalisa mgunda wangu?’ ");
INSERT INTO xnj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nambu mhenga lihengu akamyangula, Bambu, ‘Tiuleka kavili namwaka, na nene yati niukulugila na kusopalela mabuli. ");
INSERT INTO xnj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngati upambiki matunda kumwaka chabwina, ngati nakupambika, ndi udumulayi.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ligono limonga la Kupumulila, Yesu avi mukuwula munyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pavi na mdala mmonga mweavi na mzuka, mwealwalayi lukumbi lwa miyaka kumi na nane, mdala mwenuyo avi na chipindi ndi nakuhotola kuyima. ");
INSERT INTO xnj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu peamuweni akamkemela na kumjovela, “Mau, ulekekiswi utamu waku!” ");
INSERT INTO xnj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesu akamuvikila mawoko mdala yula na bahapo higa yaki yikagoloseka, na akatumbula akamlumbalila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mkulu wa nyumba ya kukonganekela Vayawudi akayoma, ndava Yesu amulamisi mdala yula, Ligono la Kupumulila. Ndi akavajovela vandu vavavi penapo, “Muvi nagu magono sita gakuhenga mahengu. Hinu mubwela magono genago kulamisiwa utamu winu, nambu lepi kulamiswa Ligono la Kupumulila!” ");
INSERT INTO xnj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nambu Bambu akamyangula, “Vahomela nyenye! Yani mweavi pagati yinu mwangawopola ng'ombi yaki amala lipunda laki muchivaya na kuyipeleka kunywiha manji Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mdala yula avi wa chiveleku cha Ibulahimu, nambu Setani amkungili miyaka kumi na nane wu, chabwina lepi kumdindulila vifungu vyaki Ligono la Kupumulila?” ");
INSERT INTO xnj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu peamali kujova genago, makoko gaki vakoli soni, nambu vandu vangi voha vakaheka kwa mambu gakukangasa gahengili. ");
INSERT INTO xnj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu akavakota, “Unkosi wa Chapanga uwanangini na kiki? Wu, nikuwanangisa na kyani? ");
INSERT INTO xnj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngati mbeyu ya mkongo wa haladali yeyitoliwi na mundu mmonga na kuhilalila mumgunda waki. Yikamela na kuvya mkongo, na videge vikajenga hisakanilu mumambanda gaki.” ");
INSERT INTO xnj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu akakota kavili, “Unkosi wa Chapanga nikuwanangisa na kyani? ");
INSERT INTO xnj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngati ngemeku laatoli mdala mmonga na kuhangisana na uhembe madebe gavili na woha watutumwiki.” ");
INSERT INTO xnj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu paayendelela na lugendu lwaki kuhamba ku Yelusalemu apitayi mumiji na muhijiji, kuni avawulayi vandu. ");
INSERT INTO xnj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu mmonga akamkota Yesu, “Bambu, wu, vandu vevisanguliwa ngavamahele?” ");
INSERT INTO xnj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesu akavajovela, “Mukangamala neju kuyingila mumlyangu udebedebe, muni nikuvajovela vandu vamahele yati vilinga kuyingila nambu nakuhotola. ");
INSERT INTO xnj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lukumbi lubwela lwa mkolo nyumba kuyima na kudinda mlyangu. Ndi penapo yati muyima kuvala na kutumbula kuhodesa mlyangu kwa kujova, ‘Bambu utidindulilayi mlyangu!’ Nambu mwene yati akuvayangula, ‘Nakuvamanya nyenye wala nakumanya kwemwihuma!’ ");
INSERT INTO xnj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na nyenye yati mwitumbula kumjovela, ‘Tete ndi vala vetalili na kunywelela na veve, mewa veve watiwulili hotohoto muhijiji yitu!’ ");
INSERT INTO xnj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nambu mwene yati ijova, ‘Nakuvamanya nyenye wala kwemwihuma. Muwuka palongolo yangu, mwavoha nyenye vahenga gahakau!’ ");
INSERT INTO xnj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ndi yati mwivembeneka na kuyaga minu, lukumbi pemkuvalola Ibulahimu na Izaki na Yakobo na vamlota voha va Chapanga vavi Muunkosi wa Chapanga, nambu nyenye muvi kuvala! ");
INSERT INTO xnj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vandu yati vibwela kuhuma pandi zoha za mulima, na kulya pamonga Muunkosi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndi vala vevavi va mwishu yati vivya va kutumbula na vala vevavi va kutumbula yati vivya va mwishu.” ");
INSERT INTO xnj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lukumbi lwenulo Vafalisayu vangi vamhambili Yesu na kumjovela, “Uwuka penapa uhamba pandu pangi muni Nkosi Helodi igana kukukoma.” ");
INSERT INTO xnj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akavayangula, “Muhamba mukamjovela lihogo, ‘Lelu na chilau nivinga mizuka na kuvalamisa vatamu na pamalau yati nimalakisa lihengu langu.’ ");
INSERT INTO xnj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nambu yikunigana niyendelela na lugendu lwangu, lelu na chilau na pamalau, muni yihotoleka lepi mlota wa Chapanga, kukomiwa kuvala ya Yelusalemu.” ");
INSERT INTO xnj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Wa Yelusalemu! Veve Yelusalemu! Mweukuvakoma vamlota va Chapanga, vevatumwili kwaku. Kwa kuvatova na maganga. Pamahele niganili kuvahegelesa vana vaku pamonga ngati nguku, cheyiyuvatila tuvana twaki mumagwaba, nambu mwaganili lepi. ");
INSERT INTO xnj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lola! Nyenye yati mulekewa muji winu. Na nene nikuvajovela yati nakunilola kavili mbaka lukumbi pa mwijova, Amotisiwa mweibwela kwa uhotola wa Bambu.” ");
INSERT INTO xnj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ligono Limonga la Kupumulila, Yesu ahambili kulya chakulya, kunyumba ya chilongosi mmonga wa Vafalisayu, na vandu vakavya kumlingulila. ");
INSERT INTO xnj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Palongolo ya Yesu avi mundu mweavi na utamu wa kuhimba higa ");
INSERT INTO xnj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu akavakota vawula va malagizu ga Chapanga geampeli Musa na Vafalisayu, “Wu, mhilu wijova wuli, chabwina amala chabwina lepi, kumlamisa mundu Ligono la Kupumulila?” ");
INSERT INTO xnj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nambu vene vakaguna. Yesu akamtola mundu yula na kumlamisa, akamleka ahambayi. ");
INSERT INTO xnj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kangi akavajovela, “Yani pagati yinu mweavi na mwana waki amala ng'ombi yaki yeyidumbukili muchiliva nakuyihumisa bahapo, ndava mu Ligono la Kupumulila?” ");
INSERT INTO xnj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nambu vene nakuhotola kumyangula. ");
INSERT INTO xnj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu akavalola vavagongoliwi chavajihagulila vigoda vya palongolo, ndi akavajovela, ");
INSERT INTO xnj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ngati mundu akugongolili, kundowa ukotoka kutama pavigoda vya palongolo, Pangi agongoliwi yungi mkulu kuliku veve. ");
INSERT INTO xnj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mweavagongolili mwavoha nyenye vavili, yati ibwela na kukujovela, ‘Uwuka atama uyu.’ Penapo yati wikola soni na kuhamba kutama pandu pa mwishu. ");
INSERT INTO xnj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ngati mundu akugongolili kundowa, veve uhamba ukatama muvigoda vya mumbele, muni mweakugongolili yula, paibwela yati akukujovela, ‘Wankozi wangu yima ubwela utama pa vigoda vya palongolo.’ Penapo yati utopela pavandu voha, vevatamili pamonga na veve. ");
INSERT INTO xnj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Muni mundu yoyoha mweakujikwiha yati iheleswa, na yeyoha mweakujihelesa yati ikwihiwa.” ");
INSERT INTO xnj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kangi akamjovela mwaigongolela yula, “Ngati uvatendelekili vandu chakulya cha muhi amala kimihi, kotoka kuvagongolela vankozi vaku amala valongo vaku amala veutamanila nawu papipi vevavi na vindu vyamahele, muni na vene vihotola kukugongolela ndava na kukuwuyisila chewavahengili. ");
INSERT INTO xnj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nambu peundelekela chakulya cha mselebuko, vagongolela vangangu na vevagogodili higa vangagenda na vangalola, ");
INSERT INTO xnj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na veve yati umotisiwa muni uvagongolili vangahotola kukuwuyisila. Nambu Chapanga yati akuwuyisila gabwina mu ligono la kuyukiswa vandu vabwina.” ");
INSERT INTO xnj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mmonga wa vala vavatamili na Yesu pameza, akajova amotisiwa mundu yula mweibwela kuyla chakulya cha mselebuko Muunkosi wa Chapanga! ");
INSERT INTO xnj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu akamjovela, “Mundu mmonga atendekili mselebuko uvaha, na kuvagongolela vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Palwahiki lukumbi lwa kulya, amtumili mvanda waki akavakemela vevagongoliwi, ‘Mbwela, kila chindu chitendelekiwi!’ ");
INSERT INTO xnj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nambu voha, mmonga na kugelekela yungi vakutumbula kujova chondi pepayi. Mundu wa kutumbula akamjovela, mvanda yula, ‘Niguli mgunda yikunigana nihamba nikaulola pepayi yati nibwela lepi.’ ");
INSERT INTO xnj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na yungi akajova, ‘Niguli ng'ombi kumi za kulimila nihamba kuzilinga kulima chondi unilekekesa.’ ");
INSERT INTO xnj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na yungi akajova, ‘Nigegili mdala ndava ya genago, nakuhotola kubwela.’” ");
INSERT INTO xnj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mtumisi yula akawuya na kumjovela bambu waki mambu goha. Mkolo nyumba yula akayoma na kumlagiza mvanda waki, ‘Kita kanyata uhamba munjila yivaha na tunjila twa muji ukavaleta vangangu na vangagenda na vangalola na vevagogodili higa.’ ");
INSERT INTO xnj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mtumisi yula Paawuyili kuhuma kweatumiwili akamjovela, ‘Bambu, goha geukalagizi gahengiki, nambu pakona pandu pakutama vandu.’ ");
INSERT INTO xnj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bambu yula akamjovela mvanda. Uhamba munjila yivaha na tunjila twa muji, ukavakamula vandu kuyingila munyumba yangu yimema. ");
INSERT INTO xnj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nikuvajovela nyenye, voha vevatumbwili kugongolewa, kawaka hati mmonga, mweimywanga chakulya cha mselebuko wangu!” ");
INSERT INTO xnj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Msambi wa vandu walongosini na Yesu, mwene akang'anamuka na kuvajovela, ");
INSERT INTO xnj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mundu yoyoha mweibwela kwa nene yikumgana aniganayi neju nene, kuliku kumgana dadi waki na nyina waki na mdala waki na vana vaki na valongo vaki na valumbu vaki, pamonga na wumi waki, changakita ago, nakuhotola kuvya muwuliwa wangu. ");
INSERT INTO xnj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundu yoyoha yula mwangagega msalaba waki na kunilanda mwenuyo nakuhotola kuvya muwuliwa wangu. ");
INSERT INTO xnj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wu, yani pagati yinu mweigana kujenga mnala nakutama hoti pahi, kuvalanga mashonga kumanya ngati avi nagu gegitosha kumalakisa kujenga? ");
INSERT INTO xnj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ngati lepi, akatumbula kujenga mkingisa, nakuhotola kumalakisa vandu voha vevilola yati vakumuheka. ");
INSERT INTO xnj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yati vijova, Mundu uyu atumbwili kujenga. Nambu nakuhotola kumalakisila! ");
INSERT INTO xnj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Wu, Nkosi yani mweigana kuhamba kutovana ngondo na Nkosi yungi, nakutama hoti pahi na kuhololela, wu, ihotola kwa manjolinjoli waki elufu kumi, kutovana ngondo na nkosi yula mweibwela kutovana nayu ngondo mweavi na manjolinjoli elufu ishilini? ");
INSERT INTO xnj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ngati amanyili kuvya nakuhotola, yati avatuma vajumbi kuyupa vakotoka kutova, lukumbi nkosi yungi akona kutali. ");
INSERT INTO xnj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mewawa,” Kawaka mundu mweihotola kuvya muwuliwa wangu, changaleka vindu vyoha vye avi navyu. ");
INSERT INTO xnj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyu chindu cha bwina, nambu mwinyu ngati uyagisi lunyong'onyo lwaki, yati usopewa kyani mbaka kuvya kavili mwinyu? ");
INSERT INTO xnj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yabwina lepi kusopewa muludaka amala mabuli. Vandu vakuyitaga kuvala. Mundu mweavi na makutu na ayuwana!” ");
INSERT INTO xnj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ligono limonga vatola kodi na vevambudila Chapanga vamahele vahambili kumuyuwanila Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Vafalisayu na vawula va malagizu ga Chapanga geampeli Musa vakatumbula kung'ung'uta, “Mumlola mundu mwenuyu, akuvakemela vandu vevambudila Chapanga na kavili ilya nawu!” ");
INSERT INTO xnj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu akavajovela luhumu ulu, ");
INSERT INTO xnj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngati mmonga winu avi na mambelele, miya yimonga na akamanya kuvya mmonga pagati yavi ayagili, yati ikita kyani? Yati akugaleka mambelele tisini na tisa gala kulugangatu na kuhamba kulonda yila yeyiyagili mbaka ampatayi. ");
INSERT INTO xnj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ngati amuwona yati akuyigega mumavega kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Peihika panyumba, Yati akuvakemela vamukozi vaki na veitama nawu papipi na kuvajovela, ‘Tivyai na luheku pamonga na nene ndava niliweni limbelele langu lelayagili.’ ");
INSERT INTO xnj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mewawa nikuvajovela, yati kwivya na luheku kunani kwa Chapanga, mundu mmonga mweakumbudila Chapanga, paileka kubuda, kuliku vandu tisini na tisa vabwina na viganikwa lepi kumuwuyila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Amala mdala yoki mweavi na mashonga kumi, limonga likamyaga, yati ikita wuli? Nakupambika hahi, na kutyanyila nyumba na kuilonda neju mbaka ayilola? ");
INSERT INTO xnj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akamala kuipata, akuvakemela vankozi vaki na veitama nawu papipi na kuvajovela, ‘Mvya na luheku pamonga na nene muni nilipatili lishonga langu lelayagili!’ ");
INSERT INTO xnj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mewawa nikuvajovela, ndi chavivya na luheku vamitumu va kunani kwa Chapanga, ndava ya mundu mmonga mweambudili Chapanga, paileka kubudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu akayendelela kujova. Kwavili na mundu mmonga mweavi na vana vasongolo vavili. ");
INSERT INTO xnj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mdebe yula akamjovela dadi waki, Dadi, nipelayi uhali wa vindu vyeviganikiwa kupewa, Dadi waki akavagavanisila vindu vyaki. ");
INSERT INTO xnj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gapitili lepi Magono gamahele, mwana mdebe yula akagulisa vindu vyaki vyoha, na kuwuka na mashonga geapewili, akahamba kumulima wa kutali, kwenuko akazipomondana kwa mambu ga ukemi mashonga gala. ");
INSERT INTO xnj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Peamalili kila chindu cheavili nachu, ndi yikahumila njala yivaha pamulima wenuwo na mwene akatumbula kung'ahika. ");
INSERT INTO xnj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Akahamba kwa mkolonjinji mmonga, wa mulima wenuwo na kuyupa lihengu, mwene akampela lihengu la kudima maguluvi kumgunda waki. ");
INSERT INTO xnj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Anogili kulya chakulya cha maguluvi gala, nambu kawaka mundu mweampeli chindu cha kulya. ");
INSERT INTO xnj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mumbele luhala lwamuyili akajova mumtima waki. Kuvi na vana lihengu, valinga kwa Dadi wangu, vevilya na kusigalisa chakulya na nene nifwa penapa na njala! ");
INSERT INTO xnj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yati niwuya kwa dadi wangu na kumjovela, Dadi, nimbudili Chapanga na nikubudili veve mewa. ");
INSERT INTO xnj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Niganikiwa lepi kavili kukemelewa, mwana waku, unikita ngati mmonga wa vana lihengu vaku. ");
INSERT INTO xnj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndi akatumbula lugendu kuwuya kwa dadi waki. “Mwene peavili cha kutali, dadi waki amuweni, kwa mtima wa lipyana amjumbalili na kumjambusa cha uganu. ");
INSERT INTO xnj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana yula akamjovela, ‘Dadi, nimbudili Chapanga, na nikubudili veve mewa. Nene niganikiwa lepi kavili kukemelewa mwana waku.’ ");
INSERT INTO xnj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nambu dadi waki akavajovela vanalihengu vaki, ‘Kanyata!’ Muleta nyula yabwina mumuwalika. Mumuwalika na pete pamonga na champali! ");
INSERT INTO xnj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mukatola mpapakasi wa mweakulupi mukahinja, tilyayi na kuselebuka! ");
INSERT INTO xnj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ndava muni mwana vangu uyu kwa nene avi ngati afwili, nambu hinu akona mumi, ayagili hinu awonikini. Vakatumbula kuselebuka.” ");
INSERT INTO xnj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Lukumbi lwenulo muhaja waki avi akona kumgunda. Ndi peawuyayi kuhegelela panyumba, akayuwana vilulu na vandu vikina ng'oma. ");
INSERT INTO xnj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akamkemela mmonga wa mtumisi kumkota, ‘Chivii kyani kwenuko?’ ");
INSERT INTO xnj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mtumisi yula akayangula, ‘Mlongo waku awuyili kunyumba, na dadi waku amuhinjili mpapakasi mweakulupili, muni ampatili akona mumi.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Nambu mvaha yula akavya na ligoga na kubela kuyingila mugati. Ndi dadi waki akahuma kuvala na kumuyupa neju ayingila mugati. ");
INSERT INTO xnj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nambu mwene akamyangula dadi waki, ‘Lola, Nikuhengili mahengu Miyaka yoha iyi ngati mvanda changabela malagizu gaku hati padebe. Unipeli kyani? Unipeli lepi hati kamene kadebe na nene nganiselebwiki na vankozi vangu. ");
INSERT INTO xnj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nambu mwana waku uyu mwepomondini mashonga gaku pamonga na vakemi, peabweli umuhinji mpapakasi mweakulupili!’ ");
INSERT INTO xnj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dadi waki akamyangula, ‘Mwana vangu, veve uvi pamonga na nene magono goha na vindu vyoha vyenivi navyu vyaku. ");
INSERT INTO xnj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nambu yatiganili kukita mselebuko na luheku ndava mlongo waku mweavi ngati afwili, hinu akona mumi, mweayagili nambu hinu awonikini.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu akavajovela vawuliwa vaki, “Mundu mmonga mweavi na vindu vyamahele, avi na mundu wa kuyimilila lihengu laki. Mkolo vindu ayuwini kuvya myimilila lihengu yula ipomondana vindu. ");
INSERT INTO xnj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mkolo vindu, akamkemela myimila lihengu yula na kumkota, ‘kyani cheniyuwana? Nigana univalangila vindu vyoha, muni nakuhotola kuyimalila lihengu langu kavili.’ ");
INSERT INTO xnj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Myimalila lihengu yula akahololela mumtima waki, ‘Bambu wangu igana kunivinga lihengu, yati nikita kyani? Makakala ga kulima nakuhotola na kuhamba kuyupayupa ngati namngangu niwona soni. ");
INSERT INTO xnj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Hinu nimanyili chakukita, muni penivingiwayi lihengu, muni vandu vanikemelayi kunyumba zavi.’” ");
INSERT INTO xnj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Akavakemela voha vevidayiwa vindu na bambu waki, mmonga mmonga akatumbula kumkota yula wa kutumbula. ‘Udayiwa vindu vilinga na bambu wangu?’ ");
INSERT INTO xnj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mwene akamyangula. ‘Makalangi kumi na mcheche ga mahuta ya mizeituni,’ Ndi myimalila lihengu yula akajova, ‘Tola balua laku lewidayiwa, tama kanyata, yandika saba.’ ");
INSERT INTO xnj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kangi akamkota yungi, ‘Veve wakalidayiwa vindu vilinga?’ Akayangula, ‘Magunila ga nganu miya yimonga.’ Muyimilila lihengu yula akamjovela. ‘Tola balua laku la gewidayiwa Yandika semanini.’” ");
INSERT INTO xnj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bambu yula akamulumba myimila lihengu mwachenjili yula, muni ahengili kwa luhala. Ndava vandu va mulima uwu vana luhala neju pevihenga vindu na vandu ngati avo, kuliku vandu vevavi munkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu akayendelela kujova, “Nikuvajovela nyenye, mjipatila vankozi kuhuma mumashonga na vindu vya pamulima uwu, muni pevimalika, vavakemela mumatamilu gavi ga magono goha. ");
INSERT INTO xnj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mundu yoyoha mwaisadikiwa muvindu videbe, mewa yati isadikiwa muvindu vyamahele. Na yoyoha angasadikiwa muvindu videbe isadikiwa lepi muvindu vyamahele. ");
INSERT INTO xnj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ngati nyenye mwisadikiwa lepi mumashonga na vindu vya pamulima, ndi yani akuvagotolela na vindu vya uchakaka? ");
INSERT INTO xnj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngati nakuhotola kusadikiwa mumashonga na muvindu vya mundu yungi, yani mweihotola kuvagotolela vindu vinu mwavene?” ");
INSERT INTO xnj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kawaka mvanda mweihotola kuvahengela vabambu vavili, muni yati amgana mmonga na kumhakalila yungi, amala yati ilongosana na mmonga na kumuvevesa yungi. Mwihotola lepi kumuhengela Chapanga na mashonga.” ");
INSERT INTO xnj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Vafalisayu pevayuwini genago, vakamvevesa Yesu, ndava vene vavi vandu vakugana mashonga, ");
INSERT INTO xnj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu akavajovela, “Nyenye mujilola mwavabwina palongolo ya vandu, nambu Chapanga ayimanyili mitima yinu. Ndava chindu chechilolekana chabwina neju palongo ya vandu, kwa Chapanga chilolekana chihakau.” ");
INSERT INTO xnj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malagizu ga Chapanga geampelii Musa na mayandiku ga valota va Chapanga gakokwiswi mbaka lukumbi lwa Yohani wa Kubatiza. Kutumbula penapo, Lilovi la Bwina la Unkosi wa Chapanga ukokoswa, na kila mundu iyingila kwa makakala. ");
INSERT INTO xnj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nambu yiyeywa neju kunani kwa Chapanga na mulima kuyaga kuliku kayandiku kadebe kuhunguliwa mu Malagizu ga Musa.” ");
INSERT INTO xnj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mundu yoyoha mweakumuleka mdala waki na kugega yungi, mwenuyo ikita ugoni na mundu yoyoha mwaakumgega, mdala mwaalekiwi yula.” Namwene mewa ikita ugoni. ");
INSERT INTO xnj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kwavili na mundu mmonga mweavi na vindu vyamahele, mwaawala nyula zezaguliwa kwa mashonga gamahele na nyula zezing'asima na kulya vindu vyabwina magono goha.” ");
INSERT INTO xnj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na pamlyangu uvaha wa mundu mwenuyo, vavi kumvika mundu mmonga mngangu, liina laki Lazalu, mweavi na vilonda vyamahele. ");
INSERT INTO xnj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mngangu mwenuyo, anogela kupewa vyakulya vevyagwayi pahi kuhuma pameza ya mkolo vindu vyamahele yula. Hati mabwa gabwela na kumihyanga vilonda vyaki. ");
INSERT INTO xnj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lwakabwela lukumbi Lazalu yula afwili na vamitumu va kunani vakamtola na kumuvika papipi ya Ibulahimu. Na mkolo vindu vyamahele mewa afwili vakamzika. ");
INSERT INTO xnj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mkolo vindu vya mahele yula, paavi mukung'ahika neju kuligodi litali langali mwishu, akamlola Ibulahimu cha kutali na Lazalu papipi yaki. ");
INSERT INTO xnj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ndi akamkemela. Dadi, Ibulahimu! Nihengela lipyana, umtuma Lazalu ajwisa lung'onji lwaki mumanji na kunipolesa lulimi lwangu, muni ning'ahika neju mumotu uwu! ");
INSERT INTO xnj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nambu Ibulahimu akamyangula, mwana vangu. Holalela, wapokili vindu vyabwina pawavi muwumi waku, na Lazalu opokili vindu vihakau. Hinu Lazalu ipumuliswa, na veve uvi mumang'ahiso. ");
INSERT INTO xnj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pamonga na genago, pagati ya nyenye na tete, kuvili na ligodi livaha, muni vevigana kubwela kwa nyenye nakuhotola, na vevigana kuwuka kwa nyenye kubwela kwa tete nakuhotola, ");
INSERT INTO xnj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mkolo vindu vyamahele yula akajova, ‘Hinu Dadi Ibulahimu nikuyupa umtuma Lazalu ahamba kunyumba ya valongo vangu, ");
INSERT INTO xnj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","muni nivii nawu valongo mhanu, ahamba akavajovela vajiyangalila vakotoka navene vakotoka kubwela kumang'ahiso kuni.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ibulahimu akamjovela, kwenuko ‘Valongo vaku vavi na mayandiku ga Musa na vamlota va Chapanga, valeka, vavayuwanila venavo.’ ");
INSERT INTO xnj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mkolo vindu vyamahele yula akajova kavili, ‘Lepi dadi Ibulahimu! Nambu ngati avahambalili mundu mweayukili kuhuma kwa vafwili, yati vileka kubuda kwavi.’ ");
INSERT INTO xnj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibulahimu akajova, ‘Ngati nakuvayuwanila mayandiku ga Musa na vamlota va Chapanga, nakumyuwanila mundu yoyoha hati ngati ayukili kuhuma kwe vevafwili.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu akavajovela vawuliwa vaki, “Nakuhotola mambu ga kuvakita vandu vambudila Chapanga gakotoka kuhumila, nambu alachikolela mundu yula mweikita genago gahumila.” ");
INSERT INTO xnj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngayivii mbanga mundu mwenuyo, kukungiwa livala livaha la kuyagila musingu na kujwigiswa munyanja, kuliku kumyokisa mmonga wa vadebe ava. ");
INSERT INTO xnj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mujiyangalila! Ngati mlongo waku akuhokili, mywangila, akakukamula chigendelu umulekesayi. ");
INSERT INTO xnj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hati ngati akuhokili mala saba kwa ligono limonga, na kukuwuyila mala saba. Kukukamula chigendelu, umulekesayi. ");
INSERT INTO xnj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Vamitumi vakamjovela Bambu Yesu, “Utiyonjakesa kusadika.” ");
INSERT INTO xnj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ndi Bambu akayangula, “Kusadika kwinu ngakuvi kudebe ngati lumbeyu ulu lwa haladali, ngamuhotwili kuujovela mkongo wa mkuyu, ‘Jitupula na ukajimelesa munyanja.’ Na wene ngauvayidakili.” ");
INSERT INTO xnj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tijova mmonga winu, ana mvanda wa lihengu kumgunda, amala kudima mambelele. Mvanda yula peiwuya kuhuma kulihengu, Wu, ijoviwa na mkulu waki, ‘Bwela kanyata utama ulyayi chakulya?’ ");
INSERT INTO xnj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Lepi! Nambu yati akumjovela, ‘Nitendelekela chakulya na kunihengela mbaka penimala kulya na kuywelela, ndi na veve pewilya na kunywelela.’ ");
INSERT INTO xnj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wu, mkulu yula yati amsengusa mtumisi yula ndava akitili goha geamlagazili? ");
INSERT INTO xnj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Na nyenye mewawa, mukahengayi kila chindu chemulagizwi kuhenga, mujovayi, ‘Tete vavanda tihengili lihengu litu ndu.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu peavi mulugendu kuhamba ku Yelusalemu, akapitila mumbaka ya Samaliya na Galilaya. ");
INSERT INTO xnj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Peayingili muchijiji chimonga vandu kumi vevavi na mabudi vakambwelela. Vakayima cha patali. ");
INSERT INTO xnj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Vakajova kwa lwami luvaha, “Yesu! Bambu! Utihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu peavaweni akavajovela, “Muhamba mukajilangisa kwa vakuteta va Chapanga.” Ndi pevavi mukuhamba vakanyamba. ");
INSERT INTO xnj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mmonga wavi peajimanyi kuvya alamiswi, awuyili kuni akumlumbalila Chapanga kwa lwami luvaha. ");
INSERT INTO xnj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akamfugamila Yesu mumagendelu na kumsengusa. Mundu mwenuyo avi Msamaliya. ");
INSERT INTO xnj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nambu Yesu akakota, “Wu, vavi lepi vandu kumi vevanyambisiwi? Vangi tisa vala vavi koki? ");
INSERT INTO xnj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hinu kawaka vandu vangi vevawuyi kumsengusa Chapanga ndi ngayuyu myehe?” ");
INSERT INTO xnj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Penapo akamjovela mundu mwenuyo, “Yima uhamba, kusadika kwaku kukulamisi.” ");
INSERT INTO xnj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Vafalisayu vamkoti Yesu kuvya Unkosi wa Chapanga yati ubwela ndali. Mwene akavayangula, “Unkosi wa Chapanga yati ubwela lepi cha kulolekana. ");
INSERT INTO xnj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kawaka mundu mweihotola kujova, ‘Uvi kuni, amala uvi kula!’ Muni unkosi wa Chapanga uvi pagati yinu.” ");
INSERT INTO xnj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kangi akavajovela vawuliwa vaki, “Galabwela magono yati mwinogela kuliwona ligono limonga mumagono gaki Mwana wa Mundu, nambu yati nakuyiwona. ");
INSERT INTO xnj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Vandu yati vakuvajovela, ‘Lola, avi kula!’ Amala ‘Lola, avi kuni!’ Nambu nyenye mukoto kuwuka wala kuvalanda. ");
INSERT INTO xnj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Muni yati yivya ngati mbamba cheyimwetula chigafula kuhumila upandi umonga mbaka wungi, ndi yati cheivya ligono la kubwela kwaki Mwana wa Mundu. ");
INSERT INTO xnj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nambu yikumgana hoti, kung'ahika neju na kubelelewa na vandu va chiveleku ichi. ");
INSERT INTO xnj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngati chayavili lusenje lwa Nuhu, ndi cheyibwela kuvya magono ga kuwuya kwaki Mwana wa Mundu. ");
INSERT INTO xnj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Vandu vayendalili kulya na kuywelela, kugega na kugegewa mbaka Nuhu peayingili muwatu uvaha. Fula yivaha yatonyili na manji gakamema na kuvakoma vandu voha. ");
INSERT INTO xnj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mewawa ngati cheyavili magono ga Lutu. Vandu vayendalili kulya na kuywelela, kugula na kugulisa, kuhila mbeyu na kujenga nyumba. ");
INSERT INTO xnj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nambu ligono Lutu paawukili ku Sodoma, motu na chibiliti vyatonyili ngati fula kuhuma kunani kwa Chapanga na kuvakoma voha. ");
INSERT INTO xnj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mewawa ndi cheyivya ligono la Mwana wa Mundu peiwuya.” ");
INSERT INTO xnj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ligono lenilo, mundu yoyoha mweivya kuvala ya nyumba akotoka kuyingila munyumba yaki kutola vindu vyaki, mewawa na yoyoha mweavikumgunda akotoka kuwuya mumbele. ");
INSERT INTO xnj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muhololela gegamkolili mdala wa Lutu! ");
INSERT INTO xnj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundu Yoyoha mweigana kuusangula wumi waki, yati auyagisa na mundu yoyoha mweakuyagisa wumi waki yati akuugombola. ");
INSERT INTO xnj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nikuvajovela kilu ya ligono lenilo, vandu vavili vevagonili pamonga palusongwani, mmonga yati itoliwa na yungi yati ilekewa. ");
INSERT INTO xnj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kangi vadala vavili yati vivya pamonga mukuyaga mbeyu, mmonga yati itolewa na yungi yati ilekewa.” ");
INSERT INTO xnj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Vandu vavili yati vivya kumgunda mmonga yati itoliwa na yungi yati ilekewa. ");
INSERT INTO xnj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Penapo vakamkota, “Koki Bambu?” Mwene akavayangula, “Pewivya mtuhi, ndi pevikonganekela manditi.” ");
INSERT INTO xnj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kangi Yesu akavajovela, luhumu yikuvagana kuyupa magono goha changali kukotoka. ");
INSERT INTO xnj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akajova, “Kwavili na mhamula mihalu kumuji wenuwo iyupa lepi kwa Chapanga wala nakuvahengela vandu bwina. ");
INSERT INTO xnj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mumuji wenuwo, pavi na lipwela mmonga, mweamhambila mhamula mihalu ligono kwa ligono, amkengelela kwa kuhamula bwina apatayi vindu vyaki kuhuma kwa likoko waki. ");
INSERT INTO xnj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa magono gamahele Mhamula mihalu yula akabela kumkengelela, nambu pamwishu akahololela mumtima waki, ‘Pamonga na nene niyupa lepi kwa Chapanga wala kuvahengela vandu bwina, ");
INSERT INTO xnj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nambu ndava ya lipwela uyu akuning'aha yati nikumkengelela kuhamula bwina, ngati lepi, yati iyendelela kunibwelela, na pamwishu yati akunitotokeha!’ ” ");
INSERT INTO xnj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bambu akajova, “Myuwanila cheijova muhamula mihalu mhakau. ");
INSERT INTO xnj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kujova Chapanga yati akuvakengelela lepi vandu veavahagwili, vevakumvembela muhi na kilu? Wu, yati ikavila kuvayuwanila? ");
INSERT INTO xnj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nikuvajovela, yati akuvakengelela kanyata. Pamonga na genago, Wu, yati kwivya na sadika pamulima lukumbi peibwela Mwana wa Mundu?” ");
INSERT INTO xnj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kangi Yesu akavajovela luhumu wa vandu vala vevakujilola vabwina na kuvavesa vangi. ");
INSERT INTO xnj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Vandu vavili vahambili ku Nyumba ya Chapanga kumuyupa. Mmonga Mfalisayu na yungi mtola kodi.” ");
INSERT INTO xnj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mfalisayu yula akayima, kuyupa kwa Chapanga chakumtima akajova, Veve Chapanga, nikusengusa ndava muni nene nivii lepi ngati vandu vangi, vanyagaji na vivikita gahakau na vevikita ugoni. Nikusengusa ndava muni nene nivii lepi ngati mtola kodi uyu. ");
INSERT INTO xnj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nikujiinisa chakulya ndava ya Chapanga mala zivili kwa lijuma, niwusa lilundu limonga pagati ya kumi muvindu vyangu. ");
INSERT INTO xnj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nambu mtola kodi yula, ayimili cha kutali, changali hati kulolokesa mihu kunani kwa Chapanga ndi ajitovili nganga cha ngolongondi, akajova. Chapanga veve, unihengala lipyana nene mwenikubudili! ");
INSERT INTO xnj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu akavajovela, mtola kodi yula awuyili kunyumba kuni ayidakiliwi na Chapanga. Nambu Mfalisayu yula lepi, ndava muni kila mundu mweakujikwiha yati iheleswa na kila mundu mweakujihelesa yati ikwihiwa. ");
INSERT INTO xnj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Vandu vangi vamletili Yesu vana vadebe muni avavikila mawoko na kuvamotisa. Vawuliwa vaki pevavawene vakavaywangila. ");
INSERT INTO xnj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nambu Yesu akavakemela na kujova, “Muvaleka vana vedebe vabwela kwangu, wala mkoto kuvabesa, muni unkosi wa Chapanga ndava ya vandu ngati venava. ");
INSERT INTO xnj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chakaka nikuvajovela, mundu yoyoha mwanga upokela Unkosi wa Chapanga ngati mwana mdebe, yati iyingila lepi muunkosi wenuwo.” ");
INSERT INTO xnj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkolo vindu vyamahele mmonga Myawudi, amkotili Yesu, “Muwula mbwina, nikita wuli muni nipokela wumi wa magono goha?” ");
INSERT INTO xnj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akamjovela, “Ndava kyani ukunikemela mbwina? Kawaka mweavimbwina nga Chapanga mwene. ");
INSERT INTO xnj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uyimanya mihilu ya Chapanga, ukoto kukita ugoni na ukoto kukoma na ukoto kuyiva na ukoto kujova ga udese vakitila gabwina dadi na nyina waku.” ");
INSERT INTO xnj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mwene akajova, “Genago goha nigakamwili kutumbula uwana wangu.” ");
INSERT INTO xnj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu peayuwini, akamjovela, “Yikugana wakona kukita chindu chimonga, gulisa kila chindu cheuvi nachu, vapela vangangu mashonga ago, ndi veve yati ukujivikila vindu vyaku kunani kwa Chapanga, kangi bwela unilandayi.” ");
INSERT INTO xnj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nambu mundu mwenuyo peayuwini genago, akavya ngolongondi neju ndava avi na vindu vyamahele. ");
INSERT INTO xnj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu peamuwene mundu mwenuyu avi ngolongondi akajova, “Yinonopa neju kwa vakolo vindu vyamahele kuyingila mu Unkosi wa Chapanga! ");
INSERT INTO xnj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Muni yiyuyuka kwa hinyama yeyikemiwa ngamiya kuholota palibowo la sindanu, kuliku mweavi na vindu vyamahele kuyingila Muunkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Vandu vevayuwini ago, vakakota, “Yani hinu, mweisanguliwa?” ");
INSERT INTO xnj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu akayangula, “Gangahotoleka kwa vandu, kwa Chapanga gihotoleka.” ");
INSERT INTO xnj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kangi Petili akamkota, “Na tete wuli? Tuvilekili vindu vyoha na kukulanda.” ");
INSERT INTO xnj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu akavajovela, “Chakaka nikuvajovela, mundu yoyoha mwaileki nyumba amala mdala waki amala mlongo amala dadi na nyina waki amala vana vaki ndava ya unkosi wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yati ipokela gamahele neju mulukumbi ulu lwa hinu, na wumi wa magono goha palusenje lwelubwela.” ");
INSERT INTO xnj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu akavakemela kuchiyepela vawuliwa vaki kumi na vavili, na kuvajovela, “Myuwanila! Tihamba ku Yelusalemu na kila chindu chechiyandikiwi na vamlota va Chapanga ndava ya Mwana wa Mundu yati chihengeka. ");
INSERT INTO xnj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Muni alagotolewa kwa vandu vangali kuvya Vayawudi vene yati vakumvevesa na kumliga na kumuhunyila mata. ");
INSERT INTO xnj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Vene yati Vakumtova na michapilu na kumkoma, nambu paligono la datu yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nambu vene vagamanyi lepi malovi genago hati padebe, lijambu lenilo lafiyiki kwa vene, ndi vagamanyili lepi geavajovili. ");
INSERT INTO xnj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lukumbi Yesu peahegalili ku Yeliko, kwavi na mundu mmonga ngalola atamili pamuhana ya njila ayupayi. ");
INSERT INTO xnj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Peayuwini msambi wa vandu wipita akakota, “Chivii kyani?” ");
INSERT INTO xnj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Vakamjovela, “Yesu wa Nazaleti ipita.” ");
INSERT INTO xnj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Akajova kwa lwami luvaha, “Yesu, wa chiveleku cha Daudi unihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Vandu vevalongolili vala vakamywangila aguna, nambu mwene akayonjokesa kujova kwa lwami luvaha, “Yesu wa chiveleku cha Daudi, unihengela lipyana!” ");
INSERT INTO xnj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu akayima, akalagiza vandu vamleta palongolo yaki. Ngalola yula peahikili papipi, Yesu akamkota, ");
INSERT INTO xnj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wigana nikukitila kyani?” Ngalola akayangula, “Bambu, nihotola kulola kavili.” ");
INSERT INTO xnj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu akamjovela, “Lola! Kusadika kwaku kukulamisi.” ");
INSERT INTO xnj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bahapo ngalola yula akalola, akamlanda Yesu kuni akumulumba Chapanga. Vandu voha pavagawene genago, vakamulumba Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu payingili ku Yeliko, apitayi munjila za muji wenuwo. ");
INSERT INTO xnj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pamuji wenuwo pavi mundu mmonga liina laki Zakayo, avi mkulu wa vatola kodi mwenuyo avi na vindu vyamahele. ");
INSERT INTO xnj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mwenuyo aganayi kumlola Yesu ndi yani, nambu ahotwili lepi ndava ya msambi wa vandu, na Zakayo avi mundu mhupi. ");
INSERT INTO xnj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hinu, akajumba kulongolo na kukwela mumkongo uvaha ndava amlolayi Yesu, muni Yesu apitayi njila yeniyo. ");
INSERT INTO xnj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu peahikili pandu penapo, akalola kunani na kumjovela Zakayo, “Huluka kanyata, muni lelu yati niwela munyumba yaku.” ");
INSERT INTO xnj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Penapo Zakayo akahuluka pahi na kumpokalela Yesu kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Vandu voha pevaloli genago, vakatumbula kung'ung'uta na kujova, “Mundu uyu ahambili kutama kwa mundu mweakumbudila Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nambu Zakayo akayima palongolo akamjovela Yesu, “Bambu Yuwanila! Yati nigava pagati vindu vyangu na kuvapela vangangu na ngati natolili chindu cha mundu kwa kuchenjela, yati nimuwuyisila mala mcheche.” ");
INSERT INTO xnj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu akamjovela, “Lelu usangula uyingili munyumba iyi, muni na mwenuyu mewa chiveleku cha Ibulahimu. ");
INSERT INTO xnj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Muni Mwana wa Mundu abwelili kulonda na kusangula veviyagili.” ");
INSERT INTO xnj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Vandu vavi vakumuyuwanila Yesu peavi papipi kuhika ku Yelusalemu vandu vaholalela Unkosi wa Chapanga uvi papipi kuhumila ndava genago Yesu avajovili luhumu wungi. ");
INSERT INTO xnj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hinu akavajovela, kwavili na mundu mmonga wa lukolo lwa unkosi, mwaahambili kumulima wa kutali muni avikiwa unkosi na nkosi mkulu na kuwuya. ");
INSERT INTO xnj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akavakemela vatumisi vaki kumi, na kuvapela kila mundu mashonga salafu zeziwanangana na luhuna lwa lihengu la mihyei yidatu, kila mmonga na kuvajovela, mhengela lihengu la kugula na kugulisa vindu mbaka peniwuyayi. ");
INSERT INTO xnj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nambu vandu va mulima wenuwo vamuhakalili mundu mwenuyo, ndi vatumili vajumbi vamulanda na kuhamba kujova, tigani lepi mundu uyu avyaa nkosi witu. ");
INSERT INTO xnj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Mundu mwenuyo agotoliwi unkosi wenuwo na kuwuya pamulima waki. Bahapo akalagiza vakemelewayi vavanda vevapewili mashonga vala, muni aganayi kumanya ngati kila mmonga ayonjokisi mashonga galinga. ");
INSERT INTO xnj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Akabwela mvanda mtumbula akajova, ‘Bambu, lilundu limonga la mashonga lewanipelili niyonjokisi malundu gangi kumi ga mashonga.’ ");
INSERT INTO xnj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bambu yula akajova, ‘Chabwina.’ Veve wamtumisi mbwina! Ndava muni usadikiwi mumambu gadebe, ‘Hinu yati nikuvika uvya chilongosi mumiji kumi.’ ");
INSERT INTO xnj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Akagelekela mtumisi yungi akajova, ‘Bambu lilundu la mashonga yewanipelili niyonjakisi malundu ga mashonga gangi mhanu.’ ");
INSERT INTO xnj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bambu yula akamjovela, ‘Na veve yati nikupela uvya wa chilongosi mumiji mhanu.’” ");
INSERT INTO xnj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Muhengaji yungi akabwela na kujova, ‘Bambu, tola lishonga laku muni nakungili muchitambala na kuyifiya pabwina. ");
INSERT INTO xnj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ndava muni nakuyogwipi, muni veve wa mundu winonopa. Witola vindu vyangali vyaku nakubena pawangamija.’ ");
INSERT INTO xnj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bambu yula akamjovela, ‘Yati nikuhamula ndava ya malovi gaku veve mtumisi mhakau! Kumbi wamanyi hotohoto ngati nene ninonopa, ndava nitola vyangali kuvya vyangu na kubena panangamija. ");
INSERT INTO xnj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ndava kyani wavikili lepi malundu ga mashonga gangu mubenki? Na nene nganitolili pamonga na chiyonjakesu peniwuya.’” ");
INSERT INTO xnj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Akavajovela vevavi penapo, ‘Mumnyagayi lilundu la lishonga lenilo, mukampela yula mweavi na malundu ga mashonga kumi.’ ");
INSERT INTO xnj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Vene vakamjovela, ‘Mwenuyo amali kupewa malundu ga mashonga kumi!’ ");
INSERT INTO xnj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bambu akavayangula, ‘Nikuvajovela, mundu yoyoha mweavi na chindu yati ipewa na kuyonjokesewa. Nambu mweangali chindu. Hati cheavi nachu yati inyagiwa. ");
INSERT INTO xnj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na hinu vamakoko vangu vevakunibela nikotoka kuvya nkosi wavi, muvaletayi penapa na muvahinja palongolo yangu!’” ");
INSERT INTO xnj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu peamali kujova genago, akavalongolela kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Peavili papipi kuhika ku Betifage na ku Betania papipi na chitumbi cha mikongo ya Mizeituni, avatumili vavili va vawuliwa vaki, ");
INSERT INTO xnj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na kuvajovela, “Muhamba muchijiji chechivii palongolo yinu, na pemwitumbula kuyingila muchijiji chenicho yati mulikolela mapapakasi wa punda akungiwi langatumbula kugega mundu. Muwopolayi, mubwela nalu apa. ");
INSERT INTO xnj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ngati mundu akuvakota, ndava kyani mukuliwopola lipunda? Mumjovela, ‘Bambu akumgana.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Vevatumiwi vala vakahamba nakukolela ngati chavajoviwi na Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pevawopolayi punda mpakakasi, vakolo lipunda vakavakota, “Ndava kyani mukuliwopola lipunda mpapakasi ili?” ");
INSERT INTO xnj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Vakayangula, “Bambu akumgana.” ");
INSERT INTO xnj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ndi vampelakili Yesu. Kangi vakatola nyula na kumuyambatisa punda mpapakasi panani na kumtamisa Yesu panani yaki. ");
INSERT INTO xnj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu ayendalili na lugendu kuni vandu vayendelela kumdandasila nyula zavi munjila. ");
INSERT INTO xnj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Paavi papipi kuhika ku Yelusalemu paluhelelu lwa chitumbi cha mikongo ya Mizeituni, msambi woha wa vandu na vawuliwa vaki vatumbwili kumlulutila kwa lwami luvaha na kumlumba Chapanga ndava ya mambu gakulu goha gevagaweni, ");
INSERT INTO xnj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","vakajova, “Amotisiwa Nkosi mweibwela kwa uhotola wa Bambu! Uteke uvya kunani kwa Chapanga na Chapanga alumbiwa mweavi kunani!” ");
INSERT INTO xnj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Vafalisayu vangi vevavili mu msambi wula wa vandu vakamjovela Yesu, “Muwula, vagunisa vawuliwa vaku!” ");
INSERT INTO xnj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akavayangula, “Nikuvajovela, ngati venava vaguni, maganga haga yati giywanga.” ");
INSERT INTO xnj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Paavi papipi neju na kuulola muji wa Yelusalemu, akauvembela muji wenuwo, ");
INSERT INTO xnj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akajova, “Ngati kuvya umanyili lelu mambu gegileta uteke! Nambu hinu gafiyiki pamihu gaku! ");
INSERT INTO xnj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Muni galabwela magono, penapo vamakoko vaku yati vakutindikila luwumba, yati vakuhaka na kukuhinya pandi zoha. ");
INSERT INTO xnj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Penapo yati vakutimbisula veve na vana vaku muluwumba wula, vakulekela lepi hati liganga limonga lelisigalila panani ya liganga lingi, ndava wamanyi lepi lukumbi Chapanga peakubweli kukusangula!” ");
INSERT INTO xnj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kangi Yesu akayingila mu Nyumba ya Chapanga, akutumbula kuvavinga vandu vevagulisa na kugula vindu, ");
INSERT INTO xnj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","akajova, “Yiyandikiwi, ‘Nyumba yangu yati yivya nyumba ya kumyupila Chapanga.’ Nambu nyenye muhiyusi kuvya libokoselu la vanyagaji.” ");
INSERT INTO xnj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ligono kwa ligono Yesu avawulayi mu Nyumba ya Chapanga. Nambu Vakulu va Kuteta na vawula va malagizu na vachilongosi va vandu, valonda njila ya kumkoma, ");
INSERT INTO xnj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nambu vavi nakumanya cha kukita ndava vandu voha vagunili kumyuwanila. ");
INSERT INTO xnj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ligono limonga, Yesu peavi mukuwula vandu mu Nyumba ya Chapanga na kuvakokosela Lilovi la Bwina, vakulu va kuteta na vawula va malagizu ga Chapanga geampeli Musa na vagogo va Vayawudi, vamhambili. ");
INSERT INTO xnj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Vakajova, “Utijovelayi! Wikita mambu aga kwa uhotola gani?” Ndi yani mweakupelili uhotola wenuwo? ");
INSERT INTO xnj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu akavajovela, “Na nene yati nikuvakota likotesi, ");
INSERT INTO xnj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","wu, uhotola wa Yohani wa kubatiza, wahumili kwa Chapanga amala kwa vandu?” ");
INSERT INTO xnj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Vakakotana vene kwa vene, “Tikajova wahumili kwa Chapanga, yati akutikota, ‘Ndava kyani mwamsadiki lepi?’ ");
INSERT INTO xnj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nambu tikajova wahumili kwa vandu, vandu voha yati vakutikoma na maganga, muni woha visadika kuvya Yohani avi mlota wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Vakamyangula, “Timmanyi lepi kwegahumili.” ");
INSERT INTO xnj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu akavajovela, “Na nene nikuvajovela lepi nikita mambu genago kwa uhotola wa yani.” ");
INSERT INTO xnj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu akayendelela kuvajovela luhumu ulu, “Mundu mmonga alimili mgunda wa mizabibu, avakodishi valimaji, kangi akahamba mulugendu mbaka mulima wa kutali, akatama kwenuko magono gamahele. ");
INSERT INTO xnj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lukumbi lwa kubena mizabibu mundu mwenuyo, amtumili mvanda waki akatola lilundu laki kuhuma ku mgunda. Nambu valimaji wa mumgunda wula vakamtova mvanda yula vakamvinga mawoko gawaka. ");
INSERT INTO xnj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mkolo mgunda amtumili kavili mvanda yungi, nambu vene mewawa vakamtova na kumliga na kumvinga mawoko gawaka. ");
INSERT INTO xnj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kangi akamutuma mvanda wa datu, mwenuyo ndi vakamulemasa na kumtaga kuvala. ");
INSERT INTO xnj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mkolo mgunda yula akahololela, ‘Yati nikita kyani? Yati nikumtuma mwana vangu ngayuyoyo wa chiganu, manya mwenuyo yati vakumtopesa. ");
INSERT INTO xnj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nambu valimaji vala, pevamuweni, vakajovesana, mwenuyu ndi mhali waki. Hinu timkomayi muni uhali waki uvya witu!’ ");
INSERT INTO xnj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ndi, vakamuwusa kuvala ya mgunda wula wa mizabibu, vakamukoma.” Yesu akavakota, “Mkolo mgunda yula yati akuvakita kyani valimaji vala?” ");
INSERT INTO xnj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Yati ibwela kuvakoma valimaji venavo, na kuvapela vangi mgunda wenuwo.” Vandu pevayuwini genago, vakajova, “Lepi! Gakotoka kuhumila hati padebe.” ");
INSERT INTO xnj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nambu Yesu akavalolokesa na kuvakota. Mayandiku Gamsopi aga mana yaki kyani? Liganga levabeli vajengaji, hinu ndi liganga likulu la kutumbula pakujenga. ");
INSERT INTO xnj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu yoyoha akagwilila panani ya liganga lenilo yati idenyekana hipandi hipandi, na liganga lenilo lakamgwilila mundu yoyoha ndi likumuyaga nyiminyimi. ");
INSERT INTO xnj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Vawula va Malagizu na vakulu va kuteta vamanyili kuvya luhumu lwenuwo ukuvavala vene, ndi vaganayi kumkamula bahapo, nambu vayogwipi vandu. ");
INSERT INTO xnj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Vamlandili cha papipi. Kangi vakavatuma vamang'omesi, vevajidekisi vandu vabwina muni vamyonja kwa malovi gaki, vakitili genago muni vahotola kumkamula na kumgotola muuhotola wa mkulu wa mkowa. ");
INSERT INTO xnj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Vamang'omesi vala vakamjovela, “Muwula timanyili kuvya wijova na wiwula mambu gachakaka, wala nakumlola mundu pamihu ndi wiwula uchakaka munjila ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ndi utijovela, wu! Chabwina amala, lepi tete kulipa kodi kwa nkosi wa ku Loma?” ");
INSERT INTO xnj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nambu Yesu amanyili likoka lavi, akavajovela, ");
INSERT INTO xnj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Munilangisa salafu ya lishonga. Wu, pamihu na liina ndi vya yani?” Vakamyangula, “Vya nkosi wa ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu akavajovela, “Hinu mumpela nkosi wa ku Loma vyaki nkosi wa ku Loma na mumpela Chapanga vyaki Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Vahotwili lepi kumyonjola hati kwa lilovi limonga palongolo ya vandu, vakakangasa kwa mayangula gaki vakaguna. ");
INSERT INTO xnj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kangi Vasadukayu, vevijova kuvya vevafwili viyuka lepi, vakambwelela Yesu, vakajova, ");
INSERT INTO xnj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Muwula, Musa atiyandikili ngati mlongo mundu afwili na amlekili mdala waki changali vana, yikumgana mhaja waki amhalayi lipwela mwenuyo, muni ambabakisila vana mlongo waki. ");
INSERT INTO xnj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hinu, kwavili na valongo saba va lukolo lumonga. Mhaja wavi agegili mdala, afwili changaleka mwana. ");
INSERT INTO xnj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mbena waki yula akamhala lipwela, mwene mewa afwili changali mwana, ");
INSERT INTO xnj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","hati mbena waki wa datu akamhala, mambu gakavya galagala voha saba vafwili, changali kuvelekisa vana. ");
INSERT INTO xnj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pamwishu, mdala yula afwili. ");
INSERT INTO xnj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Wu, palukumbi lwa vevafwili kuyukiswa, mdala yula alavya mdala wa yani? Muni agegiwi na voha saba.” ");
INSERT INTO xnj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akayangula, “Vandu va lusenje lwa hinu vigega na kugegewa, ");
INSERT INTO xnj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nambu vala vevahaguliwi na veviganikiwa kupewa wumi wa mulima wula, na kuyukiswa kula kuhuma kwa vevafwili, vigega lepi amala kugegewa. ");
INSERT INTO xnj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chakaka vifwa lepi kavili ndava viwanangana na vamitumu va kunani kwa Chapanga, ndi vana vaki Chapanga, ndava ya kuyukiswa kwavi. ");
INSERT INTO xnj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hati, Musa atilangisi njwe, kuvya vevafwili yati viyukiswa, mu Mayandiku Gamsopi. Pamihu ga padahi pepiyaka motu, akumuluwula Bambu Chapanga ngati Chapanga wa Ibulahimu na Chapanga wa Izaki na Chapanga wa Yakobo. ");
INSERT INTO xnj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mwene, lepi Chapanga wa vevafwili nambu kwa vamumi, ndava muni kwa mwene voha vilama.” ");
INSERT INTO xnj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Vawula va malagizu vangi va Musa vakajova, “Muwula, uvayangwili hotohoto!” ");
INSERT INTO xnj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Vandu vala vayogwipi kumkota kavili makotesi gangi. ");
INSERT INTO xnj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu akavakota, vandu vijova wuli, Kilisitu Msangula ndi mwana wa chiveleku cha Daudi? ");
INSERT INTO xnj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Muni Daudi mwene ajovili muchitabu cha Zabuli, Bambu, amjovili Bambu wangu, Tama muchiwoko changu cha kulyela ");
INSERT INTO xnj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hati nivavika makoko vaku pahi pa magendelu gaku. ");
INSERT INTO xnj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngati Daudi akumkemela mwene, Bambu, hinu yihotoleka wuli, kuvya mwana waki? ");
INSERT INTO xnj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesu avajovili vawuliwa vaki palongolo ya vandu voha, ");
INSERT INTO xnj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mujiyangalila na vawula va Malagizu ga Chapanga geampeli Musa, vevigana kugendagenda kuni vawalili magwanda gatali. Vigana kujambuswa chakufugwamila pandu pakugulisila vindu, kutama muvigoda vya kulongolo mu nyumba za kukonganekela Vayawudi, kutama muvigoda vya kulongolo ku mselebuko. ");
INSERT INTO xnj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Vinyaga nyumba za vapwela kwa kuchenjela, na viyupa kwa Chapanga lukumbi lutali, muni valolekanayi na vandu kuvya vabwina. Yati vihamuliwa neju kuliku vangi!” ");
INSERT INTO xnj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu pealolokesa takataka, avawene vandu vevana vindu vyamahele chevisopa luteta muchijomela cha Nyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mewa amuwene lipwela mngangu isopa mashonga sendi zivili. ");
INSERT INTO xnj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Akajova, “Chakaka nikuvajovela, uyu lipwela mngangu asopili neju kuliku voha. ");
INSERT INTO xnj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Muni, vangi voha vasopili luteta, muvindu vyavi vyeviyonjokisi, nambu mau uyu pamonga na ungangu waki asopili chindu cheavi nachu ndava ya wumi waki.” ");
INSERT INTO xnj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vandu vangi valongelelayi malovi ga kuyivala Nyumba ya Chapanga, cheyinyambwisi bwina kwa maganga ga mashonga gamahele, na luteta zezasopiwi kwa Chapanga kangi Yesu akajova. ");
INSERT INTO xnj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Goha aga gemkugawona galabwela magono kawaka hati liganga limonga lelisigalila panani ya liganga lingi, kila chindu yati chidenyekana.” ");
INSERT INTO xnj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ndi vakamkota, “Muwula mambu, genago yati gihumila ndali? Hinu ulangisu woki weulangisa papipi pagihumila mambu genago?” ");
INSERT INTO xnj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu akavayangula, “Mujiyangalilayi, mkoto kukongiwa muni vamahele yati vibwela na kulihengela liina langu. Kuni kila mmonga yati ijova kuvya ‘Mwene ndi Kilisitu msangula!’ ‘Lukumbi luhikili!’ Nambu nyenye mkoto kuvalanda. ");
INSERT INTO xnj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hinu, pamwiyuwana malovi ga ngondo na mng'anamukanu nakuyogopa, muni yiganikwa genago gahumila hoti, nambu pamwishu wene wakona.” ");
INSERT INTO xnj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kangi akayendelela kujova, “Vandu va mulima umonga yati witovana na vandu va mulima wungi, na unkosi umonga yati utovana na unkosi wungi.” ");
INSERT INTO xnj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kila pandu yati pivya na mindendemo yivaha ya ndima na njala na matamu ga kukangasa na kuyogofya, na ulangisu ukulu kuhumila kunani kuliundi. ");
INSERT INTO xnj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nambu, kwakona kuhumila genago goha, yati vakuvakamula na vakuvang'aha na kuvapeleka munyumba za kukonganekela Vayawudi na kuvakunga muchifungu, yati vakuvapeleka kwa vankosi na vachilongosi, ndava ya liina langu, ");
INSERT INTO xnj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","muhotola kujova kwa vene. ");
INSERT INTO xnj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mkangamala mumitima yinu, mkoto kuholela kwakona, wuli mukujikengelela, ");
INSERT INTO xnj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ndava namwene yati nikuvapela malovi ga luhala, hati makoko winu yati nakuhotola kukangamala amala kuvabelela. ");
INSERT INTO xnj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Vadadi na Vanyina vinu, valongo na vandu va lukolo lwinu na vankozi vinu, yati vakuvang'anamukila nyenye, vangi pagati yinu yati mwikomiwa. ");
INSERT INTO xnj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vandu voha yati vakuvahakalila nyenye ndava yangu. ");
INSERT INTO xnj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nambu, hati luyunju lumonga wa mumitu yinu lwiyaga lepi. ");
INSERT INTO xnj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Msindimala, kwa kusindimala kwinu, yati mwisangula wumi winu. ");
INSERT INTO xnj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nambu, “Pemwilola chikundi cha manjolinjoli chiutindili muji wa Yelusalemu, mumanya kuvya lusenje lwa kudenyeka kwaki luhikili. ");
INSERT INTO xnj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hinu, vevavi ku Yudea vajumbalila kuchitumbi na vevavi kumuji vawuka na vevavi kumgunda vala vakotoka kuwuya kumuji. ");
INSERT INTO xnj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ndava magono ago ndi magono ga Chapanga kuvabuna vandu vaki, muni kukita mambu goha gegayandikwi mu Mayandiku Gamsopi gahengeka. ");
INSERT INTO xnj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Valachikolela vadala vana ndumbu na vevinyongesa magono genago! Muni yati kwiva na mang'ahiso gamahele mu mulima na ligoga la Chapanga likuvabwelela vandu va mulima wa Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vangi vikomiwa kwa upanga, vangi vitoliwa na kupechenganwa mumilima yoha, muji wa Yelusalemu yati wilongoswa na vandu vangali Vayawudi, mbaka mwishu wa ulongosi wavi.” ");
INSERT INTO xnj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Yati kwivya na ulangisu mulilanga na mwehi na ndondo. Na vandu pamulima yati vivagaya ndava ya wogohi wa kubuma kwa luyuga lwa nyanja. ");
INSERT INTO xnj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Vandu yati vihinduka ndava ya wogohi, pevilola mambu gegakuukolela mulima, muni vindu vyoha vya kulihundi lilanga na mwehi na ndondo na vingi vyoha yati vinyugusika. ");
INSERT INTO xnj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kangi, yati vamlola Mwana wa Mundu ibwela mulihundi, ana makakala na ukulu wamahele. ");
INSERT INTO xnj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lukumbi mambu genago pagitumbula kuhumila, myimayi mkangamala, muni kugomboka kwinu kuhegalili.” ");
INSERT INTO xnj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kangi akavajovela luhumu, “Mlola mkongo wa mtini na mikongo yingi yoha. ");
INSERT INTO xnj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pemwilola yitumbula kumela mahamba, mwavene mwimanya kuvya lusenje lwa fula luhegelili. ");
INSERT INTO xnj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mewawa, pamwilola mambu genago gihengeka yati mwimanya kuvya Unkosi wa Chapanga uvi papipi. ");
INSERT INTO xnj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Chakaka nikuvajovela, chiveleku ichi cha hinu chipita lepi kwakona genago goha kuhengeka. ");
INSERT INTO xnj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunani kwa Chapanga na pamulima yati ziwuka, nambu malovi gangu katu gipita lepi.” ");
INSERT INTO xnj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mujiyangalilayi! Mitima yinu yikotoka kutopelwa, kwa mambu ga kugala na uhutulu na mang'ahiso ga mulima uwu. Muni ligono lenilo likuvabwelela chigafula. ");
INSERT INTO xnj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Muni yikuvabwelela ngati likoka vandu voha vevitama pamulima poha. ");
INSERT INTO xnj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hinu muvyamihu, na muyupayi kwa Chapanga lukumbi lwoha muni muhotola mpata makakala ga kuyepa mambu genago goha pegihumila, na kuyima palongolo ya Mwana wa Mundu.” ");
INSERT INTO xnj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kila ligono muhi magono ago, Yesu avi mukuwula vandu mu Nyumba ya Chapanga, nambu kilu ahambayi kuchitumbi cha mizeituni na kutama kwenuko. ");
INSERT INTO xnj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na vandu voha vayumwiki lukela hambakucha kuhamba pa Nyumba ya Chapanga, vapata kumyuwanila Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mselebuko wa mabumunda gangali ngemeku, wewikemiwa Pasaka yavi papipi. ");
INSERT INTO xnj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Vakulu va kuteta na vawula va malagizu ga Musa vakavya mukulonda njila ya kumkoma Yesu, nambu vavayogwipi vandu. ");
INSERT INTO xnj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Setani akamyingila Yuda mweikemelewa Isikalioti, mmonga pagati ya vamitumi vala kumi na vavili. ");
INSERT INTO xnj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda akahamba, kulongela na vakulu va kuteta na vakulu va valonda va Nyumba ya Chapanga, ndava ya kuvagotolela Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Vene vakaheka na vakayidakila kumpela mashonga. ");
INSERT INTO xnj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda akayidakila, ndi alonda fwasi ya bwina ya kumgotola Yesu changali msambi wa vandu kumanya. ");
INSERT INTO xnj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ligono la mabumunda gangasopewa ngemeku likahika. Lenilo ndi ligono la kuhinjwa mwana limbelele wa Pasaka. ");
INSERT INTO xnj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu akavatuma Petili na Yohani, avajovili “Mhamba mkatendekelayi chakulya cha Pasaka.” ");
INSERT INTO xnj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Vene vakamkota, “Wigana tikutendelekayi koki?” ");
INSERT INTO xnj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu akavajovela, “Myuwanila! Pamwiyingila kumuji yati mwikonganeka na mgosi mweagegili chihulu cha manji. Mumlanda mbaka munyumba yeiyingila. ");
INSERT INTO xnj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mumjovela mkolo nyumba, ‘Muwula akukota, chivii koki chumba nilyayi chakulya cha Pasaka pamonga na vawuliwa vangu?’ ");
INSERT INTO xnj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hinu mkolo nyumba yati akuvalangisa chumba chivaha cha kugolofa chechivikiwi kila chindu. Hinu mtendelekeha chakulya mwenumo.” ");
INSERT INTO xnj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Vakahamba, vakakolela kila chindu chivili ngati Yesu cheavajovili, ndi vakatendelekela chakulya cha Pasaka. ");
INSERT INTO xnj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lukumbi palwahikili, Yesu akatama kulya chakulya pamonga na vamitumi vaki. ");
INSERT INTO xnj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akavajovela, “Ninogili neju kulya chakulya cha Pasaka yeniyi pamonga na nyenye, kwakona kung'aiswa kwangu. ");
INSERT INTO xnj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Muni nikuvajovela, yati nilya lepi kavili Pasaka mbaka penapo payikamilika Muunkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kangi Yesu akatola chikombi, akamsengusa Chapanga akajova, “Mtola, mpelanayi mwavoha, ");
INSERT INTO xnj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Muni nikuvajovela, kuhumila hinu ninywa lepi kavili divayi mbaka Unkosi wa Chapanga peubwela.” ");
INSERT INTO xnj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mewawa akatola libumunda, akamsengusa Chapanga, akayimetula, akavapela akajova, “Yeniyi ndi higa yangu yemwipewa nyenye. Muni munikumbukayi nene.” ");
INSERT INTO xnj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Akakita mewawa na chikombi peamali kulya, akajova, “Chikombi ichi ndi lilaganu la mupya yeyilangiswa na ngasi yangu na yeyiyitika ndava yinu.” ");
INSERT INTO xnj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nambu, mlola! Mweakuning'anamukila avi bahapa pachakulya pamonga na nene. ");
INSERT INTO xnj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chakaka Mwana wa Mundu ihamba kukomiwa, ngati cheaganili Chapanga, nambu alachikolela mundu yula mweamng'anamukila.” ");
INSERT INTO xnj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Penapo vakatumbula kukotana vene kwa vene yani pagati yavi mwaihenga lijambu lenili. ");
INSERT INTO xnj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Vamitumi va Yesu vakatumbula kuhutana kumvala yani mweihololewa kuvya mkulu kuliku vangi. ");
INSERT INTO xnj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu akavajovela, “Vankosi va milima vakuvalongosa vandu kwa makakala, na vachilongosi vakujikemela kuvya ‘Vankozi va vandu.’ ");
INSERT INTO xnj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nambu yikoto kuvya chenichi pagati yinu, mweavimkulu pagati yinu yikumgana kuvya ngati mdebe, na mweavi chilongosi yikumgana kuvya ngati mtumisi. ");
INSERT INTO xnj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Muni, ndi yani mweavi mkulu, mweitama pameza kulya chakulya, amala yula mweitumikila? Chakaka ndi yula mweitama pameza kulya chakulya! Pamonga na genago, nambu nene nivii pagati yinu ngati muhengaji.” ");
INSERT INTO xnj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nyenye ndi mwemwasigalili na nene lukumbi lwoha lwa mang'ahiso gangu, ");
INSERT INTO xnj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ngati, Dadi cheanigotolili nene uhotola wa kulongosa, mewawa na nene nikuvagotolela nyenye, uhotola wenuwo. ");
INSERT INTO xnj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Hinu, yati mwinywa na kulya pameza yangu muunkosi wangu na kutama muvigoda vya Unkosi na kuhamula makabila kumi na gavili ga Isilaeli.” ");
INSERT INTO xnj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Yesu akajova, Simoni, Simoni! Yuwanila! Setani ayupili luwusa kwa Chapanga lwa kuvalinga nyenye kulola ngati muyendelela kuvya vamsadika. ");
INSERT INTO xnj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nambu nene nikukuyupila veve muni kusadika kwaku kukotoka kupungula. Na veve peukuvawuyila vakangamalisa valongo vaku.” ");
INSERT INTO xnj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ndi Petili akayangula, “Bambu, nene nijitendelekili kuhamba na veve muchifungu amala kufwa pamonga na veve.” ");
INSERT INTO xnj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nambu Yesu akajova, “Nikukujovela Petili, kwakona lijogolo langavika lelu yati ukunibela mala zidatu.” ");
INSERT INTO xnj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kangi, Yesu akavakota vawuliwa vaki, “Panakavatumili changali chihaku cha mashonga amala lihaku amala champali za munjila mwapungukiwi na chindu?” Vakamyangula, “Lepi.” ");
INSERT INTO xnj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu akavajovela, “Nambu hinu mundu mweavi na chihaku cha mashonga agega na mweavi na lihaku mewawa. Na yoyoha angali upanga agulisa likoti laki na akagula umonga. ");
INSERT INTO xnj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yiyandikwi mu Mayandiku Gamsopi, ‘Avalangiwi kuvya mmonga pagati ya vandu vanyagaji,’ Nikuvajovela naha, Mayandiku giganikiwa gatimila ndava yangu, ndava muni wumi wangu wihika pamwishu.” ");
INSERT INTO xnj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Vawuliwa vakajova, “Bambu, lola, penapa zivii panga zivili.” Akavajovela, “Tigaleki!” ");
INSERT INTO xnj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu akawuka ngati chayavili mvelu waki, akahamba kuchitumbi cha Mizeituni vawuliwa vaki vakamlanda. ");
INSERT INTO xnj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pehahikili pandu pala akavajovela vawuliwa vaki, “Muyupayi, mukoto kuyingila mukulingiwa.” ");
INSERT INTO xnj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kangi mwene akavaleka, akahamba utali wa mundu kujugumila liganga, akafugama, akayupa. ");
INSERT INTO xnj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Akajova, “Dadi, ngati wigana uniwusila chikombi ichi cha mang'ahiso, nambu lepi chiganu changu, ndi chewigana wamwene.” ");
INSERT INTO xnj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kangi, Mtumu wa kunani kwa Chapanga akahumila akamkangamalisa. ");
INSERT INTO xnj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hinu peavi mulipyanda, akamuyupa Chapanga neju, na lihuki ngati matonji ga ngasi, gamhulwili pahi. ");
INSERT INTO xnj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Peamali kuyupa, akayima kuvawuyila vawuliwa vaki akavakolela vagonili, ndava vavi ngolongondi. ");
INSERT INTO xnj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu akavajovela, “Ndava kyani mwigona? Muyumuka muyupa, mkoto kuyingila mukulingiwa.” ");
INSERT INTO xnj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Peavi akona ilongela, msambi wa vandu ukabwela kuni ulongoswa na Yuda mmonga wa vawuliwa kumi na vavili. Yuda akamhegelela Yesu na kumjambusa cha kumkumbatila. ");
INSERT INTO xnj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nambu Yesu akamjovela, “Yuda! Wu, ukumng'anamukila Mwana wa Mundu kwa jambusa ya kumkumbatila?” ");
INSERT INTO xnj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Vawuliwa vala pavachiwene chechihumila vakakota, “Bambu, tivadumula na panga zitu?” ");
INSERT INTO xnj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ndi mmonga pagati yavi akamtova mvanda wa Mteta Mkulu wa Chapanga, akamdumula likutu la upandi wa kulyela. ");
INSERT INTO xnj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nambu Yesu akajova, “Mleka! Yikoli.” Akampamisa likutu la mundu yula, akamlamisa. ");
INSERT INTO xnj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kangi Yesu akavajovela, vakulu va vakulu va kuteta na vakulu va valonda va Nyumba ya Chapanga na vagogo vevabweli kumkamula, “Wu, mbweli na mapanga na vibonga kunikamula ngati nene namnyagaji? ");
INSERT INTO xnj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Penavi pamonga na nyenye magono goha Munyumba ya Chapanga mwanikamwili lepi. Nambu ulu ndi lukumbi lwinu, lukumbi lwa uchilongosi wa chitita.” ");
INSERT INTO xnj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Vakamkamula Yesu, na kumtola, kuhamba nayu kunyumba ya Mteta Mkulu wa Chapanga. Petili amlandili cha kutali. ");
INSERT INTO xnj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vakakosa motu pagati ya luvanja lwa nyumba vakatama pamonga, na Petili avili pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Muhengaji mmonga mdala peamuwene Petili atamili papipi na motu, akamlolokesa akajova, “Mundu uyu mewawa avi pamonga na Yesu.” ");
INSERT INTO xnj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nambu petili akabela akajova, “Mdala veve! Nene nimmanyili lepi.” ");
INSERT INTO xnj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mwanakandahi, mundu yungi amuweni Petili, akajova “Veve wa mmonga wavi.” Nambu Petili akayangula “Bambu veve, lepi nene!” ");
INSERT INTO xnj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ngati lukumbi lwa saa yimonga palongolo, mundu yungi akajova, “Chakaka na mundu uyu avi pamonga na Yesu, ndava mwenuyu mewa Mgalilaya.” ");
INSERT INTO xnj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nambu Petili akajova, “Bambu veve, nichimanyili lepi chewijova!” Bahapo peavi akona ilongela lijogolo likavika. ");
INSERT INTO xnj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bambu akamng'anamuka na kumlola Petili, ndi Petili agakumbwiki geajoviwi na Bambu gala, “Lelu kilu kwakona lijogolo kuvika yati ukunibela mala yidatu.” ");
INSERT INTO xnj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Penapo Petili akahuma kuvala akavemba neju. ");
INSERT INTO xnj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Vandu vevamyangalila Yesu vala, vakamtova na kumvevesa. ");
INSERT INTO xnj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Vakamgubika mihu na chitambala, vakavya kumkota, lotelayi yani mwaakutovili? ");
INSERT INTO xnj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Vakamjovela malovi ga mahele ga maligu. ");
INSERT INTO xnj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kwapachili, vagogo va mulima na vakulu va kuteta na vawula va malagizu ga Musa, vakonganiki pamonga, vakamtola Yesu vakampeleka mulibanji lavi likulu la Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Vene vakamjovela “Utijovela! Wu, veve ndi Kilisitu Msangula?” Nambu Yesu akayangula, “Hati ngati nivajovili, yati mwisadika lepi, ");
INSERT INTO xnj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na ngati nivakotili nyenye, yati nakuniyangula. ");
INSERT INTO xnj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nambu kutumbula hinu, Mwana wa Mundu yati itama upandi wa kulyela wa Chapanga ana makakala.” ");
INSERT INTO xnj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Voha vakamkota, “Ndi, veve Mwana wa Chapanga?” Mwene akayangula, “Mwavene ndi mujovili kuvya ndi nene.” ");
INSERT INTO xnj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kangi vakajova, “Hinu, tigana lepi ujova wungi ndava yaki? Tavete timyuwini cheijova mumlomo waki mwene.” ");
INSERT INTO xnj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Msambi wa vandu voha vevakonganiki pala, vakayima na kumpeleka Yesu palongolo ya Pilatu, ");
INSERT INTO xnj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vakatumbula kumtakila vakajova, “Tamkolili mundu uyu avayaganisa vandu vitu na kavili akuvabesa vandu vakotoka kumpela kodi nkosi wa ku Loma na kujikemela ati mwene ndi Kilisitu Msangula Nkosi.” ");
INSERT INTO xnj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu akamkota Yesu, “Veve ndi Nkosi wa Vayawudi?” Yesu akamyangula, “Veve wamwene ndi ujovili, veve Nkosi wa Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatu akavajovela vakulu va kuteta na msambi wa vandu, “Nakuchiwona chindu cheabudili mundu uyu.” ");
INSERT INTO xnj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nambu vene vakajova chinganga, “Akuvakulukisa vandu kwa mawuliwu gaki mumulima woha wa Yudea, atumbwili ku Galilaya na hinu avi penapa.” ");
INSERT INTO xnj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu peayuwini genago, akakota, “Wu, mundu uyu ndi mkolonjinji wa ku Galilaya?” ");
INSERT INTO xnj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Peamanyili Yesu ihuma mumulima wewilongoswa na Helodi, ndi ampeliki kwa Helodi muni lukumbi lwenulo mewa avi ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helodi akavya na luheku neju peamuweni Yesu. Muni amali kuyuwana mambu ga Yesu, ndi magono gamahele anogelayi kumlola Yesu cheikita gachinamtiti. ");
INSERT INTO xnj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Helodi amkotili Yesu makotesi gamahele, nambu Yesu nakumyangula chindu. ");
INSERT INTO xnj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Vakulu va kuteta na vawula va malagizu ga Chapanga geampeli Musa vakayima kulongolo na kumtakila chinganganga. ");
INSERT INTO xnj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helodi pamonga na vamanjolinjoli vaki vakampeli soni Yesu na kumvevesa, kangi vakamuwalika ligwanda la unkosi na kumuwuyisa kwa Pilatu. ");
INSERT INTO xnj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Magono gamumbele Helodi na Pilatu vatamanila cha umakoko, nambu kutumbula ligono lenilo vakavya vankozi. ");
INSERT INTO xnj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatu akavakemele pamonga, Vamteta vakulu na vachilongosi va Chiyawudi na vandu, ");
INSERT INTO xnj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","akavajovela, “Mumletili mundu uyu mwijova akuvayaganisa vandu. Hinu myuwanila! Nimali kulola muhalu uwu palongolo yinu kawaka chindu cheabudili mu mambu goha gemumtakili. ");
INSERT INTO xnj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Lepi nene ndu, nambu hati Helodi mewa, amuwuyisi kavili, ndava kawaka chindu cheabudili cheachiwene, kwa mundu uyu hati ahamuliwa lifwa. ");
INSERT INTO xnj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yati nilagazila atovewa michapilu ya miinga, na kumulekekesa. ");
INSERT INTO xnj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mselebuko wa Pasaka, Pilatu yamganili kuvadindulila mundu mmonga kuhuma muchifungu.” ");
INSERT INTO xnj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nambu voha vakaywanga, “Mkoma mundu uyu! Utidindulilayi Balaba!” ");
INSERT INTO xnj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba asopiwi muchifungu ndava ya kukulukisa vandu muchitutu na muchitutu chenicho mundu mmonga akomiwi. ");
INSERT INTO xnj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatu aganili kumulekekesa Yesu, ndi akalongela nawu kavili vandu vevamtakili Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nambu vene vakaywanga vakajova, “Mvambayi pamsalaba, mvambayi pamsalaba!” ");
INSERT INTO xnj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatu akavajovela mala ya datu, “Chindu gani cheabudili mundu uyu? Nichiwona lepi chindu cheabudili hati ahamuliwa kukomiwa! Nene yati nilagiza atovewayi michapilu na kumlekekesa.” ");
INSERT INTO xnj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nambu vene vakayonjokesa kuywanga neju, Yesu yiganikwa avambiwayi pamsalaba, lwami zavi pamwishu zayuwaniki. ");
INSERT INTO xnj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hinu, Pilatu akahamula gahengeka. ");
INSERT INTO xnj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akamulekekesa kuhuma muchifungu yula mweakukingiwi ndava ya kuvya pamonga na vandu muchitutu na kukoma mundu mmonga, ndi akamgotola Yesu vamukita ngati chevigana. ");
INSERT INTO xnj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pevavi mukupeleka, vakakonganeka na mundu mmonga liina laki Simoni mkolonjinji wa Kulene, mweahumayi kumgunda waki, ndi vakamkamula na kumgegesa msalaba wula mumbele ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Vandu msambi kwa msambi, wamulandili, pagati yavi vavi vadala vevamuvembelayi Yesu ndava ya lipyanda. ");
INSERT INTO xnj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu akavang'anamukila, akajova, “Vamawu va Yelusalemu! Mkoto kunivembela nene, nambu mujivembela mwavene na vana vinu. ");
INSERT INTO xnj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Muni chakaka walabwela lukumbi, yati mwijova, ‘Mbanga yavi vadala, vangali vana na vangavaleke, amala vanganyong'esa vana!’ ");
INSERT INTO xnj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lukumbi lwenulo, yati vandu vakuvijovela vidunda, mutigwilila na tudunda, ‘Mutigubika!’ ");
INSERT INTO xnj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ngati vandu vakunikitila nene chenicho mwenivili ngati mkongo uvisi, yati yivya wuli kwa nyenye mwemuvi ngati mkongo uyumu?” ");
INSERT INTO xnj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mewa vavatoli vandu vangi vavili vanyagaji vavapeliki, kukomiwa pamonga na Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pavahikili pandu pepikemelawa, “Libangu la Mutu,” Ndi vakamvamba Yesu pamsalaba pamonga na vanyagaji vavili vala mmonga upandi waki wa kulyela na yungi upandi wa kumangeya. ");
INSERT INTO xnj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu akajova, “Dadi, valekekesa, muni nakumanya chevikita.” Kangi, vakagavana nyula zaki kwa kuhagula kwa gudugudu. ");
INSERT INTO xnj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vandu vayimili kulolokesa kuni vakulu va Vayawudi chevamvevisi vijova, “Avasangwili vangi, hinu ajisangula mwene ngati mwene ndi Kilisitu mwehaguliwi na Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Manjolinjoli mewa vamvevisi, vamhambili Yesu na kumpela divayi yivavanu, ");
INSERT INTO xnj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Vakumjovela, “Ngati chakaka veve ndi Nkosi wa Vayawudi, ujisangula wamwene!” ");
INSERT INTO xnj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Panani ya msalaba vavikili chibawu chechayandikiwi, “Mwenuyu ndi Nkosi wa Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mmonga wa vanyagaji vala vevavambiwi pamsalaba akamliga Yesu, akajova “Wu, lepi chakaka kuvya veve ndi Kilisitu Msangula? Jisangula wamwene, utisangula na tete!” ");
INSERT INTO xnj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nambu mnyagaji yungi yula, akamuywangila muyaki akamjovela, “Veve ukumuyogopa lepi Chapanga hati padebe? Veve uhamuliwi mewawa. ");
INSERT INTO xnj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Veve na nene yikutigana tihamuliwa ndava ya kunyaga kwitu. Nambu mundu uyu kawaka hati chimonga cheabudili.” ");
INSERT INTO xnj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kangi akamjovela Yesu, “Veve Yesu! Ukoto kunikosiwa peuyingila Munkosi waku!” ");
INSERT INTO xnj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu akamyangula, “Chakaka nikujovela lelu yati tivya na nene kupaladiso.” ");
INSERT INTO xnj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kutumbula saa sita muhi, chitita chikagubika mulima woha mbaka saa tisa, ");
INSERT INTO xnj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na lilanga likakotoka kulangasa na lipazia lelakovikwi mu Nyumba ya Chapanga likapapuka vipandi vivili. ");
INSERT INTO xnj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu akavemba kwa lwami luvaha, “Dadi! Mumawoko gaku nigotola mpungu wangu!” Akadumuka mpungu. ");
INSERT INTO xnj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mkulu wa manjolinjoli yula peagawene gegahumalili, akamulumba Chapanga akajova, “Chakaka mundu uyu avi mbwina!” ");
INSERT INTO xnj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na vandu voha vevakonganiki penapo ndava ya lijambu lenilo pavagawene gegahumalili gala, vakawuya kunyumba zavi, kuni vakujitova nganga cha ngolongondi. ");
INSERT INTO xnj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vankozi vaki voha pamonga na vadala vealongosini nawu kuhuma ku Galilaya, vayimili cha kutali kulola mambu genago. ");
INSERT INTO xnj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kwavi na mundu mmonga liina laki Yosefu, avi mmonga wa vachilongosi wa libanji likulu la Vayawudi. Avi mundu mbwina na kukita geigana Chapanga, ");
INSERT INTO xnj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","mwene nakuyidakilana gevapangili na kugakita vachilongosi vayaki va libanji likulu la Vayawudi. Yosefu avi mkolonjinji wa Alimatei, ndi avi mukulindila kubwela kwa Unkosi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mundu mwenuyo akahamba kwa Pilatu kumuyupa atola higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akayihulusa higa kuhuma pamsalaba, akayitindisila nyula ya msopi na kuvika mulitinda lelahongoliwi pamhana ya litalau, lavi langavikiwa mundu. ");
INSERT INTO xnj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lavi ligono la kutendelekeha, Ligono la Kupumulila ndi latumbukana. ");
INSERT INTO xnj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vadala vevalongosini na Yesu kuhuma ku Galilaya vakamulanda Yosefu na kuliwona litinda na higa ya Yesu cheuvikiwi. ");
INSERT INTO xnj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kangi vakawuya kunyumba, vakatendelekela mahuta geginungalila bwina ga kunyala higa ya Yesu. Ligono la Kupumulila vapumulili ngati malagizu ga Chapanga geampeli Musa chegilagiza. ");
INSERT INTO xnj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ligono la Dominika, lukela hamba kucha, vadala vala vakahamba kulitinda, kuni vagegi mayewani na mahuta gakunungalila gevatendekili. ");
INSERT INTO xnj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vakoli liganga lila libilindwisi patali kuhuma pakuyingila mulitinda. ");
INSERT INTO xnj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hinu, pavayingili mugati, vayiwene lepi higa ya Bambu Yesu. ");
INSERT INTO xnj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pevavi vakona vikangasa ndava ya lijambu lenilo, bahapo vandu vavili vevawalili nyula za kung'asima neju vakahumila papipi yavi. ");
INSERT INTO xnj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Vadala vala vakavya na wogohi, vakagundama pahi. Ndi vandu vala vakavajovela, “Ndava kyani mukumlonda mundu mweavi mumi pagati ya vevafwili? ");
INSERT INTO xnj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Avi lepi apa, ayukili. Muholalela cheavajovili peavi akona ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Yikumgana Mwana wa Mundu awusiwayi pavandu vevakumbudila Chapanga, na vene yati vakumvamba pamsalaba na pa ligono la datu yati iyuka.’ ” ");
INSERT INTO xnj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Penapo vadala vala vakagakumbuka malovi ga Yesu, ");
INSERT INTO xnj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","vakawuya kuhuma kulitinda, vakavajovela vamitumi kumi na mmonga, pamonga na vangi voha, malovi ga mambu ago goha. ");
INSERT INTO xnj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vadala vevabweli kujova mambu genago vavi Maliya mkolonjinji wa Magidala na Yoana na Maliya nyina waki Yakobo pamonga na vadala vangi vevalongosini nawu. ");
INSERT INTO xnj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nambu vamitumi vala vasadiki lepi malovi ga vadala vala, ndava vagahololela ngati uyimu nunuyu. ");
INSERT INTO xnj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nambu Petili, akajumba kuhamba kulitinda, peahikili kulitinda agundimi kulingulila mugati akayiwona ngayene nyula ya msopi. Akawuya kunyumba kuni ikangasa na kujikota gala gegahumili. ");
INSERT INTO xnj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ligono lilolo, vavili pagati ya vamulanda va Yesu vavi mulugendu kuhamba kuchijiji chimonga cha ku Emau chechavi utali wa masaa gavili kuhuma ku Yelusalemu, ");
INSERT INTO xnj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Vavi mukugalongalela mambu goha gegahumalili. ");
INSERT INTO xnj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pavayendelela na malongesi gavi, Yesu mwene akavahumila na kugenda nawu, ");
INSERT INTO xnj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vamuweni kwa mihu gavi, nambu vadindiwi vakotoka kummanya. ");
INSERT INTO xnj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu akavakota, “Mwilongela kyani kuni mwigenda?” Vene vakayima pamihu pavi pakwinyini cha ligoga. ");
INSERT INTO xnj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mmonga wavi liina laki Kileopa, akamyangula, “Wu nga veve myehe wangamanya mambu gegahumalili pa Yelusalemu magono gagaga?” ");
INSERT INTO xnj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu akavakota, “Mambu goki?” Vena vakamuyagula, “Mambu gegamkolili Yesu wa ku Nazaleti.” Mwene avi Mlota mweihotola kuhenga na kuwula palongolo ya vandu voha va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Vakulu va kuteta na vachilongosi vitu vakamgotola na kumuhamula lifwa, vakamvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nambu tete tamsadiki mwene kuvya ndi mweatumwili kuyigombola Isilaeli! Hinu, lelu ndi ligono la datu pagahengiki mambu genago. ");
INSERT INTO xnj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kavili vadala vangi va kwitu vatikenyemwisi, muni vakahambili kulitinda lukela hambakucha, ");
INSERT INTO xnj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nambu nakuyikolela higa ya Yesu. Vakawuya nakutijovela vahumiwi na vamitumu va kunani kwa Chapanga, vevavajovili ngati Yesu akona mumi. ");
INSERT INTO xnj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Vayitu vangi pagati yitu vahambili kulitinda kulola gegajoviwi na vadala vala, nambu nakuyiwona lepi mwene. ");
INSERT INTO xnj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kangi Yesu akavajovela, “Nyenye vayimu na mitima yinu yitopa kusadika gegajoviwi na vamlota va Chapanga! ");
INSERT INTO xnj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wuli, yamganili lepi Kilisitu msangula kung'ahika, kangi ayingilayi muukulu waki?” ");
INSERT INTO xnj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hinu akavadandaulila mambu goha gegamuvala mwene mu Mayandiku Gamsopi kutumbula muhitabu ya Musa mbaka muhitabu ya Vamlota va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pevahegalili na chijiji chevaambayi, Yesu akakita ngati mweiyendelela na lugendu, ");
INSERT INTO xnj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nambu vene vakamjovela, chondi pepayi, “Utamayi pamonga na tete, muni lilanga litipimi chitita chibwela.” Ndi akayingila nawu mugati. ");
INSERT INTO xnj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Peatamili kulya chakuyla pamonga nawu, akalitola libumunda na kumsengusa Chapanga na kulimetula na kuvapela. ");
INSERT INTO xnj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bahapo vakagubukuliwa mihu gavi na kummanya, nambu mwene akayaga pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndi Vakajovesana, “Mitima yitu yasangalwiki neju mugati mwitu peakatidandauli Mayandiku Gamsopi munjila mula?” ");
INSERT INTO xnj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Balapala vakawuka, kuwuya ku Yelusalemu. Kwenuko vakavakolela vamitumi kumi na mmonga na vangi vevavi pamonga na vene vakonganiki, ");
INSERT INTO xnj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","vakajova, “Chakaka Bambu ayukili! Amuhumalili Simoni!” ");
INSERT INTO xnj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hinu vamulanda vavili va Yesu vakavajovela mambu gegavakolili munjila na chevammanyili Yesu pealimetulayi libumunda. ");
INSERT INTO xnj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pevavi mukujovewa genago, Yesu mwene bahapo akayima pagati yavi nakujova, “Uteke uvyayi na nyenye.” ");
INSERT INTO xnj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Vakakenyemuka na kuyogopa neju muni vaholalelayi pangi valiwene lihoka. ");
INSERT INTO xnj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nambu mwene akavajovela, “Ndava kyani mwivagaya? Ndava kyani mwikujikota kota mumitima yinu? ");
INSERT INTO xnj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mlola mawoko na magendelu, muni mumanyayi kuvya ndi nene. Munipamisa mumanya, muni lihoka langali higa amala lijege ngati chemukunilola.” ");
INSERT INTO xnj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Peamali kujova genago, akavalangisa mawoko na magendelu. ");
INSERT INTO xnj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pevavi vakona kusadika, ndava ya luheku uvaha na kukangasa, Yesu akavakota, “Muvinachu chakulya chochoha penapa?” ");
INSERT INTO xnj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Vakampela chipandi cha somba yiyochanu, ");
INSERT INTO xnj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akachitola na kulya kuni woha vakumlola. ");
INSERT INTO xnj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kangi akavajovela, “Genaga ndi malovi genavajovili penakavili na nyenye, muni yaganikwi gahengekayi goha gegayandikiwi kunivala nene mu malagizu ga Musa na muvitabu vya vamlota va Chapanga na Muchitabu cha Zabuli.” ");
INSERT INTO xnj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kangi, penapo akavalangasila luhala lwavi muni vagamanyayi Mayandiku Gamsopi. ");
INSERT INTO xnj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akavajovela, “Gayandikiwi kuvya, Kilisitu msangula yati ing'ahiswa nambu paligono la datu yati iyuka kuhuma pavafwili, ");
INSERT INTO xnj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","yikuvagana mewa vandu va makabila goha, kutumbula ku Yelusalemu vakokoselewayi muliina laki kuleka kumbudila Chapanga. Muni valekekeswa kubuda kwavi. ");
INSERT INTO xnj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nyenye ndi mwemugawene mambu genago. ");
INSERT INTO xnj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Namwene yati nikuvapelekela yula mweavalagazili Dadi wangu, nambu mulindila kumuji mbaka pemumemeswa uhotola kuhuma kunani.” ");
INSERT INTO xnj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kangi Yesu akavalongosa vawuliwa kuvala ya muji wenuwo mbaka ku Betania, akayinula mawoko gaki kunani akavamotisa. ");
INSERT INTO xnj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Peamali kuvamotisa, akavaleka, akatoliwa kuhamba kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Vawuliwa vakamfugamila Yesu, kangi vakawuya pa Yelusalemu, kuni vavi na luheku luvaha, ");
INSERT INTO xnj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Vayendalili kuvya Panyumba ya Chapanga magono goha, vakumulumbalila Chapanga.");
INSERT INTO xnj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Penapo pakutumbula, kwakona vindu vyoha viwumbiki lepi avili mmonga mweakemeliwi Lilovi. Lilovi avili na Chapanga. Mwene avili Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kuhuma kutumbula avili pamonga na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kupitila mwene, Chapanga awumbili vindu vyoha, kawaka chindu hati chimonga chechawumbiki changali mwene. ");
INSERT INTO xnj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mwene ndi chinyepa cha wumi na wumi wene uletili lumuli kwa vandu. ");
INSERT INTO xnj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lumuli lwenulo lulangasa kuchitita, na chene chitita chihotola lepi kulujimisa. ");
INSERT INTO xnj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chapanga amtumili mundu mmonga liina laki Yohani, ");
INSERT INTO xnj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","mwene abweli kuvajovela vandu kuluvala lumuli lwenulo. Abweli muni vandu voha vayuwana na kusadika ujumbi waki. ");
INSERT INTO xnj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohani mwene avi lepi lumuli lwenulo, nambu abweli kuvajovela vandu kuluvala lumuli lwenulo. ");
INSERT INTO xnj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lwenulo ndi lumuli lwa chakaka, lumuli lwelubwela pamulima na kuvalangasila vandu voha. ");
INSERT INTO xnj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hinu, lilovi lila avili pamulima na kupitila mwene Chapanga awumbili mulima, nambu vandu va pamulima wammanyili lepi. ");
INSERT INTO xnj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Abwelili pavandu vaki mwene, nambu vandu vaki vampokili lepi. ");
INSERT INTO xnj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nambu vandu vevampokili, na kumsadika, avapeli uhotola wa kuvya vana va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Vavi vana va Chapanga lepi kwa kuvelekewa ngati vandu chevivelekewa. Amala vavelikwi lepi ngati vandu chevigana, nambu kwa maganu ga Chapanga mwene. ");
INSERT INTO xnj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lilovi lila akavya mundu, akatama kwitu. Ndi tiuwene ukulu waki, ukulu waki mwene nga Mwana wa Dadi Chapanga, amemili ubwina wa Chapanga na uchakaka. ");
INSERT INTO xnj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohani avajovili vandu malovi gaki. Akajova kwa lwami, “Mwenuyu ndi yula mwenamuluwili penajovili, ‘Ibwela mundu mweigelekela pahali pangu mkulu kuliku nene, muni amali kuvya kwakona nene kuvelekewa.’ ” ");
INSERT INTO xnj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ndava cheavili ubwina waki wamahele tete tavoha tipokili mota yamahele. ");
INSERT INTO xnj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chapanga atipeli malagizu kupitila Musa, nambu ubwina wa Chapanga na chakaka utibwelili kupitila Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kawaka mundu mweamuwene Chapanga katu. Nambu nga Mwana waki yuyo mweavi Chapanga na mweaganiwi na Dadi, mwene atimanyisi mambu gaki. ");
INSERT INTO xnj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Genaga ndi malovi Yohani geajovili ndava yaki lukumbi vachilongosi va Vayawudi ku Yelusalemu pevavatumili vamteta va Chapanga na Valawi vamkotayi, “Veve wayani?” ");
INSERT INTO xnj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohani abelili lepi kuyangula likotesi lenilo, nambu akajova hotohoto, “Nene lepi Kilisitu Msangula.” ");
INSERT INTO xnj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kangi vakamkota, “Hinu veve ndi wayani? Wu, veve ndi Eliya?” Yohani akayangula, “Lepi.” Vakamkota kangi, “Veve ndi yula mlota wa Chapanga?” Akavayangula, “Lepi!” ");
INSERT INTO xnj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kangi vakamkota, “Hinu wayani veve? Wijova wuli kukuvala wamwene? Utijovelayi na tete tikavayangula vevatitumili.” ");
INSERT INTO xnj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohani akayangula, nene ndi yula mlota Isaya ajovili malovi gaki, “Nene ndi lwami lwa mundu ikemela kulugangatu. ‘Mgolosayi njila ya Bambu.’ ” ");
INSERT INTO xnj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Vandu avo vatumwili na Vafalisayu, ");
INSERT INTO xnj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","vakamkota Yohani, “Ngati veve lepi Kilisitu Msangula mweahaguliwi na Chapanga, amala Eliya, amala mlota wa Chapanga, ndava kyani wibatiza?” ");
INSERT INTO xnj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohani akavayangula, “Nene nibatiza kwa manji, nambu avi mmonga pagati yinu, mwakona kummanya. ");
INSERT INTO xnj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mweibwela pahali pangu, ndi nene niganikiwa lepi hati kuwopola nyosi za champali zaki.” ");
INSERT INTO xnj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mambu genago gakitiki kumuji wa Betania, kumwambu ya mfuleni Yoludani, Yohani kweavi mukubatiza. ");
INSERT INTO xnj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chilau yaki, Yohani amuwene Yesu akumbwelela akajova, “Lola, mwenuyu ndi Mwana limbelele wa Chapanga, ndi mweiwusa kumbudila Chapanga pamulima! ");
INSERT INTO xnj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ndi mwenamlongalili yula penajovili, ‘Pahali pa nene ibwela mundu mkulu kuliku nene, mwene avili kwakona nene kuvelekewa!’ ");
INSERT INTO xnj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hati namwene nangammanya, nambu nibweli kubatiza na manji muni vandu va Isilaeli vammanyayi.” ");
INSERT INTO xnj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kangi Yohani atijovili gala geagawene, “Namuwene Mpungu Msopi akumuhelelela ngati ngunda kuhuma kunani na kutula panani yaki. ");
INSERT INTO xnj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nene nangammanya, nambu yula mweanitumili kubatiza vandu na manji amali kunijovela, ‘Mundu mweakumlola Mpungu Msopi akumuhelelela kuhuma kunani na kutama panani yaki, ndi mweibatiza na Mpungu Msopi.’ ");
INSERT INTO xnj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kangi Yohani akajova nene nigalolili mambu aga na nikuvajovela uchakaka kuvya mwenuyu ndi Mwana waki Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kangi chilau yaki, Yohani avili pandu penapo, pamonga na vawuliwa vaki vavili. ");
INSERT INTO xnj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Peamuwene Yesu ipita akajova, “Lola! Uyu ndi Mwana Limbelele wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Vawuliwa vavili vala pevayuwini malovi geajovayi Yohani gala vakamlanda Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu ang'anamwiki, avawene vawuliwa vala vakumlanda, akavakota, “Mwilonda kyani?” Vakamkota, “Labi witama koki?” Labi mana yaki Muwula. ");
INSERT INTO xnj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu akavajovela, “Mbwela, na nyenye yati mwilola,” Vawuliwa vala vakamlanda yavili lukumbi lwa saa kumi ya kimihi na vakatama kwaki ligono lenilo. ");
INSERT INTO xnj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andelea, mlongo waki Simoni Petili avi mmonga pagati ya vavili avo vevamyuwini Yohani geajovili, vakamlanda Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andelea akatumbula kumlonda Simoni mlongo waki, akamjovela “Timuwene Msangula.” Ndi kujova “Kilisitu.” ");
INSERT INTO xnj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kangi ampeliki Simoni kwa Yesu. Ndi Yesu akamlolokesa Simoni akajova, “Simoni veve mwana wa Yohani. Hinu yati ukemelewa Kefa,” Kwa Chigiliki ndi Petili, mana yaki “Litalau.” ");
INSERT INTO xnj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chilau yaki Yesu akawuka, kuhamba kumulima wa Galilaya ndi amkolili Filipi, akamjovela “Nilandayi.” ");
INSERT INTO xnj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi mkolonjinji wa ku Betisaida, muji wevitama Andelea na Petili. ");
INSERT INTO xnj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi amkoli Natanyeli, akamjovela, “Timuwene mwene, mweayandikiwi na Musa muchitabu cha malagizu, na vamlota va Chapanga vayandiki mambu gaki, Yesu wa kuhuma kumuji wa Nazaleti mwana wa Yosefu.” ");
INSERT INTO xnj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanyeli akamkota Filipi, “Chindu cha bwina chihotola wuli kuhumila ku Nazaleti?” Mwene akamjovela, “Bwelayi ulole.” ");
INSERT INTO xnj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu peamuwene Natanyeli akumbwelela, akajova, “Lola! Chakaka mwenuyu ndi Mwiisilaeli chakaka, kawaka udese mugati yaki hati padebe.” ");
INSERT INTO xnj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanyeli akamkota Yesu, “Unimanyi wuli?” “Mwene akamyangula, kwakona Filipi angakukemela nakuwene pewavi pahi pa mkongo wa mkuyu.” ");
INSERT INTO xnj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Penapo Natanyeli akamjovela, “Muwula,” Veve ndi Mwana wa Chapanga! “Veve ndi Nkosi wa Isilaeli!” ");
INSERT INTO xnj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu akamjovela usadika ndava nikujovili nakuwene pahi ya mkongo wa mkuyu? Yati ukugawona gavaha neju ya aga. ");
INSERT INTO xnj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ndi akayonjokesa kujova, “Chakaka nikuvajovela, yati mwilola kunani kwa Chapanga kudinduka na vamitumu va kunani kwa Chapanga vikwela na kuhelela panani pa Mwana wa Mundu.” ");
INSERT INTO xnj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ligono la datu kwavi na mselebuko kumuji wa Kana, mulima wa Galilaya, na nyina waki Yesu avili. ");
INSERT INTO xnj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu mewa agongoliwi kumselebuko pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lukumbi divayi payamaliki, nyina waki akamjovela Yesu, “Divayi yimaliki!” ");
INSERT INTO xnj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu akamyangula, “Ukotoka kunijovela cha kuhenga. Lukumbi lwangu lwakona kuhika.” ");
INSERT INTO xnj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kangi, nyina wa Yesu akavajovela vanalihengu, “Chochoha cheakuvajovela, muhengayi.” ");
INSERT INTO xnj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Penapo kwavili na vihulu sita ya kuvikila manji kwenuko, kila umonga weuhotola kumema madebe gavili amala gadatu ga manji. Yeyavikiwi penapo ndava ya mvelu wa Vayawudi kujinyambisa ndava ya kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu akavajovela, “Mumemesa manji muvihulu vyenivyo.” Vakagamemesa mbaka panani. ");
INSERT INTO xnj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kangi akavajovela, “Hinu mnegayi mumpelayi myimilila mselebuko, navene vakampelekela.” ");
INSERT INTO xnj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Myimilila mselebuko peagawonjili manji gala akalola gang'amwiki kuvya divayi. Mwene nakumanya kweyahumili, nambu vala vatumisi vevanegili vamanyili. Myimilila mselebuko amkemili mkolo ndowa, ");
INSERT INTO xnj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akamjovela, “Vandu voha vitendelekela hoti divayi yabwina na vandu vakanywayi neju, ndi vitendelekela yangali makakala yila, hinu veve uyivikili divayi ya bwina mbaka pamwishu!” ");
INSERT INTO xnj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chenicho chavi chinamtiti cha kutumbula cheachikitili Yesu ku Kana, pamulima wa Galilaya. Akalangisa ukulu waki, vawuliwa vaki ndi vakamsadika. ");
INSERT INTO xnj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pegamaliki ago, Yesu akawuka pamonga na nyina waki, na valongo vaki na vawuliwa vaki vahambili ku Kapelanaumu kwavatamili magono gadebe. ");
INSERT INTO xnj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mselebuko wa Vayawudi wewukemelewa Pasaka wavili papipi kuhika, Yesu akahamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hinu avakolili vandu Paluvanja lwa nyumba ya Chapanga, vagulisayi ng'ombi mambelele na ngunda, na vabadilisa mashonga vatamili mumeza zavi. ");
INSERT INTO xnj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndi akabota mchapilu wa nyosi akavavinga voha kuvala ya Nyumba ya Chapanga vene pamonga na ng'ombi na mambelele gavi, kangi akapechengana mashonga gavi akazibilindusa meza zavi. ");
INSERT INTO xnj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akavajovela vevagulisa ngunda vala, “Muwusa vindu vyenivi. Mkotokayi kukita nyumba ya Dadi wangu kuvya pandu pa kugulisa na kugula vindu!” ");
INSERT INTO xnj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vawuliwa vaki vakumbwiki kuvya Mayandiku Gamsopi gijova “Mwe! Chapanga uganu wangu kwa nyumba yaku ukunitinyisa mugati yangu ngati motu.” ");
INSERT INTO xnj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Vayawudi vangi vakamkota Yesu, “Wu, ulangisu woki yati wikita kulangisa una uhotola wa kukita genago?” ");
INSERT INTO xnj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akavayangula, “Mgwisa Nyumba Chapanga iyi, na nene yati nijenga kangi mu magono gadatu.” ");
INSERT INTO xnj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Penapo Vayawudi vamkotili, “Wihotola wuli kujenga mu magono gadatu? Ndava nyumba ya Chapanga iyi yijengiwi mulukumbi lwa miyaka alobaini na sita!” ");
INSERT INTO xnj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nambu Nyumba ya Chapanga Yesu yeailongelelayi ndi higa yaki. ");
INSERT INTO xnj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hinu, peayukisiwi, vawuliwa vaki vakumbwiki kuvya ajovili ago, vakagasadika Mayandiku Gamsopi na malovi Yesu geavajovili. ");
INSERT INTO xnj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu peavi ku Yelusalemu kumselebuko wa Pasaka, vandu vamahele vamsadiki pavauwene ulangisu weavakitili. ");
INSERT INTO xnj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nambu Yesu avasadiki lepi vandu avo muni avamanyili voha. ");
INSERT INTO xnj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aganili lepi kujovewa chochoha ndava ya vandu, muni mwene agamanyili bwina mambu gegavi mumitima yavi. ");
INSERT INTO xnj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kwavi na chilongosi mmonga Myawudi wa chikundi cha Vafalisayu, liina laki Nikodemu. ");
INSERT INTO xnj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ligono limonga kimihi Nikodemu amhambalili Yesu akamjovela, “Muwula, tikumanyii ngati veve muwula mweutumwili kuhuma kwa Chapanga, muni kawaka mundu mweihotola kukita ulangisu weukita changali kuvya na Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu akamjovela, “Chakaka nikujovela, mundu ngati avelekiwi lepi kavili ihotola lepi kulola Unkosi wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu akamkota, “Wu, mundu mvaha yihotoleka kuvelekewa kavili? Yihotoleka lepi kuyingila mulileme la nyina waki na kuvelekewa kavili.” ");
INSERT INTO xnj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu akamyangula, “Chakaka nikukujovela,” Mundu ngati avelekiwi lepi kwa manji na kwa Mpungu Msopi katu nakuhotola kuyingila mu Unkosi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundu ivelekewa chihiga kwa dadi na mau, nambu ivelekewa chimpungu kwa Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ukotoka kukangacha kuvya nijovili yikumgana mundu kuvelekewa kavili. ");
INSERT INTO xnj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Chimbungululu chibuma, kuhamba kwechigana wiyuwana chibuma, nambu wimanya lepi kwe chihuma amala kwe chihamba. Mewawa kwa kila mundu mweavelekiwi kwa Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu akamkota, “Mambu genaga gihotoleka wuli?” ");
INSERT INTO xnj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akamyangula, “Veve muwula wa vandu va Isilaeli nakugamanya mambu aga? ");
INSERT INTO xnj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chakaka nikujovela, tete tijova getikugamanya na tikuvajovela vandu vindu vyetiviwene, nambu nyenye nakuyidakila ujumbi witu. ");
INSERT INTO xnj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nivajovili mambu ga pamulima nakusadika, hinu mwihotola wuli kusadika nikavajovela mambu ga kunani kwa Chapanga? ");
INSERT INTO xnj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kawaka mundu mwahambili kunani kwa Chapanga, nambu Mwana wa Mundu ndi mweahelili kuhuma kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngati Musa cheanyakwili Liyoka la Shaba panani ya ndonga kulugangatu kula, mewa na Mwana wa Mundu yati inyakuliwa kunani, ");
INSERT INTO xnj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","muni kila mundu mweakumsadika yati ivya na wumi wa magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Muni Chapanga avaganili neju vandu va mulima hati amuwusili Mwana waki ngamwene yuyo, muni yoyoha mwaisadika akotoka kuyaga ndi avyayi na wumi wa magono goha. ");
INSERT INTO xnj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chapanga amtumili lepi Mwana waki pamulima ndava ya kuvahamula vandu, nambu kuvasangula. ");
INSERT INTO xnj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mweakumsadika Mwana ihamuliwa lepi, nambu mwangamsadika amali kuhamuliwa, ndava amsadiki lepi, nga Mwana yuyo wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na uhamula wene ndi uwu, lumuli lubwelili pamulima nambu vandu vaganili chitita kuliku lumuli, muni matendu gavi gahakau. ");
INSERT INTO xnj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mundu yoyoha mweikita gahakau angalugana lumuli, mewa ibwela lepi kulumuli, muni igana lepi matendu gaki gahakau galangalayi. ");
INSERT INTO xnj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nambu mundu yeyoha mweilanda gachakaka ibwela kulumuli muni matendu gaki galolekanayi, gahengiki kwa kumyidakila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pegamaliki genago, Yesu na vawuliwa vaki vakahamba kumulima wa Yudea, akatama navu kwenuko na kubatiza vandu. ");
INSERT INTO xnj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mewawa Yohani avi mukubatiza vandu ku Ainoni, papipi na ku Salemu, muni kwenuko kwavi na manji gamahele vandu vamhambalili, mwene akavabatiza. ");
INSERT INTO xnj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Genaga gahumalili lukumbi Yohani peavi angasopewa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ukahumila muhutanu pagati ya vawuliwa va Yohani na myawudi mmonga ndava ya mvelu wa kunyambiswa ndava ya kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hinu, vawuliwa avo vakamhambila Yohani na kumjovela “Muwula mundu yula mwewavili nayu kumwambu ya Yoludani, yula veve mwewatijovili malovi gaki, hinu namwene ibatiza na vandu voha vakumlanda!” ");
INSERT INTO xnj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohani akavayangula, “Mundu ihotola lepi kuvya na chindu ngati angapewa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nyenye mwavene mumanyili kuvya najovili, ‘Nene lepi Kilisitu Msangula, nambu natumiwi nimlongolela.’ ");
INSERT INTO xnj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mdala wa ndowa ndi waki mkolo ndowa, nambu nkozi wa mkolo ndowa mweiyima kumyuwanila iheka neju kuyuwana mkolo ndowa ijova. Mewa nene nisangalwiki neju. ");
INSERT INTO xnj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesu yikumgana avyayi mkulu na nene nivyayi namdebe.” ");
INSERT INTO xnj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mweibwela kuhuma kunani kwa Chapanga ndi mkulu kuliku voha, mweihuma pamulima ndi wa pamulima, na ilongela mambu ga pamulima. Nambu mweibwela kuhuma kunani ndi ilongosa vindu vyoha. ");
INSERT INTO xnj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mwene ijova gala geagawene na kuyuwana, nambu kawaka mundu mweiyidakila ujumbi waki. ");
INSERT INTO xnj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nambu mundu yoyoha mweiyidakila ujumbi waki ndi ijova Chapanga ndi mchakaka. ");
INSERT INTO xnj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ndava yula mweatumwili na Chapanga ijova malovi ga Chapanga, ndava Chapanga ammemisi mundu mwenuyo Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dadi amganili Mwana na amgotolili vindu vyoha. ");
INSERT INTO xnj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mweakumsadika Mwana avi na wumi wa magono goha gangali mwishu, nambu angamsadika Mwana avi lepi na wumi, nambu ligoga la Chapanga likumtamila. ");
INSERT INTO xnj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Vafalisayu vayuwini kuvya Yesu avi mukupata vawuliwa vamahele na kuvabatiza kuliku Yohani. ");
INSERT INTO xnj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ndi chakaka kuvya Yesu mwene abatiza lepi, nambu vawuliwa vaki ndi vevabatizayi vandu. ");
INSERT INTO xnj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hinu Yesu peagayuwini genago, akawuka ku Yudea na kuwuya ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mulugendu lwenulo yamganili kuvedukila kumulima wa Samaliya. ");
INSERT INTO xnj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ndi peahikili muji umonga pamulima wa Samaliya weukemiwa Sikali, papipi na mgunda wa Yakobo weampelilli mwana waki, mweikemiwa Yosefu. ");
INSERT INTO xnj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pandu penapo pavi na chiliva cha Yakobo, na Yesu ndava ya kutotokela na lugendu, akatama pamuhana ya chiliva. Yavili ngati lukumbi lwa muhi. ");
INSERT INTO xnj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kangi, akabwela mdala mmonga mkolonjinji wa ku Samaliya kunega manji. Yesu akamjovela, “Nipelayi manji ninywayi.” ");
INSERT INTO xnj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Lukumbi lwenulo vawuliwa vaki vahambili kumuji kugula chakulya. ");
INSERT INTO xnj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nambu mdala yula akamjovela, “Veve wa Myawudi, na nene namdala msamaliya! Uhotola wuli kuniyupa manji?” Muni Vayawudi na Vasamaliya katu vitama lepi pamonga. ");
INSERT INTO xnj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akamyangula, “Ngati kuvya umanyayi chindu chechiwusiwa na Chapanga ndi yani mweakukujovela, ‘nipelayi manji ninywai,’ Ngawamali, kumuyupa manji gegileta wumi.” ");
INSERT INTO xnj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mdala yula akamjovela, “Bambu, veve wangali ndeve ya kunegela manji, na chiliva chinyoliki. Ugapata koki manji gegavi na wumi? ");
INSERT INTO xnj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wu, veve ukujikita wa mkulu kuliku dadi witu Yakobo? Mwene ndi mweatipelili chiliva ichi, mwene na vana vaki pamonga na mifuya yaki vanywayi manji ga chiliva ichi.” ");
INSERT INTO xnj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akamyangula, “Yoyoha mweinywa manji aga yati ivya na njota kavili. ");
INSERT INTO xnj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nambu yoyoha mweinywa manji gala genikumpela nene, katu ivya lepi na njota magono goha. Manji genikumpela givya mugati yaki ngati chinyepa cha manji ga wumi na kumpela wumi wa magono goha gangali mwishu.” ");
INSERT INTO xnj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mdala mwenuyo akamjovela, “Bambu, unipela manji genago muni nikotoka kuvya na njota kavili na nikotoka kubwela penapa kunega manji.” ");
INSERT INTO xnj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu akamjovela, “Uhamba ukamkemela mngwana waku, ubwela nayu penapa.” ");
INSERT INTO xnj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mdala yula akayangula, “Nene nangali mgosi.” Yesu akamjovela “Uyangwili chakaka, wangali mgosi. ");
INSERT INTO xnj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Muni wavi na vagosi mhanu, na mgosi mweutama nayu hinu mgosi waku lepi. Penapo ujovili chakaka.” ");
INSERT INTO xnj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mdala yula akamjovela, “Bambu, niwona kuvya veve wa mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Vagogo vitu vamufugamila Chapanga kuchitumbi ichi, nambu nyenye mwijova kuvya pandu pa kumuyupila Chapanga ndi ku Yelusalemu.” ");
INSERT INTO xnj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu akamjovela “Unisadika chenijova lwalabwela lukumbi nakumfugamila Dadi, panani ya chitumbi amala ku Yelusalemu kula. ");
INSERT INTO xnj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nyenye Vasamaliya mukumfugamila yula mwangammanya, nambu tete tikumfugamila yula mwetimumanyili, ndava muni usangula wihuma kwa Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nambu lukumbi lubwela, kangi lumali kubwela ndi vala vandu vevakumfugamila kwa uchakaka, yati vamfugamila Dadi mukulongoswa na Mpungu Msopi na chakaka. Muni dadi akuvagana vandu vamfugamila chenicho. ");
INSERT INTO xnj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chapanga ndi Mpungu na vandu vevamfugamila yikuvagana vamfugamila Dadi mukulongoswa na Mpungu Msopi na kuumanya uchakaka.” ");
INSERT INTO xnj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mdala yula akamjovela, “Nimanyili kuvya Msangula mweikemiwa Kilisitu ibwela. Peibwela yati akutimanyisa tete kila chindu.” ");
INSERT INTO xnj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu akamjovela, “Nene mwenilongela na veve ndi mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bahapo vawuliwa vaki vakawuya, na kukangasa neju pavamuweni ilongela na mdala. Nambu kawaka mundu mweajovili, “Ugana kyani?” Amala, “Ndava kyani wilongela na mdala?” ");
INSERT INTO xnj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hinu, mdala yula akachileka chihulu chaki palapala na kuhamba kumuji na kuvajovela vandu, ");
INSERT INTO xnj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mbwela mukamlola mundu mweanijovili mambu goha genikitili! Wu, yihotoleka kuvya ndi Kilisitu Msangula?” ");
INSERT INTO xnj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Vandu vakawuka kumuji na kumuhambila Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lukumbi lwenulo vawuliwa vaki vamyupili neju Yesu, “Muwula, ulyayi chakulya.” ");
INSERT INTO xnj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nambu Yesu akavajovela, “Nene nivii nachu chakulya chemwangachimanya nyenye.” ");
INSERT INTO xnj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Vawuliwa vaki vakakotana vene kwa vene, “Wu, avi mundu mweamletili chakulya?” ");
INSERT INTO xnj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu akavajovela, “Chakulya changu ndi kuhenga geigana yula mweanitumili na kumalakisa lihengu laki. ");
INSERT INTO xnj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nyenye mwijova, ‘Yakona miheyi mcheche ndu na lukumbi lwa kubena yati lubwela!’ Nambu nene nikuvajovela, myinula mihu ginu mlola migunda, mabenu gakangili giganikiwa kubenwa! ");
INSERT INTO xnj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yula mweibena ipokela luhuna lweluganikiwa kupewa kwa lihengu laki, na kuyola mabenu ndava ya wumi wa magono goha wangali mwishu, muni mweimija na mbenaji vihekelela pamonga. ");
INSERT INTO xnj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vandu pevijova kuvya ‘Mundu mmonga imija na mundu yungi ibena, luhumu ulu ndi chakaka.’ ");
INSERT INTO xnj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nene navatumili nyenye mkabena changali lihengu, vangi vahengili lihengu, nambu nyenye mupatili utangatila ndava ya lihengu lavi.” ");
INSERT INTO xnj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Vasamaliya vamahele pachijiji chila vamsadiki Yesu ndava ya malovi geajovili mau yula, “Anijovili mambu goha genihengili.” ");
INSERT INTO xnj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Vasamaliya vamhambili Yesu vakamuyupa neju atama navu, namwene akatama navu magono gavili. ");
INSERT INTO xnj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Vandu vamahele, vamsadiki Yesu ndava ya malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Vakamjovela mdala yula, “Tete tisadika, nambu lepi ndava ya malovi gaku, muni tavete tiyuwini na timanyili kuvya mwenuyu ndi chakaka Msangula wa vandu va pamulima.” ");
INSERT INTO xnj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagamaliki magono gavili, Yesu akawuka penapo, akahamba ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Muni Yesu mwene ajovili hotohoto kuvya, “Mlota wa Chapanga nakuyidakiliwa pamulima waki.” ");
INSERT INTO xnj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hinu peahikili ku Galilaya, Vagalilaya vamahele vampokili. Ndava vagawene goha geahengili ku Yelusalemu, muni navene vavi kukoko kumselebuko wa Pasaka. ");
INSERT INTO xnj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kangi Yesu ahikili kavili ku Kana, kumuji wa Galilaya, pandu peang'anamwisi manji kuvya divayi. Kwenuko kwavi na chilongosi mmonga wa chinkosi mweavi na mwana waki mtamu ku Kapelanaumu. ");
INSERT INTO xnj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chilongosi yula peayuwini kuvya Yesu ahumili ku Yudea na kuhika ku Galilaya, akamhambila na kumuyupa ahamba akamlamisa mwana waki mweavi mulung'olelu. ");
INSERT INTO xnj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu akamjovela, “Nyenye changalola ulangisu na gachinamtiti katu mwisadika lepi!” ");
INSERT INTO xnj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yula chilongosi akamjovela, “Bambu, chondi tihamba kwakona mwana vangu kufwa.” ");
INSERT INTO xnj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akamjovela, “Uhambayi, mwana waku yati ilama.” Mundu yula akasadika malovi ga Yesu, akahamba. ");
INSERT INTO xnj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Peavi akona munjila akakonganeka na vatumisi vaki, vakamjovela kuvya mwana waku alamili! ");
INSERT INTO xnj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mwene akavakota lukumbi msongolo pealamili, vene vakamyangula, “Golo saa saba ya muhi, utamu wamuhumili.” ");
INSERT INTO xnj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dadi yula akamanya kuvya lwavi lukumbi lulolo, Yesu peamjovili “Mwana waku yati ilama.” Penapo mwene pamonga na valongo vaki vakamsadika Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wenuwu wavi ulangisu wa kukangasa weahengili Yesu peawukili ku Yudea kuhamba ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pegamaliki genago, Yesu ahambili ku Yelusalemu kumselebuko wungi wa Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kula ku Yelusalemu, papipi na mlyangu uvaha wa mambelele, kwavi na litanda lelikemelewa kwa Chiebulania Betizata, lelavi na mabanji mhanu gajengiwi kulitindila. ");
INSERT INTO xnj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mu mabanji genago kwavi na vatamu vamahele vatamili, vangalola na vevagogodili higa na vevapoli higa. ");
INSERT INTO xnj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Valindilayi manji gatimbuganayi, muni luvi lukumbi, mtumu wa kunani kwa Chapanga ihelela na kuyingila mulitanda na kugatimbugana manji. Mundu mweatumbwili kuyingila mumanji pegamali kutimbugana, ndi alamili utamu wowoha wula weavi nawu. ");
INSERT INTO xnj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Penapo pavi na mundu mmonga mweapoli higa kwa miyaka selasini na nane. ");
INSERT INTO xnj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu peamuwene mundu yula agonili na kuni imanya kuvya ilwala kwa magono gamahele, akamkota “Wu, ugana kulama?” ");
INSERT INTO xnj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mwene akamyangula, “Bambu, nene nangali mundu wa kuniyingisa mulitanda lukumbi manji pegitimbuliwa. Penilinga kuyingila ndi mundu yungi akunilongolela.” ");
INSERT INTO xnj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu akamjovela, “Yimuka, tola lusongwani lwaku ugenda.” ");
INSERT INTO xnj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bahapo mundu yula akalama, akatola mpasa waki na kugenda. Lijambu lenili lakitiki pa Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hinu vachilongosi va Vayawudi vakamjovela mundu yula mwealamili, “Lelu ndi Ligono la Kupumulila, malagizu gibesa veve kugega mpasa waku.” ");
INSERT INTO xnj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nambu mwene akavayangula, “Mundu mweanilamisi ndi mweanijovili tola mpasa waku, ugendayi.” ");
INSERT INTO xnj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Vene vakamkota, “Wu, mundu mwenuyo mweakujovili, utola lusongwani lwaku ugendayi, ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nambu mundu yula mwealamiswi nakummanya Yesu kuvya ndi yani, muni Yesu amali kuwuka na kwavi na vandu vamahele vavi penapo. ");
INSERT INTO xnj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ndi mwanakandahi Yesu akamkolela mundu yula Munyumba ya Chapanga, akamjovela “Hinu, ulamili ukotoka kukita gahakau kavili, likoto kukukamula lijambu lihakau neju.” ");
INSERT INTO xnj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu yula akawuka na kuhamba kuvajovela vachilongosi va Vayawudi kuvya, yula mweamlamisi ndi Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ndava muni Vayawudi vakatumbula kumung'aha Yesu ndava akitili lijambu lenilo Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu akavayangula, “Dadi wangu ihenga lihengu kila ligono na nene niganikiwa nihenga lihengu.” ");
INSERT INTO xnj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndava ya malovi genago, vachilongosi va Vayawudi vayonjokisi kulonda mpangu wa kumkoma Yesu lepi ndava ya kudenya Malagizu ga Ligono la Kupumulila ndu, nambu mewa ndava ya kujova Chapanga ndi Dadi waki, muni ajovili mwene na Chapanga vamonga. ");
INSERT INTO xnj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu akavajovela, chakaka nikuvajovela, Mwana nakuhotola kukita chindu chochoha mwene, ihotola kukita chila cheachiwene kuvya Dadi waki ikita. Muni chila cheachikita Dadi na Mwana achikita chichocho. ");
INSERT INTO xnj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dadi akumgana Mwana, ndi akumlangisa kila chindu cheikita mwene, kangi yati amlangisa mambu gakulu kuliku aga na nyenye yati mwikangasa. ");
INSERT INTO xnj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngati cheakuvayusa vevafwili na kuvapela wumi, mewawa Mwana akuvapela wumi vala veakuvagana. ");
INSERT INTO xnj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dadi akumhamula lepi mundu yoyoha, lihengu loha la kuhamula vandu amgotolili Mwana. ");
INSERT INTO xnj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Muni vandu voha vamtopesa Mwana ngati chevakumtopesa Dadi. Angamtopesa Mwana akumtopesa lepi Dadi mweamtumili. ");
INSERT INTO xnj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Chakaka nikuvajovela, mweakugayuwana malovi gangu na kumsadika yula mweanitumili yati ivya na wumi wa magono goha. Katu ihamuliwa lepi, ndi amali kukupuka mulifwa na kuyingila muwumi. ");
INSERT INTO xnj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chakaka nikuvajovela lukumbi lubwela, ndi lumali kubwela vevafwili yati vakugayuwana malovi ga Mwana wa Chapanga, vene vevakugayuwana, yati vivya na wumi. ");
INSERT INTO xnj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Muni ngati mewa Dadi cheavili kutumbula kwa wumi. Mewawa ampeli mwana kuvya mtumbula wa wumi. ");
INSERT INTO xnj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kangi ampeli uhotola wa kuhamula ndava mwene ndi Mwana wa Mundu. ");
INSERT INTO xnj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mkoto kukangaswa kuyuwana malovi aga, muni lukumbi lubwela ndava ya vandu voha vevafwili yati viyuwana malovi gaki, ");
INSERT INTO xnj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","vene yati viyuka, vevahengili gabwina yati viyuka na kuvya na wumi. Na vala vevahengili matendu gahakau yati viyuka na kuhamuliwa. ");
INSERT INTO xnj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nene nakuhotola kukita chindu kwa uhotola wangu namwene. Nene nihamula ngati cheniyuwana kuhuma kwa Dadi, na uhamula wangu ndi wa chakaka. Maganu gangu lepi kukita chenigana nanwene nambu cheigana yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ngati nijova mambu gangu namwene, malovi gangu gihotola lepi kuyidakiliwa kuvya ga chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nambu avi yungi mweijova ndava ya nene, na nene nimanyili kuvya goha geijova ndava yangu ndi gachakaka. ");
INSERT INTO xnj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nyenye mwatumili ujumbi kwa Yohani Mbatizaji mwene ajovili gachakaka ndava ya nene. ");
INSERT INTO xnj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nene nihuvalila lepi vandu vangi vajova ndava yangu, nambu nijova mambu genago muni nyenye msanguliwayi. ");
INSERT INTO xnj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohani avili ngati hahi yeyiyaka na kulangasa, na nyenye mwahagwili kusangalukila lumuli lwenulo mulukumbi luhupi. ");
INSERT INTO xnj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nambu malovi gevijova vandu ndava yangu ndi gakulu neju kuliku gala gevijova kumvala Yohani. Muni malovi genikugahenga ndi anipelili Dadi nimala kuhenga, ndi gilangisa hotohoto kuvya Dadi ndi mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Dadi mweanitumili mewawa ijova ndava yangu. Nyenye katu nakuyuwana Chapanga kwa makutu ginu amala kupalola pamihu paki, ");
INSERT INTO xnj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ujumbi waki wangatama, mumitima yinu ndava mukumsadika lepi yula mweamtumili. ");
INSERT INTO xnj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nyenye mukugalola neju Mayandiku Gamsopi mwihololela kuvya mugati yaki mwipata wumi wa magono goha wangali mwishu, na kumbi mayandiku gagago gijova ndava yangu. ");
INSERT INTO xnj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nambu nyenye mwibela kubwela kwangu muni mupokela wumi wa magono goha. ");
INSERT INTO xnj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nene nilonda lepi kulumbiwa na vandu. ");
INSERT INTO xnj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nambu nivamanyili nyenye, nimanyili kuvya uganu wa Chapanga uvili lepi mumitima hinu. ");
INSERT INTO xnj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nene nibweli ndava ya uhotola wa Dadi wangu, nambu munipokili lepi, nambu mundu yungi akabwelayi kwa uhotola waki mwene yati mukumpokela. ");
INSERT INTO xnj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Muhotola wuli, kusadika kuni nyenye mwigana kulumbilana nyenye mwavene nambu mukuulonda lepi ukulu kuhuma kwa mwene mweavi Chapanga? ");
INSERT INTO xnj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mkotoka kuholalela kuvya nene nikuvatakila kwa Dadi. Musa mwemukumuhuvalila ndi mweakuvatakila. ");
INSERT INTO xnj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ngati chakaka kuvya mukumusadiki Musa, ngamunisadiki na nene mewawa, muni Musa ayandiki malovi gegakunivala nene. ");
INSERT INTO xnj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nambu yikavyayi mwisadika lepi gala geagayandiki, muhotola wuli, kusadika genijova?” ");
INSERT INTO xnj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pegamaliki genago, Yesu akakupuka Nyanja Galilaya yikemelewa mewa Nyanja Tibelia. ");
INSERT INTO xnj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Msambi uvaha wa vandu wamlandili Yesu, ndava vayiwene milangisu ya chinamtiti yeavakitili kuvalamisa vatamu. ");
INSERT INTO xnj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu akakwela kuchitumbi, akatama kwenuko pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lukumbi lwa mselebuko wa Vayawudi wewikemelewa Pasaka wavili papipi. ");
INSERT INTO xnj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hinu, Yesu pealolokisi auwene msambi uvaha wa vandu ukumbwelela ndi akamjovela Filipi, “Wu, tikagula koki mabumunda muni vandu ava valyayi?” ");
INSERT INTO xnj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ajovili genago kwa kumlinga Filipi, mwene amali kumanya chakuhenga. ");
INSERT INTO xnj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi akamyangula “Mabumunda ga kugula kwa hipandi miya zivili ya madini ga feza gikola lepi kwa vandu ava hati ngati kila mmonga akapewayi chipandi chidebe ndu!” ");
INSERT INTO xnj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mmonga wa vawuliwa vaki liina laki Andelea, mlongo waki Simoni Petili akamjovela. ");
INSERT INTO xnj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Penapa avi msongolo mmonga ana mabumunda mhanu ga shayili na somba zivili, nambu zikola kiki kwa vandu vamahele ngati ava?” ");
INSERT INTO xnj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu akajova “Muvatamika vandu.” Pandu penapo pavi na manyahi gamahele. Hinu, vandu vakatama na jumula vavi vagosi ndu vandu elufu mhanu. ");
INSERT INTO xnj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu akatola mabumunda gala na kumsengusa Chapanga, akalagiza vavagavanisila vandu vevatamili, akakita mewawa na somba zila, kila mundu apewili cheaganili. ");
INSERT INTO xnj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Vandu pavayukwiti Yesu akavajovela vawuliwa vaki, “Vakanonga hipandi yehisigalili vikoto kuyaga.” ");
INSERT INTO xnj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hinu, vakayola hipandi ya mabumunda ga shayili yeyasigalili vandu pevamali kulya, ndi vakamemesa madengu kumi na gavili. ");
INSERT INTO xnj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Vandu pavauwene ulangisu wenuwo weahengili Yesu, vakajova “Chakaka mwenuyu ndi mlota mwealongaliwi kuvya ibwela pamulima!” ");
INSERT INTO xnj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kangi Yesu amanyili kuvya vandu vaganili kumkamula na kumvika avyai nkosi, akajibagula navu, akahamba mwene kuchitumbi. ");
INSERT INTO xnj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hati peyahikili kimihi vawuliwa va Yesu vakahelela mbaka kunyanja. ");
INSERT INTO xnj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vakayingila muwatu muni vakupuka kuhamba ku Kapelanaumu. Chitita chamali kuhika, na Yesu avi akona kuvahikila. ");
INSERT INTO xnj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chimbungululu chivaha chabumai ndi Nyanja yikatumbula kutimbugana. ");
INSERT INTO xnj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Vawuliwa vaki vamali kugenda muutali wa kilomita mhanu amala sita, vamuwene Yesu igenda panani ya manji, ihegelela muwatu, vayogwipi neju. ");
INSERT INTO xnj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu akavajovela, “Ndi nene, mkotoka kuyogopa!” ");
INSERT INTO xnj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hinu, vene kwa luheku vakamtola Yesu muwatu, na bahapo watu wula ukahika pandumba pandu pevahambayi. ");
INSERT INTO xnj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chilau yaki msambi wa vandu vevasigalili mwambu ya nyanja vamanyili kuvya kwavi na watu umonga pala. Na vamanyili kuvya Yesu ayingili lepi muwatu pamonga na vawuliwa vaki, muni vawuliwa vaki vahambili vene. ");
INSERT INTO xnj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Watu zingi kuhuma ku Tibelia zabweli papipi na pandu pala msambi wa vandu pevalili mabumunda, Bambu peamali kumsengusa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hinu, vandu vala pevamanyili kuvya Yesu pamonga na vawuliwa vaki vangavya pandu penapo, vakayingila muwatu, kuhamba ku Kapelanaumu kumlonda. ");
INSERT INTO xnj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pevamkolili Yesu mwambu ya nyanja vakamkota, “Muwula, wabweli ndali penapa?” ");
INSERT INTO xnj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu akavayangula, “Chakaka nikuvajovela nyenye mukunilonda lepi ndava mwauwene ulangisu wa kukangasa, nambu ndava muni mwalili mabumunda gala na kuyukuta. ");
INSERT INTO xnj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mkoto kuchihengela lihengu chukulya chechilula, nambu mchihengela chakulya changalula ndava ya wumi wa magono goha wangali mwishu. Mwana wa Mundu mwahaguliwi na kuyidakiliwa na Dadi yati akuvapela chakulya chenicho.” ");
INSERT INTO xnj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Vene vakamkota, “Tikita wuli muni tihotola kuhenga mahengu geigana Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akavayangula, “Lenili ndi lihengu leigana Chapanga muhengayi, kumsadika yula mweamtumili.” ");
INSERT INTO xnj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Penapo vakamkota, “Wu, yati wikita ulangisu woki wa kukangasa muni tiulola tihotola kukusadika? ");
INSERT INTO xnj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vagogo vitu valili mana kula kulugangatu, ngati chegijova Mayandiku Gamsopi. ‘Avapelili mabumunda kuhuma kunani kwa Chapanga muni valyayi.’ ” ");
INSERT INTO xnj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu akavajovela, “Chakaka nikuvajovela, lepi Musa mweavapeli libumunda kuhuma kunani kwa Chapanga, ndi Dadi wangu mweavapelili nyenye libumunda la chakaka kuhuma kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Muni libumunda la Chapanga ndi yula mweihelela kuhuma kunani kwa Chapanga na kuvapela wumi vandu va mulima.” ");
INSERT INTO xnj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Vakamjovela, “Bambu, kila ligono utipelayi libumunda lenilo.” ");
INSERT INTO xnj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu akavajovela, “Nene ndi chakulya chechileta wumi. Mweibwela kwa nene njala yikumvina lepi, mweakunisadika katu iyuwana lepi njota. ");
INSERT INTO xnj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nambu navajovili kuvya yati mukunilola nambu mukunisadika lepi. ");
INSERT INTO xnj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Voha veakunipela Dadi yati vibwela kwa nene, na nene katu nakumtaga kuvala yeyoha mweibwela kwa nene. ");
INSERT INTO xnj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nihelili kuhuma kunani kwa Chapanga, lepi kwa kuhenga genigana namwene nambu kuhenga gegiganikiwa na yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Maganu ga yula mweanitumili ndi aga, nikotoka kumyagisa hati mmonga wa vala veanipelili nambu nivayukisa voha pa ligono la mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Muni cheigana Dadi wangu ndi chenichi, yoyoha mweakumlola Mwana na kumsadika avyayi na wumi wa magono goha, na nene yati nikumuyukisa ligono la mwishu.” ");
INSERT INTO xnj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Vayawudi vakatumbula kung'ung'uta muni ajovili, “Nene ndi libumunda lelihelili kuhuma kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Vakajova, “Mwenuyu lepi Yesu, mwana wa Yosefu? Tivamanyili dadi na nyina waki! Hinu ihotola wuli kujova kuvya ahelili kuhuma kunani kwa Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu akavayangula, “Mkotoka kung'ung'uta mwavene. ");
INSERT INTO xnj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kawaka mundu mweihotola kubwela kwa nene, ngati Dadi mweanitumili amhutili lepi kwa nene, na nene yati nikumuyukisa mundu mwenuyo ligono la mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vamlota va Chapanga vayandiki, ‘Vandu voha yati viwuliwa na Chapanga.’ Kila mundu mweakumyuwana Dadi na kujiwula kuhuma kwaki, ibwela kwa nene. ");
INSERT INTO xnj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Chenijova ndi ichi avi lepi mundu mweamuwene Dadi, nga yula mweahumili kwa Chapanga, mwenuyo ndi mweamuwene Dadi. ");
INSERT INTO xnj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chakaka, nikuvajovela mweisadika avi na wumi wa magono goha wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nene ndi chakulya chechileta wumi. ");
INSERT INTO xnj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Vagogo vinu valili chakulya chechikemiwa mana kulugangatu, nambu vafwili. ");
INSERT INTO xnj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nambu chenichi ndi chakulya chechihelili kuhuma kunani kwa Chapanga muni mweilya ifwa lepi. ");
INSERT INTO xnj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nene ndi chakulya cha wumi chechihelili kuhuma kunani kwa Chapanga. Mundu yeyoha akalyayi libumunda lenili ilama magono goha gangali mwishu. Na libumunda lenikumpela ndi higa yangu yenikuyiwusa ndava ya wumi wa vandu va mulima.” ");
INSERT INTO xnj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Vayawudi vakatumbula kujovesana vene kwa vene, “Mwe, mundu uyu ihotola wuli kutipela tete higa yaki tilyayi?” ");
INSERT INTO xnj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu akavajovela, “Chakaka nikuvajovela, mweangalya higa ya Mwana wa Mundu na kuyinywa ngasi yaki, mwivya lepi na wumi mugati yinu. ");
INSERT INTO xnj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mweilya higa yangu na kunywa ngasi yangu avinawu wumi wa magono goha wangali mwishu, na nene yati nikumuyukisa ligono la mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Muni higa yangu ndi chakulya cha chakaka, na ngasi yangu chindu cha kunywa cha chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mweilya higa yangu na kunywa ngasi yangu, itama mugati yangu na nene nitama mugati yaki. ");
INSERT INTO xnj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ngati Dadi cheavili mumi, anitumili nene na nene nina wumi kwa ndava yaki, mewawa mweakunilya nene yati ivya mumi ndava ya nene. ");
INSERT INTO xnj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hinu, lenili ndi libumunda leliulwiki kuhuma kunani kwa Chapanga, lepi ngati mana yevalili vagogo vitu, vafwili. Mweilya chakulya chenichi yati ivya na wumi wa magono goha wangali mwishu.” ");
INSERT INTO xnj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu ajovili genago peavili akuvawula munyumba ya kukonganekela Vayawudi ku Kapelanaumu kula. ");
INSERT INTO xnj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hinu, vandu vamahele vevamlandayi Yesu pavagayuwini genago, vakajova, “Aga ndi mawuliwu geginonopa! Yani mweihotola kuyuwanila?” ");
INSERT INTO xnj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu amanyili mumtima waki kuvya vawuliwa vaki ving'ung'uta ndava ya lilovi lenilo, ndi akavajovela, “Wu, mawuliwu ago gakuvakita muleka kusadika? ");
INSERT INTO xnj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yati yivya wuli pemukumlola Mwana wa Mundu ihamba kunani kwa Chapanga kweavili hoti? ");
INSERT INTO xnj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mpungu Msopi ndi mweileta wumi, makakala ga mundu nakuhotola chindu. Malovi genikuvajovela ndi ga Mpungu Msopi na gileta wumi. ");
INSERT INTO xnj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pamonga na ago, nambu vavi vangi pagati yinu nakusadika.” Yesu ajovili genago ndava avamanyili kutumbula kadeni, vangasadika, na mewa yani mweakumng'anamukila. ");
INSERT INTO xnj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akayonjokesa kujova, “Ndava yeniyi navajovili kuvya kawaka mundu mweihotola kubwela kwa nene changali kutangatiliwa na Dadi.” ");
INSERT INTO xnj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kuhumila lukumbi lwenulo vevamlandayi vamahele vakawuya mumbele, vakotoka kumlanda kavili. ");
INSERT INTO xnj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu akavakota vawuliwa kumi na vavili vala, “Wu, na nyenye mwigana kuwuka?” ");
INSERT INTO xnj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petili akamyangula, “Bambu, tihamba kwa yani? Veve ndi uvinagu malovi gegileta wumi wa magono goha wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tete tikusadika na timanyili kuvya veve ndi wa Msopi kuhuma kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akavajovela, “Wu, navahagwili lepi nyenye kumi na vavili? Nambu mmonga winu ndi Setani!” ");
INSERT INTO xnj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu ajovili genago kumvala Yuda mwana wa Simoni Isikalioti, muni mwenuyo ndi yati mweakumung'anamukila, pamonga avi mmonga pagati ya vawuliwa kumi na vavili. ");
INSERT INTO xnj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pegamaliki genago, Yesu agendayi ku Galilaya kwenuko. Aganili lepi kugenda pamulima wa Yudea ndava Vachilongosi va Vayawudi vaganayi kumkoma. ");
INSERT INTO xnj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lukumbi lwa mselebuko wa Vayawudi wewukemelewa vindanda wavi papipi. ");
INSERT INTO xnj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hinu, valongo vaki vakamjovela mwene, “Uwuka penapa na uhambayi ku Yudea muni vevakulanda vagawonayi mahengu gaku geukugahenga. ");
INSERT INTO xnj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kawaka mundu mweihenga mambu cha mfiyu kuni mwene igana kumanyikana kwa vandu. Ndava wikita mambu ago, hinu jilangilasa kwa vandu va mulima woha.” ");
INSERT INTO xnj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hati valongo vaki mewawa vamsadika lepi. ");
INSERT INTO xnj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu akavajovela, “Lukumbi lwangu lwabwina lwakona kuhika, nambu kwa nyenye lukumbi lwoha lwabwina. ");
INSERT INTO xnj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Vandu va mulima nakuhotola kuvahakalila nyenye, nambu ukunihakalila nene ndava nene nijova kuvya matendu gaki gahakau. ");
INSERT INTO xnj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nyenye mhamba kumselebuko. Nambu nene nakuhamba kumselebuko wenuwo, muni lukumbi lwangu lwabwina lwakona kuhika.” ");
INSERT INTO xnj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Peamalili kujova genago, mwene akasigalila ku Galilaya. ");
INSERT INTO xnj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Valongo vaki pevahambili kumselebuko wa vindanda, Yesu namwene akahamba, nambu lepi hotohoto ndi chamfiyu. ");
INSERT INTO xnj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vachilongosi va Vayawudi vamlondayi Yesu kumselebuko wenuwo, vakakota “Avi koki?” ");
INSERT INTO xnj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pamsambi wa vandu kwavi na vandu vamahele vevajovai chinunu. Vangi pagati yavi vakajova, “Mundu mbwina.” Vangi vakajova, “Mwe! Akuvayaganisa vandu.” ");
INSERT INTO xnj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nambu avi lepi mundu mweahotwili kujova malovi ga Yesu hotohoto, ndava ya kuvayogopa Vachilongosi va Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Peyahikili pagati ya mselebuko, Yesu akahamba mu Nyumba ya Chapanga na kutumbula kuwula. ");
INSERT INTO xnj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hinu, Vachilongosi va Vayawudi vakakangasa na kujova, “Mundu uyu agamanyili wuli goha aga changali mwene kuwuliwa na mundu?” ");
INSERT INTO xnj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Penapo Yesu akavayangula, “Mawuliwu genikugawula aga ganamwene lepi, nambu gaki yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu mweigana kuhenga gala geigana Chapanga, yati imanya ngati mawuliwu gangu gahumili kwa Chapanga amala nijova namwene. ");
INSERT INTO xnj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mweijova ga mwene ndu, mwenuyu ilonda ukulu waki mwene, nambu yula mweilonda ukulu wa mweamtumili, ndi chakaka na mugati yaki kawaka uhakau. ");
INSERT INTO xnj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wu, Musa avapelili lepi Malagizu? Nambu kawaka hati mmonga mweiyidakila Malagizu. Ndava kyani mulonda kunikoma?” ");
INSERT INTO xnj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bahapo msambi wa vandu ukayangula, “Una mizuka veve! Yani mweigana kukukoma?” ");
INSERT INTO xnj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akavayangula, “Nikitili ulangisu umonga na nyenye uvakangisi. ");
INSERT INTO xnj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa avapeli malagizu ga kudumula jandu ndi wahumili lepi kwa Musa muni wahumili kwa vagogo. Hinu nyenye mukumdumula mundu jandu hati Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yakavya mundu idumuliwa jandu Ligono la Kupumulila, ndi muni malagizu ga Musa ukoto kudenywa, hinu ndava kyani mukuniyomela ndava ya kumlamisa mundu mu Ligono la Kupumulila? ");
INSERT INTO xnj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mkotoka kumuhamula mundu kwa kumlola chakuvala ndu, nambu muhamula cheyiganikiwa.” ");
INSERT INTO xnj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Vandu vangi va pa Yelusalemu vajovili, “Wu, mundu mwenuyu lepi yula vachilongosi vilonda kumkoma? ");
INSERT INTO xnj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mlola, ilongela hotohoto kawaka mundu mweakumjovela hati lilovi! Wu yihotoleka vachilongosi vamanyili chakaka, mwenuyu ndi Kilisitu? ");
INSERT INTO xnj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nambu Kilisitu peibwela avi lepi mundu yati imanya ihumila koki. Nambu tete tikumanyi kwe ahumili mundu uyu!” ");
INSERT INTO xnj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hinu, Yesu peavili mukuwula Munyumba ya Chapanga akajova kwa lwami, “Mwe! Mnimanyili, hati kwe nihumili mukukumanya? Nene nibweli lepi kwa uhotola wangu. Muni mwene mweanitumili nene ndi wa chakaka, na nyenye nakummanya, ");
INSERT INTO xnj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nambu nene nimmanyili ndava nihumili kwaki, mwene ndi mweanitumili.” ");
INSERT INTO xnj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hinu, vandu vakalonda kumkamula, nambu kawaka mundu mweatalambwili chiwoko kumpamisa ndava lukumbi lwaki lwavi lwakona kuhika. ");
INSERT INTO xnj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Vandu vamahele mu msambi wula vamsadiki, vakajova, “Peibwela Kilisitu Msangula, yati ihenga milangisu ya kukangasa yamahele neju kuliku yeihenga mundu uyu?” ");
INSERT INTO xnj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Vafalisayu vevayuwini vandu vijova ga pahi ndava ya Yesu. Hinu, vene pamonga na Vamteta vakulu va Chapanga vavatumili valonda va nyumba ya Chapanga vamkamulayi. ");
INSERT INTO xnj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu akajova, “Nakona nivii pamonga na nyenye palukumbi luhupi, kangi nihamba kwa mwene mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yati mukunilonda nambu nakuniwona, na penivya nene, nyenye nakuhotola kuhika.” ");
INSERT INTO xnj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Vachilongosi va Vayawudi vakajovesana vene kwa vene, “Mundu mwenuyu yati ihamba koki kwe nakuhotola kumkamula? Yati ihamba kumiji ya Vagiliki, kwevahamalili vandu vitu na kuvawula Vagiliki? ");
INSERT INTO xnj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mwenuyu ijova kyani peijova, yati mukunilonda nambu nakuniwona na pala penivya nene nyenye nakuhotola kuhika?” ");
INSERT INTO xnj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ligono la kumalakisa mselebuko wenuwo ndi lavi ligono likulu, Yesu akayima na kujova kwa lwami mundu mweavi na njota ndi abwela kwanene anywayi. ");
INSERT INTO xnj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngati chegijova Mayandiku Gamsopi, mweakunisadika nene, mifuleni ya manji yeyileta wumi yati yihelela mumtima waki. ");
INSERT INTO xnj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ajovili genago kumvala Mpungu Msopi kuvya vevakumsadika vala yati vakumpokela. Lukumbi lwenulo Mpungu Msopi avi akona kuhika, ndava Yesu avi akona kupewa ukulu na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Vandu vangi mu msambi wula pevayuwini malovi ago, vakajova, “Chakaka mundu uyu ndi yula mlota wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Vangi vakajova, “mwenuyu ndi Kilisitu.” Nambu vangi vakajova, “Wu, yihotoleka Kilisitu kuhuma ku Galilaya? ");
INSERT INTO xnj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wu, Mayandiku Gamsopi gijova wuli? Gijova Kilisitu yati ihumila mu lukolo lwa Daudi na ivelekewa ku Betelehemu, pamuji wa Daudi.” ");
INSERT INTO xnj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hinu, mu msambi wula mpechenganu wahumalili ndava ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Vandu vangi vaganayi kumkamula nambu avi lepi mundu mweatalambwili chiwoko chaki kumpamisa. ");
INSERT INTO xnj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kangi valonda vala vakavahambila Vakulu va kuteta va Chapanga na Vafalisayu. Ndi vene vakavakota valonda, “Ndava kyani, mwangamleta Yesu?” ");
INSERT INTO xnj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Valonda vala vakayangula, “Avi lepi mundu mweamali kujova vindu vyeajovili mundu uyu!” ");
INSERT INTO xnj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Vafalisayu vakavakota, “Wu, na nyenye mkongiwi mewa? ");
INSERT INTO xnj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wu, mumuwene hati mmonga wa chilongosi wa vandu, amala mmonga wa Vafalisayu mweakumsadika? ");
INSERT INTO xnj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lepi, nambu msambi wenuwo vangamanya Malagizu ga Bambu geampeli Musa, vapeliwi likoto na Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mmonga wavi avi Nikodemu mweamuhambili Yesu magono ga mumbele. Hinu mwene akavajovela. ");
INSERT INTO xnj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Malagizu gitu gijova tikumuhamula lepi mundu changali kumuyuwanila na kumanya ahengili kyani?” ");
INSERT INTO xnj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Vene vakamyangula, “Wu, na veve mewa uhumili ku Galilaya? Hinu ukagasoma bwina Mayandiku Gamsopi wamwene yati wilola kuvya ku Galilaya katu nakuhuma mlota wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Penapo kila mmonga awuyili kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kangi Yesu akahamba ku chitumbi Mizeituni. ");
INSERT INTO xnj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chilau yaki lukela pehe Yesu akahamba kavili Munyumba ya Chapanga. Vandu voha vamtindili na mwene akatama na kuvawula. ");
INSERT INTO xnj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hinu vawula va malagizu na Vafalisayu vamletili mdala mmonga mwevamkamwili ugoni vakamyimika pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kangi vakamkota Yesu, “Muwula mdala uyu vamkamwili ndava ya ugoni.” ");
INSERT INTO xnj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mumalagizu gitu Musa atilagizi atovewa na maganga mbaka afwayi. Mdala ngati uyu, hinu veve wijova wuli? ");
INSERT INTO xnj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vene vajovili malovi ago muni vamlinga. Muni vapatayi lilovi la kumtakila. Nambu Yesu akagundama pahi akayandika kwa lungonji lwaki pandima. ");
INSERT INTO xnj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pevayendalili kumkota, Yesu akayinuka akavajovela, “Mundu mweangambudila Chapanga pagati yinu avyayi wa kutumbula kumtova liganga.” ");
INSERT INTO xnj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kangi akagundama kavili akavya mukuyandika pandima. ");
INSERT INTO xnj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pevayuwini ago, vakatumbula kuwuka mmonga mmonga, valongolili vagogo. Yesu asigalili mwene, na mdala yula ayimili palapala. ");
INSERT INTO xnj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu peayinwiki ndi akamkota mau, Vandu vala vavi koki? Wu, kawaka hati mundu mmonga mweakuhamwili? ");
INSERT INTO xnj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mau yula, akamyangula, “Bambu, kawaka hati mmonga!” Yesu akamjovela, “Nene mewa nikuhamula lepi. Uhambayi, kutumbula hinu ukotoka kumbudila Chapanga kavili.” ");
INSERT INTO xnj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu alongili kavili na vandu, akavajovela, “Nene ndi lumuli lwa mulima. Mweakunilanda katu nakugenda muchitita, nambu ivya na lumuli lwa wumi.” ");
INSERT INTO xnj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hinu, Vafalisayu vakamjovela, “Veve wijova ndava yaku wamwene, malovi geujova ndava yaku, na geujova gachakaka lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu akavayangula, “Hati ngati nijova ndava yangu namwene malovi gangu ndi gachakaka, ndava namwene nimanyili kwenihuma na kwenihamba. Nambu nyenye mumanyi lepi kwenihumili amala kwenihamba. ");
INSERT INTO xnj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nyenye mwihamula ngati vandu chevihamula, nambu nene nikumuhamula lepi mundu. ");
INSERT INTO xnj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nambu ngati nihamula, kuhamula kwangu ndi kwa chakaka ndava nakuvya namwene, Dadi mweanitumili avi pamonga na nene. ");
INSERT INTO xnj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mu malagizu ginu yiyandikwi ngati vandu vavili vijova kwa kuyidakila ndava ya chindu chimonga chevachiwene chindu chenicho ndi chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nene nijova uchakaka namwene mewawa na Dadi mweanitumili ijova uchakaka ndava yangu.” ");
INSERT INTO xnj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bahapo vene vakamkota, “Avi koki Dadi waku?” Yesu akavayangula, “Nyenye nakunimanya nene, amala mumanyi lepi Dadi. Ngati mnimanyili nene ngammanyili na Dadi wangu mewa.” ");
INSERT INTO xnj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu agajovili malovi ago Munyumba ya Chapanga papipi na chijomela kuvikila luteta. Kawaka mundu mweamkamwili ndava lukumbi lwaki lwavi lwakona kuhika. ");
INSERT INTO xnj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu akavajovela kavili, “Nihamba namwene ndi nyenye yati mukunilonda, nambu mwifwa mukumbudila Chapanga, kwenihamba nene, nyenye nakuhotola kuhika.” ");
INSERT INTO xnj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hinu, vachilongosi va Vayawudi vakajova, ndava ya kyani ijova, kwenihamba nyenye nakuhotola kuhika, “Wu, igana kujikoma mwene?” ");
INSERT INTO xnj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu akavajovela, “Nyenye muhumili bahapa pahi, nambu nene nihumili kunani. Nyenye va bahapa pamulima, nene na wa mulima wenuwu lepi. ");
INSERT INTO xnj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndava muni navajovili kuvya yati mwifwa mukumbudila Chapanga winu, ngati mwangasadika ‘Nene Ndi Mwene,’ Mwifwa mukumbudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Vene vakamkota, “Veve wayani?” Yesu akayangula, “Nene ndi mwenavajovili kutumbula kadeni! ");
INSERT INTO xnj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nivii nagu gamahele ga kujova na mewawa kuvahamula nyenye. Nambu mweanitumili yula ndi chakaka, nene nikuujovela mulima mambu gala genigayuwini kuhumila kwa mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Vene vangamanya kuvya Yesu akuvajovela malovi ga Chapanga Dadi waki. ");
INSERT INTO xnj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndi Yesu akavajovela, “Pemukumunyakula Mwana wa Mundu, penapo ndi yati mwimanya kuvya ‘Nene Ndi Mwene,’ Namwene nakuhenga chochoha ndi nijova gala ndu geaniwulili Dadi. ");
INSERT INTO xnj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mweanitumili avi pamonga na nene, mwene anilekili lepi namwene ndava nihenga magono goha gala gegakumganisa.” ");
INSERT INTO xnj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Vandu vamahele pevamyuwini Yesu ijova genago vamsadiki. ");
INSERT INTO xnj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu akavajovela Vayawudi vala vevamsadiki, “Ngati mukugayidakila mawuliwu gangu chakaka yati mwivya vawuliwa vangu. ");
INSERT INTO xnj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yati mukuumanya uchakaka na uchakaka yati ukuvapela kulekekeswa.” ");
INSERT INTO xnj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Vene vakamyangula, “Tete chiveleku cha Ibulahimu. Hati mala yimonga, nakuvya vavanda kwa mundu yoyoha mana yaki kiki peujova, ‘Yati tilekekeswa?’ ” ");
INSERT INTO xnj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu akavayangula, “Chakaka nikuvajovela, mundu yoyoha mweibuda mwenuyu ndi mvanda mweabudili. ");
INSERT INTO xnj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mvanda itama lepi panyumba magono goha. Nambu mwana itama magono goha. ");
INSERT INTO xnj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hinu Mwana akavapela ulekekesu yati mulekekeswa chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nivamanyili nyenye kuvya chiveleku cha Ibulahimu. Pamonga mwilonda kunikoma ndava mukugabela mawuliwu gangu. ");
INSERT INTO xnj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nene nijova gala geanilangisi Dadi, nambu nyenye mkugahenga gala gemuyuwini kuhuma kwa dadi winu.” ");
INSERT INTO xnj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Vene vakamyangula, “Dadi witu Ibulahimu.” Yesu akavajovela, “Ngati nyenye kuvya vana vaki Ibulahimu ngamuhengili ngati cheahengili Ibulahimu. ");
INSERT INTO xnj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nene nivajovili uchakaka weniuyuwini kuhuma kwa Chapanga. Nambu nyenye mulonda kunikoma. Ibulahimu akitili lepi genago! ");
INSERT INTO xnj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nyenye mwikita mambu galagala geakitili dadi winu.” Vene vakamjovela, “Tete tavana vamakunja lepi! Tivii na Dadi witu mmonga ndi Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu akavajovela, “Ngati kuvya Chapanga ndi Dadi winu, ngamuniganili nene, muni nene nahumili kwa Chapanga na hinu nivii penapa. Nibweli lepi kwa uhotola wangu nambu wa mwene mweanitumili yula. ");
INSERT INTO xnj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ndava kyani mwimanya lepi genijova aga? Ndava muni nakuyuwana ujumbi wangu. ");
INSERT INTO xnj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nyenye vana va dadi winu Setani na mwigana kuhenga geigana dadi winu. Mwene avi mkomaji kuhumila kadeni, mwene iyima lepi upandi wa uchakaka, ndava muni mugati yaki uchakaka uvi lepi. Kila peijova udese ijova ngati cheavili muni mwene mdese na dadi wa vadese. ");
INSERT INTO xnj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ndava nene nikuvajovela uchakaka nyenye mukunisadika lepi. ");
INSERT INTO xnj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yani pagati yinu mweihotola kunijovela nene nikumbudila Chapanga? Nene nakajovayi chakaka ndava kyani mukunisadika lepi? ");
INSERT INTO xnj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mweavi waki Chapanga iyuwana malovi gaki Chapanga. Nambu nyenye nakuyuwana ndava nyenye vandu lepi va Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Vayawudi vakamyangula Yesu, “Wu, tete nakujova chakaka kuvya veve wa Msamaliya na kavili uvi na mzuka?” ");
INSERT INTO xnj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu akayangula, “Nangali mzuka. Nene nikumtopesa Dadi wangu, nambu nyenye mukunitopesa lepi nene. ");
INSERT INTO xnj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nene nikuulonda lepi ukulu wangu namwene, avi mmonga mweakunilondela ukulu wangu, mwene ndi mhamula mihalu. ");
INSERT INTO xnj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chakaka nikujovela, mundu akauyidakila ujumbi wangu yati ifwa lepi nambu ivya mumi magono goha gangali mwishu.” ");
INSERT INTO xnj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Vayawudi vakajova, “Hinu timanyili kuvya chakaka veve uvi na mzuka! Ibulahimu afwili mewawa vamlota va Chapanga vafwili hinu veve ujova ‘Mweakuukamulila ujumbi waku katu ifwa lepi, nambu ivya mumi magono goha!’ ");
INSERT INTO xnj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wu, veve ukujikita mkulu kuliku dadi witu Ibulahimu mweafwili?” Mewawa na vamlota va Chapanga vafwili. Veve ukujita wayani? ");
INSERT INTO xnj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akavayangula, “Nakujilumba namwene, ukulu wangu chindu lepi. Dadi wangu mwemukumkemela Chapanga winu, mwene ndi mweakunilumba. ");
INSERT INTO xnj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nyenye mukummanya lepi, nambu nene nimanyili nikajova nangammanya, yati nivya mdese ngati nyenye, nambu nimmanyili na nikugayidakila malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dadi winu Ibulahimu, ahekalili alilola ligono langu. Mwene akaliwona akavya na luheku.” ");
INSERT INTO xnj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Vayawudi vakamjovela, “Veve uhikisi lepi hati miyaka makumi mhanu na veve umuweni Ibulahimu?” ");
INSERT INTO xnj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu akavajovela, “Chakaka nikuvajovela, kwakona Ibulahimu kuvelekewa nene navili.” ");
INSERT INTO xnj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Penapo vakanonga maganga muni vamjugumilayi nambu Yesu ajifiyili na kuwuka pa Nyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu peavili mukuhamba ndi amuwene mundu mmonga mweavingalola kuhumila kuvelekewa. ");
INSERT INTO xnj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vawuliwa vaki vakamkota, “Muwula, yani mweambudili Chapanga, mundu uyu amala dadi na nyina vaki, hati avelekiwi ngalola?” ");
INSERT INTO xnj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akavayangula, “Mwene amala dadi na nyina waki avi lepi mweambudili Chapanga. Avelikiwi ngalola, muni makakala ga Chapanga gawonekanayi gihenga lihengu muwumi waki. ");
INSERT INTO xnj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kwakona muhi yikutigana kuhenga lihengu laki yula mweanitumili. Muni kimihi yibwela mundu nakuhotola kuhenga lihengu. ");
INSERT INTO xnj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lukumbi penivii pamulima nene ndi lumuli lwa vandu va mulima.” ");
INSERT INTO xnj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Peamali kujova genago, Yesu akahunya mata pahi, akakandagana ludaka na kumnyala ngalola yula mumihu. ");
INSERT INTO xnj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Akamjovela, “Hamba ukajisambisa kulitanda la Siloamu.” Liina lenilo mana yaki ndi mweatumwili. Penapo, ngalola yula akahamba akajisambisa, akawuya kuni ilola. ");
INSERT INTO xnj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hinu, vandu vevatama naku papipi vevammanyili kuvya avi mngangu myupaji, vakajova, “Wu, mwenuyu lepi ngalola mweatamayi na kuyupa?” ");
INSERT INTO xnj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Vamahele vakajova, “Ena.” Vangi vakajova “Lepi, ndi iwanana naku.” Nambu ngalola yula akajova, “Ndi nene mwenayupayi.” ");
INSERT INTO xnj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ndi vakamkota, “Wu, hinu mihu gaku uhotwili kulola?” ");
INSERT INTO xnj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mwene akavayangula, “Mundu yula mweikemelewa Yesu akandagini ludaka, na kuninyala pamihu, akanijovela. Uhamba ukajisanja pamihu ku litanda la Siloamu. Nene nikahamba kujisanja na hinu nihotola kulola.” ");
INSERT INTO xnj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Vakamkota, “Avi koki?” Mwene akavayangula, “Nene nimanyili lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kangi vampeliki mundu yula mweavili hoti ngalola kwa Vafalisayu. ");
INSERT INTO xnj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ligono Yesu peakandagini ludaka na kumdindula mihu yavili Ligono la Kupumulila. ");
INSERT INTO xnj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Vafalisayu vakamkota kavili, “Uhotwili wuli kulola?” Mwene akavajovela, “Aninyalili ludaka pamihu, ndi nene najisambisi na hinu nilola.” ");
INSERT INTO xnj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Vafalisayu vangi vakajova, “Mundu mwenuyu ahumili lepi kwa Chapanga, muni ikamula lepi Ligono la Kupumulila.” Nambu vangi vakajova, “Ihotola wuli kuhenga gachinamtiti ngati genaga?” Pakavya na mpechenganu pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Vakamkota kavili, “Veve wijova wuli kumvala mwene?” “Ndava akudindwili mihu?” Akavayangula, “Mwenuyo ndi mlota wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Vachilongosi va Vayawudi nakusadika ngati mundu yula avi ngalola kadeni na hinu ilola, mbaka pavavakemili dadi na nyina waki. ");
INSERT INTO xnj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Vakavakota dadi na nyina waki, “Wu, mwenuyu ndi mwana winu? Ndi mwemwijova avelekiwi ngalola? Kangi ahotwili wuli kulola?” ");
INSERT INTO xnj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Vene vakayangula, “Timmanyili kuvya uyu ndi mwana witu, na avelikwi ngalola. ");
INSERT INTO xnj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nambu timanyi lepi cheahotwili kulola, mewa timmanyi lepi mweamdindwili mihu. Mumkota mwene, muni mundu mvaha ihotola kudandaula mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Dadi na nyina waki vagajovili genago ndava ya kuvayogopa vachilongosi va Vayawudi muni vamali kuyidikilana kuvya mundu mweiyidakila na kujova kuvya Kilisitu ndi Msangula yati ivingiwa awuka munyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndava ya genago ndi dadi na nyina waki vajovili, “Mwene mundu mvaha ndi mumkota mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vakamkemela kavili mundu yula mweavelikwi ngalola, vakamjovela, “Lapa palongolo ya Chapanga. Tete timanyili kuvya mundu uyu akumbudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mwene akayangula, “Nene nimanyi lepi ngati akumbudila Chapanga. Nambu nimanyili chindu chimonga. Navi ngalola hinu nilola.” ");
INSERT INTO xnj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndi vakamkota, “Akuhengili kyani? Akulamisi wuli mihu gaku?” ");
INSERT INTO xnj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mundu yula akavayangula, “Nimali kuvajovela, nyenye mniyuwana lepi, ndava kyani mwigana kuyuwana kavili? Wu, na nyenye mewa mwigana kuvya vawuliwa vaki?” ");
INSERT INTO xnj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hinu vakamuliga na kumjovela, “Veve ndi muwuliwa wa mundu yula, nambu tete tavawuliwa va Musa. ");
INSERT INTO xnj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tete timanyili kuvya Chapanga alongili na Musa, nambu nakummanya mundu uyu ahumili koki!” ");
INSERT INTO xnj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwene akavayangula, “Chenichi ndi chindu cha kukangasa! Nyenye mwangamanya kweahumili, nambu anidindwili mihu gangu! ");
INSERT INTO xnj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Timanyili kuvya Chapanga akuvayuwanila lepi vevakumbudila mwene, nambu akumyuwanila mundu yoyoha mweakumyogopa Chapanga na kuhenga geigana. ");
INSERT INTO xnj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kutumbula mulima pewawumbiwi yiyuwaniki lepi kuvya mundu agadindwili mihu ga mundu mweavelekiwi ngalola. ");
INSERT INTO xnj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ngati mundu mwenuyu nakuhuma kwa Chapanga ngaahotwili lepi kuhenga chochoha!” ");
INSERT INTO xnj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Vene vakamyangula, Mwe! “Veve uvelekiwi na kukula mukumbudisa Chapanga, wihotola wuli kutiwula tete?” Hinu vakamuwusa munyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ayuwini kuvya vamuwusili munyumba ya kukonganekela Vayawudi. Hinu pevamuwene akamkota, “Wu, veve ukumsadika Mwana wa Mundu?” ");
INSERT INTO xnj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundu yula akamyangula, “Mtopeswa unijovela mundu mwenuyo ndi yani, muni nimsadikayi.” ");
INSERT INTO xnj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu akamjovela, “Umali kumuwona, mwene mweujova nayu ndi mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mundu yula akajova, “Bambu nisadika!” Ndi akamfugamila. ");
INSERT INTO xnj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu akajova, “Nene nibwelili pamulima kuvabagula vandu, muni vangalola vahotola kulola, na vevilola vavyai vangalola.” ");
INSERT INTO xnj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Vafalisayu vangi vevavi pamonga naku vagayuwini genago, vakamkota, “Wu, na tete mewa vangalola?” ");
INSERT INTO xnj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akavayangula, “Ngati mwavi vangalola, ngamvalangiwi lepi mumbudili Chapanga nambu nyenye mwijova, tete tilola hinu yilangisa kuvya nyenye mbudili.” ");
INSERT INTO xnj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu akavajovela, “Chakaka nikuvajovela, mundu yoyoha yula mweangayingila muchivaya cha mambelele kwa kupitila pamlyangu uvaha nambu iholota na kuyingila kwa pandu pangi, mwenuyo ndi muhiji na mnyagaji. ");
INSERT INTO xnj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nambu mundu yula mweiyingila kupitila mlyangu, mwenuyo ndi mdimaji wa mambelele. ");
INSERT INTO xnj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mlonda wa mlyangu wa chivaya akumdindulila mlyangu mdimaji. Na mambelele giyuwana lwami lwa mdimaji, namwene akugakemela kwa mahina gavi kila limonga na kugawusa kuvala. ");
INSERT INTO xnj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Akamala kugawusa kuvala, mwene akugalongolela kulongolo, na mambelele gakumlanda, ndava gakulumanya lwami lwaki. ");
INSERT INTO xnj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nambu gakumlanda lepi myehe, ndi gakumtila ndava nakulumanya lwami lwaki.” ");
INSERT INTO xnj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu avajovili kwa luhumu ulu, nambu vene vamanyili lepi cheaganili kuvajovela. ");
INSERT INTO xnj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hinu Yesu akajova kavili, chakaka nikuvajovela nene ndi mlyangu wa chivaya cha mambelele. ");
INSERT INTO xnj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Voha vevanilongolili nene, ndi vahiji na vanyagaji, na mambelele nakuvayuwanila. ");
INSERT INTO xnj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nene ndi mlyangu. Mweiyingila munjila yangu yati isanguliwa, yati iyingila na kuhuma na kupewa chakulya. ");
INSERT INTO xnj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mhiji ibwela muni ayivayi, na kukoma na kuhalabisa. Nene nibwelili muni mupatayi wumi wa chakaka weumemili. ");
INSERT INTO xnj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nene ndi mdimaji mbwina. Mdimaji mbwina ajitendekili hati kufwa ndava ya mambelele gaki. ");
INSERT INTO xnj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mhenga lihengu wa luhuna mdimaji lepi, mambelele gaki lepi. Peiwona libwa la kudahi libwela. Ileka mambelele na kutila, kangi libwa la kudahi likamula na kugapechengana. ");
INSERT INTO xnj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mundu mwenuyo itila na iyangalila lepi mambelele, ndava mwene ndi mundu wa luhuna ndu. ");
INSERT INTO xnj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nene ndi mdimaji mbwina nigamanyili mambelele gangu, na mambelele gegavi gangu ganimanyili. ");
INSERT INTO xnj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ngati Dadi cheanimanyili nene, na nene chenimmanyili Dadi. Niwusa wumi wangu hati kufwa ndava ya mambelele. ");
INSERT INTO xnj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kangi nivii na mambelele gangi ga chivaya ichi lepi. Yikunigana mewa kugaleta, na gene yati giyuwana lwami lwangu, yati kwivya na msambi umonga na mdimaji mmonga. ");
INSERT INTO xnj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Dadi akunigana ndava nikuuwusa wumi wangu muni niupokelayi kavili. ");
INSERT INTO xnj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kawaka mundu mweakuninyaga wumi wangu, nambu nikuuwusa kwa kugana kwangu namwene. Nivii na uhotola wa kuuwusa wumi wangu na mewa nivii na uhotola wa kuutola kavili. Chenichi ndi Dadi cheanilagizi kukita.” ");
INSERT INTO xnj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ndava ya malovi genago ukahumila mpechenganu kavili pagati ya Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Vangi vamahele vakajova, “Mwenuyu ana mzuka! Mewa ana lupengu Ndava kyani kumyuwanila?” ");
INSERT INTO xnj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nambu vangi vakajova, “Malovi aga lepi ga mundu ana mzuka. Wu, mzuka uhotola kudindula mihu ga vangalola?” ");
INSERT INTO xnj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ku Yelusalemu kwenuko kwavili na mselebuko wa kukumbuka kuyibagula Nyumba ndava ya Bambu. Lukumbi lwenulo lwavi lwa mbepu. ");
INSERT INTO xnj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu mwene avi igenda Munyumba ya Chapanga mu libanji la Solomoni. ");
INSERT INTO xnj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Vayawudi vamtindili, kumkota, “Ukutileka na maholo mbaka ndali? Ngati veve ndi Kilisitu Msangula, hinu utijovela hotohoto.” ");
INSERT INTO xnj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu akavayangula, “Nivajovili, nambu nyenye nakunisadika. Mahengu genihenga nene kwa liina la Dadi wangu gilangisa nene ndi yani. ");
INSERT INTO xnj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nambu nyenye mwisadika lepi, ndava nyenye lepi mambelele gangu. ");
INSERT INTO xnj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mambelele gangu giyuwana lwami lwangu. Nene nigamanyili na gene gakunilanda. ");
INSERT INTO xnj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nene nikugapela wumi wa magono goha wangali mwishu, katu vifwa lepi, na kawaka mundu mweihotola kuvanyaga kuhuma kwangu. ");
INSERT INTO xnj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dadi wangu ndi mkulu kuliku vyoha, na kawaka mundu wa kuhotola kuvanyaga mu mawoko ga Dadi wangu. ");
INSERT INTO xnj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nene na Dadi, tavamonga.” ");
INSERT INTO xnj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hinu, Vayawudi vakanonga maganga muni vamkomayi Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu akavajovela, “Nivalangisi mahengu gamahele kuhuma kwa Dadi. Wu, lihengu loki lelikuvakita nyenye munikoma kwa maganga?” ");
INSERT INTO xnj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Vayawudi vakamyangula, “Tikukoma lepi kwa maganga ndava ya mahengu gabwina gehuhengili, nambu ndava ukumliga Chapanga, veve wa mundu ndu nambu ukujikita wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akavajovela, “Yiyandikwi mu malagizu ginu, ‘Nene nijovili, nyenye ndi vachapanga?’ ");
INSERT INTO xnj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chapanga avakemili vandu vala vevapewili ujumbi waki ndi vachapanga, na tete timanyili kuvya Mayandiku Gamsopi gijova chakaka magono goha. ");
INSERT INTO xnj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dadi anihagwili na kunituma pamulima. Ndava kyani nyenye mukunijovela, nikumliga Chapanga. Penijova nene Mwana wa Chapanga? ");
INSERT INTO xnj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngati nikugahenga lepi mahengu ga Dadi wangu, mkoto kunisadika. ");
INSERT INTO xnj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ngati nikugahenga, hati ngati mukunisadika lepi, hinu mugasadika mahengu genago. Muhotola kumanya chakaka kuvya Dadi avi mugati yangu, na nene nivii mugati yaki.” ");
INSERT INTO xnj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vakalinga kavili kumkamula Yesu nambu akavalema mu mawoko gavi. ");
INSERT INTO xnj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu akahamba kangi kumwambu ya mfuleni Yoludani, pandu peavi Yohani ibatiza, akatama kwenuko. ");
INSERT INTO xnj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Vandu vamahele vambwelili Yesu na kujova Yohani ahengili lepi gachinamtiti gogoha, “Nambu goha geajovili kumvala mundu uyu ndi chakaka neju.” ");
INSERT INTO xnj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Vandu vamahele pandu penapo vakamsadika Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu mmonga liina laki Lazalu avi mtamu. Mundu mwenuyo avili mkolonjinji wa Betania, valumbu vaki Maliya na Malita vatamayi chijiji chila. ");
INSERT INTO xnj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliya ndi yula mweamnyalili Bambu mahuta geginungalila bwina mumagendelu gaki na kumuungula na mayunju gaki. Lazalu mweavimtamu ndi mhaja wa Maliya. ");
INSERT INTO xnj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hinu, valumbu vala vatumili ujumbi kwa Yesu. “Bambu, nkozi waku mtamu!” ");
INSERT INTO xnj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu mwene peagayuwini genago, akajova, “Utamu wenuwu wileta lepi lifwa, uhumalili muni Chapanga apewa ukulu na Mwana wa Chapanga mewa apewa ukulu.” ");
INSERT INTO xnj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu avaganili Malita na Maliya pamonga na mlongo wavi Lazalu. ");
INSERT INTO xnj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Peayuwini kuvya Lazalu mtamu, Yesu akahamba kutama peavili magono gavili. ");
INSERT INTO xnj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kangi akavajovela vawuliwa vaki, “Tihamba kavili ku Yudea!” ");
INSERT INTO xnj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Vawuliwa vala vakamjovela, “Muwula, lukumbi luhupi ndu lupitili Vayawudi vaganili kukukoma na maganga, hinu wigana kuhamba kwenuko kavili?” ");
INSERT INTO xnj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akavayangula “Wu, kuvi lepi masaa kumi na gavili ga muhi? Hinu mundu akagendayi muhi nakuhotola kujikuvala ndava ihotola kulola lumuli lwa mulima. ");
INSERT INTO xnj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nambu mundu akagendayi kilu akujikuvala ndava muni kawaka lumuli.” ");
INSERT INTO xnj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu peamali kujova malovi genago, akavajovela “Nkozi witu Lazalu agonili, nambu nene yati nihamba kumuyumusa.” ");
INSERT INTO xnj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vawuliwa vaki vakamjovela, “Bambu yikavya agonili yati ilama.” ");
INSERT INTO xnj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Vene vaholalili kuvya ajovili kugona lugono, nambu Yesu ajovili kumvala lifwa la Lazalu. ");
INSERT INTO xnj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndi Yesu akavajovela hotohoto kuvya “Lazalu afwili, ");
INSERT INTO xnj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nambu ndava yinu nivii na luheku ndava navi lepi kwenuko, muni musadika. Hinu tihamba kwa Lazalu.” ");
INSERT INTO xnj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi mweikemelewa mpaha, akavajovela vawuliwa vayaki, “Tihamba na tete tikafwayi pamonga na Yesu!” ");
INSERT INTO xnj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu peahikili kwenuko, amkolili Lazalu amali kuvya mulitinda magono mcheche. ");
INSERT INTO xnj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Chijiji cha Betania chavi papipi na Yelusalemu, utali waki wavi kilomita zidatu. ");
INSERT INTO xnj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Vayawudi vamahele vahikili kwa Malita na Maliya kuvapolesa mitima ndava mhaja wavi afwili. ");
INSERT INTO xnj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Hinu, Malita peayuwini kuvya Yesu ibwela, akahamba kumpokela, nambu Maliya asigalili kunyumba. ");
INSERT INTO xnj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malita amjovili Yesu, “Bambu, Ngati ngauvyayi apa, mhaja wangu ngaafwili lepi. ");
INSERT INTO xnj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nambu nimanyili kuvya hati hinu, chochoha cheukumuyupa Chapanga yati akupela.” ");
INSERT INTO xnj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu akamjovela, “Mhaja waku yati iyuka.” ");
INSERT INTO xnj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita akayangula, “Nimanyili kuvya yati iyuka lukumbi Chapanga peakuvayukisa vevafwili.” ");
INSERT INTO xnj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu akamjovela, “Nene ndi mweniyukisa vandu na kuvapela vandu wumi. Mweakunisadika nene hati ngati afwili, yati itama, ");
INSERT INTO xnj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","mewawa mundu yoyoha mweitama na kunisadika, katu ifwa lepi. Wu, wisadika genago?” ");
INSERT INTO xnj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malita akayangula “Ena Bambu! Nene nisadika kuvya veve ndi Kilisitu, Mwana wa Chapanga, yula mweibwela pamulima.” ");
INSERT INTO xnj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Peamalii kujova genago, Malita akahamba kumkemela mlumbu waki Maliya, akamjovela pachiepela, “Muwula avi penapa, akukemela.” ");
INSERT INTO xnj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliya peayuwini malovi ago, bahapo akayima kanyata akamuhambila Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu avi akona kuyingila pachijiji, ndi avi pandu palapala pavakonganiki na Malita. ");
INSERT INTO xnj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Vayawudi vevampolesa mtima Maliya panyumba pala, pavamuwene Maliya awukili chigafula, vakamlanda. Vaholalili kuvya ihamba kuvemba kulitinda. ");
INSERT INTO xnj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliya peahikili pandu pala peavili Yesu na kumlola akamfugamila, akamjovela, “Bambu ngati kuvya uvya apa, mhaja wangu ngaafwili lepi!” ");
INSERT INTO xnj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu peamuwene Maliya ivemba na Vayawudi vevamlandili mewa vivemba, ndi akavya ngolongondi na kuviniswa mumtima. ");
INSERT INTO xnj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kangi akavakota, “Mumvikili koki?” Vakamjovela “Bambu, ubwela ulolayi.” ");
INSERT INTO xnj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu akavemba maholi. ");
INSERT INTO xnj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hinu, Vayawudi vakajova, “Mlola cheamganili Lazalu!” ");
INSERT INTO xnj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nambu vangi vakajova, “Wu, mwenuyu ndi yula mweamdindwili mihu ngalola, hinu ahotwili lepi kukita Lazalu akoto kufwa?” ");
INSERT INTO xnj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu iviniswa mtima kavili, akahika kulitinda. Litinda lene lavi mbugu levadivalili liganga pamlyangu waki. ");
INSERT INTO xnj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu akavajovela, “Muwusa liganga lenili!” Malita mlumbu wa yula mweafwili akamjovela. “Bambu atumbwili kununga muni atamii mulitinda mula magono mcheche!” ");
INSERT INTO xnj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu akamjovela, “Wu, nene nakujovili lepi ukasadika yati ulola ukulu wa Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ndi vakaliwusa liganga lila. Yesu akalolokesa kunani kwa Chapanga, akajova “Dadi nikusengusa muni ukuniyuwana. ");
INSERT INTO xnj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nimanyili kuvya ukuniyuwana magono goha. Nambu nijovili genaga ndava ya vandu vevavi apa vasadikayi kuvya veve ndi mweunitumili.” ");
INSERT INTO xnj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Peamali kujova genago, Akakemela kwa lwami luvaha, “Lazalu! Huma kuvala!” ");
INSERT INTO xnj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mweafwili yula akahuma kuvala, kuni vamtindisili nyula ya msopi mumagendelu na mumawoko na pamihu poha. Yesu akavajovela, “Mumnyembelula, mumleka ahamba mwene.” ");
INSERT INTO xnj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Vayawudi vamahele vevabwelili kwa Maliya na kulilola lijambu leahengili Yesu. Ndi vakamsadika. ");
INSERT INTO xnj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nambu vangi vavi vakahamba kwa Vafalisayu vakavadandaulila lijambu leahengili Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Vakulu va kuteta na Vafalisayu vakakonganeka na vandu Libanji la Vayawudi vakakota, “Tikita wuli? Mundu uyu ihenga milangisu yamahele neju. ");
INSERT INTO xnj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Takamlekayi vandu voha yati vamsadika, na vakulu va ku Loma yati vibwela na kudenya Nyumba yitu ya Chapanga pamonga na mulima na vandu vitu!” ");
INSERT INTO xnj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mmonga wavi liina laki Kayafa, mweavi Mkulu wa Vateta wa mwaka wenuwo, akavajovela, “Nyenye nakumanya chindu! ");
INSERT INTO xnj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mwimanya lepi, ndi mbanga pagati yinu mundu mmonga afwayi ndava ya vandu, kuliku vandu voha va mulima witu vakomiwayi?” ");
INSERT INTO xnj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mwene ajovili lepi kwa luhala lwaki, nambu ndava avi Mteta mkulu mwaka wenuwo, ndi alotili kuvya Yesu yati ifwa ndava ya Vayawudi, ");
INSERT INTO xnj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","lepi ndava ya Vayawudi vene ndu, nambu mewa ndava ya vandu voha va Chapanga vevapechangini, muni avaletayi pamonga na kuvakita vavyayi na umonga. ");
INSERT INTO xnj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kutumbula ligono lenilo vachilongosi va Vayawudi vayidakilini kumkoma Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hinu Yesu agendili lepi hotohoto pagati ya Vayawudi, akawuka pandu pala akahamba pandu pepavi papipi na lugangatu. Pamuji wewukemelewa Efulaimu. Akatama kwenuko pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mselebuko wa Vayawudi Pasaka wavi papipi, na vandu vamahele vahambili ku Yelusalemu muni vahenga malagizu ga kujinyambisa vene muni kumuyupa Chapanga, kwakona mselebuko wenuwo. ");
INSERT INTO xnj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Vakavya kumulonda Yesu. Pevakonganiki pamonga Panyumba ya Chapanga. Vakakotana, “Yivya wuli? Yilolekana ibwela lepi pa mselebuko wenuwu? Amala wuli?” ");
INSERT INTO xnj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Vakulu va kuteta na Vafalisayu valagazili kuvya mundu akamanyayi kweavili Yesu, avajovelayi muni vamukamulayi. ");
INSERT INTO xnj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Magono sita kwakona mselebuko wa Pasaka, Yesu ahikili ku Betania kweatamayi Lazalu, mundu yula mweamyukisi. ");
INSERT INTO xnj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kwenuko vamtendelakili chakulya cha kimihi, Malita akavya kuvahengela. Lazalu avi mmonga wa vala vevatamili pameza pamonga na Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kangi Maliya akatola libotolo la pinga la mahuta geginungalila bwina, gegatenganizwi kwa mkongo wa nado, gegiguliswa kwa mashonga gamahele, akamnyala Yesu mumagendelu na kuhungula kwa mayunju gaki. Nyumba yoha yikanungalila mahuta gala. ");
INSERT INTO xnj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nambu Yuda Isikalioti mmonga wa vawuliwa vaki kumi na vavili vala ndi mweabweli kumng'anamukila Yesu, akajova, ");
INSERT INTO xnj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ndava kyani mahuta ago gaguliswi lepi kwa hipandi miya zidatu ya madini ga feza, vapewayi vangangu. ");
INSERT INTO xnj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ajovili genago lepi ndava ya lipyana kwa vangangu, nambu avi mvika kahaku ka mashonga. Na pamahele ayivayi mashonga gegavikwayi mu kahaku kala muni avi mhiji. ");
INSERT INTO xnj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nambu Yesu akajova, “Mkoto kumung'aha mau mwenuyu! Muleka agavika ndava ya ligono la kunizika. ");
INSERT INTO xnj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Vangangu yati mwivya nawu magono goha, nambu mwivya lepi na nene magono goha.” ");
INSERT INTO xnj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Vayawudi vamahele vayuwini kuvya Yesu avi ku Betania. Vakahika kwenuko lepi ndava ya kumlola Yesu ndi ndava ya kumlola Lazalu mweayukiswi na Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hinu Vamteta vakulu mewawa vayidakilini kumkoma lazalu. ");
INSERT INTO xnj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ndava ya kuyukiswa kwa Lazalu Vayawudi vamahele vavabelili vachilongosi wavi, vakamsadika Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chilau yaki, msambi uvaha wa vandu vevabwelili kumselebuko vakayuwana Yesu avi munjila kubwela pa Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hinu vakatola matutu ga mavali, vakawuka kuhamba kumpokela, vakajova kwa lwami luvaha. “Chapanga alumbiwa! Amotisiwa mwenuyo mweibwela kwa liina la Bambu. Amotisiwa Nkosi wa Isilaeli.” ");
INSERT INTO xnj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu akapewa mwana lipunda, akakwela panani yaki ngati chegijova Mayandiku Gamsopi. ");
INSERT INTO xnj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Vandu va muji wa Siyoni mkotoka kuyogopa! Ulola, Nkosi waku ibwela. Akweli mwana lipunda!” ");
INSERT INTO xnj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vawuliwa vaki nakumanya mambu ago, nambu Yesu peamali kupewa ukulu, ndi vakamanya kuvya gala gamali kuyandikwa kumvala mwene, kuvya vandu vamkitili genago. ");
INSERT INTO xnj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Msambi wa vandu vala vevavi pamonga na Yesu ligono leamkemili Lazalu kuhuma mulitinda, amyukisi. Vavajovili vandu mambu gala gegahumalili. ");
INSERT INTO xnj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ndava ya yeniyo msambi wa vandu ukahamba kumpokela, muni vayuwini kuvya akitili chinamtiti chenicho. ");
INSERT INTO xnj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hinu Vafalisayu vakakotana vene kwa vene, “Wu, mwilola? Nakuhotola kukita chochoha! Mlolayi, vandu voha va mulima vakumlanda.” ");
INSERT INTO xnj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kwavi na Vagiliki vadebe pagati ya vandu vala vevahikili ku Yelusalemu kumfugamila lukumbi lwa mselebuko wa pasaka. ");
INSERT INTO xnj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Venavo vamhambili Filipi, mkolonjinji wa Betisaida mweavili pamulima wa Galilaya, vakajova “Mtopeswa tete tigana kumlola Yesu.” ");
INSERT INTO xnj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi akahamba kumjovela Andelea, voha vavili vakahamba kumjovela Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akavajovela, “Saa ya Mwana wa Mundu kupewa ukulu yihikili.” ");
INSERT INTO xnj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chakaka nikujovela, mbeyu ya nganu yisigalila kuvya mbeyu ndu, mbaka yigwai muludaka na kufwa. Ngati yikafwayi ndi yimela na kupambika mbeyu yamahele. ");
INSERT INTO xnj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundu yoyoha mweakuugana wumi waki yati akuuyagisa, nambu mundu yoyoha mweakuuyomela wumi waki pamulima apa, akuuvika wumi wa magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mundu mweigana kunihengala yikumgana kunilanda, mewa pala penivya nene, ndi peivya mtangatila wangu. Mundu akanihengelayi nene Dadi wangu yati akumtopesa. ");
INSERT INTO xnj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Hinu mpungu wangu uvagaya, nijova wuli? ‘Dadi unisangulayi na lukumbi lwenulo?’ Nambu ndava ya genago nibwelili muni nipitilayi lukumbi ulu lwa mang'ahiso. ");
INSERT INTO xnj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dadi, ugubukula ukulu waku.” Penapo lwami lukajova kuhuma kunani kwa Chapanga, “Nimali kuugubukula ukulu wangu na yati nikuugubukula kavili.” ");
INSERT INTO xnj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Msambi wa vandu vevayimili penapo vayuwini lwami lula, nambu vangi vavi vakajova, mbulumu na vangi vakajova “Mtumu wa kunani kwa Chapanga alongili naku!” ");
INSERT INTO xnj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nambu Yesu akavajovela, “Malovi gemuyuwini lepi ndava ya nene, nambu ndava ya nyenye. ");
INSERT INTO xnj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hinu ndi lukumbi lwa vandu va mulima uwu kuhamuliwa, Setani mweavi chilongosi wa mulima uwu yati ivingiwa. ");
INSERT INTO xnj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nene peniyinuliwa panani kuhuma pamulima yati kila mmonga yati ihutika kwangu.” ");
INSERT INTO xnj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ajovili genago kulangisa lifwa leifwa. ");
INSERT INTO xnj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hinu, msambi wa vandu wula ukamyangula “Tete tijoviwi na malagizu gitu kuvya Kilisitu yati ilama magono goha. Hinu uhotola wuli, kujova yikumgana Mwana wa Mundu kuyinuliwa? Mwana wa mundu mwenuyo ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu akavajovela, “Lumuli lwakona na nyenye mu lukumbi luhupi. Mgenda kwakona muvi nalu lumuli lwenulo muni chitita chikoto kuvakolela, muni mweigenda muchitita angamanya kweihamba. ");
INSERT INTO xnj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Lukumbi muvi na lumuli mwasadiki lumuli lwenulo muni mpata kuvya vandu va lumuli.” Peamali kujova malovi genago, Yesu akawuka mwene na kuhamba kujifiya patali na vandu. ");
INSERT INTO xnj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nambu pamonga Yesu ahengili gachinamtiti goha palongolo yavi, vene vamsadiki lepi. ");
INSERT INTO xnj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hinu malovi geajovili Isaya mweavili mlota wa Chapanga gakatimalila. “Bambu, yani mweasadiki ujumbi witu? Na uhotola wa Bambu agubukuliwi yani?” ");
INSERT INTO xnj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mewa vangahotola kusadika ndava Isaya ajovili kavili, ");
INSERT INTO xnj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chapanga agakoywisi mihu gavi Avahimwisi luhala lwavi. Vakoto kulola kwa mihu gavi. Vakoto kumanya kwa luhala lwavi. Nambu vakoto kuniwuyila. Muni nivalamisa.” ");
INSERT INTO xnj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya ajovili ndava auwene ukulu wa Yesu na kujova ndava ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pamonga na ago, vachilongosi vamahele va Vayawudi vamsadiki Yesu. Nambu ndava ya kuvayogopa Vafalisayu nakujova hotohoto. Vayogwipi kuvingiwa munyumba za kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndava muni vachilongosi avo vaganili kukwihiwa na vandu kuliku kukwihiwa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kangi Yesu akajova, kwa lwami luvaha, “Mundu mweakunisadika nene, akunisadika lepi namwene ndu, mewawa akumsadika yula mweanitumili nene. ");
INSERT INTO xnj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mweakunilola nene mewawa akumlola yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nene nibwelili pamulima muni nivyayi lumuli, mundu yoyoha mweakunisadika akotoka kusigalila muchitita. ");
INSERT INTO xnj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mundu yoyoha mweiyuwana malovi gangu, na akugahengela lepi, nene nikumuhamula lepi. Muni nibweli hee ndava ya kuvahamula vandu va mumulima nambu kuvasangula. ");
INSERT INTO xnj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yula mweakunibela nene, mweangayidakila malovi gangu avi naku wa kumuhamula. Malovi ga Yesu yati gakuvahamula vandu ligono la mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nene nakujova kwa uhotola wangu namwene, nambu Dadi mweanitumili ndi mweanijovela nijova kyani na cheyiganikiwa kuvajovela vandu. ");
INSERT INTO xnj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nene nimanyili kuvya mihilu yaki yileta wumi wa magono goha gangali mwishu. Hinu nene nijova gala ndu geanilagizi Dadi kujova.” ");
INSERT INTO xnj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yavili kwakona mselebuko wa pasaka kuhika, Yesu kuni amanyili lukumbi lwa kuwuka kwaki pamulima luhikili kuhamba kwa Dadi waki. Yesu avaganili neju vandu vaki vevavi pamulima na avaganili kwa uganu wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yavi lukumbi lwa chakulya cha kimihi. Setani amali kuyingi mumtima wa Yuda Isikalioti mwana wa Simoni, na kumpela maholo ga kumng'anamukila Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu amanyili kuvya Dadi amgotolili vindu vyoha muuhotola waki, mewawa kuvya ahumili kwa Chapanga na iwuya kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesu akawuka pachakulya pala, akavika pamuhana nyula yaki ya kujihwika, akatola chitambala na kujikunga muchiwunu. ");
INSERT INTO xnj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kangi akasopa manji munkele livaha na kutumbula kuvasambisa vawuliwa vaki magendelu na kuhungula na chitambala chila cheajikungili muchiwunu. ");
INSERT INTO xnj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Peamhikili Simoni Petili, Petili mwene akajova, “Bambu, veve yati ukunisanja magendelu nene?” ");
INSERT INTO xnj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akayangula, “Wimanya lepi chenihenga hinu, nambu yati wimanya mwanakandahi.” ");
INSERT INTO xnj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petili akamjovela, “Veve ukunisanja lepi magendelu katu!” Yesu akamyangula, “Changali kukusanja magendelu gaku wivya lepi muwuliwa wangu kavili.” ");
INSERT INTO xnj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petili akamyangula, “Bambu, unisanja, lepi magendelu gene, ndi pamonga na mawoko gangu mewawa na mutu.” ");
INSERT INTO xnj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu akamjovela, “Mundu mweamali kusamba ndi amali kunyamba iganikiwa kusanja magendelu ndu. Nyenye munyambili nambu mwavoha lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ammanyili yula mweakumng'anamukila, ndi mana ajovili, “Nyenye mnyambili, nambu mwavoha lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu peamali kuvasambisa magendelu na kuwala kavili nyula yaki, akatama, peatamili akavajovela, “Wu, mmanyili aga genivakitili?” ");
INSERT INTO xnj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nyenye mukunikemela Muwula na Bambu mwijova chakaka, muni nene ndi chenivii. ");
INSERT INTO xnj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yakavyai nene mwenivii Bambu na Muwula nivasambisi nyenye magendelu, mewawa na nyenye yikuvagana musanjanayi magendelu nyenye mwavene. ");
INSERT INTO xnj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nivapeli luhumu, muni nyenye mewa muhengayi ngati chenivahengili. ");
INSERT INTO xnj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chakaka nikuvajovela, mtangatila mkulu lepi kuliku mtopeswa waki, mewawa mjumbi mkulu lepi kuliku mweamtumili yula. ");
INSERT INTO xnj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hinu, ndava muni mukugamanya mambu ago, yati mmotisiwa ngati mukugahenga. ");
INSERT INTO xnj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nijova lepi kuvavala mwavoha. Nivamanyili venivahagwili vala, nambu Mayandiku Gamsopi giganikiwa gatimilayi, mundu mwealili chakulya pamonga na nene aning'anamukili. ");
INSERT INTO xnj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Nene nivajovili mambu aga kwakona kuhumila, muni pegihumila muhotola kusadika, ‘Nene Ndi Mwene.’ ");
INSERT INTO xnj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chakaka nikuvajovela, yula mweakumpokela mundu yoyoha mwenimtumili, akunipokela nene, na mweakunipokela nene akumpokela mwene mweanitumili.” ");
INSERT INTO xnj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Peamali kujova genago, Yesu akaviniswa neju mumtima, akajova hotohoto, “Chakaka nikuvajovela mmonga winu yati akuning'anamukila!” ");
INSERT INTO xnj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Vawuliwa vakalolesana kuni nakuhotola kummanya akumjova yani. ");
INSERT INTO xnj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mmonga wa vawuliwa, Yesu mweamganili neju, atamili papipi na Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hinu Simoni Petili akumkonya lihu muwuliwa yula “Amkotayi ijova kumvala yani.” ");
INSERT INTO xnj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Muwuliwa mwenuyu akahegelela papipi na Yesu, akamkota “Bambu ndi yani?” ");
INSERT INTO xnj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu akayangula, “Mundu yula mwenikumpela chipandi cha libumunda chenijwigi munkele ndi mwenuyo.” Ndi akatola chipandi cha libumunda akachijwiga munkele na kumpela Yuda, mwana wa Simoni Isikalioti. ");
INSERT INTO xnj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda peamali kupokela chipandi chila, Setani akamuyingila. Hinu Yesu akamjovela “Chewigana kukita kita kanyata!” ");
INSERT INTO xnj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nambu kawaka hati mmonga ya vala vevatamii pachakulya mweamanyili ndava kyani amjovili genago. ");
INSERT INTO xnj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndava muni Yuda avi mvika lihaku la mashonga, vangi vaholali kuvya Yesu amjovili manya akagula vindu vyeviganikiwa pamselebuko wa Pasaka, amala avapelayi vangangu vindu. ");
INSERT INTO xnj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda peamali kutola chipandi chila cha libumunda, bahapo akahuma kuvala. Na yavili kilu. ");
INSERT INTO xnj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda peamali kuwuka, Yesu akajova, “Hinu ukulu wa Mwana wa Mundu ugubukuliwi, na ukulu wa Chapanga ugubukuliwi mugati yaki.” ");
INSERT INTO xnj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ngati ukulu wa Chapanga ulangiswi mugati ya Mwana, hinu Chapanga yati akuulangisa ukulu wa Mwana mugati yaki mwene yati ikita ago kanyata. ");
INSERT INTO xnj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nyenye vana vangu, nakona niviii pamonga na nyenye mulukumbi luhupi ndu. Yati mukunilonda, nambu nikuvajovela galagala genavajovili vachilongosi va Vayawudi kuvya, ‘Kwenihamba nene, nyenye nakuhotola kuhamba.’ ");
INSERT INTO xnj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nikuvapela muhilu wa mupya mgananayi. Mgananayi ngati nene chenavaganili nyenye. ");
INSERT INTO xnj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mukagananayi, vandu voha yati vimanya kuvya nyenye ndi vawuliwa vangu.” ");
INSERT INTO xnj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petili akamkota, “Bambu, wihamba koki?” Yesu akayangula “Kwenihamba uhotola lepi kunilanda hinu, nambu yati ukunilanda mwanakandahi.” ");
INSERT INTO xnj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petili akamkota kavili, “Bambu, Ndava kyani nihotola lepi kukulanda hinu? Nene nihotola kufwa ndava yaku!” ");
INSERT INTO xnj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu akayangula, “Wu, uhotola chakaka kufwa ndava yangu? Chakaka nikukujovela, kwakona lijogolo kuvika ukunibela mala zidatu!” ");
INSERT INTO xnj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu akavajovela, mkoto kuviniswa mumitima yinu. “Mukumsadika Chapanga, munisadika na nene mewa. ");
INSERT INTO xnj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ya Dadi wangu muvi na vyumba vyamahele, ngati lepi nganamali kuvajovela. Muni hinu nihamba kuvatendelekela fwasi ndava yinu. ");
INSERT INTO xnj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nene nikahambayi na kuvatendelekela fwasi ndava yinu, yati niwuya kuvatola mbwela kwa nene, muni na nyenye mvya pandu penivya nene. ");
INSERT INTO xnj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nyenye mukuyimanya njila ya kuhamba kwenihamba.” ");
INSERT INTO xnj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi akamkota, “Bambu, nimanya lepi kwewihamba, tihotola wuli kumanya njila yeniyo?” ");
INSERT INTO xnj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu akamyangula, “Nene ndi njila na uchakaka na wumi wene. Kawaka mundu mweihotola kuhamba kwa Dadi changali kupitila kwa nene. ");
INSERT INTO xnj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngati mukunimanya nene, mewawa mukummanya na Dadi. Kutumbula hinu mukummanya, kangi mmali kumuwona.” ");
INSERT INTO xnj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi akamjovela, “Bambu, utilangisa Dadi, genago ndu tete tigana.” ");
INSERT INTO xnj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akamyangula, Filipi unimanyili lepi nene, hati pamonga nitamii na nyenye lukumbi lutali? Mundu yoyoha mweaniweni nene, amuweni Dadi. Uhotola wuli kujova utilangisa Dadi? ");
INSERT INTO xnj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wu, wisadika lepi kuvya nene nivii mugati ya Dadi na Dadi avi mugati ya nene? Malovi genikuvajovela. Nakugajova kwa uhotola wangu, Dadi mweavimugati ya nene, ihenga lihengu laki. ");
INSERT INTO xnj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Muganikiwa kusadika penijova nivii mugati ya Dadi na Dadi avi mugati ya nene, ngati lepi. Musadika ndava ya mahengu gala genihengili. ");
INSERT INTO xnj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Chakaka nikuvajovela, mundu yoyoha mweakunisadika nene. Ena yati ihenga mahengu gakulu hati gakulu neju, ndava nihamba kwa Dadi. ");
INSERT INTO xnj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na chochoha chemwiyupa kwa liina langu yati nikuchihenga, muni ukulu wa Dadi ulumbiwa munjila ya Mwana. ");
INSERT INTO xnj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mwakaniyupa chochoha kwa liina langu yati nikuvahengela. ");
INSERT INTO xnj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ngati mkunigana nene, myidakila mihilu yangu. ");
INSERT INTO xnj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nene yati nikumuyupa Dadi mwene yati akuvapela Mtangatila yungi, mweitama na nyenye magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mwene ndi Mpungu Msopi mweakutijovela uchakaka kumvala Chapanga, nambu vandu va mulima nakuhotola kumpokela ndava vakumlola lepi amala kummanya. Nambu nyenye mukummanya ndava isigalila na nyenye na avi mugati yinu. ");
INSERT INTO xnj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nikuvaleka lepi nyenye vakiva, yati nibwela kangi kwinu. ");
INSERT INTO xnj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lwakona lukumbi luhupi, vandu va mulima yati vakuniwona lepi kavili. Nambu nyenye yati mukuniwona, ndava nene mumi mewa na nyenye yati mwiva vamumi. ");
INSERT INTO xnj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ligono lenilo pelibwela nyenye yati mwimanya kuvya nene nivii mugati ya Dadi wangu, na nyenye mugati ya nene, mewa nene mugati yinu. ");
INSERT INTO xnj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yula mweiyidakila mihilu yangu na kuzihenga, mwene ndi mweakunigana. Yula mweakunigana nene, Dadi wangu yati akumgana mwene, mewa na nene yati nikumgana na kujilangisa kwaki.” ");
INSERT INTO xnj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda lepi yula Yuda Isikalioti, akamjovela, “Bambu, ndava kyani ugana kujilangisa kwa tete lepi kwa vandu va mulima?” ");
INSERT INTO xnj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu akayangula, “Mundu akaniganayi yati iyidakila mawuliwu gangu. Dadi wangu yati akumgana, nene na Dadi wangu yati tibwela kwaki na kutama nayu.” ");
INSERT INTO xnj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mundu mweanganigana, nakukamula mwawuliwu gangu. Malovi gemkugayuwana lepi gangu, ndi gihuma kwa Dadi mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nivajovili mambu genaga kuni nakona pamonga na nyenye.” ");
INSERT INTO xnj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nambu mtangatila, mwenuyo Mpungu Msopi, Dadi mweakumutuma kwa liina langu, yati akuvawula goha na kuvakumbusa goha genivajovili. ");
INSERT INTO xnj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nikuvalekela uteke, nikuvapela uteke wangu. Nakuvapela nyenye ngati vandu va mulima chevikita. Mkoto kuviniswa mumitima yinu amala kuvya na wogohi ");
INSERT INTO xnj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Myuwini chenijovili, ‘Nene nihamba, nambu yati niwuya kavili kwa nyenye.’ Ngati mukunigana, ngamuhekalili ndava nihamba kwa Dadi, muni mwene mkulu kuliku nene.” ");
INSERT INTO xnj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nivajovili genaga hinu kwakona kuhumila, muni pagibwela kuhumila musadikayi. ");
INSERT INTO xnj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nene nijova lepi na nyenye malovi gamahele kavili, muni Setani chilongosi wa mulima uwu ibwela. Kwa nene ihotola lepi chindu. ");
INSERT INTO xnj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nambu vandu va mulima viganikiwa kumanya nikumgana Dadi, na ndi nihenga kila chindu cheanilagizi Dadi. “Myimayi, tiwukayi penapa!” ");
INSERT INTO xnj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nene ndi mzabibu wa chakaka na Dadi wangu mwene ndi mulimaji. ");
INSERT INTO xnj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lipanda loloha mugati yangu langapambika matunda mwene akuliwusa, na lipanda loloha lelipambika akulikita livyayi bwina muni lipambikayi neju. ");
INSERT INTO xnj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nyenye mmali kunyamba ndava lilovi lenavajovili lila. ");
INSERT INTO xnj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mtama mugati yangu, na nene nitama mugati yinu. Ngati lipanda nakuhotola kupapimbika lene ngati livili lepi palihina, mewawa nyenye nakuhotola kupambika ngati mutama lepi mugati ya nene.” ");
INSERT INTO xnj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nene ndi mzabibu, na nyenye ndi mambanda. Mweitama mugati yangu, na nene nivyayi mugati yaki, mwenuyo ipambika gamahele, muni changali nene nakuhotola kuhenga chochoha. ");
INSERT INTO xnj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu ngati itama lepi mugati yangu yati itagiwa kuvala ngati lipanda chelitagiwa kuvala na kuyuma. Lipanda ngati lenilo vandu vakulinonga na kulitaga pamotu litinyikayi. ");
INSERT INTO xnj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngati nyenye mwitama mugati yangu na malovi gangu yati gitama mugati yinu, muyupa chindu chochoha chemwigana yati mwipewa. ");
INSERT INTO xnj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ukulu wa Dadi wangu ulangasika ngati nyenye mwipambika matunda gamahele na kuvya vawuliwa vangu. ");
INSERT INTO xnj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nene nikuvagana nyenye ngati Dadi cheaniganili nene. Mtama muuganu wangu. ");
INSERT INTO xnj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mwakayidakila mihilu yangu yati itama mugati yangu, ngati nene cheniyidakili malagizu ga Dadi wangu na kutama muuganu waki. ");
INSERT INTO xnj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nivajovili mambu genaga muni luheku lwangu lutama mugati yinu, na luheku lwinu lutimila. ");
INSERT INTO xnj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mihilu yangu ndi iyi: Mgananayi, ngati chenikuvagana nyenye. ");
INSERT INTO xnj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kawaka mundu mweavi na uganu mkulu neju kuliku uwu, wa mundu kuwusa wumi waki ndava ya vankozi vaki. ");
INSERT INTO xnj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nyenye vankozi vangu mwakahenga chenivalagiza. ");
INSERT INTO xnj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nakuvakemela kavili vehengaji, muni mtangatila imanya lepi cheikita mtopeswa waki. Nambu nyenye nivakemili vankozi, ndava muni goha genayuwini kwa Dadi wangu nivajovili. ");
INSERT INTO xnj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nyenye nakunihagula nene, nambu nene ndi mwenivahagwili na kuvatuma mhamba mkapambika matunda ndi mahengu gabwina gegisigalia, mwene Dadi ahotola kuvapela chindu chochoa chemwiyupa kwa liina langu. ");
INSERT INTO xnj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hinu, muhilu wangu ukulu ndi wenuwu mgananayi. ");
INSERT INTO xnj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ngati vandu va mulima vakuvayomela nyenye, mkoto kukosiwa kuvya vakuniyomela nene kwakona kuvayomela nyenye. ");
INSERT INTO xnj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ngati nyenye kuvya vandu va pamulima, mulima ngauvaganili nyenye ngati vandu vaki. Nambu ndava nyenye vandu lepi va pamulima, ndi nene nivahagwili kuhuma pamulima, ndava ya genago vandu va mulima vakuvayomela. ");
INSERT INTO xnj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mkumbuka lilovi lila lenivajovili, mtangatila lepi mkulu kuliku mtopeswa waki. Yakavya vanig'aisi nene, mewawa vakuvang'aisa na nyenye, ngati malovi gangu vagakamwili mewa vakugakamula na malovi ginu. ");
INSERT INTO xnj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nambu genaga goha vakuvakitila ndava nyenye mukunisadika nene muni mwavandu vangu, ndava vakummanya lepi yula mweanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngati nabweli lepi na kulongela navu, ngavavalangiwi lepi vakumbudila Chapanga, nambu hinu nakuhotola kujova kuvya vambudili lepi Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mundu yoyoha mweakuniyomela nene, mewawa akumyomela Dadi wangu. ");
INSERT INTO xnj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngati nihengili lepi kwavi mambu gangahengeka na mundu yungi kwavi, ngavavalangiwi lepi vambudili Chapanga, nambu hinu vagaweni gachinamtiti genihengili ndi vaniyomili nene mewawa vamuyomili Dadi wangu. ");
INSERT INTO xnj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nambu vahengili lijambu lenili muni malovi gegayandikwi mu Malagizu gatimilayi! “Vaniyomili waka!” ");
INSERT INTO xnj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Peibwela mtangatila mwenuyo mwenikumtuma kwinu kuhuma kwa Dadi, mwenuyo ndi Mpungu Msopi mweakuvajovela uchakaka kumvala Chapanga. Yati nikumtuma kwinu kuhuma kwa Dadi, mwene yati akuvajovela kunivala nene. ");
INSERT INTO xnj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nyenye mewa yati mukuvajovela vandu kunivala nene ndava muvi na nene kuhumila pakutumbula. ");
INSERT INTO xnj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nivajovili malovi genaga, muni mkoto kuleka kusadika. ");
INSERT INTO xnj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vandu yati vakuvavinga nyenye munyumba za kukonganekela Vayawudi. Kangi lukumbi lubwela mundu yoyoha mweakuvakoma nyenye yati iholalela akumhengela Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mambu genago yati vakuvakitila ndava vangammanya Dadi, wala nene. ");
INSERT INTO xnj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Hinu, nivajovili mambu ago muni lukumbi lwenulo paluhikayi mkoto kukosiwa kuvya navajovili.” “Hinu, navajovili lepi mambu genaga tangia pakutumbula ndava navili pamonga na nyenye. ");
INSERT INTO xnj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambu hinu nikumhambila mweanitumili yula, kawaka hati mmonga winu mweakunikota ‘Wihamba koki?’ ");
INSERT INTO xnj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ndava ya mambu genivajovili mitima yinu yivii ngolongondi neju. ");
INSERT INTO xnj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nambu nene nikuvajovela uchakaka, mbanga yinu nene nihamba, muni ngati nangahamba mtangatila nakubwela kwinu. Nambu nakahambayi, ndi, nikumtuma kwinu. ");
INSERT INTO xnj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mwene peibwela yati akuvalangisa vandu va mulima kuvya vaumanyili lepi uchakaka kuvala kumbudila Chapanga, na kuyidakiliwa palongolo ya Chapanga na kuhamuliwa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Vaumanyi lepi uchakaka kumvala kumbudila Chapanga muni vanisadiki lepi nene. ");
INSERT INTO xnj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Vaumanyili lepi uchakaka ndava ya vandu kuyidakiliwa palongolo ya Chapanga, muni nihamba kwa Dadi, na nyenye nakuniwona kavili. ");
INSERT INTO xnj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Vaumanyili lepi uchakaka kumvala Chapanga kuvahamula vandu, muni mkulu wa mulima uwu amali kuhamuliwa.” ");
INSERT INTO xnj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nakona nivii nagu gamahele gakuvajovela, ndi kwa hinu muhotola lepi kugakamula goha. ");
INSERT INTO xnj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nambu peibwela mwene Mpungu Msopi mweakuvajovela uchakaka ndava ya Chapanga, yati akuvalongosa muuchakaka woha. Yati ijova lepi kwa uhotola waki mwene, nambu yati ijova geagayuwini kuhuma kwa Dadi na kuvajovela gegibwela. ");
INSERT INTO xnj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mwene yati akunipela ukulu nene ndava muni yati akuvamanyisa gegihuma kwa nene gala. ");
INSERT INTO xnj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Goha geavinagu Dadi ndi ga nene, ndi nijova kuvya Mpungu Msopi mwenuyo yati akuvajovela gegihuma kwa nene.” ");
INSERT INTO xnj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Lusigalili lukumbi luhupi nyenye nakuniwona, na kangi lukumbi luhupi kavili yati mukuniwona!” ");
INSERT INTO xnj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Vawuliwa vaki vangi vakakotana, “Mana yaki kyani? Peakutijovela, lwakona lukumbi luhupi nakumuwona na kavili lukumbi luhupi yati mukuniwona na kangi ijova ndava muni nihamba kwa Dadi!” ");
INSERT INTO xnj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hinu vakavya mkukotana, “Lilovi lenili leijova, lusigalili lukumbi luhupi ndi kyani? Timanyi lepi ijova kyani.” ");
INSERT INTO xnj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu amanyili kuvya vigana kumkota, mwene akavajovela, wu, mkotana ndava ya gala genavajovili. Lwakona lukumbi luhupi na nyenye nakuniwona, na kangi lukumbi luhupi yati mukuniwona kavili? ");
INSERT INTO xnj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Chakaka nikuvajovela, nyenye yati muvemba na kulola mvinisu mumtima winu, nambu vandu va mulima yati viheka. Mwalavya ngolongondi nambu ngolongondi yati ying'anamuka na kuvya luheku. ");
INSERT INTO xnj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mdala peiveleka ivya ngolongondi ndava lukumbi lwa mvinisu luhikili, nambu akamala kuveleka mwana ikosiwa mvinisu wula, ndava ya luheku lwa mwana avelekiwi pamulima. ");
INSERT INTO xnj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mewawa nyenye mwava ngolongondi hinu, nambu nalavabwelela kavili, na nyenye luheku yati lumema mu mitima yinu kawaka mundu mweiwusa luheku lwinu. ");
INSERT INTO xnj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ligono lenilo nakuniyupa chochoha. Chakaka nikuvajovela, chindu chochoha chemukumuyupa Dadi kwa liina langu yati akuvapela. ");
INSERT INTO xnj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka hinu nakumuyupa chochoha kwa liina langu. Myupa na nyenye yati mwipewa, muni luheku lwinu lutimila. ");
INSERT INTO xnj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nivajovili mambu genago kwa luhumu. Nambu lukumbi lubwela penapo nakujova kavili kwa luhumu, ndi nikuvajovela hotohoto kumvala Dadi, ");
INSERT INTO xnj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ligono ilo, yati muyupa kwa liina langu, amala nikuvajovela lepi kuvya yati niyupa kwa Dadi ndava yinu, ");
INSERT INTO xnj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ndava muni Dadi mwene akuvagana. Akuvagana ndava nyenye mukunigana nene na kunisadika, kuvya nihumili kwa Dadi. ");
INSERT INTO xnj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nene nihumili kwa Dadi, nikabwela pamulima apa, kavili nikuuleka mulima na kuwuya kwa Dadi.” ");
INSERT INTO xnj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Vawuliwa vaki vakamjovela, “Lola! Hinu ulongela hotohoto, changali kujova kwa miluhumu. ");
INSERT INTO xnj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Hinu timanyili kuvya veve ukugamanya mambu goha, amala kawaka ndava ya mundu kukota chindu, ndi tisadika kuvya wahumili kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akavayangula, “Wu, hinu mwisadika? ");
INSERT INTO xnj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nambu lukumbi luhika, kangi lumali kuhika, ndi mwavoha nyenye yati mupechengana kila mmonga kwaki, na kunileka namwene. Nambu nene nakuvya namwene, ndava muni Dadi avi pamonga na nene. ");
INSERT INTO xnj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nivajovili mambu genaga, muni mvya na uteke mukuwungana na nene. Pamulima yati mwipata mang'ahiso, nambu mkangamala mumitima! Nene niuhotwili mulima!” ");
INSERT INTO xnj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu peamali kujova genago, akalolokesa kunani kwa Chapanga, akajova, “Dadi, lukumbi luhikili! Mpela ukulu Mwana waku muni namwene Mwana akupela ukulu.” ");
INSERT INTO xnj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ndava muni wampeli Mwana waku uhotola kwa vandu voha muni vandu venavo veumpeli avapelayi wumi wa magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Wumi wa magono goha gangali mwishu ndi uwu, vandu vakumanya veve, mweuvi wamwene Chapanga wa chakaka, na kummanya Yesu Kilisitu mweumtumili. ");
INSERT INTO xnj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nene niulangisi ukulu pamulima apa, nimali lihengu lila lewanipeli nihengayi. ");
INSERT INTO xnj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hinu, Dadi unipela ukulu palongolo yaku, ukulu wulawula wenavi nawu kwakona kuwumbwa mulima. ");
INSERT INTO xnj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nikukitili umanyikanayi na vandu vala vewanipelili kuhuma pamulima. Vandu vevavi vaku, veve wanipeli vavyai vangu, navene valikamwili lilovi laku. ");
INSERT INTO xnj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hinu vamanyili kuvya kila chewanipeli chihumili kwaku. ");
INSERT INTO xnj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nene nivapeli ujumbi wula weunipeli, vene vaupokili, vamanyili chakaka nihumili kwa veve, na vasadiki kuvya veve ndi mweunitumili. ");
INSERT INTO xnj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nikuvayupila avo, nikuvayupila lepi vandu va mulima, nambu nivayupila vala veunipelili, muni ndi vaku.” ");
INSERT INTO xnj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Goha genivii nagu ndi gaku, na gaku ndi gangu, na ukulu wangu, ulolikini pagati ya avo weunipeli. ");
INSERT INTO xnj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na hinu nivii lepi kangi pamulima, nambu vene vavi pamulima. Dadi Msopi! Kwa makakala ga liina laku leunipeli, chondi uvavikila ulonda muni vavyai chindu chimonga ngati chetivili tete tavamonga. ");
INSERT INTO xnj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panakavi pamonga navu, nene navavikii ulonda kwa makakala ga liina laku leunipeli, nene navavikii ulonda, kawaka mmonga wavi mweayagili, muni yula mmonga mweahaguliwi kuyaga, muni Mayandiku Gamsopi gatimilayi. ");
INSERT INTO xnj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na hinu nibwela kwa veve, malovi aga nijovili pamulima, muni vamema luheku lwangu mumitima yavi. ");
INSERT INTO xnj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nene navapeli ujumbi waku, na vandu va pamulima vakavayomela, ndava vene lepi va pamulima, ngati mewa chenivii nene lepi wa pamulima. ");
INSERT INTO xnj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Niyupa lepi uvawusa pamulima, nambu niyupa uvavikila ulonda na yula mhakau ndi Setani. ");
INSERT INTO xnj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Vene lepi va pamulima, ngati mewa chenivii nene lepi wa pamulima. ");
INSERT INTO xnj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uvakita vandu vaku vavya vamsopi kupitila uchakaka waku, na lilovi laku ndi chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngati veve chawanitumili nene pamulima, mewawa na nene nivatumili vene pamulima. ");
INSERT INTO xnj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ndava yavi na nene namwene nikujiwusa kwaku, muni navene vajiwusayi kwaku muchakaka. ");
INSERT INTO xnj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nikuvayupila lepi venava ndu, nikuvayupila mewa na vala vevakunisadika kupitila ujumbi wavi.” ");
INSERT INTO xnj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Niyupa muni voha vavyai chindu chimonga. Dadi, niyupa vavyai mugati yitu ngati veve cheuvi mugati yangu na nene mugati yaku. Nivayupili vene kuvya chindu chimonga muni mulima usadika kuvya veve ndi wanitumili. ");
INSERT INTO xnj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nene nivapeli ukulu wulawula, wewanipeli nene, muni vavyai chindu chimonga ngati tete chetivii mmonga. ");
INSERT INTO xnj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nene nivyai mugati yavi, na veve uvyai mugati yangu. Niyupa vakamilika na chindu chimonga muni vandu va mulima vapata kumanya kuvya veve ndi mwewanitumili. Ukavagana vene ngati chawaniganili nene. ");
INSERT INTO xnj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Dadi, nigana venavo veunipelili vavyai pamonga na nene pala penivya nene, muni valolayi ukulu wangu weunipelili, ndava muni waniganili kwakona mulima kuwumbwa. ");
INSERT INTO xnj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dadi Mbwina! Vandu va pamulima nakukumanya, nambu nene nikumanyili. Navene vakumanyili kuvya veve ndi mweunitumili. ");
INSERT INTO xnj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nikukitili vakumanya veve na niyendelela kukita mewa muni uganu weuvi nawu kwangu uvya mugati yavi, na nene nivya mugati yavi.” ");
INSERT INTO xnj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu peamali kujova genago, akakupuka kamfuleni kekikemelewa Keduloni, pamonga na vawuliwa vaki. Pandu apo pavi na lidimba, Yesu akayingila pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, mweamng'anamukili Yesu, apamanyili pandu penapo, ndava Yesu ahambayi pamahele Yesu akonganiki na vawuliwa vaki kwenuko. ");
INSERT INTO xnj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hinu, Yuda atoli msambi wa manjolinjoli va Chilumi na valonda va Nyumba ya Chapanga, kuhuma kwa vakulu va vateta na Vafalisayu, akabwela navu palidimba kuni vagegi hahi na lumuli na migoha na vibonga. ");
INSERT INTO xnj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, kuni imanya gegakumkolela, akavahegelela, akavakota, “Mukumulonda yani?” ");
INSERT INTO xnj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Vene vakamyangula, “Yesu Mnazaleti!” Yesu akavajovela, “Nene, ndi mwene.” Yuda mweakumung'anamukila yula ayimili bahapo pamonga navu. ");
INSERT INTO xnj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu peavajovili, “Nene ndi mwene.” Vakawuya mumbele vakagwa pahi. ");
INSERT INTO xnj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mwene akavakota kavili, “Mukumulonda yani?” Vakamyangula, “Yesu Mnazaleti!” ");
INSERT INTO xnj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akavayangula, “Nimali kuvajovela kuvya mwene ndi nene, ndava mukunilonda nene muvaleka ava vahamba.” ");
INSERT INTO xnj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ajovili genago muni gatimilayi geajovili gala, “Dadi vala vewanipelili nakumyagisa hati mmonga.” ");
INSERT INTO xnj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petili avi na upanga, ndi akauholomola, na kumdumula likutu la kulyela mtangatila wa Mteta Mkulu. Mtumisi mwenuyo liina laki Maluko. ");
INSERT INTO xnj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu akamyangula, Petili, “Wuyisa upanga muchihaku. Wu, chikombi cha mang'ahiso cheanipeli Dadi nikotoka kunywa?” ");
INSERT INTO xnj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Msambi wa manjolinjoli va Chilumi pamonga na vakulu vavi, na valonda va Vayawudi vamkamwili Yesu, vakamkunga, ");
INSERT INTO xnj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","na kumupeleka hoti kwa Anasi, Anasi avi mkohanu wa Kayafa mweavi Mteta Mkulu mwaka wenuwo. ");
INSERT INTO xnj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ndi yula mweavajovili vachilongosi va Vayawudi kuvya mbanga mundu mmonga afwayi ndava ya vandu. ");
INSERT INTO xnj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petili pamonga na muwuliwa yungi vamlandili Yesu. Muwuliwa mwenuyo amanyikini kwa Mteta Mkulu, akayingila pamonga na Yesu mu luvanja lwa Mteta Mkulu. ");
INSERT INTO xnj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nambu Petili ayimili kuvala ya mlyangu. Yula muwuliwa yungi, mweamanyikini kwa mteta mkulu, akahuma kuvala na kujova na msikana mlonda wa mlyangu, akamyingisa Petili mugati. ");
INSERT INTO xnj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Msikana mlonda wa mlyangu, akamkota Petili, “Wu, na veve mmonga wa vawuliwa va mundu uyu?” Petili akamjovela, “Nene lepi!” ");
INSERT INTO xnj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Vatumisi na valonda vayota motu ndava kwavi na mbepu. Petili namwene ayimili na vayaki kuyota motu. ");
INSERT INTO xnj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mteta mkulu akamkota Yesu kumvala mawuliwu gaki pamonga na vawuliwa vaki. ");
INSERT INTO xnj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akamyangula, “Nijovili na kila mundu hotohoto ligono kwa ligono. Magono goha navawulili munyumba za kukonganekela Vayawudi na mu Nyumba ya Chapanga, pandu pevikonganeka Vayawudi voha, na nakujova chamfiyu. ");
INSERT INTO xnj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ndava kyani ukunikota nene? Uvakota vala vevayuwini navajovili kyani. Vene vimanya chenavajovili.” ");
INSERT INTO xnj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Peamali kujova genago mlonda mmonga mweayimili papipi, akampamanda Yesu, akamjovela, “Wu, ndi chaukumyangula Mteta Mkulu?” ");
INSERT INTO xnj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu akamyangula, “Ngati nijovili uhakau langisa uhakau wene, nambu ngati nijovili chakaka, ndava kyani ukunitova?” ");
INSERT INTO xnj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hinu, Anasi ampeliki Yesu kwa Kayafa kuni akungiwi, mweavi mteta mkulu. ");
INSERT INTO xnj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petili ayimili penapo kuyota motu. Hinu vakamkota, “Wu, veve mmonga wa vawuliwa vaki?” Mwene akabela na kujova, “Nene lepi!” ");
INSERT INTO xnj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mmonga wa vatumisi wa Mteta Mkulu, muyaki yula mweadumuliwi likutu na Petili, akamkota “Wu, nene nakuwene lepi veve kulidimba pamonga naku?” ");
INSERT INTO xnj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kangi Petili akabela kavili, bahapo lijogolo likavika. ");
INSERT INTO xnj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kangi vakamtola Yesu kuhuma kwa Kayafa, vampeliki kunyumba ya chinkosi. Yavi hamba kucha, muni vanyambasika palongolo ya Chapanga. Vahotola kulya Pasaka vene vayingili lepi munyumba ya chilongosi wa Loma vakotoka kuhakaswa. ");
INSERT INTO xnj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilatu avahumila chakuvala, akavakota, “Lijambu loki lemukumtakila mundu uyu?” ");
INSERT INTO xnj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Vakamyangula, “Ngati mwenuyu kuvya abudili lepi ngatimletili lepi kwaku.” ");
INSERT INTO xnj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu akavajovela, “Ena, mumtola mumuhamula mwavene, kulandana na malagizu ginu.” Vayawudi vakamyangula, “Tete tivii lepi na uhotola wa kumuhamula mundu yoyoha afwayi.” ");
INSERT INTO xnj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yakitiki ago gatimilayi malovi geajovili Yesu kulangisa yati ifwa namuna yoki. ");
INSERT INTO xnj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatu akayingila kavili munyumba yaki, akamkemela Yesu na kumkota. “Ati veve ndi Nkosi wa Vayawudi?” ");
INSERT INTO xnj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu akamyangula, “Wu, genago maholo gaku amala vandu vangi vakujovili kunivala nene?” ");
INSERT INTO xnj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu akayangula, “Mwe! Myawudi nene? Vandu vaku na vakulu va kuteta vakuletili kwa nene. Uhengili kyani?” ");
INSERT INTO xnj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akayangula, “Unkosi wangu lepi wa mulima uwu. Ngati kuvya unkosi wangu wa mulima wenuwu, vandu vevamlanda Yesu ngavanikengelili, vachilongosi va Vayawudi ngavanikamwili lepi. Nambu hinu unkosi wangu lepi wa penapa.” ");
INSERT INTO xnj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatu akamjovela, “Hinu veve ndi Nkosi?” Yesu akayangula, “Veve ndi ujova kuvya nene ndi Nkosi. Ndava yeniyo nene nivelikiwi na nibweli pamulima kuvajovela vandu uchakaka. Mundu yeyoha wa uchaka akuniyuwanila.” ");
INSERT INTO xnj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatu akamkota, “Uchakaka ndi chindu kiki?” Pilatu peamali kujova ago, akavahambila kavili vachilongosi va Chiyawudi kuvala, “Akavajovela nene nichiwene lepi chindu cheabudili. ");
INSERT INTO xnj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nambu ndi mvelu winu nene kuvadindulila, muchifungu mundu mmonga lukumbi lwa Pasaka. Hinu mwigana nivadindulila Nkosi wa Vayawudi?” ");
INSERT INTO xnj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Penapo vakayangula. “Mwe! Lepi mwenuyo mdindulila Balaba!” Balaba avi mundu mweinyaga vandu vindu. ");
INSERT INTO xnj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kangi, Pilatu akalagiza vamtola Yesu na kumtova michapilu. ");
INSERT INTO xnj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Vala manjolinjoli vakabota njingwa ya minga, vakamuwalika kumutu, vakamuwalika nyula ya chinkosi langi ya zambalau. ");
INSERT INTO xnj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Vakavya kumbwelela palongolo yaki na kujova, “Tikuwoni, Nkosi wa Vayawudi!” Kuni vakumpamanda. ");
INSERT INTO xnj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu akahuma kuvala kavili, akaujovela msambi wula, “Lola, nikumgotola mundu uyu kwinu, muhotola kumanya kuvya nene nichiwene lepi chindu chochoha cheabudili cha kumuhamula.” ");
INSERT INTO xnj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hinu, Yesu, akahuma kuvala kuni awalili njingwa ya minga na nyula ya chinkosi. Pilatu akavajovela, “Mlola! Mundu mwene ndi uyu.” ");
INSERT INTO xnj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Vakulu va kuteta na valonda pavamuwene vakayangula. “Mvambayi pamsalaba! Mvambayi pamsalaba!” Pilatu akavajovela. “Mwavene mumtola hinu, mukamvamba muni nene nichiweni lepi chindu cheabudili.” ");
INSERT INTO xnj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Vayawudi vakamyangula, “Tavete tivii nagu Malagizu, na malagizu gitu gijova, yikumgana afwayi, ndava mwene ajidetekisi kuvya Mwana wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu peagayuwini malovi ago, akayogopa neju. ");
INSERT INTO xnj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kangi Pilatu akayingila munyumba ya unkosi, akamkota Yesu, “Veve uhumili koki?” Nambu Yesu amyangwili lepi chindu. ");
INSERT INTO xnj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatu akamjovela, “Wu, wibela kulongela na nene? Wu, umanyi lepi kuvya nene nihotola kukudindulila na nihotola kulagiza uvambiwa pamsalaba?” ");
INSERT INTO xnj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akamyangula, “Ngauvi lepi na uhotola panani yangu changali kupewa na Chapanga. Ndava yeniyo yula mweaniletili kwaku ambudili neju.” ");
INSERT INTO xnj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kutumbula penapo, Pilatu alonda njila ya kumlekekesa Yesu, nambu Vayawudi vakaywanga. “Ngati umlekekisi mundu uyu, veve nkozi lepi wa nkosi wa ku Loma, mundu yoyoha mweajikita kuvya nkosi akumpinga nkosi mkulu wa Loma!” ");
INSERT INTO xnj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hinu, Pilatu peayuwini malovi ago akamuhumisa Yesu kuvala, akatama pachigoda cha uhamula, pandu pepikemelewa “Luvanja lwelutengenizwi kwa maganga.” Amala kwa Chiebulania Gabata. ");
INSERT INTO xnj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yavi lukumbi lwa muhi, ligono la kutendelekela Pasaka. Pilatu akavajovela Vayawudi, “nkosi winu ndi uyu!” ");
INSERT INTO xnj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Vene vakaywanga, “Mkomayi! Mkomayi! Mvambayi pamsalaba?” Pilatu akavakota, “Wu, nimvamba pamsalaba nkosi winu?” Vakulu va kuteta vakayangula, “Tete tivii lepi na nkosi yungi nambu nga nkosi wa ku Loma!” ");
INSERT INTO xnj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hinu, Pilatu akamgotola Yesu mumawoko gavi muni vamvambayi pamsalaba. Manjolinjoli, vakamtola Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu akahuma kuni agegili msalaba waki, mbaka pandu pepikemelewa “Libangu la Mutu.” Kwa Chiebulania pikemelewa Goligota. ");
INSERT INTO xnj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Penapo ndi pavamvambili pamsalaba, na pamonga nayu vavavambili pamisalaba yavi vandu vangi vavili mmonga upandi wa kulyela na yungi upandi wa kumangeya, Yesu ndi pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu akayandika likokoso pachibau akakivika panani ya msalaba, akayandika, “Yesu Mnazaleti Nkosi wa Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hinu, Vayawudi vamahele vasomili likokoso ilo, muni pandu peavambiwi Yesu pamsalaba pavi papipi na muji. Kangi likokoso lenilo layandikwi kwa Chiebulania na Chilatini na Chigiliki. ");
INSERT INTO xnj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hinu, Vakulu va kuteta vakamjovela Pilatu, “Kotoka kuyandika. ‘Nkosi wa Vayawudi,’ Nambu mundu uyu ajovili kuvya, ‘Nene ndi Nkosi wa Vayawudi.’” ");
INSERT INTO xnj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu akayangula, “Geniyandiki gala nimali, kuyandika!” ");
INSERT INTO xnj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Manjolinjoli pevamali kumvamba Yesu pamsalaba, vakazitola nyula zaki, vakavika malundu mcheche, kila mmonga na lilundu laki. Mewawa vakatola na lijoho laki la unkosi, lijoho ilo labotiwi kwa chipandi chimonga ndu, changali kutotewa. ");
INSERT INTO xnj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Manjolinjoli vala, vakajovesana. “Tikotoka kuyipapula, muni titova kula yati livya la yani.” Lijambu lenili lahengiki muni Mayandiku Gamsopi gegijova, “Vagavini nyula zangu, Na nyula yangu vakayitovela kula.” Ndi, chevahengili vala manjolinjoli. ");
INSERT INTO xnj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Papipi na msalaba wa Yesu vayimili nyina waki Yesu, na mlumbu wa nyina waki na Maliya mdala wa Kileopa, na Maliya Magidala. ");
INSERT INTO xnj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu peamuwene nyina waki, na papipi yaki ayimili muwuliwa yula mweamganili, akamjovela nyina waki. “Mau, Lola, mwenuyo ndi mwana waku.” ");
INSERT INTO xnj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kangi akamjovela muwuliwa yula. “Lola, mwenuyo ndi nyina waku.” Na kutumbula lukumbi lula muwuliwa yula akamtola atama kunyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu amanyili kuvya goha gamali kutimila, muni Mayandiku Gamsopi gatimilayi, akajova, “Niyuana njota.” ");
INSERT INTO xnj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Penapo pavi na nkele weumemili divayi yivavanu. Hinu vakajwiga litonji mudivayi yivavanu vakavika mulungoda lwa mkongo weukemiwa hisopo, vakamvikila pamlomo. ");
INSERT INTO xnj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu peamali kupewa divayi yivavanu yila, akajova, “Goha gatimili!” Kangi akagundama mutu, akafwa. ");
INSERT INTO xnj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yavi ijumaa, ligono la kutendelekeha. Ndava muni, higa yikoto kutama pamsalaba Ligono la Kupumulila, muni ligono ilo lavi likulu kwa Vayawudi. Hinu vachilongosi va Vayawudi vakamuyupa Pilatu, magendelu ga vala vevavambiwi pamsalaba gadenyewayi na higa zavi ziwusiwayi. ");
INSERT INTO xnj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Manjolinjoli vakahamba, vakayidenya magendelu ga mundu wa upandi wa kumangeya na yula wa upandi wa kulyela vevavambiwi pamisalaba pamonga na Yesu vala. ");
INSERT INTO xnj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nambu pavamhikili Yesu vamkoli amali kufwa, ndi vamdenyili lepi magendelu. ");
INSERT INTO xnj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nambu mmonga wavi amuhomili Yesu muluvafu na mgoha, bahapo yikahuma ngasi na manji. ");
INSERT INTO xnj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mwene yula mwealoli lijambu lenilo, alijovili muni na nyenye musadika. Na aga geajovili ndi uchakaka, kavili mwene imanya kuvya ijova chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lijambu lenili lahengiki muni Mayandiku Gamsopi gatimila. “Kawaka hati lijege laki limonga lelidenyewa.” ");
INSERT INTO xnj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mewawa Mayandiku Gamsopi gijova. “Vakumlola yula mwevamuhomili.” ");
INSERT INTO xnj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagamaliki genago, Yosefu mkolonjinji wa Alimatei, akamuyupa Pilatu kuyihulusa higa ya Yesu kuhuma pamsalaba. Yosefu avi mulanda waki Yesu, nambu chamfiyu, muni ayogwipi vachilongosi wa Vayawudi. Ndi Pilatu akamyidakila, Yosefu ahambili kuyiwusa higa ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yosefu alongosini na Nikodemu, mweamuhambili Yesu kimihi, akabwela agegili mahuta gegikemelewa manemane gegahangisini na ubani vibaba selasini. ");
INSERT INTO xnj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hinu voha vavili vakayitola higa ya Yesu, na kuyitindisila nyula ya msopi pamonga na mahuta ago ngati cheyavili mivelu ya Vayawudi pakuvika higa mulitinda. ");
INSERT INTO xnj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pandu pala pevamvambili Yesu pamsalaba, pavi na lidimba palidimba lenilo pavi na litinda la mupya lelavi lakona kumvika mundu yoyoha mugati yaki. ");
INSERT INTO xnj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndava ya mahengu ga Vayawudi ga kutendelekeha Ligono la Kupumulila, ndava litinda lenilo lavi papipi vakamuvika Yesu mwenumo. ");
INSERT INTO xnj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lukela hamba kucha Dominika, kwakona chitita, Maliya mkolonjinji wa Magidala akahamba kulitinda, na kulola liganga liwusiwi pamlyangu wa litinda. ");
INSERT INTO xnj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hinu, akajumba kuhamba kwa Simoni Petili na yula muwuliwa yungi, Yesu mwamganili, akavajovela, “Vamuwusili Bambu mulitinda, nakumanya kwevamvikili.” ");
INSERT INTO xnj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petili na muwuliwa yungi yula vakahamba kulitinda. ");
INSERT INTO xnj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Voha vavili, vakajumba kuhamba, yungi yula ajumbili kanyata neju kuliku Petili, akalongolela kuhika kulitinda. ");
INSERT INTO xnj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Peagundimi na kulingulila, ayiwene nyula ya msopi, nambu nakuyingila mugati. ");
INSERT INTO xnj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petili namwene, akabwela akumulanda akayingila mu litinda, mwenumo ayiwene nyula za msopi zila, ");
INSERT INTO xnj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","chitambala chevamtindisili Yesu kumutu chila. Chitambala chenicho nakuvikwa pamonga na nyula ya msopi yeniyo, muni chagunyiwi na kuvikwa pandu pene. ");
INSERT INTO xnj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kangi muwuliwa yungi yula mwealongolili kuhika kulitinda, akayingila mugati akalola na kusadika. ");
INSERT INTO xnj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vavi vakona kumanya, Mayandiku Gamsopi gegijova Yamganili kuyuka. ");
INSERT INTO xnj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hinu, Vawuliwa vala vakawuya kunyumba. ");
INSERT INTO xnj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliya ayimili kuvala ya litinda, kuni ivemba. Na peayendalili kuvemba, avi mukugundama na kulingulila mu litinda, ");
INSERT INTO xnj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","avawene Vamitumu va kunani kwa Chapanga vavili vevawalili nyula za msopi vatamili pala peyavili higa ya Yesu mmonga kumutu na yungi kumagendelu. ");
INSERT INTO xnj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Vamitumu vala vakamkota, “Mau, ndava kyani wivemba?” “Maliya akavajovela, vamtoli Bambu wangu nakumanya kwevamvikili!” ");
INSERT INTO xnj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maliya peamalili kujova genago, ang'anamwiki mumbele, amuwene Yesu ayimili penapo, nambu amanyili lepi kuvya ndi Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu akamkota, “Mau, ndava kyani uvemba? Ukumlonda yani?” Maliya, akahololela kuvya mwenuyo myimilila lidimba, akamjovela, “Mtopeswa, ngati veve umtolili nijovela kweumvikili, na nene yati nikumtola.” ");
INSERT INTO xnj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu akamjovela, “Maliya!” Mwene Maliya akang'anamuka, akamjovela kwa Chiebulania, “Laboni.” Mana yaki “Muwula.” ");
INSERT INTO xnj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu akamjovela, “Kotoka kunikamula, nakona kuhamba kunani kwa Dadi. Nambu hamba kwa valongo vangu uvajovela, nihamba kunani kwa Dadi wangu na Dadi winu, Chapanga wangu na Chapanga winu.” ");
INSERT INTO xnj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maliya wa Magidala, akahamba kuvajovela mambu gala vawuliwa, kuvya amuwene Bambu, ndi amjovili genago. ");
INSERT INTO xnj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yavili kimihi ya ligono lenilo la Dominika. Vawuliwa vakonganiki pamonga mugati ya nyumba, kuni milyangu yavi yidindiwi, ndava ya kuvayogopa vachilongosi va Vayawudi. Yesu akabwela, akayima pagati yavi, akavajovela, “Uteke uvya na nyenye!” ");
INSERT INTO xnj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Peamali kujova genago, akavalangisa mawoko gaki na luvafu lwaki. Ndi vawuliwa venavo vakasangaluka neju kumlola Bambu. ");
INSERT INTO xnj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu akavajovela kavili, “Uteke uvya na nyenye! Ngati Dadi cheanitumili nene, na nene nikuvatuma nyenye.” ");
INSERT INTO xnj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Peamali kujova genago, akavapulila na kuvajovela, “Mpokela Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Vandu vemukuvalekekesa kumbudila Chapanga kwavi, yati vilekekeswa, na vandu mwavangalekekesa, yati vilekekeswa lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi mmonga wa vawuliwa kumi na vavili vala, mweikemiwa mapaha, avi lepi pamonga nawu lukumbi Yesu peabweli. ");
INSERT INTO xnj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vawuliwa vangi vala, vakamjovela, “Timuwene Bambu.” Tomasi akavajovela, “Ngati nakugawona mavamba ga misumali mu mawoko gaki na kuvika lukonji lwangu mu mavamba ago na kuvika chiwoko changu muluvafu lwaki, yati nisadika lepi.” ");
INSERT INTO xnj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Magono nane gegagelekili, vawuliwa vavi pamonga mugati mula, na Tomasi namwene avi. Milyangu yavi hidindiwi, nambu Yesu akabwela, akayima pagati yavi, akajova, “Uteke uvya na nyenye!” ");
INSERT INTO xnj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kangi akamjovela Tomasi, “Vika lukonji lwaku ulola mawoko gangu, leta chiwoko chaku mu luvafu lwangu. Leka mtahu, nambu usadikayi!” ");
INSERT INTO xnj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi akamyangula, “Bambu wangu na Chapanga wangu!” ");
INSERT INTO xnj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu akavajovela, “Ndava uniwene nene ndi usadiki, vamotisiwa vala vanganiwona nambu vanisadiki.” ");
INSERT INTO xnj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu akitili gachinamtiti gangi gamahele, palongolo ya vawuliwa vaki, nambu gayandikwi lepi muchitabu ichi. ");
INSERT INTO xnj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nambu zenizi zeziyandikwi, muni mpata kusadika kuvya Yesu ndi Kilisitu Msangula, Mwana wa Chapanga, ndava ya kusadika mpata na wumi kwa liina laki. ");
INSERT INTO xnj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagamaliki genago, Yesu akavahumila kavili vawuliwa vaki pamuhana ya nyanja Tibelia. Avahumili naha, ");
INSERT INTO xnj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petili, Tomasi mweikemewa Mapaha, na Natanyeli mkolonjinji wa Kana ya ku Galilaya, vana vavili va Zebedayo na vawuliwa vaki vangi vavili, vakavya voha pamonga. ");
INSERT INTO xnj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petili akavajovela, “Nihamba kulova somba.” Vene vakamjovela, “Tete tilongosana na veve.” Vakahamba, vakakwela muwatu, nambu kilu yila nakupata chindu. ");
INSERT INTO xnj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hamba kucha, Yesu ayimili kumwambu ya nyanja, nambu vawuliwa vamanyili lepi kuvya avi Yesu. ");
INSERT INTO xnj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu akavakota, “Vankozi, mupatili lepi somba?” Vakamyangula, “Lepi! Kawaka.” ");
INSERT INTO xnj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu akavajovela, “Muhelesa ngwanda upandi wa kulyela wa watu na nyenye yati mwipata somba.” Ndi vakazihelesa ngwanda, nambu hinu nakuhotola kuhuta kavili ndava ya somba zamahele. ");
INSERT INTO xnj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kangi muwuliwa yula, Yesu mweamganili neju, akamjovela Petili, “Ndi Bambu!” Simoni Petili peayuwini kuvya ndi Bambu, akajikunga nyula yaki ya kuvala muni ahulili, akajitaga mumanji. ");
INSERT INTO xnj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nambu vawuliwa vangi vala vabwelili kumbwani na watu kuni vihuta ngwanda zezimemili somba, vavi lepi kutali na pandumba, ndi vavi utali wa mita miya yimonga kuhuma mu mkingisa. ");
INSERT INTO xnj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pavahikili pandumba wauwene motu wa makalakala, wiyaka, na panani yaki pavikiwi somba na libumunda. ");
INSERT INTO xnj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu akavajovela, “Mgava somba zingi mleta penapa zemlovili.” ");
INSERT INTO xnj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petili akayingila muwatu, akahuta mbaka kundumba ngwanda yila yeyimemili somba zivaha miya yimonga na makumi mhanu na zidatu. Pamonga wamemili somba zamahele, nambu ngwanda yadawiki lepi. ");
INSERT INTO xnj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu akavajovela “Mbwela mlawuka.” Kawaka hati mmonga wavi. Mwealingili kumkota. “Veve ndi wayani,” Vammanyili kuvya Bambu. ");
INSERT INTO xnj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu akabwela, akatola, libumunda akavapela, akakita mewawa na somba zila. ");
INSERT INTO xnj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yeniyi yavi mala ya datu Yesu kuvahumila vawuliwa vaki peamali kuyuka. ");
INSERT INTO xnj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pevamali kulya, Yesu akamkota Simoni Petili, “Simoni mwana wa Yohani! Wu, ukunigana nene kuliku ava?” Mwene akayangula, “Ena, Bambu, umanyili kuvya nene nikukugana.” Yesu akamjovela, “Dima vana mambelele vangu.” ");
INSERT INTO xnj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kavili akamjovela, “Simoni mwana wa Yohani! Wu, ukunigana?” Petili akamyangula, “Ena, Bambu, umanyili kuvya nikukugana.” Yesu akamjovela “Dima mambelele gangu.” ");
INSERT INTO xnj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu akamkota mala ya datu, “Simoni mwana wa Yohani! Wu, ukunigana?” Penapo Petili akavya ngolongondi ndava amkotili mala ya datu. “Ukunigana?” Akamjovela, “Bambu, wamwene umanyili kila chindu, umanyili kuvya nene nikukugana.” Yesu akamjovela, “Dima mambelele gangu! ");
INSERT INTO xnj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Chakaka nikukujovela, pawavi msongolo wayovalili kujitendelekeha wamwene na kuhamba kwewigana. Nambu pawivya mgogolo wiyinula mawoko gaku, mundu yungi ndi yati akukunga na kuhamba kwe wangagana kuhamba.” ");
INSERT INTO xnj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu ajovili genago, kulangisa namuna Petili cheifwa na kumpela ukulu Chapanga. Kangi akamjovela Petili, “Nilanda.” ");
INSERT INTO xnj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petili akang'anamuka, amuwene muwuliwa yula mweaganiwi na Yesu, akumlanda mweneuyo ndi yula mweatamili papipi neju na Yesu lukumbi pevalyayi na kumkota, “Bambu ndi yani mweakukung'anamukila?” ");
INSERT INTO xnj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hinu, Petili peamuwene mwenuyo, akamkota Yesu, “Bambu, mundu uyu chikumuhumila kyani?” ");
INSERT INTO xnj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu akayangula, “Ngati nigana asigalila mbaka penibwela, chikuvala kyani? Veve unilanda nene.” ");
INSERT INTO xnj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Malovi ago, gadandasiki pagati ya valongo vevakumsadika Kilisitu kuvya muwuliwa mwenuyo yati ifwa lepi. Nambu Yesu amjovili lepi muwuliwa yula ifwa lepi, nambu ajovili, “Ngati nigana asigalila mbaka panibwela yikukuvala kyani?” ");
INSERT INTO xnj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mwenuyu ndi muwuliwa, mwealoli mambu ago na kugayandika. Tete timanyili ajovili chakaka. ");
INSERT INTO xnj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gavi mambu gangi gamahele geagahengili Yesu. Ngati goha ngagiyandikwayi, niholela hati mulima woha nakuvya pandu pa kuvika hitabu yeyiyandikwi. Ena.");
INSERT INTO xnj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mlongo Teofili, muchitabu cha kutumbula nayandiki kugavala mambu goha, Yesu geagahengili na kugawula kwakona kutumbula lihengu laki, ");
INSERT INTO xnj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka ligono lila Yesu peatoliwi kunani kwa Chapanga. Avalagizi munjila ya Mpungu Msopi vamitumi vala veavahagwili. ");
INSERT INTO xnj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mulukumbi lwa magono alobaini kuhuma mulifwa laki, avahumalili pamahele kulangisa kuvya avi mumi. Vamuwene mwene alongili nawu ndava ya Unkosi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lukumbi lwe akonganiki nawu pamonga avalagazili. “Mkotoka kuwuka pa Yelusalemu, ndi mlindila njombi yeavalagazili Dadi, yemmali kuniyuwana nilongela ndava yaki. ");
INSERT INTO xnj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohani abatizi kwa manji, nambu magono gadebe gegigelekela, nyenye yati mbatiziwa kwa Mpungu Msopi.” ");
INSERT INTO xnj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Vanalihengu pavakonganiki pamonga na Yesu, vakamkota, “Wu Bambu, lukumbi ulu ndi pawiwuyisa unkosi wula kwa Isilaeli?” ");
INSERT INTO xnj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nambu Yesu akavajovela, “Lusenje na lukumbi lwa mambu ago uvili pahi ya uhotola wa Dadi wangu, lihengu linu lepi kumanya yati givya ndali. ");
INSERT INTO xnj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nambu lukumbi Mpungu Msopi peakuvahelelela nyenye, ndi yati mwipokela makakala na kuvya mwemwijova ndava yangu pagati ya muji wa Yelusalemu pamulima woha wa ku Yudea na ku Samaliya, na hati pamwishu wa mulima.” ");
INSERT INTO xnj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Peamali kujova genago, kuni voha vakumlolokesa, akatoliwa kunani kwa Chapanga, lihundi likamfiya vakotoka kumlola kavili. ");
INSERT INTO xnj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pevayendalili kulolokesa kunani, kuni mwene ihamba, bahapo vandu vavili vevawalili nyula za msopi vayimili papipi na vene, ");
INSERT INTO xnj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","vakajova, “Nyenye vandu va ku Galilaya! Ndava kyani myima kulolokesa kunani? Yesu mwenuyu mweatoliwi kuhuma kwinu, mewawa yati iwuya kavili ngati chemumuwene ihamba kunani kwa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kangi vamitumi vakawuya Yelusalemu kuhuma kuchitumbi chila chechikemelewa Mizeituni chechavili utali wa kilomita yimonga kuhuma kumujini. ");
INSERT INTO xnj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pavahikili pamuji vakakwela kugolofa kwevatamayi, vavi Petili na Yohani na Yakobo na Andelea na Filipi na Tomasi na Batolomei na Matei na Yakobo mwana wa Alufayo, Simoni Zeloti chikundi cha Vayawudi vevibela ulongosi wa Loma, na Yuda mwana wa Yakobo. ");
INSERT INTO xnj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Voha ava vakakonganeka kumuyupa Chapanga, pamonga na vadala na Maliya nyina waki Yesu na valongo vaki. ");
INSERT INTO xnj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Magono ago, Petili ayimili pagati ya valongo vamsadika vala vevakonganiki, voha vavi vandu miya yimonga na ishilini, ");
INSERT INTO xnj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","akajova, “Valongo vangu, yaganikiwi Mayandiku Gamsopi gatimilayi, pandu pala Mpungu Msopi, alotili mu malovi ga Daudi kumvala Yuda mweavalongwisi vala vevamkamwili Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda avi mmonga wa chikundi chitu muni ahaguliwi kuhenga lihengu la chitumi pamonga na tete.” ");
INSERT INTO xnj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mwene agulili mgunda kwa mashonga geagapatili ndava ya kumng'anamukila Yesu, akagwa pahi na kupapuka, maleme gaki gakahuma kuvala. ");
INSERT INTO xnj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lijambu lenilo likayuwanikana kwa kila mundu wa Yelusalemu, hati kwa luga yavi vakaukemela mgunda wula Hakeli Dama, mana yaki “Mgunda wa Ngasi.” ");
INSERT INTO xnj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hinu yiyandikiwi muchitabu cha Zabuli, nyumba yaki yisigalila mang'ova, mundu yoyoha akotoka kutama mwenumo. Kangi yiyandikiwi. Mundu yungi atola pandu pa lihengu laki. ");
INSERT INTO xnj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ndi mundu mmonga pagati yinu, mwealandini na tete lukumbi lwoha Bambu Yesu peavi mulugendu pamonga na tete ahaguliwa kuwungana na tete, ");
INSERT INTO xnj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mwenuyo yiganikiwa kuvya mmonga wa vala vevalandini na tete, kutumbula Yohani peavili mukubatiza mbaka ligono lila Yesu peatoliwi kuhuma kwitu kuhamba kunani kwa Chapanga. Mwenuyo ndi iwungana na tete kujova ndava ya kuyuka kwa Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hinu, vakaluwula mahina gavili, wa mmonga Yosefu mweikemiwa Basaba mewa Yusto, na yungi Matia. ");
INSERT INTO xnj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kangi vakamuyupa Chapanga, “Bambu, veve ukiyimanya mitima ya vandu voha. Hinu utilangisa yani mwemhagwili pagati ya vavili ava, ");
INSERT INTO xnj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","muni atola pandu pa lihengu la chitumi lealekili Yuda, mwene awukili kuhamba pandu paki mwene.” ");
INSERT INTO xnj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Vakamhagula na Matia ndi akahaguliwa mwene ayonjokeswa pagati ya vamitumi kumi na mmonga vala. ");
INSERT INTO xnj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ligono la Pentekoste palahikili vamsadika voha vakonganiki pandu pamonga. ");
INSERT INTO xnj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chighafula, lwami lukayuwanika kuhuma kunani ngati chimbungululu chivaha, chikamema nyumba yoha yevatamili. ");
INSERT INTO xnj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kangi, vikahumila vindu vyevyawonikini ngati lulimi lwa motu, lukalekengana na kutula panani ya kila mmonga wavi. ");
INSERT INTO xnj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Voha vakamemeswa Mpungu Msopi na kutumbula kujova luga ndalindali ngati Mpungu cheavahotwisi. ");
INSERT INTO xnj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na ku Yelusalemu kwavi na Vayawudi, vandu vevakumtopesa Chapanga vevahumila kila likabila pamulima. ");
INSERT INTO xnj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pevayuwini lwami lula, msambi uvaha wa vandu ukakonganeka. Voha vakakenyemuka neju muni kila mmonga wavi avayuwini vandu vala vijova kwa luga yaki mwene. ");
INSERT INTO xnj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vakavya na chinamtiti na kukangasa vakajova, “Wu, ava vetikuvayuwana, lepi vakolonjinji va ku Galilaya! ");
INSERT INTO xnj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hinu, yivi wuli, tete kuvayuwana kila mmonga ijova kwa luga yaki mwene? ");
INSERT INTO xnj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pagati yitu vavi vandu kuhuma ku Paliti vangi ku Medi na vangi ku Elami na vangi vakolonjinji va Mesopotamia na Yudea na Kapodokia na Ponto na Asia, ");
INSERT INTO xnj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Flugia na Pamfulia na Misili na vangi kuhuma Libiya papipi na Kulene na vangi vitu ndi vayehe kuhuma ku Loma, ");
INSERT INTO xnj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Vayawudi na vangalikuvya Vayawudi, nambu vilanda njila ya kumuyupa Chapanga ya Vayawudi, vangi vahumili ku Kilete na Alabia. Tavete tikuvayuwana vijova kwa luga zitu ndi matendu gakulu ga Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Voha vakakangasa na kuvagaya kuni vikotana, “Yeniyi mana yaki kiki?” ");
INSERT INTO xnj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nambu vangi vakavavevesa vakajova, “Vandu ava vagalili ugimbi!” ");
INSERT INTO xnj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kangi Petili akayima pamonga na vamitumi kumi na mmonga vala akatumbula kuvakokosela vandu. Valongo Vayawudi na mwavoha nyenye mwemwitama ku Yelusalemu, myuwanila malovi gangu. ");
INSERT INTO xnj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lepi chemwihololela vandu ava vagalili muni ndi saa yidatu ya lukela. ");
INSERT INTO xnj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nambu lijambu lenili ndi chakaka lelalongaliki na Yoeli mweavili mlota wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bambu ijova, mumagono gala gamwishu, nikuvamemesa Mpungu wangu vandu voha, vana vinu vagosi na vadala yati vilota ulota wa Chapanga, vasongolo vinu yati vilola maono, na vagogo vinu yati vilota munjozi. ");
INSERT INTO xnj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ena, hati vatumisi vangu, voha vagosi na vadala, yati nikuvapela Mpungu wangu navene yati vilotela. ");
INSERT INTO xnj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yati nikita gachinamtiti kunani, na kukita milangisu pahi pamulima. Yati kwiva na ngasi, motu na lyohi litopanu. ");
INSERT INTO xnj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lilanga yati ligubikwa na chitita, na mwehi walavya mdung'u ngati ngasi, kwakona kuhumila ligono likulu la ukulu wa Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mewawa mundu yoyoha mweiyupa kwa liina la Bambu yati isanguliwa. ");
INSERT INTO xnj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Vandu va Isilaeli myuwanila! Yesu wa ku Nazaleti avi mundu, uhotola waki wa uchapanga walangisi kwinu kwa gachinamtiti na makangaso na milangisu. Chapanga yeahengili kwa nyenye kwa njila yaki, ngati mwavene chemwimanya. ");
INSERT INTO xnj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ndava ya mpangu waki mwene Chapanga, amali kuhamula kuvya Yesu agotolewa kwa nyenye, na mwavene mwamkomili kwa kuvaleka vandu vahakau vamkoma na kumvamba mu msalaba. ");
INSERT INTO xnj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nambu Chapanga amyukisi kuhuma kwa vevafwili, amsangwili kuhuma mu mvinisu wa lifwa, ndava muni yihotoleka lepi lifwa limkunga. ");
INSERT INTO xnj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Muni Daudi ajovili aga kumvala mwene, ‘Namuwene Bambu palongolo yangu lukumbi lwoha, avi pamonga na nene upandi wa kulyelela, hati ninyugusika lepi. ");
INSERT INTO xnj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ndi muni mtima wangu waganisiwi, na kululuta kwa luheku. Hati higa yangu, yati yitama kwa kuhuvalila, ");
INSERT INTO xnj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ndava nakuuleka mpungu wangu kulitinda, wala kumlekekesa Msopi waku awola. ");
INSERT INTO xnj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unilangisi njila za wumi, ndava ya kuvya kwaku unimemisi luheku.’” ");
INSERT INTO xnj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Valongo vangu, nigana kuvajovela hotohoto kumvala mambu gegampatili gogo witu Daudi. Mwene afwili na kuzikiwa na litinda laki livii kwitu mbaka lelu. ");
INSERT INTO xnj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nambu Daudi ndava avili mlota wa Chapanga amanyili kuvya Chapanga amlapakisi kwa lilaganu yati akumhagula mmonga wa chiveleku waki kuvya nkosi pahali paki. ");
INSERT INTO xnj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi agaweni kwakona mambu aga gegihengeka na Chapanga, hinu akajova ndava ya kuyuka kwa Kilisitu, lukumbi peajovili, ‘Nakulekewa mu litinda la mbugu, higa yaki yawoli lepi.’ ");
INSERT INTO xnj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chapanga amyukisi Yesu na tavoha tete ndi vetijova ndava ya lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu peamali kukweswa na kuvikwa upandi wa kulyelela wa Chapanga ndi akapokela kuhuma kwa Dadi, Mpungu Msopi yula mweatiahidi, atimemimisi Mpungu wene. Chenicho ndi chetikuchiwona hinu na kuyuwana. ");
INSERT INTO xnj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Muni Daudi nakukwela mbaka kunani kwa Chapanga, muni ngamwene ajovili, ‘Bambu amjovili Bambu wangu, tama upandi wangu wa kulyela, ");
INSERT INTO xnj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka penikuvavika makoko gaku kuvya chigoda cha kuvikila magendelu gaku.’” ");
INSERT INTO xnj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Vandu voha va Isilaeli viganikiwa kumanya kwa uchakaka kuvya Yesu mwenuyo mwevamkomili na kumvamba mu msalaba, ndi Chapanga amviki kuvya Bambu na Kilisitu.” ");
INSERT INTO xnj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hinu, vandu pavagayuwini genago, mitima yawavinili, vakavakota Petili na pamonga na vamitumi vayaki. “Valongo vitu tikita wuli?” ");
INSERT INTO xnj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petili akavayangula, “Mumuwuyila Chapanga na kila mmonga winu abatiziwa kwa liina la Yesu Kilisitu, muni mulekekesewayi kubumdila Chapanga na kupokela njombi yila ya Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Muni lilaganu lila lavi ndava yinu na ndava ya vana vinu na ndava ya voha vevitama kutali ndava ya kila mundu mweikemiwa na Bambu Chapanga witu.” ");
INSERT INTO xnj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa malovi gangi gamahele, Petili avajovili hotohoto vandu “Vajisangula na chiveleku ichi chihakau.” ");
INSERT INTO xnj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Vamahele pagati yavi vagasadiki malovi ga Petili na kubatiziwa, na vandu vevayonjokisiki vavi ngati elufu zidatu ligono lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Venavo voha vayendalili kujiwula kuhuma kwa vamitumi na kutama pamonga cha lukolo, kulya pamonga na kumuyupa kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Gachinamtiti na makangaso gamahele gahengiki munjila ya vamitumi hati kila mmonga akakangaswa. ");
INSERT INTO xnj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vamsadika voha vayendalili kuvya chindu chimonga na vindu vyavi vatangatilanayi kwa pamonga. ");
INSERT INTO xnj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Vavi mukugulisa kila chindu pamonga na kangi kugavana mashonga kuwanangana ngati avi na la liganu la mmonga wavi. ");
INSERT INTO xnj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kila ligono vayendalili kukonganeka pamonga Munyumba ya Chapanga. Mewa lukumbi lwa kulya vakonganiki pamonga munyumba zavi na vilya kwa luheku na mtima wa msopi. ");
INSERT INTO xnj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Vakamulumbalila Chapanga, vakaganwa na vandu voha. Kila ligono Bambu akavayonjokesela mu msambi vandu vevasanguliwi. ");
INSERT INTO xnj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ligono limonga, lukumbi lwa saa tisa ya muhi, Petili na Yohani vavi mukuhamba Kunyumba ya Chapanga lukumbi lwa kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Hinu mundu mmonga mweavi ngagenda tangia peavelekiwi. Kila ligono vandu vamgegayi na kumvika pamlyangu wa Nyumba ya Chapanga weukemelewa “Mlyangu Wabwina.” Muni avayupayi vindu kwa vala veviyingila Munyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peavawene Petili na Yohani viyingila Munyumba ya Chapanga, avayupili vampela mashonga. ");
INSERT INTO xnj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Vene vakamlolokesa takataka, ndi Petili akamjovela, “Utilola!” ");
INSERT INTO xnj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ngagenda yula akavalola, ahololela ipewa chindu kuhuma kwavi. ");
INSERT INTO xnj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nambu Petili akamjovela, “Nivii lepi na mashonga amala zahabu, nambu chenivi nachu yati nikukupela. Kwa uhotola wa Yesu Kilisitu wa ku Nazaleti, yima ugendayi!” ");
INSERT INTO xnj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hinu akamkamula chiwoko cha kulyelela, akamyinula. Bahapo magendelu na mafugamilu gaki gakavya na makakala. ");
INSERT INTO xnj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akahumba, akayima na kutumbula kugenda. Ndi akayingila nawu pamonga Munyumba ya Chapanga, igenda na kuhumba humba kuni akumlumbalila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vandu voha vevavi penapo vamuwene igenda na kumlumbalila Chapanga, ");
INSERT INTO xnj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","pavammanyili kuvya mwene ndi yula mweatama papipi na Mlyangu Wabwina Wa Nyumba ya Chapanga, na kuyupa vakakangasa neju hati nakugamanya gegamkolili. ");
INSERT INTO xnj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lukumbi pavamuwene mundu yula alongosini na Petili na Yohani, vandu voha vakavya mumkangaso ndi vajumbalili pandu pepakemeliwi “Libanji la Solomoni.” ");
INSERT INTO xnj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hinu, Petili peavawene vandu, akavajovela, vandu va Isilaeli, ndava kyani mwikangaswa na lijambu ili? Kyani mukutilolokesa takataka ngati kwa makakala gitu amala ndava ya umsopi witu tavete timuhengili mundu uyu ahotola kugenda? ");
INSERT INTO xnj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chapanga wa Ibulahimu na Izaki na Yakobo, ndi Chapanga wa vagogo vitu ampeli amulumbalili mtumisi waki Yesu. Nambu nyenye mwamkamwili na kumgotola kwa vachilongosi na kumng'anamukila na kumbela palongolo ya Pilatu, hati peamwili kumdindulila. ");
INSERT INTO xnj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwene avili mweikita geigana Chapanga na msopi, nambu nyenye mwambelili ndi mwayupili mundu yungi mweavimkomaji adinduliwa. ");
INSERT INTO xnj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nyenye mwamkomili chanzu cha wumi, nambu Chapanga amyukisi kuhuma kwa vafwili, tavete taliwene lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Makakala na kumsadika Yesu ndi vyevi mpeli makakala mundu uyu mwemukumlola na kummanya. Sadika kwa Yesu ndi yeyimlamisi hotohoto mundu uyu ngati mwavoha chemukumlola. ");
INSERT INTO xnj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Hinu, valongo vangu, nimanyili kuvya nyenye na vachilongosi vinu mwahengili ago ndava mwamanyili lepi. ");
INSERT INTO xnj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nambu Chapanga agahengili ago goha geajovili munjila ya vamlota va Chapanga voha kuvya yamganili Kilisitu ang'aika. ");
INSERT INTO xnj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Muleka kubuda na mumuwuyila Chapanga, ndi mwene avalekekesa kumubudila. ");
INSERT INTO xnj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mukita genago, muni Bambu avapela lusenje lwa kupoleswa mitima na kuvaletela Kilisitu mweavahagulili ndi Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yikumgana mwene kusigalila kunani kwa Chapanga mbaka palubwela lukumbi vindu vyoha kukitwa vya mupya, ngati Chapanga cheajovili munjila ya vamlota vaki vamsopi vevatamili kadeni. ");
INSERT INTO xnj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muni, Musa ajovili, ‘Bambu Chapanga winu akuvayinulila mlota wa Chapanga ngati nene kuhuma kwa nyenye mwavene. Mumyuwanila mwene mu mambu goha geakuvajovela nyenye. ");
INSERT INTO xnj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu yoyoha mwangamyuwanila mlota wa Chapanga mwenuyo, yati ibaguliwa kutali na vandu va Chapanga na kukomewa.’ ");
INSERT INTO xnj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Vamlota voha va Chapanga kuhuma Samueli na vangi vevagelekili, vakokwisi mambu aga gegihumila magono aga. ");
INSERT INTO xnj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na Chapanga alagazili vamlota vaki ndava yinu, na muyingila mu lilaganu leahengili na vagogo vitu, ngati chamjovili Ibulahimu, ‘Mu chiveleku chaku na vandu voha va pamulima yati vimotisiwa.’ ");
INSERT INTO xnj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ndi Chapanga amyukisi mtumisi waki, amtumili hoti kwa nyenye, avamotisa na kumkita kila mmonga winu alekana na uhakau waki.” ");
INSERT INTO xnj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petili na Yohani pevayendalili kuvakokosela vandu, vamteta va Chapanga na valonda va Nyumba ya Chapanga na chikundi cha Vasadukayu ndi vandu vevisadika kuvya vandu nakuhotola kuyuka vakavabwelela. ");
INSERT INTO xnj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Vakamema ligoga, muni vamitumi vala vakuvakokosela vandu kuvya Yesu ayukili lijambu lelilangisa hotohoto kuvya vafwili yati viyuka. ");
INSERT INTO xnj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hinu Petili na Yohani ndi vakamuliwi na kuyingiswa muchifungu mbaka chilau yaki ndava yavi kimihi. ");
INSERT INTO xnj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nambu vamahele pagati ya vevayuwini ujumbi wavi vakasadika, na vamsadika vakayonjokeseka jumula yavi vakavya ngati vagosi elufu mhanu. ");
INSERT INTO xnj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chilau yaki, vachilongosi va Vayawudi vagogo na vawula va malagizu ga Chapanga geampeli Musa vakakonganeka pamonga ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Vakonganiki pamonga na Mteta Mkulu Anasi na Kayafa na Yohani na Alekizanda na vangi voha vevavi va lukolo lwa Mteta Mkulu. ");
INSERT INTO xnj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pavavayimiki Petili na Yohani palongolo yavi, vakavakota, “Nyenye mwihenga lijambu lenili kwa makakala ga yani amala kwa uhotola wa yani?” ");
INSERT INTO xnj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petili kuni amemiswi Mpungu Msopi akavayangula, “Vachilongosi na vagogo va vandu! ");
INSERT INTO xnj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ngati lelu mukutikota kuchivala chitendu chila chabwina cheahengiwi ngagenda yula na kulama, ");
INSERT INTO xnj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","hinu, nyenye na vandu voha va pa Isilaeli yikuvagana kumanya kuvya mundu mwenuyo iyima palongolo yinu lelu, alamili hotohoto, kwa makakala ga Yesu Kilisitu wa ku Nazaleti, nyenye mwevamvambili pamsalaba, nambu Chapanga amyukisi kuhuma kwa vafwili. ");
INSERT INTO xnj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu mwenuyo ndi Mayandiku Gamsopi chegijova. ‘Liganga lemwabelili nyenye vakujenga, hinu ndi liganga likulu la mkingisa pakujenga.’ ");
INSERT INTO xnj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Usangula wipatikana munjila ya mwene ndu, pamulima poha kawaka hati mmonga mweapewili na Chapanga uhotola wa kutisangula.” ");
INSERT INTO xnj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Vachilongosi va libanji vakavakangasa Petili na Yohani chavidandaula cha ukekesi, vavamanyili kuvya vavi vandu vangasoma wala ilimu yoyoha. Vakamanya kuvya vavi pamonga na Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nambu pavamuwene mundu yula mwealamisiwi ayimili pamonga nawu, nakuhotola kujova chindu. ");
INSERT INTO xnj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hinu vakavajovela vahuma kuvala ya libanji lila na kuni vene vakasigalila mugati kulongela vene kwa vene. ");
INSERT INTO xnj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Vakakotana, “Tikita kyani na vandu venava? Mundu yoyoha mweitama pa Yelusalemu imanyalila kuvya ulangisu uwu wa chinamtiti uhengiki, tete nakuhotola kubela lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nambu lenili tihotola kugunisa lijambu lenili likoto kudandasika kwa vandu, ndi tivabesa vakotoka kulongela na mundu yoyoha kwa uhotola wa Yesu.” ");
INSERT INTO xnj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Hinu vakavakemela kavili mugati, vakavabesa vakotoka kulongela amala kuwula vandu kwa uhotola wa Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nambu Petili na Yohani vakavayangula, “Mwavene muamula ngati chabwina palongolo ya Chapanga kuvayidakila nyenye kuliku kumyidakila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndava muni nakuhotola kuleka kulongela kugavala mambu gala getagawene na kuyuwana.” ");
INSERT INTO xnj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ndi vachilongosi va libanji vakavaywangila cha ligoga, kangi vakavalekekesa. Nakuhotola kuvalipisa ndava muni vandu voha vamlumbalila Chapanga ndava ya lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundu yula mweahengiwi ulangisu wa kulama avi na umuli wa miyaka yeyiyonjokesa alobaini. ");
INSERT INTO xnj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bahapo pavalekeswi Petili na Yohani vakawuya kwa vayavi, vakavajovela gala gevajoviwi na vakulu va kuteta va Chapanga na vachilongosi. ");
INSERT INTO xnj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Navene pavagayuwini malovi ago, vakawungana pamonga kumuyupa Chapanga vakajova, “Bambu, veve ndi mweuwumbili kunani na pamulima na nyanja pamonga vindu vyoha vyeviyili! ");
INSERT INTO xnj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ndi mweumhotwisi mtumisi waku, dadi witu Daudi ajova kwa makakala ga Mpungu Msopi, ‘Ndava kyani makabila gamemili ligoga? Ndava kyani vandu vakiti mipangu ya waka? ");
INSERT INTO xnj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Vankosi va pamulima vayimili ndava ya ngondo, na vachilongosi vakokanganiki pamonga, ndava ya kumbela Bambu na Kilisitu.’ ");
INSERT INTO xnj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Muni, chakaka ndi Helodi na Ponsio Pilatu na vandu va Isilaeli na vandu va vangali Vayawudi vakonganiki pabomani apa, kumbela mtumisi waki wa Msopi ndi Yesu mwewamuhagwili. ");
INSERT INTO xnj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Muni vahenga mambu geugapangili kutumbula kadeni kwa makakala gaku na kwa uhamula waku. ");
INSERT INTO xnj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambu hinu, Bambu, lola chaviyogofya. Utikangamalisa tavatumisi vaku kukokosa lilovi laku cha ukekesi. ");
INSERT INTO xnj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Talambula chiwoko chaku uvalamisa vandu, na kita ulangisu na chinamtiti kwa uhotola wa Yesu mtumisi waku wa Msopi.” ");
INSERT INTO xnj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pevamalili kuyupa kwa Chapanga pandu pala pakanyugusika, navene voha vakamemeswa Mpungu Msopi. Vakayendelela kukokosa lilovi la Chapanga changali wogohi. ");
INSERT INTO xnj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Vamsadika voha vavi mtima umonga na mpungu umonga. Avi lepi hati mmonga wavi mweavi na chindu chochoha, mweachivikili kuvya chaki mwene, ndi vagavini vyoha vyevavi navyu. ");
INSERT INTO xnj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kwa makakala gavaha, vamitumi vakajova ndava ya kuyuka kwaki Bambu Yesu, na Chapanga akavamotisa neju. ");
INSERT INTO xnj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kawaka mundu mwangali chindu, muni vevavi na migunda amala nyumba vagulisi na kugega mashonga gala, ");
INSERT INTO xnj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kugagotola kwa vamitumi vala, mashonga ago vagavanayi kwa kila mundu ndava ya vindu vyeaganili. ");
INSERT INTO xnj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kwavili na mundu mmonga Mlawi, mkolonjinji wa Kuplo, liina laki Yosefu vamitumi vamkemelayi Banaba mana yaki “Mundu mweikangamalisa mtima.” ");
INSERT INTO xnj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Mewawa mwene agulisi mgunda waki, akatola mashonga genago na kuvagotolela vamitumi. ");
INSERT INTO xnj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nambu mundu mmonga liina laki Anania na mdala waki Safila vagulisi mewa chipandi cha mgunda wavi. ");
INSERT INTO xnj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na mdala waki amanyili hotohoto kuvya mgwana waki afiyili mashonga gangi geapewili, na zingi zila azigotwili kwa vamitumi. ");
INSERT INTO xnj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petili akamkota, “Anania ndava kyani Setani auyingili mtima waku na kumkonga Mpungu Msopi ujifiyili mashonga gangi geupewili mumgunda wula? ");
INSERT INTO xnj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kwakona kugulisa mgunda wenuwo wavi waku, na pawaligulisi mashonga gala gavi gaku, uhengela chewigana. Ndava kyani, wahamwili mumtima waku kuhenga lijambu lenili? Umkongili lepi mundu, nambu umkongili Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania peagayuwini malovi ago, akagwa pahi akafwa na vandu voha vevagayuwini mambu ago vakayogopa neju. ");
INSERT INTO xnj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Vasongolo vakabwela, vakamugubika higa yaki kwa nyula ya msopi, vakamuwusa kuvala vakamuzika. ");
INSERT INTO xnj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagamaliki masaa ngati gadatu, mdala waki changali kumanya mambu gegahumalili, akayingila mugati mula. ");
INSERT INTO xnj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petili akamkota, “Unijovela! Wu mashonga gemwapewili kwa kugulisa mgunda ndi gagaga?” Ndi mwene akamyangula, “Ena, ndi genaga.” ");
INSERT INTO xnj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hinu, Petili akamjovela mdala yula, “Wuli muyidakilini kumlinga Mpungu wa Bambu? Yuwanila! Vandu vala vevahambili kumzika mgwana waku, hinu vavi pamlyangu ndi yati vakukutola mewa na veve.” ");
INSERT INTO xnj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bahapo safila akagwa palongolo ya magendelu ga Petili, akafwa. Vasongolo vala pavayingili vamkolili amali kufwa, ndi vakamuwusa kuvala, vakamuzika papipi na mngwana waki. ");
INSERT INTO xnj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wogohi uvaha ukavayingila msambi wa vandu vevakumsadika Kilisitu voha na vandu voha, vevayuwini malovi ga lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chapanga ahengili kwa njila ya vanalihengu gachinamtiti na makangaso gamahele pagati ya vandu. Na vamsadika vakonganikayi pamonga mulibanji la Solomoni. ");
INSERT INTO xnj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mundu yungi yoyoha angalikuvya msadika, valingili lepi kuwungana nawu. Nambu vandu vangi vangasadika vavalumbalili. ");
INSERT INTO xnj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nambu vandu vamahele vevamsadiki Bambu, vagosi na vadala vakayonjokeseka neju. ");
INSERT INTO xnj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hati vandu vavagegili vatamu vavi munjila na kuvagonesa mu lusongwani na mumipasa, muni Petili akapitayi, mbanga chimuwili chaki chivahikila vangi pagati yavi. ");
INSERT INTO xnj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vandu vamahele vabwelili kuhuma mumiji yeyitindila Yelusalemu, vavaletili vatamu wavi na vevavi na mizuka yihakau, ndi voha vakalamiswa. ");
INSERT INTO xnj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kangi, Mteta Mkulu na vayaki va chikundi cha Vasadukayu ndi vandu vevisadika kuvya vandu nakuhotola kuyuka va pandu penapo, vakayva na wihu kwa vamitumi. ");
INSERT INTO xnj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hinu vakavakamula vamitumi na kuvakunga muchifungu chikulu. ");
INSERT INTO xnj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nambu kilu mtumu wa kunani kwa Chapanga, akadindula mlyangu wa muchifungu yikulu, akavahumisa kuvala, akavajovela, ");
INSERT INTO xnj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Muhambayi mukayima Munyumba ya Chapanga, mkavajovela vandu malovi ga kuuvala wumi wa mupya.” ");
INSERT INTO xnj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Vamitumi vakayidakila, vakayingila Munyumba ya Chapanga lukela pehe, vakatumbula kuwula. Mteta Mkulu na vayaki pavahikili, vakemili mngonganu wa libanji likulu na vagogo voha va Isilaeli, kangi vavatumili vandu kujela vavaleta vamitumi vala. ");
INSERT INTO xnj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nambu valonda va muchifungu pavahikili, vavakolili lepi. Ndi vakawuya na kujova kwa vakulu va libanji, ");
INSERT INTO xnj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tikolili jela yidindanu na valonda vavi mumilyangu kulindalila. Nambu patadindwili milyangu tamkolili lepi mundu yoyoha mugati.” ");
INSERT INTO xnj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mkulu wa valonda wa Nyumba ya Chapanga na Vamteta Vakulu pevayuwini genago, vakavya na wogohi, ndava nakuchimanya chechavakolili. ");
INSERT INTO xnj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kangi, akabwela mundu mmonga na kuvajovela, “Yuwanila! Vandu vala vemkavakungili muchifungu, hinu vavi Munyumba ya Chapanga vakuvawula vandu.” ");
INSERT INTO xnj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bahapo mkulu wa valonda na vahenga lihengu vaki, vakahamba Munyumba ya Chapanga vakavaleta. Nambu nakuvakamula kwa makakala, muni vayogwipi vandu yati vakuvatova na maganga. ");
INSERT INTO xnj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hinu, vavapeliki vamitumi vala, vakavayimika palongolo ya libanji, ndi Mteta Mkulu akavajovela, ");
INSERT INTO xnj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tavabesili hotohoto kuwula paliina la mundu uyu, hinu mugadandisi mawuliwu ginu pa Yelusalemu poha mwigana kutigegesa ngasi ya mundu uyu.” ");
INSERT INTO xnj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petili pamonga na vamitumi vayaki vakayangula, “Yikutigana kumyidakila Chapanga, kuliku mundu. ");
INSERT INTO xnj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chapanga wa vagogo vitu amyukisi Yesu mwemwamkomili nyenye na kumvamba pamsalaba. ");
INSERT INTO xnj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mwenuyu ndi yula mwealumbiwi na Chapanga mbaka upandi wa kulyelela, kuvya Chilongosi na Msangula, muni avakita vandu va Isilaeli vamuwuyila Chapanga, muni vapata kulekekesewa kumbudila. ");
INSERT INTO xnj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tete ndi taliwene lijambu lenilo, na Mpungu Msopi, Chapanga avapelili vala vevakumyidakila mwene.” ");
INSERT INTO xnj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Vajumbi voha va libanji lila pevayuwini genago, vakamema ligoga vakahamula kuvakoma. ");
INSERT INTO xnj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nambu mundu mmonga Mfalisayu liina laki Gamalieli, muwula wa malagizu ga Bambu geampeli Musa na mweitopeswa na vandu voha. Akayima mu libanji palongolo ya vandu akalagiza vamitumi vala vawusiwayi kuvala mulukumbi luhupi. ");
INSERT INTO xnj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kangi akavajovela vajumbi va libanji vala, “Vandu va Isilaeli, mjiyangalila kwakona mwangakita, chemwigana kuvakitila vandu ava! ");
INSERT INTO xnj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Magono ga mumbele, ahumalili mundu mmonga liina laki Teudosi, akajijovela kuvya mundu wa kutopela, vandu ngati miya mcheche vakajiwunga nayu. Nambu akomiwi, kangi vamulanda vaki vakapechengana chikundi chaki chafwili. ");
INSERT INTO xnj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mwanakandahi kavili, lukumbi lwa kuvalangiwa vandu, ahumalili Yuda wa ku Galilaya. Mewawa mwenuyo avakulukisi vandu vakamulanda, nambu mwenuyo mewawa akomiwi vamulanda vaki vakapechengana. ");
INSERT INTO xnj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hinu nene nikuvajovela ndava ya mhalu uwu, mujiyepa na vandu ava! Mvalekayi vahamba. Ndava muni ngati mpangu wenuwo utumbuliwi na vandu yati wiyaga wene. ");
INSERT INTO xnj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nambu ngati mpangu wenuwu uhumili kwa Chapanga, nakuhotola kuvabesa vandu ava, muni mwavene yati mukujikolela mukumbela Chapanga!” Ndi vakayidakilana na malovi ga Gamalieli. ");
INSERT INTO xnj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hinu, vakavakemele vamitumi vala, vakahamula vatovewa michapilu na kuvabesa vakotoka kuwula kavili paliina la Yesu, ndi vakavaleka vahamba. ");
INSERT INTO xnj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Hinu, vamitumi vakahuma mu libanji kuni vamemi luheku, muni Chapanga avahololili kuvya vene yavaganili kukola soni ndava ya liina la Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kila ligono vayendalili kuwula na kukokosa Munyumba ya Chapanga na munyumba za vandu, Lilovi la Bwina la Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mwanakandahi vawuliwa pevayendalili kuyonjokeseka, gakahumila mang'ung'uta pagati ya vamsadika va Yesu, Vayawudi vevilongela Chigiliki vala na vala vevilongela Chiebulania, vevilongela Chigiliki vala vang'ung'utayi ndava vakuvakosiwa valipwela vavi mukugawiwa vyakulya vya kila ligono. ");
INSERT INTO xnj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndi muni, vamitumi kumi na vavili vala vakavakemela vamsadika, vakajova, “Chabwina lepi tete kuleka kukokosa Lilovi la Chapanga na kuvagavila chakulya. ");
INSERT INTO xnj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hinu, valongo vitu, mvahagula vandu saba pagati yinu, vevitopeswa na vevamemili Mpungu Msopi na luhala, tete yati tikuvagotolela lihengu lenili. ");
INSERT INTO xnj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tavete yati tivya mukuhenga mukumuyupa Chapanga na lihengu la kukokosa Lilovi la Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lijambu lenilo likavaganisa vamsadika voha, ndi vakavahagula Stefani, mundu mweamemiswi sadika yivaha na Mpungu Msopi na Filipi na Plokolo na Timoni na Pamena na Nikolausi mundu wa ku Antiokia mweajiwungi na njila ya kumuyupa Chapanga ya Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Vakavavika palongolo ya vamitumi, kangi vakavayupila kwa Chapanga kuni vavapamisi mawoko. ");
INSERT INTO xnj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lilovi la Chapanga likadandasika ku Yelusalemu na vamsadika vakayonjokeseka neju, chikundi chivaha cha vamteta va Chapanga vakalanda sadika. ");
INSERT INTO xnj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Hinu, Stefani amotisiwi na apewili makakala na Chapanga, hati akahenga chinamtiti na makangaso pagati ya vandu. ");
INSERT INTO xnj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nambu vandu vangi vakahumila muni vahutana na Stefani. Vandu venavo vavi va “Nyumba ya kukonganekela Vayawudi la vandu Hulu,” Vene vahumili Kulene na Alekisanda, na vangi vahumili Kilikia na Asia. ");
INSERT INTO xnj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nambu vahotwili lepi kumhotola ndava ya luhala lwaki, na Mpungu Msopi mweamlongwisi mukujova. ");
INSERT INTO xnj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ndi vakavakulukisa cha mfiyu vandu nunuyu vajova kuvya, “Timyuwini Stefani akumliga Musa na akumliga Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ndava ya yeniyo, vakavakokesa vandu, vachilongosi na vawula va malagizu ga Chapanga geampeli Musa. Ndi vakambwelela Stefani vakamkamula na kumpeleka palongolo ya libanji. ");
INSERT INTO xnj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kangi vakaleta vajova malovi ga udese vevajovili, “Mundu uyu katu ikotoka lepi kuliga pandu apa Pamsopi na kuliga malagizu ga Chapanga geampeli Musa. ");
INSERT INTO xnj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ndava muni tamali kumyuwanila kuvya Yesu wa ku Nazaleti mwenuyu yati apagwisa pandu apa na kung'anamusa mivelu yila yetapokili kuhuma kwa Musa.” ");
INSERT INTO xnj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Voha vevatamili mu libanji lila vakamlolokesa takataka Stefani, kangi vakalola pamihu paki pavi ngati mtumu wa kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kangi, Mteta Mkulu akamkota, “Wu, mambu genaga ndi chakaka?” ");
INSERT INTO xnj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mwene akayangula, “Valongo vangu na vadadi vangu, muniyuwanila! Chapanga amuhumalili gogo witu Ibulahimu peavili ku Mesopotamia kwakona kuhamila ku Halani. ");
INSERT INTO xnj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chapanga akamjovela, ‘Wuka pamulima waku, valeka valongo vaku, ndi uhamba pamulima wenikulangisa.’ ");
INSERT INTO xnj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hinu, Ibulahimu ahamalili kumulima wa Kalidayo akahamba kutama ku Halani. Dadi waki peamali kufwa, Chapanga akamuwusa kavili ku Halani akabwela kutama pamulima uwu wemwitama hinu. ");
INSERT INTO xnj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chapanga nakumpela hati pandu padebe pamulima pavyaa uhali waki, nambu amlagizi akumpela mulima wenuwu uvyaa waki, na chiveleku chaki. Lukumbi lwenulo avi lepi na mwana. ");
INSERT INTO xnj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chapanga akamjovela, ‘Viveleku vyaku yati vipelekwa kumulima wa vandu vangi, kwenuko ndi yati vivya vavanda na kuhengewa uhakau mulukumbi lwa miyaka miya mcheche. ");
INSERT INTO xnj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nambu nene yati nikuvahamula vandu avo, vevavahengili uvanda. Kangi yati nikuvawusa mumulima wenuwo muni vabwela penapa kunifugamila pandu apa.’ ");
INSERT INTO xnj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kangi Chapanga akampela lilaganu la jandu, Ibulahimu akamyingisa jandu mwana waki Izaki mu ligono la nane, kuhuma kuvelekewa. Mewawa Izaki akamdumula jandu Yakobo, namwene Yakobo mewawa akavakitila vagogo kumi na vavili.” ");
INSERT INTO xnj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Vagogo vala vavi na wihu kwa Yosefu ndi vakamgulisa kuuvanda ku Misili. Nambu Chapanga avi pamonga nayu, ");
INSERT INTO xnj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akamsangula mu mang'ahiso gaki goha, Chapanga akamganisa na luhala palongolo ya Falao, nkosi wa ku Misili, hati Falao akamhagula kuvya chilongosi wa mulima wula na nyumba ya nkosi. ");
INSERT INTO xnj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kangi yikahumila njala yikulu, pamulima woha wa ku Misili na ku Kanani, yikaleta ungangu uvaha. Vagogo vitu vahotwili lepi kupata chakulya chochoha. ");
INSERT INTO xnj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hinu, Yakobo peayuwini kuvya ku Misili kula kuvi na mabenu, akavatuma vana vaki, ndi vagogo vitu vahamba kwenuko yavi mala ya kutumbula. ");
INSERT INTO xnj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mulugendu lwavi lwa pili, Yosefu akajimanyisa kwa valongo vaki, ndi Falao akavamanya valongo va Yosefu. ");
INSERT INTO xnj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefu atumili ujumbi kwa dadi waki na valongo vaki, vandu sabini na mhanu, vabwela ku Misili. ");
INSERT INTO xnj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Hinu, Yakobo ahambili ku Misili, kwenuko mwene pamonga na vagogo vitu vafwili. ");
INSERT INTO xnj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Higa zavi zaletiwi mbaka ku Shekemu, zikazikiwa mu litinda la mbugu leagulili Ibulahimu kuhuma kwa vana va Hamoli kwa mashonga nunuyu.” ");
INSERT INTO xnj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Lukumbi palwahikili Chapanga atimilisa lilaganu leajovili akumpela Ibulahimu, ku Misili kula vandu vayonjokisi na kuvya vamahele neju. ");
INSERT INTO xnj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pamwishu, nkosi mmonga mweanga mmanya Yosefu, akatumbula kulongosa kula ku Misili. ");
INSERT INTO xnj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mwenuyu avakitili uhakau vandu vitu na vagogo vitu changali kugana vene vavavika kuvala vana vavi vadebe muni vafwayi. ");
INSERT INTO xnj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa avelekiwi lukumbi lwenulo, avili mwana mbwina neju palongolo ya Chapanga. Aleliwi panyumba mulukumbi lwa miyehi yidatu, ");
INSERT INTO xnj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na peaumiswi kuvala, ndi msikana wa Falao akamtola na kumlela ngati mwana waki mwene. ");
INSERT INTO xnj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa awuliwi mambu goha galuhala ga Vamisili akavya mkekesi kwa malovi na matendu.” ");
INSERT INTO xnj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hinu Musa peahikisi miyaka alobaini ndi akahamba kuvagendela kuvalola va Isilaeli vayaki. ");
INSERT INTO xnj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kwenuko amuwene mmonga wa valongo vaki ihengewa uhakau, ndi akahamba kumkengelela, ndi akamkoma Mmisili yula. ");
INSERT INTO xnj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aholalili manya Vaisilaeli vayaki yati vimanya kuvya Chapanga ngaamtumili mwene kuvagombola, nambu vene nakugamanya ago. ");
INSERT INTO xnj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chilalu yaki Musa avawene Vaisilaeli vavili vitovana, akalinga kuvatepulanisa akavajovela, ‘Nyenye mwavalongo ndava kyani hinu, mukomana mwavene?’ ");
INSERT INTO xnj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nambu yungi mweamtovayi yula muyaki akamkang'a Musa pamuhana akajova, ‘Yani mweakuvikili veve kuvya chilongosi na mhamula pagati yitu? ");
INSERT INTO xnj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wu, ugana kunikoma ngati chewamkomili Mmisili golo?’ ");
INSERT INTO xnj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa peagayuwini malovi ago, akatila na kuhamba kutama kumulima wa Midiani kwenuko akavya myehe ndi akavya na vana vasongolo vavili.” ");
INSERT INTO xnj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Peyahikili miyaka alobaini, mtumu wa kunani kwa Chapanga akamhumila Musa padahi pepiyaka motu kulugangatu papipi na Chitumbi cha Sinai. ");
INSERT INTO xnj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa akakangasa kulola lijambu lenilo hati akahegelela papipi muni alingulila, ndi akayuwana lwami lwa Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nene ndi Chapanga wa vagogo vaku, Chapanga wa Ibulahimu wa Izaki na Yakobo.’ Musa akavagaya kwa wogohi ndi nakuhotola kulolokesa neju. ");
INSERT INTO xnj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bambu akamjovela, ‘Hula champali zaku muni peuyima apa ndi pandu pamsopi. ");
INSERT INTO xnj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nigawene mahakau gevihengiwa vandu vangu ku Misili kula. Niyuwini lwami lwa mang'ahiso gavi, ndi nene nibweli kuvagombola. Hinu bwela, yati nikukutuma ku Misili.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa mwenuyu ndi yula mweabeleliwi na vandu va Isilaeli pavamjovili, ‘Yani mweakuvikili kuvya chilongosi na mhamula pagati yitu?’ Chapanga amtumili Musa kuvya chilongosi na mgombozi, kwa njila ya mtumu wa kunani kwa Chapanga mweamhumalili padahi pepiyaka motu. ");
INSERT INTO xnj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ndi mweavalongwisi vandu vala vawuka ku Misili kwa kuhenga ulangisu wa gachinamtiti na makangaso pamulima wa Misili na Kunyanja ya Shamu na kulugangatu, mulukumbi lwa miyaka alobaini. ");
INSERT INTO xnj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa ndi mweavajovili vandu va Isilaeli, ‘Chapanga yati akuvahagulila mlota waki ngati nene pagati ya valongo vinu mwavene.’ ");
INSERT INTO xnj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mwene ndi mweavili kulugangatu kula, pevakonganiki vandu va Isilaeli. Musa avili ngati mjumbi pagati ya vagogo vitu, na mtumu wa kunani kwa Chapanga, lukumbi pealongili nayu kuchitumbi cha Sinai ndi mweagotoliwi malovi ga wumi atijovela tete.” ");
INSERT INTO xnj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nambu vagogo vitu ndi vabelili kumyidakila, ndi vakamkang'a pamuhana kuni mumitima yavi vakanogela kuwuya ku Misili. ");
INSERT INTO xnj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Vakamjovela mlongo wa Musa Aloni, ‘Utikitila vachapanga yeyikutulongosa munjila, muni nakumanya chechimkolili Musa mweatilongwisi kuhuma ku Misili!’ ");
INSERT INTO xnj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Penapo ndi pavajikitili chimong'omong'o cha mpapakasi wa ng'ombi, vakayitetela na vakakita mselebuko ndava ya lihengu la mawoko gavi vene. ");
INSERT INTO xnj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nambu Chapanga akawuka pagati yavi na kuvaleka vazifugundamila ndondo za kunani, ngati cheyiyandikwi muhitabu ya vamlota va Chapanga. ‘Nyenye vandu va Isilaeli! Lepi nene mwemwanihinjili hinyama ndava ya luteta, Mumiyaka alobaini kulugangatu kula! ");
INSERT INTO xnj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nyenye mwagegili chindanda cha chapanga Moloki, na vindu vyemwajikitili kwa luhumu lwa ndondo ya chapanga winu Lefani. Vindu vyemwajikitili ndi vyemwavifugamili. Ndava ya yeniyo yati nikuvapeleka uvanda kutali na Babeli.’ ");
INSERT INTO xnj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kulugangatu kula vagogo vitu vavi na lindanda la kulangisa, lakitiwi ngati Chapanga cheamlagazili Musa ahengayi, ulangisu wulawula ngati weauwene. ");
INSERT INTO xnj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kangi Vagogo vitu vahalilini lindanda vene kwa vene mbaka lukumbi lwa Yoshua, pevatolili mulima wula kuhuma kwa milima, Chapanga mweavingili palongolo yavi. Penapo ndi latamili mbaka lusenje lwa Daudi. ");
INSERT INTO xnj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi apewili uganu na Chapanga, akamuyupa ayidakila amujengela pandu pa kutama, mwene mweavi Chapanga wa Yakobo. ");
INSERT INTO xnj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nambu Solomoni ndi mweamjengili Chapanga nyumba.” ");
INSERT INTO xnj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nambu Chapanga Mkulu, itama lepi munyumba zezijengiwi na vandu ngati cheajovili mlota wa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bambu ijova, kunani ndi chigoda changu cha unkosi, na mulima ndi chigoda cha kuvikila magendelu gangu. Nyumba ya namuna yoki yemukunijengela nene? Ndi pandu poki penipumulila? ");
INSERT INTO xnj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Namwene ndi mwenihengili vindu vyoha?’ ” ");
INSERT INTO xnj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Nyenye vandu mwemwinonopa, mitima na makutu ginu ndi ngati vandu va milima yangamulanda Chapanga. Nyenye ngati vagogo vinu. Magono goha mukumbela Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vagogo vinu vamng'aisi mlota wa Chapanga yeyoha yula, vevavakomili avo, Chapanga avatumili kukokosa kubwela kwa yula mweikita geigana Chapanga. Nambu nyenye mwamgewukili na kumkoma. ");
INSERT INTO xnj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nyenye mwapokili malagizu gala gegaletiwi na mtumu wa kunani kwa Chapanga, nambu mwayidakili lepi.” ");
INSERT INTO xnj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Vala vagogo va libanji pavamuyuwanili Stefani, vakaviniswa mitima, ndi vakajiluma minu cha ligoga. ");
INSERT INTO xnj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nambu Stefani kuni amemiswi Mpungu Msopi, akalolokesa kunani kwa Chapanga, auwene ukulu wa Chapanga na Yesu ayimili muchiwoko cha kulyela cha Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefani akajova, “Mlola! Niwona kunani kwa Chapanga kudindwiki na Mwana wa Mundu ayimili pachiwoko cha kulyela cha Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Vakulu va libanji, vakaywanga na vakagubika makutu gavi kwa mawoko. Kangi vakamuhumbila voha kwa pamonga. ");
INSERT INTO xnj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Vakamkwekwesa kuvala ya muji, na kutumbula kumtova na maganga, vevavawene vakagavika makoti gavi paulonda wa msongolo mmonga liina laki Sauli. ");
INSERT INTO xnj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pevayendalili kumtova na maganga Stefani kuni mwene iyupa kwa Chapanga, “Bambu Yesu upokela mpungu wangu!” ");
INSERT INTO xnj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akafugama, akavemba kwa lwami luvaha, “Bambu, ukotoka kuvavalangila chevakubudila Chapanga!” Peamalili kujova ago, akafwa. Sauli ayidakili chitendu cha ukomaji wenuwo. ");
INSERT INTO xnj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na mwene Sauli awene chabwina kukomewa kwa Sitefani. Ligono lenilo msambi wa vandu vevakumsadika Kilisitu va ku Yelusalemu, vatumbwili kung'ahiswa neju. Vamsadika voha, Yavaganili kupechenganika kudahi pandi za ku Yudea na ku Samaliya, nambu kwa vamitumi ndu. ");
INSERT INTO xnj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Vandu vevisadika vakamuzika Stefani na kumvembela neju. ");
INSERT INTO xnj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nambu lukumbi lwenulo Sauli alingili kuvang'aisa msambi wa vandu vevakumsadika Kilisitu, ahambili nyumba kwa nyumba akavahumisa vamsadika kuvala vagosi kwa vadala na kuvasopa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hinu vala vamsadika vevapechangini vakahamba kila pandu kukokosa Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi namwene akahelela pamuji wa ku Samaliya na kumkokosa Kilisitu kwa vakolonjinji va penapo. ");
INSERT INTO xnj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Vandu vakajiwunga kuyuwanila ujumbi wa Filipi na kulola milangisu yila yeahenga. ");
INSERT INTO xnj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ndava muni vandu vevatalaliwi mizuka mihakau, yavahumili kwa lwami luvaha, vandu vevapolili higa na vangagenda valamisiwi. ");
INSERT INTO xnj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kwavili na luheku luvaha pamuji wenuwo. ");
INSERT INTO xnj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Hinu pamuji wenuwo kwavili na mundu mmonga liina laki Simoni, mweakitili uhavi waki, pamuji wenuwu na kuvakangasa vandu va ku Samaliya, akujikwiha kuvya mwene ndi mweitopela, ");
INSERT INTO xnj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","na vandu voha vadebe na vavaha, vamyuwanili hotohoto vakajova, “Simoni ndi makakala ga uchapanga gegikemelewa ‘Makakala gavaha.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Vamlandili ndava avakangisi kwa lukumbi lutali ndava ya uhavi waki. ");
INSERT INTO xnj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nambu pavasadiki ujumbi wa Filipi kulivala Lilovi la Bwina la Unkosi wa Chapanga na kuyuwana makokoso ga Yesu Kilisitu, vagosi na vadala vabatiziwi. ");
INSERT INTO xnj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hati Simoni mwene, asadiki na peamali kubatiziwa, akalongosana na Filipi, akakangasa makangaso na gachinamtiti geahengili. ");
INSERT INTO xnj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Vamitumi vala vevavili ku Yelusalemu, pevayuwini kuvya vakolonjinji va ku Samaliya vayidakili Lilovi la Chapanga, ndi vakavatuma kwenuko Petili na Yohani. ");
INSERT INTO xnj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hinu pavahikili vakavayupila kwa Chapanga vamsadika vala, muni vampokela Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ndava lukumbi lwenulo Mpungu Msopi avi akona kuvahelelela yeyoha pagati yavi, nambu vamali kubatiziwa paliina la Bambu Yesu ndu. ");
INSERT INTO xnj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kangi Petili na Yohani vakavavikila mawoko gavi vamsadika, navene mewa vampokili Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hinu Simoni pealoli kuvya mukuvikiwa mawoko na vamitumi, vamsadika vampokili Mpungu Msopi. Alingili kuvapela mashonga Petili na Yohani, akajova, ");
INSERT INTO xnj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Mnipela na nene uhotola wenuwo muni nakamvikila mawoko mundu yeyoha, apokela Mpungu Msopi.” ");
INSERT INTO xnj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nambu Petili akamyangula, “Fwila kulongolo na mashonga gaku ndava wihololela kuvya wihotola kugula makakala ga Chapanga kwa mashonga! ");
INSERT INTO xnj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Veve uvi lepi na lilundu amala pandu popoha mulihengu ili, muni mtima waku uganisa lepi palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ndava muni, umuwuyila Chapanga waku kwa kukotoka uhakau waku, kavili umuyupa Bambu mwene ihotola kukulekekesa maholo ngati ago. ");
INSERT INTO xnj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nikulola hotohoto umelili wihu neju, ndi mkungiwa wa kumbudila Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni akayangula, “Chondi, muniyupilayi kwa Bambu, likoto kunikolela hati limonga pagati ya ago gemujovili.” ");
INSERT INTO xnj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petili na Yohani pevamalili kujova malovi gavi ga kukokosa ujumbi wa Bambu, vakawuya ku Yelusalemu. Hinu pavavi mukuwuya vakakokosa Lilovi la Bwina muhijiji yamahele ya ku Samaliya. ");
INSERT INTO xnj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mtumu wa kunani kwa Chapanga akamjovela Filipi, “Jitendelekela uhamba kusini kupitila njila yeyihuma ku Yelusalemu mbaka ku Gaza.” ");
INSERT INTO xnj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi peamali kujitendelekela, akatumbula lugendu lwa kuhamba Yelusalemu. Lukumbi lwenulo kwavili na mkolonjinji mmonga wa ku Ethiopia. Avi mvika mashonga wa Kandake, nkosi wa Chidala wa ku Ethiopia. ");
INSERT INTO xnj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mweavili munjila kuwuya kunyumba kuhuma ku Yelusalemu kweahambili kumlumba Chapanga, atamili mumkokoteni wa kubiluswa kuni ajisomelayi kwa lwami chitabu cha mlota wa Chapanga Isaya. ");
INSERT INTO xnj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mpungu Msopi akamjovela Filipi, “Hamba papipi na mkokoteni wenuwo ulongosana nayu.” ");
INSERT INTO xnj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipi akajumbalila papipi na mkokoteni wula, akamyuwana mundu yula isoma muchitabu cha mlota wa Chapanga Isaya. Penapo Filipi akamkota, “Wu, ukuchimanya chewisoma?” ");
INSERT INTO xnj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mundu yula akamyangula, “Nihotola wuli kumanya changali mundu kunidandaulila?” Ndi akamgongolela Filipi akwela mumkokoteni wula na kutama pamonga na mwene. ");
INSERT INTO xnj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pandu pa Mayandiku Gamsopi peasomayi vayandiki aga, “Avi ngati limbelele lelihamba kuhinjwa, chinunu ngati mwana limbelele cheidumuliwa mangoma, nakuyahamula mlomo. ");
INSERT INTO xnj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Akoliwi soni na kunotewa chechikumvala. Avi lepi wa kuhotola kulongela ndava ya mundu yoyoha chaki, muni wumi waki uwusiwi pamulima.” ");
INSERT INTO xnj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Muyimila hindu yula akamkota Filipi, “Nijovela, mlota wa Chapanga uyu ijova mambu aga ndava yaki mwene, amala ndava ya mundu yungi?” ");
INSERT INTO xnj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Hinu Filipi akatumbula pandu pa Mayandiku Gamsopi ago, akamjovela Lilovi la Bwina ndava ya Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pevavi vakona munjila, vakahika pandu pepavi na manji ndi mundu yula akajova, “Pandu apa pana manji, wu, chivii chindu kiki chechikunibesa nene kubatiziwa?” ");
INSERT INTO xnj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi akajova, “Ngati wisadika kwa mutima waku woha wihotola kubatiziwa.” Namwene akajova, “Nisadika Yesu Kilisitu ndi Mwana wa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hinu myimila hindu yula akahamula mkokoteni wa kubiluswa wula uyima, Filipi na mwene vakahuluka mumanji ndi Filipi akambatiza. ");
INSERT INTO xnj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pavahumili mumanji Mpungu wa Bambu amkitili Filipi awuka, myimilila hindu akotoka kumlola kavili, nambu mwene akayendelela na lugendu lwaki kuni avi na luheku. ");
INSERT INTO xnj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nambu Filipi akahumila ku Azoto, na munjila avi mukukokosa Lilovi la Bwina mbaka peahikili ku Kaisalia. ");
INSERT INTO xnj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nambu lukumbi lwenulo, Sauli ayonjokisi kuvayogofya kwa kuvakoma vamulanda va Bambu. Akahamba kwa Mteta Mkulu, ");
INSERT INTO xnj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akayupa balua ya kummanyisa kwa nyumba za kukonganekela Vayawudi zezavi ku Damasko, muni akavakolela vandu vevilanda Njila ya Bambu, vagosi amala vadala, avakamula na kuvaleta ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sauli peavi munjila papipi kuhika ku Damasko, chigafula lumuli kuhuma kunani kwa Chapanga lukamtindila kumlangasa mwene pandi zoha. ");
INSERT INTO xnj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sauli akagwa pahi ndi akayuwana lwami lukumjovela, “Sauli, Sauli! Ndava kyani ukuning'aha?” ");
INSERT INTO xnj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli akakota, “Ndi wayani veve, Bambu?” Na lwami lula lukayangula, “Nene ndi Yesu mweukuning'aha. ");
INSERT INTO xnj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nambu hinu yima uhamba kumujini, kwenuko ndi kwewijoviwa chechikugana kuchihenga.” ");
INSERT INTO xnj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Vandu vevavi mulugendu pamonga na Sauli vayimili nuu ndava ya kukangaswa, vayuwini lwami lula nambu vamuwene lepi mundu yoyoha. ");
INSERT INTO xnj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli akayinuka, peagubukwili mihu gaki, nakuhotola kulola, hinu vandu vevavi mulugendu nawu vakamkamula chiwoko kumlongosa mbaka ku Damasko. ");
INSERT INTO xnj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli atamili magono gadatu changalola, na lukumbi lwenulo lwoha atamii changalya chindu amala kunywa chindu chochoha. ");
INSERT INTO xnj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasko kula ndi kwavili na msadika mmonga liina laki Anania. Mwenuyo akemeliwi kujovewa na Bambu mumawono, “Anania!” Mwene akayidika, “Nivii apa, Bambu.” ");
INSERT INTO xnj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mwene Bambu akamjovela, “Ujitendelekahi uhamba kunjila yeyikemelewa Selede mbaka kunyumba ya Yuda ukotayi kumvala mundu yula mweahumili ku Taso, liina laki Sauli. Hinu akumuyupa Chapanga, ");
INSERT INTO xnj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na Sauli amali kuloleswa mumaono na Bambu, kuvya mundu mweikemiwa Anania avi kuyingila mugati na kumvikila mawoko muni alola kavili.” ");
INSERT INTO xnj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nambu Anania akayangula, “Bambu, vandu vamahele nivayuwini mambu gakumvala mundu uyu, niyuwini gahakau neju geavahengili vamsadika vaku ku Yelusalemu kula. ");
INSERT INTO xnj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na hinu vamteta vakulu vampeli uhotola Sauli abwela kuni ku Damasko kuvakamula voha vevakukusadika veve.” ");
INSERT INTO xnj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nambu Bambu akamjovela Anania, “Uhamba ndu, muni mwenuyo nimuhagwili muni anihengela, kukokosa ndava ya liina langu kwa vandu vangali Vayawudi na vankosi vavi na kwa vandu va Isilaeli. ");
INSERT INTO xnj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Namwene yati nikumlangisa mambu gamahele gegakumgana kung'aiswa ndava yangu.” ");
INSERT INTO xnj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hinu Anania akahamba mbaka panyumba yeniyo, akayingila mugati, kangi akamvikila mawoko Sauli. Akamjovela “Mlongo Sauli, Bambu Yesu ndi mweanitumili, mwene akuhumalili pawakavili munjila kubwela kuni, anitumili nene muni uhotola kulola kavili na kumemeswa Mpungu Msopi.” ");
INSERT INTO xnj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bahapo vindu ngati magagau vikagwa pahi kuhuma mumihu mwa Sauli, ndi akalola kavili. Hinu akayima, akabatiziwa, ");
INSERT INTO xnj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","na peamali kulya chakulya makakala gaki gakamuwuyila. Sauli atamili pamonga na vawuliwa magono gadebe ku Damasko kula. ");
INSERT INTO xnj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bahapo akatumbula kukokosa munyumba za kukonganekela Vayawudi, kuvya Yesu ndi Mwana wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vandu voha vevamyuwini vakakangasa, vakakota, “Wu, mundu mwenuyu lepi yula mweavakomili vandu vala vevamuyupayi kwa liina la Yesu wa ku Yelusalemu? Na ndava ya mpangu wenuwo ndi abwela penapa, avakamula vandu na kuvapeleka kwa vamteta vakulu!” ");
INSERT INTO xnj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli akayonjokeseka ukekesi na makakala, ndava ya kujova hotohoto kuvya Yesu ndi Kilisitu, Vayawudi va ku Damasko luhala lukavayaga. ");
INSERT INTO xnj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pagamaliki magono gamahele, Vayawudi vakakonganeka na kukita mpangu wa kumkoma Sauli. ");
INSERT INTO xnj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nambu Sauli ayuwini mpangu wavi. Kilu na muhi vamlindili mumilyangu ya kuyingalila kumujini muni vahotola kumkoma. ");
INSERT INTO xnj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lukumbi lwa kilu vawuliwa vaki vakamtola na kumhulusa pahi mugati ya lidengu livaha mufwasi ya luwumba. ");
INSERT INTO xnj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli pahaikili ku Yelusalemu akalinga kujiwunga na vawuliwa vala. Nambu vandu voha vamyogwipi vamsadiki lepi kuvya mwene ndi mulanda wa chakaka. ");
INSERT INTO xnj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kangi Banaba akamtola Sauli na kumpeleka kwa vamitumi, akavadandaulila kumvala Sauli cheamuwene Bambu munjila, na Bambu chealongili nayu. Mewawa avadandaulili kuvya Sauli cheahotwili kukokosa muuhotola wa Yesu changali wogohi, ku Damasko kula. ");
INSERT INTO xnj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hinu Sauli akatama pamonga nawu, akagendelela pa Yelusalemu poha kuni ikokosa liina la Bambu changali wogohi. ");
INSERT INTO xnj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mewawa alongili na kuhutana na Vayawudi vevilongela Chigiliki, nambu vene vapangili kumkoma. ");
INSERT INTO xnj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Valongo vala pevayuwini mpangu wenuwo, vakamtola Sauli na kuhamba nayu ku Kaisalia ndi vakamtuma ahamba ku Taso. ");
INSERT INTO xnj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lukumbi lwenulo msambi wa vandu vevakumsadika Kilisitu vakavya na uteke na mumiji yoha ya ku Yudea na ku Galilaya na ku Samaliya. Layendalili kukula mukuyupa Bambu na kuyonjokeseka na kutangatiliwa na Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petili peavi mulugendu kila pandi mewa avahikilili vandu va Chapanga vevatamayi kumuji wa Luda. ");
INSERT INTO xnj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kwenuko akamkolili mundu mmonga liina laki Ainea mweavi na utamu wa kupola higa, ndi agonili pa mpasa mulukumbi lwa miyaka nane. ");
INSERT INTO xnj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petili akamjovela, “Ainea, Yesu Kilisitu akukulamisa. Yimuka, ujitandikila mpasa waku.” Bahapo Ainea akayima. ");
INSERT INTO xnj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vandu voha va ku Luda na ku Saloni pavawene Ainea, vakamuwuyila Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kumuji wa Yopa kwavili na mulanda mmonga mdala liina laki Tabita, kwa Chigiliki ndi Doka mana yaki huluku. Mdala mwenuyo ahengayi mambu ga kumganisa Chapanga na kuvatangatila vangangu. ");
INSERT INTO xnj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Magono genago alwalili na kufwa. Hinu vandu vayisambisi higa yaki, vakamgonesa kugolofa. ");
INSERT INTO xnj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Muji wa Luda wavi papipi na muji wa Yopa, hinu vamsadika vala pevayuwini kuvya Petili avi kwenuko, ndi vakavatuma vandu vavili na ujumbi uwu, “Chondi, ubwela kwitu kanyata.” ");
INSERT INTO xnj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hinu, Petili akawuka na kulongosana na vajumbi vala, pevamali kuhika vampeliki kugolofa. Valipwela voha vevavi penapo vamtindili Petili vakavembeneka na kumlangisa magwanda na nyula zoha zeatengenezayi Doka pavi mumi. ");
INSERT INTO xnj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petili avahumisi kuvala vandu voha akafugama akayupa kwa Chapanga. Kangi akahegelela payavi higa pala na kujova, “Tabita, yumuka!” Mwene akagubukula mihu, hinu peamuwene Petili ndi akayinuka na kutama. ");
INSERT INTO xnj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petili akamkamula chiwoko, akamyinula. Kangi akavakemela vamsadika na valipwela vala ndi akavagotolela kuni avi mumi. ");
INSERT INTO xnj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Malovi ga lijambu lenilo gadandasiki pandu poha ku Yopa, na vandu vamahele vakamsadika Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petili atamili ku Yopa kwa magono nunuyu, munyumba ya mundu mweitendelekela vindu vya chikumba liina laki Simoni. ");
INSERT INTO xnj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pamuji wa Kaisalia kwavili na mundu mmonga liina laki Kolineli, mwene avi mkulu wa manjolinjoli va chikundi chechikemelewa “Msambi wa Italia.” ");
INSERT INTO xnj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mwene avi mundu mbwina, mwene pamonga na lukolo lwaki voha vamuyupayi Chapanga. Ahengayi mambu gamahele ga kuvatangatila vangangu va Vayawudi na kumuyupa Chapanga magono goha. ");
INSERT INTO xnj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ligono limonga lukumbi lwa saa tisa ya muhi awene maono hotohoto, Mtumu wa kunani kwa Chapanga akumbwelela na kumjovela, “Kolineli!” ");
INSERT INTO xnj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolineli akamlolokesa takataka cha wogohi Mtumu wa kunani kwa Chapanga yula, ndi akamkota “Chivii kyani Bambu?” Mtumu wa kunani kwa Chapanga akamyangula, “Chapanga ayuwini kumuyupa kwaku na aganisiwi na kuvatangatila kwaku vangangu ndi akukumbwiki. ");
INSERT INTO xnj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hinu, uvatumayi vandu ku Yopa vakamtola mundu mmonga liina laki Simoni. Ndi mewa ikemelewa Petili. ");
INSERT INTO xnj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mwene ndi myehe munyumba ya Simoni, mundu mweitendelekela vindu vya chikumba. Nyumba yaki yivii pamuhana ya nyanja.” ");
INSERT INTO xnj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mtumu wa kunani kwa Chapanga yula peawukili, Kolineli akavakemela vatumisi vavili va nyumba na mmonga wa manjolinjoli vaki mweakumyidakila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Peavadandaulili mambu goha gegahumalili, akavatuma ku Yopa. ");
INSERT INTO xnj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chilau yaki, lukumbi lwa saa sita ya muhi, vandu avo vadatu mulugendu lwavi, papipi kuhika ku Yopa, Petili akakwela kunani ya nyumba kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Njala yamvinili, akanogela kulya. Nambu chakulya pachatendelekewayi mwene akalola maono. ");
INSERT INTO xnj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Awene kunani kwa Chapanga kudinduliwi na chindu ngati shuka yivaha yihuluswa pahi, kuni yikamuliwi pandi zoha mcheche za mulima. ");
INSERT INTO xnj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na mugati ya shuka yila mwavi hinyama ndalindali, hinyama ya magendelu mcheche na hinyama yeyilandala pamulima na videge vyevimbululuka. ");
INSERT INTO xnj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Akayuwana lwami lukumjovela, “Petili, yimuka hinja na ulyayi.” ");
INSERT INTO xnj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nambu Petili akamyangula, “Lepi Bambu! Nene katu niwonjili lepi chindu chochoha changayidakiliwa kulya.” ");
INSERT INTO xnj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nambu lwami lula lukamuyila kavili, “Lukamjovela vindu vyeaviyidakiliwi na Chapanga kulya, kotoka kuvikelamela vihakau.” ");
INSERT INTO xnj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lijambu lila lahengiki mala zidatu, kangi shuka yivaha yila yikawuyiswa kanyata kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petili peavi akona ikangasa maono gala mana yaki kyani, hinu vandu vala vevatumwili na Kolineli pevamanyiswi nyumba ya Simoni, vakahika pamlyangu. ");
INSERT INTO xnj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Vakahodisa kwa lwami, “Vakakota kuvya kuna myehe mweitama apa ikemiwa Simoni Petili?” ");
INSERT INTO xnj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petili pealinga kuhololela mana ya maono gala, Mpungu Msopi akamjovela, “Yuwanila! Vavi vandu vadatu vakukulonda. ");
INSERT INTO xnj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Huluka kanyata na ulongosana nawu kuhamba changali mtahu, muni nene ndi mwenivatumili.” ");
INSERT INTO xnj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hinu, Petili akahuluka pahi, akavajovela vandu vala, “Mwemukunilonda ndi nene. Ndava kyani munibwelili?” ");
INSERT INTO xnj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Vene vakamyangula, atitumili “Kolineli mkulu wa manjolinjoli, mundu mbwina, mweakumuyupa Chapanga, itopeswa na Vayawudi. Ajoviwi na mtumu wa Kunani kwa Chapanga akumgongolela kunyumba yaki, muni ayuwana chochoha chila cheukumjovela.” ");
INSERT INTO xnj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petili akavakemela mugati mula, akavapela pandu pa kugona kilu yila. Chilau yaki, Petili akatumbula lugendu pamonga nawu. Vamsadika vangi vevatamayi ku Yopa vakalongosana. ");
INSERT INTO xnj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ndi pamalau yaki vakahika pamuji wa Kaisalia. Kolineli avi mukuvalindila mwene na vanalukolo lwaki pamonga na vankozi veavagongolili. ");
INSERT INTO xnj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petili peavi mukuyingila Kolineli akahamba kumkumbatila cha uganu, akamfugamila mumagendelu gaki akamgundamila. ");
INSERT INTO xnj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nambu Petili akamuyinula, akamjovela, “Yima, muni nene namundu ngati veve.” ");
INSERT INTO xnj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petili na Kolineli viyingila mugati, kuni vilongela ndi vavakolili vandu vamahele vakonganiki. ");
INSERT INTO xnj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petili akavajovela, “Mwavene mmanyi hotohoto, kuvya Myawudi abesiwi na malagizu kwa njila ya kumuyupa Chapanga yaki kutangatilana na mundu angali kuvya Myawudi, amala kumgendela nambu Chapanga anilangisi nene kuvya nakuyidakiliwa kumkemela mundu yoyoha iganikiwa lepi amala mhakau. ");
INSERT INTO xnj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ndava ya yeniyo, pamwakanikemili nibweli changali mtahu. Hinu munijovela munikemelili kyani?” ");
INSERT INTO xnj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolineli akayangula, “Magono gadatu gamumbele, lukumbi lwa saa tisa ya muhi, nene navi muchumba changu kumuyupa Chapanga. Chigafula namuwene mundu mweawalili nyula zezing'asima neju, ayimili palongolo yangu, ");
INSERT INTO xnj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","anijovili, Kolineli! Chapanga ayuwini chewiyupa pamonga na teta zaku kwa vangangu. ");
INSERT INTO xnj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hinu uvatuma vandu vahamba ku Yopa, vakamkemela mundu mmonga liina laki Simoni mweikemelewa mewa Petili. Mwenuyo avili kunyumba ya Simoni, mundu mweitendelekela vindu vya chikumba, nyumba yaki yivii pamumhana ya nyanja. ");
INSERT INTO xnj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ndi kanyata navatumili vajumbi kwaku, wamwene ukitili chabwina kubwela. Tavoha apa tivii palongolo ya Chapanga, ndava ya kukuyuwanila chindu chochoha cheakulagizi Bambu utijovela.” ");
INSERT INTO xnj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kangi Petili akatumbula kujova, “Hinu nimanyili kuvya Chapanga ibagula lepi. ");
INSERT INTO xnj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nambu mundu yeyoha mumulima mweiyupa na kuhenga gakumganisa Chapanga yati iyidakiliwa namwene. ");
INSERT INTO xnj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Umanyili ujumbi wula Chapanga weavapelekili vandu va ku Isilaeli, ikokosa Lilovi la Bwina lelileta uteke kwa njila ya Yesu Kilisitu mwene ndi Bambu wa voha. ");
INSERT INTO xnj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwavene mumanyili lijambu lelahumalili pamulima woha wa Vayawudi kutumbula ku Galilaya Yohani peamali kukokosa ndava ya ubatizu. ");
INSERT INTO xnj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mwimanya kuvya Chapanga cheamhagwili Yesu wa ku Nazaleti, ndi akammemesa Mpungu Msopi na kumpela makakala. Chapanga avi pamonga nayu, mwene ahambili kila pandu kuhenga gabwina na kuvalamisa vandu voha vevang'aiswi na Setani. ");
INSERT INTO xnj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tavete tagawene mambu goha geagahengili pamulima wa Vayawudi na muji wa ku Yelusalemu. Vamkomili na kumvamba munjila ya msalaba. ");
INSERT INTO xnj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nambu Chapanga amyukisi pagamaliki magono gadatu kuhuma kwa vevafwili. Akaloleka hotohoto, ");
INSERT INTO xnj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","awonikini lepi kwa vandu voha, nambu kwa tete ndu tetamali kuhaguliwi na Chapanga kuvya vetagawene. Ndi tete vetalili na kunywelela pamonga nayu peamali kuyuka kwaki. ");
INSERT INTO xnj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Atilagazili kuvakokosela vandu voha Lilovi la Bwina na kuvajovela kuvya mwene ndi mweahaguliwi na Chapanga, kuvya mhamula wa vandu vevavili mumi na vandu vevafwili. ");
INSERT INTO xnj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Vamlota voha va Chapanga vijova ndava yaki kuvya mundu yoyoha mweakumsadika Yesu, yati ilekekeswa kumbudila Chapanga, paliina laki.” ");
INSERT INTO xnj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petili pavi akona ilongela malovi ago, Mpungu Msopi akavahelelela vandu voha vevayuwanila ujumbi wula. ");
INSERT INTO xnj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Vayawudi vamsadika vevabweli pamonga na Petili kuhuma ku Yopa, vakangisi kulola Chapanga avamemisi njombi ya Mpungu Msopi vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Muni vavayuwini vilongela kwa muluga za chiyehe kuni vakumulumbalila Chapanga. Kangi Petili akajova, ");
INSERT INTO xnj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Vandu ava vampokili Mpungu Msopi ngati tete. Wu, avi mundu yoyoha, mweakuvabesa vakotoka kubatiziwa na manji?” ");
INSERT INTO xnj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ndi akalagiza vabatiziwa kwa uhotola wa Yesu Kilisitu, kangi vakamuyupa Petili atama nawu magono nunuyu. ");
INSERT INTO xnj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Vamitumi na vamsadika nunuyu vevavi ku Yudea vayuwini kuvya vandu vangali Vayawudi navene mewa vapokili Lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hinu Petili, peawuyili ku Yelusalemu, vamsadika va Vayawudi vala vevaganisiwi kuvya vandu vangali Vayawudi vevadumwili jandu. Ndi vakang'ung'uta vakajova, ");
INSERT INTO xnj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Veve uhambili kutama na vandu vanga yingila jandu na hati kulya pamonga nawu!” ");
INSERT INTO xnj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Penapo Petili akavadandaulila hotohoto kugavala mambu gala gegahengiki. ");
INSERT INTO xnj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ligono limonga namuyupayi Chapanga kumuji wa Yopa, nagawene maono, nachiwene chindu ngati shuka yivaha yihuluswa pahi kuhuma Kunani kwa Chapanga, kuni yikamuliwi pandi zoha mcheche, yavikiwi pamuhana yangu. ");
INSERT INTO xnj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Panakalingulili bwina mugati naloli hinyama ya magendelu mcheche, na hinyama ya mudahi na hinyama yeyilandala pamulima na hidege yeyimbululuka. ");
INSERT INTO xnj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kangi nayuwini lwami lukunijovela, ‘Petili, yimuka uhinja na kulya.’ ");
INSERT INTO xnj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nambu nene nikajova, ‘Lepi Bambu, muni chakulya chochoha changayidakiliwa katu nakuyingila hati padebe mumlomo wangu.’ ");
INSERT INTO xnj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nambu lwami lwa Kunani kwa Chapanga lwayuwaniki kavili, ‘Nakuvikelema vyangayidakiliwa vyakulya vyeavinyambisi Chapanga.’ ");
INSERT INTO xnj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lijambu lenilo lahengiki mala yidatu, pamwishu vindu vyoha vikawuyiswa Kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Chigafula vandu vadatu kuhuma Kaisalia vevatumiwi kubwela kwangu vakahika panyumba mwenatamayi. ");
INSERT INTO xnj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mpungu Msopi akanijovela nihamba pamonga nawu changali mtahu. Vamsadika ava sita nalongosini nawu kuhamba Kaisalea na kwenuko tavoha tayingili munyumba ya Kolineli. ");
INSERT INTO xnj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mwene atijovili namuna cheamuwene mtumu wa kunani kwa Chapanga, cheamuhumili munyumba yaki na kumjovela, ‘Tuma vajumbi vahamba ku Yopa vakamkemela mundu mmonga liina laki Simoni paliina lingi Petili. ");
INSERT INTO xnj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mwene yati akukujovela malovi gegakusangula veve pamonga na valongo vaku.’ ");
INSERT INTO xnj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Panatumbwili kulongela, Mpungu Msopi avahelili ngati cheatumbwili kutihelela tete. ");
INSERT INTO xnj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kangi nakumbwiki malovi geajovili Bambu, ‘Yohani abatizi kwa manji nambu nyenye yati mwibatiziwa kwa Mpungu Msopi.’ ");
INSERT INTO xnj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hinu ngati Chapanga avapelili njombi vandu vangali Vayawudi ngati cheatipelili tete tetamsadiki Bambu Yesu Kilisitu, wu, nayani nene hati nilinga kumbesa Chapanga?” ");
INSERT INTO xnj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pevagayuwini malovi ago, vakaleka mhutanu, vakamlumba Chapanga, mukujova, “Kumbi! Chapanga avapeli fwasi vandu vangali Vayawudi vamuwuyila mwene vapata wumi!” ");
INSERT INTO xnj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kangi, ndava ya mang'ahiso gegahumalili lukumbi Stefani ikomiwa, vamsadika vapechengini. Vangi vakahamba mbaka Foinike vangi Kuplo na vangi ku Antiokia mukukokosa ujumbi wula kwa Vayawudi ndu. ");
INSERT INTO xnj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nambu vamsadika vangi vevahumili Kuplo na Kulene, vakahambili ku Antiokia vakakokosa ujumbi wenuwo kwa vandu vangali Vayawudi, vakokosayi Lilovi la Bwina la kumvala Bambu Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bambu avatangatili na vandu vamahele vasadiki na kumuwuyila Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Malovi ga lijambu lila lahikili msambi wa vandu vevakumsadika Kilisitu va ku Yelusalemu. Ndi vamtumili Banaba ahamba ku Antiokia. ");
INSERT INTO xnj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Peahikili kwenuko avawene vandu vamotisiwi na Chapanga, ndi akavya na luheku na kuvakangamalisa mitima voha vasindimala musadika yavi kwa Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba avili mundu mbwina na mweamemiswi Mpungu Msopi na sadika, ndava ya lihengu la Banaba msambi uvaha wa vandu wayonjokisiki kwa Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kangi, Banaba akawuka na kuhamba ku Taso kumlonda Sauli. ");
INSERT INTO xnj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hati peamuwene, amletili ku Antiokia. Voha vavili vakatama pamonga na msambi wa vandu vevakumsadika Kilisitu mu mwaka mmonga, kuni viwula msambi uvaha wa vandu. Ku Antiokia kwenuko ndi vawuliwa va kutumbula vakemeliwi Vakilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu magono genago, vamlota vangi va Chapanga vahumili ku Yelusalemu vakahelela ku Antiokia. ");
INSERT INTO xnj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Hinu, mmonga wavi mweikemiwa Agabo alotili yati kwiva na njala yivaha pamulima wula. Njala yeniyo yahumalili lukumbi lwa ulongosi wa Kilaudio. ");
INSERT INTO xnj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Vawuliwa vala vakahamula kuvatangatila vamsadika vevatama ku Yudea, kila mmonga apeleka chindu chochoha cheihotola. ");
INSERT INTO xnj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ndi vakakita mewa na kuvapela njombi zavi Banaba na Sauli vakavagotolela vagogo va vamsadika. ");
INSERT INTO xnj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Papipi na Lukumbi lwenulo, Nkosi Helodi atumbwili kuvang'aha msambi wa vandu vevakumsadika Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ahamwili Yakobo akomiwa na upanga, mlongo wa Yohani. ");
INSERT INTO xnj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Peamanyili kuvya lijambu lenilo lavaganisi Vayawudi, ndi ayendalili akamkamula Petili. Lenilo lahengiki lukumbi lwa Mselebuko wa Mabumunda gangali ngemeku. ");
INSERT INTO xnj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peamali kumkamula Petili, akamsopa muchifungu, akavika manjolinjoli mcheche mu msambi mcheche. Helodi aganili kumuhumisa pavandu pawimalika Mselebuko wa Pasaka. ");
INSERT INTO xnj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hinu, lukumbi Petili avi muchifungu, nambu msambi wa vandu vevakumsadika Kilisitu vayendalili kumuyupa Chapanga kwa kukangamala. ");
INSERT INTO xnj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kilu kwakona ligono Helodi lealindila kumuhumisa Petili pavandu, Petili agonili pagati ya manjolinjoli vavili. Kuni akungiwi minyololo yivili, na valonda vavi mlyangu wa kujela mukulindila. ");
INSERT INTO xnj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bahapo, mtumu wa kunani kwa Chapanga akamuhumila na kuyima papipi nayu na lumuli wamlangisi muchifungu. Mtumu wa Kunani kwa Chapanga yula akamtova Petili muluvafu akamuyumsa akamjovela, “Yumuka kanyata!” Bahapo, minyololo yevamkungalili mu mawoko yikadaukana na kugwa pahi. ");
INSERT INTO xnj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Hinu mtumu wa Kunani kwa Chapanga akamjovela, “Kunga mkungi na champali zaku.” Kangi akamjovela, “Uwala likoti laku na unilandayi.” ");
INSERT INTO xnj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petili akamlanda mbaka kuvala, nambu nakumanya kuvya gegihengeka na mtumu wa kunani kwa Chapanga gala ndi gachakaka, aholalili manya ilota maono. ");
INSERT INTO xnj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Vapitili msambi wa valonda va kutumbula na kugelekela chingi, ndi vakahika pamlyangu wa lyuma wa kuyingila pamuji. Mlyangu wula wadindwiki wene, navene vakahuma kuvala. Pavagendayi munjila bahapo mtumu wa kunani kwa Chapanga yula akamleka Petili. ");
INSERT INTO xnj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hinu Petili peamanyili gegahumili, akajova, “Hinu nimanya chakaka kuvya Bambu amtumili mtumu wa kunani kwa Chapanga anisangula kuhuma mu mawoko ga Helodi na mambu goha Vayawudi gevalindalila.” ");
INSERT INTO xnj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Peamanyili genago, ndi akahamba mbaka kunyumba ya Maliya nyina waki Yohani mweikemiwa mewawa Maluko. Mwenumo vandu vamahele vakonganiki kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petili ahodisi mlyangu wa kuvala na mdala mmonga mtumisi liina laki Loda, akamyidakila. ");
INSERT INTO xnj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Msikana yula amanyili kuvya mweihodisa ndi Petili, akavya na luheku neju, hati kwakona kudindula mlyangu wula ndi akajumbalila mugati kuvajovela kuvya Petili ayimili kuvala ya mlyangu. ");
INSERT INTO xnj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Vakamjovela msikana yula, “Una lupengu!” Nambu mwene akakangamala kujova chakaka. Vene vakamyangula, “Mwenuyo ndi manya mtumi waki.” ");
INSERT INTO xnj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Lukumbi lwenulo Petili ayendelela kuhodisa mlyangu. Pamwishu vakadindula mlyangu pavamuwene vakakangasa neju. ");
INSERT INTO xnj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mwene akavagunisa kwa kuvalangisa chiwoko, akavadandaulila Bambu cheamusiwi muchifungu. Kangi akavajovela lijambu lenilo vavajovela Yakobo na vamsadika vangi vala, kavili akawuka na kuhamba pandu pangi. ");
INSERT INTO xnj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kwapachili wogohi wavayingili manjolinjoli vala, vakatumbula kukotana, “Kyani chechimkolili Petili?” ");
INSERT INTO xnj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helodi akalagazila vamlonda, nambu vamuwene lepi. Hinu akalagiza manjolinjoli vala vakotiwa, kangi akahamula vakomiwa. Helodi akawuka ku Yudea kula, na kuhamba kumuji wa Kaisalia na kutama. ");
INSERT INTO xnj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helodi ayomiswi neju na vandu va ku Tilo na vandu va ku Sidoni, hinu vene vampelekili vajumbi. Vene vakahotola kumkulukisa hoti Blasto avyaa upandi wavi, Blasto avi myimilila mkulu wa nyumba ya Unkosi. Kangi vakamhambila Helodi na kumuyupa kuvya na uteke, muni mulima wavi wahuvalila mulima wa Nkosi ndava ya chakulya. ");
INSERT INTO xnj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ligono limonga lelahaguliwi, Helodi kuni awalili nyula yaki ya unkosi na kutama pachigoda cha unkosi, avakokosili vandu. ");
INSERT INTO xnj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Vandu vala vakaluluta kwa lwami vakajova, “Lwenulo ndi lwami lwa chapanga, lepi lwa mundu.” ");
INSERT INTO xnj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bahapo mtumu wa kunani kwa Chapanga akamgwisa Helodi pahi ndava amlumbalili lepi Chapanga, ndi akamemenwa na mangokoko ndi afwili. ");
INSERT INTO xnj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nambu Lilovi la Chapanga likayonjokesa kukula na kudandasika. ");
INSERT INTO xnj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Sauli pevamalili lihengu lavi, vakawuya ku Yelusalemu vakamtola Yohani mweikemiwa Maluko. ");
INSERT INTO xnj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu msambi wa vandu vevakumsadika Kilisitu va ku Antiokia kwavili na vandu vangi vevavi vamlota va Chapanga na vawula, pagati yavi vavi Banaba na Sauli na Simioni mweikemiwa mtitu, Lukio wa Kulene, Manaeni mwealeliwi pamonga na Nkosi Helodi. ");
INSERT INTO xnj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pavamuyupayi Bambu na kujihinisa chakulya, Mpungu Msopi akavajovela, “Mnihagulila Banaba na Sauli ndava ya lihengu lenivakemelili.” ");
INSERT INTO xnj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hinu vakajihinisa chakulya neju na kumuyupa Chapanga, vakavapamisa mawoko panani yavi vakavatuma vahamba. ");
INSERT INTO xnj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hinu, Mpungu Msopi peamali kuvatuma Banaba na Sauli, vakahelela mbaka Seleukia na kuhuma kwenuko vakayingila muwatu mbaka kukisiwa cha Kuplo. ");
INSERT INTO xnj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pavahikili ku Salami vakakokosa Lilovi la Chapanga munyumba za kukonganekela Vayawudi. Yohani Maluko avi mtangatila wavi. ");
INSERT INTO xnj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Vagendili kuhuma upandi umonga na kuhamba upandi wungi wa kisiwa na kuhika Pafo, vamkolili mundu mmonga Myawudi mhavi liina laki Bal yesu mlota wa udese. ");
INSERT INTO xnj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mwenuyo avi pamonga na Seligio Pauli, mkulu wa kisiwa chila avi mundu wa luhala neju. Selgio Pauli avakemili Banaba na Sauli muni ayuwana Lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nambu mhavi yula Bal yesu mweikemelewa Elima kwa Chigiliki, alingili kuvabelelela muni kumbesa mkulu wa kisiwa chila akotoka kusadika sadika ya Chikilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hinu Sauli mweikemiwa mewa Pauli, kuni amemisiwi Mpungu Msopi, akamlolokesa takataka mhavi yula, ");
INSERT INTO xnj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na kujova, “Veve wamwana wa Setani, likoko wa kila chindu chechimganisa Chapanga, mweumemili uhakau na udese. Nakuleka hati padebe kubudisa uchakaka wa njila selede za Bambu! ");
INSERT INTO xnj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hinu, chiwoko cha Bambu yati chikubuna, yati wivya ngalola nakuhotola kulola lilanga mulukumbi.” Bahapo Elima chitita chikayingila mumihu gaki hati gakakoyoko, hati akatumbula kupamisa kuni na kuni, kulonda mundu wa kumkamula chiwoko amulongosa. ");
INSERT INTO xnj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mkulu wa kisiwa yula peagawene mambu gala, akasadika, akakangasa neju ndava ya mawuliwu gakumvala Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kangi Pauli na vayaki vakawuka Pafo, vakayingila muwatu na kuhamba kumuji wa Peliga mulima wa Pamfulia. Nambu Yohani Maluko avalekili na kuwuya ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nambu vene vayendalili na lugendu kuhuma Peliga mbaka pamuji wa Antiokia ya Pisidia. Ligono la Kupumulila vakayingila munyumba ya kukonganekela Vayawudi na kutama pahi. ");
INSERT INTO xnj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pevamali kusoma muchitabu cha malagizu ga Bambu geampeli Musa na Mayandiku ga Vamlota va Chapanga, vala vachilongosi va nyumba ya kukonganekela Vayawudi yila vavatumili ujumbi uwu, “Valongo ngati kuvi na malovi ga kuvakangamalisa mitima vandu ava mujova.” ");
INSERT INTO xnj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ndi Pauli akayima na kuvapungila chiwoko na kutumbula kuvajovela, “Vakolonjinji va Isilaeli na voha mwemumtopesa Chapanga, muniyuwanila! ");
INSERT INTO xnj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chapanga wa mulima uwu wa Isilaeli avahagwili vagogo vitu, akavakita vandu va kuvya mulima uvaha pavatamayi kuuyehe ku Misili. Kangi akavawusa kwenuko kwa makakala gaki. ");
INSERT INTO xnj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Akasindimala nawu mulukumbi lwa miyaka alobaini kulugangatu kula. ");
INSERT INTO xnj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akagakomekesa makabila saba ga mulima wa Kanani ndi akavapela mulima wenuwo vandu avo kuvya uhali wavi. ");
INSERT INTO xnj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mambu ago gahengiki kwa lukumbi lwa miyaka miya mcheche na hamsini.” “Kangi akavapela vahamula mihalu vavalongosa mbaka magono ga mlota wa Chapanga Samueli. ");
INSERT INTO xnj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chechagelekili ndi vakamyupa nkosi, ndi Chapanga akavapela Sauli mwana wa Kishi wa lukolo lwa Benjamini, akalongosa mulukumbi lwa miyaka alobaini. ");
INSERT INTO xnj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Peamuwusili Sauli, Chapanga akamhagula Daudi avya nkosi wavi. Chapanga mwene akavajovela hotohoto, nimhagwili Daudi mwana wa Yese, ndava muni mundu mweakuniganisa. Mwenuyo ndi mweihenga mambu goha genikugagana. ");
INSERT INTO xnj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhuma mu chiveleku cha mundu mwenuyo, Chapanga ngati cheavalagizi vandu va Isilaeli kuvapelekela Msangula ndi Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu peavi akona kutumbula lihengu laki, Yohani amlongolili na kuvakokosela vandu voha va Isilaeli kuvya yikuvagana vamuwuyila Chapanga na kubatiziwa. ");
INSERT INTO xnj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohani peavi mukumala ujumbi waki avajovili vandu, Mwiholela nene ndi yani? Mwemkumlindila lepi nene. Nambu yuwanila! Mweibwela mumbela yangu, nene nakuganikiwa hati kuwopola nyosi za champali zaki!” ");
INSERT INTO xnj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Valongo vangu, nyenye chiveleku cha Ibulahimu, na vangi voha mwemkumtopesa Chapanga! Ujumbi uwu wa usangula uletiwi kwitu! ");
INSERT INTO xnj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Muni vakolonjinji va Yelusalemu na vakulu vavi vammanyili lepi Yesu kuvya Msangula, katu nakugamanya malovi ga vamlota va Chapanga gegasomewa kila Ligono la Kupumulila. Pamonga na ago vakagatimilisi kwa kumkoma Yesu lifwa. ");
INSERT INTO xnj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pamonga na avi lepi na yeyikumgana akomiwa, vamyupili Pilatu amhukumwa lifwa. ");
INSERT INTO xnj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na pevamali kuhenga goha gegayandikiwi kumvala Yesu, vakamuhulusa kuhuma mu msalaba, vakamvika mu litinda la mbugu. ");
INSERT INTO xnj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nambu Chapanga amuyukisi kwevafwili. ");
INSERT INTO xnj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mwene kwa magono gamahele, avahumalili vealongosini nawu kuhuma ku Galilaya mbaka ku Yelusalemu. Venavo ndi hinu vandu vevakujovela vandu va Isilaeli mambu ga Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Hinu tete tikuvakokosela nyenye Lilovi la Bwina, lenilo ndi lilaganu kwa vagogo vitu, ");
INSERT INTO xnj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Chapanga ahengili lilaganu lenilo ndava yitu tete chiveleku chavi kwa kumyukisa Yesu, ngati cheyiyandikiwi Muzabuli ya pili, ‘Veve ndi Wamwana vangu na nene lelu na Dadi waku.’ ");
INSERT INTO xnj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na ndava ya kumyukisa kwevafwili, nakuwuya kavili kwenuko ndi awolili lepi. Chapanga ajovili, ‘Yati nikupela mota ya usopi na uchakaka zezanamlagazili Daudi.’ ");
INSERT INTO xnj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hinu wijova mu mayandiku gangi ga Zabuli, ‘Umleka lepi Msopi waku awola.’ ");
INSERT INTO xnj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daudi mwene ahengili geigana Chapanga mulukumbi lwaki, na kangi afwili na kuvikiwa mu litinda la mbugu papipi na vagogo vaki, na higa yaki yawolili. ");
INSERT INTO xnj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nambu yula mweayukiswi na Chapanga kwa vafwili awolili lepi. ");
INSERT INTO xnj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ndava muni valongo vitu tigana nyenye mumanya chakaka kuvya munjila ya Yesu, ujumbi wa kulekekesewa kumbudila Chapanga ukokoswa kwinu, ");
INSERT INTO xnj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","mundu yoyoha mweamsadika mwene ndi ilekekesewa kumbudila Chapanga kwoha, lijambu langahotoleka ndava ya kulanda Malagizu ga Bambu geampeli Musa. ");
INSERT INTO xnj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mujiyangalila, gegajoviwi na vamlota va Chapanga gala gakotoka kuvakolela, ");
INSERT INTO xnj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Myuwanila, nyenye mwemuvi na likomo, mkangasayi na mfwayi! Muni chindu chenihenga hinu, mulusenje lwinu, yati musadika lepi hati ngati mundu avajovoli.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Banaba pavawukili munyumba ya kuyupila Chapanga mula, vandu vala vakavagongolela vabwela Ligono la Kupumulila leligelekela, vavakangamalisa mambu gala. ");
INSERT INTO xnj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mngonganu wula pawamaliki Vayawudi vamahele na vandu vangali Vayawudi vevayingili njila ya kumuyupa Chapanga ya Vayawudi ndi vakavalanda Pauli na Banaba. Vene vakalongela nawu na kuvakangamalisa mitima vayendelela kutama kwa kuhuvalila ubwina wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ligono la Kupumulila lila lelagelekili kila mundu pamuji wula abwelili kuyuwanila Lilovi la Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nambu Vayawudi pavawaweni vandu vamahele vakamema wihu, vakagabela malovi gaajovayi Pauli na vakamliga. ");
INSERT INTO xnj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pauli na Banaba vakalongela kwa ukekesi neju, “Yaganikiwi Lilovi la Chapanga litumbula kuvahikila hoti nyenye, nambu ndava mulibelili na kuvya nakuhotola kupokela wumi wa magono goha, hinu tikuvaleka na kuvahambila vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Muni Bambu atilagazili aga, ‘Nikuviki lumuli lwa vandu va pamulima, muni vandu voha vasanguliwa pamilima yoha.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Vandu vangali Vayawudi pevayuwini lijambu lila vakavya na luheku, vakaulumbalila ujumbi wa Bambu na vevahaguliwi vala kupewa na wumi wa magono goha wangali mwishu, vakavya vamsadika. ");
INSERT INTO xnj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilovi la Bambu ladandasiki kila pandu pamulima. ");
INSERT INTO xnj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nambu Vayawudi vakavakulukisa vadala vangali Vayawudi vevitopeswa vevakumuyupa Chapanga na vagosi vevimanyikana wa muji wula. Vakatumbula kuvang'aha Pauli na Banaba, vakavavinga vahuma pamuji wavi. ");
INSERT INTO xnj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hinu vamitumi vala vakakung'unda lububu mumagendelu gavi kulangisa vabeli Lilovi la Bambu na vakahamba ku Ikonio. ");
INSERT INTO xnj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na vamsadika va ku Antiokia, ndi vamemiswi luheku na Mpungu Msopi. ");
INSERT INTO xnj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mewawa ku Ikonio kula, Pauli na Banaba vakayingila munyumba ya kukonganekela Vayawudi. Vakalongela cha ukekesi hati msambi uvaha wa Vayawudi na Vagiliki vakasadika. ");
INSERT INTO xnj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nambu Vayawudi vevabeli kusadika vakavakulukisa vandu vangali Vayawudi vavayomela Pauli na Banaba. ");
INSERT INTO xnj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Vayendalili kutama kwenuko mulukumbi lutali. Vakalongela cha ukekesi ndava ya Bambu, na Bambu mwene ajilangisi uchakaka wa ujumbi wevihumisa kwa ubwina waki, kwa kuvahotosa kukita gachinamtiti na makangaso. ");
INSERT INTO xnj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vandu va muji wula vakalekengana, vangi vakavya upandi wa Vayawudi na vangi vakavya upandi wa vamitumi vala. ");
INSERT INTO xnj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kangi vandu vangali Vayawudi na Vayawudi pamonga na vachilongosi wavi, vakakita mpangu wa kuvakitila gahakau na kuvakoma kwa maganga. ");
INSERT INTO xnj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Vamitumi vala pevamanyili mpangu wenuwo, vakajumbalila ku Lusitila na ku Delibe, miji ya ku Lukonia, na pamwambu ya miji ya papipi, ");
INSERT INTO xnj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ndi vakayendelela kukokosa Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lusitila kwenuko kwavili na mundu mmonga mweavi ngagenda kutumbula kuvelekewa kwaki, katu nakuhotola kugenda. ");
INSERT INTO xnj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ngagenda yula amyuwanilayi Pauli peakokosayi. Hinu Pauli akamlolokesa takataka na peamanyili kuvya avi na sadika ya kuhotola kulamiswa, ");
INSERT INTO xnj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","akamjovela kwa lwami luvaha, “Yima na magendelu gaku!” Bahapo mundu yula akahumba na kutumbula kugenda. ");
INSERT INTO xnj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Msambi wa vandu pavawene lijambu leakitili Pauli, vakajova kwa lwami luvaha muluga ya Kilukaonia, “Hinu vachapanga vatibwelili kwa musula ya mundu!” ");
INSERT INTO xnj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Vakavapele mahina ga uchapanga, Banaba vakamkemela Zeu, na Pauli ndava muni avi mjovaji mkulu, vakamkemela Helime. ");
INSERT INTO xnj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mteta wa chapanga Zeu, nyumba yaki yavi pamuhana ya muji, akagega ng'ombi mpapakasi na njingwa ya maluva palongolo ya mlyangu ukulu muji pamonga na msambi wa vandu vagana kuvawusila luteta vamitumi. ");
INSERT INTO xnj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nambu Banaba na Pauli pevayuwini malovi gala vakapapula nyula zavi na kujumbalila pamsambi wa vandu wula, na kujova kwa lwami luvaha. ");
INSERT INTO xnj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Vagosi nyenye, ndava kyani mwikita lijambu lenili? Tete mewa tavandu ngati nyenye. Ndi tikuvakokosela Lilovi la Bwina, nyenye mukoto kugundamila chimong'omong'o, mumuwuyila Chapanga wa wumi, mweawumbili kunani na mulima na nyanja pamonga na vindu vyoha. ");
INSERT INTO xnj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kadeni Chapanga avalekekisi vandu voha vahenga chevigana vene. ");
INSERT INTO xnj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nambu Chapanga alekili lepi kujilangisa kwa mambu gabwina geavahengili, kuvatonyela fula kuhuma kunani, kuvapela mabenu mulukumbi lwaki na kuvapela chakulya cha kuyimemesa mitima yavi luheku.” ");
INSERT INTO xnj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pamonga na vamitumi kujova malovi genago, yavili nakunonopa kuubelelela msambi wa vandu ukoto kuvawusila luteta. ");
INSERT INTO xnj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kangi Vayawudi nunuyu vakabwela kuhuma Antiokia na Ikonio, vakavakulukisa vandu, vamtova Pauli na maganga. Vakamkwega mbaka kuvala ya muji, kuni vahololela afwili. ");
INSERT INTO xnj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nambu vawuliwa pavamtindili akayumuka akawuya kumujini. Chilau yaki mwene pamonga na Banaba vakahamba ku Delibe. ");
INSERT INTO xnj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pauli na Banaba vakakokosa Lilovi la Bwina ku Delibe, ndi vakayonjokeseka vawuliwa vamahele. Kangi vakawuya ku Antiokia vakavedukila Lusitila na Ikonio. ");
INSERT INTO xnj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ndi vakavakangamalisa mitima vamsadika, vasindimala na sadika yavi, vakavajovela ngati tavoha yikutigana kuyingila Muunkosi wa Chapanga munjila ya mang'ahiso gavaha. ");
INSERT INTO xnj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pauli na Banaba vakavahagula vagogo mukila msambi wa vandu vevakumsadika Kilisitu ndava ya kuyupa Chapanga na kujihinisa chakulya, vakavavika muulonda wa Bambu mwevakumsadika. ");
INSERT INTO xnj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pevamalili kupitila Pisidia ndi vakahika Pamfulia. ");
INSERT INTO xnj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kangi pevamalili kuvakokosela ujumbi wula vandu va ku Peliga, ndi vakahamba ku Atalia. ");
INSERT INTO xnj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mulugendu vakahuma ku Atalia vakawuya ku Antiokia kwevayupiwi ubwina wa Chapanga, ndava ya lihengu levakitili. ");
INSERT INTO xnj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na pavahikili vahengili mngonganu na vamsadika vakavajovela vandu mambu goha, Chapanga geagahengili pamonga nawu, na cheavadindulili vandu vangali Vayawudi mlyangu wa sadika. ");
INSERT INTO xnj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ndi vakatama pamonga mulukumbi lutali na vamsadika vala. ");
INSERT INTO xnj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Hinu, vandu vangi vakahuma ku Yudea na kubwela ku Antiokia, vakatumbula kuvawula valongo vala, nakuhotola kusanguliwa ngati mwangayingila jandu, ngati mvelu wa Musa cheulagiza. ");
INSERT INTO xnj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pauli na Banaba vakavya na mhutanu na vandu vala ndava ya lijambu lila, ndi vakahamuliwa Pauli na Banaba pamonga na vamsadika vangi va Antiokia vahamba ku Yelusalemu kukonganeka na vagogo na vamitumi ndava ya lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mulugendu lwavi msambi wa vandu vevakumsadika Kilisitu ndi vavatangatili, vakapitila ku Foinike na ku Samaliya na kuvajovela vandu vangali Vayawudi chavamsadiki Chapanga. Malovi ago gavagahekisi neju vamsadika voha. ");
INSERT INTO xnj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pavahikili ku Yelusalemu, vakagongolelewa na msambi wa vandu vevakumsadika Kilisitu na vamitumi na vagogo, vene vakavajovela mambu goha Chapanga geagahengili pamonga nawu. ");
INSERT INTO xnj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nambu vamsadika vangi va msambi wa Vafalisayu vakayima na kujova, “Yikuvagana vandu vangali Vayawudi vadumuliwa jandu na kuvalagiza kulanda mhilu wa Musa.” ");
INSERT INTO xnj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hinu vamitumi na vagogo vakakonganeka ndava ya kulongalela lijambu lenilo. ");
INSERT INTO xnj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ndi pavakotini neju, Petili akayima na kujova, “Valongo vangu, mumanyili kuvya Chapanga anihagwili nene kadeni pagati yinu muni nikokosayi Lilovi la Bwina kwa vandu vangali Vayawudi navene vayuwana na vasadikayi. ");
INSERT INTO xnj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Chapanga mweimanya mitima ya vandu, ajilangisi kuvayidakila kuvapela Mpungu Msopi vene ngati cheatipeli tete. ");
INSERT INTO xnj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nakuvabagula vandu, tete amala vene, ainyambisi mitima yavi ndava vakumsadika. ");
INSERT INTO xnj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hinu ndava kyani kumlinga Chapanga, mukuvagegesa ndwika vamsadika vala, ndwika vagogo vitu wala tavete tihotola lepi kugega? ");
INSERT INTO xnj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lepi, ndi tete tisadika ngati vene, yati tisanguliwa munjila ya ubwina wa Bambu Yesu.” ");
INSERT INTO xnj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Mngonganu wa vandu voha wagunili nuu, ukuwayuwanila Pauli na Banaba vidandaula gachinamtiti na makangaso, Chapanga geagahengili muujumbi wavi kwa vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pevamali kulongela, Yakobo akatumbula kujova, “Muniyuwanila valongo vangu! ");
INSERT INTO xnj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni Petili atidandaulili Chapanga penapo kadeni cheajilangisi kwa vandu vangali Vayawudi na kuvahagula vangi pagati yavi, vavyai vandu vaki. ");
INSERT INTO xnj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lijambu lenilo ndi liyidakilana na malovi ga vamlota va Chapanga, ngati Mayandiku Gamsopi chegijova, ");
INSERT INTO xnj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bambu ajovili, pagenaga yati niwuya, na kuujenga kavili nyumba ya Daudi, yeyigwili. ");
INSERT INTO xnj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Vandu vangi voha na vandu vangali Vayawudi, voha venivakemili vavyayi vangu yati vakunilonda Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ndi cheajovili Bambu, mweagamanyisi mambu aga kuhuma kadeni.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo akayendelela kujova, “Nene nilola kuvya chabwina lepi kuvang'aha vandu vangali Vayawudi vevakumsadika Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nambu chabwina tivayandikila ujumbi kuvajovela, vayepa kulya vyakula vihakasa vya mahoka, vayepa ukemi vayepa kulya hinyama yidodanu na vayepa kulya ngasi. ");
INSERT INTO xnj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ndava muni kutumbula kadeni mhilu wa Chapanga weampelili Musa, wisomiwa kila Ligono la Kupumulila munyumba za kukonganekela Vayawudi, na malovi gaki gikokoselewa kila muji.” ");
INSERT INTO xnj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kangi vamitumi na vagogo va msambi wa vandu vevakumsadika Kilisitu voha vakahamula kuvahagula vandu nunuyu mumasambi wavi na kuvatuma ku Antiokia pamonga na Pauli na Banaba. Ndi vakamhagula Yuda mweikemiwa Basaba na Sila, vevitopeswa neju na vamsadika. ");
INSERT INTO xnj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Vavapelili ujumbi weuyandikiwi aga, “Tete vamitumi na vagogo, valongo vinu, tikuvajambusa vayitu mwangali kuvya Vayawudi mwemuvi ku Antiokia na ku Silia na ku Kilikia. ");
INSERT INTO xnj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tiyuwini kuvya vandu nunuyo vakuhuma kwitu vavang'aisi mtima yinu na malovi gavi, vahengili genago changali malagizu gitu. ");
INSERT INTO xnj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Hinu kwa pamonga tiyidakilini kuvahagula vajumbi vangi, valongosana pamonga na vankozi vitu Pauli na Banaba tivatumili kubwela kwinu. ");
INSERT INTO xnj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Vandu vevajiwusili kuyagisa wumi wavi ndava ya kumhengela Bambu witu Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ndava muni tivatumili Yuda na muyaki Sila, vene yati vakuvadandaulila malovi goha getivayandikili. ");
INSERT INTO xnj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hinu yimganisi Mpungu Msopi na tete tikotoka kuvagegesa ndwika neju ya mambu gala gegalagaziwi. ");
INSERT INTO xnj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mkoto kulya vyakulya veviwusiwi mahoka, kavili ngasi ya hinyama mkoto kunywa na mewawa hinyama yevadodili mkoto kulya, myepa ukemi. Yati muhenga chabwina ngati muyepili kuhenga mambu ago!” ");
INSERT INTO xnj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ndi pevamali kulagana, vajumbi vala vakawuka na kuhamba ku Antiokia. Kwenuko vakaukemela msambi wa vamsadika na kuvagotolela balua yeyiyandikwi yila. ");
INSERT INTO xnj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hinu pevamali kusoma ujumbi wula, malovi gaki gakavangamalisa mitima, vakavya na luheku neju. ");
INSERT INTO xnj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila vevavi vamlota va Chapanga, valongili nawu mulukumbi lutali vakuvapolesa na kuvakangamalisa mitima. ");
INSERT INTO xnj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pevamali kutama kwa lukumbi, valongo va ku Antiokia vakalagana nawu, vakavaganila uteke, kangi vakawuya kuhamba kula kwevatumwili. ");
INSERT INTO xnj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nambu sila ahamwili kusigalila. ");
INSERT INTO xnj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nambu Pauli na Banaba vasigalili ku Antiokia, kwenuko vene pamonga na vandu vangi vamahele vawulili na kuvakokosela Lilovi la Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Magono nunuyu gegagelekili Pauli akamjovela Banaba, “Tiwuya tikavagendela valongo vala vetavakokosili lilovi la Bambu tikaloli cheviyendelela.” ");
INSERT INTO xnj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba aganili mewa vamtola Yohani mweikemiwa Maluko. ");
INSERT INTO xnj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nambu Pauli aganili lepi kumtola Maluko, ndava mumbele avalekili ku Pamfulia na kubela kuvya pamonga mulihengu lavi. ");
INSERT INTO xnj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ndi ukahumila muhutanu uvaha pagati yavi, hati vakalekengana. Banaba akamtola Maluko, vakayingila muwatu na kuhamba ku Kuplo. ");
INSERT INTO xnj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pauli mwene akamhagula Sila, hinu vamsadika pevamali kuvayupila ubwina wa Bambu vakawuka. ");
INSERT INTO xnj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mulugendu lula vakapitila ku Silia na Kukilikia kuvakangamalisa msambi wa vandu vevakumsadika Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Hinu akahika ku Delibe na ku Lusitila, kweatamayi muwuliwa mmonga liina laki Timoti. Nyina waki mewawa avi msadika Myawudi, nambu dadi waki avi Mgiliki. ");
INSERT INTO xnj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoti alumbiwi bwina na vamsadika va ku Lusitila na ku Ikonio. ");
INSERT INTO xnj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli aganili kulongosana na Timoti mulugendu, hinu akamdumula jandu. Akitili chenicho ndava Vayawudi voha vevatamayi pandi zila, vamanyili kuvya dadi wa Timoti avi Mgiliki. ");
INSERT INTO xnj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pavavi mulugendu lwa mumiji vavajovela vandu malagizu ga vamitumi vala na vagogo vala va ku Yelusalemu, vakavajovela vagalanda. ");
INSERT INTO xnj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hinu msambi wa vandu vevakumsadika kilisitu vakangamala muusadika, ndi vakayonjokeseka kila ligono. ");
INSERT INTO xnj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Vakapitila mumiji ya Flugia na Galatia muni Mpungu Msopi nakuvayidakila kukokosa ujumbi wula ku Asia. ");
INSERT INTO xnj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pavahikili mumibaka ya Musia, valingili kuyingila mulima wa Bisunia. Nambu Mpungu wa Yesu nakuvayidakila. ");
INSERT INTO xnj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hinu vapitili ku Musia na kuhamba lumonga ku Tloa. ");
INSERT INTO xnj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Lukumbi lwa kilu, Pauli akalota maono amuwene mundu mmonga wa ku Makedonia ayimili balapala na kumuyupa, “Kupuka ubwela ku Makedonia utitangatila.” ");
INSERT INTO xnj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauli peagawene maono gala, bahapo tajitendelekili kukupuka kuhamba Makedonia muni tamanyili chakaka Chapanga atikemili tihamba kuvakokosela Lilovi la Bwina kwenuko. ");
INSERT INTO xnj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tagendili muwatu kuhuma ku Tloa mbaka Samotilake, na chilau yaki tahikili Neapoli. ");
INSERT INTO xnj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuhuma kwenuko tikahamba ku Filipi muji mmonga pamulima wa Makedonia, Likoloni la Valumi. Ndi tatamili muji wenuwo mulukumbi lwa magono. ");
INSERT INTO xnj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ligono la Kupumulila tahumuli kuvala ya muji, na kuhamba pamuhana ya mfuleni pandu petahololela pakuyupila Chapanga. Ndi tikatama na kulongela na vadala vevakonganiki penapo. ");
INSERT INTO xnj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mmonga wa vadala vevatiyuwanila vala, avi mdala mmonga msadika liina laki Lidia, mkolonjinji wa Tuatila, mweigula na kugulisa nyula za mashonga gamahele. Bambu amdindwili mtima waki hati akagalanda malovi gala geajova Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mdala yula pamonga na vandu va munyumba yaki pevamali kubatiziwa, akatigongolela, “Ngati chakaka myidakili kuvya nene namsadika wa Bambu, mbwela kutama kunyumba yangu.” Akakangamala kutijovela tihamba. ");
INSERT INTO xnj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ligono limonga patakavi mukuhamba pandu pa kumuyupa Chapanga, takonganiki na msikana mmonga mvanda mweavi na mzuka wa kulondola. Mdala mwenuyo avapela mashonga gamahele vandu vana vindu vyamahele ndava ulondola waki. ");
INSERT INTO xnj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Msikana yula akatilanda Pauli na tete, ijova kwa lwami luvaha, “Vandu ava ndi vatumisi va Chapanga Mkulu! Vakuvadandaulila njila ya kusanguka!” ");
INSERT INTO xnj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akitili chenicho kwa magono gamahele mbaka ligono limonga Pauli akayoma, akamng'anamukila na kuujovela mzuka wula, “Muuhotola wa Yesu Kilisitu nikulagiza muwuka mundu uyu!” Bahapo mzuka wula ukamuwuka. ");
INSERT INTO xnj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vakulu va mvanda yula pavawene mpangu wavi wa kupata mashonga kuhuma kwa mvanda wavi umaliki, vakavakamula Pauli na Sila na kuvakwekesa pandu pakugulisila vindu, palongolo ya vakulu va muji. ");
INSERT INTO xnj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Vakavatakila kwa vahamula mihalu va Loma na kujova, “Vandu ava vileta chitututu pamuji witu navene ndi Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Viwula mivelu yeyibesiwi kwa tete vandu va ku Loma kuyidakila na kuyilanda.” ");
INSERT INTO xnj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na msambi wa vandu wewavi penapo ukavatova Pauli na Sila. Kangi vahamula mihalu vala vakavapapula nyula za Pauli na Sila, vakahamula vatovewayi ndonga. ");
INSERT INTO xnj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pevamali kuvatova neju, vakavasopa muchifungu na linjolinjoli wa jela alagaziwi kuvya mihu muulonda. ");
INSERT INTO xnj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ndava ya malagizu genago, linjolinjoli wa jela akavasopa muchumba cha mugati neju na kuvakunga magendelu gavi muhibiki. ");
INSERT INTO xnj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Peyahikili pagati ya kilu Pauli na Sila vamuyupayi na kumuyimbila nyimbu za kumulumbalila Chapanga, kuni vafungwa vayavi vakuvayuwanila. ");
INSERT INTO xnj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Chigafula mndendemo mvaha wa ndima ukahumila, wewanyugwisi mikingisa ya jela. Bahapo milyangu hikadinduka na minyololo yevakungiwi vafungwa yikawopoka. ");
INSERT INTO xnj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Linjolinjoli wa jela peayumwiki na kulola milyangu ya jela gavi mbee, akatola upanga na kugana kujikoma, ndava aholalili kuvya vafungwa voha vatilili. ");
INSERT INTO xnj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nambu Pauli akakemela kwa lwami luvaha, “Ukoto kujikoma wamwene, muni tee tavoha takona tivii!” ");
INSERT INTO xnj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Linjolinjoli yula peamali kuyupa hahi, akajumbalila mugati akajigwisa pahi pa magendelu ga Pauli na Sila kuni ivagaya kwa wogohi. ");
INSERT INTO xnj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kangi akavalongosa mbaka kuvala, akavakota, “Mwavakulu vangu, nikita kyani nihotola kusanguka?” ");
INSERT INTO xnj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Vene vakamyangula, “Umsadika Bambu Yesu ndi veve pamonga na vandu va munyumba yaku yati mwisanguliwa.” ");
INSERT INTO xnj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Hinu vakamkokosela Lilovi la Bambu mwene pamonga na vandu va munyumba yaki. ");
INSERT INTO xnj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lukumbi lulolo lwa kilu, linjolinjoli wa jela yula akavatola na kuvasambisa mavamba gavi, kangi mwene na vandu va munyumba yaki vabatiziwi bahapo. ");
INSERT INTO xnj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kangi akavagongolela Pauli na Sila kunyumba yaki, kuvapela chakulya. Mwene pamonga na vandu va munyumba yaki vakavya na luheku neju ndava hinu vakumsadika Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chilau yaki lukela, vahamula mihalu va Chiloma vavatumili vakulu va manjolinjoli na malagizu aga, “Muvadindulila vandu vala.” ");
INSERT INTO xnj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Linjolinjoli wa jela akamjovela Pauli, “Vahamula mihalu va Loma vatumili na ujumbi uwu kwa veve na Sila mudinduliwayi. Hinu mwihotola kuhuma na muhamba na uteke.” ");
INSERT INTO xnj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nambu Pauli akamyangula, “Gavi wuli? Tahokili lepi vatitovili ndonga pavandu kuni tavete tavakolonjinji wa ku Loma. Kangi vatisopili muchifungu na hinu vigana kutidindulila cha mfiyu! Hati padebe! Yikuvagana vene vahamula mihalu ndi vabwela kutidindulila.” ");
INSERT INTO xnj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Vakulu va manjolinjoli vakavadandaulila lijambu lila vahamula mihalu, hinu vene pevayuwini kuvya Pauli na Sila vavi vakolonjinji va mulima wa ku Loma vayogwipi. ");
INSERT INTO xnj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ndi vakahamba na kujova, “Chondi mpepayi,” Na pavavahumisi mugati, vakavayupa vawuka pamuji wula. ");
INSERT INTO xnj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila pavahumili muchifungu vakahamba kunyumba ya Lidia, kwenuko vakakonganeka na vamsadika. Pevamali kuvakangamalisa mitima vakawuka. ");
INSERT INTO xnj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mulugendu lwavi vakapitila Amfipoli na Apolonia, vakahika ku Tesalonike kwavili na nyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Na ngati chayavili mvelu wa Pauli, akayingila mugati mula na kukotana nawu kugavala mu Mayandiku Gamsopi Magono gadatu ga Kupumulila gegagekilini. ");
INSERT INTO xnj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Avadandaulili na kuvalangisa kuvya yikumgana Kilisitu kung'aiswa na kuyuka. Akavajovela, “Yesu mwenikuvakokosela nyenye ndi Kilisitu.” ");
INSERT INTO xnj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Vangi pagati yavi vakasadika na kuvya pamonga na Pauli na Sila. Mewawa Vagiliki vamahele vevakumsadika Chapanga pamonga na vadala vevitopeswa vakavya pamonga. ");
INSERT INTO xnj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nambu Vayawudi vakavya na wihu, hati vakavakoka valauni va pabomani na kukita msambi na kuhenga chitututu muji woha. Vakaizangila nyumba ya Yasoni vahuvalilayi vihotola kuvapata Pauli na Sila muni vavaleta pavandu. ");
INSERT INTO xnj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ndava vavapatili lepi, ndi vakamukwega Yasoni na vamsadika vangi mbaka pavakulu va muji, vakajova kwa lwami luvaha, “Vandu ava ndi vevikita chitututu pamulima woha na hinu vahikili kwitu. ");
INSERT INTO xnj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoni avagongolili kunyumba yaki. Voha vihenga chimumbele na malagizu ga nkosi wa ku Loma, vijova kuvya avi nkosi yungi liina laki Yesu.” ");
INSERT INTO xnj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ndava ya malovi ago vakavamesa ligoga vandu vamahele na vachilongosi va muji. ");
INSERT INTO xnj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hinu pevamali kumlipisa mashonga Yasoni na vayaki kangi vakavaleka vahamba. ");
INSERT INTO xnj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kanyata kilu yila, vamsadika vala vakavatuma Pauli na Sila vahamba ku Belea. Navene pavahikili kwenuko vakayingila munyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Vayawudi va ku Belea vavi vayuwanaji neju kuliku Vayawudi va ku Tesalonike, valipokili Lilovi la Chapanga na kugalingulila bwina Mayandiku Gamsopi muni vamanya ngati Pauli na Sila ijova malovi ga chakaka. ");
INSERT INTO xnj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Vandu vamahele pagati yavi vasadiki, vavi na vadala va Chigiliki vevitopeswa mewa na vagosi. ");
INSERT INTO xnj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nambu Vayawudi wa ku Tesalonike pevamanyili kuvya Pauli akokosayi Lilovi la Chapanga Belea, vakahamba kwenuko na kutumbula chitututu na kuvakokeha vandu vamahele. ");
INSERT INTO xnj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Vamsadika vala vakamhindikila kanyata Pauli ahamba kumbwani, nambu Sila na Timoti vasigalili balapala. ");
INSERT INTO xnj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Vandu vala vakamhindikila Pauli mbaka Atene. Kangi vakawuya na kuni valagaziwi na Pauli kuvya, Sila na Timoti vamlanda kanyata. ");
INSERT INTO xnj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli peavalindilayi Sila na Timoti ku Atene kula, akaviniswa neju mumtima waki ndava auwene muji wula umemili vimong'omong'o vya uchapanga. ");
INSERT INTO xnj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ajovisini na Vayawudi na vandu vangi vevakumsadika Chapanga, munyumba ya kukonganekela Vayawudi, ndi kila ligono ajovesana na vandu vevahumila pandu pakugulisila vindu. ");
INSERT INTO xnj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vandu vevalanda mawuliwu ga Epikulo na Stoiki vakotini nayu. Ndi vangi vakajova, “Igana kujova kyani muyimu uyu?” Hinu vangi vakajova, “Ikokosela vachapanga vachiyehe.” Ndava Pauli avakokosela malovi ga kumvala Yesu na kuyuka, ");
INSERT INTO xnj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kangi vakamgongolela Pauli na ahamba palongolo ya libanji lelikemelewa Aleopago, vakajova, “Tigana utimanyisa mawuliwu aga gamupya geukugajova. ");
INSERT INTO xnj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ndava muni ukutijovela mambu ga chiyehe mumakutu gitu. Tigana kumanya maana ya mambu ago.” ");
INSERT INTO xnj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Vandu va ku Atene pamonga na vayehe va kwenuko lukumbi lwavi lwoha vadandaulilana na kuyuwanila mambu gamupya. ");
INSERT INTO xnj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pauli akayima pa libanji la Aleopago, akajova, “Vandu va ku Atene! Nikuvalola nyenye kuvya vandu mwemukumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ndava panapitayi kuni na kula na kulola mambu ga kuyupa kwinu, nayiwene lusanja lwa luteta lweluyandikwi, ‘Kwa Chapanga Angamanyikana.’ Hinu nene nikuvakokosela malovi gaki mwenuyo mwemukumuyupa changali kumanya. ");
INSERT INTO xnj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chapanga mweawumbili mulima pamonga vindu vyoha yvevivi mugati yaki, ndi Bambu wa kunani na pamulima, mwene nakutama Nyumba za Chapanga zezijengiwi na mawoko ga vandu. ");
INSERT INTO xnj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Mwene igana lepi kuhengewa na vandu, ngati kuvya igana utangatila wowoha wula, ndava muni mwene ndi mweakuvapela vandu wumi, mweakuvahotosa kukeka na kuvapela kila chindu. ");
INSERT INTO xnj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuhuma kwa mundu mmonga, mwene awumbili vandu va milima yoha muni vatama pamulima woha, avapangili lusenje na mibaka ya pandu pakutama. ");
INSERT INTO xnj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Chapanga aganili vandu vamulanda na hati cha kupapasa, vahotola kumhikila. Nambu mwene avi lepi patali na kila mmonga witu. ");
INSERT INTO xnj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ngati cheajovili mundu mmonga kuvya, ‘mugati mwaki tete titama na kugenda na tivili!’ Ngati vayimbaji vangi chavijova, ‘Tete ndi vana vaki.’ ");
INSERT INTO xnj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Muni tete tavana vaki Chapanga, nakuganikiwa kumhololela mwene kuvya avi ngati zahabu amala mashonga amala liganga lelihongoliwi kwa luhala na vandu. ");
INSERT INTO xnj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chapanga akitili ngati ilola lepi lusenje lula vandu pavahimwiki. Nambu hinu, ihamula vandu voha kila pandu vamuwuyila mwene. ");
INSERT INTO xnj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ndava amali kuhagula ligono leihamula mulima pangali kumganisila yoyoha munjila ya mundu mmonga mweamhagwili. Chapanga avalangisi voha lijambu lenilo kwa kumyukisa mundu mwenuyo kwevafwili.” ");
INSERT INTO xnj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pavamuyuwini Pauli ijova lijambu la kuyuka kuhuma kwa vafwili, vangi vakamuheka nambu vangi vakajova, “Tigana kuyuwana kavili lijambu lenili.” ");
INSERT INTO xnj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na Pauli akavaleka akahuma mu libanji. ");
INSERT INTO xnj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nambu vandu nunuyu vakawungana nayu, vakavya vamsadika. Pagati yavi avi Dionisi wa ku Aleopago na mdala mmonga liina laki Damali, pamonga na vandu vangi. ");
INSERT INTO xnj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pagamaliki ago, Pauli akawuka ku Atene na kuhamba Kolinto. ");
INSERT INTO xnj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kolinto kula amkolili Myawudi mmonga liina laki Akula, mkolonjinji wa Ponto. Akula pamonga na mdala waki Plisika, vawuyili magono gagago kuhuma ku Italia ndava chilongosi Kaisali Kilaudio ahamwili Vayawudi voha vawuka ku Loma. Ndi Pauli akahamba kuvalola, ");
INSERT INTO xnj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na ndava vene vavi vevitengeneza mandanda lihengu ngati laki, ndi Pauli akatama nawu kuhenga. ");
INSERT INTO xnj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Ligono la Kupumulila akotanayi nawu munyumba ya kukonganekela Vayawudi alingayi kuvakulukisa Vayawudi na Vagiliki. ");
INSERT INTO xnj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoti pavahikili kuhuma Makedonia, hinu lukumbi lwaki lwoha Pauli atumili ndava ya kuvakokosela Vayawudi, kuvya chakaka Yesu ndi Kilisitu Msangula. ");
INSERT INTO xnj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nambu Vayawudi pavampingayi na kutumbula kumliga, mwene akakung'unda lububu lwa munyula zaki akavajovela, “Mwakayaga kwali mwavene, nene nihokili lepi. Na kutumbula hinu nikuvahambalila vandu vangali Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kangi Pauli akawuka penapo na kuhamba kutama kunyumba ya mundu mmonga Mgiliki mweakumsadika Chapanga liina laki Tito Yusto nyumba yaki yavili papipi na nyumba ya kukonganekela Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo chilongosi wa nyumba ya kukonganekela Vayawudi yula, mwene pamonga vandu va nyumba yaki vamsadiki Bambu, Vakolinto vamahele pevayuwini ujumbi wula vakasadika na kubatiziwa. ");
INSERT INTO xnj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ligono limonga kilu, Bambu akamjovela Pauli mumaono, “Ukoto kuyogopa, yendelela kukokosa changali kudenyeka mtima, ");
INSERT INTO xnj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Muni nene nivii pamonga na veve na kawaka mundu wa kulinga kukulemasa muni pamuji wenuwo vandu vamahele vavi upandi wangu.” ");
INSERT INTO xnj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Hinu Pauli atamili kwenuko mulukumbi lwa mwaka umonga na upinga kuni iwula vandu Lilovi la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nambu lukumbi Galio peavi chilongosi wa Akaya, ndi Vayawudi vakamzangila Pauli kwa pamonga na kumpeleka kulibanji la mihalu. ");
INSERT INTO xnj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Vakajova “Timtakila mundu uyu ndava akuvakulukisa vandu vamuyupa Chapanga munjila yeyiyidakilana lepi na malagizu.” ");
INSERT INTO xnj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pauli akona kuyangula, Galio akavajovela Vayawudi, “Myuwanila Vayawudi nyenye! Ngati kuvya chakaka lijambu lenili ngalavi la unyagaji amala uhakau nga nivayuwanili. ");
INSERT INTO xnj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nambu ngati ndava ya muhutanu wa malovi na mahina na mhilu winu, muhamula nyenye mwavene. Nene niganili lepi kuvya mhamula wa lijambu ili!” ");
INSERT INTO xnj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ndi akavavinga kuhuma mu libanji la mihalu. ");
INSERT INTO xnj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hinu vene vakamkamula Sostene chilongosi wa nyumba ya kukonganekela Vayawudi, vakamtova balapala palongolo ya libanji la mihalu. Nambu Galio nakutangatila nawu hati padebe. ");
INSERT INTO xnj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli akayendelela kutama na valongo va ku Kolinto kwa magono gamahele. Kangi akavalaga akayingila muwatu kuhamba ku Silia pamonga na Plisika na Akula. Kenkelea kwenuko aketili mayunju gaki ndava amali kutimilisa chilapu chaki kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pavahikili ku Efeso ndi Pauli akavaleka Plisika na Akula, akahamba munyumba ya kukonganekela Vayawudi, akakotana na Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Vamuyipili atama nawu palukumbi lutali, nambu nakuvayidakila. ");
INSERT INTO xnj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nambu akalagana nawu peawukayi, akavajovela, “Ngati Chapanga aganili yati nibwela kavili.” Akawuka ku Efeso muwatu. ");
INSERT INTO xnj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Peahulwiki Kaisalia, Pauli akahamba pa Yelusalemu na kuvajambusa msambi wa vandu vevakumsadika Kilisitu. Kangi akahamba ku Antiokia. ");
INSERT INTO xnj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ndi akatama kwenuko mu magono gadebe akayendelela na lugendu kupitila miji ya Galatia na Flugia avakangamalisa vamsadika voha. ");
INSERT INTO xnj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Magono gagago Myawudi mmonga liina laki Apolo mkolonjinji wa Alekisanda, ndi abwelili ku Efeso. Avi na luhala lwa kulongela na mweimanya bwina Mayandiku Gamsopi. ");
INSERT INTO xnj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mundu mwenuyo awuliwi njila ya Bambu, kuni mtima waki uvi heyuheyu akatumbula kudandaula na kuwula uchakaka malovi ga Yesu, nambu mwene amanyili nga ubatizu wa Yohani. ");
INSERT INTO xnj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mwene akatumbula kulongela kwa ukekesi munyumba ya kukonganekela Vayawudi, hinu Plisika na Akula pavamuyuwini vakamtola kuhamba nayu kunyumba yavi na kumuwula Njila ya Chapanga kwa uchakaka neju. ");
INSERT INTO xnj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo peaganili kuhamba ku Akaya, vamsadika va ku Efeso vakamkangamalisa mtima na kuvayandikila vamsadika vala vampokelayi. Peahikili kwenuko avatangatili neju vandu vevasadika vala kwa makakala ga ubwina wa Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ndi ayendalili kwa ukekesi kujovesana na kuvashinda Vayawudi pavandu ijova hotohoto mu Mayandiku Gamsopi kuvya Yesu ndi Kilisitu Msangula. ");
INSERT INTO xnj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Lukumbi Apolo avi Kolinto, Pauli akagenda mu vidunda na kuhika ku Efeso kwenuko avakolili vawuliwa nunuyu, ");
INSERT INTO xnj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","akavakota, “Wu, mwampokili Mpungu Msopi lukumbi pamwasadiki?” Vene vakamyangula, “Lepi! Hati kuyuwana kuvi Mpungu Msopi.” ");
INSERT INTO xnj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pauli akavakota, “Ubatizu woki wemwapatili?” Vene vakamyangula, “Ubatizu wa Yohani.” ");
INSERT INTO xnj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Namwene Pauli akajova, “Ubatizu wa Yohani wavi ndava ya kulangisa kuvya vandu vamali kumuwuyila Chapanga. Yohani avajovili vandu kuvya vamsadikayi yula mweibwela palongolo yaki ndi Yesu.” ");
INSERT INTO xnj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hinu pevamali kugayuwanila genago, ndi vakabatiziwa muliina la Bambu Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pauli avapamisi mawoko panani yavi na Mpungu Msopi akavahelelela, vakatumbula kulongela luga ya chiyehe na kukokosa ujumbi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jumula vavi vagosi kumi na vavili. ");
INSERT INTO xnj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mulukumbi lwa miheyi yidatu Pauli ayendalili kuyingila munyumba ya kukonganekela Vayawudi, na kukokosa cha ukekesi na kukotana nawu ndava kuvakofwa kuuvala Unkosi wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nambu vangi vavi na mitima yeyitopa hati vakabela kusadika, vakajova gahakau ndava ya Njila ya Bambu palongo ya msambi wa vandu. Ndi Pauli akajibagula mwene pamonga na vamsadika vala, na kila ligono akakotana nawu mu libanji la mawuliwu la mundu mmonga liina laki Tilano. ");
INSERT INTO xnj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mambu ago gehengiki mulukumbi lwa miyaka yivili hati vakolonjinji voha va Asia, Vayawudi na vandu vangali Vayawudi vakayuwana Lilovi la Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chapanga akitili gachinamititi ga kukangasa gamahele mu mawoko ya Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hati vandu vavi mukutola hitambala ya kuhungulila na nyula zeazipamisi Pauli. Vavapelekili vatamu wavi ndi vakalama na vana mizuka mewawa, mizuka yikavahuma. ");
INSERT INTO xnj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mewawa kwavili na Vayawudi vevatyalatyala kuni na kula, kuvinga mizuka navene valinga mewa kuluwula liina la Bambu Yesu. Mewa vijova, “Nikulagiza umuhuma paliina la Yesu yula mweakumkokosa Pauli.” ");
INSERT INTO xnj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Vevakita genago pagati yavi vavi vasongolo saba va Sikewa, mmonga wa Vateta Vakulu wa Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nambu mzuka mhakau wula ukavayangula, “Nikummanya Yesu, na kavili nikummanya Pauli, nambu mwavayani nyenye?” ");
INSERT INTO xnj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na mundu mweatalaliwi na mzuka yula akavahumbila kwa chigigi voha vavili avashindili makakala. Navene vakajumba changali nyula kuni vana mavamba. ");
INSERT INTO xnj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mundu yeyoha mweitama ku Efeso, Myawudi na angali kuvya Myawudi, ayuwini lijambu lenilo. Voha vakavya na wogohi, vakalilumba liina la Bambu Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Vamsadika vamahele vakabwela na kujova hotohoto pavandu mambu gahakau gevahengili. ");
INSERT INTO xnj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Vandu vamahele pagati ya vala vevikita mambu ga uhavi vakatola hitabu yavi na kuyocha motu palongo ya voha. Vakavalanga bei ya hitabu yahikili mashonga elufu hamsini. ");
INSERT INTO xnj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Munjila yeniyo ndi Lilovi la Bambu chalayonjokisiki kudandasika na kuvya na makakala neju. ");
INSERT INTO xnj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Chechagelekili mu mambu ago, Pauli akahamwili kuhamba ku Yelusalemu kwa kupitila Makedonia na Akaya. Akajova, “Nakahika kwenuko, mewawa yikunigana nigendelela ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kangi avatumili vamtangatila vaki, Timoti na Elasito, vamlongolela kuhamba ku Makedonia, kuni mwene asigalili ku Asia magono gadebe. ");
INSERT INTO xnj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lukumbi lwenulo kweahumili chitututu neju ku Efeso ndava ya Njila yeniyo ya Bambu. ");
INSERT INTO xnj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mfukuta vindu vya madini ga mashonga mmonga liina laki Demetilio, mweavi na lihengu la kutengeneza majengu gadebe gadebe gegiwanangana na nyumba ya chapanga mdala Atemi. Lihengu lila lavapelili chiyonjokesu chivaha vahengati vaki. ");
INSERT INTO xnj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetilio avakemili pamonga na vanalihengu vangi ngati laki akavajovela, “Vagosi, mmanyili kuvya mashonga gemwipata gihumila mulihengu lenili. ");
INSERT INTO xnj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hinu mwihotola kuyuwana na kujilolela mwavene mambu geihenga Pauli, lepi Pa Efeso pene, nambu mewa ku Asia yoha. Mwene akuvakulukisa na kuvang'anamusa vandu vasadikayi kuvya vachapanga vala vevitengenezwa na vandu, hati padebe lepi vachapanga. ");
INSERT INTO xnj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nga lepi lihengu litu livii muhatali ya kuveveswa, nambu mewawa na nyumba ya chapanga mdala mweavimkulu, Atemi, kuvalangiwa chindu lepi. Na kuwusiwa ukulu waki, mwene mweigundamiliwa Asia na mulima woha.” ");
INSERT INTO xnj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pevayuwini genago, vakamema ligoga na kutumbula kuywanga, “Mkulu ndi Atemi wa ku Efeso!” ");
INSERT INTO xnj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Muji woha ukamema chitututu, vakavakamula Gayo na Alistako vakolonjinji va Makedonia, vevavi mulugendu pamonga na Pauli, vakavajumbisa mbaka mu libanji la mikinu. ");
INSERT INTO xnj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauli aganili kujilangisa mu msambi wa vandu, nambu vawuliwa vakambesa. ");
INSERT INTO xnj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hati vakulu nunuyu va muji wa Asia vevavi vankozi vaki, vampelekili ujumbi Pauli, vakamjovela akotoka kujiyagisa mukuhamba kulibanji la mikinu. ");
INSERT INTO xnj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lukumbi lwenulo kila mundu aywangayi, vangi vijova aga na vangi vijova gala, hati mngonganu wula ukapechengana. Vangi nakumanya hati ndava ya kukonganeka kwavi. ");
INSERT INTO xnj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Vayawudi vakamkang'a palongolo ya vandu mundu mmonga mweikemiwa Alekisanda, ndi vakamuwusa mwene palongolo ya vandu, Alekizanda akavapungila vandu chiwoko kuvagunisa. Muni aganayi kujikengelela palongolo yavi. ");
INSERT INTO xnj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nambu pevamanyili kuvya mwene ndi Myawudi, voha kwa pamonga vakaywanga, “Mkulu ndi Atemi wa ku Efeso!” Mewawa vakayendelela kuywanga mulukumbi lwa masaa gavili. ");
INSERT INTO xnj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pamwishu myimilila lihengu wa muji akahotola kuvagunisa vandu, akavajovela, “Vakolonjinji va ku Efeso, kila mundu imanya kuvya muji witu ndi mlonda wa nyumba ya chapanga Atemi na liganga lamsopi leligwili kuhuma kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Avi lepi mweihotola kubela mambu aga. Ndi, yikuvagana kuguna, mkotoka kuhenga chindu changa hololela. ");
INSERT INTO xnj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ndava muni muvaletili vandu apa, pamonga vayivi lepi vindu vya nyumba ya chapanga amala kumliga chapanga witu wa chidala. ");
INSERT INTO xnj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ngati, Demetilio na vana lihengu vaki vavi na mhalu wavi ndava ya vandu ava, gavi kulibanji la mihalu na kwa na vakulu va miji, vihotola kutakila kwenuko. ");
INSERT INTO xnj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ngati muvi na mambu gangi, mugapeleka mumngonganu wewuyidakiliwa. ");
INSERT INTO xnj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Muni tivii muhatali ya kutakiliwa ndava ya chitututu cha lelu, muni kawaka chanzu cha chitututu chenichi.” ");
INSERT INTO xnj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Peamali kujova genago, akamala mngonganu. ");
INSERT INTO xnj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Chitututu chila pechamaliki Pauli avakemili vamsadika vala akavakangamalisa mtima. Kangi akalagana nawu na kuhamba Makedonia. ");
INSERT INTO xnj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Apitayi pandi za muji wula kuvakangamalisa vandu mitima mu malovi gaki gamahele, na kuhika ku Ugiliki. ");
INSERT INTO xnj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kwenuko atamili miyehi yidatu. Hinu peajitendeleka kuhamba ku Silia, akamanya kuvya Vayawudi vavi mukumkitila mpangu uhakau, ndi akahamula kuwuya munjila ya ku Makedonia. ");
INSERT INTO xnj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Vandu ava ndi vealongosini nawu, Sapato mwana wa Piho mundu wa ku Belea, Alistako na Sekundo vandu va ku Tesalonike, vangi vavi Gayo mkolonjinji ku Delibe, Timoti pamonga na Tukiko na Tofimo vandu va kuhuma muji wa Asia. ");
INSERT INTO xnj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Vandu ava vatilongolili na kuhamba kutilindila ku Tloa kula. ");
INSERT INTO xnj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nambu tete, pawamaliki Mselebuko wa Mabumunda gangali ngemeku, tayingili muwatu kuhuma ku Filipi, mulugendu lwa magono mhanu ndi tikahika ku Tloa. Tatamili kwenuko lijuma limonga. ");
INSERT INTO xnj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ndi Jumamosi kimihi takonganiki ndava ya kulya pamonga. Muni Pauli aganayi kuwuka chilau yaki, ndi avakokosili vandu mbaka pagati ya kilu. ");
INSERT INTO xnj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kugolofa kwetakonganiki kwavili na hahi zamahele ziyaka. ");
INSERT INTO xnj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Msongolo mmonga liina laki Eutuko atamili palidilisha lukumbi Pauli ikokosa palukumbi lutali. Eutiko atumbwili kutitila lugono hati pamwishu lugono lwamgalisi akagwa kuhuma ku golofa ya datu mbaka pahi. Pevahambili kumyinula vamkoli amali kufwa. ");
INSERT INTO xnj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pauli akahuluka pahi, akajigonesa panani yaki na kumkumbatila, akajova, “Mkoto kuvemba ndava avi mumi.” ");
INSERT INTO xnj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Akakwela kavili kuchumba cha kunani kula, akanukula libumunda na kulya. Akayendelela kukokosa kwa lukumbi lutali mbaka hambakucha, kangi akawuka. ");
INSERT INTO xnj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Vandu vala vakawuya nayu msongolo yula kunyumba alamili hotohoto, ndi vakapoleswa neju. ");
INSERT INTO xnj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nambu tete tayingili muwatu kulongolela ku Aso kwetikumtola Pauli. Ndi cheapangili mwene muni aganili kuhika kwenuko munjila ya kundumba. ");
INSERT INTO xnj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Hinu atikolili ku Aso tikamutola muwatu, na kuhamba nayu Mitulene. ");
INSERT INTO xnj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tavi mulugendu lwa kuhuma kwenuko na chilau yaki tahikili Kio. Pamalau yaki tahikili ku Samo na Pamtondogolo yaki tikahika ku Mileto. ");
INSERT INTO xnj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ndava Pauli aganili lepi kuvedukila ku Efeso muni akotoka kutamakisa neju mulima wa Asia. Ayumbatika kuhika ku Yelusalemu kumselebuko wa Pentekoste ngati yihotoleka. ");
INSERT INTO xnj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuhuma Mileto Pauli avatumili ujumbi kwa vachilongosi va msambi wa vandu vevakumsadika Kilisitu va ku Efeso vakonganika nayu. ");
INSERT INTO xnj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Hinu pavamhikalili akavajovela, mwavene mmanyili chenitamili na nyenye magono goha kutumbula ligono la kutumbula panahikili mulima uwu wa Asia. ");
INSERT INTO xnj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mmanyili chenimuhengili Bambu cha ungolongondi woha, na maholi, mu mang'ahiso goha geganikolili ndava mipangu mihakau ya Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanyili kuvya hati padebe nayogwipi lepi kuvakokosela pavandu na munyumba zinu, kuvawula chochoha chechikuvatangatila. ");
INSERT INTO xnj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Navabesili vandu voha, Vayawudi na vangali Vayawudi, vamuwuyila Chapanga na kumsadika Bambu witu Yesu. ");
INSERT INTO xnj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Hinu, myuwanila! Nikumyidakila Mpungu Msopi, nihamba ku Yelusalemu changali kumanya gegakunikolela. ");
INSERT INTO xnj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nga chindu chimonga chenikuchimanya, Mpungu Msopi akunilangisa kuvya mukila muji chifungu na mang'ahiso ndi vyevyi kunilindila. ");
INSERT INTO xnj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nambu nivalanga lepi wumi wangu kuvya chindu, kwa nene ndi kumalakisa utumi wa lihengu lila leanipelili Bambu Yesu, kujova ndava ya Lilovi la Bwina la ubwina wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nigendili pagati yinu mwavoha kukokosa Unkosi wa Chapanga. Nambu hinu, nimanyili avi lepi mundu hati mmonga winu mweakuniwona kavili. ");
INSERT INTO xnj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hinu lelu nijova chakaka, kuvya mmonga winu akayaga, mhalu wa nene lepi. ");
INSERT INTO xnj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ndava muni hata padebe naleki lepi kuvakokosela mwapangu woha wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mujiyangalila mwavene, myungayi msambi wa vandu vevakumsadika Kilisitu uwu, Mpungu Msopi avaviki nyenye mvya valonda vaki. Leajipatili kwa ngasi ya Mwana waki. ");
INSERT INTO xnj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nimanyili kuvya peniwukayi, mabwa gakali ga kudahi yati gavazangila changali lipyana msambi wenuwo. ");
INSERT INTO xnj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hati pagati yinu yati vihumila vandu veviwula mawuliwu ga udese muni vavayaganisa vamsadika, vavalanda vene. ");
INSERT INTO xnj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ndava ya yeniyo, mvya mihu kuni mukumbukayi kuvya mulukumbi lwa miyaka yidatu muhi na kilu katu nalekili lepi kumbesa kila mmonga winu kwa maholi.” ");
INSERT INTO xnj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Hinu ndi, nikuvavika nyenye pahi muulonda waki Chapanga na ujumbi wa mota yaki. Mwene anauhotola wa kuvasindimalisa na kuvapela uhali pamonga nawu vandu vaki vamsopi. ");
INSERT INTO xnj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nene nanogili lepi mashonga amala zahabu amala nyula za mundu yeyoha. ");
INSERT INTO xnj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwavene mmanyili kuvya namwene nihegili lihengu mu mawoko gangu, ndava ya kupata gegiganikiwa kwa nene na vayangu. ");
INSERT INTO xnj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Pamahele nivalangisi luhumu kuvya kuhenga mahengu neju, yikutigana kuvatangatila vangali makakala, na tikumbuka mu malovi ga Bambu Yesu mwene, ‘Mbanga neju kuwusa kuliku kupokela.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Peamali kujova genago, Pauli akafugama pamonga nawu voha akayupa kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Voha vakavya mukuvemba neju, pevalaga Pauli kuni vamkumbatili cha uganu. ");
INSERT INTO xnj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lijambu lelavavinisi neju ndi lila leajovili yati vakumlola lepi kavili. Hinu ndi vamhindikili mbaka muwatu. ");
INSERT INTO xnj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patamali kulagana nawu, tayingili muwatu na kuhamba lumonga mbaka Kosi. Chilau yaki tahikili kumuji wa Lode, na patahumili kwenuko tikahamba kumuji wa Patala. ");
INSERT INTO xnj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kula taukolili watu wewihamba mbaka ku Foinike, ndi tikayingila na kuyendelela lugendu. ");
INSERT INTO xnj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ndi patahikili pandu patahotwili kulola Kuplo, tikahamba upandi wa kusini mbaka Silia. Tikahamba kuyima ku Tilo ndi pandu pa watu wula payahulusayi ndwika. ");
INSERT INTO xnj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kwenuko tavakoli vamsadika, tatamili nawu mulukumbi lwa lijuma limonga. Vamsadika venavo vakavya vilongela mukulongoswa na Mpungu Msopi, vakamjovela Pauli akotoka kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nambu lukumbi lwitu palwamaliki tavoha tawukili. Vawuliwa pamonga na vadala na vana vavi vatihindikili mbaka kuvala ya muji. Patahikili kumbwani tavoha tikafugama na kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kangi patamali kulagana nawu, tayingili muwatu na vene vakawuya kunyumba zavi. ");
INSERT INTO xnj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tete tayendalili na lugendu lwitu tahumili ku Tilo na kuhamba Tolemai kwetavajambwisi valongo vitu, tatamili nawu ligono limonga. ");
INSERT INTO xnj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chilau yaki tahumili penapo na kuhamba Kaisalia. Kwenuko tikatama kunyumba ya Filipi mkokosa wa Lilovi la Bwina. Mwene ndi avi mmonga wa vamtangatila saba vevahaguliwi ku Yelusalemu kula. ");
INSERT INTO xnj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mwenuyu avi na vakamwali mcheche vevavi na chipanji cha kulota malovi ga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Patatamili kwenuko magono gamahele, mlota mmonga wa Chapanga liina laki Agabo ahikili kuhuma ku Yudea. ");
INSERT INTO xnj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ndi atibwelili, akatola mkungi wa Pauli akajikunga mawoko na magendelu, akajova, “Mpungu Msopi ajovili aga, ‘Vayawudi va ku Yelusalemu kula yati vakumkunga mewa mundu mweavi na mkungi uwu na kumgotola kwa vandu vangali Vayawudi.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patayuwini genago, tete pamonga na vandu vangi vevavi penapo, tamuyupili Pauli akotoka kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nambu Pauli avayangwili, “Ndava kyani mwivemba? Na kunidenya mtima? Nijitendelekili, lepi ndava ya kukungiwa ndu ku Yelusalemu, nambu hati mewawa kufwa ndava ya liina la Bambu Yesu.” ");
INSERT INTO xnj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Peabeli getamjovili tagunii tikajova, “Maganu ga Bambu gahengekayi!” ");
INSERT INTO xnj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Patamali kutama mulukumbi, ndi takungili ndwika yitu, tayendalili na lugendu kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Vamsadika nunuyu va ku Kaisalia valongosini na tete, vatipeliki kunyumba ya mundu mmonga liina laki Mnasoni, ndi mwetahambayi kutama kwa lukumbi. Mwenuyo avi mkolonjinji wa muji wa Kuplo, msadika wa kadeni. ");
INSERT INTO xnj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hinu patahikili ku Yelusalemu, vamsadika vayitu vatipokili kwa luheku. ");
INSERT INTO xnj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chilau yaki Pauli pamonga na tete tahambili kumjambusa Yakobo na vagogo voha va msambi wa vandu vevakumsadika Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Patamali kuvajambusa, Pauli avajovili mambu goha Chapanga geagahengili kwa vandu vangalikuvya Vayawudi munjila ya lihengu laki. ");
INSERT INTO xnj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ndi pavagayuwini ago, vakamulumba Chapanga. Kangi vakamjovela Pauli, “Mlongo, uhotola kulola kuvya vavi maelufu ga Vayawudi vevavi vamsadika hinu na voha vilanda cha kukangamala malagizu ga Bambu geampeli Musa. ");
INSERT INTO xnj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Vayuwini mambu gaku gewiwula Vayawudi vevitama pagati ya vandu vangalikuvya Vayawudi, kuvya vakotoka kulanda malagizu ga Bambu geampeli Musa, vakotoka kuvadumula jandu vana vavi kavili vakotoka kulanda mivelu ya Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hinu tikita wuli? Chakaka yati viyuwana kuvya ubwelili. ");
INSERT INTO xnj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Hinu kitayi ngati chetikujovela, penapa tivii na vagosi mcheche vevaviki chilapu kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Uwungana nawu mukuyupa kunyambiswa, ulipa mashonga gegiganikwa, kangi vaketewayi mayunju gavi. Ndi vandu voha yati vimanya kuvya mambu gala gevayuwini kukuvala veve gangali mana, ndi wamwene wakona witama na kulanda malagizu ga Malagizu ga Musa. ");
INSERT INTO xnj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nambu kuvavala vandu vangalikuvya Vayawudi vevasadiki, tivapelekili balua yetiyandiki mambu getihamwili, vakotoka kulya chindu chochoha chechiwusiwi luteta vachapanga va udese, vakotoka kunywa ngasi, na vakotoka kulya nyama ya hinyama yidodanu, vayepa ukemi.” ");
INSERT INTO xnj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Hinu chilau yaki Pauli akavatola vandu vala muni ajinyambisa nawu pamonga, kangi akayingila Munyumba ya Chapanga, na kujova ligono la mwishu la kunyambiswa na luteta lweluwusiwa ndava ya kila mmonga. ");
INSERT INTO xnj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Hinu magono gala saba pagihegelela kumalika, Vayawudi vevahumili wa Asia vamuwene Pauli Munyumba ya Chapanga. Ndi vakavakohokea ligoga msambi woha wa vandu, ndi vakamkamula. ");
INSERT INTO xnj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Vakaywanga, “Vagosi va Isilaeli, mutitangatila! Mundu mwenuyu ndi mweakuvawula vandu kila pandu mambu gegibelana na vandu va Isilaeli, gegibesa malagizu ga Chapanga geampeli Musa na pandu apa Pamsopi. Hati hinu avayingisi vandu vangali Vayawudi Munyumba ya Chapanga na kupahakasa pandu pamsopi.” ");
INSERT INTO xnj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Vajovili genago ndava vamuwene Tofimo mkolonjinji wa ku Efeso, alongosini na Pauli kumujini, vakaholalela manya Pauli amuyingisi Munyumba ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Chitututu chadandasiki muji woha, vandu vakonganiki kuhuma pandi zoha, vakamukamula Pauli, vakamuhuta na kumuhumisa kuvala ya Nyumba ya Chapanga, na bahapo milyangu hikadindwa. ");
INSERT INTO xnj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pavalingili kumkoma Pauli, malovi gala gakamhikila mkulu wa msambi wa ku Loma kuvya Yelusalemu yoha yimemili chitututu. ");
INSERT INTO xnj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Bahapo mkulu wa msambi akavatola manjolinjoli na vachilongosi wavi, vakavajumbila kuhamba. Vayawudi pavamuwene mkulu wa msambi pamonga na manjolinjoli vakaleka kumtova Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mkulu wa msambi yula akamhegelela Pauli, akamkamula na kulagiza akungiwayi minyololo yivili. Kangi akakota, “Mwenuyu ndi yani? Abudili kyani?” ");
INSERT INTO xnj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vangi mu msambi wula vakavya mukuywanga vangi aga na vangi gala. Ndava ya chitututu, mkulu wa msambi wa manjolinjoli amanyili lepi uchakaka wa mhalu waki. Ndi akahamula vandu vaki vampeleka mugati ya ngomi ya manjolinjoli. ");
INSERT INTO xnj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli pahaikili pangazi, yavaganili manjolinjoli kumgega ndava ya chitututu cha vandu. ");
INSERT INTO xnj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ndava muni msambi wa vandu uvaha vamlandili kuni viywanga, “Mkomayi!” ");
INSERT INTO xnj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pavamuyingisa mungomi, Pauli akamuyupa mkulu wa msambi wa manjolinjoli yula, “Nihotola kukujovela chindu?” Mkulu wa msambi wa manjolinjoli akamkota, “Wu, umanya kujova Chigiliki? ");
INSERT INTO xnj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Wu, veve ndi Mmisili yula magono gegapitili atumbwili chitututu na kuvalongosa vakomaji elufu mcheche kuhamba kulugangatu?” ");
INSERT INTO xnj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli akayangula, “Nene na Myawudi, mkolonjinji wa ku Taso muji wa Kilikia, muji weutopeswa. Chondi niyidakila nilongela na vandu.” ");
INSERT INTO xnj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mkulu wa msambi wa manjolinjoli yula akamyidakila. Ndi Pauli akayima panani ya ngazi akavapungila vandu chiwoko, muni vaguna, akatumbula kulongela nawu muluga ya Chiebulania. ");
INSERT INTO xnj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Valongo vangu na vadadi vangu, muyuwanila hinu chenikujikengelela palongolo yinu!” ");
INSERT INTO xnj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pevamuyuwini ilongela nawu kwa luga ya Chiebulania vakatama nuu neju. Kangi Pauli akayendelela kujova, ");
INSERT INTO xnj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nene na Myawudi mkolonjinji wa ku Taso muji wa Kilikia. Nambu naleliwi bahapa pa Yelusalemu. Muwula wangu Gamalieli. Nawuliwi kulanda malagizu ga vagogo vitu, najiwusili mtima woha kwa Chapanga ngati chemuvi nyenye lelu. ");
INSERT INTO xnj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Navang'ahisi hati kuvakoma vandu vala vevalanda Njila ya Bambu. Navakamwili vagosi na vadala na kuvakunga muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mteta mkulu wa Chapanga, vagogo voha va libanji vihotola kujova ndava ya lijambu lenili. Kuhumila kwavi napokili balua yevayandikiwi valongo Vayawudi vala, vevavi ku Damasko. Nahambili ku Damasko muni nivakamulayi vandu avo na kuvaleta kuni ku Yelusalemu, muni vabuniwayi.” ");
INSERT INTO xnj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Hinu, panavili munjila papipi kuhika Damasko, lukumbi lwa saa sita ya muhi, lumuli luvaha kuhuma kunani kwa Chapanga chigafula ukahumila na kunilangasa pandi zoha. ");
INSERT INTO xnj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Penapo ndi nagwili pahi, nakuyuwana lwami lukunijovela, ‘Sauli, Sauli! Ndava kyani, ukuning'aha?’ ");
INSERT INTO xnj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Hinu nakotili, yani Bambu? Aniyangwili, ‘Nene ndi Yesu wa ku Nazaleti mweukumung'aha.’ ");
INSERT INTO xnj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Vayangu vala valuwene lumuli lula, nambu nakummanya lwami lwa mwenilongela nayu. ");
INSERT INTO xnj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndi nikakota, ‘Nikita kyani, Bambu?’ Bambu akaniyangula, ‘Yima, uhamba ku Damasko na kwenuko yati ujoviwa goha geupangiwi kugahenga.’ ");
INSERT INTO xnj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mihu nakuhotola kulola ndava ya lumuli lula, hinu yavaganili vayangu vala kunilongosa mbaka kuhika ku Damasko.” ");
INSERT INTO xnj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kwenuko kwavili na mundu mmonga liina laki Anania, mundu mweakumtopesa Chapanga, mweilanda Mhilu wa Chapanga weampeli Musa na mweitopeswa neju na Vayawudi voha vevitama ku Damasko. ");
INSERT INTO xnj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mwene abwelili kunilola, akanihegelela na kunijovela, ‘Mlongo wangu Sauli! Lola kavili.’ Bahapo nikahotola kumlola. ");
INSERT INTO xnj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kangi Anania akajova, ‘Chapanga wa vagogo vitu akuhagwili veve uhotola kumanya maganu gaki, kumlola Mweikita geigana Chapanga, na kumyuwana malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ndava muni yati wijova ndava yaki kwa vandu voha gala geugawene na kuyuwana. ");
INSERT INTO xnj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Hinu ndi, ndava kyani kutamakisa? Yima, ubatiziwayi na kulekekeswa geumbudili Chapanga kwa njila yeniyi ukulikemela liina la Yesu.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Hinu nawuyili ku Yelusalemu, na panavili mukuyupa Munyumba ya Chapanga, nagawene maono. ");
INSERT INTO xnj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Namuwene Bambu akunijovela, ‘Yumbatika! Wuka Yelusalemu kanyata, ndava muni vandu va penapa yati vakukuyidakila lepi mukujova kwaku ndava yangu.’ ");
INSERT INTO xnj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nikamyangula, Bambu, vandu ava vimanya hotohoto kuvya nene ndi yula mwenahambayi munyumba za kukonganekela Vayawudi na kuvakamula na kuvatova vala vevakusadikayi. ");
INSERT INTO xnj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na lukumbi Stefani mweijova ndava yaku peakomiwi, namwene navili nayidakili lepi chitendu chenicho hati navi mlonda wa nyula za vakomaji vala. ");
INSERT INTO xnj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Kangi Bambu akanijovela, ‘Hamba, Yati nikutuma kutali kwa vangali Vayawudi.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Msambi wa vandu wamuyuwanili Pauli mbaka peajovili malovi ago. Kangi vakajova kwa lwami luvaha, “Mkoma mundu uyu! Mundu ngati uyu iganikiwa lepi kutama pamulima.” ");
INSERT INTO xnj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ndi vayendalili kuywanga kuni vitaga nyula zavi na kutikula lububu kunani. ");
INSERT INTO xnj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Mkulu wa msambi wa manjolinjoli avalagizi vandu vaki vampeleka Pauli mungomi, akavajovela vamtova michapilu muni amanya ndava kyani Vayawudi vakumywangila. ");
INSERT INTO xnj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nambu pevamalili kumkunga Pauli muni vamtovayi, mwene akamkota chilongosi mmonga wa manjolinjoli mweayimi penapo, “Malagizu ginu yikuvayidakila kumtova mkolonjinji wa ku Loma angahamuliwa?” ");
INSERT INTO xnj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Hinu chilongosi yula peayuwini genago, akamjovela mkulu wa msambi wa manjolinjoli akajova, “Wigana kukita kyani? Mundu uyu ndi mkolonjinji wa ku Loma!” ");
INSERT INTO xnj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Hinu mkulu yula amhambalili Pauli, akamkota, “Nijovela, veve ndi mkolonjinji wa ku Loma?” Pauli akayangula, “Ena.” ");
INSERT INTO xnj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kangi mkulu yula akayendelela kujova, “Nene namkolonjinji wa Loma wa kugula kwa mashonga gamahele.” Pauli akajova, “Nambu nene namkolonjinji wa Loma mukuvelekewa.” ");
INSERT INTO xnj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Vandu vala vevamkotekesayi na kumtova michapilu Pauli bahapo vakawuka. Hati mkulu yula akayogopa peamanyili kuvya Pauli mkolonjinji wa ku Loma na kuni amkungili minyololo. ");
INSERT INTO xnj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chilau yaki mkulu wa msambi wa manjolinjoli aganili kumanya matakilu ga Vayawudi gevamtakili Pauli. Ndi amuwopwili minyololo na akalagiza vamteta vakulu va Chapanga na vagogo va libanji loha vakonganeka. Kangi amletili Pauli na kumyimika palongolo yavi. ");
INSERT INTO xnj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli avalolokisi takataka vandu vevakonganiki palibanji vala na kujova, “Valongo vangu, mbaka lelu iyi nihotwili kutama kwa kuhenga gakumganisa Chapanga.” ");
INSERT INTO xnj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mkulu wa kuteta wa Chapanga, mweikemiwa Anania akalagazila vevayimili papipi na Pauli vampamanda likofi mumlomo. ");
INSERT INTO xnj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Hinu Pauli akamjovela, “Chapanga mwene yati akutova likofi wamwene mweukujikita mbwina, mweuvi ngati luwumba lwevabakili chokaa! Wihotola wuli kutama na kuhukumwa malagizu kuni wamwene ukugadenya malagizu genago kwa kulagiza nene nitoviwayi?” ");
INSERT INTO xnj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Vandu vevayimili penapo vakamjovela Pauli “Ukumliga Mteta Mkulu wa Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli akajova, “Valongo vangu, namanyili lepi ngati mwene ndi Mteta Mkulu wa Chapanga. Ndava muni Mayandiku Gamsopi gijova, ‘Ukotoka kujova gahakau kumvala chilongosi wa vandu vaku.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Lukumbi lwenulo ndi Pauli amali kumanya vandu vangi mu libanji lila vavi Vafalisayu na vangi Vasadukayu. Akajova kwa lwami luvaha, “Valongo vangu, nene namfalisayu mwana wa mfalisayu. Vanitakili mu libanji kuvya nisadika vandu vevafwili yati viyuka.” ");
INSERT INTO xnj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Peamali kujova malovi ago kanyata ukahumila muhutanu pagati ya Vafalisayu na Vasadukayu mngonganu wapechengini. ");
INSERT INTO xnj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Muhutanu wene wavi, Vasadukayu vijova kuvya vandu vevafwili viyuka lepi, vavi lepi vamitumu va kunani kwa Chapanga. Mpungu nawene uvi lepi. Nambu Vafalisayu visadika goha ago gadatu. ");
INSERT INTO xnj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pakavya na njowo zamahele neju ndi vawula vangi va chikundi cha Vafalisayu vakayima na kujovesana kwa makakala, “Tichiweni lepi chihakau chochoha kwa mundu uyu, pangi kuvya mpungu amala mtumu wa kunani kwa Chapanga valongili nayu.” ");
INSERT INTO xnj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Muhutanu wavi uvaha neju hati mkulu wa msambi ayogwipi kuvya Pauli yati vakumpapulana hipandi hipandi. Ndi avalagizi manjolinjoli waki kuyingila pagati yaki, vamuwusayi Pauli na kumuwuyisa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kilu yiyoyo Bambu akamuhumila Pauli na kumjovela “Jipolesa mtima! Cheujova ndava yangu ku Yelusalemu apa yati wikita mewa Kumuji wa Loma.” ");
INSERT INTO xnj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kwapachili Vayawudi vakakonganeka na kukita mpangu, vakalapa yati vinywa lepi amala kulya mbaka vamkomayi Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Vala vevakitili mpangu wenuwo vavi neju ya vandu alobaini. ");
INSERT INTO xnj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ndi vakahamba kwa vakulu va vakuteta va Chapanga na vagogo, vakajova, “Tete tiviki chilapu yati nakulya chindu chochoha mbaka timkomayi Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hinu, nyenye pamonga na libanji mutuma ujumbi kwa mkulu wa msambi muni amletayi Pauli kwinu kudetekesa kuvya mwigana kuyuwana malovi goha ga kumvala mwene. Tijitendelekili kumkoma kwakona hati kuhika kwa nyenye.” ");
INSERT INTO xnj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nambu mwana wa mlumbu waki Pauli ayuwini mpangu wula, ndi akahamba muchifungu kumjovela Pauli malovi genago. ");
INSERT INTO xnj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kangi Pauli akamkemala mmonga wa valonda, akamjovela “Mtola msongolo mwenuyu, mpeleka kwa chilongosi wa msambi muni avi na lijambu la kumjovela.” ");
INSERT INTO xnj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ndi akamtola na kuhamba nayu mbaka kwa mkulu wa msambi akamjovela, “Pauli mweavimuchifungu yula anikemili na kuniyupa nimletayi msongolo uyu kwa veve muni avi na lilovi leigana kukujovela.” ");
INSERT INTO xnj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mkulu wa msambi akamkamula chiwoko msongolo yula na kuhamba nayu pandu pachiepela, akamkota, “Ugana kunijovela kyani?” ");
INSERT INTO xnj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na akajova, “Vayawudi vayidakilini kukuyupa umpeleka Pauli chilau pa libanji chakudetekesela vandu va libanji vigana kuyuwana hotohoto malovi gaki. ");
INSERT INTO xnj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nambu veve belayi luyupu lwavi ndava vavi vandu neju ya alobaini vakumbajamila, vaviki chilapu vinywa lepi amala kulya chindu mbaka vamkomayi, hinu vilindila uhamula waku.” ");
INSERT INTO xnj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mkulu wa msambi akamleka awuka, akambesa akotoka kumjovela mundu yoyoha kuvya anidandaulili. ");
INSERT INTO xnj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kangi Mkulu wa msambi akavakemela vakulu vaki vavili va vachilongosi akavalagiza, “Mutendelekela manjolinjoli miya zivili, vakwela falasi sabini, na manjolinjoli miya zivili wa migoha, vahamba ku Kaisalia, muwuka kwakona kuhika saa yidatu ya kilu lelu. ");
INSERT INTO xnj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mutendelekela falasi yungi ndava kumgega Pauli, mumhikisa changalemaswa kwa Felikisi Mkulu wa ku Yudea.” ");
INSERT INTO xnj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mkulu wa msambi yula ndi akayandika balua iyi, ");
INSERT INTO xnj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nene Kilaudio Lusia nikuyandikila mtopeswa mkulu Felikisi. Tikuwoni! ");
INSERT INTO xnj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mundu uyu akamuliwi na Vayawudi na vavi papipi kumkoma, penayuwini kuvya mwene mkolonjinji wa ku Loma, nikahamba pamonga na chikundi cha manjolinjoli, nikamkengelela. ");
INSERT INTO xnj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nampeliki palongolo ya libanji lavi likulu nihotola kumanya muhalu wewamtakili. ");
INSERT INTO xnj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ndi namanyili kuvya vamtakili ndava ya muhutanu wa malagizu gavi, nambu akitili lepi uhakau wowoha wewukumgana akomiwa amala akungiwa muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Panayuwini kuvya Vayawudi vaviki mpangu wa kumkoma, nahamwili vamletayi kwaku, mewawa nivajovili vevamtakili valeta matakilu gavi kwaku.” ");
INSERT INTO xnj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hinu, manjolinjoli vala vamtolili Pauli ngati chavalagaziwi. Kilu yilayila vakamupeleka mbaka Antipatili. ");
INSERT INTO xnj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Chilau yaki manjolinjoli va magendelu vala vawuyili kujela, vavalekili vayavi vevikwela falasi vayendelela na lugendu pamonga na Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pavahikili ku Kaisalia, vakampela Felikisi mkulu wa mkowa balua yila na kumgotola Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felikisi peamali kuyisoma balua yila akamkota Pauli ahumili mulima woki. Peamanywisi kuvya ahumili Kukilikia, ");
INSERT INTO xnj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akajova, “Yati nikuuyuwanila muhalu waku vala vevakutakili vakamala kuhika.” Kangi akalagiza Pauli avikiwayi munyumba ya unkosi wa Helodi na kumlindalila. ");
INSERT INTO xnj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Peyahikili ligono la mhanu, Mteta mkulu Anania ahikili Kukaisalia pamonga na vagogo vangi na mmanya malagizu mmonga wa Loma, liina laki Tetulo, ndi vamhambalili mkulu wa mkowa na kumtakila Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pauli akakemelewa, na Tetulo akatumbula kumtakila, “Mtopeswa Felikisi, ulongosi waku utiletili uteke uvaha na kavili utiletili mang'amusi gamahele gabwina ndava ya vandu vitu. ");
INSERT INTO xnj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Lijambu lenili tikulipokela cha luheku magono goha na tikusengusa neju. ");
INSERT INTO xnj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nambu changali kuyagisa lukumbi lutali, chondi kwa lipyana laku utiyuwanila padebe malovi gitu. ");
INSERT INTO xnj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tihumbwili kuvya mundu uyu avi na luhonda, mtumbulanu wa chitututu pagati ya Vayawudi kila pandu pamulima. Mewawa ndi chilongosi wa chikundi cha njila ya kumuyupa Chapanga chechikemelewa va Nazaleti. ");
INSERT INTO xnj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na hati alingili kuhakasa Nyumba ya Chapanga, tete tamkamwili. Taganili kumuhukumwa kwa mhilu witu. ");
INSERT INTO xnj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nambu Lusia mkulu wa msambi abwelili na kumuwusa pagati yitu kwa makakala, ");
INSERT INTO xnj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Wamwene ngati ukumkota mundu uyu yati wimanyalila mambu gala getamtakili tete.” ");
INSERT INTO xnj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Vayawudi kwa pamonga vakayidakila na kujova goha ago ndi gachakaka. ");
INSERT INTO xnj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kangi mkulu Felikisi akamlangisa Pauli kujova, mwene akajova, “Nimanyili kuvya veve ndi mhamula mihalu wa magono gamahele wa vandu vitu, nihekelela kujikengelela namwene. ");
INSERT INTO xnj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wihotola kumanya kuvya gapiti lepi magono kumi na gavili kuhumila penahambili ku Yelusalemu kumuyupa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Vandu ava vanikoli lepi nikotana na mundu yoyoha amala vanikoli lepi nikuvakoakeha vandu mu Nyumba ya Chapanga amala munyumba za kukonganekela Vayawudi, amala pandu popoha pamuji wenuwo. ");
INSERT INTO xnj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Vihotola lepi kujova uchakaka wa mambu aga gevakunitakila. ");
INSERT INTO xnj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nambu chindu cheniyidakila ndi kuvya nikumuhengela Chapanga wa vagogo vitu, nitama mukulanda Njila yevikemela chikundi cha njila ya kumuyupa Chapanga. Nene nisadika goha gegayandikiwi muhitabu ya malagizu na muhitabu ya vamlota va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nene nikumsadika Chapanga ngati chavisadika vandu ava, kuvya vandu vevamganisa na vevakum'budila Chapanga voha ya viyuka kwevafwili. ");
INSERT INTO xnj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ndava yeniyo nikujikangamalisa magono goha kutama wumi wa bwina changali kumbudila Chapanga na vandu.” ");
INSERT INTO xnj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Panakatamili kutali mumiyaka yamahele, nawuyili ku Yelusalemu muni nivaletela vakolonjinji vayangu mtangatilu na kuwusa luteta. ");
INSERT INTO xnj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lukumbi lwe nahengayi mambu ago ndi pavanikolili Munyumba ya Chapanga, namali kuwusa luteta lwa kunyambiswa. Pavi lepi msambi wa vandu amala chitututu. ");
INSERT INTO xnj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nambu kwavili na Vayawudi vangi kuhuma mulima wa ku Asia, venavo ndi veviganikiwa kuhika palongolo yaku na kunitakila ngati vana lilovi la kujova ndava yangu. ");
INSERT INTO xnj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Amala, vandu ava vevavi penapa vajova chenibudili pevanikolili niyimili palongolo ya libanji lavi likulu. ");
INSERT INTO xnj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ndi malovi ndu aga genajovili panakavili palongolo yavi, ‘Mukunihamula lelu iyi ndava ya kusadika kuvya vevafwili yati viyuka.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Hinu Felikisi, mweamanyili bwina njila yeniyo, akahegelesa muhalu wula mu ligono lingi. Akavajovela, “Yati nihamula muhalu uwu lukumbi Lusia Mkulu wa msambi, peibwela.” ");
INSERT INTO xnj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kangi akamlagiza chilongosi wa manjolinjoli yula vamlindalila Pauli, nambu avyai mukulekekeswa padebe, vankozi vaki vayidakiliwa kumtangatila. ");
INSERT INTO xnj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mu magono gegagelekili Felikisi abwelili pamonga na mdala waki Dilusila mweavi Myawudi. Akalagiza Pauli aletewayi, akamyuwanila ilongela ndava ya kumsadika Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nambu lukumbi Pauli peatumbwili kudandaula gakumganisa Chapanga, na kujiyepesa na uhamula wa Chapanga wewibwela, Felikisi ayogwipi, akajova, “Ndava hinu wihotola kuhamba, yati nikukukemela kavili panipata nafwasi.” ");
INSERT INTO xnj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Lukumbi lwenulo alindila manya Pauli ngaampeli mashonga. Ndava ya yeniyo amkemela pamahele kulongela nayu. ");
INSERT INTO xnj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Payamaliki miyaka yivili, Polikio Festo akavya Mkulu wa ku Yudea. Nambu Felikisi ndava ya kujiganisa kwa Vayawudi, mwene akamlekekesa Pauli kuhuma muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Magono gadatu, Festo patumbwili lihengu akawuka ku Kaisalia na kuhamba ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Vakulu va kuteta pamonga na vachilongosi va Vayawudi vakamjovela matakilu gegakumvala Pauli. Vakamuyupa neju Festo, ");
INSERT INTO xnj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","vakamuyupa neju Festo, alagazila Pauli vamletayi ku Yelusalemu, muni vavikili mpangu wa kumkoma akona munjila. ");
INSERT INTO xnj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nambu Festo avayangwili, “Pauli yati isigalila kukoko muchifungu Kaisalia namwene yati nihamba kanyata kwenuko. ");
INSERT INTO xnj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mvajovela vachilongosi vinu valongosana na nene kuhamba kwenuko, vakamtakila palongolo yangu, ngati abudili chindu.” ");
INSERT INTO xnj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo akatama nawu mulukumbi lwa magono nane amala kumi, kangi akawuya ku Kaisalia. Chilau yaki akahamba pa libanji, akalagizila Pauli vamletayi mugati. ");
INSERT INTO xnj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lukumbi Pauli ahikili, Vayawudi vevahumili ku Yelusalemu vamtindili vakatumbula kumtakila gamahele geginonopa nambu nakuhotola kujova uchakaka. ");
INSERT INTO xnj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kangi Pauli ajikengelili mukujova, “Nene nibudili lepi chindu chochoha pa malagizu ga Vayawudi amala ndava Nyumba ya Chapanga amala kumvala Nkosi wa ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nambu Festo ndava aganili kujiganisa kwa Vayawudi akamkota Pauli, “Wu wigana kuhamba ku Yelusalemu uhamuliwa palongolo yangu ndava ya matakilu genaga?” ");
INSERT INTO xnj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauli akayangula, “Niyima pa libanji la mihalu la nkosi wa ku Loma, bahapa ndi peniganikiwa kuhamuliwa. Wamwene umanyili bwina nivabudili lepi chindu chochoha Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ngati nene nambudaji amala nikitili chindu chechikunigana kukomiwa, nibela lepi kufwa. Nambu ngati kawaka uchakaka wa malovi gevanitakili ago, avi lepi mundu wa kunigotola kwa vene. Niyupa muhalu wangu ukahamuliwa kwa nkosi wa ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hinu Festo peamali kulongela na vamtangatila vaki mu libanji, ndi akamjovela Pauli, “Uyupili lufani kwa nkosi wa ku Loma, yati wipelekwa kwa mwene.” ");
INSERT INTO xnj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Magono gadebe gegagelekili, nkosi wa pandu pangi liina laki Agilipa na Belinike mweavi mlumbu waki, vahikili ku Kaisalia kumjambusa cha kumtopesa Festo. ");
INSERT INTO xnj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ndi vatamili kwenuko mu magono gamahele, Festo akamdandaulila nkosi mhalu wa Pauli, “Penapa avi mundu mmonga Felikisi amlekekesi Pauli kuhuma muchifungu. ");
INSERT INTO xnj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Penakahambili ku Yelusalemu vakulu va kuteta va Chapanga na vachilongosi va Vayawudi vamtakili na kuniyupa nimuhamula akomiwa. ");
INSERT INTO xnj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nambu nene navayangwili kuvya mvelu lepi wa vandu va ku Loma kumgotola mundu alipiswai kwakona angakonganeka na vevamtakili mihu kwa mihu na kupata fwasi ya kujikengelela ndava ya mambu gevamtakili. ");
INSERT INTO xnj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Hinu, pevamali kuhika penapa, ndi kanyata nakitili muhalu mulibanji chilau yaki, nalagazili mundu mwenuyu vamleta. ");
INSERT INTO xnj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Vamtakila vaki vayimili nambu nakudandaula matakilu geabudili ngati chenalindilayi. ");
INSERT INTO xnj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pahali paki ndi vavi na muhutanu pamonga nayu ndava ya njila ya kumuyupa Chapanga wavi na mundu mmonga liina laki Yesu mweamali kufwa, nambu Pauli ikangamala kujova akona muni. ");
INSERT INTO xnj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Namanyili lepi nikita kyani ndava ya muhalu wenuwo. Hinu, namkotili Pauli ngati igana kuhamba kulibanji la mihalu Yelusalemu kula, ndava ya matakilu ago. ");
INSERT INTO xnj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nambu Pauli akangamili kuyupa kusigalila muchifungu mbaka uhamula wa muhalu waki uhamuliwa na nkosi wa ku Loma. Ndava yeniyo nalagizi atama muchifungu mbaka penihotola kumpeleka kwa Kaisali.” ");
INSERT INTO xnj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kangi Agilipa akamjovela Festo, “Namwene nigana kumuyuwanila mundu mwenuyo.” Festo akamyangula, “Yati ukumuyuwanila chilau.” ");
INSERT INTO xnj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Hinu, chilau yaki Agilipa na Belinike vahikili kwa chilulu mu libanji la mihalu kuni valongosini na vakulu va msambi na vachilongosi va muji. Festo akalagiza Pauli vampeleka mugati. ");
INSERT INTO xnj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo akajova, “Nkosi Agilipa pamonga na vandu voha mwemuvi apa na tete! Palongolo yinu avi mundu, vandu voha va mulima wa Vayawudi va bahapa na ku Yelusalemu, vakumng'ung'utila kuvya iganikiwa lepi kulama wumi waki kavili. ");
INSERT INTO xnj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nambu namwene nichiwene lepi chindu chochoha cheabudili hati kuganikiwa akomiwa. Hinu ndava mwene ayupili muhalu waki uhamuliwayi na Nkosi wa Loma, nahamwili kumpeleka. ");
INSERT INTO xnj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mewa namwene nivii lepi na malovi gakumyandikila Nkosi wa ku Loma ndava ya muhalu uwu. Ndi mana nimletili palongolo yinu, ndi neju veve Nkosi Agilipa, muni mukamala kumkotakesa, nimanya chindu cha kumyandikila. ");
INSERT INTO xnj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ndava muni nihololela kuvya malovi gangali luhala kumpeleka mfungwa changali kulangisa matakilu gegakumvala.” ");
INSERT INTO xnj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Hinu Agilipa akamjovela Pauli, “Wihotola kujova malovi ga kujikengelela.” Ndi Pauli akakwesa chiwoko na kutumbula kujova. ");
INSERT INTO xnj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nkosi Agilipa, lelu niheka neju, kujikengelela palongolo yaku ndava ya mambu goha gevanitakili Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Neju ndava wamwene wimanya bwina mivelu ya Vayawudi na muhutanu wavi, nikuyupa uniyuwanila bwina.” ");
INSERT INTO xnj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Vayawudi voha vamanyili wumi wangu kutumbula uwana wangu, chenitamili kutumbula kadeni pamulima wangu ndi mewa ku Yelusalemu. ");
INSERT INTO xnj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Vanimanyili mu magono gamahele na vihotola kujova ndava yangu ngati vigana, kuvya kutumbula kadeni navili mmonga pagati ya chikundi cha Vafalisayu chechikangamalisa neju kulanda mvelu wa njila ya kumuyupa Chapanga yitu. ");
INSERT INTO xnj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na hinu nivii palongolo yaku nihamuliwa ndava nisadika lilaganu lila Chapanga avalagazili vagogo vitu. ");
INSERT INTO xnj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Malaganu gene ndi galagala gegihuvalila na makabila kumi na gavili ga vandu vitu, vakumhengela Chapanga muhi na kilu. Mtopeswa nkosi, Vayawudi vakunitakila ndava ya sadika yeniyo! ");
INSERT INTO xnj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ndava kyani nyenye mwivya na mtahu kusadika kuvya Chapanga akuvayukisa vevafwili? ");
INSERT INTO xnj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Chakaka namwene naholalili kuvya yikunigana kuhenga mambu kubela uhotola wa Yesu wa ku Nazaleti. ");
INSERT INTO xnj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Mambu genakitili ku Yelusalemu, napatili uhotola kuhuma kwa vakulu va kuteta va Chapanga, navasopili muchifungu vandu vamahele vevakumganisa Chapanga, ndi pavahukumiwi kukomiwa, nayidakili kuvya vakomiwa. ");
INSERT INTO xnj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pamahele navalipisi munyumba za kukonganekela Vayawudi zoha, navajovili kwa makakala vayibela sadika yavi. Namemili ligoga ndava yavi hati navahakili mbaka mumiji ya kutali.” ");
INSERT INTO xnj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Kwa lihengu lenilo, nahambili kumuji wa Damasko kwa uhotola na malagizu ga vamteta va vakulu va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mtopeswa Nkosi, lukumbi nivii munjila, muhi wa saa sita nauwene lumuli luvaha kuliku wa lilanga utilangasa kuhuma kunani kwa Chapanga, wanitidili nene pamonga na vamulugendu vayangu. ");
INSERT INTO xnj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tavoha tete tagwili pahi, ndi nayuwini lwami lukunijovela kwa luga ya Chiebulania, ‘Sauli, Sauli! Ndava kyani ukuning'aha? Ukujilemasa waka ngati ng'ombi yeyitakula ndonga ya bambu waki.’ ");
INSERT INTO xnj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ndi nene namkotili, ‘Veve wayani Bambu?’ Bambu akayangula, ‘Nene ndi Yesu mweukuning'aha. ");
INSERT INTO xnj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nambu hinu yimuka, uyimayi. Nikuhumalili muni nikuvika kuvya mtangatila wangu. Ukavajovela vandu vangi mambu geugaweni lelu na gala genivii nakona kukulangisa. ");
INSERT INTO xnj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yati nikusangula kuhuma kwa vandu va Isilaeli na vandu vangali Vayawudi, ndi nene kwenikutuma kwavi. ");
INSERT INTO xnj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Yati ukugagubukula mihu gavi muni uvang'anamusa vahuma muchitita na kuyingila mu lumuli, vahuma muulongosi wa Setani, vamuwuyila Chapanga, muni kunisadika nene valekekeswa gevamubudili Chapanga muni vatola uhali pamonga na vandu vevahaguliwi na Chapanga.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Ndi, Nkosi Agilipa, nabelili lepi maono ago ga kunani kwa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Hinu natumbwili hoti kuvakokosela vandu va ku Damasko, kangi kwa vandu va ku Yelusalemu na mulima woha wa ku Yudea mewawa kwa vandu vangali Vayawudi. Navakokosili vamuwuyila Chapanga kwa kulangisa mumatendu kuvya vang'anamwiki. ");
INSERT INTO xnj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ndava ya genago Vayawudi vanikamwili Munyumba ya Chapanga, vakalinga kunikoma. ");
INSERT INTO xnj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nambu kwa ulonda wa Chapanga nakona muni hati lelu, nikuvajovela vadebe na vavaha. Nidandaula galagala vamlota va Chapanga na Musa vajovili yati gihumila, ");
INSERT INTO xnj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kuvya yamganili Kilisitu kung'aiswa na mutumbula kuyuka, muni akokosayi kuvya lumuli lwa usangula lukuvalangasa vandu voha, Vayawudi na vandu vangali Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauli peajikengelelayi mu malovi ago, Festo akajova kwa lwami luvaha, “Pauli! Wipenga! Usomili neju ndi wipenga luhala.” ");
INSERT INTO xnj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nambu Pauli akajova, “Mtopeswa Festo, nipenga lepi mu malovi genijova ndi gachakaka na gana luhala. ");
INSERT INTO xnj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wamwene Nkosi, ukugamanya mambu aga, hinu nihotola kulongela kwa ukekesi palongolo yaku. Mambu genago gamanyikini kwaku muni lijambu ilo lahengiki lepi mumfiyu. ");
INSERT INTO xnj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Nkosi Agilipa, wu, ukugasadika gegajoviwi na vamlota vakadeni va Chapanga? Nimanyili kuvya ukugasadika.” ");
INSERT INTO xnj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa akamyangula Pauli, “Wihololela kuvya mu malovi gadebe wihotola kunikulukisa kuvya Mkilisitu?” ");
INSERT INTO xnj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauli akayangula, “Nikumuyupa Chapanga kuvya mulukumbi luhupi amala lutali lepi wamwene ndu, nambu voha vevakuniyuwanila lelu vahotola kuvya ngati chenivii nene, changali kukungwa minyololo.” ");
INSERT INTO xnj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kangi Nkosi Agilipa, mkulu Festo na Belinike na vandu voha vevatamii pamonga nawu, vakayima. ");
INSERT INTO xnj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Pevamali kuwuka ndi vajovisini, “Mundu mwenuyu ahengili lepi chindu chihakau hati kuganikiwa kukomiwa amala chifungu.” ");
INSERT INTO xnj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa akamjovela Festo “Mundu uyu ngaihotoliki kulekekeswa kuvyaa ayupili lepi uhamula kwa Nkosi wa ku Loma.” ");
INSERT INTO xnj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Pevamali kuvika mpangu wa lugendu lwa tete kuhamba Italia, Pauli pamonga na vafungwa vangi vagotoliwi pahi pa ulonda wa Juliasi mweavi Mkulu wa msambi wa manjolinjoli pagati ya chikundi chechikemelewa “Chikundi cha Augusti.” ");
INSERT INTO xnj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tayingili muwatu wewahuma ku Adilamito wewavedukila mumbwani ya miji ya Asia. Kangi tawukili pamonga na mkolonjinji wa Makedonia kuhuma Tesalonike liina laki Alistako. ");
INSERT INTO xnj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Chilau yaki tahikili kumbwani ya Sidoni. Juliasi amhengili lipyana Pauli kwa kumyidakila avalola vankozi vaki na kupata vindu vyaaganili. ");
INSERT INTO xnj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuhuma kwenuko, tagendili mumhana mwa chisiwa cha Kuplo ndava ya kuyepa mpungu wewabuma kuhuma kulongolo yitu. ");
INSERT INTO xnj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kangi takupwiki nyanja ya upandi wa Kilikia na Pamfulia, tahikili Mula muji wa Lukia. ");
INSERT INTO xnj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Penapo Mkulu wa msambi yula, aukolili watu wewihuma ku Alekisandalia na kuhamba ku Italia, ndi akatiyingisa mugati. ");
INSERT INTO xnj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tagendili mbolimboli mulukumbi lwa magono gamahele cha kutyalatyala neju tahikili papipi na muji wa Nido. Ndava ya mpungu wewatikang'ayi kuhuma kulongolo ndi tikahamba lumonga upandi wa Kilete kuhamba pandu pa yeyikemiwa Salimone. ");
INSERT INTO xnj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tapitili mumhana ya mbwani kwa kutyalatyala na kuhika pandu pepikemelewa “Bandali ya Bwina,” Papipi na muji wa Lasea. ");
INSERT INTO xnj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Lukumbi lwamahele lwamali kupita, hati magono ga kujihinisa chakulya gamaliki. Hinu vayogwipi neju lugendu lwa muwatu. Pauli akavajovela malovi aga. ");
INSERT INTO xnj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Mwavagosi, nihololela kuvya lugendu lwitu yati wivya na mang'ahiso na kuyagisa lepi ndava ya ndwika na watu ndu, nambu mewa na wumi witu.” ");
INSERT INTO xnj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nambu Mkulu wa manjolinjoli yula akasadika neju malovi ga mgendesa watu na ga mkolo watu, kuliku malovi ga Pauli. ");
INSERT INTO xnj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Hinu ndava bandali yeniyo yavi lepi nafwasi ya bwina kutama lukumbi lwa mbepu. Ndi vamahele pagati yavi vayidakilini kuwuka penapo na kuhamba mbaka Foinike ngati yihotoleka na kutama kwenuko mkulukumbi lwa mbepu. Bandali ya Kilete yeyihamba kwelihumila lilanga na kusini kwelitipama lilanga. ");
INSERT INTO xnj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Hinu, mpungu wa bwina pawatumbwili kubuma, vene vakahololela kuvya mpangu wavi wihotoleka, hinu vakahuta nanga vakatumbula lugendu kuni vigendesa watu papipi na mbwani ya Kilete. ");
INSERT INTO xnj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kwakona vangahika patali, mpungu ukali weukemiwa “Mpungu Eulokilo.” Watumbwili kubuma kuhuma muchisiwa. ");
INSERT INTO xnj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mpungu waukang'ili watu, wene wahotwili lepi kukangamala nawu, ndi taulekili mpungu uyikang'ayi. ");
INSERT INTO xnj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Na petapitayi pachisiwa chidebe chechikemiwa Kauda, tatyalityali nambu tahotwili kuukunga mtumbwi wa watu. ");
INSERT INTO xnj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Vanalihengu va muwatu pevamali kuyigisa mtumbwi wula mugati, ndi vakaukunga nyosi kwa makakala. Vayogwipi kukwama pa lilundu la masavati ga papipi na mbwani ya ku Libya, vakahelesa nyosi na kuleka watu wikang'iswa na mpungu. ");
INSERT INTO xnj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Mpungu na manji gatimbungini na pachilau yaki, vakatumbula kutaga ndwika munyanja. ");
INSERT INTO xnj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na ligono la datu vakatumbula kutaga vindu vya watu kwa mawoko gavi vene. ");
INSERT INTO xnj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mu magono gamahele valiwene lepi lilanga amala ndondo, mpungu na manji vyayendalili kutimbugana neju, kuhuvalila kwa kusanguka gavamaliki. ");
INSERT INTO xnj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Pavatamili magono gamahele changalya, Pauli akayima pagati yavi akajova, “Vamtopeswa, mbanga kuvya muniyuwanili malovi gangu ga kuleka kuwuka Kilete, ngatiyepili mang'ahiso ago pamonga na kuyagisa vindu ivi. ");
INSERT INTO xnj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nambu hinu nivayupa mjikangamalisa mtima, muni kawaka hati mundu mmonga mweiyagisa wumi waki, nambu watu wene ndi wewiyaga. ");
INSERT INTO xnj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndava muni golo kilu Mtumu wa kunani kwa Chapanga, kuhuma kwa Chapanga mwenikumuhengela, anihumalili, ");
INSERT INTO xnj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","akanijovela, ‘Pauli, kotoka kuyogopa! Yikukugana kuyima palongolo ya Nkosi wa ku Loma, Chapanga mwene yimganisi, ndi kwa ubwina waki akuvasangula wumi wa voha mulugendu lwinu.’ ");
INSERT INTO xnj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hinu vamtopeswa, mjikamngamalisa mtima ndava muni nikumsadika Chapanga kuvya givya mewawa ngati chenijoviwi. ");
INSERT INTO xnj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nambu yikutigana kutagwa kundumba ya chisiwa chimonga.” ");
INSERT INTO xnj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ligono la kumi na mcheche kilu manji pagatumbwili kutimbugana tikanga'iswa kuni na kula munyanja ya Adilia. Pagati ya kilu vanalihengu muwatu vaholalili kuvya papipi na pandumba. ");
INSERT INTO xnj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Vakalonda utali wa pahi wa nyanja kwa kuhelesa nyosi yeyakungiwi chindu chechitopa, vapatili utali wa mita alobaini. Na pavapimili kavili mwanakandahi vapatili utali wa mita selasini. ");
INSERT INTO xnj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ndava ya kuyogopa kukwama mumatalau ndi vakahelesa nanga mcheche za upandi mumbele mwa watu, vakamuyupa Chapanga kwicha kanyata. ");
INSERT INTO xnj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Vanalihengu va muwatu, vaganili kutila ndi vamali kuhelesa mtumbwi wavi mumanji, vakongayi kuvya vihamba kulongolo kuhelesa nanga za muwatu. ");
INSERT INTO xnj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nambu Pauli amjovili Mkulu wa msambi yula pamonga na manjolinjoli vangi, “Vanalihengu ava ngati vitama lepi mugati ya watu, yati mwisanguliwa lepi.” ");
INSERT INTO xnj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Penapo ndi manjolinjoli vala vakadumula nyosi zezakamwili mtumbwi wula, vakauleka uhamba na manji. ");
INSERT INTO xnj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Papipi na hamba kucha, Pauli akavayupa voha valyayi chakulya, “Lelu ndi ligono la kumi na mcheche vavili na wogoyi lukumbi lwoha ulo mwangalya chindu. ");
INSERT INTO xnj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hinu, nikuvayupa mlyayi chakulya muni mukuchigana muhotola kulama, Muni kawaka hati luyunju lumonga wa mitu yinu lweluyaga.” ");
INSERT INTO xnj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Peamali kujova malovi ago, Pauli akatola libumunda, akamsengusa Chapanga palongolo yavi voha akametula akatumbula kulya. ");
INSERT INTO xnj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kangi voha vakasindimala mtima, navene mewa vakalya chakulya. ");
INSERT INTO xnj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mugati ya watu wula tavi vandu miya zivili na sabini na sita. ");
INSERT INTO xnj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Pevamali kulya na kuyukuta kila mundu, ndi vapungwizi utopa kwa watu, kwa kutaga nganu munyanja. ");
INSERT INTO xnj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kwapachili, vanalihengu vala vaumanyili lepi mulima wula, ndi vayiwene ndumba yeyivi papipi na manji, vakajovesana vayegeka watu kwenuko ngati yihotoleka. ");
INSERT INTO xnj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ndi, vakadumula nanga na kuzileka munyanja, mewa vakahuta nyosi za kugendesela watu, kangi vakatola chitambala chimonga kulongolo kukinga mpungu, vakahamba kundumba. ");
INSERT INTO xnj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nambu vahikili pamngonganu wa manji, na watu wakwamili, upandi wa kulongolo wajwigwimi mumasavati changali kunyugusika. Upandi wa mumbele wa watu watumbwili kudenyekana hipandi hipandi ndava kukang'wa na mpungu ga manji ga kutimbugana. ");
INSERT INTO xnj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Manjolinjoli vavi na mpangu wa kuvakoma vafungwa voha ndava ya kuyogopa kuvya vihotola kusambalila mbaka kundumba na kutila. ");
INSERT INTO xnj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nambu Mkulu wa msambi yula aganili kumsangula Pauli, avabesili valeka mpangu wavi. Akalagiza vevimanya kusambalila vahumba kuhuma muwatu na kusambalila mbaka kundumba, ");
INSERT INTO xnj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","na vevasigalili vajisangula kwa kukamulila mbau amala chipandi cha watu weudenyiki, ndi tavoha tahikili tavamumi kundumba. ");
INSERT INTO xnj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Patamali kuhika bwina kundumba ndi tamanyili kuvya chisiwa chila chikemelewa Malita. ");
INSERT INTO xnj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Takangisi ndava vakolonjinji vatihengili gabwina neju tete. Fula ndi yatumbula kutonya na kwavili na mbepu, hinu vakoyili motu na kutigongolela. ");
INSERT INTO xnj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauli anongili ndwika udebe wa sagala akazikohokea pamotu, penapo ndava ya lyoto la motu, limoma lahumalili musagala na lamulumili Pauli muchiwoko na kujikamulisa. ");
INSERT INTO xnj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Vala vakolonjinji pavawene limoma lijikamulisi dombeka muchiwoko cha Pauli, vakajovesana, “Chakaka mundu uyu mkomaji, pamonga na kusanguka kufwa munyanja, nambu lihoka litu lelikemiwa ganisa Chapanga likumleka lepi alama.” ");
INSERT INTO xnj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nambu mwene akakung'undila limoma pamotu na alemili lepi hati padebe. ");
INSERT INTO xnj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Vandu vala vevalolokesa kuvya yati ihimba amala kugwa pahi na kufwa. Pavalindili mulukumbi lutali changalola kuvya Pauli apatili lepi lijambu loloha lihakau, ndi vakang'anamusa maholo gavi vakujova mwene ndi lihoka. ");
INSERT INTO xnj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Papipi na pandu apo pavili na migunda ya Publio, chilongosi wa chisiwa chila. Ndi mwene atigongolili cha uganu na tatamili munyumba yaki mu magono gadatu. ");
INSERT INTO xnj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Hinu, dadi waki Publio agonili palusongwani, ndava ya utamu na kuseka ngasi. Ndi Pauli ahambili kumlola na peamali kumuyupa Chapanga, akavika mawoko gaki panani ya mtamu ndi akamlamisa. ");
INSERT INTO xnj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Palahumalili lijambu lenilo, vatamu voha muchisiwa chenicho vabwelili na kulamiswa mewa. ");
INSERT INTO xnj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Vandu vatipelili njombi ndalindali lukumbi patatumbwili kavili lugendu vayingisi vindu vyoha vyetaganilli muwatu. ");
INSERT INTO xnj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Payamaliki miyehi yidatu tatumbwili kavili lugendu muwatu wewihuma ku Alekisandalia yeyihongoliwi chimong'omong'o ya “Vachapanga Mapaha.” Watu wenuwo wayimili muchisiwa icho mulukumbi lwoha lwa mbepu. ");
INSERT INTO xnj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Patahikili pamuji wa Silakusa, tatamili penapo mu magono gadatu. ");
INSERT INTO xnj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuhuma kwenuko tagendili na kuhika kumuji wa Legio. Chilau yaki, mpungu wa kusini watumbwili kubuma, ndi mulugendu lwa magono gavili tahikili pamuji wa Putioli. ");
INSERT INTO xnj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kwenuko tavakoli valongo vamsadika, ndi vatigongolili titama nawu mulijuma limonga. Kangi tayendalili na lugendu kuhika ku Loma. ");
INSERT INTO xnj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Vamsadika va ku Loma vala pevayuwini malovi ga kutivala tete, vakabwela kutali pandu pakugulisila vindu la Apio na Munyumba Zidatu za Vayehe kukonganeka na tete. Pauli peawene akamsengusa Chapanga na kusindimaliswa mtima. ");
INSERT INTO xnj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Petahikili ku Loma Pauli ayidakiliwi kutama mwene pamonga na linjolinjoli mmonga wa kumlindalila. ");
INSERT INTO xnj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pagamaliki magono gadatu, Pauli avakemili pamonga vachilongosi va Vayawudi va pandu apo. Pavakonganiki mwene akavajovela, “Valongo vangu, nene nakungiwi muchifungu ku Yelusalemu kula na kugotolewa kwa vandu va ku Loma, nambu nene nahengili lepi chindu chihakau amala kubela mivelu ya vagogo vitu. ");
INSERT INTO xnj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Valumi pevamali kunikotakesa vaganili kunilekekesa muni nahengili lepi chindu chihakau chechikunigana kukomiwa. ");
INSERT INTO xnj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nambu Vayawudi vala vakabela lijambu ilo, ndi nene nikayupa kuhamuliwa na Nkosi wa ku Loma, nambu navi lepi na chochoha cha kuvatakila vandu va mulima wangu. ");
INSERT INTO xnj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ndava ya genago ndi nivakemelili tiwonanganayi na kulongela na nyenye, muni nikungiwi minyololo iyi ndava ya lilagizu la Chapanga kwa Isilaeli.” ");
INSERT INTO xnj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Vene vakamjovela, “Tete tipokili lepi balua ya kuhuma ku Yudea, mewa kawaka mlongo yoyoha mweahikili kutijovela lasimi amala kulongela chindu chochoha chihakau ndava yaku. ");
INSERT INTO xnj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nambu tigana kuyuwana maholo gaku wamwene, muni timanya kuvya chikundi chenicho chibelelewa kila pandu.” ");
INSERT INTO xnj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Hinu vakayidakilana ligono la kukonganeka nayu, vandu vamahele vamhikili peatamili. Kutumbula lukela mbaka kimihi Pauli avadandaulili na kuvajovela ujumbi wa kuuvala Unkosi wa Chapanga, alingili avakulukisi vayidakila mambu ga Yesu kwa kuhengela malagizu ga Bambu geampelili Musa na mayandiku ga vamlota va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Vangi pagati yavi vakofyiliwi malovi gaki, nambu vangi vasadiki lepi. ");
INSERT INTO xnj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Hinu, vakapechengana mumaholo gavi vene kwa vene. Hinu vawukili ndava Pauli, ajovili lijambu limonga, “Mpungu Msopi avajovili chakaka vagogo vinu mu njila ya mlota wa Chapanga Isaya, ");
INSERT INTO xnj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","akajova, ‘Uvahambila vandu ava uvajovela, kuyuwana yati mwiyuwana, nambu nakumanya, kulola yati mwilola, nambu yati mwimanya lepi. ");
INSERT INTO xnj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ndava mitima ya vandu ava yitopa, vadindili makutu gavi, na vakupiki mihu gavi. Ngati lepi kulola kwa mihu gavi ngavayuwini kwa makutu gavi, ngavamanyili kwa luhala lwavi na valeka njila zavi zihakau, kangi nivalamisi.’ ” ");
INSERT INTO xnj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kangi Pauli akajova, “Mmanya kuvya ujumbi wa Chapanga ndava ya kusanguliwa upelikwi kwa vandu vangali Vayawudi. Na vene yati vauyuwanila.” ");
INSERT INTO xnj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pauli peamali kujova genago, Vayawudi vakawuka, vakakotana gamahele vene kwa vene. ");
INSERT INTO xnj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Palukumbi lwa miyaka yivili, Pauli atamili munyumba yeapangili mwene, avagongolili munyumba vandu voha vevabwelili kumjambusa. ");
INSERT INTO xnj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Avakokosili malovi ga Unkosi wa Chapanga na kuwula vandu ndava ya Bambu Yesu Kilisitu kwa ukekesi na changabesiwa na mundu.");
INSERT INTO xnj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nene Pauli niyandika balua iyi, mtumisi wa Kilisitu Yesu, mwenikemeliwi kuvya mtumi na kuhaguliwi na Chapanga, kwa lihengu la kuvakokosela vandu Lilovi la Bwina. ");
INSERT INTO xnj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Penapo kadeni, Chapanga avahaidili vandu Lilovi la Bwina lenili, mu njila ya vamlota vaki ngati cheyiyandikwi mu Mayandiku Gamsopi. ");
INSERT INTO xnj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Lilovi la Bwina lenili likumvala Mwana wa Chapanga, BAMBU witu Yesu Kilisitu, muhiga avelekiwi mu lukolo lwa nkosi Daudi. ");
INSERT INTO xnj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nambu kuuvala wumi waki chimpungu wa Mpungu Msopi ajilangisi kwa makakala gaki kuvya Mwana wa Chapanga kwa kuyuka kwaki. ");
INSERT INTO xnj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Mu njila yaki, nene nipewili ubwina wa Chapanga kuvya mtumi, muni ndava ya Kilisitu nivalongosayi vandu va milima yoha vasadikayi na kuyidakila. ");
INSERT INTO xnj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nyenye ndi pagati ya vandu venavo vevitama ku Loma, muhaguliwi muvyai vandu vaki Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Hinu nikuvayandikila mwavoha nyenye mwemwitama ku Loma ndi Chapanga akuvagana, akavahagula muvyai vandu vaki. Nikuvaganila uteke na ubwina kuhuma kwa Chapanga Dadi witu na BAMBU witu Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nitumbula kumsengusa Chapanga wangu mu njila ya Yesu Kilisitu ndava yinu mwavoha, ndava sadika yinu yiyuwaniki na vandu voha va pamulima. ");
INSERT INTO xnj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nikumhengela Chapanga, kwa mtima wangu woha kwa kukokosa Lilovi la Bwina la Mwana waki, mwene amanyili kuvya nijova chakaka kuvya nikuvakumbuka ");
INSERT INTO xnj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","lukumbi lwoha nikumuyupa mwene. Nikumuyupa Chapanga akaganayi, anihotosa nihotola kuvagendelela. ");
INSERT INTO xnj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Muni ninogela neju kuvalola na kuhanganila pamonga njombi yeakuvapela Mpungu Msopi muni avakangamalisa. ");
INSERT INTO xnj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Chenijova apa tavoha tikangamalisanayi, sadika yangu yivakangamalisa nyenye, na sadika yinu yinikangamalisa nene. ");
INSERT INTO xnj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Valongo vangu, nigana mumanyai kuvya naganili pamahele kuvagendelela, nambu mbaka hinu nibesiwi. Nigana kupata gabwina pagati yinu nyenye vandu mwemukumsadika Kilisitu ngati chenapatili pagati ya vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nivii na lihengu la kuvakokosela vandu voha vevavili na uyovelu yabwina na vana matendu yihakau, vevachenjili na vayimu. ");
INSERT INTO xnj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Hinu nene ninogela neju kulikokosa Lilovi la Bwina mewawa nyenye mwemwitama ku Loma. ");
INSERT INTO xnj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nikuliwonela lepi soni Lilovi la Bwina, ndava lina makakala ga Chapanga ga kumsangula kila mundu mweisadika, kutumbula kwa Vayawudi kangi kwa vangali Vayawudi mewawa. ");
INSERT INTO xnj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Muni Lilovi la Bwina lilangisa hotohoto Chapanga cheakuvayidakila vandu vavyai vabwina kwaki. Kwa njila ya kusadika kutumbula utumbukanu mbaka mwishu. Ngati cheyiyandikwi mu Mayandiku Gamsopi, “Mundu mweakitiwi kuvya mbwina palongolo ya Chapanga yati itama kwa sadika.” ");
INSERT INTO xnj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Chapanga amanyisi ligoga laki kuhuma kunani kwa Chapanga kwa kumbudila na uhakau woha wa vandu, vene kwa uhakau wavi vakuudiva uchakaka ukoto kumanyikana. ");
INSERT INTO xnj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ndava muni, gala gegikita Chapanga amanyikana kwavi gavi hotohoto, muni Chapanga mwene agalangisi kwavi. ");
INSERT INTO xnj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kutumbula Chapanga peawumbili mulima, makakala gaki ga magono goha gangali mwishu na uchapanga waki, chewimanyikana hotohoto hati ngati uloleka lepi kwa mihu. Nambu vandu vihotola kuulola kwa vindu vyeawumbili Chapanga. Hinu vandu vavi lepi na chindu chakujikengelela! ");
INSERT INTO xnj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pamonga vammanyili Chapanga, nambu vakumlumba lepi na kumsengusa, pahali paki, maholo gavi gauyimu na mitima yavi yisopiwi chitita. ");
INSERT INTO xnj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Vimeka kuvya vachenjili nambu vayimu. ");
INSERT INTO xnj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Vileka kumulumba Chapanga mweifwa lepi, na pahali paki vakuhilumba himong'omong'o yeyiwanangana na mundu mweifwa, ngati videge amala hinyama amala vingokoko yeyikwava. ");
INSERT INTO xnj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ndava yeniyo, Chapanga avalekili valandayi mnogo uhakau wa mitima yavi na kukitilana mambu ga soni muhiga zavi. ");
INSERT INTO xnj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Vakuung'anamusa uchakaka wa Chapanga kuvya udese, vakuvigundamila na kuvihengela vindu vyeviwumbiwi pahala pa Chapanga, vakumlumba lepi muwumba mwene mweiganikiwa kulumbiwa magono goha gangali mwishu! Ena. ");
INSERT INTO xnj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ndava vikita genago, Chapanga avalekili valandayi mnogo wavi uhakau wa soni. Hati vadala valekili kugona na vagosi ngati cheyiganikiwa pahala paki vinogelana vene kwa vene. ");
INSERT INTO xnj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Na vagosi mewawa, valekili kugona na vadala ngati cheyiganikiwa, badala yaki vinogelana vene kwa vene. Vagosi kwa vagosi vikitilana mambu ga soni, ndava yeniyo vakujiletela vene kuhamuliwa kwa uhakau wavi wevahengili. ");
INSERT INTO xnj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ndava muni vandu avo vabelili kuvika muluhala lwavi uchakaka wa kummanya Chapanga, namwene avalekili valanda luhala lwavi luhakau, vakitili gala gegabesiwi kukitiwa. ");
INSERT INTO xnj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vandu venavo vamemili uhakau woha, uhakau na uhutulu mnogo kuyola vindu wihu na ukomaji na luhonda na udese na kuhenga matendu gahakau na kuheha, ");
INSERT INTO xnj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","na kuvakupakisa vayavi na vevakumuyomela Chapanga na veviliga na vevakujilumba na vevimeka na viyidakilana kukita gahakau na vala vevibela kuvayidakila vala vevavaveliki, ");
INSERT INTO xnj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","vayimu na vilanda lepi lilaganu lavi na vakuvagana lepi vandu na vakuvahengela lepi lipyana vandu vangi. ");
INSERT INTO xnj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Vamanyili ngati malagizu ga Chapanga gijova vandu vevikita vindu ngati ivi viganikiwa kufwa, nambu vikita vindu vyenivyo ndi lepi vindu ivyo ndu, ndi mewawa vakuvayidakila vevikita vindu vyenivyo. ");
INSERT INTO xnj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Hinu nkozi wangu, ngati ukuvahamula vandu vangi, katu uhotola lepi kujikengelela, hati ngati veve wayani. Ndava muni, peuvahamula vangi, kuni wamwene ukita galagala gevikita vene ukujihamula wamwene. ");
INSERT INTO xnj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Timanyili ngati kuhamuliwa na Chapanga kwa vala vevikita mambu ngati ago ndi uhamula wa chakaka. ");
INSERT INTO xnj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nambu veve nkozi mweakuvahamula vala vevikita mambu ngati ago kuni wamwene ukita ago. Wu, uhololela uhotola kuyepa kuhamuliwa na Chapanga? ");
INSERT INTO xnj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Amala ukuuvevesa ubwina waki ukulu na kukangamala kwaki na kusindimala kwaki, wu umanyili lepi ngati ubwina wa Chapanga ukutilongosa tileka uhakau timuwuyila mwene? ");
INSERT INTO xnj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nambu ndava ya ndindani yinu na unonopa wa mitima yinu yangagana kumuwuyila Chapanga, ndi ukujivikila uhamula uvaha mu ligono lila la ligoga la Chapanga, na uhamula waki wewukumganisa peyigubukuliwa. ");
INSERT INTO xnj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Chapanga yati akuvalipisila kila mundu kuwanangana na matendu gaki. ");
INSERT INTO xnj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Vandu vala veviyendelela kukita gabwina, kuni vigana utopesa ukulu na wumi wangahalabika, vandu ava Chapanga yati akuvapela wumi wa magono goha gangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nambu vala vevilanda mambu gavi vene na vala vevibela uchakaka muni valanda uhakau, vandu avo Chapanga yati akuvahamula chakaka kwa ligoga laki likulu. ");
INSERT INTO xnj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Mang'ahiso na lipyanda gakumkolela kila mundu mweikita uhakau, gakuvakolela Vayawudi hoti, kangi kwa vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nambu Chapanga akuvalumba, akuvatopesa na akuvapela uteke vala vevikita gabwina, Vayawudi hoti, na vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Muni Chapanga akumbagula lepi mundu yoyoha. ");
INSERT INTO xnj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Vandu vangali Vayawudi vangaimanya malagizu ga Musa kuni vikita uhakau yati viyaga changamanya malagizu. Na Vayawudi vevimanyili malagizu kuni vikita uhakau yati vihamuliwa kwa Malagizu genago. ");
INSERT INTO xnj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Muni lepi veviyuwana malagizu ndi vikita gabwina palongolo ya Chapanga, nambu vala vevikamula malagizu ndi veviyidakiliwa kuvya vabwina palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Vandu vangali Vayawudi vangamanya Malagizu ga Musa, pala pevikita mambu mu uyovelu yevavelikiwi nazu kwa kuwanangana na malagizu vene vilangisa kuvya vamanyili gegiganikiwa kuhenga hati ngati vangamanya malagizu. ");
INSERT INTO xnj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ndava muni mwenendu wavi wilangisa malagizu yiyandikwi mu mitima yavi. Mitima yavi yilangisa kuvya lijambu lenili ndi chakaka, muni maholo gavi gilangisa kuvya lukumbi lungi gakuvatakila, na lukumbi lungi gakuvakengelela. ");
INSERT INTO xnj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Aga yati gihumalila ligono Chapanga peihamula mambu ga mfiyu ga vandu mu njila ya Yesu Kilisitu ngati chelijova Lilovi la Bwina lenivakokosili. ");
INSERT INTO xnj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Hinu veve mweukujikemela Myawudi, ukuyihuvalila malagizu ga Musa na kumekela kuvya wa mundu wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ukugamanya gala geigana Chapanga ugakitayi na uhotola kuhagula gabwina muni malagizu gakuwulili, ");
INSERT INTO xnj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","veve ujilola kuvya chilongosi wa vandu ngalola na lumuli kwa vala vevavi kuchitita, ");
INSERT INTO xnj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","veve ndi muwula wa vayimu na muwula wa vandu vangakangala. Ndava muni uholalela mu malagizu weuvinayu luhala lwoha na chakaka. ");
INSERT INTO xnj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ndi veve ukuvawula vangi, ndava kyani ukujiwula lepi wamwene? Ukuvakokosela vangi vakotoka kuyiva ndava kyani wamwene uyiva? ");
INSERT INTO xnj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ujova, “Mkoto kukita ugoni,” Ndava kyani wamwene ugonekana? Ukuyivenga michapanga ya vimong'omong'o nambu wamwene uyingila na kuyiva vindu munyumba za michapanga? ");
INSERT INTO xnj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Umeka ngati uvi na malagizu ga Chapanga, ndava kyani wamwene ukumvevesa Chapanga na kudenya Malagizu gaki? ");
INSERT INTO xnj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Vandu vangali Vayawudi vakuliliga liina la Chapanga “Ndava ya matendu ginu nyenye Vayawudi.” ");
INSERT INTO xnj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kudumula jandu ngalivii lijambu labwina ngati wikamula Malagizu ga Chapanga, nambu ngati widenya Malagizu ndi ngausigalili changali kudumula jandu. ");
INSERT INTO xnj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Mundu angali myawudi mweangadumula jandu akakitayi ngati Malagizu gigana wuli, yati ivalangiwa lepi ngati mundu mweadumwili jandu? ");
INSERT INTO xnj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Vandu vangali Vayawudi vala vangadumuliwa jandu, vikamula Malagizu yati vakuvahamula nyenye Vayawudi muni mukamula lepi Malagizu, hati ngati muvi nagu malagizu gegayandikwi na mudumuliwi jandu. ");
INSERT INTO xnj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ndi kujova, mundu ivya lepi Myawudi wa chakaka kwa kulolekana chakuvala amala mundu ivya lepi Myawudi wa chakaka, kwa kudumuliwa jandu. ");
INSERT INTO xnj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Myawudi wa chakaka ndi yula mweavili myawudi cha mugati, ndi mweadumwili jandu mu mtima. Lihengu lenili ndi la Mpungu wa Chapanga, lepi lijambu la malagizu gayandikwi. Mundu wa naha yati ilumbiwa na Chapanga ndi lepi na vandu. ");
INSERT INTO xnj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Wu, Myawudi ana chindu choki chingi chechiyonjokisi kuliku vandu vangi? Amala kudumula jandu kuna chiyonjokesu? ");
INSERT INTO xnj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ena, chivili chiyonjokesu. Kutumbula, Chapanga avagotolili Vayawudi ujumbi waki. ");
INSERT INTO xnj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nambu yivya wuli ngati vangi vavi vangasadika? Wu, lijambu lenili yati liwusa usadikika wa Chapanga? ");
INSERT INTO xnj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Hati padebe! Leka Chapanga alolekana mchakaka magono goha, hati ngati kila mundu mdese. Ngati Mayandiku Gamsopi chegijova, “Kila pewijova, ulangisa uchakaka, pevakuhamula, yati wihotola pevakutakili.” ");
INSERT INTO xnj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nambu, ngati uhakau witu ulangisa Chapanga ikita gabwina, hinu tijova wuli? Wu, tijova Chapanga ibuda peakutihamula? Penapa nilongela chiumundu. ");
INSERT INTO xnj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hati padebe! Ngayivyai naha, Chapanga ngaihotola wuli kuvahamula vandu voha va pamulima? ");
INSERT INTO xnj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mundu ihotola kukota, “Ngati udese wangu yati utangatila kulangisa neju uchakaka wa Chapanga na kulangisa ukulu waki, hinu ndava kyani nihamuliwa kuvya nimbudili Chapanga!” ");
INSERT INTO xnj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Hinu ndava kyani tijova lepi, tikitayi gahakau ndi tipatayi gabwina! Vandu vatiligili, vakajova kuvya nene niwula chenicho. Yati vihamuliwa ngati cheyiganikiwa. ");
INSERT INTO xnj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Hinu tijova kyani? Wu, Tavayawudi tavabwina kuliku vandu vangi? Hati padebe! Ngati chenivajovili pakutumbula kuvya Vayawudi na vandu vangali Vayawudi voha vetalaliwa na kubuda. ");
INSERT INTO xnj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ngati Mayandiku Gamsopi chegijova, “Kawaka hati mmonga mweavili mbwina palongolo ya Chapanga! ");
INSERT INTO xnj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Kawaka mundu mweamanyili, mewa kawaka hati mmonga mweinogela kumlonda Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Voha vamlekili Chapanga, voha vabudili, kawaka mweikita gabwina, kawaka hati mmonga. ");
INSERT INTO xnj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Malovi gavi ginunga ngati litinda leligubukuliwi, lulimi lwavi lumemili udese, Mu milomo yavi gihuma malovi gana chimatila ngati cha liyoka. ");
INSERT INTO xnj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Milomo yavi yimemili likoto na lipyanda. ");
INSERT INTO xnj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Vandu avo vihamba kanyata kukoma vandu, ");
INSERT INTO xnj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Poha pevihamba vihalabisa na kuleka mang'ahiso. ");
INSERT INTO xnj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Vamanyili lepi kutama cha uteke. ");
INSERT INTO xnj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Vakumyogopa lepi Chapanga hati padebe.” ");
INSERT INTO xnj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Hinu timanyili kuvya malagizu ga Musa peyijova na vandu vala veviganikiwa kulongoswa na malagizu, muni kila mundu akotoka kuhotola kujikengelela, na vandu voha vahamuliwa na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Muni kawaka mundu yoyoha mweiyidikiwa kuvya mbwina palongolo ya Chapanga kwa kuyidakila Malagizu. Nambu malagizu gakutikita timanya kubuda. ");
INSERT INTO xnj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nambu hinu, njila ya Chapanga ya kuvayidikila vandu kuvya vabwina palongola yaki yimali kumanyikana. Njila yeniyi yihuvalila lepi Malagizu ga Musa. Hati hitabu ya Malagizu vyeviyandikwi na Musa na vamlota Chapanga vijova lijambu lenili. ");
INSERT INTO xnj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Chapanga akuvakita vandu kuvya vabwina palongolo yaki kwa kumsadika Yesu Kilisitu. Chapanga ikita chenichi kwa voha vevakumsadika Kilisitu, kawaka mlekengano kwa Vayawudi na vandu vangali Vayawudi. ");
INSERT INTO xnj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Vandu voha vambudili Chapanga na vavi kutali na ukulu wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nambu kwa njombi waka ya ubwina wa Chapanga, vandu voha viyidikiwa kuvya vabwina kwa njila ya Yesu Kilisitu mweakuvagombola. ");
INSERT INTO xnj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Chapanga amuwusili Yesu avya luteta, muni kwa ngasi yaki ahotola avalekekesa vandu kumbudila Chapanga kwa sadika yavi kwa Yesu Kilisitu. Akitili chenicho muni alangisa ubwina waki palongolo ya vandu. Kwakona Kilisitu kufwa Chapanga alolili ndu changali kuvabuna ndava ya mabudilu gavi. ");
INSERT INTO xnj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Nambu kwa lukumbi ulu amuwusili Yesu muni kulangisa mwene ndi mbwina, na kwa kukita chenicho Chapanga ilangisa kuvya mwene ndi mbwina na ihotola kuvakita vandu kuvya vabwina palongolo yaki kwa kumsadika Yesu. ");
INSERT INTO xnj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Hinu tihotola kumekela kyani? Kawaka! Ndava kyani! Wu, mundu ihotola kumeka ndava kuyidakila Malagizu ga Chapanga? Lepi! Nambu muni tikumsadika Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ndava muni tilola kuvya Chapanga akumkita mundu kuvya mbwina palongolo yaki kwa njila ya sadika, lepi kwa kuyidakila Malagizu. ");
INSERT INTO xnj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Wu, Chapanga ndi Chapanga wa Vayawudi vene ndu? Wu mwene lepi Chapanga wa vandu vangali Vayawudi mewawa? Ena, mwene ndi Chapanga wa vandu vangali Vayawudi mewawa. ");
INSERT INTO xnj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Chapanga ndi mmonga, na akuvakita Vayawudi vavya vabwina palongolo yaki kwa sadika yavi, mewawa akuvakita vandu vangali Vayawudi vavyayi vabwina palongolo yaki kwa njila ya sadika yiyoyo. ");
INSERT INTO xnj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Wu, hinu tikuyivika kutali Malagizu kwa sadika iyi? Hati padebe, nambu tikuyitopesa Malagizu. ");
INSERT INTO xnj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Hinu tijova wuli, ndava ya Ibulahimu gogo witu? Ajiwulili kyani? ");
INSERT INTO xnj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Muni ngati Ibulahimu avalangiwi ubwina palongolo ya Chapanga kwa gala geakitili, ngaavili na chindu cha kumekela, nambu lepi palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ndava muni Mayandiku Gamsopi gijova, “Ibulahimu amusadiki Chapanga, ndi mwene Chapanga amuyidikili kuvya mbwina palongolo yaki.” ");
INSERT INTO xnj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Muhenga lihengu ilipwa luhuna, luhuna lwaki lepi njombi nambu ndi chindu cheiganikiwa kupewa. ");
INSERT INTO xnj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nambu mundu mwangahuvalila matendu gaki mwene, nambu akumsadika Chapanga mweakuvakita vabudanu kuvya vangabuda, hinu Chapanga akuyidakila sadika ya mundu mwenuyo, akumyidakila kuvya mbwina palongolo yaki. ");
INSERT INTO xnj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Na mwene Daudi ajovili chindu chichichi, luheku lwa mundu yula Chapanga mweakumyidakila kuvya mbwina palongolo yaki changalola matendu gaki. ");
INSERT INTO xnj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Vamotisiwi vala vevalekekiswi uhakau wavi, kumbudila kwavi Chapanga kuwusiwi. ");
INSERT INTO xnj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Amotisiwi mundu yula, ndi BAMBU ivalanga lepi kubuda kwaki.” ");
INSERT INTO xnj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Wu, kumotisiwa kwenuko yeajovili Daudi ndi vandu vevadumwili jandu vene? Lepi mewawa vandu vangadumula jandu. Ngati chenalongolili kujova, “Ibulahimu amsadiki Chapanga na kwa sadika yaki Chapanga amvalangili kuvya mbwina palongolo yaki.” ");
INSERT INTO xnj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Wu, Ibulahimu ayidakiwi kuvya mbwina palongolo ya Chapanga peavi akona kudumula jandu amala peamali kudumula jandu? Kwakona kudumuliwa jandu, na lepi peamalili kudumuliwa jandu. ");
INSERT INTO xnj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibulahimu adumwili jandu mwanakandahi, na kudumula jandu kwaki kwavili ulangisu kuvya Chapanga amyidikili kuvya mbwina ndava ya kusadika kwaki kwakona kudumula jandu. Hinu, Ibulahimu avi Dadi wa vandu voha vevakumsadika Chapanga, hati ngati vangadumula jandu, muni Chapanga avavalangila ubwina palongolo yaki. ");
INSERT INTO xnj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Mewawa Ibulahimu ndi Dadi wa vala vevadumwili jandu, nambu lepi ndava ya kudumula jandu ndu, ndi ndava vilanda njila yilayila ya sadika yeavi nayu Dadi witu Ibulahimu kwakona angadumula jandu. ");
INSERT INTO xnj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ndava muni chealagini Chapanga kuvya yati ukuuhala mulima yabweli lepi kwa Ibulahimu amala mu chiveleku chaki kwa kuyidakila Malagizu nambu mu njila ya kuvya mbwina palongolo ya Chapanga yeyibwela kwa sadika. ");
INSERT INTO xnj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ngati chealagazili Chapanga chipokelewa na vandu veviyidakila Malagizu ndu, hinu sadika chindu lepi. ");
INSERT INTO xnj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Malagizu gileta ligoga la Chapanga, malagizu ngati kawaka, ngakuvi lepi kudenya Malagizu. ");
INSERT INTO xnj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ndava yeniyo, chila chealagini Chapanga chibwela kwa sadika, genago geajovili gihuma mu ubwina waki, na ndi ulangisu wa kulangisa kuvya ndi chakaka kulagana kwenuko ndava ya viveleku vyaki, lepi ndava ya vala vevikamula Malagizu ndu, ndi mewawa kwa vevisadika ngati cheakitili Ibulahimu, mweavili Dadi witu tavoha. ");
INSERT INTO xnj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ngati Mayandiku Gamsopi chegijova, “Nikuhagwili uvyai Dadi wa makabila gamahele.” Mwene ndi Dadi witu palongolo ya Chapanga mweamsadiki. Chapanga mweakuvapela vevafwili wumi, na kwa amuli yaki, vindu vyangavya vivya. ");
INSERT INTO xnj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Hati payavili kawaka chindu chechamkitili Ibulahimu ahuvalila chila chealagini Chapanga, Ibulahimu amusadiki Chapanga na kulihuvalila lilaganu, ndi akavya dadi wa makabila goha. Ngati Mayandiku Gamsopi chegijova, “Chiveleku chaku yati chivya chamahele ngati ndondo.” ");
INSERT INTO xnj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ibulahimu avili mgogolo neju, miyaka yahegalili miya yimonga nambu mwene asadiki neju, hati ngati amanyili ihotola lepi kupata mwana ndava higa yaki yavili ngati yifwili, na mdala waki Sala avili ngaveleka, ");
INSERT INTO xnj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ibulahimu alekili lepi kulisadika lilaganu la Chapanga na alyungi lyungili lepi apatili makakala ndava ya sadika yaki, akamulumba Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Chakaka amanyili ngati Chapanga ihotola kugakita gala gealagini nayu. ");
INSERT INTO xnj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ndava ya sadika yaki, “Chapanga amvalangili Ibulahimu kuvya mundu mbwina palongolo yaki.” ");
INSERT INTO xnj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Malovi aga, “Avalangiwi ubwina palongolo ya Chapanga,” Gayandikwi lepi ndava ya Ibulahimu mwene, ");
INSERT INTO xnj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","genaga tayandikiwi tete vetivalangiwi vabwina palongolo ya Chapanga, tete vetikumsadika amuyukisi Yesu, BAMBU witu, kuhuma kwevafwili. ");
INSERT INTO xnj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Mwene awusiwi akomiwa ndava ya kubuda kwitu, kangi ayukili muni tivalangiwa kuvya tavabwina palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Hinu, ndava muni tikitiwi kuvya vabwina plongolo ya Chapanga kwa sadika, hinu tivii na uteke na Chapanga kwa njila ya BAMBU witu Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa njila ya sadika Yesu atikitili tiumanyai ubwina wa Chapanga, ndi hinu titama mwenumo. Na tete tihekelela mu huvalila yitu kuhanganila ukulu wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Lepi genago ndu, nambu mewawa tihekelela mang'ahiso gitu ndava timanyili mang'ahiso gileta usidindimala, ");
INSERT INTO xnj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","na usindimala wileta ukangamala na ukangamala wileta huvalila. ");
INSERT INTO xnj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Huvalila yeniyo yikutivinisa lepi mtima ndava Chapanga amali kuyisopa mu mitima yitu uganu waki kwa njila ya Mpungu Msopi mweatipelili tete. ");
INSERT INTO xnj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Lukumbi lwealuhagwili Chapanga pelwahikili petavili takona vangolongondi, Kilisitu afwili ndava ya tete tavahakau. ");
INSERT INTO xnj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ndava muni yinonopa mundu kufwa ndava ya mundu mbwina palongolo ya Chapanga, manya mundu ihotola kufwa ndava ya mundu mbwina. ");
INSERT INTO xnj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nambu Chapanga atimanyisi cheakutigana, muni lukumbi patavili takona mukumbudila Chapanga, Kilisitu afwili ndava yitu. ");
INSERT INTO xnj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ndava muni hinu tikitiwi kuvya vabwina palongolo ya Chapanga kwa ngasi ya Kilisitu, chakaka akutisangula kuhuma mu ligoga la Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Muni petavili tavamakoko, Chapanga atitepulanisi nayu kwa lifwa la Mwana waki. Ndava hinu titepulaniswi nayu chakaka yati tisanguliwa kwa wumi wa Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lepi genago ndu, mewawa tihekelela pa gala geagahengili Chapanga mu njila ya BAMBU witu Yesu Kilisitu ndi mweatitepulanisi na Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Kumbudila Chapanga kwayingili pamulima kwa njila ya mundu mmonga, na lifwa layingila ndava ya kubuda. Ndi lifwa lavabwelili vandu voha, ndava voha vakitili gahakau. ");
INSERT INTO xnj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kwakona Malagizu ga Musa kuvya, kubuda kwavili pamulima. Nambu kubuda kwavalangiwi lepi lukumbi Malagizu payavili lepi. ");
INSERT INTO xnj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nambu kuhuma lukumbi lwa Adamu mbaka lukumbi lwa Musa, lifwa lavatalalili vandu voha hati vala vevabudili lepi ngati cheabudili Adamu, kuleka kuyidakila gealagini na Chapanga. Adamu avili ngati ulangisu wa Kilisitu mweabwelili mwanakandahi. ");
INSERT INTO xnj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nambu kubuda kwa Adamu kuhotola lepi kuwanangiswa na ubwina wa Chapanga. Muni hati ngati vandu vamahele vafwili kwa kubuda kwa mundu mmonga, Chapanga avayonjokisi ubwina waki na njombi zaki zezadandasiki kwa vandu vamahele mu njila ya ubwina wa mundu mmonga ndi Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Njombi ya Chapanga yiwanangana lepi na kubuda kwa mundu mmonga. Muni mundu mmonga peabudili, Chapanga amhamwili, nambu pala pavabudili vandu vamahele Chapanga aletili njombi ya kuvakita vandu vavyai vabwina palongolo yaki. ");
INSERT INTO xnj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwa kubuda kwa mundu mmonga, lifwa latalalili mu njila ya mundu mwenuyo mmonga. Nambu chila cheakitili mundu mmonga yula, ndi Yesu Kilisitu, chivaha neju. Vandu voha vevipokela ubwina wa Chapanga na njombi ya kukitiwa vabwina palongolo ya Chapanga yati vitalalili wumi mu njila Yesu Kilisitu. ");
INSERT INTO xnj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Hinu ngati kubuda kwa mundu mmonga kukitili vandu voha kuhamuliwa mbunu, mewawa chindu chimonga chabwina kwa Chapanga chikuvakita vandu voha vakumganisa na kuvapela wumi. ");
INSERT INTO xnj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ndava muni kubela kuyidikila kwa mundu mmonga vandu vamahele vayingili mukubuda, nambu kuyidikila kwa mundu mmonga vandu vamahele vakitiwi vabwina palongolo ya Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagizu ga Musa yabwelili muni vandu vajimanyayi kuvya chavambudili Chapanga, nambu pala kumbudila Chapanga pepayonjokisi ndi, ubwina wa Chapanga wayonjokisiki neju. ");
INSERT INTO xnj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hinu, ngati kubuda chekwatalalili na kuleta lifwa, mewawa ubwina wa Chapanga yati ulongosi munjila ya kuvakita vandu vavyai vabwina palongolo yaki na kuvalongosa vapatayi wumi wa magono goha gangali mwishu mu njila ya Yesu Kilisitu BAMBU witu. ");
INSERT INTO xnj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tijova kyani hinu? Ndi tiyendelela kutama mukubuda muni ubwina wa Chapanga uyonjokeseka? ");
INSERT INTO xnj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Hati padebe! Petijova ndava ya makakala ga kumbudila Chapanga gegavi mugati yitu tete ngati tifwili, wu, tiyendelela wuli kutama mukubuda? ");
INSERT INTO xnj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Wu, mmanyi lepi ngati petabatiziwi tawungini na Kilisitu Yesu? Tabatiziwi na kuwungana nayu mu lifwa laki. ");
INSERT INTO xnj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Patabatiziwi tazikiwi pamonga nayu na kuwungana nayu mu lifwa laki, muni ngati Kilisitu cheayukili kuhuma lifwa kwa ukulu wa Dadi, mewawa na tete tihotola kutama muwumi wa mupya. ");
INSERT INTO xnj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Muni, ngati tete tiwungini nimwene mulifwa ngati cheafwili mwene, mewawa tiwungana nayu mkuyukiswa ngati cheayukili mwene. ");
INSERT INTO xnj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Timmanyili ngati matendu gitu ga kadeni gavambiwi pamsalaba pamonga na Kilisitu, muni makakala ga kubuda gegavi mu higa yitu yihalabiswai, na tikotoka kuvya kangi vavanda va kubuda. ");
INSERT INTO xnj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ndava muni, mundu akafwayi ivya lepi pahi ya makakala ga kumkubudila Chapanga gegihenga lihengu mugati yitu. ");
INSERT INTO xnj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Hinu, ngati tikafwai pamonga na Kilisitu, tisadika kuvya titama mewa pamonga na mwene. ");
INSERT INTO xnj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Muni, timanyili ngati Kilisitu amalili kuyuka kuhuma kufwa namwene ifwa lepi kangi, mewa lifwa nakumtalalila kavili. ");
INSERT INTO xnj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ndava afwili mala yimonga ndu, kubuda kuvi lepi na makakala kavili kwaki, na hinu mumi na itama pamonga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Mewawa na nyenye mjivalangayi mfwili kwa malovi ga makakala ga kumbudila Chapanga na mlongoswa lepi kangi na kubuda, nambu chemwitama mu kuwungana na Chapanga kwa njila ya Kilisitu Yesu. ");
INSERT INTO xnj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Hinu, kumbudila Chapanga kukoto kutalalila higa yinu yeyifwa, muni mkoto kuyidakila mnogo wa higa. ");
INSERT INTO xnj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mewawa mkoto kuwusa hati chiwungu chinu chimonga cha higa ndava ya kumbudila Chapanga. Pahala paki, mujiwusai mwavene kwa Chapanga ngati vandu vevayukiswi kuhuma lifwa, mujiwusa mwavene kwa Chapanga ndava ya lihengu la kumganisa mwene. ");
INSERT INTO xnj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Muni, kumbudila Chapanga kukoto kuvya na makakala panani yinu, muni nyenye mwilongoswa lepi na malagizu, nambu mwilongoswa na ubwina wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Hinu, tijova wuli? Wu, tiyendelela kukita uhakau ndava tilongoswa lepi na malagizu nambu tilongoswa na ubwina wa Chapanga? Hati padebe! ");
INSERT INTO xnj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mmanyi ngati mukajiwusayi mwavene ngati vavanda kumuyidakila mundu nunuyu, nyenye mwivya chakaka vavanda va mundu yula mwemukumuyidakila. Mkavyai vavanda va kumbudila Chapanga yati mmalikisila kulifwa, amala mkavya vavanda va kumuyidakila Chapanga yati mwivya vabwina palongolo yaki. ");
INSERT INTO xnj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Nambu asengusiwayi Chapanga ndava muni hati ngati mwavi vavanda va kumbudila Chapanga, nambu hinu mkamula kwa mtima woha uchakaka wa gala goha gegavi mu mawuliwu gemwapokili. ");
INSERT INTO xnj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nyenye pemwagomboliwi kuhuma uvanda wa kumbudila Chapanga, mukavya vavanda va kuhenga geigana Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Penapa nijova lepi malovi geginonopa nitumila malovi ga magono goha muni nyenye muhotola lepi kuniyelewa chenijova. Ngati kadeni chamwajiwusili kuvya vavanda va kubuda na uhakau, mewawa hinu mganikiwa mujiwusayi kuvya vavanda kuhenga gala geigana Chapanga muni munyambiswa. ");
INSERT INTO xnj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ndava muni pemwavili vavanda va kumbudila Chapanga mwakungiwi lepi kuhenga mambu gegakumganisa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Hinu mwapatili chiyonjokesu choki magono gala ndava ya mambu gala gemwakitili na hinu mwikola soni? Ndava gala gemwakitili gileta lifwa! ");
INSERT INTO xnj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nambu hinu mmalili kugombolewa kuhuma ku uvanda wa kumbudila Chapanga na muvi vavanda va Chapanga. Chiyonjokesu chemuvi nachu hinu Umsopi ndi wewileta wumi wa magono goha wangali mwishu. ");
INSERT INTO xnj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ndava muni luhuna lwa kumbudila Chapanga ndi lifwa, nambu njombi ya Chapanga ndi wumi wa magono goha gangali mwishu mukuwungana na Kilisitu Yesu, BAMBU witu. ");
INSERT INTO xnj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Valongo vangu, mmanyili chakaka genijova, muni nijova na vandu vevamanyili Malagizu. Malagizu yikumtalalila mundu peivya mumi. ");
INSERT INTO xnj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Luhumu, mdala peigegewa ikungwa, ikungiwa na mhilu lukumbi lwoha mgosi waki peivya mumi, nambu mgosi waki peifwa, ndi mdala mwenuyo ikungiwa lepi na Malagizu ga kugegana. ");
INSERT INTO xnj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ndi mdala mwenuyo akatama na mgosi yungi lukumbi mgosi waki akona mumi, mdala mweneuyo yati ikemelewa mkemi. Nambu ngati mgosi waki afwili, mdala mwenuyo ikungiwa lepi na Malagizu, hati akagegewayi na mgosi yungi, mdala mwenuyo ivya lepi mkemi. ");
INSERT INTO xnj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Mewawa valongo vangu, muvi lepi pahi ya Malagizu muni muwungini na higa yeniyi mana yaki ya Kilisitu peafwili na nyenye mwafwili pamonga nayu, hinu muvi vandu vaki mwenuyo mweayukiswi kuhuma lifwa, ndi timuhengela gabwina Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Muni, patatamili mukulongoswa na mnogo uhakau wemwavelekiwi nawu, mnogo wenuwo wakohakiwi na malagizu, zakitili lihengu muhiga yitu, na goha getahengili gamalakili mu lifwa. ");
INSERT INTO xnj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nambu hinu tilekekiswi kuhuma mu Malagizu gegatikungili ngati vavanda ndava tafwili pamonga na Kilisitu. Ndi timuhengela lihengu Chapanga mu njila ya mupya ya Mpungu Msopi lepi mu njila ya kadeni ya Malagizu gegayandikwi. ");
INSERT INTO xnj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Hinu tijova wuli? Wu, Malagizu ndi kumbudila Chapanga? Hati padebe! Nambu changali Malagizu, nene nganimanyi lepi kumbudila chapanga ndi chindu kiki. Muni Malagizu pegajovili “Ukoto kunogela, chindu cha muyaku,” Nganimanyi lepi kunogela ndi uhakau. ");
INSERT INTO xnj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mu kuhengela Mihilu yeniyo, kumbudila Chapanga kupata fwasi ya kuyimusa mnogelu uhakau wowoha mugati yangu. Muni, changali Malagizu kubuda kufwili. ");
INSERT INTO xnj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kadeni navili mumi changa mihilu nambu malagizu pagabwelili, kumbudila Chapanga kwatumbwili kuhenga lihengu muwumi wangu na nene navi ngati nifwili, ");
INSERT INTO xnj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Mihilu yeniyo yaganikiwi kuleta wumi, nambu kwa nene galetili lifwa. ");
INSERT INTO xnj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Muni kubuda kwapatili fwasi kwa mbesu wenuwo yanikongili na kunikoma. ");
INSERT INTO xnj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Hinu, Malagizu ga Musa ndi gamsopi, na mihilu ya msopi, gakumganisa Chapanga na yabwina. ");
INSERT INTO xnj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Wu, chindu chabwina chiniletili lifwa langu? Hati padebe! Yahengiki chenicho, muni kumbudila chapanga, yimanyikana ngati kumbudila Chapanga, mu njila ya ubwina yeyikuniletela lifwa langu. Hinu kumbudila Chapanga mu njila ya Malagizu galangisi kuvya chindu chihakau neju. ");
INSERT INTO xnj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Timanyili kuvya Malagizu ndi ga Chimpungu, nambu nene namundu wa chimpungu lepi, nene niguliswi ngati mvanda mu kumbudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nimanyili lepi chenikita, muni gala genigana kukita, nikita lepi, nambu gala genikugahakali ndi genikugakita. ");
INSERT INTO xnj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Nikahengayi gala genikugagana lepi kuhenga, yeniyi yilangisa kuvya niyidakila Malagizu gabwina. ");
INSERT INTO xnj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Hinu, lepi namwene mwenikita chindu chenichi, nambu kumbudila Chapanga kwekutama mugati yangu. ");
INSERT INTO xnj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nimanyili kuvya kawaka chabwina chochoha mugati yangu, mu mnogo wangu uhakau wenivelekiwi nawu. Ndava muni, nigana kukita gabwina nambu nihotola lepi. ");
INSERT INTO xnj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ndava muni, nikita lepi labwina lila lenigana, nambu nikita gala gahakau nangagana. ");
INSERT INTO xnj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ngati nikita gala genigana lepi kukita, yeniyi yilangisa kuvya nene lepi mwenikita ago ndi kubuda kwekuvili mugati yangu ndi kukita genago. ");
INSERT INTO xnj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Hinu, niliwene lijambu lenili lihenga lihengu mugati yangu, penigana kukita gabwina, nambu nikujikolela lihakau ndi lenihagula kukita. ");
INSERT INTO xnj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Mugati mwa mtima wangu nihekelela Malagizu ga Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Nambu nilola kuvya Malagizu wungi ukita lihengu muhiga yangu, mhilu weulekengana na wula weuyidikiwa na luhala lwangu. Muhilu weunikita nivyayi mkungiwa wa malagizu ga kubuda kwekukita lihengu muhiga yangu. ");
INSERT INTO xnj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Namuyinu nene! Yani mweakunisangula kuhuma mulifwa lwenipelekwa na higa yeniyi? ");
INSERT INTO xnj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Sengusa kwa Chapanga mweakunigombola munjila ya Yesu Kilisitu BAMBU witu! Chenichi ndi chenivili, namwene, kwa luhala lwangu namvanda wa Malagizu ga Chapanga, nambu kwa mnogo uhakau wenivelekiwi nawu ya kumbudila Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ndi hinu, kawaka kuhamuliwa mbunu kwa vala vevawungini na Kilisitu Yesu. ");
INSERT INTO xnj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Muni, mukuwungana na Yesu Kilisitu, Malagizu ga Mpungu Msopi mweileta wumi kwa yinigombwili kuhuma mu malagizu ga kumbudila Chapanga na lifwa. ");
INSERT INTO xnj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Chapanga akitili lijambu lila langahotoleka kuhengeka na Muhilu ndava ya mnogo uhakau wetavelekiwi nawu, wewayikitili Malagizu genago kuvya ganyong'onyo. Chapanga amtumili Mwana waki ngamwene mweavi na higa ngati tete vetibuda, muni ahukumwayi kubuda, na kwa higa yaki yeniyo akakomekesa kubuda. ");
INSERT INTO xnj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Chapanga akitili chenichi muni gala gegiganikiwa na Malagizu ga Musa gahengekayi mugati yitu neju, tete vetitama kwa makakala ga Mpungu Msopi ndi lepi kwa makakala ga mnogo uhakau wetivelekiwi nawu. ");
INSERT INTO xnj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Muni, vala vevitama kulandana na mnogo uhakau wa wakuvelekewa nawu maholo gavi gitalaliwa na mnogo uhakau wenuwo. Nambu vala vevitama kulandana na uganu wa Mpungu Msopi, vitalaliwa na gala geigana Mpungu Msopi, ");
INSERT INTO xnj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","maholo gegilongoswa na mnogo uhakau wakuvelekewa nawu weyileta lifwa, nambu uholalelu wewilongoswa na Mpungu Msopi uleta wumi na uteke. ");
INSERT INTO xnj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Mundu, mweitalaliwa na maholo ga mnogo uhakau weavelikwi nawu ivya likoko wa Chapanga. Ndava muni ilanda lepi Malagizu ga Chapanga mewa akuyiyidakila lepi. ");
INSERT INTO xnj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Vandu vevilongoswa na mnogo uhakau wa higa yeavelekiwi nayu nakuhotola kumganisa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nambu nyenye Mpungu wa Chapanga akatama mugati yinu yati mwilongoswa lepi na mnogo uhakau wa higa weavelekiwi nawu nambu mwilongoswa na mpungu. Ngati mundu yoyoha avi lepi na mpungu wa Kilisitu, mwenuyo lepi wa Kilisitu, ");
INSERT INTO xnj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nambu ngati Kilisitu avili mugati yinu, mpungu akuvapela wumi muni nyenye muvalangiwi ubwina palongolo ya Chapanga. Hati ngati higa yinu yati yifwa ndava ya kubuda nyenye mwakona mumi. ");
INSERT INTO xnj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ngati Mpungu wa Chapanga mweamuyukisi Yesu kuhuma mulifwa itama mugati yinu, ndi mwenuyo mwamuyukisi Kilisitu mewawa yati akuiyukisa higa yinu yeyifwa. Yati ikita chenicho mu njila ya Mpungu waki wewitama mugati yinu. ");
INSERT INTO xnj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Hinu ndi, valongo vangu, tivii na lihengu, tiganikiwa lepi kutama ngati mnogo witu uhakau wetivelekiwi nawu chewigana titama. ");
INSERT INTO xnj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ndava muni, mukatama ngati higa cheyigana chakaka yati mwifwa. Nambu ngati mkagakoma matendu ginu gahakau mu njila ya Mpungu Msopi, yati mwivya muwumi. ");
INSERT INTO xnj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ndava muni voha vevilongoswa na Mpungu wa Chapanga ndi vana va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ndava muni, mwampokili lepi Mpungu mweakuvakita vavanda kangi mweakuvayogofya, nambu mwampokili Mpungu mweakuvakita vana va Chapanga. Ndi tikumkemela Chapanga “Aba,” Ndi mana yaki “Dadi!” ");
INSERT INTO xnj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Mpungu wa Chapanga mwene iwungana na mpungu witu na ijova kuvya chakaka tete ndi tavana va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Hinu, yikavya tete tavana vaki, ndi vahali va Chapanga yati tipokela vindu vyeativikili Chapanga pamonga na Kilisitu, muni tikang'aikayi pamonga nayu mewawa yati tihanganila nayu muukulu waki. ");
INSERT INTO xnj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nilola kuvya mang'ahiso ga lukumbi ulu lwa hinu katu chindu lepi ngati tiwanangisa na ukulu weugubukuliwa kwitu. ");
INSERT INTO xnj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Viumbi vyoha vilindila kwa mnogo uvaha Chapanga avamanyisa vana vaki. ");
INSERT INTO xnj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ndava muni, viumbi vyoha vyabadiliswi na kuvya vyangali mana, lepi kwa kugana vyene nambu vyakitiwi kwa uganu wa Chapanga, Hati naha livii huvalila, ");
INSERT INTO xnj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","muni viumbi na vyene yati vilekekeswa kuhuma mu uvanda wa kuhalibika, na viyingila muukulu wa kulekewa kwa vana va Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Muni timanyili mbaka hinu, viumbi vyoha ving'ita kwa mvinisu ngati lipyanda la kuveleka mwana. ");
INSERT INTO xnj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nambu lepi viumbi vyenivyo ndu, hati tete vetivili na Mpungu mwenuyo, mweavili njombi ya kutumbula ya Chapanga, mewawa cha mugati ting'ita kwa lipyanda, tilindila kwa mnogo ligono lila Chapanga leakutigubukula tete kuvya vana vaki chakaka na kuying'anamusa higa zitu kuvya zamupya. ");
INSERT INTO xnj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Muni tisanguliwi nambu takona tivii na huvalila yeniyi. Nambu chindu chechihuvaliwi chakalolekana, lepi huvalila kavili. Ndi mundu yoki ihuvalila chindu chila cheavili nachu? ");
INSERT INTO xnj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ngati tikuchihuvalila chila tangachiwona, ndi tikuchilindila kwa kusindimala. ");
INSERT INTO xnj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mewawa, na mwene Mpungu Msopi akutitangatila mu kulenda kwitu. Muni timanyi lepi cheyiganikiwa tiyupayi, na Mpungu mwene akutiyupila tete kwa Chapanga kwa kung'ita kwa malovi gangajoveka. ");
INSERT INTO xnj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ni mwene Chapanga mweilola mbaka mumitima ya vandu, amanyili uholalelu lwa Mpungu, muni Mpungu akuvayupila vandu va Chapanga, kulandana na uganisu wa Chapanga. ");
INSERT INTO xnj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Chakaka timanyili mu mambu goha Chapanga ihenga lihengu kwa chiyonjokesu cha vala vevakumgana, vala vevakemeliwi kuhenga gala geigana mwene gahengekayi. ");
INSERT INTO xnj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Muni avo Chapanga avamanyili kutumbula kadeni, ndi avahagwili vawananganayi na Mwana waki, muni mwana avyayi wa kutumbula pagati ya valongo vamahele. ");
INSERT INTO xnj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ndi, vala Chapanga avahagwili, mewawa avakemili, na venavo veavakemili vabwina palongolo yaki na venavo vevakitili vabwina ndi akahanganila nawu muukulu waki. ");
INSERT INTO xnj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Pa genago goha, tijovayi kyani kangi? Ngati Chapanga avili upandi witu, yani mweihotola kutidivalila? ");
INSERT INTO xnj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Chapanga amuhengili lepi lipyana hati mwana waki, ndi amuwusili ndava ya tavoha tete. Wu, ngati atipelili mwana waki wu, akutipela lepi waka mambu goha pamonga nayu? ");
INSERT INTO xnj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yani mweakuvatakila vandu vahaguliwa va Chapanga? Chapanga mwene akuvawusila kuhoka! ");
INSERT INTO xnj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yani mwakuvahukumwa? Lepi Kilisitu Yesu! Muni Kilisitu Yesu ndi mweafwili, neju pa genago ayukili kuhuma lifwa na itama upandi wa kulyela wa Chapanga. Mwene yati akutiyupila kwa Chapanga! ");
INSERT INTO xnj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35",