﻿USE sofia;
DROP TABLE IF EXISTS sofia.xla_vpl;
CREATE TABLE xla_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xla_vpl WRITE;
INSERT INTO xla_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kotiyamale sitali dla Godtapo ta꞉lamo mate pepele di mate mimita꞉piyo. ");
INSERT INTO xla_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Epame oloma edla ta꞉lamota ala ya꞉ mila꞉pi pohimilalo halemama koko pa꞉le halaiyo. Epalati kaula patoye amtuwaleta bodepo ellati God ya꞉ Sokota yú di dla sela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Epalati Godta epo atlaiyo, “Hela꞉dleye hallepe,” diyo. Epalati hela꞉dleta ma-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Epame Godta natili dla hela꞉dleta ka꞉pi halaiyo. Epalati ya꞉tapo amtuwale mate hela꞉dle mate duka gladepame amtuwale ma meyelo himi epo hela꞉dle ma meyelo himi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Epame Godtapo hela꞉dleye semama alila diyo, epame amtuwaleye semama utula꞉la diyo. Epo itapu alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Epame Godta epo atlaiyo, “Yú duka gladlalo alisisita hallepe,” diyo. Epalati yú duka gladlalo alisisita ma-halaiyo. Epapalati Godtapo yú duka gladlalo alisisi iye semama omapla diyo. Epedeme Godtapo yú duka glademama yú semeye omapla di dla hetlati asiyama semeye ta꞉lamo dla pomeliyo. Epame namba 2 alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Epame Godta ma epo atlaiyo, “Ta꞉la sekelleta woyamama ta꞉la ma meyelo hallepe, epalati yú ma meyelo hallepe,” diyo. Epalati koko eta ma-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Epalati Godtapo ta꞉la sekelle semama ta꞉lamo diyo. Epame yú hatlo alupo pamelleye semama kaula diyo. Epame Godta koko e natipame ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Epedeme Godta ma epo atlaiyo, “Ta꞉lamo dla alisisi hapuloma mila꞉pi meyelope meyelope dletapo matelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Epalati alisisi mila꞉pi meyelope meyelope dletapo mataiyo. Epame Godta ya꞉ta mimita꞉pele alisisi i tlapame ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Epame namba 3 alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Epame Godta ma epo atlaiyo, “Omapla di dla hela꞉dlalo alisisita ha꞉ha꞉lepe. Yia꞉tapo alila mate epo utula꞉la mate duka gladlalo ha꞉ha꞉lepe. Epame yia꞉tapo alilata pololemta mate epo sokomokota pololemta mate imalalo ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","“Epalati hela꞉dle hapilalo alisisi ewolotapo omapla di dla popa꞉mama ta꞉lamo hema hela꞉dle hapimha꞉ha꞉lepe,” diyo. Epalati koko eta mo-woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Epedeme Godtapo hela꞉dle alisisi patoto dapiyamte mimita꞉pmama sikemte itiyamale mate hela꞉dlalo alisisiye alila dla hela꞉demhallepo depame himiyo. Epame pase sikemte itiyamale mate hela꞉dlalo alisisiye utula꞉la dla hela꞉demhallepo depame himiyo. Ya꞉ ma epame tamili mimita꞉piyo. ");
INSERT INTO xla_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Godtapo alisisi hapuloma iye omapla di dla ipila꞉iyo, yia꞉tapo ta꞉lamoye hela꞉dle hapimha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Epame yia꞉tapo alila mate epo utula꞉la mate omha꞉ha꞉mama amtuwale mate hela꞉dle mate duka glademha꞉ha꞉lepo depame. Epame Godta koko e natipame ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Epame namba 4 alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Epalati Godta ma epo atlaiyo, “Yú dulu dla pasakalo siyamalalo alisisitapo pasatlepe. Epame teatapo di haliyamale hema hoholiyemsiyamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Epame Godtapo amalo hapuloma mate epo alinepi opi patoto yú dulu dla ha꞉ha꞉lalo hapuloma mate epo tea hapuloma mate mimita꞉piyo. Epame Godta koko e natipame ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Epame yia꞉ watle epo atlaiyo, “Wua꞉ yú dulu dla yimlala usulumha꞉ha꞉mama kaula patoye pasatlepe. Epalati ta꞉lamo di hema teatapo yimlala usulumha꞉ha꞉mama teata pasatlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Epame namba 5 alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Epame Godta ma epo atlaiyo, “Ta꞉lamo hema alinepi mila꞉pi meyelope meyelope dle halo mate epo yowo mateta pasatlepe. Epame ilama mape pasatlepe,” diyo. Epalati koko eta ma-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Epame Godtapo alinepi hapuloma mimita꞉pame ma alinepi e tlapame ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Epame Godta ma epo atlaiyo, “Di matle oplami di mila꞉pi sepele mita꞉plowa, ya꞉tapo amalo hapuloma mate epo tea hapuloma mate epo alinepi hapuloma halo mate epo yowo mate omhallepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Epame Godtapo oplami ya꞉ mila꞉pi sepeleye mita꞉pmama oplami mate a꞉ya mate mimita꞉piyo. ");
INSERT INTO xla_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Godta yia꞉ watle epo atlaiyo, “Wua꞉ yimlala isukumama ta꞉lamoye pasatlepe. Epame wua꞉tapo ta꞉lamo omha꞉ha꞉mama amalo mate epo tea mate epo alinepi hapuloma mate omha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Na꞉tapo wua꞉ta dlowe alisisi opi ta꞉la dulu dla milimalalo mate epo dali di dla dlomoko mila꞉pi meyelope meyelope dle mate ma-hapiwapo, wua꞉tapo demha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Amasiyama alinepi hapuloma mate epo tea hapuloma mate dla na꞉tapo yia꞉ta dlowe alisisi osamokolo mate epo dali upa mate ma-hapiwapo,” diyo. Epalati koko eta me-elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Godtapo ya꞉ta mimita꞉pele alisisi hapuloma i tlapame pta ka꞉pi diyo. Epame namba 6 alilata ma-tlati ma alila amko haleta ma-alaliyo. ");
INSERT INTO xla_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ta꞉lamo mate epo pepele di mate epo alisisi hapuloma dulu edla ha꞉ha꞉lalo mate mimita꞉mhalaleye medla puame gudiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Epame alila 7 umuluwedeme hallati Godtapo ya꞉ oko hapulomaye mo-pokadiyo. Epame namba 7 alila dla ya꞉tapo hedepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ya꞉tapo hedepo polomama namba 7 alila eye aiyalma diyo. Adipalati, ya꞉tapo alisisi hapuloma mimita꞉mhalale okota gudlati alila hema hedepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Epedeme ta꞉lamo pato mate epo pepele di mateye ipo mimita꞉piyo. Lod Godtapo ta꞉lamo pato mita꞉pele oloma edla alisisi haletapo ta꞉lamo edla ala pomatlalo halaiyo. Adipalati, Lod Godtapo tiyota hellowe kokoye yipta pohimiyo. Epame ta꞉la muwalepame alisisi emalalo oplamiye ala pohalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amasiyama matale yútapo ta꞉la dulu tle matame ta꞉la dla delikiyele hamimdiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Epalati oloma edla Lod Godta ta꞉la polapo oplami mita꞉piyo. Epame pasakalo halemhala hedleye ya꞉ mu opokoko dla hamilati oplamitapo pasakalo hallowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Epame Lod Godta Iden mo dla osalo himpame edla ya꞉ta mita꞉pele oplamiye pameliyo. Osalo eye salita matlalo tiyama dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Epame ya꞉tapo dali ka꞉ka꞉dleta osalo edla matamama dlomoko dlalo milimilipe diyo. Amasiyama osalo duka edla pasakalo hamilalo dlomoko dali ma halaiyo. Epalati dlomoko dali haleye ka꞉dle malamale hamilalo mate epo batalimale malamale hamilalo mate ma me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Epalati alomata Iden mo dulu tle yemama osalo dulu dla emale alisisita woloma ka꞉pi matlepo depame ta꞉la dla delikiyele hamimdiyo. Epame aloma ita ma Iden mo tla꞉myemama ma aloma dapiyamte dapiyamte dle tatlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ka꞉yapa tladle aloma hiye Pisonpo. Aloma itapo mo pato hale Habila mo duka tle yapo. ");
INSERT INTO xla_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mo edla gold ewala ka꞉dle mate epo ullu ka꞉dle dakopala mate epo ewala ka꞉ka꞉dle opi mate wokasepo elapo. ");
INSERT INTO xla_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Aloma hale tladle hiye Gihonpo. Gihon aloma itapo mo pato hale Kus duka tle yapo. ");
INSERT INTO xla_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Epame matle aloma hale tladle hiye Tigilispo. Aloma itapo Asul mo tle salita matlalo tiyama dla yapo. Epalati matle aloma hale tladleye Yupalatespo. ");
INSERT INTO xla_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Epame Lod Godtapo oplamiye Iden osalo dulu dla pameliyo, ya꞉tapo osalo eye omhalemama oko hamhallepo depame. ");
INSERT INTO xla_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Epame ya꞉ watle epo atlaiyo, “Osalo dulu hema dlomoko dali hapulomaye me-demhallepe. ");
INSERT INTO xla_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Amasiyama wa꞉ ka꞉dle malamale mate batalimale malamale mate hapilalo dlomoko dali dla dlomoko hale podoahame dlowa. Adipalati, wa꞉ dlomoko e doahame delepiye, wa꞉ oloma medla polope,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Epedeme Lod Godta ma epo atlaiyo, “Poka꞉dena, oplamitapo meyelo halloweye. Na꞉ matle ka꞉dle gadlalo ya꞉ mate ala꞉leye mita꞉plowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Epame ya꞉tapo ta꞉la polapame alinepi hapuloma mate epo tea hapuloma mate mo-mimita꞉piyo. Epame oplami hala dla elempuwaiyo, ya꞉tapo yia꞉ hi hapilipo depame. Epalati alinepi hapulomaye oplamita yia꞉ hiye halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Oplamitapo tea hapuloma mate epo alinepi hapuloma mate hi halopimtale oloma edla ya꞉ gadlowe ya꞉ mate ala꞉le ponatiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Epalati Lod Godtapo oplami watle ellele pato hamilati oplamitapo sikemte elaiyo. Ya꞉ ala sikemte me-ellati Godta ya꞉ tiyape elo haleye holahapame mamisika꞉ godiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Epame tiyape elo e mate a꞉ya mita꞉pame ma oplami hala dla sempuaiyo. ");
INSERT INTO xla_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Epalati oplamita epo atlaiyo, “Wata ma-natima, ya꞉ye na꞉ mate ala꞉na. Ya꞉ye na꞉ elo tle epo na꞉ mo tle mita꞉pelepo. Epedeme ka꞉dena, ya꞉ hiye a꞉ya dlepe. Adipalati, ya꞉ye oplami moto tle holahapame mita꞉pelepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Epapele tle oplamitapo ya꞉ a mate epo ya꞉ wai mate salepo tame ma ya꞉ a꞉ya mate hatlope depo hallepe. Epame yia꞉ta madipata ma moto hatlope depo ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Oplami mate a꞉ya mate madipatata tidali siyapo ha꞉ha꞉iyo. Amasiyama yia꞉ dla kapala sisillita pe-elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Lod Godta mimita꞉pele alinepi hapuloma dulu dla ilamata ya꞉mkale isikimi elemala natilowe malamaleta ya꞉ dla sikemte pato halaiyo. Epedeme alila haleta ilamata puame a꞉ya watle epo atlaiyo, “Godta dlomoko dali hapuloma hema dlomoko demiyo duwaye ikadepeta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Epalati asiyama a꞉yata ya꞉ watle epo atlaiyo, “Godta di watle atlemama dlomoko hapuloma me-dlomha꞉ha꞉lepe duwa. ");
INSERT INTO xla_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Amasiyama hatlo osalo duka dla hala dlomoko dali tlo demiyo duwa. Adipalati, dita dlomoko e doahapo delepiye, dia꞉ye pallipe duwa.” ");
INSERT INTO xla_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Amasiyama ilamata a꞉ya watle epo atlaiyo, “Yu eye pomikadepe. E isikimi atluwapo. Wua꞉ popalliwa. ");
INSERT INTO xla_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Godtapo epo atluwapo, adipalati, ya꞉malamana, wua꞉ta dlomoko e delepiye, wua꞉ ma God some ha꞉ha꞉lepe depame. Epame ka꞉ka꞉dle koko mate bobtalimale koko mate sikemte malastepo ha꞉ha꞉lepe depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A꞉yatapo ilama yu dalepo medla tulupame ma dlomoko ka꞉dle natipo doahame dlowe sikemte solotamaiyo. Epame dlomoko e dele koko tle ka꞉dle malamale halowe ma solotamaiyo. A꞉yatapo epapele malamale tle dlomokoye dolalipo depame ma dlomoko haleye ya꞉wolali watle hamiyo. Epalati ya꞉wolali mape dlomoko eye hame deiyo. ");
INSERT INTO xla_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yia꞉ta madipata dlomoko dele alotle yia꞉ edla yia꞉skamu malanatiyo, yia꞉ta tidali siyapo siyamale kokoye. Epalati yia꞉tapo pigi dali upa kolepame yia꞉skamu eyamsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tamila꞉la oloma edla yia꞉tapo Lod Godta osalo dulu dla sela꞉lati daliyo. Epalati yia꞉tapo ya꞉ tle hemele potame dali upa dulu dla haohaodemsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Amasiyama Lod Godta oplami sisilapame epo atlaiyo, “Wa꞉ hadima halema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Epalati asiyama oplamita epo atlaiyo, “Na꞉ wa꞉ta osalo dulu dla sela꞉la dalepame wota꞉mama hemele hema puame haodepo poloma. Adipalati, na꞉ye tidali siyapo halema,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Asiyama Godta epo atlaiyo, “Anta wa꞉ta tidali siyapo hala kokoye wa꞉ watle imo? Pona꞉malamana, wa꞉ na꞉ta dlomoko demiyo duwaye e doahame deyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Epalati asiyama oplamita epo atlaiyo, “Wa꞉ta na꞉ watle a꞉ya hamiwatapo na꞉ watle dlomoko eye hamilati na꞉ ma eye de,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Epalati asiyama Lod Godta a꞉ya watle epo atlaiyo, “Wa꞉ adipalati koko iye hao?” diyo. Epalati asiyama a꞉yata ma epo atlaiyo, “Ilamata na꞉ye elemala natilati na꞉ dlomoko eye doahame de,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Epalati asiyama Lod Godta ilama watle epo atlaiyo, “Wa꞉ Godta kasilamale dulu dla halemama alinepi hapuloma dulu dla hatlo wa꞉ tlope wa꞉ kokota ta꞉la dla olalimsela꞉mama isikimi apupu mate demsela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Epame wa꞉ mate epo a꞉ya mate dla elle kokota elemama duka gladleta ellepe. Epame elle koko hatlo meta ma wa꞉ mamadulo mate epo a꞉ya ya꞉ mamadulo mate dla ellepe. Epammama wa꞉tapo a꞉ya ya꞉ mamadulo hale hete maku dla yellati ma asiyama ya꞉tapo wa꞉ dokopalaye supulastelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Epame Godta a꞉ya watle epo atlaiyo, “Wa꞉ta owayemala hammama wotiyalle haloweye na꞉ta ma pato dlowepo. Epalati wa꞉tapo wotiyalle mate owayimlala hohomhallepe. Amasiyama epapele tlope wa꞉ dla ala wa꞉wolali sikemte solotamale patota me-ellepe. Epalati ya꞉tapo wa꞉ omhallalo hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","Epame Godta matle A꞉dam watle epo atlaiyo, “Wa꞉ mape wa꞉ a꞉ya yu dalepame na꞉ta dlomoko demiyo dle dlomokoye delepo. Epedeme wa꞉ta dlomoko dele koko tle na꞉tapo ta꞉laye batalipo mellowepo. Epedeme dlowe alisisita isikimi meyelo pomatlowa, amasiyama osamokolo mate epo tuwale mateta matelepe. Epedeme wa꞉ dlowe alisisi dlowedeme mowolo oko pato hamama ekukulli mate oko hapo de demhallepe. Epapedeme wa꞉ oko pato metlo me-hamhalemama wa꞉ta polowe sukulu dla malatelepe. Epedeme wa꞉ta polopiye, wa꞉ motoye matle ta꞉la yielepe. Adipalati, wa꞉ motoye ta꞉la mate mita꞉puwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","A꞉damtapo ya꞉llu hi semama Ib diyo. Adipalati, ya꞉ye opa hapuloma yia꞉ waipo. ");
INSERT INTO xla_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Epame Lod Godtapo alinepi kapalata tluka mimita꞉pame A꞉dam mate Ib mate dla didiyemeliyo. ");
INSERT INTO xla_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Epame ya꞉ta ma epo atlaiyo, “Watapo oplamiye dia꞉ sepele some halemama ka꞉ka꞉dle koko mate batalimale koko mate malanatiloweye me-ya꞉malamana. Epapedeme di matle ya꞉ watle pasakalo hapimhallalo dlomoko dali tle dlomoko haleye podoahame dene dlowa, ya꞉tapo kokó pohallalo wekelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Epedeme Lod Godta yia꞉ye Iden osalo dulu tle alikili dla dodolomsaliyo, yia꞉tapo mo edla osalo hatitimha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Epame Godtapo banakaka soye Iden osalo dla tulalo api dla ipila꞉mama aipa꞉ya dlapa aloweli some tleka꞉mama sikemte usiyemale ma medla hitomeliyo, opata matle pasakalo hapimhallalo dlomoko dali tou dla tulala depame. ");
INSERT INTO xla_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Alotle A꞉dam mate Ib mate ha꞉ha꞉le dulu dla Ibtapo mopapo polopame maseyemala hamaiyo, ya꞉ hiye Kein. Epame Ibta epo atlaiyo, “Godta gadle tle na꞉tapo maseyemala ma-hamalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Epame alotle ma maseyemala hale hamaiyo, ya꞉ hiye Eibol. Epame yia꞉ta madipata dulu dla Eiboltapo aliya halo omhalemdiyo, epalati ya꞉ bapa Keintapo alisisi emalalo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Alila haleta Keintapo ya꞉ osalo dla alisisi opi hauwalepame God dla namkale dle halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Epalati Eiboltapo ya꞉ aliya halota ka꞉yapa yemala usulliye yumpame mo ka꞉dle tlope God dla namkale dle hamiyo. Epalati Godtapo Eibolta namkale dle alisisi hampuale natipame ka꞉dena demama siyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Amasiyama Keinta namkale dle alisisi halopo pualeye natipame posiyeiyo. Epalati Keintapo sikemte siyaladiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Epalati Godta Kein watle epo atlaiyo, “Wa꞉ adipalati siyaladema꞉? ");
INSERT INTO xla_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Wa꞉ta woloma ka꞉dle koko tlo hamatiye, eta na꞉tapo wa꞉ta namkale dle alisisi hamili dla siyelemla. Amasiyama wa꞉ poka꞉dle koko hamhallepiye, wa꞉ batalimaletapo wa꞉ye dokopala depo hallowedeme ma-dinapopo wa꞉ye omhalapo. Amasiyama koko eta wa꞉ dla woyamalala depame, wa꞉ itiyamale mate halane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Alotle Keintapo ya꞉ ei Eibol watle epo atlaiyo, “Di moku dla isikimi hohola꞉mtlowa,” diyo. Yia꞉ epo ma-tame moku dla ha꞉ha꞉mama Keintapo ya꞉ ei Eibol hampame yumiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Epalati alotle Godta Kein watle epo atlaiyo, “Wa꞉ ei Eibol da꞉?” diyo. Epalati asiyama Keinta epo atlaiyo, “Na꞉ pona꞉malamana. Na꞉ta na꞉ ei motoye omhalemdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Epalati Godta epo atlaiyo, “Wa꞉ adipapalati poka꞉dle koko i hao? Wa꞉ ei omalitapo ta꞉la tle na꞉ dla sisilamhalapo. ");
INSERT INTO xla_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Epedeme wa꞉ na꞉ta kasilamale dulu dla halemama matle ta꞉la muwalepo alisisi pe-emolowa. Adipalati, ta꞉la edla wa꞉tapo wa꞉ ei omaliye olostauwapo. ");
INSERT INTO xla_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Epapedeme wa꞉ matle alisisi emelepiye, wa꞉ alisisita woloma pomatlowa. Epame wa꞉ woloma mo hatlo dla pohallowa. Amasiyama wa꞉ ta꞉lamo pato hema isikimi koko pa꞉le asepe oplami some holomhallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Epalati asiyama Keinta God watle epo atlaiyo, “Na꞉ta na꞉ batalimale asiyama dla wotiyalle dulu hema halloweye pasakalo pta kokalena. ");
INSERT INTO xla_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Adipalati, wa꞉tapo na꞉ye mo itle epo wa꞉ mila꞉pi tle pateka꞉mu dla tane depo. Epapedeme na꞉tapo ta꞉lamo hema asepe oplami some mo pa꞉le isikimi duka dla holomhallepe. Epapele dulu dla oplami antapo na꞉ umulupiye, ya꞉tapo na꞉ye yumilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Amasiyama Godta Kein watle epo atlaiyo, “Hao, oplami haletapo wa꞉ye poyumuluwa. Amasiyama oplami antapo wa꞉ye yumilipiye, asiyama na꞉tapo ya꞉ opa 7ye potimolowepo,” diyo. Epame Godtapo Kein dla ulu himiyo, opata ya꞉ natipame poyumulalo wekelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Epalati Keinta God mila꞉pi tle ma teletamama Nod mo dla halla taiyo. Mo iye Iden osalo tle ma salita matlalo tiyama dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein edla tame hallati ya꞉lluta mopapo polopame maseyemala hamaiyo, ya꞉ hiye Enok. Oloma edla Keinye mo amko kestamhalaiyo. Epame mo amko e mape semama Enok diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Epapedeme Enok yamiye Ilad, epalati Ilad yamiye Mehuyael, epalati Mehuyael yamiye Metusael, epalati Metusael yamiye Lamek. ");
INSERT INTO xla_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Epalati Lamektapo wola꞉ dapiyamte halomaiyo. A꞉ya hale hiye Ada, epo a꞉ya hale hiye Sila. ");
INSERT INTO xla_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ya꞉ a꞉ya hale Adatapo maseyemala hamaiyo, ya꞉ hiye Yabal. Yabaltapo ya꞉ tatle ka꞉yapa kimtimsela꞉mama halo omhallowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Epalati Yabal ya꞉ ei hiye Yubal. Yubaltapo ya꞉ tatle ka꞉yapa woiyo mate epo pitikako mate sala dodolomalalo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Epalati Lamek ya꞉llu hale Silatapo maseyemala hamaiyo, ya꞉ hiye Tubal Kein. Ya꞉tapo ka꞉yapa oli mate epo blons ewala mate aipa꞉yaye mimita꞉plowe kotiyamaiyo. Ya꞉ nanaye Namapo. ");
INSERT INTO xla_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Alila haleta Lamektapo ya꞉ wola꞉ dapiyamte watle epo atlaiyo, “Wua꞉ na꞉ yu daliya. Kipiliyemala haletapo na꞉ heyulati na꞉ta asiyama ya꞉ye mo-yumi. ");
INSERT INTO xla_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Epele dulu dla oplami haleta di mama pato Kein yumili hallepiye, asiyama ya꞉ opa 7 ma potimelepe. Amasiyama oplami antapo na꞉ye yumilipiye, asiyama 77 soye potimelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","A꞉dam ya꞉llu Ibtapo matle maseyemala hale hamaiyo, ya꞉ hiye Set. Epalati Ibtapo epo atlaiyo, “Godtapo na꞉ watle maseyemala hale, Keinta yumili Eibol mo dla halloweye ma-hamame ilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Epame Set yami Enosta halale oloma edla opatapo God dla inoma sumama ya꞉ hi di dla ta꞉dlowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Godtapo oplami mita꞉mama ikadepe ya꞉ sepele mita꞉piyo. Epame ya꞉ sepele mimita꞉mama oplami mate a꞉ya mate mimita꞉piyo. Epame yia꞉ dla siyemama yia꞉ semama oplayemala diyo. Epalati A꞉dam ya꞉ mamadulo hiye ipo. ");
INSERT INTO xla_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","A꞉dam 130 sokomoko ma-halepo gudepame ya꞉lluta maseyemala hale, A꞉dam mila꞉pi himili hamaiyo, ya꞉ hiye Set. ");
INSERT INTO xla_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set hamale alotle A꞉damtapo 800 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Epedeme A꞉damtapo 930 sokomoko halepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Epame Settapo 105 sokomoko halepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Enos. ");
INSERT INTO xla_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Epame Enos hamale alotle Settapo 807 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Epedeme Settapo 912 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Epame Enostapo 90 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Kenan. ");
INSERT INTO xla_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Epame Kenan hamale alotle Enostapo 815 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Epapedeme Enostapo 905 sokomoko halepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Epame Kenantapo 70 sokomoko halepo gudepame ya꞉llutapo maseyemala hamaiyo, ya꞉ hiye Mahalalel. ");
INSERT INTO xla_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Epame Mahalalel hamale alotle Kenantapo 840 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Epapedeme Kenantapo 910 sokomoko halepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Epame Mahalaleltapo 65 sokomoko halepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Yaled. ");
INSERT INTO xla_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Epame Yaled hamale alotle Mahalaleltapo 830 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Epedeme Mahalaleltapo 895 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Epame Yaledtapo 162 sokomoko halepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Inok. ");
INSERT INTO xla_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inok hamale alotle Yaledtapo 800 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Epedeme Yaledtapo 962 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Epame Inokta 65 sokomoko halepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Metusela. ");
INSERT INTO xla_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Metusela hamale alotle Inoktapo 300 sokomoko dulu dla halemama ma akimlala opi mate epo utukaka opi mate hatitimaiyo. Ya꞉ sikemte God malamalalo oplami halaiyo. Epalati Godtapo ya꞉ta 365 sokomoko umpo hallati ya꞉ye hamame hetaiyo. Epalati opata ma ya꞉ye ponatiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Epalati Metuselatapo 187 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Lamek. ");
INSERT INTO xla_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek hamale alotle Metuselata 782 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Epedeme Metuselatapo 969 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Epame Lamekta 182 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Epalati Lamektapo maseyemala e ya꞉ hiye Nowa depame epo atlaiyo, “Godtapo A꞉damta batalimale tle di watle pasakalo kokalle iye hamiwapo. Epedeme ditapo di do mate ta꞉la muwalepo dlowe alisisi emha꞉ha꞉mama wotiyalle natimha꞉ha꞉ iye ma maseyemala ita di gadlalo hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowa hamale alotle Lamektapo 595 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Epedeme Lamektapo 777 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Epalati Nowata 500 sokomoko halepo gudepame ya꞉llutapo akimlala hatitimaiyo, yia꞉ hiye Sem, epo Ham, epo Yapet. ");
INSERT INTO xla_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Ta꞉lamo pato dla opata sikemte pasatamtaiyo. Epalati oloma edla pepele di dla ha꞉ha꞉lalo so opa opitapo ta꞉la sota hatitimale utukaka ka꞉ka꞉dleta popa꞉la natipame malame halomyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Epalati Godta epo atlaiyo, “Na꞉ta hamili pasakalo halemhala hedletapo oplami dulu dla pase kokó hallowa. Adipalati, opaye isikimi ta꞉la sopo. Epedeme yia꞉tapo isikimi 120 sokomoko ha꞉ha꞉pame palidemha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Epedeme pepele di tle malale so opa iwolota wola꞉ ikadepe halopo hatitimale yimlalata sikemte itiyamale mate koko halomha꞉ha꞉mdiyo. Epapele tle opata yia꞉ kokoye powowelilalo kokó malaha꞉ha꞉mdiyo. Epame yia꞉ye semama Nepilim so demdiyo. Nepilim so iwoloye ka꞉yapa ta꞉lamo hema me-ha꞉ha꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Godta natili dla ta꞉lamo so hapulomatapo sikemte batalimale koko halomha꞉ha꞉la natiyo. Epame yia꞉ta malamale mape alila hapuloma isikimi batalimale koko malamoloweta ella natiyo. ");
INSERT INTO xla_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Epalati Godtapo ya꞉ta mimita꞉pele opata ha꞉ha꞉le pasakalo natipame dupa kolle mate epo atlaiyo, “Na꞉ adipalati ta꞉la soye mimita꞉puwa? ");
INSERT INTO xla_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Na꞉ watapo na꞉ta mimita꞉pele opa hapuloma mate epo alinepi hapuloma mate epo tea hapuloma mate potipa꞉mmellowepo. Adipalati, na꞉ta mimita꞉pele so hapuloma i natimama sikemte alima,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amasiyama dulu edla oplami hatlo Nowatapo God mila꞉pi tle ka꞉dle oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Epedeme opa hapuloma dulu dla hatlo Nowatapo God mila꞉pi tle ka꞉dle oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowatapo ya꞉ akimlala dapahatlope elemhalaiyo, yia꞉ hiye Sem, epo Ham epo Yapet. ");
INSERT INTO xla_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","13","Godtapo ta꞉lamo so hapulomata batalimale pato dulu dla ha꞉ha꞉la natipame Nowa watle epo atlaiyo, “Ta꞉lamo hema ya꞉mkale yumuluwe koko mate epo ya꞉mkale pomalamalalo wekelowe koko mateta pta pato halapo. Epedeme na꞉ ta꞉lamo mate epo dulu edla ha꞉ha꞉lalo so opa hapuloma mate poyuluwepo. ");
INSERT INTO xla_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Epapedeme wa꞉ dali ka꞉ka꞉dle mate koa pato tine. Epame dulu edla hutiyelowe aya alupoli hatitipame dulu mate alikili mate dla tokeyamale alisisi mate hutupamelene, yúta dulu dla tulala depame. ");
INSERT INTO xla_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Epame koata selemalliye 150 mita hallepe, epo ya꞉ta popolalleye 25 mita hallepe, epame dopukota didleye 15 mita hallepe. ");
INSERT INTO xla_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Epedeme wa꞉ eme bodepo matle mosisi kokoloma tilimama eme isili tle mateka꞉pi medla tilimelepe. Epame kokoloma tlo koa seme dla tilipe. Epame koa dulu dla aya popoliyeleye dapahatlope hallepe. Haleta isili ikadepe dla, epalati haleta duka dla, epalati haleta di ikadepe dla hala dlepe. ");
INSERT INTO xla_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Epalati na꞉tapo yú puale pato hamilowepo ta꞉lamo dla ha꞉ha꞉ so hapuloma poyulupo depame. Epedeme alisisi hapuloma ta꞉lamo hema ha꞉ha꞉tapo pallipe. ");
INSERT INTO xla_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amasiyama wa꞉tapo, wa꞉ a꞉ya mate epo wa꞉ akimlala dapahatlope mate epo yia꞉ wola꞉ mate koa dulu dla tumullati na꞉tapo wua꞉ pasakalo gadlowepo. ");
INSERT INTO xla_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Wua꞉ta koa dulu dla tumama alinepi mila꞉pi meyelope meyelope dleye patetalo mate epo molalatalo mateta wa꞉ hala dla pumhallati hohopo tumullupe, yia꞉tapo popalilalo wekelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Epame wua꞉ta tumama wua꞉ta dlowe alisisi mate epo alinepita dlowe alisisi mate halopo tumullupe.” ");
INSERT INTO xla_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Epalati Nowatapo Godta atlale koko hapuloma eye ma-haiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Epame Godtapo Nowa watle epo atlaiyo, “Wata oloma hema ha꞉ha꞉ opa hapuloma dulu dla na꞉ta natiye hatlo wa꞉ tlo sikemte ka꞉dle oplami halema. Epapedeme wa꞉ mate wa꞉ a꞉ya mate epo wa꞉ akimlala mate epo yia꞉ wola꞉ mate koa dulu dla elemtuwane. ");
INSERT INTO xla_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Epame wua꞉ta tumama ullu watalo alinepi mila꞉pi meyelope meyelope dleye patetalo mate molalatalo mate hohopo tumullupe. Amasiyama wa꞉ ullu pa꞉talo alinepi tlo elemtumama alinepi mila꞉pi meyelope meyelope dleye patetalo dla 7 hohoma epame molalatalo dla 7 hohoma demtapame elemtulupe. ");
INSERT INTO xla_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Epame tea mape patetalo dla 7 hohoma epo molalatalo dla 7 hohoma demtapame elemtulupe. Epalati yia꞉tapo ma alotle yia꞉ mila꞉pi sepele usulumha꞉ha꞉mama pasatlepo depame. ");
INSERT INTO xla_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Wata oloma itle alila 7 pololepo gudlati na꞉tapo tiyo patoye ta꞉lamo dla tulune dlowama. Epalati 40 alila mate epo 40 utula꞉la mate tiyo patota hellepe. Epalati na꞉ta mimita꞉pele opa hapuloma mate epo alinepi hapuloma mateye poyuluwepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Epalati Nowatapo Godta atlale koko hapulomaye ma-haiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowaye 600 sokomoko hallati yútapo puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Epalati Nowata ya꞉ a꞉ya mate epo ya꞉ akimlala mate epo yia꞉ wola꞉ mate koa pato dulu dla tuwaiyo, yúta ta꞉lamo gola꞉dlati yia꞉tapo pasakalo hallowe halowedeme. ");
INSERT INTO xla_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Epalati Godta atlale yu e dolumama tea mila꞉pi meyelope meyelope dle mate epo alinepi hapuloma mila꞉pi meyelope meyelope dle matetapo Nowa hala dla puame koa dulu dla tumhalaiyo. Yia꞉tapo koa dulu dla tumhalemama patetalo mate molalatalo mate tua demhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Epame alila 7 mogudlati yútapo ta꞉lamo patoye dokolomhetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowata halemama 600 sokomoko umale oloma edla yú mataletapo ta꞉la dulu tle popokotimyaiyo. Epalati omapla di tle tiyo patota heliyo. Koko iye namba 2 mama dulu dla namba 17 alila umulati apiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Epalati tiyotapo 40 alila mate epo 40 utula꞉la mate dulu dla helemhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Epalati Nowa mate ya꞉llu mate epo yia꞉ akimlala Sem mate epo Ham mate epo Yapet mate epo yia꞉ wola꞉ mate koa dulu dla tuwaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Yia꞉ta tumama alinepi mila꞉pi meyelope meyelope dle dulu dla halo mate epo yowo mate epo tea mila꞉pi meyelope meyelope dle mate elemtuwaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Godta atlale yu e dolumama alinepi hapulomatapo Nowa mate tumhalale dulu edla patetalo mate epo molalatalo mate tua demhalaiyo. Yia꞉ta hapulomatapo koa dulu dla mo-tupa꞉mele pokadlati God meyelo kokolomaye godiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Tiyota 40 alila dulu dla helemhallati yúta pumhetamama koata hollowe mo-kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Yútapo ta꞉lamo dokolomhetemama tamali patoto sikemte seselemalli popa꞉le aloweli diye mo-gola꞉gola꞉diyo. ");
INSERT INTO xla_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Epalati tamali patoto aloweli yúta gola꞉dleye 7 mita ga꞉tulli epapele halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Epalati alinepi hapuloma mate epo tea hapuloma mate epo opa hapuloma mate ta꞉la medla pomelletapo paliyo. Epedeme ta꞉lamo hema pasakalo ha꞉ha꞉lalo alisisi hapulomatapo mosukulu palipa꞉meliyo. Amasiyama hatlo Nowata koa dulu dla elemtuwale sotapo pasakalo gadlowe haiyo. ");
INSERT INTO xla_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Epalati 150 alila dulu dla yútapo ta꞉laye gola꞉depo elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Godtapo Nowa mate epo alinepi hapuloma mate koa dulu dla ha꞉ha꞉leye ala me-malahalaiyo. Epammama ya꞉tapo mosisi dla itiyamale hamiyo, mosisita sikemte hotlomhalemama yúta pillipo depame. ");
INSERT INTO xla_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Epalati Godta ta꞉la dulu dla yú matale opokoko ha꞉ha꞉leye ma-gogodlati omapla di tle tiyo patota helemhalale mape keidiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","Epalati yúta woloma pilimtulumhalaiyo. Epalati koata yú di dla holomsela꞉mama mama 5 pololepo gudlati tulume Alalat tamali aloweli di dla gagadiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amasiyama yúta ala woloma me-pilimtulumhalemama mama dapiyamte pololepo gudlati tamali opi aloweli mape mo-wowoyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Epame Nowata ma 40 alila pololepame mosisi kokoloma gowaladepame wako teaye tane diyo. Amasiyama tea itapo ma ilame populalo yúta pillipo depame me-hollomsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Epame ma-alotle Nowatapo seselema teaye tane diyo, yúye mo-pilita꞉ depo natilipo depame. ");
INSERT INTO xla_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amasiyama yúta woloma pilimtulumama dalupa ala me-dodokolopo hallati natipame teata kollowe totamsela꞉po ilame pulati Nowata ma hamame koa dulu dla pameliyo. ");
INSERT INTO xla_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Epame Nowa matle alila 7 halepo gudepame seselema teaye ma tane diyo. ");
INSERT INTO xla_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Epalati seselema teatapo hollomtame sela꞉po ma tamila꞉la ilame pumama olipi dali upa amkota꞉le ketahame mukota yilame puaiyo. Nowa epela malamaiyo, yúye mo-pilimtulupo. ");
INSERT INTO xla_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Epame matle alila 7 halepo gudepame seselema teaye ma tane diyo. Epalati ya꞉tapo hollomtamama ma ilame popuwaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Epalati Nowata koa dulu dla halemama mama 10 umulati eme dokostepo alikili dla natitepo, yúta mo-pilipo halla natiyo. Oloma hema Nowatapo 601 sokomoko umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Epame ma mama dapiyamte pololepo gudepo alotle natilati ta꞉lata ma sekelemama kokalestame ella natiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Epalati Godtapo Nowa watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wa꞉ mate epo wa꞉ a꞉ya mate epo wa꞉ akimlala mate epo yia꞉ wola꞉ mate koa dulu tle alikili a꞉ma dla wowoyamaiya. ");
INSERT INTO xla_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Wua꞉ta u-ulapo tamama alinepi hapuloma mila꞉pi meyelope meyelope dle mate eleme alikili dla woyamaiya, yia꞉tapo yimlala usulumama ta꞉lamoye matle pasatlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Epalati Nowata ya꞉llu mate epo ya꞉ akimlala mate epo yia꞉ wola꞉ mate koa dulu tle alikili dla u-ulapo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Epame alinepi hapulomata koa dulu tle alikili dla u-ulapo tamalemama miyelo yia꞉ sepele siyapota mepo ketamta mepo ketamta depo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Epame Nowatapo God dla alinepi poyupo ha꞉lalo tileye haiyo. Epame ya꞉tapo God hi di dla ta꞉demama ullu pa꞉le aliya halo mate tea mate poyupo halomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Epalati alinepi halomale ullu seyamaletapo hetame ya꞉ umalati Godta sikemte siyeiyo. Epame ya꞉skamu epo atlaiyo, “Ta꞉la sota ma batalimale koko halomha꞉ha꞉lati na꞉tapo ta꞉lamoye matle poyuluwa. Epapele dulu dla na꞉malamana, ta꞉la sotapo koko halomale mate epo momalamale mateye pta batalimana. Epapele tlope na꞉ matle yia꞉ye popoyuluwa. ");
INSERT INTO xla_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Amasiyama ta꞉lamota matle hallowe oloma edla alisisi emolowe alila me-ellepe, epame alisisi hauwallowe alila ma me-ellepe. Epame pomale alila ma me-ellepe, epame alemalle alila ma me-ellepe. Epame tene alila mate epo sali silaple alila mate ma me-ellepe. Epame utula꞉la mate alila mate ma me-ellepe.” ");
INSERT INTO xla_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Godtapo Nowa mate ya꞉ akimlala mate dla epo atlaiyo, “Wua꞉ yimlala sikemte isukumama ta꞉lamoye pasatlepe. ");
INSERT INTO xla_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Alinepi hapuloma tea mate epo amalo mateta wua꞉ wowota꞉le mate ha꞉ha꞉lepe. Epapedeme yia꞉tapo wua꞉ta itiyamale isili tle ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kotiyamale dla na꞉tapo wua꞉ye isikimi emale alisisi mate epo dlomoko mate dlomha꞉ha꞉iye duwapo. Amasiyama na꞉ ma wata wua꞉ watle atlema, alinepi hapuloma iye dlomha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Amasiyama wua꞉ mo demama ala omali mate hallati podlowa. Adipalati, pasakaloye omali dulu dla halapo. ");
INSERT INTO xla_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Epedeme oplami antapo ya꞉mkale pasakaloye kestlepiye, ya꞉ ma asiyama yumilipe. Epame alinepi aditapo oplami pasakalo kestlepiye, asiyama alinepi e mape yumilipe. ");
INSERT INTO xla_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Epedeme oplami antapo ya꞉mkale omaliye olostlepiye, ya꞉ ma asiyama ya꞉ omaliye olostlepe. Adipalati, Godtapo oplamiye me-ya꞉ mila꞉pi sepele mita꞉puwapo. ");
INSERT INTO xla_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Epedeme Nowa wa꞉ mate epo wa꞉ akimlala mate, wua꞉ yimlala sikemte isukumaiya, wua꞉ mamadulotapo ta꞉lamo pato hema opa pasatlepo depame.” ");
INSERT INTO xla_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Epame Godta Nowa mate epo ya꞉ akimlala mate dla ma epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Na꞉ watapo yu itiyamaleye wua꞉ mate epo alotle wua꞉ mamadulota ha꞉ha꞉lowe mate dla himima. ");
INSERT INTO xla_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Epame wua꞉ mate koa dulu tle u-ulapo matiwa alinepi mila꞉pi meyelope meyelope dle mate dla ma himima. ");
INSERT INTO xla_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Yu itiyapo himili eye ipo. Na꞉ matle pasakalo ha꞉ha꞉ alisisi hapulomaye yú mate popoyuluwa. Epame matle ta꞉lamoye yú mate poyuluwa. ");
INSERT INTO xla_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Na꞉tapo wua꞉ mate wua꞉ mamadulo mate epo pasakalo ha꞉ha꞉lalo alinepi hapuloma mate dla yu itiyapo himmama ulu himiye ipo. ");
INSERT INTO xla_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Eye na꞉tapo pesepidoloye omapla di dla himima. Pesepidolo itapo na꞉ta wua꞉ dla yu itiyapo himi i imalalo hallepe. ");
INSERT INTO xla_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","16","Epapedeme pesepidolota wuala dulu dla ella natilipiye, na꞉tapo wua꞉ mate epame alinepi hapuloma mate dla yu itiyapo himi iye malamolowepo. Epedeme yútapo matle pasakalo ha꞉ha꞉lalo alisisi hapulomaye popotimolowa. ");
INSERT INTO xla_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Adipalati, pesepidolotapo na꞉ta yu itiyapo himi i ya꞉ ulu himili halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Nowa ya꞉ akimlala iwolotapo koa dulu tle u-ulapo matiyo. Yia꞉ hiye Sem, epo Ham epame Yapet. Amasiyama Hamye Keinan ya꞉ apo. Epedeme akimlala dapahatlope iwolotapo ta꞉lamo opa hapulomata puale sitali halapo. ");
INSERT INTO xla_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Alotle Nowatapo osalo himpame gla꞉pi dlomoko emaiyo. ");
INSERT INTO xla_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Epame ya꞉ gla꞉pi dlomoko dala mate wain yú mita꞉pame depo yiyilamama aya dulu dla tidali siyapo elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Epalati Keinan ya꞉ a Hamta natipame Sem mate epo Yapet mate dla atlaiyo. ");
INSERT INTO xla_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Epalati Sem mate epo Yapet mateta yia꞉ ata tidali siyapo ellati natilala depame, tluka hame yia꞉ maka꞉ dla himme kawapo tuwame yia꞉ aye bopudiyo. ");
INSERT INTO xla_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowa kawata yulita mo-pa꞉lati yelepo yami mosukulu hamale Hamta koko halë dalepame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Wotiyalle kokotapo Keinan dla pulupe. Epame ya꞉tapo ya꞉ bapadulo dulu dla isili ikadepe dla asiyama pa꞉le oko halalo hallepe.” ");
INSERT INTO xla_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Epame ya꞉ matle epo atlaiyo, “Lod, Sem ya꞉ God hi di dla ta꞉diya. Epame Keinanta Sem ya꞉ oko oplami halemama ya꞉ yu dla salladepo sela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Epame Godtapo Yapet watle ta꞉la pato hamilipe. Epame Yapettapo Sem ya꞉ aya dla hallepe. Epalati Keinantapo yia꞉ yu dla salladepo sela꞉mama yia꞉ oko oplami hallepe.” ");
INSERT INTO xla_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yúta opa poyuli alotle Nowatapo 350 sokomoko halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Epedeme Nowatapo 950 sokomoko halepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowa ya꞉ akimlala hiye Sem, epo Ham epo Yapet. Epapedeme yúta opa poyuli alotle opa dapahatlope iwolotapo akimlala hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapet ya꞉ akimlala hiye Goma, epo Magog, epo Madai, epo Yaban, epo Tubal, epo Mesek epame Tilas. ");
INSERT INTO xla_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Epalati Goma ya꞉ akimlala hiye Askenas, epo Lipat, epo Togama. ");
INSERT INTO xla_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Epalati Yaban ya꞉ akimlala hiye Elisa mate epo Talsis matepo. Epame Kitim so mate epo Lodanim so mateye Yaban ya꞉ mamadulopo. ");
INSERT INTO xla_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Epedeme opa hapuloma iwoloye Yapet ya꞉ mamadulopo. Yia꞉tapo Mediteleniya kaula pili dla yia꞉ elele tle miyelo hutukuliyapo tame hala hala demtaiyo. Epame yia꞉ yu mape meyelope meyelope dle yuhamha꞉ha꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Epalati Ham ya꞉ akimlala hiye Kus, epo Mislaim, epo Put epame Keinan. ");
INSERT INTO xla_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Epalati Kus ya꞉ akimlala hiye Seba, epo Habila, epo Sabata, epo Lama epame Sabateka. Epalati Lama ya꞉ akimlala hiye Seba mate epo Dedan mate. ");
INSERT INTO xla_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ya꞉ mama haleye Nimlodpo. Nimlodtapo opahale dulu dla sikemte itiyamale oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Epame ya꞉tapo God mila꞉pi tle ka꞉pi dlowe alisisi siyomalalo halaiyo. Epapedeme yuta ipo atlapo, “Nimlod some God mila꞉pi tle ka꞉pi dlowe alisisi siyomalalo halane,” depo. ");
INSERT INTO xla_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ka꞉yapa Nimlodtapo mo hapuloma iye omhalaiyo. Eye Babilonpo, epo Elekpo, epo Akadipo, epo Kalnepo. Mo hapuloma iye Babiloniya mo pato dulu dla hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Epame ma etle Asiliya mo dla taiyo. Ya꞉ edla tame Niniba mo mate Lehobot Il mo mate epame Kala mo mate kotimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Ya꞉ matle Niniba mo ka꞉ epo Kala mo pato ka꞉ duka dla Lesen mo kestaiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Epedeme Ham yami Mislaim ya꞉ mamaduloye ipo, Ludi sopo, epo Anam sopo, epo Lehab sopo, epo Naptu sopo, ");
INSERT INTO xla_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","epo Patlus sopo, epo Kaslu sopo, epo Kaptoli sopo. Epedeme Pilisteya soye Kaslu so yia꞉ mamadulopo. ");
INSERT INTO xla_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Epalati Ham yami Keinan ya꞉ mamaduloye ipo, Saidon sopo, epo Hitai sopo, ");
INSERT INTO xla_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","epo Yebusi sopo, epo Amoli sopo, epo Gilgasi sopo, ");
INSERT INTO xla_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","epo Hibai sopo, epo Alki sopo, epo Sini sopo, ");
INSERT INTO xla_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","epo Albad sopo, epo Semali sopo, epo Hamat sopo. Epame alotle Keinan so elele hapuloma ewolotapo hutukuliyapo taiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Epedeme Keinan so ta꞉la sukuluye ipo elema. Saidon mo tle kotiyapo yame Gasa dla gudepo. Epo matle tame Sodom mo mate Gomola mo dla tame umapo. Epame ma etle tame Adama mo mate epo Seboim mo mate dla tame gudepo. Epame ma metle tame Lasa dla mosukulu gudepo. ");
INSERT INTO xla_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Opa hapuloma iwoloye Ham ya꞉ mamadulopo. Yia꞉tapo mo meyelope meyelope dle dla ha꞉ha꞉mtamama yia꞉ yu mape meyelope meyelope dle yuhamha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yapet ya꞉ bapa Semtapo akimlala hatitimaiyo. Epele dulu dla oplami Ebel ya꞉ akimlala hapulomaye Sem ya꞉ mamadulopo. ");
INSERT INTO xla_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Epalati Sem ya꞉ akimlalaye ipo, Elam, epo Asul, epo Alpaksad, epo Lud, epame Alam. ");
INSERT INTO xla_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Epalati Alam ya꞉ akimlalaye ipo, Us, epo Hul, epo Getel epame Mesek. ");
INSERT INTO xla_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Epalati Alpaksad yamiye Sala, epalati Sala yamiye Ebel. ");
INSERT INTO xla_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebelta akimlala dapiyamte hatitimaiyo, maseyemala hale hiye Peleg. Adipalati, ya꞉ta halale oloma edla Godtapo yu hapulomaye hutukuliyapo hamastamama opa hapuloma mape hutukuliyapo hamastaiyo. Peleg ya꞉ ei hiye Yokotan. ");
INSERT INTO xla_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokotan ya꞉ akimlalaye ipo, Almodad, epo Selep, epo Hasamabe, epo Yela, ");
INSERT INTO xla_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","epo Hadolam, epo Usal, epo Dikila, ");
INSERT INTO xla_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","epo Obal, epo Abimael, epo Seba, ");
INSERT INTO xla_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","epo Opil, epo Habila, epo mosukuluye Yobabpo. Epedeme opa hapuloma iwoloye Yokotan ya꞉ akimlalapo. ");
INSERT INTO xla_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Yia꞉ta ha꞉ha꞉le moye Mesa mo tle kotiyapo tame salita matlalo tiyama tamali di Sepa mo dla tame gudiyo. ");
INSERT INTO xla_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Opa hapuloma iwoloye Sem ya꞉ mamadulopo. Yia꞉tapo mo meyelope meyelope dle dla ha꞉ha꞉mtamama yia꞉ yu mape meyelope meyelope dle yu hamha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Elele hapuloma iye Nowa ya꞉ akimlala tle puaiyo. Epame yúta opa poyuli alotle opa iwolotapo ta꞉lamo so hapuloma yia꞉ sitali halapo. ");
INSERT INTO xla_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ka꞉yapa ta꞉lamo pato hema opa hapulomatapo yu hatlo mate yuhamha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Epame opata ha꞉ha꞉mtamama toko salita matlalo tiyama dla gilidetepo wou mo ka꞉dle Babiloniya mo dla natipame ma edla tame ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Yia꞉ edla tame ha꞉ha꞉mama yia꞉skamu yia꞉ dulu dla epo atlamyaiyo, “Di mo pato kestapame aya patoto halomolowa. Epame di God umuluwedeme aya pato selemalli hatlo hame hetlowa. Epedeme dita mo edla kestepo aya halomelepiye, di ewala mate pohalomolowa, amasiyama sokope tokeyamale mate dukupo blik ewala mimita꞉pame kolumhetamama aya halomolowepo. Dita aya patoto halomelepiye, opata di hi di dla ta꞉dlepe. Eta dita ta꞉lamo pato hema pohutukuliyapo tame ha꞉ha꞉myelowa,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Amasiyama Godtapo opata mo pato kestale mate epo aya pato selemalli hamhetale mate natila malaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Godta malame natipo epo atlaiyo, “Opa iwoloye hatlopepo, epame yu hatlo yuhamsiyamapo. Epame yia꞉ta koko ha iye ala ka꞉yapa kotiyamama amma. Epame ma alotle yia꞉ta solotamale koko patoto me-halomalala. ");
INSERT INTO xla_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Epapedeme di tulume ha꞉ha꞉mama yia꞉ta yu hatlo yuhamsiyamaye duka hutukuliyapo mellowa, yia꞉ta ya꞉mkale yu asiyama pomala dallalo weke asiyama pomala dallalo weke demsiyamelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Epapedeme Godtapo yia꞉ta yu hatlo yuhamsiyamaleye ma hutukuliyapo mellati yia꞉tapo aya selemalli hamhetale ma memeliyo. Epalati yia꞉tapo yia꞉ yu meyelope meyelope dle mate ta꞉lamo pato dla hutukuliyapo tame ha꞉ha꞉myaiyo. Epedeme yia꞉ta mo pato kestale hiye Babilonpo. Adipalati, mo hema Godtapo yu hapulomaye hutukuliyapo meliyo. ");
INSERT INTO xla_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yúta opa poyuli alotle sokomoko dapiyamte polollati Semye 100 sokomoko umaiyo. Oloma edla ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Alpaksad. ");
INSERT INTO xla_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Epo Alpaksad hamale alotle Semtapo 500 sokomoko dulu dla halemama akimlala opi mate utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Epalati Alpaksadtapo 35 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Sala. ");
INSERT INTO xla_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Epame Sala hamale alotle Alpaksadta 403 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Epalati Salatapo 30 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Ebel. ");
INSERT INTO xla_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Epame Ebel hamale alotle Salata 403 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Epalati Ebeltapo 34 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Peleg. ");
INSERT INTO xla_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Epame Peleg hamale alotle Ebelta 430 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Epalati Pelegtapo 30 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Leu. ");
INSERT INTO xla_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Epame Leu hamale alotle Pelegta 209 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Epalati Leutapo 32 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Selug. ");
INSERT INTO xla_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Epame Selug hamale alotle Leuta sokomoko 207 dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Epalati Selugtapo 30 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Nahol. ");
INSERT INTO xla_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Epame Nahol hamale alotle Selugta 200 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Epalati Naholtapo 29 sokomoko halepo gudepame ya꞉lluta maseyemala hamaiyo, ya꞉ hiye Tela. ");
INSERT INTO xla_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Epame Tela hamale alotle Naholta 119 sokomoko dulu dla halemama akimlala opi mate epo utukaka opi mate hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Epalati Telatapo sokomoko 70 halepo gudepame akimlala dapahatlope hatitimaiyo, yia꞉ hiye A꞉iblam, epo Nahol, epame Halan. ");
INSERT INTO xla_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tela ya꞉ akimlalaye A꞉iblam, epo Nahol, epame Halan. Halan yamiye Lotpo. ");
INSERT INTO xla_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Epame Halan ya꞉ a Tela ala me-hallati Halan mo-powaiyo, Kaldeya mo pato dulu dla ya꞉ mo ikadepe Ul dla. ");
INSERT INTO xla_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","A꞉iblam mate epo ya꞉ ei Nahol mate wola꞉ halomaiyo. A꞉iblam ya꞉llu hiye Selai. Amasiyama Selaiye hamkapi polaiyo. Epalati Nahol ya꞉lluye Halan yoti Milkapo. Milka ya꞉ bapaye Iskapo. ");
INSERT INTO xla_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Epeleye Telatapo yami A꞉iblam mate epo ya꞉ moma Selai mate epo Halan yami Lot mate elepame Ul mo tle alikili dla woyapame ma Keinan mo dla tamalaiyo. Amasiyama yia꞉ Keinan mo dla tamalemama ma mo pato hale Halan mo dla tame woyapame medla ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Telata 205 sokomoko halepame Halan mo medla powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Godta A꞉iblam watle epo atlaiyo, “Wa꞉ mo mate epo wa꞉ opa mate epo wa꞉ a ya꞉ asiyadulo mate medla salepame na꞉ta wa꞉ watle mo nati-iliwe mo dla tane. ");
INSERT INTO xla_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","3","Epame na꞉tapo wa꞉ gademama wa꞉ mamaduloye ma a꞉ma pasatepo mellowepo. Epame wa꞉ hi mape pato dlowepo. Epapele dulu dla wa꞉ dla siyele hamilalo so dla asiyama na꞉ta yia꞉ dla siyele hamilowepo. Epame wa꞉ dla wotiyalle hamilalo so dla asiyama na꞉tapo yia꞉ dla wotiyalle hamilowepo. Epapedeme wa꞉ tle ta꞉la so hapuloma dla siyele hampulupe.” ");
INSERT INTO xla_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Epalati A꞉iblamta 75 sokomoko hallati Godta atlale yu e dolumama Halan moye saliyome taiyo. Ya꞉ tamama ya꞉llu Selai mate epo ya꞉ aluwa Lot mate epo ya꞉ta Halan mo dla halemama alisisi hapuloma halopo halale mate epame ya꞉ oko so hapuloma mate Keinan mo dla ma-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yia꞉ Keinan mo dulu edla siyamama Sekem mo dla puame woyamaiyo. Epame aiyalma dali Mole mo dla hallalo dla tame woyamaiyo. Oloma edla Keinan soye ala mo medla me-ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Epalati Godta A꞉iblam watle woyapo epo atlaiyo, “Na꞉tapo wa꞉ mamadulo dla ta꞉la iye hamilowepo,” diyo. Epame A꞉iblamtapo God dla alinepi poyupo ha꞉lalo tile haiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ya꞉ Sekem mo medla halepame matle donapi mo dla hetame Betel moye salita tullalo tiyama dla pomele epo Ai moye salita matlalo tiyama dla pomele depame duka dla kimiyo. Edla mape God dla alinepi poyupo ha꞉lalo tile hapame inoma sumama God hi di dla ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Epame ma mo e saliyome tamama Negeb mo dla tuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Oloma edla Keinan mo dla dlowe alisisita pa꞉lati A꞉iblamta ma Isip mo dla hallowedeme tuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Epame yia꞉ Isip mo dla mo-ulatuluwedeme ha꞉ha꞉mama A꞉iblamta ya꞉llu Selai watle epo atlaiyo, “Wa꞉ye a꞉ya pta ka꞉pi. ");
INSERT INTO xla_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Epapedeme dita Isip mo dla tulupiye, mo sota di natipame ipo atlowe sepena, ‘A꞉ya iye ya꞉llupo,’ depame na꞉ye yummama wa꞉ tlo pomellowe sepena. ");
INSERT INTO xla_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Epedeme wa꞉ta asiyama yia꞉ watle atlemama wa꞉ye notumala dlepe. Wa꞉ta epapelepiye, yia꞉ta wa꞉ natimama na꞉ye poyumuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Epedeme yia꞉ta Isip mo dla puame woyamalati Isip sota Selai natipame a꞉ya pta ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Epame Isip mo dokopala oplami Pelo ya꞉ oko sotapo Selai natipame ma tame yia꞉ dokopala oplami Pelo watle atlemama a꞉ya sikemte ka꞉dena depame ma ya꞉ hala dla sempuaiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Epalati dokopala oplami Pelotapo semte Selaiye A꞉iblam yotimala tepo depame A꞉iblamye woloma gadiyo. Epammama ya꞉ watle sipi aliya mate epo bulumkiyawa aliya mate epo donki aliya molalatalo mate patetalo mate epame oko so opa mate wola꞉ mate epo ka꞉mol aliya mate hohopo iyo. ");
INSERT INTO xla_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Amasiyama A꞉iblam ya꞉llu Selai koko tle Pelo mate epo ya꞉ oko so mate dla Godta esiyele pato hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Epalati Pelotapo A꞉iblam watle hihimama epo atlaiyo, “Wa꞉ apa kokoye na꞉ watle hauwa? Wa꞉ adipalati na꞉ watle Selaiye na꞉ a꞉ya pe-epalalo wekuwa? ");
INSERT INTO xla_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Epame wa꞉ adipalati Selaiye notumala duwa? Wa꞉ta epo atluwa koko tle na꞉tapo ya꞉ halowedeme na꞉ aya dla semtauwapo. Epapedeme wa꞉ a꞉ya ipo. Wa꞉ ya꞉ sepame ma-tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Epame Pelotapo A꞉iblam koko dla ya꞉ opa watle itiyamale yu atlati yia꞉tapo A꞉iblam mate ya꞉llu mate dla ma-taiya diyo. Epalati yia꞉tapo yia꞉ alisisi hapuloma mate ma-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Epedeme A꞉iblam mate epo ya꞉llu Selai mate yia꞉ alisisi hapuloma halopo Isip mo saliyome ma Negeb mo dla ilamtaiyo. Epalati ya꞉ aluwa Lotta ya꞉ mate taiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Epele dulu dla A꞉iblamtapo alisisi pasatale halemama alinepi mate epo mani mate sikemte pasatale oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Epame A꞉iblamtapo Negeb mo tle ma Betel mo dla umula tamama duka dla kimpo halepo ma a꞉ma tademtaiyo. Epammtamama tame ya꞉ta ka꞉yapa kimili mo Betel ka꞉ epo Ai ka꞉ duka dla woyapo kimiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Epapeleye mo hema ya꞉tapo ka꞉yapa puame kimpo halemama God dla alinepi poyupo ha꞉lalo tile haiyo. Epame ya꞉ ma mo hatlo hema puame God dla inoma sumama ya꞉ hi di dla ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Oloma hema Lottapo ya꞉ yimlala mate epo ya꞉ oko so mate epo aliya halo hapuloma mate me-eleme A꞉iblam mate sela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Amasiyama yia꞉ta madipatata yia꞉ halo hapuloma mate ha꞉ha꞉le dulu dla mota yia꞉ mate po-ala꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Epalati A꞉iblam ya꞉ aliya halo omha꞉ha꞉lalo so mate epo Lot ya꞉ aliya halo omha꞉ha꞉lalo so mate ta꞉la yilo yu topuloliyo. Amasiyama oloma edla yia꞉ta ha꞉ha꞉le mo dla Keinan so mate epo Pelisi so mate me-ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Epeleye A꞉iblamta Lot watle epo atlaiyo, “Wa꞉ mate na꞉ mate ta꞉la yilo yu dlomha꞉ha꞉lowe poka꞉dena. Epame wa꞉ opa mate epo na꞉ opa mate yu dlomha꞉ha꞉lowe poka꞉dena. Adipalati, di asiya hatlopepo. ");
INSERT INTO xla_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ta꞉la hatlo ita pe-elasema. Epedeme di duka gladepame meyelo ta meyelo ta dlowe ka꞉pi. Epedeme mo pato hema wa꞉ta solotamale hadima ellepie, wa꞉ mo e halepe. Epele dulu dla wa꞉ta dowala tiyama dla telepiye, na꞉ asiyama weke tiyama dla tlowepo. Amasiyama wa꞉ta weke tiyama dla telepiye, na꞉ asiyama dowala tiyama dla tlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Epalati Lotta mo halowedeme toko Yoden aloma pili dla natitepo, wou mo sikemte ka꞉dle natiyo. Epame ya꞉ta mo e natili dla mo eye semte Godta osalo himili tepo diyo. Epame semte Isip mo tepo diyo. Koko iye Godta Sodom mo mate epo Gomola mo mate ala poyulalo hallati apiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Epedeme Lottapo Yoden aloma pili dla mo halowe solotamale atlaiyo. Epapedeme yia꞉ta madipatatapo duka gladepame meyelo ma-ta meyelo ma-ta diyo. ");
INSERT INTO xla_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Epalati A꞉iblamtapo Keinan mo medla me-halaiyo. Epalati Lottapo Yoden aloma pili dla Sodom mo pato mateka꞉pi dla kimtimsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Amasiyama Sodom sotapo God mila꞉pi tle pta sikemte batalimale koko patoto halomha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Epapeleye Lotta A꞉iblam saliyome ma-tlati Godta A꞉iblam watle epo atlaiyo, “Wa꞉ta hala mo alikili dla tlamane. ");
INSERT INTO xla_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ta꞉la pato wa꞉ta nati iye na꞉ta wa꞉ mate epo wa꞉ mamadulo mate dla hamilowepo. Ta꞉la itapo kokó halepo ha꞉ha꞉le dulu dla wua꞉lë hallepe. ");
INSERT INTO xla_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Epame na꞉tapo wa꞉ mamaduloye sikemte pasatepo mellowepo. Epalati yia꞉tapo asila some sikemte pasatamama opata sesa꞉loweye po-ala꞉lowa. ");
INSERT INTO xla_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wa꞉ wata sila꞉tipame mo tlamtane. Adipalati, na꞉ mo pato iye wa꞉ watle hamima.” ");
INSERT INTO xla_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Epalati A꞉iblamtapo ya꞉ kimna꞉ya dokostepo ma Heblon mo dla tame dali patoto polli Mamele mo mateka꞉pi dla kimpame God dla alinepi poyupo ha꞉lalo tile haiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Oloma edla Kedolamelta Elam mo dla dokopala oplami halaiyo. Epalati Amlapelta Babiloniya mo dla dokopala oplami halaiyo. Epalati Aliyokta Elasa mo dla dokopala oplami halaiyo. Epalati Tidalta Goim mo dla dokopala oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Dokopala so iwolotapo dokopala so opi do supulastale so mate opahale dlowedeme alumaiyo. Epedeme dokopala so do supulastale ewoloye ipo, Belaye Sodom mo dokopala oplamipo, epalati Bilsaye Gomola mo dokopala oplamipo, epalati Sinabye Adama mo dokopala oplamipo, epalati Semebelye Seboim mo dokopala oplamipo, epame dokopala oplami hale Bela mo dla hallalo. Bela mo i ya꞉ hi haleye Sowa demdepo. ");
INSERT INTO xla_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Dokopala so do supulastale iwoloye Kedolameltapo sokomoko 12 dulu dla yia꞉ye dokopala depo halemama omhalaiyo. Epame 13 sokomoko mo-umulati dokopala so ewolota ya꞉ye ma-aliyo. Epapalati yia꞉tapo Kedolamel mate opahale dlowedeme yia꞉ opa eleme puame Sidim pili dla alumaiyo. Mo iye wata Solo Kaulata gola꞉depo halapo. ");
INSERT INTO xla_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Epame 14 sokomoko umulati Kedolamel mate epo ya꞉ mate tamalale dokopala so mate tame Lepa so, Astelot Kanaim mo dla ha꞉ha꞉laloye kotlopame ma Susi so, Ham mo dla ha꞉ha꞉laloye kotlomaiyo. Epame yia꞉ ma tame Emi so, Sabe Kiliyataim mo dla ha꞉ha꞉laloye kotlomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Epame matle Seil tamali di dla ha꞉ha꞉lalo Holi soye posalemtame dalupa mo mateka꞉pi dla hallalo El Palan mo dla gudiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Epame yia꞉ ma i-ilapo puame ma En Mispa mo dla taiyo. Mo i ya꞉ hi haleye Kadespo. Epame yia꞉ mo edla puame Amalek so yia꞉ moye kolahaiyo. Epame yia꞉ ma tame Amoli so, Hasason Tama mo dla ha꞉ha꞉laloye kotlopame yia꞉ ta꞉laye kolahaiyo. Epame yia꞉ matle Sidim pili dla puame alumaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Epame yia꞉ edla puame alumalati dokopala so do supulastaletapo yia꞉ mate nalatimolowedeme dinapiyo. Dokopala so do supulastale ewoloye ipo, Sodom mo dokopala oplami, epo Gomola mo dokopala oplami, epo Adama mo dokopala oplami, epo Seboim mo dokopala oplami, epo Bela mo dokopala oplami. ");
INSERT INTO xla_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Epele dulu dla Kedolamel wolotapo dokopala so do supulastale mate nalatimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Yia꞉ta nalatimale dulu dla Kedolamel wolota itiyamalati Sodom so mate epo Gomola so mate potamama opa opiye munamu dulu dla tutula꞉mtaiyo. Epalati opa opi tlo tamali di dla pehetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","12","Epalati Kedolamel wolota puame Sodom mo mate Gomola mo mate kotlopame opa mate wola꞉ mate elemtamama A꞉iblam ya꞉ aluwa Lot mate hamamtaiyo. Adipalati, ya꞉ ma Sodom mo medla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Epame oloma edla hemele teletale oplami haletapo puame Hibulu oplami A꞉iblam watle koko woyamale hapulomaye atlamaiyo. Oloma edla A꞉iblamye Amoli oplami Mamele ya꞉ dali patoto mateka꞉pi dla halaiyo. Epeleye Mamele mate epo ya꞉ eidulo Esko mate Ane mate A꞉iblamye sikemte gademha꞉ha꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","A꞉iblamta ya꞉ aluwa Lotye opahale sota hamame tale dalepame ya꞉tapo ya꞉ opa, opahale dlowe sikemte malastale so 318 opa epapeleye elemaiyo. Epame yia꞉tapo Kedolamel woloye alotle dolumtame Dan mo dla popa꞉lati umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Epame utula꞉la oloma edla A꞉iblamta ya꞉ opaye huhukulupame alumale meyelo meyelope depo hatitimaiyo. Epame yia꞉tapo Kedolamel ya꞉ opaye poyumama opi tlo posalemtame Damasko mo tla꞉mtame tota ikadepe Hoba mo dla woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Epapeleye A꞉iblamtapo Kedolamel wolota Sodom mo mate Gomola mo mate dla halomale alisisi hapuloma mate epo mo so hapuloma mate ma i-ilapo elempuaiyo. Ya꞉ ilampumama ya꞉ aluwa Lot mate epo ya꞉ alisisi hapuloma mate halopo puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","A꞉iblamta dokopala oplami Kedolamel mate epo dokopala so opi mate kotlopo poyupame pulati Sodom mo dokopala oplamita ya꞉ umuluwedeme Sabe pili dla taiyo. Epedeme mo i ya꞉ hi haleye dokopala sota ha꞉ha꞉lalo mo demama apopo. ");
INSERT INTO xla_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Epame Salem mo dokopala oplami Melkisedek mape daya mate epo wain yú mate halopo A꞉iblam watle halopila puaiyo. Ya꞉ye di ikadepe dla hallalo God ka꞉ epo opa ka꞉ duka dla hallalo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Epapeleye ya꞉ta A꞉iblam watle epo atlaiyo, “Pepele di mate ta꞉lamo mate mimita꞉polalo Godta wa꞉ mate hallepe. Epedeme na꞉ di ikadepe dla hallalo God hi di dla ta꞉dema. Adipalati, wa꞉ dla opahale dlalo soye ya꞉ta hohopame wa꞉ do tama dla ipila꞉uwapo,” diyo. Epame A꞉iblamta ya꞉ta opahale dele dulu dla halomale alisisi hapuloma kolumtame 10 dleye meyelope meyelope depo kokolupame ma dulu edla kolumale hatlo tlo Melkisedek watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Epalati Melkisedekta A꞉iblam saliyome tlati Sodom mo dokopala oplamita puame A꞉iblam watle epo atlaiyo, “Na꞉ wa꞉ dla siyema, wa꞉ta opahale dele dulu dla na꞉ mo so mate epo na꞉ alisisi hapuloma mate ma i-ilapo halomale dla. Epedeme alisisi tlo mowolo halomama asiyama na꞉ mo so opa mate epo wola꞉ mate epo yimlala mate tlo na꞉ watle halopine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Amasiyama A꞉iblamta ya꞉ watle epo atlaiyo, “Na꞉ ta꞉lamo mate epo pepele di mate mimita꞉polalo di dla hallalo God hi tle wa꞉ watle ipo atlema, ");
INSERT INTO xla_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Na꞉ wa꞉ alisisiye pohalomolowa. Adipalati, na꞉ posolotamasema, wa꞉ta ma alotle na꞉ koko dla atlemama wa꞉ta na꞉ye alisisi pasatale oplami duwa dloweye. ");
INSERT INTO xla_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Epapele dulu dla wa꞉ alisisi dulu dla na꞉ opata dlowe alisisi opiye mo-douwa, epedeme eye na꞉ta wa꞉ dla halomolowe asiyama epo. Amasiyama wa꞉ ka꞉dena, na꞉ mate tamalale so opa Ane mate Esko mate epo Mamele mate dla alisisi halopiliweye.” ");
INSERT INTO xla_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Koko ita tame gudlati A꞉iblam inomata meyelope dle oloma edla Godta ya꞉ watle epo atlaiyo, “A꞉iblam, wa꞉ ase sikemte wota꞉miya. Na꞉tapo wa꞉ pasakalo gadlalo halemama wa꞉ dla ka꞉ka꞉dle koko halopimhallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Amasiyama A꞉iblamta epo atlaiyo, “Na꞉ pato God, wa꞉ apa kokoye na꞉ watle hamipa꞉? Adipalati, na꞉ maseyemala pa꞉le halema. Epedeme na꞉ta polati na꞉ oko oplami, Damasko dla hallalo Eliyeselta na꞉ elo dla hallalo hallepe. Adipalati, wa꞉ta na꞉ watle akimlalaye pohapina,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Epalati Godta asiyama A꞉iblam watle atlemama epo atlaiyo, “Wa꞉ oko oplamitapo wa꞉ elo dla pohallowa. Amasiyama mo-wa꞉ maseyemala ikadepetapo wa꞉ elo dla hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Epame Godta A꞉iblamye aya alikili dla semtame halemama epo atlaiyo, “Wa꞉ inoma mate omapla di dla natine. Wa꞉ ala꞉lepiye, wa꞉ tamili hapuloma eye sesa꞉pa꞉mele pokadene. Wa꞉ mamadulotapo tamili some epo pasatlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","A꞉iblamta Godta atlale yu dla mikadepe diyo. Epalati asiyama Godta ya꞉ta mikadepe dle natipame ya꞉ye ka꞉dle oplami diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Epame Godta ya꞉ watle epo atlaiyo, “Na꞉ye Godpo. Na꞉tapo wa꞉ye Kaldeya mo dla Ul mo yemala tle hema sempumama api impuwapo. Na꞉ta mo iye wa꞉ watle hamilati wa꞉ta mo eye ikadepe wolë dlepo depame sempuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Epalati A꞉iblamta asiyama epo atlaiyo, “Na꞉ pato God, na꞉ta ikadepe mo i haloweye apa kokota na꞉ ipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Epalati Godta A꞉iblam watle epo atlaiyo, “Wa꞉ na꞉ watle bulumkiyawa aliya molala mate epo gaut aliya molala mate epo sipi aliya pate mate elempuane. Wa꞉ na꞉ watle aliya elempumama sokomoko dapahatlope oloma dla ha꞉ha꞉lalo tlo elempuane. Epammama seselema mate epo hilipi yemala mate ma hohopo puane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Epalati A꞉iblamta alinepi hapuloma iwoloye hohopame elempuaiyo. Epame poyupo duka gaglatipame moto semeye seme dla hatitimta epo moto semeye seme dla hatitimta diyo. Amasiyama tea tlo duka pogladlalo mepo hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Epalati kepili tea mo i tlapame di tle keketamsiyamama mallati A꞉iblamta posaliyo. ");
INSERT INTO xla_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Epame salita mo-tutula꞉mtullati inoma ta꞉le patota A꞉iblam dla pulati ya꞉ elaiyo. Epalati milamalo amtuwaleta puame ya꞉ bopudlati natimama ya꞉ sikemte wota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Epame Godta ya꞉ watle epo atlaiyo, “Wa꞉ mamadulotapo ta꞉lamo hale dla tame ha꞉ha꞉mama asepe so some ta꞉la pa꞉le ha꞉ha꞉lepe. Epame yia꞉tapo 400 sokomoko dulu dla opa dla asiyama pa꞉le oko halomha꞉ha꞉mama wotiyalle dulu dla ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Amasiyama yia꞉ dla wotiyalle hapilalo so dla asiyama na꞉ta wotiyalle hapilowepo. Epame wa꞉ opatapo mo etle alikili dla woyamama alisisi pasatale mate woyamelepe. ");
INSERT INTO xla_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Amasiyama wa꞉ye, wa꞉ totoyemala ikadepe halemama ka꞉dle api tle polati alotle koko ita woyamelepe. ");
INSERT INTO xla_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Epalati wa꞉ mamadulotapo 400 sokomoko dulu dla asiyama pa꞉le oko dla wotiyalle halomha꞉ha꞉pame ma ilame mo hema pumullupe. Adipalati, Amoli so hema ha꞉ha꞉ yia꞉ batalimaleta ta꞉mpuame gudlowe sukuluye ala po-umasema.” ");
INSERT INTO xla_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Epalati salita mo-tullati mota ma-amtuwaiyo. Epalati pakasiyamalalo namtiyape otomale mate epo tuloma otomale mate woyapame mo epallita hutiye dlatimale duka dla siyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Alila oloma edla Godta A꞉iblam dla yu itiyapo himmama epo atlaiyo, “Wa꞉ mamadulo dla na꞉ta ta꞉la iye hamilowepo. Ta꞉la ya꞉ sukuluye ipo, Isip aloma tle kotiyapame tame Yupalates aloma pato dla gudepo. ");
INSERT INTO xla_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Amasiyama wata oloma hema opa iwolotapo ta꞉la hema me-ha꞉ha꞉po. Eye Keni sopo, epo Kenisi sopo, epo Kadomona sopo, ");
INSERT INTO xla_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","epo Hitai sopo, epo Pelisi sopo, epo Lepa sopo, ");
INSERT INTO xla_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","epo Amoli sopo, epo Keinan sopo, epo Gilgasi sopo, epame Yebusi sopo. Epedeme opa hapuloma iwolo ta꞉laye na꞉tapo wa꞉ mamadulo watle hamilowepo.” ");
INSERT INTO xla_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","A꞉iblam ya꞉llu Selaiye yimlala pohohomalalo hamkapi polaiyo. Epeleye ya꞉ aya dulu dla Isip a꞉ya ipilalo haleta ya꞉ oko hamhalaiyo, ya꞉ hiye Hagai. ");
INSERT INTO xla_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","4","Epapeleye Selaita A꞉iblam watle epo atlaiyo, “Na꞉ Godta na꞉ta yimlala hohomolowe apiye godena. Epapedeme wa꞉ wata tame na꞉ oko a꞉ya ipilalo Hagai hane. Epame ya꞉ta yimlala hatitimelepiye, eye nolëpo,” diyo. Epalati A꞉iblamta Selai yu dla dalepo ka꞉dena depame Hagaiye haiyo. Epedeme koko iye A꞉iblamta tame Keinan mo dla sokomoko 10 halale oloma edla apiyo. Epalati alotle Hagaita ya꞉ta mopapo polaleye natipame A꞉iblam ya꞉llu ikadepe Selaiye kokosa꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Epalati Selaita A꞉iblam watle epo atlaiyo, “Hagaita na꞉ kokosa꞉mhala kokoye e mo-wa꞉ batalimalepo. Amasiyama na꞉ta ya꞉ye wa꞉ watle hamiwapo, epapele tlope ma ya꞉ta mopapo polale natipame ma na꞉ye kokosa꞉mhalapo. Epedeme Godta wa꞉ mate epo na꞉ mate di kokoye gladlowe ka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Epalati A꞉iblamta asiyama ya꞉ watle epo atlaiyo, “Hagai iye wa꞉ oko a꞉yapo. Epedeme wa꞉ta solotamale koko ya꞉ dla halowedeme me-hane,” diyo. Epalati Selaita Hagai dla kasilamama ya꞉ dla wotiyalle hapimhallati ya꞉tapo wota꞉mama alikili dla woyapo teletaiyo. ");
INSERT INTO xla_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagaita teletame dalupa dulu dla woyapo ma Sul mo dla tlalo api alikili dla yú matale hallati medla polaiyo. Epalati God ya꞉ banakaka oplamita tulume ya꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Hagai, Selai ya꞉ oko a꞉ya, wa꞉ hadima tlowedeme adi tle puame poloma꞉?” diyo. Epalati asiyama Hagaita epo atlaiyo, “Na꞉ye na꞉ omhallalo a꞉ya Selai tle alikili dla woyapo tama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Epalati God ya꞉ banakaka oplamitapo ma ya꞉ watle epo atlaiyo, “Wa꞉ ma ilamtame wa꞉ omhallalo a꞉ya Selai yu dla salladepo sela꞉ne,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","11","Epame ma epo atlaiyo, “Wa꞉ta mopapo polaye hatostamama maseyemala hamelepe. Epalati wa꞉tapo ya꞉ hiye Ismael dlepe. Adipalati, wa꞉ta dupa kolle kokoye Godta ma-daluwapo. Epame na꞉tapo wa꞉ awaduloye sikemte pasatepo mellowepo. Epalati oplami haleta posesa꞉pa꞉mellowa. ");
INSERT INTO xla_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Amasiyama wa꞉ maseyemala Ismaeltapo aliya yowo some itiyamale mate halemama opa hapuloma dla opahale demhallepe. Epammama ya꞉ eidulo mate ma opahale demhallepe.” ");
INSERT INTO xla_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Epame Hagaita koko i natipo sikemte yelemama epo malamaiyo, “Yao ikadepe, na꞉ ikadepe God natili tlope na꞉ popowasema,” diyo. Epammama ya꞉tapo God hi semama, na꞉ natimhallalo God diyo. ");
INSERT INTO xla_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Epapele koko tle opatapo yú matale e semama Bel Lahai Loi demdiyo. Yú matale iye Kades mo ka꞉ epo Beled mo ka꞉ duka dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","A꞉iblamta 86 sokomoko halale oloma edla Hagaita maseyemala hamaiyo. Epalati A꞉iblamta maseyemala watle Ismael hiye hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","A꞉iblamta 99 sokomoko halale oloma edla Godta ya꞉ dla woyapame epo atlaiyo, “Na꞉ye itiyamale Godpo. Epedeme wa꞉ na꞉ mila꞉pi tle sela꞉mama woloma ullu pa꞉po hallepe. ");
INSERT INTO xla_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Epame na꞉ta wa꞉ dla yu itiyapo himiwaye e kokalepame wa꞉ mamadulo mape pasatepo mellowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Epalati A꞉iblamta ta꞉la dla akukulume polomama ya꞉ mila꞉pita ta꞉la umpo pollati Godta epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Na꞉ta wa꞉ dla yu itiyapo himiliye ipo, wa꞉tapo ta꞉la so hapuloma yia꞉ a hallepe. Epedeme wata oloma hema wa꞉ hiye ma po-A꞉iblam dlowa, amasiyama wa꞉ hiye ma A꞉iblaham dlepe. ");
INSERT INTO xla_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Epedeme na꞉tapo wa꞉ mamaduloye ma-a꞉ma sikemte pasatepo mellowepo. Epalati yia꞉tapo yia꞉ dulu dla dokopala hi halopo ha꞉ha꞉mtelepe. ");
INSERT INTO xla_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Epedeme na꞉tapo wa꞉ mate epo wa꞉ mamadulo mate yia꞉ God depo hallowedeme yu itiyapo himili itapo kokó elepo ellepe. ");
INSERT INTO xla_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Epame wata wa꞉ta Keinan mo dla asepe oplami some hala mo iye na꞉tapo wa꞉ watle epo wa꞉ mamadulo watle hamilowepo. Ta꞉la itapo mepo kokó wua꞉ hi mate ellepe. Epame na꞉ta wa꞉ mamadulo yia꞉ God hallowepo.” ");
INSERT INTO xla_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Epame Godta A꞉iblaham watle ma epo atlaiyo, “A꞉iblaham wa꞉ mate epo wa꞉ mamadulo mate na꞉ yu dla salladepo siyamelepe. ");
INSERT INTO xla_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","11","Epele dulu dla wua꞉ta na꞉ yu dla salla depo siyamolowe nati-imama wua꞉ dulu dla opa hapulomatapo kapala kotimolowe kotiyapame ma wua꞉ akimlala dla hamilipe. ");
INSERT INTO xla_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Epame wata oloma itle kotiyapo tamama akimlala hohopo alila 8 umalati kapala kotima demha꞉ha꞉lepe. Epammama wa꞉ oko so hapuloma mate epo yia꞉ akimlala mate kapala kotima demha꞉ha꞉lepe. Epame asepe oplamita puame wa꞉ oko hamhallepiye, ka꞉dena ya꞉ mate epo ya꞉ akimlala mate kapala kotimha꞉ha꞉loweye. Wua꞉ moto dla ulu hutiyetapo wua꞉ta na꞉ta yu itiyapo himili koko dulu edla ha꞉ha꞉ye alila hapuloma dla botomastamhallepe. ");
INSERT INTO xla_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Epele dulu dla oplami antapo kapala pokestlalo hallepiye, ya꞉ na꞉ opa dulu dla pohallowa. Adipalati, ya꞉tapo na꞉ta yu itiyapo himi iye mo-postamama apelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God matle A꞉iblaham watle epo atlaiyo, “Wa꞉ matle wa꞉ a꞉ya hi semama po-Selai demhallowa. Amasiyama wa꞉ wata oloma itle tamama wa꞉ a꞉ya semama Sela demhallepe. ");
INSERT INTO xla_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Na꞉tapo ya꞉ gadlati ya꞉ye maseyemala hamelepe. Epalati wa꞉tapo ya꞉ a hallepe. Epalati Selatapo ta꞉la so hapuloma yia꞉ wai hallepe. Epame ya꞉ awadulo opitapo dokopala hi halopo ha꞉ha꞉mtelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Epela dalepame A꞉iblahamta alumata akukulumpolomama ya꞉ mila꞉pita ta꞉la dla umpo eimale mate ya꞉skamu ya꞉ dla epo atlaiyo, “Ka꞉deta꞉, oplamita 100 sokomoko halemama maseyemala himiloweye? Hao, po-ala꞉na. Epame a꞉yata 90 sokomoko halemama maseyemala hamoloweye ka꞉deta꞉? Hao, po-ala꞉na,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Epame A꞉iblahamta God watle ma epo atlaiyo, “Ame poka꞉deta꞉, wa꞉ta Ismael ma wa꞉ta yu itiyapo himili maseyemala dloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Epalati Godta epo atlaiyo, “Hao pe-epapolowa. Amasiyama wa꞉ a꞉ya Selatapo wa꞉ elo ikadepe dla hallowe maseyemalaye hamelepe. Epalati wa꞉ta ya꞉ hiye Aisek dlepe. Epame na꞉ta wa꞉ dla yu itiyapo himiwatapo ya꞉ mate epo ya꞉ mamadulo mate dla kokó ellepe. ");
INSERT INTO xla_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Amasiyama wa꞉ta Ismael koko dla otele yu himiliye na꞉ me-dalema. Epedeme na꞉tapo ya꞉ gademama ya꞉ mamaduloye sikemte pasatepo mellowepo. Ya꞉tapo elele 12 sitali hallepe. ");
INSERT INTO xla_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Amasiyama na꞉ta wa꞉ dla yu itiyapo himiwaye ma Aisek mate ellepe. Maseyemala iye Selata sokomoko hale dla alila oloma me-ipapele dla hamelepe.” ");
INSERT INTO xla_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Godta A꞉iblaham mate yukamhalale medla gudepame ya꞉ saliyome me-hetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Epalati Godta atlale yu e dolumama alila hatlo medla A꞉iblahamtapo ya꞉ mate epo yami Ismael mate kapala kotimaiyo. Epame ya꞉ aya dulu dla ha꞉ha꞉le opa hapuloma mate epo yia꞉ akimlala hapuloma mate epo ya꞉ oko so opa hapuloma asepe so mate alila hatlo medla kapala kotimaiyo. Amasiyama oloma hema A꞉iblahamtapo sokomoko ma 99 oloma dla halaiyo. Epalati yami Ismael tlo 13 sokomoko oloma dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamele mo dla aiyalma dali patotota ha꞉ha꞉le oloma dla Godta A꞉iblaham watle woyamaiyo. Alila oloma hema sali sikemte alemallati A꞉iblahamta ya꞉ kimna꞉ya kokoloma tala homale dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ya꞉ toko edla polomama ipo natitepo, opa dapahatlopeta ya꞉ mateka꞉pi dla pumha꞉ha꞉la natiyo. Epalati A꞉iblahamta sila꞉time yia꞉ hala dla kukulumtame heodepo polomama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Na꞉ adulo, wua꞉ na꞉ye alikili tle olostame tamiya. ");
INSERT INTO xla_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Amasiyama wua꞉ aseka dali tau hema hedepo popa꞉iya. Epalati na꞉ tame wua꞉ hete hoahalomolowe yú mate epo dlowe alisisi mate halopo puluwepo, wua꞉ta e depame ma itiyamale mate tloweye,” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Ka꞉dena, wa꞉ta atla koko eye ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Epalati A꞉iblaham hapele tame ya꞉ aya dla tuwame ya꞉llu Sela watle atlemama epo atlaiyo, “Wa꞉ hapele daya amko tlo hapo daya pato ha꞉ne,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Epame matle kukulumtame ya꞉ aliyata ha꞉ha꞉lalo mo dla tame aliya amkota꞉le sikemte kakaliyapele tlo hampo puame ma ya꞉ oko oplami hale watle hamimama aliya iye ma-hapele yumpo ha꞉ne, diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Epame A꞉iblahamtapo aliya mo ya꞉ta ha꞉le mate epame bulumkiyawa aliya meme dala mate opa dapahatlope ewolo dla halopo taiyo. Epapeleye yia꞉ daya mo-dlompopa꞉lati A꞉iblahamtapo dali tou dla halemama yia꞉ omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Epalati yia꞉tapo A꞉iblaham watle epo atlaiyo, “Wa꞉ a꞉ya Sela da꞉?” diyo. Epalati asiyama A꞉iblahamta epo atlaiyo, “Ya꞉ aya dulu dla me-poloma,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Epame Godta atlemama epo atlaiyo, “Sokomoko hale dla alila oloma hema na꞉ta matle pulupiye, wa꞉ a꞉ya Selatapo maseyemala hamelepe,” diyo. Amasiyama Godta epo atlempollati Selatapo hemele aya dulu dla polomama dalempolaiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Alila oloma edla A꞉iblaham mate Sela mate mo-totoyimlala ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Epame Selatapo eimale mate polomama ya꞉skamu epo atlaiyo, “Na꞉ mate na꞉ oplami mate yimlala hatitimolowe po-ala꞉na. Adipalati, dia꞉ dla itiyamale ma-hawapo. Epedeme siyele iye ikadepe na꞉ dla pupa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Epalati asiyama Godtapo A꞉iblaham watle epo atlaiyo, “Adipalati Selatapo eimale mate atlemama ya꞉skamu ya꞉ye owayemala hamolowe dla sikemte alluyemala poloma di? ");
INSERT INTO xla_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Epapele dulu dla koko adita God dla kokalle elema꞉? Epedeme na꞉ sokomoko hale na꞉ta sale alila dla ma ilame puluwepo. Epalati oloma edla Selatapo maseyemala hamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Amasiyama Selaye sikemte wota꞉mama ya꞉tapo eimale kokoye kesomama, na꞉ pe-eimana, diyo. Amasiyama Godtapo ya꞉ watle epo atlaiyo, “Hao, wa꞉ me-eimalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Epame opata mo-tlowedeme sillipo ma Sodom tiyama dla tamalemama koloma di tle Sodom moye isili dla hallati omtamalaiyo. Epalati A꞉iblahamtapo yia꞉ api duka dla pomellowedeme yia꞉ mate taiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Epame Godta ya꞉skamu epo malamaiyo, “Na꞉ta wata koko halowedeme api iye A꞉iblaham watle atlamolowe me-ka꞉pi. ");
INSERT INTO xla_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Adipalati, A꞉iblaham ya꞉ mamadulotapo sikemte pasatlepe. Epame na꞉tapo ya꞉ tle ta꞉la so hapuloma dla siyele hampulupe. ");
INSERT INTO xla_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Adipalati, na꞉tapo ya꞉ye mo-souwapo, ya꞉tapo ya꞉ mamaduloye God yu imama ka꞉ka꞉dle koko tlo halomha꞉ha꞉lepo depame. Epalati na꞉tapo ya꞉ dla yu itiyapo himiwa kokoye e hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Epedeme Godta A꞉iblaham watle epo atlaiyo, “Sodom mo mate epo Gomola mo mate dla ha꞉ha꞉lalo sota batalimale koko patoto halomha꞉ha꞉leye na꞉ me-daluwapo. ");
INSERT INTO xla_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Epapedeme na꞉ monolo tulume yia꞉ta koko halomha꞉ha꞉le hapulomaye natilowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Epalati opa dapiyamtetapo God mate A꞉iblaham mate medla ha꞉ha꞉lati yia꞉ tlo ma Sodom mo tiyama dla taiyo. Amasiyama A꞉iblahamtapo God mila꞉pi tle me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Epame A꞉iblahamta Godta hala mateka꞉pi dla tuwame halemama epo atlaiyo, “Na꞉ Lod, wa꞉ bobtalimale so poyumama ka꞉ka꞉dle so mate poyupa꞉? ");
INSERT INTO xla_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Wa꞉ mo edla ka꞉ka꞉dle so opa 50ta ha꞉ha꞉la natimama adipapopa꞉? Wa꞉ mo eye mepele me-yupa꞉? ");
INSERT INTO xla_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Amasiyama na꞉malamana, wa꞉ye ka꞉ka꞉dle so opa mate batalimale so opa mate hatlo godepame po-poyuluwa. Adipalati, wa꞉ye ta꞉lamo so opa hapuloma koko gladlalo oplamipo. Epame wa꞉ye isikimi ka꞉ka꞉dle koko siyapo tlo halomdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Epalati Godta asiyama A꞉iblaham watle epo atlaiyo, “Na꞉tapo Sodom mo dulu dla ka꞉ka꞉dle so opa 50 tlamelepiye, na꞉ yia꞉ yilo mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Epalati asiyama A꞉iblahamta God watle epo atlaiyo, “Lod, na꞉ po-ka꞉dle oplami, na꞉ isikimi ta꞉lamo oplamipo. Amasiyama epapele tlope na꞉ wa꞉ dla yu hale atlowe solotama. ");
INSERT INTO xla_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Wa꞉ mo edla ma isikimi 45 opa ka꞉ka꞉dleta ha꞉ha꞉la natimama wa꞉ mo eye me-yupa꞉?” diyo. Epalati asiyama Godta epo atlaiyo, “Na꞉ 45 opa ka꞉ka꞉dle so natilipiye, na꞉ mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Epalati A꞉iblaham matle God watle epo atlaiyo, “Ame wa꞉ 40 opa ka꞉ka꞉dle so natimama mo eye me-yupa꞉?” diyo. Epalati Godta asiyama ya꞉ watle epo atlaiyo, “40 opa ka꞉ka꞉dle so tlamelepiye, na꞉ yia꞉ yilo mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Epalati A꞉iblaham matle God watle epo atlaiyo, “Lod, wa꞉ na꞉ dla siyalademiya. Adipalati, na꞉ matle wa꞉ watle yu hale atlowe solotama. Ame wa꞉ ka꞉ka꞉dle so opa 30 tlamelepiye, wa꞉ mo eye me-yupa꞉?” diyo. Epalati asiyama Godta epo atlaiyo, “Hao, na꞉ ka꞉ka꞉dle so opa 30 tlamelepiye, na꞉ yia꞉ yilo mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Epame A꞉iblahamta mamisika꞉ God watle epo atlaiyo, “Lod, na꞉ta wa꞉ dla atlanatili yu atlamhala hema wa꞉ ase sikemte alimiya. Amasiyama wa꞉ ka꞉ka꞉dle so opa 20ta mo dulu edla ha꞉ha꞉la natimama wa꞉ mo eye me-yupa꞉?” diyo. Epalati Godta asiyama epo atlaiyo, “20 opata ha꞉ha꞉lepiye, na꞉ yia꞉ yilo mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Epame A꞉iblahamta mamisika꞉ epo atlaiyo, “Lod, wa꞉ta na꞉ dla po-siyaladlalo wekelepiye, na꞉ yu mosukulu tlo wa꞉ dla atlowepo. Wa꞉ opa ka꞉ka꞉dle so 10 siyapota ha꞉ha꞉la natipame mo eye me-yupa꞉?” diyo. Epalati Godta asiyama epo atlaiyo, “Na꞉ ka꞉ka꞉dle so opa 10 ewolo yilo mo eye poyuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Epame Godta A꞉iblaham mate yukamhalaleye medla gudepame ma-tlati A꞉iblaham mape ya꞉ aya dla ilame ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tamila꞉la oloma edla Lotta Sodom mo kosukulli kokoloma tala dla pollati banakaka so dapiyamte, A꞉iblaham mate yukamha꞉ha꞉le sotapo woyapo pumulaiyo. Epalati Lotta yia꞉ natipame yia꞉ hala dla tame heodepo polomama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Na꞉ adulo, wua꞉ aseka na꞉ aya dla hedla puaiya. Epalati na꞉tapo wua꞉ hete howahalomolowe yú tipo puluwepo. Epame wua꞉ wata utula꞉la hatlo na꞉ aya dulu hema hutiyepame ma iyela utulalati wua꞉ta solotamale mo dla tamalaiya,” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Hao, di wata utula꞉la isikimi mo duka haliyamale dla hutiyelowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Amasiyama Lottapo yia꞉ta madipataye me-ha꞉ha꞉pame ya꞉ aya dla eleme hetame daya ilimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Epalati yia꞉ daya mo-depo popa꞉lati Sodom mo opa hapulomata Lot ayaye polomama olostaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Yia꞉ Lot ayaye polemyemama ya꞉ watle epo atlamyaiyo, “Wata tamila꞉la opa dapiyamteta wa꞉ aya dla pumulale soye dia꞉ watle eleme puane. Di solotama, yia꞉ dla namile pasakalo ilimolowama,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Epalati Lotta aya dulu tle alikili dla woyapame kokoloma himomeleme ma opa hapuloma dla epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Namkadulo, wua꞉ batalimale koko ipapele hamiya. ");
INSERT INTO xla_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Na꞉ aya dulu dla na꞉ utukaka ipilatalo dapiyamte me-popa꞉ma. Epedeme na꞉ tame wua꞉ hala dla eleme puluwepo. Epalati wua꞉ta yia꞉ dla solotamale koko me-haiya. Amasiyama wua꞉ opa dapiyamte, na꞉ aya dulu dla popa꞉ iwolo dla batalimale koko hale pohalowa. Adipalati, yia꞉ta na꞉ aya dla asepe pumulalepo. Epedeme na꞉ta yia꞉ye woloma omhallowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Epalati asiyama yia꞉ta epo atlamyaiyo, “Wa꞉ alikili dla gilidene, wa꞉ hadima hallalota꞉? Wa꞉ isikimi asepe oplamita puame hema halema. Wa꞉ta dia꞉ye dokopala depo halemama di koko dla humatlowe poka꞉dena. Ka꞉! Wa꞉ wolomape! Wa꞉ alikili dla po-gilidlalo hallepiye, dita asepe so dla koko halowedeme ape kokoye ma wa꞉ dla sikemte pato halowepo,” demyaiyo. Epame yia꞉tapo Lotye ma alo dla ka꞉stamama ya꞉ aya kokolomaye hauwokokomala yakomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Amasiyama banakaka so opa dapiyamteta haliyamale dla u-ulapo tuwame Lotye hamame aya dulu dla hallumtumama kokoloma tlo himomeliyo. ");
INSERT INTO xla_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Epame yia꞉tapo aya alikili dla ha꞉ha꞉le so opa inomaye usiyepo meliyo, yia꞉tapo aya kokolomaye woloma ponatilalo wekelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Epame banakaka sotapo Lot watle epo atlaiyo, “Godtapo Sodom sota batalimale koko patoto halomha꞉ha꞉leye ma-daluwapo. Epame di watle Sodom moye yula tuluiya duwapo. Epedeme wa꞉ a꞉ya mate epo wa꞉ utukaka mate epo wa꞉ asiyadulo opi mate epo wa꞉ dokodulo mate eleme mo itle hapele alikili dla woyapo tane. Adipalati, Godtapo mo iye yupo hamastlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Epalati Lotta tame ya꞉ utukaka dapiyamte opa dla halopiliwedeme yu hatitipo ha꞉ha꞉le so opa dapiyamte dla epo atlaiyo, “Wua꞉ hapele sillipame mo itle alikili dla wowoyapo taiya. Adipalati, Godta mo iye mo-yuluwedeme amma,” diyo. Amasiyama opa dapiyamte iwolota Lot yu dalemama semte isikimi yia꞉ mate asupumama ammapo diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Epame ala ka꞉yapa alalemtlati banakaka sota Lotye ha꞉ha꞉mama epo atlaiyo, “Wa꞉ hapele wa꞉ a꞉ya mate epo wa꞉ utukaka dapiyamte mate elepame alikili dla woyapo teletane. Adipalati, Godta mo iye yumama wua꞉ mate potimalala depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Amasiyama Lot ala dekelemsela꞉lati banakaka so opa dapiyamteta Lot do mate epo ya꞉llu do mate epo ya꞉ utukaka do mate dla hohopame elepo hapele Sodom mo tle alikili dla woyamaiyo. Adipalati, Godtapo yia꞉ye sikemte malamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Yia꞉ta hapulomatapo ma alikili dla wowoyapo tamha꞉ha꞉lati banakaka oplami haleta yia꞉ watle epo atlaiyo, “Wua꞉ pasakalo malamama alikili dla potaiya. Wua꞉ potamama ma ilame ponatilowa, epame wou mo edla pohedepo ha꞉ha꞉lowa. Amasiyama wua꞉ pasakalo yilo tamali di dla pohetlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Amasiyama Lotta epo atlaiyo, “A, wa꞉ta na꞉ye sikemte polowamama na꞉ pasakaloye gadlepo. Amasiyama wa꞉ ase dita tamali di dla pohetlepo depame ha꞉ha꞉miyo, e pta pateka꞉mu. Di duka dla hetamha꞉ha꞉mama palilala,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Epame Lotta ya꞉ watle mo yemala hale nati-imama epo atlaiyo, “Mo yemala eye pase pateka꞉mu, dita edla hapele ullumtloweye. Epedeme dia꞉ye edla potaiya dene. Epelepiye, dia꞉ popalliwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Epalati banakaka oplamita asiyama epo atlaiyo, “Mope ka꞉dena, epedeme wua꞉ mo yimka꞉mala edla potaiya. Na꞉ mo yemala eye poyuluwa. ");
INSERT INTO xla_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Epapedeme wua꞉ hapele mo yemala edla ullumtaiya. Adipalati, wua꞉ ala mo e po-umulalo hallati na꞉ta Sodom mo dla koko haloweye po-ala꞉na,” diyo. Epapele koko tle mo yemala eye semama Sowa demdepo. ");
INSERT INTO xla_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Epalati utulalati ikadepe ma-ala꞉himhallati Lotta Sowa mo dla tame woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Epapele oloma edla Godta pepele di tle dlapa aloweli tleka꞉leye Sodom mo mate epo Gomola mo mate dla hamastlati dlapata seseyamama tiyo some heliyo. ");
INSERT INTO xla_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Epalati dlapatapo mo patoto dapiyamte e mate epo dulu edla ha꞉ha꞉lalo so opa mate epame alisisi hapuloma mate epame dali hapuloma mate epo ta꞉la mate hamdepo diskopo tuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Amasiyama Lot ya꞉lluta helestame ma ilame natili oloma edla ya꞉ mototapo solo yepame ewala some kokalepo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","28","Utulala oloma edla A꞉iblahamta ya꞉ta ka꞉yapa God mila꞉pi tle halale mo dla tame halemama koloma isili dla natilati Sodom mo mate epo Gomola mo mate dla namile patotapo bulamhetamhalla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Godtapo wou mo dla ha꞉ha꞉le mo patoto poyumama A꞉iblaham ma sikemte malamaiyo. Epapele koko tle ya꞉tapo Lotye dlapa hamdele dulu tle seme alikili dla woyamaiyo. Amasiyama dlapa etapo Lotta halale mo dapiyamte eye ma-hamdepo hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot mate ya꞉ utukaka mate Sowa mo memeleme ma tamali di dla hetame ha꞉ha꞉iyo. Adipalati, Lotta Sowa mo dla halloweye pta wota꞉iyo. Epedeme yia꞉ tamali di dla hetame teiko hotuwale dulu dla ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Oloma edla Lot yoti patotapo ya꞉la yemala watle epo atlaiyo, “Di aye mo-totoyemala halemtama. Epame dita ha꞉ha꞉ mo hema dita opa halopo yimlala hatitimolowe opaye hawapo. ");
INSERT INTO xla_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Epedeme di ka꞉dena, di aye kawata yú ipame ya꞉ mate hatlope dlowa, di ata dia꞉ tle akimlala hatitimelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Epame utula꞉la oloma edla yia꞉ aye kawata yú ipame yoti pato tatle ya꞉ a seme elaiyo. Epapele dulu dla yotitapo ya꞉ a mate elepo sila꞉tili kokoye ya꞉ ata pomalamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Epame ma alila haleta ya꞉ nanatapo ya꞉la watle epo atlaiyo, “Na꞉ta na꞉ a mate ma-elalepo. Epedeme ma wata utula꞉la kawata yú mamisika꞉ ipame wa꞉ta ya꞉ mate elane, ditapo di a tle yimlala hatitimoloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Epapedeme utula꞉la edla yia꞉ta yia꞉ aye kawata yú mamisika꞉ ipame ya꞉la yemalatapo elemama ya꞉ a seme elaiyo. Amasiyama ya꞉ atapo yoti yemalata ya꞉ mate elepo sila꞉tili kokoye ya꞉ ma pomalamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Epapele koko tle Lottapo ya꞉ utukaka dapiyamte tle yimlala hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yoti patotapo maseyemala hamaiyo, epame ya꞉ hiye Moab, diyo. Epedeme maseyemala itapo Moab so wata ha꞉ha꞉ yia꞉ mama pato halapo. ");
INSERT INTO xla_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Epalati yoti yimka꞉mala mape maseyemala hamaiyo, epame ya꞉ hiye Ben-Ami diyo. Epedeme maseyemala itapo Amon so wata ha꞉ha꞉ yia꞉ mama pato halapo. ");
INSERT INTO xla_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","A꞉iblahamta Mamele mo melepame ma Negeb mo dla tulume Kades mo ka꞉ epame Sul mo ka꞉ duka dla halaiyo. Epame matle Gela mo dla tame halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Edla halemama A꞉iblahamtapo ya꞉llu Selaye opa watle atlemama yotimala diyo. Epalati Gela mo dokopala oplami Abimelekta Selaye sisilamaiyo, ya꞉ta hala dla pulupo depame. Epame ya꞉ aya dla semhetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Amasiyama Godta milamalo tulume Abimelek watle epo atlaiyo, “Wa꞉ polope, adipalati, a꞉ya wa꞉ta sisilapame wa꞉ aya dla semhetaleye mo-oplami walena,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Epapeleye Abimelek ala Sela mate pohatlope dlalo halademe asiyama epo atlaiyo, “Lod, wa꞉ koko pa꞉le isikimi opaye potipa꞉? ");
INSERT INTO xla_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Adipalati, A꞉iblahamtapo Selaye notumala dlati asiyama Sela mape A꞉iblahamye na꞉ bapa duwapo. Epapele koko tle na꞉ta Selaye seme hetamama semte ka꞉dle koko hamapo duwa.” ");
INSERT INTO xla_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Epame Godtapo Abimelek watle milamalo epo atlaiyo, “Na꞉malamana, wa꞉ye ka꞉dle malamale mate koko iye halepo. Epapele koko tle na꞉tapo wa꞉ta ya꞉ kapala umuluwe apiye himomeluwapo. ");
INSERT INTO xla_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Epapedeme wa꞉ a꞉ya eye ma seme ya꞉wolali hala dla telepe. Ya꞉wolaliye na꞉ yu molo atlalo oplamipo. Epedeme ya꞉ta wa꞉ yilo inoma sumale yu na꞉ dla atellepiye, eta wa꞉ye popolowa. Amasiyama wa꞉ta a꞉ya iye ya꞉wolali watle ma ilame posemtlalo wekelepiye, wa꞉ mate epo wa꞉ asiyadulo hapuloma mate pallipe.” ");
INSERT INTO xla_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Epame alila haleta sali ala matamahallati Abimelekta ya꞉ oko so sisilapame ya꞉ dla woyamale koko hapulomaye atlamaiyo. Epalati yia꞉ta koko e dalepame sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Epame Abimelekta A꞉iblaham sisilapame ya꞉ watle epo atlaiyo, “Wa꞉ adipapele kokoye dia꞉ watle hauwa? Epame na꞉ta wa꞉ dla adipapele batalimale kokoye halati asiyama wa꞉tapo na꞉ mate epo na꞉ opa mate dla upiyele koko hamila yakoma꞉? Epedeme wa꞉ta na꞉ dla koko haleye poka꞉dle koko, oplamita epapele koko haloweye. ");
INSERT INTO xla_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ame wa꞉ adipalati ipapele kokoye na꞉ dla hao?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Epalati A꞉iblahamta asiyama epo atlaiyo, “Na꞉ta malamaleta God wowota꞉lalo soye mo hema poha꞉ha꞉mapo duwa. Epame na꞉ta malamaleta opata Sela yilo na꞉ye yumuluwetepo duwa. ");
INSERT INTO xla_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Amasiyama ikadepe kokoye epo elema, Selaye notumala ikadepepo. Adipalati, ya꞉ye na꞉ a yotipo. Epele tlope ya꞉ wai tlo meyelope. Epedeme na꞉ta ya꞉ye hauwapo. ");
INSERT INTO xla_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Epapedeme Godta na꞉ a aya dulu tle na꞉ye ma asepe so mo dla tane dlati na꞉ta Sela watle atlemama epo atluwa, ‘Wa꞉ na꞉ malamama opa hapuloma dla atlamsela꞉mama na꞉ye wa꞉ bapapo demsela꞉lepe,’ duwa.” ");
INSERT INTO xla_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Epalati Abimelekta sipi aliya mate epo bulumkiyawa aliya mate epo ya꞉ oko so opa mate epo wola꞉ mate eleme puame A꞉iblaham watle pomeliyo. Epame matle Selaye ya꞉wolali A꞉iblaham watle homeliyo. ");
INSERT INTO xla_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Epame Abimelekta A꞉iblaham watle epo atlaiyo, “Mo pato iye nolëpo. Epedeme dulu hema wa꞉ta solotamale natipame edla hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Epame ya꞉ta Sela watle epo atlaiyo, “Na꞉tapo wa꞉ oplami watle 1,000 elo mani hamima. Epapele koko tle na꞉ta ikadepe kokoye opa hapuloma dla botomastama. Adipalati, na꞉ta wa꞉ dla koko hale pohana. Epedeme opata wa꞉ koko dla pobatalipo atlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","A꞉iblaham ya꞉llu dla woyamale koko dla Godtapo Abimelek ya꞉llu mate epo ya꞉ aya dulu dla oko halomha꞉ha꞉lalo wola꞉ mateta yimlala hohomolowe apiye godiyo. Epalati A꞉iblahamta God watle inoma sumaiyo, wola꞉ ewolota mamisika꞉ yimlala hatitimelepo depame. Epalati yia꞉tapo ma yimlala hatitimolowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Godta Selaye sikemte polowamama ya꞉ta yu itiyapo himili kokota ikadepe Sela dla woyamelepe diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Epalati Godta sale alila dla Selatapo mopapo polopame A꞉iblaham yami hamaiyo. Amasiyama oloma edla A꞉iblahamye mo-totoyemala ikadepe halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Epalati A꞉iblahamtapo ya꞉ maseyemala hiye Aisek diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Aisek hamale alotle alila 8 pololepame A꞉iblahamta Godta atlale yu e dolumama Aisekye kapala kestaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Epele dulu dla A꞉iblahamye 100 sokomoko oloma dla hallati yami Aisek hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Epame Selata epo atlaiyo, “Godtapo eimela꞉le sepele kokoye na꞉ dla ma-hauwapo. Epedeme opa hapulomatapo koko i dalemama na꞉ mate eimela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Adipalati, yia꞉tapo na꞉ta maseyemala hamolowe koko dla pomalaha꞉ha꞉na. Amasiyama epele tlope A꞉iblahamta mo-totoyemala ikadepe hallati na꞉tapo ya꞉ maseyemala hamalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aisekta ta꞉mtamama meme memellati ya꞉ a A꞉iblahamtapo daya dele pato dinapiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Amasiyama daya dele oloma edla Selata natilati ya꞉ oko a꞉ya Hagaita himili maseyemala Ismaeltapo Aisekye sikemte tetelemsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Selata epapele koko natipame A꞉iblaham watle epo atlaiyo, “Na꞉ oko a꞉ya i mate epo yami mate alikili dla tane dene. Adipalati, na꞉ posolotamasema, Isip a꞉ya e yamita na꞉ maseyemala mate wa꞉ elo dla ha꞉ha꞉mama wa꞉ alisisi omha꞉ha꞉loweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Epalati A꞉iblahamta koko e dalepame sikemte dupa koliyo. Adipalati, Ismael mape yami ikadepepo. ");
INSERT INTO xla_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Amasiyama Godta A꞉iblaham watle epo atlaiyo, “Wa꞉ oko a꞉ya Hagai mate epo yami Ismael mate ase sikemte malamiya. Selata apa kokoye wa꞉ dla atellepiye, wa꞉ koko eye halepe. Adipalati, Aisekta hatitimolowe yimlalatapo wa꞉ mamadulo ikadepe depo ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Epame God matle epo atlaiyo, “Na꞉ wa꞉ oko a꞉ya yami ya꞉ mamadulo mape ma a꞉ma selemalliwepo. Adipalati, ya꞉ mape wa꞉ maseyemalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Epame alila hale utulala ikadepe A꞉iblahamtapo Hagai dla daya mate epo aliya kapala dla yú tili mate ya꞉ maka꞉ dla didiyemelepame ma-taiya diyo. Epalati yia꞉ta madipatata ya꞉ saliyome ma Belseba mo dalupa dulu dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yia꞉ edla tame siyamama yia꞉ta dlalo yúta mo-pokadlati Hagaita yamiye dali yimlala polli tou homale dla pameliyo. ");
INSERT INTO xla_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Epame ya꞉ meyelo pateka꞉mu tiyama dla tame polomama epo malamaiyo, “Poka꞉dena, na꞉ta na꞉ maseyemala mate polomama ya꞉ta polati natiloweye,” diyo. Ya꞉ epo malamama sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Amasiyama Godta maseyemalata amale kokoye daliyo. Epalati pepele di tle God ya꞉ banakaka oplamita Hagai sisilapame epo atlaiyo, “Hagai wa꞉ ase sikemte wota꞉miya, Godta wa꞉ maseyemalata amale kokoye ma-dallepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","“Epedeme wa꞉ sila꞉time tame maseyemala dla sadle hamine. Adipalati, na꞉ta ya꞉ mamadulo alotle ha꞉ha꞉loweye pasatepo mellowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Epame Godta ya꞉ inomaye totowatimalati yú matale natiyo. Epame yú tipo hamtame yami watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Epedeme Ismaelta ta꞉mhetale oloma edla Godta ya꞉ye woloma omhalaiyo. Epame maseyemala etapo dalupa dulu dla halemama aliya sikemte siyomalalo oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ismael ala Palan mo dalupa dulu dla hallati ya꞉ wai Hagaitapo ya꞉lluye Isip a꞉ya natiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Alila haleta Abimelek mate epo opahale so dokopala oplami Pikolo mateta puame A꞉iblaham watle epo atlaiyo, “Wa꞉ta halomhala koko hapuloma dulu dla Godtapo wa꞉ mate halapo. ");
INSERT INTO xla_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Epedeme wa꞉ wata God hi mate yu itiyapo himine, wa꞉tapo na꞉ dla epo na꞉ yimlala dla epo na꞉ mamadulo dla batalimale koko halala depame. Epele dulu dla na꞉tapo wa꞉ta asepe pulati wa꞉ dla ka꞉dle koko siyapo tlo halomhaluwapo. Epedeme wa꞉ ma asiyama na꞉ dla epo na꞉ mo so dla mape ka꞉dle koko siyapo tlo halomhalane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Epalati A꞉iblahamtapo koko edla me-ka꞉pi demama yu itiyapo himiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Epame A꞉iblahamta ma Abimelek watle epo atlaiyo, “Wa꞉ oko sotapo na꞉ta yú kolomale haleye uhauwapo. E poka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Amasiyama Abimelekta ya꞉ watle epo atlaiyo, “Na꞉ koko eye podallalo haluwa, isikimi wata me-dalema. Wa꞉ adipalati ma-hapele na꞉ watle po-atlalo wekuwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Epalati A꞉iblahamtapo sipi aliya mate epo bulumkiyawa aliya mate Abimelek watle hohopo imama yia꞉ta madipatata ma namkale diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Epame A꞉iblahamta matle ya꞉ halo dulu dla sipi aliya molala 7 amkoteta꞉le tlo alikili dla giligilidiyo, Abimelek watle hapilowedeme. ");
INSERT INTO xla_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Epalati Abimelekta natipame epo atlaiyo, “Wa꞉ adipalati wa꞉ sipi aliya 7ye alikili dla ipila꞉i? Ya꞉ dulu koko apata꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Epalati asiyama A꞉iblahamta epo atlaiyo, “Wa꞉ sipi aliya 7 iye hohomane. Adipalati, wa꞉ta aliya i hohomelepiye, eta yú iye ikadepe na꞉ta kolomuwa dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Epapedeme yia꞉tapo mo eye semama Belseba diyo. Adipalati, mo hema opa dapiyamte iwolotapo koko hatlo dla yu itiyapo himpame namkale diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Yia꞉ta yu itiyapo himili alotle Abimelek mate epo Pikolo mate Belseba mo saliyome ma Pilisteya mo dla ilame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Epalati A꞉iblahamta Belseba mo dla dali emomelepame ma kokó halepo hallalo God dla inoma sumama ya꞉ hi di dla ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Epame A꞉iblahamtapo Pilisteya mo medla alila selemalli halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Alila opi alotle Godtapo A꞉iblahamta mikadepe dle natilowedeme ya꞉ sisilamaiyo. Epalati asiyama A꞉iblahamta epo atlaiyo, “Na꞉ ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Epalati Godta epo atlaiyo, “Wa꞉ wa꞉ta sikemte dupa ellalo maseyemala Aisek seme Moliya mo dla tane. Epame edla tamali hale na꞉ta nati-iliwe dla hetame ya꞉ye yumpame na꞉ watle hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Epalati alila hale utulala ikadepe A꞉iblahamta sila꞉time God dla namkale dle alisisi ha꞉lowe dlapa hukulupo ya꞉ donki aliya ko di dla pameliyo. Epo ya꞉ oko so opa dapiyamte mate epo yami Aisek mate eleme Godta ya꞉ watle atlale mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ya꞉ tamama alila dapahatlope pololepo alotle edla Godta ya꞉ watle atlale moye natiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Epalati ya꞉ oko so dapiyamte dla epo atlaiyo, “Wua꞉ta madipatata donki aliya mate medla popa꞉iya. Epalati na꞉tapo na꞉ maseyemala Aisek mate huma tame God hi di dla ta꞉depame ma wua꞉ hala dla ilame puluwepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","7","Epame A꞉iblahamta God dla alisisi ha꞉po hamilowe dlapa bulumaleye Aisek maka꞉ dla asiyomellati ya꞉ta asiyame taiyo. Epalati ya꞉ ata dlapa tele mate epo aipa꞉ya mate halopo taiyo. Yia꞉ta madipatata tamama Aisekta ya꞉ watle epo atlaiyo, “A,” diyo. Epalati asiyama ya꞉ ata epo atlaiyo, “Na꞉ maseyemala, adipamma꞉?” diyo. Epalati Aisekta asiyama epo atlaiyo, “A, na꞉ natima, di dlapa bulumale mate epo dlapa tele mate ma-halopo tamalapo. Amasiyama dita sipi aliya yemala yumpame God hi di dla ta꞉demama ha꞉lowe e da꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Epalati A꞉iblahamta asiyama epo atlaiyo, “God meyelo sipi aliya yemala eye di watle nati-ilipe, dita yumpame God hi di dla ta꞉demama ha꞉loweye,” diyo. Epame yia꞉ta madipatata ma-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yia꞉ta madipatata Godta atlale mo dla tame woyapame ha꞉ha꞉mama A꞉iblahamtapo God dla alinepi poyupo ha꞉lalo tile haiyo. Epame di dla dlapa kolupame ma yamiye dea mate keketipoliyepame dlapa di dla himiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Epame ya꞉ dota ola꞉mtuwame aipa꞉ya haiyo, yami Aisek yumuluwedeme. ");
INSERT INTO xla_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Epalati oloma edla God ya꞉ banakaka oplamitapo pepele di tle ya꞉ watle epo sisilamaiyo, “A꞉iblaham, A꞉iblaham,” diyo. Epalati asiyama A꞉iblahamta epo atlaiyo, “Na꞉ ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Epalati banakaka oplamita epo atlaiyo, “Wa꞉ maseyemala dla koko hale hamama ya꞉ dla wotiyalle hamimiya. Wata oloma hema wa꞉ta God wota꞉le kokoye na꞉ ma-natima. Adipalati, wa꞉ God wota꞉mama wa꞉ maseyemala hatlopeye podatimana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Epame A꞉iblahamta helestame natili oloma edla sipi aliyata dokopala dla pate walleta dukulu dla olopo halla natiyo. Epalati A꞉iblahamta tame aliya eye hampo puame Aisekta elale mo dla himpame yumiyo. Epame God hi di dla ta꞉demama aliya tlo ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Epedeme A꞉iblahamta mo e semama, Godta kokoye dinapelepe, diyo. Epame ma wata oloma hema opata atlemama, God ya꞉ tamali di dla ya꞉tapo koko dinapelepe, demdepo. ");
INSERT INTO xla_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Epame God ya꞉ banakaka oplamita matle A꞉iblahamye sisilamama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Yu iye Godta ipo atlema. Na꞉tapo na꞉ hi tle wa꞉ watle ikadepe koko atlema. Adipalati, wa꞉tapo wa꞉ maseyemala hatlopeye na꞉ watle hamilowedeme podatimana. ");
INSERT INTO xla_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Epapele koko tle na꞉tapo wa꞉ mamaduloye sikemte pasatepo mellowepo. Epalati yia꞉ta pasatamama omapla di dla tamili ha꞉ha꞉ye epapele some ha꞉ha꞉lepe. Epame yia꞉tapo pasatamama yú pili dla asila halemdiye, epapele some ha꞉ha꞉lepe. Epame wa꞉ mamadulotapo sikemte itiyamale mate yia꞉ dla opahale dlalo soye posalepame yia꞉ ta꞉laye kolahademsiyamelepe. ");
INSERT INTO xla_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Epalati na꞉tapo wa꞉ mamadulo tle ta꞉la so hapuloma dla siyele hampulupe. Ame adipalati, wa꞉tapo na꞉ yu dla salladuwa koko tle,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Epame A꞉iblaham ma ilame tame ya꞉ oko so mate yimkata Belseba mo dla taiyo. Epame A꞉iblahamtapo mo medla me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Koko i gudlati alotle A꞉iblahamtapo oplami haleta ya꞉ watle yu hamili yu iye me-daliyo, “Wa꞉ ei Nahol ya꞉llu Milkaye akimlala 8 hatitimuwapo.” Epedeme akimlala ewolo hiye ipo, Us, epo Bus, epame Alam ya꞉ a Kemuwel, epo Kesed, epo Haso, epo Pildas, epo Yidalap epame Betuwel. Epalati Betuweltapo Lebekaye himiyo. ");
INSERT INTO xla_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Epame Naholtapo ma a꞉ya hale Leuma hapame ma akimlala 4 hatitimaiyo. Yia꞉ hiye ipo, Teba, epo Gaham, epo Tahas, epo Maka. ");
INSERT INTO xla_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Selaye sokomoko 127 halepo gudepame Kiliyat Alba mo dla powaiyo. Mo hatlo i ya꞉ hi haleye Heblonpo. Amasiyama mo iye Keinan mo pato dulu dla elapo. Epalati A꞉iblahamtapo ya꞉lluta powale koko dla sikemte dupa kolomama amsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Epame A꞉iblahamtapo ya꞉llu powale motota elale aya dulu tle alikili dla woyapame Hitai so opa dla tame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Na꞉ye mo hale oplamita ma wua꞉ mo hema isikimi asepe puame halapo. Epedeme wua꞉ na꞉ watle ta꞉la nati-iya, na꞉ epalati asiyama mate ta꞉la e hapame na꞉ a꞉ya motoye hamatilowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Epalati opa ewolota asiyama ya꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“A, wa꞉ di yu dalene. Wa꞉ye ikadepe diamkale ikadepepo. Di wa꞉ta wa꞉ allu moto hamatilowe ta꞉la koko dla po-alliwa. Amasiyama mowolo di mo hema ta꞉la ka꞉dle natipame wa꞉ a꞉ya moto edla hamatine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Epalati A꞉iblahamtapo yia꞉ mila꞉pi tle heodepame yia꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","“Na꞉ta na꞉ a꞉ya hema hamatilowe dla wua꞉ta solotamelepiye, ka꞉dena, wua꞉ Sohal yami Epolon dla dallanatiya, ya꞉tapo ya꞉ ta꞉la mosukulu gudle dla Makapela mo dla teiko hotuwale elaye na꞉ watle hamilowe depame. Epele dulu dla ya꞉ta ta꞉la asiyama dla adisowa selepiye, na꞉ mesowa himilowepo. Adipalati, na꞉ solotama, na꞉ asiyadulota palilati yia꞉ moto mape medla hatimha꞉ha꞉lowedeme,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Epalati Epolonta mo kosukulli kokoloma tala dla yimkadulo Hitai so mate polomama A꞉iblaham yu dalepame asiyama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Na꞉ a, wa꞉ na꞉ yu dalene. Na꞉ watapo Makapela ta꞉la i mate epame teiko hotuwale mate na꞉ opa mila꞉pi tle wa꞉ watle hamima, wa꞉tapo wa꞉ a꞉ya motoye edla hamatilipo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","13","Epolonta epo atla dalepame A꞉iblahamta opa mila꞉pi tle heodepame opa hapulomata dallepo depame Epolon watle epo atlaiyo, “Namkale, wa꞉ na꞉ yu dalene. Na꞉ solotama, wa꞉ ta꞉la iye asiyama mate hapame na꞉ a꞉ya motoye hamatilowama. Epedeme wa꞉ na꞉ta wa꞉ watle ta꞉la asiyama dla mani hamilati wa꞉ siyele mate hane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Amasiyama Epolonta A꞉iblaham watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Na꞉ a namkale, ta꞉la i ya꞉ asiyamaye 400 elo manipo. Epapele tlope asiyama eye pokoko. Epedeme wa꞉ isikimi tame wa꞉ a꞉ya motoye hamatine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Epalati ta꞉la asiyama dla A꞉iblahamta mo kosukulli kokoloma tala dla popa꞉le so yia꞉ inoma dali tle 400 elo maniye hame Epolon watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Epapele api tle A꞉iblahamtapo Epolon ta꞉la yemala eye haiyo. Ta꞉la edla Makapela teiko hotuwale mate epo dali edla ha꞉ha꞉ mate A꞉iblahamta halomaiyo. Ta꞉la iye Mamele mo tle salita matlalo tiyama dla elapo. Epedeme A꞉iblahamtapo ya꞉llu Sela motoye Makapela mo dla teiko hotuwale dulu dla hamatiyo. ");
INSERT INTO xla_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mo eye ya꞉tapo Hitai so dla asiyama mate hauwapo, ya꞉ asiyadulota palilati hatimha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","A꞉iblahamtapo mo-totoyemala ikadepe halaiyo. Epalati Godtapo A꞉iblahamta halomhalale koko hapuloma dulu dla sikemte gademhalemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Alila haleta A꞉iblahamtapo ya꞉ oko so dokopala oplami sisilapo ya꞉ watle epo atlaiyo, “Na꞉ solotama, wa꞉tapo na꞉ maseyemala Aisekta a꞉ya halowe totamtelepo depame. Epedeme wa꞉tapo ya꞉ta a꞉ya halowe totamtamama Keinan a꞉ya tlo natipo sempulala depame Pepele dimo mate ta꞉lamo mate omhallalo God hi tle yu itiyapo himine. ");
INSERT INTO xla_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Adipalati, na꞉ solotama, wa꞉tapo tame na꞉ta ka꞉yapa haluwa mo dla na꞉ asiya dulu dla a꞉ya hale natipo sempulupo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Epalati asiyama ya꞉ oko oplamita epo atlaiyo, “A꞉ya eta mo hema na꞉ mate puluwe allipiye, na꞉ ma asiyama wa꞉ maseyemala tlo medla semtapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Amasiyama A꞉iblahamta ya꞉ watle epo atlaiyo, “Hao! Na꞉ maseyemalaye mo edla posemtlowa. ");
INSERT INTO xla_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Adipalati, Pepele dimo omhallalo Godtapo na꞉ asiyadulo dulu tle na꞉ye sempuame Keinan mo iye na꞉ mamadulo watle ikadepe hamilowe yu atluwapo. Epedeme God etapo ya꞉ banakaka oplamiye tane dlepe, wa꞉ gadlepo depame. Epalati wa꞉tapo edla tame ya꞉ta gadle tle na꞉ maseyemalata a꞉ya halowe api dinapoloweye ka꞉pi ellepe. ");
INSERT INTO xla_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Amasiyama a꞉ya ipilalo etapo wa꞉ mate puluwe dla posolotamalalo wekelepiye, epalati wa꞉ wa꞉ta God hi tle na꞉ maseyemala ya꞉llu sempuluwe dla mowolo yu itiyapo himi koko itle alikili dla woyamelepe. Amasiyama epapele tlope wa꞉tapo na꞉ maseyemala tlo mo edla posemtlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Epalati A꞉iblaham ya꞉ oko oplamitapo God hi tle yu itiyapo himimama epo atlaiyo, “Na꞉ wa꞉ta na꞉ watle atlale yu e dolumolowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Epalati A꞉iblaham ya꞉ oko oplamitapo ka꞉ka꞉dle alisisi hapuloma kokopame ka꞉mol aliya 10 dla hatitipo taiyo. Ya꞉ tamama Alam Nahalaim mo dla tame heyupo ma A꞉iblaham ya꞉ ei Naholta hallalo mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ya꞉ tame tamila꞉la mo edla woyapame mo alikili dla yú kolomale dla hedlati ka꞉mol aliyata medla hedepo hutiyemyaiyo. Amasiyama oloma eye mo edla ha꞉ha꞉lalo wola꞉ta yú tilimala pumulumdiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Epapedeme ya꞉tapo inoma sumama epo atlaiyo, “Lod, na꞉ dokopala oplami A꞉iblaham ya꞉ God, wa꞉ta A꞉iblaham dla bokotiyapo malahala koko nati-imama na꞉ watle Aisek ya꞉lluye wata nati-ine. ");
INSERT INTO xla_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Adipalati, na꞉ yú kolomale mateka꞉pi hema poloma. Epedeme ipilatalo hapulomata hema yú tilimala pumullupe. ");
INSERT INTO xla_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Na꞉ epalati yia꞉ watle yú dallowama. Epalati ipilalo hale antapo na꞉ watle yú tipo hamipame ma na꞉ ka꞉mol aliya dla yú ilimelepiye, na꞉ epalati edla malanatilowepo, wa꞉ta Aisek ya꞉llu saleye. Epapedeme kokota woloma ipo ka꞉pi ellepiye, na꞉ etle malanatilowepo, wa꞉ta na꞉ dokopala oplami A꞉iblaham dla bokotiyapo malamale himhalaye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ya꞉ ala inoma sumpollati ipilalo hale Lebekata yú tiliwedeme eto hampula natiyo. Ya꞉ye A꞉iblaham ya꞉ ei Nahol yami Betuwel yotiyo. Amasiyama ya꞉ awaye Milkayo. ");
INSERT INTO xla_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","A꞉ya ipilalo iye pta ka꞉piyo, epame ya꞉ oplami koko yeliyeiyo. Epeleye ya꞉ta puame yú kolomale dla yú tipo hetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Epalati A꞉iblaham ya꞉ oko oplamita ya꞉ natipame ya꞉ hala dla hapele puame epo atlaiyo, “Notumala namkale, na꞉ yú sikemte ta꞉ma, na꞉ yú hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Epalati asiyama ya꞉ta yú tipo halale metlo ya꞉ dla haiyemama epo atlaiyo, “A, yú dene,” diyo. Epalati ya꞉tapo yúye deiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ya꞉ta yú depo gudlati a꞉ya ipilalota ya꞉ watle epo atlaiyo, “Na꞉ wa꞉ ka꞉mol aliya mape yú tipo ilimolowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Epame ya꞉tapo ka꞉mol aliyata yú dloweye aliyata yú dlalo ita dla yú tilipo puame sisimamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Amasiyama A꞉iblaham ya꞉ oko oplamita woloma polomama a꞉yata koko hamsela꞉ tlo ompolaiyo, ya꞉ta halowe kokoye Godta mo-dinapota꞉ depo malanatilowedeme. ");
INSERT INTO xla_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ka꞉mol aliyata yú dlopo gudlati A꞉iblaham ya꞉ oko oplamita gold ewalata ka꞉pi dinapele yiyeleye ya꞉ mu opokoko dla guludepame ma gold ewalata ka꞉pi tili seipase patotoye ya꞉ do dla didiyemeliyo. ");
INSERT INTO xla_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Epo halemama ya꞉ watle epo atlaiyo, “Namkale notumala, wa꞉ a hiye anata꞉? Epame wa꞉ a aya dulu dla alupoli elema꞉, na꞉tapo na꞉ mate pumulale so iwolo mate tame hutiyeloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Epalati asiyama a꞉ya ipilalota epo atlaiyo, “Na꞉ aye Nahol yami Betuwelpo, epalati na꞉ awaye Milkapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Epame ma epo atlaiyo, “Yao ka꞉dena, dia꞉ dla ka꞉mol aliyata dlowe dayaye me-hutiyema. Epame wua꞉ta hutiyelowe aya alupoli ma me-elema,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Epalati oko oplamita God mila꞉pi tle alumata akukumpolomama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Lod, na꞉ dokopala oplami A꞉iblaham ya꞉ God, na꞉ wa꞉ dla siyema. Adipalati, wa꞉tapo na꞉ dokopala oplami A꞉iblaham dla yu itiyapo himili e dolumama na꞉ye woloma sempuame ya꞉ asiyadulo ikadepe dla woyamalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Epame Lebekata ilame kukulumtame ya꞉ aya dulu dla ha꞉ha꞉ so dla koko iye atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Epalati Lebeka ya꞉ bapa Labantapo Lebekata didiyepo puale gold alisisi tlapame epo A꞉iblaham ya꞉ oko oplamita Lebeka watle atlale yuye dalepame oplami eye salataiyo. Ya꞉ tame natilati oplami etapo ya꞉ ka꞉mol aliya mate yú kolomale mateka꞉pi dla hallati natiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Epalati ya꞉ watle epo atlaiyo, “A namkale, Godta wa꞉ye gaduwapo. Epele tlope wa꞉ adipapalati alikili hema halema꞉? Na꞉ mate aya dla puane. Adipalati, na꞉tapo wua꞉ta hutiyelowe aya mate epo wua꞉ ka꞉mol aliyata hutiyelowe aya mate ma-dinapopo pua,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Epalati A꞉iblaham ya꞉ oko oplamitapo ya꞉ mate tame aya dulu dla tuwaiyo. Epame Laban ya꞉ opata ka꞉mol aliya tama di dla hutiyele alisisiye alikili dla hatitipame yia꞉ye daya ilimaiyo. Epame A꞉iblaham ya꞉ oko oplami mate epo ya꞉ mate pumulale so mate dla yú tipo hamiyo, yia꞉tapo yia꞉ hete howahalomelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Epame Labantapo yia꞉ watle daya halopo pulati A꞉iblaham ya꞉ oko oplamitapo epo atlaiyo, “Na꞉ yipta daya podlowa. Amasiyama na꞉ta puale koko tatle atlepo gudepame daya dlowepo,” diyo. Epalati Labanta epo atlaiyo, “Yao, atlane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Epalati ya꞉ta epo atlaiyo, “Na꞉ye A꞉iblaham ya꞉ oko oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Godtapo A꞉iblahamye sikemte gademhallati ya꞉tapo wata oloma hema alisisi sikemte pasatale oplami halapo. Epo Godta ya꞉ dla sipi aliya mate epo gaut aliya mate epame bulumkiyawa aliya mate epame mani mate epo ya꞉ oko so opa mate wola꞉ mate epo ka꞉mol aliya mate epo donki aliya mate hapuloma hapiwapo. ");
INSERT INTO xla_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","A꞉iblaham ya꞉lluye ma alluyemala ikadepe halemama maseyemala hamalati A꞉iblahamtapo maseyemala e watle ya꞉ alisisi hapuloma halopiwapo. ");
INSERT INTO xla_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Epame ya꞉ta a꞉ya halowe koko dla ma na꞉ watle epo atluwa, ‘Wa꞉tapo na꞉ maseyemalata a꞉ya haloweye Keinan mo a꞉yaye sempulala depame God hi tle yu itiyapo himine. ");
INSERT INTO xla_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Amasiyama wa꞉ na꞉ a ya꞉ asiyadulo dla tame na꞉ maseyemala Aisek ya꞉llu natipo sempuane,’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Epalati asiyama na꞉ta ya꞉ dla epo atluwa, ‘A꞉ya ipilalo eta na꞉ mate puluwe allipiye, na꞉ adipapopa꞉?’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Epalati asiyama ya꞉ta epo atluwa, ‘Na꞉ta mikadepe dlalo Godtapo ya꞉ banakaka oplamiye wa꞉ mate tane dlepe, wa꞉ gadlepo depame. Epalati wa꞉tapo na꞉ maseyemala Aisek ya꞉lluye na꞉ opa ikadepe dulu dla natilipe. ");
INSERT INTO xla_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Epedeme wa꞉ tame na꞉ opa dla woyamalati yia꞉ta wa꞉ watle na꞉ maseyemala ya꞉lluye hamame iliwe allipiye, mowolo yu itiyapo himi koko hema pase sikemte pomalamolowa,’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Epalati na꞉tapo wata yú kolomale dla puame polomama God dla epo inoma sumale yu atla, ‘Lod, na꞉ dokopala oplami A꞉iblaham ya꞉ God, na꞉ wa꞉ dla otele yu himima, wa꞉tapo Aisek ya꞉lluye na꞉ watle nati-ilipo depame. ");
INSERT INTO xla_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Epedeme a꞉ya ipilalota yú tila pulati na꞉tapo ya꞉ watle yú dallowepo. ");
INSERT INTO xla_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Epalati ya꞉tapo na꞉ watle yú tipo hamipame na꞉ ka꞉mol aliya ma yú ilimelepiye, na꞉ epalati malamolowepo, a꞉ya ipilalo eye na꞉ dokopala oplami yami Aisek ya꞉llupo,’ de. ");
INSERT INTO xla_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Na꞉ ala woloma me-inoma sumpollati Lebekata pakasiyamalalo ya꞉ eto hame medla pua. Ya꞉ yú kolomale dulu dla tulume yú tipo matlati na꞉ta ya꞉ watle epo atla, ‘Namkale na꞉ yú hamine,’ de. ");
INSERT INTO xla_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Epalati ya꞉tapo ya꞉ eto maka꞉ di dla polaleye na꞉ watle haiyemama, yú i tlo dene de. Epame ma ya꞉tapo na꞉ ka꞉mol aliya ma yú ilimili de. Epapedeme na꞉ yú e ma-de, epo na꞉ ka꞉mol aliya mape yú me-ilima. ");
INSERT INTO xla_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Epame na꞉ta ya꞉ watle, wa꞉ a anata꞉ dlati ya꞉ta epo atla, ‘Na꞉ aye Nahol yami Betuwelpo, epalati na꞉ awaye Milkapo,’ de. Epalati na꞉tapo gold ewalata mita꞉pele yiyeleta ya꞉ mu opokoko dla guludepame ma gold seipase mape ya꞉ do dla didiyemele. ");
INSERT INTO xla_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Epame na꞉tapo alumata akukulumpolomama na꞉ dokopala oplami A꞉iblaham ya꞉ God dla siyele yu hami. Adipalati, ya꞉tapo api duka dla na꞉ye sempuwapo, na꞉tapo na꞉ dokopala oplami yami ya꞉lluye woloma ya꞉ opa ikadepe dulu dla natilipo depame. ");
INSERT INTO xla_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Epapedeme namkadulo, wua꞉ adipo malama꞉? Wua꞉ na꞉ dokopala oplamita atlale yuye ka꞉dena dema꞉? Wua꞉ dla yu hale ellepiye, na꞉ atlaiya. Epalati asiyama na꞉ta koko haloweye woloma momalamolowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Epalati Laban mate Betuwel mate koko i dalepame epo atlaiyo, “Koko iye God tle puapo. Epedeme dia꞉ dla koko hale atlowe hawa. ");
INSERT INTO xla_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Epedeme wa꞉ Lebeka iye me-semtane. Adipalati, ka꞉dena, ya꞉tapo Godta dinapele koko dolumama wa꞉ dokopala oplami yami haloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Epalati A꞉iblaham ya꞉ oko oplamita yia꞉ yu e dalepame alumata akukulumpolomama ya꞉ mila꞉pita ta꞉la dla gudemama God dla siyele ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Epame goldta mimita꞉pele alisisi mate epo silbata mimita꞉pele alisisi mate epo kapala alisisi mate Lebeka dla halopiyo. Epame namkale dle alisisi opi ka꞉ka꞉dle halopame Lebeka ya꞉ wai watle epo ya꞉ bapa watle dla halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Koko ita gudlati yia꞉ta hapulomatapo daya dlopo aya medla hutiyeiyo. Yia꞉ epo utulalati sillipame A꞉iblaham ya꞉ oko oplamita epo atlaiyo, “Di ma ilame na꞉ dokopala oplami hala dla mo-tlowe ka꞉deta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Amasiyama Lebeka ya꞉ wai mate epo ya꞉ bapa mateta epo atlaiyo, “Hao, wua꞉ aseka dia꞉ mate alila 10 epapele ha꞉ha꞉po gudepame tamalaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Amasiyama A꞉iblaham ya꞉ oko oplamita epo atlaiyo, “Wua꞉ na꞉ hammiya. Godta na꞉ta puwa kokoye ma-ka꞉depo dinapopo meluwapo. Epedeme na꞉ ka꞉dena, na꞉ dokopala oplami hala dla ma ilame tloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Epalati Lebeka ya꞉ wai mate epo ya꞉ bapa mateta epo atlaiyo, “Di aseka amseyemala sisilapame ya꞉ta solotamale koko atla dallowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Yia꞉ epame Lebekaye sisilapame ya꞉ watle atlanatiyo, “Wa꞉ oplami i mate tlowe solotama꞉?” diyo. Epalati asiyama Lebekata epo atlaiyo, “Yao, na꞉ ya꞉ mate mo-tlowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Epalati yia꞉tapo Lebekaye ya꞉ nomopi mate opa ewolo mate taiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Epalati yia꞉tapo Lebeka yilo inoma sumama epo atlaiyo, “Wa꞉ opa hapuloma yia꞉ wai hallepe. Epame wa꞉ awadulotapo yia꞉ dla opahale dlalo soye posalemha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Epame Lebeka mate epo ya꞉ gadlalo ipilatalo mate ka꞉mol aliya di dla yia꞉ alisisi mate hetame tamalemama A꞉iblaham ya꞉ oko oplami mate taiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Alila oloma edla Aisektapo Bel Lahai Loi mo saliyome ma Negeb mo dla tame halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ya꞉ edla halemama tamila꞉la haleta isikimi mo haliyamale dla holomsela꞉la taiyo. Epo holomsela꞉mama natilati ka꞉mol aliyata pumulla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Amasiyama Lebeka mape pateka꞉mu tle Aisek natipame ka꞉mol aliya di tle ta꞉la dla pestatuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Epame A꞉iblaham ya꞉ oko oplami watle epo atlaiyo, “Oplami e anta di natilowedeme ta꞉la api pumhalema꞉?” diyo. Epalati asiyama A꞉iblaham ya꞉ oko oplamita epo atlaiyo, “Oplami eye na꞉ dokopala oplami Aisekta puapo,” diyo. Epalati Lebekata tluka hapame ya꞉ mila꞉pi bopudiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Yia꞉ tame Aisekye umpo oko oplamitapo ya꞉ watle ya꞉ta tame koko hauwa hapulomaye esemaiyo. ");
INSERT INTO xla_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Epame Aisekta Lebekaye seme ya꞉ wai Selata halale aya dla semtaiyo. Epame yia꞉ta madipatata ma-halomaiyo. Epame oloma edla Aisekta ya꞉llu Lebeka dla sikemte malamale himmama asiyama ya꞉ waita powale koko dla dupa kolle pase himiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","2","A꞉iblaham ya꞉llu Selata powale alotle A꞉iblahamtapo ma a꞉ya hale Ketula hapame akimlala opi hatitimaiyo. Akimlala ewolo hiye ipo, Simlan, epo Yoksan, epo Medan, epo Midiyan, epo Isbak, epo Suwa. ");
INSERT INTO xla_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Epapeleye Yoksantapo Seba mate epo Dedan mate hatitimaiyo. Epedeme Dedan ya꞉ mamaduloye Asul sopo, epo Letu sopo, epo Leom sopo. ");
INSERT INTO xla_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Amasiyama Midiyan ya꞉ akimlalaye ipo, Epa, epo Epel, epo Hanok, epo Abida, epo Elda. Asiya hapuloma iwoloye Ketula ya꞉ awadulopo. ");
INSERT INTO xla_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","A꞉iblahamtapo ya꞉ alisisi hapulomaye ya꞉ elo dla hallalo maseyemala Aisek watle halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Epame ya꞉ ma ala popolalo halemama Hagai mate epo Ketula mateta hatitimale akimlala dla namkale dle alisisi halopiyo. Epame yia꞉ye ya꞉ elo ikadepe dla hallalo maseyemala Aisek tle alikili a꞉ma salita matlalo tiyama dla taiya, diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Epapedeme A꞉iblahamtapo 175 sokomoko halepo gudepame sikemte totoyemala oloma dla halemama powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Epalati ya꞉ akimlala dapiyamte Aisek mate epo Ismael mateta ya꞉ye ya꞉llu Sela hamatili Mamele mo mateka꞉pi Makapela teiko hotuwale dulu medla hamatiyo. Epapeleye wabasi iye A꞉iblaham meyelo Hitai oplami Sohal yami Epolon tle haiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","A꞉iblahamta powale alotle Godtapo maseyemala Aisek dla siyemama ka꞉ka꞉dle kokoye halopiyo. Epalati ya꞉tapo tame Bel Lahai Loi mo dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismaelye A꞉iblaham ya꞉llu Sela ya꞉ oko a꞉ya Hagaita himili maseyemalapo. ");
INSERT INTO xla_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Epapedeme Ismael ya꞉ akimlalaye ipo, Nebayot, epo Kedal, epo Adibel, epo Mibsam, ");
INSERT INTO xla_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","epo Misima, epo Duma, epo Masa, ");
INSERT INTO xla_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","epo Hadad, epo Tema, epo Yetul, epo Napis, epame Kedema. ");
INSERT INTO xla_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismael ya꞉ akimlala 12 iwolotapo elele 12 sitali ha꞉ha꞉po. Yia꞉ta ha꞉ha꞉le mo hi mape opa iwolo hi tlo sasalemaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Epedeme Ismaeltapo 137 sokomoko halepo gudepame powaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Epalati Ismael ya꞉ mamadulotapo Habila mo tle ha꞉ha꞉mtamama Sul mo dla tame gudiyo. Yia꞉ta ha꞉ha꞉ mo iye Isip mo mateka꞉pi, Asul mo dla tlalo api dla halapo. Yia꞉ edla ha꞉ha꞉mama A꞉iblaham ya꞉ mamadulo opi hapuloma mate opahale demha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","20","A꞉iblaham yami Aisekta 40 sokomoko oloma dla halemama Padan Alam mo dla hallalo Alam oplami Betuwel yoti Lebekaye haiyo. Amasiyama Lebeka ya꞉ bapaye Labanpo. ");
INSERT INTO xla_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Lebekata hamkapi pollati ya꞉wolali Aisekta God dla inoma sumale yu himhallati Godta daliyo. Epalati Lebekata mopapo mo-polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Epalati Lebeka mopapo koko dulu dla akimlala dapiyamteta popa꞉iyo. Yia꞉ta dapiyamtetapo ya꞉ koko dulu dla nalatimpopa꞉mama humsiyamaiyo. Epalati Lebekata epo atlaiyo, “Yimlala iwoloye adipapalati na꞉ koko dulu dla nalatimpopa꞉ma꞉?” diyo. Epapele koko tle ya꞉tapo God dla dalla natilati asiyama Godta epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","“Opa alumale dapiyamtetapo wa꞉ koko dulu dla popa꞉po. Alumale dapiyamte ewolotapo wa꞉ koko dulu tle wowoyapo ha꞉ha꞉mama yia꞉ dulu dla opahale demha꞉ha꞉lepe. Yia꞉ta dapiyamteta epo opahale demha꞉ha꞉le dulu dla haletapo itiyamale mate hallati asiyama haletapo pase itiyamale mate hallowa. Epedeme ya꞉ bapatapo ya꞉ ei yu dla salladepo sela꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Owayemala hamolowe alilata mo-pulati Lebekatapo akimlala dapiyamte hohomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Itapu puale maseyemala ya꞉ kapalaye sikemte omteka꞉piyo, epame dlalo ma sikemte wokasemaiyo. Epapedeme yia꞉tapo ya꞉ hiye Iso diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Epalati ya꞉ ko tle puale maseyemalatapo Iso hete maku dla hamame elaiyo. Epalati yia꞉tapo ya꞉ hiye Yokob diyo. Aisekta 60 sokomoko hallati akimlala dapiyamte iwoloye hohomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Akimlala dapiyamte iwolota teta꞉le dulu dla Isotapo alila hapuloma dla moku dla yetetalemsela꞉mama alinepi sikemte siyomalalo halaiyo. Amasiyama Yokobye homta hallalo oplami halemama isikimi hatlo aya dla halemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisektapo Isoye sikemte malamdiyo. Adipalati, Isota alinepi siyopo pulati demama ka꞉pi demdiyo. Amasiyama Lebekatapo Yokob tlo sikemte malamdiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Alila hale dla Yokobtapo tiyokona opo ha꞉mhalaiyo. Epalati Isota to hamtaleta pumama daya sikemte ta꞉le mate puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Epalati ya꞉tapo ya꞉ ei Yokob watle epo atlaiyo, “Na꞉ ya꞉mkale, daya ta꞉mama pola yakoma. Epedeme wa꞉ tiyokona opo omteka꞉pele eye na꞉ watle hamine,” diyo. Epapele koko tle Iso ya꞉ hi haleye Edom demdepo. ");
INSERT INTO xla_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Epalati Yokobta asiyama epo atlaiyo, “Ka꞉dena, na꞉ wa꞉ watle hamilowepo. Amasiyama wa꞉ ka꞉yapa wa꞉ta di a elo dla halemama ya꞉ alisisi hapuloma omhallowe itiyamale hamhalaye na꞉ watle hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Epalati Isota asiyama epo atlaiyo, “Na꞉ daya ta꞉mama mo-pola yakomapo. Epedeme na꞉ta na꞉ a alisisi omhallowe itiyamale na꞉ dla ela ita apa koko ka꞉dle na꞉ dla hamipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Epalati asiyama Yokobta epo atlaiyo, “Wa꞉ ikadepe na꞉ watle me-hamili demama God hi tle yu itiyapo himmama atlane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Epalati Isota ya꞉ yu dla tulumama ya꞉ ata ya꞉ watle ya꞉ alisisi omhallepo depo itiyamale hamiliye ma ya꞉ ei Yokob watle hamiyo. Epalati asiyama Yokobtapo ya꞉ watle tiyokona opo mate epo daya mate hapiyo. Epame Isota daya ma-depo gudepame sila꞉time taiyo. Epapele koko tle Isotapo ya꞉ ata ya꞉ watle ya꞉ alisisi omhallepo depo itiyamale hamiliye pokoko diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A꞉iblahamta halale oloma edla sali pato silapomama daya pa꞉le kokota pualeye, epapele kokotapo ma mo edla puaiyo. Epalati Aisektapo Pilisteya so yia꞉ dokopala oplami Abimelekta hala mo Gela dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Adipalati, Godta ya꞉ dla woyapo epo atlaiyo, “Wa꞉ Isip mo dla potlowa. Amasiyama wa꞉tapo na꞉ta wa꞉ watle halane dle mo hatlo medla halane. ");
INSERT INTO xla_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Wa꞉ta edla hallati na꞉tapo wa꞉ mate halemama wa꞉ gademhallowepo. Epame na꞉tapo wa꞉ a A꞉iblaham dla yu itiyapo himiwaye e dolumama mo eye wa꞉ dla epo wa꞉ mamadulo dla hamilowepo. ");
INSERT INTO xla_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Epame na꞉tapo wa꞉ mamaduloye ma-a꞉ma pasatepo mellowepo. Yia꞉tapo omapla di dla tamilita wokasepo elemdiye, epapele some pasatame ellepe. Epame na꞉tapo ta꞉la pato iye yia꞉ watle hamilowepo. Epalati ta꞉lamo meyelope meyelope dle sotapo yia꞉ tle siyele halepe. ");
INSERT INTO xla_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Epedeme na꞉tapo koko iye halowepo. Adipalati, wa꞉ a A꞉iblahamtapo na꞉ yu mate epo na꞉ta aiyalma hatitimale mate woloma ka꞉pi dolumhaluwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Epapedeme Aisektapo Godta atlale yu dalepame Gela mo dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Epapele dulu dla Aisek ya꞉llu Lebekaye a꞉ya pta ka꞉piyo. Epapeleye Gela mo edla ha꞉ha꞉lalo opatapo ya꞉ watle epo atlaiyo, “A꞉ya iye wa꞉ alluta꞉?” diyo. Epalati Aisektapo mo so opata Lebeka halowedeme ya꞉ye yumulala depame wota꞉mama isikimi yia꞉ watle epo atlaiyo, “A꞉ya iye notumalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Amasiyama alila opi mo-pololepo alotle Pilisteya so yia꞉ dokopala oplami Abimelektapo toko mosisi kokoloma tle natitepo Aisektapo ya꞉llu Lebeka hulumhalla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Epalati ya꞉tapo Aisek sisilapame ya꞉ watle epo atlaiyo, “Lebekaye wa꞉ allu ikadepepo. Ame wa꞉ adipalati dia꞉ dla isikimi mala-atlemama Lebekaye notumala duwa?” Epapalati asiyama Aisekta ya꞉ watle epo atlaiyo, “Na꞉ta malamaletapo mo so opata na꞉ a꞉ya halowedeme na꞉ye yumulala depo apuwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Epalati asiyama dokopala oplami Abimelektapo ya꞉ watle epo atlaiyo, “Wa꞉ adipapalati epapele koko hamama dia꞉ dla mala-atluwa? Epapele dulu dla na꞉ mo so oplami haletapo wa꞉ alluye seme tame elematiye, mowolo batalimale koko halë itapo ma dia꞉ dla wotiyalle hamilimla,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Epame dokopala oplamitapo haliyamale dla imale yu hamimama epo atlaiyo, “Oplami antapo Aisek dla epame ya꞉llu dla wotiyalle hamilipiye, oplami eye polowe dla himilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Epedeme Aisektapo mo edla halemama dlowe alisisi emaiyo. Epalati Godta gadle tle ya꞉tapo emale alisisiye sikemte pasatale hauwaliyo. ");
INSERT INTO xla_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Epapele koko tle ya꞉tapo alisisi sikemte pasatepo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Epame ya꞉tapo ya꞉ aliya halo sikemte pasatepo halemama ya꞉ oko so mape sikemte pasatale halaiyo. Epalati Pilisteya sotapo koko i natipame ya꞉ dla elle pato himiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Epammama yia꞉tapo Aisekta yú dlalo hapulomaye ma ta꞉lata kakapulomtaiyo. Yú kokolomale iye Aisek ya꞉ a A꞉iblaham ya꞉ oko sotapo kokolomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Epapalati dokopala oplami Abimelektapo Aisek watle epo atlaiyo, “Wa꞉tapo dia꞉ dulu dla sikemte itiyamale mate halemama alisisi pasatepo halema. Epapedeme wa꞉ mo itle alikili a꞉ma woyapo tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Epalati Aisektapo mo etle alikili a꞉ma woyapo tame ma Gela kikiwi isili wou dla tulume halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ya꞉ epame yú kokolomale Pilisteya sota kakapulomtaleye mamisika꞉ kokolomtaiyo. Epame ya꞉ a A꞉iblahamta yú kokolomale edla hi halopili hi hatlo metlo ma halopimtaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Epapeleye alila haletapo Aisek ya꞉ oko sotapo koloma kikiwi isili dla yú amko kolomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Amasiyama Gela mo dla aliya omha꞉ha꞉lalo sotapo Aisek ya꞉ oko so mate yú kolomale e datimama yu topuloliyo. Epapedeme Aisektapo yú kolomale e ya꞉ hiye semama Esek diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Epalati Aisek ya꞉ oko sotapo ma yú hale kolomaiyo. Amasiyama Gela mo dla aliya omha꞉ha꞉lalo sota yú kolomale e ma yia꞉ta datimama yia꞉ mate yu topuloliyo. Epapele koko tle Aisektapo yú kolomale hale e ya꞉ hiye semama Sitna diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Epame yia꞉ ma etle tame yú hale kolomaiyo. Amasiyama yia꞉ yú kolomale hema yu potopulollalo wekiyo. Epalati Aisektapo yú kolomale e ya꞉ hiye semama Lehobot diyo. Epapedeme Aisektapo epo atlaiyo, “Godtapo dia꞉ watle ha꞉ha꞉lowe mo patoye ma-hamilipo. Epedeme ditapo hema ha꞉ha꞉mama woloma ka꞉depo ha꞉ha꞉lowepo.” ");
INSERT INTO xla_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Epame Aisektapo mo edla halepame ma Belseba mo dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Epapeleye ya꞉ edla hetame woyamale utula꞉la oloma edla Godtapo ya꞉ watle tulume epo atlaiyo, “Na꞉ye wa꞉ a A꞉iblaham ya꞉ Godpo. Wa꞉ ase sikemte wota꞉miya! Na꞉tapo wa꞉ mate halemama wa꞉ gademhallowepo. Epapedeme na꞉tapo wa꞉ a A꞉iblaham dla yu itiyapo himiwa eye dolumama wa꞉ mamaduloye pasatepo mellowepo.” ");
INSERT INTO xla_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Epalati Aisektapo tile hapame God dla namkale dle alinepi poyupo ha꞉mama God dla inoma sumama ya꞉ hi di dla ta꞉diyo. Epame mo edla kimtipo ha꞉ha꞉mama ya꞉ oko sotapo yú hale kolomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Epapeleye Aisektapo Belseba mo dla hallati Gela mo dokopala oplami Abimelekta ya꞉ hala dla pumama opa dapiyamte mate puaiyo. Oplami haleye ya꞉ gadlalo, ya꞉ hiye Ahusat. Epalati oplami haleye opahale so dokopala oplami Pikolo. ");
INSERT INTO xla_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Amasiyama Aisektapo yia꞉ watle epo atlaiyo, “Wua꞉ adipalati na꞉ natila pumulo? Na꞉tapo wua꞉ mo dla hallati wua꞉tapo na꞉ye alikili a꞉ma dodolomuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Epalati asiyama yia꞉tapo epo atlaiyo, “Dimalamana, Godtapo wa꞉ mate halapo. Epedeme di solotama, wa꞉tapo dia꞉ mate po-opahale dlalo, isikimi sadepo hallepo depame solotamale yuye wa꞉ mate himila pumula. ");
INSERT INTO xla_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Epapedeme ditapo wa꞉ dla wotiyalle pohamilalo wekuwaye, epammama wa꞉ ma asiyama dia꞉ dla wotiyalle pohamilalo wekelowedeme yu itiyapo himine. Adipalati, wa꞉tapo dia꞉ mate hallati ditapo wa꞉ye woloma omha꞉ha꞉pame sadle mate wa꞉ye alikili a꞉ma woyamane duwapo. Epedeme dimalamana, Godtapo wa꞉ dla sikemte siyemhalemama wa꞉ gademhalapo.” ");
INSERT INTO xla_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Epalati Aisektapo daya dele pato dinapopame yimkata daya deiyo. ");
INSERT INTO xla_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Epame utulala ikadepe dla Aisek mate epo dokopala oplami Abimelek mate asiyama God hi tle yu itiyapo himi himi demama epo atlaiyo, “Di yimkata woloma sadle mate ha꞉ha꞉lowepo,” diyo. Epame alotle Aisektapo yia꞉ye sadle mate ma-taiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Alila hatlo medla Aisek ya꞉ oko sotapo puame ya꞉ watle epo atlaiyo, “Di yú amkoye koloma,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Epalati Aisektapo yú kolomale eye semama Siba diyo. Epapele oloma etle kotiyapo pumama Siba yú kolomale mateka꞉pi dla hala moye wata oloma hema semama Belseba demha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Epapeleye Aisek yami Isotapo 40 sokomoko umulati ya꞉tapo Hitai mo so wola꞉ dapiyamte halomaiyo. Epedeme ya꞉llu haleye Beli yoti Yuditpo. Epalati ma ya꞉llu haleye Elon yoti Basematpo. ");
INSERT INTO xla_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Epapele dulu dla wola꞉ dapiyamte iwolotapo Aisek mate epo Lebeka mate dla pasakalo kokalleye hampuaiyo. ");
INSERT INTO xla_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Epapedeme Aisektapo mo-totoyemala halemama inoma pa꞉po halaiyo. Epapele oloma dla ya꞉tapo ya꞉ maseyemala itapu hamale Iso sisilapame ya꞉ watle epo atlaiyo, “Na꞉ maseyemala,” diyo. Epalati asiyama Isotapo epo atlaiyo, “Yao, a, atlane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Epalati ya꞉ atapo ya꞉ watle epo atlaiyo, “Na꞉ mo-totoyemala halemama mo-polowe mateka꞉pi dla halapo. Epedeme wa꞉ na꞉ta atlamolowedeme ape yuye woloma dalene. ");
INSERT INTO xla_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","Epapedeme wa꞉ to hamtame alinepi hale sumpo daya woloma ka꞉pi ha꞉po na꞉ watle hampuane. Epalati na꞉tapo daya eye depame wa꞉ watle asiyadulo dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye hamilowepo. Adipalati, na꞉ye mo-polowe mateka꞉pi dla halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","7","Epapele dulu dla Aisekta Iso dla yukamhallati Lebeka ma hemele me-dalemhalaiyo. Epapeleye Isota dlowe api ma-tlati ya꞉tapo yami hale Yokob watle epo atlaiyo, “Na꞉ wa꞉ atapo wa꞉ bapa watle atlemama ‘to hamtapame alinepi hale sumpo hampuame ha꞉po hamine. Na꞉ epalati depame wa꞉ watle God mila꞉pi tle elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye hamilowepo,’ dla dale,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Epame Lebekatapo Yokob watle ma epo atlaiyo, “Na꞉ maseyemala, wa꞉ na꞉ta atlamolowedeme ape koko e dalepame koko eye hane. ");
INSERT INTO xla_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Epapedeme wa꞉ wa꞉ aliya kosukulli dla tame gaut aliya kakaliyapele dapiyamteye poyupo puane. Epalati na꞉tapo aliya mo e mate wa꞉ ata solotamale dayaye ha꞉lowepo. ");
INSERT INTO xla_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Epapalati wa꞉ atapo ala popolalo halemama daya eye depame wa꞉ watle itiyamale hamilipe, wa꞉tapo elele dulu dla dokopala depo halemama koko hapuloma omhalloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Epalati Yokobtapo asiyama ya꞉ wai watle epo atlaiyo, “Wai wa꞉ natine, na꞉ bapaye kapala dlalo sikemte wokasemana. Asiyama na꞉ tlo kapala dlalo hawa. ");
INSERT INTO xla_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Epapele dulu dla na꞉ atapo na꞉ kapala umpo malanatipame na꞉ta ya꞉ dla mala-atla koko dla adipo malapa꞉? Ya꞉tapo ka꞉dle koko tlo na꞉ dla pohamilalo ma isikimi wotiyalle tlo na꞉ dla hamilala,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Epalati asiyama ya꞉ waitapo ya꞉ watle epo atlaiyo, “Wa꞉ ase malamiya, na꞉ta wotiyalle eye mepele me-halowepo. Epedeme isikimi na꞉ta atlale yu eye dolumama gaut aliya halo poyupo halopo puane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Epapalati Yokobtapo ya꞉ waita atlale yu eye dolumama aliya halo puyupo pulati ya꞉ waitapo Aisekta solotamale dayaye ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Epame Iso ya꞉ kapala alisisi ka꞉ka꞉dleye ma Yokob dla didiyemeliyo. ");
INSERT INTO xla_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Epame gaut aliya halo kapala olale mape Yokob do dla epo tumuku dla didiyemeliyo. ");
INSERT INTO xla_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","18","Epo gudepame Aisekta solotamale mo opo mate epo daya mate Yokob watle hamiyo. Epalati Yokobtapo Aisek watle hamtame hamimama, a diyo. Epalati ya꞉ atapo ya꞉ watle epo atlaiyo, “Yao na꞉ maseyemala, wa꞉ anata꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Epalati Yokobtapo isikimi ya꞉ a dla mala-atlemama epo atlaiyo, “Na꞉ye wa꞉ maseyemala itapu hamale Isopo. Na꞉tapo wa꞉ta na꞉ watle atlamale kokoye ma-halepo. Epedeme wa꞉ sila꞉time polomama daya iye dene. Epame wa꞉tapo na꞉ watle elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Epalati asiyama Aisekta epo atlaiyo, “Wa꞉ adipo alinepi ma hapele sumpo hampuwo?” diyo. Amasiyama Yokobtapo ya꞉ a watle epo atlaiyo, “Wa꞉ Lod wa꞉ Godtapo na꞉ gadlepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Epapalati Aisektapo Yokob watle epo atlaiyo, “Wa꞉ na꞉ mateka꞉pi dla kulume puane. Epalati na꞉tapo wa꞉ kapala umpame ikadepe Iso mleni dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Epalati Yokobtapo ya꞉ a Aisek hala dla kulume tuwame pollati Aisekta ya꞉ kapala umpame epo atlaiyo, “Wa꞉ta yukamale tlo Yokobta yukamale sepena. Amasiyama wa꞉ do u-umamalati tlo Iso do dlalo some halema,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Epapele dulu dla Aisektapo Yokobye woloma pomalanatilalo wekiyo. Adipalati, Yokob do dlalotapo Iso do dlalo some halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Epapele koko tle ya꞉ atapo epo atlaiyo “Wa꞉ye ikadepe Isota꞉?” diyo. Epalati asiyama Yokobta mamisika꞉ isikimi mala-atlemama epo atlaiyo, “Yao, na꞉ye ikadepe Isopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Epalati Aisektapo ya꞉ watle epo atlaiyo, “Wa꞉tapo na꞉ daya hampualeye na꞉ watle hamine. Epalati na꞉tapo daya e depame wa꞉ watle elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye wa꞉ watle hamilowepo,” diyo. Epalati Yokobtapo daya mate epo wain yú mate halopo puame ya꞉ a watle halopilati ya꞉tapo daya mate epo wain yú mate deiyo. ");
INSERT INTO xla_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Epame Aisektapo Yokob watle epo atlaiyo, “Na꞉ maseyemala, wa꞉ na꞉ mateka꞉pi dla kulume puame polomama na꞉ye hulune,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Epalati Yokobtapo ya꞉ a Aisekta pola mateka꞉pi dla tuwame polomama ya꞉ye huliyo. Ya꞉ye epo me-hulumpollati Aisektapo Iso tluka ullu papame epo malamaiyo, “Yao, iye na꞉ maseyemala ullupo,” diyo. Epammama ya꞉tapo elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye ya꞉ watle hapimama epo atlaiyo, “Na꞉ maseyemala kapala ullu ka꞉pi pamalati Godta siyemhala osalo ullu ka꞉pi some pama. ");
INSERT INTO xla_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Epedeme Godtapo tiyo mate epo ta꞉la ka꞉dle mate wa꞉ dla hapilipe. Epalati wa꞉ dla alisisi pasataletapo matapame dlowe alisisi ka꞉pita teimelepe. ");
INSERT INTO xla_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Epame mo meyelope meyelope dle dla ha꞉ha꞉lalo opatapo wa꞉ yu dla heodepame salladepo siyamelepe. Epame wa꞉tapo wa꞉ asiyadulo dulu dla dokopala depo hallati yia꞉tapo wa꞉ hete sitali isili dla heode demha꞉ha꞉lepe. Epame oplami antapo wa꞉ dla wotiyalle hamilipiye, asiyama Godtapo ya꞉ dla wotiyalle hamilipe. Epame oplami antapo wa꞉ dla siyele hamilipiye, asiyama Godtapo ya꞉ dla siyele hamilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Epapeleye Aisektapo Yokob watle koko hapuloma atlemhalepo gudepo Yokobta ma-tlati alotle Isotapo dlowe api sela꞉leta mo-puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Epame Iso mape dlowe alisisi ka꞉pi ha꞉pame ya꞉ a hala dla hamtame halemama epo atlaiyo, “A, na꞉po. Epedeme wa꞉ sila꞉time polomama daya iye dene. Epame wa꞉tapo elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye na꞉ watle hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Amasiyama ya꞉ a Aisektapo ya꞉ watle epo atlaiyo, “Wa꞉ anata꞉?” diyo. Epalati Isotapo epo atlaiyo, “Na꞉ wa꞉ maseyemala itapu hamale Isopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Epalati Aisektapo yu i dalepo sikemte eseselalimama epo atlaiyo, “Ame oplami anta api, wa꞉ ala populalo hallati ya꞉ tatle daya ha꞉pame hampualeye? Na꞉ daya e depame ya꞉ watle elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye ma-hami. Epapedeme na꞉ matle wa꞉ watle pohamilowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Epalati Isotapo koko i dalepame sikemte dupa kolle mate ammama epo atlaiyo, “A, na꞉ mape, elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamaleye hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Amasiyama ya꞉ a Aisektapo ya꞉ watle epo atlaiyo, “Wa꞉ eitapo isikimi na꞉ dla mala-atlepame ya꞉tapo wa꞉ta halowe koko patoye ma-ha,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Epalati asiyama Isotapo epo atlaiyo, “Na꞉ ei Yokob ya꞉ hi e mate ya꞉ta moto mate koko halë mate natimama ma-ala꞉po. Epedeme ya꞉tapo na꞉ dla mala-atlaleye ma-dapiyamte depo. Epapele dulu dla ya꞉tapo ka꞉yapa na꞉ta na꞉ a elo dla hallowe kokoye kolahauwapo. Epame ma wata oloma hema ya꞉tapo elele dulu dla dokopala depo halemama koko hapuloma omhallowe itiyamale mape ya꞉ta ma-halepo,” diyo. Ya꞉ epo atlepame matle ya꞉ a watle epo atlaiyo, “Wa꞉ dla na꞉ watle hapilowe koko opiye me-hutiyema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Amasiyama Aisektapo ya꞉ watle epo atlaiyo, “Na꞉tapo Yokob watle itiyamale ma-hamilipo, ya꞉tapo wa꞉ye dokopala depo halemama wa꞉ asiyadulo dla mape ya꞉ta dokopala depo hallepe. Epame na꞉tapo na꞉ emale alisisi osalo hapuloma ma ya꞉ dla ma-hapi. Epapedeme na꞉ matle apa kokoye wa꞉ watle hamipa꞉? Na꞉ dla koko opiye ma-hawa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Epalati Isotapo ya꞉ a dla otele pato himimama epo atlaiyo, “A, na꞉ dla hamilowe koko ma-hawapa? Wa꞉ na꞉ dla ma koko opi hapine,” depame ha꞉ha꞉mama sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Epapalati Aisektapo asiyama epo atlaiyo, “Wa꞉tapo tiyo pa꞉le mo dla halemama wa꞉ osalo dulu dla dlowe alisisi emaletapo pomatlowa, pallipe. ");
INSERT INTO xla_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Epame wa꞉tapo opa mate sikemte nalatimhalemama wa꞉ ei yu dla heodepame salladepo sela꞉lepe. Amasiyama wa꞉tapo ya꞉ tle alikili a꞉ma gladepo tame mowolo hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Epedeme Isotapo ya꞉ ei Yokob watle elle pato himiyo. Adipalati, ya꞉ta elele dulu dla dokopala depo halemama koko hapuloma omhallowe kokoye ya꞉ tle mo-kolahalati. Epame ya꞉ta ya꞉skamu epo malamaiyo, “Na꞉ aye mo-polowe mateka꞉pi dla halema. Epedeme na꞉ ata polati dupa kolemama a꞉lleta tame gudle alotle na꞉tapo Yokobye yumuluwepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Epapeleye Lebekata Isota Yokob yumuluwedeme yu himili dalepame Yokob sisilapo epo atlaiyo, “Wa꞉ bapa Isoye wa꞉ yumuluwedeme yu himsela꞉po. ");
INSERT INTO xla_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Epedeme wa꞉ na꞉ta atlama koko i dalepame koko eye hane. Wa꞉ na꞉ bapa Laban, Halan mo dla halaye, edla teletane. ");
INSERT INTO xla_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Epedeme wa꞉ edla halemama wa꞉ bapata ma sadlati na꞉tapo na꞉ oko so watle wa꞉ye salataiya dlowepo. Epapedeme na꞉tapo wa꞉ye po-tane dlalo wekelepiye, wa꞉ bapa Isotapo wa꞉ye yumilipe. Epalati pona꞉malamana, ma asiyama opa opitapo wa꞉ bapaye yumulala. Epedeme na꞉ posolotamasema, wua꞉ta dapiyamteta haohaodloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Epapele dulu dla Lebekatapo ya꞉wolali Aisek watle epo atlaiyo, “Hitai wola꞉ dapiyamte Isota halomale iwolotapo na꞉ pasakaloye wotiyalle dulu dla semtama. Epedeme na꞉ posolotamasema, Yokobtapo Hitai a꞉ya hale haloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Epalati Aisektapo Yokob sisilapame ya꞉ watle epo atlaiyo, “Wa꞉ Keinan mo dla hallalo a꞉ya hale pohalowa. ");
INSERT INTO xla_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Amasiyama wa꞉ mama Betuwel, Padan Alam mo dla halaye, edla tane. Wa꞉ edla tame wa꞉ awe Laban ya꞉ utukaka dulu dla yoti hale hane. ");
INSERT INTO xla_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Epalati itiyamale Godtapo wa꞉ gademama wa꞉ watle yimlala pasataleye hapilipe, epame wa꞉ mamaduloye pasatepo mellepe. Epalati ta꞉lamo meyelope meyelope dle sotapo hatlo wa꞉ watle yia꞉ mama dlepe. ");
INSERT INTO xla_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Epame Godtapo A꞉iblaham watle ta꞉la i hamilowedeme yu itiyapo himiwaye ma alotle wa꞉ watle hamilipe. Amasiyama ditapo ta꞉la hema watapo asepe so some ha꞉ha꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Epo atlepo gudepame Aisektapo Yokobye sadle mate Padan Alam mo dla ya꞉ awe Laban mate halla tane, diyo. Epela dalepame Yokobtapo tame Alam oplami Betuwel yami Laban hala dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Epapeleye Isotapo ya꞉ a Aisekta Yokobye Keinan a꞉ya pohalalo ma Padan Alam mo dla tame a꞉ya hane dle kokoye daliyo. ");
INSERT INTO xla_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Epame ya꞉ ma me-daliyo, Yokobtapo ya꞉ a Aisek yu dalepame salladepo Padan Alam mo dla tale kokoye. ");
INSERT INTO xla_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Epapedeme Iso ya꞉ malanatiyo, ya꞉ atapo ya꞉ta Keinan wola꞉ dapiyamte halomuwa dla alimhalaleye. ");
INSERT INTO xla_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ya꞉ epela natipame tame A꞉iblaham yami Ismaelta himili a꞉ya hale haiyo. Ya꞉ hiye Mahalat, ya꞉ye Nebayot ya꞉lapo. ");
INSERT INTO xla_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Epapedeme Yokobtapo Belseba mo saliyome ma Halan mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Epapeleye ya꞉ mo edla tamama salita mo-tullati duka dla yaliyo. Ya꞉ye ellowedeme ewala hapame matali some himme elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ya꞉ elemama milamalo natilati tilikali omaletapo ta꞉lamo tle hitomeleme hetame Pepele dimo dla gudepo halla natiyo. Epalati God ya꞉ banakaka sotapo tilikali etle tulu heta demha꞉ha꞉la natiyo. ");
INSERT INTO xla_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Epapele dulu dla milamalo dulu edla Godtapo ya꞉ mateka꞉pi dla halemama epo atlaiyo, “Na꞉ye wa꞉ mama A꞉iblaham ya꞉ Godpo, epame wa꞉ a Aisek ya꞉ Godpo. Epedeme na꞉tapo ta꞉la pato iye wa꞉ watle epo wa꞉ mamadulo watle hamilowepo. ");
INSERT INTO xla_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Epame wa꞉ mamadulotapo sikemte pasatamama apupu some mo pato dla pasalalemtelepe. Wa꞉ mamadulo iwolo tle ta꞉la so hapuloma dla siyele hampulupe. ");
INSERT INTO xla_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Epame wa꞉tapo hadima adipo ta demsela꞉lepiye, na꞉tapo alila hapuloma dulu dla wa꞉ mate hallowepo. Epo alotle na꞉tapo wa꞉ye ta꞉la hema ma ilame sempuluwepo. Na꞉ wa꞉ye posaliyome tlowa. Epame monolo atlamale koko iye halomolowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Epapeleye Yokobtapo elale tle sila꞉tipame ya꞉skamu epo atlaiyo, “Na꞉ Godta hema hala kokoye pomalamana. Amasiyama ya꞉ mo hema ma me-halemapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Epammama Yokobtapo sikemte wota꞉mama epo atlaiyo, “Ikadepe, mo iye God ya꞉ mopo, epame Pepele dimo kokoloma talapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Epapeleye Yokobtapo ma-alallati elale tle sila꞉tipame ewala ya꞉ta matali some dokopala himme elaleye hapame oloma hitomeleme pameliyo. Epame dakopala mate ewala di dla sipame mo eye semama aiyalma diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Epapele dulu dla ka꞉yapa mo e ya꞉ hi semama Lus demdiyo. Epapele tlope Yokobtapo matle hi amko semama Betel diyo. ");
INSERT INTO xla_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Epame Yokobtapo God dla yu itiyapo himimama epo atlaiyo, “Wa꞉tapo na꞉ta tlati na꞉ omtamama dlowe alisisi mate kapala alisisi mate halopimtapame ma ilame woloma sempuame na꞉ a aya dla pomellepiye, eta wa꞉ye ikadepe na꞉ God mleni dlowepo. ");
INSERT INTO xla_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Epame ewala hema opatapo puame wa꞉ hi di dla ta꞉de demha꞉ha꞉lepe. Epame wa꞉tapo na꞉ watle hapili alisisiye kokolumtame 10 depame ma kolumale hatlo tlo wa꞉ watle ilame hami demhallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yokobtapo Betel mo saliyome ma tame salita matlalo tiyama dla tame woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Epapeleye ya꞉ puame mo edla natilati yú kolomaleye natiyo. Epame aliya halo alumale dapahatlopetapo yú kolomale mateka꞉pi edla yú dlowedeme hutiyemyela natiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yú kolomale iye ewala patotapo himomeleme polomdiyo. Epapeleye aliya halo omha꞉ha꞉lalo sotapo yia꞉ aliya halota ma alupo gudlati ewala yú kolomale himomeleme pollaloye alikili dla kokolustamdiyo, yia꞉ aliyata yú dlomelepo depame. Epame yia꞉ aliyata yú mo-dlopo gudlati ewalata mamisika꞉ himomelemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Epapele dulu dla Yokobtapo aliya halo omha꞉ha꞉lalo so watle epo atlaiyo, “Namkadulo, wua꞉ apa sota꞉?” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Dia꞉ye Halan mo so,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Epalati asiyama Yokobta yia꞉ watle epo atlaiyo, “Nahol ya꞉ mama Laban wua꞉malamata꞉?” diyo. Epalati asiyama yia꞉ta ya꞉ watle epo atlaiyo, “Yao, dimalamana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yokobtapo matle yia꞉ watle epo atlaiyo, “Ya꞉ye me-ka꞉depo halema꞉?” diyo. Epalati ma asiyama yia꞉ta epo atlaiyo, “Yao, ya꞉ye me-ka꞉depo halema,” depame matle atlaiyo, “Wa꞉ aseka huma natine. Oplami wa꞉ta atla e yoti Leisolpiye, sipi aliya halo eleme puaye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Epalati Yokobtapo aliya omha꞉ha꞉lalo so ewolo dla epo atlaiyo, “Wua꞉ natiya, saliye ala dukuslopi dla halapo. Epapedeme wata oloma hema wua꞉ aliya haloye yú ilipame osamokolo dlomelepo depame ma hapele eleme tamalaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Amasiyama yia꞉ta asiyama epo atlaiyo, “Hao, di pe-epapolowa. Adipalati, sipi aliya halo omha꞉ha꞉lalo sotapo yia꞉ aliya halo mate woloma yimkata mo-puame hema alupo gudlepiye, eta di ewalaye kokolustapame di sipi aliya haloye yú ilimolowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yokob ala opa mate me-yukamhallati Leisoltapo ya꞉ a aliya halo eleme yia꞉ hala dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Epalati Yokobta Leisol natipame ewala kokolustapame ya꞉ awe Laban aliya haloye yú ilimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Epame Yokobtapo Leisol dla hamame ammama ya꞉ watle epo atlaiyo, “Na꞉ye wa꞉ a yotimala Lebeka yamipo,” diyo. Epalati Leisolta yu i dalepame ma hapele kukulumtame ya꞉ a atlaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Epapalati Labanta ya꞉ awe Yokobye puwo dle koko dalepame ma hapele ya꞉ natila taiyo. Epame ya꞉ye hamame hulupame aya dla seme hetaiyo. Epalati Yokobtapo ya꞉ dla wowoyamale koko hapulomaye ya꞉ awe Laban watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Epalati asiyama Labanta koko e dalepame ya꞉ watle epo atlaiyo, “Wa꞉ye ikadepe na꞉ omali ikadepepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Epedeme Yokobtapo ya꞉ awe mate halemama mama hatlo ma-hamastlati ya꞉ awe Labantapo ya꞉ watle epo atlaiyo, “Wa꞉ye na꞉ awe demama isikimi asiyama pa꞉le na꞉ oko hamhallowe poka꞉dena. Epapedeme wa꞉ apa asiyama yilo na꞉ oko hamhallowe solotama꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Amasiyama Labanye ya꞉ utukaka dapiyamte eleme halaiyo, Leisol mate epo ya꞉ nana Liya mate. ");
INSERT INTO xla_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Epapele dulu dla Liyatapo a꞉ya ipilalo pase ka꞉pita polaiyo. Amasiyama Leisol tlope a꞉ya ipilalo sikemte ka꞉pita polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Epapeleye Yokobtapo Leisol tlo ya꞉ta sikemte solotamale pato elaiyo. Epammama ya꞉tapo ya꞉ awe watle epo atlaiyo, “Na꞉tapo Leisol halowedeme sokomoko 7 dulu dla wa꞉ oko hamhallowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Epapalati asiyama ya꞉ awe Labantapo epo atlaiyo, “Yao, me-ka꞉pi. Adipalati, poka꞉dena, na꞉tapo Leisolye wa꞉ watle pohamilalo wekemama ma oplami hale dla hamiloweye. Epedeme wa꞉ na꞉ mate halemama na꞉ oko hamhalane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Epapele dulu dla Yokobtapo Leisol halowedeme sokomoko 7 dulu dla oko hamhalaiyo. Amasiyama ya꞉ Leisol sikemte solotamale elemama sokomoko 7 iye ya꞉ dla pase pasatale diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Epedeme ya꞉tapo sokomoko 7 oko hamhalepo depo mogudlati Laban watle epo atlaiyo, “Alilatapo mo-umapo. Wa꞉ Leisolye na꞉ watle ma-hamine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Epalati Labantapo yoti oplami watle hamilowedeme daya dele dinapopame opa hapulomaye puaiya diyo. Epame yia꞉tapo puame yimkata daya deiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Amasiyama ma-tamila꞉la halemtlati Labanta Yokob mala-atlepame Leisolye poseme pulalo ma Liya tlo seme puaiyo. Epapele dulu dla Yokobtapo pomalanatilalo Liya mate me-elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Epapedeme Labantapo ya꞉ oko a꞉ya Silpaye ma Liya gademsela꞉lepo depame hamame iyo. ");
INSERT INTO xla_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Epapeleye Yokobta utulalati sila꞉tipo natipame Laban watle epo atlaiyo, “Wa꞉ adipalati na꞉ watle isikimi ipo elemo? Adipalati, na꞉ Leisol tlo halowedeme sokomoko 7 dulu dla wa꞉ oko hamhaluwapo. Amasiyama wa꞉ isikimi mala-atlepame ma Liya tlo na꞉ watle hamilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Epalati asiyama Labanta ya꞉ watle epo atlaiyo, “Di mo dulu hema wola꞉ta opa halomama ya꞉ nana pato me-hallati ya꞉la yemala tatle oplami pohasemde. ");
INSERT INTO xla_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Epedeme Liya daya dele itapo wiki hatlo hamastlati alotle Leisolye wa꞉ watle hamilowepo. Amasiyama wa꞉ mamisika꞉ sokomoko 7 dulu dla na꞉ oko hamhallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Epapalati Yokobtapo yu e dalepame solotamale me-himiyo. Epame Liya hamili daya deleta mosukulu tame gudlati Labanta yoti hale Leisolye hame Yokob watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Epapeleye Labantapo ya꞉ oko a꞉ya Bilhaye Leisol gademsela꞉lepo depame hamame iyo. ");
INSERT INTO xla_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Epame Yokobtapo Leisol mate elaiyo. Epapele dulu dla ya꞉ Leisol tlo sikemte solotamale pato elemama asiyama Liya tlo pase solotamale elaiyo. Epame mamisika꞉ ya꞉ta Leisol halë asiyama dla sokomoko 7 dulu dla oko hamhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Epedeme Godtapo Yokobta Liya pase solotamalalo wekele koko natipame Liya tlo yimlala isukumelepe diyo, amasiyama Leisol tlo hamkapi pollope diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Epapeleye Liyatapo mopapo polopame maseyemala hampame ya꞉ hiye Luben diyo. Epedeme Liyatapo epo atlaiyo, “Godtapo na꞉ta dupa kolle kokoye ma-natiwapo. Epedeme na꞉ oplamitapo wata oloma hema na꞉ye sikemte solotamale ellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Epame ya꞉ matle mopapo polopo maseyemala hale hampame, ya꞉ hiye Simiyon diyo. Epame ma epo atlaiyo, “Godtapo na꞉ oplamita na꞉ye pase sikemte malahala kokoye ma-daluwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Epame ya꞉ mamisika꞉ mopapo polopo maseyemala hale hampame ya꞉ hiye Libai diyo. Epame epo atlaiyo, “Epedeme watapo na꞉ oplamitapo na꞉ye sikemte malahallepe. Adipalati, na꞉tapo ya꞉ akimlala dapahatlopeye mo-hohomuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Epame mamisika꞉ mopapo polopo maseyemala hale hampame ya꞉ hiye Yuda diyo. Epame ma epo atlaiyo, “Wata oloma hema na꞉ God hi di dla ta꞉dlowepo,” diyo. Epame etle tamama mamisika꞉ yimlala opi po-isukumalalo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Epedeme Leisoltapo ya꞉skamu ya꞉ta yimlala po-isukumalalo wekele koko natipame ya꞉ nana Liya dla elle himhalaiyo. Epammama ya꞉tapo ya꞉wolali Yokob watle epo atlaiyo, “Na꞉ yimlala hapine! Wa꞉ta na꞉ watle yimlala pohapilalo wekelepiye, na꞉ polowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Epalati Yokobtapo yu e dalepo siyaladepame ya꞉ watle epo atlaiyo, “Na꞉ Godta꞉? Eta wa꞉ta na꞉ watle epo atlaye. Hao! Hatlo Godtapo yimlalaye hapimhalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Epapalati Leisoltapo Yokob watle epo atlaiyo, “Wa꞉ na꞉ oko a꞉ya Bilha mate elane, ya꞉tapo na꞉ yimlala isukumelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Epammama Leisotapo Bilhaye ya꞉wolali Yokob watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Epalati Bilhata mopapo polopame maseyemala hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Epapalati Leisoltapo maseyemala hiye Dan hi sepilaiyo. Epame epo atlaiyo, “Godtapo na꞉ta inoma sumale yu dalepame asiyama hamipo. Ya꞉tapo na꞉ kokoye natipame maseyemala na꞉ watle hamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Epame Bilhatapo mamisika꞉ mopapo polopame maseyemala hale hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Epalati Leisoltapo ya꞉ hiye Naptali diyo. Epame epo atluwapo, “Na꞉tapo na꞉ nana mate nalatimama na꞉ta ma-tla꞉mtauwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Epapele oloma edla Liya ya꞉ malanatiyo, ya꞉ mopapo godle kokoye. Epammama ya꞉tapo ya꞉ oko a꞉ya Silpa hamame ya꞉wolali Yokob watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Epalati Silpatapo mopapo polopame maseyemala hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Epapalati Liyata maseyemala hiye Gad hi hamiyo. Epame epo atlaiyo, “Ka꞉dle kokotapo na꞉ dla mo-woyamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Epame Silpatapo mamisika꞉ mopapo polopame maseyemala hale hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Epalati Liyatapo maseyemala hiye Asel diyo. Epame epo atlaiyo, “Na꞉ wata sikemte siyema. Epedeme wola꞉ hapulomatapo na꞉ watle siyele a꞉ya demyelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Epapele dulu dla witi daya hauwallowe alilata pulati Lubentapo osalo dla tame dali dlosalo mopapo pollopo depame dlaloye natipame halopo puame ya꞉ wai Liya watle halopiyo. Epalati Leisolta dalepame Liya watle epo atlaiyo, “Wa꞉ maseyemalata dali dlosalo halopo puale opiye na꞉ watle halopine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Amasiyama Liyatapo siyaladepame Leisol watle epo atlaiyo, “Wa꞉tapo na꞉ oplamiye mo-uhauwapo. Epame mamisika꞉ na꞉ maseyemalata dali dlosalo halopo pualeye uhalomolowedeme apopa?” diyo. Amasiyama Leisolta ya꞉ watle epo atlaiyo, “Wa꞉tapo wa꞉ maseyemalata dali dlosalo kolepo halopo pualeye na꞉ watle hamilipiye, na꞉ epalati asiyama wa꞉ye watapo Yokob mate elane dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Epapeleye tamila꞉la oloma edla Yokobtapo ya꞉ osalo tle pulati Liyatapo tame ya꞉ umpame epo atlaiyo, “Wata utula꞉la na꞉ta wa꞉ mate ellowedeme na꞉ maseyemalata dali dlosalo kolepo pualeye Leisol watle ma-halopi. Epedeme wa꞉ wata na꞉ mate ellepe,” diyo. Epalati Yokobtapo utula꞉la edla Liya mate elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Epapele oloma edla Godta Liyata inoma sumale yu dalepame ya꞉ watle maseyemala hale hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Epame ya꞉tapo maseyemala e ya꞉ hiye Isakal hi hamiyo. Epame epo atlaiyo, “Na꞉tapo na꞉ oko a꞉yaye nowolali watle hamilati Godtapo na꞉ watle asiyama ka꞉dleye hamilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Epapele dulu dla Liyatapo matle mopapo polopame maseyemala hale hamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Epalati ya꞉tapo ya꞉ hiye Sebulun diyo. Epame epo atlaiyo, “Godtapo namkale dle alisisi hamimama maseyemala iye hamilipo. Epedeme nowolalitapo na꞉ye di dla hame hetlepe. Adipalati, na꞉tapo ya꞉ akimlala 6 mo-isukumuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Epame alotle ya꞉ matle amseyemala hamaiyo, epo ya꞉ hiye Daina diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Epame Godtapo ma Leisolye malapame ya꞉ta inoma sumale yu dalepame ya꞉ta yimlala isukumolowe itiyamale hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Epalati ya꞉tapo mopapo polopame maseyemala hamaiyo. Epame epo atlaiyo, “Godtapo na꞉ta wota꞉le koko hapulomaye ma-hamastalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Epedeme maseyemala e ya꞉ hiye Yosep diyo. Epame ma epo atlaiyo, “Na꞉ malama, Godtapo na꞉ watle ma maseyemala hale hamilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Epapedeme Leisoltapo Yosep hamale alotle Yokobtapo Laban watle epo atlaiyo, “Na꞉ solotama watapo mo itle ma na꞉ mo ikadepe dla ilame tlowama. ");
INSERT INTO xla_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Epedeme na꞉tapo Liya mate epo Leisol mate halomolowedeme wa꞉ oko patoye ma-hamhaluwapo. Epapedeme wa꞉ na꞉ wola꞉ dapiyamte i mate epame na꞉ yimlala mate na꞉ watle halopine. Na꞉ epalati mo-tlowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Amasiyama Labantapo asiyama epo atlaiyo, “Hao, wa꞉ta na꞉ saliyome tlowe poka꞉dena. Adipalati, na꞉ta inoma nalatimale tle natili dulu dla Godtapo wa꞉ tle na꞉ dla gadle pato himimhalapo. ");
INSERT INTO xla_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Epedeme na꞉ solotama wa꞉ta hema me-halloweye. Epapedeme wa꞉ta midla hallepo depame na꞉ asiyamaye adisowa wa꞉ watle hamipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Amasiyama Yokobtapo asiyama ya꞉ watle epo atlaiyo, “Epedeme mo-wa꞉malamana, na꞉tapo wa꞉ mate halemama wa꞉ oko patoye ma-hamhaluwapo. Epalati wa꞉ aliya halotapo sikemte mo-pasatamtauwapo. ");
INSERT INTO xla_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Epapele dulu dla na꞉ta ka꞉yapa puwa oloma edla wa꞉ aliya haloye pase pasataleta halana. Amasiyama wata oloma hema wa꞉ aliya halotapo sikemte kustipo tame elapo. Adipalati, Godtapo na꞉ta koko halomale tle wa꞉ dla gadle pato himhaluwapo. Amasiyama wata oloma hema alilatapo mo-puapo, na꞉tapo naskamu na꞉ yimlala siyapo tlo omhalloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Epapele tlope Labantapo asiyama Yokob watle ma epo atlaiyo, “Na꞉ asiyama adisowaye wa꞉ watle hamipa꞉?” diyo. Epalati asiyama Yokobta ya꞉ watle epo atlaiyo, “Epedeme asiyamaye ipo. Na꞉ solotama wa꞉ aliya halo dulu dla aliya dilikili mate epo dudulalimale mate epo popokalle mate tlo hohomolowama. ");
INSERT INTO xla_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Epapele dulu dla wa꞉ta na꞉ watle koko e hane dlepiye, na꞉ eta wa꞉ mate medla halemama wa꞉ oko hamhallepe. ");
INSERT INTO xla_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Epapedeme itapu dla wa꞉ matle puame na꞉ aliya halo natilati dilikili siyapo mate epo dudulalimale siyapo mate epo popokalle siyapo mate natilipiye, wa꞉ na꞉ye ikadepe po-uhalalo wekele mleni dlepe.” ");
INSERT INTO xla_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Epalati Labantapo yu edla solotamale himmama epo atlaiyo, “Yao, me-ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Amasiyama alila oloma edla Labantapo hemele tame Yokobta ya꞉ dla hohomele dle aliya halo dilikitalo mate epo dudulalimale mate epo popokalalimale mateye elepame pateka꞉mu dla elemtaiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Epalati Laban ya꞉ akimlalatapo aliya ewoloye eleme mo pateka꞉mu, duka dla hutiyemama alila dapahatlope polollalo mo dla elemtamalaiyo. Amasiyama Yokobtapo koko i pomalamalalo aliya halo opi medla pomelleye me-omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Epapele dulu dla Yokobtapo Labanta ya꞉ aliya uhohopo elemtale natipame ya꞉tapo dali dlo kolepame kapala dollomama woloma ka꞉pi dudulumtuluiyo, aliya kapala dudulli some ha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Epame aliyata yú dlalo mo mateka꞉pi dla kellemtaiyo, yia꞉tapo yú dlomsiyamama dali dudulli natilipo depame. ");
INSERT INTO xla_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Epame yia꞉tapo dali eta ha꞉ha꞉ mila꞉pi tle halomsiyapo depo yimlala usulumama isikimi dudulalimale mate epo popokalalimale mate tlo usullupo depame. ");
INSERT INTO xla_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Epame yia꞉tapo yimlala usullati Yokobtapo yimlala hapuloma hohopo tame miyelo alikili dla ipila꞉iyo. Epame matle aliya opi tlo elemtame Laban aliya dudulalimale mate dilikitalo mateta ha꞉ha꞉ yia꞉ mila꞉pi dla ipila꞉iyo, yia꞉tapo halomsiyapo depo yimlala dudulalimale mate dilikitalo mate tlo hatitimelepo depame. Epalati Yokobtapo aliya dudulalimale mate epo dilikitalo mate epo popokalalimale mate ala usulliye elemtame ma ya꞉ aliya mate hatlo godiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Epame matle aliya halo i-itiyamaletapo hoholomolowedeme ha꞉ha꞉lati Yokobtapo dali dudulliye halopame yia꞉ mila꞉pi dla kellemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Amasiyama aliya halo hohopeyalimaletapo hoholomalati ya꞉ dali dloye pokellalo wekemdiyo. Epapele koko tle aliya halo i-itiyamaleta hatitimale tlo Yokobta hohomdiyo. Amasiyama hohopeyalimaleta hatitimale tlo Labanta hohomdiyo. ");
INSERT INTO xla_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Epapele koko tle Yokob ya꞉ aliyatapo sikemte pasatamtamama ya꞉ye alisisi pasatale oplami diyo. Epame ya꞉ oko so ma sikemte pasatepo elemama ya꞉ donki aliya mate epo ya꞉ ka꞉mol aliya mate sikemte kustimtame elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Epedeme Laban ya꞉ akimlalatapo Yokob koko dla yu ipo balemyaiyo, “Ya꞉tapo di ata omhaluwa aliyaye ma ya꞉ta hohomama ya꞉skamu ya꞉ye alisisi pasatale oplami depo halapo,” demyaiyo. Epalati Yokobta yia꞉ta yu balemyaleye me-daliyo. ");
INSERT INTO xla_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Epame Labanta ya꞉ watle elle himhala koko ma me-malanatiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Epalati Godtapo ya꞉ watle epo atlaiyo, “Wa꞉ ma ilame wa꞉ mo ikadepe dla tane. Epapalati na꞉tapo wa꞉ mate hallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Epapele dalepame Yokobtapo ya꞉ wola꞉ dapiyamteye ya꞉ta aliya omhallalo mo dla pulupo depame yia꞉ye sisilamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","7","Epame yia꞉ watle epo atlaiyo, “Na꞉ wata mo-malanatima, wua꞉ atapo na꞉ dla elle himhala kokoye. Amasiyama dulu edla na꞉ a Aisek ya꞉ Godtapo na꞉ mate halemama wua꞉ atapo na꞉ watle wotiyalle pohamimdena. Epapedeme wua꞉ mo-wua꞉malamana, na꞉tapo wua꞉ a oko pato hamhaluwaye. Epapele tlope ya꞉tapo na꞉ dla isikimi mala-atlale koko hamama na꞉ oko asiyamaye alila opi dla meyelope de epo ma alila opi dla meyelope de demhaluwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Epammama ya꞉ta atlemama, ‘Wa꞉ oko asiyamaye aliyata yimlala usulumama popokalalimale siyapo usullati wa꞉tapo hohoma demhallepe,’ dlati aliyatapo yimlala usulumama mepo popokalalimale siyapo tlo usulumduwapo. Epame matle wua꞉ ata atlemama, ‘Wa꞉ aliya yimlala dudulalimale usullati hohoma demhallepe,’ dlati aliyatapo mepo dudulalimale siyapo tlo usulumduwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Epapele koko tle Godtapo wua꞉ a aliya hapulomaye ma na꞉ watle hohopo iwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Epapeleye aliyatapo hoholomtlowe alilata pulati na꞉ milamalo natimama ipo natiwa. Aliya hapulomata hoholomyale oloma edla isikimi aliya pate dudulalimale mate epo popokalalimale mate tlo hoholomyela natiwa. ");
INSERT INTO xla_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Epalati milamalo natili dulu edla God ya꞉ banakaka oplamitapo na꞉ watle epo atluwa, ‘Yokob.’ Epapalati na꞉ asiyama epo atluwa, ‘Yao, na꞉ me-dalemelema,’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Epalati ya꞉ta epo atluwa, ‘Wa꞉ natima꞉, isikimi aliya pate dudulli mate epame popokalalimale mateta hoholomyapo. Adipalati, na꞉tapo Labanta wa꞉ dla batalimale koko hapuloma halomhaluwaye me-natiwa. ");
INSERT INTO xla_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Epapedeme na꞉ye wa꞉ta duka dla puame Betel mo dla ellati wa꞉ dla malame woyamuwa Godpo. Wa꞉tapo mo edla ewalaye oloma hitomeleme dakopala ewala di dla sipame na꞉ dla yu itiyapo himiwapo. Epedeme wa꞉ Laban mate halaye memelepame ma-hapele wa꞉ mo ikadepe dla ilamtane,’ duwa.” ");
INSERT INTO xla_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Epapeleye Leisol mate epo Liya mate Yokobta yia꞉ watle atlamale yu dla ka꞉pi demama epo atlaiyo, “Di ata polati dita ya꞉ tle alisisi halomoloweye hawa. ");
INSERT INTO xla_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Epame ya꞉tapo dia꞉ye elele meyelope so some omhalemama wa꞉ta di halomama ya꞉ watle asiyama pato himiwaye e isikimi mo-dosomuwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Epedeme Godtapo alisisi hapulomaye di a tle mo-kokolahapame ma watapo dia꞉ mate epo di akimlala mate dla hapiwapo. Epapedeme wa꞉ Godta atlamale yu e dalemama dolumane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","21","Epedeme Yokobye ya꞉ doko Labanye po-atlalo hemele mo-tlowedeme ma-dinapiyo. Amasiyama alila oloma eye Labantapo ya꞉ aliya halo dlaloye ketlemhalla taiyo. Epalati yoti Leisoltapo mo-tlowedeme sela꞉mama hemele hetame ya꞉ a Laban aya dla biskapa god dlopi dota mimita꞉peleye halomaiyo. Epame Yokobtapo ya꞉ wola꞉ dapiyamte mate epo ya꞉ yimlala mate ka꞉mol aliya di dla ipila꞉pame ya꞉ a Aisekta hala mo Keinan dla ilame ma-tamalaiyo. Yia꞉ tamalemama yia꞉ alisisi hapuloma mate aliya halo hapuloma mateye eleme tamalaiyo. Yia꞉ tame Yupalates aloma patoye ulupame ma Giliyad mo dla hetamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Epedeme alila dapahatlope mo-pololepo hallati alotle Labantapo toko ipo natitepo Yokobta ma-tale halla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Epalati ya꞉ta koko i natipame ya꞉ asiyadulo elepame alila 7 dulu dla Yokobta tale alotle dodolomtamalaiyo. Epapeleye yia꞉ tame Yokobye Giliyad mo dla kimpo halla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Epalati yia꞉ mape seme mateka꞉pi medla kimpo hutiyeiyo. Epalati utula꞉la oloma edla Godtapo milamalo malame Laban watle epo atlaiyo, “Wa꞉ Yokob watle koko atlamolowedemeye woloma malapo atlamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Epalati Labantapo tame Yokob umpame ya꞉ watle epo atlaiyo, “Wa꞉ adipalati na꞉ye mala-atlepame na꞉ utukakaye hemele opahale sota hohopo tamdiye epapele some hohopo puwa? ");
INSERT INTO xla_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Epedeme wa꞉tapo na꞉ watle woloma wa꞉ta alikili a꞉ma woyama kokoye atlematiye, na꞉ eta wa꞉ mate woloma daya dele pato himpame wua꞉ye sala sale mate alikili a꞉ma woyamaiya dlemla. ");
INSERT INTO xla_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Epame wa꞉ta epo hemele tale koko tle na꞉tapo na꞉ mamadulo dla epo na꞉ utukaka dapiyamte dla namkale dle yu atlepame pohuhulamana. Epapele koko tle wa꞉ye batalimale koko pato ma-hauwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Epapedeme na꞉ dla itiyamale elapo, wa꞉ye batalipo hamastloweye. Amasiyama wa꞉ a ya꞉ Godtapo wata utula꞉la milamalo malame na꞉ dla epo atla, ‘Wa꞉ Yokob dla koko atlamolowedeme woloma malapo atlamane,’ de. ");
INSERT INTO xla_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Epedeme na꞉ malama, wa꞉ta wa꞉ a hala dla tlowedeme sikemte malamale pato himhaluwaye. Amasiyama wa꞉ adipalati na꞉ god dlopi dota mimita꞉pele mate uhalopo puwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","32","Amasiyama Yokobtapo ya꞉llu Leisolta biskapa god dlopi dota mimita꞉peleye hemele uhalopo puale kokoye woloma pomalamalalo Laban watle epo atlaiyo, “Na꞉ puluwedeme wa꞉ye po-atlana. Adipalati, na꞉ta malamaleta wa꞉tapo wa꞉ utukakaye ma ilame elemalala duwa. Epedeme dia꞉ dulu dla oplami haletapo wa꞉ god dlopi dota mimita꞉pele halopo puale hallepiye, ka꞉dena oplami etlo polowe dla himiloweye. Epapedeme wa꞉ na꞉ asiyadulo mila꞉pi tle wa꞉ alisisi totapame natipo halopo tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Epalati Labantapo ya꞉ biskapa dlopi dota mimita꞉pele godye totamtame Yokobta ellalo dla tuwame totama, epo ma Liyata ellalo dla tuwame totama, epame ma tuwame Liya mate epo Leisol mate yia꞉ gadlalo wola꞉ta hutiyelalo dla tuwame totama diyo. Amasiyama ya꞉ ponatiyo. Epalati ma mosukulu dla Leisolta ellalo dla totamala tuwaiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Amasiyama biskapa dlopi dota mimita꞉pele god eye Leisoltapo duli dulu dla hatipame ka꞉mol aliya dimsisi di dla himpame di tle polaiyo. Epapele koko tle Labantapo Leisolta ellalo mo dla tuwame totamalati ponatilalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Epame Leisoltapo ya꞉ a Laban watle epo atlaiyo, “A, na꞉ta ka꞉mol aliya di tle alikili a꞉ma potullalo pola koko dla wa꞉ na꞉ dla ase sikemte siyalademiya. Adipalati, na꞉ye na꞉ toto koko natipo poloma,” diyo. Epapalati Labantapo kimna꞉ya duluye sikemte totamaiyo, amasiyama ya꞉ ponatiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Epalati Yokobtapo sikemte siyalademama ya꞉ doko Laban watle epo atlaiyo, “Wa꞉ apa batalimaleye na꞉ dla natima꞉? Epame wa꞉ na꞉ apa aiyalmaye hauwokokomalati wa꞉tapo na꞉ye dodolompuo? ");
INSERT INTO xla_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Adipalati, wa꞉ta na꞉ alisisi hapuloma dulu dla totapame natili kokoye na꞉ asiyadulo mate epo wa꞉ asiyadulo mate yia꞉ mila꞉pi tle hatitimane. Epalati edla anta ikadepe koko hata꞉-e depo natilowepo. ");
INSERT INTO xla_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Epedeme na꞉tapo sokomoko 20 dulu dla wa꞉ oko patoye ma-hamhaluwapo. Epapele dulu dla wa꞉ aliya halota yimlala usulumtale oloma edla aliya yemala haletapo popowana. Epame na꞉tapo wa꞉ aliya halo dulu dla aliya haleye poyummdena. ");
INSERT INTO xla_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Epame alila opita moko esemalatapo wa꞉ aliya hale yumulati ma asiyama na꞉tapo na꞉ aliya tlo wa꞉ watle hamame imduwapo. Epame wa꞉ aliya haletapo haodle hallati na꞉ watle asiyama wa꞉ta himine demduwapo. ");
INSERT INTO xla_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Epammhalemama sali patotapo na꞉ dla yumduwapo, epame utula꞉la kapumale patotapo pulati woloma pe-elemdena. ");
INSERT INTO xla_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Epame na꞉tapo sokomoko 20 dulu dla wa꞉ oko hamhalemama asiyama pa꞉le oko halalo oplami some haluwapo. Epapele dulu dla sokomoko 7 semeye Liya halowedeme wa꞉ oko hamhaluwapo, epame ma sokomoko 7 semeye Leisol halowedeme wa꞉ oko hamhaluwapo. Epame ma mosukulu sokomoko 6 ipiye wa꞉ aliya halo opiye hohomolowedeme oko pato hamhaluwapo. Amasiyama epapele tlope wa꞉tapo alila hapuloma dulu dla na꞉ oko asiyamaye meyelope meyelope demhaluwapo, woloma hatlo dla pohamimhalana. ");
INSERT INTO xla_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Amasiyama na꞉ a Aisek mate epo na꞉ mama A꞉iblaham mate yia꞉ Godtapo na꞉ mate haluwapo. Epapele koko tle wa꞉tapo na꞉ye alisisi dimi po-tane dena. Amasiyama Godtapo wa꞉ta na꞉ dla elle himhalemama koko hamhaluwa mate epo na꞉ta wa꞉ yilo oko pato hamhaluwa mate natipame wata utula꞉la wa꞉ dla woyapame wa꞉ye molo atlalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Epalati Labantapo Yokob watle epo atlaiyo, “Liya mate epo Leisol mateye na꞉ utukakapo, epame yia꞉ yimlalaye nolëpo, epame aliya halo e ma nolëpo. Epapele dulu dla koko hapuloma wa꞉ta hema natiye, eye ikadepe nolëpo. Amasiyama na꞉ na꞉ utukaka mate epo yia꞉ yimlala mate ma ilame hohomolowedeme yu hale po-atlowa. ");
INSERT INTO xla_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Epapedeme ka꞉dena, dita madipatatapo sadle halowedeme yu itiyapo himimama ewalaye hatlo kolumolowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Epalati Yokobtapo ewala pato hatlo tatle hapame oloma hitomeleme pameliyo. ");
INSERT INTO xla_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Epame ya꞉ asiyadulo watle epo atlaiyo, “Ewala opi halopame yimkata mateka꞉pi dla alupo kolupo pameliya,” diyo. Epalati yia꞉tapo ewala halopame yimkata alupo kolupo pamelepame ma yimkata Laban mate ewala kolumale mateka꞉pi dla popa꞉mama daya deiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Epame Labantapo Yokob watle epo atlaiyo, “Ewala kolumale itapo wa꞉ mate na꞉ mate sadle halowedeme yu itiyapo himi iye nati-imama apelepe,” diyo. Epapele koko tle Labantapo ewala kolumale e ya꞉ hiye semama Yegal Sahaduta diyo. Amasiyama Yokobta ma ewala kolumale hatlo metlo semama Galed diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Epame Labanta ma epo atlaiyo, “Dita madipatata duka gladepame me-ya꞉ mo dla ta ta dlepiye, Godtapo dia꞉ye di tle omhallepe,” diyo. Epapeleye ewala kolumale hatlo meye ma opata semama Mispa diyo. ");
INSERT INTO xla_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Epame Labantapo ma epo atlaiyo, “Wa꞉ta adipammama na꞉ utukaka dla wotiyalle hamipame ma a꞉ya hale halepiye, wa꞉ malamelepe, Godta dia꞉ye me-omhalapo. ");
INSERT INTO xla_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Epedeme ewala pato oloma hitomeleme pamelle i mate epo ewala hatlo kolumale i matetapo wa꞉ mate epo na꞉ mate sadle halowedeme yu itiyapo himiliye malamama apelepe. Epedeme na꞉ta wa꞉ watle wotiyalle hamilowedeme ewala kolumale eye pohotlatlowa, epame wa꞉ mape na꞉ watle wotiyalle hamilowedeme ewala kolumale eye pohotlapuluwa. ");
INSERT INTO xla_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Epapedeme wa꞉ mama A꞉iblaham mate epo na꞉ mama Nahol mate yia꞉ Godtapo dia꞉ dulu dla koko gladlalo hallepe,” diyo. Epalati Yokobtapo ya꞉ a Aisek ya꞉ God hi tle yu itiyapo himili iye dolumhallowepo depame solotamale himiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Epame Yokobtapo tamali di dla God hi di dla ta꞉demama aliya halo yumpame God watle hamiyo. Epo ya꞉ asiyadulo watle daya dla puaiya diyo. Epapeleye yia꞉ daya depame tamali di medla hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Epame utulalati ikadepe Labantapo ya꞉ utukaka dapiyamte mate epo ya꞉ mamadulo mate dla namkale dle yu atlepame yia꞉ye huhulapo gudepo ma ya꞉ mo dla ilame taiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yokobta ya꞉ doko mate esemhalepo depo ma-tlati God ya꞉ banakaka sota tulume ya꞉ye umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Epalati Yokobtapo yia꞉ natipame epo atlaiyo, “Pona꞉malamana, iye Godta hedepo yallalo mo sepena,” diyo. Epammama ya꞉tapo mo e ya꞉ hiye semama Mahanaim diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","5","Yokobtapo ya꞉ yu hamtlalo so taiya demama yia꞉ watle epo atlaiyo, “Wua꞉ tame na꞉ bapa Iso watle yu ipo atlaiye, ‘Na꞉ye Yokobpo, ya꞉ yu dla salladepo sela꞉lalo oplami. Na꞉tapo Laban mate halepo gudepame ma wata ya꞉ hala dla ilame pumhalema,’ diye. Epame ya꞉ dla ma ipo atellepe, ‘Na꞉ye na꞉ bulumkiyawa aliya mate epo donki aliya mate epo sipi aliya mate epame na꞉ oko so mate puma,’ diye. Epame matle ya꞉ watle epo atlaiye, ‘Na꞉ yu iye ya꞉ dla hamima, ya꞉tapo na꞉ta pua kokoye momolo malapame na꞉ye sadle mate selepo depame,’ diye,” diyo. Epapeleye ya꞉tapo ya꞉ opa watle yu ipo atlepame ya꞉ bapa Iso hala dla taiya diyo. Epalati yia꞉tapo tame ya꞉ bapa Isoye Seil mo dla hallati natipame yu eye atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Epame yu hamtlalo sotapo ma ilame puame Yokob watle epo atlaiyo, “Wa꞉ bapa Isoye 400 opa eleme hema pumhalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Epalati Yokobtapo yu i dalepame sikemte wota꞉iyo. Epammama ya꞉tapo ya꞉ opa mate epo ya꞉ aliya halo mate alumale dapiyamte dla hukulupo ipila꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Adipalati, ya꞉ ipo malamaiyo, “Isotapo alumale hale dla puame hustamhallepiye, asiyama alumale hale dla ha꞉ha꞉lalo so tlo potlopo depo,” malamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Epammama Yokobtapo inoma sumama epo atlaiyo, “God, wa꞉ye na꞉ a Aisek ya꞉ Godpo epame na꞉ mama A꞉iblaham ya꞉ Godpo. Wa꞉tapo na꞉ watle atlemama, ‘wa꞉ mo dla epo wa꞉ asiyadulo dla ma ilame tane,’ duwapo. Epame wa꞉tapo na꞉ mate halemama na꞉ye gadle himhalli duwapo. ");
INSERT INTO xla_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Epedeme na꞉tapo naskamu na꞉ye koko pa꞉le depo haluwa tlope wa꞉tapo na꞉ dla ka꞉ka꞉dle kokoye ma-halomhalemduwapo. Epame na꞉tapo mo-powataliya Yoden aloma ulume Laban hala dla tamama isikimi na꞉ dali ku tlo hame tauwapo. Amasiyama wata oloma hema na꞉ aliya mate epo na꞉ opa mateta sikemte pasatamha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Epedeme God, na꞉ye na꞉ bapa Iso do dulu tle seme alikili a꞉ma woyamane. Adipalati, ya꞉tapo na꞉ mate na꞉ wola꞉ mate epo na꞉ yimlala mate potimalala depame. ");
INSERT INTO xla_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Amasiyama wa꞉tapo na꞉ dla yu itiyapo himmama, ‘wa꞉ mamadulotapo pasatamama asila some sesa꞉lowe pa꞉le hallepe,’ duwapo. Epame wa꞉ ma na꞉ watle atlemama ‘na꞉tapo wa꞉ mate halemama wa꞉ gadlalo hallowepo’ duwapo.” ");
INSERT INTO xla_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","14","Epapeleye Yokobtapo medla elepo polomama Iso watle namkale dle alisisi hamiloweye dinapomama ya꞉ gaut aliya dulu dla 200 molalatalo mate epo 20 patetalo mate hohopo alikili dla ipila꞉iyo. Epame matle sipi aliya dulu dla 200 molalatalo mate epo 20 patetalo mate hohopo alikili dla ipila꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Epame matle ka꞉mol aliya dulu dla 30 molalatalo mate epo yia꞉ yimlala mate hohopo alikili dla ipila꞉iyo. Epame ma bulumkiyawa aliya dulu dla 40 molalatalo mate epo 10 patetalo mate hohopo alikili dla ipila꞉iyo. Epame ma donki aliya dulu dla 20 molalatalo mate epo 10 patetalo mate hohopo alikili dla ipila꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Epammtepo gudepame Yokobtapo ya꞉ oko so watle aliya halo alumale meyelope meyelope dle iwoloye omhala omhala demtaiya demama yia꞉ watle epo atlaiyo, “Wua꞉ tatle itapu dla tamalemama alumale hale tatle itapu tle tlati ma alumale haleta medla telepe, epalati ma alumale haleta medla ta demha꞉ha꞉iya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","18","Epapeleye Yokobtapo ya꞉ oko so itapu aliya elemtlalo so watle epo atlaiyo, “Wua꞉ aliya iwolo elemtlati Isota wua꞉ natipo wua꞉ watle atlemama ‘wua꞉ hadima tama꞉?’ depame ma wua꞉ watle atlemama, ‘iye ana aliyata꞉?’ depame ma wua꞉ watle atlemama, ‘wua꞉ dokopala oplami anata꞉?’ dlatiye, ma wua꞉ta ya꞉ watle ipo atlaiye, ‘Aliya iye wa꞉ yu dla salladepo sela꞉lalo oplami Yokob tete, ya꞉tapo wa꞉ watle isikimi namkale dle tle hapilowedeme puma,’ diye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yokobtapo yu hatlo me-iye aliya alumale meyelope meyelope dle elemtlalo so watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Epame yia꞉ watle ma epo atlaiyo, “Wua꞉ tame Iso watle atlemama na꞉ye ala alotle puma dle yu atloweye welimiyo,” diyo. Adipalati, ya꞉ malamaiyo, “Pona꞉malamana, na꞉tapo namkale dle alisisi eye Iso watle momolo hapilipiye, eta ya꞉tapo na꞉ batalimale dla siyaladepo halaye wellipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ya꞉ epo malapame namkale dle alisisi tatle Iso watle ma-hapila taiya depame ya꞉ tlo aseka medla hedepame alila hatlo medla yaliyo. ");
INSERT INTO xla_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Amasiyama utula꞉la dukuslopi oloma edla Yokobtapo ya꞉ wola꞉ mate epame ya꞉ akimlala 11 mate epo ya꞉ alisisi hapuloma mate yia꞉ tatle Yabok aloma ulumyame pomeliyo. ");
INSERT INTO xla_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Amasiyama ya꞉ tlo meyelope ala aloma seme medla me-polaiyo. Epalati oplami haleta utula꞉la puame ya꞉ye hamame poposila꞉lepo ya꞉ mate madipata dudupulalimsiyamaiyo. Yia꞉ta madipatatapo mepo poposila꞉lepo dudupulalimsiyamama me-ala꞉himiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Epapele dulu dla oplami hale etapo ya꞉ta potla꞉mtlalo wekelati asiyama Yokob tlo akolo dla heyumama akolo holataiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Epame Yokob watle epo atlaiyo, “Ma-ala꞉himima. Epapedeme na꞉ mo-tlowama,” diyo. Amasiyama Yokobtapo asiyama ya꞉ watle epo atlaiyo, “Na꞉ yilo inoma sumane. Epalati asiyama na꞉ta wa꞉ye ma-tane dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Epalati asiyama oplami eta Yokob watle epo atlaiyo, “Wa꞉ hi anata꞉?” diyo. Epapalati asiyama Yokobta epo atlaiyo, “Na꞉ hiye Yokobpo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Epalati asiyama oplamita epo atlaiyo, “Wata oloma itle kotiyapo tamama wa꞉ hiye matle po-Yokob demha꞉ha꞉lowa. Amasiyama wa꞉ hiye matle Isalael demha꞉ha꞉lepe. Adipalati, wa꞉tapo God mate epo opa mate nalatimale dulu dla wa꞉tapo ma-tla꞉mtalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Epalati Yokobtapo oplami e watle epo atlaiyo, “Wa꞉ hiye anata꞉?” diyo. Epalati asiyama oplami eta epo atlaiyo, “Wa꞉ adipalati na꞉ hiye dallowe solotama꞉?” depame Yokobye inoma sumale mate gadepame ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Epalati Yokobtapo mo hi eye semama Peniyel depame epo atlaiyo, “Na꞉ye God mila꞉pi ikadepeye natilipo, epapele tlope na꞉ pasakalota pohaodena,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Epapele dulu dla salita matlati Yokobtapo akolo holatale mepele mo e saliyome woloma sukomtamahalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Epapedeme wata oloma hema Isalael sotapo aliya mo demama akolo oloma dla mo ha꞉ha꞉lalo podlomasemde. Ame adipalati, Godtapo Yokobye akolo oloma dla heyumama akolo holatauwapo. ");
INSERT INTO xla_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Yokobtapo Peniyel mo saliyome tamhalemama natilati Isotapo ya꞉ 400 opa mate ala pateka꞉mu tle pumhalla natiyo. Epalati Yokobtapo Isota pula natipame ya꞉ yimlalaye alumale meyelope meyelope dle dla hatitimama ya꞉ oko so wola꞉ dapiyamte yia꞉ yimlala mateye wua꞉ tatle itapu dla taiya diyo. Epalati Liya mate epo ya꞉ akimlala mate medla tamalaiya diyo. Epalati Leisoltapo mosukulu ya꞉ maseyemala mate alotle tamalaiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Epame Yokob tlo ya꞉ tatle itapu tle tame ya꞉ bapa Iso ala pateka꞉mu tiyama tle me-pumhallati ya꞉ umula tamama 7 oloma dla heodepo alumata akukulume pola demtaiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Amasiyama Isota kukulumpuame ya꞉ye hampo poposila꞉pame hulumama sikemte amaiyo. Epalati Yokob mape sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Epame Isotapo wola꞉ mate epo yia꞉ yimlala mate pumha꞉ha꞉lati tlapame Yokob watle epo atlaiyo, “Wola꞉ iwolo mate epo yimlala iwolo mate anawolota꞉?” diyo. Epalati Yokobtapo asiyama ya꞉ watle epo atlaiyo, “Yia꞉ye Godtapo na꞉ watle halopiwa wola꞉ mate epo yimlala matepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Epalati ya꞉ oko so wola꞉ dapiyamteta yia꞉ yimlala mate puame Iso hete sitali isili dla heoheodiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Epame ma medla Liyatapo ya꞉ yimlala mate puame Iso hete sitali isili dla heoheodiyo. Epame Leisoltapo mosukulu alotle ya꞉ maseyemala Yosep mate puame Iso hete sitali isili dla heoheodiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Epalati Isotapo asiyama me-halemama Yokob watle epo atlaiyo, “Na꞉ta duka dla pumama tetla꞉mpuale aliya haloye adipapoloweta꞉?” diyo. Epapalati asiyama Yokobta ya꞉ watle epo atlaiyo, “Na꞉tapo wa꞉ dla siyele hamimama namkale dle alisisi eye wa꞉ dla halopilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Amasiyama Isotapo epo atlaiyo, “Ei yemala, na꞉ dla aliya halo sikemte pasatana, epedeme mowolo me-elemane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Epalati ma asiyama Yokobtapo epo atlaiyo, “Hao, bapa, wa꞉ta na꞉ natipame namkale dle kokoye nati-imama na꞉ta namkale dle alisisi halopi-iye me-halomane. Adipalati, wa꞉ta na꞉ natipo sikemte siyelati na꞉tapo wa꞉ mila꞉pi natimama semte God mila꞉pi natimapo de,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","“Epedeme Godtapo na꞉ mate halemama alisisi hapulomaye na꞉ watle ma-ala꞉po hapiwapo. Epapedeme na꞉ta namkale dle alisisi wa꞉ watle halopiye me-halomane,” diyo. Epele dulu dla Yokobtapo sikemte me-ha꞉ha꞉mhallati Isotapo namkale dle alisisi eye me-halomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Epammama Isotapo Yokob watle epo atlaiyo, “Di yimkata mo-tlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Amasiyama Yokobtapo Iso watle epo atlaiyo, “Di yipta yimkata wa꞉ mate potlowa. Adipalati, na꞉ yimlala opiye ala pta yimka꞉sikili, mo pateka꞉mu epapeleye hapele tlowe po-ala꞉na. Epame aliya halo mape yimlala ala yimka꞉sikili deme meme me-ilimtamalapo. Epapele dulu dla ditapo ma-hapele sikemte ullumtamellepiye, aliya halo yimlala ala usulliye pallipe. ");
INSERT INTO xla_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Epapedeme wa꞉ tatle itapu me-tane. Di epalati woloma alotle wa꞉ dolumtame wa꞉ta hallalo Seil mo dla tame woyamolowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Epalati asiyama Isota epo atlaiyo, “Na꞉tapo na꞉ opa opiye wa꞉ mate medla pomollowepo, yia꞉tapo wa꞉ gadlepo depame,” diyo. Amasiyama Yokobtapo asiyama epo atlaiyo, “Na꞉ natima, wa꞉ta na꞉ mate mo-sadepo hala kokoye. Epedeme na꞉ sikemte siyema. Epapele dulu dla wa꞉ na꞉ ase sikemte malamiya, aseka wa꞉ mo dla ma ilame tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Epalati Isotapo ma ilame ya꞉ mo Seil dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Amasiyama Yokobtapo ya꞉ wola꞉ mate epo ya꞉ yimlala mate mo edla potamallalo ma Sukot mo dla tamalaiyo. Yia꞉ edla tame woyapame ya꞉ wola꞉ mate epo ya꞉ yimlala mateta ha꞉ha꞉lowe aya haiyo. Epame ya꞉ aliya halota ha꞉ha꞉lowe kimna꞉ya ma halomaiyo. Epapele koko tle mo hiye Sukot demdiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Epapele alotle Yokobtapo Sukot mo e saliyome tame Keinan mo dla tame woyamaiyo. Epame Sekem mo alikili tle kimpo halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Epapele dulu dla mo ya꞉ta kimili ta꞉la eye Sekem ya꞉ a Hamol ya꞉ ta꞉layo. Epapeleye Yokobtapo 100 elo mani mate Hamol ya꞉ akimlala tle ta꞉la eye haiyo. ");
INSERT INTO xla_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Epame mo edla Yokobtapo God dla alinepi poyupo ha꞉lalo tile haiyo. Epo tile e ya꞉ hiye semama El Elohe Isalael diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Alila haletapo Liya yoti Dainata ipilatalo yimkadulo Sekem mo dulu edla ha꞉ha꞉lalo soye natila taiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Amasiyama ya꞉ edla tlati mo dulu edla dokopala hallalo Hibai elele halë oplami Hamol yami Sekemtapo ya꞉ natipame ya꞉ye uhaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Epame Sekemtapo Dainaye sikemte siyalahamama ya꞉ta Daina dla sikemte solotamale pato ela kokoye ya꞉ watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Epammama ya꞉tapo ya꞉ a watle epo atlaiyo, “A, wa꞉ na꞉ta a꞉ya i halowe api dinapene,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Epapeleye Yokobtapo Sekemta yoti uhale kokoye dalepame koko hale pohalalo, aseka ya꞉ akimlala aliya halo omha꞉ha꞉la tale soye ompolaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Epapele dulu dla Sekem ya꞉ a Hamoltapo yamita Daina halowe kokoye Yokob mate esemolowedeme mo-puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oloma medla Yokob ya꞉ akimlala mape aliya omha꞉ha꞉le tle mo-puame woyamaiyo. Epame yia꞉ puame Sekemta koko halë dalepame yiyelepame sikemte siyalasiyaladiyo. Epammama yia꞉tapo epo atlamyaiyo, “Sekemtapo Isalael so dla batalimale koko halëpa?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Epalati Sekem ya꞉ a Hamoltapo Yokob mate epo ya꞉ akimlala mate dla epo atlaiyo, “Na꞉ maseyemala Sekemtapo Daina dla sikemte solotamale pato elema. Epapedeme ya꞉ta halepo depame ya꞉ watle me-hamiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","“Epedeme ka꞉dena, ditapo dia꞉ dulu dla di utukakaye asiyama ha asiyama ha dlowe ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","“Epapelepiye, eta wua꞉tapo ma dia꞉ mate yimkata ha꞉ha꞉lepe. Epame di ta꞉la opiye wua꞉tapo asiyama mate halopame medla me-ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Epalati Sekemtapo Yokob mate epo ya꞉ akimlala mate dla epo atlaiyo, “Wua꞉tapo Dainaye na꞉ watle hamilipiye, asiyama adipapele koko pato wua꞉ta halowa dlepiye, na꞉tapo koko eye wua꞉ watle hapo hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Amasiyama Sekemta Dainaye mo-uhale koko tle Yokob ya꞉ akimlalata Sekem mate epo ya꞉ a Hamol mate dla mala-atlemama epo atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Di posolotamasema, diyotimalaye kapala pokestlalo wekele oplami dla hamiloweye. Adipalati, koko itapo dia꞉ dla wota꞉le koko hampulupe,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","“Epapedeme wa꞉tapo wa꞉ opa mate dita kapala kotipo ha꞉ha꞉ye wua꞉ ma epo ha꞉ha꞉lepiye, di eta diyotimalaye wa꞉ watle hamilowepo. ");
INSERT INTO xla_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Epapelepiye, eta ditapo dia꞉ dulu dla wola꞉ye asiyama ha epo asiyama ha demha꞉ha꞉mama mo medla yimkata opa hatlope depo ha꞉ha꞉lowepo. ");
INSERT INTO xla_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Amasiyama wua꞉tapo kapala pokotimalalo wekelepiye, di eta diyotimalaye wa꞉ watle pohamilalo me-seme mo i saliyome tlowepo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Epalati Hamol mate epo yami Sekem mate yu i dalepame solotamale himpame Sekemtapo ma-hapele kapala kestla taiyo. Adipalati, ya꞉ Daina halowe dla sikemte solotamale pato elaiyo. Epapele dulu dla Sekem iye ya꞉ asiyadulotapo ya꞉ye di dla hamhetamdiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Epapedeme Sekemtapo ya꞉ a Hamol mate mo dulu dla tame opata alupo esemalalo mo dla opa hapuloma sisilapame yia꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Yokob woloye dia꞉ mate namkale depo ha꞉ha꞉lowe sikemte solotama. Epapedeme di ka꞉dena, yia꞉ye elempuame yimkata ha꞉ha꞉mama dia꞉ dulu dla di utukakaye asiyama haloma epo asiyama haloma demha꞉ha꞉loweye. Epame yia꞉tapo di ta꞉la ipiye asiyama mate halowe ma me-ka꞉pi. ");
INSERT INTO xla_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Amasiyama dulu edla di koko hatlo itlo halowepo, di yia꞉ mate hatlope depo ha꞉ha꞉lowedeme yia꞉ta kapala kotipo ha꞉ha꞉ye, epammama di mape di opaye kapala kotimolowepo. ");
INSERT INTO xla_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Epedeme dita epapelepiye, eta yia꞉ aliya halo mate epo yia꞉ alisisi hapuloma mate diyole dlepe. Epapedeme ka꞉dena, dita hapulomatapo kapala kotimoloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Epalati Sekem so hapulomata yu i dalepo ka꞉dena demama yia꞉ta hapulomatapo kapala mo-kotimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Epame alila dapahatlope pololepo alotle opaye ala kapala kotipo hekaka alomale mate me-hutiyemyaiyo. Epalati Yokob ya꞉ akimlala dapiyamte Simiyon mate epo Libai mateta yia꞉ aipa꞉ya halopame Sekem soye ala pomalamalalo me-popa꞉myelati mo dulu dla tuwame opa hapulomaye potimtamalaiyo. Yia꞉ opa potimtamalemama Hamol mate epo Sekem mate ma potimaiyo. Epame yia꞉ Sekem aya dla hetame yotimala Dainaye seme ma yia꞉ aya dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","28","Epalati Yokob ya꞉ akimlala opitapo Sekemta yia꞉ yotimala Daina dla koko halë tle asiyama tame mo edla alisisi hapulomaye uhalomama sipi aliya hapuloma mate epo gaut aliya mate epame donki aliya mate epame alisisi hapuloma mate halopame alikili a꞉ma woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Epame wola꞉ mate epo yimlala mate mape hohopame alikili a꞉ma woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Amasiyama Yokobtapo koko i dalepame Simiyon mate epo Libai mate dla epo atlaiyo, “Wua꞉ adipalati koko ipapele hao? Watapo mo hema ha꞉ha꞉lalo Keinan so mate epo Pelisi so matetapo dia꞉ dla sikemte elle pato himilipe. Epedeme wua꞉ natiya, dia꞉ye opa pase pato, epapedeme yia꞉tapo dia꞉ mate opahale dlepiye, yia꞉ta di poyulupe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Amasiyama ya꞉ akimlalata asiyama yia꞉ a watle epo atlaiyo, “Ka꞉deta꞉, yia꞉tapo diyotimalaye isikimi duka dla sela꞉lalo a꞉ya some semtame uhaloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Godtapo ma Yokob watle epo atlaiyo, “Wa꞉ mo i saliyome ma Betel mo dla halla tane. Adipalati, mo edla wa꞉tapo ka꞉yapa wa꞉ bapa tle teletlati wa꞉ dla woyamuwa God eye na꞉po. Epedeme wa꞉ edla tame God dla alinepi poyupo ha꞉lalo tile hane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Epalati Yokobtapo ya꞉ wola꞉ mate epo ya꞉ akimlala mate epame opa opi ya꞉ mate ha꞉ha꞉lalo so mate dla epo atlaiyo, “Wua꞉ dulu dla biskapa dlopi dota mimita꞉pele god hutiyeye alikili a꞉ma pololepame yú huhutapame tluka amko didiyepo ha꞉ha꞉iya, God mila꞉pi tle woloma ha꞉ha꞉lowedeme. ");
INSERT INTO xla_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Adipalati, di mo iye melepame ma Betel mo dla telepe. Mo edla na꞉tapo God dla alinepi poyupo ha꞉lalo tile hapame ya꞉ hi di dla ta꞉dlowepo. Adipalati, God eta na꞉ta upiyele dulu dla sela꞉lati ya꞉tapo gadle pato himhaluwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Epapalati opatapo yia꞉ dulu dla dlopi dota mimita꞉pele biskapa god mate epo sutulu mate uptipame Yokob watle halopiyo. Epalati ya꞉tapo alisisi eye halopame Sekem mo mateka꞉pi dla dali pato hallalo hala sitali isili dla muwalepo hatiyo. ");
INSERT INTO xla_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Epame Yokob mate epo ya꞉ wola꞉ mate epo ya꞉ yimlala mate epame opa opi yia꞉ mate tale so mate ma-tamalaiyo. Amasiyama Godta mo yimlala mateka꞉pi dla popa꞉myale so dla wowota꞉le hamilati yia꞉tapo Yokob wolota ma-tlati yia꞉ mate opahale dlowedeme yia꞉ alotle podolumtamallalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Epapeleye alila haletapo Yokob woloye ma-tame Betel mo dla woyamaiyo. Amasiyama mo Betel i ya꞉ hi haleye semama Lus demdepo. ");
INSERT INTO xla_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Epedeme mo edla Yokobtapo God dla alinepi poyupo ha꞉lalo tile hapame tile e ya꞉ hiye El Betel diyo. Adipalati, ya꞉tapo Iso tle teletame mo edla ellati Godtapo ya꞉ dla woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Epapeleye yia꞉ edla ha꞉ha꞉lati Yokob ya꞉ wai Lebeka gadlalo a꞉ya Debolaye mo-powaiyo. Epalati ya꞉ motoye Betel mo dla dali sitali isili dla hamatiyo. Epame dali e ya꞉ hiye dupa kolomama a꞉lle dali diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Epapedeme Yokobtapo Betel mo dla hallati Godta matle ya꞉ dla puame woyapame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“Wa꞉ hiye matle po-Yokob demha꞉ha꞉lowa. Amasiyama wa꞉ hiye matle Isalael demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Na꞉ye itiyamale Godpo. Epame na꞉tapo wa꞉ mamaduloye ma-a꞉ma sikemte pasatepo mellowepo. Epame wa꞉ mamadulo opitapo dokopala hi halopo ha꞉ha꞉mtelepe. ");
INSERT INTO xla_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Epapedeme na꞉tapo A꞉iblaham mate epo Aisek mate dla hamiwa ta꞉laye matle wa꞉ mate epo wa꞉ mamadulo mate dla hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Epapele dulu dla Godta ya꞉ mate yukamhalepo gudepo me-hetlati Yokobtapo ewala pato pamelepame God hi di dla ta꞉dlowedeme wain yú mate epo dakopala mate ewala di dla simaiyo. ");
INSERT INTO xla_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Epapedeme Yokobtapo mo e semama Betel diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Epapeleye Yokob wolotapo Betel moye memeleme ma Epalat mo dla tamalaiyo. Yia꞉ ala duka dla me-tamalemama Leisoltapo owayemala hatostlowedeme wotiyalle natiyo. ");
INSERT INTO xla_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Epele dulu dla ya꞉ wotiyalle me-natimelemama owayemala hatostaiyo. Epalati ya꞉ gadlalo a꞉yatapo ya꞉ watle epo atlaiyo, “Ase sikemte wota꞉miya! Wa꞉ ma maseyemala hale hamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Amasiyama Leisoltapo dupa mosukulu ketame tulluwedeme yukamama maseyemala hiye Benoni diyo. Ya꞉ epo atlepame mo-powaiyo. Amasiyama Yokobtapo maseyemala e ya꞉ hiye ma Benyamin diyo. ");
INSERT INTO xla_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Epedeme yia꞉ Epalat mo dla tamalemama Leisolta polati duka medla polomeliyo. Epapeleye wata oloma hema Epalat moye semama Betliyem demdepo. ");
INSERT INTO xla_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Epalati Yokobtapo Leisolta powale wabasi malanatilowedeme ewala patota wabasi di tle pameliyo. Epapedeme ewala eye wata oloma hema ala me-polapo. ");
INSERT INTO xla_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Epame Yokobtapo ma mo e meleme ma Migidal Edel mo tla꞉mtame halemama kimtimsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Epapele dulu dla Yokobta mo edla me-hallati me-ya꞉ maseyemala Lubentapo ya꞉ wai hale Bilhaye uhaiyo. Epapeleye ya꞉ a Yokobtapo koko iye alotle me-daliyo. ");
INSERT INTO xla_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Epedeme iye Yokob ya꞉ akimlala 12 ipo. Epeleye ya꞉llu hale Liyatapo akimlala 6 hatitimaiyo, yia꞉ hiye Luben, epo Simiyon, epo Libai, epo Yuda, epo Isakal, epame Sebulun. ");
INSERT INTO xla_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Epame ma ya꞉llu hale Leisoltapo akimlala dapiyamte hatitimaiyo, yia꞉ hiye Yosep mate epo Benyamin mate. ");
INSERT INTO xla_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Epame ya꞉llu Leisol ya꞉ oko a꞉ya Bilhatapo akimlala dapiyamte hatitimaiyo, yia꞉ hiye Dan mate epo Naptali mate. ");
INSERT INTO xla_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Epame ya꞉llu hale Liya ya꞉ oko a꞉ya Silpatapo akimlala dapiyamte hatitimaiyo, yia꞉ hiye Gad mate epo Asel mate. Epedeme yimlala hapuloma iwoloye Yokobtapo Padan Alam mo dla halemama hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Epapeleye Yokobtapo ya꞉ a Aisek Heblon mo dla hallati natila taiyo. Heblon mo hi haleye Mamele epame Kiliyat Alba. Epedeme mo iye A꞉iblahamta ka꞉yapa halale mopo. ");
INSERT INTO xla_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Epapedeme Aisektapo mo edla halemama 180 sokomoko umpame powaiyo. Epalati ya꞉ akimlala dapiyamte Iso mate epo Yokob mateta yia꞉ a motoye polomeliyo. ");
INSERT INTO xla_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Aisek yami Iso ya꞉ hi haleye Edom demdepo. Epame ya꞉ mape ya꞉ mamaduloye sikemte pasatana. ");
INSERT INTO xla_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Epedeme Isotapo Keinan wola꞉ dapiyamte halomaiyo. A꞉ya hale hiye Ada, Hitai elele halë oplami Elon yotiyo. Epame a꞉ya hale hiye Oholibama, Hibai elele halë oplami Sibeon yami Ana yotiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Epame ya꞉ matle ya꞉ nana, Ismael yoti Basemat haiyo. Basemat eye Nebayot ya꞉layo. ");
INSERT INTO xla_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Epapeleye Iso ya꞉llu Adatapo maseyemala hatlo himiyo, ya꞉ hiye Elipas. Epame Iso ya꞉llu hale Basemattapo maseyemala hatlo himiyo, ya꞉ hiye Luwel. ");
INSERT INTO xla_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Epame Iso ya꞉llu hale Oholibamatapo akimlala dapahatlope hatitimaiyo, yia꞉ hiye Yus, epo Yalam, epo Kola. Epedeme Isotapo Keinan mo dla halemama akimlala iwoloye hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Epapedeme Iso mate epo Yokob mate yia꞉ta madipatata Keinan mo dla ha꞉ha꞉le dulu dla yia꞉ aliya halota sikemte pasatamama mo ha꞉ha꞉lowe kustimalati ya꞉ bapa Isotapo ya꞉ wola꞉ mate epo ya꞉ yimlala mate epame ya꞉ aliya halo mate epo ya꞉ alisisi hapuloma mate ma mo hale Seil mo dla ha꞉ha꞉la taiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isoye Edom elele halë so yia꞉ mama patopo. Epedeme ya꞉ mamadulo Seil mo dla ha꞉ha꞉lalo so yia꞉ hiye ipo. ");
INSERT INTO xla_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Iso ya꞉llu hale Adatapo maseyemala hatlo himiyo, ya꞉ hiye Elipas. Epalati Elipas ya꞉ akimlala hiye Teman, epo Omal, epo Sepo, epo Gatam, epo Kenas. Epame Iso yami Elipasta ma a꞉ya hale Timna hapame maseyemala hatlo himiyo, ya꞉ hiye Amalek. Iso ya꞉llu hale Basemattapo maseyemala hatlo himiyo, ya꞉ hiye Luwel. Epame Luwel ya꞉ akimlala hiye Nahat, epo Yela, epo Sama, epo Misa. ");
INSERT INTO xla_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Epame ma Iso ya꞉llu hale Sibeon yami Ana yoti Oholibamata akimlala dapahatlope hatitimaiyo, yia꞉ hiye Yus, epo Yalam, epame Kola. ");
INSERT INTO xla_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Epapele dulu dla Iso ya꞉llu Adata himili maseyemala Elipas tle elele meyelope meyelope dle iwolota ha꞉ha꞉iyo, Teman so, epo Omal so, epo Sepo so, epo Kenas so, epo Kola so, epo Gatam so, epo Amalek so. Epedeme elele meyelope meyelope dle iwoloye Edom mo dla ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Epame ma Iso ya꞉llu hale Basematta himili maseyemala Luwel tle elele meyelope meyelope dle iwolota ha꞉ha꞉iyo, Nahat so, epo Yela so, epo Sama so, epo Misa so. Epapedeme elele meyelope meyelope dle iwolo mape Edom mo hatlo medla me-ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Epame ma Iso ya꞉llu hale Ana yoti Oholibama tle elele meyelope meyelope dle iwolota ha꞉ha꞉iyo. Yus so, epo Yalam so, epo Kola so. ");
INSERT INTO xla_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Epedeme elele meyelope meyelope dle hapuloma hema hutiyemtuluye, hatlo Iso tle kotiyamale elelepo. Iso ya꞉ hi haleye Edom. ");
INSERT INTO xla_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Iso ala Edom mo dla pohallalo hallati Holi elele halë oplami hale Seil tatle mo edla halaiyo. Epedeme elele meyelope meyelope dleta oplami Seil etle kotiyamaleye iwolopo. Lotan so, epo Sobal so, epo Sibeon so, epo Ana so, epo Dison so, epo Esel so, epo Disan so. Epapedeme elele meyelope meyelope dle iwolo mape Edom mo hatlo medla me-ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Epapeleye Lotan ya꞉ akimlalaye Holi mate epo Homan matepo. Epalati Lotan ya꞉ nanaye Timnapo. ");
INSERT INTO xla_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Epalati Sobal ya꞉ akimlala hiye Alban, epo Manahat, epo Ebal, epo Sepo, epo Onam. ");
INSERT INTO xla_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Epame ma Sibeon ya꞉ akimlala hiye Aiya mate epo Ana matepo. Epapeleye Ana itapo ya꞉ a donki aliya halo omhalemama dalupa pa꞉le mo dla yú matale natiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Epapele dulu dla Ana ya꞉ yimlala hiye Dison mate epo Oholibama matepo. ");
INSERT INTO xla_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Epalati Dison ya꞉ akimlala hiye Hemdan, epo Esban, epo Itlan, epo Kelan. ");
INSERT INTO xla_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Epalati ma Esel ya꞉ akimlala hiye Bilhan, epo Saban, epo Akan. ");
INSERT INTO xla_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Epalati ma Disan ya꞉ akimlala hiye Us mate epo Alan matepo. ");
INSERT INTO xla_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Epapedeme Holi elele halomale soye iwolopo, Lotan so, epo Sobal so, epo Sibeon so, epo Ana so, epo Dison so, epo Esel so, epo Disan so. Epapedeme elele meyelope meyelope dle iwoloye Seil mo dla ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Epapele dulu dla Isalael mo omhallalo dokopala ala pohallalo hallati dokopala so opi iwolo tatle Edom moye dokopala depo ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Dokopala oplami haleye Beol yami Bela. Ya꞉ye Dinaba mo dla hallalo oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Epame Belata mo-polati Yela yami Yobabta halaiyo. Ya꞉ye Bosla mo dla hallalo oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Epame Yobabta mo-polati matle Husamta halaiyo. Ya꞉ye Teman mo dla hallalo oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Epame Husamta mo-polati ma Bedad yami Hadadta halaiyo. Ya꞉ye Abit mo dla hallalo oplamipo. Ya꞉ta halemama Moab mo dla tame Midiya so mate opahale demama ya꞉ opatapo tla꞉mtaiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Epame Hadadta mo-polati ma Samlata halaiyo. Ya꞉ye Masleka mo dla hallalo oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Epame ma Samlata mo-polati ma Saulta halaiyo. Ya꞉ye Yupalates aloma pili dla Lehobot mo dla hallalo oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Epo Saulta mo-polati ma Akbol yami Bal Hananta halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Epame Bal Hananta mo-polati ma Hadadta halaiyo. Ya꞉ye Pau mo pato dla hallalo oplamipo. Epedeme Hadad ya꞉lluye Matled yoti Mehetabelpo, ya꞉ye Mesahab ya꞉ awapo. ");
INSERT INTO xla_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Epapedeme Iso elele halomale soye iwolopo. Timna so, epo Alba so, epo Yetet so, epo Oholibama so, epo Ela so, epo Pinon so, epo Kenas so, epo Teman so, epo Mibsal so, epo Magdiel so, epo Ilam so. Epedeme elele meyelope meyelope dle iwolotapo Edom mo pato dulu dla miyelo mepo mo kestepo ha꞉ha꞉ demtaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yokobtapo ya꞉ ata halale mo Keinan dla me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Epapeleye Yokob yami Yoseptapo 17 sokomoko halemama ya꞉ bapadulo Bilha ya꞉ akimlala mate epo Silpa ya꞉ akimlala mate yimkata yia꞉ a aliya halo omha꞉ha꞉mdiyo. Epele dulu dla Yoseptapo ya꞉ bapadulota batalimale koko halomyale hapulomaye hemele ya꞉ a watle tame esemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Epapele dulu dla Yokobtapo ya꞉ maseyemala Yosep tlope sikemte malamale pato elemdiyo. Adipalati, ya꞉tapo mo-totoyemala halemama Yosepye himiwapo. Epeleye alila haletapo ya꞉ atapo Yosep watle tluka alisisi ka꞉dle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Epalati ya꞉ bapadulotapo tluka alisisi e natipame epo malamaiyo, “Dia꞉ atapo Yosep tlo sikemte malamale pato himhalema,” demdiyo. Epammama yia꞉tapo Yosep dla elle pato himha꞉ha꞉mama ya꞉ dla sadle yu hale po-atlemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","8","Epapeleye Yoseptapo ya꞉ta utula꞉la elemama milamalo natiliye ya꞉ bapadulo dla esemama epo atlaiyo, “Na꞉ wata utula꞉la elemama milamalo ipo nati. Dita yimkatatapo osalo dla tame witi daya kolepame keketipoliyemsiyama. Amasiyama dulu edla nolë ketepolli tlo duka dla hitomeleme hallati asiyama wua꞉lë keketipoliyele tlo alikili tle sillidepo ha꞉ha꞉mama nolë dla heode demha꞉ha꞉,” diyo. Epalati ya꞉ bapadulotapo yu i dalepame sikemte siyalasiyalademama ya꞉ watle epo atlaiyo, “Wa꞉ wa꞉ta malamaleta wa꞉ta dokopala hi hapame di omhalli depo malahalemama amma꞉?” diyo. Epammama ya꞉ bapadulotapo ya꞉ dla sikemte elle pato himha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Epame Yoseptapo mamisika꞉ milamnatiyo. Epame ma ya꞉ bapadulo dla esemama epo atlaiyo, “Na꞉ milamnatili hale ipo nati. Sali mate epo mama mate epo tamili 11 matetapo na꞉ dla heoheode dempopa꞉,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Epame ya꞉ ma tame ya꞉ta milamnatiliye ya꞉ a watle atlaiyo. Epalati ya꞉ atapo yu i dalepame alimama epo atlaiyo, “I apa koko dla milamalo natimama api? Wa꞉ na꞉ mate epo wa꞉ wai mate epame wa꞉ bapadulo mateta puame wa꞉ hete sitali isili dla heoheodlepe depo malamama amma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Epedeme ya꞉ bapadulotapo koko hema ya꞉ dla siyalasiyalademama elle pato himiyo. Amasiyama ya꞉ atapo koko hema apa koko natimama apuwo depame sikemte malamale pato me-himhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Epapele dulu dla alila haletapo Yosep ya꞉ bapadulota yia꞉ a aliyaye osamokolo delepo depame Sekem mo mateka꞉pi dla elemtame ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Epalati Yokobta yami Yosep watle epo atlaiyo, “Wa꞉ wa꞉ bapadulo Sekem mo dla ha꞉ha꞉ye tame natine. Wa꞉ tame yia꞉ natipame yia꞉ta koko halomha꞉ha꞉ye natipo puame na꞉ watle atlamane,” diyo. Epalati Yoseptapo Heblon mo saliyome ma Sekem mo dla ya꞉ bapadulo natila taiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ya꞉ tame Sekem mo dla ya꞉ bapadulo totamsela꞉lati oplami haleta ya꞉ natipame ya꞉ watle epo atlaiyo, “Wa꞉ apa totamsela꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Epalati asiyama Yosepta ya꞉ watle epo atlaiyo, “Na꞉ na꞉ bapadulo mate epo yia꞉ aliya mateye totamsela꞉ma. Wa꞉ yia꞉ye me-nati?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Amasiyama oplami eta ma asiyama epo atlaiyo, “Yia꞉ mo iye ma-saliyome tamalemama ‘di Dotan mo dla tamalema’ duwa,” diyo. Epalati Yoseptapo ma Dotan mo dla tame natilati ya꞉ bapadulota edla yia꞉ aliya halo omha꞉ha꞉la natiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","19","Amasiyama Yosepta ala pateka꞉mu tle pumhallati ya꞉ bapadulotapo natipame ya꞉ye yumuluwedeme yu himimama epo atlamyaiyo, “Milamalo natilalo oplami mo-puapo! ");
INSERT INTO xla_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Epedeme ya꞉ yumpame munamu dulu dla hamastlowa. Epame di a watle atlemama moko esemalata yumme dena dlowepo. Epame ya꞉ta milamalo tlamhalale kokoye apa kokota woyamolowe depo omha꞉ha꞉lowepo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Amasiyama Lubenta ya꞉ eidulotapo Yosep yumuluwedeme yu himili dalepame yia꞉ watle epo atlaiyo, “Di ya꞉ye poyumuluwa! Amasiyama isikimi munamu dulu dla me-hamastlowa,” diyo. Epapele dulu dla Lubenta yu ipo atluwaye, ya꞉ malamaiyo, Yosepye ma munamu dulu tle holahapame ya꞉ a hala dla seme puluwedeme apuwapo. ");
INSERT INTO xla_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Epapeleye Yosepta pulati ya꞉ bapadulotapo ya꞉ye hampame ya꞉ a Yokobta tluka ka꞉dle asiyomelleye uptipame ya꞉ye munamu dulu dla hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Epame yia꞉ daya dlowedeme popa꞉mama natilati Ismael elele halë sotapo Giliyad mo tle ma Isip mo dla tamalemama ullu ka꞉dle pamalalo alisisi mate epo dakopala mate halopo ka꞉mol aliya dla kolupo tamalla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","27","Epalati Yudatapo ya꞉ bapadulo dla epo ya꞉ eidulo dla epo atlaiyo, “Di poka꞉dena, di ei bidulo yumpame hemele hatiyomolloweye. Adipalati, ya꞉ye di ei ikadepepo. Epedeme isikimi Ismael so dla hamame ipame asiyama mani tlo halowa,” diyo. Epalati yia꞉tapo Yudata atlale yu dalepame solotamale himiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Epedeme Ismael sotapo mo-mateka꞉pi dla pumullati ya꞉ bapadulotapo Yosepye munamu dulu tle holahapame ya꞉ye yia꞉ watle hamame imama asiyama 20 elo mani tlo halomaiyo. Epalati Ismael sotapo Yosepye Isip mo dla hamame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Amasiyama Lubenye ya꞉ eidulotapo Yosep munamu dulu tle holahale ya꞉ ponatilalo wekiyo. Epapele koko tle ya꞉tapo alotle puame munamu dla toko ipo natitepo ya꞉ ei Yosepye ma-hawa hallati sikemte dupa kolemama ya꞉ tluka tallatalladiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Epame tame ya꞉ eidulo watle epo atlaiyo, “Yosepye ma-hawa halema. Epedeme na꞉ apa koko hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Epalati Yosep ya꞉ bapadulotapo gaut aliya yumpame Yosep ya꞉ tlukaye omali dla sosokoliyo. ");
INSERT INTO xla_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Epame omali sosokolle tlukaye hamtame yia꞉ a Yokob watle nati-imama epo atlaiyo, “Di tluka iye mo-pumulumama api duka dla ella nati. Epedeme tluka iye ikadepe wa꞉ maseyemala teteta꞉ depame woloma malanatilipo depame hampua,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Epalati Yokobtapo tluka eye woloma natipo malanatipame epo atlaiyo, “Yao, ikadepe iye na꞉ maseyemala tlukapo. Pona꞉malamana, moko esemalatapo ya꞉ye yumme deyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Epedeme Yokobtapo ya꞉ maseyemala Yosep yilo dupa kolle pato himimama ya꞉ tluka tallatalladepame ma dupa kolle tluka didiyepo polaiyo. Epame ya꞉tapo alila selemalli dulu dla ya꞉ maseyemala yilo dupa kolle pato himhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Amasiyama Yokobtapo epo dupa kolle dulu dla hallati ya꞉ akimlala mate epo ya꞉ utukaka mateta ya꞉ gadlowedeme pumulaiyo. Epapele tlope yia꞉tapo yia꞉ a gadlowe po-ala꞉iyo. Epammama Yokobtapo epo atlaiyo, “Na꞉tapo na꞉ maseyemala yilo me-ipo dupa kolemhalemama me-polowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Epapele alila oloma edla Ismael sotapo Yosepye Isip mo dla hamame tame oplami Potipa watle hamame imama asiyama mani tlo haiyo. Epedeme oplami Potipa iye Isip mo dokopala oplami Pelo ya꞉ aya alikili tle omha꞉ha꞉lalo so yia꞉ dokopala oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Epapele alila oloma edla Yudatapo ya꞉ bapadulo medla saliyome ma Adulam mo dla hallalo oplami Hila mate halla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Epeleye ya꞉ edla tame halemama Keinan oplami Suwa yoti natipame me-haiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Epame ya꞉ a꞉ya e hapo halemama maseyemala himiyo. Epalati maseyemala e ya꞉ hiye El diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Epame ya꞉llu ma mopapo polopame maseyemala hale himiyo. Epalati ya꞉ waitapo ya꞉ hiye Onan diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Epame yia꞉ ma Kesib mo dla ha꞉ha꞉lati ya꞉llu ma mopapo polopame maseyemala hale hamaiyo. Epalati ya꞉ hiye Sala diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Epeleye itapu hamale maseyemala Elta ma-ta꞉lati ya꞉ a Yudatapo ya꞉ta a꞉ya halowe api ka꞉diyo. Epalati Eltapo a꞉ya Tamaye haiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Amasiyama Elye God mila꞉pi tle batalimale koko patoto halomhallati Godtapo ya꞉ye yumiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Epame Elta mo-polati ya꞉ a Yudatapo yami hale Onan watle epo atlaiyo, “Di aiyalma dolumama wa꞉ bapa ya꞉llu dupulapi polaye ma wa꞉ta hane. Epame wa꞉ bapa powale elo dla hallowe maseyemala himine,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Amasiyama Onantapo ya꞉ bapa elo dla hallowe maseyemala himilowe posolotamaiyo. Epammama ya꞉tapo Tama mate elale oloma edla ya꞉ nalakaleye alikili dla o-olotimdiyo, ya꞉ta mopapo popollalo wekelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Epapedeme ya꞉ta ipapele koko hamhallati Godta koko e natimama posiyelalo wekiyo. Epalati Godtapo ya꞉ye yumiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Epedeme Yuda ya꞉ posolotamaiyo, ya꞉ maseyemala Salata ma Tama hapame poloweye. Epammama ya꞉ moma Tama watle epo atlaiyo, “Wa꞉ aseka tame wa꞉ a mate halane. Na꞉ maseyemala Salata alotle ta꞉pame wa꞉ye halepe,” diyo. Epela dalepame Tamata ma ilame ya꞉ a mate halla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Epame sokomoko opi mo-pololepo alotle Yuda ya꞉llu mo-powaiyo. Epalati ya꞉tapo ya꞉llu yilo dupa kolemhalaleta ma-tame gudlati ya꞉mkale Adulam mo dla hallalo oplami Hila mate tame Timna mo dla ya꞉ sipi aliya dlalo ketlemhala natila tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Amasiyama Yuda ya꞉ moma Tamatapo Yudata Timna mo dla mo-puale kokoye me-daliyo. ");
INSERT INTO xla_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Epapele dulu dla ya꞉ mo-malamaiyo, Yuda yami Salata mo-pato depo hala kokoye. Amasiyama epapele tlope ya꞉ moma Yudatapo yami Salaye ala ya꞉ watle pohamilalo halaiyo. Epalati asiyama ya꞉tapo Yuda elemolowedeme ya꞉ dupulapi tluka uptipame isikimi duka dla sela꞉lalo a꞉ya some ya꞉ mila꞉piye tlukata bopudepo tame Enaim mo kosukulli kokoloma tala dla Timna dla tlalo api dla ompolaiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","Epalati Yudatapo edla pumhalemama ya꞉ momata me-polla natipo semte isikimi duka dla sela꞉lalo a꞉ya tepo depame ya꞉ mate ella puane diyo. Epalati ya꞉ moma eta epo atlaiyo, “Na꞉ta wa꞉ mate ellepiye, wa꞉ adisowa na꞉ watle hamipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Amasiyama Yudatapo ya꞉ moma woloma pomalanatilalo wekemama ya꞉ watle epo atlaiyo, “Na꞉tapo gaut aliya halo amkota꞉leye wa꞉ watle hamame iliwepo,” diyo. Epalati ma asiyama ya꞉ momata ya꞉ watle epo atlaiyo, “Wa꞉ta ikadepe na꞉ watle gaut aliya halo hamame iliwepo depame na꞉ watle alisisi hale hamine, wa꞉ta atlama koko eye ikadepe dlowedeme,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Epalati asiyama Yudata ya꞉ watle epo atlaiyo, “Wa꞉ apa alisisi halowe solotama꞉?” diyo. Epalati asiyama ya꞉ta epo atlaiyo, “Na꞉ solotama, wa꞉ta meleli sokolomama wa꞉ hi mate himili asiyamhala eye e mate epo wa꞉ dali ku mate halomolowama,” diyo. Epapalati Yudatapo ya꞉ alisisi eye ya꞉ watle halopipame ya꞉ mate elaiyo. Epapele alotle ya꞉ momata mopapo mo-polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Epapeleye ya꞉ Yuda mate elepame ma ilame tame ya꞉ aya dla duka dla sela꞉lalo a꞉yata didiyelalo tluka didiyepo elaleye uptipame ma ya꞉ dupulapi tluka didiyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Epapele dulu dla Yudatapo ya꞉mkale Hila watle epo atlaiyo, “Gaut aliya iye semtame a꞉ya e watle hamame imama asiyama na꞉ alisisiye ilame halopo puane,” diyo. Amasiyama ya꞉mkale Hilaye tame totamsela꞉po a꞉ya e ponatilalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Epalati ya꞉tapo mo edla ha꞉ha꞉lalo so watle epo atlaiyo, “Duka dla sela꞉lalo a꞉ya Enaim mo kokoloma tala dla pollaloye da꞉?” diyo. Amasiyama yia꞉ta asiyama epo atlaiyo, “Mo hema duka dla siyamalalo wola꞉ hawa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Epalati Hilatapo ma ilame tame Yuda watle epo atlaiyo, “Na꞉ a꞉ya eye ponatina. Adipalati, mo edla ha꞉ha꞉lalo sotapo na꞉ watle atlemama duka dla siyamalalo wola꞉ hema poha꞉ha꞉semde de,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Epalati asiyama Yudata epo atlaiyo, “Mope, ya꞉ta na꞉ alisisi me-halopo hallepo,” diyo. “Epedeme ditapo gaut aliya ya꞉ watle hamame iliwedeme semtale tlope, di ya꞉ ponatina. Epapedeme dita mamisika꞉ gaut aliya iye semtelepiye, opata di natipo eimela꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Epapele dulu dla mama dapahatlope mo-pololepo alotle Yudaye daliyo, ya꞉ moma Tamata meyelo duka dla sela꞉le koko tle mopapo polale kokoye. Epalati Yudatapo koko e dalepame siyalademama epo atlaiyo, “A꞉ya eye haliyamale dla hamame puame pamelepo dlapata mistaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Amasiyama opatapo ya꞉ye dlapa dla mo-mistlowedeme hamame woyamalati ya꞉tapo ya꞉ moma Yuda dla yu hamimama epo atlaiyo, “Oplami dali ku i mate epo meleli sokolomale i mate halopo hallalo oplamiye na꞉ koko dulu dla pola owayemala ya꞉ apo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Epalati Yudatapo dali ku mate epo meleli sokolomale mate malanatipame na꞉ alisisipo diyo. Epame epo atlaiyo, “Na꞉ batalimalepo, po-ya꞉ta batalimale. Adipalati, na꞉tapo na꞉ maseyemala Salaye ma ya꞉ watle pohamina,” diyo. Epedeme Yudatapo ya꞉ watle wotiyalle pohamilalo wekepame ma ya꞉ mate pe-ellalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Epapeleye Tamata mopapo hatostlowe alilata mo-pulati ya꞉ gadlalo a꞉yata ya꞉ koko dulu dla owayimlala dapiyamte popa꞉la natiyo. ");
INSERT INTO xla_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Epalati ya꞉ta mopapo hatostale oloma edla owayemala haletapo ya꞉ do tatle woyamaiyo. Epalati Tama ya꞉ gadlalo a꞉yatapo tluka omteka꞉pele hame owayemala do woyamala himomelemama epo atlaiyo, “Owayemala i tatle hatostama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Amasiyama epapele tlope do eye ma ilame gilidlati ma asiyama ya꞉ bapa tatle ma-hatostaiyo. Epalati ya꞉ gadlalo a꞉yatapo epo atlaiyo, “Wa꞉ adipammama wa꞉ tatle haliyamale dla hatostao?” diyo. Epapele tle maseyemala e ya꞉ hiye semama Peles diyo. ");
INSERT INTO xla_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Epame ma ya꞉ ei, do dla tluka omteka꞉peleta himomelletapo alotle hatostaiyo. Epalati ya꞉ hiye semama Sela diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Epapele dulu dla Ismael elele halë sotapo Yosepye hamamtame Isip mo dla woyapame ya꞉ye oplami Potipa watle asiyama halowedeme hamame iyo. Epedeme oplami Potipa iye Isip mo dokopala oplami Pelo ya꞉ aya alikili tle omha꞉ha꞉lalo so yia꞉ dokopala oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Epapeleye Yoseptapo Potipa aya dulu dla hallati Godta ya꞉ mate halemama ya꞉ sikemte gademhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","4","Epalati Potipatapo koko i natipame Yosep watle ya꞉ aya mate epo ya꞉ alisisi hapuloma mate omhalane diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Epapedeme oloma etle kotiyapo Yoseptapo Potipa aya mate epo alisisi hapuloma mate woloma ka꞉depo omhallati Godta ya꞉ mate halemama ya꞉ sikemte gademhalaiyo. Epapele koko tle Potipatapo pakasiyamalalo alisisi sikemte pasatale oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Epedeme Yosepta ya꞉ oko epo ka꞉depo hala natimama Potipatapo koko hale halowe pomalamalalo isikimi daya dlowe tlo sikemte malamdiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Amasiyama Potipa ya꞉llutapo Yosepta kipiliyemala ka꞉pi hallati natipame dupa hetamama ya꞉ watle epo atlaiyo, “Na꞉ solotama, wa꞉ mate hatlope dlowedeme,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Amasiyama Yoseptapo alimama ya꞉ watle epo atlaiyo, “Hao, na꞉ wa꞉ mate pohatlope dlowa. Adipalati, wa꞉wolali Potipatapo na꞉ watle koko hapuloma hapimama woloma omhalane duwa. Ya꞉ta epo atlemama wa꞉ tlo na꞉ta po-omhalane dena. Ame adipalati, wa꞉ye ya꞉llu ikadepepo. Epedeme na꞉ adipammama batalimale koko ipapele wa꞉ dla hapa꞉? Adipalati, God mila꞉pi tle batalimale koko ipapele haloweye poka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Amasiyama epapele dulu dla Potipa ya꞉llutapo Yosepta ya꞉ mate hatlope dlepo depame alila hapuloma ya꞉ ha꞉ha꞉mhalemdiyo. Amasiyama Yoseptapo alimama ya꞉ tle alikili a꞉ma teletamdiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","12","Epapedeme alila haletapo aya duluye aya siyapo Yosep meyelo hallati Potipa ya꞉lluta puame Yosep tluka dla hamama epo atlaiyo, “Di aya siyapo dla bidulo ha꞉ha꞉po, epedeme wa꞉ matime na꞉ mate hatlope dene,” diyo. Amasiyama a꞉yata Yosep tluka dla hamamhallati Yosepta teletlati ya꞉ tluka tlo puahaiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Epalati a꞉yatapo Yosepta teletamama tluka tlo medla pomeleme tale halla natipame ya꞉ oko so sisilamaiyo. Epame yia꞉ta pula natipame yia꞉ watle epo atlaiyo, “Hibulu oplami Yoseptapo na꞉ uhalowedeme na꞉ hamala mati. Epela na꞉ta alimama sikemte hiyella dalepo teletamama ya꞉ tluka tlo medla pomelle ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","17","Epame ya꞉ta Yosep tlukaye medla himpolopo depo ya꞉wolalita mo-tamila꞉la pulati ya꞉ watle epo atlaiyo, “Wa꞉ oko halalo Hibulu oplami Yoseptapo na꞉ uhala matilipo. ");
INSERT INTO xla_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Epalati na꞉ta sikemte hiyellati dalepame teletamama ya꞉ tluka tlo medla pomelemtale ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","20","Epalati Potipatapo sikemte siyalademama Yosepye hampame amtuwale aya dulu dla ka꞉staiyo. Epedeme amtuwale aya iye Isip so yia꞉ dokopala oplami Pelo mape opaye amtuwale aya hatlo medla ka꞉ka꞉timhalemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","23","Amasiyama Godtapo Yosep mate halemama ya꞉ye gadle pato himhalaiyo. Epalati amtuwale aya omhallalo oplamitapo ya꞉ dla ka꞉dle koko natipame ma ya꞉ watle amtuwale aya dulu dla ha꞉ha꞉lalo so hapulomaye omhalane diyo. Epalati Yosepta amtuwale aya dulu dla ha꞉ha꞉lalo soye woloma ka꞉pi omhallati natipame amtuwale aya omhallalo oplamitapo koko opi pohalomalalo isikimi Yosep dla pomelepame me-omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Epapele dulu dla alila haletapo Isip mo dokopala oplami Pelotapo ya꞉ dla wain yú tipo hami demhallalo oplami mate epo ya꞉ daya ha꞉lalo oplami mate dla siyaladiyo. ");
INSERT INTO xla_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Ya꞉ siyalademama yia꞉ye hohopame Yosepta amtuwale aya dulu dla hala hatlo medla ka꞉ka꞉timaiyo. ");
INSERT INTO xla_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Epalati amtuwale aya dokopala oplamita Yosep watle opa dapiyamte ewolo ma wa꞉ta me-omhalane diyo. Epame Yosepta yia꞉ye alila hapuloma amtuwale aya dulu medla me-omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Epapele dulu dla alila haletapo Pelo dla wain yú tipo hamilalo oplami mate epo daya ha꞉lalo oplami matetapo utula꞉la hutiyemama milamalo tlamaiyo. Amasiyama yia꞉ta milamalo tlamaleye yia꞉ dulu kokoye poyia꞉malamana. ");
INSERT INTO xla_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Epapeleye utulalati edla Yosepta matime natilati yia꞉ta madipatatapo yia꞉ mila꞉piye sikemte polowastame popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Epalati Yoseptapo yia꞉ watle epo atlaiyo, “Apa kokota wua꞉ dla woyamalati mila꞉pi sikemte polowastame popa꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Epapalati asiyama yia꞉ta Yosep watle epo atlaiyo, “Di wata utula꞉la hutiyemama milamalo tlama. Amasiyama milamalo tlamale ya꞉ dulu kokoye oplami antapo di watle bobotimatipa꞉, dempopa꞉ma,” diyo. Epalati Yosepta yia꞉ watle epo atlaiyo, “Hatlo God tlo ala꞉na, wua꞉ta milamalo tlamale kokoye woloma wua꞉ watle imoloweye. Amasiyama wua꞉ta tlamaleye na꞉ watle atlamaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Epedeme dokopala oplami dla wain yú tipo hamilalo oplamitapo ya꞉ tatle ya꞉ta milamalo natiliye Yosep watle esemama epo atlaiyo, “Na꞉ elemama natilati gla꞉pi dlomoko dalita dlo dapahatlo tatlamale nati. Epeleye dlo edla dlomoko hahata pupame ma dlomoko ikadepeta dolahutiyemama ma-napo hutiye. ");
INSERT INTO xla_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Epapeleye na꞉tapo dokopala oplami Pelo ya꞉ isilako hapame gla꞉pi dlomoko dlalipo dala isilako dla okolopame Pelo dla hami,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Epalati Yoseptapo ya꞉ watle epo atlaiyo, “Wa꞉ta milamalo natili ya꞉ dulu kokoye ipo elema. Gla꞉pi dali dlo dapahatlope tatlamaleye, alila dapahatlope kokoye imama apopo. ");
INSERT INTO xla_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Epedeme alila dapahatlope pololepame dokopala oplami Pelotapo wa꞉ye amtuwale aya dulu tle alikili a꞉ma hamame woyamelepe. Epalati wa꞉tapo mamisika꞉ ya꞉ dla wain yú tipo hami demhallepe. ");
INSERT INTO xla_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Amasiyama wa꞉tapo ma alikili a꞉ma woyapame na꞉ye malamama dokopala oplami Pelo dla na꞉ kokoye atlane, na꞉ta amtuwale aya dulu itle alikili a꞉ma woyamelepo depame. ");
INSERT INTO xla_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ame adipalati, na꞉ye dlopi akumale tle na꞉ mo ikadepe memelepame ma hema seme pumuluwapo. Epame na꞉ye koko pa꞉le amtuwale aya dulu hema ka꞉stauwapo. Amasiyama na꞉ batalimale koko hale pohana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Epapele dulu dla dokopala oplami Pelo daya ha꞉lalo oplamitapo Yosepta ya꞉mkaleta milamalo natili ya꞉ dulu kokoye woloma ka꞉pi botomastlati natipame Yosep watle epo atlaiyo, “Wata utula꞉la na꞉ta milamalo natimama na꞉ye hakala duli tilimale dapahatlopeye palawa daya kolupame dokopala di dla ipila꞉po ta. ");
INSERT INTO xla_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Epapele dulu dla itapu di tle pameleme polale duli dulu edla palawa daya Pelota delepo depame kolupo hame ta. Amasiyama teata puame palawa daya eye demya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Epalati asiyama Yoseptapo ya꞉ watle epo atlaiyo, “Wa꞉ta milamalo natili ya꞉ dulu kokoye ipo elema. Hakala duli tilimale dapahatlope eye alila dapahatlopepo. ");
INSERT INTO xla_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Epapedeme alila dapahatlope pololepame Pelotapo wa꞉ dokopala iye ketamastepame wa꞉ motoye deata dali di dla himomeleme ellati teata puame wa꞉ moye delepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Epapeleye alila dapahatlope pololepo alotle Pelotapo ya꞉ hamale daya demama ya꞉ oko so hapuloma sisilamaiyo, daya dele dla pulupo depame. Epame ya꞉ dla wain yú tipo hamilalo oplami mate epo daya ha꞉lalo oplami mate amtuwale aya dulu tle alikili a꞉ma eleme woyamaiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","22","Epame yia꞉tapo mo-pulati Pelota ya꞉ dla wain yú tipo hami demhallalo oplamiye sepame daya ha꞉lalo oplami tlo yumiya diyo. Epedeme koko hapuloma iye Yosepta atlamale koko mate ala꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Amasiyama wain yú tipo hami demhallalo oplamitapo Yosep kokoye dokopala oplami dla atlowepo depo yu himiliye mo-welipo hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sokomoko dapiyamte mo-pololepo halemama dokopala oplami Pelotapo milamalo tlamaiyo. Milamalo natimama ya꞉ye Nael aloma peleyama dla tulume halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Epalati bulumkiyawa aliya kakaliyapele 7tapo aloma yú tle woyapame aloma peleyama dla osamokolo dlomsiyamala natiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","4","Epapalati bulumkiyawa aliya opi 7 sikemte bobatlalimale mape Nael aloma yú tle wowoyapame bulumkiyawa aliya yimkadulo 7 kakaliyapeleye gola꞉gola꞉diyo. Epame Pelota koko i natipame elale tle yieliyo. ");
INSERT INTO xla_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Epame ya꞉ sila꞉timpolopo mamisika꞉ elemama milamalo haleye ipo natiyo. Epeleye ya꞉ elemama natilati witi dali hatlo medla witi daya moko sikemte sosoumale 7ta dola hutiyela natiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","7","Epapele oloma medla witi daya gegeyalimaleta sosoumale 7ta ma medla wowoyapame witi daya sikemte sosoumale ka꞉ka꞉dleye gola꞉gola꞉diyo. Epapele oloma edla Peloye elale tle me-yieliyo. ");
INSERT INTO xla_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Epame utulala ikadepe sila꞉time polomama ya꞉ta milamalo tlamaleye apa koko tlamama apiyo depame sikemte momalampolaiyo. Epame ya꞉tapo ya꞉ opa inoma nalatimale so mate epo osolo watalo so mate sisilapame yia꞉ watle bobotimatimaiya diyo. Amasiyama yia꞉tapo yeitamama yia꞉ dulu kokoye ya꞉ watle po-bobotimatimalalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Epalati Pelo watle wain yú tipo hamilalo oplamita puame ya꞉ watle epo atlaiyo, “Epedeme na꞉ na꞉ta mo-powataliya wa꞉ watle atli depo weluwaye ma wata wa꞉ watle atlowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","“Epapedeme mo-powataliya wa꞉tapo na꞉ mate epo wa꞉ daya ha꞉lalo oplami mate dla siyalademama dia꞉ye amtuwale aya dulu dla ka꞉ka꞉timuwapo. ");
INSERT INTO xla_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Edla ha꞉ha꞉mama utula꞉la hale dla hutiyemama dita madipatatapo milamalo tlamuwa. Epele tlope dita milamalo tlamale yia꞉ dulu kokoye podimalamana. ");
INSERT INTO xla_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Amasiyama dulu edla Hibulu oplami hale, Potipa ya꞉ oko oplamitapo dia꞉ mate amtuwale aya dulu edla me-haluwa. Epapeleye ditapo dita milamalo tlamale kokoye ya꞉ watle atlamalati ya꞉tapo asiyama di watle yia꞉ dulu kokoye ka꞉pi bobotimatimuwa. ");
INSERT INTO xla_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Epedeme ya꞉ta di watle atlamuwa kokotapo ikadepe mo-wowoyamuwapo. Epele dulu na꞉ye matle na꞉ oko kotiyamama wa꞉ dla wain yú tipo hamilalo haluwapo. Amasiyama daya ha꞉lalo oplami tlo wa꞉ta yumiwa duwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Epela dalepame Pelotapo Yosepye ya꞉ hala dla seme puaiya diyo. Epapalati Yoseptapo aiyo tapo yú woloma hutupame tluka ka꞉ka꞉dle didiyepo pollati ya꞉ seme Pelo hala dla taiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Epalati Pelotapo ya꞉ natipame ya꞉ watle epo atlaiyo, “Na꞉ wata utula꞉la elemama milamalo nati. Amasiyama ya꞉ dulu koko botomastloweye oplami hale ponatisema. Amasiyama na꞉ oko oplamita atlemama wa꞉ tlo ala꞉na, dulu koko botomastloweye, de,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Epalati Yoseptapo asiyama ya꞉ watle epo atlaiyo, “Na꞉ dla malamale hale hawa. Epapele tlope Godtapo wa꞉ watle ya꞉ dulu kokoye botomastlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","18","Epalati Pelota epo atlaiyo, “Na꞉ elemama natilati na꞉ye Nael aloma pili peleyama dla tulume hala. Epalati bulumkiyawa aliya sikemte kakaliyalimale 7tapo Nael aloma yú dulu tle wowoyapame aloma pili dla osamokolo dlomsiyama. ");
INSERT INTO xla_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Epapele aloma medla bulumkiyawa aliya opi sikemte bobatlalimale 7 mape Nael aloma yú tle wowoyamalati nati. Epapele dulu dla na꞉ aliya sikemte bobatlalimale ipapele ponatisemde. ");
INSERT INTO xla_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Epapeleye bulumkiyawa aliya sikemte bobatlalimale 7 iwolotapo yimkadulo sikemte kakaliyalimaleye gola꞉gola꞉de. ");
INSERT INTO xla_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Amasiyama yia꞉ta epo gola꞉gola꞉depo ha꞉ha꞉le alotle natilati yia꞉ dulu dla teta꞉le ponatina. Amasiyama yia꞉ta hapulomatapo poteta꞉lalo isikimi mepo ka꞉yapa bobatlalipo ha꞉ha꞉uwaye, ma mepo ha꞉ha꞉la nati. Na꞉ epalati ma elale tle yiele. ");
INSERT INTO xla_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Epame na꞉ mamisika꞉ elemama milamalo hale ipo nati. Witi dali hatlo medla witi daya sikemte sosoumale 7ta dola hutiyela nati. ");
INSERT INTO xla_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","24","Epalati alotle ma witi daya opi gegeyalimaleta sosoumale 7tapo dali hatlo medla wowoyapame witi daya sikemte sosoumale 7ye gola꞉gola꞉dla nati. Epedeme na꞉tapo na꞉ osolo watalo so watle na꞉ta milamalo tlamale yia꞉ dulu kokoye na꞉ watle bobotimatimaiya dle tlope, yia꞉ na꞉ watle po-bobotimatimana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Epalati Yoseptapo Pelo watle epo atlaiyo, “Wa꞉ta milamalo tlamale dapiyamte dulu hema yia꞉ dulu kokoye ma-hatlope. Wa꞉ta milamalo tlamale koko tle Godtapo ya꞉ta koko halowedeme hala kokoye wa꞉ watle ma-nati-ilipo. ");
INSERT INTO xla_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Epapedeme wa꞉tapo bulumkiyawa aliya sikemte kakaliyapele 7 tlamale mate epame witi daya sikemte sosoumale 7 dola hutiyela tlamale mate e ya꞉ dulu kokoye sokomoko ka꞉ka꞉dle 7po. Epedeme itapu sokomoko 7 dulu edla dlowe alisisitapo sikemte pasatepo ellepe. ");
INSERT INTO xla_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Amasiyama wa꞉tapo bulumkiyawa aliya sikemte bobatlalimale 7 tlamale mate epo witi daya gegeyalimaleta sosoumale 7 tlamale mate yia꞉ dulu koko mape sokomoko 7po. Amasiyama sokomoko 7 dulu edla daya pa꞉le kokota ellepe. ");
INSERT INTO xla_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Epedeme Godtapo ya꞉ta koko halowedeme hala kokoye wa꞉ watle momolo nati-ilipo. ");
INSERT INTO xla_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Epapedeme itapu sokomoko 7 pua dulu hema emale alisisitapo woloma ka꞉pi matamama dlowe alisisitapo sikemte pasatlepe. ");
INSERT INTO xla_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Amasiyama ma alotle sokomoko 7 opi dulu dla emale alisisitapo woloma ka꞉pi pomatlalo gegeyalimama pallipe. Oloma edla dayata pa꞉mama Isip mo patoye sikemte batalipo hamastlepe. Epapele dulu dla opatapo daya pa꞉le dulu edla ha꞉ha꞉mama yia꞉ta ka꞉yapa sokomoko 7 ka꞉ka꞉dle dulu dla ha꞉ha꞉mama dlowe alisisi sikemte poposatilipo ha꞉ha꞉uwa kokoye wowellipe. ");
INSERT INTO xla_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Epedeme Godtapo ikadepe koko i halowedeme ya꞉tapo milamalo tlamale dapiyamte iye wa꞉ dla nati-ilipo. Epame ya꞉ta koko i haloweye podekellowa, ikadepe woyamelepe. ");
INSERT INTO xla_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Epedeme dokopala oplami, di ka꞉dena, daya alisisiye momolo itle mo-kokolumha꞉ha꞉lowa. Epapedeme wa꞉tapo oplami hale sikemte malamale oplamiye hulumane, dlowe alisisi kokolumolowe dla dokopala depo halloweye. ");
INSERT INTO xla_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Epame wa꞉ ma opa opi hohomelepe, yia꞉tapo sokomoko 7 ka꞉ka꞉dle dulu dla Isip mo pato dla siyamama witi daya halopo puame aya dla koluma demha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Epapedeme wa꞉tapo koko eye halepiye, etapo sokomoko 7 batalimale dulu dla daya pa꞉le kokota pulati opata dlowe alisisi me-demha꞉ha꞉lepe. Amasiyama wa꞉ta koko e pohalalo wekelepiye, opa hapuloma Isip mo dulu dla ha꞉ha꞉ soye pallipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","38","Yosepta koko eye atlamalati Isip mo dokopala oplami Pelotapo ya꞉ opa mate yu i dalepame pta ka꞉pi demama solotamale himmama epo atlaiyo, “Hatlo Yosep tlo ala꞉na, dokopala oplami halloweye. Adipalati, God ya꞉ Sokotapo ikadepe ya꞉ mate halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Epame Pelotapo Yosep watle epo atlaiyo, “Godtapo na꞉ta milamalo natili ya꞉ dulu kokoye wa꞉ watle imalepo. Epedeme hatlo wa꞉ye sikemte ka꞉depo malamale oplamipo. ");
INSERT INTO xla_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Epapedeme wa꞉tapo na꞉ aya mate epo na꞉ opa mate dokopala depo hallepe. Epalati opa hapulomatapo wa꞉ yu dla salladepo siyamelepe. Amasiyama hatlo monolo na꞉tapo wa꞉ dokopala oplami hallowepo. ");
INSERT INTO xla_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Epedeme na꞉tapo wa꞉ye Isip mo pato dulu hema dokopala oplami hallepo depame itiyamale hamima,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Epo atlepame Pelotapo Yosepta itiyamale ya꞉ tle halë eye nati-iliwedeme ya꞉ domoko dla alisisi asiyamhallaloye pustepo ma Yosep domoko dla asiyomeliyo. Epame Yosep watle tluka alisisi ka꞉ka꞉dle didiyemelepo ma ya꞉ tumuku dla gold meleli sokolomaleye asiyomeliyo. ");
INSERT INTO xla_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Epame ya꞉tapo Yosep watle ma ya꞉ aliya koa hale hamiyo. Epapele dulu dla Yoseptapo aliya koa etle tlati ya꞉ oko sotapo itapu tle tamalemama yu teta꞉le mate, “heodiya heodiya, Isip mo dokopala oplami mo-puma,” demtamalemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Epame Pelotapo Yosep watle ma epo atlaiyo, “Na꞉ye Isip so yia꞉ dokopala oplami Pelopo. Amasiyama epapele tlope ma wa꞉ dla itiyamale pato elapo. Epedeme oplami haletapo wa꞉ podallalo Isip mo dulu hema koko hale pohalowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Epame Pelotapo Yosep watle hi amko hamimama Sapenat Paneya diyo. Epame ya꞉ watle Potipela yoti Asenat hamiyo. Oplami Potipela iye Heliyopolis mo dla Isip so yia꞉ god dla alinepi poyupo hapilalo oplami halaiyo. Epedeme Yoseptapo 30 sokomoko hallati Pelotapo ya꞉ watle mo dokopala depo omhallowe hi hamiyo. Epalati ya꞉tapo Isip mo pato dulu dla sela꞉mama mo hapulomaye tlamtamdiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Epedeme sokomoko 7 ka꞉ka꞉dle dulu dla alisisitapo ka꞉pi matamama dlowe alisisitapo sikemte pasatepo elaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Epalati Isip sota emale alisisi hauwalle oloma dla Yoseptapo alisisi opiye aya patoto halopo dulu edla kokolumhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Epapedeme dlowe alisisitapo sikemte poposatilimama isikimi asila some sesa꞉lowe api pa꞉po halaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Daya pa꞉le kokota ala populalo hallati Yosep ya꞉llu Asenattapo akimlala dapiyamte hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Epalati Yoseptapo itapu hamale maseyemala ya꞉ hiye Manase depame epo atlaiyo, “Godtapo na꞉ta upiyele dulu dla puwa malamale mate epame na꞉ta totosomale mate mo-welipo hamastauwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Epame ya꞉ maseyemala hale hiye Eplaim depame epo atlaiyo, “Godtapo na꞉ta upiyele hamhaluwa mo hema yimlalaye halopima,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Epapele dulu dla Isip mo dla sokomoko 7 ka꞉ka꞉dle dulu dla ha꞉ha꞉mama dlowe alisisita pasatilipo ha꞉ha꞉le alilata ma-tame gudiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Epalati Yosepta atlamale koko mate ala꞉mama ma sokomoko 7 dulu dla sali pato sisilapomama daya pa꞉lowe alilatapo mo-kotiyamaiyo. Epapele oloma dla mo hapulomatapo dlowe alisisita mo-pa꞉iyo. Amasiyama hatlo Isip mo dla Yosepta aya patoto halomale dulu dla dlowe alisisita me-poposatilipo hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Epedeme daya pa꞉le kokota Isip mo dla pulati opatapo daya teta꞉mama Pelo hala dla tame daya halomolowedeme daliyo. Epalati Pelota asiyama yia꞉ watle epo atlaiyo, “Wua꞉ Yosep hala dla tame daliya. Epame ya꞉ta atlamale yu e dolumaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Epapeleye daya pa꞉le kokota Isip mo patoye ma-halati asiyama Yoseptapo dlowe alisisi kokolumale aya patoto halomale kokolomaye dodokotimaiyo. Epalati Isip sota ya꞉ hala dla puame dayaye mani mate halomha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Epapedeme daya pa꞉le kokota ta꞉lamo pato dla pulati opatapo mo opi tle Isip mo dla Yosep hala dla mani mate daya halomala pumhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Daya pa꞉le kokotapo Keinan mo ma me-haiyo. Epalati Yosep ya꞉ a Yokobtapo Isip mo dla dlowe alisisita ala me-elale kokoye dalepame ya꞉ akimlala watle epo atlaiyo, “Wua꞉ adipalati isikimi hohola꞉mha꞉ha꞉ma꞉? Na꞉ Isip mo dla daya hutiyeuwo dle kokoye me-dale. Epedeme wua꞉ tulume dayaye halomaiya. Poka꞉dena, dita daya dimi ha꞉ha꞉mama palliweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Epalati Yokob ya꞉ akimlala 10tapo yu e dalepame Isip mo dla daya halomala tuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Amasiyama Yokobtapo Yosep ya꞉ ei Benyaminye ya꞉ bapadulo mate taiya dloweye posolotamaiyo. Adipalati, api duka dla koko haletapo ya꞉ dla woyamalala depame. ");
INSERT INTO xla_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Epapedeme Keinan so opa opitapo Isip mo dla daya halomala tullati Yokob ya꞉ akimlala mape daya halomolowedeme yia꞉ mate tame Isip mo dla wowoyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yia꞉ edla tame woyapame daya halomolowedeme dokopala oplami Yosep hala dla tame ya꞉ hete sitali isili dla heoheodiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Epapele dulu dla ya꞉ bapadulo iwolotapo Yosepye woloma pomalanatilalo wekiyo. Amasiyama Yosep ya꞉ tlope ya꞉ bapadulo iwoloye me-malanatiyo. Amasiyama epapele tlope ya꞉tapo yia꞉ watle ya꞉ kokoye pobotomastlalo wekemama yia꞉ watle yu itiyamale mate epo atlaiyo, “Wua꞉ apa sota꞉?” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Dia꞉ye Keinan sopo. Di daya pa꞉lati hema daya halomolowedeme pumula,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Epapele dulu dla Yoseptapo sokomoko mo-powataliya dla milamalo natimama ya꞉ bapadulotapo ya꞉ dla heoheoduwa koko malapame yia꞉ watle epo atlaiyo, “Wua꞉ Isip moye isikimi wota꞉ siyamalalo so opapo. Epedeme wua꞉ di mota itiyamale pa꞉po ela kokoye isikimi kolemnatila pumulo?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","11","Amasiyama yia꞉tapo asiyama epo atlaiyo, “Hao, dokopala oplami, di powota꞉ tlalo so opa. Dia꞉ye isikimi wa꞉ hala dla daya halomala pua. Epame di mape isikimi oplami hatlope ya꞉ akimlalata pumula,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Epalati Yoseptapo asiyama yia꞉ watle epo atlaiyo, “Hao, wua꞉ isikimi na꞉ dla mala-atlapo. Adipalati, wua꞉ isikimi di mota itiyamale pa꞉po ela kokoye wota꞉ natila pumulana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Amasiyama yia꞉tapo ya꞉ watle epo atlaiyo, “Hao, di koko edla popuwana. Adipalati, dia꞉ye isikimi oplami hatlo ya꞉ akimlalapo. Di atapo akimlala 12 hatitimuwa. Epapele tlope di 10 sotapo hema pumulalepo. Epalati di ei, alo ikadepe hamaleye di a mate Keinan mo medla saliyome pumula. Amasiyama di ei yemala hale tlo mo-pouwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Amasiyama Yoseptapo yia꞉ watle epo atlaiyo, “Medla gudiya! Adipalati, na꞉ta ka꞉yapa wua꞉ watle ma-atlalepo, wua꞉ye mo hema isikimi wota꞉ pumulalepo. ");
INSERT INTO xla_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Amasiyama na꞉ wua꞉ta atlama kokoye ikadepeta꞉e depame, wua꞉ ei yemala natilowe solotama. Epapedeme wua꞉ dulu dla haletapo ma ilamtame wua꞉ ei yemala sempuaiya. Amasiyama opi wua꞉ye na꞉tapo amtuwale aya dulu dla ka꞉ka꞉timolowepo. Epapele dulu dla wua꞉tapo wua꞉ ei yemala posempulalo wekelepiye, wua꞉ ikadepe mo hema wota꞉ pumulale sota ammama apelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Epame Yoseptapo yia꞉ta hapulomaye amtuwale aya dulu dla alila dapahatlope ha꞉ha꞉lepo depame ka꞉ka꞉timaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Alila dapahatlope mogudlati Yoseptapo yia꞉ watle epo atlaiyo, “Na꞉ye God yu dla heodlalo oplamipo. Epedeme wua꞉ na꞉ta atlati koko eye halepiye, eta wua꞉ye po-potimolowa me-ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","20","Wua꞉ dulu dla oplami hale tlo amtuwale aya dla ka꞉stlowepo. Amasiyama opi wua꞉ tlope daya halopame ma ilame wua꞉ a hala dla tamalaiya. Amasiyama wua꞉ ei yemalaye na꞉ watle seme puaiya. Epele dulu dla wua꞉tapo ikadepe ya꞉ye seme pulupiye, na꞉ eta wua꞉ta atlamale kokoye ikadepe tepo dlowepo. Epalati na꞉tapo wua꞉ye popotimolowa,” diyo. Epalati Yosep ya꞉ bapadulotapo yu e dalepame yu hale po-atlalo me-ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Epame yia꞉tapo yia꞉ dulu dla yia꞉skamu yu hamyemama epo atlamyaiyo, “Ditapo mo-powataliya me-di ei dla batalimale koko hauwa tle asiyama di watle wotiyalle koko itapo woyamapo. Adipalati, ditapo di eiye munamu dulu dla hamastlati ya꞉tapo gadle yilo dia꞉ dla otele himmama sisilamalati dita ya꞉ye pogadena,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Epame Lubenta epo atlaiyo, “Na꞉tapo wua꞉ watle atlemama, ya꞉ dla wotiyalle hamimiya duwapo. Amasiyama wua꞉tapo na꞉ yu podallalo ya꞉ dla wotiyalle me-hamiwapo. Epapele koko tle ya꞉ omali asiyama dla ma dita wotiyalle hapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Epele dulu dla Yoseptapo ya꞉ bapadulota atlamyale koko hapulomaye me-dalepo halaiyo. Amasiyama ya꞉ bapadulota malamaleye semte yia꞉ yuye ya꞉ podallalo wekemapo diyo. Adipalati, Yoseptapo ya꞉ bapadulo mate yukamhalemama isikimi Isip so yu mate yukamhallati asiyama oplami haletapo yia꞉ watle ma Hibulu yu mate ilaha demhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Epeleye Yoseptapo ya꞉ bapadulota epo yu hamyela dalepame helestame tumama amaiyo. Epame ma helestame halemama ya꞉ bapadulo dulu dla Simiyon tlo hamame do keketipoliyepo amtuwale aya dulu dla ka꞉staiya, diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Epame Yosepta ya꞉ bapadulo koko dla ma ya꞉ oko so watle epo atlaiyo, “Dayaye yia꞉ yekalo dla atilipame yia꞉ mani mape ma ilame yia꞉ yekalo dulu medla hatiya. Epame yia꞉ta duka dla tamalemama daya dlomtlowe ma halopiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Epapalati Yosep ya꞉ bapadulotapo yekalo daya atilimaleye donki aliya di dla kolupame ma Keinan mo dla ilame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Yia꞉ tame duka dla hutiyelowedeme popa꞉mama yia꞉ bapa haletapo ya꞉ donki aliya daya iliwedeme ya꞉ yekalo daya atiliye towastame natilati ya꞉ta daya halë maniye ma ilame ya꞉ yekalo dulu dla hamatili halla natiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Epalati natipame sikemte yielepo yia꞉ watle epo atlaiyo, “Na꞉ta daya halë maniye ma ilame yekalo dulu dla hamatili halema,” diyo. Amasiyama yia꞉tapo yu i dalepo yiyelepame dupa yulumale mate epo atlamyaiyo, “God adipalati di watle koko ipapele hama꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yia꞉ Keinan mo dla tame woyapame yia꞉ dla wowoyamuwa koko hapulomaye yia꞉ a watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Epame matle ya꞉ watle epo atlaiyo, “Isip mo dokopala oplamitapo dia꞉ dla sikemte mukolli yu atlemama dia꞉ye wota꞉ pumulale so duwa. ");
INSERT INTO xla_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Amasiyama epalati ditapo asiyama ya꞉ watle epo atluwa, ‘Dia꞉ye ikadepe wota꞉ popuwana. ");
INSERT INTO xla_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Epame dia꞉ye oplami hatlo ya꞉ akimlalapo duwa. Epapele dulu dla di ei hale tlo mo-polati asiyama di ei mosukulu hallalo tlo mo medla di a mate me-halema,’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Epalati Isip dokopala oplamitapo di watle ipo atluwa, ‘Wua꞉ dulu dla wua꞉ bapa hale tlo medla pomelepo daya halopo ma ilame tame wua꞉ a hala dla tamalaiya,’ duwa. ");
INSERT INTO xla_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","‘Amasiyama wua꞉ ei yemala tlo hema sempuaiya. Wua꞉tapo wua꞉ ei yemalaye na꞉ hala dla sempulati natilipiye, na꞉ eta wua꞉ yu dla mikadepe demama wua꞉ye powota꞉ pumulale so dlowepo,’ duwa. ‘Epalati na꞉tapo wua꞉ bapa Simiyonye amtuwale aya tle hamame woyamalati wua꞉tapo daya me-haloma demha꞉ha꞉lepe,’ duwa.” ");
INSERT INTO xla_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Epame yia꞉ a watle yu epo atlepo ha꞉ha꞉mama yia꞉ yekalo daya atilimaleye gowalagowala depo natitepo, yia꞉ yekalo dulu dla yia꞉ta daya halomale maniye ma i-ilapo yekalo dulu dla hatili halla natiyo. Epalati yia꞉tapo yia꞉ a mate yia꞉ manita ma yia꞉ yekalo dulu dla me-hutiyela natipame yiyelepo sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Amasiyama yia꞉ a Yokobtapo koko e natipame yia꞉ watle epo atlaiyo, “Wua꞉ na꞉tapo na꞉ akimlala hapulomaye me-pokadlepo depame ipapele kokoye halomtamalema꞉? Adipalati, Yosepye mo-haoduwapo. Epame Simiyon ma mo-haodlepo. Epame wua꞉ matle Benyamin iye hamame tlowedeme apopa? Upiyele kokota na꞉ dla mo-woyamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Epalati asiyama Lubentapo epo atlaiyo, “Na꞉tapo Benyaminye Isip mo dla seme tapame ya꞉ye ma ilame woloma sempuluwepo. Amasiyama wa꞉ na꞉ta Benyaminye posempulalo wekelati natipame asiyama na꞉ akimlala dapiyamteye wa꞉ta potimelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Amasiyama Yokobtapo asiyama epo atlaiyo, “Hao, na꞉ maseyemala Benyamintapo wua꞉ mate Isip mo dla potlowa. Adipalati, ya꞉ bapa Yosep mo-polati yia꞉ wai Leisol ya꞉ akimlala dulu dla ma hatlo ya꞉ta halapo. Epedeme ya꞉ta Isip mo dla tamama koko haleta ya꞉ dla woyamelepiye, dupa kolle kokotapo na꞉ dla sikemte pasatamama na꞉ye polope,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Daya pa꞉le kokota ala Keinan mo dla me-ellati Yokobtapo ya꞉ akimlala mate yia꞉ta Isip mo tle daya halopo pualeye dlomha꞉ha꞉mama mosukulu pokadiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Epalati Yokobtapo ya꞉ akimlala watle epo atlaiyo, “Ma ilame tame Isip mo dla daya opiye halomaiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Amasiyama Yudatapo ya꞉ watle epo atlaiyo, “Di edla tamalemama Benyamin dimi tloweye poka꞉dena. Adipalati, dokopala oplamita di watle ipo atluwa, ‘Wua꞉ ma hema ilampumulumama Benyamin posempulalo wekelepiye, wua꞉ matle na꞉ta hala dla puame daya pohalomolowa,’ duwa. Epedeme di Isip mo dla ma ilame tamalemama Benyamin mate semtlowe ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Epalati Yokobta asiyama ya꞉ watle epo atlaiyo, “Wua꞉ adipalati upiyele na꞉ watle hamimama wua꞉ ei yemala me-halema dle koko ya꞉ watle atluwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Amasiyama ya꞉ akimlalatapo ya꞉ watle epo atlaiyo, “Dokopala oplamitapo di watle di kokoye sikemte dlalemtumama wua꞉ a totoyemala ma me-halema꞉, epame wua꞉ ei ma me-halema꞉ demtuwa. Di epalati ya꞉ yu asiyama dla di koko hapulomaye ya꞉ dla atlamuwa. Epapele dulu dla ma ya꞉ta atlemama wua꞉ ei ma me-sempumulaiye dla dalepame sikemte yiyeluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Epame Yudatapo ya꞉ a watle epo atlaiyo, “Ka꞉dena, wa꞉ Benyaminye na꞉ mate ta dene, etapo dita ma hapele tame Isip mo dla daya halopame ma ilame pulupe. Amasiyama dita pe-epapalalo wekelepiye, dita hapulomaye daya yilo pallipe. ");
INSERT INTO xla_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Na꞉ ikadepe koko wa꞉ watle atlema, na꞉tapo ya꞉ye ma ilame wa꞉ hala dla sempuluwepo. Amasiyama na꞉tapo wa꞉ hala dla posempulalo wekelepiye, e na꞉ batalimalepo, monolo asiyama halowepo. ");
INSERT INTO xla_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Amasiyama epele dulu dla di alilaye dosomha꞉ha꞉po. Adipalati, wa꞉ta Benyaminye dia꞉ mate potane desema. Wa꞉tapo dia꞉ye ka꞉yapa ma-hapele taiya dematiye, di etapo mo edla tepo pua dleye ma dapiyamte depo ha꞉ha꞉lemla.” ");
INSERT INTO xla_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Epalati yia꞉ atapo yia꞉ watle epo atlaiyo, “Epapelepiye mope, Benyaminye me-semtaiya. Amasiyama wua꞉ tamalemama dokopala oplami dla namkale dle alisisi ipapeleye halopo tamalaiya. Ullu ka꞉depo pamalalo dakopala mate, epame topsiyo mate, epo isole ta mate epo bolipi ta mate halopo telepe. ");
INSERT INTO xla_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Epame wua꞉ yekalo dulu dla mani hutiyeuwaye ma ilame tame dokopala oplami watle halopiye. Pona꞉malamana, oplami haleta yeliyele koko tle wua꞉ yekalo dulu dla mani hatiwayo. Epame ma mani opi wua꞉ta halopo taye eta daya amko halomaiye. ");
INSERT INTO xla_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Epammama Benyamin ma seme ma-tamalaiya. ");
INSERT INTO xla_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Epapedeme na꞉ God dla inoma sumale yu himma, ya꞉tapo dokopala oplami dla sadle hamilati Benyamin mate epo Simiyon mateye ma ilame wua꞉ mate pumullupo depame. Amasiyama Godtapo yia꞉ye paliya dlepiye, eta mepo palliwe ka꞉pi. Na꞉ God yu dla heodlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Epalati Yokob ya꞉ akimlalatapo namkale dle alisisi mate epo mani mate halopame Benyamin seme Isip mo dla Yosep hala dla ma hapele tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yia꞉ Isip mo dla tame Yosep hala dla woyamalati Yoseptapo Benyamin natipame ya꞉ oko oplami watle epo atlaiyo, “Opa iwolotapo wata alila dla na꞉ mate daya delepe. Epedeme yia꞉ye na꞉ aya dla eleme hetame aliya halo yumpo di daya ha꞉ne,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Epalati Yosep ya꞉ oko oplamitapo Yosepta atlale koko dolumama yia꞉ye elemhetaiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Amasiyama yia꞉ye epo elemtamallati yia꞉ sikemte wowota꞉le mate epo atlamtamalaiyo, “Ka꞉yapa di duli dulu dla mani ma i-ilapo hatiwa koko tle ya꞉tapo dia꞉ye hema hohopo tapo. Epame ya꞉tapo di donki aliyaye ma ya꞉ta elepame dia꞉ye hohopo asiyama pa꞉le oko dla hatitimalala,” demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Epapeleye yia꞉ Yosep aya dla tame woyapame ya꞉ oko oplami watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","22","“Ditapo amka꞉yapa daya halomala puwa oloma edla di daya halopo tame duka dla hutiyelowedeme popa꞉mama natilati dita daya halomuwa maniye ma ilame di yekalo dulu dla hatili halla natiwa. Amasiyama di podimalamana, oplami antapo mani eye ma ilame di yekalo dla hatiwo. Epedeme di mani eye ma ilame wa꞉ watle hamilowedeme hampumama dita daya amko halowe mani mate me-halopo pua,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Amasiyama Yosep ya꞉ oko oplamitapo asiyama yia꞉ watle epo atlaiyo, “Ase sikemte momalamama wowota꞉miya. Adipalati, wua꞉ mate epo wua꞉ a mate wua꞉ Godtapo wua꞉ maniye ma ilame wua꞉ yekalo dulu dla hatitimuwayo. Ame adipalati, di mani wua꞉ta halopiwaye ma-halomuwapo,” diyo. Epame ya꞉ yu i atlepo gudepo halemama Simiyonye yia꞉ watle hamame matiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Epapeleye Yosep ya꞉ oko oplamitapo yia꞉ye aya dulu dla elemhetame yia꞉ hete howahalomolowe yú tipo hamipame ma yia꞉ donki aliya daya ilimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Epame yia꞉ watle atlemama, “wua꞉ na꞉ dokopala oplami mate tamila꞉la daya delepe,” dlati dalepame yia꞉tapo Yosep watle namkale dle alisisi hamiloweye ma-dinapopo popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Epeleye Yosepta mo-pulati natipame yia꞉tapo namkale dle alisisiye halopo tuwame ya꞉ hete sitali dla heoheodepo popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Epalati Yoseptapo yia꞉ watle epo atlaiyo, “Wua꞉ a totoyemala ala me-ka꞉depo halema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Epalati asiyama yia꞉tapo ya꞉ watle epo atlaiyo, “Di a totoyemalaye me-ka꞉pi halema,” depame Yosep hete isili dla mamisika꞉ heoheodiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Epame Yoseptapo Benyamin natipame yia꞉ watle epo atlaiyo, “Iye wua꞉ ei yemala ikadepe ipa?” diyo. Epo halemama Benyamin watle atlemama, “Na꞉ maseyemala, Godtapo wa꞉ mate hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Amasiyama Yoseptapo Benyamin sikemte malamama ya꞉ta ellalo dulu dla tuwame amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Epame amale kaiyoye hiyolepame ma haliyamale dla ulamatiyo. Epame ya꞉ta dupa kolle kokoye me-hamame sela꞉mama ya꞉ oko so watle daya halopo matiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Epapeleye yia꞉ daya dlowedeme popa꞉mama Yosep meyelo polaiyo. Epame ya꞉ bapadulo ma miyelo popa꞉iyo. Epalati Isip so Yosep mate daya dlalo so mape miyelo popa꞉iyo. Adipalati, Isip sotapo yia꞉ aiyalma dolumama Hibulu so mate yimkata daya podesemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Amasiyama yia꞉ ala daya dlowedeme popa꞉mama Yoseptapo ya꞉ bapaduloye woloma ipila꞉mama ya꞉ bapa Luben tle kotiyapo ipila꞉mtame ya꞉ ei Benyamin dla tame gudiyo. Amasiyama Yosep ya꞉ bapadulotapo koko i natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Epame Yoseptapo ya꞉ oko so watle epo atlaiyo, “Wua꞉ta opa iwolo daya ilimama Benyamin tlo sikemte iye,” diyo. Epalati Yosep ya꞉ bapadulotapo sisiyele mate daya pato deiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Epapele dulu dla ya꞉ bapadulota daya ma-dempopa꞉po gudlati Yoseptapo tuwame ya꞉ oko oplami watle epo atlaiyo, “Wa꞉ opa iwolo dayaye yia꞉ yekalo dla atilimama sikemte poposatilimane. Epame yia꞉ mani mape i-ilapo hatine. ");
INSERT INTO xla_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Epame yia꞉ ei yekalo dulu dla na꞉ silba isilako mape medla hamatine,” diyo. Epalati ya꞉ oko oplamitapo Yosepta atlamale koko hapulomaye halomaiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Epame utulala ikadepe ya꞉ bapadulotapo yia꞉ yekalo daya atilimaleye yia꞉ donki aliya dla kolupame ma-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Epapeleye yia꞉ ala mo saliyome mateka꞉pi tiyama dla me-tamha꞉ha꞉lati Yoseptapo ya꞉ oko oplami watle atlemama, “Wa꞉ opa ala tamalale so alotle dodolomtame yia꞉ watle ipo atlane, ‘Na꞉ dokopala oplamitapo wua꞉ dla ka꞉dle koko halepo. Epapele tlope wua꞉ adipalati batalimale koko hamama ya꞉ta yú dlalo isilakoye uhampuo? Isilako etle na꞉ dokopala oplamitapo itapu dla wowoyamolowe kokoye atlamdepo,’ dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Epalati Yosep ya꞉ oko oplamitapo ma-hapele yia꞉ ko tle dodolomtame yia꞉ umpame Yosepta ya꞉ watle atlale kokoye ma yia꞉ watle atlaiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Amasiyama yia꞉ta yu i dalepame ya꞉ watle epo atlaiyo, “Di adipammama koko ipapele hapa꞉? Epapedeme di ikadepe koko wa꞉ watle atlema, di alisisi hale upohana. ");
INSERT INTO xla_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Epedeme dita amka꞉yapa daya halomala puwa oloma edla di daya halopo tame Keinan mo dla natilati dita daya halomuwa maniye ma ilame di yekalo dulu dla hatili haluwa. Epalati mani eye ma i-ilapo wa꞉ watle halopo pumuluwapo. Epapedeme di adipammama wa꞉ dokopala oplami tle alisisi hale dita uhapa꞉? ");
INSERT INTO xla_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Epedeme wa꞉ di yekalo totowatipame yekalo dulu tlamtane. Epapele dulu dla wa꞉ oplami ana yekalo dulu dla isilako e ellepiye, wa꞉ oplami etlo polowe dla himilipe. Epalati dita hapulomatapo wa꞉ dokopala oplami dla asiyama pa꞉le oko halalo so depo ha꞉ha꞉lowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Epapalati asiyama Yosep ya꞉ oko oplamitapo epo atlaiyo, “Me-ka꞉pi, epapele tlope isikimi isilako halalo oplami tlope asiyama pa꞉le oko halalo hallepe. Amasiyama wua꞉ta hapulomaye ma-tamalaiya dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","12","Epalati yia꞉tapo yia꞉ yekalo daya atilimaleye ipila꞉lati Yosep ya꞉ oko oplamitapo yekalo dulu tlamtamama yia꞉ bapa pato Luben yekalo tle kotiyapame totamtame yia꞉ ei yemala Benyamin yekalo dulu edla isilako ella natiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Epalati ya꞉ bapadulotapo koko i natipame sikemte dupa kolle pato himmama yia꞉ tluka tallatalladlalimaiyo. Epame yia꞉ yekaloye ma donki aliya dla ipila꞉pame ma ilame Yosep hala dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Epapeleye yia꞉ Yosep aya dla tame Yosep natipame ya꞉ hete sitali isili dla heoheodiyo. ");
INSERT INTO xla_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Epalati Yosepta yia꞉ watle epo atlaiyo, “Wua꞉ apa koko halowedeme na꞉ isilako uhame tao? Wua꞉ powua꞉malamata꞉, oplami na꞉ ipapeletapo inoma nalatimale tle opata hemele koko halomalalo tlamoloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Amasiyama Yudatapo ya꞉ watle epo atlaiyo, “Dia꞉ dla yu hale atlowe pa꞉ma. Adipalati, Godtapo dita batalimale koko halomuwa dla asiyama hamimama apeyo. Epapedeme hatlo di ei yemala Benyamintapo asiyama pa꞉le oko halalo pohallowa. Amasiyama dita yimkatatapo asiyama pa꞉le oko halomha꞉ha꞉lowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Amasiyama epalati Yosepta asiyama ya꞉ watle epo atlaiyo, “Hao, na꞉ pe-epapolowa. Isikimi na꞉ isilako uhale oplami tlope na꞉tapo na꞉ asiyama pa꞉le oko dla pamollowepo. Amasiyama wua꞉ta hapulomaye wua꞉ a hala Keinan mo dla ma-tamalaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Epalati Yudatapo itapu dla tame halemama Yosep watle epo atlaiyo, “Dokopala oplami, na꞉malamana, wa꞉ye Pelota itiyamale hamhala epapeleye hamhalapo. Amasiyama na꞉ye wa꞉ mila꞉pi tle koko pa꞉le oplami. Epapele tlope na꞉ solotama, wa꞉ mate woloma kulume yukamolowedeme. ");
INSERT INTO xla_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Epedeme dita ka꞉yapa daya halomala pulati wa꞉ta di watle ipo atluwapo, ‘Wua꞉ a waleta꞉? Epame wua꞉ ei yemala waleta꞉?’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Epalati dita wa꞉ watle atlemama, yao, dia꞉ a mate epo di ei yemala Benyamin, di ata mo-totoyemala halemama himili ma me-halema, duwapo. Epedeme na꞉ a ya꞉llu hale Leisol ya꞉ akimlala dapiyamte dulu dla hatlo Benyamin tlo halapo. Adipalati, ya꞉ bapaye mo-pouwapo. Epapele koko tle ya꞉ atapo ya꞉ye sikemte malamale pato elemde. ");
INSERT INTO xla_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Epame wa꞉ta atlemama wua꞉ ei yemalaye sempuaiye, na꞉ natilowama duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Epapalati ditapo wa꞉ watle ipo atluwapo, ‘Maseyemala etapo ya꞉ a saliyomtlowe poya꞉malamana. Ya꞉tapo ya꞉ a saliyome telepiye, ya꞉ ata isikimi mo-polope,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Amasiyama wa꞉tapo di watle epo atluwapo, ‘Wua꞉ta wua꞉ ei yemala posempulalo wekelepiye, wua꞉ matle puame na꞉ mila꞉pi ponatilowa,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Epalati ditapo ma ilame Keinan mo dla tame di a watle koko hapuloma wa꞉ta atlamuwa kokoye ya꞉ watle atlamuwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Epapalati di ata atlemama, ‘ma ilame tame Isip mo dla daya opi halomaiya,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Epalati asiyama ditapo ya꞉ watle epo atluwapo, ‘di dia꞉ ei yemalaye posemtlalo wekelepiye, di ma dokopala oplami ponatila tlowa,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Amasiyama di atapo di watle epo atluwa, ‘mo-wua꞉malamana, na꞉ a꞉ya Leisoltapo akimlala dapiyamte hatitimuwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Dulu edla haleye moko esemalata yumme douwayo, epalati hatlo tlo me-halapo. ");
INSERT INTO xla_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Epapedeme wua꞉tapo Benyamin ma seme tamama duka dla koko haletapo ya꞉ dla woyamelepiye, na꞉tapo dupa kolle pato natimama me-polope,’ duwapo.” ");
INSERT INTO xla_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Epame Yudatapo ma Yosep watle epo atlaiyo, “Epedeme na꞉ye na꞉ ei yemala dimi Keinan mo dla ilame potlowa. Adipalati, di atapo yami Benyamin tlope sikemte malamale pato elapo. Epapele dulu dla dita ma ilame tamalemama Benyaminta dia꞉ mate populalo wekelati natipame ya꞉ye polope. ");
INSERT INTO xla_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Epapedeme di batalimaletapo ya꞉ye pomama apelepe. ");
INSERT INTO xla_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Epame na꞉ matle na꞉ a watle ipo atluwa, ‘na꞉tapo Benyamin wa꞉ hala dla ma ilame posempulalo wekelepiye, e na꞉ batalimalepo, monolo asiyama halowepo,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Epedeme ka꞉dena, na꞉tapo na꞉ ei Benyamin mo dla halemama asiyama pa꞉le oko halowama. Epalati asiyama wa꞉ta Benyamin tlo ya꞉ a hala dla ilamtane dene. ");
INSERT INTO xla_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Adipalati, na꞉ Benyaminta na꞉ mate potlalo wekelepiye, na꞉ adipo na꞉ a hala dla tapa꞉? Epedeme na꞉ dupa kolle ipapeleye na꞉ a hala dla hamtlowe posolotamasema,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Epapele dulu dla Yoseptapo Yudata atlamale yu dalepame ya꞉skamu ya꞉ta dupa kolle koko hamoloweye po-ala꞉iyo. Epame ya꞉ta ya꞉ oko so hapulomaye aseka alikili a꞉ma taiya depame meyelo ya꞉ bapadulo mate halemama sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Epapele dulu dla Yoseptapo sikemte di dla amalati ya꞉ oko sotapo dalepame ma tame Pelo atlaiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Epame Yoseptapo ya꞉ bapadulo watle epo atlaiyo, “Na꞉ye Yoseppo! Na꞉ a me-halema꞉?” diyo. Amasiyama ya꞉ bapadulotapo Yosepta yia꞉ watle epo atla dalepame sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Epame Yosepta yia꞉ watle epo atlaiyo, “Na꞉ mateka꞉pi dla kulume pumulaiya,” diyo. Epalati yia꞉tapo mo-kulume pumullati mamisika꞉ yia꞉ watle epo atlaiyo, “Na꞉ye ikadepe wua꞉ ei Yoseppo! Na꞉ye wua꞉tapo Ismael so dla asiyama mate hamame ilati yia꞉tapo na꞉ye Isip mo hema hamame puwapo. ");
INSERT INTO xla_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Epapedeme wua꞉ta na꞉ dla ipapele koko hauwa dla ase sikemte dupa kolle hatitimama wua꞉ dulu dla alli momalamiya. Adipalati, Godtapo na꞉ye hema puane duwapo, na꞉tapo opa hapulomata daya pa꞉le koko dulu dla ha꞉ha꞉lati yia꞉ pasakalo gadlepo depame. ");
INSERT INTO xla_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Epedeme daya pa꞉le kokota elemama sokomoko dapiyamte mo-pololepo. Epame ditapo daya pa꞉le koko dulu dla ha꞉ha꞉lowe sokomoko ala itapu a꞉ma do supulastale me-hutiyepo. Dulu edla dlowe alisisita pomatlowa. ");
INSERT INTO xla_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Amasiyama Godtapo na꞉ye momolo itapu hema tane duwapo, na꞉tapo wua꞉ mate epo wua꞉ yimlala mate wua꞉ pasakalo gadlepo depame. ");
INSERT INTO xla_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Epapedeme yao, ikadepe, wua꞉tapo na꞉ye hema potane dena, amasiyama God meyelo na꞉ye momolo hema tane duwapo. Epame ya꞉tapo Pelota itiyamale hapulomaye na꞉ dla hapiwapo. Epalati na꞉tapo Isip mo patoye dokopala depo omhalapo. ");
INSERT INTO xla_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Epedeme wua꞉ ma hapele na꞉ a hala dla tame na꞉ta wua꞉ watle atlamale kokoye ma ya꞉ watle atlemama ‘wa꞉ maseyemala Yosep dla Godtapo Isip mo pato omhallowe itiyamaleye hamiyo. Epapedeme wa꞉ ma hapele ya꞉ hala dla pulupo duwa,’ delepe. ");
INSERT INTO xla_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","11","Epalati wua꞉tapo wua꞉ yimlala mate epame wua꞉ mamadulo mate epame wua꞉ aliya mate puame Isip mo dulu dla Gosen mo dla ha꞉ha꞉lepe. Epedeme wua꞉tapo na꞉ mateka꞉pi hema ha꞉ha꞉lati na꞉tapo wua꞉ye woloma omhallowepo. Adipalati, daya pa꞉le kokota elloweye sokomoko do supulastale me-a꞉ma hutiyepo. Amasiyama wua꞉tapo hema populalo wekelepiye, wua꞉ mate epo wua꞉ yimlala matetapo daya dlowe pa꞉mama pallipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Epame Yoseptapo mamisika꞉ yia꞉ watle epo atlaiyo, “Wua꞉ watapo wua꞉skamu me-malanatipo, na꞉ye ikadepe wua꞉ ei Yoseppo. Epame Benyamin wa꞉ mape na꞉ye me-malanatipo, na꞉ye ikadepe wa꞉ bapa Yoseppo. ");
INSERT INTO xla_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Epapedeme wua꞉ tame na꞉ a watle na꞉ta Isip mo hema dokopala depo itiyamale hapo hala kokoye atlaiye. Epame wua꞉ta hema tlama koko hapuloma mape tame ya꞉ watle atlepame ya꞉ye hema ma hapele sempuaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Epapeleye Yoseptapo yu i atlemhalepo gudepame Benyamin hamame poposila꞉lepo amaiyo. Epalati Benyamin mape asiyama ya꞉ye hamame amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Epame matle ya꞉ bapadulo hapuloma hohopo poposila꞉lepame amhalaiyo. Epame alotle yia꞉tapo yimkata esempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Epapele dulu dla Pelo mate epo ya꞉ oko so mateta Yosep ya꞉ bapadulota puale koko dalepame sikemte sisiyeiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","18","Epammama Pelotapo Yosep watle epo atlaiyo, “Wa꞉ bapadulo atlamane, yia꞉tapo yia꞉ dayaye donki aliya dla kolupame yia꞉ a mate epo yia꞉ wola꞉ mate epo yia꞉ yimlala mate elemala telepo depame. Epalati na꞉tapo Isip mo hema yia꞉ta ha꞉ha꞉lowe ta꞉la ka꞉dleye hamilowepo. Epalati yia꞉tapo edla ha꞉ha꞉mama dlowe alisisi pasatale dulu dla ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","20","Amasiyama yia꞉ tamalemama na꞉ aliya koa opi elemtamellepo, yia꞉tapo ma ilame pumulumama yia꞉ wola꞉ mate yia꞉ yimlala mate epo yia꞉ a mate elempumulluweye. Epele dulu dla yia꞉ pumulumama yia꞉ alisisi medla pomeleme pumullupo. Adipalati, yia꞉ta hema pumullati na꞉tapo yia꞉ watle ta꞉la ka꞉dle mate epo alisisi ka꞉ka꞉dle mate halopiliwepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Epapeleye Yoseptapo Pelota atlamale yu dolumama ya꞉ bapadulo watle aliya koa mate epo yia꞉ta duka dla tamama daya dlowe mate halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Epame ya꞉ bapadulo dla tluka amko didiyelowe halopiyo. Amasiyama Benyamin tlo tluka didiyelowe do supulastale mate epo 300 elo mani mate halopiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Epame ya꞉ a watle namkale dle hamimama donki aliya 10 dla Isip mo dla alisisi ka꞉ka꞉dle hutiyeleye kolupame hamiyo. Epame donki aliya molala 10 dla daya kolupo hamiyo, ya꞉ atapo Isip mo dla pumama daya dempulupo depame. ");
INSERT INTO xla_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Epapeleye ya꞉ bapadulota ma-tlati yia꞉ watle epo atlaiyo, “Wua꞉ duka dla tamalemama woloma tamalaiye, ase sikemte momalamtamalemiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Epapedeme yia꞉ Isip mo saliyome tame yia꞉ ata hala Keinan mo dla tame woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Epame ya꞉ watle epo atlaiyo, “A, Yosepye ala me-halema! Ya꞉ye popolalo wekena! Ya꞉ye Isip mo dla dokopala oplami halapo,” diyo. Amasiyama yia꞉ a Yokobtapo yu i dalepame sikemte yielemama pomikadepe dlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Amasiyama ya꞉tapo Yosepta atlamale koko hapuloma dalepame ma ya꞉ta aliya koa halopili dla natimama edla mikadepe diyo. ");
INSERT INTO xla_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Epame epo atlaiyo, “Na꞉ watapo wua꞉ta atlama koko dla mikadepe dema. Adipalati, na꞉ maseyemala Yosepye ala me-halemapo. Epedeme na꞉ Isip mo dla tame ya꞉ natipame edla polowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Epapeleye alila haletapo Yokobta ya꞉ wola꞉ mate epame yia꞉ yimlala mate Isip mo dla ma-tamalaiyo. Yia꞉ tamalemama Belseba mo dla woyapame Yokobta ya꞉ a Aisek ya꞉ God hi di dla ta꞉demama aliya halo poyupame God watle hapiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Epalati utula꞉la oloma edla Godtapo milamalo tulume ya꞉ watle epo atlaiyo, “Yokob, Yokob!” Epalati Yokobta asiyama epo atlaiyo, “Lod, na꞉ ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Epalati Godtapo ya꞉ watle epo atlaiyo, “Na꞉ye wa꞉ a Aisek ya꞉ Godpo. Epedeme wa꞉ Isip mo dla tloweye powota꞉lowa. Adipalati, edla na꞉tapo wa꞉ mamadulo pasatepo mellowepo. ");
INSERT INTO xla_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Epedeme wa꞉ta Isip mo dla tame hallepiye, na꞉tapo wa꞉ye woloma omhallowepo. Epame alotle na꞉tapo wa꞉ mamaduloye Isip mo tle Keinan mo hema eleme puluwepo. Epame wa꞉ta polowedeme ellati Yoseptapo wa꞉ gadlalo hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Epame yia꞉ utulalati ma-tamalemama Yokob ya꞉ akimlalatapo yia꞉ a mate epo yia꞉ wola꞉ mate epame yia꞉ yimlala mateye Pelota aliya koa hapili di dla ipila꞉po tamalaiyo. Yia꞉ tamalemama yia꞉ halo mate epo yia꞉ alisisi Keinan dla halomale hapuloma mate me-halopo Isip mo dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Epapele dulu dla Yokob ya꞉ akimlala, Isalael so iwolotapo yia꞉ a Yokob mate yimkata Isip mo dla tamalaiyo. Eye iwolopo, itapu hamale maseyemalaye Lubenpo. ");
INSERT INTO xla_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Epame Lubenta hatitimale akimlalaye iwolopo, Hanok, epo Palu, epo Heslon, epame Kalmi. ");
INSERT INTO xla_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Epame Luben ko tle himili maseyemala haleye Simiyonpo. Epalati Simiyonta hatitimale akimlalaye iwolopo, Yemuel, epo Yamin, epo Ohad, epo Yakin, epo Sohal, epo ma haleye Saul, Keinan a꞉yata himili. ");
INSERT INTO xla_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Epame Simiyon ko tle himili maseyemala haleye Libaipo. Epalati Libaita hatitimale akimlalaye iwolopo, Geson, epo Kohat, epame Melali. ");
INSERT INTO xla_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Epame Libai ko tle himili maseyemala haleye Yudapo. Epalati Yudata hatitimale akimlalaye iwolopo, El, epo Onan, epo Sala, epo Peles, epame Sela. Amasiyama El mate Onan mateye ala Isip mo dla populalo ha꞉ha꞉mama Keinan mo medla paliyo. Epele dulu dla Yuda yami hale Pelesta hatitimale akimlalaye Heslon mate epo Hamul matepo. ");
INSERT INTO xla_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Epame Yuda ko tle himili maseyemala haleye Isakalpo. Epalati Isakalta hatitimale akimlalaye iwolopo, Tola, epo Puwa, epo Yasub, epo Simlon. ");
INSERT INTO xla_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Epame Isakal ko tle himili maseyemala haleye Sebulunpo. Epalati Sebulunta hatitimale akimlalaye iwolopo, Seled, epo Elon, epo Yahelel. ");
INSERT INTO xla_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Epapele dulu dla akimlala iwoloye Yokob ya꞉llu hale Liyatapo Padan Alam mo dla ha꞉ha꞉mama hatitimalepo. Epele dulu dla ya꞉ amseyemala hatlo tlo himiyo, ya꞉ hiye Daina. Epedeme Liya yimlala mate epo ya꞉ awadulo mate hatlo godepo sesa꞉lati 33 umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Epame Yokob ya꞉llu hale Silpata ka꞉yapa hamale maseyemalaye Gadpo. Epalati Gadta hatitimale akimlalaye iwolopo, Sepon, epo Hagi, epo Suni, epo Esbon, epo Eli, epo Alodi, epo Aleli. ");
INSERT INTO xla_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Epame Gad ko tle himili maseyemala haleye Aselpo. Epalati Aselta hatitimale akimlalaye iwolopo, Imna, epo Isba, epo Isbi, epo Beliya. Epame yia꞉otumala hatloye Selapo. Amasiyama Beliya ya꞉ akimlalaye Hebel mate epo Malkiel matepo. ");
INSERT INTO xla_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Epapele dulu dla akimlala iwoloye Yokob ya꞉llu hale Silpata hatitimalepo. Epedeme ya꞉ akimlala iwolo mate epo ya꞉ awadulo mate hatlo godepo sesa꞉lati 16 umaiyo. Amasiyama Silpa iye Labanta yoti Liya watle hamame ili oko a꞉yapo. ");
INSERT INTO xla_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Epame ma Yokob ya꞉llu hale Leisolta hatitimale akimlalaye Yosep mate epo Benyamin matepo. ");
INSERT INTO xla_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Epapeleye Yoseptapo Heliyopolis mo dla alinepi poyupo god dla hamilalo oplami Potipela yoti Asenat haiyo. Epame akimlala dapiyamte hatitimaiyo, yia꞉ hiye Manase mate epo Eplaim matepo. ");
INSERT INTO xla_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Epame Benyaminta hatitimale akimlalaye iwolopo, Bela, epo Bekel, epo Asbel, epo Gela, epo Naman, epo Ehi, epo Los, epo Mupim, epo Hupim, epo Alad. ");
INSERT INTO xla_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Epapedeme Leisolta hatitimale akimlala mate epo ya꞉ awadulo mate hatlo godepo sesa꞉lati 14 umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Epame Yokob ya꞉llu hale Bilhata ka꞉yapa hamale maseyemalaye Danpo. Epalati Dan yamiye Husimpo ");
INSERT INTO xla_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Epame Dan ko tle himili maseyemala haleye Naptalipo. Epalati Naptalita hatitimale akimlalaye iwolopo, Yasiyel, epo Guni, epo Yesel, epo Silem. ");
INSERT INTO xla_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Epapele dulu dla akimlala iwoloye Yokob ya꞉llu hale Bilhata hatitimalepo. Epedeme ya꞉ akimlala mate epo ya꞉ awadulo mate hatlo godepo sesa꞉lati 7 umaiyo. Amasiyama Bilha iye Labanta yoti hale Leisol watle hamame ili oko a꞉yapo. ");
INSERT INTO xla_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Epapedeme Yokob ya꞉ yimlala mate epo ya꞉ mamadulo mate hatlo godepame Isip mo dla tlowedeme sesa꞉lati 66 umaiyo. Amasiyama yia꞉ta yia꞉skamu sesa꞉le oloma dla Yokob ya꞉ momaduloye posesa꞉lalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Epame alotle Yokob yami hale Yosep mate epo ya꞉ akimlala Isip mo dla hohomale mate ma hatlo godepo sesa꞉lati 70 umaiyo. ");
INSERT INTO xla_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Epapele dulu dla Yokob ala Isip mo dla puluwedeme duka dla pumhalemama yami Yuda watle epo atlaiyo, “Wa꞉ tatle tame Yosep atlane, ya꞉ puame Gosen mo dla dia꞉ye umulupo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Epalati Yudatapo tame Yosep atlati ya꞉tapo ya꞉ aliya koa tle tame Gosen mo dla ya꞉ a umaiyo. Epame ya꞉tapo ya꞉ a mila꞉pi natipame ya꞉ a dla poposila꞉lepo hamame sikemte ammama kelliwe pa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Epalati ya꞉ atapo Yosep watle epo atlaiyo, “Na꞉ maseyemala, wa꞉ ala me-halemapo! Epedeme na꞉ wata oloma hema wa꞉ mila꞉pi natipame polowe mleni,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Epame Yoseptapo ya꞉ a mate epo ya꞉ bapadulo mate dla epo atlaiyo, “Na꞉ tame Pelo watle atlemama wua꞉ye Keinan mo tle mo-puame ma Gosen mo dla popa꞉ma dlowama. ");
INSERT INTO xla_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Epame ma ya꞉ watle atlemama wua꞉ye aliya halo omha꞉ha꞉lalo so deme wua꞉ aliya mate epo wua꞉ alisisi hapuloma mate me-halopo pumulana dlowepo. ");
INSERT INTO xla_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Epapedeme Pelotapo wua꞉ye sisilapame wua꞉ watle atlemama, wua꞉ apa oko halomha꞉ha꞉mdi? dlati, asiyama ya꞉ watle atlemama, dia꞉ye di mamadulota mo-powataliya aliya omha꞉ha꞉lalo oko hampuwademe, di mape mepo aliya omha꞉ha꞉mde, diye. Adipalati, wua꞉tapo Pelo watle epo atellepiye, asiyama ya꞉tapo wua꞉ watle atlemama Gosen mo medla ha꞉ha꞉iya dlepe. Ame adipalati, Isip soye aliya omha꞉ha꞉lalo so mate yimkata poha꞉ha꞉semde,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Epapeleye Yosepta Pelo hala dla tame ya꞉ watle epo atlaiyo, “Na꞉ a mate epo na꞉ bapadulo mate epo yia꞉ aliya halo mate epame yia꞉ alisisi hapuloma mate Keinan mo tle mo-puame Gosen mo dla popa꞉ma,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","3","Epalati Yosepta ya꞉ bapadulo do supulastaleye Pelo hala dla elempulati Pelota yia꞉ watle epo atlaiyo, “Wua꞉ apa oko halomdi?” diyo. Epalati asiyama yia꞉tapo ya꞉ watle epo atlaiyo, “Dia꞉ye di mamadulotapo mo-powataliya aliya omha꞉ha꞉lalo ha꞉ha꞉deme, di mape aliya omha꞉ha꞉lalo ha꞉ha꞉ma. ");
INSERT INTO xla_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Amasiyama di mo Keinan dla daya pa꞉le kokota elemama di aliyata dlowe osamokolo ma hawa. Epalati natipame di hema ha꞉ha꞉la pumula. Epedeme ka꞉deta꞉, ditapo Gosen mo dla ha꞉ha꞉loweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Epalati Pelotapo Yosep watle epo atlaiyo, “Watapo wa꞉ a mate epo wa꞉ bapadulo mate mo-pumulalepo. ");
INSERT INTO xla_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Epedeme ka꞉dena, yia꞉tapo Isip mo dulu hema ha꞉ha꞉loweye. Epapedeme Gosen mo ka꞉dleye yia꞉ watle hamine. Epame yia꞉ dulu dla oplami hale aliya omhallowe sikemte malastale hallepiye, ya꞉ ka꞉dena na꞉ aliya halo mate omhalloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Epame Yoseptapo ma tame ya꞉ a Yokobye Pelo hala dla sempulati ya꞉tapo Pelo dla namkale dle yu atlemama Godta wa꞉ mate hallepe diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Epalati Pelota asiyama ya꞉ watle epo atlaiyo, “Wa꞉ sokomoko adisowata꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Epalati Yokobta asiyama ya꞉ watle epo atlaiyo, “Na꞉ye ta꞉lamo wotiyalle dulu dla halemama 130 sokomoko pololuwa. Amasiyama na꞉ mamadulota ha꞉ha꞉le sokomokota na꞉ sokomokoye tla꞉mtana,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ya꞉ epo atlepo Pelo watle atlemama Godta wa꞉ mate hallepe depame ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Epapedeme Yoseptapo Pelo yu dolumama ya꞉ a mate epo ya꞉ bapadulo mate dla ta꞉la ka꞉pi Lamses mo mateka꞉pi dla ellaloye yia꞉ watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Epame yia꞉ watle daya pasataleye alemdiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Epapeleye daya pa꞉le kokotapo mo pato hamama Isip mo mate epo Keinan mo mate dla dlowe alisisi emaletapo hapuloma paliyo. ");
INSERT INTO xla_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Epalati opatapo Yosepta Isip mo dla aya dulu dla daya kokolumtaleye puame mani mate halomha꞉ha꞉iyo. Epapalati Yoseptapo maniye halopame ma Pelo ya꞉ mani isilako dla kolumhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Amasiyama Isip sota yia꞉ maniye daya halomha꞉ha꞉mama mo-pokapokadlati Yosep hala dla tame ya꞉ watle epo atlaiyo, “Di daya halomha꞉ha꞉mama di maniye mo-pokapokadema. Epedeme wa꞉ di daya isikimi me-hapine. Adipalati, wa꞉ta pe-epapalalo wekelepiye, di pallipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Epalati asiyama Yoseptapo yia꞉ watle epo atlaiyo, “Wua꞉ mani ma hawa hallepiye, isikimi asiyama wua꞉ aliya haloye na꞉ watle hohopo iya. Epalati na꞉tapo asiyama wua꞉ watle daya halopimhallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Epapedeme opatapo Yosep watle aliya halo hohopo pumula demha꞉ha꞉lati asiyama ya꞉tapo daya alema demhalaiyo. Yia꞉ta epammha꞉ha꞉mama yia꞉ hos aliya mate epo yia꞉ sipi aliya mate epame yia꞉ gaut aliya mate epo yia꞉ bulumkiyawa aliya mate epo yia꞉ donki aliya mate Yosep watle hapimha꞉ha꞉mdiyo. Epammtamama sokomoko hatlo ma-hamastlati opata daya halomha꞉ha꞉mama yia꞉ aliya halo hapuloma mo-pokapokadiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Epalati yia꞉ Yosep hala dla tame epo atlaiyo, “Ditapo wa꞉ watle asiyama mate daya halomha꞉ha꞉mama di mani mate epame di aliya halo mate mo-pokapokadepo. Epapedeme di ma apa alisisi wa꞉ dla halopimama asiyama daya halopa꞉? Dia꞉ dla di alisisi hapulomaye ma-hawa, isikimi di moto i mate epo di ta꞉la mate tlo me-hutiyepo. ");
INSERT INTO xla_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Epapedeme poka꞉dena, ditapo daya teta꞉le koko tle palimama di ta꞉laye isikimi koko pa꞉le batalipo hamastloweye. Epedeme wa꞉tapo daya mate epo dlowe alisisi emolowe ale mate di watle hapilati asiyama ditapo di moto mate epo di ta꞉la mate wa꞉ watle hapilowepo. Epame ditapo Pelo dla asiyama pa꞉le oko hamha꞉ha꞉lati ya꞉tapo di ta꞉la omhallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Epapele dulu dla daya pa꞉le kokotapo Isip moye sikemte batalipo hamastlati Isip so hapulomatapo daya yilo yia꞉ ta꞉la hapulomaye Yosep watle halopimama pokapokadiyo. Epalati Pelotapo yia꞉ ta꞉la hapulomaye omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Epame Yoseptapo Isip so hapulomaye Pelo dla asiyama pa꞉le oko halalo so diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Amasiyama god dla alinepi poyupo hapilalo so tlo yia꞉ ta꞉laye daya yilo Yosep watle pohalopilalo wekiyo. Adipalati, Pelotapo yia꞉ oko asiyamaye hapimama daya mate halopimdiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Epame Yoseptapo opa watle epo atlaiyo, “Watapo wua꞉ mate epo wua꞉ ta꞉la mateye dokopala oplami Pelo tetepo. Epedeme na꞉tapo wua꞉ watle dlowe alisisi emolowe aleye halopiliwepo. ");
INSERT INTO xla_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Epalati wua꞉tapo dlowe alisisiye empame ma-hauwallowe oloma dla pulati hauwalemama opi tlo Pelo watle halopi demha꞉ha꞉lepe. Epame muwolo haloma dulu edla opiye tlo demama asiyama opi tlo ale emolowe koluma demha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Epalati asiyama yia꞉tapo Yosep watle epo atlaiyo, “Wa꞉tapo di pasakaloye gaduwapo. Epapedeme ditapo dokopala oplami Pelo dla asiyama pa꞉le oko hamha꞉ha꞉mama ya꞉ yu dla salladepo siyamolowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Epalati Yoseptapo aiyalma himiyo, Isip sota dlowe alisisi emale hauwalemama kolumale do supulastale dulu dla kolumale hatlo tlo Pelo watle hami demha꞉ha꞉lepo depame. Epapedeme aiyalma himili iye wata oloma hema ala me-elapo. Amasiyama epapele dulu dla alinepi poyupo god dla halopilalo so yia꞉ ta꞉la tlo Pelo dla pohalopilalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Epedeme Isalael sotapo Gosen mo dla ha꞉ha꞉mama yimlala sikemte isukumama opata pasatamtaiyo. ");
INSERT INTO xla_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","30","Epapeleye Yokobtapo Isip mo dla tame halemama 17 sokomoko pololiyo. Epame ya꞉tapo ma 147 sokomoko umulati polowetapo ya꞉ dla mo-teteka꞉mpuaiyo. Epalati ya꞉tapo ya꞉ maseyemala Yosep sisilapame ya꞉ watle epo atlaiyo, “Wa꞉ ikadepe na꞉ye sikemte malahalema dlepiye, wa꞉ na꞉ motoye Isip mo hema pohamatilowa. Amasiyama wa꞉ tame Keinan mo dla na꞉ mamadulo hatili wabasi hatlo medla na꞉ motoye hamatine,” diyo. Epalati Yoseptapo asiyama ya꞉ watle epo atlaiyo, “Yao, na꞉ta wa꞉ta atlama koko hapuloma eye halowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Epame ma Yokobtapo ya꞉ watle epo atlaiyo, “Wa꞉ watapo na꞉ mila꞉pi tle God hi tle yu itiyapo himine, wa꞉ta ikadepe na꞉ motoye Keinan mo dla hamatiloweye,” diyo. Epalati asiyama Yoseptapo God hi mate yu itiyapo himiyo, ya꞉ a motoye Keinan mo dla hamatiloweye. Epalati Yokobtapo ya꞉ta ellalo dla dokopala himme elemama inoma sumaiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Epapele dulu dla alila haletapo Yosepta ya꞉ ata sikemte esiyem-elale dalepame ya꞉ akimlala dapiyamte Manase mate Eplaim mate elepo Gosen mo dla ya꞉ a natila puaiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Epapeleye ya꞉ a Yokobta Yosepta puale dalepame esiyem-elale mepapele itiyamale hapame sila꞉time polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","Epame yami Yosep watle epo atlaiyo, “Itiyamale Godtapo mo-powataliya na꞉ye Keinan mo pato dulu dla Lus mo yemala dla pollati na꞉ watle woyapo epo atluwapo, ‘Na꞉tapo wa꞉ mamaduloye pasatepo mellowepo. Epalati wa꞉ opatapo pasatamama pato dlepe. Epame na꞉tapo Keinan mo iye wa꞉ mamadulo watle hamilowepo. Ta꞉la itapo yia꞉ hi mate kokó mepo ellepe,’ duwapo.” ");
INSERT INTO xla_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Epame Yokobtapo Yosep watle ma epo atlaiyo, “Na꞉ ala Isip mo hema populalo hallati wa꞉tapo akimlala dapiyamte Eplaim mate Manase mate hatitimuwapo. Amasiyama na꞉ solotama, na꞉tapo wa꞉ akimlala dapiyamte ewoloye ma na꞉ta hohopame na꞉ akimlala ikadepe dlowepo. Yia꞉tapo na꞉ akimlala itapu hatitimale Luben mate epo Simiyon mate epapele some na꞉ akimlala depo ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Epame ma alotle wa꞉ta akimlala isukumelepiye, akimlala ewolotapo mo-wa꞉ akimlala ikadepe depo ha꞉ha꞉lepe. Amasiyama yia꞉tapo Eplaim mate epo Manase mate yia꞉ elo dla ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Epedeme na꞉tapo wa꞉ akimlala Eplaim mate epo Manase mateye wa꞉ wai Leisol ya꞉ akimlala ikadepe dlowepo. Adipalati, wa꞉ wai Leisoltapo Keinan mo dla dia꞉ye Padan Alam mo tle ma Epalat mo dla pumha꞉ha꞉mama duka dla pouwapo. Epalati na꞉tapo dupa kolle pato mate ya꞉ motoye Epalat dla tlalo api mateka꞉pi dla polomoluwapo.” ");
INSERT INTO xla_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Amasiyama Yokobye mo-totoyemalata inoma pa꞉mama yami Yosep ya꞉ akimlala natipo epo atlaiyo, “Akimlala iwoloye anawolota꞉?” diyo. Epalati asiyama Yosepta epo atlaiyo, “Na꞉ akimlalapo. Akimlala iwoloye na꞉ta Isip mo dla hallati Godtapo na꞉ watle halopiwapo,” diyo. Epapalati Yokobtapo ya꞉ watle epo atlaiyo, “Yia꞉ye na꞉ watle elempuane. Epalati na꞉tapo yia꞉ye hohopo inoma sumama God dla ta꞉dlowepo,” diyo. Epedeme Yoseptapo ya꞉ akimlala dapiyamteye ya꞉ hala dla elempulati Yokobtapo yia꞉ye hohopo poposila꞉lepo huhulamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Epame Yokobtapo ma Yosep watle epo atlaiyo, “Na꞉ta malamaletapo wa꞉ye ma ponatilalo wekelowe tepo demduwa. Amasiyama wata Godtapo hatlo wa꞉ tlo ponati-ina, amasiyama wa꞉ akimlala mape na꞉ watle me-nati-ilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Epame Yoseptapo ya꞉ akimlala dapiyamteye yia꞉ mama Yokob mulu tle hohopo alikili dla ipila꞉pame asiyama ya꞉tapo ya꞉ a hete isili dla heodepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Epame Yoseptapo ya꞉ maseyemala pato Manaseye ya꞉ a do dowala tiyama dla pameliyo. Epalati ya꞉ ei Eplaimye hamame ya꞉ a do weke tiyama dla pameliyo. ");
INSERT INTO xla_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","15","Amasiyama Yokobtapo akimlala dapiyamte iwolo dla inoma sumale mate yia꞉ye God dla ta꞉demama ya꞉ dowala dotapo ya꞉ ei Eplaim dokopala dla hamaiyo. Epalati ya꞉ weke dotapo ya꞉ bapa Manase dokopala dla hamaiyo. Epo halemama epo atlaiyo, “Na꞉ mama A꞉iblaham mate epo na꞉ a Aisek mate yia꞉ God wa꞉tapo na꞉ pasakaloye woloma omhalemduwapo. ");
INSERT INTO xla_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Epame wa꞉ banakaka oplamitapo na꞉ta wotiyalle dulu dla pollati na꞉ye gademduwapo. Epedeme wa꞉ akimlala dapiyamte iwoloye gademama yia꞉ mate halane. Epame yia꞉ tle na꞉ a hi mate epo na꞉ hi mate epo na꞉ mama hi mate ma-a꞉ma selemalipo melemama yia꞉ yimlala mate epo yia꞉ mamadulo mate pasatepo melene,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Amasiyama Yokobtapo ya꞉ dowala dota Eplaim dokopala dla hama epela asiyama ya꞉ weke dota ya꞉ bapa Manase dokopala dla hama depo halemama inoma sumalati yami Yosepta koko e natipame posiyeiyo. Epammama ya꞉tapo ya꞉ a doye alikili a꞉ma poloko demama epo atlaiyo, “A, wa꞉ dowala doye itapu hamale maseyemala dokopala dla pohamamhalasema. Amasiyama ma ya꞉ ei yemala dokopala dla hamamhalapo. Epedeme wa꞉ dowala doye itapu hamale maseyemala Manase dokopala dla hamolowe ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Amasiyama ya꞉ ata Yosep watle epo atlaiyo, “Na꞉ta koko i haye na꞉malamana. Adipalati, ya꞉ ei yemala Eplaim ya꞉ mamadulotapo sikemte pasatamama ya꞉ bapa Manase ya꞉ mamaduloye tla꞉mtelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Epame Yokobtapo akimlala dapiyamte iwoloye inoma sumale mate ta꞉demama epo atlaiyo, “Alotle Isalael sotapo yimkadulo watle epo atlamyelepe, ‘Godtapo Eplaim mate epo Manase mate dla gadle pato himhaluwaye, epammama ya꞉tapo wua꞉ watle mepo gadle pato himhallepe,’ demyelepe,” diyo. Epammama ya꞉tapo ya꞉ ei yemala hi tatle itapu tle himimama asiyama ya꞉ bapa hi tlo alotle himiyo. ");
INSERT INTO xla_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Epame Yokobtapo yami Yosep watle epo atlaiyo, “Na꞉ye mo-polowe mateka꞉pi dla halapo. Epedeme Godtapo wa꞉ mate hallepe. Epame ma ya꞉tapo wua꞉ye wua꞉ mamadulo watle Keinan mo hamili duwa edla elemtelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Epame Yokobtapo ma ya꞉ watle epo atlaiyo, “Keinan mo dulu dla Sekem ta꞉laye pta ka꞉pi. Epedeme ta꞉la eye wa꞉ bapadulo watle pohamilowa. Amasiyama Yosep wa꞉ watle hamilowepo. Ta꞉la eye na꞉tapo Amoli so mate nalatimama kolahauwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Yokobtapo ya꞉ akimlala hapulomaye sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ta hapuloma yimkata na꞉ mateka꞉pi dla puame alumaiya. Epalati na꞉tapo wua꞉ watle itapu dla wowoyamolowe kokoye atlamolowepo. Adipalati, na꞉ye Yokob, wua꞉ a Isalaelpo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Epammama ya꞉tapo ya꞉ maseyemala itapu hamale watle epo atlaiyo, “Luben wa꞉ye na꞉ kipiliyemala omalita ka꞉yapa himili maseyemalapo. Epame wa꞉tapo na꞉ akimlala hapuloma dulu dla wa꞉ta itapu halemama wa꞉ eiduloye tla꞉mtame haluwapo. ");
INSERT INTO xla_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Amasiyama wa꞉ye wa꞉skamu wa꞉ moto hamoloweye powa꞉malamana. Adipalati, wa꞉tapo wa꞉ wai hale uhale koko tle na꞉ dla wota꞉le hampuwapo. Epapedeme wa꞉ eidulo dulu dla wa꞉tapo podokopala depo hallowa. ");
INSERT INTO xla_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Epame Simiyon wa꞉ mate epo wa꞉ ei Libai mateye wua꞉ dulu dla sadle halowe powua꞉malamana. Adipalati, wua꞉ye yimkadulo mate sikemte nalatimha꞉ha꞉mde. ");
INSERT INTO xla_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Epedeme wua꞉tapo batalimale koko halomolowedeme yu hatitimale dulu dla na꞉ mate pohallowa. Adipalati, wua꞉ sikemte siyalasiyaladepame aipa꞉yata upo opaye mo-potimuwapo. Epame isikimi asupumale koko tle bulumkiyawa aliya heteye ma-hauwokokomuwapo. ");
INSERT INTO xla_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Epapedeme na꞉tapo wua꞉ koko e natimama keteyamale yu atlema. Ka꞉dle kokota wua꞉ dla populuwa. Epame wua꞉ mamadulotapo Isalael so elele dulu dla meyelope meyelope depo tame ha꞉ha꞉myelepe. ");
INSERT INTO xla_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Epame Yuda wa꞉ye wa꞉ bapadulo mate epo wa꞉ eidulo matetapo wa꞉ dla sisiyemama wa꞉ hete sitali isili dla heoheodemha꞉ha꞉lepe. Adipalati, wa꞉ta itiyamaletapo wa꞉ dla opahale dlalo sota itiyamaleye tla꞉mtame hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Epame wa꞉ye layon esemala some ya꞉ nomsu yumdepame oplami haleta pohustlalo woloma ka꞉pi elemdiye, epapele some hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Epedeme Isalael so dulu dla Yuda elele halomale sotapo dokopala ha꞉ha꞉mtelepe. Epammtamama yia꞉ dulu tle ma ikadepe dokopala oplami halloweta alotle pulupe. Epalati opa hapulomatapo hatlo ya꞉ yu dla heodepo sallademha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Epame wa꞉ gla꞉pi dlomoko dalitapo sikemte pasatamama wain yú ma sikemte pasatepo hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Epame wa꞉ inomatapo dikimama wain yú some hallepe. Epalati wa꞉ a꞉petapo sikemte kamama memeko some hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Amasiyama Sebulun wa꞉ye kaula pato peleyama dla halemsela꞉lepe. Epame wa꞉ta hallowe mo edla koa patototapo puame hedlowe koa sitali ka꞉pita halemyelepe. Epame wa꞉ ta꞉la sukulutapo tame Saidon mo dla gudlepe. ");
INSERT INTO xla_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Epame Isakal wa꞉ye itiyamale donki aliyatapo upiyele alisisi pato asiyame pupo depo hedepo elemdiye, epapele some hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Epame wa꞉tapo puame hedlowe mo ka꞉dle natipame ma edla asiyama pa꞉le oko halowe ma po-alimhallowa. ");
INSERT INTO xla_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Amasiyama Dan wa꞉tapo Isalael so dulu dla yia꞉ koko gladlalo hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Epame wa꞉ye kolape ilama some halemama hos aliya hete dla yiellati yota ta꞉la dla teyu demhallepe.” ");
INSERT INTO xla_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Epapele dulu dla Yokobtapo epo atlaiyo, “Lod God, na꞉ wa꞉ta na꞉ pasakalo gadlowe koko dla omhalapo,” diyo. Epame ma ya꞉ akimlala dla helestame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad wa꞉ye opatapo puame hustepo dodoloma demha꞉ha꞉lepe. Epalati asiyama wa꞉tapo yia꞉ye posallati, yia꞉tapo wa꞉ tle potademha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Epame Asel wa꞉ ta꞉la dla dlowe alisisi ka꞉ka꞉dleta matelepe. Epalati wa꞉tapo dokopala sota dlalo dlowe alisisiye halomhallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Amasiyama Naptali wa꞉ye diya aliya malalatapo ya꞉ yimlala ka꞉ka꞉dle usulupame inoma tetleyamama tlesela꞉mdiye epapele some sela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Epame Yosep wa꞉ye dlomoko dali dlo seselemallita sikemte milimaletapo yú matale mateka꞉pi dla halemdiye, epapele some hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Amasiyama wa꞉ dla opahale dlalo sotapo wa꞉ye sikemte siyaladle mate husta demhallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Amasiyama epapele tlope wa꞉tapo woloma kokalepo halemama to hinale tlo woloma kokata hama demhallepe. Adipalati, Yokob ya꞉ God itiyamaletapo wa꞉ gadlepe. Ame adipalati, Godtapo aliya halo omhallalota ya꞉ aliya woloma omhalemdiye, epapele some wa꞉ye omhallepe. Ya꞉ye Isalael so yia꞉ molopa kestale depo halapo. ");
INSERT INTO xla_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Wa꞉ a ya꞉ Godtapo wa꞉ye gadlepe. Ya꞉tapo wa꞉ watle tiyo mate epo yú matale mate halopilipe. Epame wa꞉ watle mamadulo pasataleye halopilipe. ");
INSERT INTO xla_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Epedeme na꞉ maseyemala, na꞉ta atlamale ka꞉ka꞉dle koko itapo wa꞉ dla pasatamama tamali aloweli selemalliye bopudlepe. Adipalati, wa꞉tapo wa꞉ bapadulo dulu dla itapu hamale some hallepe. ");
INSERT INTO xla_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Amasiyama Benyamin wa꞉ye moko esemala epapele some hallepe. Wa꞉tapo wa꞉ dla opahale dlalo soye potipame yia꞉ alisisiye halopo puame wa꞉ opa dla hukulupo alema demhallepe.” ");
INSERT INTO xla_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Epapedeme yu iye Yokobtapo itapu dla ya꞉ akimlala 12 dla wowoyamolowe kokoye momolo atlamale yu ipo. Epedeme Yokob ya꞉ akimlala 12 iwolotapo Isalael so elele 12 sitali ha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Epapele dulu dla Yokobtapo ya꞉ akimlala 12 watle epo atlaiyo, “Na꞉ye mo-polowe mateka꞉pi dla polapo. Epedeme na꞉ motoye Makapela teiko hotuwale dulu dla na꞉ mamadulo hatili medla hamatiye. Wabasi iye Keinan mo pato dulu dla Mamele mo yemala dla halapo. Adipalati, na꞉ mama A꞉iblahamtapo wabasi eye mo-powataliya Hitai elele halë oplami Epolon tle asiyama mate hauwapo. ");
INSERT INTO xla_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Epedeme mo edla A꞉iblaham mate epo ya꞉llu Sela mate hatiwapo. Epame mo hatlo medla Aisek mate epame ya꞉llu Lebeka mate hatiwapo. Epame mo hatlo medla na꞉tapo na꞉ a꞉ya Liyaye polomoluwapo. ");
INSERT INTO xla_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ame adipalati, na꞉ mama A꞉iblahamtapo popoliyelowe ta꞉la iye Hitai so tle asiyama mate ma-hauwapo.” ");
INSERT INTO xla_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Epapele dulu dla Yokobtapo ya꞉ akimlala dla yu hapuloma ma-atlapo gudepame ya꞉ heteye woloma ya꞉ta ellalo dla ola꞉po elemama mosukulu dupa ketamtuluiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Epapeleye Yokobta mo-polati yami Yoseptapo ya꞉ a dla hamame poposila꞉lepo ammela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Epame ya꞉ opa watle yu hamimama ya꞉ a motoye hapele hutulala depame woloma dinapiya diyo. ");
INSERT INTO xla_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Epalati yia꞉tapo Isip so yia꞉ toto koko dolumama powale moto eye alila 40 dulu dla dinapomama dakopala mate huhutupiliyeiyo. Epapele dulu dla Isip sotapo Yokobta polati alila 70 dulu dla dupa kolle pato himha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Epame yia꞉ta dupa kolletapo ma-tame gudlati Yoseptapo Pelo ya꞉ oko so watle epo atlaiyo, “Wua꞉ yu iye dokopala oplami Pelo watle hamtaiya. ");
INSERT INTO xla_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Na꞉ atapo mo-polowedeme elemama epo atluwa, ‘Wua꞉ na꞉ta polati na꞉ motoye Keinan mo dla hamtame na꞉ mamadulo hatili wabasi hatlo medla hamatiye,’ duwa. Epalati na꞉tapo ya꞉ motoye edla hamtame polomilowedeme God hi tle yu itiyapo himiwa. Epapedeme na꞉ solotama, na꞉ a motoye edla hamtame polomilipame ma ilame puluwama,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Epalati Pelotapo yu i dalepame solotamale himmama epo atlaiyo, “Wa꞉ta God hi tle yu itiyapo himili e dolumama wa꞉ a motoye edla tame polomilipame ma ilame puane,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Epapalati Yoseptapo ya꞉ a moto polomila tlati opa hapuloma Pelo ya꞉ oko so mate epo Pelo ya꞉ opa aliya koa tle siyamalalo so mate epo Isip mo dokopala so mate epame Yosep ya꞉ asiyadulo hapuloma mate yimkata tamalaiyo. Amasiyama Yosep ya꞉ asiyadulo yimlala yimka꞉sikili mate epame yia꞉ aliya halo mate tlo Gosen mo medla pomelepo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Epapeleye yia꞉ tame Yoden aloma mateka꞉pi dla Atad so yia꞉ witi daya supulallalo mo dla woyamaiyo. Yia꞉ edla tame woyapame Yosep mate epo opa hapuloma ya꞉ mate tale so mate dupa kolle pato himpo a꞉lemha꞉ha꞉mama alila 7 pololiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Amasiyama mo edla ha꞉ha꞉lalo sota yia꞉ta dupa kolle pato natipo epo atlaiyo, “Isip soye dupa kolle pato himha꞉ha꞉po,” diyo. Epapele koko tle opatapo mo eye semama Abel Mislaim diyo. ");
INSERT INTO xla_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Epapedeme Yosep mate epo ya꞉ bapadulo mate yia꞉ a Yokobta atlamale yu e dolumama ya꞉ motoye hamtame Keinan mo dulu dla Makapela teiko hotuwale dulu dla polomiliyo. Adipalati, popoliyele hatiliwe ta꞉la iye A꞉iblahamta Hitai elele halë oplami Epolon tle asiyama mate haiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Epapedeme Yosepta ya꞉ bapadulo mate yia꞉ a motoye mo-wabasi dulu dla polomilipame ma yimkata Isip so mate ilame Isip mo dla pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Amasiyama yia꞉ a Yokobta mo-powale alotle Yosep ya꞉ bapadulotapo wowota꞉mama yia꞉skamu epo atlamyaiyo, “Yoseptapo dita ya꞉ watle batalimale koko halomuwaye ala me-malahalemama di watle di batalimale asiyama hamilala,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Epammama yia꞉ta Yosep watle yu hamimama epo atlaiyo, “Di atapo mo-polowedeme elemama di watle yu ipo atluwa, ");
INSERT INTO xla_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Wua꞉ta mo-powataliya Yosep watle batalimale koko hauwaye, wua꞉ asiyama ya꞉ watle namkale dle yu atlaiya, ya꞉tapo wua꞉ batalimaleye wellipo depame,’ duwa. Epapedeme Yosep, di wa꞉ dla otele pato himma, wa꞉tapo dita mo-powataliya wa꞉ dla batalimale koko hauwaye wellipo depame. Adipalati, dia꞉ye di a ya꞉ God yu dla salladepo siyamalalo sopo,” diyo. Amasiyama Yoseptapo ya꞉ bapadulota yu hamili i dalepame dupa kolomama sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Epame ya꞉ bapadulotapo puame ya꞉ hete sitali dla heodepo popa꞉mama epo atlaiyo, “Dia꞉ye wa꞉ yu dla salladepo siyamama asiyama pa꞉le oko halomha꞉ha꞉lowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Amasiyama Yoseptapo asiyama yia꞉ watle epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Na꞉ta adipo Godta dinapele kokoye ma meyelope depa꞉? ");
INSERT INTO xla_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Adipalati, wua꞉tapo na꞉ dla batalimale koko halowa depame apuwapo. Epapele tlope Godtapo batalimale koko etle ma ka꞉dle koko tlo hauwapo. Epame wua꞉tapo na꞉ye Isip mo hema hamame iwaye koko pa꞉le po-apena. Amasiyama opa hapuloma pasakalo gadlepo depo apuwapo. ");
INSERT INTO xla_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Epedeme wua꞉ ase na꞉ natipo wowota꞉miya. Na꞉tapo wua꞉ mate epo wua꞉ yimlala mate woloma omhallowepo,” diyo. Epammama ya꞉tapo yia꞉ dla polowamale mate yukamama yia꞉ dupa malamaleye woloma hahatotimaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Epapele dulu dla Yoseptapo ya꞉ bapadulo mate Isip mo dla halemama sokomoko pasatale pololiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Epame ya꞉ ala me-halemama yami Eplaimta hatitimale mate epo ya꞉ mamadulo ewolota hatitimale mape me-tlamaiyo. Epame ma yami hale Manaseta himili maseyemala Makita hatitimale mape me-tlamaiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Epapeleye Yoseptapo mo-polowe mateka꞉pi dla polomama ya꞉ bapadulo watle epo atlaiyo, “Na꞉ye mo-polowe mateka꞉pi dla polapo. Amasiyama Godtapo wua꞉ye woloma omhallepe. Epame ya꞉tapo wua꞉ye Isip mo tle ma Keinan mo dla elemtelepe. Adipalati, ta꞉la iye ya꞉tapo di mamadulo A꞉iblaham mate epo Aisek mate epo Yokob mate dla hamilowepo depo yu itiyapo himiwapo. ");
INSERT INTO xla_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Epapedeme Godtapo wua꞉ye Isip mo tle eleme alikili a꞉ma woyamolowe alilata mo-pulati tamalemama na꞉ elo mate hamtlowe dla God hi tle na꞉ dla yu itiyapo himiya,” diyo. Epalati yia꞉tapo koko eye ikadepe halowa demama God hi tle yu itiyapo himiyo. ");
INSERT INTO xla_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Epapele dulu dla Yoseptapo 110 sokomoko umpo halemama edla powaiyo. Epame ya꞉ motoye Isip so yia꞉ toto koko dolumama woloma ka꞉pi dinapopame ewalata wabasi tili dulu dla hamatiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Epedeme Yokob ya꞉ akimlala iwolotapo yia꞉ a mate Isip mo dla tamalaiyo. Luben, epo Simiyon, epo Libai, epo Yuda, epo Isakal, epo Sebulun, epo Benyamin, epo Dan, epo Naptali, epo Gad, epo Asel. Yia꞉tapo tamalemama me-yia꞉ wola꞉ mate epo yia꞉ yimlala mate elemtamalaiyo. Amasiyama Yosep tlo ya꞉ tatle Isip mo dla ma-tame halaiyo. Yokob ya꞉ akimlala mate epo ya꞉ mamadulo mate Isip mo dla tame hatlo godepo sesa꞉lati 70 umaiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yosep mate epo ya꞉ bapadulo mate Isip mo dla ha꞉ha꞉po depo mo-totoyimlala momama paliyo. Epame yia꞉ mate teta꞉le so mape mo-paliyo. ");
INSERT INTO xla_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Amasiyama Isalael sota yimlala sikemte isukumama Isip mo patoye kustiptame elaiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Epame alotle Yosep koko yeliyele oplamitapo Isip mo dla dokopala oplami halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Epapeleye dokopala oplami Pelo etapo ya꞉ opa watle epo atlaiyo, “Wua꞉ natiya, Isalael soye sikemte pasatamama di opaye tla꞉mtla yakomapo. ");
INSERT INTO xla_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Epapedeme di api totamolowa, Isalael sota sikemte pasatlala depo himomolloweye. Adipalati, yia꞉tapo yia꞉ opata ma-ta꞉lati natipame potlowedeme opahale so opi mate hatlope depame dia꞉ mate opahale dlala,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Epammama yia꞉tapo Isalael sota itiyamaleta pa꞉lepo depame asiyama pa꞉le oko patoto dla hatitipame yia꞉ omha꞉ha꞉lalo so ma hohomaiyo. Epalati Isalael sotapo mo patoto dapiyamte Pitom mate epo Lamses mate kotipo aya halomtamalaiyo, Pelotapo ya꞉ alisisi hapuloma edla hatitimelepo depame. ");
INSERT INTO xla_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Amasiyama epapele tlope yia꞉ oko pato me-halomha꞉ha꞉mama yia꞉ yimlala ma-a꞉ma sikemte isukumaiyo. Epapalati Isip sotapo Isalael sota epo sikemte me-a꞉ma pasatamtlati natipame wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Epammama asiyama yia꞉tapo oko sikemte patoto aya halomolowe oko mate epo osalo hatitimolowe oko mate tlo yia꞉ watle halopimha꞉ha꞉mama pasakalo kokalle dla elemtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Epapele dulu dla Isip mo dokopala oplami Pelotapo Hibulu so wola꞉ta yimlala hohomalati mopapo natilalo so wola꞉ dapiyamte Sipla mate epo Puwa mate dla yu hamimama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Wua꞉ Hibulu so wola꞉ta owayimlala hohomale dulu dla akimlala hohomalati e tlo potimama asiyama utukaka hohomalati e tlo woloma natidemha꞉ha꞉iye,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Amasiyama dulu edla wola꞉ dapiyamte iwolotapo God tlo wowota꞉mama dokopala oplami Pelo yu dla posalladlalo Isalael so wola꞉ta akimlala hohomalati popotimasemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Epalati Pelotapo mopapo natilalo so wola꞉ dapiyamte ewoloye sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ adipalati Hibulu so wola꞉ta akimlala hohomalati popotimalalo wekemduwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Epalati asiyama yia꞉tapo epo atlaiyo, “Dokopala oplami, wa꞉ natine, Hibulu so wola꞉ye owayimlala hohomolowe dla sikemte i-itiyamana, po-Isip so wola꞉ epapena. Epapele koko tle dita ma hapele tuwame yia꞉ gadloweye pta dekelemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Epalati Godta mopapo natilalo so wola꞉ ewolo dla siyemhallati yia꞉ ma yia꞉ yimlala sikemte hohomaiyo. Epalati Isalael sotapo ma a꞉ma sikemte pasatamtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Epedeme Pelotapo matle Isip so hapuloma watle yu ipo hamiyo, “Wua꞉ Hibulu wola꞉ta owayimlala hohomama akimlala hohomalati Nael aloma dla polole demha꞉ha꞉iye. Amasiyama utukaka hohomalati tlo po-potimha꞉ha꞉lowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Epammtale oloma edla Libai elele halë oplami haletapo me-ya꞉ asiya dulu dla a꞉ya hale haiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Epame alotle a꞉ya eta mopapo polopame maseyemala hamaiyo. Epo natitepo owayemalatapo ka꞉pi hallati natipame ya꞉ye mama dapahatlope dulu dla hemele hatiyomeleme halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Amasiyama mama dapahatlope mo-pololepo hallati alotle ya꞉ waita matle owayemala hemele hatiyomollowe apiye mo-pa꞉iyo. Epalati ya꞉tapo duli ka꞉pi yú di dla hollalo tipo owayemalaye duli dulu dla hamatipame Nael aloma yú dla osamokolo polli dulu dla tuwame pameliyo. ");
INSERT INTO xla_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Epame owayemala ya꞉ nanata pateka꞉mu tle halemama apa kokota owayemala dla woyamolowe depo omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Epo alotle Isip mo dokopala oplami Pelo yotitapo aloma dla yú hutula malaiyo. Epalati ya꞉ oko so wola꞉ ya꞉ mate malale sotapo aloma yú peleyama dla siyamaiyo. Epapeleye Pelo yotitapo toko ipo natitepo dulitapo osamokolo dulu dla yú tama di dla holompolla natipame ya꞉ oko a꞉ya hale watle duli eye ya꞉ watle hampuane diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Epame duli dulu gowaladepo natilati owayemala maseyemalatapo duli dulu dla elemama amme ella natiyo. Epapalati ya꞉tapo owayemalata amale dalepame sikemte polowamama epo atlaiyo, “Pona꞉malamana, owayemala iye Hibulu a꞉yata himiwayo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Epalati owayemala ya꞉ nana hemele haodepo halaletapo Pelo yoti hala dla matime halemama epo atlaiyo, “Ka꞉deta꞉, na꞉ta Hibulu a꞉ya haleta wa꞉ owayemala eye nomopi ilipo depame hema sempuluweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Epalati Pelo yotitapo ka꞉pi demama Hibulu a꞉ya haleye salatane diyo. Epalati owayemala ya꞉ nana eta tame owayemala e hamale a꞉ya ikadepe tlo sempuaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Epalati Pelo yotitapo ya꞉ watle epo atlaiyo, “Na꞉ owayemala iye wa꞉ta woloma omhalemama meme imhalane. Epalati na꞉tapo wa꞉ watle asiyama hamilowepo,” diyo. Epalati ya꞉tapo owayemala eye hamamtame woloma omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Epedeme maseyemala etapo mo-pato dlati ya꞉ waitapo Pelo yoti hala dla mo-pomolla taiyo. Epalati Pelo yotitapo asiyama maseyemala eye ma ya꞉ maseyemala ikadepe diyo. Epame ya꞉ hiye semama Moses diyo. Epame epo atlaiyo, “Na꞉tapo ya꞉ye yú di dla holomsela꞉lati natipo hamame holahauwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Epapele dulu dla Mosesta mo-oplami depo halemama ya꞉ opa Hibulu sota oko pato hamha꞉ha꞉leye natila taiyo. Epame ya꞉ edla tame omhallati Isip oplamitapo Hibulu oplamiye sikemte hopolla natiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Epalati Mosestapo ya꞉ta hala alikili dla tlama tepo oplami haleta ya꞉ po-omhallalo wekelati asiyama ya꞉tapo Isip oplamiye yumpame hemele ta꞉la muwalepo hamatiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Epame ma alila haleta tame natilati Hibulu so opa dapiyamtetapo me-ya꞉mkale mate nalatimha꞉ha꞉la natiyo. Epalati Mosestapo oplami ya꞉mkale sikemte hopolemhala watle epo atlaiyo, “Wa꞉ adipalati mo-wa꞉ amkale Hibulu oplamiye hopolemhalema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Epalati oplami ya꞉mkale hopolemhalaletapo Moses watle epo atlaiyo, “Anta wa꞉ye dokopala hi hamilati dia꞉ye omhalane duwa? Wa꞉ye wa꞉ta Isip oplami yumuwaye, epammama na꞉ ma yumuluwedeme amma꞉?” diyo. Epalati Mosestapo yu e dalepame ya꞉ta hemele koko hauwaye ma-natiwayo depo malapame wota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Epapeleye Pelotapo koko i dalepame Mosesye hampo yumuluwedeme totamaiyo. Amasiyama Mosestapo Pelota ya꞉ yumili dle koko dalepame ma Midiya mo dla teletaiyo. Ya꞉ edla teletame halemama yú kolomale mateka꞉pi dla tame polaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Epele dulu dla mo edla alinepi poyupo God dla hapilalo oplami halaiyo, ya꞉ hiye Yetlo. Ya꞉ye ya꞉ utukaka wolupalatalo 7 elemhalaiyo. Epapeleye yia꞉tapo yia꞉ a sipi aliya halo yú ilimolowedeme yú tilimala pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Amasiyama aliya omha꞉ha꞉lalo so opitapo yia꞉ natipo posaliyo. Epalati Mosestapo utukaka ewolo gademama opa ewoloye dodolomsalepame ma utukaka yia꞉ aliya tlo yú ilimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Epame yia꞉ye yia꞉ a Yetlo hala dla tame woyamalati yia꞉ atapo yia꞉ watle epo atlaiyo, “Wua꞉ wata ma-hapele pumuluma. Wua꞉ aliya pasataleye adipo hapele yú ilimo?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Epalati asiyama yia꞉tapo ya꞉ watle epo atlaiyo, “Isip oplami haletapo dia꞉ye gademama aliya halo omha꞉ha꞉lalo so opa opiye alikili dla dodolomsalepame di yú tilipame di aliya halo ma yú ilima,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Epapalati yia꞉ atapo yia꞉ watle epo atlaiyo, “Oplami eye da꞉? Wua꞉ ya꞉ye isikimi duka dla pomeleme pumiya. Amasiyama wua꞉ ya꞉ye di aya dla seme matame popa꞉mama daya iliwe ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Epalati Mosesta yia꞉ aya dla hetaiyo. Epame aya edla me-hallati oplami Yetlo etapo yoti Sipolaye ya꞉ watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Epapedeme Mosestapo Sipola hapo halemama maseyemala himpame ya꞉ hiye Gesom demama epo atlaiyo, “Na꞉ye asepe oplami some ya꞉mkale ta꞉la dla tame halema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","25","Epapele oloma edla sokomoko opi mo-pololepo alotle Isip mo dokopala oplami Peloye mo-powaiyo. Amasiyama Isalael sotapo wotiyalle upiyele dulu medla asiyama pa꞉le oko halomha꞉ha꞉mama ikiyelemha꞉ha꞉iyo. Epalati Godtapo yia꞉ta wotiyalle upiyele dulu dla gadle yilo a꞉lemha꞉ha꞉leye me-dalepame yia꞉ sikemte malahalaiyo. Epammama ma ya꞉tapo A꞉iblaham mate epo Aisek mate epo Yokob mate dla yu itiyapo himili kokoye malamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Epapedeme alila haletapo Mosesta ya꞉ doko Yetlo aliya halo omhalaiyo. Oplami iye Midiya mo dla aliya poyupo God dla hapilalo halaiyo. Epapeleye Mosestapo ya꞉ doko aliyaye eleme dalupa dulu dla sela꞉mama Sainai tamali kikiwi isili dla tame woyamaiyo. Tamali iye God ya꞉ aiyalma tamalipo. ");
INSERT INTO xla_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Epapele dulu dla tamali edla God ya꞉ banakakatapo dlapa tele aloweli mate dalupa asiyale dulu tle ya꞉ dla woyamaiyo. Epalati Mosestapo dlapata dalupa asiyale dulu tle ullumama tleka꞉mhallati natitepo dlapatapo dali upaye ikadepe pohamdlalo halla natiyo. ");
INSERT INTO xla_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Epalati ya꞉skamu epo atlaiyo, “Koko iye pta sikemte ulugiyemana. Epedeme na꞉ ma woloma kulume tuwame natili,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Amasiyama Mosesta kulume pula natipame Godtapo dlapa ullumhala dulu tle ya꞉ watle epo sisilamaiyo, “Moses, Moses.” Epalati asiyama ya꞉ta epo atlaiyo, “Na꞉ ipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Epalati Godtapo ya꞉ watle epo atlaiyo, “Wa꞉ ase hema sikemte kulume matimiya. Adipalati, wa꞉ta dolemhala ta꞉laye aiyalma ta꞉lapo. Epedeme wa꞉ hete alisisi uptimane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Epame Godta ma epo atlaiyo, “Na꞉ye wa꞉ mamadulo A꞉iblaham mate epo Aisek mate epame Yokob mate yia꞉ Godpo,” diyo. Epalati Mosestapo God natilowe wota꞉mama ya꞉ mila꞉piye bopudiyo. ");
INSERT INTO xla_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Epapalati Godtapo Moses watle epo atlaiyo, “Na꞉ na꞉ opa Isalael sotapo Isip mo dla asiyama pa꞉le oko hamha꞉ha꞉mama wotiyalle dulu dla ha꞉ha꞉ye me-natima. Epame Isip sotapo yia꞉ dla wotiyalle hapimha꞉ha꞉lati a꞉lemha꞉ha꞉ kokoye me-dalemhalemama yia꞉ye sikemte malahalema. ");
INSERT INTO xla_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Epapedeme na꞉tapo yia꞉ye Isip mo tle alikili dla eleme mo hale ka꞉dle dla tlowedeme malalepo. Mo eye pta pato epame dlowe alisisi mape pta wokasemana. Wata oloma hema Keinan so mate epo Hitai so mate epo Amoli so mate epo Pelisi so mate epo Hibai so mate epo Yebusi so matetapo mo edla ha꞉ha꞉po. Amasiyama na꞉tapo yia꞉ ta꞉la eye kolahapame ma na꞉ opa Isalael so watle hamilowepo. ");
INSERT INTO xla_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yao, ikadepe, na꞉ opatapo gadle yilo na꞉ dla otele himha꞉ha꞉mama a꞉lemha꞉ha꞉ kokoye me-daluwa. Epame Isip sotapo yia꞉ watle wotiyalle pato hapimha꞉ha꞉ koko mape me-natima. ");
INSERT INTO xla_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Epapedeme na꞉tapo wa꞉ye Isip so yia꞉ dokopala oplami Pelo hala dla tane dema, wa꞉tapo na꞉ opa Isalael soye eleme Isip mo tle alikili dla woyamelepo depame.” ");
INSERT INTO xla_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Amasiyama Mosestapo God watle epo atlaiyo, “Na꞉ po-ala꞉na, na꞉tapo wa꞉ opa Isalael soye eleme alikili dla woyamolowedeme Pelo hala dla tame yu ka꞉dloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Epalati asiyama Godta Moses watle epo atlaiyo, “Na꞉tapo wa꞉ mate hallowepo. Epedeme na꞉tapo ikadepe wa꞉ye tane duwa kokoye wa꞉ dla nati-imama Isalael so opaye alikili dla eleme woyapo puame ma tamali hema na꞉ dla inoma sumama na꞉ hi di dla ta꞉dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Epapele dulu dla Mosestapo God watle epo atlaiyo, “Na꞉tapo wa꞉ opa Isalael so watle tame atlemama, wua꞉ mamadulo yia꞉ Godta na꞉ye wua꞉ hala dla tane duwa, dlati ma asiyama yia꞉ta atlemama ya꞉ hiye anata꞉ dlati, na꞉ apa kokoye yia꞉ watle atlepa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","15","Epapalati Godta Moses watle epo atlaiyo, “Na꞉ye Na꞉po. Epedeme wa꞉ Isalael so hala dla tame yia꞉ye atlamane, na꞉ye yia꞉ mamadulo A꞉iblaham mate epo Aisek mate epo Yokob mate yia꞉ Godpo. Epame na꞉ hiye Na꞉ye Na꞉po. Epapedeme na꞉ hi etapo kokó elepo ellepe. Epapedeme wata oloma itle kotiyapo tamama opa hapulomatapo na꞉ hi eye malastlepe. ");
INSERT INTO xla_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Epedeme wa꞉ Isip mo dla tame Isalael so dokopala opaye elepame yia꞉ watle yu iye ipo atlamelepe, na꞉ye yia꞉ mamadulo A꞉iblaham mate epo Aisek mate epo Yokob mate yia꞉ Lod Godpo. Na꞉tapo Isip sota Isalael so dla wotiyalle pato hapimha꞉ha꞉ kokoye ma-natiwa. ");
INSERT INTO xla_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Epapedeme na꞉tapo yia꞉ye Isip mo dla upiyele dulu dla ha꞉ha꞉ tle alikili dla eleme woyapame yia꞉ watle Keinan so mate epo Hitai so mate epo Amoli so mate epo Pelisi so mate epo Hibai so mate epo Yebusi so mate yia꞉ ta꞉laye hamilowepo. Ta꞉la eye pta pato, opatapo edla ha꞉ha꞉mama dlowe alisisi dloweye pta pasatana. ");
INSERT INTO xla_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Epalati Isalael dokopala sotapo wa꞉ yu dalepame mikadepe dlepe. Epame wa꞉tapo yia꞉ mate yimkata Pelo hala dla tame ipo atlamane, ‘Hibulu so di Godtapo dia꞉ dla woyamuwa. Epapedeme di solotama, alila dapahatlope dulu dla tlalo mo dla tame ha꞉ha꞉mama alinepi poyupame di God dla hapimha꞉ha꞉loweye,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Amasiyama Pelotapo wua꞉ye po-yipta taiya dlowa. Amasiyama ya꞉tapo ikadepe God halema dle koko natipame eta wua꞉ye taiya dlepe. ");
INSERT INTO xla_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Epapedeme na꞉tapo na꞉ta itiyamale pato mate Isip so dulu dla ulugiyemale koko halomama yia꞉ dla wotiyalle hamilowepo. Epalati Pelotapo ulugiyemale koko e natimama alotle wua꞉ye taiya dlepe. ");
INSERT INTO xla_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Epedeme na꞉tapo Isip so dla wotiyalle hamilowe alotle yia꞉tapo wowota꞉mama wua꞉ta solotamale koko hapulomaye halopimyelepe. Epalati wua꞉tapo Isip mo e saliyome tamalemama yia꞉ alisisi hapulomaye halopo tamellepe. ");
INSERT INTO xla_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Epame Isalael so wola꞉tapo yia꞉ mateka꞉pi dla ha꞉ha꞉lalo Isip so wola꞉ dla tame gold ewala mate epo silba ewala mateta mimita꞉pele alisisi mate epo kapala alisisi mate dlalepo halopame ma yia꞉ yimlala dla didiyemellepe. Epapele koko tle Isalael sotapo Isip so alisisi ka꞉ka꞉dle hapulomaye halopame alikili dla woyamelepe.” ");
INSERT INTO xla_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosesta asiyama God watle epo atlaiyo, “Ame opatapo na꞉ yu dla dalepame pomikadepe dlalo wekelati na꞉ adipapopa꞉? Epame ma yia꞉ta atlemama Godta wa꞉ dla powoyamana dlati na꞉ ma adipo atlepa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Amasiyama epalati Godtapo Moses watle epo atlaiyo, “Wa꞉ apa alisisiye wa꞉ dota hamhalema꞉?” diyo. Epalati Mosestapo asiyama epo atlaiyo, “Iye na꞉ dali kupo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Epalati Godtapo epo atlaiyo, “Ta꞉la dla hamastane,” diyo. Epalati Mosestapo ya꞉ dali kuye ta꞉la dla hamastlati ilama yieiyo. Epela natipame Mosesta ilama natipo wota꞉mama alikili dla pesta taiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Amasiyama Godtapo Moses watle epo atlaiyo, “Tila꞉ dla hamame ta꞉dene,” diyo. Epalati Mosestapo ilamaye tila꞉ dla hamame ta꞉dlati ilamatapo ma ya꞉ dali ku yieiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Epalati Godtapo epo atlaiyo, “Dali ku i mate Isalael so opa mila꞉pi tle ipapele koko halepe. Epalati yia꞉tapo ikadepe na꞉tapo wa꞉ dla woyamana depame mikadepe dlepe. Ame adipalati, na꞉ye yia꞉ mamadulo A꞉iblaham mate epo Aisek mate epo Yokob mate yia꞉ Godpo.” ");
INSERT INTO xla_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Epame Godta mamisika꞉ Moses watle epo atlaiyo, “Wa꞉ doye wa꞉ kapumale tluka dulu dla hamatipame holahane,” diyo. Epalati Mosestapo ya꞉ doye ya꞉ kapumale tluka dulu dla hamatipo holahalati ya꞉ do dla heheyapata demama kamkamyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Epame ma Godtapo ya꞉ watle epo atlaiyo, “Wa꞉ doye mamisika꞉ tluka dulu dla hamatipame holahane,” diyo. Epalati ya꞉tapo ya꞉ doye tluka dulu dla ma hamatipo holahalati ya꞉ dotapo ma ka꞉pi halemama ma meyelo hallalo epo halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","9","Epame Godtapo ma epo atlaiyo, “Isalael sotapo wa꞉ yu dalepame ma wa꞉ta koko e halomale dla pomikadepe dlalo wekelepiye, wa꞉ ma Nael aloma dla yú tipame ta꞉la dla olostane. Epalati yútapo pakasiyamalalo omali yielepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Amasiyama Mosestapo God watle epo atlaiyo, “Na꞉ opa mila꞉pi tle yu woloma ka꞉pi po-atlasemde. Epame wata na꞉ta wa꞉ mate yukamhalepo alotle ma adipo ka꞉pi yukamalalo halepa꞉? Adipalati, na꞉ ala me-yu olopo yukamhalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Amasiyama Godtapo asiyama ya꞉ watle epo atlaiyo, “Anta opa dla yukamolowe hamimdi? Epame anta opa dla yu pa꞉le mate molo pa꞉le mate hamimdi? Epame anta opa dla inoma pa꞉le hamimdi? Epame inoma kokowelalimale so dla anta ma natilowe hamimdi? Koko hapuloma eye God na꞉tapo hapimhalapo. ");
INSERT INTO xla_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Epapedeme wa꞉ Isip mo dla tane. Edla na꞉tapo wa꞉ gademama wa꞉ta yukamolowe yuye hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Amasiyama Mosestapo God dla otele himimama epo atlaiyo, “Lod, wa꞉ na꞉ye tane demiya. Amasiyama wa꞉ oplami hale tlo tane dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Epalati Godtapo Mosesta atlale yu dalepame ya꞉ mate siyalademama ya꞉ watle epo atlaiyo, “Ame wa꞉ bapa A꞉lon adipapeta꞉? Ya꞉ye opa mila꞉pi tle pta ka꞉pi yukamde. Epapedeme ya꞉ye api duka dla wa꞉ye umuluwedeme mo-pumhalapo. Ya꞉tapo wa꞉ye natipame siyelepe. ");
INSERT INTO xla_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Epedeme A꞉lontapo wa꞉ta atlamolowe yuye opa dla atlamelepe. Wa꞉tapo na꞉ some halemama A꞉lon watle koko hapulomaye atlamhallati ma ya꞉tapo opa hapuloma dla atlamhallepe. Epapedeme na꞉tapo wua꞉ta madipatata yuhalowe koko dla gadle pato himilowepo. Epame wua꞉ta halomolowe kokoye imolowepo. ");
INSERT INTO xla_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Epedeme wa꞉ dali ku mate hamtane. Eta wa꞉tapo e mate ulugiyemale kokoye halomelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Epapeleye koko ita gudlati Moses ma ilame tame ya꞉ doko Yetlo watle epo atlaiyo, “Ka꞉deta꞉, na꞉ta ma Isip mo dla ilame tame na꞉ asiyaduloye ala me-woloma ka꞉depo ha꞉ha꞉ma꞉ depo natiloweye?” diyo. Epalati Yetlotapo ya꞉ watle epo atlaiyo, “Yao ka꞉pi, woloma tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Epapeleye Moses ala Midiya mo dla hallati Godtapo ya꞉ watle epo atlaiyo, “Wa꞉ Isip mo dla ma ilame tane. Adipalati, opa wa꞉ye yumuluwedeme yu himha꞉ha꞉le soye mo-palina,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Epapalati Mosestapo ya꞉llu mate epo ya꞉ akimlala mate donki aliya di dla ipila꞉pame Isip mo dla tamalaiyo. Yia꞉ tamalemama Godta hamtane dle dali ku mate hamtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Epame Godtapo Moses watle epo atlaiyo, “Wa꞉ Isip mo dla tame dokopala oplami Pelo mila꞉pi tle na꞉ta wa꞉ watle ulugiyemale koko halomolowe nati-iwaye e halomane. Amasiyama epapele dulu dla na꞉tapo ya꞉ dupaye kokalepo mellowepo. Epalati ya꞉ta na꞉ opaye yipta alikili a꞉ma powoyamaiya dlowa. ");
INSERT INTO xla_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Epalati wa꞉ta ma Pelo watle ipo atellepe, Isalael soye na꞉ itapu himili maseyemala epapele some halapo. ");
INSERT INTO xla_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Epapedeme Pelotapo na꞉ maseyemalaye hapele alikili a꞉ma woyamane dlepo. Epalati na꞉ maseyemalatapo tame na꞉ hi di dla ta꞉dlepo. Amasiyama Pelota ya꞉ye alikili a꞉ma powoyamane dlalo wekelepiye, asiyama na꞉tapo ya꞉ maseyemala itapu hamaleye yumuluwama,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Epapeleye Mosestapo Isip mo dla tamama ya꞉llu mate epo ya꞉ yimlala mate duka dla hutiyeiyo. Yia꞉ duka edla hutiyelati Godtapo Mosesye yumula yakomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Amasiyama ya꞉llu Sipolatapo ya꞉ maseyemala kapala kestapame kapala eye hame Moses hete dla gudemama epo atlaiyo, “Na꞉ maseyemala kapala kestale omali itapo wa꞉ pasakaloye gadlepe,” diyo. Epapele dulu dla Godtapo Mosesye poyumina. ");
INSERT INTO xla_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Epapele oloma edla Godtapo A꞉lon watle epo atlaiyo, “Wa꞉ tame dalupa dulu dla Mosesye umane,” diyo. Epalati A꞉lontapo yu e dalepame tame Mosesye God ya꞉ aiyalma tamali kikiwi isili dla halla natipame ya꞉ye poposila꞉lepo huliyo. ");
INSERT INTO xla_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Epame Mosestapo Godta ya꞉ta Isip mo dla tame atlamelepo depo yu halopili hapuloma mate epo ya꞉ta ulugiyemale koko halomelepo depo atlamale koko hapuloma mateye ma A꞉lon watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Epame Moses mate epo A꞉lon mate Isip mo dla tame Isalael so dokopala so hapuloma elepame yimkata puame alumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Epapele oloma edla A꞉lontapo Godta Moses watle atlamale koko hapulomaye ma yia꞉ watle atlamaiyo. Epame Mosestapo opa hapuloma mila꞉pi tle ulugiyemale koko halomalati opatapo koko e natipame mikadepe diyo. ");
INSERT INTO xla_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Epedeme Godtapo yia꞉ta wotiyalle dulu dla ha꞉ha꞉leye natipo gadlepe depame, yia꞉tapo God dla heodepo sisiyemama ya꞉ hi di dla ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moses mate epo A꞉lon mate Isalael so dla yu atlamha꞉ha꞉po gudepame ma Pelo hala dla tame epo atlaiyo, “Isalael so dia꞉ Lod Godtapo wa꞉ watle epo atluwa, wa꞉tapo ya꞉ opaye hapele alikili a꞉ma woyamaiya dloweyo, yia꞉tapo dalupa dulu dla tame ya꞉ hi di dla ta꞉demama daya delepo depame duwa.” ");
INSERT INTO xla_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Amasiyama Pelota yia꞉ watle epo atlaiyo, “God iye anata꞉? Na꞉ adipammama ya꞉ yu dla dalepo salladepame Isalael soye alikili a꞉ma woyamaiya depa꞉? Na꞉ God i ya꞉ kokoye pona꞉malamana. Epapedeme na꞉ Isalael soye alikili a꞉ma powoyamaiya dlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Epalati Moses mate epo A꞉lon mateta epo atlaiyo, “Hibulu so dia꞉ Godtapo dia꞉ watle woyamuwa. Epapedeme di solotama, alila dapahatlope dulu dla tlalo mo dla tame ha꞉ha꞉mama alinepi poyupame di God dla hapimha꞉ha꞉loweye. Amasiyama wa꞉ta dia꞉ye alikili a꞉ma powoyamaiya dlalo wekelepiye, Godtapo esiyele pato mate epo opahale koko mateta dia꞉ye poyuluwe sepena,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Amasiyama Pelotapo asiyama yia꞉ watle epo atlaiyo, “Wua꞉ adipalati oko hamha꞉ha꞉ so opaye eleme alikili dla woyamala yakoma꞉? Hibulu so opa pasataletapo na꞉ okoye hamha꞉ha꞉po. Epedeme wua꞉tapo yia꞉ye pe-eleme tlowa. Epapedeme wua꞉ ma ilame oko halomala tamalaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Alila oloma edla Pelotapo Isalael so yia꞉ omha꞉ha꞉lalo so dla epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Wua꞉ Hibulu so opata blik ewala mimita꞉pelepo depame matle osamokolo totolle pohapimha꞉ha꞉lowa. Amasiyama yia꞉ miyelo tame osamokolo totolle totapame halopo pua demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Amasiyama epapele dulu dla yia꞉tapo blik ewala mimita꞉pmama alila hatlo dulu dla adisowa mimita꞉mduwa, ma mesowa mimita꞉mha꞉ha꞉lepe. Adipalati, yia꞉ye sasalalimama ma na꞉ watle atlemama, di dalupa dulu dla tame di God hi di dla ta꞉demama alinepi poyupo ya꞉ watle hapilowama, demha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Epapedeme opa iwoloye oko sikemte pato halomha꞉ha꞉ diya, yia꞉tapo Mosesta bobokolomale yu atlamsela꞉ koko dla podallalo wekelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Epalati Isalael so omha꞉ha꞉lalo sota tame Isalael so watle epo atlaiyo, “Pelotapo yu ipo atla, ya꞉ matle wua꞉ta blik ewala mimita꞉plowe dla osamokolo totolleye pohalopiliwa de. ");
INSERT INTO xla_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Amasiyama muwolo tame osamokolo totolleye totapame halopo puame sokope tokeyamale mate dudukumha꞉ha꞉lepe, blik ewala mimita꞉ploweye. Epammha꞉ha꞉mama wua꞉ta ka꞉yapa alila hatlo dla adisowa mimita꞉mduwa ma mepapele mimita꞉mha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Epalati opatapo Isip mo pato dulu dla osamokolo totolleye totamtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Epapele dulu dla yia꞉ omha꞉ha꞉lalo sotapo opata oko sikemte halepo depame itiyamale mate ha꞉ha꞉limyemama epo atlamha꞉ha꞉iyo, “Wua꞉ alila hapuloma dulu dla blik ewalaye mimita꞉mtame sale sukulu mate dla gude demha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Amasiyama Isalael sota blik ewala mimita꞉pmama sale sukulu dla tame pogudiyo. Epalati yia꞉ omha꞉ha꞉lalo sotapo yia꞉ye hohopolemama epo atlaiyo, “Wua꞉ ka꞉yapa blik ewalaye sikemte pasatale mimita꞉mduwapo. Ame wua꞉ ma adipalati tatla mate epo wata mate pasto mimita꞉i?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Epapalati asiyama Isalael so yia꞉ dokopala sotapo ma Pelo hala dla tame epo atlaiyo, “Wa꞉ adipalati dia꞉ dla wotiyalle ipapele hapimhalema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","“Epedeme wa꞉ natine, oplami haletapo di watle osamokolo totolleye pohapimhalasema. Ame wa꞉ opata ma adipalati di watle atlemama ka꞉yapa blik ewala mimita꞉mduwa ma mesowaye mimita꞉piya demha꞉ha꞉ma꞉? Wa꞉ opatapo dia꞉ye hohopollepo, amasiyama koko iye podi batalimale, mo-wa꞉ opa yia꞉ batalimalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Amasiyama Pelotapo yia꞉ watle epo atlaiyo, “Muwolo sasalalimama oko halomala allimama apopo. Epammama wua꞉tapo alila hapuloma na꞉ watle epo atlamdepo, ‘Di dalupa dulu dla tame God hi di dla ta꞉demama alinepi poyupo hapilowama,’ demdepo. ");
INSERT INTO xla_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Epapedeme wua꞉ ma oko hala taiya. Di wua꞉ watle osamokolo totolle pohapilowa. Amasiyama wua꞉ ka꞉yapa blik ewala mimita꞉mduwa mesowaye matle mimita꞉mha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Epapele dulu dla yia꞉tapo Pelota yu ipo atlamala dalepame epo momalamaiyo, “Dia꞉ye wotiyalle dulu dla mo-tutula꞉lepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Epame yia꞉ta Pelo mate yu hamha꞉ha꞉po ilame tamalale oloma edla Moses mate epo A꞉lon mateta yia꞉ natilowedeme yia꞉ omha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Epalati yia꞉tapo Moses mate epo A꞉lon mate dla epo atlaiyo, “Godtapo wua꞉ batalimale asiyama hamilipe. Adipalati, wua꞉ta koko halë tle Pelo mate epo ya꞉ oko so mateta dia꞉ dla wotiyalle hamimama dia꞉ potimala yakomapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Epalati Mosestapo yia꞉ saliyomtame halemama inoma sumale yu epo atlaiyo, “Lod, wa꞉ adipalati wotiyalle patoye wa꞉ opa dla hampuma꞉? Wa꞉ adipalati na꞉ye hema puane duwa? ");
INSERT INTO xla_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na꞉tapo Pelo hala dla tame wa꞉ta na꞉ watle atlamelepo depo yu hamiwa hapulomaye ma atlamuwapo. Epapele tlope oloma etle kotiyapo puwa oloma edla Pelotapo wa꞉ opa dla ala wotiyalle me-halopimhalapo. Epapele dulu dla wa꞉ yia꞉ye woloma pogademhalasema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Epalati Godtapo asiyama Moses watle epo atlaiyo, “Epedeme wa꞉ watapo na꞉ta Pelo dla koko halowedeme apiye natilipe. Epapele dulu dla ya꞉tapo na꞉ta itiyamale natipame na꞉ opaye Isip mo tle alikili a꞉ma woyamaiya demama yia꞉ye posallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Epame Godtapo ma Moses watle epo atlaiyo, “Na꞉ye Godpo. ");
INSERT INTO xla_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Epedeme na꞉tapo A꞉iblaham mate epo Aisek mate epo Yokob mate dla woyamalati yia꞉tapo na꞉ye itiyamale God demduwapo. Amasiyama yia꞉ na꞉ hi ikadepeye poyia꞉malamana. Adipalati, na꞉tapo na꞉ hi ikadepe Na꞉ye Na꞉poye yia꞉ watle pobotomastana. ");
INSERT INTO xla_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Epame na꞉tapo Keinan ta꞉la yia꞉ watle hamilowe yuye me-itiyapo himiwapo. Epedeme oloma edla yia꞉ Keinan mo eye ala pohalalo isikimi asepe so some ha꞉ha꞉uwapo. ");
INSERT INTO xla_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Amasiyama na꞉ yia꞉ watle yu itiyapo himiwaye powelina. Epame wata oloma hema Isalael sota a꞉lle kokoye na꞉ me-dalemde. Adipalati, Isip sotapo yia꞉ watle wotiyalle pato halopimha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Epedeme wa꞉ tame Isalael soye atlamane, na꞉ye Godpo. Na꞉tapo na꞉ta itiyamale pato nati-imama yia꞉ye Isip sota yia꞉ watle wotiyalle hapimha꞉ha꞉ dulu etle eleme alikili dla woyamolowepo. Epame asiyama Isip so dla wotiyalle pato hamilowepo. ");
INSERT INTO xla_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Epapedeme Isalael soye na꞉tapo na꞉ opa ikadepe dlepe, epame na꞉tapo yia꞉ God depo hallowepo. Epalati asiyama yia꞉tapo na꞉ye yia꞉ God demama Isip sota yia꞉ dla wotiyalle hamili tle alikili dla eleme tlalo God dlepe. ");
INSERT INTO xla_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Epame na꞉tapo yia꞉ye na꞉ta A꞉iblaham mate epo Aisek mate epo Yokob mate dla yu itiyapo himiwa mo edla eleme tlowepo. Epame mo eye yiole ikadepe depame yia꞉ watle hamilowepo. Na꞉ye Godpo.” ");
INSERT INTO xla_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Epalati Mosestapo Godta ya꞉ watle atlamale koko hapulomaye ma Isalael so watle atlamaiyo. Amasiyama yia꞉tapo wotiyalle pato dulu dla ha꞉ha꞉ natipame ma Moses yu dla mikadepe dloweye alliyo. ");
INSERT INTO xla_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Epedeme Godtapo Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Na꞉ opa Isalael soye Isip mo tle alikili a꞉ma woyamelepo depame wa꞉ta tame Isip mo dokopala oplami Peloye atlane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Amasiyama Mosestapo God watle epo atlaiyo, “Isalael sotapo na꞉ yu dalepame pomikadepe desema. Epapedeme adipammama ma Pelota na꞉ yu dalepame mikadepe depa꞉? Adipalati, na꞉ opa mila꞉pi tle woloma poyukamasemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Amasiyama Godta Moses mate epo A꞉lon mate dla epo atlaiyo, “Wua꞉ tame Pelo hala dla itiyamale hapame Isalael so opaye eleme Isip mo tle alikili dla woyamaiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isalael yami Luben ya꞉ akimlala iwolotapo yia꞉ elele dulu dla dokopala ha꞉ha꞉iyo, yia꞉ hiye Hanok, epo Palu, epo Heslon epo Kalmi. ");
INSERT INTO xla_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Epame Simiyon ya꞉ akimlala iwolotapo dokopala ha꞉ha꞉iyo, yia꞉ hiye Yemuel, epo Yamin, epo Ohad, epo Yakin epo Sohal, epo Saul. Amasiyama Saul ya꞉ waiye Keinan a꞉yayo. ");
INSERT INTO xla_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Epame Moses ya꞉ mama Libai ya꞉ akimlalaye iwolopo, Geson, epo Kohat, epo Melali. Epedeme Libaitapo 137 sokomoko halepame edla powaiyo. ");
INSERT INTO xla_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Epame Libai yami Geson ya꞉ akimlalaye, Libini mate epo Simei matepo. ");
INSERT INTO xla_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Epame Libai yami Kohat ya꞉ akimlalaye iwolopo, Amlam, epo Isal, epo Heblon, epo Usiyel. Epedeme Kohattapo 133 sokomoko halepame edla powaiyo. ");
INSERT INTO xla_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Epame Libai yami Melali ya꞉ akimlalaye Mahali mate epo Musi matepo. Epapedeme opa iwolotapo Libai elele dulu dla dokopala so ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Epapele dulu dla Kohat yami Amlamtapo me-ya꞉ a yotimala Yokebed haiyo. Epame a꞉ya itapo akimlala dapiyamte hohomaiyo, yia꞉ hiye A꞉lon mate epo Moses matepo. Epedeme Amlamtapo 137 sokomoko halepame edla powaiyo. ");
INSERT INTO xla_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Epame Kohat yami Isal ya꞉ akimlalaye iwolopo, Kola, epo Nepeg, epo Sikili. ");
INSERT INTO xla_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Epame ma Kohat yami Usiyel ya꞉ akimlalaye iwolopo, Misael, epo Elsapan, epo Sitli. ");
INSERT INTO xla_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Epapeleye A꞉lontapo Aminadab yoti Eliseba haiyo. Eliseba ya꞉ bapaye Nasonpo. Epeleye Elisebatapo hatitimale akimlalaye iwolopo, Nadab, epo Abihu, epo Eleyasa, epame Itamal. ");
INSERT INTO xla_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Epame Isal yami Kola ya꞉ akimlalaye iwolopo, Asil, epo Elkana, epo Abiyasap. Epapele dulu dla opa iwolotapo Kola ya꞉ asiya dulu dla dokopala ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Epame A꞉lon yami Eleyasatapo Putiyel yoti hale haiyo. Epeleye a꞉ya etapo maseyemala hatlo himiliye Pineyaspo. Epedeme opa iwolotapo Libai elele dulu dla asiya meyelope meyelope dle dokopala ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Epapedeme A꞉lon mate epo Moses mate ewolo dla Godtapo atlemama, “Isalael so elele hapulomaye Isip mo tle eleme alikili a꞉ma woyamaiya,” demduwapo. ");
INSERT INTO xla_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Epame iwolotapo Isip mo dokopala oplami Pelo dla atlamama, “Isalael soye alikili a꞉ma woyamaiya dene,” demduwapo. ");
INSERT INTO xla_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Epedeme Mosestapo Isip mo dla hallati Godtapo ya꞉ watle yukamama epo atluwapo, ");
INSERT INTO xla_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Na꞉ye Godpo. Epapedeme Isip so dokopala oplami Pelo watle na꞉ta wa꞉ watle atlamuwa koko hapulomaye ya꞉ watle atlamane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Amasiyama Mosestapo God watle epo atlaiyo, “Na꞉ yu pase ka꞉pi yukamasemde. Epedeme Pelotapo na꞉ yu podallowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Epalati Godta Moses watle epo atlaiyo, “Na꞉tapo wa꞉ye Pelo mila꞉pi tle na꞉ some hallepo depame pamellowepo. Epalati wa꞉ bapa A꞉lontapo wa꞉ta atlamolowe yu hapulomaye Pelo watle atlamhallepe. ");
INSERT INTO xla_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Epedeme na꞉tapo wa꞉ watle atlamuwa koko hapulomaye ma A꞉lon watle atlamane. Epalati ma ya꞉tapo Pelo watle atlemama Isalael soye alikili a꞉ma woyamelepo dlepe. ");
INSERT INTO xla_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Amasiyama na꞉tapo Pelo ya꞉ dupa malamaleye kokalepo mellowepo. Epame na꞉tapo ulugiyemale koko patotoye Isip mo dla halomolowepo. ");
INSERT INTO xla_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","5","Amasiyama epapele dulu dla ya꞉ta koko eye tlapame ya꞉ dupa malamaleye ala pomeyelope dlowa, wua꞉ta alikili a꞉ma woyamoloweye. Amasiyama na꞉tapo na꞉ta itiyamale pato mate Isip so dla wotiyalle hamimama Isalael so elele hapulomaye eleme alikili a꞉ma woyamolowepo. Epalati Isip sotapo e natimama na꞉ye ikadepe God mleni dlepe.” ");
INSERT INTO xla_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Epalati Moses mate epo A꞉lon mate God yu dla dalepo salladepame Pelo dla tame yu i atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Oloma edla Mosesye 80 sokomoko umpo halaiyo. Epalati A꞉lon tlo 83 sokomoko umpo halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Epame Godta Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Pelotapo wua꞉ watle atlemama ulugiyemale koko halomaiya dlati, wa꞉ A꞉lon atellepe, ya꞉tapo Pelo mila꞉pi tle ya꞉ dali kuye hamastlepo depame. Epapelepiye, dali ku etapo ma ilama yielepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Epapalati Moses mate epo A꞉lon mate Godta atlamale yu e dolumama Pelo hala dla tamalaiyo. Yia꞉ tame ulugiyemale koko halomama A꞉lontapo ya꞉ dali kuye Pelo mila꞉pi tle epo ya꞉ oko so mila꞉pi tle hamastlati ilama yieiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","12","Epela natipame asiyama Pelotapo ya꞉ osolo watalo so opa sisilamaiyo. Epalati yia꞉tapo puame yia꞉ osolo mate ulugiyemale koko halomama yia꞉ dali kuye polollati ilama yiyeiyo. Amasiyama A꞉lon ya꞉ ilamatapo osolo watalo so yia꞉ ilama hapulomaye gola꞉gola꞉diyo. ");
INSERT INTO xla_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Epalati Pelotapo Godta atlamale yu mate ala꞉mama ya꞉ dupa sikemte kokalepame Moses mate epo A꞉lon mate yia꞉ yu dla podaliyo. ");
INSERT INTO xla_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Epame Godtapo Moses watle epo atlaiyo, “Pelo dupaye sikemte kokalemama na꞉ opaye alikili a꞉ma woyamane dloweye alipo. ");
INSERT INTO xla_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Epedeme utulala ikadepe Pelotapo Nael aloma pili dla telepe. Epalati wa꞉ mape wa꞉ dali ku ilama yieuwa e hame ya꞉ hala dla tame ya꞉ watle yu ipo atlane, ");
INSERT INTO xla_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","‘Hibulu so yia꞉ Lod Godtapo na꞉ye wa꞉ hala dla tane de, wa꞉tapo ya꞉ opaye alikili a꞉ma woyapo taiya dlati yia꞉tapo dalupa dulu dla tame yia꞉ God dla inoma sumama ya꞉ hi di dla ta꞉demha꞉ha꞉lepo depame. Amasiyama wa꞉ ala yu eye woloma podalesema. ");
INSERT INTO xla_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Epapedeme wata Godtapo ya꞉ta ikadepe God depo hala kokoye wa꞉ dla nati-imama ma ulugiyemale koko hale halepe. Eye na꞉tapo na꞉ta hamhala dali ku i mate Nael aloma dla heyulati yútapo ma omali yielepe. ");
INSERT INTO xla_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Epapele dulu dla amalo yú dulu dla ha꞉ha꞉lalotapo palimama yúye hutallu pamalati opatapo matle Nael aloma dla yú podlomolowa,’ dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Epame Godtapo ma Moses watle epo atlaiyo, “Wa꞉ A꞉lon atlane, ya꞉tapo ya꞉ dali ku mate aloma hapuloma dla epo yú kolomale hapuloma dla epo kaula hapuloma dla dlokomelepo depame. Epapalati yú hapuloma Isip mo dulu dla hutiyetapo ma omali yiyelepe. Epalati oloma edla dopa dla yú tilimale mate epo eto dla yú tilimale mate aya dulu dla popa꞉mtale hapuloma mape omali yiyelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Epalati Moses mate epo A꞉lon mate Godta atlamale yu dla salladepame Nael aloma yú pili dla Pelo natila tulumalaiyo. Yia꞉ tulume Pelo mate epo ya꞉ oko so mate umpame Godta Pelo watle atlaiye dle yu hapulomaye atlamaiyo. Epame yia꞉ mila꞉pi tle ha꞉ha꞉mama A꞉lontapo ya꞉ dali ku mate Nael aloma dla heyuiyo. Epalati aloma yútapo omali yieiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Epame amalo yú dulu dla ha꞉ha꞉laloye palimama aloma yúye hutallu pamolowe kotiyamaiyo. Epalati Isip sotapo yú dlowe ka꞉dle hale hawa halaiyo. Adipalati, Isip mo pato dulu dla yú hapulomaye omalita hapo halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Epapele dulu dla Pelo ya꞉ osolo so mape yia꞉ dali ku mate aloma yú dla heyulumalati aloma yútapo omali yieiyo. Epapele koko natipame Pelotapo Godta atlamale yu mate ala꞉mama ya꞉ dupa sikemte kokalepame Moses mate epo A꞉lon mate yia꞉ yu pohaiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Epame ya꞉tapo ma ilame ya꞉ aya dla tame polomama Moses mate epo A꞉lon mateta halomale kokoye pokoko depame mo-weliyo. ");
INSERT INTO xla_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Epalati Isip sotapo yia꞉ta yú dlowe hawa hallati ma tame Nael aloma peleyama dla yú dlowe amko kokolalimyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nael aloma yúta omali yiepo elale dulu dla alila 7 pololepo gudlati Godtapo matle Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","“Wa꞉ tame Pelo dla yu ipo atlane, ya꞉tapo na꞉ opaye alikili a꞉ma woyamaiya dlepo depame. Epalati yia꞉tapo tame na꞉ dla inoma sumha꞉ha꞉mama na꞉ hi di dla ta꞉demha꞉ha꞉lepo. ");
INSERT INTO xla_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Epapele dulu dla Pelota allipiye, na꞉tapo Isip mo patoye gulugulepi mate yuluwepo. ");
INSERT INTO xla_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Epapele oloma edla Nael alomaye gulugulepitapo kustipo tame ellepe. Yia꞉tapo aloma yú tle wowoyapame Pelo aya dla hetame ya꞉ aya alupoli dulu dla epo ya꞉ta ellalo dla hehetamyelepe. Epame ya꞉ oko so aya dla ma hehetamyemama mo so aya hapuloma dla mape wokasepo ellepe. Epame yia꞉tapo aya hapuloma tile mate epo daya kolumalalo ita mate dla hehetamyelepe. ");
INSERT INTO xla_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Epame gulugulepitapo ma Pelo dla epo ya꞉ oko so dla epame ya꞉ mo so dla hehetamyelepe.” ");
INSERT INTO xla_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Epame Godtapo matle Moses watle epo atlaiyo, “Wa꞉ A꞉lon atlane, ya꞉tapo ya꞉ dali ku mate aloma dla epo yú kolomale dla epo kaula dla dlokomelepo, gulugulepitapo yú dulu tle wowoyapame Isip mo pato pasatlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Epapalati A꞉lontapo ya꞉ dali kuye aloma dla epo yú kolomale dla epo kaula dla dlokomaiyo. Epalati gulugulepita wowoyapame Isip mo pato dla hapo elaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Amasiyama osolo watalo so yia꞉ mape yia꞉ osolo mate ulugiyemale koko halomalati gulugulepitapo yú dulu tle wowoyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Epalati Pelotapo Moses mate epo A꞉lon mate ya꞉ hala dla pumullupo depame sisilamaiyo. Epame yia꞉ watle epo atlaiyo, “Gulugulepi ita na꞉ tle epo na꞉ opa tle alikili a꞉ma telepo depame God dla inoma sumaiya. Wua꞉ta epapelepiye, eta na꞉tapo wua꞉ opaye alikili a꞉ma woyamaiya dlowepo. Epalati yia꞉tapo dalupa dulu dla tame yia꞉ God hi di dla ta꞉demama alinepi poyupo hapilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Epapalati Mosestapo asiyama epo atlaiyo, “Yao, ka꞉pi. Amasiyama wa꞉ta na꞉ watle alila hamine, na꞉tapo wa꞉ mate epo wa꞉ oko so mate epo wa꞉ opa mate yilo God dla inoma sumale himmama gulugulepiye potimelepo depame. Amasiyama Nael aloma dla gulugulepi hala tlo me-pomellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Epalati Pelota asiyama epo atlaiyo, “Wa꞉ inoma sumane, iyela gulugulepita pa꞉lepo depame,” diyo. Epalati asiyama Mosesta epo atlaiyo, “Yao ka꞉pi, wa꞉ta atla koko eta me-woyamelepe. Epapele dulu dla wa꞉ gulugulepi ita mosukulu pali kokoye natipame malamelepe, di Godta itiyamaletapo wa꞉ godta itiyamaleye tla꞉mtame halapo. Amasiyama hatlo Nael aloma dla gulugulepi hala tlo me-ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Epame Moses mate epo A꞉lon mate Pelo medla pomelepame ma ilame tamalaiyo. Epapeleye Mosestapo Godta gulugulepiye potimelepo depame otele himmama inoma sumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Epalati Godtapo Mosesta inoma sumale yu dalepame gulugulepi hapuloma mo dulu dla hapo elaleye potimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Epame gulugulepi hapuloma mo-potimaleye ma yimkata hatlo kolupo pamele kolupo pamele demtamalaiyo. Epalati hutallutapo mo patoye haiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Amasiyama Pelotapo gulugulepita mo-palli koko natipame Godta atlamale yu mate ala꞉mama ya꞉ dupa malamaleye ala sikemte me-kokalepame Moses mate epo A꞉lon mate yia꞉ yu dla podaliyo. ");
INSERT INTO xla_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Epame Godta ma Moses watle epo atlaiyo, “Wa꞉ A꞉lon atlane, ya꞉ dali ku hapame ta꞉la apupu dla heyulupo depame. Epalati Isip mo pato dulu dla apuputapo sase kapala yiyelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","18","Epela dalepame A꞉lontapo ya꞉ dali ku mate ta꞉la apupu dla heyuiyo. Epapele oloma dla apuputapo sase kapala yiyepame Isip mo pato dulu dla opa hapuloma dla epo yia꞉ aliya halo dla topulumyaiyo. Epame Pelo ya꞉ osolo watalo so mape solotamaiyo, yia꞉ osolo mate ta꞉la apupuye ma sase kapala yiyelepo depame. Amasiyama yia꞉ po-ala꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Epalati yia꞉ tame Pelo watle epo atlaiyo, “Podimalamana, Godta itiyamaletapo koko iye hasema,” diyo. Amasiyama Pelotapo Godta atlamale yu mate ala꞉mama ya꞉ dupa sikemte kokalepame Moses mate epo A꞉lon mate yia꞉ yu dla podaliyo. ");
INSERT INTO xla_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Epame Godtapo matle Moses watle epo atlaiyo, “Wa꞉ utulala ikadepe Pelotapo Nael aloma pili dla tlati tame ya꞉ umpame ipo atellepe, ya꞉tapo na꞉ opaye alikili a꞉ma woyamaiya dlepo depame. Epalati yia꞉tapo tame inoma sumale mate na꞉ hi di dla ta꞉demha꞉ha꞉lepo. ");
INSERT INTO xla_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Epapele dulu dla ya꞉tapo na꞉ opaye alikili a꞉ma powoyamaiya dlalo wekelepiye, asiyama na꞉tapo Isip so watle momokama diki hapulomaye tuluiya dlowepo. Epalati momokama dikitapo malame mo pato dulu dla pasatepo elemama Pelo mate epo ya꞉ oko so mate epo ya꞉ mo so mate dla topulumyelepe. Epame yia꞉ aya dulu dla mape sikemte topulumyelepe. ");
INSERT INTO xla_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Amasiyama momokama dikita pulupiye, yia꞉ na꞉ opa Gosen mo dla ha꞉ha꞉lalo so dla puame potopulluwa. Amasiyama yia꞉ isikimi puame Isip so dla topulumyelepe. Epapedeme Pelotapo ipapele koko natimama ikadepe Godtapo mo hema halemapo dlepe. Epapedeme iyela na꞉ta ulugiyemale koko iye halati momokama dikita mallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Epapele dulu dla Godta meyelo atlale koko dolumama alila haletapo momokama dikitapo mo-malaiyo. Epapeleye momokama diki patotota ketame pumama Pelo ya꞉ aya mate epo ya꞉ oko so aya mate epo mo so yia꞉ aya mate dla topulumyaiyo. Epammama Isip mo patoye momokama dikita hapo elaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Epalati Pelotapo Moses mate epo A꞉lon mate sisilapame yia꞉ watle epo atlaiyo, “Na꞉ wua꞉ dla itiyamale hamima, wua꞉tapo wua꞉ opa eleme alinepi poyupo God dla halopila tlepo depame. Amasiyama wua꞉ Isip mo saliyome tamiyo, medla me-ha꞉ha꞉mama apelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Epalati asiyama Mosesta epo atlaiyo, “Hao, di epapele koko pohalowa. Adipalati, ditapo Isip so mila꞉pi tle alinepi poyupo God dla halopimha꞉ha꞉lepiye, yia꞉tapo di natila allimama ewalata di kelemelepe. ");
INSERT INTO xla_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Epedeme di ka꞉dena, Godta yu himili e dolumama alila dapahatlope dulu dla tlalo mo dla tame alinepi poyupo ya꞉ dla hapiloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Epalati Pelota asiyama epo atlaiyo, “Yao ka꞉pi, epapele tlope wua꞉ edla tamalemama ika sikemte mo pateka꞉mu dla potlowa. Amasiyama wua꞉ momokama dikitapo na꞉ tle alikili a꞉ma telepo depame wata na꞉ yilo inoma sumaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Epalati Mosesta epo atlaiyo, “Na꞉tapo wa꞉ mate yukamhalepo tame God dla inoma sumuluwepo. Epalati iyela momokama dikitapo pa꞉lepe. Amasiyama wa꞉ dia꞉ye mala-atlepame ma malamale meyelope depo opata alikili a꞉ma woyapo tame alinepi poyupo God dla hapilowe apiye pohimomollowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Epame Mosestapo Pelo mate yukamhalepo gudepo tame inoma sumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Epalati Godtapo Moses yu dalepame momokama diki hapulomaye alikili a꞉ma posaliyo. Epele dulu dla Isip mo pato dla momokama dikita ma-hawa ikadepe halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Amasiyama Pelota matle ya꞉ dupa kokalemama Isalael soye alikili a꞉ma powoyamaiya dlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Alila haleta Godta ma Moses watle epo atlaiyo, “Wa꞉ Pelo hala dla tame ipo atlane, ya꞉tapo na꞉ opaye alikili a꞉ma woyamaiya dlepo depame. Epalati yia꞉tapo tame na꞉ dla inoma sumha꞉ha꞉mama na꞉ hi di dla ta꞉demha꞉ha꞉lepo. ");
INSERT INTO xla_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Amasiyama Pelotapo na꞉ opaye alikili a꞉ma woyamaiya dlowe dla ala me-alimhallepiye, na꞉tapo ya꞉ aliya halo hapuloma dla esulumale pato hamilowepo. Epalati ya꞉ hos aliya mate epo donki aliya mate epo ka꞉mol aliya mate epame bulumkiyawa aliya mate epo sipi aliya mate epame gaut aliya mateta esulumale pato halomama pallipe. ");
INSERT INTO xla_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Amasiyama Isalael so yia꞉ aliya tlo popalliwa, me-ka꞉pi ha꞉ha꞉lepe. Isikimi Isip so aliya siyapo tlo alomama pallipe. ");
INSERT INTO xla_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Epedeme iyela eye alilapo, na꞉tapo esiyele patota yia꞉ halo dla tulune dloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Epapele dulu dla alila haletapo Godtapo esiyele kokota aliya halo dla tulune dlati Isip so yia꞉ aliya halo hapuloma tlo palimama asiyama Isalael so yia꞉ aliya halo hapuloma dulu dla haleta po-polalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Amasiyama Pelota Isalael so halo hapuloma dulu dla haleta ikadepe popolalo wekele koko dalepame ya꞉ dupaye ala me-kokalemama Isalael soye alikili a꞉ma mo-woyamaiya dloweye aliyo. ");
INSERT INTO xla_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Epame ma alila haletapo Godta Moses mate epo A꞉lon mate dla epo atlaiyo, “Wua꞉ tilepu halopame Pelo mila꞉pi dla tame ha꞉ha꞉mama Moses wa꞉tapo tilepuye di dla kustelepe. ");
INSERT INTO xla_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Epalati tileputapo mo pato dulu dla pasalalemtamama opa dla epo yia꞉ halo dla soseta yulumtelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Epapalati Moses mate epo A꞉lon mate tilepu halopame Pelo hala dla tame ha꞉ha꞉mama Mosestapo tilepuye hapame di dla kustaiyo. Epalati tileputapo Isip mo pato dulu dla pasalalemtamama soseta opa hapuloma dla epo yia꞉ aliya halo hapuloma dla yulumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Epapele dulu dla osolo watalo sotapo ma Moses hala dla puluweye po-ala꞉iyo. Adipalati, yia꞉ mape soseta sikemte yulumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Amasiyama Godtapo Pelo ya꞉ dupa ma-a꞉ma kokalepo meliyo. Epalati Pelotapo Godta atlamale yu mate ala꞉mama Moses mate epo A꞉lon mate yia꞉ yu dla podaliyo. ");
INSERT INTO xla_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Godta ma Moses watle epo atlaiyo, “Wa꞉ utulala ikadepe Pelo hala dla tame ipo atlane, ya꞉tapo na꞉ opaye Isip mo tle alikili a꞉ma woyamaiya dlepo depame. Epalati yia꞉tapo tame na꞉ dla inoma sumha꞉ha꞉mama na꞉ hi di dla ta꞉demha꞉ha꞉lepo. ");
INSERT INTO xla_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Amasiyama ya꞉tapo na꞉ opaye potaiya dlalo wekelepiye, na꞉tapo asiyama ya꞉ mate epo ya꞉ oko so mate epo ya꞉ mo so opa mate dla sikemte wotiyalle pato hamilowepo. Epalati ya꞉tapo na꞉ta itiyamale pato e natipame ma god opita itiyamale mate ala꞉lepiye, po-ala꞉lowa. ");
INSERT INTO xla_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Epapele dulu dla na꞉ta itiyamaletapo ya꞉ mate epo Isip so hapuloma mateye mo-potimelemla. ");
INSERT INTO xla_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Amasiyama na꞉tapo ya꞉ye aseka me-hallepo duwapo, na꞉ta itiyamale nati-imama epo na꞉ hita ta꞉lamo hema pato dlepo depame. ");
INSERT INTO xla_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Amasiyama epapele tlope ya꞉ ala ya꞉skamu ya꞉ tlo pato demama na꞉ opaye ma alikili a꞉ma woyamaiya dloweye alipo. ");
INSERT INTO xla_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Epapedeme iyela utulalati na꞉tapo tiyo patoto ewala sepeleye omapla di tle tulune dlepe. Epapele dulu dla Isip sota ka꞉yapa tiyo patoto ewala sepele epapeleye ponatimdena. ");
INSERT INTO xla_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Epedeme poka꞉dena Pelo ya꞉ opa mate epo ya꞉ aliya halo mate haliyamale dla ha꞉ha꞉loweye, yia꞉ta hapulomatapo woloma aya dulu dla ha꞉ha꞉lepe. Adipalati, na꞉tapo iyela tiyo patoto ewala sepeleye tulune dlowepo. Epapele dulu dla opa mate epame aliya halo mate ala me-haliyamale dla siyamyelepiye, tiyo ewala sepeleta di tle helemama yia꞉ye potimelepe.” ");
INSERT INTO xla_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Epalati Pelo ya꞉ oko so opitapo Moses yu dalepo mikadepe demama yia꞉ opa mate epo yia꞉ aliya halo mate eleme aya dulu dla tumulaiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Amasiyama Pelo ya꞉ oko so opa opitapo yu edla dalepo pomikadepe dlalo wekemama yia꞉ opa mate epo yia꞉ aliya halo mate aya dulu dla pe-elemtulalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Epalati Godta Moses watle epo atlaiyo, “Wa꞉ dali ku hame omapla di dla dlokomane, tiyo patoto ewala sepeleta omapla di tle Isip so opa mate epo yia꞉ aliya mate epo yia꞉ta emale alisisi mate dla hellepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","25","Epalati Mosesta yu e dalepame omapla di dla ya꞉ dali ku mate dlokomalati natipame Godtapo tiyo patoto ewala sepeleye hamimama omapla mate sikemte hane diyo. Epapele koko tle alikili haliyamale dla siyamale opa mate epo aliya halo mate poyuiyo. Epame emale alisisi hapuloma mate epo dali hapuloma mate batalipo hamastaiyo. Epapele dulu dla Isip sotapo ka꞉yapa tiyo ewala sepele patoto ipapeleye ponatimdiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Amasiyama Isalael sota ha꞉ha꞉ mo Gosen dla tiyo ewala sepele itapo pehellalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Epapalati Pelota Moses mate epo A꞉lon mate sisilapame yia꞉ watle epo atlaiyo, “Na꞉ wata natima, na꞉ batalimale koko ma-hauwapo. Adipalati, wua꞉ God tlo ikadepe koko atlamhaluwapo. Amasiyama na꞉ mate epo na꞉ opa mate tlo batalimale api dla tamalana. ");
INSERT INTO xla_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Epedeme tiyo ewala sepeleta helemhala iye medla gudlepo depame, wua꞉ God dla inoma sumale himiya. Epalati na꞉tapo wua꞉ye alikili a꞉ma mo-woyamaiya dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Epapalati asiyama Mosestapo epo atlaiyo, “Na꞉tapo mo dulu tle alikili dla tame God dla inoma sumalati omaplata hamhala mate epo tiyo ewala sepeleta helemhala mateta medla gudlepe. Epalati wa꞉ edla malamelepe, ta꞉lamo patoye Godta omhalapo. ");
INSERT INTO xla_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Amasiyama na꞉malamana, wa꞉ mate epo wa꞉ oko so mateye ala Lod God po-wowota꞉mha꞉ha꞉sema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Epapedeme tluka mimita꞉polalo sematipi dali mate epo bali daya mate mo-hauwallowe oloma dla hutiyelati tiyo ewala sepeleta helemama batalipo hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Amasiyama witi daya tlo ala ta꞉la dulu dla emtademe pobatalimalalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Epapalati Mosestapo alikili a꞉ma woyapo tame inoma sumalati omapla halë mate epo tiyo ewala sepeleta helle mate medla ka꞉liyo. ");
INSERT INTO xla_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","35","Epapele dulu dla Pelotapo tiyota me-keillati natipame ma ya꞉ta yu himili hauwokokomaiyo. Epedeme Godta atlale yu dolumama Pelo mate epo ya꞉ oko so mate yia꞉ dupaye sikemte kokalalimama Isalael so opaye alikili a꞉ma powoyamaiya dlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Epame Godta ma Moses watle epo atlaiyo, “Na꞉tapo Pelo mate epo ya꞉ oko so mate yia꞉ dupaye kokalalipo meluwapo, na꞉ta itiyamale kokoye yia꞉ dla nati-imhalemama ulugiyemale koko halomhallowedeme. Epapedeme na꞉ta ikadepe God depo halemama ulugiyemale koko patoto Isip so dla halomhala iye ma wua꞉tapo wua꞉ yimlala dla epo wua꞉ mamadulo dla esemha꞉ha꞉lepe. Epapedeme wa꞉ Pelo hala dla ma ilamtane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Epalati Moses mate epo A꞉lon mate Pelo hala dla ilamtame epo atlaiyo, “Hibulu so dia꞉ Lod Godtapo epo atla, ‘Wa꞉ adipalati ya꞉ yu dla poheodlalo ala me-dalla alimhalema꞉? Wa꞉ ya꞉ opa dia꞉ye hapele alikili a꞉ma woyamaiya dene, ditapo tame ya꞉ dla inoma sumha꞉ha꞉mama ya꞉ hi di dla ta꞉demha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Amasiyama wa꞉tapo dia꞉ye alikili a꞉ma powoyamaiya dlalo wekelepiye, ya꞉tapo iyela ma wua꞉ watle wotiyalle hale hamimama wolomopiye tulune dlepe. ");
INSERT INTO xla_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Epalati wolomopita sikemte pasatamama Isip moye hapo ellepe. Epapele dulu dla tiyo ewala sepeleta helemama emale alisisi hauwokokomama opi me-popomelleye ma wolomopi eta mosukulu dlopa꞉mele pokadlepe. Epame yia꞉tapo dalupa hapuloma mape dlopa꞉mele pokadlepe. ");
INSERT INTO xla_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Epame wolomopi hapulomatapo wa꞉ aya mate epo wa꞉ oko so aya mate epo wa꞉ mo so aya mate dla hehetamyelepe. Epapele dulu dla Isip sotapo ka꞉yapa wolomopi sikemte pasatale ipapeleye ponatimdena,’” diyo. Mosestapo yu iye Pelo dla atlamhalepo gudepame ma taiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Epalati Pelo ya꞉ oko sotapo ya꞉ hala dla puame epo atlaiyo, “Wa꞉ adipalati oplami ita dia꞉ dla wotiyalle me-hamimhallepo depame me-semhalema꞉? Ya꞉ koko tle di Isip mo patoye mo-batalipo elapo. Epedeme wa꞉ Hibulu so iwoloye ma hapele alikili a꞉ma woyamaiya dene, yia꞉tapo tame yia꞉ God dla inoma sumama ya꞉ hi di dla ta꞉demha꞉ha꞉lepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Epapalati Pelota yu i dalepame Moses mate epo A꞉lon mate ma sisilapame yia꞉ watle epo atlaiyo, “Ka꞉dena, wua꞉tapo ma tame wua꞉ God dla inoma sumama ya꞉ hi di dla ta꞉demha꞉ha꞉loweye. Amasiyama epapele dulu dla wua꞉ na꞉ watle atlaiya, ikadepe anawolota wua꞉ mate tapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Epalati Mosesta asiyama epo atlaiyo, “Isalael so hapulomatapo na꞉ mate telepe. Epapedeme opolatalo yimlala mate epame amkoteta꞉le so mate di aliya halo hapuloma mate eleme na꞉ mate tamellepe. Adipalati, di ma edla tame daya pato demama di God hi di dla ta꞉dlowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Epalati asiyama Pelota epo atlaiyo, “Hao, wua꞉ pe-epapolowa! Wua꞉ isikimi na꞉ dla mala-atlowedeme aposema. Epedeme na꞉ wua꞉ yimlala mate epo wua꞉ wola꞉ mate eleme alikili a꞉ma powoyamaiya dlowa. ");
INSERT INTO xla_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Epele dulu dla wua꞉ God dla inoma sumama ya꞉ hi di dla ta꞉dlowedeme apelepiye, wua꞉ isikimi opa siyapo tlo elemtaiya. Amasiyama wua꞉ wola꞉ mate epo wua꞉ yimlala mate tlo medla pomelepame taiya,” diyo. Pelota epo atlepame Moses mate epo A꞉lon mateye ya꞉ aya dulu tle alikili a꞉ma posaliyo. ");
INSERT INTO xla_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Epalati Godta Moses watle epo atlaiyo, “Wa꞉ dali ku hapame Isip mo pato dla dlokomane. Epapalati wolomopita puame emale alisisi tiyo ewala sepeleta helemama hauwokokomama opi me-pomelleye ma yia꞉ta dlomama mosukulu pokadlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","14","Epalati Mosestapo ya꞉ dali ku hame Isip mo pato dla dlokomaiyo. Epalati Godtapo mosisi patoye tulune dlati mosisitapo salita matlalo tiyama tle alila mate utula꞉la mate sikemte hotlomhalaiyo. Epame utulala ikadepe opata hutiyele tle sillipo natitepo wolomopi hapulomatapo Isip moye sikemte hapo ella natiyo. Epapele dulu dla ka꞉yapa yia꞉tapo wolomopi sikemte wokasemale ipapeleye ponatimdiyo. Epame matle alotle ipapele ponatilowe sepena. ");
INSERT INTO xla_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Epedeme wolomopitapo Isip ta꞉la pato dla sikemte topulumyemama kustipo tame elaiyo. Epame yia꞉tapo dalupa hapuloma mate epo emale alisisi mate sikemte dlomha꞉ha꞉mama mosukulu pokapokadiyo. Epapele koko tle Isip mo patoye sikemte batalipo hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Epalati Pelotapo Moses mate epo A꞉lon mate ma hapele sisilapame yia꞉ watle epo atlaiyo, “Na꞉tapo wua꞉ God dla epame wua꞉ dla batalimale koko ma-halepo. ");
INSERT INTO xla_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Epedeme na꞉ batalimale hiyolepo welipame God dla inoma sumale himiya, wolomopi hapuloma ita pa꞉lepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","19","Epapele dulu dla Mosestapo ya꞉ tle tame God dla inoma sumale himilati Godtapo sokomoko pato hamiyo. Epalati sokomokota bibikilimama wolomopi hapulomaye hahala꞉po tame Omteka꞉pele Kaula dla ka꞉ka꞉timaiyo. Epapele alotle wolomopi haletapo matle Isip mo dulu dla posela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Amasiyama Godtapo Pelo dupa malamaleye mamisika꞉ kokalepo mellati ya꞉tapo Isalael soye alikili a꞉ma powoyamaiya dlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Epame Godta ma Moses watle epo atlaiyo, “Wa꞉ do omapla di dla ta꞉depo dlokomane. Epalati motiti patota puame Isip mo patoye bopudlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Epalati Mosesta ya꞉ doye omapla di dla ta꞉depo dlokomalati motiti patotapo puame Isip moye haiyo. Epapele dulu edla motiti pato tuwale etapo elemama alila dapahatlope pololiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Epalati oloma edla Isip sotapo pohoholelalo isikimi hatlo aya dulu dla ha꞉ha꞉iyo. Amasiyama Isalael sota ha꞉ha꞉ mo tlo motiti potulalo hela꞉dleta ala me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Epapalati Pelota Mosesye sisilapame ya꞉ watle epo atlaiyo, “Epedeme wua꞉ta hapuloma mo-wua꞉ wola꞉ mate epo mo-wua꞉ yimlala mate alikili a꞉ma woyapo tame wua꞉ God dla inoma sumama ya꞉ hi di dla ta꞉demha꞉ha꞉iya. Amasiyama wua꞉ tamalemama wua꞉ aliya halo tlo pe-elemtlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Epalati Mosesta asiyama epo atlaiyo, “Hao, di pe-epapolowa. Adipalati, di aliya halo iye poyupame God dla namkale dle alisisi hapilowama. ");
INSERT INTO xla_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Epapele dulu dla di alinepi adipapele tlo ya꞉ dla poyupo hapipa꞉ dle kokoye ala podimalamana. Epedeme di bidulo edla tame ha꞉ha꞉mama alinepi woloma tlapame poyupo di God dla hapiloweye tlamolowama. Epapedeme di aliya halo hapulomaye me-eleme tlowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Amasiyama Godta Pelo dupa malamaleye ala me-kokalepo mellati Isalael soye ma alikili a꞉ma powoyamaiya dlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Epammama ya꞉tapo siyalademama Moses watle epo atlaiyo, “Wa꞉ na꞉ aya itle alikili a꞉ma tane. Na꞉ta matle wa꞉ mila꞉pi natilipiye, wa꞉ yumuluwepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Epalati Mosesta asiyama epo atlaiyo, “Ka꞉pi, eye wa꞉ta solotamale kokopo. Na꞉ matle ilame wa꞉ hala dla populuwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Epame Godtapo ma Moses watle epo atlaiyo, “Na꞉tapo mosukulu wotiyalle hatlopeye Pelo mate epo ya꞉ opa Isip so mate dla hamilowepo. Epalati yia꞉tapo wotiyalle iye natimama asiyama Pelota wua꞉ye Isip mo tle alikili a꞉ma taiya demama mosukulu dodolomsallepe. ");
INSERT INTO xla_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Epedeme wa꞉ Isalael so dla atlamane, yia꞉tapo gold ewala mate epo silba ewala mateta mimita꞉pele alisisiye yimkadulo Isip so dla dlalepame halomelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Adipalati, Godtapo Isip so dla dupa malamale ka꞉dle hamiyo, ma yia꞉tapo Isalael so mate ka꞉pi namkale demha꞉ha꞉lepo depame. Epammama Pelo ya꞉ oko so mate epo Isip so hapuloma matetapo ma Mosesye pato oplami demdiyo. ");
INSERT INTO xla_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Epalati Mosestapo Pelo watle epo atlaiyo, “Godtapo ipo atla, wata utula꞉la dukuslopi dla ya꞉tapo Isip mo pato duka tle tlowepo de. ");
INSERT INTO xla_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Epapele oloma edla itapu hohomale akimlala hapulomata pallipe. Epele dulu dla wa꞉ maseyemala itapu hamale tatle polope, epame Isip so yia꞉ akimlala itapu hohomale so hapuloma mape medla palimtelepe. Epame wua꞉ aliya halo dulu dla mape itapu usulli patetalo hapuloma ma pallipe de. ");
INSERT INTO xla_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Epapele dulu dla sikemte a꞉lle yu patotapo Isip mo pato dla ellepe. Epapedeme a꞉lle yu epapeleye ka꞉yapa podalemdena, epame a꞉lle yu ipapele mape alotle ma podallowa. ");
INSERT INTO xla_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Amasiyama Isalael so dulu dla itapu hohomale so akimlala hapulomatapo popalilalo, me-ha꞉ha꞉lepe de. Koko hapulomatapo Isalael so dulu dla woloma me-homta ellepe. Epame yia꞉ aliya halo dulu dla haleta popolowa. Wa꞉ta koko i natimama malamelepe, Godtapo Isalael so gadlalo halaye. ");
INSERT INTO xla_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Epame ma wa꞉ oko sotapo na꞉ hete sitali dla puame heodepo otele yu mate epo atlamyelepe, ‘Wa꞉ mo itle wa꞉ opa mate epo wa꞉ alisisi mate alikili a꞉ma mo-woyapo tane,’ demyelepe. Epalati na꞉tapo na꞉ alisisi hapuloma halopo na꞉ opa eleme alikili a꞉ma woyamolowepo,” diyo. Mosestapo yu iye atlemhalepo gudepame siyaladle mate Pelo aya tle alikili a꞉ma woyapo taiyo. ");
INSERT INTO xla_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ka꞉yapa Godtapo Moses watle epo atlaiyo, “Pelotapo wa꞉ yu dla dalepame poheodemhallowa. Epalati na꞉tapo ulugiyemale koko patotoye Isip mo dla halomhallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Epapele koko tle Moses mate epo A꞉lon matetapo ulugiyemale koko patotoye Pelo mila꞉pi tle halomha꞉ha꞉iyo. Amasiyama Godtapo Pelo dupa malamaleye ala me-kokalepo meledemhalemdiyo, Isalael sota Isip mo tle alikili dla wowoyamalala depame. ");
INSERT INTO xla_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Epedeme Moses mate epo A꞉lon mate ala Isip mo dla me-ha꞉ha꞉lati Godta yia꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Itapu woyampola mama iye wua꞉ta ka꞉yapa sokomoko kotiyamolowe mamapo. ");
INSERT INTO xla_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Epedeme wua꞉ Isalael so watle yu iye atlamaiya. Mama woyampola ita alila 10 umulati yia꞉ta daya dlowe dla dinapomama aya hatlope hatlope dle dulu dla yia꞉ halo amkota꞉leye hihimapo elempulupe. ");
INSERT INTO xla_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Epapele dulu dla aya ya꞉ atapo aliya hulumelepiye, ya꞉ aya dulu dla ha꞉ha꞉ so opata dlowe mate ala꞉le hulumelepe. Amasiyama ya꞉ aya dulu dla ha꞉ha꞉ sota aliya eye miyelo dlowe po-ala꞉lalo wekelepiye, ya꞉ ka꞉dena, ya꞉mkadulo ya꞉ mateka꞉pi dla ha꞉ha꞉ so atlepame yimkata delepe. ");
INSERT INTO xla_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Epame yia꞉ta aliya potimolowedeme hulumelepiye, woloma sokomoko hatlo hamastale sipi aliya pate epapele o gaut aliya pate epapeleta hekaka pa꞉talo tlo hulumelepe. ");
INSERT INTO xla_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Epedeme aliya halo huhulalimale iwoloye hihimapo ha꞉ha꞉mama mama i ya꞉ alila 14 umulati tamila꞉la medla potimelepe. ");
INSERT INTO xla_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Epame aliya omali tilipame yia꞉ta daya dempopa꞉lowe aya kokoloma tala alikili dla huhutupiliyemtelepe. ");
INSERT INTO xla_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Epame utula꞉la edla aliya mo eye woloma totopame palawa daya yist pa꞉le mate ha꞉po demama mala epapele mate delepe. ");
INSERT INTO xla_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Yia꞉ daya demama mo ala hesulupo ha꞉leye podlowa, epame tini dla atili mape podlowa. Amasiyama woloma aliya patoye mepo ka꞉pi totomale tlo delepe. ");
INSERT INTO xla_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Epapele utula꞉la edla yia꞉tapo aliya mo hapulomaye depa꞉mele pokadlepe. Amasiyama yia꞉ta mo popokadlalo wekelepiye, mo hapuloma eye dlapa dla mistlepe. ");
INSERT INTO xla_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Yia꞉ daya dlomolowedeme woloma tluka alisisi mate epo hete alisisi mate didiyepo popa꞉mama dali ku mape halomelepe. Epame daya e demama ma hapele hahamale mate delepe. Epapedeme daya dele iye semama Godta Namilatale daya dele dlepe. ");
INSERT INTO xla_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Epedeme utula꞉la oloma edla na꞉tapo Isip mo pato dulu dla tamama akimlala itapu hohomale so hapuloma mate epo alinepi pate itapu usulalimale hapuloma mate potimtlowepo. Epedeme na꞉tapo koko i hamama na꞉ta itiyamaleta Isip so yia꞉ god hapuloma tla꞉mtame hala kokoye botomastlowepo. Adipalati, na꞉ye Godpo. ");
INSERT INTO xla_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Epapedeme na꞉tapo itapu hohomale akimlala potimolowedeme mo dulu dla tumama omalita wua꞉ aya kokoloma tala dla huhutupiliyemtale halla natilipiye, aya eye di tle namilatademtlowepo. Epapele dulu dla na꞉ta Isip so dla wotiyalle hamilowe etapo ma wua꞉ akimlala dla populuwa. ");
INSERT INTO xla_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Epedeme Isalael so wua꞉tapo na꞉ta wua꞉ di tle namilatamama wua꞉ yimlala popotimalalo wekele kokoye powowelliwa, woloma sikemte malaha꞉ha꞉mama sokomoko hapuloma dulu dla alila i umulati na꞉ta Namilatale daya dele iye hademha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Epedeme Namilatale daya dele alila oloma edla wua꞉ aya dulu dla yist hutiyelepiye, alikili dla polollepe. Epame ma alila 7 dulu dla palawa daya yist mate dukumale podemha꞉ha꞉lowa. Epapedeme dulu edla oplami antapo palawa dayaye yist mate dukupo delepiye, ya꞉ye Isalael so tle alikili a꞉ma mosukulu geda꞉dlepe. ");
INSERT INTO xla_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Epame alila 7 dulu edla itapu kotiyamale alila mate dla epame mosukulu alila mate dla wua꞉ta yimkata puame na꞉ dla inoma sumama na꞉ hi di dla ta꞉demha꞉ha꞉lepe. Amasiyama itapu kotiyamale alila mate epame mosukulu gudlowe alila mate dla wua꞉ oko pohalomha꞉ha꞉lowa. Isikimi daya dlowe tlo dinamha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Epapedeme sokomoko hapuloma dla alila 7 dulu edla wua꞉tapo palawa daya yist mate podukumalalo wekele daya dele iye de demha꞉ha꞉lepe. Adipalati, wua꞉tapo alila oloma edla na꞉ta wua꞉ye Isip mo tle alikili a꞉ma eleme woyamuwa kokoye malaha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Epapedeme wua꞉ daya dele iye itapu mama hema alila 14 umulati tamila꞉la edla kotiyapame me-tame alila 21 tamila꞉la dla gudlepe. Alila dulu hema ha꞉ha꞉mama palawa dayaye yist mate dukupo podlomha꞉ha꞉lowa. ");
INSERT INTO xla_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Amasiyama alila 7 dulu edla Isalael so opa aya dulu dla yist hutiyelepiye, alikili dla polollepe. Epame dulu edla oplami antapo palawa dayaye yist mate dukupo delepiye, ya꞉ye Isalael so tle alikili a꞉ma mosukulu geda꞉dlepe. Epapele dulu dla asepe so opi wua꞉ mate ha꞉ha꞉ mape palawa dayaye yist mate dukupo podlomha꞉ha꞉lowa. Epedeme wua꞉ alotle mo hadima tame ha꞉ha꞉mtelepiye, wua꞉ koko iye me-hademha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Epapele dulu dla Godta yukamhalale mogudlati ma Mosestapo Isalael so dokopala soye sisilapame yia꞉ watle epo atlaiyo, “Epedeme wua꞉ Namilatale daya dlowedeme aliya halo huhulupame poyuiya. ");
INSERT INTO xla_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Epame omali tilipame dali tatala hauwalepo omali dla saodepame kokoloma tala alikili dla huhutupiliyemtaiya. Epame utula꞉la edla oplami haletapo alikili a꞉ma po-ulatlowa, amasiyama woloma aya dulu dla popa꞉mtelepe. ");
INSERT INTO xla_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Epalati Godtapo itapu hohomale akimlala potimolowedeme Isip mo dulu dla sela꞉lepe. Amasiyama ya꞉ tamama aya kokoloma tala alikili dla omali huhutupiliyele halla natilipiye, di tle namilatademsela꞉lepe. Epammama ya꞉tapo powale hamsela꞉lalo banakaka oplami watle aya dulu edla akimlalaye popotimane dlowa. ");
INSERT INTO xla_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Epapedeme sokomoko hapuloma dulu dla wua꞉ mate epo wua꞉ mamadulo mate daya dele koko iye ha demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Epame alotle Godta wua꞉ watle hamilowepo depo yu itiyapo himili mo dla tame ha꞉ha꞉mama Namilatale daya dele iye sokomoko hapuloma dulu dla me-de demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","27","Epapele dulu dla wua꞉ yimlalatapo ‘daya dele koko iye apa kokota꞉?’ dlati ma asiyama wua꞉ta yia꞉ watle epo atellepe, ‘Iye Godta Namilatale daya delepo,’ dlepe. ‘Adipalati, Godta Isip mo dulu dla malame sela꞉mama itapu hohomale akimlala hapuloma tlo potimama asiyama Isalael so dia꞉ akimlala tlo me-pomeluwapo,’ dlepe.” Mosesta epo atla dalepame Isalael sotapo God dla heoheodepo popa꞉mama ya꞉ hi di dla ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Epame yia꞉ tame Godta Moses mate epo A꞉lon mate dla atlamale yu e woloma dolumama koko hapuloma eye halomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Epapele utula꞉la dukuslopi oloma dla Godtapo Isip mo dulu dla sela꞉mama Isip so yia꞉ itapu hohomale akimlala hapulomaye potimtaiyo. Epammama Pelo yami tatle yumpame matle Isip so yia꞉ akimlala hapuloma itapu hohomale soye potimtaiyo. Epame itapu usulli alinepi patetalo mape potimtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Epapedeme utula꞉la oloma edla Pelo mate epo ya꞉ oko so mate epo Isip so hapuloma mate sillipame sikemte a꞉lemyaiyo. Adipalati, yia꞉ aya hapuloma dulu dla yia꞉ akimlala itapu hohomale so hapulomatapo mo-palipo hutiyemtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","32","Epedeme utula꞉la oloma edla Pelotapo Moses mate epo A꞉lon mate sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ta hapuloma wata ma-tamalaiya! Wua꞉ wola꞉ mate epo wua꞉ yimlala mate epo wua꞉ aliya halo mate me-eleme ma-tamalaiya, wua꞉ God hi di dla ta꞉dlowedeme. Amasiyama wua꞉ tamama God dla inoma sumale mate na꞉ gadiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Epammama Isip so mape Isalael so dla epo atlamyaiyo, “Wua꞉ di mo itle ma hapele alikili a꞉ma woyapo tamalaiya. Adipalati, wua꞉ta hema me-ha꞉ha꞉lepiye, dita hapulomatapo palilala,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Epalati Isalael sota ma-tamhalemama palawa daya yist mate podudukumalalo wekeleye ita dla kukutipame tlukata popoliyepo momka꞉tipo tamhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Epame yia꞉tapo Mosesta yu atlamale e dolumama Isip so dla gold alisisi mate epo silba alisisi mate epo tluka alisisi mate dlalepo halopame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Adipalati, Godtapo Isip so dla dupa malamale ka꞉dle hamiyo, ma yia꞉tapo Isalael so mate ka꞉pi namkale demha꞉ha꞉lepo depame. Epedeme Isalael sota mo-tlowedeme Isip so watle alisisi otlomyelati Isip sotapo alisisi hapulomaye yia꞉ watle halopiyo. Epapele koko tle Isalael sotapo ma-tamalemama Isip so yia꞉ alisisi ka꞉ka꞉dle hapulomaye halopo alikili dla woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Epapedeme Isalael sotapo Isip mo tle ma-tamalemama Lamses mo tle ma Sukot mo dla tamalaiyo. Yia꞉ alikili dla mo-woyapo tame ha꞉ha꞉mama opa siyapo tlo sesa꞉lati 600,000 umaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Yia꞉ tamalemama yia꞉ aliya halo hapuloma mate eleme tamalaiyo. Epame opa opi mape yia꞉ mate me-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Epame yia꞉ duka dla tame hedepo daya dlowedeme palawa dayaye yist mate podukumalalo isikimi mepo halopo deiyo. Adipalati, yia꞉tapo yia꞉ daya alisisiye woloma podinapolalo ma hapele Isip mo tle alikili dla woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Epapele dulu dla Isalael sotapo Isip mo dulu dla 430 sokomoko ha꞉ha꞉pame alikili dla woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Epame utula꞉la oloma edla Godtapo yia꞉ye alikili a꞉ma eleme woyamolowedeme woloma ka꞉pi omhalaiyo. Epapedeme sokomoko hapuloma dulu dla alila eye umulati asiyama Isalael sotapo Godta yia꞉ye eleme alikili a꞉ma woyamale koko malamama utula꞉la edla ompopa꞉demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Epapele dulu dla Godtapo Moses mate epo A꞉lon mate dla epo atlaiyo, “Wua꞉ta Namilatale daya dele iye demha꞉ha꞉lepiye, isikimi Isalael so siyapota demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Epedeme wua꞉ dla asiyama pa꞉le oko halalo oplami hallepiye, wua꞉ ka꞉yapa ya꞉ kapala tatle kestapame alotle ya꞉ye Godta Namilatale dayaye dene demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Amasiyama kapala pokotimalalo wekele asepe sotapo Godta Namilatale daya iye podlomha꞉ha꞉lowa. ");
INSERT INTO xla_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Wua꞉ Namilatale daya i demama woloma wua꞉ aya dulu dla delepe. Oplami haletapo moye hame alikili dla powoyamolowa. Epame elo mape pohauwokokomolowa. ");
INSERT INTO xla_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Epapedeme Isalael so opa hapulomatapo daya dele dulu hema ha꞉ha꞉lepe, haleta alikili dla po-ulatlowa. ");
INSERT INTO xla_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Epame asepe so wua꞉ mate ha꞉ha꞉ dulu hema yia꞉ ma Godta Namilatale daya dele iye yia꞉ mate dlowe solotamelepiye, yia꞉ ka꞉yapa yia꞉ opa siyapo tatle kapala kotimelepe. Epame yia꞉tapo wua꞉ mate Namilatale daya deleye yimkata delepe. Daya dele iye kapala pokestlalo wekele oplamitapo podlowa. ");
INSERT INTO xla_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Epame Isalael so mape me-epapena. Yia꞉ dulu dla kapala pokotimalalo wekele so opa ha꞉ha꞉lepiye, yia꞉ mape Godta Namilatale daya dele iye podlowa.” ");
INSERT INTO xla_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Epapedeme Isalael sotapo Godta Moses mate epo A꞉lon mate dla atlamale yuye woloma dolumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Epedeme alila hatlo medla Godta Isalael so elele meyelope meyelope dle hapulomaye Isip mo tle eleme alikili a꞉ma woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Epame Godtapo Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Wua꞉ akimlala itapu hohomale soye na꞉ watle hohopo iya. Epame wua꞉ aliya halo patetalo itapu usulli mape na꞉ watle hohopo iya. Adipalati, akimlala itapu hohomale mate epo aliya halo patetalo itapu usulli mate nolëpo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Epalati Mosestapo Isalael so watle epo atlaiyo, “Alila iye wua꞉tapo Isip mo dulu dla asiyama pa꞉le oko halomha꞉ha꞉lati Godtapo ya꞉ta itiyamale pato mate wua꞉ye eleme alikili a꞉ma woyamapo. Epedeme wua꞉ alila iye malamama palawa daya yist mate dukumale podlowa. ");
INSERT INTO xla_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Epedeme watapo Abib mama oloma hema wua꞉ye Isip mo tle ma alikili a꞉ma woyamapo. ");
INSERT INTO xla_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Epapedeme Godtapo ka꞉yapa wua꞉ mamadulo dla yu itiyapo himimama wua꞉ye mo hale, dlowe alisisi sikemte wokasemale dla eleme tlowepo duwapo. Amasiyama wata oloma hema Keinan so mate epo Hitai so mate epo Amoli so mate epo Hibai so mate epo Yebusi so mateta mo edla me-ha꞉ha꞉po. Amasiyama epapele tlope Godtapo yia꞉ ta꞉laye ma wua꞉ watle hamilipe. Epame wua꞉ mo edla ha꞉ha꞉mama sokomoko hapuloma dulu dla itapu mama hema palawa daya yist mate podukumalalo wekele daya dele iye de demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Epedeme alila 7 dulu dla wua꞉ palawa daya yist mate dukumaleye podlomha꞉ha꞉lowa. Wua꞉ dulu dla yist hutiyelepiye, alikili a꞉ma polollepe. Epame daya dele mosukulu alila dla daya pato demama God hi di dla ta꞉de demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Epammha꞉ha꞉le oloma edla wua꞉ yimlala watle wua꞉ta daya de ya꞉ dulu kokoye yia꞉ watle atlemama ipo atlemha꞉ha꞉lepe, ‘Dita koko i haye, Godta dia꞉ye Isip mo tle alikili a꞉ma eleme woyamuwa kokoye malamama apopo,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Epedeme daya dele koko itapo wua꞉ do dla epo wua꞉ daptala dla ulu epapele some hutiyelepe, wua꞉tapo Godta imale kokoye wowelilala depame. Adipalati, ya꞉ta itiyamaleta wua꞉ye eleme Isip mo tle alikili dla woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Epapedeme sokomoko hapuloma dulu dla ya꞉ alilata umulati wua꞉tapo palawa daya yist mate podukumalalo wekele daya dele iye de demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","12","Godtapo wua꞉ mamadulo dla yu itiyapo himili dolumama Keinan moye wua꞉ watle hamilati wua꞉tapo edla ha꞉ha꞉mama wua꞉ akimlala itapu hohomaleye God watle hohopo imha꞉ha꞉lepe. Epame aliya halo dulu dla itapu patetalo usulli mape God watle hohopo imha꞉ha꞉lepe. Adipalati, itapu hohomale akimlala mate epo alinepi patetalo mateye God tetepo. ");
INSERT INTO xla_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Amasiyama wa꞉ donki aliya tlo God watle hamili hallepiye, wa꞉ e tlo ma ilame hammama asiyama sipi aliya amkota꞉le tlo God watle hamilipe. Amasiyama epapele dulu dla wa꞉ sipi aliya yumuluwe allipiye, donki aliya tlo tumuku kestlepe. Epapedeme wua꞉ akimlala itapu hohomale God watle hohopo iliye ma ya꞉ tle asiyama mate ilame hohomelepe. ");
INSERT INTO xla_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Epapedeme wua꞉ yimlalatapo wua꞉ watle atlemama wua꞉ apa koko hama꞉ dlati yu iye yia꞉ watle atlamha꞉ha꞉lepe, ‘Dita koko i haye, dita Isip mo dulu dla asiyama pa꞉le oko pato hamha꞉ha꞉lati Godta itiyamaletapo dia꞉ye eleme alikili a꞉ma woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Epame oloma edla Pelotapo dia꞉ye alikili a꞉ma woyamaiya dloweye sikemte alimama posolotamdena. Epalati Godtapo Isip so yia꞉ itapu hohomale akimlala mate epo yia꞉ aliya halo itapu usulli patetalo mateye potimuwapo. Epapedeme epapele koko tle ditapo di aliya halo itapu usulli patetaloye poyupo God watle hapimdepo. Epame di akimlala itapu hohomale so God watle hohopo iliye ma ilame bidulo hohomolowedeme di halo tlo poyupo hapimdepo,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Epedeme God watle alinepi poyupo hapilowe koko itapo wua꞉ do dla epo wua꞉ daptala dla ulu epapele some hutiyelepe. Adipalati, wua꞉tapo Godta itiyamaleta wua꞉ye eleme Isip mo tle alikili dla woyamale kokoye wowelilala depame.” ");
INSERT INTO xla_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Epapeleye Pelota Isalael soye ma-taiya dlati Godtapo yia꞉ye eleme api kiyele Pilisteya so mo dla tlalo api tle potlalo wekiyo. Adipalati, ya꞉ malamaiyo, yia꞉tapo api kiyele tle tlati opahale sotapo yia꞉ mate nalatimalati ma ilame Isip mo dla tamallala depame. ");
INSERT INTO xla_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Epammama ya꞉tapo yia꞉ye api selemalli dalupa dulu tle ma Omteka꞉pele Kaula pili dla elemtaiyo. Epame yia꞉ tamalemama yia꞉ opahale alisisiye mo-dinapopo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Epedeme Mosestapo tamama Yosep powale elo mate halopo taiyo. Adipalati, Yoseptapo mo-powataliya mo-polowedeme elemama Isalael so watle yu itiyamale mate epo atlaiyo, “Godtapo wua꞉ye Isip mo tle alikili a꞉ma eleme woyamalati tamalemama na꞉ elo mate halopo tamellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Epapeleye Isalael sotapo Sukot mo saliyome ma Etam mo dla taiyo. Etam mo eye dalupa mateka꞉pi dla halapo. ");
INSERT INTO xla_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Epedeme yia꞉ alila tamallati Godtapo wuala dulu tle yia꞉ye elemtamdiyo. Epalati asiyama utula꞉la tamallati Godtapo yia꞉ dla hela꞉dle hamimama dlapa ulli aloweli dulu tle yia꞉ye elemtamdiyo. Godtapo ipapele api tle yia꞉ye imtlati yia꞉tapo alila mate epo utula꞉la mate me-tamalemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Amasiyama wuala mate epo dlapa ulli aloweli mateta yia꞉ posaliyome tlalo itapu tle yia꞉ elemtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Godta ma Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Opa watle yu iye atlamane, yia꞉ ma ilame Pihahilot mo dla ta diya. Mo eye Bal Sepon mo mateka꞉pi, Migidol ka꞉ epo kaula ka꞉ duka dla halapo. Epedeme yia꞉ tame kaula pili dla kimpo ha꞉ha꞉lepo. ");
INSERT INTO xla_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Adipalati, Pelota malamelepe, Isalael soye dalupa dulu dla tloweye api yeitamama wowota꞉msiyamayo dlepe. ");
INSERT INTO xla_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Amasiyama na꞉tapo Pelota malamaleye mamisika꞉ kokalepo mellowepo, ya꞉tapo ya꞉ opa mate wua꞉ye ma hohomala telepo depame. Amasiyama na꞉ta yia꞉ watle halowe kokotapo opa hapuloma dla na꞉ta itiyamale kokoye nati-iliwepo. Epalati Isip sotapo na꞉ye ikadepe God mleni dlepe,” diyo. Epalati Isalael sotapo God yu i dalepo dolumaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Epapele dulu dla Pelo mate epo ya꞉ oko so mateta Isalael sota ma ilame popumullalo ma a꞉ma potale halla dalepame epo atlamyaiyo, “Wua꞉ natiya, Isalael soye di asiyama pa꞉le oko halalo sopo. Epedeme di yia꞉ye adipalati alikili a꞉ma woyamaiya duwa?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Epalati Pelotapo ya꞉ aliya koa hame ya꞉ opa mate Isalael soye alotle dodolomtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ya꞉ta tamama 600 aliya koa ka꞉ka꞉dle mate epo aliya koa hapuloma mo dulu dla siyamalalo mate elepame taiyo. Epele dulu dla aliya koa hapuloma di edla opatapo mo-popa꞉mtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","10","Epapeleye Godta Pelo dupa malamale kokalepo mellati ya꞉tapo ya꞉ opa mate Isalael soye dodolomtamallati Isalael sotapo sisiyele mate kaula mateka꞉pi dla ellalo Pihahilot mo dla mala tamalaiyo. Yia꞉ edla tulume kimtimha꞉ha꞉mama alo dla natilati Pelotapo ya꞉ opa mate epo ya꞉ aliya koa hapuloma mate alotle pumulla natiyo. Epalati yia꞉tapo sikemte wowota꞉mama gadle yilo God dla a꞉liyo. ");
INSERT INTO xla_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Epame Moses dla epo atlamyaiyo, “Wa꞉ adipalati dia꞉ye Isip mo tle hema elempuwa? Epame wa꞉ di Isip mo dla palilati hatiliwe wabasi hawa hallati dia꞉ye dalupa dulu hema pallipo depame elempuwa? ");
INSERT INTO xla_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Epame ditapo wa꞉ watle ma-atlamduwapo, ‘Wa꞉ di memelene. Di Isip mo medla asiyama pa꞉le oko halomha꞉ha꞉lowama,’ demduwapo. Epapele dulu dla di asiyama pa꞉le oko dulu medla ha꞉ha꞉matiye, di dalupa dulu hema puame popalima,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Epalati Mosestapo epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Woloma kokalepo ha꞉ha꞉iya. Adipalati, wua꞉ wata Godtapo wua꞉ gadle kokoye natilipe. Ame adipalati, wua꞉tapo Isip so iwolo yia꞉ mila꞉piye matle ponatilowa. ");
INSERT INTO xla_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Epapedeme wua꞉ isikimi omha꞉ha꞉iya. Epalati Godta wua꞉ yilo nalatimelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Epalati Godta Moses watle epo atlaiyo, “Wa꞉ adipalati gadle yilo na꞉ dla otele himhalema꞉? Wa꞉ opa atlamane, kaula pili dla tulume popa꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Epame wa꞉ dali ku hapame kaula pato di dla dlokomane. Epalati kaula patotapo meyelo duka gladlati wa꞉ mate epo Isalael so mate ta꞉la sekelle tle seme dla ulumtelepe. ");
INSERT INTO xla_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Epame na꞉tapo Pelo mate epo ya꞉ opa mate yia꞉ dupa malamaleye kokalepo mellati yia꞉tapo wua꞉ alotle dodolomelepe. Amasiyama na꞉ta yia꞉ watle halowe kokotapo opa hapuloma dla na꞉ta itiyamale kokoye nati-iliwepo. Epalati Isip sotapo na꞉ye ikadepe God mleni dlepe.” ");
INSERT INTO xla_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Epalati God ya꞉ banakaka mate epo wuala mateta itapu tle api imtamalaleye matle alo dla tulume Isalael so ka꞉ epo Isip so ka꞉ duka dla halemama Isalael so dla hela꞉dle hamimama asiyama Isip so watle amtuwale hamiyo. Epammama yia꞉tapo Isalael so hala dla puluweye amtuwaleta api himomeleme halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Epalati Mosestapo ya꞉ dali ku hamhalemama kaula pato di dla dlokomaiyo. Epalati Godtapo salita matlalo tiyama tle mosisi pato hamilati mosisitapo utula꞉la patoye hotlomhalemama kaula yú patoye duka gladiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Epalati yúta duka gladepame duka dla ta꞉la sekelleta woyamellati Isalael sota etle seme dla ulumha꞉ha꞉iyo. Yia꞉ kaula patoye ta꞉la sekelle tle ulumha꞉ha꞉mama natilati yútapo seme mate seme mate dla kosukulli some halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Epalati Pelo ya꞉ opata koko e natipame yia꞉ aliya koa mate Isalael sota ulli alotle kotiyapame uliyo. ");
INSERT INTO xla_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Epapeleye ma alallowe mateka꞉pi dla hallati Godtapo wuala dulu tle epame dlapa ulli aloweli dulu tle Isip so natipame yia꞉ dla yeitamale hamiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Epame yia꞉ aliya koa heteye bobtalipo mellati yia꞉tapo a꞉ma tloweye memeliyo. Epapala natipame yia꞉tapo yia꞉skamu yia꞉ dulu dla epo atlamyaiyo, “Di itle ma ilame tamali dla tlowa. Adipalati, Godtapo Isalael so yilo dia꞉ mate nalatimama aposema,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Epalati Godtapo Moses watle epo atlaiyo, “Wa꞉ dali ku mamisika꞉ ta꞉depame kaula di dla dlokomane. Epalati yúta ma ilame puame godemama Isip so mate epo yia꞉ aliya koa mateye gola꞉dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","28","Utulala ikadepe salita mo-matlati Mosesta ya꞉ dali ku di dla ta꞉depo halemama kaula pato dla dlokomaiyo. Epalati yútapo ma ilame mo-godla puaiyo. Isip sota epela natipame ma ilame potlati yia꞉ mate epo yia꞉ aliya koa mateye yúta hapuloma gola꞉demama potimaiyo. Epapedeme ipapele koko tle Godtapo Isip so hapulomaye potimama oplami haletapo alikili a꞉ma po-ulataiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","30","Epedeme alila oloma edla Godtapo Isalael soye Isip so do tle eleme alikili a꞉ma woyamaiyo. Adipalati, ya꞉tapo kaula patoye duka gladepame yúta seme mate seme mate dla kosukulli some hallati Isalael sotapo ta꞉la sekelle tle seme dla uliyo. Asiyama Isip sotapo ullati yú patota ma godemama poyuiyo. Epalati Isalael sotapo Isip so palli motoye yú peleyama dla hutiyemyelati tlamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Epapele dulu dla yia꞉tapo Godta ya꞉ta itiyamale nati-imama Isip so dla wotiyalle hamili koko natipame God dla sikemte wowota꞉le mate ya꞉ dla mikadepe demama ma ya꞉ oko oplami Moses dla mape mikadepe diyo. ");
INSERT INTO xla_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Epapedeme Moses mate epo Isalael so mate God hi di dla ta꞉demama sala iye dolumaiyo. “Na꞉tapo God hi di dla ta꞉demama sala iye dolumolowepo. Adipalati, ya꞉tapo Isip so mate nalatimama ya꞉ta itiyamaletapo yia꞉ye ma-tla꞉mtalepo. Epame ya꞉tapo aliya koa mate epo yo di dla popa꞉lalo so mate yú dla mo-yumatilipo. ");
INSERT INTO xla_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Epedeme Godtapo na꞉ dla itiyamale hamilalo halapo epame na꞉ pasakalo gadlalo halapo. Epedeme na꞉ ya꞉ dla sala solowama. Epame na꞉ta ya꞉ye na꞉ God ikadepe demama ya꞉ hi di dla ta꞉dlowepo. Epame na꞉ mamadulo yia꞉ God ikadepe demama ya꞉ dla siyele hamilowepo. ");
INSERT INTO xla_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Epapedeme Godye opahale dlalo dokopala oplamipo. Epedeme Godye ya꞉ hi ikadepepo. ");
INSERT INTO xla_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Epapele dulu dla Pelo ya꞉ opa mate epo yia꞉ aliya koa mate Godtapo Omteka꞉pele Kaula dulu dla mo-yumatilipo. ");
INSERT INTO xla_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Epame yútapo yia꞉ dokolomama ewala some u-upiyemama ollotulume ta꞉la umpo popa꞉po. ");
INSERT INTO xla_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Epame God wa꞉tapo Isip soye wa꞉ta itiyamale pato mate mo-potipo hamastalepo. ");
INSERT INTO xla_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Epame wa꞉ta itiyamaletapo wa꞉ dla opahale dlalo soye batalipo hamastalepo. Epame wa꞉ta siyaladleye pta sikemte dlapa sepena. Epapedeme wa꞉ dla opahale dlalo soye dlapata osamokolo hamdemdiye epapelepo. ");
INSERT INTO xla_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Epame wa꞉ta hedletapo mosisi some bibikilimama kaula patoye duka gladuwapo. Epalati yútapo kokalepame kosukulli some haluwapo. ");
INSERT INTO xla_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Epapedeme ka꞉yapa Isip sotapo hatetalemama epo atlamyeuwapo, ‘Ditapo Isalael soye dodolomtame yia꞉ye hohopo aipa꞉ya mate poyupame yia꞉ alisisi hapuloma halomolowepo,’ demyeuwapo. ");
INSERT INTO xla_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Amasiyama wa꞉ta hedletapo mosisi some bibikilimama yia꞉ye yúta gola꞉depo poyumama yú dulu dla ewala some ollo-ollo dlalimuwapo. ");
INSERT INTO xla_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Epapedeme god hale wa꞉ epapele halema꞉? Hao, hawa ikadepe. Adipalati, wa꞉ye sikemte aiyalma depo halemama hela꞉dle mate itiyamale mate halapo. Epame wa꞉tapo ulugiyemale koko patoto halomdepo. ");
INSERT INTO xla_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Epame wa꞉ta itiyamale tle Isip soye ta꞉lamota gola꞉dene dlepo. ");
INSERT INTO xla_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Epapedeme wa꞉ kokó halepo hallalo bokotiyapo malamaletapo wa꞉ta ma ilame hohomale opa dia꞉ye eleme telepe. Epame wa꞉tapo yia꞉ye wa꞉ta hallalo mo dla eleme pulupe. ");
INSERT INTO xla_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Epedeme opa opitapo koko i dalepame sikemte wowota꞉myelepe. Epapele dulu dla Pilisteya soye sikemte wowota꞉mama yia꞉ta itiyamaleye pa꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Epame Edom dokopala so mate epo Moab dokopala so mate sikemte eseselalalimale mate dupa yulumama wowota꞉myelepe. Epame Keinan so tlo sikemte yiyellepe. ");
INSERT INTO xla_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Epapele dulu dla opa ewolotapo wa꞉ta itiyamale natipame wowota꞉mama dali sokotalo some ha꞉ha꞉myelepe. Yia꞉tapo mepo ha꞉ha꞉lati wa꞉ opa, wa꞉ta ma ilame hohomale sotapo tamhalemama tetla꞉mha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Epame wa꞉tapo yia꞉ye elemtame wa꞉ta hallalo tamali dla ipila꞉lepe. Adipalati, tamali eye wa꞉ dota mita꞉pele aiyalma ayapo. ");
INSERT INTO xla_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","God, wa꞉ta dokopala depo hallowe kokotapo kokó halepo hallepe.” ");
INSERT INTO xla_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Epapedeme sala iye Isalael sotapo God hi di dla ta꞉demama dolumaiyo. Adipalati, Godtapo kaula patoye duka gladlati Isalael sota ta꞉la sekelle tle seme dla uliyo. Amasiyama Isip sota ullati Godta yúye ma hame puame bopudemama yia꞉ye poyuiyo. ");
INSERT INTO xla_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Epalati God yu molo atlalo a꞉ya, A꞉lon ya꞉ nana Miliyamtapo wola꞉ opi mate sila꞉sila꞉ halopo siyalemama Miliyamta itapu sala hamastepo yomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Epammama ya꞉ sala ipo dolumaiyo, “God hi di dla ta꞉demama sala iye dolumaiya. Adipalati, ya꞉tapo Isip so mate nalatimama ya꞉ta itiyamaletapo yia꞉ye ma-tla꞉mtalepo. Epame ya꞉tapo aliya koa mate epo yo di dla popa꞉lalo so mate yú dla mo-yumatilipo.” ");
INSERT INTO xla_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Epame Mosestapo Isalael soye elepame Omteka꞉pele Kaula saliyome ma Sul dalupa dulu dla tamalemama alila dapahatlope dulu dla yú dimi tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Epame yia꞉ puame Mala mo dla yú natiyo. Amasiyama yú eye haka꞉lati podlomaiyo. Epedeme mo e ya꞉ hiye semama Mala demdepo. ");
INSERT INTO xla_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Epapeleye yia꞉ edla puame natitepo yú dloweta pa꞉lati Moses yu balemama, “Di yú hadima tame tilipo dlopa꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Epalati Mosestapo gadle yilo God dla otele himiyo. Epapalati Godtapo dali tatalaye nati-iyo. Epame Mosestapo dali tatala eye hame yú dla hamastlati yútapo ma opaliyo. Epapedeme Mala mo edla Godtapo Isalael sota ikadepe ya꞉ dolumolowe depame aiyalma amkoye ipo imaiyo, ");
INSERT INTO xla_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Wua꞉ hatlo na꞉ yu dla dalepo salladepo siyamama na꞉ta solotamale koko tlo dolumha꞉ha꞉iya. Wua꞉ta epapelepiye, eta na꞉ta Isip so dla wotiyalle hapiwa epapele wotiyalleye ma wua꞉ watle pohapilowa. Adipalati, na꞉tapo God depo halemama wua꞉ta alomaleye ka꞉ka꞉dlalo halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Epame yia꞉tapo Mala moye saliyome ma Elim mo dla puaiyo. Epapeleye Elim mo edla yú matale 12 me-popa꞉iyo. Epame olo dali 70 ma medla ha꞉ha꞉iyo. Epalati yia꞉tapo yú matale mateka꞉pi medla kimtimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Epapedeme Isalael sotapo Elim mo saliyome ma Sin dalupa dulu dla taiyo. Epapeleye mo eye Sainai tamali ka꞉ epo Elim mo ka꞉ duka dla halaiyo. Epapele dulu dla yia꞉ Isip mo tle woyapame mama hatlope dulu dla puame Sin dalupa dulu dla woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Epame yia꞉ edla puame ha꞉ha꞉mama Moses mate epo A꞉lon mate dla yu balemyemama epo atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Wua꞉ adipalati dia꞉ye hema eleme puwa? Hema daya dlowe hawa ikadepe. Amasiyama Isip mo dla di dlowe alisisi sikemte dlomduwapo. Epapeleye ka꞉dena, di edla ha꞉ha꞉mama palliwe tlo ka꞉pipo. Amasiyama wua꞉tapo dia꞉ye daya teta꞉le koko tle pallipo depame hema elempuwa,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Epalati Godtapo yia꞉ta yu balle koko dalepame Moses watle epo atlaiyo, “Na꞉tapo dayaye pepele di tle wua꞉ dla hamimama tiyo some hellepe. Epalati opatapo tame alila hatlo mate ala꞉le daya haloma demha꞉ha꞉lepe. Epapele dulu dla haletapo dayaye alila hatlo dla dlowe dla tla꞉mtale pohalowa. Adipalati, ipapele koko tle na꞉tapo yia꞉ta ikadepe na꞉ta aiyalma hapili dolumha꞉ha꞉ma꞉ depo omhallepe. ");
INSERT INTO xla_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Amasiyama alila 6 umulati tlo dayaye alila dapiyamte dulu dla dlowe mate ala꞉le halepe.” ");
INSERT INTO xla_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","8","Epapalati Moses mate epo A꞉lon mate Isalael so sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ adipalati dia꞉ dla yu balemha꞉ha꞉ma꞉? Wua꞉ta yu balemha꞉ha꞉ye dia꞉ dla po-aposema. Amasiyama wua꞉ God dla apopo. Epapele dulu dla Godtapo wua꞉ta ya꞉ dla yu balle kokoye ma-daluwapo. Epapedeme wata tamila꞉la wua꞉tapo ikadepe Godta wua꞉ye Isip mo tle alikili a꞉ma eleme woyamuwa dle kokoye natilipe. Epame wua꞉tapo utulala ikadepe ya꞉ta itiyamale mamisika꞉ natilipe. Adipalati, God meyelo wua꞉ta tamila꞉la dlowe mo mate epo utulalati dlowe daya mate wua꞉ dla halopimhallati wua꞉ natilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Epammama Mosestapo A꞉lon watle epo atlaiyo, “Wa꞉ Isalael so atlamane, God hala dla pulupo depame. Adipalati, Godtapo yia꞉ta yu balle kokoye ma-dallepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Epapeleye A꞉lontapo ala opa dla me-yukamhalemama toko alikili dla ipo natitepo God ya꞉ hela꞉dletapo wuala dulu dla halla natiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Epame Godta ma Moses watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Na꞉tapo yia꞉ta yu balle kokoye me-daluwa. Epedeme wa꞉ opa watle ipo atlamane, yia꞉ tamila꞉la hapuloma dla mo dloma epo utulalati hapuloma dla daya dloma demha꞉ha꞉lepe. Epalati yia꞉ta epo dlomha꞉ha꞉mama na꞉ye yia꞉ Lod Godpo dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Epapele tamila꞉la oloma edla tuluma tea hapulomatapo ketame puame kimna꞉ya alikili dla popa꞉myaiyo. Epalati utulalati ikadepe dla kimna꞉ya alikili tle mamdulotapo osamokolo dla popa꞉myaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Amasiyama mamdulotapo mo-pa꞉lati toko ipo natitepo amalo kapa sepeletapo ta꞉la dla kamyela natiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Epapele dulu dla Isalael sota koko i natipame apa alisisita꞉ depo momalamyaiyo. Epalati Mosestapo yia꞉ watle epo atlaiyo, “Eye Godta daya hamimama apopo. ");
INSERT INTO xla_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Epedeme ya꞉tapo epo atlamuwapo, ‘Wua꞉ dulu dla daya i halomama isikimi wua꞉ kimna꞉ya dulu dla ha꞉ha꞉lalo so mate ala꞉le tlo halomelepe,’ duwapo.” ");
INSERT INTO xla_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","18","Epalati opatapo Moses yu dalepo tame dayaye yia꞉ mate ala꞉le halomama opa opitapo pasatale halomalati opitapo koweta halomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Epame Mosestapo epo atlaiyo, “Daya i dlomama ma utulalati dloweye pohatitimolowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Amasiyama opa opitapo Moses yu podallalo daya utulalati dloweye me-hatitimaiyo. Epalati utulalati dayatapo hutumama hutalluta pamelati wokakata wokasepo elaiyo. Epapalati Mosesta koko e natipame opa ewolo mate sikemte siyaladiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Epapeleye opatapo utulala hapuloma dla daya yia꞉ mate ala꞉le halomdiyo. Epame salitapo mo duka dla hetamama sikemte alemallati daya yia꞉ta halomama opi popomelletapo potolumdiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Epapele dulu dla alila 6 umulati yia꞉ta daya halomama alila dapiyamte dulu dla dlowe mate ala꞉le halomaiyo. Epapalati Isalael dokopala sota koko e natipame Moses hala dla woloma atla puaiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Epalati Mosestapo yia꞉ watle epo atlaiyo, “Godta atlale e dolumama iyelaye dita God dla inoma sumuluwe alilapo. Epapedeme wua꞉ daya wata dloweye wata dukupame ha꞉lepe. Epame wata atilowe mape wata atilipe. Epame wua꞉ta iyela dlowa depo halomale alisisi tlope me-hatitimelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Epalati yia꞉tapo Mosesta atlale yu e woloma dolumale koko tle yia꞉ta inoma sumalalo alila dla dlowepo depo kolumale dayata pohutlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Epammama Mosestapo opa watle epo atlamaiyo, “Wua꞉ta tatla daya hatitimuwaye wata dlomaiya. Adipalati, wata alila iye God dla inoma sumuluwe alilapo. Epedeme ya꞉ watapo dia꞉ watle daya amko pohamilowa. ");
INSERT INTO xla_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Epapedeme wua꞉ alila 6 dulu dla daya haloma demha꞉ha꞉lepe. Amasiyama alila 7ye dita isikimi hedepo popa꞉mama God dla inoma sumuluwe alilapo. Epedeme wua꞉ alila edla daya amko hale ponatilowa.” ");
INSERT INTO xla_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Epapele tlope opa opitapo yia꞉ta inoma sumalalo alila medla daya halomala taiyo. Amasiyama yia꞉ tame natilati daya hale ponatiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Epalati Godta koko e natipame Moses watle epo atlaiyo, “Wua꞉ye adipalalo na꞉ yu dla dalepame dolupa꞉? ");
INSERT INTO xla_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Epedeme na꞉ta wua꞉ dla inoma sumalalo alilaye hamiwapo, wua꞉ta hedlepo depame. Epapele koko tle na꞉tapo wua꞉ watle 6 alila umulati daya ma halopiwapo, wua꞉tapo alila dapiyamte dla demtelepo depame. Epedeme inoma sumalalo alila edla oplami haletapo alikili a꞉ma poholomsela꞉lowa. Amasiyama woloma yia꞉ aya dulu dla ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Epalati opa hapulomatapo inoma sumalalo alila edla woloma hedepo popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Epapeleye Isalael sota Godta yia꞉ watle daya hamili e semama mena daya diyo. Mena daya iye dlomoko ta kamale epapele sepena. Amasiyama ya꞉ tlo sikemte opalimama topsiyo dala mate dukumale daya some halemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Epame Mosestapo opa watle epo atlaiyo, “Godtapo epo atlema, mena daya opiye di mamadulo alotle ha꞉ha꞉mtlowe sota natiloweye woloma hatitimelepo dema. Epapelepiye, etapo wua꞉ta Isip mo tle woyapo dalupa dulu dla siyamalati Godta wua꞉ta delepo depame mena daya hapimhaluwaye yia꞉ ma me-natilipe.” ");
INSERT INTO xla_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Epammama Mosestapo A꞉lon watle epo atlaiyo, “Wa꞉ ita dla mena dayaye kolupame God mila꞉pi tle woloma ka꞉pi pamelene, di mamadulo alotle ha꞉ha꞉lowe sota natilipo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Epapedeme A꞉lontapo Godta Moses watle atlamale yu dalepame mena daya kolumaleye woloma kokó mepo ellepo depame God mila꞉pi tle pameliyo. ");
INSERT INTO xla_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Epapele dulu dla Isalael sotapo 40 sokomoko dulu dla isikimi mena daya tlo dlomsiyamama yia꞉ta ha꞉ha꞉lowe mo Keinan dla puame woyamama medla gudiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Epedeme Isalael sotapo Godta atlamale yu dolumama Sin dalupaye saliyome tamalemama mo hale tle ma mo hale dla ta demsiyamama puame Lepidim mo dla kimtimaiyo. Amasiyama mo edla opata yú dlowe hawa ikadepe halaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Epalati yia꞉tapo yú yilo Moses yu balemyemama epo atlamyaiyo, “Wa꞉ di yú hamine,” demyaiyo. Epapalati asiyama Mosestapo yia꞉ watle epo atlaiyo, “Wua꞉ adipalati na꞉ dla yu balemha꞉ha꞉mama Godta itiyamale dla pomikadepe dlalo ha꞉ha꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Amasiyama opatapo yú sikemte teta꞉lati Moses yu balemama epo atlamyaiyo, “Wa꞉ta dia꞉ye Isip mo tle alikili a꞉ma eleme woyamuwaye ipo yú teta꞉le koko tle dia꞉ mate epo di yimlala mate epame di aliya halo mate pallipo depo apuwa?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Epalati Mosestapo God watle otele yu himimama epo atlaiyo, “Na꞉ opa iwolo dla apa koko hapa꞉? Adipalati, yia꞉tapo na꞉ye ewala mate kelepame yumula yakomapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Epalati Godtapo asiyama Moses watle epo atlaiyo, “Wa꞉ tatle opa mila꞉pi tle tamama Isalael dokopala so opa opiye eleme tane. Epo tamama wa꞉ta Nael aloma dla heyuwa dali ku mate hamtane. ");
INSERT INTO xla_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Epedeme na꞉ tatle tame Sainai tamali dla ewala dla wa꞉ ompollowepo. Epalati wa꞉ta alotle puame wa꞉ dali ku mate ewala edla heyulati yútapo alowamelepe. Epalati opatapo edla yú dlomelepe,” diyo. Epapeleye Mosestapo Godta atlamale yu dolumama dokopala so opa opi me-omha꞉ha꞉lati koko eye haiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Epame mo eye semama Masa epo Meliba diyo. Adipalati, Isalael sotapo Moses yu balemyemama epo atlamyaiyo, “Godye ikadepe dia꞉ mate halema꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Epedeme Isalael soye Lepidim mo dla kimtipo ha꞉ha꞉lati Amalek sota puame kotlomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Epalati Mosestapo Yosuwa watle epo atlaiyo, “Wa꞉ iyela opa opi elepame Amalek so mate tame nalatimane. Epalati na꞉tapo tamali di dla hetame God ya꞉ dali ku hame hallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Epalati Yosuwatapo Mosesta atlamale yu dolumama ya꞉ opa elepame Amalek so mate nalatimolowedeme ma-tlati asiyama Mosestapo A꞉lon mate epo oplami hale Hul mate tamali di dla hetamalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Epapele dulu dla Mosestapo do di dla ta꞉ta꞉depo hallati Isalael sotapo sikemte itiyamale mate nalatimha꞉ha꞉iyo. Amasiyama Mosestapo ma ya꞉ do isili a꞉ma hahaliyomtullati asiyama Amalek sota sikemte itiyamale mate nalatimha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Epapele dulu dla Mosestapo ya꞉ do ta꞉ta꞉depo halaleye do mo-popalilati A꞉lon mate epo Hul mate ewala hampuame pamelepame Mosesye di edla polane diyo. Epame Mosesta ewala di edla pollati A꞉lontapo do seme dla hama epo Hulta do seme dla hama depame ta꞉ta꞉depo ha꞉ha꞉lati sali mo-tulumtaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Epapele tle Yosuwatapo ya꞉ opa mate Amalek soye kotlomama potimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Epalati Godta Moses watle epo atlaiyo, “Opatapo wua꞉ta Amalek so mate nalatimhala koko iye welilala depame buka dla ilimane. Epame Yosuwa watle sesa꞉po ine. Adipalati, na꞉tapo Amalek so hapulomaye mosukulu potipo polollowepo. Epalati opata yia꞉ kokoye mosukulu wellipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Epammama Mosestapo God dla alinepi poyupo ha꞉lalo tile hapame ya꞉ hi semama, “Na꞉ta opahale dele dulu dla Godta na꞉ gadlalo halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“Adipalati, na꞉tapo na꞉ doye God dla ta꞉ta꞉depo hallati ya꞉tapo na꞉ye gadlepo. Epapedeme wata oloma itle tamama Godtapo Amalek so mate kokó mepo opahale demhallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","4","Epapele dulu dla Mosestapo ka꞉yapa mo-powataliya ya꞉llu Sipola mate epo ya꞉ akimlala dapiyamte mate ya꞉ doko Yetlo hala dla taiya diyo. Moses yami ka꞉yapa itapu hamale hiye Gesom diyo. Adipalati, Mosesta epo atlaiyo, na꞉ye mo hema asepe puwapo. Epame yami hale hiye Eliyesel diyo. Adipalati, Mosesta epo atlaiyo, “Na꞉ a ya꞉ Godta na꞉ gademama Pelota siyaladle tle alikili a꞉ma seme woyamuwapo,” diyo. Epeleye Moses ya꞉ doko Yetlo iye Midiya mo dla alinepi poyupo God dla hapilalo oplami halaiyo. Epapeleye ya꞉tapo Godta Moses mate epo Isalael so mate dla gademama yia꞉ye eleme Isip mo tle alikili dla woyamale kokoye dalepame natila puaiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Epedeme ya꞉ pumama ya꞉ doko Moses watle yu hamimama epo atlaiyo, “Na꞉ wa꞉ allu mate epame wa꞉ akimlala dapiyamte mate eleme wa꞉ natila puma,” diyo. Epammama yia꞉tapo Moses mate epo Isalael so mate ala dalupa dulu dla God ya꞉ tamali mateka꞉pi dla kimpo popa꞉lati edla puame woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Epalati Mosesta ya꞉ dokota pula natipame ya꞉ dla tame heodepame ya꞉ye hamame huliyo. Epame namkale dle yu atlepame yia꞉ye ya꞉ kimna꞉ya dla elemtuwaiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Epame Mosestapo ya꞉ doko watle Godta Isalael so yilo Pelo dla epo Isip so dla koko halomhalale hapulomaye esemaiyo. Epame yia꞉tapo Isip mo tle alikili dla woyapo pumama pasakalo kokalle dulu dla pulati Godta yia꞉ gademhalale mape esemaiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","10","Epapeleye ya꞉ doko Yetlotapo yu i dalepame siyemama epo atlaiyo, “God hi di dla ta꞉diya! Adipalati, ya꞉tapo wua꞉ye Pelo mate epame ya꞉ opa mate yia꞉ do dulu tle eleme alikili a꞉ma woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Epapedeme na꞉ wata malama, wua꞉ Godtapo god hapulomaye tla꞉mtame halapo. Adipalati, ya꞉tapo Isalael soye Isip sota itiyamale tle elepame alikili dla woyamuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Epammama ya꞉tapo alinepi poyupo God watle hamimama namkale dle alisisi opi mate halopi-iyo. Epalati A꞉lon mate epo Isalael so dokopala so opa opi mate yimkata puame ya꞉ mate God mila꞉pi tle popa꞉mama daya deiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Epame Mosesta utulalati sila꞉time opa koko gladlowedeme ya꞉ta pollalo dla pollati Isalael sota ya꞉ hala dla pumhalaiyo. Adipalati, yia꞉ solotamaiyo, yia꞉ dulu dla yu topulolle koko mate epame upiyele koko mate hutiyemyaye Mosesta ka꞉depo gladlepo depame. Epammama opatapo utulalati kotiyapame Moses hala dla ta demha꞉ha꞉mama tamila꞉la dla tame gudemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yia꞉ta epammha꞉ha꞉lati Moses ya꞉ doko Yetlota koko i natipame ya꞉ watle epo atlaiyo, “Wa꞉ opa hapuloma iwolo natine. Yia꞉ alila hapuloma wa꞉ dla puame alupo koko gladlowedeme utulalati kotiyapo tame tamila꞉la dla gude demha꞉ha꞉po. Epapedeme wa꞉ adipalati mowolo koko iye hamhalema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","Amasiyama Mosestapo ya꞉ watle epo atlaiyo, “Opatapo yia꞉ dulu dla yu topulolle koko mate epo upiyele koko mate hutiyelati Godta solotamale koko dlallepo depame gadle yilo na꞉ hala dla pumulumama ammdepo. Epalati na꞉tapo yia꞉ kokoye gladepame yia꞉ watle God ya꞉ aiyalma kokoye imdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Amasiyama Moses ya꞉ dokotapo epo atlaiyo, “Wa꞉ koko iye woloma ka꞉dle api tle po-ammhalasema. ");
INSERT INTO xla_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Adipalati, wa꞉ mate epame opa wa꞉ natilowa depo pumhalale so mateye sikemte susukalemama hohopeyalimelepe. Ame adipalati, oko eye pta pato, oplami hatlota haloweye po-ala꞉na. ");
INSERT INTO xla_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","20","Epedeme na꞉tapo wa꞉ye woloma molo atlati Godtapo wa꞉ mate hallepe. Epapele dulu dla wa꞉tapo opa yilo God mate yukamhalaye pta ka꞉pi, epame wa꞉tapo yia꞉ watle God ya꞉ aiyalma dolumha꞉ha꞉mama woloma ka꞉depo ha꞉ha꞉lowe koko imhalaye e ma pta ka꞉pi. ");
INSERT INTO xla_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Amasiyama wa꞉ opa opiye huhulumane, yia꞉tapo wa꞉ta opa koko glademhala oko ipiye yia꞉ta halepo depame. Epapele dulu dla wa꞉ opa ewolo hohomama woloma God wowota꞉lalo so tlo hohomelepe. Epame mani yilo yimkadulo koko gladlowa depo malamalalo soye pohohomolowa. Amasiyama woloma ikadepe koko halomalalo so tlo huhulupame hohomelepe. Epame alumale meyelope meyelope dle dla ipila꞉mtamama opitapo 10 opa epapele omha꞉ha꞉, epame opa opitapo 50 opa epapele omha꞉ha꞉, epame opitapo 100 opa epapele omha꞉ha꞉, epame opitapo 1,000 opa epapele omha꞉ha꞉demtelepe. ");
INSERT INTO xla_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Epapedeme opa iwolotapo koko gladlalo so ha꞉ha꞉lepe. Amasiyama koko patoto tlope wa꞉ hala dla gladlowedeme pua demha꞉ha꞉lepe. Epapele koko tle yia꞉tapo wa꞉ oko ipiye gademha꞉ha꞉lati wa꞉tapo posukallowa. ");
INSERT INTO xla_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Epapedeme koko iye Godta solotamale kokopo. Epapele dulu dla wa꞉ta koko i hamhallepiye, eta wa꞉ posukallowa. Epalati opatapo yia꞉ kokoye ka꞉depo gladla natipame sisiyele mate ma ilamtademha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Epalati Mosestapo ya꞉ dokota molo atlale yu dalepame koko eye ka꞉dena demama me-haiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Epammama ya꞉tapo alumale meyelope meyelope dle omha꞉ha꞉mtlowe opa ka꞉ka꞉dle hohomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Epame yia꞉tapo opa koko glademha꞉ha꞉mdiyo. Amasiyama isikimi koko patoto tlo Moses hala dla halopo pumdiyo. ");
INSERT INTO xla_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Epapele dulu dla koko ita tame gudlati Moses ya꞉ dokotapo ya꞉ saliyome ma me-ya꞉ mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Epedeme Isalael sota Lepidim mo dla kimtipo ha꞉ha꞉po ma tamalaiyo. Epele dulu dla yia꞉tapo Isip mo tle alikili a꞉ma woyapo tamalemama mama dapiyamte pololepame Sainai dalupa dulu dla puame woyapame Sainai tamali kikiwi isili dla kimtimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Epame Mosestapo Sainai tamali di dla hetlati Godtapo ya꞉ sisilamama epo atlaiyo, “Wa꞉ Isalael so watle yu iye atlamane. ");
INSERT INTO xla_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Yia꞉tapo na꞉ta Isip so dla koko halomuwaye ma-tlamuwapo. Epame na꞉tapo yia꞉ye Isip mo tle alikili a꞉ma eleme woyapo na꞉ta hala mo hema elempumama kepilitapo ya꞉ yemala suku dla pamelepo hollomtamdiye, epapele some puwaye yia꞉ me-natiwapo. ");
INSERT INTO xla_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Epapedeme yia꞉tapo na꞉ yu dalepame salladepo dolumsiyamelepiye, eta yia꞉ye ikadepe na꞉ opa dlepe. Epapele dulu dla ta꞉lamo so hapulomaye nolëpo. Amasiyama hatlo yia꞉ tlope ikadepe na꞉ta sesalemale sopo. ");
INSERT INTO xla_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Epedeme yia꞉tapo na꞉ ka꞉ epo ta꞉lamo so opa hapuloma ka꞉ duka dla ha꞉ha꞉lalo so depo ha꞉ha꞉lepe. Epedeme wa꞉tapo yu iye Isalael so watle atlamane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mosestapo Godta ya꞉ watle atlamale koko hapuloma eye dalepame tulume ma Isalael so dokopala so sisilapame yia꞉ watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Epalati asiyama opa hapulomatapo yu e dalepame epo atlamyaiyo, “Di Godta atlamale koko hapuloma eye halomolowepo,” demyaiyo. Epalati Mosestapo yia꞉ta atlamale yu asiyamaye ma God dla hamila hetaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Epame ya꞉tapo opata atlamale yuye God watle atlapo gudlati asiyama Godtapo ya꞉ watle epo atlaiyo, “Na꞉tapo wuala deiyamale dulu tle wa꞉ hala dla puluwepo. Epame na꞉tapo wuala deiyamale dulu etle wa꞉ mate yukamhallati opatapo e dalepame wa꞉ye ikadepe na꞉ yu molo atlalo oplami tepo dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Epame Godta ma Moses watle epo atlaiyo, “Wa꞉ opa watle tame yu iye atlamane. Yia꞉tapo na꞉ mateka꞉pi dla puluwedeme wata alila mate epame iyela mate woloma ka꞉pi dinapomama yia꞉ kapala alisisi mape woloma ka꞉pi howahalomelepo. ");
INSERT INTO xla_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Adipalati, iyela popa꞉po alallati na꞉tapo opa hapulomata natilipo depame Sainai tamali di dla mollowepo. ");
INSERT INTO xla_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","Epedeme opata siyamama tamali kikiwi isili ikadepe edla pumullala depame sukulu himine. Adipalati, oplami antapo epame alinepi aditapo holomsela꞉mama sukulu himili eye me-tla꞉mtame tamali umulupiye, ya꞉ye ewala mate kelepo yumilipe o tota suma꞉himilipe. Epapele dulu dla oplami haletapo epo yumili oplami motoye po-umuluwa. Amasiyama hulutapo sisilamelepiye, eta opatapo sukulu himili edla puame alumelepe.” ");
INSERT INTO xla_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Epame Mosestapo ma ilame tulume Godta atlamale kokoye opa watle atlamaiyo. Epalati yia꞉tapo yu e dalepame woloma dinapomama yia꞉ kapala alisisiye woloma ka꞉pi howahalomaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Epame Mosesta yia꞉ watle ma epo atlaiyo, “Wua꞉ Godta dia꞉ dla mollowe alila dla dinapomama wua꞉ wola꞉ kapala po-umamolowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Epame Godta mollowe alila utulalati dla omapla halë mate epo hela꞉hela꞉dle mate hamama wuala deiyamaletapo tamali aloweli di dla bopudepo halaiyo. Epalati hulu yutapo sikemte palimhallati opa hapuloma kimna꞉ya dla popa꞉letapo sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Epame Mosestapo opaye eleme tamali kikiwi isili dla God hala dla tamalaiyo. Yia꞉ tame tamali kikiwi isili sukulu himili dla ha꞉ha꞉mama omha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Epalati Godtapo dlapa dulu tle Sainai tamali di edla mallati tamali eye namiletapo sikemte haiyo. Namileta epo sikemte bulamhetamhallati allu tuwale patota tuwaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Epapele dulu dla hulu yutapo ala pokeillalo me-hallati Mosestapo God watle yukamaiyo. Epalati Godtapo omapla halë dulu tle ya꞉ watle asiyama yu atlaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Epapedeme Godtapo Sainai tamali di dla malame halemama Moses sisilamama epo atlaiyo, “Wa꞉ tamali di hema matane,” diyo. Epalati Mosestapo tamali di dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Epapalati Godtapo ya꞉ watle epo atlaiyo, “Wa꞉ tulume opaye yu itiyamale mate atlamane, yia꞉tapo sukulu himili eye tla꞉me na꞉ta hala hema pulala depame. Adipalati, yia꞉ta epapelepiye, yia꞉ pallipe. ");
INSERT INTO xla_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Epame na꞉ dla alinepi poyupo hapilalo so mape sukulu himili i tla꞉mpulupiye yia꞉ ma pallipe. Epapalala depame yia꞉ mape yu hatlo me-dolumama aiyalma depo ha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Amasiyama Mosestapo God watle epo atlaiyo, “Opatapo tamali dla kulume populuwa. Adipalati, na꞉tapo wa꞉ta atlamale koko e dolumama tamali dla tla aiyalma depame sukulu me-himiwapo. Ame adipalati, tamali iye aiyalmapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Epalati Godta Moses watle epo atlaiyo, “Wa꞉ tulume A꞉lonye hema seme matane. Amasiyama wa꞉ opa opi mate epame na꞉ dla alinepi poyupo hapilalo so mateye sukulu himili tla꞉me hema mata demiya. Yia꞉ta epapelepiye, na꞉tapo yia꞉ potimolowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Epapedeme Mosestapo ma ilame tulume opa watle Godta atlamale kokoye atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Epame Godtapo epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Na꞉ye wa꞉ Lod Godpo. Na꞉tapo wa꞉ta Isip mo dla asiyama pa꞉le oko pato hamhallati seme alikili a꞉ma woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Epedeme wa꞉ Godye hatlo na꞉ta halapo. Wa꞉ god hale dla pomikadepe dlowa. ");
INSERT INTO xla_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Epame biskapa godye dlopi dota mita꞉pmiyo. Epedeme wa꞉ pepele di dla ha꞉ha꞉lalo mila꞉pi mate epo ta꞉lamo dla ha꞉ha꞉lalo mila꞉pi mate epo yú dulu dla ha꞉ha꞉lalo mila꞉pi mate dla tlapame wa꞉ dota dlopi mimita꞉pame edla heodepo siyemama wa꞉ god demhalemiya. ");
INSERT INTO xla_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Adipalati, na꞉tapo wa꞉ta epammhallati wa꞉ yilo siyaladle mate hahamhalapo. Epapele dulu dla oplami antapo na꞉ye alimhallepiye, asiyama na꞉tapo ya꞉ mate epo ya꞉ yimlala mate epo ya꞉ mamadulo mate dla ya꞉ batalimale asiyama hamilowepo. ");
INSERT INTO xla_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Amasiyama oplami antapo na꞉ye sikemte malahalemama na꞉ yu dla dalepame salladepo sela꞉lepiye, asiyama na꞉tapo ya꞉ mate epo ya꞉ mamadulo alotle ha꞉ha꞉mpuluwe so dla na꞉ta bokotiyapo malamale patoye yia꞉ dla himhallowepo. ");
INSERT INTO xla_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Epedeme wa꞉ Lod God hiye isikimi posolowa. Adipalati, na꞉tapo epapalalo oplami dla wotiyalle hamilipe. ");
INSERT INTO xla_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Epame wa꞉ta inoma sumalalo alilaye woloma aiyalma depo halane. ");
INSERT INTO xla_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Adipalati, wa꞉ dla alila 6 me-hutiyepo, wa꞉tapo alila edla wa꞉ta solotamale oko halomoloweye. ");
INSERT INTO xla_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Amasiyama 7 alila dla oko hala aiyalmapo. Adipalati, alila eye na꞉ hi di dla ta꞉demha꞉ha꞉mama na꞉ dla inoma sumha꞉ha꞉lowe alilapo. Epapele dulu dla alila oloma edla wa꞉ mate epo wa꞉ yimlala mate epame wa꞉ oko so mate epame wa꞉ aliya matetapo oko pohalomha꞉ha꞉lowa. Epame asepe so wa꞉ mate ha꞉ha꞉ mape oko pohalomha꞉ha꞉lowa. ");
INSERT INTO xla_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Adipalati, alila 6 dulu dla na꞉ta omapla mate epo ta꞉lamo mate epo kaula mate epame dulu edla ha꞉ha꞉lalo alisisi hapulomaye mimita꞉puwapo. Epame 7 alila dla na꞉ta hedepo poluwapo. Epapele koko tle na꞉ta 7 alila iye aiyalma duwapo. ");
INSERT INTO xla_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Epame wa꞉ a yu mate epo wa꞉ wai yu mate dla heodepo salladepo sela꞉ne. Wa꞉ta epapelepiye, etapo na꞉ta wa꞉ watle ta꞉la hami hema kokó hallepe. ");
INSERT INTO xla_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Epame ya꞉mkale yumula aiyalma. ");
INSERT INTO xla_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Epame upo opa mate epo upo wola꞉ mate uhala aiyalma. ");
INSERT INTO xla_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Epame ya꞉mkale alisisi uhala aiyalma. ");
INSERT INTO xla_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Epame ya꞉mkale hi mate isikimi mala-atla aiyalma. ");
INSERT INTO xla_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Epame ya꞉mkale alisisi natipame etlo na꞉ta꞉ halowo depame solotamale himila aiyalma. Epapele dulu dla ya꞉mkale aya mate epo ya꞉mkale ya꞉llu mate epo ya꞉ oko so mate epo ya꞉ halo mate epo ya꞉ alisisi hapuloma mateye na꞉ta halomolowo depame solotamale himila aiyalma.” ");
INSERT INTO xla_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Epalati opatapo omapla yu mate epo hulu yu mate dalemama omaplata hela꞉hela꞉dle mate epo namile patota tamali di dla bulamhetamhallati natiyo. Epalati yia꞉tapo sikemte wowota꞉le mate eseselalalimama pateka꞉mu tle omha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Epammama yia꞉tapo Moses watle epo atlamyaiyo, “Wa꞉tapo dia꞉ dla yukapo ilipiye, eta di dallowepo. Amasiyama Godta dia꞉ dla yukapo ilipiye dia꞉ palliwe sepena,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Epalati asiyama Mosesta yia꞉ watle epo atlaiyo, “Ase sikemte wowota꞉miya. Godtapo ya꞉ta itiyamale nati-iliwedeme ipapele api tle dia꞉ dla mo-malalepo. Epapedeme wowota꞉le mate ya꞉ yu dla salladepo siyamama batalimale koko halomiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Amasiyama opatapo ala me-pateka꞉mu dla ha꞉ha꞉lati Mosesta meyelope namile amtuwale dulu dla God mateka꞉pi dla kulume hetaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Epame ma Mosesta tamali di dla hetame ma ilame hapele pomallalo wekelati Isalael sotapo A꞉lon hala dla puame alupame ya꞉ watle epo atlaiyo, “Di Isip mo tle hema elempuwa Mosesye hapele popuasema. Di podimalamana ya꞉ye hadima tauwo? Epedeme wa꞉ di elemtlowe godye dota mita꞉pene,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Epalati A꞉lontapo yia꞉ watle epo atlaiyo, “Wua꞉ wola꞉ mate epo wua꞉ akimlala mate epame wua꞉ utukaka mateta gold sutulu molo dla didiyepo siyamaye na꞉ watle uptipo halopiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Epapalati yia꞉ta hapulomatapo yia꞉ gold sutulu uptipame A꞉lon watle halopimyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Epalati ya꞉tapo eye halopame dlapa dla holopo potollati bulumkiyawa aliya mila꞉pi sepeleye mita꞉piyo. Epame opatapo i natipame epo atlamyaiyo, “Isalael so, iye di godpo. God itapo dia꞉ye Isip mo tle eleme alikili a꞉ma woyamuwapo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Epalati A꞉lonta yu i dalepame God dla alinepi poyupo ha꞉lalo tileye bulumkiyawa aliya ya꞉ta mita꞉pele mateka꞉pi dla hapame epo atlaiyo, “Iyela God hi di dla ta꞉demama daya pato dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Epapeleye utulala ikadepe dla opatapo aliya haloye poyupo dlopi dota mita꞉pele god dla hapimama halomha꞉ha꞉iyo. Epame yia꞉tapo daya pato demama kawata yúye sikemte dlopame siyalemyemama wola꞉ mate epo opa mate uhalomyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Epapele oloma dla Mosestapo tamali di dla ala me-hallati Godtapo opata koko halomha꞉ha꞉ natipame ya꞉ watle epo atlaiyo, “Wa꞉ ma ilame tulune. Adipalati, opa wa꞉ta eleme Isip mo tle alikili a꞉ma woyamuwaye batalimale koko pato halomha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Epedeme na꞉tapo yia꞉ watle molo atluwa yuye ma-hamastana. Epame yia꞉tapo biskapa god dlopi dota mita꞉pele bulumkiyawa mila꞉pi sepeleye mita꞉pame edla sisiyemha꞉ha꞉po. Epame yia꞉tapo alinepi poyupo ya꞉ watle hapimha꞉ha꞉mama epo atlamha꞉ha꞉po, ‘Isalael so, iye di godpo. Ya꞉tapo dia꞉ye Isip mo tle eleme alikili a꞉ma woyamuwapo,’ demyapo. ");
INSERT INTO xla_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Epedeme na꞉ iwolota dupa kokalalimale kokoye ma-natima. ");
INSERT INTO xla_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Epedeme na꞉ yia꞉ dla sikemte siyalademama yia꞉ye hapuloma poyupa꞉mollowama. Epapele dulu dla wa꞉ na꞉ apiye pohimomollowa. Amasiyama Moses, hatlo wa꞉ tle na꞉tapo na꞉ opaye ma pasatlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Amasiyama Godta malamale meyelope dlepo depame Mosestapo ya꞉ dla otele pato himimama epo atlaiyo, “God, wa꞉ta itiyamaletapo opa iwoloye Isip mo tle eleme alikili a꞉ma woyamuwapo. Epapedeme wa꞉ta siyaladleta yia꞉ye potimiya. ");
INSERT INTO xla_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Wa꞉ta yia꞉ye potimelepiye, asiyama Isip sotapo epo malamelepe, ‘Godta ya꞉ opaye isikimi potimolowedeme Isip mo itle eleme alikili a꞉ma woyamana,’ dlepe. Epapedeme wa꞉ta siyalademama yia꞉ye potimele dleye memelene. ");
INSERT INTO xla_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Adipalati, wa꞉tapo di mamadulo A꞉iblaham mate epo Aisek mate epo Yokob mate dla yu itiyapo himiwa kokoye e malamane. Ame adipalati, wa꞉tapo yia꞉ watle epo atluwapo, yia꞉ mamadulotapo sikemte pasatamama tamili some hallepe. Epame wa꞉ta yia꞉ watle hamili duwa moye yia꞉ta halepe duwapo. Epame ta꞉la itapo yia꞉ hi mate kokó mepo ellepe duwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Epalati Godtapo Moses yu dalepo ya꞉ta malamaleye meyelope depame yia꞉ye popotimalalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Epame Mosestapo tamali di tle Godta ewala dapiyamte dla aiyalma 10ye seme mate seme mate hatitipo halopiliye halopo tuluiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Moses ala tulumhallati ya꞉ gadlalo oplami Yosuwata api duka dla ala me-ompolomama dallati opata siyalle yu daliyo. Epame Moses watle epo atlaiyo, “Na꞉ opahaleta di opaye hustepo kotlomale yuye dalesema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Amasiyama Mosesta ya꞉ watle asiyama epo atlaiyo, “Hao, opahale sota kotlomale yu epapele podalesema. Amasiyama siyalemama sala sale yu tlo dalema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Epedeme Mosesta kimna꞉ya dla tulume natilati biskapa god dota mita꞉pele bulumkiyawa aliya mila꞉pi sepele mate epo opata siyalle koko mate natipame sikemte siyaladiyo. Epammama ya꞉tapo ewala dapiyamteye medla pololemama susupolatalemaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Epo halemama biskapa god dlopi dota mita꞉peleye dlapa dla mistaiyo. Epame sikemte potolumama sokane some hallati yú dla kustaiyo. Epame yú eye Isalael so watle dlomaiya diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Epo A꞉lon dla helestame halemama epo atlaiyo, “Opa iwolotapo wa꞉ dla apa koko halati asiyama wa꞉tapo yia꞉ye batalimale koko pato hema elemtuluwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Epalati A꞉lonta asiyama Moses watle epo atlaiyo, “Wa꞉ ase na꞉ mate sikemte siyalademiya. Adipalati, opa iwolo kokoye mo-wa꞉malamana. Yia꞉ye alila hapuloma batalimale koko halomolowe dla ma-dinapopo siyamdepo. ");
INSERT INTO xla_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Epapedeme yia꞉tapo puame na꞉ watle epo atlemama dia꞉ye Isip mo tle alikili dla eleme woyamuwa Mosesye hadima tauwa? Epedeme wa꞉ di elemtlowe godye dota mita꞉pene, duwapo. ");
INSERT INTO xla_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Epalati na꞉tapo yia꞉ yu dalepame yia꞉ watle atlemama wua꞉ gold sutulu uptipame na꞉ watle halopo puaiya duwapo. Epame yia꞉tapo alisisi eye mo-halopo pulati na꞉tapo e halopame dlapa alemalle dla potolupo depame bulumkiyawa aliya mila꞉pi sepele iye mita꞉puwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","26","Epapele dulu dla Mosestapo A꞉lonta opa batalipo eleme tale koko tle opahale sota yia꞉ natipo eimela꞉lala depo malapame kimna꞉yata popa꞉mtame gudle dla halemama yu teta꞉le mate yia꞉ watle epo atlaiyo, “Opa anawolotapo God tiyama dla ha꞉ha꞉lepiye, na꞉ta hala dla pumulaiya,” diyo. Epalati Libai elele halomale sotapo ya꞉ hala dla pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Epalati ya꞉tapo yia꞉ watle epo atlaiyo, “Isalael so di Lod Godtapo epo atlema, ‘Wua꞉ aipa꞉ya halopame kimna꞉ya dulu dla siyamama mo-wua꞉ amkadulo mate epame mo-wua꞉ asiyadulo mate potimtamalaiya,’” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Epalati yia꞉tapo Moses yu dalepame kimna꞉ya dulu dla siyamama 3000 opaye potimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Epame Mosestapo Libai elele halomale so watle epo atlaiyo, “Wua꞉tapo God yu dalepo salladepame mo-wua꞉ amkadulo mate epo mo-wua꞉ asiyadulo mate potimolowe dla wowota꞉mama po-alina. Epapele koko tle wua꞉tapo Isalael so dulu dla God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo so depo ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Epame ma alallati Mosesta opa watle epo atlaiyo, “Wua꞉tapo batalimale pato ma-halomalepo. Epapedeme na꞉ ma ilame tamali di dla wua꞉ bobtalimale yilo God mate yukamama otele himila hetlowepo. Adipalati, pona꞉malamana, ya꞉tapo wua꞉ bobtalimaleye hiyollowe sepena,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Epammama Mosestapo ma ilame hetame God watle epo atlaiyo, “Opata batalimale koko pato hamama yia꞉skamu biskapa god dlopi dota mita꞉pame edla sisiyemha꞉ha꞉uwapo. ");
INSERT INTO xla_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Epapedeme na꞉ wa꞉ dla otele pato himima, wa꞉tapo yia꞉ bobtalimaleye hiyolepo wellipo depame. Amasiyama wa꞉tapo yia꞉ bobtalimale hiyollowe allipiye, asiyama na꞉ hi wa꞉ buka dulu dla elaye e tlo hiyostane,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Epalati Godta asiyama Moses watle epo atlaiyo, “Opa anawolotapo na꞉ dla batalimale koko mo-halomuwa, opa ewolo hi tlope na꞉tapo na꞉ buka tle hiyotimolowepo. ");
INSERT INTO xla_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Epapedeme na꞉ta wua꞉ watle hamilowepo depo yu itiyapo himiwa mo dla wa꞉ opa eleme ma-tane. Epalati na꞉ banakaka oplamitapo wua꞉ta tlati itapu tle telepe. Epapele dulu dla na꞉tapo yia꞉ watle yia꞉ bobtalimale asiyama hamilowe alilata woyamalati yia꞉ watle yia꞉ bobtalimale asiyamaye hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Epammama opatapo A꞉lonta biskapa god mita꞉pele dla mikadepe depo edla sisiyemha꞉ha꞉le koko tle Godtapo yia꞉ batalimale asiyama dla esiyele pato hamiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Godta ma Moses watle epo atlaiyo, “Wa꞉ta Isip mo tle elempuwa opa mate mo i saliyome na꞉ta꞉ mo-powataliya wua꞉ watle hamili duwa mo dla tane. Adipalati, na꞉tapo A꞉iblaham mate epo Aisek mate epo Yokob mate dla yu itiyapo himmama mo eye yia꞉ mamadulo watle hamili duwapo. ");
INSERT INTO xla_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","5","Mo eye pta ka꞉pi, dlowe alisisiye pta wokasemana. Wua꞉ta tlati na꞉tapo na꞉ banakaka oplamiye wua꞉ mate tane dlowepo, ya꞉tapo wua꞉ mate halemama Keinan so mate epo Amoli so mate epo Hitai so mate epo Pelisi so mate epo Hibai so mate epo Yebusi so mateye alikili a꞉ma posallepe. Amasiyama Isalael soye na꞉ yu dolumolowe dla pta dupa kokalalimale sopo. Epapedeme na꞉ta yia꞉ mate potlowa. Adipalati, na꞉tapo yia꞉ta duka dla tamalemama dupa kokalalimale koko natipame yia꞉ potimalala. Epapedeme watapo yia꞉ta yia꞉skamu yia꞉ moto dla goldta mimita꞉pele alisisi mate dinapele kokoye medla uptimelepe. Epalati na꞉tapo yia꞉ dla halowe kokoye alotle atlowepo,” diyo. Epalati opatapo Godta atlale yu i dalepame sikemte dupa kolle mate a꞉lemyemama yia꞉tapo goldta mimita꞉pele alisisi didiyepo ha꞉ha꞉leye medla uptimyaiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Epapele koko tle Isalael sotapo Sainai tamali kikiwi isili dla gold alisisi matle didiyepo siyamoloweye mosukulu medla memeliyo. ");
INSERT INTO xla_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Isalael sota kimtimale alikili tle Mosestapo kimna꞉ya hale hapame semama God mate yukamalalo kimna꞉ya demdiyo. Opatapo God tle yu dallowe solotamama kimna꞉ya edla tamdiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Amasiyama Mosestapo God mate yukamalalo kimna꞉ya edla tlati opatapo yia꞉ kimna꞉ya tle sillipame kokoloma tle omha꞉ha꞉lati Mosesta kimna꞉ya dulu dla tumdiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mosestapo kimna꞉ya dulu dla mo-tulati wuala deiyamaletapo kokoloma tala dla malame bodepo halemdiyo. Epalati Godtapo Moses mate yukamhalemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Epalati opata wualata mo-malla natipame yia꞉ kimna꞉ya kokoloma tala dla ha꞉ha꞉mama God dla heoheodemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Godtapo Moses mate yukamhalemama oplamita ya꞉mkale mate mila꞉pi hatlo atumapo yukamhalemdiye, epammhalemdiyo. Mosestapo God mate yukamhallepo gudepame ilame tlati asiyama ya꞉ gadlalo kipiliyemala Nun yami Yosuwa tlope God mate yukamalalo kimna꞉yaye posaliyome tasemdiyo. ");
INSERT INTO xla_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosestapo God watle epo atlaiyo, “Wa꞉ta na꞉ watle atlemama opa iwoloye elemtane demhalapo. Amasiyama wa꞉ ala na꞉ gadepo tlowe oplamiye ponati-isema. Epame wa꞉tapo na꞉ natipo siyemama na꞉ye wa꞉mkale ikadepe demdepo. ");
INSERT INTO xla_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Amasiyama wa꞉ta ikadepe na꞉ dla siyemhalema dlepiye, na꞉ watle wa꞉ta malamale kokoye imane. Epalati asiyama na꞉tapo wa꞉ yu dla salladepo sela꞉lati wa꞉ta natipame siyemhala kokota me-ellepe. Epele dulu dla wa꞉ malamane, opa iwoloye wa꞉ta sesalemale sopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Epalati Godta Moses watle epo atlaiyo, “Hawa, na꞉ta wa꞉ gademama wa꞉ mate tlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Epalati Mosesta epo atlaiyo, “Wa꞉ta ikadepe dia꞉ mate potlalo wekeli dlepiye, dia꞉ye wa꞉ta sale mo edla taiya demiya. ");
INSERT INTO xla_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Amasiyama wa꞉ta dia꞉ mate telepiye, eta mo opi sotapo wa꞉ta ikadepe dia꞉ dla siyemhalemama dia꞉ mate hala kokoye malamelepe. Epame yia꞉tapo dia꞉ye ikadepe wa꞉ta sesalemale so opa mleni dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Epalati Godta Moses watle epo atlaiyo, “Na꞉tapo wa꞉ta solotamale koko halowepo. Adipalati, wa꞉ye namkale ikadepepo. Epedeme na꞉ wa꞉ dla siyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Epalati Mosesta God watle epo atlaiyo, “Na꞉ wa꞉ta hela꞉dle mila꞉pi ikadepe natilowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Epalati Godtapo Moses watle epo atlaiyo, “Na꞉ye Godpo. Epedeme na꞉tapo na꞉ta꞉ sesalemale so dla polowamale koko mate epo bokotiyapo malamale koko mate nati-imdepo. Epapedeme na꞉tapo wa꞉ watle na꞉ta hela꞉dle nati-imama na꞉ hi ma atlowepo. ");
INSERT INTO xla_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Amasiyama wa꞉ na꞉ mila꞉pi ikadepe tlo ponatilowa. Adipalati, na꞉ mila꞉pi ikadepe natilalo oplamiye polope,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Epame matle epo atlaiyo, “Na꞉ mateka꞉pi dla teiko halaye wa꞉ edla hetame halane. ");
INSERT INTO xla_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Epalati na꞉ta hela꞉dle mate wa꞉ hala dla pumama na꞉ do mate wa꞉ye kukomama teiko dulu dla hemele hatiyomellowepo. ");
INSERT INTO xla_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Epame na꞉ta wa꞉ye ma-tla꞉mtamama wa꞉ta isikimi na꞉ ko tlo natilipo depame wa꞉ye ma haliyamale dla pamollowepo. Adipalati, opata na꞉ mila꞉pi ikadepeye natilowe pta aiyalma.” ");
INSERT INTO xla_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Godta Moses watle ma epo atlaiyo, “Na꞉ta ka꞉yapa aiyalma kokoye ewala dapiyamte dla hatitipo hapilati wa꞉ta hauwokokomuwa epapele ewalaye ma amko mimita꞉pene. Epalati ma na꞉tapo aiyalma hatlo meye monolo hatitimolowepo. ");
INSERT INTO xla_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Epapedeme wa꞉ iyela utulalati ewala dapiyamte e halopame Sainai tamali di dla na꞉ hala dla matelepe. ");
INSERT INTO xla_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Epele dulu dla oplami haletapo wa꞉ mate pomatlowa. Epame opa mate alinepi mateta tamali mateka꞉pi dla populuwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Epalati Mosestapo Godta atlale yu e dolumama ewala dapiyamte mimita꞉pame halopo utulalati ikadepe Sainai tamali di dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Epalati Godtapo wuala dulu dla malame Moses mate halemama ya꞉ hi ikadepe semama na꞉ye Godpo diyo. ");
INSERT INTO xla_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Epame ya꞉tapo Mosesye me-hallati tla꞉mtamama epo atlaiyo, “Na꞉ye Godpo. Na꞉ dla polowamale koko mate epo sadle koko mate epo bokotiyapo malamale koko mate hutiyepo. Epapele dulu dla na꞉ na꞉ta yu itiyapo hatitimale hapulomaye pohauwokokomasemde. ");
INSERT INTO xla_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Na꞉ opa hapulomaye bokotiyapo malamama yia꞉ bobtalimaleye hiyotipo welimdepo. Epapele tlope na꞉tapo batalimale walle oplami dla asiyama pohamilalo powekesemde. Epedeme adulo yia꞉ bobtalimale asiyama dla na꞉tapo yia꞉ yimlala dla epo yia꞉ mamadulo dla asiyama wotiyalle hapimdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mosesta alumata ta꞉la dla akukulumpolomama God dla heodepo epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Na꞉ God, wa꞉ta ikadepe na꞉ dla siyemhalema dlepiye, di saliyome tamiya. Na꞉malamana, opa iwoloye wa꞉ yu dolumolowe dla pta dupa kokalalimale so. Amasiyama epapele tlope di bobtalimaleye wa꞉tapo hiyostepo welipame ma wa꞉ opa ikadepe dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Epalati Godta epo atlaiyo, “Na꞉tapo yu itiyapo himma, Isalael sotapo ikadepe na꞉ta sesalemale so depo ha꞉ha꞉loweye. Epapedeme na꞉tapo yia꞉ mila꞉pi tle ulugiyemale koko patoto ta꞉lamo hema pohalalo wekele kokoye halomolowepo. Yia꞉tapo na꞉ta wa꞉ yilo itiyamale pato mate wa꞉ gademhala kokoye natipame yiyellepe. ");
INSERT INTO xla_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Epapedeme na꞉tapo Amoli so mate epo Keinan so mate epo Hitai so mate epo Pelisi so mate epo Hibai so mate epo Yebusi so mateye na꞉ta wua꞉ watle hamilowe mo tle alikili a꞉ma dodolomsallowepo. Amasiyama na꞉ta epapelepo depame wua꞉tapo na꞉ta atla yu hema dolumha꞉ha꞉iya. ");
INSERT INTO xla_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Eye, wua꞉tapo mo edla ha꞉ha꞉lalo so opa mate namkale demha꞉ha꞉miya. Wua꞉ta yia꞉ mate namkale demha꞉ha꞉lepiye, yia꞉tapo wua꞉ye batalimale koko dla elemtullupe. ");
INSERT INTO xla_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Amasiyama wua꞉tapo yia꞉ta alinepi poyupo yia꞉ god dla ha꞉lalo tile hapulomaye dodokotimaiya. Epame yia꞉ aiyalma ewalaye susupolatipame ma yia꞉ aiyalma daliye hauwokokomaiya. ");
INSERT INTO xla_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Epame wua꞉ hatlo na꞉ dla heodemha꞉ha꞉mama god opi dla mikadepe demha꞉ha꞉miya. Adipalati, na꞉tapo wua꞉ yilo hahamalalo God halapo. ");
INSERT INTO xla_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Epedeme wua꞉ wolomape! Mo edla ha꞉ha꞉lalo so opa mate namkale depo ha꞉ha꞉miya. Adipalati, yia꞉tapo wua꞉ye na꞉ tle eleme ma yia꞉ biskapa god dla sisiyemama yia꞉ dla hapili daya ma dlomlala. ");
INSERT INTO xla_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Epedeme wua꞉tapo wua꞉ akimlala dla edla ha꞉ha꞉lalo mo so wola꞉ halopimiya. Adipalati, yia꞉tapo wua꞉ akimlalaye eleme yia꞉ biskapa god dla sisiyelowe dla tullala. ");
INSERT INTO xla_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Epedeme biskapa godye dlopi dota mimita꞉miya. ");
INSERT INTO xla_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Sokomoko hapuloma dulu dla Abib mama umulati alila 7 dulu dla wua꞉ yimkata alupame daya dele demama palawa daya yist mate podukumalalo wekele dlomha꞉ha꞉iya. Adipalati, Abib mama dulu dla alila oloma iye na꞉tapo wua꞉ye Isip mo tle alikili dla eleme woyamuwapo. ");
INSERT INTO xla_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Wua꞉ akimlala itapu hohomale soye na꞉ watle hohopo iya. Epame wua꞉ aliya halo patetalo itapo usulli mape na꞉ watle hohopo iya. ");
INSERT INTO xla_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Amasiyama wa꞉ donki aliya tlo na꞉ watle hamili hallepiye, wa꞉ e tlo ma ilame hammama asiyama sipi aliya amkota꞉le tlo yumpame na꞉ watle hamilipe. Amasiyama epapele dulu dla wa꞉ sipi aliya yumuluwe allipiye, donki aliya tlo tumuku kestlepe. Epapedeme wua꞉ akimlala itapu hohomale na꞉ watle hohopo iliye ma asiyama mate na꞉ tle ilame hohomelepe. Oplami haleta namkale dle alisisi dimi na꞉ hala dla populuwa. ");
INSERT INTO xla_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Alila 6 dulu dla wua꞉ oko dla ha꞉ha꞉lepe. Amasiyama alila 7ye wua꞉ta hedepo popa꞉lowe alilapo. Epele dulu dla wua꞉ dlowe alisisi emolowe alila mate epo hauwallowe alila mate dla alila ita woyamelepiye, aseka mepapele hedlepe. ");
INSERT INTO xla_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Witi dayata ma-namalati hauwalepame yimkata alupo daya pato de demha꞉ha꞉lepe. Epame Kotiyopa alila dla Kimna꞉ya daya dele demama yimkata alupo daya pato de demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Epapedeme sokomoko hatlo dulu dla wua꞉ opa hapulomatapo dapahatlo oloma dla na꞉ mila꞉pi tle hetame alumademha꞉ha꞉lepe. Adipalati, na꞉ye Isalael so wua꞉ Lod Godpo. ");
INSERT INTO xla_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Amasiyama wua꞉ta ta꞉la halowedeme ha꞉ha꞉ mo edla ha꞉ha꞉lalo soye na꞉tapo dodolomsalepame ma ta꞉la eye popolalepo mellowepo. Epalati wua꞉ta mo edla ha꞉ha꞉mama sokomoko hatlo dulu dla alumale dapahatlope i halomha꞉ha꞉lati opa ewolotapo ma ilampuame wua꞉ ta꞉la halowedeme wua꞉ye pokotlomolowa. ");
INSERT INTO xla_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Wua꞉tapo na꞉ watle alinepi poyupo hapimha꞉ha꞉mama wua꞉ yist mate dukumale alisisiye pohapimha꞉ha꞉lowa. Epame wua꞉tapo Namilatale daya dele dla daya pomelleye pohatitimha꞉ha꞉lowa, dlapa dla mistemha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Na꞉ye wua꞉ Lod Godpo. Epedeme wua꞉ta emale alisisitapo ka꞉yapa milimale alisisiye hauwalepame na꞉ aiyalma aya dla halopo pua demha꞉ha꞉lepe. Epame gaut aliya yemalaye ya꞉ya memeko mate hatlo dukupo ha꞉miya.” ");
INSERT INTO xla_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Epame God matle Moses watle epo atlaiyo, “Yu iye buka dla hatitimane. Adipalati, na꞉tapo wa꞉ dla epo Isalael so dla yu itiyapo himiwa ya꞉ asiyamaye wua꞉tapo na꞉ta imuwa koko hapuloma iye woloma dolumha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosestapo tamali di dla 40 alila mate epo utula꞉la mate dulu dla God mate halemama daya mate epo yú mate podlalo halaiyo. Epame Godta ewala dapiyamte dla aiyalma koko 10ye hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mosestapo Sainai tamali di dla God mate yukamhalepo depame ewala dapiyamte dla aiyalma koko hatitimaleye halopo malaiyo. Amasiyama ya꞉ malemama ya꞉ta God mate yukamhalale koko tle ya꞉ mila꞉pita usiyemale mate halaleye ya꞉skamu pomalanatiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Oloma edla A꞉lon mate epo Isalael so mate Moses mila꞉pitapo hela꞉demama usiyemale mate hallati natipame wowota꞉mama ya꞉ hala dla kulume potumulaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Amasiyama Mosestapo yia꞉ sisilamaiyo. Epalati A꞉lontapo Isalael opa yia꞉ dokopala so eleme Moses hala dla tulati ya꞉tapo yia꞉ mate yukamhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Epame alotle Isalael so opa hapulomatapo puame ya꞉ hala dla alumalati ya꞉tapo Sainai tamali di dla Godta ya꞉ watle aiyalma koko hamiliye ma yia꞉ watle imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosestapo yia꞉ mate yukamhalepo gudepame ya꞉ mila꞉piye tluka mate bopudiyo. Adipalati, ya꞉ mila꞉pitapo ala me-sikemte usiyemhalaiyo. ");
INSERT INTO xla_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","35","Epalati Mosestapo kimna꞉ya dla tame God mate yukamolowedeme ya꞉ mila꞉pi bopudlalo tlukaye alikili dla himimdiyo. Epame Godta atlamale kokoye ma Isalael so watle atlamolowedeme halemama ya꞉ mila꞉pi ma bopudemdiyo. Adipalati, yia꞉ta natilati Moses ya꞉ mila꞉pitapo sikemte usiyemale mate halemdiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Alila haleta Godta Amitai yami Yona watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Wa꞉ Niniba mo pato dla na꞉ yuye itiyamale mate atlamhalla tane. Adipalati, na꞉tapo yia꞉ta batalimale koko pato halomha꞉ha꞉leye ma-natima,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Amasiyama Yonata God yu dalepame alimama teletaiyo. Ya꞉ Yopa mo dla tulume kaula peleyama dla koa pato natiyo. Koa eye Talsis mo dla tlowedeme elaiyo. Ya꞉ koa edla asiyama himpame posokolopo ma Talsis mo dla taiyo, God tle hemele haodlowedeme. ");
INSERT INTO xla_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Oloma edla Godta sokomoko patoye kaula dla hamiyo. Epalati ulo patotota sillimama koa patoye gaglatimala yakomtaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Epedeme koa sosollalo sota wowota꞉mama yia꞉ god meyelope meyelope dle dla otele hatitimaiyo, yia꞉ gadlepo depame. Epame yia꞉ koata holokamelepo depame, yia꞉ alisisi koa dulu dla hutiyeleye yú dulu dla pololiyo. Amasiyama Yonaye koa dulu isili ikadepe dla tulume sikemte elaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Epalati koa dokopala oplamita tulume Yonata ellati esesa꞉mama epo atlaiyo, “Wa꞉ apa ham-elema꞉? Sila꞉tipame wa꞉ God dla inoma sumama sisilamane. Pona꞉malamana, wa꞉ Godta di natipo bokotiyamama di pasakalo gadlowe sepena,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Epalati koa sosollalo sota yia꞉skamu yia꞉ dulu dla atlanati atlanati demama epo atlamyaiyo, “Sokomoko mate epo ulo mate sila꞉ti iye, anta batalimaleta amma꞉?” demyaiyo. “Epedeme di osolo mate koko i malanatilowa,” diyo. Epame yia꞉ osolo ipo ha꞉ha꞉mama natilati Yona tlo malanatiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Epedeme yia꞉ Yona watle epo atlaiyo, “Di atlane, sokomoko pato puaye, anta batalimaleta api? Wa꞉ apa oplamita꞉? Wa꞉ hadima halemdi? Wa꞉ apa oko hamdi?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Epalati Yonata yia꞉ watle asiyama epo atlaiyo, “Na꞉ye Hibulu oplami. Na꞉ pepele di mate epo ta꞉lamo mate mimita꞉pele God dla mikadepe demde,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Epame koa sosollalo so watle ya꞉ta God tle teleta kokoye atlaiyo. Epalati yia꞉ta yiyelepame Yona watle epo atlaiyo, “Wa꞉ ka꞉dle koko pohasema,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Oloma edla ulo patotota ma-a꞉ma ta꞉mtlati koa sosollalo sota Yona watle epo atlaiyo, “Sokomoko ita ka꞉llipo depame, di apa koko wa꞉ dla hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Epalati Yonata asiyama yia꞉ watle epo atlaiyo, “Na꞉ batalimaletapo sokomoko patota wua꞉ dla mo-pualepo. Epedeme na꞉ tlo hampame kaula dla hamastaiya. Epelepiye, ulo patoto mate epo sokomoko mateta medla ka꞉llipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Amasiyama yia꞉ Yona yu podallalo ma tamali dla sosolomtlowe solotamaiyo. Epele tlope sokomoko mate epo ulo matetapo itiyamama yia꞉ta tamali dla tlowe apiye ponatiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Epedeme yia꞉ God watle yu sisikalle mate epo atlamyaiyo, “God, dita Yonaye hamame yú dla ka꞉stlati asiyama wa꞉ta dia꞉ye potimiya. Adipalati, koko iye podi batalimale, wa꞉ta dinapele kokopo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Epame yia꞉ Yona hamame kaula duka dla ka꞉stlati pakasiyamalalo oloma medla ulo mate sokomoko mate ka꞉ka꞉liyo. ");
INSERT INTO xla_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Epalati yia꞉tapo Godta itiyamale koko i natipame wowota꞉mama aliya halo yupo God watle hamimama ya꞉ dolumtlowe yu hatitimaiyo. ");
INSERT INTO xla_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yonaye yú dulu dla ollodemtullati Godta yu himili dolumama amalo patota puame ya꞉ye gola꞉diyo. Epalati ya꞉tapo amalo koko dulu dla elemama alila dapahatlope pololiyo. ");
INSERT INTO xla_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yonaye amalo koko dulu dla polomama, ya꞉ Lod God dla inoma sumama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Na꞉ ewatalo ga꞉tulli dulu dla tulume polowe mateka꞉pi dla polomama wa꞉ dla sisilamalati wa꞉tapo na꞉ yu daluwapo. ");
INSERT INTO xla_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Wa꞉ta na꞉ye ewatalo yú ga꞉tulli duka dla hamastlati yú pato itiyamaletapo na꞉ye polumama namilatauwapo. ");
INSERT INTO xla_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Lod, na꞉ta malamaleye, wa꞉ta na꞉ye wa꞉ mila꞉pi tle mosukulu alikili a꞉ma hamastamapo duwa. Epame Yu so aiyalma aya mape ponatilalo wekelowe tepo duwa. ");
INSERT INTO xla_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Yúta na꞉ye gola꞉dlati na꞉tapo yú dulu dla susukulumeluwapo. Epame yú dulu dla ollotulume ellati dokomakita na꞉ dokopala dla popoliyemyeuwapo. ");
INSERT INTO xla_vpl VALUES ("JH2_6","033_2_6","JON","2","6","7","Na꞉ ewatalo ga꞉tulli dulu dla tulume alikili a꞉ma woyamolowe pa꞉le dla elemama na꞉ta malamaleta na꞉ pasakaloye alikili a꞉ma haodlowe tepo duwa. Amasiyama na꞉ta dulu edla polomama wa꞉ dla otele himilati wa꞉ta wa꞉ aiyalma aya dla polomama na꞉ yuye me-daluwapo. Epedeme na꞉ God wa꞉tapo na꞉ pasakaloye gaduwapo. ");
INSERT INTO xla_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Opa anawolotapo biskapa god dla mikadepe demdi, epapele soye Godta yia꞉ dla bokotiyapo malamale himhala ka꞉dleye ponatilowa. ");
INSERT INTO xla_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Amasiyama na꞉ wa꞉ dla siyele sala semama aliya halo yupo hamilowepo. Epame na꞉tapo alila hapuloma dulu dla wa꞉ yu dla salladepo sela꞉lowedeme solotamale himilowepo. Adipalati, pasakalo gadle kokoye hatlo God wa꞉ tle puapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Epame Godtapo amalo pato dla atlaiyo, Yonaye tamali dla tame mumullupo depame. ");
INSERT INTO xla_vpl VALUES ("JH3_1","033_3_1","JON","3","1","2","Godta ma Yona watle epo atlaiyo, “Wa꞉ tame Niniba mo pato dla na꞉ta wa꞉ watle atlamale yuye ma opa watle atlamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Oloma hema Yonatapo God yu dla salla depame Niniba mo pato dla God yu hamtaiyo. Niniba mo iye pta pato, oplamitapo Niniba mo eye seme tle ma seme dla ulumyeli dlepiye, ya꞉ me-ulumhalemama alila dapahatlopeye polollepe. ");
INSERT INTO xla_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yona Niniba mo pato dla woyapame tamhalemama opa dla God yu atlamolowe kotiyaptaiyo. Ya꞉ yu itiyamale mate epo atlamtaiyo, “40 alila alotle Godta Niniba moye batalipo hamastlepe,” demtaiyo. ");
INSERT INTO xla_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Epapeleye Niniba sota God yu dalepo mikadepe demama opa hapuloma dokopala so mate epo mo so mate yia꞉ bobtalimale tle heheletimaiyo. Epedeme yia꞉ta yia꞉ bobtalimale tle heheletimale nati-imama daya podlalo ha꞉ha꞉mama dupa kolle tluka didiyepo ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Niniba mo dokopala oplamita koko i natipo ya꞉ta pollalo tle sila꞉time tluka ka꞉ka꞉dle uptipame ma dupa kolle tluka didiyepo tile apupu dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Epame ya꞉tapo Niniba so hapuloma dla yu i hamiyo, “Yu iye dokopala oplami mate epo ya꞉ gadlalo so mate tle wua꞉ dla puapo. Opa hapuloma mate epo yia꞉ halo hapuloma matetapo daya mate epo yú mate podlomolowa. ");
INSERT INTO xla_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Amasiyama opa mate epo yia꞉ halo mate dupa kolle tluka tlo didiyelepe. Epame opa hapulomata God dla otele himimama yia꞉ bobtalimale tle ya꞉ hala dla heheletimelepe. ");
INSERT INTO xla_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Adipalati, pona꞉malamana, Godta ya꞉ta malamale meyelope depame dia꞉ye popoyulalo wekelowe sepena,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Epedeme opa hapulomatapo yia꞉ bobtalimale tle God hala dla heheletimalati Godta yia꞉ natipame yia꞉ polowamama yia꞉ popoyulalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Godta Niniba so popoyulalo wekelati Yonata alimama sikemte siyaladiyo. ");
INSERT INTO xla_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Epame ya꞉ siyalademama inoma sumale yu mate God dla epo atlaiyo, “God, na꞉ta na꞉ mo dla halemama malamuwaye, wa꞉tapo Niniba mo so watle yia꞉ batalimale asiyama pohamilowe tepo duwa. Epedeme na꞉ Talsis mo dla teletauwa. Adipalati, na꞉malamana, wa꞉ dla bokotiyapo malamale pato mate epo polowamale pato mate halapo. Epame wa꞉ sadle mate halemama ma hapele posiyaladesemde, epame batalimale asiyama hamiloweye alimdepo. ");
INSERT INTO xla_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Epedeme God, wa꞉ na꞉ pasakalo hane. Na꞉ hallowe posolotamasema, polowe tlo ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Amasiyama Godta epo atlaiyo, “Yona, wa꞉ apa koko dla siyaladle himma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Epalati Yonata siyalademama Niniba mo tle alikili a꞉ma ulatame salita matlalo tiyama dla tame halemama usi hupo polaiyo. Ya꞉ edla polomama apa kokota Niniba mo dla woyamolowe depame ompolaiyo. ");
INSERT INTO xla_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Lod Godta Yonata homale dla pollopo depame dukulu emaiyo. Epame Yonata dukulu natipo sikemte siyeiyo. ");
INSERT INTO xla_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Amasiyama alila hale dla sali ala sokotalo teimhallati Godta yu himili dolumama sosota puame dukulu dlosalo kotimalati dukuluta powaiyo. ");
INSERT INTO xla_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Epame salita matlati Godta alemalle pato hamiyo. Oloma edla salita sisikalle mate tulume Yona dokopala dla sikemte domaiyo. Epalati Yonaye powatlowe mateka꞉pi dla polomama polowe tlo solotamaiyo. Epammama ya꞉ta epo atlaiyo, “Na꞉ pasakalo hallowe posolotamasema, polowe tlo ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Amasiyama Godta Yona watle epo atlaiyo, “Yona, wa꞉ta dukuluta polati siyaladlowe poka꞉dena,” diyo. Epalati asiyama Yonata God watle epo atlaiyo, “Na꞉ sikemte siyalademama polowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Epalati Godta epo atlaiyo, “Dukulu iye utula꞉la haleta peapame ma utula꞉la haleta mo-powapo. Amasiyama wa꞉ dukulu empame po-omhalana. Wa꞉ adipalati dukulu yilo sikemte polowama꞉? ");
INSERT INTO xla_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Na꞉ta Niniba so yilo polowama tlo ka꞉pipo. Adipalati, Niniba mo pato dulu dla na꞉ koko yeitamale so 120,000 opata yia꞉ halo mate me-ha꞉ha꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kelisoye Deibidi mate epo A꞉iblaham mate yia꞉ asiya dulu tle puwapo. Epedeme Yesu ya꞉ mamadulo hiye ipo. ");
INSERT INTO xla_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A꞉iblaham tle kotiyapame yamiye Aisekpo, epo Aisek yamiye Yokob, epo Yokob yamiye Yuda mate epo akimlala opi matepo. ");
INSERT INTO xla_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Epedeme Yuda ya꞉ akimlalaye Peles mate Sela mate (yia꞉ waiye Tama), epo Peles yamiye Heslon, epo Heslon yamiye Lam. ");
INSERT INTO xla_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Epo Lam yamiye Aminadab, epo Aminadab yamiye Nason, epo Nason yamiye Salmon. ");
INSERT INTO xla_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Epo Salmon yamiye Boas (Boas ya꞉ waiye Leihab), epo Boas yamiye Obed (Obed ya꞉ waiye Lut), epo Obed yamiye Yesi. ");
INSERT INTO xla_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Epo Yesi yamiye dokopala oplami halale Deibidipo. Epedeme Deibidi yamiye Solomon. (Solomon ya꞉ waiye oplami Yulaya powale ya꞉ sepeyamayo.) ");
INSERT INTO xla_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Epo Solomon yamiye Lehoboam, epo Lehoboam yamiye Abiya, epo Abiya yamiye Asa. ");
INSERT INTO xla_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Epo Asa yamiye Yehosapat, epo Yehosapat yamiye Yeholam, epo Yeholam yamiye Yusaya. ");
INSERT INTO xla_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Epo Yusaya yamiye Yotam, epo Yotam yamiye Ahas, epo Ahas yamiye Hesekaya. ");
INSERT INTO xla_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Epo Hesekaya yamiye Manase, epo Manase yamiye Amon, epo Amon yamiye Yosaya. ");
INSERT INTO xla_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Epo Yosaya yamiye Yekonaya mate epo akimlala opi matepo. Oloma hema Isalael soye Babilon mo dla elemtaiyo, wotiyalle dulu dla ka꞉ka꞉timolowedeme. ");
INSERT INTO xla_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Epedeme Isalael sota Babilon mo dla wotiyalle dulu dla ha꞉ha꞉le oloma edla Yekonayatapo maseyemala himiyo, ya꞉ hiye Selatiyel. Epo Selatiyel yamiye Selubabel. ");
INSERT INTO xla_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Epo Selubabel yamiye Abiyud, epo Abiyud yamiye Eliyakim, epo Eliyakim yamiye Asol. ");
INSERT INTO xla_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Epo Asol yamiye Sadok, epo Sadok yamiye Akim, epo Akim yamiye Eliyud. ");
INSERT INTO xla_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Epo Eliyud yamiye Eleyasa, epo Eleyasa yamiye Matan, epo Matan yamiye Yokob. ");
INSERT INTO xla_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Epo Yokob yamiye Yosep. Epedeme Yoseptapo Meli hauwapo. A꞉ya Meli itapo Yesu opata semama Keliso dlaloye hamuwapo. ");
INSERT INTO xla_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Epedeme A꞉iblahamta halale oloma etle kotiyapo tame dokopala oplami Deibidita halale oloma edla, Yesu ya꞉ mamaduloye 14 sota ha꞉ha꞉po. Epame dokopala oplami Deibidita halale oloma etle kotiyapo tame Babilon sota Isalael soye wotiyalle dulu dla elemtale oloma edla, Yesu ya꞉ mamadulo ma 14 sota ha꞉ha꞉po. Epame etle kotiyapo tame Yesu hamale oloma edla mape Yesu ya꞉ mamaduloye 14 sota ha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keliso hamale kokoye ipo elema. Ya꞉ wai Meliye Yosep watle hamilowedeme yu himpo ha꞉ha꞉iyo. Amasiyama yia꞉ ala pohalalo ha꞉ha꞉mama Meli ya꞉skamu malanatiyo, ya꞉ta Hela꞉dle Sokota itiyamale tle mopapo polaleye. ");
INSERT INTO xla_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Amasiyama Yosepye koko iye dalepo batalipo malapame Meliye memellowe solotamaiyo. Epele tlope Yosepye koko ka꞉dle oplamiyo. Epapedeme ya꞉ posolotamaiyo, opa inoma dali tle Meli memelloweye. Epammama ya꞉ solotamaiyo, Meli halowepo depo yu himiliye hemele memellowedeme. ");
INSERT INTO xla_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yosep ala koko hema me-momalamhallati God ya꞉ banakakata milamalo ya꞉ dla tulume epo atlaiyo, “Yosep, Deibidi ya꞉ mama, wa꞉ Meli halowe koko dla ase sikemte wota꞉miya. Adipalati, ya꞉ye Hela꞉dle Sokota itiyamale tle mopapo polapo. ");
INSERT INTO xla_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Epedeme ya꞉tapo maseyemala hamelepe. Epalati wa꞉tapo ya꞉ hiye Yesu sepilipe. Adipalati, ya꞉tapo ya꞉ opaye yia꞉ batalimale dulu tle elepo alikili dla woyamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Epapedeme koko hapuloma ita mo-wowoyamaiyo, Lodta ya꞉ tle yu hapame molo atlalo oplami mati tle atlamale kokota mikadepe dlepo depame. Adipalati, ya꞉ta epo atluwapo, ");
INSERT INTO xla_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ipilalo oplami koko yeliyeletapo mopapo polopame maseyemala hamelepe. Epalati opata ya꞉ hiye Imanuwel sepilipe,” duwapo. Hi i ya꞉ dulu kokoye ipo elema, Godye dia꞉ mate halapo. ");
INSERT INTO xla_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosep ya꞉ elale tle sila꞉tipame Lod ya꞉ banakakata ya꞉ watle atlamale yu e dolumama Meli me-haiyo. ");
INSERT INTO xla_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amasiyama Yosep Meli hapo halemama ya꞉ kapala ala po-umulalo hallati Melita maseyemala hamaiyo. Epalati Yoseptapo maseyemala hiye Yesu sepiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helodtapo Yu so mo dokopala oplami halale oloma edla Yudiya mo dulu dla Betliyem mo yemala dla Melitapo Yesuye hamaiyo. Yesu hamale alotle tamili sesa꞉lalo sotapo salita matlalo tiyama tle Yelusalem dla pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yia꞉ puame Yelusalem dla woyapo epo atlamsiyamaiyo, “Maseyemala Yu so dokopala oplami hallowe hamaleye hadima elema꞉? Adipalati, di ala di mo dla ha꞉ha꞉mama ya꞉ tamilita mo-woyampolla natipame ya꞉ hi di dla ta꞉dlowedeme pumula,” demsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amasiyama dokopala oplami Helod mate epo opa hapuloma Yelusalem dla ha꞉ha꞉lalo so mate koko i dalepame sikemte momalamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Epammama Helodta aiyalma aya dokopala so mate epo aiyalma imalalo so mate sisilapame epo atlaiyo, “Kelisoye hadima hamelepe demduwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Epalati asiyama yia꞉ta epo atlaiyo, “Yudiya mo pato dulu dla Betliyem mo yemala dla hamelepe demduwa. Adipalati, God tle yu hapame molo atlalo oplamita ipo hatitimuwapo, ");
INSERT INTO xla_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betliyem so, Yuda mo pato dulu dla wua꞉ moye yimka꞉malapo. Amasiyama wua꞉ mo yimka꞉mala etle dokopala hallowe oplamiye pulupe. Ya꞉tapo na꞉ opa Isalael soye omhallepe,’ demduwapo.” ");
INSERT INTO xla_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Epalati Helodta koko i dalepame tamili sesa꞉lalo so tle tamilita woyamale alila dallowedeme hemele yia꞉ sisilamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Epame yia꞉ta asiyama yuye atla dalepame yia꞉ye Betliyem dla taiya demama yu ipo hamiyo, “Wua꞉ tame maseyemalaye woloma totamtame natipo ma ilame puame na꞉ atlaiye. Epalati na꞉ ma tame ya꞉ dla siyele hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Epalati tamili sesa꞉lalo sotapo Helod yu dalepame ma-tamallati yia꞉ta yia꞉ mo dla tamili natili hatlo metlo ma natiyo. Yia꞉ tamili e natipame sisiyele mate tamili eta itapu tlati dolumtamalaiyo. Yia꞉ tamili dolumtamha꞉ha꞉lati tamilita tame maseyemalata ela aya di dla hedepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Epalati tamili sesa꞉lalo sota maseyemalata ela aya dulu dla tuwame natilati maseyemalaye ya꞉ wai Melita hamame polla natiyo. Epalati yia꞉tapo heodepo popa꞉mama maseyemala dla siyele hamimama ya꞉ hi di dla ta꞉diyo. Epame ya꞉ watle namkale dle alisisi ipapele halopiyo, gold mani epo ullu ka꞉pi pamalalo sosoko epame kapala huhutamalalo dakopala alisisi ka꞉dle. ");
INSERT INTO xla_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Amasiyama yia꞉ ma i-ilapo tlowedeme hutiyelati Godta milamalo yia꞉ watle epo atlaiyo, “Wua꞉ ma i-ilapo tamalemama Helod hala dla potlowa. Amasiyama wua꞉ api hale tle ma wua꞉ mo dla taiye,” diyo. Epalati yia꞉tapo yu e dolumama api hale tle yia꞉ mo dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Epo alotle tamili sesa꞉lalo sota ma-tamallati utula꞉la edla Yosep ellati milamalo God ya꞉ banakakata tulume epo atlaiyo, “Wa꞉ sila꞉time maseyemala mate epo ya꞉ wai mate eleme Isip mo dla teletane. Adipalati, Helod ya꞉ opatapo maseyemala e yumuluwedeme totampumullupe. Epedeme wua꞉ potame Isip mo dla ha꞉ha꞉lepe. Wua꞉ edla tame ha꞉ha꞉lati ma na꞉ta wua꞉ta ilampuluwe yuye atlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Epela dalepame utula꞉la edla Yosepta sila꞉time maseyemala mate ya꞉ wai mate elepame Isip mo dla potaiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yia꞉ edla tame Helodta polopo depame omha꞉ha꞉iyo. Epedeme koko ita mo-woyamaiyo, Lodtapo ya꞉ tle yu hapame molo atlalo oplami mati tle atlale yuta mikadepe dlowedeme. Yu eye ipo, “Isip mo dulu tle na꞉tapo na꞉ maseyemalaye sisilamuwapo.” ");
INSERT INTO xla_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Amasiyama Helodtapo tamili sesa꞉lalo sota ya꞉ po-atlalo ma api hale tle yia꞉ mo dla taleye dalepame sikemte siyaladiyo. Epalati ya꞉tapo ya꞉ opa watle yu itiyamale hamiyo, yia꞉tapo Betliyem mo dla epo mo yimlala opi mateka꞉pi dla popa꞉mya dla tame akimlala yimka꞉sikili potimelepo depame. Epalati yia꞉tapo tame akimlala sokomoko dapiyamte oloma dla ha꞉ha꞉lalo so mate epo yia꞉ ko tle hohomale so mate potimtaiyo. Adipalati, Helodta ya꞉skamu epo malamaiyo, “Tamili sesa꞉lalo sota tamili natiwa tle puame wata oloma hema sokomoko dapiyamte mo-pololepo. Epedeme na꞉ta na꞉ opa watle akimlala sokomoko dapiyamte mate epo yia꞉ ko tle hohomale so mate potimtaiya dlepiye, eta maseyemala e ma yumilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Epedeme ipapele kokota woyamama God tle yu hapame molo atlalo oplami Yelemayata atlamale yu mate ma-ala꞉uwapo. Adipalati, ya꞉ta ipo ilimuwapo, ");
INSERT INTO xla_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A꞉lle yu mate wowolimyale yu mate Lama mo dla dalepo. Adipalati, a꞉ya Laiseltapo ya꞉ yimlala yilo amsela꞉po. Epedeme ya꞉ sikemte amsela꞉mama ka꞉lliwe ponatisema. Adipalati, ya꞉ yimlala hapulomaye mo-potimuwapo.” ");
INSERT INTO xla_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Yosep ala Isip mo dla me-hallati dokopala oplami Helodye mo-powaiyo. Epalati God ya꞉ banakaka oplamitapo Yosep ellati milamalo tulume epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wa꞉ sila꞉time maseyemala mate ya꞉ wai mate elepame Isalael mo dla ma ilamtane. Adipalati, maseyemala yumuluwa dlalo soye mo-paliwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Epalati Yosep yu i dalepame maseyemala mate ya꞉ wai mate eleme ma ilame Isalael mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Amasiyama Helodta polati ma yami Akeleyosta Yudiya mo dla dokopala oplami halaiyo. Epalati Yosepta dalepame mo edla tlowe wota꞉iyo. Epalati God ya꞉ banakakata mamisika꞉ milamalo tulume ya꞉ watle epo atlaiyo, “Wa꞉ Yudiya mo dla potlowa,” diyo. Yoseptapo banakaka oplamita epo atla dalepame ma Ga꞉lili mo pato dulu dla Nasalet mo yemala dla halla taiyo. Epapedeme Godta ya꞉ tle yu hapame molo atlalo oplami mati tle atlale kokotapo mo-mikadepe duwapo. Adipalati, ya꞉ta epo atluwapo, “Opata Kelisoye semama Nasalet oplami dlepe,” duwapo. ");
INSERT INTO xla_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Epedeme Yon opa yú dla ka꞉ka꞉timalalo oplamitapo puame Yudiya mo dalupa dulu dla God yu epo atlamsela꞉iyo, ");
INSERT INTO xla_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Wua꞉ malamale meyelope depame wua꞉ bobtalimale tle heheletimaiya. Adipalati, Pepele dimo kokota puluweye mo-mateka꞉pi,” demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Epedeme Yon opa yú dla ka꞉ka꞉timalalo oplami kokoye God tle yu hapame molo atlalo oplami Aisayata ipo atluwapo, “Oplami haletapo dalupa dulu dla yu ipo teta꞉mhalapo, ‘Lod apiye dinapiya. Epame ya꞉ apiye ka꞉depo dolepo himiya,’ demhalapo.” ");
INSERT INTO xla_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yonye ka꞉mol aliya dlalota tluka dedlemale asiyamsela꞉mama alinepi kapalata akolo dla nosowe some asiyamsela꞉mdiyo. Epo ya꞉ wolomopi mate topsiyo mate demsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Opa hapulomatapo Yon yu dallowedeme pumulumama opitapo Yelusalem tle epo Yudiya tle epame opitapo Yoden aloma pili dla ha꞉ha꞉lalo tle pumhalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yia꞉ Yon yu dalepame yia꞉ bobtalimale bobotimatimalati Yontapo yia꞉ye Yoden yú dla ka꞉ka꞉timaiyo. ");
INSERT INTO xla_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amasiyama Pa꞉lisi so opa opi mate epo Sa꞉dusi so opa opi mate Yonta opa yú dla ka꞉ka꞉timhallati puame wowoyamaiyo. Epalati Yonta yia꞉ natipame yia꞉ watle epo atlaiyo, “Wua꞉ye ilama yimlalapo. Antapo wua꞉ watle atlemama isikimi yú tutula꞉le kokota wua꞉ye Godta kasilamale pua tle hemele haohaodlepe duwa? ");
INSERT INTO xla_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wua꞉ta wua꞉ bobtalimale tle ikadepe heheletimaleye wua꞉ta ha꞉ha꞉le pasakalo tle nati-iya. ");
INSERT INTO xla_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Epame wuskamu wua꞉ tlo A꞉iblaham ya꞉ mamadulo depame Godta kasilamale tle hemele haohaodlepe demiya. Adipalati, na꞉ wua꞉ watle ikadepe koko atlema. God ya꞉ dla itiyamale elapo, ewala popa꞉ itapo ma A꞉iblaham ya꞉ mamadulo ikadepe yiyeloweye. ");
INSERT INTO xla_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mutupa꞉yatapo dali tou dla ma-dinapopame womelapo. Epedeme dali aditapo dlomoko ka꞉dle pomilimalalo hallepiye, dali eye wostapame dlapa dla mistlepe. ");
INSERT INTO xla_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na꞉tapo wua꞉ta wua꞉ bobtalimale tle malamale meyelope dle dla wua꞉ye isikimi yú siyapo dla ka꞉ka꞉tima. Amasiyama na꞉ ko tle pua oplamita itiyamaletapo na꞉ tla꞉mtana. Epedeme na꞉ta ya꞉ hete alisisi uptipo halopo tlowe poka꞉dena. Ya꞉tapo wua꞉ye itiyamale hamimama Hela꞉dle Soko mate epo dlapa mate dla ka꞉ka꞉timelepe. ");
INSERT INTO xla_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ya꞉tapo witi daya mate epo daya kasili mate duka gladlowedeme ya꞉ oko alisisi mate ma-dinapopo halapo. Ya꞉ta witi daya mate epo kasili mate duka gladepame daya siyapo tlo aya dla kolumelepe. Epame asiyama daya kasili tlo posumtlalo wekelalo dlapa dla mistlepe.” ");
INSERT INTO xla_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Alila oloma edla Yesuye Ga꞉lili mo tle Yoden aloma dla puaiyo, Yontapo ya꞉ye yú dla ka꞉stlepo depame. ");
INSERT INTO xla_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amasiyama Yonta Yesuye yú dla ka꞉stlowe alimama ya꞉ watle epo atlaiyo, “Wa꞉ adipalati na꞉ta wa꞉ye yú dla ka꞉stlepo depame na꞉ hala dla puo? Ka꞉dlepo, wa꞉ta na꞉ tlo yú dla ka꞉stloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Epalati asiyama Yesuta ya꞉ watle epo atlaiyo, “Ka꞉dena, wata oloma hema wa꞉ta na꞉ tlo mepo yú dla ka꞉stloweye. Adipalati, iye Godta solotamale koko ipo,” diyo. Epalati Yonta yu i dalepame Yesuye yú dla ka꞉staiyo. ");
INSERT INTO xla_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Epame Yesuye yú dla tulupo hetame halemama natilati Pepele dita gowaladepo hallati God ya꞉ Hela꞉dle Sokotapo seselema tea some ya꞉ dla malla natiyo. ");
INSERT INTO xla_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Epalati Pepele di tle yuta epo malaiyo, “Iye na꞉ta sikemte dupa ellalo maseyemala ikadepepo. Na꞉ ya꞉ dla sikemte siyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hela꞉dle Sokota Yesuye dalupa dulu dla semtaiyo, Saitenta ya꞉ye elemala natilipo depame. ");
INSERT INTO xla_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ya꞉ 40 alila mate utula꞉la mate daya dimi sela꞉le oloma dla ma daya ta꞉le patota ya꞉ dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Epalati Saitenta puame Yesu watle epo atlaiyo, “Wa꞉ ikadepe God Yami dlepiye, wa꞉ ewala hutiye i atlane daya yiyelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amasiyama Yesuta epo atlaiyo, “God yu bukata epo atlapo, ‘Oplamitapo daya siyapo tlo demhalemama pasakalo pohallowa. Amasiyama ya꞉ God yu tlo daya some demhalemama pasakalo hallepe,’” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Epame matle Saitenta Yesu seme Yelusalem dla taiyo. Epame aiyalma aya dopuko di ikadepe dla Yesuye pamelepame ya꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Wa꞉ ikadepe God Yami dlepiye, wa꞉ dopuko di itle ta꞉la dla putuko dene. Adipalati, God yu bukata epo atlapo, ‘Godtapo ya꞉ banakaka so watle, wa꞉ye woloma omha꞉ha꞉iya, dlepe. Epalati yia꞉tapo wa꞉ye yia꞉ dota hamelepe, wa꞉ heteta tulume ewala dla heyulala depame.’” ");
INSERT INTO xla_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Amasiyama Yesuta epo atlaiyo, “God yu bukata ma epo atlapo, ‘Wa꞉ Lod wa꞉ Godta itiyamale natilowedeme ya꞉ye elemala natimiya,’” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Saiten matle Yesu seme tamali pato di dla hetaiyo. Epame ya꞉ watle ta꞉lamo patotota yia꞉ta itiyamale mate hela꞉dle mate hutiye kokoye nalati-iyo. ");
INSERT INTO xla_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Epame Saitenta ma ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ dla heodepo siyele ta꞉dlepiye, na꞉tapo ta꞉lamo pato iye wa꞉ watle hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Epalati Yesuta ya꞉ watle epo atlaiyo, “Saiten, wa꞉ na꞉ tle alikili a꞉ma tane. Adipalati, God yu bukata epo atlapo, ‘Wa꞉ hatlo Lod wa꞉ God dla heodepo siyele ta꞉demama ya꞉ yu dla salladepo sela꞉ne.’” ");
INSERT INTO xla_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Epapele oloma edla Saitentapo Yesu saliyome taiyo. Epalati banakaka sotapo Yesuye puame gadiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesutapo Yon opa yú dla ka꞉ka꞉timalalo oplamiye amtuwale aya dla ka꞉stale dalepame ma Ga꞉lili dla ilamtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ya꞉ Nasalet mo saliyome ma Kapaniyem mo dla halla taiyo. Kapaniyem mo iye Ga꞉lili kaula peleyama dla halapo. Ta꞉la eye Sebulun mate epo Naptali mate yia꞉ asiyadulo ta꞉layo. ");
INSERT INTO xla_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Koko itapo mo-woyamaiyo, God tle yu hapame molo atlalo oplami Aisayatapo atlale mate ala꞉lowedeme. Adipalati, ya꞉ta yu ipo atluwapo, ");
INSERT INTO xla_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ga꞉lili so, wua꞉ po-Yu so mate ha꞉ha꞉po. Wua꞉ ta꞉laye Ga꞉lili kaula peleyama dla elapo, Yoden aloma seme dla. Epame opata wua꞉ ta꞉laye Sebulun mate epo Naptali mate yia꞉ ta꞉la demdepo. Epedeme wua꞉ na꞉ yu daliya. ");
INSERT INTO xla_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Opa amtuwale dulu dla ha꞉ha꞉lalo so, wua꞉ hela꞉dle pato natilipe. Epame powaleta bopudepo ha꞉ha꞉lalo so, wua꞉ dla hela꞉dle patota pulupe.” ");
INSERT INTO xla_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Epame oloma edla Yesutapo God yu imolowe kotiyamama epo imsela꞉iyo, “Wua꞉ malamale meyelope depame wua꞉ bobtalimale tle heheletimaiya. Adipalati, Pepele dimo kokota puluweye mo-mateka꞉pi,” demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Alila haleta Yesu Ga꞉lili kaula peleyama tle polomyemama amalo halomsiyamalalo so opa dapiyamte Saimon mate epo ya꞉ ei Endulu mate tlamaiyo. Saimon ya꞉ hi haleye Pitayo. Epapeleye yia꞉ mata yú dulu dla hatitimsiyamalati Yesuta pumama yia꞉ natiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Epame yia꞉ watle epo atlaiyo, “Wua꞉ na꞉ dolumpumulaiya. Wua꞉ ka꞉yapa amalo halomalalo so depo ha꞉ha꞉uwapo. Amasiyama ma wata oloma itle wua꞉ opaye ma God dla elempulalo so depo ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Epalati yia꞉ yu e dalepame yia꞉ mata medla pomelepame Yesu mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Epame yia꞉ etle ma tamalemama amalo halomsiyamalalo so opa opi tlamaiyo, Sebedi ya꞉ akimlala dapiyamte Yeims mate epo ya꞉ ei Yon mate. Yia꞉ye yia꞉ a mate koa dulu dla mata dinampopa꞉iyo. Epalati Yesuta yia꞉ watle epo atlaiyo, “Na꞉ dolumpumulaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Epalati yia꞉ yu e dalepame yia꞉ mata mate epo yia꞉ a mate koa dulu medla salepame Yesu mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Epedeme Yesu Ga꞉lili mo pato dulu dla mo yimlala hapuloma dulu dla sela꞉mama yia꞉ta inoma sumalalo aya hapuloma dla ka꞉dle yu Pepele dimo kokoye imsela꞉iyo. Epamsela꞉mama esusulumale so hapuloma mape ka꞉ka꞉demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Epalati Ga꞉lili mo seme Siliya demdiye edla ha꞉ha꞉lalo so mape ya꞉ta koko halomsela꞉leye daliyo. Epapele koko tle opatapo esiyele mila꞉pi meyelope meyelope dle so opaye Yesuta ka꞉ka꞉dlepo depame ya꞉ hala dla hohopo pumhalaiyo. Epedeme yia꞉tapo esiyele mila꞉pi meyelope meyelope dle ipapeleye Yesu hala dla hohopo pumhalaiyo. Opitapo sikemte wotiyalle dulu dla ha꞉ha꞉lalo soye hohopo pumulaiyo, epela opitapo bataliya watalo soye hohopo pumulaiyo, epela opitapo yiyilalimale soye hohopo pumulaiyo, epela opitapo moto palli soye hohopo pumulaiyo. Epalati Yesutapo yia꞉ta hapulomaye ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Epedeme opa hapuloma Ga꞉lili tle epame Dekapolis tle epo Yelusalem tle epame Yudiya tle epame mo opi Yoden aloma seme dla ha꞉ha꞉lalo tle Yesu hala dla puame ya꞉ dolumtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu opa hapulomata ya꞉ hala dla pula natipame tamali di dla hetame polaiyo. Epalati ya꞉ alotle tlalo sota ya꞉ dla puame alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Epapele oloma edla ya꞉tapo God yu yia꞉ watle imolowe kotiyamama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Opa anawolotapo gadle yilo God dla hitaha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Pepele dimo kokoye wuolepo. ");
INSERT INTO xla_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Epame opa anawolotapo dupa kolle mate a꞉lemha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Godtapo wua꞉ye gadlepe. ");
INSERT INTO xla_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Epame opa anawolotapo homta ha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Godtapo ta꞉lamo patoye wua꞉ watle hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Epame opa anawolotapo Godta solotamale koko tlo halomolowa depo sikemte solotamha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Godtapo wua꞉ta hatlo ya꞉ta solotamale koko tlo halomha꞉ha꞉lepo depame wua꞉ye gadlepe. ");
INSERT INTO xla_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Epame opa anawolotapo yimkadulo polowamale mate ha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, asiyama Godtapo wua꞉ dla polowamale mate hallepe. ");
INSERT INTO xla_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Epame opa anawolotapo yia꞉ dupa dulu tle ullu pa꞉po ha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, wua꞉tapo God natilipe. ");
INSERT INTO xla_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Epame opa anawolotapo yimkaduloye sadle mate ha꞉ha꞉lepo depame gademha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Godtapo wua꞉ye ya꞉ akimlala dlepe. ");
INSERT INTO xla_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Epame opa anawolotapo Godta solotamale koko dolumha꞉ha꞉mama wotiyalle halomha꞉ha꞉ma꞉, wua꞉ sisiyeiya. Adipalati, Pepele dimo kokoye wuolepo. ");
INSERT INTO xla_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Epedeme opatapo na꞉ koko yilo wua꞉ putlopame hopolemyemama wua꞉ hi mate mala-atlamyelepiye, wua꞉ sisiyeiya. ");
INSERT INTO xla_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Adipalati, Pepele di dla wua꞉ta halowe asiyama patoye wua꞉ hi mate ma-dinapopo hutiyepo. Epapedeme wua꞉ malamaiya, wua꞉ dla wotiyalle hapimha꞉ha꞉ so yia꞉ mamadulotapo ka꞉yapa ha꞉ha꞉uwa God yu molo atlamalalo so dla wotiyalle mepapeleye halopimha꞉ha꞉uwapo.” ");
INSERT INTO xla_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Wua꞉ ta꞉lamo so dla solo epapele some ha꞉ha꞉po. Amasiyama solotapo ya꞉ta opalli pa꞉lepiye, ma adipo ya꞉ta opalliye hapa꞉? Epedeme solo ita ya꞉ta opalli pa꞉lepiye, ya꞉ ma koko pa꞉le ellepe. Epalati ta꞉la dla hamastlati opata di tle dolemsiyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Epame wua꞉ye ta꞉lamo so hapuloma dla hela꞉dle epapele some ha꞉ha꞉po. Adipalati, tamali di dla mo pollopiye, mo eye hemele pohaodepo pollowa. Hao, haliyamale dla gillistame polomdepo. ");
INSERT INTO xla_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Epedeme oplami haletapo tulomaye otopame kawapo mate pobopudesemde. Hao. Ya꞉ tuloma otopame haliyamale dla pamelemdepo, opatapo aya dulu dla popa꞉mama hela꞉dle natilipo depame. ");
INSERT INTO xla_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Epapele tle ka꞉dena, wua꞉tapo ta꞉lamo so dla hela꞉depo ha꞉ha꞉loweye. Epapelepiye, opatapo wua꞉ta koko ka꞉dle halomha꞉ha꞉ natipame yia꞉tapo wua꞉ A God Pepele di dla hala hi di dla ta꞉dlepe.” ");
INSERT INTO xla_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Epedeme wua꞉ na꞉ye Godta aiyalma koko hatitimale mate epo ya꞉ tle yu hapame molo atlamalalo sota God yu hatitimale mateye batalimolowedeme puwayo depo malamha꞉ha꞉miya. Hao, na꞉ epapolowedeme popuana. Amasiyama na꞉ isikimi yia꞉ta atlamale koko hapuloma eye ala꞉po pustlowedeme puwapo. ");
INSERT INTO xla_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Epapedeme na꞉ ikadepe koko wua꞉ watle atlema. Ta꞉lamo mate epo pepele di mateta ala popa꞉lalo me-ha꞉ha꞉lati Godta aiyalma hatitimale dulu dla hi ilalimale yemala haleta alikili dla pohaodlowa. Amasiyama aiyalmata atlamale koko hapulomata mepo wowoyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Epedeme oplami antapo Godta aiyalma hatitimale dulu dla aiyalma hatlo yimka꞉mala dla posalladlalo halemama yimkadulo ma mepapele koko imhallepiye, ya꞉ye Pepele dimo dla yimka꞉mala ikadepe hallepe. Amasiyama oplami antapo Godta aiyalma hatitimale hapuloma dla salladepo halemama yimkadulo ma mepapele koko imhallepiye, ya꞉ye Pepele dimo dla pato depo hallepe. ");
INSERT INTO xla_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ta God dla salladleta aiyalma imalalo so mate epo Pa꞉lisi so mateta God dla salladleye potla꞉mtlalo wekelepiye, wua꞉ Pepele dimo dla po-ulatuluwa.” ");
INSERT INTO xla_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Epedeme Godtapo mo-powataliya di mamadulo dla yu ipo atluwaye wua꞉ ma-daluwapo, ‘Ya꞉mkale yumula aiyalma, epame ya꞉mkale yumulalo oplamiye koko gladle dla hamamhetlepe,’ duwa kokoye. ");
INSERT INTO xla_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amasiyama na꞉ matle koko hema ipo atlema. Oplami antapo ya꞉mkale dla siyaladle mate hallepiye, ya꞉ ma koko gladle dla hamamhetlepe. Epame oplami antapo ya꞉mkale watle, ‘wa꞉ poka꞉dle oplami’ dlepiye, ka꞉dena, wua꞉ ya꞉ye mo dokopala so dla hamamtame ya꞉ koko gladloweye. Epame oplami antapo ya꞉mkale watle, ‘wa꞉ yiyilamale oplami’ dlepiye, ka꞉dena, ya꞉ye asiyama Dlapa mo dla ka꞉stloweye. ");
INSERT INTO xla_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Epedeme wa꞉ God watle namkale dle alisisi hamilowedeme halemama ma pakasiyamalalo medla wa꞉ amkaleta wa꞉ dla elle himhala koko malamelepiye, wa꞉ namkale dle alisisiye medla himpame ma hapele tame wa꞉ amkale e mate namkale dlepe. Epame ma ilame puame namkale dle alisisi eye God watle hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Epedeme wa꞉ alilalo oplamita wa꞉ye koko gladle dla semtlati wa꞉ hapele api duka dla ya꞉ mate tamama ya꞉ta wa꞉ dla alli elaye pustlepo depame ya꞉ mate namkale dlepe. Amasiyama wa꞉ta koko e pohalalo wekelepiye, ya꞉tapo wa꞉ye koko gladlalo oplami dla semtame wa꞉ koko gladlepe. Epalati ma koko gladlalo oplamitapo wa꞉ye amtuwale aya omhallalo oplami dla homellepe. Epalati etle ya꞉tapo wa꞉ye ma amtuwale aya dulu dla ka꞉stlepe. ");
INSERT INTO xla_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Epedeme na꞉ ikadepe kokoye atlema, wa꞉ amtuwale aya dulu edla halemama alikili dla woyamolowe apiye ponatilowa. Amasiyama wa꞉tapo ya꞉ta sale mani sukulu mate ala꞉po himilipiye, eta wa꞉ye alikili dla woyamelepe.” ");
INSERT INTO xla_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Epedeme wua꞉ yu ipo atlati ma-daluwapo, ‘Ya꞉mkale a꞉ya uhala aiyalma’ duwa kokoye. ");
INSERT INTO xla_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amasiyama na꞉ matle wua꞉ watle ipo atlema, oplami antapo ya꞉mkale a꞉yaye inomata sikemte omelemama dupata malamale tle ya꞉ mate hatlope dlowe solotamelepiye, ya꞉ a꞉ya eye ya꞉ta malamale tle mo-uhapo. ");
INSERT INTO xla_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Epedeme wa꞉ dowala inomata wa꞉ye batalimale dla semtullupiye, ka꞉dena, wa꞉ dowala inoma eye holame hamastloweye. Ame adipalati, poka꞉dena, wa꞉ta wa꞉ inoma dapiyamte mate halemama Dlapa mo dla tloweye. Amasiyama ka꞉dena, wa꞉ta inoma hatlope mate Pepele dimo dla ulatuluweye. ");
INSERT INTO xla_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Epame wa꞉ dowala dota wa꞉ye batalimale dla semtullupiye, ka꞉dena, wa꞉ dowala do eye ketamastloweye. Ame adipalati, poka꞉dena, wa꞉ta wa꞉ do dapiyamte mate halemama Dlapa mo dla tloweye. Amasiyama ka꞉dena, wa꞉ta do hatlope mate Pepele dimo dla ulatuluweye. ");
INSERT INTO xla_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Epame wua꞉ yu ipo atlati ma-daluwapo, ‘Oplami antapo ya꞉ a꞉ya memellowe solotamelepiye, ya꞉ye a꞉ya mellalo pepa dla yu ilipame a꞉ya watle hamilipe,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amasiyama na꞉ matle koko hema wua꞉ watle ipo atlema, wa꞉ a꞉ya pomellowa. Epapele tlope dulu hema a꞉yatapo oplami hale uhalepiye, wa꞉ eta ka꞉dena, wa꞉ a꞉ya e memelloweye. Amasiyama wa꞉ isikimi koko pa꞉le wa꞉ a꞉ya e memellepiye, etapo a꞉ya eye batalimale koko dla semtullupe. Adipalati, dulu edla a꞉ya etapo ma oplami hale halepiye, ya꞉ oplami eye uhapo. Epame oplami mape a꞉ya eye uhapo.” ");
INSERT INTO xla_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Epame wua꞉ di mamadulo dla yu ipo atlati ma-daluwapo, ‘Wa꞉ God dla koko hale halowedeme aiyalma sepame aiyalma eye ma popostlowa,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amasiyama na꞉ matle koko hema ipo atlema, wa꞉ koko hale halowedeme aiyalma posemhallowa. Epedeme wa꞉ Pepele dimo hi sepame aiyalma posolowa. Adipalati, eye Godta pollalo mopo. ");
INSERT INTO xla_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Epame ta꞉lamo hi sepame aiyalma posolowa. Adipalati, eye Godta ya꞉ hete kellepo pollalo mopo. Epame Yelusalem mo hi sepame aiyalma posolowa. Adipalati, mo eye dokopala oplami ya꞉ mopo. ");
INSERT INTO xla_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Epame wa꞉ dokopala umpame aiyalma posolowa. Adipalati, wa꞉ta atla kokotapo wa꞉ dokopala dulu kokosase haleye mila꞉pi pomeyelopedesemde. ");
INSERT INTO xla_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Epedeme wa꞉ koko hale halowedeme solotamelepiye, isikimi ‘yao, na꞉ me-solotama’ dlepe. Epame koko hale halowe allipiye, isikimi ‘hao, na꞉ posolotamasema’ dlepe. Adipalati, wua꞉ta pe-epapalalo isikimi aiyalma tlo selepiye, wa꞉ yu eye Saiten tle pua atlapo.” ");
INSERT INTO xla_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Epame wua꞉ yu ipo atlati ma-daluwapo, ‘Wa꞉ ya꞉mkale heyumama inoma topa꞉dlepiye, ka꞉dena, oplami haleta asiyama wa꞉ heyumama inoma topa꞉dloweye. Epame matle wa꞉ ya꞉mkale a꞉pe nama dla heyumama a꞉pe hatlo holamastlepiye, ka꞉dena, ma asiyama oplami haleta wa꞉ a꞉pe nama dla heyumama a꞉pe holamastloweye.’ ");
INSERT INTO xla_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amasiyama na꞉ koko edla ma ipo atlema, wa꞉ oplami haleta wa꞉ dla batalimale koko adipapele halepiye, wa꞉ asiyama epapele kokoye ya꞉ watle ponati-iliwa. Epedeme oplami haletapo wa꞉ damta dla heyulupiye, ka꞉dena, ma damta seme dla heyulupo depame ya꞉ dla haiyeloweye. ");
INSERT INTO xla_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Epame oplami haleta wa꞉ sede halowe solotamama wa꞉ye koko gladle dla hamamtelepiye, ka꞉dena, wa꞉tapo wa꞉ sede e mate epame wa꞉ kapumale tluka mate ya꞉ watle me-hapine. ");
INSERT INTO xla_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Epame oplami haletapo wa꞉ mate mo hale dla tlowa depo puame ha꞉ha꞉melepiye, ka꞉dena, wa꞉ ya꞉ gademama ya꞉ mate telepe. ");
INSERT INTO xla_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Epedeme oplami haleta wa꞉ dla alisisi otelepiye, ya꞉ dla isikimi me-hamine.” ");
INSERT INTO xla_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Epedeme wua꞉ yu ipo atlati ma-daluwapo, ‘Wa꞉ amkale tlo bokotiyapo malamama asiyama wa꞉ dla opahale dlalo oplami tlo aline’ duwaye. ");
INSERT INTO xla_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amasiyama na꞉ ma koko hema wua꞉ watle ipo atlema, wua꞉ dla opahale demha꞉ha꞉ soye bokotiyapo malamha꞉ha꞉iya. Epammama wua꞉ dla wotiyalle hapimha꞉ha꞉ so yilo inoma sumale himme ha꞉ha꞉iya. ");
INSERT INTO xla_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Epedeme wua꞉ta ipapele koko hamha꞉ha꞉lepiye, eta wua꞉ye Pepele di dla hala A God ya꞉ akimlala ikadepe dlepe. Epapele dulu dla Godtapo ka꞉ka꞉dle so dla epo bobtalimale so dla sali ka꞉depo silaple mate epo tiyo mate hapimhalapo. ");
INSERT INTO xla_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Epapedeme wua꞉ isikimi hatlo wua꞉ dla sikemte malamale himha꞉ha꞉ so tlo malamha꞉ha꞉lepiye, wua꞉ asiyama ka꞉pi hapa꞉? Hao, pohalowa. Adipalati, batalimale so mape mepamdepo. ");
INSERT INTO xla_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Epame wua꞉ isikimi wua꞉ amkadulo tlo namkale demhallepiye, e ka꞉dle kokota꞉? Hao, alikili so ma koko mepapele hamdepo. ");
INSERT INTO xla_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Epedeme wua꞉ A Godta opa hapuloma sikemte bokotiyapo malamhalaye, mepammama wua꞉ ma opa hapulomaye bokotiyapo malamha꞉ha꞉iya.” ");
INSERT INTO xla_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Epapedeme wua꞉ isikimi opata natilipo depame ka꞉ka꞉dle koko halomha꞉ha꞉miya. Adipalati, wua꞉ koko ipapele halomha꞉ha꞉lepiye, wua꞉ A God Pepele di dla hala tle asiyama pohalowa. ");
INSERT INTO xla_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Epapele dulu dla wa꞉ atali so watle alisisi halopiliwedeme haliyamale opa inoma dali tle halopimiya. Adipalati, yiskamu pepeyalimalalo sotapo opata yia꞉ tlo ka꞉ka꞉dle so dlepo depame ipapele kokoye inoma sumalalo aya dla epame mo duka dla halomsiyamdepo. Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Yia꞉ta epapele koko halomha꞉ha꞉lati opata yia꞉ natipo sisiyemha꞉ha꞉ tle yia꞉ asiyama ma-hamha꞉ha꞉po. Epapedeme yia꞉ God tle asiyama hale pohalowa. ");
INSERT INTO xla_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Epedeme wa꞉ atali so watle alisisi halopiliwedeme apelepiye, wa꞉ hemele yia꞉ watle halopilipe. Epalati wa꞉ A Godta wa꞉ta hemele ka꞉dle koko ha e natipame wa꞉ watle asiyama hamilipe.” ");
INSERT INTO xla_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Epame wua꞉ inoma sumama yiskamu pepeyalimalalo so some ha꞉ha꞉miya. Adipalati, yia꞉ye opata yia꞉ natilipo depame mo duka dla epame inoma sumalalo aya dulu dla itapu ikadepe dla tuwame ha꞉ha꞉mama inoma sumha꞉ha꞉mdepo. Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Yia꞉ta epapele koko halomha꞉ha꞉ tle yia꞉ asiyama ma-hamha꞉ha꞉po. Epapedeme yia꞉ God tle asiyama hale pohalowa. ");
INSERT INTO xla_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amasiyama wa꞉ inoma sumolowedeme wa꞉ aya dulu dla tuwame kokoloma himomelepame opata ponatilalo wekelalo A God dla inoma sumelepe. Epalati ya꞉tapo wa꞉ta ya꞉ watle epo inoma sumale himhala natipame wa꞉ watle asiyama hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Epame wua꞉ inoma sumama God koko yeitamale sota inoma sumalalo some inoma sumha꞉ha꞉miya. Adipalati, yia꞉ta inoma sumale dulu dla isikimi koko pa꞉le yu sikemte seselemalli atlamtamdepo. Adipalati, yia꞉ta malamaletapo Godta yia꞉ta inoma sumale yu seselemalli atlamalati tlo sikemte dallowe solotama demdepo. ");
INSERT INTO xla_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Epedeme wua꞉ yia꞉ some koko pa꞉le inoma sumale yu atlamha꞉ha꞉miya. Adipalati, wua꞉ta solotamale kokoye wua꞉ A God ya꞉ tatle mo-malapo halemdepo. ");
INSERT INTO xla_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Amasiyama wua꞉ta inoma sumale dulu dla ipo inoma sumha꞉ha꞉lepe, ‘Di A Pepele di dla hallalo, hatlo wa꞉ hita alila hapuloma dulu dla aiyalma depo hallepe. ");
INSERT INTO xla_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Epame di solotama, wa꞉ mo kokota pulupo depame. Epame Pepele dimo dla wa꞉ta solotamale koko halomha꞉ha꞉ epapele kokoye ma ta꞉lamo sota halomha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Epame alila hapuloma dulu dla dita dlowe alisisiye halopimhalane. ");
INSERT INTO xla_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Epame di bobtalimaleye hihiyotipo woweline. Adipalati, di mape diamkadulota dia꞉ dla batalimale koko halomde hapulomaye wowelimdepo. ");
INSERT INTO xla_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Epame dia꞉ye elemala natili kokalle dla elemtaiya demiya. Amasiyama dia꞉ye Saitenta itiyamale tle alikili dla eleme woyamane.’ ");
INSERT INTO xla_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Epedeme wua꞉tapo wua꞉ amkadulota wua꞉ dla batalimale koko halati yia꞉ batalimaleye wellipe. Wua꞉ta epapelepiye, asiyama wua꞉ A Pepele di dla halatapo wua꞉ bobtalimaleye hiyotipo wowellipe. ");
INSERT INTO xla_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amasiyama wua꞉tapo wua꞉ amkadulota wua꞉ dla bobtalimale koko halati yia꞉ bobtalimaleye powelilalo wekelepiye, asiyama wua꞉ Atapo wua꞉ bobtalimaleye pohiyotipo welilowa.” ");
INSERT INTO xla_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Epame wua꞉ daya dimi inoma sumha꞉ha꞉mama ase yiskamu pepeyalimalalo sota aplalo some amha꞉ha꞉miya. Adipalati, yia꞉ daya dimi ha꞉ha꞉mama yia꞉ mila꞉pi sikemte alistame ha꞉ha꞉mdepo, opatapo yia꞉ta daya dimi ha꞉ha꞉ koko natilipo depame. Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Yia꞉ta epapele koko hamha꞉ha꞉ tle yia꞉ God tle asiyama pohalowa. ");
INSERT INTO xla_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amasiyama wa꞉ daya dimi inoma sumpollowedeme apelepiye, wa꞉ mila꞉pi woloma howahapame alisisi woloma dinapopo siyele mila꞉pi himimpollepe. ");
INSERT INTO xla_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wa꞉ta epo pollopiye, opata wa꞉ta daya dimi hala kokoye pomalanatilowa. Amasiyama opata ponatilalo wekelalo A Godtapo wa꞉ta hemele daya dimi pola kokoye natipame wa꞉ watle asiyama ka꞉dle hamilipe.” ");
INSERT INTO xla_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Epapedeme wua꞉ ase ta꞉lamo hema alisisi sikemte poposatilipame kokolupo ha꞉ha꞉miya. Adipalati, ta꞉lamo hema wua꞉ alisisi opiye musasuta dlomdepo. Epame opiye miyelo batalimdepo. Epame opiye uhalalo sotapo tuwame uhalomdepo. ");
INSERT INTO xla_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amasiyama wua꞉ Pepele dimo dla alisisi sikemte kokolupo ha꞉ha꞉iya. Adipalati, mo edla musasutapo alisisi podlomasemde, epo alisisitapo miyelo pobatalimasemde, epame uhalalo sota tuwame alisisi upohalomasemde. ");
INSERT INTO xla_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Epapedeme wua꞉ alisisi pasatale kokotapo mo hadima hutiyelepiye, wua꞉ta malamale mape edla hatitipo ha꞉ha꞉mdepo. ");
INSERT INTO xla_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Epedeme wa꞉ inomatapo wa꞉ moto pato dla tuloma epapele some halapo. Epedeme wa꞉ inomata ka꞉depo hallepiye, wa꞉ moto patota hela꞉dle dulu dla hallepe. ");
INSERT INTO xla_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amasiyama wa꞉ inomata batalimelepiye, wa꞉ moto patoye amtuwale dulu dla hallepe. Epapele dulu dla wa꞉ dla hela꞉dle elaye sumtame hallepiye, wa꞉ ikadepe sikemte amtuwale dulu dla halapo. ");
INSERT INTO xla_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Epapedeme oplamitapo dokopala so dapiyamte yu dla salladepo sela꞉mama oko haloweye po-ala꞉na. Adipalati, ya꞉ dokopala oplami hale tlo solotamama haleye allipe. Epammama ya꞉tapo dokopala oplami hale yu dla salladepo sela꞉mama ma hale yu dla posalladlowa. Epapedeme wa꞉ poka꞉dena, God dla salladepo sela꞉lalotapo matle mani dla salladepo sela꞉loweye.” ");
INSERT INTO xla_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Epedeme na꞉ wua꞉ dla atlema, wua꞉ta ha꞉ha꞉mama daya demha꞉ha꞉lowe mate epo tluka didiyemha꞉ha꞉lowe mate dla ase sikemte momalamha꞉ha꞉miya. Adipalati, dlowe alisisita koko pato pohalasema. Hao. Amasiyama wua꞉ pasakalota koko pato halapo. Epame tluka alisisita koko pato pohalasema. Hao. Amasiyama wua꞉ motota koko pato halapo. ");
INSERT INTO xla_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Epapedeme wua꞉ tea natipame malamaiya. Yia꞉ dlowe alisisiye empame ma pohauwalesemde. Epame yia꞉ dla yia꞉ta dlowe alisisi kokolumoloweye aya hawapo. Amasiyama epapele tlope wua꞉ A Pepele di dla halatapo yia꞉ye dlowe alisisi ilimhalapo. Amasiyama wua꞉ A God mila꞉pi tle teata pase koko pato pohalasema, amasiyama wua꞉tapo ya꞉ mila꞉pi tle koko patoto ha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Epedeme oplami antapo tluka alisisi mate epo daya dlowe koko mate dla sikemte momalamhalemama ya꞉ pasakaloye ma a꞉ma selemalemdi? ");
INSERT INTO xla_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Epedeme wua꞉ adipalati tluka alisisi dla sikemte momalamha꞉ha꞉ma꞉? Amasiyama wua꞉ isikimi moku dla dali haha ka꞉ka꞉dleta ha꞉ha꞉mde dla natimama malamaiya. Adipalati, yia꞉tapo yiskamu gadlowe dla oko hapame ma yia꞉ tluka podedlalimasemde. ");
INSERT INTO xla_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Epedeme na꞉ wua꞉ watle atlema, ka꞉yapa Solomonta dokopala oplami haluwa oloma edla ya꞉tapo tluka alisisi mila꞉pi ka꞉ka꞉dle didiyemhaluwapo. Amasiyama moku dla dali haha ha꞉ha꞉mde yia꞉ mila꞉pitapo Solomonta tluka didiyemhaluwa mila꞉piye tla꞉mtame halapo. ");
INSERT INTO xla_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Epedeme dali haha ka꞉dletapo wata u-uplatipo ha꞉ha꞉po depame ma alila hale dla pakasiyamalalo mo-totolemdepo. Epapele tlope Godtapo dali haha dla mepo tluka ka꞉ka꞉dle didiyemelemhalema dlepiye, na꞉ ma mikadepe dema, Godtapo wua꞉ye tluka ka꞉ka꞉dle didiyemelemhalapo. Wua꞉ ase mikadepe dle pa꞉talo so some ha꞉ha꞉miya. ");
INSERT INTO xla_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Epapedeme wua꞉ ase sikemte momalamha꞉ha꞉mama ipo atlemha꞉ha꞉miya, ‘Di dita daya mate yú mate dlowe hadima hapa꞉? Epame dita tluka didiyelowe ma hadima hapa꞉?’ demha꞉ha꞉miya. ");
INSERT INTO xla_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Adipalati, alikili sotapo ipapele alisisi yilo sikemte momalamha꞉ha꞉mdepo. Amasiyama wua꞉ A Pepele di dla halaye me-ya꞉malamana, wua꞉ta ipapele alisisi halomolowedeme solotamale himha꞉ha꞉ye. ");
INSERT INTO xla_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Epedeme wua꞉ Pepele dimo koko totamama wua꞉ Ata solotamale koko tatle ala꞉iya. Wua꞉ta epapelepiye, asiyama ya꞉tapo wua꞉ta totamha꞉ha꞉ alisisi hapulomaye wua꞉ watle hapilipe. ");
INSERT INTO xla_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Epedeme wua꞉ iyelata koko halopo puluwe dla ase sikemte momalamha꞉ha꞉miya. Adipalati, iyela kokoye e iyela kokopo. Amasiyama wua꞉ wata alila dla koko wowoyamolowe tlo momalamaiya.” ");
INSERT INTO xla_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Wa꞉ wa꞉ amkaleye batalimale oplami demiya, epalati asiyama wa꞉ye pobatalimale oplami dlowa. ");
INSERT INTO xla_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Adipalati, wa꞉tapo ya꞉mkale kokoye adipo gladlepiye, asiyama wa꞉ koko ma mepo gladlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Wa꞉ adipalati wa꞉ amkale inoma dla hakaka yemala ela tlo sikemte natimama asiyama wa꞉ inoma dla sokotalo patota ela tlo ponatilalo wekema꞉? ");
INSERT INTO xla_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Epame wa꞉ inoma dla sokotalo pato elaye ponatilalo, wa꞉ ma adipalati wa꞉ amkale dla atlemama, ‘Wa꞉ inoma dla hakaka yemala elaye holahamastali,’ demdi? ");
INSERT INTO xla_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wa꞉ ikadepe wa꞉skamu pepemalalo oplamipo. Adipalati, wa꞉ ka꞉dena, wa꞉ inoma dla sokotalo pato ela e tatle holamastloweye. Eta wa꞉ amkale inoma dla hakaka yemala elaye woloma natipo holamastlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God watle halopiliwe alisisiye esemala watle halopimiya. Adipalati, esemalaye isikimi ilame wa꞉ yellepe. Epame wa꞉ dla ka꞉ka꞉dle alisisi hutiyeye aliya dla pololemiya. Adipalati, aliyata alisisi eye dlolemsela꞉mama batalimelepe.” ");
INSERT INTO xla_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Epapedeme na꞉ wua꞉ dla atlema, wua꞉ atlanatiya. Epapelepiye, wua꞉ dla hapilipe. Epame wua꞉ totamaiya. Epapelepiye, wua꞉ natilipe. Epame wua꞉ kokoloma dla heyulumaiya. Epapelepiye, kokolomaye wua꞉ dla gowaladlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Adipalati, atlanatilalo oplamitapo koko halepe. Epame totamalalo oplamitapo koko natilipe. Epame kokoloma dla heyulumalalo oplami watle kokolomaye gowaladlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Epapedeme adulo wua꞉ daliya. Oplami antapo ya꞉ maseyemalata daya yilo amalati ya꞉ watle ewala hamimdi? ");
INSERT INTO xla_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Epame ya꞉tapo ma amalo yilo amalati wa꞉ ya꞉ watle wa꞉ha꞉le hamimdi? ");
INSERT INTO xla_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Wua꞉ batalimale so tlope, wua꞉malamana, wua꞉ yimlala dla ka꞉ka꞉dle alisisi tlo halopiliweye. Epapedeme dimalamana, A God Pepele di dla halata ya꞉ watle alisisi otomha꞉ha꞉lalo so dla alisisi ka꞉ka꞉dle hapimhalapo. ");
INSERT INTO xla_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Wua꞉ apa kokoye opata wua꞉ dla halepo depo solotamelepiye, ka꞉dena, wua꞉ tatle yia꞉ dla epapele kokoye halepe. Adipalati, Mosesta aiyalma hatitimale mate epo God tle yu hapame molo atlamalalo sota hatitimale mateta imale yia꞉ dulu kokoye ipo.” ");
INSERT INTO xla_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Epapedeme kokoloma kokotomale tle u-ulapo tuwaiya. Adipalati, Dlapa mo dla tlalo api kokolomaye pta pato epame api mape pta pato. Epapele tle opa hapulomatapo kokoloma etle u-ulapo api medla tamhalapo. ");
INSERT INTO xla_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amasiyama pasakalo apiye pta yimka꞉mala. Epame api edla ulatulalo kokoloma ma pta yimka꞉mala. Epame isikimi opa pastotapo api e natipame api etle tamhalapo.” ");
INSERT INTO xla_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ka꞉e, wolomape! Wua꞉ biskapa God yu molo atlamalalo soye woloma natiya. Adipalati, yia꞉ye kapala di tle ka꞉ka꞉dle so some pumdepo. Amasiyama yia꞉ opasi dulu tle moko esemala kakasilamale epapele some pumdepo. ");
INSERT INTO xla_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Epedeme wua꞉ yia꞉ta moto mate koko halomale tle yia꞉ta ha꞉ha꞉ kokoye malanatimdepo. Adipalati, pigi dlomoko mate epo gla꞉pi dlomoko mate biskapa dali dla pomilimasemde. ");
INSERT INTO xla_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Epedeme dlomoko dali ka꞉dletapo dlomoko ka꞉ka꞉dle siyapo tlo mimdepo. Epame dlomoko dali batalimaletapo dlomoko bobtalimale siyapo tlo mimdepo. ");
INSERT INTO xla_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Epedeme dlomoko dali ka꞉dletapo dlomoko batalimale pomisemde. Epame dlomoko dali batalimaletapo dlomoko ka꞉dle pomisemde. Hao. ");
INSERT INTO xla_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Epapele dulu dla dlomoko dali aditapo dlomoko ka꞉ka꞉dle pomilalo hallepiye, dali eye wostapame dlapa dla mistlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Epapele koko tle wua꞉ biskapa God yu molo atlamalalo soye yia꞉ta dlomoko milimale tle yia꞉ kokoye malanatilipe. ");
INSERT INTO xla_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Epedeme pase opa hapulomata Lod, Lod demha꞉ha꞉ sotapo Pepele dimo dla po-ulahetlowa. Amasiyama opa anawolotapo na꞉ A Pepele di dla halata solotamale koko tlo halomha꞉ha꞉ma꞉, ewolota hetlepe. ");
INSERT INTO xla_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Epapedeme koko gladle oloma dla opa opitapo na꞉ watle puame epo atlamyelepe, ‘Lod, Lod, di wa꞉ hi tle God yu atlamsiyamduwapo, epame wa꞉ hi tle bataliya yimlalaye opa dulu tle alikili dla dodolomsalemsiyamama ulugiyemale koko ma halomsiyamduwapo,’ demyelepe. ");
INSERT INTO xla_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amasiyama na꞉tapo yia꞉ watle asiyama epo atellepe, ‘Wua꞉ pona꞉ opa ikadepe, na꞉ tle alikili a꞉ma dla tamalaiya, wua꞉ bobtalimale sopo.’” ");
INSERT INTO xla_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Oplami antapo na꞉ yu dalepame salladepo sela꞉lepiye, ya꞉ye oplamita aya hamama munamu sikemte mumuwalepo alumiti kellepo aya halë epapele some halapo. ");
INSERT INTO xla_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Adipalati, sokomoko mate tiyo mate puame aya dla heyulati ayata me-kokalepo polaiyo. Ame adipalati, aya alumiti munamuye sikemte halopo kelliyo. ");
INSERT INTO xla_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amasiyama oplami antapo na꞉ yu dalepame posalladlalo sela꞉ma꞉, ya꞉ye oplamitapo aya hamama munamu pase mumuwallalo wekele epapele some halapo. ");
INSERT INTO xla_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Adipalati, sokomoko mate tiyo mate ya꞉ aya dla puame heyulati ayata pokokallalo dokalamhamastauwapo.” ");
INSERT INTO xla_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesuta imhalepo gudlati opa hapulomata ya꞉ta imale koko natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Adipalati, ya꞉ta imale dulu dla po-aiyalma imalalo sota imalalo epapiyo. Amasiyama ya꞉ye sikemte itiyamale oplamita imalalo epapele some halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu tamali di tle mallati opa hapulomatapo ya꞉ alotle dolumtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Epapele oloma edla kapala batalimale oplamita puame Yesu hete sitali dla polomama epo atlaiyo, “Lod, wa꞉ na꞉ ka꞉dlowe solotamelepiye, na꞉ ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Epalati Yesuta ya꞉ do mate oplami ummama epo atlaiyo, “Na꞉ wa꞉ ka꞉dlowe solotama, epedeme wa꞉ ma-ka꞉dene,” diyo. Epalati pakasiyamalalo ya꞉ kapala batalimaleta ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Epame Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ tame opa opi watle na꞉ta wa꞉ ka꞉dle kokoye atlemiyo. Amasiyama wa꞉ tame God ka꞉ epo opa ka꞉ duka dla hallalo oplami watle wa꞉ kapalata ka꞉dle kokoye nati-ine. Epame wa꞉ta ka꞉dle koko dla Mosesta atlale namkale dle alisisi mate God watle hapine, opata koko etle wa꞉ta ka꞉dle kokoye malanatilipo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kapaniyem mo dla tame woyamalati Loum opahale so omhallalo oplamita gadle yilo Yesu watle puame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Lod, na꞉ oko oplami haleye sikemte esiyeme elemama sila꞉tilowe wekepo elema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Epalati Yesuta ya꞉ watle epo atlaiyo, “Na꞉ tame ya꞉ye ka꞉dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amasiyama Loum opahale so omhallalo oplamita epo atlaiyo, “Lod, wa꞉ta na꞉ aya dla puluwe poka꞉dena. Adipalati, na꞉ batalimale oplami. Wa꞉ isikimi metle halemama yu tlo atlane, na꞉ oko oplamita ka꞉dlepo depame. ");
INSERT INTO xla_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Adipalati, na꞉ ma opa opi isili tle oko hamhalemama yia꞉ yu dla salladepo sela꞉mdepo. Epame opa opi mape na꞉ isili tle ha꞉ha꞉mama na꞉ yu dla salladepo siyamdepo. Epedeme na꞉ta na꞉ oko oplami hale watle, ‘huma tane,’ dlati ya꞉ edla tamdepo. Epame ma hale watle atlemama, ‘hema puane,’ dlati ya꞉ ma pumdepo. Epame matle hale watle, ‘wa꞉ koko i hane,’ dlati ya꞉ ma koko e hamdepo. Epapedeme wa꞉ mape isikimi yu tlo atlane, na꞉ oko oplamita ka꞉dlepo depame.” ");
INSERT INTO xla_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuta yu i dalepo yelepame ya꞉ alotle dolumtale so hapuloma watle epo atlaiyo, “Na꞉ ikadepe koko wua꞉ watle atlema. Na꞉ta Isalael mo dla sela꞉uwa dla mikadepe dle kokalle oplami ipapele ponatimdena. ");
INSERT INTO xla_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Epapedeme na꞉ wua꞉ watle atlema, opa hapuloma ta꞉lamo meyelope meyelope dle tle puame Pepele dimo dla A꞉iblaham mate epo Aisek mate epo Yokob mate yimkata daya dlowedeme puame popa꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amasiyama Yu soye alikili amtuwale dla polollepe. Epalati edla ha꞉ha꞉mama a꞉lle mate a꞉pe tetekelalimha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Epo halemama Yesuta Loum opahale so omhallalo oplami watle epo atlaiyo, “Wa꞉ aya dla ma-tane. Wa꞉ta mikadepe dle tle wa꞉ta solotamale koko eta ma-hallepe,” diyo. Epapele oloma medla Loum opahale so omhallalo oplami ya꞉ oko oplami aya dla esiyeme elaletapo ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Epame Yesuye Pita aya dla taiyo. Ya꞉ edla tame natilati Pita ya꞉ dokotapo aya dulu edla esiyeme ella natiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Epalati Yesuta a꞉ya e ya꞉ do dla hamalati esiyeleta ya꞉ tle pa꞉iyo. Epame ya꞉tapo sila꞉time daya ha꞉po Yesu watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Epapele tamila꞉la oloma edla opatapo bataliya watalo so hapulomaye Yesu hala dla hohopo pumhalaiyo. Epalati ya꞉tapo yu itiyamale mate bataliya yimlalaye opa dulu tle alikili dla dodolomsalepame esusulumale so opa hapuloma mape ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Epedeme God tle yu hapame molo atlalo oplami Aisayata atlamale yu mate ala꞉lowedeme apiyo. Adipalati, ya꞉ta ipo atluwapo, “Ya꞉tapo dia꞉ dla hutiye esusulumale koko hapulomaye ma ya꞉ta halomama dia꞉ tlo ka꞉ka꞉depo meluwapo.” ");
INSERT INTO xla_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesutapo opa hapulomata ya꞉ hala dla puame alumyela natipame ya꞉ alotle tlalo so watle epo atlaiyo, “Di kaula seme dla ulluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Epalati oloma medla aiyalma imalalo oplami haleta puame ya꞉ watle epo atlaiyo, “Imalalo oplami, wa꞉ta hadima adipo tamsela꞉lepiye, na꞉ wa꞉ dolumsela꞉lowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu asiyama ya꞉ watle epo atlaiyo, “Moku dla moko esemalata ha꞉ha꞉laloye me-ha꞉ha꞉po, epame tea hapulomata hutiyelalo etoye me-popa꞉po. Amasiyama Opa Yami dla ya꞉ta ellalo ayaye pohalasema, hawa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Epapalati opa opi Yesu alotle dolumsiyamale so dulu dla oplami haletapo Yesu watle epo atlaiyo, “Lod, na꞉ wa꞉ dolumtlowe solotama. Amasiyama wa꞉ aseka na꞉ dla alila hamine, na꞉ta na꞉ a polati hamatilipo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amasiyama Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ dolumpuane. Adipalati, soko tle palli sotapo miyelo palli soye hatimha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Epame Yesu mate epo ya꞉ alotle tlalo so mate koa dla tulume alupame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yia꞉ tamha꞉ha꞉lati sokomoko patota bibikilimama ulo patotota silliyo. Epame ulo patotota sillimama yia꞉ koa dla yúta pasataiyo. Amasiyama Yesuye koa dulu dla sikemte pa꞉tame elaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Epalati Yesu ya꞉ alotle tlalo sota tuwame ya꞉ esesa꞉mama epo atlaiyo, “Lod, wa꞉ di gadene. Di yú dla tutula꞉la yakoma,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Amasiyama Yesuta elale tle yelepo yia꞉ watle epo atlaiyo, “Wua꞉ adipalati sikemte wowota꞉ma꞉? Wua꞉ta mikadepe dleye pta yimka꞉sikili ikadepe,” diyo. Epame ya꞉ sila꞉time sokomoko mate ulo mateta keidlepo depame yu itiyamale mate atlaiyo. Epalati sokomoko mate epo ulo mateta medla keidlati kaulata ma woloma keilipo elaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Epalati Yesu ya꞉ alotle tlalo sota koko i natipame yiyelepame wowota꞉mama epo atlamyaiyo, “Oplami iye adipapele oplamita꞉? Mosisi mate epo ulo mateta ya꞉ yu dla dalepame keidlepo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Epame Yesu kaula seme dla ulumyame Gadala mo so ta꞉la dla tame woyamaiyo. Ya꞉ edla tame woyamalati bataliya watalo so opa dapiyamteta popliyele hatili mo tle ya꞉ hala dla puame wowoyamaiyo. Opa dapiyamte iwolota yiyilamsiyamama sikemte itiyamale mate siyamalati mo sota popliyele hatili api etle posiyamasemdiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Epalati bataliya watalo sotapo puame Yesu watle yu teta꞉le mate epo atlaiyo, “God Yami, wa꞉ dia꞉ dla apa koko hala puo? Wa꞉ye Godta alila himili ala me-hallati duka medla dia꞉ye mo-batalimala puo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Yia꞉ta ha꞉ha꞉ mateka꞉pi medla aliya halo hapulomatapo ketame modlomsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Epalati bataliyatapo Yesu watle otomama epo atlaiyo, “Wa꞉ dia꞉ye alikili dla dodolomsallowedeme apelepiye, ka꞉dena, wa꞉ dia꞉ye aliya dulu dla tuwaiya dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Epapalati Yesuta yia꞉ watle aliya dulu dla tuwaiya diyo. Epapele oloma edla bataliya yimlalatapo opa dapiyamte iwolo tle u-ulapo tame ma aliya dulu dla tumulaiyo. Epalati aliya hapulomatapo donapi di tle ullumtulume yú dla tutula꞉mama paliyo. ");
INSERT INTO xla_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aliya omha꞉ha꞉lalo sotapo koko i natipame ma hapele yia꞉ mo dla ullumtame aliya dla koko woyamale mate epo opa dapiyamteta ma ka꞉dle koko mate atlamtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Epalati mo dulu edla ha꞉ha꞉lalo so opa hapulomatapo Yesu natila taiyo. Yia꞉ tame ya꞉ natipo ya꞉ watle otomama epo atlamyaiyo, “Wa꞉ di mo itle alikili a꞉ma tane,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Epame Yesu ya꞉ ma koa dulu dla posokolepame ilame ya꞉ta hallalo mo Kapaniyem dla uliyo. ");
INSERT INTO xla_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ya꞉ edla yame woyamalati opatapo akoloyale oplamiye wa꞉ya dla himpame ya꞉ hala dla hamampumulaiyo. Epalati Yesu yia꞉ta mikadepe dle natipame akoloyale oplami watle epo atlaiyo, “Namkale, wa꞉ ase sikemte wota꞉miya. Wa꞉ bobtalimaleye mo-hiyotipame wellipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Amasiyama aiyalma imalalo so opa opitapo Yesuta ipo atla dalepame allimama ipo momalampopa꞉iyo, “Oplami iye God hi mate putlopo atlalepo. Adipalati, hatlo God tlo ya꞉ dla batalimale hiyotimolowe itiyamale elapo,” dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amasiyama Yesu yia꞉ta momalamale ma-natipame epo atlaiyo, “Wua꞉ adipalati na꞉ta atlale kokoye batalipo momalampopa꞉mama sikemte allimpopa꞉ma꞉? ");
INSERT INTO xla_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wua꞉ akoloyale oplami i natiya. Ya꞉ dla adipo atlowe tlo kokaleta꞉? ‘Na꞉ta wa꞉ batalimaleye ma-hiyostalepo,’ dlowe kokota kokaleta꞉? O ‘Wa꞉ sila꞉time ma-tane,’ dlowe kokota kokaleta꞉? ");
INSERT INTO xla_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Epedeme Opa Yamita ta꞉lamo hema batalimale hiyotimolowe dla itiyamale hamsela꞉ye wua꞉ta natilipo depame na꞉tapo wata akoloyale oplami iye ka꞉dlowepo.” Epo atlepame Yesutapo akoloyale oplami watle epo atlaiyo, “Wa꞉ sila꞉time wa꞉ wa꞉ya hame wa꞉ aya dla ma-tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Epalati akoloyale oplamita sila꞉time ya꞉ aya dla ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Epame opa hapulomata koko i natipo yiyelepame God hi di dla ta꞉demyaiyo. Adipalati, Godta itiyamale iye opa dla hamili natipame. ");
INSERT INTO xla_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Koko i gudlati alotle Yesu ma tamama natilati ta꞉kis mani halomalalo oplami Ma꞉tiyuta ta꞉kis mani halomalalo aya dulu dla polla natiyo. Epalati ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ dolumpuane,” diyo. Epalati ya꞉ sila꞉time Yesu mate taiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesutapo ya꞉ alotle tlalo so mate Ma꞉tiyu aya dla hetame daya dempopa꞉lati ta꞉kis mani halomalalo so mate epo batalimale so mateta puame yia꞉ mate hatlo godepo daya dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Amasiyama Pa꞉lisi sotapo koko i natipame allimama Yesu ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ imalalo oplami adipapalati ta꞉kis mani halomalalo so mate epo batalimale so mate daya dempoloma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Epalati Yesuta yu i dalepame asiyama epo atlaiyo, “Esiyele pa꞉talo sotapo dakopala ilalo oplami hala dla potasemde. Amasiyama isikimi esusulumale sotapo dakopala ilalo oplami hala dla tamdepo. ");
INSERT INTO xla_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Epedeme God yu buka dla ipo atlapo, ‘Na꞉ ya꞉mkale gadlowe tlo sikemte malamama asiyama wua꞉ta na꞉ dla alinepi poyupo hapilowe koko tlo pase malamasemde,’ depo. Epapedeme wua꞉ tame yu ipo atla ya꞉ dulu kokoye woloma totamaiya. Adipalati, na꞉ta puwaye, ka꞉ka꞉dle soye sisilamolowedeme popuana. Amasiyama bobtalimale so tlo sisilamolowedeme puwapo.” ");
INSERT INTO xla_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Alila haletapo Yon ya꞉ alotle tlalo sota puame Yesu watle epo atlaiyo, “Dia꞉ mate epo Pa꞉lisi so mate inoma sumha꞉ha꞉mama daya aiyalma depo ha꞉ha꞉mdepo. Ame adipalati wa꞉ alotle tlalo so tlo daya po-aiyalma dlalo ha꞉ha꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Epalati asiyama Yesuta yia꞉ watle wayu mate epo atlaiyo, “A꞉ya halalo oplamita a꞉ya halowedeme daya dinapopo yimkadulo sisilamelepe. Epalati yimkadulota puame, dayaye aiyalma depo popa꞉pa꞉? Hao. Yia꞉ sisiyele mate a꞉ya halalo oplami mate popa꞉mama dayaye yimkata dempopa꞉lepe. Amasiyama alila haleta a꞉ya halalo oplamiye yia꞉ tle alikili dla hamame telepiye, eta yia꞉tapo daya aiyalma depo popa꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu ma wayu mate epo atlaiyo, “Oplamitapo tluka takala dla tluka amko ketahame badepo podedlemasemde. Adipalati, tluka amkota itiyamama tluka takalaye tallatallademama opokoko sikemte pato dlepe. ");
INSERT INTO xla_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Epedeme matle oplamitapo wain yú amkoye aliya kapalata ita iwale takala dla posimasemde. Adipalati, wain yú amkota itiyamama aliya kapalata iwale ita takalaye gladlati wain yúye alikili dla olotlepe. Epapedeme ka꞉dena, wain yú amkoye woloma aliya kapalata iwale ita amko dla simoloweye. Epapelepiye, eta wain yú mate epo ita mate pobatalimolowa.” ");
INSERT INTO xla_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu yu ala atlempollati inoma sumalalo aya omhallalo oplamita puame ya꞉ hete sitali dla heodepo polomama epo atlaiyo, “Na꞉ amseyemalaye ala poa. Epedeme wa꞉ puame ya꞉ta ka꞉dlepo depame wa꞉ dotapo ya꞉ye umane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Epalati Yesu mate epo ya꞉ alotle tlalo so mate sillipame oplami ya꞉ mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Yia꞉ ala me-tamaha꞉ha꞉lati a꞉ya hale 12 sokomoko dulu dla ya꞉ toto koko natimama ka꞉lliwe pa꞉le esiyele hampollalota yia꞉ mate tamama epo malamtaiyo, “Na꞉ isikimi Yesu tluka ipi tlo umili, eta na꞉ye ka꞉dlepe,” diyo. Ya꞉ epo malapame opa dulu tle tuwame Yesu tluka ipi umaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Epapele oloma medla Yesu helestame a꞉ya natipo ya꞉ watle epo atlaiyo, “Namkale, wa꞉ ase wota꞉miya. Wa꞉ta mikadepe dletapo wa꞉ye ma-ka꞉dlepo,” diyo. Epalati a꞉yatapo oloma medla ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Epame Yesu ma etle tame inoma sumalalo aya omhallalo oplami aya dla hetaiyo. Yia꞉ edla hetame natilati opa opitapo dupa kolle salaye pitikako epapele mate sesa꞉lalimyaiyo. Epalati opitapo wowolimyemama a꞉lemyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesuta koko e natipame yia꞉ watle epo atlaiyo, “Wua꞉ alikili a꞉ma taiya. Amseyemala iye popowame elasema. Amasiyama ya꞉ye isikimi elema,” diyo. Epalati yia꞉ta hapulomata Yesu yu dalepame pomikadepe dlalo isikimi eimelemyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amasiyama Yesutapo opa hapulomaye alikili dla posalepame amseyemalata elale aya dla tuwame ya꞉ do dla hamaiyo. Epalati amseyemalata mo-powame elale tle ma-sila꞉tiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Epapalati mo hapulomata koko iye ma-dlalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu aya etle tulume tamhallati inoma pa꞉talo so opa dapiyamtetapo ya꞉ alotle dolumtamalaiyo. Yia꞉ tamalemama yu teta꞉limale mate ipo atlamtamalaiyo, “Deibidi Yami, wa꞉ di polowamama di gadene,” demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Epame Yesu ma aya dulu dla hetlati inoma pa꞉talo so iwolota ya꞉ hala dla pumulaiyo. Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ye ikadepe na꞉ta wua꞉ ka꞉dlepe demama na꞉ hala dla pumulo?” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Yao Lod, di mikadepe dema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Epapalati Yesuta yia꞉ inoma dla ummamama epo atlaiyo, “Wua꞉ta mikadepe dle koko tle wua꞉ dla wua꞉ta solotamale kokota woyamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Epalati yia꞉ inomatapo ma-ka꞉ka꞉diyo. Amasiyama Yesutapo yu itiyamale mate yia꞉ watle epo atlaiyo, “Wua꞉ tame koko iye opa opi dla atlamiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amasiyama yia꞉ta dapiyamteta tame opa hapuloma dla Yesu kokoye atlamtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Inoma pa꞉talo so ala alikili a꞉ma woyapo tamha꞉ha꞉lati opata ma bataliya walle oplamiye Yesu hala dla seme pumulaiyo. Oplami iye bataliyatapo ya꞉ dulu dla halemama yu pa꞉po halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Epapeleye Yesutapo bataliya yemalaye ya꞉ tle alikili a꞉ma dla dodolomalati ya꞉tapo matle yukamolowe kotiyamaiyo. Epalati opa hapulomata koko i natipo yiyelepame epo atlamyaiyo, “Di Isalael mo dulu dla ipapele koko ponatimha꞉ha꞉mdena,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amasiyama Pa꞉lisi sotapo epo atlamyaiyo, “Bataliya yimlala yia꞉ dokopala oplamitapo Yesu watle itiyamale hamilati itiyamale etle bataliya yimlalaye alikili dla dodolomsalemsela꞉ma,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Epedeme Yesuta mo hapuloma dulu dla sela꞉mama Yu sota inoma sumalalo aya hapuloma dla ka꞉dle yu Pepele dimo kokoye imsela꞉mdiyo. Epame esusulumale so hapuloma ma ka꞉ka꞉demsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Epapeleye Yesutapo opa hapuloma natipame sikemte polowamaiyo. Adipalati, yia꞉ye gadle pa꞉le ha꞉ha꞉mama sipi aliyata yia꞉ omhallalota pa꞉lati ha꞉ha꞉mdiye, epapele some popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Epo halemama Yesutapo ya꞉ alotle tlalo so watle epo atlaiyo, “Osalo dulu dla alisisi hapulomata ma-hauwallowe oloma dla ha꞉ha꞉ma. Amasiyama alisisi hauwallowe so tlo pase pasatana. ");
INSERT INTO xla_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Epedeme wua꞉ inoma sumale yu mate osalo omhallalo oplami dla atlaiya, ya꞉tapo ya꞉ osalo dulu dla emale alisisi hauwallalo soye taiya dlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesutapo ya꞉ alotle tlalo so 12 sisilapame yia꞉ watle itiyamale hamiyo, yia꞉tapo opa dulu tle bataliya yimlalaye alikili dla dodolomsalemsiyamama esusulumale so ma ka꞉ka꞉demsiyamelepo depame. ");
INSERT INTO xla_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Epapedeme Yesutapo Taiya dle so 12 iwoloye hohomaiyo. Saimon, ya꞉ hi hale Pita, epame ya꞉ ei Endulu, epo Sebedi ya꞉ akimlala dapiyamte Yeims mate epo ya꞉ ei Yon mate, ");
INSERT INTO xla_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","epame Pilipi, epo Batolome, epo Tomas, epo ta꞉kis mani halomalalo oplami Ma꞉tiyu, epame Alpiyes yami Yeims, epo Tadiyes, ");
INSERT INTO xla_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","epame Loum gamani so mate opahale demhalale oplami Saimon, epo Yudas Iskaliyot, alotle Yesuye opahale so do tama dla homelle oplami. ");
INSERT INTO xla_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesuta opa 12 iwoloye taiya demama yia꞉ watle yu ipo hamiyo, “Wua꞉ tamalemama po-Yu so mate epo Samaliya so mate dla potlowa. ");
INSERT INTO xla_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amasiyama Isalael so opa dla telepe. Adipalati, yia꞉ye sipi aliya halota yia꞉ omhallalo pa꞉le ha꞉ha꞉mdiye, epapele some ha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Epedeme wua꞉ tamama God yu ipo atlamtelepe, ‘Pepele dimo kokoye mo-mateka꞉pi halema,’ demtamellepe. ");
INSERT INTO xla_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Epammama esusulumale so ma ka꞉ka꞉dlepe, epo palli so dla ma pasakalo hapilipe, epame kapala bobtalimale so ma ka꞉ka꞉dlepe, epame bataliya yimlalaye opa dulu tle alikili dla dodolomsallepe. Na꞉ta wua꞉ watle itiyamale hami iye asiyama pa꞉na. Epapedeme wua꞉ ma opa gagademsiyamama asiyama yilo po-otomsiyamolowa. ");
INSERT INTO xla_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wua꞉ tamama mani mate pohalopo tlowa. ");
INSERT INTO xla_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Epame duli pohalopo tlowa. Epame sede ma dapiyamte pohalopo tlowa. Epo hete alisisi ma pohalopo tlowa. Epame dali ku ma pohalopo tlowa. Adipalati, oko soye yia꞉ oko asiyama halomdepo. ");
INSERT INTO xla_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wua꞉ mo hadima telepiye, wua꞉ edla tame koko ka꞉dle oplami hale totamelepe. Wua꞉ epapele oplami hale natipame ya꞉ mate ya꞉ aya dla ha꞉ha꞉lepe. Epame wua꞉ta mo etle mo-tlowedemeta aya eye saliyomta demsiyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wua꞉ aya hadima eleme hetlepiye, wua꞉ aya edla ha꞉ha꞉lalo so watle namkale dle yu atlemama, ‘Godta sadleta wua꞉ mate hallepe,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Epalati aya dulu edla ha꞉ha꞉lalo sota wua꞉ mate namkale demama sadle mate wua꞉ye elemhetlepiye, wua꞉ta namkale dle yu atlamaletapo yia꞉ mate hallepe. Amasiyama yia꞉ta wua꞉ye pe-elemhetlalo wekelepiye, wua꞉ta namkale dle yu atlamaletapo yia꞉ mate pohallowa. ");
INSERT INTO xla_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Epame wua꞉ mo hadima tlati opata wua꞉ye pe-elemhetlalo wekemama wua꞉ yu ma podallalo wekelepiye, wua꞉ mo e saliyome tlowedeme yia꞉ mo sokopeta wua꞉ hete dla popolahaleye hihiyollepe, Godta kasilamale kokota yia꞉ dla pua kokoye imolowedeme. ");
INSERT INTO xla_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Epedeme na꞉ mikadepe koko wua꞉ dla atlema. Koko gladle oloma edla wua꞉ alilalo so epapeleye asiyama sikemte wotiyalle pato halepe. Amasiyama Sodom so mate epo Gomola so mate yia꞉ asiyama wotiyalle yimka꞉mala halepe.” ");
INSERT INTO xla_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Epapedeme na꞉ wua꞉ye sipi aliya halo epapele some moko esemala kakasilamale dulu dla taiya dema. Epedeme wua꞉ ilamata kakaletalimale epapele some ha꞉ha꞉iya. Epame wua꞉ ma banapita ullu pa꞉pame salladepo sela꞉mdiye, wua꞉ ma epapiya. ");
INSERT INTO xla_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Epedeme wua꞉ wolomape. Opata wua꞉ye hohopame koko gladlalo aya dla eleme ta demha꞉ha꞉lepe. Epame wua꞉ye yia꞉ inoma sumalalo aya dla eleme hetame hohopole demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Epo na꞉ koko tle wua꞉ye dokopala so patoto mila꞉pi dla elemhetame ipila꞉ demha꞉ha꞉lepe. Amasiyama wua꞉ta edla na꞉ kokoye yia꞉ watle epo po-Yu so dla atlama demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Epapele dulu dla opata wua꞉ye koko gladle aya dla hohopo hetlati wua꞉ ase wua꞉ta atlowe dla sikemte pomomalamolowa. Adipalati, oloma edla Hela꞉dle Sokotapo wua꞉ta atlowe malamale ka꞉dleye hapilalo hallepe. ");
INSERT INTO xla_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Epalati wua꞉ muwolo poyuhalowa, amasiyama God ya꞉ Hela꞉dle Sokota wua꞉ mate halemama yukamelepe. ");
INSERT INTO xla_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Oloma edla oplamitapo ya꞉ bapa mate ya꞉ ei mateta pallipo depame yia꞉ allimha꞉ha꞉ so dla homellepe. Epame atapo ya꞉ yimlala dla ma mepapelepe. Epame akimlalatapo sillipame yia꞉ adulo mate epo waidulo mate palliwe dla eleme telepe. ");
INSERT INTO xla_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Adipalati, wua꞉ta na꞉ dla mikadepe dle koko tle opa hapulomata wua꞉ dla elle pato himha꞉ha꞉lepe. Amasiyama antapo ya꞉ta mikadepe dleye kokalepo halemama mosukulu dla tame woyamelepiye, ya꞉ pasakalo hallowe halepe. ");
INSERT INTO xla_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Epedeme wua꞉ opata wua꞉ dla wotiyalle hamilati ma etle mo hale dla potlepe. Epame ma mo edla ha꞉ha꞉lalo sota wua꞉ dla wotiyalle hamilati wua꞉ ma mo hale dla pota demsiyamelepe. Amasiyama na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ ala mepamsiyamalati Opa Yamita medla me-pulupe. ");
INSERT INTO xla_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Epedeme imalalo oplamiye ya꞉ alotle tlalo sota potla꞉mtame halasema. Epame oko halalo sota yia꞉ dokopala oplamiye potla꞉mtame ha꞉ha꞉sema. ");
INSERT INTO xla_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Epapele dulu dla yia꞉ imalalo oplami dla apa kokota woyamelepiye, ya꞉ alotle tlalo so ma ma-dinapopo ha꞉ha꞉lepe, mepapele kokota yia꞉ dla woyamalala depame. Epame dokopala oplami dla apa kokota woyamelepiye, ya꞉ oko halalo oplami ma ma-dinapopo hallepe, ya꞉ dla mepapele kokota woyamalala depame. Epedeme aya ya꞉ ata hi batalimale hapo hallepiye, aya dulu edla ha꞉ha꞉lalo so ma hi batalimale halopo ha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Epapedeme wua꞉ alimha꞉ha꞉ so dla ase sikemte wowota꞉miya. Adipalati, hemele towalipo hutiye koko hapulomaye ma haliyamale dla bobotimatimelepe. Epame opata podallalo wekemduwa kokoye ma haliyamale dla atlamelepe. ");
INSERT INTO xla_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Epedeme na꞉ta wua꞉ mate sela꞉mama hemele atlamsela꞉ koko hapulomaye ma wua꞉tapo haliyamale dla bobotimatimelepe. Epame na꞉ta apa kokoye wua꞉ dla hemele molo yu atlamsela꞉ma꞉, ma alotle aya dopuko di tle koko eye yu sisiyatlemale mate atlamelepe. ");
INSERT INTO xla_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Epedeme wua꞉ opa wua꞉ alimha꞉ha꞉ so natipo ase wowota꞉mha꞉ha꞉miya. Adipalati, yia꞉ isikimi wua꞉ moto tlo potipame ma koko hale haloweye po-ala꞉na. Amasiyama wua꞉ hatlo God tlo wowota꞉mha꞉ha꞉iya. Adipalati, ya꞉tapo wua꞉ motoye potipame matle wua꞉ sokoye Dlapa mo dla ka꞉ka꞉timoloweye ala꞉na. ");
INSERT INTO xla_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Epedeme wua꞉ malamaiya, daliyama tea yimlala dapiyamteye isikimi palli manita halomdepo. Amasiyama dulu edla tea yimlala haleta poloweye wua꞉ A God tatle malamdepo. ");
INSERT INTO xla_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Epapedeme God me-ya꞉malamana, wua꞉ dokopala dla kokosase hapuloma ha꞉ha꞉ye. Adipalati, ya꞉tapo hapuloma eye ma-sesa꞉uwapo. ");
INSERT INTO xla_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Epapedeme wua꞉ ase sikemte wowota꞉mha꞉ha꞉miya. Adipalati, God mila꞉pi tle teata koko pato pohalasema. Hao. Wua꞉tapo koko pato ha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Epedeme oplami antapo opa mila꞉pi tle halemama ya꞉ta na꞉ dla mikadepe dle kokoye botomastlepiye, asiyama na꞉tapo na꞉ A God Pepele di dla hala ya꞉ mila꞉pi tle ya꞉ye na꞉ oplami dlowepo. ");
INSERT INTO xla_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amasiyama oplami antapo opa mila꞉pi tle halemama ya꞉ta na꞉ dla mikadepe dle kokoye botomastlowe wota꞉lepiye, asiyama na꞉tapo na꞉ A God Pepele di dla hala ya꞉ mila꞉pi tle ya꞉ye welliwepo.” ");
INSERT INTO xla_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Epedeme wua꞉ na꞉tapo ta꞉lamo hema sadle hampuwayo depo malamha꞉ha꞉miya. Adipalati, na꞉ sadle koko pohampuana, asiyama duka gladle kokoye hampuwapo. ");
INSERT INTO xla_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Epapedeme na꞉ta puwa ya꞉ dulu koko epapena. Akimlalatapo me-yia꞉ adulo mate duka gladle ellepe. Epame utukakatapo me-yia꞉ waidulo mate duka gladle ellepe. Epame meneledulotapo me-yia꞉ meneledulo mate duka gladle ellepe. ");
INSERT INTO xla_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Epapele dulu dla mo-wa꞉ asiyadulotapo wa꞉ mate duka gladle ellepe. ");
INSERT INTO xla_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oplami antapo ya꞉ a mate epo ya꞉ wai mate epo yami mate epo yoti mate dla sikemte malamale pato himhalemama, asiyama na꞉ dla malamale yimka꞉mala himhallepiye, ya꞉ye na꞉ dolumtlowe po-ala꞉na. ");
INSERT INTO xla_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Epame oplami antapo meyelo ya꞉ dali yekelemhimili maka꞉himme na꞉ dolumpuluwe allipiye, ya꞉ye na꞉ mate po-ala꞉na. ");
INSERT INTO xla_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Epedeme oplami antapo ya꞉ pasakalo meyelo omhalli dlepiye, ya꞉ pasakaloye haodlepe. Amasiyama oplami antapo na꞉ koko dla ya꞉ pasakalo haodlepiye, ya꞉ halepo halepo pasakalo halepe.” ");
INSERT INTO xla_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Oplami antapo wua꞉ye ya꞉ aya dla semhetlepiye, ya꞉ye na꞉ semhetamama apopo. Epedeme oplami antapo na꞉ye semhetlepiye, ya꞉ye na꞉ A na꞉ tane duwaye e semhetamama apelepe. ");
INSERT INTO xla_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Epame oplami antapo God tle yu hapame molo atlalo oplamiye ya꞉ aya dla semhetlepiye, ya꞉ God tle yu hapame molo atlalo oplamita asiyama haloweye, ya꞉ ma asiyama epapele halepe. Epame ma oplami antapo ka꞉dle oplamiye ya꞉ aya dla semhetlepiye, ya꞉ye ka꞉dle oplamita asiyama haloweye, ya꞉ ma asiyama epapele halepe. ");
INSERT INTO xla_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Epame oplami antapo na꞉ dolumalalo oplamita yú ta꞉lati yú tipo hamilipiye, ya꞉ ma asiyama pato halepe. Epedeme koko iye ikadepepo.” ");
INSERT INTO xla_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuta ya꞉ alotle tlalo so 12 dla koko i atlamhalepo gudepame ma Ga꞉lili mo pato dulu dla God yu imsela꞉la taiyo. ");
INSERT INTO xla_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yon opa yú dla ka꞉ka꞉timalalo oplamitapo amtuwale aya dulu dla halemama Kelisota koko halomsela꞉le dalepame ya꞉ alotle tlalo so opa opi watle Yesu hala dla taiya diyo. ");
INSERT INTO xla_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Epalati yia꞉ tame Yesu hala dla woyapo ya꞉ watle epo atlaiyo, “Yonta dia꞉ye wa꞉ watle taiya demama yu ipo hami, ‘Wa꞉ ikadepe Keliso, dita omha꞉ha꞉uwa oplamita꞉? O, di ala oplami hale tlo me-omha꞉ha꞉pa꞉?’ de,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Epalati asiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ ma ilame tame Yon watle wua꞉ta tlamale koko mate epo dlalle koko mate atlamaiye. ");
INSERT INTO xla_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Adipalati, inoma pa꞉talo sota ma tlamapo. Epame akoloyalemale so mape ma ka꞉ka꞉depo siyamapo. Epame kapala bobtalimale so mape ma ka꞉ka꞉depo siyamapo. Epame molo pa꞉talo so mape ma ka꞉ka꞉depo dlalemsiyamapo. Epame palli so mape ma sillipo siyamapo. Epame ka꞉dle yuye atali sota ma-dalepo. ");
INSERT INTO xla_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Epapedeme opa anawolota na꞉ koko tle pokustamtlalo wekelepiye, Godta yia꞉ dla siyelepe.” ");
INSERT INTO xla_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yon ya꞉ alotle tlalo sota ma ilame tlati Yesuta opa watle Yon koko atlemama epo atlaiyo, “Wua꞉ dalupa dulu dla apa koko natila tauwa? Mosisita osamokolo dla yumama holumhallati natila tauwa? ");
INSERT INTO xla_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wua꞉ oplamita tluka ka꞉ka꞉dle didiyepo pollati natila tauwa? Hao. Adipalati, tluka ka꞉ka꞉dle didiyelalo soye dokopala sota popa꞉lalo aya dla popa꞉mdepo. ");
INSERT INTO xla_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Epame wua꞉ God tle yu hapame molo atlalo oplami natila tamama apuwa? Yao, wua꞉ta tame natiwa oplami Yon etapo God tle yu hapame molo atlamalalo so ka꞉yapa ha꞉ha꞉uwaye ma-tla꞉mtame halapo. ");
INSERT INTO xla_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Adipalati, God yu buka dla ipo atlaleye Yon koko atlapo, ‘Na꞉tapo na꞉ yu hamsela꞉lalo oplami tatle tane dlowepo. Ya꞉tapo wa꞉ apiye dinapelepo depame,’ depo. ");
INSERT INTO xla_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Epapedeme na꞉tapo ikadepe kokoye wua꞉ watle atlema. Yonta ka꞉yapa ha꞉ha꞉mpuwa opa hapulomaye tla꞉mtame halapo. Amasiyama epapele tlope oplami antapo Pepele dimo koko dla yimka꞉mala depo hallepiye, ya꞉tapo Yonye tla꞉mtame halapo. ");
INSERT INTO xla_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Epedeme Yonta God yu atlamsela꞉uwa oloma etle kotiyapo puame wata oloma hema batalimale sotapo Pepele dimo kokoye batalipo hamastlowedeme sikemte akumyemama ma yia꞉ta eledostla yakomduwapo. ");
INSERT INTO xla_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yon ala pohallalo hallati Mosesta aiyalma hatitimale mate epo God tle yu hapame molo atlamalalo sota hatitimale mateta Pepele dimo kokoye atlamhaluwapo. ");
INSERT INTO xla_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Epedeme wua꞉ yia꞉ta atlamale yu hema mikadepe dlepiye, eta wua꞉tapo Yonye ma Ilayapo dlepe. Adipalati, God yu bukatapo Ilayata puluwe kokoye ma-atlamhaluwapo. ");
INSERT INTO xla_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Epedeme molo watalo so, wua꞉ yu iye woloma daliya.” ");
INSERT INTO xla_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Epame Yesu matle epo atlaiyo, “Wata oloma hema opa ha꞉ha꞉ye adipapele sota꞉? Yia꞉ye akimlala yimka꞉sikili some api duka dla popa꞉mama yimkadulo watle asiyama atla asiyama atla dempopa꞉mama ipo atlampopa꞉mdepo, ");
INSERT INTO xla_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Dita siyele sala dodolumpopa꞉lati wua꞉ta posiyalemdena. Epame dita dupa kolle sala dodolumpopa꞉lati wua꞉ta po-a꞉lemdena,’ demdepo. ");
INSERT INTO xla_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wua꞉ ma epapele so some ha꞉ha꞉po. Adipalati, Yon opa yú dla ka꞉ka꞉timalalota puwaye, ya꞉ daya mate wain yú mate podemsela꞉na. Amasiyama wua꞉ta ya꞉ye bataliya walena demyapo. ");
INSERT INTO xla_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Epame Opa Yami mape mo-puwapo. Ya꞉ta puame daya mate wain yú mate demsela꞉lati wua꞉ta ya꞉ye daya mate wain yú mate sikemte dlalo oplami demyapo. Epame wua꞉tapo ya꞉ye ta꞉kis mani halomalalo so mate epo batalimale so mate namkale dlalo oplami demyapo. Amasiyama God ya꞉ opata ka꞉depo ha꞉ha꞉la natipame opa opitapo e natimama God kokoye ka꞉pi demha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesutapo mo opi dla ulugiyemale koko hapuloma halomsela꞉lati mo so opata yia꞉ bobtalimale tle poheheletimalalo wekelati ya꞉tapo ipapele so koko dla sikemte atlemama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ka꞉e, Kolasin so mate epo Betsaida so mate, wua꞉ wolomape! Wotiyalle patota wua꞉ye omelapo. Adipalati, na꞉ta wua꞉ mo dla ulugiyemale koko patoto halomsela꞉uwa epapeleye ma po-Yu so mo Taya mate epo Saidon mate dla halomsela꞉matiye, yia꞉ pakasiyamalalo yia꞉ bobtalimale tle heheletimelemla. Epame yia꞉ta yia꞉ bobtalimale koko tle ma-heheletimale kokoye nati-imama tluka bobtalimale didiyepame tilepu huhutapo siyamelemla. ");
INSERT INTO xla_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Epedeme na꞉ wua꞉ dla atlema, Godta koko gladle oloma dla Taya so mate epo Saidon so mate dla wotiyalle yimka꞉mala hamilipe. Amasiyama Kolasin so wua꞉ mate epo Betsaida so wua꞉ mate dla wotiyalle pato hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amasiyama Kapaniyem so, wua꞉ alila oloma edla wua꞉ye Pepele dimo dla ta꞉dlepo depo momalaha꞉ha꞉ma꞉? Hao. Wua꞉ye hohopame Dlapa mo dla ka꞉ka꞉timelepe. Na꞉ta wua꞉ mo dla ulugiyemale koko patoto halomsela꞉uwa epapeleye ma Sodom mo dla halomsela꞉matiye, wata oloma hema Sodom moye pobatalimalalo ala me-hallemla. ");
INSERT INTO xla_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amasiyama na꞉ wua꞉ dla atlema, Godta koko gladle oloma edla Sodom mo so dla wotiyalle yimka꞉mala hamilipe. Amasiyama Kapaniyem so wua꞉ dla wotiyalle pato hamilipe.” ");
INSERT INTO xla_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Epalati Yesuta epo atlaiyo, “A, pepele di mate epo ta꞉lamo mate wa꞉tapo Lod depo halapo. Epedeme na꞉ wa꞉ dla siyele hamima. Adipalati, wa꞉tapo wa꞉ mo koko hemele hutiyeye, koko malamale so dla pobotomastlalo wekuwapo. Amasiyama wa꞉tapo isikimi koko yeitamale so dla botomastauwapo. ");
INSERT INTO xla_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yao A, ikadepe, koko iye wa꞉ta solotamale kokopo.” ");
INSERT INTO xla_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu ma opa watle epo atlaiyo, “Na꞉ Atapo koko hapulomaye na꞉ watle ma-halopiwapo. Oplami haletapo Yamiye poya꞉malamana. Amasiyama hatlo A tlo Yamiye ya꞉malamana. Epame oplami haletapo Aye poya꞉malamana. Amasiyama hatlo Yami tlo Aye ya꞉malamana. Epame opa anawolo dla Yamita A kokoye botomastlowe solotamelepiye, opa ewoloye A kokoye yia꞉ ma malamelepe. ");
INSERT INTO xla_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Epedeme opa anawolotapo upiyele alisisi didiyepo siyamama susukalle mate siyama꞉, wua꞉ na꞉ hala dla puaiya. Epalati na꞉tapo wua꞉ watle hedle hamilowepo. ");
INSERT INTO xla_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Epame na꞉ta imale kokoye hapame na꞉ koko natipo dolumaiya. Adipalati, na꞉ye pta sikemte sadena. Epapedeme wua꞉ puame na꞉ dla hedle haiya. ");
INSERT INTO xla_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Adipalati, na꞉ta imale koko wua꞉ dla hamilowedeme halaye pase kokalena. Epame na꞉tapo wua꞉ta didiyepo telepo depame alisisi kokomale hamilowedeme hala iye pta sikemte holokamana.” ");
INSERT INTO xla_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yu so inoma sumalalo alila hale dla Yesuta ya꞉ alotle tlalo so mate witi daya emale dulu tle tamalaiyo. Epame Yesu ya꞉ alotle tlalo sota daya teta꞉mama witi dlomoko hauwalepame dlomtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Epalati Pa꞉lisi sota koko i natipame Yesu watle epo atlaiyo, “Wa꞉ alotle tlalo sota adipalati dita inoma sumalalo alila dla dlowe alisisi hauwali? Yia꞉ di aiyalma ma-hauwokokomalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuta asiyama epo atlaiyo, “Wua꞉ God yu buka dla Deibidi mate ya꞉mkadulo mate yia꞉ta daya teta꞉lati koko halëye posesa꞉mdi? ");
INSERT INTO xla_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Adipalati, Deibiditapo God ya꞉ aiyalma aya dulu dla tuwame aiyalma dayaye hapame ya꞉mkadulo mate douwapo. Amasiyama aiyalma daya iye di aiyalma dolumama isikimi God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo so siyapota dlomduwapo. Epapele tlope Deibiditapo di aiyalma postamama ya꞉ opa mate mepele dlomuwapo. ");
INSERT INTO xla_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Epame wua꞉ Mosesta aiyalma hatitimale dulu dla yu haleta ipo atlaye wua꞉ posesa꞉semdi? Eye God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo soye dita inoma sumalalo alila dla aiyalma aya dulu dla yia꞉ oko halomdepo. Yia꞉ta epamha꞉ha꞉mdiye eta yia꞉ ma aiyalma hauwokokomdepo. Amasiyama Godta koko e natimama pobatalimana desemde. ");
INSERT INTO xla_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Epedeme na꞉ wua꞉ dla atlema, koko hale amkotapo wata oloma hema mo-puame halemama aiyalma ayata itiyamaleye mo-tla꞉mtame halapo. ");
INSERT INTO xla_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Epapedeme God yu bukata epo atlapo, ‘Na꞉ ya꞉mkale gadlowe tlo sikemte malamama asiyama wua꞉ta na꞉ dla alinepi poyupo hapilowe koko tlo pase malamasema,’ depo. Wua꞉ yu e ya꞉ dulu koko ikadepe sikemte malastame ha꞉ha꞉lepiye, wua꞉ na꞉ alotle tlalo soye pobatalimale so dlowa. ");
INSERT INTO xla_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Adipalati, Opa Yamitapo wua꞉ta inoma sumalalo alilaye ya꞉ta dokopala depo halapo.” ");
INSERT INTO xla_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuta yu i atlamhalepo gudepame ma etle yia꞉ta inoma sumalalo aya dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Epame aya dulu edla oplami hale do seme powale ma me-polaiyo. Epapele dulu dla Pa꞉lisi sotapo Yesuye batalimale oplami dlowe api totamama ya꞉ watle epo atlaiyo, “Dita inoma sumalalo alila dla oplami ka꞉dloweye ka꞉deta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Amasiyama Yesutapo yia꞉ watle epo atlaiyo, “Wua꞉ dulu dla wua꞉ sipi aliya epapeleta dita inoma sumalalo alila dla munamu dulu dla teyulupiye, wua꞉ ya꞉ye poholahalalo wekepa꞉? Hao. Wua꞉ ya꞉ye munamu dulu tle holalepe. ");
INSERT INTO xla_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Epapedeme God mila꞉pi tle sipi aliyatapo koko pato pohalasema. Hao. Oplamitapo koko pato halapo. Epapedeme oplamitapo dita inoma sumalalo alila dla ka꞉dle koko haloweye aiyalma kokota pobatalimana desema.” ");
INSERT INTO xla_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Epammama Yesutapo do seme powale oplami watle epo atlaiyo, “Wa꞉ do powaleye mo-dolene,” diyo. Epalati oplamita ya꞉ do powaleta mo-dollati ya꞉ dota ma-ka꞉demama ma ya꞉ do seme ka꞉dle some halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Epalati Pa꞉lisi sotapo koko i natipame siyalasiyalademama yia꞉ta inoma sumalalo aya tle alikili dla tamalaiyo. Yia꞉ tame yiskamu yia꞉ dulu dla Yesuye adipo hampo yumpa꞉ dle kokoye esemaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Epedeme Yesu yia꞉ta yu hatitimpopa꞉le koko dalepame ma mo hale dla taiyo. Epalati opa hapulomatapo ya꞉ dolumtamalaiyo. Epapalati ya꞉tapo yia꞉ dla esusulumale hutiyele hapulomaye ka꞉ka꞉depame yia꞉ watle itiyamale mate epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“Na꞉ kokoye ase opa hapuloma dla esemsiyamiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eye God tle yu hapame molo atlalo oplami Aisayata atlamale mate ala꞉lowedeme apiyo. Adipalati, ya꞉tapo epo atluwapo, ");
INSERT INTO xla_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Na꞉ oko oplami natiya. Ya꞉ye na꞉ta sale oplamipo. Na꞉ ya꞉ye sikemte malamama ya꞉ dla siyema. Na꞉tapo na꞉ Sokoye ya꞉ watle hamilowepo. Epalati ya꞉tapo ikadepe kokoye po-Yu so hapuloma dla atlamelepe. ");
INSERT INTO xla_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Epame ya꞉tapo oplami hale mate yu ga꞉ga꞉lemama yu potopulolowa. Epo oplami haletapo ya꞉ta yu topulolle yuye mo duka dla podallowa. ");
INSERT INTO xla_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Epame ya꞉tapo osamokolo illiye popostlowa. Epo tuloma yimka꞉mala ullumhallaloye posumtlowa. Epedeme ya꞉tapo opaye epo gagademhala kokoye yipta pomellowa. Amasiyama opa hapulomata Godta solotamale koko tlo dolumha꞉ha꞉la natipame medla gudlepe. ");
INSERT INTO xla_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Epapedeme ya꞉ hi tle po-Yu so opa hapulomatapo yia꞉ta omha꞉ha꞉mama dalemha꞉ha꞉ pasakaloye halepe.” ");
INSERT INTO xla_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oloma edla opatapo oplami hale bataliya yemalata ya꞉ dulu dla tuwame halemama inoma mate epo yu mate pa꞉po halaleye Yesu hala dla hamampumulaiyo. Epalati Yesutapo ya꞉ye ka꞉diyo. Epapele oloma medla oplamitapo ya꞉ inoma mo-towanatipame yukamolowe ma mo-kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Opa hapulomata koko i natipo yiyelepame epo atlamyaiyo, “Oplami iye Deibidi Yami mle,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amasiyama Pa꞉lisi sotapo koko i dalepame epo atlamyaiyo, “Yesuye Belsebulta itiyamale tle bataliya yimlalaye alikili dla dodolomsalemsela꞉ma. Adipalati, Belsebulye bataliya yimlala yia꞉ apo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Amasiyama Yesu yia꞉ta malamaleye momalanatipame yia꞉ watle epo atlaiyo, “Mo hatlope sotapo yiskamu yia꞉ dulu dla duka gladepame opahale dlepiye, mo eye pohallowa, batalimelepe. Epame asiya hatlope sota yiskamu yia꞉ dulu dla duka gladepame opahale dlepiye, asiya ewoloye poha꞉ha꞉lowa, batalimelepe. ");
INSERT INTO xla_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Epapedeme Saitentapo bataliya yimlalaye alikili dla dodolomsalemhallepiye, eta ya꞉skamu ya꞉ alumale dulu dla duka gladepame opahale dlepe. Ya꞉ta epapelepiye, adipammama ya꞉ mo kokota kokó elepa꞉? Batalimelepe. ");
INSERT INTO xla_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amasiyama na꞉ta bataliya yimlalaye alikili dla dodolomsalemsela꞉ itiyamale iye ikadepe Belsebulta itiyamale tle amsela꞉ma dlepiye, ame mo-wua꞉ opata bataliya yimlala alikili dla dodolomsalemsiyamaye itiyamale adi tle hapo siyamama amma꞉? Epedeme wua꞉ opa ewolotapo wua꞉ta na꞉ dla atlamyaleye pomikadepe dlowa. ");
INSERT INTO xla_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amasiyama na꞉tapo God ya꞉ Sokota itiyamale tle bataliya yimlalaye alikili dla dodolomsalemsela꞉ma dlepiye, God ya꞉ mo kokotapo wua꞉ dla mo-puwapo. ");
INSERT INTO xla_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Epedeme oplami haletapo itiyamale oplami aya dla hetame alisisi uhalomolowedeme apelepiye, ya꞉ ka꞉yapa itiyamale oplami tatle dea mate yupo himilipe. Epame alotle ya꞉ aya dulu dla hetame ya꞉ alisisi uhalomelepe. ");
INSERT INTO xla_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Epapedeme oplami antapo na꞉ tiyama tle pohallalo wekelepiye, ya꞉ye na꞉ mate opahale demhalapo. Epame oplami antapo na꞉ mate opaye God hala dla pe-elempulalo wekelepiye, ya꞉tapo opaye God tle ma alikili dla dodolomsalemhalapo. ");
INSERT INTO xla_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Epedeme na꞉ wua꞉ watle ikadepe koko atlema. Batalimale koko hapuloma opata halomde mate epo yu batalimale God hi mate putlopo atlepiye, Godta howahapo hiyostlepe. Amasiyama oplami antapo Hela꞉dle Soko watle putlopo atlepiye, Godta ya꞉ batalimaleye pohowahapo hiyostlowa. ");
INSERT INTO xla_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Epedeme oplami antapo Opa Yami dla batalipo putlopo atlepiye, Godtapo ya꞉ batalimaleye howahapo hiyostlepe. Amasiyama oplami antapo Hela꞉dle Soko dla batalipo putlopo atlepiye, ya꞉ kokó elepo ellalo batalimale hapo. Epedeme ya꞉ batalimaleye Godtapo pohowahapo hiyostlowa.” ");
INSERT INTO xla_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Epedeme dlomoko dali ka꞉dletapo dlomoko ka꞉ka꞉dle mimdepo. Epame dlomoko dali batalimaletapo dlomoko batalimale mimdepo. Epedeme dlomoko dali hapulomaye yia꞉ dlomoko tle malanatimdepo. ");
INSERT INTO xla_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Epedeme wua꞉ ilama yimlalapo. Wua꞉ bobtalimale so depo ha꞉ha꞉ tle ma adipammama ka꞉ka꞉dle koko atlapa꞉? Epapedeme adipapele kokotapo oplami dupa dulu dla pasatepo ellepiye, ya꞉ mati tle epapele kokoye atlamdepo. ");
INSERT INTO xla_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Epedeme ka꞉dle oplamitapo ka꞉ka꞉dle koko ya꞉ dupa dulu dla hutiyeye ya꞉ mati tle halopo wowoyamdepo. Epalati batalimale oplamitapo ya꞉ dupa dulu tle bobtalimale kokoye halopo wowoyamdepo. ");
INSERT INTO xla_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Epapele dulu dla na꞉ mikadepe koko wua꞉ watle atlema. Koko gladle oloma edla opa hapuloma hatlope hatlope dletapo yia꞉ta bobtalimale yu atlamale hapulomaye God dla bobotimatimelepe. ");
INSERT INTO xla_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Epedeme Godtapo wa꞉ koko glademama mowolo yu adipo atlamsela꞉mduwa yu e mate wa꞉ kokoye gladlepe. Epapele dulu dla wa꞉ yu ka꞉ka꞉dle tlo atlamsela꞉mduwayo, ya꞉tapo wa꞉ye ka꞉dle oplami dlepe. Amasiyama wa꞉ yu bobtalimale tlo atlamsela꞉mduwayo, ya꞉tapo wa꞉ye batalimale oplami dlepe.” ");
INSERT INTO xla_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Alila hale dla Pa꞉lisi so opi mate epo aiyalma imalalo so opi mate Yesu hala dla puaiyo. Yia꞉tapo Yesuta itiyamale hamsela꞉ye ikadepe God tle malata꞉ depame ya꞉ watle epo atlaiyo, “Imalalo oplami, di wa꞉ta ulugiyemale koko hale halati natilowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesuta asiyama yia꞉ watle epo atlaiyo, “Wata oloma hema ha꞉ha꞉ so opaye pta bobtalimana. Epame yia꞉ ma God kokoye pokoko desemde. Epammama yia꞉ isikimi ulugiyemale koko tlo tlamha꞉ha꞉lowedeme na꞉ watle atlamha꞉ha꞉po. Amasiyama na꞉ yia꞉ dla ulugiyemale koko hale ponati-iliwa. Isikimi God tle yu hapame molo atlalo oplami Yona koko tlo yia꞉ watle nati-iliwepo. ");
INSERT INTO xla_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonatapo alila dapahatlope amalo pato koko dulu dla eluwapo. Epammama Opa Yami mape alila dapahatlope ta꞉la dulu dla ellepe. ");
INSERT INTO xla_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Epedeme Niniba sotapo koko gladle oloma dla wua꞉ mate ha꞉ha꞉mama wua꞉ kokoye gladepo wua꞉ye batalimale so dlepe. Adipalati, Yonata God yuye yia꞉ dla hampulati yia꞉tapo yia꞉ bobtalimale tle ma-heheletimuwapo. Amasiyama na꞉tapo Yonaye tla꞉mtame halapo. Epapele tlope na꞉ta God yuye wua꞉ dla hampulati wua꞉ta dalepame wua꞉ bobtalimale tle poheheletimana. ");
INSERT INTO xla_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Epame koko gladle oloma dla Siba mo dokopala a꞉ya mape wua꞉ mate koko gladle dla halemama wua꞉ kokoye gladepo wua꞉ye batalimale so dlepe. Adipalati, ya꞉tapo mo pateka꞉mu tle pato oplami Solomonta imale koko dalla puwapo. Amasiyama na꞉ta Solomonye tla꞉mtame halapo. Epapele tlope wua꞉tapo na꞉ yuye dalla allipo.” ");
INSERT INTO xla_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Epedeme bataliya yemalata oplami tle alikili dla ulatelepiye, ya꞉ tame dalupa dulu dla ya꞉ta hedlowe moye totamsela꞉lepe. Ya꞉ epo totamsela꞉mama ya꞉ta hedlowe mo ponatilalo wekelati ma ya꞉skamu epo atellepe, ");
INSERT INTO xla_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Na꞉ na꞉ta haluwa aya dla ma ilame tali,’ dlepe. Ya꞉ epo puame natili dla ayata ala aya siyapo woloma hakaka towalipo hallati natilipe. ");
INSERT INTO xla_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Epalati ya꞉ ma tame bataliya yimlala opi 7 sikemte i-itiyamale tlo elempuame aya edla hallepe. Epapelepiye, oplami itapo ya꞉ta ka꞉yapa haluwaye memelepame ma sikemte batalipo hallepe. Epapedeme wata oloma hema batalimale dulu dla ha꞉ha꞉lalo so dla epapele kokota woyamelepe.” ");
INSERT INTO xla_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu opa alumale dla ala me-yukamhallati ya꞉ wai mate epo ya꞉ eidulo mateta alikili tle puame ha꞉ha꞉mama ya꞉ mate yukamolowe solotamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Epalati oplami haletapo Yesu watle epo atlaiyo, “Wa꞉ wai mate epo wa꞉ eidulo mateta wa꞉ mate yukamolowe solotamama alikili dla puame omha꞉ha꞉ma,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Amasiyama Yesutapo ya꞉ watle epo atlaiyo, “Na꞉ wai anata꞉? Epo na꞉ eidulo ma anawolota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Epame ya꞉ta ya꞉ alotle tlalo so dla do dlokomama epo atlaiyo, “Iwoloye na꞉ wai mate epo na꞉ eidulo matepo. ");
INSERT INTO xla_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Adipalati, opa anawolotapo na꞉ A Pepele di dla halata solotamale koko halomha꞉ha꞉lepiye, ewoloye na꞉ eidulopo, epo notimadulopo, epo na꞉ waidulo ikadepepo.” ");
INSERT INTO xla_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Alila hatlo medla Yesu aya dulu tle alikili dla woyapame Ga꞉lili kaula peleyama dla polla tuluiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ya꞉ edla tulume impollati opa hapulomatapo ya꞉ta imale dallowedeme ya꞉ hala dla puame sikemte alumaiyo. Epalati Yesuta koa dla posokolome polomama impollati opa hapulomata tamali tle dalempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Epame ya꞉tapo koko hapulomaye wayu mate opa hapuloma dla impolomama epo atlaiyo, “Alila haleta oplami haletapo witi daya aleye ka꞉ka꞉lla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ya꞉ witi daya ale ka꞉ka꞉lemsela꞉mama ale opitapo api duka dla teteyuiyo. Epalati teata puame deiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Epalati witi daya ale opitapo ewala ta꞉la dla teteyupame hapele popeyalimaiyo. Amasiyama yia꞉ye sali alemalleta yumama pakasiyamalalo paliyo. Adipalati, ta꞉la popta꞉deme yia꞉ keseye ta꞉la dulu dla sikemte potutula꞉lalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Epo ma witi daya ale opita osamokolo dulu dla teteyuiyo. Yia꞉ epame pakasiyamalalo popeyalimaiyo. Amasiyama yia꞉ta teta꞉le oloma edla osamokolota yia꞉ mate matamama dukuluta popoliyelati yia꞉ta hapulomata paliyo. ");
INSERT INTO xla_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Epame witi daya ale opita ta꞉la ka꞉dle dla teteyuiyo. Epame yia꞉tapo popeyalipo teta꞉pame dlomoko sikemte milimaiyo. Epele dulu dla witi daya ale opitapo 100 dlomoko milimaiyo. Epo opitapo 60 dlomoko milimaiyo. Epo opitapo 30 dlomoko milimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Epedeme molo watalo so opa, wua꞉ yu i daliya.” ");
INSERT INTO xla_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Epalati Yesu ya꞉ alotle tlalo sota puame Yesu watle epo atlaiyo, “Wa꞉ adipalati opa watle wayu mate imsela꞉mdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu asiyama yia꞉ watle epo atlaiyo, “Wua꞉tapo Pepele dimo kokoye malastlepe. Adipalati, ka꞉yapa Godta ya꞉ mo kokoye hemele hatiyomeleme haluwaye wata wua꞉ dla botomastapo. Amasiyama ya꞉ opa opi dla pobotomastana. ");
INSERT INTO xla_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Epedeme woloma ka꞉pi dallalo oplami dla Godtapo ka꞉pi malamale pasataleye hamilipe. Amasiyama oplami antapo na꞉ yuye podallalo wekelepiye, Godtapo ya꞉ dla ka꞉dle malamale yemala elaye kolahalepe. ");
INSERT INTO xla_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na꞉tapo opa watle wayu mate imsela꞉mdepo. Adipalati, ‘yia꞉tapo natimama ya꞉ dulu kokoye woloma ponatilalo wekelepo depame. Epame yia꞉tapo dalepame woloma ya꞉ dulu kokoye pomalamalalo wekelepo depame.’ ");
INSERT INTO xla_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Epalati Aisayata atlale yutapo yia꞉ tle ikadepe depo. Adipalati, ya꞉ta ipo atluwapo, ‘Wua꞉ woloma kulume dallepe, amasiyama wua꞉ woloma pomalamolowa. Epame wua꞉ woloma kulume natilipe, amasiyama wua꞉ woloma pomalanatilowa. ");
INSERT INTO xla_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Adipalati, yia꞉ dupa dulu malamaleye pta kokalalimana. Epapedeme yia꞉ molo mate epo yia꞉ inoma mateye ma-hihimamuwapo. Amasiyama yia꞉ta inomata natipo molota dalepame malamale hapo na꞉ dla ilame pumatiye, Eta na꞉ta yia꞉ bobtalimaleye hiyotimelemla.’ ");
INSERT INTO xla_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amasiyama Godtapo wua꞉ dla siyemhalapo. Adipalati, wua꞉ inomatapo koko tlamha꞉ha꞉po, epame wua꞉ molotapo koko dlalemha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Epedeme na꞉ wua꞉ watle ikadepe koko atlema. God tle yu hapame molo atlalo so ka꞉yapa ha꞉ha꞉uwa mate epo God mila꞉pi tle ka꞉ka꞉dle so opa matetapo wua꞉ta wata tlamde kokoye natilowa depame omha꞉ha꞉uwapo. Amasiyama yia꞉ potlamana. Epame wua꞉ta wata dlalemde koko mape dallowa depame omha꞉ha꞉uwapo. Amasiyama yia꞉ podalena.” ");
INSERT INTO xla_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu ma epo atlaiyo, “Epapedeme witi daya ale ka꞉ka꞉lle wayu i ya꞉ dulu kokoye woloma daliya. ");
INSERT INTO xla_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Epapedeme opa opitapo witi ale api duka dla teteyuli epapele some ha꞉ha꞉po. Yia꞉ ka꞉dle yu Pepele dimo kokoye dalepame woloma pohalalo wekelepiye, Saitenta puame God yu iye yia꞉ dupa dulu tle kolahamdepo. ");
INSERT INTO xla_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Epalati opa opitapo witi daya aleta ewala ta꞉la dla teteyuli epapele some ha꞉ha꞉po. Epedeme yia꞉tapo God yu atla dalepame siyele mate ma-hamdepo. ");
INSERT INTO xla_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amasiyama God yutapo yia꞉ dupa dulu dla kese woloma potutula꞉semde. Epedeme yia꞉ta God yuye dalepame isikimi alila kiyele dla mikadepe demdepo. Amasiyama yia꞉ta God yu hamale koko tle kokalle koko mate epo wotiyalle koko mateta yia꞉ dla woyamalati yia꞉ta God yu dla ha꞉ha꞉ etle ma-hapele alikili dla potamdepo. ");
INSERT INTO xla_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Epalati opa opitapo witi daya ale osamokolo dulu dla teteyuli epapele some ha꞉ha꞉po. Yia꞉tapo God yu dalepame hamdepo. Amasiyama ta꞉lamo pasakalo momalamale mate epo alisisi poposatilipo ha꞉ha꞉lowe malamale mateta yia꞉ta mikadepe dleye yumdepo. Epapele koko tle yia꞉ta mikadepe dle kokota dlomoko pomilimasemde. ");
INSERT INTO xla_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Epapalati opa opitapo witi daya ale ta꞉la ka꞉dle dla teteyuli epapele some ha꞉ha꞉po. Yia꞉tapo God yu dalepame woloma hamdepo. Epammama yia꞉ta dlomoko milimama opita 100 dlomoko milimdepo, epo opita 60 dlomoko milimdepo, epo opita 30 dlomoko milimdepo.” ");
INSERT INTO xla_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Epame matle Yesutapo wayu hale mate ipo imaiyo, “Pepele dimo kokoye ipapena. Oplami haletapo witi daya aleye ya꞉ ta꞉la dla ka꞉ka꞉liyo. ");
INSERT INTO xla_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amasiyama utula꞉la edla opa hapulomata mo-hutiyelati ya꞉ dla opahale dlalo oplamitapo puame ya꞉ta witi daya ale ka꞉ka꞉lle di tle osamokolo aleye ka꞉ka꞉lemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Epedeme witi dayata matapame dlomoko milimale oloma edla osamokolo ma mataiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Epalati ya꞉ oko sota puame epo atlaiyo, ‘Wa꞉ osalo dulu dla witi daya ale siyapo tlo ka꞉ka꞉luwapo. Amasiyama adipammama osamokolo ma dulu medla matama꞉?’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Epapalati asiyama ya꞉ta epo atlaiyo, ‘Dia꞉ mate opahale dlalo oplamitapo puame ka꞉ka꞉luwayo,’ diyo. Epame ya꞉ oko sotapo ya꞉ watle epo atlaiyo, ‘Ka꞉deta꞉, dita tame osamokolo eye poptalipo alikili dla pololloweye?’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amasiyama ya꞉tapo yia꞉ watle epo atlaiyo, ‘Hao, wua꞉ pe-epapolowa. Adipalati, wua꞉ osamokolo e poptalimama witi daya mate poptalilala. ");
INSERT INTO xla_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Epedeme aseka yia꞉ta yimkata mepo teta꞉lepo. Epame hauwallowe oloma dla na꞉tapo na꞉ oko so watle osamokolo tatle poptalipame dlapa dla mistaiya dlowepo. Amasiyama witi daya tlo woloma hauwalepame na꞉ aya dla hampuame kolumaiya dlowepo.’” ");
INSERT INTO xla_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Epame matle Yesutapo wayu hale mate ipo imaiyo, “Pepele dimo kokoye ipapena. Oplamitapo masted dlomoko ale yemala yimka꞉mala ikadepeye hamtame emomellepe. ");
INSERT INTO xla_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Amasiyama dlomoko ale yemala etapo peyapame ta꞉lepiye, osalo dulu edla dlomoko dali eta pato hallepe. Epalati teatapo puame ya꞉ dlo dla eto tilimyelepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Epame matle Yesutapo wayu hale mate ipo imaiyo, “Pepele dimo kokoye ipapena. A꞉yatapo palawa daya ha꞉lowedeme ka꞉yapa dukumama palawa daya pato dulu dla yist yimka꞉malaye kustamdepo. Epalati yist yimka꞉mala etapo palawa dayaye sikemte ta꞉mdepo.” ");
INSERT INTO xla_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Epedeme Yesutapo isikimi wayu ipapele mate opa hapulomaye imsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ya꞉ta ipapele koko halomsela꞉uwaye God tle yu hapame molo atlalo oplamita atluwa koko mate ala꞉lowedeme apuwapo. Adipalati, ya꞉ta ipo atluwapo, “Na꞉tapo opa watle God yu imama wayu mate imsela꞉lowepo. Epame na꞉tapo ka꞉yapa ta꞉lamo kotiyamale tle hemele hahatiyopo hutiyele kokoye ma haliyamale dla bobotimatimelepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu opa alumaleye medla pomelepame ma aya dulu dla hetaiyo. Epalati ya꞉ alotle tlalo sota ya꞉ watle puame epo atlaiyo, “Wa꞉ di watle witi daya ale mate osamokolo ale mate ka꞉ka꞉lle wayu ya꞉ dulu kokoye woloma imane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Epapalati Yesuta yia꞉ watle epo atlaiyo, “Witi daya ale ka꞉ka꞉lle oplamiye e Opa Yamipo. ");
INSERT INTO xla_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Epalati witi daya ale ka꞉ka꞉lle osaloye ta꞉lamopo. Epedeme witi daya aleye God ya꞉ akimlalapo. Amasiyama osamokolo aleye Saiten ya꞉ akimlalapo. ");
INSERT INTO xla_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Epapele dulu dla osamokolo ale ka꞉ka꞉lle oplamiye Saitenpo. Epapedeme hauwallowe alilaye ta꞉lamo mosukulupo. Epalati witi daya hauwallalo soye God ya꞉ banakaka sopo. ");
INSERT INTO xla_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Epedeme osamokoloye potopame dlapa dla mistemdiye, epammama ta꞉lamo mosukulu dla Opa Yamita Saiten ya꞉ akimlalaye dlapa dla epo mistlepe. ");
INSERT INTO xla_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Epapele dulu dla Opa Yamitapo ya꞉ banakaka soye taiya dlepe, yia꞉tapo tame opa anawolotapo yimkaduloye batalimale koko dulu dla elemtullalo so mate epo batalimale koko halomalalo so mateye eleme Dlapa mo dla ka꞉ka꞉timelepe. Epalati yia꞉tapo dulu edla a꞉lemha꞉ha꞉mama yia꞉ a꞉pe tetekelalimyelepe. ");
INSERT INTO xla_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amasiyama Godta ka꞉dena dle sotapo yia꞉ A God mo dla sali some silapompopa꞉lepe. Epedeme molo walle oplamitapo yu iye dallepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Epapedeme Pepele dimo kokoye ipapena. Oplamitapo ta꞉la muwalemtamama oplami haleta mani sikemte pato mo-powataliya hemele hatiyomelleye natilipe. Ya꞉ mani e natipame matle ta꞉la mate kakapulomelepe. Epame ma siyele mate ya꞉ aya dla ilame tame ya꞉ alisisi hapulomaye opa watle hapipame asiyama mani tlo halepe. Ya꞉ epame mani e mate ta꞉la e halepe. Epammama dulu edla mani pato hemele hatiyomeleme ela eye e ma ya꞉tapo halepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Epame Pepele dimo koko ma ipapena. Oplamitapo moli epapele totamsela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ya꞉ totamsela꞉mama moli sikemte ka꞉dle natilipiye, ya꞉ tame ya꞉ alisisi hapulomaye opa watle hapipame asiyama mani tlo halepe. Ya꞉ epame mani e mate moli ka꞉dle eye halepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Epame Pepele dimo koko ma ipapena. Amalo halomalalo sotapo yia꞉ mataye yú dulu dla pololepame amalo sikemte halomdiye epapena. ");
INSERT INTO xla_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Epapele dulu dla amalota yia꞉ mata dla sikemte tumulale hallepiye, yia꞉ mata eye hallumhetame tamali di dla popa꞉mama hukullupe. Yia꞉ hukulumama amalo ka꞉ka꞉dle tlo duli dulu dla hamama, asiyama huhutalemale tlo polollepe. ");
INSERT INTO xla_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Epapedeme ta꞉lamo mosukulu dla koko epapeleta me-woyamelepe. Epammama God ya꞉ banakaka sotapo ta꞉lamo pato dla tame ka꞉ka꞉dle so mate bobtalimale so mate duka gladlepe. ");
INSERT INTO xla_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Epame bobtalimale so tlope Dlapa mo dla ka꞉ka꞉timelepe. Epalati yia꞉tapo dulu edla a꞉lemha꞉ha꞉mama yia꞉ a꞉pe tetekelalimyelepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu epo halemama ya꞉ alotle tlalo so dla epo atlaiyo, “Wua꞉ na꞉ta atlama ya꞉ dulu kokoye woloma malama꞉?” diyo. Epalati yia꞉tapo asiyama epo atlaiyo, “Yao, di me-malama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Epalati Yesuta yia꞉ watle epo atlaiyo, “Aiyalma imalalo oplami antapo Pepele dimo kokoye sikemte malastame hallepiye, ya꞉ye aya ya꞉ a epapele some halapo. Ya꞉tapo aya dulu etle alisisi amko mate epo takala mate halopo pua demhallepe.” ");
INSERT INTO xla_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu opa hapulomaye wayu mate imhalepo gudepame ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ya꞉ ma ilame tame ya꞉ mo ikadepe Nasalet dla halemama yia꞉ta inoma sumalalo aya dla hetame opaye God yu mate imhalaiyo. Epalati opa hapulomatapo ya꞉ta imale dalepame sikemte yiyelemama epo atlamyaiyo, “Oplami ita imale hamsela꞉leye hadima hauwa? Epame ya꞉ta ulugiyemale koko halomsela꞉ye, apa kokota꞉? ");
INSERT INTO xla_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ya꞉ isikimi Meli yamipo. Epame ya꞉ye isikimi hema hallalo aya halalo oplami yamipo. Epo ya꞉ye Yeims mate epo Yosep mate epo Saimon mate epo Yudas mate yia꞉ bapapo. ");
INSERT INTO xla_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Epame yotumadulo mape dia꞉ mate midla popa꞉po. Epapedeme Yesuta koko halomsela꞉ iye hadima hauwa?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Epedeme yia꞉ta ipo malamale tle Yesuta imale haloweye alliyo. Epalati Yesuta yia꞉ watle epo atlaiyo, “Opatapo God tle yu hapame molo atlalo oplami yu dla dalepame heodemdepo. Amasiyama ya꞉ mo so mate epo ya꞉ asiyadulo mateta ya꞉ yu dla dalepame poheodesemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Epedeme Yesu yia꞉ta ya꞉ dla mikadepe dle pa꞉le natipame ya꞉ mo edla ulugiyemale kokoye pase halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","12","Alila haleta Ga꞉lili mo omhallalo oplami Helodtapo ya꞉ ei Pilipi ya꞉llu Helodiyasye kolahaiyo. Epalati Yonta koko i natipame Helodye sikemte atlemama epo atlemdiyo, “Wa꞉ta wa꞉ ei ya꞉llu kolahaloweye poka꞉dena. Adipalati, eye aiyalmapo,” demdiyo. Epalati Helodta sikemte siyaladepame Yonye amtuwale aya dla ka꞉staiyo. Epammama ya꞉ solotamaiyo, Yon yumuluwedeme. Epele tlope ya꞉ opa wota꞉mama poyumiyo. Adipalati, opa hapulomata Yonye God tle yu hapame molo atlalo oplami demdiyo. Epame alotle Helod ya꞉ hamale alilata umalati ya꞉tapo ya꞉mkadulo mate eleme puame daya dempolaiyo. Epalati Helodiyas yotitapo puame yia꞉ mila꞉pi tle ka꞉pi yomama Helod dla siyele hamiyo. Epalati asiyama Helodtapo yu itiyamale himimama ya꞉ watle epo atlaiyo, “Wa꞉ta solotamale alisisiye na꞉ watle atlepiye, na꞉ta alisisi eye wa꞉ watle hamilowepo,” diyo. Ya꞉ epo atla dalepo yomhalepo gudepame ya꞉ wai hala dla tuwame ya꞉ta solotamale kokoye daliyo. Epo ma ilame matime Helod watle epo atlaiyo, “Na꞉ Yon opa yú dla ka꞉ka꞉timalalo oplami dokopala tlo solotama. Epedeme wa꞉ watapo ya꞉ dokopalaye ketahapo kowepa dla himme puame na꞉ watle hamine,” diyo. Helodta koko i dalepame Yon dokopala ketahapo hamiloweye posolotamaiyo. Amasiyama ya꞉ta amseyemala watle yu itiyapo himili kokoye ya꞉ mate daya dempopa꞉le so ma me-daliyo. Epapedeme ya꞉tapo koko hema alliweye api ponatiyo. Epedeme ya꞉tapo ya꞉ opa watle yu itiyamale hamiyo, yia꞉tapo tame Yon dokopalaye ketahame hampulupo depame. Epalati ya꞉ opatapo tame Yon dokopalaye ketahapo kowepa dla himimpuame amseyemala watle hamiyo. Epalati ma ya꞉tapo ya꞉ wai watle hamiyo. Epalati Yon ya꞉ alotle tlalo sota puame Yon motoye hamtame wabasi dla hamatiyo. Epo tame Yesu watle atlaiyo. Epapele koko alotle Helodtapo Yesuta koko halomsela꞉le dalepame ya꞉ oko so watle epo atlaiyo, “Oplami iye Yon opa yú dla ka꞉ka꞉timalalo oplami mle. Epedeme ya꞉tapo powale tle sila꞉time ma ulugiyemale koko ipapele halomsela꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuye Helodta Yon yumili koko dalepame koa dla tulume posokoleme homta ellalo mo dla hedlowedeme taiyo. Amasiyama opa hapuloma mo meyelope meyelope dle dla ha꞉ha꞉lalo sota koko i dalepame tamali api tle Yesu hala dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu koa tle tamali dla posokolome halemama opa hapuloma alumale natipame yia꞉ye sikemte polowamama esusulumale soye ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yesu epamsela꞉lati ya꞉ alotle tlalo sota tamila꞉la puame ya꞉ watle epo atlaiyo, “Sali mo-tulupo. Epedeme wa꞉ opa hapuloma iye ma-taiya dene, yia꞉tapo mo mateka꞉pi hema popa꞉ dla tame daya halomelepo depame. Adipalati, dita popa꞉ mo iye daya pa꞉na,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ yia꞉ye daya halomala taiya demiya. Amasiyama muwolo yia꞉ye daya halopiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Epalati asiyama yia꞉tapo ya꞉ watle epo atlaiyo, “Dia꞉ dla isikimi daya mo-halomale do supulastale mate amalo dapiyamte mateta hutiyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Epalati Yesuta asiyama epo atlaiyo, “Daya e mate epo amalo e mate na꞉ watle halopo puaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Epame ya꞉ opa hapulomaye tuptu dla popa꞉iya depame daya mo-halomale do supulastale mate amalo dapiyamte mate halopame pepele di dla omhalemama God dla siyele yu atlepame daya hauwokokomaiyo. Epame ya꞉ alotle tlalo so watle hapiyo, yia꞉tapo ma opa hapuloma watle alemelepo depame. ");
INSERT INTO xla_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Opa hapulomatapo daya dlopame sikemte susukalemama daya popokadiyo. Epalati Yesu ya꞉ alotle tlalo sota daya akutu mate amalo akutu mate popomelleye yekalo 12 dla atilimama sikemte poposatilimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Epedeme opa mate epo wola꞉ mate epame yimlala mate daya i deiyo. Amasiyama sesa꞉le oloma edla opa siyapo tlo sesa꞉mama 5,000 umaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuta 5,000 opa daya ilipo gudepame ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ tatle koa hame kaula seme dla uliya. Na꞉ opa iwoloye taiye depo alotle puluwamo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Epame ya꞉ opa alumaleye ma-taiya depame ma meyelo hallowedeme tamali di dla inoma sumala hetaiyo. Ya꞉ tamali di edla hetame hallati ma-amtuwaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amasiyama oloma edla ya꞉ alotle tlalo sotapo koa dla alupame mo-kaula dukuslopi dla tamha꞉ha꞉iyo. Epalati mosisita ulo mate puame yia꞉ koa dla heyulati yia꞉tapo sikemte itiyamale mate koa sosolemtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Epo utulala ikadepe ala iki yulumhallati Yesutapo yú di tle yia꞉ hala dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Epalati yia꞉tapo Yesu natipame sikemte yiyelepo wowota꞉mama ikiyeliyo. Adipalati, yia꞉ta malamaleta semte bataliyata pumapo diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Ase sikemte wowota꞉miya. Na꞉ta puma,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Epalati Pitata epo atlaiyo, “Lod, ikadepe wa꞉ta puma dlepiye, wa꞉ ma na꞉ye yú di tle puane dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Epalati asiyama Yesuta epo atlaiyo, “Puane.” Epapele oloma dla Pitata tulume yú dla posokolome yú di tle kotiyapo Yesu hala dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amasiyama ya꞉ tamama ulo patotota pumhalla natipame sikemte wota꞉iyo. Epapele oloma edla ya꞉tapo yú dulu dla mo-ollodemtulumama yu teta꞉le mate epo atlaiyo, “Lod, na꞉ gadene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Epalati Yesuta pakasiyamalalo ya꞉ dota ola꞉mtulume ya꞉ye hampame ya꞉ watle epo atlaiyo, “Wa꞉ta mikadepe dleye pta yimka꞉mala. Wa꞉ adipalati malamale tatlamo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Epame yia꞉ta madipatata koa dulu dla poposokollati mosisita medla ka꞉liyo. ");
INSERT INTO xla_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Epalati ya꞉ alotle tlalo sota Yesu hete sitali dla tulume heodepo popa꞉mama epo atlaiyo, “Wa꞉ye ikadepe God Yamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yesu mate ya꞉ alotle tlalo so mate kaula ulume Genesalet mo dla tame woyapame koa himiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Edla ha꞉ha꞉lalo opata Yesu malanatipame mo meyelope meyelope dle dla yu hamtamalaiyo. Epalati opata esusulumale so opa hapulomaye Yesu hala dla hohopo pumhalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Epalati esusulumale sota Yesu watle otomama epo atlamyaiyo, “Di isikimi wa꞉ tluka ipi tlo umamolowama,” demyaiyo. Epapele dulu dla Yesu tluka ipi umamale so hapulomata ma-ka꞉ka꞉dlalimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pa꞉lisi so opa opi mate epo aiyalma imalalo so opa opi mate Yelusalem tle puame Yesu hala dla alupame ya꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Wa꞉ alotle tlalo sota di toto koko podolumalalo wekemama yia꞉ doye woloma pohowahalomalalo daya dlompopa꞉ye adipalati amma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Ame wua꞉ adipalati Godta imale aiyalma kokoye melepame ma opata imale aiyalma koko dolumsiyama꞉? ");
INSERT INTO xla_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Adipalati, Godta epo atluwapo, ‘Wa꞉ a mate wa꞉ wai mate yia꞉ yu dla heodepo salladepo siyamaiya. Amasiyama antapo ya꞉ a mate ya꞉ wai mate dla yu batalimale atlepiye, ya꞉ye yumuluwe ka꞉pi,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amasiyama wua꞉ta atlemama oplamitapo ya꞉ a mate ya꞉ wai mate gadlowe yilo alisisi himhalaleye ma God watle hamiloweye ka꞉pi demdepo. ");
INSERT INTO xla_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Epapele koko tle wua꞉tapo oplamita ya꞉ a mate ya꞉ wai mate gadlowe yilo dinapopo halaleye humatlemdepo. Wua꞉ta ipapele koko hamha꞉ha꞉mama Godta aiyalma hamili koko tlo podolumalalo, ma wua꞉ toto koko tlo dolumha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wua꞉ wuskamu pepemalalo sopo. God tle yu hapame molo atlalo oplami Aisayata ikadepe koko atluwapo, wua꞉ epapele so dla. Adipalati, ya꞉ta ipo ilimuwapo, ");
INSERT INTO xla_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Opa iwolotapo isikimi mati tle na꞉ dla siyele ta꞉demdepo. Amasiyama yia꞉ dupa dulu dla na꞉ malamaleye hawa ikadepe. ");
INSERT INTO xla_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Epedeme yia꞉ta na꞉ dla heodepame na꞉ hi di dla ta꞉demha꞉ha꞉ye dulu koko pa꞉na. Adipalati, yia꞉tapo opata imale aiyalmaye na꞉ta imale tepo depame ma opa watle imsiyamapo.’” ");
INSERT INTO xla_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuta opa hapuloma sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ta hapuloma na꞉ yu dalepame malamale haiya. ");
INSERT INTO xla_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Epedeme wua꞉ natiya, oplamitapo dlowe alisisi demdeta ya꞉ dupa duluye pobatalimasemde. Amasiyama oplami ya꞉ dupa dulu tle malamale woyamdeta ya꞉ dupa duluye batalimdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Epalati ya꞉ alotle tlalo sota ya꞉ watle puame epo atlaiyo, “Wa꞉ Pa꞉lisi sotapo wa꞉ta atlamale koko dla siyalasiyaladeye me-malanatima꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Amasiyama Yesuta asiyama yia꞉ watle epo atlaiyo, “Dlomoko dali adiye na꞉ Ata pe-emalalo wekuwa, dlomoko dali hapuloma eye kese mate dodokalepo polollepe. ");
INSERT INTO xla_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Epedeme Pa꞉lisi soye dlomoko dali epapele some ha꞉ha꞉po. Wua꞉ yia꞉ ase sikemte malamiya. Yia꞉ inoma pa꞉talo so epapele some ha꞉ha꞉mama opaye elemtapo. Epapedeme inoma pa꞉le oplamitapo ya꞉mkale inoma pa꞉le oplami haleye semtlepiye, yia꞉ta madipatata munamu dulu dla teteyulupe.” ");
INSERT INTO xla_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Epalati Pitata epo atlaiyo, “Wa꞉ta atla wayu ya꞉ dulu kokoye di watle woloma imane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Epapalati asiyama Yesutapo epo atlaiyo, “Wua꞉ ala yu i ya꞉ dulu kokoye yeitampopa꞉pa? ");
INSERT INTO xla_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Epedeme wua꞉ natiya, wua꞉ta dlowe alisisi hame dlomdeta wua꞉ dupa dulu pobatalimasemde. Adipalati, dlowe alisisi iye isikimi koko dulu dla tulupame ma alikili dla ulatamdepo. ");
INSERT INTO xla_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amasiyama oplami mati tle yukamde koko hapulomatapo ya꞉ dupa dulu tle woyapame ya꞉ye batalimdepo. ");
INSERT INTO xla_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Adipalati, ya꞉ dupa dulu tle ipapele kokota wowoyamdepo, batalimale koko malamolowe, epo ya꞉mkale yumuluwe, epo ya꞉mkale ya꞉llu mate ya꞉mkale ya꞉wolali mate uhalowe, epo opa mate wola꞉ mate uhalomolowe, epo upo alisisi uhalowe, epo ya꞉mkale mala-atlowe, epo ya꞉mkale hi mate putlopo atlowe. ");
INSERT INTO xla_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Epedeme batalimale koko hapuloma itapo wa꞉ye batalimale oplami demdepo. Amasiyama do pohowahalalo daya dlomdetapo wa꞉ye pobatalimale oplami desemde.” ");
INSERT INTO xla_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu mo eye saliyome ma Taya mo mate epo Saidon mo mate dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ya꞉ edla tame woyamalati a꞉ya haletapo ya꞉ hala dla puaiyo. A꞉ya eye Keinan a꞉yayo. Epapeleye ya꞉tapo Yesu natipame yu teta꞉le mate epo atlaiyo, “Lod, Deibidi Yami, wa꞉ na꞉ polowamane. Adipalati, na꞉ amseyemalaye bataliyata ya꞉ dulu dla tuwame halemama ya꞉ dla wotiyalle pato hapimhalemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amasiyama Yesuta yu e dalepame yu hale po-atlaiyo. Epalati ya꞉ alotle tlalo sota Yesu watle puame epo atlaiyo, “A꞉ya iye di dolumsela꞉mama sikemte yu teta꞉msela꞉ma. Epedeme wa꞉ ya꞉ye ma-tane dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Epalati Yesutapo yia꞉ watle epo atlaiyo, “Godtapo na꞉ye isikimi Isalael so dla tane duwapo. Adipalati, Isalael soye ma sipi aliya halo epapele some mo-haohaodepo ha꞉ha꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Epedeme a꞉yatapo ma puame Yesu hete sitali dla heodepo polomama epo atlaiyo, “Lod, na꞉ gadene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Epalati Yesuta asiyama a꞉ya watle wayu mate epo atlaiyo, “Yimlala dayaye halopame ma esemala dla ilimoloweye poka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amasiyama a꞉yatapo Yesu watle epo atlaiyo, “Yao, Lod, wa꞉ ikadepe atlapo. Epapele tlope esemalaye yia꞉ ata daya demama akutu ta꞉la dla teteyulati dlomsiyamdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Epalati Yesuta ya꞉ watle epo atlaiyo, “A꞉ya, wa꞉ta mikadepe dleye pta pato. Epedeme na꞉tapo wa꞉ta atlale kokoye ala꞉lowepo,” diyo. Epapele oloma medla a꞉ya e ya꞉ amseyemalata ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu mo e saliyome ma Ga꞉lili kaula peleyama tle polomyaiyo. Ya꞉ etle ma hetame tamali di dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Epalati opata Yesu watle esusulumale so hohopo puame ya꞉ hete sitali dla ipila꞉iyo. Opitapo akoloyalemale so hohopo pumhalaiyo, epo opitapo inoma pa꞉talo so, epo opitapo moto palli so, epo opitapo yu pa꞉talo so, epame esusulumale opi mila꞉pi meyelope meyelope dle so opi ma me-hohopo pumhalaiyo. Epalati Yesutapo esusulumale so hapulomaye ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Epapele dulu dla opata koko i natipame sikemte yiyelemama Isalael so yia꞉ God dla siyele pato ta꞉diyo. Adipalati, yu pa꞉talo sota ma yuhamyaiyo, epame moto palli so ma mo-sillipo siyamaiyo, epame akoloyalemale so ma ka꞉ka꞉depo siyamaiyo, epame inoma pa꞉talo so ma ma-tlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Epalati Yesutapo ya꞉ alotle tlalo so sisilapame epo atlaiyo, “Opa alumale iwoloye na꞉ mate alila dapahatlope dla siyamuwapo. Epame ma yia꞉ta daya dimi popa꞉lati natipame yia꞉ sikemte bokotiyama. Na꞉ yia꞉ daya po-ilimalalo ma-taiya dlowe tlope yia꞉ api duka dla tamalemama daya yilo hopeyalimelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Epalati ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Dlowe pa꞉le mo hema dita hadima dlowe hapo opa pato iwolo ilipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Epalati Yesuta asiyama epo atlaiyo, “Wua꞉ dla daya adisowata hutiyema꞉?” diyo. Epalati yia꞉ta asiyama epo atlaiyo, “Isikimi daya 7 mate epo amalo dapiyamte yemalata hutiyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Epalati Yesuta opa hapulomaye ta꞉la dla popa꞉iya depame daya 7 mate epo amalo mate halopo siyele yu God dla hamiyo. Epo daya mate amalo mate hauwokokopo ya꞉ alotle tlalo so watle hapiyo, opa watle alemelepo depame. ");
INSERT INTO xla_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Opa hapulomata daya dlopo sikemte susukaliyo. Epalati ya꞉ alotle tlalo sota daya akutu ipi popomelleye yekalo 7 dla atilimama poposatilimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Epedeme opa mate epo wola꞉ mate epame yimlala mate daya i deiyo. Amasiyama sesa꞉le oloma dla opa siyapo tlo sesa꞉mama 4,000 umaiyo. ");
INSERT INTO xla_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu opa hapuloma ma-taiya depame ya꞉ alotle tlalo so mate koa dla tulume alumaiyo. Epame Magadan mo mateka꞉pi dla uliyo. ");
INSERT INTO xla_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Epame Pa꞉lisi so mate epo Sa꞉dusi so mate Yesu hala dla puame ya꞉ta itiyamale hamsela꞉ye ikadepe God tle malata꞉ depame epo atlaiyo, “Wa꞉ pepele di tle ulugiyemale koko di watle nati-ine,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ tamila꞉la salita ka꞉pi tutula꞉la natipame epo atlemdepo, ‘Iyela sali ka꞉pi hallepe,’ demdepo. Epame wua꞉ ma utulalati wuala dikilita pepele di bopudepo ellati natipame, ‘Wata tiyo hellepe,’ demdepo. Epedeme wua꞉ ipapele kokota wowoyamoloweye mo-wua꞉malamana. Amasiyama wata oloma hema wowoyamhala koko hapuloma yia꞉ dulu kokoye powua꞉malamana. ");
INSERT INTO xla_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wata oloma hema ha꞉ha꞉ so opaye pta bobtalimana. Epame yia꞉ ma God kokoye pokoko desemdepo. Epammama yia꞉ ulugiyemale koko tlo tlamha꞉ha꞉lowedeme na꞉ watle atlamha꞉ha꞉po. Amasiyama na꞉ yia꞉ dla ulugiyemale koko hale ponati-iliwa, isikimi Yona koko tlo yia꞉ watle nati-iliwepo.” Yesu koko i atlepo gudepame yia꞉ saliyome ma-taiyo. ");
INSERT INTO xla_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Epame Yesu mate epo ya꞉ alotle tlalo so mate kaula seme dla uliyo. Yia꞉ edla tame popa꞉mama ya꞉ alotle tlalo sota yia꞉ta daya dimi puale kokoye momalampopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yia꞉ epo momalampopa꞉lati Yesuta yia꞉ watle epo atlaiyo, “Ka꞉e, wolomape! Pa꞉lisi so mate Sa꞉dusi so mate yia꞉ta imale kokoye daya haka꞉le sepena. Adipalati, daya amko ka꞉dleye daya haka꞉le mate dukumelepiye, daya amko ka꞉dleye batalimelepe.” ");
INSERT INTO xla_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amasiyama Yesu ya꞉ alotle tlalo sota koko i dalepame yiskamu yia꞉ dulu dla esempopa꞉mama epo atlamyaiyo, “Dita daya pohame pulalo wekele koko tle Yesutapo di natipo yu epo atlapo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Epapalati Yesuta yia꞉ta momalampopa꞉leye ma-natipame yia꞉ watle epo atlaiyo, “Wua꞉ adipapalati wua꞉ta daya pohampulalo wekele koko dla sikemte momalampopa꞉ma꞉? Wua꞉ta mikadepe dleye pta yimka꞉sikilipo. ");
INSERT INTO xla_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Epame wua꞉ na꞉ta itiyamale dla ala pomikadepe dlalo ha꞉ha꞉pa? Epame wua꞉ na꞉ta 5,000 opaye daya do supulastale mate hauwokokopo ilimuwaye mo-woweluwapa? Epame yia꞉ta daya dlopo popomellati wua꞉tapo yekalo adisowa dla atilimuwa? ");
INSERT INTO xla_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Epame wua꞉ ma na꞉ta 4,000 opaye daya 7 mate hauwokokopo ilimuwaye wua꞉ e ma mo-woweluwapa? Epame yia꞉ta daya dele popomelleye yekalo adisowa dla atilimuwa? ");
INSERT INTO xla_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Epedeme na꞉ daya kokoye wua꞉ watle po-atlana. Wua꞉ koko iye adipalati ala pomalamalalo popa꞉ma꞉? Amasiyama na꞉ta atlama kokoye wua꞉tapo Pa꞉lisi so mate epo Sa꞉dusi so mate yia꞉ta imale dla tullala depame wuskamu woloma omha꞉ha꞉lepo depo yu i atlalepo.” ");
INSERT INTO xla_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Epalati ya꞉ alotle tlalo sotapo edla malanatiyo, Yesuta ikadepe daya koko dla po-atlalo, isikimi Pa꞉lisi so mate epo Sa꞉dusi so mateta imale koko dla atlaleye. ");
INSERT INTO xla_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuta tame Kasaliya Pilipi mo dla sela꞉mama ya꞉ alotle tlalo so watle epo atlaiyo, “Opatapo Opa Yamiye ana demdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Epalati yia꞉ta ya꞉ watle epo atlaiyo, “Opa opitapo wa꞉ye Yon opa yú dla ka꞉ka꞉timalalo demdepo. Epame ma opita wa꞉ye Ilaya mle demdepo. Epalati asiyama opita wa꞉ye Yelemaya mle demdepo. Epame ma opita wa꞉ye God tle yu hapame molo atlamalalo so ka꞉yapa ha꞉ha꞉uwa oplami hale mle demdepo.” ");
INSERT INTO xla_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Amasiyama wua꞉ta na꞉ye ana demdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Epalati Saimon Pitata asiyama epo atlaiyo, “Wa꞉ye Keliso, kokó halepo halemhala God Yamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Epapalati asiyama Yesuta ya꞉ watle epo atlaiyo, “Saimon Pita, Yona yami, wa꞉ye siyene. Adipalati, oplami haletapo wa꞉ watle koko iye po-imana. Amasiyama na꞉ A Pepele di dla halatapo wa꞉ imalepo. ");
INSERT INTO xla_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Epedeme Pita, na꞉ wa꞉ dla atlema, wa꞉ye ewalapo. Epedeme na꞉tapo ewala tama hema na꞉ sosye kotiyamolowepo. Epapele dulu dla polowe itiyamaletapo sos eye potla꞉mtlowa. ");
INSERT INTO xla_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Epame na꞉ Pepele dimo kokoloma eloye wa꞉ watle hapilowepo. Epedeme wa꞉ apa kokoye ta꞉lamo hema polupo ellepiye, Pepele dimo dla ma mepo polupo ellepe. Epame wa꞉ apa kokoye ta꞉lamo hema towastlepiye, Pepele dimo dla ma mepo towastlepe.” ");
INSERT INTO xla_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ya꞉ epo halemama yu itiyamale mate ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ opa watle atlemama na꞉ye Kelisopo demiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Epame oloma etle Yesutapo ya꞉ alotle tlalo so watle ya꞉ta polowe kokoye atlamsela꞉lowe kotiyamaiyo. Epammama ya꞉ta yia꞉ watle epo atlaiyo, “Na꞉ye Yelusalem dla hetlati Yu so dokopala so mate epo aiyalma aya dokopala so mate epo aiyalma imalalo so mateta na꞉ dla wotiyalle hamilipe. Epame opata na꞉ye yumulati wabasi dulu dla powame elepo alila dapahatlope dla ma pasakalo depame sila꞉tilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Epalati Pitata Yesuye alikili dla hamamtame halemama ya꞉ watle epo atlaiyo, “Hao Lod, koko ipapeleta wa꞉ dla woyamoloweye poka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amasiyama Yesuta Pita dla helestame halemama epo atlaiyo, “Saiten, na꞉ tle alikili a꞉ma tane. Wa꞉ta yu ipo atlatapo na꞉ye pogadesema. Adipalati, wa꞉ta yu atlaleye God tle popuasema. Amasiyama opata malamale tle puapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu matle ya꞉ alotle tlalo so dla epo atlaiyo, “Oplami antapo na꞉ dolumpuluwe solotamelepiye, ya꞉ ya꞉skamu ya꞉ta solotamale koko hamsela꞉ye memelepame ya꞉ dali yekelemhimiliye maka꞉himsela꞉mama na꞉ dolumpulupe. ");
INSERT INTO xla_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amasiyama oplami antapo ya꞉ pasakaloye meyelo gadlowedeme apelepiye, ya꞉ pasakaloye haodlepe. Amasiyama oplami antapo na꞉ yilo ya꞉ pasakaloye haodlepiye, ya꞉ matle halepo halepo pasakalo halepe. ");
INSERT INTO xla_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amasiyama oplami antapo ta꞉lamo pato hema halemama ya꞉ta solotamale koko hapulomaye ma-halopame hatlo pasakalo hallowe koko tlo hotlepiye, ya꞉ ma apa koko hapa꞉? Hawa. Adipalati, ya꞉ta alisisi hapuloma ta꞉lamo hema halopo halale e mate halepo halepo pasakalo pohalowa. ");
INSERT INTO xla_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Epapedeme Opa Yamitapo ya꞉ ata hela꞉dle mate epo ya꞉ banakaka so mate pumama opa hapuloma dla yia꞉ta halomha꞉ha꞉le asiyamaye mepo ala꞉po halopilipe. ");
INSERT INTO xla_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Epapele dulu dla na꞉ mikadepe koko wua꞉ watle atlema. Wua꞉ dulu dla opa opi me-ha꞉ha꞉po. Yia꞉tapo Opa Yamita ya꞉ Pepele dimo koko mate pulati natipame alotle pallipe.” ");
INSERT INTO xla_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Epame alila 6 mogudlati Yesutapo Pita mate epo Yeims mate epo Yeims ya꞉ ei Yon mate tamali di ikadepe dla miyelo ha꞉ha꞉la hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yia꞉ edla hetame popa꞉mama natilati Yesutapo ya꞉ Pepele dimo mila꞉pi himhalla natiyo. Epalati ya꞉ mila꞉pitapo sali some hela꞉demama usiyemaiyo. Epame ya꞉ tlukatapo sikemte kamama hela꞉dle some halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yia꞉ edla me-ompopa꞉mama natilati Moses mate epo Ilaya mate wowoyapo Yesu mate yuhamha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Epalati Pitata Yesu watle epo atlaiyo, “Lod, di mo hema ha꞉ha꞉lowe ka꞉pi. Epedeme wa꞉ta ka꞉dena dlepiye, na꞉ hema kimna꞉ya dapahatlope kimtimolowepo. Kimna꞉ya haleye wolëpo, epame haleye Moses tete, epame haleye Ilaya tete dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ala me-yukamhallati wuala sikemte hela꞉dletapo malame yia꞉ye bopudiyo. Epalati wuala dulu tle yuta epo atlaiyo, “Iye na꞉ta sikemte malamama dupa ellalo maseyemalapo. Na꞉ ya꞉ dla sikemte siyema. Epedeme ya꞉ yu dla daliya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Epalati Pita wolota koko i natipame sikemte wowota꞉mama ta꞉la dla tulume hutiyemama yia꞉ mila꞉pi isili dla poutalepo hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Amasiyama Yesuta puame yia꞉ dla umama epo atlaiyo, “Wua꞉ silliya. Ase sikemte wowota꞉miya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Epalati yia꞉ta sillipame toko natitepo Yesuta meyelo halla natiyo. ");
INSERT INTO xla_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Epame yia꞉ tamali di tle malemha꞉ha꞉mama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ta tlamale kokoye opa opi watle atlamiyo. Amasiyama Opa Yamita popo sila꞉time me-hetlati alotle atlamsiyamaiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Epalati Pita wolota Yesu watle epo atlanatiyo, “Adipalati aiyalma imalalo sota imama ‘Ilayata itapu pulati Kelisota alotle pulupe’ demdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesuta asiyama yia꞉ watle epo atlaiyo, “Ikadepe, Ilaya tatle puame koko hapulomaye ma woloma ka꞉ka꞉depo dinapelepe. ");
INSERT INTO xla_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amasiyama na꞉ wua꞉ dla atlema, Ilayaye mo-puwapo. Epapele tlope opatapo ya꞉ye woloma pomalanatilalo ya꞉ dla wotiyalle halopimyeuwapo. Epammama yia꞉tapo Opa Yami dla ma mepo wotiyalle halopimyelepe.” ");
INSERT INTO xla_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Epalati yia꞉tapo Yesuta epo atla dalepame asiyama yia꞉ta malamaleta Yon opa yú dla ka꞉ka꞉timalaloye semte ikadepe Ilayata pua tepo diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesuta ya꞉ alotle tlalo so dapahatlope mate tamali di tle tulume opa hapuloma yia꞉ ompopa꞉le so dla woyamalati oplami haleta puame Yesu hete isili dla heodepo polomama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Lod, wa꞉ na꞉ maseyemalaye polowamane. Adipalati, ya꞉tapo yiyilamaleta ya꞉ dla halati ya꞉skamu yú dulu dla epo dlapa dulu dla tutula꞉msela꞉mama wotiyalle pato hamde. ");
INSERT INTO xla_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Epapeleye na꞉tapo maseyemala eye wa꞉ alotle tlalo so dla puame nati-ilati yia꞉tapo ya꞉ye poka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Asiyama Yesuta epo atlaiyo, “Wua꞉ye mikadepe dle pa꞉talo bobtalimale sopo. Wua꞉ta na꞉ dla mikadepe dlepo depame na꞉ alila adisowaye wua꞉ mate halepa꞉? Amasiyama maseyemala eye na꞉ watle hamampuaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Epame Yesuta maseyemala dulu tle bataliyaye alikili dla dodolomaiyo. Epapele oloma edla maseyemalatapo ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Koko ita tame gudlati alotle Yesu ya꞉ alotle tlalo sotapo miyelo popa꞉mama Yesu watle epo atlaiyo, “Di adipalati bataliyaye maseyemala tle alikili dla dodolomolowe dla itiyamale hawa halo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Wua꞉ta mikadepe dleye pta yimka꞉sikili ikadepe. Epapele koko tle wua꞉ta bataliya i alikili dla dodolomoloweye itiyamale hawa halalepo. Epedeme na꞉ ikadepe koko wua꞉ dla atlema. Wua꞉ta mikadepe dleta dlomoko ale yimka꞉sikili epapele some wua꞉ dla me-hutiyelepiye, eta wua꞉ ala꞉na, tamali watle atlemama ‘ma huma tame polane’ dlepiye, mepapelepe. Epedeme koko haletapo wua꞉ dla pokokallowa.  ");
INSERT INTO xla_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amasiyama bataliya ipapeleye isikimi daya aiyalma depo halemama inoma sumale mate alikili dla dodolomlala.” ");
INSERT INTO xla_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu ya꞉ alotle tlalo sota puame Ga꞉lili dla alupame ha꞉ha꞉lati Yesuta yia꞉ watle epo atlaiyo, “Opa Yamiye opa do tama dla homellepe. ");
INSERT INTO xla_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Epalati yia꞉tapo ya꞉ye yumilipe. Amasiyama ya꞉ye powame elepame ma dapahatlope alila dla ma pasakalo depame sila꞉tilipe.” Epalati Yesu ya꞉ alotle tlalo sotapo yu i dalepame sikemte dupa koliyo. ");
INSERT INTO xla_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Epame matle Yesu mate epo ya꞉ alotle tlalo so mate tame Kapaniyem mo dla woyamalati aiyalma aya gadlowe koko dla ta꞉kis mani halomalalo sotapo Pita watle puame epo atlaiyo, “Wua꞉ imalalo oplamiye aiyalma aya gadlowe koko dla ta꞉kis mani hatitimdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Epalati Pitata asiyama epo atlaiyo, “Yao, me-hatitimdepo,” diyo. Amasiyama Pita ala aya dulu dla tumhallati Yesuta ya꞉ watle epo atlaiyo, “Pita, wa꞉ koko iye na꞉ dla atlane. Ta꞉lamo dokopala sotapo opa anawolo tle ta꞉kis mani halomdi? Me-yia꞉ yimlala tle halomdi, o opa opi tle halomdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Epalati Pitata asiyama epo atlaiyo, “Opa opi tle halomde,” diyo. Epalati asiyama Yesuta epo atlaiyo, “Epedeme dokopala oplami ya꞉ yimlalatapo yia꞉ a watle ta꞉kis mani pohatitimolowa. ");
INSERT INTO xla_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amasiyama di poka꞉dena, aiyalma aya gadlowe koko dla ta꞉kis mani halomalalo so iwolo dla siyaladle hamiloweye. Epapedeme wa꞉ tame kaula dla tudi pololepame amalo yelene. Epame ya꞉ mati gowalastame elo mani natilipe. Epame wa꞉ mani e hamtame yia꞉ dla ta꞉kis mani hamimama nolë mate epo wolë mate hatitimane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Alila oloma edla Yesu ya꞉ alotle tlalo sotapo puame Yesu watle epo atlaiyo, “Pepele dimo dulu dla anta pato halema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Epalati Yesutapo maseyemala hale sisilapame yia꞉ dulu dla pamelepo halemama ya꞉ alotle tlalo so watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ malamale meyelope depame maseyemala yimka꞉mala ipapele some poha꞉ha꞉lalo wekelepiye, wua꞉ Pepele dimo dla po-u-ulapo tuluwa. ");
INSERT INTO xla_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Epedeme oplami antapo maseyemala yimka꞉mala ipapele some ya꞉skamu isili dla hamtulupo hallepiye, ya꞉ye Pepele dimo dulu dla pato depo halapo. ");
INSERT INTO xla_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Epame oplami antapo maseyemala ipapeleye na꞉ hi tle ya꞉ aya dla seme hetlepiye, ya꞉ na꞉ye seme hetamama apelepe. ");
INSERT INTO xla_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amasiyama na꞉ dla mikadepe dlalo maseyemala yimka꞉mala ipapeleye oplami antapo seme batalimale koko dla tullupiye, ka꞉dena, oplami eye ewala patota tumuku dla himomeleme ewatalo dla hamastloweye. ");
INSERT INTO xla_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ka꞉e, ta꞉lamo dla ha꞉ha꞉lalo so, wua꞉ yimkadulo! Adipalati, ta꞉lamo pato hema wua꞉ batalimale dla elemtullalo kokoye pta pasatana. Epedeme epapele kokota me-pumhallepe. Amasiyama oplami antapo ipapele koko kotiyamhalema꞉, wa꞉ye wolomape! Godtapo epapele oplami dla wotiyalle sikemte pato hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Epedeme wa꞉ do aditapo wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, do seme e ketamastloweye. Ame adipalati, ka꞉dlepo, wa꞉ta do hatlope mate Pepele dimo dla ulatuluweye. Amasiyama poka꞉dena, wa꞉tapo do dapiyamte mate halemama kokó elepo ellalo Dlapa mo dla tulluweye. Epame wa꞉ hete aditapo wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, hete seme e ketamastloweye. Ame adipalati, ka꞉dlepo, wa꞉ta hete hatlope mate Pepele dimo dla ulatuluweye. Amasiyama poka꞉dena, wa꞉tapo hete dapiyamte mate halemama kokó elepo ellalo Dlapa mo dla tulluweye. ");
INSERT INTO xla_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Epame wa꞉ inoma adita wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, inoma seme eye holamastloweye. Ame adipalati, ka꞉dlepo, wa꞉ta inoma hatlope mate Pepele dimo dla ulatuluweye. Amasiyama poka꞉dena, wa꞉ta inoma dapiyamte mate halemama Dlapa mo dla tulluweye. ");
INSERT INTO xla_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Epedeme wua꞉ wolomape. Yimlala yimka꞉sikili iye koko pa꞉talo so demiya. Adipalati, yia꞉ banakaka soye Pepele dimo dla na꞉ A mila꞉pi tle me-ha꞉ha꞉po.  ");
INSERT INTO xla_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Epedeme Opa Yamitapo alikili dla haohaodle soye gadla puwapo.” ");
INSERT INTO xla_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Oplamitapo 100 sipi aliya haloye omhallepe. Epapele dulu dla hatlota haodlepiye, ya꞉ ma apa koko hapa꞉? Ka꞉dena, ya꞉tapo 99 sipi aliya opiye medla pomelepame ma hatlo haodle tlo totamtlepe. ");
INSERT INTO xla_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Ya꞉ 99 aliya halo pohaohaodlalo wekele dla siyele me-elapo. Amasiyama ya꞉ hatlo haodleye totapo ma natili dla sikemte siyele pato elapo. ");
INSERT INTO xla_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Epapedeme wua꞉ A Pepele di dla halata posolotamasema, yimlala ipapele dulu dla haleta haodloweye.” ");
INSERT INTO xla_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Epedeme wa꞉ amkale mikadepe dle oplamitapo wa꞉ dla batalimale koko halepiye, ka꞉dena, wa꞉ hemele ya꞉ hala dla tame atellepe. Epapele dulu dla ya꞉ta wa꞉ yu dallepiye, wa꞉ oplami eye batalimale dla ma-tlati ma ka꞉dle api dla sempumama apelepe. ");
INSERT INTO xla_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amasiyama ya꞉tapo wa꞉ yu dalepo pohalalo wekelepiye, wa꞉ epalati ma mikadepe dle so opa opiye ya꞉ hala dla elemtelepe, yia꞉ta wa꞉ gadlepo depame. ");
INSERT INTO xla_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Epapele dulu dla ya꞉tapo ma yia꞉ yu podallalo wekelepiye, epalati koko iye sos dokopala so dla atlane. Amasiyama ya꞉ ala me-sos dokopala so yu dla podallalo wekelepiye, wa꞉ epalati ya꞉ye ma alikili oplami dlepe. ");
INSERT INTO xla_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Epedeme na꞉ ikadepe koko wua꞉ dla atlema. Wua꞉ apa kokoye ta꞉lamo hema polupo ellepiye, Pepele dimo dla ma mepo polupo ellepe. Epame wua꞉ apa kokoye ta꞉lamo hema towastlepiye, Pepele dimo dla ma mepo towastlepe. ");
INSERT INTO xla_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Epedeme na꞉ ma ikadepe koko wua꞉ dla atlema. Ta꞉lamo hema opa dapiyamtetapo malamale hatlope depame koko hadima inoma sumale pato himimpopa꞉lepiye, yia꞉ koko eye na꞉ A Pepele dimo dla hala tle ma-halepe. ");
INSERT INTO xla_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Epapedeme opa dapiyamte epapele o dapahatlope epapeleta na꞉ hi tle puame alupo popa꞉lepiye, na꞉ yia꞉ mate me-halapo.” ");
INSERT INTO xla_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Epapele oloma edla Pitata puame Yesu watle epo atlaiyo, “Lod, namkale mikadepe dle oplamita na꞉ dla batalimale koko halomhallati asiyama na꞉ta ya꞉ batalimaleye adisowa oloma dla wowelipa꞉? 7 oloma dla tame gudepa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Epalati asiyama Yesuta epo atlaiyo, “Hao, 7 oloma edla ya꞉ batalimaleye powelilowa, amasiyama 77 oloma dla ya꞉ batalimaleye wowellipe. ");
INSERT INTO xla_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Epedeme Pepele dimo kokoye ipapena. Dokopala oplami ya꞉ oko sotapo ya꞉ tle ya꞉ maniye isikimi samta halomaiyo, alotle ma mesowa ya꞉ watle hapilowedeme. ");
INSERT INTO xla_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Epapeleye ya꞉ oko oplami hale, ya꞉ tle mani pato holaleye, ya꞉ hala dla sempuaiyo. ");
INSERT INTO xla_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Amasiyama oplami etapo mani mesowa ilame hamiloweye po-ala꞉iyo. Epalati dokopala oplamitapo ya꞉ opa watle epo atlaiyo, ‘Oplami i mate epo ya꞉llu mate epo ya꞉ yimlala mate epame ya꞉ alisisi hapuloma mate tame opa opi watle hohopo ipame asiyama mani tlo hapo ma na꞉ watle hampuaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Epalati oko oplami etapo ya꞉ dokopala oplami hete sitali isili dla teyume alumata kellepo polomama otele mate epo atlaiyo, ‘Wa꞉ na꞉ polowamama aseka alila yimka꞉mala omhalane. Na꞉ monolo alotle asiyama mesowa himilowepo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Epalati dokopala oplamita ya꞉ye sikemte polowamama ya꞉ watle epo atlaiyo, ‘Wa꞉ta na꞉ mani hauwa asiyama dla wa꞉ta na꞉ watle alotle hamili dleye memelene. Adipalati, na꞉ ma koko eye mo-welima. Epedeme wa꞉ siyele mate tane,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Epalati oko oplamita ma ilame tamama natilati ya꞉mkaleta pula natiyo. Oplami itapo oko oplami ya꞉ tle mani pastoye isikimi samta haiyo. Epapeleye oko oplami etapo ya꞉ natipame tumuku dla hamame popokalemama epo atlaiyo, ‘Wa꞉ta na꞉ tle mani hauwaye wata asiyama mesowaye na꞉ watle hamine,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Epalati asiyama ya꞉mkale etapo oko oplami e ya꞉ hete isili dla teyume alumata kellepo polomama otele mate epo atlaiyo, ‘Wa꞉ na꞉ polowamama aseka alila yimka꞉mala omhalane. Adipalati, na꞉ ma monolo alotle mani mesowaye wa꞉ watle hamilowama,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amasiyama oko oplamitapo ya꞉mkaleta epo atlati alimama ya꞉ye hamamtame amtuwale aya dulu dla ka꞉staiyo, ya꞉tapo hapele asiyama mesowa hamilipo depame. ");
INSERT INTO xla_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Amasiyama dokopala oplami ya꞉ oko so opitapo koko i natipame dupa kolemama yia꞉ dokopala oplamiye atla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Epalati dokopala oplamita koko i dalepame ya꞉ oko oplami eye sisilapame ya꞉ watle epo atlaiyo, ‘Wa꞉ye sikemte batalimale oplami ikadepepo. Wa꞉ta isikimi yepa꞉ta na꞉ mani pato hapame ma alotle himiloweye wa꞉ dla po-ala꞉lalo wekelati na꞉ta wa꞉ye polowamama mope memelene duwapo. ");
INSERT INTO xla_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Epedeme wa꞉ ma asiyama wa꞉ amkale polowamama epapolowe ka꞉pipo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Epo atlepame dokopala oplamitapo siyalademama ya꞉ oko oplami e watle epo atlaiyo, ‘Wa꞉ta wa꞉ amkale popolowamalalo amtuwale aya dla ka꞉staleye, na꞉ ma asiyama wa꞉ye mepo amtuwale aya dla ka꞉stlowepo. Epame wa꞉tapo na꞉ tle mani pato isikimi samta hauwaye ma mesowa himilipe,’ diyo.” ");
INSERT INTO xla_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesuta yu i atlepo gudepame ma opa watle epo atlaiyo, “Epedeme wua꞉tapo wua꞉ amkale mikadepe dle oplami ya꞉ batalimaleye wua꞉ dupa dulu tle powelilalo ha꞉ha꞉lepiye, asiyama na꞉ A Pepele di dla halatapo wua꞉ batalimaleye powelilowa.” ");
INSERT INTO xla_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu koko i atlemhalepo gudepame Ga꞉lili mo saliyome ma Yudiya mo dla tamama Yoden aloma ulumtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ya꞉ edla tlati opa hapulomatapo ya꞉ dolumtamalaiyo. Epalati Yesutapo yia꞉ dulu dla esusulumale hutiyele hapulomaye ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Epame oloma edla Pa꞉lisi so opita puame Yesu dla batalimale koko natilowedeme ya꞉ watle epo atlaiyo, “Oplamitapo isikimi koko pa꞉le dla a꞉ya melloweye aiyalma elema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Wua꞉ God yu posesa꞉lalo wekemdi? Godtapo ta꞉lamo mita꞉ple oloma edla oplami mate epo a꞉ya mate mimita꞉puwapo. ");
INSERT INTO xla_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Epame Godta epo atluwapo, ‘Epedeme oplamitapo ya꞉ a mate epo ya꞉ wai mate melepame ma ya꞉llu mate hatlope depo hallepe. Epame yia꞉ta madipatatapo moto hatlope depo ha꞉ha꞉lepe,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Epedeme yia꞉ta ha꞉ha꞉le dulu dla yia꞉ podapiyamte, amasiyama yia꞉ ma hatlopepo. Epapedeme Godta yia꞉ta dapiyamte ma-hatlope dleye ma oplami haleta poduka gladlowa.” ");
INSERT INTO xla_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amasiyama Pa꞉lisi sota ma asiyama Yesu watle epo atlaiyo, “Ame adipalati Mosesta atlemama a꞉ya mellowedeme isikimi a꞉ya mellalo pepa tlo ilipo a꞉yaye ma-tane demha꞉ha꞉iye duwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Epalati asiyama Yesuta epo atlaiyo, “Mosestapo wua꞉ dupa dulu kokalalimale tlapame wua꞉ta wua꞉ wola꞉ memelloweye me-ka꞉pi duwapo. Amasiyama kotiyamale sitali dla Godtapo a꞉ya mellowe kokoye po-atlana. ");
INSERT INTO xla_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Epedeme na꞉ wua꞉ watle atlema, oplamitapo ya꞉llu pomellowa. Amasiyama a꞉ya etapo oplami hale uhalepiye, etapo ya꞉wolalitapo ya꞉ye mellowe ka꞉pi. Epedeme oplamitapo ya꞉lluye isikimi koko pa꞉le melepame ma a꞉ya hale halepiye, ya꞉ a꞉ya eye uhapo.” ");
INSERT INTO xla_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Epalati Yesu ya꞉ alotle tlalo sotapo ya꞉ watle epo atlaiyo, “Epedeme epapele kokotapo ellepiye, poka꞉dena, oplamitapo a꞉ya haloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Epalati Yesuta yia꞉ watle epo atlaiyo, “Imale koko iye opa hapuloma dla potasema. Amasiyama isikimi wola꞉ halomalalo so dla tapo. ");
INSERT INTO xla_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Adipalati, opa opiye wola꞉ halopo yimlala hatitimoloweye po-ala꞉na. Adipalati, yia꞉ waidulota yia꞉ hohomale tle yia꞉ mepapena. Epapele koko tle yia꞉ wola꞉ pohalomasemde. Epalati opa opiye me-yimkadulotapo yia꞉ moto dla ulu hatitimale koko tle yia꞉ mape wola꞉ pohalomha꞉ha꞉sema. Epalati asiyama opa opitapo Pepele dimo koko yilo wola꞉ pohalomha꞉ha꞉sema. Epedeme oplami antapo a꞉ya hali dlepiye, ya꞉ ka꞉dena, na꞉ta a꞉ya halowe koko dla ima iye dolumelepe.” ");
INSERT INTO xla_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Opa opitapo yia꞉ yimlalaye Yesu hala dla elempumulaiyo, Yesutapo yia꞉ yilo inoma sumama ya꞉ do mate yia꞉ u-umamelepo depame. Epalati ya꞉ alotle tlalo sota koko e natipame yia꞉ye humatlaiyo. ");
INSERT INTO xla_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amasiyama Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Yimlalaye na꞉ hala dla pumula diya, yia꞉ humatlemiya. Adipalati, ipapele sotapo Pepele dimo dla u-ulapo tulupe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Epame ya꞉tapo ya꞉ do mate yia꞉ u-umapame ma mo hale dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oplami haleta Yesu watle puame epo atlaiyo, “Imalalo oplami, na꞉ apa koko ka꞉dle hapo, halepo halepo pasakalo hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Epalati Yesu asiyama ya꞉ watle epo atlaiyo, “Wa꞉ adipalati na꞉ watle puame ka꞉dle koko dalema꞉? Hatlo God tlo ka꞉dle halapo. Epapedeme wa꞉ halepo halepo pasakalo halowedeme apelepiye, wa꞉ aiyalma koko dolumhalane.” ");
INSERT INTO xla_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Asiyama oplamita epo atlaiyo, “Apa aiyalma kokota꞉?” diyo. Epalati Yesu ya꞉ watle epo atlaiyo, “Wa꞉ ya꞉mkale yumula aiyalma, epo wa꞉ upo a꞉ya uhala aiyalma, epo wa꞉ upo alisisi uhala aiyalma, epo wa꞉ amkale hi mate isikimi mala-atla aiyalma, ");
INSERT INTO xla_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","amasiyama wa꞉ a mate epo wa꞉ wai mate yia꞉ yu dla heodepame salladepo sela꞉lepe, epame wa꞉ wa꞉skamu sikemte bokotiyapo malamdiye, epammama wa꞉ amkale ma sikemte bokotiyapo malamelepe.” ");
INSERT INTO xla_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Amasiyama oplamitapo Yesu watle epo atlaiyo, “Aiyalma koko hapuloma iye na꞉ta mo-dolumhaluwapo. Epele tlope na꞉ ma apa koko hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Epalati Yesuta ya꞉ watle asiyama epo atlaiyo, “Wa꞉ ullu pa꞉po halemama woloma Godta solotamale koko mate ala꞉po halli dlepiye, wa꞉ tame wa꞉ alisisi hapulomaye opa opi watle hapipame asiyama mani tlo hapo puame atali so dla hapine. Wa꞉ta epapelepiye, Pepele dimo dla alisisi pasataletapo wa꞉ hi mate ellepe. Epame ma na꞉ dolumpuane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Oplamitapo Yesu yu i dalepame sikemte dupa kolle mate taiyo. Adipalati, ya꞉ye alisisi pasatepo halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Epalati Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Na꞉ ikadepe kokoye wua꞉ dla atlema. Alisisi pasatale oplamitapo Pepele dimo dla ulatuluweye pta kokalena. ");
INSERT INTO xla_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Epedeme na꞉ matle wua꞉ dla atlema, ka꞉mol aliyatapo tluka dedlemalalo tuwale opokoko tle ulatuluweye ka꞉deta꞉? Hao, po-ulatuluwa. Epedeme e ma epapena, alisisi pasatale sota Pepele dimo dla ulatuluweye pta kokalena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Amasiyama ya꞉ alotle tlalo sota imale i dalepame yiyelemama epo atlaiyo, “Ame epo kokalleye oplami anta ulatupa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Epalati Yesuta yia꞉ watle omhalemama epo atlaiyo, “Oplamita meyelo ya꞉ pasakalo gadloweye po-ala꞉na. Amasiyama God tlo ala꞉na. Adipalati, ya꞉ta koko hapuloma haloweye pokokalena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Epalati Pitata Yesu watle epo atlaiyo, “Dia꞉ye wa꞉ dolumpumama di alisisi hapulomaye medla pomelepo pumulalepo. Epapedeme di asiyama apa koko hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Epalati asiyama Yesuta epo atlaiyo, “Na꞉ ikadepe kokoye wua꞉ watle atlema. Godta koko hapuloma ma-amko dlowe oloma edla Opa Yamitapo dokopala depame ya꞉ta pollalo mo dla pollope. Epalati oloma edla na꞉ dolumsiyamalalo so 12 wua꞉ mape dokopala sota popa꞉lalo mo 12 dla popa꞉mama Isalael so elele 12ye ompopa꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Epame oplami antapo na꞉ hi yilo ya꞉ bapadulo mate epo ya꞉ eidulo mate epo ya꞉ nanadulo mate epo yotumadulo mate epo ya꞉ a mate ya꞉ wai mate epo ya꞉ yimlala mate epo ya꞉ ta꞉la mate epo ya꞉ aya mate salepame na꞉ dolumpulupiye, ya꞉ta wata oloma hema asiyama pato halepe. Epame ma alotle ya꞉tapo halepo halepo pasakaloye halepe. ");
INSERT INTO xla_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Epedeme itapu dla ha꞉ha꞉lalo so opita ma alo dla ha꞉ha꞉lepe. Asiyama alo dla ha꞉ha꞉lalo so opita ma itapu dla ha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Pepele dimo kokoye ipapena. Osalo ya꞉ atapo utulala ikadepe oko so elemala telepe, ya꞉ta gla꞉pi dlomoko emale dla oko halepo depame. ");
INSERT INTO xla_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Epame ya꞉tapo opa opi natipo yia꞉ mate yia꞉ oko asiyama dla esemama alila hatloye elo mani hatlo hamilipe diyo. Epame yia꞉ye mo-oko hala taiya diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Epedeme osalo ya꞉ atapo sali inoma 9 oloma dla hallati ya꞉ mamisika꞉ mo dulu dla tamama natilati opa opitapo isikimi koko pa꞉le duka dla siyamalati natiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Epalati ya꞉tapo yia꞉ watle epo atlaiyo, ‘Wua꞉ ma tame na꞉ alisisi emale dla oko haiya. Epalati na꞉tapo tamila꞉la dla wua꞉ oko asiyama mate ala꞉le mani hapilowepo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Epame yia꞉ye mo-oko dla taiyo. Epo alila hatlo medla sali inoma mo-duka dla hallati ya꞉ opa opi mape elemtame ya꞉ osalo dulu dla oko haiya diyo. Epame ma alila hatlo medla sali inoma dapahatlope oloma dla hallati ya꞉ matle opa opiye eleme tame oko hapiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Epame ma alila hatlo medla sali inoma do supulastale oloma dla hallati ya꞉ ma mo dulu dla ilamtame natilati opa opitapo koko pa꞉le siyamalati natiyo. Epalati ya꞉tapo yia꞉ watle epo atlaiyo, ‘Wua꞉ adipalati koko pa꞉le alila pato isikimi hema ha꞉ha꞉ma꞉?’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Epalati asiyama yia꞉ta epo atlaiyo, ‘Oplami haleta dia꞉ye ya꞉ oko halepo depo di watle po-atlana,’ diyo. Epalati ya꞉ta yia꞉ watle atlemama, ‘wua꞉ ma na꞉ osalo dla oko hala puaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Epame tamila꞉la oloma edla osalo ya꞉ atapo ya꞉ oko oplami hale watle epo atlaiyo, ‘Osalo dulu dla oko halomalalo so sisilapame yia꞉ oko asiyama mani halopine,’ diyo. ‘Epedeme wa꞉ mani halopimama opa alo ikadepe tle pumulale so tatle halopine,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Epapalati oko sotapo asiyama halomolowedeme mo-puame alumalati alotle oko hala tlalo so tatle yia꞉ oko asiyama dla elo mani hatlope hatlope dle halopiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Epalati opa yia꞉ tatle utulala ikadepe oko hala tamalale sota koko e natipame yia꞉ta malamaleta yia꞉ tlo yia꞉ oko asiyamaye pato halomelepe depo momalampopa꞉iyo. Amasiyama yia꞉ ma elo mani hatlo me-epapele halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yia꞉ mani i halopame allimama osalo ya꞉ a watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Dia꞉ tlo alila pato sali alemalle dla oko hamha꞉ha꞉lepo. Amasiyama opa iwoloye isikimi sali inoma kiyele dla oko halepo. Epapele tlope wa꞉ adipalati yia꞉ watle mani hapili mepapeleye ma di watle hapi?’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Epalati osalo ya꞉ ata yia꞉ dulu dla oplami hale watle epo atlaiyo, ‘Na꞉ batalimale koko hale wa꞉ dla pohana. Adipalati, wa꞉ alila hatlope oko asiyama elo mani hatlo me-epapeleye hali depame oko halowe solotamalepo. ");
INSERT INTO xla_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Epedeme wa꞉ mani e hame ma-tane. Na꞉ solotama, na꞉tapo wa꞉ watle mani hamili mepapeleye ma opi watle hapilowedeme. ");
INSERT INTO xla_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Adipalati, na꞉ ka꞉dena, na꞉tapo na꞉ mani mate na꞉ta solotamale koko haloweye. Epapele tlope wa꞉ adipalati na꞉ta ka꞉dle koko halati ma na꞉ watle siyaladema꞉?’ diyo.” ");
INSERT INTO xla_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Epalati Yesuta ma epo atlaiyo, “Epedeme wata oloma hema alo dla ha꞉ha꞉ sotapo ma itapu dla ha꞉ha꞉lepe. Epame ma itapu dla ha꞉ha꞉ sotapo ma alo dla ha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Yelusalem dla hetamama ya꞉ alotle tlalo soye alikili dla hohopo tame halemama yia꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ka꞉e! Di Yelusalem dla matamayo. Edla Opa Yamiye Yu so aiyalma aya dokopala so mate epo aiyalma imalalo so mate dla homellepe. Epalati yia꞉tapo ya꞉ koko gladepo, ya꞉ta polowe kokoye atlepame ma po-Yu so dla homellepe. ");
INSERT INTO xla_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Epame po-Yu sota ya꞉ye hampame ya꞉ dla tetlemyemama putlopo atlamyelepe. Epame ya꞉ye hopolemtame dali yekelemhimili di dla gogodlepe. Amasiyama ya꞉ye wabasi dulu dla powame elepame ma dapahatlope alila dla pasakalo depame sila꞉tilipe.” ");
INSERT INTO xla_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Epame Sebedi ya꞉ akimlala Yeims mate epo Yon mateye yia꞉ waita eleme Yesu hala dla puaiyo. Epame yia꞉ waitapo ya꞉ akimlala koko dla Yesu watle dalla natilowedeme ya꞉ hete sitali dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ apa kokoye na꞉ watle atla puo?” diyo. Epalati asiyama ya꞉ta Yesu watle epo atlaiyo, “Wa꞉ mo kokota pulati na꞉ akimlala dapiyamte dulu dla haletapo wa꞉ dowala tiyama dla pola epo haletapo wa꞉ weke tiyama dla pola dlowe ka꞉deta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ wua꞉ta atla kokoye powua꞉malama. Wua꞉ na꞉ta wotiyalle pato halowedeme halaye wua꞉ ma mepapele halowe ala꞉ta꞉?” diyo. Epalati asiyama yia꞉ta epo atlaiyo, “Yao, di ma-ala꞉na,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Ikadepe, wua꞉ ma wotiyalle mepapele halepe. Amasiyama na꞉ dowala tiyama dla popa꞉lalo so mate epo na꞉ weke tiyama dla popa꞉lalo so mate sesalemoloweye na꞉ dla itiyamale hawa. Amasiyama isikimi na꞉ Ata ma-sesalemale so siyapotapo mo edla popa꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Epapele dulu dla Yesu ya꞉ alotle tlalo so opa opitapo yu i dalepame Yeims mate epo Yon mate dla sikemte siyalasiyaladiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Epalati Yesuta yia꞉ sisilapame yia꞉ watle epo atlaiyo, “Po-Yu so dokopala sotapo yia꞉ isili tle ha꞉ha꞉lalo soye sikemte itiyamale mate omha꞉ha꞉mdepo. ");
INSERT INTO xla_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amasiyama wua꞉ dulu dla epapolowe poka꞉dena. Epedeme wua꞉ dulu dla anta pato hallowe solotamelepiye, ya꞉ ka꞉yapa wua꞉ yu dla salladepo sela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Epame antapo itapu hallowe solotamelepiye, ya꞉ ka꞉yapa ya꞉skamu isili dla hamtulupame ya꞉ motoye yimkadulo gadlowe oko dla himilipe. ");
INSERT INTO xla_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Adipalati, Opa Yamita ta꞉lamo hema puwaye, opata ya꞉ gadlepo depame popuana. Amasiyama ya꞉ta opaye gadlowedeme puwapo. Epo opata pasakalo halepo depame polowedeme puwapo.” ");
INSERT INTO xla_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesutapo ya꞉ alotle tlalo so mate Yeliko mo meleme tamha꞉ha꞉lati opa hapulomatapo yia꞉ dolumtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Epapele oloma edla inoma pa꞉talo so opa dapiyamteta api duka dla popa꞉iyo. Yia꞉tapo Yesuta pua koko dalepame yu teta꞉le mate epo atlampopa꞉iyo, “Lod, Deibidi Yami, wa꞉ di polowamama di gadene,” dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Amasiyama opata yia꞉ watle epo atlaiyo, “Wua꞉ yu dimi popa꞉iya,” diyo. Amasiyama opata yia꞉ watle epo atlati yia꞉tapo yia꞉ yu podallalo ma sikemte yu teta꞉le mate epo atlempopa꞉iyo, “Deibidi Yami, wa꞉ di polowamama di gadene,” dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Epalati Yesutapo medla hedepame yia꞉ sisilapo yia꞉ watle epo atlaiyo, “Wua꞉ na꞉ta wua꞉ watle apa koko halepo depo solotama꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Epapalati asiyama yia꞉ta ya꞉ watle epo atlaiyo, “Di inoma ka꞉dene. Di ma tlamsiyamolowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuta yia꞉ polowamama yia꞉ inomaye u-umamaiyo. Epalati pakasiyamalalo yia꞉ inomata ma-ka꞉ka꞉dlati yia꞉tapo Yesu alotle dolumtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu mate ya꞉ alotle tlalo so mate Yelusalem mo mateka꞉pi dla tamalemama Olipi tamali kikiwi isili dla mo yemala Betapage dla woyamaiyo. Yia꞉ edla puame woyapo ha꞉ha꞉mama Yesuta ya꞉ alotle tlalo so opa dapiyamteye taiya demama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Wua꞉ mo yemala itapu pola huma taiya. Wua꞉ edla tame natilati donki aliyata ya꞉ yemala mate kikitama hihimapo ha꞉ha꞉lati natilipe. Epalati wua꞉ yia꞉ kikitamaye totowatipame na꞉ watle elempulupe. ");
INSERT INTO xla_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Epapele dulu dla oplami haletapo wua꞉ye atlepiye, wua꞉ asiyama atlemama, ‘Lodta aliya i solotamuwo,’ dlepe. Epalati oplamita wua꞉ watle me-elemtaiya dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Epedeme koko ita wowoyamaleye God tle yu hapame molo atlamalalo oplamita atlamale yu mate ala꞉lowedeme apiyo. Adipalati, ya꞉ta ipo atluwapo, ");
INSERT INTO xla_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Wua꞉ Yelusalem so atlaiya, ‘Wua꞉ dokopala oplamiye wua꞉ dla mo-puapo. Ya꞉ye pta sadena. Ya꞉ye donki aliya yemala tle puapo.’” ");
INSERT INTO xla_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Epapeleye Yesu ya꞉ alotle tlalo sotapo tame Yesuta atlamale koko eye halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yia꞉ tame donki ya꞉ya mate epo donki yemala mate eleme pumulaiyo. Epame yia꞉ kapumale tluka uptipame donki aliya dimsisi di dla kolumalati Yesutapo di dla hetame polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Epalati opa hapulomatapo yia꞉ kapumale tlukaye uptipame api duka dla yalemtlati opitapo usiye kolepame Yesuta tlowe api dla yalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Epalati Yesutapo aliya di tle ma-tamhallati itapu dla tamha꞉ha꞉le so opa mate epo Yesu ko tle pumha꞉ha꞉le so matetapo yu teta꞉le mate epo atlamtamalaiyo, “Deibidi Yami dla sisiyeiya. Lod hi tle pua oplami dla sisiyeiya. Di ikadepe dla hallalo God dla sisiyeiya,” demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu Yelusalem mo dulu dla mo-ulatulati opa hapuloma edla ha꞉ha꞉le sotapo yiyelepame epo atlamyaiyo, “Oplami iye anata꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Epalati opa alumaletapo asiyama epo atlaiyo, “Iye God tle yu hapame molo atlalo oplami Yesupo. Ya꞉ye Ga꞉lili mo pato dulu dla Nasalet mo yemala tle puapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu Yelusalem dla puame aiyalma aya dla hetaiyo. Ya꞉ hetame natilati opata aiyalma aya dulu edla alinepi mate alisisi opi mateye asiyama mate halomyela natiyo. Epela natipame alimama ya꞉tapo aya dulu dla hutiyele alisisi yia꞉ adulo mate epo alisisi e halomalalo so opa mate alikili dla dodolomsaliyo. Epo mani mila꞉pi meyelope meyelope dle omha꞉ha꞉lalo sota mani kolumalaloye dodokotipo pololiyo. Epame opata seselema tea halopo puame hatitimalalo mape dodokotimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Epame Yesuta yia꞉ watle epo atlaiyo, “God yu bukata ipo atlapo, ‘Na꞉ aiyalma ayaye inoma sumalalo aya demha꞉ha꞉lepe,’ depo. Amasiyama epapele tlope wua꞉tapo God ya꞉ aya iye ma uhalalo aya dlepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Epapele oloma edla Yesu aiyalma aya dulu dla hallati inoma pa꞉talo so mate epo akoloyalemale so mate ya꞉ hala dla pumulaiyo. Epalati ya꞉tapo yia꞉ye ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amasiyama aiyalma aya dokopala so mate epo aiyalma imalalo so mate Yesuta koko ka꞉dle halomale natipame sikemte siyalasiyaladiyo. Epammama yia꞉tapo yimlalata aiyalma aya dulu dla ha꞉ha꞉mama “Yesu Deibidi Yami dla sisiyeiya” demyela dalepame sikemte alliyo. ");
INSERT INTO xla_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Epame ma yia꞉ta Yesu watle epo atlaiyo, “Wa꞉ yimlalata atlamya kokoye me-dalema꞉?” diyo. Epalati asiyama Yesuta yia꞉ watle epo atlaiyo, “Yao, me-dalema. Amasiyama wua꞉ God yu bukata atla kokoye ala posesa꞉lalo ha꞉ha꞉ma꞉? Adipalati, God yu bukata epo atlapo, ‘Godtapo yimlala mate epo owayimlala mateta ya꞉ hi di dla ta꞉dlowe kokoye me-imuwapo,’ depo.” ");
INSERT INTO xla_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Epame Yesu yia꞉ saliyome Yelusalem tle ma Betani mo dla ella taiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Utulalati Yesu ma Yelusalem dla ilame tamama daya ta꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Epalati tamama pigi dlomoko dalita api duka dla hallati dlomoko mita꞉ depo natila tuwaiyo. Amasiyama dlomoko tlo pomilalo isikimi upa siyapo asipo halla natiyo. Epalati Yesutapo pigi dlomoko dali edla epo atlaiyo, “Wa꞉ matle dlomoko pomimhallowa,” diyo. Epapele oloma medla dalitapo pakasiyamalalo mo-powaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesu ya꞉ alotle tlalo sotapo koko i natipo yiyelepame epo atlaiyo, “Pigi dlomoko dali iye adipammama pakasiyamalalo mo-poma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Epalati Yesutapo asiyama yia꞉ watle epo atlaiyo, “Na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ mikadepe depo ha꞉ha꞉mama malamale potatlamalalo hallepiye, na꞉ta dali hema koko halëye wua꞉ ma epapele koko haloweye ala꞉lepe. Epame hatlo koko ipapele tlo pohalomolowa. Amasiyama wua꞉ koko opi patoto ma me-halomelepe. Epammama wua꞉ta tamali hema atlemama ‘wa꞉skamu dokastapame yú dulu dla tulune,’ dlepiye, koko eta mepapelepe. ");
INSERT INTO xla_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Epapedeme wua꞉ apa koko solotamama koko eye ikadepe hali depo mikadepe dle mate God dla otele himilipiye, wua꞉ koko eye halepe.” ");
INSERT INTO xla_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ma Yu so aiyalma aya dla hetame opa watle God yu imhallati aiyalma aya dokopala so mate epo Yu so dokopala so mateta puame Yesu watle epo atlaiyo, “Wa꞉ apa itiyamale tle koko iye hamsela꞉ma꞉? Anta wa꞉ watle itiyamale iye hamiwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Na꞉ mape wua꞉ watle atlanatili yu hatlo atlowama. Anta Yon watle itiyamale hamiwa, opa yú dla ka꞉ka꞉timelepo depame? Godta itiyamale hamiwa, o oplamita itiyamale hamiwa? Epedeme wua꞉ta asiyama yu na꞉ watle atlepiye, epalati na꞉ ma asiyama na꞉ta itiyamale hamsela꞉ iye wua꞉ watle atlowepo,” diyo. Epalati yia꞉ta yu i dalepame yiskamu yia꞉ dulu dla esemyemama epo atlamyaiyo, “Di adipo atlepa꞉? Di Yonta itiyamaleye God tle puwa dlepiye, ma asiyama Yesuta di watle epo atellepe, ‘Ame wua꞉ adipalati Yon yu dla pomikadepe dlalo wekuwa?’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Epame di ma ya꞉ta itiyamaleye oplami tle puwa dlepiye, ma asiyama opata dia꞉ dla siyalasiyaladlepe. Adipalati, opa hapulomata Yonye God tle yu hapame molo atlalo oplami ikadepe demdepo.” ");
INSERT INTO xla_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Epammama yia꞉ta asiyama Yesu watle epo atlaiyo, “Di podimalamana, Yonta itiyamale halë sitaliye,” diyo. Epalati asiyama Yesuta yia꞉ watle epo atlaiyo, “Na꞉ ma asiyama wua꞉ watle na꞉ta itiyamale hamsela꞉ iye po-atlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Epedeme wua꞉ koko hema apa koko malama꞉? Oplami haletapo akimlala dapiyamte elemhalaiyo. Epapeleye ya꞉tapo ka꞉yapa hamale maseyemala dla epo atlaiyo, ‘Wa꞉ tame na꞉ gla꞉pi dlomoko emale osalo dla oko hane,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Amasiyama maseyemalatapo atlemama, ‘Na꞉ alima,’ depame ma alotle malamale meyelope depame oko hala taiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Epame ya꞉ ata ma tame ya꞉ maseyemala hale dla epo atlaiyo, ‘Wa꞉ tame na꞉ gla꞉pi dlomoko emale osalo dla oko hane,’ diyo. Epalati ya꞉ maseyemalata atlemama, ‘Yao, na꞉ oko hala tlowepo,’ depame ma potlalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Epedeme akimlala dapiyamte dulu hema maseyemala aditapo ya꞉ ata solotamale koko hauwa?” Epalati asiyama aiyalma aya dokopala so mate epo Yu so dokopala so mateta epo atlaiyo, “Ka꞉yapa hamale maseyemalatapo ya꞉ ata solotamale kokoye hauwapo,” diyo. Epalati Yesuta yia꞉ watle epo atlaiyo, “Na꞉ ikadepe koko wua꞉ watle atlema. Ta꞉kis mani halomalalo so mate epame opa ala꞉msiyamalalo so wola꞉ matetapo yia꞉ tatle Pepele dimo dla u-ulapo tumama asiyama wua꞉ tlo alikili dla pomellepe. ");
INSERT INTO xla_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Adipalati, Yontapo wua꞉ye api ka꞉dle nati-ilati wua꞉ ya꞉ yu dalepame pomikadepe dena. Amasiyama bobtalimale so ewolotapo Yon yu dalepame mikadepe duwapo. Epame wua꞉tapo yia꞉ta mikadepe dle koko natipame malamale pomeyelope dlalo ha꞉ha꞉mama Yon yu dla ala pomikadepe dlalo wekuwapo.” ");
INSERT INTO xla_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Epame wayu hale i ma daliya. Alila haleta osalo ya꞉ atapo ya꞉ osalo dla gla꞉pi dlomoko ale emaiyo, epame alikili kosukuliyo. Epo dlomoko dala okolloweye ta꞉la dla munamu muwalepame matle alisisi e ompollowe kimna꞉ya di dla haiyo. Ya꞉ epame opa opi watle omha꞉ha꞉iye depame ma mo hale pateka꞉mu dla halla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ya꞉ edla tame hallati dlomokota milipame namolowe alilata mo-puaiyo. Epalati ya꞉tapo ya꞉ oko so opi watle ya꞉ osalo dla tame dlomokoye halopo puaiye diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Amasiyama osalo omha꞉ha꞉lalo sota yia꞉ta pula natipame hohopo opi tlo hohopoliyo. Epame opi tlo ewala mate kelepo potimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Epalati osalo ya꞉ ata koko i dalepame matle oko so pasataleye taiya diyo. Amasiyama osalo omha꞉ha꞉lalo sotapo yia꞉ mape mepo hohopolemama opi tlo ewalata kelepo potimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Epalati ma mosukulu dla ya꞉ maseyemala tlo tane demama epo malamaiyo, ‘Osalo omha꞉ha꞉lalo sotapo na꞉ maseyemala dla heodemama ya꞉ye poyumlowa,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amasiyama osalo omha꞉ha꞉lalo sotapo osalo ya꞉ a yamita pulati natipame yiskamu yia꞉ dulu dla epo atlamyaiyo, ‘Maseyemala itapo osalo ya꞉ a elo dla hallala. Epedeme ya꞉ye yumpame osalo iye dita halowa,’ demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Epammama yia꞉tapo maseyemala eye osalo alikili dla hamamtame yumiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Epedeme osalo ya꞉ ata puame ya꞉ osalo omha꞉ha꞉lalo so dla apa koko hapa꞉?” ");
INSERT INTO xla_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Epalati aiyalma aya dokopala so mate epo Yu so dokopala so mateta asiyama epo atlaiyo, “Osalo ya꞉ ata puame osalo omha꞉ha꞉lalo soye potipame osaloye ma opa opi watle omha꞉ha꞉iya dlepe. Epedeme opa ewolotapo dlomoko ma hauwallowe oloma edla hauwalepame yoye halopi demha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ God yu bukata atlama kokoye posesa꞉lalo wekemdi? Adipalati, edla ipo atlapo, ‘Aya halalo sota alumiti allimama alumiti hamastaletapo ma wata aya duka dla molopa kestale some halapo. Epedeme koko iye Lodta hauwapo. Epalati dita koko i natipo yiyelemama sikemte ka꞉dena depo.’ ");
INSERT INTO xla_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Pepele dimo kokoye wua꞉ tle kolahapame ma opa anawolotapo Godta solotamale koko tlo halomha꞉ha꞉ma꞉, ma ewolo watle halopilipe. ");
INSERT INTO xla_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Epedeme oplami antapo alumiti edla kustamtame teyulupiye, ya꞉ye susupulastepo hamastlepe. Epame alumiti etapo oplami haleye goludlepiye, oplami eye totola꞉timtame ellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Epalati aiyalma aya dokopala so mate epo Pa꞉lisi so mate Yesuta wayu atlamale koko dalepame “di koko atlemhalema,” depo momalamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Epammama yia꞉tapo Yesu hamolowe apiye totamaiyo. Amasiyama opa hapulomatapo Yesuye God tle yu hapame molo atlalo oplami ikadepe demyelati dalepame ya꞉ye hamolowe wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Epame Yesu matle wayu mate ipo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pepele dimo kokoye ipapena. Dokopala oplamitapo yamita a꞉ya halowe dla daya pato dinapiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ya꞉ daya ma dinapopo gudepame ma ya꞉ oko so watle taiya demama epo atlaiyo, ‘Wua꞉ na꞉ta daya dinapele dla pulupo depame yu halopimtauwa opaye elempuaiya,’ diyo. Epalati ya꞉ oko sota yu hamtame opa ewolo atlamalati asiyama yia꞉ta pula alliyo. ");
INSERT INTO xla_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Epela dalepame dokopala oplamitapo ya꞉ oko so opa opiye mamisika꞉ tame atlamama epo atlaiye diyo, ‘Aliya haloye mo-poyupo halema, epame daya ma ma-dinapopo halema. Epapedeme wua꞉ a꞉ya hamili daya dele dla puame daya deiya diye,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amasiyama yia꞉tapo yu hamtame atlati opa opita yu i dalepame allimama ma yia꞉ oko dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Epalati ma opa opitapo yu i dalepo dokopala oplami ya꞉ oko so opaye hohopolepame potimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Epalati dokopala oplamitapo koko i dalepo sikemte siyaladepame ya꞉ opa hapuloma watle atlemama, ‘Yimkadulo potimalalo so ewoloye potipame yia꞉ mo ma dlapa mistaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Epame dokopala oplamitapo ya꞉ oko so watle ma epo atlaiyo, ‘Daya patoye mo-dinapopo elema. Amasiyama na꞉ta sisilamale soye me-yia꞉ batalimale koko tle populalo wekelepo. ");
INSERT INTO xla_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Epedeme wua꞉ tame mo duka dla siyama opa hapulomaye daya delepo depame elempuaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Epalati ya꞉ oko sota tame opa hapuloma ka꞉ka꞉dle so mate epo bobtalimale so mate elepame daya dele dla pumulaiyo. Epapele oloma edla aya dulu eye opata alumama sikemte pasataiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amasiyama dokopala oplamita aya dulu edla opa natila hetamama natilati oplami haletapo a꞉ya hamili dla tluka didiyelalo epapele po-asilalo puame polla natiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Epalati dokopala oplamita ya꞉ watle epo atlaiyo, ‘Namkale, wa꞉ a꞉ya hamili dla tluka didiyelalo epapele po-asiyampolasema. Wa꞉ aya dulu hema adipo matao?’ diyo. Amasiyama oplami etapo asiyama atlowe yu pa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Epalati dokopala oplamitapo ya꞉ oko so watle epo atlaiyo, ‘Oplami iye do mate epo hete mate kokotipoliyepame alikili amtuwale dla hamastaiya. Ya꞉ edla halemama amale mate a꞉pe tetekelemhallepe,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Epedeme Godtapo opa hapulomaye ma-sisilamhalapo. Amasiyama ya꞉ isikimi opa opi tlo elemhalapo.” ");
INSERT INTO xla_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Epame Pa꞉lisi sotapo alikili dla tame Yesutapo batalimale koko atlati ya꞉ye hamolowe kokoye esemaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Epammama yia꞉tapo yia꞉ opa mate epo Helod ya꞉ opa mate Yesu hala dla taiya diyo. Epalati opa ewolota tame Yesu watle epo atlaiyo, “Imalalo oplami, dimalamana, wa꞉ye ikadepe koko tlo halalo oplamipo. Epame wa꞉ta God koko imama ikadepe koko siyapo tlo imdepo. Epame wa꞉ opa powota꞉semde. Epo wa꞉ opa isikimi kapala di dla potlamasemde. ");
INSERT INTO xla_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Epedeme wa꞉ di atlane, di ka꞉deta꞉, Loum dokopala oplami Sisa watle ta꞉kis mani halopiliweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu yia꞉ta batalipo malamale kokoye momalanatipame yia꞉ watle epo atlaiyo, “Wua꞉ wuskamu pepemalalo sopo. Wua꞉ adipalati na꞉ye elemala natilowedeme amma꞉? ");
INSERT INTO xla_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Epedeme wua꞉ta ta꞉kis mani kolumha꞉ha꞉lalo mani haleye na꞉ watle nati-iya.” Epalati yia꞉ta ya꞉ watle elo mani hale hamiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Epalati Yesutapo yia꞉ watle epo atlaiyo, “Mani hema ana mila꞉pi mate epo ana hi mate hutiyema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Epalati asiyama yia꞉ta epo atlaiyo, “Sisa mila꞉pi mate epo ya꞉ hi mateta hutiyema,” diyo. Epapalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ epapedeme Sisa teteye Sisa watle halopiya, epame God teteye God watle halopiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yia꞉tapo yu i dalepo sikemte yiyelepame Yesu saliyome ma-tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Epame alila oloma edla Sa꞉dusi so opa opita Yesu hala dla pumulaiyo. Opa iwolota atlemama, “Palli sota ma posilliwa,” demdepo. Epeleye yia꞉tapo puame Yesu watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Imalalo oplami, Mosesta di watle molo atlale yuye ipo ilipo hamiwapo. ‘Oplamitapo a꞉ya hapo yimlala pohatitimalalo halepo polopiye, ma oplami e ya꞉ eita sepeyama eye hapo ya꞉ bapa elo dla ha꞉ha꞉lowe yimlala hatitimelepe,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Epapedeme oplami haletapo akimlala 7 hatitimaiyo. Epame yia꞉ bapa tatle a꞉ya haiyo. Epo yimlala pohatitimalalo halemama powaiyo. Epalati ma medla hallalota ya꞉ bapa ya꞉llu sepeyama me-eye haiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ya꞉ mape yimlala pohatitimalalo powaiyo. Epela ma medla hallalota sepeyama hatlo me-eye haiyo. Amasiyama ya꞉ mape yimlala pohatitimalalo powaiyo. Epamtamama akimlala 7 hapuloma ewolotapo yimlala pohatitimalalo pataiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Epo a꞉ya sepeyama eta mosukulu powaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Epapedeme palli tle silliwe oloma edla a꞉ya eye ikadepe ana ya꞉llu depa꞉? Adipalati, yia꞉ta 7ta a꞉ya hatlo metlo halompuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Amasiyama Yesuta asiyama yia꞉ watle epo atlaiyo, “Wua꞉ye yeitamale sopo. Adipalati, wua꞉ Godta itiyamale mate epo ya꞉ yu mate ala yeitamha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Adipalati, palli sota wabasi tle sillipiye, yia꞉ matle wola꞉ mate epo opa mate pohalomha꞉ha꞉lowa. Amasiyama yia꞉tapo God ya꞉ banakaka sota Pepele di dla ha꞉ha꞉ye epapele some ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Epedeme wua꞉ Godtapo palli sota matle pasakalo depo silliwe koko dla atlale yuye posesa꞉semdi? Adipalati, ya꞉ta epo atluwapo, ");
INSERT INTO xla_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na꞉ye A꞉iblaham ya꞉ Godpo, epo Aisek ya꞉ Godpo, epame Yokob ya꞉ Godpo,’ duwapo. Epapedeme God iye popalli so yia꞉ God. Hao, pasakalo ha꞉ha꞉lalo so yia꞉ Godpo.” ");
INSERT INTO xla_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Epalati opatapo Yesuta imale koko i dalepame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuta Sa꞉dusi sota yuhalowe api himomelle koko natipame asiyama Pa꞉lisi sotapo yimkata alupame esemaiyo. ");
INSERT INTO xla_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Epame yia꞉ dulu dla aiyalma imalalo oplami haleta Yesu elemala natilowedeme puame ya꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Imalalo oplami, Mosesta aiyalma hatitimale dulu dla aiyalma adi tlo sikemte patota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Epalati Yesutapo asiyama epo atlaiyo, “‘Wa꞉ Lod wa꞉ Godye sikemte malahalane, wa꞉ dupa dulu malamale tle, epo wa꞉ soko tle, epame wa꞉ta malamale tle.’ ");
INSERT INTO xla_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Epedeme aiyalma hatitimale dulu dla aiyalma itapo ikadepe pato halapo. ");
INSERT INTO xla_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Epame ya꞉ ko tle aiyalma hale pato me-epapele sepeleye ipo, ‘Wa꞉ta wa꞉skamu sikemte malamdiye, epammama wa꞉ amkale ma sikemte malamhalane.’ ");
INSERT INTO xla_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Epedeme Mosesta aiyalma hatitimale hapuloma mate epo God tle yu hapame molo atlamalalo sota hatitimale hapuloma matetapo aiyalma dapiyamte iwolo dla hitaha꞉ha꞉po.” ");
INSERT INTO xla_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pa꞉lisi so ala yimkata me-alupo popa꞉lati Yesuta yia꞉ watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wua꞉ Keliso kokoye adipo malama꞉, ya꞉ye ana yamita꞉?” diyo. Epalati yia꞉tapo epo atlaiyo, “Deibidi yamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Epalati asiyama Yesuta yia꞉ watle epo atlaiyo, “Ame adipalati Deibiditapo Soko tle atlemama Kelisoye ya꞉ Lod duwa? Deibidita meyelo epo atluwapo, adipalati, ");
INSERT INTO xla_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Godta na꞉ Lod watle epo atluwapo, Wa꞉ na꞉ dowala tiyama dla polane. Epalati na꞉tapo wa꞉ watle opahale demha꞉ha꞉ soye wa꞉ hete sitali isili dla hatitimolowepo,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Epedeme Deibidita Kelisoye ya꞉ Lod duwapo. Ame adipammama Kelisoye Deibidi yami depa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Epalati oplami haletapo ya꞉ yu ipi dla yu hale asiyama po-atlaiyo. Epedeme oloma etle ma oplami haletapo Yesu watle atlanatili yu hale atloweye wowota꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Epame Yesuta ma opa hapuloma dla epo ya꞉ alotle tlalo so dla epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Aiyalma imalalo so mate epo Pa꞉lisi so mate yia꞉ dla itiyamale elapo, yia꞉tapo Mosesta aiyalma hatitimale wua꞉ dla imoloweye. ");
INSERT INTO xla_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Epedeme yia꞉ yu dla salladepo siyamama yia꞉ta atlamha꞉ha꞉ kokoye halomha꞉ha꞉iya. Amasiyama wua꞉ yia꞉ta moto mate koko halomha꞉ha꞉ e natipame wua꞉ ma e halomiya. Adipalati, yia꞉ aiyalma koko wua꞉ dla ipo ma miyelo moto mate koko eye pohalomasemde. ");
INSERT INTO xla_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Epapedeme yia꞉ta aiyalma imale kokotapo opa dla upiyele pato hapimdepo. Amasiyama yia꞉tapo yimkadulo gagademama upiyele ipi eye ma miyelo pohasemde. ");
INSERT INTO xla_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Epedeme yia꞉ta koko halomale dulu dla isikimi opatapo yia꞉ye natilipo depo ammdepo. Epame yia꞉ God yu ipi ilalimaleye dawale patoto tilimale epapele dulu dla hatitipo didiyepo siyamdepo, opata natilipo depame. Epame opata natilipo depame yia꞉ta inoma sumama tluka didiyelalo patoto seselemalliye didiyepo siyamdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yia꞉ epame dita inoma sumalalo aya dla epo daya pato dele dla itapu ikadepe dla popa꞉lowe tlo solotamdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Epame api duka dla opata yia꞉ dla heodepame namkale dle yu atlamalati yia꞉ sikemte dallowe tlo solotamdepo. Epame yia꞉ ma solotamdepo, opatapo yia꞉ watle imalalo so dlepo depame. ");
INSERT INTO xla_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amasiyama poka꞉dena, opatapo wua꞉ watle atlemama imalalo oplami dloweye. Adipalati, wua꞉ imalalo oplamiye hatlopepo. Epame wua꞉ dulu dla haleta potla꞉mtamhalasema. ");
INSERT INTO xla_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Epame ta꞉lamo hema oplami hale watle atlemama a demiya. Adipalati, wua꞉ A hatlope Pepele dimo dla halapo. ");
INSERT INTO xla_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Epame poka꞉dena, oplami haletapo wua꞉ watle atlemama dokopala oplami dloweye. Adipalati, wua꞉ dokopala oplami mape hatlo Kelisopo. ");
INSERT INTO xla_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Epedeme wua꞉ dulu dla salladepo sela꞉lalo oplamitapo pato halapo. ");
INSERT INTO xla_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Epapedeme opa anawolotapo yiskamu yia꞉ye di dla halopo hetamha꞉ha꞉ma꞉, asiyama Godtapo yia꞉ye isili dla ipila꞉lepe. Amasiyama opa anawolotapo yiskamu yia꞉ye isili dla halopo tulumha꞉ha꞉ma꞉, yia꞉ye asiyama Godta di dla ipila꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Epapedeme ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ yimkadulota Pepele di dla ulatuluweye api komha꞉ha꞉po. Epame wua꞉ muwolo edla po-ulatuwasemde.  ");
INSERT INTO xla_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ isikimi elemale tle sepeyamataloye dodolomsalepame yia꞉ ayaye kokolahamdepo. Epame wua꞉ opa hapuloma inoma dali tle inoma sumale yu seselemalli atlamdepo. Epedeme wua꞉ asiyama wotiyalle pato halepe. ");
INSERT INTO xla_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ solotamde, po-Yu so opatapo ma Yu so dlepo depame ta꞉lamo pato dla opaye totamsiyamdepo. Epame wua꞉ta oplami hale ma-hampame wua꞉ta batalipo imale koko mate ya꞉ye sikemte batalipo hamastamdepo. Epapele koko tle wua꞉tapo ya꞉ye Dlapa mo dla semtamama ammdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ka꞉e, wua꞉ wolomape! Wua꞉ inoma watalo so tlope ma inoma pa꞉talo so some opaye elemtapo. Epame wua꞉tapo ipo imdepo, ‘Oplami haletapo yu itiyapo himimama aiyalma aya hi mate aiyalma soloweye pase koko pato,’ demdepo. ‘Amasiyama oplami antapo aiyalma aya dulu dla mani ela hi tle yu itiyapo himimama aiyalma selepiye, e tlo koko pato,’ demdepo. ‘Epammama ma alotle yu itiyapo himili eye pohauwokokomolowa,’ demdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wua꞉ yiyilamale sopo! Manita koko pato pohalasema. Amasiyama aiyalma ayata koko pato halapo. Adipalati, mani eta aiyalma aya dulu dla ellati mani e ma aiyalma depo elapo. ");
INSERT INTO xla_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Epame wua꞉ ma ipo imdepo, ‘Oplami haletapo yu itiyapo himimama God watle namkale dle alisisi ha꞉po hamilalo tile, aiyalma aya dulu dla pola, e ya꞉ hi tle aiyalma soloweye pase koko pato,’ demdepo. ‘Amasiyama ya꞉ta yu itiyapo himimama tile edla namkale dle alisisi himili e hi tle aiyalma selati e tlo sikemte koko pato,’ demdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wua꞉ inoma pa꞉talo sopo. Aiyalma aya dulu dla tile pola dla himili alisisita koko pato pohalasema. Amasiyama tileta koko pato halapo. Adipalati, tiletapo namkale dle alisisi hamili eye aiyalma demdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Epedeme oplami antapo yu itiyapo himimama tile hi tle aiyalma selepiye, ya꞉ isikimi tile hi siyapo mate aiyalma posolowa. Amasiyama ya꞉tapo tile hi mate epo tile edla namkale dle alisisi himili e ya꞉ hi mate aiyalma selepe. ");
INSERT INTO xla_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Epame oplami antapo yu itiyapo himimama aiyalma aya hi tle aiyalma selepiye, ya꞉ isikimi aiyalma aya hi siyapo mate aiyalma posolowa. Amasiyama ya꞉tapo aiyalma aya hi mate epame dulu edla hallalo God hi mate aiyalma selepe. ");
INSERT INTO xla_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Epame oplami antapo yu itiyapo himimama Pepele dimo hi tle aiyalma selepiye, ya꞉ isikimi Pepele dimo hi siyapo mate aiyalma posolowa. Amasiyama God hi mate epo ya꞉ta pollalo hi mate aiyalma selepe. ");
INSERT INTO xla_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Epapedeme ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ God dla namkale dle alisisi hapimama mala mate epo sosoko mate epo alisisi opi yimka꞉sikili mate woloma kolumale 10 dulu dla kolumale hatlope God watle hapi demha꞉ha꞉mama asiyama aiyalma hatitimale dulu dla koko patoto hutiye halomolowe tlo wowelimdepo. Eye ka꞉dle koko halowe mate, epo ya꞉mkale bokotiyapo malamolowe koko mate, epo mikadepe dlowe koko matepo. Epedeme koko patoto e tlo woloma halomha꞉ha꞉iya. Epammama God dla namkale dle alisisi halopiliwe koko ma wowelimiya. ");
INSERT INTO xla_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wua꞉ inoma pa꞉talo sopo. Wua꞉ amama yemalata wua꞉ daya dla pollati woloma natipame alikili dla auwemdepo. Amasiyama aliya patota wua꞉ mila꞉pi dla ellati e ponatilalo me-gola꞉demdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Epapedeme ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ muwolo kapo mate epo palita mate alikili tlo sikemte howahalomama asiyama dulu tlo pohowahalalo wekemdiye, wua꞉ ma mepo ha꞉ha꞉po. Adipalati, wua꞉tapo kapala di tlo howahalomdepo. Amasiyama wua꞉ dupa duluye batalimale koko mate epame alisisi solotamolowe koko mateta sikemte poposatilipo hutiyepo. ");
INSERT INTO xla_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pa꞉lisi so, wua꞉ ikadepe sikemte inoma pa꞉talo sopo. Wua꞉ ka꞉yapa wua꞉ kapo dulu mate epo palita dulu mate tatle howahalomaiya. Epapelepiye, alikili ma mepo ullu pa꞉po hallepe. ");
INSERT INTO xla_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Epapedeme ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ wabasi ka꞉pi dinapopo halemdiye, epapele some ha꞉ha꞉po. Adipalati, wabasi di tle tlo sikemte ka꞉pi dinapopo halemdepo. Amasiyama duluye powale elo mate hutallu mate sikemte wokasepo elemdepo. ");
INSERT INTO xla_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Epammama wua꞉ opa mila꞉pi tle wuskamu wua꞉ye ka꞉ka꞉dle so demsiyamdepo. Amasiyama wua꞉ isikimi wuskamu pepeyalimalalo sopo. Adipalati, wua꞉ opasi duluye batalimale kokota poposatilipo hutiyepo. ");
INSERT INTO xla_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Epapedeme ka꞉e, aiyalma imalalo so mate epo Pa꞉lisi so mate, wua꞉ wuskamu sikemte pepeyalimalalo sopo! Wua꞉ta God tle yu hapame molo atlamalalo so palli hatili wabasi di tle aya yimlala halopame ka꞉pi dinapomha꞉ha꞉po. Epammama ka꞉ka꞉depo ha꞉ha꞉le sota palli wabasi mape wua꞉ta mepo ka꞉depo dinapomha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Epame wua꞉ ma epo atlamha꞉ha꞉po, ‘Di mamadulota ha꞉ha꞉uwa oloma edla di ma me-ha꞉ha꞉matiye, di God tle yu hapame molo atlamalalo soye dia꞉ mate pe-epo potima,’ demha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Amasiyama wua꞉ta epo atlamha꞉ha꞉ koko tle muwolo wuskamu wua꞉ye God tle yu hapame molo atlamalalo so potimale yia꞉ mamadulopo demha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Epedeme wua꞉ mamadulotapo batalimale koko kotiyapo meluwaye ma wua꞉ta mosukulu dla tame gudiya. ");
INSERT INTO xla_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wua꞉ ilama yimlalapo. Apa kokotapo wua꞉ta Dlapa mo dla tamalaye himomelepa꞉? ");
INSERT INTO xla_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Epedeme na꞉ wua꞉ watle God tle yu hapame molo atlamalalo so mate epo ka꞉ka꞉dle so mate epo God yu imalalo so mate taiya dlowepo. Amasiyama wua꞉tapo opiye potimelepe. Epo opiye dali yekelemhimili dla gogodlalimelepe. Epame opiye aiyalma aya dulu dla hohopollepe. Epalati opiye wua꞉tapo wotiyalle hapimha꞉ha꞉mama mo hale tle ma mo hale dla dodolomsalemha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Epedeme ta꞉lamo hema wua꞉ mamadulotapo ka꞉ka꞉depo ha꞉ha꞉lalo soye mo-potimpuwapo. Epammama yia꞉tapo ka꞉dle oplami Eibol tle yumuluwe kotiyapame potimpuame Belekaya yami Sekalaya yumpo guduwapo. Epedeme yia꞉tapo Sekalayaye aiyalma aya ka꞉ epo God dla alinepi poyupo halomalalo tile ka꞉ duka dla hallati yumuwapo. Epapedeme wata ha꞉ha꞉ so wua꞉tapo wua꞉ mamadulota ka꞉yapa God tle yu hapame molo atlamalalo so potimpuwa yia꞉ batalimale asiyamaye wua꞉ta halepe. ");
INSERT INTO xla_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Epedeme na꞉ ikadepe kokoye wua꞉ dla atlema. Wua꞉tapo wua꞉ mamadulo batalimale asiyamaye halepe.” ");
INSERT INTO xla_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalem, Yelusalem, wa꞉ adipalati God tle yu hapame molo atlamalalo so potimama Godta taiya dle soye ewala mate kelemhalemdi? Na꞉ alila adisowa dla gagapota ya꞉ yimlalaye woloma suku dulu dla ipila꞉po opolomdiye, epapolowedeme na꞉ta wa꞉ yimlalaye elempuluwe solotamduwapo. Amasiyama yia꞉ posolotamdena. ");
INSERT INTO xla_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Epapedeme Yelusalem so, wua꞉ daliya. Wua꞉ aiyalma ayaye aya siyapo hallepe. ");
INSERT INTO xla_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Epedeme na꞉ ikadepe kokoye wua꞉ watle atlema. Wua꞉ matle na꞉ mila꞉piye ponatilowa. Amasiyama alilata pulati wua꞉tapo epo atlamyelepe, ‘God hi mate pua oplami dla sisiyeiya,’ demyelepe. Epapele oloma edla wua꞉tapo ma na꞉ mila꞉pi natilipe.” ");
INSERT INTO xla_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu aiyalma aya saliyome ma-tamhallati ya꞉ alotle tlalo sota puame ya꞉ watle atlemama “aiyalma aya ka꞉pi dinapele pola i natine,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amasiyama Yesuta epo atlaiyo, “Wua꞉ koko hapuloma iye woloma natiya. Na꞉ ikadepe koko wua꞉ watle atlema. Aya hema ewala haletapo matle yimkadulo tama di dla popopa꞉lowa. Amasiyama aya e dokostlati ewala hapuloma etapo matle ta꞉la dla teteyupo tulume popa꞉myelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Epame Yesu Olipi tamali di dla hetame pollati ya꞉ alotle tlalo sota miyelo puame ya꞉ watle ipo atlanatiyo, “Wa꞉ di atlane, aiyalma aya dokostlowe alilaye adipalalota꞉? Epame wa꞉ta puluwedeme hallati apa kokota woyapa꞉? Epame ta꞉lamo mosukuluta woyamolowedeme hallati ma apa kokota di watle nati-ipa꞉?” ");
INSERT INTO xla_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Amasiyama Yesuta ma yia꞉ watle epo atlaiyo, “Ka꞉e wolomape! Oplami haleta wua꞉ye ikadepe api tle ma alikili dla elemtullala. ");
INSERT INTO xla_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Adipalati, opa opitapo na꞉ hi mate puame atlamyemama yiskamu yia꞉ye Kelisopo demyelepe. Epamyemama yia꞉ta opa pasataleye ikadepe api tle alikili dla eleme telepe. ");
INSERT INTO xla_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Epapedeme wua꞉ opahale koko mate epo nalatimale koko mateta wowoyamalati dalepame ase sikemte wowota꞉miyo. Ame adipalati, koko ipapele tatle wowoyamelepe. Amasiyama dulu edla mosukulu alilata yipta populuwa. ");
INSERT INTO xla_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mo haletapo mo hale mate opahale de demyelepe. Oloma edla mo opi dla daya pa꞉le kokotapo pulupe. Epo allutuwale patotota mo opi dla ellepe. ");
INSERT INTO xla_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Epapele kokota wowoyamelepiye, wotiyalle alilata kotiyamama apelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Epapele dulu dla opatapo wua꞉ dla wotiyalle hapipame potimolowe dla eleme telepe. Epame wua꞉ta na꞉ dla mikadepe dle koko tle opa hapulomatapo wua꞉ dla elle pato himha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Epapele oloma edla opa opitapo yia꞉ta mikadepe dleye polollepe. Epammama yia꞉tapo yimkadulo mikadepe dle soye allimama yia꞉ dla opahale demha꞉ha꞉ so dla hohopo ilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Epame biskapa God yu molo atlamalalo sotapo wowoyapame opa opiye elemala natilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Epapele dulu dla batalimale kokota sikemte ta꞉mhetlati asiyama opatapo ya꞉mkale bokotiyapo malamolowe kokota pomelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amasiyama oplami antapo ya꞉ta mikadepe dleye kokalepo halemama mosukulu dla tame woyamelepiye, ya꞉ pasakalo hallowe halepe. ");
INSERT INTO xla_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Epedeme mo hapuloma dla opa hapulomata ikadepe koko dlallepo depame ka꞉dle yu Pepele dimo kokoye atlamtelepe. Epalati ka꞉dle yuye opa hapuloma dla ma-atlamtepo gudepo hallati ta꞉lamo mosukuluta edla woyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Epedeme sesa꞉lalo oplami, wa꞉ yu i ya꞉ dulu kokoye woloma hane. Adipalati, God tle yu hapame molo atlalo oplami Da꞉niyolta epo atluwapo, ‘Wua꞉ ulugiyemale alisisi batalimaletapo aiyalma aya dulu dla tulumhalla natilipe,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Epalati Yudiya sotapo ulugiyemale alisisi e natipame tamali di dla pohetlepe. ");
INSERT INTO xla_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Epame oloma edla aya potopali dla pollalo oplamitapo poka꞉dena, ma aya dulu dla tuwame ya꞉ alisisi halomoloweye. ");
INSERT INTO xla_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Epame osalo dulu dla sela꞉lalo oplamitapo ma ilame aya dla ya꞉ tluka alisisi pohalomala tlowa. ");
INSERT INTO xla_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Epo oloma edla mopapo koko watalo so mate epo owayimlala meme ilimalalo so matetapo potloweye pta kokalle pato natilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Epapedeme wua꞉ta potlowe alilata teneyapi dla o dita inoma sumalalo alila dla powoyamalalo wekelepo depame God dla inoma sumale yu himme ha꞉ha꞉iya. ");
INSERT INTO xla_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Adipalati, oloma edla wotiyalle koko patota pulupe. Epedeme ta꞉lamo kotiyamale oloma etle pualeye, opatapo wotiyalle koko ipapele ponatimdena. Epame wotiyalle koko pato ita tame gudlepiye, ma alotle wotiyalle koko ipapeleye ponatilowa. ");
INSERT INTO xla_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Amasiyama epapele tlope Godta wotiyalle alila iye kiyepo mellepe. Adipalati, ya꞉ta alila selemalipo melematiye, oplami haleta wotiyalle dulu edla halloweye po-ala꞉ma. Amasiyama wotiyalle dulu edla Godta sesa꞉lemale so opa ma me-ha꞉ha꞉deme ya꞉tapo alila eye kiyepo mellepe. ");
INSERT INTO xla_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Oloma edla oplami haleta puame, wua꞉ watle atlemama, ‘Iye Kelisopo’ o ‘Huma natine, eye Kelisopo,’ dlatiye, ya꞉ yu dla mikadepe demiyo. ");
INSERT INTO xla_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Adipalati, biskapa elemala natilalo keliso mate epo biskapa God yu molo atlamalalo so matetapo puame ulugiyemale koko patoto halomyelepe, Godta sesa꞉le so elemolowa depame. ");
INSERT INTO xla_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Epedeme koko iye ala powowoyamalalo hallati na꞉ tatle wua꞉ye molo atlamayo. ");
INSERT INTO xla_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Epapedeme oplami haletapo wua꞉ watle atlemama ‘Kelisoye dalupa dulu dla halema,’ dlati natila tamiyo. Epame ma ya꞉tapo ‘Kelisoye aya dulu dla halema,’ dlati mikadepe demiyo. ");
INSERT INTO xla_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Adipalati, omaplatapo hela꞉hela꞉demama ta꞉lamo pato hela꞉demdiye, epapele some wua꞉tapo Opa Yamita pulati natilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mo hadima hutale ellepiye, kepilitapo hutale e dlowedeme tame edla topulumdepo.” ");
INSERT INTO xla_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Epame wotiyalle alila ita tame gudlati pakasiyamalalo ‘salita sumtlepe. Epalati mamata ma hela꞉dle pohamilowa. Epo tamili mape omapla di dla popa꞉ye ta꞉la dla teteyulupe. Epame itiyamale alisisi omapla di dla ha꞉ha꞉tapo hohoulalumama itiyamale pa꞉lepe.’ ");
INSERT INTO xla_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oloma edla Opa Yamita puluwe kokoye omapla di dla imale koko hamilati opata natilipe. Epalati opa hapulomatapo koko e natipame dupa kolle mate sikemte a꞉lemyelepe. Epapele oloma edla opatapo Opa Yamiye wuala dulu tle hela꞉dle mate epo itiyamale pato mate pulati natilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Epame ya꞉ta pumama ya꞉ banakaka soye hulu yu mate taiya dlepe, Godta sesa꞉le so opa hapuloma ta꞉lamo pato dla ha꞉ha꞉mtaye elemtelepo depame. ");
INSERT INTO xla_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Epedeme wua꞉ ipili dali tle koko i malamaiya. Wua꞉ ipili tokiyeta matlati natipame sali silaplowe alilata mo-kotiyama depo malamdepo. ");
INSERT INTO xla_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Epedeme koko i ma epapena. Wua꞉ na꞉ta atlama koko ita wowoyamalati natipame Opa Yamita puluweye mo-mateka꞉pi mle dlepe. ");
INSERT INTO xla_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na꞉ ikadepe kokoye wua꞉ watle atlema. Wata oloma hema ha꞉ha꞉ soye ala me-ha꞉ha꞉lati koko hapuloma ita wowoyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Epedeme pepele di mate epo ta꞉lamo mate pa꞉lepe. Amasiyama na꞉ yu tlo popa꞉lowa. ");
INSERT INTO xla_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Epedeme Opa Yamita puluwe alilaye oplami haleta poya꞉malamana. Epame God ya꞉ banakaka so Pepele di dla ha꞉ha꞉ mate epo God Yami mate yia꞉ ma poyia꞉malamana. Amasiyama hatlo God tlo alila eye ya꞉malamana. ");
INSERT INTO xla_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Epedeme Nowata haluwa oloma edla koko wowoyamuwaye, epammama ma Opa Yamita puluwe oloma dla mepo woyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Adipalati, Nowata halale oloma edla yúta ala populalo hallati opatapo daya mate epo yú mate dlomha꞉ha꞉mama opa mate wola꞉ mate halomha꞉ha꞉mdiyo. Epamha꞉ha꞉le oloma edla alila haleta Nowatapo koa dulu dla tuwaiyo. ");
INSERT INTO xla_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nowata koa dulu dla tulati opa hapulomatapo koko woyamoloweye ala yeitapo ha꞉ha꞉lati yúta puame poyuiyo. Epammama Opa Yamita puluwe alila dla opa hapulomata dinapopo ha꞉ha꞉lati populuwa. ");
INSERT INTO xla_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Amasiyama alila oloma edla opa dapiyamtetapo osalo dulu dla oko hamsiyamalati hale tlo hamame hetamama hale tlo medla pomellepe. ");
INSERT INTO xla_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Epame oloma edla wola꞉ dapiyamtetapo daya yulumha꞉ha꞉lati hale tlo hamame hetamama hale tlo medla pomellepe. ");
INSERT INTO xla_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Epedeme wua꞉ woloma dinapopo omha꞉ha꞉iya. Adipalati, powua꞉malamana Lodta puluwe alilaye. ");
INSERT INTO xla_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amasiyama wua꞉ koko iye woloma malamaiya. Oplamitapo uhalalo oplamita ya꞉ aya dla puluwe alilaye dallepiye, ya꞉ ma-dinapo polomama ompollepe. Epame uhalalo oplamita mo-pulati natipame ya꞉ye dodolomelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Epapedeme wua꞉ mape ma-dinapopame dalemha꞉ha꞉mama omha꞉ha꞉iya. Adipalati, wua꞉ powua꞉malamana, Opa Yamita puluwe alilaye.” ");
INSERT INTO xla_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Koko dla salladepo sela꞉mama oko ka꞉depo hamhallalo oplami anata꞉? Dokopala oplamitapo epapele oplami dla itiyamale hamilipe, ya꞉tapo ya꞉ oko so hapuloma omhalemama ma yia꞉ dla daya alemhallepo depame. ");
INSERT INTO xla_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Adipalati, dokopala oplamitapo haka꞉ma dla tame halepo puame natilati ya꞉ oko oplamita woloma ya꞉ okoye ka꞉depo hamhalale natipame ya꞉ dla siyele hamilipe. ");
INSERT INTO xla_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Epapedeme na꞉ wua꞉ dla mikadepe koko atlema. Dokopala oplamitapo ya꞉ oko oplamita woloma okoye ka꞉depo hamhalla natilipiye, ya꞉tapo ma ya꞉ watle ya꞉ alisisi hapulomaye omhalane dlepe. ");
INSERT INTO xla_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Amasiyama oko batalipo halalo oplamitapo ya꞉ dokopala oplamita ala hapele populalo hallati natipame epo atellepe, ‘Na꞉ dokopala oplami hapele popuasema,’ depame ya꞉mkadulo oko soye hopolemhalemama kawata yú dlalo so eleme daya mate yú mate dlomhalemdepo. ");
INSERT INTO xla_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ya꞉ epamhalemama podinapolalo hallati ya꞉ dokopala oplamita puame woyamelepe. ");
INSERT INTO xla_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Epalati ya꞉ dokopala oplamitapo puame ya꞉ye sikemte hopolepame alikili dla ka꞉stlepe, ya꞉tapo yiskamu pepemalalo so mate hallepo depame. Epalati ya꞉tapo edla tame halemama amale mate a꞉pe tetekelemhallepe.” ");
INSERT INTO xla_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Alila oloma edla Pepele dimo kokota puluweye ipapena. Ipilatalo 10tapo yia꞉ tuloma halopo a꞉ya hala pua oplami dla ompopa꞉la taiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Epapeleye yia꞉ dulu dla wola꞉ 5 opiye sikemte sasalalimale soyo. Asiyama wola꞉ 5 opi tlo sikemte hutulli soyo. ");
INSERT INTO xla_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Epapele dulu dla sasalle so wola꞉ yia꞉ tamalemama tuloma yú pasto tilipo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amasiyama hutulli so tlo tuloma yú pato tilipo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yia꞉ tame ompopa꞉lati a꞉ya halowedeme pua oplamiye yipta popuaiyo. Epalati yia꞉ta hapulomata inoma teta꞉mama mo-hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Epame mo-utula꞉la dukuslopi dla oplami haletapo yu teta꞉le mate epo atlaiyo, ‘A꞉ya hala pulalo oplamiye mo-mateka꞉pi dla pumhalemo. Epedeme wua꞉ tame ya꞉ye umaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Epalati ipilatalo hapulomata yimkata sillipame yia꞉ tuloma o-ota꞉timaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Amasiyama sasalle sotapo hutulli so wola꞉ watle epo atlaiyo, ‘Di tuloma yúye mo-pokadla yakoma. Wua꞉ di tuloma yú hapiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Epalati asiyama hutulli so wola꞉tapo yia꞉ watle epo atlaiyo, ‘Hao. Dita di tuloma yúye wua꞉ tuloma dla sisimamelepiye, dia꞉ mate po-ala꞉lowa. Epapedeme wua꞉ tame alisisi aya dla tuloma yú amko tilimaiya,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Amasiyama yia꞉ ala tuloma yú tilimala tlati a꞉ya hala pulalo oplamita mo-puame woyamaiyo. Epalati hutulli so wola꞉ ya꞉ ompopa꞉letapo ya꞉ mate daya dlowedeme aya dulu dla me-hetaiyo. Yia꞉ aya dulu edla me-hetame popa꞉lati kokolomaye mo-godiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Amasiyama sasalle sotapo ma-alotle puame kokoloma dla heyulumama epo atlaiyo, ‘Kokoloma gowaladiya, di aya dulu dla tuluwama,’ demha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amasiyama a꞉ya hala pulalo oplamitapo asiyama yia꞉ watle epo atlaiyo, ‘Hao. Wua꞉ pomatiliwa. Adipalati, na꞉ wua꞉ kokoye ikadepe pona꞉malamana,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Epedeme wua꞉ woloma omha꞉ha꞉mama dalemha꞉ha꞉iya. Adipalati, Opa Yamita puluwe alilaye powua꞉malamana.” ");
INSERT INTO xla_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Epame Pepele dimo koko ma ipapele some hallepe. Dokopala oplamitapo mo pateka꞉mu dla tlowedeme ya꞉ oko so sisilamaiyo. Epame yia꞉ watle ya꞉ alisisi woloma omha꞉ha꞉iye diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Epammama ya꞉ta ya꞉ oko so dla mani halopimama yia꞉ta momalamale mate ala꞉le maniye halopiyo. Epammama ya꞉tapo sikemte malamale oplami watle 5,000 elo mani halopiyo. Epo ma oplami hale ya꞉ ko tle hallalo watle 2,000 elo mani halopiyo. Epame ma mosukulu alo dla hallalo oplami watle 1,000 elo mani halopiyo. Epame ya꞉ ma mo pateka꞉mu dla halla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Epapalati ya꞉ oko so dulu dla 5,000 elo mani halomale oplamitapo mani e mate tame alisisi aya tipo halemama ma 5,000 elo mani opi halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Epalati 2,000 elo mani halomale oplami mape mepapiyo. Epammama ya꞉tapo 2,000 elo mani mate ma tame alisisi aya tipo halemama ma 2,000 elo mani opi halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amasiyama 1,000 elo mani halomale oplamiye ya꞉ mani e hapame tame koko hale pohalalo isikimi ta꞉la muwalepo dulu dla hamatiyo. Epapele koko tle ya꞉ mani hale pohaiyo. ");
INSERT INTO xla_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dokopala oplamitapo mo pateka꞉mu dla tame halepo depame ma ilame mo-puaiyo. Ya꞉ puame ya꞉ta mani halopili soye sisilamaiyo, ya꞉ta yia꞉ watle mani hapiliye ma adisowa hutiyema꞉ depo dallowedeme. ");
INSERT INTO xla_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Epalati 5,000 elo mani halomale oplamitapo mani hampuame epo atlaiyo, ‘Dokopala oplami, wa꞉ta na꞉ watle 5,000 elo mani halopiwaye ma wata mo-pasatamama 10,000 elo mani umpo elapo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Epalati dokopala oplamitapo asiyama ya꞉ watle epo atlaiyo, ‘Wa꞉ ka꞉depo oko halalo oplamipo. Wa꞉ta oko ka꞉pi halë natipo na꞉ siyema. Epedeme wa꞉ta yimka꞉sikili koko woloma omhaluwa tle asiyama na꞉tapo wa꞉ watle ma patoto kokoye omhalane dlowepo. Epapedeme wa꞉ na꞉ mate matime daya dele dla polomama siyele mate polane,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Epalati 2,000 elo mani halomale oplamitapo mani hampuame ya꞉ dokopala oplami watle epo atlaiyo, ‘Dokopala oplami, wa꞉ta na꞉ watle 2,000 elo mani halopiwaye ma wata mo-pasatamama 4,000 elo mani umpo elapo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Epalati dokopala oplamitapo asiyama ya꞉ watle epo atlaiyo, ‘Wa꞉ ka꞉depo oko halalo oplamipo. Wa꞉ta oko ka꞉pi halë natipo na꞉ siyema. Epedeme wa꞉ta yimka꞉sikili koko woloma omhaluwa tle asiyama na꞉tapo wa꞉ watle ma patoto kokoye omhalane dlowepo. Epapedeme wa꞉ na꞉ mate matime daya dele dla polomama siyele mate polane,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Epalati ma 1,000 elo mani halomale oplamitapo puame ya꞉ dokopala oplami watle epo atlaiyo, ‘Dokopala oplami, na꞉malamana, wa꞉ye sikemte itiyamale oplami. Epame wa꞉ opa opita emale alisisiye wa꞉ta isikimi me-hauwalemdepo. ");
INSERT INTO xla_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Epapedeme na꞉ wota꞉mama wa꞉ mani mate koko hale pohalalo isikimi tame ta꞉la muwalepo dulu dla hamatiwa. Epedeme wa꞉ta na꞉ watle mani hamiwa mesowata ela ipo,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Epalati ya꞉ dokopala oplamitapo asiyama ya꞉ watle epo atlaiyo, ‘Wa꞉ sikemte batalipo omhallalo oko oplamipo. Wa꞉ta malamaleta na꞉ye ya꞉mkale alisisi emaleye isikimi me-hauwalemde dlepo. ");
INSERT INTO xla_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Amasiyama wa꞉ adipalati na꞉ manita ta꞉lepo depame hamtame mani omha꞉ha꞉lalo so aya dla pohimilalo wekuwa? Wa꞉ta na꞉ maniye edla tame himimatiye, eta na꞉ta ilame puale oloma dla manita mo-pato depo ellati halemla,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Epedeme dokopala oplamitapo ya꞉ opa dla epo atlaiyo, ‘Wua꞉ ya꞉ watle 1,000 elo mani hutiyeye e halopame ma 10,000 elo mani halomalalo oplami watle halopiya. ");
INSERT INTO xla_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Adipalati, opa anawolotapo yia꞉ dla hapili alisisiye woloma ka꞉depo omha꞉ha꞉lepiye, asiyama yia꞉ dla ma pasataleye hapilipe. Amasiyama opa anawolota yia꞉ dla hapili alisisiye batalipo omha꞉ha꞉lepiye, yia꞉ dla hutiye alisisi hapuloma kokolahalepe. ");
INSERT INTO xla_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Epedeme batalipo omhallalo oko oplamiye alikili amtuwale dulu dla hamastaiya. Ya꞉ edla halemama amale mate a꞉pe tetekelemhallepe.’” ");
INSERT INTO xla_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Opa Yamitapo ya꞉ta itiyamale mate epo banakaka so hapuloma mate pulupiye, oloma edla ya꞉ta hela꞉dle pato mate puame ya꞉ta pollalo mo dla pollope. ");
INSERT INTO xla_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Epalati ta꞉lamo meyelope meyelope dle so hapulomaye banakaka sotapo elempuame ya꞉ mila꞉pi dla ipila꞉lepe. Epalati ya꞉tapo aliya omhallalo oplamitapo ya꞉ aliya duka hukulumama sipi aliya ma meyelo ipila꞉ epame gaut aliya ma meyelo ipila꞉ demdiye, epammama ya꞉tapo ta꞉la so hapulomaye duka hukulupame alumale dapiyamte dla ipila꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Epammama ya꞉tapo opa alumale haleye ya꞉ dowala tiyama dla ipila꞉pame ma alumale haleye ya꞉ weke tiyama dla ipila꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ya꞉ epame ya꞉ dowala tiyama dla ha꞉ha꞉ so watle epo atellepe, ‘Na꞉ ata sesa꞉le so opa wua꞉ puaiya, Godta ta꞉lamo kotiyamale dla wua꞉ yilo dinapopo himili moye halowedeme. ");
INSERT INTO xla_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Adipalati, na꞉ta daya ta꞉mpollati wua꞉tapo daya hapimduwapo. Epo na꞉ta yú ta꞉mpollati wua꞉tapo yú imduwapo. Epame na꞉ asepe oplami some pulati wua꞉tapo na꞉ye wua꞉ aya dla seme hetamduwapo. ");
INSERT INTO xla_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Epame na꞉ tluka alisisi pa꞉le pollati wua꞉tapo na꞉ye tluka didiyemelemduwapo. Epame na꞉ta esiyemellati wua꞉tapo na꞉ye woloma gademduwapo. Epame na꞉ amtuwale aya dulu dla pollati wua꞉tapo na꞉ye puame natimduwapo,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Epalati asiyama ya꞉ dowala tiyama dla ipila꞉le ka꞉ka꞉dle so opatapo epo atellepe, ‘Lod, di adipalalo wa꞉ta daya ta꞉msela꞉lati natipo daya imduwa? Epame di adipalalo wa꞉ta yú ta꞉mpollati natipo yú imduwa? ");
INSERT INTO xla_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Epame di adipalalo wa꞉ta asepe oplami some pula natipame di aya dla seme hetamduwa? Epame di adipalalo wa꞉ta tluka alisisi pa꞉le sela꞉lati tluka alisisi didiyemelemduwa? ");
INSERT INTO xla_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Epame di adipalalo wa꞉ta esiyemellati wa꞉ye woloma gademduwa? Epame di adipalalo wa꞉ta amtuwale aya dulu dla pollati wa꞉ natila tamduwa?’ demyelepe. ");
INSERT INTO xla_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Epalati dokopala oplamitapo asiyama epo atellepe, ‘Na꞉ ikadepe kokoye wua꞉ dla atlema. Wua꞉ta opa opi gagademduwaye na꞉ dla ammduwapo,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Epame dokopala oplamita ma ya꞉ weke tiyama dla ha꞉ha꞉ so dla epo atellepe, ‘Wua꞉ na꞉ tle alikili a꞉ma taiya. Adipalati, wua꞉ye Godta kasilamale dulu dla ha꞉ha꞉lalo sopo. Epedeme wua꞉ye Godta Saiten mate epo ya꞉ banakaka so mate dla posumtlalo wekele dlapa dinapopo himili dla taiya. ");
INSERT INTO xla_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Adipalati, na꞉ daya ta꞉mpollati wua꞉tapo na꞉ye daya po-imdena. Epame yú ta꞉mpollati yú po-imdena. ");
INSERT INTO xla_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Epame na꞉ta asepe oplami some pulati na꞉ye poseme hetamdena. Epame na꞉ta tluka pa꞉le pollati wua꞉tapo na꞉ye tluka podidiyemelemdena. Epame na꞉ta esiyemellati wua꞉tapo na꞉ye woloma pogademdena. Epame na꞉ta amtuwale aya dulu dla pollati wua꞉tapo puame na꞉ ponatimdena,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Epalati asiyama yia꞉ta epo atellepe, ‘Lod, di adipalalo wa꞉ta daya ta꞉le mate yú ta꞉le mate polla natiwa? Epame di adipalalo wa꞉ta asepe oplami some pulati natiwa? Epame di adipalalo wa꞉ta tluka pa꞉le pollati natiwa? Epame di adipalalo wa꞉ta esiyemellati natiwa? Epo di adipalalo wa꞉ta amtuwale aya dulu dla pollati natiwa?’ demyelepe. ");
INSERT INTO xla_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Epalati dokopala oplamitapo asiyama epo atellepe, ‘Na꞉ta wua꞉ watle ikadepe koko atlema. Wua꞉ta opa opi gadla allimduwaye na꞉ dla ammduwapo,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Epedeme opa iwoloye kokó elepo ellalo wotiyalle dla tame ha꞉ha꞉lepe. Amasiyama Godta ka꞉dena dle sotapo kokó elepo ellalo pasakalo dla ulatulupe.” ");
INSERT INTO xla_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuta koko hapuloma iye atlepo gudepame matle ya꞉ alotle tlalo so watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Wua꞉ mo-wua꞉malamana, Godta Namilatale daya dele kotiyamoloweye alila dapiyamte ma a꞉ma hutiyepo. Epame alila oloma edla Opa Yamiye dali yekelemhimili di dla gogodlepo depame opahale so dla homellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Epame oloma edla Yu so dokopala so mate epame aiyalma aya dokopala so mateta yia꞉ dokopala oplami Kayapas aya dla alupame esemaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yia꞉ta esemale dulu dla isikimi mala-atlale koko tle Yesuye hampame yumuluwa depo yu himiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Epammama yia꞉ta epo atlaiyo, “Di daya dele alila dla ya꞉ye poyumulowa. Adipalati, opata siyaladle ta꞉dlala,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani mo dla Saimon kapala batalimale oplami aya dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ya꞉ edla halemama daya dempollati a꞉ya hale isilako dla dakopala ullu ka꞉dle tipo hampuaiyo. Ya꞉ dakopala hampuame Yesu dokopala di dla simaiyo. Amasiyama dakopala iye mani pta patota halë alisisipo. ");
INSERT INTO xla_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Epalati Yesu ya꞉ alotle tlalo sota koko i natipame sikemte allimama epo atlaiyo, “A꞉ya i adipalati dakopala ullu ka꞉dleye koko pa꞉le dla simama me-pokadi? ");
INSERT INTO xla_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ya꞉ ka꞉dena, dakopala ullu ka꞉dleye opa watle hamipame asiyama mani pato hapo, alisisi pa꞉talo so gadloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amasiyama Yesuta yia꞉ta alli kokoye natipame yia꞉ watle epo atlaiyo, “A꞉ya ita halë koko natipame ya꞉ dla batalipo atlemiya. Adipalati, ya꞉tapo na꞉ dla ka꞉dle koko halëpo. ");
INSERT INTO xla_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Epedeme alisisi pa꞉talo sotapo alila hapuloma dulu dla wua꞉ mate ha꞉ha꞉lepe. Amasiyama na꞉ alila hapuloma dulu dla wua꞉ mate pohallowa. ");
INSERT INTO xla_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ya꞉tapo na꞉ motota wabasi dla ellowe malamama dakopalata na꞉ dla simalepo. ");
INSERT INTO xla_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na꞉ wua꞉ watle mikadepe koko atlema. Opata ta꞉lamo hadima ka꞉dle yu atlamtelepiye, yia꞉tapo a꞉ya ita koko halë ma atlamtelepe. Epalati opata ya꞉ koko ma malamelepe.” ");
INSERT INTO xla_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Epame Yesu ya꞉ alotle tlalo so 12 dulu dla hallalo hale Yudas Iskaliyotta aiyalma aya dokopala so watle tame epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Na꞉ta Yesu wua꞉ watle hamame ilipiye, wua꞉ asiyama apa alisisiye na꞉ watle hamipa꞉?” diyo. Epalati asiyama yia꞉tapo 30 elo maniye ya꞉ watle halopiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Epalati oloma etle tamama Yudastapo Yesuye yia꞉ do dla hamame iliwe api totamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isip mo tle alikili dla woyamale malamale daya dele kotiyamale alila dla Yesu ya꞉ alotle tlalo sota tame Yesu watle epo atlaiyo, “Di hadima tame Namilatale daya dloweye dinapopa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Epalati Yesuta asiyama epo atlaiyo, “Wua꞉ Yelusalem dla tame oplami hale natipo ipo atellepe, ‘Imalalo oplamita epo atla, Ya꞉ta sale alilata mo-puwo. Epedeme ya꞉ta ya꞉ alotle tlalo so eleme wa꞉ aya dla Namilatale daya dele dloweyo,’ dlepe.” ");
INSERT INTO xla_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesuta epo atla dalepame ya꞉ alotle tlalo sotapo yu e dolumama tame Namilatale daya dinapiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Epame Yesutapo tamila꞉la oloma edla ya꞉ alotle tlalo so eleme daya dlowedeme polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Yia꞉ edla daya dempopa꞉mama Yesuta epo atlaiyo, “Na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ dulu dla oplami haletapo na꞉ye opahale do tama dla homellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesu ya꞉ alotle tlalo sota yu i dalepame dupa kolle mate popa꞉mama Yesu watle epo atlamyaiyo, “Lod, na꞉ta꞉ na꞉ta꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu asiyama yia꞉ watle epo atlaiyo, “Oplami antapo na꞉ mate palita hatlope dla daya saodepo delepiye, oplami eye na꞉ opahale do tama dla hamame iliwe epo. ");
INSERT INTO xla_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amasiyama God yu bukata atla e dolumama Opa Yamitapo polope. Amasiyama Opa Yami opahale do tama dla homallalo oplamiye wolomape. Ya꞉ wotiyalle dulu dla tullupe. Epapalala depame ya꞉ waita ya꞉ye pohamalalo wekematiye, eta ya꞉ ka꞉dlemla.” ");
INSERT INTO xla_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Epalati Yesu opahale do tama dla homallalo oplami Yudasta epo atlaiyo, “Imalalo oplami, na꞉ta꞉?” diyo. Epalati Yesuta asiyama ya꞉ watle epo atlaiyo, “Yao, mowolo ma-atlapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yia꞉ daya dempopa꞉lati Yesuta daya hapame God dla siyele yu atlepame hauwokokomaiyo. Epame ya꞉ alotle tlalo so watle alemama epo atlaiyo, “Daya halopo deiya. Iye na꞉ motopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Epame Yesu matle isilako hapame God dla siyele yu atlepo gudepame ya꞉ alotle tlalo so watle hamimama epo atlaiyo, “Wua꞉ta hapuloma yú i deiya. ");
INSERT INTO xla_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Iye na꞉ omalipo, opa hapuloma yia꞉ bobtalimale howahalowe yilo dla olostapo. Na꞉ omalitapo Godta opa mate yu itiyapo himili amkoye kokalepo. ");
INSERT INTO xla_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Na꞉ wata oloma itle tamama wain yú matle podlowa. Amasiyama na꞉tapo alotle wua꞉ mate wain yú amkoye na꞉ A mo dla dlowepo.” ");
INSERT INTO xla_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Epame yia꞉tapo siyele sala sepo gudepo ma Olipi tamali dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesuta matle ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ta hapulomata wata utula꞉la na꞉ saliyome potlepe. Adipalati, God yu bukata epo atlapo, ‘Godtapo sipi omhallalo oplamiye yumulati sipi hapulomata ya꞉ tle potlepe.’” ");
INSERT INTO xla_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Epame Yesu ma epo atlaiyo, “Amasiyama na꞉ powale tle sila꞉tipame na꞉ tatle tame Ga꞉lili dla wua꞉ omhallowepo.” ");
INSERT INTO xla_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Epalati Pitata asiyama Yesu watle epo atlaiyo, “Opa hapulomatapo wa꞉ saliyome potlepiye, asiyama na꞉ tlo wa꞉ posaliyome tlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Amasiyama Yesuta ya꞉ watle epo atlaiyo, “Na꞉ wa꞉ watle ikadepe koko atlema. Wata utula꞉la gagapo ala poyulumalalo hallati wa꞉tapo na꞉ kokoye dapahatlope oloma dla wellipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Amasiyama Pitata ya꞉ watle epo atlaiyo, “Na꞉ pe-epapolowa. Opata wa꞉ye yumama yumilipiye, na꞉ mate polowepo,” diyo. Epalati ya꞉ alotle tlalo so hapulomata ma yu hatlo mepo atlamyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuta Getsemani osalo dla ya꞉ alotle tlalo so mate tame halemama yia꞉ watle epo atlaiyo, “Wua꞉ midla popa꞉iye. Na꞉ huma tame inoma sumolowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ya꞉ epo halemama isikimi Pita mate epo Sebedi ya꞉ akimlala dapiyamte mate tlo eleme hetaiyo. Ya꞉ hetame hallati dupa kolle mate opasi upiyele mateta ya꞉ dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Epalati ya꞉ta yia꞉ watle epo atlaiyo, “Na꞉ opasi duluye upiyele patota hetamama polowe mateka꞉pi dla puma. Epedeme wua꞉ hema ha꞉ha꞉mama omha꞉ha꞉iye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu epo atlepame yia꞉ tle alikili a꞉ma tame alumata kellepo ta꞉la dla heodepo polomama inoma sumpolaiyo. Ya꞉ inoma sumama epo atlaiyo, “A, wa꞉ solotamelepiye, na꞉ dla wotiyalle pua iye alikili a꞉ma hamastane. Amasiyama mowolo solotamale koko tlo hane, pona꞉ta solotamale koko,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Epame ya꞉ inoma sumhalepo tame natilati ya꞉ alotle tlalo so dapahatlopeta mo-hutiyelati natiyo. Epalati natipame Pita watle epo atlaiyo, “Saimon, wua꞉ adipalati hutiyema꞉? Wua꞉ poka꞉deta꞉, alila yimka꞉mala dla na꞉ mate inoma sumha꞉ha꞉loweye? ");
INSERT INTO xla_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Wua꞉ omha꞉ha꞉mama inoma sumha꞉ha꞉iya, wua꞉tapo elemala natili dla tullala depame. Adipalati, soko wua꞉ dulu dla halatapo solotamapo, itiyamolowedeme. Amasiyama wua꞉ motota hohopeyamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ya꞉ matle tame ipo inoma sumaiyo, “A, na꞉ta wotiyalle halowe koko hema api hatlo ita ellepiye, na꞉ wotiyalle me-halowepo. Adipalati, na꞉tapo wa꞉ta solotamale koko tlo halowepo.” ");
INSERT INTO xla_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu ma tame inoma sumhalepo depo puame natilati ya꞉ alotle tlalo so dapahatlopeta inoma teta꞉mama mo-hutiyela natiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Epalati Yesu matle ilame tame dapahatlope oloma dla inoma sumale yu hatlo metlo atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ya꞉ matle ilame puame ya꞉ alotle tlalo so dla epo atlaiyo, “Wua꞉ ala me-sikemte hutiyepa? Adipalati, Opa Yamiye batalimale so dla hamame iliwe alilata mo-puapo. ");
INSERT INTO xla_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Epedeme huma natiya, na꞉ batalimale so watle hamame iliwe oplamiye mo-puapo. Epedeme silliya, medla tlowa.” ");
INSERT INTO xla_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ala me-yukamhallati ya꞉ alotle tlalo so oplami hale Yudastapo Yesu hamolowe so opa elempuame edla woyamaiyo. Epapeleye Yesu hamolowe so opa iwoloye aiyalma aya dokopala so mate epo Yu so dokopala so mateta taiya diyo. Epalati yia꞉ta pumama aipa꞉ya mate epo bulukupi mate halopo puaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Epapele dulu dla Yudasta ala puluwedeme halemama Yesu hamolowe so watle epo atlaiyo, “Na꞉ta tame oplami hullupiye, oplami epo. Wua꞉ epalati ya꞉ye woloma hamame taiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Epedeme Yudas opa me-eleme puame halemama Yesu hala dla tame epo atlaiyo, “Namkale, imalalo oplami,” depame ya꞉ye huliyo. ");
INSERT INTO xla_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Epalati Yesuta ya꞉ watle epo atlaiyo, “Namkale, wa꞉ta hala puale kokoye hane,” diyo. Epalati opata puame Yesu ma-hamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amasiyama ya꞉ alotle tlalo so oplami haleta aipa꞉ya hame aiyalma aya dokopala oplami ya꞉ oko oplami haleye heyumama molo ketamastaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ aipa꞉ya alikili dla himine. Adipalati, yimkadulo potimolowedeme aipa꞉ya halopo siyamalalo soye yia꞉ ma aipa꞉ya tama dla pallipe. ");
INSERT INTO xla_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Epedeme wa꞉ powa꞉malamata꞉, na꞉ta gadle yilo na꞉ A dla atlepiye, ya꞉tapo na꞉ gadlepo depame ya꞉ banakaka so hapulomaye tuluiya dlepe. ");
INSERT INTO xla_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amasiyama na꞉ta epelepiye, God yu buka dla na꞉ta wotiyalle hapo polowe koko dla atlaleye adipo ala꞉pa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Epame Yesuta ya꞉ hamala puale so opa watle epo atlaiyo, “Wua꞉ na꞉ uhalalo oplamita hallati natipame na꞉ye hamolowedeme aipa꞉ya mate epo bulukupi mate halopo pumulo? Amasiyama wua꞉ na꞉ye alila hapuloma aiyalma aya dulu dla imsela꞉la natimduwapo. Ame wua꞉ adipalati na꞉ta edla hallati pohamalalo wekemduwa? ");
INSERT INTO xla_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Epele tlope wata wua꞉ta na꞉ hamala puale kokotapo God tle yu hapame molo atlamalalo sota atlamale yu mate ma-ala꞉po.” Epalati oloma edla Yesu ya꞉ alotle tlalo so hapulomata ya꞉ saliyome mo-potaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Opata Yesu hamame aiyalma aya dokopala oplami Kayapas aya dla seme hetaiyo. Amasiyama aya dulu edla aiyalma imalalo so mate epo Yu so dokopala so mate yia꞉ tatle ma-alupo popa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Epalati Pitata alo ikadepe tle Yesu dolumtame aiyalma aya dokopala oplami aya alikili dla halaiyo. Ya꞉ edla aiyalma aya dokopala oplami ya꞉ oko so mate polomama Yesu dla apa koko halowe depo ompolaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Epalati aiyalma aya dokopala so mate epo Yu so dokopala so mate Yesu yumuluwedeme ya꞉ batalimale totamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Epammama opata isikimi Yesu hi mate mala-atlamyemama koko meyelope meyelope dle atlamyaiyo. Amasiyama yia꞉ta koko meyelope meyelope dle atlamyale dulu dla ikadepe koko hale ponatiyo, yia꞉tapo Yesu yumuluweye. ");
INSERT INTO xla_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Epalati opa dapiyamteta ma alotle puame epo atlaiyo, “Di Yesuta epo atla daluwa, ‘Na꞉ dla itiyamale elapo, aiyalma aya iye dokostapame ma alila dapahatlope dulu dla amko haloweye,’ duwa.” ");
INSERT INTO xla_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Epalati aiyalma aya dokopala oplamita sila꞉time Yesu watle epo atlaiyo, “Wa꞉ opata wa꞉ koko dla yu meyelope meyelope dle atlamya dla asiyama yu po-atlalo wekepa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amasiyama Yesu yu hale po-atlaiyo. Epalati aiyalma aya dokopala oplamita matle ya꞉ watle epo atlaiyo, “Na꞉ God hi tle wa꞉ dla atlema, wa꞉ di atlane, wa꞉ ikadepe God Yami Kelisota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu asiyama epo atlaiyo, “Yao, mowolo ma-atlapo. Epame na꞉ wua꞉ dla ma-atlema. Wua꞉ Opa Yamiye God dowala tiyama dla polla natilipe. Epame ya꞉tapo pepele di tle wuala dulu dla malla natilipe.” ");
INSERT INTO xla_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aiyalma aya dokopala oplamita yu i dalepame sikemte alimama ya꞉ tluka tallatallademama epo atlaiyo, “Oplami iye God hi mate putlopo atlema. Epedeme di ya꞉ koko gladlowe dla ma yu opi dlallowe posolotamasema. Adipalati, wua꞉ ma-dallepo ya꞉ta God hi mate putlopo atlaleye. ");
INSERT INTO xla_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Epedeme wua꞉ apa koko ya꞉ dla halowe solotama꞉?” diyo. Epalati asiyama Yu so dokopala sota epo atlaiyo, “Ya꞉ polowe ka꞉dena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Epame yia꞉tapo ya꞉ dla mitikape tilitipame tetlemyaiyo. Epame ya꞉ mila꞉pi dla heyulumyemama ya꞉ watle epo atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Keliso, anta wa꞉ye heyu?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ala aya alikili dla me-pollati aiyalma aya dokopala oplami ya꞉ oko a꞉ya haleta puame ya꞉ watle epo atlaiyo, “Wa꞉ mape Yesu Ga꞉lili oplami mate sela꞉uwa oplami halepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Epalati Pitata opa hapuloma mila꞉pi tle epo atlaiyo, “Na꞉ wa꞉ta atla kokoye pona꞉malamana,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ya꞉ epame aya kosukulli kokoloma tala dla hallati oko a꞉ya haletapo ya꞉ natipame opa edla ha꞉ha꞉le so dla epo atlaiyo, “Oplami i mape Yesu Nasalet oplami mate sela꞉uwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Epalati Pitata matle yu itiyamale mate epo atlaiyo, “Na꞉ ikadepe koko atlema. Na꞉ oplami e ya꞉ kokoye pona꞉malamana,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Alila yimka꞉mala popa꞉pame edla ha꞉ha꞉le so opata puame Pita watle epo atlaiyo, “Ikadepe, wa꞉ ma Yesu mate sela꞉uwa oplami hale wa꞉po. Adipalati, wa꞉ta yukamatapo Ga꞉lili sota yuhalaloye epo yukamapo. Epedeme wa꞉ta yukamale kokota wa꞉ kokoye botomastapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Epalati Pitata yu itiyamale mate God hi tle aiyalma semama yia꞉ watle epo atlaiyo, “Na꞉ pona꞉malamana, oplami eye,” diyo. Pitata epo atlepo hallati gagapota mo-yulumaiyo. ");
INSERT INTO xla_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Epalati Pitata gagapota yulumalati dalepame Yesuta atlale yu malamaiyo. Adipalati, Yesuta ya꞉ watle ipo atluwapo, “Wa꞉ gagapota ala poyulumalalo hallati wa꞉tapo dapahatlope oloma dla na꞉ kokoye wellipe,” duwapo. Epapedeme ya꞉ yu e malapame alikili dla ulatame sikemte dupa kolle mate amaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Utulalati ikadepe aiyalma aya dokopala so hapuloma mate epo Yu so dokopala so hapuloma mateta Yesu yumuluwe koko dla esempopa꞉mama yu mo-kokalepo himiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Epame yia꞉ta Yesu doye deata kokotipoliyepame gamani dokopala oplami Paelet hala dla semtaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesu opahale do tama dla homallalo oplami Yudasta Yesuye ikadepe mo-yumuluwe dla halema dla dalepame sikemte dupa yumama wota꞉iyo. Epammama ya꞉ta 30 elo mani halomaleye matle aiyalma aya dokopala so mate epo Yu so dokopala so mate dla hamila taiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ya꞉ tame yia꞉ watle epo atlaiyo, “Na꞉ batalimale koko hauwa. Adipalati, batalimale pa꞉le oplamiye na꞉tapo opahale so dla homeluwapo,” diyo. Amasiyama dokopala sota asiyama epo atlaiyo, “E podi koko. Wa꞉ kokopo. Mowolo ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Epalati dalepame Yudasta mani eye aiyalma aya medla kustapame ma ilame tame ya꞉skamu tumuku dla dea himomelepo yumiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Epalati aiyalma aya dokopala sota mani kikilamha꞉ha꞉mama epo atlamyaiyo, “Mani iye ma ilame aiyalma aya dla hamilowe poka꞉dena. Adipalati, mani iye omali olostlowe dla asiyama himiwapo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yia꞉ epame mani e mate koko haloweye esepame isilako mimita꞉plalo oplami ya꞉ ta꞉la haiyo, po-Yu sota palilati hatimha꞉ha꞉loweye. ");
INSERT INTO xla_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Epapedeme opata ta꞉la e semama omali ta꞉la demdepo. ");
INSERT INTO xla_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Epalati oloma edla koko etapo God tle yu hapame molo atlalo oplami Yelemayata atlale mate ma-ala꞉iyo. Adipalati, ya꞉ta epo atluwapo, “Yia꞉tapo Isalael sota ya꞉ moto asiyama dla sale 30 elo maniye halopame matle isilako mimita꞉plalo oplami ta꞉laye haiyo, Lodta na꞉ watle atlale yu e dolumama.” ");
INSERT INTO xla_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuye Loum gamani oplami Paelet hala dla seme hetlati asiyama gamani oplamita ya꞉ watle epo atlaiyo, “Wa꞉ye ikadepe Yu so dokopala oplamita꞉?” diyo. Epalati Yesuta asiyama ya꞉ watle epo atlaiyo, “Yao, wa꞉ta atla mepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Epalati aiyalma aya dokopala so mate epo Yu so dokopala so mateta Yesuye batalimale pasatale oplami depame ya꞉ dla batalimale yu atlamyelati ya꞉ asiyama yu hale po-atlaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Epalati Paeletta ya꞉ watle epo atlaiyo, “Wa꞉ opata wa꞉ koko dla yu meyelope meyelope dle atlamyaye podallalo wekema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amasiyama Yesuta yu hale po-atlalo wekelati gamani oplamita koko e natipame sikemte momalamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sokomoko hapuloma dulu dla Paeletta Yu sota sisiyelepo depame Godta Namilatale daya dele oloma edla opata solotamale oplami haleye amtuwale aya dulu tle hamame alikili dla woyamdiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oloma edla batalimale pasatale oplami hale Balabasye amtuwale aya dulu dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Epeleye opa hapulomata alumalati Paeletta yia꞉ watle epo atlaiyo, “Na꞉ oplami adi tlo amtuwale aya tle alikili dla hamame woyapa꞉? Balabasta꞉, o Yesu, opata Keliso demdeta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Epele dulu dla ya꞉ mo-malanatiyo, Yu so dokopala sota Yesu dla sikemte elle himimama ya꞉ watle hamame pualeye. ");
INSERT INTO xla_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paelet ala koko gladlalo mo dla me-pollati ya꞉lluta ya꞉ watle yu hamimama epo atlaiyo, “Wa꞉ batalimale pa꞉le oplami edla koko hale hamiyo. Adipalati, na꞉ wata utula꞉la milamalo ya꞉ koko dla pta batalipo nati,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amasiyama aiyalma aya dokopala so mate epo Yu so dokopala so mateta opa hapuloma watle ha꞉ha꞉limyemama epo atlamyaiyo, “Paelet watle atlemama ‘Yesu tlo yummama Balabas tlo alikili dla hamame woyamane,’ diya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Epalati Paeletta opa hapuloma dla epo atlaiyo, “Wua꞉ oplami adi tlo na꞉ta amtuwale aya dulu tle alikili dla hamame woyamolowe solotama꞉?” diyo. Epalati opa hapulomata ya꞉ yu ipi dla epo atlamyaiyo, “Balabas tlo alikili dla hamame woyamane,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Epalati Paeletta epo atlaiyo, “Na꞉ta Balabasye amtuwale aya tle alikili dla hamame woyamelepiye, ame na꞉ Yesu, opata Keliso demdiye, adipapopa꞉?” diyo. Epalati asiyama opa hapulomata yu teta꞉le mate epo atlamyaiyo, “Ya꞉ye dali yekelemhimili di dla gogodiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Asiyama Paeletta yia꞉ watle epo atlaiyo, “Wua꞉ ya꞉ta apa batalimale koko halë hallati natipo ya꞉ye yumuluwedeme amma꞉?” diyo. Amasiyama opa hapulomata sikemte yu sisikalle mate epo atlamyaiyo, “Ya꞉ye dali yekelemhimili di dla gogodiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Epalati opata ya꞉ta solotamale koko pohalalo wekemama siyaladle ta꞉dla natipame ya꞉tapo yú tipo opa hapuloma mila꞉pi tle ya꞉ do howahamama epo atlaiyo, “Wua꞉ta oplami i ya꞉ omali olostlepiye, pona꞉ mate, amasiyama wua꞉ kokopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Epalati opa hapulomata epo atlaiyo, “Ya꞉ omalita olosta asiyamaye dita di yimlala mate halowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Epedeme Paelettapo Balabasye amtuwale aya tle alikili dla hamame woyamaiyo. Epame ya꞉ opa watle “Yesuye tuwale dea mate hopolepame dali yekelemhimili di dla gogodiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Epalati opahale sota Yesuye tuwale dea mate hopolepo Paelet aya dukuslopi haliyamale dla hamame hetaiyo. Epame edla opahale so opi hapuloma sisilapo alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yia꞉ edla alupo Yesuye tetlowedeme ya꞉ tluka uptipo ma patoto sota didiyelalo tluka omteka꞉ple selemalli didiyemeliyo. ");
INSERT INTO xla_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Epame tuwale dea tipo ya꞉ dokopala dla asiyomelepame ya꞉ dowala do dla dali hamiyo. Epame Yesu dla tetlemyemama ya꞉ dla heodepame epo atlamyaiyo, “Yu so dokopala oplami dla sisiyeiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Epame ya꞉ dla mitikape tilitimyemama ya꞉ dla dali hamiliye ma kolahapame ya꞉ dokopala dla siyomyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Epapopo gudepame opahale sotapo ya꞉ta tluka didiyepo halaleye uptipame ma ya꞉ tluka ikadepe didiyemeliyo. Epame ya꞉ye seme dali yekelemhimili di dla gogodlowedeme taiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Opahale sota Yesu seme mo dulu tle alikili dla ulatame tamama Kulene oplami Saimon umaiyo. Ya꞉ umpame Yesuta dali yekelemhimili hamtaleye ma ya꞉ watle hamtane diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yia꞉ epo tame Golgota mo dla woyamaiyo. Mo hi ya꞉ dulu kokoye dokopala elo. ");
INSERT INTO xla_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yia꞉ edla puame Yesu watle wain yúye etle yú mate dukupo hamiyo. Amasiyama Yesu yú iye isikimi yimka꞉mala dla natipame memeliyo. ");
INSERT INTO xla_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Epame opahale sota Yesuye dali yekelemhimili di dla gogodepame Yesu tluka hukulluwedeme yia꞉ dulu dla ewala mate tatipiyele hale tatipiyeiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yia꞉ Yesu tluka hukulupo popa꞉mama ya꞉ ompopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Epame oplami haleta yia꞉ta Yesu yumili sitali kokoye opata natilipo depame Yesu dokopala di dla ipo ilipo badiyo, ");
INSERT INTO xla_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Epame uhalalo so opa dapiyamte mape dali yekelemhatitimale di dla gogodlalimaiyo, haleta ya꞉ dowala tiyama dla epo haleta ya꞉ weke tiyama dla diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Epalati opata api etle tetla꞉po tamhalemama Yesu natipo yia꞉ dokopala popokalimyaiyo. Epame ya꞉ watle batalipo tetlalimyemama tepelemyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Epamyemama ya꞉ watle epo atlamyaiyo, “Wa꞉ta ipo atluwapo, ‘Na꞉ta aiyalma ayaye dokostapame ma alila dapahatlope dulu dla amko halepe,’ duwapo. Epapedeme wa꞉ ikadepe God Yami dlepiye, wa꞉ dali yekelemhimili di tle malame wa꞉skamu wa꞉ gadene,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Epame aiyalma aya dokopala so mate epo aiyalma imalalo so mate epo Yu so dokopala so mate yia꞉ mape Yesuye tepelemyemama epo atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ya꞉ye opa opi tlo gagademsela꞉mduwapo, amasiyama ya꞉ wata ya꞉skamu ya꞉ pogadesema. Ya꞉ye ikadepe Keliso, di Isalael so dokopala oplami dlepiye, ya꞉ dali yekelemhimili di tle mollowe ka꞉pi. Di eta ya꞉ta malla natipame ya꞉ dla mikadepe dlowepo. ");
INSERT INTO xla_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ya꞉ye God dla mikadepe demduwapo. Epedeme Godta ya꞉ dla siyemhalematiye, eta Godta wata ya꞉ pasakalo gadlemla. Adipalati, ya꞉ye ya꞉skamu atlemama, ‘na꞉ God Yami,’ demsela꞉mduwapo.” ");
INSERT INTO xla_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Epame uhalalo so opa dapiyamte Yesu mate dali yekelemhimili di dla gogodle so mape ya꞉ watle putlopo atlamyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sali mo-dukuslopi dla hallati mo patota motiti tumama sali inoma dapahatlope pololiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Epame motiti tuwaleta ma hawa hallati Yesuta yu teta꞉le mate epo sisilamaiyo, “Ilai, Ilai, lama sabakatani.” Yu i dulu kokoye ipapena, “Na꞉ God, na꞉ God, wa꞉ adipalati na꞉ melema꞉?” ");
INSERT INTO xla_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Epalati opa mateka꞉pi dla ha꞉ha꞉leta Yesuta semte Ilaya sisilamapo depame epo atlaiyo, “Wua꞉ daliya. Ya꞉ye Ilaya sisilamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Epame oplami haleta dali selemalli ipi dla tluka polupo wain yú haka꞉le dla saodepame Yesu mati dla haiyeiyo, ya꞉tapo delepo depame. ");
INSERT INTO xla_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Epalati opata epo atlaiyo, “Di ya꞉ye Ilayata puame hamame tulluwe depame aseka me-omha꞉ha꞉lowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Epame oloma edla Yesu yu sikemte di dla teta꞉pame powaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Epalati Yesuta powale oloma edla aiyalma aya dulu dla tluka deiyamaleta komaleye di tle tallademtulume isili dla gudiyo. Epame allu patota tumama teita meyelo glaglademyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Epame wabasi mape gowalagowaladiyo. Epalati God ya꞉ opa opi pallitapo sillipo yia꞉ wabasi tle alikili dla wowoyapo siyamaiyo. Epame Yesuta popo sila꞉tili alotle yia꞉ mape Yelusalem dla tame yiskamu yia꞉ye opa opi dla nalati-iyo. ");
INSERT INTO xla_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Epalati opahale so omhallalo oplami mate epo ya꞉ mate Yesu omha꞉ha꞉le so mateta allutuwale mate epo koko opi edla wowoyamale mate tlapame sikemte wowota꞉mama epo atlamyaiyo, “Ikadepe, oplami iye God Yamipo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Epame wola꞉ opi Yesu mate Ga꞉lili tle pumulale sota pateka꞉mu tle Yesu dali yekelemhimili di dla ellati omha꞉ha꞉iyo. Wola꞉ iwoloye Yesu mate Ga꞉lili tle pumulumama ya꞉ gadempumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Epapeleye wola꞉ opiye iwolopo. Meli Magadalin, epo Yeims mate Yosep mate yia꞉ wai Meli, epame Sebedi ya꞉llupo. ");
INSERT INTO xla_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tamila꞉la oloma edla alisisi pasatale oplami hale Alimatiya mo tle puaiyo. Ya꞉ hiye Yosep. Ya꞉ mape Yesu dolumtlalo oplami hale halaiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Epapeleye ya꞉tapo tame Paelet watle Yesu moto halowedeme daliyo. Epalati Paelettapo ya꞉ opa watle atlemama “Yesu motoye Yosep watle hamiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Epalati Yosepta Yesu motoye hapame tluka amko kamale mate polupame me-ya꞉ wabasi tei seselemale dla muwalle dulu dla hamatiyo. Epame wabasi dulu dla tullalo kokolomaye ewala patota kokolum-malame himomeleme taiyo. ");
INSERT INTO xla_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Epalati Meli Magadalin mate epo Meli hale mateta wabasi mateka꞉pi dla popa꞉mama ompopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","63","Epo alallati Yu sota inoma sumalalo alila dla aiyalma aya dokopala so mate epo Pa꞉lisi so mateta Paelet hala dla tame ya꞉ watle epo atlaiyo, “Isikimi mala-atlalo oplami Yesu itapo epo atlemduwapo, ‘Na꞉ye wabasi dulu dla alila dapiyamte elepame ma dapahatlope alila dla sila꞉tilowepo,’ demduwapo. ");
INSERT INTO xla_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Epapedeme di solotama, wa꞉ opata alila dapahatlope dulu dla wabasi alikili tle omha꞉ha꞉lepo depame. Adipalati, ya꞉ alotle tlalo sota puame ya꞉ moto uhamtapame ma isikimi mala-atlemama ya꞉ motoye mo-sila꞉time hetana dlala depame. Epapelepiye, alotle mala-atlowe koko itapo ya꞉ta ka꞉yapa mala-atlale kokoye tla꞉mtelepe.” ");
INSERT INTO xla_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Epalati Paeletta epo atlaiyo, “Wua꞉ na꞉ opa opi elemtame wabasiye woloma ka꞉pi omha꞉ha꞉iya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Epalati yia꞉ta hapulomata tame wabasi dla ha꞉ha꞉mama wabasi dulu dla ulatulalo api ewalata himomelle dla ulu himiyo, oplami haleta hemele tumama ewala alikili dla gilidle hallati natilowedeme. Epo gudepame omha꞉ha꞉lalo so watle omha꞉ha꞉iya diyo. ");
INSERT INTO xla_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yu sota inoma sumalalo alilata tame gudepo alallati Meli Magadalin mate epo Meli hale mateta wabasi natila tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yia꞉ ala wabasi dla tamha꞉ha꞉lati pakasiyamalalo allutuwale patota tulati Lod ya꞉ banakakata pepele di tle malame ewalaye alikili dla kokolustame di dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ya꞉tapo tluka kamkamale didiyepo polomama sikemte hela꞉dle mate usiyepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Epalati wabasi omha꞉ha꞉lalo so opatapo sikemte wowota꞉mama eseselalle mate powatatalepo palli some hutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amasiyama banakaka oplamita wola꞉ dapiyamte watle epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Na꞉malamana, wua꞉ Yesu dali yekelemhimili di dla gogoduwaye e totamsiyamapo. ");
INSERT INTO xla_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ya꞉ hema pe-elasema. Ya꞉ta meyelo atluwa yu e dolumama ya꞉ ma-sila꞉time hetana. Epedeme wua꞉ puame ya꞉ motota elale mo natiya. ");
INSERT INTO xla_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Epame wua꞉ ma hapele tame ya꞉ alotle tlalo so watle ipo atlaiye, ‘Yesuye ma-sila꞉time hetana. Epame ya꞉ tatle tame yia꞉ye Ga꞉lili dla ompolapo. Yia꞉ edla tame ya꞉ye natilipe,’ diye. Iye na꞉ yupo, wua꞉ dla.” ");
INSERT INTO xla_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Epo atla dalepame wola꞉ta ma ilame hapele sisiyele mate tamalemama me-wowota꞉mtamalaiyo, ya꞉ alotle tlalo so atlamolowedeme. ");
INSERT INTO xla_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Epo wowota꞉mtamalati pakasiyamalalo Yesuta api duka dla yia꞉ umpame epo atlaiyo, “Namkadulo,” diyo. Epalati wola꞉ dapiyamte iwolotapo puame ya꞉ hete sitali dla heodepo ya꞉ hete dla hohopo popa꞉mama ya꞉ dla siyele hamiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Wua꞉ tame na꞉ alotle tlalo soye atlaiye, yia꞉tapo tame Ga꞉lili dla na꞉ natilipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wola꞉ dapiyamte iwolota Yesu ya꞉ alotle tlalo soye ala atla tamha꞉ha꞉lati wabasi omha꞉ha꞉lalo sota tame aiyalma aya dokopala so watle wabasi dla koko wowoyamale hapulomaye atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Epela dalepame aiyalma aya dokopala sota Yu so dokopala so mate esemaiyo. Yia꞉ esepame mani pato wabasi alikili tle omha꞉ha꞉lalo so watle hamimama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Wua꞉ opa dla ipo atlaiye, ‘Di utula꞉la sikemte hutiyelati Yesu ya꞉ alotle tlalo sota hemele puame Yesu motoye hamta’ diye. ");
INSERT INTO xla_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Epame gamani oplami Paeletta koko i dalepo siyaladlepiye, ditapo ya꞉ta siyaladleye pustamama wua꞉ koko ka꞉dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Epalati wabasi omha꞉ha꞉lalo sotapo mani hapame yia꞉ta haiya dle kokoye haiyo. Epapele koko tle mala-atlale koko eye Yu sotapo yia꞉ dulu dla yu hamsiyamama ala me-hamsiyamapo. ");
INSERT INTO xla_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu ya꞉ alotle tlalo so 11ta Yesuta atlale yu dolumama Ga꞉lili dla tame tamali hale dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yia꞉ edla hetame Yesu natipame ya꞉ dla siyele hamiyo. Amasiyama yia꞉ dulu dla opitapo malamale tatlalimaiyo. ");
INSERT INTO xla_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Epalati Yesuta yia꞉ mateka꞉pi dla puame halemama epo atlaiyo, “Pepele dimo mate epo ta꞉lamo mate dla koko hapuloma omhallowe itiyamaleye na꞉ watle ma-hamiwapo. ");
INSERT INTO xla_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Epapedeme wua꞉ opa hapuloma ta꞉lamo meyelope meyelope dle dla ha꞉ha꞉mta so dla tame yia꞉ta na꞉ dla mikadepe dlepo depame ka꞉dle yuye atlamtaiya. Epammama yia꞉ye A hi tle epo Maseyemala hi tle epame Hela꞉dle Soko hi tle yú dla ka꞉ka꞉timtaiya. ");
INSERT INTO xla_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Epame molo atlale yu na꞉ta wua꞉ta dolumha꞉ha꞉lepo depo hamiwaye ma yia꞉ watle hamiya, ma yia꞉ta yu eye dolumha꞉ha꞉lepo depame. Amasiyama wua꞉ malamaiya, wata oloma itle kotiyapame ta꞉lamo mosukulu dla telepiye, na꞉tapo alila hapuloma dulu dla wua꞉ mate hallowepo.” ");
INSERT INTO xla_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Epedeme ka꞉dle molo atlale yu God yami Yesu Keliso kokoye ipo kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God tle yu hapame molo atlalo oplami Aisayata ya꞉ buka dla ipo hatitimuwapo, “Na꞉ta na꞉ yu hamsela꞉lalo oplamiye tane dlowepo. Epalati ya꞉ tatle tame wa꞉ apiye dinapelepe. ");
INSERT INTO xla_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ya꞉ye dalupa dulu dla ipo sisilamhalapo, ‘Lod apiye dinapiya. Epame ya꞉ apiye ka꞉depo dolepo himiya.’” ");
INSERT INTO xla_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Epedeme Yontapo dalupa dulu dla woyapame opaye yú dla ka꞉ka꞉timpuaiyo. Ya꞉ta epo atlamsela꞉iyo, “Wua꞉ bobtalimale tle heheletipame yú dla tutula꞉iya. Epalati Godtapo wua꞉ bobtalimaleye hiyotipo wellipe,” demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Epedeme Yudiya so opa hapuloma mate epo Yelusalem so opa hapuloma mate Yon yu dalla tamalaiyo. Yia꞉ Yon yu dalepame yia꞉ bobtalimale bobotimatimalati Yontapo yia꞉ye Yoden yú dla ka꞉ka꞉timaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yonye ka꞉mol aliya dlalota tluka dedlemale asiyamsela꞉mama alinepi kapalata akolo dla nosowe some asiyamsela꞉mdiyo. Epo ya꞉ wolomopi mate epo topsiyo mate demsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ya꞉ opa dla ipo atlamsela꞉iyo, “Oplami hale na꞉ ko tle pulupe. Ya꞉ta itiyamaleye pato, na꞉ta itiyamaleye tla꞉mtana. Na꞉ poka꞉dena, ya꞉ hete sitali dla heodepame ya꞉ hete alisisi uptimoloweye. ");
INSERT INTO xla_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na꞉tapo wua꞉ye yú siyapo dla ka꞉ka꞉tima, amasiyama ya꞉tapo wua꞉ye itiyamale hamimama Hela꞉dle Soko dla ka꞉ka꞉timelepe.” ");
INSERT INTO xla_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Alila oloma edla Yesu Ga꞉lili mo pato dulu dla Nasalet mo tle Yon hala dla pulati Yonta ya꞉ye Yoden yú dla ka꞉staiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu yú tulupo hetame halemama natilati Pepele dita gowaladepo hallati Hela꞉dle Sokota seselema tea some ya꞉ dla malla natiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Epalati Pepele di tle yuta epo malaiyo, “Wa꞉ye na꞉ dupa ellalo maseyemala ikadepepo, na꞉ wa꞉ dla sikemte siyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Koko ita tame gudlati Sokota Yesuye dalupa dulu dla semtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ya꞉ 40 alila dulu edla alinepi mate hallati Saitenta ya꞉ye elemala natimdiyo. Epalati God ya꞉ banakaka sota ya꞉ye gademdiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yu so dokopala oplami Helodta Yon amtuwale aya dla ka꞉stale alotle Yesu Ga꞉lili mo pato dla tame God tle puale ka꞉dle yuye epo atlamsela꞉iyo, ");
INSERT INTO xla_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Ka꞉dle alilata mo-puapo, epame God ya꞉ mo kokota puluweye mo-mateka꞉pi. Epedeme wua꞉ malamale meyelope depame wua꞉ bobtalimale tle heheletipo ka꞉dle yu dla mikadepe diya.” ");
INSERT INTO xla_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Alila haleta Yesu Ga꞉lili kaula peleyama tle tamhalemama natilati amalo halomalalo so opa Saimon mate ya꞉ ei Endulu mate mata hatitimsiyamala natiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesuta yia꞉ watle epo atlaiyo, “Na꞉ dolumpumulaiya. Wua꞉ ka꞉yapa amalo halomsiyamuwapo. Amasiyama wata oloma itle wua꞉ opaye ma God dla elempulalo so depo ha꞉ha꞉lepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Epalati yia꞉ yu e dalepame yia꞉ mata medla pomelepame Yesu mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yia꞉ ma etle tamalemama amalo halomsiyamalalo opa opi tlamaiyo, Sebedi ya꞉ akimlala Yeims mate epo Yon mate. Yia꞉ koa dulu dla mata dinampopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu yia꞉ natipame yia꞉ watle epo atlaiyo, “Na꞉ dolumpumulaiya,” diyo. Epalati yia꞉tapo pakasiyamalalo yia꞉ a Sebedi mate epo ya꞉ oko so opa mate koa dulu medla salepame Yesu mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ya꞉ alotle tlalo so mate Kapaniyem mo dla taiyo. Yia꞉ edla tame ha꞉ha꞉lati Yu sota inoma sumalalo alilata puaiyo. Epalati Yesu inoma sumalalo aya dla hetame God yu imolowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Epapele dulu dla opa hapulomatapo ya꞉ta imale koko dalepame sikemte yiyeliyo. Adipalati, ya꞉ta imale dulu dla po-aiyalma imalalo sota imalalo epapiyo. Amasiyama ya꞉ye sikemte itiyamale oplamita imalalo epapele some imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Epalati pakasiyamalalo bataliya walle oplami edla polaleta Yesuta imale dalepame yu teta꞉mama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu Nasalet oplami, wa꞉ apa hamsela꞉ma꞉? Wa꞉ dia꞉ye bobtalimala puo? Na꞉malamana, wa꞉ye God tle malale aiyalma oplamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Epalati Yesuta bataliya yemala watle yu itiyamale mate epo atlaiyo, “Keidene, epo ya꞉ tle alikili dla ulatane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Epalati bataliya yemalata oplami watle eseselalle pato hamipame hiyelle mate ya꞉ tle alikili dla ulataiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Opata i natipame yiyelle mate yimkadulo watle ipo atlanati atlanati demyaiyo, “Koko i adipapeta꞉? Imale amko sepena. Adipalati, Yesuta bataliya yemala watle itiyamale mate atlati ya꞉ yu dla salladepo alikili dla ulatalepo.” ");
INSERT INTO xla_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Epalati Ga꞉lili mo pato dla opa hapulomata koko i pakasiyamalalo dlalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Inoma sumaleta tame gudlati Yesutapo Yeims mate epo Yon mate eleme tame Saimon mate Endulu mate yia꞉ aya dla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","Amasiyama aya dulu edla a꞉ya hale Saimon ya꞉ doko esiyeme elaiyo. Yesuta esiyele koko iye dalepame ya꞉ natila tuwaiyo. Epapeleye ya꞉ta ellalo dla tuwame halemama ya꞉ do dla hamame sila꞉time pamelle oloma dla esiyeleta mo-pa꞉iyo. Epalati ya꞉tapo sila꞉time daya ha꞉po yia꞉ watle alemaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Tamila꞉la edla salita mo-tulli hallati opata Yesu hala dla esusulumale so hapuloma mate epo bataliya watalo so hapuloma mate elempumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Epalati Yesuta esiyele mila꞉pi meyelope meyelope dle halomale soye ka꞉ka꞉diyo. Epame bataliya yimlala opa dulu dla ha꞉ha꞉leye alikili dla dodolomsalemama yia꞉ watle yu hamiyo diyo. Adipalati, bataliya yimlala hapulomaye yia꞉malamaiyo, Yesuye ikadepe God Yamipo. ");
INSERT INTO xla_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Utulala ikadepe ala pohela꞉dlalo hallati Yesu elale tle sila꞉time aya saliyome keilipo elale mo dla inoma sumala taiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Epalati Saimon mate epo yimkadulo mate toko sillipo natitepo Yesuta hawa hallati ya꞉ totamtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yia꞉ tame Yesu natipame ya꞉ watle epo atlaiyo, “Opa hapulomata wa꞉ totamsiyama. Epedeme wa꞉ ilamtloweyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Hao, di ilame potlowa. Amasiyama di mo yimlala opi mateka꞉pi popa꞉mya dla tlowepo. Edla tame na꞉tapo God yu atlamolowepo. Adipalati, na꞉ ipapele koko hala puwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Epedeme ya꞉ Ga꞉lili mo pato dulu dla mo yimlala hapuloma dla tame Yu so inoma sumalalo aya dla God yu atlamsela꞉iyo. Epame bataliya yimlala mape opa dulu tle alikili dla dodolomsalemsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kapala batalimale oplamita Yesu watle puame alumata kellepo polomama epo atlaiyo, “Wa꞉ na꞉ ka꞉dlowe solotamelepiye, na꞉ ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu ya꞉ sikemte polowamale mate ya꞉ ummama ya꞉ watle epo atlaiyo, “Na꞉ wa꞉ ka꞉dlowe solotama, epedeme wa꞉ ma-ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Epalati pakasiyamalalo ya꞉ kapala batalimaleta ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuta ya꞉ye ma-tane demama yu itiyamale mate ipo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Wa꞉ tame na꞉ta wa꞉ ka꞉dleye opa opi dla atlamiyo. Amasiyama wa꞉ tame God ka꞉ epo opa ka꞉ duka dla hallalo oplami watle wa꞉ kapalata ka꞉dle kokoye nati-ine. Epame wa꞉ta ka꞉dle koko dla Mosesta atlale namkale dle alisisi mate God watle hapine, opata koko etle wa꞉ta ka꞉dle kokoye malanatilipo depame.” ");
INSERT INTO xla_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amasiyama ya꞉ Yesu yu hamastapame ma opa hapuloma watle ya꞉ kapala ka꞉dle kokoye esemsela꞉iyo. Epapele tle Yesuta mo hadima tama꞉, opa hapulomata ya꞉ natilowedeme sikemte aluma demsiyamdiyo. Epedeme ya꞉ ma mo opi dla opa inoma dali dla potademsela꞉iyo. Amasiyama ya꞉ opa pa꞉le mo dla hallati opata mepele mo meyelope meyelope dle tle ya꞉ hala dla pumhalemdiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Alila opi alotle Yesu ma ilame Kapaniyem mo dla pulati opata ya꞉ta puale kokoye mo edla ma-dlalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Epedeme opa hapulomata puame ya꞉ aya dulu mate alikili mate sikemte alumalati Yesuta yia꞉ watle God yu imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Epalati akoloyale oplami haleye opa dapiyamte dapiyamte dleta dea tili dla himpo Yesuta hala aya dla hamame pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yia꞉ solotamaiyo, Yesu hala dla hamame tuluwedeme, amasiyama opata kustimama api ponatiyo. Yia꞉ epalati oplami akoloyale eye dea tili mate aya dopuko di dla hamame hetaiyo. Epame Yesuta yukamhala oloma etle opokoko pokolepo dea tili mate isili a꞉ma halumtuluiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Opata akoloyale oplami dopuko di tle halumtulumhimilati Yesuta yia꞉ta mikadepe dle natipame akoloyale oplami watle epo atlaiyo, “Namkale, wa꞉ bobtalimaleye mo-hiyotipo wellipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amasiyama edla popa꞉le aiyalma imalalo so opa opita Yesuta atlale yu i dalepame allimama ipo momalampopa꞉iyo, ");
INSERT INTO xla_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Oplami iye adipalati ipo atlo? Ya꞉ God hi mate putlopo atlalepo. Adipalati, hatlo God dla itiyamale elapo, opa batalimale hiyotimoloweye,” dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Amasiyama Yesu yia꞉ta momalampopa꞉leye ma-natipame yia꞉ watle epo atlaiyo, “Wua꞉ adipalati na꞉ta atlale koko dla sikemte momalampopa꞉mama allimpopa꞉ma꞉? ");
INSERT INTO xla_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wua꞉ akoloyale oplami i natiya. Ya꞉ dla koko adipo atlowe tlo kokaleta꞉? ‘Na꞉ta wa꞉ batalimaleye ma-hiyostalepo,’ dlowe kokota kokaleta꞉? O, ‘wa꞉ sila꞉time wa꞉ wa꞉ya hame ma-tane,’ dlowe kokota kokaleta꞉? ");
INSERT INTO xla_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Epedeme Opa Yamita ta꞉lamo hema batalimale hiyotimolowe dla itiyamale hamsela꞉ye wua꞉ta natilipo depame na꞉tapo wata akoloyale oplami iye ka꞉dlowepo,” diyo. Epo atlepame Yesuta akoloyale oplami watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wa꞉ sila꞉time wa꞉ wa꞉ya hame wa꞉ aya dla tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Epalati opa hapulomata me-ompopa꞉lati akoloyale oplamita pakasiyamalalo sila꞉time ya꞉ wa꞉ya hame ya꞉ aya dla ma-taiyo. Epapeleye akoloyale oplamita ma-sila꞉timtla natipame yia꞉ta hapulomata sikemte yiyelepame God dla siyele ta꞉demyemama epo atlamyaiyo, “Di koko ipapele ponatisemde,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu Ga꞉lili kaula pili dla ma ilamtlati opa hapulomata ya꞉ hala dla puame alumaiyo. Epalati ya꞉tapo yia꞉ watle God yu imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Epame Yesu kaula pili dla sela꞉mama natilati oplami hale Alpiyes yami Libaiye ta꞉kis mani halomalalo aya dla polla natiyo. Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ dolumpuane,” diyo. Epalati ya꞉tapo sila꞉time Yesu mate taiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesutapo ya꞉ alotle tlalo so mate Libai aya dla hetame daya dempolaiyo. Epalati ta꞉kis mani halomalalo so mate epo batalimale so Yesu dolumsiyamale so mate yia꞉ ma Yesu mate hetame hatlo godepo daya dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Amasiyama Pa꞉lisi so opa mate epo aiyalma imalalo so opa mate koko i natipame allimama, Yesu ya꞉ alotle tlalo so watle epo atlaiyo, “Yesu adipapalati ta꞉kis mani halomalalo so mate epo batalimale so mate daya dempoloma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu yu i dalepame yia꞉ watle epo atlaiyo, “Esiyele pa꞉talo sotapo dakopala ilalo oplami hala dla potasemde. Amasiyama isikimi esusulumale sotapo dakopala ilalo oplami hala dla tamdepo. Epedeme na꞉ta puwaye, ka꞉ka꞉dle soye sisilamolowedeme popuana. Amasiyama bobtalimale so tlo sisilamolowedeme puwapo.” ");
INSERT INTO xla_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Alila haleta Yon opa yu dla ka꞉ka꞉timalalo ya꞉ alotle tlalo so mate epo Pa꞉lisi so yia꞉ alotle tlalo so mate God dla inoma sumha꞉ha꞉lowedeme daya aiyalma depo ha꞉ha꞉iyo. Epalati opa opita puame Yesu watle epo atlaiyo, “Wa꞉ natine, Yon ya꞉ alotle tlalo so mate epo Pa꞉lisi so yia꞉ alotle tlalo so mateta daya aiyalma depo ha꞉ha꞉po. Ame adipalati wa꞉ alotle tlalo so tlo daya po-aiyalma dlalo ha꞉ha꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Epalati asiyama Yesuta yia꞉ watle wayu mate epo atlaiyo, “A꞉ya halalo oplamita a꞉ya halowedeme daya dinapopo yimkadulo sisilamelepe. Epalati yimkadulota puame dayaye aiyalma depo popa꞉pa꞉? Hao. Yia꞉ sisiyele mate a꞉ya halalo oplami mate popa꞉mama dayaye yimkata dempopa꞉lepe. Adipalati, poka꞉dena, a꞉ya halalo oplamita yia꞉ mate pollati yia꞉ta daya aiyalma depo popa꞉loweye. ");
INSERT INTO xla_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amasiyama alila haleta a꞉ya halalo oplamiye yia꞉ tle alikili dla hamame telepiye, eta yia꞉tapo daya aiyalma depo popa꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesuta ma wayu hale mate epo atlaiyo, “Oplamitapo tluka takala dla tluka amko ketahame badepo podedlemasemde. Adipalati, tluka amkota itiyamama tluka takalaye tallatallademama opokoko sikemte pato dlepe. ");
INSERT INTO xla_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Epedeme matle oplamitapo wain yú amkoye aliya kapalata ita iwale takala dla posimasemde. Adipalati, wain yú amkota itiyamama aliya kapalata iwale ita takalaye gladlati wain yúye alikili dla olotlepe. Epapedeme ka꞉dena, wain yú amkoye woloma aliya kapalata iwale ita amko dla simoloweye.” ");
INSERT INTO xla_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yu sota inoma sumalalo alila haleta Yesuta ya꞉ alotle tlalo so mate witi daya emale dulu tle tamalaiyo. Yia꞉ tamalemama ya꞉ alotle tlalo sota witi dlomoko hauwalepo demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Epalati Pa꞉lisi sota koko i natipame Yesu watle epo atlaiyo, “Wa꞉ alotle tlalo soye adipalati dita inoma sumalalo alila dla dlowe alisisi hauwali? Yia꞉ di aiyalmaye ma-hauwokokomalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Wua꞉ God yu buka dla Deibidi mate ya꞉mkadulo mate yia꞉ta daya teta꞉lati koko halëye posesa꞉mdi? ");
INSERT INTO xla_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Adipalati, Abiyatata aiyalma aya dokopala depo halale oloma edla Deibidita ya꞉ opa mate daya teta꞉lati aiyalma aya dulu dla hetame aiyalma daya God dla hamili douwapo. Amasiyama di aiyalma dolumama isikimi God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo sota daya e dlomduwapo. Epapele tlope Deibidita mepele daya e demama ya꞉ opa watle hapiwapo.” ");
INSERT INTO xla_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu matle Pa꞉lisi so watle epo atlaiyo, “Godta di watle inoma sumalalo alila i himiwaye di watle wotiyalle koko hamiwa? Hao, pe-epapena. Isikimi di gadlowe dla inoma sumalalo alila iye himiwapo, dita hedepo popa꞉ demha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Epedeme Opa Yamitapo wua꞉ta inoma sumalalo alilaye ya꞉ta dokopala depo halapo.” ");
INSERT INTO xla_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yu so inoma sumalalo alila haleta Yesu yia꞉ta inoma sumalalo aya dla hetaiyo. Aya dulu edla do seme powale oplami hale me-polaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Epapeleye Pa꞉lisi sotapo Yesuta yia꞉ aiyalma hale postamama do seme powale oplami ka꞉dlowe depo omsiyamaiyo. Adipalati, yia꞉ aiyalma koko dolumama yia꞉ta inoma sumalalo alila dla esiyele oplami hale ka꞉dloweye aiyalmayo. ");
INSERT INTO xla_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuta do seme powale oplami watle epo atlaiyo, “Wa꞉ta pola metle sila꞉timpuame haliyamale hema halane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Epame Yesu Pa꞉lisi so watle epo atlaiyo, “Dita inoma sumalalo alila dla apa koko haloweta aiyalmata꞉? Ka꞉dle koko haloweta꞉, o batalimale koko haloweta꞉? Epame pasakalo gadloweta꞉, o pasakalo yumuluweta꞉?” Epalati Pa꞉lisi sota ya꞉ yu dalepame allimama yu opi po-atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuta Pa꞉lisi so tlapame yia꞉ watle sikemte siyaladiyo. Amasiyama ya꞉ ma yia꞉ yilo sikemte dupa koliyo. Adipalati, yia꞉ta oplami i gadlowe dla dupa kokalalimale tlapame. Epame do seme powale oplami watle epo atlaiyo, “Wa꞉ do dolene,” diyo. Epalati oplamita ya꞉ do dolle oloma edla ya꞉ dota ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Epalati Pa꞉lisi sota koko i natipame allimama yia꞉ta inoma sumalalo aya tle alikili dla tamalaiyo. Yia꞉ tame Helod ya꞉ alumale so mate Yesuye adipo hampo yumpa꞉ dle kokoye esemaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu ya꞉ alotle tlalo so mate Ga꞉lili kaula dla tlati opa hapulomata ya꞉ dolumtaiyo. Opa hapuloma iwoloye mo meyelope meyelope dle itle pumulaiyo, opita Ga꞉lili tle epo Yudiya tle epo Yelusalem tle epo Idumiya tle epo Yoden aloma seme dla ha꞉ha꞉lalo mo tle epo Taya mate epo Saidon mate epame mo e mateka꞉pi dla ha꞉ha꞉lalo mo tle. Epedeme opa hapulomata Yesuta koko hamsela꞉le dlalepame mo meyelope meyelope dle itle Yesu hala dla pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Opa hapuloma iwolota Yesu hala dla alumalati Yesuta esusulumale so opiye ka꞉ka꞉diyo. Epalati natipame esusulumale so opi hapulomata Yesu tluka ipi umuluwedeme opa alumale dulu dla sikemte akumtumulaiyo. Epedeme opata epo sikemte akumtumullati Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Na꞉ koa hale momolo himme popa꞉iya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Epapele dulu dla bataliya watalo sota Yesu natipame ya꞉ hete sitali dla teteyupo ikiyelemhutiyemama epo atlamyaiyo, “Wa꞉ye God Yamipo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Epalati Yesuta bataliya yimlala watle yu itiyamale mate epo atlamaiyo, “Wua꞉ opa watle atlemama na꞉ye God Yamipo demiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu tamali di dla hetame halemama ya꞉ta solotamale so opa tlo sisilamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Epame yia꞉ dulu dla ma opa 12 tlo hohomaiyo, ya꞉ mate siyamelepo depame. Epame yia꞉ watle Taiya dle so hi halopimama yia꞉ watle epo atlaiyo, “Na꞉ta wua꞉ye taiya dlowepo, God yu atlamsiyamelepo depame. ");
INSERT INTO xla_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Epo wua꞉ watle itiyamale hamilowepo, wua꞉tapo bataliya yimlala opa dulu dla ha꞉ha꞉ye alikili dla dodolomsalemsiyamelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Epapele dulu dla Yesuta opa 12 iwolo hohomaiyo, Saimon (Yesuta ya꞉ hi hale sepo iyo, Pita) ");
INSERT INTO xla_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","epo Sebedi ya꞉ akimlala dapiyamte Yeims mate epo ya꞉ ei Yon mate. (Yesutapo yia꞉ hi hale sepo ilimaiyo, Bouwaneges. Adipalati, hi i dulu kokoye omapla some halalo so.) ");
INSERT INTO xla_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Epo Endulu epo Pilipi epo Batolome epo Ma꞉tiyu epo Tomas epo Alpiyes yami Yeims epo Tadiyes epo Loum gamani so mate opahale demhalale oplami Saimon ");
INSERT INTO xla_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","epo Yudas Iskaliyot (alotle Yesu opahale do tama dla homelle.) ");
INSERT INTO xla_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ma ilame aya dla tlati opata matle sikemte alumaiyo. Opata edla alumtumama Yesu mate ya꞉ alotle tlalo so mate daya dlowe alila ponatiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Epalati Yesu ya꞉ asiyadulota Yesuta daya podlalo koko hamsela꞉le dalepame Yesu hamala puaiyo. Adipalati, yia꞉ta malamaleta Yesuye semte yiyilamselemapo depame. ");
INSERT INTO xla_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Epalati aiyalma imalalo so Yelusalem tle pumulaleta epo atlaiyo, “Yesuye bataliya walena. Ya꞉ dulu dla bataliya yimlala yia꞉ dokopala oplami Belsebulta halapo. Epedeme ya꞉tapo Yesu dla itiyamale hamilati bataliya yimlala opa dulu dla ha꞉ha꞉ye alikili dla dodolomsalemhalapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Epalati Yesuta aiyalma imalalo so sisilapame yia꞉ watle wayu mate epo imaiyo, “Saiten adipo ya꞉skamu opa dulu tle alikili dla dodolomsalepa꞉? ");
INSERT INTO xla_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Epedeme mo hatlope sotapo yiskamu yia꞉ dulu dla duka gladepame opahale dlepiye, mo eye pohallowa, batalimelepe. ");
INSERT INTO xla_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Epame asiya hatlope sota yiskamu yia꞉ dulu dla duka gladepame opahale dlepiye, asiya ewoloye poha꞉ha꞉lowa, batalimelepe. ");
INSERT INTO xla_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Epo Saitentapo ya꞉skamu ya꞉ opa mate duka gladepame opahale dlepiye, ya꞉ mo kokota kokó pe-ellowa, medla pa꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Epedeme oplami haleta itiyamale oplami aya dla hetame alisisi uhalomolowedeme apelepiye, ya꞉ ka꞉yapa itiyamale oplami tatle dea mate yupo himilipe. Epame alotle ya꞉ aya dulu dla hetame alisisi uhalomelepe. ");
INSERT INTO xla_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Epedeme na꞉ wua꞉ watle ikadepe koko atlema, batalimale koko hapuloma opata halomde mate epo yu batalimale God hi mate putlopo atlamde mateye Godta howahapo hiyostlepe. ");
INSERT INTO xla_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amasiyama oplami antapo Hela꞉dle Soko watle putlopo atlepiye, ya꞉ kokó elepo ellalo batalimale hapo. Epedeme ya꞉ batalimaleye pohowahapo hiyostlowa.” ");
INSERT INTO xla_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Epapele dulu dla aiyalma imalalo sota Yesuye bataliya walena dlati Yesuta koko iye yia꞉ watle epo atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Epame Yesu ya꞉ wai mate ya꞉ eidulo mateta ya꞉ natila pumulaiyo. Epeleye yia꞉ puame alikili dla ha꞉ha꞉mama Yesu mate yukamolowe solotamama oplami hale watle Yesu atla tuane diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Epalati opa hapuloma Yesu mate popa꞉leta ya꞉ watle epo atlaiyo, “Wa꞉ wai mate epo wa꞉ eidulo mate alikili dla wa꞉ omha꞉ha꞉uwo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Na꞉ wai anata꞉? Epo na꞉ eidulo ma anawolota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Amasiyama Yesuta opa hapuloma ya꞉ mate popa꞉le so dla tlapame yia꞉ watle epo atlaiyo, “Wua꞉ye na꞉ wai mate epo na꞉ eidulo matepo. ");
INSERT INTO xla_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Adipalati, opa anawolotapo Godta solotamale koko halomha꞉ha꞉lepiye, ewoloye na꞉ eidulopo epo notimadulopo epo na꞉ waidulo ikadepepo.” ");
INSERT INTO xla_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Alila haleta Yesu Ga꞉lili kaula pili dla imhallati opa hapulomata dallowedeme ya꞉ hala dla puame sikemte alumaiyo. Epalati Yesuta koa dla posokolome yú duka tiyama dla akustepo polomama opaye impolaiyo. Epalati opa hapulomata tamali tle popa꞉mama dalempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesuta imsela꞉le dulu dla isikimi wayu mate imsela꞉mdiyo. Epedeme ya꞉ wayu i mate opa iwolo imama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Na꞉ta koko atlowedeme apiye wua꞉ daliya. Alila haleta oplami haletapo witi daya aleye ka꞉ka꞉lla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ya꞉ witi daya ale ka꞉ka꞉lemsela꞉mama ale opitapo api duka dla teteyuiyo. Epalati teata puame deiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Epalati witi daya ale opitapo ewala ta꞉la dla teteyupame hapele popeyalimaiyo. Amasiyama yia꞉ye sali alemalleta yumama pakasiyamalalo paliyo. Adipalati, ta꞉la popta꞉deme yia꞉ keseye ta꞉la dulu dla sikemte potutula꞉lalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Epo ma witi daya ale opita osamokolo dulu dla teteyuiyo. Yia꞉ epame pakasiyamalalo popeyalimaiyo. Amasiyama yia꞉ta teta꞉le oloma edla osamokolota yia꞉ mate matamama dukuluta popoliyelati yia꞉ta hapulomatapo dlomoko pomilimalalo paliyo. ");
INSERT INTO xla_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Epame witi daya ale opita ta꞉la ka꞉dle dla teteyuiyo. Epame yia꞉tapo popeyalipo teta꞉pame dlomoko sikemte milimaiyo. Epele dulu dla witi daya ale opitapo 100 dlomoko milimaiyo. Epo opitapo 60 dlomoko milimaiyo. Epo opitapo 30 dlomoko milimaiyo.” ");
INSERT INTO xla_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesuta yu mosukulu gudemama epo atlaiyo, “Molo watalo so, wua꞉ yu iye woloma daliya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesuta opa impolopo gudlati yia꞉ta hapulomata ma yia꞉ mo dla i-ilapo tamalaiyo. Epalati Yesu ya꞉ alotle tlalo so mate epo opa opi Yesu dolumtale so mate medla popa꞉mama ya꞉ watle epo atlaiyo, “Wa꞉ adipalati opa watle wayu mate imsela꞉mdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Epalati Yesu asiyama yia꞉ watle epo atlaiyo, “Wua꞉tapo God ya꞉ mo kokoye malastlepe. Adipalati, ka꞉yapa God ya꞉ mo kokoye hemele hatiyomme eluwaye, wata wua꞉ dla mo-botomastapo. Amasiyama alikili sotapo wayu tlo dallepe, epele tlope yia꞉tapo wayu yia꞉ dulu kokoye woloma pomalamolowa. ");
INSERT INTO xla_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Adipalati, God yu bukata ipapele so opa watle epo atlapo, ‘Opa ipapele sotapo woloma kulume natilipe, amasiyama yia꞉ pomalanatilowa. Epame yia꞉ woloma kulume dallepe, amasiyama yia꞉ woloma pomalamolowa. Epedeme yia꞉ natipame dalemama malamale meyelope dematiye, eta Godta yia꞉ batalimaleye hiyotimelemla.’” ");
INSERT INTO xla_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuta ma yia꞉ watle epo atlaiyo, “Wayu i ya꞉ dulu kokoye pase kokalena. Ame adipalati wua꞉ wayu i ya꞉ dulu kokoye woloma pomalamalalo wekema꞉? Epedeme wua꞉ wayu i woloma pomalamalalo wekiye, wayu opi mape adipo malapa꞉? ");
INSERT INTO xla_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Epedeme witi daya ale ka꞉ka꞉llalo oplamiye God yu atlalo oplami epapelepo. Ya꞉tapo God yuye witi daya ale some ka꞉ka꞉lemdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Epapedeme opa opitapo witi daya ale opi api duka dla teteyuli epapele some ha꞉ha꞉po. Yia꞉ God yu ma-dalemdepo, amasiyama Saitentapo pakasiyamalalo yia꞉ tle kolahamdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Epame opa opiye witi daya ale ewala ta꞉la dla teteyuli epapele some ha꞉ha꞉po. Yia꞉ God yu atla dalepame siyele mate ma-hamdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amasiyama God yutapo yia꞉ dupa dulu dla kese woloma potutula꞉semde. Epedeme yia꞉ta God yuye dalepame isikimi alila kiyele dla mikadepe demdepo. Amasiyama yia꞉ta God yu hamale koko tle kokalle koko mate epo wotiyalle koko mateta yia꞉ dla woyamalati yia꞉ta God yu dla ha꞉ha꞉ etle ma-hapele alikili dla potamdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Epalati opa opitapo witi daya ale osamokolo dulu dla teteyuli epapele some ha꞉ha꞉po. Yia꞉tapo God yu dalepame hamdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amasiyama ta꞉lamo pasakalo momalamale mate epo alisisi poposatilipo ha꞉ha꞉lowe momalamale mate epo batalimale koko momalamale mateta yia꞉ta mikadepe dleye yumdepo. Epapele koko tle yia꞉ta mikadepe dle kokota dlomoko pomilimasemde. ");
INSERT INTO xla_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Epapalati opa opitapo witi daya ale ta꞉la ka꞉dle dla teteyuli epapele some ha꞉ha꞉po. Yia꞉tapo God yu dalepame yia꞉ dupa dulu dla woloma hatitimdepo. Epammama yia꞉ta dlomoko milimama opita 100 dlomoko milimdepo, epo opita 60 dlomoko milimdepo, epo ma opita 30 dlomoko milimdepo.” ");
INSERT INTO xla_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu matle wayu hale imama epo atlaiyo, “Wua꞉ tuloma otopo kawapota di tle bopudemdi? Hao. Wua꞉ tuloma otopame woloma haliyamale dla pamelemdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Epedeme watapo na꞉ wayuye tuloma kawapota bopudle epapele some hutiyepo. Amasiyama alotle na꞉ wayu koko ita haliyamale dla wowoyamelepe. ");
INSERT INTO xla_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Epedeme molo walle oplamitapo na꞉ta atlama koko i dallepe.” ");
INSERT INTO xla_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Epame Yesuta matle yia꞉ watle epo atlaiyo, “Na꞉ yu iye woloma dalepame haiya. Adipalati, oplami antapo na꞉ yuye hapame woloma dolumsela꞉lepiye, alotle Godtapo ya꞉ watle malamale ka꞉dle hamilipe. Amasiyama oplami antapo na꞉ yuye woloma podallalo wekelepiye, alotle Godta ya꞉ dla malamale ka꞉dle yemala elaye kolahalepe.” ");
INSERT INTO xla_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu matle wayu mate epo atlaiyo, “God ya꞉ mo kokoye ipapena. Oplamitapo dlomoko aleye ta꞉la dla ka꞉ka꞉llepe. ");
INSERT INTO xla_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Epo ya꞉ utula꞉la hapuloma mate alila hapuloma mate elepo sila꞉ti elepo sila꞉ti demhalemama ya꞉ta dlomoko ale ka꞉ka꞉lleta popeyalipo teta꞉ye ponatisemde. Epedeme ya꞉ poya꞉malamana, ya꞉ dlomoko ale ka꞉ka꞉lleta adipo teta꞉ma꞉ dle kokoye. ");
INSERT INTO xla_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Amasiyama dlomoko aleta ta꞉la dulu dla hutiyemama meyelo popeyalipo teta꞉mdepo. Epame yia꞉ teta꞉mama mupamu tatle wowoyamdepo. Epo alotle upata u-uplatimalati yia꞉ moto ma edla wowoyamdepo. Epame alotle yia꞉ motota teta꞉pame dlomoko milimdepo. ");
INSERT INTO xla_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Epalati dlomoko teta꞉po napo hutiyelati yo ka꞉ka꞉llalo oplamita puame dlalimdepo.” ");
INSERT INTO xla_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu matle yia꞉ watle epo atlaiyo, “God ya꞉ mo kokoye adipapeta꞉? Na꞉ adipapele koko mate God ya꞉ mo kokoye wua꞉ dla ipa꞉? Epedeme God ya꞉ mo koko ipapena. ");
INSERT INTO xla_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oplamitapo masted dlomoko ale yemala yimka꞉mala ikadepeye hamtame emomellepe. ");
INSERT INTO xla_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Amasiyama dlomoko ale yemala etapo peyapame ta꞉lepiye, osalo dulu edla dlomoko dali eta pato hallepe. Epalati ya꞉ dlota pateka꞉mu dla yalemtlati teata homale edla puame eto tilimyelepe.” ");
INSERT INTO xla_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu opa dla God yu atlamsela꞉mama wayu ipapele mate sikemte atlamsela꞉mdiyo. Adipalati, wayu ipapeleta yia꞉ta malamale mate ala꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Epapele tlope ya꞉ opa hapuloma watle wayu ya꞉ dulu kokoye po-imsela꞉mdiyo. Amasiyama ya꞉ alotle tlalo sota miyelo ya꞉ mate popa꞉lati ya꞉tapo wayu ya꞉ dulu kokoye woloma yia꞉ watle imdiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Alila eta sali mo-tullati Yesutapo ya꞉ alotle tlalo so watle epo atlaiyo, “Di kaula seme dla ulluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Epame Yesu ya꞉ alotle tlalo so mate ya꞉ta God yu atlampolale koa e hame opa saliyome kaula seme dla uliyo. Epalati opa opi mape koa opi dla alupo alotle pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yia꞉ seme dla ulumha꞉ha꞉lati pakasiyamalalo sokomoko patota bibikilimaiyo. Epalati yia꞉ ala me-tamha꞉ha꞉lati ulo patotota sillipame yia꞉ koa dulu dla yúta sosowalatamama yia꞉ koaye yú dulu dla ollodla yakomaiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Amasiyama Yesu kei dla matali himme elaiyo. Epalati ya꞉ alotle tlalo sotapo ya꞉ esesa꞉mama ya꞉ watle epo atlaiyo, “Imalalo oplami, wa꞉ dita yú tutula꞉la yakomaye wa꞉ me-natima꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Epalati Yesuta elale tle yelepo sila꞉time halemama sokomoko mate epo ulo mate dla epo atlaiyo, “Wua꞉ medla kekeidiya,” diyo. Epalati oloma edla sokomoko mate ulo mateta medla kekeidiyo. ");
INSERT INTO xla_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu koko i hapo halemama ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ adipalati wowota꞉ma꞉? Wua꞉ ala mikadepe dle me-pa꞉po ha꞉ha꞉pa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Amasiyama ya꞉ alotle tlalo sotapo sikemte wowota꞉mama yiskamu yia꞉ dulu dla atlanati atlanati demyemama epo atlamyaiyo, “Oplami iye anata꞉? Sokomoko mate epo ulo mateta ya꞉ yu dalepo keka꞉llipo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Epedeme Yesuta ya꞉ alotle tlalo so mate Ga꞉lili kaula seme dla uliyo. Yia꞉ tame Gelasa so yia꞉ mo ipi dla yia꞉ koa himiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Epo Yesu ala koa tle tamali dla hetamhallati bataliya walle oplamita pakasiyamalalo popliyele hatili mo tle woyapame Yesu hala dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Oplami iye popliyele hatili mo dla halemdiyo. Ya꞉ye sikemte itiyamaiyo. Epapele koko tle opata ya꞉ do mate epo ya꞉ hete mate oli deata yupo himmdiyo. Amasiyama ya꞉ta itiyamaleta oli deaye mepele gelledemdiyo. Epame oplami haleta ya꞉ omhalloweye po-ala꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ya꞉ alila hapuloma mate epo utula꞉la hapuloma mate popliyele hatili mo dla epo koloma di dla hehetamsela꞉mama ewalata ya꞉skamu ya꞉ kapala kotimsela꞉mama hihiyelemsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Epedeme oplami itapo Yesu ala pateka꞉mu tle natipame kukulumtame ya꞉ hete sitali isili dla heodepo polaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Epalati Yesuta ya꞉ watle epo atlaiyo, “Bataliya, wa꞉ ya꞉ tle alikili dla ulatane,” diyo. Amasiyama Yesu ala epo atlemhallati bataliya walle oplamita asiyama yu teta꞉le mate epo atlaiyo, “Yesu, sikemte di dla hallalo God Yami, wa꞉ apa koko na꞉ dla hala puo? Na꞉ God hi mate wa꞉ dla atlema, na꞉ dla wotiyalle hamimiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ hi anata꞉?” diyo. Epalati ya꞉ta asiyama Yesu watle epo atlaiyo, “Na꞉ hiye Atumkaka. Adipalati, dia꞉ye sikemte pasatana,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Epame ya꞉ta Yesu watle ma otomama epo atlaiyo, “Wa꞉ dia꞉ye mo itle alikili dla dodolomsalemiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Epapele oloma dla donapi di dla aliya halo hapulomatapo ketame modlomsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Epela natipame Atumkakata Yesu watle otomama epo atlaiyo, “Wa꞉ dia꞉ye aliya dulu dla tuwaiya dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Epalati Yesuta yia꞉ye aliya dulu dla tumulaiya diyo. Oloma edla bataliya yimlalata oplami tle u-ulapo tame ma aliya dulu dla tumulaiyo. Epalati 2,000 aliya epapeleta donapi di tle ullumtulume yú dulu dla tutula꞉mama me-paliyo. ");
INSERT INTO xla_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Epalati aliya omha꞉ha꞉lalo sota koko i natipame potame yia꞉ mo dla epo yia꞉ dakase aya dla atlamtaiyo. Epalati mo sota koko i dalepame woloma natila tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Opa hapulomata puame Yesu hala dla natitepo bataliya walle oplamita malamale ma-ka꞉depo tluka didiyepo polla natiyo. Epalati yia꞉ta hapulomatapo sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Epame aliya omha꞉ha꞉lalo sotapo Yesuta bataliya walle oplami ka꞉dle mate epo aliyata palli koko mate yia꞉ watle matle woloma atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Epalati opata koko i dalepame wowota꞉mama Yesu watle epo atlaiyo, “Wa꞉ di mo itle alikili a꞉ma woyapo tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Epalati Yesuta ma ilame tlowedeme koa dla posokolome hallati oplami ya꞉ta ka꞉dleta ya꞉ watle epo atlaiyo, “Na꞉ wa꞉ mate tlowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amasiyama Yesuta ya꞉ watle epo atlaiyo, “Hao, wa꞉ na꞉ mate potlowa. Wa꞉ ma aya dla ilame tame Lodta wa꞉ polowamama wa꞉ dla koko pato halëye wa꞉ asiyadulo dla atlamane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Epalati ya꞉ ma ilame tame Dekapolis mo dla Yesuta ya꞉ gadle kokoye atlamsela꞉iyo. Ya꞉ta koko i atlamsela꞉lati opata dlalepame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu ma ilame ya꞉ alotle tlalo so mate kaula seme dla uliyo. Yia꞉ yame kaula seme peleyama dla ha꞉ha꞉lati opa hapulomata yia꞉ hala dla alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Opa alumale dulu dla oplami hale halaiyo, ya꞉ hiye Yelus. Ya꞉tapo mo edla Yu so inoma sumalalo aya omhalemdiyo. Ya꞉ Yesu natipame ya꞉ hete sitali isili dla tulume heodepo polomama otele mate epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Na꞉ amseyemala me-ipilalo yemalaye mo-polowe mateka꞉pi dla elema. Epedeme wa꞉ puame na꞉ amseyemalaye dota hamame inoma sumane, ya꞉ta ka꞉depo hallepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Epalati Yesuta ya꞉ yu dalepame ya꞉ mate taiyo. Amasiyama dulu edla opa hapulomata Yesu mate tamama sikemte kustipo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","26","Epalati opa alumale dulu edla a꞉ya hale ya꞉ toto koko natimama ka꞉lliwe pa꞉le esiyele hamhalaiyo. Ya꞉ 12 sokomoko dulu dla esiyele i mate halemama dakopala ilalo sota ya꞉ye ka꞉dlepo depame mani pato yia꞉ watle hamastamdiyo. Amasiyama yia꞉tapo ya꞉ye poka꞉dlalo isikimi ya꞉ dla wotiyalle tlo me-hapimha꞉ha꞉mama esiyeleta me-ta꞉mtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Epedeme ya꞉ Yesuta opa ka꞉ka꞉demsela꞉ dalepame ya꞉ epo malamaiyo, “Na꞉ isikimi tame Yesu tluka ipi tlo umili, eta na꞉ye ka꞉dlepe,” diyo. Ya꞉ epo malapame opa dulu tle tuwame Yesu tluka ipi umaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ya꞉ta tame Yesu tluka ipi umale oloma edla ya꞉ toto koko natili esiyeleta ya꞉ tle mo-pa꞉iyo. Epame esiyeleta mo-pa꞉lati ya꞉ ya꞉skamu epo malamaiyo, “Wata esiyele iye na꞉ tle mo-pa꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Epalati Yesu pakasiyamalalo ya꞉ta itiyamaleta alikili dla ulatlati natipo helestame halemama opa dla epo atlaiyo, “Oplami anta na꞉ tluka ipi umo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Epalati ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Wa꞉ adipapalati ‘oplami anta na꞉ umo,’ dema꞉? Wa꞉ natine, opa hapulomata wa꞉ mate kustipo tamalemama wa꞉ umamtamalapo.” ");
INSERT INTO xla_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amasiyama Yesu me-tlamhalaiyo, ya꞉ tluka umale oplami natilowedeme. ");
INSERT INTO xla_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Epalati a꞉ya Yesu tluka umaleta ya꞉skamu ya꞉ta ka꞉dle koko malapame wota꞉mama eseselalle mate Yesu hete sitali isili dla puame polomama ya꞉ta ka꞉dle kokoye Yesu watle atlaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Epalati Yesuta asiyama ya꞉ watle epo atlaiyo, “Namkale, wa꞉ta na꞉ dla mikadepe dletapo wa꞉ye ma-ka꞉dlepo. Epedeme siyele mate tane. Adipalati, esiyeleta wa꞉ tle mo-pa꞉lepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ala me-yukamhallati opa Yelus aya tle puame Yelus watle epo atlaiyo, “Wa꞉ amseyemala mo-powame elema. Epedeme wa꞉ta imalalo oplami sempuluweye koko pa꞉na,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amasiyama Yesuta yia꞉ta atlale yu dalepame yia꞉ yu pohalalo Yelus watle epo atlaiyo, “Wa꞉ ase sikemte wota꞉miya. Isikimi na꞉ dla mikadepe dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu epame Yelus aya dla tamama opa hapuloma medla pomelepo ma isikimi Pita mate epo Yeims mate epo Yeims ya꞉ ei Yon mate tlo elemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Epame yia꞉ tame Yelus aya dla natilati opa hapulomata a꞉lemyemama sikemte wowolimyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Epalati Yesuta aya dulu dla hetame halemama yia꞉ watle epo atlaiyo, “Wua꞉ adipalati a꞉lemyemama wowolimyema꞉? Amseyemala iye popowame elasema. Ya꞉ isikimi elapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amasiyama yia꞉tapo Yesu yu dalepame eimelemyaiyo. Epalati Yesuta yia꞉ watle, “aya dulu itle alikili a꞉ma u-ulapo taiya,” diyo. Epame ya꞉ alotle tlalo so mate amseyemala ya꞉ a mate epo ya꞉ wai mate elepame amseyemalata ela aya dulu dla tuwaiyo. ");
INSERT INTO xla_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu tuwame amseyemala powame ela do dla hamame halemama epo atlaiyo, “Amseyemala, wa꞉ sila꞉tine,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Epapele oloma edla amseyemala mo-powame elaleta ma sila꞉timsela꞉iyo. Epalati opa hapulomata koko i natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Epame Yesuta yia꞉ watle yu itiyamale mate epo atlaiyo, “Wua꞉ na꞉ta amseyemala i ka꞉dle kokoye opa opi watle atlamiyo,” diyo. Epo halemama “amseyemalaye daya hamiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ya꞉ alotle tlalo so mate mo etle ma ilame ya꞉ mo ikadepe Nasalet dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ya꞉ mo edla tame hallati Yu so inoma sumalalo alilata puaiyo. Epalati Yesuta yia꞉ta inoma sumalalo aya dla hetame halemama opaye God yu mate imhalaiyo. Epalati opa hapulomata ya꞉ta imale dalepame sikemte yiyelemama epo atlamyaiyo, “Oplami ita malamale adipapeta꞉? Ya꞉ta imale hamsela꞉leye hadima hauwa? Epame ya꞉ dota ulugiyemale koko halomsela꞉ye, apa kokota꞉? ");
INSERT INTO xla_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ya꞉ isikimi Meli yami, aya halalo oplamipo. Epo ya꞉ye Yeims epo Yosep epo Yudas epo Saimon yia꞉ bapapo. Epame yotumadulo mape dia꞉ mate midla popa꞉po,” demyaiyo. Epedeme yia꞉ta ipo malamale tle Yesuta imale haloweye alliyo. ");
INSERT INTO xla_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Epalati Yesuta yia꞉ watle epo atlaiyo, “Opatapo God tle yu hapame molo atlalo oplami yu dla dalepame heodemdepo. Amasiyama ya꞉ mo so mate epo ya꞉ asiyadulo mate epo ya꞉ aya dulu dla ha꞉ha꞉lalo so matetapo ya꞉ yu dla dalepame peheodesemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Epedeme Yesu yia꞉ta ya꞉ dla allimama mikadepe dle pa꞉le natipame ya꞉ ulugiyemale koko pase halomaiyo. Isikimi esusulumale so hatlope hatlope dle tlo ya꞉ do mate hohopame ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Epapeleye ya꞉ yia꞉ta mikadepe dle pa꞉le natipo yelepame Nasalet mo tle ma mo opi yimka꞉sikili dla God yu imsela꞉la taiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu ya꞉ alotle tlalo so 12 sisilapame yimkata alumaiyo. Epalati Yesuta yia꞉ dulu dla dapiyamte dapiyamte depo hohomtapame, “Mo meyelope meyelope dle dla taiya,” diyo. Yia꞉ watle taiya demama bataliya yimlala alikili dla dodolomsallowe itiyamale mate hamiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesuta yia꞉ watle yu itiyamale mate epo hamiyo, “Wua꞉ tamama alisisi opi pohalopo tlowa, isikimi dali ku tlo halopo tamellepe. Epame daya ma pohalopo tlowa. Epo duli ma pohalopo tlowa. Epo mani ma pohalopo tlowa. ");
INSERT INTO xla_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Amasiyama hete alisisi didiyepame tluka alisisi mape isikimi wua꞉ta didiyepo ha꞉ha꞉ metlo didiyepo tamellepe. ");
INSERT INTO xla_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wua꞉ta mo dla tame woyamale oloma edla opata wua꞉ye yia꞉ aya dla seme hetlepiye, wua꞉ aya hatlo medla hutiyemha꞉ha꞉lepe. Epame wua꞉ta mo etle mo-tlowedemeta aya eye saliyomta demsiyamelepe. ");
INSERT INTO xla_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Epame wua꞉ mo hadima tlati opata wua꞉ye pe-elemhetlalo wekemama wua꞉ yu ma podallalo wekelepiye, wua꞉ mo e saliyome tlowedeme yia꞉ mo sokopeta wua꞉ hete dla popolahaleye hihiyollepe, Godta kasilamale kokota yia꞉ dla pua kokoye imolowedeme.” ");
INSERT INTO xla_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Epapeleye Yesuta ya꞉ alotle tlalo so watle koko i ipo gudepame yia꞉ye taiya diyo. Epalati yia꞉ tame God yu opa dla atlamsiyamama epo atlamsiyamaiyo, “Wua꞉ malamale meyelope depame wua꞉ bobtalimale tle heheletimaiya,” demsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Epame bataliya yimlala opa dulu dla ha꞉ha꞉leye yia꞉ta alikili dla dodolomsalemsiyamaiyo. Epame esusulumale so mape dakopala mate yia꞉ dokopala dla huhutupiliyelati esiyeleta yia꞉ tle pa꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Epalati alotle Yesuta itiyamale mate ulugiyemale koko halomsela꞉lati opata Yesu koko dla epo atlemdiyo, “Oplami iye Yon opa yú dla ka꞉ka꞉timalalo oplami mle. Epedeme ya꞉ powale tle ma-sila꞉timpuame ulugiyemale koko i halomsela꞉yo,” demdiyo. Epo opa opita ma epo atlemdiyo, “Yesuye God tle yu hapame molo atlalo oplami hale Ilaya mle,” demdiyo. Epalati ma opa opitapo epo atlemdiyo, “Ya꞉ God tle yu hapame molo atlalo so ka꞉yapa ha꞉ha꞉uwa so epapele oplami hale mle,” demdiyo. Amasiyama Helodta Yesu koko dalepame epo atlaiyo, “Ya꞉ye Yonpo. Na꞉ta dokopala ketamastauwata matle powale tle pasakalo depo sila꞉timsela꞉yo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Alila haleta Helodta ya꞉ ei Pilipi ya꞉llu Helodiyasye kolahalati Yon opa yú dla ka꞉ka꞉timalalota ya꞉ye sikemte golemama epo atlemdiyo, “Wa꞉ta wa꞉ ei ya꞉llu kolahaleye, koko e poka꞉dena,” demdiyo. Epalati Helodiyasta siyaladepame tame Helod watle Yon amtuwale aya dulu dla ka꞉stlepo depame atlaiyo. Epalati Helodta ya꞉ opaye taiya dlati yia꞉tapo tame Yon hampame amtuwale aya dulu dla ka꞉staiyo. Amasiyama Helodiyasta Yon sikemte alimama ya꞉ yumuluwe solotamaiyo. Epele tlope Helodta Yon yumuluwe wota꞉mama ya꞉ye woloma omhalaiyo. Adipalati, Helod ya꞉ malamaiyo, Yonye ka꞉dle oplamipo. Epedeme Helodta Yonta God yu atlemhallati dalepame haloweye malamale tatlamdiyo. Epele tlope ya꞉ Yon yuye me-dallowe solotamdiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amasiyama alotle Helodiyas dla Yon yumuluwe alila ka꞉dleta puaiyo. Epedeme Helod hamale alila dla daya pato dlowedeme gamani dokopala so mate epo ya꞉ opahale dokopala so mate epo Ga꞉lili mo dulu dla dokopala ha꞉ha꞉lalo so hapuloma mate Helodta sisilamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yia꞉ puame daya dempopa꞉lati Helodiyas yotita puame yia꞉ watle siyele hamimama yomaiyo. Ya꞉ yopo gudlati Helodta ya꞉ watle epo atlaiyo, “Wa꞉ta apa koko solotamale na꞉ dla atlepiye, na꞉ koko eye wa꞉ dla hamilowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ya꞉ epo polomama ya꞉skamu aiyalma saiyo, meyelo yu himili postlala depo. Epame matle ya꞉ watle epo atlaiyo, “Na꞉ watle wa꞉ta solotamale koko atlemama na꞉ ta꞉la seme mate halowe solotamelepiye, na꞉ wa꞉ watle hamilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Epalati amseyemalata tame ya꞉ wai Helodiyas hala dla ya꞉ta solotamale koko daliyo. Epapalati ya꞉ waita epo atlaiyo, “Wa꞉ tame ipo atlane, ‘Na꞉ Yon dokopala ketahalë halowe solotama’ dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Epalati amseyemalata ya꞉ wai yu dalepo hapele ilamtame Helod watle epo atlaiyo, “Na꞉ solotama, Yon dokopalaye ketahapo kowepa dla himimpulati halowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Helodta yu i dalepame sikemte dupa koliyo. Amasiyama ya꞉ opa hapuloma inoma dali dla ya꞉ta aiyalma sale postloweye wota꞉mama amseyemala yu dla alliweye posolotamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Epammama ya꞉tapo amtuwale aya omhallalo oplami hale watle epo atlaiyo, “Wa꞉ tame Yon dokopalaye ketahapo kowepa dla himimpuane,” diyo. Epalati ya꞉ tame amtuwale aya dulu dla Yon dokopalaye ketahapo kowepa dla himimpuame amseyemala watle hamiyo. Epalati amseyemalatapo dokopala eye hame ma ya꞉ wai watle hamiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Epalati Yon ya꞉ alotle tlalo sota koko i dalepame puame Yon moto hapame ta꞉la dla muwalepo polomeliyo. ");
INSERT INTO xla_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesuta ya꞉ alotle tlalo so watle taiya dlati yia꞉ tame siyapo ma i-ilapo puame Yesu hala dla alupame yia꞉ta koko halomsiyamale mate epo yia꞉ta imsiyamale mate Yesu watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Amasiyama opa hapulomata Yesu hala dla ta epo pua demsiyamalati Yesu mate ya꞉ alotle tlalo so mate daya dlowe alila ka꞉dle ponatiyo. Epedeme Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Di aseka bidulo keilipo elale mo dla hedla tlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Epame Yesuta ya꞉ alotle tlalo so mate tulume koa dla alupo kaula seme dla homta ellalo mo dla uliyo. ");
INSERT INTO xla_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yia꞉ kaula seme dla ala ulumha꞉ha꞉lati opata yia꞉ natipame mo meyelope meyelope dle tle Yesuta ta mo edla yia꞉ tatle tamali api ullumtamalaiyo. Yia꞉ ma-tame edla ompopa꞉lati Yesuta ya꞉ alotle tlalo so mate koa tle pumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu koa tle tamali dla posokolome halemama opa hapuloma alumale natipame yia꞉ sikemte polowamaiyo. Adipalati, yia꞉ye sipi aliya halota omhallalo pa꞉le epapele some popa꞉iyo. Epalati natipame Yesuta yia꞉ watle God koko hapuloma imolowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Yesu ala opa dla me-imhallati salita mo-tulumtaiyo. Epalati ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Sali mo-tulupo. Epedeme wa꞉ opa hapuloma iye ma-taiya dene, yia꞉tapo mo mateka꞉pi hema popa꞉ dla tame daya halomelepo depame. Adipalati, dita popa꞉ mo iye daya pa꞉na,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Muwolo yia꞉ye daya halopiya,” diyo. Epalati ya꞉ alotle tlalo sota Yesu watle epo atlaiyo, “Wa꞉ adipalati dimsilamale koko dia꞉ dla atlema꞉? Wa꞉ natine, oplamitapo opa alumale isowa daya ilimolowe mani halowedeme sokomoko hatlo dulu dla oko halepiye, mani eta opa hapuloma iye po-ala꞉lowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ dla daya adisowata hutiyema꞉? Tame tlamaiya,” diyo. Epalati yia꞉ta tame tlapo puame epo atlaiyo, “Isikimi daya mo-halomale do supulastale mate epo amalo dapiyamte mateta me-hutiyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Epalati Yesuta ya꞉ alotle tlalo so watle atlemama “Opaye tuptu dla alupo popa꞉ alupo popa꞉ demtaiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Epalati opata alumale meyelope meyelope depo popa꞉mtamama opita 100 sota popa꞉ epo opita 50 sota popa꞉ demtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Epalati Yesuta daya mo-halomale do supulastale mate amalo dapiyamte mate halopame pepele di dla omhalemama God dla siyele yu atlepame daya hauwokokomaiyo. Epame ya꞉ alotle tlalo so watle hapiyo, yia꞉tapo ma opa hapuloma watle alemelepo depame. Ya꞉ epame amalo ma hauwokokopo ya꞉ alotle tlalo so watle alemaiya diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Opa hapulomata daya dlopo sikemte susukalemama daya popokadiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Epalati Yesu ya꞉ alotle tlalo sota daya akutu mate amalo akutu mate popomelleye yekalo 12 dla atilimama poposatilimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Epedeme opa mate epo wola꞉ mate epame yimlala mate daya i deiyo. Amasiyama sesa꞉le oloma dla opa siyapo tlo sesa꞉mama 5,000 umaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Daya dele gudlati Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ tatle kaula seme Betsaida dla uliye. Na꞉ opa iwoloye taiye depo alotle puluwamo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu opa hapulomaye ma-taiya depame meyelo tamali di dla inoma sumala hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Epame tamila꞉la eta ya꞉ alotle tlalo so koaye mo-kaula dukuslopi dla tamhallati Yesu meyelope tamali dla ala me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Ya꞉ halemama natilati mosisita puame ya꞉ alotle tlalo so koa dla sikemte yulati yia꞉ta koa sosolemtamama susukalle mate tamha꞉ha꞉la natiyo. Epo utulala ikadepe ala iki yulumhallati Yesutapo yú di tle yia꞉ hala dla taiyo. Yesu yia꞉ koa ala tla꞉me tamhallati ya꞉ alotle tlalo sota ya꞉ natipame semte bataliya tepo depame ikiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Epalati Yesuta ya꞉ alotle tlalo sota ya꞉ natipo wowota꞉mama ikiyellati yia꞉ watle epo atlaiyo, “Ase sikemte wowota꞉miya. Na꞉ta puma,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Epame ya꞉ ma koa dulu dla posokollati oloma edla mosisita ka꞉liyo. Epo ya꞉ alotle tlalo sota koko i natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Adipalati, yia꞉ye Yesuta 5,000 opa dla daya ilimale edla Yesuta itiyamaleye woloma pomalanatiyo. Ame adipalati, yia꞉ dupa sikemte kokalalimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yia꞉ kaula ulume Genesalet mo dla tame woyapame koa himiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yia꞉ta koa tle tamali dla posokoleme tale oloma edla opatapo Yesu pakasiyamalalo malanatiyo. ");
INSERT INTO xla_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Opata Yesu malanatipame mo meyelope meyelope dle dla yu hame ullumtamalaiyo, esusulumale soye Yesu hala dla hohopo pumullupo depame. ");
INSERT INTO xla_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Epedeme Yesuta mo hadima tamsela꞉uwa edla opata esusulumale soye hohopo puame haliyamale dla ipila꞉ demsiyamdiyo, Yesuta yia꞉ye ka꞉ka꞉dlepo depame. Epalati esusulumale so hapulomata Yesu watle otomama epo atlamyaiyo, “Di isikimi wa꞉ tluka ipi tlo umamolowama,” demyaiyo. Epapele dulu dla ya꞉ tluka ipi umamale so hapulomata ma-ka꞉ka꞉dlalimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pa꞉lisi so mate epo Yelusalem tle pumulale aiyalma imalalo so mateta Yesu hala dla puame alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yia꞉ puame natilati Yesu ya꞉ alotle tlalo so opita yia꞉ toto koko mate podolumalalo yia꞉ do pohowahalomalalo daya me-dlompopa꞉la natiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Epapele dulu dla Pa꞉lisi so mate Yu so opi mate yia꞉ toto koko dolumama yia꞉ do howahalopo daya dlomdepo. Adipalati, yia꞉ta malamdepo, yia꞉ta do pohowahalomalalo daya delepiye, eta yia꞉ dupa dulu batalimelepe, demdepo. ");
INSERT INTO xla_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Epame yia꞉ alisisi halomalalo aya tle alisisi halopo puame dlowedeme yia꞉ tatle yú ka꞉pi huhutapame daya dlomdepo. Yia꞉ epo yia꞉ toto koko opi dolumama, yia꞉ kapo epo yia꞉ eto epo yia꞉ disi mape woloma howahalomdepo. ");
INSERT INTO xla_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Epedeme Pa꞉lisi so mate aiyalma imalalo so mate Yesu watle epo atlaiyo, “Wa꞉ alotle tlalo sota di toto koko podolumalalo wekemama yia꞉ doye woloma pohowahalomalalo daya dlompopa꞉ye adipalati amma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ wuskamu pepemalalo sopo. God tle yu hapame molo atlalo oplami Aisayata wua꞉ koko dla ikadepe koko ipo atluwapo, ‘Opa iwolotapo isikimi mati tle na꞉ dla siyele ta꞉demdepo. Amasiyama yia꞉ dupa dulu dla na꞉ malamaleye hawa ikadepe. ");
INSERT INTO xla_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Epedeme yia꞉ta na꞉ dla heodepame na꞉ hi di dla ta꞉demha꞉ha꞉ye dulu koko pa꞉na. Adipalati, yia꞉tapo opata imale aiyalmaye na꞉ta imale tepo depame ma opa watle imsiyamapo.’” ");
INSERT INTO xla_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yesu ma yia꞉ watle epo atlaiyo, “Wua꞉ye Godta imale aiyalma dla dolumsiyamuwaye memelepame ma opata aiyalma imale dolumsiyamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu me-yukamhalemama epo atlaiyo, “Wua꞉ Godta aiyalma hatitimaleye wua꞉ta woloma ma alikili dla himina, ma wua꞉ toto koko dolumolowedeme. ");
INSERT INTO xla_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Epedeme Mosesta aiyalma hatitimaleta epo atlapo, ‘Wa꞉ a mate wa꞉ wai mate yia꞉ yu dla heodepo salladepo siyamaiya. Amasiyama antapo ya꞉ a mate ya꞉ wai mate dla putlomale yu atlepiye, ya꞉ye yumuluwe ka꞉pi.’ ");
INSERT INTO xla_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Epedeme oplamitapo God watle namkale dle alisisi hamilowedeme yu himimdepo. Epame alotle ma ya꞉ a mate ya꞉ wai mate alisisi pa꞉lati yia꞉ gadlowedeme solotamdepo. ");
INSERT INTO xla_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Amasiyama aiyalma imalalo so, wua꞉tapo ya꞉ watle epo atlemdepo, ‘Wa꞉ a mate wa꞉ wai mate matle gadlowe poka꞉dena. Adipalati, wa꞉ yu me-himiwapo, wa꞉ alisisi God watle hapilowedeme,’ demdepo. ");
INSERT INTO xla_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Epedeme ipapele koko tle wua꞉ta aiyalma opa dla imsiyamama Godta aiyalma imaleye ma-hamastauwapo. Epame wua꞉ koko opi hapuloma ipapele ma halomsiyamapo.” ");
INSERT INTO xla_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuta opa hapuloma sisilapame yia꞉ watle epo atlaiyo, “Wua꞉ta hapuloma na꞉ yu dalepame malamale haiya. ");
INSERT INTO xla_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Epedeme wua꞉ natiya, oplamitapo dlowe alisisi demdeta ya꞉ dupa duluye pobatalimasemde. Amasiyama oplami ya꞉ dupa dulu tle malamale batalimale woyamdeta ya꞉ dupa duluye batalimdepo. Epedeme molo walle oplamita yu i dallepe.” ");
INSERT INTO xla_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu opa saliyome aya dulu dla hetlati ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Wa꞉ di watle wa꞉ta wayu esemale ya꞉ dulu kokoye imane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Epalati Yesu ma yia꞉ watle epo atlaiyo, “Wua꞉ mape yu i dulu kokoye ala me-yeitampopa꞉pa? Epedeme wua꞉ natiya, wua꞉ta dlowe alisisi hame dlomdeta wua꞉ dupa duluye pobatalimasemde. ");
INSERT INTO xla_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Adipalati, dlowe alisisiye isikimi koko dulu dla tulupame ma alikili dla ulatamdepo.” Epapedeme Yesuta koko i atlemama dlowe alisisi hapulomaye me-dlowe ka꞉pi diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu ma epo atlaiyo, “Oplami dupa dulu tle batalimale koko woyamdeta ya꞉ye batalimdepo. ");
INSERT INTO xla_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Epedeme oplami dupa dulu tle ipapele kokota wowoyamdepo, eye batalimale koko malamolowe, epo opa mate wola꞉ mate uhalomolowe, epo upo alisisi uhalowe, epo ya꞉mkale yumuluwe, epo ya꞉mkale ya꞉llu mate ya꞉mkale ya꞉wolali mate uhalowe, ");
INSERT INTO xla_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","epo alisisi sikemte halomolowe malamale, epo poka꞉ka꞉dle koko halomolowe, epo ya꞉mkale mala-atlowe, epo opa inoma dali dla wota꞉le koko halowe, epo ya꞉mkale ellewe, epo ya꞉mkale hi mate putlopo atlowe, epo ya꞉skamu di dla hamhetlowe, epo dokopala pa꞉msiyamolowe. ");
INSERT INTO xla_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Epedeme batalimale koko hapuloma ita oplami dupa dulu tle woyapame oplamiye batalimdepo.” ");
INSERT INTO xla_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesutapo sila꞉time mo e saliyome Taya mo mate epo Saidon mo mate dla tame woyamaiyo. Ya꞉ posolotamaiyo, ya꞉ta mo edla tame woyapame aya hale dla pollati opata puame ya꞉ natiloweye. Amasiyama epapele tlope ya꞉tapo ya꞉skamu opata ya꞉ natilala depame hemele haodloweye api ponatiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Epalati po-Yu a꞉ya hale Ponesiya Siliya mo dla hallalota Yesu koko dalepame ya꞉ hala dla puaiyo. Ya꞉ puame Yesu hete sitali dla teyume elemama epo atlaiyo, “Na꞉ amseyemalaye bataliya walena. Epedeme wa꞉ puame na꞉ amseyemala dulu dla bataliya halaye alikili a꞉ma dodolomane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu ya꞉ yu dalepame wayu mate epo atlaiyo, “Yimlala dayaye hapo esemala watle ilimolowe poka꞉dena. Yimlala tatle daya ilimolowe ka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","A꞉ya asiyama Yesu yu dla epo atlaiyo, “Yao Lod, wa꞉ ikadepe atlapo. Amasiyama esemalatapo ta꞉la dla siyamama yimlalata daya dele akutuye dlomsiyamdepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Epalati Yesuta asiyama ya꞉ watle epo atlaiyo, “Wa꞉ta asiyama yu ka꞉dle na꞉ watle hamilipo. Epedeme wa꞉ tame aya dla wa꞉ amseyemala natine, ma-ka꞉depo polapo. Bataliyaye wata ya꞉ dulu dla ma-hawa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Epalati ya꞉ tame yoti natilati bataliyata ya꞉ dulu dla ma-hawa hallati ma-ka꞉depo polaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu matle Taya mo saliyome Saidon mo tle tame Dekapolis mo dla woyapo ma Ga꞉lili kaula dla tuluiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yesu Ga꞉lili mo dla tame woyamalati opa opita oplami yu pa꞉mama molo mate pa꞉leye ya꞉ hala dla hamampuaiyo. Yia꞉ puame epo atlaiyo, “Wa꞉ dota oplami i hamame inoma sumane, ya꞉ta ka꞉dlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Epalati Yesuta oplami iye hamame alumale dulu tle alikili dla pameliyo. Yesu epo halemama oplami ya꞉ molo opokoko dla domokota kekesopame mitikape do dla tupodepame ya꞉ te dla umaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu pepele di dla omhalemama inoma supo hedemama ya꞉ watle ya꞉ yu mate epo atlaiyo, “Epata,” diyo. Yu i ya꞉ dulu kokoye mo-gowalagowaladiya demama apopo. ");
INSERT INTO xla_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Oloma edla oplami ya꞉ molota ma-ka꞉depo daliyo. Epo ya꞉ teta ma-ka꞉depo yukamolowe kotiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Epame Yesuta opa hapuloma watle yu itiyamale mate epo atlaiyo, “Wua꞉ oplami ita ka꞉dle kokoye opa opi watle atlamiyo,” diyo. Amasiyama ya꞉ta yia꞉ watle sikemte atlemama, “Ya꞉ kokoye opa opi dla atlemiyo,” dleye, ma opata yu e podallalo ma sikemte opa opi watle me-atlamsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Epedeme opa hapulomatapo koko hema dlalepame sikemte yiyelepame epo atlamyaiyo, “Yesu koko hapuloma woloma ka꞉depo halomsela꞉po. Ya꞉ molo pa꞉talo so mate yu pa꞉talo so mate ka꞉ka꞉demsela꞉mdepo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Alila haleta opa hapuloma ma Yesu hala dla alupame ya꞉ mate siyamaiyo. Edla siyamama Yesuta opata daya dimi popa꞉le natipame ya꞉ alotle tlalo so sisilapame yia꞉ watle epo atlaiyo, “Opa alumale iwoloye na꞉ mate alila dapahatlope siyamuwapo. Epame ma yia꞉ta daya dimi popa꞉lati natipame yia꞉ sikemte bokotiyama. ");
INSERT INTO xla_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na꞉ yia꞉ daya po-ilimalalo ma-taiya dlowe tlope, yia꞉ api duka dla tamalemama daya yilo hopeyalimelepe. Adipalati, opa opi yia꞉ mo pateka꞉pi,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesu ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Dlowe pa꞉le mo hema dita hadima tame dlowe hapo opa pasatale iwolo adipo ilipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Epalati Yesuta ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ dla daya adisowata hutiyema꞉?” diyo. Epapalati yia꞉ta asiyama epo atlaiyo, “Isikimi daya mo-halomale 7 tlo me-hutiyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Epalati Yesuta opa hapulomaye ta꞉la dla popa꞉iya depame daya 7 halopo siyele yu God dla hamiyo. Epo daya hauwokokopo ya꞉ alotle tlalo so watle hapiyo, ma yia꞉ta opa watle alemelepo depame. ");
INSERT INTO xla_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Epame yia꞉ dulu dla amalo yimlala ma me-hutiyeiyo. Epalati Yesuta amalo yimlala e halopame siyele yu God watle hamiyo. Epame ya꞉ alotle tlalo so watle hapiyo, ma yia꞉ta opa watle alemelepo depame. ");
INSERT INTO xla_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Opa hapulomata daya dlopo sikemte susukaliyo. Epalati ya꞉ alotle tlalo sota daya akutu ipi popomelleye yekalo 7 dla atilimama sikemte poposatilimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yia꞉ta daya dele alotle opa siyapo sesa꞉mama 4,000 umaiyo. Epo alotle Yesuta opaye ma i-ilapo yia꞉ aya dla taiya diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ya꞉ opa hapuloma ma-taiya depame ya꞉ alotle tlalo so mate koa dulu dla tulume alupame Dalmanuta mo dla uliyo. ");
INSERT INTO xla_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yia꞉ tame Dalmanuta mo dla woyamalati Pa꞉lisi sota puame Yesu mate yu dlomaiyo. Adipalati, yia꞉ solotamaiyo, Yesuta itiyamaleye ikadepe God tle puma꞉ depo natilowedeme. Epammama yia꞉ta Yesu watle “ulugiyemale koko hane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Epalati Yesuta yia꞉ta mikadepe dle pa꞉le natipame alimama yia꞉ watle epo atlaiyo, “Wua꞉ adipalati ulugiyemale koko natilowe tlo sikemte solotama꞉? Wua꞉ adipapele ulugiyemale koko natipo Godta itiyamale dla mikadepe dlowama꞉? Epedeme na꞉ wua꞉ dla ikadepe koko atlema. Na꞉ wua꞉ta natilipo depame ulugiyemale koko hale pohalowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesu yu i atlepame ya꞉ alotle tlalo so mate koa dulu dla tulume alupo ma kaula seme dla uliyo. ");
INSERT INTO xla_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yia꞉ kaula seme dla ulumama Yesu ya꞉ alotle tlalo sota daya pato halowe welimama isikimi yimka꞉mala tlo hame tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Epalati Yesuta yia꞉ watle molo atlemama epo atlaiyo, “Ka꞉e wolomape! Pa꞉lisi so mate epo Helod mate yia꞉ta imale kokoye daya haka꞉le sepena. Adipalati, daya amko ka꞉dleye daya haka꞉le mate dukumelepiye, daya amko ka꞉dleye batalimelepe.” ");
INSERT INTO xla_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Amasiyama Yesu ya꞉ alotle tlalo sota koko i dalepame yiskamu yia꞉ dulu dla esempopa꞉mama epo atlamyaiyo, “Dita daya pohampulalo wekele koko tle Yesutapo di natipo yu epo atlapo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Epapalati Yesuta yia꞉ta momalampopa꞉leye ma-natipame yia꞉ watle epo atlaiyo, “Wua꞉ adipapalati wua꞉ta daya pohampulalo wekele koko dla sikemte momalampopa꞉ma꞉? Epame wua꞉ na꞉ta itiyamale dla ala pomikadepe dlalo ha꞉ha꞉mama dupa kokalalipo ha꞉ha꞉pa? ");
INSERT INTO xla_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Wua꞉ inoma watalo sopo, amasiyama wua꞉ inoma eta potlamasemde. Epame wua꞉ molo watalo sopo, amasiyama wua꞉ molo eta podlalesemde. Epedeme wua꞉ na꞉ta 5,000 opa daya do supulastale mate hauwokokopo ilimuwaye mo-woweluwapa? Epame yia꞉ta daya dlopo popomellati wua꞉ yekalo adisowa dla daya akutu popomelle atilimuwa?” Epalati ya꞉ alotle tlalo sota ya꞉ watle epo atlaiyo, “Yekalo 12 dla atilimuwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu matle yia꞉ watle epo atlaiyo, “Epame 4,000 opaye na꞉ta daya 7 mate hauwokokopo ilimalati wua꞉ yekalo adisowa dla daya akutu popomelle atilimuwa?” diyo. Epalati yia꞉ta asiyama epo atlaiyo, “Yekalo 7 dla atilimuwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Epalati Yesuta yia꞉ watle epo atlaiyo, “Amasiyama wua꞉ koko e tlapame ma na꞉ta itiyamale dla ala pomikadepe dlalo ha꞉ha꞉pa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu mate ya꞉ alotle tlalo so mate ma Betsaida mo dla uliyo. Yia꞉ edla tame woyamalati opata inoma pa꞉le oplami Yesu watle hamampuame epo atlaiyo, “Wa꞉ dota oplami i hamame inoma sumane, ya꞉ta ka꞉dlepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Epalati Yesuta oplami iye hamame opa dulu tle alikili dla pameliyo. Yesu epo halemama ya꞉ inoma dla mitikape tupodepame dota ya꞉ inoma u-umapo halemama epo atlaiyo, “Wa꞉ wata me-natima꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Epalati oplamita alikili dla tlapame epo atlaiyo, “Yao, na꞉ wata me-natima. Amasiyama opa siyama tlo woloma pomalanatisema, isikimi dali some siyama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Epalati Yesu matle oplami inoma dla ya꞉ dota umamaiyo. Oloma edla oplamita ya꞉ inoma sikemte towanatipame alisisi woloma ka꞉pi tlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu oplami i ka꞉depame ya꞉ aya dla tane demama epo atlaiyo, “Wa꞉ koko iye opa opi watle atlamiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu matle ya꞉ alotle tlalo so mate Kasaliya Pilipi mo yimlala dla sela꞉mama ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ na꞉ atlaiya, opata na꞉ye ana demdi?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Epalati yia꞉ta asiyama ya꞉ watle epo atlaiyo, “Opa opita wa꞉ye Yon opa yú dla ka꞉ka꞉timalalo demdepo. Epalati ma opita wa꞉ye Ilaya mle demdepo. Epalati ma opita wa꞉ye God tle yu hapame molo atlalo so ka꞉yapa ha꞉ha꞉uwa oplami hale mle demdepo.” ");
INSERT INTO xla_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Amasiyama wua꞉ta na꞉ye ana demdi?” diyo. Epalati Pitata Yesu watle epo atlaiyo, “Wa꞉ye Godta sale oplami Kelisopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Epalati Yesuta yia꞉ watle epo atlaiyo, “Opa opi watle atlemama na꞉ye Kelisopo demiyo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesutapo ya꞉ alotle tlalo so watle ya꞉ta polowe kokoye imolowe kotiyamama epo atlaiyo, “Opa Yamiye sikemte wotiyalle natilipe. Epapele dulu dla Yu so dokopala so mate epo aiyalma aya dokopala so mate epo aiyalma imalalo so mateta ya꞉ dla sikemte elle pato himilipe. Epame opata ya꞉ye yumilipe. Amasiyama ya꞉tapo wabasi dulu dla powame elepame ma dapahatlope alila dla sila꞉tilipe.” ");
INSERT INTO xla_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesuta ya꞉ koko iye ya꞉ alotle tlalo so watle haliyamale dla botomastepo atlaiyo. Epalati Pitata koko i dalla alimama Yesu hamame alikili dla woyapo halemama ya꞉ watle “epo atlemiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amasiyama Yesutapo ya꞉ alotle tlalo so watle omhalemama Pita watle epo atlaiyo, “Saiten, na꞉ tle alikili a꞉ma tane. Adipalati, wa꞉ta yu atlaleye God tle popuasema. Amasiyama opata malamale tle puapo.” ");
INSERT INTO xla_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuta opa hapuloma mate ya꞉ alotle tlalo so mate sisilapame yia꞉ watle epo atlaiyo, “Oplami antapo na꞉ dolumpuluwe solotamelepiye, ya꞉ ya꞉skamu ya꞉ta solotamale koko hamsela꞉ye memelepame ya꞉ dali yekelemhimiliye maka꞉himsela꞉mama na꞉ dolumpulupe. ");
INSERT INTO xla_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amasiyama oplami antapo ya꞉ pasakaloye meyelo gadlowedeme apelepiye, ya꞉ pasakaloye haodlepe. Amasiyama oplami antapo na꞉ yilo epame ka꞉dle yu yilo ya꞉ pasakaloye haodlepiye, ya꞉ matle kokó halepo halepo pasakalo halepe. ");
INSERT INTO xla_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amasiyama oplami antapo ta꞉lamo pato hema halemama ya꞉ta solotamale koko hapulomaye mo-halopame hatlo pasakalo hallowe koko tlo hotlepiye, ya꞉ ma apa koko hapa꞉? Hawa. ");
INSERT INTO xla_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Adipalati, ya꞉ta alisisi hapuloma ta꞉lamo hema halopo halale e mate kokó halepo halepo pasakalo pohalowa. ");
INSERT INTO xla_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Epedeme wata oloma hema batalimale alila dla ha꞉ha꞉mama opata God mo-wowelipo. Amasiyama opa anawolota dulu edla ha꞉ha꞉mama na꞉ mate epo na꞉ta imale mate dla wowota꞉mha꞉ha꞉lepiye, asiyama Opa Yamita ya꞉ Ata hela꞉dle mate epo ya꞉ banakaka so mate puame ya꞉ dla wota꞉le hamilipe.” ");
INSERT INTO xla_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ma epo atlaiyo, “Epedeme na꞉ mikadepe koko wua꞉ watle atlema. Wua꞉ dulu dla opa opi me-ha꞉ha꞉po. Yia꞉tapo God ya꞉ mo kokota itiyamale mate pulati natipame alotle pallipe.” ");
INSERT INTO xla_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Epame 6 alila mogudlati alotle Yesuta Pita mate epo Yeims mate epo Yon mate eleme tamali di dla miyelo ha꞉ha꞉la hetaiyo. Yia꞉ edla hetame popa꞉mama natilati Yesuta ya꞉ Pepele dimo mila꞉pi himhalla natiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Epalati ya꞉ tlukata sikemte kamama wapoko some halemama sikemte usiyemaiyo. Epedeme ta꞉lamo oplami haleta ya꞉ tluka howahamama ipo kamoloweye api hawa. ");
INSERT INTO xla_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yia꞉ edla me-ompopa꞉mama natilati Moses mate epo Ilaya mate wowoyapo Yesu mate yuhamha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Epalati natipame wowota꞉mama Pitatapo woloma pomalamalalo Yesu watle epo atlaiyo, “Dokopala oplami, di mo hema ha꞉ha꞉lowe ka꞉pi. Epedeme di kimna꞉ya dapahatlope kimtimolowepo. Kimna꞉ya haleye wolëpo, epame haleye Moses tete, epame haleye Ilaya tete dlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Amasiyama Pitata ala me-yukamhallati wualata puame yia꞉ye bopudiyo. Epalati yuta wuala dulu tle epo atlaiyo, “Iye na꞉ta sikemte malamama dupa ellalo maseyemalapo. Epedeme ya꞉ yu dla daliya,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Epalati Pita wolota yu i dalepame alikili tlamaiyo. Amasiyama yia꞉ oplami hale ponatiyo. Isikimi Yesuta meyelo yia꞉ mate halla natiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Epame yia꞉ tamali di tle malemha꞉ha꞉mama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ta tlamale kokoye opa opi watle atlamiyo. Amasiyama Opa Yamita popo sila꞉time me-hetlati alotle opa opi dla atlamsiyamaiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Epalati Pita wolota Yesu yu dalepame woloma haiyo. Epame yia꞉ dulu dla powale tle sila꞉tilowe koko tlo esemama ya꞉ dulu kokoye woloma totamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Matle Pita wolota Yesu watle epo atlanatiyo, “Adipalati aiyalma imalalo sota imama ‘Ilayata itapu pulati Kelisota alotle pulupe’ demdi?” ");
INSERT INTO xla_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Ikadepe, Ilaya tatle puame koko hapulomaye ma woloma ka꞉depo dinapelepe. Ame adipalati God yu bukata atlemama ‘Opa Yamiye opata elle pato himimama wotiyalle pato hamilipe’ demdi? ");
INSERT INTO xla_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amasiyama na꞉ wua꞉ watle atlema, Ilayaye mo-puwapo. Epalati opata God yu bukata atla mate ala꞉mama ya꞉ watle wotiyalle koko ma-hapiwapo.” ");
INSERT INTO xla_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuta ya꞉ alotle tlalo so dapahatlopeye tamali di tle eleme malame halemama natilati ya꞉ alotle tlalo so opita aiyalma imalalo so mate yu dlomha꞉ha꞉la natiyo. Epalati opa hapulomata puame edla alupo ha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Epo alupo ha꞉ha꞉mama Yesu natipo yiyelepame sisiyele mate Yesu hala dla ullumtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ta yu dlomha꞉ha꞉leye apa koko dla api?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Epalati alumale dulu edla oplami haleta epo atlaiyo, “Imalalo oplami, na꞉ maseyemala yu pa꞉leye wa꞉ watle hamampua. Adipalati, ya꞉ye bataliya walena. ");
INSERT INTO xla_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Epedeme bataliyata ya꞉ dla hetlati teyume kikiyamtame elemama a꞉pe tetekelle mate mitikape totowa꞉leme elemde. Epeleye na꞉ta wa꞉ alotle tlalo so watle ‘bataliya iye alikili dla dodolomaiya,’ dlati yia꞉ta pododolomana.” ");
INSERT INTO xla_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Epalati Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ye mikadepe dle pa꞉le bobtalimale sopo. Wua꞉ta na꞉ dla mikadepe dlepo depame na꞉ alila adisowaye wua꞉ mate halepa꞉? Amasiyama maseyemala eye na꞉ watle hamampuaiya.” ");
INSERT INTO xla_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Epalati opatapo maseyemalaye Yesu hala dla hamampulati bataliyata Yesu natipame maseyemala watle eseselalle hamiyo. Epalati maseyemalata ta꞉la dla teyume duduplumelemama mitikape totowa꞉lemelaiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Epalati Yesuta maseyemala ya꞉ a watle epo atlaiyo, “Maseyemala iye adipalalo koko i kotiyamuwa?” diyo. Amasiyama ya꞉ ata Yesu watle epo atlaiyo, “Ya꞉ ala yimka꞉mala halemama koko iye kotiyamuwa. ");
INSERT INTO xla_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Epedeme bataliyata maseyemala i yumuluwedeme dlapa dulu dla epo yú dulu dla ka꞉ka꞉timhalemde. Epedeme wa꞉ dla ala꞉lepiye, dia꞉ye polowamama na꞉ maseyemala i ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ adipalati na꞉ watle atlemama ‘wa꞉ dla ala꞉lepiye’ dema꞉? Amasiyama anta God dla mikadepe dlepiye, koko hapuloma ya꞉ dla pokokalena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maseyemala ya꞉ ata Yesu yu dalepame yu teta꞉le mate epo atlaiyo, “Na꞉ God dla mikadepe dema, epedeme na꞉ta mikadepe dle yimka꞉malaye ma pato depo melene,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Opata Yesu hala dla puame ala me-alumyelati Yesuta bataliya watle epo atlaiyo, “Wa꞉ opa dla molo mate yu mate pa꞉le hapilalo soko, na꞉ wata yu itiyamale mate wa꞉ dla atlema. Maseyemala ya꞉ tle alikili dla ulatane. Epame matle ya꞉ dla potuluwa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Epalati bataliyata maseyemalaye ta꞉la dla hamastapame hiyelle mate alikili dla ulataiyo. Maseyemala ta꞉la dla teyume elemama powale some elaiyo. Epalati opa hapulomata epo atlamyaiyo, “Maseyemala iye mo-powame elayo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amasiyama Yesuta maseyemalaye do dla hamame sila꞉time pameliyo. ");
INSERT INTO xla_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Epame Yesuta ma aya dulu dla hetlati ya꞉ alotle tlalo sota miyelo ya꞉ mate popa꞉mama ya꞉ watle epo atlaiyo, “Di adipalati bataliyaye maseyemala tle alikili dla dodolomolowe dla itiyamale hawa halo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Bataliya yimlala ipapeleye isikimi daya aiyalma depo halemama inoma sumhalale koko tle alikili dla dodolomlala,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu matle ya꞉ alotle tlalo so mate mo e meleme Ga꞉lili mo dulu tle tamalaiyo. Amasiyama ya꞉ posolotamaiyo, oplami haleta ya꞉ta hala natilowe. ");
INSERT INTO xla_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Adipalati, ya꞉ isikimi ya꞉ alotle tlalo so tlo imsela꞉mama yia꞉ watle epo atlaiyo, “Opa Yamiye opa do tama dla homellepe. Epalati yia꞉tapo ya꞉ye yumilipe. Amasiyama ya꞉ye powame elepame ma dapahatlope alila dla ma pasakalo depame sila꞉tilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Epalati ya꞉ alotle tlalo sota yu i dulu kokoye woloma pomalamalalo wekemama ya꞉ watle atlanatiloweye wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesuta ya꞉ alotle tlalo so mate Kapaniyem dla mo-puaiyo. Yia꞉ puame aya dulu dla hetame popa꞉mama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ api duka dla pumulumama apa koko balempumulo?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amasiyama ya꞉ alotle tlalo sota ya꞉ yu dalepo titiyalepo popa꞉iyo. Adipalati, yia꞉ dulu dla anta pato halema꞉ dle kokoye api duka dla pumulumama balempumulaiyo. ");
INSERT INTO xla_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Epalati Yesuta yia꞉ sisilapo polomama yia꞉ watle epo atlaiyo, “Epedeme anta pato hallowe solotamelepiye, ya꞉ ya꞉skamu ya꞉ye alo dla himpame ya꞉ motoye yimkadulo gadlowe dla himilipe.” ");
INSERT INTO xla_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesu epame maseyemala hamame duka dla pamelepo matle ya꞉ mulu dla pamelemama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oplami antapo maseyemala ipapeleye na꞉ hi tle ya꞉ aya dla seme hetlepiye, ya꞉ na꞉ye seme hetamama apelepe. Epame oplami antapo na꞉ye ya꞉ aya dla seme hetlepiye, ya꞉tapo na꞉ a na꞉ tane duwaye seme hetamama apelepe.” ");
INSERT INTO xla_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Epalati Yonta Yesu watle epo atlaiyo, “Imalalo oplami, di oplami hale wa꞉ hi mate bataliya yimlalaye alikili dla dodolomsalemhalla natiwa. Epalati dita ya꞉ye humatluwa. Adipalati, ya꞉ di alumale dulu dla pohalasemde,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Amasiyama Yesuta epo atlaiyo, “Ya꞉ humatlemiya. Adipalati, anta na꞉ hi mate ulugiyemale koko halepiye, ya꞉ na꞉ hi dla poputlopo atlasema. ");
INSERT INTO xla_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Epedeme anta dia꞉ dla po-opahale dlalo halema꞉, ya꞉ye diamkalepo. ");
INSERT INTO xla_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na꞉ wua꞉ watle mikadepe koko atlema. Oplami antapo Keliso dolumalalo oplamita yú ta꞉mpollati yú tipo hamilipiye, ya꞉ koko edla asiyama halepe.” ");
INSERT INTO xla_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Epedeme na꞉ dla mikadepe dlalo maseyemala yimka꞉malaye oplami antapo seme batalimale koko dla tullupiye, ka꞉dena, oplami eye ewala patota tumuku dla himomeleme ewatalo dla hamastloweye. ");
INSERT INTO xla_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Epame wa꞉ do aditapo wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, do seme eye geda꞉dloweye. Ame adipalati, ka꞉dlepo, wa꞉ta do hatlope mate siyele mo dla ulatuluweye. Amasiyama wa꞉ta do dapiyamte halemama Dlapa mo dla tloweye poka꞉dena. Adipalati, Dlapa mo edla dlapata posumtasemde. ");
INSERT INTO xla_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO xla_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Epame wa꞉ hete aditapo wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, hete seme eye geda꞉dloweye. Ame adipalati, ka꞉dlepo, wa꞉ta hete hatlope mate siyele mo dla ulatuluweye. Amasiyama wa꞉ta hete dapiyamte halemama Dlapa mo dla tloweye poka꞉dena. ");
INSERT INTO xla_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO xla_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Epame wa꞉ inoma aditapo wa꞉ye batalimale dla hamame tullupiye, ka꞉dena, inoma seme eye holamastloweye. Ame adipalati, ka꞉dlepo, wa꞉ta inoma seme tiyape mate God ya꞉ mo dla ulatuluweye. Amasiyama wa꞉ta inoma dapiyamte halemama Dlapa mo dla tloweye poka꞉dena. ");
INSERT INTO xla_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Adipalati, ‘Dlapa mo edla wokakata popalisemde, epame dlapa ma posumtasemde.’ ");
INSERT INTO xla_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Opa hapulomaye solota dlapa some dusukopo hamastlepe. ");
INSERT INTO xla_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Epedeme soloye ka꞉pi alisisipo. Amasiyama solota ya꞉ta opalli pa꞉lepiye, ma adipo ya꞉ta opalli hapa꞉? Pohalowa. Epame dimalamana, solotapo dlowe alisisi dla opalli hamimdepo. Epedeme wua꞉ mape solo some ha꞉ha꞉mama yimkadulo sadle mate ka꞉pi ha꞉ha꞉iya.” ");
INSERT INTO xla_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu Ga꞉lili mo saliyome Yudiya dla tamama Yoden aloma ulumtaiyo. Ya꞉ edla tlati opa hapulomatapo ya꞉ dolumtamalaiyo. Epalati yia꞉ watle ya꞉ta imalalo epo imaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Epalati Pa꞉lisi so opita puame Yesu dla batalimale koko natilowedeme ya꞉ watle epo atlaiyo, “Oplamita ya꞉llu melloweye aiyalma elema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu asiyama yia꞉ watle epo atlaiyo, “Koko hema Mosesta wua꞉ watle apa aiyalma imuwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Epalati yia꞉ta epo atlaiyo, “Mosesta di watle imama ‘a꞉ya memellowedeme isikimi a꞉ya mellalo pepa tlo ilipo, a꞉yaye ma-tane de demha꞉ha꞉iye,’ duwa.” ");
INSERT INTO xla_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu matle yia꞉ watle epo atlaiyo, “Mosesta wua꞉ dupa kokalalimale tlapame wua꞉ watle aiyalma ipo imuwapo. ");
INSERT INTO xla_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amasiyama Godta ta꞉lamo mita꞉ple oloma edla ‘ya꞉ oplami mate a꞉ya mate mimita꞉puwapo. ");
INSERT INTO xla_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Epedeme oplamitapo ya꞉ a mate ya꞉ wai mate melepame ma ya꞉llu mate hatlope depo hallepe. ");
INSERT INTO xla_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Epame yia꞉ta madipatatapo moto hatlope depo ha꞉ha꞉lepe.’ Epedeme yia꞉ta ha꞉ha꞉le dulu dla yia꞉ podapiyamte, amasiyama yia꞉ ma hatlopepo. ");
INSERT INTO xla_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Epapedeme Godta yia꞉ta dapiyamte ma-hatlope dleye ma oplami haleta poduka gladlowa.” ");
INSERT INTO xla_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Alotle Yesu ya꞉ alotle tlalo sota aya dulu dla popa꞉mama a꞉ya mellowe kokoye mamisika꞉ Yesu watle atlanatiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Oplami antapo ya꞉llu memelepame matle a꞉ya hale halepiye, ya꞉ a꞉ya eye uhapo. Epammama ya꞉tapo ya꞉llu takala dla batalimale koko hamipo. ");
INSERT INTO xla_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Epame ma a꞉ya haleta ya꞉wolali memelepame ma oplami hale halepiye, ya꞉ mape oplami eye uhapo.” ");
INSERT INTO xla_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Opa opitapo yia꞉ yimlala eleme Yesu hala dla hohopo pumulaiyo, Yesutapo yia꞉ye ya꞉ do mate u-umamelepo depame. Amasiyama ya꞉ alotle tlalo sota koko e natipame yia꞉ye humatlaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Epalati Yesuta yia꞉ watle siyaladle mate epo atlaiyo, “Yimlalaye na꞉ hala dla pumula diya, yia꞉ humatlemiya. Adipalati, epapele sota God ya꞉ mo koko dla u-ulapo tulupe. ");
INSERT INTO xla_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Epedeme na꞉ mikadepe koko wua꞉ watle atlema. Oplami antapo yimlala ipapele some God ya꞉ mo kokoye pohalalo wekelepiye, ya꞉ mo edla po-ulatuluwa.” ");
INSERT INTO xla_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Epame Yesuta yimlalaye mulu dla ipila꞉po ya꞉ dota yia꞉ hohopo polomama inoma supo yia꞉ watle siyele hamiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu mo e saliyome tlowedeme hallati oplami haleta kukulumpuame ya꞉ hete sitali dla alumata kellepo polomama ya꞉ watle epo atlaiyo, “Ka꞉depo imalalo oplami, na꞉ apa koko hapo, halepo halepo pasakalo hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu asiyama ya꞉ watle epo atlaiyo, “Wa꞉ adipalati na꞉ watle ka꞉dle oplami dema꞉? Oplami haletapo ka꞉dle oplami pohalasema. Amasiyama hatlo God tlo ka꞉dle halapo. ");
INSERT INTO xla_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Epedeme wa꞉ di aiyalma kokoye mo-wa꞉malamana. Wa꞉ ya꞉mkale yumula aiyalma, epo wa꞉ upo a꞉ya uhala aiyalma, epo wa꞉ upo alisisi uhala aiyalma, epo wa꞉ amkale hi mate isikimi mala-atla aiyalma, epo wa꞉ ya꞉mkale elemale tle ya꞉ alisisi uhala aiyalma, amasiyama wa꞉ a mate wa꞉ wai mate yia꞉ yu dla salladepo sela꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Amasiyama oplamita Yesu watle epo atlaiyo, “Imalalo oplami, na꞉ta yimka꞉mala tle sila꞉tiwaye aiyalma koko hapuloma eye mo-dolumpuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Epalati Yesuta ya꞉ dla omhalemama ya꞉ bokotiyapo malamale mate ya꞉ watle epo atlaiyo, “Wa꞉ dla koko hatlo tlo hotepo halapo. Epedeme wa꞉ tame wa꞉ alisisi hapulomaye opa opi watle hapipame asiyama mani tlo hame puame atali so watle hapine. Epalati Pepele dimo dla alisisi pasataletapo wa꞉ hi mate ellepe. Epame wa꞉ ma na꞉ dolumpuane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Oplami koko i dalepame posiyelalo mila꞉pi sikemte upiyestame taiyo. Adipalati, ya꞉ye sikemte alisisi pasatepo halaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Epame Yesu oplamita ma-tlati omhalemama ya꞉ alotle tlalo so watle epo atlaiyo, “Alisisi pasatale sotapo God ya꞉ mo koko dla ulatuluweye pta kokalena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Amasiyama ya꞉ alotle tlalo sota yu i dalepame sikemte yiyeliyo. Epalati Yesu matle yia꞉ watle epo atlaiyo, “Namkadulo, God ya꞉ mo koko dla ulatuluweye pta kokalena. ");
INSERT INTO xla_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Epedeme ka꞉mol aliya patota tluka dedlemalalo tuwale opokoko tle ulatuluwe ka꞉deta꞉? Hao, po-ulatuluwa. Epedeme e ma epapena, alisisi pasatale sota God ya꞉ mo koko dla ulatuluweye pta kokalena.” ");
INSERT INTO xla_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Amasiyama ya꞉ alotle tlalo sota imale i dalepame sikemte yiyelepo epo atlamyaiyo, “Ame epo kokalleye anta ulatupa꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Epalati Yesuta yia꞉ watle omhalemama epo atlaiyo, “Oplamita meyelo ya꞉ pasakalo gadloweye po-ala꞉na. Amasiyama God tlo ala꞉na. Adipalati, ya꞉ta koko hapuloma halomoloweye pokokalena,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Epalati Pitata Yesu watle epo atlaiyo, “Dia꞉ye wa꞉ dolumpumama di alisisi hapulomaye medla pomelepo pumuluwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Na꞉ wua꞉ watle mikadepe koko atlema. Oplami antapo na꞉ dolumpumama ya꞉ aya mate epo ya꞉ bapadulo mate epo ya꞉ eidulo mate epo ya꞉ nanadulo mate epo yotumadulo mate epo ya꞉ a mate ya꞉ wai mate epo ya꞉ yimlala mate epo ya꞉ ta꞉la mate salepame na꞉ yu ka꞉dle yilo na꞉ dolumpulupiye, ya꞉tapo wata oloma hema asiyama pato halepe. Epame matle ta꞉lamo hema ya꞉ta aya mate epo asiyadulo mate epo ta꞉la mate poposatilipo hallepe. Epame ya꞉ta na꞉ yu yilo wotiyalle ma me-natimhalemama alotle halepo halepo pasakalo halepe. ");
INSERT INTO xla_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Epedeme itapu dla ha꞉ha꞉lalo so opita ma alo dla ha꞉ha꞉lepe. Asiyama alo dla ha꞉ha꞉lalo so opita ma itapu dla ha꞉ha꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuta ya꞉ alotle tlalo so eleme Yelusalem dla hetamama Yesu meyelo itapu taiyo. Epalati ya꞉ alotle tlalo sota ya꞉ ko tle tamalemama sikemte momalamtamalaiyo. Amasiyama opa opita ya꞉ ko tle dolumtamalemama sikemte wowota꞉mtamalaiyo. Epalati Yesu matle ya꞉ alotle tlalo so tlo hohopo alikili dla tame halemama Yelusalem dla koko woyamoloweye yia꞉ watle ipo atlamaiyo, ");
INSERT INTO xla_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ka꞉e! Di Yelusalem dla matamayo. Edla Opa Yamiye Yu so aiyalma aya dokopala so mate epo aiyalma imalalo so mate dla homellepe. Epalati yia꞉tapo ya꞉ koko gladepo ya꞉ta polowe kokoye atlepame ma po-Yu so watle homellepe. ");
INSERT INTO xla_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Epame po-Yu sota ya꞉ hampame ya꞉ dla tetlemyemama putlopo atlamyelepe. Epame ya꞉ watle mitikape tilitimyemama tuwale dea mate hopolepame yumilipe. Amasiyama ya꞉ye wabasi dulu dla powame elepame ma dapahatlope alila dla ma pasakalo depame sila꞉tilipe.” ");
INSERT INTO xla_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ya꞉ akimlala Yeims mate Yon mate Yesu watle puame epo atlaiyo, “Imalalo oplami, di wa꞉ watle dita solotamale koko hale atlowama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Epalati Yesu asiyama epo atlaiyo, “Wua꞉ apa kokoye na꞉ watle atlowe solotama꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Asiyama yia꞉ta epo atlaiyo, “Di solotama, wa꞉ mo kokota pulati dita dapiyamte dulu dla haleta wa꞉ dowala tiyama dla pola epame haleta wa꞉ weke tiyama dla pola dloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ wua꞉ta atla kokoye powua꞉malamana. Epedeme wua꞉ na꞉ta wotiyalle pato halowedeme halaye, wua꞉ ma mepapele halowe ka꞉deta꞉? Epame na꞉ta polowedeme halaye, wua꞉ ma halowe ka꞉deta꞉?” ");
INSERT INTO xla_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Epalati yia꞉ta asiyama epo atlaiyo, “Yao, di ka꞉dena, e haloweye,” diyo. Epalati Yesuta asiyama epo atlaiyo, “Ikadepe, wua꞉ mape na꞉ta wotiyalle halowedeme halaye e halepe. Epame na꞉ta polowedeme halaye, wua꞉ mape e halepe. ");
INSERT INTO xla_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amasiyama na꞉ dowala tiyama dla popa꞉lowe so mate epo na꞉ weke tiyama dla popa꞉lowe so mate sesalemoloweye na꞉ dla itiyamale hawa. Amasiyama isikimi na꞉ Ata ma-sesalemale so siyapotapo mo edla popa꞉lepe.” ");
INSERT INTO xla_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Epalati Yesu ya꞉ alotle tlalo so opita yu i dalepame Yeims mate Yon mate dla sikemte siyalasiyaladiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu koko i natipame yia꞉ sisilapo epo atlaiyo, “Po-Yu so dokopala sotapo yia꞉ isili tle ha꞉ha꞉lalo soye sikemte itiyamale mate omha꞉ha꞉mdepo. ");
INSERT INTO xla_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amasiyama wua꞉ dulu dla epapolowe poka꞉dena. Epedeme wua꞉ dulu dla anta pato hallowe solotamelepiye, ya꞉ ka꞉yapa wua꞉ yu dla salladepo sela꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Epame antapo itapu hallowe solotamelepiye, ya꞉ ka꞉yapa ya꞉skamu isili dla hamtulupame ya꞉ motoye yimkadulo gadlowe oko dla himilipe. ");
INSERT INTO xla_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Epedeme Opa Yamita ta꞉lamo hema puwaye, opata ya꞉ gadlepo depame popuana. Amasiyama ya꞉ta opaye gadlowedeme puwapo. Epo opata pasakalo halepo depame polowedeme puwapo.” ");
INSERT INTO xla_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","47","Yesu mate epo ya꞉ alotle tlalo so mate ma Yeliko mo dla puaiyo. Epame yia꞉ ma Yeliko mo ma-saliyome tamalemama opa hapulomata yia꞉ dolumtamalaiyo. Yia꞉ ma-tamha꞉ha꞉lati Timaes yami Batimayos inoma pa꞉le api duka dla otompollalota Yesuta pua koko daliyo. Ya꞉ Yesu Nasalet oplamita pua dalepame yu teta꞉le mate epo atlaiyo, “Yesu, Deibidi Yami, na꞉ polowamama na꞉ gadene,” dempolaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Epalati opa opita ya꞉ watle humatlemama epo atlamyaiyo, “Wa꞉ yu dimi polane,” demyaiyo. Amasiyama opata ya꞉ watle epo atlamyelati ya꞉tapo yia꞉ yu podallalo ma sikemte yu teta꞉le mate epo atlempolaiyo, “Deibidi Yami, wa꞉ na꞉ polowamama na꞉ gadene,” dempolaiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Epalati Yesuta hedepo halemama epo atlaiyo, “Oplami e hema pua diya,” diyo. Epame opata inoma pa꞉le oplami watle epo atlaiyo, “Ase sikemte malamiya. Wa꞉ sila꞉timtane. Yesu wa꞉ sisilamapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Epalati inoma pa꞉le oplamita hapele sila꞉time ya꞉ kapumale tlukaye ya꞉ta polale medla hamastapo Yesu hala dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ta wa꞉ watle apa koko halepo depo solotama꞉?” diyo. Epalati inoma pa꞉le oplamita asiyama epo atlaiyo, “Imalalo oplami, na꞉ inoma ka꞉dene. Na꞉ ma natilowe solotama,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Epalati Yesuta ya꞉ watle epo atlaiyo, “Wa꞉ ma-tane. Wa꞉ta mikadepe dleta wa꞉ye ma-ka꞉dlepo,” diyo. Epalati pakasiyamalalo inoma pa꞉le oplamitapo ya꞉ inomata ma-ka꞉dlati Yesu dolumtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesuta ya꞉ alotle tlalo so mate Yelusalem dla tamama Olipi tamali kikiwi isili dla mo yimlala Betapage mate epo Betani mate mateka꞉pi dla puame woyamaiyo. Yia꞉ edla puame ha꞉ha꞉mama Yesu ya꞉ alotle tlalo so dapiyamte taiya demama epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Wua꞉ mo yemala itapu pola huma taiya. Wua꞉ mo edla tame donki aliya amkota꞉le kikitama himomeleme halla natilipe. Ya꞉ye opata di dla ala popopa꞉lalo wekelalo. Epeleye wua꞉ta kikitama towastepo hema sempuaiye. ");
INSERT INTO xla_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Epapele dulu dla wua꞉ta epo sempulati oplami haleta wua꞉ watle atlemama, ‘Wua꞉ adipalati donki aliya kikitama towastepo semtama꞉?’ dlatiye, wua꞉ asiyama ya꞉ watle atlemama, ‘Lodta aliya i solotamuwo, epame ma alotle ilame semtaiya dloweyo,’ dlepe.” ");
INSERT INTO xla_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Epalati ya꞉ alotle tlalo so dapiyamteta mo edla tame natilati aliya eye aya hale alikili dla himomeleme hallati kikitama towastaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yia꞉ aliya kikitama towastamha꞉ha꞉lati opa opita puame yia꞉ watle epo atlaiyo, “Wua꞉ adipalati aliya kikitama towastamha꞉ha꞉ma꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Epalati ya꞉ alotle tlalo sota asiyama yu atlemama Yesuta ipo atlaiye dleye epo atlaiyo. Epalati opata aliyaye yia꞉ watle me-semtaiya diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yia꞉ aliya seme puame Yesu hala dla woyamaiyo. Epame yia꞉ kapumale tluka uptipame donki aliya dimsisi di dla kolumalati Yesutapo di dla hetame polaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Opa hapulomata Yesu watle sisiyemama yia꞉ kapumale tluka uptipo api dla yalemtlati opa opita usi kolepame Yesuta tlowe api dla yalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Epame Yesuta ma-tamhallati itapu dla tamha꞉ha꞉le so opa mate epo Yesu ko tle pumha꞉ha꞉le so matetapo yu teta꞉le mate epo atlamtamalaiyo, “God hi di dla ta꞉diya. Lod hi tle pua oplami dla sisiyeiya. ");
INSERT INTO xla_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Epedeme wua꞉ God ya꞉ mo koko dla sisiyeiya. Adipalati, ya꞉tapo di mama Deibidita omhaluwa mo koko epapeleye hampuapo. Di ikadepe dla hallalo God dla sisiyeiya,” demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Epame Yesu Yelusalem dla tame Yu so aiyalma aya dla hetame woloma tlamsela꞉iyo. Epo ma-apomtlati ya꞉ alotle tlalo so 12 eleme ma Betani mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yesu Betani dla elepo ma Yelusalem dla pumama daya ta꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ya꞉ daya ta꞉le mate pumama natilati pateka꞉mu dla pigi dlomoko dalita upa asipo halla natiyo. Epalati ya꞉ dlomoko tlo dlowedeme dlomoko mipo halema꞉ depo natila tuwaiyo. Amasiyama ya꞉ tame natilati dlomoko pomilalo upa tlo asipo halaiyo. Adipalati, oloma eye pigi dlomokota pomilimolowe alila. ");
INSERT INTO xla_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Epalati Yesuta pigi dlomoko dali dla epo atlaiyo, “Wa꞉ matle dlomoko pomimhallowa,” diyo. Yesuta epo atlati ya꞉ alotle tlalo so ma me-daliyo. ");
INSERT INTO xla_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu Yelusalem dla puame Yu so aiyalma aya dla hetaiyo. Ya꞉ hetame natilati opata alinepi mate alisisi opi mateye asiyama mate halomyela natiyo. Epela natipame alimama ya꞉tapo aya dulu dla hutiyele alisisi yia꞉ adulo mate epo alisisi e halomalalo so opa mate alikili dla dodolomsaliyo. Epo mani mila꞉pi meyelope meyelope dle omha꞉ha꞉lalo sota mani kolumalaloye dodokotipo pololiyo. Epame opata seselema tea halopo puame hatitimalalo mape dodokotimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yesu ma epo halemama opa watle epo atlaiyo, “Oplami haleta ma alisisi halopo pumama di aiyalma aya dulu itle olomasepele potuwa demha꞉ha꞉lowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Epammama opa watle ma ipo imaiyo, “God yu bukata epo atlapo, ‘Na꞉ aiyalma ayaye opa hapulomata inoma sumalalo aya demha꞉ha꞉lepe.’ Amasiyama epapele tlope wua꞉tapo God ya꞉ aya iye ma uhalalo aya dlepo.” ");
INSERT INTO xla_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Epalati aiyalma aya dokopala so mate epo aiyalma imalalo so mate yu i dalepame wowota꞉mama Yesu yumuluwe api totamaiyo. Adipalati, yia꞉ natiyo, opa hapulomata ya꞉ta imale koko dalepame woloma haiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Epame tamila꞉la edla Yesuta ya꞉ alotle tlalo so mate Yelusalem saliyomtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Alila hale utulala ikadepe yia꞉ ma Betani tle Yelusalem dla tamalemama natilati pigi dali Yesuta atlaleta mo-powame halla natiyo. Yia꞉ta dali i natili dla dlo tle tulume dlosalo hapuloma haleta pasakalo pohalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Epalati Pitata koko i natipame Yesuta atlale yu malamaiyo. Epammama Yesu watle epo atlaiyo, “Imalalo oplami, wa꞉ natine, dali tatla wa꞉ta isikimi yu mate atluwaye mo-powame halapiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Epalati Yesuta asiyama epo atlaiyo, “Wua꞉ God dla mikadepe diya. ");
INSERT INTO xla_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Oplami antapo tamali watle atlemama ‘wa꞉ dokalamtame kaula dla tulune’ demama ya꞉ dupa dulu dla malamale potatlamalalo wekemama ya꞉ta atla yu dla mikadepe dlepiye, Godta koko e halepe. ");
INSERT INTO xla_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Epedeme na꞉ wua꞉ watle atlema, wua꞉ God watle apa koko otomama koko eye mikadepe ma-hana dlepiye, wua꞉ koko eye ma-halepe. ");
INSERT INTO xla_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Epame wa꞉ inoma sumama apa batalimale wa꞉ amkaleta wa꞉ dla ma hauwa, wa꞉ batalimale eye wellipe. Epalati wa꞉ A God Pepele di dla halata asiyama wa꞉ batalimaleye hiyostepo wellipe. ");
INSERT INTO xla_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amasiyama wa꞉ta wa꞉ amkale batalimaleye powelilalo wekelepiye, asiyama wa꞉ A God Pepele di dla halata wa꞉ batalimale pohiyostepo welilowa.” ");
INSERT INTO xla_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Yia꞉ mo-puame Yelusalem dla woyapame Yesu aiyalma aya dla hetame sela꞉iyo. Ya꞉ edla hetame sela꞉lati aiyalma aya dokopala so mate epo aiyalma imalalo so mate epo Yu so dokopala so mateta ya꞉ watle puame epo atlaiyo, “Wa꞉ apa itiyamale tle koko i hamsela꞉ma꞉? Anta wa꞉ watle itiyamale i hamiwa?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Na꞉ mape wua꞉ watle atlanatili yu hatlo atlowama. Anta Yon watle itiyamale hamiwa, opa yú dla ka꞉ka꞉timelepo depame? Godta itiyamale hamiwa, o oplamita itiyamale hamiwa? Epedeme wua꞉ta asiyama yu na꞉ watle atlepiye, epalati na꞉ ma asiyama na꞉ta itiyamale hamsela꞉ iye wua꞉ watle atlowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Epalati yia꞉ta yu i dalepame yiskamu yia꞉ dulu dla esemyemama epo atlamyaiyo, “Di adipo atlepa꞉? Di Yonta itiyamaleye God tle puwa dlepiye, ma asiyama Yesuta di watle epo atellepe, ‘Ame wua꞉ adipalati Yon yu dla pomikadepe dlalo wekuwa?’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Epame di ma ya꞉ta itiyamaleye oplami tle puwa dlepiye, ma asiyama opata dia꞉ dla siyalasiyaladlepe. Adipalati, opa hapulomata Yonye God tle yu hapame molo atlalo oplami ikadepe demdepo.” ");
INSERT INTO xla_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Epedeme yia꞉ asiyama Yesu watle epo atlaiyo, “Di podimalamana, Yonta itiyamale halë sitaliye,” diyo. Epalati Yesuta asiyama yia꞉ watle epo atlaiyo, “Na꞉ ma asiyama wua꞉ watle na꞉ta itiyamale hamsela꞉ iye po-atlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu matle wayu mate yia꞉ watle epo atlaiyo, “Alila haleta oplami hale osalo himpame gla꞉pi dlomoko ale empo alikiliye kosukuliyo. Epo dlomoko dala okolloweye ta꞉la dla munamu muwalepame matle alisisi e ompollowe kimna꞉ya di dla haiyo. Ya꞉ epame opa opi watle omha꞉ha꞉iye depame ma mo hale pateka꞉mu dla halla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ya꞉ edla tame hallati dlomokota milipame namolowe alilata mo-puaiyo. Epalati ya꞉tapo ya꞉ oko oplami hale watle ya꞉ osalo dla tame dlomokoye halopo puane diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amasiyama ya꞉ edla tame woyamalati osalo omha꞉ha꞉lalo sota ya꞉ye hopolopame alisisi dimi ma ilame tane diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Epela natipame osalo ya꞉ ata ma ya꞉ oko oplami hale tane diyo. Amasiyama ya꞉ mape omha꞉ha꞉lalo sota ya꞉ye hopolemama dokopala dla ulu hatitipame ya꞉ watle wota꞉le hamipo tane diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Epalati osalo ya꞉ ata matle ya꞉ oko oplami hale tane diyo. Amasiyama omha꞉ha꞉lalo sota ya꞉ ma hopolopo yumiyo. Epamtamama osalo ya꞉ ata ya꞉ oko so hapuloma taiya diyo. Amasiyama dlomoko emale omha꞉ha꞉lalo sota opa opi hohopolemama opa opi tlo potimaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Epame osalo ya꞉ ata ya꞉ oko so hapuloma mo-pokadiyo. Epalati ma ya꞉ta bokotiyapo malamale maseyemala hatlo tlo tane demama epo malamaiyo, ‘Osalo omha꞉ha꞉lalo sotapo na꞉ maseyemala dla heodemama ya꞉ye poyumuluwa,’ diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Amasiyama osalo omha꞉ha꞉lalo sotapo osalo ya꞉ a yamita pulati natipame yiskamu yia꞉ dulu dla epo atlamyaiyo, ‘Maseyemala itapo osalo ya꞉ a elo dla hallala. Epedeme ya꞉ye yumpame osalo iye dita kolahalowepo,’ demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Epame yia꞉ maseyemala hamamtame yumpo ya꞉ motoye dlomoko emale kosukulli alikili dla hamastaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Epedeme osalo ya꞉ ata puame ya꞉ osalo omha꞉ha꞉lalo so dla apa koko hapa꞉? Ya꞉ puame yia꞉ye potipame ma opa amko hohopo ya꞉ osaloye omha꞉ha꞉iya dlepe. ");
INSERT INTO xla_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Epedeme wua꞉ God yu bukata atlama kokoye posesa꞉lalo wekemdi? Adipalati, edla ipo atlapo, ‘Aya halalo sota alumiti allimama alumiti hamastaletapo ma wata aya duka dla molopa kestale some halapo. ");
INSERT INTO xla_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Epedeme koko iye Lodta hauwapo. Epalati dita koko i natipo yiyelemama sikemte ka꞉dena depo.’” ");
INSERT INTO xla_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Epalati Yu so dokopala sota wayu i dalepame epo momalamaiyo, “Yesuye di koko atlapo,” demyaiyo. Epammama yia꞉ta Yesu hamolowe api totamaiyo. Amasiyama yia꞉ opa wowota꞉mama pohamalalo ma i-ilapo tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Epame Yu so dokopala so hapulomata Pa꞉lisi so opi mate Helod ya꞉ opa mate Yesu hala dla taiya diyo, yia꞉tapo Yesuta batalimale yu sepele atlati ya꞉ye hamolowedeme. ");
INSERT INTO xla_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Epedeme Pa꞉lisi so mate Helod ya꞉ opa mate puame Yesu watle epo atlaiyo, “Imalalo oplami, dia꞉ dimalamana, wa꞉ye ikadepe koko tlo atlamalalo oplamipo. Epo wa꞉ ma opaye powota꞉semde. Epame wa꞉ opa kapala di dla potlamasemde. Amasiyama wa꞉ ikadepe God koko tlo imsela꞉mdepo. ");
INSERT INTO xla_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Epedeme wa꞉ di atlane, di ka꞉deta꞉, Loum dokopala oplami Sisa watle ta꞉kis mani halopiliweye?” diyo. Yesu yia꞉ta ya꞉ elemala natiliye malanatipo epo atlaiyo, “Wua꞉ adipalati na꞉ye elemala natima꞉? Elo mani hema hampuaiya, na꞉ natili,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Epalati opata ya꞉ watle elo mani hamiyo. Yesu elo mani hame halemama yia꞉ watle epo atlaiyo, “Mani hema ana mila꞉pi mate epo ana hi mate hutiyema꞉?” diyo. Epalati opata asiyama epo atlaiyo, “Sisa mila꞉pi mate epo ya꞉ hi mateta hutiyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu asiyama yia꞉ watle epo atlaiyo, “Wua꞉ epapedeme Sisa teteye Sisa watle halopiya, epame God teteye God watle halopiya,” diyo. Epalati opata Yesu yu i dalepame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Epame alila oloma edla Sa꞉dusi so opa opita Yesu hala dla pumulaiyo. Opa iwolota atlemama, “Palli sota ma posilliwa,” demdepo. Epeleye yia꞉tapo puame Yesu watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Imalalo oplami, Mosesta di watle molo atlale yuye ipo ilipo hamiwapo, ‘Oplamitapo a꞉ya hapo yimlala pohatitimalalo halepo polopiye, ma oplami e ya꞉ eita sepeyama eye hapo ya꞉ bapa elo dla ha꞉ha꞉lowe yimlala hatitimelepe,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Epapedeme oplami haletapo akimlala 7 hatitimaiyo. Epame yia꞉ bapa tatle a꞉ya haiyo. Epo yimlala pohatitimalalo halemama powaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Epalati ma medla hallalota ya꞉ bapa ya꞉llu sepeyama me-eye haiyo. Ya꞉ mape yimlala pohatitimalalo powaiyo. Epela ma medla hallalota sepeyama hatlo me-eye haiyo. Amasiyama ya꞉ mape yimlala pohatitimalalo powaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Epamtamama akimlala 7 hapuloma ewolotapo yimlala pohatitimalalo pataiyo. Epo a꞉ya sepeyama eta mosukulu alotle powaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Epapedeme palli tle silliwe oloma edla a꞉ya eye ikadepe ana ya꞉llu depa꞉? Adipalati, yia꞉ta 7ta a꞉ya hatlo metlo halompuwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu asiyama yia꞉ watle epo atlaiyo, “Wua꞉ye yeitamale sopo. Adipalati, wua꞉ Godta itiyamale mate epo ya꞉ yu mate ala yeitamha꞉ha꞉po. ");
INSERT INTO xla_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Adipalati, palli sota wabasi tle ma sillipiye, yia꞉ matle wola꞉ mate epo opa mate pohalomha꞉ha꞉lowa. Amasiyama yia꞉tapo God ya꞉ banakaka sota Pepele di dla ha꞉ha꞉ye, epapele some ha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wua꞉ Mosestapo ya꞉ buka dla palli sota matle pasakalo depo silliwe koko dla ilimaleye posesa꞉lalo wekuwa? Adipalati, yu eye dalupa asiyale dulu tle dlapata hamdemhallati Godta dlapa dulu tle Moses watle epo atluwapo, ‘Na꞉ye A꞉iblaham ya꞉ Godpo, epo Aisek ya꞉ Godpo, epame Yokob ya꞉ Godpo,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Epapedeme God iye popalli so yia꞉ God. Hao, pasakalo ha꞉ha꞉lalo so yia꞉ Godpo. Epedeme wua꞉ pta sikemte yeitamale sopo.” ");
INSERT INTO xla_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Epalati aiyalma imalalo oplami haleta puame Yesu ya꞉ Sa꞉dusi so mate yu demhallati natiyo. Epame Yesuta Sa꞉dusi sota atlanatili yu ipi dla asiyama yu ka꞉ka꞉dle hapimhalla dalepame ya꞉tapo Yesu watle epo atlaiyo, “Mosesta aiyalma hatitimale dulu dla aiyalma adi tlo sikemte patota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Epalati asiyama Yesuta ya꞉ watle epo atlaiyo, “Di aiyalma hatitimale dulu dla aiyalma patoye ita elapo, ‘Isalael so wua꞉ daliya. Lodye di Godpo. Ya꞉ta hatlo di God halapo. ");
INSERT INTO xla_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Epedeme wua꞉ Lod wua꞉ Godye sikemte malamaiya, wua꞉ dupa dulu malamale tle, epo wua꞉ soko tle, epo wua꞉ta malamale tle, epo wua꞉ta itiyamale tle.’ ");
INSERT INTO xla_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Epame aiyalma pato haleye ipo, ‘Wa꞉ wa꞉skamu sikemte malamdiye, epammama wa꞉ amkale ma sikemte malamhalane.’ Epedeme aiyalma dapiyamte iwolotapo koko patoto ha꞉ha꞉po.” ");
INSERT INTO xla_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Epalati aiyalma imalalo oplamita Yesu watle epo atlaiyo, “Imalalo oplami, wa꞉ ikadepe koko atlalepo. Epedeme Lod hatlo ya꞉ta God halapo, god hale hawa. ");
INSERT INTO xla_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Epedeme di Lod sikemte malamolowa, di dupa dulu malamale tle, epo dita malamale tle, epo dita itiyamale tle. Epame diskamu sikemte malamdiye, epammama dia꞉ amkadulo ma sikemte malamolowepo. Epedeme aiyalma dapiyamte iwolo dolumoloweta koko pato halapo. Adipalati, aiyalma dapiyamte iwolotapo God watle alinepi poyupo dlapa dla halomalalo mate epo alisisi God watle hapilalo mate tla꞉mtame halapo.” ");
INSERT INTO xla_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu oplamita asiyama yu ka꞉dle atla dalepame ya꞉ watle epo atlaiyo, “Wa꞉ God ya꞉ mo koko dla ulatuluweye mo-mateka꞉pi dla halapo,” diyo. Epalati oplami haleta ma Yesu watle atlanatiloweye wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu Yu so aiyalma aya dla opa hapuloma imhalemama epo atlaiyo, “Adipalati aiyalma imalalo sotapo Kelisoye Deibidi yamipo demdi? ");
INSERT INTO xla_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Deibiditapo meyelo Hela꞉dle Soko tle ipo atluwapo, ‘Godta na꞉ Lod watle epo atluwapo, Wa꞉ na꞉ dowala tiyama dla polane. Epalati na꞉tapo wa꞉ watle opahale demha꞉ha꞉ soye wa꞉ hete sitali isili dla hatitimolowepo,’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Epedeme Deibidita Kelisoye ‘na꞉ Lod’ duwapo. Ame adipalati aiyalma imalalo sotapo Kelisoye Deibidi yami demdi?” Epalati opa hapulomata sisiyele mate Yesu yu woloma daliyo. ");
INSERT INTO xla_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu matle epo atlaiyo, “Ka꞉e! Wua꞉ aiyalma imalalo so opa woloma natiye. Yia꞉ tluka ka꞉ka꞉dle tlo didiyepo siyamdepo. Epo yia꞉ solotamde, opata yia꞉ natipame yia꞉ watle heodepo siyele yu atlamelepo depame. ");
INSERT INTO xla_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yia꞉ epame dita inoma sumalalo aya dla epo daya pato dele dla itapu ikadepe dla popa꞉lowe tlo solotamdepo. ");
INSERT INTO xla_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yia꞉ epo isikimi elemale tle sepeyamataloye dodolomsalepame yia꞉ ayaye kokolahamdepo. Epame yia꞉tapo isikimi opata dallepo depame inoma sumale yuye sikemte seselemalli atlamdepo. Epedeme yia꞉ asiyama wotiyalle pato halepe.” ");
INSERT INTO xla_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Opata aiyalma aya dulu dla namkale dle mani kolumha꞉ha꞉lati Yesu mani kolumalalo isilako mateka꞉pi dla polomama ompolaiyo. Yesu ompollati alisisi pasatale so opa hapulomata namkale dle alisisi patoto kolumha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Epalati sepeyamata puame palli mani elo dapiyamte tlo isilako dulu dla kolumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu sepeyama e natipame ya꞉ alotle tlalo so sisilapo epo atlaiyo, “Na꞉ wua꞉ watle mikadepe koko atlema. A꞉ya sepeyama itapo hamilita alisisi pasatale sota hapiliye ma-tla꞉mtalepo. ");
INSERT INTO xla_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Adipalati, alisisi pasatale soye mani patoto yia꞉ dla me-hutiyelati mani opihata tlo hapilipo. Amasiyama sepeyama iye, ya꞉ dla mani mosukulu elaleye etlo hamilipo. Epedeme ya꞉ dla daya dlowe mani ma-hawapo.” ");
INSERT INTO xla_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ya꞉ alotle tlalo so mate aiyalma aya tle tulumha꞉ha꞉mama ya꞉ alotle tlalo so oplami haleta ya꞉ watle epo atlaiyo, “Imalalo oplami, wa꞉ di aiyalma aya i natine. Ewala aya pta ka꞉pi ikadepe. Ewala tlamane, pta patoto,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuta asiyama ya꞉ watle epo atlaiyo, “Aya iye woloma natine. Adipalati, aya hema ewala haletapo matle yimkadulo tama di dla popopa꞉lowa. Amasiyama aya e dokostlati ewala hapuloma etapo matle ta꞉la dla teteyupo tulume popa꞉myelepe.” ");
INSERT INTO xla_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ma etle Olipi tamali di dla hetame polomama aiyalma aya ompolaiyo. Epalati Pita mate Yeims mate epo Yon mate epo Endulu mate miyelo puame Yesu watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Wa꞉ di atlane, aiyalma aya dokostlowe alilaye adipalalota꞉? Epame koko ita mo-puluwe mateka꞉pi dla hallati apa kokota di watle nati-ipa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yia꞉ta epo atlati Yesuta yia꞉ watle imolowe kotiyamama epo atlaiyo, “Ka꞉e, wolomape! Oplami haleta wua꞉ye ikadepe api tle ma alikili dla eleme tullala. ");
INSERT INTO xla_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Adipalati, opa opitapo na꞉ hi mate puame atlamyemama yiskamu yia꞉ye Kelisopo demyelepe. Epamyemama yia꞉ta opa pasataleye ikadepe api tle alikili dla me-eleme telepe.” ");
INSERT INTO xla_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Epame Yesu ma epo atlaiyo, “Epapedeme wua꞉ opahale koko mate epo nalatimale koko mateta wowoyamalati dalepame ase sikemte wowota꞉miyo. Ame adipalati, koko ipapele tatle wowoyamelepe. Amasiyama dulu edla mosukulu alilata yipta populuwa. ");
INSERT INTO xla_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mo haletapo mo hale mate opahale de demyelepe. Epame allutuwale patotota mo opi dla ellepe. Oloma edla mo opi dla daya pa꞉le kokotapo pulupe. Epapele kokota wowoyamelepiye, wotiyalle alilata kotiyamama apelepe. ");
INSERT INTO xla_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Epedeme wua꞉ wolomape! Opata wua꞉ye hohopame koko gladlalo aya dla eleme ta demha꞉ha꞉lepe. Epame wua꞉ye yia꞉ inoma sumalalo aya dla eleme hetame hohopole demha꞉ha꞉lepe. Epo na꞉ koko tle wua꞉ye dokopala so patoto mila꞉pi dla elemhetame ipila꞉ demha꞉ha꞉lepe. Amasiyama wua꞉ta edla na꞉ kokoye yia꞉ watle atlama demha꞉ha꞉lepe. ");
INSERT INTO xla_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Epedeme ka꞉dle yu tatle ta꞉lamo pato dla atlamtepo gudepo hallati ta꞉lamo mosukuluta edla woyamelepe. ");
INSERT INTO xla_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Epo opata wua꞉ye koko gladle aya dla hohopo hetlati wua꞉ ase wua꞉ta atlowe dla sikemte pomomalamolowa. Amasiyama Hela꞉dle Sokota wua꞉ watle oloma edla wua꞉ta atlowe yu hamilipiye, yu etlo atlamelepe. Adipalati, wua꞉ muwolo poyuhalowa, amasiyama Hela꞉dle Sokota wua꞉ mate halemama yuhalepe. ");
INSERT INTO xla_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oloma edla oplamitapo ya꞉ bapa mate ya꞉ ei mateta pallipo depame yia꞉ allimha꞉ha꞉ so dla homellepe. Epame atapo ya꞉ yimlala dla ma mepapelepe. Epame akimlalatapo sillipame yia꞉ adulo mate epo waidulo mate palliwe dla eleme telepe. ");
INSERT INTO xla_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Adipalati, wua꞉ta na꞉ dla mikadepe dle koko tle opa hapulomata wua꞉ dla elle pato himha꞉ha꞉lepe. Amasiyama antapo ya꞉ta mikadepe dleye kokalepo halemama mosukulu dla tame woyamelepiye, ya꞉ pasakalo hallowe halepe. ");
INSERT INTO xla_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Epedeme sesa꞉lalo oplami, wa꞉ yu i ya꞉ dulu kokoye woloma hane. Adipalati, wua꞉tapo ulugiyemale alisisi batalimaletapo ya꞉ta pohallalo wekele mo dla tulumhalla natilipiye, Yudiya so wua꞉ye tamali di dla ma hapele pohetlepe. ");
INSERT INTO xla_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Epame oplami aya potopali dla pollalo ya꞉ mape ya꞉ poka꞉dena, ma aya dulu dla tuwame ya꞉ alisisi halomoloweye. Amasiyama ya꞉ ma hapele tamali di dla telehetlepe. ");
INSERT INTO xla_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Epame osalo dulu dla sela꞉lalo oplami ya꞉ mape ma ilame aya dla ya꞉ tluka alisisi pohalomala tlowa. ");
INSERT INTO xla_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Epo oloma edla mopapo koko watalo so mate epo owayimlala ala meme ilimalalo so matetapo potloweye pta kokalle pato natilipe. ");
INSERT INTO xla_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Epapedeme wua꞉ta potlowe alilata teneyapi dla powoyamalalo wekelepo depame God dla inoma sumale yu himme ha꞉ha꞉iya. ");
INSERT INTO xla_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Adipalati, oloma edla wotiyalle koko patota pulupe. Epedeme ta꞉lamo kotiyamale oloma etle pualeye, opatapo wotiyalle koko ipapele ponatimdena. Epame wotiyalle koko pato ita tame gudlepiye, ma alotle wotiyalle koko ipapeleye ponatilowa. ");
INSERT INTO xla_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amasiyama epapele tlope Godta wotiyalle alila iye kiyepo mellepe. Adipalati, ya꞉ta alila selemalipo melematiye, oplami haleta wotiyalle dulu edla halloweye po-ala꞉ma. Amasiyama wotiyalle dulu edla Godta sesalemale so opa ma me-ha꞉ha꞉deme ya꞉tapo alila eye kiyepo mellepe. ");
INSERT INTO xla_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Oloma edla oplami haleta puame wua꞉ watle atlemama, ‘Iye Kelisopo,’ o ‘Huma natine, eye Kelisopo,’ dlatiye, ya꞉ yu dla mikadepe demiyo. ");
INSERT INTO xla_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Adipalati, biskapa elemala natilalo keliso mate epo biskapa God yu molo atlamalalo so matetapo puame ulugiyemale koko patoto halomyelepe, Godta sesa꞉le so elemolowa depame. ");
INSERT INTO xla_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Epedeme koko iye ala powowoyamalalo hallati na꞉ tatle wua꞉ye molo atlamayo. Epedeme wuskamu woloma omha꞉ha꞉iya.” ");
INSERT INTO xla_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Epame wotiyalle alila ita tame gudlati, ‘salita sumtlepe. Epalati mamata ma hela꞉dle pohamilowa. ");
INSERT INTO xla_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Epo tamili mape omapla di dla popa꞉ye ta꞉la dla teteyulupe. Epame itiyamale alisisi omapla di dla ha꞉ha꞉tapo hohoulalumama itiyamale pa꞉lepe.’ ");
INSERT INTO xla_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oloma edla opata Opa Yamiye wuala dulu tle hela꞉dle mate itiyamale pato mate pulati natilipe. ");
INSERT INTO xla_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Epame ya꞉ta pumama ya꞉ banakaka soye taiya dlepe, Godta sesa꞉le so opa hapuloma ta꞉lamo pato dla ha꞉ha꞉mtaye elemtelepo depame. ");
INSERT INTO xla_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Epedeme wua꞉ ipili dali tle koko i malamaiya. Wua꞉ ipili tokiyeta matlati natipame sali silaplowe alilata mo-kotiyama depo malamdepo. ");
INSERT INTO xla_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Epedeme koko i ma epapena. Wua꞉ na꞉ta atlama koko ita wowoyamalati natipame Opa Yamita puluweye mo-mateka꞉pi halayo depo malamelepe. ");
INSERT INTO xla_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Epedeme na꞉ mikadepe koko wua꞉ watle atlema. Wata oloma hema ha꞉ha꞉ soye ala me-ha꞉ha꞉lati koko hapuloma ita wowoyamelepe. ");
INSERT INTO xla_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Epedeme pepele di mate epo ta꞉lamo mate pa꞉lepe. Amasiyama na꞉ yu tlo popa꞉lowa. ");
INSERT INTO xla_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Epedeme Opa Yamita puluwe alilaye oplami haleta poya꞉malamana. Epame God ya꞉ banakaka so Pepele di dla ha꞉ha꞉ mate epo God Yami mate yia꞉ ma poyia꞉malamana. Amasiyama hatlo God tlo alila eye ya꞉malamana. ");
INSERT INTO xla_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Epo wua꞉ mape alila eta puluweye powua꞉malamana. Epedeme wua꞉ dinapo omha꞉ha꞉iya. ");
INSERT INTO xla_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Alila eye ipapena. Oplamitapo mo hale dla tamama ya꞉ oko so watle ya꞉ ayaye omha꞉ha꞉iye depo telepe. Ya꞉ epo ya꞉ oko so watle aya e omha꞉ha꞉lowe oko meyelope meyelope dle hapilipe. Epame kokoloma omhallalo watle ‘woloma ka꞉pi omhalane,’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Epapedeme aya yoye na꞉po. Epedeme wua꞉ woloma omha꞉ha꞉iye. Adipalati, wua꞉ powua꞉malamana, na꞉ta puluwe alilaye. Epapedeme pona꞉malamana, tamila꞉la puluwe, o utula꞉la dukuslopi puluwe, o iki ala yulumhallati puluwe, o utulala ikadepe puluwe. ");
INSERT INTO xla_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Alila hapuloma dinapopo omha꞉ha꞉iya. Adipalati, na꞉ta puame wua꞉ye hutiyela natiloweye poka꞉dena. ");
INSERT INTO xla_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Epedeme na꞉ wua꞉ watle epo opa hapuloma watle koko i atlema, wua꞉ woloma dinapopo omha꞉ha꞉iya.” ");
INSERT INTO xla_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Godta Namilatale daya dele dlowe mate epo Isip mo tle alikili dla woyamale malamale daya dele dlowe mate alila dapiyamte umuluwe ma a꞉ma hutiyeiyo. Epalati aiyalma aya dokopala so mate epo aiyalma imalalo so mateta esemama isikimi mala-atlale koko tle Yesuye hampo yumuluwedeme api totamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amasiyama yia꞉ yiskamu epo atlaiyo, “Di daya dele dulu dla ya꞉ye poyumuluwa. Adipalati, opata siyaladle ta꞉dlala,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Betani mo dla Saimon kapala batalimale oplami aya dla taiyo. Ya꞉ edla hetame daya dempollati a꞉ya hale isilako dla ullu ka꞉depo pamalalo dakopala tipo hampuaiyo. Ya꞉ puame isilako glastepo Yesu dokopala di dla simaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Epalati opa opi edla popa꞉le sotapo koko i natipame sikemte allimama yiskamu epo atlamyaiyo, “A꞉ya i adipalati dakopala ullu ka꞉dleye koko pa꞉le dla simama me-pokadi? ");
INSERT INTO xla_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ya꞉ ka꞉dena, dakopala ullu ka꞉depo pamalalo iye opa watle hamipame asiyama mani pato hapo alisisi pa꞉talo so gadloweye,” demyaiyo. Yia꞉ta epo atlemama a꞉yaye batalipo atlamyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “A꞉ya ita koko ha dla natipo ya꞉ye batalipo atlamiya. Adipalati, ya꞉tapo na꞉ dla ka꞉dle koko halëpo. ");
INSERT INTO xla_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Epedeme alisisi pa꞉talo sotapo alila hapuloma dulu dla wua꞉ mate ha꞉ha꞉lepe. Epalati wua꞉ta yia꞉ye gagademha꞉ha꞉lepe. Amasiyama na꞉ alila hapuloma dulu dla wua꞉ mate pohallowa. ");
INSERT INTO xla_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Epedeme a꞉ya itapo ya꞉ta haleli dle kokoye na꞉ dla halëpo. Ya꞉tapo na꞉ motota wabasi dulu dla elloweye malamama dakopalata na꞉ dla simalepo. ");
INSERT INTO xla_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na꞉ wua꞉ watle mikadepe koko atlema. Opata ta꞉lamo hadima ka꞉dle yu atlamtelepiye, yia꞉tapo a꞉ya ita koko halë ma atlamtelepe. Epalati opata ya꞉ koko ma malamelepe.” ");
INSERT INTO xla_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Epame Yesu ya꞉ alotle tlalo so 12 dulu dla hallalo oplami hale Yudas Iskaliyotta aiyalma aya dokopala so watle tame Yesu hamame iliweye yu himiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Epalati yia꞉ta yu i dalepame sikemte sisiyemama ya꞉ watle asiyama mani hamilowe yu atlaiyo. Epalati Yudastapo Yesuye yia꞉ do dla hamame iliwe api totamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Isip mo tle alikili dla woyamale malamale daya dele kotiyamale alila dla Yu sota Godta Namilatale daya dele tatle dlowedeme sipi aliya haloye poyumdiyo. Epedeme Yesu ya꞉ alotle tlalo sota Yesu watle epo atlaiyo, “Di hadima tame Namilatale daya dloweye dinapopa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Epalati Yesuta asiyama ya꞉ alotle tlalo so dapiyamte tlo taiya demama epo atlaiyo, “Wua꞉ Yelusalem dla tuwaiya. Wua꞉ edla tuwame natilati oplami haleta yú tipo tamhallati umulepe. Wua꞉ ya꞉ umpame ya꞉ dolumtelepe. ");
INSERT INTO xla_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wua꞉ ya꞉ta tame aya dulu dla hetlati ha꞉ha꞉mama aya yo ikadepe watle ipo atellepe, ‘Imalalo oplamita ya꞉ alotle tlalo so mate Godta Namilatale daya dlowe mo da꞉?’ dlepe. ");
INSERT INTO xla_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Epalati ya꞉tapo aya alupoli pato di dla hallaloye wua꞉ watle nati-ilipe. Wua꞉ epalati dita Godta Namilatale daya dloweye edla dinapelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Epalati Yesu ya꞉ alotle tlalo so dapiyamteta Yelusalem dla ma-taiyo. Yia꞉ tame natilati koko hapuloma Yesuta yia꞉ watle atlamaletapo mepo hutiyela tlamaiyo. Epalati yia꞉tapo Namilatale daya dloweye edla dinapiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Epo ma tamila꞉la oloma edla Yesuta ya꞉ alotle tlalo so 12 eleme puame aya dulu edla hetaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yia꞉ edla daya dempopa꞉mama Yesuta yia꞉ watle epo atlaiyo, “Na꞉ ikadepe koko wua꞉ watle atlema. Wua꞉ dulu dla oplami hale na꞉ mate daya dempolatapo na꞉ye opahale do tama dla homellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yesu ya꞉ alotle tlalo sota yu i dalepame dupa kolle mate popa꞉mama Yesu watle epo atlamyaiyo, “Na꞉ta꞉, na꞉ta꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu asiyama yia꞉ watle epo atlaiyo, “Wua꞉ta 12 dulu dla oplami antapo na꞉ mate palita hatlope dla daya saodepo delepiye, oplami eta na꞉ye opahale do tama dla hamame ilipe. ");
INSERT INTO xla_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Amasiyama God yu bukata atla e dolumama Opa Yamitapo polope. Amasiyama Opa Yami opahale do tama dla homallalo oplamiye wolomape. Ya꞉ wotiyalle dulu dla tullupe. Epapalala depame ya꞉ waita ya꞉ye pohamalalo wekematiye, eta ya꞉ ka꞉dlemla.” ");
INSERT INTO xla_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yia꞉ daya dempopa꞉lati Yesu daya hame God watle siyele yu atlepame daya hauwokokomaiyo. Epame ya꞉ alotle tlalo so watle alemama epo atlaiyo, “Daya halopo deiya. Iye na꞉ motopo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Epame Yesu matle isilako hapame God dla siyele yu atlepo gudepame ya꞉ alotle tlalo so watle hamiyo. Epalati yia꞉ta hapulomata yú deiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu ma epo atlaiyo, “Iye na꞉ omalipo, opa hapuloma yia꞉ bobtalimale howahalowe yilo dla olostapo. Na꞉ omali itapo Godta opa mate yu itiyapo himili amkoye kokalepo. ");
INSERT INTO xla_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Epedeme na꞉ ikadepe koko wua꞉ watle atlema. Na꞉ wata oloma itle tamama wain yú matle podlowa. Amasiyama alotle God ya꞉ mo dla wain yú amkoye dlowepo.” ");
INSERT INTO xla_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Epame yia꞉tapo siyele sala sepo gudepo ma Olipi tamali dla taiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuta matle ya꞉ alotle tlalo so watle epo atlaiyo, “Wua꞉ta hapulomata na꞉ saliyome potlepe. Adipalati, God yu bukata epo atlapo, ‘Godtapo sipi omhallalo oplamiye yumulati sipi hapulomata ya꞉ tle potlepe,’ depo.” ");
INSERT INTO xla_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Epame Yesu ma epo atlaiyo, “Amasiyama na꞉ powale tle ma sila꞉tipame na꞉ tatle tame Ga꞉lili dla wua꞉ omhallowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Epalati Pitata asiyama Yesu watle epo atlaiyo, “Opa hapulomatapo wa꞉ salepame potlepiye, asiyama hatlo na꞉ tlo wa꞉ posaliyome tlowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Amasiyama Yesuta ya꞉ watle epo atlaiyo, “Na꞉ wa꞉ watle ikadepe koko atlema. Wata utula꞉la gagapota dapiyamte oloma dla ala poyulumalalo hallati wa꞉tapo na꞉ kokoye dapahatlope oloma dla wellipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amasiyama Pitata Yesu yu ipi dla yu itiyamale mate epo atlaiyo, “Na꞉ pe-epapolowa. Opata wa꞉ye yumama yumilipiye, na꞉ wa꞉ mate polowepo,” diyo. Epalati ya꞉ alotle tlalo so hapuloma ma yu hatlo me-epo atlamyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Epame Yesu ya꞉ alotle tlalo so mate Getsemani osalo dla tamalaiyo. Epame Yesuta yia꞉ watle epo atlaiyo, “Na꞉ tame inoma sumhallati wua꞉ hema ompopa꞉iye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya꞉ epame isikimi Pita epo Yeims epo Yon tlo eleme hetaiyo. Ya꞉ edla hetame hallati dupa kolle mate opasi upiyele mateta ya꞉ dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Epalati ya꞉ Pita wolo watle epo atlaiyo, “Na꞉ opasi duluye upiyele patota hetamama polowe mateka꞉pi dla puma. Epedeme wua꞉ hema ha꞉ha꞉mama omha꞉ha꞉iye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Epame ya꞉ yia꞉ tle yimka꞉mala alikili dla tame alumata ta꞉la dla kellepo polomama ipo inoma sumpolaiyo, “A, koko hapulomaye wa꞉ dla pokokalena. Epedeme wa꞉ solotamelepiye, wotiyalle pato na꞉ dla puaye alikili dla hamastane. Amasiyama pona꞉ta solotamale koko, wa꞉ta solotamale koko tlo hane.” ");
INSERT INTO xla_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu inoma sumhalepo tame natilati ya꞉ alotle tlalo so dapahatlopeta mo-hutiyela natiyo. Epalati natipame Pita watle epo atlaiyo, “Saimon, wa꞉ adipalati elema꞉? Wa꞉ poka꞉deta꞉, alila yimka꞉mala dla na꞉ mate inoma sumhalloweye? ");
INSERT INTO xla_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Epedeme wua꞉ omha꞉ha꞉mama inoma sumha꞉ha꞉iya, wua꞉tapo elemala natili dulu dla tullala depame. Adipalati, soko wua꞉ dulu dla halatapo solotamapo, itiyamolowedeme. Amasiyama wua꞉ motota hopeyamapo.” ");
INSERT INTO xla_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Epame Yesu matle tame ya꞉ta ka꞉yapa inoma sumale yu atlamale hatlo metlo mamisika꞉ atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Epo matle ilampuame natilati ya꞉ alotle tlalo so dapahatlopeta inoma teta꞉mama mo-hutiyela natiyo. Epapele dulu dla yia꞉tapo yiyelepame wowota꞉mama Yesu watle yu hale atlowe pa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Epame Yesu matle tame inoma sumhalepo ilampuame natilati ya꞉ alotle tlalo so dapahatlopeta ma hutiyela natiyo. Epalati yia꞉ watle epo atlaiyo, “Wua꞉ ala me-sikemte hutiyepa? Wua꞉ hutiye mogudiya. Adipalati, Opa Yamiye batalimale so dla hamame iliwe alilata mo-puapo. ");
INSERT INTO xla_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Epedeme huma natiya, na꞉ batalimale so watle hamame iliwe oplamiye mo-puapo. Epedeme wua꞉ silliya, medla tlowa.” ");
INSERT INTO xla_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ala me-yukamhallati ya꞉ alotle tlalo so oplami hale Yudastapo Yesu hamolowe so opa elempuame edla woyamaiyo. Epapeleye Yesu hamolowe so opa iwoloye aiyalma aya dokopala so mate epo Yu so dokopala so mateta taiya diyo. Epalati yia꞉ta pumama aipa꞉ya mate epo bulukupi mate halopo puaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Epapele dulu dla Yudasta ala puluwedeme halemama Yesu hamolowe so watle epo atlaiyo, “Wua꞉ na꞉ta tame oplami hullupiye, oplami epo. Wua꞉ epalati ya꞉ye woloma hamame taiye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Epedeme Yudas opa me-eleme puame halemama Yesu hala dla tame epo atlaiyo, “Namkale, imalalo oplami” depame ya꞉ye huliyo. ");
INSERT INTO xla_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Epalati opata Yesu ma-hamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Amasiyama ya꞉ alotle tlalo so oplami haleta aipa꞉ya hame aiyalma aya dokopala oplami ya꞉ oko oplami haleye heyumama molo ketamastaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Epame Yesuta ya꞉ hamala puale so opa watle epo atlaiyo, “Wua꞉ na꞉ uhalalo oplamita hallati natipame na꞉ye hamolowedeme aipa꞉ya mate epo bulukupi mate halopo pumulo? ");
INSERT INTO xla_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Amasiyama wua꞉ na꞉ye alila hapuloma aiyalma aya dulu dla imsela꞉la natimduwapo. Ame wua꞉ adipalati na꞉ta edla hallati pohamalalo wekemduwa? Epele tlope wua꞉ta na꞉ hamala puale kokotapo God tle yu hapame molo atlamalalo sota atlamale yu mate ma-ala꞉po.” ");
INSERT INTO xla_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Epalati ya꞉ alotle tlalo so hapulomata ya꞉ saliyome mo-potaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Epapele dulu dla kipiliyemala haleta tluka siyapo tlo polupo Yesu hamame tlati alotle dolumtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Epalati opata ya꞉ hamolowedeme tluka dla hamalati ya꞉ tluka tlo yia꞉ dla pomelepo ya꞉ tlo tidali siyapo teletaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Opata Yesuye aiyalma aya dokopala oplami aya dla hamame hetaiyo. Epalati aiyalma aya dokopala so mate epo Yu so dokopala so mate epo aiyalma imalalo so mateta aya edla alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Epalati Pitata alo ikadepe tle Yesu dolumtame aiyalma aya dokopala oplami aya alikili tle halaiyo. Ya꞉ edla halemama aya e oko so mate kakapumalati dlapa tilimpopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Epalati aiyalma aya dokopala so mate epo Yu so dokopala so mate Yesu yumuluwedeme ya꞉ batalimale totamaiyo. Epammama opata isikimi Yesu hi mate mala-atlamyemama koko meyelope meyelope dle atlamyaiyo. Amasiyama yia꞉ta koko meyelope meyelope dle atlamyale dulu dla ikadepe koko hale ponatiyo, yia꞉tapo Yesu yumuluweye. ");
INSERT INTO xla_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Epalati opa opita sillipame Yesu hi mate ipo mala-atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Di oplami ita ipo atla daluwa, ‘Na꞉ opata halë aiyalma aya iye dokostepo ma alila dapahatlope dulu dla opata dota pohalalo wekele aiyalma aya amko halowepo’ duwa.” ");
INSERT INTO xla_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amasiyama yia꞉ta yu meyelope meyelope dle atlamyale dulu dla ikadepe koko ponatiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Epalati aiyalma aya dokopala oplamita opa alumale dulu tle sila꞉tipame halemama Yesu watle epo atlaiyo, “Wa꞉ opata wa꞉ koko dla yu meyelope meyelope dle atlamya dla asiyama yu po-atlalo wekepa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amasiyama Yesuta ya꞉ watle asiyama yu hale po-atlaiyo. Epalati aiyalma aya dokopala oplamita matle ya꞉ watle epo atlaiyo, “Wa꞉ God Yami Kelisota꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu asiyama epo atlaiyo, “Yao, na꞉po. Epedeme wua꞉ Opa Yamiye ya꞉ A God dowala tiyama dla polla natilipe. Epame ya꞉tapo pepele di wuala dulu tle malla natilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aiyalma aya dokopala oplamita yu i dalepame sikemte alimama ya꞉ tluka tallatallademama epo atlaiyo, “Oplami iye God hi mate putlopo atlema. Epedeme di ya꞉ koko gladlowe dla ma yu opi dlallowe posolotamasema. ");
INSERT INTO xla_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Adipalati, wua꞉ ma-dallepo, ya꞉ta God hi mate putlopo atlaleye. Epedeme wua꞉ apa koko ya꞉ dla halowe solotama꞉?” diyo. Epalati Yu so dokopala so hapulomata epo atlamyaiyo, “Yesuye pta batalimale oplami. Epedeme ya꞉ polowe ka꞉dena,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yia꞉ epo atlapame Yesu dla tetlemyemama ya꞉ watle mitikape tilitimyaiyo. Epalati opita Yesu inoma bopudepame ya꞉ heyulumyemama epo atlamyaiyo, “Anta wa꞉ye heyu?” demyaiyo. Epame aiyalma aya dokopala oplami ya꞉ oko sota Yesuye hopoliyo. ");
INSERT INTO xla_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pita ala dlapa me-timpollati aiyalma aya dokopala oplami ya꞉ gadlalo a꞉ya haleta puame Pita malanatipame ya꞉ watle epo atlaiyo, “Wa꞉ ma Nasalet oplami Yesu mate sela꞉uwa hale wa꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Epalati Pitata koko eye isikimi demama asiyama epo atlaiyo, “Na꞉ pona꞉malamana, wa꞉ta atla oplami kokoye,” diyo. Pita epo atlepo ma ya꞉ tle alikili a꞉ma teletaiyo. Epalati oloma edla gagapota ka꞉yapa yulumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Epame a꞉ya hatlo meta matle Pitata opa opi mate halla natipame yia꞉ watle epo atlaiyo, “Oplami iye Yesu mate sela꞉uwa hale ya꞉po,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amasiyama Pitata koko eye ma isikimi demama epo atlaiyo, “Na꞉ oplami e kokoye pona꞉malamana,” diyo. Epame opata ma yimka꞉mala ha꞉ha꞉po Pita watle epo atlaiyo, “Ikadepe, wa꞉ ma Yesu mate sela꞉uwa oplami hale wa꞉po. Adipalati, wa꞉ mape Ga꞉lili oplamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Epalati Pitata yu itiyamale mate koko eye isikimi depo God hi tle aiyalma semama yia꞉ watle epo atlaiyo, “Na꞉ pona꞉malamana, wua꞉ta atla oplami e ya꞉ kokoye,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pitata epo atlepo hallati gagapota dapiyamte oloma dla yulumaiyo. Epalati Pitata Yesuta ya꞉ watle atlale yu i malamaiyo, “Wa꞉ gagapota yulumale ala podapiyamte dlalo hallati wa꞉ na꞉ kokoye dapahatlope oloma dla wellipe.” Epapedeme ya꞉ yu i malapame dupa kolle pato hapame sikemte amaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Epedeme utulala ikadepe aiyalma aya dokopala so mate epo aiyalma imalalo so mate epo dokopala so opi hapuloma mate esempopa꞉iyo. Yia꞉ esepo gudepame Yesu doye deata kokotipoliyepame gamani oplami Paelet hala dla semtaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Epalati Paeletta Yesu natipame ya꞉ watle epo atlaiyo, “Wa꞉ ikadepe Yu so dokopala oplamita꞉?” diyo. Epalati Yesuta asiyama epo atlaiyo, “Yao, wa꞉ta atla hatlo mepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Epalati aiyalma aya dokopala sota Yesu dla batalipo atlamyemama ya꞉ watle batalimale pasatale oplami demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Epalati Paelet ma Yesu watle epo atlaiyo, “Wa꞉ opata wa꞉ koko dla yu meyelope meyelope dle atlamyaye podallalo wekema꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amasiyama Yesu yia꞉ watle yu hale po-atlaiyo. Epalati Paeletta koko e natipame sikemte yeliyo. ");
INSERT INTO xla_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sokomoko hapuloma dulu dla Paeletta Yu sota sisiyelepo depame Godta Namilatale daya dele oloma edla opata solotamale oplami haleye amtuwale aya dulu tle hamame alikili dla woyamdiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Epapeleye oloma edla oplami hale ya꞉ hi Balabasye amtuwale aya dulu dla halaiyo. Adipalati, ya꞉ ka꞉yapa yimkadulo mate Loum gamani so opa mate nalatimama oplami hale yumiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Epedeme opa hapulomata puame Paelet watle epo atlaiyo, “Wa꞉ amtuwale aya dulu dla hallalo oplami hale alikili dla hamame woyamdepo. Epedeme wa꞉ ma sokomoko hema oplami hale alikili dla hamame woyamane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Epele dulu dla Paelet mo-malanatiyo, Yu so dokopala sota Yesu dla sikemte elle himimama ya꞉ watle hamame pualeye. Epammama ya꞉ta opa hapuloma watle epo atlaiyo, “Wua꞉ solotama꞉, na꞉ta wua꞉ dokopala oplami Yesu tlo alikili dla hamame woyamoloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amasiyama aiyalma aya dokopala sota opa hapuloma watle ha꞉ha꞉limyemama epo atlamyaiyo, “Paelet watle atlemama, ‘Yesu tlo yummama Balabas tlo alikili dla hamame woyamane,’ diya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Epalati Paeletta koko i dalepo yia꞉ watle epo atlaiyo, “Na꞉ta Balabasye amtuwale aya tle alikili dla hamame woyamelepiye, ame na꞉ Yesu, wua꞉tapo wua꞉ dokopala oplami demdiye, adipapopa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Epalati yia꞉ta asiyama Paelet watle epo atlamyaiyo, “Ya꞉ye dali yekelemhimili di dla gogodiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Epalati Paelet asiyama yia꞉ watle epo atlaiyo, “Wua꞉ ya꞉ta apa batalimale koko halë hallati natipame ya꞉ye yumuluwedeme amma꞉?” diyo. Amasiyama opa hapulomata sikemte yu sisikalle mate epo atlamyaiyo, “Ya꞉ye dali yekelemhimili di dla gogodepo himiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Epalati Paeletta opa hapulomata sisiyelepo depame Balabasye amtuwale aya tle alikili dla hamame woyamaiyo. Epame ya꞉ opa watle asiyama Yesuye tuwale dea mate hopolepame dali yekelemhimili di dla gogodiya diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Epalati opahale sota Yesuye tuwale dea mate hopolepo Paelet aya dukuslopi haliyamale dla hamame hetaiyo. Epame edla opahale so opi hapuloma sisilapo alumaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Yia꞉ edla alupo Yesuye tetlemyelowedeme patoto sota didiyelalo tluka omteka꞉ple selemalli asiyomeliyo. Epame tuwale dea tipo ya꞉ dokopala dla asiyomelepame epo atlamyaiyo, “Yu so dokopala oplami dla heodepo sisiyeiya,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Epame bulukupita Yesu dokopala dla hohopolemyemama ya꞉ watle mitikape tilitimyaiyo. Epo tetlemyemama ya꞉ dla alumata ta꞉la dla kellepo heoheodlalimyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Epo gudepame opahale sota ya꞉ tluka omteka꞉pele asiyomelleye pustapame ma ya꞉ tluka ikadepeye asiyomeliyo. Epame Paelet aya tle Yesu ma-hamame dali yekelemhimili di dla gogodlowedeme semtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Opahale sota Yesu edla hamame tamha꞉ha꞉mama Kulene oplami hale ya꞉ hi Saimonye api duka dla Yelusalem dla pumhalla umaiyo. Epalati yia꞉tapo ya꞉ye hampame “Yesu dali yekelemhimili hamtane,” diyo. Saimon iye Alesenda mate Lupus mate yia꞉ ayo. ");
INSERT INTO xla_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yia꞉ Yesu hamame Golgota mo dla taiyo. Mo hi ya꞉ dulu kokoye dokopala elo. ");
INSERT INTO xla_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Epame edla semtame ha꞉ha꞉mama oplami haleta Yesu watle wain yúye wotiyalle pa꞉lalo yú mate dukupo hamiyo. Amasiyama Yesu yú e dloweye aliyo. ");
INSERT INTO xla_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Epame salita mo-kokalemtlati opahale sota Yesuye dali di dla mo-gogodepo himiyo. Epo yia꞉tapo Yesu tluka hukulupo halomolowedeme yia꞉ dulu dla ewala mate tatipiyele hale tatipiyeiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Epame oplami haleta yia꞉ta Yesu yumili sitali kokoye opata natilipo depame Yesu dokopala di dla yu ipo ilipo badiyo, ");
INSERT INTO xla_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Epame uhalalo so opa dapiyamte mape dali yekelemhatitimale di dla gogodlalimaiyo, haleta ya꞉ dowala tiyama dla epo haleta ya꞉ weke tiyama dla diyo.  ");
INSERT INTO xla_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Epedeme God yu bukata epo atlapo, “Ya꞉ye uhalalo oplami some polope.” Epeleye Yesutapo uhalalo oplami some mo-polowedeme elemama yu iye mikadepe duwapo. ");
INSERT INTO xla_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Epalati opata api tle tetla꞉po tamhalemama Yesu natipo yia꞉ dokopala popokalimyemama ya꞉ watle batalipo tetlemyaiyo. Epamyemama ya꞉ watle epo atlamyaiyo, “Wa꞉ ipo atluwapo, ‘Na꞉tapo aiyalma ayaye dokostapame ma alila dapahatlope dulu dla amko halepe’ duwapo. ");
INSERT INTO xla_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Epedeme wa꞉ dali yekelemhimili di tle malame wa꞉skamu wa꞉ gadene,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Epame aiyalma aya dokopala so mate epo aiyalma imalalo so mate yia꞉ mape yiskamu yia꞉ dulu dla Yesu tetlemyemama epo atlamyaiyo, “Ya꞉ye opa opi tlo gagademsela꞉mduwapo, amasiyama ya꞉ wata ya꞉skamu pogadesema. ");
INSERT INTO xla_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Epame ya꞉ye ikadepe Keliso, di Isalael so dokopala oplami dlepiye, ya꞉ dali yekelemhimili di tle mollowe ka꞉pi. Di eta ya꞉ta malla natipame ya꞉ dla mikadepe dlowepo,” demyaiyo. Epame uhalalo so opa dapiyamte Yesu mate dali yekelemhimili di dla gogodle so mape ya꞉ watle putlopo atlamyemama tetlemyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sali mo-dukuslopi dla hallati mo patota motiti tumama sali inoma dapahatlope pololiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Epame motiti tuwaleta ma hawa hallati Yesuta yu teta꞉le mate epo sisilamaiyo, “Ilai, Ilai, lama sabakatani.” Yu i dulu kokoye ipapena, “Na꞉ God, na꞉ God, Wa꞉ adipalati na꞉ melema꞉?” ");
INSERT INTO xla_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Epalati opa mateka꞉pi dla ha꞉ha꞉leta Yesuye semte Ilaya sisilamapo depame epo atlamyaiyo, “Wua꞉ daliya, ya꞉ye Ilaya sisilamapo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Epame oplami haleta dali selemalli ipi dla tluka polupo wain yú haka꞉le dla saodepame Yesu mati dla haiyeiyo, ya꞉tapo delepo depame. Ya꞉ epame epo atlaiyo, “Di ya꞉ye Ilayata puame hamame tulluwe depame aseka me-omha꞉ha꞉lowa,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Epame oloma edla Yesu yu sikemte di dla teta꞉pame powaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Epalati Yesuta powale oloma edla aiyalma aya dulu dla tluka deiyamaleta komaleye di tle tallademtulume isili dla gudiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Epame opahale so omhallalo oplamita Yesu dali yekelemhimili isili dla halemama Yesuta powale kokoye woloma natipame epo atlaiyo, “Ikadepe, oplami iye God Yamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Epame wola꞉ opi Yesu mate Ga꞉lili tle pumulale sota pateka꞉mu tle Yesu dali yekelemhimili di dla ellati omha꞉ha꞉iyo. Alumale dulu edla ha꞉ha꞉le so wola꞉ye Meli Magadalin mate epo Meli hale (Yeims yimka꞉mala mate Yosep mate yia꞉ wai), epo Salome matepo. Epeleye wola꞉ dapahatlope iwoloye Yesu mate Ga꞉lili dla siyamama Yesuye gademsiyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Epame ma tamila꞉la oloma edla Yosep Alimatiya oplamita Paelet hala dla taiyo. Ya꞉ mape Yu so dokopala oplami hale halemama God ya꞉ mo kokota puluwe dla omhalaiyo. Epeleye Yu so inoma sumalalo alila umuluwe mo-mateka꞉pi hallati ya꞉tapo powota꞉lalo Paelet watle Yesu moto hame tlowedeme tame daliyo. ");
INSERT INTO xla_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Amasiyama Paeletye Yesuta mo-powale yu dalepame sikemte yelepame ya꞉ opahale dokopala oplami sisilapame ya꞉ watle epo atlaiyo, “Yesu mo-pouwo de, mikadepeta꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Epalati asiyama yuye ya꞉ opahale dokopala oplamita atla dalepame Yosep watle “Yesu motoye hamtane,” diyo. ");
INSERT INTO xla_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Epalati Yosepta tame tluka selemalli hapo Yesu moto dali yekelemhimili tle hamtulume tlukata poliyo. Epame Yesu motoye hamtame tei seselemale dulu dla wabasi muwalle dla hamatiyo. Epo ewala patota kokolum-malame tulalo api himomeliyo. ");
INSERT INTO xla_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Amasiyama Meli Magadalin mate epo Meli Yosep ya꞉ wai mateta Yesu moto hamatili moye me-natiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Epame Yu sota inoma sumalalo alilata tamila꞉la ma-tame mogudlati Meli Magadalin mate epo Meli Yeims ya꞉ wai mate epo Salome mate ka꞉depo ullu pamalalo dakopala Yesu moto dla huhutupiliyelowe halomaiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Epame Sande alila utulala ikadepe sali mo-matamhallati yia꞉ Yesu wabasi natila taiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yia꞉ tamalemama epo atlamtaiyo, “Ewala pato wabasi tulalo api himomelleye, anta alikili dla kokolustlowe?” demtamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amasiyama yia꞉ tame natilati ewala pato eye mo-kokolustale halla natiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Epalati wola꞉ ewolota wabasi dulu dla tuwame yia꞉ dowala tiyama dla natilati kipiliyemalata tluka kamkamale selemalli asiyame polla natipame sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Amasiyama ya꞉ta yia꞉ watle epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Na꞉malamana, wua꞉ye Yesu Nasalet oplami dali yekelemhimili di dla gogoduwaye totamsiyamapo. Amasiyama ya꞉ye hema hawa. Wua꞉ puame ya꞉ta elale natiya. Ya꞉ hema pe-elasema. Ya꞉ powale tle mo-sila꞉time hetana. ");
INSERT INTO xla_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Epedeme wua꞉ tame Pita mate epo Yesu ya꞉ alotle tlalo so opi mate dla atlaiye, yia꞉tapo Ga꞉lili dla telepo depame. Adipalati, Yesuye ya꞉ tatle tame Ga꞉lili dla yia꞉ye ompolapo. Epedeme yia꞉ tame Ga꞉lili dla Yesuye natilipe. Adipalati, Yesuta ka꞉yapa yia꞉ watle koko iye ma-atluwapo.” ");
INSERT INTO xla_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Epalati wola꞉tapo wabasi tle wowota꞉le mate ullumtamalemama eseselalalimtamalaiyo. Amasiyama yia꞉ api duka dla tamalemama oplami hale po-atlaiyo. Adipalati, yia꞉ sikemte wowota꞉le mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuta Sande alila utulala ikadepe powale tle sila꞉tipo ya꞉ ka꞉yapa Meli Magadalin hala dla tame woyamaiyo. Meli iye Yesuta ka꞉yapa ala popolalo sela꞉mama bataliya yimlala 7ye ya꞉ tle alikili dla dodolomsaliyo. ");
INSERT INTO xla_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Epeleye Meli itapo Yesu natipame tame Yesu mate siyamale so opa dupa kolle mate a꞉lempopa꞉lati yia꞉ watle epo atlaiyo, “Na꞉ Yesuye powale tle ma-sila꞉time sela꞉la nati,” diyo. Amasiyama yia꞉tapo ya꞉ yu dalepame pomikadepe diyo. ");
INSERT INTO xla_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Epo ma alotle Yesuta ya꞉ mila꞉pi meyelope depo ya꞉ mate siyamale opa dapiyamte api duka dla tamha꞉ha꞉lati tame woyamaiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Epalati ma opa dapiyamte iwolota yia꞉ta Yesu natiliye tame opa Yesu mate siyamale watle atlamalati yia꞉tapo yia꞉ yu dla ma pomikadepe diyo. ");
INSERT INTO xla_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Epame alotle Yesu ma ya꞉ alotle tlalo so 11ta daya dempopa꞉lati tame woyamaiyo. Epame yia꞉ watle yu itiyamale mate epo atlaiyo, “Wua꞉ mikadepe dle pa꞉talo sopo. Wua꞉ adipalati opa opita ka꞉yapa na꞉ natipo puame atlamalati edla pomikadepe dlalo weki?” diyo. ");
INSERT INTO xla_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Yesu ma yia꞉ watle epo atlaiyo, “Wua꞉ ta꞉lamo pato dla tame ka꞉dle yuye opa hapuloma dla atlamsiyamaiya. ");
INSERT INTO xla_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Epedeme oplami antapo ka꞉dle yu dla mikadepe depo yú dla tullupiye, ya꞉ye kokó elepo ellalo pasakalo halepe. Amasiyama oplami antapo ka꞉dle yu dla pomikadepe dlalo wekelepiye, ya꞉ye Dlapa mo dla ka꞉stlepe. ");
INSERT INTO xla_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Epame ka꞉dle yu dla mikadepe dle sota na꞉ta itiyamale mate ulugiyemale koko halomsiyamelepe. Epedeme yia꞉tapo bataliya yimlalaye na꞉ hi tle alikili dla dodolomsalemsiyamelepe, epo ulugiyemale yu mate yuhamyelepe, ");
INSERT INTO xla_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","epame yia꞉tapo ilama dota hohomsiyamelepe, epame yati dala dlomelepiye, yia꞉ popalliwa, epame yia꞉ dota esusulumale soye hohomsiyamalati esusulumale sota ma-ka꞉ka꞉dlalimelepe.” ");
INSERT INTO xla_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lod Yesuye yu i atlemhalepo gudlati Godta itiyamaleta ya꞉ye Pepele dimo dla hamame hetaiyo. Epame ya꞉ God ya꞉ dowala tiyama dla polaiyo. ");
INSERT INTO xla_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Epalati Yesu ya꞉ alotle tlalo sota Yesu yu dolumama ta꞉lamo pato dla ka꞉dle yu atlamtaiyo. Epalati Lodta yia꞉ mate hallati ulugiyemale koko halomsiyamaiyo, opata ka꞉dle yu dla dlalepo mikadepe dlepo depame. ");
INSERT INTO xla_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Godta dia꞉ dulu dla oko hamhaluwaye opa opitapo kotiyamale tle koko e tlapame yia꞉ ma God oko hamama opa dulu dla koko eye atlamsiyamuwapo. Yia꞉ta atlamsiyama koko eye di ma me-daluwa. Epalati ma opa opitapo ikadepe yo dlalle so mate epo koko e tlamale so mateta atlamala dalepame yia꞉ koko eye buka dla ilalimuwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Epedeme na꞉ ma koko hapuloma eye na꞉ta woloma kotiyamale tle malastademe na꞉ mape yu iye woloma ilima. Epapedeme Tiyopoles namkale, wa꞉ta daluwa koko eye wa꞉ta woloma ikadepe koko dlepo depame na꞉ta wa꞉ watle yu ilimale iye hamima. ");
INSERT INTO xla_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Helodta Yudiya mo dla dokopala oplami halale oloma edla God ka꞉ epo opa ka꞉ duka dla hallalo oplami hale halaiyo, ya꞉ hiye Sekalaya. Ya꞉ God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo so alumale hale Abiya alumale dulu dla halaiyo. Epo ya꞉llu hiye Elisabet, ya꞉ ma A꞉lon ya꞉ asiyapo. ");
INSERT INTO xla_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Epapeleye Sekalaya mate Elisabet mate God mila꞉pi tle woloma ka꞉ka꞉depo ha꞉ha꞉mama Godta molo atlale yu woloma dolumha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amasiyama yia꞉ yimlala hawa ha꞉ha꞉iyo. Adipalati, Elisabet ya꞉ye hamkapi a꞉ya polomama ma-alluyemala halaiyo. Epalati Sekalaya mape mo-totoyemala halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Alila haleta Sekalaya ya꞉ alumale sota oko halowe alilata pulati Sekalayata Yu so aiyalma aya dla hetame God mila꞉pi tle halemama oko hamhalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Epalati God ka꞉ epo opa ka꞉ duka dla ha꞉ha꞉lalo sota yia꞉ dulu dla oplami hale hulumolowedeme ewala mate tatipiyele hale tatipiyemdiyo. Epapedeme yia꞉ta yia꞉ dulu dla epo ewala mate tatipiyemama Sekalayata tla꞉mtaiyo. Epalati yia꞉ta Sekalayaye Lod ya꞉ aiyalma aya dulu dla ullu ka꞉dle seyamale ha꞉lepo depame hulumaiyo. Epedeme Sekalayata Yu so aiyalma aya dla hetame ullu ka꞉dle seyamale ha꞉mhalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Epame ya꞉tapo ullu ka꞉dle seyamale ha꞉mhallati opa hapulomata aiyalma aya alikili tle ha꞉ha꞉mama inoma sumha꞉ha꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekalayaye aiyalma aya dulu dla me-hallati God ya꞉ banakaka oplamita ullu ka꞉dle seyamale ha꞉lalo tile dowala tiyama dla woyame halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Epalati Sekalayata banakaka oplami natipame sikemte yelepame wota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Amasiyama God ya꞉ banakakata ya꞉ watle epo atlaiyo, “Sekalaya, wa꞉ ase sikemte wota꞉miya. Godta wa꞉ta inoma sumhaluwaye ma-daluwapo. Wa꞉ allu Elisabetta mopapo polopame maseyemala hamelepe. Epalati wa꞉tapo maseyemala ya꞉ hiye Yon dlepe. ");
INSERT INTO xla_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ya꞉tapo wa꞉ dla siyele hampulupe, epame opa hapulomata ya꞉ hamalati sisiyelepe. ");
INSERT INTO xla_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Adipalati, ya꞉tapo Lod mila꞉pi tle pato oplami hallepe. Epedeme ya꞉tapo kawata yú podlowa. Amasiyama ya꞉ye ya꞉ waita ya꞉ hamale tle kotiyapo Hela꞉dle Sokota pasatepo hallepe. ");
INSERT INTO xla_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ya꞉tapo Isalael soye mamisika꞉ Lod yia꞉ God hala dla elempulupe. ");
INSERT INTO xla_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ya꞉ Ilayata itiyamale mate haluwa epapele some halemama Lodta puluwedeme hallati ya꞉ tatle olomasepele pulupe. Epame ya꞉tapo opaye Lodta pua koko dla dinapomama adulo mate yia꞉ yimlala mateye sadle koko dla elempulupe. Epame ya꞉tapo God yu dla posalladepo siyamalalo sota malamaleye ma ka꞉dle koko halowe malamale dla elempulupe.” ");
INSERT INTO xla_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Amasiyama Sekalayata God ya꞉ banakaka oplami watle epo atlaiyo, “Na꞉ apa koko natipame wa꞉ta atla kokoye ikadepe depa꞉? Adipalati, na꞉ye mo-totoyemala halapo, epame na꞉ a꞉ya ma ma-alluyemala polapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","God ya꞉ banakaka oplamita asiyama ya꞉ watle epo atlaiyo, “Na꞉ hiye Ga꞉ibiliyelpo. Na꞉ye God mila꞉pi tle halemdepo. Godtapo na꞉ye tulune de, na꞉tapo wa꞉ watle ka꞉dle yu iye atlepo depame. ");
INSERT INTO xla_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amasiyama wa꞉ dalene, wa꞉ yu pa꞉le oplami depo hallepe. Adipalati, wa꞉ na꞉ yu dla pomikadepedesema. Epedeme wa꞉ yu pa꞉po hallati na꞉ta wa꞉ watle atlamale koko ita wowoyamolowe alilata umulati edla natipame matle yukamelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sekalayata aiyalma aya dulu dla halemama kokó dlati opa hapulomata alikili dla omha꞉ha꞉mama epo atlamyaiyo, “Ya꞉ apa koko hamhalemama amma꞉?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Epalati Sekalayata aiyalma aya tle matime poyukamalalo halemama isikimi do yu mate atlamaiyo. Epalati opata koko e natipame momalamaiyo, “Ya꞉ye aiyalma aya dulu dla halemama inomata meyelope dlati ulugiyemale koko tlamayo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekalayata aiyalma aya dulu dla oko hamhalale alilata mo-puame gudlati ya꞉ ma ilame ya꞉ mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Alotle Sekalaya ya꞉llu Elisabetta mopapo pollati mama 5 dulu dla ya꞉ta hatlo ya꞉ aya dulu dla halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Epame Elisabetta ya꞉skamu epo malamdiyo, “Lodta na꞉ gaduwapo, epame ya꞉tapo na꞉ta opa mila꞉pi dla hamkapi polomama wota꞉mduwaye ma-hamastauwapo,” demdiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabetta mopapo polaleye mama 6 mo-pololepo hallati Godta ma ya꞉ banakaka oplami Ga꞉ibiliyelye tulune diyo, homta pollalo ipilalo Meli watle. Meliye Ga꞉lili mo pato dulu dla Nasalet mo dla hallalo a꞉yayo. Epapeleye Deibidi mate asiya hatlope oplami haleta Meli halowedeme halaiyo, ya꞉ hiye Yosep. ");
INSERT INTO xla_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Epeleye God ya꞉ banakaka oplamita tulume Meli watle epo atlaiyo, “Namkale, Godta sale a꞉ya wa꞉po. Godta wa꞉ mate halapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meli yu i dalepo yelepame yu i ya꞉ dulu kokoye sikemte momalamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Amasiyama God ya꞉ banakaka oplamita asiyama Meli watle epo atlaiyo, “Meli, wa꞉ ase sikemte wota꞉miya. Adipalati, Godta sale a꞉ya wa꞉po. ");
INSERT INTO xla_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wa꞉tapo mopapo polopame maseyemala hamelepe. Epame wa꞉tapo ya꞉ye Yesu sepilipe. ");
INSERT INTO xla_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ya꞉tapo pato hallepe, epame ya꞉ye di ikadepe dla hallalo God Yami dlepe. Epame Lod Godta ya꞉ mama Deibidita dokopala haluwa moye ma ya꞉ watle hamilipe. ");
INSERT INTO xla_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Epalati ya꞉tapo Yokob ya꞉ asiya dulu dla dokopala oplami hallepe. Epame ya꞉ta dokopala depo hallowe kokota sukulu pa꞉le ellepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Epalati Melita asiyama God ya꞉ banakaka watle epo atlaiyo, “Koko iye adipo na꞉ dla epo woyapa꞉? Na꞉ oplami koko yeliyena,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Amasiyama God ya꞉ banakaka oplamita epo atlaiyo, “Hela꞉dle Sokota wa꞉ dla tullupe, epame di ikadepe dla hallalo Godta itiyamaleta wa꞉ye bopudlepe. Epapedeme wa꞉ta hamolowe maseyemalaye aiyalmapo, epame ya꞉ye God Yami dlepe. ");
INSERT INTO xla_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Epedeme wa꞉ dalene. Wa꞉ aya Elisabet malamane. Ya꞉ye mo-alluyemala polomama hamkapi a꞉ya poloma duwapo. Amasiyama ya꞉ye watapo mopapo pola mama ma 6 halapo. ");
INSERT INTO xla_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Adipalati, God ya꞉ dla koko hapuloma dulu dla kokalle hawa,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Melita epo atlaiyo, “Na꞉ye Lod ya꞉ yu dla salladepo sela꞉lalo a꞉yapo. Epedeme wa꞉ta atlamale kokota na꞉ dla wowoyamelepe,” diyo. Epalati God ya꞉ banakaka oplamita Meli saliyome taiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Epame oloma edla Melitapo dinapopame ma hapele Elisabet natila taiyo. Ya꞉ Yudiya tamali mo dla hetame Sekalayata hala mo yemala dla woyapame ma Sekalaya aya dla taiyo. Ya꞉ Sekalaya aya dla hetame Elisabet natipame namkale dle yu atlaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabetta Melita namkale dle yu atla dalle oloma edla owayemalatapo ya꞉ koko dulu dla humsela꞉iyo. Epame Elisabetye Hela꞉dle Sokota tulume ya꞉ dla haiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Epalati ya꞉ta yu teta꞉le mate epo atlaiyo, “Wola꞉ hapuloma dulu dla Godta wa꞉ dla siyele pato hamimama wa꞉ koko dulu dla pola maseyemala dla mape siyele hamipo. ");
INSERT INTO xla_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na꞉ popato a꞉ya tlope, na꞉ Lod ya꞉ waita na꞉ natila pualepo. Koko edla na꞉ sikemte siyema. ");
INSERT INTO xla_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Epame wa꞉ta na꞉ watle namkale dle yu atlati owayemala na꞉ koko dulu dla polata siyemama humsela꞉. ");
INSERT INTO xla_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wa꞉ Lodta wa꞉ dla woyamolowe koko atlati dalepame yu edla mikadepe duwa koko tle Lodta wa꞉ dla siyele hamilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Epame Melita epo atlaiyo, “Na꞉ dupa dulu tle Lod dla siyele yu atlama. ");
INSERT INTO xla_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Epame na꞉ sokota na꞉ God na꞉ pasakalo gadlalo dla siyema. ");
INSERT INTO xla_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Adipalati, ya꞉ta malamale pato himiwapo, ya꞉ yu dla salladepo sela꞉lalo koko pa꞉le a꞉ya na꞉ dla. Epedeme oloma itle tamama opa hapulomatapo na꞉ watle siyele a꞉ya dlepe. ");
INSERT INTO xla_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Adipalati, itiyamale Godtapo na꞉ dla koko patoto ma-halomuwapo. Ya꞉ hiye aiyalmapo. ");
INSERT INTO xla_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Opa anawolotapo God wowota꞉mha꞉ha꞉ma꞉, yia꞉ dla Godta polowamaletapo kokó ellepe. ");
INSERT INTO xla_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ya꞉ dotapo koko patotoye ma-halomuwapo. Epame ya꞉tapo yiskamu yia꞉ tlo ka꞉ka꞉dena depo di dla halopo hetlalo soye alikili a꞉ma posaluwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Epo ya꞉tapo dokopala depo popa꞉lalo soye ma isili dla ipila꞉pame atali soye gagademama di dla halopo hetauwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Epame ya꞉tapo daya pa꞉talo soye ka꞉ka꞉dle alisisi mate gadepame asiyama alisisi poposatilimale soye alisisi dimi alikili a꞉ma posaluwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Epame ya꞉tapo di mamadulo mate yu itiyapo himiwaye e dolumama ya꞉ yu dla salladepo siyamalalo Isalael soye gaduwapo. Epedeme ya꞉ta polowamale kokotapo A꞉iblaham mate ya꞉ mamadulo mate dla kokó ellepe.” ");
INSERT INTO xla_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meliye Elisabet mate halemama mama dapahatlope pololepo gudepame ma ilame ya꞉ mo dla taiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetta owayemala hamolowe alilata mo-pulati ya꞉ maseyemala hamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Godta Elisabet watle koko ka꞉dle halë edla ya꞉ asiyadulo mate epo ya꞉ mateka꞉pi dla ha꞉ha꞉lalo so mate koko i dalepo siyele yimkata Elisabet mate ta꞉diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Epame maseyemala hamale alotle alila 8 umulati yia꞉ta hapuloma maseyemala e ya꞉ kapala kestlowedeme puame alumaiyo. Epame yia꞉ solotamaiyo, maseyemala hiye ya꞉ a Sekalaya hi sepilowedeme. ");
INSERT INTO xla_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amasiyama ya꞉ waita epo atlaiyo, “Hao, ya꞉ hiye Yon dlepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amasiyama yia꞉ta Elisabet watle epo atlaiyo, “Yonye powa꞉ toto hi,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Epame yia꞉ ma maseyemala ya꞉ a watle maseyemala hi dallowedeme do yu mate atlaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Epalati Sekalayata opa watle hotowe mate namkalapi mate daliyo, maseyemala hi himilowedeme. Epame ya꞉ta maseyemala hiye epo himiyo, “Ya꞉ hiye Yon.” Epalati opa hapulomata koko i natipo sikemte yiyelepame momalamyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Epame pakasiyamalalo Sekalayata poyukamalalo halaleta matle yukamolowe kotiyapame God dla siyele ta꞉demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Epalati mo edla ha꞉ha꞉lalo sotapo koko i natipo wowota꞉iyo. Epame Yudiya tamali mo dla ha꞉ha꞉lalo so mape koko iye dlalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Epame koko i dallalo sota momalamama epo atlamyaiyo, “Maseyemala iye adipapele oplamita halepa꞉?” demyaiyo. Adipalati, yia꞉ natiyo, Lodta itiyamaleta ya꞉ mate hallati. ");
INSERT INTO xla_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yon ya꞉ a Sekalayata Hela꞉dle Sokota pasatepo halemama amile dla wowoyamolowe kokoye momolo epo atlamaiyo, ");
INSERT INTO xla_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isalael so yia꞉ Lod God hi di dla ta꞉diya. Adipalati, ya꞉tapo puame asiyama mate dia꞉ye ya꞉ hala dla elempulupe. ");
INSERT INTO xla_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Epame dia꞉ dla God ya꞉ oko oplami Deibidi ya꞉ asiya dulu tle pasakalo gadlalo oplami pato di watle ma-hamipo. ");
INSERT INTO xla_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Koko iye Godta ka꞉yapa ya꞉ mila꞉pi tle aiyalma depo ha꞉ha꞉uwa molo atlamalalo so mati tle di watle ma-atlamuwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Epapedeme Godtapo dia꞉ye dia꞉ mate opahale demha꞉ha꞉ sota itiyamale tle epo dia꞉ dla allimha꞉ha꞉ so dulu tle alikili dla eleme woyamelepe. ");
INSERT INTO xla_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Epame ya꞉tapo di mamadulo dla polowamale kokoye himhalli duwapo. Epame ya꞉tapo A꞉iblaham mate yu itiyapo himili eye malahalli duwapo. ");
INSERT INTO xla_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Epapedeme Godtapo dia꞉ye dia꞉ mate opahale demha꞉ha꞉ so do dulu tle eleme alikili dla woyamelepe, ditapo God ya꞉ oko hamha꞉ha꞉mama wota꞉le pa꞉po ha꞉ha꞉lepo depame. ");
INSERT INTO xla_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Adipalati, ya꞉tapo dia꞉ye ya꞉ mila꞉pi tle mo-ullu pa꞉talo so dlepe. ");
INSERT INTO xla_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amasiyama na꞉ maseyemala, wa꞉ye opatapo di ikadepe dla hallalo God yu molo atlalo oplami dlepe. Adipalati, wa꞉tapo Lodta puluwedeme hallati wa꞉ tatle tame ya꞉ apiye dinapelepe. ");
INSERT INTO xla_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wa꞉tapo ya꞉ opaye pasakalo halowe kokoye imelepe, eye Godta yia꞉ bobtalimale howahalowe kokoye apopo. ");
INSERT INTO xla_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Godtapo dia꞉ye polowamama sikemte malahalapo. Epapedeme Pepele di tle dia꞉ dla alila amkota alallowedeme pulupe. ");
INSERT INTO xla_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hela꞉dle itapo polowe dulu dla ha꞉ha꞉ so mate epo amtuwale dulu dla ha꞉ha꞉ so mate dla domala pulupe. Epame hela꞉dle itapo dia꞉ye Godta sadle dla elemtelepe.” ");
INSERT INTO xla_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yontapo ta꞉mama Soko tle itiyamale oplami depo halaiyo. Ya꞉tapo dalupa dulu dla halepo depame ma alilata pulati Isalael so opa dla ka꞉dle yu atla puaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Oloma edla Sisa Augustusta Loum mo dokopala depo halemama hi halalo so watle yu hamimama epo atlaiyo, “Wua꞉ tame Loum mo pato dulu dla opa hapuloma hi halomtelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hi halomtale iye hi pohalomalalo ha꞉ha꞉po depame ka꞉yapa hi halomolowe kotiyamama apiyo. Hi halomtale iye Kuleniyosta Siliya mo dla dokopala halale oloma dla apiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Epalati opa hapulomata yia꞉ hi hapilowedeme yia꞉ mo ikadepe dla tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Epedeme Yosepye Deibidi ya꞉ mama halepo. Epapedeme ya꞉ Ga꞉lili mo dulu dla mo hale Nasalet tle ma Yudiya mo dla mo hale Betliyem dla ya꞉ hi hamilowedeme hetaiyo. Adipalati, Betliyem mo eye Deibidi ya꞉ asiyadulo mo ikadepepo. ");
INSERT INTO xla_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ya꞉ Meli, ya꞉ watle hamilowa depo yu himme ha꞉ha꞉leye me-seme hetaiyo, hi halopiliwedeme. Amasiyama oloma edla Meliye mopapo mo-polaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yia꞉ ala Betliyem mo dla tame woyamalati Melita owayemala hamolowe alilata mo-puaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Epalati ya꞉tapo ka꞉yapa owayemala hammama maseyemala hamaiyo. Ya꞉ maseyemala hampame tlukata polupo aliyata daya dlalo aya helemale dla himiyo. Adipalati, asepe sota ha꞉ha꞉lalo aya dulu edla alupoli hale hawa halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yesu hamale utula꞉la edla halo omha꞉ha꞉lalo sota Betliyem mateka꞉pi dla yia꞉ sipi aliya ompopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Epalati Lod ya꞉ banakakata pakasiyamalalo yia꞉ mateka꞉pi dla woyamaiyo. Epame Lod ya꞉ hela꞉dleta yia꞉ halati yia꞉ sikemte wowota꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Amasiyama banakaka oplamita yia꞉ watle epo atlaiyo, “Wua꞉ ase sikemte wowota꞉miya. Adipalati, na꞉tapo opa hapulomata sisiyelowe ka꞉dle yuye wua꞉ dla hampualepo. ");
INSERT INTO xla_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Watapo Deibidi mo dla opa pasakalo gadlowe maseyemalaye ma-hamalepo. Ya꞉ye wua꞉ta dalemha꞉ha꞉mama omha꞉ha꞉uwa Keliso Lodpo. ");
INSERT INTO xla_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wua꞉tapo ya꞉ye ipo malanatilipe, maseyemala eye tlukata polupo aliyata daya dlalo aya helemale dla ella natilipe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Epalati pakasiyamalalo banakaka so alumale patota malame ka꞉yapa malale banakaka oplami mate hatlo godepame God dla siyele ta꞉demama epo atlamyaiyo, ");
INSERT INTO xla_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pepele di dla hallalo God dla siyele ta꞉diya. Epame ta꞉lamo hema Godta solotamale so dla sadleta ellepe,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Banakaka sota ma i-ilapo pepele di dla hetlati halo omha꞉ha꞉lalo sota yiskamu yia꞉ dulu dla epo atlamyaiyo, “Di Betliyem mo dla tame Lodta di watle atlamale kokoye natila tlowa,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yia꞉ ma hapele tame natilati Meli mate Yosep mate maseyemalaye aliyata daya dlalo aya helemale dla himimpopa꞉la natiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yia꞉ tame maseyemala natipame ma Yosep mate Meli mate dla banakaka oplamita yia꞉ watle maseyemala ya꞉ koko dla atlamale yuye ma yia꞉ watle atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Epalati halo ompopa꞉lalo sota maseyemala koko dla atlamala dallalo so hapulomata sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amasiyama Melitapo koko i dalepame alila hapuloma dulu dla powelilalo me-malahalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Halo omha꞉ha꞉lalo sota ma ilame tamalemama yia꞉ta dalle koko mate epo tlamale koko mate dla God watle siyele pato ta꞉diyo. Adipalati, yia꞉ta tlamale hapulomaye banakaka oplamita atlamale yu mate ma-ala꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Epame owayemala hamale alotle alila 8 umulati maseyemalaye kapala kestaiyo. Epame ya꞉ watle Yesu hiye sepilaiyo. Adipalati, hi iye ka꞉yapa ya꞉ ala Meli koko dulu dla popollalo hallati banakaka oplamita hi iye hamiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Meli mate Yosep mate Mosesta aiyalma hatitimale dolumama yia꞉ta God mila꞉pi tle ma ullu pa꞉po ha꞉ha꞉lowedeme dinapele alilata tame gudlati yia꞉ Yesu seme Yelusalem dla taiyo. Epame yia꞉ Yu so aiyalma aya dla hetame yia꞉ta ma God mila꞉pi tle ullu pa꞉po ha꞉ha꞉lowedeme tea dapiyamte poyupo God dla halopiyo. Adipalati, Lod ya꞉ aiyalmata epo atlapo, “Wua꞉ seselema tea dapiyamte o hilipi tea yimlala dapiyamteye na꞉ dla poyupo halopiya,” depo. Epammama yia꞉ aiyalma aya dla hetame Yesuye ma God watle hamiyo. Adipalati, Lod ya꞉ aiyalmata epo atlapo, “Itapu hohomale akimlala hapulomaye God watle halopiya,” depo. ");
INSERT INTO xla_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Alila oloma edla Yelusalem dla totoyemala hale halaiyo, ya꞉ hiye Simiyon. Ya꞉ye God mila꞉pi tle ka꞉dle oplami halemama God tlo sikemte malahalemdiyo. Epapeleye ya꞉tapo Godta Isalael so dla upiyele ela e hamastlowe alilata puluwe dla dalemhalemama omhalaiyo. Epalati Hela꞉dle Sokotapo ya꞉ mate halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Amasiyama Hela꞉dle Sokota ka꞉yapa ya꞉ watle ma-atlaiyo, ya꞉tapo totoyemala ikadepe halemama Lodta sale Kelisoye natipame poloweye. ");
INSERT INTO xla_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Epapedeme Hela꞉dle Sokota Simiyonye aiyalma aya dla semhetlati Meli mate Yosep mate owayemala Yesuye aiyalma koko dolumolowedeme aiyalma aya dla hamame hetla natiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ya꞉ Yesu natipo hamame halemama God dla siyele yu atlaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ya꞉ta God dla siyele yu atlemama epo atlaiyo, “Lod, wa꞉ta na꞉ye Keliso natipame polope duwapo. Epedeme na꞉ siyema, wata na꞉tapo sadle mate poloweye. ");
INSERT INTO xla_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Adipalati, na꞉ inoma mate pasakalo gadlalo oplami, wa꞉tapo opa hapuloma dla hamiwaye na꞉ ma-natilipo. ");
INSERT INTO xla_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ya꞉ye hela꞉dlepo, po-Yu so opa dla God kokoye botomastlepo depame. Epame ya꞉tapo wa꞉ opa Isalael so dla hela꞉dleye hampulupe.” ");
INSERT INTO xla_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu ya꞉ a mate ya꞉ wai mate Simiyonta atlamale yu dalepame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Epame Simiyontapo God hi tle yia꞉ dla siyele hamimama Meli watle epo atlaiyo, “Godtapo maseyemala iye ma-sauwapo, Isalael so opita ya꞉ tle kustamtame teteyumha꞉ha꞉lati asiyama opitapo ya꞉ tle gadle hapame ma sillimha꞉ha꞉lepo depame. Epame opa opitapo ya꞉ koko haloweye allimama ya꞉ mate opahale dlepe. ");
INSERT INTO xla_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Epapele koko tle ya꞉tapo yia꞉ dupa dulu dla hemele koko hutiyeye haliyamale dla bobotimatimelepe. Epame dupa kolle kokotapo wa꞉ dupaye aipa꞉yata suma sepelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Oloma edla God tle yu hapame molo atlalo a꞉ya hale aiyalma aya dulu edla halaiyo, ya꞉ hiye Ana. Ya꞉ Asel elele halë a꞉yayo. Epame ya꞉ a hiye Panuwel. Ya꞉ ma-alluyemala halaiyo. Ya꞉ ka꞉yapa oplami hapame sokomoko 7 dulu dla oplami mate halepo depame ya꞉wolaliye mo-powaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Epame ya꞉ye dupulapi polomama 84 sokomoko umaiyo. Ya꞉ aiyalma ayaye posaliyome tlalo alila mate utula꞉la mate God hi di dla ta꞉demhalemama daya aiyalma depo inoma sumhalemdiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Epapeleye Simiyonta Meli mate Yosep mate yukamhallati ya꞉ ma oloma medla puaiyo. Ya꞉ puame God dla siyele yu atlemama Yelusalemye upiyele dulu tle alikili a꞉ma woyamolowe dla omha꞉ha꞉ so watle Yesu kokoye atlamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep mate Meli mate Lodta atlamale aiyalma koko hapulomaye ma-halopo gudepame ma Ga꞉lili mo dulu dla yia꞉ mo ikadepe Nasalet dla taiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Maseyemalatapo itiyamale mate ta꞉pame ka꞉depo malamaletapo ya꞉ dla pasatepo halaiyo. Epalati Godta bokotiyapo malamaleta ya꞉ mate halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sokomoko hapuloma dulu dla Yesu ya꞉ wai mate ya꞉ a mate Yelusalem dla Godta Namilatale daya dla hetamdiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sokomoko haleta yia꞉ matle Namilatale daya dlowedeme hetaiyo. Oloma edla Yesuye sokomoko 12 halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Epapeleye daya dele alilata mo-puame gudlati yia꞉ ma Nasalet mo dla ilame ma-taiyo. Amasiyama maseyemala Yesuye ya꞉ a mate ya꞉ wai mate podallalo Yelusalem dla me-halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Amasiyama ya꞉ a mate ya꞉ wai mate yia꞉ta malamaleta Yesuye semte yimkadulo mate ma-tamapo depame yia꞉ ma ma-tamalaiyo. Yia꞉ tame duka dla hutiyelowedeme popa꞉mama Yesuye yimkadulo dulu dla totamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yia꞉ edla totamama Yesuye ponatilalo wekelati ma ilame Yelusalem dla Yesu natila taiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yia꞉ Yesu totamale alila dapahatlope gudepame natilati Yesuye Yu so aiyalma aya dla aiyalma imalalo so mate yuhampopa꞉lati natiyo. Dulu edla Yesuta aiyalma imalalo sota imha꞉ha꞉lati dalempolomama asiyama atlanatili yu atlampolaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Epalati asiyama aiyalma imalalo sota atlanatili yu ipi dla ya꞉ta asiyama yu ka꞉ka꞉dle atlampolla dalepame opa hapulomata ya꞉ta malamale ka꞉pi natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yesu ya꞉ wai mate ya꞉ a mate Yesuta aiyalma imalalo so mate yukampollati natipame sikemte yiyeliyo. Epame ya꞉ waita epo atlaiyo, “Maseyemala, wa꞉ adipalati di watle ipapele koko hao? Wa꞉ a mate na꞉ mate wa꞉ totamsiyamama dupa sikemte kiyetame siyama,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Amasiyama Yesuta yia꞉ watle epo atlaiyo, “Wua꞉ adipalati na꞉ totamsiyamo? Wua꞉ powua꞉malamata꞉, na꞉ta na꞉ A aya dla halloweye?” diyo. ");
INSERT INTO xla_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amasiyama yia꞉ Yesu yu ya꞉ dulu kokoye woloma pomalamaiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Epame Yesuye ma yia꞉ mate Nasalet dla ilame taiyo. Epame edla yia꞉ mate halemama yia꞉ yu dla salladepo sela꞉iyo. Epapedeme Melitapo alila hapuloma dulu dla koko hapuloma iye me-malahalemdiyo. ");
INSERT INTO xla_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuye ta꞉mama ka꞉depo malamale mate ta꞉iyo. Epalati Godta ya꞉ dla siyemhallati opa ma ya꞉ dla sikemte sisiyemdiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibiliyes Sisata 15 sokomoko Loum dokopala oplami halale oloma edla opa iwolotapo ya꞉ isili tle dokopala popa꞉iyo, Pontes Paeletta Yudiya mo omhalaiyo, epalati Helodta Ga꞉lili mo omhalaiyo, epalati ya꞉ ei Pilipita Ituliya mo mate Tlakonitis mo mate omhalaiyo. Epalati Lisaniyasta Abilene mo omhalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Epalati Anas mate Kayapas mate Yu so aiyalma aya dokopala so ha꞉ha꞉iyo. Alila oloma edla Sekalaya yami Yonta dalupa dulu dla hallati God yuta ya꞉ dla puaiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Epalati ya꞉ tame Yoden aloma pili dla sela꞉mama opa watle God yuye epo atlamsela꞉iyo, “Wua꞉ bobtalimale tle heheletipame yú dla tutula꞉iya. Epalati Godtapo wua꞉ bobtalimaleye hiyotipo wellipe,” demsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Koko iye God tle yu hapame molo atlalo oplami Aisayata ya꞉ buka dla hatitimale yu mate ma-ala꞉po. Adipalati, ya꞉ta ya꞉ buka dla ipo ilimuwapo, “Oplami haletapo dalupa dulu dla yu ipo teta꞉mhalapo, ‘Lod apiye dinapiya. Epame ya꞉ apiye ka꞉depo dolepo himiya. ");
INSERT INTO xla_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Epame koloma walle apiye ma woloma kekesomaiya, apita woloma ka꞉depo ellepo depame. Epame api doduluwelalimaleye ma woloma ka꞉depo dololepo hatitimaiya. Epame api dla momkalalimale hapulomaye ma woloma badiya. ");
INSERT INTO xla_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Epalati opa hapulomatapo God tle pasakalo gadle puaye natilipo depame.’” ");
INSERT INTO xla_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Opa alumaleta Yonta yia꞉ye yú dla ka꞉ka꞉timelepo depo pumullati Yonta yia꞉ watle epo atlaiyo, “Wua꞉ye ilama yimlalapo. Antapo wua꞉ watle atlemama isikimi yú tutula꞉le kokota wua꞉ye Godta kasilamale pua tle hemele haohaodlepe duwa? ");
INSERT INTO xla_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wua꞉ta ha꞉ha꞉le pasakalo tle wua꞉ta wua꞉ bobtalimale tle ikadepe heheletimaleye nati-iya. Epame wuskamu wua꞉ tlo A꞉iblaham ya꞉ mamadulo depame Godta kasilamale tle hemele haohaodlepe demiya. Adipalati, na꞉ wua꞉ watle ikadepe koko atlema. God ya꞉ dla itiyamale elapo, ewala popa꞉ itapo ma A꞉iblaham ya꞉ mamadulo ikadepe yiyeloweye. ");
INSERT INTO xla_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mutupa꞉yatapo dali tou dla ma-dinapopame womelapo. Epedeme dali aditapo dlomoko ka꞉ka꞉dle pomilimalalo hallepiye, dali eye wostapame dlapa dla mistlepe.” ");
INSERT INTO xla_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Epalati opata Yon yu dalepame asiyama epo atlaiyo, “Ame di apa koko hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Epalati asiyama Yonta yia꞉ watle epo atlaiyo, “Wa꞉ dla sede dapiyamte hutiyelepiye, ka꞉dena, wa꞉tapo hale hame wa꞉ amkale sede pa꞉le oplami dla hamiloweye. Epame wa꞉ dla daya ellepiye, ka꞉dena, wa꞉tapo wa꞉ amkale daya pa꞉le oplami mate daya dloweye,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Epame ta꞉kis mani halomalalo so mape yia꞉ ma yú tutula꞉lowedeme Yon watle puame epo atlaiyo, “Imalalo oplami, di ma apa koko hapa꞉?” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yonta asiyama epo atlaiyo, “Wua꞉ta opa dla mani halomha꞉ha꞉mama seme wua꞉ta halowa depo malamama ta꞉kis mani himilowe saleye ase sikemte tla꞉mtame hademha꞉ha꞉miya. Amasiyama ala꞉le tlo opa dla hademha꞉ha꞉iya,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Epame opahale sota Yon watle epo atlaiyo, “Di ma apa koko hapa꞉?” diyo. Epalati asiyama Yontapo yia꞉ watle epo atlaiyo, “Wua꞉ yimkadulo mani uhalowedeme yia꞉ye ha꞉ha꞉limha꞉ha꞉miya. Epame yimkadulo mani uhalowedeme isikimi yia꞉ mala-atlamsiyamiya. Amasiyama isikimi wua꞉ta wua꞉ oko asiyama dla mani hademha꞉ha꞉ dla mepo ha꞉ha꞉iya,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Opa hapulomata Keliso tlo omha꞉ha꞉le dla Yonta pulati natipame yia꞉ta malamaleta Yonye semte Keliso tepo diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Amasiyama Yonta yia꞉ watle epo atlaiyo, “Na꞉tapo wua꞉ye isikimi yú siyapo dla ka꞉ka꞉tima. Amasiyama na꞉ ko tle pua oplamita itiyamaleta na꞉ tla꞉mtana. Epedeme na꞉ poka꞉dena, ya꞉ hete alisisi uptimoloweye. Ya꞉tapo wua꞉ye itiyamale hamimama Hela꞉dle Soko mate epo dlapa mate dla ka꞉ka꞉timelepe. ");
INSERT INTO xla_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ya꞉tapo witi daya mate epo daya kasili mate duka gladlowedeme ya꞉ oko alisisi mate ma-dinapopo halapo. Ya꞉ta witi daya mate epo kasili mate duka gladepame daya siyapo tlope aya dla kolumelepe. Epame asiyama daya kasili tlo posumtlalo wekelalo dlapa dla mistlepe.” ");
INSERT INTO xla_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yontapo ka꞉dle yu mate api meyelope meyelope dle tle opa elempuluwedeme God yu atlamsela꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Amasiyama Ga꞉lili mo dokopala oplami Helodta batalimale koko hamsela꞉mama ya꞉ ei ya꞉llu Helodiyasye kolahaiyo, ya꞉wolali me-hallati. Epalati Yonta koko i natipame ya꞉ atlemama ya꞉ batalimale opi mate ya꞉ dla bobotimatimaiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Epalati alotle Helodta siyaladepame ya꞉ batalimale pato hale hamama Yonye amtuwale aya dla ka꞉staiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yonta opa yú dla ka꞉ka꞉timhalale oloma edla Yesu ma yú dla ka꞉staiyo. Yesu yú tulupo hetame inoma sumhallati pepele di kokolomata gowaladiyo. ");
INSERT INTO xla_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Epalati Hela꞉dle Sokotapo seselema tea some ya꞉ dla malaiyo. Epalati pepele di tle yuta epo malaiyo, “Wa꞉ye na꞉ dupa ellalo maseyemala ikadepepo. Na꞉ wa꞉ dla sikemte siyema,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuye sokomoko 30 oloma dla halemama God yu atlowe mo-kotiyamaiyo. Opa hapulomatapo Yesuye Yosep yamipo depo malamdiyo. Yosep ya꞉ a hiye Heli, ");
INSERT INTO xla_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ya꞉ a hiye Matat, Matat ya꞉ a hiye Libai, Libai ya꞉ a hiye Melki, Melki ya꞉ a hiye Yanai, Yanai ya꞉ a hiye Yosep, ");
INSERT INTO xla_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosep ya꞉ a hiye Matatiyas, Matatiyas ya꞉ a hiye Amos, Amos ya꞉ a hiye Nahum, Nahum ya꞉ a hiye Esli, Esli ya꞉ a hiye Nagai, ");
INSERT INTO xla_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ya꞉ a hiye Mat, Mat ya꞉ a hiye Matatiyas, Matatiyas ya꞉ a hiye Semei, Semei ya꞉ a hiye Yosek, Yosek ya꞉ a hiye Yoda, ");
INSERT INTO xla_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ya꞉ a hiye Yowana, Yowana ya꞉ a hiye Lesa, Lesa ya꞉ a hiye Selubabel, Selubabel ya꞉ a hiye Selatiyel, Selatiyel ya꞉ a hiye Neli, ");
INSERT INTO xla_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli ya꞉ a hiye Melki, Melki ya꞉ a hiye Adi, Adi ya꞉ a hiye Kosam, Kosam ya꞉ a hiye Elmadam, Elmadam ya꞉ a hiye El, ");
INSERT INTO xla_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El ya꞉ a hiye Yosuwa, Yosuwa ya꞉ a hiye Eliyesel, Eliyesel ya꞉ a hiye Yolim, Yolim ya꞉ a hiye Matat, Matat ya꞉ a hiye Libai, ");
INSERT INTO xla_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai ya꞉ a hiye Simiyon, Simiyon ya꞉ a hiye Yuda, Yuda ya꞉ a hiye Yosep, Yosep ya꞉ a hiye Yonam, Yonam ya꞉ a hiye Eliyakim, ");
INSERT INTO xla_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ya꞉ a hiye Meleya, Meleya ya꞉ a hiye Mena, Mena ya꞉ a hiye Matata, Matata ya꞉ a hiye Neiten, Neiten ya꞉ a hiye Deibidi, ");
INSERT INTO xla_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibidi ya꞉ a hiye Yesi, Yesi ya꞉ a hiye Obed, Obed ya꞉ a hiye Boas, Boas ya꞉ a hiye Salmon, Salmon ya꞉ a hiye Nason, ");
INSERT INTO xla_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ya꞉ a hiye Aminadab, Aminadab ya꞉ a hiye Adimin, Adimin ya꞉ a hiye Alni, Alni ya꞉ a hiye Heslon, Heslon ya꞉ a hiye Peles, Peles ya꞉ a hiye Yuda, ");
INSERT INTO xla_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda ya꞉ a hiye Yokob, Yokob ya꞉ a hiye Aisek, Aisek ya꞉ a hiye A꞉iblaham, A꞉iblaham ya꞉ a hiye Tela, Tela ya꞉ a hiye Nahol, ");
INSERT INTO xla_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol ya꞉ a hiye Selug, Selug ya꞉ a hiye Leu, Leu ya꞉ a hiye Peleg, Peleg ya꞉ a hiye Ebel, Ebel ya꞉ a hiye Sala, ");
INSERT INTO xla_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ya꞉ a hiye Keinan, Keinan ya꞉ a hiye Alpaksad, Alpaksad ya꞉ a hiye Sem, Sem ya꞉ a hiye Nowa, Nowa ya꞉ a hiye Lamek, ");
INSERT INTO xla_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ya꞉ a hiye Metusela, Metusela ya꞉ a hiye Inok, Inok ya꞉ a hiye Yaled, Yaled ya꞉ a hiye Mahalael, Mahalael ya꞉ a hiye Keinan, ");
INSERT INTO xla_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinan ya꞉ a hiye Enos, Enos ya꞉ a hiye Set, Set ya꞉ a hiye A꞉dam, A꞉dam ya꞉ aye God. ");
INSERT INTO xla_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuta Yoden aloma tle ma ilamtlati Hela꞉dle Sokota ya꞉ dla pasatapame ya꞉ye dalupa dulu dla semtaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya꞉ 40 alila dalupa dulu dla hallati Saitentapo ya꞉ye elemala natimhalemdiyo. Ya꞉ alila dulu edla sela꞉mama daya dimi halaiyo. Epo 40 alila eta tame gudlati ya꞉ dla daya ta꞉leta puaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Epela natipame Saitenta ya꞉ watle epo atlaiyo, “Wa꞉ ikadepe God Yami dlepiye, wa꞉ ewala ela i atlane daya yelepo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Amasiyama Yesuta epo atlaiyo, “God yu bukata epo atlapo, ‘Oplamitapo daya siyapo tlo demhalemama pasakalo pohallowa,’” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Saiten matle Yesu seme tamali di dla hetaiyo. Epame Saitenta Yesu watle pakasiyamalalo ta꞉lamo pato hapulomaye nalati-iyo. ");
INSERT INTO xla_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Epo Yesu watle epo atlaiyo, “Ka꞉yapa Godta alisisi hapuloma iye na꞉ watle hapilati na꞉tapo omhaluwapo. Amasiyama wa꞉ wata na꞉ dla heodepo siyele ta꞉dlepiye, ta꞉lamo pato i mate epo alisisi hapuloma dulu dla ha꞉ha꞉ mate wa꞉ watle hapilowepo. Adipalati, na꞉ dla itiyamale elapo, ma oplami hale dla hapiloweye.” ");
INSERT INTO xla_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Epalati Yesuta asiyama Saiten watle epo atlaiyo, “God yu bukata epo atlapo, ‘Wa꞉ hatlo Lod wa꞉ God dla heodepo siyele ta꞉demama ya꞉ yu dla salladepo sela꞉ne.’” ");
INSERT INTO xla_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Epame matle Saitenta Yesu seme Yelusalem dla taiyo. Epame aiyalma aya dopuko di ikadepe dla Yesuye seme hetame pamelepame ya꞉ watle epo atlaiyo, “Wa꞉ ikadepe God Yami dlepiye, wa꞉ dopuko di itle ta꞉la dla putuko dene. ");
INSERT INTO xla_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Adipalati, God yu bukata epo atlapo, ‘Godtapo ya꞉ banakaka so watle, wa꞉ye woloma omha꞉ha꞉iya, dlepe. ");
INSERT INTO xla_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Epalati yia꞉tapo wa꞉ye yia꞉ dota hamelepe, wa꞉ heteta tulume ewala dla heyulala depame.’” ");
INSERT INTO xla_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Asiyama Yesuta epo atlaiyo, “God yu bukata ma epo atlapo, ‘Wa꞉ Lod wa꞉ Godta itiyamale natilowedeme ya꞉ye elemala natimiya,’” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saitenta Yesuye elemala natimsela꞉le mogudlati ma ilampuluwe malamama aseka alila yimka꞉mala dla Yesu saliyome taiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Yesuye Hela꞉dle Sokota pasatapame itiyamale mate ma Ga꞉lili dla ilame taiyo. Epame ya꞉tapo Yu so inoma sumalalo aya hapuloma dla imsela꞉lati opata ya꞉ dla sisiyemdiyo. Epalati Ga꞉lili mo pato dulu dla opa hapulomata Yesu koko dlalemtaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Alila haleta Yesu ya꞉ta ta꞉le mo ikadepe Nasalet dla taiyo. Epame Yu sota inoma sumalalo alila dla ya꞉ ma meyelo aplalo epammama yia꞉ta inoma sumalalo aya dla hetame halemama God yu buka sesa꞉lowedeme sila꞉tiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Epalati God tle yu hapame molo atlalo oplami Aisayata ilimale bukaye ya꞉ watle hamiyo. Ya꞉ buka hapame dollomtame yu hatitimale oloma hema gowaladepo yu iye sesa꞉iyo, ");
INSERT INTO xla_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lod ya꞉ Hela꞉dle Sokoye na꞉ mate halapo. Adipalati, ya꞉tapo na꞉ye sauwapo, ka꞉dle yuye atali so dla hampulupo depame. Epame ya꞉tapo na꞉ye tane duwapo, amtuwale aya dulu dla deata popoliyepo ha꞉ha꞉ soye dea totowatimelepo depame. Epame inoma pa꞉talo sota matle ka꞉depo tlamelepo depame. Epame Lodtapo na꞉ye tane duwapo, opata allimha꞉ha꞉ soye upiyele etle elepame alikili dla woyamelepo depame. ");
INSERT INTO xla_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Epame na꞉tapo Lodta namkale dle alilata puaye opa watle imolowedeme.” ");
INSERT INTO xla_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu buka sesa꞉po gudepame ma ilame buka omhallalo watle hamipame polaiyo. Epalati opa hapuloma aya dulu edla popa꞉le sotapo Yesu watle woloma inoma kokata omhutiyeiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Epame ya꞉ta yia꞉ watle epo atlaiyo, “Wua꞉ta God yu buka dla atla dalle kokotapo wata wua꞉ dla mo-woyamalepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Epalati ya꞉ yu dallalo so opa hapulomatapo ya꞉ye ka꞉dle oplami depame ya꞉ta atlamale yu ma ka꞉pi diyo. Yia꞉ epo atlepame ma epo atlamyaiyo, “Dimalamana, ya꞉ye Yosep yamipo. Epapele tlope ya꞉ adipammama yu ipo ka꞉pi atlo?” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuta ma yia꞉ watle epo atlaiyo, “Na꞉ mikadepe dema, wua꞉tapo na꞉ watle epo atlamyelepe, ‘Dakopala ilalo oplami, wa꞉skamu wa꞉ ka꞉dene. Epame wa꞉ta Kapaniyem mo dla ulugiyemale koko halomuwaye ma wa꞉ mo ikadepe hema halomane,’ demyelepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Amasiyama Yesu ma yia꞉ watle epo atlaiyo, “God tle yu hapame molo atlalo oplamiye ya꞉ mo so ikadepeta allipe. ");
INSERT INTO xla_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Epedeme wua꞉ daliya, Ilayata halale oloma edla sali silaple patota puwapo. Epalati sokomoko dapahatlope epo mama 6 dulu dla tiyota pehellalo haluwapo. Oloma edla Isalael mo dla dupulapitalo me-popa꞉uwapo. ");
INSERT INTO xla_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amasiyama dulu edla Godta Ilayaye yia꞉ gadlepo depame po-atlana. Amasiyama ya꞉ Ilayaye isikimi po-Yu a꞉ya Saidon mo dulu dla mo hale Salipat dla pollalo dupulapi tlo gadla tane duwapo. ");
INSERT INTO xla_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Epame ma Ilaisata halale oloma edla Isalael mo dla kapala bobtalimale sota wokasepo ha꞉ha꞉uwapo. Amasiyama Ilaisata opa ewoloye pogadena. Amasiyama ya꞉ po-Yu oplami Naman, Siliya mo dla hallalo tlo gademama ya꞉ye ka꞉duwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Opa inoma sumalalo aya dla popa꞉leta yu i dalepame sikemte siyalasiyaladiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Epame yia꞉ sillipame Yesuye hamame tamalaiyo, mo alikili dla tei seselemale halale di tle ka꞉stlowedeme. ");
INSERT INTO xla_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amasiyama Yesu opa alumale dulu metle alikili a꞉ma woyapame taiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Epame Yesu matle Ga꞉lili mo dulu dla mo hale Kapaniyem mo dla taiyo. Ya꞉ edla tame halemama inoma sumalalo alila haleta yia꞉ta inoma sumalalo aya dla hetame God yuye imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Epalati opata ya꞉ta imale dalepame sikemte yiyeliyo. Adipalati, ya꞉ye sikemte itiyamale mate imhalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Inoma sumalalo aya edla bataliya walle oplami hale polaiyo. Ya꞉tapo yu teta꞉le mate Yesu watle epo atlaiyo, ");
INSERT INTO xla_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei, Yesu Nasalet oplami, wa꞉ dia꞉ dla apa koko hala puo? Wa꞉ di bobtalimala puo? Amasiyama wa꞉ di meleme tane. Adipalati, na꞉malamana, wa꞉ye God tle malale aiyalma oplamipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Epalati Yesuta bataliya yemala watle itiyamale mate epo atlaiyo, “Wa꞉ keidepame oplami dulu etle alikili dla ulatane,” diyo. Yesuta epo atlati bataliya yemalatapo ulatlowedeme oplamiye opa inoma dali dla ka꞉stapame wa꞉ya dla teyume ellati ya꞉ tle alikili dla ulataiyo. Amasiyama bataliya yemalata ya꞉ tle ulatamama ya꞉ dla wotiyalle hale pohamilalo wekiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Epalati opatapo koko i natipame yiyelle mate epo atlamyaiyo, “Ya꞉ta atlale kokoye adipapeta꞉? Adipalati, ya꞉tapo itiyamale mate bataliya yimlala watle yu atlati yia꞉tapo ya꞉ yu dla dalepo salladepame alikili dla u-ulapo tamdepo,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Epalati opatapo koko i natipame mo opi edla popa꞉mta dla esemtaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu inoma sumalalo aya tle ma Saimon aya dla taiyo. Aya dulu edla a꞉ya hale Saimon ya꞉ dokoye esiyeme elaiyo. Epalati opatapo ya꞉ye Yesuta ka꞉dlepo depame Yesuye atlaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Epalati Yesuta tuame ya꞉ta ela mateka꞉pi dla halemama esiyele alikili dla ayalemama epo atlaiyo, “Wa꞉ ya꞉ tle alikili a꞉ma woyamane,” diyo. Epalati pakasiyamalalo esiyeleta ya꞉ tle ma-hawa hallati ya꞉tapo ma-ka꞉depame sila꞉tipo daya ha꞉po yia꞉ watle alemaiyo. ");
INSERT INTO xla_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Salita mo-tullati opata esusulumale so hapulomaye Yesu watle eleme pumhalaiyo. Epalati ya꞉tapo ya꞉ do mate esusulumale so hapulomaye hohopame ka꞉ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Epame Yesuta bataliya watalo soye ka꞉ka꞉dlati bataliya yimlalata yia꞉ tle u-ulapo tamhalemama yu teta꞉le mate “Wa꞉ye God Yamipo,” demyaiyo. Amasiyama Yesuta itiyamale mate yia꞉ watle epo atlaiyo, “Wua꞉ yuhamiya,” diyo. Adipalati, bataliya yimlalaye yia꞉malamana, Yesuye Godta sale Kelisopo. ");
INSERT INTO xla_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma utulala ikadepe Yesu elale tle sila꞉time keilipo elale mo dla taiyo. Amasiyama ya꞉ ko dla opatapo ya꞉ hawa hallati ya꞉ totamsiyamaiyo. Opata Yesu totamtame natipame ya꞉ watle epo atlaiyo, “Wa꞉ di saliyome tamiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amasiyama Yesutapo yia꞉ watle epo atlaiyo, “Na꞉ ka꞉dena, mo opi dla ma God ya꞉ mo kokoye atlamtloweye. Adipalati, Godta koko edla na꞉ye tane duwapo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Epame Yesutapo Yu so mo pato dla yia꞉ta inoma sumalalo aya hapuloma dla God yu imsela꞉mdiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Alila hale dla Yesuta Ga꞉lili kaula peleyama dla God yu atlemhallati opa hapulomata dallowedeme alumama sikemte kustimtame elaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu me-halemama amalo halomalalo sota yia꞉ mata howahalomolowedeme koa dapiyamte tamali di dla hallumhetame hatitimaleye natiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu koa dapiyamte dulu dla Saimon koa dla tulume polomama Saimon watle, “Koaye yú duka tiyama dla akustane,” diyo. Epame koa dulu etle polomama opata tamali di dla popa꞉lati God yu impolaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu opa dla God yu atlepo gudepame Saimon watle epo atlaiyo, “Wa꞉ koa yú duka dla solemtuame wua꞉ amkadulo mate wua꞉ mataye amalo tulupo depame yú dulu dla pololiya,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Amasiyama Saimonta epo atlaiyo, “Imalalo oplami, di wata utula꞉la mata pololemsiyamama oko pato ha, epele tlope amalo pohana. Amasiyama wa꞉ta atlademe na꞉ mataye yú dulu dla polollowepo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yia꞉ epame yia꞉ mataye yú dulu dla polollati amalo hapulomata yia꞉ mata dulu dla tumama yia꞉ mataye tallatalladla yakomaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Epalati yia꞉tapo yimkadulo koa hale dla ha꞉ha꞉lalo soye do yu mate sisilamaiyo, yia꞉ gadlepo depame. Epo yia꞉ta mo-pulati yia꞉ koa dapiyamteye amalota sikemte poposatilimama koa ollo-ollodla yakomaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pitata koko i natipame Yesu hete sitali dla heodepo polomama epo atlaiyo, “Lod, na꞉ tle alikili a꞉ma tane, na꞉ye batalimale oplami,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Adipalati, ya꞉ mate ya꞉mkadulo mate yia꞉ta amalo hapuloma halomale natipame sikemte yiyeliyo. ");
INSERT INTO xla_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Epame Saimon mate oko halalo so Yeims mate Yon mate yia꞉ ma koko i natipame sikemte yiyeliyo. Opa dapiyamte Yeims mate Yon mate iwoloye Sebedi ya꞉ akimlalayo. Epame Yesuta Saimon watle epo atlaiyo, “Wa꞉ ase sikemte wota꞉miya. Wa꞉ ka꞉yapa amalo halomalalo haluwapo. Amasiyama wata oloma itle wa꞉ye ma opaye God dla elempulalo hallepe,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Epame yia꞉ tame yia꞉ koaye tamali dla himpame alisisi hapuloma medla salepame ma Yesu mate tamalaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Alila haleta Yesu ma mo hale dla taiyo. Mo edla kapala batalimale oplami halaiyo. Oplami itapo Yesu natipame Yesu hete sitali dla heodepo polomama epo atlaiyo, “Lod, wa꞉ na꞉ ka꞉dlowe solotamelepiye, na꞉ ka꞉dene,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Epalati Yesuta ya꞉ do mate oplami ya꞉ dla ummama epo atlaiyo, “Na꞉ wa꞉ ka꞉dlowe solotama, epedeme wa꞉ ma-ka꞉dene,” diyo. Epalati pakasiyamalalo ya꞉ kapala batalimaleta ma-ka꞉diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Epame Yesuta ya꞉ watle yu itiyamale mate epo atlaiyo, “Wa꞉ tame opa opi watle na꞉ta wa꞉ ka꞉dle kokoye atlemiyo. Amasiyama wa꞉ tame God ka꞉ epo opa ka꞉ duka dla hallalo oplami watle wa꞉ kapalata ka꞉dle kokoye nati-ine. Epame wa꞉ta ka꞉dle koko dla Mosesta atlale namkale dle alisisi mate God watle hapine, opata koko etle wa꞉ta ka꞉dle kokoye malanatilipo depame,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Epapele tlope opatapo Yesu kokoye mo hapuloma dla esemtlati opa hapulomata ma-dlalemtaiyo. Epalati opa hapulomata Yesuta God yu atla dallowedeme pumhalaiyo. Epame ya꞉ta yia꞉ dla esusulumale hutiyeye ka꞉ka꞉dlepo depame. ");
INSERT INTO xla_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amasiyama ya꞉ alila hapuloma opa hapuloma tle alikili dla woyapame meyelo homta ellalo mo dla inoma sumala tamdiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Alila haleta Yesu opa imhallati Pa꞉lisi so mate aiyalma imalalo so mate yia꞉ ma medla popa꞉iyo. Opa iwoloye opita Ga꞉lili mo hapuloma tle epo opita Yudiya tle epame opita Yelusalem tle pumulaiyo. Epalati Yesutapo esusulumale so ka꞉ka꞉dlepo depame Lodta itiyamaleta ya꞉ mate halaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Epalati oloma edla opa opita akoloyale oplamiye dea tili dla himpo Yesuta hala aya dla hamame pumulaiyo. Yia꞉ solotamaiyo, Yesu hala dla hamame tuluwedeme. ");
INSERT INTO xla_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amasiyama opata kustimama api ponatiyo. Yia꞉ epalati oplami akoloyaleye dea tili dla himili memmate aya dopuko di dla hamame hetaiyo. Epame aya dopuko di tle opokoko pokolopame dea tili mate Yesuta hala oloma dla halumtuluiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Epalati Yesu yia꞉ta mikadepe dle natipame akoloyale oplami watle epo atlaiyo, “Namkale, wa꞉ bobtalimaleye mo-hiyotipame wellipo,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amasiyama edla popa꞉le aiyalma imalalo so mate epo Pa꞉lisi so mateta ya꞉ yu dalepame epo momalampopa꞉iyo, “Oplami i anata꞉? Ya꞉ God hi mate putlopo atlalepo. Adipalati, hatlo God tlo ya꞉ dla batalimale hiyotimolowe itiyamale elapo,” dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amasiyama Yesu yia꞉ta momalamale ma-natipame epo atlaiyo, “Wua꞉ adipalati na꞉ta atlale koko dla sikemte momalampopa꞉mama allimpopa꞉ma꞉? ");
INSERT INTO xla_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wua꞉ akoloyale oplami i natiya. Ya꞉ dla adipo atlowe tlo kokaleta꞉? ‘Na꞉ta wa꞉ batalimaleye ma-hiyostalepo,’ dlowe kokota kokaleta꞉? O, ‘Wa꞉ sila꞉time ma-tane,’ dlowe kokota kokaleta꞉? ");
INSERT INTO xla_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Epedeme Opa Yamita ta꞉lamo hema batalimale hiyotimolowe dla itiyamale hamsela꞉ye wua꞉ta natilipo depame na꞉tapo wata akoloyale oplami iye ka꞉dlowepo,” diyo. Epo atlepame Yesuta akoloyale oplami dla omhalemama ya꞉ watle epo atlaiyo, “Na꞉ta wa꞉ dla atlema, wa꞉ sila꞉time wa꞉ wa꞉ya hame wa꞉ aya dla ma-tane,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Epalati akoloyale oplamita pakasiyamalalo yia꞉ inoma dali dla sila꞉time ya꞉ wa꞉ya hame ma-tamama God dla siyele ta꞉demtaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Opa hapulomatapo koko i natipo yiyelepame wowota꞉le mate God dla siyele ta꞉demama epo atlamyaiyo, “Di wata pta ulugiyemale koko pato nati,” demyaiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Koko ita tame gudlati alotle Yesu aya dulu tle alikili dla woyapo taiyo. Ya꞉ tamama natilati ta꞉kis mani halomalalo oplami Libaita ta꞉kis halomalalo aya dulu dla polla natiyo. Epalati ya꞉ watle epo atlaiyo, “Wa꞉ na꞉ dolumpuane,” diyo. ");
INSERT INTO xla_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Epalati Libaita sila꞉time alisisi hapuloma medla pomelepame Yesu mate taiyo. ");
INSERT INTO xla_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Epame Libaita Yesu watle daya pato dinapiyo. Epalati ta꞉kis mani halomalalo so hapuloma mate epo opa opi mate puame aya edla Yesu mate daya dempopa꞉iyo. ");
INSERT INTO xla_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Amasiyama Pa꞉lisi so mate epo aiyalma imalalo so m