﻿USE sofia;
DROP TABLE IF EXISTS sofia.xed_vpl;
CREATE TABLE xed_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xed_vpl WRITE;
INSERT INTO xed_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wya ka tva saba mndəra taŋ ma Yesu Kristi zivra Dawuda. Dawuda guli ná, zivra Abraham ya. ");
INSERT INTO xed_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ta yatá Izak, Izak ta yatá Yakubu, Yakubu ta yatá Yuda nda zwanamani. ");
INSERT INTO xed_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ta yatá i Peres nda Zara (Tamar na ma taŋ,) Peres ta yatá Isrum, Isrum ta yatá Aram, ");
INSERT INTO xed_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ta yatá Aminadap, Aminadap ta yatá Nasuŋ, Nasuŋ ta yatá Salmuŋ, ");
INSERT INTO xed_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuŋ ta yatá Buwaz (Rahab na mani,) Buwaz ta yatá Ubet (Rut na mani,) Ubet ta yatá Yesay, ");
INSERT INTO xed_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesay ta yatá Dawuda. Ka yatá mgham Dawuda ta Salumuŋ (si markwa Uriya na mani,) ");
INSERT INTO xed_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salumuŋ ta yatá Rubuwam, Rubuwam ta yatá Abiya, Abiya ta yatá Asa, ");
INSERT INTO xed_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ta yatá Yusafat, Yusafat ta yatá Yuram, Yuram ta yatá Uziyas, ");
INSERT INTO xed_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziyas ta yatá Yuwatam, Yuwatam ta yatá Akaz, Akaz ta yatá Izekiyas, ");
INSERT INTO xed_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Izekiyas ta yatá Manasa, Manasa ta yatá Amuŋ, Amuŋ ta yatá Yuziyas, ");
INSERT INTO xed_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yuziyas ta yatá Yukwaniyas nda zwanamani. Ta tsa fitik ya, hlaghata lu ta la Israʼila ta haɗika Babila. ");
INSERT INTO xed_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tahula hlaghata lu ta həŋ ta haɗika Babila, ka yatá Yukwaniyas ta Salatiyel, Salatiyel ta yatá Zwarubabel, ");
INSERT INTO xed_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zwarubabel ta yatá Abiyuda, Abiyuda ta yatá Iliyakim, Iliyakim ta yatá Azura, ");
INSERT INTO xed_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azura ta yatá Saduka, Saduka ta yatá Akim, Akim ta yatá Iliyuda, ");
INSERT INTO xed_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iliyuda ta yatá Iliyazar, Iliyazar ta yatá Mataŋ, Mataŋ ta yatá Yakubu, ");
INSERT INTO xed_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu ta yatá Yusufu ta nzakway ka zəʼala Mari. Tsa Mari ya ta yatá Yesu ta hgə lu ka Kristi. ");
INSERT INTO xed_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Zlrafta ta Abraham ka sagha ta Dawuda ná, ghwaŋpɗə fwaɗ da mida. Zlrafta ta Dawuda ka lagha ta fitika hlaghatá la Israʼila ta haɗika Babila guli ná, ghwaŋpɗə fwaɗ da mida. Zlrafta ta fitika hlaghatá la Israʼila ta haɗika Babila ka sagha ta Kristi guli ná, ghwaŋpɗə fwaɗ da mida. ");
INSERT INTO xed_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wya ka lu yatá Yesu Kristi. Mari mani ma Yesu ná, Yusufu ta dzugway. Ta kul kluvtá həŋ ta vgha, ka zlghanavatá Sulkum nda ghuɓa ta huɗi ta Mari. ");
INSERT INTO xed_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tsa zwaŋa midzani Yusufu ya ná, ŋərma mndu ya. Va a ta pghanaghatá hula ta makumidzani wa. Ka kumə tsi ta zlanavatá tsa makwa ya ma kɗek ma kɗek. ");
INSERT INTO xed_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tata ndanay ndanay tsatsi ta zlanavata, ka lagha duhwala Mgham Lazglafta da sunani. «Yusufu zivra Dawuda, ma zləŋ ka ta kla Mari ŋa nzakway ka markwa ghuni. Tsa huɗi zlghaf tsi ya ná, Sulkum nda ghuɓa ta zlghanavata. ");
INSERT INTO xed_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Zwaŋa zgun dzaʼa tsi yatá, ŋa tsanaftá gha ta hgani ka Yesu, kabga tsatsi dzaʼa mbanaftá mnduhani ma dmakuha taŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inda tsaya ná, magu maga ŋa dzanaghatá ghəŋa skwi ya mnigiŋ Mgham Lazglafta nda ma wa anabi kazlay: ");
INSERT INTO xed_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Wya dzaʼa zlghafzlgha daghala makwa ta kul snaŋtá zgun ta huɗi, ŋa yatani ta zwaŋa zgun, ŋa tsanaftá hgani ka Emanuwel,» manda mnay kazlay: Kawadaga Lazglafta nda amu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sliʼavata Yusufu, ka snatá tsi ta tsa gwaɗa mnana duhwala Mgham Lazglafta ya. Ka klaftá tsi ta Mari ŋa nzakway ka markwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Walaŋ a Yusufu ta ksaŋtá tsa makwa ya wa. Tahula dgatani zlra tsi ta ksaŋta. Ka tsanaftá tsi ta hga tsa zwaŋ ya ka Yesu. ");
INSERT INTO xed_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ma luwa Batlehem ta haɗika Zudiya yatá lu ta Yesu, ma fitika gay Hiridus ta mghamani hada. Tahula yata, ka sliʼaftá gwal nda sna ta skwi ta ghəŋa tekwatsa daga ma mndəra luwa ka safi da luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ka ɗawaŋtá həŋ: «Ga tsa zwaŋ yaga lu ka lfiɗ Mghama la Yahuda ya na? Nda ngha ŋni ta tekwatsani ta zlagapta daga ma mndəra luwa kəl ŋni ka safi da tsəlɓu ta kəmani.» ");
INSERT INTO xed_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Snaŋta mgham Hiridus ta tsa gwaɗa ya, tsiɓak ma vghani. Mantsaya inda gwal ma luwa Ursalima guli. ");
INSERT INTO xed_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ka tskanatá tsi ta inda gwal mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha. Ka ɗawu tsi da həŋ: «Ga tsa vli dzaʼa yata lu ta Kristi ya na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka həŋ nda tsi mantsa: «Ma luwa Batlehem ta haɗika Zudiya dzaʼa yatá lu, kabga wya ka anabi vindafta: ");
INSERT INTO xed_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Kagha luwa Batlehem ta haɗika Yahuda. Hta a nzakwa gha mataba luwaha ya ta haɗika Yahuda wu, kabga ga ghuni dzaʼa saba Mgham dzaʼa ngha mnduha ɗa la Israʼila,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ka hgaftá mgham Hiridus ta tsa gwal nda sna ta skwi ta ghəŋa tekwatsa ya ma kɗek ma kɗek, ka ɗawaŋtá tsi da həŋ: «Yawu zlagapta tsa tekwatsa ya na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ka ghunaftá tsi ta həŋ da Batlehem, kaʼa mantsa: «Lawala, ka zbapta kuni ɗina ta gwaɗa ta tsa zwaŋ ya. Ka slafsla kuni tida katsi, ka vrakta kuni da mnihata ŋa dzaʼa vərɗa iʼi guli da tsəlɓu ta kəmani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kɗakwa taŋ ta snamtá tsa gwaɗa mgham ya, ka sliʼaftá həŋ ka dzaʼa. Ka nghəglaŋtá həŋ ta tsa tekwatsa si nghaŋ həŋ daga ma mndəra luwa ya kay ta mbaɗa ta kəma taŋ. Ɓhadaghatani da tsa vli nda tsa zwaŋ ya, ka sladata tsi. ");
INSERT INTO xed_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nghay taŋ ta sladata tsa tekwatsa ya, ka tuta ŋuɗufa taŋ da rfu katakata. ");
INSERT INTO xed_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ka lamə həŋ da həga. Ka slanaghatá həŋ ta tsa zwaŋ ya nda Mari ta nzakway ka mani. Ka tsəlɓatá həŋ ta kəma tsa zwaŋ ya, ka vlaŋtá həŋ ta glaku. Ka palanaptá həŋ ta zlibiha taŋ, ka mbəhatá həŋ nda dasu, nda urdi ŋa dray nda dra, nda mandaɓaya urdi. ");
INSERT INTO xed_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tahula tsa ka mnanatá Lazglafta ta həŋ nda ma suni kazlay: Yahayaha həŋ da vradaghata nda da Hiridus kəʼa. Ka sliʼaftá həŋ ka vraghata da luwa taŋ nda ta sana tvi. ");
INSERT INTO xed_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tahula laghwa taŋ, ka lagha sana duhwala Mgham Lazglafta da suna Yusufu. Kaʼa nda tsi mantsa: «Sliʼafsliʼa, kla ta na zwaŋ na nda mani ka hwayaghata ka nda həŋ ta haɗika Masar, ka nzata ka hada. Iʼi dzaʼa mnaghata kada vrakta ka. Ya dzaʼa zbay Hiridus ta na zwaŋ na ŋa dzata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ka sliʼaftá Yusufu, ka hlaftá tsi ta i tsa zwaŋ ya nda mani girviɗik ka laghwi ta haɗika Masar. ");
INSERT INTO xed_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ka nzatá tsi hada ha ka sagha fitika mta ta mgham Hiridus. Mantsa kəʼa maguta ŋa dzanaghatá ghəŋa gwaɗa mna Mgham Lazglafta nda ma wa anabi, kaʼa mantsa: «Ma haɗika Masar hgagapta yu ta zwaŋa ɗa,» kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kəʼa ka Hiridus ná, hiɗaku hiɗanagha tsa gwal nda snatá skwi ta ghəŋa tekwatsa ya. Ka kuzlanaftá tsi ta ŋuɗuf. Tsaw mnanamna tsa gwal nda sna ta skwi ta ghəŋa tekwatsa ya kay ta fitika zlagapta tsa tekwatsa ya, kəl tsi ka mnay: Lawa pslihatá inda zwana zgwana yaga lu hadahada ha ka klaftá imi his ma luwa Batlehem, nda ya ma inda vli ta wanafta kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma tsa fitik ya dzatá ghəŋa gwaɗa ya mna anabi Irmiya. Kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ta snaku hlawi ma Rama. Ta snaku lili nda ŋaɗa ghəŋ. Rahila ya ta tawa zwanani, va a ta lɓanatá ŋuɗuf wu kabga rwurwa həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manda mtatá mgham Hiridus, ka ləglagha duhwala Mgham Lazglafta da suna Yusufu ma haɗika Masar. ");
INSERT INTO xed_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kaʼa mantsa: «Sliʼafsliʼa, ka kla ka ta na zwaŋ na nda mani, ka dzaʼa ka ta haɗika Israʼila kabga nda rwa tsa gwal ta zba dzatá na zwaŋ na ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ka sliʼaftá Yusufu, ka hlaftá tsi ta i tsa zwaŋ ya nda mani, ka laghwi ta haɗika la Israʼila. ");
INSERT INTO xed_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama snaŋtani kazlay: Zwaŋa Hiridus ta nzakway ka Arkilayus ta ga mgham ta haɗika Zudiya kəʼa, ka zləŋaftá tsi ta dzaʼa da hada. Tahula mnanaŋta Mgham Lazglafta nda ma suni, ka mbəɗaghatá tsi ta vgha ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ka laghu tsi nzata ma sana luwa ta hgu lu ka Nazaret. Nda nza mantsaya ŋa dzanaghatá ghəŋa gwaɗa ya mana la anabiha, ka həŋ mantsa: «Mnda la Nazaret dzaʼa hga lu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma tsa fitik ya, ka zlagaptá Yuhwana mnda maga batem ma mtak ta haɗika Zudiya, kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Mbəɗanafwa mbəɗa ta nzakwa ghuni, kabga ndusa ga mghama Lazglafta ka sagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ka anabi Isaya mnuta mantsa: «Mamu sana mndu ta guguɗaku ma mtak. Kaʼa mantsa: “Payanawa tva Mgham Lazglafta, ka leleʼanata kuni ndəɗap,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Gatá lguta swida ŋalibwa ta suɗə Yuhwana ta vgha nda hbatá ɓanava huta misti. Hiʼi nda zuɗuma mtak skwa zayni. ");
INSERT INTO xed_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka sliʼadaghatá gwal ta sliʼafta ma luwa Ursalima, nda inda gwal ta haɗika Zudiya, nda inda gwal ta haɗikha ta wanafta ghwa Zurdeŋ, ka lagha da tsi. ");
INSERT INTO xed_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ka manigiŋtá həŋ ta dmakuha taŋ, ka maganaftá tsi ta batem ta həŋ ma ghwa Zurdeŋ. ");
INSERT INTO xed_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nghay Yuhwana ta ndəghadaghata la Farisa nda la Sadukiya ta sliʼadaghata da tsi, ŋa maganaftani ta batem ta həŋ ná, kaʼa nda həŋ mantsa: «Mndəra la mupuhwa! Waya ta mnaghunatá hwayapta ma tsa ɓasatá ŋuɗufa Lazglafta dzaʼa sagha ya na? ");
INSERT INTO xed_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ka maga kuni tama ta slna dzaʼa maraŋtá mbəɗata nzakwa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma fa kuni ta ndana ghuni kazlay: Abraham na Da ŋni kəʼa. Ka yu ta mnaghunata na: laviŋlava Lazglafta ta mbəɗanaftá na palaha na ŋa nzakwa taŋ ka zwana Abraham. ");
INSERT INTO xed_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nda ghada fata wa slpaɗa mista fuha ŋa ratsiŋta nda slrəŋ nda slrəŋ. Inda fu kul zɗaku yakwani, dzaʼa tsiŋtsa lu ka vzamta ma vu. ");
INSERT INTO xed_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iʼi ná, nda imi ta magaghunafta yu ta batem ŋa maraŋtá ta mbəɗata nzakwa ghuni. Ama tsa mndu ta sagha nda hula ɗa ya ná, mal ŋani glaku ka ŋa ɗa. Slaghu a yu dər ŋa hlaptá ɓaɓah ma səlani wa. Tsatsi ná, dzaʼa magaghunafmaga ta batem nda Sulkum nda ghuɓa nda ya nda vu. ");
INSERT INTO xed_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mamu kuwatavihi ma dzvani ta wa blikwi ŋa vihaptá hyani, ŋa dganatá sabatbat nda hənzila hya ŋa pghamtani ta hyani ma guvur. Ama ŋa driŋtani ta sabatbat, nda vu kul haɗ ta mtavata ɗekɗek,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ka sliʼaftá Yesu ta haɗika Galili, ka lagha ta wa ghwa Zurdeŋ slanaghatá Yuhwana ŋa maganaftani ta batem. ");
INSERT INTO xed_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ka Yuhwana nda tsi mantsa: «Nawanawa mantsa a tsa wu! Iʼi ta kuma magiɗifta kagha ta batem guli ná, da iʼi ta sagha kagha guli?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","«Maga maga mantsa ya ndanana karaku, kabga mantsa ya dzaʼa magata u ta inda skwi ya kumaŋ Lazglafta,» ka Yesu nda tsi. Gi dzəglamə a Yuhwana ta wi mida wa. ");
INSERT INTO xed_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kɗakwa lu ta maganaftá batem ta Yesu, ka sabə tsi ma imi. Ka gi gunatá luwa buwaŋ, ka nghə tsi ta Sulkuma Lazglafta ta saha manda ghərbuʼ ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","«Nanana zwaŋa ɗa ya ɗvu yu, ya ta zɗigihata katakata,» ka sana lwi snagata daga ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tahula tsa, ka klaghatá Sulkuma Lazglafta ta Yesu da mtak ŋa dzəghay halaway. ");
INSERT INTO xed_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tahula magatani ta fitik fwaɗ mbsak nda rviɗik tani nda fitik tani ta suma, ka kuzlanaftá maya. ");
INSERT INTO xed_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka gavanavatá halaway, kaʼa nda tsi mantsa: «Ka si Zwaŋa Lazglafta ka katsi ná, mnanamna ta na palaha na ka mbəɗavafta həŋ ka skwa zay,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka Yesu mantsa: «Ka lu vindafta ma gwaɗa Lazglafta na: “nda skwa zay kweŋkweŋ yeya a ta nzata mndu nda hafu wu, ama nda inda gwaɗa ta sabi ma wa Lazglafta,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ka klaghatá halaway ta Yesu da Ursalima luwa ya nda ghuɓa. Ka kladaftá tsi ta bɗəma həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ka halaway nda tsi mantsa: «Ka si Zwaŋa Lazglafta ka katsi ná, vzadavza ta vgha ta haɗik. Ka lu vindafta ma gwaɗa Lazglafta na: “dzaʼa ghunafghuna Lazglafta ta duhwalhani ŋa tsuʼaftá kagha ma dzva taŋ ŋa kwala səla gha da gruŋtá pala,”» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka Yesu guli mantsa: «Ka lu vindafta ma gwaɗa Lazglafta guli na: “Ma dzəghə ka ta Mgham Lazglafta gha kəʼa,”» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tahula tsa, ka kləglaghatá halaway ta bɗəma sana ghwá nda slra, ka maranatá za mgham ma ghəŋa haɗik nda gadghəlani tani. ");
INSERT INTO xed_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kaʼa nda tsi mantsa: «Ka tsəlɓa tsəlɓa ka ma ghuva ɗa ka vlihatá glaku, ta vlaghavla yu ta inda taŋ demdem,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ka Yesu nda tsi mantsa: «Halaway! Laghula gha ta vata iʼi. “Ŋa Mghama gha Lazglafta dzaʼa vla ka ta glaku, da tsatsi turtukwani dzaʼa skwa ka ta htsiŋ,”» ka lu vindafta ma deftera Lazglafta, kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mnatani ta tsaya, ka zlanavatá halaway. Ka sliʼadaghatá duhwalha Lazglafta, ka vlaŋtá həŋ ta skwa zay. ");
INSERT INTO xed_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Manda snaŋta Yesu kazlay: Waʼa hbam hba lu ta Yuhwana ma gamak kəʼa, ka sliʼaftá tsi ka laghwi ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka zlanatá tsi ta luwa Nazaret. Ka laghwi da nzata ma luwa Kafarnahum ta nzakway ta wa drəfa Galili, ma kwakwara luwa Zabuluŋ nda Naftali. ");
INSERT INTO xed_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mantsa ya magata tsi ŋa dzanaghatá ghəŋa gwaɗa ya mnə anabi Isaya: ");
INSERT INTO xed_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Kaghuni kwakwara Zabuluŋ nda Naftali ta nzakway ta wa drəf tvə sana ɓla ghwa Zurdeŋ, nda kagha haɗika Galili ta nzaku gwal kul haɗ ka la Yahuda mida ya, ");
INSERT INTO xed_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dzaʼa nda ngha gwal ta nzaku ma grusl ta mghama tsuwaɗak. Lanagha la tsuwaɗak ta gwal ta nzaku ma luwa zlatanagha sulkuma mtaku ta həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Daga ma tsa fitik ya zlrafta Yesu ta mna gwaɗa, kaʼa mantsa: «Mbəɗanafwa mbəɗa ta nzakwa ghuni! Ndusa ga mghama Lazglafta ka sagha!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ta wawakwani Yesu ta wa drəfa Galili, ka nghaŋtá tsi ta zwanamaha his, i Simuŋ ta hgu lu ka Piyer ya nda zwaŋamani Andre. Ta wɗa kadəŋa taŋ həŋ da drəf ŋa tuma klipi kabga tuma klipi slna taŋ. ");
INSERT INTO xed_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","«Mbaɗwa mista ɗa ŋa naghunafta ɗa ka gwal hlaktá mnduha,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka gi zlanavatá həŋ ta kadəŋha taŋ ka laghu mistani. ");
INSERT INTO xed_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mbaɗapta taŋ dauʼ, ka nghaŋtá tsi ta zwanamaha his guli, i Yakubu nda Yuhwana zwana Zebedi. Kawadaga həŋ nda da taŋ Zebedi ma kwambalu ta paya kadəŋa taŋ. Ka hgaftá Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ka zlanavatá həŋ ta tsa kwambala taŋ ya nda da taŋ tani, ka laghwi mista Yesu. ");
INSERT INTO xed_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ka rə Yesu ta inda haɗika Galili, ka tagha skwi ŋa mnduha ma həgaha tagha skwa la Yahuda, ka mna Lfiɗa Gwaɗa ta ghəŋa ga mghama Lazglafta, ka mbamba mnduha ma inda ɗaŋwaha taŋ, nda inda ya ta raghwa həŋ. ");
INSERT INTO xed_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ka tuta gwaɗa wdiɗ ta ghəŋa Yesu ta inda haɗika Siri. Ka hlədanaghatá lu ta inda gwal ɗaŋwa, nda gwal ta ŋra ɗaŋwaha kavghakavgha, nda gwal nda ksa da halaway, nda gwal nda ksa da seteni, nda gwal nda rwa səla taŋ. Ka mbambə Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ka sliʼi dəmga mistani, gwal ta sliʼafta ta haɗika Galili, nda gwal ta sliʼafta ta kwakwara Dekapwalus, nda ya ma luwa Ursalima, nda ya ta haɗika Zudiya, nda gwal nda ta sana ɓla ghwa Zurdeŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nghay Yesu ta sliʼadaghata dəmga da tsi, ka sliʼaftá tsi ka lafi ta kuɗuŋur ka nzata. Ka sliʼadaghatá duhwalhani tavatani. ");
INSERT INTO xed_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ka zlraftá tsi ta tagha skwi ŋa taŋ, kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Rfu da gwal nda sna ta pɗa taŋ ma Sulkum, kabga ŋa taŋ ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Rfu da gwal ta taw ndanana, kabga dzaʼa lɓana lɓa Lazglafta ta ŋuɗufa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Rfu da gwal leɓtekwa ghəŋa taŋ, kabga dzaʼa vlaŋvla Lazglafta ta haɗik ya tanaf tsi ta imi ta sləməŋ ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Rfu da gwal ta dzə maya nda ndala maga skwi ta kumə Lazglafta ta həŋ, kabga dzaʼa baghaku həŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Rfu da gwal ta tawa hiɗahiɗa ta mndu kabga dzaʼa taway Lazglafta ta hiɗahiɗa ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Rfu da gwal hezleʼ a ŋuɗufa taŋ, kabga dzaʼa nghaŋngha həŋ ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Rfu da gwal ta sləga zɗaku mataba mnduha, kabga zwana ɗa kuni ka Lazglafta dzaʼazlay nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Rfu da gwal ta gə lu ta iri ŋa taŋ ta ghəŋa magay taŋ ta skwi tɗukwa, kabga ŋa taŋ ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Rfu da kaghuni, ka ta rarazay lu ta kaghuni, ka ta gay lu ta iri ŋa ghuni, ka ta vazay lu ta rutsak ta kaghuni ta ghəŋa gwaɗa ta iʼi. ");
INSERT INTO xed_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rfawarfa ta rfu, ka nzata kuni waɗah, kabga mamu nisəla ghuni dagala ta kzla kaghuni ta luwa. Manda va tsaya ganapta lu tiri ta anabiha ta tiŋlaghutá kaghuni.» ");
INSERT INTO xed_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Kaghuni slughula ghəŋa haɗik. Ka sabsa nəmaku ma slughul ná, waka lu dzaʼa nəmglanafta na? Ta haɗ hayhayani wu, ta ghəŋa pghidiŋta ŋa diŋlay mnduha yeya. ");
INSERT INTO xed_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Kaghuni tsuwaɗaka ghəŋa haɗik. Haɗ luwa ta bafta lu ta ghwá ta ɗifaghuta wa. ");
INSERT INTO xed_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Haɗ lu ta tsamtá vu ma pitirla ka dzuɓamta ma tughuba wa. Ta vli tskala ta fagata lu ŋa tsuwaɗakayni ta inda gwal ma tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Manda tsaya dzaʼa tsuwaɗakakwa tsuwaɗaka ghuni ta kəma mnduha, kada nghaŋta həŋ ta ŋərma slna ta magə kuni, ŋa zləzlvay taŋ ta da ghuni ta luwa.» ");
INSERT INTO xed_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Ma fa kuni ta ghəŋ kazlay: Sa da hərɗiŋtá zlaha Musa nda tagha skwa la anabi yu kəʼa. Sa da hərɗiŋta a yu wu, sa da ŋlanaftá yu. ");
INSERT INTO xed_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kahwathwata ka yu ta mnaghunata: Ka ta tekeʼa luwa nda haɗik katsi, haɗ sana skwi dər neɗ, dər ndəheɗ dzaʼa wuɗanaghuta lu mataba zlaha Musa, ha ka laghani ta fitika kɗavakta inda skwi wa. ");
INSERT INTO xed_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","«Tsaya tama, dər wa ta kwalaghutá snatá dər ya kwitikw mataba tsa zlahuha ya, ka tagha magay manda tsa ŋani ya ŋa sanlaha ná, dzaʼa nzakway tsa mndu ya ka sagəŋ gudzekw ma ga mghama Lazglafta. Ama ka snasna mndu ta tsa zlahu ya, ka tagha magay manda tsa ŋani ya ŋa sanlaha guli ná, ka mndu dagala tsa mndu ya dzaʼazlay ma ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kahwathwata ka yu ta mnaghunata: Ka malaghumala a kaghuni ta snatá zlahu ka gwal tagha zlahu ŋa mnduha nda la Farisa wu katsi ná, haɗ kuni dzaʼa walaŋtá lami da ga mghama Lazglafta wa.» ");
INSERT INTO xed_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Nda sna kuni ta skwi mnana lu ta dzidzíha mu ghalya kazlay: Yaha ka walaŋta dzatá mndu kəʼa. Dər wa mndu ta dzatá mndu ná, dzaʼa klay lu da guma kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama ka iʼi ta mnaghunata ná, dər wa ta ɓasanavatá ŋuɗuf ta zwaŋamani ka mukumani a tsi ka tsi, dzaʼa klay lu ta tsa mndu ya da guma. Dər wa mndu dzaʼa mnay nda zwaŋamani ka mukumani a tsi kazlay: Ghwaɗak kəʼa ná, dzaʼa klay lu ta tsa mndu ya ta kəma guyatá ghəŋa gwal tsa guma. Dər wa mndu dzaʼa mnay nda zwaŋamani ka mukumani a tsi kazlay: Rgha kəʼa, nda ra tsa mndu ya ŋa vzaghata da duda vu. ");
INSERT INTO xed_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Tsaya tama, ka kladagha kla ka ta skwi ŋa vlay ta gwir ŋa Lazglafta, ka havaktá ka hada ta gwaɗa ya ta kul dzraku mataba ghuni nda zwaŋama gha katsi, ");
INSERT INTO xed_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","zlaŋzla ta tsa skwa gha ya hada tavata tsa gwir ya, ka vraghuta ka dzrafta nda tsi karaku, kada vrakta ka vlaŋtá tsa skwa gha ya ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Ka mamu skwi mataba ghuni nda mndu katsi, ta kul lagha kuni da vla guma nda tsi ya, ŋavaŋa ka dzrafta kuni ma kɗaku tsi kladaghaghata da vla guma, da klaftá mndu ta tsa guma ta kagha ka vlaŋtá la sludzi, da vzaghatá lu ta kagha da gamak. ");
INSERT INTO xed_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kahwathwata ka yu ta mnaghata, haɗ ka dzaʼa sabi hada kata kɗiŋ a ka ta planatá kɗavakta penani wa.» ");
INSERT INTO xed_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Nda sna kuni ta skwi mna lu kazlay: Yaha ka da hliri kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama ka iʼi ta mnaghunata ná, mndu ta nghafta nda ira mbəzleh ta markwa sani ma mndu ná, nda ghada klutani ta tsa marakw ya ma ŋuɗufani. ");
INSERT INTO xed_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ka ira gha nda ga zeghwi ta kla kagha da ga dmaku katsi, tsakwasliŋ tsakwasla ka wuɗidiŋta ka diʼiŋ. Dər pɗata ka ta fawaya gha turtuk ka ya da vzamta lu ta kagha tsuhtsuh da duda vu. ");
INSERT INTO xed_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ala, ka dzva zeghwa gha ta kla kagha da maga dmaku ya, tsiŋtsa ka wuɗidiŋta ka diʼiŋ, dər pɗata ka ta fawaya gha turtuk ka ya da vzamta lu ta kagha tsuhtsuh da duda vu.» ");
INSERT INTO xed_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ka lu mnata guli na: “Ka ghzliŋghzla mndu ta markwa taŋ katsi, vindanaftani ta ɗelewera ghzlatani.” ");
INSERT INTO xed_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama ka iʼi ta mnaghunata na: Ka ghzliŋghzla mndu ta markwa taŋ, ka ta ghəŋa hliri a tsi wu katsi, famfa ta tsa marakw ya da hliri. Ka klafkla mndu ta marakw ghzliŋ lu guli, hliri ta hlə tsa mndu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Nda sna kuni ta skwi mnana lu ta dzidzíha ghalya na: Yaha ka da walaŋta waɗu kəʼa. Manda va tsa waɗana ka ta Mgham Lazglafta gha ya ná, manda va tsaya ká ka magata. ");
INSERT INTO xed_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama ka iʼi ta mnaghunata na: Yaha kuni walaŋta waɗutá vli, dər nda luwa, kabga vla nzakwa Lazglafta ya. ");
INSERT INTO xed_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Dər nda haɗik, kabga vla fa səlani ya. Dər nda luwa Ursalima, kabga luwa Mgham dagala ya. ");
INSERT INTO xed_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yaha ka da waɗu nda ghəŋa gha, kabga laviŋ a ka ta mbəɗanafta ka ŋusliŋ dər ka ŋra ta ya dər turtuk ma swida gha wa. ");
INSERT INTO xed_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Gwaɗa ya ŋa sabi ma wa ghuni ná, ka aŋi tsi, aŋi. Ka mantsa a tsi wu, mantsa a wa. Inda ya dzaʼa sganaghata lu ta ghəŋa tsaya ná, sagha da halaway.» ");
INSERT INTO xed_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Nda sna kuni ta mnata lu kazlay: Nda iri dzaʼa plamta lu ta iri, nda sliʼiŋ dzaʼa plamta lu ta sliʼiŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama ka iʼi ta mnaghunata ná, ka magamaga mndu ta ghwaɗaka skwi, yaha kuni da vranamta. Katək ná, ka dzughusdza mndu ma lagəŋa gha nda ga zeghwi, mbəɗanambəɗa guli ta lagəŋa gha nda ga zlaɓa. ");
INSERT INTO xed_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka kurakura mndu ta wlatá kagha kabga ŋa klugudughustá dawra gha, fanavafa guli ta lguta huɗa gha. ");
INSERT INTO xed_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka pgha ta iʼi tkweʼ ka meli turtuk ka mndu nda kagha ya, pghafpgha gha ka meli his. ");
INSERT INTO xed_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka ɗawaŋɗawa mndu ta skwi da kagha vlaŋvla gha. Ka laghala mndu da ɓla nzawa da kagha, ma sɗanaf ka.» ");
INSERT INTO xed_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Nda sna kuni ta skwi mna lu kazlay: Ɗvuɗva ta zwaŋama gha, ghuma gha katsi husaghata kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama ka iʼi ta mnaghunata: Ɗvuwaɗva ta ghuma ghuni, magawa duʼa ta ghəŋa gwal ta giri ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tsaya dzaʼa kəl kuni ka nzakway ka vərɗa zwana Da ghuni ya ta luwa, kabga tsatsi ta sliʼaganaptá fitik ta ghəŋa gwal kul zɗaku ghəŋa taŋ, nda ya ta ghəŋa gwal zɗa ghəŋa taŋ. Ta nzagazna ta imi ta ghəŋa tɗukwa mnduha, nda ya ta ghəŋa ghwaɗaka mnduha. ");
INSERT INTO xed_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka gwal ta ɗvutá kaghuni yeya ka kuni laghu ɗvuta katsi, mndəra wati nisəla ta dzaʼa kuni mutsəgəlta na? Dər gwal tska dzumna guli ná, mantsa ya a ta maga həŋ guli ra? ");
INSERT INTO xed_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ka ŋa zwaŋama gha yeya ta ga kaghuni ta zgu katsi ná, ndaw malaghuta kaghuni tama? Mantsa ya a ta maga gwal kul snaŋta Lazglafta guli ra? ");
INSERT INTO xed_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nzawanza ka vərɗa mndu manda va nzakwa Da ghuni ta luwa ka vərɗa mndu ya.» ");
INSERT INTO xed_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ɗasuwa ka kuni ta magə kuni ta skwi tɗukwa, yaha kuni da magay ŋa ghubaku ta wa ira mnduha. Ka mantsa tsi ná, mutsafta a kuni ta nisəla ghuni da Da ghuni ta nzakway ta luwa wa. ");
INSERT INTO xed_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Ta vlə ka ta skwi ŋa pɗu ya, ma ghubu ka ta ghəŋa gha ta ghəŋani, manda ya ta magə gwal ta maga maɗgwirmaɗgwir ma həga tagha skwa la Yahuda, nda ya ta pazlala, ŋa ghubaku da mnduha ya. Kahwathwata ka yu ta mnaghunata, mutsu mutsa həŋ ta nisəla taŋ. ");
INSERT INTO xed_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama kagha, ta mbəhu ka ta pɗu ya, ma snaŋ dzva zlaɓa gha ta skwi ta magə dzva zeghwa gha. ");
INSERT INTO xed_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tsaya dzaʼa kəl tsa mbəha gha ya ka nzakway ka skwi nda ɗifa. Dzaʼa plaghampla Da gha Lazglafta ta ngha skwi ta magə ka ma ɗifa ya.» ");
INSERT INTO xed_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ta ndəɓu kuni ta dzvu, ma nza kuni manda ŋa gwal ta maga maɗgwirmaɗgwir zɗəgana maga duʼa ta həŋ ta sladu ta sladu ma həga tagha skwa la Yahuda, nda ya ta wa madədga tvi ŋa nghaŋta mnduha ta həŋ ya. Kahwathwata ka yu ta mnaghunata, mutsu mutsa həŋ ta nisəla taŋ. ");
INSERT INTO xed_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama kagha, ka ta maga duʼa ka, laghula da dzuguva gha, ka hafta ka ta tgha gha ka ndəɓa ka ta dzvu. Dzaʼa plaghampla Da gha ta nzakway ta nghay ma ɗifa ya. ");
INSERT INTO xed_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ta ndəɓu kuni ta dzvu ya, ma gɗa kuni ta vrafta ta gwaɗa turtuk, manda ŋa gwal kul saŋtá Lazglafta ta ndanay kazlay: Vrafta ta gwaɗa dzaʼa kəl Lazglafta ka tsuʼaŋnafta kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma taghə kuni ta skala taŋ, kabga nda sna Da ghuni ta skwi ta kumə kuni ma kɗaku kaghuni ka ɗaway da tsi.» ");
INSERT INTO xed_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wya ka kuni da maga duʼa tama: «Da ŋni ta nzakway ta luwa, ka snavasna hga gha nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ka saghasa fitika ga mghama gha, ka maga ka ta skwi ta kumə ka ta haɗik, manda ya ta magaku ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vlaŋnavla ta skwa zay prək zay ŋni gita. ");
INSERT INTO xed_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Plaŋnapla ta dmakuha ŋni, manda ya ta plinista aŋni ta dmakwa gwal ta magaŋnata. ");
INSERT INTO xed_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma zlaŋna ka tawa skwi dzaʼa dzəghaŋnata. Klapkla ta aŋni ma dzva halaway, kabga ŋa gha ga mgham, nda mbraku, nda glaku, ŋa kɗekedzeŋ. Amin! ");
INSERT INTO xed_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ka plinispla kuni ta dmakwa mnduha ta magaghunata katsi, Da ghuni ta nzakway ta luwa ná, dzaʼa plighunispla ta ŋa ghuni guli. ");
INSERT INTO xed_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama ka haɗ kaghuni ta plinistá dmakwa mnduha ta magaghunata wu katsi, haɗ Da ghuni dzaʼa plighunistá dmakuha kaghuni guli wa.» ");
INSERT INTO xed_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ka ta suma kuni, ma pslaf kuni ta kuma manda ya ta magə ghwaɗaka mnduha. Ta pslafpsla həŋ ta kuma, kabga ŋa nghay mnduha kazlay: Ta suma həŋ kəʼa. Kahwathwata ka yu ta mnaghunata, mutsumutsa həŋ ta nisəla taŋ nda tsaya. ");
INSERT INTO xed_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kagha, ka ta suma ka, masammasa ta rɗi ma ghəŋa gha ka payanata ka, mbaziŋ ka ta kuma gha guli. ");
INSERT INTO xed_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tsaya dzaʼa kwal mnduha tsatsafta ta suma ka kəʼa. Ta ghəŋa Da gha hada ta nzaku ma ɗifa yeya nda ngha. Dzaʼa plaghampla tsa Da gha nda ngha ta skwi ta magə ka ma ɗifa ya. Psawapsa ta mutsaftá gadghəl da Lazglafta.» ");
INSERT INTO xed_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ma tskana kuni ta gadghəla ghuni ta haɗik ma vli ya ta zuta zahar, ta ksuta mbəzlar, nda ya ma vli ta zlraghata ghaliha guli. ");
INSERT INTO xed_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama tskawa tska ta gadghəla ghuni ta luwa ma vli dzaʼa kwal zahar zuta, dzaʼa kwal mbəzlar ksuta, nda ya dzaʼa kwal ghaliha zlraghata. ");
INSERT INTO xed_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma vli hada gadghəla gha ya, hada ŋuɗufa gha guli.» ");
INSERT INTO xed_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Iri ná, manda pitirla vgha gha nzakwani. Ka tsiɗiɗ ira gha, tsuwaɗak inda vgha gha. ");
INSERT INTO xed_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama ka nda badza ira gha, ma grum inda vgha gha. Ka si ma grum nzakwa tsa tsuwaɗak ma kagha ya katsi, kighkigh dzaʼa tɗikuta tsa grum ya tama!» ");
INSERT INTO xed_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Haɗ mndu dzaʼa laviŋta gwafta ksanatá slna ta mghamha his, ta magaymagay ŋa ya, ta magaymagay ŋa ya, ma va tsa fitik turtuk ya wa. Nda husaŋta sani, ta ɗvutá tsi ta sani. Nda ndiʼa nzakwani nda sani, ta wuɗiŋtá tsi ta sani. Laviŋ a kuni ta gwaftá maga slna ŋa Lazglafta, ta magaymagay kuni ŋa tsedi wa.» ");
INSERT INTO xed_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Tsaya ta kəl yu ka mnaghunata kazlay: Ma thə kuni ta heʼ, a nu dzaʼa mu zay? Nu dzaʼa mu say? A nu dzaʼa mu suɗay ta vgha na kəʼa? Malaghumala a hafu ta skwa zay ra? Ari malaghumala a wa a vgha ta lgut na? ");
INSERT INTO xed_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nghawangha ta ɗyak ta ndaraku ta luwa ɓa. Haɗ həŋ ta sləgu wu, tska a həŋ ta skwi ta vwah wu, haɗ həŋ ta tskanatá skwi ma guvur guli wa. Da ghuni ta luwa ta zuŋtá skwi ta həŋ. Malaghumala a kaghuni piw ka hahəŋ wu ra? ");
INSERT INTO xed_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","«Waya mataba ghuni ma mnayni ta heʼ, dzaʼa slranaghata dauʼ ta fitika hafani na? ");
INSERT INTO xed_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ala, kabgawu ta kəl kuni ka mna heʼ ta ghəŋa lgut tama ɓa? Nghawangha ta vzlizla ta magaku ma vwah ɓa. Haɗ sana slna ta magata həŋ wu, haɗ həŋ ta ga lgut wa. ");
INSERT INTO xed_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kulam nda tsa, ka yu ta mnaghunata na: Dər Salumuŋ nda va tsa nzakwani ka gadghəl ya tani ná, ta fava a ta lgut ta klaftá ɗinakwa ya dər turtuk ma tsa vzlizlaha ya wa. ");
INSERT INTO xed_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka si mantsa ya ta suɗanavata Lazglafta ta lgut ɗina ta kuzuŋ gita, gamahtsimani ŋa vzamta da vu ya ní, kaghuni yeya dzaʼa kwal tsi suɗavaghunata tama rki? Kay! Nda hta zlghay nda ŋuɗufa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Ma walaŋ kuni ta mna heʼ tama, ma mnə kuni kazlay: A nu dzaʼa ŋni zay? A nu dzaʼa ŋni say? A nu dzaʼa ŋni suɗay ta vgha na kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Inda tsaha ya ná, gwal kul snaŋtá Lazglafta ta psay. Nda sna Da ghuni ta luwa ta skwiha ta raku ka ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Zbawazba ta ga mghama Lazglafta nda maga skwi tɗukwa ta wa irani karaku, dzaʼa vlaghunavla lu ta inda tsa skwiha ya ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","«Ma mnə kuni kazlay: Heʼ, waka yu da magay gamahtsimani na kəʼa. Prək gamahtsimani ka ndananatá ghəŋani, prək dər wati ma vaghu nda ɗaŋwani.» ");
INSERT INTO xed_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Ma tsə kuni ta guma ta ghəŋa mndu, da tsaghunaghatá lu ta guma ta kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dzaʼa tsaghunagha tsa Lazglafta ta guma, manda va tsa ta tsə kaghuni ta ghəŋa sanlaha ya. Nda tsa daram ta kəl kaghuni ka gray ŋa sanlaha ya, nda va tsaya dzaʼa gra lu ŋa kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kabgawu ta kəl kagha ka laghwi da ngha slimbitsa udzu ma ira zwaŋama gha, kul nghaŋta kagha ta dughuslani ma ŋa gha iri na? ");
INSERT INTO xed_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ari, waka kagha dzaʼa mnay nda zwaŋama gha “Yaha ka kləgaghata yu ta slimbitsa udzu ta ira gha kəʼa,” wya dughuslani ma ŋa gha na? ");
INSERT INTO xed_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tsa maɗgwirmaɗgwira gha ya. Tiŋəl ká ka kliŋtá dughusl ma ira gha karaku, kada nghaŋta ka ta vli ŋa kligiŋtá slimbitsa udzu ma ira zwaŋama gha.» ");
INSERT INTO xed_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Ma vlə kuni ta skwi nda ghuɓa ŋa kriha, da mbəɗavatá tsi valafta ta kaghuni ka patsaghunata. Ma vza kuni ta miziɗikwa ghuni ta kəma ghuvazu da diŋlanaptá tsi, ka mbəɗavata da hiʼida kaghuni.» ");
INSERT INTO xed_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ɗawawaɗawa dzaʼa vlaghunavla lu. Zbawazba dzaʼa mutsay kuni. Gawaga ta zgu dzaʼa gunaghunaguna lu ta watgha. ");
INSERT INTO xed_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dər wati ma mndu ta ɗawaŋta, ta mutsay. Dər wati ma mndu ta zbaŋta, ta slafsla tida. Ta gunanaguna lu ta watgha ta mndu ta gatá zgu. ");
INSERT INTO xed_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Waya ma kaghuni dzaʼa klaftá pala ka vlaŋtá zwaŋani ɗawaŋər tsi ta skwa zay na? ");
INSERT INTO xed_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ari, ka klipi ɗawaŋ tsa zwaŋ ya, ka klaftani ta nahaɗik ka vlaŋta na? ");
INSERT INTO xed_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka si kaghuni ta nzakway ka ghwaɗaka mnduha, nda sna kuni ta klaftá ŋərma skwiha ka vlaŋtá zwana ghuni ya ní, Da ghuni ta luwa yeya dzaʼa kwal kul snaŋta klaftá skwiha ɗinaɗina, ka vlaŋtá gwal ta ɗawaŋta da tsi rki?» ");
INSERT INTO xed_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Inda skwi má ta kumə kaghuni ta magaghunata mnduha ya, maganawamaga kaghuni guli ta hahəŋ, kabga tsaya klatá ghəŋa zlaha Musa, nda gwaɗa la anabi.» ");
INSERT INTO xed_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Lamwa la nda ta watgha slrehwa, kabga watgha bughwa ná, bla a labə tida wa ta kla mndu da vla zaɗaku. Nda ndəgha gwal ta dzaʼa nda tida. ");
INSERT INTO xed_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Watgha slrehwa ná, nda bla ka lu ta labə tida, ta kla mndu da hafu. Sira a gwal ta mutsa labə tida guli wa.» ");
INSERT INTO xed_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ɗasuwa ka kuni nda anabiha ta tsakalawi ta sliʼamta da taba ghuni manda tuwak, ama ma ŋuɗufa taŋ ta sidi həŋ manda kramtak mtak. ");
INSERT INTO xed_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ta slna taŋ dzaʼa tsatsafta kuni ta həŋ. Ta ɗagay lu ta yakwa fwa inabi ta teki ra? Ari, ta ɗagay a lu ta yakwa ghuraf ta hluʼa na? ");
INSERT INTO xed_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inda fu zɗa ná, zɗa yakwani. Ala, ka zɗa a fu ná, zɗa a yakwani guli wa. ");
INSERT INTO xed_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Haɗ fu zɗa ta laviŋta yaftá yakwa fu kul zɗaku wa. Manda tsaya guli ná, haɗ fu kul zɗaku ta yaftá yakwa fu zɗa guli wa. ");
INSERT INTO xed_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Inda fu kul zɗaku yakwani, ta tsiŋtsa lu ka vzamta ma vu. ");
INSERT INTO xed_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tsaya tama, ta yakwa taŋ ta tsatsafta lu ta həŋ.» ");
INSERT INTO xed_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Inda gwal ta mnay kazlay: Mghama ɗa, Mghama ɗa! kəʼa a dzaʼa lami da ga mghama ɗa wa. Ba mndu ya ta maga skwi ta kumə Da ɗa ta nzakway ta luwa kweŋkweŋ dzaʼa lami. ");
INSERT INTO xed_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nda ndgha gwal dzaʼa mnay ŋa ɗa baɗu tsa kazlay: Mghama ɗa, Mghama ɗa! Aŋni a si ta kla lwa Lazglafta nda hga gha kay ra? Aŋni a si ta ghazla ghwaɗaka sulkum nda hga gha kay ra? Aŋni a si ta maga ndəghata mazəmzəmha nda hga gha kay guli ra kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ka yu dzaʼazlay nda həŋ baŋluwa na: “Ta walaŋ a yu ta snaŋtá kaghuni wu. Laghwala ta vata iʼi, kaghuni gwal maga ghwaɗaka skwiha.”» ");
INSERT INTO xed_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Mantsa tama, dər wati ma mndu ta snaŋtá na gwaɗa ta mnə yu na, ka ksa slna nda tsi, dzaʼa nzakway tsa mndu ya ka gragra nda sana mndu nda hiɗa ta baftá həgani ta kutumba. ");
INSERT INTO xed_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ka sagha imi, ka lagha zala vlunduɗ dista tsa həga ya. Zlu a wu, kabga thaf ta kutumba lu. ");
INSERT INTO xed_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Dər wati ma mndu ta snaŋtá na gwaɗa ta mnə yu na, ka kwalaghutá tsi ta ksa slna nda tsi, ka gragra tsa mndu ya guli nda sana mndu ka rgha ta baftá həgani ta wutak. ");
INSERT INTO xed_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka sagha imi, ka lagha zala vlunduɗ dista tsa həga, ka saf falak guk gruŋta, ka zlutá tsi tesneʼ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Manda kɗiŋta Yesu ta mna tsa gwaɗaha ya, ka ndərmim mnduha katakata ta tsa tagha skwani ya, ");
INSERT INTO xed_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kabga nda sgit ma tsa ŋani tagha skwi ya, nza a manda tsa ŋa gwal tagha zlahu ŋa taŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Manda saha Yesu ta ghwá, ka sliʼaftá ndghata dəmga mistani. ");
INSERT INTO xed_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka lagha sana mndu nda rɗa mndu tida zləmbata ma ghuvani, kaʼa mantsa: «Mghama ɗa, ka ta kumay ka, laviŋlava ka ta mbiɗifta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ka fadaptá Yesu ta dzvani ka ksaŋta, kaʼa nda tsi mantsa: «Ta kumay yu, mbafmba gha,» kaʼa. Gi hadahada ka mbaftá tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka Yesu nda tsi mantsa: «Yahayaha ka mnanaŋtá mndu! La ka dzaʼa ka da maranaŋtá vgha gha ta mnda dra skwi ŋa Lazglafta, ka plata ka ta ghəŋ nda skwi manda ya mna zlaha Musa, kada snaŋta mnduha nda mba ka kəʼa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ta lamə Yesu da luwa Kafarnahum, ka lagha sana mghama sludza la Ruma ndəɓa dzvu da tsi. ");
INSERT INTO xed_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kaʼa nda tsi mantsa: «Mghama ɗa, waʼa kwalva ɗa ta hani mintgha gəzəmblaʼ a ta ghuya ɗaŋwa katakata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","«Ta dzaʼa yu da mbanafta,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","«Mghama ɗa! Ra a yu ka lagha gha da ini wa. Ka sabsa gwaɗa teʼ ma wa gha ná, dzaʼa mbaku kwalva ɗa. ");
INSERT INTO xed_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iʼi guli ná, mista maliha nziŋta yu, mamu sludziha mista iʼi guli. “Ka la!” ka yu nda sani, gi sliʼani. Ka “saghasa!” ka yu nda sani, gi saghani. Ka “maga ta ya!” ka yu nda kwalva ɗa, gi magayni,» ka tsa mghama sludzi ya. ");
INSERT INTO xed_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Snanata Yesu ta tsa gwaɗa mghama sludzi ya, ka laghu tsi ndərmimay. Kaʼa nda tsa gwal mistani ya mantsa: «Kahwathwata ká yu ta mnaghunata, dər mataba la Israʼila, ta slaf a yu ta mndərga zlghay nda ŋuɗufa mndu manda nana wa. ");
INSERT INTO xed_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka yu ta mnaghunata ná, nda ndgha gwal zlghay nda ŋuɗuf mndərga nana dzaʼa sliʼagaghata daga ma mndəra luwa nda ya mista luwa, ka nzata ka za skwi kawadaga nda i Abraham nda Izak nda Yakubu ma ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama gwal má dzaʼa nzakway ka zwana za həga ga mghama Lazglafta ya, dzaʼa hlafhla lu ta həŋ ka pghidiŋta da grum ma bli, ma vli ŋa taw nda hpaɗa sliʼiŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ka Yesu nda tsa mghama sludzi ya mantsa: «La dzagha gha! Dzaʼa magamaga lu manda ya zlghaf ka,» kaʼa. Gi ma va tsa fitik ya ka mbaftá tsa kwalvani ya. ");
INSERT INTO xed_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ka sliʼaftá Yesu ka lagha da Piyer, ka slanaghatá tsi ta midza Piyer ta hani ta ɓasa ŋuɗidar. ");
INSERT INTO xed_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ka ksaŋtá tsi ta dzvu, ka mbaftá tsi da tsa ŋuɗidar ya. Ka sliʼaftá tsi ka maganatá skwa zay. ");
INSERT INTO xed_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gahawani, ka hladaghatá lu ta ndghata gwal nda ksa da ghwaɗaka sulkumha. Ka ghazligiŋtá tsi ta tsa ghwaɗaka sulkumha ya nda gwaɗa ma wani. Ka mbambanaftá tsi ta inda gwal kul ɗughwanaku. ");
INSERT INTO xed_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mantsa ya magata tsi ŋa dzanaghatá ghəŋa gwaɗa ya mna anabi Isaya kazlay: «Tsatsi ka ghəŋani ta hlaghutá ɗaŋwaha mu, ka mbambamafta ma kwala mu kul ɗughwanaku kəʼa ya.» ");
INSERT INTO xed_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nghanata Yesu ta dəmga ta wanafta ná, «mbaɗma ta a ɓlu a,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka lagha sana mnda vinda zlahu slanaghata, kaʼa nda tsi mantsa: «Maləma ɗa! Ta dzaʼa mista gha yu dər dzaʼa diga ka,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Yesu nda tsi mantsa: «Gərhaŋha ná, mamu ghurumha taŋ. Ɗyakha ta ndaraku ta luwa guli, mamu həgaha taŋ. Ama Zwaŋa mndu ná, haɗ dər vli ŋa fadatani ta ghəŋani wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka sani mataba duhwalhani mantsa: «Mghama ɗa! Zlihazla ka dzaʼa yu da paɗamtá da ɗa karaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka Yesu nda tsi mantsa: «Mbaɗa kagha mista ɗa! Zlaŋzla ta gwal nda rwa ka paɗa həŋ ta mbliha taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ka sliʼaftá Yesu ka lami da kwambalu, ka laghu duhwalhani mistani. ");
INSERT INTO xed_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tata ndəru həŋ ta drəf, ka sliʼavaftá mghama falak, ka kapatsaʼuwaku imi, ka sliʼi da kwambalu. Ma tsa fitik ya, ta hanutá hanani Yesu. ");
INSERT INTO xed_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka sliʼaftá duhwalhani ka lagha sliʼanafta. Ka həŋ nda tsi mantsa: «Mghama ɗa, kata ta amu, dzaʼa rwaku mu!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka Yesu nda həŋ mantsa: «Nu ta kəl kuni ka zləŋ. Kay! Nda hta zlghay nda ŋuɗufa ghuni,» kaʼa. Ka sliʼaftá tsi ka davanaghatá falak nda drəf, ka nzatá vli tɓekw. ");
INSERT INTO xed_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka ndərmim tsa mnduha ya katakata. «Wa na mndu na ta snə dər falak nda drəf tani ta gwaɗani katək na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ɓhadapta taŋ ta tsa sana ɓla drəf ta haɗika Gadaraniya ya, ka sliʼagaptá sana mnduha his ma kulu kasu halaway, ka lagha həŋ da guyay. Ta zləŋay lu ta həŋ katakata, laviŋ a mndu ta walaŋta labə nda tvə tsa wa. ");
INSERT INTO xed_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ka gi dzə həŋ ta lawlaw. Ka həŋ mantsa: «Nya mataba mu nda kagha ní Zwaŋa Lazglafta? Sagha da ghuyaŋnaftá ka ta kul magaku fitikani ra?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsaw manda a nda həŋ, mamu sana bra ghuvazu dagala ta nghə lu. ");
INSERT INTO xed_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka ndəɓu tsa halawayha ya ta dzvu da Yesu. Ka həŋ mantsa: «Ka ta ghzla aŋni ka ná, ghuna ta aŋni da a bra ghuvazuha a,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kaʼa nda həŋ mantsa: «Lawala!» kaʼa. Ka sliʼagaptá həŋ ka sliʼamta da tsa ghuvazuha ya. Ka vazagatá tsa bra ghuvazuha ya ta vgha ta vata vli, ka rkaghata da drəf, ka zaɗamtá həŋ mida. ");
INSERT INTO xed_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka sliʼafta tsa gwal si ta ngha həŋ ya nda hwaya, ka laghwi da luwa da mna inda skwi ta maguta, nda ya ta slanaghatá tsa mnduha kasu halaway ya. ");
INSERT INTO xed_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ka sliʼagaptá mnduha ma luwa nekwnekw da guya Yesu. Na tsa gi nghaŋta taŋ ta Yesu ya, «kdəkkdək, sliʼapsliʼa ma haɗika ŋni,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ka sliʼaftá Yesu ka lami da kwambalu, ka vrəglaghuta nda ta drəf, ka ɓhadaghatá tsi da luwani. ");
INSERT INTO xed_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka tsukwadaghatá sana mnduha da tsi ta kativiŋ ta sana mndu nda rwa səlani. Nghanata Yesu ta zlghay nda ŋuɗufa taŋ, kaʼa nda tsa mndu nda rwa səlani ya mantsa: «Sagəŋ! Ŋavaŋa gha, nda pla dmakwa gha!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ka sanlaha ma gwal tagha zlahu ŋa mnduha ma ghəŋa taŋ mantsa: «Na mndu na ná, ta kwarakwara ta ghəŋa Lazglafta,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nghadapta Yesu ta skwi ta ndanu həŋ, kaʼa mantsa: «Kabgawu ta kəl kuni ka ndana tsa ghwaɗaka ndanu ya na? ");
INSERT INTO xed_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mal blakwa mnay kazlay: Nda pla dmakwa gha kəʼa re, ari, mal mnay kazlay: Sliʼafsliʼa gha ka mbaɗaka ta mbaɗa kəʼa na? ");
INSERT INTO xed_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ala, kada grafta kuni mamu Zwaŋa mndu nda mbrakwa pliŋtá dmakwa mnduha ta na ghəŋa haɗik na kəʼa,» kaʼa nda tsa mndu nda rwa səlani ya mantsa: «Sliʼafsliʼa gha, kla ta kativiŋa gha ka dzaʼa ka dzagha gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gi brahwat sliʼafsliʼa tsa mndu ya ka laghwi tsi dzaghani. ");
INSERT INTO xed_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nghanata dəmga ta tsaya, ka ksutá tsi ta həŋ ka zləŋ. Ka zləzlvu həŋ ta Lazglafta ta vlaŋtá mndərga tsa mbraku ya ta mnduha. ");
INSERT INTO xed_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Manda sliʼafta Yesu ka zluŋtá tsa vli ya, ka nghaŋtá tsi ta sana mndu ta hgə lu ka Mata, ta nzaku ma həga tska dzumna. «Mbaɗa mista ɗa!» kaʼa nda tsi. Ka sliʼafta Mata ka laghwi mistani. ");
INSERT INTO xed_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tahula tsa, ka nzatá Yesu ka za skwa zay ga Mata. Ka sliʼadaghatá ndəghata gwal ta tska dzumna, nda sanlaha ma ghwaɗaka mnduha nzata ka za skwa zay nda tsi, kawadaga nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nghay la Farisa ta tsa zay taŋ ta skwa zay kawadaga ya, ka həŋ nda duhwalhani mantsa: «Kabgawu ta kəl Mghama ghuni ka za skwa zay kawadaga nda gwal tska dzumna, nda ya nda ghwaɗaka mnduha na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Slrew lami da sləməŋa Yesu, kaʼa mantsa: «Haɗ mnduha ɗughwana ɗughwana ta zba duhtur wa, gwal kul ɗughwanaku yeya ta zbay. ");
INSERT INTO xed_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lawa tsatsa klatá ghəŋa gwaɗa ya mnə Lazglafta kazlay: Tawa hiɗahiɗa skwi ta zɗigihata pla ghəŋ nda rini a wu kəʼa ya. Sagha a yu haga gwal tɗukwatɗukwa wa, gwal dmaku ŋa iʼi ta sagha da hagay,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka sliʼaftá duhwalha Yuhwana mnda maga batem ka lagha ɗawaŋta da Yesu, ka həŋ mantsa: «Kabgawu ta kwal ŋa gha duhwalha suma, ya wya ta suma aŋni nda la Farisa tazlay na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka Yesu nda həŋ mantsa: «Dzaʼa laviŋlava gwal hagaŋ lu da vla kla makwa ta nzata zuzuʼuva, ka ta kawadaga zwaŋa midzi nda həŋ ra? Dzaʼa saghasa fitik ŋa kləgadanaghutá həŋ ta zwaŋa midzi. Ma tsa fitik ya dzaʼa suma həŋ ta suma. ");
INSERT INTO xed_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Haɗ mndu ta tsaʼatá lfiɗa lgut ka tsamtá halata lgut nda tsi wa. Ka mantsa tsi, dzaʼa sganaghasga tsa lfiɗani ya ta mɗukwiŋta tsa halatani ya. ");
INSERT INTO xed_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Haɗ lu guli ta pghamtá ima inabi ta ka nuni da halata zliba huta wa. Ka mantsa tsi, dzaʼa tuta tsa zliba huta ya, ŋa mbuzuta ima inabi, lpay lu ma zliba huta guli. Ima inabi ta ka nuni ná, ma zliba huta ta ka lfiɗani ta pghamta lu. Tsaya dzaʼa kəl həŋ his his ka nzata ɗina.» ");
INSERT INTO xed_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tata mna tsa gwaɗa ya Yesu ŋa taŋ mantsa, ka lagha sana mali mataba la Yahuda zləmbata ma ghuvani. Kaʼa nda tsi mantsa: «Ta nzɗava a makwa ɗa manda saba hafu mida wa, sawi fanaghatá dzva gha ta ghəŋani ka mbafta tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ka sliʼaftá Yesu kawadaga nda duhwalhani, ka dzaʼa mista tsa mali mataba la Yahuda ya. ");
INSERT INTO xed_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka sliʼaftá sana marakw ta magay vakwani ghwaŋpɗə his ta paghaku, ka lagha tsi ksaŋtá wa lguta Yesu nda ga muhul hul. ");
INSERT INTO xed_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsaw ka tsa marakw ya ma ghəŋani na: «Dər wa lgutani yeya ksaŋ yu taɗa ná, dzaʼa mbaku yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ka mbəɗavatá Yesu, ka nghanavatá tsi. Kaʼa nda tsi mantsa: «Ŋavaŋa gha makwa ɗa! Zlghay nda ŋuɗufa gha ta mbaghafta,» kaʼa. Gi hadahada ka mbaftá tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ka ɓhadaghatá Yesu da tsa mali mataba la Yahuda ya, ka slanaghatá tsi ta gwal ta vya siŋlak, nda gwal ta vaza vgha. ");
INSERT INTO xed_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kaʼa nda həŋ mantsa: «Laghwala, ta mta a na makwa na wu, hani ta hani tsi,» kaʼa. Ka ghuɓasu həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Manda mbigiŋta lu ta mnduha dzibil, ka lami Yesu da həga. Ka ksaftá tsi ta tsa zwaŋa makwa ya ta dzvu, ka sliʼaftá tsa makwa ya. ");
INSERT INTO xed_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ka tutá tsa skwi ta magata ya wdiɗ ma luwa. ");
INSERT INTO xed_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Manda sliʼafta Yesu ma tsa vli ya ka sliʼi, ka sliʼaftá sana ghulpa ta mnduha his mistani nda hagaku. «Zwaŋa Dawuda! Tawa ta hiɗahiɗa ta aŋni!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka lamə Yesu da həga, ka lagha həŋ slanaghata. Ka Yesu nda həŋ mantsa: «Grafgra kuni kazlay: Dzaʼa laviŋlava yu ta mbaghunafta kəʼa ra?» kaʼa nda həŋ. «Aŋi Mghama ɗa,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka kasaŋtá tsi ta iriha taŋ. «Manda va tsa zlghafta ghuni nda ŋuɗuf ya ná, ka magamaga tsi manda va tsa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka mbaftá tsa iriha taŋ ya. «Yahayaha kuni walaŋta mnanatá mndu!» ka Yesu ka ŋɗaŋɗa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na tsa saba tsa gwal nda ghulpa ya, ka laghu həŋ da ta gwaɗa ta Yesu ma inda tsa haɗik ya. ");
INSERT INTO xed_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ta mbəɗ hul tsa mnduha si nda ghulpa ya, ta kladaghatá lu da Yesu ta sana mndu tsiŋ ghwaɗaka sulkum ka rgha. ");
INSERT INTO xed_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka ghzligiŋtá Yesu ta tsa ghwaɗaka sulkum ya mida. Ka zlraftá tsa mndu si ka rgha ya ta gwaɗa tsəleŋ. «Ka yawu ka yawu, ta ngha a lu ta mndərga skwi manda na ma Israʼila wu,» ka dəmga ka ndərmimay. ");
INSERT INTO xed_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","«Mghama ghwaɗaka sulkum ta vlaŋtá mbraku ta Yesu ta kəl tsi ka ghazla ghwaɗaka sulkumha,» ka la Farisa nda ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ka rə Yesu ta vli ma inda luwa dagaladagala nda zwana luwa tani. Ka tataghə tsi ta skwi ŋa mnduha ma həgaha tagha skwa la Yahuda. Ka mnə tsi ta Lfiɗa Gwaɗa ta ga mghama Lazglafta, ka mbamba mnduha ma inda ɗaŋwaha, nda inda ya ta raghwa mndu. ");
INSERT INTO xed_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kəʼa ka Yesu waftá dəmga ná, ka ksaŋtá tsi ka hiɗahiɗa, kabga nda hərfa həŋ, ta haɗ mbraku ma həŋ wu, nda nza həŋ manda tuwakha kul haɗ mndu ŋa nghay. ");
INSERT INTO xed_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kaʼa nda duhwalhani mantsa: «Dagala skwi ŋa tskay ta vwah, slaghu a gwal ŋa tskay wa. ");
INSERT INTO xed_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndəɓawa ndəɓa ta dzvu da mnda vwah ka ghuna tsi ta gwal ksa slna, ŋa tskanatá skwi ta vwah,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ka hagaftá Yesu ta duhwalhani ghwaŋpɗə his. Ka valaŋtá tsi ta mbrakwa ghazla ghwaɗaka sulkum, nda mbamba mnduha ma inda ɗaŋwaha, nda ya ma inda ɗaŋwaha ta raghwa mndu nda raghwa ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wya hga tsa gwal ghwaŋpɗə his ya: Taŋtaŋani, Simuŋ ta hgə lu ka Piyer, nda Andre ta nzakway ka zwaŋamani, nda Yakubu zwaŋa Zebedi, nda Yuhwana ta nzakway ka Zwaŋamani, ");
INSERT INTO xed_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nda Filip, nda Bartelemi, nda Tuma, nda Mata mnda tska dzumna, nda Yakubu zwaŋa Alfe, nda Tade, ");
INSERT INTO xed_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nda Simuŋ mnda la Kananit, nda Zudas Iskaryut ta skwaptá Yesu ya. ");
INSERT INTO xed_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tsa gwal ghwaŋpɗə his ya ghwanagha Yesu da luwa. Kaʼa nda həŋ ma kɗaku tsi ka ghuna həŋ mantsa: «Yaha kuni dzaʼa da mndu kul nzakway ka la Yahuda. Yaha kuni lami da luwa la Samari. ");
INSERT INTO xed_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lawa tvə la Israʼila, hahəŋ ná, nda nza həŋ manda tuwak nda zaɗa. ");
INSERT INTO xed_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Lawa ka mna kuni ŋa taŋ kazlay: Ndusagagha ndusa ga mghama Lazglafta, kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ka mbamba kuni ta gwal kul ɗughwanaku, ka sliʼaganapta kuni ta gwal nda rwa, ka mbambanafta kuni ta gwal nda ksa da rɗa mndu, ka ghazliŋta kuni ta ghwaɗaka sulkumha. Zlghaf ka mbalay kaghuni ka vla kaghuni guli ka mbalay. ");
INSERT INTO xed_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yaha kuni klaftá dər dasu, dər tsedi, dər skwi ŋa da manaka tsedi ma zliba ghuni. ");
INSERT INTO xed_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yaha kuni klaftá dər zliba mbuluh. Turtuktuk ka kuni da klaftá lgut. Yaha kuni klaftá ɓaɓah, dər dafa, kabga nda ra ka mutsay mnda slna ta skwa zayni. ");
INSERT INTO xed_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ka lamla kuni da luwa dagala, dər da zwaŋa luwa a tsi, zbawazba ta mndu ya nda fa vghani ŋa tsuʼaftá kaghuni. Ka nzata kuni ga tsa mndu ya ha ka sagha fitika sliʼafta ghuni. ");
INSERT INTO xed_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta lamə kuni da həga ga mndu ya, “ka nza zɗakwa Lazglafta nda kaghuni,” ka kuni dazlay. ");
INSERT INTO xed_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka nda fa vgha gwal ma tsa həga ya ŋa tsuʼa zɗaku katsi, dzaʼa nzaku tsa zɗakwa ghuni ya ta ghəŋa taŋ. Ala, ka fa a vgha taŋ wu katsi, ka vragaghuvra tsa zɗakwa ghuni ya da kaghuni. ");
INSERT INTO xed_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka kwalaghukwala lu ta tsuʼaftá kaghuni snaghuna a lu ta gwaɗa ghuni wu katsi, sliʼapwa sliʼa ma tsa həga ya, ka ma tsa luwa ya a tsi, ka tukwiŋta kuni ta rgitik ta səla ghuni. ");
INSERT INTO xed_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kahwathwata ka yu ta mnaghunata, baɗu tsay dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha ná, ta dərdər ŋa luwa Suduma nda Gwamura dzaʼa nzakwa tsi ka ŋa mnduha ma tsa luwa ya.» ");
INSERT INTO xed_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Wana yu ta ghuna kaghuni manda tuwakha da taba kramtak mtakha. Ka nzata kuni nda hiɗa manda nahaɗik, manda ghərbuʼ kul haɗ gwaɗa ta ghəŋani ya ká kuni da nzata guli. ");
INSERT INTO xed_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɗasuwa ká kuni, dzaʼa hlay mnduha ta kaghuni da vla guma. Dzaʼa sləvay həŋ ta kaghuni nda gaslərɓaha ma həga tagha skwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dzaʼa hlay lu ta kaghuni, kabga gwaɗa ta iʼi ta kəma ŋumna nda ya ta kəma mghamha. Ŋa nzakwa ghuni ka masləmtsəka ɗa ta kəma taŋ, nda ya ta kəma sanlaha ma mndəra mnduha. ");
INSERT INTO xed_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ka hlafhla lu ta kaghuni ka hladaghata ta kəma guma katsi, yaha kuni da ndana skwi ŋa mnay ghuni, nda ya ka kuni dzaʼa da gwaɗay. Dzaʼa vlaghunavla Lazglafta ta gwaɗa ya ŋa gwaɗay ghuni ma va tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tsa gwaɗa dzaʼa kuni gwaɗay ya ná, kaghuni a dzaʼa gwaɗay wu, Sulkuma Da ghuni dzaʼa gwaɗay nda ma kaghuni. ");
INSERT INTO xed_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Zwaŋamani dzaʼa vlatá zwaŋamani ŋa dzata. Dani dzaʼa vlatá zwaŋani ŋa dzata. Dzaʼa ndəranava ndəra zwana taŋ ta dadaha taŋ, ŋa vlatá həŋ ŋa pslata. ");
INSERT INTO xed_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dzaʼa husaŋhusa kuni ta inda mnduha ta ghəŋa gwaɗa ta iʼi. Ama mndu dzaʼa kɗanakta ná, dzaʼa mbaku. ");
INSERT INTO xed_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka ta giri lu ŋa ghuni ma sana luwa katsi, ka hwaya kuni da sana luwa. Kahwathwata ka yu ta mnaghunata, ma kɗaku kuni ka ranaftá inda luwaha la Israʼila ná, dzaʼa vragaghavra Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Malaghumala a mndu ta taghə lu ta skwi ŋani, ka mndu ta taghanatá skwi wa. Malaghumala a kwalva ta daŋahəgani guli wa. ");
INSERT INTO xed_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Laviŋlava mndu ta taghanata lu ta skwi ta nzakway ka guram nda mndu ta taghanatá skwi. Laviŋlava kwalva ta nzakway ka guram nda daŋahəgani guli. Ka si halaway, ka lu ta hga daŋahəga ya ní, kighkigh ká lu dzaʼa hga gwal ma tsa həga ya tama?» ");
INSERT INTO xed_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yaha kuni da zləŋa həŋ. Haɗ skwi bukwana lu dzaʼa kwal kul sabi ta daɓi wa. Haɗ skwi ɗifana lu dzaʼa kwal lu tsatsafta guli wa. ");
INSERT INTO xed_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Skwi mnaghuna yu ma grum ya ná, mnawa mna baŋluwa. Skwi mnaghuna lu ma sləməŋ ma sləməŋ ya guli ná, guguɗawa guguɗa ta wa lilwa. ");
INSERT INTO xed_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma zləŋ kuni ta gwal ta dzatá sluʼuvgha ta kwal kul laviŋta dzatá hafu. Lazglafta ta laviŋta zaɗanatá sluʼuvgha nda hafu tani ma həga vu ya ŋa zləŋay katək. ");
INSERT INTO xed_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Haɗ lu ta skwaptá tiyti his ta kwaɓu ra? Kulam nda tsa ná, haɗ ya dər turtuk ma həŋ dzaʼa zaɗavaghuta kul ɗvaftá Da ghuni wa. ");
INSERT INTO xed_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nduk nda swidi ma ghəŋa ghuni tani ná, mbəɗaf mbəɗa Lazglafta demdem. ");
INSERT INTO xed_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaha kuni da zləŋ, mal kaghuni sgitani ka ndəghata tiytiha. ");
INSERT INTO xed_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Tsaya tama, ka ŋa Yesu iʼi ka mndu ta kəma inda mndu katsi ná, iʼi guli ná, ŋa ɗa na mndu na wu, ka yu dzaʼazlay ta kəma Da ɗa ta nzakway ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ala, ka ŋa Yesu a iʼi wu, ka mndu ta kəma mnduha ya guli ná, iʼi guli ná, ŋa ɗa a na mndu na wu, ka yu dzaʼazlay ta kəma Da ɗa ta nzakway ta luwa.» ");
INSERT INTO xed_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Yaha kaghuni da ndanay kazlay: Zɗaku klagagha iʼi da ghəŋa haɗik kəʼa. Kafay klagagha yu. ");
INSERT INTO xed_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Saghasa yu da dganatá i zwaŋ nda dani, ta i makwa nda mani, ta i ghwaʼali nda midzani. ");
INSERT INTO xed_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Gwal ma həga ga mndu dzaʼa nzakway ka ghuma mndu ma va tsa həga ya.» ");
INSERT INTO xed_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Ka malaghumala ɗvafta mndu ta dani ka mani a tsi ka iʼi ná, ta nza a tsa mndu ya ka ŋa ɗa wa. Ka malaghumala ɗvafta mndu ta zwaŋani ka makwani a tsi ka iʼi ná, ta nza a tsa mndu ya ka ŋa ɗa guli wa. ");
INSERT INTO xed_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ka kla a mndu ta udza zləŋayni ka dzaʼa mista ɗa wu ná, ta nza a tsa mndu ya ka ŋa ɗa wa. ");
INSERT INTO xed_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ka ta nzula hafa ɗa yu ka mndu katsi ná, dzaʼa zaɗiŋzaɗa tsa mndu ya ta tsa hafani ya. Mndu ta zaɗiŋtá hafani ta gwaɗa ta iʼi guli ná, dzaʼa mutsay tsa mndu ya ta tsa hafani ya guli.» ");
INSERT INTO xed_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ka tsuʼaftsuʼa mndu ta kaghuni, iʼi tsaya tsuʼaf tsi. Mndu ta tsuʼaftá iʼi guli, mndu ta ghunagatá iʼi tsaya tsuʼaf tsi guli. ");
INSERT INTO xed_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mndu ta tsuʼaftá anabi kabga nzakwani ka anabi ná, dzaʼa mutsay ta nisəla manda ya ta vlə lu ŋa anabi. Mndu ta tsuʼaftá mndu tɗukwa, kabga nzakwani ka mndu tɗukwa ná, dzaʼa mutsay ta nisəla manda ya ta vlə lu ŋa mndu tɗukwa. ");
INSERT INTO xed_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mndu ta tanaftá dər leghwa imi ləŋləŋa yeya tsi ŋa say ta sani turtuk mataba tsa zwaniha ya, kabga nzakwani ka duhwala ɗa ná, kahwathwata ka yu ta mnaghunata, haɗ nisəla tsa mndu ya dzaʼa zwaɗuta wa.» ");
INSERT INTO xed_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Manda kɗakwa Yesu ta tsa tagha skwiha ŋa tsa duhwalhani ghwaŋpɗə his ya ná, ka sliʼaftá tsi hada ka laghwi da ra luwaha ma tsa haɗik ya ŋa tagha skwiha, nda ya ŋa mna Lfiɗa Gwaɗa. ");
INSERT INTO xed_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma tsa fitik ya, ma gamak na Yuhwana mnda maga batem. Ka snaŋtá tsi ta mna gwaɗa ta Kristi nda slnaha ta magə tsi. Ka ghunaftá tsi ta sanlaha ma duhwalhani ");
INSERT INTO xed_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","da ɗawaŋta da Yesu kazlay: Kagha Kristi dzaʼa sagha ya re, ari ka kzla ŋni ta sana mndu a na kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Yesu nda həŋ mantsa: «Lawa mnanatá Yuhwana ta skwi ya snaŋ kuni nda skwi ya nghaŋ kuni. ");
INSERT INTO xed_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nda ngha gwal si nda ghulpa ta vli. Ta mbaɗa gwal si nda raghwa səla taŋ. Nda mbamba gwal si nda rɗa mndu ta həŋ. Nda sna gwal si ka matghəm ta sləməŋ. Sliʼagapsliʼa gwal si ta rwuta. Mnanamna lu ta Lfiɗa Gwaɗa ta gwal ka pɗu. ");
INSERT INTO xed_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rfu da mndu ya kul kwalaghutá zlghaftá iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ta sliʼi duhwalha Yuhwana ka vru, ka mnə Yesu ŋa dəmga ta gwaɗa ta Yuhwana, kaʼa mantsa: «Nahgani laghu kuni da nghay ma mtak na? Gagaɗak ta vyə falak rki laghu kuni da nghay na? ");
INSERT INTO xed_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nahgani laghu kuni da nghay ɓa? Mndu ta suɗavata lgut nda bla rki laghu kuni da nghay? Ya wya gwal ta suɗavatá lgut nda bla nda bla ta həŋ ná, ma həga ga mghamha həŋ. ");
INSERT INTO xed_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nu va skwi laghu kuni da nghay tama? Anabi rki laghu kuni da nghay? Mantsa nzakwani, ka yu ta mnaghunata ná, malaghumala tsa mndu ya ta anabi. ");
INSERT INTO xed_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tsatsi tsa mndu mnə deftera Lazglafta ta gwaɗa ta ghəŋani kazlay: Wya yu ta tiŋlaghutá ghunafta mnda ɗa ka kagha ŋa payaghatá tvi kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kahwathwata ka yu ta mnaghunata na: Mataba inda mndu ya yaga marakw nda ya ná, haɗ mndu ya ta zlagapta ka malaghutá Yuhwana mnda maga batem wa. Tsaw tama ná, mndu ya ta htuta katakata ma ga mghama Lazglafta ná, malaghumala ta tsatsi. ");
INSERT INTO xed_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Daga ta fitika Yuhwana mnda maga batem, ha ka sagha ta gitana, ta hwisay lu nda mbraku ta ga mghama Lazglafta. Ta zbay tsa gwal ta hwisay nda mbraku ya ta zluʼatá tsa ga mghama Lazglafta ya guli. ");
INSERT INTO xed_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Inda la anabi nda deftera Musa tani, mnumna həŋ ta gwaɗa ta ghəŋa tsa ga mghama Lazglafta ya, ha ka sagha ta fitika zlagapta Yuhwana. ");
INSERT INTO xed_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kata kumay kuni ta snaŋta katsi ná, Yuhwana tsa Iliya dzaʼa vragaghata ya. ");
INSERT INTO xed_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ka mamu mndu nda sləməŋa snay ka sna tsi. ");
INSERT INTO xed_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Nda wa dzaʼa gra yu ta mnduha ta na zamana na na? Manda tskatá vgha zwani ta luma ta tsgha lwi ŋa graha taŋ ");
INSERT INTO xed_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","kazlay: Vyanafha ŋni ta siŋlak ná, skala a kuni wu, fanafha ŋni ta laha ta ŋaɗa ghəŋ, tawa a kuni wu kəʼa ya həŋ. ");
INSERT INTO xed_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Saghaha Yuhwana, za a ta skwi wu, sa a ta skwi wu, “aʼ nda halaway ma ghəŋani!” ka mnduha nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Saghaha Zwaŋa mndu, ta zay ta skwi, ta say ta skwi, “aʼ mamblahawa ya, dagala sasakwani, aʼ gra gwal tska dzumna, nda gwal dmaku ya,” ka həŋ nda tsi. Kulam nda tsa, ta nghaku ɗifla Lazglafta ma slnahani.» ");
INSERT INTO xed_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tahula tsa tama, ka tsukunustá tsi nda gwaɗa ta luwaha ya maga tsi katakata ta mazəmzəmhani mida, kabga kwalaghuta taŋ ta mbəɗanaftá nzakwa taŋ. Kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ɗaŋwa ŋa gha luwa Kwariziŋ! Ɗaŋwa ŋa gha luwa Betsayda! Ka má tsa mazəmzəm magə lu ma luwa gha ya, má maga ma luwa Tir, nda luwa Siduŋ lu katsi ná, má gitagita a ta mbəɗanaftá həŋ ta nzakwa taŋ ka pghavatá buhu nda hutiɗif ta vgha wa. ");
INSERT INTO xed_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tsaya ta kəl yu ka mnaghunata kazlay: Baɗu tsay dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha ná, ta dərdər ŋa luwa Tir nda luwa Siduŋ dzaʼa nzakwa tsi ka ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Kagha guli Kafarnahum! Dzaʼa kapay Lazglafta ta iʼi ta luwa ka kagha ta gray ra? Bukwa a gha tsa! Dzaʼa vradaghavra lu tɗəm da vla gwal nda rwa. Ka má tsa mazəmzəm maga lu ma luwa gha ya, má maga ma luwa Suduma lu katsi ná, má ta tekeʼa luwa Saduma gita na. ");
INSERT INTO xed_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tsaya ta kəl yu ka mnaghunata kazlay: Baɗu tsay dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha ná, ta dərdər ŋa luwa Suduma dzaʼa nzakwa tsi ka ŋa gha kəʼa.» ");
INSERT INTO xed_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma va tsa fitik ya, ka Yesu mantsa: «Ta rfay yu ta kagha Da, Mghama luwa nda haɗik tani, kabga ɗifana ɗifa ka ta na skwiha na da gwal nda ɗifil ma ghəŋa taŋ, nda gwal nda sna ta skwi, ka maranatá ka ta zwani. ");
INSERT INTO xed_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Manda va tsa nzakwani Da, ta rfay yu ta kagha, ma zɗakwa gha nzakwa tsi mantsa. ");
INSERT INTO xed_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Da ɗa ta vliha ta inda skwi. Haɗ sana mndu nda sna ta Zwaŋ wa, ba Da yeya nda sna. Haɗ sana mndu nda sna ta Da guli wa, ba Zwaŋ yeya nda sna, nda mndu ta kumə Zwaŋ ta maranata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Saghawasa da iʼi inda kaghuni gwal nda hərfa da ndəgaku ka mbiʼaghunapta yu ta vgha. ");
INSERT INTO xed_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Zba a yu ta nzaghunaghata wa. Klawakla ta ndəgaku ya ta klə yu, ka tagha kuni ta skwi da iʼi, mantsa ya dzaʼa kəl kuni ka mutsaftá mbiʼa vgha. ");
INSERT INTO xed_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Manda va tsaya nzakwani, skwi ya dzaʼa faghunaghata yu ná, ndəgaghunata a wa. Kafkafani nzakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma va tsa fitik ya, baɗu fitika sabat, ka labə i Yesu nda duhwalhani nda ma vwaha hya. Ka kuzlanaftá maya ta duhwalhani. Ka ɓalaʼatá həŋ ta ghəŋa alkama ŋa dghaɗay. ");
INSERT INTO xed_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nghay la Farisa ta tsa skwi ta magə həŋ ya ná, ka həŋ nda Yesu mantsa: «Ngha ta duhwalha gha ɓa! Waʼa həŋ ta maga skwi kul raku ka magay baɗu sabat,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka Yesu nda həŋ mantsa: «Ta dzaŋaf a kaghuni ta skwi ya maga Dawuda kuzlanafər maya, nda gwal kawadaga nda tsatsi tani ra? ");
INSERT INTO xed_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ka lamə həŋ da həga Lazglafta ka zuta həŋ ta skwa zay fana lu ta Lazglafta. Haɗ sana mndu ta za tsa skwa zay ya, dər Dawuda, dər tsa gwal kawadaga nda tsi ya mazlay wu, ba gwal dra skwi ŋa Lazglafta yeya ta zay. ");
INSERT INTO xed_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ari ta dzaŋaf a kuni ma deftera zlahu kazlay: Baɗu sabat ná, ta zluŋzla gwal dra skwi ŋa Lazglafta ta zlaha sabat ta magə həŋ ta slna ma həga Lazglafta, ksaf a ta həŋ ka dmaku wu kəʼa na? ");
INSERT INTO xed_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tsaw ka yu ta mnaghunata ná, mamu sana skwi hadna ta malaghutá həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ka má nda sna kuni ta klatá ghəŋa skwi mnə lu kazlay: Tawa hiɗahiɗa skwi ta zɗigihata pla ghəŋ nda rini a wu kəʼa ya ná, má haɗ kuni dzaʼa mnay kazlay: Magamaga həŋ ta dmaku, kəʼa nda tsa gwal kul haɗ dmakwa taŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Zwaŋa mndu ná, tsatsi mgham ta ghəŋa fitika sabat,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ka sliʼaftá Yesu ka zlaŋtá tsa vli ya, ka laghwi da həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hada, mamu sana mndu nda mta dzvani. Ka mnduha ɗawaŋta da Yesu mantsa: «Vlavla zlaha mu ta tvi ŋa mbanaftá mndu baɗu sabat re, ari ki na?» ka həŋ nda tsi ŋa mutsaftá rutsak tida. ");
INSERT INTO xed_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kaʼa nda həŋ mantsa: «Waya mataba ghuni, ka dəɗaghatá kɗakwa tuwakani turtuktuk da gudzuvruŋ baɗu sabat, dzaʼa kwal kul kligiŋtá tsa tuwakani ya na? ");
INSERT INTO xed_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Malaghumala a mndu ka tuwak ra? Tsaya tama ná, pyaf a lu ta mndu ka maga zɗaku baɗu sabat wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kaʼa nda tsa mndu nda mta dzvani ya mantsa: «Tɗap dzva gha,» kaʼa. Ka tɗaptá tsi, gi yəmaɗ vravafvra tsa dzvani ya manda va tsa sanani ya. ");
INSERT INTO xed_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ka gi gazlagaptá la Farisa, ka laghwi dzrəku ŋa zba tvi ŋa zaɗiŋtá Yesu. ");
INSERT INTO xed_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tsatsafta Yesu ta tsa ndana taŋ ya, ka sliʼaftá tsi ma tsa vli ya, ka laghwi. Ka sliʼaftá dəmga guli ka laghwi mistani, ka mba mbə tsi ta inda gwal ma ɗaŋwa. ");
INSERT INTO xed_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka zlahanaghatá tsi ta həŋ ka ŋɗaŋɗa kazlay: Yahayaha kuni da mnihata kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kəl tsi ka mnay mantsa ya ná, nda nza ŋa dzanaghatá ghəŋa gwaɗa ya mna anabi Isaya kazlay: ");
INSERT INTO xed_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Wya kwalva ɗa ya zbap yu, ya ɗvu yu, ya ta zɗigihata katakata, dzaʼa fanaghafa yu ta Sulkuma ɗa, dzaʼa mnanamna ta inda mndəra mndu kazlay: Tuɗukwa guma ɗa kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Zbəta a ta zlərɗawi wa. Dzəta a ta lawlaw wa. Haɗ mndu dzaʼa snaŋta ta guguɗaku ta pazlala wa. ");
INSERT INTO xed_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Haɗ dzaʼa kɗəgliŋtá ɓlanaptá sulam nda ghada ŋatani wa. Haɗ dzaʼa kɗiŋta mtəgliŋtá pitirla ta mtaku mtaku guli wa. Mantsa ya dzaʼa maga tsi ha ka vlaŋtani ta za ghwa ta skwi tɗukwa. ");
INSERT INTO xed_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ŋa fafta mndəra mnduha ta ghəŋa taŋ ta hgani kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka kladaghatá lu da Yesu ta sana mndu ksu ghwaɗaka sulkum ta ghulpiŋta, ka tsiŋta ka rgha guli. Ka mbanaftá tsi. Ka gwaɗə tsa mndu ya ta gwaɗa tsəleŋ, ka nghaŋtá tsi ta vli tsiɗiɗ guli. ");
INSERT INTO xed_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","«Zlah zwaŋa Dawuda a na mndu na wu re?» ka mnduha ka ndərmimay. ");
INSERT INTO xed_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na snaŋta la Farisa ta tsa skwi ya, ka həŋ mantsa: «Nda mbrakwa halaway ta nzakway ka mghama ghwaɗaka sulkumha ya ta ghazla tsi ta ghwaɗaka sulkumha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tsaw nda sna Yesu ta skwi ta ndanu həŋ. Kaʼa nda həŋ mantsa: «Ka ta lmuvuslma va tsa ga mgham turtuk ya ta lmu katsi ná, sladglata a tsa ga mgham ya wa. Ka ta lmuvustalmu gwal ma luwa turtuk, ka gwal ma həga turtuk a tsi guli ta lmu ná, haɗ ya dzaʼa sladglata ma həŋ guli wa. ");
INSERT INTO xed_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka si ta ghzlay halaway ta halaway katsi ná, dgavapdga tsa halaway ya nda tsa tama. Waka ga mghamani dzaʼa sladglata tama na? ");
INSERT INTO xed_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ka si nda mbrakwa Halaway ta ghzla yu ta ghwaɗaka sulkum ya ní, nda mbrakwa wa ta ghazla zwana ghuni guli? Tsaya tama, vərɗa hahəŋ dzaʼa tsaghunatá gumani. ");
INSERT INTO xed_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ala, ka si nda Sulkuma Lazglafta ta ghzla yu ta ghwaɗaka sulkumha katsi, ɓhavaghunaɓha ga mghama Lazglafta nda tsa tama. ");
INSERT INTO xed_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Ari, waka mndu dzaʼa laviŋtá lami da həga ga mndu nda mbra ka hluguduŋtá huzlani ta kul habaftá tsi ta tsa mndu nda mbra ya na? Tahula tsaya dzaʼa kəl tsi ka hluguduŋtá huzlani. ");
INSERT INTO xed_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Mndu kul haɗ mista ɗa ná, ghuma ɗa tsa mndu ya. Mndu kul haɗ ta katihata nda tskanata guli ná, kwizidiŋtá ŋa tsa mndu ya ta kwizay. ");
INSERT INTO xed_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tsaya ta kəl yu ka mnaghunata kazlay: Inda dmaku ta gə mndu, nda rutsak ya ta pghə tsi ta Lazglafta ná, dzaʼa plinispla lu ta həŋ. Ama mndu ta vzaftá rutsak ta Sulkum nda ghuɓa ná, haɗ lu dzaʼa plinistá dmakwani wa. ");
INSERT INTO xed_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ka vzafvza mndu ta rutsak ta Zwaŋa mndu katsi, dzaʼa plinispla lu ta dmakwani. Ama mndu ta vzaftá rutsak ta Sulkum nda ghuɓa ná, haɗ lu dzaʼa walaŋtá plinistá dmakwani, dər ta na zamana na, dər ta zamana dzaʼa sagha wa.» ");
INSERT INTO xed_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ka si zɗa ya fu ya, ka lu ná, zɗa yakwani. Ka si zɗa a ya fu ya wu, ka lu ná, zɗa a yakwani guli wa, kabga ta yakwani ta tsatsafta lu ta fu. ");
INSERT INTO xed_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mndəra la mupuha na! Waka kuni si má dzaʼa mnagaptá skwi ɗina, kaghuni la ghwaɗak na! Ka nu ndəghatá skwi ma ŋuɗufa mndu ta mnigiŋta wubisima mndu. ");
INSERT INTO xed_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ŋərma mndu ná, ma tsa ŋərma skwiha ma ŋuɗufani ya ta kligista tsi ta skwi ɗina. Ghwaɗaka mndu guli ná, ma tsa ghwaɗaka skwiha ma ŋuɗufani ya ta kligista tsi ta ghwaɗaka skwi. ");
INSERT INTO xed_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ka yu ta mnaghunata ná, nda wa taŋ dzaʼa mnəgiŋta mnduha baɗu guma ta inda ŋaslu ya brəfəgiŋ həŋ. ");
INSERT INTO xed_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nda gwaɗa ma wa gha dzaʼa tsaghaghata lu ta guma. Ka ŋa kwala dmakwa gha kul haɗ tsi, ka ŋa nzakwa dmakwa gha mamu a tsi.» ");
INSERT INTO xed_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ka sanlaha ma gwal tagha zlahu ŋa mnduha, nda sanlaha ma la Farisa guli, nda Yesu mantsa: «Mghama ɗa, ta kumay ŋni ta magata gha ta mazəmzəm ŋa grafta ŋni kazlay: Sa daga da Lazglafta ka kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka Yesu nda həŋ mantsa: «Ghwaɗak mnduha ta na fitik na. Haɗ həŋ ta zləŋa Lazglafta wa. Ta ɗawa mazəmzəm həŋ. Haɗ sana mazəmzəm dzaʼa maganata lu ta həŋ, ka tsa ŋa anabi Yunusa ya a tsi wa. ");
INSERT INTO xed_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Manda va ya maga anabi Yunusa ta vaghu hkən nda rviɗik hkən ma huɗa mghama klipi ya, manda va tsaya guli dzaʼa magata Zwaŋa mndu ta vaghu hkən nda rviɗik hkən ma haɗik. ");
INSERT INTO xed_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ghalya guli, gwal ma luwa Niniva ná, snasna həŋ ta gwaɗa anabi Yunusa, ka mbəɗanaftá həŋ ta nzakwa taŋ. Wana mamu mndu ta malaghutá anabi Yunusa hadna. Baɗu tsay dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha, “ŋa ghuni dmaku,” ka gwal ma luwa Niniva dzaʼa sliʼafta mnay ŋa mnduha ta na fitik na. ");
INSERT INTO xed_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ghalya, ka sliʼaftá sana marakw ta ga mgham ma vli diʼiŋ nda ga sud, ka lagha da sna ɗifla Salumuŋ. Wana mamu mndu hadna ta malaghutá Salumuŋ nda ɗifil. Baɗu tsay dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha, “ŋa ghuni dmaku,” ka tsa marakw ya dzaʼa mnanatá mnduha ta na fitik na.» ");
INSERT INTO xed_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ka sabsa ghwaɗaka sulkum ma mndu katsi, ŋa dzaʼani da ra vli tuhwayaŋ tuhwayaŋa ka zba vli ŋa mbiʼa vghani. Ka triɗ mutsaf a tsi ta tsa vli ŋa mbiʼa vghani ya wu katsi, ");
INSERT INTO xed_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“ka vra yu da tsa həga ɗa sabə yu mida ya gra,” kaʼa dzaʼazlay, ŋa sliʼaftani ka vradaghata. Ka ta vradaghatá tsi nda tsukwa vli mida, nda paya ɗina katsi, ");
INSERT INTO xed_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yawa da! kəʼa dzaʼazlay ŋa vraghutani, ŋa hlanaktani ta sanlaha ma ghwaɗaka sulkumha ndəfáŋ ta malaghutá tsatsi nda sidi. Ŋa lama taŋ da tsa həga ya ka nzamta mida. Mantsa tama, dzaʼa nzakway ɓadzatá nzakwa tsa mndu ya ka malaghutá nzakwani taŋtaŋ. Manda va tsaya dzaʼa nzakwa tsi nda na mnduha ta na ghwaɗaka fitik na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tata gwaɗa tsa gwaɗa ya Yesu nda dəmga ná, ka ɓhadaghatá i mani nda zwanamani, ka nzaghutá həŋ ma bli, ka zbə həŋ ta gwaɗganata. ");
INSERT INTO xed_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka sana mndu nda tsi mantsa: «Waʼa i ma gha nda zwanama gha ma bli ta zba gwaɗgaghata,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Yesu nda tsa mndu ta mnay ŋani ya mantsa: «I wa i ma ɗa nda zwanama ɗa na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ka fadaptá tsi ta dzvu tvə duhwalhani, kaʼa mantsa: «Wana i ma ɗa nda zwanama ɗa. ");
INSERT INTO xed_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Dər wati ma mndu ta maga skwi ya kumaŋ Da ɗa ta nzakway ta luwa ná, tsa mndu ya ta nzakway ka zwaŋama ɗa, nda mukuma ɗa, nda ma ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Baɗu va tsa fitik ya, ka sabi Yesu ma həga ka laghwi nzata ta wa drəf. ");
INSERT INTO xed_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka tskadaghatá dəmga ŋərɓisl ta vgha ta vatani. Ka sliʼaftá tsi ka laghwi nzagapta ma kwambalu ta nzatá inda mnduha ta wa ghwa. ");
INSERT INTO xed_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka mnə tsi ta ndəghata skwiha ŋa taŋ ka mahdihdi, kaʼa mantsa: «Mbaɗa sana mndu ka sliʼafta ka laghwi da wutsa hulfani. ");
INSERT INTO xed_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tata wutsay wutsay, ka rkatá sanlaha ma hulfa ta tvi, ka sliʼaktá ɗyakha ka ɗaguta. ");
INSERT INTO xed_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka rkatá sanlaha ta kluluh ma vli kul slaghutá haɗik, ka gi ɗyaftá tsi misimmisim kabga sira a haɗik ta ghəŋani wa. ");
INSERT INTO xed_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na safa fitik dzafta tida ka zlghutá tsi həw ka ghwaluta, kabga slaghu a slrəŋ mistani wa. ");
INSERT INTO xed_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka rkamtá sanlaha ma teki, ka glanaghatá teki ka raghwanata. ");
INSERT INTO xed_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka rkatá sanlaha ta gənək, ka ɗyaftá tsahaya ka glaftá tsi ka pghaftá ghəŋ ka zwaŋ dzeʼdzeʼ, ɓərzləzla ghəŋa sanlaha, selela ghəŋa sanlaha, miɗiɗa ghəŋa sanlaha.» ");
INSERT INTO xed_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ka sganaghatá Yesu, kaʼa mantsa: «Mndu nda sləməŋa snay ka sna tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka gavanavatá duhwalhani, ka həŋ mantsa: «Kabgawu ta kəl ka ka mna gwaɗa ŋa taŋ ka mahdihdi katək na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka Yesu nda həŋ mantsa: «Kaghuni ná, vlaghunavla lu ta snaŋtá vərɗa ɗifatá ga mghama Lazglafta, ama vlaŋ a lu ta hahəŋ wa. ");
INSERT INTO xed_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ŋa mndu mamu skwi da tsi ta sganaghata lu, ŋa sgutani da tsi. Ama mndu ya kul haɗ skwi da tsi ná, dzaʼa kləgadanaghu kla lu ta va tsa kiʼa da tsi ya. ");
INSERT INTO xed_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tsaya ta kəl yu ka mnay ka mahdihdi ŋa taŋ, kabga dər nghaŋha həŋ, ngha a həŋ wa. Dər snaŋha həŋ nda sləməŋa taŋ katək, sna a həŋ wu, graf a həŋ guli wa. ");
INSERT INTO xed_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","«Ta ghəŋa taŋ dəɗafta tsa gwaɗa Lazglafta ta mnay nda ma wa anabi Isaya kazlay: “Dər dzaʼa nda sna kuni nda sləməŋa ghuni, grafta a kuni wa. Dər dzaʼa nda ngha kuni nda ira ghuni, nghaŋta a kuni wu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Təŋu təŋa ghəŋa na mnduha na. Dərzlaf dərzla həŋ ta sləməŋa taŋ, hafha həŋ ta ira taŋ, kabga va a həŋ ta nghaŋta wa, yaha həŋ da snaŋta nda sləməŋa taŋ, yaha həŋ da grafta ma ŋuɗufa taŋ, yaha həŋ da mbəɗanaftá nzakwa taŋ, da mbanaftá yu ta həŋ.” ");
INSERT INTO xed_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Kaghuni ná, nda tfawi ta ghəŋa kaghuni, kabga nda ngha ira ghuni ta vli, nda sna sləməŋa ghuni ta sləməŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kahwathwata ka yu ta mnaghunata: Nda ndəgha la anabi nda gwal tɗukwatɗukwa nzakwa taŋ si ta ɗvaŋta nghaŋtá na skwi nghaŋ kaghuni na, lay ngha a həŋ wa. Si ta kumay həŋ ta snaŋtá na skwi snaŋ kaghuni ná, sew sna a həŋ wa,» kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Snawasna tama ta klatá ghəŋa gwaɗa ta ghəŋa tsa mndu ta wutsa hulfa ya. ");
INSERT INTO xed_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tsa tvi rkaf hulfa tida ya ná, gwal ta snaŋtá gwaɗa ta ga mghama Lazglafta kul grafta həŋ ya, həŋ. Ka sagha halaway zluʼugudunustá həŋ ta tsa skwi wutsam lu ma ŋuɗufa taŋ ya. ");
INSERT INTO xed_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tsa kluluh rkaf hulfa tida ya ná, tsaya mndu ta snaŋtá gwaɗa ta ga mghama Lazglafta, gi ka tsuʼaftá tsi nda rfu. ");
INSERT INTO xed_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tsaw tama, haɗ slrəŋ mistani wu, nzɗava a wa. Ka gi gruŋgra ghuya ɗaŋwa, ka giri a tsi kabga tsa gwaɗa ya, gi zləmbutani. ");
INSERT INTO xed_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tsa vli ma teki rkam hulfa mida ya guli ná, tsaya gwal ta snaŋtá gwaɗa Lazglafta, ka laghu həŋ da ndana skwiha ma ghəŋa haɗik, nda skwa gadghəl, ka raghwanatá tsa skwiha ya ta tsa gwaɗa ya ma həŋ, ka niŋtá həŋ ka ksubaŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tsa gənək rkaf hulfa tida ya guli ná, tsaya gwal ta snaŋtá gwaɗa Lazglafta ka snatá həŋ, ka magaftá həŋ: Ghərmbəts ghərmbəts sanlaha, salala sanlaha, miɗiɗa sanlaha.» ");
INSERT INTO xed_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kaʼa nda həŋ nda sana mahdihdi mantsa: «Ka guram ga mghama Lazglafta nda sana mndu ta sləgamtá vərɗa hulfa hya ma vwahani. ");
INSERT INTO xed_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Girviɗik, sliʼaghuslia lamndu da vlə hani, ka lagha ghumani da sləginistá rira distani ka laghwani. ");
INSERT INTO xed_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Manda ɗyafta tsa hulfa ya ka pghaftá ghəŋ, ka zlagaptá rira guli. ");
INSERT INTO xed_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ka lagha kwalvaha tsa daŋahəga ya mnay ŋani, ka həŋ mantsa: “Mghama ɗa! vərɗa hulfa a sləgam kagha ma vwaha gha kay ra? Lamə ndiga rira dida na?” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kaʼa nda həŋ mantsa: “Ghuma ɗa ta magatá tsa,” kaʼa. Ka tsa kwalvaha ya nda tsi mantsa: “Ta ɗvay ka ka dzaʼa ŋni rətiŋta rki na?” ka həŋ. Kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Zlaŋwazla, ma lə kuni da rətay, yaha kuni da gaɓiŋta nda vərɗa hya. ");
INSERT INTO xed_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Zlaŋwa həŋ ka glakwa həŋ ka skwa turtuk ha ka sagha fitika tskay ta vwah. Tskapwa tska karaku ta rira, ka habafta kuni ŋa driŋta nda vu. Vərɗa hya ya, ka tskiɗimta kuni da guvura ɗa, ka yu dzaʼazlay nda gwal tska skwi ta vwah,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kaʼa nda həŋ nda sana mahdihdi kay guli mantsa: «Ga Mghama Lazglafta ná, ka guram nda hya kramasa klaf mndu ka sləgamta ma vwahani. ");
INSERT INTO xed_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndərzikwa tsatsi mataba inda hulfaha, ama ka ɗyaf ɗya tsi ka glafta, mal tsatsi mataba hulfa niɗaliha. Ta nuna gdiz ka fu, ŋa sliʼadaghata ɗyakha da baba həga taŋ ta zligamahani.» ");
INSERT INTO xed_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kaʼa nda həŋ nda sana mahdihdi guli mantsa: «Ka guram ga mghama Lazglafta nda is ta klafta marakw ka laɓanamta ma kuratá darama hupu hkən ŋa ŋlaftá tsa hupu ya demdem,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ka mahdihdi mnanata Yesu ta inda tsa skwiha ya ta dəmga. Haɗ sana skwi mnanaŋ tsi ta həŋ kul haɗ ka mahdihdi wa, ");
INSERT INTO xed_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","kada nzakwa dzatá ghəŋa gwaɗa anabi ta mnay kazlay: «Ka mahdihdi dzaʼa gwaɗa yu ta gwaɗa nda həŋ. Dzaʼa mnigiŋmna yu ta skwiha nda ɗifa daga ka ya wu zlraftá ghəŋa haɗik kəʼa ya». ");
INSERT INTO xed_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mbaɗa Yesu ka zliŋtá dəmga, ka sliʼaftá tsi ka laghu da həga. Ka gavanavatá duhwalhani, ka həŋ nda tsi mantsa: «Pslaŋnap psla ta klatá ghəŋa tsa mahdihdi ta ghəŋa rira ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kaʼa nda həŋ mantsa: «Tsa mndu ta sləgamtá vərɗa hulfa hya ya ná, Zwaŋa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vwah ya guli ná, ghəŋa haɗik tsa. Vərɗa hulfa hya ya guli ná, gwal ta nzakway ka ŋa ga mghama Lazglafta ya. Rira ya guli ná, gwal ta nzakway ka ŋa halaway ya. ");
INSERT INTO xed_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tsa ghuma ta sləgamta ya guli ná, halaway ya. Tsa tska skwi ta vwah ya, tsaya kɗakwa ghəŋa haɗik. Tsa gwal tska skwi ta vwah ya guli, tsaya duhwalha Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Manda va tsa tskaptá rira ŋa driŋta nda vu ya, manda va tsaya dzaʼa nzakwa tsi baɗu kɗavakta ghəŋa haɗik guli. ");
INSERT INTO xed_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dzaʼa ghunaga ghuna Zwaŋa mndu ta duhwalhani ŋa talaptá inda gwal ta pghamtá mndu da ga dmaku, nda gwal ta maga ghwaɗaka skwi, ŋa hliŋtá həŋ diʼiŋ nda ga mghamani, ");
INSERT INTO xed_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ka pghamtá həŋ da duda vu. Ŋa wahay taŋ ta wahu, ka hpaɗa sliʼiŋa taŋ hada. ");
INSERT INTO xed_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ama gwal ta nzakway tɗukwa ta wa ira Lazglafta ya, manda fitik dzaʼa wuɗakwa hahəŋ ma ga mghama Da taŋ. Ka mamu mndu nda sləməŋa snay, ka sna tsi.» ");
INSERT INTO xed_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ka guram ga Mgham Lazglafta nda gadghəl ta ɗifa ma sana vwah. Ka lagha sana mndu dukwafta tida. Ka ɗifglanata tsa mndu ya guli. Ka laghu tsi nda rfu da dzawiŋtá inda skwani ka skwata tsa vwah ya.» ");
INSERT INTO xed_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ka guram ga mghama Lazglafta nda sana mnda tsakala ta psa miziɗikwha nda bla dzvani. ");
INSERT INTO xed_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka mutsafta tsi ta tsa miziɗikw ya turtuk nda bla dzvani ya. Ka laghu tsi dzawiŋtá inda skwani ka skwata tsa miziɗikw ya.» ");
INSERT INTO xed_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ka guram ga mghama Lazglafta nda kadəŋ ta wuɗadata lu da drəf ŋa tumagaftani ta inda mndərga klipiha kavghakavgha. ");
INSERT INTO xed_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ndəghafta tsa kadəŋ ya, ŋa tɗagafta ta wa sgam. Tahula tsa, ŋa nzata ka ɗagaptá ya ɗinaɗina, ka pghamta ma tughuba, ŋa pghiŋta ghwaɗakhani. ");
INSERT INTO xed_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mantsa ya dzaʼa nzakwa tsi ma kɗakwa ghəŋa haɗik. Dzaʼa sliʼaga sliʼa duhwalha Lazglafta ŋa galapta taŋ ta ghwaɗaka mnduha mataba tɗukwani, ");
INSERT INTO xed_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ŋa pghaghata taŋ ta həŋ da duda vu, ŋa wahay taŋ ta wahu ka hpaɗa sliʼiŋa taŋ hada.» ");
INSERT INTO xed_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka Yesu nda duhwalhani mantsa: «Lamla inda tsa skwiha ya da sləməŋa ghuni rki na?» kaʼa nda həŋ. «Aŋi!» ka həŋ zlghanafta wani. ");
INSERT INTO xed_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kaʼa nda həŋ guli mantsa: «Tsaya tama ná, ka nuna mnda tagha zlahu ka duhwala ga mghama Lazglafta ná, ka guram nda daŋahəga ta mutsa skwa gadghəlani ma skwiha ka lfiɗ ka lfiɗ, nda ya ma skwiha nda kɗa fitikani, dzaʼa gra lu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tahula kɗiŋta Yesu ta mana tsa mahdihdiha ya, ka sliʼafta tsi hada ka laghwi. ");
INSERT INTO xed_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ka ɓhadaghata tsi da luwa Nazaret ta nzakway ka luwa ta glakwani. Ka taghə tsi ta skwiha ŋa mnduha ma həga tagha skwa taŋ. Ka ndərmim həŋ, ka həŋ mantsa: «Wa ta vlaŋtá mndərga na ma ɗifil? Wa ta vlaŋtá mbrakwa maga mndərga na ma mazəmzəm? ");
INSERT INTO xed_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Zwaŋa tsa mndu ta fiɗi ya a tsi kay ra? Mari a mani kay guli ra? I Yakubu, nda Yusufu, nda Simuŋ, nda Yuda a zwanamani kay ra? ");
INSERT INTO xed_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mataba amu a ta nzakwa kwaghamani kay guli ra? Tsaw wa ta vlaŋtá na ɗifil na, nda na mbraku na tama ɓa?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsahaya skwi ta pyafta həŋ ka zlghafta Yesu. Ka Yesu nda həŋ tama mantsa: «Ma luwani, nda ya ma həga ga taŋ yeya ta hərtətata lu ta anabi. Ama ma hamata vli ná, ta vlaŋvla lu ta glaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kiʼa yeya mazəmzəm magaŋ Yesu ma luwa Nazaret, kabga zlghaf a mnduha nda ŋuɗuf wa. ");
INSERT INTO xed_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma tsa fitik ya, ka snanaghatá gwaɗa ta Yesu ta Hiridus ta nzakway ka ŋumna ta haɗika Galili. Kaʼa nda kwalvahani mantsa: ");
INSERT INTO xed_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","«Yuhwana mnda maga batem ya ta sliʼagapta ma mtaku, tsaya kəl tsi ka mutsaftá mbrakwa maga mazəmzəm,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tsaw si mnamna Hiridus kazlay: Ksiɗifwa ksa ta Yuhwana kəʼa. Ka ksaftá lu, ka habafta, ka vzamta ma gamak ta ghəŋa gwaɗa ta Hiridiya markwa zwaŋamani Filip, ");
INSERT INTO xed_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kabga ka Yuhwana nda Hiridus na: «Raʼa ka klafta gha ka markwa ghuni wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Si ka zbə Hiridus ta tva dzata, ama ka zləŋaftá tsi ta dəmga, kabga ka anabi klafta mnduha ta Yuhwana. ");
INSERT INTO xed_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka sagha fitik ya ta grafta nda fitik ya kəl lu ka yatá Hiridus. Ka lagha makwa tsa Hiridiya ya kay da skalu ta kəma gwal hagadagha lu da vla skala havaktá tsa fitika yakwani ya. Ka zɗanaftá tsi ta ŋuɗuf ta Hiridus. ");
INSERT INTO xed_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kaʼa mantsa: «Dər nahgani ɗawaŋ ka da iʼi ná, ta vlaghavla yu,» kaʼa waɗanatá tsa makwa ya. ");
INSERT INTO xed_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ka mnanaftá mani ta hiɗaku. Ka tsa makwa ya mantsa: «Tsiɗiftsa ta kwambleh nda va nana ta ghəŋa Yuhwana mnda maga batem,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Suʼanak ka mgham nzata. Ama kabga ghadaghada ta waɗanata, hada tsa gwal hagadagha lu ya kay guli, kaʼa mantsa: «Lawala da tsagaghata ka vlaŋta kuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka ghunaftá tsi ta mnduha da tsagaghatá ghəŋa Yuhwana ma gamak. ");
INSERT INTO xed_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ka klaktá lu ta ghəŋa Yuhwana ta kwambleh, ka vlaŋtá tsa zwaŋa makwa ya, ka klaŋtá tsi ta mani. ");
INSERT INTO xed_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka lagha duhwalha Yuhwana da klaghatá mblani ka laghwi da paɗamta. Ka sliʼaftá həŋ ka laghwi mnanatá Yesu. ");
INSERT INTO xed_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Manda snaŋta Yesu ta tsa gwaɗa ya, ka sliʼaftá tsi hada nda kwambalu, ŋa laghwi nzakta kətsauʼ ta wa mazawa. Ka sniŋtá dəmga, ka sliʼaftá həŋ nda səla ka laghwi da zbiŋta. ");
INSERT INTO xed_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta sabi Yesu ma kwambalu, kəʼa kəʼa ná, tizlik mnduha. Ka ksaŋtá həŋ ta Yesu ka hiɗahiɗa, ka mbambanaftá tsi ta gwal kul ɗughwanaku guli. ");
INSERT INTO xed_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Gahawu, ka gavadaghata duhwalhani tavata Yesu. Ka həŋ nda tsi mantsa: «Ta wa mazawa na vli na, laghula fitik guli, vriŋvra ta na mnduha na ka dzaʼa həŋ da luwaha da zba skwi ŋa zay taŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka Yesu nda həŋ mantsa: «Zbaŋ a hahəŋ ta sliʼi wa, vlaŋwavla kaghuni ta skwa zay ta həŋ, ka za həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","«Buradi hutaf nda tsulhwa klipi his yeya da amu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","«Hligiɗighawa hla,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","«Nzawanza nda nza ta kuzuŋ,» kaʼa nda mnduha. Ka nzatá mnduha rpaʼ. Ka hlaftá tsi ta tsa buradiha hutaf nda tsulhwa klipi his ya, ka nghadaftá tsi nda ta luwa, ka rfanaghatá tsi ta Lazglafta, ka ɓalanaptá tsi ta tsa buradi ya, ka valaŋtá duhwalhani ŋa dgay ŋa dəmga. ");
INSERT INTO xed_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ka zə inda mnduha. Ka babaghutá həŋ. Ka tsakaftá lu ta paɗakwani ma vəl zay taŋ ka ghwanak ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tsa gwal si ta zay ya ná, ta magay həŋ ta dəmbuʼ hutaf, mbəɗa a lu ta miʼaha nda zwani wa. ");
INSERT INTO xed_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Gi tahula tsa, ka mblaftá Yesu ta duhwalhani ka lami da kwambalu ŋa dzaʼa ta sana ɓlu, ta nzaghutá tsatsi ŋa vriŋtá tsa dəmga ya. ");
INSERT INTO xed_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Manda vriŋtani ta həŋ, ka sliʼafta tsi ka laghwi nzata ta ghwá ŋa maga duʼa. Ta kuzutá rviɗik tukzum ná, ta hada turtukwani. ");
INSERT INTO xed_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta tsa luwa ya ná, ma takataka drəf na kwambalu ta takaɗa wuda nda gamtsaʼuwakwa imi, ta vray vray falak guli. ");
INSERT INTO xed_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta tsughbura sərɗək tama, ka sliʼaftá Yesu ka mbaɗa ta drəf ka dzaʼa tvə duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nghay duhwalhani ta mbaɗani ta drəf ná, ka ksaftá zləŋ ta həŋ. «Aya halalay!» ka həŋ ka wahu nda zləŋ nda zləŋ. ");
INSERT INTO xed_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gi ka Yesu nda həŋ mantsa: «Ma wahu kuni! Iʼi ya, ma zləŋ kuni ta zləŋ!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ka Piyer nda tsi mantsa: «Mghama ɗa, ka si kagha tsi ná, mnamna ka laba yu ta ghəŋa na imi na da kagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","«Saghasa!» kaʼa nda tsi. Ka sabə Piyer ma kwambalu, ka mbaɗa ta imi ka dzaʼa nda da Yesu. ");
INSERT INTO xed_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama nghayni ná, dagala falak, ka ksaftá zləŋ. Gi səlikw zlraftani ta dəɗaku da huɗa imi tsa. «Mghama ɗa, kata ta iʼi!» kaʼa wahata. ");
INSERT INTO xed_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ka gi fadaptá Yesu ta dzvu ka ŋanata. «Nda hta zlghay nda ŋuɗufa gha, kabgawu kəl ka ka dga ghəŋ na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka sliʼaftá həŋ ka lami da kwambalu, ka lɓata tsa falak ya. ");
INSERT INTO xed_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","«Kagha ná, vərɗa Zwaŋa Lazglafta ka,» ka tsa gwal ma kwambalu ya sliʼadaghata da tsəlɓu ma ghuva Yesu. ");
INSERT INTO xed_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tahula tsughwaɗapta taŋ ta drəf, ka ɓhadaghata həŋ ta haɗika Genazaret. ");
INSERT INTO xed_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tsəmafta gwal ma tsa vli ya ta Yesu, ka tsaghaghatá həŋ ta lwi da inda luwaha ta wanaftá həŋ. Ka hləganaghatá lu ta inda gwal kul ɗughwanaku. ");
INSERT INTO xed_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ka ndəɓə həŋ ta dzvu da tsi: «Zlanaŋzla ta tvi ta həŋ ka ksaŋta həŋ ta wa lguta gha kweŋkweŋ,» ka həŋ nda tsi. Inda tsa gwal ta kasaŋta ya, ka mbambaftá həŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tahula tsa, ka sliʼaftá la Farisa nda gwal tagha zlahu ŋa mnduha daga ma luwa Ursalima, ka lagha da Yesu. Ka həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Kabgawu ta kəl duhwalha gha ka kwal kul sna taghatá nzaku daga ta dzidzí, kul haɗ həŋ ta mbaziŋtá dzvu kada za skwa zay wu na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kaʼa nda həŋ mantsa: «A ki kaghuni kaghuni, kabgawu ta kwal kaghuni sna zlaha Lazglafta, ka laghwi da sna ŋa ghuni ŋa ghuni na? ");
INSERT INTO xed_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ya wya ka Lazglafta mnata na: “Vla ta glaku ŋa i da gha nda ma gha,”» kaʼa. Kaʼa mnata guli na: «“Mndu ta razanaftá dani ka mani a tsi ná, dzatá tsa mndu ya,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama ká kaghuni ta taghay ŋa mnduha na: Laviŋlava ka ta mnay ŋa da gha ka ma gha a tsi kazlay: Si ta kumay yu ta vlaghatá skwi ŋa kataghata mndani ná, tsaw dzaʼa vlaŋtá Lazglafta yu kəʼa. Nza a tkweʼ ka vlaŋta gha ta glaku ta da gha nda tsa tama wa. ");
INSERT INTO xed_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mantsa ya zaɗanata kuni ta gwaɗa Lazglafta ka mbəɗapta nda ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tsa maɗgwirmaɗgwira ghuni ya! Nda tvani tsa klatá lwa Lazglafta klak Isaya ta ghəŋa ghuni ta mnay kazlay: ");
INSERT INTO xed_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ta wi ta wi ta vla tsəna mnduha na ta glaku ŋa ɗa, ama ma ŋuɗufa taŋ ná, diʼiŋ həŋ nda iʼi. ");
INSERT INTO xed_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ka bətbət ta tsəlɓa həŋ ta tsəlɓu ŋa ɗa, gwaɗa Lazglafta ya ka həŋ ta tagha zlaha mnduha ŋa mnduha kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ka hgadaghatá Yesu ta dəmga da tsi, kaʼa nda həŋ mantsa: «Fawafa ta sləməŋ ka sna kuni. ");
INSERT INTO xed_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Skwi ta lami nda la nda ma wubisim a ta ŋriŋtá mndu wu, ama skwi ta sabi nda sa ma wa mndu ta ŋriŋtá mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na snaŋta duhwalhani ta tsa gwaɗa ya ka gavadaghatá həŋ. Ka həŋ nda tsi mantsa: «Nda sna kagha kazlay: Kuzlaŋ kuzla tsa gwaɗa gha ya ta la Farisa kəʼa re?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kaʼa mantsa: «Inda fu ya kul ŋəɓata Da ɗa ná, dzaʼa tɗiŋtɗa lu. ");
INSERT INTO xed_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zlaŋwazla ta həŋ, la ghulpata mndu ta pgha ghulpata mnduha həŋ. Ka lagha ghulpata mndu ka pgha ghulpata mndu ná, dzaʼa rkagharka həŋ his his da ghurum,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","«Tsislaŋnap tsisla ta tsa mahdihdi ya,» ka Piyer nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka Yesu mantsa: «Haɗ mahizl ma ghəŋa kaghuni guli katək ra? ");
INSERT INTO xed_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ta sna a kaghuni kazlay: Inda skwi ta lami nda la nda ma wubisim ta dzaʼa da huɗi, ŋa dzaʼa thidiŋta ma dra kəʼa ra? ");
INSERT INTO xed_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama skwi ta sabi nda sa nda ma wubisim ná, ma ŋuɗuf ta saba tsi. Tsaya skwi ta ŋriŋtá mndu. ");
INSERT INTO xed_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tazlay ná, ma ŋuɗufa mndu ta sliʼagapta ghwaɗaka ndanuha manda: Psla mndu, hliri, sliʼiŋsliʼiŋ, ghali, tsanavata gwaɗa ta mndu, vza rutsak ta mndu. ");
INSERT INTO xed_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tsahaya skwi ta ŋriŋtá mndu. Haɗ za skwa zay kul mbazaku dzvu ta ŋriŋtá mndu wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tahula tsa ka sliʼafta Yesu ma tsa vli ya ka laghwi ta haɗika Tir nda ya nda ta haɗika Siduŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka lagha sana marakw, makwa ta Kanʼana ta nzakway ta tsa haɗik ya da wahu da tsi. «Zwaŋa Dawuda, tawatá hiɗahiɗa ta iʼi Mghama ɗa. Halaway ta ksuta makwa ɗa, ta ghuya ɗaŋwa ŋani katakata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka kwalaghuta tsi ta zlghanaftawi dər teʼ. «Vriŋ na marakw ta wahu mista mu na ɓa!» ka duhwalhani gavadaghata mnay ŋani ka ŋɗaŋɗa. ");
INSERT INTO xed_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kaʼa mantsa: «Ghunaga ŋa la Israʼila nda zaɗa manda tuwak lu ta iʼi, ŋa sanlaha a wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama ka lagha tsa marakw ya tsəlɓata ma ghuvani: «Mghama ɗa, kata ta iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka Yesu mantsa: «Ra a ka klaftá skwa zay zwani ka vzanatá zwana kriha wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","«Mantsa ya nzakwani Mghama ɗa, tsaw ta ɗagay zwana kriha ta wiwisa skwa zay ta rkagata ma vəl zay daŋahəga taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gi ka Yesu nda tsi mantsa: «Dagala zlghay nda ŋuɗufa gha makwa ɗa, ka magamaga tsa skwi ya, manda ya kumaŋ ka,» kaʼa. Gi ta tsa luwa ya, ka mbaftá tsa makwani ya. ");
INSERT INTO xed_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tahula tsa, ka sliʼafta Yesu ma tsa vli ya ka laghwi nda ta wa drəfa Galili. Ka laf tsi da nzata ta sana kuɗuŋur. ");
INSERT INTO xed_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka sliʼadaghata ndəghata dəmga slanaghata. Ka hladanaghata həŋ nda gwal ta dzəgiɗi, nda gwal nda ghulpa, nda gwal nda rwa səla taŋ, nda gwal ka rgha, nda ndəghata sanlaha ma ɗaŋwaha, ka pghata ta kəmani. Ka mbambanaftá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka ndərmim tsa dəmga ya ta gwal si ka rgha ta gwaɗa, ta mbambatá gwal si ka buɗuduŋ fawaya taŋ, ta gwal nda rwa səla taŋ ta mbaɗa, ta gwal si nda ghulpa ta ngha vli. Ka həŋ mantsa: «Ŋa Lazglafta la Israʼila na glaku,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tahula tsa guli, ka hgaŋtá Yesu ta duhwalhani. Kaʼa nda həŋ mantsa: «Ta ksihata ka hiɗahiɗa na dəmga na, kabga mahkəna fitika taŋ na kawadaga nda iʼi, haɗ skwi ɗaŋ həŋ wa. Va a yu ta vriŋtá həŋ nda maya nda maya guli wu, da htuta mbrakwa taŋ ta tvi ta vru dzagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka duhwalhani nda tsi mantsa: «Ga dzaʼa mutsa mu ta skwa zay hadna ma na mtak na ŋa zuŋtá ndəghata dəmga mandana na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","«Kidaghi buradi da kaghuni na?» ka Yesu nda həŋ. «Ndəfáŋ həŋ, mamu zwana klipi kiʼa guli,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kaʼa nda tsa ndəghata dəmga ya mantsa: «Nzawanza nda nza ta haɗik,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka hlaftá tsi ta tsa buradi ndəfáŋ nda tsa klipiha ya, ka rfanaghatá tsi ta Lazglafta ta ghəŋani. Ka ɓalanaptá tsi ka vlaŋtá duhwalhani. Ka daganaftá hahəŋ guli ta tsa ndəghata dəmga ya. ");
INSERT INTO xed_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ka zə inda taŋ, ka baghawtá həŋ. Ka tskaftá lu ta pɗakwani ka ghwanak ndəfáŋ. ");
INSERT INTO xed_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dəmbuʼ fwaɗ na tsa mnduha ta za tsa skwi ya, mbəɗaf a lu ta miʼaha nda zwani wa. ");
INSERT INTO xed_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tahula vriŋtani ta tsa dəmga ya dzagha taŋ, ka lamə tsi da kwambalu ka laghwi ta haɗika Magadaŋ. ");
INSERT INTO xed_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ka sliʼadaghatá la Farisa nda la Sadukiya slanaghatá Yesu. «Maraŋnamara ta ŋizla ya ta saha daga ta luwa,» ka həŋ ɗawaŋta da tsi ŋa dzəghay. ");
INSERT INTO xed_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka Yesu nda həŋ mantsa: «Nghay ghuni ta dvata vli laghar vli ta fitik hawu ya na: “Ka mandaha dzaʼa nzakwa vli mahtsim,” ka kuni ta mnay. ");
INSERT INTO xed_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nghay ghuni ta ŋra ta vli ma mndəra luwa gasərɗək ya guli na: “Dzaʼa ghubugwa vli gita,” ka kuni ta mnay. Nda sna kuni ta dganatá skwiha ya ta magaku ta luwa, ama sna a kuni ta dganatá ŋizla skwiha ya ta magaku nda fitikani wa. ");
INSERT INTO xed_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ghwaɗak mnduha ta na fitik na, zləŋa a həŋ ta Lazglafta wa. Mazəmzəm yeya ta ɗawu həŋ. Haɗ sana mazəmzəm dzaʼa maganata lu ta həŋ ka ŋa anabi Yunusa a tsi wu,» kaʼa nda həŋ. Ka sliʼaftá tsi ka zlaŋta həŋ ka laghwani. ");
INSERT INTO xed_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ta tsughwaɗapta duhwalha Yesu ta drəf ná, zanap za həŋ ta klaftá skwa zay. ");
INSERT INTO xed_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","«Ɗasuwa ka kuni! Nghawa ghəŋa ghuni da isa la Farisa nda la Sadukiya,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","«Tsəna kwala mu kul klaftá skwa zay na ya kəl tsi ka mnay mantsa,» ka duhwalhani ta ndanay ma ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka Yesu nda həŋ snaŋər tsi ta tsa ndana taŋ ya mantsa: «Slaghwa a zlghay nda ŋuɗuf da kaghuni wa. Kabgawu ta kəl kuni ka ndanay kazlay: Haɗu skwa zay da amu wu kəʼa na? ");
INSERT INTO xed_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ta sna a kuni ra? Haɗ kuni ta havakta ka buradi zunus lu ta mnduha dəmbuʼ hutaf kay ra? Kidaghi ta tughuba tsakafta kuni ta paɗakwani na? ");
INSERT INTO xed_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Haɗ kuni ta havaktá ka buradi ndəfáŋ zunus lu ta mnduha dəmbuʼ fwaɗ kay guli ra? Kidaghi ta tughuba tsakafta kuni ta paɗakwani guli na? ");
INSERT INTO xed_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ma mnaghunata ɗa kazlay: Ɗasuwa ka kuni nda isa la Farisa nda Sadukiya kəʼa ná, waka kaghuni kwal kul snaŋta kazlay: Ta ghəŋa buradi a ta gwaɗa yu wu kəʼa na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ka tsatsaftá duhwalhani kazlay: Ta ghəŋa is ta magə lu ma buradi a mna Yesu ta magay taŋ ta ɗasuwa wu, ama ta ghəŋa tagha skwa la Farisa nda la Sadukiya dzaʼa maga həŋ ta ɗasuwa. ");
INSERT INTO xed_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɓhadaghata Yesu ta haɗika Sezare Filip, ka ɗawaŋtá tsi da duhwalhani: «Wa ya ka mnduha ta mnay ta Zwaŋa mndu na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","«Yuhwana mnda maga batem ya, ka sanlaha ta mnay. Iliya ya, ka sanlaha. Irmiya ya, ka sanlaha. Sana anabi ya, ka sanlaha,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","«A ki kaghuni! Wa ya ka kaghuni ta mnay?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","«Kagha ná, Kristi ka, Zwaŋa Lazglafta ya ta vla hafu ka,» ka Piyer nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Yesu nda tsi tama mantsa: «Simuŋ zwaŋa Zunas, nda tfawi ta ghəŋa kagha, kabga mnda səla a ta mnaghatá tsa gwaɗa ya wu, Da ɗa ta nzakway ta luwa ya. ");
INSERT INTO xed_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka iʼi ta mnaghatá kagha na: Piyer ka. Ta tsa pala ya dzaʼa bafta yu ta Igliza ɗa. Haɗ sana skwi dzaʼa laviŋtá mbrakwa mtaku ta maganavata wa. ");
INSERT INTO xed_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dzaʼa vlaghavla yu ta kramtak tgha ga mghama Lazglafta. Inda skwi dzaʼa ka da hbafta ta ghəŋa haɗik ná, nda hba ta luwa guli. Inda skwi dzaʼa ka da pliŋta ta ghəŋa haɗik guli ná, dzaʼa pliŋpla lu ta luwa guli. ");
INSERT INTO xed_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yaha kuni da walaŋta mnanaŋtá dər wati ma mndu kazlay: Kristi yu kəʼa,» ka Yesu zlahanaghatá duhwalhani ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daga ma tsa fitik ya zlrafta Yesu ta tsalinistá duhwalhani kazlay: «Dzaʼa dzaʼa yu da luwa Ursalima, dzaʼa ghuyɗipghuya la galata mndu, nda la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha ta ɗaŋwa katakata. Ŋa dzata taŋ ta iʼi. Baɗu mahkən ya, ŋa sliʼagapta ɗa ma mtaku nda hafu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Lagha Piyer ka ksaghutá Yesu nda ghəŋani ta slərpa vli, ka dvanaghata: «Ka kliŋkla Lazglafta ta tsaya Mghama ɗa. Ma walaŋ tsaya ta slaghaghata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","«Laghula gha tavata iʼi, halaway na. Tuthun ta fə ka ŋa ɗa. Manda ŋa Lazglafta a ta ndana ka ta ndanu wu, manda ŋa mnda səla ta ndana ka,» ka Yesu mbəɗavata nda Piyer. ");
INSERT INTO xed_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ka Yesu nda duhwalhani tama mantsa: «Ka ta kumay mndu ta dzaʼa mista ɗa ná, vziŋtani ta ghəŋani ka klayni ta udza zləŋayni, ka dzaʼani mista ɗa. ");
INSERT INTO xed_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mndu ta kuma nzulanatá hafani ná, dzaʼa zaɗiŋzaɗa tsa mndu ya ta hafani. Ama mndu dzaʼa zaɗiŋtá hafani ta ghəŋa gwaɗa ta iʼi ná, dzaʼa mbanafmba ta hafani guli. ");
INSERT INTO xed_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tsa lagha mndu ka mutsaftá na ghəŋa haɗik na demdem ka ŋani, ka nda zaɗa hafani ní, nu dzaʼa ghzlanata tsi na? Ari mamu a skwi dzaʼa laviŋta mndu ta varatá hafani nda tsi na? ");
INSERT INTO xed_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wya dzaʼa sasa Zwaŋa mndu kawadaga nda duhwalhani ma glakwa Dani, ŋa dganaftani ta nisəla inda mndu taɓta magatá slnani ma mndu. ");
INSERT INTO xed_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kahwathwata ka yu ta mnaghunata ná, haɗ sanlaha mataba na gwal hadna na dzaʼa rwuta kul nghaŋtá həŋ ta sagha Zwaŋa mndu ma ga mghamani wa.» ");
INSERT INTO xed_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tahula fitik mkuʼ, ka hlaftá Yesu ta i Piyer nda Yakubu nda zwaŋamani Yuhwana nda ghəŋa taŋ, ka laghu həŋ ta sana ghwá nda slra. ");
INSERT INTO xed_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ka mbəɗavaftá Yesu ta wa ira taŋ, ka wuɗaku kumani manda fitik. Ka navaftá lgutani tilil ka ŋusliŋ manda slker. ");
INSERT INTO xed_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ka gi zlagaptá i Musa nda Iliya ta wa ira taŋ ka ghwa yiva nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gi ka Piyer nda Yesu mantsa: «Mghama ɗa! Ɗina ka nzata mu hadna. Kata kumay ka, dzaʼa magafmaga yu ta dumbiha hkən hadna: Pal ŋa gha, pal ŋa Musa, pal ŋa Iliya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tata tsa gwaɗa ya Piyer, gi ka saha kusay ka ŋusliŋ tilil bukwamtá həŋ. Gi ka snaŋtá lu ta sana lwi ta gwaɗagapta ma tsa kusay ya: «Nana na Zwaŋa ɗa ya ɗvu yu katakata Tsatsi zbap yu, ta rfu yu ta ghəŋani. Snawasna ta gwaɗani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na gi snaŋta tsa duhwalha ya ta tsa lwi ya, gi ka zləmbatá həŋ zluzlumbruh ta haɗik. Ka ksutá zləŋ ta həŋ katakata. ");
INSERT INTO xed_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ka gavadaghatá Yesu tavata həŋ, ka ksaŋtá həŋ. Kaʼa mantsa: «sliʼafwa sliʼa, ma zləŋ kuni ta zləŋ!» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kəʼa ka həŋ nghagafta ná, Yesu turtukwani yeya nghaŋ həŋ hada. ");
INSERT INTO xed_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ta vragatá həŋ ta tsa ghwá ya tama, ka zlahanaghatá Yesu ta həŋ: «Yahayaha kuni mnanaŋtá dər wati ma mndu ta skwi ya nghaŋ kuni, ha ka sagha fitika sliʼagapta Zwaŋa mndu nda hafu ma mtaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka duhwalhani ɗawaŋta da tsi mantsa: «Kabgawu kəl gwal tagha zlahu ŋa mnduha ka mnay kazlay: Tiŋəl Iliya dzaʼa sagha karaku kəʼa katək na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","«Manda va tsaya nzakwani, tiŋəl Iliya dzaʼa sagha ŋa payanatá inda skwi karaku. ");
INSERT INTO xed_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama ka yu ta mnaghunata ná, ghadaghada Iliya ta sagha. Tsaw tama tsatsaf a mnduha wu, ka ghuyanaptá həŋ ta ɗaŋwa manda ya kumaŋ həŋ. Manda va tsaya dzaʼa ghuyanapta həŋ ta ɗaŋwa ta Zwaŋa mndu guli,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mantsa ya tama, ka graftá tsa duhwalha ya kazlay: Ta gwaɗə ta ghəŋa Yuhwana mnda maga batem ta tsa gwaɗa ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ndusadaghata taŋ tavata dəmga, ka gi ndadaghatá sana mndu tsəlɓata ma ghuva Yesu, ");
INSERT INTO xed_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kaʼa mantsa: «Mghama ɗa! Tawatá hiɗahiɗa ta zwaŋa ɗa ksu seteni, ta ghuya ɗaŋwa ŋani katakata. Da vu kəʼa ta dəɗamta baɗu ma sani, da imi baɗu ma sani. ");
INSERT INTO xed_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Si ka kləganaghatá yu ta duhwalha ná, ka traptá həŋ ta mbanafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ka Yesu mantsa: «Kaghuni mnduha ta na fitik na, haɗ zlghay nda ŋuɗuf da kaghuni wa. Ta maga ghwaɗaka skwi kuni. Ha ŋa yawu dzaʼa gɗavata yu tavata kaghuni na? Klagiɗighawa tsa zwaŋ ya da hadna,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ka kladanaghatá lu. Ka davanaghatá Yesu ta tsa seteni ya katakata. Ka saghu tsi ma tsa zwaŋ ya, gi ka mbaftá tsa zwaŋ ya hadahada. ");
INSERT INTO xed_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma nzata duhwalhani kawadaga nda Yesu ndaghəŋa taŋ, ka gavadaghatá həŋ da ɗawaŋta da tsi: «Kabgawu kəl aŋni ka traptá ghzligiŋtá tsa seteni ya katək na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","«Hta ta zlghay nda ŋuɗufa ghuni ta magay,» ka Yesu nda həŋ. «Kahwathwata ka yu ta mnaghunata ná, ka mamu zlghay nda ŋuɗuf kiʼa da kaghuni manda hya kramasa katsi ná, laviŋlava kuni ta mnanatá ya ghwá ya kazlay: Sliʼafsliʼa hadna ka dzaʼa ka da hada a kəʼa na, dzaʼa sliʼafsliʼa. Haɗ sana skwi dzaʼa trəgadaghunaghuta wa. ");
INSERT INTO xed_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama mndərga tsa ghwaɗaka sulkum ya ná, ba nda maga duʼa kawadaga nda suma ta ghzligiŋtá lu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma sana fitik ka tskavatá duhwalha Yesu ma Galili. Ka Yesu nda həŋ mantsa: «Dzaʼa vlavla lu ta Zwaŋa mndu ma dzva mnduha. ");
INSERT INTO xed_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ŋa dzata taŋ, baɗu mahkəna fitik ŋa sliʼagaptani nda hafu ma mtaku,» kaʼa. Ka nzata duhwalhani sasuʼanak katakata ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Manda ɓhadaghata taŋ da luwa Kafarnahum, ka gwal tska dzumna həga Lazglafta nda Piyer mantsa: «Ta plər pla a waʼa Mghama ghuni ta dzumna həga Lazglafta katək na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","«Ta play,» kaʼa. Ka sliʼaftá tsi ka lami da həga. Gi ka Yesu nda Piyer mantsa: «Simuŋ, kinawu ndana kagha ta ghəŋa tsa gwaɗa taŋ ya na? I wa raŋ pla dzumna nda dzumna luma ŋa mghamha ta na ghəŋa haɗik na na? Zwana haɗik re, ari la matbay a na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","«La matbay ya,» ka Piyer. Ka Yesu mantsa: «Nza a tkweʼ ta zwana haɗik ka play taŋ nda tsa tama wa. ");
INSERT INTO xed_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dər má mantsa tsi ná, yaha mu da nzakway ka skwa tuthun ŋa taŋ. La da drəf, ka vzadata ka ta ŋalum. Tsa taŋtaŋa klipi dzaʼa ka da ksafta ya, ka gunaŋta ka ta wani, dzaʼa slanaghasla ka ta tseda dzumna mndu his. Ka klafta ka, ka vlaŋta ka ta həŋ ŋa platá ŋa u,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma tsa fitik ya, ka gavanavatá duhwalhani ta Yesu, ka həŋ mantsa: «Wa ta nzakway ka mali ma ga mghama Lazglafta na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ka hgaktá Yesu ta sana zwaŋ kwitikw ka sladanata ta kəma taŋ. ");
INSERT INTO xed_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kaʼa mantsa: «Kahwathwata ka yu ta mnaghunata, ka mbəɗanaf a kuni ta nzakwa ghuni, ka nuta ghuni manda zwani kwitikw kwitikw wu katsi ná, haɗ kuni dzaʼa lami da ga mghama Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tsaya tama ná, mndu ta hanaganatá ghəŋani manda na zwaŋ kwitikw na ná, tsaya mndu ka mali ma ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dər wati ma mndu ta tsuʼaftá zwaŋ manda na zwaŋ wana tsi na ta ghəŋa gwaɗa ta iʼi ná, vərɗa iʼi tsuʼaf tsi.» ");
INSERT INTO xed_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ala, ka zləmbiŋzləmba mndu ta sani turtuk ma tsa zwaniha ta zlghaftá iʼi ya katsi, ta dər ya má hbiɗim lu ta dughura buna ma ŋurzluŋ ka vzaghata da drəf. ");
INSERT INTO xed_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ɗaŋwa ŋa ghəŋa haɗik ta nzakway ta zlazlambiŋtá mndu! Aŋ mndani, nda nza tkweʼ ka nzakwa skwiha ta zlambiŋtá mndu. Ama ɗaŋwa ŋa mndu ya ta sagha tsa zləmbaku ya nda da tsatsi. ");
INSERT INTO xed_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Ka nda nza dzva gha, ka səla gha a tsi ka skwi ta famtá kagha da ga dmaku katsi ná, tsiŋtsa gha ka wuɗiŋta ka diʼiŋ. Ta dər lama ka da hafu ŋa kɗekedzeŋ nda səla gha sluŋ turtuk, ka dzva gha sluŋ turtuk a tsi, ka ya da klafta lu ta kagha nda səlaha gha yipaʼ ka dzvuha gha yəmaɗ a tsi, ka vzamtá kagha da həga vu ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka ira gha ta famtá kagha da ga dmaku katsi ná, tsakwasliŋ tsakwasla gha ka wuɗidiŋta ka diʼiŋ. Ta dər lama ka da həga hafu ŋa kɗekedzeŋ nda ira gha guzliŋ turtuk, ka ya da klafta lu ta kagha nda iriha gha his his ka vzaghamta da həga vu.» ");
INSERT INTO xed_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ɗasuwa ka kuni da hərtətatá kuni ta ya dər turtuk mataba tsəna zwaniha na. Ka yu ta mnaghunata ná, duhwalha Lazglafta ta gɗata ta ngha kuma Da ɗa ta nzakway ta luwa ta ngha həŋ.  ");
INSERT INTO xed_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sa da mbanaftá gwal ya si nda zaɗa na Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Kinawu ka kaghuni ta ndanay na? Ka dərmək ka tuwaka mndu, tsa zaɗavaghuta ya turtuk katsi ná, haɗ ta zlaŋtá tsaha təmbay mbsak təmbay mida ya ta ghwá, ka laghu da psa tsa turtuk ta zwaɗuta ya ra? ");
INSERT INTO xed_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ka yu ta mnaghunata ná, ka slafsla tsi tida ná, dzaʼa rfay ta rfu katakata ta ghəŋani ka malaghuta ta ghəŋa tsaha təmbay mbsak təmbay mida kul zwaɗuta ya. ");
INSERT INTO xed_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Manda va tsaya guli ná, va a Da ghuni ta nzakway ta luwa ta zaɗavaghuta ya dər turtuk ma tsa zwaniha ya wa.» ");
INSERT INTO xed_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ka gaghaga zwaŋama gha ta dmaku ná, la slanaghata ka dzraŋta kaghuni histaghuni. Ka snaghasna tsi katsi, katafkata ka ta zwaŋama gha. ");
INSERT INTO xed_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ala, ka kwalaghukwala tsi ta snaghata katsi, klafkla ta mndu turtuk ka his a tsi kawadaga nda kagha, ka vradaghata ka da slanaghata, “ŋa da graftá tsa gwaɗa ya ma wa mnduha his ka hkən a tsi.” ");
INSERT INTO xed_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka kwalaghukwala tsi ta snanatá tsaha ya guli katsi, mnanamna ta Igliz. Ka kwalaghukwala tsi ta snatá ŋa Igliz katsi guli, ngha ta tsa mndu ya manda mndu kul snaŋtá Lazglafta, ka mnda tska dzumna a tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Kahwathwata ka yu ta mnaghunata, inda skwi ya dzaʼa kwalaghuta kuni ta haɗik ná, dzaʼa kwalaghukwala lu guli ta luwa. Inda skwi ya dzaʼa hbanata kuni ta haɗik ná, dzaʼa hbafhba lu guli ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Ka yu ta mnaghunata guli na: Ka dzrafdzra mnduha his mataba ghuni ta wi, ŋa ɗawa dər wati ma skwi tsi katsi, dzaʼa tsuʼanaf tsuʼa Da ɗa ta luwa ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ma vli ya guyava mnduha his ka hkən a tsi ma hga ɗa ná, mataba taŋ yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ka sliʼaftá Piyer ka gavadaghata ɗawaŋta da Yesu, kaʼa mantsa: «Mghama ɗa! Ka ta giha ga zwaŋama ɗa ta dmaku ní, kidaghi səla dzaʼa planata yu ta dmakwani na? Ndəfáŋ səla rki dzaʼa planata yu na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka Yesu nda tsi mantsa: «Ndəfáŋ səla yeya a ta mnaghata yu wu, ndəfáŋ mbsak, ndəfáŋ mbsak, ndəfáŋ səla. ");
INSERT INTO xed_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tsaya dzaʼa kəl lu ka gra ga mghama Lazglafta nda sana mgham ta kuma mbəɗaftá skwa gadghəlani ma dzva gwal ta ksanatá slna ya. ");
INSERT INTO xed_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ma nzatani ka mbəɗay, ka klanaktá lu ta sani ya nda dməŋa mleŋwi mleŋwiha tsedi da tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Haɗ skwa tsa mndu ya ŋa plata wa. Ka tsa mgham ya mantsa: Skwapwaskwa ta tsa mndu ya, nda markwa taŋ tani, nda zwanani tani, nda inda skwi ta nzakway ka ŋani tani, ŋa pla tsa dməŋ ya, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ka zləmbatá tsa kwalva ya ta haɗik ka tsəlɓata ta kəmani, kaʼa mantsa: “Wya dzvu, ksa ta ŋuɗuf, dzaʼa plagha pla yu demdem,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ksaŋta tsa kwalvani ya ka hiɗahiɗa katakata ta tsa daŋahəgani ya, ka zlanaŋtá tsi ta tsa dməŋ ya ka zliŋta. ");
INSERT INTO xed_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Saba tsa kwalva ya manda zliŋtá, ka guyatá tsi nda sana grani ya si ta ksə həŋ ta slna kawadaga, nda dməŋani da tsi ka suley dərmək. Ka valaftá tsi tida, ka ksanaftá ŋurzluŋ. “Plihapla ta skwa ɗa gita gita!” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ka zləmbatá tsa grani ya ta haɗik, ka ndəɓa dzvu da tsi. Kaʼa mantsa: “Wya dzvu, ksa ta ŋuɗuf dzaʼa plagha pla yu,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Yaʼ! Ɗva a yu wu, plihata gitagita,” kaʼa. Ka laghu tsi hamtá tsa grani ya ma gamak ka kzla planatani ta tsa dməŋani ya. ");
INSERT INTO xed_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nghay sanlaha ma tsa kwalvaha ya ta tsa skwi maga tsi ya ná, ka kuzlanaftá tsi ta həŋ ta ŋuɗuf katakata. Ka laghu həŋ rusanaftá daŋahəga taŋ ta inda skwi ta maguta. ");
INSERT INTO xed_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ka hgadaghata tsa daŋahəgani ya, kaʼa nda tsi mantsa: “Ghwaɗaka kwalva ka, zlaghaŋzla yu ta inda dməŋa ɗa ta kagha kabga ndəɓata gha ta dzvu da iʼi ná, ");
INSERT INTO xed_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","haɗ kagha guli má dzaʼa tawa hiɗahiɗa ta gra gha, manda ya tawa yu ta hiɗahiɗa ta kagha ya ra?” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huf safi ta ŋuɗufa daŋahəgani, ka laghu tsi hamta ma gamak, ka kzla planatani ta inda dməŋani da tsi. ");
INSERT INTO xed_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Dər wa tsi ma kaghuni kul haɗ ta planatá dmakwa zwaŋamani ma hyahya ŋuɗufani wu katsi ná, manda va tsaya dzaʼa maga Da ɗa ya ta luwa nda kaghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Manda kɗiŋta Yesu ta tsa gwaɗa ya, ka sliʼaftá tsi ta haɗika Galili ka laghwi ta haɗika Zudiya ta ɓla ghwa Zurdeŋ. ");
INSERT INTO xed_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ka sliʼafta dəmga rutut mistani. Ka mbambə tsi ta mnduha. ");
INSERT INTO xed_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ka gavadaghatá la Farisa da tsi, kabga ta kumay həŋ ta tsanamtá matsavaɗa. Ka həŋ nda tsi mantsa: «Laviŋlava mndu ta ghzliŋtá markwa taŋ, ka magamaga tsi ta dər wati ma skwi tsi ra?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Yesu nda həŋ mantsa: «Ta dzaŋa a kuni ta skwi ya nda vinda ma defteri nda ghuɓa ra? “Ma zlrafta inda skwi ná, zlagigiŋ zlaga Lazglafta ta i zgun nda marakw.” ");
INSERT INTO xed_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ka Lazglafta mantsa: “Tsaya dzaʼa kəl zgun ka zlaŋtá i dani nda mani, ka laghwi da ndiʼaftá vgha nda markwa taŋ, ŋa nzakway tsa hahəŋ his ya ka mndu turtuk.” Mantsa ya tama, ");
INSERT INTO xed_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","nzəgla a həŋ ka mnduha his wa, ama ka mndu turtuk nzakwa taŋ. Yaha mndu tama da dganatá skwi ya ndiʼanaf Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka la Farisa nda tsi mantsa: «Kabgawu tama kəl Musa ka mnay kazlay: Ka ta ghzlay mndu ta markwa taŋ katsi ná, vindanaftani ta ɗelewera ghzliŋtani kəʼa ɓa?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Yesu nda həŋ mantsa: «Təŋa ta ghəŋa ghuni kəl Musa ka vlaghunatá tva ghzliŋtá marakw. Ma zlraftani ná, mantsa ya a nzakwani wa. ");
INSERT INTO xed_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ama ka iʼi ta mnaghunata ná, yaha mndu walaŋtá ghzliŋtá markwa taŋ, ka taghəŋa hliri a tsi. Nzakwani ná, ka ghzliŋghzla mndu ta markwa taŋ, ka klaftani ta sani katsi ná, ta hliri tsa mndu ya nda tsa.» ");
INSERT INTO xed_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka duhwalhani nda Yesu mantsa: «Ka si mantsa ya ta magakwa skwi mataba i marakw nda zəʼal katsi ná, dər kwal kul klay,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ka Yesu nda həŋ mantsa: «Inda mndu a dzaʼa laviŋtá ŋaftá tsa gwaɗa ya wa, ba gwal ya vlaŋ Lazglafta ta mbrakwa ŋafta kasiʼi, ");
INSERT INTO xed_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","kabga mamu gwal ya yaga lu ka kuɓitik, mamu gwal ya pslaf mnduha nda psla, mamu gwal ta kwalaghutá klay, kabga gwaɗa ta ga mghama Lazglafta guli. Mndu ya dzaʼa laviŋtá ŋaftá tsa gwaɗa ya, ka ŋa tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tahula tsa, ka hladaghatá mnduha ta zwani kwitikw kwitikw da Yesu, ŋa fanaghatani ta dzvu ta həŋ ka maga duʼa ta ghəŋa taŋ. Ama ka pyə duhwalha Yesu ta mnduha. ");
INSERT INTO xed_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka Yesu nda tsa duhwalha ya mantsa: «Zlaŋwazla ta zwani ka sagha həŋ da iʼi, ma pyə kuni ta həŋ, kabga ŋa gwal ta gara vgha nda hahəŋ na ga mghama Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ka fafanaghatá Yesu ta dzvu ta ghəŋa tsa zwaniha ya. Tahula tsa, ka sliʼaftá tsi ma tsa vli ya, ka laghwi. ");
INSERT INTO xed_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Va gi ka lagha sana mndu da Yesu, kaʼa mantsa: «Maləma ɗa, nahgani skwi dzaʼa yu magata ɗina, ŋa nzakwa ɗa nda hafu ŋa kɗekedzeŋ kawadaga nda Lazglafta na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka Yesu nda tsi mantsa: «Kabgawu kəl ka ka ɗawihata ta ghəŋa ŋərma skwi na? Turtuktuk ŋərma ta nzakway ka Lazglafta. Ka ta kumay ka ta nzakwa gha nda hafu ŋa kɗekedzeŋ kawadaga nda Lazglafta katsi ná, snata gha ta zlahuhani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","«Wati zlahuha ya na?» Ka tsa mndu ya. Ka Yesu mantsa: «Yaha ka da dzatá mndu, yaha ka da hliri, yaha ka da ghali, yaha ka da tsanavatá gwaɗa ta mndu, ");
INSERT INTO xed_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","vla ta glaku ŋa i da gha nda ma gha, ɗvuɗva ta mnda səla manda va ghəŋa gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka tsa duhwal ya nda tsi mantsa: «Snasna yu ta inda tsaha ya demdem, nu ta pɗakwani ŋa magəgəlta ɗa na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka Yesu nda tsi mantsa: «Ka ta kumay ka ta nzakwa gha hem katsi ná, la ka dzawiŋta ka ta inda skwa gha, ka daganafta ka ta tsedani ta gwal ka pɗu. Dzaʼa mutsay ka ta gadghəl ta luwa, tahula tsa ka sagha ka, ka dzaʼa ka mista ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na snaŋta tsa duhwal ya ta tsa gwaɗa ya, ka ɓasaftá tsi ta ŋuɗuf ka sliʼafta ka laghwi, kabga gadghəl ya. ");
INSERT INTO xed_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ka Yesu nda duhwalhani mantsa: «Kahwathwata ka yu ta mnaghunata, nda bla katakata ka lama mndu ta fafta ghəŋani ta gadghəl da ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka yu ta vrəgliŋtá mnaghunata na: Ta dər laba ŋalibwa nda ta ghuruma lipir, ka lama mndu ta faftá ghəŋani ta gadghəl da ga mghama Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na snaŋta duhwalhani ta tsa gwaɗa ya, ka ndərauʼ həŋ katakata, ka həŋ mantsa: «Ka si mantsa tsi, wa dzaʼa laviŋta mutsaftá mbaku tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ka nghanavatá Yesu ta həŋ, kaʼa mantsa: «Skwi nda bla da mnduha ya ná, bla a da Lazglafta wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gi tsauʼ ka piyer tsuʼaghutá gwaɗa, kaʼa nda Yesu mantsa: «Aʼa! Ya wana aŋni, zlanavazla aŋni ta inda skwi, ka dzaʼa mista gha ya ní, kinawu kəʼa dzaʼa magaku nda aŋni tama?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, ma mbəɗavafta inda skwi dzaʼazlay ná, dzaʼa nzafta ta dughurukwa glakwani na Zwaŋa mndu. Kaghuni gwal ta dzaʼa mista ɗa ya guli, dzaʼa nzanzafta ta dughurukha ghwaŋpɗə his kaghuni, ŋa tsa guma ta ghəŋa mndəra la Israʼila ghwaŋpɗə his guli. ");
INSERT INTO xed_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Dər wati ma mndu ta zlanavatá həgani, ka zwanamani a tsi, ka kwaghamani a tsi, ka dani a tsi, ka mani a tsi, ka zwanani a tsi, ka vwahani a tsi, ta ghəŋa gwaɗa ta iʼi ná, dzaʼa mutsay həŋ ta dərməkatani, ka malaghuta a tsi, ŋa mutsay taŋ ta hafu ŋa kɗekedzeŋ guli ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama nda ndəgha gwal ta nzakway taŋtaŋ, dzaʼa nzakway nda hul. Nda ndəgha gwal ta nzakway nda hul guli, dzaʼa nzakway taŋtaŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Wya skwi ŋa gray nda ga mghama Lazglafta. Ka tsavagaptá sana zəʼala həga ma həgani, wrək sərɗək, da zba gwal ŋa ksanatá slna ma vwaha inabani. ");
INSERT INTO xed_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ka dzraftá tsi nda tsa gwal ksa slna ya ta planatá həŋ ka tseda vagha mndu turtuk, ta vagha taŋ. Ka ghunaghatá tsi ta həŋ da vwaha inabi. ");
INSERT INTO xed_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ka sliʼiglaftá tsi wər ta nzemndi təmbay gavzlazlaŋ, ka nghəglaŋtá tsi ta gwal ksa slna ta nzaku bətbət. ");
INSERT INTO xed_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kaʼa nda həŋ mantsa: “Lawa kaghuni guli da ksa slna ma vwaha inaba ɗa, dzaʼa plaghuna pla yu ta tseda ghuni manda ya ta raku,” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka sliʼaftá tsa gwal ksa slna ya ka laghwi da tsa vwaha inabi ya. Ka sliʼiglaftá tsi guli wər fitik ma ghəŋ vli, mantsa guli ta fitik hawu, ka magata manda va tsaya guli. ");
INSERT INTO xed_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka sliʼiglaftá tsi guli beeghwa fitik, ka slanaghatá tsi guli ta sanlaha ma gwal ksa slna ta nzaku. Kaʼa nda həŋ mantsa: “Nya kəl kuni ka vaghay ta nzaku kul laghwi maga slna na?” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka həŋ nda tsi mantsa: “Haɗ mndu ta klaftá aŋni ŋa maga slna wa,” ka həŋ. Kaʼa nda həŋ mantsa: “Lawa kaghuni guli da maga slna ma vwaha ɗa,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Gahawu tama, “hagakhaga ta tsa gwal ta ksa slna ya, ka planata ka ta nisəla taŋ ka zlrafta ka nda tsa gwal ka kwanahani ya, ŋa kɗiŋta gha nda gwal taŋtaŋ,” ka tsa dani ma vwaha inabi ya nda kwalvani. ");
INSERT INTO xed_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ka lagha tsa gwal ta zlraftá ksa slna beeghwa fitik ya. Ka vlaŋtá lu ta tseda vagha mndu turtuk turtuk ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka lagha gwal ta zlraftá ksa slna taŋtaŋ. “Mali dzaʼa aŋni zlghay” ka hahəŋ si ta gray. Ama ka vlaŋtá lu ta tseda vagha mndu turtuk turtuk ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta zlghə həŋ ya, ta dzaʼa nda ŋuŋuraku həŋ ta ghəŋa tsa daŋahəga ya. ");
INSERT INTO xed_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ka həŋ mantsa: “Beeghwa fitik ta sagha nanaha na, awa turtuktuk kweŋkweŋ maga həŋ ta ksa slna ná, waka kagha planatá həŋ guram nda ŋa aŋni na? Aŋni, hərfu hərfa ŋni ta ksa slna tles fitik, ka vaghay ta maga slna ta fitik,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kaʼa nda həŋ mantsa: “Gra ɗa, nənɓap a yu ta kagha wa. Ta tseda vagha mndu turtuk a dzrafta u nda kagha kay ra? ");
INSERT INTO xed_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Zlgha ta nisəla gha, ka sliʼa ka. Manda va ya kumaŋ yu vlaŋta yu ta tsa mndu ta sagha nda hul ya, manda va ŋa gha. ");
INSERT INTO xed_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Laviŋlava yu ta maga skwi manda ya kumaŋ yu nda tseda ɗa, mantsa a kasiʼi wa? Ari zɗəgagha a wa a na skwi ɗina maga yu na ta wa ira gha na?” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tsaya tama ná, dzaʼa nzakway gwal nda hul, ka gwal taŋtaŋ. Ŋa nzakwa gwal taŋtaŋ, ka gwal nda hul,» ka Yesu sganaghata. ");
INSERT INTO xed_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka sliʼaftá Yesu ka ŋlu ka dzaʼa da luwa Ursalima. Ta mbaɗa həŋ ta tvi, ka ksaghutá tsi ta tsa gwal ghwaŋpɗə his ya, kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ndanana, wana mu ta ŋlu ka dzaʼa da luwa Ursalima. Dzaʼa ksafksa lu ta Zwaŋa mndu, ka vlaŋtá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, ŋa tsanaghata taŋ ta guma dzata. ");
INSERT INTO xed_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dzaʼa vlaŋvla həŋ ta gwal kul haɗ ka la Yahuda, ŋa gagay tsaha ya, ŋa sləvay taŋ nda krupi, ŋa zləŋafta taŋ ta udza zləŋay. Baɗu mahkəna fitik, ŋa sliʼagaptani nda hafu ma mtaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tahula tsa, ka lagha mani ma zwana Zebedi nda zwanani. Ka tsəlɓata tsi ta kəmani ŋa ɗawa skwi da tsi. ");
INSERT INTO xed_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","«Nu ta kumə ka na?» ka Yesu nda tsi. «Wana na zwana ɗa his na, sagha fitika ga mghama gha ya ná, ka mnata ka, ŋa nzata na zwana ɗa na, nda ga zeghwa gha ya, nda ga zlaɓa gha ya, ka yu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","«Sna a kuni ta skwi ta ɗawu kuni wa. Dzaʼa laviŋlava kuni ta sa leghwa tsa ghuya ɗaŋwa dzaʼa yu ghuyay ya ra?» ka Yesu. «Dzaʼa say ŋni!» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka Yesu nda həŋ mantsa: «Mantsa nzakwani, dzaʼa say kuni ta tsa leghwa ghuya ɗaŋwa ɗa ya, ama ta ghəŋa gwaɗa ta nzaku nda ga zeghwi nda ya nda ga zlaɓa ná, iʼi a dzaʼa mna tsaya wa. Da ɗa dzaʼa vlaŋtá tsa vli ya ta gwal ya payanaf tsi ta həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Snaŋta tsa pɗakwa duhwalha ghwaŋ ya ta tsa gwaɗa ya, ka ɓasanavatá həŋ ta ŋuɗuf ta tsa zwanamaha his ya. ");
INSERT INTO xed_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ka hagadaghatá Yesu ta həŋ, kaʼa nda həŋ mantsa: «Nda sna kuni ná, ta gay mghamha ta ghəŋa mnduha ta má mgham mghama taŋ ta ghəŋa taŋ. Gwal dagaladagala guli, ta maray hahəŋ ta mbrakwa taŋ ta ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama mantsa ya a nzakwani mataba kaghuni wa. Katək ná, ka ta kumay sani ta nzakway ka mali mataba ghuni ná, nzatani ka kwalva ghuni. ");
INSERT INTO xed_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ala, ka dər wa ta kuma nzakway ka mnda kla kəma mataba ghuni ya, nzatani ka vuʼa ghuni. ");
INSERT INTO xed_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Manda va tsaya ná, sa a Zwaŋa mndu ŋa maganata lu ta slna wa. Ama sasa ŋa maganatá slna ta mnduha, ŋa vlatani ta hafani ŋa mbanaftá ndəghata mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ta sabə i Yesu nda duhwalhani ma luwa Yeriku, ka sliʼaftá dəmga rutut mistani. ");
INSERT INTO xed_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta nzaku ghulpata mnduha his ta wa tvi. Ka snaŋtá həŋ ta labla Yesu nda ta tsa kəʼa, ka dzatá həŋ ta lawlaw. «Mgham, Zwaŋa Dawuda! Tawa ta hiɗahiɗa ta aŋni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","«Hafwa wa ghuni!» Ka tsa dəmga ya, ka dava həŋ. Ama ka sganaghatá tsa ghulpata mnduha ya ta dza lawlaw. «Mgham, Zwaŋa Dawuda! Tawa ta hiɗahiɗa ta aŋni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ka sladavatá Yesu, ka hgadaghatá tsi ta həŋ. «Nahgani ta kumə kuni ta magaghunata ɗa na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","«Mghama ɗa, gwanaŋnagwana ta iriha ŋni!» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ka ksaŋtá həŋ ta Yesu ka hiɗahiɗa. Ka kasaŋtá tsi ta iriha taŋ. Ka gi nghaŋtá həŋ ta vli nziɗiɗ. Ka laghu həŋ mista Yesu. ");
INSERT INTO xed_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ta ghwaŋ a i Yesu nda duhwalhani ka ɓhadaghata da luwa Ursalima wu, ndusa həŋ nda luwa Beslaze tavata ghwá Zaytuŋ, ka ghunaftá Yesu ta gwal his mataba duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kaʼa nda həŋ mantsa: «Lawala da a luwa ta kəma ghuni a. Ka ɓhadaghaɓha kuni, dzaʼa gi slanaghasla kuni hada ta hbatá mana kɗih nda zwaŋani. Ka pligiɗaghata kuni ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka mamu mndu ta gwaɗgaghunata ta ghəŋani katsi ná, “Mgham ta kumay,” ka kuni da zlghanaftá wani. Dzaʼa gi zlaghunaŋzla həŋ.» ");
INSERT INTO xed_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kəl tsaya ka nzakway mantsa ná, nda nza kabga ŋa dzanaghatá ghəŋa gwaɗa ya mna anabi Zakari kazlay: ");
INSERT INTO xed_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Mnanawamna ta gwal ma luwa Siyuna, waʼa mghama gha ta sagha da kagha, leɓtekw nzakwani katakata, ta sagha ta kɗih, ta vuvuʼukwa kɗih, ta nzakway ka zwaŋa kɗih,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka sliʼaftá tsa duhwalha ya ka laghwi magata manda ya mnanaf Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ka hlaktá həŋ ta tsa mana kɗih ya nda zwaŋani, ka pghaftá həŋ ta lgutha taŋ ta həŋ, ka lafi Yesu nzafta tida. ");
INSERT INTO xed_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ka zlazlatə ndəghata mnduha ta lgutha taŋ ta tvi. Sluhwa ŋa sanlaha ta patsay ka pghay ta tvi guli. ");
INSERT INTO xed_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ka hlə gwal ta kəma Yesu nda gwal nda hulani tani ta wi, ka həŋ mantsa: «Ŋa Zwaŋa Dawuda glaku, ka tfanaghatfa Lazglafta ta wi ta mndu ta sagha ma hga Mgham Lazglafta! Ŋa Lazglafta ta luwa glaku!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Manda ɓhadamta Yesu da luwa Ursalima, ka kɓutá mnduha. «Wa na mndu na tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka tsa dəmga mistani ya mantsa: «Anabi Yesu ta sabi ma luwa Nazaret ta haɗika Galili ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ka lami Yesu da həga Lazglafta. Ka ghzligiŋtá tsi ta inda gwal ta tsakala nda gwal ta skway tani ma tsa həga Lazglafta ya. Ka zlambidiŋtá tsi ta tabəla gwal mbəɗu, nda vla nzakwa gwal ta dzawaptá ghərbuʼ. ");
INSERT INTO xed_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kaʼa nda həŋ mantsa: «Nda vinda ma deftera Lazglafta kazlay: Həga ɗa ná, həga maga duʼa ya kəʼa, ka niŋtá kaghuni ka galigha la gənda.» ");
INSERT INTO xed_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka gavadaghatá gwal nda ghulpa nda gwal nda raghwa səla taŋ tavatani ma tsa həga Lazglafta ya. Ka mbambanaftá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nghay la mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha ta tsa mandərmima skwi ta magə Yesu, nda tsa hlawa zwani ma həga Lazglafta kazlay: «Ŋa Zwaŋa Dawuda glaku!» kəʼa ya ná, ka kuzlanaftá tsi ta həŋ ta ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ka həŋ nda Yesu mantsa: «Nda sna ka ta na skwi ta mnə həŋ na ra?» ka həŋ. «Aŋi! Nda sna yu,» ka Yesu nda həŋ. «Ta walaŋ a kuni ta dzaŋaftá tsa gwaɗaha ya ma deftera Lazglafta ra? Kaʼa na: “Kagha ta payaftá zləzlva kagha nda ma wa zwani nda ya nda ma wa zwana vziʼuwa, manda ya kumaŋ ka,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ka sliʼaftá Yesu ka zlaŋtá həŋ ka saghwi ma tsa luwa ya, ka laghwi da luwa Betani ka hani tsi hada. ");
INSERT INTO xed_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gasərɗək ta vru Yesu ka dzaʼa da tsa luwa dagala ya, ka kuzlanaftá maya. ");
INSERT INTO xed_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka nghaŋtá tsi ta fwa sana ghuraf ta wa tvi. Ka lagha tsi distani. Kəʼa kəʼa ná, sluhwa yeya dzeʼdzeʼ tida. «Haɗ ka dzaʼa walglaŋta yəglafta wu,» kaʼa nda tsi. Gi hadahada dzuŋ ghwalatá tsa fu ya tsa. ");
INSERT INTO xed_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kəʼa ká tsa duhwalhani ya nghanata ghwalatá tsa fu ya ná, ka ndərmimi həŋ nda ndərmima. Ka həŋ mantsa: «Waka na ghuraf na gi ghwaluta hadahada kay ka na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, ka zlghafzlgha kuni ta Lazglafta nda ŋuɗuf dgaŋ a kuni ta ghəŋ ɗekɗek wu ka tsi ná, skwi magana lu ta na ghuraf na yeya a dzaʼa kuni magay wa: “Ama, sliʼafsliʼa hada ka vzamta ka ta vgha da drəf,” ka kuni dzaʼazlay nda ya ghwá ya ná, dzaʼa magaku manda va tsaya. ");
INSERT INTO xed_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Inda skwi dzaʼa ɗawaŋta kuni nda zlghay nda ŋuɗuf nda ma maga duʼa ná, dzaʼa mutsay kuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ka lamə Yesu da həga Lazglafta ka taghə tsi ta skwi ŋa mnduha. Ka gavadaghata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu da ɗawaŋta da tsi. «Mutsu ga kagha ta na mbraku ta kəl kagha ka maga na skwiha na na? Wa ta vlaghata na mbraku na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka Yesu nda həŋ mantsa: «Mamu skwi turtuktuk dzaʼa ɗawaŋta yu da kaghuni guli. Ka zlghiɗifzlgha kuni ta wani katsi, dzaʼa mnaghunamna yu ta vli ta mutsu yu ta na mbraku ta kəl yu ka maga na skwiha na. ");
INSERT INTO xed_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wa ta ghunafta Yuhwana ŋa maga batem na? Lazglafta re, ari mnduha a na?» kaʼa nda həŋ. Ka laghu heŋ da dzray mataba hahəŋ hahəŋ. Ka həŋ mantsa: «“Ka Lazglafta ta ghunafta Yuhwana ka mu,” nu kwal kuni kul zlghafta ɓa? kaʼa dzaʼazlay nda amu. ");
INSERT INTO xed_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ala, ka “mnduha ta ghunafta” ka mu guli, ta zləŋay mu ta mnduha guli, kabga klafkla həŋ demdem kazlay: Anabi Yuhwana kəʼa.» ");
INSERT INTO xed_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ka həŋ nda Yesu tama mantsa: «Sna a aŋni ka wa ta ghunafta wu,» ka həŋ. Ka Yesu nda həŋ guli mantsa: «Iʼi guli ná, haɗ yu ta mnaghunata ka wa ta vlihata na mbraku ta kəl yu ka maga na skwiha na wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ka Yesu nda həŋ guli mantsa: «Kinawu ka kaghuni ta ndanay na? Mamu sana mndu his zwanani. Kaʼa nda sani taŋtaŋ mantsa: “La ka dzaʼa ka da maga slna ma vwaha inaba u sagəŋ,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“La a yu wu,” kaʼa. Tahula tsa, ka ndanglaptá tsi ka sliʼafta ka laghwi da vwah. ");
INSERT INTO xed_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ka mnanatá dani ta tsa sana zwaŋ ya manda va tsaya guli. “Aray, ta dzaʼa yu da,” kaʼa. Tahula tsa, ka kwalaghuta tsi. ");
INSERT INTO xed_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wati mataba tsa zwaniha his ya, ta magata skwi ya kumə da taŋ ná?» ka Yesu nda həŋ. «Tsa taŋtaŋ ya ya,» ka həŋ. Ka Yesu nda heŋ tama mantsa: «Kahwathwata ka yu ta mnaghunata ná, dzaʼa tiŋlaghutiŋla gwal tska dzumna nda miʼa hliri ta lami da ga mghama Lazglafta ka kaghuni. ");
INSERT INTO xed_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wya saghasa Yuhwana mnda maga batem da kaghuni, ka maraghunatá tsi ta tvi tɗukwa, ka kwalaghutá kuni ta zlghafta. Ama ka zlghaftá gwal ta tska dzumna nda miʼa hliri. Kulam nda va tsa nghaŋta ghuni ya tani, mbəɗanaf a kuni ta nzakwa ghuni ka zlghafta wa,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ka mnaghunamna yu ta sana mahdihdi ɓa: Mamu sana mndu ta ŋaɓaftá fwa inabiha ma vwahani. Ka ŋamtá tsi ma muhul. Ka laptá tsi ta ghurum ŋa ɗitsa yakwani. Ka baghatá tsi ta vli ŋa nzagata ka nghay. Tahula tsa, ka fanamtá tsi ma dzvu ka haya ta gwal hva. Ka sliʼafta tsi ka laghwi dista luwa. ");
INSERT INTO xed_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Magatá fitika ɗaga yakwani, ka ghunafta tsi ta kwalvahani da tsa gwal hva ma tsa vwah ya, ŋa mutsanafta taŋ ta ŋani ma ɗagata yakwa tsa inabi ya. ");
INSERT INTO xed_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ama, ka valaftá tsa gwal hva tsa vwaha inabi ya ta tsa kwalvaha ya. Ka ɗgaptá həŋ nda ɗga ta sani ka dzata həŋ nda dza ta sani. Ka zlərtsatá həŋ nda zlərtsa ta sani. ");
INSERT INTO xed_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka ghunglaftá tsi ta sanlaha ma kwalvahani ka malaghuta mbsaka tsaha taŋtaŋ ya. Ka maganatá tsa gwal hva tsa vwah ya ta hahəŋ guli manava ŋa tsahaya. ");
INSERT INTO xed_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kɗavaktani, ka ghunədanaptá tsi ta həŋ ta vərɗa ŋani ma zwaŋ nda mnay kazlay: Dzaʼa vlaŋvla həŋ ta glaku ta zwaŋa ɗa kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na nghay tsa gwal hva fwa inabi ya ta lagha tsa zwaŋ ya, ka həŋ mataba taŋ mantsa: “Wana tsa mndu dzaʼa za həga ya kay. Sawa, ka dzata mu! Ŋa zay mu ta həgani,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ka valaftá həŋ tida. Ka tshidiŋta diʼiŋ nda tsa vwah ya, ka dzata. ");
INSERT INTO xed_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Baɗu da saghər tsa dani ma inabi ya ní, kinawu kəʼa dzaʼa magay nda tsa gwal hva tsa vwaha inabi ya na?» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","«Dzaʼa pslapsla ta tsa ghwaɗakha ya, ksaŋta a həŋ ka hiɗahiɗa wa. Ŋa klaftani ta tsa vwaha inabani ya ka fanamta ma dzvu ka haya ta sanlaha ma gwal hva. Ŋa vlay tsahaya ŋani nda fitikani ta ŋani mataba ɗagata yakwa tsa fwa inabi ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ka Yesu nda həŋ guli mantsa: «Ta walaŋ a kuni ta dzaŋafta skwi vindaf lu ma defteri ra? “Tsa pala wuɗidiŋ gwal ba həga ya, tsaya ta nuta ka vərɗa palaka tughwa həga. Tsaya ná, Lazglafta ta ɗvaftá nzakwani mantsa. Nda nza ka mazəmzəm ta wa ira amu.” ");
INSERT INTO xed_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Tsaya kəl yu ka mnay ŋa ghuni kazlay: Dzaʼa klaghukla lu ta ga mghama Lazglafta da kaghuni ŋa vlaŋtá mndəra mnduha dzaʼa snanatá gwaɗani ɗina kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tsa mndu dzaʼa zləmbafta ta tsa pala ya, dzaʼa hurɓə hurɓa. Ala, ka tsa pala ya ta zləmbanaghatá mndu katsi, dzaʼa huʼanap huʼa ŋərɗək ta tsa mndu ya.» ");
INSERT INTO xed_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na snanata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la Farisa ta tsa mahdihda Yesu ya, ka graftá həŋ kazlay: Ta ghəŋa taŋ ta gwaɗa tsi ta tsa gwaɗa ya, kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ka zbə həŋ ta ksaftá Yesu. Ama ka zləŋaftá həŋ ta dəmga, kabga klafkla dəmga ta Yesu ka anabi. ");
INSERT INTO xed_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ka Yesu mnəglanatá həŋ nda mahdihdi mantsa: ");
INSERT INTO xed_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ka guram ga mghama Lazglafta nda sana mgham ta payaftá skwa zay ma klay zwaŋani ta makwa. ");
INSERT INTO xed_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka ghwanaftá tsi ta kwalvahani ŋa hagaktá gwal hagaŋ tsi ŋa za tsa skwa zay ya, ama ka kwalaghuta tsahaya ta sagha. ");
INSERT INTO xed_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka ghunglafta tsi ta sanlaha ma kwalvaha ŋa dzaʼa “mnanatá tsa gwal hagaŋ tsi ya nda mnay kazlay: Ndanana ná, ndusa skway zay kəʼa. Pslapsla yu ta slaha ɗa, nda rina fisika ɗa nda uwasla nda uwasla, nda paya inda skwi, saghawasa da za skwa zay ma vla kla makwa,” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ndanaŋ a tsa gwal hagaŋ lu ya wa. Ta laghu ya da vwahani, ta laghu ya da tsakalani, ");
INSERT INTO xed_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ta valafta sanlaha ta tsa kwalvaha ya ka ganaptá iri ta həŋ, ka pslatá həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka kuzlanaftá tsi ta ŋuɗuf ta mgham, ka ghunadaptá tsi ta sludzihani zaɗanatá ta tsa gwal ta pslatá tsa mnduha ya ka driŋtá luwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tahula tsa, kaʼa nda kwalvahani mantsa: “Wana nda paya skwa zaya kla makwa. Tsa gwal si hagaŋ lu ya, raŋ ta həŋ a zay wa. ");
INSERT INTO xed_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lawala ta madədga tviha, ka hagakta kuni ta inda mndu dzaʼa guyuŋta kuni da na vla za skwa zay na,” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka sliʼafta tsa kwalvahani ya ka laghwi ta tvi. Ka tsakaktá həŋ ta inda mndu ya guyuŋ həŋ. Nda ghwaɗaka mnduha tani, nda ŋərma mnduha tani, ka ndəghanaftá həga ma tsa vla kla makwa ya. ");
INSERT INTO xed_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ka lamə mgham da nghanaghatá tsa gwal hagak lu ya. Ka nghaŋtá tsi ta sana mndu kul haɗ lguta kla makwa tida. ");
INSERT INTO xed_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kaʼa nda tsi mantsa: “Ari gra! Waka kagha sami da na həga na kul haɗ lguta kla makwa ta kagha na?” kaʼa nda tsi. Sew, sna a tsa mndu ya ta skwi ŋa mnay wa. ");
INSERT INTO xed_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ka mgham nda kwalvahani mantsa: “Habafwa haba ta dzvuhani nda səlahani, ka klafta kuni ka wuɗidiŋta dzibil da grum, ka tawa tsi ta taw, ka hpaɗa sliʼiŋani hada,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tsaya tama ná, dagala hagatani, ama kiʼa yeya ɗagatani,» ka Yesu sganaghata. ");
INSERT INTO xed_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mbaɗaka la Farisa ka tskavata ka dzrafta ka həŋ dzaʼa ksaftá Yesu nda gwaɗa dzaʼa sabi ma wani. ");
INSERT INTO xed_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ka ghunaftá həŋ ta sanlaha ma duhwalha taŋ kawadaga nda mnduha Hiridus slanaghatá Yesu. Ɓhadaghata taŋ, ka həŋ nda Yesu mantsa: «Mghama ɗa, nda sna ŋni kazlay: Ta mnay kagha ta kahwathwata kəʼa. Skwi ta kumə Lazglafta ta magay mu ta taghə kagha kahwathwata ŋa mnduha. Haɗ kagha ta zləŋa ira mndu wu, kabga gala a kagha nda gala ta mndu wa. ");
INSERT INTO xed_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mnaŋnamna ta ŋa gha ma ndanu. Nda ra re, ari ra a waʼa ka pla dzumna ŋa mgham Sezar na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tsaw nda sna Yesu ta tsa ghwaɗaka ndana taŋ ya. Kaʼa nda həŋ mantsa: «Tsa maɗgwirmaɗgwira ghuni ya. Kabgawu ta kəl kuni ka dzəgha iʼi na? ");
INSERT INTO xed_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Marihawa tsa kwaɓu ta kəl lu ka pla dzumna ya,» kaʼa. Ka klanaktá lu ta tsa kwaɓu ya. ");
INSERT INTO xed_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kaʼa nda həŋ mantsa: «Ŋa wa na fwatu nda hgu ta na kwaɓu na ná,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","«Ŋa mgham Sezar ya,» ka həŋ. «Ka mantsa tsi ya ní, vlaŋwavla ta mgham Sezar ta ya ta nzakway ka ŋa mgham Sezar. Vlaŋwavla guli ta Lazglafta ta ya nzakway ka ŋa Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Snaŋta taŋ ta tsa gwaɗa ya, ka ndərmim həŋ nda ndərmima. Ka zlanavatá həŋ ta Yesu ka laghwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Baɗu va tsaya, ka laghala Sadukiya, tsa gwal ta mnay kazlay: Haɗ lu dzaʼa sliʼagapta ma mtaku wu kəʼa ya slanaghata Yesu. ");
INSERT INTO xed_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ka həŋ nda Yesu mantsa: «Mghama ɗa, ka Musa na: “Ka mtumta mndu ta kul yatá tsi ta zwaŋ katsi, klay zwaŋamani ta tsa wadgani ya ka markwa taŋ ŋa yanatani ta zivir ta tsa zwaŋamani ta mtuta ya,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tsaw mamu sana mndu da aŋni ndəfáŋ zwanani. Ka klaftá mali ta marakw, ka mtuta tsi ta yana a lu ta zwaŋ wa. Ka wunanaghatá sagəŋani ta tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka mtutá tsa mahisa zwaŋ ya guli, ya a ta zwaŋ wa. Ka klafta ma hkən, ha ka klafta mandəfáŋ, haɗ ya ta yatá zwaŋ ma həŋ nda tsi wa. ");
INSERT INTO xed_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tahula rwuta taŋ demdem, ka mtuta tsa marakw ya guli. ");
INSERT INTO xed_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Baɗu sliʼagapta dzaʼa sliʼagapta gwal nda rwa ma mtaku nda hafu ní, wati dzaʼa nzakway ka zəʼala tsa marakw ya mataba tsa zwaniha ndəfáŋ ya, ya wya klukla həŋ demdem ka marakw na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka Yesu nda həŋ mantsa: «Ta nanay kuni ta ghəŋa ghuni, kabga sna a kuni ta skwi nda vinda ma defteri nda ghuɓa wa. Sna a kuni guli ta mbrakwa Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Baɗu sliʼagapta dzaʼa sliʼagapta lu ma mtaku ná, haɗ lu dzaʼa kləgəltá vgha ŋa nzakway ka marakw nda zəʼal wa. Dzaʼa nzakway lu ta nzaku tavata Lazglafta manda duhwalha Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gwaɗa ta ghəŋa sliʼagapta ma mtaku ná, ta dzaŋaf a kuni ma defteri ta tsa gwaɗa Lazglafta ta manay kazlay: ");
INSERT INTO xed_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Iʼi Lazglafta Abraham, iʼi Lazglafta Izak, iʼi Lazglafta Yakubu kəʼa ya ra? Lazglafta ná, Lazglafta gwal nda rwa a wu, Lazglafta gwal nda hafu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Snaŋta mnduha ta tsa tagha skwani ya, ka ndərmim həŋ nda ndərmima katakata. ");
INSERT INTO xed_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na snaŋta la Farisa kazlay: Hanafha Yesu ta wi ta la Sadukiya kəʼa, ka tskavatá həŋ. ");
INSERT INTO xed_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Lagha sani mataba taŋ ta nzakway ka mndu ta tagha zlahu ŋa mnduha, ka kuma tsanamtá matsavaɗa ta Yesu. Kaʼa nda tsi mantsa: ");
INSERT INTO xed_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Mghama ɗa! Wati mali mataba zlahuha na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Yesu nda tsi mantsa: «“Ɗvuɗva ta Mgham Lazglafta gha nda hyahya ŋuɗufa gha, nda inda hafa gha, nda inda ndana gha.” ");
INSERT INTO xed_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tsahaya mali mida, tsahaya taŋtaŋa zlahu guli. ");
INSERT INTO xed_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mamu mahisani manda tsaya guli: “Ɗvuɗva ta sləvda gha manda va ghəŋa gha” kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Inda zlaha Musa, nda inda skwi ta taghə la anabi ná, ta tsa zlahuha his ya sladafta həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mbaɗaka la Farisa ka tskavata hada tavata Yesu. Ka Yesu nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kinawu ka kaghuni ta ndanay ta ghəŋa Kristi na? Zwaŋa wa ya na?» kaʼa. «Zivra Dawuda ya,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka Yesu nda həŋ guli mantsa: «Waka Dawuda mnay nda ma mbrakwa Sulkum nda ghuɓa kazlay: Mgham kəʼa ɓa? Ya wya ka Dawuda na: ");
INSERT INTO xed_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ka Mgham nda Mghama ɗa na: Sawi nzata nda ga zeghwa ɗa, ha ka nanafta ɗa ta ghumaha gha ka skwa ta diŋlay səla gha”, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ka si “Mghama ɗa”, ka Dawuda ta hgay ya ní, waka Kristi dzaʼa nzakway ka zivrani tama?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Triɗ, traptra dər wa ta zlghanaftá wi. Daga baɗu tsa, haɗ mndu ta walglaŋta ɗawutá vli da tsi wa. ");
INSERT INTO xed_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tahula tsa, ka Yesu nda dəmga nda ya nda duhwalhani tani mantsa: ");
INSERT INTO xed_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Dzaŋanaghatá gwal tagha zlahu, nda la Farisa na tsislanaptá zlaha Musa ta mnduha. ");
INSERT INTO xed_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tsaya tama ná, nda ra ka snanata ghuni ta həŋ, ka magay ghuni ta inda skwi ta mnaghunata həŋ. Nziya nza tsi ná, yaha kuni da magay manda ya ta magə hahəŋ, kabga haɗ hahəŋ ta magay manda va ya ta mnata həŋ wa. ");
INSERT INTO xed_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ta hbafhba həŋ ta huzla ndəgaku ka fanaghatá mnduha, ama va a hahəŋ ta ksaŋta dər nda wa ndəfiŋa dzva taŋ wa. ");
INSERT INTO xed_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inda slna ta magə həŋ ná, ta magay həŋ ŋa nghay wa ira mnduha. Mantsa ya ná, ɓərzləzla ka hahəŋ ta mbaghaftá ŋa taŋ ayaha ta fuŋta ta wa bizlbizla kuma, nda ya ta dzvu. Zutut ka həŋ ta zlaŋtá dzva lguta taŋ. ");
INSERT INTO xed_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vli nda paya ta kəma ŋa taŋ ta zbay ŋa nzakwa taŋ ma fitika za skwa zay ta badawa. Vli nda paya ta kəma guli ta zbə həŋ ŋa nzakwa taŋ ma həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ta kumay həŋ ta ganaghata mnduha ta zgu ta həŋ ma vla tsakata vgha mnduha, ka hga həŋ ka “maləm.” ");
INSERT INTO xed_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama kaghuni ya, ma ɗvaf kuni ta hga kaghuni ka maləm. Turtuktuk Maləma ghuni. Kaghuni ná, la zwanama kuni. ");
INSERT INTO xed_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma hgə kuni ta mnda səla ta ghəŋa haɗik ka “Da” kabga turtuktuk Da ghuni ta nzakway ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma ɗvaf kuni ta hga kaghuni ka “mali,” kabga turtuktuk Mala ghuni ta nzakway ka Kristi. ");
INSERT INTO xed_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ka kwalva ghuni ká mali mataba ghuni nzakway. ");
INSERT INTO xed_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Inda mndu ta kapanaftá ghəŋani ná, dzaʼa dzaganadza lu. Inda mndu ta hanaganatá ghəŋani guli ná, dzaʼa kapanafkapa lu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya. Mbaɗa ka kuni ka hanaftá tgha ga mghama Lazglafta ta mnduha. Lamə a vərɗa kaghuni wu, zlanaŋ a kuni ta tvi ta gwal ta kuma lami guli wa. ");
INSERT INTO xed_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya. Kaghuni ta hluguduŋtá skwa miʼa wadgu. Ka va slriŋtá maga duʼa ŋa nghay wa ira mnduha. Tsaya tama dzaʼa kəl lu ka tsaghunaghatá guma ka malaghutá mbraku. ");
INSERT INTO xed_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya. Ta wawaku kuni ka ra vli ta drəf nda ya ta haɗik ŋa mutsaftá dər mndu turtuk ŋa da dina ghuni. Ka mutsafmutsa kuni, ŋa niŋta ghuni ka mnda nzakway ma duda vu ka malaghutá ŋa ghuni mantsa ya mantsa ya his. ");
INSERT INTO xed_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ɗaŋwa ŋa ghuni gwal nda ghulpa ta kla gwal nda ghulpa. Ka kuni ta mnay tazlay na: “Ka waɗawaɗa mndu ta waɗu nda həga Lazglafta ná, bla a tsaya wa. Ama ka waɗawaɗa mndu ta waɗu nda dasu ma həga Lazglafta katsi ná, nda nza tkweʼ ka magatani ta skwi waɗa tsi ŋa magay ya, ka kuni.” ");
INSERT INTO xed_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","La rghaha, gwal nda ghulpa! Wati mali mida? Mal dasu re, ari mal həga Lazglafta ta nanaftá dasu ka skwi nda ghuɓa ya a ka na? ");
INSERT INTO xed_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ka kuni guli ná, “ka waɗawaɗa mndu ta waɗu nda gwir ná, bla a tsaya wa. Ama ka waɗawaɗa mndu ta waɗu nda skwi ya vlaŋ tsi ta Lazglafta ta gwir ná, nda nza tkweʼ ka magatani ta tsa skwi waɗa tsi ŋa magay ya,” ka kuni. ");
INSERT INTO xed_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ghulpata mnduha! Wati mali mida. Skwi ya kəl lu ka mbəhata nda tsi re, ari gwir ta nanaftá skwa mbəhu ka skwi nda ghuɓa ya a ná? ");
INSERT INTO xed_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wya tsi, mndu ta waɗa ta waɗu nda gwir ná, waɗawaɗa ta waɗu nda skwi tida tani. ");
INSERT INTO xed_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mndu ta waɗa ta waɗu nda həga Lazglafta ná, waɗawaɗa ta waɗu nda Lazglafta ta nzaku mida ya tani. ");
INSERT INTO xed_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mndu ta waɗa ta waɗu nda luwa ná, waɗawaɗa ta waɗu nda dughurukwa nzakwa Lazglafta, nda Lazglafta ta nzaku tida ya tani. ");
INSERT INTO xed_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya! Ta ŋavaŋa kuni ka vla zaka niɗali, ka zluŋtá mali ma skwi ma zlahu ta nzakway ka nzaku tɗukwa, nda maga zɗaku, nda nzaku ka ŋərma. Tsahaya skwi ma ŋa magay nda kwal kul zanaptá sanlaha ma skwiha. ");
INSERT INTO xed_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gwal ta kla gwal nda ghulpa kuni! Ta ɗizapɗiza kuni ta imi ŋa kliŋta miyauŋ mida, ka laghwa ghuni da ndutá ŋalibwa. ");
INSERT INTO xed_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya! Hula leghwa ta sa imi nda hliba ŋa ghuni ta laghwi da mbaziŋta, ama ma huɗani, nda ndəgha nda skwa ghala ghuni nda ya nda skwiha zlaʼuwa kuni. ");
INSERT INTO xed_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","La Farisa ghulpata mnduha! Tiŋəl ma ka kuni ghuɓiŋtá huɗa leghwa nda hliba, kada nzakwa hulani nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya! Manda kulu ɓap lu ka ŋusliŋ nzakwa ghuni. Ká ka nda ɗinakwani nda ta hulani, ama nda ma huɗani ná, tskata ghudzifa gwal nda rwa, nda ya nda rwata ŋəɗak yeya mida. ");
INSERT INTO xed_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Manda va tsaya kaghuni guli. Ta nghadaghatá mnduha ta kaghuni ná, manda skwi tɗukwa nzakwa ghuni. Ama ta ghəŋa maɗgwirmaɗgwir, nda kwal kul sna gwaɗa da Lazglafta yeya ma kaghuni. ");
INSERT INTO xed_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Ɗaŋwa ŋa ghuni gwal tagha zlahu ŋa mnduha, nda la Farisa. Tsa maɗgwirmaɗgwira ghuni ya! Ta baba kulu kuni ŋa la anabi, ta pgha rka kuni ta kula gwal ta snanatá gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ka kuni ta mnay ná, “ka má si mamu aŋni ta fitika dzidzíha ŋni ná, ma gwafta a aŋni ta wi nda həŋ ka pslatá la anabi wu, ka kuni.” ");
INSERT INTO xed_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ma tsa mnay ta mnə kuni mantsa ya ná, maraŋmara kuni kazlay: Zivra tsa gwal ta zaɗanatá la anabi ya kuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɗina tsa, lawa ta kəma ta kəma nda maga tsa ghwaɗaka slna zlraf dzidzíha ghuni ya! ");
INSERT INTO xed_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nahaɗikha! Mndəra la mupuha! Haɗ wa ghuni ŋa ndapta ma tsa guma nda vu ya wa. ");
INSERT INTO xed_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tsaya tama ná, dzaʼa ghunaghunafghuna yu ta la anabi, nda gwal nda ɗifil da həŋ, nda gwal tagha zlahu. Dzaʼa pslata nda psla kuni ta sanlaha, dzaʼa zleŋafta nda zləŋa kuni ta sanlaha, dzaʼa sləvapta nda sləva kuni ta sanlaha ma həga tagha skwa ghuni, dzaʼa zbiŋzba kuni ta həŋ ma inda luwaha, ka giri ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tsaya tama, ta ghəŋa ghuni dzaʼa vrafta usa gwal tɗukwa psla kuni. Zlrafta ta Abel mndu tɗukwa, ha ka sagha ta dzata dza kuni ta Zakari zwaŋa Baraki, ya dza lu ma takataka vli nda ghuɓa ma həga Lazglafta nda gwir ya. ");
INSERT INTO xed_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kahwathwata ka yu ta mnaghunata, dzaʼa vrafta ta ghəŋa gwal ta na fitik na inda tsaya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Aya Ursalima! Aya Ursalima! Kagha ta pslatá la anabi, kagha ta pslata nda pala ta gwal ghunadaghagha Lazglafta. Nda kɗa fitika zbaŋta ɗa ta tskanatá zwana gha manda mana ghatalakw ta tskanatá nduɗukhani ma zlambakhani ya, ama ka kwalaghuta kuni. ");
INSERT INTO xed_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ndana tama, zlaghunaŋzla lu ta həga ghuni ka kufik. ");
INSERT INTO xed_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kahwathwata ka yu ta mnaghunata, haɗ kuni dzaʼa nghəglaŋtá iʼi wa, ha ŋa mnay ghuni dazlay kazlay: Tfawi ta ghəŋa mndu ta sagha ma hga Mgham Lazglafta kəʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mbaɗa Yesu ka sabi ma həga Lazglafta, ka sliʼi. Ka lagha duhwalhani tavatani ŋa maranata batá həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka Yesu nda həŋ mantsa: «Nda ngha kuni ta inda ya nzakwani ya kiʼe? Kahwathwata ka yu ta mnaghunata, dzaʼa tasiŋtasa lu ta indani demdem. Haɗ nzugwatá pala sani ta sani, dzaʼa pɗata wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ka sliʼaftá Yesu ka laghwi nzata ta ghwá Zaytuŋ. Ka lagha duhwalhani slanaghata. Ka nzata həŋ nda ghəŋa taŋ kawadaga nda tsi. Ka ɗawaŋtá həŋ da tsi: «Mnaŋnamna ka yawu dzaʼa magakwa tsa skwi ya. Kinawu ka ŋni dzaʼa snaŋtá fitik dzaʼa kəl ka ka sagha, nda fitika kɗakwa ghəŋa haɗik na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka Yesu nda həŋ mantsa: «Ɗasuwa ka kuni, yaha lu da nanaghunafta. ");
INSERT INTO xed_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wya nda ndəgha mnduha dzaʼa klafta hga ɗa ka sagha: “Iʼi Kristi,” ka həŋ dzaʼazlay ŋa nanaghata taŋ ta ndəghata mnduha. ");
INSERT INTO xed_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dzaʼa nda sna kuni ta gwaɗa ta vulu ma vliha ndusa ndusa nda ya ma vliha diʼiŋ diʼiŋ. Ɗasuwa ka kuni, yaha ŋuɗufa ghuni tɗu, kabga nda nza tkweʼ ka magakwa inda tsa skwiha ya. Ama tsaya a kɗakwa ghəŋa haɗik wa. ");
INSERT INTO xed_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dzaʼa vulay sana luwa ta vulu nda sana luwa. Dzaʼa vulay sana mgham ta vulu nda sana mgham. Dzaʼa slasla maya ma sana vliha. Dzaʼa gigɗavafgigɗa haɗik. ");
INSERT INTO xed_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inda tsa skwiha dzaʼa magaku ya ná, dzaʼa nzakway manda zlrakwa ɓasa yaku. ");
INSERT INTO xed_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Dzaʼa vlavla lu ta kaghuni ma dzvu ŋa mnduha, ŋa gaghunaptá iri. Dzaʼa pslapsla lu ta kaghuni guli. Dzaʼa husaŋhusa kuni ta inda mndəra mnduha ta ghəŋa haɗik kabga gwaɗa ta iʼi. ");
INSERT INTO xed_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta ghəŋa tsaya tama, nda ndəgha gwal dzaʼa zlanavatá zlghay nda ŋuɗufa taŋ. Dzaʼa skwapskwa sani ta sani, ta husaŋtá sani ta sani. ");
INSERT INTO xed_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nda ndəgha ghwaɗaka anabiha dzaʼa sagha ŋa nanaghata taŋ ta ndəghata mnduha guli. ");
INSERT INTO xed_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ta dzaʼa sgaku nda sga maga ghwaɗaka skwi, dzaʼa vyaku nda vya ɗvu ma ŋuɗufa ndəghata sanlaha ma gwal zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama mndu ta suʼafta ha ka lagha ta kɗavaktani, dzaʼa mbaku. ");
INSERT INTO xed_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dzaʼa mnay lu ŋa mnduha ta ghəŋa haɗik demdem ta tsa Lfiɗa Gwaɗa ta ghəŋa ga mghama Lazglafta ya, ŋa snaŋta gwal kul snaŋtá Lazglafta. Tahula tsaya tama, ŋa sagha fitika gwaɗa ta kɗakwa ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Tsaya tama, ka nda ngha kuni ta sana “ghwaɗaka manzakɗaway ta vla mbiɗa” manda ya mnə anabi Daniyel, fa lu ma vli nda ghuɓa ya, ɗina ka snaŋta mndu ta dzaŋay. ");
INSERT INTO xed_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","«Ma tsa fitik ya, ka hwaya gwal ta haɗika Zudiya ta hwaya ta ghwá. ");
INSERT INTO xed_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka ta ghəŋa həga nda dədəma mndu, yaha ləglami nda ma həga da hla huzla mida, ka hwaya tsi ta hwaya. ");
INSERT INTO xed_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka ma vwah mndu, yaha da vrəgəlta dzagha da hla lguthani. ");
INSERT INTO xed_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ɗaŋwa taŋ ŋa miʼaha nda huɗi nda ya nda miʼaha nda zwaŋ ta ghuva taŋ ma tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ka ndəɓa kuni ta dzvu yaha tsa fitika hwaya ghuni ya da nzakway ma fitika mazlam, nda ya baɗu sabat, ");
INSERT INTO xed_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kabga dagala ghuya ɗaŋwa dzaʼa slaku ma tsa fitik ya. Ta walaŋ a mndərga ghuya ɗaŋwa manda tsaya ta slata ka yawu fata ghəŋa haɗik wa. Haɗ mndəra tsaya dzaʼa sləglata guli wa. ");
INSERT INTO xed_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka má haɗ ka Lazglafta ta htanaktá tsa fitik ya wu, ma haɗ mndu dzaʼa ndapta wa. Ama kabga gwal ya zabap tsi, ka htanaktá tsi ta tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Ka ka mndu nda kaghuni mantsa: “Aʼ! Wana Kristi hadna.” “Aʼ! Wa a hada a,” kaʼa ná, yaha kuni da tsuʼafta. ");
INSERT INTO xed_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ya dzaʼa sliʼagaghasliʼa ghwaɗaka krista nda ghwaɗaka anabiha, ŋa magay taŋ ta skwa mandərmimiha nda mazəmzəmha katakata ŋa nana mndu, ka ta magaku tsi, nda gwal ɗagap Lazglafta tani. ");
INSERT INTO xed_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wya mnaghunamna yu ta tsekeʼluwa. ");
INSERT INTO xed_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ka ka lu nda kaghuni mantsa: “Aʼ! Wa a Kristi ta wa mtak kəʼa,” yaha kuni da dzaʼa. “Aʼ! Wana ɗifaghuta hadna kəʼa,” yaha kuni da zlghafta. ");
INSERT INTO xed_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sagha dzaʼa sagha Zwaŋa mndu ná, dzaʼa sagha manda wuɗakwa luwa nda ma mndəra luwa, ka ranaftá vli kutsuk ma mndəra luwa ya, dzaʼa nzakwa tsi. ");
INSERT INTO xed_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma vli dər ga mbla skwi ya ná, hada dzaʼa tska gugzlum ta vgha. ");
INSERT INTO xed_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Gi tahula fitika tsa ghuya ɗaŋwa ya, gi tɗik dzaʼa nzata fitik, haɗ tili dzaʼa tsuwaɗakgəltá vli wu, dzaʼa rkaga rka tekwatsa ta luwa, dzaʼa gigɗavafgigɗa skwiha nda mbra nda mbra ta luwa. ");
INSERT INTO xed_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ma tsaya tama dzaʼa ngha lu ta saha zwaŋa mndu ta luwa ŋa wahay mnduha ta ghəŋa haɗik ka wahu, ŋa nghay taŋ ta Zwaŋa mndu ta saha ta luwa ma ghwayak nda inda mbrakwani, nda inda glakwani. ");
INSERT INTO xed_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ŋa ghunaftani ta duhwalha Lazglafta ŋa vyata taŋ ta duli ta taw katakata, ŋa tsakakta taŋ ta gwal ya ɗagap tsi ta slərpa luwa fwaɗ, sliʼaftani ta mndəra luwa dikw dista luwa.» ");
INSERT INTO xed_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Mamu skwi ŋa taghay ghuni ma nzakwa ghuraf. Ka nda sta ghuraf ta ɗakuɗaku sluhwa tida katsi, nda sna kuni kazlay: Ndusa duwiŋ tama kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Manda va tsaya guli ná, ka nda ngha kuni ta inda tsa skwiha ya, grafwa gra kazlay: Ndusa Zwaŋa mndu, manda skwi ta watgha nzakwani kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kahwathwata ka yu ta mnaghunata, ta sagha tsa skwiha ya ná, rwuta a na mnduha ta na fitik na demdem wa. ");
INSERT INTO xed_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dzaʼa lula luwa nda haɗik, ama gwaɗa ɗa ná, walaŋta a ta luta wa.» ");
INSERT INTO xed_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Tsa gwaɗa ta ghəŋa fitik ya dzaʼa magaku tsa skwiha ya, nda ya ka ta wati luwa tsi ya ná, haɗ mndu nda sna wa. Dər duhwalha Lazglafta, dər Zwaŋ, sna a wa. Da turtukwani yeya nda sna. ");
INSERT INTO xed_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma tsa fitik dzaʼa sagha Zwaŋa mndu ya ná, manda va skwi ta luta ma fitika Nuhu ya dzaʼa magakwa tsi. ");
INSERT INTO xed_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manda va ya ma tsa fitik ma kɗaku tsa ima mabuɗbuɗ ya dzaʼa nzakwa tsi, laghula mnduha da hamtá ghəŋ ma za skwi, nda ya ma sasaku. Laghula həŋ da hamtá ghəŋ ma kla makwa, nda valaŋtá kwagha taŋ ŋa zəʼal, ha ka sagha fitik kəl Nuhu ka lamə da kwambalu. ");
INSERT INTO xed_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Haɗ sana skwi ndanaŋ həŋ wu, ha ka sagha ima mabuɗbuɗ hlaghatá həŋ demdem. Baɗu tsa fitik dzaʼa sagha Zwaŋa mndu ya ná, manda va tsaya dzaʼa magakwa tsi. ");
INSERT INTO xed_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma tsa fitik ya, ta maga slna mnduha his ma vwah, ŋa klanaghutá sani ka zlanavata sani. ");
INSERT INTO xed_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Miʼaha his ta huʼu ta buna, ŋa klanaghuta sani ka zlanavata sani. ");
INSERT INTO xed_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ka si mantsa tsi, nzawanza hzleŋa, kabga sna a kuni ta tsa fitik dzaʼa kəl mghama ghuni ka sagha ya wa. ");
INSERT INTO xed_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wya skwi ɗina ŋa snaŋta ghuni: Ka má nda sna daŋahəga ta fitik má dzaʼa lamə ghali da həgani ná, má dzaʼa nzanza hzleŋa, má zlanata a ta ghali ka lamani da həgani wa. ");
INSERT INTO xed_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tsaya tama ná, nzawanza kaghuni guli nda payatá vgha, kabga ma tsa fitik kul faftá kuni ta ghəŋ ya, dzaʼa sagha Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Wa na ŋərma kwalva nda hiɗa fanam daŋahəgani ma dzvu ta inda gwal ksanata slna, ŋa nghaptani ka həŋ ka dgayni ta skwa zay ŋa taŋ nda fitikani na na? ");
INSERT INTO xed_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rfu ŋa tsa kwalva dzaʼa sagha daŋahəgani slanaghata ta magaymagay ta tsa slna ya. ");
INSERT INTO xed_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kahwathwata ka yu ta mnaghunata, dzaʼa fanamfa daŋahəgani ta inda gadghəlani ma dzvu. ");
INSERT INTO xed_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ala, ka ghwaɗaka kwalva tsi, “saghata a daŋahəga ɗa misimmisim wu” kaʼa dzaʼazlay ma ghəŋani, ");
INSERT INTO xed_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ŋa liŋtani ta psla grahani ta ksə həŋ slna ka skwa turtuk. Ŋa laghwani zazakwani, ka sasakwani kawadaga nda gwal ghwayaku. ");
INSERT INTO xed_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nda sagha daŋahəgani slanaghata dluk ma fitik kul faftá tsi ta ghəŋ, nda ya ka ta wati luwa tsi, sna a wa. ");
INSERT INTO xed_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dzaʼa ɗgapɗga daŋahəgani, ŋa tsanaghatani ta guma kawadaga nda la ghwaɗak, ŋa taway tsa kwalva ya ta taw, ka hpaɗa sliʼiŋani hada,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ma tsa fitik ya, dzaʼa gray lu ta ga mghama Lazglafta nda sana kuʼaha ghwaŋ ta klaftá pitirla taŋ ka dzaʼa da gəma zwaŋa midzi. ");
INSERT INTO xed_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mataba taŋ, hutaf gwal kul hiɗaku, hutaf gwal nda hiɗa. ");
INSERT INTO xed_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta klafta tsa kuʼaha kul hiɗaku ya ta pitirla taŋ ná, tana a həŋ ta rɗi ŋa sgay da tsa pitirla taŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama tsa kuʼaha nda hiɗa ya, tanaʼatá hahəŋ ta rɗi ma hwarak ŋa sgay da ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ka gərɗatá zwaŋa midzi ka sagha misimmisim. Ka zuŋur hani ta həŋ, ka pslatá hani ta həŋ demdem. ");
INSERT INTO xed_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Ma takala tama, ka guguɗatá lu: “Waʼa zwaŋa midzi kay ta sagha! Lawala da gmay,” ka lu. ");
INSERT INTO xed_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ka sliʼavatá tsa kuʼaha ya demdem ta hani, ka sganaghatá vu ma pitirla taŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka tsa kuʼaha kul hiɗaku ya nda tsaha nda hiɗa ya mantsa: “Taŋnafwata ta na rɗa ghuni na, wana na ŋa ŋni ma pitirla na ta mtaku,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka tsaha nda hiɗa ya mantsa: “Kay! Slaghwa a ka dgay mu wa, lawala da gwal ta dzawapta, ka skwakta kuni ta ŋa ghuni,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ta laghu hahəŋ da skwa rɗi ya ná, ta ɓhagaghatá zwaŋa midzi. Ka lamə tsaha nda hba vgha taŋ ya kawadaga nda tsi da həga kla makwa, ka hawutá lu ta tgha. ");
INSERT INTO xed_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ɓats nzɗa tama, ka vraktá tsa kuʼaha ya. Ka həŋ mantsa: “Mghama ɗa, mghama ɗa! Gunaŋnaguna ta watgha,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kaʼa nda həŋ mantsa: “Kahwathwata ka yu ta mnaghunata, sna a yu ta kaghuni wu,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ka Yesu sganaghata mantsa: «Nzawanza hzleŋa, kabga sna a kuni ta tsa fitik ya, ka ta wati luwa tsi wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Manda va tsaya ná, dzaʼa gray lu ta ga mghama Lazglafta nda sana mndu ma sliʼani dista luwa, ka hagaftá tsi ta kwalvahani, ka dganaftá tsi ta gadghəlani ta həŋ ma dzvu. ");
INSERT INTO xed_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka klaftá tsi ta talaŋ hutaf, ka vlaŋtá sani. His kəʼa klafta ka vlaŋtá sani. Pal kəʼa klafta guli ka vlaŋtá mahkənani. Taɓta mbrakwa taŋ kəʼa dganaftá həŋ. Ka sliʼaftá tsi ka laghwi. ");
INSERT INTO xed_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ka gi sliʼafta tsa ta zlghaftá talaŋ hutaf ya da tsakala nda tsi, ka zanaghatá tsi ta ndeli ka talaŋ hutaf guli. ");
INSERT INTO xed_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka sliʼaftá tsa ta zlghaftá talaŋ his ya guli ka laghwi da tsakala, ka zanaghatá tsi ta ndeli ka talaŋ his guli. ");
INSERT INTO xed_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tsa ta zlghaftá talaŋ turtuk ya, ka laghu tsi da lapta ghurum ma haɗik, ka ɗifanatá tsa tseda daŋahəgani ya. ");
INSERT INTO xed_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nzɗavanzɗa lu katakata tama, ka vraktá daŋahəga tsa kwalvaha ya dzagha. Ka ɗaw tsi da həŋ ta skwi maga həŋ nda tsa tsedani ya. ");
INSERT INTO xed_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ka lagha tsa ta zlghafta talaŋ hutaf ya, ka kladanaghata nda talaŋ hutaf guli. Kaʼa mantsa: “Mghama ɗa, talaŋ hutaf vliha ka, wana zanaghata yu ta ndeli ka talaŋ hutaf guli,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka daŋahəgani nda tsi mantsa: “Ɗina tsa, ŋərma kwalva ka! Manda va tsa nzakwa gha ka ŋərma mndu ma skwi kwitikw ya, ta vlaghavla yu ta skwi dagala. Saghusa gha da rfu kawadaga nda iʼi,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ka lagha tsa ta zlghaftá talaŋ his ya guli, ka kladanaghata nda sana talaŋ his. Kaʼa mantsa: “Mghama ɗa, talaŋ his vliha ka, wana zanaghata yu ta ndeli ka talaŋ his guli,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka daŋahəgani nda tsi mantsa: “Ɗina tsa, ŋərma kwalva ka. Manda va tsa nzakwa gha ka ŋərmani ma skwi kwitikw ya, ta vlaghavla yu ta skwi dagala guli. Saghusa gha da rfu kawadaga nda iʼi,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tahula tsa, ka lagha tsa ta zlghafta talaŋ turtuk ya guli. Kaʼa mantsa: “Mghama ɗa, nda sna yu kazlay: Nda bla gwaɗa ta kagha kəʼa. Ta tskay ka ta skwi ta vwah ma vli kul sləgadata ka. Ta hlay ka guli ta skwi ma vli kul vihaŋtá ka. ");
INSERT INTO xed_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ka zləŋaftá yu ta zləŋ, ka laghu yu da ɗifanatá tsa talaŋa gha ya ma haɗik. Wana tsi, kla ta skwa gha,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ka daŋahəgani nda tsi mantsa: “Kagha ná, ghwaɗaka kwalva ka, yaɗi. Ka si nda sna ka kazlay: Ta tskay yu ta skwi ta vwah ma vli kul sləgadatá yu, ta hlay yu ta skwi ma vli kul vihaŋtá yu kəʼa ya ní, ");
INSERT INTO xed_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","má fafa ka ta tsa tseda ɗa ya ma baŋki, ma na vragaghata ɗa na ná, má saghasa yu da kla skwa ɗa nda imi ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kləgadanaghwakla ta tsa talaŋ ya, ka gwanavata kuni ta tsa nda talaŋ ghwaŋ ya,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","«Mantsa ya ná, ŋa mndu mamu tsi da tsi, ta sganaghata lu ta skwi ŋa nzakwani dagala da tsi. Ama mndu ya kul haɗ tsi da tsi ya, kləgadanaghutá va tsa kwitikwatani da tsi ya. ");
INSERT INTO xed_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Klafwa kla ta tsa ghwaɗaka kwalva ya ka wuɗidiŋta kuni dzibil da grum, ka dzaʼa tsi taw, ka hpaɗa tsi ta sliʼiŋani hada,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Baɗu sagha dzaʼa sagha Zwaŋa mndu ma glakwani kawadaga nda inda duhwalha Lazglafta ná, dzaʼa nzafnza ta dughurukwa glakwani. ");
INSERT INTO xed_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dzaʼa tskanatska lu ta inda mndəra mnduha ta ghəŋa haɗik ta kəmani, ŋa dganatani ta sanlaha nda sanlaha manda ya ta dganata mnda ngha rini ta tuwak nda gu ya. ");
INSERT INTO xed_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ŋa pghatani ta tuwak nda ga zeghwani, pghaha ta gu nda ga zlaɓani. ");
INSERT INTO xed_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ka mgham dzaʼazlay nda tsaha nda ga zeghwani ya mantsa: “Saghawasa, kaghuni gwal tfanagha Da ɗa ta wi ya. Tsuʼawa tsuʼa, ta za mgham ya payaghunaf Lazglafta daga ma zlrafta ghəŋa haɗik ya. ");
INSERT INTO xed_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ma fitika dzay maya ta iʼi, vlihavla kuni ta skwa zay. Ma fitika dzay ndala ta iʼi, tiɗiftá kuni ta imi ŋa say. Nzanza yu ka matbay, ka tsuʼaftá kuni ta iʼi. ");
INSERT INTO xed_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma nzakwa ɗa ka fərdiʼu, suɗiɗiva suɗa kuni ta lgut. Ma nzakwa ɗa kul ɗughwanaku, nghapngha kuni ka iʼi. Ma nzakwa ɗa ma gamak, nghaɗighangha kuni,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ka tsa gwal ta snatá gwaɗa Lazglafta ya dzaʼazlay mantsa: “Yawu nghaŋta ŋni ta kagha ta dzə maya, ka vlaghatá ŋni ta skwa zay? Yawu nghaŋta ŋni ta kagha ta dzə ndala, ka taghaftá ŋni ta imi ŋa say? ");
INSERT INTO xed_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yawu nghaŋta ŋni ta kagha ka matbay, ka tsuʼaftá ŋni ta kagha? Yawu nghaŋta ŋni ta kagha ka fərdiʼu ka suɗavaghatá ŋni ta lgut? ");
INSERT INTO xed_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yawu nghaŋta ŋni ta kagha kul ɗughwanaku? Yawu nghaŋta ŋni ta kagha ma gamak ka lagha ŋni nghaghata?” ka həŋ ");
INSERT INTO xed_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ka Mgham dzaʼazlay mantsa: “Kahwathwata ka yu ta mnaghunata ná, inda fitik ya maga kuni ta tsa skwiha ya ŋa zwanama ɗa gwal ya nda hta katakata ya ná, magihatá iʼi kuni nda tsa.” ");
INSERT INTO xed_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Tahula tsa, kaʼa dzaʼazlay nda tsa gwal nda ga zlaɓani ya mantsa: “Laghwala tavata iʼi, kaghuni gwal ksiʼaf Lazglafta. Lawala da həga vu ya ŋa kɗekedzeŋ, payaf lu ŋa i halaway nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ma fitika dzay maya ta iʼi, vliha a kuni ta skwa zay wa. Ma fitika dzay ndala ta iʼi, tiɗif a kuni ta imi ŋa say wa. ");
INSERT INTO xed_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nzanza yu ka matbay, tsuʼaf a kuni ta iʼi wa. Ma nzakwa ɗa ka fərdiʼu, suɗiɗiva a kuni ta lgut wa. Ma nzakwa ɗa kul ɗughwanaku nda ya ma nzakwa ɗa ma gamak guli, nghaɗigha a kuni wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ka həŋ dzaʼazlay guli na: “Mghama ɗa, yawu nghaŋta ŋni ta kagha ta dzə maya? Yawu nghaŋta ŋni ta kagha ta dzə ndala? Yawu nzata ka ka matbay? Yawu nghaŋta ŋni ta kagha ka fərdiʼu? Yawu nghaŋta ŋni ta kagha kul ɗughwanaku? Yawu nghaŋta ŋni ta kagha ma gamak kul kataghata ŋni na?” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ka Mgham dzaʼazlay nda həŋ mantsa: “Kahwathwata ka yu ta mnaghunata, inda fitik ya kul maganatá kuni ta tsa skwiha ya ŋa gwal ya nda hta katakata ya, ŋa ɗa kwalaghuta kuni ta magay nda tsaya.” ");
INSERT INTO xed_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ŋa sliʼa tsaha ya da vla ghuya ɗaŋwa ŋa kɗekedzeŋ, ta sliʼi gwal ta snatá gwaɗa Lazglafta da vla hafu ŋa kɗekedzeŋ guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Manda kɗiŋta Yesu ta inda tsa gwaɗaha ya, kaʼa nda duhwalhani mantsa: ");
INSERT INTO xed_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Nda sna kuni kazlay: Ta his fitik ka skala Pak kəʼa, ŋa vlatá Zwaŋa mndu ŋa zləŋafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka tskavatá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu mataba mnduha ma daɓa həga ga mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta hgə lu Kayifa ya. ");
INSERT INTO xed_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ka dzraftá həŋ ta ksaftá Yesu ma ɗifa ma ɗifa ŋa dzata. ");
INSERT INTO xed_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ama ka həŋ mantsa: «Yaha da nzakway baɗu fitika skala Pak tama, kabga yaha da sliʼanaftá ŋuɗufa mnduha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ta nzaku Yesu ma həga ga Simuŋ, sana mndu nda rɗa mndu tida ma luwa Betani, ");
INSERT INTO xed_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ta za skwa zay həŋ, ka lagha sana marakw tavata Yesu nda klatá hwaraka albastra nda ndəghatani nda urdi ya nda bla dzvani. Ka pghəganatá tsi ma ghəŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nghay duhwalhani ta tsa skwi ta magə tsa marakw ya, zɗəgana a ta həŋ wa. «Kabgawu ta kəl lu ka ɓadza skwi manda na na? ");
INSERT INTO xed_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Skwi ma ŋa skwapta na urdi na ka tsedi dagala, ka daganaftá la ka pɗu ná,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Snaŋta Yesu ta tsa gwaɗa taŋ ya, kaʼa nda həŋ mantsa: «Kabgawu ta kəl kuni ka ghuya ɗaŋwa ŋa na marakw na na? Ɗina skwi magiha tsi ta iʼi. ");
INSERT INTO xed_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kawadaga a kaghuni nda la ka pɗu inda fitik wu ra? Ama iʼi ná, gɗavata a yu kawadaga nda kaghuni inda fitik wa. ");
INSERT INTO xed_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nana pghata urdi pghiɗigha tsi na ná, paya iʼi ŋa dzaʼa da kulu ya. ");
INSERT INTO xed_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kahwathwata ka yu ta mnaghunata, ma inda vli dzaʼa mnə lu ta na Lfiɗa Gwaɗa na ta ghəŋa haɗik tender ná, dzaʼa gɗagɗa lu ta rusa skwi maga na marakw na ŋa havay,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ka gi sliʼafta sani mataba duhwalhani ta hgə lu ka Zudas Iskaryut, ka laghwi slanaghata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kaʼa nda həŋ mantsa: «Nu dzaʼa vlihata kuni ka vlaghunavla yu ta Yesu na?» kaʼa. Ka vlaŋtá həŋ ta suley hkən mbsak. ");
INSERT INTO xed_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daga ma tsa fitik ya, ka zbə tsi ta tvi ya nda ra ŋa vlatani ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Baɗu taŋtaŋa fitika skala buradi kul haɗ is mida, ka duhwalhani nda Yesu mantsa: «Ga ta kuma ka ta payaghafta ŋni ta vla skwa zaya skala Pak na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kaʼa nda həŋ mantsa: «Lawala da huɗa luwa, ka lagha kuni da sana mndu. Ka kuni dzaʼazlay nda tsi na: “Wana ndusakndusa fitika ɗa, ga ghuni dzaʼa za yu ta skwa skala Pak kawadaga nda duhwalha ɗa, ka Mghama ŋni, ka kuni dzaʼazlay,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ka laghu duhwalhani magata manda va ya mnana Yesu ta həŋ. Ka payaftá həŋ ta skwa zaya skala Pak. ");
INSERT INTO xed_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gahawani, ka nzata Yesu kawadaga nda duhwalhani ghwaŋpɗə his ka za skwa zay. ");
INSERT INTO xed_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta zə həŋ ta tsa skwa zay ya, kaʼa mantsa: «Kahwathwata ka yu ta mnaghunata, mamu sani mataba ghuni dzaʼa vlatá iʼi ma dzva mnduha,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rmasas ka vgha inda taŋ. «Iʼi a wu suʼu ní Mghama ɗa! Iʼi a wa suʼu ní Mghama ɗa!» ka inda hahəŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kaʼa nda həŋ mantsa: «Tsa mndu tsghada ŋni da hliba ka guram nda tsi ya, tsa mndu ya dzaʼa vlatá iʼi ma dzva mnduha. ");
INSERT INTO xed_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dzaʼa laghulani Zwaŋa mndu manda ya nda vinda ma gwaɗa Lazglafta ta ghəŋani. Ama ɗaŋwa ŋa mndu dzaʼa vlatá Zwaŋa mndu ma dzvu ŋa mnduha. Ta draŋ ya má kwal lu kul yatá tsa mndu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ka Zudas dzaʼa vlata ma dzva mnduha ya guli mantsa: «Ari iʼi a ní Mghama ɗa?» kaʼa. «Manda va ya mna kagha nda wa gha,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta za skwa zay həŋ, ka klafta Yesu ta buradi. Tahula rfanaghatani ta Lazglafta, ka ɓlanaptá tsi ka vlaŋtá duhwalhani. Kaʼa mantsa: «Zlghawazlgha ka za kuni. Nanana ná, sluʼuvgha ɗa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ka klafta tsi ta leghwa ima inabi guli. Tahula rfanaghatani ta Lazglafta, ka vlaŋtá tsi ta həŋ. Kaʼa mantsa: «Sasaʼawasasa kaghuni demdem, ");
INSERT INTO xed_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kabga nanana ná, usa ɗa ya, usa slərɓa zughu dzaʼa pghiŋta lu ŋa pla dmakwa ndəghata mndu. ");
INSERT INTO xed_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka yu ta mnaghunata ná, haɗ yu dzaʼa səglaŋtá na ima inabi na wu, ha ka sagha fitik ya dzaʼa kəl yu ka səgəltá lfiɗani kawadaga nda kaghuni ma ga mghama Da ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tahula fafanafta taŋ ta laha skala Pak, ka laghu həŋ ta ghwá Zaytuŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ka Yesu nda həŋ mantsa: «Ta na rviɗik gitaʼuna, dzaʼa hwayaghuhwaya kuni ka zlihata. Ka lu vindafta ma defteri Lazglafta na: Dzaʼa dzadza lu ta mnda ngha tuwak, ŋa gazlata tuwakha demdem ta bra. ");
INSERT INTO xed_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama tahula sliʼagapta ɗa ma mtaku, dzaʼa tiŋlaghutiŋla yu ta ɓhata ma Galili ka kaghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka Piyer nda tsi mantsa: «Dər ma dzaʼa hwayaghuhwaya lamndu ka zlavaghata ná, haɗ iʼi dzaʼa walaŋta hwayaghuta ka zlavaghata wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","«Kahwathwata ka yu ta mnaghata, ta va na rviɗik gita u na, ma kɗaku vazak ka wahata, dzaʼa mnamna ka hkən səla kazlay: Sna a yu ta na mndu na wu kəʼa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","«Dər ŋa mtuta ɗa kawadaga nda kagha tsi, haɗ yu dzaʼa mnay kazlay: Sna a yu ta kagha wu kəʼa wu,» ka Piyer. Manda va tsaya ka inda sanlaha ma duhwalhani mnata guli. ");
INSERT INTO xed_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ma va tsaya, ka ɓhadaghatá i Yesu nda duhwalhani da sana vli ta hgə lu ka Getsemene. Kaʼa nda duhwalhani mantsa: «Nzawanza hadna ta labə yu da maga duʼa hada a,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka klanaʼata tsi i Piyer nda tsa zwana Zebedi his ya mistani. Ka tɗata ŋuɗufani ka ksay ka zləŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kaʼa nda həŋ tama mantsa: «Tɗatɗa ŋuɗufa ɗa manda skwi dzaʼa dzihata. Nzawanza hadna, ka nzata kuni ndiri kawadaga nda iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Zadaptani dawʼ ta kəma, ka zləmbatá tsi ka mbumba, ka maga duʼa. Kaʼa mantsa: «Da ɗa, ka ta magaku tsi, diʼiŋiŋdiʼiŋa ta na leghwa ghuya ɗaŋwa na nda iʼi. Nziya nza tsi ná, manda ya ta kumə iʼi a wu, manda ya ta kumə kagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ka sliʼafta tsi ka vradaghata slanaghatá duhwalhani, pslapsla hani ta həŋ. Kaʼa nda Piyer mantsa: «Trapta ghuni ta nzata ndiri kawadaga nda iʼi dər ka awa turtuk tsa ra? ");
INSERT INTO xed_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nzawanza ndiri ka ndəɓa kuni ta dzvu, kada ŋaŋta kuni ta skwi dzaʼa dzəghaghunata. Ta kumay kuni ta maga skwi ɗina mndani, ama haɗ mbrakwa sluʼuvgha ghuni wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka zəgladaptá tsi dawʼ ka mahis, ka ndəɓəgəltá dzvu, kaʼa mantsa: «Da ɗa, ka va a ka ta diʼiŋaghuta na leghwa ghuya ɗaŋwa na nda iʼi wu katsi, ka nda nza tsi ŋa say ɗa ná, ka maga tsi manda ya kumaŋ ka,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ka vrəglagaghatá tsi ka sləglanaghatá həŋ ta hani, nda ghərɓa həŋ da hani. ");
INSERT INTO xed_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka zləglaŋtá tsi ta həŋ ka zəgladapta dawʼ, ka ndəɓgəltá tsi ta dzvu ka ma hkən, ka vrəgliŋtá tsi ta va tsa gwaɗaha mna tsi ya. ");
INSERT INTO xed_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka vrəgladaghatá tsi da tsa duhwalhani ya, kaʼa nda həŋ mantsa: «Tata hana ghuni kuni ta mbiʼa vgha ghuni ɓa? Ɗaswa ka kuni tama tsa, wana nda maga fitik dzaʼa kəl lu ka vlata Zwaŋa mndu ma dzva gwal dmaku. ");
INSERT INTO xed_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sliʼafwasliʼa mbaɗma. Waʼa tsa mndu ta vlatá iʼi ŋa dzata ya ta sagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tata tsa gwaɗa ya i Yesu, nda ɓhakta Zudas ta nzakway tekw mataba duhwalha ghwaŋpɗə his ya. Kawadaga həŋ nda ndəghata mnduha nda kafay nda kafay, nda sarak nda sarak, ghunaf la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la galata mndu mataba mnduha. ");
INSERT INTO xed_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mnanafmna Yuda ta nzakway dzaʼa vlata ya kəʼa dzaʼa magay nda tsi, ta həŋ. «Tsa mndu dzaʼa yu brusata ya ná, ya vani tsaya, ka ksa kuni.» ");
INSERT INTO xed_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na gi ndusadaghatani tavata Yesu, kaʼa mantsa: «Zgu tsa ŋa gha Mghama ɗa,» kaʼa ka gi brusay. ");
INSERT INTO xed_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","«Gra ɗa, maga ta skwi sagha ka magay,» ka Yesu nda tsi. Ka gi sliʼadaghata tsa mnduha ya, ka pghaftá vgha tida ka ksafta. ");
INSERT INTO xed_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gi fay, tshagaptsha sani ma duhwalha Yesu ta kafayani, gi tay, tsaghuta sləməŋa sani ma kwalva mali ta ghəŋa gwal dra skwi ŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ka Yesu nda tsi mantsa: «Vradanamvra ta kafaya gha da kupakani. Inda gwal ta kla huzla vulu ná, tsa huzla vulu ya dzaʼa zaɗana ta həŋ guli. ");
INSERT INTO xed_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka kagha ta gray ná, laviŋ a yu ta hgaŋta Da ɗa, ŋa gi ghunigihatani ta bra sludza duhwalha Lazglafta ta malaghuta ghwaŋpɗə his ra? ");
INSERT INTO xed_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kinawu tama dzaʼa nzakwa dzata ghəŋa skwi ya nda vinda ma deftera Lazglafta ta mnay kazlay: Mantsa ya dzaʼa magakwa tsi kəʼa ya?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma va tsa fitik ya, ka Yesu nda tsa mnduha ya mantsa: «Nya ŋa sagha ghuni da ksa iʼi nda kafay nda kafay, nda sarak nda sarak, manda skwi ŋa ksa gənda na? Inda fitik yu ta nzaku kawadaga nda kaghuni ta tagha skwi ma həga Lazglafta, ksaf a kuni ta iʼi wa. ");
INSERT INTO xed_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kəl na skwiha na ka magaku ná, nda nza ŋa dzanaghata ghəŋa skwi ya vindaf la anabi ma deftera Lazglafta,» kaʼa. Ka gi hwayaghutá inda duhwalha Yesu krawats ka zlanavata. ");
INSERT INTO xed_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ka klaghatá tsa gwal ta ksafta ya ta Yesu da mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta nzakway ka Kayifa, ma vla tskatá vgha gwal tagha zlahu ŋa mnduha nda la galata mndu ya tani. ");
INSERT INTO xed_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mbaɗaka Piyer ka dzaʼa ta hulani ta hulani, ha ka lami da daɓa həga ga tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya. Ka nzamtá tsi mataba la kwalva ka nghay ka kinawu kɗavaktani. ");
INSERT INTO xed_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka zbə la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda inda gwal tsa guma, ta tsanavatá ghwaɗaka gwaɗa ta Yesu prək ka dzata. ");
INSERT INTO xed_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Triɗ, mutsaf a həŋ wa. Aŋ mndani, nda ndəgha tsakalawiha ya hladagha lu. Ma kɗavaktani, ka lagha sana mnduha his da mnay: ");
INSERT INTO xed_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ka na mndu na ná, laviŋlava yu ta tasiŋtá na həga Lazglafta na, ka bəgladafta ɗa baɗu mahkən, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka sliʼafta mali ta ghəŋa gwal dra skwi ŋa Lazglafta, kaʼa nda Yesu mantsa: «Zlgha a ka ta wani ra? Nu ta mnə na mnduha na ta kagha na na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pslaf a Yesu ta wani wa. Ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda tsi mantsa: «Nda həga Lazglafta nda hafu mida, ta ɗawa yu da kagha, zlghiɗifzlgha ta wani. Kagha Kristi ta nzakway ka Zwaŋa Lazglafta ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka Yesu nda tsi mantsa: «Manda va ya mna kagha nda wa gha. Ka yu ta sgaghunaghata ta ghəŋani ná, daga ndanana, dzaʼa nda ngha kuni ta Zwaŋa mndu ta nzaku nda ga zeghwa Lazglafta ta mbruta, dzaʼa nda ngha kuni ta sahani ma kusay ta luwa guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lagha tsa mali ta ghəŋa gwal dra skwi ya ka kuhiŋtá lgut ta vghani. Kaʼa mantsa: «Ya wana kwara ta kwarakwara ta ghəŋa Lazglafta. Mndəra wati gwaɗa ya ta psəgəlta mu, ya wana nda sna sləməŋa ghuni ta kwarakwara ya kwara tsi na? ");
INSERT INTO xed_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kinawu ka kaghuni ta gray na?» kaʼa. «Nda ra ka dzata na mndu na,» ka həŋ hlafta wi. ");
INSERT INTO xed_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ka gi tafə həŋ ta sərɗək ma kuma ŋa Yesu, ka dəŋəzl sanlaha, ta dgharu ya laha. ");
INSERT INTO xed_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Ka si Kristi ka ná, tsatsaftsatsa ka waya ta dza kagha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma tsa fitik ya, ta nzaku Piyer ma bli ma daɓa tsa həga ya. Ka lagha sana kwalva ka marakw slanaghata. «Kagha guli ná, si ka kawadaga kagha nda tsa Yesu mnda la Galili ya,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Əŋ, yaʼ! «Sna a yu ta skwi ta kumə ka ta mnay wu,» kaʼa ta kəma mnduha demdem. ");
INSERT INTO xed_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tahula tsa, ka sliʼafta tsi ka nzata ma dzuguva watgha. Ka nghaŋtá sana kwalva ka marakw guli. «Si ka kawadaga na mndu na nda Yesu mnda la Nazaret,» kaʼa nda tsa gwal hada ya. ");
INSERT INTO xed_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Əŋ, yaʼ! «Sna a yu ta tsa mndu ya wu,» kaʼa ka waɗgəlta. ");
INSERT INTO xed_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓats nzɗa, ka gavanavatá tsa gwal ma tsa vli ya ta Piyer, ka həŋ nda tsi mantsa: «Dər ki tsi, tekw kagha mataba tsa mnduha ya, ta tsatsaku ta lwa gha,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","«Kusekw!» ka Piyer ka waɗay. «Ka ksiʼafksiʼa Lazglafta ta iʼi ka tsakalawa ɗa tsi. Sna a yu ta na mndu na wu,» kaʼa. Gi ka wahatá vazak. ");
INSERT INTO xed_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ka gi havaktá Piyer ka gwaɗa ya si mnana Yesu kazlay: Ma kɗaku vazak wahata ná, dzaʼa mnay ka hkən səla kazlay: Sna a yu ta tsa mndu ya wu kəʼa ya. Ka gi sliʼafta tsi ka laghwi dzibil ka hərɓa taw. ");
INSERT INTO xed_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tsaɗakwa vli gasərɗək, ka tskavata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la galata mndu, ka dzraftá gwaɗa ta ghəŋa Yesu, ŋa dzata. ");
INSERT INTO xed_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ka habaftá həŋ, ka klaghatá həŋ vlaŋtá Pilat ta nzakway ka ŋumna. ");
INSERT INTO xed_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nghay tsa Zudas ta vlatá Yesu ya, ta tsanaghatá guma ŋa dzata ná, ka hagə tsi ta madər. Ka klaftá tsi ta tsa suley hkən mbsak ya, ka lagha vranavatá tsa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la galata mndu ya. ");
INSERT INTO xed_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Gaga yu ta dmaku ta vlatá mndu kul haɗ dmakwani ŋa dzata,» kaʼa nda həŋ. «Nu gwaɗa aŋni! Dzik nda kagha tsaya,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka pghidiŋtá Yuda ta tsa tsedi ya ma həga Lazglafta, ka laghwi hamtá ketsiŋ ma ŋurzluŋani, ka dzuvtá htsiŋani. ");
INSERT INTO xed_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka hlafta la mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta tsa tsedi ya. «Ra a ka gwafta na tsedi na nda tsedi ma vla tskatá skwa Lazglafta wu, kabga tseda nasa ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ka dzraftá həŋ, ka laghwi skwatá vwaha sana mnda tsa huzla nda tsi, ŋa la mbla la matbay. ");
INSERT INTO xed_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tsaya tama ta kəl lu ka hga tsa vwah ya ka «vwaha nasa» kulam gitana. ");
INSERT INTO xed_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tsaya dzatá ghəŋa skwi ya mna anabi Irmiya kazlay: Ka klaftá həŋ ta tsa suley hkən mbsak ya, tsa mbsaka tsedi kura la Israʼila ta planata ya, ");
INSERT INTO xed_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ka vlatá həŋ ŋa skwatá vwaha sana mnda tsa huzla, mantsa ya mniɗifta Mgham Lazglafta kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ka kladaghatá lu ta Yesu ta kəma Pilat ta nzakway ka ŋumna. «Kagha na mghama la Yahuda na ra?» ka ŋumna ɗawaŋta da tsi. «Manda va tsa mna ka ya,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama, ta ghəŋa hamata tsakalawa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu ya ná, zlgha a ta wani wa. ");
INSERT INTO xed_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","«Sna a kagha ta inda na skwi ta gwaɗə həŋ ta kagha na ra?» ka Pilat nda tsi. ");
INSERT INTO xed_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama mbəɗanagha a Yesu dər teʼ ta inda tsa ɗaway ta ɗaw tsi ya wa. Ka ndərmim ŋumna Pilat katakata. ");
INSERT INTO xed_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Inda fitika skala Pak ya, ta snusna ŋumna ta zligiŋtá mndu turtuk ma gamak. Mndu ya ɗawaŋ mnduha da tsi ta zliŋta tsi. ");
INSERT INTO xed_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma tsa fitik ya, mamu sana mnda dmaku snaŋ lu ksamə lu da gamak, Barabas hgani. ");
INSERT INTO xed_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nghay Pilat ta tsa tskata mnduha ya, kaʼa nda həŋ mantsa: «Wati ta kumə kuni ta zlighunista ɗa na? Barabas re, ari Yesu ta hgə lu ka Kristi ya a na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nda sna Pilat kazlay: Ka draku vlata həŋ ta Yesu kəʼa ya kay. ");
INSERT INTO xed_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta nzaku Pilat ma vla tsa guma tama, ka ghunafta markwa taŋ ta mndu ŋa mnanata kazlay: Ma famə ka ta ghəŋa gha ma gwaɗa ta na mndu kul haɗ dmakwani na. Ya ghuyə ghuya yu ta ɗaŋwa katakata ta ghəŋa na mndu na ma suna ɗa ta na rviɗik gita u na kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lagha la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu, ka liŋtá bara mnduha ŋa ɗaway taŋ ta sliŋtá Barabas, ta dzatá lu ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","«Wati mataba na mnduha his na ta kumə kuni ta zlighunista ɗa na?» ka Pilat nda həŋ. «Barabas! Barabas! Barabas!» ka həŋ hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","«Nu dzaʼa yu magay ŋa Yesu ta hgə lu ka Kristi na tama?» ka Pilat ɗawaŋta da həŋ. «Zləŋafta ta udzu! Zləŋafta ta udzu! Zləŋafta ta udzu!» ka həŋ hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","«Nahgani va skwi maga tsi?» ka ŋumna nda həŋ. «Zləŋafta ta udzu! Zləŋafta ta udzu! Zləŋafta ta udzu!» ka həŋ hlaftá wi nda mbraku. ");
INSERT INTO xed_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nghay Pilat ná, zlramta a mataba taŋ wu, ta sgaku nda sga sliʼavafta ŋuɗufa mnduha, ka taʼatá tsi ta imi, «wya dzva ɗa, wya dzva ɗa,» kəʼa mbaziŋtá dzvani ta kəma mnduha. «Sabsa dzva ɗa ta ghəŋa gwaɗa ta na mndu na, dzik nda kaghuni tsa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","«Ka la usani ta ghəŋa aŋni nda zwana ŋni tani!» ka həŋ hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lagha Pilat ka zlinistá Barabas ta həŋ. Tahula slvaptani ta Yesu nda krupi, ka vlatá tsi ŋa zləŋafta ta udzu. ");
INSERT INTO xed_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ka kladamtá la sludza ŋumna Pilatu ta Yesu da daɓi ma huɗa həga, ka hagadaghata həŋ ta inda la sludzi demdem ka tskanaghatá ghəŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ka suɗatá həŋ. Ka suɗanavatá həŋ ta lguta dva ma mgham mgham. ");
INSERT INTO xed_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ka ɗaftá həŋ ta zewazewa teki, ka fanamta ma ghəŋ, fanamha həŋ ta dafa ma dzva zeghwi. Ka lagha həŋ da tsəlɓu ta kəmani ka gagay. «Zgu tsa ŋa gha mghama la Yahuda,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ka tafa sərɗək tida, ka klaghutá tsa dafa da tsi ya, ka dzay nda tsi ma ghəŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Manda kɗakwa taŋ ta gagay, ka suɗaghutá həŋ ta tsa lguta ma mgham mgham ya, ka suɗglanavatá tsa ŋani ma lgut ya. Ka klə həŋ ŋa dzaʼa zləŋafta ta udza zləŋay. ");
INSERT INTO xed_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta sap həŋ ma huɗa luwa, ka guyatá həŋ nda sana mnda la Sireŋ, ta hgə lu ka Simuŋ. Ka mblanaftá həŋ ta kla udza zləŋa Yesu. ");
INSERT INTO xed_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Manda ɓhadaghata taŋ da vli ta hgə lu ka Gwalgwata, manda mnay kazlay: Vla ghudzifa ghəŋ kəʼa ya, ");
INSERT INTO xed_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ka vlaŋtá həŋ ta ima inabi nda skwi ya ɗah ɗaha. Tapanata Yesu ná, ka kwalaghutá tsi ta say. ");
INSERT INTO xed_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tahula zləŋafta taŋ, ka vzə həŋ ta vindima, ŋa daguvustá lguthani. ");
INSERT INTO xed_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tahula tsa, ka nzatá həŋ ka nghay. ");
INSERT INTO xed_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ŋa maraŋtá skwi kəl lu ka tsanaghatá guma, wya ká lu vindafta nda ta ghəŋani: «Nana mndu na Yesu, Mghama la Yahuda, ka lu.» ");
INSERT INTO xed_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ka zlaŋaftá lu ta gəndaha his kawadaga nda tsi. Pal nda ga zeghwani, pal nda ga zlaɓani. ");
INSERT INTO xed_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ka rarazə gwal ta mbaɗa ta tvi ka kəktsa ghəŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Kagha dzaʼa tasiŋtá həga Lazglafta ka bəgladafta gha ma fitik hkən ná, mbanafmba ta ghəŋa gha tama ɓa, ka si Zwaŋa Lazglafta ka. Sasa gha ta na udza zləŋay na tama ɓa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ka gagə la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, nda la galata mndu guli, ka həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Mbanafha ta sanlaha ná, triɗ trapta ma mbanafta ghəŋani. Ka si mghama la Israʼila tsi ya ní, ka sasa tsi ta na udza zləŋay na kada grafta mu. ");
INSERT INTO xed_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Faffa yu ta ghəŋa ɗa ta Lazglafta, kaʼa. Ka mbanafmba Lazglafta ndana tama, ka si ta ɗvay tsi. “Iʼi ná, Zwaŋa Lazglafta yu,” a katsi kay ra,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ka rarazə tsa gəndaha zlaŋaf lu kawadaga nda tsi ya manda va tsaya guli. ");
INSERT INTO xed_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Zlrafta ta fitik ɗək ma ghəŋ ha ka laha ta nzemndi hkən ta fitik hawu, ka nutá vli tɗik ka grum ta ghəŋa haɗik demdem. ");
INSERT INTO xed_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lagha vli ta nzemndi hkən tama, ka wahatá Yesu nda lwi dagala. «Eluwa! Eluwa! Lama sabaktani,» manda mnay kazlay: «Da ɗa! Da ɗa! kabgawu kəl ka ka zliɗivata na?» kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","«Wya ta haga Iliya,» ka tsa gwal ta snay hada ya. ");
INSERT INTO xed_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ka gi hwayaftá sana mndu turtuk mataba taŋ, ka laghwi klaftá susu, ka tsumamta ma imi masmasa, ka hbuŋta ta wa udzu, ka vlay ŋani ŋa sayni. ");
INSERT INTO xed_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","«Zlaŋzla ka ngha mu, ka dzaʼa saghasa tsa Iliya ya da mbanafta,» ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka wahglatá Yesu nda lwi dagala, ka sap hafu mida. ");
INSERT INTO xed_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma va tsa fitik ya, ka gi tavaptá zlala ma həga Lazglafta his, daga ta ghəŋ dikw ta mndər, ka gigɗavaftá haɗik, ka tatavaptá palaha, ");
INSERT INTO xed_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ka gwanutá wa kuluha, ka sliʼagaptá ndəghata mnduha Lazglafta si ta rwuta, nda hafu. ");
INSERT INTO xed_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tahula sliʼagapta Yesu, sliʼagapta hahəŋ ma kulu, ka laghu həŋ da luwa Ursalima ta nzakway ka luwa nda ghuɓa. Nda ndəgha mnduha ta nghaŋta həŋ hada. ");
INSERT INTO xed_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nghay mghama sludza la Ruma nda sanlaha ma sludzi kawadaga nda tsi ta ngha Yesu ta tsa gigɗavafta haɗik, nda tsa skwi ta magaku ya ná, ka ksutá zləŋ ta həŋ katakata. «Kahwathwata ná, Zwaŋa Lazglafta na mndu na,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hada guli ná, nda ndəgha miʼaha ta nzakta diʼiŋ ka nghay. Tsaw daga ma luwa Galili sliʼafta həŋ mista Yesu ŋa maganata slna. ");
INSERT INTO xed_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mataba tsa miʼaha ya, hada Mari makwata Magdala, nda Mari mani ma i Yakubu nda Yusufu, nda mani ma zwana Zebedi. ");
INSERT INTO xed_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Laha fitik hawu, ka sagha sana mnda luwa la Arimate ta hgə lu ka Yusufu. Tsa mndu ya ná, gadghəl ya, duhwala Yesu ya guli. ");
INSERT INTO xed_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ka lagha tsi da Pilat da ɗawaftá mbla Yesu. Ka vlatá Pilat ta tvi ŋa vlaŋta. ");
INSERT INTO xed_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ka klaftá Yusufu ta tsa mbli ya, ka mbsamta ma wupaya ŋusliŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ka klaftá tsi ka laghwi da famta ma kulu ta ka lfiɗ, si lap tsi ma kluluh ŋa ghəŋani. Ka taŋwaluŋtá tsi ta mghama klam ta wa tsa kulu ya. Ka sliʼaftá tsi, ka laghwi. ");
INSERT INTO xed_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka nzaktá i Mari makwa ta Magdala nda tsa sana Mari ya mbəŋ nda tsa kulu ya. ");
INSERT INTO xed_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gamahtsimani, tahula fitika paya skwi ŋa baɗu Sabat, ka sliʼaftá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta kawadaga nda la Farisa, ka laghu slanaghatá Pilat. ");
INSERT INTO xed_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ka həŋ nda tsi mantsa: «Mghama ɗa, mamu sana skwi havagagha ŋni. Ka tsəna mnda tsakalawi na mnata ta ma nzakwani ta ndiri ná, “tahula fitik hkən dzaʼa sliʼagapsliʼa yu nda hafu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tsaya tama ná, mnanamna ta la sludzi ka dzaʼa həŋ ngha tsa kulani ya, ha baɗu mahkəna fitik, da lagha duhwalhani da ghalaghata mblani, da mnə həŋ ŋa mnduha kazlay: Wa a sliʼagapsliʼa ma mtaku, kəʼa. Ya dzaʼa malaghumala tsa tsakalawi ma kɗavaktani ya katakata ka tsa taŋtaŋ ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","«Ya mamu sludziha, hlawa həŋ ka dzaʼa kuni da nghay, manda ya ta kumə kuni,» ka Pilat. ");
INSERT INTO xed_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ka laghu həŋ da vla tsa kulu ya, ka ŋərzlaftá həŋ ta tsa klam ya, ka pghatá həŋ ta la sludzi ŋa nghay. ");
INSERT INTO xed_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tahula luta Sabat, wurək tgha baɗu Dəmas, ka sliʼafta i Mari makwa ta Magdala nda tsa sana Mari ya ka laghu ta kulu. ");
INSERT INTO xed_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gi ka gigɗavaftá haɗik katakata. Ka saha duhwala Lazglafta daga ta luwa, ka taŋwalaghutá tsa klam ya, ka nzafta tida. ");
INSERT INTO xed_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ta wuɗaku manda wuɗa luwa. Ka ŋusliŋ lgutani tilil manda papla. ");
INSERT INTO xed_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka ghudzaku tsa sludziha ta ngha tsa kulu ya da zləŋ. Ka zlambutá həŋ manda gwal nda rwa. ");
INSERT INTO xed_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka tsa duhwala Lazglafta ya nda tsa miʼaha ya mantsa: «Kaghuni, ma zləŋ kaghuni ta zləŋ. Nda sna yu kazlay: Tsa Yesu si zləŋaf lu ta udzu ya ta zbə kuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ta haɗ hadna wa, sliʼagapsliʼa ma mtaku manda va ya si mna tsi. Sawa nghanatá vli si hanana lu ɓa. ");
INSERT INTO xed_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ka dzaʼa kuni misimmisim da mnanatá duhwalhani kazlay: Sliʼagapsliʼa Yesu ma kulu, waʼa ta kzla kaghuni ma luwa Galili kəʼa. Hada dzaʼa gmakwa kuni nda tsi. Tsaya skwi mnaghuna yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka gi sliʼafta tsa miʼaha ya ta kulu nda zləŋ nda zləŋ, nda rfu nda rfu guli, ka laghu nda hwaya nda hwaya mnay ŋa duhwalha Yesu. ");
INSERT INTO xed_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka gi lagha Yesu da guyaku nda həŋ. «Zguwa tsa!» kaʼa nda həŋ. Ka gavadaghatá tsa miʼaha ya tavatani, ka ŋaŋanatá səlahani, ka tsəlɓu ta kəmani. ");
INSERT INTO xed_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka Yesu nda həŋ mantsa: «Ma zləŋ kuni ta zləŋ! Lawala da mnanata zwanama ɗa, ka dzaʼa həŋ da luwa Galili, hada dzaʼa gmakwa ŋni nda həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tata tvi tsa miʼaha ya, ta sliʼamtá sanlaha ma tsa gwal si ta ngha kulu ya da luwa, ka laghu da rusay ŋa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta inda skwi ta maguta. ");
INSERT INTO xed_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ka tskavatá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu, ka dzraftá həŋ ta klafta tsedi ɗəmblək ka vlaŋtá tsa la sludzi ya. ");
INSERT INTO xed_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ka həŋ nda həŋ mantsa: «“Duhwalhani ta sagha ghalaghata girviɗik ta hani aŋni ná, kiɓa” ka kuni dzaʼazlay, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka snanaghasna tsa gwaɗa ya ta ŋumna ya, dzaʼa nda sna aŋni ta skwi ŋa mnanata, haɗ sana skwi dzaʼa ksaghunata wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ka zlghaftá tsa la sludzi ya ta tsa tsedi ya, ka laghwi magata manda ya mnanaf lu ta həŋ. Ka tutá tsa gwaɗa ya mataba la Yahuda, ta mnə həŋ ha gita. ");
INSERT INTO xed_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka sliʼafta tsa duhwalha Yesu ghwaŋpɗə ndeŋ ya ka laghwi da luwa Galili ta ghwá ya mnanaf Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na gi nghay taŋ ta Yesu, ka tsəlɓatá həŋ ta kəmani. Ama ta dga ghəŋ sanlaha. ");
INSERT INTO xed_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka gavadaghatá Yesu, kaʼa nda həŋ mantsa: «Inda mbraku ta luwa nda ya ta haɗik tani ná, vlihavla lu. ");
INSERT INTO xed_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lawala ta ghəŋa haɗik demdem, ka nanafta kuni ta mnduha ka duhwalha ɗa, ka maganafta kuni ta batem ta həŋ ma hga Da, ma hga Zwaŋ, nda ya ma hga Sulkum nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ka taghanafta kuni ta həŋ ta snatá inda skwiha ya mnaghunaf yu. Ya wana yu kawadaga nda kaghuni ha kɗavakta ghəŋa haɗik,» kaʼa.");
INSERT INTO xed_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Zlrafta Lfiɗa Gwaɗa ta ghəŋa Yesu Kristi Zwaŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nda nza manda ya nda vinda ta ghəŋani ma deftera anabi Isaya kazlay: Iʼi Lazglafta, wana yu ta tiŋlaghutá ghunaftá mndu ka kagha karaku, ŋa dzaʼa faɗaghatá tvi. ");
INSERT INTO xed_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lwa tsa mndu ya ta snu lu ta hagaku ma mtak kazlay: Payanawa paya ta tvi ŋa Mgham ka leleʼanata kuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mantsa tama, ka zlagaptá Yuhwana, mnda maga Batem ma mtak, kaʼa mantsa: «Mbəɗanafwa mbəɗa ta nzakwa ghuni, ka magaghunafta lu ta batem, ka plighunista Lazglafta ta dmakuha ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka sliʼaktá inda gwal ma luwa Ursalima, nduk nda inda hamata gwal ta haɗika Zudiya, ka lagha slanaghatá Yuhwana. Ka manigiŋtá həŋ ta dmakuha taŋ, ka maganaftá Yuhwana ta batem ta həŋ ma imi ma ghwa ta hgu lu ka Zurdeŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tsa Yuhwana ya ná, gatá swida ŋalibwa ta kəl tsi ta vgha nda hbatá ɓanava huta misti. Hiʼi nda zuɗuma mtak skwa zayni. ");
INSERT INTO xed_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wya kəʼa ta mnay guli: «Mamu sana mndu ta sagha nda hula ɗa, mal ŋani mbraku ka ŋa ɗa, slaf a iʼi ɗekɗek dər ŋa ɓukwadata ka plaptá zuʼa ɓaɓah ma səlani wa. ");
INSERT INTO xed_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iʼi ná, magaghunaftá batem nda imi ŋa ɗa. Tsatsi, nda Sulkum nda ghuɓa dzaʼa magaghunafta tsi.» ");
INSERT INTO xed_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma tsa fitik ya, ka sliʼaftá Yesu ma luwa Nazaret ta haɗika Galili ka lagha slanaghatá Yuhwana. Ka maganaftá Yuhwana ta batem ta Yesu ma ghwa Zurdeŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta sabə Yesu ma imi manda kɗaku ta maganaftá, ka nghadaftá tsi ta luwa, gi ka nghaŋtá tsi ta gunatá luwa buwaŋ, ka saha Sulkum nda ghuɓa manda ghərbuʼ ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka gi snaku lwa Lazglafta daga ta luwa kazlay: «Kagha zwaŋa ɗa ta ɗvu yu, ma hyahya ŋuɗufa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tahula tsa, ka gi tiŋwaghatá Sulkum nda ghuɓa ta Yesu da mtak. ");
INSERT INTO xed_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ka zatá tsi ta fitik fwaɗ mbsak hada ta dzəghaydzəghay halaway. Ma tsa mtak ya, mataba nimtak ta nzakwa tsi, ta katay katay duhwalha Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ma sana fitik, ka ksaghatá lu ta Yuhwana tsamta ma gamak, ka sliʼaftá Yesu ka laghwi ta haɗika Galili da mna Lfiɗa Gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kaʼa ta mnay mantsa: «Nda maga fitik, ndusa ga mghama Lazglafta, mbəɗanafwa nzakwa ghuni, ka zlghafta kuni ta Lfiɗa Gwaɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ta labə tsi nda ta wa drəfa Galili, ka nghaŋtá tsi ta i Simuŋ nda zwaŋamani Andre ta wɗa kadəŋa taŋ da drəf ŋa tuma klipi, kabga tuma klipi slna taŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka Yesu nda həŋ mantsa: «Saghawasa, mbaɗwa mista ɗa, dzaʼa naghunafna yu ka gwal hlaktá mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Gi sɗak zlanavazla həŋ ta kadəŋa taŋ, ka laghu mistani. ");
INSERT INTO xed_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Manda zadapta taŋ dawʼ, ka lagha həŋ slanaghatá zwana Zebedi, i Yakubu nda zwaŋamani Yuhwana ta paya kadəŋa taŋ guli ma kwambalu. ");
INSERT INTO xed_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ka hgaftá tsi ta həŋ, «mbaɗwa mista ɗa,» kaʼa. Ka gi sliʼaftá tsahaya guli ka laghwi mistani, ka zlanavatá da taŋ Zebedi ma kwambalu kawadaga nda gwal ksanatá slna ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tahula tsa, ka ɓhadaghatá həŋ da luwa Kafarnahum. Na gi sagha sabat, ka lamə Yesu da həga tagha skwa la Yahuda, ka taghə tsi ta skwi ŋa mnduha ma tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ka ndərmim həŋ nda ndərmima ta tsa tagha skwani ya, kabga nda sgit ma tsa ŋani tagha skwi ya. Nza a manda ŋa gwal tagha zlaha Musa ŋa mnduha wa. ");
INSERT INTO xed_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka gi zlagaptá sana mndu ksu ghwaɗaka sulkum mataba taŋ ta lami da tsa həga tagha skwa taŋ ya. Ka sliʼaftá tsi nda lili, kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Yesu zwaŋa la Nazaret, nu gwaɗa gha nda aŋni, sagha ka da zaɗa aŋni? Wya nda sna ŋni kazlay: Mndu nda ghuɓa daga da Lazglafta kagha kəʼa na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","«Haf wa gha! Sabsa ma na mndu na,» ka Yesu dvanaghata. ");
INSERT INTO xed_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lagha tsa ghwaɗaka sulkuma ya ka ghudzanaftá tsa mndu ya katakata, ka lilatá tsi, ka saghu tsi mida. ");
INSERT INTO xed_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka tsutá ŋuɗufa mnduha demdem ma tsa vli ya, ha ka ɗaɗawu həŋ mataba taŋ, ka həŋ mantsa: «Nu mndərga nana ma skwi? Aa! lfiɗa skwi ta zlagaptá mndərga nana! Na dvanaghatani ta dər halaway tsi ná, ta snanasna həŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ka tutá gwaɗa ta ghəŋa Yesu wdiɗ ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tahula sliʼagabta taŋ ma tsa həga tagha skwa la Yahuda ya, ka gwaghatá həŋ ta vgha nda i Yakubu nda Yuhwana da i Simuŋ nda Andre. ");
INSERT INTO xed_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tata lamə nda la həŋ da həga, ka gi mnə lu ŋa Yesu ta gwaɗa ta midza Simuŋ ta hani ta ɓasa ŋuɗidar. ");
INSERT INTO xed_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka gavadaghatá Yesu tavatani ka ŋanata ta dzvu, ka sliʼanafta. Na tsa gi sliʼanaftani ya, gi kwandlaŋ mbatani tsa. Ka sliʼaftá tsa marakw ya maganatá skwa zay ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tahula dəɗata fitik baɗu va tsaya, ka hladaghatá lu ta inda gwal kul ɗughwanaku da Yesu, kulam nda gwal ta tsuta ka halaway tani. ");
INSERT INTO xed_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ka tskavatá inda mnduha ma luwa ŋərɓisl ta watgha tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ka mbambanaftá Yesu ta ndəghata mnduha ma ɗaŋwaha taŋ kavghakavgha, ghazligiŋha ta ndəghata duhwalha halaway guli ma mnduha. Vlaŋ a ta tvi ta tsa duhwalha halaway ya ŋa gwaɗa guli wu, kabga nda sna hahəŋ guli ta nzakwa Yesu. ");
INSERT INTO xed_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na tsaɗakwa vli ta tsughbura sərɗək, ka sliʼaftá Yesu, ka laghwi da mtak. Ka ndəɓu tsi ta dzvu hada. ");
INSERT INTO xed_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ka sliʼaftá i Simuŋ nda sanlaha ma mnduha ka laghwi da naghay. ");
INSERT INTO xed_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka naghə həŋ, ka slaftá həŋ tida. «Ta paha kagha inda mnduha,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","«Mbaɗma da sana vliha ndusa ndusa, ka dzaʼa yu mnanaŋtá gwaɗa Lazglafta ta tsahaya guli, kabga tsaya kəl yu ka sagha,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ka laghu tsi da mna gwaɗa Lazglafta ma həgaha tagha skwa la Yahuda ta inda haɗika Galili, ghazligiŋha ta duhwalha halaway ma mnduha. ");
INSERT INTO xed_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma sana fitik, ka lagha sana mndu nda rɗa mndu tida tsəlɓata ta kəma Yesu. Kaʼa mantsa: «Nda zɗakatahuɗa gha, laviŋlava ka ta mbiɗifta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ka ksaŋtá tsi ta Yesu ka hiɗahiɗa. Ka kapaŋtá tsi ta dzvani ka ksaŋta. «Ta kumay yu, mbafmba gha,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gi hadahada, hlets mbatani tsa, kləwəɗ vghani. ");
INSERT INTO xed_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","«La tama,» ka Yesu vriŋta. ");
INSERT INTO xed_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kaʼa nda tsi guli mantsa: «Yahayaha ka da walaŋta mnanaŋtá mndu, ka dzaʼa ka da maranaŋtá vgha gha ta mnda dra skwi ŋa Lazglafta. Ka plata ka ta ghəŋ manda ya vindaf Musa, ŋa maraŋtá ghuɓatá kagha, ka da grafta mnduha ta mbatá kagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama ka sliʼaftá tsatsi, ka laghwi tay ma luwa, ka tutá tsi wdiɗ. Kabga tsa, ka pyaftá tsa gwaɗa ya ta Yesu ka lamə da luwa baŋluwa. Ama ka nzaghutá tsi ta wa mazawa. Kulam nda tsa, ka sliʼadaghatá mnduha dər ndiga ndiga da slanaghata hada. ");
INSERT INTO xed_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tsɓakw fitik tahula tsa, ka sliʼaftá Yesu ka vradaghata da luwa Kafarnahum. Manda snaŋta lu kazlay: Vragaghavra Yesu dzagha kəʼa, ");
INSERT INTO xed_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ka sliʼadaghatá mnduha ŋərɓisl ndaghaganaptá vli nduk ta daɓitgha, haɗ vli ŋa nzaku wu, ta mna Lfiɗa Gwaɗa Yesu ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka tsukwadanaghatá mnduha fwaɗ mataba mnduha ta sliʼadaghata da tsi ta sana mndu nda rwa səlani. ");
INSERT INTO xed_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Zbay taŋ ta tvi ŋa ɓhanavatá Yesu ná, triɗ mutsaf a həŋ wa. Ka ŋladaftá həŋ ta ghəŋa tsa dzuguvi nzamə Yesu mida ya. Ka gunaptá həŋ ta ghəŋani, ka hbaftá həŋ ta tsa mndu ya ta tsa skwa hanani ya ka fadatá həŋ nda ta tsa ghurum ya. ");
INSERT INTO xed_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nghanata Yesu ta tsa zlghay nda ŋuɗufa taŋ ya ná, «nda pla dmakwa gha sagəŋ,» kaʼa nda tsa mndu nda rwa səlani ya. ");
INSERT INTO xed_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta nzaku sanlaha ma gwal tagha zlaha Musa ŋa mnduha ma tsa vli ya, ka həŋ ma ghəŋa taŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Nu ta kəl na mndu na ka kwarakwara mandana na! Wa ta laviŋtá pla dmakwa mndu ta ghəŋa Lazglafta turtukwani na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Snaŋta Yesu ta tsa skwi ta mnə həŋ ma ghəŋa taŋ ya nda ma sulkuma vghani, kaʼa nda həŋ mantsa: «Nu ta kəl kuni ka ndanu mandana na? ");
INSERT INTO xed_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta grə kuni ná, mal blakwa mnay ŋa na mndu nda rwa səlani na kazlay: Nda pla dmakwa gha kəʼa re, ari mal blakwa mnay ŋani kazlay: Sliʼafsliʼa, kla ta skwa hana gha ka sliʼa ka kəʼa na? ");
INSERT INTO xed_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ndana tama, kada snaŋta kuni kazlay: Mamu Zwaŋa mndu nda mbrakwa pliŋtá dmakwa mndu ta ghəŋa haɗik kəʼa ná, wya tsi: ");
INSERT INTO xed_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ka iʼi ta mnaghata gra wa, “Sliʼafsliʼa, kla ta skwa hana gha, la dzagha gha,”» kaʼa nda tsa mndu nda rwa səlani ya. ");
INSERT INTO xed_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gi brahwat kəʼa sliʼafta, zləŋal klaftá skwa hanani, ka sabə tsi nzərem ta nghay inda mnduha. Ka ndərmim həŋ nda ndərmima, ka zləzlvu həŋ ta Lazglafta. Ka həŋ mantsa: «Ka yawu ka yawu, ta maga a skwi manda na wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tahula tsa ka sliʼaftá Yesu ka vrəglaghata nda ta wa drəfa Galili. Ka sliʼadaghatá mnduha dlivis slanaghata hada, ka taghə tsi ta skwi ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tata gra mbaɗa Yesu, ka nghaŋtá tsi ta Levi mnda tska dzumna, ta nzakway ka zwaŋa Alfe, ta nzaku ta watgha həga ksa slnani. «Mbaɗa mista ɗa,» kaʼa nda tsi. Ka sliʼafta Levi ka laghwi mistani. ");
INSERT INTO xed_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tahula tsa, ka tskavatá i Yesu nda duhwalhani kawadaga nda gwal tska dzumna, nda sanlaha ma ghwaɗaka mnduha, kabga nda ndəgha mndərga tsa mnduha ya ta dzaʼa mistani tazlay. Ka tskavatá həŋ ka za skwi ma həga ga Levi. ");
INSERT INTO xed_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kəʼa, ká gwal tagha zlaha Musa ŋa mnduha ta nzakway mataba la Farisa ná, ta za skwi Yesu kawadaga nda gwal tska dzumna nda sanlaha ma tsa ghwaɗaka mnduha ya. Ka həŋ nda duhwalha Yesu mantsa: «Kabgawu ta kəl Mghama ghuni ka za skwi kawadaga nda na mnduha na ɓa?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Slrew, lamla tsa gwaɗa ya da sləməŋa Yesu. Kaʼa mantsa: «Gwal kul ɗughwanaku yeya ta psa duhtur, psa a gwal ɗughwana wa. Sagha da psa gwal dmaku iʼi, sagha a yu da psa gwal ta mnay kazlay: Tuɗukwa aŋni kəʼa wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tata suma i duhwalha Yuhwana nda la Farisa ma sana fitik guli, ka sliʼaktá mnduha ɗawaŋta da Yesu. Ka həŋ mantsa: «Ya wya ta suma i duhwalha Yuhwana nda la Farisa ní, kabgawu ta kwal ŋa gha ma duhwalha suma ka na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ka Yesu nda həŋ mantsa: «Ka ta kawadaga graha zwaŋa midzi nda tsa zwaŋa midzi ya katsi ná, ta sumay həŋ ta suma ra? Ka ta kawadaga həŋ katsi ná, haɗ həŋ ta suma wa. ");
INSERT INTO xed_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dzaʼa saghasa fitik, ŋa klaghutá zwaŋa midzi. Baɗu tsaya tama, dzaʼa sumay həŋ ta suma. ");
INSERT INTO xed_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mantsa guli, haɗ lu ta tsaktá lfiɗa gərzaŋ, ka tsamtá halata lgut nda tsi wa. Ka mantsa tsi katsi ná, dzaʼa kɗiŋkɗa tsa lfiɗa gərzaŋ ya ta mɗukiŋtá tsa halata lgut ya. ");
INSERT INTO xed_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Haɗ lu ta ɗihamtá ima inabi ta ka nuni ma halata zliba huta guli wa, ba ma lfiɗani ta ɗihamta lu. Kabga tawaftani dzaʼazlay ná, dzaʼa zlukigiŋzlukwa ta tsa halata huta ya, ŋa tiŋtani. Ŋa nzakwani lpay lu ma ya, lpay lu ma ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Baɗu sana sabat ta labla i Yesu nda duhwalhani ta tvi ma vwaha nimaya, ka ɓalaʼatá tsa duhwalhani ya ta tsa nimaya ya. ");
INSERT INTO xed_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka la Farisa nda Yesu mantsa: «Ngha ɓa gra ta skwi, kabgawu ta kəl duhwalha gha ka maga skwi pyaf lu ta magay baɗu sabat na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka Yesu nda həŋ mantsa: «Ta dzaŋaf a kuni ta skwi maga Dawuda ma fitika kuzlanafta maya ta həŋ nda gwal kawadaga nda tsi tani ra? ");
INSERT INTO xed_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ma fitika nzakwa Abiyatar ka mali ta ghəŋa inda gwal ta dra skwi ŋa Lazglafta ná, ka lamə tsi da həga Lazglafta, ka zutá skwa zay ya fana lu ta Lazglafta pɗar tsi ta skwi ŋa zaŋta, tsatsanafha guli ta gwal kawadaga nda tsi. Tsa skwa zay ya ná, haɗ hamata mndu ta zay wa, ba tsa gwal ta dra skwi yeya kweŋkweŋ ta zay, ama ka zutá Dawuda tsatsanafha ta grahani guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ka Yesu nda həŋ guli mantsa: «Kabga ŋa kata mndu fata lu ta sabat, fa a lu ta mndu ŋa sabat wa. ");
INSERT INTO xed_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tsaya kəl Zwaŋa mndu ka nzaku ka mgham ta ghəŋa sabat,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mbaɗaka Yesu ka ləglami da həga tagha skwa la Yahuda, ka slaftá tsi ta sana mndu nda mta dzvani ta nzaku hada. ");
INSERT INTO xed_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka dzaʼa mbanafər mbanaf a tsi ta na mndu na baɗu sabat, ká mnduha nzata ka ngha Yesu tiritiri, kabga ŋa mutsaftá rutsak tida. ");
INSERT INTO xed_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","«Sliʼafsliʼa gra, ka sagha ka sladata ta kəma mnduha,» ka Yesu nda tsa mndu nda mta dzvani ya. ");
INSERT INTO xed_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kaʼa nda həŋ tama mantsa: «Nu skwi nda ra ŋa magay baɗu sabat na? Maga skwi ɗina re, ari maga ghwaɗaka skwi a na? Mbanaftá mndu skwi ta raku re, ari dzatá mnda a skwi ta raku?» kaʼa nda həŋ. Tsitsriɗ, ka həŋ nzata. ");
INSERT INTO xed_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka kuzlanaftá tsi ta Yesu ta ŋuɗuf manda waftani ta həŋ, kabga tsa təŋa ta ghəŋa taŋ ya. Huf safi ta ŋuɗufa Yesu, «tɗaptɗa ta dzva gha gra,» kaʼa nda tsa mndu nda mta dzvani ya. Ka tɗapta tsi ta dzvani, gi kundliŋ mbatani tsa. ");
INSERT INTO xed_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ka gazlagabtá la Farisa dzibil, gi ka laghwi həŋ dzrəku kawadaga nda mnduha mghama Hiridus ŋa zba tva dzatá Yesu. ");
INSERT INTO xed_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ka sliʼaptá i Yesu nda duhwalhani mataba taŋ, ka laghwi ta wa drəfa Galili. Snaŋta mnduha ta tsa skwi ta magə Yesu ya, ka sliʼakta həŋ daga ta haɗika Galili, nda ya ma Zudiya, ");
INSERT INTO xed_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nda pɗakwa gwal ta haɗika Ursalima, nda gwal ta haɗika Idume, nda gwal ta ɓla ghwa Zurdeŋ, nda gwal ta waftá luwa Tir nda Siduŋ tani. ");
INSERT INTO xed_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ka mnanatá Yesu ta duhwalhani ŋa payanatá kwambalu, kabga yaha mnduha da ɓisla iʼi kəʼa, ");
INSERT INTO xed_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","kabga nda ndəgha mnduha mbambanaf tsi, kəl inda gwal ɗaŋwa ka sliʼadaghata. ");
INSERT INTO xed_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ghur ka gwal kasaf ghwaɗaka sulkum ta həŋ ngha Yesu guli ná, ka sliʼadaghatá həŋ da tsəlɓu ma ghuvani ka wahu. «Kagha Zwaŋa Lazglafta!» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka davanaghatá Yesu ta həŋ ka ŋɗaŋɗa. «Ma mnaŋ kuni ta iʼi» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tahula tsa, ka sliʼaftá Yesu ka laghwi ta kuɗuŋur. Ka hagaʼatá tsi ta gwal kumaŋ tsi, ka sliʼadaghatá həŋ slanaghata. ");
INSERT INTO xed_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka ɗagaʼatá tsi ta gwal ghwaŋpɗə his ŋa nzaku tavatani, ŋa ghunayni guli ta həŋ mna Ggwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Vlaŋha ta mbrakwa ghazligiŋtá duhwalha halaway ma mnduha ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wya hga tsa gwal ghwaŋpɗə his ɗagab tsi ya: Simuŋ tsanaf tsi ta hgani ka Piyer, ");
INSERT INTO xed_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nda i Yakubu nda zwaŋamani Yuhwana ta nzakway ka zwana Zebedi, Bwarneges kəʼa tsanaftá hga taŋ, manda mnay kazlay: Zwana ŋəzla luwa kəʼa ya, ");
INSERT INTO xed_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nda Andre, Filip, Bartelemi, Mata, Tuma, Yakubu zwaŋa Alfe, Tade, Simuŋ mnda la Kananit, ");
INSERT INTO xed_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nda Zudas Iskaryut. Tsa Zudas ya ta skwaptá Yesu. ");
INSERT INTO xed_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tahula tsa, ka sliʼaftá həŋ ka laghwi dzagha. Ka sliʼigəldaghatá mnduha dlivis slanaghatá həŋ, ha ka trapta i Yesu nda duhwalhani ta mutsaftá fitik ŋa zaŋtá skwa zay. ");
INSERT INTO xed_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Snaŋta la taŋ ma Yesu ta skwi ta mnə lu kazlay: Nda hwaɗa ghunislakani kəʼa ya, ka sagha həŋ da klay. ");
INSERT INTO xed_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka gwal tagha zlaha Musa ŋa mnduha ta sliʼakta ma luwa Ursalima ta mnay guli mantsa: «Nda ksa na mndu na da Belzebul, kabga nda mbrakwa halaway ta ghazligiŋta tsi ta duhwalha halaway ma mnduha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ka hagaftá Yesu ta həŋ ka mnay ŋa taŋ nda mahdihdi. Kaʼa nda həŋ mantsa: «Waka halaway dzaʼa ghzligiŋtá halaway na? ");
INSERT INTO xed_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ka tavaptá luwa turtuk ná, dzaʼa nzakway tsa luwa ya tɗukwa ra? ");
INSERT INTO xed_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ka dgavapdga həga mndu his ná, ta dzaʼa nzəglanza tsa həga ya ra? ");
INSERT INTO xed_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ka kuranavatá ghəŋani halaway katsi ná, nda dga his nda tsa tama, sladglata a nda tsa tama guli wu, kɗavakta ŋani tsa. ");
INSERT INTO xed_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ka ta habaf a mndu ta mndu nda mbra wu katsi ná, laviŋta a ta lami da həga ga taŋ ka hlugudunustá huzlani wa. ");
INSERT INTO xed_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kahwathwata ka yu ta mnaghunata: Inda dmakuha dzaʼa magata mnduha, dzaʼa plinispla Lazglafta ta həŋ nda inda rarazuha dzaʼa həŋ rarazay tani. ");
INSERT INTO xed_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama inda mndu dzaʼa razanaftá Sulkum nda ghuɓa, plinista a lu ta dmakwani ɗekɗek wa. Dzaʼa nzakway dmakwani ta ghəŋani ŋa kɗekedzeŋ,» kaʼa nda həŋ, ");
INSERT INTO xed_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","kabga «nda ghwaɗaka sulkum ma vghani,» ka həŋ ta mnay ta Yesu, kəl Yesu ka mna tsa gwaɗa ya ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tahula tsa, ka ɓhadaghatá i mani nda zwanamani ma Yesu, ka sladaghuta ma bli. Ka ghunadamtá həŋ ta mndu da həga ŋa hgagaptá Yesu. ");
INSERT INTO xed_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tizlik tskatá mnduha tavata Yesu ta lagha lu da mnay ŋani kazlay: Waʼa i ma gha nda zwanama gha ta hga kagha ma bli kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","«I wa ma ɗa nda zwanama ɗa na?» kaʼa zlghaftá wani. ");
INSERT INTO xed_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka nghadaptá tsi ka tsa mnduha ta nzaku ta wanafta ya, kaʼa mantsa: «Wana i ma ɗa nda zwanama ɗa, ");
INSERT INTO xed_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","kabga inda mndu ta maga skwi manda ya ta kumə Lazglafta, tsaya zwaŋama ɗa, tsaya mukuma ɗa, tsaya ma ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma sana fitik, ka nzəglatá Yesu ka tagha skwi ŋa mnduha ta wa drəfa Galili. Ka tskadaghatá mnduha ta vgha ŋərɓisl tavatani, kəl tsi ka laghwi nzagapta ma kwambalu ta wa tsa drəf ya, ta nzatá inda tsa mnduha ya rpaʼ ta wani. ");
INSERT INTO xed_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ka taghə tsi ta ndəghata skwi ŋa taŋ nda mahdihdi. Wya kaʼa nda həŋ ma tsa tagha skwani ya: ");
INSERT INTO xed_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Snawa ka mnaghunata yu ɓa! Mbaɗaka sana mndu ka sliʼaftá ka laghwi da wutsa hulfa ma vwahani. ");
INSERT INTO xed_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tata wutsaywutsay mantsa, ka rkatá sanlaha ta tvi ka sliʼadaghatá ɗyakha da ɗaguta. ");
INSERT INTO xed_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka rkatá sanlaha ta kluluh ma vli kul slaghutá haɗik, ka gi ɗyaftá tsi misimmisim kabga sira a haɗik ta ghəŋani wa. ");
INSERT INTO xed_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na safa fitik dzafta tida, ka zlghutá tsi həw ka ghwaluta, kabga slaghu a slrəŋ mistani wa. ");
INSERT INTO xed_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma teki sanlaha, ka glanaghatá teki ka raghwanata pghaf a ta ghəŋ wa. ");
INSERT INTO xed_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta gənək sanlaha, ka ɗayafta tsahaya, ka galafta, ka pghaftá ghəŋ ka zwaŋ dzeʼdzeʼ. Miɗiɗa ghəŋa sanlaha, selela ghəŋa sanlaha, ɓərzləzla ghəŋa sanlaha. ");
INSERT INTO xed_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mndu nda sləməŋa snay, ka sna tsi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Manda dgaghuta i Yesu nda duhwalhani kawadaga nda sanlaha ma mnduha ta vgha, ka ɗawaŋtá həŋ ta ghəŋa tsa mahdihdi ya da tsi. ");
INSERT INTO xed_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","«Kaghuni, vlaghunavla lu ta snaŋtá ɗifa ta gwaɗa ta ghəŋa ga mghama Lazglafta, ama ŋa sanlaha ná, ba nda mahdihdi dzaʼa mnanaŋta lu ta həŋ, ");
INSERT INTO xed_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kabga ŋa nghay taŋ, nghaŋta a həŋ wa. Ŋa snay taŋ, snaŋta a həŋ ɗekɗek wa. Ka má nda sna həŋ katsi ná, má dzaʼa mbəɗakmbəɗa həŋ ta vgha da Lazglafta ŋa plinistani ta dmakuha taŋ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tahula tsa, kaʼa nda həŋ guli mantsa: «Sna a kuni ta tsa mahdihdi ya ra? Ka sna a kuni ta tsaya wu katsi ná, wa ka kuni dzaʼa snaŋtá inda mahdihdi tama? ");
INSERT INTO xed_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tsa hulfa ta wutsə tsa mndu mnə yu ya ná, gwaɗa Lazglafta ya ta wutsə tsi. ");
INSERT INTO xed_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sanlaha ma mnduha ná, manda tvi rkaf hulfa tida nzakwa taŋ. Na gi snaŋta taŋ ta gwaɗa Lazglafta ma ŋuɗufa taŋ, ndadaghata halaway hlugudunustá həŋ, manda ɗagay ta ɗaguta ɗyak ta hulfa ta tvi. ");
INSERT INTO xed_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sanlaha ma mnduha guli ná, manda kluluh wutsaf lu ta hulfa tida həŋ. Ka snaŋsna həŋ ta gwaɗa Lazglafta gi misimmisim ka həŋ ta tsuʼafta nda rfu, ");
INSERT INTO xed_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ama haɗ həŋ ta zlaŋtá vli ŋa dzugwamta tsa gwaɗa ya ta slrəŋ ma ŋuɗufa taŋ wa. Ka gruŋgra ghuya ɗaŋwa nda giri ta həŋ kabga tsa gwaɗa ya katsi, gi suwak zlanavata taŋ ta zlghay nda ŋuɗufa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sanlaha ma mnduha guli ná, manda vli ma teki rkam hulfa mida həŋ. Snaŋsna həŋ ta gwaɗa Lazglafta ");
INSERT INTO xed_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama ta laghula həŋ da ndana nzaku ma ghəŋa haɗik, nda ndana zba gadghəl, nda ndana sana skwiha ta haraʼuwa iri. Mantsa tama, mbaɗa tsa skwiha ya ka raghwa tsa gwaɗa ya, ka niŋtá həŋ ka ksubaŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sanlaha ma mnduha ná, manda haɗik ka gənək həŋ. Ta snaŋsna həŋ ta gwaɗa Lazglafta, ta zlghafzlgha həŋ nda ŋuɗufa taŋ, ta magay həŋ ta skwi ta kumə Lazglafta. Sanlaha ma tsa mnduha ya ná, kiʼa kiʼa magata həŋ, ka gratani magata sanlaha, Sanlaha ma mnduha guli ná, va ŋulum ŋulum magatá ŋa taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ka Yesu nda həŋ guli: «Ta klafkla lu ta pitirla ŋa dzuɓamta ma tughuba ra? Ari ta klafkla a lu ŋa fiŋta mista ghzləŋ na? Ta klafta ŋa fafta ta vəl tskala lu kasiʼi kiʼe. ");
INSERT INTO xed_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Haɗ skwi nda ɗifa dzaʼa kwal kul sabi ta daɓi wa. Haɗ skwi kɗekkɗek dzaʼa kwal kul maravata baŋluwa guli wa. ");
INSERT INTO xed_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mndu nda sləməŋa snay ka sna tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kaʼa nda həŋ guli: «Ɗaswa ka kuni nda skwi ta snaŋta kuni. Nda tsa daram ta kəl kuni ka gra skwi ya, nda tsi guli dzaʼa graghunafta Lazglafta ta ŋa ghuni, ŋa sgaghunaghatá ŋa ghuni guli. ");
INSERT INTO xed_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tsaya tama, mndu ta fata sləməŋani ɗina ka sna gwaɗa ná, dzaʼa sganaghasga Lazglafta ta snaŋtani. Ama mndu ta dərzlaftá sləməŋani ná, dzaʼa sganaghasga ta dərzlanafta guli,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kaʼa nda həŋ guli: «Ka gragra nda hulfa ta pghamta mndu da haɗik ya ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dər ta hanə ta hanani tsa mndu ya girviɗik, dər ta vaghə ta nzakwani tsi gifitik, ta ɗyutá ɗyakwani, ka glakwani hulfa sna a kəʼa ta magaku wa. ");
INSERT INTO xed_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Haɗik ta ɗygiŋtá hulfa ŋa nzakwani ka kuzuŋ. Tahula tsa, ŋa pghaftani ta ghəŋ ŋa ksayni ta zwaŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ka nda ndəha tsi vərzləŋ tama, nda maga fitik ŋa tsay, sagha fitika kla vɗu ŋa tsay tsa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wya kaʼa nda həŋ guli: «Ndaw dzaʼa gra mu ta ga mghama Lazglafta, nda wati ma skwi dzaʼa grafta mu? ");
INSERT INTO xed_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tsa ga mghama Lazglafta ya ná, dzaʼa gray lu nda hya kramasa. Tsa hya kramasa ya ná, ndərzikw nzakwani mataba hulfaha ta ghəŋa haɗik, ama ka sləgam sləga lu, ");
INSERT INTO xed_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ta glafgla gdiz ka malaghutá hamata sluhwaha niɗali. Ta pghay ta sləma dagala ha ka laviŋta ɗyakha ta baba həga taŋ tida,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nda ndəghata mndərga tsa mahdihdiha ya mnanaŋta tsi ta gwaɗa ta həŋ prək ka snaŋta taŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Inda ŋani ma gwaɗa nda həŋ ná, ba nda mahdihdi. Ama nzata taŋ nda ghəŋa taŋ nda duhwalhani ya ná, tsislanaptani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gahawu baɗu va tsa, «mbaɗma ta a ɓlu a,» ka Yesu nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ka sliʼafta həŋ ka zlanavatá tskata mnduha, ka lamə həŋ da tsa kwambalu nzamə Yesu mida ya ka laghwi, kawadaga nda sanlaha ma kwambalu guli mistani. ");
INSERT INTO xed_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tata ndrə həŋ ma kwambalu, ka sliʼafta mghama mativirauʼ, ka kapatsaʼuwaku imi ka lami ka kuma ndəghanafta kwambalu. ");
INSERT INTO xed_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta hanani Yesu ma mndəra kwambalu, nda fatá ghəŋani ta skwa fa ghəŋ. Ka sliʼanaftá həŋ. «Mghama ɗa! Ndana a kagha ta na zwaɗuta dzaʼa zwaɗuta mu na ra?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sliʼavatani mantsa, ka dvanaghatá tsi ta falak. «Lɓalɓa ka nzata ka tɓekw!» kaʼa nda drəf. Ka lɓatá falak, ka nzatá vli tɓekw. ");
INSERT INTO xed_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ka mbəɗavatá tsi tvə duhwalhani. Kaʼa nda heŋ mantsa: «Nu ta kəl kuni ka zləŋ mandana na, kulam ndana, haɗ zlghay nda ŋuɗuf da kaghuni ɗekɗek katək ra?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka ksaftá zləŋ ta həŋ katakata. «Wa va na ma mndu katək na? Nduk nda falak nda drəf tani ta snanatá gwaɗa!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Manda laba taŋ ta tsa sana ɓla drəfa Galili ta haɗika Geraseni ya, ");
INSERT INTO xed_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","tata sabə nda sa Yesu ma kwambalu, ka gi ndadaghatá sana mndu ksu halaway, ta sabi mataba kuluha da guyay. ");
INSERT INTO xed_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mataba kuluha si ta nzakwa tsa mndu ya. Haɗ mndu ta laviŋtá ksafta ŋa habafta dər nda ziɗa wu, ");
INSERT INTO xed_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","kabga si ta tsamtsa lu ma tsuhwal, habawuha lu ta dzvuhani nda ziɗa, ama ta ratsiŋ ratsa tsatsi ta tsa ziɗaha ya, ta ɓaliŋ ɓala ta tsa tsuhwalha ya. Haɗ mndu ta laviŋtá zlahafta wa. ");
INSERT INTO xed_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Inda fitik ta vaghə nda vagha, ta hanə nda hana ta wawaku mataba kuluha nda ya ta ghwá, ka lili ka kwaha vghani nda pala. ");
INSERT INTO xed_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na tsa Nghaŋtani ta Yesu manda a ya ná, ka hwayaftá tsi ka lagha tsəlɓata ta kəmani, ");
INSERT INTO xed_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ka wahu nda lwi dagala. «Yesu Zwaŋa Lazglafta ta luwa: Nya mataba ɗa nda kagha na? Ta ndəɓa dzvu yu da kagha nda həga Lazglafta, ma ghuyɗip ka ta ɗaŋwa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kəl tsi ka mna tsaya ná, kabga mnanamna Yesu kazlay: Ghwaɗaka sulkum! Sabsa ma na mndu na kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ka ɗawaŋtá tsi da tsi. «Wa hga gha na?» kaʼa nda tsi. «Dəɓaʼ» hga ɗa, kabga nda tska ŋni. ");
INSERT INTO xed_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kdəkkdək, ma ghzliŋnis ka ma luwa, kaʼa ndiʼata ka ŋɗaŋɗa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsaw ma tsa vli ya, mamu bra ghuvazuha ta zbu ta skwa zay taŋ tavata ghwá. ");
INSERT INTO xed_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka tsa ghwaɗaka sulkum ya mantsa: «Kdəkkdək, ghuna ta aŋni da a ghuvazuha a, ka sliʼamta ŋni da həŋ,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","«Lawala!» Kaʼa nda həŋ. Ka sliʼagaptá həŋ ka sliʼamta da tsa ghuvazuha ya. Ka vazagatá tsa ghuvazuha ya ta vgha tavata tsa ghwá ya ka rkaghata da drəf. Ta magay mbsaka taŋ ta dəmbuʼ his ta zaɗamta ma tsa drəf ya. ");
INSERT INTO xed_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na tsa gwal si ta ngha tsa ghuvazuha ya, ka sliʼafta həŋ nda hwaya ka laghu mnay ma luwa nduk tahula luwa. Ka sliʼadaghatá mnduha da ngha tsa skwi ta maguta ya. ");
INSERT INTO xed_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Manda sliʼadaghata taŋ tavata Yesu, ka nghaŋtá həŋ ta tsa mndu si sliʼamə ghwaɗaka sulkumha dida ya ta nzakwani kwandlaŋ nda suɗatá lgut ta vgha. Ka ghudzaku tsa mnduha ya da zləŋ. ");
INSERT INTO xed_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka rusu tsa gwal si hada ya ta skwi ta maguta nda tsa mndu si ksu halaway ya, nda skwi ta maguta nda tsa ghuvazuha ya, ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tahula tsa, «kdəkkdək, sliʼapsliʼa ma haɗika ŋni,» ka həŋ nda Yesu. ");
INSERT INTO xed_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ta dzaʼa dzaʼa Yesu da kwambalu tama, «wya dzvu, ka la yu mista gha,» ka tsa mndu si ksu halaway ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama ka Yesu nda tsi mantsa: «La dzagha gha, ka dzaʼa ka slanaghatá la ga ghuni. Ka rusanafta ka ta inda skwi maga gha Mgham Lazglafta, nda ya kəʼa tawatá hiɗahiɗa ta kagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ka sliʼafta tsi ka laghwi da manay ma kuraghuta haɗika Dekapwalus ta inda skwi magana Yesu. Ka ndərmim inda taŋ nda ndərmima. ");
INSERT INTO xed_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Manda vradaghata Yesu nda kwambalu ka lagha ta sana ɓla drəf, ka sliʼadaghatá mnduha ŋərɓisl slanaghata hada. Ta sladu Yesu ta wa tsa drəf ya. ");
INSERT INTO xed_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ka lagha sana mndu tekw mataba maliha ma həga tagha skwa la Yahuda slanaghata. Zayrus hga tsa mndu ya. Na gi nghaŋtani ta Yesu, ka gi zləmbatá tsi ma ghuvani. ");
INSERT INTO xed_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ka ŋavatá tsi ka ndəɓa dzvu da tsi, kaʼa mantsa: «Wa a makwa ɗa ta kala ghəŋ ta dzaʼa mtaku. Kdəkkdək, sawi ksaŋta nda dzvu ka mbafta tsi, ka nzakwa tsi nda hafu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka sliʼaftá Yesu ka dzaʼa kawadaga nda tsi. Mbaɗa mnduha ka sliʼi rutututa mistani, ka ɓislay. ");
INSERT INTO xed_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mamu sana marakw mataba taŋ ta maga vaku ghwaŋpɗə his ta paghaku. ");
INSERT INTO xed_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ghuyghuya tsa marakw ya ta ɗaŋwa katakata ta dzaʼa da takay da duhturha. Zaɗiŋzaɗa ta inda skwihani demdem, nduk nda tsa, haɗ lavaghwani wu, tata sgaku nda sga tsa ɗaŋwani ya. ");
INSERT INTO xed_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na snaŋta tsa marakw ya ka lu ta gwaɗa ta Yesu, ka kɗikadamtá tsi mataba mnduha, ka lagha ksaŋtá lguta Yesu nda ga mahulhul, ");
INSERT INTO xed_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kabga wya kaʼa ma ghəŋani: «Tsa ksaŋ yu ta dər lgutani taɗa ná, dzaʼa mbaku yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na tsa gi ksaŋtani ya, gi tərsiuʼ lɓata tsa paghakwani ya tsa. Ta snu tsi ma vghani ná, wdər nda mba. ");
INSERT INTO xed_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gi ta snə Yesu ma ŋani ma vgha guli ná, mamu mbraku ta savaghuta. Ka sladata tsi, ka mbəɗavata mataba tskata mnduha. Kaʼa mantsa: «Wa na mndu ta ksaŋtá lgutha ɗa na na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka duhwalhani nda tsi mantsa: «Nda ngha ka ta tskatá mnduha ta ɓisla kagha ná, wa ta ksihata na» ka ka? ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka nanaghaku tsi ka zba tsa mndu ta ksaŋta ya. ");
INSERT INTO xed_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na tsa marakw ya, ka ghudzaku da zləŋ, kabga nda sna ta skwi maga tsi. Ka zləmbatá tsi ma ghuva Yesu, ka mnanaŋtá kahwathwata. ");
INSERT INTO xed_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka Yesu nda tsi mantsa: «Nda mba ka makwa ɗa, kabga zlghafta gha ta iʼi nda ŋuɗufa gha. La nda vgha ta zɗaku, ka nzata ka kwandəlaŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tata gwaɗa Yesu, ka sagha gwal ga Zayrus da mnay ŋa Zayrus kazlay: Kɗakwa tsa makwa gha ya tsa, ŋa daŋwazlgəlta gha ŋaw ta mgham na? ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Klaf a Yesu ta tsa gwaɗa taŋ ya ka gwaɗa wa. «Ma zləŋ ka, fafta kagha ta ghəŋa gha ta iʼi kweŋkweŋ ŋa gha,» kaʼa nda Zayrus. ");
INSERT INTO xed_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ka sliʼaftá tsi ka dzaʼa. Ka pyanatá tsi ta mnduha ta dzaʼa mistani, ka hganaʼatá tsi ta i Piyer nda Yakubu nda Yuhwana zwaŋamani ma Yakubu ŋa dzaʼa mistani. ");
INSERT INTO xed_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ka ɓhadaghatá həŋ da tsa Zayrus mali ma həga tagha skwa la Yahuda ya. Ka slanaghatá Yesu ta mnduha ta kitsiwiraku, ta wawahaku, ta dzadza lubaluba. ");
INSERT INTO xed_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ka lamə tsi da həga. «Kabgawu ta kəl kuni ka hlawi, ta kəl kuni ka taw? Ya wana ta mta a zwaŋ wu, hani ta hani tsi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka ghuɓasu həŋ ta Yesu. Lagha Yesu ka ghzlagaptá inda mndu ma həga. Ka hganaʼatá tsi ta i dani nda mani ma tsa zwaŋ ya, nda tsa gwal lagha həŋ kawadaga ya, ka lamə həŋ da tsa dzuguvi nda zwaŋ mida ya. ");
INSERT INTO xed_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ka ŋanatá tsi ta dzvu, kaʼa mantsa: «Talitakum,» kaʼa. Manda mnay kazlay: Makwa ɗa, sliʼafsliʼa, iʼi ya ta gwaɗa nda kagha kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gi hləbəts ka tsa makwa ya sliʼafta ka gi mbaɗa. Aʼ, ghwaŋpɗə his ima tsa makwa ya. Ka nzata həŋ ndandrakawa ka ndərmimay. ");
INSERT INTO xed_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mbaɗaka Yesu ka zlahanaghatá həŋ ka ŋɗaŋɗa kazlay: Yahayaha kuni da mnay dər ŋa wa tsi, kaʼa. Kaʼa nda həŋ guli mantsa: «Vlaŋwa skwa zay ta na makwa na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ka sliʼaftá Yesu ka zlaŋtá tsa vli ya ka laghu da luwa ta glakwani. Ka laghu duhwalhani mistani. ");
INSERT INTO xed_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Baɗu sabat, ka lamə Yesu da tagha skwi ŋa mnduha ma həga tagha skwa la Yahuda. Káka nda ndəghata mnduha hada ta sna tsa skwi ta taghə tsi ya. Ka ndərmim həŋ nda ndərmima: «Wa ta taghanaftá mndərga nana ma skwi? Wa ta vlaŋtá mndərga nana ma ɗifil ta kəl tsi ka maga nana ma mazəmzəmha na? ");
INSERT INTO xed_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tsa mnda fiɗi ta nzakway ka zwaŋa Mari ya a na mndu na kay ra? Zwaŋamani ma i Yakubu nda Yuses, nda Yuda, nda Simuŋ a tsi kay ra? Mataba mu a kwagha mani kay guli ra?» ka həŋ. Ka nzaku Yesu ka skwa tuthun da həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka Yesu nda həŋ tama mantsa: «Ta vlay lu ta glaku ŋa anabi ma sana vliha, ama ma luwani, nda ya mataba la taŋ nduk nda ya ma həga ga taŋ ná, haɗ lu ta vla glaku ŋani wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tsaya kəl Yesu ka kwal kul magaŋtá mazəmzəm hada. Ka laghu tsi ksaŋta nda dzvu ta sanlaha ma mnduha kul ɗughwanaku, ka mbambanaftá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ka ndərmim Yesu nda ndərmima ta tsa kwala taŋ kul zlghaftá tsatsi nda ŋuɗuf ya. Tahula tsa, ka sliʼaftá Yesu ka laghwi da ra zwana luwa ta hula Nazaret. Ka tatagha skwi ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka hagaftá tsi ta duhwalhani ghwaŋpɗə his ŋa ghwanaftani ta həŋ his his his da luwaha. Ka valaŋtá tsi ta mbraku ta həŋ ŋa ghazligiŋtá ghwaɗaka sulkum. ");
INSERT INTO xed_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ka zlahanaghatá tsi ta həŋ kaʼa mantsa: «Ta sliʼi kuni ya, dafa kweŋkweŋ dzaʼa kuni klafta ma dzva ghuni, yaha kuni klaftá skwa zay, nda dər zliba ghuva, yaha kuni klaftá tsedi ma zlibi. ");
INSERT INTO xed_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yaha kuni klaftá mahisa lgut. ");
INSERT INTO xed_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ka lamla kuni da luwa katsi, ka nzata kuni ga mndu ya ta tsuʼaftá kaghuni, ha ka sagha fitik dzaʼa kəl kuni ka sliʼafta ma tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ka mamu gwal ma sana vli dzaʼa kwal kul tsuʼafta kaghuni ta kwalaghutá sna gwaɗa ghuni katsi, ka sliʼapta kuni ma tsa vli ya, ka tukwiŋta kuni ta rgitika tsa luwa ya ta səla ghuni. Tsaya dzaʼa maraŋtá nzakwa dmakwa taŋ ta ghəŋa taŋ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ka sliʼaftá həŋ ka laghwi da mnay ŋa mnduha, ka həŋ mantsa: «Mbəɗanafwa mbəɗa ta nzakwa ghuni, ka mnigiŋta kuni ta dmakwa ghuni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ka ghazligiŋtá həŋ ta ghwaɗaka sulkum ma mnduha, mbambanafha həŋ ta ndəghata gwal kul ɗughwanaku nda masanavata rɗi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mantsa, ka snanaghatá tsa gwaɗa ta gwaɗə lu ta Yesu ya ta mgham Hiridus, kabga laghula hgani da zərwa. Ka lu ta mnay tida na: «Tsa Yuhwana mnda maga batem ya kay ya ta sliʼagabta ma mtaku, tsa ta kəl tsi ka maga mazəmzəmha,» ka lu. ");
INSERT INTO xed_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","«Iliya ya tane,» ka həŋ. «Sana anabi ta gara vgha nda sani mataba anabiha ghalya ya,» ka sanlaha nda ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama manda kɗakwa Hiridus ta snaŋta tsahaya: «Tsa Yuhwana tsaghu yu ta ghəŋani ya kay ya ta sliʼagabta nda hafu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kəl Hiridus ka mnata ksaftá Yuhwana ná, kabga gwaɗa ta Hiridiya ta nzakway ka markwa zwaŋamani Filip klu tsi ka marakw, ");
INSERT INTO xed_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","si kəl Yuhwana ka mnay ŋa Hiridus kazlay: Ra a ka klay gha ta markwa zwaŋama gha wu, kaʼa nda tsi. Kəl Hiridus ka ghunaftá sludzani ksaftá Yuhwana ka tsamta ma ziɗa. ");
INSERT INTO xed_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tifin ɓasanava ɓasa Hiridiya ta ŋuɗuf ta Yuhwana kabga tsa gwaɗa ya, ka zbə tsi ta tvi ŋa dzata ama triɗ traptra ta tvani. ");
INSERT INTO xed_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vərɗa dər Hiridus ná, ta zləŋay ta Yuhwana. Nda sna guli kazlay: Mndu nda ghuɓa Yuhwana, ŋərma mndu ya kəʼa ka katə tsi. Inda nzata Hiridus ka sna gwaɗa ta gwaɗə Yuhwana ya ná, ta dəwir nda dwira ta ghəŋani dər má ɗvafɗva tsi ta snay. ");
INSERT INTO xed_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma sana fitik tama, ka mutsafta tsa Hiridiya ya ta tvi ŋa dzatá Yuhwana. Tsa fitik ya ná, baɗu fata Hiridus ta skala havakta fitika yakwani ya. Baɗu tsaya, ka hagaftá Hiridus ta mnduha. Tsa mnduha hagaf tsi ya, gwal dagaladagala ta wanafta, nda mghamha ta ghəŋa sludziha, nda gwal klu lu ta haɗika Galili ya. ");
INSERT INTO xed_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Baɗu va tsaya tama, ka lamə makwa tsa Hiridiya ya ka skalu ta kəma tsa mnduha ta tskavata ya. Ka zɗanaftá tsa skalani ya ta ŋuɗufa Hiridus nda tsa gwal hagaf tsi ya tani. Ka Hiridus nda tsa makwa ya mantsa: «Ka nu dzaʼa kumafta maya gha ya, ɗawiha ɗawa dzaʼa vlaghavla yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ka waɗanatá tsi. Kaʼa mantsa: «Skwi ya dzaʼa ɗawaŋta kagha da iʼi ná, dzaʼa vlaghavla yu, dər má slɓahwa luwa ɗa tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka ndagaptá tsa makwa ya ka laghwi mnay ŋa mani. Tahula mnanatani, ka ɗawu tsi da mani. Kaʼa mantsa: «Nu dzaʼa yu ɗaway tama?» kaʼa. Ka mani zlghaftá wani mantsa: «Ɗawa ta ghəŋa Yuhwana mnda maga batem,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ka gi vrəglaghutá tsi slanaghatá mgham ka ɗaway da tsi: «Ta kumay yu ta vlihata gha ndana ndana ta kwambleh ta ghəŋa Yuhwana mnda maga batem,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Suʼanak ká mgham nzata. Lavgliŋ a ta sɗanafta wu, kabga nda ghada waɗanatani ta kəma tsa gwal hagaf tsi ya. ");
INSERT INTO xed_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ka gi ghunaftá tsi ta sludzi turtuk mataba gwal ta nghay kaʼa nda tsi mantsa: «La ka tsagaghata ka ta ghəŋa Yuhwana mnda maga batem,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ka sliʼaftá tsa sludzi ya ka laghwi da gamak, ka tsagaghatá ghəŋa Yuhwana mnda maga batem ta kwembleh. ");
INSERT INTO xed_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Manda snaŋta duhwalha Yuhwana ta tsa skwi ya, ka lagha həŋ klaghata mblani ka laghwi paɗamta. ");
INSERT INTO xed_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mbaɗa tsa duhwalha si ghwanagha Yesu ya ka varakta. Ka tskavatá həŋ tavata Yesu, ka rusa skwi si maga həŋ, nda skwi ya si ta taghə həŋ ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ka Yesu nda həŋ mantsa: «Mbaɗma ta wa mazawa, ka nzata kuni ka hlaptá hafu hada,» kaʼa. Haɗ fitika taŋ ŋa mutsaftá dər zaŋta dər skwa zay wu, kabga ndəghata mnduha ta zazavaɗaku katakata hada. ");
INSERT INTO xed_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ka sliʼaftá hahəŋ hahəŋ ka dzaʼa ma kwambalu da sana vli ta wa mazawa. ");
INSERT INTO xed_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta sliʼi həŋ, nda ndəgha mnduha ta nghiŋtá həŋ, ka tsəmaftá həŋ. Ka gazlatá inda mnduha ma luwa, ka dzaʼa nda səla da tsa vli ta dzaʼa i Yesu nda duhwalhani ya, ka tiŋlaghutá həŋ ta ɓhadaghata, kabga ta hway nda hwaya hahəŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Manda ɓhadaghata Yesu, ka sabə tsi ma kwambalu. Kəʼa kəʼa ná, tizlik tskata mnduha, ka ksaŋtá həŋ katakata ta Yesu ka hiɗahiɗa, kabga nda nza həŋ manda tuwakha kul haɗ mnda ngha həŋ, ka gi nzatá tsi ka tagha skwiha ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Manda ya nda ghada laghwa fitik, ka lagha duhwalhani mnay ŋani. Ka həŋ mantsa: «Wana ma mtak lu hadna, laghula fitik guli, ");
INSERT INTO xed_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mnanamna ta na mnduha na, ka sliʼa həŋ da luwa, nda ya da zwana luwaha ta wafta na vli na, ka dzaʼa həŋ skwa skwiha ŋa zay taŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ama ka Yesu nda həŋ mantsa: «Vlaŋwavla kaghuni ɓa ta skwa zay ta həŋ,» kaʼa. Ama ka həŋ nda tsi mantsa: «Ŋa sliʼa ŋni da dzawaktá buradi prək ka tseda vagha mnduha his dərmək ta maga slna, ka valaŋtá həŋ ŋa zay taŋ rki?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kaʼa nda həŋ mantsa: «Kidaghi buradi da kaghuni na? Naghawa nagha» kaʼa. Naghanata taŋ, ka həŋ mantsa: «Buradi hutaf nda tsulhwa klipi his ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ka Yesu nda duhwalhani mantsa: «Mnanawamna ta mnduha ka nzanzata həŋ ka ghuɓu ka ghuɓu ta kuzuŋwa mkwenek,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka tsakavatá mnduha, ka nzanzata dərmək dərmək ma ya vli, hutaf mbsak hutaf mbsak ma ya vli. ");
INSERT INTO xed_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka hlaftá Yesu ta tsa buradi hutaf, nda tsulhwa klipi his ya. Ka nghadaftá tsi nda ta luwa ka rfanaghatá Lazglafta. Tahula tsa mantsa, ka ɓalanaptá tsi ta tsa buradi ya, ka valaŋtá duhwalhani, ŋa daganaftá tsa mnduha ya. Mantsa guli, ka daganaftá tsi ta tsa tsulhwa klipi his ya ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Inda taŋ demdem ka zazutá həŋ, ka babaghawtá həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka tskaftá lu ta paɗakwa tsa buradiha nda klipiha ya ka ghwanak ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gwal ta za tsa buradi ya ná, mnduha dəmbuʼ hutaf ya. ");
INSERT INTO xed_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tahula tsa, gi ka mblafta Yesu ta duhwalhani ka lamə da kwambalu ŋa dzaʼa taŋ ta sana ɓla drəf nda tvə luwa Betsayda, ta kɗə tsatsi ta vriŋtá dəmga ŋa laba tsatsi nda hul nda hul slanaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Manda dgatani ta vgha nda tsa mnduha ya, ka sliʼaftá tsi ka laghwi ta ghwá da maga duʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lama vli da rviɗik ya ná, ɓhatá tsa duhwalha Yesu ya tsa nda kwambalu ma takataka drəf. Tata haɗik Yesu turtukwani. ");
INSERT INTO xed_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kəʼa ka Yesu nghadapta ná, ta takaɗaku duhwalhani ka swa kwambalu, kabga mamu falak ta vra həŋ. Wər ta tsughbura sərɗək vli, ka sliʼaftá tsi ka mbaɗa ta drəf nda səla, ŋa dzaʼa nda da həŋ, ka kumə tsi ta klatá wa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kəʼa ka həŋ ná, mamu skwi ta mbaɗa ta imi, zlah halalay ya, ka həŋ ka wahu. ");
INSERT INTO xed_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nda ngha inda taŋ demdem, ka ghudzaku həŋ ta ghudzaku da zləŋ. Ka gi gwaɗganatá Yesu ta həŋ. Kaʼa nda həŋ mantsa: «Ma wahu kuni ta wahu, iʼi ya, ma zləŋ kuni ta zləŋ!» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ka lagha tsi, ka lamə da tsa kwambalu ya nzata tavata həŋ. Ka gi lɓata tsa falak ya tɓekw. Ka laghu tsa duhwalhani ya da ndərmimay katakata. ");
INSERT INTO xed_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ma ŋa snaŋta taŋ ta mbrakwa Yesu nda mazəmzəm maga tsi nda buradi ya ná, lanamə a ta həŋ wu, kabga təŋtəŋa ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tahula tsughwaɗapta taŋ ta drəf, ɓhadaghar həŋ ta haɗika Genazaret, ka hbanata həŋ ta kwambala taŋ ta wa drəf hada. ");
INSERT INTO xed_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Manda saba taŋ ma kwambalu, ka tsəmafta mnduha ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tsəmafta taŋ, ka sliʼaftá həŋ nda hwaya da mnay ma inda vliha. Ka tsakwə həŋ nda ghzləŋa taŋ nda ghzləŋa taŋ ta gwal kul ɗughwanaku, da inda vli snaŋ həŋ kazlay: Hada Yesu kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma inda dər wati ma vli tsi ta lagha Yesu, dər ma zwana luwa tsi, dər ma huɗa luwa tsi, ka dər tahula luwa a tsi, ta hladaghahla lu ta gwal kul ɗughwanaku ka pghata ta daɓi. Ka ndəɓu lu ta dzvu da tsi, ŋa ksaŋta dər wa lgutani tsi kweŋkweŋ. Inda gwal ta ksaŋta ná, nda mbamba həŋ. ");
INSERT INTO xed_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka sliʼagata tsa la Farisa nda sanlaha ma gwal tagha zlahu ŋa mnduha ya ma Ursalima, ka tskavata tavatá Yesu. ");
INSERT INTO xed_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka nghaŋtá həŋ ta sanlaha ma duhwalha Yesu ta za skwa zay nda ŋratá dzvu, mbaziŋ a həŋ manda ya taghanaf dzidzíha taŋ ta həŋ wa. ");
INSERT INTO xed_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tsaw la Farisa nda sanlaha ma la Yahuda ya ná, haɗ həŋ ta za skwa zay ka ta mbaza a dzva taŋ tsuweɗek ɗina, manda ya taghanaf dzidzíha taŋ ta həŋ wa. ");
INSERT INTO xed_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ka vragaghavra həŋ ta luma, haɗ həŋ ta za skwa zay ka ta mbazaghu a həŋ ta mbaza wa. Mamu ndəghata sana skwiha guli taghanaf dzidzíha taŋ ta həŋ ta magə həŋ manda: Tva mbazapta ɗina ta kuwa, nda bəzleghwa, nda siga kufur. ");
INSERT INTO xed_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mbaɗa la Farisa nda gwal tagha zlahu ŋa mnduha ka ɗawaŋta da Yesu. Ka həŋ mantsa: «Nu kul haɗ duhwalha gha ta maga skwi taghaf lu da dzidzíha, ta kəl həŋ ka za skwa zay kul mbaziŋtá dzvu na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka Yesu nda həŋ mantsa: «Tsa maɗgwirmaɗgwira ghuni ya. A ta ŋa Isaya ta mnay ta ghəŋa ghuni, manda ya nda vinda mnə na Lazglafta kazlay: nana mnduha na ná, ta wubisim ta wubisim ta zləzlva həŋ ta iʼi. Ma ŋuɗufa taŋ ná, ɗva a həŋ ta iʼi wa. ");
INSERT INTO xed_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zləzləva iʼi ta zləzlvu həŋ ná, ka bətbət. Ma ŋa taghay taŋ ta zlaha ɗa ŋa mnduha ná, ka laghu həŋ da ŋanatá zlaha mnduha,» kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zlanava zla kuni ta zlaha Lazglafta, ka laghu kuni da sna skwi ya ta taghu mnduha. ");
INSERT INTO xed_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","«Nda hiɗa kuni kahwata ta wuɗiŋtá zlahuha Lazglafta, ka ŋanatá ŋa ghuni ma skwa dzidzí. ");
INSERT INTO xed_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wya ka Musa: “Vla ta glaku ŋa i da gha nda ma gha,” kaʼa. Kaʼa guli na: “Mndu ta razanaftá i dani nda mani, dzaʼa dzadza lu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama ka kaghuni ta mnay ŋa mnduha ná, laviŋlava mndu ta mnay ŋa i dani nda mani kazlay: Si má ta kumay yu ta vlaghatá skwi ŋa kataghata, ɗaw laviŋ a yu wu, kabga kwarbaŋ ya manda mnay kazlay: Dzaʼa vlaŋtá Lazglafta yu kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mantsa ya tama ta mbla kuni ta tsa mndu ya, ŋa kwal kul kataŋta i dani nda mani. ");
INSERT INTO xed_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma tsa magay ghuni mantsa ya tama ná, ta mbəɗiŋmbəɗa kuni ta gwaɗa Lazglafta, nda mndərga tsa tagha skwa ghuni ya ŋa mnduha. Nda ndəgha mndərga sana skwiha ta magə kuni manda ɗaslakwa tsahaya.» ");
INSERT INTO xed_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tahula tsa, ka hagəglaktá Yesu ta dəmga da tsi. Kaʼa nda həŋ mantsa: «Gunawa guna ta sləməŋa ghuni ɗina, ka mnaghunata yu. ");
INSERT INTO xed_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Haɗ skwi ta zadata mndu nda za ta ŋriŋta mndu wa, ba skwi ta sabə nda sa ma ŋuɗufa mndu ta ŋriŋta mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ka mamu mndu nda sləməŋa snay ka sna tsi. ");
INSERT INTO xed_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Manda sliʼafta Yesu ka laghwi da həga dgarə tsi ta vgha nda dəmga, ka ɗawaŋtá duhwalhani da tsi ta ghəŋa tsa gray graf tsi ya. ");
INSERT INTO xed_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kaʼa nda həŋ mantsa: «Aʼa, haɗ ɗifil ma ghəŋa kaghuni guli ra? Sna a kaghuni guli kazlay: Haɗ skwi ta zadata mndu nda za ta laviŋtá ŋriŋta mndu wu kəʼa ra? ");
INSERT INTO xed_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Haɗ tsa skwi ta zadata mndu nda za ya ta dzaʼa da ŋuɗufa mndu wu, da huɗi ta dzaʼa tsi ŋa dzaʼa thidiŋta ma dra,» kaʼa. Tsa gwaɗa Yesu ya ná, ta kumay ta mnay kazlay: Nda ghuɓa inda skwa zay kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","«Skwi ta sabə nda sa ma ŋuɗufa mndu ná, tsaya ta ŋriŋta mndu, ");
INSERT INTO xed_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kabga ma ŋuɗufa mndu ta sliʼagabta ghwaɗaka ndanuha, nda sliʼiŋsliʼiŋ, nda ghali, nda psla mnduha, ");
INSERT INTO xed_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nda hliri, nda haraʼu tiri, nda sidi, nda nənɓa mndu, nda kakraŋaku, nda ghudzaku, nda vza rutsak ta mndu, nda gəla ghəŋ, nda ga rgha. ");
INSERT INTO xed_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Inda tsa ghwaɗaka skwiha ta sliʼagapta ma ŋuɗufa mndu ya ta ŋriŋta mndu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tahula tsa, ka sliʼaftá Yesu hada ka laghwi ta haɗika Tir nda Siduŋ. Ka lamə tsi da sana həga. Va a si ta snaŋta mndu kazlay: Waʼa hadya kəʼa wa, ama laviŋ a ta ɗifaghuta wa. ");
INSERT INTO xed_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mamu sana marakw ksu halaway ta makwani, ka snaŋtá tsi ta mna gwaɗa ta Yesu. Ka gi sliʼaftá tsi ka lagha zləmbatá ma ghuva Yesu. ");
INSERT INTO xed_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ka ndəɓu tsi ta dzvu da tsi ŋa ghzligiŋtá tsa duhwala halaway ya ma tsa makwani ya. Tsa marakw ya ná, makwa la Grek ma luwa Finusi, ya lu ta haɗika Siri ya. ");
INSERT INTO xed_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka Yesu nda tsi mantsa: «Zlaŋzla ta zwani karaku ka baghafta həŋ. Ɗina a ka klaftá ɗuvula zwani ka vlaŋtá zwana kriha wa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","«Mantsa nzakwani mndani mghama ɗa, ama ta ɗagay zwana kriha ta wiwsa tsa skwa zay ta rkadata ta haɗik ma vəl zay zwani ya guli,» ka tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kaʼa nda tsi mantsa: «Kabga tsa gwaɗa gha ya, la makwa ɗa dzagha gha, waʼa saghusa tsa duhwala halaway ya ma makwa gha» kaʼa nda tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ka sliʼaftá tsa marakw ya ka laghwi dzaghani. Ɓhadaghatani dzagha ka lamə tsi da həga, ka slanaghatá tsi ta tsa makwani ya ta hani ta ghzləŋ. Ta haɗ tsa duhwala halaway ya mida wa. ");
INSERT INTO xed_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tahula tsa, ka sliʼaftá Yesu ta haɗika Tir, ka laghwi nda ma luwa Siduŋ, ka zlagaghatá tsi nda ma Dekapwalus ŋa vru nda tvə drəfa Galili. ");
INSERT INTO xed_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ɓhadaghatani da hada, ka klanaktá lu ta sana mndu ka rgha, sna a ta sləməŋ wu, sna a ta gwaɗa guli wa. Ka ndəɓu lu ta dzvu da tsi ŋa ksaŋta nda dzvu ka mbafta tsi. ");
INSERT INTO xed_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka klaghatá Yesu ta tsa mndu ya turtukwani, diʼiŋ nda mnduha. Ka dzadzaghatá Yesu ta ndəfiŋa dzvuhani da sləməŋha tsa mndu ya, ɗanafha ta sərɗəkani ta ghanik. ");
INSERT INTO xed_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ka nghadaftá Yesu nda ta luwa, ka hlafta tsi ta hafu. «Efasla,» kaʼa. Manda mnay kazlay: Gunaguna kəʼa ya, nda gwaɗa luwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Gi wuzlaŋ guna guna sləməŋha tsa mndu ya, gi wuteɗ plata ghanikani tsa, ka gwaɗə tsi ta gwaɗa tsəleŋ. ");
INSERT INTO xed_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ka dvanaghatá Yesu ta mnduha yaha həŋ da mnay dər ŋa wati ma mndu tsi. Ka dvu Yesu ta həŋ ya ná, ka sgə hahəŋ ta mna tsa skwi maga Yesu ya. ");
INSERT INTO xed_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ka ndərmim həŋ katakata, ka həŋ mantsa: «Inda skwi ta magə na mndu na na, ɗina. Nduk nda rgha tani ná, ka gwananatani ta sləməŋhani, ka gwaɗayni ta gwaɗa. Kay! Skwi ɗina ta magə na mndu na,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma tsa fitik ya, ka tskəglavatá ndəghata mnduha da Yesu, haɗ skwa zay ŋa zay taŋ wa. Ka hgaŋtá Yesu ta duhwalhani, ");
INSERT INTO xed_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ta ksita ka hiɗahiɗa na mnduha na, kabga ma hkəna fitika taŋ na ta nzaku kawadaga nda iʼi, haɗ skwi mutsaf həŋ ŋa zay guli wa. ");
INSERT INTO xed_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka lawala dzagha ghuni nda maya nda maya ka yu nda həŋ katsi, mutsafta a həŋ ta mbraku ŋa mbaɗa ta tvi wa. Wya sliʼaf ma vli diʼiŋ sanlaha mataba taŋ guli,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","«Ga dzaʼa mutsafta lu ta skwa zay ma na mtak na, ŋa vlaŋtá na mnduha na ŋa baghanaftá həŋ na?» ka duhwalhani nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","«Kidaghi buradi da kaghuni na?» kaʼa nda həŋ. «Ndəfáŋ həŋ,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mantsa tama, «nzawanza rəp ta haɗik,» ka Yesu nda tsa mnduha ya. Ka nzatá həŋ. Ka hlaftá Yesu ta tsa buradiha ndəfáŋ ya, ka rfanaghatá tsi ta Lazglafta. Tahula tsa, ka ɓalanaptá tsi, ka valaŋtá duhwalhani, ŋa daganaftá tsa mnduha ya. Ka daganaftá hahəŋ ta tsa mnduha ya. ");
INSERT INTO xed_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mamu zwana klipi kiʼa guli da həŋ, ka rfanaghatá Yesu ta Lazglafta ta ghəŋa tsa klipi ya, ka valaŋtá tsi ta duhwalhani. «Daganafwa daga ta mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ka zutá mnduha, ka baghaftá həŋ. Ka tskaftá lu ta pɗakwani ma vəl zay taŋ, ka ghwanak ndəfáŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsa mnduha ya na, ta magay həŋ ta dəmbuʼ fwaɗ. Mantsa tama, ka vriŋtá Yesu ta həŋ dzagha taŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Gi tahula tsa, ka sliʼaftá tsi ka lamə da kwambalu nda duhwalhani, ka laghu həŋ ta haɗika Dalmanuta. ");
INSERT INTO xed_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Manda ɓhadaghata taŋ, ka sliʼadaghatá la Farisa slanaghata, ka zlərɗə həŋ ta skwiha nda tsi, kabga ta kumay həŋ ta mutsaftá ghurum ŋa ksaftá Yesu, ka həŋ nda tsi mantsa: «Magaŋnamaga maga ta mazəmzəm ŋa maraŋta kazlay: Da Lazglafta ta mutsa kagha ta ŋa gha ma mbraku kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka hlaftá Yesu ta hafu, kaʼa mantsa: «Kabgawu ta kəl mnduha ta na zamana na, ka ɗawa magatá mazəmzəm katək na? Kahwathwata ta mnaghunata yu, haɗ sana mazəmzəm dzaʼa maranaŋta lu ta mnduha ta na zamana na wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ka sliʼaptá tsi mataba tsa la Farisa ya ka laghwi da kwambalu ŋa dzaʼa ta sana ɓla tsa drəf ya. ");
INSERT INTO xed_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma tsa sliʼa taŋ ya, ka zanaptá duhwalhani ta klaftá buradi, turtuktuk yeya buradi da həŋ ma kwambalu. ");
INSERT INTO xed_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","«Ɗasuwa ka kuni! Nghawa ghəŋa ghuni da isa la Farisa nda Hiridus,» ka Yesu zlahanaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka wuwisaku tsa duhwalhani ya mataba taŋ. «Zlah na kwala buradi kul haɗ da amu na yeya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Fslek ka tsa gwaɗa ya lamə da sləməŋa Yesu. Kaʼa nda həŋ mantsa: «Kabgawu ta kəl kuni ka ndanu, kabga kwala buradi kul haɗ da kaghuni na? Ha gita, haɗ mahizl ma ghəŋa ghuni ra? Təŋtəŋani ghəŋa ghuni katək ra? ");
INSERT INTO xed_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ya wana mamu ira ghuni ní, nu kul nghaŋtá kuni ta vli? Wana mamu sləməŋa ghuni, nu kul snaŋtá kuni ta sləməŋ? Haɗ kaghuni ta havaktá skwi katək ra? ");
INSERT INTO xed_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ma fitika daganafta ɗa ta buradi hutaf ta mnduha dəmbuʼ hutaf, kidaghi ndaghanafta kuni ta ghwanak nda paɗakwa vəl zay mnduha na?» kaʼa nda həŋ. «Ghwaŋpɗə his həŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«A ki ma fitika daganafta ɗa ta buradi ndəfáŋ ta mnduha dəmbuʼ fwaɗ, kidaghi ndaghanafta kuni ta tughuba nda paɗakwa vəl zay mnduha guli?» kaʼa nda həŋ. «Ndəfáŋ həŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","«Ka si mantsa tsi, nu kwal kuni snaŋta tama?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mantsa tama ka ɓhadaghatá i Yesu nda duhwalhani da luwa Betsayda. Ka kladaghatá mnduha ta ghulpata mndu da Yesu. Ka ndəɓu lu ta dzvu da tsi ŋa ksaŋta. ");
INSERT INTO xed_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka ksaftá Yesu ta tsa mndu nda ghulpa ya ta dzvu, ka klaghata tahula luwa. Ka tfanaftá tsi ta sərɗək ta iri, ka pghanaftá dzvu, ka ɗaw tsi da tsi kazlay: Nda ngha ka ta skwi ra? kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka gunaŋtá tsa ghulpa ta mndu ya ta iri. «Nda ngha yu ta mnduha ta wawaku mndani ná, ama manda fu manda fu ta ngha yu ta həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ka pghəglaftá Yesu ta dzvuhani ta iriha tsa mndu ya guli, ka nghaŋtá tsa mndu ya ta vli tsuwaɗak. Nda mba tama, nda ngha ta dagatá skwiha. ");
INSERT INTO xed_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mantsa tama, «Yaha ka lami da huɗa luwa,» kaʼa nda tsi, ka ghuniŋta dzaghani. ");
INSERT INTO xed_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tahula tsa, ka sliʼaftá Yesu kawadaga nda duhwalhani ka dzaʼa da sana luwaha ndusa ndusa ma luwa Sezare Filip. Ta labə həŋ ta tvi, ka ɗaw tsi da duhwalhani. Kaʼa mantsa: «Wa iʼi, ka mnduha ta mnay na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka həŋ mantsa: «Yuhwana mnda maga batem ya ka sanlaha, Iliya ya ka sanlaha, sana mndu mataba la anabi ya ka sanlaha ta mnay nda kagha.» ");
INSERT INTO xed_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","«Kinawu ka kaghuni, wa ya ka kaghuni ta mnay nda iʼi?» kaʼa kay guli. Ka Piyer mantsa: «Kagha na: Kristi ka,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka zlahanaghatá Yesu ta həŋ ka ŋɗaŋɗa. Kaʼa nda həŋ mantsa: «Yahayaha kuni da walaŋtá mnay mantsa ŋa mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mantsa tama, ka zlraftá Yesu ta taghay ŋa duhwalhani kazlay: Dzaʼa ghuyapə ghuya Zwaŋa mndu ta ɗaŋwa katakata. Dzaʼa wuɗidiŋ wuɗa la galata mnduha, nda maliha ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha tani. Dzaʼa dzadza lu, baɗu mahkən, ŋa sliʼagaptani nda hafu, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ka mnə tsi ta tsa gwaɗaha ya baŋluwa. Ka ksaghutá Piyer ta Yesu ta slərpa vli ka davanaghata. ");
INSERT INTO xed_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ka mbəɗavatá Yesu, ka ngha duhwalhani. Ka ŋruhanaghatá tsi ta Piyer, kaʼa nda tsi mantsa: «Laghula gha tavata iʼi halawaya skwi na. Haɗ ka ta ndanu manda ya ta kumə Lazglafta wa. Manda ndana mnduha ká ka ta ndanu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ka hagaktá Yesu ta mnduha, nda duhwalhani tani, ka mnay ŋa taŋ. Kaʼa mantsa: «Ka ta kumay mndu ta nzaku kawadaga nda iʼi katsi, ba vziŋtani ta ghəŋani, ka klayni ta udza zləŋayni, ka dzaʼani mista ɗa. ");
INSERT INTO xed_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ka dzaʼa mbanafmba yu ta hafa ɗa ka mndu katsi ná, dzaʼa zaɗiŋzaɗa tsa mndu ya ta hafani. Mndu dzaʼa zaɗiŋtá hafani kabga iʼi, nda ya kabga Lfiɗa Gwaɗa ná, dzaʼa mbanafmba tsa mndu ya ta hafani. ");
INSERT INTO xed_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nu dzaʼa ghzlanata mutsafta mndu ta na ghəŋa haɗik na tender, ka nda zaɗa hafani na? ");
INSERT INTO xed_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nu dzaʼa vlata mndu ŋa vara hafani na? ");
INSERT INTO xed_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ya wana ka dmaku mnduha ta na zamana na, ka sliʼiŋ ka sliʼiŋ həŋ da Lazglafta. Ka kwalaghukwala mndu ta mnaŋtá hga ɗa nda gwaɗa ɗa guli ta kəma tsa mnduha ya katsi, iʼi Zwaŋa mndu guli ná, dzaʼa kwalaghukwala yu ta mnaŋtá tsa mndu ya baɗu vragata ɗa kawadaga nda duhwalha nda ghuɓa ta luwa ma glakwa Lazglafta.» ");
INSERT INTO xed_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaʼa nda həŋ guli mantsa: «Kahwathwata ka yu ta mnaghunata, mamu sanlaha ma mnduha mataba gwal hadna, dzaʼa kwal kul rwuta ta saha ga mghama Lazglafta nda mbraku, ŋa nghaŋta taŋ nda ira taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tahula fitik mkuʼ, ka hlaftá Yesu ta i Piyer nda Yakubu, nda Yuhwana mistani, ka ŋlaghatá həŋ ta sana ghwá nda slra. Lafa taŋ ta tsa ghwá ya, ka mbəɗavaftá tsi ta kəma taŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ka wuɗaku lguthani tilil katakata. Haɗ mndu ta na ghəŋa haɗik na dzaʼa laviŋtá ghuɓaptá skwi ŋa ɓanafta ŋa laf taɓ ta tsaya wa. ");
INSERT INTO xed_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta wa ira tsa duhwalhani ya, ka zlagaptá i Iliya nda Musa, ka ghwa yiva nda Yesu. ");
INSERT INTO xed_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ka ksafta zləŋ ta tsa duhwalha ya katakata. Sna a Piyer ta skwi ŋa mnay wa. Gi ka Piyer nda Yesu mantsa: «Maləma ɗa, ɗina ka nzata mu hadna. Magafmamaga ta həgaha tumpul hkən. Pal ŋa gha, pal ŋa Musa, pal ŋa Iliya guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka saha kusay tɗik bukwamtá həŋ. Ka gwaɗagaptá lwi ma tsa kusay ya. Kaʼa mantsa: «Nana na zwaŋa ɗa ta ɗvu yu nda ŋuɗufa ɗa. Snawa ta gwaɗa da tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gi zləwaɗ zləwaɗ zləwaɗ, ka duhwalhani ka nanagha vli ta wanaftá həŋ. Kəʼa ka həŋ ná, Yesu turtukwani yeya nghaŋ həŋ kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ka sliʼaftá həŋ ka saha ta tsa ghwá ya. Ta saha həŋ, ka zlahanaghatá Yesu ta tsa duhwalha ya. Kaʼa mantsa: «Yahayaha kuni da mnaŋtá skwi nghaŋ kuni ŋa mndu ha ka sagha fitik ya dzaʼa sliʼagabta Zwaŋa mndu mataba gwal nda rwa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ka snatá həŋ ta tsa gwaɗa ya, ama ka laghu həŋ da ɗaɗawaku mataba taŋ «nahgani sliʼagabta mataba gwal nda rwa?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mantsa tama, ka ɗawaŋtá duhwalhani da Yesu. Ka həŋ mantsa: «Kabgawu ta kəl gwal tagha zlahu ŋa mnduha ka mnay kazlay: Tiŋəl Iliya dzaʼa saha karaku kəʼa na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka Yesu nda həŋ mantsa: «Aŋi, dzaʼa tiŋlaghutiŋla Iliya ta saha ŋa payanatá inda skwiha. Ama kabgawu vindafta lu ta ghəŋa Zwaŋa mndu kazlay: Dzaʼa ghuyay ta ɗaŋwa katakata, ɗvəta a lu wu kəʼa? ");
INSERT INTO xed_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ama ka yu ta mnaghunata ná, ghadaghada Iliya ta saha ka ghuyanaptá həŋ ta ɗaŋwa manda ya kumaŋ həŋ. Mantsa ya ka gwaɗa Lazglafta mnata ta ghəŋani,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Manda vradaghata i Yesu tavata tsa duhwalhani si zlana həŋ ya, ka nghaŋtá həŋ ta tskata mnduha ta wanaftá tsa duhwalha ya nda gwal tagha zlahu ŋa mnduha ta zlərɗutawi nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na ghur, nghay tsa tskatá mnduha ya ta Yesu ná, nda ghada ndusadaghatani da həŋ. Ka sliʼafta həŋ nda hwaya ka dzaʼa ga zgu ŋani. ");
INSERT INTO xed_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka Yesu ɗawaŋta da həŋ mantsa: «Ta ghəŋa wu ta zlərɗa kuni ta wi nda həŋ na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka sana mndu mataba tsa mnduha ya zlghanaftawi mantsa: «Maləma ɗa, zwaŋa ɗa ksu seteni, vlaŋ a ta tva gwaɗa wu kəl yu ka klagaghata da kagha. ");
INSERT INTO xed_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ka ta kumay tsa skwi ya ta slanapta katsi, gi slanatani ta haɗik. Gi pghay tsa zwaŋ ya ta mahupak ma wi, dzislayni ta sliʼiŋ ka hpaɗay, gi dzəŋ vghani. Tsaya kəl yu ka ndəɓa dzvu da duhwalha gha, kambəl ka ghzligiŋtá həŋ ta tsa seteni ya ma tsa zwaŋa ɗa ya mazlay, ama ka traptá həŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka Yesu nda həŋ mantsa: «Ghwaɗaka mndəra mnduha kul haɗ zlghay nda ŋuɗuf da həŋ! Ŋa kulam yawu dzaʼa nzata yu tavata kaghuni? Ŋa kulam yawu dzaʼa nzata yu ka suʼuwaghunata? Klagiɗighawa tsa zwaŋ ya,» kaʼa nda həŋ. Ka klədanaghatá lu. ");
INSERT INTO xed_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gi ghur nghay tsa zwaŋ ya ta Yesu ná, ka gi slanaptá tsa seteni ya nda mbraku, ka slanata ta haɗik, ka kwatambal tsi ta vgha ta haɗik, ka pgha mahupak ma wi. ");
INSERT INTO xed_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka ɗawaŋtá Yesu da dani ma tsa zwaŋ ya: «Daga Yawu zlrafta na skwi na ta na zwaŋ na na?» kaʼa nda tsi. «Daga ma ga zwaŋani ksafta tsi. ");
INSERT INTO xed_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Baɗu ma sani, klaftani wuɗamta da vu, dər da imi tsi, gi wuɗamtani ma ŋa dzatani, kəʼa ta magay tazlay. Ka laviŋlava ka, kdəkkdək kataŋna kata, tawa ta hiɗahiɗa ta aŋni!» ka tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","«Ka laviŋlava ka ri waka ka? Nu dzaʼa kwal lu laviŋta magata ka zlghafzlgha mndu nda ŋuɗuf na?» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gi ka kapaŋtá dani ma tsa zwaŋ ya ta lwi, «Zlghafzlgha yu, sawi katihata ma hta ta zlghay ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nghay Yesu ta gazladaghata mnduha nda hwaya, ka davanaghatá tsi ta tsa seteni ya. «Ghwaɗaka Sulkum ta pya mndu ka gwaɗa nda ya ka snaŋtá sləməŋ. Sabsa ma na zwaŋ na, ka yu ta mnaghata. Yaha ka vrəgladamta ɗekɗek dida,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka wahata tsa seteni ya ka ghudzanaftá tsa zwaŋ ya nda mbraku, ka sabə tsi mida. Ka niŋtá tsi ta tsa zwaŋ ya gzəmblaʼ manda mndu nda mta, ha ka mnay ndəghata mnduha kazlay: Nda mta kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama ka ŋanatá Yesu ta dzvu, ka sliʼanafta, ka sliʼaftá tsi ka sladata. ");
INSERT INTO xed_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Manda lama Yesu kawadaga nda duhwalhani da həga nda ghəŋa taŋ, ka ɗaw həŋ da tsi. Ka həŋ mantsa: «Kabgawu kəl aŋni ka traptá ghzligiŋtá tsa seteni ya katək na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","«Mndərga tsa Sulkum ya ná, ba nda maga duʼa kada saba tsi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ka sliʼaftá həŋ hada ka taghatá haɗika Galili. Va a Yesu si ta nghaŋta mndu wu, ");
INSERT INTO xed_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kabga ta tagha skwi ŋa duhwalhani. Wya skwi ta mnə tsi ŋa taŋ: «Dzaʼa ksafksa lu ta Zwaŋa mndu ka vlata ma dzva mnduha ŋa dzata taŋ. Baɗu mahkən, ŋa sliʼaftani nda hafu.» ");
INSERT INTO xed_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama sna a duhwalhani ta tsa gwaɗa ya wa. Ta zləŋ həŋ guli nda ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ka ɓhadaghatá həŋ da luwa Kafarnahum. Ta nzaku həŋ ma həga, ka ɗawaŋtá Yesu da həŋ: «Nahgani tsa skwi ta uwaʼuwal kaghuni ta tvi ya na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sriw nzanza həŋ, pslaf a həŋ ta wa taŋ wa, kabga si ta zba snaŋtá mali mataba taŋ həŋ, na skwi si ta uwaʼuwal həŋ ta tvi. ");
INSERT INTO xed_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ka nzadatá Yesu, «saghawasa» kaʼa nda həŋ. «Ka ta kumay mndu ta nzaku ka mali ta wa ira Lazglafta katsi, vraganatani ta ghəŋani ka sagəŋ gudzekw mista lamndu, ka nzakwani ka kwalva taŋ guli.» ");
INSERT INTO xed_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka hgaftá tsi ta sana zwaŋ kwitikw, ka sladanata mataba taŋ. Ka tskwaftá tsi ma ghuvani, kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Dər wati ma mndu ta tsuʼaftá sani turtuk mataba na zwaniha na, kabga iʼi, vərɗa iʼi tsuʼaf tsa mndu ya nda tsa. Dər wati ma mndu ta tsuʼaftá iʼi guli, vərɗa iʼi a tsuʼaf tsi wa, ama mndu ya ta ghunigihata tsuʼaf tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka Yuhwana nda tsi mantsa: «Maləma ɗa, nda ngha ŋni ta sana mndu ta ghzla duhwalha halaway ma mndu. Ka tsa mndu ya na: “Yesu ta vlihatá mbraku,” kaʼa. Ka lmə ŋni, kabga haɗ ta dzaʼa mista amu wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka Yesu mantsa: «Ma lmə kuni ta mndu, kabga haɗ mndu ta maga mazəmzəm nda hga ɗa, dzaʼa vza rutsak ta iʼi wa. ");
INSERT INTO xed_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mndu kul haɗ ta raza amu guli ná, ŋa amu tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Dər wati ma mndu ta taghunaftá imi rauʼ ŋa say, kabga nzakwa ghuni ka ŋa Kristi, kahwathwata ka yu ta mnaghunata, haɗ nisəla tsa mndu ya dzaʼa zwaɗuta ɗekɗek wu,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ka vzamvza mndu ta sani turtuk mataba na zwaniha ta zlghafta iʼi na ma dmaku katsi, dzaʼa ghuyay ta ɗaŋwa katakata da Lazglafta. Ta dər má ya hbanam lu ta dughura buna dagala ma ŋurzluŋ, ka vzaghata da drəf, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ka si dzva gha ta famta kagha kəl ka ka zləmbamta ma dmaku katsi, tsiŋtsa gha ta tsa dzvu ya. Ta dər mutsafta gha ta hafu nda dzva gha ka buɗuduŋ, ka lama gha nda dzvuha gha yipaʼ his his da həga vu kul haɗ ta mtavata ɗekɗek. ");
INSERT INTO xed_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Hada, mamu mtarakha ta yamta ma vgha ŋəɗməts, rwava a həŋ wa. Haɗ tsa vu ya ta mtaku ɗekɗek guli wa. ");
INSERT INTO xed_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ka səla gha ta famta kagha kəl ka zləmbamta ma dmaku katsi, tsiŋtsa ta tsa səla ya. Ta dər mutsafta gha ta hafu nda səla gha sluŋ turtuk, ka nzakwa gha nda səlaha gha yipaʼ his his, ŋa wuɗamtá kagha da həga vu. ");
INSERT INTO xed_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Hada, mamu mtarakha ta yamta ma vgha ŋəɗməts, rwava a həŋ wa. Haɗ tsa vu ya ta mtaku ɗekɗek guli wa. ");
INSERT INTO xed_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ka ira gha turtuk, ta famta kagha kəl ka ka dəɗamta da dmaku katsi, tsakwasliŋ tsakwasla ta tsa iri ya. Ta dər lama ka nda ira gha guzliŋ turtuk da ga mghama Lazglafta, ka nzakwa gha nda ira gha his his, ŋa wuɗamtá kagha da həga vu. ");
INSERT INTO xed_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Hada, mamu mtarakha ta yamta ma vgha ŋəɗməts, rwava a həŋ wa. Haɗ tsa vu ya ta mtaku ɗekɗek guli wa. ");
INSERT INTO xed_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Inda mndu dzaʼa nəmanaf nəma vu manda slughul. Inda skwi ta drə lu ŋa Lazglafta ta kuktaf kukta lu ta slughul tida ");
INSERT INTO xed_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Slughul ná, skwi ɗina ya, ama ka ta haɗ zɗaku mida ɗekɗek wu katsi, nu dzaʼa magəglamta kuni mida ŋa vranamtá si tsa nəmatani ya na? Mamu ka slughul ma kaghuni. Nzawanza nda zɗaku mataba ghuni, sanlaha nda sanlaha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tahula tsa, ka sliʼaftá i Yesu nda duhwalhani hada ka laghwi ta haɗika Zudiya nda tvə drəfa Zurdeŋ. Ka tskəgladaghatá mnduha ta vgha tavatani. Ka nzəglatá tsi ka tagha skwi ŋa taŋ manda ya snu tsi. ");
INSERT INTO xed_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ka gavadaghatá la Farisa tavata Yesu ŋa hla səlani. Ka ɗawaŋtá həŋ da tsi, ka həŋ mantsa: «Mamu re haɗ wa a tvi ŋa ghzliŋta mndu ta markwa taŋ na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kaʼa nda həŋ mantsa: «Wa ka Musa vindaghunafta na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","«Ka Musa ná, ka ta kumay mndu ta ghzliŋtá markwa taŋ katsi ná, vindanaftani ta ɗelewera ghzlu, ka ghzliŋtani kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka Yesu nda həŋ mantsa: «Təŋa ta ghəŋa ghuni kəl Musa ka vindaghunaftá tsa gwaɗa zlahu ya mantsa. ");
INSERT INTO xed_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama ma zlraftani, manda kɗiŋta Lazglafta ta magaftá inda skwi, “ka tsaftá tsi ta i zəʼal nda marakw.” ");
INSERT INTO xed_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tsaya dzaʼa kəl zgun ka zlaŋtá dani nda mani, ka ndiʼanavatá vgha ta markwa taŋ, ");
INSERT INTO xed_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ŋa nzakwa tsa hahəŋ his ya ka sluʼuvgha turtuk. Mantsa tama, nzəgla a həŋ ka mnduha his wu, ama ka sluʼuvgha turtuk nzakwa taŋ.» ");
INSERT INTO xed_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Skwi ndiʼanaf Lazglafta ná, yahayaha mndu dganata, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Manda vrakta taŋ, ka lamə həŋ nzata ma həga, ka ɗawaŋtá duhwalhani da tsi ta ghəŋa tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kaʼa nda həŋ mantsa: «Ka ghzliŋghzla mndu ta markwa taŋ, ka klaftá sana marakw katsi, ta hliri tsa mndu ya, maganamaga tsa mndu ya ta ghwaɗaka skwi ta tsa taŋtaŋa markwa taŋ ya. ");
INSERT INTO xed_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mantsa guli, ka sliʼafsliʼa marakw ka laghu da wumatá sana zəʼal katsi, ta hliri tsa marakw ya nda tsa.» ");
INSERT INTO xed_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mbaɗaka mnduha ka va hlaktá zwani kwitikw kwitikw da Yesu ŋa tfanaghatawi ta həŋ, nda ma fanaghatani ta dzvu ta həŋ. Ama ka ghzlə duhwalha Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka nghə Yesu ta tsa skwi ta magə həŋ ya ná, zɗəgana a wu, ka kuzlanaftá tsi ta ŋuɗuf. «Zlaŋwazla ta zwaniha kwitikw kwitikw ka sagha həŋ da iʼi, ma pyə kuni ta həŋ, kabga ŋa gwal ta gara vgha nda həŋ na ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kahwathwata ka yu ta mnaghunata, dər wati ma mndu dzaʼa gi kwal kul tsuʼaftá ga mghama Lazglafta manda zwaŋ kwitikw, lamta a tsa mndu ya ɗekɗek wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ka hlamtá tsi ta tsa zwaniha ya da ghuvani, ka pghanaghatá dzvu ta həŋ, ka tfanaghatawi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Manda sliʼafta Yesu ka mbaɗa ta tvi, ka sliʼaftá sana mndu ka hwayakta tsəlɓata ma ghuvani, ka ɗaway da tsi: «Ari ŋərma mgham, nu dzaʼa magə yu ŋa mutsafta ɗa ta hafu ŋa kɗekedzeŋ na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka Yesu nda tsi mantsa: «Kabgawu kəl ka ka hga iʼi ka ŋərma na? Haɗ sana ŋərma taɓta Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nda sna ka ta zlahuha ta mnay kazlay: Yaha ka da dzatá mndu, yaha ka da hliri, yaha ka da ghali, yaha ka da tsanavatá gwaɗa ta mndu, yaha ka da nənɓa mndu, ka vla ka ta glaku ŋa i da gha nda ma gha kəʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","«Mghama ɗa, snasna yu ta inda tsa skwiha ya daga ma ga zwaŋa ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tsəmesl, ka Yesu nghanavatá tsa mndu ya, ka ɗvutá tsi, kaʼa nda tsi mantsa: «Ta turtuk skwi ta pɗugudughusta. La ka dzawapta ka ta inda skwa gha, ka daganafta ka ta gwal ka pɗu, mantsa dzaʼa mutsay ka ta gadghəl ta luwa. Magata gha ta tsaya, ka sagha ka, ka dzaʼa ka mista ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na snaŋta tsa mndu ya ta tsa gwaɗa ya, ka laghu tsi nda ɓasatá ŋuɗuf, kabga gadghəl ya. ");
INSERT INTO xed_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ka waftá Yesu ta duhwalhani ta wanafta. «Kay! Dzaʼa nda bla ka lama gwal gadghəl da ga mghama Lazglafta!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ka ndərmim duhwalhani nda ndərmima ta tsa gwaɗa ya. Ka vrəgliŋtá Yesu ta mnay guli, «Zwana ɗa, nda bla ka lama gwal ta fafta ghəŋa taŋ ta gadghəl da ga mghama Lazglafta! ");
INSERT INTO xed_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ta dər laba ŋalibwa nda ta ghuruma lipir, ka lama mnda gadghəl da ga mghama Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka va ndərmimgəlta duhwalhani, ka həŋ mataba taŋ mantsa: «Ka si mantsa tsi katsi ná, wa dzaʼa mutsafta mbaku tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka nghanavatá Yesu ta həŋ, kaʼa mantsa: «Haɗ mndu dzaʼa laviŋtá mbanaftá ghəŋani wa, ama laviŋlava Lazglafta ta mbanaftá mndu, kabga laviŋlava ta maga inda skwi.» ");
INSERT INTO xed_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","«Aʼa! Wana aŋni, zlanavazla ŋni ta inda skwiha ŋni, ka dzaʼa mista gha,» ka Piyer. ");
INSERT INTO xed_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka Yesu mantsa: «Kahwathwata ka yu ta mnaghunata, haɗ mndu ta sliʼafta ka zlaŋtá hgani, nda zwanamani, nda kwaghamani, nda mani, nda dani, nda zwanani, nda haɗikhani, kabga iʼi nda ya kabga Lfiɗa Gwaɗa Lazglafta, ");
INSERT INTO xed_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dzaʼa kwal kul mutsafta fərta ta sgavaghatani daga ta na zamana mida mu na wa. Dzaʼa mutsay ta həgaha, nda zwanama, nda kwaghama, nda mamaha, nda zwani, nda haɗikha tani, ama dzaʼa ghuyay ta ɗaŋwa guli. Ma zamana ta sagha guli, ŋa mutsayni ta hafu ŋa kɗekedzeŋ da Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nda ndəgha gwal si ta kəma, dzaʼa nzakway nda hul. Nda ndəgha gwal si nda hul guli, dzaʼa nzakway ka gwal ta kəma,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta mbaɗa həŋ ta tvi ŋa ŋlu ka dzaʼa da Ursalima, ka labə Yesu ta kəma taŋ. Hluhla zləŋ ta duhwalhani, nda gwal ta dzaʼa mista taŋ tani. Ka tskəglanatá Yesu ta tsa duhwalhani ghwaŋpɗə his ya tavatani, ka zlraftá tsi ta mnay ŋa taŋ ta skwi dzaʼa slanaghata. ");
INSERT INTO xed_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Snawasna ɓa! Wana mu ta dzaʼa da Ursalima. Hada dzaʼa ksafta lu ta Zwaŋa mndu, ŋa vlaŋtá maliha ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, ŋa tsanaghata taŋ ta guma ŋa dzata, ŋa vlaŋta taŋ ta gwal kul nzakway ka la Yahuda, ");
INSERT INTO xed_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ŋa ganapta tsahaya tiri, ŋa tafay taŋ ta sərɗək tida, ŋa sləvay taŋ nda krupiha, ŋa dzata taŋ, ama baɗu mahkən, ŋa sliʼagaptani nda hafu.» ");
INSERT INTO xed_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tahula tsa, ka gavadaghatá i Yakubu nda Yuhwana ta nzakway ka zwana Zebedi tavata Yesu. «Mghama ɗa, ta kumay ŋni ta magaŋnata gha ta skwi dzaʼa ɗawaŋta ŋni da kagha,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","«Nahgani ta kumə kuni ta magaghunata ɗa na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","«Baɗu lama gha da glakwa gha ya ná, ka pghata ka ta aŋni, sani nda ga zeghwa gha, sani guli nda ga zlaɓa gha ná, kiɓa,» ka ŋni. ");
INSERT INTO xed_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka Yesu zlghanaftawani ta həŋ mantsa: «Sna a kuni ta skwi ta ɗawə kuni wa. Dzaʼa laviŋlava kuni ta sa leghwa tsa ghuya ɗaŋwa dzaʼa yu say ya ra? Ari dzaʼa tsuʼay kuni ta batema tsa ghuya ɗaŋwa dzaʼa ghuyɗipta lu ya?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","«Aŋi, dzaʼa laviŋlava ŋni,» ka həŋ. Ka Yesu nda həŋ mantsa: «Mantsa nzakwani, dzaʼa say kuni ta leghwa ghuya ɗaŋwa dzaʼa yu say, dzaʼa tsuʼay kuni ta batema tsa ghuya ɗaŋwa dzaʼa lu ghuyɗipta ya. ");
INSERT INTO xed_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama ta ghəŋa skwi ta nghanaŋtá tsa nzaku nda ga zeghwa ɗa nda ya nda ga zlaɓa ɗa ya ná, nghiɗigha a tsa ya wa. Nda nza tsa vliha ya ka ŋa gwal payanaf Lazglafta ta həŋ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na snaŋta tsa pɗakwa duhwalha ghwaŋ ya ta tsa gwaɗa ya, ka ɓasanavata həŋ ta ŋuɗuf ta i Yakubu nda Yuhwana. ");
INSERT INTO xed_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","«Saghawasa,» ka Yesu nda həŋ. «Nda sna kuni ta gwal ta nghə lu manda mghamha ta ghəŋa mndəra mnduha ná, ta gay həŋ ta ma mgham mghama taŋ. Gwal kulaŋ lu guli, ta maray hahəŋ ta mbrakwa taŋ ta ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama mantsa a nzakwani mataba kaghuni wa. Ka ta kumay mndu ta nzaku ka mali mataba ghuni katsi, ka nzata tsi ka kwalva ghuni. ");
INSERT INTO xed_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ka ta kumay mndu mataba ghuni ta nzaku ta kəma katsi, ka nzata tsi ka kwalva inda mnduha. ");
INSERT INTO xed_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wya tsi, sa a Zwaŋa mndu kabga ŋa maganata lu ta slna wa, ama ŋa nzaku ka kwalva mnduha, vlaha ta hafani ŋa vara ndəghata mnduha guli,» ka Yesu zlghanaftawani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ka ɓhadaghatá həŋ da luwa Yeriku. Ta sabə i Yesu nda duhwalhani, nda tskata sanlaha ma mnduha ma tsa luwa ya, mamu sana ghulpa ta mndu ta nzaku ta wa tvi ka gatá skwi. Bartime hga tsa mndu ya, ta nzakway ka zwaŋa Time. ");
INSERT INTO xed_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Manda snaŋtani kazlay: Yesu zwaŋa la Nazaret ya ta sagha kaʼa, ka dzatá tsi ta lawlaw, kaʼa mantsa: «Yesu zwaŋa Dawuda, tawa ta hiɗahiɗa ta iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mbaɗa mnduha ka ŋurhway. «Ma gwaɗaf ka,» ka həŋ. Ama ka sganaghatá tsi ta dza lawlaw ka ŋɗaŋɗa: «Zwaŋa Dawuda, tawa ta hiɗahiɗa ta iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ka sladata Yesu, kaʼa mantsa: «Hgagaghawa hga,» kaʼa. Ka hgaktá həŋ ta tsa ghulpa ta mndu ya. Ka həŋ nda tsi mantsa: «Ŋavaŋa ka sliʼafta ka, wya ta hga kagha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ka slurtidiŋtá tsa ghulpa ta mndu ya ta lgutani, ka valavata ka labə nda tvə Yesu. ");
INSERT INTO xed_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ka ɗawaŋtá Yesu da tsi. Kaʼa mantsa: «Nu ta kumə ka ta magaghata ɗa na?» kaʼa. «Maləma ɗa, ka nghəglaŋta yu ta vli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","«La, nda mba ka, kabga zlghafta gha ta iʼi nda ŋuɗufa gha,» kaʼa nda tsi. Ka gi nghəglaŋtá tsa mndu ya ta vli, ka ksə tsi ta tvi ka dzaʼa mista Yesu. ");
INSERT INTO xed_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Taghwaŋ a həŋ ka ɓhadaghata da luwa Ursalima wu, ka labə həŋ nda mista ghwá zaytuŋ, ndusa nda sana luwaha ta hgu lu ka Beslaze nda Betani. Ka ghunaftá Yesu ta gwal his mataba duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Lawala da na luwa ta kəma ghuni na. Ka ɓhadaghaɓha kuni, dzaʼa slanaghasla kuni ta zwaŋa kɗih hbana lu ta kul walaŋta mndu ta laf tida. Ka plata kuni, ka klagaghata kuni. ");
INSERT INTO xed_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka “ŋaw kuni ta tsa na” ka mndu ɗawaŋta da kaghuni katsi, “Mgham ta kumay,” ka kuni dazlay. Gi dzaʼa zlaghunaŋzla həŋ ŋa klaktá ghuni da hadna,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka sliʼaftá həŋ ka labə, ka slanaghatá həŋ ta zwaŋa kɗih ta hba ma bli ta watgha ga mndu ndusa nda wa tvi, ka platá həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ka gwal ma tsa vli ya nda həŋ mantsa: «Nu tsa ta magə kuni na? Ta plə ŋaw kuni ta tsa zwaŋa kɗih ya na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka zlghanaftá həŋ ta wa taŋ manda ya mnanaf Yesu ta həŋ. Ka zlaŋtá lu ta həŋ, ka laghu həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ka klədanaghatá həŋ ta tsa zwaŋa kɗih ya ta Yesu, ka pghaftá həŋ ta lguta taŋ, ka ŋladaftá Yesu nzafta tida. ");
INSERT INTO xed_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ka liŋtá mnduha ta zlazlatá lgutha taŋ ta tvi, sləhwa fuha ŋa sanlaha ta ɓalakta ma vwah ka pghay ŋa tsuʼay. ");
INSERT INTO xed_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mbaɗaka gwal ta dzaʼa ta kəma Yesu nda gwal ta dzaʼa nda hulani tani ka hla wi. «Ŋa Lazglafta glaku! Ka tfanaghatfa Lazglafta ta wi ta mndu ya ta sagha ma hgani. ");
INSERT INTO xed_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ka tfanaghatfa Lazglafta ta wi ta ga mgham ta sagha, ga mghama Dawuda ta nzakway ka da ŋni! Glaku ŋa Lazglafta ta luwa!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ka ɓhadaghatá Yesu da luwa Ursalima, ka lamə tsi da həga Lazglafta. Tahula naghanatani ta inda skwiha, ka sliʼaftá tsi ka vraghuta da Betani kawadaga nda duhwalhani ghwaŋpɗə his, kabga nda ghada laghwa fitik. ");
INSERT INTO xed_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gamahtsimani, ta sabə həŋ ma tsa luwa Betani ya ka vru da luwa Ursalima, ka kuzlanaftá maya ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka nghaŋtá tsi ta sana ghuraf manda a nda sləhwa tbukw tida. Ka labə tsi nghanata, ka dzaʼa slanaghar slanagha a wa yu ta zwaŋ tida kəʼa. Laghani tavata tsa fu ya, kəʼa kəʼa ná, sləhwa yeya tida, kabga ta fitika yakwa ghuraf a wa. ");
INSERT INTO xed_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka Yesu nda tsa ghuraf ya mantsa: «Walglaŋta a mndu ta tsagatá yaku ta kagha ŋa zay wa,» kaʼa. Ta snaysnay duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tahula tsa, ka ɓhadaghatá həŋ da luwa Ursalima, ka lamə Yesu da daɓa həga Lazglafta. Ka slanaghatá tsi ta mnduha ta dzawa skwi nda sakwa skwi hada. Ka liŋtá tsi ta ghzligiŋtá həŋ dzibil, ka zlambidiŋtá tsi ta tabəlha gwal ta mbəɗ, nda vla nzakwa gwal ta dzawa ghərbuʼ tani. ");
INSERT INTO xed_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Zlana a ta mndu dər turtuk ŋa tsughwaɗadapta nda ma tsa daɓa həga Lazglafta ya nda skwi wa. ");
INSERT INTO xed_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka mnə tsi ŋa taŋ. Kaʼa mantsa: «Vinda a ma gwaɗa Lazglafta kazlay: Həga ɗa ná, dzaʼa nzakway ŋa həga maga duʼa mndəra mnduha demdem kəʼa ra? Ama mbaɗa kaghuni ka niŋta ka galigha gwal gənda,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Manda snaŋta la mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha ta tsa skwi ya, ka zbə həŋ ta tvi ŋa dzatá Yesu. Ama ta zləŋ həŋ guli, kabga ksaŋksa tsa skwi ta taghə tsi ya ta hamata inda mnduha. ");
INSERT INTO xed_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Manda dəɗata fitik, ka sabə i Yesu nda duhwalhani ma tsa luwa ya ka laghwa taŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga sərɗək ta labə həŋ ta tvi ka vru da Ursalima, kəʼa ka duhwalha Yesu ná, dzuŋuŋ nda ghwala tsa ghuraf ksiʼaf tsi ya kay, nduk nda slrəŋhani tani. ");
INSERT INTO xed_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka havaktá Piyer ta ghəŋa skwi ta luta. «Maləma ɗa, ngha ta ghwala ta na ghuraf ksiʼaf ka na kay ɓa!» kaʼa nda Yesu. ");
INSERT INTO xed_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka Yesu nda duhwalhani mantsa: «Fafwa ghəŋa ghuni ta Lazglafta! ");
INSERT INTO xed_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kahwathwata ka yu ta mnaghunata, dər ya ghwá ya mnə mndu kazlay: Sliʼafsliʼa ka vzamta ka ta vgha da drəf! kaʼa nda tsi katsi, ka dgaŋ a tsi ta ghəŋ ta ghəŋani wu, faffa ta ghəŋani ta skwi ya mna tsi ŋa magakwani katsi, dzaʼa maganamaga Lazglafta ta tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tsaya ta kəl yu ka mnaghunata kazlay: Inda skwi dzaʼa kuni ɗawaŋta nda maga duʼa ná, fafwafa ta ghəŋa ghuni tida manda skwi nda ghada mutsatani, dzaʼa nghay kuni ta magata tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ka ta maga duʼa kuni katsi, ka waya kaʼa mamu dgun ma ŋuɗufa ghuni nda sana mndu katsi, pliniswapla ta dmakwa tsa mndu ya, kada plighunista Da ghuni Lazglafta ta luwa ta dmakuha kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama, ka haɗ kaghuni ta plinistá dmakwa mndu wa katsi, haɗ Da ghuni Lazglafta ta luwa dzaʼa plighunistá dmakwa kaghuni guli wa» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ta mbaɗa həŋ, ka vrəgladaghatá həŋ da luwa Ursalima. Ta wawakwani Yesu ma həga Lazglafta, ka sliʼadaghatá la mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, nda la galata mndu guli slanaghata. ");
INSERT INTO xed_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Nda mbrakwa wa ta maga ka ta na skwiha na, wa ta vlaghatá tvi ŋa magay?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","«Iʼi guli, ka ɗawaŋɗawa yu ta skwi turtuk da kaghuni, ka zlghiɗifzlgha kaghuni ta wani katsi, dzaʼa mnaghunamna yu, ka nda mbrakwa wa ta maga yu ta tsa skwiha ya,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","«Wya tsa ɗaway ɗa ya: Lazglafta ta ghunafta Yuhwana maga batem re, ari mnduha a na? Zlghiɗifwa zlgha ta wani,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ka laghu həŋ zlərɗay mataba taŋ. «Waka mu dzaʼa zlgha wani. Ka Lazglafta ya ta ghunafta ka mu, kabgawu kwal kuni kul zlghafta ɓa,» kaʼa dzaʼazlay nda amu. ");
INSERT INTO xed_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","«Ka mnduha ta ghunafta» ka mu katsi, lava a mantsa guli wu, ka həŋ, kabga nda sna mnduha ta Yuhwana kahwathwata kazlay: Vərɗa anabi ya kəʼa. Tsaya tama, ta zləŋay həŋ ta skwi dzaʼa magə mnduha. ");
INSERT INTO xed_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mantsa tama: «Sna a aŋni ta mndu ta ghunakta wu,» ka həŋ. Ka Yesu nda həŋ tama mantsa: «Mantsa iʼi guli, haɗ yu dzaʼa mnaghunata, ka nda mbrakwa wa ta maga yu ta tsa skwiha ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mantsa, ka nzatá Yesu ka mna gwaɗa ŋa taŋ nda mahdihdi, kaʼa mantsa: «Mamu sana mndu ta sliʼafta ka laghwi da ŋaɓaftá fuha inabi ndər ndər ndər ma vwahani, ka ŋamtá tsi ma dzugur. Ka laptá tsi ta vli ŋa ɗitsa yakwani. Ka bamtá tsi nduk nda dumbi nda slra tani mida ŋa nzakwa mnda nghay. Tahula kɗiŋtani ta payanatá tsa vwahani ya ɗina, ka fanamtá tsi ma dzvu ta gwal hvay. Ka sliʼaftá tsi ka laghwi dista luwa. ");
INSERT INTO xed_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sagha fitika ɗaga yakwani, ka ghunadaghatá tsi ta sana kwalvani slanaghatá tsa gwal ta hvay ya ŋa mutsanafta taŋ ta ŋani ma yakwa tsa inabi ya. ");
INSERT INTO xed_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Laghani, ɗiŋ ksafksa həŋ ka ɗgaptá, ka vriŋta kul vlaŋta. ");
INSERT INTO xed_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka ghungladaghatá tsi ta sana kwalva slanaghatá həŋ guli, ka tatanaghatá həŋ ta ghəŋ ka rarazata. ");
INSERT INTO xed_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka ghungladaghatá tsa mnda vwah ya ta mahkəna kwalva, ka dzatá həŋ nda dza ta tsaya. Ka ghungladaghatá tsa mnda vwah ya ta sanlaha ma kwalvaha guli, ka ɗgaptá həŋ nda ɗga ta sanlaha, ka pslatá həŋ nda psla ta sanlaha. ");
INSERT INTO xed_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ga va tsa mndu ya, mamu pɗakwa zwaŋani turtuktuk ta ɗvu tsi ma hya ŋuɗufani, ka kɗiŋtá tsi ta ghunadapta da tsa mnduha ya kazlay: Dzaʼa hulay həŋ tahula ta na zwaŋa ɗa na kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ka sliʼafta tsa zwaŋ ya ka lagha slanaghatá həŋ. “Ya wana tsa mndu dzaʼa za həga ya kaya! Sawa ka dzatá mu, ŋa zay amu ta tsa həga ya!” Ka tsa gwal ta hva tsa vwah ya mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɗiŋ ksafksa həŋ ka dzata, ka vzidiŋtá həŋ ta mblani diʼiŋ nda tsa fuha inabi ya. ");
INSERT INTO xed_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Ndana tama, nu dzaʼa magə dani ma tsa vwaha fuha inabi ya? Dzaʼa laghala, ŋa zaɗanatani ta tsa mnduha ta hva ma tsa vwah ya, ŋa vlaŋtani ta tsa fuha inabi ya ta sanlaha ma mnduha. ");
INSERT INTO xed_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ta dzaŋaf a kaghuni ta vindatani ma deftera Lazglafta manda ya kəʼa ta mnay ra? “Tsa pala wuɗidiŋ gwal ta ba həga ya, tsaya ta nuta ka vərɗa palaka tughwa həga. ");
INSERT INTO xed_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tsaya ná, Lazglafta ta ɗvaftá nzakwa tsa pala ya ka vərɗa palaka tughwa həga. Skwa ndərmimay nzakwani ta wa ira amu!”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsatsafta tsa maliha ya ná, ta ghəŋa taŋ ta gwaɗa Yesu ta tsa gwaɗa ya. Ka zbə həŋ ta tva ksafta, ama ka zlanatá həŋ ka laghwa taŋ kabga zləŋa gwaɗa da mnduha. ");
INSERT INTO xed_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka ghunaftá həŋ ta sanlaha mataba la Farisa nda mnduha Hiridus, ŋa dzaʼa gwaɗa nda Yesu, kada ɗakwatsafta lu ta gwaɗa ma wani ŋa ksafta. ");
INSERT INTO xed_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wya ka həŋ lagha mnay ŋani: «Maləma ɗa, nda sna ŋni kazlay: Dar gwaɗa ta mnə kagha kəʼa, haɗ kagha ta zləŋa ira mnduha wu, kabga haɗ ghuya gha nda mndu ta ghərɓakwani wa. Vərɗa nzaku manda ya ta kumə Lazglafta ta taghə kagha. Ta kumay ŋni ta ɗawaŋtá gwaɗa da kagha: Ma zlaha Lazglafta ná, nda ra re, ra a wa ka pla dzumna ŋa mgham dagala ma Ruma na? Dzaʼa plər pla a wa ŋni na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","«Kabgawu ta kəl kuni ka dzəgha iʼi na?» Ka Yesu zlghanaftawi ta həŋ, kabga nda sna ta tsa maɗgwirmaɗgwira taŋ ya. «Klagaghawakla ta tsa kwaɓu ya ka nghanata yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ka klanaktá həŋ turtuk. Ka ɗawaŋtá Yesu da həŋ. Kaʼa mantsa: «Nda wa grafta lu ta na skwi tsaf lu tida na na? Ŋa wa na hgu tida na guli?» kaʼa nda həŋ. «Ŋa mgham Sezar ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka Yesu nda həŋ mantsa: «Vlaŋwa mgham Sezar ta ya ta nzakway ka ŋa mgham Sezar, vlaŋwa Lazglafta ta ya ta nzakway ka ŋa Lazglafta,» kaʼa nda həŋ. Ka ndərmim həŋ katakata ta tsa zlghawani ya. ");
INSERT INTO xed_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ka sliʼadaghatá la Sadukiya slanaghata Yesu guli. Hahəŋ ná, gwal ta mnay kazlay: Haɗ sliʼagabta mndu ma mtaku wu kəʼa ya həŋ. Ka ɗawaŋtá həŋ da tsi, ka həŋ nda tsi mantsa: ");
INSERT INTO xed_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Maləma ɗa, wya ka Musa vindaŋnafta: “Ka mamu mndu mtu zwaŋamani ka zlaŋtá markwa taŋ, ya a ta zwaŋ nda tsa marakw ya wu katsi, wunanaghata tsa zwaŋamani ta ndiri ya ta tsa wadgani ya, ŋa yanatani ta zivir ta tsa zwaŋamani ta mtuta ya,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","«Tsaw ghalya, si mamu zwanama ndəfáŋ həŋ ma da taŋ. Si ka klaftá zumali ma həŋ ta marakw, ka mtutá tsa mndu ya ta yana a lu ta zwaŋ wa, ");
INSERT INTO xed_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ka wunanaghatá tsa mahisa zwaŋ ya ta tsa wadgu ya, ka mtutá tsaya guli, yana a lu ta zwaŋ wa. Mantsa ya tsa mahkəna zwaŋ ya guli. ");
INSERT INTO xed_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Inda tsa zwaniha ya ndəfáŋ ndəfáŋ, ka raftá həŋ ta tsa marakw ya, kul haɗ ya ta yatá zwaŋ nda tsi. Tahula rwuta tsa zwaniha ya ndəfáŋ ndəfáŋ, ka mtuta tsa marakw ya guli. ");
INSERT INTO xed_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mantsa tama ní, baɗu sliʼagabta ma mtaku nda hafu ní, ŋa wa ŋa wa dzaʼa nzakwa tsa marakw ya mataba taŋ baɗu tsaya tama, ya wya klafkla həŋ demdem ta tsa marakw ya ka markwa taŋ?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka Yesu zlghanaftawani ta həŋ mantsa: «Ta nanay kuni ta ghəŋ. Kabgawu kəl yu ka mnay mantsa? Sna a kuni ta skwi nda vinda ma gwaɗa Lazglafta wu, sna a kuni ta mbrakwa Lazglafta guli wa. ");
INSERT INTO xed_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tahula sliʼagapta ma mtaku nda hafu ná, ta haɗ kluvtá vgha i marakw nda zəʼal wu, dzaʼa nzanza həŋ manda duhwalha Lazglafta ta luwa. ");
INSERT INTO xed_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta ghəŋa gwaɗa ta vragapta ma mtaku nda hafu ya ná, ta dzaŋaf a kuni ta tsa vli ta ghəŋa mubuk nda vu tida ma deftera Musa ya ra? Ka Lazglafta nda Musa hada na: “Iʼi Lazglafta Abraham, iʼi Lazglafta Izak, iʼi Lazglafta Yakubu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hahəŋ ná, ta nda hafu həŋ, kabga Lazglafta ná, Lazglafta gwal nda rwa a wu, ama Lazglafta gwal nda hafu ya. Ta nanay kuni ta ghəŋa ghuni katakata,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma tsa vli ya, mamu sana mndu mataba gwal tagha zlahu ŋa mnduha ta sna tsa skwi ta zlərɗə i Yesu nda la Sadukiya ya. Nghayni ná, ɗina tsa zlghatá wa Yesu ŋa taŋ ya. Ka sliʼafta tsi ka gavadaghata tavata Yesu da ɗawaŋta. Kaʼa mantsa: «Wati mali ma inda zlahuha na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Yesu nda tsi mantsa: «Wya mali mida: Snawa ɓa la Israʼila! Mgham ta nzakway ka Lazglafta ná, tsatsi turtuktuk Mgham. ");
INSERT INTO xed_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mantsa tama, ka ɗvuta ka ta Mgham ta nzakway ka Lazglafta gha nda hyahya ŋuɗufa gha, nda inda hafa gha, nda inda ndana gha, nda inda mbrakwa gha. ");
INSERT INTO xed_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wya mahisani: “Ka ɗvuta ka ta mnda səla manda va ɗvuta gha ta ghəŋa gha.” Mataba inda zlahuha ná, haɗ zlahu ta malaghutá tsahaya wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka tsa mndu ta tagha zlahu ŋa mnduha ya nda tsi mantsa: «Zɗa tsa mghama ɗa. Kahwathwata tsa mnə ka kazlay: Turtuktuk Lazglafta kəʼa ya, haɗ sani ɗekɗek ta ghəŋa tsatsi wa. ");
INSERT INTO xed_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Haɗ taɓta ɗvuta mndu ta Lazglaftani nda hyahya ŋuɗufani, nda inda ndanani, nda inda mbrakwani, nda ɗvutani ta mnda səla manda va ɗvutani ta ghəŋani wa. Malaghumala tsaya ta ghəŋa skwi nda səla ta drafta lu tsuhtsuh ta gwir. Malaghumala guli ta planatá ghəŋ ta plu lu nda hamata skwiha nda ya nda rini ta vlaŋta lu manda ya ɗawaŋ zlahu,» ka tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nghanata Yesu ta tsa zlghawani ya ná, mamu ɗifil mida. Kaʼa nda tsi mantsa: «Diʼiŋaghu a ka nda ga mghama Lazglafta wa,» kaʼa. Haɗ mndu ta dərglaftá ŋuɗuf ka ɗawgəltá vli da tsi tahula tsa wa. ");
INSERT INTO xed_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka kɗə Yesu ta tagha skwi ŋa mnduha ma həga Lazglafta. Wya kaʼa ta mnay: «Kurki gwal tagha zlahu ŋa mnduha ta mnay kazlay: Kristi ná, zwaŋa Dawuda ya kaʼa na? ");
INSERT INTO xed_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ya wya ka vərɗa Dawuda pghafər Sulkum nda ghuɓa mnata: “Ka Mgham Lazglafta mnanatá Mghama ɗa na: Nzanza gha nda ga zeghwa ɗa ha ka sagha fitik dzaʼa niŋta yu ta ghumaha gha ka skwa diŋlay gha, ” kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ya “Mghama ɗa ka,” ka vərɗa Dawuda ta hgay ní, wa kəʼa nzəglaku ka zwaŋani tama?» kaʼa guli. Tsa skwi ta taghə Yesu ya na, zɗəganazɗa ta tsa dəmga ta snay ya. ");
INSERT INTO xed_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wya kaʼa nda həŋ ma tsa skwi ta taghə tsi ya. «Ɗaswa ka kuni nda gwal tagha zlahu ŋa mnduha! Hahəŋ ná, nda lgutha zutututa zɗəganata wawaku ta həŋ. Zɗəganazɗa ganaghatá zgu ta həŋ ta luma. ");
INSERT INTO xed_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta zbay həŋ ta vla nzaku ta kəma ma həga ta kəl lu ka tagha skwa la Yahuda. Vla nzaku ɗina ta zbə hahəŋ ma vla za skwa zay guli. ");
INSERT INTO xed_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Hahəŋ gwal ta dghwaɗguduŋtá skwa la wadgu. Zɗəganazɗa slriŋtá maga duʼa ta həŋ ta kəma mnduha ŋa ghubaŋtá həŋ. Dzaʼa tsanaghatsa lu ta guma ta həŋ katakata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tahula tsa, ka nzatá Yesu mbəŋ nda akwata pgha tsedi ma həga Lazglafta, ka nghay ka mnduha ta pgha tsedi dida. Nda ndəgha la gadghəl ta va pghadatá tsedi. ");
INSERT INTO xed_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka lagha sana markwa wadgu ka pɗu guli, ka pghadatá tsi ta aneni his kul slaghuta ka sana skwi. ");
INSERT INTO xed_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mantsa tama, ka hagaŋtá Yesu ta duhwalhani, kaʼa nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, tsedi pghada ya markwa wadgu ya da ya skwi ya ná, mal ŋani ka ŋa pɗakwa mnduha, ");
INSERT INTO xed_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kabga sanlaha ná, ma fərta tani da həŋ klaʼata həŋ ka pghadata. Ama tsa marakw ya ná, kɗavakta skwi ma ŋa zayni ga taŋ klaf tsatsi ka pghadata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ma fitika saba i Yesu ma həga Lazglafta, ka sani mataba duhwalhani nda tsi mantsa: «Mghama ɗa, ngha ta glakwa na pala na ɓa! Nghana ka ta glakwa bata na həga na ɓa!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka Yesu nda həŋ mantsa: «Nda ngha ka ta glakwa batá na həga na kiʼe, haɗ nzugwatá pala dər turtuk dzaʼa pɗata wa, dzaʼa tasiŋtasa lu tesneʼ» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tahula tsa, ka sliʼaftá Yesu ka laghwi nzata ta ghwá zaytuŋ, ta nzakway mbəŋ nda həga Lazglafta, ka ksaghutá i Piyer nda Yakubu nda Yuhwana nda Andre nda ghəŋa taŋ ta Yesu ka ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Yawu dzaʼa magakwa tsa skwiha ya, ŋizla wu dzaʼa maraŋtá magakwa inda tsa skwiha ya na? Mna gwanaŋna mna,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka zlraftá Yesu ta mnay ŋa taŋ, kaʼa nda həŋ mantsa: «Ɗaswa ka kuni yaha mndu da nanaghunafta. ");
INSERT INTO xed_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kabga nda ndəgha mnduha dzaʼa sliʼakta ka klaftá hga ɗa kazlay: “Iʼi Kristi,” ka inda taŋ dzaʼa mnay, ŋa nanaghata taŋ ta ndəghata mnduha. ");
INSERT INTO xed_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dzaʼa nda sna kuni ta mna gwaɗa ta lmu ndusa nda ya diʼiŋ, yaha ŋuɗufa ghuni tɗu, kabga dzaʼa magaku tsa skwiha ya, ama kɗavakta kɗakwa ghəŋa haɗik a tsa wa. ");
INSERT INTO xed_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dzaʼa lmay sana haɗik ta lmu nda sana haɗik, mantsa sana luwa nda sana luwa guli. Dzaʼa ghudzavafghudza haɗik ma vliha kavghakavgha. Dzaʼa slaku maya ta haɗik. Nda tsahaya dzaʼa zlra ghəŋa haɗik ta ɓasay manda marakw ta ɓasa yaku. ");
INSERT INTO xed_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kaghuni, ɗaswa ka kuni, dzaʼa hlay lu ta kaghuni da vla guma, dzaʼa ɗgay lu ta kaghuni nda sarak ma həga tagha skwa la Yahuda. Dzaʼa hladaghunagha hla lu ta kəma la ŋumna nda mghamha, kabga nzakwa ghuni ka duhwalha ɗa. Hada dzaʼa maraŋta kuni ta nzakwa ghuni ka masləmtsəka ɗa ta kəma taŋ. ");
INSERT INTO xed_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wya skwi dzaʼa magaku karaku: Dzaʼa nzakway tkweʼ ka mnanaŋtá mnduha ta ghəŋa haɗik tender ta Lfiɗa Gwaɗa Lazglafta, kada kuɗuta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hlafta lu ta kaghuni ka hlaghata da vla guma ya, yaha kuni da laghwi da ndana skwi dzaʼa kuni mnay hada kazlay: Nu dzaʼa mu mnay tama, kaʼa. Ka nu dzaʼa sagha da ghəŋa ghuni ma tsa fitik ya, tsaya dzaʼa kuni mnay, kabga kaghuni a dzaʼa gwaɗay wa. Dzaʼa sagha da Sulkum nda ghuɓa skwi dzaʼa kuni gwaɗay. ");
INSERT INTO xed_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma tsa fitik ya ná, zwaŋamani dzaʼa vlatá zwaŋamani ŋa dzata, zwaŋani ŋa da dzaʼa vlata ŋa dzata, ta mbəɗavatá zwani tvə dadaha taŋ nda mamaha taŋ ŋa vlatá həŋ ŋa pslata. ");
INSERT INTO xed_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dzaʼa husaŋhusa kuni ta inda mnduha, kabga nzakwa ghuni ka duhwalha ɗa, ama mndu ya dzaʼa kɗanakta suʼafta dzaʼa mbaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ma sana fitik dzaʼazlay, dzaʼa nda ngha kuni ta manzakɗaway ta ŋriŋta skwa Lazglafta dzaʼa nzata ma vli má si kul raku. Ka havapta mndu nda sna ta dzaŋa. Mantsa guli, ka nda ngha gwal hadna ma Zudiya ta tsa skwi ya katsi, ka hwaya həŋ ta ghwá. ");
INSERT INTO xed_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ka ta nzaku mndu ta bɗəma həga, yaha da ndana valagata ŋa vru da həga kabga ŋa klaftá sana skwi, ka hwaya tsi ta hwaya. ");
INSERT INTO xed_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mndu ya ma vwah guli, yaha da ndana vrakta dzagha ŋa klaftá lgutani. ");
INSERT INTO xed_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ghuya ɗaŋwa dzaʼa slanaghatá miʼaha nda huɗi nda gwal nda zwani ta ghuva taŋ ma tsa fitik ya! ");
INSERT INTO xed_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ndəɓawa dzvu da Lazglafta, kabga yaha tsa skwiha ya slata givya. ");
INSERT INTO xed_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ka yawu tsatá ghəŋa haɗik ka sagha ta gita, ta sla a mndərga tsa ghuya ɗaŋwa dzaʼa slata ma tsa fitik ya wu, sləglata a vani guli wa. ");
INSERT INTO xed_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ka má fa a Lazglafta ta htanaktá tsa fitik ya wu katsi, ma haɗ mndu dzaʼa mbafta wa. Ama dzaʼa htanaghuhta ta tsa fitik ya, kabga gwal ɗagap tsi ŋa nzaku ka ŋani. ");
INSERT INTO xed_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ka “wana Kristi hadna,” “aʼ waʼa Kristi hada a,” ka mndu nda kaghuni katsi, yaha kuni da snay, ");
INSERT INTO xed_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","kabga dzaʼa sliʼagaghasliʼa ghwaɗaka la krista nda ghwaɗaka anabiha. Dzaʼa magay həŋ ta ŋizla sana skwiha nda mazəmzəmha ŋa nana ɗagatá mnduha Lazglafta, ka má ta magaku tsi. ");
INSERT INTO xed_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaghuni, ɗaswa ka kuni. Wya mnaghunamna yu ta tsekeʼluwa ta inda skwi dzaʼa magaku demdem. ");
INSERT INTO xed_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Tsa fitik dzaʼa sagha tahula ghuyapta lu ta tsa ɗaŋwa ya, dzaʼa mtumta fitik, haɗ tili dzaʼa ɓəglafta wa. ");
INSERT INTO xed_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dzaʼa rkaga rka tekwatsa ta luwa, ta dzaʼa ghudzavafghudza mbrakwa sana skwiha ta luwa. ");
INSERT INTO xed_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma tsaya tama, dzaʼa nghaŋta lu ta saha Zwaŋa mndu nda mbraku ma ghwayak, ta wuɗaku katakata ma glakwani ta saha tsi dzaʼazlay. ");
INSERT INTO xed_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ghwanafha ta duhwalha Lazglafta, ŋa sliʼa taŋ ta kɗavakta ghəŋa haɗik tender, kulam ta slrəŋa luwa, ŋa tsakaktá mnduhani ɗagab tsi. ");
INSERT INTO xed_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Nghawa skwi ta magaku nda ghuraf ɓa! Ka nda ngha kuni ta ghuraf ta ɗaku katsi ná, gi nda sna kuni kazlay: Ndusa dəwiŋ tama kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mantsa ya guli, ka nda ngha kuni ta tsa skwiha ya ta magaku katsi ná, ka snaŋta kuni kazlay: Ta tvi səla Zwaŋa mndu ka saha tama kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kahwathwata ka yu ta mnaghunata, haɗ na mnduha ta na zamana gita na dzaʼa kɗuta ɗekɗek kul slatá tsa skwiha ya wa. ");
INSERT INTO xed_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Luwa nda haɗik ná, dzaʼa kɗu kɗa. Ama gwaɗa ɗa ná, haɗ dzaʼa kuɗuta wa. Nzawanza hzleŋa, yaha kuni hani. ");
INSERT INTO xed_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ta ghəŋa gwaɗa ta tsa fitik ya ná, haɗ mndu nda sna ka ta wati luwa tsi wa. Dər duhwalha Lazglafta ta luwa, dər zwaŋani, sna a həŋ wa. Ba Da turtukwani yeya nda sna ta tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɗaswa ka kuni! ka nzata kuni hzleŋa nda fatá ghəŋa ghuni, sna a kuni ka yawu dzaʼa sagha tsa fitik ya wa. ");
INSERT INTO xed_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tsa skwi ya ná, dzaʼa nzakway manda zəʼala həga ta vrakta ta za wliwani. Ma sliʼani, ka zlaŋtá tsi ta həgani ma dzva gwal ksanatá slnani, daganafha ta slna taŋ ta həŋ. Ka ngha ka ta həga, kaʼa nda mnda ngha həga, ka nzata ka hzleŋa, kaʼa guli. Ka sliʼaftá tsi ka laghwi. ");
INSERT INTO xed_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kaghuni guli, hzleŋa fata ghəŋa ghuni kabga snaŋta a kuni ka ta wani luwa dzaʼa sagha zəʼala həga wa. Ka gahawu tsi, ka ma takala tsi, ka ta waha vazak tsi, ka gasərɗək a dzaʼa sagha tsi, haɗ mndu nda sna wa. ");
INSERT INTO xed_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ɗaswa ka kuni da sagha tsi dluk slaghunaghata pslapsla hani ta kaghuni. ");
INSERT INTO xed_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Manda va na ta mnə yu ŋa ghuni na ná, mantsa ya ta mna yu ŋa inda mnduha kazlay: Hzleŋa ka kuni fata ghəŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ta his fitik ka sagha fitika skala Pak, nda skala buradi kul haɗ is mida, ka zbu gwal dra skwi ŋa Lazglafta nda gwal tagha zlahu ŋa mnduha ta hiɗaku ŋa ksaftá Yesu ma kɗek ma kɗek ŋa klay dzata. ");
INSERT INTO xed_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«Yaha da nzakway baɗu tsa fitika skala Pak ya tama, kabga ka baɗu tsa ka mu ksay katsi ná, ka waya ka skwi da sliʼanaftá mnduha ta hwanzaɓaku,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma luwa Betani Yesu ta nzaku ka za skwa zay ma həga ga Simuŋ si nda rɗa mndu tida ya, ka lamə sana marakw slanaghata nda klatá hwaraka Albastra ndəghamə tsi ta urda sana fu ta hgu lu ka Nar. Nda bla dzva tsa urdi ya katakata. Ka ɓlaghutá tsi ta wa tsa hwarak ya, ka bərzləganatá tsa urdi ya ma ghəŋ ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka kuzlanaftá tsi ta sanlaha ta ŋuɗuf, ka ruruŋwaku həŋ ta ruruŋwaku. Ka həŋ mantsa: «Kabgawu ta kəl lu ka badza urdi ka bətbət na? ");
INSERT INTO xed_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ta skwi má ŋa klafta ka skwapta ŋa mutsaftá suley hkən dərmək, ka daganaftá gwal pɗu ná,» ka həŋ ka ɓasanavatá ŋuɗuf ta tsa marakw ya, ka davay. ");
INSERT INTO xed_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama ka Yesu nda həŋ mantsa: «Kabgawu ta kəl kuni ka ghuya ɗaŋwa ŋa tsa marakw ya? Zlanawa zla, ŋərma skwi tsa skwi ya magiha tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gwal ka pɗuha ná, kawadaga həŋ nda kaghuni inda fitik, laviŋlava kuni ta vla skwi ŋa taŋ dər yawu tsi manda ya ta kumə kuni. Iʼi ná, gɗavata a yu tavata kaghuni wa. ");
INSERT INTO xed_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kɗavakta ŋərma skwi kura tsi, maga tsi. Rɗi má ŋa masaɗivata baɗu dzaʼa ɗa da haɗik, tsaya na masaɗiva tsi na. ");
INSERT INTO xed_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kahwathwata ka yu ta mnaghunata, inda vli dzaʼa mnə lu ta Lfiɗa Gwaɗa Lazglafta ma ghəŋa haɗik tender, dzaʼa rusay lu ta skwi maga na marakw na, ŋa hava na marakw na.» ");
INSERT INTO xed_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ka sliʼaftá Zudas Iskaryut. Tsatsi ná, tekw mataba duhwalha ghwaŋpɗə his, Ka laghu tsi da slanaghatá gwal dra skwi ŋa Lazglafta. «Dzaʼa vlaghunavla yu ta Yesu ma dzva ghuni,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tahula mnanatani ta tsa gwaɗa ya ta həŋ, ka rfu həŋ ta rfu. «Dzaʼa vlaghavla aŋni ta tsedi guli,» ka həŋ nda tsi. «Yaw,» ka Zudas. Tahula tsa tama, ka ŋavata Zudas ka psa tvi dzaʼa kəl tsi ka vlaŋtá Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Baɗu tsa taŋtaŋa fitika skala skwa zay kul haɗ is mida ya, baɗu tsaya ta hna lu ta tuwak ŋa maga tsa skala Pak ya. Ka duhwalhani nda Yesu mantsa: «Ga ta kuma ka ta payafta mu ta vli ŋa maga skala Pak na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ka ghunaftá tsi ta gwal his mataba duhwalhani. Kaʼa nda həŋ mantsa: Lawala da huɗa luwa, dzaʼa guyaku kuni nda sana mndu ta kla bzleghwa imi, ka dzaʼa kuni mistani. ");
INSERT INTO xed_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ka dzaʼa lamə da həga ga tsi ya ná, ka mnanatá kuni ta zəʼala həga ma tsa həga ya kazlay: Ga tsa vli dzaʼa kəl yu ka za skwa zay ŋa skala Pak kawadaga nda duhwalha ɗa ya na? ka mghama ŋni, ka kuni dazlay nda tsi, ŋa maraghunatani. ");
INSERT INTO xed_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya dzaʼa maraghunamara ta vli ma sana dzuguvi ta ghəŋa sana həga nda payatá inda huzlaha mida. Hada dzaʼa payamafta kuni ta skwi ŋa za skwa zay ŋa skala Pak, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ka sliʼafta tsa duhwalha ya, ka laghwi da huɗluwa, ka slafta həŋ ta inda tsa skwiha ya, manda va ya mnanaf Yesu ta həŋ. Ka datá həŋ ta skwa zaya skala Pak hada. ");
INSERT INTO xed_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gahawu tama, ka lagha tsi kawadaga nda duhwalhani ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nda nza nzakwa taŋ tama ta za skwa zay həŋ, ka Yesu mantsa: «Kahwathwata ta mnaghunata yu, mamu mndu turtuk mataba ghuni ta zə mu ta skwa zay kawadaga nda tsi, dzaʼa vlatá iʼi ma dzva mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rəmasas ka vgha taŋ. «Iʼi a wu suʼu na? Iʼi a wu suʼu na? Iʼi a wu suʼu na?» ka həŋ turtuk turtuk nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","«Mndu turtuk mataba na kaghuni ghwaŋpɗə his ta zə mu ta skwa zay ma hliba turtuk na tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wya teʼuwa, Zwaŋa mndu ná, dzaʼa mtaku manda ya nda ghada vindatani ma gwaɗa Lazglafta. Ama ɗaŋwa ŋa mndu dzaʼa vlata Zwaŋa mndu ma dzva mnduha ŋa dzata. Dər ya má kwal lu yatá tsa mndu ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ta zə həŋ ta skwa zay, ka klaftá Yesu ta tsa buradi ya, ka rfanaghatá tsi ta Lazglafta, ka ɓalanaftá tsi ta həŋ. Kaʼa nda həŋ mantsa: Nanana ná, sluʼuvgha ɗa ya, zlghawazlgha, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tahula tsa, ka klaftá tsi ta leghwa ka rfanaghatá tsi ta Lazglafta, ka vlaŋtá tsi ta həŋ. Ka zlghaftá həŋ ka ŋaŋaʼata demdem. ");
INSERT INTO xed_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kaʼa nda həŋ mantsa: «Nanana na usa ɗa ya. Nana usa ɗa ná, dzaʼa pghupgha ŋa slərɓa zughu mataba mnduha demdem nda Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kahwathwata ta mnaghunata yu, haɗ yu dzaʼa səglaŋtá ima yakwa fwa inabi ha ka labə ta fitik dzaʼa kəl yu ka sa lfiɗani ma ga mghama Lazglafta wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ka fafanaftá həŋ ta laha zləzlva Lazglafta, ka sliʼaftá həŋ ka dzaʼa ta ghwá zaytuŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ta labə həŋ ta tvi, ka Yesu nda həŋ mantsa: «Dzaʼa hwahwayaghu hwahwaya kuni ka zliɗivata,» kaʼa nda həŋ. Wya teʼuwa nda vinda da Lazglafta kazlay: Dzaʼa dzadza yu ta mnda ngha tuwak, ŋa gazlaghuta tuwakha kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","«Dzaʼa dzadza lu ta iʼi, ama tahula sliʼagabta ɗa, dzaʼa tiŋlaghutiŋla yu ta ɓhadaghata da Galili ka kaghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka Piyer nda tsi mantsa: «Dər hwahwayaghuta lamndu ka zlavaghata, iʼi, zlavaghata a yu ɗekɗek wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ka Yesu nda tsi guli mantsa: «Kahwathwata ka yu ta mnaghata wa, ta vana rviɗik gita u ná, ma kɗaku vazak ka wahata kamahis, dzaʼa mnamna vərɗa kagha hkən səla kazlay: Sna a yu ta na mndu na wu kəʼa.» ");
INSERT INTO xed_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ama ka Piyer vrəgliŋtá zlghanaftawi nda mbraku nda mbraku mantsa: «Dər má ŋa dzatá iʼi kawadaga nda kagha tsi, haɗ yu dzaʼa mnay kazlay: Sna a yu ta kagha wu kəʼa wu,» kaʼa nda tsi. Manda va tsaya, ka pɗakwa sanlaha nda tsi guli. ");
INSERT INTO xed_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ka ɓhadaghatá həŋ da sana vli ta hgu lu ka Getsemene. Lagha taŋ da tsa vli ya, «nzawanza hadna ta dzaʼa yu da maga duʼa,» ka Yesu nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka hganaʼatá tsi ta i Piyer nda Yakubu nda Yuhwana kawadaga nda tsi. Ta mbəɗap a həŋ ta səla wu ná, ka ksaftá zləŋ ta Yesu ka ghuyay ma vgha. ");
INSERT INTO xed_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kaʼa nda həŋ mantsa: Tɗatɗa ŋuɗufa ɗa katakata ta kuma dzihata, nzawanza hadna ndiri, kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tahula tsa ka mbəɗaptá tsi ta səla dauʼ manda a, ka zləmbatá tsi ta haɗik, ka ndəɓə tsi ta dzvu da Lazglafta: Ka má ta magaku tsi katsi ná, ka laghula na ghuya ɗaŋwa na ta ghəŋa ɗa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kaʼa guli: «Aba, Da, haɗ skwi kul laviŋtá ka ta magay wa, kliŋkla ta na gruma dzaʼa yu say na! Nziyanza tsi tama, manda ya ta kumə iʼi a wa, ama ka nza tsi manda ya ta kumə kagha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ka sliʼaftá tsi ka vrakta slanaghatá duhwalhani, ka slanaghatá tsi ta həŋ ta hani. Kaʼa nda Piyer mantsa: «Simuŋ, ta hani ka ra? Laviŋ a ka ta nzɗavata ta nzaku ndiri dər ka kiʼa ra! ");
INSERT INTO xed_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nzawanza ndiri, ka ndəɓa kuni ta dzvu yaha kuni da zləmbamta ma ghwaɗaka skwi dzaʼa dzghaghunata,» kaʼa nda Piyer. «Nda sna yu ta kumay ŋuɗufa ghuni ta maga skwi ɗina, ama haɗ mbrakwa sluʼuvgha wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ka vrəglaghutá tsi da maga duʼa manda va tsa ya kay guli. ");
INSERT INTO xed_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka sliʼiglaftá tsi ka vrəglakta slanaghatá həŋ. Ta vraktá tsi ná, ta zuŋura hani həŋ kay guli. Ka sliʼanaftá tsi ta həŋ. Triɗ traptra həŋ ta skwi ŋa mnanata, kabga nda ghuya həŋ da hani. Ka vrəglaghutá tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ka vrəglaktá tsi ŋa mahkəna səla, kaʼa nda həŋ mantsa: «Tata hani kuni ka mbiʼa vgha ghuni tama ɓa? Nda kɗa, nda maga fitikani tama. Wana vlaŋvla lu ta Zwaŋa mndu ma dzvu ta gwal dmaku. ");
INSERT INTO xed_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sliʼafwasliʼa, mbaɗma guya həŋ, wya ndusakta tsa mndu ta vlatá iʼi ma dzva taŋ ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tata tsa gwaɗa ya Yesu, ta lagha Zudas ta nzakway tekw mataba duhwalha ghwaŋpɗə his. Ka lagha tsi kawadaga nda tskatá mnduha, nda huzla lmu da həŋ da slanaghatá Yesu. Tsa mnduha ya ná, ghunatá mnduha mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, nda la galata mndu ya. ");
INSERT INTO xed_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tsa Zudas ya ná, tsatsi ta vlaŋtá həŋ. Tiŋlaghutiŋla ta mnanatá həŋ kazlay: Ka nda ngha kuni ta tsa mndu dzaʼa lagha yu da brusata ya ná, ya vani tsaya. Ka gi ksafta kuni, ka kla kuni, yaha kuni da walaŋta zliŋta, kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ɓhadaghatani, ka gavadaghatá tsi tavata Yesu. «Zgu tsa Maləma ɗa,» kaʼa ganaghatá zgu ka brusay. ");
INSERT INTO xed_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ka gi sliʼadaghatá tsa mnduha ya ksaftá Yesu. ");
INSERT INTO xed_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka gi tshagaptá sana mndu tavata Yesu ta kafayani, ka gi tsaghutá sləməŋa sani ma kwalva tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya. ");
INSERT INTO xed_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka Yesu nda həŋ mantsa: «Nya ta maguta kəl kuni ka sliʼagaghata nda huzla lmu da ksa iʼi, gənda yu ra? ");
INSERT INTO xed_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ya wya kawadaga yu nda kaghuni ta tagha skwi ma həga Lazglafta tazlay, hada kaghuni, kabgawu kwal kuni ksaftá iʼi? Wya nana skwi ta magaku na ná, ŋa nzakwani manda ya mna gwaɗa Lazglafta ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka hwahwayaghutá duhwalha Yesu ka zlanavata. ");
INSERT INTO xed_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka sliʼaftá sana galaɓay ka mbaɗa mistani, nda tsatá gwada ta vghani, ka kumə lu ta ksafta, ");
INSERT INTO xed_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ama ka slurtiŋtá tsi ta lgutani ka hwayaghuta ka fərdiʼu. ");
INSERT INTO xed_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ka klaghatá həŋ ta Yesu da mala gwal dra skwi ŋa Lazglafta. Hada, ka tskavatá inda gwal ta dra skwi ŋa Lazglafta, nda la galata mndu tani, nda gwal tagha zlahu ŋa mnduha tani, ka tskavatá həŋ. ");
INSERT INTO xed_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta klə həŋ ya, mbaɗaka Piyer ka mbaɗa ta hulani ta hulani, ha ka lamə tsi da daɓa tsa həga ga mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta ya. Ka nzatá tsi hada ka slina vu kawadaga nda kwalvaha. ");
INSERT INTO xed_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mbaɗa maliha ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tsa guma, ka zba skwi dzaʼa kəl lu ka mutsaftá rutsak nda inda tsakalawi ta ghəŋa Yesu, kabga ŋa mutsaftá dzata, triɗ mutsaf a həŋ wa. ");
INSERT INTO xed_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nda ndəgha gwal ta vaza rutsak ta Yesu mndani, ama la a tsa gwaɗa taŋ ya ta tva turtuk wa. ");
INSERT INTO xed_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka sliʼanaftá sanlaha ta gwaɗa ta ghəŋani. Kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Sniŋsna ŋni ta mnayni kazlay: «Dzaʼa tasiŋtá na həga Lazglafta baf lu nda dzvu na yu, ka vranafta ɗa ta bafta baɗu mahkən kul ksaŋtá mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kulam nda tsaya tani, la a tsa gwaɗa taŋ ya ta tva turtuk wa. ");
INSERT INTO xed_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ka sliʼaftá mal ta ghəŋa gwal dra skwi ŋa Lazglafta mataba tsa tskatá vgha mnduha ya. Kaʼa nda Yesu mantsa: «Nu kul zlghə kagha ta wa na skwi ta mnə mnduha ta kagha na katək na? Ari sna a wa a kagha na?» ");
INSERT INTO xed_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tsəriɗa, ka Yesu nzata, zlgha a ta wani wa. Ka ɗawuglaŋtá tsa mal ta ghəŋa gwal dra skwi ya da tsi. «Kagha Kristi ta nzakway ka Zwaŋa Lazglafta nda tfawi ta ghəŋani ya ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka Yesu zlghanaftá mantsa: «Aŋi, iʼi ya. Dzaʼa nda ngha kuni ta iʼi Zwaŋa mndu ta nzaku nda ga zeghwa Lazglafta nda mbra. Dzaʼa nghay kuni ta saha ɗa ma kusay ta luwa guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na snaŋta tsa mal ta ghəŋa gwal ta dra skwi ŋa Lazglafta ya ta tsa gwaɗa ya, ka kwahiŋtá tsi ta lgutani. Kaʼa nda həŋ mantsa: «Nu tata zbəgəlta mu? ");
INSERT INTO xed_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nda sna kuni ta tsa ŋaslani ya kiʼe, kinawu ka kaghuni ta ghəŋani?» kaʼa. Prək ka dzatá na mndu na, ka həŋ demdem. ");
INSERT INTO xed_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ka gi tafə sanlaha ta sərɗək tida, ka hbanamtá həŋ ta patak ma kuma, ka dəŋəzlay. Ka həŋ nda tsi mantsa: Tsatsaf tsatsa ta tsa mndu ta dzughusta ya, ka həŋ nda tsi. Ka vlaŋtá həŋ ta la kwalvaha, ka dghar tsahaya guli. ");
INSERT INTO xed_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tata nzaku Piyer ndagahaɗik ma daɓa həga, ka sagha sana marakw ta nzakway tekw mataba kwalvaha ka miʼaha ga mal ta ghəŋa gwal ta dra skwi ŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ka nghaŋtá tsi ta Piyer ta slina vu. Ka vits tsi, «Si kawadaga kagha nda tsa Yesu la Nazaret ya,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","«Kay! Sna a yu ta na skwi ta mnə ka na wu, sna a yu ta va na mndu ta mnə ka na guli wu,» kaʼa. Ka gi sliʼaftá tsi ka laghwi da dzuguva watgha. Ka wahatá vazak. ");
INSERT INTO xed_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka nghəglaŋtá va tsa marakw ya. Tekw nana mndu na mataba tsa mnduha ya, kaʼa nda tsa mnduha ma tsa vli ya kay guli. ");
INSERT INTO xed_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","«Kay! Iʼi a wu,» kaʼa kay guli. Ɓats nzɗa, ka tsa gwal ta nzaku hada ya nda Piyer kay guli mantsa: «Dər ki tsi, vara a kagha mataba tsa mnduha ya wu, kagha ná, mnda la Galili ka,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka zlraftá Piyer ta ksiʼa ghəŋani ka waɗu. Kaʼa mantsa: «Sna a yu ta na mndu ta mnə kuni na ɗekɗek wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ka gi wahatá vazak ka mahis. Snaŋta Piyer ta tsa wahata vazak ka mahis ya, hizl sagha tsa gwaɗa mnana Yesu kazlay: Ma kɗaku vazak wahata ka mahis ná, dzaʼa mnay ka kazlay: Sna a yu ta kagha wu kəʼa ya tsa da ghəŋani. Ka gi sliʼaftá tsi ka laghwi da hərɓa taw. ");
INSERT INTO xed_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tsaɗakwa vli, ka gi tskavatá maliha ta ghəŋa gwal dra skwi ŋa Lazglafta ka dzrəku kawadaga nda la galata mndu, nda gwal tagha zlahu ŋa mnduha, nda gwal tsa guma demdem. Ka habaftá həŋ ta Yesu. Ka klaftá həŋ ka laghwi vlaŋtá Pilat ka ŋumna. ");
INSERT INTO xed_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tahula kladaghata taŋ ta Yesu da Pilatus, ka ɗawaŋtá Pilat da tsi. Kaʼa mantsa: «Kagha mghama la Yahuda ra?» kaʼa nda tsi. Manda ya mna ka, ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka vazə maliha ta ghəŋa gwal dra skwi ŋa Lazglafta ta rutsakha kavghakavgha ta Yesu. ");
INSERT INTO xed_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka ɗawuglaŋtá Pilat da Yesu, «Mbəɗa a ka ra, ari sna a wa a ka ta na skwiha ta mnə həŋ ta kagha na na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tsəriɗ nzanza Yesu kul mbəɗanaghata dər ka turtuk. Ka vlaŋtá tsi ta ndanu ta Pilat. ");
INSERT INTO xed_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tsaw inda fitika skala Pak ya ná, ta snusna Pilat ta zlinistá mndu turtuk ma gamak ta həŋ. Mndu ɗawaŋ həŋ ta zlinista tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma tsa fitik ya, mamu sana mndu ta hgu lu ka Barabas, ksaf lu ka famta ma gamak kawadaga nda sanlaha ma mnduha, kabga dzata taŋ ta mndu ma vla zlərɗawi nda ŋumna. ");
INSERT INTO xed_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbaɗa dəmga ka sliʼadaghata da Pilatus, «Zliŋniszla ta mndu turtuk manda ya snu ka ta magaŋnata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","«Ta kumay kuni ta zlighunista ɗa ta mghama la Yahuda ra?» ka Pilat nda həŋ, ");
INSERT INTO xed_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","kabga nda sna ka mnay kazlay: Ka draku kladaghata maliha ta ghəŋa gwal dra skwi ŋa Lazglafta ta Yesu kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama mbaɗa maliha ta ghəŋa gwal dra skwi ŋa Lazglafta ka ŋavata, ka bara mnduha ŋa mnay taŋ kazlay: Zliŋnis Barabas, zliŋnis Barabas, kaʼa nda Pilatus. ");
INSERT INTO xed_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ka vrəgliŋtá Pilat ta ɗaway da həŋ: «Ka si mantsa tsi, nu ta kumə kuni ta magay ɗa nda na mndu ta hgu kuni ka mghama la Yahuda na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka hləglaftá həŋ ta wi: «Zləŋafzləŋa ta udzu, ka həŋ nda tsi.» ");
INSERT INTO xed_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ka Pilat nda həŋ guli mantsa: «Kabgawu, nahgani va ghwaɗaka skwi maga tsi? Ka hləglaftá həŋ ta wi nda mbraku, Zləŋafzləŋa ta udzu!» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tsa Pilat ya, ta kumay ta zɗanafta ŋuɗuf ta dəmga. Mantsa, ka zlinistá tsi ta Barabas ta həŋ, ta vlaŋtá tsi ta Yesu ma dzvu ta la sludzi ŋa slvanapta. Tahula tsa, ka zlanaŋtá tsi ta həŋ ŋa zləŋafta ta udzu. ");
INSERT INTO xed_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ka zlghaghutá sludziha ta Yesu ma dzva Pilatus, ka kladamtá həŋ, ta daɓi ma həga ma vla nzakwa Pilatus, ka hagadaghatá həŋ ta inda sludziha demdem, ka tskavata hada. ");
INSERT INTO xed_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ka suɗanavatá həŋ ta lguta ma mgham mgham ka dva. Ka ɗaftá həŋ ta teki ka wanamta ma ghəŋ manda zewzewa. ");
INSERT INTO xed_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ka gə həŋ ta zgu ŋani: «Zgu tsa mghama la Yahuda,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mbaɗaka həŋ ka dzay ta ghəŋ nda sarak guli, ka tafa sərɗək tida. Ka tsəlɓu həŋ ta tsəlɓu ta kəmani, manda skwi ŋa vla glaku ŋani. ");
INSERT INTO xed_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tahula hərfuta taŋ ta gagay, ka suɗaghutá həŋ ta tsa lguta dva má mgham mgham tida ya, ka suɗglanavatá həŋ ta vərɗa ŋani. Ka klagapta ka klaghata ŋa zləŋay ta udzu. ");
INSERT INTO xed_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ta labə həŋ ta tvi, ka guyatá həŋ nda sana mnda la Sireŋ ta hgu lu ka Simuŋ, dani ma i Alegzandra nda Rufus ta vrakta ta wawakwani. Ka mblanaftá həŋ ta kla tsa udza zləŋa Yesu ya. ");
INSERT INTO xed_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ka klaghatá həŋ ta Yesu da Gwalgwata. Tsa Gwalgwata ya na, manda mnay kazlay: Vla ghudzifa ghəŋ kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓhadaghata taŋ da hada, ka kumə həŋ ta sunustá ima inabi laɓanaf lu nda sana skwi ta hgu lu ka mur, ŋa htanaghutá kuzlakwa tsa ghuya ɗaŋwa ya, ama ka kwalaghutá Yesu ta say. ");
INSERT INTO xed_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Nzemndi təmbay vli ta zləŋaftá həŋ ta udza zləŋay, ka vzə həŋ ta vindima ŋa daguvustá lguthani. ");
INSERT INTO xed_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vindafha lu nda ta ghəŋani, ta ghəŋa skwi kəl lu ka tsanaghatá guma kazlay: Mghama la Yahuda kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ka zlaŋaftá həŋ ta gəndaha his ta sana udzuha tavatani, pal nda ga zeghwani, pal nda ga zlaɓani. ");
INSERT INTO xed_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mantsa ya kɗavakta skwi mnə gwaɗa Lazglafta kazlay: Nda mbəɗa mataba mbsaka gwal ta maga ghwaɗaka skwi, kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mbaɗa mnduha ta labə nda ta tsa tvi ya, ka gigɗa ghəŋ ka rarazay, «Yawa a wa! Dzaʼa tasiŋtasa yu ta həga Lazglafta ka bafta ɗa ma fitik hkən a ka ka kay ra. ");
INSERT INTO xed_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mbanaf mba ta ghəŋa gha kagha ka ghəŋa gha, ka saha ka ta na udza zləŋay na!» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mbaɗa maliha ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha ka manay guli: «Mbanafha ta sanlaha ná, ama triɗ laviŋ a ta mbanaftá ghəŋani wu,» ka həŋ mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","«Ka sasa Kristi Mghama la Israʼila ta na udza zləŋay na ndana tama, ka ngha ŋni, kada zlghafta ŋni nda ŋuɗufa ŋni!» ka həŋ. Mbaɗa tsa gwal zləŋaf lu kawadaga nda tsi ya guli ka razay. ");
INSERT INTO xed_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lafa fitik ɗək da ghəŋ, ka nutá vli tɗik ka grusl ta haɗik demdem, ha ka laha ta nzemndi hkən ta fitik hawa. ");
INSERT INTO xed_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Manda magatá nzemndi hkən, ka hgatá Yesu nda mbraku, kaʼa mantsa: «Eluhi, Eluhi, lama sabaktani?» kaʼa. Manda mnay kazlay: Lazglafta ɗa, Lazglafta ɗa, kabgawu zliɗivata ka na? kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Snaŋta sanlaha mataba tsa gwal hada ya ta tsa skwi mna tsi ya ná, ka həŋ mantsa: «Wya ta hga Iliya mnda Lazglafta ghalya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka gi sliʼaftá sani mataba taŋ ka hwayadapta klaftá susu, ka hbuŋta ta wa sarak. Ka tsughumamtá tsi ma ima inabi mastalaŋ, ka tsghədanaftá tsi ta Yesu ŋa sayni. Ta tsghə tsi ya, «Swidwa! Nghama ngha ka dzaʼa sasa Iliya da klagata ta na udza zləŋay na tsi, kaki tsi,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ama ka wahatá Yesu nda mbraku, ka sabə hafu mida. ");
INSERT INTO xed_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma va tsa fitik ya, ka tavaptá zlala ta watgha lamə da vli nda ghuɓa ma həga Lazglafta kuyar daga ta luwa dikw ta haɗik. ");
INSERT INTO xed_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma tsa vli zləŋaf lu ta Yesu ya, mamu sana mghama sludza la Ruma ta sladakta mbəŋ nda tsi. Manda nghaŋtani ta mndərga tsa klay Yesu ta hafu ya, kaʼa mantsa: «Kahwathwata, na mndu na ná, Zwaŋa Lazglafta ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mamu sana miʼaha ta sladakta diʼiŋ ka ngha tsa skwiha ta magaku ya guli. Mataba tsa miʼaha ya, mamu i Mari makwa ta Magdala, nda Salume, nda Mari mani ma i Yuses nda Yakubu ta tsneʼuwa ya. ");
INSERT INTO xed_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ma fitika si nzakwa Yesu ta ma luwa Galili karaku ná, si ta dzaʼa mistani tsa miʼaha ya ŋa maganatá slna. Si nda ndəgha sanlaha ma miʼaha ta sliʼadafta mistani da luwa Ursalima guli. ");
INSERT INTO xed_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Baɗu luma Madagala tsa fitik ya, ta kəl lu ka papaya skwiha, kabga dzaʼa lamla lu da sabat, ka nda dəɗa fitik. ");
INSERT INTO xed_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ka lagha Yusufu mnda luwa Arimate. Tsa mndu ya ná, ta mnay ta tughwa gwaɗaha. Tsatsi guli ná, ta kzla ga mghama Lazglafta. Ka draftá tsi ta ŋuɗuf, ka lagha slanaghatá Pilat ŋa ɗawaftá tvi ŋa dzaʼa kla mbla Yesu. ");
INSERT INTO xed_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka ndərmim Pilat ta tsa gi saba hafu ma Yesu misimmisim ya. Ka hgaŋtá tsi ta tsa mghama sludziha ya, ka ɗawaŋta da tsi kazlay: Nda kɗa fitika saba hafu mida ra? kəʼa. ");
INSERT INTO xed_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Manda snanamta tsa mghama sludzi ya, ka zlanaŋtá tsi ta tvi ta Yusufu ŋa dzaʼa kla mbla Yesu. ");
INSERT INTO xed_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ka skwatá Yusufu ta lguta wupay, ka klagata mbla Yesu ta udza zləŋay, ka mbsamta mida. Ka klaftá tsi ka laghwi famta ma kulu huhrap lu ma kluluh. Ka taŋwalaktá mghama klam, ka huŋta ta wa tsa kulu ya. ");
INSERT INTO xed_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta nzaktá i Mari makwa ta Magdala nda Mari mani ma Yuses, ka ngha vli dzaʼa kəl lu ka famta. ");
INSERT INTO xed_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Manda luta sabat, ka sliʼaftá i Mari makwa ta Magdala nda Salume nda Mari mani ma Yakubu dzawatá rɗa urdi ŋa dzaʼa masay ta mbla Yesu. ");
INSERT INTO xed_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ka sliʼafta həŋ, ka ɓhadaghatá həŋ mbessa vzlazlaŋ ta kulu gasərɗək baɗu dəmas. ");
INSERT INTO xed_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta labə həŋ ta tvi, ka həŋ mantsa: Wa dzaʼa taŋwalaghutá tsa klam ta wa tsa kulu ya tama? ka həŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ndusadaghata taŋ, kəʼa ka həŋ ná, taŋwalaghutaŋwala lu ta tsa mghama klam ya diʼiŋ nda wa tsa kulu ya. ");
INSERT INTO xed_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ka gi lamə həŋ da tsa kulu ya. Ka slanaghatá həŋ ta sana duhwal ta nzaku hada nda ga zeghwi, nda suɗatá ta lguta ŋusliŋ zutut ta vghani. Nghaŋta taŋ, mbaɗaka həŋ ka ghudzafta da zləŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","«Ma zləŋ kuni ta zləŋ, nda sna yu kazlay: Yesu mnda la Nazaret si zləŋaf lu ya ta psə kuni» kəʼa. Ta haɗ hadna wa. Sliʼafsliʼa nda hafu ka laghwi. Wana tsa vli si kəl lu ka fatá mblani ya. ");
INSERT INTO xed_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lawala da mnanatá i Piyer nda sanlaha ma duhwalhani kazlay: Tiŋəl tsatsi dzaʼa ɓhata ma Galili. Hada dzaʼa nghaŋta kuni manda ya si mnaghuna tsi, ka tsa duhwal ya nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka ndagaptá tsa miʼaha ya ma kulu, ka hwaya. Ta ghudzaku həŋ da zləŋ. Ka kwalaghutá həŋ ta mna tsa gwaɗa ya ŋa mndu, kabga nda ksa həŋ da zləŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Manda sliʼagabta Yesu gasərɗək baɗu dəmas, tiŋəl Mari makwa ta Magdala, ya ghzligiŋ tsi ta duhwalha halaway ndəfáŋ mida ya, marava tsi da tsi. ");
INSERT INTO xed_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ka sliʼaftá tsa marakw ya ka laghwi da mnay ŋa gwal si kawadaga nda Yesu, ta nzaku həŋ sasgama ka taw. ");
INSERT INTO xed_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wa a Yesu nda hafu, nda ngha iʼi nda ira ɗa, kaʼa nda həŋ. Ka kwalaghutá həŋ ta zlghaftá tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tahula tsa, ka maravatá Yesu ka sani ma mndu tskəm da duhwalhani his ta mbaɗa ta tvi ta dzaʼa tahula luwa. ");
INSERT INTO xed_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ka vraktá həŋ da Ursalima, ka rusu həŋ ŋa sanlaha. Ama ka kwalaghutá tsahaya ta zlghaftá tsa gwaɗa ya guli. ");
INSERT INTO xed_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tahula tsa guli, ka maravatá tsi ta kəma duhwalhani ghwaŋpɗə ndeŋ ta zə həŋ ta skwa zay. Ka davanaghatá tsi ta həŋ: Nu kul zlghaftá kuni ta gwaɗa tsa gwal ta nghaŋtá iʼi ta sliʼagapta ya, təŋtəŋa ghəŋa ghuni, kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kaʼa nda həŋ tama mantsa: Lawala ta ghəŋa haɗik tender, ka mna kuni ta Lfiɗa Gwaɗa Lazglafta ŋa inda mnduha. ");
INSERT INTO xed_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inda mndu dzaʼa zlghafta nda ŋuɗuf, ka maganaftá lu ta batem, dzaʼa mbaku. Ama mndu dzaʼa kwal kul zlghafta, dzaʼa tsanaghatsa Lazglafta ta guma. ");
INSERT INTO xed_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wya ŋizla dzaʼa maraŋtá gwal ta zlghaftá iʼi: Nda hga ɗa, dzaʼa ghazlay həŋ ta duhwalha halaway ma mnduha, dzaʼa gwaɗay həŋ ta sana Lfiɗa Gwaɗa. ");
INSERT INTO xed_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dər ksafha həŋ ta nahaɗik nda dzvu, dər suha həŋ ta gruma, haɗ sana skwi dzaʼa maganata tsi ta həŋ wa. Dzaʼa fafanaghafafa həŋ ta dzvu ta gwal kul ɗughwanaku, ŋa mbambafta taŋ, ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tahula mnanata Mgham Yesu ta tsa gwaɗa ya ta həŋ, ka klaghatá Lazglafta ta luwa, ka nzanatá tsi nda ga zeghwani. ");
INSERT INTO xed_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hahəŋ guli, ka sliʼaftá həŋ ka laghwi da mna tsa Lfiɗa Gwaɗa Lazglafta ya ma inda vli. Ka katu Mgham Yesu ta həŋ ma mna tsa gwaɗa ya, ŋlanaghaha ta tsa gwaɗa ya ta həŋ nda ma magay taŋ ta mazəmzəm.");
INSERT INTO xed_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ari ŋərma Tawfilus, nda ndəgha mnduha ta ŋavata ka vinda gwaɗa ta ghəŋa skwiha ta luta mataba ŋni. ");
INSERT INTO xed_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ka vindafta həŋ manda va skwi nghaŋ gwal ta nzakway ka masləmtsəka tsa skwi ya, ta nuta ka gwal mna gwaɗa Lazglafta daga taŋtaŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ka ŋavatá iʼi guli ka psa snaŋta ɗina ta skwiha ta luta daga taŋtaŋ ŋa vindaghafta nda tvani a mala ɗa Tawfilus, ");
INSERT INTO xed_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kada snaŋta ka ta kɗavakta vərɗa skwiha mutsaf ka ta tagha skwi ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mantsa tama, ma fitika nzakwa mgham Hiridus ta ga mgham ta haɗika Zudiya, mamu sana mndu ta dra skwi ŋa Lazglafta, Zakari hgani mataba mndəra la Abiya mndəra gwal ta dra skwi ŋa Lazglafta. Elizabet hga markwa taŋ ta sabi nda ma mndəra la Haruna. ");
INSERT INTO xed_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tuɗukwa mndu həŋ his his ta wa ira Lazglafta. Ta snay həŋ ta zlaha Lazglafta nda skwa dzahayhani, haɗ maslivinza ta ksaŋtá həŋ wa. ");
INSERT INTO xed_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mutsaf a həŋ ta zwaŋ ɗekɗek wa, kabga ka dzəghəŋ Elizabet, lula ima taŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ma sana fitik, ta maga slna tsa dra skwi ya Zakari ta kəma Lazglafta, kabga mbəɗagagha mbəɗa fitik ŋa magay mndəra taŋ ta tsa slna ya, ");
INSERT INTO xed_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ka zbaptá lu nda vindima ta Zakari ŋa lami da həga Lazglafta da dra urdi manda ya snu gwal ta dra skwi ŋa Lazglafta ta magay. ");
INSERT INTO xed_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Magatá tsa fitika dra urdi ya, ka sliʼaftá tsi ka lami da həga Lazglafta da dra tsa urdi ya, ta magə dəmga ta duʼa ma bli. ");
INSERT INTO xed_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Má tsa tama, gi ka zlagaptá duhwala Lazglafta ta kəma Zakari, ka sladata nda ga zeghwa tsa gwir ta drə lu ta urdi ya. ");
INSERT INTO xed_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Na gi nghaŋta Zakari, ka ghudzaftá tsi da zləŋ, sraw vghani. ");
INSERT INTO xed_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","«Ma zləŋ ka ta zləŋ Zakari, wana tsuʼaftsuʼa Lazglafta ta ndəɓa dzva gha. Dzaʼa yagha ya markwa ghuni Elizabet ta zwaŋa zgun ŋa tsanaftá gha ta hgani ka Yuhwana, ");
INSERT INTO xed_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","dzaʼa rfay ka ta rfu katakata, dagala gwal dzaʼa rfu ta ghəŋani guli. ");
INSERT INTO xed_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ka mndu dagala dzaʼa nzakwa tsi ta kəma Lazglafta. Haɗ dzaʼa sa ima inabi dər skwi ta ghuya mndu wa. Dzaʼa ndəghundəgha nda Sulkum nda ghuɓa daga ma huɗa mani. ");
INSERT INTO xed_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dzaʼa nda ndəgha zwana la Israʼila dzaʼa vranakta tsi da Lazglafta Mghama taŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta kəma ta kəma dzaʼa dzaʼa tsi nda slnani ta kəma Lazglafta nda Sulkum, nda mbraku manda ŋa Iliya ŋa dzranaftá nzaku mataba dadaha nda zwana taŋ, ŋa vranaktá ghəŋa gwal ta maga ghwaɗaka skwi ka ŋərma mnduha. Mantsa ya dzaʼa payafta tsi ta mnduha ŋa fata taŋ ta vgha ŋa Lazglafta,» ka tsa duhwala Lazglafta ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","«Waka yu dzaʼa snaŋtá skwi mantsa? Wana iʼi halata mndu yu, markwa ini guli nda hala,» ka Zakari nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka tsa duhwala Lazglafta ya zlghanaftawi mantsa: «Iʼi Gabriyel ya, ta sladu ta kəma Lazglafta ŋa maganatá slna. Tsatsi ta ghunigihata ŋa gwaɗgaghata, ka mnaghatá tsa Lfiɗa Gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndana tama, wana ka dzaʼa nuta ka rgha. Laviŋta a ka ta gwaɗa ha ka sagha fitika magata tsa skwiha ya wa, kabga zlghaf a ka ta tsa skwi dzaʼa magaku ma fitikani mnagha yu ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta nzatá mnduha ka kzla saba Zakari, sew sabə a wa. Ka ndanu həŋ ta ndanu: «Nu ta slanaghata ma həga Lazglafta tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Manda sabani, ka traptá tsi ta gwaɗa nda tskatá mnduha, gi ka tsatsaftá həŋ kazlay: Mamu mazəmzəm ta slanaghata ma həga Lazglafta kəʼa. Laviŋ a ta gwaɗa nda wi nda həŋ wu, mbaɗa ka mnay nda dzvu ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tahula kɗuta fitika maga slnani, ka sliʼaftá tsi ka laghwi dzaghani. ");
INSERT INTO xed_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nzɗava a tahula tsa wu, ka zlghaftá markwa taŋ Elizabet ta huɗi. Ka zatá Elizabet ta tili hutaf ta ɗifa vgha. Kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Zɗakatahuɗi ya magiha Mgham Lazglafta, ka skwa hula si nzakwa ɗa ta kəma mnduha ɗa, kabga ta ya a yu ta zwaŋ wa. Ama ka tawatá Lazglafta ta hiɗahiɗa ta iʼi ndana, ka klaghutá tsa hula ya ta ghəŋa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ta mamkuʼ a tilani, ka ghunaftá Lazglafta ta duhwalani Gabriyel da sana luwa ta hgu lu ka Nazaret ma haɗika Galili, ");
INSERT INTO xed_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","da sana daghali ta hgu lu ka Mari ta dzugu sana mndu Yusufu hgani ta sabə nda ma mndəra la Dawuda. ");
INSERT INTO xed_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka lamə tsi slanaghata: «Zgu tsa, tfaghaghatfa Lazglafta ta wi katakata. Kawadaga Mgham Lazglafta nda kagha,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kɓanafta tsa gwaɗa ya ta Mari, «nu mndəra nana ma ga zgu tama,» kaʼa ma ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka duhwala Lazglafta nda tsi mantsa: «Ma zləŋ ka ta zləŋ Mari, zbapzba Lazglafta ta kagha ka tfaghaghatawi. ");
INSERT INTO xed_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wana dzaʼa zlghafzlgha ka ta huɗi, ŋa yata gha ta zwaŋa zgun, ŋa tsanafta gha ta hgani ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dzaʼa nzakway ka mndu dagala, dzaʼa hgay lu ka Zwaŋa Lazglafta ta luwa ŋa vlaŋta Lazglafta ta ga mgham manda ŋa dzidzani Dawuda. ");
INSERT INTO xed_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dzaʼa gay ta mgham ta ghəŋa la Israʼila ŋa kɗekedzeŋ, kɗavakta a tsa ga mghamani ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ka Mari nda tsa duhwala Lazglafta ya mantsa: «Kinawu ka skwi dzaʼa magaku mantsa, ya wya ta sna a yu ta zgun wu?» ka Mari. ");
INSERT INTO xed_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","«Sulkum nda ghuɓa dzaʼa saha ta ghəŋa gha. Mbrakwa Lazglafta ta luwa dzaʼa bukwaghamta. Tsaya dzaʼa kəl lu ka hga tsa zwaŋ nda ghuɓa dzaʼa yata ka ya ka Zwaŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ngha a ka ta zba gha Elizabet si kul faftá lu ta ghəŋ ta yayni ta zwaŋ ná, waʼa nda huɗi ndana, mamkuʼ a tilani na nda va tsa halatani ya tani ra. ");
INSERT INTO xed_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Haɗ sana skwi ta tranaghatá Lazglafta wa,» ka duhwala Lazglafta nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yaw, «kwalva Lazglafta iʼi, ka maga Lazglafta manda ya mniha ka,» ka Mari. Ka sliʼafta duhwala Lazglafta tavatani ka laghwi. ");
INSERT INTO xed_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma va tsa fitik ya, ka sliʼaftá Mari misimmisim ka laghwi da sana luwa ta ghwá ma haɗika Yahuda da nghanaghatá Elizabet. ");
INSERT INTO xed_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ka lamə tsi da həga ga Zakari ka ganaghatá tsi ta zgu ta Elizabet. ");
INSERT INTO xed_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na gi snaŋta Elizabet ta ga zgwa Mari, gi ka skalavaftá zwaŋ ma huɗani. Ka ndəghanaftá Sulkum nda ghuɓa ta Elizabet. ");
INSERT INTO xed_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ka klaŋtá tsi ta lwi dagala dagala. Kaʼa mantsa: «Kagha, nda tfawi ta ghəŋa kagha mataba miʼaha. Na zwaŋ ma huɗa gha na guli, nda tfawi ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Waka yu mutsa nana ma zɗaku kəl mani ma mghama ɗa ka sagha da ini na? ");
INSERT INTO xed_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nda sna ka ná, ma fitika lama tsa ga zgwa gha ya tsərah da sləməŋa ɗa, ka skalavaftá na zwaŋ ma huɗa ɗa na da rfu. ");
INSERT INTO xed_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nda tfawi ta ghəŋa kagha, kagha ta zlghaftá skwiha mna gha lu ta dzaʼa magaku kahwathwata daga da Mgham Lazglafta ya.» ");
INSERT INTO xed_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ka Mari mantsa: «Ta zləzlvay yu ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ta taku ŋuɗufa ɗa da rfu ta ghəŋa tsatsi mnda mba iʼi, ");
INSERT INTO xed_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kabga ɗvafɗva ta nghapta ka kwalvani nda hta. Wana daga ndana, nda tfawi ta ghəŋani ka inda zivra mnduha dzaʼazlay nda iʼi, ");
INSERT INTO xed_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kabga dagala ŋərma skwiha magiha Lazglafta nda mbra. Nda ghuɓa həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tawa hiɗahiɗani ná, nda nza ŋa ɗekɗek ta ghəŋa gwal ta zləŋay. ");
INSERT INTO xed_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nda dzvani maraŋta tsi ta mbrakwani, ka ghzliŋtá tsi ta gwal ta gla ghəŋ, nda ghərɓaku ma ŋuɗufa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ka slisliŋwiŋtá tsi ta sanlaha ma gwal dagaladagala ta dughurukwa dasu, ka kapanaftá tsi ta gwal nda hta, ");
INSERT INTO xed_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ka baghanaftá tsi ta gwal ma maya nda skwiha zɗazɗa, ka ghzliŋtá tsi ta gwal gadghəl bɗadar. ");
INSERT INTO xed_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Manda ya tanaf tsi ta imi ta sləməŋ ta dzidzíha mu, ka kataŋtá tsi ta la Israʼila mnda maganatá slna, ");
INSERT INTO xed_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ka havaptá tsi ka tawa hiɗahiɗani ŋa Abraham nda inda zivrani tani ŋa ɗekɗek,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ka nzatá Mari kawadaga nda Elizabet ta kla tili hkən, tahula tsa ka vraghutá tsi dzaghani. ");
INSERT INTO xed_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mantsa, ka sagha fitika dgakwa Elizabet, ka yatá tsi ta zwaŋa zgun. ");
INSERT INTO xed_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ka snaŋtá sləvdahani nda la taŋ ta tsa ŋərma zɗaku magana Lazglafta ya, ka sliʼadaghatá həŋ gwaftá rfu kawadaga nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Baɗu matghasa fitik manda dgatani, ka sliʼadaghatá həŋ ŋa tsanatá fafaɗa zwaŋ. Ka kumə həŋ ta tsanaftá hgani ka Zakari manda va hga dani. ");
INSERT INTO xed_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","«Mantsa a dzaʼa hga lu wu, Yuhwana hgani,» ka mani. ");
INSERT INTO xed_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","«Haɗ mndu mataba mndəra ghuni tsanaf lu ta mndərga tsa hgu ya wu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka ɗawaŋtá həŋ nda dzvu da dani: «Waka ka ta kuma tsanaftá hgu na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Klagiɗighawa aluha, ka Zakari nda dzvu. «Yuhwana hgani,» kəʼa vindaftá hga tsa zwaŋ ya. Inda taŋ demdem ka ndərmim həŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gi hadahada, ka zlrəglaftá Zakari ta gwaɗa tsəleŋ, ka zləzlva Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ka ksaftá tsi ka zləŋ ta inda sləvdahani. Ka rusu lu ta inda tsa skwiha ya ma inda vli ta ghwá ma haɗika Zudiya. ");
INSERT INTO xed_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Inda mndu ta snaŋtá tsa gwaɗa ya, ta ndanu ta ghəŋani kazlay: Kinawu dzaʼa nzakwa tsa zwaŋ ya tama kəʼa? «Zlah dzaʼa nzakway ka mndu dagala, kabga kawadaga Lazglafta nda tsa zwaŋ ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tsa Zakari dani ma tsa zwaŋ ya kay, ka ndəghanaftá Sulkum nda ghuɓa, ka zlraftá tsi ta mna skwi dzaʼa magaku: ");
INSERT INTO xed_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Zləzlvama Mgham Lazglafta la Israʼila kabga saghani da kataŋtá mnduhani, ka varatá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ka sladamatá tsi ta mnda mba mndu nda mbra ta sabi ma zivra Dawuda ta nzakway ka kwalvani, ");
INSERT INTO xed_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","manda ya mnigiŋ tsi nda ma wa la anabi daga ghalya kazlay: ");
INSERT INTO xed_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dzaʼa mbaghunafmba yu ma dzva ghumaha ghuni, nda ya da gwal ta dra kaghuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mantsa ya, maranaŋmara ta tsa tva hiɗahiɗani ya ta dzidzíha mu, ka havaktá tsi ka tsa dzratá wani nda ghuɓa ya, ");
INSERT INTO xed_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","manda ya waɗana tsi ta dzidza mu Abraham, ");
INSERT INTO xed_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Dzaʼa mbaghunafmba yu ma dzva ghuma ghuni, kada laviŋta kuni ta ksanatá slna kul haɗ zləŋ, ");
INSERT INTO xed_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ŋa nzata ghuni ka gwal nda ghuɓa, gwal tɗukwa ta kəmani ma inda kɗavakta hafa mu.” ");
INSERT INTO xed_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kagha zwaŋa ɗa, anaba Lazglafta ta luwa dzaʼa hga lu ta kagha. Kagha dzaʼa tiŋlaghuta ka mgham ŋa faɗanatá tvi, ");
INSERT INTO xed_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ŋa snanamtá mnduhani kazlay: dzaʼa mbay ta həŋ ma platá dmakwa taŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dagala tawa hiɗahiɗa nda zɗaku da Lazglafta mu kəl tsi ka vlagatá tsuwaɗakani manda fitik ta safi gavzlazlaŋ, ka sagha da amu daga ta luwa, ");
INSERT INTO xed_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ŋa tsuwaɗakaku ta ghəŋa gwal ta nzaku ma grusl, nda gwal ta nzaku ta wa hɗak ma sulkuma mtaku, nda ya ŋa pgha səla mu ta tva zɗaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mbaɗa tsa zwaŋ ya ka glaku, ka sgaku mbrakwani ma Sulkum, ka nzatá tsi ma mtak ha ka sagha fitik kəl tsi ka maraŋtá nzakwani baŋluwa da la Israʼila. ");
INSERT INTO xed_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma tsa fitik ya, ka mnaftá mgham Sezar Agustus ta zlahu kazlay: Vindaftá mbsaka inda mnduha ma dzva Ruma kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma fitika nzakwa Kiriniyus ka ŋumna ta haɗika Siri zlrafta tsa taŋtaŋa mbəɗaftá mbsaka mnduha ya. ");
INSERT INTO xed_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Inda mnduha ka sliʼi həŋ da vinda hga taŋ ma luwa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ka sliʼafta Yusufu ma luwa Nazaret ta haɗika Galili, ka ŋladaftá tsi da luwa Batlehem ma haɗika Zudiya ta nzakway ka luwa kəl lu ka yatá mgham Dawuda. Lafla da hada kabga sabə ma mndəra Dawuda tsatsi. ");
INSERT INTO xed_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ka laf tsi kawadaga nda makumidzani Mari nda huɗi ya, da vinda hga taŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Manda ɓhadaghata taŋ da hada, ka sagha fitika dgakwa Mari. ");
INSERT INTO xed_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka yatá tsi ta zumalani ka zwaŋa zgun, ka mbsamtá tsi ma lgut ka hananamta ma tsuʼaŋ, kabga mutsaf a həŋ ta həga nzakwa matbay wa. ");
INSERT INTO xed_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tsaw ma va tsa luwa ya mamu gwal ta ngha rini, ta hani ma mtak ta ngha rina taŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka zlagaptá duhwala Lazglafta ta kəma taŋ, ka wanaftá tsuwaɗaka glakwa Lazglafta ta həŋ. Ka ksaftá zləŋ ta həŋ katakata. ");
INSERT INTO xed_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","«Ma zləŋ kuni ta zləŋ, kabga Lfiɗa Gwaɗa dzaʼa nzakway ka skwa rfu dagala da inda mnduha sagha yu da mnaghunata. ");
INSERT INTO xed_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gita yəgaghunata lu ta mnda mba mndu ta nzakway ka Kristi ma luwa Dawuda. ");
INSERT INTO xed_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wya ŋizla dzaʼa kəl kuni ka tsəmafta: Dzaʼa slanaghasla kuni ta vziʼuwa mbsam lu ma lgut ka hananamta ma tsuʼaŋ,» ka duhwala Lazglafta nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ka gi sliʼagatá ndəghata sanlaha ma duhwalha Lazglafta ta luwa ŋərɓisl slanaghatá tsa turtuk ya. Ka zləzlvu həŋ ta Lazglafta. Ka həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Glaku ŋa Lazglafta ta luwa, zɗaku ta ghəŋa haɗik mataba mnduha ɗvu tsi.» ");
INSERT INTO xed_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Manda vraghuta tsa duhwalha Lazglafta ya ta luwa, ka tsa gwal ngha rini ya mataba taŋ mantsa: «Mbaɗma da luwa Batlehem ka nghanata mu ta tsa skwi ta maguta mnama lu ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ka sliʼaftá həŋ ka laghwi misimmisim, ka slanaghatá həŋ ta i Mari nda Yusufu nda tsa zwaŋa vziʼuwa ya hananam lu ma tsuʼaŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tahula nghaŋta taŋ, ka rusu həŋ ta skwi mnana lu ta həŋ ta ghəŋ tsa vziʼuwa ya. ");
INSERT INTO xed_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ka ndərmim inda gwal ta sna tsa skwi ta mnə gwal ngha rini ŋa taŋ ya nda ndərmima. ");
INSERT INTO xed_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka ŋanatá Mari ta inda tsa skwiha ya ma ghəŋani ka ndanu ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ka vraghutá tsa gwal ngha rini ya dzagha taŋ nda vla glaku nda zləzlvu ŋa Lazglafta ta ghəŋa inda skwi snaŋ həŋ, ka nghaŋtá həŋ manda va skwi ya mnana lu ta həŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta matghasa fitik ŋa tsanatá fafaɗa tsa zwaŋ ya, ka tsanaftá lu ta hgu ka Yesu, tsa hgu mna duhwala Lazglafta ma kɗaku mani ka zlghaftá huɗani ya. ");
INSERT INTO xed_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kɗatá tsa fitika ghuɓata Mari manda ya ta mnə zlaha Musa ya, ka klaghatá i Mari nda Yusufu ta tsa zwaŋ ya da Ursalima ŋa vlaŋtá Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Manda ya nda vinda ma deftera Lazglafta kazlay: Inda zumali ka zwaŋa zgun ná, ŋa Lazglafta ya kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka dranaftá həŋ ta Lazglafta ŋa pla ghəŋ ta «kukuha his ka zwana ghərbuʼ his a tsi» manda ya nda vinda ma zlaha Mgham Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma tsa fitik ya, mamu sana mndu ma Ursalima Simeyuna hgani. Tsa mndu ya ná, tɗukwa mndu ya, ta snay ta gwaɗa da Lazglafta. Ta kzlaykzlay ta mnda mba la Israʼila. Kawadaga Sulkuma Lazglafta nda tsi guli. ");
INSERT INTO xed_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Si mnanaŋmna Sulkum nda ghuɓa kazlay: Haɗ dzaʼa mtuta karaku ka ta ngha a tsi ta ghunatá mnda Lazglafta ta nzakway ka Kristi wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ka ghunaftá Sulkum nda ghuɓa da həga Lazglafta, ta kladaghatá i dani nda mani ta Yesu ŋa kɗiŋta magatá skwi manda ya mna zlahu ŋa magay. ");
INSERT INTO xed_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ka tsuʼaftá tsatsi ta tsa zwaŋ ya ma dzvani, ka rfu tsi ta Lazglafta. Kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ndana tama mghama ɗa, nda kɗa magatá slna gha, zlaŋzla ta kwalva gha, ka ɓhata tsi nda vghata zɗaku manda ya mna ka, ");
INSERT INTO xed_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kabga nda ngha yu nda ira ɗa ta mbaku vla ka, ");
INSERT INTO xed_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mbaku ya payaf ka ŋa inda mnduha demdem. ");
INSERT INTO xed_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tsuwaɗak ya ŋa inda mndəra mndu. Tsatsi dzaʼa klaktá glaku ŋa mnduha gha la Israʼila.» ");
INSERT INTO xed_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ka va ndərmim i dani nda mani ta skwi ta gwaɗə lu ta ghəŋa tsa zwaŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ka tfanaghatá Simeyuna ta wi ta həŋ. Kaʼa nda Mari mantsa: «Nana zwaŋ na ná, dzaʼa klakkla ta zləmbaku, nda sliʼafta ŋa ndəghata sanlaha ma mnduha ma la Israʼila. Dzaʼa nzakway ka ŋizla daga da Lazglafta, ŋa husaŋtani ta sanlaha ma mnduha. ");
INSERT INTO xed_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dzaʼa tuzigiŋ tuza ta skwi ma ŋuɗufa mnduha. Vərɗa kagha guli ŋa nzakwa ŋuɗufa gha manda skwi sligla lu nda kafay,» kaʼa nda Mari mani ma tsa zwaŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mamu sana marakw ka anabi nda hala katakata, Ana hgani, makwa Fanuwal ma mndəra la Asira. Ndəfáŋ yeya vaku maga tsi nda zəʼal manda laghani da mndu, ");
INSERT INTO xed_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ka nzaku tsi ka wadgu. Tghasmbsak fwaɗ mida imani. Ma həga Lazglafta ta nzakwa tsi ta ksanatá slna nda fitik tani nda rviɗik tani, nda ma maga duʼa nda suma. ");
INSERT INTO xed_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɓhadaghata tsatsi guli, ma va tsa fitik ya, ka zləzlvu tsi ta Lazglafta, ka mnə tsi ta gwaɗa ta Yesu ŋa inda gwal ta kzla mbakwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tahula kɗiŋta i Yusufu nda Mari ta maga skwi ya mnə zlaha Lazglafta, ka vraghutá həŋ da luwa taŋ ma Nazaret ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ka glaku tsa zwaŋ ya, ka sifaku tsi, dagala ɗifil ma ghəŋani, kawadaga zɗakwa Lazglafta guli nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Inda vaku i dani nda mani ma Yesu ta dzaʼa da skala Pak ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Magatá ima tsa zwaŋ ya ghwaŋpɗə his, ka ŋlaghatá tsi kawadaga nda i dani nda mani da Ursalima da tsa skala Pak ya manda ya snu həŋ ta magay. ");
INSERT INTO xed_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tahula kɗatá tsa skalu ya ta vru həŋ dzagha, ta tsaghutá Yesu ta vgha nda həŋ ka nzaghuta ma Ursalima kul snaŋtá i dani nda mani. ");
INSERT INTO xed_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ba ta mbaɗa həŋ kawadaga nda grahani ka həŋ sizlay. Tekulemes vagha taŋ ta mbaɗa, ka zbə həŋ mataba mndəra taŋ nda grahani, lay ngha a həŋ wa. ");
INSERT INTO xed_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Trapta taŋ ta pahay, ka vraghutá həŋ pahay ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Baɗu mahkəna fitik, ka slanaghatá həŋ ma həga Lazglafta ta nzaku mataba gwal tagha zlahu ŋa mnduha, ta sna skwi ta mnə həŋ, ta dzaʼa nda ɗawaŋta da həŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Faflara, ka tsa gwal ta sna tsa zlghawi ta zlghə tsi nda tsa snaŋtá skwani ya. ");
INSERT INTO xed_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na ghur nghaŋtá i dani nda mani, ka ndraʼu həŋ nda ndraʼuwa. «Sagəŋ, nu kəl ka ka magaŋnatá skwi mandana? Hərfa ta aŋni nda da gha na təklək ta psa kagha,» ka mani nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","«Ŋaw kaghuni ta iʼi ta psay na? Sna a kuni kazlay: Dzaʼa nzə ma həga da ɗa yu ta nzaku kəʼa ra?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tsəriɗ, sna a həŋ ta tsa skwi ta mnə tsi ŋa taŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mantsa tama, ka snatá tsi ta gwaɗa taŋ, ka sliʼaftá tsi kawadaga nda həŋ, ka valaghata da Nazaret. Ka ŋanatá mani ta inda tsa skwiha ya ma ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ka glaku Yesu, ka sgaku ɗifilani, ka zɗəganatá nzakwani ta Lazglafta nda mnduha tani. ");
INSERT INTO xed_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ta Maghwaŋapɗə hutafa vakwa Tiber Sezar ta pala, ta nzakwə Pwaŋəs Pilat ka ŋumna ta haɗika Zudiya, ta gə Hiridus ta mgham ta haɗika Galili, ta gə zwaŋamani Filip guli ta mgham ta haɗika Iture nda haɗika Trakunita, ta gə Lisaniya guli ta haɗika Abilena. ");
INSERT INTO xed_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma tsa fitik ya guli, i Hana nda Kayifa mali ta ghəŋ gwal dra skwi ŋa Lazglafta. Ka sagha gwaɗa Lazglafta da ghəŋa Yuhwana zwaŋa Zakari ma mtak. ");
INSERT INTO xed_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ka sliʼaftá Yuhwana ka laghwi da ra inda luwa ta wanaftá ghwa Zurdeŋ nda hagaku, kaʼa mantsa: «Mbəɗanafwa mbəɗa ta nzakwa ghuni, ka magaghunafta lu ta batem, ka plighunista Lazglafta ta dmakwa ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Manda ya nda vinda ma deftera anabi Isaya kazlay: «Lwa tsa mndu ya ta snu lu ta guguɗaku ma mtak kazlay: payanawa paya ta tvi ŋa Mgham, ka leleʼanata kuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ka saŋamta lu ta inda vli ka didiŋa, ka tasiŋta lu ta inda ghwá nda kuɗuŋurha, ka ɗayapta lu ta skwi ka ghuluŋuɗ, ka payanata lu ta huraɓasl ta tvi, ");
INSERT INTO xed_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ŋa nghaŋta inda mnda səla ta mbaku da Lazglafta.» ");
INSERT INTO xed_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ka mnə tsi ŋa tsa mnduha ta sliʼadaghata rutututa da maga batem da tsi ya. Kaʼa mantsa: «Mndəra la mupuhwa, wa ta mnaghunata kazlay: Hwayawahwaya ta ɓasa ŋuɗuf ta sagha ta kəma kəʼa na? ");
INSERT INTO xed_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Magawamaga ta slna ya ta maraŋta mbəɗatá nzakwa ghuni, ka zlaŋta kuni ta mnay ma ghəŋa ghuni kazlay: Abraham ná, dzidza ŋni ya, kəʼa. Ka yu ta mnaghunata ná, laviŋlava Lazglafta ta nanaftá ya palaha ya ka zwana Abraham. ");
INSERT INTO xed_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ɗaswa ka kuni! Nda ghada kapatá slpaɗa ŋa tsiŋtá fu daga ta slrəŋ. Inda fu ya kul zɗaku yakwani, dzaʼa tsiŋtsa lu ka vzamta ma vu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka dəmga nda Yuhwana mantsa: «Nu ta raku ŋa magay ŋni tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kaʼa nda həŋ mantsa: «Mndu ya his lgut da tsi, ka dganapdga tsi nda mndu ya kul haɗ tsi da tsi. Mndu ya mamu skwa zay da tsi guli, ka maga tsi mantsa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ka sliʼadaghatá gwal ta tska dzumna guli, ŋa maganafta Yuhwana ta batem ta həŋ, ka ɗawə həŋ da tsi: «Maləm, nu ta raku ŋa magay aŋni guli?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kaʼa nda həŋ mantsa: «Ma ɗaw kuni ta skwi da mndu ka malaghutá ya tsaf lu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","«A ki aŋni, nu ta raku ŋa magay ŋni?» ka La sludzi ɗawaŋta guli da tsi. Kaʼa nda həŋ mantsa: «Ma mbrəh kuni ta mndu ŋa vlaghunata skwi, rfawa ta rfu nda kuraghuta skwi ta plaghunata lu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","«Zlah Kristi a na mndu na ri,» ka mnduha nda Yuhwana, kabga nda fa ghəŋa taŋ ka kzla saghani. ");
INSERT INTO xed_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kaʼa nda həŋ mantsa: «Iʼi ná, nda imi ta magaghunafta yu ta batem, ama mamu mndu ta sagha ta malaghutá iʼi nda mbraku. Slaghu a iʼi ka pliŋtá zuʼa ɓaɓahani wa. Tsatsi, dzaʼa magaghunafmaga ta batem nda Sulkum nda ghuɓa nda ya nda vu. ");
INSERT INTO xed_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nda ŋatá kuwatavihi ma dzvani, dzaʼa vihapviha ta hyani, ŋa tskamtani ma gvurani, ŋa driŋtani ta sabatbat nda vu kul mtavata,» kaʼa nda həŋ demdem. ");
INSERT INTO xed_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mantsa ya ka Yuhwana ta mna Lfiɗa Gwaɗa ŋa mnduha, ka dzaʼa nda vla ndəghata hiɗakuha ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ka dvanaghatá Yuhwana ta mgham Hiridus ta ghəŋa klugudunustani ta Hiridiya markwa zwaŋamani Filip, nda ya ta ghəŋa ndəghata sanlaha ma ghwaɗaka skwi ta magə tsi. ");
INSERT INTO xed_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ka ksamtá tsi ta Yuhwana da gamak, ka sganaghata ta ghəŋa tsa ghwaɗaka skwi ta magə tsi ya. ");
INSERT INTO xed_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Manda ya ta maganafta Yuhwana ta batem ta mnduha, ka lagha Yesu ka maganaftá lu ta batem guli. Ta ndəɓu tsi ta dzvu, ka gunatá luwa buwaŋ, ");
INSERT INTO xed_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ka saha Sulkum nda ghuɓa ta ghəŋani manda ghərbuʼ ta nghə mnduha. Mantsa, ka snaku lwa Lazglafta daga ta luwa ta mnay kazlay: Kagha Zwaŋa ɗa ɗvu yu ma hyahya ŋuɗufa ɗa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ta magay ima Yesu ta hkən mbsak ta zlraftá tsi ta ksa slnani. Manda va ya ta ndanu mnduha kazlay: Zwaŋa Yusufu ya kəʼa ya, wya mndəra taŋ: Yusufu, Yusufa Heli, ");
INSERT INTO xed_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hela Matat, Matata Levi, Levi Malki, Malki Zanay, Zanaya Yusufu, ");
INSERT INTO xed_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufa Matatiyas, Matatiyasa Amus, Amusa Nahum, Nahuma Hesəla, Hesəla Nagay, ");
INSERT INTO xed_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaya Mahat, Mahata Matatiyas, Matatiyasa Samayiŋ, Samayiŋa Yusek, Yuseka Yuda, ");
INSERT INTO xed_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda Yuwana, Yuwana Resa, Resa Zwarubabel, Zerubabela Salatiyel, Salatiyela Neri, ");
INSERT INTO xed_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nera Malki, Malki Adi, Adi Kasam, Kasama Elmadama, Elmadama Yera, ");
INSERT INTO xed_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yera Dzesuwa, Dzesuwa Eliyezer, Eliyezera Yurima, Yurima Matat, Matata Levi, ");
INSERT INTO xed_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leva Simeyuna, Simeyuna Yudah, Yudaha Yusufu, Yusufa Yunam, Yunama Iliyakim, ");
INSERT INTO xed_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iliyakima Meleya, Meleya Mena, Mena Matat, Matata Nataŋ, Nataŋa Dawuda, ");
INSERT INTO xed_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawuda Yesay, Yesaya Ubed, Ubeda Buwaz, Buwaz Sala, Sala Nasuŋ, ");
INSERT INTO xed_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasuŋa Aminadap, Aminadapa Admin, Admina Arni, Arni Hesərum, Hesruma Fares, Faresa Yuda, ");
INSERT INTO xed_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda Yakubu, Yakubu Izak, Izaka Abraham, Abrahama Tera, Tera Nahur, ");
INSERT INTO xed_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahura Seruk, Serukwa Ragaw, Ragawa Falek, Faleka Eber, Ebera Sala, ");
INSERT INTO xed_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Kayinam, Kayinama Afaksad, Afaksada Sema, Sema Nuhu, Nuhwa Lamek, ");
INSERT INTO xed_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameka Matusalah, Matusalaha Inuk, Inukwa Yered, Yereda Maleleyel, Maleleyela Kayinan, ");
INSERT INTO xed_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinana Inus, Inusa Set, Seta Adamu, Adamu ya Zwaŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ta vragaptá Yesu ma ghwa Zurdeŋ, nda ndəgha nda Sulkum nda ghuɓa. Ka wawu tsa Sulkum ya ma mtak, ");
INSERT INTO xed_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","fitik fwaɗ mbsak zaŋ a ta skwa zay wa. Ka dzəghaŋtá halaway. Tahula luta tsa fitikha ya, ka kuzlanaftá maya. ");
INSERT INTO xed_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ka halaway nda tsi mantsa: «Ka Zwaŋa Lazglafta ka katsi, mnanamna ta na pala na, ka navapta tsi ka buradi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka Yesu mantsa: «Nda vinda ma deftera Lazglafta kazlay: Nda skwa zay kweŋkweŋ yeya a ta nzakwa mndu ta nzaku nda hafu wu kəʼa,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ka kladaftá halaway ta Yesu ta wa lilwa, ka gi maranatá tsi ta inda za mgham ma ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kaʼa nda tsi mantsa: «Dzaʼa vlaghavla yu ta inda na mbraku nda glaku ma na ghəŋa haɗik na, kabga klafkla lu ka vlihata ma dzva ɗa. Laviŋlava yu ta vlaŋtá mndu ya ta ɗvu yu guli. ");
INSERT INTO xed_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka tsəlɓa tsəlɓa ka ma ghuva ɗa, ta vlaghavla yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka Yesu nda tsi mantsa: «Nda vinda ma deftera Lazglafta kazlay: ma ghuva Mgham Lazglafta gha dzaʼa tsəlɓa ka ta tsəlɓu, ka maganatá slnani turtukwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ka kləglaghatá halaway ta Yesu da Ursalima, ka kladafta ta bɗəma həga Lazglafta ka sladanata. Kaʼa nda tsi mantsa: «Ka si Zwaŋa Lazglafta ka katsi, vzada vgha gha hadna, kabga nda vinda ma deftera Lazglafta kazlay: ");
INSERT INTO xed_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Dzaʼa mnanamna ta duhwalhani ta luwa ŋa nghapta ka kagha kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kaʼa guli na: “Ŋa tsuʼafta taŋ ta kagha ma dzva taŋ, yagha pala da dzughusta ta səla”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka Yesu nda tsi guli mantsa: «Nda vinda ma deftera Lazglafta kazlay: ma dzəghə ka ta Mgham Lazglafta gha ɗekɗek kəʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɗakwa halaway ta dzəghaŋta nda inda tsa skwiha kavghakavgha ya, ka zlanavatá tsi ka laghwi ŋa baɗu ma sani guli. ");
INSERT INTO xed_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ta sliʼaftá Yesu ka laghwi ta haɗika Galili nda ndəgha nda mbrakwa Sulkum nda ghuɓa. Ka tuta hgani ma inda vli ta wanaftá tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ka tataghə tsi ta skwi ma həga tagha skwa la Yahuda, ka ghubu mnduha. ");
INSERT INTO xed_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka sliʼaftá tsi ka Laghwi da Nazaret, luwa ta glakwani. Ka lamə tsi da həga tagha skwa la Yahuda baɗu sabat manda ya snu tsi. Ka sliʼaftá tsi ŋa dzaŋaftá skwi ma defteri. ");
INSERT INTO xed_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka klaftá lu ta deftera anabi Isaya ka vlaŋta. Ka plaŋtá tsi, ka slanaghatá tsi ta vli vindaf lu kazlay: ");
INSERT INTO xed_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Kawadaga Sulkuma Lazglafta nda iʼi ŋa vlihatá mbraku. Zbapzba Lazglafta ta iʼi ka tfiɗaghatawi ŋa mnanatá Lfiɗa Gwaɗa ta gwal ka pɗu, ghunafghuna ta iʼi ŋa mnanatá gwal habaf lu kazlay: Palaghunispala lu kəʼa, ŋa gwaniŋtá ira gwal nda ghulpa, ŋa zluʼagapta ɗa ta gwal raghwana lu, ");
INSERT INTO xed_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ŋa snanamta ɗa ta mnduha ta vaku dzaʼa sagha zɗakwa Lazglafta» kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Manda kɗiŋtani ta dzaŋafta, ka mbsaftá tsi ka vlaŋtá kwalva ma tsa həga ya, ka nzadatá tsi. Ka pghaftá inda tsa mnduha ma tsa həga tagha skwa la Yahuda ya ta iri tida: ");
INSERT INTO xed_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka Yesu nda həŋ mantsa: «Nana gwaɗa Lazglafta snaŋ kuni nda sləməŋa ghuni gita na ná, nda kɗa magatani ka ŋa ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Inda tsa hahəŋ ma tsa vli ya ka zɗəganatá tsi ta həŋ, ka ndərmim həŋ ta tsa gwaɗa zɗaku ta sabə ma wani ya. Ka həŋ mantsa: «Zwaŋa Yusufu a na mndu na kay tsawa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka Yesu nda həŋ mantsa: «Nda sna yu dzaʼa mnay kuni ta mahdihdi ta ghəŋa iʼi kazlay: Ka duhtur ka katsi ná, mbanafmba ta ghəŋa gha kagha ka ghəŋa gha kəʼa. Ka kuni dzaʼazlay nda iʼi guli, “magamaga hadna ma luwa gha ta tsa skwiha snaŋ ŋni ta magə ka ma Kafarnahum ya”» kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","«Kahwathwata ka yu ta mnaghunata ná, haɗ lu ta tsuʼafta hmətət ta dər wati ma anabi ma luwani wa, ka Yesu sganaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kahwathwata ka yu ta mnaghunata, ma fitika nzakwa anabi Iliya, si nda ndəgha wadguha ma Israʼila, ka ghwalutá luwa ka vaku hkən nda tili mkuʼ, ka slatá maya dagala ta haɗika Yahuda, ");
INSERT INTO xed_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Má ŋa ghunafta lu ta Iliya ŋa kataŋta ya dər turtuk ma tsa wadguha la Yahuda ya, ka ghunaftá lu kataŋtá sana markwa wadga ma luwa Sarepta ta haɗika Siduŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma fitika nzakwa anabi Alisa guli, si nda ndəgha gwal nda rɗa mndu ta həŋ ma Israʼila, haɗ ya mbanaf lu dər turtuk mataba taŋ wu, Naʼama mnda la Siri yeya mbanaf lu.» ");
INSERT INTO xed_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ka ɓasaftá həŋ ta ŋuɗuf demdem ma tsa həga tagha skwa La Yahuda ya, manda snaŋta taŋ ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ka sliʼaftá həŋ, ka ksagaptá Yesu ma huɗa luwa, ka kladapta ta wa lilwa tsa ghwá baf həŋ ta luwa taŋ tida ya, ma ŋa sliŋwidiŋta, ");
INSERT INTO xed_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ka tsəhaptá Yesu ta vghani mataba taŋ ka laghwani. ");
INSERT INTO xed_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ka laha tsi da luwa Kafarnahum ta haɗika Galili. Baɗu sabat, ka taghə tsi ta skwi ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka ndərmim lu ta tsa tagha skwani ya, kabga nda sgit ma tsa gwaɗani ya. ");
INSERT INTO xed_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma tsa həga tagha skwa taŋ ya, mamu sana mndu ksu duhwala halaway mataba taŋ. Ka sliʼaftá tsi nda lili. ");
INSERT INTO xed_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Aya! Yesu zwaŋa la Nazaret, nu gwaɗa gha nda aŋni sagha ka da zaɗa aŋni? Wya nda sna yu mndu nda ghuɓa daga da Lazglafta kagha kəʼa, kaʼa» ");
INSERT INTO xed_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","«Haf wa gha, sapsa ma na mndu na!» ka Yesu dvanaghata. Gi ka slanatá tsa duhwala halaway ya ta tsa mndu ya mataba tskatá mnduha, ka saghu tsi mida kul balanata. ");
INSERT INTO xed_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka tsutá ŋuɗufa mnduha demdem, ha ka ɗaɗawu həŋ mataba taŋ kazlay: Nu mndərga nana ma skwi? Na gi dvanaghatani nda sgit nda mbraku ta duhwala halaway ná, gi saghwa taŋ, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka tutá hgani ma inda vli ta wanaftá tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Manda sliʼagapta taŋ ma həga tagha skwa la Yahuda, ka laghu həŋ da Simuŋ. Ta lagha həŋ ta ɓasa ŋuɗidar midza Simuŋ katakata. Ka ndəɓu lu ta dzvu da Yesu ŋa kataŋtá tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ka ɓukudanaghatá tsi ta tsa marakw ya, «zliŋzla!» kaʼa nda ŋuɗidar, ka zliŋtá tsi. Gi hadahada ka sliʼaftá tsa marakw ya ka maganatá skwa zay ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Manda dəɗata fitik, ka hladaghatá gwal nda mnduha taŋ kul ɗughwanaku da ɗaŋwaha kavghakavgha ta həŋ da Yesu, ka fafanaghatá tsi ta dzvu ta həŋ, ka mbambanaftá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka sliʼagaptá duhwala halaway guli nda lili ma ndəghata mnduha. Ta sliʼagaptá həŋ, ka həŋ mantsa: «kagha ná, Zwaŋa Lazglafta ka,» ka həŋ nda tsi. Ka davanaghatá Yesu ta həŋ, ŋa hanaftá wi ta həŋ, kabga nda sna hahəŋ kazlay: Tsatsi Kristi kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na tsaɗakwa vli, ka sabə Yesu ka laghwi da mtak. Ka sliʼaftá mnduha ka zbay, ka slanaghatá həŋ, ka kumə həŋ ta ŋanata yaha lavaghwi tavata həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka Yesu mantsa: «Ɗina guli ka mnanaŋta ɗa ta Lfiɗa Gwaɗa ta ghəŋa ga mghama Lazglafta ta sana luwaha, kabga tsaya kəl Lazglafta ka ghunigihata,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ka sliʼaftá tsi ka laghwi. Ka va rə tsi ta vli ta mna tsa Lfiɗa Gwaɗa ya ma inda həga tagha skwa la Zudiya. ");
INSERT INTO xed_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ma sana fitik ta nzaku Yesu ta wa drəf ma Genezaret, ka va sliʼadaghata dəmga dlivis slanaghata ŋa sna gwaɗa Lazglafta da tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka nghaŋtá tsi ta kwambaluha his ta wa tsa drəf ya, sliʼagaghu gwal tuma klipi mida ka laghu ghwaɓa kadəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ka sliʼaftá Yesu ka lamə da sani ma tsa kwambaluha ya, ta nzakway ka ŋa Simuŋ. «Gavadanam gava kwitikw nda ma huɗa drəf,» kaʼa nda Piyer. Ka nzagaptá tsi mida ka tagha skwi ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Manda kɗakwani ta gwaɗa, «Gavadanamwa gava ta kwambalu da takataka drəf, ka wuɗadata kuni nda graha gha ta kadəŋa ghuni ŋa tuma klipi,» kaʼa nda Simuŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka Piyer mantsa: «Mghama ɗa, kurzliŋ hana ŋni ta tumay, lay mutsaf a ŋni wa. Yaw, dzaʼa vzadavza ŋni tama ta gwaɗa gha» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ka vzadatá həŋ, ka waftá tsi ta ndəghata klipiha ta malaghutá mbraku ka kuma ratsiŋtá kadəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ka kəməts həŋ ta sanlaha ma graha taŋ ma sana kwambalu ŋa sagha kataŋtá həŋ. Ka sagha tsahaya, ka ndaghanaftá həŋ ta tsa kwambaluha taŋ ya his his, ha ka kumə tsa kwambaluha taŋ ya ta zamta da imi. ");
INSERT INTO xed_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","«Mghama ɗa! laghula gha tavata iʼi kabga mnda dmaku yu,» ka Simuŋ Piyer tsəlɓata ma ghuva Yesu nghər tsi ta tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tsaw si hluhla zləŋ ta i Piyer nda grahani ta ghəŋa tsa mandərmima tuma klipi maga həŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mantsa ya hluta tsi ta i Yakubu nda Yuhwana ta nzakway ka zwana Zebedi ta gwaftá vgha nda i Simuŋ ya guli. Ama ka Yesu nda Simuŋ mantsa: «Ma zləŋ ka, daga ndanana, mnduha dzaʼa ka hlakta,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Manda vranakta taŋ ta tsa kwambaluha ya ta wa sgam, sɗak zlanavazla həŋ ta inda skwiha taŋ ka laghwi mista Yesu. ");
INSERT INTO xed_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma sana fitik ma nzakwa Yesu ma sana luwa, ka lagha sana mndu ksu rɗa mndu. Na gi nghaŋtani ta Yesu, ka zləmbatá tsi zlumbruh ma ghuvani ka ndəɓa dzvu. «Mghama ɗa, ka ta kumay ka laviŋlava ka ta mbiɗifta ka nzakwa yu nda ghuɓa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ka fadaptá Yesu ta dzvani ka ksaŋta. Ka Yesu mantsa: «Ta kumay yu ta mbafta gha, mbafmba gha,» kaʼa. Gi hlets mbaftá ka nzaku tsi nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tahula tsa kaʼa nda tsi mantsa: «Yahayaha ka da walaŋtá mnanaŋtá mndu, la da maranaŋtá vgha gha ta mndu ta dra skwi ŋa Lazglafta karaku, ka vlata ka ta skwi manda ya vindaf Musa ŋa grafta mnduha ta mbatá kagha,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka va sgaku dzaʼa hga Yesu da zərwa, ka sliʼaktá dəmga da sna gwaɗa da tsi nda ya ŋa mutsaftá mbaku ma ɗaŋwaha taŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama ta gɗata Yesu ta laghwi da mtak da maga duʼa. ");
INSERT INTO xed_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma sana fitik ta tagha skwi Yesu ŋa dəmga, ta nzaku la Farisa nda gwal tagha zlahu ŋa mnduha hada ta sliʼakta ma inda luwa ta haɗika Galili nda ya ma luwa Ursalima, nda pɗakwa gwal ma haɗika Zudiya. Ka va sgaku maravata mbrakwa Mgham Lazglafta nda ma mbambay Yesu ta mnduha ma ɗaŋwaha taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka sliʼadaghatá mnduha, ka tsukwadanaghatá sanlaha ta sana mndu nda rwa səlani. Ka zbə həŋ ta ɓhadanamta da həga fata ta kəma Yesu. ");
INSERT INTO xed_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ka traptá həŋ ta tvi ŋa lami, kabga hiɓa ta mnduha. Ka kladaftá həŋ nda ta bɗəma həga, ka gunaptá həŋ ta ghəŋa tsa həga ya, ka fadatá həŋ sruh fata ta kəma Yesu nda ta tsa ghurum ya nda ghzləŋani nda ghzləŋani mataba tskata mnduha. ");
INSERT INTO xed_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nghanata Yesu ta zlghay nda ŋuɗufa taŋ ná, «nda pla dmakwa gha sagəŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","«Wana ma mndu ta kwarakwara ɓa? Wa ta laviŋtá pla dmakwa mndu ta ghəŋa Lazglafta turtukwani na?» ka tsa gwal tagha zlahu ŋa mnduha nda la Farisa ya ta ndanay ma ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","«Ndanawu mndəra na ta ndanu kuni ɓa! ka Yesu nda həŋ, kabga nda sna tsatsi ta ndana taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta grə kuni ná, mal blakwa mnay ŋa na mndu na kazlay: Nda pla dmakwa gha kəʼa re? Ari mal blakwa mnay kazlay: Sliʼafsliʼa ka mbaɗa ka ta mbaɗa kəʼa na? ");
INSERT INTO xed_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ala, ka da grafta kuni kazlay: Mamu Zwaŋa mndu nda mbrakwa pliŋtá dmakwa mndu ta ghəŋa haɗik» kəʼa, ka yu ta mnaghata gra wa, «sliʼafsliʼa, kla ta skwa hana gha, la dzagha gha,» kaʼa nda tsa mndu nda rwa səlani ya. ");
INSERT INTO xed_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Gi hadahada brahwat sliʼafta tsa mndu ya tsa ta nghay mnduha demdem, zləŋal klaftá skwa hanani, ka dzaʼa dzaghani nda zləzlva Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ka ndərmim inda mnduha nda ndərmima, ka zləzlvu həŋ ta Lazglafta. «Nda ngha ŋni ta skwa mandərmimi gita,» ka həŋ nda zləŋ nda zləŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tahula tsa, ka sabə Yesu ka nghaŋtá tsi ta sana mnda tska dzumna Levi hgani, ta nzaku ma həga ksa slnani. «Mbaɗa mista ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ka sliʼaftá Levi ka zlanavatá inda tsa skwiha ta magə tsi ya ka laghwi mistani. ");
INSERT INTO xed_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lagha Levi ka maganatá skwa zay gaʼ ga taŋ. Ka nzata həŋ ka zay kawadaga nda ndəghata mnduha, nda sanlaha ma gwal tska dzumna guli mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ka ruruŋwaku la Farisa nda mnduha taŋ ta tagha zlahu ŋa mnduha ta ruruŋwaku. Ka həŋ mantsa: «Kabgawu ta kəl kuni ka za skwi nda sa skwi kawadaga nda gwal tska dzumna nda sanlaha ma ghwaɗaka mnduha na?» ka həŋ nda duhwalha Yesu. ");
INSERT INTO xed_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka Yesu nda həŋ mantsa: «Haɗ gwal ɗughwana ta zba duhtur wa, gwal kul ɗughwanaku yeya ta zbay. ");
INSERT INTO xed_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sagha a yu da hagaktá gwal ta mnay kazlay: Tuɗukwa aŋni kəʼa wu, sa da haga gwal ta snaŋta kazlay: Gwal dmaku aŋni kəʼa yu, ŋa mbəɗanafta taŋ ta nzakwa taŋ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka la Farisa nda Yesu mantsa: «Ta sumay i duhwalha Yuhwana nda duhwalha aŋni ta suma ka maga duʼa tazlay, za skwa zay taŋ nda sa skwa say taŋ ŋa duhwalha kagha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka Yesu nda həŋ mantsa: «Dzaʼa laviŋlava kuni ta mnay kazlay: Tkweʼ sumawa suma ta suma kəʼa nda graha zwaŋa midzi ka ta kawadaga zwaŋa midzi nda həŋ baɗu kla makwa ra? ");
INSERT INTO xed_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dzaʼa saghasa fitik ŋa kləgədanaghutá zwaŋa midzi ta həŋ. Ma tsa fitikha ya dzaʼa suma həŋ ta suma,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kaʼa nda həŋ nda mahdihdi guli mantsa: «Haɗ mndu ta kuhwaʼatá lfiɗa lgut ŋa tsamtá halata lgut nda tsi wa. Ala ka kuhwa a kuhwa lu ta tsa lfiɗa lgut ya ka tsamtá halatani nda tsi katsi, rəta a ngha tsatá tsa halata lgut ya wa. ");
INSERT INTO xed_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Haɗ mndu dzaʼa pghamtá ima inabi ta ka nuni da halata zliba huta wa. Ka pghampgha lu katsi, dzaʼa tiŋta ta tsa zlibi ya, ŋa mbəzutani ta bəghutá lu ma zliba huta. ");
INSERT INTO xed_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma zliba huta ta ka lfiɗ ta pghamta lu ta ima inabi ta ka nuni. ");
INSERT INTO xed_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Haɗ mndu ta sutá ima inabi nda tawa dzaʼa zba səgəltá ima inabi ta ka nuni guli wa. “Mal zɗakwa ya nda tawa” ka lu ta mnay,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Baɗu sana fitika sabat, ta lap Yesu ta tvi ma takataka vwaha alkama kawadaga nda duhwalhani, ka ɓalaʼatá duhwalhani ta ghəŋani. Ka vərɗə həŋ ma dzvu ka dghaɗay. ");
INSERT INTO xed_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mamu sanlaha ma la Farisa ta nghaŋtá həŋ. Kaʼa nda həŋ nda həŋ mantsa: «Kabgawu ta kəl kuni ka maga skwi ya pyaf lu ta magay baɗu sabat na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ka Yesu nda həŋ mantsa: «Ta dzaŋaf a kuni ta skwi maga Dawuda ma sana fitik kuzlanafər maya kawadaga nda gwal ta dzaʼa mistani tani ra? ");
INSERT INTO xed_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ka sliʼaftá tsi ka lami da həga Lazglafta, ka klaftá tsi ta buradi fana lu ta Lazglafta ka zuta, daganafha ta tsa gwal mistani ya guli, aŋ mndani za a hamata mndu ta tsa skwi ta fanata lu ta Lazglafta ya wa, ba gwal ta dra skwi ŋa Lazglafta yeya ta zay.» ");
INSERT INTO xed_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","«Zwaŋa mndu ná, tsatsi mgham ta ghəŋa sabat,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma sana sabat guli, ka lamə Yesu da həga tagha skwa la Yahuda, ka taghə tsi ta skwi. Mamu sana mndu nda mta dzva zeghwani hada. ");
INSERT INTO xed_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma tsa vli ya guli, mamu gwal tagha zlahu ŋa mnduha nda la Farisa, ta kuma mutsaftá rutsak ta Yesu ŋa razay. Ka nzatá həŋ ka ngha Yesu ta iri ta iri ŋa nghay ka dzaʼa mbər mba a wa tsi ta mndu baɗu sabat, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tsaw nda sna Yesu ta ndana taŋ. Kaʼa mantsa: «Sliʼafsliʼa gra, ka sagha ka sladata ta nghay mnduha,» kaʼa nda tsa mndu nda mta dzvani ya. Ka sliʼaftá tsa mndu ya ka sladata. ");
INSERT INTO xed_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka Yesu nda həŋ mantsa: «Nu skwi mna zlaha mu ŋa magay baɗu sabat na? Maga skwi ɗina ta raku re, ari maga skwi kul ɗinaku a na? Mbanaftá hafu skwi nda ra re, ari klaptá hafu mida a guli?» ka Yesu ɗawaŋta da tsa gwal tagha zlahu ŋa mnduha ya, nda tsa la Farisa ya. ");
INSERT INTO xed_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ka waftá Yesu ta həŋ turtuk turtuk. Kaʼa mantsa: «Tɗaptɗa ta dzva gha gra,» kaʼa nda tsa mndu ya. Ka tɗaptá tsi ta tsa dzvani ya, ka vravaftá tsi yəmaɗ. ");
INSERT INTO xed_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ka kuzlanaftá tsi ta həŋ ta ŋuɗuf, ka laghu həŋ dzədzərkaku mataba taŋ ŋa zba maganatá ghwaɗaka skwi ta Yesu. ");
INSERT INTO xed_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ma tsa fitik ya, ka sliʼaftá Yesu ka laghwi tavata ghwá da maga duʼa. Ka hani tsi kurzliŋ nda iri ta maga duʼa da Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tsaɗakwa vlani, ka hagadaghatá Yesu ta duhwalhani tavatani, ka sliʼadaghatá həŋ. Ka zabaʼatá tsi ta mnduha ghwaŋpɗə his mataba taŋ, ka tsanaftá tsi ta hgu ta həŋ ka gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wya hga tsa mnduha ghwaŋpɗə his zaba a tsi ya: Mamu Simuŋ tsanaf tsi ta hgani ka Piyer, nda Andre zwaŋamani ma Simuŋ, nda Yakubu, nda Yuhwana, nda Filip, nda Bartelemi, ");
INSERT INTO xed_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nda Mata, nda Tuma nda Yakubu zwaŋa Alfe, nda Simuŋ ta hgə lu ka mnda zluʼa ghwa, ");
INSERT INTO xed_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nda Yuda zwaŋa Yakubu, nda Zudas Iskaryut. Tsa Zudas ya ta skwaptá Yesu. ");
INSERT INTO xed_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tahula tsa, ka saha həŋ kawadaga, ka sladavatá həŋ ta sana vli ka dandar tskava ŋəɗdəmata sanlaha ma duhwalhani, nda ndəghata mnduha ta sliʼakta ma luwa Ursalima, nda sanlaha ta haɗika Zudiya, nda sanlaha guli ta wa drəf ta nzakway ka luwa Tir nda Siduŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inda tsa mnduha ya ná, sliʼagagha da sna gwaɗa da Yesu həŋ, nda ya ŋa mutsa mbaku ma ɗaŋwa taŋ. Ka mbambanaftá tsi ta inda gwal kasu ghwaɗaka sulkum ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Inda mndu ta zba tvi ŋa ksaŋta dər ndəheɗ, kabga mamu mbraku ta sabə ma tsatsi ka mbamba həŋ. ");
INSERT INTO xed_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mantsa, ka waftá Yesu ta duhwalhani, kaʼa mantsa: «Rfawarfa ta rfu, kaghuni gwal ka pɗu, kabga ŋa ghuni ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Rfawarfa ta rfu kaghuni gwal ta kuzlaŋta maya ndanana, kabga dzaʼa baghaku kuni. Rfawarfa ta rfu kaghuni gwal ta taw ndanana, kabga dzaʼa ghuɓasay kuni ta ghuɓasu. ");
INSERT INTO xed_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Rfawarfa ta rfu ka ta husaŋhusa kuni ta mnduha, ka ta vzighunisvza həŋ, ka ta razay həŋ ta kaghuni, ka ta vazay həŋ ta rutsak ta kaghuni kabga vəl zlghafta ghuni ta Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rfawarfa ta rfu, ka vavalakwa kuni da rfu baɗu slaghunaghata tsa skwiha ya, kabga dzaʼa mutsay kuni ta nisəla dagala ta luwa. Mantsa ya si ta ghuya dzidzíha taŋ ŋa la anabiha ghalya. ");
INSERT INTO xed_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ɗaŋwa ŋa ghuni kaghuni gwal ka gadghəl, kabga nda ghada mutsuta ghuni ta ŋa ghuni zɗaku. ");
INSERT INTO xed_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ɗaŋwa ŋa ghuni! Kaghuni gwal nda bagha, kabga dzaʼa dzay maya ta kaghuni. Ɗaŋwa ŋa ghuni! Kaghuni gwal ta ghuɓasu ndanana, kabga dzaʼa taway kuni ta taw nda ima taw. ");
INSERT INTO xed_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ɗaŋwa ŋa ghuni! ka ta mnay inda mnduha ta zɗaku ta kaghuni, kabga mantsa si ta mna dzidzíha taŋ ta ghəŋa la ghwaɗaka anabiha ghalya.» ");
INSERT INTO xed_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ka iʼi nda kaghuni gwal ta sna gwaɗa ɗa ná, ɗvuwaɗva ta ghumaha ghuni, magawa zɗaku ŋa gwal ta husaŋta kuni. ");
INSERT INTO xed_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɗawawa tfawi ta ghəŋa gwal ta ksiʼa kaghuni. Ndəɓawa dzvu ta ghəŋa gwal ta giri ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka dzughunus dza mndu ma lagəŋ katsi, mbəɗanawa sana lagəŋ guli. Ka kləgadaghawkla mndu ta lguta huɗa gha katsi, ma pyə ka ta kləgədaghawtá dawra gha. ");
INSERT INTO xed_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vlaŋvla ta skwi ta mndu ta ɗawaŋta da kagha. Ka kləgədaghaw kla mndu ta skwa gha ŋa ŋani katsi, ma ɗawugəl ka da tsi. ");
INSERT INTO xed_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ka nu skwi ɗina ta kumə ka ghuni ta magaghunata mnduha ya, maganawamaga manda va tsaya ta hahəŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ka gwal ta ɗvutá kaghuni yeya ka kaghuni ta ɗvuta katsi, mndəra wati ma nisəla ta kzləgəlta kaghuni tama ya mantsa ya ta maga gwal dmaku guli, gwal ta ɗvutá hahəŋ ta ɗvuta həŋ? ");
INSERT INTO xed_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka ŋa gwal ta magaghunatá zɗaku yeya ka kaghuni maga zɗaku katsi, mndəra wati ma nisəla ta kzləgəlta kaghuni ya mantsa ya ta maga gwal dmaku guli? ");
INSERT INTO xed_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka ŋa gwal ta ndanu kuni dzaʼa plaghunamta yeya ka kuni ɓla nzawa katsi ní, mndəra wati ma nisəla ta kzləgəlta kuni guli ya mantsa ya ta ɓla gwal dmaku ta nzawa ŋa gwal dmaku guli, ŋa planamtá həŋ manda va tsaya? ");
INSERT INTO xed_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kaghuni ya ná, ɗvuwaɗva ta ghumaha ghuni, magawamaga ta zɗaku ŋa taŋ. Ɓlawa nzawa ŋa mnduha, ma faf kuni ta ghəŋ ta vraghunamta, dzaʼa mamu nisəla ghuni dagala, dzaʼa nzakway kuni ka zwana Lazglafta ta luwa, kabga tsatsi ná, zɗa ghəŋani nda mnduha kul haɗ ta rfa mndu, nda gwal ta sidi tani.» ");
INSERT INTO xed_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","«Tawawa tawa ta hiɗahiɗa ta mndu, manda ya ta taw Da ghuni ta hiɗahiɗa ta mndu ya. ");
INSERT INTO xed_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma tsanagha kuni ta guma ta mndu. Haɗ Lazglafta dzaʼa tsaghunaghatá guma guli wa. Ma ŋam kuni ta mndu ma ŋuɗuf, haɗ Lazglafta dzaʼa ŋamtá kaghuni ma ŋuɗuf guli wa. Pliniswa dmakwa mnduha, dzaʼa plighunispla Lazglafta ta ŋa ghuni guli. ");
INSERT INTO xed_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vlawa vla ta skwi ŋa mndu, dzaʼa vlay Lazglafta ŋa ghuni guli, ŋa ndəghaghunamta ta wa lguta ghuni, ka gəgzanata, ka va tsihwaghunamta, ka ndəghanafta ha ka paghakwani. Ta tsa skwi ta kəl kaghuni ka gra skwi ŋa mndu ya dzaʼa gra Lazglafta ŋa ghuni guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Wya ka Yesu nda həŋ nda mahdihdi guli: «Dzaʼa ksay mndu nda ghulpa ta mndu nda ghulpa ka mbaɗa ta tvi ra? Haɗ həŋ dzaʼa rkaghata his his da ghurum ra? ");
INSERT INTO xed_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Haɗ zwaŋ ta taghə lu ta skwi ŋani malaghutá Maləmani wu, ba ka nda tagha skwa tsa zwaŋ ya dzaʼa kəl tsi ka nzakway manda Maləmani kasiʼi. ");
INSERT INTO xed_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Kabgawu ta kəl kagha ka laghwi ngha hiwir ma ira zwaŋama gha, kul haɗ kagha ta nghapta ka dughusl ma ŋa gha iri na? ");
INSERT INTO xed_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Waka kagha ta mnay ŋa zwaŋama gha kazlay: Yaha ka klighista yu ta hiwir ma ira gha kəʼa, ya ngha a kagha ta dughusl ma ŋa gha iri na? Mndəra wani ma maɗgwirmaɗgwir tsa? Kligiŋ kla karaku ta dughusl ma ŋa gha iri, kada nghaŋta ka ta vli ŋa laviŋtá kligiŋtá hiwir ma ira zwaŋama gha.» ");
INSERT INTO xed_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Haɗ yakwa fu zɗa ta yaku ta fu kul zɗaku yakwani wa. Haɗ yakwa fu kul zɗaku yakwani ta yaku ta fu zɗa yakwani guli wa. ");
INSERT INTO xed_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta yakwani ta tsatsafta lu ta inda fu. Haɗ lu ta mutsaftá mana ta hulʼuwa wa. Haɗ lu ta ɗaga yakwa ghuku ta madzəfdzəf wa. ");
INSERT INTO xed_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mantsa ya guli, mataba ndəghata skwiha ɗinaɗina ma ŋuɗufani ta mnigiŋta ŋərma mndu ta skwi. Mataba ndəghata ghwaɗaka skwiha ma ŋuɗufani ta mnigiŋta ghwaɗaka mndu ta ŋani guli, kabga skwi ma ŋuɗufani ma mndu ta mnigiŋta wubisim.» ");
INSERT INTO xed_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«“Mghama ɗa! Mghama ɗa!” ka kuni ta hga iʼi, kabgawu tama? wya haɗ kuni ta maga skwi ta mnaghunata yu wu na? ");
INSERT INTO xed_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ka mnaghunamna yu ta nzakwa mndu ta sagha da iʼi ɓa. Tsa mndu ya ná, ta snaŋsna ta gwaɗa ɗa, ka ksa slna nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ka guram tsa mndu ya nda mndu ta baftá həgani. Ma zlrayni ta bay, ka ladatá tsi ta mndərani, ka thagafta ta kutumba. Ma sagha zala vlunduɗ dista tsa həga ya ma ŋa zliŋta, triɗ, traptá zliŋta kabga nda diha mndərani. ");
INSERT INTO xed_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mndu ya ta snaŋtá gwaɗa ɗa, ka kwalaghutá tsi ta ksa slna nda tsi, ka guram tsa mndu ya nda mndu ta baftá həgani ta haɗik, kul ladatá mndərani da haɗik. Ma saha zala vlunduɗ dista tsa həga ya, gi krip zluta tesneʼ ɗekɗek,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tahula kɗiŋta Yesu ta mna inda tsa gwaɗa ya ŋa tsa ndəghata mnduha ta sna tsa gwaɗani ya, ka sliʼaftá tsi ka lami da luwa Kafarnahum. ");
INSERT INTO xed_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hada, mamu sana mghama sludza la Ruma kul ɗughwanaku kwalvani ya ɗvu tsi katakata, ta dzaʼa mtaku. ");
INSERT INTO xed_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Manda snaŋta tsa mghama sludzi ya ta mna gwaɗa ta Yesu, ka ghunadaptá tsi ta la galata mndu ta ghəŋa la Yahuda, ŋa guyata nda Yesu, ŋa ndəɓanatá dzvu ŋa sagha mbanaftá tsa kwalvani ya. ");
INSERT INTO xed_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ka sliʼaftá həŋ ka lagha slanaghatá Yesu, ka ndəɓanatá həŋ ta dzvu katakata. Ka həŋ mantsa: «Kdəkkdək nda ra kataŋta gha ta tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tsa mndu ya ná, ta ɗvay ta mndəra amu, tsatsi ta baŋnaftá həga tagha skwi,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka sliʼaftá Yesu ka dzaʼa kawadaga nda həŋ. Ndusa Yesu ka ɓhadaghata tama ta ghungladapta tsa mghama sludzi ya ta grahani ŋa mnanatá Yesu. Ka həŋ mantsa: «Mghama ɗa, yaha lu da daŋwazlaghafta, ra a yu ka ŋlata gha ga ini wa. ");
INSERT INTO xed_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tsaya dər kəl yu ka mnay kazlay: La a vərɗa iʼi da guya kuma nda tsi wu kəʼa. Ka sabsa gwaɗa ma wa gha ya ná, prək mbanaftá kwalva ɗa tsa. ");
INSERT INTO xed_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iʼi guli ná, mista gwal dagaladagala nziŋta yu, mamu sludziha ta ksa slna mista iʼi guli. Ka “la,” ka yu nda sani ná, gi sliʼani. Ka “saghasa,” ka yu nda sani guli ná, gi saghani. Ka “magamaga ta ya skwi ya,” ka yu nda kwalva ɗa, gi magatani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na snanata Yesu ta tsa gwaɗa ya, ka ndrauʼ tsi nda ndrauʼuwa ta tsa mghama sludzi ya. Ka mbəɗavatá tsi tvə tsa ndəghata mnduha ta dzaʼa mistani ya. «Ka yu ta mnaghunata ná, dər mataba la Israʼila, ta slanagha a yu ta mndərga nana ma zlghay nda ŋuɗuf wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ta vradaghatá tsa mnduha si ghunagha tsa mghama sludzi ya dzagha, ka slanaghatá həŋ ta mbatá tsa kwalva si kul ɗughwanaku ya. ");
INSERT INTO xed_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tahula tsa ka sliʼaftá Yesu ka laghwi da sana luwa ta hgə lu ka Nayina. Ka sliʼaftá duhwalhani nda dəmga guli mistani. ");
INSERT INTO xed_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ndusa ka lami ta watgha tsa luwa ya, ka guyatá tsi nda mnduha ta kla mbli ŋa paɗay. Tsa mbli ya, kɗakwakɗakwa zwaŋa sana markwa wadgu ya. Nda tska mnduha tsa luwa ya ta dzaʼa mista tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na nghaŋta Yesu ta tsa marakw ya, ka ksaftá tsi ka hiɗahiɗa. «Ma taw ka» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ka gavadaghatá Yesu tavata tsa kativiŋ ta kəl lu ta mbli tida ya, ka ksaŋta. Ka sladavatá tsa mnduha ta kla mbli ya. «Iʼi ya ta gwaɗa nda kagha galaɓay ɗa, sliʼafsliʼa gha!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka sliʼaftá tsa mbli ya ka nzata, ka gwaɗə tsi ta gwaɗa. «Wya zwaŋa gha makwa ɗa,» ka Yesu nda tsa mani ya. ");
INSERT INTO xed_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ka ksutá tsi ta inda taŋ ka zləŋ. Ka zləzlvu həŋ ta Lazglafta guli. «Nda zlaga mghama anabi mataba mu, saghasa Lazglafta nghanaghatá mnduhani,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ta ghəŋa tsa skwi ya, ka tuta gwaɗa wdiɗ ta ghəŋa Yesu ta inda haɗika Zudiya, nda ya ma inda luwaha ta wanafta. ");
INSERT INTO xed_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ka snanamtá duhwalhani ma Yuhwana, ta inda tsa skwiha ta maguta ya ta Yuhwana. ");
INSERT INTO xed_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ka hgaftá Yuhwana ta gwal his mataba duhwalhani, ka ghunaftá həŋ da Mgham Yesu. Kaʼa nda həŋ mantsa: «Lawala ɗawaŋta! Kagha tsa mndu snə ŋni dzaʼa sagha ya re, ari ka kzla ŋni ta sana mndu a na?» ka kuni nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ka sliʼaftá həŋ ka ɓhadaghata da Yesu. Ka həŋ mantsa: «Yuhwana mnda maga batem ta ghunagaŋnaghata da kagha kazlay: Kagha tsa mndu snə ŋni dzaʼa sagha ya re, ari ka kzla ŋni ta sana mndu a na kəʼa?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma va tsa fitik ya, ka mbambanaftá Yesu ta ndəghata mnduha ma ɗaŋwa taŋ, nda gwal nda raghwa, nda gwal kasaf ghwaɗaka sulkum, gwananaha ta iri ta gwal si nda ghulpa. ");
INSERT INTO xed_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kaʼa nda həŋ mantsa: «Lawala mnanata Yuhwana ta inda skwiha nghaŋ kuni, nda inda skwiha sanaŋ kuni. Gwal si nda ghulpa nda ngha həŋ ta vli, ta mbaɗa gwal si nda raghwa səla taŋ, kwandlaŋkwandlaŋ mbambatá gwal si nda rɗa mndu ta həŋ, nda gwana sləməŋa gwal si ka rgha si kul snaŋtá sləməŋ. Gwal si nda rwa, varamvara həŋ nda hafu. Mananamana lu ta Lfiɗa Gwaɗa ta gwal ka pɗu. ");
INSERT INTO xed_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Rfu da mndu ta kwal kul zlaŋtá zlghay nda ŋuɗufani ta iʼi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Manda vraghuta tsa mnduha si ghunadap Yuhwana ya, ka zlraftá Yesu ta mna gwaɗa ta ghəŋa Yuhwana ŋa tsa ndəghata mnduha ta tskavata ya. Kaʼa mantsa: «Ma tsa laghwa ghuni da mtak ya ní, nahgani laghu kuni nghay? Sana mndu ta tatamaku manda sulam ta gigɗu falak rki laghu kuni da nghay? ");
INSERT INTO xed_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ka tsa a tsi wu, nahgani laghu kuni nghay ɓa? Sana mndu nda suɗatá lgut ta wuɗaku ta vghani rki laghu kuni da nghay? Ya wya gwal ta kla lgut nda bla dzvani ná, ta za mghama taŋ həŋ ka nzaku ma həga ma mgham mgham. ");
INSERT INTO xed_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wa va mndu laghu kuni da nghay tama na kula? Sana anabi rki laghu kuni da nghay? Aŋi mantsa nzakwani, malaghumala tsa mndu ya ta mbrakwa anabi. ");
INSERT INTO xed_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta ghəŋa tsa Yuhwana ya vindafta lu ma deftera Lazglafta kazlay: Iʼi Lazglafta wana yu ta tiŋlaghutá ghunaftá mndu ka kagha ŋa dzaʼa faɗaghata tvi kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ka yu nda kaghuni wa, mataba inda mndu ya yaga marakw nda ya ná, haɗ ya ta malaghutá Yuhwana wa. Tsaw tama, mndu ta nzakway kwitikw ma ga mghama Lazglafta ná, malaghumala ta Yuhwana. ");
INSERT INTO xed_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tsaw inda hamata mnduha nduk nda gwal tska dzumna tani, snaŋta taŋ ta gwaɗa Yuhwana, ka həŋ mantsa: “Ta kumay Lazglafta ta mbamafta,” ka həŋ. Ka ɗawu həŋ ta maganaftá batema Yuhwana ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kuraghuta la Farisa nda gwal tagha zlahu ŋa mnduha ya, ka kwalaghuta həŋ ta tsuʼaftá skwi ta kumə Lazglafta ta magay ŋa taŋ. Ka kwalaghutá həŋ ta tsa batem ta magə Yuhwana ya.» ");
INSERT INTO xed_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","«Ndaw dzaʼa gra yu ta mnduha ta na fitik na? Yakwa wa həŋ? ");
INSERT INTO xed_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ka guram nda zwani ta kurɓut ta mnay mataba taŋ kazlay: Vyanafha ŋni ta siŋlak skala a kuni wu, fanafha ŋni ta laha ta taw, tawaŋ a kuni ta taw wu kəʼa ya həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tsaya ná, nzakwani manda sagha Yuhwana mnda maga batem, ka kwalaghuta tsi ta za buradi nda sa ima inabi, “aʼ nda ksa da halaway” ka kuni. ");
INSERT INTO xed_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Saghaha Zwaŋa mndu guli, ka zay ka say, “aʼ dagala mahahawʼani, dagala sasakwani, gra gwal tsəka dzumna nda la ghwaɗaka mnduha ya,” ka kuni. ");
INSERT INTO xed_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Inda gwal nda ɗifil ma ghəŋa taŋ ná, tsatsaftsatsa hahəŋ ta vərɗaka ɗifla Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ka hgaftá sana la Farisa ta Yesu ŋa za skwa zay ga taŋ. Ka lagha Yesu da tsa mndu ya, ka lamə tsi da həga ka zə tsi ta skwi. ");
INSERT INTO xed_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mamu sana ghwaɗaka marakw ma tsa luwa ya, ka snaŋtá tsi kazlay: Waʼa Yesu ta za skwa zay ga tsa la Farisa ya kəʼa, ka klaftá tsi ta hwaraka Albastra ndəghatani nda urdi nda bla dzvani, ka kladaghata. ");
INSERT INTO xed_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ka lagha tsi tavata səla Yesu nda ga mahulhulani, ka mbəza ima taw ta səla Yesu, ka ksaftá tsi ta swidani ka takaɗay nda tsi, ka habwaʼaku ta səlani, ka pgha tsa urdi ya ta səla Yesu. ");
INSERT INTO xed_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na nghaŋta tsa mnda la Farisa ta hgadaghatá Yesu ya ta tsa skwi ya, kaʼa ma ghəŋani mantsa: «Ka ma vərɗa anabi na mndu na ná, ma dzaʼa tsatsaftsatsa ta mndərga na marakw ta ksaŋta na. Ma dzaʼa nda sna kazlay: Ghwaɗaka marakw ya kəʼa.» ");
INSERT INTO xed_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ka Yesu zlraftá gwaɗa nda tsa mnda la Farisa ya mantsa: «Ari Simuŋ, mamu gwaɗa ta kumə yu ta mnaghata,» kaʼa. «Aŋi Mghama ɗa mna,» kaʼa zlghanaftá wi. ");
INSERT INTO xed_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","«Mamu sana mndu ta ɓalanaftá nzawa ta sana mnduha his. Prək ka tseda vagha mnduha hutaf dərmək kəʼa vlaŋtá sani, prək ka tseda vagha mnduha hutaf mbsak kəʼa vlaŋtá sani guli. ");
INSERT INTO xed_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka traptá həŋ ta palata kabga haɗ skwi da həŋ prək ka palata taŋ wa. Ka zlanaŋtá tsi ta tsa dməŋ ya ta həŋ his his. Wati mataba tsa mnduha ya dzaʼa malaghuta ɗvutá tsa mndu ya, ka kagha ta gray na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","«Mataba tsa mnduha ya ra! Ta graftá yu ná, tsa mndu zlanaŋ lu ta ŋani dagala ya ya,» ka Simuŋ. «Ta ŋa gha,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ka mbəɗavatá Yesu tvə tsa marakw ya, ka mnə tsi ŋa Simuŋ: «Nda ngha ka ta na marakw na kiʼe? Samsa yu da həga ga ghuni, walaŋ a ka ta tiɗiftá imi ŋa mbaza səla ɗa manda ya snu lu wu, ka mbazihatá na marakw na nda ima tawani, ka takaɗihata nda swidani. ");
INSERT INTO xed_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Brusa a ka ta iʼi ma sagha ɗa manda ya snu lu wa. Tsatsi, ka yawu sama ɗa ta zlana a ta brusa səlaha ɗa wa. ");
INSERT INTO xed_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Walaŋ a ka ta pghigihatá rɗi ma ghəŋ manda ya snu lu wu, tsatsi, pghiɗif pgha tsatsi ta rɗi ta səlaha ɗa. ");
INSERT INTO xed_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ka yu ka mnaghata na: Nda pla inda dmakwa na marakw na. Tsaya kəl tsi ka maraŋta ɗvutani ta iʼi dagala. Ka kiʼa planata lu ta dmakwa mndu ya, kiʼa ɗvu maraŋ tsa mndu ya guli.» ");
INSERT INTO xed_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","«Nda pla inda dmakwa gha makwa ɗa» ka Yesu nda tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ka sana mnduha ta za skwi kawadaga nda tsi mantsa: «Wa va na mndu na katək na? Ta uwala pla dmaku na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","«Zlghay nda ŋuɗufa gha ta mbaghafta makwa ɗa, la nda vghata zɗakwa gha,» ka Yesu nda tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tsəɓakw fitik tahula tsa, ka laghwi Yesu da ra luwaha dagaladagala nda luwaha kwitikw kwitikw, ka tuza Lfiɗa Gwaɗa ta ghəŋa ga mghama Lazglafta, ka mna gwaɗa ta ghəŋani ");
INSERT INTO xed_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nda sanlaha ma miʼaha ya ghazligiŋ lu ta ghwaɗaka sulkumha ma həŋ, ka mbambanaftá həŋ ma ɗaŋwaha taŋ. Tekw i Mari makwa ta Magdala sliʼagap ghwaɗaka sulkumha ndəfáŋ mida, ");
INSERT INTO xed_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nda Yuwana markwa Kuza. Tsa Kuza ya, mndu ya fanam mgham Hiridus ta inda skwi ma həgani ma dzvani ya. Mamu Suzana, nda ndəghata sanlaha ma miʼaha guli mataba taŋ. Inda tsa miʼaha ya ná, kataŋkata həŋ ta i Yesu nda duhwalhani nda skwi ma dzva taŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ka sliʼaktá mnduha ma luwaha kavghakavgha ka tskavata tizlik tavata Yesu. Mantsa tama, ka zlraftá Yesu ta mna mahdihdi: ");
INSERT INTO xed_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mbaɗa sana mndu ka sliʼafta ka laghwi da wutsa hulfa ma vwahani. Tata wutsaywutsay, ka rkata sanlaha ma tsa hulfaha ya ta tvi, ka diŋlaku lu tida, ka sliʼadaghata ɗyakha da ɗaguta. ");
INSERT INTO xed_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka rkatá sanlaha ta kluluh: Na tsa gi ɗyaftani ya, ka ghwalutá tsi kabga haɗ nasa mistani wa. ");
INSERT INTO xed_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka rkamtá sanlaha ma teki, ka ɗyaftá tsi, ka glanaghatá teki ka raghwanata. ");
INSERT INTO xed_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka rkatá sanlaha ta gənək. Tsahaya, ka ɗayaftá həŋ, ka glafta ka pghaftá ghəŋ ghərmbəts ghərmbəts. Ka mamu mndu nda sləməŋa snay, ka sna tsi,» ka Yesu sganaghata nda lwi dagala. ");
INSERT INTO xed_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","«Nu klatá ghəŋa tsa mahdihdi ya na?» ka duhwalhani ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","«Kaghuni, vlaghunavla lu ta snaŋtá ɗifatá gwaɗa ta ghəŋa ga mghama Lazglafta. Ŋa sanlaha ya, ba nda mahdihdi dzaʼa mnanaŋta lu ta həŋ kabga “ta nghay həŋ, triɗ ngha a həŋ wu, ta snay həŋ, sew sna a həŋ wa.”» ");
INSERT INTO xed_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Wya klatá ghəŋa tsa mahdihdi ya: Tsa hulfa ya ná, gwaɗa Lazglafta ya. ");
INSERT INTO xed_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sanlaha ma mnduha ná, manda tvi rkaf hulfa tida həŋ. Hahəŋ ná, gi snaŋta taŋ ta gwaɗa Lazglafta, gi ndadaghata halaway klugudunustá həŋ yaha həŋ da zlghafta ma ŋuɗufa taŋ da mbafta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sanlaha ma mnduha guli ná, manda kluluh rkaf hulfa tida həŋ, snaŋta taŋ ta gwaɗa Lazglafta, gi zlghafta taŋ nda rfu, ama haɗ həŋ ta zlaŋtá vli ŋa dzugwamta tsa gwaɗa ya ta slrəŋ ma ŋuɗufa taŋ wa. Ka dzghaŋdzgha skwi ta həŋ, gi suwak zlaŋta taŋ ta zlghay nda ŋuɗufa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sanlaha ma mnduha guli ná, manda hulfa ta rkamta da teki ya həŋ, snaŋta taŋ ta gwaɗa Lazglafta ka laghu həŋ da ndana nzaku ma ghəŋa haɗik nda zba gadghəl nda ndana zba skwi ta haraʼuwa iri, mantsa tama, mbaɗa tsa skwiha ya ka raghwa tsa gwaɗa ya, ka niŋta həŋ ka ksubaŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sanlaha ma mnduha guli, manda gənək həŋ, snaŋta taŋ ta gwaɗa Lazglafta, ka zlghaftá həŋ nda ŋuɗuf turtuk, ka ŋanatá həŋ ka ksa slna nda tsi ka dihavata mida.» ");
INSERT INTO xed_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ka mnaghunamna yu ɓa! Haɗ mndu ta tsamta vu ma pitirla ka dzuɓamta ma tughuba wu, haɗ ta fiŋta mista ghzləŋ guli wu, ta fagata ta vli tskala, kada nghaŋta gwal ta lamə da dzuguvi ta tsuwaɗak. ");
INSERT INTO xed_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Inda skwi nda ɗifa ná, dzaʼa maravamara. Inda skwi nda bukwa guli dzaʼa snaŋsna lu, ŋa zlagaptani bɗaŋay ta daɓi. ");
INSERT INTO xed_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ɗasuwa ka kuni nda tva snaŋta skwi ta snaŋta kuni, kabga ŋa mndu nda guna sləməŋani ŋa sna skwi dzaʼa sganaghata lu ta snanamta. Ama ka haɗ tsi da mndu wu, dzaʼa kləgadanaghu kla lu ta va tsa má si ta ndanu tsi ta mutsay ya.» ");
INSERT INTO xed_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ka lagha i mani nda zwanamani ma Yesu slanaghata, ama triɗ traptra həŋ ta ɓhanavata, tskutska mnduha. ");
INSERT INTO xed_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","«Wa a i ma gha nda zwanama gha ma bli ta gəvala kagha,» ka lu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","«Gwal ta sna gwaɗa Lazglafta ka maga slna nda tsi, tsaha ya i ma ɗa nda zwanama ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ma sana fitik, «mbaɗma ta a sana ɓla drəf a,» ka Yesu nda duhwalha, ka sliʼafta həŋ kla lamə da kwambalu ka sliʼi. ");
INSERT INTO xed_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tata ndəru həŋ, ka dzata hani ta Yesu, ka sliʼavafta mativirauʼ ta ghəŋa drəf, ka dzaʼa imi ndəghanaftá kwambalu. Ta wa hɗak həŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ka lagha həŋ sliʼa Yesu, «Maləm! Maləm! Nda zaɗa mu!» ka həŋ nda tsi. Ka sliʼavatá Yesu ka davanaghatá tsi ta falak, nda tsa vavalakwa imi ya. Ka lɓatá vli ka nzata tɓekw. ");
INSERT INTO xed_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","«Nu ta kəl kuni ka zləŋ mantsa? Kulam ndana haɗ zlghay nda ŋuɗuf da kaghuni ɗekɗek katək ra?» kəʼa mbəɗavata tvə duhwalhani. Ka ksaftá zləŋ ta həŋ, ka ndraʼu həŋ. «Wa na mndu na katək na? Na dvanaghatani ta dər falak nda imi ná, gi ka snanata taŋ?» ka həŋ mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ka ɓhadaghata i Yesu nda duhwalhani ta haɗika Geraseni ta nzakway mbəŋ ya mbəŋ ya nda luwa Galili. ");
INSERT INTO xed_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nda fagata Yesu ta səla ta haɗik ta sabə tsi ma kwambalu, ka sagha sana mnda tsa luwa ya da guyay. Tsa mndu ya ná, ksuksa duhwala halaway. Nda kɗa fitikani kul suɗgəltá lgut ɗekɗek, haɗ ta nzəglata mintgha wu, mataba kuluha kəʼa ta nzaku. ");
INSERT INTO xed_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na ghur nghayni ta Yesu, ka wahatá tsi ka zləmbatá ma ghuvani. Kaʼa mantsa: «Yesu Zwaŋa Lazglafta ta luwa, Nya mataba u nda kagha? Kdəkkdək, wya dzvu, yaha ka ghuyɗiptá ɗaŋwa,» kaʼa wahata nda lwi dagala. ");
INSERT INTO xed_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kəl tsi ka mna tsaya na: Sabsa ma na mndu na ka Yesu dvanaghtá tsa duhwala halaway ya. Tsa mndu ya ná, nda kɗa fitika ksafta tsa duhwala halaway ya. Ma tsa fitika ksaftani ya, si ta habafhaba mnduha nda ziɗa, ka tsamtá səlahani ma tsuhwal, ma ŋa habanata. Ka raratsiŋtá tsi ka ɓaɓaliŋta. Ka klaghatá tsa duhwala halaway ya ka laghwi ra vli ma mtak. ");
INSERT INTO xed_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","«Wa hga gha na?» ka Yesu nda tsi. «Dɓaʼ hga ɗa,» kaʼa zlghanaftá wi. Kəl tsi ka mna tsaya ná, kabga nda ndəgha duhwala halaway ta sliʼamta dida. ");
INSERT INTO xed_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","«Kdəkkdək, yaha ka da ghuna aŋni da gudzuvruŋwa vu,» ka tsa duhwala halaway ya ndiʼata, ka ndəɓa dzvu da Yesu. ");
INSERT INTO xed_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ndusa nda tsa vli ya, mamu sana bra ghuvazu ta zbutá skwa zay taŋ tavata ghwá. «Kdəkkdək vlaŋna tvi, ka sliʼamta ŋni da a ghuvazuha a,» ka həŋ nda Yesu. «Aray,» ka Yesu vlaŋtá tvi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ka gi sliʼagaptá tsa duhwala halaway ya ma tsa mndu ya, ka sliʼamta da tsa ghuvazuha ya. Ka vazagatá tsa ghuvazuha ya ta vgha tavata tsa ghwá ya ka rkaghata da drəf ka rwuta. ");
INSERT INTO xed_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nghay tsa mnduha ta ngha tsa ghuvazuha ya ta tsa skwi ta magata ya, ka hwayaftá həŋ ka laghwi tay ma luwa nduk ma zwana luwaha ta tsa skwi ta maguta ya. ");
INSERT INTO xed_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ka sliʼaftá mnduha ka laghwi da ngha tsa skwi ta maguta ya. Ka lagha həŋ slanaghatá Yesu, ka slaftá həŋ ta tsa mndu sliʼagap duhwala halaway mida ya ta nzaku kurevesa tavatá səla Yesu nda suɗatá lgut ta vgha, nda mbatani kwandlaŋ. Nghaŋta taŋ, ka ksutá tsi ta həŋ ka zləŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mbaɗa tsa gwal si ta nghay ta magaku tsa skwi ya, ka rusay ŋa taŋ ká tsa mndu si ksaf duhwala halaway ya mbafta. ");
INSERT INTO xed_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka həŋ mantsa: «Kdəkkdək sliʼapsliʼa ma haɗika ŋni,» ka inda mnduha ma haɗika Geraseni nda Yesu, kabga nda ksa həŋ da zləŋ katakata. Ka sliʼaftá Yesu ka lamə da kwambalu ŋa vru. ");
INSERT INTO xed_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","«Wya dzvu, kla ta iʼi ta səla gha,» ka tsa mndu sliʼagap duhwala halaway mida ya nda Yesu. ");
INSERT INTO xed_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Vra dzagha gha, ka dzaʼa ka rusa inda skwi maga gha Lazglafta,» ka Yesu pyafta ka dzaʼa mistani. Ka sliʼaftá tsi ka laghwi tay ma inda luwa ta inda skwi magana Yesu. ");
INSERT INTO xed_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ta vrəgladaptá Yesu ta sana ɓla drəf, ka slanaghatá tsi ta ndəghata mnduha guli ta kzlay hada ŋa zlghafta. ");
INSERT INTO xed_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mbaɗaka sana mndu ta hgə lu ka Zayrus ta nzakway tekw mataba la mali ta ghəŋa həga tagha skwa la Yahuda, ka lagha zləmbatá ma ghuva Yesu. Kaʼa mantsa: «Kdəkkdək mbaɗa da ini,» kaʼa nda tsi, ");
INSERT INTO xed_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kabga mamu kɗakwakɗakwa makwani ta kla imi ghwaŋpɗə his kul ɗughwanaku ta kala ghəŋ. Ka sliʼaftá Yesu ka dzaʼa mistani. Ta mbaɗa Yesu ka dzaʼa mataba tskata mnduha, haɗ tva mbəɗayni ta vgha wa. ");
INSERT INTO xed_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mamu sana marakw mataba taŋ Maghwaŋapɗə hisa vakwani tsa ta paghaku. Kɗiŋkɗa ta inda skwi ma dzvani ŋa la duhtur. Haɗ ya ka dər turtuk mataba taŋ ta mbanafta wa. ");
INSERT INTO xed_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka lagha tsa marakw ya nda ga mahulhula Yesu ka ksaŋtá wa lgutani. Na tsa gi ksaŋtani ya, gi hleʼ sladata tsa paghaku ya tsa. ");
INSERT INTO xed_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ka Yesu mantsa: «Wa tsa ta ksita ya na?» kaʼa. «Andaw! Andaw! Andaw!» ka mnduha. Ka Piyer mantsa: «Maləma ɗa! Mataba ndəghata mnduha mandana ta waghafta, haɗ tva mbəɗa vgha gha ná, wa ta ksihata na, ka ka?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ka Yesu mantsa: «Mamu mndu ta ksihata! Nda sna yu ta mbraku ta savaghuta ma iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Snay tsa marakw ya ta tsa gwaɗa ya ná, a nda tsatsa yu, kaʼa. Ka lagha tsi nda ghudzatani da zləŋ zləmbatá ma ghuva Yesu, ka mnə tsi ta kəma inda mnduha ta skwi kabgawu kəl tsi ka ksaŋta nda ya kəʼa mbafta ma va tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ka Yesu mantsa: «Makwa ɗa, zlghay nda ŋuɗufa gha ta mbaghafta, la nda vgha ta zɗakwa gha,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tata tsa gwaɗa ya Yesu, ka lagha sana mndu ta sliʼafta ga Zayrus da mnay ŋa Zayrus: Kaʼa mantsa: «Kɗakwa tsa makwa gha ya tsa, ta ŋa daŋwazlgəlta gha ŋaw ta Maləm na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka Yesu mantsa: «Ma tɗu ŋuɗufa gha, fata gha ta ghəŋa gha yeya ŋa gha, dzaʼa mbaku,» ka Yesu nda Zayrus snaŋər tsi ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Manda ɓhadaghata taŋ da taŋ, ka pyaftá Yesu ta mnduha ta lami da həga mistani, ka hlaʼatá tsi ta i Piyer nda Yuhwana, nda Yakubu nda dani nda mani ma tsa makwa ya ŋa lamə mistani. ");
INSERT INTO xed_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta lamə həŋ, ta wahu inda gwal ma həga ka tawa ghəŋ ta ghəŋa tsa makwa ya. Ka həŋ mantsa: «Ma taw kuni, mta a wu, hani ta hani tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","«Ta mndu nda mta ná, mta a wu kaʼa,» ka həŋ ka ghuɓasay. ");
INSERT INTO xed_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ka lagha Yesu ksaftá tsa makwa ya ta dzvu. «Sliʼafsliʼa gha makwana!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ka vramtá tsa makwa ya, ka gi sliʼafta. «Vlaŋwavla ta skwa zay,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ndandrakauʼ ká i dani nda mani ma tsa makwa ya nzata ka ndərmimay. «Yaha kuni da mnay dər ŋa wati ma mndu ta skwi ta maguta,» ka Yesu zlahanaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lagha Yesu ka tskanatá duhwalhani ghwaŋpɗə his, ka vlaŋtá tsi ta həŋ ta mbrakwa mbranaghatá inda duhwala halaway, nda mbrakwa mbambanaftá ɗaŋwaha. ");
INSERT INTO xed_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ka ghunaftá tsi ta həŋ tuza gwaɗa ta ghəŋa ga mghama Lazglafta, nda mbambanaftá gwal kul ɗughwanaku. ");
INSERT INTO xed_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma kɗaku həŋ sliʼafta, kaʼa nda həŋ mantsa: «Yaha kuni klaftá sana skwi ɗekɗek ŋa dzaʼa da wawaku, dər dafa, dər zlibi, dər skwa zay, dər tsedi, turtuk turtuk ka kuni da klaftá lgut. ");
INSERT INTO xed_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dər ma wati həga da tsuʼafta lu ta kaghuni ya, nzata ghuni hada ha ka sagha fitika sliʼapta ghuni ma tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ala, dər ga vli dzaʼa kwal lu tsuʼaftá kaghuni ya, wya dzva ŋni wya dzva ŋni ka kuni dazlay ka zlanavata kuni ta tsa luwa ya, tsaya dzaʼa maranaŋtá həŋ ta ɓasa ŋuɗufa Lazglafta ta ghəŋa taŋ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ka sliʼaftá həŋ ka laghwi da ra luwaha, ka mna Lfiɗa Gwaɗa, ka mbamba gwal kul ɗughwanaku ma inda vli. ");
INSERT INTO xed_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na snaŋta tsa Hiridus Tetrak ta nzakway ka mgham ta haɗika Galili ya, ta mna gwaɗa ta inda skwiha ta magaku. Ka traptá tsi ta skwi ŋa ndanay. «Aʼ, Yuhwana ya ta sliʼagapta nda hafu,» ka sanlaha ta mnay. ");
INSERT INTO xed_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","«Aʼ, anabi Iliya ya ta zlagapta,» ka sanlaha. «Aʼ, sani mataba la anabiha ghalya ya ta sliʼagapta,» ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","«Ya wya tsaghwa tsa ta ghəŋa Yuhwana ka yu, ka tsaghutá lu ní, wa na mndu na ta mnə lu ta mndərga na skwiha ta snə yu na ta ghəŋani tama?» ka Hiridus, ka psə tsi ta tva nghaŋtá Yesu. ");
INSERT INTO xed_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ka varaktá tsa gwal ghunay ya. Manda varakta taŋ, ka rusu həŋ ŋa Yesu ta inda skwi maga həŋ. Ka hlaghatá Yesu ta həŋ mistani, ka laghu həŋ nda tvə sana luwa ta hgə lu ka Betsayda nda ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Snaŋta dəmga kazlay: Laghula həŋ kəʼa, ka sliʼaftá həŋ zbiŋtá həŋ. Ka lagha həŋ slanaghatá həŋ, ka zlghaftá Yesu ta həŋ, ka mnə tsi ta gwaɗa ta ga mghama Lazglafta ŋa taŋ. Ka mbambanaftá tsi ta gwal ta kuma mbambanaftá həŋ ma ɗaŋwa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ta fitik hawu, ka gavadaghatá duhwalhani tavatani, ka mnay ŋani: «Mnanamna ta na mnduha na, ka dzaʼa həŋ da luwa dagaladagala nda luwaha kwitikw kwitikw ta waftá na vli na, ŋa dzaʼa taŋ zba skwa zay nda vli ŋa hana taŋ, kabga ma mtak mu hadna,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka Yesu nda həŋ mantsa: «Vlaŋwavla kaghuni ɓa ta skwi ŋa zay ta həŋ,» kaʼa. Ka duhwalhani mantsa: «Buradi hutaf nda tsulhwa klipi his yeya da amu, ŋa dzaʼa ŋni da dzawagaghatá skwa zay ŋa zuŋtá inda na mnduha na rki?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsaw ta magay mnduha ta dəmbuʼ hutaf ma tsa vli ya. «Mnanawa mna ta həŋ ka tsakavata həŋ hutaf mbsak hutaf mbsak,» ka Yesu nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","«Aray!» ka həŋ ka tsakanatá həŋ ta mnduha. ");
INSERT INTO xed_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ka hlaftá Yesu ta tsa buradiha hutaf ya, nda tsa tsulhwa klipi his ya, ka nghadaftá tsi nda ta luwa, ka rfanaghatá tsi ta Lazglafta ta ghəŋani, ka ɓalanaptá tsi ka valaŋtá duhwalhani ŋa daganaftá mnduha. ");
INSERT INTO xed_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ka zə inda tsa mnduha ya, ka babaghawtá həŋ. Ka tskaftá lu ta paɗakwani ka ghwanak ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ma sana fitik ta nzaku Yesu turtukwani ka maga duʼa, ka lagha duhwalhani slanaghata. Kaʼa ɗawaŋta da həŋ mantsa: «Wa iʼi ka dəmga ta mnay na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka duhwalhani mantsa: «Tsa Yuhwana mnda maga batem ya kay ya, ka sanlaha. Iliya ya, ka sanlaha. Sani mataba la anabi ghalya ya ta sliʼagapta nda hafu, ka sanlaha,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kaʼa nda həŋ guli mantsa: «A ki kaghuni, waya ka kaghuni ta mnay nda iʼi na?» kaʼa. Ka Piyer mantsa: «Kagha ná, Kristi ka,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka Yesu zlahanaghatá həŋ ka ŋɗaŋɗa mantsa: «Yaha kuni da mnay dər ŋa wati ma mndu tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kaʼa sganaghata guli na, «dzaʼa ghuyay Zwaŋa mndu ta ɗaŋwa katakata, dzaʼa wɗiŋwɗa la galata mndu nda gwal mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha. Dzaʼa dzadza lu, ŋa sliʼagaptani nda hafu baɗu mahkən,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wya kaʼa nda həŋ demdem: «Ka ta kumay mndu ta dzaʼa mista ɗa katsi, ba zlaŋtani ta ndanu ta ghəŋa ghəŋani, ka vlatani ta ghəŋani ka kla udza zləŋayni inda fitik, ka dzaʼa mista ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kaʼa guli mantsa: «Ka dzaʼa mbanafmba yu ta hafa ɗa ka mndu katsi, dzaʼa Zaɗiŋzaɗa tsa mndu ya ta hafani. Ala ka dzaʼa Zaɗiŋzaɗa mndu ta hafani ta ghəŋa iʼi katsi, dzaʼa mbanafmba tsa mndu ya ta hafani. ");
INSERT INTO xed_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nu dzaʼa kataŋta mutsafta mndu ta inda na ghəŋa haɗik na ka ŋani ka Zaɗiŋzaɗa tsi ta hafani, ka ghəŋani a tsi na? ");
INSERT INTO xed_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ka ta ɓasa zləŋ mndu ka mnaŋtá hga ɗa, nda gwaɗa ɗa guli katsi, iʼi Zwaŋa mndu guli ná, dzaʼa kwalaghukwala iʼi guli ta mnaŋtá tsa mndu ya baɗu sagha dzaʼa sagha yu ma glakwa ɗa, nda ya ma glakwa Da ɗa nda duhwalhani nda ghuɓa, ta luwa. ");
INSERT INTO xed_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kahwathwata ka yu ta mnaghunata: Mamu sanlaha ma mnduha mataba gwal hadna dzaʼa kwal kul rwuta ta saha ga mghama Lazglafta, dzaʼa nda ngha həŋ nda ira taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ta magay fitik tghas manda mnutani ta tsa gwaɗa ya, ka hlaftá Yesu ta i Piyer nda Yuhwana nda Yakubu, ka ŋlaghatá həŋ ta ghwá da maga duʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta magə Yesu ta duʼa, ka mbəɗavaftá kumani tskəm, mbəɗavafha lgutani ka wuɗaku tilil ka ŋusliŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gi wya mnduha his ta ghwa yiva nda tsi. I Musa nda Iliya tsa mnduha ya, ");
INSERT INTO xed_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ta zlagapta ta wuɗaku tili ma glakwa Lazglafta ta luwa, ta gwaɗa nda Yesu kinawu kəʼa dzaʼa kɗiŋta magata skwi ta kumə Lazglafta nda ma mtakwani ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma tsa fitik ya, nda ghərɓa i Piyer nda grahani da hani, sliʼavata taŋ, ka nghaŋtá həŋ ta glakwa Yesu nda tsa mnduha his ya tavatani. ");
INSERT INTO xed_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma fitika dgay tsa mnduha ya ta vgha nda Yesu, ka Piyer nda Yesu mantsa: «Maləma ɗa! Ɗina ka nzakwa mu hadna, ka magafmaga ŋni ta həga tumpul hkən. Pal ŋa gha, pal ŋa Musa, pal ŋa Iliya!» kaʼa. Tsaw, snəgla a Piyer ta skwi ta mnə tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tata mna tsa gwaɗa ya tsatsi, ka saha kusay bukwamtá həŋ, ka ksaftá zləŋ ta tsa duhwalha ya nghər həŋ ta saha tsa kusay ya bukwamtá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ka gwaɗagaptá lwi ma tsa kusay ya. Kaʼa mantsa: «Nanana zwaŋa ɗa ya zbap yu, snawasna ta gwaɗa da tsi!» kaʼa ");
INSERT INTO xed_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tahula gwaɗata tsa lwi ya, Yesu yeya ta nghə lu turtukwani, sriw nzanza tsa duhwalha ya ma tsa fitik ya, haɗ mndu ya mnanaŋ həŋ ta tsa gwaɗa ya wa. ");
INSERT INTO xed_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gamahtsimani ka saha həŋ ta ghwá, ka sliʼaftá ndəghata dəmga ka sagha da guya Yesu. ");
INSERT INTO xed_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ka wahatá sana mndu mataba mnduha: «Maləma ɗa! Ta ndəɓa dzvu yu da kagha, nghanava na zwaŋa ɗa na ɓa! kɗakwakɗakwa zwaŋa ɗa na. ");
INSERT INTO xed_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ghwaɗaka sulkum ta ksafta. Na ksaftani, gi wahayni ta wahu, ka ghudzay nda mbraku, ka pgha mahupak ka giri ŋani, zlah kəʼa ta zliŋta. ");
INSERT INTO xed_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ka ndəɓu yu ta dzvu da duhwalha gha ma ŋa ghzligiŋtá mida ná, triɗ traptra həŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka Yesu mantsa: «Gwal təŋtəŋa ghəŋa taŋ kul haɗ zlghay nda ŋuɗuf da həŋ, kulam ŋa yawu dzaʼa nzavaghunata yu? Kulam ŋa yawu dzaʼa nzata yu ka suʼaghunata? Klak tsa zwaŋa gha ya da hadna,» ka Yesu nda tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta gavadaghatá tsa zwaŋ ya, ka slanatá tsa ghwaɗaka sulkum ya ta haɗik, ka ghudzay nda mbraku. Ka davanaghatá Yesu ta tsa ghwaɗaka sulkum ya, ka mbanaftá tsi ta tsa zwaŋ ya, ka vlaŋtá tsi ta tsa dani ya. ");
INSERT INTO xed_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ka ndərmim mnduha ta glakwa mbrakwa Lazglafta. Ta laghu mnduha da ndərmima inda tsa skwi maga Yesu ya, ka Yesu nda duhwalhani mantsa: ");
INSERT INTO xed_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Fawafa ta sləməŋ ɗina, ka sna na skwi dzaʼa yu mnaghunata na. Dzaʼa ksafksa lu ta Zwaŋa mndu, ka vlata ma dzva mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sna a tsa duhwalha ya ta tsa gwaɗa ya wa, tsala a tsa gwaɗa ya da həŋ wa. Nda ɗifa klatá ghəŋa tsa gwaɗa ya da həŋ, kabga ŋa kwala taŋ kul snaŋta. Ta zləŋay həŋ ta ɗawaŋtá tsa gwaɗa ya guli da tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ka sagha sana ndanu da ghəŋ taŋ, ka zlərɗə həŋ mataba taŋ. Ka həŋ mantsa: «Wa mali mataba mu na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ɗaslafta Yesu ta tsa ndana taŋ ya, ka hgaftá tsi ta zwaŋ kwitikw ka sladanata tavatani. ");
INSERT INTO xed_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kaʼa nda həŋ mantsa: «Dər wa ta tsuʼaftá na zwaŋ kwitikw na nda hga ɗa, vərɗa iʼi tsuʼaf tsi. Dər wa ta tsuʼaftá iʼi guli, tsuʼaftsuʼa ta tsa mndu ta ghunigihata ya. Tsa mndu ta niŋtá ghəŋani ka zwaŋ gudzekw ɗekɗek mataba ghuni ya ná, tsa mndu ya ta nzakway ka mali,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ka gi tsuʼaghutá Yuhwana ta gwaɗa, kaʼa mantsa: «Maləma ɗa! Nda ngha ŋni ta sana mndu ta ghzla duhwala halaway nda hga gha, ka lmaftá ŋni kabga haɗ tsatsi mataba mu wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","«Ŋaw! Ma pyə kuni! Ka haɗ gwaɗa mndu nda kaghuni wu, mista ghuni tsa mndu ya,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manda ndusakta fitik dzaʼa kəl Yesu ka zlaŋtá ghəŋa haɗik, ka klaftá tsi ta ghəŋani ŋa dzaʼa ɓhata ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka ghunaghatá tsi ta sana mnduha ŋa dzaʼa ta kəma ta kəma. Ka sliʼaftá tsaha ya ka ksaftá tvi, ka ɓhadaghatá həŋ da sana zwaŋa luwa la Samari ŋa payanaftá vli. ");
INSERT INTO xed_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka kwalaghutá mnduha ma tsa luwa ya ta tsuʼafta, kabga nzakwani ta dzaʼa da Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Snaŋta gwal his mataba tsa duhwalha ya, i Yakubu nda Yuhwana ta tsa gwaɗa ya, «Maləma ɗa! Va a ka ta ɗawaŋta ŋni da Lazglafta ŋa zligiŋtani ta vu ta luwa, ka zaɗanata tsi ta həŋ ra?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ka mbəɗavatá Yesu ka davanaghatá həŋ: «Sna a kuni ka mndəra wani ma sulkum ta klaghunaktá mndərga tsaya ma ndanu wu! Sagha a Zwaŋa mndu da zaɗanatá mndu wu, saghasa ŋa mbanaftá həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ka sliʼafta həŋ ka laghwi da sana zwaŋa luwa. ");
INSERT INTO xed_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta mbaɗa həŋ ta tvi, ka sana mndu mantsa: «Dər dzaʼa diga ka, ta dzaʼa yu mista gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka Yesu mantsa: «Mamu ghuruma gərhaŋha, mamu həga ɗyakha, Zwaŋa mndu ná, haɗ vli ŋa fadatani ta ghəŋani wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kaʼa nda sana mndu guli mantsa: «Mbaɗa mista ɗa!» kaʼa nda tsi. «Mghama ɗa! Zlihazla ka dzaʼa yu paɗamtá da ɗa karaku,» ka tsaya zlghanaftá wi. ");
INSERT INTO xed_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","«Zlaŋzla ta gwal nda rwa ka paɗa həŋ ta ghəŋa taŋ, sliʼafsliʼa kagha ka dzaʼa ka da mna gwaɗa ta ga mghama Lazglafta,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka sana mndu guli mantsa: «Ta dzaʼa yu mista gha mghama ɗa. Nziya nza tsi tama ná, ka la yu mnanatá la ga ini nda sliʼasliʼa ɗa kaʼa.» ");
INSERT INTO xed_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ka Yesu nda tsi mantsa: «Ka nda ghada sliʼafta mndu ka dzaʼa mista ɗa, ka ləglaghwani ngha vli nda ga muhul hul katsi, tsa mndu ya ná, haɗ hayhayani ɗekɗek ŋa magaftá slna ga mghama Lazglafta wa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tahula tsa ka zabəglaptá Mgham Yesu ta sanlaha ma duhwalha ndəfáŋ mbsak his mida, ka ghunaftá tsi ta həŋ his his his ta kəma ta kəma da inda vli ya má dzaʼa ɓhata tsatsi. ");
INSERT INTO xed_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kaʼa nda həŋ mantsa: «Dagala skwiha ŋa tskay ta vwah, tsaw slaghwa a mnduha ŋa magay wa. Ndəɓawa dzvu da mnda vwah ka sganaghata tsi ta mnduha nda ndəgha ŋa tskanata. ");
INSERT INTO xed_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lawala, ta ghuna kaghuni yu manda zwana tuwak da taba kramtakha. ");
INSERT INTO xed_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yaha kuni klaftá tsedi, dər zlibi, dər ɓaɓah. Yaha kuni laghwi da gaga zgu ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Dər da wa dzaʼa lagha kuni, “ka nza zɗakwa Lazglafta ta ghəŋa na həga na,” ka kuni dzaʼazlay karaku. ");
INSERT INTO xed_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka mamu mnda zɗaku ma tsa həga ya katsi, dzaʼa nzaku tsa zɗakwa ghuni ya nda tsi. Ka haɗ tsi wu dzaʼa vragaghuvra tsa zɗakwa ghuni ya da kaghuni. ");
INSERT INTO xed_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka tsuʼaftsuʼa lu ta kaghuni, ka nzata kuni ma tsa həga ya, ka za kuni, ka sa kuni ta inda skwi dzaʼa vlaghunata lu, kabga nda ra ka tsuʼay mndu ta maga slna ta nisəlani. Yaha kuni dzaʼa da ra həga. ");
INSERT INTO xed_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka lamla kuni da luwa ka tsuʼaftá lu ta kaghuni, tsuʼawatsuʼa ka za kuni ta skwi dzaʼa vlaghunata lu. ");
INSERT INTO xed_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ka mbambanafta kuni ta gwal kul ɗughwanaku dzaʼa slanaghata kuni ma tsa luwa ya. “Ndana ná, ndusavaghuna ndusa ga mghama Lazglafta,” ka kuni dzaʼazlay nda həŋ, ");
INSERT INTO xed_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dər da wati ma luwa dzaʼa lama kuni, ka kwalaghutá lu ta tsuʼaftá kaghuni, lawala ta tvi ta tvi ma tsa luwa ya, ka kuni dzaʼazlay nda həŋ na: ");
INSERT INTO xed_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Wana ŋni ta tukwaghunatá nduk nda rgitika na luwa ghuni ta ndiʼafta ta səla ŋni na, kada grafta kuni si ndusavaghuna ndusa ga mghama Lazglafta kəʼa.” ");
INSERT INTO xed_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka yu ta mnaghunata na: Baɗu tsa fitik dzaʼa tsə Lazglafta ta guma ta ghəŋa mnduha ya ná, ta ləŋləŋa ŋa luwa Suduma ka ŋa tsa luwa ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Ɗaŋwa ŋa gha luwa Kuraziŋ! Ɗaŋwa ŋa gha luwa Betsayda! Ka má magamaga lu ta mndərga tsa mazəmzəm maga lu mataba kaghuni ya ma luwa Tir nda luwa Siduŋ katsi ná, má nda kɗa fitika mbəɗanaftá taŋ ta nzakwa taŋ, ka zlanavatá maga ghwaɗaka skwiha, ka pghavatá buhu ta vgha nda hutiɗif ma ghəŋ ");
INSERT INTO xed_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tsaya dzaʼa kəl tsi ka nzakway baɗu tsa fitika guma Lazglafta ya, dzaʼa malaghumala kafatá guma ta ghəŋa luwa Tir nda luwa Siduŋ ka ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","«Kagha luwa Kafarnahum, dzaʼa kapiɗif kapa lu ta luwa ka kagha ra? Siga! Dzaʼa vradaghavra lu ha da vla gwal nda rwa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ka Yesu guli nda duhwalhani mantsa: «Mndu ta snatá gwaɗa ghuni, gwaɗa ɗa sna tsi. Ka kwalaghukwala mndu ta tsuʼaftá kaghuni, iʼi kwalaghu tsi ta tsuʼafta. Ka kwalaghukwala mndu ta tsuʼaftá iʼi, kwalaghukwala ta tsuʼaftá mndu ta ghunigihata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Manda laghwa tsa gwal ndəfáŋ mbsak his mida ya, ka varaktá həŋ nda rfu katakata. «Mgham ɗa! Nduk nda duhwalha halaway tani ná, snasna həŋ ta gwaɗa davanaghar ŋni ta həŋ nda hga gha,» ka həŋ nda Yesu. ");
INSERT INTO xed_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka Yesu nda həŋ mantsa: «Nda ngha yu ta halaway ta dəɗagata ta luwa manda wuɗakwa luwa. ");
INSERT INTO xed_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Snawa ɓa! Vlaghunavla yu ta mbrakwa diŋlanaptá nahaɗikha nda rdaha, nda ya ta ghəŋa inda mbrakwa ghuma, haɗ sana skwi dzaʼa balaghunata wa. ");
INSERT INTO xed_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kulam nda tsa, ma rfu kuni ta rfu kabga snaghunata ghwaɗaka sulkumha ta gwaɗa, rfawa ta rfu ta ghəŋa vindatá hga ghuni ta luwa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma va tsa fitik ya ka zɗanaftá Sulkum nda ghuɓa ta ŋuɗuf ta Yesu, kaʼa mantsa: «Əŋkaʼa Da, Mgham ta luwa nda ya ta haɗik, ta ghəŋa ɗifanata gha ta tsa skwiha ya da gwal nda ɗifil ma ghəŋa taŋ, nda ya da gwal nda mahizl ma ghəŋa taŋ, ka maranaŋtá ka ta gwal kul snaŋtá skwi. Kahwathwata mantsa nzakwani Da, ta rfa kagha yu ta ghəŋa ɗvafta gha mantsa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Inda skwiha vlihavla Da ɗa, haɗ mndu nda sna ta tsa Zwaŋ ya wa, Da yeya nda sna. Haɗ mndu nda sna ta tsa Da ya guli wa, Zwaŋ yeya nda sna nda mndu ya ta kumə zwaŋ ta maranaŋta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ka mbəɗavatá Yesu tvə duhwalhani, ka mnay ŋa taŋ nda ghəŋa taŋ kazlay: Rfu ŋa ghuni, kaghuni gwal ta nghaŋtá skwi ya nghaŋ kuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ka yu ta mnaghunata na: «Nda ndəgha la anabiha nda mghamha si ta kuma nghaŋtá skwi ya nghaŋ kaghuni, triɗ ngha a həŋ wa. Si ta kumay həŋ ta snaŋta, sew, sna a həŋ wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lagha sana mnda tagha zlahu ŋa mnduha ka sliʼafta kabga ŋa dzəghaŋtá Yesu, kaʼa mantsa: «Maləma ɗa, nu dzaʼa yu magata ŋa mutsafta ɗa ta hafu ŋa kɗekedzeŋ na?» kaʼa nda Yesu. ");
INSERT INTO xed_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka Yesu nda tsi mantsa: «Waka lu vindafta ma deftera zlahu na? Nu dzaŋaf ka mida na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","«Ka ɗvuta ka ta Mgham Lazglafta gha nda kɗavakta ŋuɗufa gha, nda kɗavakta hafa gha, nda kɗavakta mbrakwa gha, nda kɗavakta ndana gha guli, ka ɗvuta ka ta sləvda gha manda va ghəŋa gha kəʼa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","«Mantsa ya nzakwani, la magay mantsa dzaʼa mutsay ka ta hafu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaʼa nda Yesu mantsa: «Wa ya ta nzakway ka sləvda ɗa na?» Ka tsa mnda tagha zlahu ya kabga ta kumay ta nzakwa gwaɗa ta ŋani. ");
INSERT INTO xed_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ka Yesu mantsa: «Mbaɗa sana mndu ka sliʼafta ma Ursalima ka valu da Yeriku. Ta laha tsi, ka dəɗamtá tsi mataba la gənda, ka zluʼatá həŋ ta tsa mndu ya ka ɗgata ka pɗanamtá hafu hafu, ka laghwa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta lala sana mnda dra skwi ŋa Lazglafta ta va tsa tvi ya, ka dukwaftá tsi ta tsa mndu ya, ka tsaghutá tsi ta warawara ka laghwani. ");
INSERT INTO xed_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ka lagha sana mnda la Levi dukwafta tida guli, ka tsaghutá tsaya ta warawara guli ka laghwani. ");
INSERT INTO xed_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mataba tsa ka lagha sana mnda la Samari ta dzaʼa wawakwani dukwafta tida. Ghur kəʼa ná, ka ksaŋtá tsi ka hiɗahiɗa. ");
INSERT INTO xed_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ka gavadaghatá tsi, ka maganaftá tsi ta rɗi nda ghwani ta lkuhani, ka habanafta. Ka tsukwaftá tsi ka fafta ta kɗihani. Ka klaghata da həga tsuʼa matbay, ka zughulay hada. ");
INSERT INTO xed_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gamahtsimani, ka klaftá tsi ta tseda vagha mndu his ta maga slna ka vlaŋtá mndu nda tsa həga ya, kaʼa nda tsi mantsa: “Aʼa, ka nghapta ka ka na mndu na, ka kidaghi dzaʼa sgavaghata ta ghəŋani ya, ŋa mnihata gha vragaghar yu, ŋa plaghata ɗa,”» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Wati mataba tsa duhwalha hkən ya, ta nzakway ka sləvda tsa mndu ta dəɗamta mataba la gənda ya, ka kagha ta gray na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","«Tsa mndu ta tawatá hiɗahiɗa tida ya ya,» ka tsa mnda tagha zlahu ya. «La, ka maga kagha mantsa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tata mbaɗa i Yesu nda duhwalhani, ka ɓhadaghatá həŋ da sana luwa. Ka tsuʼaftá sana marakw ta hgə lu ka Marta ta Yesu ga taŋ. ");
INSERT INTO xed_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mamu mukumani ta hgə lu ka Mari guli, ka nzatá tsi tavata Yesu, ka sna skwiha ta gwaɗə tsi, ");
INSERT INTO xed_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ta ksaghutá slna rmba ta Marta. Ka sap tsi mnay ŋa Yesu, kaʼa mantsa: «Mghama ɗa! Tha a kagha ta na zliɗiŋta mukuma ɗa ta slna na katək ra? mnanamna ɓa ka katihata tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka Yesu nda tsi mantsa: «Marta! Marta! Ma ghuyə ka ta ghəŋa gha, ma laghu ka da ndandanaku ta ghəŋa ndəghata skwiha. ");
INSERT INTO xed_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Turtuk skwi ta raku. Ka zbaptá Mari ta vərɗani ya dzaʼa kwal lu klugudunusta ɗekɗek,» ka Mgham Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma sana fitik ka magə Yesu ta duʼa ma sana vli. Manda kɗakwani ta maga tsa duʼa ya, Ka ɗawaŋtá sani mataba duhwalhani da tsi, kaʼa mantsa: «Mghama ɗa! Taghaŋnaf tagha ka lu ta maga duʼa manda ya taghanaf Yuhwana ta duhwalhani ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka Yesu nda həŋ mantsa: «Ta magə kuni ta duʼa, wya ka kuni da mnay: “Da ŋni ya ta nzakway ta luwa, ka snavasna hga gha nda ghuɓa, ka saghasa ga mghama gha. ");
INSERT INTO xed_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vlaŋnavla ta skwa zay prək zay ŋni inda fitik, ");
INSERT INTO xed_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","plaŋnapla ta dmakwa ŋni, manda ya ta plinista aŋni ta dmakuha gwal ta magaŋnata guli. Ma zlaŋna ka tawa skwi dzaʼa dzəghaŋnata,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ka Yesu nda həŋ guli mantsa: «Ka waya ka skwi mamu sana mndu mataba ghuni mamu grani, ka sliʼaftá tsa mndu ya ma takala, ka laghwi slanaghatá tsa grani ya. “Zwaŋama ɗa, katihakata nda kanaya buradi hkən. ");
INSERT INTO xed_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mamu sani mataba graha ɗa si ta wawakwani ta dukwata ga ini, tsaw haɗ skwa zay ŋa vlaŋta ɗa wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka waya ka skwi ka gwaɗagaptá tsa grani ya ma həga, kaʼa mantsa: “Ma gərzlə ka ta iʼi gra, nda ghada hatá tgha ɗa, nda ghada ŋni ta ghzləŋ nda zwana ɗa, lavgliŋ a yu ta sliʼafta ŋa vlaghatá buradi wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka yu ta mnaghunata ná, dər má laviŋta a tsi ta sliʼiglafta ŋa vlaŋtá skwi ya ta ɗawu tsi, kabga dər má nzakwani ka grani wu, má dzaʼa sliʼafsliʼa ka vlaŋtá inda skwi ta kumə tsi kada kwala tsi ta gərzləgəlta. ");
INSERT INTO xed_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Ka iʼi ta mnaghunata ná, ɗawawaɗawa dzaʼa vlaghunavla lu. Zbawazba dzaʼa mutsay kuni, dzawadza ta tgha ta gunaghunaguna lu. ");
INSERT INTO xed_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ka dər wa ta ɗawaŋta ta mutsay, ka dər wa ta zbaŋta ta slafsla tida, ka dzaŋdza mndu ta tgha, ta gunanaguna lu. ");
INSERT INTO xed_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wati ya mataba ghuni dzaʼa klaftá pala ka vlaŋtá zwaŋani, ɗawaŋər tsi ta buradi na? Ari ka klipi a ɗawaŋ tsi, ŋa klaftani ta nahaɗik ka vlaŋta ka zlaŋtá klipi na? ");
INSERT INTO xed_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ari ka slislik a ɗawaŋ tsi ná, ŋa klaftani ta rda ka vlaŋta na? ");
INSERT INTO xed_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka si kaghuni ta nzakway ka ghwaɗaka mnduha ya, nda sna kuni ta vla skwi ɗina ŋa zwana ghuni ya ní, Da ya ta nzakway ta luwa yeya dzaʼa kwal kul vlaŋtá Sulkum ta mndu ta ɗawaŋta rki na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma sana fitik ka ghzligiŋtá Yesu ta duhwalha halaway ta tsa mndu ka rgha ma sana mndu. Manda saghwa tsa duhwalha halaway ya ma tsa mndu ya, ka zlraftá tsa mndu ya ta gwaɗa tsəleŋ, ka va ndərmim dəmga. ");
INSERT INTO xed_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka sanlaha mataba tsa dəmga ya mantsa: «Aʼ nda mbrakwa belzebul mgham ta ghəŋa duhwalha halaway ta ghazla tsi ta tsa duhwalha halaway ya!» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","«Magaŋnamaga ta mazəmzəm dzaʼa maraŋta kazlay: Sa daga da Lazglafta mbrakwa gha kəʼa,» ka sanlaha nda tsi ŋa dzghay. ");
INSERT INTO xed_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tsatsafta Yesu ta ndana taŋ, kaʼa mantsa: «Ka tavaptá ga mgham turtuk his katsi ní, nda zla tsa ga mgham ya ŋa zlazlakwa həga sani ta sani. ");
INSERT INTO xed_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka si dgavapdga halaway his katsi ní, wa ka tsa ga mghamani ya dzaʼa gɗavata tama, “ya nda mbrakwa belzebul ta ghazla tsi ta duhwalha halaway” ka kaghuni nda iʼi? ");
INSERT INTO xed_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka si iʼi, nda mbrakwa halaway ta ghazla yu ta duhwalha halaway katsi ní, nda mbrakwa wa ta ghazla zwana ghuni guli? Hahəŋ dzaʼa tsaghunatá gumani. ");
INSERT INTO xed_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iʼi, nda mbrakwa Lazglafta ta ghazla yu ta duhwalha halaway, tsaya ta maraŋtá ghadata sagha ga Mgham Lazglafta da taba ghuni. ");
INSERT INTO xed_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Ka hbafhba mndu nda mbra ta vghani ka ngha həgani ka tsi ná, haɗ skwi dzaʼa ksaŋtá skwihani wa. ");
INSERT INTO xed_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ala, tsa lagha sana mndu ta malaghutá mbrakwani ka lagha habafta tsehwtsehwehw ka hləgadanaghutá huzla lmani ya faf tsi ta ghəŋani tida ya katsi, ta haɗ mbrakwani wa. Ŋa hlafta tsa mndu ya ta tsa huzla zluʼa tsi ya ka dgiŋta. ");
INSERT INTO xed_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Mndu ya kul haɗ mista ɗa ná, nda iʼi gwaɗani. Mndu kul haɗ ta katihata ka tskanata ná, kwiziŋtá ŋani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Ka sabsa ghwaɗaka sulkum ma mndu katsi, ŋa dzaʼani da ra vli tuhwayaŋ tuhwayaŋa, ŋa zba vli ŋa mbiʼa vghani, ka triɗ mutsaf a tsi ta tsa vli ŋa mbiʼa vghani ya wu katsi, kaʼa dzaʼazlay na: “Ka vra yu da tsa həga ɗa ma vəl sabi yu ya gra,” kaʼa, ŋa sliʼaftani ka vradaghata. ");
INSERT INTO xed_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka ta vradaghatá tsi da tsa həga ya, nda tsukwa vli mida nda paya ɗina katsi, ");
INSERT INTO xed_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yawa da kəʼa dzaʼazlay ŋa vraghutani, ŋa hlanaktani ta sanlaha ma ghwaɗaka sulkumha ndəfáŋ ta malaghutá tsatsi nda sidi, ŋa lama taŋ da tsa həga ya ka nzamta mida. Tsaya dzaʼa kəl nzakwa tsa mndu ya ka ɓwadzuta ka malaghutá nzakwani taŋtaŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tata gwaɗa tsa gwaɗa ya Yesu, «rfu da tsa marakw ta klaftá kagha ma huɗi ka sughustá uʼa ya!» ka sana marakw klaŋtá lwi mataba tskata mnduha. ");
INSERT INTO xed_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","«Katək ná, rfu da mndu ta fata sləməŋ ka sna gwaɗa Lazglafta, ka ksa slna nda tsi,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ta tskakutskaku mnduha tavata Yesu, kaʼa mantsa: «Ghwaɗak mnduha ma na fitik na, má magaŋnamaga lu ta mazəmzəm ta saha daga da Lazglafta, ka həŋ ta ɗaway. Haɗ sana mazəmzəm dzaʼa maganata lu ta həŋ, ka mndərga ŋa anabi Yunusa a tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Manda va ya nza anabi Yunusa ka ŋizla ŋa gwal ma luwa Niniva ya, manda va tsaya dzaʼa nzakwa Zwaŋa mndu, ŋa gwal ma na fitik na. ");
INSERT INTO xed_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ghalya, ka sliʼaftá sana marakw ta ga mgham ma vli diʼiŋ ta haɗika Seba ka lagha da sna ɗifil da Salumuŋ. Wana mamu mndu ta malaghutá Salumuŋ hadna, baɗu tsay Lazglafta ta guma ta ghəŋa mnduha, ŋa ghuni dmaku ka tsa marakw ya dzaʼa sliʼafta mnanatá mnduha ma na fitik na. ");
INSERT INTO xed_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ghalya guli, gwal ma luwa Niniva ná, snasna həŋ ta gwaɗa anabi Yunas, ka mbəɗanaftá həŋ ta nzakwa taŋ. Wana mamu mndu ta malaghutá anabi Yunusa hadna. Baɗu tsay Lazglafta ta guma ta ghəŋa mnduha, ŋa ghuni dmaku ka gwal ma luwa Ninive dzaʼa sliʼafta mnay ŋa mnduha ma na fitik na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Haɗ mndu ta tsamtá vu ma pitirla ŋa fata ma lwa vli ka ka dzuɓamta ma tughba a tsi wu ta vli tskala ta fagata tsi ŋa nghaŋta mnduha ta lami da həga ta tsuwaɗak. ");
INSERT INTO xed_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ira gha ná, pitirla vgha gha ya. Ka ta ɗinaɗina ira gha, ma tsuwaɗak vgha gha. Ka nda ɓadza ira gha, ma grum vgha gha. ");
INSERT INTO xed_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ɗasuwa ká ka, yaha tsa tsuwaɗak ma kagha ya da nuta ka grum. ");
INSERT INTO xed_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ka si má tsuwaɗak inda vgha gha, haɗ pɗakwa sana vli ma gruma wu katsi, inda vgha gha dzaʼa nzata ma tsuwaɗak manda tsuwaɗaka pitirla ta tsuwaɗaka vli ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Manda kɗakwa Yesu ta gwaɗa, ka hgaghatá sana la Farisa ŋa dzaʼa za skwi ga taŋ. Ka lamə tsi da hga, ka nzatá tsi ka za skwi. ");
INSERT INTO xed_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka nzatá tsa la Farisa ya ka ndərmima kwala Yesu kul mbaziŋtá dzvu kada za skwi. ");
INSERT INTO xed_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Mgham Yesu nda tsi mantsa: «Kaghuni la Farisa, hula leghwa nda hula hliba yeya ŋa ghuni ta mbaziŋta, ama ma ŋuɗufa ghuni ta kumay kuni ta ghalatá sanlaha, ta sidi kuni guli. ");
INSERT INTO xed_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Rghaha! Tsa mndu ta magaftá hulani ya a ta magaftá huɗani guli ra? ");
INSERT INTO xed_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Klawa skwi ma leghwa ghuni nda ya ma hliba ghuni, ka vla kuni ŋa gwal ka pɗu, tsaya dzaʼa kəl inda skwi ka nzaku tsuweɗaka da kaghuni. ");
INSERT INTO xed_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ɗaŋwa ŋa ghuni la Farisa! Ta laghula kuni vla skwi turtuk ma ghwaŋ ta nzakway mataba niɗali ta mutsafta kuni ma vwah, nda masuʼataha ta hvata kuni nda hva ka vlay ŋa Lazglafta, ka zlaŋtá nzaku tɗukwa, nda ɗvutá Lazglafta. Tsaya skwi má ŋa magay nda kwal kul zanaptá sana skwiha. ");
INSERT INTO xed_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ɗaŋwa ŋa ghuni la Farisa! Ta laghula kuni ɗvaftá taŋtaŋa vla nzaku ma həga tagha skwa la Yahuda, ta kumay kuni ta gagay mnduha ta zgu ŋa ghuni ta dawadawa. ");
INSERT INTO xed_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ɗaŋwa ŋa ghuni! Manda kulu ta zwaɗuta ta mbaɗə mnduha ta mbaɗa tida kul snaŋta ya kuni.» ");
INSERT INTO xed_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","«Mghama ɗa, aŋni ta razə ka ndana gwaɗa gha na,» ka sana mnda ta tagha zlahu ŋa mnduha nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","«Ɗaŋwa ŋa ghuni guli, gwal tagha zlahu! Kərtawa ndəgaku ka kaghuni nda mnduha, va a kaghuni ta hiŋtá dər ndəfiŋa dzva ghuni ŋa kataŋtá həŋ ka klay wa. ");
INSERT INTO xed_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Ɗaŋwa ŋa ghuni! Kula anabiha psla dzidzíha ghuni ghalya ŋa ghuni ta babay. ");
INSERT INTO xed_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ma tsa babay ghuni mantsa ya ná, ta maray kuni kazlay: Zɗəgaghunazɗa tsa skwi maga dzidzíha ghuni ya kəʼa. Pslapsla hahəŋ ta la anabiha, baba kuluha taŋ ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tsaya kəl Lazglafta ma ɗifilani ka mnay kazlay: Dzaʼa ghunədaghuna ghuna yu ta la anabi nda gwal ghunay ta həŋ, dzaʼa pslapsla həŋ ta sanlaha, dzaʼa ganapga həŋ tiri ta sanlaha kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ta ghəŋa tsaya dzaʼa kəl lu ka ghuzlanaŋtá iri ta gwal ta na fitik na kabga pslata taŋ ta inda la anabiha daga zlrafta ghəŋa haɗik, ");
INSERT INTO xed_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","na zlrafta ta Abel, ka sagha ta Zakari dza lu ma takataka gwir nda vli nda ghuɓa ma həga Lazglafta ya. Mantsa tsaya, dzaʼa ghuzlanaŋghuzla lu ta iri ta gwal ma na fitik na ta ghəŋa vəl pslata taŋ ta tsa mnduha ya. ");
INSERT INTO xed_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Ɗaŋwa ŋa ghuni gwal tagha zlahu! Nuʼaf nuʼa kuni ta watgha snaŋtá skwi, lamə a vərɗa kaghuni wu, pyafpya kuni ta sanlaha ta kuma lami guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Manda zlaŋta Yesu ta tsa vli ya, ka zlraftá gwal tagha zlahu nda la Farisa ta zlurgwa gwaɗa kavghakavgha da tsi. ");
INSERT INTO xed_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ka ɗakwats həŋ ŋa ksafta nda gwaɗa dzaʼa sabi fətes ma wani, ŋa fanamtá tɓaŋ ma lwi. ");
INSERT INTO xed_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mataba tsaya, ka tskadaghatá mnduha ta vgha ŋəɗdəm tavata Yesu ka ɓisla vgha sani tavata sani. Ka Yesu nda duhwalhani mantsa: «Ɗasuwa ka kuni nda Isa la Farisa ta nzakway ka maɗgwirmaɗgwir ta magə həŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Haɗ skwi nda ɗifa dzaʼa kwal kul sabi ta daɓi wa. Haɗ skwi kɗekkɗek dzaʼa kwal kul snavata guli wa. ");
INSERT INTO xed_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tsaya dzaʼa kəl inda skwi dzaʼa kuni mnay ma grum ka snaku ta daɓi. Skwi dzaʼa kuni mnay ma sləməŋ ma sləməŋ ma dzuguvi dzaʼa tuta wdiɗ ta daɓi.» ");
INSERT INTO xed_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Wya ka yu ta mnaghunatá kaghuni ta nzakway ka graha ɗa: Ma zləŋ kuni ta gwal dzaʼa dzatá sluʼuvgha ghuni kweŋkweŋ, kul laviŋtá həŋ ta magəglatá sana skwi tahula tsa. ");
INSERT INTO xed_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka maraghunamara yu ta mndu dzaʼa kuni zləŋay. Zləŋawa zləŋa ta Lazglafta. Tsatsi ta laviŋtá dzatá sluʼuvgha ghuni, mamu guli nda mbrakwa klafta kaghuni ka vzamta da vu. Mantsa ya nzakwani, tsatsi dzaʼa kuni zləŋay, ka yu ta mnaghunata. ");
INSERT INTO xed_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Haɗ lu ta skwaptá tiytiha hutaf ta aneni his ra? Kulam nda tsa, Zanap a Lazglafta ta ya dər turtuk ma həŋ wa. ");
INSERT INTO xed_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mbəɗaf mbəɗa lu nduk nda swidi ma ghəŋa ghuni tani, ma zləŋ kuni ta zləŋ ɗekɗek. Malaghumala kuni piw ta tiyti,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ka yu ta mnaghunata na, mndu dzaʼa maraŋtá ghəŋani ta daɓi ka mnay: “Ŋa Yesu iʼi” kaʼa ná, ka Zwaŋa mndu dzaʼazlay ta kəma duhwalha Lazglafta na: “Ŋa ɗa na mndu na,” kaʼa dzaʼazlay. ");
INSERT INTO xed_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama Mndu dzaʼa mnay ta kəma mnduha: “ŋa Yesu a iʼi wu” kaʼa, ka Zwaŋa mndu dzaʼazlay ta kəma duhwalha Lazglafta na: “Ŋa ɗa a na mndu na wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mndu dzaʼa vaza ŋazlu ta ghəŋa Zwaŋa mndu, dzaʼa plinispla lu ta dmakwani. Ka Sulkum nda ghuɓa dzaʼa razanafta mndu katsi, haɗ lu dzaʼa plinistá dmakwani ɗekɗek wa. ");
INSERT INTO xed_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Ka kladaghunaghakla lu da həga tagha skwa la Yahuda, ka tsaghunaghatá guma, ka dər da gwal tsa guma nda gwal ŋumna a tsi, yaha kuni da ndana skwi dzaʼa kuni magay ŋa kata ghəŋa ghuni, nda ya dzaʼa kuni mnay guli. ");
INSERT INTO xed_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sulkum nda ghuɓa dzaʼa mnaghunata ma tsa fitik ya ta skwi ŋa mnay ghuni.» ");
INSERT INTO xed_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ka sana mndu mataba dəmga nda Yesu mantsa: «Maləma ɗa, mnanamna ta zwaŋama ɗa kada dganapta ŋni ta skwa za hga ŋni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","«Ari gra! Wa ta famtá iʼi ŋa tsaghunatá guma, ari wa ta famtá iʼi ŋa dgaghunaptá skwa za hga na?» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","«Ɗasuwa ka kuni nda tsagana. Vəl nzakwa skwa mndu mamu ka nutá tsi ka gadghəl a kəl tsi ka nzata nda hafu wu, ka Yesu kay guli nda inda mnduha.» ");
INSERT INTO xed_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaʼa nda həŋ nda mahdihdi mantsa: «Lagha sana mndu ka gadghəl ka hvatá hva dagala. ");
INSERT INTO xed_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“Waka yu dzaʼa maga na skwi ná, wana haɗ vli ŋa pgha na nimaya ɗa na wu?” kaʼa ma ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Yawa! Wya skwi dzaʼa yu magay: Dzaʼa dzaɓiŋtá guvurha ɗa yu, ka tahanaghata ŋa tskamta ɗa ta inda nimaya ɗa, nda hamata skwiha ɗa mida. ");
INSERT INTO xed_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wana mamu skwi dər ŋa vaku kidaghi tsi. Mbiʼa ta vgha gha, za, sa, rfa ta rfu tama, ka yu dzaʼazlay nda vgha ɗa,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Rghargha vgha na, kuɗaŋ hafa gha ta na rviɗik gita u na, ŋa wa inda na skwiha papayaf ka na tama?”» ka Lazglafta nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ka Yesu sganaghata mantsa: «Tsaya skwi ta magaku nda mndu ta tskanatá skwi ta ghəŋani, ka zlaŋtá tskanatá skwi ta ghəŋani da Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tahula tsa, ka Yesu nda duhwalhani guli: «Tsaya ta kəl yu ka mnay ŋa ghuni kazlay: Ma mnə kuni ta “Heʼ, a nu dzaʼa yu zay ní, a nu da fə yu ta vgha ní,” kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mal hafu ka skwa zay, mal vgha ka lgut. ");
INSERT INTO xed_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nghawa zarakataghuvi ɓa, haɗ ta sləgu dər tska skwi ta vwah wu, haɗ wbani wu, haɗ guvurani guli wu, Lazglafta ta zuŋtá skwi. Malaghumala a kaghuni piw ta ɗyakha ra? ");
INSERT INTO xed_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Waya mataba ghuni dzaʼa laviŋtá sganaghata dər kwitikw ta fitik ta ghəŋa hafani kabga vəl mnayni ta heʼ na? ");
INSERT INTO xed_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","«Ka si laviŋ a kuni ta magatá skwi dər ka kiʼa wu, nu ta kəl kuni ka mna heʼ nda pɗakwani tama. ");
INSERT INTO xed_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nghawa vzlizla ma vwah ɓa, haɗ həŋ ta maga slna wu, haɗ həŋ ta ga lgut wa. Ka yu ta mnaghunata ná, dər Salumuŋ, kulam nda tsa nzakwani ka gadghəl ya tani, ta fava a ta lgut manda ŋa sani ma tsa vzlizlaha ya wa. ");
INSERT INTO xed_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka gita u na ka Lazglafta pghanavatá rka ta kuzuŋ ma vwah ná, gi gamahtsimani ŋa driŋta nda vu. Kaghuni yeya dzaʼa kwal tsi suɗavaghunatá lgut tama rki? Nahgani ta htiŋtá zlghay nda ŋuɗufa ghuni? Nu kul laviŋtá kuni ta faftá ghəŋ? ");
INSERT INTO xed_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ma laghu kuni da ndana skwi dzaʼa kuni zay nda skwi dzaʼa kuni say. ");
INSERT INTO xed_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gwal kul snaŋtá Lazglafta ma ghəŋa haɗik ta laghu da zba tsahaya. Kaghuni ná, nda sna da ghuni kazlay: Ta ɗvay kuni ta tsa skwiha ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dzawadza ta vgha ka zba ga mgham Lazglafta karaku, dzaʼa vlaghunavla Lazglafta ta pɗakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ma zləŋ kuni ta zləŋ kaghuni gwal ta nzakway ka ŋa ɗa manda zwaŋa bra. Zɗəganazɗa ta Da ghuni Lazglafta na vlaghunatani ta ga mghamani. ");
INSERT INTO xed_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dzawiŋwa dzawa ta skwiha ghuni, ka dgiŋta kuni ŋa gwal ka pɗu ta tsedani. Tskawa tseda ghuni ma vəl dzaʼa kwal kul ɓadzavata ta nzakway ta luwa. Hada, ksaŋta a ghali wu, ksaŋta a hzay guli wa. ");
INSERT INTO xed_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ka ga vla tskatá gadghəla gha ya ná, hada ŋuɗufa gha guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Hbawahba ta vgha ŋa maga slna, tsamwa vu ma pitirla ghuni, ");
INSERT INTO xed_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nzawanza manda duhwalha ta kzla dzaŋta daŋahəga taŋ ta watgha vrakər tsi ma vla kla makwa ŋa gunanata taŋ. ");
INSERT INTO xed_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Rfu da tsa kwalvaha dzaʼa sagha daŋahəga taŋ slanaghatá həŋ ndiri ya! Kahwathwata ka yu ta mnaghunata, dzaʼa habafhaba ta vgha, ŋa nzanatani ta həŋ ma vla za skwi, ŋa saghani vlaŋtá skwa zay ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rfu da tsa kwalvaha ya ka slanaghasla tsi ta həŋ ndiri ma takala dər nda dga a vli ya! ");
INSERT INTO xed_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Fawafa ta sləməŋ ɗina. Ka má nda sna zəʼala hga ta fitik dzaʼa lagha ghali da taŋ katsi, má dzaʼa nzanza ndiri má zlaŋta a ka zlratani ta hgani wa. ");
INSERT INTO xed_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaghuni guli, habafwa vgha, kabga ma fitik kul ndanaŋtá kuni dzaʼa sagha Zwaŋa mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ka Piyer ɗawaŋta mantsa: «Mghama ɗa! ŋa aŋni nda ghəŋa ŋni re, ari ŋa inda mndu demdem a ta mna ka ta na mahdihdi na na,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","«Wa na mndu tɗukwa nda mahizl ma ghəŋani na na? Tsaya a mndu dzaʼa daŋahəgani mnay ŋani: “Ta vlaghavla yu ta slna, ka vla ka ta skwa zay ŋa gwal ta magihatá slna nda fitikani,” kaʼa ya ra. ");
INSERT INTO xed_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Rfu da tsa mndu dzaʼa sagha daŋahəga slanaghata ta magay mantsa ya! ");
INSERT INTO xed_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kahwathwata ka yu ta mnaghunata: Dzaʼa fanaghafa ta tsa mndu ya ta ghəŋa inda tsa skwihani ya. ");
INSERT INTO xed_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ala ka ka tsa kwalva ya ma ghəŋani mantsa: “Wana nda gərɗa mghama ɗa katək na,” kaʼa ka liŋtá psla sanlaha ma kwalva nda kwalva miʼaha, ka laghwi da zazaku nda sasaku ka ghuyaku katsi, ");
INSERT INTO xed_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dzaʼa saghasa mghama tsa kwalva ya dluk ma vaghu kul graftá tsatsi ta fitik ya kul snaŋtá tsi, ŋa ghuyaghunaptani ta ɗaŋwa katakata, ŋa tsanaghatani ta guma kawadaga nda gwal ta maga ghwaɗaka skwiha. ");
INSERT INTO xed_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Tsa kwalva nda sna ta skwi ta kumə mghamani ka kwalaghutá tsi ta payavata ka magay ya, dzaʼa ɗgapɗga lu kwərɗək. ");
INSERT INTO xed_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kwalva ya kul snaŋtá skwi ta kumə mghamani, ka magatá tsi ta skwiha prək ka ɗgapta, kiʼa yeya dzaʼa ɗguŋta lu. Ka dagala vlaŋta lu ta mndu katsi, dagala dzaʼa ɗawa lu da tsi guli. Ka si fərta tani vlaŋ lu ta mndu katsi, fərta tani dzaʼa ɗawu lu da tsi guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Sagha da vzatá vu yu ta haɗik, ta kumay yu ta gi kbaftani misimmisim. ");
INSERT INTO xed_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dzaʼa lamla yu da ghuya ɗaŋwa manda ya ta lamə mndu da imi ma maga batem. Ya ta kzlə nda imi ma kuluŋ yu ta magatani. ");
INSERT INTO xed_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Zɗaku klagagha yu ta ghəŋa haɗik ka kaghuni ta gray ra? Si ga! Daga vgha klagagha yu. ");
INSERT INTO xed_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Daga ndanana, dzrafta a mnduha hutaf ma hga ta wi wa. Dzrafta a gwal hkən ta wi nda gwal his wa. Dzrafta a gwal his ta wi nda gwal hkən guli wa. ");
INSERT INTO xed_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dzaʼa nda dma i da nda zwaŋ, dzaʼa nda dma i zwaŋ nda dani. Dzaʼa nda dma i ma nda makwani, dzaʼa nda dma i makwa nda mani. Dzaʼa nda dma i midzi nda ghwaʼalani, dzaʼa nda dma i ghwaʼali nda midzani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ka Yesu guli nda ndəghata dəmga na: «Nghay ghuni ta ŋatá ghwayak nda ga mazu ná, “dzaʼa saghasa imi” ka kuni ta mnay, gi ŋa magatani mantsa. ");
INSERT INTO xed_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nghay ghuni ta vyakwa falaka Sud ná, “dzaʼa mamu vis gita,” ka kuni ta mnay, gi ŋa magatani mantsa. ");
INSERT INTO xed_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tsa maɗgwirmaɗgwir maɗəgwira ghuni ya! Nda sna kuni ta dganatá skwiha ta magaku ta haɗik nda ya ta luwa, waka kuni traptá snaŋtá dganatá skwiha ta magaku ma na fitik na tama?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Waka kaghuni ka ghəŋa ghuni traptá tsatsaftá maga skwi ɗina? ");
INSERT INTO xed_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ka wlawla mndu ta kagha, ka sliʼafta kuni ka dzaʼa da guma katsi, ŋavaŋa ka dzray nda tsi ma kɗaku kuni ka ɓhadaghata da tsa vla guma ya, da lamə ka da dzva mnda tsa guma, da klaftá tsi ta kagha ka vlata ma dzva la sludziha, da klaftá tsahaya ta kagha guli ka vzamta ma gamak. ");
INSERT INTO xed_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka yu ta mnaghunata ná, “haɗ ka dzaʼa walaŋtá sabi hada ka ta kɗiŋ a ka ta platá kɗavakta anena tsa mndu ta vlaghata ya wu,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma va tsa fitik ya, ka sliʼadaghatá sanlaha ma mnduha mnay ŋa Yesu ta skwi ta slanaghatá gwal ma Galili psla Pilat ma fitika dray taŋ ta skwi ŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ka Yesu nda həŋ mantsa: «Mal ŋa tsa la Galili psla lu ya glakwa dmaku ka ŋa pɗakwa sanlaha ma gwal ma Galili, kəl həŋ ka ghuytá tsa ɗaŋwa ya, ka kaghuni ta gray ra? ");
INSERT INTO xed_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Malaghumala a ŋa taŋ wa. Ka mbəɗanaf a kaghuni ta nzakwa ghuni wu katsi, dzaʼa rwurwa kuni demdem manda hahəŋ. ");
INSERT INTO xed_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ari tsa mnduha ghwaŋpɗə tghas ta rwuta ma fitika zləmbanaghata sana həga dagala ma Silwe ta həŋ ya ná, mal ŋa taŋ glakwa dmaku ka pɗakwa sanlaha ma mnduha ma Ursalima a ka kaghuni ta gray na? ");
INSERT INTO xed_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Malaghumala a ŋa taŋ wa. Ka mbəɗanaf a kaghuni ta nzakwa ghuni wu katsi, dzaʼa rwurwa kaghuni manda hahəŋ guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wya kaʼa nda həŋ nda mahdihdi guli: «Mamu sana mndu ɗyaf fwa ghuraf ma vwaha inabani. Ka sliʼaftá tsa mndu ya ka lagha da ɗaga yakwani. Ta lagha tsi ná, lay yaf a ɗekɗek wa. ");
INSERT INTO xed_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kaʼa nda tsa mndu ta ngha tsa vwaha inabi ya mantsa: “ngha ɓa ta na ghuraf na, mahkəna vakwa ɗa na ta sagha da ɗaga yakwani, lay haɗ ta yafta wa. Ŋaw ŋa zləŋutani ta vli ka bətbət na, tsiŋtsa!” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mghama ɗa! Ka va va tsi karaku, ka lapta yu ta vli mistani, ka pghiŋta yu ta rgwa distani. ");
INSERT INTO xed_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ka waya ka skwi dzaʼa yafya kɗaghalam. Ka yəglafa a tsi wu katsi ŋa tsiŋta gha,”» ka tsa mndu ta nghay ya. ");
INSERT INTO xed_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Baɗu sana sabat, ka taghə Yesu ta skwi ŋa mnduha ma həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hada, mamu sana marakw kul ɗughwanaku ta maga vaku ghwaŋpɗə tghas ŋiŋ sulkuma halaway kutsuvuɗ, laviŋ a ta sladata ndəɗap wa. ");
INSERT INTO xed_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nghaŋta Yesu ta tsa marakw ya, ka hgaŋtá tsi. «Nda mba ka ma ɗaŋwa gha makwa ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ka faftá tsi ta dzvu tida, gi hadahada ka sladatá tsi ndəɗap, ka zləzlvu tsi ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ka kuzlanaftá tsi ta ŋuɗuf ta mgham ta ghəŋa tsa həga tagha skwa la Yahuda ya, kabga tsa mbanafta Yesu ta mndu baɗu sabat ya. «Mamu fitik mkuʼ ŋa maga slna sagha ghuni da mbamba vgha ghuni ma tsa fitikha ya, baɗu sabat a wu,» kaʼa nda tsa tskatá vgha mnduha ya. ");
INSERT INTO xed_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","«Tsa maɗgwirmaɗgwira ghuni ya! Haɗ inda kaghuni ta pla slani ka kɗihani a tsi ta wa guduk ka klay da vla sa imi baɗu sabat wu ra? ");
INSERT INTO xed_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wana na marakw na ta sabə ma mndəra la Abraham Maghwaŋapɗə tghasa vakwani na manda hbuta halaway, ra a ka pliŋtá tsəna marakw na ma tsa ziɗa ya baɗu sabat wu ra?» ");
INSERT INTO xed_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ka ksutá tsa zlghawa Yesu ya ta ghumahani ka hula. Ka rfu hamata sanlaha ma mnduha ta rfu ta ghəŋa inda ŋərma slna ta magə Yesu. ");
INSERT INTO xed_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ka Yesu guli mantsa: «Ndaw dzaʼa gra lu ta ga mghama Lazglafta na? Ndaw dzaʼa gra yu? ");
INSERT INTO xed_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka guram nda hya kramasa klaf sana mndu ka sləgamta ma gam, ka ɗyaftá tsi ka glafta gədiz, ka babaftá ɗyakha ta hga taŋ ta zligamahani nzakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ka Yesu guli mantsa: «Ndaw dzaʼa gra yu ta ga mghama Lazglafta na? ");
INSERT INTO xed_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ka guram nda is klaf sana marakw ka laɓanamta ma gratá darama hupu hkən ŋa ŋlanafta inda tsa hupu ya nzakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ka tadaptá Yesu ta zwana luwa nda luwaha dagala dagala, ta sliʼi tsi da luwa Ursalima, ka dzaʼa nda tagha skwi ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka lagha sana mndu ɗawaŋta da tsi: «Mgham ɗa! Kiʼa yeya mnduha dzaʼa mbafta rki na?» kaʼa. Ka Yesu nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Ŋavawaŋa ka lami nda ta watgha slrehwa. Ka yu ta mnaghunata na: Nda ndəgha gwal dzaʼa zba lami nda tida, triɗ ŋa trapta taŋ. ");
INSERT INTO xed_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Ka sliʼafsliʼa daŋahəga ka ŋərzlaftá watgha ta ma bli kaghuni katsi, ŋa kuɗuslafta kaghuni ta dza watgha kazlay: Mghama ɗa! Mghama ɗa! Gunaŋnaguna ta watgha kəʼa. “Sna a yu ka sagha ndiga kuni wu!” kaʼa dzaʼazlay nda kaghuni. ");
INSERT INTO xed_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Taw kay Mghama ɗa! Ta va aŋni si ta za skwi, ka sa skwi, ka tataghə ka ta skwi ŋa mnduha ta inda pazlala ma luwa ŋni kay ra!” ka kuni dzaʼazlay nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Sna a yu ka sagha ndiga kuni wu, laghwala demdem tavata iʼi, kaghuni gwal ta maga ghwaɗaka skwi,” kaʼa dzaʼazlay nda kaghuni kay guli. ");
INSERT INTO xed_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hada, dzaʼa waha kuni ta wahu nda hpaɗa sliʼiŋ nghaŋər kuni ta i Abraham nda Izak, nda Yakubu, nda inda anabiha ta nzaku ma ga mghama Lazglafta, wɗiŋwɗa lu ta kaghuni ma bli. ");
INSERT INTO xed_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dzaʼa sliʼaksliʼa mnduha nda ta slərpa luwa fwaɗ, ŋa nzata taŋ ka za skwi ma ga Mgham Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nda tsaya tama, gwal nda hul ndanana guli, dzaʼa nzakway həŋ ta kəma. Gwal ta kəma ndanana, dzaʼa nzakway həŋ nda hul,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma va tsa fitik ya, ka lagha sanlaha ma la Farisa slanaghatá Yesu, ka həŋ mantsa: «Ta psa kagha Hiridus ŋa dzata, sliʼafsliʼa hadna ka laghwa ka da sana vli,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","«Lawa mnanatá tsa gərhaŋ ya kazlay: Ta ghazla duhwala halaway yu, ta mbamba gwal ma ɗaŋwa yu gita nda ya mahtsim, ta mahkəna fitik ŋa kɗiŋta ɗa ta slna ɗa, kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ka kɗa yu ta mbaɗa ɗa gita, nda ya mahtsim, nda ya baɗima. Ra a ka mtuta anabi ma sana vli, ka zlaŋtá mtuta ma Ursalima wa. ");
INSERT INTO xed_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Luwa Ursalima! Luwa Ursalima! Kagha ta rwanatá anabiha. Ghunəgagha gha Lazglafta ta mnduha ná, rwana ka, ka pslatá həŋ nda pala. Kumaŋkuma yu ta tskanatá mnduha gha tavata iʼi, manda mana ghatalakw ta tskanatá nduɗukhani ma zlambakani, ka kwalaghutá kuni. ");
INSERT INTO xed_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wana lu dzaʼa zlaghunaŋtá həga ghuni. Haɗ kuni dzaʼa nghəglaŋtá iʼi ɗekɗek ha ka sagha fitik dzaʼa mnə kuni kazlay: Ka tfanaghatfa Lazglafta ta wi ta mndu ya ta sagha ma hga Mgham kəʼa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Baɗu sana sabat, ka sliʼaftá Yesu ka lami da həga ga sana mali mataba la Farisa da za skwa zay. Ka pghaftá gwal hada ta iri tida ka nghay ndeezla. ");
INSERT INTO xed_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mamu sani mndu kul ɗughwanaku nda hasla vghani ta nzaku hada. ");
INSERT INTO xed_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","«Mamu tvi ŋa mba mndu baɗu Sabat re haɗ wa a na?» ka Yesu ɗawaŋta da gwal tagha zlahu ŋa mnduha nda la Farisa. ");
INSERT INTO xed_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tsitsiriɗ nzanza həŋ kul zlghanaftá wi. Ka lagha Yesu ksaŋtá tsa mndu kul ɗughwanaku ya ka mbanafta, ka ghuniŋta dzaghani. ");
INSERT INTO xed_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kaʼa nda həŋ tama mantsa: «Wa mataba ghuni ka dəɗaghadəɗa zwaŋani, ka slani a tsi da vəvrəm baɗu Sabat dzaʼa kwal kul tɗigiŋta misimmisim na?» ");
INSERT INTO xed_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Triɗ, traptra həŋ ta skwi ŋa zlghanaftá wani. ");
INSERT INTO xed_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na nghay Yesu ta gwal hagaf lu ta zba vla nzaku ɗinaɗina, kaʼa nda həŋ nda mahdihdi mantsa: ");
INSERT INTO xed_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ka hgaf hga mndu ta kagha da vla za skwa zay, ma gi lə ka da nzata ma vli ɗina, ka waya ka skwi mamu sana mndu ta malaghutá kagha hgaf lu ŋa da tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Da lagha tsa mndu ta hgaftá kaghuni ya, da mnay ŋa gha kazlay: Sliʼafsliʼa, zlanaŋzla ta na vli na ta na mndu na kəʼa, ŋa ksutani ta kagha ka hula ta dzaʼa nzəglata ma hamata vla nzaku. ");
INSERT INTO xed_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Skwi ta raku ná, ka hgaf hga lu ta kagha da vla za skwa zay katsi, nzanza gha ma hamata vla nzaku karaku. Kəʼa ka tsa mndu ta hgaftá kagha ya ná, “ɓay gra! sliʼafsliʼa, sawi da nzata hadya,” kaʼa dzaʼazlay. Mantsa tama nda tsafara vgha gha da gwal dzaʼa za skwi kawadaga nda kagha. ");
INSERT INTO xed_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Inda mndu ta glanaftá ghəŋani, dzaʼa vraganavra lu, inda mndu ta vraganatá ghəŋani dzaʼa kapanafkapa lu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kaʼa nda tsa mndu ta hgafta ya mantsa: «Ka magamaga ka ta skwa zay ŋa badawa ka vaghu dər skwa zay ka hani a tsi ŋa mnduha, ma laghu ka hagay ta gra gha ta gra gha, ta zwaŋama gha ta zwaŋama gha, ta laghuni ta laghuni, nda ya ta sləvdaha gha ka gadghəl ka gadghəl, da hgaftá həŋ ta kagha ŋa plaghamta manava tsaya baɗu ya ga taŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ka magamaga ka ta skwa zay ŋa badawa katsi, haga ta la ka pɗu, nda la ka marghum, nda la nda rwa səlaha taŋ, nda gwal nda ghulpa, ŋa zay. ");
INSERT INTO xed_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dzaʼa nzanza ka nda rfu kabga haɗ fitik dzaʼa plaghamta həŋ manda va tsaya wa. Lazglafta dzaʼa plaghamta baɗu fitik dzaʼa sliʼagapta tɗukwa mnduha nda hafu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tahula snanata sana mndu mataba tsa gwal ta za skwa zay ya tsa gwaɗa ya, kaʼa nda Yesu mantsa: «Rfu da mndu dzaʼa za skwa zayni ma ga mghama Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ka Yesu nda tsi mantsa: «Lagha sana mndu ka magatá skwa zay dagala, ka hagaŋtá tsi ta mnduha nda ndəgha. ");
INSERT INTO xed_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ndusakwa skwa zay, ka ghunaftá tsa mndu ya ta duhwalani da mnanatá tsa mnduha hagaŋ tsi ya kazlay: Saghawasa nda maga fitikani kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lagha tsa mnduha ya ka mbahanaftá wi ta tva turtuk. “Mamu vwah skwa yu ná, tsaw nda nza tkweʼ ka dzaʼa ɗa nghanata ná, kiɓa, wya dzvu,” ka sani taŋtaŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Mamu slaha hva dzawa yu ghwaŋ dzaʼa yu dzaghaŋta” ná, kiɓa, wya dzvu, ka sani. ");
INSERT INTO xed_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Klafta ɗa yeya ta makwa ta ga maghurbi yu tsaya dzaʼa kwal yu ɓhata,” ka sani nda ŋani. ");
INSERT INTO xed_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ka vragaghatá tsa duhwal ya dzagha, ka rusanaftá tsi ta mghamani. Ka ɓasaftá tsa daŋahəgani ya ta ŋuɗuf. Kaʼa nda tsa duhwalani ya mantsa: “La misimmisim ta badawaha nda ya ta pazlalaha ma luwa, ka hagakta ka ta la ka pɗu, nda la marughumha, nda ghulpata mnduha, nda la nda rwa səlaha taŋ,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tahula magatani, ka vradaghatá tsi. “Mghama ɗa, nda maga tsa skwiha mna ka ya kay, tsaw ta tekeʼa vla nzakuha, kaʼa.” ");
INSERT INTO xed_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“La ta tvi ta tvi nda ya ma vla ŋaŋatá gam, ka hlakta ka ta inda mnduha dzaʼa slanaghata ka, ka da ndaghagapta vli ma hga ga ini, ka tsa daŋahəga ya nda duhwalani. ");
INSERT INTO xed_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ka yu ta mnaghunata ná, haɗ mndu mataba tsa gwal hagaŋ lu ya dzaʼa ɗaŋtá skwa zaya ɗa wa,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma sana fitik ta mbaɗa mnduha rutututa ta tvi mista Yesu, ka mbəɗavata Yesu, kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ka sagha da iʼi mndu katsi, ba malaghutani ta ɗvutá iʼi ka i dani nda mani, nda markwa taŋ, nda zwanani, nda zwanamani, nda kwaghamani, nduk nda vərɗa ghəŋani tani, kada nzakwa tsi ka duhwala ɗa. ");
INSERT INTO xed_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dər wa tsi ta kwalaghutá kla udza zləŋayni, ka kwalaghutá dzaʼa mista ɗa, laviŋ a ta nzakway ka duhwala ɗa wa. ");
INSERT INTO xed_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ka ta kumay mndu mataba ghuni ta baftá həga dagala katsi ní, haɗ ta nzata ka mbəɗaftá mbsaka skwi dzaʼa zaɗiŋta tsi karaku ŋa nghayni ka mamu re haɗ wa a tsedani prək ka kɗiŋtá tsa slna ya ra? ");
INSERT INTO xed_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ka mantsa a tsi wu, ka laghani ka thaftá mndəra tsa həga ya ka kwal kɗiŋtá bafta katsi, inda gwal dzaʼa nghanavata ná, dzaʼa ghuɓasay həŋ. ");
INSERT INTO xed_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ngha ta na mndu na ta thaftá mndəra hga ka traptá kɗiŋta,” ka həŋ dzaʼazlay. ");
INSERT INTO xed_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mantsa guli, ka ta kumay sana mgham ta vulu nda sana mgham katsi, haɗ ta nzata karaku ka ndanapta ka dzaʼa laviŋərlaviŋ a wa a tsi ta guyata nda ghumani ta dzaʼa sagha guyata nda tsi nda mnduha dəmbuʼ hisambsak wu ra? Tsaw tsatsi, dəmbuʼ ghwaŋ yeya ŋani ma mnduha. ");
INSERT INTO xed_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ka kəʼa kəʼa nghadapta laviŋta a tsi wu, ta ghunafghuna ta mndani da tsa sana mgham ya ta kul ɓhadaghatá tsi ndusa, ŋa ɗawa tva dzrafta nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mantsa tama, haɗ mndu dzaʼa laviŋtá nzata ka duhwala ɗa mataba ghuni, ka zliŋ a tsi ta inda skwihani wu,» ka Yesu sganaghata. ");
INSERT INTO xed_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Wya zɗa slughul, ka nda kɗa zɗaku mida katsi, ndaw dzaʼa vrəglanamta lu ta zɗakwani na? ");
INSERT INTO xed_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Zɗəgla a ŋa pghafta ta vwah dər ŋa rgwa wu, dzaʼa pghidiŋpgha lu ta haɗik. Ka mamu mndu nda sləməŋa snay, ka sna tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma sana fitik, ka gavadaghata gwal ta tska dzumna da sna gwaɗa da Yesu. ");
INSERT INTO xed_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mbaɗa la Farisa nda gwal tagha zlahu ka ruruŋwaku. «Niŋna na mndu na ta ghəŋani ka gra gwal dmaku, wana ta za skwi kawadaga nda həŋ,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ka mnə Yesu ŋa taŋ nda mahdihdi hdi: ");
INSERT INTO xed_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Waya mataba ghuni, ka dərmək tuwakhani, ka zaɗavaghuta ya turtuk mataba taŋ, dzaʼa kwal kul zlanavatá tsa pɗakuha taŋ təmbaymbsak təmbay mida ya ma mtak, ka laghwi da zba tsa turtuk ta zwaɗuta ya, ha ka nghaŋtani na? ");
INSERT INTO xed_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Manda nghaŋtani, ka rfu tsi ta rfu, ka tsukwaftá tsi ta badzagani. ");
INSERT INTO xed_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Manda vraktani dzagha, ka hagaŋtá tsi ta grahani nda sləvdahani. “Sawa ka rfa mu ta rfu, wana nda ngha yu ta tuwaka ɗa si ta zwaɗuta kay,” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ka yu ta mnaghunata ná, dzaʼa malaghumala rfu ta luwa ta ghəŋa mnda dmaku turtuk ta mbəɗanaftá nzakwani, ka ŋa tɗukwa mnduha təmbaymbsak təmbay mida ta kwalaghutá mbəɗanaftá nzakwa taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Ari wati marakw ya, ta mutsaftá suley ghwaŋ, ka zwaɗugudunustá suley turtuk matabani, dzaʼa kwal kul tsamtá vu ma pitirla, ka tsukwa həga ka psay ɗasuwa ha ka nghaŋtani na? ");
INSERT INTO xed_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Manda nghaŋtani, ŋa hagaŋtani ta magrahani nda sləvdahani. “Sawa, rfama ta rfu, wana nda ngha yu ta suley ɗa si ta zwaɗuta kay, kaʼa.” ");
INSERT INTO xed_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ka yu ta mnaghunata ná, dzaʼa malaghumala rfu da duhwalha Lazglafta ta ghəŋa mnda dmaku turtuk ta mbəɗanaftá nzakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wya kaʼa guli: «Mamu sana mndu his zwanani. ");
INSERT INTO xed_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Ari da! Vlihavla ta ŋaɗa ma skwa za həga má dzaʼa yu mutsay,” ka sagəŋ nda dani. Aray, ka da taŋ. Ka dganaptá tsi ta gadghəlani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsəɓakw fitik tahula tsa, ka dzawiŋtá tsa sagəŋ ya ta ŋani demdem, ka sliʼaftá tsi ka laghwi ta sana haɗik diʼiŋ. Hada, ka ɓadziŋtá tsi ta skwani ma maga sliʼiŋsliʼiŋ. ");
INSERT INTO xed_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Manda kuɗuta tsa skwani ya demdem, ka slatá maya ta tsa haɗik ya. Lay, ta haɗ skwi ɗekɗek da tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ka laghu tsi vzatá ghəŋani ŋa maga slna ga sana mndu ma tsa haɗik ya. Ka ghunaghatá tsa mndu ya da ngha ghuvazuha ma vwahani. ");
INSERT INTO xed_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ka dzə maya. Ta kumay si má ta za tsa skwa zaya ghuvazuha ya, lay haɗ mndu ta vlaŋta wa. ");
INSERT INTO xed_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ka zlraftá tsi ta ndanu: “Kidaghi gwal ta ksa slna ga da ɗa, ta za skwi ka haslay, wana iʼi hadna ta mtaku da maya! ");
INSERT INTO xed_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dzaʼa vru yu da da ɗa. Vradaghata ɗa ya, da! maganamaga yu ta dmaku ta Lazglafta, magaghamaga yu ta dmaku guli, ");
INSERT INTO xed_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","rgla a yu ka hgay ka zwaŋa gha wu, fafa ta iʼi manda mndu tekw mataba gwal magaghatá slna,” ka yu dzaʼazlay nda tsi, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ka sliʼaftá tsi ka vraghuta da dani. «Ta ghwa a ka ɓhadaghata dzagha wu, ka nghaŋtá dani. Ka ksaftá tsi ta dani ka hiɗahiɗa, ka sliʼaftá tsi nda hwaya, ka lagha tsi habwaʼ tida, ka brusay. ");
INSERT INTO xed_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ari Da! maganamaga yu ta dmaku ta Lazglafta, magaghamaga yu ta dmaku ta kagha guli, rgla a yu ka hgəgəlta ka zwaŋa gha wu,” ka tsa zwaŋ ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Klagapwa kla misimmisim ta tsa lgut ɗina katakata ya, ka suɗanavata kuni, fanaf kuni ta halagar ta dzvu, suɗanam kuni ta ɓaɓah ma səla. ");
INSERT INTO xed_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ksagaghawaksa ta mamakwa sla nda uwasla, ka hnata kuni, ka za mu, ka rfa mu ta rfu. ");
INSERT INTO xed_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nana zwaŋa ɗa wana tsi na ná, manda skwi si nda mta, wana vrakta nda hafu, si nda zaɗa ka nghavatá tsi,” ka dani nda kwalvahani. Ka zlraftá həŋ ta rfu. ");
INSERT INTO xed_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Tsaw ma vwah zumala tsa mndu ya ta tsa fitik ya. Ta vraktá tsa zumali ya dzagha, laghani ndusa nda həga, ka snaŋtá tsi ta ghudzaga dewdew nda skalu ga taŋ. ");
INSERT INTO xed_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ka hgaŋtá tsi ta sani ma kwalva taŋ, ka ɗawaŋta da tsi ta skwi ta magaku. ");
INSERT INTO xed_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Zwaŋama gha ya ta vrakta, ka dzatá da gha ta mamakwa sla nda uwasla, kabga nghaŋtani ta ɗughwana,” ka tsa kwalva ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ka ɓasaftá tsi ta ŋuɗuf, ka kwalaghutá dzaʼa da həga. Ka sabə dani gatay ŋa lamani da həga. ");
INSERT INTO xed_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Má kidagha vakwa ɗa na ta magaghatá slna, ta kwalaghu a yu ɗekɗek ta snatá skwi ta mnihata ka wa. Ta ksaf a ka ta dər ɓizaɓiza gu ka vlihata ŋa hnata ɗa, ka rfay ŋni ta rfu nda graha ɗa wa. ");
INSERT INTO xed_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na vrakta zwaŋa gha ya ta zaɗanatá gadghəla gha ŋa gwal ta hliri ná, ŋani ta hna yu ta mamakwa sla nda uwasla ka ka,” kaʼa nda dani. ");
INSERT INTO xed_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Sagəŋ, kawadaga kagha nda iʼi inda fitik. Inda skwa ɗa ná, ŋa gha ya. ");
INSERT INTO xed_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nda ra ka magatá skwa skalu, ka rfay mu ta rfu. Nana zwaŋama gha wana tsi na ná, si nda mta, ka vraktá tsi nda hafu. Si nda zaɗa, ka nghavatá tsi,”» ka dani nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ka Yesu nda duhwalhani guli mantsa: «Mamu sana mnda gadghəl ta hlaftá huzlani ka pghanamtá sana mndu ma dzvu ŋa nghanata. Ka lagha lu da mnanata kazlay: Waʼa tsa mndu ya ta badza huzla gha kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka hgaŋtá tsi. Kaʼa nda tsi mantsa: “Waka ka ta magay ka lu ta snə yu ya na? Mnihamna káka ta maga slna gha. Ndanana na, nzəglanaghata a ka ta ghəŋa huzla ɗa wa,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka tsa mndu si ma dzvani tsa huzlaha ya mantsa: “Waka yu dzaʼa magay tama? Wana hlaghuhla daŋahəga ɗa ta inda huzlaha ma dzva ɗa? Ka la yu da hva ka yu, haɗ mbrakwa ɗa wu. Ka la yu da gatá skwi ka yu, dzaʼa ksay ta iʼi ka hula. ");
INSERT INTO xed_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ala, nda sna yu ta skwi dzaʼa yu magay dzaʼa kəl mnduha ka tsuʼaftá iʼi ghzləɗisrə lu dazlay,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tahula tsa tama ka hagaftá tsi ta gwal nda huzla daŋahəgani da həŋ. “Kidaghi skwi ta dzaʼa ka vlay ŋa daŋahəga ɗa na?” kaʼa nda taŋtaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Garwa rɗi dərmək ya,” kaʼa nda tsi. “Klafkla ta ɗelewera gha, nzanza misimmisim ka vindafta ka ta hutafmbsak,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ki da kagha, ta kidaghi ŋa gha ŋa vlay?” kaʼa nda sani guli. “Buhwa hya dərmək ya,” kaʼa nda tsi. “Klafkla ta ɗelewera gha, vindafvinda ta Tghasmbsak,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hwiɗhwiɗa na mndu na, ka tsa daŋahəga ya ka ghuba tsa ghwaɗaka mndu ya. Tsaw mal hiɗata mnduha ma na ghəŋa haɗik na nzakwa taŋ mataba taŋ, ka zwana tsuwaɗak,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Ka iʼi ta mnaghunata na: Hlawa na ghwaɗaka skwa gadghəl ta na ghəŋa haɗik na, ka kasa kuni ta gra nda tsi. Baɗu kɗaghutani da kaghuni ya, ŋa tsuʼay Lazglafta ta kaghuni ma həgani ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ka nda sna mndu ta ŋanatá skwi kwitikw, nda sna guli ta ŋanatá skwi dagala. Ka sna a mndu ta ŋanatá skwi kwitikw wu katsi, sna a guli ta ŋanatá skwi dagala wa. ");
INSERT INTO xed_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka laviŋ a kuni ta ŋanatá ghwaɗaka skwa gadghəla na ghəŋa haɗik na wu katsi, wa dzaʼa mnay kazlay: Zlgha ta vərɗa skwa gadghəl kəʼa? ");
INSERT INTO xed_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka laviŋ a kuni ta ŋanatá skwa gadghəl wu ní, wa dzaʼa vlaghatá vərɗa ŋa gha ma skwi tama. ");
INSERT INTO xed_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Laviŋ a kwalva turtuk ta ga kwalva daŋahəga his wa. Nda husaŋta sani turtuk, nda ɗvutani ta sani. Ka mantsa a tsi wu, dzaʼa ndiʼanava ndiʼa ta vgha ta sani, ŋa husaŋta tsa sani ya. Laviŋ a kuni ta nzakway ka kwalva Lazglafta kuni guli na, ka kwalva tsedi kuni guli wa,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ka ghuɓasu la Farisa ta sna inda tsa gwaɗa ya ta Yesu, kabga ɗvuɗva hahəŋ ta tsedi. ");
INSERT INTO xed_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ka Yesu nda həŋ mantsa: «Ka tɗukwa mndu aŋni ka kaghuni ta mara ghəŋa ghuni ta kəma mnduha. Tsaw nda sna Lazglafta ta ŋuɗufa ghuni. Tsa skwi ta ghubu mnduha nda ghuba ya ná, ka manzakɗaway nzakwani ta wa ira Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Daga ghalya ta zlraftá lu ta mna gwaɗa ta ghəŋa skwi vindaf lu ma deftera zlaha Musa, nda ya ma deftera anabiha, ha ka sagha ta fitika zlagapta Yuhwana mnda maga Batem. Ta fitika zlagapta Yuhwana mnda maga batem tama, ka zlraftá lu ta mna gwaɗa ta ghəŋa Lfiɗa Gwaɗa ta ga mghama Lazglafta, ka zluʼu mnduha ta vgha ŋa lami. ");
INSERT INTO xed_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tsaw mal ndəkweɗata hərɗuta luwa nda haɗik ka dəɗavaghuta thatá skwi turtuk ma zlahu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Mndu ta ghzliŋtá markwa taŋ ka klaftá sani ná, hliri ta hlu tsa mndu ya. Mndu ta klaftá marakw ghzliŋ zəʼala taŋ guli ná, hliri ta hlu tsa mndu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Mamu sana mndu ghalya ka gadghəl, lgut kulefeɗfeɗa nda bla dzvani ta suɗə tsi ta vgha. Inda fitik, skwi zɗazɗa ta zə lu ga taŋ. ");
INSERT INTO xed_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mamu sana mndu guli Lazar hgani, ka pɗu, ka lku vghani dzeʼdzeʼ, ta ziʼaku, ta hani ta watgha ga tsa mnda gadghəl ya. ");
INSERT INTO xed_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta kumay si ta baghaftani nda wiwisa ɗafa ta rkata ma vlə zay tsa mnda gadghəl ya, sew mutsaf a wa. Ama kriha yeya katək ta sliʼadaghata da niʼa tsa lkuhani ya. ");
INSERT INTO xed_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ka mtuta tsa mndu ka pɗu ya, ka tsukwaghatá duhwalha Lazglafta fata tavata Abraham. Ka mtutá tsa mnda gadghəl ya guli, ka paɗamtá lu. ");
INSERT INTO xed_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka ghuyə tsi ta ɗaŋwa katakata ma vla nzakwa gwal nda rwa. Kəʼa kəʼa klaŋtá ghəŋ ná, ka nghaŋtá tsi ta Abraham diʼiŋ kawadaga nda Lazar. ");
INSERT INTO xed_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Da ɗa Abraham! Tawatá hiɗahiɗa ta iʼi! Ghunafghuna ta Lazar ka tsughumamta tsi ta ndəfiŋa dzvani ma imi, ka ɗiɗifta tsi ta ghanik ləŋləŋləŋ, kabga ta ghuya ɗaŋwa yu katakata ma na vu na,” kaʼa dzatá lawlaw. ");
INSERT INTO xed_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ka Abraham nda tsi mantsa: “Sagəŋ! Havaphava ka za mghama gha si ta zə ka ma nzakwa gha nda iri ta ghəŋa haɗik, ta ghuyə Lazar ta ɗaŋwani ya. Ndana tama nda lɓa ŋuɗufa tsatsi, ta ghuyə kagha ta ɗaŋwa gha. ");
INSERT INTO xed_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Zlaŋha lu ta tsa, mamu mghama gudzuvruŋ ta dgamata. Dər má ta kumay mnduha ta sliʼafta hadna da aŋni ŋa dzaʼa da kaghuni ná, laviŋ a həŋ wa. Laviŋ a lu ta tsughwaɗagapta da kaghuni ka sagha da aŋni guli wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ka si mantsa tsi, wya dzvu, ghunatá Lazar da la ga da ɗa, ");
INSERT INTO xed_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kabga ta mamu zwanama ɗa hutaf. Ka dzaʼa tsi da snanamtá həŋ, da sagha hahəŋ guli da ghuya ɗaŋwa ma na vla ghuya ɗaŋwa na,” ka tsa mnda gadghəl ya. ");
INSERT INTO xed_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mamu vindatá deftera zlaha Musa nda vindatá gwaɗa la anabiha da zwanama gha, ka snasna həŋ,” ka Abraham nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Slaghwa a tsaya da ɗa Abraham wu, ka sliʼaf hadna mndu da gwal nda rwa, ka lagha slanaghatá həŋ ka tsi ná, hadahada həŋ dzaʼa mbəɗanaftá nzakwa taŋ,” ka tsa mnda gadghəl ya. ");
INSERT INTO xed_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ka va a həŋ ta sna tsa zlaha Musa nda tsa gwaɗaha la anabi ya wu katsi, dər ki sliʼafta mndu da gwal nda rwa ka lagha slanaghatá həŋ, haɗ fitik dzaʼa snata həŋ wu, ka Abraham nda tsi,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ka Yesu nda duhwalhani tama mantsa: «Nda nza tkweʼ ka nzakwa skwiha dzaʼa dziŋtá mnduha ka tuthun. Ama ɗaŋwani ma mndu ta zləmbiŋtá sani. ");
INSERT INTO xed_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta draŋ ya ma hbanam lu ta buna ma lwi ka vzaghata da drəf, ka vzamtani ta sanlaha nda hta da dmaku. ");
INSERT INTO xed_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nghawa ghəŋa ghuni! «Ka gaga zwaŋama gha ta dmaku, mnanaŋmna dar. Ka mbəɗanaf mbəɗa tsi ta nzakwani, planapla ta dmakwani. ");
INSERT INTO xed_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ka dər ndəfáŋ səla gaghata tsi ta dmaku ta fitika turtuk ka va sagha tsi mnaghaŋta kazlay: Bgaɗaya kəʼa, plinispla,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka gwal ghunay nda Mgham Yesu mantsa: «Sgaŋnagha zlghay nda ŋuɗuf,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka Yesu tsuʼanaftá wani ta həŋ mantsa: «Ka mamu zlghay nda ŋuɗufa ghuni taɓta hya kramasa katsi, dzaʼa mnay kuni ŋa ya babala ya kazlay: Tɗaftɗa ta vgha gha ka dzaʼa ka vzamtá vgha ma drəf kəʼa, ŋa snaghunatani.» ");
INSERT INTO xed_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Ka mamu ya mataba ghuni ta hvanatahva ta mndu, ka ta nghanatá rini a tsi, na gi nghaŋta tsa mndu ya ta saghani ma vwah ná, “sawi misimmisim da za skwa zay” kaʼa dzaʼazlay nda tsi ra? ");
INSERT INTO xed_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Skwi dzaʼa tsi mnay ná, “diha skwa zay, ka mbəɗapta ka ta lgut ŋa vla skwi ŋa ɗa, ta zə yu. Tahula tsa, ŋa zay gha ta ŋa gha kəʼa.” ");
INSERT INTO xed_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dzaʼa rfay ta tsa kwalva ya kabga magatani ta tsa skwi mnana tsi ya ra? ");
INSERT INTO xed_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","«Mantsa ya kaghuni guli, ka magamaga kuni ta skwi mnaghuna Lazglafta ŋa magay katsi, “nu hayhaya kwalva ma aŋni ɓa, skwi ya laviŋ ŋni ta magata maga ŋni, ka kuni mnay,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ta dzaʼa Yesu da luwa Ursalima, ka labə tsi ma takataka haɗika Samari nda Galili. ");
INSERT INTO xed_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tata lamə nda la Yesu da sana luwa, ka sagha gwal ghwaŋ hlu rɗa mndu ta həŋ guyaku nda tsi. Ka nzagaghatá həŋ kətsauʼ. ");
INSERT INTO xed_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Mgham Yesu, tawatá hiɗahiɗa ta aŋni,» ka həŋ kapaŋtá lwi. ");
INSERT INTO xed_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na gi pghafta irani ta həŋ, «lawa la maranaŋtá vgha ghuni ta mnda dra skwi ŋa Lazglafta,» kaʼa nda həŋ. Tata mbaɗa həŋ ka dzaʼa, gi kləwəɗ nda mbamba həŋ. ");
INSERT INTO xed_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na gi nghaŋtá sani turtuk mataba taŋ ta tsa mbatani ya, ka vraktá tsi nda zləzlva Lazglafta nda lwi dagala dagala, ");
INSERT INTO xed_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ka lagha tsi zləmbatá ma ghuva Yesu, ka rfay. Tsaw mnda la Samari tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ka Yesu mantsa: «Ghwaŋ a həŋ ta mbambafta kay ra? Ga tsaha təmbay ya katək na? ");
INSERT INTO xed_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nana mndu ka matbay na yeya kweŋkweŋ ta vragaghata da rfanaghatá Lazglafta ra?» ka Yesu ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","«Sliʼafsliʼa gha ka dzaʼa ka, zlghay nda ŋuɗufa gha ta mbaghafta,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ka la Farisa nda Yesu mantsa: «Yawu dzaʼa sagha fitika ga mghama Lazglafta na?» ka həŋ. Kaʼa nda həŋ mantsa: «Ghur a dzaʼa nghaŋta lu ta sagha ga mghama Lazglafta wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","«Haɗ lu dzaʼa mnay kazlay: Aʼ! “Wana tsi,” aʼ! “Waʼa tsi” kəʼa wa. Ɗina ka snaŋta ghuni kazlay: Ma takataka ghuni ga mghama Lazglafta kəʼa,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kaʼa nda duhwalhani guli mantsa: «Dzaʼa saghasa fitik ŋa kumaŋta ghuni ta nghaŋtá fitika Zwaŋa mndu dər turtuk səla tsi, nghaŋta a kuni wa. ");
INSERT INTO xed_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka lu dzaʼazlay nda kaghuni na: “Aʼ! Wa a hada a,” “aʼ! Wana hadna,” yaha kuni da dzaʼa, yaha kuni da slaslamaku. ");
INSERT INTO xed_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Manda ɗaslakwa wuɗa luwa ta sliʼafta ta sana slərpu ka labə da sana vli ya ná, mantsa ya dzaʼa sagha Zwaŋa mndu baɗu ŋani fitik. ");
INSERT INTO xed_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma kɗə tsaya, dzaʼa ghuyapə ghuya ta ɗaŋwa katakata ŋa vziŋta na mnduha ta na fitik na. ");
INSERT INTO xed_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tsa skwi ta maguta ma fitika Nuhu ya ná, mantsa ya dzaʼa magakwa tsi ma fitika Zwaŋa mndu guli. ");
INSERT INTO xed_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta zazaku mnduha, ka sasaku, ka hla miʼi, ka vla kwagha taŋ ŋa zəʼal, ha ka sagha fitik kəl Nuhu ka lami da kwambalu, ka sagha imi vlunduɗ zaɗanatá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka guram nda skwi ta magata ta fitika Ludu dzaʼa magakwa tsi. Ta zazaku mnduha, ka sasaku, ka sakway, ka dzawapta, ka ŋaɓay, ka babay, ");
INSERT INTO xed_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","vagim baɗu saghwa Ludu ma Suduma ya, ka zlagatá drəfa vu zaɗanatá həŋ tendərzleleʼ. ");
INSERT INTO xed_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Manda va tsaya dzaʼa nzakwa tsi baɗu tsa fitik dzaʼa zlagapta Zwaŋa mndu ya. ");
INSERT INTO xed_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Baɗu tsaya, ka ta nzaku mndu ta dədəmatá ghəŋa həga, dər ma mamu huzlani ma huɗa həga, yaha tsi da saha da hlay, ka hwayaghuta tsi. Mantsa mndu ma vwah guli, yaha vru dzaghani. ");
INSERT INTO xed_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Havakwa markwa Ludu ɓa! ");
INSERT INTO xed_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mndu ta kuma mbanaftá hafani ka ghəŋani ná, dzaʼa zaɗiŋzaɗa. Ama mndu ya ta zaɗiŋtá hafani dzaʼa mutsafmutsa. ");
INSERT INTO xed_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ka yu ta mnaghunata ná, ma tsa rviɗik ya, gwal his ta hani ta ghzləŋa turtuk, ŋa klaghutá sani, ka zlanavatá sani. ");
INSERT INTO xed_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Miʼaha his ta huʼu ka skwa turtuk, ŋa klaghutá sani ka zlanavatá sani. ");
INSERT INTO xed_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mnduha his ma vwah, ŋa klaghutá sani ka zlanavatá sani,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ka duhwalhani nda tsi mantsa: «Ga dzaʼa magakwa tsa skwiha ya ní Mghama ɗa?» ka həŋ. «Ka ga mbla skwi ya ná, hada ta tska gugzlum ta vgha,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka mnə Yesu ta mahdihdi ŋa taŋ, ŋa gɗavata taŋ nda maga duʼa, yaha malandugwa taŋ da rwaku, da zlanatá həŋ. ");
INSERT INTO xed_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kaʼa mantsa: «Mamu sana mnda tsa guma ma sana luwa kul zləŋa Lazglafta, haɗ ghuyani nda mnda səla wa. ");
INSERT INTO xed_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mamu sana markwa wadgu ma va tsa luwa ya guli, ta va gɗata ta lagha da mnay ŋani kazlay: Dgaŋna guma mataba ŋni nda ghuma ɗa, kaʼa tazlay. ");
INSERT INTO xed_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nda kɗa fitika kwalaghutani ta tsanatá tsa gumani ya. Tahula tsa, kaʼa ma ghəŋani mantsa: “Dər ma zləŋa a yu ta Lazglafta wu, haɗ ghuya ɗa nda mnda səla guli wu, ");
INSERT INTO xed_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tsaw wana na wadgu na ta ghuya iʼi, dər tsanata ɗa ta na gumani na, yaha da gɗata ta sagha da ghuya ghəŋa ɗa,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","«Fawa sləməŋ ka sna kuni ta skwi mnə tsa ghwaɗaka mnda tsa guma ya ɓa! ");
INSERT INTO xed_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lazglafta yeya dzaʼa kwal kul maganatá zɗaku ta mnduhani ta wahu da tsi gifitik nda rviɗik tani ŋa gərɗa həŋ rki na? ");
INSERT INTO xed_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ka iʼi ta mnaghunata, dzaʼa gi maganamaga ta zɗaku ta həŋ gi hadahada. Nziya nza tsi, baɗu vragata dzaʼa vragata Zwaŋa mndu ní, dzaʼa slanaghasla ta gwal ta zlghafta nda ŋuɗuf rki na?» ");
INSERT INTO xed_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ka mnə Yesu ta sana mahdihdi guli kabga sanlaha ta ngha ghəŋa taŋ ka gwal tɗukwa ta kəma Lazglafta ka ghuɓasa sanlaha. ");
INSERT INTO xed_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kaʼa mantsa: «Mamu sana mnduha his ta ŋladafta da həga Lazglafta da maga duʼa. La Farisa sani, mnda tska dzumna sani. ");
INSERT INTO xed_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ka sladatá tsa la Farisa ya ka maga duʼa ma ghəŋani. Kaʼa mantsa: “Ari Lazglafta, ta rfay yu ta kagha, kabga nza a iʼi manda sanlaha ma mnduha, gwal ghali, ka ghwaɗak mnduha, nda gwal hliri wa. Nza a yu manda ya mnda tska dzumna ya wa. ");
INSERT INTO xed_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fitik his ta fata yu ka suma ma luma, ta vlay yu ta skwi turtuk ŋa gha ma skwiha ɗa ghwaŋ kəʼa.” ");
INSERT INTO xed_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na tsa mnda tska dzumna ya kay ka nzagaghata kətsauʼ, walaŋ a ta kapaŋtá ghəŋ nda ta luwa wa. Mbaɗa kəʼa ka wuslikay dzvu, ka dza ghuva. Kaʼa mantsa: “Ari Lazglafta, tawa ta hiɗahiɗa ta iʼi ta nzakway ka mnda dmaku na,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ka iʼi ta mnaghunata, ta lagha tsa mndu ya dzaghani, nda dzra ŋani nda Lazglafta. Mantsa a nzakwa ŋa tsa la Farisa ya wa. Nzakwani ná, dər wa ta kapanaftá ghəŋani, dzaʼa gwitsaganagwitsa lu. Ka hananahana mndu ta ghəŋani, dzaʼa kapanafkapa lu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mbaɗa mnduha ka va hlaktá zwani kwitikw kwitikw da Yesu ŋa tfanaghatani ta wi ta həŋ guli, Na nghaŋta duhwalhani ta tsa hladaghatá zwani ya, ka ghzlə həŋ ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka hgaŋtá Yesu ta həŋ, kaʼa mantsa: «Zlaŋwazla ta zwani ka sagha həŋ da iʼi! Ma pyə kuni ta həŋ. Nda nza ga mghama Lazglafta ka ŋa gwal ta gara vgha nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kahwathwata ka yu ta mnaghunata, dər wa ta kwal kul tsuʼaftá ga mghama Lazglafta manda zwaŋ kwitikw ná, haɗ dzaʼa walaŋta lami dida ɗekɗek wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ka ɗawaŋtá sana mghama la Yahuda da Yesu kaʼa mantsa: «Ŋərma mgham, nu da a yu magay ka da mutsafta yu ta hafu ŋa kɗekedzeŋ na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka Yesu nda tsi mantsa: «Kabgawu ta kəl ka hga iʼi ka ŋərma na? Lazglafta turtukwani ŋərma. ");
INSERT INTO xed_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nda sna ka, ka zlahu ta mnay: “Ma hlu ka tiri, ma dza ka ta mndu, ma ghali ka ta ghali, ma tsanava ka ta gwaɗa ta mndu, vlatá glaku ŋa i da gha nda ma gha, kəʼa,”» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","«Aʼ! Sna a iʼi ta tsaha ya daga ma ga zwaŋa ɗa ra,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na snaŋta Yesu ta tsaya, kaʼa mantsa: «Turtuk skwi ta pɗəgədaghawta. La dzawiŋtá skwiha gha, ka daganafta ka ta tsedani ta la ka pɗu, dzaʼa mutsay ka ta gadghəl ta luwa, ka vrakta ka, ka dzaʼa ka mista ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na snaŋtani ta tsa gwaɗa ya, suʼanak kumani kabga gadghəl ya katakata. ");
INSERT INTO xed_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nghanata Yesu ta tsa suʼanaka ta ŋuɗufani ya, kaʼa mantsa: «Eʼ! Nda bla ka lama gadghəl da ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ta draŋ lama ŋalibwa nda ta ghuruma lipir, ka lama gadghəl da ga mghama Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","«Ka si mantsa tsi, waya dzaʼa mbafta ɓa?» ka tsa gwal ta sna skwi ta mnə tsi ya. ");
INSERT INTO xed_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","«Tsa skwi nda bla nzakwani da mnda səla ya ná, bla a da Lazglafta wu,» ka Yesu zlghanaftawa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ka Piyer mantsa: «Aʼa! Wana aŋni ta zlaŋtá inda skwa ŋni, ka dzaʼa mista gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, ka zlaŋzla mndu kabga ga mghama Lazglafta, ta hgani, ka markwa taŋ a tsi, ka zwanamani a tsi, ka i dani nda mani a tsi, ka zwanani a tsi, ");
INSERT INTO xed_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dzaʼa kwal kul mutsaftá skwi dagala ma na zamana na, ŋa mutsaftani ta hafu ŋa kɗekedzeŋ dazlay wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ka hgadaghatá Yesu ta duhwalhani ghwaŋpɗə his da tsi, kaʼa nda həŋ mantsa: «Wana mu ta dzaʼa da Ursalima hada dzaʼa kɗafta skwi vindaf la anabi ta ghəŋa Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dzaʼa vlaŋvla lu ta gwal kul nzakway ka la Yahuda, ŋa gagay taŋ, ŋa rarazay taŋ, ŋa tafay taŋ ta sərɗək tida. ");
INSERT INTO xed_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tahula sləvapta taŋ nda krupi, ŋa dzata. Ta mahkəna fitik, ŋa sliʼagaptani.» ");
INSERT INTO xed_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sna a duhwalhani ta tsa skwi ta mnə tsi ya wa. Gwaɗa nda ɗifa ya ta snə hahəŋ, sna a həŋ ta klatá ghəŋani wa. ");
INSERT INTO xed_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ndusadaghata Yesu tavata luwa Yeriku, mamu sana ghulpa ta mndu ta nzaku ta wa tvi ta gatá skwi. ");
INSERT INTO xed_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Snaŋtani ta dəmga ta sliʼadaghatá, ka ɗawaŋtá tsi ta skwi ta magaku. ");
INSERT INTO xed_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka mnanatá lu kazlay, Yesu mnda la Nazaret ya ta labə kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kaʼa mantsa: «Yesu zwaŋa Dawuda, tawatá hiɗahiɗa ta iʼi,» kaʼa dzatá lawlaw. ");
INSERT INTO xed_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lagha tsa gwal ta kəma ya ka davay, ka mbəl ŋa hanaftá wi. «Zwaŋa Dawuda, tawatá hiɗahiɗa ta iʼi!» kaʼa sganaghatá lwi dagala dagala. ");
INSERT INTO xed_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka sladavatá Yesu. «Klakwakla,» kaʼa mnanatá mnduha. Manda gavadanaghata, ");
INSERT INTO xed_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«nu ta kumə ka ta magaghata ɗa na?» ka Yesu ɗawaŋta da tsi. «Maləma ɗa, ka nghəglaŋta yu ta vli,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ka Yesu nda tsi mantsa: «Nghəglaŋ ngha gha, zlghay nda ŋuɗufa gha ta mbaghafta,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Gi hadahada, nzuwiɗiɗ irani, ka sliʼaftá tsi ka dzaʼa mista Yesu nda zləzlva Lazglafta. Inda mndu ta nghaŋta ka zləzlvu tsi ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ka ɓhadamtá Yesu da luwa Yeriku, ka labə nda mida. ");
INSERT INTO xed_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mamu sana mndu ta hgə lu ka Zakayus, mali ta ghəŋa gwal tska dzumna, gadghəl ya guli. ");
INSERT INTO xed_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ka zbə tsi ta tva gmata nda Yesu, ka wa tsi ya. Tsaw laviŋ a ta nghaŋta wa. Ka dekweri nzakwani tskutska mnduha guli ");
INSERT INTO xed_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ka hwayaghatá tsi nda ta kəma, ka ŋladafta ta sana fwa babala, ŋa nghaŋta Yesu ta labə nda ta tsa tvi ya. ");
INSERT INTO xed_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Manda ɓhadaghata Yesu da tsa vli ya, ka kapaŋtá tsi ta ghəŋ, ka nghadafta. Kaʼa mantsa: «Zakayus, sasa gha misimmisim da ghuni ta dzaʼa yu gita,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka gi saha Zakayus, ka laghu həŋ da taŋ, ka tsuʼaftá tsi ta Yesu nda rfu. ");
INSERT INTO xed_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nghaŋta mnduha ta tsaya, mbaɗa həŋ ka ruruŋwaku. «Wa a laghwa tsa mndu ya da mnda dmaku,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ka sladata Zakayus, kaʼa nda Mgham Yesu mantsa: «Sna ɓa Mghama ɗa! Dzaʼa daganaftá slɓahwa gadghəla ɗa yu ta la ka pɗu. Ka mamu mndu si hulgudunus yu ta skwani, fwaɗ səla dzaʼa planamta yu ta va tsa skwani ya guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka Yesu mantsa: «Samsa mbaku da na həga na gita, kabga zivra Abraham tsatsi guli. ");
INSERT INTO xed_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tsaya ná, sa psa gwal nda zaɗa ŋa mbambanaftá həŋ Zwaŋa mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tata snaysnay həŋ ta tsa skwi ya, ka sganaghatá Yesu ta mahdihdi kabga ndusanavatani ta luwa Ursalima. Guli ná, zlah gi dzaʼa zlagapzlaga ga mgham Lazglafta, ka mnduha ta ndanay. ");
INSERT INTO xed_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wya tsa skwi ta mnə tsi ya: «Mamu sana mndu ka katsala mndəra taŋ ta laghwi ta sana haɗik diʼiŋ, ŋa famta ka mgham, kada vrakta tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma kɗə tsi kada laghwi, ka hagaʼatá tsi ta gwal ksanatá slna ghwaŋ ka daganaftá tseda dasu pal pal pal ta həŋ. “Ka tsakala kuni ta tsakala nda tsi ta vraktá yu,” kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tsa mndu ya ná, ta husaŋhusa ta tsa mnduha ta tsa haɗik ya. Ka ghunaftá həŋ ta mnduha ta hulani kazlay: Va a ŋni ta gayni ta mgham ta ghəŋa aŋni wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kulam nda tsa, ka famtá lu ma mgham, ka vraktá tsi ta haɗikani. Ka hagaktá tsi ta tsa gwal daganaf tsi ta tsedi ya, ŋa ɗawaŋta da həŋ ta skwi mutsanagha həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ka lagha sani taŋtaŋ. Kaʼa mantsa: “Mghama ɗa! Ghwaŋ mutsanaghata yu ta ghəŋa tsa vliha ka ya kay,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ɗina tsa, vərɗa kwalva ka. Fitika tsa nzata gha ka vərɗa mndu ma skwi kiʼa ya, ka ŋumna ta ghəŋa luwaha ghwaŋ ta famta yu ta kagha,” ka tsa mgham ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ka lagha mahis. “Mghama ɗa! Hutaf mutsanaghata yu ta ghəŋa tsa vliha ka ya kay,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Kagha guli, ka ŋumna ta ghəŋa luwaha hutaf ta fanaghata yu ta kagha, kaʼa.” ");
INSERT INTO xed_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ka sagha sani. Kaʼa mantsa: “Mghama ɗa! Aʼa tseda dasa gha. Ma lgut si mbsamta yu. ");
INSERT INTO xed_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Zləŋafzləŋa yu ta kagha, nda bla gwaɗa ta kagha, ta klay ka ta skwi kul fata ka, ta tskay ka ta skwi ta vwah ya kul sləgaftá ka,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ghwaɗaka kwalva ka. Ta gwaɗa gha ta tsaghaghata yu ta guma. Nda sna kagha kazlay: Nda bla gwaɗa ta iʼi, ta klay yu ta skwi kul fata yu, ta tskay yu ta skwi ta vwah kul sləgaftá yu kəʼa a tsa wa. ");
INSERT INTO xed_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kabgawu kwal ka kul famta ta tsa tseda ɗa ya ma baŋki? Ma na vrakta ɗa na ná, ma ŋa klagapta ɗa nda zwaŋ ta ghəŋani?” ");
INSERT INTO xed_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ka mgham nda tsa gwal hada ya mantsa: “Kləgədanaghwa tsa tseda dasu ya ka gwanaghata kuni ta tsa ghwaŋ ŋani ya,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka həŋ nda tsi mantsa: “Aʼa! Ghwaŋ a ŋani tsa mghama ɗa wa!” ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ka iʼi ta mnaghunata wa, ka mamu skwi da mndu katsi, ŋani ta sganaghata lu. Ala ka haɗ skwi da mndu wu katsi, kləgadanaghutá va tsa kiʼatani ta fə tsi ta ghəŋ tida ya, kaʼa zlghanaftawi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tsa hamata gwal kul kuma nzakwa ɗa ka ga mgham ta ghəŋa taŋ ya, hlagaghawahla ta həŋ ka pslata kuni ta həŋ tawa ira ɗa, kaʼa nda həŋ,”» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tahula mnata Yesu ta tsa gwaɗa ya, Ka sliʼaftá tsi ka mbaɗa ta kəma taŋ ŋa dzaʼa da Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Manda ndusanavatani ta luwa Beslaze, nda luwa Betani ta nzakway ndusa nda ghwá Zaytuŋ ya, ka ghunaftá tsi ta duhwalhani his. Kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Lawala da na luwa ta kəma mu na. Ɓhadaghata ghuni ya, dzaʼa slanaghasla kuni ta zwaŋa kɗih ta hba, ta kul walaŋtá mndu ta lafi tida. Ka plata kuni ka klaktá kuni. ");
INSERT INTO xed_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Ka ŋaw ta pla kuni na?” ka mndu nda kaghuni ya, “Mgham ta psay”» ka kuni dazlay nda tsi, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ka laghu tsa gwal ghunagha lu ya, ka slanaghatá həŋ manda va ya mnana Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tata playplay həŋ, «ŋaw kuni ta zwaŋa kɗih na?» ka tsa gwal nda kɗiha taŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","«Mgham ta psay,» ka həŋ zlghanaftawi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ka klanaktá həŋ ta tsa zwaŋa kɗih ya ta Yesu. Ka pghaftá həŋ ta lgutha taŋ tida. Ka faftá Yesu tida. ");
INSERT INTO xed_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka gavu həŋ ya ná, ka zlazlatə mnduha ta lgutha taŋ ta tvi. ");
INSERT INTO xed_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ndusadaghatani nda Ursalima, nda ta tsa tvi ta saha nda tvə ghwá Zaytuŋ ya, mbaɗa inda tskata duhwalhani ka rfu, ka zləzlva Lazglafta nda lwi dagaladagala ta ghəŋa inda mazəmzəm ya nghaŋ həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Ka tfanaghatfa Lazglafta ta wi ta Mgham ta sagha ma hgani. Zɗaku ta luwa, glaku ŋa Lazglafta ta luwa nda gaftək,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","«Lma ta na duhwalha na ɓa, ka lɓata həŋ,» ka sanlaha ma la Farisa ta lami da taba dəmga. ");
INSERT INTO xed_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","«Ka iʼi nda kaghuni wa, ka hafha həŋ ta wa taŋ ná, pala dzaʼa wahay,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ndusadaghatani ɗekɗek nda luwa, ka nghanavatá tsi, ka taw tsi ta taw ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kaʼa mantsa: «Ka má nda sna kagha Ursalima káka má da zba zɗakwa gha gita! Ndana tama, zaɗaghaghazaɗa nghəglaŋta a ka wa. ");
INSERT INTO xed_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dzaʼa saghasa fitika ksaghaghata, ŋa dzəɓafta ghumaha gha ka waghafta, ka ŋamtá kagha hesl dər ndiga. ");
INSERT INTO xed_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ŋa zaɗaghata nda mnduha gha tani. Zlanata a həŋ ta nzugwatá pala ta ghəŋa sani wu, kabga tsatsafa a kagha ta tsa fitika sagha Lazglafta da kata kagha ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ka lamə Yesu da həga Lazglafta, ka zlraftá tsi ta ghzlagaptá gwal ta tsakala. ");
INSERT INTO xed_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kaʼa mantsa: «Vinda a ma deftera Lazglafta kazlay: Həga ɗa ná, həga maga duʼa ya kəʼa ra? Na kaghuni ná, ka niŋta ka galigha la ghali?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka taghə Yesu ta skwi ŋa mnduha ma həga Lazglafta inda fitik. Mbaɗa gwal dra skwi ŋa Lazglafta nda gwal tagha zlahu, nda la mali ta ghəŋa mnduha ka psa dzatá Yesu. ");
INSERT INTO xed_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama sna a həŋ ta tvi ka həŋ dzaʼa ɓhanavata wu, kabga dar fata mnduha ta vgha ka sna gwaɗani. ");
INSERT INTO xed_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ma sana fitik, ma tsa fitika tataghay Yesu ta skwi ŋa mnduha ma həga Lazglafta, ka mna Lfiɗa Gwaɗa ya, ka sliʼadaghatá la mali mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu, nda la galata mndu slanaghata. ");
INSERT INTO xed_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ka həŋ mantsa: «Mnaŋnamna, ka wa ta mnaghatá maga na skwiha na, ka wa ta vlaghatá mbrakwa magay?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka Yesu mantsa: «Ka ɗawaghuna ɗawa iʼi guli. ");
INSERT INTO xed_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Lazglafta ta ghunagatá Yuhwana da maga batem re, ari mnduha a na? mnihawa mna,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka nzatá həŋ ka dzrəkay mataba taŋ. «“Ka Lazglafta ya ta ghunagata” ka mu, “nu kul zlghaftá kuni ta gwaɗani ɓa,” kaʼa dzaʼazlay nda amu. ");
INSERT INTO xed_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Ka mnduha ya” ka mu guli, dzaʼa zlrətsaku mu nda pala da inda mnduha ŋa pslatá amu, kabga nda sna inda taŋ kazlay: Anabi Yuhwana kəʼa.» ");
INSERT INTO xed_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","«Sna a aŋni ka wa ta ghunagaghata wu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ka Yesu mantsa: «Ahaa! Iʼi guli ná, haɗ yu ta mnaghunata ka wa ta vlihatá mbrakwa maga tsa skwiha ya wu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tahula tsa, ka zlraftá Yesu ta mna mahdihdi ŋa mnduha, kaʼa mantsa: «Lagha sana mndu ka ŋaɓatá fuha inabi ma vwahani. Ka sliʼaftá tsi ka laghwi distaluwa ŋa nzɗavata. ");
INSERT INTO xed_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Magatá fitika ɗaga yakwa fwa inabi, ka ghunaftá tsa mndu ya ta kwalvani slanaghatá tsa gwal ta hva vwaha tsa inabi ya, ŋa hlanaftá mayaka ŋani ma yakwa fu. Ka mbəɗanatá tsa gwal ta hva tsa vwah ya ta tsa kwalva ya nda dzə kul klanafta. ");
INSERT INTO xed_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka ghunglaftá tsi ta sana kwalvani, ka rəhaptá həŋ ta tsaya guli, ka rarazata, ka vriŋta kul klanafta. ");
INSERT INTO xed_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka ghungladaptá tsi ta mahkəna kwalvani, ka balanatá həŋ ta tsaya guli ka vzidiŋta. ");
INSERT INTO xed_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ka dani ma tsa vwaha inabi ya mantsa: “Waka yu dzaʼa magay? dzaʼa ghuna zwaŋa ɗa ɗvu yu, yu. Tsatsi yeya dzaʼa vlə həŋ ta glaku ŋani,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na ghur nghay tsa gwal ta hva vwaha tsa inabi ya ta lagha tsa zwaŋ ya, gi ka həŋ mantsa: “Ya wana tsa mndu dzaʼa za həga ya tane, dzamadza, ka nzakwa na fuha inabi na ka ŋa mu,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ka tsəhaghatá həŋ diʼiŋ nda tsa vwaha inabi ya, ka dzata.» Ka Yesu mantsa: «Mantsa tama ní, nu dzaʼa maganata dani ma vwaha inabi ta həŋ? ");
INSERT INTO xed_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dzaʼa laghala slanaghatá tsa gwal ta hva tsa vwaha inabi ya, ka pslatá həŋ. Ŋa klaftani ta tsa fwa inabi ya, ka fanamta ma dzvu ta sanlaha ma mnduha,» kaʼa nda həŋ. «Haɗ tsaya dzaʼa magaku mantsa wu,» ka tsa mnduha ta sna gwaɗa Yesu ya hlaftawi. ");
INSERT INTO xed_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka naghadamtá Yesu da kuma taŋ, kaʼa mantsa: «Nu klatá ghəŋa tsa gwaɗa vindaf lu ma deftera Lazglafta kazlay: Tsa pala wuɗidiŋ gwal ta ba həga ya, ta nuta ka palaka tughwa həga kəʼa ya? ");
INSERT INTO xed_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inda mndu dzaʼa nzeghwafta ta tsa pala ya, dzaʼa huruɓu huruɓa. Ka tsa pala ya ta dəɗanaghatá tsa mndu ya katsi guli, dzaʼa huʼanap huʼa ŋərɗək,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma va tsa fitik ya, ka zbə la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu, ta tva ksaftá Yesu, kabga nda sna həŋ kazlay: Ta ghəŋa taŋ ta mna Yesu ta tsa mahdihdi ya kəʼa, ama ka zləŋaftá həŋ ta mnduha. ");
INSERT INTO xed_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ka va ɗakwats həŋ ta Yesu, ka ghunadaghatá həŋ ta sana mnduha ta nzakway manda va ya ŋərma mnduha ya, da ɗawa gwaɗa da Yesu, ŋa ɗakwatsa gwaɗa da tsi, ŋa ksafta ka vlaŋtá ŋumna. ");
INSERT INTO xed_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ka ɗawaŋtá həŋ da tsi: «Mghama ɗa! Nda sna ŋni ta gwaɗa ta gwaɗə ka, nda skwi ta taghə ka tɗukwa nzakwani kəʼa. Haɗ ka ta gala mndu wu, tva nzaku kahwathwata manda ya ta kumə Lazglafta ta taghə ka,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","«Mnaŋnamna, nda ra re ra a wa a ka play mu ta dzumna ŋa mgham Sezar na?» ka ga ŋni. ");
INSERT INTO xed_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tsatsafta Yesu ta tsa maɗgwirmaɗgwira taŋ ya, kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Yahawa ka nghanata yu ta tsa kwaɓu ya. Fuwata wa nda hga wa na thaf lu tida na na?» kaʼa. «Ŋa mgham Sezar ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","«Ala plawa ŋa mgham Sezar ta ya ta nghanatá mgham Sezar. Plawa ŋa Lazglafta ta ya ta nghanatá Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Triɗ traptra həŋ ta ksaftá krughuvani ma skwi ya ta mnə tsi ta kəma mnduha. Tsa zlghawani yeya ta vlaŋtá ndərmimay ta həŋ katək, ka nzatá həŋ faflara. ");
INSERT INTO xed_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ka gavadaghatá sanlaha ma la Sadukiya guli tavatá Yesu. Tsa la Sadukiya ya gwal ta mnay kazlay: Haɗ sliʼagapta ma mtaku nda hafu wu kəʼa ya. Ka ɗawaŋtá həŋ da Yesu. ");
INSERT INTO xed_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Mghama ɗa! Ka Musa vindaŋnafta na: “Ka mamu sana mndu nda zwaŋamani ta klaftá marakw ka mtuta kul yatá zwaŋ katsi, ka kla tsa mndu ta ndiri ya ta tsa wadgani ya, ŋa yanatani ta zivir ta zwaŋamani,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tsaw mamu la zwanama ndəfáŋ həŋ. Ka klaftá zumali ta marakw ka mtuta kul yatá zwaŋ. ");
INSERT INTO xed_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ka klutá mahis ta tsa wadgu ya, ");
INSERT INTO xed_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","mantsa ya mahkən, ka raftá həŋ ndəfáŋ ndəfáŋ tida ka rwuta həŋ, haɗ ya ta yatá zwaŋ nda tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mantsa ya guli ka mtanaghatá tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mantsa tama ní, ŋa wa ŋa wa dzaʼa nzakwa tsa marakw ya baɗu sliʼagapta ma mtaku nda hafu, ya wya klukla tsa mnduha ya ndəfáŋ ndəfáŋ ka markwa taŋ na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka Yesu nda həŋ mantsa: «Ta kluvustá vgha zgwana nda miʼaha ma na ghəŋa haɗik na, ");
INSERT INTO xed_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ama zgwana nda miʼaha gwal nghadap Lazglafta kazlay: Nda ra həŋ ka vragapta ma mtaku nda hafu, ŋa nzaku nda hafu ma mbəɗakwa luwa dazlay kəʼa ya, haɗ həŋ dzaʼa kluvustá vgha wa. ");
INSERT INTO xed_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Haɗ həŋ dzaʼa mtəgəltá mtaku wu, kabga nda nza həŋ manda duhwalha Lazglafta. Nda nza həŋ ka zwana Lazglafta, kabga sliʼagapsliʼa həŋ ma mtaku, ka nzata nda hafu. ");
INSERT INTO xed_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kɗiŋkɗa Musa ta mnata kazlay: Dzaʼa sliʼagapsliʼa gwal nda rwa ŋa nzaku nda hafu kəʼa. Ma vla gwaɗa ta ghəŋa mubukw ta zlghaku, ka hgə tsi ta Mgham, “ka Lazglafta Abraham, ka Lazglafta Izak, ka Lazglafta Yakubu.” ");
INSERT INTO xed_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lazglafta ná, Lazglafta gwal nda rwa a wa, Lazglafta gwal ndiri ya, kabga inda taŋ demdem ŋani ta nzakwa həŋ nda hafu.» ");
INSERT INTO xed_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rkauʼ tsuʼuwaghu tsuʼa sanlaha ma gwal tagha zlahu ta gwaɗa, ka həŋ mantsa: «Zɗa tsa gwaɗa gha ya Mghama ɗa,» ka həŋ, ");
INSERT INTO xed_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Walglaŋ a həŋ ta ɗawglaŋtá sana skwi da tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ka Yesu mantsa: «Kura ki lu ta mnay kazlay: Kristi ná, zwaŋa Dawuda ya kəʼa na? ");
INSERT INTO xed_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wya mnamna vərɗa Dawuda ma deftera Zabura kazlay: “Ka Mgham Lazglafta nda mghama ɗa ná, nzanza nda ga zeghwa ɗa, ");
INSERT INTO xed_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta nanaftá yu ta ghumaha gha ka skwa ta diŋlay səla gha” kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Waka Kristi dzaʼa nzaku ka zwaŋa Dawuda, ya wya “Mgham” ka Dawuda ta hgay?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tata sna tsa gwaɗa ta mnə tsi ya mnduha, ka Yesu nda duhwalhani mantsa: ");
INSERT INTO xed_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ɗaswa ka kuni nda gwal tagha zlahu zɗəgana wawaku ta həŋ nda lgut zutututa ta kuma gagay lu ta zgu ŋa taŋ ta dawadawa ya. Vla nzaku ta kəma ŋa taŋ ta zbay ma həga tagha skwa la Yahuda nda ya ma vla za skwa zay. ");
INSERT INTO xed_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Hahəŋ gwal ta tskugudunustá skwa miʼa wadgu. Ta slriŋslra həŋ ta maga duʼa ŋa ghubu. Dzaʼa tsanaghatsa lu ta guma ta həŋ katakata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kəʼa ka Yesu fatá iri ná, ta pgha tsedi gwal gadghəl da akwata pgha tsedi ma həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ka nghaŋtá tsi guli ta sana markwa wadgu ka pɗu ta pgha aneni his dida. ");
INSERT INTO xed_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaʼa mantsa: «Kahwathwata ka yu ta mnaghunata ná, mal ya markwa wadgu ka pɗu ya ta pghadatá tsedi ka inda sanlaha. ");
INSERT INTO xed_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tsa tsedi pghada sanlaha ya ná, ma fərta tani da həŋ klaʼata həŋ ka pghadata da tsa akwati tsedi ya. Ya marakw ya ná, kɗavakta skwi ma ŋa zayni pghada tsatsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mbaɗa sana mnduha ka mna gwaɗa ta ghəŋa ɗinakwa həga Lazglafta nda rkatarkani nda pala nda skwiha ta vlə lu ŋa Lazglafta. Ka Yesu nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Tsəna skwi ta nghə kuni na ná, dzaʼa saghasa fitik ŋa kwal kul nghəglaŋtá nzugwatá pala ta sani, dzaʼa tasiŋtasa lu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","«Mghama ɗa! Yawu dzaʼa magakwa tsa skwiha ya, mndəra wati ŋizla dzaʼa kəl lu ka snaŋtá magakwa tsa skwiha ya tama?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","«Ɗaswa ka kuni da nanaghunaftá lu, kabga nda ndgha gwal dzaʼa sagha ka klaftá hga ɗa ka mnay kazlay: “Iʼi Kristi, ndusakndusa fitik,” ka həŋ dzaʼazlay. Yaha kuni da dzaʼa mista taŋ. ");
INSERT INTO xed_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Baɗu da snaŋta kuni ta mna gwaɗa ta vulu ta vulu lu, nda ghazeŋzeŋ ta ghazeŋzeŋ lu ya, yaha ŋuɗufa ghuni da tɗu, ya kɗakwa ghəŋa haɗik a tsaya karaku wa. Tkweʼ ka tiŋlaghuta tsa skwiha ya ta slata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","«Dzaʼa vulay mndəra sana mnduha ta vulu nda mndəra sana mnduha. Dzaʼa vulay sana mgham ta vulu nda sana mgham. ");
INSERT INTO xed_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dzaʼa ghudzavafghudza haɗik katakata. Dzaʼa mamu ɗaŋwaha, nda maya guli ma vliha kavghakavgha. Dzaʼa mamu skwiha ta gaga zləŋ, nda ŋizlaha dagaladagala dzaʼa saha ta luwa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ma kɗaku tsa skwiha ya magaku dzaʼa kasay lu ta kaghuni, dzaʼa ghuyay lu ta ɗaŋwa ŋa ghuni, dzaʼa hlay lu ta kaghuni da həga tagha skwa la Yahuda, ŋa tsaghunaghatá guma, dzaʼa tsatsam tsatsa lu ta kaghuni ma gamak, dzaʼa hlay lu ta kaghuni ta kəma mghamha nda ŋumnaha, kabga nzakwa ghuni ka ŋa ɗa. ");
INSERT INTO xed_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dzaʼa slaghunaghasla tsa skwiha ya, ŋa maraŋta ghuni ta nzakwa ghuni ka masləmtsəka ɗa. ");
INSERT INTO xed_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wya skwi ŋa famta ghuni ma ghəŋ: Yaha kuni laghwi da ndanay ká kuni dzaʼa waraptá ghəŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iʼi, dzaʼa ndanaghunaktá tva gwaɗaha nda ɗifil ŋa ŋarapta ghuni ta ghumaha ghuni, ŋa trapta taŋ ta skwi ŋa mbəɗay. ");
INSERT INTO xed_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kulam nda dadaha ghuni tani, nda mamaha ghuni tani, nda zwanama ghuni tani, nda zbəha ghuni tani, nda graha ghuni guli tani, dzaʼa vlatá kaghuni ŋa pslanaghutá sanlaha mataba ghuni. ");
INSERT INTO xed_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dzaʼa husaŋhusa kuni ta həŋ demdem, kabga nzakwa ghuni ka ŋa ɗa. ");
INSERT INTO xed_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama dər turtuk haɗ ya dzaʼa dəɗavaghuta ma swida ghəŋa ghuni wa. ");
INSERT INTO xed_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Drusa ka kuni da nzata, ya tsaya dzaʼa kəl kuni ka kataftá htsiŋa ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Baɗu da nghaŋta kuni ta wanafta sludziha ta luwa Ursalima ya, ya ndusa kɗakwa gwaɗa tida nda tsa. ");
INSERT INTO xed_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka mantsa tsi katsi, ka hwaya gwal ta haɗika Zudiya ta ghwá. Ka sliʼapta gwal ma luwa Ursalima guli. Yagha gwal tahula luwa da sagha ka lami da huɗa luwa. ");
INSERT INTO xed_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mantsa ya dzaʼa tsanaghata Lazglafta ta guma ta mnduhani, ŋa hɗanamtá ghəŋa skwi ya nda vinda ma deftera Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ɗaŋwa ŋa miʼaha nda huɗi dzaʼazlay, nda gwal nda zwaŋ ta ghuva taŋ ma tsa fitik ya, kabga dzaʼa mamu ghuya ɗaŋwa dagala ma tsa fitik ya. Dzaʼa maranaŋmara Lazglafta ta ɓasa ŋuɗufani ta tsa mnduha ya. ");
INSERT INTO xed_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dzaʼa pslapsla lu ta həŋ nda kafay nda za, dzaʼa hlaghahla lu ta həŋ da ga vuʼa mataba mndəra sana mnduha. Dzaʼa tasiŋtasa gwal kul snaŋtá Lazglafta ta luwa Ursalima, ha ka kɗaghuta fitika gay taŋ ta mgham.» ");
INSERT INTO xed_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Dzaʼa nghaku ŋizla ta fitik nda tili nda tekwatsa. Ta ghəŋa haɗik guli, dzaʼa ghudzaga drəf, ŋa vavalakwa imi, ŋa ksutani ta mnduha ka zləŋ katakata, snaŋta a həŋ ta skwi ŋa magay wa. ");
INSERT INTO xed_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dzaʼa rwaku mnduha da zləŋa vəl ndana skwi dzaʼa magaku ta ghəŋa haɗik, kabga dzaʼa ghudzavafghudza skwiha nda mbra nda mbra ta luwa. ");
INSERT INTO xed_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma tsaya dzaʼa nghaŋta lu ta Zwaŋa mndu ta saha ma mbrakwani nda glakwani dagala ma kusay. ");
INSERT INTO xed_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ka zlrafzlra tsa skwiha ya ta magaku katsi, ka payavata kuni, ka kapaŋta kuni ta ghəŋ ya ndusakwa fitika mbakwa ghuni tsa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wya kaʼa granaftá həŋ guli: «Nghawangha ta ghuraf nda inda fuha ɓa. ");
INSERT INTO xed_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ka nda ngha kuni ta zlrafta taŋ ta ɗaku, gi nda sna kuni ndusa dəwiŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mantsa ya, ka nda ngha kuni ta magakwa tsa skwiha ya, ka snaŋta kuni ndusakndusa fitika ga mghama Lazglafta kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kahwathwata ka yu ta mnaghunata, haɗ na mnduha gitana na dzaʼa rwuta demdem, makɗaku inda tsa skwiha ya ka magaku wa. ");
INSERT INTO xed_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dzaʼa lula luwa nda haɗik, gwaɗa ɗa ná luta a ɗekɗek wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ɗaswa ka kuni da laghu kuni dzamtá ghəŋ ma skwi ŋa zay nda za, nda skwi ŋa say nda sa, nda ndana nzaku ma ghəŋa haɗik, da sagha tsa fitika sagha Zwaŋa mndu ya ksaghunaghata dluk. ");
INSERT INTO xed_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Manda vza kadəŋ ya dzaʼa sagha tsi ta ghəŋa inda mnduha ta ghəŋa haɗik tender. ");
INSERT INTO xed_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hzleŋa ka kuni nzata, ka va maga kuni ta duʼa dər ta wati luwa tsi, kada mutsafta kuni ta ndapta ma inda tsa skwiha dzaʼa magaku ya, ŋa sladata ghuni ta kəma Zwaŋa mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gifitik gifitik ya, ta tatagha skwi Yesu ma həga Lazglafta. Gahawu gahawu ya guli, laghwani hanə ta sana ghwá ta hgə lu ka ghwá zaytuŋ. ");
INSERT INTO xed_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tsaɗakwa vli gasərɗək ya, sliʼadaghata inda mnduha da sna gwaɗa ta mnə tsi ma həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ka ndusagaghatá fitika za buradi kul haɗ is mida ta hgə lu ka skala Pak. ");
INSERT INTO xed_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka zbə la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda gwal tagha zlahu ŋa mnduha ta tvi ŋa ksaftá Yesu ŋa dzata. Kəl həŋ ka psa tvi nda psa ná, kabga ta zləŋay həŋ ta mnduha. ");
INSERT INTO xed_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsaw ka lami halaway da Zudas ta hgə lu ka Iskaryut ta nzakway mataba mbsaka gwal ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ka sliʼaftá Zudas ka laghwi dzrafta nda la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la mali ta ghəŋa gwal ta ngha həga Lazglafta kəʼa dzaʼa laviŋtá ksanaftá həŋ ta Yesu. ");
INSERT INTO xed_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ka rfu tsahaya ta rfu. Dzaʼa vlaghavla aŋni guli ta tsedi, ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tahula dzrafta taŋ, ka zbə tsi ta fitik ya dzaʼa kəl tsi ka vlaŋtá həŋ ta Yesu kul snaŋtá mnduha. ");
INSERT INTO xed_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ka sagha tsa fitika za buradi kul haɗ is mida ya. Tsa fitik ya ta kəl lu ka dzaɓa maŋazak ŋa za skala Pak. ");
INSERT INTO xed_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ka ghunaftá Yesu ta i Piyer nda Yuhwana: «Lawala ka dzaʼa kuni payamaftá skwa zaya Pak,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","«Ga ta kuma ka ta dzaʼa ŋni payamafta na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kaʼa nda həŋ mantsa: «Wya tsi, na lama ghuni da luwa ya, dzaʼa guyaku kuni nda sana mndu ta kla bzleghwa imi, ka dzaʼa kuni mistani da tsa həga dzaʼa lami tsi ya. ");
INSERT INTO xed_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“Ga tsa vli ŋa zay ŋni ta skwa zay ŋa skala Pak kawadaga nda duhwalha ɗa ya na ka Mgham nda kagha?” ka kuni dazlay nda zəʼala həga ma tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ya dzaʼa maraghunamara ta vli ma sana dzuguvi dagala ta ghəŋa sana həga, nda payatá inda huzla mida. Hada dzaʼa payamafta kuni ta skwa zay ŋa skala Pak,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ka sliʼaftá həŋ ka laghwi, ka slanaghatá həŋ ta tsa skwiha ya manda ya mnanaf tsi ta həŋ. Ka payaftá həŋ ta skwa zay ŋa skala Pak hada. ");
INSERT INTO xed_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na sagha tsa fitik ya, ka nzatá tsi ka za skwa zay kawadaga nda gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kaʼa nda həŋ mantsa: «Ndaɗa a kumafta yu ta zay ɗa ta na skwa zaya skala Pak na kawadaga nda kaghuni ma kɗaku yu ghuya ɗaŋwa wa. ");
INSERT INTO xed_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mantsa nzakwani, ka yu ta mnaghunata ná, haɗ yu dzaʼa zəglaŋtá na skwa zay na ɗekɗek ha ka sagha fitika dzatá ghəŋani ma ga mghama Lazglafta wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ka kapaŋtá tsi ta leghwa, ka rfanaghatá tsi ta Lazglafta, kaʼa mantsa: «Zlghawa ta na leghwa na, ka rafta kuni tida, kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mantsa nzakwani, ka yu ta mnaghunata ná, kwanaha say ɗa nana ta ima yakwa inabi ɗekɗek, ha ka sagha fitika ga mghama Lazglafta.» ");
INSERT INTO xed_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ka kapaftá tsi ta buradi, tahula rfanaghatani ta Lazglafta, ka ɓlanaptá tsi, kaʼa mantsa: «Nanana ná, sluʼuvgha ɗa ya vla lu ŋa ghuni, ka maga kuni manda nana ŋa havay ghuni ta iʼi,» kəʼa ka vlaŋtá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tahula zuta taŋ ta skwa zay, ka kapaftá tsi ta leghwa manda tsaya guli, kaʼa mantsa: «Nana leghwa na ná, slərɓatá zughu mataba mnduha nda Lazglafta ya nda ma usa ɗa ta pghuta ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nghawa ɓa! Nana mndu ta skwaptá iʼi na ná, wana ta za skwi zay kawadaga nda iʼi. ");
INSERT INTO xed_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wya teʼuwa dzaʼa mtaku Zwaŋa mndu manda ya ghada Lazglafta ta mnata, ama ɗaŋwani ma mndu dzaʼa vlatá Zwaŋa mndu ma dzva mnduha ŋa dzata!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ka zlraftá tsa duhwalha ya ta ɗaɗaway da sani nda sani ta tsa mndu mataba taŋ dzaʼa magatá tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ka sliʼavaftá gwaɗa ɗuk mataba tsa gwal ghunay ya. Wa ta nzakway ka mali mataba mu na? ka həŋ zlərɗanafta. ");
INSERT INTO xed_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ka Yesu nda həŋ mantsa: «Ta ga má mgham mghama taŋ mghamha kul snaŋtá Lazglafta ta ghəŋa mnduha taŋ. “Ŋərma mnduha,” ká lu má hga aŋni, ka tsa gwal ta ga mgham ta ghəŋa taŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yaha ŋa ghuni da nzakway manda tsaya. Katək ná, ka nzanza tsa mndu ka mali mataba ghuni ya manda zwaŋ kwitikw. Tsa mndu ta kla kəma ya guli, ka nzanza tsi manda mndu ta dga skwi ŋa mndu. ");
INSERT INTO xed_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wa mali katək na, mndu ta nzata ka zay zay re? Ari mndu ta dgaydgay a na? mndu ta nzata ka zay zay mali kasiʼi kiʼe? Ala, wana iʼi mataba ghuni manda mndu ta dgaydgay. ");
INSERT INTO xed_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kaghuni, wana gɗavagɗa kuni kawadaga nda iʼi ma ɗaŋwaha ghuyə yu. ");
INSERT INTO xed_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Manda ya payana Da ɗa ta vla ga mghamani ŋa ɗa ya, manda tsaya ta payaghunata iʼi guli ta kaghuni. ");
INSERT INTO xed_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ŋa nzata ghuni ka zay nda say ma ga mghama ɗa, ŋa nzanzafta ghuni ta dughurukwa má mgham mgham, ŋa tsay ghuni ta guma ta ghəŋa mndəra la Israʼila ghwaŋpɗə his.» ");
INSERT INTO xed_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simuŋ! Simuŋ! Nda sna ka ra? ɗawafɗawa halaway ta mbraku ŋa ktsiɗa kaghuni manda hya ma dzelela. ");
INSERT INTO xed_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tsaw magamaga yu ta duʼa ta ghəŋa gha, kada kwala zlghay nda ŋuɗufa gha htuta ɗekɗek. Baɗu vragaghuta gha da iʼi ya, ka mba ka ta zwanama gha,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","«Mghama ɗa, dər dzaʼa tsamta ma gamak lu ta kagha, dər dzaʼa dzata nda dza lu ta kagha, nda fa vgha iʼi ŋa dzaʼa mista gha,» ka Piyer nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","«Piyer! ka yu ta mnaghata ná, makɗaku vazak ka wahata gitaʼuna ná, hkən səla dzaʼa mnata ka kazlay: Sna a yu ta na mndu na wu kəʼa,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kaʼa nda həŋ guli mantsa: «Ma fitika ghwanaghata ɗa ta kaghuni da vəl diʼiŋ da mna gwaɗa, kul haɗ tsedi, kul haɗ zlibi, kul haɗ ɓaɓah ya kay ní, mamu skwi pɗa kuni ra?» kaʼa. «Haɗ wa,» ka həŋ zlghanaftá wi. ");
INSERT INTO xed_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","«Ndana tama, ka mamu tseda mndu, ka klafta tsi, ka mamu zliba mndu, ka klafta tsi guli, ka haɗ kafay da mndu wu katsi, ka skwapta tsi ta lguta huɗani ŋa skwata. ");
INSERT INTO xed_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ka yu ta mnaghunata ná, nana gwaɗa Lazglafta ta mnay kazlay: Tekw tsatsi mataba gwal pslatá mnduha kəʼa ya, ka nza tsi ta ghəŋa iʼi manda tsa. Ndanana, wana tsa skwi mnaf lu ta iʼi ya dzaʼa magaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","«Mghama ɗa, wana kafayha his,» ka həŋ. «Prək tsa tsa,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ka sliʼaftá Yesu ka sabi, ka laghwi ta ghwá zaytuŋ manda ya snu tsi ta magay, ka laghu duhwalhani mistani guli. ");
INSERT INTO xed_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Manda ɓhadaghatani da tsa vli ya, «magawamaga ta duʼa kada kwala kuni ta zləmbuta dzəghaghunar skwi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ka tsaghutá tsi ta vgha ta vata həŋ ka zaptá mtak prək ka mtaka wuɗadaptá pala. Ka tsəlɓatá tsi ka maga duʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Da! Ka má ta kumay ka, klaghukla ta na ghuya ɗaŋwa na ta ghəŋa ɗa! Tsaw yaha da nzakw manda ya ta kumə iʼi, ka nza tsi manda ya ta kumə kagha,» kaʼa.  ");
INSERT INTO xed_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka gi saha duhwalha Lazglafta daga ta luwa da vlaŋtá mbraku. ");
INSERT INTO xed_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma tsa tɗata ŋuɗufani ka ghuyay ya, ka ŋavatá tsi ka maga duʼa, ka nuta visani manda palaka us, ka taɗaku ta haɗik. ");
INSERT INTO xed_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Manda kɗakwani ta maga duʼa, ka sliʼaftá tsi ka lagha slanaghatá duhwalhani ta hani kabga nda gurɗa ŋuɗufa taŋ katakata. ");
INSERT INTO xed_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Kabgawu ta kəl kuni ka hani na? Sliʼafwasliʼa, magawamaga ta duʼa kada kwala kuni ta zləmbuta dzəghaghunar skwi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tata tsa gwaɗa ya Yesu, nda sliʼadaghata mnduha vlunduɗ slanaghata. Tsa mndu ta hgə lu ka Zudas tekw mataba duhwalha ghwaŋpɗə his ya kay ta kəma taŋ. Ka lagha tsi tavata Yesu da brusay. ");
INSERT INTO xed_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","«Ari Zudas! Nda ma brusay dzaʼa vlata ka ta Zwaŋa mndu ra?» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nghay tsa gwal kawadaga nda Yesu ya ta skwi dzaʼa magaku ná, ka həŋ mantsa: «Mghama ɗa! Ka tsa ŋni ta həŋ nda kafay ra?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka gi tsanamtá sani mataba taŋ ta kwalva mali ta ghəŋa gwal dra skwi ŋa Lazglafta, ka tsaghutá sləməŋa zeghwani. ");
INSERT INTO xed_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","«Zlaŋwazla prək tsa!» ka Yesu nda həŋ. Ka ksaŋtá tsi ta sləməŋa tsa mndu ya, ka mbanafta. ");
INSERT INTO xed_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ka Yesu nda tsa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la mali ta ghəŋa gwal ngha həga Lazglafta, nda la galata mndu ta sliʼadaghata da ksay ya mantsa: «Nya kəl kuni ka sliʼakta nda kafay nda kafay, nda sarak nda sarak na, gənda yu ra? ");
INSERT INTO xed_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inda fitik yu si kawadaga nda kaghuni ma həga Lazglafta, zbaŋ a kuni ta ksaftá iʼi wu, ŋa ghuni nda mghama na grusl ná, na fitik na gita tama,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tahula ksafta taŋ ta Yesu, ka klaghatá həŋ da həga ga mali ta ghəŋa gwal dra skwi ŋa Lazglafta. Ka sliʼi Piyer tahula taŋ tahula taŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Vanagha va lu ta vu ma takataka daɓa həga, ka lagha Piyer nzata ka slinay mataba gwal ta nzaku ta slinayslinay. ");
INSERT INTO xed_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kəʼa ka sana kwalva ka marakw ná, ta nzaku Piyer ka slina vu, ka faftá tsi ta iri tida ka vitsay. «Si kawadaga na mndu na guli nda tsa mndu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","«Makwana, sna a yu ta tsa mndu ya wu,» ka Piyer ka waɗay. ");
INSERT INTO xed_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓats nzɗa, ka nghaŋtá sana mndu guli ta Piyer. «Tekw kagha mataba taŋ tani,» kaʼa nda tsi. «Gra! Nu gwaɗa gha nda iʼi tagha,» ka Piyer. ");
INSERT INTO xed_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Va rɓats nzɗa tahula tsa guli, «kahwathwata kawadaga na mndu na nda tsi, mnda la Galili ya,» ka sana mndu nda tsi nda mbraku nda mbraku. ");
INSERT INTO xed_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","«Sna a yu ta na skwi ta kumə kagha ta mnay na gra wu,» ka Piyer. Tata tsa gwaɗa ya Piyer, ma va tsa fitik ya, ka wahatá vazak. ");
INSERT INTO xed_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka mbəɗavatá Mgham Yesu nghagapta ka Piyer ma kuma. Ka havaktá Piyer ta gwaɗa mnana Yesu kazlay: Makɗaku vazak wahata gita u nana, hkən səla dzaʼa waɗata ka kazlay: Sana a yu ta na mndu na wu kəʼa nda iʼi kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ka saghu Piyer dzibil ka laghu hərɓa taw. ");
INSERT INTO xed_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mbaɗa tsa mnduha ta ŋanatá Yesu ya ka gagay, ka dəŋzlay. ");
INSERT INTO xed_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka hbanamtá həŋ ta patak ma kuma. «Tsatsaf tsatsa ta mndu ta dəŋzlughusta,» ka həŋ ka ɗaway da tsi. ");
INSERT INTO xed_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ka vavazə həŋ ta rutsak tida ka rarazay. ");
INSERT INTO xed_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tsaɗakwa vli, ka tskavatá la galata mnduha mataba la Yahuda, nda mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tagha zlahu ŋa mnduha, ka klaghatá həŋ ta Yesu da vla tsa guma taŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ka həŋ mantsa: «Kagha Kristi ra? Mnaŋnaŋ mna,» ka həŋ. Ka Yesu mantsa: «Dər ki mnaghunata yu, zlghəta a kuni wa. ");
INSERT INTO xed_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Dər ki ɗawaghunata yu, tsuʼuta a kuni ta wani wa. ");
INSERT INTO xed_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Daga ndanana, dzaʼa nzanza Zwaŋa mndu nda ga zeghwa Lazglafta nda mbra.» Ka Yesu zlghanaftawani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","«Zwaŋa Lazglafta kagha nda yeya tama rke?» ka həŋ hlaftá wi. «Manda tsa nzakwani manda ya mna kuni,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","«Mndəra wati gwaɗa tata zbəgəlta mu, ya wya mnamamna vərɗa tsatsi nda wubisimani, nda sna sləməŋa amu?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ka sliʼaftá həŋ demdem, ka klaghatá Yesu da Pilat ta nzakway ka ŋumna. ");
INSERT INTO xed_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Wana na mndu na, slanagha ŋni ta hwazlaɓa mnduha ŋni. Ma plə kuni ta dzumna ŋa mgham Sezar, iʼi Kristi ta nzakway ka mgham, kaʼa,» ka həŋ ka vaza rutsak tida. ");
INSERT INTO xed_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ka Pilat mantsa: «Kagha mghama la Yahuda ra?» kaʼa ɗawaŋta da tsi. «Manda tsa mna ka ya nzakwani,» ka Yesu zlghanaftá wani. ");
INSERT INTO xed_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ka Pilat mantsa: «Ksaf a iʼi ta skwi prək ka tsanaghata ɗa ta guma ta na mndu na wu,» kaʼa nda tsa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda ya nda tsa dəmga ya. ");
INSERT INTO xed_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","«Ta hwazlaɓa mndu na mndu na nda skwi ta taghə tsi. Wa a zlrafta tsi ta haɗika Galili, ka raganaptá inda haɗika Zudiya, ha ka sagha da hadna,» ka həŋ ndiʼata ka mnay. ");
INSERT INTO xed_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","«La Galili na mndu na ra?» Ka Pilat ɗawaŋta snər tsi ta kulaŋtá Galili. ");
INSERT INTO xed_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Snaŋta Pilat kazlay: Sliʼaf ma luwa ta gə Hiridus ta mgham na Yesu kəʼa, ka vriŋtá tsi ta Yesu da mgham Hiridus, kabga ma luwa Ursalima Hiridus ma tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Manda vradanaghatá, ka rfu Hiridus ta rfu nghər tsi ta Yesu, kabga nda kɗa fitika zbayni ta nghaŋta, ta ghəŋa skwiha ta snə tsi ta mnay tida. Dzaʼa nghaŋngha yu ta maga sana mazəmzəm suʼu na, kaʼa sizlay. ");
INSERT INTO xed_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ka va ɗaɗawu tsi ta skwiha kavghakavgha da Yesu. Sew haɗ sana skwi zlghanaf tsi ta wani wa. ");
INSERT INTO xed_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hada la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda gwal tagha zlahu ŋa mnduha. Ka va ŋavatá həŋ ka vaza rutsak tida. ");
INSERT INTO xed_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mbaɗa i Hiridus nda sludzihani ka dulay, ka gagay. Ka suɗanavatá həŋ ta lgut káka nda ɗinakwani, ka vriŋta da Pilat ta nzakway ka ŋumna. ");
INSERT INTO xed_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Daga baɗu tsa, ksatá gra i Pilat nda Hiridus tsa kabga si manda la ghuma nzakwa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Manda tskanata Pilat ta la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda gwal tsa guma nda dəmga tani, kaʼa nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","«“Wana na mndu na ta hwazlaɓa mnduha,” ka kuni klakta da iʼi, ka ɗawaŋtá yu da tsi ta kəma ghuni, haɗ skwi dər turtuk mataba tsa skwiha ta mnə kaghuni tida ya ksaf yu da tsi wa. ");
INSERT INTO xed_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ksaf a Hiridus guli ta sana skwi da tsi wu, kəl tsi ka vraganaghata da amu. Wana guli haɗ sana skwi maga na mndu na ta nzakway prək ka dzata wa. ");
INSERT INTO xed_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wana yu dzaʼa sləvapta nda krupi ŋa zliŋta ɗa,» kaʼa.  ");
INSERT INTO xed_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tsaw inda skala Pak ya ná, ta zliniszla tkweʼ ta vuʼa turtuk ma gamak ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka həŋ mantsa: «Dzadza ta na mndu na ka zliŋnista ka ta Barabas,» ka həŋ hlaftá wi demdem ka skwa turtuk. ");
INSERT INTO xed_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tsaw tsa Barabas ya, tsamtsa lu ma gamak kabga vəl dzatá mndu ma sliʼavafta hwazlaɓaku nda ŋumna. ");
INSERT INTO xed_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta kumay Pilat má ta zliŋtá Yesu, ka gwaɗgəlganatá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka həŋ mantsa: «Zləŋafzləŋa ta udzu! Zləŋafzləŋa ta udzu!» ka həŋ hlaftawi. ");
INSERT INTO xed_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka Pilat nda həŋ ka mahkən mantsa: «Nu va na ghwaɗaka skwi na maga tsi na? Ya wana slanagha a iʼi ta dmaku maga tsi prək ka dzata wa. Ala, wana yu dzaʼa slvapta nda krupi, ŋa zliŋta ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","«Zləŋaftá Yesu ta udzu,» ka həŋ va sganaghatá hlawi. Ka ŋraptá tsa hlawa taŋ ya ta Pilatus. ");
INSERT INTO xed_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ka maganatá Pilat ta həŋ ta tsa skwi kumaŋ həŋ ya. ");
INSERT INTO xed_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka zliŋtá tsi ta tsa mndu si tsam lu ma gamak ta ghəŋa vəl dzatá mndu ma hwazlaɓaku nda ŋumna, ta ɗawu həŋ ya. Ka vlaŋtá tsi ta həŋ ta Yesu manda ya kumaŋ həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ta klayklay həŋ ta Yesu ka guyatá həŋ nda Simuŋ mnda la Sireŋ ta vrakta ma vwah. Ka ŋanatá həŋ, ka fanaghatá tsa udza zləŋay ya ŋa klayni mista Yesu. ");
INSERT INTO xed_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ka sliʼi mnduha rutututa mistani, ta dzaʼa miʼaha nda taw ka ŋaɗa ghəŋ guli. ");
INSERT INTO xed_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka mbəɗavatá Yesu tvə tsa miʼaha ya, kaʼa nda həŋ mantsa: «Ma taw kuni ta iʼi kwagha Ursalima, tawawa tawa ta ghəŋa ghuni nda zwana ghuni. ");
INSERT INTO xed_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wya dzaʼa saghasa fitik dzaʼa kəl lu ka mnay kazlay: Rfu da gwal ka dzəghəŋ, kul tatá mndər, kul saŋtá zwaŋ ta uʼa taŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Zlagawazla ta ghəŋa aŋni,” ka mnduha dzaʼazlay nda ghwáha, “bukwaŋnawa bukwa,” ka həŋ dzaʼazlay nda kuɗuŋurha! ");
INSERT INTO xed_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ka si manda nana maganata lu ta udza mkwenek ya ní, kighkigh dzaʼa slanaghata tsi ta ghwalatá udzu?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mamu sanlaha ma ghwaɗaka mndu his guli ta hlu lu ŋa dzaʼa pslatá həŋ kawadaga nda Yesu. ");
INSERT INTO xed_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ɓhadaghata taŋ da tsa vli ta hgə lu ka «vla ghudzifa ghəŋ» ya, ka zləŋaftá həŋ hada, kawadaga nda tsa ghwaɗaka mnduha his ya kay. Pal sani nda ga zeghwani, pal sani nda ga zlaɓani. ");
INSERT INTO xed_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ka Yesu mantsa: «Da! planapla ta dmakwa taŋ, kabga sna a həŋ ta skwi ta magə həŋ wu,» kaʼa. Ka vzə həŋ ta vindima ŋa daguvustá lguthani. ");
INSERT INTO xed_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka nzatá mnduha hada ka nghay. «Mbambanaf a tsi ta sanlaha kay ra? Ka si Kristi zbatá ŋa Lazglafta tsi katək ya ní, ka mbanafmba tsi ta ghəŋani tama ɓa?» ka gwal dagaladagala ta ghəŋa la Yahuda ka ghuɓasa Yesu. ");
INSERT INTO xed_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka kladaghatá la sludzi guli ta imi masmasa ka vlay ŋani, ka ghuɓasu həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ka mghama la Yahuda ka katsi, mbanafmba ta ghəŋa gha, ka ghəŋa gha,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","«Nana na mghama la Yahuda,» ka lu vindafta skwi ka fagata nda ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","«Kristi a kagha kay ra? mbanafmba ta ghəŋa gha ka ghəŋa gha, ka mbaŋnafta ka,» ka sani ma tsa ghwaɗaka mnduha zlaŋaf lu ya, ka razay. ");
INSERT INTO xed_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka sani dvanaghata mantsa: «Wana kagha ta ghuyay ghuyay manda tsatsi, zləŋa a kagha ta Lazglafta ra? ");
INSERT INTO xed_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ŋa u ná, rakwani tsaʼuwaghatá guma, kabga nisəla slna u maga u ŋu u ta mutsafta. Tsatsi, haɗ skwi ga tsi wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kaʼa ta hula tsa guli mantsa: «Ka havapta ka ka iʼi baɗu saghar ka da ga mgham,» kaʼa nda Yesu. ");
INSERT INTO xed_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ka Yesu mantsa: «Kahwathwata ka yu ta mnaghata na, gita u na dzaʼa kawadaga ka nda iʼi ma luwa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ɗək fitik ma ghəŋ, ka haftá skwi ta wa ira fitik, ka nutá vli ka grum ta inda tsa haɗik ya, ha ka lagha ta fitik hawu. Ka tavaptá tsa zlala tamə lu ma həga Lazglafta ya tsəraʼ ma takataka. ");
INSERT INTO xed_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ka Yesu mantsa: «Da! Ma dzva gha ta vlaghata yu ta hafa ɗa,» kaʼa wahata nda lwi dagala. Tahula mnatani ta tsa gwaɗa ya, ka sabi hafu mida. ");
INSERT INTO xed_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","«Kahwathwata si ŋərma mndu na mndu na,» ka mghama sludzi la Ruma nghər tsi ta tsa skwi ta magata ya, ka zləzlvu tsi ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tahula nghaŋta taŋ ta tsa skwi ta magata ya, ka vraghutá inda tsa gwal si ta lagha nghay ya nda wuwuslika dzvu. ");
INSERT INTO xed_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka nzaktá inda graha Yesu, nda tsa miʼaha ta safi mistani daga ma Galili ya, ka ngha tsa skwi ta magaku ya. ");
INSERT INTO xed_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mamu sana ŋərma mndu tɗukwa nzakwani, ta hgə lu ka Yusufu. Mnda la Arimate ya, sana luwa ta nzakway ta haɗika la Yahuda. Ta kzlaykzlay tsatsi ta sagha fitika ga mghama Lazglafta. Tekw tsatsi mataba gwal dagaladagala ta vla hiɗaku. Tsuʼaf a tsatsi ta tsa skwi tsiŋ lu ta ghəŋani ma guma ŋa magay, ka magata lu ya wa. ");
INSERT INTO xed_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ka sliʼaftá tsa mndu ya ka lagha da Pilat ta nzakway ka ŋumna da ɗawaftá tvi ŋa dzaʼa kla mbla Yesu. ");
INSERT INTO xed_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ka laghu tsi klagatá mbla Yesu ta udza zləŋay, ka mbsamtá tsi ma wupay, ka laghu tsi famta ma kulu huhrap lu ma kluluh ta kul famtá lu ta mbli mida karaku. ");
INSERT INTO xed_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Baɗu luma madagala tsa fitik ya, ta ghwaŋ a lu ka lami da Sabat wa. ");
INSERT INTO xed_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka sliʼaftá tsa miʼaha si ta safi mista Yesu daga ma Galili ya mista Yusufu. Ka nghanatá həŋ ta vla tsa kulu ya, nda ya ka lu hananamtá Yesu mida. ");
INSERT INTO xed_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ka vraghatá həŋ da luwa. Ka payaftá həŋ ta rɗi nda urdi ŋa masay ta mbla Yesu. Ka nzaptá həŋ baɗu Sabat manda ya ta mnə zlahu. ");
INSERT INTO xed_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wrək tgha gasərɗək baɗu dəmas, ka klaftá tsa miʼaha ya ta tsa rɗi nda urdi payaf həŋ ya kay, ka sliʼafta ka laghwi ta kulu. ");
INSERT INTO xed_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kəʼa ká həŋ ná, taŋwalaghutaŋwala lu ta tsa klam kəl lu ka huŋta ya. ");
INSERT INTO xed_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka lami həŋ dida, ngha a həŋ ta mbla Mgham Yesu mida wa. ");
INSERT INTO xed_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Triɗ, traptra həŋ ta skwi ŋa ndanay. Gi ka zlagaptá duhwalha Lazglafta his ta kəma taŋ nda suɗatá lgut ta wuɗaku tilil ta vgha taŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka ksaftá zləŋ ta həŋ katakata, ka dzadzatá həŋ ta ghəŋa taŋ nda ta haɗik. Ka tsa duhwalha Lazglafta ya nda həŋ mantsa: «Ta zbə ŋaw kuni ta mndu ndiri mataba gwal nda rwa na? ");
INSERT INTO xed_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ta haɗ hadna wa, sliʼapsliʼa tsatsi nda hafu. Havakwahava ta skwi mnaghuna tsi ma fitika nzakwani ta ma Galili. ");
INSERT INTO xed_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kaʼa mnata na: “Nda nza tkweʼ ka klaftá Zwaŋa mndu ka fanamtá gwal dmaku ma dzvu, ŋa dzata ta udza zləŋay, ŋa sliʼagaptani nda hafu ma mtaku baɗu mahkəna fitik kəʼa ya.”» ");
INSERT INTO xed_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ka havaktá tsa miʼaha ya ta skwi ya si mnana Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sliʼafta taŋ ta kulu, ka laghu həŋ da rusanaftá inda tsa skwiha ya ta tsa duhwalha ghwaŋpɗə ndeŋ ya nda pɗakwa sanlaha. ");
INSERT INTO xed_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsa miʼaha ta mna tsa gwaɗa ya ŋa gwal ghunay ya ná, i Mari makwata Magdala, nda Yuwana, nda Mari mani ma Yakubu, nda sanlaha ma miʼaha ta dzaʼa mista taŋ ya həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ta nghə ka tsaɓaku həŋ ta tsa gwaɗa ya, zlghaf a həŋ ta gwaɗa tsa miʼaha ya wa. ");
INSERT INTO xed_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piyer ya tani, sliʼaftá tsatsi nda hwaya ka laghwi ta kulu, ka ɓukwadatá tsi, kəʼa kəʼa ná, wupay yeya nghaŋ tsi ŋufuk ta haɗik, ka vraghatá tsi dzaghani nda ndərmima tsa skwi ta magaku ya. ");
INSERT INTO xed_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Baɗu va tsa fitik ya, ka sliʼaftá sana duhwalha his, ka dzaʼa da sani luwa ta hgə lu ka Imayus. Ta magay meli ghwaŋpɗə ndeŋ matakataka taŋ nda luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ka dzaʼa həŋ nda ghwa yiva ta ghəŋa skwi ta maguta. ");
INSERT INTO xed_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tata dzaʼa nda ghwa yiva ta ghəŋa tsa skwi ta maguta ya həŋ, ka ksaftá Yesu ta həŋ ka mbaɗa kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ka hanaftá skwi ta iri ta həŋ, tsəmaf a həŋ wa. ");
INSERT INTO xed_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka Yesu mantsa: «Ta ghəŋa wu ta dzaʼa kuni nda ghwa yiva na?» kaʼa nda həŋ. Gagərdzək sladaslada həŋ, ka nzata sasgama. ");
INSERT INTO xed_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka sani mataba taŋ ta hgə lu ka Kliyupas nda tsi mantsa: «Si laghu diga kagha ta magaku skwi ma Ursalima ma na fitik na na?» kaʼa. Ka Yesu mantsa: «Nya ta magaku na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka həŋ nda tsi mantsa: «Sna a ka ta skwi ta maguta nda Yesu mnda la Nazaret ta nzakway ka anabi dagala, nda sgit ma gwaɗani, ta magata skwa mandərmimi ta kəma Lazglafta nda ya ta kəma inda mnduha, ");
INSERT INTO xed_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","klaf la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda gwal tsamatá guma, ka vlatá həŋ ŋa dzata, ka zləŋaftá həŋ ta udza zləŋay ra? ");
INSERT INTO xed_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tsatsi dzaʼa mbanaftá la Israʼila ka ŋani sizlay, kulam nda tsa, hkən gita manda luta tsa skwiha ya. ");
INSERT INTO xed_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aŋ mndani, ta ndərmimi nda ndərmima ŋni ta gwaɗa sana miʼaha mataba ŋni ta sliʼafta wrək tgha, ka laghu ta kulu. ");
INSERT INTO xed_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ta lagha həŋ, slanagha a həŋ ta mblani wu, ka vraktá həŋ da mnay: “Maravamara duhwalha Lazglafta ta wa ira ŋni, ka mnə həŋ ŋaŋni kazlay: Sliʼafsliʼa nda hafu kəʼa.” ");
INSERT INTO xed_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ka sliʼaftá sanlaha mataba ŋni guli ka laghu ta kulu, ka slanaghatá həŋ ta tsa skwi ya manda va tsa mnə tsa miʼaha ya. Tsatsi, ngha a həŋ wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka Yesu nda həŋ mantsa: «Mnduha kul haɗ mahizl ma ghəŋa taŋ, ta daramay nda darama ta zlgha inda skwi mna la anabi! ");
INSERT INTO xed_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nza a tkweʼ ka ghuyay Kristi ta tsa ɗaŋwaha ya makɗaku tsi ka lami da glakwani ra?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ka zlraftá Yesu ta rusa gwaɗa ta ghəŋani manda ya mna i Musa nda inda la anabi ma deftera Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ndusadaghata taŋ nda tsa luwa ta dzaʼa həŋ ya, mbaɗa Yesu ka kɗa mbaɗa manda mndu ta kuma dzaʼa da vla diʼiŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","«Nawanawa, nzanza kawadaga nda aŋni, nda hləma fitik, ndusa rviɗik,» ka həŋ nzafta tida, ka ŋanata, ka lamə tsi da həga ka nzata kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta zə tsi ta skwa zay kawadaga nda həŋ, ka klaftá tsi ta buradi, ka rfanaghatá Lazglafta, ka ɓlanaptá tsi, ka valaŋtá tsi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nziɗiɗ, tsalatsala ira taŋ ka tsəmaftá həŋ, gi lay nghəgla a həŋ tavata həŋ wa. ");
INSERT INTO xed_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","«Burburbur a ŋuɗufa u ma fitika mnayni ta gwaɗa ta rusu tsi ta skwi ma deftera Lazglafta ŋa u ta tvi kay ra?» ka həŋ mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tahula tsa, gi ka sliʼaftá həŋ ka vraghuta da Ursalima. Ɓhadaghata taŋ, ka slanaghatá həŋ ta tskata vgha tsa duhwalha ghwaŋpɗə ndeŋ ya, kawadaga nda gwal si ta dzaʼa mista taŋ, ");
INSERT INTO xed_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ta mnaymnay kazlay: Kahwathwata sliʼagapsliʼa Mgham Yesu nda hafu. Nda ngha Piyer kəʼa. ");
INSERT INTO xed_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ka rusu tsahaya guli ta skwi ta maguta ta tvi nda ya ka həŋ tsəmaftá Yesu, ma fitika ɓalanaptani ta buradi. ");
INSERT INTO xed_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tata rusa tsa gwaɗa ya həŋ, ka gi maravata vərɗaka Yesu mataba taŋ, kaʼa mantsa: «Ka vlaghunavla Lazglafta ta zɗaku» kaʼa ganaghatá zgu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka ksaftá tsi ta həŋ ka zləŋ, ka ghudzaku həŋ katakata, ba glamglam ya ka həŋ sizlay. ");
INSERT INTO xed_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka Yesu nda həŋ mantsa: «Nya ta ghudza kaghuni na? Nya ta kəl kuni ka dga ghəŋ? ");
INSERT INTO xed_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nghawangha ta dzvuha ɗa nda səlaha ɗa ɓa, va tsa iʼi yeya. Ksihawaksa, ka vitsiɗivata kuni. Haɗ sluʼuvgha nda ghudzif ma glamglam manda tsa ta ndanu kaghuni ta ghəŋa iʼi ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta mnə tsi ta tsaya ná, ta marə tsi ta dzvuhani nda səlahani ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ta graf a həŋ karaku wu, ta rfu həŋ katakata ka ndərmimay. Ka Yesu mantsa: «Mamu skwa zay da kaghuni hadna ra?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka vlaŋtá həŋ ta sulatá klipi kiʼa. ");
INSERT INTO xed_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ka zlghaftá tsi ka zay ta wa ira taŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kaʼa nda həŋ mantsa: «Wana na skwi si ta mnə yu ŋa ghuni ma fitika nzakwa ɗa kawadaga nda kaghuni kazlay: “Inda skwi ya vindaf lu ta ghəŋa iʼi ma deftera Musa nda ya ma deftera la anabi, nda ya ma Zabura ná, dzaʼa magaku kəʼa ya kay,”» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ka gunanaŋtá tsi ta mahizl ta həŋ ŋa snaŋtá skwi vindaf lu ma gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kaʼa nda həŋ guli mantsa: «Wya ka lu vindafta: Dzaʼa ghuyay Kristi ta ɗaŋwa, ŋa sliʼagaptani ma mtaku nda hafu baɗu mahkən. ");
INSERT INTO xed_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dzaʼa mnay lu tkweʼ nda hgani ŋa inda mndəra mnduha ka mbəɗanafta həŋ ta nzakwa taŋ, ŋa planata Lazglafta ta dmakwa taŋ. Tiŋəl ma luwa Ursalima dzaʼa zlrafta lu ta mnay. ");
INSERT INTO xed_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kaghuni ta nzakway ka masləmtsəka tsa skwiha ya kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wya yu dzaʼa ghungaghunatá tsa skwi taghunaf Da ɗa ta imi ta sləməŋ ya. Kaghuni, ka nzata kuni ma huɗa luwa ha ka saha mbraku daga ta luwa da mbraghunafta,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ka hlaftá Yesu ta həŋ ma huɗa luwa, ka laghu həŋ nda tvə luwa Betani. Ɓhadaghata taŋ da hada, ka kapaftá tsi ta dzvu ka tfanaghatawi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tata tfaytfay ta wi ta ghəŋa taŋ, ka dgaghutá tsi ta vgha nda həŋ, ka klaghatá lu ta luwa. ");
INSERT INTO xed_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hahəŋ, manda kɗakwa taŋ ta tsəlɓanatá tsəlɓu, ka vraghatá həŋ da Ursalima nda rfu katakata. ");
INSERT INTO xed_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ka gɗatá həŋ ta lagha da nzaku ma həga Lazglafta ka zləzlvay.");
INSERT INTO xed_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Daga taŋtaŋ mamu gwaɗa. Kawadaga tsa gwaɗa ya nda Lazglafta. Tsa gwaɗa ya ta nzakway ka Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Daga taŋtaŋ, kawadaga tsa gwaɗa ya nda Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nda tsatsi magafta Lazglafta ta inda skwiha. Haɗ skwi magaf Lazglafta kul haɗ tsatsi wa. ");
INSERT INTO xed_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma tsatsi zlrafta hafu. Tsa hafu ya ta nzakway ka tsuwaɗaka mnduha. ");
INSERT INTO xed_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsa tsuwaɗak ya ta tsuwaɗakaku ma grusl, walaŋ a grusl ta ksafta ɗekɗek wa. ");
INSERT INTO xed_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ka zlagaptá sana mndu ta hgə lu ka Yuhwana ghunaf Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ka sagha tsi ŋa nzaku ka masləmtsəka tsuwaɗak, kada zlghafta inda mnduha nda ma tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tsatsi a tsa tsuwaɗak ya wu, zlagap ŋa ga masləmtsəka tsuwaɗak tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tsa tsuwaɗak ya ná, vərɗa tsuwaɗak ya. Ma saghani ta ghəŋa haɗik ka tsuwaɗak tsi ta mnda səla. ");
INSERT INTO xed_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tsaw tsa gwaɗa ya ná, nda ghada nzakwani ma ghəŋa haɗik, kabga nda tsatsi magafta lu ta ghəŋa haɗik. Nziya nza tsi tsatsaf a mnduha wa. ");
INSERT INTO xed_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Saghani da mnduha, ka kwalaghuta mnduha ta tsuʼafta. ");
INSERT INTO xed_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lagha gwal ta tsuʼafta, ka zlghaftá hgani. Ŋa tsahaya, ka vlaŋtá tsi ta həŋ ta mbrakwa nzaku ka zwana Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nza a həŋ ka zwanani manda ya ta yagata mnda səla, manda ya ta kumə mndu a wu, ama sagha da Lazglafta manda ya ta kumə tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tsa gwaɗa mnə lu ya kay ná, ka mbəɗavaftá tsi ka mndu, ka nzata mataba mu. Nda ndəgha nda zɗakatahuɗi, nda kahwathwata. Nda ngha mu ta glakwani, glakwa zwaŋ turtuktuk ghunaf Da ya. Zɗakatahuɗani nda kahwathwatani katakata ya. ");
INSERT INTO xed_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ka gwaɗatá Yuhwana ta nzakway ka masləmtsəkani baŋluwa. «Wana tsa mndu mnə yu kazlay: Tsa mndu ta sagha nda hula ɗa ya ná, malaghumala ta iʼi, kabga mamu tsatsi ma kɗaku lu ka yatá iʼi kəʼa ya kay.» ");
INSERT INTO xed_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dagala zɗakatahuɗani katakata, tfamaghatfa ta wi demdem, ta gɗagɗa ta vlamatá zɗakatahuɗani. ");
INSERT INTO xed_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nda ma dzva Musa vlata Lazglafta ta zlahu, ka sagha zɗakatahuɗi nda kahwathwata nda da Yesu Kristi. ");
INSERT INTO xed_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Haɗ mndu ta kɗə walaŋtá nghaŋtá Lazglafta wa. Tsa zwaŋ turtuktuk ya ta nzakway ka Lazglafta, ta nzaku ma ghuva Da ya, tsatsi ta mnaŋtá nzakwa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wya gwaɗa mna Yuhwana ma ghunadaghata gwal dagaladagala ma la Yahuda ma Ursalima ta gwal dra skwi ŋa Lazglafta, nda la Levi. Ka lagha həŋ da ɗawaŋta da tsi: «Wa kagha na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ka mnatá Yuhwana ta kahwathwata, manana a ta həŋ wa. «Kristi a iʼi wu,» kaʼa klinistá ghəŋani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","«Tsa wa kagha ɓa? Iliya ka rki?» ka həŋ nda tsi. «Vani a iʼi wu,» ka Yuhwana nda həŋ. «Anabi ka rki?» «Vani a iʼi wa.» ");
INSERT INTO xed_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","«Wa kagha ka ŋni dzaʼazlay nda gwal ta ghunagaŋnaghata ɓa? Wa iʼi ka va kagha na?» ka həŋ nda tsi kay guli. ");
INSERT INTO xed_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","«Iʼi ná, “lwi ta guguɗaku ma mtak yu, leleʼanawa tvi ŋa mgham”» kaʼa nda həŋ, manda ya mnə anabi Isaya. ");
INSERT INTO xed_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mataba tsa mnduha ghunadap lu da Yuhwana ya, mamu la Farisa. ");
INSERT INTO xed_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ka ɗawglaŋtá həŋ da Yuhwana, «Wana Kristi a iʼi wu ka ka, ta Iliya a yu wu ka ka, anabi a yu wu ka ka guli, ŋaw ta maga ka ta batem ɓa?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","«Iʼi ná, nda imi ta magə yu ta batem. Mamu sana mndu mataba ghuni kul snaŋtá kuni. Tsatsi ta sagha nda hula ɗa. ");
INSERT INTO xed_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ra a yu ka plaptá zuʼa ɓaɓahani wu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma Betani maguta tsa skwiha ya, ta ɓla ghwa Zurdeŋ, ma vla magay Yuhwana ta batem. ");
INSERT INTO xed_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gamahtsimani ka nghə Yuhwana ta Yesu ta sagha da tsi. «Wana zwaŋa tuwaka Lazglafta ta klaghutá dmakwa mnduha. ");
INSERT INTO xed_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tsatsi tsa mndu mnə yu kazlay: Mamu sana mndu ta sagha nda hula ɗa ta malaghutá iʼi, mamu tsatsi ma kɗə lu ka yatá iʼi kəʼa ya kay. ");
INSERT INTO xed_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Iʼi guli ná, si sna a yu kazlay: Tsatsi ya kəʼa wa. Nana saghasagha yu da maga batem ma imi na ná, ŋa snanamtá la Israʼila nzakwani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ka Yuhwana guli mantsa: «Nda ngha yu ta Sulkum ta saha daga ta luwa manda ghərbuʼ, ka nzafta tida. ");
INSERT INTO xed_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Si sna a yu kazlay: Tsatsi ya kəʼa wu, ka mnihatá Lazglafta ta ghunaftá iʼi ŋa maga batem ma imi ya kazlay: Tsa mndu dzaʼa nghaŋta ka ta saha Sulkum ka nzafta tida ya, tsatsi ta dzaʼa maga batem nda Sulkum nda ghuɓa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ka nghaŋtá yu manda va tsaya. Nana mndu na ná, Zwaŋa Lazglafta ya, ka yu ta ghəŋani.» ");
INSERT INTO xed_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Gamahtsimani, ka vradaghata Yuhwana kawadaga nda gwal his mataba duhwalhani da va tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nghayni ta Yesu ta labə mantsa: «Wa a zwaŋa tuwaka Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Snaŋta tsa duhwalha his ya ta tsa gwaɗa Yuhwana ya, ka laghu həŋ mista Yesu. ");
INSERT INTO xed_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kəʼa ka Yesu mbəɗavata, ta nghə tsi ná, ta dzaʼa mistani həŋ. «Nu ta zbə kuni ɓa?» kaʼa nda həŋ. «Maləma ɗa! Ga ta nzakwa ka na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","«Saghawasa ka nghanata kuni ɓa!» kaʼa nda həŋ. Ka laghu həŋ mistani, ka nghanatá həŋ ta vla nzakwani. Ta fitik hawu ta nzemndi fwaɗ vli nda tsa. Ka kɗiŋtá həŋ ta vaghay kawadaga nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mataba tsa mnduha his ta snaŋtá gwaɗa Yuhwana ka laghu mista Yesu ya ná, tekw Andre ta nzakway ka zwaŋamani ma Simuŋ Piyer. ");
INSERT INTO xed_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tiŋəl ŋa zwaŋamani Simuŋ sliʼafta tsi ka laghwi da mnay. Kaʼa mantsa: «Slafsla ŋni ta Almasihu,» kaʼa. Tsaya ta nzakway ka «Kristi.» ");
INSERT INTO xed_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ka kladaghatá tsi da Yesu, na ghur nghaŋta Yesu, kaʼa nda tsi mantsa: «Simuŋ! Zwaŋa Yuhwana ka, Kefas dzaʼa hga lu ta kagha,» manda mnay kazlay: Pala kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gamahtsimani, dzaʼa da Galili yu, ka Yesu. Ka guyatá tsi nda Filip, «mbaɗa mista ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Tsa Filip ya ná, mnda luwa Betsayda luwa i Andre nda Piyer ya. ");
INSERT INTO xed_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tahula tsa, ka guyatá Filip nda Natanayel guli. «Slanaghasla ŋni ta tsa mndu vindaf Musa ta gwaɗa ta ghəŋani ma deftera zlahu nda ya ta mnə la anabi ta gwaɗa ta ghəŋani ya kay. Yesu zwaŋa Yusufu mnda la Nazaret ya,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","«Mndərga wati skwi ya ɗina dzaʼa sabi ma luwa Nazaret na?» ka Natanayel nda tsi. «Sawi ka nghanata ka ɓa!» ka Filip. Ka sliʼaftá tsi ka lagha. ");
INSERT INTO xed_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nghay Yesu ta laghani, «wana vərɗa mnda la Israʼila kul haɗ sana skwi ŋa tsanavata,» ka Yesu nda Natanayel. ");
INSERT INTO xed_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","«Ga snaŋta ka ta iʼi na?» ka Natanayel nda tsi. «Aʼa! Ngha a yu ta kagha ta nzaku mista ghuraf ma kɗə Filip ka hga kagha ya ra!» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","«Maləma ɗa! Kagha ná, Zwaŋa Lazglafta ka, mghama la Israʼila ka,» ka Natanayel nda Yesu. ");
INSERT INTO xed_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","«Zlray kagha ta zlghay tsa ɓa, kabga mnay ɗa kazlay: Nda ngha yu ta kagha mista ghuraf kəʼa? dzaʼa nda ngha ka ta skwiha ta malaghutá tsaya,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ka Yesu sganaghata mantsa: «Kahwathwata ka yu ta mnaghunata, dzaʼa nda ngha kuni ta gunatá luwa buwaŋ ŋa ŋla duhwalha Lazglafta, ŋa saha taŋ ta ghəŋa Zwaŋa mndu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ta mahkəna fitik, ka slatá skala kla makwa ma luwa Kana ta haɗika Galili. Tsaw laghala mani ma Yesu da tsa vla skala kla makwa ya. ");
INSERT INTO xed_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Hgadagha hga lu ta i Yesu nda duhwalhani guli da tsa vla skala kla makwa ya. ");
INSERT INTO xed_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ka kɗutá ima inabi. Ka mani nda Yesu mantsa: «Nda kɗa ima inabi da həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","«Nahgani ŋa gha nda iʼi katək ní a ma! Ta maga a fitika ɗa wu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","«Ka maga kuni ta inda skwi dzaʼa mnaghunata tsi,» ka mani ma Yesu nda kwalvaha. ");
INSERT INTO xed_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tsaw ma tsa vli ya, mamu wudaha tsatsaf lu nda palaha ta za litir tghas mbsak tghas mbsak sanlaha, dərmək nda hisambsak hisambsak sanlaha, ta kəl la Yahuda ka ghuɓa səlaha taŋ. ");
INSERT INTO xed_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","«Ndaghanafwa ndagha ta ya wudaha ya nda imi,» ka Yesu nda həŋ. Ka ndaghanaftá həŋ teʼteʼ. ");
INSERT INTO xed_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","«Ndana tama, taŋwatá ta mndu ta wa skwa zay,» ka Yesu nda həŋ, ka taŋtá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tapanata tsa mndu ta wa skwa zay ya ta tsa imi mbəɗanaf lu ka ima inabi ya ná, zɗakwa skwi a va tsa wu, sna a guli ka sagha ga tsa ima inabi ya wa. Taghəŋa tsa gwal ta zakamtá tsa imi yeya nda sna. Ka hgaŋtá tsi ta zəʼala makwa. ");
INSERT INTO xed_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Kaʼa nda tsi mantsa: «Tiŋəl ima inabi ya zɗa ta dgə lu ŋa mnduha, kada vla ya leghlegha tahula baghuta taŋ ná, ka laghwa kagha ɗifanatá ya zɗa, ka zlra klagapta ndana?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tsaya taŋtaŋa mazəmzəm maga Yesu ma luwa Kana ta haɗika Galili. Mantsa ya maraŋta tsi ta glakwani. Ka faftá duhwalhani ta ghəŋ tida. ");
INSERT INTO xed_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tahula tsa, ka sliʼaftá tsi ka lagha da luwa Kafarnahum kawadaga nda i mani nda zwanamani, nda duhwalhani tani, ka zatá həŋ ta fitik tsəɓakw hada. ");
INSERT INTO xed_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ndusagaghata fitika skalay la Yahuda ta Pak, ka lafi Yesu da Ursalima. ");
INSERT INTO xed_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɓhadaghatani, ka lamə tsi da daɓa həga Lazglafta ka slanaghatá tsi ta mnduha ta dzawa slaha nda tuwakha, nda ghərbuʼha, nda gwal mbaɗa tsedi ta nzaku tavata tabəla taŋ hada. ");
INSERT INTO xed_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ka klaftá tsi ta tɓaŋ ŋa krupi, ka ghzlagaptá tsi ta mnduha demdem ma tsa daɓa həga Lazglafta ya, nda tuwakha tani, nda slaha tani. Ka wutsidiŋtá tsi ta tseda gwal mbəɗu, ka zlambidiŋtá tabəla taŋ. ");
INSERT INTO xed_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","«Hliŋwa na skwiha na hadna, ma niŋ kuni ta həga Da ɗa ka həga mbəɗa dzvu,» kaʼa nda gwal dzawa ghərbuʼha. ");
INSERT INTO xed_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka havaktá duhwalhani ta skwi ya nda vinda ma gwaɗa Lazglafta tazlay: «Ɗvafɗva yu ta həga gha, manda vu ta dra tsi ta iʼi,» kaʼa ya ");
INSERT INTO xed_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","«Mndərga wati ma mazəmzəm dzaʼa ka magata, ŋa maraŋtá skwi kəl ka ka maga mndəra skwi mandana na?» ka la Yahuda zlraftá gwaɗa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","«Tasiŋwatasa ta na həga Lazglafta na, dzaʼa bəglafba yu ma fitik hkən,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","«Ta skwi vaku fwaɗ mbsak mkuʼ mida za lu ta ba na həga Lazglafta na ná, ma fitik hkən dzaʼa bafta yu ri wa kəʼa?» ka la Yahuda nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tsaw tsa həga ta gwaɗə Yesu ya ná, ta gwaɗə ta ghəŋa ghəŋani tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tsaya kəl duhwalhani tahula sliʼagaptani ma mtaku, ka havaktá skwi ya mna tsi. Ka zlghaftá həŋ ta skwi ya nda vinda ma gwaɗa Lazglafta, nda gwaɗa Yesu ta mnata tani. ");
INSERT INTO xed_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma fitika nzakwa Yesu ma Ursalima ta skala Pak, nda ndəgha gwal ta zlghafta nghər həŋ ta mazəmzəmha ta magə tsi. ");
INSERT INTO xed_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lamə a tsaya da fəlma Yesu wu, kabga nda sna ta həŋ tsiɗiɗ. ");
INSERT INTO xed_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Psa a ta mnanata mndu ta gwaɗa ta ghəŋa nzakwa sana mndu wu, kabga nda sna tsatsi ta skwi ma ŋuɗufa mndu. ");
INSERT INTO xed_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mamu sana mndu mataba la Farisa ta hgə lu ka Nikwademu tekw mataba gwal dagaladagala mataba la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka sliʼaftá tsi nda rviɗik ka lagha slanaghatá Yesu. Kaʼa nda tsi mantsa: «Maləma ɗa! Nda sna ŋni kazlay: Mnda tagha skwi ta saha daga da Lazglafta kagha kəʼa, kabga haɗ mndu ta laviŋtá maga tsa mazəmzəmha ta magə kagha ya, ka haɗ Lazglafta kawadaga nda tsi wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","«Kahwathwata ka yu ta mnaghata, ka ya a lu ta mndu ka mahis wu katsi, laviŋ a ta nghaŋtá ga mghama Lazglafta wu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","«Waka lu dzaʼa yəglagatá mndu nda ghada halatani, dzaʼa vrəgladaf vra da huɗa mani, ŋa yəglagata ra?» ka Nikwademu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka Yesu mantsa: «Kahwathwata ka yu ta mnaghata, ka ya a lu ta mndu nda imi nda Sulkum wu katsi, laviŋ a ta walaŋtá lami da ga mghama Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ya yaga mndu ná, mnda səla tsaya. Ya yaga Sulkum ya ná, ŋa Sulkum tsa ya. ");
INSERT INTO xed_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma ndərmim ka nda ndərmima kabga mnaghata ɗa: “Tkweʼ ka yagatá kaghuni ka mahis” kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nda ta tvi ta kumə tsi ta vyakwa falak. Ta snay ka ta ghudzagani, sna a ka ka ga sliʼafta tsi wu, sna a ka ka ga ta dzaʼa tsi wa. Mantsa ya nzakwa inda mndu yaga lu ma Sulkum,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","«Waka skwi mantsa dzaʼa magaku?» ka Nikwademu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ka Yesu nda tsi mantsa: «Kagha mndu ta tagha skwi ŋa la Israʼila ná, sna a ka ta tsa ra? ");
INSERT INTO xed_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kahwathwata ka yu ta mnaghata, skwi snaŋ ŋni ta mnə ŋni, skwi nghaŋ ira ŋni ta gwaɗə ŋni, tsaw tsuʼa a kuni ta skwi ta mnə ŋni wa. ");
INSERT INTO xed_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gwaɗay ɗa ta skwi ta magaku ta haɗik ŋa ghuni, zlgha a kuni wu, waka kuni dzaʼa zlghaftá skwi ta magaku ta luwa dzaʼa mnaghunata yu tama? ");
INSERT INTO xed_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Haɗ mndu ta kɗə lafi ta luwa, ka mndu ta saha daga ta luwa a tsi wa. Ba Zwaŋa mndu yeya ta saha daga ta luwa. ");
INSERT INTO xed_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Manda va ya kapadaf Musa ta nahaɗika ghuvatili ta udzu ma mtak ya, manda va tsaya dzaʼa kapadafta lu ta Zwaŋa mndu, ");
INSERT INTO xed_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kada mutsafta dər wa ta zlghaftá hafu ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Ɗvuɗva Lazglafta ta ghəŋa haɗik, kəl tsi ka vlatá Zwaŋani turtuktuk, dər wa ta zlghafta, zwaɗuta a wu, mutsafmutsa ta hafu ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ghunaga a Lazglafta ta zwaŋani ŋa tsanaghatá guma ta mnduha ta ghəŋa haɗik wu, ama ŋa mutsafta mnduha ma ghəŋa haɗik ta mbaku nda ma tsatsi, kəl Lazglafta ka ghunagatá Zwaŋani ta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mndu ta zlghaftá Zwaŋa Lazglafta, haɗ guma ta ghəŋani wa. Mndu kul zlghafta, nda ghada tsatá guma ta ghəŋani, kabga kwalani kul zlghaftá Zwaŋa Lazglafta turtuktuk. ");
INSERT INTO xed_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«Wya ghəŋa tsa guma ya: Ma saha tsuwaɗak ta ghəŋa haɗik, ka zlanavatá mndu ta tsuwaɗak ka laghwi ɗvatá grusl, kabga slnaha taŋ kul ɗinaku. ");
INSERT INTO xed_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inda mndu ta maga ghwaɗaka skwi, husaŋhusa tsuwaɗak. Haɗ tsa mndu ya dzaʼa walaŋta sagha da tsuwaɗak wu da maravata slnani duway ta daɓi. ");
INSERT INTO xed_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ka ŋərmani nzakwa mndu kahwathwata katsi ná, dzaʼa saghasa da tsuwaɗak kada nghavata inda slnani ta magə tsi tsiɗiɗ kazlay: Skwi ta magə tsi, zɗəganazɗa ta Lazglafta kəʼa.» ");
INSERT INTO xed_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tahula tsa, ka sliʼaftá Yesu kawadaga nda duhwalhani ka laghwi ta haɗika Zudiya. Ka nzɗavatá tsi tsəɓakw fitik kawadaga nda həŋ hada. Ka magə tsi ta batem ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta magə Yuhwana ta batem guli ŋa mnduha ma sana vli ta hgə lu ka Inuŋ, ndusa nda sani vli ta hgə lu ka Salima, kabga dagala imi hada. Ka va sliʼadaghatá mnduha ŋa maganaftá batem ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma tsa fitik ya, ta la a lu ksaghatá Yuhwana da gamak karaku wa. ");
INSERT INTO xed_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ka sliʼanaftá duhwalha Yuhwana ta zlərɗutawi nda sana mnda la Yahuda ta ghəŋa gwaɗa ta ghuɓa səla. ");
INSERT INTO xed_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ka sliʼaftá həŋ ka lagha da mnay ŋa Yuhwana kazlay: Maləma ɗa! Tsa mndu si kawadaga nda kagha ta ɓla ghwa Zurdeŋ si ta mnə ka ta gwaɗa ta ghəŋani ya kay ná, waʼa ta maga batem ŋa mnduha. Ta sliʼi inda mnduha da tsi, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka Yuhwana mantsa: «Haɗ mndu dzaʼa mutsaftá sana skwi ka Lazglafta a ta vlaŋta wa. ");
INSERT INTO xed_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nda sna kaghuni nda sləməŋa ghuni ta mnə yu tazlay “Kristi a iʼi wu” kəʼa. Ghuniɗik ghuna lu ma kɗaku tsatsi ka sagha. ");
INSERT INTO xed_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ŋa zwaŋa midzi ta kla lu ta makwa, gra zwaŋa midzi ya guli ná, tavatani ta nzata tsi ka sna lwa gwaɗa ta gwaɗagapta zwaŋa midzi. Snaŋtani ta gwaɗa ta gwaɗagapta tsi ya, rfayni ta rfu. Manda tsaya ta rfa iʼi ta rfu guli. Ndanana ná, rfu ŋa ɗa ta rfay. ");
INSERT INTO xed_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ka ŋla tsatsi nda ŋla, ka htakwa iʼi nda hta. ");
INSERT INTO xed_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Mndu ya ta saha daga ta luwa ná, nzanaghanza tsatsi ta ghəŋa inda skwi demdem. Mndu ya ta ghəŋa haɗik guli ná, ŋa ghəŋa haɗik tsatsi. Gwaɗa ta ghəŋa skwi ta ghəŋa haɗik ŋani ta gwaɗay. Mndu ta saha daga ta luwa ná, ta ghəŋa inda skwi nzanaghata tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Gwaɗa ta ghəŋa skwi nghaŋ tsi nda ya snaŋ tsi ta gwaɗə tsi. Haɗ mndu ta tsuʼaftá gwaɗani wa. ");
INSERT INTO xed_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mndu ta tsuʼaftá gwaɗani ná, grafgra tsa mndu ya ta Lazglafta kazlay: Kahwathwata ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mndu ghunaga Lazglafta ná, gwaɗa Lazglafta ta gwaɗə tsi, kabga zwakuzwakwa Sulkum vlaŋ Lazglafta mida. ");
INSERT INTO xed_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","«Ɗvuɗva Da ta Zwaŋ, ka fanamtá tsi ta inda skwi ma dzvani. ");
INSERT INTO xed_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mndu ta zlghaftá tsa Zwaŋ ya mutsafmutsa ta hafu. Mndu ta kwalaghutá zlghaftá tsa zwaŋ ya mutsafta a ta tsa hafu ya wa. Ta ghəŋa ɓasa ŋuɗufa Lazglafta yeya ta nzaku ta ghəŋani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ka snaŋtá la Farisa ta mnay kazlay: Mal mnduha ta sliʼi da maga batem da Yesu ka ya da Yuhwana kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ka kahwathwatani ka lu mnay katsi ná, Yesu a ta maga batem ŋa mndu wu, duhwalhani zlanaŋ tsi ta magay. Snaŋta Yesu ta tsa gwaɗa ta mnə lu ya, ");
INSERT INTO xed_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ka sliʼaftá tsi ta haɗika Zudiya ŋa vrə ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wya nda ma haɗika Samari ta laba tsi ya, ");
INSERT INTO xed_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ka ɓhadaghatá tsi da sana vli ta hgə lu ka Sikar ndusa nda vwaha Yakubu ta vlaŋtá zwaŋani Yusufu bamma, ta haɗika Samari. ");
INSERT INTO xed_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma tsa vli ya, mamu vəvrəma Yakubu. Manda hərfatá Yesu ta mbaɗa, ka nzatá tsi ta wa tsa vəvrəm ya, wər ma ghəŋ fitik nda tsa. ");
INSERT INTO xed_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ka lagha sana markwa la Samari da ta imi. «Tiɗifta ta imi ka saʼata yu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ma tsa fitik ya, laghula duhwalhani da luwa da skwa skwa zay. ");
INSERT INTO xed_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","«Waka kagha ta nzakway ka mnda la Yahuda, ta ɗawa imi ŋa say da iʼi ta nzakway ka markwa la Samari na?» ka tsa marakw ya nda tsi. Tsaw haɗ la Yahuda ta guya vgha nda la Samari wa. ");
INSERT INTO xed_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka Yesu mantsa: «Ka má nda sna ka ta skwi ta kumə Lazglafta ta vlaghata, nda mndu ya ta ɗawa imi ŋa say da kagha katsi ná, má kagha má dzaʼa ɗawa imi ŋa say, má ŋa vlaghatani ta imi ta vla hafu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ka tsa marakw ya nda tsi mantsa: «Mghama ɗa! wana haɗ skwi ŋa tagafta da kagha wu, nda la na vəvrəm na guli, ga dzaʼa mutsa ka ta tsa imi ta vla hafu ya na? ");
INSERT INTO xed_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mal kagha ka dzidza ŋni Yakubu si ta sa ima na vəvrəm na nda zwanani, nda rinani tani, ka zlaŋnaŋtá tsi na ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Yesu nda tsi Mantsa: «Dər wati ma mndu ta sa na imi na ná, ta dzaʼa kuzlaŋkuzla ndala, ");
INSERT INTO xed_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama mndu dzaʼa sa na imi dzaʼa vlaŋta yu na ná, walglaŋta a ndala ta kuzlaŋta wa. Tsa imi dzaʼa vlaŋta yu ya ná, dzaʼa nuna ka dzuɓay, ŋa mbəzagapta hafu ŋa kɗekedzeŋ mida,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","«Mghama ɗa! Vlihavla ta tsa imi ya tsa, kada kwala ndala ta kuzliglihata, ka kwala yu ta səglagha da ta imi hadna,» ka tsa marakw ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","«La hgaktá zəʼala ghuni, ka sagha kuni da hadna,» ka Yesu nda tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","«Haɗ zəʼala ɗa wu,» ka tsa marakw ya nda tsi. Ka Yesu nda tsi mantsa: «Ta ŋa gha ta mnay kazlay: Haɗu zəʼala ɗa wu kəʼa, ");
INSERT INTO xed_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kabga hutaf zəʼala gha. Nana ga taŋ ka ndanana guli, zəʼala ghuni a wu, raghatani mnay gha mantsa ya,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","«Mghama ɗa! Anabi ka ta grə yu nda na skwi na. ");
INSERT INTO xed_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dzidzíha ŋni la Samari ná, ta na ghwá na si ta maga həŋ ta duʼa ŋa Lazglafta. Ka kaghuni la Yahuda ná, ma Ursalima vla maga duʼa ŋa Lazglafta, ka kaghuni,» ka tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka Yesu nda tsi mantsa: «Marakw na, zlghafzlgha ta iʼi. Dzaʼa saghasa fitik dzaʼa kwal kuni maga duʼa ŋa Da ta na ghwá na, dər ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kaghuni la Samari, ŋa skwi kul snaŋtá kuni ta maga kuni ta duʼa. Aŋni la Yahuda, ŋa skwi snaŋ ŋni ta maga ŋni ta duʼa, kabga da la Yahuda sagha mbaku. ");
INSERT INTO xed_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dzaʼa saghasa fitik, nda maga vani ndanana. Ma Sulkum nda ya ma kahwathwata dzaʼa kəl mnduha ka maga duʼa, ŋa tsəɓay taŋ ta tsəlɓu ŋa Da, kabga mndərga tsa mnduha ta tsəɓa tsa tsəlɓu ya ta zbə Da. ");
INSERT INTO xed_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Lazglafta ná, Sulkum ya. Tsa mnduha ta maga duʼa ŋani ya, ma Sulkum nda ya ma kahwathwata ta maga həŋ,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","«Nda sna yu kazlay: Dzaʼa saghasa Almasihu, ta hgə lu ka Kristi ya, kəʼa. Ka saghasa tsi, dzaʼa mnaŋnamna ta inda skwi,» ka tsa marakw ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","«Tsa mndu ta mnə kagha ya na iʼi ta gwaɗa nda kagha na,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tata gwaɗa həŋ, ka vraktá duhwalhani. Ka ndərmimi duhwalhani ta tsa nzatani ka gwaɗa nda tsa marakw ya. Tsitsiriɗ, nzanza həŋ, haɗ ya ta pslanaftawi, ka ɗawaŋta da tsi kazlay: Nu ta ɗaw ka da tsi, ari nu ta gwaɗə ka nda tsi na kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ka gi zlanatá tsa marakw ya ta bzleghwani hada ka laghwi da luwa da mnay ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Kaʼa mantsa: «Sawa ngha mndu ta mnihatá inda skwiha maga yu ɓa, zlah Kristi na mndu na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ka sliʼagaptá mnduha ma luwa, ka lagha slanaghatá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","«Maləma ɗa! Kwa za ta skwa zay misimmisim,» ka duhwalhani nda Yesu, ma tsa fitik ya. ");
INSERT INTO xed_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","«Mamu skwa zaya ɗa kul snaŋtá kaghuni,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","«Mamu mndu ta klanaktá skwa zay ra?» ka duhwalhani mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka Yesu nda həŋ mantsa: «Maga skwi ta zɗəganatá mndu ya ta ghunigihata ka kɗinistá slnani, skwa zaya ɗa. ");
INSERT INTO xed_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ta fwaɗ pɗakwa tili ka tska nimaya ta vwah” a ka kaghuni ndanana wu ra? ka iʼi nda kaghuni wa, nghadapwangha ta ndəhatá nimaya ta vwah ɓa, ta ghwaŋ a lu ka tskay wa. ");
INSERT INTO xed_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mndu ta tska nimaya ta vwah ná, ta mutsay ta nisəlani, ŋa tskanatani ta hulfani ŋa hafu ŋa kɗekedzeŋ. Mantsa ya, ŋa rfay mndu ta sləgafta nda mndu ta tskata ta rfu kawadaga. ");
INSERT INTO xed_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsa mahdihdi mnə lu kazlay: Slgadatá slgayslgay ŋa sani, tskatá tskaytskay ŋa sani kəʼa ya ná, kahwathwata nzakwani. ");
INSERT INTO xed_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Da vli kul magatá kuni ta slna ghunaghunafta yu. Ghuyghuya sanlaha ta ɗaŋwa ma slna, ka lagha kaghuni da ŋatsa ndela tsa slna taŋ ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nda ndəgha la Samari ma tsa luwa taŋ ya ta zlghaftá Yesu ta ghəŋa tsa gwaɗa mna tsa marakw ya ta mnay kazlay: Ka mnihatá tsi ta inda skwiha maga yu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma lagha la Samari da slanaghatá Yesu, ka ndəɓə həŋ ta dzvu da tsi ŋa nzatani kawadaga nda həŋ. Ka nzatá tsi ka zatá fitik his hada da həŋ. ");
INSERT INTO xed_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ka sgavaghatá ndəghata mnduha ta zlghaftá Yesu, kabga Yesu ka ghəŋani ta mna gwaɗani ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","«Zlghafzlgha aŋni ndanana tama makwa na, kabga gwaɗa gha mna ka yeya a wa. Nda sna vərɗa aŋni nda sləməŋa ŋni. Grafgra ŋni kahwathwata kazlay: Na mndu na ná, mnda mba mnduha ta ghəŋa haɗik ya kəʼa.» ");
INSERT INTO xed_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tahula tsa fitik his ya, ka sliʼaftá Yesu hada ka laghwi ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tsaw si wya ka Yesu mnata: «Haɗ lu ta vla glaku ŋa anabi ta haɗikani wu» kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɓhadaghatani ta haɗika Galili, ka tsuʼaftá gwal hada. Tsa gwal ta tsuʼafta ya ná, gwal ta nghaŋtá inda skwi maga Yesu ma Ursalima ma fitika skala Pak ya, kabga si labla hahəŋ guli da vla tsa skalu ya. ");
INSERT INTO xed_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ka vraghatá tsi tama da luwa Kana ta haɗika Galili, ma vla mbəɗanaftani ta imi ka ima inabi ya kay. Tsaw mamu sana mndu dagala ma slna ŋumna, ta maga slna ga mgham ma luwa Kafarnahum, kul ɗughwanaku zwaŋani ta kala ghəŋ. ");
INSERT INTO xed_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Snaŋtani kazlay: Sliʼafsliʼa Yesu ta haɗika Zudiya, ka sagha ta haɗika Galili kəʼa, ka sliʼaftá tsi ka lagha slanaghata. Kaʼa nda tsi mantsa: «Kdəkkdək, mbaɗa mbanaftá zwaŋa ɗa kul ɗughwanaku, ta kala ghəŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ka Yesu nda tsi mantsa: «Ka ta ngha a kaghuni ta mazəmzəm nda skwa ndərmimay wu ná, zlgha a kaghuni kay tama wa!» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka tsa mndu ta maga slna ga mgham ya nda tsi mantsa: «Mghama ɗa! Mbaɗa ma kɗaku zwaŋa ɗa mtuta,» ka nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ka Yesu nda tsi mantsa: «La dzagha! Wa a zwaŋa gha wdərwdər,» kaʼa. Ka zlghaftá tsa mndu ya ta tsa gwaɗa mnana Yesu ya, ka sliʼaftá tsi ka laghwi dzaghani. ");
INSERT INTO xed_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ta laha tsi ta tvi ta dzaʼa dzagha, ka guyatá tsi nda kwalvahani ta ŋlu da mnay ŋani kazlay: Waʼa nda mba zwaŋa gha wdər kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ka tsa mndu ya mantsa: «Ta wati luwa leŋavata tsi na?» kaʼa ɗawaŋta da həŋ. «Kiʼa hdzikata fitik ma ghəŋ ɗahawu, ta lavaghutá tsa ŋuɗidarani ya,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka graftá tsa dani ya, ta tsa luwa ya mna Yesu ŋani kazlay: Wdərwdər zwaŋa gha kəʼa ya. Daga baɗu tsa ka zlghaftá tsatsi nda gwal ga taŋ tani ta Yesu. ");
INSERT INTO xed_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tsaya mahisa mazəmzəm maga Yesu ta haɗika Galili manda zlaŋtani ta haɗika Zudiya. ");
INSERT INTO xed_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tahula tsaya, ka slatá skala la Yahuda ma Ursalima. Ka laf Yesu da hada. ");
INSERT INTO xed_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tsaw ma Ursalima, mamu sana ghwa tsap lu ndusa nda watgha saba tuwakha. Betsayda ta hga lu ta tsa ghwa ya nda gwaɗa Hebru. Ta wa tsa ghwa ya mamu glakamha hutaf. ");
INSERT INTO xed_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma tsa glakamha ya, mamu ndəghata gwal kul ɗughwanaku mida, manda gwal nda ghulpa, nda gwal ta dzəgiɗi, nda gwal nda rwa səla taŋ nda dzva taŋ ta kzla gigɗavata imi. ");
INSERT INTO xed_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tsaw ta sasa duhwala Lazglafta tazlay da tsa imi ya ŋa gigɗanafta. Ka gigɗavafgigɗa tsa imi ya, ka tiŋəl wa ta gi laha dida tahula gigɗavaftani ya, nda mba tsa mndu ya dər kinawu tsa ɗaŋwani ya. ");
INSERT INTO xed_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hkənmbsak tghas mida vakwa sana mndu ma ɗaŋwani ta nzaku hada. ");
INSERT INTO xed_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kəʼa ka Yesu ná, ta hani tsa mndu ya. Nda sna guli kazlay: Nda kɗa fitikani ta ɓasa tsa ɗaŋwa ya kəʼa. «Ta kumay ka ta mbafta gha ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","«Mghama ɗa! Haɗ mnda ɗa ŋa fadihata da imi gigɗavafər tsi wa. Ka dzaʼa yu, ka yu ya ná, gi tiŋlaghuta sani ta laha ka iʼi,» ka tsa mndu kul ɗughwanaku ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","«Sliʼafsliʼa gha kla ta skwa hana gha, ka sliʼa ka,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Gi hadahada ka mbaftá tsa mndu ya, sləŋaɗ klaftá skwa hanani, ka sliʼi. Tsaw, baɗu Sabat magakwa tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ka la mali ma la Yahuda nda tsa mndu mbanaf lu ya mantsa: «Sabat a vli gita kay ra? Wa ta mnaghatá kla skwa hana gha na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","«“Kla ta skwa hana gha, ka sliʼa ka” ka tsa mndu ta mbaɗifta ya nda iʼi,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","«Wa tsa mndu ta mnaghata kazlay: Kla ta skwa hana gha ka sliʼa ka kəʼa ya na?» ka həŋ ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tsaw sna a tsa mndu mbanaf lu ya ta tsa mndu ta mbanafta ya wu, kabga zaɗamzaɗa Yesu mataba tskata mnduha ma tsa vli ya. ");
INSERT INTO xed_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ɓats nzɗa, ka guyaftá Yesu ta vgha nda tsa mndu ya ma daɓa həga Lazglafta. «Wana nda mba ka ndana tama, yaha ka walglaŋta maga dmaku da slaghaghatá ya katakata ta malaghutá tsaya,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka sliʼaftá tsa mndu ya, ka laghwi da mnay ŋa la mali ma la Yahuda kazlay: Yesu tsa mndu ta mbiɗifta ya kay kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tsaya kəl la mali ma la Yahuda ka zba htsiŋa Yesu, kabga magatani ta tsa skwi ya baɗu Sabat. ");
INSERT INTO xed_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka Yesu nda həŋ mantsa: «Tata maga slna Da ɗa kulam ndanana, mantsa iʼi guli, tata maga slna yu kulam ndanana,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta ghəŋa tsa gwaɗa gwaɗa tsi ya, ka zbəgəlta la mali mataba la Yahuda ta Yesu ŋa dzata. Ta ghəŋa vəl ɓlanaptani ta zlaha Sabat kweŋkweŋ a ta zba həŋ wu, kabga mnayni kazlay: Vərɗa Lazglafta na Da ɗa kəʼa ta gra ghəŋani nda Lazglafta guli ya. ");
INSERT INTO xed_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ka Yesu vrəgliŋtá gwaɗani nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, laviŋ a zwaŋ ta magatá skwi gaghəŋ gaghəŋani, ka ngha a tsi ta skwi ta magə Da wa. Ka kinawu ta maga Da ta inda skwi ya, ka gragra mantsa ya ta maga zwaŋ guli. ");
INSERT INTO xed_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta ɗvay Da ta zwaŋ. Tsaya ta kəl tsi ka maranaŋtá inda skwi ta magə tsi, ŋa maranaŋtani ta slnaha ta malaghutá nana, kada nghaŋta kuni ta skwa ndərmimay. ");
INSERT INTO xed_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Manda ya ta sliʼaganapta Da ta gwal nda rwa nda hafu ya, mantsa ya ta vlaŋta zwaŋ ta hafu ŋa mndu ta kumə tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tsa a Da ta guma ta ghəŋa mndu wu, ma dzva zwaŋ fanamta tsi ta inda guma ŋa gumay, ");
INSERT INTO xed_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kada vla inda mndu ta glaku ŋa zwaŋ, manda ya ta vlə həŋ ta glaku ŋa Da ya. Ka vla a mndu ta glaku ŋa zwaŋ wu katsi, haɗ tsa mndu ya ta vla glaku ŋa Da ta ghunagatá tsa zwaŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Kahwathwata ka yu ta mnaghunata, mndu ta sna gwaɗa ɗa, ka zlghaftá tsi ta mndu ta ghunigihatá, mamu hafu ŋa kɗekedzeŋ ma tsa mndu ya. Haɗ lu dzaʼa tsanaghatá guma ta tsa mndu ya wa. Nda ghada Pak tsa mndu ya ta mtaku ka laghwi da hafu. ");
INSERT INTO xed_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kahwathwata ka yu ta mnaghunata, dzaʼa saghasa fitik, nda ghada va saghani, dzaʼa kəl gwal nda rwa ka snaŋtá lwa Zwaŋa Lazglafta. Tsa gwal dzaʼa snaŋta ya dzaʼa nzakway nda hafu. ");
INSERT INTO xed_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Manda ɗaslakwa hafu ta nzaku ma Da ya, manda tsaya vlaŋta tsi ta zwaŋ ŋa mutsakwa hafu ma tsatsi guli. ");
INSERT INTO xed_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ka vlaŋtá tsi ta mbrakwa tsa guma, kabga nzakwani ka Zwaŋa mndu. ");
INSERT INTO xed_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tsaya a skwi ŋa ndərmimay ghuni wu, dzaʼa saghasa fitik dzaʼa kəl inda gwal ma kulu ka snaŋtá lwani ");
INSERT INTO xed_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ŋa sliʼagapta taŋ. Gwal ta maga skwi ɗina ya, dzaʼa sliʼagapta ŋa nzata nda hafu hahəŋ. Gwal ta maga skwi kul ɗinaku ya guli, dzaʼa sliʼagapta ŋa tsanaghatá guma ta həŋ hahəŋ.» ");
INSERT INTO xed_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ka Yesu mantsa: «Haɗ sana skwi dzaʼa magata iʼi gaghəŋ gaghəŋa ɗa wa. Manda ya mniha Lazglafta ta tsa yu ta guma. Nda tvani ta tsa yu ta guma kabga zba a yu ta skwi ta kumə ghəŋa ɗa wu, skwi ta zɗəganatá mndu ta ghunigihata ta zbə yu. ");
INSERT INTO xed_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Ka iʼi katsi mnatá gwaɗa ta ghəŋa ɗa katsi ná, haɗ hayhaya tsa gwaɗa ɗa ya nda tsa wa. ");
INSERT INTO xed_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka sana mndu katsi mna gwaɗa ta ghəŋa iʼi katsi, nda sna yu kazlay: Tsa gwaɗa ta mnə tsi ta ghəŋa iʼi ya ná, kahwathwata nzakwani kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ghunaf ghuna kuni ta mnduha da Yuhwana ka mnaghunatá tsi ta kahwathwata. ");
INSERT INTO xed_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iʼi taɗa ná, zbaŋ a yu ta mndu ŋa mna gwaɗa ta ghəŋa ɗa wa. Tsaya kweŋkweŋ mnaghuna yu ŋa mutsay ghuni ta hafu. ");
INSERT INTO xed_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhwana ná, pitirla ta zlghaku ka tsuwaɗaka vli ya. Kumaŋkuma kuni ta nzɗavata nda rfu ma tsuwaɗakani. ");
INSERT INTO xed_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Iʼi, mamu ŋa ɗa ma gwaɗa ta ghəŋa ɗa ta malaghutá ŋa Yuhwana. Tsa gwaɗa ya ná, slnaha vliha Da ŋa kɗanafta ɗa ta magay ya. Tsa slnaha ta kɗə yu ta magay ya, ta maraŋta tsiɗiɗ kazlay: Da ya ta ghunigihata kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tsa Da ta ghunigihata ya, ta mnaŋtá gwaɗa ta ghəŋa ɗa. Aŋ mndani ta walaŋ a kuni ta snaŋtá lwani wa. Ta walaŋ a kuni ta nghaŋtá kumani guli wa. ");
INSERT INTO xed_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nza a gwaɗani ma ŋuɗufa ghuni wu kabga zlghaf a kuni ta mndu ya ghunaga tsi wa. ");
INSERT INTO xed_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Ta ndiʼandiʼa kuni ka tagha skwi ya nda vinda ma gwaɗa Lazglafta kabga mida dzaʼa mutsa ŋni ta hafu ŋa kɗekedzeŋ ka kuni. Tsa gwaɗa Lazglafta nda vinda ya ná, ta ghəŋa iʼi ta gwaɗa tsi. ");
INSERT INTO xed_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sew va a kuni ta sagha da iʼi ŋa mutsa vərɗa hafu wa. ");
INSERT INTO xed_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Da mnda səla a ta mutsa iʼi ta glakwa ɗa wa. ");
INSERT INTO xed_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tsaw nda sna iʼi ta kaghuni tsiɗiɗ kazlay: Ɗvu a kuni ta Lazglafta wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Da ɗa ta ghunigihata, ka kwalaghutá kuni ta tsuʼaftá iʼi. Ka ma sana mndu ta klaftá ghəŋani ka ghəŋani ka sagha katsi ná, má tsuʼaftsuʼa kuni. ");
INSERT INTO xed_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kaghuni gwal ta ɗva glaku da sani nda sani, ka kwalaghutá zba glaku daga da Lazglafta turtukwani, waka kuni má dzaʼa zlghafta na? ");
INSERT INTO xed_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Yaha kuni da uwalay kazlay: Dzaʼa wlay yu ta kaghuni da Lazglafta kəʼa. Tsa Musa faf kaghuni ta ghəŋ tida ya dzaʼa wla kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ka má zlghafzlgha kuni ta Musa katsi ná, má zlghafzlgha kuni ta iʼi guli, kabga vindaf ta ghəŋa iʼi tsatsi ta gwaɗa. ");
INSERT INTO xed_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka si zlghaf a kaghuni ta skwi vindaf tsatsi ya wu ní, waka kuni dzaʼa zlghaftá gwaɗa ɗa na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tahula tsaya, ka sliʼaftá Yesu ka laghwi ta sana ɓla tsa ghwa Galili ta hgə lu ka Tiberyad ya guli. ");
INSERT INTO xed_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ka sliʼaftá dəmga rutut mistani nghər həŋ ta mazəmzəm, ka mbamba gwal kul ɗughwanaku. ");
INSERT INTO xed_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ka ŋlaghatá Yesu ta ghwá ka nzagata hada kawadaga nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tsaw ndusa fitika skala Pak ta nzakway ka skala la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kəʼa ka Yesu klaŋtá ghəŋ ka nghadapta ná, rutututa dəmga ta lagha da tsi. Kaʼa mantsa: «Ga dzaʼa skwakta mu ta buradi ŋa zunustá na ndəghata mnduha na?» ka Yesu nda Filip. ");
INSERT INTO xed_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ŋa tsakwasla gwaɗa da tsi kəl tsi ka mnanata mantsa, kabga nda sna tsatsi ta skwi dzaʼa tsi magay. ");
INSERT INTO xed_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka Filip nda tsi mantsa: «Dər tseda vagha mnduha his dərmək ta maga slna klaf lu ŋa dzawaktá buradi nda tsi ná, slaghu a dər ŋa valaŋtá həŋ kiʼa kiʼa wu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ka sani mataba duhwalhani ta nzakway ka Andre zwaŋamani ma Simuŋ Piyer nda tsi mantsa: ");
INSERT INTO xed_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Mamu sana zwaŋ hadna nda buradi hutaf nda tsulhwa zwana klipi his da tsi, tsaw ŋa slafta kawu mataba ndəghata mnduha mandana na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka Yesu mantsa: «Mnanawa mna ta həŋ ka nzanzata həŋ nda nzanza,» kaʼa. Tsaw mamu ɗyatá kuzuŋ ksif ma tsa vli ya, ka nzanzaftá mnduha ta maga dəmbuʼ hutaf tida. ");
INSERT INTO xed_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ka hlaftá Yesu ta tsa buradiha ya, ka rfanaghatá tsi ta Lazglafta ta ghəŋani, ka daganaftá tsi ta tsa mnduha ta nzaku ya. Ka daganaftá tsi ta tsa klipiha ya ta həŋ guli manda ya ta kumə həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Manda babaghawta mnduha, «Tskafwa paɗakwani yaha da badzuta,» ka Yesu nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ka tskaftá həŋ, ka ndaghanaftá həŋ ta ghwanak ghwaŋpɗə his nda pɗakwa tsa buradi hutaf ya, tahula babaghawta taŋ demdem. ");
INSERT INTO xed_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","«Nana mndu na vərɗa anabi dzaʼa sagha ta ghəŋa haɗik mnə lu kay ya,» ka tsa mnduha ta nghaŋtá mazəmzəm maga Yesu ya. ");
INSERT INTO xed_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tsatsafta Yesu kazlay: Dzaʼa saghasa lu da ksafta nda mbraku ŋa nzakwani ka mgham kəʼa, ka kɗiŋta Yesu ta ŋləglaghata ta ghwá. ");
INSERT INTO xed_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Magatá hawu, ka sliʼagatá duhwalhani ta wa drəf. ");
INSERT INTO xed_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ka sliʼadamtá həŋ da kwambalu ŋa tsughwaɗa drəf ŋa dzaʼa da luwa Kafarnahum. Nda ghada kuzatá vli, ta vradagha a Yesu slanaghatá həŋ wa. ");
INSERT INTO xed_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tata ndrə həŋ, ka sliʼavaftá falak dagala katakata, ka kapatsaʼuwaku drəf. ");
INSERT INTO xed_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Swadap swa duhwalha Yesu ta kwambalu ta maga meli hutaf ka mkuʼ a tsi, ka nghaŋtá həŋ ta Yesu ta mbaɗa ta drəf ta ndusadaghata tavata kwambalu, ka ksaftá zləŋ ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","«Iʼi ya tane! Ma zləŋ kuni ta zləŋ!» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Si ta kumay həŋ ta klamta da kwambalu sizlay, gi nda ɓhadaghata kwambalu da tsa vli ta dzaʼa həŋ ya. ");
INSERT INTO xed_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gamahtsimani, ka havaktá tsa mnduha ta nzaku ta wa drəf ya kazlay: Turtuktuk kwambalu si ta lagha da tsa vli ya kəʼa. Grafgra həŋ guli kazlay: Lamə a Yesu kawadaga nda duhwalhani dida wu kəʼa. Nda ghəŋa taŋ laghwa duhwalhani. ");
INSERT INTO xed_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma va tsa fitik ya, ka sliʼaftá sana kwambaluha ma luwa Tiberiya, ka ɓhadaghatá həŋ ndusa nda tsa vli kəl Mgham Yesu ka rfanaghatá Lazglafta ta ghəŋa buradi, ka zutá mnduha ya kay. ");
INSERT INTO xed_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nghay mnduha ná, haɗ Yesu hada wu, haɗ duhwalhani hada guli wu, ka sliʼadamtá həŋ da tsa kwambalu ya ka laghwi da luwa Kafarnahum da zba Yesu. ");
INSERT INTO xed_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ka ɓhadaghatá həŋ ka zbə həŋ, ka slanaghatá həŋ ta wa sana ɓla tsa drəf ya. «Maləma ɗa! Yawu saghwa ka da hadna kay?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, ta zbə kabga vəl nghaŋta ghuni ta mazəmzəm a kuni ta iʼi wa. Ta zbə kabga zuta ghuni ta buradi, ka baghaftá kuni, kuni ta iʼi. ");
INSERT INTO xed_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ma ksə kuni ta slna ŋa skwa zay dzaʼa ɓadzuta. Ŋavawaŋa ka maga slna ŋa skwa zay ta nzɗavata dzaʼa vlaghunatá hafu ŋa kɗekedzeŋ. Tsa skwa zay ya ná, Zwaŋa mndu dzaʼa vlaghunata, kabga ta tsatsi thafta Da ta ŋizla vlaŋtani ta mbraku,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka həŋ nda tsi mantsa: «Nahgani dzaʼa aŋni magay ŋa kɗiŋtá magatá slna Lazglafta na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka Yesu nda həŋ mantsa: «Zlghafta ghuni ta mndu ya ghunaga tsi, na slna ya ta kzlə Lazglafta ta maganata ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka həŋ mantsa: «Mndərga wati mazəmzəm laviŋ ka ta magaŋnata ŋa nghaŋta ŋni, kada zlghafta ŋni ta kagha na? Wati slna dzaʼa ka magata na? ");
INSERT INTO xed_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Zuza dzidzíha ŋni ta Mana ma mtak. Manda ya nda vinda na: “vlagavla ta buradi daga ta luwa ŋa taŋ, ŋa zay taŋ,”» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, Musa a ta vlaghunatá buradi ta saha ta luwa wa, Da ɗa ta vlatá buradi ta saha ta luwa. ");
INSERT INTO xed_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tsa Buradi vlaga Lazglafta ya ná, tsa ta saha ta luwa ta vla hafu ŋa mnduha ta ghəŋa haɗik yeya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ka həŋ mantsa: «Mghama ɗa! gɗagɗa ta vlaŋnatá mndərga tsa buradi ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ka Yesu nda həŋ mantsa: «Iʼi buradi ta vla hafu. Ka saghasa mndu da iʼi, walglaŋta a maya ta kuzlaŋta wa. Ka zlghafzlgha mndu ta iʼi, walglaŋta a ndala ta kuzlaŋta wa. ");
INSERT INTO xed_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wya mnaghunamna yu, nda ngha kuni ta iʼi, ka kwalaghutá kuni ta zlghaftá iʼi. ");
INSERT INTO xed_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Inda gwal vliha Da, dzaʼa saghasa həŋ da iʼi. Haɗ iʼi guli dzaʼa zlaŋtá mndu ya ta sagha da iʼi ma bli wa. ");
INSERT INTO xed_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sa a iʼi ta luwa ŋa maga skwi ta kumə yu wa. Sasa iʼi ŋa maga skwi ta kumə mndu ta ghunigihata. ");
INSERT INTO xed_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Skwi ta kumə mndu ta ghunigihata ná, kwala ɗa kul zlanaghutá inda gwal vliha tsi, ŋa sliʼaganapta ɗa ta həŋ baɗu kɗakwa ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wya skwi ta kumə Da ɗa, dər wati ma mndu ta nghaŋtá zwaŋ ka zlghaftá tsi, nda mutsa hafani ŋa kɗekedzeŋ. Dzaʼa sliʼaganapsliʼa yu baɗu kɗakwa ghəŋa haɗik,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka ruruŋwaku la Yahuda ta ghəŋani, kabga mnayni kazlay: Iʼi buradi ta saha daga ta luwa kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","«Tsatsi a Yesu zwaŋa Yusufu kay wu ra? Tsatsi a na snaŋ amu ta i dani nda mani na ra? Ta ghəŋa wu ta mna tsi kazlay: Sa daga ta luwa yu kəʼa ɓa?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ka Yesu nda həŋ mantsa: «Zlanawazla ta ruruŋwaku mataba ghuni, ");
INSERT INTO xed_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","haɗ mndu dzaʼa laviŋtá sagha da iʼi, ka ghunagagha a Da ta ghunigihata da iʼi wa. Iʼi, dzaʼa sliʼaganapsliʼa yu ta tsa mndu ya baɗu kɗakwa ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wya skwi vindaf la anabi: “Dzaʼa taghanaftagha Lazglafta ta skwiha ta həŋ.” Dər wa ta snay, ka zlghaftá tsa skwi ta taghə Lazglafta ya, dzaʼa saghasa tsa mndu ya da iʼi. ");
INSERT INTO xed_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Va a tsaya ta mnay kazlay: Nda ngha tsa mndu ya ta Da nda irani kəʼa wu, ba mndu ta saha da Lazglafta yeya nda ngha ta Da nda irani. ");
INSERT INTO xed_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kahwathwata ka yu ta mnaghunata, mndu ta zlghaftá iʼi, nda mutsa hafani ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iʼi buradi ta vla hafu. ");
INSERT INTO xed_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Zuza dzidzíha ghuni ta mana ma mtak, kulam nda tsa, rwurwa inda taŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wana buradi ta saha daga ta luwa hadna. Mndu ta zay, mtəta a wa. ");
INSERT INTO xed_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iʼi buradi ta vla hafu ta saha daga ta luwa. Kata zay mndu ta tsa buradi ya, dzaʼa nzaku tsa mndu ya nda hafu ŋa kɗekedzeŋ. Tsa buradi ta vlə yu ya ná, sluʼuvgha ɗa ya. Dzaʼa vlay yu, kada nzakwa mnduha ta ghəŋa haɗik nda hafu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka həŋ mantsa: «Waka na mndu na dzaʼa vlamatá sluʼuvghani ŋa zay na?» ka la Yahuda zlghanafta ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ka Yesu nda həŋ mantsa: «Kahwathwata ka yu ta mnaghunata, ka za a kuni ta sluʼuvgha Zwaŋa mndu, sa a kuni ta usani wu katsi, haɗ hafu ɗekɗek ma kaghuni wa. ");
INSERT INTO xed_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mndu ta za sluʼuvgha ɗa, ta sa usa ɗa, mamu hafu ŋa kɗekedzeŋ ma tsa mndu ya. Dzaʼa sliʼaganapsliʼa yu ta tsa mndu ya baɗu kɗakwa ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Vərɗa skwa zay ná, sluʼuvgha ɗa ya. Vərɗa skwa say guli ná, usa ɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mndu ta za sluʼuvgha ɗa, ta sa usa ɗa ná, ma iʼi ta nzamta tsa mndu ya, ma tsa mndu ya nzamta iʼi guli. ");
INSERT INTO xed_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tsa Da ta ghunigihata ya ná, nda hafu mida. Nda tsatsi ta nzakwa iʼi nda hafu. Mantsa ya guli ka ta zay mndu ta iʼi, dzaʼa nzanza nda hafu. ");
INSERT INTO xed_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wana buradi ta saha daga ta luwa hadna. Nza a manda ŋa dzidzíha ghuni ta zutá mana ka rwutá həŋ ya wa. Mndu ta za na buradi na ná, dzaʼa nzanza nda hafu ŋa kɗekedzeŋ,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ta taghə tsi ta skwi ma həga tagha skwa la Yahuda ma Kafarnahum, mna Yesu ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ka sanlaha mataba duhwalhani snaŋər həŋ ta tsa gwaɗa ya mantsa: «Ɗukɗukwa na gwaɗa na, wa dzaʼa laviŋtá snay na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ɗaslafta Yesu ma vghani kazlay: Ta ruruŋwaku duhwalhani ta ghəŋa tsa tagha skwi ya kəʼa, «nda ŋra ŋuɗufa kaghuni guli ra? ");
INSERT INTO xed_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A ka tsa nghaŋ kuni ta Zwaŋa mndu ta ŋlu da vli si hada tsi ghalya, waka ŋuɗufa ghuni dzaʼa magay tama? ");
INSERT INTO xed_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sulkuma Lazglafta ta vla hafu, haɗ sana skwi laviŋ mnda səla ta magata wa. Na gwaɗa mnaghuna yu na ná, Sulkum nda hafu ya. ");
INSERT INTO xed_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tsaw mataba ghuni ná, mamu sanlaha kul zlghafta ɗekɗek,» ka Yesu nda həŋ. Tsaw nda sna Yesu daga zlraftani ta gwal kul zlghafta ɗekɗek, nda mndu ya dzaʼa skwapta tani. ");
INSERT INTO xed_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ka Yesu sganaghata mantsa: «Tsaya kəl yu ka mnay ŋa ghuni kazlay: Haɗ mndu dzaʼa laviŋtá sagha da iʼi, ka ghunak a Da wu kəʼa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tahula mnata Yesu ta tsa gwaɗa ya, nda ndəgha sanlaha ma duhwalhani ta vraghuta, ka kwal kul dzaʼagəlta mistani. ");
INSERT INTO xed_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ka Yesu mantsa: «Ki kaghuni, sliʼa a kaghuni guli ra?» kaʼa nda tsa gwal ghwaŋpɗə his ya. ");
INSERT INTO xed_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ka Simuŋ Piyer mantsa: «Mghama ɗa! Da wa ta dzaʼa ŋni? Ya wana mamu gwaɗa hafu ŋa kɗekedzeŋ da kagha. ");
INSERT INTO xed_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Zlghafzlgha ŋni, nda sna ŋni guli kazlay: Kristi mndu nda ghuɓa ta saha daga da Lazglafta kagha kəʼa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ka Yesu mantsa: «Iʼi a ta ɗagaptá na kaghuni ghwaŋpɗə his na ra? Nziya nza tsi ná, ka halaway ya turtuk mataba ghuni,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ta ghəŋa Zudas Iskaryut zwaŋa Simuŋ ta mna tsi ta tsaya kabga tsatsi mndu dzaʼa skwapta, dər má tekw tsatsi mataba tsa gwal ghwaŋpɗə his ya. ");
INSERT INTO xed_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tahula tsa, mbaɗa Yesu ka ra haɗika Galili. Va a ta dzaʼa ta haɗika Zudiya wu, kabga ta ɗakwatsay ɗakwatsay maliha ta ghəŋa la Yahuda hada ŋa dzata. ");
INSERT INTO xed_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tsaw ndusakndusa fitika skala dumbi da la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","«Sliʼafsliʼa gha ka dzaʼa ka ta haɗika Zudiya kada nghaŋta duhwalha gha guli ta slna ta magə ka, ");
INSERT INTO xed_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","haɗ mndu ta kuma maraŋtá ghəŋani ta ɗifa ghəŋani wa. Ya wya mamu skwiha ta magə ka ya, maraŋmara ta ghəŋa gha baŋluwa ŋa nghaŋta inda mnduha ta kagha,» ka zwanamani nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tsaw ta zlghaf a zwanamani ta tsatsi wa. ");
INSERT INTO xed_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ka Yesu nda həŋ mantsa: «Ta sagha a fitika ɗa wa. Ŋa kaghuni ya ná, dər ta wati luwa tsi, nda maga fitik, ka kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Haɗ kaghuni ta husaŋtá mnduha wa. Iʼi ná, husaŋhusa yu ta mnduha, kabga ta mnanaŋmna yu ta slna taŋ kul ɗinaku ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lawala kaghuni! La a iʼi wu, kabga ta kɗa a sagha fitika ɗa karaku wu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tahula mnanatani ta tsa gwaɗa ya ta həŋ, ka nzaghutá tsatsi ma Galili. ");
INSERT INTO xed_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Manda laghwa zwanamani da vla skalu, ka sliʼaftá tsatsi ka ghəŋani ka lafi ma ɗifa ma ɗifa, kul maraŋtá ghəŋani baŋluwa. ");
INSERT INTO xed_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ka la Yahuda mantsa: «Ga tsatsi tama!» ka həŋ ka zba Yesu ma vla skalu. ");
INSERT INTO xed_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka sliʼavaftá zlərɗutawi ka ŋɗaŋɗa ta ghəŋa tsatsi mataba mnduha kazlay: Ŋərma mndu ya, ka sanlaha, mnduha ta zaɗiŋta tsi, ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma va tsaya ná, haɗ mndu ta klaŋtá lwi ka gwaɗa ta ghəŋa Yesu wu, kabga zləŋa la mali ta ghəŋa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dəgatá tsa fitikha ŋa skalu ya ka gragra ya ná, ka sliʼaftá Yesu ka lamə da həga Lazglafta. Ka taghə tsi ta skwi ŋa mnduha mida. ");
INSERT INTO xed_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ka la Yahuda mantsa: «Taghaf ga na mndu na ta na ŋani ma skwi na na? Ya wya ta lagha a da vla taghaftá skwi wu, waka a snaŋtá skwi ma gwaɗa Lazglafta mandana na?» ka həŋ ka ndərmimay. ");
INSERT INTO xed_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ka Yesu nda həŋ mantsa: «Ta sagha da mndu ta ghunigihatá skwi ta taghə yu, ta sabə da iʼi a wa. ");
INSERT INTO xed_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ka fafa mndu ta ghəŋani ka maga skwi ta kumə Lazglafta, dzaʼa nda sna ka ta sagha da Lazglafta na skwi ta taghə yu na tsi, ka ta klaʼata ma ghəŋa ɗa a yu. ");
INSERT INTO xed_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mndu ta mna gwaɗa ta ghəŋa ghəŋani ná, ghəŋani ta ghubu tsi. Mndu ta zba vlaŋtá glaku ta mndu ya ta ghunafta, vərɗa mndu tsa mndu ya, ghwaɗaka mndu a wa. ");
INSERT INTO xed_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa a ta vlaghunata zlahu wu ra? haɗ ya mataba ghuni ta maga slna nda tsa zlahu ya wa. Ta zbə ŋaw kuni ta iʼi ŋa dzata tama?» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka həŋ mantsa: «Nda ksa ka da halaway, wa ta zba kagha ŋa dzata na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ka Yesu nda həŋ mantsa: «Turtuktuk yeya slna magaŋ yu, ka ndərmim kuni nda ndərmima demdem. ");
INSERT INTO xed_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Vlaghunavla Musa ta zlahu ŋa ɗatsa fafaɗ, aŋ mndani Musa a ta zlrafta wa. Daga ta dzidzí ta zlrafta lu. Ta ɗatsay a kuni ta fafaɗa zwani baɗu sabat rke? ");
INSERT INTO xed_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka si laviŋlava kuni ta tsa fafaɗa zwaŋ baɗu Sabat, kabga yaha lu da ɓlanaptá zlaha Musa ya ní, kabgawu ta ɓasa kuni ta ŋuɗuf ta ghəŋa iʼi, kabga vəl mbanafta ɗa ta mndu dzahumaʼ baɗu sabat tama? ");
INSERT INTO xed_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ma tsə kuni ta guma wa iri, tsawa tsa ta guma manda ya ta raku,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ka sanlaha ma mnduha la Ursalima mantsa: «Nana mndu na a ta zbə həŋ ŋa dzata kay ra? ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngha ɓa ta platá vghani ta gwaɗa, gwaɗanaf a lu wa. Ari tsatsaftsatsa a maliha mu kazlay: Kristi na mndu na kəʼa kana? ");
INSERT INTO xed_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aŋ mndani nda sna mu ta vli sabə tsi. Wya ka saghasa Kristi tani ná, haɗ mndu nda sna ta vli dzaʼa sabə tsi wu,» ka sanlaha ma mnduha la Ursalima guli. ");
INSERT INTO xed_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ma tsa tagha skwi ta taghə Yesu ma daɓa həga Lazglafta ya, ka klaŋtá tsi ta lwi dagala dagala. Kaʼa mantsa: «Nda sna kaghuni ta iʼi nda vli sabə yu dardar guli ra? Gaghəŋ gaghəŋa ɗa a sagha yu wa. Vərɗa mndu tsa mndu ta ghuniɗikta ya. Tsaw sna a kaghuni tama ta tsa mndu ya wa. ");
INSERT INTO xed_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iʼi, nda sna yu, kabga sagha da tsatsi iʼi. Tsatsi ta ghuniɗikta,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kamkamkam, ka sanlaha ka kuma ksay. Sew haɗ ya ta faftá dzvu tida wu, kabga ta sagha a fitikani karaku wa. ");
INSERT INTO xed_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","«Baɗu saghar Kristi ní, dzaʼa magay ta mazəmzəm ka malaghutá ŋa na mndu na ri?» ka ndəghata sanlaha ma mnduha mataba tsa dəmga ya. ");
INSERT INTO xed_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ka sniŋtá la Farisa ta tsa skwi ta mnə mnduha makɗekmakɗek ta ghəŋa Yesu ya. Ka ghunaftá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la Farisa ta gwal ngha həga Lazglafta da ksa Yesu. ");
INSERT INTO xed_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ka Yesu mantsa: «Ta tekeʼa nzɗa ɗa kwitikw da kaghuni, kada vra yu da mndu ta ghuniɗikta. ");
INSERT INTO xed_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dzaʼa zbay kuni ta iʼi, slafta a kuni ta iʼi wu, laviŋta a kuni ta ɓhata ma vli ta dzaʼa yu guli wu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ka la Yahuda mantsa: «Dzaʼa laghu diga ŋa kwala mu kul slanaghata na? Dzaʼa laghu da taba la Yahuda ta wiɗamtá vgha ma səla la Grek, ka tagha skwi ŋa la Grek rki na? ");
INSERT INTO xed_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dzaʼa zbay kuni ta iʼi, slaɗighata a kuni wu, laviŋta a kuni ta ɓhata da vli ta dzaʼa yu guli wu, kaʼa ná, nu klatá ghəŋa tsa gwaɗani ya na?» ka həŋ ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baɗu kɗavakta fitika tsa skalu ta nzakway ka mghama fitik ya, ka sliʼaftá Yesu ka sladata, ka gwaɗata nda lwi dagala. Kaʼa mantsa: «Ka ta kuzlaŋkuzla ndala ta mndu, ka sawi tsi da iʼi da sa imi. ");
INSERT INTO xed_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Ka zlghafzlgha mndu ta iʼi katsi, dzaʼa mbəzagapmbəza dzuɓay ma ŋuɗufani.” Tsa imi ya ta vla hafu. Mantsa ya vindatani ma gwaɗa Lazglafta,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tsaya ná, ta gwaɗə ta ghəŋa Sulkum dzaʼa tsuʼu gwal dzaʼa zlghaftá tsatsi ta tsa gwaɗa ya. Ta vla a lu ta Sulkum karaku ma tsa fitik ya wu, kabga ta kapanaf a lu karaku ta Yesu ma glakwani wa. ");
INSERT INTO xed_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ka sanlaha mataba tsa dəmga ya snaŋər həŋ ta tsa gwaɗa ya mantsa: «Vərɗa anabi na mndu na,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","«Kristi ya,» ka sanlaha. «Tsaw ma Galili dzaʼa saba Kristi rki? ");
INSERT INTO xed_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Ma zivra Dawuda ma luwa Batlehem ta nzakway ka luwa Dawuda” a dzaʼa saba Kristi, ka vindatani ma gwaɗa Lazglafta kay ra?» ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kidaghi gamndər ka tsa ndəghata mnduha ya dagavapta ta ghəŋa gwaɗa ta Yesu. ");
INSERT INTO xed_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kamkamkam, ka sanlaha ka kuma ksafta, sew haɗ ya ta faftá dzvu tida wa. ");
INSERT INTO xed_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ka vraghutá tsa gwal ngha həga Lazglafta ya da slanaghatá tsa la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la Farisa ya. Ka həŋ mantsa: «Nya kwal kuni ksakta na?» ka tsaha ya nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ka həŋ mantsa: «Kay! Haɗ mndu ta kɗə walaŋtá gwaɗaftá mndərga tsa gwaɗa ta gwaɗə tsa mndu ya wu,» ka həŋ nda tsa la Farisa ya. ");
INSERT INTO xed_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ka la Farisa mantsa: «Nu! Nanafnana lu ta kaghuni guli ɓa? ");
INSERT INTO xed_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mamu mndu dər turtuk mataba la mali mali, nda ya mataba la Farisa ta zlghaftá tsa mndu ya ta nghə kaghuni ra? ");
INSERT INTO xed_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tsa ndəghata mnduha ta zlghafta ta nghə kaghuni ya ná, sna a həŋ ta zlaha Musa wu, gwal nda ksiʼa həŋ!» ka la Farisa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ka Nikwademu ta nzakway mataba taŋ si ta sliʼafta girviɗik ka lagha slanaghatá Yesu ya kay nda həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ka ta ɗawap a lu ta gwaɗa da mndu, ka snaŋtá skwi maga tsi wu ná, ta gi tsanaghatsa zlaha mu ta guma ta ghəŋani ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ka həŋ mantsa: «Tekw kagha mataba la Galili guli ra? Dzaŋa ta gwaɗa Lazglafta ɓa ka ngha ka, ka dzaʼa slanaghasla ka ta vli ta mna saba anabi ma Galili,» ka həŋ nda tsi.  ");
INSERT INTO xed_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tahula tsa, ka gazlaghutá həŋ dzagha taŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ka sliʼaftá Yesu ka laghwi ta ghwá Zaytuŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wrək tgha ka vragatá tsi, ka lamə tsi da daɓa həga Lazglafta, ka sliʼadaghatá inda mnduha da tsi. Ka nzatá tsi nda nza ka tagha skwi ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mbaɗa gwal tagha zlahu ŋa mnduha, nda la Farisa ka ksadaghatá sana marakw ksaf lu ta hliri. Ka kladamta da taba mnduha ka sladanata ta kəma Yesu. ");
INSERT INTO xed_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ka həŋ mantsa: «Mghama ɗa! Wana na marakw na ksaf lu ta hliri. ");
INSERT INTO xed_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mndərga na marakw na ná, zlambata nda pala, ka zlaha Musa mnaŋnata. Waka kagha nda ŋa gha na?» ka həŋ nda Yesu. ");
INSERT INTO xed_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsaw ŋa tsanamtá matsavaɗa, kada mutsafta həŋ ta rutsak tida lagha həŋ mna tsa gwaɗa ya ŋani. Lagha Yesu ka dzamtá ghəŋ ka vinda skwi ta haɗik nda ndəfiŋa dzvu. ");
INSERT INTO xed_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ka gɗavatá həŋ ka va ɗaway da tsi. Ka Yesu mantsa: «Ka waya mataba ghuni kul walaŋta gatá dmaku ya, ka zlrafzlra tsi ta wuɗa na marakw na nda pala,» kaʼa kapaŋtá ghəŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ka dzəglamtá tsi ta ghəŋ ka vindgəltá skwi ta haɗik. ");
INSERT INTO xed_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tahula snaŋta taŋ ta tsa gwaɗa Yesu ya, ka gazlaghatá həŋ turtuk turtuk, zlrafta ta la galata mnduha ha ka saha ta zwani. Ka zlaŋtá həŋ ta Yesu turtukwani nda tsa marakw ya ta sladu ta kəmani. ");
INSERT INTO xed_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kəʼa ka Yesu kapglaŋtá ghəŋ ná, tsa marakw yeya nghaŋ tsi. Ka Yesu mantsa: «Aʼ, gazlagha diga həŋ kay ní makwa na? Haɗ mndu ta tsaghagha ta guma kay ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ka tsa marakw ya mantsa: «Haɗ mghama ɗa wa,» kaʼa. Ka Yesu mantsa: «Tsa a iʼi ta guma ta ghəŋa kagha guli wa. La! Yaha ka magəgəltá dmaku,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ka Yesu nda həŋ guli mantsa: «Iʼi tsuwaɗaka ghəŋa haɗik, mndu ta dzaʼa mista ɗa ná, haɗ dzaʼa mbaɗa ma grusl wu, dzaʼa mutsay ta tsuwaɗaka hafu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ka la Farisa mantsa: «Ghuba ghəŋa gha ta ghubu ka, vərɗa gwaɗa a na gwaɗa gha na wu,» ka həŋ ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ka Yesu nda həŋ mantsa: «Dər má ghuba ghəŋa ɗa ta ghubu yu ná, vərɗa gwaɗa ya ta mnə yu, kabga nda sna yu ta vli sagha yu nda vli ta dzaʼa yu. Tsaw kaghuni ya ná, sna a kuni ta vli sagha yu, nda vli ta dzaʼa yu wa. ");
INSERT INTO xed_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kaghuni ná, guma wa iri ta tsə kuni. Iʼi, tsa a yu ta guma ta ghəŋa mndu wa. ");
INSERT INTO xed_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ala ka tsatsa yu ta guma katsi, vərɗa guma na guma ɗa, kabga turtukwa ɗa a yu wu kawadaga ŋni nda Da ta ghunigihata. ");
INSERT INTO xed_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nda vinda ma zlaha ghuni kazlay: Ka nda guya gwaɗa mnduha his ta va tsa skwa turtuk ya katsi ná, kahwathwata nzakwa tsa gwaɗa ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ghuba ghəŋa ɗa ta ghubu yu mndani, ta ghuba iʼi Da ɗa ta ghuniɗikta guli,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","«Ga Da gha na?» ka həŋ nda tsi. Ka Yesu mantsa: «Sna a kuni ta iʼi wu, sna a kuni ta Da ɗa guli wa. Ka má nda sna kuni ta iʼi ná, má nda sna kuni ta Da ɗa guli,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ta tagha skwi ma daɓa həga Lazglafta mna tsi ta tsa gwaɗaha ya, ta nzaku ndusa nda vla pgha tsedi. Sew haɗ mndu ta faftá dzvu tida wu, kabga ta sagha a fitikani wa. ");
INSERT INTO xed_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ka Yesu mantsa: «Dzaʼa laghula yu, dzaʼa zbay kuni ta iʼi. Dzaʼa rwaku kuni ma dmaku, laviŋta a kuni ta ɓhata ma tsa vli ta dzaʼa yu ya wu,» kaʼa nda həŋ guli. ");
INSERT INTO xed_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ka la Yahuda mantsa: «Vghani rki dzaʼa tsi dzuvta kəl tsi ka mnay kazlay: Laviŋta a kuni ta ɓhata da tsa vli ta dzaʼa yu ya wu kəʼa na»? ka həŋ ta ghəŋa tsa gwaɗani ya. ");
INSERT INTO xed_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ka Yesu mantsa: «Gwal ta ghəŋa haɗik kaghuni, la ta luwa iʼi, ŋa gwal ta ghəŋa haɗik kaghuni, ŋa na ghəŋa haɗik na a iʼi wa. ");
INSERT INTO xed_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsaya tsa kəl yu ka mnay ŋa ghuni kazlay: Dzaʼa rwaku kuni ma dmakuha ghuni kəʼa ya. Dzaʼa rwaku kuni ma dmakuha ghuni ka si zlgha a kuni kazlay: “Iʼi ná, iʼi ya kəʼa ya wu,”» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ka həŋ nda tsi mantsa: «Wa kagha katək na?» ka həŋ. Ka Yesu nda həŋ mantsa: «Tsa iʼi mnaghuna yu daga taŋtaŋ ya, ya. ");
INSERT INTO xed_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ta traku skwiha ŋa mnay ɗa ta kaghuni, ka tsaghunaghatá guma. Tsa mndu ta ghunigihata ya ná, vərɗa mndu ya. Skwi snaŋ yu da tsi ta mnə yu ŋa mnduha ta ghəŋa haɗik,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sew sna a həŋ kazlay: Ta gwaɗə ta Da na Yesu ta tsa gwaɗa ya kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ka Yesu nda həŋ mantsa: «Baɗu kapadafta ghuni ta Zwaŋa mndu ya, baɗu tsaya dzaʼa snaŋta kuni “ta iʼi.” Baɗu tsaya guli dzaʼa snaŋta kuni kazlay: Gaghəŋgaghəŋa ɗa a ta maga yu ta skwi wu, manda ya taghaɗif Da ta mna yu ta gwaɗa ɗa kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tsa mndu ta ghuniɗikta ya ná, kawadaga ŋni nda tsi. Turtukwa ɗa a zlihata tsi wu, kabga ta maganamaga yu ta skwi ta zɗəganata inda fitik,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta gwaɗə Yesu ta tsa gwaɗaha ya ná, nda ndəgha gwal ta zlghafta. ");
INSERT INTO xed_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ka Yesu nda tsa la Yahuda ta zlghafta ya mantsa: «Ka gɗavagɗa kuni ma skwi ta taghə yu ŋa ghuni katsi, nda nza kuni ka vərɗa duhwalha ɗa. ");
INSERT INTO xed_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dzaʼa nda sna kuni ta kahwathwata, ŋa vlaghunata tsa kahwathwata ya ta nzaku nda platá vgha,» kaʼa ");
INSERT INTO xed_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka la Yahuda mantsa: «Zivra Abraham aŋni, ta walaŋ a aŋni ta nzata ka vuʼa mndu wa. Ta wu ŋa mnay gha kazlay: Dzaʼa plaku vgha ghuni kəʼa na?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ka Yesu nda həŋ mantsa: «Kahwathwata ta mnaghunata yu, inda mndu ta ga dmaku ná, nda nza ka vuʼa dmaku. ");
INSERT INTO xed_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Haɗ vuʼa ta gɗavata ma həga ga mndu wu, zwaŋ yeya ta gɗavata ŋa ɗekɗek. ");
INSERT INTO xed_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ka zwaŋ ta plighunista katsi ná, falauʼ vgha ghuni kahwathwata. ");
INSERT INTO xed_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nda sna yu kazlay: Zivra Abraham kuni kəʼa, ama wana kuni ta psa iʼi ŋa dzata, kabga tsuʼa a kuni ta gwaɗa ɗa wa. ");
INSERT INTO xed_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Skwi nghaŋ yu da Da ɗa ta mnə yu. Kaghuni, skwi taghaghunaf da ghuni ŋa ghuni ta magay,» kaʼa ");
INSERT INTO xed_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ka həŋ nda tsi mantsa: «Abraham da ŋni ta aŋni,» ka həŋ. Ka Yesu nda həŋ mantsa: «Ka má vərɗa zwana Abraham kuni katsi ná, má mndərga slna Abraham ta magə kuni. ");
INSERT INTO xed_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wana ndanana ná, ta zba dzata iʼi ta mnaghunatá kahwathwata skwi ya snaŋ yu da Lazglafta kuni. Ta walaŋ a Abraham ta magatá mndərga tsaya wa. ");
INSERT INTO xed_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kaghuni ná, slna da ghuni ta magə kuni,» kaʼa nda həŋ. Ka həŋ mantsa: «Masagwa a aŋni wa. Turtuktuk Da ŋni ta nzakway ka Lazglafta,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ka Yesu nda həŋ mantsa: «Ka si Lazglafta vərɗa da ghuni katsi ná, má dzaʼa ɗvuɗva kuni ta iʼi. Sliʼaf da Lazglafta iʼi ka sagha, gaghəŋgaghəŋa ɗa a sagha yu wa. Tsatsi ta ghunigiɗaghata. ");
INSERT INTO xed_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Laviŋ a kuni ta snaŋtá gwaɗa ɗa wu, kabga kwala ghuni kul fatá sləməŋ ka sna skwi ta mnaghunata yu. ");
INSERT INTO xed_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Da ghuni ná, halaway ya. Ta kumay kuni ta maganatá skwi ta zɗəganata. Nda nza tsatsi ka mnda dzata mndu daga ma zlrafta. Ta walaŋ a ta sladafta ta kahwathwata wu, kabga haɗ kahwathwata da tsi wa. Vərɗa ŋani ma gwaɗa ta gwaɗagapta ná, tsakalawi ya, kabga tsakalawi tsatá fwa tsatsi. Dani ma tsakalawi tsatsi guli. ");
INSERT INTO xed_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Iʼi, tsuʼa a kuni ta iʼi, kabga mnay ɗa ta kahwathwata wa. ");
INSERT INTO xed_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Waya mataba ghuni dzaʼa mnihata kazlay: Taɓ magamaga ka ta dmaku dər turtuk səla kəʼa nda iʼi na? Ka si kahwathwata ta mnə yu, kabga wu kwal kuni zlghay na? ");
INSERT INTO xed_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mndu ya nda nza ka ŋa Lazglafta ná, ta snay ta gwaɗa Lazglafta. Kaghuni, sna a kuni ta gwaɗa Lazglafta wu, kabga nza a kuni ka ŋani wu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ka la Yahuda mantsa: «Ta ŋaŋni a ta mnay kazlay: Mnda la Samari kagha, nda ksa ka da halaway kəʼa kay rke?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ka Yesu mantsa: «Ksa a yu da halaway wa. Glaku ŋa ɗa ta vlay ŋa Da ɗa, ka mbiɗata kaghuni ta iʼi. ");
INSERT INTO xed_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Zba vlaŋtá glaku ta ghəŋa ɗa a ta zbə yu wa. Turtuk tsa mndu ta zba tsa glaku ya ŋa ɗa, tsatsi ta tsa guma guli. ");
INSERT INTO xed_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kahwathwata ka yu ta mnaghunata, mndu ta snatá skwi ta taghə yu, haɗ dzaʼa mtuta ɗekɗek wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ka la Yahuda nda tsi mantsa: «Ndanana grafta ŋni kazlay: Nda ksa ka da halaway kəʼa. Mtumta Abraham, rwurwa la anabi guli. “Ka snasna mndu ta skwi ta taghə yu ná, haɗ dzaʼa mtuta ɗekɗek wu,” ka ka ná, ");
INSERT INTO xed_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","mal kagha ka tsa da ŋni Abraham ta mtuta ya ra? Ari mal kagha a ka tsa anabiha ta rwuta ya na? Wa iʼi ka kagha ta gray na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ka Yesu nda həŋ mantsa: «Ka vla glaku ta vlə yu ŋa ghəŋa ɗa katsi ná, bətbət tsa glakwa ɗa ya. Da ɗa ta vlihatá glaku, tsa ta mnə kaghuni kazlay: Má Lazglafta ŋni ya kəʼa ");
INSERT INTO xed_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","kul snaŋta kuni ya. Iʼi nda sna yu ta tsatsi. Ka má sna a yu wu ka yu mazlay katsi ná, má dzaʼa nzakway yu ka guram nda kaghuni ta tsakalawi ya. Tsaw nda sna iʼi ta tsatsi, ta snay yu ta gwaɗani guli. ");
INSERT INTO xed_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Harharhar ghəŋa Abraham ta ghəŋa vəl ndanayni ta dzaʼani nghaŋtá fitika ɗa. Ka nghaŋtá tsi, ka tuta tsi da rfu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ka la Yahuda mantsa: «Ta maga a ima gha hutaf mbsak ná, gi nda ngha yu ta Abraham ka ka?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ka Yesu mantsa: «“Kahwathwata ka yu ta mnaghunata, makəɗ lu ka Yatá Abraham ná, mamu iʼi,”» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Na mnatani ta tsaya, ka hlaftá həŋ ta pala ŋa zlərtsay. Ka ɗifaghutá Yesu, ka saghu tsi da daɓa həga Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ta labə Yesu ta tvi, ka nghaŋtá tsi ta sana mndu nda ghulpa daga ta yagatá lu. ");
INSERT INTO xed_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","«Maləma ɗa! Wana nda ghulpa na mndu na daga ta yagatá lu. Tsatsi re, dadahani a ta gatá dmaku katək na?» ka duhwalhani ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ka Yesu mantsa: «Ta ghəŋa dmakwani a ghulpəta tsi wu, ta ghəŋa dmakwa dadahani a guli wa. Ghulpghulpa ŋa maravata slna Lazglafta nda ma tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ta ka fitik vəl na ná, magamamaga ta slna mndu ya ta ghunigihata. Wana vli dzaʼa kuzuta ŋa kwal kul laviŋta ksəgəltá slna. ");
INSERT INTO xed_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tata ghəŋa haɗik na yu karaku ná, iʼi tsuwaɗaka ghəŋa haɗik,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tahula mnatani ta tsa gwaɗa ya, ka tfatá tsi ta sərɗək, ka hwaɗaʼatá haɗik nda tsi, ka masanafta ta kwapaya irihani. ");
INSERT INTO xed_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Manda kɗiŋtani ta masanaftá, kaʼa nda tsi mantsa: «La mbaziŋta kuma gha ma ima Silwe,» kaʼa. Tsa «Silwe» ya ná, manda mnay kazlay: Ghunay kəʼa ya. Ka sliʼaftá tsi ka laghwi mbaziŋtá kumani. Mbaziŋtani, tsiɗiɗ irani, ka sliʼaftá tsi ka laghu dzaghani. ");
INSERT INTO xed_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","«Na mndu ta nzata ka gatá skwi da mnduha ya a na mndu na kay ra?» ka sləvdahani si ta gɗata ta nghaŋta ta gatá skwi ya. ");
INSERT INTO xed_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","«Tsatsi ya» ka sanlaha. «Tsatsi a wu, sana mndu ya ta gara vgha nda tsatsi,» ka sanlaha guli. Ka tsa mndu ya mantsa: «Aŋ! vaɗa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","«Waka ka magay kəl ka ka nghaŋtá vli ɓa?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","«Sana mndu ya ta hgə lu ka Yesu, ta hwaɗaʼatá haɗik, ka masaɗiftá tsi ta kwapaya iriha ɗa. “La mbaziŋtá kuma gha ma ima Silwe,” kaʼa nda iʼi, ka sliʼaftá yu ka laghwi yu mbaziŋta, kəl yu ka nghaŋtá vli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","«Ga tsa mndu ya ndana?» ka həŋ nda tsi. «Sna a iʼi wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ka klaftá həŋ ta tsa mndu si nda ghulpa ya, ka klaghata da la Farisa. ");
INSERT INTO xed_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tsaw baɗu Sabat hwaɗaʼata Yesu ta tsa haɗik ya, ka masanaftá tsa mndu ya ta kwapaya irihani ka mbanafta ya. ");
INSERT INTO xed_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ka ɗawgəltá la Farisa da tsi kəʼa magaku kəl tsi ka nghaŋtá vli. Kaʼa mantsa: «Haɗik hwaɗa a tsi, ka masaɗifta ta kwapaya iriha ɗa. Ka mbaziŋta yu ta kuma ɗa, kəl yu ka nghaŋtá vli,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ka dgavaptá la Farisa his gamndər. «Mnda Lazglafta a tsa mndu ya wu kabga sna a ta skwi ta mnə zlaha sabat wu,» ka sanlaha. «Waka mnda dmaku dzaʼa maga mndərga tsahaya ma mazəmzəm na?» ka sanlaha, ka həŋ ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka həŋ nda tsa mndu ya mantsa: «Wa tsa mndu ta mbaghafta ya ka kagha ta gray na?» ka həŋ ka mahis nda tsi. «Anabi ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ta lanaf a ta la mali ta ghəŋa la Yahuda na mnay kazlay: Si nda ghulpa tsa mndu ya, ka nghaŋtá tsi ta vli kəʼa wa. Ka laghu həŋ hgaktá dadaha tsa mndu ya. Ka sagha həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Manda sagha taŋ, «zwaŋa ghuni na mndu na ra? Grafgra kuni kazlay: Nda ghulpa ta yagata kuni kəʼa ra? Waka a magaku kəl tsi ka nghaŋtá vli ndana ɓa?» ka həŋ nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka dadahani mantsa: «Nda sna aŋni kazlay: Zwaŋa ŋni ya kəʼa. Ta yagatá ŋni guli ná, nda ghulpa. ");
INSERT INTO xed_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tsaw sna a aŋni kəʼa magaku kəl tsi ka nghaŋtá vli wa. Ɗawawaɗawa da tsi, nda gla tsatsi prək ka zlghawani tsatsi ka ghəŋani,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ta zləŋay tsa dadahani ya ta la maliha ta ghəŋa la Yahuda, kəl həŋ ka mnay mantsa. Tsaw la mali ta ghəŋa la Yahuda ya ná, nda ghada dzrafta taŋ. Mndu ta mnay kazlay: Yesu ná Kristi ya kəʼa ná, dzaʼa taliŋtala lu ta tsa mndu ya ma həga tagha skwa mu kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tsaya kəl dadahani ka mnay kazlay: Nda gla tsatsi, prək tsatsi ka ghəŋani ka zlghawani kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ka hgəglaŋtá la Farisa ta tsa mndu ya kamahis. Ka həŋ nda tsi mantsa: «Mna kagha ta kahwathwata ta kəma Lazglafta. Aŋni ná, nda sna aŋni kazlay: Mnda dmaku tsa mndu ya kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ka tsa mndu ya mantsa: «Ka mnda dmaku tsi, ka mnda dmaku a tsi wu, sna a iʼi wa. Skwi turtuk ya snaŋ iʼi ná, si nda ghulpa yu, ndanana nda ngha yu ta vli tsiɗiɗ,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","«Waka a magaghata kəl ka ka nghaŋtá vli ka ka?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","«Ghadaghada yu ta mnaghunata, va a kuni ta snay wu. Nu ta kumə kuni ta mnəglaghunata ɗa tama, ari ta kumay a kaghuni ta nzakway ka duhwalhani guli na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ka rarazə həŋ. Ka həŋ mantsa: «Ba kagha ta nzakway ka duhwalani wala, aŋni ná, duhwalha Musa aŋni. ");
INSERT INTO xed_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nda sna amu kazlay: Gwaɗgana gwaɗa Lazglafta ta Musa kəʼa. Tsa mndu ya, sna a aŋni ka sagha ga tsi wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ka tsa mndu ya mantsa: «Wanawa mandərmimi kay tama! Sna a kuni ta vli ka ga sagha tsi wu? Wana gunihaguna ta ira iʼi taɗa tsa. ");
INSERT INTO xed_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Skwi ya snaŋ amu ná, zlgha a Lazglafta ta wa skwi ta ɗawu mnda dmaku wa. Mndu ya ta vla glaku ŋani, ta snanatá ŋani, ta zlghə tsi ta wani. ");
INSERT INTO xed_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka yawu ta sna a lu ta mnay kazlay: Mamu mndu ta gunanatá ira mndu yaga lu nda ghulpa kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ka si nza a tsa mndu ya ka mnda Lazglafta wu ná, má haɗ sana skwi laviŋ tsi ta magata wa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ka həŋ nda tsi mantsa: «Kagha yaga lu ka dmaku dzeʼdzeʼ guli ná, ka taghəgəltá skwi ŋaŋni,» ka həŋ, ka ghzlagapta ma həga tagha skwa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Manda snaŋta Yesu kazlay: Ghzlagap ghzla lu ma həga tagha skwa la Yahuda kəʼa, ka lagha tsi slanaghata. Kaʼa mantsa: «Zlghafzlgha ka ta Zwaŋa mndu ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ka tsa mndu ya mantsa: «Waya ní mghama ɗa! Mnihamna ka zlghafta yu,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","«Vani na ta nghə ka, ta gwaɗa nda kagha na,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","«Zlghafzlgha yu mghama ɗa,» kəʼa tsəlɓata ka ndəɓa dzvu ŋani. ");
INSERT INTO xed_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ka Yesu mantsa: «Sasa yu ta na ghəŋa haɗik na ŋa dganatá nzakwa mnduha. Ŋa nghaŋta gwal kul nghaŋtá vli, ta vli. Ta ghulpəta gwal nda ngha ta vli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ka sanlaha ma la Farisa hada mantsa: «Dzaʼa ghulpghulpa aŋni guli ra?» ka həŋ nda tsi manda snaŋta taŋ ta tsa gwaɗaha ya. ");
INSERT INTO xed_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ka Yesu nda həŋ mantsa: «Ka má ghulpghulpa kuni katsi ná, má haɗ dmaku ta kaghuni wa. Tsaw “nda ngha aŋni ta vli,” ka kuni ndanana ya, tsaya kəl dmakwa ghuni ka gɗavata,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ka Yesu mantsa: «Kahwathwata ka yu ta mnaghunata, mndu ta kwal kul lami nda ta watgha gamaka tuwakha, ka valadata nda ta muhul ná, ghali tsa mndu ya, gənda tsa mndu ya guli. ");
INSERT INTO xed_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ala ka lami nda ta watgha tsa mndu ya katsi, mnda ngha tuwakha tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Dzaʼa gunanaguna mnda ngha tsa həga ya ta watgha, dzaʼa nda sna tuwakha ta lwani, ŋa hgayni ta tuwakhani nda hga taŋ nda hga taŋ. Ŋa zligiŋtani ta həŋ dzibil. ");
INSERT INTO xed_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Zligiŋtani ta inda tuwakha ta nzakway ka ŋani ya, ŋa dzaʼani ta kəma taŋ, ta dzaʼa hahəŋ mistani. Ta dzaʼa tuwakhani mistani, kabga nda sna hahəŋ ta lwani. ");
INSERT INTO xed_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","La a həŋ mista mndu kul snaŋtá həŋ wu, dzaʼa hwayaghuhwaya həŋ diʼiŋ nda tsi, kabga tsatsaf a həŋ ta lwani wa.» ");
INSERT INTO xed_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Mantsa ya ka Yesu mnanatá mahdihdi ta həŋ, sew sna a tsa mnduha ta snay ya ta ghəŋa tsa skwi ta mnə tsi ya wa. ");
INSERT INTO xed_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ka Yesu nda həŋ guli mantsa: «Kahwathwata ka yu ta mnaghunata, iʼi watgha gamaka tuwakha. ");
INSERT INTO xed_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Inda gwal ta sagha ka tiŋlaghutá iʼi, ghali tsaha ya, gənda həŋ guli. Ama ka kwalaghutá tuwakha ta sna lwa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iʼi watgha gamaka tuwak, ka lamla mndu nda ta iʼi, dzaʼa mbaku. Dzaʼa laviŋlava ta lami ka sabi, ŋa mutsaftani ta skwa zayni. ");
INSERT INTO xed_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mndu ta ghali ná, ghali ŋani ta sagha da ghalay, ŋa dzata, ŋa zaɗanata. Iʼi ná, saghasa yu ŋa mutsafta mnduha ta hafu ka haslay, ŋa nzakwa taŋ kul haɗ sana skwi ta pɗugudunustá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Iʼi vərɗa mnda ngha tuwak, vərɗa mnda ngha tuwak ná, nda fa vghani ŋa tuwakhani. ");
INSERT INTO xed_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mndu ta ngha tuwak ta plə lu nda pla ŋani ná, ŋani a tuwakha wu na, nghayni ta kramtak mtak ta sagha ya ná, hwayaghutani ka zlanavatá tuwakha, ŋa valafta kramtak mtak ta tuwakha, ka kwitanatá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tsaya skwi ta magə mndu ta maga slna ŋa tsedi, haɗ ɗaŋwani nda tuwakha wa. ");
INSERT INTO xed_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Iʼi ná, vərɗa mnda ngha tuwak yu, nda sna yu ta tuwakha ɗa, hahəŋ guli nda sna hahəŋ ta iʼi, ");
INSERT INTO xed_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","manda va ya snaŋ Da ta iʼi ya, iʼi guli ná, nda sna yu ta Da, nda fa vgha ɗa guli ŋa tuwakha ɗa. ");
INSERT INTO xed_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mamu sanlaha ma tuwakha ɗa guli, kul haɗ ma na gamak na. Dzaʼa nda sna həŋ ta lwa ɗa, ŋa hlaktá ɗa ta həŋ, ŋa nzata taŋ tuts, turtuk mndu ta ngha həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ɗvuɗva Da ta iʼi, kabga fafa yu ta vgha ɗa ŋa mtuta, ŋa mutsəglafta ɗa. ");
INSERT INTO xed_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Haɗ mndu ta laviŋtá klaptá hafu ma iʼi wu, iʼi ka ghəŋa ɗa ta vlata. Laviŋlava yu ta vlata, laviŋlava yu ta mutsəglafta. Tsaya skwi dzaʼa ka magay ka Da ɗa nda iʼi.» ");
INSERT INTO xed_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ka dagəglavaptá la Yahuda kidaghi gamndər ta ghəŋa tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ka sanlaha ma həŋ mantsa: «Mamu duhwala halaway ma na mndu na, nda ksa da halaway, ŋaw ta sna kuni ta gwaɗa ta gwaɗə tsi na?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","«Haɗ mndu nda ksa da halaway ta gwaɗa manda tsaya wu, laviŋlava duhwala halaway ta gunana ta iri ta mnduha ra?» ka sanlaha guli. ");
INSERT INTO xed_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma fitika mazlam, ka skalə lu ta skala havaktá guna həga Lazglafta ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mbaɗa Yesu ka wawaku ma rmak ta wa tsa həga Lazglafta ta hgə lu ka rmaka Salumuŋ ya. ");
INSERT INTO xed_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ka lagha la Yahuda wanafta dlivis. Ka həŋ nda tsi mantsa: «Ŋa kulam yawu dzaʼa zlaŋnata ka ma dga ghəŋ ta dgə ŋni na? Ka kagha ta nzakway ka Kristi ya kay, mnaŋna ka dardar ɓa?» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ka Yesu nda həŋ mantsa: «Mnaghunamna yu, zlgha a kuni wa. Na slnaha ta magə yu nda hga Da ɗa na ta mnaŋtá iʼi, ");
INSERT INTO xed_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","zlgha a kuni wu kabga haɗ kuni mataba tuwakha ɗa wa. ");
INSERT INTO xed_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nda sna tuwakha ɗa ta lwa ɗa. Iʼi nda sna yu ta hahəŋ, ta dzaʼa həŋ mista ɗa guli. ");
INSERT INTO xed_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta vlaŋvla yu ta hafu ŋa kɗekedzeŋ ta həŋ. Haɗ həŋ dzaʼa walaŋta zwaɗuta wu, haɗ mndu dzaʼa hlaptá həŋ ma dzva ɗa guli wa. ");
INSERT INTO xed_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tsa Da ɗa ta vliha ta həŋ ya, malaghumala ta inda sanlaha. Haɗ mndu dzaʼa laviŋtá hlaptá həŋ ma dzva Da ɗa wa. ");
INSERT INTO xed_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aŋni nda Da ɗa ná, ka skwa turtuk ŋni,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lagha la Yahuda ka hləglaftá pala ŋa zlərtsay. ");
INSERT INTO xed_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ka Yesu nda həŋ mantsa: «Wya nda ndəgha slna ɗinaɗina si da Da ɗa magaghuna yu, ta ghəŋa wati ta kuma kuni ta zlərtsa iʼi na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ka həŋ mantsa: «Ta ghəŋa magata gha ta skwi ɗina a ta zlərtsa ŋni ta kagha wu, ta ghəŋa vəl kwarakwara gha. Kagha ta nzakway ka mnda səla ná, ta gra ghəŋa gha ka nda Lazglafta,» ka la Yahuda nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ka Yesu nda həŋ mantsa: «Vinda a ma deftera zlaha ghuni ma vla mnay Lazglafta kazlay: Kaghuni ná, “lazglaftaha” kuni kəʼa kay ra? ");
INSERT INTO xed_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nda sna mu kazlay: Haɗ mndu dzaʼa laviŋtá hərɗiŋta skwi nda vinda ma deftera Lazglafta wu kəʼa. Tsaw lazglaftaha kuni ka Lazglafta tsanaftá hgu ta mnduha ta mnə tsi ta gwaɗani ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iʼi, Da ta zbaptá iʼi, ka ghunigihata ta ghəŋa haɗik, waka kuni dzaʼa mnay kazlay: Ta kwarakwara ka kəʼa kabga mnay ɗa kazlay: Zwaŋa Lazglafta yu kəʼa? ");
INSERT INTO xed_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka slna Da ɗa a ta magə yu ta nghə kuni wu, ma zlghaf kuni ta iʼi. ");
INSERT INTO xed_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ala ka si vani tsi ta magə yu katsi, dər má zlghaf a kuni ta iʼi wu, zlghafwazlgha a ka tsa slnaha ya, kada grafta kuni, ŋa snaŋta ghuni kazlay: Da ta nzaku ma iʼi, iʼi ma Da guli kəʼa,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ta ghəŋa tsaya ka zbəgəltá həŋ ta ksafta, ka zaɗanaghatá tsi rək ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ka vrəglaghutá Yesu ta ɓla ghwa Zurdeŋ, ma vla taŋtaŋa magay Yuhwana ta batem ŋa mnduha, ka nzatá tsi hada. ");
INSERT INTO xed_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","«Haɗ mazəmzəm dər turtuk maga Yuhwana wa. Tsaw inda skwi ya mna Yuhwana ta ghəŋa na mndu na ná, manda va tsaya nzakwani, ka ndəghata mnduha ta sliʼadaghata da tsi ta mnay.» ");
INSERT INTO xed_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma tsa vli ya, nda ndəgha gwal ta zlghaftá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mamu sana mndu ma luwa Betani Lazar hgani ksaf ɗaŋwa. Ma tsa luwa ya ta nzakwa kwaghamani ta nzakway ka i Mari nda Marta. ");
INSERT INTO xed_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tsa Mari ya tsa ta pghanaftá urdi ta səla ta Mgham Yesu ka takaɗay nda swida ghəŋani ya. Zwaŋamani tsa Lazar kul ɗughwanaku ya guli. ");
INSERT INTO xed_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ka tsghaghatá tsa kwaghamani ya ta lwi ŋa Yesu kazlay: Mghama ɗa, ɗughwana a tsa gra gha ya kay wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka Yesu mantsa: «Dzata a tsa ɗaŋwa ya ta Lazar wa. Ŋa maraŋtá glakwa mbrakwa Lazglafta tsa ɗaŋwani ya, kada maravata glakwa Zwaŋa Lazglafta guli,» kaʼa manda snaŋtani ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tsaw ta ɗvay Yesu ta i Marta nda mukumani nda Lazar. ");
INSERT INTO xed_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tahula tsa snaŋta Yesu kazlay: ɗughwana a Lazar wu kəʼa ya, ka magəglatá tsi ta fitik his, ma tsa vli hada tsi ya. ");
INSERT INTO xed_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tahula tsa, «vramavra ta haɗika Zudiya,» kaʼa nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","«Maləma ɗa, kɗakwa la Yahuda tsa ta kuma zlərtsa ta kagha nda pala ŋa dzata ná, vramavra ta haɗika Zudiya ka ka?» ka duhwalhani nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ka Yesu mantsa: «Ghwaŋpɗə his a nzemndi ma vaghu ra. Ka ta mbaɗə gifitik mndu ta mbaɗa ná, haɗ tuthun, ta dzadzay wu, kabga tsuwaɗak vli ta wa irani gifitik. ");
INSERT INTO xed_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ala ka girviɗik ta mbaɗa mndu ta mbaɗa katsi, ta dzadzay tuthun, kabga ngha a ta vli girviɗik wu,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","«Wa a dzadza hani ta gra mu Lazar, ka la yu da sliʼanafta,» kaʼa nda həŋ tahula mnatani ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","«Mghama ɗa! ka si hani ta dzata ya ní, haɗ dzaʼa mbafta ra?» ka duhwalhani nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ba va hani ta dzata kahwathwata ka hahəŋ sizlay nda ŋa taŋ. Tsaw ta ghəŋa mtatani mna Yesu ta ŋani. ");
INSERT INTO xed_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ka Yesu klinistá ghəŋani ta həŋ mantsa: «Nda mta Lazar tane! ");
INSERT INTO xed_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ta rfu yu ta ghəŋa kwala ɗa kul haɗ hada. Ɗina tsaya ka ŋa ghuni, ŋa fafta ghuni ta ghəŋ ta iʼi. Mbaɗma slanaghata ndana tama,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","«Mbaɗma amu guli, ka dzaʼa mu rwuta kawadaga nda tsi,» ka Tuma ta hgə lu ka mbuhwali nda pɗakwa duhwalha. ");
INSERT INTO xed_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ta lagha Yesu ná, mafwaɗa fitika Lazar tsa ma haɗik manda paɗamta. ");
INSERT INTO xed_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tsa luwa Betani ya, malaghumala a ka meli hkən nzakwani nda luwa Ursalima wa. ");
INSERT INTO xed_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nda ndəgha la Yahuda ta sliʼadaghata da zgwaŋtá i Marta nda Mari, ta ghəŋa mtatá zwaŋama taŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Manda snaŋta Marta kazlay: Waʼa Yesu ta sagha kəʼa, ka labə tsi da guyay ta tvi, ta nzutá nzakwani Mari mintgha. ");
INSERT INTO xed_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ka Marta nda Yesu mantsa: «Mghama ɗa! Ka má hadna ka katsi ná, má mta a zwaŋama ɗa wa. ");
INSERT INTO xed_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tsaw dər nda vanana ná, nda sna yu kazlay: Inda skwi dzaʼa ka ɗawaŋta da Lazglafta ná, dzaʼa tsuʼaghaf tsuʼa Lazglafta ta wani kəʼa,» ka Marta nda Yesu. ");
INSERT INTO xed_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ka Yesu mantsa: «Dzaʼa sliʼagapsliʼa zwaŋama gha ma mtaku,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","«Nda sna yu mantsa kazlay: Dzaʼa sliʼagapsliʼa ma mtaku baɗu kɗakwa ghəŋa haɗik kəʼa,» ka Marta nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ka Yesu nda tsi mantsa: «Iʼi tsa mndu ta sliʼaganaptá gwal nda rwa ŋa nzəglata taŋ nda hafu ya. Mndu ta zlghaftá iʼi dər mtumta tsi, dzaʼa nzanza nda hafu. ");
INSERT INTO xed_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Dər wati ma mndu ka ta ndiri tsi ta zlghaftá iʼi haɗ dzaʼa mtuta ɗekɗek wa. Zlghafzlgha ka ta tsa?» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ka Marta nda tsi mantsa: «Aŋni mghama ɗa, zlghafzlgha yu kazlay: Kagha ná, Kristi Zwaŋa Lazglafta ya dzaʼa saha ta ghəŋa haɗik ka,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mnatani ta tsa gwaɗa ya, ka sliʼaftá tsi ka laghwi mnanatá mukumani Mari makɗekmakɗek kazlay: Waʼa tsa mndu ta taghamatá skwi ya kay hadna ta gvala kagha, kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na gi snaŋta Mari mantsa ya, gi brahwat sliʼafta, ka hwaya slanaghatá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tsaw ta lamə a Yesu da luwa karaku wu, tata nzaku ma tsa vla guyakwa taŋ nda Marta ya. ");
INSERT INTO xed_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nghay tsa la Yahuda ta nzaku ma həga ta lɓa ŋuɗuf ŋa Mari ta tsa gi sliʼaftani brahwat ka sliʼi dzibil ya, ka həŋ mantsa: Ya sliʼani da taw ta kulu tsa, ka həŋ ka sabi mistani. ");
INSERT INTO xed_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","«Mghama ɗa! Ka má hadna ka ná, má mta a zwaŋama ɗa wu,» Ka Mari zləmbatá ma ghuva Yesu nghaŋər tsi manda ɓhadaghatani da tsa vli nda tsi ya. ");
INSERT INTO xed_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nghay Yesu ta Mari ta taw, nda tsa la Yahuda ta labə mistani ya tani, ka lagha tsi ta ŋuɗufa Yesu ka kɓanafta. ");
INSERT INTO xed_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Ga paɗamta kuni na?» kaʼa nda həŋ. «Mghama ɗa! Sawi nghanata ɓa,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ka mbəzə Yesu ta ima taw. ");
INSERT INTO xed_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","«Nghawa kəʼa ta ɗvay ɓa!» ka la Yahuda ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","«Tsatsi ta mbanaftá ghulpata mndu kay guli ná, laviŋ a ta pyaftá Lazar má ŋa kwal kul mtuta ra,» ka sanlaha mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ka ləglagha tsi ta ŋuɗufa Yesu. Ka sliʼaftá tsi ka lagha ta kulu. Sana galigha ya fuŋ lu ta klam ta wani. ");
INSERT INTO xed_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","«Taŋwalaghwa ya klam ta wani ya,» ka Yesu. «Mghama ɗa! Nda ghada ziʼatani, kabga ma fwaɗa fitikani na manda paɗamta,» ka Marta, mukumani ma tsa mndu nda mta ya. ");
INSERT INTO xed_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","«Mnagha a yu kazlay: Ka zlghafzlgha ka ná, dzaʼa nda ngha ka ta mbrakwa Lazglafta kəʼa kay ra?» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ka taŋwalaghutá həŋ ta tsa klam ya. Ka nghadaftá Yesu nda ta luwa, kaʼa mantsa: «Da! Ta rfay yu ta kagha, kabga ta zlghafzlgha ka ta tawa ɗa. ");
INSERT INTO xed_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nda sna yu kazlay: Ta gɗagɗa ka ta zlghiɗiftawa ɗa kəʼa. Nziya nza tsi ná, ŋa na mnduha ta wiɗifta na ta mna yu, kada zlghafta həŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tahula mnatani ta tsa gwaɗa ya, kaʼa nda lwi dagaladagala mantsa: «Lazar! Sabsa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ka sabə tsa Lazar si nda mta ya nda slahwatá səlahani nda dzvuhani, nda patak ma kuma. «Paliŋwapala, ka mbaɗa tsi ta mbaɗa,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mataba tsa la Yahuda si ta lagha da zgwa Mari ya ná, nda ndəgha sanlaha ta zlghaftá Yesu nghaŋər həŋ ta skwi maga tsi. ");
INSERT INTO xed_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka sliʼaftá sanlaha mataba taŋ, ka laghwi slanaghatá la Farisa, ka rusanaftá skwi maga Yesu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lagha la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la Farisa, ka tskanatá gwal tsa guma. Ka həŋ mantsa: «Dagala mazəmzəm ta magə tsa mndu ya, waka mu dzaʼa magay na? ");
INSERT INTO xed_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ka zlanazla mu ka va magayni katsi ná, dzaʼa sliʼaghuslia mnduha da zlghaftá tsatsi, ŋa sagha la Ruma da zaɗanatá həga Lazglafta nda mndəra amu tani,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ka Kayifa ta nzakway tekw mataba la mali ta ghəŋa la Yahuda, ya zbap lu ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta ma tsa vaku ya, nda həŋ mantsa: «Kaghuni wa, haɗ skwi snaŋ kuni wa. ");
INSERT INTO xed_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Haɗ kuni ta ndanu ra? Draŋ mtuta mndu turtuk da manaka mnduha, kaya dzaʼa zaɗanata lu ta mndəra mndu nekwnekw,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tsaw tsa gwaɗa mnə tsi ya ná, nda ɗvayni a wa. Ma vəl tsa nzakwani ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya ná, ka mnutá tsi kazlay: Dzaʼa mtumta Yesu da mnaka la Yahuda kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ŋa la Yahuda nda ghəŋa taŋ a wu, nda nza guli ŋa tskanatá inda zwana Lazglafta ta wiɗatá vgha. ");
INSERT INTO xed_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Daga baɗu tsa ka dzraftá həŋ ta wi ŋa dzata Yesu. ");
INSERT INTO xed_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tsaya kwal Yesu margəltá vghani baŋluwa mataba la Yahuda. Ka sliʼaftá tsi ka laghwi da sana luwa ta hgə lu ka Ifrayim ndusa nda wa mtak. Ka nzatá tsi hada kawadaga nda duhwalhani. ");
INSERT INTO xed_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ka ndusaktá fitika skalay la Yahuda ta Pak. Ma kɗaku tsa fitika skalu ya, ka sliʼadaghatá ndəghata mnduha tsa haɗik ya da luwa Ursalima, ŋa ghuɓiŋtá vgha taŋ. ");
INSERT INTO xed_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","«Ta ndanə kuni ná, dzaʼa saghasa da vla skalu re, ari saghata a wa na?» ka həŋ mataba taŋ, ka zba Yesu. ");
INSERT INTO xed_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tsaw si mnumna la mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda la Farisa kazlay: Ka wa mndu da snaŋtá vli hada tsi ya ná, ka mna tsi ŋa ksafta, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ta pɗakwa fitik mkuʼ ka maga skala Pak, ka Lagha Yesu da luwa Betani, ma tsa luwa ta nzaku Lazar, tsa mndu sliʼaganap tsi ma mtaku ya kay. ");
INSERT INTO xed_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ka danatá lu ta skwa zay hada, ka dgə Marta. Tekw tsa Lazar ya mataba tsa mnduha ta nzata ŋa za skwa zay kawadaga nda Yesu ya. ");
INSERT INTO xed_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ka klaftá Mari ta hwaraka urda sana fu ta hgə lu ka Nar, nda bla dzvani, ka rita litir. Ka pghə tsi ta səla Yesu, ka takaɗay nda swida ghəŋani. Ka vərtikanaftá tsa urdi ya ta vli ma inda tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ka Zudas Iskaryut zwaŋa Simuŋ, ta nzakway tekw mataba duhwalha Yesu ta dzaʼa skwapta ya mantsa: ");
INSERT INTO xed_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Haɗ lu si ta skwaptá na Urdi na ka tseda vagha mnduha hkən dərmək ka daganaftá gwal ka pɗu ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Vərɗa gwaɗa ta la pɗu a gwaɗə tsi wa. Vərɗa tsatsi ná, ghali ya kabga ta dzaʼa tsatsi nda klaʼatá tsa skwi ta tskə lu ma zlibi da tsi ya. ");
INSERT INTO xed_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ama ka Yesu mantsa: «Zlanazla! Ka fata tsi ŋa baɗu paɗa iʼi. ");
INSERT INTO xed_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gwal pɗu ná, tavata kaghuni hahəŋ. Iʼi, nzata a yu tavata kaghuni ŋa ɗekɗek wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Snaŋta ndəghata la Yahuda kazlay: Waʼa Yesu ma Betani kəʼa, ka sliʼadaghatá həŋ. Tsa sliʼadaghata sliʼadagha həŋ ya ná, ta ghəŋa gwaɗa ta Yesu nda ghəŋani a wu, ta kumay həŋ ta nghaŋtá tsa Lazar sliʼaganap Yesu mataba gwal nda rwa ya guli. ");
INSERT INTO xed_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","«Dzatá Lazar guli!» ka la mali ta ghəŋa gwal dra skwi ŋa Lazglafta kurata, ");
INSERT INTO xed_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kabga nda ndəgha la Yahuda ta sliʼapta mataba taŋ ka laghwi da zlghaftá Yesu ta ghəŋa gwaɗa ta Lazar. ");
INSERT INTO xed_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Gamahtsimani, ka snaŋtá dəmga ta sliʼadaghata da tsa vla skalu ya kazlay: Waʼa Yesu ta sagha da Ursalima kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ka ɓal həŋ ta sluhwa zlizlam ka dzaʼa da guyay ta tvi. Ka həŋ mantsa: «Ŋa Lazglafta glaku! Ka tfanaghatfa Lazglafta ta wi ta mndu ta sagha nda hga Mgham. Ka tfanaghatfa Lazglafta ta wi ta Mghama la Israʼila,» ka həŋ ka hla wi. ");
INSERT INTO xed_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Manda ya nda vinda, ka mutsaftá Yesu ta zwaŋa kɗih, ka laf tsi tida. ");
INSERT INTO xed_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ma zləŋ kuni ta zləŋ mnduha ma luwa Ursalima, waʼa Mghama ghuni ta sagha ta zwaŋa kɗih,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Inda tsa skwiha ta magaku ya ná, ta sna a duhwalhani ta klatá ghəŋani karaku wa. Tahula kapanafta lu ta Yesu ma glakwani, ka havaktá həŋ kazlay: Ta ghəŋa tsatsi vindafta lu ta tsa skwi ya kəʼa, ka sagha tsa skwi mna lu ma gwaɗa Lazglafta ya magata manda va tsaya guli, ta ghəŋa Yesu. ");
INSERT INTO xed_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ka rusu inda tsa mnduha si kawadaga nda Yesu ya ta skwi nghaŋ həŋ, ma fitika sliʼaganaptani ta Lazar ma kulu, mataba gwal nda rwa ya. ");
INSERT INTO xed_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tsaya kəl mnduha ka sliʼadaghata da guyay kabga snaŋta taŋ ta tsa mazəmzəm maga tsi ya. ");
INSERT INTO xed_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","«A haɗ sana skwi dzaʼa magata mu ya na! Nghawa ɓa ta inda mnduha ta dzaʼa mistani,» ka la Farisa mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mamu la Grek mataba tsa gwal ta sliʼadaghata da Ursalima ŋa tsəlɓu da Lazglafta ma tsa fitika skalu ya. ");
INSERT INTO xed_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ka həŋ mantsa: «Mghama ɗa! Ta kumay ŋni ta guyata nda Yesu,» ka həŋ nda Filip ta nzakway ka mnda luwa Betsayda ta haɗika Galili. ");
INSERT INTO xed_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ka laghu Filip mnanatá Andre, ka sliʼaftá həŋ kawadaga ka laghwi mnanatá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ka Yesu nda həŋ mantsa: «Nda maga fitik dzaʼa kəl lu ka kapanaftá Zwaŋa mndu ma glakwani. ");
INSERT INTO xed_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kahwathwata ka yu ta mnaghunata, ndleŋw manda va tsaya ta nzata hya nimaya ka dəɗam a tsi da haɗik ka rwutani. Ka rwurwa tsi, dzaʼa yaf ya dagala. ");
INSERT INTO xed_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mndu ta ɗva ghəŋani ná, dzaʼa zaɗiŋzaɗa. Ala, ka malaghumala ɗvafta tsa mndu ya ta Lazglafta ka skwiha ma ghəŋa haɗik katsi, dzaʼa nzulananzula tsa mndu ya ta hafani ŋa kɗekedzeŋ. ");
INSERT INTO xed_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kata kumay mndu ta magihatá slna ná, ka sawi tsi mista ɗa, ma tsa vli dzaʼa nzata iʼi ya, hada dzaʼa nzata tsa mndu ta magihatá slna ɗa ya guli. Ka ta magihamaga mndu ta slna, dzaʼa ŋlanafŋla Da ɗa ta tsa mndu ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ka Yesu mantsa: «Ndanana ná, wana nda tsa ŋuɗufa ɗa. Sna a yu ta skwi ŋa mnay ɗa wa. Da! Klapkla ta iʼi ma na ghuya ɗaŋwa na ka yu, tsaw ta ghəŋa tsa ghuya ɗaŋwa ya klə yu ka saha ta ghəŋa haɗik da ghuyay kay guli. ");
INSERT INTO xed_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Da! Maraŋmara ta glakwa gha,» kaʼa. «Ghadaghada yu ta maraŋtá glakwa ɗa, dzaʼa kɗay yu ta maray guli,» ka lwi gwaɗagata daga ta luwa. ");
INSERT INTO xed_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","«Luwa ya ta ŋəzlata,» ka dəmga ta snay. «Duhwalha Lazglafta ya ta gwaɗganata,» ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ama ka Yesu mantsa: «Tsa lwi ta gwaɗagata ya ná, ka ŋa ɗa a wa, ka ŋa ghuni gwaɗagata tsi. ");
INSERT INTO xed_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ndanana tama, nda maga fitika tsanaghatá guma ta na ghəŋa haɗik na. Ndanana dzaʼa wuɗidiŋta lu ta mghama na ghəŋa haɗik na. ");
INSERT INTO xed_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iʼi, baɗu kapaɗifta lu ta na ghəŋa haɗik ya, dzaʼa tɗaktɗak yu ta inda mnduha da iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tvi kəʼa dzaʼa mtaku ta mnə tsi ma tsa gwaɗani ya. ");
INSERT INTO xed_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","«Dzaʼa nzata ŋa kɗekedzeŋ Kristi, ka aŋni taghafta ma deftera zlahu ná, waka kagha tama ta mnay kazlay: Dzaʼa kapanafkapa lu ta Zwaŋa mndu kəʼa. Wa tsa Zwaŋa mndu ya?» ka tsa dəmga ya. ");
INSERT INTO xed_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ka Yesu mantsa: «Ta ɓats nzɗa tsuwaɗak karaku mataba ghuni. Tatakeʼa tsuwaɗak na ná, Mbaɗawambaɗa ta mbaɗa ma tsuwaɗak, yaha vli da kuzaghunaghata. Mndu ta mbaɗa ma grum ná, sna a ta vli ta dzaʼa tsi wa. ");
INSERT INTO xed_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Zlghafwazlgha ta tsuwaɗak ta da kaghuni tsi na, kada nzakwa kuni ka zwana tsuwaɗak,» kaʼa nda həŋ. Gwaɗata Yesu ta tsa gwaɗa ya, ka laghu tsi ka zaghuta diʼiŋ nda həŋ, ka ɗifaghuta. ");
INSERT INTO xed_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kulam nda tsa mazəmzəmha mamaga tsi ta wa ira taŋ ya, ka kwalaghutá həŋ ta zlghafta. ");
INSERT INTO xed_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mantsa ya dzaʼa kəl tsi ka nzakway taɓ ta gwaɗa manda ya mna anabi Isaya kazlay: «Mghama ɗa, wa ta zlghaftá gwaɗa ya gwaɗa ŋni? Wa maranaŋ Mgham Lazglafta ta mbrakwani?» ");
INSERT INTO xed_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Skwi kwal həŋ zlghafta ná, wya tsi ka Isaya mnata guli: ");
INSERT INTO xed_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Lazglafta ta ghulpiŋtá ira taŋ, ka təŋanaftá ghəŋa taŋ, ŋa kwala taŋ nghaŋta nda ira taŋ, ŋa kwala taŋ tsatsafta da mbəɗaktá həŋ ta vgha tvə iʼi ŋa mbanafta ɗa ta həŋ kəʼa,» ka Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ma tsa fitika nghaŋta Isaya ta glakwa Yesu ka mnə tsi ta gwaɗa ta ghəŋani ya, mnata tsi ta tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma va tsaya ná, mamu ndəghata la mali ta ghəŋa la Yahuda ta zlghaftá Yesu. Ama ka kwalaghutá həŋ ta maraŋtá ghəŋa taŋ, kabga zləŋa gwaɗa da la Farisa, da taliŋtá lu ta həŋ ma həga tagha skwa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Malaghumala ɗvafta taŋ ta ghubu da mnduha ka ya da Lazglafta. ");
INSERT INTO xed_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ka Yesu klaŋtá lwi mantsa: «Mndu ta zlghaftá iʼi, iʼi a zlghaf tsi wu, tsa mndu ta ghunigihata ya zlghaf tsi. ");
INSERT INTO xed_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mndu nda ngha ta iʼi, nda ngha ta mndu ta ghunigihata. ");
INSERT INTO xed_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iʼi ná, tsuwaɗak yu, ka saha yu ta ghəŋa haɗik kada kwala mndu ta zlghaftá iʼi da nzata ma grum. ");
INSERT INTO xed_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ka nda sna mndu ta gwaɗa mna yu, ka kwalaghutá tsi ta maga slna nda tsi katsi, iʼi a dzaʼa tsa guma ta ghəŋani wu, kabga sa a yu ta ghəŋa haɗik ŋa tsa guma wu, sasa yu ŋa mba mnduha ta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mndu ta vziɗta ka kwalaghutá tsi ta zlghaftá gwaɗa ɗa, dzaʼa tsanaghatsa lu ta guma. Tsa gwaɗaha gwaɗa yu ya dzaʼa tsanaghatá guma baɗu kɗakwa ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iʼi ná, gaghəŋ gaghəŋa ɗa a ta gwaɗa yu ta gwaɗa wa. Tsa Da ta ghunigihata ya ta mnihatá gwaɗa ŋa gwaɗay ɗa, nda ya ŋa ta taghay ɗa ŋa mnduha. ");
INSERT INTO xed_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nda sna yu kazlay: Skwi ta mnə tsi ná, ta vlay ta hafu ŋa kɗekedzeŋ kəʼa. Inda skwiha ta mnə yu ná, manda va skwi mniha Da ɗa ta mna yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ta kɗavakta fitik lu, gamahtsimani dzaʼa skala lu ta skala Pak. Nda sna Yesu kazlay: Saghasa fitik dzaʼa kəl tsi ka zlanatá na ghəŋa haɗik na, ka laghu da Da kəʼa. Ɗvuɗva tsatsi ta gwal ta zlghafta ma na ghəŋa haɗik na, haɗ kɗavakta ɗvutani ta həŋ wa. ");
INSERT INTO xed_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ka zə Yesu ta skwa zay nda duhwalhani gahawu. Nziya nza tsi, ghadaghada halaway ta hbutá Zudas zwaŋa Simuŋ Iskaryut ŋa skwaptá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nda sna Yesu ka ghəŋani kazlay: Sa daga da Lazglafta yu, dzaʼa vru da Lazglafta yu kəʼa. Nda sna guli kazlay: Fanamfa Lazglafta ta inda skwi ma dzvani kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ka sliʼavatá tsi ma tsa vla za skwi ya, ka suɗatá tsi ta lgutani, ka klaftá tsi ta ira gwada ka hbivta misti. ");
INSERT INTO xed_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka tamtá tsi ta imi ma glifiŋ, ka mbambazə tsi ta səla duhwalhani. Ka ta takaɗ tsi nda tsa ira gwada hbiv tsi misti ya kay. ");
INSERT INTO xed_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ka lagha tsi ta Simuŋ Piyer. Ka Simuŋ Piyer mantsa: «Mghama ɗa! Kagha ná, ŋa mbaza səla ɗa!» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","«Ta kɗa a snaŋta gha ta na skwi ta magə yu na karaku wu, dzaʼa nda sna ka dazlay,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","«Kadzeŋkadzeŋ, haɗ ka ta walaŋtá mbaza səla ɗa wu,» ka Piyer nda tsi. «Ka mbazagha a yu ta səla gha wu, haɗ ima gha ma iʼi wu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kaʼa mantsa: «Mghama ɗa! Səlaha ɗa kweŋkweŋ a dzaʼa ka mbazihata tama wu, nda dzvuha ɗa nda ghəŋa ɗa tani,» ka Simuŋ Piyer nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ka Yesu mantsa: «Ka nda mbazambaza mndu, haɗ ta zbəgəltá mbaza wa. Ba səlaha kweŋkweŋ dzaʼa mbambazanaghuta tsi, kabga tsuweɗaka vghani. Tsuweɗaka vgha ghuni, tsaw kaghuni demdem a wu,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nda sna Yesu ta mndu dzaʼa skwapta, tsaya kəl tsi ka mnay kazlay: Kaghuni demdem a tsuweɗaka wu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tahula mbambazanatani ta səlaha taŋ, ka suɗglavatá tsi ta lgutani, ka nzəgladatá ka zəgəltá skwi. Kaʼa nda həŋ mantsa: «Nda sna kuni ta tsa skwi magə yu ŋa ghuni ya ra? ");
INSERT INTO xed_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mndu ta tagha skwi” ŋaŋni ka, “mghama ŋni” ka, ka kuni ta hga iʼi. Ta ŋa ghuni tsaya, manda va tsaya yu. ");
INSERT INTO xed_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ka si iʼi ta nzakway ka mgham, mndu ta tagha skwi ŋa mndu, mbaza ghuna mbaza yu ta səla ya ní, kaghuni guli ŋa mbazay ghuni mantsa ta ŋa sani nda sani. ");
INSERT INTO xed_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Maraghunatá tsaya maraghuna yu, ŋa magay kaghuni guli manda tsa magaghuna yu ya. ");
INSERT INTO xed_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kahwathwata ka yu ta mnaghunata, haɗ kwalva ta malaghutá mghamani wu, haɗ mnda ghunay guli ta malaghutá mndu ta ghunafta wa. ");
INSERT INTO xed_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ka nda sna kuni ta tsaya, dzaʼa rfu kuni kata magay kuni ta slna nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nda kaghuni demdem a ta gwaɗa yu ta tsa gwaɗa ya wu, nda sna yu ta gwal zabap yu. Tsa gwaɗa nda vinda ma defteri ya ná, ɗina ka magatani mantsa. “Mndu ta zə ŋni ta skwa zay kawadaga nda tsi ta liɗista.” ");
INSERT INTO xed_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ka yu ta mnaghunata daga ndanana ma kɗaku skwi ka slata. Mantsa tama ka slasla skwi ya, ŋa zlghafta ghuni kazlay: “Iʼi ná, iʼi ya” kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kahwathwata ka yu ta mnaghunata, ka tsuʼaftsuʼa mndu ta mndu dzaʼa ghunafta yu katsi ná, iʼi tsuʼaf tsi. Ka tsuʼaftsuʼa tsi ta iʼi, tsuʼaftsuʼa guli ta mndu ta ghunigihata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tahula kɗiŋta Yesu ta mana tsa gwaɗaha ya, ka ghudzavaftá ŋuɗufani, kaʼa mantsa: «Kahwathwata ka yu ta mnaghunata, mamu sani ma kaghuni dzaʼa skwaptá iʼi,» kaʼa mnanaŋta həŋ baz. ");
INSERT INTO xed_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ghurghurghur, ka duhwalhani ka nanagha vgha taŋ. Sew sna a həŋ ka ta wa ta mna tsi wa. ");
INSERT INTO xed_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tsaw sani turtuk mataba duhwalhani, tsa ta mamə Yesu ya, tavata Yesu nzanavata tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","«Wa na mndu ta gwaɗə ka ta ghəŋani na na? ka ka ɗawaŋta da tsi ɓa?» ka Simuŋ Piyer nda tsi nda dzvu. ");
INSERT INTO xed_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mantsa ya tama, «Waya ní mghama ɗa,» ka tsa duhwal ya fadaghatá ghəŋ da ghuva Yesu ka ɗaway. ");
INSERT INTO xed_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ka Yesu mantsa: «Tsa mndu dzaʼa niʼagafta yu ta ndurzla ɗafa ka vlaŋta ya ná, vani tsaya,» kaʼa nda tsi. Ka niʼagaftá tsi ta ndurzla ɗafa ka vlaŋtá Zudas zwaŋa Simuŋ Iskaryut. ");
INSERT INTO xed_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na gi tsa zlghafta Zudas ta tsa ndurzla ɗafa ya, gi lama halaway dida tsa. «Maga misimmisim ta skwi ta kumə ka ta magay,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Haɗ mndu dər ka turtuk mataba tsa gwal ta nzata ka za skwi ya nda sna ka kabgawu kəl tsi ka mnay ŋani mantsa wa. ");
INSERT INTO xed_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zlah la skwaktá skwi ŋa za skalu, ka la valaŋtá skwi ta gwal ka pɗu a ka Yesu nda tsi, ka sanlaha ta ndanay, kabga da Zudas zliba tska skwa taŋ. ");
INSERT INTO xed_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na zlghafta Zudas ta tsa ndurzla ɗafa ya, ka gi sabə tsi dzibil. Rviɗik vli ta tsa luwa ya. ");
INSERT INTO xed_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tahula saghwa Zudas dzibil, ka Yesu mantsa: «Ndana na ŋlanafta lu ta Zwaŋa mndu. Ka ŋlanaftá lu ta Lazglafta guli nda ma tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ka nda ma tsatsi zlagigiŋta Lazglafta ta glakwani ya, dzaʼa marigiŋmara ma vərɗa tsatsi ta glakwa zwaŋ guli, dzaʼa gi magay ndana ndana. ");
INSERT INTO xed_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Zwana ɗa, ta ɓats yeya nzɗa ɗa kawadaga nda kaghuni, dzaʼa zbay kuni ta iʼi. Manda va ya mnana yu ta la Yahuda kazlay: Laviŋ a kuni ta ɓhata ma vli ta dzaʼa yu wu kəʼa ya, manda tsaya ta mnaghunaŋta yu ta kaghuni guli ndana. ");
INSERT INTO xed_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wana lfiɗa zlahu ta vlaghunata yu. Ɗvuwaɗva ta vgha ghuni sani nda sani. Manda va ya ɗvu iʼi ta kaghuni ya, ɗvuwaɗva kaghuni guli ta vgha ghuni sani nda sani. ");
INSERT INTO xed_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ka ta ɗvuɗva kuni ta vgha ghuni sani nda sani katsi, ta tsaya dzaʼa snaŋta mnduha kazlay: Duhwalha ɗa kuni kəʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ka Piyer mantsa: «Mghama ɗa! dzaʼa diga ka na?» kaʼa nda tsi. «Laviŋ a ka ta ɓhata da tsa vli ta dzaʼa yu ya ndanana wu, dazlay ya, dzaʼa ɓhaɓha ka mista ɗa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ka Piyer mantsa: «Mghama ɗa! kabgawu dzaʼa kwal yu laviŋtá ɓhata mista gha ndana na? Dər ŋa dzatá iʼi tsi, fafa yu ta vgha ɗa ka ŋa gha,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ka Yesu mantsa: «Va kahwathwata, fafa ka ta vgha gha ŋa ɗa ra? Kahwathwata ka yu ta mnaghata, ma kɗaku vazak wahata ná, hkən səla dzaʼa mnata ka kazlay: Sna a yu ta na mndu na wu, kəʼa nda iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ka Yesu nda duhwalhani kay guli mantsa: «Yaha ŋuɗufa ghuni da tɗu, fafwafa ta ghəŋa ghuni ta Lazglafta faf kuni guli ta ghəŋa ghuni ta iʼi. ");
INSERT INTO xed_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nda ndəgha vla nzaku ma həga ga Da ɗa, ka má haɗ tsi mantsa wu, má mnaghunamna yu. Dzaʼa nda sliʼa yu da payaghunatá vli. ");
INSERT INTO xed_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tahula laghwa ɗa ka payaghunatá vli, dzaʼa vragavra yu, ŋa hlay ɗa ta kaghuni tavata iʼi. Ŋa mutsafta kaghuni guli ta nzaku ma vli dzaʼa nzata iʼi, kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Wya nda sna kaghuni ta vli ta dzaʼa yu, nda sna kuni ta tvi guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ka Tuma mantsa: «Mghama ɗa, sna a ŋni ta vli ta dzaʼa ka wu, waka aŋni dzaʼa snaŋtá tvi?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ka Yesu nda tsi mantsa: «Iʼi tvi, iʼi kahwathwata, iʼi hafu. Haɗ mndu dzaʼa laviŋtá lami da həga ga Da, ka nza a tsi nda tvə iʼi wa. ");
INSERT INTO xed_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ka nda sna kuni ta iʼi dzaʼa nda sna kuni guli ta Da ɗa. Ndanana ná, nda sna kuni, nda ngha kaghuni guli,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ka Filip mantsa: «Mghama ɗa! Maraŋnamara ta tsa Da ya, ka zɗafta ŋuɗufa ŋni,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ka Yesu nda tsi mantsa: «Nda kɗa fitika ɗa kawadaga nda kaghuni Filip ná, ta sna a ka ta iʼi ra? Ka nda ngha mndu ta iʼi ná, nda ngha ta Da. Waka ka dzaʼa mnay kazlay: Maraŋnamara ta Da kəʼa na? ");
INSERT INTO xed_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Zlghaf a ka kazlay: Ta nzaku ma Da iʼi, Da guli ta nzaku ma iʼi kəʼa ra? Nana gwaɗaha ta mnaghunata yu na ná, ma ghəŋa ɗa a ta klaʼata yu wa. Tsa Da ta nzaku ma iʼi ya ta maga tsa slnaha ya. ");
INSERT INTO xed_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Fafwa fa ta ghəŋa ghuni ta skwi ta mnaghunata yu kazlay: Iʼi ta nzaku ma Da, Da guli ta nzaku ma iʼi kəʼa ya. Fafwafa ta ghəŋa ghuni dər ta ghəŋa tsa slnaha yeya tsi. ");
INSERT INTO xed_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kahwathwata ka yu ta mnaghunata, mndu ta zlghaftá iʼi, dzaʼa magay tsatsi guli ta slna ta magə yu. Dzaʼa magay ka malaghuta kabga nda sliʼa iʼi da Da ɗa. ");
INSERT INTO xed_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mantsa tama, inda skwi dzaʼa kuni ɗawaŋta nda hga ɗa, dzaʼa magay yu, kada maraŋta Da ta glakwani nda ma zwaŋ. ");
INSERT INTO xed_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ka ɗawaŋɗawa kuni ta sana skwi nda hga ɗa, dzaʼa magay yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Ka ɗvuɗva kuni ta iʼi, dzaʼa snasna kuni ta zlahuha ɗa. ");
INSERT INTO xed_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iʼi, dzaʼa ɗaway yu da Da ta sana mndu ŋa ghunəgaghunatani ŋa nzatani ŋa ɗekɗek kawadaga nda kaghuni ŋa kata kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tsa mndu ya ná, Sulkuma kligiŋtá kahwathwata ya. Laviŋ a mndu ma ghəŋa haɗik ta tsuʼafta wa. Laviŋ a həŋ ta snaŋta guli wa. Kaghuni nda sna kaghuni, kabga ta gɗata kawadaga nda kaghuni, dzaʼa gɗavagɗa ŋa ɗekɗek ma ŋuɗufa ghuni. ");
INSERT INTO xed_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iʼi, zlaghunata a yu manda zwana tawakri wu, dzaʼa vragaghavra yu da kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ta ɓats nzɗa ɗa, nghaŋta a mnduha ma ghəŋa haɗik ta iʼi wa. Kaghuni ya, dzaʼa nda ngha kuni ta iʼi, kabga ta nzakw nda hafu iʼi, dzaʼa nzata nda hafu kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Baɗu tsaya dzaʼa snaŋta kuni kazlay: Ta nzaku ma Da iʼi, ta nzaku ma iʼi kaghuni, iʼi guli ta nzaku ma kaghuni yu kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ka ŋanaŋa mndu ta zlahuha ɗa ka snata, tsaya mndu ta ɗvutá iʼi. Dzaʼa ɗvuɗva Da ɗa ta tsa mndu ta ɗvutá iʼi ya. Iʼi guli dzaʼa ɗvuɗva yu ŋa maranaŋta ɗa ta nzakwa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","«Kinawu ka kagha dzaʼa maravata da aŋni, kul maravata ka da mnduha ta ghəŋa haɗik na?» ka Zuda, Zudas Iskaryut ya a wa. ");
INSERT INTO xed_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ka Yesu nda tsi mantsa: «Ka ɗvuɗva mndu ta iʼi, dzaʼa ŋanaŋa ta gwaɗa ɗa, dzaʼa ɗvuɗva Da ɗa ta tsatsi guli. Ŋa sagha ŋni nda Da ɗa tani ŋa nzakwa ŋni ga taŋ. ");
INSERT INTO xed_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ka ɗvu a mndu ta iʼi wu katsi, ŋana a ta gwaɗa ɗa wu, nana gwaɗa ta mnaghunata yu ta snə kuni na ná, kla a ma ghəŋa ɗa a yu wu, tsa Da ɗa ta ghunigihata ya ta mnihata. ");
INSERT INTO xed_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Mnaghunamna yu ta tsaya ta wana yu kawadaga nda kaghuni na. ");
INSERT INTO xed_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tsa mnda kata mndu dzaʼa saha ya, Sulkum nda ghuɓa ya dzaʼa ghunagata Da nda hga ɗa. Tsatsi dzaʼa taghaghunaftá inda skwi, ŋa havaghunaktá inda gwaɗa managhuna yu. ");
INSERT INTO xed_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Zɗaku ya ta zlaghunaŋta yu. Zɗakwa ɗa ya ta vlaghunata yu. Vla a yu ŋa ghuni manda ya ta vlə mnduha ma ghəŋa haɗik wa. Yaha ŋuɗufa ghuni da tɗu, yaha kuni da zləŋ. ");
INSERT INTO xed_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nda sna kuni ta gwaɗa mnaghuna yu kay, “nda sliʼa yu, dzaʼa vragaghavra yu da kaghuni.” Ka ta ɗvay kuni ta iʼi katsi ná, dzaʼa rfay kuni ta rfu ta ghəŋa má snaŋta ghuni kazlay: Nda sliʼa yu da Da kəʼa, kabga mal Da ka iʼi. ");
INSERT INTO xed_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wana yu ta mnaghunatá tsa skwiha ya ndanana ma kɗaku həŋ ka slata, kada zlghafta kuni ta skwi ta mnaghunata yu, slarə tsi. ");
INSERT INTO xed_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Haɗ gwaɗa ta dagala ta ŋa mnaghunata ɗa wu, kabga wya tsa ghwaɗaka mghama na ghəŋa haɗik na ya ta sagha. Tsaw laviŋ a ta ŋraptá iʼi wa. ");
INSERT INTO xed_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ɗina ka snaŋta mnduha ta ghəŋa haɗik kazlay: Ɗvuɗva yu ta Da kəʼa. Inda skwiha ta magə yu guli ná, manda va ya mniha Da ta maga yu. Sliʼafwasliʼa hadna mbaɗma,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Iʼi vərɗa fwa inabi, Da ɗa mnda hvay. ");
INSERT INTO xed_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Inda dzva fu ta dzuslafta ta iʼi, kul haɗ ta yaku ná, ta tsiŋtsa. Inda dzva fu ta dzuslafta ta iʼi ta yaku guli na, ta slaɗafslaɗa ŋa sgəglavaghata yakwani. ");
INSERT INTO xed_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ghadaghada tsa gwaɗa ta mnaghunata yu ya ta slaɗaftá kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gɗavawagɗa nda ndiʼatá vgha ta iʼi manda ndiʼatá iʼi nda kaghuni ya. Laviŋ a dzva fu ta yafta ka ndiʼa a tsi ta dughwaŋ wa. Mantsa kaghuni guli, laviŋ a kuni ta magatá sana skwi ka gɗava a ndiʼatá kaghuni ta iʼi wa. ");
INSERT INTO xed_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Iʼi fwa inabi, kaghuni dzvuhani, mndu ta gɗavata ndiʼatani ta iʼi manda iʼi nda tsatsi ya, dzaʼa yaf ya tsatsi rgədzəɓ. Ka haɗ iʼi wu, laviŋ a kuni ta magatá sana skwi wa. ");
INSERT INTO xed_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ka gɗava a ndiʼatá mndu ta iʼi ná, dzaʼa wuɗidiŋ wuɗa lu manda dzva fu ŋa ghwalutani, ŋa hlaftá tsa dzvuhani ya, ka pghamta ma vu, ŋa drutani. ");
INSERT INTO xed_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ka gɗavagɗa ndiʼatá kaghuni ta iʼi, ka gɗavagɗa gwaɗa ɗa guli ma kaghuni katsi, ɗawawaɗawa ta inda skwi ta kumə kuni, dzaʼa mutsay kuni. ");
INSERT INTO xed_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ka rgədzəɓ ta yafta kuni ta maray kuni kazlay: Duhwalhani aŋni kəʼa, tsaya dzaʼa maraŋtá glakwa Da ɗa. ");
INSERT INTO xed_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ɗvuɗva iʼi ta kaghuni manda va ya ɗvu Da ɗa ta iʼi ya. Gɗavawagɗa ma ɗvutá mnda ɗa. ");
INSERT INTO xed_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ka ta snasna kuni ta zlaha ɗa, dzaʼa gɗavagɗa kuni ma ɗvutá mnda ɗa. Manda tsaya snata iʼi ta zlaha Da ɗa, kəl iʼi ka gɗavata ma ɗvutá mndani. ");
INSERT INTO xed_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Mnaghunamna yu manda va tsaya kada yifafta rfa ɗa ma kaghuni, ŋa ndəghafta rfa kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wya zlaha ɗa ta mnaghunata yu, ɗvuwaɗva ta vgha ghuni sani nda sani manda va ya ɗvu iʼi ta kaghuni ya. ");
INSERT INTO xed_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Haɗ sana ɗvutá mndu ta malaghuta ta ghəŋa vlata mndu ta hafani ŋa grahani wa. ");
INSERT INTO xed_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ka ta magay kuni ta skwi ta mnaghunata yu ná, nda nza kuni ka graha ɗa. ");
INSERT INTO xed_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Hgəgla a yu ta kaghuni ka kwalvaha wu, kabga sna a kwalva ta skwi ta magə daŋahəgani wa. Graha ɗa ta hga iʼi ta kaghuni, kabga inda skwi taghaf yu da Da ɗa ná, snaghunamsna yu. ");
INSERT INTO xed_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kaghuni a ta zbaptá iʼi wu, iʼi ta zabaptá kaghuni, ka faghunaghatá slna ŋa magay, ŋa yafta ghuni, ŋa gɗavata tsa yakwa ghuni ya. Mantsa tama, dzaʼa vlaghunavla Da ɗa ta inda skwi dzaʼa kuni ɗawaŋta nda hga ɗa. ");
INSERT INTO xed_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Skwi ta mnaghunata yu ná, ka ɗvuta kuni ta vgha ghuni sani nda sani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ka Yesu mantsa: «Ka ta husaŋhusa kuni ta mnduha ta na ghəŋa haɗik na katsi, tiŋəl iʼi ta husaŋtá həŋ ka kaghuni. ");
INSERT INTO xed_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ka má ŋa na ghəŋa haɗik na ka ghuni katsi, má dzaʼa ɗvafɗva mnduha ta na ghəŋa haɗik na ta kaghuni, kabga ŋa taŋ kuni mazlay. Zabapzaba yu ta kaghuni, ka hligiŋtá kaghuni mataba mnduha ta ghəŋa haɗik. Ta ka ŋa mnduha ta ghəŋa haɗik a kaghuni wu, kəl kuni ka husaŋtá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Havakwahava ta gwaɗa mnaghuna yu. “Malaghumala a kwalva ka Maləmani wa.” Ka si ghuyɗipghuya mnduha ta ɗaŋwa, dzaʼa ghuyay həŋ ŋa kaghuni guli. Ka si snasna həŋ ta gwaɗa ɗa, dzaʼa snay həŋ ta ŋa ghuni guli. ");
INSERT INTO xed_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ta gwaɗa ta iʼi dzaʼa maga həŋ ta tsaya ŋa ghuni, kabga sna a həŋ ta mndu ta ghunigihata wa. ");
INSERT INTO xed_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ka má sna a yu wu, ka má haɗ gwaɗa walaŋ yu ta mnanatá həŋ wu, má haɗ dmakwa taŋ wa. Ndanana tama, lavgliŋ a həŋ ta mnay kazlay: Haɗ dmakwa ŋni wu kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ka ta husaŋhusa yu ta mndu, ta husaŋhusa Da ɗa ta tsa mndu ya guli. ");
INSERT INTO xed_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ka má maga a yu mataba taŋ ta slnaha ya kul walaŋtá sani ma mndu ta magata wu katsi, má haɗ dmakwa taŋ wa. Ndanana, nda ngha həŋ ta slnaha ɗa, ka husaŋtá yu ta həŋ nda Da ɗa tani. ");
INSERT INTO xed_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tsaw slasla tsaya mantsa ya, ŋa nzakwa tsa gwaɗa nda vinda ma deftera zlaha taŋ ta mnay kazlay: Ka bətbət husaŋta yu ta həŋ kəʼa ya, manda va tsaya nzakwani. ");
INSERT INTO xed_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Tsa mnda kata kaghuni dzaʼa saha ya, Sulkum ta kligiŋtá kahwathwata ya dzaʼa saha daga da Da. Dzaʼa mnay ta gwaɗa ta iʼi. ");
INSERT INTO xed_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kaghuni guli, dzaʼa mnay kuni ta gwaɗa ta iʼi, kabga kawadaga kuni nda iʼi, daga ka yawu zlrafta mu ta nzaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ka Yesu mantsa: «Managhuna mana yu ta tsa skwiha ya, kada kwala kuni zlanavatá zlghay nda ŋuɗufa ghuni. ");
INSERT INTO xed_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dzaʼa taliŋtala lu ta kaghuni ma həga tagha skwa la Yahuda. Tsaya ya a vani wu, ta saghasa fitik dzaʼa kəl mnduha dzaʼa pslatá kaghuni ka ndanay kazlay: Na skwi maga mu na ná, magamaga mu ta skwi ta zɗəganatá Lazglafta kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mantsa ya dzaʼa maga həŋ, kabga sna a həŋ ta dər Da, dər iʼi wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kaʼa guli mantsa: «Ka saghasa tsa fitik ya, dzaʼa havakhava kuni ta skwiha managhuna yu. Tsaya kəl yu ka managhunatá tsahaya. Ta kawadaga yu nda kaghuni kwal yu ka mnaghunata daga taŋtaŋ. ");
INSERT INTO xed_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ndanana dzaʼa da mndu ta ghunigiha yu. Sew haɗ ya mataba ghuni ta ɗaway kazlay: Dzaʼa da wa ka na kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ama ma mnaghunaŋta ɗa, ka gurɗutá ŋuɗufa ghuni. ");
INSERT INTO xed_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kahwathwata na skwi ta mnaghunata yu na. Mal ma na laghwi dzaʼa laghu yu na kata ta kaghuni. Ka laghu a yu wu, sata a tsa mndu dzaʼa kata kaghuni ya da kaghuni wa. Ka laghula yu, dzaʼa ghunəgaghuna ghuna yu. ");
INSERT INTO xed_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ka sasa tsi, dzaʼa mnanamna ta mnduha ta ghəŋa haɗik ta krughuva taŋ ta ghəŋa skwi ka dmaku nda ya ta ghəŋa skwi tɗukwa, nda ya ta ghəŋa skwi ka guma. ");
INSERT INTO xed_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ta nanay mnduha ta ghəŋa haɗik ta ghəŋa taŋ ta ghəŋa skwi ka dmaku, kabga kwala taŋ kul zlghaftá iʼi. ");
INSERT INTO xed_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta nanay mnduha ta ghəŋa haɗik ta ghəŋa taŋ ta ghəŋa skwi tɗukwa, kabga nda sliʼa iʼi da Da, nghəglaŋta a kuni ta iʼi wa. ");
INSERT INTO xed_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta nanay mnduha ta ghəŋa haɗik ta ghəŋa taŋ ta ghəŋa skwi ka guma, kabga nda ghada tsanaghatá guma ta ghwaɗaka mghama na ghəŋa haɗik na. ");
INSERT INTO xed_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Ta dagala skwi má ŋa managhunata ɗa, tsaw laviŋta a kuni ta ŋafta ndana wa. ");
INSERT INTO xed_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ka sasa tsa Sulkum ta mnigiŋtá kahwathwata ya, dzaʼa snaghunamsna ta inda kahwathwata. Gwaɗa ma ghəŋani a dzaʼa klaʼata tsi ka mnay wa. Inda skwi dzaʼa snaŋta tsi, dzaʼa tsi mnay, ŋa mnaghunatani ta skwi dzaʼa slaku ta kəma. ");
INSERT INTO xed_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tsatsi dzaʼa maraŋtá glakwa ɗa, kabga skwi da iʼi dzaʼa tsuʼafta tsi ŋa mnay ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inda skwa Da ɗa ná, ŋa ɗa ya. Tsaya kəl yu ka mnaghunata kazlay: Skwi da iʼi dzaʼa klafta tsi ŋa mnay ŋa ghuni kəʼa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kaʼa guli mantsa: «Ta ɓets nzɗa, nghəglaŋta a kuni ta iʼi wa. Ɓats nzɗa guli, dzaʼa nghəglaŋngha kuni ta iʼi kabga nda sliʼa yu da Da,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ka sanlaha ma duhwalhani mataba hahəŋ hahəŋ mantsa: «“Ta ɓets nzɗa nghəglaŋta a kuni ta iʼi wu, ɓats nzɗa guli ná, dzaʼa nghəglaŋngha kuni iʼi guli. Nda sliʼa yu da Da,” kaʼa ná, gwaɗa wu tsa gwaɗa ya ta gwaɗamata tsi na?» ");
INSERT INTO xed_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«“Ta ɓets nzɗa” kaʼa ya ní, nu ghəŋ tsaya ma gwaɗa tama? Sana a amu ta skwi ta kumə tsi ta mnay wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ɗaslafta Yesu ta skwi ta kumə həŋ ta ɗaway da tsi, kaʼa nda həŋ mantsa: «Ta ɗaɗawavustá kuni mataba ghuni ta ghəŋa skwi mnə yu kazlay: Ta ɓets nzɗa nghaŋta a kuni ta iʼi wu, ɓats nzɗa guli, dzaʼa nghəglaŋ ngha kuni ta iʼi kəʼa ya ra? ");
INSERT INTO xed_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kahwathwata ka yu ta mnaghunata, dzaʼa taway kuni ta taw, dzaʼa ŋaɗay kuni ta ghəŋ, ta rfu mnduha ta ghəŋa haɗik ta rfu. Dzaʼa gurɗaku ŋuɗufa ghuni, ŋa nutá tsa gurɗatá ŋuɗufa ghuni ya ka rfu. ");
INSERT INTO xed_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ka saghasa fitika dgakwa marakw ná, ta ghuyay ta ɗaŋwa ta ɓasay. Na gi yatani ta tsa zwaŋ ya, gi zanaptani ta tsa ghuya ɗaŋwani ya. Ta rfay ta rfu katakata, kabga nghaŋtani ta mnda səla ta saha ta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mantsa ya ta ɓasa kaghuni ndanana guli. Tsaw ta dzaʼa guyaku amu, ŋa rfay ghuni ta rfu. Haɗ mndu dzaʼa laviŋtá klaghutá tsa rfu ya da kaghuni wa. ");
INSERT INTO xed_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Ka saghasa tsa fitik ya, haɗ kaghuni dzaʼa ɗawaŋta skwi nda ɗawa da iʼi wa. Kahwathwata ka yu ta mnaghunata, dzaʼa vlaghunavla Da ta inda skwi. Dzaʼa kuni ɗawaŋta nda hga ɗa. ");
INSERT INTO xed_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kulam gwatna haɗ sana skwi ta kɗə ɗawaŋta kuni nda hga ɗa wa. Ɗawawaɗawa dzaʼa mutsay kuni, kada ndəghafta ŋuɗufa ghuni da rfu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kaʼa guli mantsa: «Ka mahdihdi mnaghunata yu ta tsa gwaɗa ya. Dzaʼa saghasa fitik dzaʼa kwal yu mnəgəlta mantsa ŋa ghuni, ŋa mnaghunaŋta ɗa ta skwi tsiɗiɗ ta ghəŋa Da. ");
INSERT INTO xed_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ma tsa fitik ya, kaghuni ka ghəŋa ghuni dzaʼa ɗawa skwi da Da nda hga ɗa, dər maga a iʼi ta duʼa da tsi ŋa ghuni. ");
INSERT INTO xed_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Vərɗa Da kaghəŋani ná, ta ɗvay ta kaghuni kabga ta ɗvay kaghuni ta iʼi. Grafgra kaghuni guli kazlay: Iʼi ná, sa daga da Lazglafta yu kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Sliʼaf daga da Da iʼi ka saha ta ghəŋa haɗik. Ndanana guli, wana yu ta sliʼafta ta ghəŋa haɗik ka vru da Da,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ka duhwalhani mantsa: «Haɗ mahdihdi ma na tama wa. Wya zlra ka ta kligiŋtá ghəŋa gwaɗa. ");
INSERT INTO xed_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndanana tama, nda sna ŋni kazlay: Nda sna ka ta inda skwi kəʼa. Ma kɗaku mndu ka ɗawaŋtá skwi da kagha, nda sna kagha ta skwi ta kumə tsi ta ɗaway. Tsaya kəl aŋni ka zlghafta kazlay: Sa daga da Lazglafta kagha kəʼa,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ka Yesu nda həŋ mantsa: «Ndanana zlra kaghuni ta zlghafta ɓa? ");
INSERT INTO xed_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wya fitik ta sagha, nda ghada va saghani katək ŋa wutsata ghuni ta vgha, ta ksə ya ta tvani ta ksə ya ta tvani, ŋa zliɗivata ghuni turtukwa ɗa. Tsaw kahwathwata ná, turtukwa ɗa a yu wu, kabga kawadaga ŋni nda Da. ");
INSERT INTO xed_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Managhunamana yu ta inda tsaha ya, kabga ŋa mutsafta ghuni ta zɗaku ma nzakwa guyata vgha ghuni nda iʼi. Dzaʼa ghuyay mnduha ta ghəŋa haɗik ta ɗaŋwa ŋa ghuni. Ka nzata kuni drusa. Iʼi, ghuɓasapghuɓasa yu ta mbrakwa na ghəŋa haɗik na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tahula gwaɗata Yesu ta tsa gwaɗaha ya, ka nghadaftá tsi nda ta luwa. Kaʼa mantsa: «Da, nda maga fitik! Maraŋmara ta glakwa zwaŋa gha ŋa maraŋta zwaŋa gha guli ta glakwa gha. ");
INSERT INTO xed_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vlaŋvla ka ta mbraku ta ghəŋa inda mnda səla, ŋa vlaŋtani ta hafu ŋa kɗekedzeŋ ta gwal pgham ka ta həŋ ma dzvani. ");
INSERT INTO xed_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hafu ŋa kɗekedzeŋ ná, tsaya snaŋta taŋ ta kagha. Kagha vərɗa Lazglafta turtuktuk, nda snaŋta taŋ ta mndu ya ghunaga ka ta nzakway ka Yesu Kristi. ");
INSERT INTO xed_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Maraŋmara yu ta glakwa gha ta ghəŋa haɗik, kɗiŋkɗa yu ta magatá slna ya vliha ka ŋa magay. ");
INSERT INTO xed_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndanana tama Da ná, ŋliɗif ŋla da kagha manda nzatá nzakwa ɗa si ta kul zlraftá ghəŋa haɗik ya. ");
INSERT INTO xed_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Snanamsna yu ta hga gha ta gwal hligiŋ ka ma ghəŋa haɗik ka vlihata ya. Si ka ŋa gha həŋ, ka hlaftá ka ta həŋ ka vlihata. Ka snatá həŋ ta gwaɗa gha. ");
INSERT INTO xed_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndanana ná, nda sna həŋ kazlay: Inda skwi ya vliha ka ná, sagha da kagha kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mnanamna yu ta həŋ ta gwaɗa ya mniha ka, tsuʼaftsuʼa həŋ. Nda sna həŋ dar kazlay: Daga da kagha sagha yu kəʼa, zlghafzlgha həŋ guli kazlay: Kagha ta ghunigihata kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Ta ghəŋa hahəŋ ta maga yu ta duʼa, maga a yu ta duʼa ta ghəŋa pɗakwa mnduha ma ghəŋa haɗik wa. Ta ghəŋa hahəŋ ta maga yu ta duʼa, kabga ŋa gha həŋ. ");
INSERT INTO xed_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Inda tsaha ta nzakway ka ŋaɗa ya ná, ŋa gha həŋ. Inda tsaha ta nzakway ka ŋa gha ya guli ná, ŋa ɗa həŋ. Ta maravamara glakwa ɗa ma həŋ. ");
INSERT INTO xed_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«Ta haɗ iʼi ma ghəŋa haɗik wa. Hahəŋ ná, tata ghəŋa haɗik həŋ. Ta dzaʼa da kagha iʼi. Da ɗa, kagha ta nzakway nda ghuɓa, ŋanaŋa ta həŋ nda mbrakwa gha. Nda mndərga tsa mbraku vliha ka ya, kada nzakwa həŋ ka mndu turtuk manda nzakwa u ka mnda turtuk ya. ");
INSERT INTO xed_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma tsa nzakwa ɗa kawadaga nda həŋ ma ghəŋa haɗik ya ná, si ta nghay yu ta həŋ nda mbrakwa gha ya vliha ka. Ŋanaŋa yu ta həŋ, haɗ ya ta zaɗavaghuta wu, ba ya ta nzakway nda fa ŋa zwaɗuta, ŋa kɗiŋtá skwi ya nda vinda ma defteri yeya ta zaɗapta. ");
INSERT INTO xed_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ndanana dzaʼa da kagha yu. Manda tsaya ta mna yu ma na nzakwa ɗa tata ghəŋa haɗik na, kada ndəghafta rfa ɗa ma həŋ. ");
INSERT INTO xed_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mnanamna yu ta gwaɗa gha ta həŋ. Tsaya kəl həŋ ka husaŋtá mnduha ma ghəŋa haɗik, manda nzakwa iʼi kul haɗ ka ŋa ghəŋa haɗik ya. ");
INSERT INTO xed_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ndəɓa a yu ta dzvu da kagha ŋa hlaptá həŋ ma ghəŋa haɗik wa. Ama nghay yeya dzaʼa ka ngha həŋ da katkata tsa ghwaɗak ya. ");
INSERT INTO xed_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Manda nzakwa iʼi kul haɗ ka ŋa ghəŋa haɗik ya ná, manda tsaya nzatá nzakwa hahəŋ, nza a həŋ ka ŋa ghəŋa haɗik wa. ");
INSERT INTO xed_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Niŋna ta həŋ ka ŋa gha, nda ma kahwathwata. Gwaɗa gha ná, kahwathwata nzakwani. ");
INSERT INTO xed_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Manda ya ghunaga kagha ta iʼi ta ghəŋa haɗik ya, iʼi guli, ta ghunay yu ta hahəŋ ta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iʼi faghafa yu ta ghəŋa ɗa ka ŋa taŋ, kada nzakwa hahəŋ guli ka ŋa gha kahwathwata. ");
INSERT INTO xed_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ta ghəŋa na hahəŋ na yeya a ta maga yu ta duʼa wu, ta magay yu ta duʼa guli ta ghəŋa gwal dzaʼa zlghafta iʼi nda ma gwaɗa taŋ, ");
INSERT INTO xed_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","kada nzakwa həŋ demdem ka mnda turtuk. Da! Ka nza həŋ ka yakwa u manda guyatá u, kagha ma iʼi, iʼi ma kagha ya. Ka nza həŋ ka mnda turtuk ŋa mnay mnduha ma ghəŋa haɗik kazlay: Kagha ta ghunigihata kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","«Iʼi, ŋlanafŋla yu ta həŋ, manda tsa ŋliɗifta kagha ya, kada nzakwa həŋ ka mndu turtuk, manda nzakwa u ka mndu turtuk, ");
INSERT INTO xed_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","iʼi ma hahəŋ, kagha ma iʼi ya. Manda tsaya dzaʼa kəl həŋ ka nzakway kahwathwata ka mndu turtuk, kada snaŋta mnduha ma ghəŋa haɗik kazlay: Kagha ta ghunigihata, ɗvuɗva kagha ta həŋ manda ya ɗvu kagha ta iʼi guli ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Da! Tsəna mnduha vliha ka na ná, ta kumay yu ta nzakwa taŋ ma vli ya nza iʼi, ŋa nghay taŋ ta glakwa ɗa ya vliha kagha, kabga ɗvuɗva ka ta iʼi daga ta kul zlraftá ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Da ɗa! Tuɗukwa nzakwa kagha, tsaw sna a mnduha ma ghəŋa haɗik ta kagha wa. Iʼi, nda sna yu ta kagha, na hana guli, tsatsaftsatsa həŋ kazlay: Kagha ta ghunigihata kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Snanamsna yu ta kagha ta həŋ, ta dzaʼa snəglanamsna yu ta həŋ, kada nzamta tsa ɗvu ɗvaf ka ta iʼi ya ma həŋ, ŋa nzamta iʼi ma həŋ guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tahula kɗiŋta Yesu ta tsa gwaɗaha ya, ka sliʼaftá tsi nda duhwalhani ka laghwi ta ɓla lika Sedruŋ. Mamu sana kwambalu mantsa vli ya, ka lamə tsi dida kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nda sna tsa Zudas ta dzaʼa skwapta ya guli ta tsa vli ya, kabga snusna Yesu ta lagha da tsa vli ya kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ka hlanaftá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la Farisa ta sludziha, nda gwal ta ngha həga Lazglafta, ta Zudas. Ka sliʼaftá həŋ nda huzla vulu nda huzla vulu, nda pelapela nda pelapela, nda pinatá vu nda pinatá vu. Ka lagha həŋ da tsa gam ya. ");
INSERT INTO xed_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Manda ya nda sna Yesu ta skwi dzaʼa slanaghata, ka sliʼaftá tsi da gəma həŋ. Kaʼa mantsa: «Wa ta zbə kuni na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ka həŋ mantsa: «Yesu mnda la Nazaret ya ta zbə ŋni,» ka həŋ nda tsi. «Iʼi nana,» kaʼa nda həŋ. Ta sladu tsa Zudas ta dzaʼa skwapta ya kay tavata həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na tsa mnay Yesu nda həŋ kazlay: Iʼi nana kəʼa ya, dəm turtuk ka həŋ vraghuta nda ga muhul hul, ka zlambutá həŋ siy ta haɗik. ");
INSERT INTO xed_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","«Wa ta zbə kuni ka kuni ka na?» kaʼa ɗawglaŋta da həŋ. «Yesu mnda la Nazaret ya ta zbə ŋni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","«Vaɗa nana a ka yu nda kaghuni kay ra! Ka si iʼi ta zbə kuni ya ní, zlanawa nanaha na tsa, ka laghwa hahəŋ,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kəl tsi ka mnay mantsa ya ná, ŋa nzakwani manda va tsa gwaɗa mnə tsi kazlay: Haɗ ya dər turtuk zaɗanaghu yu mataba gwal ya vliha ka wu kəʼa ya, ya. ");
INSERT INTO xed_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mamu kafay da Simuŋ Piyer, ka tsəhagaptá tsi ka tsanamtá sani ma kwalva mali ta ghəŋa gwal dra skwi ŋa Lazglafta, ka tsaghutá sləməŋani nda ga zeghwi. Malkus hga tsa kwalva ya. ");
INSERT INTO xed_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ka Yesu mantsa: «Vranamvra ta kafaya gha da kupakani. Ra a ka say ɗa ta leghwa ghuya ɗaŋwa ya vliha Da ɗa wu ka ka rki na?» kaʼa nda Piyer. ");
INSERT INTO xed_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lagha tsa tskatá sludziha ya nda mghamha taŋ tani, nda la Yahuda ta ngha həga Lazglafta ya, ka ksaftá Yesu, ka habaghutá həŋ ta dzvuhani. ");
INSERT INTO xed_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ka klaghatá karaku da Hana ta nzakway ka dzidza Kayifa. Tsa Kayifa ya ta nzakway ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta ma tsa vaku ya. ");
INSERT INTO xed_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tsa Kayifa ya tsa ta vlaŋtá hiɗaku ta la Yahuda kazlay: Draŋ mtuta mndu turtuk da mnaka mnduha, ka ya da zaɗanata lu ta inda mndəra mndu kəʼa ya kay. ");
INSERT INTO xed_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ka sliʼaftá i Piyer nda sna duhwal, ka dzaʼa ta hula Yesu ta hula Yesu. Tsa sana duhwal ya ná, nda sna tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya. Ka lamə tsi mista Yesu da daɓi ma huɗa həga ga tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya, ");
INSERT INTO xed_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ta sladaghutá Piyer ma bli ta watgha. Ka vragaptá va tsa duhwal snaŋ mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya, da gwaɗganatá tsa marakw ta ngha watgha ya. Ka hgadamtá tsi ta Piyer. ");
INSERT INTO xed_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kaʼa nda tsi mantsa: «Tekw a kagha mataba duhwalha tsəna mndu na guli wu ri?» ka tsa marakw ka kwalva ta ngha watgha ya nda Piyer. «Tekw a iʼi mataba taŋ wu,» ka Piyer. ");
INSERT INTO xed_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ka vanaghatá kwalvaha nda gwal ta ngha həga Lazglafta ta vu, ka slinə həŋ, kabga mtasl vli. Ka lagha Piyer guli da slinganatá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kaʼa nda tsi mantsa: «I wa duhwalha gha na? Nahgani ta taghə ka ŋa mnduha na?» ka tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya, nda Yesu. ");
INSERT INTO xed_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ka Yesu nda tsi mantsa: «Baŋluwa si ta mna yu ta gwaɗa ŋa inda mndu ma həga tagha skwa la Yahuda nda ya ma həga Lazglafta. Ma vli ta tskavata inda la Yahuda si ta gɗata yu ta tagha skwiha. Haɗ sana skwi mna yu kɗekkɗek wa. ");
INSERT INTO xed_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kabgawu ta kəl kagha ka ɗaway da iʼi na? Ɗawa da gwal si ta sna tsa skwi ta mnə yu ŋa taŋ ya ɓa. Nda sna hahəŋ ɗinaɗina ta skwi mnana yu ta həŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na tsa mnata Yesu mantsa ya, ka sliʼaftá sani mataba tsa gwal ta ngha həga Lazglafta ya, ka lagha dgharuŋtá Yesu. «Mantsa ta zlgha ka ta wi ŋa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ka Yesu mantsa: «Ka mamu ghwaɗaka skwi mna yu ya kay, mnamaŋmna. Ala ka si tɗukwa gwaɗa mna yu, kabgawu ta kəl lu ka dza iʼi na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ka ghunaftá Hana nda va tsa habatá dzvuhani ya da tsa Kayifa ta nzakway ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya. ");
INSERT INTO xed_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma tsa fitik ya, hada Simuŋ Piyer ta slinutá vwani. «Tekw a kagha mataba duhwalha tsəna mndu na guli wu ri?» ka lu nda tsi. «Siga! haɗ iʼi mataba taŋ wu,» ka Piyer ka waɗutá vli. ");
INSERT INTO xed_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","«Ngha a yu ta kagha kawadaga nda tsəna mndu na ma gam ra?» ka sani mataba kwalvaha tsa mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya. Tsatsi ná, la taŋ ma tsa mndu tsanaghu Piyer ta sləməŋani ya, ya. ");
INSERT INTO xed_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","«Siga yu, iʼi a wu!» ka Piyer ka waɗutá vli kay guli. Ka gi wahatá vazak. ");
INSERT INTO xed_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gasərɗək, ka klaftá həŋ ta Yesu ga Kayifa, ka klaghata da həga dagala ga ŋumna la Ruma. Lamə a vərɗa hahəŋ da tsa həga ya wu, da ŋriŋtá həŋ ta vgha taŋ makəɗ həŋ ka za skala Pak. ");
INSERT INTO xed_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tsaya kəl Pilat ŋumna la Ruma ka sabi dzibil da slanaghatá həŋ. Kaʼa nda həŋ mantsa: «Nu va ghwaɗaka skwi maga na mndu na ka kuni ka na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ka həŋ mantsa: «Ka má nza a tsi ka mndu ta magatá dmaku wu katsi ná, má klaghak a ŋni wu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","«Klawakla va kaghuni, ka dzaʼa kuni da tsanaghatá guma manda ya mna zlaha ghuni,» ka Pilat nda həŋ ta ghəŋani. «Vlaŋna a lu ta tva dzatá mndu wu,» ka la Yahuda zlghanaftawani. ");
INSERT INTO xed_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mantsa ya dzaʼa magakwa skwiha na ya gwaɗə Yesu ta ghəŋani kəʼa dzaʼa mtaku ya. ");
INSERT INTO xed_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ka vraghatá Pilat da daɓa həga, ka hgadamtá tsi ta Yesu. «Mghama la Yahuda kagha ra?» kaʼa ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ka Yesu mantsa: «Kagha ta ndanapta ma ghəŋa gha re, ari sanlaha a ta mnaghatá iʼi na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","«Iʼi! La Yahuda yu ra? Laghuni, nda maliha ta ghəŋa gwal dra skwi ŋa Lazglafta ta klaktá kagha da iʼi, nahgani maga ka ya katək na?» ka Pilat nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ka Yesu mantsa: «Ga mghama ɗa ná, ŋa na ghəŋa haɗik na a wa. Ka má ŋa na ghəŋa haɗik na tsi katsi, má lmalma kwalvaha ɗa, má ŋa kwala lu klagaghatá iʼi da gwal dagaladagala mataba la Yahuda. Tsaw ŋa na ghəŋa haɗik na a ga mghama ɗa wu,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","«Tsaw va mgham kagha rke?» ka Pilat nda tsi. «Manda va tsa mna ka ya, Mgham yu. Yaya lu ta iʼi ŋa sagha mnaŋtá kahwathwata ma na ghəŋa haɗik na. Inda mndu ta nzakway ka ŋa kahwathwata ná, ta snay ta gwaɗa ɗa,» ka Yesu. ");
INSERT INTO xed_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","«Nahgani kahwathwata na?» ka Pilat nda tsi. Tahula tsa, ka səglap tsi dzibil slanaghatá la Yahuda. Kaʼa mantsa: «Slanagha a yu ta skwi prək ŋa dzatá tsəna mndu na wa. ");
INSERT INTO xed_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ya wya ta snusna yu ta gɗata ta zlighunistá mndu turtuk ma gamak ma fitika skala Pak ya, ta kumay kuni ta slighunista ɗa ta mghama la Yahuda ra?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ka həŋ mantsa: «Tsatsi a ŋa zliŋta wa, Barabas katsi,» ka həŋ hləglaftawi. Tsaw tsa Barabas ya ná, gənda ya. ");
INSERT INTO xed_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tahula tsa, klagaghawa tsa Yesu ya ka sləvapta kuni nda krupi, ka Pilat. ");
INSERT INTO xed_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lagha la sludzi ka ɗaftá teki, ka fanamta ma ghəŋ manda zewzewa, ka suɗanavatá həŋ ta lguta má mgham mgham ka dva guli. ");
INSERT INTO xed_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","«Zgutsa ŋa gha mghama la Yahuda,» ka həŋ gavadaghata tavatani, ka dadgharay. ");
INSERT INTO xed_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","«Ndana tama wana yu dzaʼa kləgaghunapta dzibil, kada grafta kuni kazlay: Slanagha a yu ta sana skwi prək ka dzatá na mndu na wu kəʼa,» ka Pilat səglap dzibil slanaghatá la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ka sabə Yesu nda zewzewa teki ma ghəŋ, nda suɗatá lguta má mgham mgham ta vgha. «Wana tsa mndu ya,» ka Pilat nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na gi nghay la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal ta ngha həga Lazglafta, «zləŋaftá! zləŋaftá!» ka həŋ hlaftawi. «Klawakla kaghuni ka zləŋafta kuni, kabga slanagha a yu ta skwi ɗekɗek prək ka dzata wu,» ka Pilat nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","«Mamu zlaha ŋni. Ka tsa zlahu ya ná, dzata! kaʼa, kabga Lazglafta yu kəʼa fatá ghəŋani,» ka la Yahuda zlghanaftawi. ");
INSERT INTO xed_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Snaŋta Pilat ta tsa gwaɗa ya, ka ksəglaftá zləŋ katakata, ");
INSERT INTO xed_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ka lamə tsi da daɓa həga. «Sagha ga ka na?» kaʼa ɗawaŋta da Yesu. Sew zlghanaf a Yesu ta wani wa. ");
INSERT INTO xed_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","«Zlgha a ka ta wa ɗa wu? sana a ka kazlay: Laviŋlava yu ta zlighista, laviŋlava yu ta zləŋaftá kagha kəʼa wu ra?» ka Pilat nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","«Haɗ sana skwi laviŋ ka ta ghəŋa iʼi, ka ya vlagha Lazglafta a tsi wa. Tsaya kəl dmakwa tsa mndu ta vlatá iʼi ma dzva gha ya, ka malaghutá ŋa gha dmaku,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hada tama, ka zbə Pilat ta tvi ŋa zliŋta. «Ka zliŋzla ka ta tsəna mndu na ná, gra Sezar a ka wa. Ka mgham a iʼi ra, ka mndu guli ná, ghuma mgham Sezar tsa mndu ya,» ka la Yahuda. ");
INSERT INTO xed_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Snaŋta Pilat ta tsa gwaɗaha ya, «kladapwakla ta Yesu dzibil,» kaʼa. Ka nzaftá tsi ta vla tsa guma ma sana vli ta hgə lu ka Pave. Tsa Pave ya, Gabasla ta hga lu nda gwaɗa Hebru. ");
INSERT INTO xed_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mahtsim skala Pak ka lu, ta ghwanə a fitik ma ghəŋ wu, ka Pilat nda la Yahuda mantsa: «Wyawa mghama ghuni,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","«Ŋa dzatá! Ŋa dzatá! Zləŋafta ta udzu» ka həŋ hlaftá wi. «Ka zləŋaghunafta yu ta mghama ghuni ta udzu?» ka Pilat nda həŋ. «Haɗ sana mghama ŋni ta ghəŋa Sezar wu, ka la mali ta ghəŋa gwal dra skwi ŋa Lazglafta.» ");
INSERT INTO xed_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lagha Pilat ka vlaŋtá həŋ ta Yesu ŋa zləŋafta ta udzu. Ka tsuʼuwaghutá həŋ ka klaghata. ");
INSERT INTO xed_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ka klə Yesu ta udzu ŋa zləŋa ghəŋani, ka sabi ma huɗa luwa ŋa dzaʼa da sana vli ta hgə lu ka «vla ghudzifa ghəŋ.» «Gwalgwata» ta hga lu ta tsa vli ya nda gwaɗa Hebru. ");
INSERT INTO xed_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma tsa vli ya zləŋafta həŋ ta Yesu ta udzu. Ka zlaŋanavatá həŋ ta sanlaha ma mnduha his guli tavata Yesu, ma takataka ka həŋ zləŋamtá Yesu. ");
INSERT INTO xed_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Vindafwa vinda ta skwi ka fagata kuni ta ghəŋa tsa udzu ya, ka Pilat. «Yesu mnda la Nazaret mghama la Yahuda,» ka lu vindafta. ");
INSERT INTO xed_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nda ndəgha la Yahuda ta dzaŋaftá tsa skwi vindaf lu ya, kabga ndusa nda luwa tsa vli zləŋaf lu ta Yesu ya. Nda gwaɗa Hebru, nda gwaɗa Lateŋ, nda gwaɗa Grek vivindafta lu ta tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","«Má vinda a ka kazlay: Mghama la Yahuda kəʼa wa. “Iʼi mghama la Yahuda” kaʼa, ka ka má vindafta,» ka la mali ta ghəŋa gwal dra skwi ŋa Lazglafta mataba la Yahuda nda Pilat. ");
INSERT INTO xed_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","«Skwi ghada iʼi ta vindafta ná, nda vinda,» ka Pilat zlghanaftawani ta həŋ. ");
INSERT INTO xed_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tahula zləŋafta la sludzi ta Yesu ta udzu, ka hlaftá həŋ ta lguthani, ka daganapta fwaɗ ta həŋ ta həŋ. Ka klaftá həŋ ta dzampani ya gaf lu mantsa daga ta ghəŋ dikw ta haɗik kul haɗ iri tida ya guli. ");
INSERT INTO xed_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","«Ma kwahanap mu ta na dzampa na, vzamavza ta vindima ŋa ngha mndu dzaʼa zuta,» ka la sludzi mataba hahəŋ hahəŋ. Tsa skwi maga la sludzi ya ná, magamaga həŋ manda skwi nda vinda ma defteri kazlay: Ka daganaptá həŋ ta lgutha ɗa, ka vzə həŋ ta vindima ta ghəŋa dzampa ɗa kəʼa ya, tsaya skwi maga la sludzi. ");
INSERT INTO xed_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ndusa nda tsa vli zləŋaf lu ta Yesu ya, ka sladaktá i mani, nda mukumani ma mani, nda Mari markwa Klupas, nda Mari makwata luwa Magdala. ");
INSERT INTO xed_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nghay Yesu ta mani, kəʼa kəʼa ná, wya tsa duhwal ta ɗvu tsi ya ta sladu tavatani. Kaʼa mantsa: «Ma! Wya zwaŋa gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","«Wya ma gha!» kaʼa nda tsa duhwal ya guli. Daga ma tsa fitik ya, ka klaghatá tsa duhwal ya da taŋ. ");
INSERT INTO xed_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tahula tsa, manda snaŋta Yesu kazlay: Nda kɗa inda skwi tama kəʼa, «ndala ta kuzlihata!» kaʼa, ŋa nzakwani manda ya nda vinda ma defteri. ");
INSERT INTO xed_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tsaw ma tsa vli ya, mamu wuda ima inabi masmasa. Ka sliʼaftá sana sludzi ka klaftá susu, ka tsughumamta ma tsa ima inabi masmasa ya, ka hbuŋta ta wa dafa, ka tsghadafta fuŋta ta wa wubisima Yesu. ");
INSERT INTO xed_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","«Nda dza ghəŋa inda skwi tama,» ka Yesu tapanar tsi ta tsa ima inabi masmasa ya. Ka dzagatá tsi ta ghəŋ, ka sabə hafu mida. ");
INSERT INTO xed_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Baɗu luma madagala ŋa gi lamə da Sabat magakwa tsa skwi ya. Va a la mali mataba la Yahuda ta slanaghata Sabat ta tsa mnduha ya ta udzu wa. Tsa Sabat ya ná, sana mghama fitik ya. Ka sliʼaftá həŋ ka laghwi da ɗaway da Pilat ŋa ɓalanaptá səlaha taŋ ŋa hligiŋtá həŋ ta udzu. ");
INSERT INTO xed_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ka lagha la sludzi da ɓalanaptá səlaha tsa mnduha his zlaŋanava lu tavata Yesu ya. ");
INSERT INTO xed_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ta lagha həŋ ta Yesu, kəʼa ka həŋ ná, nda ghada mtatani. Ka zlaŋtá həŋ ta ɓalanaptá səlahani. ");
INSERT INTO xed_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka sliglanavatá sani ma tsa sludziha ya ma ŋwazliɓ nda gupani, ka gi mbəzagaptá us nda imi. ");
INSERT INTO xed_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tsəna mndu ta vinda na skwiha ta maguta na ná, nda ngha tsatsi nda irani. Kahwathwata gwaɗani guli. Nda sna tsatsi kazlay: Kahwathwata ta mnə tsatsi kəʼa. Mnay ta mnə tsi ná, kada zlghafta kaghuni guli. ");
INSERT INTO xed_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Magamaga tsa skwiha ya mantsa, ŋa nzakwani manda ya nda vinda ma defteri kazlay: Haɗ ghudzifani dzaʼa ɓlanapta lu dər turtuk wu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ka lu vindafta ma sana vli guli ná, «dzaʼa nghanavangha həŋ ta tsa mndu sliglanava həŋ nda gupa ya» kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tahula tsa, mamu sana mnda la Arimate ta hgə lu ka Yusufu, ta nzakway ka duhwala Yesu makɗekmakɗek kabga zləŋa la Yahuda. Ka sliʼaftá tsi ka laghwi ɗawaftá mbla Yesu da Pilatus. Ka zlanaŋtá Pilat ta tvi, ka lagha tsi klaghatá tsa mbla Yesu ya. ");
INSERT INTO xed_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ka lagha Nikwademu, tsa mndu si ta lagha da slanaghatá Yesu girviɗik ya kay. Ka lagha tsi nda klatá laɓatá urdi ka hpuhpu ta hgə lu ka Mir nda Alwes. ");
INSERT INTO xed_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ka klaftá həŋ ta mbla Yesu, ka masanavatá rɗi ka urdi, ka mbsamtá həŋ ma wupay manda ya snu la Yahuda ta magay ta paɗə həŋ ta mnda taŋ. ");
INSERT INTO xed_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tsaw ma tsa vli kəl lu ka zləŋafta ya, mamu sana gam. Ma tsa gam ya, mamu kulu ta ka lfiɗ ta kul walaŋta lu ta paɗamtá mndu mida. ");
INSERT INTO xed_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndusa nana, ka həŋ ka paɗamtá Yesu ma tsa klu ya, kabga tsaya fitik ta kəl la Yahuda ka paya vgha ŋa lami da Sabat. ");
INSERT INTO xed_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wrək tgha gasərɗək baɗu dəmas, ta kzauʼkzauʼ a vli, ka lagha Mari makwa ta Magdala ta kulu. Kəʼa kəʼa ná, taŋwalaghutaŋwala lu ta klam ta wa tsa kulu ya. ");
INSERT INTO xed_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ka sliʼaftá tsi nda hwaya ka laghwi slanaghatá i Simuŋ Piyer nda tsa sana duhwal ta ɗvu Yesu ya. «Klapkla lu ta mbla Mghama mu ma kulu, sna a ŋni ta vli fam lu wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ka sliʼaftá i Piyer nda tsa sana duhwal ya, ka laghwi ta kulu. ");
INSERT INTO xed_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ka sliʼaftá həŋ his his nda hwaya. Tsaw mal tsa sana duhwal ya ta hwaya ka Piyer, ka tiŋlaghutá tsi ta ɓhadaghata ta kulu. ");
INSERT INTO xed_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɓhadaghatani má ŋa lamani, lamə a wa. Ka ɓukwatá tsi ka nghə dida. Kəʼa kəʼa ná, wupay yeya ksufa ta haɗik. ");
INSERT INTO xed_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ka ɓhadaghatá Simuŋ Piyer nda hul nda hul, ka lamə tsi da tsa kulu ya. Kəʼa kəʼa ná, wupay yeya ksufa ta haɗik, ");
INSERT INTO xed_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nda tsa patak si wanam lu ta Yesu ma ghəŋ ya. Tsa patak ya ná, ma sana vli tsaya ŋusafa guli kawadaga nda tsa wupay ya a wa. ");
INSERT INTO xed_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka lamə tsa duhwal si ta ɓhadaghata taŋtaŋ ya kay guli. Ka nghanatá tsatsi guli, ka zlghaftá tsi. ");
INSERT INTO xed_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsaw si ta graf a həŋ ta skwi mna defteri kazlay: Dzaʼa sliʼagapsliʼa Yesu mataba gwal nda rwa kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ka vraghutá tsa duhwalha his ya dzagha taŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ka nzaghutá Mari ma bli ta wa tsa kulu ya ka taw. Ta taw tsi ta tsa taw ya ná, ta ɓukwatá tsi ka nghə da tsa kulu ya. ");
INSERT INTO xed_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ka nghaŋtá tsi ta duhwalha Lazglafta his, ta nzaku ma tsa vla si fatá mbla Yesu ya. Sani nda tvə ghəŋ, sani nda tvə səla. ");
INSERT INTO xed_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","«Nya ta taw ka ní makwa na?» ka həŋ nda tsi. «Mghama ɗa ya klagha lu, sna a yu ta vli fam lu wu,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ta mnə tsi ta tsaya, ka mbəɗavatá tsi. Ka nghaŋtá tsi ta sana mndu ta sladu hada. Tsatsaf a tsatsi kazlay: Yesu ya kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","«Nya ta taw ka ní makwa na? Wa ta zbə ka na?» ka Yesu nda tsi. Na mndu nda na gam na ya ka tsatsi sizlay. «Mghama ɗa, ka si kagha ta klaghata, mnihamna ta vli fam ka, ka dzaʼa yu da klay» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","«Mari!» ka Yesu hgaŋta, ka mbəɗavatá tsi. «Rabum» kaʼa nda tsi. Manda mnay kazlay: Mnda taghaɗiftá skwi kəʼa ya nda gwaɗa Hebru. ");
INSERT INTO xed_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","«Ma ŋiha ka, ta laf a yu da Da ɗa karaku wu, la da mnay ŋa zwanama ɗa kazlay: Ta dzaʼa da Da ɗa ta nzakway ka Da ghuni yu, da Lazglafta ta nzakway ka Lazglafta ghuni ya yu guli,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","«Nda ngha yu ta Mgham Yesu,» ka Mari makwata Magdala sliʼafta ka laghwi da mnay ŋa duhwalha. Ka rusu tsi ŋa taŋ ta skwi mnana tsi. ");
INSERT INTO xed_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gahawu baɗu va tsa dəmas ya, ka tskavatá tsa duhwalha ya ma həga. Ka ŋərzlaftá həŋ ta watgha kabga ta zləŋay həŋ ta la mali mataba la Yahuda. «Ka nza zɗaku kawadaga nda kaghuni,» ka Yesu lami da taba taŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mnatani mantsa ya, ka maranaŋta tsi ta dzvuhani nda ŋwazliɓani ta həŋ. Ka rfu tsa duhwalha ya ta rfu nghaŋər həŋ ta Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","«Ka nza zɗaku kawadaga nda kaghuni. Manda ya ghunaf Da ta iʼi ya, mantsa ya ta ghuna iʼi ta kaghuni guli,» ka Yesu nda həŋ guli. ");
INSERT INTO xed_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tahula mnatani ta tsaya, «tsuʼuwawatsuʼuwa ta Sulkum nda ghuɓa,» kəʼa vusludanaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","«Gwal dzaʼa planata kuni ta dmakuha taŋ, dzaʼa planapla lu ta dmakuha taŋ. Gwal dzaʼa kwalaghuta kuni ta planatá dmakuha taŋ, haɗ lu dzaʼa planatá dmakuha taŋ guli wa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tsaw haɗ Tuma ta nzakway ka mbuhwali tekw mataba tsa duhwalha ya hada ta lagha Yesu wa. ");
INSERT INTO xed_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","«Nda ngha ŋni ta Mghama mu Yesu,» ka tsa pɗakwa duhwalha ya nda tsi. «Ka ngha a yu ta miviɗa pusa ta dzvuhani, ka ksaŋta ɗa nda ndəfiŋa ɗa ta vla tsa pusaha ya, ksaŋha yu guli nda dzva ɗa ta ŋwazliɓani wu, haɗ yu ta zlghafta ɗekɗek wa,» ka Tuma nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tghas fitik tahula tsa, ka nzəglatá duhwalha Yesu ma həga, kawadaga Tuma nda həŋ baɗu tsa. Ka ŋərzlaftá həŋ ta watgha. Ka lamə Yesu da taba taŋ. «Ka nza zɗaku kawadaga nda kaghuni,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","«Wya dzvuha ɗa ksaŋksa nda ndəfiŋa gha, wya ŋwazliɓa ɗa guli, ksaŋksa nda dzva gha, ka zlaŋta ka ta dga ghəŋ, ka zlghafta ka nda ŋuɗuf,» kaʼa nda Tuma. ");
INSERT INTO xed_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","«Kagha ta nzakway ka Mghama ɗa, kagha ta nzakway ka Lazglafta ɗa guli,» ka Tuma zlghanaftawi. ");
INSERT INTO xed_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","«Zlray gha ta zlghaftá tsa ɓa kabga nghaŋta gha ta iʼi? Rfu da gwal ta zlghaftá iʼi, kul nghaŋtá həŋ ta iʼi,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ta traku mazəmzəm magəgla Yesu ta kəma duhwalhani kul vindaku ma na defteri na. ");
INSERT INTO xed_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nana vinda a lu na ná, vinda a vinda lu ŋa zlghafta ghuni kazlay: Yesu ná, Kristi ya, Zwaŋa Lazglafta ya guli kəʼa. Ka zlghafzlgha kuni ta tsatsi, dzaʼa mutsay kuni ta hafu nda ma tsatsi. ");
INSERT INTO xed_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tsəɓakw fitik tahula tsa, ka marglavatá Yesu da duhwalhani ta wa drəfa Tiberyad. Wya kəʼa maravata: ");
INSERT INTO xed_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ta nzaku i Simuŋ Piyer nda Tuma ta hgə lu ka mbuhwali ya, nda Natanayel mnda luwa la Kana ta haɗika Galili, nda zwana Zebedi, nda sanlaha ma duhwalhani his, ka skwa turtuk. ");
INSERT INTO xed_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","«Dzaʼa tuma klipa ɗa yu,» ka Simuŋ Piyer nda həŋ. «Nda sliʼa aŋni mista gha guli,» ka hahəŋ guli nda tsi. Ka sliʼaftá həŋ ka laghwi, ka lamə həŋ da kwambalu. Kurzliŋ hana taŋ ndiri baɗu tsa, ksaf a həŋ ta klipi dər ka turtuk wa. ");
INSERT INTO xed_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tsaɗakwa vli gasərɗək, ka lagha Yesu sladata ta wa tsa drəf ya. Tsəmaf a duhwalhani kazlay: Tsatsi ya kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","«Mamu klipi ksaf kuni ri zwani?» ka Yesu nda həŋ. «Haɗ wu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","«Wuɗadawa kadəŋa ghuni ta slərpa kwambalu nda ga zeghwi ya, dzaʼa mutsay kuni,» kaʼa nda həŋ. Ka wuɗadatá həŋ. Ka traptá həŋ ta tɗagafta kabga ndəghatani nda klipi. ");
INSERT INTO xed_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","«Mgham Yesu ya tane, ka tsa duhwal ta ɗvu Yesu ya,» nda Piyer. Na tsa gi snaŋta Simuŋ Piyer kazlay: Mgham Yesu ya kəʼa ya, ka favatá tsi ta lgutani kabga si suɗiŋsuɗa ka tuma klipi, ka vzadatá tsi ta vgha da drəf. ");
INSERT INTO xed_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ka vragaghutá tsa sanlaha ma tsa duhwalha ya ma kwambalu, nda tɗa tsa kadəŋ nda ndəghatani nda klipi ya. Si diʼiŋaghu a həŋ katakata wa. Ka mitir dərmək yeya ri kaki nzakwa taŋ nda wa sgam. ");
INSERT INTO xed_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta sliʼagaptá həŋ ma kwambalu, kəʼa ka həŋ ná, mamu tsatá vu hada nda klipi tida nda buradi. ");
INSERT INTO xed_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","«Kligiswakla ta tsa klipiha kasaf kuni ya,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ka lamə Simuŋ Piyer da kwambalu, ka tɗagaptá tsi dzibil ta tsa kadəŋ nda ndəghatani nda klipi ɓərzləzla ya. Dərmək nda hutaf mbsak hkən mida gwagwatani. Kulam nda va tsa nzakwani mantsa ya ná, ratsanap a ta tsa kadəŋ ya wa. ");
INSERT INTO xed_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","«Sawa da za skwa zay!» ka Yesu nda həŋ. Haɗ ya mataba tsa duhwalha ya ta walaŋtá ɗawaŋta kazlay: Wa kagha na kəʼa wu, kabga nda sna həŋ kazlay: Mgham Yesu ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ka lagha Yesu klaftá tsa buradi ya, ka daganaftá həŋ, daganafha ta klipi ta həŋ guli. ");
INSERT INTO xed_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mahkəna maravata Yesu tsaya da duhwalhani manda sliʼagaptani nda hafu mataba gwal nda rwa. ");
INSERT INTO xed_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tahula zuta taŋ ta skwa zay, ka Yesu mantsa: «Simuŋ zwaŋa Yuhwana! Ɗvuɗva ka ta iʼi, ka malaghutá ŋa nanaha na ra?» kaʼa ɗawaŋta da Simuŋ Piyer. «Aŋi Mghama ɗa, nda sna kagha kazlay: Ta ɗvay yu ta kagha kəʼa,» kaʼa zlghanaftá wani. «Ka ngha ka ta zwana tuwakha ɗa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","«Simuŋ zwaŋa Yuhwana! Ɗvuɗva ka ta iʼi?» ka Yesu nda tsi kamahis. «Aŋi Mghama ɗa! Nda sna kagha kazlay: Ta ɗvay yu ta kagha» kəʼa, ka Piyer nda tsi. «Ka ngha ka ta tuwakha ɗa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","«Simuŋ zwaŋa Yuhwana! Ta ɗvay ka ta iʼi?» kaʼa nda tsi ka mahkən. Ka kuzlanaftá tsi ta Piyer ta ŋuɗuf na tsa ɗaway Yesu ka mahkən kazlay: Ta ɗvay ka ta iʼi ra kəʼa ya. «Mghama ɗa, nda sna kagha ta inda skwi, nda sna kagha guli kazlay: Ta ɗvay yu ta kagha kəʼa,» kaʼa nda tsi. «Ka ngha ka ta tuwakha ɗa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","«Kahwathwata ka yu ta mnaghata, ma fitika nzakwa gha ka duhwal, kagha ka ghəŋa gha ta hba ɓanava gha misti, ka dzaʼa gha da vli ta kumə ka. Ka hwaluhwala ka, dzaʼa pghapgha ka ta dzvuha gha ŋa nzɗaghafta sana mndu ta ɓanava gha, ka kla kagha da vli kul kumə ka ta dzaʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tsa gwaɗaha mnə tsi ya, tvi ka Piyer dzaʼa mtaku ŋa vla glaku ŋa Lazglafta ya mnə tsi. «Mbaɗa mista ɗa,» kaʼa nda tsi tahula tsa. ");
INSERT INTO xed_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kəʼa ka Piyer mbəɗavata ná, ta saghasa tsa duhwal ɗvu Yesu ya mista taŋ. Tsatsi tsa duhwal ta fadaghatá ghəŋ da ghuva Yesu, ma fitika nzata taŋ ka za skwa zay, ka ɗaw tsi kazlay: Mghama ɗa! Wa va na mndu dzaʼa skwaptá kagha na na? kəʼa yeya. ");
INSERT INTO xed_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","«A ki na duhwal na tama Mghama ɗa, nahgani dzaʼa slanaghatá tsatsi?» ka Simuŋ Piyer nda Yesu, nghər tsi ta sagha tsa duhwal ya. ");
INSERT INTO xed_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","«Ka nzanza nda hafu ha ka vrakta ɗa, ka yu nda tsi ní, nu ta nghaghata mida na? Sliʼa kagha mista ɗa ŋa gha ɓa,» ka Yesu nda tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ka tutá tsa gwaɗa ya mataba gwal zlghay nda ŋuɗuf kazlay: Mtəta a tsa duhwal ya wu kəʼa. Mtəta a wa a mna Yesu ŋa Piyer wa. Wya kəʼa mnay: «Ka nzanza nda hafu ta vragatá yu, a ka ka yu nda tsi ní, nu ta nghaghata mida na» kəʼa skwi mna tsi. ");
INSERT INTO xed_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Va na duhwal ta mna na gwaɗaha na ta vindafta. Nda sna mu guli kazlay: Kahwathwata gwaɗani kəʼa. ");
INSERT INTO xed_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nda ndəgha sanlaha ma skwiha magəgla Yesu. Ka má ka vivindaf vivinda lu ta indani ká lu katsi ná, graf a yu kazlay: Má dzaʼa ŋafŋa ghəŋa haɗik ta tsa defteriha má dzaʼa vivindafta lu ya kəʼa wa.");
INSERT INTO xed_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ari Ŋərma ɗa Tawfilus, Ma taŋtaŋa deftera ɗa ná, rusaghaf rusa yu ta inda skwi ya maga Yesu, nda skwi ya si ta tataghə tsi ŋa mnduha daga ma zlraftani, ");
INSERT INTO xed_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ha ka sagha ta fitik kəl lu ka klaghata ta luwa. Ma kɗaku tsi ka ŋlaghatá ta luwa na, vlaŋvla ta zlahuhani nda mbrakwa Sulkum nda ghuɓa ta mnduha ya zabap tsi ka gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tahula mtutani, ka marə tsi ta vgha ŋa taŋ nda tvi kavghakavgha. Ta traku skwiha maranaŋ tsi ta həŋ ŋa granaftá həŋ kazlay: Nda hafu yu kəʼa. Fwaɗmbsak fitikani ta mamaranaŋtá vgha ta həŋ, ka mna gwaɗa ta ghəŋa ga mghama Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","«Yaha kuni zaghuta diʼiŋ nda Ursalima. Ka nzata kuni hada ka kzla skwi ya taghunaf Lazglafta ta imi ta sləməŋ, manda ya snaŋ kuni ma wa ɗa,» kaʼa vlaŋta zlahu ta həŋ ma sana fitik ta zə həŋ ta skwa zay. ");
INSERT INTO xed_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","«Nda imi si ta maga Yuhwana ta batem. Ma fitik kwitikw, kaghuni ná, dzaʼa magaghunafmaga lu ta batem nda Sulkum nda ghuɓa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","«Mghama ɗa, ma na fitik na dzaʼa sladanafta ka ta ga mghama la Israʼila ra?» ka tsa gwal ghunay ta tskavata tavatani ya ɗawaŋta da tsi. ");
INSERT INTO xed_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","«Nghaghunaŋ a snaŋta ka ta wati luwa, nda ya ka ta wati fitik tsafta Da ta ga mgham ya ta nghanata wa. ");
INSERT INTO xed_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kaghuni, dzaʼa mutsay kuni ta mbraku sarə Sulkum nda ghuɓa ta ghəŋa ghuni. Ŋa nzakwa ghuni ka masləmtsəka ɗa ma luwa Ursalima, nda ya ta haɗika Zudiya, nda ya ta haɗika Samari, nda ya ta kɗavakta ghəŋa haɗik demdem,» ka Yesu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tahula mnata Yesu ta tsa gwaɗaha ya, ka kapə tsi ta vgha, ka zaghuta ta luwa, ta nghaynghay hahəŋ demdem, ka zamtá tsi ma ghwayak ta wa ira taŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ta tsa fitika pghata taŋ ta iri ka ngha sliʼani ta luwa ya, gi ka zlagaptá sana mnduha his tavata həŋ nda suɗata lguta ŋusliŋ ta vgha taŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ka həŋ nda həŋ mantsa: «Mnduha la Galili, kabgawu ta kəl kuni ka pgha iri ta luwa na? Tsa Yesu klap lu mataba ghuni, ka klaghata ta luwa ya ná, dzaʼa vragavra manda va tsa nghay nghə kuni ta sliʼani ta luwa ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ka sliʼaftá tsa gwal ghunay ya ta ghwá ta hgə lu ka Ghwá Zaytuŋ ya, ka vraghuta da luwa Ursalima. Tsa ghwá ya ná, ndusa nzakwani nda Ursalima. Minti hkənmbsak ta magata lu ta mbaɗa manda sliʼafta hada. ");
INSERT INTO xed_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ɓhadaghata taŋ da Ursalima, ka ŋlaghatá həŋ da sana dzuguvi banagha lu ta ghəŋa sana həga, ma vli sunə həŋ ta tska vgha. Wya tsa hahəŋ ya: I Piyer, nda Yuhwana, nda Yakubu, nda Andre, nda Filip, nda Tuma, nda Bartelemi, nda Mata, nda Yakubu zwaŋa Alfe, nda Simuŋ mnda zluʼa ghwa, nda Yuda zwaŋa Yakubu, na həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hahəŋ demdem, ta tskay həŋ ta vgha inda fitik ŋa maga duʼa. Kawadaga heŋ nda sanlaha ma miʼaha, nda i Mari mani ma Yesu, nda zwanamani ma Yesu tani. ");
INSERT INTO xed_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Baɗu sana fitik, ma tsa fitik ta tskə həŋ ta vgha ya, ka tskavatá gwal zlghay nda ŋuɗuf ta magay həŋ ta dərmək nda hisambsak. Ka Piyer sliʼavata mataba taŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Zwanama ɗa, nda ra ka magakwa skwi ya mna Sulkum nda ghuɓa ma defteri nda ma wa Dawuda ta ghəŋa Zudas, ta nuta ka mnda kla kəma ŋa mnduha ya ta ksaftá Yesu ya. ");
INSERT INTO xed_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si tekw tsatsi mataba amu, si mamu slnani mataba va tsa slna ta magə amu ya guli. ");
INSERT INTO xed_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nda tsa tsedi plana lu ma vəl dzatani ta mndu ya, ka skwata tsi ta vwah. Ka dəɗagatá tsi nda ga ma ghəŋghəŋ ka pslutá huɗani pɗah. Mbəlaɓaɓ, ka harani saghwi ta daɓi. ");
INSERT INTO xed_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ka snanaghatá tsi ta inda mnduha ma Ursalima, kəl həŋ ka tsanaftá hgu ta tsa vwah ya nda gwaɗa taŋ ka “Hakəldama,” manda mnay kazlay: Vwaha nasa kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Wya skwi ta dzaŋə lu ma deftera Zabura: “Dzaʼa nuna həgani ka kufik, haɗ mndu dzaʼa nzamta mida wa.” Kaʼa guli na: “Sana mndu dzaʼa klafta slnani kəʼa,” na skwi nda vinda ma defteri. ");
INSERT INTO xed_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Tsaya tama, ɗina ka sganaghatá sana mndu tavata amu, ŋa nzakway ka masləmtsəka sliʼagapta ya sliʼagap Mghama mu Yesu. Tsa mndu ya ná, nda nza ka tsi ka mndu ya si ta gɗata ta dzaʼa mista mu ta inda haɗikha ya ranaf mu kawadaga nda Mghama mu Yesu, zlrafta ta fitika maganafta Yuhwana ta batem, ha ka sagha ta fitik kəl lu ka kləgadamaghuta ka laghu ta luwa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mantsa tama, ka pghatá lu ta mnduha his. Tsa mnduha ya ná, i Yusufu ta hgə lu ka Barsaba, ta hgay lu guli ka Yustus, nda Matiyas həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ka ndəɓə həŋ ta dzvu, ka həŋ mantsa: «Mghama ɗa, nda sna kagha ta ŋuɗufa inda mnduha. Maraŋnamara ta ya zbap kagha mataba na mnduha his na, ");
INSERT INTO xed_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ŋa maga slna mnda ghunay ta nzakway ka vla Zudas, ta zlanavata ka laghu da ksa tvi ya kumaŋ tsi ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ka vzə həŋ ta vindima. Ka kluta vindima ta Matiyas. Ka gwafta tsi ta vgha kawadaga nda tsa gwal ghunay ghwaŋpɗə ndeŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ta sagha fitika Pentekwat ná, nda tska vgha inda gwal ŋa ghunay tets ma vlaka turtuk. ");
INSERT INTO xed_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gi ka saha skwi ta luwa manda ghudzaga falak ta vyaku dididida ya, ka ndəghamtá vgha ma tsa həga nzamə həŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ka zlagaptá skwi manda ghanika vu, ka dagavapta, ka nzanzafta ta ghəŋa taŋ turtuk turtuk. ");
INSERT INTO xed_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ka ndaghaftá həŋ demdem nda Sulkum nda ghuɓa. Ka gi gwaɗə həŋ ta gwaɗa nda sanlaha ma gwaɗaha manda ya vlaŋ Sulkum ta həŋ ŋa gwaɗay. ");
INSERT INTO xed_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tsaw ma Ursalima ma tsa fitik ya ná, ta nzaku gwal ta ndiʼamta ma dina la Yahuda ta sliʼakta ta inda haɗikha ta ghəŋa haɗik. ");
INSERT INTO xed_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Snaŋta taŋ ta ghudzaga tsa skwi ya, ka sliʼadaghatá həŋ ŋərɓisl, ka ndərmim həŋ katakata, kabga inda taŋ ta sna skwi ta gwaɗə gwal zlghay nda ŋuɗuf nda gwaɗa taŋ ya ta gwaɗə həŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ka ndərmim həŋ nda ndərmima ka nutá manda rgha. Ka həŋ mantsa: «Inda na mnduha ta gwaɗa na gwaɗa na ná, la Galili a həŋ kay ra? ");
INSERT INTO xed_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Wa kəʼa magaku ta kəl inda amu ka snaŋtá skwi ta gwaɗə həŋ nda vərɗa ŋa mu ma gwaɗa ɓa? ");
INSERT INTO xed_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wana mataba mu ná, mamu gwal ta sliʼakta ta haɗika Partes, nda ya ta haɗika Medi, nda ya ta haɗika Elam. Mamu gwal ta sliʼakta ta haɗika Mezaputami, nda haɗika Zudiya, nda Kapadwas, nda Puŋ, nda haɗika Asiya tani. ");
INSERT INTO xed_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Mamu gwal ta haɗika Frizi, nda Pamfali, nda Masar, nda gwal ta wanaftá Sireŋ, nda Libiya tani. Mamu gwal ta sliʼafta daga ta haɗika Ruma guli. ");
INSERT INTO xed_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mamu gwal ta haɗika Kret nda Arabi. Zivra la Yahuda sanlaha. Dina la Yahuda ta nanaftá sanlaha. Nda inda tsa gwaɗaha mu kavghakavgha ya ta sna mu ta skwi ta mnə həŋ ta ghəŋa glakwa slna Lazglafta ta magata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ka ndərmim həŋ katakata, snəgla a həŋ ta skwi ŋa magay wa. «Nu mndəra nana ma skwi manda na na?» ka həŋ mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","«Nda ghuya həŋ,» ka sanlaha ka ghuɓasa həŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ka sliʼaftá Piyer kawadaga nda tsa gwal ghwaŋpɗə ndeŋ ya, ka klaŋtá tsi ta lwi. Kaʼa nda həŋ mantsa: «Kaghuni la Yahuda, nda inda kaghuni ta nzakway ma Ursalima! Fawa sləməŋ ka sna skwi dzaʼa mnaghunata yu, ka sna kuni ɗina ta skwi ta magaku. ");
INSERT INTO xed_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na mnduha na ná, ghuya a həŋ manda tsa ta grə kuni ya wu, kabga ta ka vzlazlaŋ vli. ");
INSERT INTO xed_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gwaɗa anabi Yuwel ta mnata ya kay nana ta magaku ndanana: Wya kaʼa mnata: ");
INSERT INTO xed_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ma kɗavakta fitik ná, wya skwi dzaʼa magaku, ka Lazglafta: Dzaʼa pghadapgha yu ta Sulkuma ɗa ta ghəŋa inda mnda səla, ŋa nuta zwana zgwana ghuni nda kwagha ghuni ka anabiha. Ka mazəmzəm dzaʼa gwaɗa yu ta gwaɗa ŋa duhwalha ghuni. Nda ma suni dzaʼa gwaɗa yu ta gwaɗa ŋa la halata mnduha ghuni. ");
INSERT INTO xed_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mantsa ya nzakwani, dzaʼa pghadapgha yu ta Sulkuma ɗa ta ghəŋa kwalvaha ɗa ka zgwana nda la ka miʼaha tani. Ma tsa fitik ya, dzaʼa nzakway həŋ ka la anabi. ");
INSERT INTO xed_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dzaʼa magay yu ta skwa mandərmimi ma ghuvaŋata luwa, nda ŋizla mazəmzəmha ta haɗik. Dzaʼa mamu us, dzaʼa mamu vu nda ɗukwakwa ɗiŋ, ");
INSERT INTO xed_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","tɗik dzaʼa mbəɗavafta fitik. Ma kɗaku fitik dagala ta nzakway ka fitika Mgham Yesu ka sagha, ghəw manda us dzaʼa mbəɗavafta tili. ");
INSERT INTO xed_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mantsa tama, inda mndu ta hga hga Mgham Yesu nda fatá ghəŋ tida ná, dzaʼa mbaku,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Mnduha la Israʼila, snawa ta skwi dzaʼa mnaghunata yu: Yesu mnda la Nazaret na tsa mndu maraghunaŋ Lazglafta ta ga Mghamani, ma magayni ta mandərmimi, nda ŋizla mazəmzəmha kavghakavgha mataba ghuni, manda va ya snaŋ vərɗa kaghuni ya. ");
INSERT INTO xed_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Vlaghunavla lu ta tsa mndu ya ma dzva ghuni. Nda sna Lazglafta manda va tsaya dzaʼa nzakwa tsi kəʼa, ta kuratá tsi. Ka zləŋaftá kuni ta Yesu. Ma zləŋafta ghuni nda ma dzva gwal kul zləŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ka sliʼaganaptá Lazglafta, ka kligiŋta ma ghuya ɗaŋwa mtaku, kabga haɗ mbrakwa mtaku ŋa ŋanata wa. ");
INSERT INTO xed_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wya ka Dawuda mnuta ta ghəŋani: “Ta nghay yu ta Mgham inda fitik ta kəma ɗa, ta nzaku nda ga zeghwa ɗa. ");
INSERT INTO xed_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tsaya ta ghunanaftá ŋuɗufa ɗa, kəl yu ka fa laha rfu. Dər má nda nza yu ka mndu dzaʼa mtaku ná, dzaʼa mbiʼay yu ta vgha nda fatá ghəŋ, ");
INSERT INTO xed_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kabga zlanata a ka ta hafa ɗa ma vla gwal nda rwa wu, zlaŋta a ka ta iʼi ta nzakway ka ŋərma mnda gha ŋa rwuta ma kulu wu, ");
INSERT INTO xed_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","kagha ta marihatá tva hafu. Dzaʼa ndəghiɗifndəgha ka nda rfu ma nzakwa gha tavata iʼi”» kəʼa, kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ka Piyer sganaghata mantsa: «Zwanama ɗa, mutsafmutsa yu ta na fitik na ŋa mnaghunata tsiɗiɗ ta gwaɗa ta dzidza mu Dawuda. Tsatsi ná, mtumta ka paɗamta lu. Ta tekeʼa kulani dər gitana. ");
INSERT INTO xed_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tsatsi ná, anabi ya. Nda sna guli kazlay: Dzrafdzra Lazglafta ta wi nda tsatsi nda waɗanata kazlay: Dzaʼa fafa ta sana mndu mataba zivrani ta palaka ga mgham manda nzakwa tsatsi ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","«Ka tsatsaftá Dawuda ta skwi dzaʼa magaku. Tsaya kəl tsi ka mna gwaɗa ta ghəŋa sliʼagapta Kristi kazlay: Zlana a lu ma vla nzakwa gwal nda rwa wu, rwu a sluʼuvghani ma kulu wu kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Tsa Yesu gwaɗə yu ya ná, Lazglafta ta sliʼaganapta ma mtaku. Nda nza aŋni demdem ka masləmtsəkani. ");
INSERT INTO xed_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ka kapanaftá Lazglafta ka nzanata nda ga zeghwani. Ka zlghafta tsi da Da ta tsa Sulkum nda ghuɓa tamaf lu ta imi ta zləməŋ ya, ka pghaŋnaghatá tsi. Tsaya skwi ta nghə kuni nda ya ta snə kuni ndanana ya. ");
INSERT INTO xed_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dawuda ka ghəŋani a ta lafi ta luwa mndani wa. Tsaw wya skwi mna tsi: “Ka Mgham Lazglafta nda Mghama ɗa ná, sawi nzata nda ga zeghwa ɗa, ");
INSERT INTO xed_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ha ka nanafta ɗa ta ghumaha gha ka skwa ta diŋlay səla gha, ” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Ka snaŋsna la Israʼila kahwathwata kazlay, tsa Yesu dalaf kuni ta udzu ya kay ná, tsatsi fa Lazglafta ka Mgham, ka Kristi kəʼa guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na snaŋta tsa mnduha ya ta tsa gwaɗaha gwaɗa Piyer ya ná, ka kɓanaftá tsi ta həŋ. «Zwanama, nu ka ŋni dzaʼa magay tama?» ka həŋ nda i Piyer nda sanlaha ma gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ka Piyer nda həŋ mantsa: «Mbəɗanafwambəɗa ta tva nzakwa ghuni, ka magafta inda kaghuni ta batem ma hga Yesu Kristi, ŋa plighunista Lazglafta ta dmakuha ghuni, ŋa vlaghunatani ta Sulkum nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tsa ta ta imi ta sləməŋ taghunaf Lazglafta ya ná, ŋa kaghuni nda zwana ghuni, nda gwal diʼiŋdiʼiŋ, nda ndəghata mbsaka gwal dzaʼa hagakta Mgham Lazglafta tani ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ndaɗa a sanlaha ma gwaɗaha manaŋ Piyer, ka vla hiɗaku nda mbraku ŋa taŋ wa. «Tsuʼafwatsuʼa ta mbaku ka sliʼapta kuni mataba gwal nda zaɗa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nda ndəgha gwal ta zlghaftá tsa gwaɗa Piyer baɗu tsa ya. Ka maganaftá lu ta batem ta həŋ. Tsa mnduha ta sgavaghata ta ghəŋa gwal zlghay nda ŋuɗuf baɗu tsaya ná, ta magay həŋ ta dəmbuʼ hkən. ");
INSERT INTO xed_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inda tsa mnduha ya ná, ta gɗata ta ŋavata ka sna skwi ta taghə gwal ghunay həŋ. Ta ŋavaŋa həŋ ka guya vgha nda zwanama. Ta ŋavaŋa həŋ guli ka guya ghəŋ ta ghəŋa skwa zay, nda ya ma vla maga duʼa. ");
INSERT INTO xed_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ka zləŋ inda mnduha ta zləŋ, kabga nda ndəgha mandərmimi nda mazəmzəmha ta magata Lazglafta nda ma gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Inda gwal zlghay nda ŋuɗuf ná, tets ka skwa turtuk guya ta ghəŋa taŋ. Inda skwa taŋ guli ná, ka skwa turtuk ta dguvusta həŋ ta vgha taŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta dzawap dzawa həŋ ta skwiha taŋ ŋa daguvusta taŋ ta tsedani, taɓ ta ɗaŋwa dər wa mataba taŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inda fitik həŋ ta tskavata ma həga Lazglafta. Ka skwa turtuk ta nzata həŋ ka za skwa zay ma watgha taŋ. Nda rfu nda rfu, nda ŋuɗuf turtuk ta za həŋ. ");
INSERT INTO xed_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ta zləzlvay həŋ ta Lazglafta, ta mamay inda mnduha ta həŋ. Inda fitik Mgham Lazglafta ta sganaghatá gwal ta mbanafta tsi ta ghəŋa ghuɓa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ma sana fitik, ka sliʼaftá i Piyer nda Yuhwana ka dzaʼa da həga Lazglafta da maga duʼa ta nzemndi hkən ta fitik hawu. ");
INSERT INTO xed_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndusa nda watgha tsa həga Lazglafta ta hgə lu ka «watgha ɗina» ya, mamu sana mndu nda raghwa daga yagata, ta nzaku hada. Inda fitik lu ta tsukwadaghata ka nzanata hada, ŋa gatá skwi da gwal ta lami da tsa həga Lazglafta ya. ");
INSERT INTO xed_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ka nghaŋta tsi ta i Piyer nda Yuhwana ta lami da tsa həga ya. Ka gatə tsi ta skwi da həŋ. ");
INSERT INTO xed_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","«Ngha ta aŋni!» Ka i Piyer nda Yuhwana pghafta iri tida. ");
INSERT INTO xed_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ka nzatá tsi ka ngha həŋ, dzaʼa mutsay yu kasiʼi ta skwi da həŋ, kaʼa ma ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ka Piyer nda tsi mantsa: «Dər tsedi, dər dasu, haɗ da iʼi wa. Skwi ta nzakway da iʼi ná, tsaya dzaʼa vlaghata yu. Nda hga Yesu Kristi mnda la Nazaret, sliʼafsliʼa gha, ka mbaɗa ka ta mbaɗa!» ");
INSERT INTO xed_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kaʼa ka ksafta ta dzva zeghwi, ka sliʼanafta. Gi hadahada, mutsafta səla tsa mndu ya tsa ta mbraku. ");
INSERT INTO xed_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Gi vɗuk, sliʼaftani tsa ka sladata. Ka mbaɗə tsi ta mbaɗa. Ka lamə həŋ kawadaga da həga Lazglafta, ka dzaʼa tsatsi nda vavalaku, nda zləzlva Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Inda mndu ná, nda ngha ta mbaɗayni ta mbaɗa, ka dzaʼa nda zləzlva Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tsəmafta taŋ kazlay: Tsa mndu ta gɗata ta nzaku ka gatá skwi tawa tsa watgha həga Lazglafta ta nzakway ɗina yeya kəʼa, ka hluta zləŋ ta həŋ, ka ndərmim həŋ nda ndərmima ta skwi ta slata nda tsa mndu ya. ");
INSERT INTO xed_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tsaw tsa mndu mbanaf lu ya ná, lavaghu a tsatsi tavata i Piyer nda Yuhwana wa. Ka gazladaghata inda mnduha wanafta həŋ ma rmak, ta hgə lu ka «Rmaka Salumuŋ.» Ka ndərmim həŋ nda ndərmima demdem. ");
INSERT INTO xed_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na nghay Piyer ta tsaya, kaʼa nda tsa mnduha ta tskadaghatá vgha ya mantsa: «Ari wa la Israʼila, kabgawu ta kəl kuni ka ndərmima mbatá na mndu na mandana na? Kabgawu ta kəl kuni ka vuʼa aŋni, manda skwi aŋni ta mbanaftá na mndu na nda mbrakwa ŋni? Ndiʼa ta vgha ŋni nda Lazglafta ta mbanaftá na mndu na ra? ");
INSERT INTO xed_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tsaya a wa. Lazglafta i Abraham, nda Izak, nda Yakubu, nda dzidzíha mu ta maraŋta glakwa vuʼani Yesu Kristi, ya klaf kaghuni ka ghəŋa ghuni ka mblanaftá gwal dagaladagala yeya ma mnay Pilat kazlay: Zliŋwa na mndu na kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kaghuni, vziŋvza kuni ta mndu ya nda ghuɓa, mndu ya tɗukwa, ka laghu kuni ɗawaftá zlighunista mndu ya ta pslatá mnduha. ");
INSERT INTO xed_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ka dzatá kuni ta mndu ya nda hafu da tsi. Tahula dzata ghuni, ka sliʼaganaptá Lazglafta mataba gwal nda rwa. Ma tsa sliʼagapta sliʼagap tsi ya ná, nda nza aŋni ka masləmtsəkani. ");
INSERT INTO xed_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ma fatá ghəŋa ŋni ta Yesu, kəl mbrakwa tsa Yesu ya ka sliʼanaftá na mndu ta nghə kuni snaŋ kuni ta sladu na. Mantsa, ma fatá ghəŋ ta Yesu kəl na mndu na ka mutsafta mbaku guzlindiliŋ, manda ya ta nghə kuni demdem ya. ");
INSERT INTO xed_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Tsaw tama zwanama, tsa skwi magana kaghuni ta Yesu kawadaga nda gwal dagaladagala ya ná, nda kwala ghuni kul snaŋta magata kuni. ");
INSERT INTO xed_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mantsa ya dzanaghata Lazglafta ta ghəŋa skwi ya mna tsi manda ghalya nda ma wa inda la anabi kazlay: Dzaʼa ghuyay Kristi ta ɗaŋwa kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mbəɗanafwa nzakwa ghuni, ka mbəɗavata kuni tvə Lazglafta, ka plighunista tsi ta dmakwa ghuni. ");
INSERT INTO xed_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mantsa ya dzaʼa kəl Lazglafta ka vlaghunatá fitika hlaptá hafu, ŋa ghunəgaghunatani ta Yesu, ta nzakway ka Kristi zbaghunap tsi daga manda ghalya ya. ");
INSERT INTO xed_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ndanana karaku, nda ra nzaghuta Yesu Kristi ta luwa ka kzla mbəɗavafta inda skwi manda ya ghada Lazglafta ta mnata daga manda ghalya nda ma wa la anabi nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ka Musa na: “Dzaʼa ghunəgaghuna ghuna Lazglafta ghuni ta anabi manda iʼi, mataba zivra ghuni dzaʼa sabi tsi, ŋa snay ghuni ta inda skwi dzaʼa tsi mnaghunata. ");
INSERT INTO xed_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Inda mndu dzaʼa kwal kul sna gwaɗa tsa anabi ya, dzaʼa ghzlap ghzla lu mataba mnduha Lazglafta, dzaʼa dzadza lu guli,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kahwathwata ná, mnaŋnamna inda la anabi, zlraftani ta Samuyel, ha ka sabi ta sanlaha ta zlagapta tahula tsatsi, ta gwaɗa ta na fitika amu gitana na. ");
INSERT INTO xed_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ka ŋa ghuni taghunafta Lazglafta ta imi ta sləməŋ nda ma wa la anabi. Ka ŋaghuni dzrafta Lazglafta ta wi nda dzidza mu Abraham kazlay: Dzaʼa tfanaghatfa yu ta wi ta inda mndəra mnduha nda ma zivra gha kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tsaya kəl Lazglafta ka maraghunaŋtá kaghuni ta kwalvani karaku, ma ghunagaghatani da kaghuni ŋa tfaghunaghatawi, ka mbəɗaghunafta ŋa zlaŋtá ghwaɗaka skwi ta magə kuni,» ka Piyer. ");
INSERT INTO xed_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tata gwaɗa i Piyer nda mnduha, nda sliʼadaghata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal ta ngha həga Lazglafta, nda la Sadukiya. ");
INSERT INTO xed_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ta kuzlaŋta ta ŋuɗufa taŋ tsa skwi ta taghə i Piyer nda Yuhwana ŋa mnduha kazlay: Sliʼagapsliʼa Yesu ma mtaku, manda tsaya dzaʼa sliʼagapta mnduha guli ma mtaku kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ka hlaftá həŋ ta i Piyer, ka pghamta ma gamak ŋa hanay hada, kabga nda kuza vli. ");
INSERT INTO xed_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tsaw mataba tsa gwal ta snaŋtá tsa gwaɗa gwal ghunay ya, nda ndəgha həŋ ta zlghafta. Ta magay mbsaka taŋ ta dəmbuʼ hutaf. ");
INSERT INTO xed_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gamahtsimani, ka tskavata gwal dagaladagala mataba la Yahuda, nda la galata mndu, nda gwal ta tagha zlahu ŋa mnduha ma luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mataba taŋ, hada i Hana, ta nzakway ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda Kayifa, nda Yuhwana, nda Alegzandra, nda inda hamata mndəra gwal ta dra skwi ŋa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ka hlagaptá həŋ ta i Piyer nda Yuhwana ma gamak ka hladaghata ta kəma taŋ. Ka həŋ mantsa: «Nda mbrakwa wa, nda hga wa, magata kuni ta tsa skwi ya na?» ka həŋ ɗawaŋta. ");
INSERT INTO xed_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Piyer ya tani, nda ndəgha tsatsi nda Sulkum nda ghuɓa. Kaʼa nda həŋ mantsa: «Ari wa gwal dagaladagala ta ghəŋa mnduha, nda la galata mndu! ");
INSERT INTO xed_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Wana gita, ta ɗaway lu da aŋni ta ghəŋa skwi ɗina magana ŋni ta mndu si nda raghwa. Ta ɗaway lu da aŋni ka waka ya mndu ya magay kəl tsi ka mbafta. ");
INSERT INTO xed_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mantsa nzakwani, ɗina ka snaghunamta, mantsa ya ŋa inda la Israʼila guli. Na mndu ta sladu ta kəma ghuni na ná, nda mbrakwa hga Yesu Kristi, mnda la Nazaret, ya dza kuni ta udza zləŋay, ka sliʼaganaptá Lazglafta ma mtaku ya, mbafta tsi. ");
INSERT INTO xed_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ta tsa Yesu ta mnə defteri kazlay: Pala ya wuɗidiŋ kaghuni gwal ba həga ta nzakway ka palaka tughwa həga kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ma tsatsi ta mutsakwa hafu, kabga haɗ sana mndu ta ghəŋa tsatsi vlaga Lazglafta ta ghəŋa haɗik tender ŋa mba amu wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ka ndərmim tsa gwal dagaladagala ta tskavata ya ta tatá us ta ira i Piyer nda Yuhwana. Ka nghə həŋ guli ná, má si ka gratá mndu həŋ, dzaŋa a dzaŋa taŋ wa. Gwal tani ta dzaʼa mista Yesu ya ka hahəŋ ta gray. ");
INSERT INTO xed_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ta nghə həŋ guli ná, wya tsa mndu nda mba ya ta sladu ta kəma taŋ, haɗ sana skwi laviŋ həŋ ta mbəɗay wa. ");
INSERT INTO xed_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ka ghunigiŋtá həŋ dzibil ta i Piyer nda Yuhwana ma tsa həga dzra gwaɗa ya, ka nzatá hahəŋ hahəŋ ka dzra gwaɗa ta ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ka həŋ mantsa: «Waka mu dzaʼa magay nda na mnduha na na? Wana nda sna inda mnduha ma Ursalima kahwathwata kazlay: Hahəŋ ta magatá tsa mazəmzəm ya kəʼa, laviŋ a amu ta waɗay guli wa. ");
INSERT INTO xed_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kada kwala na skwi na ta tuta katakata da mnduha ná, dvanaghamadva ta həŋ, yaha həŋ walglaŋta gwaɗa ta tsa Yesu ya dər ŋa wa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ka hgəgladamtá həŋ ta i Piyer, ka davanaghata həŋ. Ka həŋ mantsa: «Yaha kuni walglaŋta gwaɗaŋtá gwaɗa ta Yesu, dər ka tagha skwi ŋa mnduha nda hgani,» ka həŋ nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama ka i Piyer nda Yuhwana mantsa: «Mal sna ŋaghuni ka zlaŋta ŋa Lazglafta skwi ta raku re, ari mal sna ŋa Lazglafta a na? Tsawa tsa kaghuni ka ghəŋa ghuni ta gumani. ");
INSERT INTO xed_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aŋni ta ŋni, laviŋ a aŋni ta hafta wi kul haɗ ta gwaɗa ta ghəŋa skwi ya nghaŋ aŋni nda ira ŋni, nda ya snaŋ aŋni nda sləməŋa ŋni wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ka dvəglanaghatá tsa mnduha ya ta həŋ ka zliŋtá həŋ, haɗ skwi mutsaf həŋ prək ka hamtá həŋ ta ghəŋa skwi maga həŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tsa mndu mbanaf lu nda mazəmzəm ya ná, ta malay imani ta fwaɗ mbsak. ");
INSERT INTO xed_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tahula zliŋtá i Piyer nda Yuhwana, ka sliʼaftá həŋ ka laghu slanaghatá graha taŋ ma ghuɓa taŋ. Ka rusanaftá həŋ ta inda skwi mnana la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu, ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na snaŋta tsahaya ta tsa skwi ya rusanaf lu ta həŋ ya, ka gwaftá həŋ ta wi ka maga duʼa da Lazglafta. Ka həŋ mantsa: «Mghama ɗa, kagha ta zlaganaptá luwa nda haɗik, nda drəf, nda inda skwiha ma həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kagha ta gwaɗagapta nda mbrakwa Sulkum nda ghuɓa, nda ma wa dzidza ŋni Dawuda, vuʼa gha kazlay: “kabgawu ta kəl na mnduha na ka baruvtá vgha? Kabgawu ta kəl həŋ ka ndandanaku ka bətbət? ");
INSERT INTO xed_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hbafhba mghamha ta ghəŋa haɗik ta vgha ŋa vulu. Guyafguya gwal nda mbra ta wi ta ghəŋa Mgham Lazglafta nda ya ta ghəŋa Mgham tfanagha tsi ta wi” kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mantsa ya guli ná, guyaf guya i Hiridus nda Pwaŋəs Pilat ta wi ma na luwa na kawadaga nda sanlaha ma mndəra mnduha, nda la Israʼila ta ghəŋa kwalva gha ya nda ghuɓa, ta nzakway ka Yesu, mndu ya tfanagha ka ta wi. ");
INSERT INTO xed_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Skwi ya kumaŋ ka, ghada ka ta fata nda mbrakwa gha maga həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ndanana Mghama ɗa, ngha ka həŋ ta lma aŋni ɓa. Vlaŋvla ta mbraku ta vuʼaha gha ŋa mna gwaɗa gha nda tatá us ta iri. ");
INSERT INTO xed_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Maraŋ mbrakwa gha, mbamba ta gwal kul ɗughwanaku, maga ta mazəmzəmha, nda mandərmimi nda hga Yesu kwalva gha ya nda ghuɓa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Manda kɗakwa taŋ ta ndəɓatá tsa dzvu ya, ka ghudzavaftá tsa vli tskava həŋ ya. Ka ndəghaftá həŋ demdem nda Sulkum nda ghuɓa, ka mnə həŋ ta gwaɗa Lazglafta nda tatá us ta iri. ");
INSERT INTO xed_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Inda tsa gwal zlghay nda ŋuɗuf ya, ka skwa turtuk ŋuɗufa taŋ, ka skwa turtuk ndana taŋ guli. Haɗ mndu ya ta mnay kazlay: Ŋa ɗa yeya kəʼa wa. Tuts ka skwa turtuk skwa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nda kuzla nda kuzla ta gwaɗa gwal ghunay ta gwaɗa ta sliʼagapta Mgham Yesu. Ka tfə Lazglafta ta wi ta ghəŋa taŋ demdem. ");
INSERT INTO xed_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mataba taŋ, haɗ ya ta pɗata skwa dzvu wa. Tsaw inda gwal nda vwah da həŋ, nda həga da həŋ mataba taŋ ya ná, ta dzawiŋ dzawa həŋ ka hlaktá tseda skwi ya dzawiŋ həŋ ");
INSERT INTO xed_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ka vlaŋtá gwal ghunay. Mbaɗa lu ka dgay ŋa inda mndu taɓta skwi ya ɗvaŋ mndu ŋa maga slnani nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Manda Yusufu, ta nzakway tekw ka mnda la Levi, ya ya lu ma luwa Kiprus, tsanaf gwal ghunay ta hgani ka Barnabas, manda mnay kazlay, «zwaŋa ufa vgha» kəʼa ya: ");
INSERT INTO xed_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ka skwaptá tsatsi ta ŋani vwah, ka klaktá tsedani ka vlaŋtá gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mamu sana mndu guli ta hgə lu ka Hananiya nda markwa taŋ Safira. Ka skwaptá hahəŋ ta vwaha taŋ guli. ");
INSERT INTO xed_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ka dzraftá həŋ nda markwa taŋ, ka ɗifanaghutá tsa tsedi ya, ka klaktá pɗakwani, ka vlaŋtá gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ka Piyer nda tsi mantsa: «Ari Hananiya, kabgawu kəl ká ka zlanaŋtá ŋuɗufa gha ta halaway, ka tsakalanatá wi ta Sulkum nda ghuɓa, ka ɗifanaghutá tseda tsa vwah skwap ka ya na? ");
INSERT INTO xed_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ta kul skwaptá ka ná, ka ŋa gha a nzakwani ra? Tahula skwapta gha guli, ka ŋa gha a tsedani guli ra? Waka ka kurata magatá skwi mandana na? ŋa mnduha a tsakalanata ka ta wi wu, ŋa Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na mnata lu ta tsa gwaɗa ya, ka zləmbatá Hananiya, ka mtuta. Ka hlutá zləŋ ta inda gwal ta snaŋtá tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ka sliʼaftá duhwalha, ka ɗahamta, ka klaghata paɗamta. ");
INSERT INTO xed_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tahula luta awa hkən manda paɗamta, ka lamə markwa taŋ, sna a tsatsi ta skwi ta slata wa. ");
INSERT INTO xed_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ka piyer nda tsi mantsa: «Ari makwana, mniha mna, mandana na tseda tsa vwah skwap kuni ya ra?» kaʼa. «Aŋi, mantsa ya skwapta ŋni,» ka tsa marakw ya. ");
INSERT INTO xed_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ka Piyer mantsa «Waka kaghuni dzrafta kawadaga ta dzəgha Sulkuma Mgham Lazglafta na? Wya tsa gwal ta paɗamtá zəʼala ghuni ya ta watgha, dzaʼa tsukwaghatá kagha guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Gi hadahada, ka zləmbatá tsi ta kəma Piyer ka mtuta. Ta lamə tsa duhwalha ya ná, nda mta. Ka tsukwaghatá həŋ, ka laghwi da paɗamta tavata zəʼala taŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ka ksaftá tsi ka zləŋ ta gwal zlghay nda ŋuɗuf, nda hamata sanlaha ta snaŋtá tsa skwi ya. ");
INSERT INTO xed_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nda ndəgha mazəmzəm nda mandərmimi maga gwal ghunay mataba mnduha. Snusna gwal zlghay nda ŋuɗuf ta tskavata kawadaga ma rmaka həga Lazglafta ta hgə lu ka rmaka Salumuŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Haɗ sana mndu ta guya vgha nda həŋ wa. Kulam nda va tsa, ta ghubay lu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta sgaku nda sga ndəghata zgwana nda miʼaha ta zlgha Mgham Yesu ta sgavaghata ta ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ta hlakhla lu ta gwal kul ɗughwanaku, ka pghatá həŋ ta wa tvi ta kativiŋ nda ya ta pəta, ŋa lanaghata dər sulkuma Piyer yeya tsi ta sanlaha ma həŋ ta labə tsi ta tvi. ");
INSERT INTO xed_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nda ndəgha gwal ta gazlakta ma luwaha ta wanaftá Ursalima ta hlakta gwal kul ɗughwanaku, nda gwal nda kasa da ghwaɗaka sulkum, ka mbambafta həŋ demdem. ");
INSERT INTO xed_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mbaɗa mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal tavatani, ta nzakway ka la Sadukiya, ka dra gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ka sliʼaftá həŋ ka hlaftá gwal ghunay, ka pghamtá həŋ ma gamak. ");
INSERT INTO xed_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Girviɗik, ka gwaniŋtá duhwala Mgham Lazglafta ta watgha tsa gamak ya ka hligiŋtá gwal ghunay mida. ");
INSERT INTO xed_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kaʼa nda həŋ mantsa: «Lawala da həga Lazglafta ka mna kuni ta gwaɗa ta ghəŋa tsa lfiɗa hafu ya ŋa mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ka snatá tsa gwal ghunay ya ta tsa gwaɗa ya ka sliʼaftá həŋ bit tgha ka laghwi da həga Lazglafta ka tagha skwi ŋa mnduha hada. Ka tskavata i mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda gwal tavatani, nda la galata mndu mataba la Yahuda, ŋa dzra gwaɗa. Ka ghunaftá həŋ ta mnduha ŋa dzaʼa hlagaptá tsa gwal ghunay ya kay, ma gamak. ");
INSERT INTO xed_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ta lagha tsa gwal ghunaf lu ya ná, kuɗataŋ haɗ həŋ ma tsa gamak ya wa. Ka vradaghata həŋ da mnay ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ka həŋ mantsa: «Ta lagha aŋni kay ná, tɗetsa nda ha watgha gamak manda va vlani, ta hada tsa gwal ta nghay ya guli ma vla taŋ. Buts ka ŋni gunatá tgha ná, kuɗataŋ, haɗ mndu mida wu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na snaŋta taŋ ta tsa gwaɗa ya ná, nda ndərkawa ka i mghama ngha həga Lazglafta nda la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nzata. Snəgla a həŋ ta skwi ŋa mnay wa. Ka həŋ mantsa: «Nu ta magaku nda tsa gwal ghunay ya,» ka həŋ ɗaɗawavusta. ");
INSERT INTO xed_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tata tsa ndanə ya həŋ, ka sagha sana mndu da mnay ŋa taŋ. Kaʼa mantsa: «waʼa tsa mnduha si ham kuni ma gamak ya kay ma həga Lazglafta ta tagha skwi ŋa mnduha,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ka sliʼafta tsa mali ta ghəŋa gwal ngha həga Lazglafta ya kawadaga nda sludzihani, ŋa hlakta həŋ. Ka mbraku mbrakwa a hlakta həŋ ta həŋ tama wu, kabga ta zləŋay həŋ ta zləzlərtsata mnduha ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Hlakta taŋ ta həŋ, ka hladaghatá həŋ ta həŋ ta kəma tsa gwal dagaladagala ya. Ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta mantsa: ");
INSERT INTO xed_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Lmaf a ŋni ta kaghuni ka taghəgəltá skwi ŋa mnduha nda hga tsa mndu ya kay ra? Wana ndanana, tiŋtá kuni ta tagha skwa ghuni ma luwa Ursalima. Ta kumay kuni ta vzaŋnamtá tɓaŋ ma lwi ta gwaɗa ta mtakwa tsa mndu ya,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ka i Piyer kawadaga nda sanlaha ma gwal ghunay nda tsi mantsa: «Mal sna gwaɗa da Lazglafta ka ya da mnduha. ");
INSERT INTO xed_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Lazglafta dzidzíha mu ta sliʼaganaptá Yesu si dza kuni ma zləŋafta ghuni ta udzu ya. ");
INSERT INTO xed_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tsatsi kapanaf Lazglafta ka Mgham ka fata nda ga zeghwani, ka mnda mba mndu, ŋa vla tvi ŋa mnduha la Israʼila ŋa mbəɗanafta taŋ ta nzakwa taŋ, ŋa mutsafta taŋ ta platá dmakwa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aŋni, kawadaga nda Sulkum nda ghuɓa, ya ta vlə Lazglafta ŋa gwal ta sna gwaɗani ya ná, masləmtsəka tsa skwi ya aŋni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ka kuzlanaftá tsi ta ŋuɗuf ta tsa gwal dagaladagala ya. Ta kumay həŋ má ta zaɗanatá tsa gwal ghunay ya. ");
INSERT INTO xed_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ka sliʼavata sana la Farisa mataba tskatá mndu, Gamaliyel hgani, mndu ta tagha zlahu ŋa mnduha ya, ta tsatsi ta fa mnduha ta iri. Kaʼa mantsa: «Ka labla na mnduha na dzibil,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kaʼa nda tsa tskata mnduha ya tama mantsa: «Mnduha la Israʼila, ɗaswa ka kuni nda skwi dzaʼa kuni da magay ŋa na mnduha na. ");
INSERT INTO xed_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Diʼiŋaghu a fitikani manda zlagapta sana mndu ta hgə lu ka Tewdas ta mnay kazlay: Haɗ mndu taɓta iʼi wu kəʼa. Ta magay mnduha ta fwaɗ dərmək ta laghwi mistani. Ka dzatá lu ta tsatsi, ka gazlatá tsa gwal si ta dzaʼa mistani ya. Ta haɗ lu tata gwaɗa tida wa. ");
INSERT INTO xed_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tahula tsa, ka zlagaptá sana mndu ta fitika vinda hga mnduha, Zudas mnda la Galili. Ka waghatá tsi ta ndəghata mnduha mistani. Ka dzatá lu ta tsatsi guli, ka gazlatá tsa gwal ta laghwi mistani ya. ");
INSERT INTO xed_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Skwi ya ta mnaghunata yu ndanana tama, ma magaŋ kuni ta sana skwi nda na mnduha na. Ka tsa a nda tsa həŋ ta na skwi na katsi, mamu kɗavaktani. ");
INSERT INTO xed_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ala, ka sagha da Lazglafta tsi katsi ná, laviŋta a kuni ta lɓanata wa. Ɗaswa ka kuni nda lmu dzaʼa kuni lmay nda Lazglafta,» kaʼa nda həŋ. Ka snanatá tsa mnduha ya ta tsa gwaɗani ya. ");
INSERT INTO xed_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ka hgəgladamtá həŋ ta tsa gwal ghunay ya da həga, ka ɗgaptá həŋ. «Yahayaha kuni walglaŋta gwaɗaŋtá gwaɗa nda hga Yesu,» ka həŋ nda i Piyer. ");
INSERT INTO xed_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ka sliʼaftá tsahaya ka laghwi nda rfu, nda mnay kazlay: Nda ra kuni ka ghuya ɗaŋwa ta ghəŋa Yesu, ka Lazglafta nda aŋni, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Inda fitik tama, zlana a həŋ ta tagha skwi ŋa mnduha, nda mna gwaɗa ta ghəŋa Lfiɗa Gwaɗa ta ghəŋa Yesu Kristi ma həga Lazglafta nda ya ma həga ga mnduha wa. ");
INSERT INTO xed_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma tsa fitik ya, ta sgaku nda sga gwal ta zlghafta. Ka ŋaɗ la Grek ta ghəŋ ta ghəŋa la Hebru, kabga inda fitika dga skwa zay, ta zazanap zaza lu ta wadgaha taŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ka hgaftá tsa gwal ghwaŋpɗə his ya ta inda gwal zlghay nda ŋuɗuf. Ka həŋ mantsa: «Ra a ka zlanata aŋni ta mna gwaɗa Lazglafta ka laghwi da dga skwa zay wa. ");
INSERT INTO xed_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tsaya tama zwanama, mal zabapta ghuni ta mnduha ndəfáŋ mataba ghuni, gwal nda ɗifil ma ghəŋa taŋ, ka zlanaŋta ŋni ta tsa slna ya ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aŋni ya, ka dihavata ŋni ka maga duʼa nda mna gwaɗa Lazglafta,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ka zɗəganatá tsa gwaɗa ya ta inda mnduha. Ka zabaptá həŋ ta i Atiyen, ta nzakway ka vərɗa mnda zlghay nda ŋuɗuf, nda ndəgha nda Sulkum nda ghuɓa ya guli, nda Filip, nda Prukur, nda Nikamur, nda Timan, nda Permenas, nda Nikwala mnda luwa Aŋtakiya si ta tsuʼaftá dina la Yahuda ya. ");
INSERT INTO xed_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ka hlaktá həŋ ta həŋ maranaŋtá gwal ghunay. Ka maganaghatá tsaha ya guli ta duʼa ta ghəŋa taŋ nda fanaghatá dzvu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka sgavaghatá tuta gwaɗa Lazglafta. Ka sgavaghatá gwal zlghay nda ŋuɗuf ma luwa Ursalima. Nda ndəgha gwal dra skwi ŋa Lazglafta katakata ta faftá ghəŋa taŋ ta Yesu guli. ");
INSERT INTO xed_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ka zɗanaŋtá Lazglafta ta huɗi ta Atiyen, ka vlaŋtá mbraku, ka magə tsi ta mazəmzəmha nda skwiha ka mandərmimi mataba mnduha. ");
INSERT INTO xed_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ka sliʼavaftá sana mnduha, ka zlərɗawi nda Atiyen. Tsa mnduha ya ná, gwal ta nzakway ma həga tagha skwa la Yahuda həŋ. «Gwal hlap lu ma ga vuʼa,» i la Sireŋ, nda la Alegzandri, nda la Silisi, nda la Asiya, həŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tsaw laviŋ a həŋ ta ŋrapta nda gwaɗa wu, kabga vlaŋvla Sulkum nda ghuɓa ta ɗifil ta Atiyen. ");
INSERT INTO xed_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ka baraftá həŋ ta sanlaha ma mnduha, ŋa mnay taŋ kazlay: Nda sna aŋni ta razayni ta i Musa nda Lazglafta kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mantsa ya, ka sliʼanaftá həŋ ta ghəŋ ta dəmga nda la galata mndu, nda gwal tagha zlahu. Tahula tsa, ka valaftá həŋ ta Atiyen, ka ksaghatá da vla tska vgha taŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ka hlaftá həŋ ta tsakalawi. Ka həŋ mantsa: «Haɗ na mndu na ta zlaŋtá raza həga Lazglafta mu nda ghuɓa, nda zlaha Musa tani wa. ");
INSERT INTO xed_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nda sna ŋni ta mnayni kazlay: Dzaʼa dzaɓiŋdzaɓa tsa Yesu mnda la Nazaret ya ta həga Lazglafta, ka mbəɗanaftá nzaku ya snu mu mida vlama Musa ya guli kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka pghaftá inda tsa gwal ma tsa həga ya ta iri ta Atiyen, ka nghay. Tata nghaynghay həŋ, ka mbəɗavaftá kumani manda ŋa duhwala Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta nda tsi mantsa: «Tsaw mantsa na skwi ta gwaɗə lu ta kagha na rki na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ka Atiyen mantsa: «Zwanama ɗa nda dadaha ɗa, maranaŋmara Lazglafta dagala ta ghəŋani ta dzidza mu Abraham ta tsa fitika nzakwani ta haɗika Mezaputami ya, ma kɗə tsi ka laghwi da nzata ma luwa Haraŋ. ");
INSERT INTO xed_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kaʼa nda tsi mantsa: “Zlaŋzla ta haɗika gha, nda la ghuni tani, ka dzaʼa ka ta haɗik ya dzaʼa maraghata yu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mantsa ya, ka sliʼaftá tsi ka zlaŋtá haɗika Kaldiya ka laghwi da nzata ma luwa Haraŋ. Tahula mtatá dani ka sliʼaftá tsi ka laghwi da nzata ma na haɗik ta nzaku kaghuni mida gitana na. ");
INSERT INTO xed_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ma tsa fitik ya, haɗ vli vlaŋ Lazglafta ka ŋani dər ka kwitikw wa. Ama ka tanaftá Lazglafta ta imi ta sləməŋ kazlay: Dzaʼa vlaghavla yu ta na haɗik na, ŋa nzakwani ka ŋa gha, nda ya ŋa zivra gha tani kəʼa. Ma tsa fitik ya, ta mutsaf a Abraham ta zwaŋ karaku wa. ");
INSERT INTO xed_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kaʼa nda tsi guli mantsa: “Dzaʼa laghula zivra gha da nzapta ta sana haɗik ma mayəm, ŋa dulay lu ta həŋ, ka ga vuʼa ŋa taŋ hada ka vaku fwaɗ dərmək. ");
INSERT INTO xed_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Iʼi dzaʼa ganap ta iri ta tsa gwal ta dula həŋ ya guli. Tahula tsa, ŋa sliʼafta taŋ ka saghwi da tsəlɓu ma ghuva ɗa ma na vli na,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ka dzraftá Lazglafta ta wi nda Abraham. Tsiŋtá fafaɗ, na ŋizla tsa dzratawi ya. Tsaya kəl Abraham ka tsanatá fafaɗa zwaŋani Izak baɗu matghasa fitik manda yagata. Mantsa ya Isiyaku, ka tsanatá tsi ta ŋa Yakubu. Yakubu guli, ka ɗatsanatá tsi ta ŋa zwanani ghwaŋpɗə his, ta nzakway ka dzidzíha mu ya. ");
INSERT INTO xed_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ka drə dzidzíha mu ta Yusufu, ka skwaptá həŋ. Ka klaghatá lu da ga vuʼa ma luwa Masar. Nziya nza tsi, kawadaga Lazglafta nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ka klaptá tsi ma ɗaŋwani, ka vlaŋtá ɗifil ŋa gwaɗa nda Firʼawna ta nzakway ka mghama Masar. Ka zɗəganatá tsi ta tsa mgham ya. Ka fatá mgham ka ŋumna haɗika Masar, ka zwirani kəʼa fata guli. ");
INSERT INTO xed_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ka slatá maya ta inda haɗika Masar nda ya ta haɗika Kanʼana. Ghuyaŋ ghuya lu katakata. Ka traptá dzidzíha mu ta skwi ŋa zaŋta. ");
INSERT INTO xed_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ka snaŋtá Yakubu kazlay, mamu skwa zay ta haɗika Masar kəʼa. Ka ghunadaptá tsi ta dzidzíha mu nda taŋtaŋa səla taŋ. ");
INSERT INTO xed_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka ləglap həŋ nda mahisa səla, ka mnanaŋtá Yusufu ta ghəŋani ta zwanamani. Ka snaŋtá Firʼawna ta mndəra taŋ guli. ");
INSERT INTO xed_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ka tsghaftá Yusufu ta lwi, ŋa hlagaghutá i dani Yakubu nda la ga taŋ tani. Ta magay mbsaka taŋ ta ndəfáŋ mbsak hutaf mida. ");
INSERT INTO xed_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ka laha Yakubu da luwa Masar. Hada mtuta tsi. Mantsa ya dzidzíha mu guli. ");
INSERT INTO xed_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ka hlaftá lu ta mbla taŋ ka hlakta da luwa Sikem. Ka papaɗamtá həŋ hada, ma vli ya skwa Abraham nda tsedi da zwana Hamur ma luwa Sikem. ");
INSERT INTO xed_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Manda ndusakta tsa fitik ŋa magakwa tsa skwi tanaf Lazglafta ta imi ta sləməŋ ta Abraham ya, ka sgavaghatá yavafta mndəra amu ma luwa Masar. ");
INSERT INTO xed_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka laf sana mgham ta pala ma luwa Masar, sna a tsatsi ta Yusufu wa. ");
INSERT INTO xed_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ka nənɓaptá tsi ta mndəra amu. Ka dulu tsi ta dzidzíha mu, ŋa vlata taŋ ta zwana taŋ tkweʼ ŋa rwanatá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma tsa fitik ya, ka yatá lu ta Musa. Káka nda ɗinakwani, zɗəganazɗa ta Lazglafta guli. Ka zatá tsi ta tili hkən ta glaku ma həga ga dani. ");
INSERT INTO xed_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Manda kɗakwa dadahani ta klafta ka laghwi ɗifanata, ka slafta makwa Firʼawna tida ka klaftá tsi ka klaghata glanafta ka zwaŋani. ");
INSERT INTO xed_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mantsa, ka taghanaftá lu ta Musa ta ɗifla la Masar, ka nzaku tsi ka mndu ta laviŋtá gwaɗa, nda mbra guli ma slnani. ");
INSERT INTO xed_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ka kumaftá Musa ta dzaʼa nghanaghatá la taŋ la Israʼila magafər imani ta fwaɗ mbsak. ");
INSERT INTO xed_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka nghaŋtá tsi ta sana mnda la Masar ta ghuya ɗaŋwa ŋa sana mnda la Israʼila. Ka lagha tsi kataŋta. Ka dzatá tsi ta tsa mnda la Masar ya ŋa play. ");
INSERT INTO xed_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ba dzaʼa nda sna zwanama ɗa kazlay: Iʼi fa Lazglafta ŋa mbanaftá həŋ kəʼa, ka tsatsi si ta ndanay, tsaw sna a hahəŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gamahtsimani, ka lagha Musa guyamtá ma lmu ta lmə gwal his mataba la Israʼila. Si ka kumə tsi ta dzranaftá həŋ. Kaʼa nda həŋ mantsa: “Graha ɗa! La zwanama kuni ná, kabgawu ta kəl kuni ka lmu na?” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ka tsa mndu ta zbaftá zwaŋamani nda lmu ya sliŋwidiŋtá Musa mantsa: “Wa ta faghamta ka mghama ŋni ŋa tsa guma ta aŋni na? ");
INSERT INTO xed_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ari ta kumay ka ta dzihata manda tsa dzata gha ta mnda la Masar ɗahawu ya a kay na?” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na snaŋtá Musa ta tsa gwaɗa ya, ka hwayaftá tsi ka laghwi ta haɗika Madiyaŋ. Ka yayatá tsi ta zwana zgwana his hada. ");
INSERT INTO xed_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Tahula zatani ta vaku fwaɗ mbsak hada, ka maranaŋtá duhwala Lazglafta ta ghəŋani ma vu ta mubuk ma mtak tavata ghwá Sinay. ");
INSERT INTO xed_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ka tsutá Musa ka nghay, nghər tsi ta tsa skwi ya. Ka gavadaghatá tsi ŋa tsəmanavata. Ta gavadaghatá tsi, ka snaŋtá tsi ta lwa Mgham Lazglafta. Kaʼa mantsa: ");
INSERT INTO xed_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Iʼi Lazglafta dzidzíha gha, ta nzakway ka Lazglafta Abraham, nda Izak, nda Yakubu ya, kaʼa. Ka ghudzaku Musa ta ghudzaku da zləŋ, Walglaŋ a ta nghay wa. ");
INSERT INTO xed_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ka Mgham Lazglafta nda tsi mantsa: Hlaphla ta ɓaɓah ma səla gha, kabga na vli slada ka na ná, haɗik nda ghuɓa ya. ");
INSERT INTO xed_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nghadap ngha yu ta ghuya ɗaŋwa ŋa mnduha ɗa ta ghuyə lu ma haɗika Masar. Sniɗigha sna ŋaɗa ghəŋa taŋ, kəl yu ka saha da hlaptá həŋ mida. Ndanana na, sawi ka ghuna yu ta kagha da luwa Masar,” kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Va tsa Musa si vziŋ la Israʼila kazlay, wa ta famtá kagha ka mgham, ŋa tsa guma ta ghəŋa aŋni na? kəʼa ya kay, va tsa tsatsi ya ghunaf Lazglafta ŋa nzakay ka mgham, ŋa mbanaftá mnduhani. Nda ma wa duhwala Lazglafta nghaŋ Musa ma vu ta mubuk ya, mnanata Lazglafta ta tsa gwaɗa ya ta Musa. ");
INSERT INTO xed_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tsa Musa ya ta hlagaptá zwana la Israʼila, nda maga mazəmzəm nda skwa ndərmimay ma haɗika Masar, nda ya ma drəfa Dva, nda ya ma mtak, ka zatá həŋ ta vaku fwaɗ mbsak ta tvi ma mtak. ");
INSERT INTO xed_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tsa Musa ya ta mnay nda zwana la Israʼila guli kazlay: Dzaʼa ghungaghunaghuna Lazglafta ta sana anabi manda va iʼi ta nzakway mataba mndəra ghuni ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ma fitika tskavata zwana la Israʼila ma zivak, tsa Musa ya ta nzakway ma takataka dzidzíha mu, nda duhwala Lazglafta ta gwaɗa nda tsi, ta ghwá Sinay ya. Hada tsuʼamafta tsi ta gwaɗa hafu ka klamakta. ");
INSERT INTO xed_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ka kwalaghutá dzidzíha mu ta snanata, ka vziŋtá həŋ, ka kuma vru da Masar. ");
INSERT INTO xed_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Magaŋnafmaga ta Lazglafta ŋa mbaɗa ta kəma ŋni, kabga sna a ŋni ta skwi ta slanaghatá nana Musa ta hlagaŋnapta ma Masar na wu,” ka həŋ nda Haruna. ");
INSERT INTO xed_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Mantsa fitik ya, ka tsaftá həŋ ta skwi manda zwaŋa sla ka pla ghəŋ ŋani, ka skalu ŋa skwi ya tsaf hahəŋ nda dzva taŋ. ");
INSERT INTO xed_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ka mbəɗanatá Lazglafta ta hul ta həŋ, ka zliŋtá həŋ ŋa tsəlɓu ŋa tekwatsaha ta luwa manda ya nda vinda ma deftera la anabi ta mnay kazlay: Ari la Israʼila, ŋa ɗa plihata kuni ta ghəŋ ma zata ghuni ta vaku fwaɗ mbsak ma mtak ya ra? ");
INSERT INTO xed_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ŋa ɗa a wa. Ŋa həga tumpula Mulku, nda fwata tekwatsa Refaŋ hlaf kuni ka pghata ka Lazglafta ghuni a tsi kay ra. Tsaya dzaʼa kəl yu ka hlaftá kaghuni ka tsughwaɗaghunaptá haɗika Babila, kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Ma nzakwa dzidzíha mu ma mtak ná, mamu si həga tumpul pgham lu ta huzla dzratawi nda Lazglafta mida, da həŋ. Manda va ya mnanaf Lazglafta ta Musa ŋa magaftani ya, ka magaftá tsi manda va ya nghaŋ tsi. ");
INSERT INTO xed_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tahula tsa, ka zlghaftá dzidzíha mu guli da dadaha taŋ. Ka pghaftá Dzesuwa ta həŋ ka hladamta da tsa haɗik ghzlaf Lazglafta ta mnduha mida ta kəma taŋ ya, kawadaga nda tsa həga tumpul ya. Ka nzaku tsi ha ka sagha ta fitika Dawuda. ");
INSERT INTO xed_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tsatsi zɗanaŋ Lazglafta ta huɗi, ka ɗawaŋtá da Lazglafta ŋa vlaŋtá tvi, ŋa banaftá həga nda ghuɓa, ta tsatsi Lazglafta Yakubu. ");
INSERT INTO xed_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nziya nza tsi tama, Salumuŋ ta baftá tsa həga ya. ");
INSERT INTO xed_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tsaw haɗ Lazglafta ta luwa ta nzaku ma həga baf mnda səla manda va ya mna Anabi kazlay: ");
INSERT INTO xed_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ta luwa vla nzakwa ɗa, vla fa səla ɗa ya guli ná, haɗik ya. Mndəra wati həga ya dzaʼa kuni biɗifta na? Wati vli ya prək ka lama ɗa dida na? ");
INSERT INTO xed_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Iʼi a ta magaftá tsa skwiha ya ra kəʼa ya.» ");
INSERT INTO xed_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ka Atiyen guli mantsa: «Kaghuni ná, təŋtəŋa ghəŋa ghuni. Ta hgə Lazglafta ta kaghuni ná, duduzla ka kuni nzata, va a kuni ta sna gwaɗa da Sulkum nda ghuɓa manda va tsa nzakwa dzidzíha ghuni ya wa. ");
INSERT INTO xed_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wati ma anabi ya kul ganaptá dzidzíha ghuni ta iri na? Ta pslapsla həŋ ta gwal ya ta mna gwaɗa ta ghəŋa mndu ta nzakway tɗukwa. Ta na fitik na guli, ka skwaptá kaghuni ta tsa mndu tɗukwa ya ka dzata. ");
INSERT INTO xed_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kaghuni ka ghəŋa ghuni ta tsuʼaftá zlahu nda ma dzva duhwala Lazglafta, ka kwalaghutá kuni ta snatá tsa zlahu ya guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na snay taŋ ta tsa gwaɗa ya, ka sliʼavaftá həŋ manda binzauŋ ta ghəŋa Atiyen, ka hiʼidə həŋ ta dzvu ka wuslikay. ");
INSERT INTO xed_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama ka nghadaftá Atiyen, mndu ya nda ndəgha nda Sulkum nda ghuɓa, ta luwa. Ka nghaŋtá tsi ta glakwa Lazglafta nda Yesu ta sladu nda ga zeghwa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kaʼa nda həŋ kay guli mantsa: «Wana nda ngha yu ta gunatá luwa. Waʼa Zwaŋa mndu ta sladu nda ga zeghwa Lazglafta,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ka hlaftá həŋ ta wi katakata, ka dzadzamtá dzvu ma sləməŋ, ka vavalaftá həŋ tida. ");
INSERT INTO xed_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ka tsəhaftá həŋ ka klaghata tahula luwa, ka zlərtsay nda pala ŋa dzata. Ka pghatá la ka masləmtsəka tsa skwi ya ta lguta taŋ da sana galaɓay, Sawulu hgani. ");
INSERT INTO xed_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ta zlərtsə həŋ ta Atiyen nda pala ya, ta magə tsatsi ta duʼa da Lazglafta. Kaʼa mantsa: «Mgham Yesu, tsuʼa ta hafa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ka tsəlɓatá tsi, ka gwaɗata nda lwi dagala. Kaʼa mantsa: «Mghama ɗa, ma mbəɗanaf ka ta həŋ ta na dmaku na,» kaʼa. Tahula mnatani ta tsaya, ka sabə hafu sref mida. ");
INSERT INTO xed_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ka zɗəganatá tsa dzatá Atiyen ya ta Sawulu. Baɗu tsa fitik ya zlrafta ghuya ɗaŋwa katakata ta slanaghatá gwal zlghay nda ŋuɗuf ma luwa Ursalima. Ka gazlaghutá inda gwal zlghay nda ŋuɗuf da sana vliha ta haɗika Zudiya, nda ya ta haɗika Samari. Gwal ghunay yeya ta pɗata hada. ");
INSERT INTO xed_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mamu sana mnduha ta zləŋa Lazglafta, ka paɗamtá həŋ ta Atiyen, ka tawamtá həŋ katakata. ");
INSERT INTO xed_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ŋa Sawulu ya tani, kuma zaɗanatá gwal zlghay nda ŋuɗuf ŋani. Ka dzaʼa tsi da həga da həga kasa zgwana nda miʼaha, ka pgha həŋ da gamak. ");
INSERT INTO xed_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tsa gwal ta gazlaghuta ya ná, ra luwa ŋa taŋ ta magay ka mna gwaɗa ta ghəŋa Lfiɗa Gwaɗa. ");
INSERT INTO xed_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ka laha Filip da luwa Samari, ka mnə tsi ta gwaɗa ta Kristi ŋa mnduha hada. ");
INSERT INTO xed_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Zɗəganazɗa tsa gwaɗa ta mnə Filip ya ta həŋ. Tets ka skwa turtuk ndəghata dəmga ta sna tsa gwaɗa ta mnə tsi ya, nda ya ta ngha tsa mazəmzəmha ta maga tsi ya guli, ");
INSERT INTO xed_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","kabga ta sliʼagapsliʼa ghwaɗaka sulkumha nda dza lili ma ndəghata mnduha. Nda ndəgha gwal nda raghwa, nda gwal matavaghu səla taŋ ta mbambafta. ");
INSERT INTO xed_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tsaya tama, ma rfu tsa luwa ya katakata. ");
INSERT INTO xed_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tsaw mamu sana mndu ta hgu lu ka Simuŋ ma tsa luwa ya. Nda kɗa fitikani ma tsa luwa ya ta ksa slna nda zava. Ta zləŋ nda zləŋa mnduha ma luwa Samari. Ka mndu dagala klafta tsi ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nda zwani tani, nda galata mnduha tani demdem, zɗəganazɗa tsa mndu ya ta həŋ. «Nana mndu na ná, mbrakwa Lazglafta ya ta hgə lu “ka mbraku dagala yeya,”» ka həŋ tazlay. ");
INSERT INTO xed_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Zɗəganazɗa tsa mndu ya ta həŋ, kabga nda kɗa fitikani ta maganatá slna ta həŋ nda tsa zavani ya. ");
INSERT INTO xed_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tahula zlghafta taŋ ta tsa gwaɗa Filip ta mnay ŋa taŋ ta ghəŋa Mgham Lazglafta, nda ya ta ghəŋa hga Yesu Kristi ya, ka maganaftá lu ta batem ta həŋ, nda zgwana tani, nda miʼaha tani. ");
INSERT INTO xed_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Va tsa Simuŋ ya guli, ka zlghaftá tsatsi, ka maganaftá lu ta batem. Ka ndiʼanavatá tsi ta vgha ta Filip, ka nghə tsi ta mandərmimiha nda mazəmzəmha ta magə Filip ya, ka ndərmim tsi. ");
INSERT INTO xed_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Snaŋta gwal ghunay ta nzakway ma Ursalima kazlay: Zlghafzlgha gwal ma luwa Samari ta gwaɗa Lazglafta kəʼa, ka ghunadaptá həŋ ta i Piyer nda Yuhwana, da həŋ. ");
INSERT INTO xed_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lagha tsahaya da həŋ, ka magə həŋ ta duʼa ta ghəŋa taŋ, kada mutsafta həŋ ta Sulkum nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tsaw si ta sa a Sulkum nda ghuɓa ta ghəŋa ya dər ka turtuk ma həŋ wa. Batem kweŋkweŋ yeya maganaf lu ta həŋ ma hga Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lagha i Piyer nda Yuhwana ka fanaghatá dzvu ta həŋ, ka mutsaftá həŋ ta Sulkum nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na nghay Simuŋ ta tsa vla Sulkum nda ghuɓa ŋa mnduha ma fanaghata gwal ghunay ta dzvu ta həŋ ya, ka klaftá tsi ta tsedi ka vlay ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kaʼa mantsa: «Vlihawavla ta tsa mbraku ya ta iʼi guli, ŋa mutsafta mndu dzaʼa fanaghata iʼi guli ta dzvu, ta Sulkum nda ghuɓa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ka Piyer nda tsi mantsa: «Ka zaɗa tseda gha nda kagha tani, ka si nda tsedi ta mutsa lu ta skwa mbalay da Lazglafta ka ka ta gray ya. ");
INSERT INTO xed_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Haɗ ŋa gha ma na skwi na wu, haɗ ima gha mida guli wu, kabga slada a ŋuɗufa gha dar ta kəma Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Vziŋvza ta tsa ghwaɗaka ndana gha ya, ka ɗawa ka da Mgham ta plighistani ta dmakwa tsa ndanagha ya, ka dzaʼa magaku tsi. ");
INSERT INTO xed_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ta nghadaptá yu ná, ksuksa ghwaɗaka skwi ta kagha, ma gamaka dmaku ka,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ka tsa Simuŋ ya nda həŋ mantsa: «Kdəkwakdək, magawa vərɗa kaghuni ta duʼa ta ghəŋa ɗa, kada kwala tsa skwiha mna kuni ya da sliɗighata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tahula mnaŋta taŋ ta gwaɗa ta ghəŋa Yesu Kristi nda gwaɗani tani, ka vraghatá həŋ da luwa Ursalima ka dzaʼa nda mna gwaɗa ma ndəghata sana luwaha ta haɗika Samari. ");
INSERT INTO xed_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ka duhwala Lazglafta nda Filip mantsa: «Sliʼafsliʼa ka dzaʼa ka nda Sud, ka dzaʼa ka da tsa vli ta saha ma Ursalima ŋa dzaʼa da luwa Gaza ya, ya ka mtak tsa vli ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ka sliʼaftá tsi ka laghwi. Tsaw mamu sana mnda la Itiyupi si ta laghwi da maga duʼa da Lazglafta ma luwa Ursalima. Tsa mndu ya ná, ka kuɓitik nzakwani. Mndu dagala ya ma slna, ma dzvani inda gadghəla sana marakw, Kandes hga tsa marakw ya ta nzakway ka Mghama la Itiyupi. ");
INSERT INTO xed_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ta vru tsi dzaghani, ka nzamtá tsi ma mwata plisani, ka dzaʼa nda dzaŋa deftera anabi Isaya. ");
INSERT INTO xed_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","«Gavadaghagava tavata ya mwata plis ya,» ka Sulkum nda Filip. ");
INSERT INTO xed_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ka ndadaghatá Filip. Ta snə tsi ná, ta dzaŋa deftera anabi Isaya tsa mnda la Itiyupi ya. Kaʼa nda tsi mantsa: «Nda sna ka ta na skwi ta dzaŋ ka na ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ka tsa mndu ya mantsa: «Waka yu dzaʼa snaŋta ka mniɗif a mndu na?» kaʼa zlghaftá wani. Ka hgadaftá tsi ta Filip nzanavata. ");
INSERT INTO xed_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wya tsa vli ta dzaŋ tsi ya: «Manda kla tuwak da vla hnay klaghata lu. Manda nzatá nzakwa zwaŋa tuwak kul haɗ ta gwaɗafta ta kwitsə lu ta swidani ya kəʼa nzata, pslaf a ta wani wa. ");
INSERT INTO xed_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma hanaganatani ta ghəŋani, ka tsanaghatá lu ta guma, ka dzata. Haɗ mndu dzaʼa kulaŋtá mndəra taŋ wu, kabga zaɗanazaɗa ta hafani ta ghəŋa haɗik,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ka tsa mnda la Itiyupi ya ɗawaŋta da Filip mantsa: «Kdəkkdək, mnihamna ka ta ghəŋa wa ta gwaɗa na anabi na ta na gwaɗa na! Ta ghəŋa ghəŋani re, ari ta ghəŋa sana mnda a na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ka zlraftá Filip ta gwaɗa ta ghəŋa tsa vli dzaŋaf tsi ya, ka mnanaŋtá tsi ta Lfiɗa Gwaɗa ta ghəŋa Yesu. ");
INSERT INTO xed_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tata mbaɗa həŋ ta tvi, ka lagha həŋ slafta ta imi ma ghwa. Ka tsa mnda la Itiyupi ya nda tsi mantsa: «Ya wana imi na ní, nu dzaʼa pyafta magaɗiftá batem na?» kaʼa.  ");
INSERT INTO xed_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","«Ka zlghafzlgha ka nda ŋuɗufa gha, ta magaku,» ka Filip. «Mantsa nzakwani, zlghafzlgha yu nda ŋuɗufa ɗa kazlay: Yesu Kristi ná, Zwaŋa Lazglafta ya kəʼa,» ka tsa mndu ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ka sladanatá tsi ta tsa mwata plisani ya. Ka saha həŋ nda Filip mida ka lamə həŋ da imi, ka maganaftá Filip ta batem. ");
INSERT INTO xed_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Manda kɗakwa taŋ ta sabi ma tsa imi ya, ka klaghatá Sulkuma Mgham Lazglafta ta filip, gi kuɗataŋ nghəgla a tsa mnda la Itiyupi ya wa. Ka kɗə tsatsi ta ksa tvani, ka dzaʼa nda rfu. ");
INSERT INTO xed_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ka zlagaptá Filip ma luwa Azutu. Ka rə tsi ta luwaha ka dzaʼa nda mna Lfiɗa Gwaɗa, ka laghwi trezekw da luwa Sezare. ");
INSERT INTO xed_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma tsa fitik ya, zlanava a Sawulu ta ghuyanaptá ɗaŋwa nda rwanatá duhwalha Mgham Yesu wa. Ka sliʼaftá tsi ka lagha slanaghatá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, ");
INSERT INTO xed_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ŋa ɗawaftá ɗelewer ŋa dzaʼani vlaŋtá la maliha ma həga tagha skwa la Yahuda ma luwa Damas. Tsa ɗelewer ya dzaʼa vlaŋtá tvi, ka slanaghasla tsi ta gwal zlghay nda ŋuɗuf hada, ŋa kasaftani ta həŋ ka hlakta da luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tata mbaɗa həŋ ta tvi, ndusadagha ndusa həŋ nda luwa Damas tama, ka saha tsuwaɗak wanaftá Sawulu. ");
INSERT INTO xed_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ka zləmbagatá tsi ta haɗik, ka snə tsi ta sana lwi ta hgay, kaʼa mantsa: «Sawulu! Sawulu! Kabgawu ta kəl ka ka giri ŋa ɗa na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","«Wa kagha ní Mghama ɗa?» Ka Sawulu nda tsi. «Iʼi Yesu ta gə ka tiri ŋa ɗa yeya, ");
INSERT INTO xed_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sliʼafsliʼa gha, ka dzaʼa ka da huɗa luwa Damas. Hada dzaʼa mnaghata lu ta skwi ŋa magay gha,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndandrakawa, ka tsa gwal ta pgha Sawulu ya nzata. Nda sna həŋ ta lwi mndani, ama ngha a həŋ ta tsa mndu ta gwaɗa ya wa. ");
INSERT INTO xed_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ka sliʼafta Sawulu ta haɗik. Kəʼa ka ngha yu ta vli kəʼa, ngha a ta vli wa. Ka ksafta lu ta dzvu ka klaghata da luwa Damas. ");
INSERT INTO xed_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ka zata tsi ta fitik hkən, ngha a ta vli wu, zaŋ a ta skwi wu, saŋ a ta imi guli wa. ");
INSERT INTO xed_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tsaw ma tsa Damas ya, mamu sana mndu zlghay nda ŋuɗuf ta hgə lu ka Hananiya. Ka Mgham Yesu nda tsi manda skwi ma suni mantsa: «Hananiya!» kaʼa. «Wana yu Mghama ɗa,» ka Hananiya. ");
INSERT INTO xed_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","«Sliʼafsliʼa ka dzaʼa ka ta tvi, ta tsa tvi ta hgə lu ka tvi nda ga zeghwi ya, ka ɗawaŋta ka ta sana mnda la Tarsus, ta hgə lu ka Sawulu, waʼa ma həga ga Yuda ya. ");
INSERT INTO xed_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ya waʼa ta maga duʼa ndanana. Ka nghaŋtá tsi manda skwi ma suni ta sana mndu ta hgə lu ka Hananiya ta lami ka fa dzvu ta ghəŋani, kada nghəglaŋta tsi ta vli,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ka Hananiya mantsa: «Mghama ɗa, nda ndəgha mnduha ta mnihatá gwaɗa ta ghəŋa tsa mndu ya, ka rusiftá həŋ ta inda ghwaɗaka skwi magana tsi ta mnduha gha ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ka sagha tsi da hadna nda mbraku ya mutsaf tsi da maliha ta ghəŋa gwal dra skwi ŋa Lazglafta, ŋa kasa inda gwal ta hgaŋtá hga gha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ka Mgham Yesu nda tsi mantsa: «La! Iʼi ta zbaptá tsa mndu ya ŋa ghunay ɗa, ŋa mnanaŋtá hga ɗa ta sanlaha ma mnduha, nda ya ŋa mghamha, mantsa ya guli ŋa mnduha la Israʼila. ");
INSERT INTO xed_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Dzaʼa maranaŋmara iʼi ka ghəŋa ɗa, ta inda ghuya ɗaŋwa ya tkweʼ dzaʼa tsi ghuyay ta ghəŋa hga ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ka sliʼaftá Hananiya tama ka laghwi. Ka lamə tsi da tsa həga ya. Ka fanaghatá tsi ta dzvu ta Sawulu. Kaʼa nda tsi mantsa: «Sawulu! Zwaŋama ɗa ka. Tsa Mgham Yesu ta maraghaŋtá ghəŋani ta tvi ya, ta ghuniɗikta ŋa nghəglaŋta gha ta vli, nda ya ŋa ndəghaghafta nda Sulkum nda ghuɓa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ka gi sliʼagata skwiha manda ŋulaŋ manda ŋulaŋ ta ira Sawulu, ka nghəglaŋtá tsi ta vli. Ka sliʼaftá tsi, ka maganaftá lu ta batem. ");
INSERT INTO xed_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ka zutá tsi ta skwa zay, ka vravaktá mbrakwani. Ka nzɗavatá tsi tsəɓakw fitik kawadaga nda gwal zlghay nda ŋuɗuf ma Damas. ");
INSERT INTO xed_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ka gi sliʼaftá tsi ka mnay ma həga tagha skwa la Yahuda, kaʼa mantsa: «Yesu ná, Zwaŋa Lazglafta ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ka ndərmim inda gwal ta snay nda ndərmima. Ka həŋ mantsa: «Nana mndu na a ta ganaptá iri katakata ta gwal ta hga hga Yesu ma luwa Ursalima kay ra? Sagha da kasa həŋ ŋa hlaŋtá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta a tsi kay ra?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ka gɗavatá Sawulu ka mnay: «Yesu ná, Kristi ya,» kaʼa. Ka kɓanaftá tsi ta la Yahuda ta nzakway ma luwa Damas. Sna a həŋ ta skwi ŋa zlghanaftawi wa. ");
INSERT INTO xed_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Labla fitik mida tama, ka dzraftá la Yahuda ta wi ŋa zba dzatá Sawulu. ");
INSERT INTO xed_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ka nzatá həŋ ta watgha luwa nda rviɗik tani, nda fitik tani ka ɗakwatsay ŋa dzata. Ka slramtá tsa skwi dzraf həŋ ya da sləməŋa Sawulu. ");
INSERT INTO xed_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ta sana rviɗik tama, ka famtá gwal zlghay nda ŋuɗuf ta Sawulu ma gwadzegwer ka tsghigiŋta nda ta ghurum ta muhula luwa. ");
INSERT INTO xed_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ɓhadaghatani da luwa Ursalima, ka zbə tsi ta guyaftá vgha nda gwal zlghay nda ŋuɗuf. Ka zləŋə həŋ nda zləŋa, kabga graf a həŋ kazlay, vərɗa mnda zlghay nda ŋuɗuf ya kəʼa wa. ");
INSERT INTO xed_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama ka klaftá Barnabas, ka pghadaghata slanaghatá gwal ghunay. Ka rusanaftá Barnabas ta həŋ ka Sawulu nghaŋtá Mgham Yesu ma tvi, nda ya ka Mgham Yesu gwaɗganata. Rusanafha ta həŋ guli, kinawu ka Sawulu fatá ghəŋani ka mna Lfiɗa Gwaɗa nda hga Mgham Yesu ma luwa Damas. ");
INSERT INTO xed_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Daga baɗu tsa ya, ka ksaftá tsi ta nzaku nda həŋ. Ta labla həŋ, ta vrakvra həŋ ta mna Lfiɗa Gwaɗa nda hga Mgham Yesu ma Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ta gwaɗgana gwaɗa ta la Yahuda nda sna ta gwaɗa Grek, ta zlərɗay ta gwaɗaha nda həŋ. Ŋa taŋ tani, zba htsiŋani ŋa dzata ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Snaŋta zwanama, ka pghaghatá həŋ da luwa Sezare. Hada, ka ghunaghatá həŋ da luwa Tarsus. ");
INSERT INTO xed_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma tsa fitik ya, lefɗekw nzata nzakwa guyatá ghəŋa gwal zlghay nda ŋuɗuf ta haɗika Zudiya, nda ya ta haɗika Galili, nda ya ta haɗika Samari. Ta mbray həŋ ta vgha ka nzaku nda hanatá ghəŋ mista Mgham Yesu. Ta sgaku nda sga həŋ nda zɗakatahuɗa Sulkum nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyer ya ná, ra inda vli ka naghanaghatá gwal zlghay nda ŋuɗuf ŋani. Ma sana fitik, ka laha tsi nghanaghatá gwal zlghay nda ŋuɗuf ma luwa Lida. ");
INSERT INTO xed_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ka slaftá tsi sana mndu ta hgə lu ka Ayniya ta hani ta ghzləŋ. Ma tghasa vakwani tsa manda raghwatani. ");
INSERT INTO xed_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ka Piyer nda tsi mantsa: «Ayniya! Yesu Kristi ta mba kagha. Sliʼafsliʼa ka payanata ka ta ghzləŋa gha,» kaʼa. Ka gi sliʼaftá Ayniya. ");
INSERT INTO xed_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nghaŋta inda gwal ma luwa Lida, nda gwal ma daɓi ma luwa Siruŋ ta tsa mndu ya ná, ka zlghaftá həŋ ta Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mamu sana marakw ma luwa Yafa ta hgə lu ka Tabita mataba gwal zlghay nda ŋuɗuf. Tsaya «Durkas» nda gwaɗa Grek, manda mnay kazlay: Madva kəʼa ya. Dagala ŋerma skwi maga tsi, ta katay ta gwal ka pɗu. ");
INSERT INTO xed_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma tsa fitikha ya, ka ksaftá ɗaŋwa ka mtutá tsi. Tahula mbazata, ka klaftá lu ka famta ma dzuguvi ta ghəŋa sana həga. ");
INSERT INTO xed_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tsaw ndusa tsa luwa Yafa ya nda luwa Lida. Ka snaŋtá tsa gwal zlghay nda ŋuɗuf ma Yafa ya kazlay, waʼa Piyer ma luwa Lida kəʼa. Ka ghunadaptá həŋ ta mnduha his da tsi. Ka həŋ nda Piyer mantsa: «Kdəkkdək sawi misimmisim da aŋni,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ka sliʼaftá Piyer ka labə kawadaga nda tsa mnduha ya. Manda ɓhadaghatani, ka kladaftá lu da tsa dzuguvi ta ghəŋa sana həga ya. Ka sliʼaftá inda miʼa wadgu wamta ka taw, ka maray ŋani ta lgut nda dzampa ya maganaf Tabita ta həŋ ma nzakwani ta nda iri. ");
INSERT INTO xed_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ka Piyer nda inda mndu ma həga mantsa: «Labwala la dzibil,» kaʼa. Ka saghu həŋ. Tahula tsa, ka tsəlɓatá Piyer ka maga duʼa. Ka mbəɗavatá tsi tvə mbli. Kaʼa mantsa: «Tabita, Sliʼafsliʼa!» kaʼa. Ka gunaŋtá Tabita ta iri. Nghaŋtani ta Piyer, ka sliʼavatá tsi ka nzata nda nza. ");
INSERT INTO xed_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ka ŋanatá Piyer ta dzvu, ka sliʼanafta ka sladata. Ka hgadamtá tsi ta gwal zlghay nda ŋuɗuf, nda tsa la wadguha ya, ka maranaŋtá həŋ ta nzakwani nda hafu. ");
INSERT INTO xed_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ka snanaghatá tsi ta inda gwal ma Yafa. Ka zlghaftá ndəghata mnduha ta Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ka nzatá Piyer ka nzɗavata ma Yafa ga sana mnda kɓa huta, Simuŋ hgani. ");
INSERT INTO xed_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mamu sana mndu ta hgə lu ka Kwarney ma luwa Sezare. Tsatsi mali ta ghəŋa sana ghuɓa la sludza la Ruma ta hgə lu ka «ghuɓa la Italiya.» ");
INSERT INTO xed_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ŋərma mndu tsa mndu ya nda gwal ga taŋ tani. Ta zləŋay ta Lazglafta, dagala mnduha la Yahuda mbaha tsi. Ta magay ta duʼa da Lazglafta inda fitik. ");
INSERT INTO xed_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ma sana fitik ta nzemndi hkən tama, ka slanaghatá sana mazəmzəm. Ka nghaŋtá tsi ta duhwala Lazglafta ta lamə da həga ga taŋ ka hgaŋta. «Kwarney!» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ka nghə tsi ta tsa duhwala Lazglafta ya nda zləŋ nda zləŋ. Kaʼa mantsa: «Nya ní Mghama ɗa!» kaʼa. «Ɓhadafɓha tsa maga duʼa ta magə ka ya, nda tsa mbaha mnduha ta mbah ka ya da Lazglafta, kəl tsi ka havapta ka kagha. ");
INSERT INTO xed_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ghuna nda va nana ta mnduha da luwa Yafa da mnanatá Simuŋ ta hgə lu ka Piyer ya ka sagha tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ya waʼa ga sana mnda kɓa huta Simuŋ hgani tawa drəf hga taŋ ya,» ka tsa duhwala Lazglafta ya nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na gi laghwa tsa duhwala Lazglafta ta gwaɗa nda tsi ya, ka hgaftá tsi ta kwalvahani his nda ŋərma sludzani turtuk ta ksanatá slna manda ghalya. ");
INSERT INTO xed_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tahula rusanaftani ta həŋ ta inda tsa skwi ta luta ya, ka ghunaghatá tsi ta həŋ da luwa Yafa. ");
INSERT INTO xed_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Gamahtsimani ta labə tsa mnduha ya ta tvi, ndusa həŋ ka lamə da tsa luwa Yafa ya, ka laf Piyer ta dədəmatá ghəŋa həga da maga duʼa. Ta ghwaŋ a fitik ma ghəŋ nda tsaya wa. ");
INSERT INTO xed_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ka kuzlanaftá maya ta Piyer, ta kumay ma ta skwi ŋa zay. Tata də nda da lu ta skwi zay ŋani. Ka slanaghatá sana mazəmzəm. ");
INSERT INTO xed_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ka nghə tsi ta gunata luwa, ka saha sana skwi manda gatá gwada habuŋ lu ta wani ta wani, ka saha ta haɗik. ");
INSERT INTO xed_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Inda nimtak fwaɗ səla mistani, nda skwiha ta mbaɗa nda huɗi ta haɗik, nda zarakha tani mida. ");
INSERT INTO xed_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","«Sliʼafsliʼa gha Piyer ka hana ka, ka za ka,» ka sana lwi gwaɗganata. ");
INSERT INTO xed_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ka Piyer mantsa: «Va a yu Mghama ɗa wa. Haɗ skwa mbiɗa nda skwi kul raku ka zay ta kɗə walaŋta lami da wa ɗa wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","«Ka nda ra tsa skwi ya ka zay ka Lazglafta ya ná, ma nghə kagha ka skwi kul raku ka zay,» ka tsa lwi ya ka mahis nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hkən vranaftani mantsa ya, ka vriŋtá tsi ta tsa skwi ya ta luwa. ");
INSERT INTO xed_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","«Nu mndəra tsaya ma skwi tama,» ka Piyer ta ndana klatá ghəŋa tsa mazəmzəm ta slanaghata ya, nda ɓhadaghata tsa gwal ghunaf Kwarney ya ta watgha manda kɗakwa taŋ ta ɗawaŋtá vla həga la Simuŋ. ");
INSERT INTO xed_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","«Hadna ta nzakwa Simuŋ ta hgə lu ka Piyer ya ra?» Ka həŋ gwaɗata nda lwi kuzlahkuzlah. ");
INSERT INTO xed_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Tata ndana skwi ta ghəŋa tsa mazəmzəm ya Piyer kay ná, «Wya mnduha hkən ta psa kagha, ");
INSERT INTO xed_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","sliʼafsliʼa ka laha ka, ŋa dzaʼa gha kawadaga nda həŋ. Yaha ka da dga ghəŋ, kabga iʼi ta ghunagaghatá həŋ,» ka Sulkum nda ghuɓa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ka sliʼaftá Piyer ka saha slanaghatá tsa mnduha ya. «Wana yu, iʼi tsa mndu ta psə kuni ya. Nya ta klagaghunaghata na?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","«Kwarney ka mali ta ghəŋa ghuɓa sludzi, ta nzakway ka ŋərma mndu, ta zləŋa Lazglafta, ta ghubu inda la Yahuda ya ta ghunaŋnakta. Duhwala Lazglafta ta mnanata ŋa hgadaptá kagha da taŋ ŋa sna skwi dzaʼa ka mnanata,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ka hladamtá Piyer ta həŋ, ka hanə həŋ hada. Gamahtsimani, ka sliʼaftá tsi ka laghu mista taŋ. Ka sliʼaftá sanlaha ma zwanama ma luwa Yafa ka pghaghatá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ka ɓhadaghatá həŋ da luwa Sezare. Gamahtsimani, ta kzlaykzlay Kwarney nda la ga taŋ tani, nda hɗuhuɗa grahani gwal hagaf tsi ya, ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Manda ɓhadaghata Piyer, ka lagha Kwarney da guyay, ka zləmbatá tsi ma ghuvani ka ga zgu ŋani. ");
INSERT INTO xed_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","«Sliʼafsliʼa, mndu iʼi guli,» ka Piyer ka sliʼanafta. ");
INSERT INTO xed_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tata dzaʼa nda ghwa yiva həŋ nda Kwarney, ka lamə tsi da həga. Ka slanaghatá tsi ta hiɓatá mnduha hada. ");
INSERT INTO xed_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kaʼa nda həŋ mantsa: «Nda sna kuni ná, pyafpya lu ta guyay mnda la Zudiya ta vgha nda la mayəm, ɓalavakata lamə da həga ga taŋ. Tsaw haɗ mnda səla ya ŋa mnay kazlay: Nda ghuɓa yeya, ghuɓa a yeya ka guya vgha nda tsi wu kəʼa wu, ka Lazglafta marihata. ");
INSERT INTO xed_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tsaya kwal yu kul dgaŋtá ghəŋ ka sagha hgaŋər ka ta iʼi. Ta kumay yu tama ta snaŋtá ghəŋa skwi kəl kuni ka hgaktá iʼi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ka Kwarney mantsa: Ma fwaɗa fitik na, manda va na luwa, ta maga duʼa yu ma həga ɗa ta nzəmndi hkən, ka gi sagha sana mndu nda suɗatá lguta ŋusliŋ tilil ta vghani ta kəma ɗa. ");
INSERT INTO xed_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kaʼa nda iʼi mantsa: «Kwarney, snasna Lazglafta ta duʼa gha, havaphava guli ka mbaha mnduha ta mbah ka. ");
INSERT INTO xed_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ghuna tama ta mnduha da luwa Yafa da hgaghaktá Simuŋ ta hgə lu ka Piyer ta nzaku ga sana mndu, Simuŋ hgani, mnda kɓa huta, ta wa drəf hgani ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","«Gi kəl yu ka ghunadaptá mnduha da kagha. Ɗina na sagha sagha ka na. Ndanana, wana aŋni demdem ta kəma gha ŋa sna skwi ya mnagha Mgham ŋa mnaŋnata,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mbaɗa Piyer ka zlraftá gwaɗa. Wya kaʼa: «Kahwathwata, ndanana grafta yu kazlay: Haɗ Lazglafta ta gala mndu wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Inda mndu dər má ma mndəra la wa tsi ta zləŋa hgani, ka maga skwi tɗukwa ná, zɗəganazɗa. ");
INSERT INTO xed_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ghunafghuna Lazglafta ta gwaɗani ŋa zwana la Israʼila ma mnanaŋtá Lfiɗa Gwaɗa ta nzaku nda ma Yesu Kristi, ta nzakway ka Mghama inda mnduha, ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nda sna kuni ta skwi ta zlrafta ta haɗika Galili, ka zluʼutá tsi ta vli ta haɗika Zudiya demdem, tahula kɗakwa Yuhwana ta mna gwaɗa, nda ya ta maga batem. ");
INSERT INTO xed_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nda sna kuni ka Lazglafta pghəganaghatá mbrakwa Sulkum nda ghuɓa ta Yesu Kristi mnda la Nazaret. Nda sna kuni guli ka Yesu ranaftá inda vli ka maga zɗaku, ka mbamba gwal ghurgana halaway ta həŋ, kabga kawadaga Lazglafta nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aŋi, nda nza aŋni ka masləmtsəka inda skwi maga tsi ta haɗika la Yahuda nda Ursalima. Ka dzatá lu nda ma zləŋafta ta udzu. ");
INSERT INTO xed_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ka sliʼaganaptá Lazglafta nda hafu baɗu mahkən. Ka vlaŋtá tsi ta tva maraŋtá ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ŋa tsa aŋni tiŋlaghu Lazglafta ta zbapta ŋa nzakway ka masləmtsəkani ya. Ŋa tsa aŋni si ta za skwi, ka sa skwi kawadaga nda tsi ya maraŋta tsi ta ghəŋani, tahula sliʼagaptani ma taba gwal nda rwa ya. Ŋa inda mnduha demdem a maraŋta tsi ta ghəŋani wa. ");
INSERT INTO xed_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tsatsi ta mnaŋnata, ka mna kuni ŋa mnduha, ka sladanafta kuni kazlay: Tsatsi sladana Lazglafta ka mnda tsa guma ta ghəŋa gwal nda hafu, nda ya ta ghəŋa gwal nda rwa kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Inda la anabi ná, mnamna həŋ ta ghəŋani kazlay: Dər wati ma mndu ta zlghafta dzaʼa mutsay ta planatá dmakwani, nda ma mbrakwa hgani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tata mna tsa gwaɗaha ya Piyer, ka saha Sulkum nda ghuɓa ta ghəŋa inda tsa gwal ta sna tsa gwaɗa ya. ");
INSERT INTO xed_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ka ndərmim inda tsa gwal zlghay nda ŋuɗuf nda tsa fafaɗa taŋ ta labə mista Piyer ya kay, ta vlagata Lazglafta ta Sulkum nda ghuɓa ta ghəŋa inda tsa gwal kul nzakway ka la Yahuda ya. ");
INSERT INTO xed_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ka snə həŋ ta gwaɗay tsa mnduha ya ta gwaɗa nda sanlaha ma gwaɗa. Ka zləzlvu həŋ ta glakwa Lazglafta. Ka Piyer mantsa: ");
INSERT INTO xed_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Dzaʼa pyafpya lu ta maganaftá batem nda imi ta na mnduha na, ya wana mutsafmutsa həŋ ta Sulkum nda ghuɓa manda va amu na ra?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ka Piyer guli mantsa: «Maganaftá batem ta həŋ nda hga Mgham Yesu Kristi,» kaʼa. Tahula tsa, ka ndəɓanata həŋ ta dzvu ŋa nzɗavatani tsəɓakw fitik da həŋ. ");
INSERT INTO xed_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ka snaŋtá gwal ghunay nda zwanama ta nzakway ma haɗika Zudiya kazlay: Zlghafzlgha gwal kul nzakway ka la Yahuda ta gwaɗa Lazglafta guli kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Manda vradaghata Piyer da luwa Ursalima, tus gwal zlghay nda ŋuɗuf nda ɗatsa fafaɗa taŋ nda gwaɗa nda Piyer. ");
INSERT INTO xed_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Lamla ka da həga ga gwal kul ɗatsaku fafaɗa taŋ, ka za skwa zay kawadaga nda həŋ,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ka zlraftá Piyer ta rusay ŋa taŋ turtuk turtuk ka tsa skwi ya luta. ");
INSERT INTO xed_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kaʼa mantsa: «Ma nzakwa ɗa ma luwa Yafa, ta maga duʼa yu tama, ka slaɗighatá sana mazəmzəm. Ka nghaŋtá yu ta sana skwi dagala manda gatá gwada nzakwani ŋaŋana lu ta wa kuzibiɗimani ta wa kuzibiɗimani ta saha daga ta luwa, ka ndusaɗivata. ");
INSERT INTO xed_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ka faftá yu ta iri tida ka vitsay, ka nghaŋtá yu ta skwiha fwaɗ fwaɗ səla mista taŋ, nda nimtak, nda skwiha ta mbaɗa nda huɗi, nda zarakha mida. ");
INSERT INTO xed_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Sliʼafsliʼa gha Piyer ka hana ka, ka za ka ta həŋ,” ka sana lwi gwaɗgihata. ");
INSERT INTO xed_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Va a yu Mghama ɗa wa, haɗ skwa mbiɗa nda skwi kul raku ta kɗə lami da wa ɗa wu,” ka yu. ");
INSERT INTO xed_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ka nda ra, ka Lazglafta ya ná, ma nghə ka ka skwi kul raku,” ka tsa lwi ya gwaɗglagata ta luwa ka mahis. ");
INSERT INTO xed_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hkən kəʼa vrəglanafta manda va tsaya. Ka vriŋtá lu ta tsa skwi ya ta luwa. ");
INSERT INTO xed_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ta va tsa luwa ya, nda ɓhadaghata sana mnduha hkən ghunaf lu ta həŋ daga ma luwa Sezare, ŋa sliɗighata ma tsa həga ta nzaku yu ya. ");
INSERT INTO xed_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Ka dzaʼa ka mista taŋ, yaha ka da dga ghəŋ,” ka Sulkum nda ghuɓa nda iʼi. Ka pghaftá na mnduha wana həŋ hadna na ta iʼi da luwa Sezare, ka lamə ŋni demdem da həga ga Kwarney. ");
INSERT INTO xed_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ka rusaŋnaftá tsa mndu ya kəʼa nghaŋtá duhwala Lazglafta ta sladu ma həga ga taŋ. Kaʼa nda tsi mantsa: “Ghuna ta mndu da luwa Yafa ŋa hgaktá Simuŋ, ta hgə lu ka Piyer ya ka sagha tsi, ");
INSERT INTO xed_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ŋa mnaghunatani ta gwaɗaha ya dzaʼa klaghaktá mbaku, ŋa kagha nda həga gha tani demdem,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ta zlrayzlray yu ta gwaɗa tama ná, ka saha Sulkum nda ghuɓa ta ghəŋa taŋ manda va ya ta magaku nda amu taŋtaŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ka havaktá yu ta gwaɗa Mgham Yesu ta mnay kazlay: Yuhwana ná, nda imi maga tsatsi ta batem, kaghuni ya, nda Sulkum nda ghuɓa dzaʼa magaghunafta lu ta batem kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ka si Lazglafta ta vlaŋtá tsa Sulkum nda ghuɓa ya ta tsa mnduha ya, manda va ya vlama lu ta amu ma zlghafta mu ta Mgham Yesu Kristi ya ní, wa iʼi tama ŋa dzanamtá wi ta Lazglafta?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tahula snaŋta taŋ ta tsa gwaɗa ya, ka lɓatá həŋ demdem, ka zləzlvu həŋ ta Lazglafta «ta vlaŋtá tva mbəɗanaftá nzakwa taŋ ta gwal kul nzakway ka la Yahuda kada mutsafta həŋ ta vərɗa hafu tama,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tsa ghuya ɗaŋwa ta slata ma kɗə fitika dzatá Atiyen sagha ya, ta wutsanatá gwal zlghay nda ŋuɗuf. Ka sliʼaftá sanlaha ka laghwi dikw da luwa Finisi, ta laghu sanlaha da Kiprus, ta laghu sanlaha da Aŋtakiya. Ka mnə həŋ ta gwaɗa Lazglafta ŋa la Yahuda ka zlaŋtá mnay ŋa sanlaha ma mnduha. ");
INSERT INTO xed_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mbaɗa sanlaha ma gwal zlghay nda ŋuɗuf ta nzakway ka mnduha la Kiprus nda la Sireŋ, ka sliʼafta ka laghu da luwa Aŋtakiya, tvə la Grek. Ka mnə həŋ guli ta Lfiɗa Gwaɗa Mgham Yesu ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kawadaga mbrakwa Mgham Yesu nda həŋ, kəl ndəghata mnduha ka zlghafta, ka mbəɗaghutá vgha tvə Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ka snanaghatá tsi ta Igliz ma luwa Ursalima. Ka ghunaftá həŋ ta Barnabas da luwa Aŋtakiya. ");
INSERT INTO xed_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Manda ɓhadaghatani, ka nghaŋtá tsi ta zɗakatahuɗa Lazglafta, ka rfu tsi ta rfu. Ka vlaŋtá tsi ta mbraku ta həŋ ŋa gɗavata taŋ nda fatá ŋuɗufa taŋ ta Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tsaw tsa Barnabas ya ná, ŋerma mndu ya, mnda zlghay nda ŋuɗuf ya ndəghu ndəgha nda Sulkum nda ghuɓa. Ka sgavaghatá ndəghata mnduha ta zlghaftá Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ka sliʼaftá Barnabas ka laghwi da luwa Tarsus, da zba Sawulu. ");
INSERT INTO xed_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Manda slaftani tida, ka klagaghatá tsi da luwa Aŋtakiya. Təŋ vakwa taŋ hada kawadaga ta ksa slna ma Igliz. Ka taghə həŋ ta skwi ŋa ndəghata mnduha guli. Ma luwa Aŋtakiya zlrafta lu ta hga gwal zlghay nda ŋuɗuf, ka la krista. ");
INSERT INTO xed_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ma tsa fitik ya, ka sliʼaftá la anabi ma luwa Ursalima ka laha da luwa Aŋtakiya. ");
INSERT INTO xed_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mamu sani mataba taŋ ta hgə lu ka Agabus. Kaʼa mantsa: «Dzaʼa slaku maya ta ghəŋa haɗik demdem,» kaʼa manda ya mnana Sulkum nda ghuɓa. Ka slatá tsi tama ma fitika gay Klawdi ta mgham. ");
INSERT INTO xed_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ka gwal zlghay nda ŋuɗuf sladanata mantsa: «Inda mndu, ka vla tsi ta skwi ya laviŋ tsi ta vlay ŋa tsəghay ŋa kata zwanama ta nzaku ma haɗika Zudiya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ka tskaftá həŋ, ka vlaŋtá i Barnabas nda Sawulu, ŋa klaŋtá la galata mnduha ma haɗika Zudiya. ");
INSERT INTO xed_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma va tsa fitik ya, ka zlraftá mgham Hiridus ta ghuya ɗaŋwa ŋa Igliz. ");
INSERT INTO xed_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ka dzatá tsi nda kafay ta Yakubu, zwaŋamani ma Yuhwana. ");
INSERT INTO xed_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta nghə tsi ná, zɗəganazɗa tsa skwi ya ta la Yahuda. Ka ksaftá tsi ta Piyer guli ma fitika skala buradi kul haɗ is mida ya. ");
INSERT INTO xed_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tahula ksaftani, ka tsamtá tsi ma gamak. Ka pghatá tsi ta ghuɓa sludzi fwaɗ fwaɗ ŋa mbaɗay taŋ ta vgha ta nghay. Tahula kɗata ma skala Pak ta ndana tsi ta tsanaghatá guma baŋluwa. ");
INSERT INTO xed_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma tsa ŋatá Piyer ma gamak ya tama, ka ŋavata Igliz ka maga duʼa ka ŋɗaŋɗa ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta tsa rviɗik ŋa tsaɗakwa vlani ya ta ndana Hiridus ta tsanaghatá guma. Ta hani Piyer nda tsatani ma tsuhwalha his ma takataka sludziha his. Ta nzaku gwal ngha watgha guli nda tvə watgha. ");
INSERT INTO xed_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gi ka zlagaptá duhwala Lazglafta ka tsuwaɗakanaftá vli ma tsa dzuguvi ya. Ka nduhuɗaŋtá tsi ta Piyer ma ŋwazliɓ. «Sliʼafsliʼa misimmisim,» kaʼa nda tsi. Gi stak saha tsa tsuhwalha ya tsa ta dzvani. ");
INSERT INTO xed_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","«Hbana ɓanava gha ka suɗamta ka ta ɓaɓaha gha,» ka duhwala Lazglafta nda tsi. Ka magatá tsi mantsa. «Fava lguta gha, sawi mista ɗa,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ka saghu Piyer ma gamak mista tsa duhwala Lazglafta ya. Zbaŋ a tsatsi kazlay: Kahwathwata na skwi ta magə duhwala Lazglafta na re ari ki na kəʼa wa. Zlah suni na skwi na ta fiɗaghata, ka tsatsi ta ndanay. ");
INSERT INTO xed_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ka tsughwaɗagaptá həŋ ta taŋtaŋa ghuɓa tsa gwal ta ngha mnduha ya, tsughwaɗapha həŋ ta mahisani. Ka lagha həŋ tavata sana watgha haf lu nda kufur ta tva lami da huɗa luwa. Ka gunutá tsa watgha ya ka ghəŋani ta wa ira taŋ. Ka sabə həŋ, ka ksaftá həŋ ta tvi, gi ka zlanatá duhwala Lazglafta hada. ");
INSERT INTO xed_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ma tsa fitik ya zlrafta Piyer ta snaŋtá skwi ta magaku. «Ndanana, grafta yu dar kazlay: Mgham Yesu ta ghunagatá duhwalani klaptá iʼi ma dzva Hiridus nda ya ma inda ghwaɗaka skwi si ta kumə la Yahuda ta slaɗighatani,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na snaŋtani kazlay: Manda va tsaya nzakwani kəʼa, ka sliʼaftá tsi ka laghwi da Mari mani ma Yuhwana, ta hgə lu ka Markus ya. Hada, nda hiɓa tskatá vgha mnduha ta maga duʼa. ");
INSERT INTO xed_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ka lagha Piyer dzaŋtá watgha lamə da həga. Ka gavadaghatá sana marakw ka kwalva, ta hgə lu ka Ruda, da sna lwani. ");
INSERT INTO xed_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ka tsatsaftá tsi ta lwa Piyer, ka rfu tsi ta rfu. Ma ŋa gunatani ta tsa watgha ya ná, ka hwayaghatá tsi da huɗa həga da mnay kazlay: Waʼa Piyer ma bli kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","«Nda ksa ka da skwi ra!» ka həŋ nda tsi. «Kahwathwata ta mna yu,» kaʼa ta ghəŋani. «Ba sulkumani ya,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mbaɗa Piyer ka gɗavata ta dza watgha. Manda gunata taŋ ta watgha ka nghaŋtá həŋ ta Piyer. Ka ndərmim həŋ. ");
INSERT INTO xed_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kɗkəɗkɗ, ka Piyer nda dzvu ka lɓanatá həŋ. Ka rusanaftá tsi ta həŋ ka Mgham Yesu kligiŋta ma gamak. «Ka dzaʼa kuni da rusanaftá i Yakubu nda sanlaha ma zwanama,» kaʼa nda həŋ guli. Ka gi sabə tsi ka laghwi da sana vli. ");
INSERT INTO xed_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tsaɗakwa vlani, ka kɓutá la sludzi katakata. «Ka wu nuta na Piyer na tama?» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","«Psawa manda va psay,» ka Hiridus. Lay, ngha a wa. Laghani ka ɗaɗawanaptá vli ta tsa gwal si ta nghay ya. Ka vlatá tsi ta tvi, ŋa pslatá həŋ. Tahula tsa, ka sliʼaftá Hiridus ma Zudiya ka laha da luwa Sezare, ŋa nzɗavata ka fitik tsəɓakw hada. ");
INSERT INTO xed_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ka ɓasaftá mgham Hiridus ta ŋuɗuf katakata ta ghəŋa gwal ma luwa Tir nda Siduŋ. Ka dzraftá tsahaya ta wi ka skwa turtuk ŋa lagha ta kəmani. Ka sutá həŋ ta ghəŋa Blastus ta nzakway ka zwira mgham ya. Ka lagha həŋ ɗawa dzrafta nda mgham, kabga ma haɗika tsa mgham ya ta saba skwi ŋa zay taŋ. ");
INSERT INTO xed_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Baɗu tsa fitik tsaf həŋ ya, ka suɗavatá Hiridus ta lguta ma mgham mghamani, ka nzafta ta dughurukwani, ka ŋəzlatá tsi baŋluwa. ");
INSERT INTO xed_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","«Lazglafta ta gwaɗa, mndu a wu,» ka mnduha hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Gi hadahada, ka dzuŋtá duhwala Lazglafta ta Hiridus, kabga kwalani kul vlaŋtá glaku ta Lazglafta. Ka dughwaɗutá mtarak, ka mtutá tsi. ");
INSERT INTO xed_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Mbaɗa gwaɗa Lazglafta ka ta vgha, ka sgaku mbsaka gwal zlghay nda ŋuɗuf nda sga. ");
INSERT INTO xed_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Manda kɗiŋta i Barnabas nda Sawulu ta slna ya ghunaf lu ta həŋ da Ursalima, ka vraghutá həŋ. Ka kliŋtá həŋ ta Yuhwana, ta hgə lu ka Markus ya, mista taŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ma Igliza luwa Aŋtakiya ná, mamu la anabiha nda gwal ta tagha skwiha ŋa mnduha. Hahəŋ na i Barnabas, nda Simeyuna ta hgu lu ka mnda ŋra ya, nda Lukiyus mnda la Sireŋ, nda Manaheŋ ta glafta kawadaga nda Hiridus, ya si ta ga mgham ta haɗika Galili ya, nda Sawulu. ");
INSERT INTO xed_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ma sana fitik, ka tskavatá həŋ ka maga duʼa nda sumay. «Hlapwa i Barnabas nda Sawulu ya mataba ghuni, ŋa maga slna ya hgaŋ yu ta həŋ,» ka Sulkum nda ghuɓa, nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tahula kɗiŋta taŋ ta tsa suma nda maga duʼa ya, ka fanaghatá həŋ ta dzvu ta həŋ ka zliŋtá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ka sliʼaftá i Barnabas nda Sawulu, ghunafər Sulkum nda ghuɓa ta həŋ, ka laghu həŋ da luwa Selusi. Hada ŋlafta həŋ ta kwambalu, ka laghwi ta haɗika Kiprus, ta tsavata ma drəf. ");
INSERT INTO xed_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Manda ɓhadaghata taŋ da luwa Salamina, ka mnə həŋ ta gwaɗa Lazglafta ma həga tagha skwa la Yahuda. Kawadaga Yuhwana Markus nda həŋ ŋa zlghaŋtá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ka tadaptá həŋ ta tsa haɗik ya ka ɓhadaghata da luwa Pafus. Ka slanaghatá həŋ ta sana ɗəgha, ta hgu lu ka Baryusuwa, sana mnda la Yahuda ya ta niŋtá ghəŋani ka anabi. ");
INSERT INTO xed_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tavata ŋumna tsa haɗik ta tsavata ma drəf ya ta nzakwa tsi. Tsa ŋumna ya ná, Sergiyus Palus, mndu nda ghunizlak ma ghəŋani ya. Ka hgaftá tsi ta i Barnabas nda Sawulu, kabga ta kumay ta snanatá gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lagha tsa ɗəgha ta hgu lu ka Alimas nda gwaɗa Grek ya, ka dzadza wa taŋ ka zba mbəɗiŋtá zlghay nda ŋuɗufa tsa ŋumna ya. ");
INSERT INTO xed_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mbaɗa Sawulu, ta hgu lu ka Pwal ya, nda ndəghatani nda Sulkum nda ghuɓa, ka vazlaftá iri tida. ");
INSERT INTO xed_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Kuslembermbera magakwa gha, dagala nana mnda gha, zwaŋa halaway ka, ghuma inda skwi tɗukwa ka. Yawu dzaʼa zlaŋta kagha ta mbəɗiŋtá tva Lazglafta ta nzakway ka tɗukwani na? ");
INSERT INTO xed_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kzla tama, wya Mgham dzaʼa dzughusta, ŋa ghulpəta gha. Dzaʼa nzɗavanzɗa ka, haɗ ka dzaʼa nghaŋtá fitik wu,» kaʼa. Gi hadahada tɗik vli ta wa ira Alimas manda vli girviɗik. Ka tatam tsi ta tatamaku ka zba mndu ŋa ksay ta dzvu. ");
INSERT INTO xed_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nghanata ŋumna ta tsa skwi ta maguta ya ná, ka zlghaftá tsi nda ŋuɗufani. Lanafla tsa skwi ta taghə lu ta ghəŋa Mgham Yesu ya katakata. ");
INSERT INTO xed_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ka sliʼaftá i Pwal nda grahani ka lami da kwambalu ma luwa Pafus, ka laghwi da Perge ta haɗika Pamfali. Ka dgatá Yuhwana Markus ta vgha nda həŋ, ka vraghuta da luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ka sliʼiglaftá həŋ ma luwa Perge, ka laghwi da luwa Aŋtakiya ta haɗika Pisidi. Baɗu Sabat, ka lamə həŋ nzata ma həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tahula dzadzaŋafta lu ta vli ma deftera zlaha Musa, nda ya ma deftera anabiha, ka maliha ma tsa həga tagha skwa la Yahuda ya nda həŋ mantsa: «Zwanama ɗa, ka mamu gwaɗa da kaghuni ŋa vlaŋtá mbraku ta mnduha, laviŋlava kuni ta gwaɗay ndana,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ka sliʼaftá Pwal, kaʼa nda dzvu nda dzvu mantsa: Snawasna la Israʼila nda inda gwal ta tsəlɓu ta kəma Lazglafta! ");
INSERT INTO xed_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Lazglafta mnduha la Israʼila ta zbaptá dzidzíha mu ŋa ŋlanaftá həŋ, ma fitika nzakwa taŋ ta haɗika Masar. Ka hligiŋtá tsi ta həŋ ma tsa haɗik ya nda mbrakwani. ");
INSERT INTO xed_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ta klay ta vaku fwaɗ mbsak maga tsi ta suʼa nzaku nda həŋ ma mtak. ");
INSERT INTO xed_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tahula tsa, ka zaɗanatá tsi ta mndəra mnduha ndəfáŋ ta haɗika Kanʼana, ka vlaŋtá tsi ta tsa haɗik ya ta həŋ, ŋa ŋataŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Inda tsa nzakwagapta taŋ ya ná, ta klay ta vaku fwaɗ dərmək nda hutafmbsak. «Ka vlaŋtá tsi ta gwal ŋa tsanatá guma ta həŋ, ha ka sagha ta fitika anabi Samuyel. ");
INSERT INTO xed_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ka ɗawu həŋ ta fanamtá mghama taŋ ta həŋ. Ka fanamtá Lazglafta ta həŋ ta Sawulu zwaŋa Kis, ta sabi ma mndəra la Benzameŋ. Fwaɗ mbsak vakwani ta ga mgham ta ghəŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","«Ka mbəɗanatá Lazglafta ta hul ta Sawulu, ka mbəɗanamtá ga mgham ta Dawuda ta ghəŋa taŋ. “Slafsla yu ta Dawuda, zwaŋa Yesay. Zɗəgihazɗa, dzaʼa magay ta inda skwi ya ta kumə yu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nda ma zivra Dawuda kləganaghata Lazglafta ta la Israʼila, ta mnda mba mndu, ta nzakway ka Yesu, manda ya tamaf tsi ta imi ta sləməŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ma kɗaku Yesu ka saha, mnanamna Yuhwana ta inda la Israʼila kazlay: Mbəɗanafwambəɗa ta nzakwa ghuni, ka magaghunafta lu ta batem guli kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ndusakwa fitika kɗayni ta slnani, kaʼa mantsa: “Duŋwa wa ya ka kaghuni nda iʼi na? Ya tsa mndu ta kzlə kaghuni ya a iʼi wa. Wa a tsatsi ta sagha nda hula ɗa, slaghwa a yu dər ka plaptá zuʼa ɓaɓah ma səlani wa,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Zwanama ɗa, kaghuni ta nzakway ka zivra Abraham, nda kaghuni ta zləŋa Lazglafta tani, ŋa amu tsghəgamaghata lu ta na gwaɗa ta mbaku na. ");
INSERT INTO xed_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tsaw tama, tsatsaf a mnduha ma Ursalima nda mghamha tani ta Yesu wa. Sna a həŋ ta tsa gwaɗa la anabi ta dzaŋə lu inda sabat ya guli wa. Ka dzanaghatá həŋ ta ghəŋa skwi mna la anabi, nda ma dzata taŋ ta Yesu. ");
INSERT INTO xed_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Dər ma slanagha a həŋ ta skwi prək ka dzata ma mndani wu, dzadza ta na mndu na, ka həŋ nda Pilat. ");
INSERT INTO xed_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tahula kɗiŋta magatá skwi manda ya nda vinda ta ghəŋani ma deftera Lazglafta, ka klaghatá həŋ dzata ta udza zləŋay. Ka klagatá həŋ ka famta ma kulu. ");
INSERT INTO xed_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama ka sliʼaganaptá Lazglafta mataba gwal nda rwa. ");
INSERT INTO xed_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nda ndəgha fitikani ta mara vgha ŋa gwal ta sliʼafta ma Galili kawadaga nda tsi, ka lafi da Ursalima. Tsa mnduha ya ta nzakway ndanana, ka masləmtsəkani da mnduha la Israʼila. ");
INSERT INTO xed_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Vərɗa aŋni, tsa Lfiɗa Gwaɗa ya ta mnaghunata aŋni. Tsa ta ta imi tanaf Lazglafta ta zləməŋ ta dzidzíha mu ya ná, ");
INSERT INTO xed_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","magama ta amu, ta nzakway ka zivra taŋ ya Lazglafta, ma sliʼaganaptani ta Yesu ma mtaku. Wya skwi nda vinda ma Zabura his: “Zwaŋa ɗa ka, gita yata yu ta kagha,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Sliʼaganapsliʼa Lazglafta ta Yesu ma mtaku, walglaŋta a ta mtuta ŋa fəgladamtá mblani da kulu ŋa rwutani wa. “Tsaya kəl Lazglafta ka mnay kazlay: Dzaʼa vlaghunavla yu ta tfawi nda ghuɓa, nda fa ghəŋ tida, ya tanaf yu ta imi ta sləməŋ ta Dawuda kəʼa ya.” ");
INSERT INTO xed_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kaʼa ma sana vli guli na: “Haɗ ka dzaʼa zlanatá mnda gha ŋa rwutani ma kulu wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ma fitika nzakwa Dawuda nda hafu ná, mnda ksanatá slna ta Lazglafta ya. Maganamaga ta skwi ta kumə tsi. Ka mtutá tsi, ka lamtá lu tavata dzidzíhani, ka rwuta tsi. ");
INSERT INTO xed_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama tsa mndu sliʼaganap Lazglafta nda hafu ya, walaŋ a rwaku ta ksaŋtá tsatsi wa. ");
INSERT INTO xed_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mantsa tama zwanama, ɗina ka snaŋta ghuni kazlay: Əŋkaʼa ka tsa Yesu ya kəl lu ka mnaghunaŋta nda pla dmakwa ghuni kəʼa. Traptra zlaha Musa ta klaptá kaghuni ma tsa dmakwa ghuni ya. ");
INSERT INTO xed_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ama inda mndu ta zlghaftá Yesu ná, falauʼ vghani. ");
INSERT INTO xed_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɗaswa ka kuni tama, da slaghunaghatá skwi mnə la anabi kazlay: ");
INSERT INTO xed_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Kaghuni gwal ta mna mbrəs nda Lazglafta, nghawangha, ndərmima wa ndərmima, ka zwaɗutá kuni, kabga dzaʼa magay yu ta fitika ghuni ta mandərmimi, ya dər ma kinawu rusaghunafta lu ná, grafta a kuni ɗekɗek wu kəʼa ya”». ");
INSERT INTO xed_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Manda saba i Pwal nda Barnabas ma həga tagha skwi, «Kdəkwakdək, ka vrakta kuni baɗu sana Sabat da mnəglaŋnatá na gwaɗa na,» ka lu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tahula gazlata mnduha, ka sliʼaftá ndəghata la Yahuda nda gwal ta lami nda la da dina la Yahuda mista i Pwal nda Barnabas. Ka ghu həŋ ta yiva. Ka vlə i Pwal nda Barnabas ta mbraku ŋa taŋ. «Dihavawa diha ma zɗakatahuɗa Lazglafta,» ka həŋ nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sagha tsa sana Sabat ya, ka tskavatá wər mnduha ma tsa luwa ya demdem ŋa sna gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nghay la Yahuda ta tsa tskata mnduha ya, ka lamə həŋ nda draku, ka dzadzə həŋ ta wa i Pwal, ka raraza həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Zləŋaŋə a i Pwal nda Barnabas ta həŋ wa. Ka həŋ mantsa: «Nda ra má ka tiŋlaghutá mna gwaɗa Lazglafta ŋa kaghuni mazlay, ka kwalaghutá kaghuni. Ra a aŋni ka mutsa hafu ŋa kɗekedzeŋ wu ka kuni ya, dzaʼa mbəɗaghutá vgha ŋni nda tvə gwal kul nzakway ka la Yahuda ndana tama. ");
INSERT INTO xed_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wya skwi mnaŋna Mgham Lazglafta: “Fafa yu ta kagha ka tsuwaɗaka gwal kul nzakway ka la Yahuda, ŋa mnay gha ta gwaɗa ta mbaku ta ghəŋa haɗik tender,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Snay gwal kul nzakway ka la Yahuda ta tsa gwaɗa ya ná, ka rfu həŋ ta rfu, ka zləzlvu həŋ ta Lazglafta. Ka zlghaftá inda gwal thanaf lu ta hafu ŋa kɗekedzeŋ, ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ka tutá gwaɗa Mgham Lazglafta ma tsa luwa ya demdem. ");
INSERT INTO xed_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ka sliʼamtá la Yahuda da gagaftá gwal dagaladagala ta zləŋa Lazglafta, nda gwal dagaladagala ma luwa tani. Ka ganaktá həŋ ta giri ŋa i Pwal nda Barnabas, ŋa ŋawaftá həŋ ma haɗika taŋ. ");
INSERT INTO xed_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ka tukwanatá i Pwal nda Barnabas ta rgitika səla taŋ ta həŋ, ka laghwa taŋ da luwa Ikwaniya. ");
INSERT INTO xed_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ta ndaghutá ŋuɗufa gwal zlghay nda ŋuɗuf ma luwa Aŋtakiya da rfu, nda ya nda Sulkum nda ghuɓa tani guli. ");
INSERT INTO xed_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Manda ɓhadaghata i Pwal nda Barnabas da luwa Ikwaniya, ka lamə həŋ da həga tagha skwa la Yahuda, ka mnə həŋ ta gwaɗa Lazglafta. Ma tsa mnay taŋ ya, ndaɗa a ndəghatá la Yahuda nda la Grek ta zlghafta nda ŋuɗuf wa. ");
INSERT INTO xed_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama mbaɗa tsa la Yahuda kul zlghafta nda ŋuɗuf ya, ka gagaftá gwal kul nzakway ka la Yahuda ŋa gwaftawi nda həŋ ka zba gwaɗa da zwanama. ");
INSERT INTO xed_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kulam nda tsa, ka nzɗavatá i Pwal nda Barnabas ma tsa luwa Ikwaniya ya. Ka mnə həŋ ta gwaɗa Lazglafta ka ŋɗaŋɗa nda fatá ghəŋ dar ta Mgham Lazglafta. Vərɗa gwaɗa tsa gwaɗa ya, ka Mgham Lazglafta nda həŋ nda ma vlaŋtani ta mbrakwa maga mazəmzəm, nda mandərmimi ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ka dgavaptá mnduha his gamndər ma tsa luwa ya. Gəts ya laha mista la Yahuda, gəts ya laha mista gwal ghunay. ");
INSERT INTO xed_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ka dzraftá la Yahuda, nda gwal kul nzakway ka la Yahuda, nda maliha taŋ ta wi, ŋa liŋtá i Pwal nda Barnabas nda pala ŋa pslatá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ka snanaghatá tsi ta i Pwal nda Barnabas. Ka laghu həŋ da ɗiɗifa vgha ma luwa Listra, nda ya ma luwa Derba ta haɗika Ikwaniya, nda ya ma luwaha ta wanafta. ");
INSERT INTO xed_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ka mnə həŋ ta Lfiɗa Gwaɗa ma tsa vliha ya guli. ");
INSERT INTO xed_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ma tsa Listra ya guli, mamu sana mndu nda rwa səlani ta kul walaŋta mbaɗaŋtá mbaɗa daga yagata, ta nzakwani hada. ");
INSERT INTO xed_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ka fatá tsi ta sləməŋ ka sna tsa gwaɗa ta mnə Pwal ya. Ka faftá Pwal ta iri tida. Ta nghə tsi ná, mamu zlghay nda ŋuɗuf da tsi prək ka mbanafta. ");
INSERT INTO xed_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ka Pwal nda tsi mantsa: «Sliʼafsliʼa ka sladata ka nda səla gha,» kaʼa nda tsi nda lwi dagala dagala. Gi vɗuk kəʼa valavata, ka mbaɗə tsi ta mbaɗa. ");
INSERT INTO xed_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nghanata tsa tskata mnduha ya ta tsa skwi maga Pwal ya, ka hlaftá həŋ ta wi nda gwaɗa Ikwaniya ta nzakway ka gwaɗa taŋ. «Wana sliʼagata lazglaftaha manda mnda səla tsakwam tsakwam da slamaghata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","«Zeyus» nana, ka həŋ nda Barnabas. «Hesmes» nana, ka həŋ guli nda Pwal, kabga tsatsi ta gwaɗa. ");
INSERT INTO xed_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ka ksagaghatá mndu ta pla tsa Zeyus banaf lu ta həgani ta tva lami da tsa luwa ya ta lghəŋha rkanaf tsi ta rka ta watgha tsa həga ya. Ta kumay tsatsi nda tsa tskata mnduha ya tani, ta planatá ghəŋ ta i Barnabas nda Pwal. ");
INSERT INTO xed_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Snaŋta tsa gwal ghunay ta nzakway ka i Barnabas nda Pwal ya ta tsa skwi ya, ka kwahiŋtá həŋ ta lgut ta vgha taŋ, ka ndadamta da taba tsa tskata mnduha. Ka həŋ mantsa: ");
INSERT INTO xed_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Nawawanawa zwanama, nahgani na dzaʼa kuni magay na? Mndu aŋni manda va kaghuni tane. Lfiɗa Gwaɗa ŋa aŋni ta kləgaghunaghata, ka zlaŋta kuni ta skwa wuyayha ka mbəɗakta kuni ta vgha tvə Lazglafta ya nda hafu mida, ya ta magaftá luwa nda haɗik, nda inda skwiha mida tani. ");
INSERT INTO xed_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ghalya ná, zliniszla ta tvi ta mnduha ŋa ksa tvi ya ta kumə həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Aŋ mndani, ta kwalaghu a Lazglafta ta maraŋtá ghəŋani nda maga zɗaku wa. Ta nzəgaghunanza ta imi daga ta luwa, ta magaku skwi ma vwaha ghuni, ta hasl nda hasla kuni ta skwa zay, ta taku ŋuɗufa ghuni da rfu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kulam nda va tsa mnay taŋ mantsa ŋa taŋ ya, zlahzlah ka həŋ pyaftá həŋ ta dzaʼa pla ghəŋ ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ta ma tsa gwaɗa ya həŋ, ka sliʼadaghatá la Yahuda ma luwa Aŋtakiya nda gwal ma luwa Ikwaniya, da baraftá tsa tskata mnduha ya. Ka zləzlərtsə lu ta Pwal ma ŋa dzata. Zlah nda mta tama ka lu ka tsəhidiŋta tahula luwa ta wa mazawa. ");
INSERT INTO xed_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama ka lagha gwal zlghay nda ŋuɗuf wanaghatá vgha, ka sliʼaftá tsi ka lami da huɗa luwa. Gamahtsimani, ka sliʼaftá tsi kawadaga nda Barnabas ka laghwi da luwa Derba. ");
INSERT INTO xed_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ka mnə həŋ ta Lfiɗa Gwaɗa ma tsa luwa ya. Ka mutsaftá həŋ ta ndəghata gwal ta zlghafta nda ŋuɗuf. Tahula tsa, ka vraghatá həŋ da luwa Listra, nda ya da luwa Ikwaniya, nda ya da luwa Aŋtakiya ta nzakway ta haɗika Pisidi ya. ");
INSERT INTO xed_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ka vlaŋtá həŋ ta mbraku ta tsa gwal zlghay nda ŋuɗuf ya, ŋa dihavata taŋ ma zlghay nda ŋuɗufa taŋ. «Nda ma ghuya ɗaŋwa kavghakavgha dzaʼa lama lu da ga mghama Lazglafta,» ka həŋ, nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ka paghanamtá həŋ ta gwal ŋa ngha mnduha ta həŋ ma inda vla guya ta ghəŋa mnduha Lazglafta. Tahula ndəɓata taŋ ta dzvu kawadaga nda suma, ka fanamtá həŋ ta tsa mnduha ya ma dzvu ta Lazglafta, ya zlghaf həŋ. ");
INSERT INTO xed_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ka sliʼaftá həŋ ka laghwi nda ta haɗika Pisidi, ka ɓhadaghatá həŋ ta haɗika Pamfali. ");
INSERT INTO xed_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ka mnə həŋ ta gwaɗa Lazglafta ma luwa Perge. Ka sliʼaftá həŋ ka laha da luwa Atali. ");
INSERT INTO xed_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ka sliʼaftá həŋ nda kwambalu hada guli, ka laghwi da luwa Aŋtakiya ta nzakway ta haɗika Siri ya. Ma tsa luwa ya mutsafta həŋ ta zɗakatahuɗa Lazglafta ŋa maganatá slna ya kɗa həŋ ta magay. ");
INSERT INTO xed_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Manda ɓhadaghata taŋ, ka tskanatá həŋ ta Igliz, ka rusu həŋ ŋa taŋ ta inda skwi ya magə Lazglafta nda həŋ, nda ya kəʼa guninistá tva zlghay nda ŋuɗuf ta gwal kul nzakway ka la Yahuda guli. ");
INSERT INTO xed_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ka hanavatá i Pwal nda Barnabas katakata ma luwa Aŋtakiya kawadaga nda gwal zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mamu sana mnduha ta sliʼafta ta haɗika Zudiya, ka lagha da Aŋtakiya da taghay ŋa zwanama kazlay: «Ka tsa a kuni ta fafaɗa ghuni manda ya mna zlaha Musa wu katsi ná, mbaf a kuni wa» kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Zɗəgana a tsa tagha skwa taŋ ya ta i Pwal nda Branabas wa. Ka zlərɗə həŋ ta wi nda həŋ ta ghəŋani ka ŋɗaŋɗa. Ka lu tama mantsa: Ka la i Pwal nda Barnabas nda sanlaha mataba mu da Ursalima slanaghatá gwal ghunay, nda la galata mndu, ka tsiŋta həŋ ta gwaɗa ta ghəŋani, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ka klaftá gwal zlghay nda ŋuɗuf ta skwi ŋa mbaɗa taŋ. Ka ksaftá həŋ ta tvi nda ma Finisi nda ya nda ma haɗika Samari, ka dzaʼa nda rusay, ka gwal kul nzakway ka la Yahuda zlghaftá Mgham Yesu. Ka rfu inda zwanama ta rfu katakata ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɓhadaghata taŋ da Ursalima, ka tsuʼaftá Igliz, nda gwal ghunay, nda la galata mndu, ta həŋ. Ka rusu həŋ ŋa taŋ ta skwi magə Lazglafta nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mbaɗa sanlaha mataba la Farisa ta zlghaftá Yesu, ka sliʼavafta. «Ɗatsay gwal kul nzakway ka la Yahuda ta fafaɗ, ka maga həŋ ta skwi ya mna zlaha Musa guli,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ka tskavatá gwal ghunay nda la galata mndu, ŋa ngha gwaɗa ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ka gwaɗanaghatá həŋ ta gwaɗa katakata ta ghəŋani. Ka sliʼaftá Piyer, kaʼa mantsa: «Zwanama, nda sna kuni manda ghalya kazlay: Mataba ghuni zbapta Lazglafta ta iʼi ŋa mnanaŋtá Lfiɗa Gwaɗa ta gwal kul nzakway ka la Yahuda, kada snaŋta həŋ ŋa zlghafta taŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ka maraŋtá Lazglafta ya nda sna ta ŋuɗufa inda mndu, ka tsuʼaftá həŋ nda ma vlaŋtani ta Sulkum nda ghuɓa ta həŋ manda ya vlama tsi ta amu ya guli. ");
INSERT INTO xed_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Haɗ sana skwi dgana Lazglafta ta amu nda hahəŋ manda ghuɓiŋtani ta ŋuɗufa taŋ, ma zlghafta taŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ndanana tama ní, kabgawu ta kəl kuni ka zlurga Lazglafta nda fanaghatá gwal zlghay nda ŋuɗuf ta ndəgaku ya trap dzidzíha mu nda amu tani guli ta kərtay na? ");
INSERT INTO xed_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nda ma zɗakatahuɗa Mghama mu Yesu Kristi fatá ghəŋa amu ta mbaku manda va hahəŋ guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Sew, ka tsa tskatá vgha ya nzata. Ka zlraftá i Barnabas nda Pwal ta rusa mazəmzəmha nda skwa mandərmimi maga Lazglafta nda ma hahəŋ mataba gwal kul nzakway ka la Yahuda. ");
INSERT INTO xed_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kɗakwa taŋ ta gwaɗa ta gwaɗa, ka zlraftá Yakubu ta gwaɗa, kaʼa mantsa: «Zwanama, swidwa! ");
INSERT INTO xed_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Rusamaf rusa Simuŋ ká Lazglafta zlraftá nghapta ka gwal kul nzakway ka la Yahuda, ka zabaptá tsi mataba taŋ ta gwal ŋa nzata ka ŋani. ");
INSERT INTO xed_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ka guram nda tsaya gwaɗata la anabi ta gwaɗa taŋ, manda ya nda vinda kazlay: ");
INSERT INTO xed_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Tahula tsaya dzaʼa vragavra yu, ŋa bəglafta ɗa ta həga Dawuda ta zluta ya. Ŋa payafta ɗa ta tsa ɓadzatani ya, ka sladanafta. ");
INSERT INTO xed_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Mantsa ya dzaʼa kəl hamata mnduha, ka tsa gwal kul nzakway ka la Yahuda hagaf yu ŋa nzakway ka ŋa ɗa ya ka psa iʼi, ka Mgham Lazglafta ta maga tsa skwiha ya ");
INSERT INTO xed_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","mnata daga manda ghalya.” ");
INSERT INTO xed_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ka kɗə Yakubu ta mna gwaɗani. Ma vlaŋ lu ta ghuya ɗaŋwa ta gwal kul nzakway ka la Yahuda ta mbəɗaktá vgha da Lazglafta, ka iʼi nda ŋa ɗa. ");
INSERT INTO xed_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Skwi ŋa vindanaftá həŋ na: Zlaŋta taŋ ta wuya skwi, nda hliri, nda za skwi ɓərtá lu nda ɓərta, nda za us, kabga ");
INSERT INTO xed_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","daga ma nzakwagaptá, mamu mnduha ta mna gwaɗa Musa ma inda luwa. Ta dzadzaŋay lu guli inda fitika Sabat ma həga tagha skwa la Yahuda,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mantsa tama, ka ndanatá gwal ghunay nda la galata mndu, nda gwal zlghay nda ŋuɗuf, ta pasaptá mnduha mataba taŋ ŋa ghunay da Aŋtakiya kawadaga nda i Pwal nda Barnabas. Ka psaptá həŋ ta i Yuda ta hgu lu ka Barsaba ya, nda Silas. Nda sgit ta həŋ his his mataba zwanama. ");
INSERT INTO xed_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wya ka həŋ vindanamtá ɗelewer ta həŋ ma dzvu: «Aŋni gwal ghunay nda la galata mndu ya ta ga zgu ŋa ghuni zwanama ta nzakway mataba gwal kul nzakway ka la Yahuda ma luwa la Aŋtakiya, ta haɗika Siri nda ya ta haɗika Silisi. ");
INSERT INTO xed_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Snaŋnagha sna gwaɗa ta ghəŋa sanlaha ma mndu ta sliʼafta da aŋni, ka lafi da kɓaghunafta kawadaga nda graha ŋni i Barnabas nda Pwal. ");
INSERT INTO xed_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ka nzanaghatá ŋni demdem ta ghəŋani, ka dgaptá hya mida. Ka zabaptá ŋni ta mnduha ŋa ghundaghunafta kawadaga nda graha ŋni i Barnabas nda Pwal. ");
INSERT INTO xed_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Hahəŋ gwal ta vlatá hafa taŋ ŋa maganatá slna ta Mghama mu Yesu Kristi. ");
INSERT INTO xed_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","I Yuda nda Silas ta ghunədaghunafta ŋni mista taŋ, ŋa rusaghunafta taŋ nda wubisima taŋ ta va na skwi vindaghunaf ŋni na. ");
INSERT INTO xed_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Skwi ta zɗəganatá Sulkum nda ghuɓa nda aŋni tani ná, va a ŋni ta faghunaghatá ndəgaku, ka malaghutá ya ta raku tkweʼ ka magay wa. Wya skwi ŋa magay ghuni: ");
INSERT INTO xed_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Yaha kuni za sluʼa skwa wuyay, yaha kuni za us, yaha kuni da za sluʼa skwi ɓərta lu nda ɓərta, yaha kuni hliri. Ka zlaŋzla kuni ta maga tsa skwiha ya katsi ná, magamaga kuni ta skwi ɗina. Ləŋləŋ ka kuni nzata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ka zlaŋtá i Pwal nda Barnabas nda Yuda nda Silas ta həŋ ka laghwi da Aŋtakiya. Ka tskanatá həŋ ta gwal zlghay nda ŋuɗuf, ka vlaŋtá həŋ ta tsa skwi vindanaf lu ya ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tahula dzaŋafta, ka rfu həŋ demdem ta rfu nda mbraku ya vlaŋ lu ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","I Yuda nda Silas ta nzakway ka la anabi ya, ka nzɗavata həŋ ta mna gwaɗa ŋa taŋ ŋa lɓa ŋuɗuf ŋa taŋ, ka mbra həŋ ma zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tahula nzɗavata taŋ tsəɓakw fitik hada, «ka ɓhata kuni ɗughwana tama zwanama!» ka gwal zlghay nda ŋuɗuf nda həŋ, ŋa vra taŋ slanaghatá gwal ta ghunaftá həŋ.  ");
INSERT INTO xed_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sliʼaf a yu wu, ka Silas ka nzaghuta hada. ");
INSERT INTO xed_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ka nzatá i Pwal nda Barnabas ma luwa Aŋtakiya. Ka taghə həŋ ta skwi ŋa mnduha, ka mnə həŋ ta gwaɗa Mgham Lazglafta kawadaga nda sanlaha ma mnduha. ");
INSERT INTO xed_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tsəɓakw fitik tahula tsa, «vru u vra da inda vli mana u ta gwaɗa Mgham Lazglafta, ka dzaʼa u naghanaghatá zwanama, ka kinawu nzakwa taŋ,» ka Pwal nda Barnabas. ");
INSERT INTO xed_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Si ta kumay Barnabas ta kliŋtá Yuhwana ta hgu lu ka Markus ya, mista taŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lanaf a tsa dzaʼani mista taŋ ya ta Pwal wu, kabga daga ta haɗika Pamfali ta tsaghutá tsi ta vgha ka kwalaghutá kɗa dzaʼa maga slna kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ka zlərɗanaftá həŋ katakata, ka dgatá həŋ ta vgha. Ka klaghatá Barnabas ta Markus mistani, ka ŋlaftá həŋ ta kwambalu ka laghwi ta haɗika Kiprus. ");
INSERT INTO xed_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ta zbaʼatá Pwal ta Silas. «Mista gha ka Lazglafta!» ka zwanama nda Pwal, ka sliʼaftá tsi ka laghwi. ");
INSERT INTO xed_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ka rə tsi ta haɗika Siri nda haɗika Silisi, ka vla mbraku ŋa Igliz. ");
INSERT INTO xed_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ka ɓhadaghatá Pwal da luwa Derba, nda ya da luwa Listra guli. Mamu sana mnda Zlghay nda ŋuɗuf hada, Timute hgani. Makwa la Yahuda ta nuta ka mnda zlghay nda ŋuɗuf ta yata. Mndəra la Grek dani. ");
INSERT INTO xed_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ta ghubay tsa zwanama ta nzakway ma luwa Listra nda ya ma luwa Ikwaniya ya ta Timute. ");
INSERT INTO xed_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ka kumaftá Pwal ta klay ta səlani, ka klə tsi. Ka tsanatá tsi ta fafaɗ, yaha gwaɗa da la Yahuda ta nzakway ma tsa vli ya, kabga nda sna həŋ demdem kazlay: Mndəra la Grek dani kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ma inda luwa ta ɓhadaghata həŋ, ta mnay həŋ ŋa inda gwal zlghay nda ŋuɗuf ta skwi ya tsiŋ gwal zlghay nda ŋuɗuf nda la galata mndu ta ghəŋani ma Ursalima. Tsaya skwi ŋa snata ghuni ka həŋ ta mnay ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ka mbrə Igliz ta vgha ma zlghay nda ŋuɗuf, ka sgaku mbsaka taŋ inda fitik. ");
INSERT INTO xed_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ka pyaftá Sulkum nda ghuɓa ta i Pwal nda Silas, ka mna gwaɗa Lazglafta ta haɗika Asiya. Ka sliʼaftá həŋ ka laghwi nda ta haɗika Frizi nda ya ta haɗika Galat. ");
INSERT INTO xed_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ndusadaghata taŋ ta haɗika Misiya, ka kumə həŋ ta dzaʼa ta haɗika Bitani, ama vlaŋ a Sulkuma Yesu ta tvi ta həŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ka kɗaŋtá həŋ ta dzaʼa nda ta haɗika Misiya, ka ɓhadaghatá həŋ da luwa Truwas. ");
INSERT INTO xed_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Hada, ka nghaŋtá Pwal ta sana mnda la Mekaduniya ta sladu ta kəmani ma suni, ta mnay ŋani kazlay: «Sawi da Mekaduniya da kata aŋni kəʼa.» ");
INSERT INTO xed_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tahula fanaghata tsa suni ya ta Pwal, ka gi psə ŋni ta tva dzaʼa da Mekaduniya, kabga grafgra ŋni kazlay: Ta hga aŋni Lazglafta ŋa kla Lfiɗa Gwaɗa da hada kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ka lamə ŋni da kwambalu ma luwa Truwas, ka ksaftá ŋni ta tva dzaʼa da luwa Samutra ta tsavata ma drəf ya. Gamahtsimani, ka laghu ŋni da luwa Nyapulis. ");
INSERT INTO xed_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ka sliʼaftá ŋni hada ka laghu ŋni da luwa Filipiya. Tsaya luwa dagala ta tsa haɗika Mekaduniya ta nzakway ma dzva la Ruma ya. Tsəɓakw fitika ŋni gerger ma tsa luwa ya. ");
INSERT INTO xed_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Baɗu fitika Sabat, ka saghu ŋni ma huɗa luwa ka laghwi tawa ghwa, dzaʼa slafsla ŋni ta vla ndəɓa dzva la Yahuda hada ka ŋni sizlay. Ka slaftá ŋni ta tskata miʼaha. Ka mnə ŋni ta gwaɗa ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lidiya hga sana marakw mataba taŋ, makwa luwa Tiyatir ya. Lguta dva ya nda bla nda bla dzvani ta dzawə tsi. Ta zləŋay ta Lazglafta guli. Ka fatá tsi ta sləməŋ ka sna gwaɗa ŋni. Ka gunanaŋtá Lazglafta ta ŋuɗufani, ŋa tsuʼa tsa gwaɗa ta gwaɗə Pwal ya. ");
INSERT INTO xed_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ka maganafta lu ta batem nduk nda la ga taŋ tani. «Ka grafgra kuni kazlay: Zlghafzlgha yu ta Mgham Yesu kəʼa, sawa da ini» kaʼa ka mbladaghatá aŋni da taŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ta dzaʼa ŋni da vla maga duʼa ma sana fitik, ka gəmatá ŋni nda sana makwa ka kwalva ksu ghwaɗaka sulkum ta vlaŋtá mna skwi dzaʼa magaku ta kəma. Dagala tsedi ta tsanakta tsi ta daŋahəgani, nda tsa ma slayaŋslayaŋani ya. ");
INSERT INTO xed_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ka gi mbaɗə tsi mista ŋni nda i Pwal. «Nana mnduha na ná, gwal ksanatá slna ta Lazglafta ta luwa ya, tva mbaku ta mnaghunata həŋ!» kaʼa ta dzaʼa nda guguɗay. ");
INSERT INTO xed_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nda za fitikhani ta mna tsa gwaɗa ya tama, ka psanaghatá tsi ta Pwal. «Nda hga Yesu Kristi, sabsa ma na makwa na,» kaʼa nda tsa ghwaɗaka sulkum mida ya. Ka gi sabə tsi mida hadahada. ");
INSERT INTO xed_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nghay la daŋahəgani ma tsa makwa ya ta kwala taŋ kul fəglaftá ghəŋ ta mutsa tsedi, ka hlaftá həŋ ta i Pwal nda Silas, ka hlaghatá ta dawadawa ta kəma gwal dagala dagala. ");
INSERT INTO xed_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ka hladaghatá həŋ ta həŋ da mnda tsa guma la Ruma. Ka həŋ mantsa: «Gwaɗa ŋa kətsiɗa mnduha klamak nana mnduha la Yahuda na. ");
INSERT INTO xed_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ka taghamatá nzaku kul nghamata, kul ramata tsuʼay mu, kul ramata ksay mu ta slna nda tsi, na amu ta nzakway ka la Ruma na,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ka pghaftá dəmga ta vgha ta həŋ. Ka susuɗaghutá gwal guma ta lguta i Pwal nda Silas. «Sləvawa həŋ nda krupi,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tahula sləvaptá həŋ, ka hlaghatá lu ta həŋ da gamak. «Ka ngha ka ta həŋ ɗina,» ka lu nda mnda ngha gamak. ");
INSERT INTO xed_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na mnanata lu ta tsa gwaɗa ya ta mnda ngha gamak, ka hlaghatá tsi ta həŋ da huɗa həga. Ka tsatsamtá tsi ta səlaha taŋ ma udzu. ");
INSERT INTO xed_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ma takala tama, ka magə i Pwal nda Silas ta duʼa, ka falaha nda zləzlva Lazglafta. Ta snaysnay hamata la vuʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Gi ka ghudzavaftá haɗik, ka gigɗavaftá tughwa tsa gamak ya. Gi ka gwanutá inda watgha tida, ka pwalutá ziɗa ta inda la vuʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ka sliʼavatá tsa mndu ta ngha həŋ ya. Kəʼa kəʼa ná, nda gwana tsa gamak ya. Ka tsəhagaptá tsi ta budgwani ŋa dzuvtá vghani, ba sliʼaghuslia inda la vuʼa kəʼa sizlay. ");
INSERT INTO xed_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","«Ma dzuv ka ta vgha gha, wana ŋni demdem hadna,» ka Pwal guguɗata. ");
INSERT INTO xed_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","«Pinifwa vu ya,» ka tsa mnda ngha vuʼa ya, ka ndadamtá tsi zləmbatá ta kəma i Pwal nda Silas, ta ghudzaku vghani da zləŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tahula tsa ka hligiŋtá tsi ta həŋ. Kaʼa nda həŋ mantsa: «Mghamha ɗa, nu dzaʼa yu magata ka da mbafta yu na?» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ka Pwal nda Silas mantsa: «Zlghafzlgha ta Mgham Yesu Kristi, ka mbafta ka, kagha nda la ga ghuni tani,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ka mnanatá həŋ ta gwaɗa Mgham Lazglafta, ŋa tsatsi nda la ga taŋ tani demdem. ");
INSERT INTO xed_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ka hlaghatá tsi ta həŋ ta va tsa rviɗik ya ka laghwi ghuɓinistá lkuha taŋ. Ka gi maganaftá lu ta batem ta tsa mndu ya nda la ga taŋ tani demdem. ");
INSERT INTO xed_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ka klaghatá tsi ta i Pwal nda Silas da taŋ, ka zunustá skwi ta həŋ. Ka rfu tsa mndu ya nda la ga taŋ tani ta rfu, kabga zlghafta taŋ ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tsaɗakwa vli, ka ghunaftá gwal tsa guma ta mnduha da tsa mnda ngha vuʼa ya kazlay: Zliŋzla ta həŋ kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ka mnda ngha vuʼa lami mnanatá Pwal mantsa: «Zliŋzla ta həŋ, ka gwal tsa guma tsghaɗiktá lwi, sabwasa, ka dzaʼa kuni nda zɗaku,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ka Pwal nda tsa gwal ghunadagha lu ya mantsa: «Tsaŋnagha a lu ta guma wu, ka gi slvaptá lu ta aŋni ta kəma mnduha, ka pghamtá aŋni ma gamak, ta aŋni ta nzakway ka mnduha la Ruma ná, gi ndanana ná, sabwa sa kɗekkɗek ka lu nda aŋni ra? Magava a tsaya mantsa wa! Sagha hahəŋ kaghəŋa taŋ zliŋnista,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ka sliʼaftá tsa gwal ghunadagha lu ya rusanaftá gwal tsa guma. Ka ksaftá zləŋ ta həŋ, snaŋər həŋ kazlay: Mnduha la Ruma i Pwal nda Silas kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ka lagha həŋ da ndəɓa dzvu, ka həŋ mantsa: «Ga ghunaga ŋni ta dmaku,» ka həŋ. Ka hligiŋtá həŋ ta həŋ ma gamak. Ka ndəɓanatá həŋ ta dzvu ta həŋ ŋa sliʼapta taŋ ma tsa luwa ya. ");
INSERT INTO xed_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Saba i Pwal nda Silas ma gamak, ka laghu həŋ da Lidiya. Tahula nghanaghata taŋ ta zwanama, ka vlaŋtá mbraku ta həŋ ka sliʼaftá həŋ ka laghwi. ");
INSERT INTO xed_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ka ksaghatá həŋ ta tvi nda ma luwa Amfipulis ka zlagaghata nda ma luwa Apuliniya, ka ɓhaghata həŋ da luwa Tesalunik. Hada, mamu həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Hkən Sabata Pwal ta lami ta ghəŋ ta ghəŋ manda ya snu tsi. Ka zlərɗə tsi nda həŋ ta skwi nda vinda ma deftera Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ka paslay ŋa taŋ, ka mnay kazlay: Dzaʼa ghuyə ghuya Kristi ta ɗaŋwa, dzaʼa sliʼagapsliʼa nda hafu mataba gwal nda rwa kəʼa. «Tsəna Yesu ta mnə yu ŋa ghuni na ná, tsaya tsa Kristi ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ka tɗaghata tsa gwaɗa ya ta ghunislaka sanlaha ma la Yahuda ta snay, ka laghu həŋ mista i Pwal nda Silas. Mantsa ya ndəghata la Grek ta zləŋa Lazglafta, nda ndəghata sanlaha ma miʼaha dagaladagala guli. ");
INSERT INTO xed_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ka ndəghanaftá draku ta ŋuɗufa sanlaha ma la Yahuda, ka hlafta həŋ ta la tanda ma luwa, ka sliʼanafta həŋ ta ŋuɗufa mnduha. Ka sliʼadaghata həŋ da Yasuŋ, ka zbə həŋ ta i Pwal nda Silas ŋa hla həŋ ta kəma mnduha, ");
INSERT INTO xed_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","slanagha a həŋ ta həŋ wa. Ka ksaghatá həŋ ta Yasuŋ nda sanlaha ma zwanama ta kəma gwal ta tsa guma ma luwa. Ka həŋ mantsa: «Nana mnduha na ta kətsiɗanaftá mnduha ta ghəŋa haɗik, ka sagha həŋ da amu ndanana, ");
INSERT INTO xed_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ka tsuʼafta Yasuŋ ta həŋ ga taŋ. Haɗ həŋ ta sna zlahu ya ta fata mgham Sezar wa. Mamu sana Mgham ta hgə lu ka Yesu, ka həŋ ta mnay,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Snaŋta mnduha ma tsa luwa ya nda gwal ta tsa guma ta tsa gwaɗa ya, ka sliʼavaftá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ka platá i Yasuŋ nda tsa sanlaha ma zwanama ya ta bika kada zliŋta gwal ta tsa guma ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Girviɗik tama, ka kɗikiŋtá gwal zlghay nda ŋuɗuf ta i Pwal nda Silas da luwa Bere. Ɓhadaghata taŋ da hada, ka lamə həŋ da həga tagha skwa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mal la Yahuda ma Bere zɗakwa ghəŋa taŋ ka gwal ma luwa Tesalunik, kabga fafa hahəŋ ta ghəŋa taŋ kahwathwata ka sna gwaɗa Lazglafta. Inda fitik həŋ ta vitsa vindatá skwi ma deftera Lazglafta ŋa nghay ka manda va tsaya tsi re, ka manda va tsaya a wa a tsa skwi ta mnə Pwal ŋa taŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nda ndəgha la Yahuda ta zlghafta nda ŋuɗufa taŋ. Mantsa ya ndəghata miʼaha dagaladagala mataba la Grek nda zgwana taŋ tani. ");
INSERT INTO xed_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Snaŋta tsa la Yahuda ma luwa Tesalunik ya kazlay: Waʼa Pwal ta mna gwaɗa Lazglafta ma luwa Bere kay guli kəʼa, ka sliʼadaghata həŋ da tsa luwa ya sliʼanaftá ŋuɗufa mnduha. ");
INSERT INTO xed_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ka gi kɗikiŋtá zwanama ta Pwal nda ta wa drəf, ta nzaghuta i Silas nda Timute ma luwa Bere. ");
INSERT INTO xed_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ka klaghatá gwal pghay ta Pwal, tep da luwa Atina. Ma sliʼa taŋ ka vru, ka mnanatá Pwal ta həŋ kazlay: Ka sagha i Silas nda Timute sliɗighata misimmisim ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ma tsa nzakwa Pwal ta kzla i Silas nda Timute ma luwa Atina ya, ka nanaghaŋtá tsi ta skwa wuyayha ma tsa luwa ya, ka kuzlanaftá tsi ta ŋuɗuf katakata. ");
INSERT INTO xed_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Mantsa tama, ka ghu tsi ta yiva nda la Yahuda, nda ya nda gwal ta zləŋa Lazglafta ma həga tagha skwa la Yahuda. Mantsa ya guli nda inda mndu ta guyatá tsi nda həŋ ta dawadawa vli inda fitik. ");
INSERT INTO xed_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mamu gwal ta tagha dzaŋa tva mbaɗa gwaɗa ta hgə lu ka la Ipikuri, nda Situyikiya ta mbaɗa gwaɗa nda tsi guli. «Nu ta yə na mndu na katək na?» ka sanlaha. «Gwaɗa ta sana Lazglafta kul haɗ hadna ta gwaɗə tsi.» Ka sanlaha, kabga snay taŋ ta mnay Pwal ta gwaɗa ta Yesu nda sliʼagapta ya sliʼagap tsi mataba gwal nda rwa. ");
INSERT INTO xed_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ka klaghatá həŋ ta Pwal mista taŋ, ka kladaghata ta kəma gwal dzra gwaɗa ta sana kuɗuŋur ta hgə lu ka Ariyupas. «Dzaʼa snaŋnamsna ka ta na lfiɗa skwi ta taghə ka na rki na? ");
INSERT INTO xed_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nana gwaɗa ta mnə ka na ná, ka lfiɗani nzakwani da aŋni. Ta kumay ŋni ta snaŋta klatá ghəŋani,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Inda la Atina nda la matbayha ma tsa luwa ya, tsa lfiɗa skwi yeya ta gwagwaɗu lu, ta snə lu kweŋkweŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ka sladatá Pwal ta kəma tsa gwal dzra gwaɗa ya, kaʼa mantsa: «Kaghuni mnduha la Atina, ta nghadaptá yu dər ndigandiga ná, ŋanaŋa kuni ta dina. ");
INSERT INTO xed_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ma fitika ranafta ɗa ta vliha ma na luwa ghuni na ná, ka slaslanaghatá yu ta skwiha ta ndəɓu kuni ta dzvu ŋa taŋ. Ka slaftá yu ta gwir vindaf lu ta skwi tida kazlay: Ŋa Lazglafta kul snaŋta lu kəʼa. Mantsa nzakwani, tsa skwi ta ndəɓu kuni ta dzvu ŋani kul snaŋta kuni ya ná, tsaya sagha yu da mnaghunata. ");
INSERT INTO xed_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tsaya Lazglafta ta magaftá haɗik nda inda skwi tida tani. Tsatsi Mgham ta ghəŋa luwa nda haɗik. Haɗ ta walaŋta nzaku ma həga ya baf mndu nda dzvani wa. ");
INSERT INTO xed_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Psaŋ a ta katu da mnda səla ŋa vlaŋtá skwi wa. Haɗ skwi pɗa tsatsi guli wa. Tsatsi ta famta hafu ma inda mndu ta kəl mndu ka hafu. Tsatsi guli ta vlata inda hamata skwi. ");
INSERT INTO xed_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nda ma mndu turtuk zlagagiŋta tsi ta inda mnduha, ka pghata həŋ təɓsaʼ ta ghəŋa haɗik demdem. Ka daganatá fitika inda skwi, kwakwaranaha ta inda taŋ ta haɗik ŋa nzakwa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mantsa ya kəʼa magafta, kabga ŋa zbay taŋ ta Mgham Lazglafta, ma tatamay taŋ ta zbay. Aŋ mndani, diʼiŋaghu a nda amu wa. ");
INSERT INTO xed_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Əŋkaʼa ka tsatsi ta kəl mu ka nzaku nda hafu, dər ta kəl mu ka gigɗavata, dər ta kəl mu ka nzaku. Mantsa ya mnata gwal fa laha mataba ghuni guli: “Kahwathwata mndəra taŋ amu guli,” ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ka si mndəra taŋ ma Lazglafta amu ya, ra a ka ndanay mu ta granaftá Lazglafta nda tsa skwa wuyayha tsatsaf lu nda dasu, nda ya nda kufur, nda ya nda pala tsana a mnda səla ka ghəŋani ta magafta ya wa. ");
INSERT INTO xed_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ŋaw lu ɓa, ka Lazglafta nda mnduha daga manda ghalya, kabga kwala taŋ kul snaŋta. Ndanana tama, ta hga mnduha Lazglafta ma inda vli ka mbəɗanafta həŋ ta nzakwa taŋ, ");
INSERT INTO xed_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kabga fafa ta fitik ŋa tsanaghata guma nda tvani ta inda ghəŋa haɗik. Zbapzba Lazglafta ta mndu ŋa maga tsaya ka sliʼaganaptá tsi mataba gwal nda rwa. Manda tsaya maranaŋta Lazglafta ta inda mndu kazlay: Tsatsi vərɗa mnda tsa guma zbap yu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na tsa snaŋta taŋ ta mnay Pwal ta gwaɗa ta sliʼagapta mataba gwal nda rwa ya, ka ghuɓasu sanlaha nda ghuɓasa ta Pwal. «Ŋa snəglanavata ŋni baɗu ma sani ta tsa gwaɗa ta mnə ka ya,» ka sanlaha. ");
INSERT INTO xed_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ka sliʼafta Pwal mataba taŋ ka laghwi. ");
INSERT INTO xed_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mataba va tsaya ná, mamu sanlaha ta zlghafta, ka laghu həŋ mistani. Mataba taŋ, mamu Deniz, ta nzakway tekw tsatsi mataba gwal ta dzra gwaɗa ma Ariyupas, nda sana marakw Damaris hgani, nda sanlaha guli kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Tahula tsa, ka sliʼaftá Pwal ma luwa Atina, ka laghwi da luwa Kwareŋt. ");
INSERT INTO xed_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Hada, ka guyatá tsi nda sana mnda la Yahuda ta hgu lu ka Akilas, ya lu ta haɗika Puŋ. Sliʼaftani yeya ta haɗika Italiya kawadaga nda markwa taŋ Priskila, kabga ka sliʼapsliʼa inda la Yahuda ta haɗika Ruma ka mgham Klawdi mnata. Ka guyaftá Pwal ta vgha nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ka skwa turtuk slna ta magə həŋ. Həga tumpul ta ɗaɗah həŋ. Tsaya kəl Pwal ka gwaftá vgha nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Inda fitika Sabat Pwal ta zlərɗa gwaɗa ma həga tagha skwa la Yahuda, nda la Yahuda nda ya nda la Grek, kabga ta kumay ta tɗaktá həŋ ŋa zlghaftá gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Manda zlaŋta i Silas nda Timute ta haɗika Mekaduniya, ka lagha slanaghatá Pwal, ka vzatá Pwal ta ghəŋani ka mna gwaɗa. Ka paslə tsi ŋa la Yahuda kazlay: Yesu ná, Kristi ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ka gruŋtá la Yahuda ka rarazay. Mbaɗa Pwal ka tukwanatá rgitika lgutani ta həŋ. Kaʼa nda həŋ mantsa: «Ta ghəŋa ghuni ka skwa ghuni, daga ndana nda sliʼa yu tvə gwal kul nzakway ka la Yahuda,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ka sliʼaftá tsi hada ka lagha da sana mndu, Tirtiyus Yustus hgani. Ta zləŋay tsa mndu ya ta Lazglafta. Tavata həga tagha skwa la Yahuda həga taŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ka zlghaftá Krispus ta nzakway ka mgham ta ghəŋa həga tagha skwa la Yahuda ta Mgham Yesu, mantsa ya la ga taŋ guli. Nda ndəgha gwal ma Kwareŋt guli ta snaŋtá gwaɗa Pwal, ka zlghaftá həŋ, ka maganaftá lu ta batem ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ta sana rviɗik, ka gwaɗganatá Lazglafta ta Pwal nda ma suni. Kaʼa mantsa: «Yaha zləŋ da ksaftá kagha da haftá ka ta wi Pwal, kɗaŋ gwaɗay. ");
INSERT INTO xed_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kawadaga yu nda kagha, haɗ mndu dzaʼa walaŋta faftá dzvu ta kagha ŋa ghuya ɗaŋwa ŋa gha wa. Nda ndəgha mnduha ɗa ta ma na luwa na,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ka zata pwal ta vaku nda tili mkuʼ ma tsa luwa ya, ta taghanaftá mnduha ta gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ma fitika nzakwa Galiyuna ka ŋumna ta haɗika Akaya tama, ka gwaftá la Yahuda ta wi ka gruŋtá Pwal. Ka kladaptá həŋ da vla tsa guma. ");
INSERT INTO xed_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ka həŋ mantsa: «Nana mndu na ta bara mnduha ŋa tsəlɓu ta kəma Lazglafta, ka zluŋtá skwi mna zlahu,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ta dzaʼa dzaʼa Pwal da gwaɗa mantsa, ama ka gi tsuʼaftá Galiyuna ta gwaɗa nda la Yahuda. Kaʼa mantsa: «Ka haɗ mndu dza lu wu katsi, haɗ sana dmaku ta bluta wu katsi, haɗ yu ta snaghunata, a la Yahuda wa. ");
INSERT INTO xed_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ka si ta ghəŋa zwana gwaɗaha, nda ya ta ghəŋa hgu, nda ya ta ghəŋa zlaha ghuni ta zlərɗa kuni ya, dzik nda kaghuni tsa. Va a yu ta tsa guma ta ghəŋa tsa skwiha ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ka ghzlaftá tsi ta həŋ ma vla tsa guma. ");
INSERT INTO xed_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ka gwaftá həŋ ta wi ta Sustene, ta nzakway ka mgham ta ghəŋa tsa həga tagha skwa la Yahuda ya, ka ksafta, ka ɗgapta ta wa tsa vla tsa guma ya, gvalaŋ a Galiyuna wa. ");
INSERT INTO xed_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ka nzɗəglavatá Pwal tsəɓakw fitik ma Kwareŋt. Tahula tsa, ka sliʼaftá tsi kawadaga nda i Priskila nda Akilas, ka zlaŋtá zwanama, ka lami da kwambalu, ka laghwi ta haɗika Siri. Ma kɗə tsi ka lami da kwambalu, ka htsatá tsi ta ghəŋani ma luwa Saŋkre, si waɗana tsi ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ka ɓhadaghatá həŋ da luwa Afisus, ka zlanatá Pwal ta i Priskila nda Akilas. Ka sliʼaftá tsi ka lami da həga tagha skwa la Yahuda, ka ghwa yiva nda la Yahuda hada. ");
INSERT INTO xed_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ka ndəɓə həŋ ta dzvu da tsi, má ŋa nzɗavatani da həŋ, ama ɗvaf a Pwal wa. ");
INSERT INTO xed_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","«Ta dzaʼa vragaghavra yu ka ta ɗvay Lazglafta,» kaʼa nda həŋ. Ka ŋlaftá tsi ta kwambalu ma Afisus ka laghwi. ");
INSERT INTO xed_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ka ɓhadaghatá tsi da luwa Sezare. Ka sliʼaftá tsi hada guli ka laghwi da luwa Ursalima da ganaghatá zgu ta Igliz karaku, ma kɗaku tsi ka laghwi da luwa Aŋtakiya. ");
INSERT INTO xed_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tahula nzɗavatani gerger ma luwa Aŋtakiya ta haɗika Siri, ka sliʼaftá tsi ka laghwi da ranaftá haɗika Galat, nda haɗika Frizi, ka vla mbraku ŋa inda gwal zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mamu sana mnda la Yahuda, Apwalus hgani, ma luwa Alegzandri yata lu. Ka lagha tsi da luwa Afisus. Mnda gwaɗa ya, nda sna ta vindata skwiha ma defteri. ");
INSERT INTO xed_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Taghaf tagha ta skwi ta tva Mgham Yesu. Ká ka nda warakatani. Ta taghay ta skwi ta ghəŋa Yesu nda tvani ŋa mnduha. Aŋ mndani, maga batema Yuhwana yeya snaŋ tsi. ");
INSERT INTO xed_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ka mnə tsi ta gwaɗa nda tsafaratá vgha ma həga tagha skwa la Yahuda. Snay i Priskila nda Akilas ta skwi ta mnə tsi, ka hgaghatá həŋ ŋa sganaghata taghanaftá skwi nda tvani ta ghəŋa gwaɗa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tahula tsa, ka kumaftá Apwalus ta dzaʼa ta haɗika Akaya. Ka sganaghatá zwanama ta mbraku, ka vindanaftá həŋ ta ɗelewer ta gwal ta tsa haɗik ya ŋa tsuʼafta taŋ nda rfu. Ɓhadaghatani da hada, ka kataŋtá tsi nda zɗaku ya vlaŋ Lazglafta ta gwal ta ghadatá zlghafta. ");
INSERT INTO xed_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ka gwaɗə tsi ta gwaɗa baŋluwa nda la Yahuda, ka traptá həŋ ta skwi ŋa ŋrapta. Ka maranaŋtá tsi ta həŋ ta skwi nda vinda ma defteri kazlay: Yesu ná, Kristi ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ma fitika nzakwa Apwalus ma luwa Kwareŋt, ka ranaftá Pwal ta vli ta ghwáha ta haɗika Asiya, ka ɓhadaghatá tsi da luwa Afisus ka slaftá tsi ta sanlaha ma gwal zlghay nda ŋuɗuf hada. ");
INSERT INTO xed_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kaʼa mantsa: «Mutsafmutsa kuni ta Sulkum nda ghuɓa ma zlghafta ghuni ra?» kaʼa ɗawaŋta da həŋ. Ka həŋ nda tsi mantsa: «Ta sna a ŋni ta skwi ta hgə lu ka Sulkum nda ghuɓa wa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","«Mndərga wati batem magaghunaf lu na?» kaʼa nda həŋ. «Mndərga ŋa Yuhwana magaŋnaf lu,» ka həŋ nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ka Pwal mantsa: «Gwal ta tsuʼafta ka mbəɗanaftá nzakwa taŋ, maganaf Yuhwana ta batem ta həŋ. Ka Yuhwana nda həŋ na: Zlghafwazlgha ta tsa mndu ta sagha nda hula ɗa ta nzakway ka Yesu ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Tahula snaŋta taŋ ta tsa gwaɗa ya, ka maganaftá lu ta batem ta həŋ nda hga Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ka fanaghatá Pwal ta dzvu ta həŋ, ka saha Sulkum nda ghuɓa ta ghəŋa taŋ. Ka gwaɗə həŋ ta gwaɗa nda sanlaha ma gwaɗa, ka klə həŋ ta lwa Lazglafta guli. ");
INSERT INTO xed_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ta magay gwagwa ta tsa mnduha ya ta ghwaŋpɗə his. ");
INSERT INTO xed_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tahula tsa, ka gɗatá Pwal ta dzaʼa da həga tagha skwa la Yahuda. Hkən tilani ta mna gwaɗa ta ga mghama Lazglafta, ka ŋavata ŋa tɗaktá ghəŋa gwal ta sna skwi ta mnə tsi. ");
INSERT INTO xed_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ka təŋanaftá sanlaha mataba taŋ ta ghəŋ, ka kwalaghutá həŋ ta zlghafta, ka ghuɓasə həŋ ta tsa tagha skwi ta ghəŋa tva Yesu ya ta kəma tskata mnduha. Tsaya tama, ka sliʼaftá Pwal ka zlaŋtá həŋ, ka hlaghatá gwal zlghay nda ŋuɗuf, ka laghu həŋ da həga dzaŋa Tiranus, ka taghə tsi ta skwi ŋa taŋ inda fitik hada. ");
INSERT INTO xed_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","His vakwa taŋ ta taghay. Ma tsaya snaŋta inda gwal ta nzakway ta haɗika Asiya, daga la Yahuda, nda la Grek tani ta gwaɗa Mgham Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ka magə Lazglafta ta mazəmzəm ŋa ndərmimay nda ma Pwal. ");
INSERT INTO xed_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Tsaya ta kəl lu ka klaftá lgut nda salawar ya ta ksaŋtá vgha Pwal tazlay, ka klaŋtá gwal kul ɗughwanaku ŋa ksaŋtá həŋ, ŋa saghwa tsa ɗaŋwa nda ghwaɗaka sulkum ya tani ma həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mamu sanlaha ma la Yahuda guli ta ra luwa, ŋa ghazligiŋtá ghwaɗaka sulkum ma mnduha. Ka dzəghaŋtá hahəŋ guli ta ghzla ghwaɗaka sulkum nda həga Mgham Yesu ma gwal nda kasa da halaway. Ka həŋ mantsa: «Nda hga tsa Yesu ta mnə Pwal ya ta mnaghunata ŋni: Sabwasa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ndəfáŋ zwana sana mndu ta hgə lu ka Seva ta nzakway tekw mataba la mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta la Zudiya, ta maga mndərga tsa skwi ya mantsa. ");
INSERT INTO xed_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma sana fitik, ka tsa ghwaɗaka sulkum ya nda həŋ mantsa: «Wya nda sna yu ta Yesu, nda sna yu ta Pwal guli, wa kaghuni tama?» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ka valaftá tsa mndu ksu halaway ya ta həŋ ka mbranaghatá həŋ demdem. Ka ndandagaptá həŋ ma tsa həga ya nda hwaya ka fərdiʼu, nda babalatá vgha. ");
INSERT INTO xed_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ka snanaghatá tsa skwi ya ta inda la Yahuda nda la Grek tani ma luwa Afisus. Ka ksaftá zləŋ ta həŋ demdem, ka vlə həŋ ta glaku ŋa Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ta traku gwal si ta zlghafta, ka sagha həŋ da mnay nda wa taŋ ta ghwaɗaka skwi ya mamaga həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nda ndəgha gwal si ta mbaɗaku ta hlaktá defteriha taŋ ka dariŋta ta kəma mnduha demdem. Ka mbaɗaftá lu ta tseda tsa defteriha ya ná, ta klay ta tsedi ka dəmbuʼ hutaf ");
INSERT INTO xed_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mantsa ya kəl gwaɗa Mgham Yesu ka ŋluta, ka zuta vli nda mbrakwa Mgham Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tahula tsa, ka Pwal ndanata mantsa: Ka ranafra yu ta vli ta haɗika Mekaduniya, nda vli ta haɗika Akaya katsi, ta dzaʼa da luwa Ursalima yu. «Ka ɓhadaghaɓha yu da hada katsi guli, nda nza tkweʼ ka ɓhadaghata ɗa da luwa Ruma guli,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ka ghunaghatá tsi ta i Timute nda Irasta, his mataba gwal ta kataŋta ta haɗika Mekaduniya. Ta nzatá vərɗa tsatsi ka nzɗavata ta haɗika Asiya. ");
INSERT INTO xed_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ma tsa fitik ya, ka sliʼavaftá gwaɗa katakata ta ghəŋa Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tsaw mamu sana ɗəgha ta slru ta hgu lu ka Dametriyus, ta slara zwana həga ka kufur, ŋa wuyay, ta hgu lu ka Deyes Artimis. Kaɗ ka skwi ta planata tsi ta gwal ta maganatá slna. ");
INSERT INTO xed_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ka tskanatá tsi ta tsa mnduhani ya, kawadaga nda sanlaha ta maga mndərga tsa slnahani ya guli. Kaʼa nda həŋ mantsa: «Graha! Nda sna kuni kazlay: Ta na skwi ta tsatsafta mu na nzafta mu kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nda ngha kuni, nda sna kuni guli ta skwi ta mnə Pwal. Kaʼa na: Nza a skwi ta tsatsafta mnduha nda dzva taŋ ka Lazglafta wu, kaʼa. Ka tɗaghatá tsi ta ndəghata mnduha. Ma na luwa Afisus na kweŋkweŋ yeya a wu, nduk ma inda vli ta haɗika Asiya tani. ");
INSERT INTO xed_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wana na skwi na dzaʼa dzatá slna mu. Tsaya ya a wu, dzaʼa zləmbaku gwaɗa ta ghəŋa həga skwa wuyay mu dagala ta nzakway ka Deyes Artimis. Vləgəlta a mnduha ta glaku ŋa Deyes ka tsəlɓu ma ghuvani manda ya ta magə lu ma inda vli ta haɗika Asiya nda ya ta ghəŋ haɗik demdem ya wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Snaŋta taŋ ta tsa gwaɗa ya, ka gufaftá ŋuɗufa taŋ ka guguɗ həŋ ta guguɗaku. «Ya dagala gwaɗa ta Dayes Artimis la Afisus,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ka sliʼavaftá vli kuɗukuts ma luwa demdem, ka hwaya da vla katskatsu, ka ksədanaghatá həŋ ta graha Pwal ta nzakway ka i Gayus nda Aristarkus, tsa hahəŋ his ta nzakway ka mnduha la Mekaduniya ya. ");
INSERT INTO xed_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Si ka kumə Pwal ta dzaʼa slanaghatá həŋ, ama ka pyaftá gwal zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mamu sanlaha ma gwal ksa slna ŋumna ta haɗika Asiya ta nzakway ka graha Pwal. «Yaha ka da dzaʼa da tsa vla katskatsu ya,» ka həŋ tsghadanaghatá lwi ta Pwal. ");
INSERT INTO xed_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ta tsa luwa ya, nda ghuya ghəŋa mnduha. Ka nu ŋa ya laha ta guguɗay, ka nu ŋa ya laha ta gugɗay. Mal gwal mataba taŋ kul snaŋtá skwi ta tskanatá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ka snanamtá sana mnduha ta tsa gwaɗa ya ta sana mndu ta hgu lu ka Alegzandra ta klə la Yahuda ta kəma. Ka Alegzandra tama mantsa: «Swidwa! Swidwa!» kəʼa kapaŋtá dzvu, ka kuma gwaɗa ŋa mnanaŋtá mnduha. ");
INSERT INTO xed_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Manda snaŋta taŋ kazlay: Mnda la Yahuda na mndu na kəʼa, ka hlaftá həŋ ta wi ka skwa turtuk ka zatá awa his. Ka həŋ mantsa: «Dagala gwaɗa ta Dayes Artimis la Afisus!» ka həŋ hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ka lɓanatá mnda vindi ma tsa luwa ya ta mnduha zlahzlah. Kaʼa mantsa: «Ari wa la Afisus, wa ya kul snaŋta kazlay: Luwa Afisus ta ŋanatá tsa həga Dayes Artimis dagala ya, nda tsa tsatani ta saha ta luwa ya kəʼa na? ");
INSERT INTO xed_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Haɗ mndu dzaʼa zlərɗay wa. Lɓanatá ŋuɗuf ka dzatá ghəŋ skwi ŋa magay. ");
INSERT INTO xed_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Na mnduha hlagagha kuni da hadna na ná, haɗ sana rutsak vzaf həŋ ta həga skwa wuyay, ka razatá Diyesa mu wa. ");
INSERT INTO xed_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ka mamu skwi mataba Dematriyus kawadaga nda gwal ksanatá slna nda sana mndu katsi, mamu vla tsa guma, ka kla həŋ da gwal tsa guma, ka dzaʼa həŋ dganata hada. ");
INSERT INTO xed_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ka mamu sna gwaɗa ta kumə kuni ta mnay katsi guli, dzaʼa dzray mu ta tsaya ma vla dzrəka mu. ");
INSERT INTO xed_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ta ghəŋa na skwi ta magaku gita na ná, laviŋlava lu ta tsaftá badza ta amu ka gwal zlərɗawi, kabga haɗ skwi prək ka tskamata mandana ná, ŋa mnay mu kazlay: Ta ghəŋa ya skwi ya tskavata mu kəʼa wa,» kaʼa. Kɗakwani ta gwaɗa, «gazlawagazla,» kaʼa nda mnduha. ");
INSERT INTO xed_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Tahula lɓatá tsa sliʼavafta sliʼavaf lu ya, ka tskanatá Pwal ta gwal zlghay nda ŋuɗuf, ka vlaŋtá mbraku ta həŋ. Ka dgatá tsi ta vgha nda həŋ, ka laghwi ta haɗika Mekaduniya. ");
INSERT INTO xed_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Tahula ranaftani ta tsa haɗika ya, ka valaŋtá tsi ta mbraku katakata ta gwal zlghay nda ŋuɗuf, ka ɓhadaghatá tsi ta haɗika Gres. ");
INSERT INTO xed_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ka zatá tsi ta tili hkən hada. Ta dzaʼa dzaʼa lami da kwambalu ŋa dzaʼa ta haɗika Siri tama, ka snaŋtá tsi ta dzray ta dzrə la Yahuda ta wi ta ghəŋani ŋa pghanatá buɗukwa. Ka ksəglaghatá tsi ta tvi nda ta haɗika Mekaduniya. ");
INSERT INTO xed_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ka sliʼaftá i Supater zwaŋa Pirhus mnda luwa Beriya, nda Aristarkus nda Sekundus mnda la Tesalunik, nda Gayus mnda luwa Derba, nda Timute, nda Tisik, nda Trufim mnduha haɗika Asiya, mistani. ");
INSERT INTO xed_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ka laghu tsahaya ta kəma kzla aŋni ma luwa Truwas. ");
INSERT INTO xed_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Aŋni ya, ka lamə ŋni da kwambalu ma luwa Filipiya, tahula zutá skala buradi kul haɗ is mida ya. Ta mahutafa fitik, ka lagha ŋni slanaghatá həŋ ma luwa Truwas, ka zatá ŋni ta luma hada. ");
INSERT INTO xed_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Gahawu baɗu luma gwasi, ka tskavatá ŋni ŋa za skwa zaya Mgham Yesu, ka zlraftá Pwal ta gwaɗa ta kəma gwal zlghay nda ŋuɗuf, ka nzɗavatá tsi ta gwaɗa ha ka lami da takala, kabga dzaʼa nda sliʼa tsaɗakwər vli. ");
INSERT INTO xed_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ma dzuguvi ma həga ta ghəŋa həga tskavata ŋni. Mamu ndəghata pitirlaha ma tsa dzuguvi ta ghəŋa həga tskava ŋni ya. ");
INSERT INTO xed_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tsaw mamu sana zwaŋ ta hgu lu ka Fewtikus ta nzuŋta tawa finitir. Ka dziŋtá hani ma tsa nzɗavata Pwal ta mna gwaɗa ya. Na tsa ghərɓanafta hani ya, ka dəɗagatá tsi ta tsa mahkəna həga ta ghəŋa həga ya ta haɗik. Kəʼa ka lu ka sliʼay ná, nda mta. ");
INSERT INTO xed_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ka saha Pwal, ka ndadaghata tsukwafta. «Ma tɗ ŋuɗufa ghuni, ta tekeʼa hafu mida,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ka vradaftá Pwal ka ɓlaʼatá tsi ta buradi ka zay. Ka kɗə tsi ta gwaɗa petsuweɗ vli. Tahula tsa, ka sliʼaftá tsi ka laghwi. ");
INSERT INTO xed_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nda hafu ma tsa galaɓay ya ta klaghatá lu dzagha. Ka rfu həŋ ta rfu katakata. ");
INSERT INTO xed_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ka sliʼaftá ŋni ka laghwi ta kəma ta kəma da ŋlaftá kwambalu ŋa kla aŋni da luwa Asus. Ŋa dzaʼa ŋni kla Pwal hada, kabga ta dzaʼa nda səla iʼi, kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Manda laghani slaŋnaghatá ma Asus, ka klamtá ŋni da kwambalu, ka laghu ŋni da luwa Miteleŋ. ");
INSERT INTO xed_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ka sliʼaftá ŋni hada nda kwambalu, ka ɓhadaghatá ŋni gamahtsimani mbəŋ nda luwa Kiyus. Gamahtsimani, ka ɓhadaghatá ŋni da luwa Samus, gamahtsima tsaya guli, ka ɓhadaghatá ŋni da luwa Miletus. ");
INSERT INTO xed_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ka Pwal mnuta na: «Haɗ yu dzaʼa sladavata ma luwa Afisus wu, da zutá lu ta fitik ma haɗika Asiya, ka má ta magaku tsi katsi ná, misimmisim ta kuma yu ta ɓhadaghata da Ursalima, ka ma kɗə fitika skala Pentakwat ka sagha a tsi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ma tsa Miletus ya tama, ka ghunaftá Pwal ta mnduha da Afisus ŋa hgaktá gwal ngha Igliz. ");
INSERT INTO xed_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Manda ɓhadaghata taŋ da slanaghata, ka Pwal nda həŋ mantsa: «Daga baɗu lagha ɗa ta haɗika Asiya ná, nda sna kuni ka yu nzata kawadaga nda kaghuni. ");
INSERT INTO xed_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nda leɓtekwa ta ghəŋ mataba ghuya ɗaŋwa da sanlaha ma la Yahuda ta pghihatá buɗukwa, ksanata yu ta slna ta Mgham Yesu. ");
INSERT INTO xed_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nda sna kuni guli kazlay: Haɗ sana skwi prək ka katá kaghuni ɗifaghuna yu wu kəʼa. Mnaghunamna yu ta indani, ka taghaghunafta baŋluwa nda ya dzagha dzagha. ");
INSERT INTO xed_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ka gvalaŋtá yu ta la Yahuda nda la Grek, ŋa mbəɗavata tvə Lazglafta ŋa zlghafta taŋ ta Mghama mu Yesu Kristi. ");
INSERT INTO xed_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ndanana, nda sliʼa yu da Ursalima. Sulkum nda ghuɓa ta tiŋwa iʼi ŋa dzaʼa. Sna a yu ta skwi dzaʼa sliɗighata hada wa. ");
INSERT INTO xed_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Skwi ya ta mniɗiŋta Sulkum nda ghuɓa kweŋkweŋ ná, dzaʼa slaɗighasla ghuya ɗaŋwa, dzaʼa vzidimvza lu da gamak. ");
INSERT INTO xed_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Iʼi ná, ndana a yu ta gwaɗa ta hafa ɗa, dər má kinawu ɗinutani ka ŋa ɗa wa. Dzaʼa kɗanaktá tsa ŋərma slna vliha Mgham Yesu ŋa magay, ta nzakway ka mna Lfiɗa Gwaɗa ta ghəŋa zɗakatahuɗa Lazglafta ya skwi ta zɗəgihata. ");
INSERT INTO xed_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ndanana ná, nda sna yu kazlay: Nghəglaŋta a inda na kaghuni raghunaf yu, ka mnaghunatá gwaɗa ta ga mghama Lazglafta ná, ta həga kuma ɗa ɗekɗek wa. ");
INSERT INTO xed_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tsaya ta kəl yu ka mnaghunata dar gita kazlay: Magaghunamaga yu ta inda skwi ya laviŋ yu ta magay nda inda kɗavakta mbrakwa ɗa. Ka dzaʼa zluŋzla kuni ta skwi ya taghaghunaf yu, ta haɗ iʼi mida wu, ");
INSERT INTO xed_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kabga mnaghunamna yu ta inda skwi mna Lazglafta, haɗ ya ɗifanaghu yu wa. ");
INSERT INTO xed_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nghawangha ta ghəŋa ghuni, nghawa ta inda bra ya vlaghuna Sulkum nda ghuɓa ŋa nghay guli. Nghawangha ta Igliza Lazglafta ya mutsanak tsi ta ghəŋani nda usa zwaŋani. ");
INSERT INTO xed_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tahula laghwa ɗa ná, nda sna yu kazlay: Dzaʼa sliʼadamsliʼa mnduha ta sidi manda mandundiha da taba ghuni, haɗ həŋ dzaʼa zlaŋtá tsa bra ya wu kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dər mataba kaghuni guli ná, dzaʼa sliʼafsliʼa sanlaha da tsakalawi, ŋa baraghata taŋ ta sanlaha ma duhwalha mista taŋ. ");
INSERT INTO xed_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ka nzata kuni hzleŋa. Havapwahava kazlay: Hkən vakwa ɗa ta ŋavata nda ima taw ta iri, nda rviɗik tani, nda fitik tani, ta vla hiɗaku ŋa inda kaghuni kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ndana tama, ma dzva Lazglafta nda gwaɗa ta zɗakatahuɗani tani ta famta yu ta kaghuni. Tsa gwaɗa ya dzaʼa ŋla kaghuni, ŋa zay ghuni ta həga kawadaga nda inda gwal nda ghuɓa. ");
INSERT INTO xed_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ma nzakwa ɗa ná, gvalaŋ a yu ta dər tseda mndu, dər dzindara mndu, dər lguta mndu wa. ");
INSERT INTO xed_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nda sna vərɗa kaghuni kazlay: Nda dzva ɗa si ta maga yu ta slna ŋa kata ghəŋa ɗa, nda ya ŋa kata gwal ta dzaʼa mista ɗa tani kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Inda tsa slnaha magə yu mantsa ya ná, ŋa maraghunata kazlay: Mantsa ya ta maga lu ta slna ŋa kataŋtá gwal ka pɗu kəʼa. Ŋa havaghunakta guli ta gwaɗa Mgham Yesu ta mnay kazlay: Mal mndu ta vlay ta rfu, ka mndu ta zlghay kəʼa ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ta kɗaku Pwal ta mna tsa gwaɗa ya, ka tsəlɓata tsi ka maga duʼa nda hahəŋ tani demdem. ");
INSERT INTO xed_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Rəɓ həŋ demdem nda taw, ka lagha tekweseʼ ta Pwal. ");
INSERT INTO xed_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tsa mnayni kazlay: Nghəglaŋta a kuni ta həga kuma ɗa wu kəʼa ya na skwi ta ganaftá taw ta həŋ. Ka sliʼaftá həŋ ka pghaghatá Pwal da vla kwambalu. ");
INSERT INTO xed_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tahula dgata ŋni ta vgha nda həŋ, ka lamə ŋni da kwambalu. Ka sliʼafta ŋni ka laghwi tur da luwa Kus. Gamahtsimani, ka sliʼafta ŋni ka laghwi da luwa Rudes. Ka gi sliʼafta ŋni hada guli ka laghwi da luwa Patara. ");
INSERT INTO xed_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hada, ka slafta ŋni ta sana kwambalu ta sliʼi da luwa Finisi, ka lamə ŋni dida, ka laghu ŋni. ");
INSERT INTO xed_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nghay ŋni ta luwa Kiprus manda a, haɗik ya ta tsavata ma drəf, ka zluŋtá ŋni nda ga zlaɓa ŋni ka laghu ŋni nda tvə haɗika Siri. Ka ɓhadaghatá ŋni da luwa Tir ma vla pghay kwambalu ta huzla. ");
INSERT INTO xed_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Hada, ka slanaghatá ŋni ta gwal zlghay nda ŋuɗuf, ka zata ŋni ta fitik ndəfáŋ da həŋ. «Ma laf ka da luwa Ursalima,» ka həŋ nda Pwal, manda kɗakwa Sulkum nda ghuɓa ta mnanaŋtá həŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ma kɗavakta tsa mandəfáŋa fitik ya, ka sliʼafta ŋni ka sliʼi. Ka pghafta həŋ demdem ta aŋni, nda miʼa taŋ, nda zwana taŋ tani, ha ka zluŋtá huɗa luwa. Ɓhadaghata ŋni ta wa ghwa, ka tsəlɓata ŋni, ka magatá duʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Manda dgata ŋni ta vgha nda həŋ, ka ŋlaftá aŋni ta kwambalu, ta vraghuta hahəŋ dzagha taŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ka kɗiŋtá ŋni ta mbaɗa ŋni nda kwambalu. Sliʼafta ma luwa Tir ka ɓhadaghata da luwa Tulemayis. Hada, ka guguvta ŋni ta zgu nda zwanama. Ka zata ŋni ta fitik turtuk kawadaga nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ka sliʼafta ŋni gamahtsimani ka dzaʼa, ka ɓhadaghata ŋni da luwa Sezare. Ka sliʼafta ŋni guli ka lagha da Filip ta hgə lu ka mnda mna gwaɗa Lazglafta, ta nzakway ka mndu ya tekw mataba tsa gwal ndəfáŋ ya kay. Ka lamə ŋni da həga ga taŋ ka hanay ga taŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mamu kwaghani fwaɗ ka daghali ka daghali ta klaktá lwa Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nda za fitika ŋni ŋulum hada tama, ka sliʼaftá sana anabi ta hgə lu ka Agabus daga ta haɗika Zudiya, ");
INSERT INTO xed_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ka sagha da slaŋnaghata. Ka klaftá tsi ta ɓanava Pwal, ka habanatá tsi ta səlahani nda dzvuhani. Kaʼa mantsa: «Wya skwi mna Sulkum nda ghuɓa: Ka ŋa wa nana ɓanava na ná, manda va yeya dzaʼa habafta la Yahuda ta tsa mndu ya ma Ursalima, ŋa klafta taŋ ka fanamta gwal kul nzakway ka la Yahuda ma dzva taŋ,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Na snaŋta ŋni ta tsa gwaɗa ya, nda aŋni tani, nda gwal ma tsa vli ya tani, ka ndəɓə ŋni ta dzvu ŋa Pwal ŋa kwalani kul lafi da Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ka Pwal nda aŋni mantsa: «Ta ghəŋa wu ta tawa kuni ta taw. Ta kumay kuni ta giɗiftá zləŋ ra? Iʼi ta ɗa ná, ŋa habaftá iʼi yeya a wu, dər má ŋa dza ta iʼi ma Ursalima ta ghəŋa hga Mgham Yesu tsi, nda fa vgha ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Na tsa trapta ŋni mida ya ná, ŋəvglaŋ a aŋni guli wa. «Ka maga Mgham Yesu ta skwi ya kumaŋ tsi,» ka aŋni ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tahula luta tsa fitik ya tama, ka hbaftá ŋni ta vgha, ka ŋlaghatá da luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ka sliʼaftá sanlaha ma gwal zlghay nda ŋuɗuf ma luwa Sezare guli mista ŋni. Ka pghadaghata həŋ ta aŋni da vli ya dzaʼa hani ŋni ta hani ga sana mndu ta hgə lu ka Menasuŋ, mnda sana luwa ta tsavata ma drəf, ta hgə lu ka Kiprus. Nda kɗa fitika tsa mndu ya ma zlghay nda ŋuɗuf. ");
INSERT INTO xed_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ɓhadaghata ŋni da Ursalima, ka tsuʼafta zwanama ta aŋni nda rfu. ");
INSERT INTO xed_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ga mahtsimani, ka sliʼaftá Pwal kawadaga nda aŋni ka lagha da Yakubu. Ka lagha gwal Igliz tskavata demdem hada. ");
INSERT INTO xed_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Tahula ganaghata Pwal ta zgu ta həŋ, ka rusu tsi turtuk turtuk ta skwi maga Lazglafta mataba gwal kul nzakway ka la Yahuda nda ma slnani. ");
INSERT INTO xed_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Snanata taŋ ta tsa skwi rusanaf Pwal ta həŋ ya, ka zləzlvu həŋ ta Lazglafta. Ka həŋ nda tsi mantsa: «Zwaŋama, nda ngha ka ta dəmbuʼ a ta la Yahuda ta zlghafta ya kiʼe, ta ŋavaŋa həŋ ka sna zlaha Musa. ");
INSERT INTO xed_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ka lu nda həŋ nda gwaɗa ta kagha ná, ma snə kuni ta zlaha Musa, ma ɗatsə kuni ta fafaɗa zwana ghuni, ma taghə kuni ta nzakwa la Yahuda, ká ka ta taghay ŋa inda la Yahuda ta nzaku ma səla hamata sanlaha ma mnduha, ka lu ta mnay. ");
INSERT INTO xed_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Waka lu dzaʼa magay? Ya wya dzaʼa nda sna həŋ kahwathwata kazlay: Hadna ka kəʼa, dzaʼa sliʼagaghasliʼa həŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ka si mantsa tsi, ka maga ka ta na skwi dzaʼa ŋni mnaghata na. Mamu sana mnduha fwaɗ mataba mu ta waɗana ta waɗu ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Hla ta həŋ ka dzaʼa ka da tsalapta ghəŋa gha kawadaga nda həŋ. Ka plata ka ta skwi ma dzaʼa hahəŋ da play. Tahula tsa, ŋa htsiŋta taŋ ta ghəŋa taŋ. Ka magamaga lu mantsa katsi, dzaʼa nda sna inda mnduha kazlay, tsa skwi ta snə mu ta mnay ta Pwal ya kay ná, tsakala wi ya kəʼa. Ma tsaya dzaʼa kəl lu ka snaŋta kazlay: Ta snay kagha ta zlahu guli kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ŋa gwal kul haɗ ka la Yahuda ya, tsiŋtsa mu ta ghəŋani ka vindanafta mu ta həŋ kazlay: Yaha həŋ da za sluʼa skwa wuyay, yaha həŋ da za us, yaha həŋ da za skwi ɓərta lu nda ɓərta, yaha həŋ da maga sliʼiŋsliʼiŋ kəʼa,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Mantsa tama, ka sliʼafta Pwal kawadaga nda tsa mnduha fwaɗ ya ka tsalapta tsi ta ghəŋani. Gamahtsimani, ka lamə tsi da həga Lazglafta, ŋa mnata fitika dzata ghəŋa tsa tsalatá ghəŋ, nda vlata skwa pla ghəŋ dzaʼa vlə lu ta həŋ ta həŋ ya. ");
INSERT INTO xed_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Baɗu kɗavakta tsa mandəfáŋa fitik ya, ka nghaŋtá la Yahuda ta sagha ta haɗika Asiya ta Pwal ma həga Lazglafta. Ka gagaftá həŋ ta dəmga, ka ksafta həŋ ta Pwal. ");
INSERT INTO xed_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ka dzata həŋ ta lawlaw: «Ari mnduha la Israʼila! Kudiɗwa! Ya wana tsa mndu ta ra inda vli ka raraza mnduha mu, nda zlaha Musa, nda na həga Lazglafta na tani ya kay. Laghani guli ná, ka hladamtá la Grek da na həga Lazglafta na, ka ŋriŋtá na vli nda ghuɓa na,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Tsaw si nghiŋngha həŋ ta sana mndu ta hgə lu ka Trufim, mnda la Afisus kawadaga nda tsi ma luwa. Zlah si kladamkla Pwal ta tsa mndu ya da həga Lazglafta ka həŋ si ta gray. ");
INSERT INTO xed_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kɗukuts sliʼavafsliʼa vli ma luwa, ka gazladaghatá mnduha ma inda vli. Ka ksaftá həŋ ta Pwal ma həga Lazglafta, ka ksigiŋta dzibil, ka gi hahuŋtá tghaha. ");
INSERT INTO xed_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ta naghay naghay həŋ ta tva dzatá Pwal ta lagha lu da mnay ŋa mghama sludzi kazlay: ya nda ɓadza vli ma luwa Ursalima kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ka gi hlaftá tsi ta sludziha nda maliha ta ghəŋa la sludziha, ka sliʼafta həŋ ka ndadaghata slanaghata həŋ. Nghay taŋ ta mghama la sludzi nda la sludzi tani, ka gi zlaŋta həŋ ta dza Pwal. ");
INSERT INTO xed_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ka gavadaghatá mghama la sludzi ka ŋanatá Pwal, ka tsatsanaftá ziɗaha his. «Wa va kagha, nahgani maga ka?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ka nu ŋa ya ta gwaɗay, ka nu ŋa ya ta gwaɗay, ka tsa tskata ghəŋa mnduha ya. Triɗ, trap ta mghama sludzi ta ksaftá ghəŋa gwaɗa, kaʼa mantsa: «Klawakla ta na Pwal na da vla nzakwa la sludzi,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ndusadaghata Pwal tavata dzatá tva ŋlu da həga, ka gi tsukwaghatá la sludzi, kabga nda ga sida mnduha. ");
INSERT INTO xed_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","«Dzata! Dzata, dzata!» ka tsa ŋəɗdəma ta mnduha ta mbaɗa mistani ya, ka dzaʼa nda hla wi. ");
INSERT INTO xed_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ta ghwaŋ a lu ka kladamta Pwal da vla nzakwa la sludzi tama wu, «dzaʼa tsuʼay ka, ka mnaghaŋta yu ta gwaɗa ɗa ra?» Ka Pwal nda tsa mghama sludzi ya. «Nda sna ka ta gwaɗa la Grek ra? ");
INSERT INTO xed_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ka gha a na mnda la Masar ta sliʼanaftá zlərɗawi ka ma taŋ, ka hlaghatá gəndaha dəmbuʼ fwaɗ da mtak ya wu ra?» kaʼa nda Pwal. ");
INSERT INTO xed_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ka Pwal mantsa: «Mnda la Yahuda iʼi, ya lu ma luwa Tarsus ta haɗika Silisi, zwaŋa sana luwa ta klu lu ya yu. Kdəkkdək, vlihavla ta tvi ka gwaɗganata yu ta mnduha,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ka vlaŋtá tsa mghama la sludzi ya ta tvi. Ka sladatá Pwal ta tsa dzatá tva dzaʼa da həga ya. Ma hlə kuni ta wi, kaʼa nda dzvu nda mnduha. Sriw, nzanza mnduha. Ka zlraftá Pwal ta gwaɗa nda həŋ nda gwaɗa Hebru. ");
INSERT INTO xed_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Zwanama nda dadaha, snawasna ka mnaghunata yu ndanana ta skwi ta magaku, ŋa waɗaptá ghəŋa ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Na tsa snay taŋ ta zlraftani ta gwaɗa nda gwaɗa Hebru ya, ka sganaghata həŋ ta nzata sriw. Ka Pwal mantsa: ");
INSERT INTO xed_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Iʼi ná, la Yahuda yu, ya ma luwa Tarsus ta haɗika Silisi lu ta iʼi, ama ma na luwa na glafta yu. Gamaliyel ta dzaŋaɗiftá ta dzaŋa, ka taghaɗifta snaŋtá zlaha dzidzíha mu nda tvani manda ya ta raku. Ŋavaŋa iʼi guli ka sna ŋa Lazglafta manda va na ta magə kaghuni demdem gita na. ");
INSERT INTO xed_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ganap ga yu ta iri ta gwal ta ksa na tvi na ha ka pslatá həŋ. Hahabaf hahaba yu ta zgwana nda miʼaha tani ka pghamtá həŋ da gamak. ");
INSERT INTO xed_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Masləmtsəka ɗa na la mali ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda la galata mndu na guli. Da hahəŋ zlghafta yu ta ɗelewer ŋa klaŋtá zwanama mu la Yahuda ma luwa Damas, ŋa dzaʼa ɗa kasa gwal zlghay nda ŋuɗuf ma tsa luwa ya, ŋa hlaktá həŋ da luwa Ursalima, ŋa tsanaghata guma ta həŋ.» ");
INSERT INTO xed_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Tata mbaɗa yu ta tvi, wur ma ghəŋ fitik, ndusa yu nda luwa Damas tama, ka saha tsuwaɗak katakata daga ta luwa ka tsuwaɗakanaftá vli ta wiɗifta. ");
INSERT INTO xed_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ka zləmbadata yu ta haɗik. “Sawulu! Sawulu! Kabgawu ta kəl ka ka giri ŋa ɗa na?” ka sana lwi nda iʼi ta snə yu. ");
INSERT INTO xed_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Wa kagha ní Mghama ɗa!” ka yu nda tsi. “Iʼi Yesu mnda la Nazaret, ta gə ka ta iri ŋani ya yu,” kaʼa nda iʼi. ");
INSERT INTO xed_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nda ngha gwal kawadaga nda iʼi ta tsa tsuwaɗak ya, ama sna a hahəŋ ta lwa tsa mndu ta gwaɗa nda iʼi ya wa. ");
INSERT INTO xed_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Nu skwi ŋa magay ɗa ní Mghama ɗa?” ka yu nda tsi. “Sliʼafsliʼa, la da tsa luwa Damas ya, dzaʼa mnagha mna lu ta inda skwi ŋa magay gha hada,” ka Mgham Yesu nda iʼi. ");
INSERT INTO xed_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ghulpiɗghulpa wuɗakwa tsa tsuwaɗak ya kay, nghəgla a yu ta vli wa. Ka ksə tsa gwal kawadaga nda iʼi ya ta iʼi ta dzvu, ka ɓhidiɗighata da luwa Damas. ");
INSERT INTO xed_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Hada, mamu sana mndu ta hgə lu ka Hananiya. Ta zləŋay ta Lazglafta, ta snay guli ta zlaha Musa. Ta ghubay inda mnduha la Yahuda ma tsa luwa Damas ya. ");
INSERT INTO xed_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ka sagha tsi sliɗighata, kaʼa nda iʼi mantsa: “Zwaŋama ɗa Sawulu, nghəglaŋngha ta vli,” kaʼa. Gi hadahada, gi ka gwanatá iriha ɗa, ka nghaŋtá yu ta vli. ");
INSERT INTO xed_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ka Hananiya nda iʼi guli mantsa: “Zbuzba Lazglafta dzidzíha mu ta kagha daga ghalya ŋa snaŋtá skwi ta kumə tsi, ŋa nghaŋta gha ta tsa tɗukwa mndu ya, ŋa snaŋta gha ta gwaɗa vərɗa tsatsi nda wani. ");
INSERT INTO xed_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kagha dzaʼa nzakway ka masləmtsəkani da inda mnduha ta ghəŋa skwiha ya snaŋ ka da tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ndanana, haɗ sana skwi ŋa kzləgəlta gha wa. Sliʼafsliʼa, sawi ka magaghafta lu ta batem, ka ghuɓata dmakwa gha nda ma hgaŋta gha ta Mgham Yesu,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Tahula tsa, ka vraghutá yu da Ursalima. Ma sana fitik ta maga duʼa yu ma həga Lazglafta, ka mariɗiŋtá Mgham Yesu ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Na tsa nghaŋta ɗa ya, kaʼa nda iʼi mantsa: “Sliʼapsliʼa misimmisim ma luwa Ursalima, kabga tsuʼafta a həŋ ta skwi dzaʼa ka mnay ta iʼi wu,” kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Mghama ɗa, nda sna vərɗa hahəŋ kazlay: Si ta ray yu ta həga tagha skwa la Yahuda ka hla gwal ta zlghaftá kagha, ka hla həŋ da gamak, ka sləva həŋ nda krupi kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ta dzatá lu ta Atiyen ta nzakway ka masləmtsəka gha ya ná, hada vərɗa iʼi. Zɗigihazɗa tsa dzata dza həŋ ya. Iʼi ta ŋanatá lguta tsa gwal ta dzata ya,” ka yu nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Sliʼafsliʼa, la! Ta ghunə da vli diʼiŋ yu ta kagha da gwal kul nzakway ka la Yahuda,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ka fata həŋ ta sləməŋ ka sna gwaɗa ta gwaɗagapta Pwal ha ka mnagaptani ta tsa gwaɗaha ya. Na gi snaŋta taŋ ta tsa gwaɗaha ya, «zaɗiŋtá mndərga nana ma mndu ta ghəŋa haɗik, dzawa dza! Ra a ka zlaŋta nda hafu wu!» ka həŋ hlaftá wi. ");
INSERT INTO xed_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ka kwahu həŋ ta wi ka vaza lguta taŋ nda ta luwa, ka tsaɗa haɗik nda ta luwa. ");
INSERT INTO xed_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tsaya kəl mghama sludzi ka mnay kazlay: Klaghawakla ta Pwal da həga, ka ɗawanapta kuni ta vli nda sləvu, kada snaŋta lu ta skwi ta kəl na mnduha na ka hla wi mandana na ta ghəŋani na, kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Manda habafta lu ŋa sləvay tama, ka Pwal nda mali ta ghəŋa la sludzi ta sladu hada mantsa: «Vlaghunavla lu ta tvi ŋa sləva mnda la Ruma nda krupi ta kul tsanaghata lu ta guma katək ra?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Snaŋta tsa la mali ta ghəŋa la sludzi ya ta tsa gwaɗa ya, ka sliʼafta tsi ka laghwi da mnanata mghama taŋ. «Waka ka dzaʼa magay? Nana mndu na ná, mnda la Ruma ya,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ka gi sliʼaftá tsa mghama la sludzi ya ka lami slanaghatá Pwal. «Mnihamna, mnda la Ruma ka kahwathwata ra?» kaʼa nda tsi. «Aŋi!» ka Pwal nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","«Iʼi ná, nda tsedi dagala skwata yu ta nzakwa ɗa, kada nzata yu ka mnda la Ruma,» ka tsa mghama la sludzi ya nda tsi. «Iʼi na, ka mnda la Ruma yata lu ta iʼi ɓuzul,» ka Pwal nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Damkwal vraghuvra tsa gwal si dzaʼa sləva Pwal ya nda hul, ŋa sagha nda sa ɗawanaptá vli. Na tsa snaŋta tsa mghama la sludzi ya kazlay: Mnda la Ruma Pwal kəʼa ya, ka ksuta tsa habafta habaf tsi ya ka zləŋ. ");
INSERT INTO xed_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Gamahtsimani, ka zbə tsa mghama la sludzi ya ta vərɗaka skwi kəl la Yahuda ka ksaftá Pwal. Ka paliŋtá tsi ta tsa habafta habaf tsi ta Pwal ya. Ka hagaktá tsi ta la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda gwal ta tsa guma, ŋa tskavata. Ka kladaghata tsi ta Pwal ka sladanata ta kəma taŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ka vazlanamtá Pwal ta iri ta gwal tsa guma. Kaʼa mantsa: «Zwanama ɗa, haɗ sana skwi dəmanaf yu ta Lazglafta ha gita wa. Haɗ sana skwi guli ŋa tsaɗivata wu,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","«Dzuŋwadza ta wubisim,» ka mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta nzakway ka Hananiya ya, nda gwal ndusa nda Pwal. ");
INSERT INTO xed_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","«Dzaʼa dzay Lazglafta ta kagha ghwaɗaka vata həga ɓap lu nda ɓa na. Nza ŋa tsa guma ta ghəŋa iʼi manda ya ta mnə zlahu kagha, ama ka zluŋtá ka ta zlahu, ka laghwi da mnay kazlay: Dzuŋwa dza kəʼa,» ka Pwal nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","«Waka ka ta raza mali ta ghəŋa gwal dra skwi ta nzakway ka mnda Lazglafta na?» ka tsa gwal ndusa nda tsi ya. ");
INSERT INTO xed_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","«Sna a yu kazlay: Mali ta ghəŋa gwal dra skwi ŋa Lazglafta ya kəʼa zwanama wu, kabga nda vinda guli kazlay: Haɗu ka dzaʼa raza mgham ta ghəŋa mnduha gha wu kəʼa,» ka Pwal. ");
INSERT INTO xed_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tsaw nda sna kazlay: Nana gwal tsa guma na ná, laɓatani nda la Sadukiya, nda la Farisa ya kəʼa, kəl tsi ka gwaɗata nda lwi dagala dagala. Kaʼa mantsa: «Zwanama ɗa, iʼi ná, mnda la Farisa iʼi, zwaŋa mnda la Farisa yu guli. Ta ghəŋa fafta ɗa ta ghəŋa ɗa, nda ya ta ghəŋa sliʼagapta dzaʼa sliʼagapta gwal nda rwa ma mtaku, ta kəl lu ka tsa guma ta ghəŋ iʼi,» ka Pwal. ");
INSERT INTO xed_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Na tsa mnatani ta tsaya, ka zlraftá zlərɗutawi mataba la Farisa nda la Sadukiya. Ka dgavaptá tsa tskata vgha ya his. ");
INSERT INTO xed_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Haɗ gwal nda rwa dzaʼa walaŋta sliʼagapta wu, haɗ duhwalha Lazglafta wu, haɗ Sulkum guli wu, ka la Sadukiya nda ŋa taŋ. Mamu tsahaya demdem, ka la Farisa nda ŋa taŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ka sliʼaftá inda mnduha nda guguɗaku. Ka sliʼavata sanlaha mataba gwal ta tagha zlahu ŋa mnduha ta nzakway mataba la Farisa gwaɗata nda lwi dagala dagala: «Mutsaf a aŋni ta sana ghwaɗaka skwi maga na mndu na wa. Ka sana Sulkum tsi, ka sana duhwala Lazglafta tsi, ka kitsi ta gwaɗganata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ka sgavaghata zlərɗuta wi katakata. Duŋwa həŋ da ɗatsanaptá Pwal na! ka mghama sludzi zləŋaftá zləŋ kəl tsi ka ghunaftá la sludzi ŋa klaptá Pwal mataba taŋ, ka klaghata da həga la sludzi. ");
INSERT INTO xed_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Girviɗikani, ka Mgham Yesu maravata da Pwal mantsa: «Tatá us ta iri! Manda va tsa ga masləmtsək gə ka ta ghəŋa iʼi ma luwa Ursalima ya ná, manda va tsaya guli dzaʼa ga ka ta tsa masləmtsək ya ma luwa Ruma,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Gamahtsimani, ka dzraftá sanlaha ma la Yahuda ta wi ŋa dzaʼa dzatá Pwal. Ka waɗatá həŋ ka mnay kazlay: Haɗ mu dzaʼa zaŋtá skwi nda za, nda saŋtá skwi nda sa, ka ta dza a mu ta Pwal wu, ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ta malay gwal ta dzraftá tsa wi ya ta fwaɗ mbsak. ");
INSERT INTO xed_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ka sliʼaftá həŋ ka laghwi da slanaghatá la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la galata mndu. Ka həŋ mantsa: «Waɗawaɗa ŋni kahwathwata ta kəma Lazglafta kazlay: Haɗ ŋni dzaʼa walaŋta zaŋtá skwi nda za, ka ta dza a ŋni ta Pwal wu. ");
INSERT INTO xed_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ndanana tama, gwafwagwa kaghuni ta wi nda gwal ta tsa guma. Ta kumay ŋni ta ɗagapta hya ma na gwaɗa na kahwathwata, ka kuni dazlay nda mghama sludzi ya ná, ŋa klaghunakta lu ta Pwal ta kəma ghuni. Ta sagha tsi ya, nda paya vgha aŋni ŋa gi dzata,» ka həŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Snaŋta zwaŋa mukumani ma Pwal ta tsa pghanatá buɗukwa dzaʼa pghanata lu ta Pwal ya, ka sliʼaftá tsi ka laghwi mnanatá Pwal ma həga la sludzi. ");
INSERT INTO xed_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ka hgaftá Pwal ta sana mali ma la sludzi. «Kla ta na duhwal na da mghama la sludzi, ya mamu gwaɗa dzaʼa mnanata tsi,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ka klaftá tsa mali ta ghəŋa la sludzi ya ta tsa duhwal ya, ka klaghata da tsa mghama la sludzi ya. Kaʼa mantsa: «Tsa Pwal tsam lu ma gamak ya ta hgaftá iʼi. Kdəkkdək, kla ta na duhwal na da tsi, mamu gwaɗa dzaʼa tsi mnanata, kaʼa nda iʼi, kəl yu ka klakta,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ka ksaftá tsa mghama sludzi ya ta tsa duhwal ya ta dzvu, ka laghwi ta slərpa vli. «Nu ta kumə ka ta mnihata na?» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kaʼa nda tsi mantsa: «Dzrafdzra sanlaha ma la Yahuda ta sagha da ndəɓaghatá dzvu, ŋa kladaghatá Pwal ta kəma gwal ta tsa guma mahtsim. Ta kumay ŋni ta ɗagapta hya ma tsa gwaɗa ya kahwathwata ka həŋ dzaʼazlay nda kagha. Tsaw mantsa ya nzakwani wa. ");
INSERT INTO xed_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yaha ka da snana ta həŋ. Ya mamu gwal ta malay ta fwaɗ mbsak dzaʼa pghatá buɗukwa. Waɗa nda waɗa həŋ kazlay: Haɗ ŋni dzaʼa walaŋta zaŋtá skwi nda za, haɗ ŋni dzaʼa saŋtá skwi nda sa, ka ta dza a ŋni ta Pwal wu kəʼa. Ndanana, nda paya vgha taŋ, ya gwaɗa da kagha kweŋkweŋ ta kzlə həŋ,» kaʼa nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ka tsa mghama sludzi ya mantsa: «Nana gwaɗa mniɗiŋ ka na ná, yaha ka walaŋta mnanaŋta sana mndu,» kaʼa, ka ghuniŋtá tsa duhwal ya. ");
INSERT INTO xed_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tahula tsa, ka hagaftá mghama la sludzi ta maliha his ta ghəŋa sludziha. Kaʼa nda həŋ mantsa: «Hbawa vgha, dzaʼa nda sliʼa kuni da luwa Sezare ta nzemndi təmbay girviɗik, kawadaga nda sludziha his dərmək, nda sludziha ndəfáŋ mbsak ta ŋla plis, nda sludziha his dərmək nda huzla vulu da həŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mutsaf kuni guli ta plis ŋa kla Pwal, ŋa ɓhadanaghata ɗughwana da ŋumna ta nzakway ka Feliks,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Wya ka tsa mghama sludzi ya vindanaftá ɗelewer guli: ");
INSERT INTO xed_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Iʼi Klawdi Lisiyas, ta ga zgu ŋa mghamani ŋumna ta nzakway ka Feliks. ");
INSERT INTO xed_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ya mndu ta ghunədaghapta yu ya ná, la Yahuda ta ksafta ka dzaʼa dzata. Ka lagha yu nda la sludza ɗa ka zluʼagapta ma dzva taŋ snaŋər yu kazlay: Mnda la Ruma ya kəʼa. ");
INSERT INTO xed_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ŋa zba snaŋtá ghəŋa skwi ya kəl həŋ ka razay ná, ka kladaghatá yu ta kəma gwal ta tsanatá guma ta həŋ. ");
INSERT INTO xed_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ka slanaghatá yu ná, ta razu ta ghəŋ skwi ta ksaŋtá zlaha taŋ həŋ. Ama haɗ skwi ga tsi prək ka dzata, dər prək ka hbamta ma gamak wa. ");
INSERT INTO xed_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ka sagha lu snaɗimta kazlay: Ta pgha buɗukwa həŋ ŋani kəʼa, kəl yu ka ghunədaghapta tsa mndu ya ŋa lagha hahəŋ ka ghəŋa taŋ da mna dmakuha ya maga tsa mndu ya ta kəma gha. Ləŋləŋ ká ka nzata mghama ɗa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ka klaftá tsa la sludzi ya ta Pwal girviɗik manda va ya mnanaf lu ta həŋ, ka klaghata da luwa Aŋtipatris. ");
INSERT INTO xed_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Gamahtsimani, ka vragaghutá hamata la sludzi da vla nzakwa taŋ, ka kɗə gwal nda plis nda plis ta kla Pwal da luwa Kaysariya. ");
INSERT INTO xed_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ɓhadaghata tsa la sludziha ta plis ya da luwa Sezare, ka klaftá həŋ ta tsa ɗelewer ya ka vlaŋtá ŋumna, zlanaŋha həŋ guli ta Pwal ma dzvani. ");
INSERT INTO xed_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Tahula dzaŋaftá ŋumna ta tsa ɗelewer ya, kaʼa mantsa: «Ta wati haɗik kagha na?» kaʼa ɗawaŋta da Pwal. Snaŋtani kazlay: Mnda haɗika Silisi ya kəʼa, ");
INSERT INTO xed_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ŋa sna yu ta gwaɗa gha saghər tsa mnduha ta raza kagha ya,» kaʼa nda tsi. Klaghawakla, ka dzaʼa kuni da nghay ma tsa həga baf Hiridus ya, ka tsa ŋumna ya nda mnduha. ");
INSERT INTO xed_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tahula luta fitik hutaf, ka ɓhadaghatá i mali ta ghəŋa gwal dra skwi ŋa Lazglafta ta nzakway ka Hananiya, nda la galata mndu, nda sana mndu ta hgə lu ka Tertulus ya, nda viɗa ma gwaɗa. Ka lagha həŋ da wlatá Pwal da ŋumna. ");
INSERT INTO xed_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ka hgadaghata lu ta Pwal. Ka zlraftá Tertulus ta rusa skwi ya maga Pwal, kəl həŋ ka wlata. Kaʼa mantsa: «Mghama ɗa, əŋkaʼa ka kagha kəl ŋni ka nzata nda zɗaku. Snaŋta gha ta dzra nzaku kəl mnduha ŋni ka nzakway ɗughwana. ");
INSERT INTO xed_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ta rfay mnduha ŋni dər ndigandiga ta kagha katakata Feliks. ");
INSERT INTO xed_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mghama ɗa! Yaha ŋni da gərɗaghata. Kdəkkdək, kabga zɗakwa gha, faŋna fa ta zləməŋ ka sna ka ta zwaŋa gwaɗa ŋni dzaʼa mnaghata ŋni. ");
INSERT INTO xed_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Nana mndu na ná, ghwaɗaka mndu ya slanagha ŋni ta hwaɗa ghəŋa la Yahuda dər ndigandiga ta ghəŋa haɗik. Tsatsi mghama dina la Nazaret ta nzakway ka gwal ta dzaʼa mista Yesu ya. ");
INSERT INTO xed_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ka kumə tsi ta maga sana skwiha dzaʼa kwal kul vlaŋtá sgit ta həga Lazglafta ŋni, kəl ŋni ka ksafta. Ka kumə ŋni ta tsanaghatá guma manda ya ta mnə zlaha ŋni. ");
INSERT INTO xed_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ama ka lagha mghama la sludzi ta nzakway ka Lisiyas da zluʼaghuta ma dzva ŋni nda mbraku, ");
INSERT INTO xed_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ŋa sagha ŋni da kuma gha da wlata, ka Lisiyas nda aŋni. Ka ɗawaŋɗawa vərɗa kagha da tsi, dzaʼa nda sna ka kazlay: Tsakalawi a na skwi ta mnə ŋni tida na wu kəʼa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","«Manda va tsaya nzakwani,» ka la Yahuda ta ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Manda mnanata ŋumna nda dzvu ta Pwal kazlay: Gwaɗa ta gwaɗa kəʼa. Ka Pwal mantsa: «Nda sna yu kazlay: Gitagita a vakwa kagha ta tsa guma ta ghəŋa mnduha ŋni wu kəʼa. Nda rfu dzaʼa waɗa yu ta ghəŋa ɗa ta kəma gha. ");
INSERT INTO xed_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ka psaŋpsa ka katsi ná, malapə a fitik ghwaŋpɗə his manda lafa ɗa da luwa Ursalima da tsəlɓu ta kəma Lazglafta wa. ");
INSERT INTO xed_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Haɗ mndu ta sliɗighata ta zlərɗawi nda mndu, ta hwazlaɓa ghəŋa mnduha, dər ma həga Lazglafta, dər ma həga tagha skwa la Yahuda, dər ma luwa wa. ");
INSERT INTO xed_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nana skwi mnə hahəŋ ta iʼi ndanana ná, graghafta a vərɗa hahəŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Skwi ya graf iʼi ná, ta maganata slna yu ta Lazglafta dzidzíha ŋni nda ta tsa tvi mnə hahəŋ kazlay: Dina ghwaɗaka tvi ya kəʼa ya. Zlghafzlgha yu ta inda skwi ya nda vinda ma zlaha Musa, nda ya ma deftera la anabi. ");
INSERT INTO xed_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Faffa iʼi guli ta ghəŋ ta Lazglafta manda va ŋa hahəŋ ta mnay kazlay: Dzaʼa sliʼaganapsliʼa Lazglafta ta tɗukwa mnduha nda ghwaɗaka mnduha tani kəʼa ya. ");
INSERT INTO xed_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tsaya ta kəl yu ka ŋavata ka nzaku manda ya ta raku ta kəma Lazglafta nda ya ta kəma mnduha. ");
INSERT INTO xed_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Nda kɗa fitika ɗa manda dgata ɗa ta vgha nda Ursalima, kəl yu ka vradaghata, ka kladanaghata nda tsedi ŋa kataŋtá mnduha ɗa, nda ya ŋa planatá ghəŋ ta Lazglafta. ");
INSERT INTO xed_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tsaya skwi ta magə yu ta slaɗighatá sanlaha ma la Yahuda si ta haɗika Asiya. Kɗakwa ɗa ta tsala ghəŋa ɗa tsa, ta haɗ tskata mnduha hada wu, hwazlaɓanaf a yu ta ghəŋa mnduha guli wa. ");
INSERT INTO xed_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ka má mamu sana skwi gana yu ta həŋ katsi ná, má vərɗa la Yahuda ta haɗika Asiya ta sagha wlatá iʼi da kagha tama. ");
INSERT INTO xed_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ka mantsa a tsi wu, ma mnaŋmna nana mnduha na ta dmaku ya ksaf həŋ ta iʼi nda tsi ma fitika lagha ɗa ta kəma gwal ta tsa guma. ");
INSERT INTO xed_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ta kəma gwal ta tsa guma, gwaɗagwaɗa yu nda mbraku kazlay: Grafgra yu, “dzaʼa sliʼaganapsliʼa Lazglafta ta gwal nda rwa kəʼa. Ta ghəŋa tsaya ta tsa lu ta guma ta ghəŋa ɗa gita,”» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks ná, nda sna tsatsi ta skwiha katakata ta ghəŋa tva Kristi kəl tsi ka dzanamtá wi ta həŋ. Kaʼa mantsa: «Sagha mghama la sludzi ta nzakway ka Lisiyas ya ná, nghay ɗa ta na gwaɗa ghuni na tsa,» kaʼa nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ka mnanata tsi guli ta mali ta ghəŋa la sludzi kazlay: Hamha ta Pwal ma gamak, yaha ka da hbanata nda hba. Ka ta saghasa grahani da kataŋta katsi, yaha da pya həŋ, kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Tsəɓakw fitik tahula tsa, ka sagha Feliks kawadaga nda markwa taŋ Drusil, ta nzakway ka makwa la Yahuda. Ka hgagaptá tsi ta Pwal, ka snə tsi ta gwaɗa ta ghəŋa zlghaftá Yesu Kristi da tsi. ");
INSERT INTO xed_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ka zlraftá Pwal ta zwa gwaɗa ta ghəŋa nzaku ya ta zɗəganatá Lazglafta, nda gwaɗa ta nghuta mndu ta ghəŋani, nda gwaɗa ta ghəŋa ya ka Lazglafta dzaʼa tsa guma ta ghəŋa mnduha. Ka Feliks ksur tsi ka zləŋ mantsa: «La tama, baɗu mutsafər yu ta fitik ya guli ná, hgəgəlta ɗa ta kagha tsa,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dzaʼa mutsay yu kasiʼi ta tsedi da Pwal ka ŋumna Filiks sizlay, ta kəl tsi gɗata ta hgagaptá Pwal tazlay ka ghwa yiva nda tsi. ");
INSERT INTO xed_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Səɗ səɗ his ka vaku luta ta magay mantsa. Tahula tsa vaku his ya, ka mbəɗapta Purkiyus Festus ta Filiks. Kambəl zɗəganata tsi ta la Yahuda ka Feliks ná, ka zlaŋtá tsi ta Pwal ma gamak. ");
INSERT INTO xed_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tahula fitik hkən manda klafta Festus ta slna nzanaghatá haɗikani, ka sliʼafta tsi ma luwa Sezare ka lafi da luwa Ursalima. ");
INSERT INTO xed_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ka sliʼadaghata la mali ta ghəŋa gwal dra skwi ŋa Lazglafta, nda la mali ta ghəŋa la Yahuda slanaghata hada. Ka wlatá həŋ ta Pwal da tsi. ");
INSERT INTO xed_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","«Kdəkkdək, kləgaŋnagha kla ta Pwal da na luwa Ursalima na,» ka həŋ ndiʼata ka ŋɗaŋɗa nda tsi. Mataba tsaya ná, nda dzra wa taŋ ŋa pghata buɗukwa ŋa dzata ma tvi ta laf tsi. ");
INSERT INTO xed_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ama ka Festus nda həŋ mantsa: «Wa a Pwal ma gamak ma luwa Sezare. Vərɗa iʼi guli ná, nzɗavata a yu wa, dzaʼa gi vru yu. ");
INSERT INTO xed_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ka sliʼafsliʼa sanlaha mataba la maliha ghuni mista ɗa ka dzaʼa ŋni da slanaghata hada ma luwa Kaysariya. Ka mamu skwi maga tsi kul ɗinaku katsi, ŋa wlata taŋ,» ka Festus nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ka tghas tsi, ka ghwaŋ a fitik za Festus ma luwa Ursalima, ka laha tsi da luwa Sezare. Gamahtsimani, ka sliʼaftá tsi, ka lagha da vla tsa guma. «Klagapwakla ta Pwal ya,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ka lagha Pwal. Ka sliʼadaghatá tsa la maliha la Yahuda ta sliʼadata ma Ursalima ya dlivis da wamtá Pwal. Ka mnə həŋ ta gwaɗaha ta kuzlaku ta kuzlaku, ka tsatsanavatá Pwal, ama haɗ hya gwaɗa kligiŋ həŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ka Pwal mantsa: «Haɗ sana dmaku maga yu wu, dər tvə zlaha la Yahuda, dər tvə həga Lazglafta, dər tvə mgham Sezar wu,» kaʼa waɗaptá ghəŋani. ");
INSERT INTO xed_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","«Ta ɗvay ka ta dzaʼa da Ursalima ka dzaʼa lu tsatá na guma na ta kəma taŋ ra?» Ka Festus nda Pwal ŋa zɗanafta ŋuɗuf ta la maliha ta ghəŋa la Yahuda. ");
INSERT INTO xed_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ka Pwal mantsa: «Wana yu ma vla tsa guma mgham Sezar. Hadna guli rakwa tsaɗighatá guma. Haɗ dmaku gana yu ta la Yahuda wu, nda sna vərɗa kagha ka ghəŋa gha. ");
INSERT INTO xed_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ka mamu dmaku gə yu, magamaga yu ta skwi prək ka dzata iʼi katsi, ma dza lu ta iʼi a ka yu wa. Ama ka haɗ hyahya skwi ma na gwaɗaha ta mnə həŋ ta iʼi na wu katsi, laviŋ a mndu ta vlaŋtá iʼi ta həŋ wa. Ta ndəɓa dzvu yu da kagha, ka la na guma na ta kəma mghama Ruma,» kaʼa. ");
INSERT INTO xed_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","«Manda tsa zbaŋta gha ta dzaʼa na guma na ta kəma mgham ya, dzaʼa dzaʼa ka ta kəma mgham Sezar,» ka Festus nda Pwal tahula gwaɗuvustani nda gwal ta vlaŋtá hiɗaku. ");
INSERT INTO xed_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Tsəɓakw fitik tahula tsa, ka lagha mgham Agripa nda Beranis da luwa Sezare da nghanaghata ŋumna Festus. ");
INSERT INTO xed_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ka zata həŋ ta fitik tsəɓakw hada. Ka rusanaftá ŋumna Festus ta gwaɗa ta ghəŋa Pwal ta tsa mgham ya. Kaʼa mantsa: «Mamu sana mndu zliɗiŋ Feliks hadna ma gamak. ");
INSERT INTO xed_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ma fitika laha ɗa da luwa Ursalima, ka sliʼadaghatá maliha ta ghəŋa gwal ta dra skwi ŋa Lazglafta, nda la galata mndu mataba la Yahuda sliɗighata. Ka wlata həŋ. Kdəkkdək, tsaŋna tsa ta guma ta na mndu na, ka həŋ nda iʼi. ");
INSERT INTO xed_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ta snu a aŋni la Ruma ta gi tsanaghata guma ta mndu mantsa ya wa. Tiŋəl ta guyanata nda guya lu ta tsa mndu ya nda tsa gwal ta wlata ya, ŋa zlanaŋta tvi ŋa waɗayni ta ghəŋani ta kəma tsa gwal ta wlata ya karaku, ka yu nda həŋ. ");
INSERT INTO xed_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ka saha həŋ da hadna mista ɗa. Gərɗava a yu guli wu, ka gi nzata ŋni ma vla tsa guma gamahtsimani. Hgagaghawa hga ta tsa mndu ya ka yu, ka hgaktá lu. ");
INSERT INTO xed_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ba va wana na mnduha ta wlata na dzaʼa mna ghwaɗaka skwi maga tsi, ka yu ná, sew haɗ tɗukwa skwi mna həŋ wa. ");
INSERT INTO xed_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ta ghəŋa zlərɗa gwaɗa ta dina taŋ nda gwaɗa ta sana mndu ta hgə lu ka