﻿USE sofia;
DROP TABLE IF EXISTS sofia.xbi_y_vpl;
CREATE TABLE xbi_y_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xbi_y_vpl WRITE;
INSERT INTO xbi_y_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ampueik sukur sukurel, Wulapm Weink ka apul mpuampua wantosukurel ka ar na keipm ar kitapmelel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Aser kitapm karokn ar ntapie ant aser arel, karokn. Yemp ka ar kuserel, ka mpep suwainkel aikol, pe nenkitie nenkitie ankilel karokn, eti mpep ka atit nkirnkerip, antempel yemp 'a nimpiemp yatip. Pe Pirpm Wulapm Weinkel ankil ka mpimpi lala sil mpep keipm nuarep wolpmel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","I Wulapm Weink akei sankmai akosepm ka niawurpmelel nak na, “Yemp, yikn mpilil, i kapepe yemp mpililim. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Wulapm Weink aser yemp'a mpililel ka akolikekn yatip. Kapepe kil awor kitiekitieelim, mpililel ar yakitie pe nimpiempelel ar yakitie. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Yemp'a mpililel ka kil aiyimp awun, pe yemp'a nimpiempel ka kil aiyimp nomp. Nomp a antun i rien nkankir, i kapepe awun sukur karep miniat. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Kil apul ntalepe niatelel, i Wulapm Weink ampu akei sankmai akosepm ka niawurpmelel napmok na, “Mpormpus, yikn la yer yuntun sinkireel yer no keipm na ntunkorp mpep nako yer yakitie yakitieel.” I kapepe mpormpus la ar misop nako ntunkorp mpep ka ar na keipmel antempel kitapmel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Eti mpormpus epe ka kil aiyimp mporkeipm. Nomp a antun mi rien kakirel, ka awun wuyeelim. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kil apul ntalepe niatelel, Wulapm Weink akei sankmai akosepm ka niawurpmelel nak ampulp mpep ka aikol ar a kitapmel nako mpi waker yukol yupmuei yempelikekn, apulp nako kitapm ampu no sil yapelel. Kapepe mpep kakir wankeip i kitapm ampu na misil yapel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Yemp nenk epe ka mpep kakir wankeip arkompel, ka Wulapm Weink aiyimp “kitapm”, pe mpep ka mpi waker aikol yempelikeknel, ka kil aiyimp “mpep niopm”. Wulapm Weink aser kitapm irpm mpep niopm ka kil apulel ka akolikekn yatip. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Pe kil apul ntalepe niatelel, i Wulapm Weink akei sankmai akosepm niawurpmelel nakimp kitapm na, “Yikn yupul walenk niepm irpm lo mua simi titepel, yek kitapm no ninink.” I kapepe kitapm apul misop. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Niepm irpm lo mua simi titep ka rukopm sepm'uret naker namporpm. Wulapm Weink aser mpuampua irpm epe akolikekn yatip. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nomp a antun mi rien kakirel i, awun wuyelikeknelim. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kapepe kil apul ntalepe niatelel i Wulapm Weink akei sankmai akosepmel niawurpmelel nak ampulp yite nompel awunel kana ninink yer no mporkeipmel i awunel ko suknim pe nompel ko akoim. Apulp nako ant waperp nomp awun yintemp wank yet mi ko ser yuworel yupulp awun simi titepelel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kil nakimp nti yite irpm pe ar na keipmelel ntape na, “Niokn aiyipmel yipm'o yukorp le kitapm mpilil sawupm, ntinkirai mpimpink sepm.” Eti ka ntapepe. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yite wuyeel epe ka Wulapm Weink apulel, nomp awun ntiwuye ka apul niokn suknel. Yite ka akorp ntinkiliempelel ka awun, pe nonkel ka akorp silmpenkelel ka wuyen. Pe kil apul nkuaimantump antempel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Pe yite irpm epe ka kil apul awomp nti aikol ar nampu mporkeipm, nako yukorp le yemp yer kitapmel, ");
INSERT INTO xbi_y_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","apulp nako yuwor awun yatel, nomp yatel, mi ko rien sikirel ko awunim, pe kona nomp yoel ka nompim. Wulapm Weink ka aser mpuampua irpm epeel, ka akolikekn yatip. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nomp a antun rien kamikir, i awun wuyewuyeelim. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kil apul ntalepe niatel, i Wulapm Weink akei sankmai sepmel ka niawurpmelel apulp mpepniopm na yokn sukn ako sepm'uret na nukur no i ko nkanka mpimpi lala yupmuei mpepniopm yekipmin. Pe aipm irpm pe nukurno lilil yikeipe yikeipe yer no mporkeipm. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kapepe yokn sukn muanumporel, antempel yokn suknako sepm'uret na nukur no yupmuei mpepniopm antempel mpuampua simi titep kana yer mpepniopmel, antempel aipm simi simi ko lilil yer no mpor keipm. Wulapm Weink aser mpuampua irpm epeel ka akolikekn yatip. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","I Wulapm Weink akei sankmai sepmel ar nti ampul nti sepm nako nti somp mintenkel. Nti yokn yuntup yokn mitinkel mi ko nti sikir yikei yetel yer mpepniopmel. Pe nti aipm ko mper yuwolmp mitinkel nako yuntup aipmuku mitinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nomp a antun rien kamikir, i awun ntakitiempuelim. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kil apul ntalepe niatel, i Wulapm Weink akei sankmai sepmel ka niawurpmelel namikimp kitapm na, “Yikn kako yupul aipmwus wurunel yintempel wurokn niumpua knuampel yet, yintempel saklokwus irpm milmputek yintempel mpuampua irpm ka pirpmelel.” I kapepe mpuampua irpm epe nukur na apmuei kitapm. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Wulapm Weink apul wus mpeiknwank, keipmel kitapmel, wurunel antempel knuampelel, pe wus simisimi yatyat ka ar kitapmel antempel. Wulapm Weink apul ntakilelel, ka kil aser nti akolikekn yatip. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kil apul ntalepe niatel, i Wulapm Weink napmok na, “Kapepe ant'a ko yumpul moule nako yer sop ntunkatu antilelel. Pe arai ant mper nti yer niorknel nti yokn irpm aipm wus antempel mpuampua wanto sukurel pie ar kitapm epieel, i ko nti yupmuei nta antuel mouleel.” ");
INSERT INTO xbi_y_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kapepe Wulapm Weink ampul nti moule, i nti nkamump mulomuati Wulapm Weinkel, ka kil apul moule wuyeel, mentit antempel maken. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","I Wulapm Weink akei sankmai sepmel niawurpmel ar nti amuk nti mintenk. Kil nakimp nti na, “Yipm'o ra ninkilapm mitinkel nako mpi nkis wampwamp yer kitapm sukurel epie nako yuwulmp mpuampua wantosukurel pie arel. Apm mper yokn irpm aipm antempel wus mpeiknel wankel pie ar kitapmel ar nta aiyipmel, ko yipm yuwulmp nti.” ");
INSERT INTO xbi_y_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kapepe Wulapm Weink nak na, “Eti yipm ser, apm ak yipmel lo rukopm ka ar wurun knuampel antemp niepm ntatnenk ka ar niokn mputnankel, ka apm ak yipm na yipm yelel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Aser wus mpeiknwank antempel aipm wurunsoel, ka apm ak nti wonkatnoel antempel mpua irpm ntakilelel, nako nti yelel.” Kapepe mpuampua irpm epe ka ar numuarep sank ka Wulapm Weink nakel. ");
INSERT INTO xbi_y_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Wulapm Weink aser mpuampua simisimi epe sepmim, i kil wunempsepmelim. Nomp a amuntun i rien kamikir, ka awun 6-pelaim. ");
INSERT INTO xbi_y_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kapepe Wulapm Weink aiye nimpiliekn ar kitapm i akei ampul mouleel. I kil mutump awop muar moule epe niunkuniemp, i moule epe aiye yapm i kil pirpmim. ");
INSERT INTO xbi_y_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Pe niokn ampueik Wulapm Weink apul ar Iden ar yekyakitie awun naelel, moule epe karep kil apulel ka kil mper kil apei pope. ");
INSERT INTO xbi_y_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Wulapm Weink apul kitapm, i lo simi titeptitep nkis akei nampel. Lo irpm epe ka nti aser sepm suwaink, pe rukopm antuel ka nakerel ka sinken yatip. Pe lo wuyeel ka na tnei niokn niumonel, lo nonkel kana yupul nti moule kana yer sepmel yer yeklikeknel, pe lo nonkel kako yupul yapmunemp antuel na yitityukor yupulp yapmunemp weink sukurel, oku ka kuretel, oku ka akosepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","17","Wulapm Weink apul kitapm sukurel niatel i, kil kua moule pe karepil apulel mpi mper kil apmuei niokn Iden, nako moule epe yirip niokn ekilelel. Kil mper kil ar niatel i, Wulapm Weink nankimpil na, “Lorukopm wanto pe tnei niokn ekeielel ka yikn yel. Aser lorukopm likekn epe ka ak moule yapmunemp sepmel i ka aser aworel mpuampua simi ka sepmel simi ka kuretelel, lorukopm epe ka yikn korokn yel. Kona yikn yelel, yikn arai pokel yuwur. (Sank ka ar Stat 2:15-17) ");
INSERT INTO xbi_y_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Ar mpinkeimpinkeiel i, Wulapm Weink napmok na, “Moule epie likekn ar, aser karokn sepm. Apm yupul setel ninink nako ikiwatilel. Eti Wulapm Weink nkamp kitapm i kil ampul aipm wus mpuampua mitinkel. Apul nti niatel i, kil kua nti la ntimiremp moule epe, nako moule epe wul nti nia nintilemel, i moule epe apul misop. Nia kil wul nti wus wampiliekn antempel wus yanker, antempel aipm suknako sukurel. Nia simisimi karepel, ka pie yireikel apmuei, ka nia antuelim. Aser ka setel antuel mpuampua ekilelel kapukorokn ikiwat Adam ntaka memprien ankilelel. ... (Sank ka ar Stat 2:18-20) ");
INSERT INTO xbi_y_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","25","Kapepe Wulapm Weink ampu apul moule epe ampu ar niumpu wuntuim, i kil peyar apei niumpu i Wulapm Weink amiye linkepm apmuei kil wurienk i ampu mor kil ntieaikn karepil aiye linkepmel. Kapepe Wulapm Weink akei linkepm karepil aiye ar mentitel akei ampul makenel, ar i kil atnimp maken mimpip mentit. Moule epe aser makenel i kil napmok na, “Kapepe. Kil ka memprien apmilel. Linkepm ankilel ka yek linkepm apmilel naikul. Pe wusmpa ankilel ka yek wusmpa apmilel naikul. Ka Wulapm Weink akei linkepm apmilel apul kil, eti oko apm miyimpil maken.” Eti pie yayapel epie tneiel. Mentit ka nisep waiekmantiek ka nkis amintemp maken ankilel. Pe ntiwie ka ar nkis mpim likekn. Ntiwie ka akei ntayelel arnkis. Aser ka ntiwie karokn ampu wule maiyaknel. ... (Sank ka ar Stat 2:21-25) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","5","Wulapm Weink ka apul aipm wus akeiwanto, aser saklok ka yapmunemp ntupmu ntiesoelip. Nti aipm wus mpuampua Wulapm Weink apulel karokn sankork kil. I saklok amiyimp maken na, “Mi Wulapm Weink ka nakantup yipmwuye na korokn yel lorukopm akeiwanto sukurel pie tnei nioknel pe, a?” I maken ampu nak na, “Lorukopm mitinkel irpm pie tnei nioknel arai ant yel. Aser lo likekn po tnei niokn niumon niumonel ka Wulapm Weink nakantup antie, ka ant'orokn yel. Wulapm Weink nakimp antie na, Yipmwie korokn yel, korokn ntasomp rukopm lo ekilelel, yipm ko yuwur.” Kapepe saklok namikimp maken na, “Karokn. Yipmwuye kapukorokn yuwur. Kona yipmwuye yel rukopm lo ekilelel, arai nkiyirp yipmwuye niampepm i yapmunemp yipmwuye ko yukor yumpulp simi ka kuretelel, simi ka sepmelel. Pe yipmwuye arai yer ntaka Wulapm Weinkel. Yapmunemp Wulapm Weinkel ka akor ampulp, eti pe kil nakantup yipmwuye na korokn yel rukopm lo ekilelel iii.” (Sank ka ar Stat 3:1-5) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Maken aser lo epe akosepm pe rukopm ka nakerel ka akolikekn yatip. Kapepe maken wunempwamiyimp na, “Ka akosepm apm yel rukopm lo ekilelel nako yapmunemp apm yukor yititel.” Eti maken epe nsin rukopm lo ekilelel i kil aim. Pe mpurel kil amuk minkan ankilel, i minkan ankilel aim. (Sank ka ar Stat 3:6) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","8","I niampepm ntiwuye mpililim i ntiwuye aser amorel na ntiwuye ka akei ntayelel at. I kapepe ntiwuye ntimpal wupm lo fikel, i ntiwuye atnu mintaka elmpuapmel nako sukurp moule ntiwuyeelel. Ar awuniunkurikn yemp niumuaipmel, i ntiwuye yupmueipm Wulapm Weink ka warep at niokn ekilelel, i ntiwuye akei lo irpm pe nkuwur nkumurupm. (Sank ka ar Stat 3:7-8) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","13","Aser Wulapm Weink aiyimp mentit i nak na, “Yikn ar oku?” I mentit ampu nak na, “Apm eipm yikn ka warep at nioknel i apm nkinkiekn, apulpaser apm ka akei ntayelel at, eti apm nkurupm yikn. I Wulapm Weink amiyimpil, “Yikn aser aworel ntakulel, pe yikn akei ntayelel atel? Mini nakimp yikn? Ntakilelel yikn pe karep aim lorukopm ka apm nakantup yikn na korokn yelel tikikn?” I moule ampu nak na, “Ka maken epie ka yikn ak apm ntaka memprien apmilelel ak apm al.” Wulapm Weink eipm sank ekilelel i kil amiyimp maken na, “Mpuampua epe ka yikn apulpielel?” I maken ampu nak na, “Ka saklok waker apm yapmunemp i kil ninkai apmel, eti apm aim lorukopm epie.” (Sank ka ar Stat 3:9-13) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","15","Maken epe nak ntakilelel i, Wulapm Weink nankimp saklok na, “Yikn aim yapmunemp'uretel i yikn apulel i, ekeielel apm'a yikei mai yumor yikn. Yikn oko ninkem wankepm suknel. Wankepm yikn'a yirkosel kapuko sukn sankork nti aipm wus wanto sukurel. Yekipie mpiel yintempel araiaraielel, yikn oko yikei lunko yuwei yet wunamp, pe yikn oko yel nimpiliekn niurkuekn. Pe arai apm yupul yikn yintemp maken nkisemp wurokn, pe maken yintemp yikn nkisemp wurokn. Pe arai apm yupul nti wurepm'itie aiyiknel yintemp nti wurepm'itie makenel nkisemp wurokn. Nti oko nkaik ntemp yikn mamp, pe yikn ko yump nti tnei nkaik nikitei.” (Sank ka ar Stat 3:14-15) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Pe Wulapm Weink nakimp maken na, “Arai apm yek yikn wankepm suknel kona yikn tnei ninkilapmel. Pe kona yikn ra ninkilapmel arai yikn somp yakop suknel. Aser yikn kako yupulp minkan aiyiknelel suknelip, aser kil kapuko yer niorknel yuwulmp yikn.” (Sank ka ar Stat 3:16) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","20","Pe Wulapm Weink nakimp Adam na, “Yikn yupmueipm sank maken aiyiknelel i yikn aim lorukopm ka apm nakantup yiknelel. Ntakeielel i, apm oko yumpul kitapm milminel, niepm irpm kapukorokn serp yikei sepm yupul. Ko yikn yikei ntinkiliemp aiyiknel yumpul nako niepm nukulup kitapmel. Mua yenkel antempel mpuas sepm kuret arai no yuwor yuwulmp niokn mputnank aiyiknel. Yikn ko ntinkiliemp, tupuapur nukul yiknel, i ko yikn yim niepm. Yikn ko ntinkiliemp ntinkliemp mpimpi ser yikn ko yumur i ampu ko yumu kitapm. Apulpaser ka apm akei kitapm apul yikn i ko yikn ntintir yupmuei kitapm.” Mentit aiyimp maken ankilel Ivel, ka apulpaser kil ka mipmakn antuel mentitmaken akeiwantoelel. (Sank ka ar Stat 3:17-20) ");
INSERT INTO xbi_y_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","24","Ar mpinkeielel i, Wulapm Weink akei wusaikn ampul elmpuapmel, i kil amuk Adam nti maken ankilel i ntiwuye amutnu. I Wulapm Weink napmok na, “Moule ka aser amorel mpuampua simi ka akosepmelel simi ka kuretelel, pe kil ka minta ka antel. Eti ka ant'orokn yikei niampepm ser kil na kil mpi kitnan lo epe ka apul moule kana nkis keipmelel. Kil ko ampu yiki yel lorukopm epe yintempelel, kil kapuko nkis yupmueiel. Kona ntakilelel, kako kuretim.” Kapepe i, Wulapm Weink nkiyir moule apmuei niokn Iden, i wankesil mpi na yupul niokn yupmuei kitapm po ka Wulapm Weink akei apul kilel. Ar kitapm ekeielel, kil ko yikei kitapm epe yupul niokn mputnank ankilel. Wulapm Weink karep nkimiyir ntiwuye ntitmakenel, i kil nkamump nti ensel ka niawurpmelel na nti na yet wakerp niokn Iden yer yakitie awun naelel. Pe nonkel kil mper skal nimpilieel ka yite tnalel ar, i ka nimpilemp nimpilemp akeipe akeipe. Aninkanink nti ensel antempel skal nimpilieel ka arip wakerp apeielel, apulp na mouleel ko mpi kitnan lo epe kana yupul moule nkis keipm yerelel. (Sank ka ar Stat 3:21-24) ");
INSERT INTO xbi_y_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Moule mamp Isipel aiyimp nti moule ankilel ka yapmunemp atitakuor antempel nti moule yalepmel i nti mpim. Kil nakimp nti ko nti yikei niawurpm antuel na yupul soplikekn Aron apulel. Eti nti yawol mpu antuel a kitapm nisam saklok. ");
INSERT INTO xbi_y_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Kapepe Wulapm Weink ampu aiki nakimp Moses na, “Nikimp Aron na kil yikei mpu ankilel yuntup'itapm yupulp nako watunkup ka ar kitapm sukurel Isipel ampu nisam muanmipmiknel.” ");
INSERT INTO xbi_y_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kapepe ntiwuye apul misop. ... i watunkup sukurel ka ar Isipel ampu nimisam muanmipmikn i muanmipmikn kakirpamuntun nti mentitmaken antempel wus irpm antuel. ");
INSERT INTO xbi_y_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kapepe nti moule yalepmel Isipel nkarp i ampu yupul niawurpm kitapmel antuel apulp na muanmipmikn na nukul soplikeknel, aser ka nti apul kuserel. ... ");
INSERT INTO xbi_y_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Eti nti epe namikimp moule mamp na, “Ka Wulapm Weink ankil apupul mpuampua irpm epe.” ");
INSERT INTO xbi_y_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sepmel, mpunkol niawurpm miel kako sankork yiknel? Arokn. Yikn ka nia suknel nkamp yiknel apulp wunamp sepmel ntinkiraiel aiyiknelel. Mpunti aiyiknel ka nampu keipm. Yikn ka likeknako yatip. Yikn ka apul niokn suknel niawurpmel mitinkelel, eti nti mentitmaken akeiwanto ka nkinkiekn ampulp yikn. Setelel kapukorokn yupul sop yikn apulel na waiyimp yikn. Kapukorokn ankil! ");
INSERT INTO xbi_y_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kapepe Moses awor wuntokn mpaielel kitielel wieel ntaka ampueik niorknelel, i kil akei nompel waimpip wuntokn wieel epe apul namp malenk Sainai. Ka kil apul sop sank ka Wulapm Weink nakimpilel. ");
INSERT INTO xbi_y_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Eti Wulapm Weink a kitapm i ar war mpor ka nimilel mi ka nankilemp a ntemp kitapmel, antemp Moses at na malenk i, kil aiyimp nia ankilel Apmapeielel ntimiremp Moses. ");
INSERT INTO xbi_y_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kapepe kil nak nunkualel mpi yireikel Moses ntapena, “Apm apmel, apm ka apeielel. Nia apmilel Apmapeielel. Apm ankil ka Wulapm Weink, ka moule ntayonel, pe apm ka akei nankerp yipm suwaink. Pe apm ka moule pmoel, yapmunemp sepmel apmilel apulp yipm mentitmaken akeiwantoelel, kakorokn niat. Apm ka akei nta niupuknel nkrawomp yipm suwaink, pe yapmunemp sepmel apmilel kapukorokn ampu yitip awun wainkilel.” ");
INSERT INTO xbi_y_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Wulapm Weink nakimpil niatel, i Moses mpulyapm a kitapm i amiyep Wulapm Weink aiki nia Wulapm Weinkel namp keipm. ");
INSERT INTO xbi_y_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","I Moses napmok na, “Sepmel, kona yikn aser apm akosepmel, i apm apulp na yikn na yo yintemp ant yer. Ka yikn apiserel pe, nti mentitmaken epe ka yapmunemp ntupmuelip. Aser apm aiyimp yikn, nako yikn yikei nankerp ant, pe yikn'orokn wunempwaiyimp yapmunemp'uretel antilel. Pe yikn ampu ntasomp ant ntaka mentitmaken aiyiknel likeknelel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ekilelel nti moule sepm wulapmel ka ar niorknel awulmp nti Israel i aipmitnimonim. Pe mouleel yemp suknel Betlehemel, kil ka ntieyarkup antuel Judael, kil kua maken ankilel antempel ninkilapm ntit wuyeel ankilel at niyem mpi ankei yininkel nioknwank mpurel ar Moap. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Pe nia moule ekilelel ka Elimelek. Pe nia maken ankilelel ka Naomi. Pe nia ninkilapm ntit wuyeel ankilelel ka Malon nti Kilion. Wopmweink antuel ka Efrata, nti ka ntieyarkup antuel Judael. Pe nti ka yek yemp suknel Betlehem la. Nti mpi nkis popokel ar kitapm antuel Moapel. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Aser Elimelek amur, i Naomi kua ninkilapm wuyeel ankilel likekn apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ar mpi i ninkilapm wuyeel nkamump maken wuyeel Moapel antemp ntiwuye nkupmus. Pe nia maken wuyeel epeel ka Orpa nti Rut. Ntiarko ka ar nioknwank 10-pela irpm tikikn, ");
INSERT INTO xbi_y_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","aser Malon nti Kilion awur amintempel. Kapepe Naomi likekn apmuei. Pe minkan ankilel kua ninkilapm wuyeel ankilel ka amur. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Kapepe Naomi eipm sank ampulp na, Wulapm Weink ka amuk nti mentitmaken ankilel niepm mimpinel. Eti kil antempel yanikno ankilel wuyeel ntimpramp nako mpi yumomp yemp antuel Moapel. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","I Naomi kua maken wuyeel epe nkarp i ampu mpim kitapm Naomiel ka Juda. Nti nkarp mpim, ");
INSERT INTO xbi_y_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","aser Naomi namikimp ntiwuye na, “Yipmwuye ampu nuaker mpi knuamp yintemp mantiek wuyeel aiyipmel yer. Nti tnioknsiknamp ka awurel antempel apm, ka yipmuye aserp ant, apul ant sepm akei ampripel. Eti kako soplikekn, apm apulp na Wulapm Weink ko yep yipm yupul yipmwuye sepm yikei yiripel waperel. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Pe apm aiyimp Wulapm Weink apulp na kil serp yipmwuye nako yipm ampu yintemp minkan niumpueiel nkis mi ko yipmwuye ampu yer sepmelel.” Kapepe Naomi sank antemp maken wuyeel nak namiremp nti, aser ntiwuye akei misa warpmel, ");
INSERT INTO xbi_y_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","i nti namikimp Naomi na, “Karokn. Antarko kana mpi yintemp nti aiyiknel yupmuei.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Aser Naomi nak na, “Yipmwuye apei sop apm, akosepmel ka yipmwuye ampu waker mpim. Pe yipmwuye sop apm la apulpi? Eti apm arai ra ninkilapm ntit mpurel nako yipmwuye yintemp nti nkisel tikikn? Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Apm ka tnioknim, apm kapukorokn yintemp minkan nkis. Pe kona nomp epe apm yintemp minkan nkis mi, apm ra ninkilapm irpmel, ka yipmwuye kapukorokn yer kuserel yirip nti, nako nti sepmwulapmel i ko yipm yintemp nti nkisel. Yipmwuye kapukorokn yirip nti karokn. Wulapm Weink ka apul apm 'uret, eti apm wunempapulp yipmwuye yatip. Yipm ampu mpim wompitne weink aiyipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kapepe Rut nti Orpa ampu aiki misa aninkel. I Orpa nak naremp Naomi niatel, i kil po ampu mpim, aser Rut ka nkark i kil antemuampilp Naomi na ntiwuye nako yupmuei. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Kapepe Naomi namikimp Rut na, “Yikn ser es aiyiknel okoripm, kil po ampu na mpi miser nti ankilel yintempel womp antuel milman mipmakn ankilel ka nti nuarelel. Pe yikn ampu yintempil mpim.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Aser Rut ampu nak na, “Yikn 'orokn niek nkiyir apm na yuwomp yikn, pe yikn korokn niek yuntup apm, yupulp apm 'a yintemp yikn yetel. Pe yikn'a yet yikeipe yikeipeel, apm arai yintemp yikn mpi. Pe wampwamp kona yikn 'a mpi yerel, apm arai mpi yintemp yikn yer. Nti moule ka aiyiknelel, arai nti apmilel yintempel, pe Wulapm Weink kona yikn yepel, arai apm yepil soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Pe yemp yikn 'a yuwur yoel, arai apm yuwur yo yintempel i ko nti yuntup apm yupmuei yemp epe. Apm kapukorokn yikei wule mperp sitel na yuwor antwuye. Ka awurel likekn ko yuwor antwuyeel. Sank pe apm nakel ka apm nak nuarel, kona apm 'orokn yupul sop sank irpm pie apm nakelel, i arai Wulapm Weink yupul apm milminel yep.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi aser Rut aser kil apul mipmaip na yintempil mpim, eti Naomi ka sank karokn. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kapepe ntiwuye nisopel mpi niminink Betlehem. Naomi nti Rut mpi ninink Betlehemel, nti mentitmaken karep nkark prierprur ankil. I nti makenmaken napmok na, “Epe ka Naomi pe tikikn?” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Kapepe Naomi napmok na, “Yipm orokn yimp apm Naomi, nuarep maken ka yapmunem niuluknunelel. Karokn. Wulapm Weink ka niawurpmelip, kil apul apm 'uret, eti kako yipm yimp apm Mara, maken ka wosol wulimpel son woelel. ");
INSERT INTO xbi_y_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Apm nkarp yek wompitne epie mpiel, apm'a wankepmelip, aser pie Wulapm Weink ampu apul apm lael, ka apm akei ntayelel nklai ankil. Minkan apmilel kua ninkilapm wuyeel ka wuntuim. Yipm ampu aiyimp apm maken yapmunemp niuluknunel apulpi? Sepmel antilel Wulapm Weink kil ka niawurpmelip, ka kil ankil napek pe i, apm pe niminkem 'uretel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Sank epie ka nak apulp Naomi kua yanikno ankilel Rut, maken yemp Moapelel, ampu lael. Nti mpi ninink Betlehemel, ka ankrik ka nti antun antun bali ka nuarep rukopmuninkelel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nti ar Betlehemel, Boas ka mesepmel nia nkampel. Pe Elimelek ampueik Naomi antempil nkisel, ka ntieyarkup Boasel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kapepe Rut nkarp i namikimp Naomi na, “Apm pe na mpi niokn nuanti bali ka nti moule antun mi mpurel ka naikul nti nkis irpmel. Pe kona nti moule nioknel mpua yikiel ko apm nuanti bali rukopm misop nti. Kapepe Naomi ampu nak na, “Yanikno, ka akosepm yikn ampu mpi.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kapepe Rut mpi niokn i numuanti bali irpm ka naikul nti nkisel misop nti moule nioknel. Pe kil karokn nak na niokn epe ka Boasel, i Boas ka ntie yarkup Elimelekelel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ekilelel i, Boas yek Betlehem la aser nti moule nioknel ankilel i kil sank ar nti nak na, “Wulapm Weink yintemp yipm yer.” Kapepe nti ampu nakimpil na, “Wulapm Weinkl yupul yikn sepm.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kapepe Boas amiyimp moule mamp antuel moule nioknelel na, “Maken ninkieel epe wopm weink ankilel ka simi?” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","I moule mamp ampu nakimpil na, “Maken epe ka wampelelip ka antemp Naomi la. Ntiwuye ka yek Moap mpila. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Kil aiyimp apm na kil na nuanti bali sop nti moule nioknel. Karep kil apul yek nomprien mpla, pe ekeielel ka kil nkisemp sipmakn pitepitekn.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Kapepe Boas nankimp Rut na, “Mipmakn, yikn eipm apm sank. Ka yikn orokn mpi nuanti bali yer niokn yatel. Karokn. Ka yikn yintemp nti maken nioknel apmilel yupul niokn, nuanti bali yer mputnank epie likekn. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Yikn ser yemp nti apul niokn arel aipopel nako yikn yintemp nti yerel. Apm nakimp yikn likeknel, arai apm nikimp nti moule wasiyamelel mpunkolel yupulp na ka nti korokn ntasomp yikn. Pe kona mpepyapm yer yiknel, mpep marpmel ka nti ale mper apmuei, ko yikn mpi yel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Kil nak niatel, i Rut waker nkaikyumpo eip kitapm aikel a, i kil nakimp Boas na, “Apm ka maken 'useluselel ka yek wampwamp mpilael. Apulntaku pe yikn niampepm kakirp apm, mi pe yikn apul apm sepmelel ");
INSERT INTO xbi_y_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas ampu nakimpil na, “Sank apulp simisimi ka yikn apulp yanikno aiyiknel ka minkan aiyiknel awurel ka apm yupmueipm. Pe apm 'a nimpriepmel apulp nti waiekmantiek aiyiknel antempel wompitne aiyiknel ka yikn amomp nti. Pe yikn pie la antemp nti mentitmake Israelel ampueik yikn arokn aser ntiel apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Puikn apmilel ka apulp na apm aiyimp Wulapm Weink ko nkisemp yikn wunemp sepmel waperel. Pe puikn suknel apmilel apulp simi ka Wulapm Weink antilel Israelel ka ant aiyepel na yek yikn ka ko numpu keipm. Pe yikn lael, yikn kana yer wa Wulapm Weink likekn pepe, nako kil niumuayikei yiknel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Kapepe Rut ampu nakimp Boas na, “Waiek, nia karokn nkamp apm, nuarep nti maken nioknel aiyiknelel. Aser yikn muarkn ar apm yapmunemp, i yapmunemp apmilel ampu mintenkim. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nti nako yim niepm, i Boas namikimp Rut na, “Yikn la somp luwu ntintir-el yikei wat mpep wain ka lukopelel i yikn yel.” Kapepe Rut la i nkis kitnan namintip nti moule nioknel. I Boas nkamp bali ka nti as yiteel i akei mitneipil. Rut al mpi aser kil lunkoim, i niepm wainki nkupmus. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rut al niepm niatel, i kil ampu nkarp numuanti bali wainkilel wainkilel irpm ka atit nkisel. I Boas namikimp nti moule nioknel ankilel na, “Kona Rut na nuanti bali wainkilel wainkilel mpi kitnan po yipm kitin waimpwaimp mperarel, yipm 'orokn yupul kil wule maiaknel, ka yipm yikei niampepm ser kil. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Pe yipm yurko bali wainkilel mpurel mper yer, nako kil nuantiel. Ka yipm 'orokn niekil yep.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut nuanti bali wainkilel wainkilel ar niokn mpimpi awun amu kitapm. Kil nuanti niatelel i kil nimimirem rukopm ankilel i kil nkamump. Ka kil aimpum wunink sorkel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kapepe Rut aiki bali epe san apul mpim yemp suknel ntimiremp yanikno ankilel Naomi. Pe niepm wainki karepil al awun mi kil mper arel, ka kil apul mpi ak yanikno ankilel antempel. ");
INSERT INTO xbi_y_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Kapepe Naomi amiyimp Rut na, “Pe yikn nkamp ar oku bali epe? Niokn moule miniel yikn apul elmp arel. Moule epe ka aser yikn mi kil wunempwaiyimp yiknel, ka ko Wulapm Weink yupul kil sepm.” Kapepe Rut ampu nak na, “Apm 'a apul niokn ar mputnank moule el, nia ankilel ka nti aiyimp Boas.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","I Naomi napmok na, “Moule epe ko Wulapm Weink yupul kil sepm. Pe Elimelek kua nti ninkilapm wuyeel ankilel ka awurel, antempel antwuye, Wulapm Weink karokn ntanisep ant mi kil akei ant pmompel.” Kapepe Naomi ampu nak na, “Moule epe ka ntieyarkup antilel, pe antarko ka wopmweink likekn. Kil ka moule sepmel, niokn ankilel, kil kapuko yuwulmp nti, ninkilapm ntankermp irpm makenarenk yer wopmweink antilelel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kapepe Rut napmok na, “Pe sank nonkel ka Boas nakimp apmel, ka ntalekil. Apm kako yintemp nti maken nioknel ankilel yupul niokn yipeiel, mpimpi ser niokn kana yuntun bali irpm witel ko miniatim.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Kapepe Naomi napmok na, “Yanikno, ka mpinta pepe. Kona yikn ampu mpi yupul elmp yer niokn mewelel, nti moule nioknel moule epeel arai yupul yikn 'uret. Akospemel ka yikn yintemp nti maken nioknel Boasel likekn yupul.” ");
INSERT INTO xbi_y_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Eti Rut ka antemp nti maken nioknel Boasel apul niokn, mpimpi akei amu elmp ka antun bali irpm witel ka miniat. Pe Rut ka antemp yanikno ankilel apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Aninkelel, i Naomi nakimp Rut na, “Yikn eipm, apm pe na yuwup moule na yikn yintemp mi ko yikn nkis niumuaipm niuluknunel, yupulp nako kil niumuayikei yikn aipopelel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kapepe yikn ampu eipm. Moule opo Boas, po yikn antemp nti maken nioknel ankilel apulpil nioknel, kil ka mewel antilel ka na somp yemp na sop ntunkatu antilelel. Pe nomp araiel, kil oko yo yupul niokn yer yemp ka na simpilemp bali mi na ye niakepm yerel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Eti yikn mpi niserk mpep, yikei sanda yuwa moule, pe yikn somp mintirokn akosepmel ntri. Kapepe ko yikn mpim yemp po kil apul niokn arel, aser ka yikn orokn mpi niampepm ankilel na kil ser yikn. Pe yikn 'o yukuweimil mpi ser niepm irpm mpep ka kil alel ko miniatim.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Kona kil na yer niumpuel, ko yikn niampepm yukol yemp po kil arel aipopel. Kapepe yikn mpi i, elmpuapm mpeiknel ka kil akei awulmp wolpmel, ko yikn yiki wainki ka awulmpil nkaikel. Pe yikn 'o yer kitnan nantipil nkaik. Pe arai kil nikimp yikn yupul simi ko yikn yupulel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Eti Rut ampu nak na, “Sank akosepm. Arai apm yupul sop sank irpm pe yikn nakel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kapepe Rut nkarp i kil po mpim yemp kana simpilemp bali mi na ye niakep yerel, i kil apul misop sank irpm karep Naomi nakel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas al niepm irpm mpep niatel, kil karep wunemp sepmel ankil. Kapepe niumpu amu kil, i kil mpi ar niumpu ar kitnan namintip bali kepmel. Ar mpi i Rut seseik mpi aimiki elmpuapm mpeiknel i kil a ar niumpu namintip Boas nkaik. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ar mpi nompsoel i, Boas nkarp nimimpilemp, aser kil amiser maken ka ar niumpu ar kitnan nantipil nkaikel. Kil aser ntakilelel, kil karep nkark kuret ankil, moule kil ka numuarep mporyiniknel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Kapepe kil amiyimp na, “Pe yikn mini?” I Rut nak na, “Apm ka Rut, maken ka apulp yikn nioknel. Yikn ka ntieyarkup Elimelekel. Yikn yikei elmpuapm wainki aiyiknel yuwulmp apm, nako ntremp ntape na, apm 'a nako yintemp yikn nkupmus. Ka niokn aiyiknel na yuwulmp ant makenarenk wopmweinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas eipm ntakilelel, i kil namikimp Rut na, “Mantiek niupukn apm apulp na Wulapm Weink ko nkisemp yikn wunamp sepmel, yupul yikn sepm. Apulpaser, simi pe yikn apulpel ka ntremp apm apulp puikn aiyiknel ar Naomiel, pe yapmunemp aiyiknel ka ar likekn antemp yapmunemp Naomiel. Eti wunamp sepmel pie yikn ntrempel ka sankork wunamp sepmel irpm ampueik yikn apulel. Nti ninkilapm moule wasiamel pie arel ka mitinkelip. Nti mpurel ka antempank mpuampua mitinkel, mpurel karokn. Eti ka yikn arokn akei moule aiyiknel yuwup mewel antuel. Karokn! Ka yikn aiyimp apm ankil, nako apm yupul niokn sepmel wopmweinkel na yuwulmp yiknel. Akosepm.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Eti, mantiek niupukn apmilel ka yikn orokn nkinkiyekn, yupulp na yikn 'a maken wuselwuselel ka yek wampwamp la nkisel, pe yikn 'orokn niek na nti mentitmaken Betlehemel ko yikei niampepm mitael ser yikn. Nti ka nimpriepmel, yikn ka maken akosepmel, pe simisimi ka yikn nakel arai apm yupul. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ka yikn nak wat a ntunk, apm 'a moule ntieyarkup kitnanel, kana sop ntunkatu minkan aiyiknelel pe apm 'a na niumuayikei yikn. Aser ntieyarkup kitnanel ankilel yitne pminel, kana yupul niokn epeel kape ar, kil ka es apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Eti yikn yer piepe, ankai nomprienel apm oko mpi yimp moule opo yapmunemp ankilel. Kona kil na ntasomp yikn na niumuayikei yiknel, ko akosepm. Aser kona kil serkel, i arai apm ntasomp yikn niumuayikei yikn. Sank apmilel epie ka apm nak yuwa. Wulapm Weink karep yupmueipm sank pie apm nakel. Kapepe yikn ampu yo yupmuei niumpu. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kapepe Rut ampu ar niumpu ar kitnan namintip Boas nkaik. Ar mpi rien kakir mpilil nimpiempel i, Rut ampu nkarpmop. Pe Boas ka wunempwaiyimp na, sank apulp maken epe pie la yemp epieel ka korokn yukorp nukul yemp yapelel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Kapepe Boas namikimp Rut na, “Yikn yupul elmuapm aiyiknel ka yikn akei awulmp wolpmel la nkra nkis kitapm,” Rut apul misop, i Boas nkamp bali nimprip mimperpil elmpuapm, wankepm ankilel ka nuarep wankepm wunink sorkelel ka nti aiyimp 20 kilo. Kapepe Boas aser Rut nkamumpopil bali i kil apul mpim knuamp. Pe Boas ka mpim yemp suknel.");
INSERT INTO xbi_y_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut mpi ninink knuampel war yitneel, i yanikno ankilel napmok na, “Yanikno, apul ntaku?” Kapepe Rut sukueimpil ampulp simisimi karep Boas apulel. ");
INSERT INTO xbi_y_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","I Rut napmok na, “Boas 'arokn apulp na apm'a yikei kuserel mpi ser yanikno apmilelel, eti kil antup apm bali mpurel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kapepe Naomi napmok na, “Yanikno, yikn ampu yer pitepitekn nantip, yuwup ser simi ko nininkel. Apulpaser Boas kapukorokn yer kuserel. Karokn. Kapukorokn akir, kil arai pokel yuntun ye yupul.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boas mpi nkupmus anuyapel ka nti aiyepel. (Anuyapel ka nti aiyep ar kitnan nantip lomp tukuakn ka nti akei yininkemp yemp suknelel, pe ka nti aiyep ar yek ya kurieknel. Anu epe ka nti aiyep apulp sank niepm, mpuampua kona nti niye yer nkis mi nti niek yupul irpmel.) Arokn akir kil ampu amiser ntieyarkup Elimelekel epe, kil ampu mila. Kapepe Boas amiyimpil na, “Ei sepmel, yikn la nkis epie apm a nikimp yikn sank pitepitekn.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Kapepe Boas nkamp nti 10-pela moule mamp wompitneel la, i kil nakimp nti na, “Yipmarko yo nkis kitapm,” i nti 'a nkupmus. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kapepe kil namikimp es ankilel i ntiarko yupmueipm na, “Naomi ampu ka yek Moap mila. Kil ka apulp na mewel na somp kitapm Elimelekel, kil ka es antwuyeel. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Apm'a nak na mpuampua ntakilelel kako yikn eipm mpiniorkn. Eti apm 'a nikimp yikn, kona yikn puiknel yikn ampu somp kitapm epe yer niampepm antuel moule mamp antilelel, yintempel nti moule pie nkis epieel. Kona yikn 'a somp kitapm okorelel, yikn 'a ar niorknel apm. Pe kona yikn nkarkel, i yikn nikimp apm nuworpel.” Kapepe moule epe napmok na, “Arai apm somp.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","I Boas nankimpil na, “Kona yikn 'a yintempank kitapm Naomi nti Rutel, i maken Moapel opo Rut, kako yikn sompil yintemp yikn nkupmus. Pe kitapm irpm epe kako yupmei nta antuel wopmweink moule po awurelel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Aser moule epe napmok na, “Ka yikn nak yuwa, mpuampua irpm epe ka apmilel. Aser mpuampua irpm apmilel, apm 'arokn mpuaimpuai apulp na mperp walimp nti ninkilapm yatel yintempel ninkilapm apmilel nti. Eti apm kapukorokn somp kitapm epe, ka elmp aiyiknelip.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Wunamp antuel Israelel ampueik nti milman mipmakn ar nkis sop yek po laelel, nonkel ka apulp mpuampua ka nti na yuwei wusyuwa yuntunel, antempel simisimi ka nti na nimpilemp yikei wainki yikei wainkiel, ka nti apul ntalekil. Mewel ko nankulp loaikn ankilel i ko yumuk moule nonkel. Nti Israel ka na yuntuniye wankepm simisimiel, ka nti apul pisop yayapel piepe. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Kapepe moule epe nakimp Boas na, “Kitapm epe kako yikn ankil sumump.” Eti kil nankulp loaikn ankilel amuk Boas. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","I Boas ampu nankimp nti moule mamp antempel nti mentitmaken na, “Yipm wanto, yipm ampu ser. Arep arepel mpuampua Elimelek nti Kilionel antempel Malonel ka Naomi antempank. Aser ekeielel karep apm nkamump. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Pe apm ampu na nikimp yipm sank nonkel yintempel. Rut makenarenk Malonel, pie apm'a sompil yintemp apm nkupmus, pe kil ka maken apmilelim. Apm 'a somp Rut yupulp nako kitapm wainki antuel ko yirip ntiel. Pe nti wompitne weink moule ka awurel, antempel wopmweink ankilel ko wunempwaiyimp nia ankilel yer yeklikeknel. Simi pie apm apulel, karep yipm aser amikorp.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Kapepe nti moule akeiwanto nak na, “Kope, karep ant eipm amiser. Maken epe ka war yitne aiyiknelel, puikn antilel ka apulp na Sepmel antilel Wulapm Weink ko yekil ninkilapm ntitmaken mitinkel, i ko kil yupul kil yer mintaka Resel nti Leael. Ntiwuye ka mipmakn antilel Israelel, pe ntiwuye ka antunimper ant i ant pie kakir suknim. Pe wopmweink Efratael, yikn ankil kako mesepmel antuel. Pe nia oko somp yikn yer yemp suknel antuel Betlehem. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Wulapm Weink ko yek yipmwuye ninkilapm ntitmaken mitinkel. Pe nti knamniumpuai aiyiknel ko sikir sukn, nuarep nti knamniumpuai Pereselel. Pe Peres ka ninkilapm ntit Juda nti Tamarel. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kapepe Boas nkamp Rut antempil nkupmus, i Wulapm Weink niumuaamikei ntiwuye ampulp'a Boas rap Rut ninkilapm mi ka kil ninkilapmelel. I kapepe kil mira ninkilapm ntit nonkel. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Kapepe nti maken maken yemp suknel Betlehemel napmok na, “Yiki nia Wulapm Weinkel yupulp ntieyarkup aiyiknel pe kil ak yikn na sop ntunkatu aiyiknel nako kil ampu niumuayikei yiknel. Ant aiyimp Wulapm Weink apulp nia sompil yer niampepm antilel Israelel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Pe kona worniumuapm yupul yikn mi wunamp aiyiknel ko yikn yer nkisel arai kil niumuayikei yikn yikei yiripel. Yanikno aiyiknel Rut maken pe ra ninkilapm ntit ekilelel ka puikn apulp yikn yatip. Pe simisimi ka kil sakirp yikn mi kil apulel ka sankork simisimi ka nti 7-pela ninkilapm ntit nako yupulel.” ");
INSERT INTO xbi_y_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Kapepe Naomi nkamp ninkilapm i waimimpipil. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","I nti maken wompitne ekilelel napmok na, “Naomi karep nkamump ninkilapm ntit, kil ka niumpuai ankilel.” Kapepe nia ninkilapm epeel ka nti aiyimpil Obet. Ar mpi i Obet mira Jesi, pe Jesi ka ra Devit. ");
INSERT INTO xbi_y_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Nti moule ka yek Peres la akei Devitel ka piepe. Peres ka ra Hesron, pe Hesron ka ra Ram, pe Ram ka ra Aminadap, pe Aminadap ka waiek Nasonel, pe Nason ka waiek Salmonel, pe Salmon ka ra Boas, pe Boas ka waiek Obetel, pe Obet ka ra Jesi, pe Jesi ka waiek Devitel. ");
INSERT INTO xbi_y_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","10","Apm aiyimp yikn na yikei mampupmompel ser yapmunemp'uretel apmilel. Pe yikn asil apm yapmunemp'uretel yikei ntinkirai ntinkiraiel, sukn pitekn korokn ampu yer. Wulapm Weink, yikn nimpilemp yapmunemp yekipminel apmilel. Pe yikn yek apm yapmunemp niupueiel ntalepeel nako yapmunemp yapelel apmilel ko yintemp yikn yer yeklikeknelel, i apm korokn ampu yumop yipm yapmunemp wuyeel. ");
INSERT INTO xbi_y_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Wulapm Weink, ekeielel apm ka armuai yapmunemp apmilel ampu ka ar nkumur yikn. Moule apmilel ka maiyaknel apulp yapmunemp'uretel apmilel, eti apm ka nimpilemp yapmunemp ntakilelel. Yapmunemp apmilel nimpilemp ntakilelel ka wompwuyepm apmilel ka apm ak yiknel. Pe apm ka nimpiriepmel apulp yikn, moule ka apul nta keielel, yikn'arokn yimpil pmomp ar kilel. ");
INSERT INTO xbi_y_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Wulapm Weink, ka yikn apiser apmel pe, yapmunemp apmilel ka sukukurelim ka kitip amu likekn. Apm kapukorokn nkuwepm yapmunemp'uretel irpm apmilel, yupul na yikn korokn serel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","2","Wulapm Weink ka niawurpmel, mpunkol ankilel ka sukn yatip, kil ka ar niorknel. Kona mouleel yimpilel, kil ko yer nantipil, arai kil niek na “Apm'a nkarkwa yikn. Yikn ka niumuaakei apm, apm nkamp niawurpm yuwa yikn. Apm akei yikn nkael, yikn likekn ka Wulapm Weink apmilel (or: Wulapm Weink ko apm yiki yiknel??).” ");
INSERT INTO xbi_y_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Sank epie ka wat amu ntunk, Wulapm Weink arai niumuayikei yikn. Mpuampua ka ar nkuwepmel kapukorokn yupul yikn milminel. Wule suknel kakorokn somp yikn, arai Wulapm Weink niekyuntup. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Kil arai mpuanink yikn yikei yiripel ntaka aipmutnu ka akei yok ankilel mpuanink siknamp ankilelel. Kil karokn ninkaielelel, yikn ko yer wa Wulapm Weink, ntaka moule ka akei ntumpua lep yenk ka nti akei na yumpilel. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Nompel, yikn'orokn sirkemp muati yupulp setel. Pe awunel, mpuampua ka la na pokel yupul milminel yiknel, yikn'orokn nkinkiekn yupulp. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Yikn kapukorokn sirkemp wule mparimp nompel, pe awun yapelyapel mpuampua simi na ntimpielpm yiknel, yikn korokn sirkemp. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Wulapm Weink arai nikimp nti ensel ankilel ko mpuanink yikn yer oku oku kona yikn yetel. ");
INSERT INTO xbi_y_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Pe arai nti yikei nta nuwomp yikn yupulp na wuntokn korokn yump yikn nkaikel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sank epie ka apulp nti manmakn Jisaselel. Jisas ka ntieyarkup Devitel, pe Devit ka ntieyarkup Abrahamel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ka ra Aisak Aisak ka ra Jekop Jekop ka ra Juda antempel nti es knuan ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ka ra Peres antempel Sera. Mamam ntiwuyeel ka Tamar. Peres ka ra Hesron. Hesron ka ra Ram. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ka ra Aminadap. Aminadap ka ra Nason. Nason ka ra Salmon. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ka ra Boas. Mamam ankilel ka Rahap. Boas ka ra Obet. Mamam ankilel ka Rut. Obet ka ra Jesi. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ka ra moule mamp Devit. Devit ka ra Solomon. Ampueikel mamam Solomonel ka maken Uriael. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ka ra Rehoboam. Rehoboam ka ra Abiya. Abiya ka ra Asa. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ka ra Jehosapat. Jehosapat ka ra Jehoram. Jehoram ka ra Usia. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ka ra Jotam. Jotam ka ra Ahas. Ahas ka ra Hesekia. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ka ra Manase. Manase ka ra Emon. Emon ka ra Josaia. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ka ra Jehoiakin ampueipel nti knuan ankilel. Wank ekilelel nti Babilon ka aimpar nti Israel, nkiyir nti mpi kitapm antuel Babilon, pe nti Babilon nakantup nti na korokn ampu mpi yemp antuel Israel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nti ar Babilonel i, Jehoiakin mira Sealtiel. Pe Sealtiel ka ra Serubabel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ka ra Abiut. Abiut ka ra Eliakim. Eliakim ka ra Asor. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ka ra Sadok. Sadok ka ra Akim. Akim ka ra Eliut. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ka ra Eleasar. Eleasar ka ra Matan. Matan ka ra Jekop. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ka ra Josep. Josep ka minkan Mariael. Maria ka ra Jisas, ka nti aiyimpil Krais, moule ka Wulapm Weink yuwakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nti manmakn ka yek Abraham lala tnei Devitel ka 14. Pe yek Devit lala tnei nti Israel ka ar Babilonel ka 14. Pe yek Babilon lala tnei Kraisel ka 14. Sank epie ka nak apulp nti manmakn Jisasel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sank apulp Jisas Krais ka Maria ra kilel ka ntalekil. Mamam ankilel ka Maria, ka nti antupinta kil na yintemp Josep nkis. Aser ka peyar, Maria karokn antemp Josep nkis aser kil ampu apmot knuamp, kil ninkilapmelim. Apulpaser Pirpm Sepmel Wulapm Weinkel ankil awulmpil i, kil ninkilapmelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aser minkan ankilel Josep kil ka moule akosepm, niumuaipm niluknunel, kil ka nakerpm sankwunamp Wulapm Weinkel ka Moses nakel. Kil eipm aser Maria ninkilapmelim. Eti kil karokn na yupul Maria wule maiyaknel, na nkiyir kil yer niampepm antuel mentitmakenel, karokn. Eti kil na sirkempil nkuwepmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep peyar wunempwaiyimp yayapel kil na yupul sopel. Aser kil ar niumpu ninkiniepmel aser na ensel Wulapm Weinkelel ninkemil nakimpil na, “Josep, moule ntieyarkup Devitel, yikn korokn sirkemp Maria. Ko yikn sompil, ka maken aiyiknel. Yikn ampu eipm apm. Ninkilapm po ar kil lunkoel, ka Pirpm Sepmel Wulapm Weinkelel ankil awulmpil i kil ninkilapmelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kil arai ra ninkilapm ntit, pe nia ankilel ko yikn yimpil Jisas. Niupukn nia Jisasel ka nak na kil arai nantip mua yirkomp nti mentitmaken ankilel, nti ka nkis wunamp'uretelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Ampueikampueikel moule ka nakaworp yapmunemp Wulapm Weinkelel, sank Wulapm Weinkel ka naikul niepm ankilel nak na, Makenel, kil peyar arokn antemp minkan, aser kil ka ninkilapmelim, i ko kil mira ninkilapm ntit. Nia ankilel ko nti yimpilel, Emanuel. (Aisaia 7:14) (Niupukn nia Emanuelel ka nak na Wulapm Weink ka antemp ant ar.) Sank ampueikel, pie ant niampepm nkupmus, pie niminink.” ");
INSERT INTO xbi_y_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep ampu nkarp niumpuel i, kil apul misop sank karep ensel Wulapm Weinkel nakimpilel, i kil nkamump maken ankilel Maria. ");
INSERT INTO xbi_y_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aser Josep karokn ampu rap Maria ninkilapm irpm mpimpi Maria mira ninkilapm ntit. I Josep amiyimpil Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria ra Jisas ar Betlehem ar kitapm antuel Judiael, pe ekilelel Herot ka moule mamp ka awulmp kitapm antuel Judiael. Maria ra Jisas niatel i, nti moule mpurel ka yapmunemp niuluwampenkel, wompitne antuel ka apei yemp peikel awun naelel. Nti la niminink Jerusalem i nti aiyimp naiwulp nti moule ntape na, ");
INSERT INTO xbi_y_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ninkilapm niuwaiknel kana yer ntaka moule mamp aiyipmel Judael, ka mantiek ankilel ra kil ar oku? Ant'a apei yemp antilel, yemp awun nael okor, aser ant amiser nkuaimantump ka ntremp ant apulpil ka nininkel. Eti ant la na nirempil, yiki nia ankilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Moule mamp Herot antempel nti ntitmaken Jerusalemel akeiwanto eipm sank ekeielel, nti ka numpul ampulp. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eti Herot aiyimp nti moule mamp antuel prisel amposel nti moule wupm raiel Judael, nti ko la ser kil. Nti naiyenaiye la apmuei likekn i kil namikimp nti na, “Yipm ka ntinkirai apulp Krais, moule ka Wulapm Weink yuwakel. Eti yipm nikimp apm, ko mantiek ankilel ra kil yer wamp antu?” ");
INSERT INTO xbi_y_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eti nti ampu nakimpil na, “Krais arai ninink yer Betlehem ka ar Judia. Ampueikampueikel moule ka nakaworp yapmunemp Wulapm Weinkelel apul sank sil wupm nak ntalekil na, ");
INSERT INTO xbi_y_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yipm Betlehem, yipm ka nia nkampel, yemp aiyipmel ka akopitekn aser nia nkamump yipm. Ar yemp suknel irpm Judiael yipm Betlehem ka ar niorknel. Nia nkamp yipmel ka apulp na mewel aiyipmel arai yer ntaka moule mampel. Kil ko yuwulmp nti mentitmaken Wulapm Weinkel ka ar Israelel.” (Maika 5:2) ");
INSERT INTO xbi_y_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pe nti mesepmel Judael karep mpim i, Herot akei mitiknel mper sank nankimp nti moule, yemp antuel ka ar yakitie awun naelel, na nti ko la ser kil nkuwepm. Nti la i kil aiyimp naiwulp nti aipopel na, “Atik yipm aser nkuaimantump epe naikulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I kil nak na, “Yipm mpi yuwup ninkilapm opo aipopel. Kona yipm ser kilel i ko yipm ampu pokel la ninkimp apm, nako apm mpi nirempil, yiki nia ankilelel.” Kapepe kil wankes nti mpim Betlehem. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nti eipm Herot nakimp nti sank niatel i, nti mpim. Nti ampu amiser nkuaimantump epie ampueik nti aser ar yemp antuel awun naelel. Nkuaimantump epe ka ar niorknel ntimiremp nti yayapel, mpi tnei nimisinkerpm yitne ka ninkilapm niuwaiknel arel. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nti aser nkuaimantumpel, yapmunemp antuel ka mpuaimpuai yatip. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nti war yitne i nti amiser ninkilapm amposel mamam ankilel Maria. I nti waker kaikyimpo eip kitapm namiremp ninkilapm, i nti aimiki nia ankilel. Nti siknin rumpunk antuel i nti amuk kil mpuampua sepmel mpurel. Nti ak kil wuntokn raiel irpm (gol), amposel mpuampua irpm ka wuyepm sepmel naikiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Niatel i, Wulapm Weink akei ninkiniepmel nankimp nti na, “Yipm'orokn ampu mpi ser Herot.” Eti nti ampu ka sop yayapel yatelel mpim yemp antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nti moule yemp antuel awun naelel karep apmot, aser Wulapm Weink wankes ensel ankilel akei ninkiniepmel nankimp Josep na, “Yikn serp somp ninkilapm yintempel mantiek ankilel, kua nti serk mpim Isip. Yikn kako yer mpi Isip mpimpi ser ko apm ampu ninkimp yikn sank. Apulpaser Herot kana nikimp nti moule napolel ankilel na yuwup ninkilapm epe na yer kil wuntu.” ");
INSERT INTO xbi_y_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kapepe Josep nkarp nomp wainki i, kua nti maken ninkilapm ankilel nkark mpim yemp peikel Isip. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep nti ka ar Isip mpimpi i, Herot amur. Ka sop sank ampueik moule ka nakaworp yapmunemp Wulapm Weinkelel nakel, ka pie niminink. Ka kil nak na, Ninkilapm ntit apmilel ka ar Isipel, apm aiyimpil na yuwomp Isip yer, kil la. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Moule mamp Herot arep nkamp ntinkirai ampulp nti moule yemp awun naelel epe ka nti ninkai kilel, eti yapmunempil ka kuret kuret ankil. Kapepe i, kil wunempwaiyimp ampulp atik ka nti nakimpil nti aser nkuaimantump naikulel i, kil wankes nti moule napolel ankilel mpim Betlehem antempel nti wompitne ka ar kitnan nantip Betlehemel i, nti amor nti ninkilapm ntit ntit ka niuwaiknel peyar karokn wank wuyeelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mpuampua epe nininkel ka sop sank Wulapm Weinkel, ampueik Jeremaia, moule ka nakaworp yapmunemp Wulapm Weinkelel, nakel. Kil nak na, ");
INSERT INTO xbi_y_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nti akei warawur, sa nimpi muakupm suknel ar yemp suknel Rama. Ka Resel saiyip nti ninkilapm ankilel ka awurel. Nti ninkilapm ankilel ka awur miniatim. Eti yapmunemp ankilel, kil karokn apulp na nti na yum wakerpil yer. (Jeremaia 31:15) ");
INSERT INTO xbi_y_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep ar Isipel i, Herot amur, Wulapm Weink wankes ensel ankilel akei ninkiniepmel nankimp Josep ");
INSERT INTO xbi_y_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nak na, “Yikn serp, kua maken ninkilapm aiyiknel ampu mpim Israel. Moule kana yer ninkilapmel ka amur.” ");
INSERT INTO xbi_y_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kapepe, Josep kua nti maken ninkilapm ankilel ampu mpim Israel. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aser Josep yupmueipm sank na Arkelaus ampu nkamump yemp waiek ankilel Herotel, kil ka awulmp nti ka ar kitapm Judiael. Eti Josep nkinkiekn ampulp na mpi yemp ekilelel. Aser Wulapm Weink akei ninkiniepmel nankimp Josep, i Josep mpim kitapm Galili. ");
INSERT INTO xbi_y_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kil mpi nkupmus yempel ka nti aiyimp Nasaretel ka ar kitapm Galiliel, apulp nako sop sank ampueik ka moule nakaworp yapmunemp Wulapm Weinkelel nakel. Kil nak na, Kapuko nti yimpil moule Nasaretel. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","4","Ampueikampueikel Wulapm Weink ka nak sank ar niepm mouleel ka nakaworp yapmunemp Wulapm Weinkelel, nia ankilel ka Aisaia. Kil nak na, Ar yemp kuserel moule karokn arel, mewel oko yikei sank suknel niek na, Sepmel aiyipmel pewipm, yipm ntimpramp yapmunemp, nkrak yayapel na kil yetel. (Aisaia 40:3) Sank ekeielel ka nak apulp Jon Baptaisel ka niminink. Jon ka atnu elmpuapm niurkutupel, ka kil akei niol kamelel apulel. Pe wusaikn ka nkunkurarel ka kil antun i akei antup mintompel. Niepm ankilel ka kil alel, ka kil al milmp niupukn wurun soel antemp wusol. Aninkel, Jon Baptaisel la i kil ar yemp kuserel moule karoknelel ka ar kitapm Judiael, i kil wat sank namikimp nti mentitmaken ka sopil la opo. Kil nak na, “Yipm nisep sankwunamp'uretel, yipm nimplemp yapmunemp, pitepiteknim Wulapm Weink oko yumulmp ant.” ");
INSERT INTO xbi_y_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kapepe i, nti Jerusalemel, nti Judiael antempel nti wompitne ka ar kitnan nantip pukn Jordanel, nti la amiser Jon. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I nti nak amorp yapmunemp'uretel ka nti apulel i Jon rup nti amu mpep apmuei pukn Jordan. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon aser nti Farisi antempel nti Sadyusi mitinkel pe la na ser kil na rup nti yo mpepel, i kil nakimp nti na, “Yipm aser apmel, ka yipm akei wuleaikn ninkai apmel. Yapmunemp aiyipmel ka wieel. Ka mini nakimp yipm, pe yipm na la epieel? Yipm'a waiyimp yapmunemp ntinkiliempel Wulapm Weinkel mi? ");
INSERT INTO xbi_y_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kona yipm'a nimplemp yapmunemp likeknelel, ka akosepm. Aser yipm kapuko yupul wunamp sepmel nako ntremp ant miser nana yipm ka nimimpilemp yapmunemp. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yapmunemp aiyipmel, yipm wunempwaiyimp na Wulapm Weink kakorokn yump yipm. Yipm nakel na, Abraham ka milman antilel ka Wulapm Weink nkampil niorknel. I kapepe, Wulapm Weink kapukorokn yump ant apulpaser ant ka ntieyarkup Abrahamel. Aser karokn. Apm nakimp yipm likeknel, ntieyarkup Abrahamel karokn mpuampua suknel ar niampepm Wulapm Weinkelel nako yipm yikei Abraham nkaelel, karokn. Kona Wulapm Weink puiknel, kil ko nimplemp wuntokn ankil ampu na nisam nti moule niumpueiel nako ntieyarkup Abrahamel. Kona ntakilelel, yipm korokn wunempwaiyimp na milman aiyipmel Abraham ko yupul yikn na yer sepmel yer niampepm Wulapm Weinkel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wulapm Weink ka awup nti moule ka sop sank ankilel i nkis wunamp sepmelel, nti ka nuarep lo ka rukopm naker mitinkelel. Koroknel, pitepiteknim Wulapm Weink arai yikei elmp ankilel ka kil ntimprampel, mpuar nti yawol yo yite. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Apm'a rup yipm yo mpepel, ka muati apulp nako nti ser yipm ntape na yipm ka nimimpilemp yapmunemp. Aser moule sepmel ko sop apmel, kil arai yupul niokn yikei Pirpm Sepmel Wulapm Weinkel yintempel yite, nako sukul yipm nuarep kil rup yipm a mpepel. Niawurpm ankilel ka sankork apm. Niokn apm apulel, nia kapukorokn somp apm apulp na apm ka moule kuserel, pe nia arai sompil no keipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kil ko la yupul niokn nuarep moule ka antun rukopm witel i, niupukn ankilel arai kil yum yo rumpunk mper, pe aikn ankilel ko kil sompwat yo yite ka ar yeklikeknelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ekilelel i, Jisas nkarp yek Galili mpim pukn Jordan. Kil mpi aser Jon i nakimpil na, “Yikn rup apm yo mpep.” ");
INSERT INTO xbi_y_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aser Jon nak nkiyir kil na, “Apulntaku pe yikn la aiyimp apm na rup yikn yo mpepel? Akosepmel kako yikn yupulp apm pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aser Jisas ampu nakimpil na, “Karokn. Kako yikn yupul nta pie apm nakel pe. Niokn epie kako sop puikn Wulapm Weinkel, apulp yapmunemp sankwunamp sepmel wantoel ko ant yupulel.” I Jon apul misop sank ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kil rup Jisas a mpep niatel i, Jisas ampu pokel nkarp apmot keipm. Kapepe mpor keipm amikor, i kil amiser Pirpm Wulapm Weinkel ka nuarep aipm mpuknel lilil a misil kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kapepe nti yupmueipm sank ka Wulapm Weink nak naikul mpor pminel, ka nak na, “Kil epe ka ninkilapm apmilel, apm ka apulpil yatip. Yapmunemp apmilel ka mpuaimpuai apulpil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ekilelel i, Pirpm Wulapm Weinkel apul Jisas mpim yemp kuserel moule karokn arel, apulp na Satan na waker kil yapmunemp na kuapil na yupul yapmunemp'uretelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nompawun Jisas nakantup niepmel ka awun 40-plael i, nilmp amor kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kapepe, Satan la aser kil i nakimpil na, “Kona yikn ka ninkilapm Wulapm Weinkelel, yikn nimplemp wuntokn epe na nisam luwu ntintir.” ");
INSERT INTO xbi_y_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aser Jisas ampu nakimpil na, “Sank ka sil wupm Wulapm Weinkelel, ka nak na, Sank Wulapm Weinkel arai yek nti mentitmaken mintenk. Niepm likekn kakorokn yek nti mintenkel. Karokn.” (Lo 8:3) ");
INSERT INTO xbi_y_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kil nak ntape i, Satan ampu kua kil mpim Jerusalem la yitne suknel Wulapm Weinkel. Satan apul Jisas na misil yitne keipm keipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","I Satan nakimpil na, “Kona yikn ninkilapm Wulapm Weinkelel, yikn yukur yo kitapm. Apulpaser sank ka sil wupm Wulapm Weinkelel ka nak na, Kil arai nikimp nti ensel ankilel oko somp yikn sil nta antuel, apulp na wuntokn korokn yump yikn nkaik.” (Buk Song 91:11-12) ");
INSERT INTO xbi_y_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aser Jisas nakimpil na, “Sank ka sil wupm Wulapm Weinkel ka nak antempel na, Wulapm Weink ka niawurpmelip. Yikn korokn timpielpil” (Lo 6:16) ");
INSERT INTO xbi_y_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kapepe Satan ampu kua Jisas mpi namp malenk suknel ka na keipmel at yapel. I kil ntimirempil wopmweink mitinkel ka nuapropm kitapm sukurelel, antempel mpuampua sepmel mitinkel antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I kil nakimp Jisas na, “Kona yikn waker nkaikyimpo eip kitapm i yiki nia apmilelel, arai apm yek yikn mpuampua irpm epe sukurel ka yikn aserel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","I Jisas nakimpil na, “Satan, yikn nisipm. Sank ka sil wupm Wulapm Weinkelel ka nak na, Kako yikn yiki nia Wulapm Weinkel likekn, kil likekn ka sepmel aiyiknel.” (Lo 6:13) ");
INSERT INTO xbi_y_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Eti kil awomp Jisas apmot, pe nti ensel la i wakerpil. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Jisas eipm aser, nti mper Jon apmuei yitne kuretel, i kil awomp yemp suknel Nasaret apmuei. Kil mpim yemp suknel Kaperneam ka ar Galiliel, nti ka nkis sop mpepwarmp mita ar Galili. Kitapm pe nti nkisel, ka ampueik wopmweink antuel nti Sebulun antempel nti Naptali nkisel. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","17","Ka sop sank ampueik Wulapm Weink akei niepm Aisaiael nakel, kil nak na, Nti Sebulun antempel nti Naptali, kitapm antuel ka ar Galili ar yipek yakitie pukn Jordanel. Nti ka sil sop yayapel suknel ka mpi mpepniopmel, pe nti moule wampwamp mitinkelel ka nkis pepe. Nti mentitmaken Sebulun nti Naptaliel ka ar nkis kukokukoel. Aser Wulapm Weink arai yupul yapmunemp antuel na yer mpilil ntinkiraiel (Aisaia 9:1-2) Jisas ka apei Kaperneam, kil ka nakimp nti mentitmaken sank Wulapm Weinkel. Kil nak na, “Kona yipm'a yer nta Wulapm Weinkelel ka piepe, yipm nimimpilemp yapmunemp nisep sankwunamp'uretel apulpaser Wulapm Weink pe kitnanim, kil kana yumulmp yipm.” Kil apul ntakilelel i, Wulapm Weink apul sank Aisaiel pie niminink. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas sop mpepwarmp Galili mita amu i, kil amiser ntiwuye es knuanel Saimon, nia kitie ankilel ka Pita, antempel knuan ankilel Andru. Ntiwuye apul niokn wuntokn akei ntoknpuank nkamp yokn ar mpepwarmp. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas la nankimp ntiwuye na, “Yipmwuye la sop apm. Arai apm ntremp yuwap yipm yayapel nako yipm somp nti moule yimp nti na sop apmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kapepe, arokn akir, ntiwuye nisep ntoknpuank nkupmus, ntiwuye po mpi misopil. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas mpimpi aser, kil ampu amiser ntiwuye es knuanel nonkel Jems nti Jon antempel waiek antuel Sebedi. Ntiarko pe sil wutumpepel i awomp ntoknpuank ka kakirel. I kapepe Jisas amiyimp ntiwuye, ");
INSERT INTO xbi_y_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","i karokn akir, ntiwuye nisep waiek ntiwuyeel sil wutumpepel apmuei, ntiwuye po mpi misop Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas at aser nti akeiwanto ka ar kitapm Galiliel, i kil muar yank Wulapm Weinkel irpm antuel i yumuap nti ntitmaken sank sepmel apulp Wulapm Weink kana yuwulmp ntiel yer nta ankilelel. Nti mentitmaken ka wule simisimi apul nti kuretelel, kil ampu apul nti sepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nti ntitmaken ka ar kitapm Siria sukurel eipm sank ampulp Jisas. Kapepe nti wampwampel apul nti moule ka wule simisimi apul ntiel la amiser kil. Nti moule ka nkamp yakop suknelel, antempel nti moule ka muanumpor yanker ar ntiel, antempel nti moule ka mpienyukurel, antempel nti moule ka ntankaik awurel, nti akeiwanto mila. I Jisas ampu apul nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pe nti moule mentitmaken mitinkel ka nkarp ar Galili, Dekapolis, Jerusalem, Judia, antempel nti yemp ka ar yek yakitie pukn Jordanel, nti ka sopil. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas aser nti mentitmaken mitinkel arko lael i, kil po mpi namp malenk. Nti moule ka sopilel la ser kil, ");
INSERT INTO xbi_y_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","i kil yumuap nti sank, nak na, ");
INSERT INTO xbi_y_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nti moule ka wunempwaiyimp na nti ankil karokn mintenk na sop yayapel Wulapm Weinkelel, kil ka mpuaimpuai apulp nti, kil ka apul nti sepm. Nti ka ar nta ankilel apmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nti moule ka ar antemp nimpiel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm. Kil arai wakerp nti yer. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nti moule ka ar niuluknun mi, karokn aiki nia antuel na keipmel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm. Kil arai yek nti kitapm sukurel yer nta antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nti moule ka puikn apulp na nti na yer nkis wunamp sepmel suwainkelel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm. Arai kil yupulp nti sukn sop puikn antuel epieel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nti moule ka akei nainkerp nti moule yatelel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm. Kil arai yikei nainkerp nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nti moule yapmunemp antuel ka ntinkirai ntinkiraiel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm i, niampepm antuel arai nkupmus Wulapm Weink. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nti moule ka aikli nti ka napol nukuapmel, Wulapm Weink ka mpuaimpuai apulp nti, kil ka apul nti sepm. Kil arai yimp nti ninkilapm ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nti moule ka nakerpm wunamp sepmel mi nti nkamp yakop apulpel, Wulapm Weink ka mpuaimpuai apulp nti. Nti ka antempil ar nta ankilel ar sepmel apmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kona nti moule ser yipm ka ar yakitie apmilel i, nti nak mpuliep yipmel, apul nia aiyipmel a kitapm i wakerkikaik yipmel, Wulapm Weink ka mpuaimpuai apulp yipm, kil apul yipm sepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wankepm epe yipm ninkemel ka soplikekn ka ampueik ninkem nti moule Wulapm Weinkel ka nakaworp yapmunemp ankilelel. Eti ekeielel yipm ko yer yintemp mpuaimpuai, yapmunemp niuluknunel, apulpaser Wulapm Weink arai yupulp yipm waperel yer yemp sepmel ankilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas ampu nak na, “Yipm ka nuarep niopm ka apul niepm i sinkenel. Aser kona niopm ka silmpenkel, ko ant yupul ntakulel ko niopm ampu sinkenel? Niopm ka ntakilelel ka kuretim, kapuko nti moule nimprip i yikei nkaik simile. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yipm ka nuarep yitelienk ka lep yayapelel. Nti ko ser yipm yukorpel ntaka yitelienk ka ar yemp suknel ar na malenk keipm i ka lep nti akei aelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pe nonkel, nti moule karokn nukup yite mi akei marpm awulmp nkis kitapmel. Karokn. Ka nti yuwol mpimp keipm, nako yuntun ntinkrienel yempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kapepe sankwunamp aiyipmel kako sepm suwaink yer niampepm antuel mentitmakenelel. Kona nti ser sankwunamp sepmel aiyipmel ntakilelel, nti ko yimiki nia waiek aiyipmel ka ar na yemp keipmelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas ampu aiki nak na, “Sank niawurpmel Wulapm Weinkelel ka Moses ak yipmel, antempel sank ampueik ka nti moule Wulapm Weinkel nakaworpel, yipm korokn niek na apm la nakimp yuwap yipm nako antarko yikei pmompel sank irpm opo na yikei nisepel. Karokn. Ka apm'a niek simpop sank niawurpmel sukurel nako yer mintenkel. Apm ankil ko yupul niupukn sank niawurpmelel ko niepm ankilel nikerel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Apm nakimp yipm likeknel, yitomprai sukn pitekn ka nti akei ar sank niawurpmelel sukurelel kakorokn niat niorkn. Karokn. Aser kona niepm sukurel sank niawurpmelel niker niatel, i kapepe kitapm sukurel ko miniat. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kona mewel niek na, Sank niawurpmel epe ka mpuampua akopiteknel i kil na kuap nti wanto na yupul soplikeknel, arai kona Wulapm Weink yuwulmp antel, moule epe nia ankilel kapukorokn yer sukn, kako yumu kitapm. Aser kona mewel yupul sop sank niawurpmel i ntremp nti wanto na nti yupulel, kona Wulapm Weink yuwulmp antel, moule epe nia ankilel arai yer sukn. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Apm nakimp yipm, kona yipm wunempwaiyimp na yipm'a war yer nta Wulapm Weinkelel, sankwunamp aiyipmel kako sankork nti moule wupm raiel antempel nti Farisi. Na koroknel, yipm'orokn war.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas ampu aiki nak na, “Sank niawurpmel Wulapm Weinkel ka Moses nakimp nti manmakn aiyipmelel ka yipm yupmueipm. Ka nak na, Yipm'orokn yer mewel wuntu. (Kisim Bek 20:13) Nti manmakn nak na kona yikn yer mewel wuntuel, yikn ko yet niampepm antuel moule lowulaelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wupm Wulapm Weinkel ka nak ntapepe, aser apm'a nikimp yipm walimp na, Kona yikn yintemp mamintomp aiyiknel nukuapmel, kako soplikekn, arai yikn yet niampepm antuel moule lowulaelel. Pe kona yikn niek mamintomp aiyiknel sank kuretelel, yikn ko yet niampepm moule mamp antuel nti lowulaelel. Pe kona yikn nikimp mamintomp aiyiknel na kil ka nipel munuelel, yikn'o yikei wunempel. Kona yikn yupul yupulel, yikn arai mpi yemp yiteel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kapepe, kona yikn'a yupul mpuampua aiyiknel mpi na yek Wulapm Weink sil lowaimp wompwuyepmelel, aser yikn wunempwamiyimp wankepm aiyiknel ka nkis antemp mewelel, ");
INSERT INTO xbi_y_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","i sukur ko yikn mper mpuampua aiyiknel mpi peik, pe yikn mpi yintempil niek sank yum yapmunemp yo likekn. Niatel i, ko yikn mpi yumuk Wulapm Weink mpuampua misil lowaimp wompwuyepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mewel kana yintemp yikn niek sank yupulp wankepm ka yikn apulpilel, yikn ko pokel mpi ser kil i niek sank yum yapmunemp yo likekn, yupulp na sank yuwurel. Koroknel, moule epe arai mper yikn mpi nta masistretel i masistret arai mper yikn mpi nti moule aipmpienel, pe nti moule aipmpienel arai mper yikn war yitne kuretel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Apm nakimp yipm, yikn ko yer yitne kuretelel, kapuko yikn yer sop wuntokn muati ka nti nak apulp na yikn'a yikei yupulp wankepm ka nkis yiknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas ampu nak na, “Sank niawurpmel Wulapm Weinkel ampueik ka Moses ak yipmel ka yipm yupmueipm. Ka nak na, Yipmntitmaken'orokn yupul tniompreimp. (Kisim Bek 20:14) ");
INSERT INTO xbi_y_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wupm Wulapm Weinkel ka nak ntapepe, aser apm'a nikimp yipm walimp na, kona yikn ser makenel i yikn yikei yapmunemp aiyiknel waiyimp na yikn'a sompilel, ka ntaka yikn akei moule apul tniompreimp amintemp maken epe. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kapepe, kona niampepm yapelel aiyiknel kuap yikn'a yupul setel kuretelel i, ko yikn ye sompwat. Yikn yikei niampepm likeknel yer nako yikn yer sepmelel. Koroknel, yikn arai yupul moule aiyiknel sukur yintempel niampepm wuye mpi yemp yiteel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pe kona ntayapelel aiyiknel kuap yikn'a yupul setel kuretelel, yikn yuntun sompwat. Yikn yikei nta likeknel yer nako yikn yer sepmelel. Koroknel, arai yikn yupul moule aiyiknel sukur yintemp nta wuye mpi yemp yiteel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas ampu nak na, “Sank niawurpmel Wulapm Weinkel ampueik Moses ak yipmel ka yipm yupmueipm. Ka nak na, Kona yikn'a nkiyir makenel, yikn ko yek kil wupm ka nak apulp maken karep yikn nkiyir kilel. (Lo 24:1-4) ");
INSERT INTO xbi_y_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wupm Wulapm Weinkel ka nak ntapepe, aser apm'a nikimp yipm walimp na, kona maken aiyiknel, ampueikel kil karokn antemp mewel apul tniompreimpelel aser yikn nkiyir kil puikn aiyiknel, ka yikn ankil ka waker sank niawurpmel Wulapm Weinkel. Yikn nkiyir kil niatel, nako maken epe yintemp minkan niumpueielel, kil ka antemp moule epe apul tniompreimp. Weink ka ar minkan niorknel ankilel karep nkiyir kilel. Pe kona mentit somp maken ampueik mewel nkiyirel ka soplikekn. Kil ka waker sank niawurpmel, apulp maken ka antemp minkan nkisel. Pe kil ka antemp maken epe apul tniompreimp.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas ampu nak na, “Pe sank niawurpmel nonkel Wulapm Weinkelel ampueik Moses ak nti manmakn aiyipmel i pie yipm eipmel ka ntalekil. Kona yikn niek mi niawurpm yuwa sank aiyiknel ka likeknelel, yikn korokn niek kuserel. Ko yikn yupul likeknel misop sank ka yikn nak ar niampepm Wulapm Weinkel. (Namba 30:2) ");
INSERT INTO xbi_y_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wupm Wulapm Weinkel ka nak ntapepe, aser apm'a nikimp yipm walimp na, yipm'orokn somp setel niek niawurpm yuwa sank aiyiknelel. Karokn. Yipm korokn yikei nia yemp sepmelel niek likeknel niawurpm yuwa sank aiyiknel. Apulpaser yemp sepmel ka lontulnko sepmel Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pe yipm korokn yikei nia kitapmel niek likeknel niawurpm yuwa sank aiyiknel. Apulpaser kitapm ka yemp ka Wulapm Weink wul nkaik ankilel silel. Pe yipm korokn yikei nia Jerusalem niek likeknel niawurpm yuwa sank aiyipmel. Apulpaser Jerusalem ka yemp suknel ankilel moule mamp niorknelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pe yikn korokn yikei mamniol aiyiknel niek niawurpm yuwa sank aiyiknel. Apulpaser mpunkol aiyiknel kapukorokn nimplemp mamniol likekn aiyiknel ka erpmelel ampu mpi yonel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ko yipm niek na, kope mi arokn mi. Ntapepe. Sank irpm yatel ka yipm nak apulp na mintenkitneip yipm sankel, ka Satan ankil aiki yapmunemp aiyipmel i yipm napmok.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas ampu nak na, Sank niawurpmel nonkel Wulapm Weinkelel ampueik ka Moses ak nti manmakn aiyipmelel, ka yipm yupmueipm. Ka nak na, Kona mewel ye yikn niampepmel, yikn ko ye kil niampepm waperel. Pe kona mewel waker yikn nainiunkuel, yikn ko waker kil nainiunku waperel. (Kisim Bek 21:24) ");
INSERT INTO xbi_y_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A Wupm Wulapm Weinkel ka nak ntapepe, aser apm'a nikimp yipm walimp na, kona mewel na yupul yipm kuretel, ka yipm korokn yupulpil waperel. Karokn. Kona mewel na mutump nkuntomp niampepm yimpil yipmel, ko yipm ser yikei yuwompel, yer nkis niuluknunel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pe kona mewel na yintemp yikn niek sank yer niampepm antuel moule lowulaelel i na somp elmpuapm ka yikn atnuelel, yikn korokn nirknimp. Ko yikn somp elmpuapm ka yikn nar awulmp wolpmel, yek kil elmpuapm wuye yintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kona mewel na yintemintenk yikn na sakirpil ntokwankepm mpi yemp kitnanelel, kako yikn ampu sakirpil mpim yemp peikel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pe kona mewel na nikimp yikn yupulp setel na somp kuserelel, yikn korokn nirknimp. Pe kona mewel yimp yikn na yek kil setelel na arai kil ampu yek yiknel, ko yikn yek kil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas ampu nak na, “Sank niawurpmel Wulapm Weinkel ka ampueik Moses ak yipmel, ka yipm yupmueipm. Ka nak na, Nti moule ntieyarkup aiyiknel, ko yikn wunempyupulp nti i yupul nti sepmel. (Wok Pris 19:18) Pe nti manmakn aiyipmel nak walimp nak na nti wantome, karokn. Yipm korokn wunempyupulp nti. Nti ka moule wuroknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nti ka nak ntapepe, aser apm'a nikimp yipm ntinkirai na, yipm ko yikei nta niupuknel nkrawomp nti moule wuroknel aiyipmel, pe yipm ko yintemp Wulapm Weink niek sank yimpil yupulp na kil wunempyupulp nti moule ka apul yipm kuretelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kona yipm yupul ntakeielel, yipm kako ninkilapm Waiek Keipmelel, apulp na sankwunamp aiyipmel ka sop sankwunamp ankilel. Kil ka apul awun akorp ar na keipm nako lep nti moule sepm kuret sukn akoel. Antempel wutnie ka kil apul awulmp nti moule akeiwanto sepm kuret sukn ako. Sankwunamp aiyipmel kako soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kona yipm yikei nta niupuknel aiyipmel nkrawomp nti moule ka apul yipm sepm mi yapmunemp aiyipmel ka puikn apulp nti likeknel, yipm korokn niek na Wulapm Weink ko ampu yupul yipm sepm waperel, kapukorokn. Pe ka nti moule kuretel ka nkampop yikn wuntokn ak moule mamp antuel Romel, nti ka apul soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pe kona yipm niek niremp nti moule ntieyarkup aiyipmel likeknel, ko yipm sankork nti moule kuretel epe ntakulel? Karokn. Nti moule ka ar kurieknel, nti karokn sop Wulapm Weinkel, nti ka apulp nti meniem antuel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yipm moule ntitmaken ko sop Waiek aiyipmel ar na yemp keipmelel. Sankwunamp ankilel ka sepm sepm suwaink. Yipm kako soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas ampu nak na, “Yipm ko yikei wunempel yupulp sankwunamp aiyipmel ka yipm ar nkisel. Yipm korokn yupul yer niampepm antuel mentitmakenel na nti ser. Kona yipm yupul yer niampepm antuel ntakilelel, Waiek Keipmel kapukorokn yupul yipm sepm waperel yupulp niokn yipm apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kona yipm'a yek nti kuretako mpuampuael, yipm korokn yiki nia aiyipmel yikei mampel niek sank nuarep nti moule ka akei wule kurieknel ninkai ntiel. Nti ka atorp sank at yayapel antempel yank Wulapm Weinkelel apulp na ntremp nti wanto wunamp sepmel antuel, nako nti ntitmaken yuntun nia sepmel yimp ntiel. Apm nakimp yipm likeknel, nti moule epe nia suknel nti apulpel karep nti nkamp wamperel. Araiel Wulapm Weink kapukorokn ampu yupulp nti sepm waperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yikn'a yupulp nti kuretako ntakilelel, ko yikn yupul nkuwepm, nti moule korokn ser ka yikn apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kona yikn yupul ntakilelel, niokn ka yikn wunempapulp nti mi yikn apulel ko yer nkuwepm. Waiek Keipmel ka aser niokn sepmel ka yikn apul nkuwepmelel, arai kil yupulp yipm waperel niokn ka yipm apulel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas ampu nak na, “Kona yipm'a yintemp Wulapm Weink niek sankel, yipm korokn yupul nuarep ka nti moule ka akei wule kurieknel apulel. Nti ka puikn na kona nti yintemp Wulapm Weink yikei mampel niek sank yer yayapel nakurepm yintempel yank Wulapm Weinkelel, i ko nti moule ser ntiel. Apm nakimp yipm likeknel, nia sepmel nti puikn nako somp ntiel, karep nti nkamp apmuei niampepm antuel mouleel. Wulapm Weink korokn ampu yupulp nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aser kona yikn'a niek sank yintemp Wulapm Weinkel, yikn likekn war yitne yael ka ar yitne aiyiknel pminel i, ko yikn likekn yintemp Waiek Keipmel niek sank nkimepm. Waiek Keipmel ka aser niokn sepmel ka yikn apul nkuwepmelel, arai kil yupulp yikn waperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pe kona yipm'a yintemp Wulapm Weink niek sankel, ka yipm korokn kuap sank mpeikn nkis yikei niek niekel nuarep nti moule ka tupualimp wulapm kitapmel antuelel apulel. Nti ka nak na kona nti niek sank kuap mpeikn mpeiknel, wulapm antuel oko yupmueipm nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka yipm korokn yupul sop ka nti apulel. Yipm peyar karokn nak sank aiyimp Waiek Keipmel apulp setelel, aser kil karep aser amorel mpuampua irpm ka yipm aroknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kona yipm'a yintemp Wulapm Weink niek sankel ko ntalekil. Waiek antilel ka ar na yemp keipmelel, nia ntinkiraiel aiyiknel ko yer niorknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Apm aiyimp yikn ko pokel somp yemp moule mampel. Ko ant nikerpm sank aiyiknel sukurelel yer kitapmel ntaka nti ka ar na yemp keipmel ka nakerpm yikn aninkaninkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pe ant aiyimp yikn na yek ant niepm yupulp awun ekeielelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pe yapmunemp'uretel antilel ko yikn wunempiskel sop ka ant wunempiskel yapmunemp'uretel antuel wantoel ka nti apulp antel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yikn korokn yikei niampepm ser setel kuretel ninkem ant. Ko yikn mpuanink ant yupulp na Satan korokn kuap ant na yupulp ant ntalekil. Akosepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yipm eipm, kona yipm wunempiskel yapmunemp'uretel antuel ka nti apulp yipmel, Waiek aiyipmel ka ar na yemp keipmelel ko wunempiskel yapmunemp'uretel aiyipmel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aser kona yipm korokn wunempiskel yapmunemp'uretel antuel mentitmakenelel, Waiek Keipmel kapukorokn wunempiskel yapmunemp'uretel aiyipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas aiki nak na, “Kona yipm nkis nailep yupulp yapmunemp aiyipmel ko yer mintenk yintemp Wulapm Weinkel, mpuaniampepm aiyipmel korokn yuwol ntaka nti moule ka akei wule kurieknelel ka apulel ko nti ntitmaken ser nti yukorpel ntaka nti ka nkis nailepel. Apm nakimp yikn likeknel, nia sepmel antuel nti puiknel, karep nti nkamp apmuei kitapm epie. Araiel Wulapm Weink korokn yiki nia antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aser yikn, kona yikn nkis nailepel, yikn korokn nar yipmamp no nta ");
INSERT INTO xbi_y_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nako nti moule korokn ser yuworel na yikn'a nkis nailepel. Yikn ko asil wule yikei yetel. Waiek aiyiknel ka ar nkuwepmel, kil likekn ko ser yukorpelel. Niokn sepmel ka yikn apul nkuwepmel, Waiek aiyiknel ka ar na yemp keipmel karep amiser. Kil arai yupulp yikn waperel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Jisas aiki nak na, “Yapmunemp aiyipmel kakorokn yer sukn yintemp mpuampua kitapmel. Apulpaser kona yipm mper mpuampua mitinkelel, nti kapukorokn yer sepmel yerelel, arai neipm yikei, wutekwutnu waker, arai nti mewurkite somp. Pe kona yapmunemp aiyipmel yer sukn yintemp Wulapm Weink ka ar yemp keipmelel, yipm kapuko yer sepmel yupmueiel. Yapmunemp ntakilelel ka nuarep mpuampua sepmel kona yipm mper yikei yiripelel, mi ko neipm korokn yikei, wutekwutnu korokn yuntun pe nti mewurkite kakorokn sompel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mpuampua mi ka yikn apulpel ka ntremp nti wantosukurel apulp yapmunemp aiyiknel. Wulapm Weink ka ar niorknel mi mpuampua kitapmel ka ar niorknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jisas aiki nak na, “Niampepm aiyiknel ka nuarep yite ka lep wunamp aiyiknelel. Kona niampepm aiyiknel akosepm mpilil tinkirienel nako yikn niampepm yuntup Wulapm Weink aninkaninkel, eti yikn ko ser yuworel wunamp aiyiknel ka yikn ankil ar nkisel. Aser kona yapmunemp aiyiknel ka ar peikelel, ka nuarep niampepm aiyiknel peyar tukulpmel. Ka ntaka yikn at yemp nimpiempelel, yite karoknel. Wunamp aiyiknel ka yikn ar nkisel yikn kapukorokn ser yuworel. Pe kona yite Wulapm Weinkel ka ar yapmunemp aiyiknelel nukurkel, yapmunemp aiyiknel kako nimpiempelim. Eti ko yikn ser yuworel wunamp irpm ka yikn ar nkisel ntakulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas aiki nak na, “Mewel korokn eipm sank moule mamp wuyeel yentikekn yupul sop, nonkel arai kil yikei pmomp yer, kil arai sop nonkel. Likekn ko yer niorkn, nonkel ko yer nkien. Ntiwuye kapukorokn yer soplikekn yer yapmunempel. Ka muati apulp yapmunemp mouleel kakorokn yer wuyeel. Kona Wulapm Weink yer niorkn yer yapmunempel, wuntokn raiel irpm ko yer nkien. Wulapm Weink yintempel wuntokn raiel, ntiwuye korokn yer sukn soplikekn yer yapmunemp aiyiknel. Karokn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas ampu nak na, “Eti apm'a nikimp yipm, yipm korokn wunempwaiyimp ninkopnilmp aiyipmel i mper niepm yer niorknel yer yapmunemp aiyipmel. Niepm likekn kapukorokn yupul yipm ko yer sepmelel. Pe yipm korokn wunempiserp wule aiyipmel i niek na, Elmpuapm simi ko ant yutnu sukurp mouleel? Wule aiyipmel ka si suknel ar niampepm Wulapm Weinkel; elmpuapm irpm ka si akopitekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kona yipm numpul yupulp niepm irpmel, yipm ampu wunempwaiyimp nti aipm. Nti karokn apul niokn mputnank, pe nti karokn neik aiye si wot i mper ar yitne mpawuel yupulp niepm nti ko yel nkienkienel. Aser Waiek aiyipmel ar na yemp keipmelel ka ak nti lorukopm al, ka niepm antuel. Nti aipm ka akopitekn, aser kil ka wakerp nti akei ampripel. Yipm moule ka si suknel ar niampepm ankilel nako kil yupulp yipm sukn soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pe yipm numpul ntakilelel, kakorokn yupul yipm na yer sepmel, kakorokn yupul yipm na nkis yerelel, kapukorokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Kona yipm numpul yupulp mpuampua irpmel, yipm ampu wunempwaiyimp sunsu irpm. Nti sunsu pe yipm aser nti sepmel, nti karokn awomp wapm antuel i nti nar. Ka nti nkis akei nampuel, aser Wulapm Weink apul nti ka akolikekn yatip. Walaipm antuel ka akosepm, ka sankork elmpuapm sepmsepmel ampueik ka moule mamp Solomon narel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nti sunsu antempel mpuas ka ar awun likekn ako, niatel mouleel ko yuntun nti nako pmusite. Nti ar akopitekn, aser ka Wulapm Weink ankil ka apulp nti akosepm yatip. Yipm moule ka numpul apulp mpuampua kitapmelel, yapmunemp aiyipmel ka wank. Yipm karokn aser ntinkirai yapmunemp Wulapm Weinkel. Wulapm Weink ka apul nti sunsu sepmelel, kako kil yupulp yipm sepm sankork nti sunsuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yipm korokn niek na, Ko ant yelel mi? Elmpuapm simi ko ant yutnuel? i numpul yupulp. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nti moule ka ar kuriekn i karokn ntinkirai apulp Wulapm Weinkel, nti ka apulp na nti na yuwup ninkem mpuampua irpm ntakilelel. Aser Waiek aiyipmel ar na yemp keipmelel, kil karep amiser mpuampua irpm yipm aroknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aser niokn sukur kona yipm'a yupulel, ka ntalekil. Yipm somp Wulapm Weink yer yapmunemp aiyipmel ntaka moule mamp aiyipmelel, pe eipm sank ankilel nkis wunamp sepmel. Kona yipm yupul ntakilelel, Waiek Keipmel ko yumuk yipm elmpuapm irpm niepm ka yipm numpulpel. ");
INSERT INTO xbi_y_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yipm korokn wunempwaiyimp wankepm simi kona ninkem yipm ankaiel. Wankepm awun ekeielel likekn ko yipm wunempwamiyimp. Pe wankepm mi ankaiel ko yimprip ankai, ko yipm korokn somp yupul yer awun epie.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Jisas ampu nak na, “Yipm korokn niuknu yuwap mewel, na somp sank wankepmel mperpil i niek na kil ka moule kuret. Kona yipm yupul ntakilelel Wulapm Weink arai yuntunel yipm soplikekn. Yapmunemp aiyiknel ka yikn aim apulp nti moule yatelel kako yapmunemp soplikekn arai Wulapm Weink yikei yupulp yikn. Eti ka yipm korokn niek sank wankepmel mperp mewel nako Wulapm Weink korokn yuntunel yipm kuretel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yapmunemp aiyiknel ka sop sankmuati epie. Yikn ka aser niakep ka ar niampepm mamintomp aiyiknel, pe ka nimpilie kitielel ka ar yikn niampepmel, ka yikn karokn wunempwaiyimp. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Apulntaku! Kona nimpilie kitielel ka ar yikn niampepmel, ka yikn korokn nikimp mamintomp aiyiknel na, Mamintomp, apm'a ye niakep pe ar yikn niampepmel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yikn ka moule sank mpulmpulel. Ko yikn nor nimpilie kitielel suknel ka ar yikn niampepmel niorkn. I yikn ko ser ntinkirai nako yikn miye niakep akopiteknel ka ar niampepm mamintomp aiyiknelel. Sankmuati epie ka ntremp yikn apulp sank wankepmel yikn'orokn pokel mperp mewel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pe sankmuati nonkel ka ntalekil. Kona yipm'a somp sank yapmunemp sepmel Wulapm Weinkel mi na nikimp nti moule ka ntaka niumpua kuretelel, nti kako mintaka niumpuael, arai ampu nimplemp yump yikn. Kona ntakilelel, karokn sepm. Pe sankmuati nonkel ka soplikekn. Yipm korokn somp lipan sepmel aiyipmel i mperp nti moule ka nuarep wurokn yankerel. Apulp na ka nti karokn nimpriepmel apulp mpuampua mi ka sepmelel, ka nti kako nkaik ntemp wantemp'itapm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisas ampu nak na, “Kona yipm yintemp Wulapm Weink niek sank, yimpil yupulp setel na kil na yek yipmel, arai kil yek yipm. Kona yipm yikei yuwupelel, arai yipm ninkem. Pe kona yipm yikei nta sunkol yitne tukuakn, arai Wulapm Weink sikninep yipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Apulpaser aiyimp irpm ka nti akeiwanto aiyimpilel arai nti somp. Simisimi ka nti awupel arai nti ninkem. Pe moule na yikei nta sunkol yitne tukuakn arai nti sikninepil. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka ntalekil. Kona ninkilapm mewelel yimp waiek ankilel na yek kil luwu ntintirel, kil kapukorokn yek kil wuntokn nilu yel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pe kona ninkilapm mewelel yimp waiek ankilel na yek kil yoknel, kil kapukorokn yek kil saklok maninik yel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yipm waiek antuel ninkilapmel, yipm ka ar nkis wunamp'uretel suwaink, aser mpuampua sepmel ka yipm nkis akei ampuk ampuk nti ninkilapm aiyipmel. Eti yipm ser yuworel, Waiek aiyipmel po ar na yemp keipmelel, kil ka mpuaimpuai na yek yipm mpuampua sepmel ka yipm aiyimpil apulpel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kapepe, sankwunamp sepmel ka yipm apulp na nti moule na yupulp yipmel, ko yipm yupulp nti soplikekn niorkn. Sank epie ka sank weink apulp sank niawurpmel sukurel Wulapm Weinkel antempel sank wantoel ka nti moule Wulapm Weinkel nakaworpel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jisas ampu nak na, “Lomp tukuakn ka wuyeel, nonkel ka sukn, pe nonkel ka ninonel. Yayapel ka mpi yemp'uretelel i ko nti moule yer kuret aninkaninkelel, yayapel epe ka sukn, nako yetel ka sarel. Lomp tukuakn ankilel ka mpuntier, pe nti mitimitink kako sop yayapel epe war. Aser lomp tukuakn nonkel ka war yemp sepmelel ka ninonel. Yayapel ankilel ka ntinkiliemp, nti moule kana sop yayapel na war lomp tukuakn ekilelel kapuko likekn wuye ako. Yipm ankil ko war lomp tukuakn ninonelel pepe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas ampu nak na, “Yipm'o yikei wunempel nkis niampepm ntankuel yupulp nti moule ninkaielel kana niek yuworp sank Wulapm Weinkel kuserel. Nti ka nakimp yipm sank aikn akosepmsepmel na kuap yipmel, aser yapmunemp yekipminel antuel, nti kana ninkai yipmel na yupul yipm milminelel. Nti kona nikimp yipm sankel, nti ka nar wulienk mimper, nkamp marknimp minar i napmok sank. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wunamp antuel arai ntremp yipm ntinkirai yupulp na nti ka moule mielel. Kako mpintaka sankmuati piepe. Kona yikn'a sin rukopm ka sinkenelel, yipm kapukorokn sin yer mpuas ka yenkelel. Pe kona yipm apulp na yipm'a yel waiel, yipm kapukorokn yuwup yer yemp ainkel. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eti ka soplikekn, rukopm akosepmel ka naker ar lo akosepmel. Pe rukopm ka kuretelel ka nanker ar lo kuretel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo ka akosepmelel kapukorokn niker rukopm ka kuretelel. Pe lo ka kuretelel kapukorokn niker rukopm akosepmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo mpuampua karokn naker rukopm sepmelel, ka nti mpuar pe akei yite as. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eti yipm ser yuworel sankwunamp antuel nti moule ninkaielel kana niek yuworp sank Wulapm Weinkel kuserel, ko yipm ntinkirai yupulp nti ka moule miel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nti moule ntitmaken mpurel ka akei niepm kurieknel aiyimp nia apmilel kuserel ntentenkelel i nak na, Yikn ka Sepmel apmilel. Nti kakorokn war yemp sepmel i yer nta Wulapm Weinkel. Karokn. Wulapm Weink ka awup nti moule ka eipm sank ankilel i nakerpm sop puikn ankilelel. Nti likekn kako war i yer yintempil yer yemp sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kona nti moule yet niampepm Wulapm Weinkel i ko kil yuntunel ntiel, ekilelel nti mitinkel arai nikimp Wulapm Weink na, Sepmel, ant akei nia aiyiknel nakaworp yapmunemp aiyiknel. Pe ant akei nia aiyiknel nkiyir nti muanumpor yanker. Pe ant akei nia aiyiknel apul niokn niawurpmel mitinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe awun ekilelel apm arai nikimp nti likeknel na, Yipm'arokn sop yapmunemp apmilel, ka yipm akei nia apmilel kuserelel, akei yapmunemp'uretel apupul. Eti apm ka antemwunemp yipm. Yipm nisipm apm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas ampu nak na, “Kona mewel eipm sank irpm karep apm nakel i kil apul sopel, kil ka ntaka moule ka nimpriepmelel i kil apul yitne tnei kitapm ka wuntokn akei yuweipel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wolpmpor wutnie ntamel yir amu i mpepupukn mintaink sil a, i sal yamol yitne. Aser ka yitne karokn nuwor, apulpaser kitapm irpm ka aimop wulael ka aremp wula irpm kitapm mintenkim. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aser kona mewel eipm sank irpm karep apm nakel i karokn apul sopel, kil ka nuarep moule ka yapmunemp sukukurelel ka apul yitne tnei kitapm ka mpumpululel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe ka wolpmpor wutnie ntamel yir i mpepupukn mintaink sil a, i sal yawol yitneel, ka yitne ka numuor atitwarminkeselim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas nak sank irpm epe niatelel, i nti moule ntitmaken mitinkel epe ka nkark kuret ankil ampulp sank ka kil yuwap ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Apulpaser kil karokn yuwap nti ntaka nti moule wupm raiel antuel ka yuwap nti sank niawurpmel Wulapm Weinkel. Karokn. Ka kil yuwap nti mintaka moule ka nkamp mpunti suknelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas nakimp nti sank ar na malenk niatel i, kil ampu amu i, nti mentitmaken mitinkel pe arko sopil mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aser mouleel ka wule ninkirmp apulel la i waker nkaikyumpo eip kitapm ampulp Jisas, i kil nak na, “Sepmel, wule ninkirmp apul moule apmilel wankepm yatip. Kona yikn puiknel, yikn yupulp apm wule ninkirmp epie na niat. Nako moule apm pipilakn i apm yer ntinkirai yer niampepm Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kapepe Jisas aiki nta mul kil i nak na, “Apm apulp na moule yikn pipilakn.” Kapepe, karokn akir, wule ninkirmp ankilel ka miniat i moule kil pipilaknim. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I Jisas nakimpil na, “Yikn eipm. Yikn korokn mpi yireikel nikimp mewel yupulp niokn apm apulp yiknel. Karokn. Sukur yikn mpi yitne suknel Wulapm Weinkel ser pris i, yikn ntrempil wule aiyiknel na kil ser aipopel. Kona wule ninkirmp niatel, yikn wul wompwuyepm aiyiknel yintempel, sop sank niawurpmel ampueik Moses nakimp yipmel. Nako nti moule ser yuworel wule ninkirmp aiyiknel ka niatelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas mpi muar yemp suknel Kaperneam, i moule mamp antuel 100 moule napolel Romel la i markipninket Jisas nakimpil na, ");
INSERT INTO xbi_y_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sepmel, moule ka apulp apm nioknel ka arip wule suknel ar yitne. Ntankaik kil ka yakop nkirnkerip, ka awur mpilmpilelim apmuei kitapm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","I Jisas nakimpil na, “Wule po apul kilel, arai apm mpi yupulpil i ko akosepmim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Aser moule mamp ampu nakimp Jisas na, “Sepmel, yikn ka moule mpunti pisilel, apm'arokn moule akosepmel i ko yikn war yitne apmilel. Ka yikn yer piepe yikei sank niek nkiyir wule ankilel. Pie apm nak ntakeielel ka apulpaser mpunkol aiyiknel ka suknelip. Moule ka mpunti silel nuarep yiknel ko niek sank miel nako nti eipm yupul sopel. Ka mpintaka kona moule mamp apmilel nikimp apm sank mi, ko apm yupulel. Pe kona apm wankes mewel antuel nti moule napolel apmilel na mpi okorelel, kil arai mpi. Pe kona apm yimp mewel na, Yikn la, kil arai la. Pe kona apm nikimp moule ka apulp apm nioknelel na, Yikn yupul niokn ntalepe ntalepeel, kil ka ampul. Pie apm aiyimp yiknel, ko yikn yupul soplikekn nako moule nioknel apmilel ampu sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas eipm sank ekilelel, kil ka yapmunemp pupurur apulp sank ka kil nakel, ka sank akosepm, kil nak yumua. Jisas ampu nimplemp i nankimp nti moule ka la sopilel na, “Apm nakimp yipm, moule ekilelel ka apul akosepm. Apm karokn ampu aser ninkem mouleel Israelel ka yapmunemp mintenk apulp apm nta yapmunemp pie moule Romel ekeielel aimel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Apm nakimp yipm likeknel, arai kona Wulapm Weink yer ntaka moule mamp kitapm sukurelel, nti moule mitinkel ka ar wampwampel, kona nti yum yapmunemp nta moule epie aimelel, nti oko la yel niepm yimintemp nti manmakn antilel, Abraham nti Aisak antemp Jekop. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aser nti ntitmaken Israelel ampueik Wulapm Weink yuwak nti na yintempil yer nta ankilel aninkaninkel, nti karokn aim yapmunemp ntapo kil aimel. Eti arai kil ampu nkiyir nti, yawol nti yo yemp nimpiempel ka Wulapm Weink karokn arel. Nti oko yikei sasael, wunemniripm wule antuelel, nainiunku sinkerel yipei pope.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kapepe Jisas nankimp moule mamp epe na, “Yikn mpim. Yapmunemp aiyiknel ka mintenk apulp Wulapm Weink ko yupul moule nioknel aiyiknel akosepmim, i kako ntapepe kil apul misop.” Ankrik Jisas nak sank ekilelel, i wule ka apul moule nioknel ankilelel ampu sepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kapepe Jisas mpi i kil muar yitne Pitael, i kil amiser yanukno Pitael ka ar waimpel, apulpaser wule apul kil, moule kil ntinkiliemp. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kapepe Jisas ntankamumpil nta i, wule kil miniat, moule kil silmpenkim. Kapepe yanukno Pitael pe nkarp i yireikel ampulp Jisas niepm na kil yelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ka awuniunkuriknim i, nti apul nti mentitmaken mitinkel ka muanumpor yanker ar ntiel la amiser Jisas. I Jisas nak nkirnkerel nkimiyir nti muanumpor yanker i nti naikul amomp nti mentitmaken. Pe nti moule akeiwanto ka wule apul ntiel ka Jisas apul nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kil apul ntakilelel ka sop sank ampueik naikul niepm moule ka nakaworp yapmunemp Wulapm Weinkelel, nia ankilel Aisaia. Ka kil nak na, Kil ankil ka arkos wankepm irpm antilel, nkiyir wulenip mpuampua antilel mpim. (Aisaia 53:4) ");
INSERT INTO xbi_y_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas aser nti mentitmaken mitinkel ka at mployininkempilel i, kil nankimp nti moule ka sopilel na, “Kuasipm, ant yuntun mpepwarmp mpim yakitie.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aser mouleel wupm raiel la i nakimp Jisas na, “Sepmel, wompitne wampwamp kona yikn mpiel apm arai sop yikn yintemp yikn mpi.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","I Jisas ampu nakimpil na, “Nti aiemp ka tnei pirkepm ar kitapm, pe nti aipm ka ar wapm antuel sil lo. Aser na apm Es Aiyipmel Ntitmaken Akeiwantoelel, yitne ka apm ar niumpu arel, karokn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pe moule nonkel ka mewel antuel ka sop Jisasel, kil ampu nakimp Jisas na, “Mesepmel, apm'a yimp yikn. Ko sepm mi rokn, ko apm mpi wompitne apmilel na yuntup waiek apmilel niorknel i, ko apm ampu la sop yiknel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aser Jisas ampu nakimpil na, “Ka mekitik, nti moule knuampel kako yuwur yikei yawopmelel, nti ankil ko yuntup nti moule antuel. Aser yikn, yikn la sop apm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kapepe Jisas yukur na misil wutumpepel i, nti moule ka sopilel akeimpil namp wutumpepel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nti mpi mpep niumon niumonel i, wolpm mpor suknel namp i mpepwarmp atit nkirnkerelim nako yer yamui wutumpepel. Pe Jisas ka ar niumpu wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","I nti mpi sisir kil, markipniminketil na, “Mesepmel! Yikn ampu ser ant, wunempyupulp ant! Ant pie nako wuntuim!” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kapepe kil nankimp nti na, “Yapmunemp aiyipmel ka wank, karokn mintenk. Pe yipm nkinkiekn apulpi?” Kil nkarp i nakamuntup wolpm irpm mpep. I kapepe wolpm kakir, mpep ntimpil ainkol. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kapepe nti aser ntakilelel, nti karep nkark akei tninel ankil, i nak na, “Pie ka moule simi, pie wolpm irpm mpep eipmil sankel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas antun mpepwarmp Galili mpi kitapm antuel Gadarael ka ar yakitieel. Aser moule wuyeel, ka muanumpor yanker aworwukeelel, la i niminkem Jisas. Ntiwuye ka yek yemp ntopm muanel la. Ntiwuye ka yapmunemp yankerel namp nti, eti nti ntitmaken ka nkinkiekn ampulp ntiwuye, eti nti nkarmikemp na yet yayapel epeel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kapepe ntiwuye nak Jisas nkirnkerelim na, “Ai! Ninkilapm Wulapm Weinkel! Pe yikn'a la yupulp ant ntakulel? Epie karokn awun aiyiknel na yikn'a yek ant yakop nako yuntunel antel!” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pe wurokn mitinkel ka nkamkamp at likekn al niepm ar ako mpimp peik. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nti muanumpor yanker epe, nti akei mayon i ansankel nak na, “Kona yikn na nyikir antel, yikn wankes ant mpi war nti wurokn opo.” ");
INSERT INTO xbi_y_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas nankimp nti na, “Kope, ka yipm mpim.” Kapepe nti muanumpor yanker naikul amomp moule wuyeel epe i, nti nkark mpi wamirep nti wurokn. Kapepe nti wurokn wantosukurel epe nkark akei naiel mpim yemp ka kuret antinkel. I nti akeiwanto yireikel nkaiyi krinkarel amu mpepwarmp. Eti mpep waker nti mintanku i nti ka wuntu miniat. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nti moule ka wakerp wuroknel aser ntakilelel, nti ka nkarpmok. Nti mpi ninink yemp suknelel i nti nankimp nti ntitmaken ampulp mpuampua karep ninkem ntiel. I nti sukueimp nti ampulp mpuampua ka ninkem moule wuyeel ampueik muanumpor yanker aworwukeel ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kapepe nti mentitmaken ka ar yemp suknel ekilelel, nti akeiwanto la i amiser Jisas. I nti nak kil mpunkolelim na, “Yikn korokn yer yemp epie, yikn mpim yempel okor.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kapepe Jisas yukur na wutumpepel nonkel i mpim yek yakitie mpepwarmpel, kil mpi niminink yemp wompitne ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","I nti arkos mouleel ka ntankaik awur silmpenkel sil lowaimp la amiser kil. Jisas amiser yapmunemp antuel aser ka mintenk apulpil na yupul moule epe sepmelel. I kil nakimp moule ka ntankaik silmpenkelel na, “Mamintomp, yapmunemp aiyiknel ampu yer pipilakn. Yapmunemp'uretel aiyiknel karep apm nkiyir armikomp yikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nti moule wupm raiel mpurel, nti eipm kuret sank pe Jisas nakel, i nti anti nak na, “Moule epe ka nkamp yemp Wulapm Weinkel na nkiyir yapmunemp'uretel mouleel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas karep aser amorel yapmunemp antuel, i kil nak na, “Yapmunemp aiyipmel ka yakopel apulpi? ");
INSERT INTO xbi_y_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sank simi ka sarel ko apm niekel? Ko apm niek na, Yapmunemp'uretel aiyiknel karep apm nkiyir armikomp yikn? Oroknel, ko apm niek na, Yikn serp yet wunamp? Sank wuyeel epie ka soplikekn, ntiwuye ka sarel kona apm yikei niawurpm apmilel yupulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aser apm ka apulp na yipm ser yuworel yupulp mpunti apmilel Es Ntitmaken Akeiwantoelel. Apm ka niawurpmel ar kitapm ekeielel, nako nkiyir yapmunemp'uretel irpmel yer kitapmel.” Kapepe Jisas nak sank irpm epe niatel i, kil niampepm amuntup moule epe ka ntankaik awur silmpenkelel i, Jisas nankimpil na, “Yikn serp, yiki waimp aiyiknel, yikn ampu mpim yitne aiyiknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kapepe, arokn akir, moule epe ka nkarp mpim yitne ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nti moule aser ntakilelel i nti mimuai amu. I nti aimiki nia Wulapm Weinkel, apulp ka kil ak nti moule mpunti suknel ntakilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas mpi i kil niminkem mouleel, nia ankilel Matyu, ka nkis apul niokn ankilel nkampop nti wuntokn antuel Judael ak moule mamp antuel Romel. I Jisas nakimpil na, “Yikn la sop apm.” I Matyu nkarp i sop Jisas mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kapepe Jisas kua nti moule ka sopilel war nkis al niepm apmuei yitne Matyuel, i nti moule mpurel ka nkampop nti Juda wuntoknel antempel nti moule yatel mpurel ka aim yapmunemp'uretelel, nti mila i ntiarko nkis al niepm amintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nti Farisi aser Jisas nkis antemp nti moule yapmunemp'uretel epe i nti namiyim nti moule ka sop Jisasel na, “Apulntaku pe sepmel aiyipmel al niepm nkis antemp nti moule ka nkampop ant wuntoknel amposel nti moule yatel ka aim yapmunemp'uretelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas eipm sank ekilelel, i kil nankimp nti sanklomp na, “Nti moule ka wule ntawu karoknelel, nti karokn mpi aser moule ka apul nti wule ntawu sepmimel. Karokn. Nti moule ka wule ntawu apulel likekn ka mpi na ser kilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sank ka sil wupm suknel Wulapm Weinkelel, yipm mpi somp ser aipopel. Sank ka nak ntape na, Puikn suknel apmilel ka apulp na yipm ko wunempyupulp nti yikeiwanto yupul nti sepm. Kona yipm korokn yum yapmunemp sepmel ntakilelel, apm kapuko sirkemp wompwuyepm aiyipmel kona yipm wulel.” (Hosea 6:6) I Jisas ampu nak na, “Apm karokn a apulp nti moule ka nak na nti ka aim yapmunemp sepmelel. Karokn. Apm ka a apulp nti moule ka aim yapmunemp'uretelel, yimp nti na nimplemp yapmunemp na sop apmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nti nkis nak sank aser, nti moule mpurel ka sop Jon Baptaisel la aser Jisas i namiyimil na, “Ant antempel nti Farisi ka nkis nailep na wunempwaiyimp Wulapm Weink. Aser nti moule ka sop yiknel, nti karokn apul sop pie ant apulel mi, ka apulpi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kapepe Jisas akei sanklomp nankimp nti na, “Kona mouleel na somp makenel, eti nti ntieyarkup ankilel ko nkis nailep saiyipil, mi rokn? Arokn! Nti kapuko mpuaimpuai yupulpil. Kil ka antemp nti arel. Aser kona moule epe wuntuel, i kapepe nti ntieyarkup ankilel ko nkis nailep yumpulp ka kil awomp ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sanklomp nonkel ka ntalekil. Elmpuapm rankel ka akorel, ko yikn somp elmpuapm niumpueiel yuwomp nantip, mi rokn? Karokn. Kona yikn yupul ntakilelel, yikn'a sukulel, arai mpep la nkuei elmpuapm niumpueiel ka soel, kuap elmpuapm rankel ka nimirknelel i, ko yukor kuretim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pe muati nonkel ka ntalekil. Kona mewel yuwomp wusaikn yupul ntaka yukoel i mper mpimpi na rankelel, kil korokn nimprip mpep wain nimpueiel yo yuko rankel ankilel epe na mper yer. Karokn. Kona mpep wain limain yikiel, arai yuwor wusaikn rankel ntintirel epe arai yukor, i mpep wain ko nukul yamukul. Eti nti nimprip mpep wain niumpueiel a wusaikn niumpueiel mplulel. Kona mpep wain limain yikiel, wusaikn korokn yukor. Mpep wain yintempel wusaikn kako yer sepmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas peyar antemp nti moule ka sop Jonel nak nak sank, aser mesepmel pe la i waker nkaikyumpo eip kitapm ar nkaik Jisasel i nak na, “Ninkilapm makenel apmilel karep amur. Yikn la ntawul kil, nako kil ampu serpel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kapepe Jisas nkarp i sopil mpim, i nti moule ka sop Jisasel antempil mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pe makenel ka ar ekilelel ka nimprip yarkup 12-pla nioknwank sukurel. Maken epe la kitnan pmomp Jisasel i kil akei nta mukuap elmpuapm mpeiknel Jisasel wainki ka akei a kitapmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","I kil ankil wunempwaiyimp na kona kil ntasomp Jisas elmpuapmel, yarkup ankilel oko yumuntun i, kil oko sepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","I kapepe Jisas nimplemp aser kil i nak na, “Niaikno, yapmunemp aiyiknel yer pipilakn. Yikn ka yapmunemp mintenk apulp apm, eti yikn karep akosepmim. “Ankrik pe Jisas nakimpil sankel i maken epe ka ampu akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kapepe Jisas mpi niminink yitne emesepmel karepelel i, kil amiser nti mentitmaken ka saiyip muanel. Nti awop wulpm, nti sa nimpi apul yemp ka titirelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I Jisas nak na, “Yipm nisipm, yet mpi peik. Ninkilapm maken ako epe karokn awur. Karokn. Kil ka ar niumpu.” I nti naminkeip Jisas apulp sank kil nakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eti kil nkiyir nti ntitmaken nainkul kuriekn, i kil mpi war, ntankamump ninkilapm maken ako epe nta, i kil ampu nkarpmop. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kapepe nti moule mitinkel ka ar kitapm antuel wampwampelel yupmueipm sank ampulp niokn epe ka Jisas apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas awomp yemp epe apmuei i kil po mpim. Aser moule wuyeel ka niampepm liknelel sopil mpi, aiyimpil na, “Sepmel, Knamniumpuai Devitel, yikn wunempyupulp antie.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas mpi muar yitne i moule wuyeel ka niampepm liknel mpi amiser kil. I Jisas naiyim nti na, “Yipmwuye ka yapmunemp mintenk apulp apm na yupul niampepm yipmwuyeel ampu sepm, mi rokn?” I ntiwuye nakimpil na, “Kope, Sepmel. Yapmunemp antilel ka mintenk ar yikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","I kapepe kil akei nta wul ntiwuye niampepm i kil nak na, “Yapmunemp mintenkel yipmwuyeel ka ar apmel, i kapepe apm'a yupul misop sank pe yipmwuye nakel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I niampepm ntiwuyeel akosepm mpililim. Kapepe Jisas nakamuntup ntiwuye mpunkolel na, “Yipm korokn nikimp mewel yupulp niokn simi pie apm apulp yipmel,” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aser ntiwuye mpi nankimp nti mentitmaken apmuei yemp wompitne mitinkel ampulp niokn sepmel ka Jisas apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Moule wuyeel epe awomp Jisas apmot, ntiwuye po mpim. Eti nti ntitmaken ampu apul mouleel la amiser Jisas, ka muanumpor yanker nkisil moule i apul kil niepm ka nanintipelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","I kapepe Jisas nkimiyir muanumpor yanker epe apmuei kil moule i kil ampu napmok sank. Kapepe nti moule mentitmaken yapmunemp nti ka pupurur i nti nak na, “Ka niokn niawurpmelip epe, ampueikampueikel ant'arokn ampu aser ntalekil ar kitapm antilel Israelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aser nti Farisi napmok na, “Ka kil akei niawurpm Satanel, ka moule mamp antuel muanumpor yankerel, pe kil nkiyir nti muanumpor yanker.” ");
INSERT INTO xbi_y_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas mpi aser nti ntitmaken akeiwanto apmuei yemp wompitne suknel akoel. Kil yumuap nti ntitmaken ar muar yank Wulapm Weinkel antuel irpm. Kil nankimp nti sank sepmel apulp Wulapm Weink na yuwulmp nti nako nti yintempil yer sepmelel. Pe wulenip mpuampua ka apul ntiel, ka kil apulp nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kil aser nti ntitmaken mitinkelel i kil wunempampulp nti, apulpaser yapmunemp antuel ka mpurampuraelim, mintenk antuel karokn sukn. Nti ka ar nkis kukokukoel antempel yapmunemp wankepmel nuarep nti wus sipsip ka nti moule karokn wakerp ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eti Jisas ampu nakimp nti moule ka sopilel na, “Nti moule epie ka nuarep niepm ka tikn ar niokn mputnankel, aser nti moule nioknel kana neik yeel karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eti yipm niek sank yimp Waiek Keipmel, ka waiek niokn ekilelel nako kil wankes nti moule nioknel mpi na somp nti yikei tnei yer yempelikeknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas aiyimp nti 12-pla moule ka sopilel la i, kil amuk nti niawurpm ampulp na nti na nkiyir muanumpor yanker irpm ka ar nti ntitmakenel, na yupulp nti wule mpuampua sepm yimintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nia antuel nti 12-pla aposel epe ka Jisas wankes nti atel ka ntalekil. Saimon, nia kitie ankilel ka Pita, antempel knuan ankilel Andru. Pe Jems nti Jon, nti ka ninkilapm Sepetiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip nti Bartolomyu antempel Tomas. Pe Matyu, kil ka moule nkampop nti Israel wuntokn ak moule mamp antuel Romelel. Pe Jems ka ninkilapm Alpiusel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tadius, ka moule yatel, pe Saimon ka moule ka apei yakitie antuel Selotelel. Pe mouleel ka Judas Iskariot, kil arai mper Jisas mpi nta antuel moule kuretelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas wankes nti 12-pla moule mpiel, kil nakimp nti sank ntalekil. “Yipm'orokn mpi ser nti moule kurieknel yintempel nti yemp suknel irpm antuel Samariael, mekitik. Nti karokn ntieyarkup Judael. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ka yipm mpi ser nti moule ntitmaken Israelel ka yawopmel nuarep nti wus sipsipel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yipm mpi nikimp nti yukorpel ntape na, Wulapm Weink kana yuwulmp yipmel, kil karep la kitnanim. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yipm mpi ser nti moule ka wule apulel, ampu yupul nti sepmim. Pe nti moule ka wuntuel ko yipm ampu yiki nti sirpmop. Nti moule ka wule ninkirmp apulel, wule antuel ko yipm yupul sukupim. Muanumpor yanker ka ar nti ntitmakenel ko yipm nkimiyir.” Jisas nakimp nti na, “Wule simisimi ka apul nti ntitmakenel ko yipm yupulp nti kuserel sop niawurpm ka apm ak yipmel. Ka apm ak yipm kuserel, karokn yipm akei wuntokn nkamp. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kona yipm yet wampwampel, yipm'orokn nunkur rumpunk yupul yet. Yipm'orokn yum wuntokn mprarel suknel akoel yo ntokrumpunk aiyipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yipm'orokn ntri elmpuapm wuyeel, loaikn nkaikel yipm'orokn ntri, mpu yipm'orokn ntitnei, mekitik. Moule ka apul niokn Wulapm Weinkel ar wampwampel, niepm mpuampua irpm ko nti ankil yek kil apulp na kil ka moule nioknel Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kona yipm'a mpi wampwampel, ko yipm yuwup moule ka ar nkis apul sankwunamp sepmelel. Ko yipm yintemp moule epe yipei pe, mpimpi ser yipm ko yimomp wompitne epe. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kona yipm'a war yitneel, sukur ko yipm nikimp nti waiek mantiek yitneel na Wulapm Weink oko yupul nti sepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kona ko nti waiekmantiek yitneel mpuaimpuai yupulp yipm i, somp yipm yintemp nti yer yitneel, sank sepmel karep yipm nakel ko rukopm niker yupmuei nti yapmunemp. Aser kona mouleel korokn mpuaimpuai yupulp yipmel, sank sepmel epe kako nkupmus kitapm. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kona waiek mantiek yitneel mi nti moule ka ar yemp suknelel korokn eipm yipm sank na somp yipm yupul war yitneel, kop mpumprukn yemp antuelel ka apul yipm nkaikel ko yipm simpilemp ntinkirai, ka muati apulp yemp epe ko yipm niek yuntunel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Apm nakimp yipm likeknel, arai ko Wulapm Weink yuntunel nti ntitmakenel, wankepm ko ninkem nti ntitmaken yemp suknel ekeielelel kapuko suknelip, arai sankork wankepm suknel kako ninkem nti ntitmaken yemp suknel Sodom antempel Gomorael, ka ampueik nti nkis yapmunemp sankwunamp'uretel suknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas nak na, “Apm'a wankes yipm mpi yuworsapre nti moule kana sikirpyuntun yipm nuarep milmpelel. Yipm ko yikei wunempel. Yipm korokn yumop nti yapmunemp'uretel likekn, ko yipm yum yapmunemp sepmel musukorel, nkis wunamp sepmel suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Yipm ko nkis niampepm ntankuel yikei wunempel yupulp nti moule, nti na mper yipm mpi nta antuel moule lowulaelel. Nti arai ntampli yipm yer yank Wulapm Weinkel yer yemp antuel yupulp ka yipm sop apmel. Nti kako yintemintenk yipm, kua yipm mpi yetn niampepm moule suknelel yintempel moule mampelel. Ekeielel ko yipm nikimp nti moule lowulaelel yintempel nti moule kurieknel nti karokn Judaelel, yipm ko niek sank sepmel yupulp apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kona nti na somp yipm yupul mpi niek sank ntakilelel, yipm korokn nkinkiekn. Wulapm Weink arai yek yipm yapmunemp yupulp sank simi ko yipm niekel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Apulpaser sank arai yipm niekel, kapukorokn yipm ankil niek, karokn. Arai Pirpm ankilel Waiek aiyiknel ankil yiki yapmunemp aiyipmel i ko yipm nipmok. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mouleel arai yumop knuan ankilel yapmunemp'uretel mper kil mpi nta antuel moule lowulaelel, i ko nti yer kil wuntuim. Nti waiek arai yupulp nti ninkilapm antuel soplikekn, pe nti ninkilapm antuel arai yintemp nti waiek mantiek antuel nkisemp wurokn i, nti arai mper nti waiek mantiek mpi nta antuel moule lowulaelel ko yer nti wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pe nti moule akeiwanto arai wunemp'uret yupulp yipm, apulpaser ka yipm sop apm, akei nia apmilel apul nioknel. Pe yipm minimini kona nkis niumumpuel yer nia apmilel mpimpi nako kitapm sukurel epie niatel, Wulapm Weink ko yupul yipm na yintempil yer sepmel yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kona ko nti ntitmaken yemp suknel likekn yupul yipm kuretel, yipm ko serk mpim yemp suknel yatel nako yipm yupul niokn apmilel yer opoel.” Jisas nak na, “Apm nakimp yipm likeknel, niokn irpm apmilel irpm yipm'orokn yupul niat yer yemp suknel Israelel sukurel aser apm arai pokel yo ntaka Es Ntitmaken Akeiwantoel i ko yumuntun yipm niokn wainki. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Ninkilapmel korokn sankork moule wupm raiel ka yuwapilel. Aser kona kil yer soplikekn sop moule wupm raiel ankilelel, kako akosepm. Moule ka apul niokn kuserelel korokn sankork moule mamp nioknel ankilel. Aser kona kil yer soplikekn sop moule mamp nioknel ankilelel, kako akosepm. Apm ka waiek aiyipmel, sepmel aiyipmel. Kona yipm puikn na sop apmel, nti ko yupulp yipm soplikekn ntaka nti apulp apmel. Kona nti yimp apm Belsebul (nia kuretel kitie Satanel), eti yipm moule kuserel ka sop apmel ko yupulntaku?” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas aiki nak na, “Yipm korokn nkinkiekn yupulp nti moule ko yupul yipm kuretel. Yapmunemp irpm simi ka ar nkuwepmelel, arai ninink yer yemp yapelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aser sank sepmel ka apm akei wankel nakimp yipmel, ko yipm ankil yet yemp yapelel niek yuworp nikimp nti moule yikeiwanto. Apm nakimp yipm, sank ka yipm akei ntanku nkampel, yipm korokn nkuwepm yer yapmunemp. Ko yipm yikei sank suknel yet anuyapel wat sank epe. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kona nti moule kuretel na yer yipm wuntuel, ka yipm korokn nkinkiekn yupulp nti, kapuko nti yer ntieaikn aiyipmel likekn wuntuel. Aser ka nti kapukorokn yer pirpm aiyipmel wuntu, karokn. Kako yipm nkinkiekn yupulp Wulapm Weink likekn. Apulpaser ka kil likekn ka niawurpmel nako kil yupul ntieaikn aiyipmel yintempel pirpm aiyipmel yikei yawopmelel yupmuei yemp yiteel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Apm'a sukueimp yipm sankmuati yupulp yokn ntuye, nako yipm ntinkirai yupulp yapmunemp Wulapm Weinkel apulp yipm moule kitapmelel. Yipm ka ntinkirai, nti moule ka akei wuntokn muati likekn nkamp yokn ntuye yitomp wuyeel. Yokn ntuye ka akopitekn, aser Wulapm Weink, waiek aiyipmel, kil ka wunempaser nti yokn ntuye epe. Yokn ntuye likekn kakorokn nkis yikei wuntuel. Karokn. Apulpaser Wulapm Weink aser kil miniorkn. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Aser yipm, kona mamniol likekn aiyiknel ninkrinel, ka mpuampua akopitekn aser Wulapm Weink ka nimpriepm ampulp. Kil ka niumuaakei yipm ar niampepm ankilel. I kapepe, yipm korokn nkinkiekn yupulp nti moule epe kana yumpyer yipmel. Karep Wulapm Weink amiser.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas ampu aiki nakimp nti na, “Kona moule likekn ka mpuaimpuai na nti yikeiwanto ko ser yuworel kil ka moule ka sop apmel i kil karokn wule maiakn apulp apm, apm korokn sirep nia ankilel yer niampepm Waiek apmilel ka ar yemp keipmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aser moule mini kona sirep nia apmilel yer niampepm antuel mouleelel, apm arai nkuwepm nia ankilel yer niampepm waiek apmilelel ka ar yemp keipmel niek na, Apm antemwunemp moule epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas ka nak ntalekil, “Apm'arokn a na yupul yipm na yer niluknunel, karokn. Apm ael, kana yuwor nikile yipm na yer kitiekitieel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Apm ko yupul mouleel na yintemp waiek ankilel nupol nukuapm. Apm kako weink na ninkilapm maken ko yintemp mantiek ankilel nkisemp'uretel. Pe makenel yintemp yanukno ankilel ko nupol nukuapm yupulp apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mouleel kana sop apmel, nti wopmweink ankilel ka ar yitne ankilelel kako yintempil nkisemp wurokn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Moule mini, puikn ankilel ka apulp waiek mantiek niorknelel, i ntaka kil wunempiskel apmel, yapmunemp ankilel ka wank, kil kakorokn sop apm. Pe moule mini, puikn ankilel ka apulp ninkilapm ntitmaken niorknelel i ntaka kil wunempiskel apmel, yapmunemp ankilel ka wank i, kil kakorokn sop apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Moule mini na sop apmel, kil ko yirkos wankepm irpm sop apm arai yirkos lonkuntonkel i wuntu silel. Na koroknel, kil kakorokn sop apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kona mouleel wunempaserp mpuampua kitapmel ankilel wunempwaiyimp na mpuampua ankilel ko yupul kil na yer sepmelel, kil arai yawopmel yintempel mpuampua ankilel. Aser kona mouleel wunempiskel mpuampua kitapmel ankilel apulpaser kil na wunempwaiyimp apm niorknel, kil arai somp yapmunemp Wulapm Weinkel na yer sepmel yupmueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas aiki nak na, “Aninkel kona yipm mpi wampel yupul niokn apmilel, na mewel kua yipm war yitne ankilel i yek yipm niepm yelel, ka kil apulp apm ankil. Kona kil yupulp apm ntakilelel, ka kil apulp Wulapm Weink ankil ka wankes apm ael. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kona mewel ka mpuaimpuai apulp niokn ka mouleel nakaworp yapmunemp Wulapm Weinkel apulel, i kil kua moule epe war yitne yek kil niepm yelel, Wulapm Weink ko yupulp ntiwuye waperel soplikekn. Pe sank nonkel ka ntalekil. Kona mewel ser sepm wunamp ka moule yapmunemp sepmelel nkisel i kil kua kil war yitne ankilel i yek kil niepm yelel, Wulapm Weink ko yupulp ntiwuye waperel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kona mewel nimprip mpep tinam yukoel i yek moule kuserel ka sop apmel na yelel, Wulapm Weink karep amiser niokn akopitepitekn sepmel ka kil apulel, kil kapukorokn wunempiskel. Arai kil yupulp moule epe sepmel waperel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nti 12-pla ka sop Jisasel, sank karep kil nakimp yuwap nti miniatim, i kil pe mpim yemp suknel yatelel irpm na nikimp yumuap nti ntitmaken sank Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aser Jon Baptaisel, ka nti mper kil ar yitne kuretel pminel, kil yupmueipm sank ampulp niokn irpm ka Krais apulel, i kil wankes nti moule ka sopilel mpi na miser Jisas. Jon Baptaisel nakimp nti moule ka sopilel nak na, ");
INSERT INTO xbi_y_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Yipm mpi niyim Jisas ntape na, Krais, moule ka Wulapm Weink nakimp ant nako kil wankesil yo yuwulmp antel, ka yikn pe mi rokn, peyar ar pmin?” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nti mpi namiyim Jisas i, kil ampu nankimp nti na, “Yipm mpi nikimp Jon yupulp niokn apmilel ka yipm eipm aserel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nikimpil yupulp nti moule ampueik ka niampepm liknelel, niampepm nti ampu ka nimin. Nti moule ka nkaik kuretel mi nti nkis kitapmel, nti ampu ka nkarp apmot keipm. Pe nti moule ka wule ninkirmp apul ntiel, nti ka ntinkiraiyim. Nti moule ntanku kukoel, nti ampu ka yupmueipm sank. Nti moule ka awurel ampu ka nkarpmop. Nti moule kuretako ka mpuampua aroknel, nti ka la yupmueipm sank Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nti moule minimini karokn yapmunemp mitimitink na yuwomp apmel, nti kako mpuaimpuai.” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nti moule ka sop Jonel karep mpim i, Jisas sunkueimp nti ntitmaken sank ampulp Jon Baptaisel, ka wat sank Wulapm Weinkel ar yemp'userelel. Jisas nak na, “Aninkel yipm mpi yemp'userel epe, yipm'a mpi na ser mi? Ka yipm mpi na ser wolpm ka yileip yakuel tikikn? ");
INSERT INTO xbi_y_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Rokn, yipm mpi na ser mouleel ka ntri elmpuapm sepmsepmelel tikikn? Arokn. Kona yipm'a yuwup ninkem moule ntalepeel, ko yipm ser kil yer yitne moule mampelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Eti yipm'a mpi na yupulel mi? Yipm'a ser moule ka nakaworp yapmunemp Wulapm Weinkelel tikikn? Kope, ka kil pe. Apm nakimp yipm, Jon Baptaisel ka sankork nti moule akeiwanto ka ampueik nakaworp yapmunemp Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yipm eipm, sank ka sil wupm suknel Wulapm Weinkelel ka kil nak apulp moule epeel ntalekil, ka nak na, Arai apm wankes mouleel na nikimp nti sank apmilelel. Kil ko yet niorknel, nikimp nti nako nti ntimpramp yapmunemp nkrak yayapel yupulp Mesaia ko nininkel. (Malakai 3:1) ");
INSERT INTO xbi_y_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Apm nakimp yipm likeknel, Jon Baptaisel ka sankork nti moule wanto kitapm sukurel ekeielel. Aser, moule kuserel minimini ka nimplemp yapmunemp war nta Wulapm Weinkelel, kil ka sankork Jon. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yek Jon Baptaisel lala ekeielel, ka nti mitinkel apul mpunkol antuel na war nta Wulapm Weinkelel nako kil yuwulmp ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Ampueikel nti moule ka nakaworp yapmunemp Wulapm Weinkel, nti akeiwanto ka nak apulp Krais, moule ka Wulapm Weink yuwakel, pe wupm sank niawurpmel Wulapm Weinkelel ka nak soplikekn. Nti nak na niorknel Elaija ko ampu mila. Pie Jon nininkel ka kil ankil nkamp yemp Elaijael. Kapepe kona yipm yapmunemp likekn yintemp sank ampueik nti nakel, ko yipm ntinkirai ka apm nakimp yipm likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Moule ka ntanku tneiel, ko kil eipm sank epie. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ekeielel apm'a niek yuworp sankwunamp antuel nti ntitmakenelel, aser na ko apm yikei sankmuati simiel niek yupulp ntiel? Nti ka ntaka ninkilapm mpurel ka nkis anuyapel aiyimp nti ninkilapm yatel na ntiarko yupul purkupel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nti mpurel nak na, Ant awop wulpmel aser yipm'arokn antemp ant akei wampen. I ant wat warawur, aser yipm'arokn sa nimpi. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Eti Jisas ampu aiki nak na, Nti ntitmaken ekeielel ka nuarep pie nti ninkilapm apulel. Nti aser Jon la mi, kil nkis nailep apulp niepm sepmel irpm mpep wain, apulp na kil na yupul niokn Wulapm Weinkelel. Nti karokn mpuaimpuai apulpil i nti nak ntape na, Muanumpor aworwukewel kil tikikn. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aser pie apm a ntaka Es Aiyipmel Wantoel i, aninkanink apm apul yatel, apm ka antemp nti akeipe akeipe al niepm al mpep wain irpmel. Nti aser apmel, nti karokn mpuaimpuai apulp apm i nti nak na, Kil ka moule niepm ipiapel. Pe kil kukoel, ka kil al mpep wain sukn. Ntakilelel, nti meniem ankilel ka aim yapmunemp'uretelel i nti mpurel ka nkampop ant wuntoknel ak moule mamp antuel Romelel pe. Nti nak antie apulp niokn antie apulel, aser ka rukopm naker sepmel soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas apul niokn niawurpmel mitinkel ar yemp suknel mpurel aser nti karokn nisep sankwunamp'uretel antuel mi, nimplemp yapmunemp antuel. Karokn. Eti ekeielel i Jisas nak nti miyep. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kil yukantun nak na, “Ai! Yipm mentitmaken Korasinel antempel yipm Betsaidael, wankepm kuretel arai niminkem yipm yer nta Wulapm Weinkel. Yipm aser niokn niawurpmel mitinkel aser yipm karokn nimplemp yapmunemp aiyipmel. Ampueik kona apm mpi yupul niokn niawurpmel soplikekn ntremp nti yer yemp suknel kuretel Tair yintempel Saidonel sop apm apul ar niampepm aiyipmelel, nti kako nimimplemp yapmunemp, nimisep sankwunamp'uretel antuel. Nti kako yikei yitekop yiri mpua, ntri elmpuapm kuretel niurkutupel yupulp nako nti yikeiwanto ser nana nti ka nimimplemp yapmunempel. Aser karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Apm nakimp yipm, arai ko Wulapm Weink yuntunel nti ntitmaken sukurel yer kitapm ekeielel, wankepm arai ninkem yipmel kapuko suknelip. Kapuko sankork wankepm kako ninkem nti Tair yintempel nti Saidonel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pe yipm Kaperneam yipm'a na yiki nia aiyipmel nomp keipm tikikn? Yipm ka nak na yipm ko yer no yemp keipmel. Kapukorokn ankil. Wulapm Weink arai yawol yipm yo yemp yiteel. Ampueikel kona ko apm mpi Sodom yupul niokn niawurpmel likekn sop ka yipm aserel, yapmunemp'uretel antuel ka sukn yatip aser nti korokn ninkemp wankepm sukn yer nta Wulapm Weinkel. Apulpaser nti kapuko nimimplemp yapmunemp. Yemp antuel kapuko peyar yer. Aser karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Apm nakimp yipm, kona ko Wulapm Weink yuntunel nti mentitmakenel, wankepm arai nukulup yipmel kapuko suknelip, arai sankork wankepm kako nukulup nti moule yemp suknel Sodomel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Ekilelel i Jisas nak na, “Waiek, yikn ka Sepmel antilel akeiwantoel. Yikn ka awulmp yemp keipmel antempel kitapm sukurel. Waiek, apm nak naremp yikn apulp sankwunamp aiyiknel, karokn yikn apul ar niampepm antuel moule ka yapmunemp atitakorel, karokn. Nti moule knuampel yapmunemp antuel ka nuarep nti ninkilapmel, nti likekn yikn ka ntremp nti na nti ka aser sankwunamp aiyiknel akorpel. Ka yikn apul sop puikn aiyiknel, ka mpuampua akosepmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas ampu aiki nak na, “Waiek apmilel karep amuk apm mamp ntinkiraiel antemp mpunkol niawurpm ankilel. Ka kil likekn aser yapmunemp pmiempniumpuaipm apmilel, apm likekn aser yapmunemp pmiempniumpuaipm ankilel. Aser nti moule mpurel ko apm ntremp nti nuworpel yupulp yapmunemp pmiempniumpuaipm Waiekelel, kako nti likekn ser yapmunemp Waiekel yimintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yipm moule ka arkos wankepm suknel, awup ntinkiliempel, yipm la ser apm. Ko yipm yintemp apm yer nkisemp sipmakn i, ko apm yumuk yipm mpunkol. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sankwunamp apmilel ka niumuaipm niuluknunel. Apm karokn aiki nia apmilel na keipmel, karokn. Ko apm ntremp yuwap yipm yayapel nako apm kua yipm yintemp apm yupul nioknel. Kona yipm yintemp apm nkis ntakilelel, yipm ko yer nkis yintemp yapmunemp pipilakn niluknunel suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Niokn ant'a yupul yintempelel, yipm kapukorokn eipm wankepmel, karokn. Niokn ko apm yek yipmel kapuko misil yipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Awunel Sapatel, ka nti Juda nakantup nioknel, Jisas kua nti moule ankilel ka sopilel at mpim niokn witel niumon niumon, aser nilmp amor nti i nti antun wit rukopm aim. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aser nti Farisi amiser nti, i nti namikimp Jisas na, “Yikn ampu ser, epie ka awun Sapatel aser nti moule ka sop yiknel nti waker sank niawurpmel apulp Sapatel. Ka nti apul kuret, apul niokn antun wit rukopm al.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eti Jisas ampu nakimp nti na, “Ampueik Devit waker sank niawurpmel Wulapm Weinkelel, kil karokn apul kuret. Sank epe yipm'arokn aser, mi? Sank epie ka ar wupm Wulapm Weinkelel, ka nak apulp ampueik ka Devit kua nti moule ankilel ar nilmpelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit war yitne Wulapm Weinkel i nkuan luwu ntintir ka nti wul apulp wompwuyepmel i kil kua nti moule ankilel aim. Luwu ntintir epe nti moule kuserel ka nti nakantup nti na nti korokn yel. Ka nti pris likekn ko nti yelel. Aser Devit antun sank epie. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eti sank yatel ka ar wupm Wulapm Weinkel ka nak apulp nti pris, nti ka apul niokn ar yitne Wulapm Weinkelel ar awun Sapatel. Sank niawurpmel apulp awun Sapatel ka nti wapiker pe, aser nti pris karokn apul setelel kuret. Sank epe ka yipm aser ar wupm Wulapm Weinkel, mi rokn? ");
INSERT INTO xbi_y_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yapmunemp aiyipmel ka suknelip apulp yitne suknel Wulapm Weinkelel. Aser apm nakimp yipm, moule ka ar ekeielel ka suknelip, nia ankilel ka sankork nia yitne suknel Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sank ka sil wupm Wulapm Weinkel ka nak na, Ar niampepm apmilelel, wompwuyepm ka yipm wulel karokn si suknel. Apm ka apulp na yipm ko wunempyupulp nti moule yikeiwanto, yikei nainkerp nti. (Hosea 6:6) Kona yipm ntinkirai yupulp niupukn sank epeel, yipm'orokn wankirp sank yek nti moule akosepmel. Nti karokn apul setel kuret ar niampepm Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Apm Es Ntitmaken Akeiwantoel ka ar niorknel mpuampua sukurel i kapepe apm ka moule mamp ka awulmp awun Sapat. I kapepe, apm akei niampepm amiser nti moule apmilel apul niokn antun wit rukopm apmuei awun Sapatel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas awomp yemp epe apmuei, kil po mpi niminink yemp suknelel i kil mpi muar yank Wulapm Weinkel antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aser mouleel pe nkis, ntakitie ankilel ka kuret amur. Nti moule mpurel wananklelel mperpai Jisas, naiyimil na, “Epie ka awun Sapat. Ant'a yupulp nti moule ka wule apulel sepm, mi rokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eti Jisas ampu nakimp nti na, “Awun Sapat kona ko wus sipsip mewel aiyipmelel nkiyi yo lieel, ko yipm yo ye kil, mi rokn? Kapuko yipm yupul. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aser moule likekn ka si suknel ar niampepm Wulapm Weinkelel, ka sankork wus sipsip. Yipm kako ye wus sipsip aiyipmel i kapepe, awun Sapat ka awun akosepm ko ant yupul moule wule ntawuel ampu sepmim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eti kil nakimp moule epe ka nta kuretelel na, “Yikn ampu nkunu nta.” Kil nkanu ntael i, nta ankilel ampu akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aser nti Farisi nkarp mpi akei wankel nak nkuwepm amup yayapel na nti na yer Jisas wuntuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas ka ntinkirai apulp nti Farisi na yupul kil kuretel. Eti kil awomp yemp suknel epe apmuei, kil po mpim. Nti ntitmaken akeiwanto sopil mpim i nti moule wanto sukurel ka wule apulel, kil apul nti wule antuel ampu sepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eti Jisas nakantup nti na nti korokn nikimp nti wampwamp sank yupulpilel na kil ka mini. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ekeielel ka Jisas apul sop sank ampueik Wulapm Weink nak ar niepm Aisaiael, moule ampueikel ka nakaworp yapmunemp Wulapm Weinkelel. Ka kil nak ntalekil. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Moule epie karep apm ankil yumuak kil apulp na kil yupul niokn apmilel. Apm ka mpuaimpuai apulpil yatip. Kil ka niumpuaipm apmilel. Arai apm yek kil pirpm apmilel mintenkitneipil. I kil ko yikei sankwunamp sepmel niek yuwa nako kil yuntunel nti moule wampwamp yer kitapm sukurelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kona kil yet yayapelel, kil kapukorokn yikei nukuapmel yuwor ma no keipm na nti ntitmaken eipmil, kapukorokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I kona kil ser nti moule munienel ka awup ntinkiliempel, kil ko yupul nti niluknun. Nti ka nuarep yite ka tnaelel i kil kapukorokn yukur. Kil ko yikei niumuaipmel yupulp nti, wunempyupulp nti. Kil ko yupulp nti ntape mpimpi ser sankwunamp sepmel suwaink ko yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pe nti moule wampwampel karokn ntieyarkup Judaelel, nti kako niampepm tneipil, yukueimil nako kil nantip mua yirkomp nti na nti yer sepmel yerelel. (Aisaia 42:1-4) ");
INSERT INTO xbi_y_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ekeielel nti nkamp mouleel apulp Jisas mila. Moule epe, muanumpor yanker apul kil niampepm ka liknel, sank arokn nak. Jisas ninil niampepm, sakor kil niepm i, kil nak sank amiser ntinkirai. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Eti nti ntitmaken akeiwanto nti ka yapmunemp pupurur nak na, “Moule epe ka Krais tikikn? Ko ant yimpil Knamniumpuai Devitel, rokn arokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nti Farisi eipm apulpilel i nti napmok na, “Moule epe ka akei mpunkol Belsebulel apul niokn, pe kil nkiyir nti muanumpor yanker irpmel.” (Nia kitie Belsebulel ka Satan, ka moule mamp antuel muanumpor yankerel.) ");
INSERT INTO xbi_y_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aser Jisas karep amiser yapmunemp antuel eti kil nakimp nti na, “Kona nti moule ka ntiarko wakirpmtumpua a likeknel, ko nti ampu yintemp nti ankil nupolel, wakirpmtumpua antuel kakorokn yer mintenk, kako miniat. Pe kona ko nti moule wopmweink likekn na yintemp nti ankil nkisemp wuroknel, nti kakorokn yer sepm. Pe kona wompitneel epe nupol nukuapm yintemp nti anti, nti kakorokn yet mintenk. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kona Satan nkiyir nti muanumpor yanker ankilel, kako soplikekn. Ka nuarep ntiarko ka antemp nti ankil nkisemp wuroknel. Mpunkol Satanel kapukorokn. Niawurpm antempel niokn ankilel kako miniat. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yipm nakimp apm na ka mintenk Satanel pie apm akei apul niokn apmilelel. Apulntaku! Ntakilelel, nti moule mpurel aiyipmel nti ka apul soplikekn tikikn, nti akei akei mpunkol Satanel nkiyir muanumpor yanker irpmel. Yipm wunempwaiyimp ntakulel? Arokn. Kapepe, nti ankil ko yuntunel yipm yupulp sank ka yipm nakimp apmel ka sank kukoel, karokn likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aser kona ko mintenk Pirpm Wulapm Weinkel ankil ak apm mintenk i apm apul niokn epeel, ko yipm ser yuworel na Wulapm Weink karep la kitnan na yuwulmp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Apm'a sukueimp yipm sankmuati akopitekn apulp niokn mi apm apulel. Kona mouleel puikn na waker yitne yupul wurkiteel, kako kil war yitne epe, yikei wantienk kitip ntankaik waiek yitneel serp wula nonkel worpil niepm i, ko kil sumump mpuampua puikn ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Moule karokn antemp apm apul niokn, kil ka antemp apm nkisemp wuroknelel. Moule epe karokn sakirp apm na somp nti ntitmaken, kil ka nkiyir nti ar likekn likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Apm nakimp yipm, sank yapmunemp'uretel mimi ka yikn apulel, arai Wulapm Weink eipm ser yikei yuwompel yapmunemp'uretel aiyiknel epe. Kona yikn nek sank kuret yupul nia Es Ntitmaken Akeiwantoel yo kitapmel, yapmunemp'uretel aiyiknel epe arai Wulapm Weink eipm ser yikei yuwompel. Aser kona yikn niek sank kuret yupul nia Pirpm Sepmel Wulapm Weinkel yo kitapmel, Wulapm Weink kapukorokn wunempiskel yapmunemp'uretel aiyiknel, pe wankepm aiyiknel kapuko yer yupmueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas nak ntalekil, “Lo ka akosepmel, rukopm ankilel ka akosepm. Pe lo ka kuretel, rukopm ankilel ka kuret. Nti moule ka aser lorukopm niorkn i nti napmok na, Lo epe ka akosepm, pe lo opo ka kuret. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aser yipm ankil, yipm ka moule limpek. Sankwunamp irpm pe yipm nkisel ka ntremp ant apulp yapmunemp'uretel ka yipm aimel, ka nkirnkerip. Kona ntakilelel, sank sepmel ko yipm niek ntakulel? ");
INSERT INTO xbi_y_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Moule akosepmel ka aim yapmunemp sepmel mitinkel. Sankwunamp ankilel kil apulel ka akosepm suwaink. Pe moule kuretel ka aim yapmunemp'uretel mitinkel, sankwunamp ankilel kil apulel ka kuret suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Apm nakimp yipm, arai kona Wulapm Weink yuntunel yipmel, sank likekn likekn pe yipm nakel, arai kil niyim yipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wulapm Weink arai yuntunel yikn yupulp sank ka yikn nakel, yikn ka moule sepm mi kuret mi.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nti moule wupm raiel mpurel antempel nti Farisi mpurel, ntiarko nakimp Jisas nak na, “Sepmel, ant puikn apulp na yikn ampu yupul niokn niawurpmel likekn ntaka muati walenkel, ntremp ant ka Wulapm Weink ankil ak yikn mintenk apulp niokn yikn apulel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aser Jisas ampu nakimp nti na, “Aaa! Yipm ntitmaken ka pie arel, yipm ka kuret, yipm karokn yapmunemp likekn antemp Wulapm Weink. Ka weink na aninkanink yipm ka nak na yipm na ser ser niokn niawurpmel ntaka muati walenkel suwaink. Aser kapukorokn. Muati likekn ko yipm serel, ka ampueikampueik ninkem Jona, moule ka nakaworp yapmunemp Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Awun wuyelikekn nomp wuyelikekn, Jona ar war yokn lunkoel. Ko soplikekn yupulp apm, Es Ntitmakenel. Arai nti yuntup apm yo kitapm nako apm yer awun wuyelikekn nomp wuyelikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aninkel kona Wulapm Weink yuntunel nti ntitmakenel, nti moule Niniveel arai yet yemp yapelel niek yuworp sankwunamp'uretel aiyipmel, yipm ntitmakenel Judael ekeielel. Nti ko niek na, Ampueikel ant Ninive ka ar kuriekn aser ant eipm sank ka Jona nakimp antel, ant nimimpilemp yapmunemp. Sankwunamp'uretel antilel ka ant amomp. Pe yipm ka ar ekeielel, ka apulntaku? Moule ka antemp yipm at nakimp yipm sank Wulapm Weinkelel, kil ka moule suknelip, ka sankork Jonael. Aser yipm karokn eipmil sank. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kona Wulapm Weink yuntunel nti ntitmakenel, maken mamp kitapm Sibael, kil arai yet yemp yapelel niek yuworp sankwunamp'uretel aiyipmel soplikekn niek yipm yep sank Wulapm Weinkel ka yipm karokn eipm nakerpmel. Maken mamp epie, yemp ankilel ka peik yatip. Aser kil la na eipm Solomon, yapmunemp ntinkiraiel ankilel ka kil nakel. Apm nakimp yipm, mouleel pie ar ekeielel ka sankork Solomon aser yipm karokn apul sop maken mamp epie apulel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas ampu nak na, “Kona muanumpor yanker yuwomp moule nukulel i kil ko mpim yemp nkunkurarel yuwup yemp niumpueiel nako kil yerel. Aser rokn, kil karokn ninkem yemp niumpueiel ko kil yerel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","I kil nak ntalekil, Eti apm ampu na mpim yemp ampueik apm arel. Kil mpiel, kil arai ser moule pe, yapmunemp ankilel ka nuarep yitne ka ntinkirai kuserelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eti arai kil ampu mpi somp 7-pla muanumpor yanker nonkel, yapmunemp'uretel antuel ka sankork kilel. I nti akeiwanto war apmuei moule epe. Nti kapuko yupulpil kuret ankil, sankork ampueikel. Ka muati apulp nti ntitmaken kuretel ka pie nkisel, nti kapuko soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas peyar nakimp nti ntitmaken sankel, mamam antempel nti knuan knuan ankilel la at kuriekn. Nti na yintempil niek sank. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eti mouleel nakimp Jisas na, “Yikn ampu eipm, mamam aiyiknel antempel nti knuan knuan aiyiknel po at kuriekn, nti na yintemp yikn niek sank.” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aser Jisas ampu nakimp moule epe na, “Mini ka mantiek apmilelel, mini ka knuan apmilelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kil niuknu yuwa nti moule ka sopilel nak na, “Yipm ser nti ekeielel ka sop apmel, nti ka mamam apmilel antempel nti knuan knuan apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kona mentit mi maken mi ka nakerpm puikn Waiek apmilel ka ar yemp keipmelel, kil ankil ka mamintomp apmilel, niaikno apmilel, mantiek apmilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Awun ekilelel i, Jisas nkarp yek yitne nainkul kuriekn. Kil mpi nkupmus mpepwarmp mita. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","I nti mentitmaken mitinkel arko la amiser kil. Kapepe Jisas mpi yukur na misil wutumpepel, pe nti mentitmaken ka at mpepwarmp mita at nenk. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I kapepe Jisas akei sanklomp mitinkel nankimp nti. Kil nak na, “Yipm eipm. Mouleel ka mpi i yalip rukopm ar niokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kil yalip mpimpi i, rukopm mpurel ka nkis yayapel i, karokn akir, nti aipm pokel la yuweip nkamp apul mpi aim. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pe rukopm mpurel ka nkis yemp ka wuntokn marnk silel, kitapm ka akei nakerkel, karokn miritink. Walenk ka pokel namp aser, niamp ankilel karokn a pmin, ka a kutuwur wuntokn marnk. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eti awun akorpel i walenk ampu ninkerim. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pe rukopm mpurel ka nkis yemp ka rukopm mpuas yenkelel nkisel. Ntiwuye nael, i mpuas yenkel ka pokel na sukn eti aworamulmp rukopm, eti ka niayeknelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aser rukopm mpurel ka nkis kitapm sepmel i rukopm nakerel, mpurel ka naker 100, pe mpurel ka naker 60, pe mpurel ka naker 30. Kapepe. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Moule ka ntanku tneiel, kil ko eipm sank epie.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Niatel i, nti moule ka sop Jisasel la aser kil i nti namiyimil na, “Apulntaku yikn akei sanklomp irpm nakimp nti mentitmakenel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","I Jisas ampu nakimp nti na, “Apm akei sanklomp irpm nakel ka apulpaser niupukn irpm ka ampueik ar nkuwepmel, ka Wulapm Weink ntimiremp yipm ankil apulp yayapel ka kil na yuwulmp nti mouleel. Pe nti ntitmaken sukurel, karokn. Apm karokn nakimp nti niupukn akorpel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Weink ankilel ka ntalekil. Kona mouleel yum yapmunemp sepmelel, Wulapm Weink arai yek kil yapmunemp sepmel mitinkel yintempel i yapmunemp ankilel kapukorokn wank. Aser kona mouleel karokn nkamp ntinkirai aim yapmunemp sepmelel, yapmunemp akopiteknel ka kil aimel ara yawopmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","I kapepe, yipm ko ser ntinkirai apulp weink ka piepe apm akei sanklomp irpm nakimp ntiel. Nti oko ser mpuampua, aser nti kapukorokn ser yuworel. Nti ka akei ntanku eipm sank, aser ka nti karokn eipm kankre. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nti ntitmaken, ampueikampueikel Aisaia ka nak yapmunemp Wulapm Weinkel apulp nti ntape na, Yipm oko eipm sank Wulapm Weinkel aninkanink aser ka yipm kapukorokn eipm sinkre. Yipm oko ser mpuampua mitinkel, aser ka yipm kapukorokn ser yuworel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nti ntitmaken epe yapmunemp antuel ka so yatip, ntanku antuel ka nti muorp, niampepm antuel ka tumukulpm. Eti ka nti karokn eipm aser kankre, pe yapmunemp antuel karokn atitakor apulp sank ka apm nakel ko nti nimplemp yapmunemp antuel na sop apmel nako apm yupul nti na yer sepmel. Karokn. (Aisaia 6:9-10) ");
INSERT INTO xbi_y_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jisas nakimp nti moule ka sopilel na, “Aser yipm, Wulapm Weink ka apul yipm sepm, niampepm ntanku aiyipmel ka akosepm ntinkiraiyim. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Apm nakimp yipm likeknel, ampueikampueikel, nti moule ka nakaworp yapmunemp Wulapm Weinkelel antempel nti moule sepmel ka nakerpm sank Wulapm Weinkelel, ntiarko ka puikn apulp na nti na ser simisimi irpm pe yipm aserel. Aser ka nti karokn ampu aser. Pe nti ka puikn apulp na nti na eipm sank pe yipm eipmel. Aser ka nti karokn ampu eipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","I Jisas ampu aiki nak na, “Kapepe, yipm ampu eipm weink sanklomp karep apm nak apulp moule ka yalip rukopm ar niokn ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka ntalekil. Kona nti moule eipm sank sepmel yupulp Wulapm Weink na yuwulmp nti yer nta ankilelel aser nti karokn aim ar yapmunempel, ka nuarep rukopm ka nkis yayapel i ka Satan pokel la nkampel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pe rukopm ka nkis yemp wuntokn marnk silel, kil ka nkarp pitekn aser niamp ankilel karokn yuwei a pmin, eti ka pokel ninkerim. Sank epie ka muati apulp mouleel ka eipm sank Wulapm Weinkel i kil mpuaimpuai apulpel. Karokn akir ka kil pokel nkamp aim apmuei yapmunemp. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aser kil po eipm na nti moule na yupul kil kuret yupulp sank Wulapm Weinkel epe kil nkampel, kil ka pokel nkarpmok awomp sank Wulapm Weinkel apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pe kona mouleel eipm sank Wulapm Weinkel i yum yer yapmunempel, aser yapmunemp ankilel ka ar mitimitink apulp mpuampua kitapmelel, ka nuarep rukopm ka nkis antemp mpuas yenkelel. Kil ka apulp na mper wuntokn suknel yer nta ankilel. Mpuampua kitapmel epe ka niayekn amulmp sank Wulapm Weinkel. Kil karokn apul sop, ka yawopmel apmuei yapmunemp ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pe kona mouleel eipm sank Wulapm Weinkel yukorpel i kil yum yer yapmunemp i yupul sop sank ka kil eipmel, ka nuarep rukopm ka nkis kitapm sepmel. Sankwunamp ankilel kil apulel ka rukopm nakerel, mpurel ka naker 100, mpurel ka naker 60, pe mpurel ka naker 30.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas nakimp nti sank na, “Apm'a yuwor sanklomp nikimp yipm yupulp nti moule ka ar nta Wulapm Weinkel i kil awulmp ntiel. Ka nuarep sankmuati pie apm'a niekel. Mouleel ei wit ar niokn ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pe moule ka antempil nkisemp wuroknel, kil ka aser na nomp po a i nti ntitmaken po ar niumpuel, kil ka mpi yamilip mpuas'uretel nuarep witel ka ar amintempel wit karep waiek nioknel eiel, i kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ar mpimpi, wit po na sukn, rukopm nanker i, nti moule ka apulpil nioknel nti ampu amiser mpuas'uretel ka na nuwarkwayo antempel wit. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kapepe nti mpi aser waiek mputnankel i nakimpil na, Yii, waiek! Ant ka nak na ka yikn ei wit likekn ar nioknel. Apulntaku po mpuas'uretel ampu na antempelel? ");
INSERT INTO xbi_y_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I kil nakimp nti na, Moule ka antemp apm nkisemp wuroknel, kil la yalip mpuas rukopm kuretel ar. Eti nti moule ka apulpil nioknel ampu namiyimil na, Yikn puikn apulp na ant'a mpi nuromp mpuas'uretel opo na sompwat? ");
INSERT INTO xbi_y_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aser kil nakimp nti na, Karokn. Ka yipm korokn nuromp mpuas'uretelel, yipm ko yireikel nuromp wit yintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yipm yuwomp ntiwuye tnei yo likekn serp sukn mpimpi na wit rukopm kona so na rael. I kapepe ko apm nikimp nti moule kona yupul nioknel na, Sukur yipm nuromp mpuas'uretel, pe yipm kitin waimpwaimp mper yer, nako arai ant yikei yite wusel. Niatel ko yipm ra wit epe, aknump muar yitne mpawuel apmilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas ampu aiki awor sanklomp nakimp nti sank na, “Kona Wulapm Weink na yer niorknel yuwulmp nti mouleel, ka ntaka mastet wunael ka mewelel yalip ar niokn ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet wuna karokn ntaka lorukopm mpurel ka suknelel, karokn. Ka akopitekn ako. Aser mastet epe arai no suknel ntaka loel yuwulmp wonk irpm ka ar nioknel. Kil ka na mpeikn i ntiknank amor, i nti aipm ka la apul wapm antuel misil mastet ntiknank irpm. Wulapm Weink kona yuwulmp nti mouleel, kako soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas ampu nak sanklomp na, “Kona Wulapm Weink na yuwulmp nti mouleel, ka ntaka mikeikuret akopitekn nti aiyimp yisel. Kona makenel yikei yis akopitekn nimplemp luwu suknel kako wamprip luwu sukurel nako limain yiki sukn muanumporel. Nti moule ka ar nta Wulapm Weinkelel kako yupul soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sank irpm ka Jisas nakimp nti moule ntitmakenel, karokn kil nakimp nti sank niupukn aworp. Karokn. Ka kil awor lomp nak sankmuati suwainkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ampueikel moule ka nakaworp yapmunemp Wulapm Weinkelel kil nak na, Apm kako yikei sanklomp sukueimp yipm yupulp yapmunemp irpm Wulapm Weinkel ka ampueik ar nkuwepmelel. Eik kitapm nimpiliek lala ekeielel, ka kil karokn aiye niupukn nak yapelel. (Buk Song 78:2) Sank epe ka moule ampueik nakel, pie Jisas apul misop. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas awomp nti ntitmaken apmot, kil po mpi muar yitne yekipmin. I nti moule ka sopilel la aser kil i nti nak na, “Eti yikn ampu sukueimp ant sank niupukn aipopel yupulp sankmuati apulp mpuas'uretel ka na ar mputnankel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I Jisas nankimp nti na, “Moule ka ei witel ka apm, Es Ntitmaken Akeiwantoel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pe mputnank ka muati apulp kitapm pie ant arel. Wit rukopm ka muati apulp nti moule ntitmaken ka ar nta Wulapm Weinkel i kil awulmp ntiel. Pe mpuas'uretel ka muati apulp nti mentitmaken ka ar nta Satanelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Moule wuroknel ka la yalip mpuas rukopm kuretelel ka muati apulp Satan. Kona wit so i nti rael, ka muati apulp kitapm pie ant arel kona niatel. Pe nti moule ka apul nioknel, ka muati apulp nti ensel Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mpuas'uretel ka nti naromp as yiteel, ka muati apulp nti moule ntitmaken ka ar nta Satanelel, kona kitapm niat i, ko yite yel ntiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apm Es Moule Wantoel, arai wankes nti ensel yo nkrakemp yemp Wulapm Weinkel ka kil awulmpel. Nti arai nkiyir nti moule kuretel, kana kuap nti moule ka ar nta Wulapm Weinkel na yupul sankwunamp'uretelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nti moule kuretel epe arai nti ensel somp nti yawol yo yite suknel. Nti arai yikei mayon nainiunku sinkerel mplomplo yer yite. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Niatel i nti moule Wulapm Weinkel sankwunamp antuel ka akosepmel, nti ko yupmuei yemp sepmel ankilel, ka kil awulmp ntiel. Miniampepm antuel arai yontiyelkn nuarep awun weink mperp nael. Kona yipm moule ntanku tneiel, yipm ko eipm sank ka apm nakel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas nak na, “Wulapm Weink kana yuwulmp yipmel nako yipm yer nta ankilelel ka ntaka sanklomp epie apulp wuntokn raiel ka nti kitip waimpel antup nkuwepm tnei kitapm. Mouleel la ninkemel i kil ka mpuaimpuai ankil. Kil ampu nkimepm i kil mpi amiyimp waiek kitapmel i kil nkamp mpuampua ankilel sukurel akei nkamump wuntoknel. Niatel i, kil mpi wat wuntokn ankilel sukurel ak waiek kitapmel i kil nkamump kitapm epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas nak na, “Sanklomp nonkelel ka ntalekil, ka nak apulp nti mentitmaken kana yer nta Wulapm Weinkelel i ko kil yuwulmp ntiel. Mouleel ka awup yuwawompelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kona kil ninkem yuwawompel epe ka likeknako yatipel, kil mper mpuampua ankilel sukurel akei nkamp wuntoknel i kil la wat wuntokn sukurel ankilel akei nkamump.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas nak na, “Sanklomp nonkel ka ntalekil. Kona Wulapm Weink kana yuwulmp nti mentitmakenel, ka ntaka ntoknpuank ka nti moule akei nkamp yokn mpuampua ar mpepel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kona yokn nontip yer ntoknpuankel, i ko nti ye yupul nomp nenk. Nti nkis i nti antunel yokn. Yokn kuretel nti nkamp wat. Pe yokn sepmsepmel nti mper apmuei wunink. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kitapm sukurel kona niatel kapuko ntapepe. Nti ensel Wulapm Weinkelel arai yo nikile nti moule kuretel ka antemp nti moule akosepmel arel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Arai nti yawol nti moule kuretel yo yite suknel ko nti arai nainiunku sinkerel yikei mayon mplomplo yer yite.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pe Jisas nayim nti moule ka sopilel na, “Eti yipm ka ntinkirai apulp weink irpm sank ekeielel tikikn?” I nti nakimpil na, “Kope.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eti kil nakimp nti na, “Nti moule wupm raiel ka eipm sank Wulapm Weinkel apul sopel, nti ka ntaka waiek yitneel. Kil po mpi muar yitne yael ankilel epe i kil nkamp mpuampua rankel antempel mpuampua niumpueiel apul naimukul.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jisas nakimp nti sanklomp niatel i, kil awomp nti apmuei, kil po mpim wompitne weink ankilel. Kil mpi yank Wulapm Weinkel antuel i kil namikimp nti mentitmaken sank Wulapm Weinkelel. Nti eipmil sankel, nti ka nkark pupurur ankil, yapmunemp nti yakopel nak na, “Moule epe ka nkamp yapmunemp ntinkiraiel ar oku? Kil nkamp mintenk ar oku pe kil apul niokn niawurpmel ntakilelel? ");
INSERT INTO xbi_y_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ant ka ntinkirai apulp moule epe. Kil ka ninkilapm antilel, waiek ankilel ka moule apulapul yitneel, mamam ankilel ka Maria. Pe Jems nti Josep antempel Saimon nti Judas ntiarko ka knuan ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pe nti niaikno ankilel, nti pie antemp ant ar. Apulntaku ko kil yupul niokn irpm ekilelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Eti nti karokn yapmunemp likekn antempil. Aser Jisas ka ampu nakimp nti na, “Mouleel ka nakaworp yapmunemp Wulapm Weinkelel, ka nia nkampil ar wampwamp. Pe wompitne weink wopmweink ankilel karokn, nia karokn nkampil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kapepe kil karokn apul niokn niawurpmel mitinkel ar wompitne ankilel apulpaser nti karokn yapmunemp mintenk apulpil. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herot, moule mamp ka awulmp kitapm Galiliel, kil eipm sank ampulp niokn ka Jisas apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eti kil numpul ampulp, i kil nakimp nti moule nioknel ankilel ntalekil, “Jisas epe ka Jon Baptaisel tikikn, ka ampu nkarp ar yemp wompel pe kil apul niokn niawurpmel ntakilelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot wunempwaiyimp ntakilelel ka apulpaser kil ka numpul apulp sank ampueik Jon nak apulp Herotel, i Herot ar kil wuntu miyep. Ka ntalekil. Jon nak Herot apulp ampueik ka Herot nineik maken knuan ankilel Pilipel i antempil nkisel. Nia makenel ka Herodias. Ntape i, Jon nakimp Herot na, “Karokn akosepm pe yikn nkamp maken ekilelel.” Eti Herot nakimp nti ntankamp Jon, kitipil ntankaik, mper kil apmuei yitne kuretel pmin. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot kana yer Jon wuntuim, aser kil nkinkiekn ampulp nti ntitmaken apulpaser nti ka nak na Jon ka moule akosepmel ka nakaworp yapmunemp Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aninkel nti moule mpurel la antemp Herot al niepm ampulp nioknwank ampueik ka mantiek ankilel ra kilel. Nti al niepm nkisel i, ninkilapm maken Herodiasel la apul nkaikpuank apmuei niampepm antuel. Eti Herot ka puikn ampulp nkaikpuank ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","I Herot nak numuar nak na, “Mpuampua simisimi ka yikn apulpel, kona yikn yimp apmel arai apm yek yikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ntape i, Herodias, mamam maken epeel, amuk kil yapmunemp. I ninkilapm maken epe namikimp Herot na, “Apm puikn apulp na yikn yuntun Jon Baptaisel mamp, yum yo yuko, somp yupulp apm no.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot eipm sank ekeielel, kil ka yapmunemp wankepmel ankil. Aser kil wunempwamiyimp sank ka kil nak nuwarel ar niampepm nti moule ka antempil nkis al niepmel, i kil nkarkemp wule maiyaknel. Eti kil nakimp nti moule aipmpienel na yupul misop karep maken nakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","I kil wankes mouleel mpim yitne kuretel pmin na nimikimp nti moule aipmpienel na nti na yuntun Jon wourenkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mamp ankilel ka nti aim a yuko apulp maken ninkie epe mila. I maken epe nkamp apulp mantiek ankilel mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pe moule ropm Jonel ka nti moule ka sopilel nkamp apul mpi amuntup. Nti antupil niatel i, nti mpi namikimp Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas eipm sank apulp Jon ka nti ar kil wuntuel i, kil awomp yemp epe apmuei. Kil ka nkamp wutumpepel kua nti moule ka sopilel, ntiarko mpim yemp kuserel, moule karokn arel. Aser nti moule ntitmaken mitinkel eipm, nti napmok na, Jisas karep mpim yemp kuserelel okor. I kapepe nti moule ntitmaken pe awomp yemp suknel apmuei, nti po sopil awupil ntape mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas la tnei mpep mitael, kil yukur a kitapm i kil amiser nti moule ntitmaken muanumpor pe karep la akei mitnei. Kil wunempampulp nti minimini ka wule apulel i kil ampu apul nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nti ar mpi awun nimimpilemp i, nti moule ka sopilel la i nankimp Jisas na, “Epie ka yemp kuserel, awun po nako yumu kitapm. Akosepmel, yikn wankes nti ntitmaken na nti yipmot. Nti yirko mpi wompitne irpm, wat wuntokn yuwup niepm nti na yelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aser Jisas nakimp nti moule ka sopilel na, “Ka nti na mpi yupulpi? Ka yipm ankil yek nti niepm yel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","I nti nakimpil na, “Apulntaku! Niepm ant karokn apul mitink epie. Ka luwu ntintir ntakitiempuel, yokn wuyeel pie ant apulel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I kil nakimp nti na, “Luwu ntintir irpm yokn pe yipm apulel, yipm ampu yupulp apm la.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I Jisas nankimp nti ntitmaken na, “Yipm yo nkis kitapm.” I kil nkamp luwu ntintir ntakitiempuel antempel yokn wuyeel, i kil niampepm na keipm nak naremp Wulapm Weink ampulp niepm epe. Niatel i, kil wamiker luwu ntintir i amuk nti moule ka sopilel. I nti moule ka sopilel amuk nti ntitmaken aim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nti akeiwanto al mpimpi aser lunkoim, i niepm wainki wainki nkupmus. Nti moule ka sop Jisasel nkamp nkamp aim a 12-pla rumpunk. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nti mentit ka al niepm ekilelel, muati antuel ka 5,000 moule. Pe nti karokn waperp nti maken ninkilapm antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas nakimp nti moule ka sopilel na, “Apm pe na yer pie pitepitekn. Yipm somp wutumpepel yuntun mpepwarmp niorknel mpi nenkitie.” I kil wankes nti ntitmaken apmot ampul likekn wuye. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nomp'a nimpiempel, kil likekn mpi namp malenk ampulp na kil na yintemp Wulapm Weink niek sankel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ar mpi nomp sosoel i, wutumpepel karep mpim mpepwarmp niumonel. Wolpm na ale mpep, akei ntampli wutumpepel ntilonk, eti wutu karokn mpi, ka waipipiyim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wuyen rienel i, Jisas at sil mpep keipm la naimukulup nti moule ankilel ka sopilel, nti ka sil wutumpepelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nti aser kil at sil mpep keipmelel, nti ka nkinkiekn ankil, wunuyumukur nti. Nti maarkikip i nti nak na, “Yii! Epe ka muanumpor tikikn” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aser arokn akir, Jisas nakimp nti na, “Yipm 'orokn serk, yipm yet mintenk. Pie ka apm pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ampu nakimpil na, “Sepmel, kona ka yiknel, eti yikn nikimp apm na apm'a yet sil mpep keipm mpi ser yikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eti Jisas nak na, “Kope, yikn la.” Ntape i, Pita yukur yek wutumpepel a mpep i kil at sil mpep keipm akeimp Jisas mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aser wolpm na nkirnkerelim, eti Pita nkinkiekn ampulp i nkaik ankilel nkrur amu mpep pmin. Ntape eti, kil markipniminket Jisas na ntasompil. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas pokel yuwei nta a salmikemp Pita. I Jisas nankimpil na, “Pita, yikn karokn akei apm nkael. Eti yapmunemp aiyiknel pe wuyeel tikikn. Weink ekilelel ka weink mi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ntiwuye yukur na wutumpepelel, i karokn akir wolpm kamikir. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pe nti moule ka sil wutumpepelel nti waker nkaik aiki nia Jisasel namp keipm, nti napmok na, “Ka likeknelim. Yikn ka Ninkilapm Wulapm Weinkel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas kua nti moule ka sopilel mpi mitnei nenk apmuei kitapm wainki antuel Genesaretel. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kapepe, nti moule yemp ekilelel aser amorel kil ka Jisas ankil. I nti mper sank mpim wompitne mitinkel ka ar kitnan kitnanel, na nti yupul nti moule mitinkel irpm ka wule apulel la na ser kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eti nti antemintenk Jisas na kil ko mpuaimpuai yupulp nti moule ka wule apulel, nti na ntasomp elmpuapm nikitei ankilel. Eti nti ntitmaken akeiwanto ka apul ntakilelel, wulenip antuel ka miniat. Nti ampu ka akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ekilelel i, nti Farisi mpurel antempel nti moule wupm raiel yek Jerusalem la i amiser Jisas. I nti amiyimpil na, ");
INSERT INTO xbi_y_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apulntaku nti moule ka sop yiknel, nti karokn apul sop sank antuel mesepmelel ka ampueik mporantunel, ka apulpi? Nti moule aiyipmel karokn kaikul nta niorkn nako nti yel niepmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","I Jisas ampu nakimp nti na, “Eti apm'a niyim yipm, apulntaku yipm ampu ka walimp sank Wulapm Weinkel mper sank yapmunemp mesepmel irpm aiyipmelel miniorkn? Pe sank niawurpmel Wulapm Weinkel ampueik ka mporantunel ka yipm ampu wamiker, ka apulpi? ");
INSERT INTO xbi_y_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wulapm Weink nak na, Yikn ko niremp waiek mantiek aiyipmel, eipm sank antuel yupul nti sepm. Pe kil ampu nak na, Kona mewel aiyipmel niekilai waiek mantiek ankilelel, arai yipm yer kil wuntu. (Kisim Bek 20:12 yintempel 21:17) ");
INSERT INTO xbi_y_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ampueikel Wulapm Weink ka nakimp yipm sank niawurpmel epie, aser yipm ka apul sop yapmunemp milman mipmakn aiyipmelel suwaink. Yipm ka nakimp waiek mantiek aiyipmel na wuntokn yipm mper apulp na wakerp ntiel ka miniat. Ka apulpaser wuntokn epe karep yikn amuk Wulapm Weink. Nti mesepmel aiyipmel ka nakimp yipm na yipm ka apul akosepm. Nti nak nana yipm korokn numpul yupulp sank niawurpmel Wulapm Weinkel ka nak na yipm kapuko niremp waiek mantiek aiyipmel yupul nti sepmel. Ka mekitik. Apulntaku! Ka kuret! Yipm ka wamiker sank niawurpmel Wulapm Weinkel kana yer nuarep mpuampua kuserel. Wuntokn aiyipmel yipm karokn akei wakerp nti waiek mantiek aiyipmel apulp nti sepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ka yipm akei wule kurieknel nak sank ninkaielel! Ampueikel Aisaia, moule ka nakaworp yapmunemp Wulapm Weinkelel, ka nak amorp sankwunamp aiyipmel ntape na, ");
INSERT INTO xbi_y_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Wulapm Weink ka nak na, Nti mentitmaken epe ka akei niepm kurieknel aiki nia apmilel, pe yapmunemp pmiempniumpuaipm antuel ka apei yempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nti ka nkamp sank yapmunemp antuel manmaknel nak na, Epie ka sank Wulapm Weinkel. Aser ka nti nak yapmunemp moule kitapmelel, naremp apm kuserel.” (Aisaia 29:13) ");
INSERT INTO xbi_y_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kapepe Jisas aiyimp nti mentitmaken la aser kil i, kil nakimp nti na, “Yipm eipm sank epie, wunempwaiyimp aipopel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Niepm ka yipm alel, kapukorokn yupul yikn i yikn kuret sankorkel yer niampepm Wulapm Weinkel. Karokn. Aser sank yapmunemp ka yek yekipmin naikul niepmel, ekilelel ka apul moule kuret sankorkel apmuei niampepm Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niatel i, nti moule ka sop Jisasel la i nakimp Jisas na, “Nti Farisi ka wunemp'uret apulp sank pe yikn nak i nti eipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","I Jisas ampu nak sanklomp nak na, “Waiek apmilel po ar na yemp keipmelel ka are niokn, pe kil akeimp niepm ar. Pe nimum ninkakn irpm ka kil karokn akeimpel, arai kil nuromp yintempel niamp sukur muat. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Eti ka yipm korokn yapmunemp wankepm yupulp nti Farisi. Nti ka nuarep moule ka akei tukulpmel at, i na ntremp kuap mewel niampepm tukulpmel yayapelel. Kona ntiwuye yet yintempel, arai ntiwuye yintempel nkiyi yo lie.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","I Pita ampu nakimp Jisas na, “Eti yikn ampu niek yuworp niupukn sanklompel pe yikn nakimp nti ntitmakenelel, ant ampu eipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","I Jisas nak na, “Ka apulntaku? Yipm'arokn eipm kankre mi? ");
INSERT INTO xbi_y_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Eti yipm nimpil eipm. Niepm ka yipm alel ka yek kuriekn war yekipminel, ka a ar lunko eti ka aiye muat. Eti mpuampua epe karokn apul moule kuret sankorkel ar niampepm Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aser ka sankwunamp aiyipmel pe ka yek yekipmin naikul niepm kurieknel ka nkarp ar yapmunemp. I ka mpuampua pepe ka apul yipm kuret sankorkel ar niampepm Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ka apm nak apulp sankwunamp irpm ka nkarp ar yapmunemp mouleelel, ka ntalekil. Kona yipm aim yapmunemp'uretel miel, pe ka yipm aimpar moule wuntuelel, pe ka yikn apul wurkite, pe ka sank ninkaielel ka yikn nak ar niampepm antuel moule lowulaelel mi sank kuretel ka yipm nkamp mperp mewelel, pe yapmunemp aiyiknel nkarp na yupul tniompreimp irpmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wunamp irpm ntakilelel ka apul moule na yer kuret sankorkel yer niampepm Wulapm Weinkel. Pe moule karokn kaikul nta sop sank antuel manmaknelel, epie karokn apul moule na yer kuret sankorkel yer niampepm Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kapepe Jisas awomp yemp epe apmuei i kil mpim yempel ka ar nantip yemp suknel Tair irpm Saidonel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pe makenel Kenanel karokn ntieyarkup antuel Judaelel, ka ar pepe. Kil la akei mpeiknel aiyimp Jisas i nak na, “Sepmel, Knamniumpuai Devitel, yikn wunempyupulp apm! Ninkilapm maken apmilel ka muanumpor yanker aimpil kuret ankil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aser Jisas karokn ampu nakimpil sank wainkiwainkiel. Kapepe, nti moule ka sop Jisasel mpi i namikimp Jisas na, “Maken epe ka ma aworawor nkirnker yatip. Yikn ampu wankesil mpim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","I Jisas ampu nakimp nti na, “Wulapm Weink ka wankes apm na simpop nti ntitmaken Israelel likekn. Nti ka nuarep wus sipsip ka yawopmel ar yempelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aser maken epe la kitnan i kil waker nkaikyumpo eip kitapm apulp na yiki nia Jisaselel i kil nak na, “Sepmel, ko yikn yupulp apm!” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I Jisas ampu nakimp maken epe sanklomp na, “Ant korokn simpop nti ninkilapm niepm na mperp niumpua.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aser maken epe ampu nak na, “Sepmel, ka yikn nak wat amu ntunk. Aser nti niumpua, nti ka nuanti niepm nirepm ka naikul a kitapmel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisas eipm sank ekilelel i kil ampu nankimpil na, “Mantiek, yapmunemp aiyiknel ka mintenk yatip ar apmel! Eti puikn aiyiknel yikn apulp na nininkel, kako ninink.” Ankrik ka Jisas nak sank ntakilelel i, ninkilapm maken ankilel epe ampu ka akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas awomp yemp epe apmuei i, kil at sop mpepwarmp Galili mita mpim. Kil mpi namp malenk i kil nkupmus. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kapepe nti moule ntitmaken mitinkel arko la amiser kil. Nti mpurel ka nkaik kuretelel, antempel nti moule ka ntankaik awur mpilmpilelel, antempel nti ka niampepm liknelel, antempel nti ka niepm nanintipelel sank karokn nakel, antempel nti minimini ka wulenip apulel, nti apul ntiarko la i mper nti ar kitnan namintip Jisas, i kil ampu apul nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kapepe nti moule ntitmaken amiser nti ka niepm nanintipel ampu napmok sank, pe nti ka ntankaik awur mpilmpilelel ampu ka akosepmim, pe nti ka ntankaik kuretelel nti ampu ka apmot wunamp. Antempel nti ka niampepm liknelel, niampepm nti ampu ka nimin. Eti nti ka yapmunemp pupurur ampulp Jisas, i nti aimiki nia Wulapm Weink Israelel namp keipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas aiyimp nti moule ka sopilel la i kil nakimp nti na, “Apm wunempampulp nti moule ntitmaken epe. Nti antemp apm ar awun wuyelikeknelim, eti nti ka niepm karoknim. Apm'arokn apulp na apm'a wankes nti yikei nilmpel mpi. Nilmp'o yer ntiel, niampepm ko nu nti, i nti ko nkiyi yer yayapel tikikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","I nti moule ka sop Jisasel nakimpil na, “Nti ka mitink yatip, ko ant somp niepm mitinkel yer oku nako ant yek nti yelel? Yemp epie ka moule karokn ar.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I Jisas namiyim nti na, “Eti niepm atipm pe yipm apulel?” I nti nak na, “Ant apul 7-pla luwu ntintir antempel yokn akopiteknel mpurel, karokn mitink.” ");
INSERT INTO xbi_y_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kapepe Jisas nakimp nti ntitmaken na nkupmus kitapm. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kil nkamp 7-pla luwu ntintir antempel yokn, i kil nak namiremp Wulapm Weink i kil waker awor amuk nti moule ka sopilel. Kapepe nti moule ka sop Jisasel nkamp i amuk nti ntitmaken. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I nti al mpimpi aser lunkoim, i nti moule ka sop Jisasel nkamp niepm wainki wainki ka nti al nkisel aim amu 7-pla rumpunkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nti mentit ka al niepm ekilelel ka 4,000 pe nti maken ninkilapm ka nti karokn waperp nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kapepe i, Jisas wankes nti ntitmaken ampul likekn wuye, pe kil ka yukur na sil wutumpepel i kil po mpim kitapm antuel Magadenel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nti Farisi antempel nti Sadyusi nti la na mperpai Jisas. Nti nakimpil na, “Kona yikn apul niokn Wulapm Weinkelel, yikn ampu yupul niokn niawurpmel likekn ntremp ant nako ant ser yukorpel mintenk Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aser kil ampu nakimp nti na, “Awuniunkuriknel yipm ka nak ntape na, Mpor akosepm yipilnaiyenk milep, awun ko mitnei. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pe nomprien mpor ka kuasemp'uretel, yipm ka nak na, Wolpm wutnie puko yimir. Yipm aser mpor keipmel, muati walenk ankilel ka yipm aser kaminkre. Aser muati walenk ka ntremp yipm apulp mpuampua pe ka ninkem yipm ar kitapmelel, yipm karokn aser aworel niupukn ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yipm ntitmaken ka pie nkisel, yapmunemp aiyipmel antemp Wulapm Weinkel ka kuret ankil, nuarep moule ka nkisemp apul tniompreimp ntankermpel. Aninkanink yipm ka nak na yipm'a ser niokn niawurpmel suwaink. Aser karokn.” Eti Jisas nakimp nti na, “Arai yipm ser niokn niawurpmel likekn ampueik ninkem Jona, moule ka nakaworp yapmunemp Wulapm Weinkelel.” Niatel i, kil awomp nti apmot, kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas antempel nti moule ka sopilel karep antun mpepwarmp mpim nenkitie, aser nti moule ka sopilel wunempiskel luwu ntintir, nti karokn apul. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","I Jisas nakimp nti na, “Yipm ko yikei wunempel yet niampepm ntankuel yupulp yis ka nti Farisi antempel nti Sadyusi akeiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eti nti moule ka sopilel nakimp nti ankil na, “Pie kil nakimp ant ntakeielel ka apulpaser ant'arokn apul luwu ntintir la, tikikn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ka ntinkirai apulp sank pie nti nakel i kil nakimp nti na, “Apulntaku pe yipm nak na luwu ntintir yipm aroknel? Yapmunemp aiyipmel ka wank. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yipm peyar karokn ntinkirai apulp niupukn sank apmilelel tikikn? Yipm'arokn wunempwaiyimp luwu ntintir ntakitiempuel mi ka nti 5,000 ntitmaken alel? Wainkiwainki nkisel, ka yipm aim a rumpunk atipm? ");
INSERT INTO xbi_y_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Eti 7-pla luwu ntintir ka nti 4000 ntitmaken al mi wainkiwainki nkisel ka yipm aim a rumpunk atipm? Yipm ka wunempiskel amintempel tikikn? ");
INSERT INTO xbi_y_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Apm karokn nakimp yipm apulp luwu ntintir. Yipm wunempwaiyimp ntakilelel, ka apulpi? Karep apm nakimp yipmel, yipm yikei wunempel yet niampepm ntankuel yupulp yis antuel nti Farisi antempel nti Sadyusiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nti eipm sank ekilelel, nti ntinkiraiyim, ka kil nakimp nti apulp sank simi ka nti Farisi antempel nti Sadyusi yuwap ntiel, ko nti yikei wunempel yupulp na sank yapmunemp antuel kakorokn mpuanink yapmunemp Wulapm Weinkel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas mpim yemp suknel Sisaria Filipai, ekilelel i kil naiyim nti moule ka sopilel na, “Mi nti ntitmaken nak nana apm Es Ntitmaken Akeiwantoel, apm ka mini?” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nti nakimpil na, “Nti mpurel ka nak nana yikn ka Jon Baptaisel ka Herot ar kil wuntuel aser ka kil ampu nkarpel tikikn. Pe nti mpurel ka nak nana yikn ka Elaija mi, Jeremaia mi, moule mini ka ampueik nakaworp yapmunemp Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I Jisas namiyim nti na, “Eti yipm i, yipm nakel, apm ka mini?” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita nakimpil na, “Yikn ka Krais, moule ka Wulapm Weink yuwakel. Yikn ka Ninkilapm Wulapm Weinkelel, kil ka ar aninkaninkel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Niatel i, Jisas nakimpil na, “Saimon ninkilapm Jonel, Wulapm Weink ka apul yikn akosepm. Apulpaser karokn mewelel kitapm ekeielel nakimp yikn yapmunemp epe, karokn. Ka yaiyai apmilel ar yemp keipmelel, kil ankil ntimpiremp yikn. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Apm nakimp yikn, nia kitie Pitael pie karep yikn apul misop niupukn niael. Eti apm ko miyimp yikn Pita, ka niupukn nak apulp wuntoknel. Wuntokn epe kako wula weink i ko apm yupul nti ntitmaken apmilel na yer nuarep yitne ka sil wuntokn keipm mi ka mintenkel. Eti mpunkol niawurpm mpuampua kuretel kitapmel kana yer nti moule wuntuel kapukorokn sankork nti ntitmaken apmilel. Karokn. Nti ko yer yupmueiel nuarep mpepwuntoknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mpunti apmilel arai apm yek yikn nta aiyiknelim. I kapepe kona yikn niek na, Wunamp epe ka kuret, yipm'orokn yupul ntakilelel - yikn nak ntakilelel ka sop yapmunemp Wulapm Weinkelel. Pe kona yikn niek na, Wunamp epe ka akosepm yipm yupul sop - Yikn nak ntakilelel ka sop yapmunemp Wulapm Weinkelel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niatel Jisas ka nakantup nti moule ka sopilel mpunkol mpunkolel na nti korokn nikimp mewelel ntape na kil ankil ka Krais, moule ka Wulapm Weink yuwakel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ekeielel ka sukur Jisas nakimp nti moule ka sopilel apulp wankepm kana ninkemilel. Kil nak na, “Ekeielel apm ko mpim Jerusalem yupulp na apm ko somp yakop suknel yer nta antuel mesepmelel, nti ka moule mamp antuel prisel yintempel nti moule wupm raiel. Nti na yer apm wuntuel, ko nomp wuyelikeknel yumuntun apm yer mpi i, ko apm ampu sirpmop.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita eipm kuret sank ekeielel. Kil kua Jisas mpi yakitie i kil nakamuntupil mintenk mintenkel nak na, “Sepmel, Wulapm Weink kako wunempyupulp yikn, niekyuntup wankepm epe kakorokn ninkem yikn epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aser Jisas ampu nakimp Pita na, “Satan, yikn yikei yuworp kitapmel, yikn yer nkien. Ka yikn kuap apm na yupul yapmunemp'uretel. Karokn yikn sop yapmunemp Wulapm Weinkel epe, ka yapmunemp moule kitapmelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","I Jisas nakimp nti moule ka sopilel na, “Moule mini kana sop apmel, kil kakorokn wunempyupulp wule ankilel. Kil kako yirkos wankepm mimi kana ninkemilel kona kil na nikerpm apmel, sop arai ko apm yirkos lonkuntonkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Apulpaser kona mouleel wunempserp mpuampua kitapmel ankilelel ka apul kil na yer sepmelel, arai kil yikei yawopmelel. Pe kona mouleel wunempwaiyimp apm niorknel i wunempiskel mpuampua kitapmel ankilelel, kil ko yer sepmel yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Moule epe ka nia nkampil apulp mpuampua kitapmel mitinkelel, kona kil yuwurel, mpuampua ankilel karep kil aiki kepmel tneiel ko yupulpil ntakulel? Kapukorokn. Karep akei yawopmelelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Apm Es Ntitmaken Akeiwantoel arai kua nti ensel Wulapm Weinkelel nako apm yikei mpunkol niawurpm ankilel Waiek apmilel yo. Apm arai yuntunel nti ntitmaken wantoel sop sankwunamp antuel ka nti apulel i arai apm yupulp nti waperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Apm nakimp yipm likeknel, mpurel aiyipmel yipm moule peyar nkisel kako ser Es Ntitmakenel yet ntaka moule mampel niorkn, i ko yipm yumur.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nomp ntakitiempu niampepm amuntun i, Jisas kua Pita antempel wuyeel es knuan Jems nti Jon, ntiarko namp malenk suknel i, nti likekn apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nti at amiser Jisas, aser wule ankilel naimimpil. Mpuaminiampepm ankilel ka ntiyilntiyelelim, pe elmpuapm ankilel ka mpusmail yatip. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aser Moses nti Elaija ka ampueik awurel, ntiwuye nukur na antemp Jisas napmok sank i, nti moule ka sopilel amiser. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita aser ntakilelel i kil nankimp Jisas na, “Sepmel, akosepm ant ar keielel. Kona yikn puiknel, apm'a yupulp yipmarko wuyelikeknel mpilmpal kitielel nintilem yipm. El aiyiknel, el Mosesel, el Elaijael.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita peyar nak sank aser mpor mlipmlaiknel amulmp nti. I sank tiknin naikul mpor nankimp nti na, “Kil epe ka ninkilapm apmilel, apm ka puikn apulpil yatip. Apm ka mpuaimpuai apulpil. Yipm eipmil sank.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nti moule ka sop Jisasel eipm ntakilelel, nti ka nkinkiekn ankil. Eti nti waker nkaikyumpo mpul mpuaminiampepm amu kitapm. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Eti Jisas la ntankamp nti, aiki nti i, kil nankimp nti na, “Yipm serp. Yipm korokn nkinkiekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nti nkarp niampepm amuntupil, aser nti karokn aser mewelel antempil at, arokn. Ka nti aser Jisas likekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nti nisep malenk epe mi nti mpi ael, Jisas nakimp nti mpunkolelim na, “Muati pie yipm aserel, yipm'orokn nikimp mewel, mekitik. Ko yer mpimpi ser apm Es Aiyipmel Ntitmakenel ko serp yupmuei yemp muanel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eti nti moule ka sopilel namiyimil na, “Nti moule wupm raiel ka nak na pitepitekn kona Krais na yoel, sukur Elaija ko yo niorknel. Ko yupulntaku?” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I Jisas nankimp nti na, “Sank epe ka likeknelim. Elaija kako la niorknel na ntimpiramp nti ntitmaken yupulp Krais ko nininkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aser apm nakimp yipm, Elaija karep mila, aser nti moule karokn aser kil aworel. Karokn. Sankwunamp ka nti nkis akei apupulel pisop puikn antuel. Arai ko nti yupulp apm Es Aiyipmel Akeiwantoelel kapuko kuret soplikekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eti Jisas nak ntakilelel, nti moule ka sopilel karep ntinkiraiyim, ka kil nak apulp Jon Baptaisel pe, ka nkamp yemp Elaijaelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas kua nti moule wuyelikeknel ka sopilel mpim, i nti niminkem nti ntitmaken mitinkel ka arel. Mouleel la aser Jisas, waker nkaik eip kitapm ampulpil, ");
INSERT INTO xbi_y_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","i kil nakimpil na, “Sepmel, yikn wunempyupulp ninkilapm ntit apmilel. Ka mpienyukur kil, moule kil ka nkuankuan kuret ankil. Aninkanink kil ka nkaiyi mpi yite, nkaiyi a mpep ntentenkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Apm kua kil mpi aser nti moule aiyiknel ka sop yiknel, aser niawurpm antuel karokn sukn nako nti yupul wule ankilel na niatel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","I Jisas ampu nakimp nti na, “Yipm ntitmaken epe, yapmunemp aiyipmel karokn mintenk nako yipm yikei Wulapm Weink nkaelel. Yapmunemp aiyipmel ka nkirnker yatip. Ko apm yintemp yipm yer, yirkos wankepm aiyipmel mpimpi waiyoel mi? Yipm ampu yupulp apm ninkilapm epe la.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kapepe Jisas nak nkimiyir muanumpor yanker i muanumpor yanker naikul amomp ninkilapm epe, i arokn akir wule kil akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","At pitepitekn i, nti moule ka sop Jisasel, nti likekn la aser Jisas i nakimpil na, “Ka weink mi ant kakorokn nkiyir muanumpor yanker opoel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","I Jisas ampu nakimp nti na, “Ka apulpaser yapmunemp aiyipmel ka wank. Ka apm nakimp yipm likeknel, kona yapmunemp mintenkel aiyipmel apulp Wulapm Weinkel kona akopitekn ntaka mastet wunael, kona yipm nikimp malenk na wasirkel, malenk epe ko wasirk mpim. Yapmunemp aiyipmel kona yer mintenk yintemp Wulapm Weinkel, niokn niawurpmel wantoel kako yipm yumpul.” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas antemp nti moule ka sopilel ar likekn ar Galiliel, i Jisas nakimp nti na, “Nti arai mper apm Es Aiyipmel Ntitmaken Akeiwantoel mpi nta antuel mouleel, ");
INSERT INTO xbi_y_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","i ko nti yer apm wuntuim. Apm ko yer awun wuyelikeknel i ko apm ampu sirpmop.” Nti moule ka sop Jisasel eipm sank ekilelel, nti ka yapmunemp wankepmel yatip. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Niatel i, Jisas antempel nti moule ka sopilel mpi niminink yemp suknel Kaperneam, i nti moule kana somp wuntokn apulp yitne suknel Wulapm Weinkelel la aser Pita namiyimil na, “Mi moule sepmel ka yipm sopel ka apikei pe wuntokn kana mper yupulp yitne Wulapm Weinkelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","I Pita wankerpwunemp nak na, “Kope.” Eti Pita mpi muar yitne, aser kil peyar karokn nak sank, i Jisas naiyimil miniorkn na, “Saimon, apm'a nikimp yikn sanklomp i yikn ampu eipm. Eti yikn nikimp apm yapmunemp aiyiknel, yikn wunempwaiyimp ntakulel? Nti moule mamp ar kitapm ekeielel, nti ka yimp nti mini na kuap nti wuntoknel? Ka nti aiyimp nti ninkilapm antuel? Mi rokn, ka nti aiyimp nti moule kurieknel ka nkis kitapm karep nti nkampel kuap wuntokn antuel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","I Pita nak na, “Ka nti moule wampwampel nkis kurieknel likekn ko yek moule mamp wuntokn ntalepeel.” I Jisas ampu nakimp Pita na, “Ka yikn nak wat amu ntunk. Nti ninkilapm antuel ka antemp nti arel, nti karokn. Wiakn moule mampel karokn aikol nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sanklomp epie ka ntremp ant apulp aiyimp antuel nti moule opoel, nti kana yimp kuap ant wuntokn yupulp yitne suknel Wulapm Weinkelel. Karokn niokn apmilel nako apm yupulp nti wuntokn epeel. Aser nti karokn ntinkirai apulp nana apm ka ninkilapm Wulapm Weinkel. Eti ant oko yek nti wuntokn kuserel, ant'orokn yintemp nti nukuapm yupulp. Kapepe yikn mpi mpepwarmp yuwup yokn, pe yokn sukur kona yikn sompel yikn sakor kil niepm, pe i arai yikn ser wuntokn raiel likekn pe ar kil niepm yekipmin. Yikn somp wuntokn epe yupul mpi yek nti moule opo yupulp antie, kako wuntokn antieel yupulp yitne suknel Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ekilelel i, nti moule ka sop Jisasel la aser Jisas i naiyimil na, “Kona Wulapm Weink somp yemp yet yapel ntaka moule mampel, mini ko yintempil yer niorknel na nia suknel sompilel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kapepe Jisas aiyimp ninkilapm akopiteknel la i, ntankampil apul apmot niumonel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","I kil nak na, “Apm nakimp yipm likeknel, kona yipm korokn nimplemp sankwunamp aiyipmel ampu ntaka nti ninkilapm ninkilapmelel, yipm kapukorokn yer nta Wulapm Weinkel i kil yuwulmp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kona moule mini nimplemp i yer ntaka ninkilapm akopiteknelel na korokn wunempwaiyimp nia sepmel na sompilel, moule epe arai yer niorknel kona Wulapm Weink yuwulmp antel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pe kona moule mini ka at nia apmilel nako mpuaimpuai na somp mouleel ka nuarep ninkilapm akopiteknel epieel, kil ka wunempapulp apm ankil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","Jisas ampu nak na, “Kona mewel kuap mouleel ka nuarep ninkilapm akopiteknel epe ka akei apm nkaelel, na kuapil yuwomp apm na yupul kuretelel, ka apm aser kuret ankil.” Jisas yukantun i nak na, “Apm wunempapulp nti ntitmaken kitapmel. Nti moule ka akei apm nkael ntaka ninkilapm akopiteknelel, nti kako ninkem nti moule yatel mpurel kana kuap nti na yupul yapmunemp'uretel. Moule mini epe kana kuap ntiel arai ninkem wankepm yer nta Wulapm Weinkelel. Kona nti somp wuntokn suknel yumpop yukol kil wourenk na yawol kil yo mpepniopm mi kil wuntuel, wankepm epe ka akopitekn. Aser na wankepm arai ninkemilel kako suknelip. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kapepe kona ntankaik aiyiknel na kuap yikn na yer nkis wunamp'uretelel, ko yikn yuntun wat. Akosepmel yikn yikei ntankaik likekn yer, mi araiel ko yikn yer sepmel yupmueiel yer yemp keipmelel. Aser kona yikn nirknimp ntankaik aiyiknel wuye yer sukurel, arai nti somp yikn moule sukur yawol yo yemp yiteel ka ar aninkaninkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pe kona niampepm aiyiknel kuap yikn na yer nkis wunamp'uretelel, i ko yikn ye sompwat. Akosepmel yikn yikei niampepm kitie likeknel yer, aser arai ko yikn ankil yer sepmel yerelel. Aser kona yikn nirknimp niampepm wuyeel aiyiknel tneiel, arai nti somp yikn moule sukur yawol yo yemp yiteel ka ar aninkaninkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Yipm ko yikei wunempel. Yipm korokn niek na mouleel ka ar nkis nuarep ninkilapm akopiteknel ka akei apm nkaelel ka si akoel. Karokn. Apm nakimp yipm, ar na yemp keipmel nti ensel Wulapm Weinkel ka wakerp ntiel, nti ka mintenk yatip, pe aninkanink nti ka aser mpuaminiampepm Waiek apmilel po ar na yemp keipmelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jisas ampu nak na, “Yipm wunempwaiyimp ntakulel? Mewelel ka wakerp 100 wus sipsip, pe likekn ka yawopmel, kil ko yupul mi? Eti nti 99 wus sipsip epe arai kil yuwomp yet malenk i, kil arai mpi yuwup likekn ka yawopmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Apm nakimp yipm likeknel. Nti 99 wus sipsip ka karokn yawopmelel, mpuaimpuai ankilel apulp ntiel ka ako. Pe kona kil ninkem likekn ka yawopmelel, mpuaimpuai ankilel kapuko nkirnkerip. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Waiek apmilel ka ar yemp keipmelel ka soplikekn. Kil karokn puikn na likekn antuel nti moule ankilel ka nuarep nti ninkilapm akopiteknelel ko yawopmel yupmueiel. Karokn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas ka nak ntalekil, “Kona ko mamintomp Kristenel aiyiknel yupul yikn kuretel, yikn mpi ser kil nako yipmwuye likekn yerel. Ko yipmwuye likekn ampu nkis niek sank yuwup yapmunemp yumu likekn. Kona ko kil eipm yikn sankel, ko yipmwuye ampu yer yapmunemp niuluknunel nako yipmwuye ampu yer sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aser kona kil korokn eipm yikn sankel, ko yikn somp mewel likekn mi wuyeel mi ampu mpi yintempel yikn, yupulp nako ntiwuye yet niumonel eipm yipm sankel. Ka apulpaser sank niawurpmel ka nak na, Sankwunamp akeiwantoel kako moule wuye niek yapmunemp mper yo likekn yupulp. (Lo 19:15) ");
INSERT INTO xbi_y_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aser kona kil korokn eipm sank i kil na mipmaip yupulyupulel, yikn nikimp nti ntitmaken Wulapm Weinkel yikeiwanto nako nti yintempil niekel. Kona kil korokn eipm sank antuel soplikeknel, ka yipm yupulpil ntaka yipm apulp nti moule kurieknel nuarep nti Judael ka ak moule mamp antuel Romel wuntokn aiyipmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Apm nakimp yipm likeknel, yapmunemp irpm mimi ko yipm ntayintemp yer kitapmel, karep Wulapm Weink ntaantemp ar namp yemp keipmelel. Aser yapmunemp irpm mimi ka yipm nisep ar kitapmel, karep Wulapm Weink nisep apmuei yemp keipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Apm ampu na nikimp yipm. Kona moule wuye aiyipmel nkis niek sank yum yapmunemp yo likekn yimp Wulapm Weinkel, kil ko yupul misop ka ntiwuye aiyimpilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Apulpaser kona yipmwuyeel mi wuyelikeknel mi niye yikei nia apmilel yer nkisel, apm ankil ka antemp yipm ar.” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ekilelel i, Pita mpi aser Jisas i nakimpil na, “Sepmel, kona mewel yupul apm kuret i ko apm eipm ser yikei yuwompelel, kako apm yupulpil ntakilelel anink atipm? Kako apm yupulpil anink 7-pla pe, tikikn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","I Jisas nakimpil na, “Apm karokn nakimp yikn nako yikn yupul anink 7-pla ako, karokn. Epe karokn anink mitink. Ka apm nakimp yikn na kako yikn yupul yupmuei yupmueiel. Yikn'orokn yupul yikei waperpel nako anink atipm ko yikn yupulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","I kapepe, Wulapm Weink kona yuwulmp nti mouleel, kako nuarep sanklomp epie, apm'a sukueimp yiknel. Yikn eipm. Aninkel, mesepmelel ampu na somp wuntokn ankilel ka nkis nti moule nioknel ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kil apul niokn epe misop sank'arep kil nakel, i nti apul mewelel la amiser kil. Moule epe, wuntokn ka nkisilel ka sukn muanumporelip, muati ankilel ka nuarep 10 milien wuntokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aser wuntokn muati ntakilelel moule epe karokn mper. Eti mesepmel epe nak na, Wuntokn kil arokn, i kapepe yipm sompil yintempel nti maken ninkilapm ankilel yintempel mpuampua sukurel antuel yikei somp wuntoknel yumuk apm. Yipm ko mper nti mpi nta mewelel ko nti yupulpil niokn kuserel aninkaninkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Moule epe eipm sank epie, aser kuretim. Kil ka numuarep niumpua ka mintomp ar sop ropmelel mpi, i kil markipniminketil nakimpil na, Mesepmel, kako yikn yikei nainkerp apm, yukueim apm. Arai apm ampu yek yikn mpuampua ka apm nkampop yikn i pie nkis apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","I mesepmel nak na, Akosepm. Apm wunempapulp yikn, ka yikn yupul yikei watel. I kil wankesil nainkul kuriekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","I kapepe, kil yek yitne nainkul kuriekn, aser kil niminkem meniem ankilel ampueik kil ak kil wuntokn 10 kina ako ka nkisilel, i kil amuntupmali kil, wakerkikaik kilim, i kil nak na, Kako yikn yumpuk apm piepe wuntokn apmilel ampueik apm ak yikn i pe nkis yiknel! ");
INSERT INTO xbi_y_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Meniem ankilel eipm sank ekilelel i, kil pe mintomp ar sop ropmel nuarep niumpua mpi, markipniminket moule epe, nankimpil na, Yikn yikei nainkerp apm, yukueim apm. Arai apm ampu yek yikn wuntokn aiyiknel ka nkis apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aser moule epe karokn eipmil sank i, kil mpi nakimp nti moule aipmpienel i nti la nkampil apul mpim yitne kuretel. Kil ko yer mpimpi ser kil ko ampu yumuk kil wuntokn wamperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nti meniem ankilel moule nioknel epe aser ka kil apulpil ntakilelel, yapmunemp nti ka kuret ankil. I nti mpi sunkueimp mesepmel antuel sank ampulp moule nioknel epe ka nti eipm aserel. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eti mesepmel epe aiyimpil la i nakimpil na, Yikn epe, yikn apul kuret! Karep ka yikn la naiyim apm apulp wuntokn suknel apmilel ka nkis yiknel, apm'arokn kuasemp yikn, apm ka akei nainkerp yikn. Karep apm wunempampulp yikn. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eti apulntaku yikn karokn na wunempyupulp meniem aiyiknel soplikeknel? ");
INSERT INTO xbi_y_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mesepmel epe ka wunemp'uret ankil i kil mper kil mpim nta antuel moule aipmpienel nako nti yeryitor kilel. Ko nti yeryitor kil mpimpi ser wankepm wuntoknel ka nkisilel kona niatel, i ko miniatim. Sank ka ntapepe. ");
INSERT INTO xbi_y_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sank epie apm sukueimp yipmel ka ntremp ant yapmunemp waiek apmilel po ar na yemp keipmelel. Kona yipm'orokn wunempiskel yapmunemp'uretel ka mewel apulp yipmel, Wulapm Weink oko yupulp yipm misop sank karep apm nakimp yipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas nak sank irpm niatel i, kil po awomp kitapm Galili apmuei, kil po mpim kitapm Judiael ka ar yek yakitie pukn Jordanel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","I nti ntitmaken mitinkel pe misopil. Kapepe, ar yemp ekilelel, nti mini ka wule apul ntiel ka kil apulp nti akosepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aser nti Farisi la i mimperpai Jisas. Nti namiyimil na, “Eti sank niawurpmel antilel ka nak na, akosepm ko an nkiyir makenel, mi rokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I Jisas ampu nak na, “Mi ka yipm karokn aser sank ka sil wupm Wulapm Weinkelel? Sank epe ka nak na, Ampueik nimpilieknel ka Wulapm Weink apul kitapm sukurelel, kil ka apul ant moule, pe kil antuninper ant ntitmakenel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","I Wulapm Weink nak na, Kapepe mentit ko yuwomp waiek mantiek ankilel yer. Kil ko yer yimintempel maken ankilel. Ntiwuye ka mpim likekn, karokn yatyatel. Karokn. Wulapm Weink ankil ka ntankamp ntiwuye apul mpi likeknel, moule kakorokn yuntun.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","I nti Farisi nakimpil na, “Eti ka Moses nakimp ant na ant ko yupul wupm na nkiyir makenelel, ka apulpi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I Jisas ampu nakimp nti na, “Moses aser amorel yipm, yipm ka moule yapmunemp soel. Ampueikampueikel yapmunemp apulp na nkiyir makenel, Wulapm Weink karokn nak. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Apm'a nikimp yipm na, kona makenel karokn apul tniompreimp, aser minkan ankilel ankil nkiyir kil puikn ankilel eti kil ampu nkamp maken yatelel, minkan niorknel ankilel ankil ka apul tniompreimp. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nti moule ka sopilel eipm sank epe i nti nakimp Jisas na, “Kona ntakilelel, ka mekitik, ant yer kuserel, korokn somp maken.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I Jisas nakimp nti na, “Ka nti mpurel, Wulapm Weink ak nti yapmunemp ntinkiraiel na somp sank epie na yum yer yapmunempel, pe ka nti wanto karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yipm eipm, nti moule mpurel ka at arompelel, weink ankilel ka yatyat. Nti moule mpurel ka ntape yek ninkopmnilmp ampu, wunaikn antuel ka amur. Pe nti mpurel wuyepm antuel ka nti amiye. Pe nti mpurel ka nakantup maken apulp na nti na yupul niokn Wulapm Weinkelel. Aser moule mini kona yapmunemp likekn yintempel sank wantosukurel ekeielel, kil ko yum yo yapmunemp ankilel yupul sop.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Awun ekilelel nti mentitmaken apul nti ninkilapm la amiser Jisas. Nti apulp na kil na wul nta sil nti, yimp Wulapm Weink ko yupul nti sepmel. Aser nti moule ka sop Jisasel napmok nti mentitmaken. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","I Jisas ampu nakimp nti moule ka sopilel na, “Yipm yikei niampepm ser nti ninkilapm la ser apm. Korokn nkiyir nti, karokn. Wulapm Weink ka awulmp nti moule mini, yapmunemp antuel ka nuarep nti ninkilapm ekeielel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kapepe kil aiki nta wul nti ninkilapm mamp, i kil awomp yemp epe apmuei, kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wasiamelel la aser Jisas i nak na, “Sepmel, yikn ka moule akosepmel. Yikn nikimp apm na wunamp sepmel simi ko apm yupul i ko apm yintemp Wulapm Weink yer sepmel yerelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I Jisas nakimpil na, “Apulpi yikn aiyimp apm moule akosepmelel? Ka Wulapm Weink likekn ka akosepmel. Aser kona yikn na yintempil yer sepmelel, kako yikn sop sank niawurpmel Wulapm Weinkelel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","I moule epe ampu naiyim Jisas na, “Yikn nakel, ka sank niawurpmel simi?” I Jisas nak na, “Sank niawurpmel irpm ka nak na, Yipm korokn yer nti ntitmaken wuntu. Yipm korokn yupul tniompreimp. Yipm korokn yupul wurkite. Yipm korokn yintemp nti mentitmaken yikei sank ninkaielel nukuapm yer niampepm antuel moule lowulaelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Aninkanink yipm ko eipm sank waiek mantiek aiyipmelel yupul nti sepm. Pe nti moule wantosukurelel ko yikn yikei nta niupuknel nkrawomp nti, ko yikn yupulp nti ntaka yikn apulp wule aiyiknelel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aser wasiamel epe nakimp Jisas na, “Sank niawurpmel Mosesel epe ka apm misop. Aser sank niawurpmel simi ka apm wunempiskel nako apm yupulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","I Jisas nakimpil na, “Kona yapmunemp aiyiknel na yer sepmel ntinkiraiel suwainkel, yikn mpi somp mpuampua sukurel aiyiknel pe i yikei somp wuntoknel. Wuntokn yikn nkampel, yikn mpi walimp yek nti moule ka mpuampua karoknel. Yikn yupul ntakilelel, Wulapm Weink oko yupulp yikn sepm waperel yupmuei yemp sepmel ankilel. Pe yikn la sop apm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wasiamel epe eipm sank epe aser ka kuret, yapmunemp ankilel wankepmel yatip apulp mpuampua mitinkel ka kil mperel, eti kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","I Jisas nakimp nti moule ka sopilel na, “Apm nakimp yipm likeknel, nti moule ka mper wuntokn suknelel, nti ka awup ntinkiliemp na yer nta Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Apm nakimp yipm, wurokn kapukorokn war pirkepm lipanel. Karokn. Moule ka mper wuntokn suknelel ka soplikekn, kil ka ntinkiliemp na war yer nta Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nti moule ka sopilel eipm sank epeel, yapmunemp nti karep nkark prierprur ankil, i nti nak na, “Kona ntakilelel, moule ko war yer nta Wulapm Weinkel ntakulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kapepe Jisas nkumusomp nti i kil nak na, “Nti moule kapukorokn yupul setel na nti yer nta Wulapm Weinkelel, aser Wulapm Weink likekn oko yupulp nti.” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas nak ntape i, Pita ampu nankimpil na, “Yikn eipm. Pie ant sop yikn i, mpuampua antilel ant akei pmompelel, ko yikn yupulp ant ntakulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","I Jisas nak na, “Apm nakimp yipm likeknel, aninkel Wulapm Weink na yupul kitapm niumpueielel, apm Es Ntitmaken Akeiwantoel arai nia sompel, apm arai sil lontulnko akolikeknel apmilel. Ekilelel, yipm moule ka sop apmel, yipm arai sil 12-pla lontulnko akosepmel i ko yipm yer miniorknel nti 12-pla wopmweink Israelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kona nti moule minimini ka sop apm i, nisep yitne, nisep knuan kna, waiek mantiek, ninkilapm, niokn mputnank yerel, mpuampua likekn likekn ntalepe ka nti nisepel arai nti somp sukn mitinkel ntaka 100-pla mpuampua waimienel na somp yemp mpuampua likekn likekn ka nti awompel. I ko nti yintemp Wulapm Weink yer sepmel yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pe nti moule mitinkel ka ar niorknelel, nti arai ampu yer nkien. Pe nti moule mitinkel ka ar nkaienel, nti arai ampu yer niorknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas ampu aiki nak na, “Nti moule ka Wulapm Weink awulmp ntiel, ka nuarep sank pie apm'a sukueimp yipmel pe. Ka ntalekil. Moule ka nuapropm kitapm mitinkelel, kil nkarp akei rienel mpi anuyapel nkamp nti moule ko yupulpil niokn wuntoknel na lep rukopm wain ankilel yer niokn ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nti moule kana yupulpil niokn wuntoknel ka antempil kitip sank ampulp wuntokn atipm ka kil na yek nti yupulp awun likeknel, i waiek nioknel po wankes nti mpi apul niokn apmuei niokn wainel ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kapepe awun akorpel i kil pe mpi amiser nti moule ka ar kuserel at anuyapelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I kil nakimp nti na, Aei, yipm mpi niokn wainel apmilel yupulp apm niokn mpurel. Arai apm yupul wunamp sepmel yek yipm wuntoknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","I nti eipmil sank i nti po mpim. Pe yek awun ropmel mpi awun nimpilempel, mesepmel epe ka ampu mpi anink wuye apul misoplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Awun a kitapmelel i, kil po mpi amiser nti mpurel ka ar kuserel ar anuyapelel. I kil namiyim nti na, Apulntaku pe yipm ar kuserel awun mpeikn mpeikn ekeielel? ");
INSERT INTO xbi_y_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","I nti ampu nakimpil na, Ka mewel karokn ampu ak ant niokn setel. I mesepmel nakimp nti na, Pe yipmarko mpi yupul niokn yer niokn wainel apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Awun niunkurikn nompelim, i waiek nioknel nankimp moule ankilel ka ar niorknel nti moule irpm ka apul niokn wuntoknelel na, Yikn yimp nti moule ka apul nioknel la, yek nti wuntokn awun likeknel. Yikn yek nti likekn likekn nintilem, nti ka la nkaienel ko yikn yek nti niorkn mpimpi tnei nti ka la niorknel, ko yikn yek nti nkien. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kapepe nti moule ka la apul niokn awuniunkuriknel, nti la nkamump wuntokn awun likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pe nti moule karep la apul niokn niorknelel, nti mila. Nti ka nak na nti oko somp ako no keipm, aser karokn. Ka nti nkamp soplikekn, wuntokn awun likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nti aser wuntokn ka nti nkampel, i nti napmok mesepmel epe na, ");
INSERT INTO xbi_y_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nti moule ka la nkaienel, niokn ka nti apul akopitekn awun muati likekn ako, aser yikn ampu ak nti wuntokn muati soplikekn mi! Ant ka apul niokn yek nomprien lael, ant ka apul niokn ntinkiliempel, awun karep al ant kuret ankil! ");
INSERT INTO xbi_y_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Waiek nioknel eipm sank ntakilelel i kil ampu nakimp mewel antuel moule ka apul nioknel na, Aei, yikn epe, apm karokn apul yikn kuret. Eti karepel antarko ka kitip sank yapmunemp a likekn apulp wuntokn awun likeknel, mi rokn? ");
INSERT INTO xbi_y_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eti yikn somp wuntokn aiyiknel, i yikn yipmot. Kona apm'a yek yipm yikeiwantoel wuntokn soplikeknel, ka puikn apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ka yapmunemp apmilel. Apulntaku apm korokn yek yipm wuntoknel sop puikn apmilelel? Kona apm'a yupul nti sepmel, eti yikn ampu yapmunemp yakopel apulpi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","I Jisas nak na, “Ka mintapepe, nti moule ka ar nkaienel nti arai ampu yer niorknel. Pe nti moule ka ar niorknelel arai ampu yer nkien.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas mpim Jerusalem i kil nkamp nti moule ka sopilel mpi mita i nakimp nti nunkualel na, ");
INSERT INTO xbi_y_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yipm eipm. Ant pe na mpim Jerusalem. Pe nti arai mper apm Es Aiyipmel Wantoel mpi nta antuel nti moule mamp antuel prisel antempel nti moule wupm raiel. I ko nti niek apm, yer apm wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","I ko nti mesepmel epe mper apm mpim nta antuel nti moule yatelel, nti karokn Judaelel. I nti ankil epe ko yikei mua ntampli apm, mpuliep apm, i ko ntemp apm yinkol lonkuntonkel, i apm ko wuntuim. Pe apm ko yuwur na yer yemp muanelel kako awun wuyelikeknel i ko apm ampu sirpmop.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ar i, maken Sebediel kua ninkilapm ntit wuyeel antuel mpi amiser Jisas. I kil waker nkaikyumpo eip kitapm i kil na nimikimpil sank ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kapepe Jisas amiyimpil na, “Yikn ampu la nikimp apm sank yikn'a niekel.” I maken epe nankimp Jisas na, “Kona yikn yer yapel ntaka moule mamp antilelel, apm apulp na yikn ko somp nti ninkilapm wuyeel apmilel ka sop yiknel, mper ntiwuye niorknel yer yakitie yakitie aiyiknel na yuwulmp nti wantoel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas eipm sank ekilelel i kil ampu nakimp nti na, “Sank epe yipm nakel, ka yipm nkis akei napekel, yipm karokn wunempwaiyimp aipopel. Ko yipmwuye yet mintenk yirkos wankepm ntaka arai ko apm yirkosel, mi rokn?” I ntiwuye ampu nak na, “Kope, antie ka mintenk, arai antie yirkos.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I Jisas ampu namikimp ntiwuye na, “Akosepm, yipmwuye arai yirkos wankepm ntaka apm'a yirkosel. Aser apm korokn niek puikn apmilel yupulp nti mini ko yer niorknel yintempel apmel. Karokn. Ka Waiek apmilel ankil ko ntimpramp nti moule mini ko somp yemp ekilelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nti 10-pla moule yatel ka sop Jisasel eipm ntiwuye es knuanel naiyim Jisas ntakilelel, i nti ka yapmunemp'uret ampulp ntiwuye. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aser Jisas aiyimp nti la i kil nankimp nti na, “Yipm eipm. Nti moule mamp ka ar kitapm ekeielel, nti ka apulp nia antuel na yer no keipmel. Eti nti ka nakimp nti moule akeiwanto mintenk mintenkel na nti ko eipm sank moule mampel yupul sop suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aser yipm ankil, yipm korokn yupul sop po nti apulel. Karokn. Kona mewel aiyipmel apulp nako nia sompil yer niampepm antuel ntitmaken Wulapm Weinkelel, moule epe kakorokn yiki nia ankilel no keipm. Karokn. Moule epe ko yer ntaka moule kuserel, nia karoknelel nako yupulp nti moule yikeiwantoel niokn kuserelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pe kona mouleel apulp na yer niorknelel, kil ankil arai yer nkien. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Apm Es Aiyipmel Akeiwantoelel kapuko soplikekn. Apm karokn a, na kuap nti moule na yupulp apm nioknel. Karokn. Apm ael, kana yupulp nti ankil, apm ko yuwur nako nantip mua yirkomp nti mitinkel na nti ko yintemp Wulapm Weink yer sepmel yupmueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas antempel nti moule ka sopilel awomp yemp suknel Jeriko apmuei, nti po mpim. I nti mentitmaken mitimitink arko misop Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pe moule wuyeel ka nkis yayapel mita. Niampepm ntiwuyeel ka liknel. Ntiwuye eipm sank apulp Jisas ka lael, ntiwuye ma awor napmok na, “Ai! Knamniumpuai Devitel, yikn wunempyupulp antie!” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nti ntitmaken eipm ntiwuye nak ntakilelel, nti nakimp ntiwuye mpunkolel na, “Yipmwuye yikei mitiknel.” Aser ntiwuye akei mamael napmok na, “Sepmel, Knamniumpuai Devitel, yikn wunempyupulp antie!” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eti Jisas la kitnan, aiyimp ntiwuye la i, kil napmok na, “Yipmwuye puiknel, apm'a yupul yipmwuye ntakulel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","I ntiwuye nakimpil na, “Antie puikn apulp na yikn'a nin ant niampepm ka liknelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eti Jisas wunempapulp ntiwuye i, kil wul nta misil nti niampepm, i niampepm ntiwuyeel ampu nimin. I ntiwuye sop Jisas mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Aninkel, Jisas antempel nti moule ka sopilel mpi kitnan nantip Jerusalemel, i nti mpi niminink wompitneel ka nti aiyimp Betpetsel ka ar malenk Lo Olivel. I kil nankimp nti moule wuyeel ankilel, wankes nti mpim, i kil nak na, “Yipmwuye mpi wompitne kitnanel epe. Kakorokn akir yipmwuye arai ser wus donki ka nti kitip atel, siknamp ankilel pe antempil at. Yipm sinkeip nti mua, yupulp apm mila. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Konana mewel nikimp yipm sank setelel, ko yipmwuye nikimpil na, Moule sepmel ka ant sopel wankes ant la na somp nti yupulpil mpi. I ko kil wankes nti pokel mila.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","Kapepe ntiwuye mpi apul misop sank ka Jisas nakimp ntiel. Ntiwuye nkamp nti wus donki tniokn siknampel apul nti mila, i ntiwuye kankeip elmpuapm mpeiknel ntiwuyeel i mul nti wus donki keipm. I Jisas na misil keipm. Moule ka nakaworp yapmunemp Wulapm Weinkelel, sank ampueik ka kil nakel pie ant niampepm nkupmus, pie niminink. Sank ankilel ka ar wupm Wulapm Weinkel ka nak na, Nikimp nti moule ntitmaken Saionel sank, niek na, Yipm ser. Moule mamp aiyipmel pe mila. Kil ka sil wus donki keipm akei niumuaipmel la. Kil karokn aiki nia ankilel. (Sekaraia 9:9) ");
INSERT INTO xbi_y_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","I kapepe nti mentitmaken aser Jisas sil wus donki lael i nti wunempwamiyimp sank Wulapm Weinkelel ka pie niminink. I nti moule akeiwanto kankeip elmpuapm mpeiknel antuel i nti mper yaya apmuei yayapel. Nti mpurel ka antun rukopm nkuniemp atno i apul soplikekn na kil na nikerpm yetel. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jisas at niumon, pe nti moule ntitmaken ka at niorkn nkaien, pe nti akeiwanto aiki alump i nti nak na, “Mpuaimpuai apulpil, kil ka Knamniumpuai Devitel! Yiki nia ankilel no keipm. Wulapm Weink arai niumuayikei moule epe ka akei nia Wulapm Weinkel lael. Yiki nia Wulapm Weinkel, kil ka ar niorknel!” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kona Jisas war Jerusalem ntakilelel, nti akeiwanto ar Jerusalemel ka nkark kuret ankil i nti aiyimp naiwulp nak na, “Moule epe ka moule mini?” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","I nti moule ka antempil lael, nti nak na, “Kil ka Jisas, ka moule nakaworp yapmunemp Wulapm Weinkelel. Kil ka eik wompitne ankilel Nasaret ka ar kitapm Galiliel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas war lomp ka nti akei yinink yitne suknel Wulapm Weinkelel i, kil nkimiyir nti moule ka apul niokn wuntokn ar ekilelel. Nti moule mpurel ka nimplemp wuntokn, nti moule mpurel ka mper aipm na nti ntitmaken na yikei wuntokn epe somp na wul wompwuyepmelel. Jisas aser ntiarko ntakilelel i kil ntankamp loyopm irpm waimp pe aiki nimplemp nkimiyir nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I kil nakimp nti na, “Sank ka ar wupm Wulapm Weinkelel, kil ka nak na, Yitne apmilel ka yemp nti ko yintemp apm niek sank yerel. (Aisaia 56:7) Aser yipm ankil, yipm ka apul numuarep yemp ka nti mewurkite nkurupm arelel!” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ar yitne Wulapm Weinkelel i, nti moule ka niampepm liknel antempel nti ka nkaik kuretelel, nti la amiser kil i kil ampu apul nti sepmim. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aser nti pris antempel nti moule wupm raiel, nti amiser niokn niawurpmel ka kil apulel. I nti yupmueipm nti ninkilapm ninkilapm ka aiki alump ar war lomp yekipminel ka antup yitne Wulapm Weinkelel. Nti ninkilapm ka nak na, “Antarko mpuaimpuai apulp Knamniumpuai Devitel!” Eti nti mesepmel antempel nti moule wupm raiel wunemp'uret, ");
INSERT INTO xbi_y_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","i nti namiyim Jisas na, “Karep yikn yupmueipm po nti nakel?” I Jisas wakerpwunemp nakimp nti na, “Kope, karep apm yupmueipm. Eti yipm karokn eipm sank ar wupm Wulapm Weinkel tikikn ka nak na, Ka Wulapm Weink ankil aiki nti ninkilapm yapmunemp i nti aimiki nia ankilel.” (Buk Song 8:2) ");
INSERT INTO xbi_y_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","I kil awomp nti apmuei, kil nainkul kuriekn. Nomp ekilelel, kil ka mpi apmuei Betani. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas nkarp akei nompel ampu mpim Jerusalem. Kil at yayapel la i nilmp amor kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I kil amiser lo fik likekn ka tnei yayapel mitael, i kil mpi kitnan loim. Kil niampepm antup lo, aser rukopm karokn ampu naker. Karokn. Ka atno kuserel ar. Kapepe kil akei mai ar lo fik i nak na, “Ka yikn korokn ampu niker rukopm. Mekitik.” Eti karokn akir, lo fik epe pokel ninkerim. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nti moule ka sopilel aser ntakilelel nti karep nkark kuret i nti nak na, “Apulntaku lo fik epe ampu pokel ninkerel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","I Jisas ampu nakimp nti na, “Apm nakimp yipm likeknel, kona yapmunemp aiyipmel yer mintenk yintemp Wulapm Weink i korokn yapmunemp wuyeelel, pie apm apulel, ka arai yipm yupul soplikekn ntapie apm apulp lo fikel. I arai yipm yupul muati yatel yintempel ntalekil, i kona yipm nikimp malenk epe na, Yikn korokn yer, yikn yo mpepniopm, eli ka malenk epe arai yupul sop pe yipm nakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ka apulpaser kona yipm niek sank yintemp yapmunemp mintenkel yupulp Wulapm Weinkel, simi yipm naiyimil apulpel, arai yipm somp.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas mpi muar lomp ka nti akei antun apulp yitne Wulapm Weinkelel i kil yumuap nti mentitmaken. Aser nti pris antempel nti moule mamp antuel Israelel la aser Jisas i nak kil naiyimil na, “Yikn nkamp mpunkol niawurpm epe ar oku pe yikn apul niokn ntakilelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","I Jisas ampu nakimp nti na, “Apm korokn pokel nikimp yipm niorkn. Aser apm apmel ampu na yimp yipm sank yatel. Kona yipm nikimp apm yuwa sop sank ka apm naiyim yipmel, i ko apm nikimp yipm likeknel yupulp mini pie ak apm niawurpm i pie apm akei apul nioknel. Kapepe. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Apm'a niyim yipm. Ampueik ka Jon rup nti moule a mpepel, kil nkamp niawurpm epe ar oku? Ka niawurpm Wulapm Weinkel mi, rokn ka yapmunemp mouleel?” Kapepe nti nakimp nti anti napmok na, “Kona ant niek na Jon ka akei niawurpm Wulapm Weinkelel, Jisas arai ampu niyim ant na apulntaku ant karokn na sop sank ka Jon nakel? Kako kuret. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pe nonkel, kona ant niek na Jon ka akei yapmunemp mouleelel, ant ko yinkei wunempel yupulp nti ntitmaken. Nti arai yupul ant kuret tikikn, apulpaser nti ka nak na Jon ka moule sepm ka nakaworp yapmunemp Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eti nti ampu nakimp Jisas na, “Nakil, ant antemwunemp.” I Jisas ampu nakimp nti na, “Ka ntapepe. Yipm karokn nakimp apm sank likeknel apulp ka apm naiyim yipmel, i kapepe apm kapukorokn nikimp yipm yupulp mini ka ak apm niawurpm pie apm akei apul nioknelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas aiki nakimp nti moule mamp antuel prisel antempel nti mesepmel, nakimp nti sank nak na, “Apm'a sukueimp yipm sankel. Yipm eipm, i ko yipm ampu nimikimp apm yapmunemp aiyipmel. Sank ka ntalekil. Mouleel kil ka ra ninkilapm ntit wuyeel. Aninkel kil nakimp ninkilapm mampel ankilel na, Yikn mpi yupul niokn yer mputnank. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Aser kil nak na, Kapukorokn epe, apm ka nkark. I kapepe waiek antuel ampu mpi nankimp ninkilapm ropmel pe. Ka kil nakimpil soplikekn, nta karep kil nakimp ninkilapm mampelel, i kil wankerpwunemp waiek ankilel nak na, Akosepm. Aser ninkilapm ropmel ka kil wakerpwunemp kuserel, kil karokn mpi apul niokn. Ka ninkilapm mampel karep nkarkel, kil nimplemp yapmunemp, i kil mpi ampul niokn. Kapepe. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jisas nakimp nti na, “Eti ninkilapm wuyeel epe, yipm nakel, mini ka sop puikn waiek ntiwuyeelel?” I nti nak na, “Ninkilapm mampel.” I Jisas nakimp nti na, “Ka yipm nak yuwa. Aser apm nakimp yipm likeknel. Nti maken yayapelel antempel nti moule ka ak moule mamp antuel Romel wuntokn aiyipmelel, nti ka nimimplemp yapmunempel. Nti ka sankork yipm, nti karep niorknel mpi ar sepmel apmuei nta Wulapm Weinkelel. Aser yipm karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sankwunamp sepmel ka Jon ntremp yuwap yipmel, ka yipm karokn apul sop, karokn. Ka nti maken yayapelel antempel nti moule ka ak moule mamp antuel Romel wuntokn aiyipmelel, nti ka eipm sank epie ka likeknel, nti aim a yapmunemp apul sop. Nti ka war apmuei nta Wulapm Weinkelel. Ka yipm aser nti opo ka nimplemp yapmunemp antuelel, aser ka yipm karokn ampu wunempwaiyimp na nimplemp yapmunemp aiyipmel ankil, karokn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas nakimp nti mesepmel na, “Yipm ampu eipm sanklomp nonkel apm'a sukueimp yipmel, ka ntalekil. Mouleel kil ka are niokn i kil ei rukopm wain. Niatel i kil apul yitne ko nti yer wakerp nioknel i kil awor lie ko nti wasip mpep rukopm wainelel. Niatel i kil akei lomp yiminink. I kil mper mpim nta antuel moule mpurel ka niokn kitapm karoknelel na nti na wakerpel. Kona rukopm nikerel, wainki ko nti yumpul pe suknel ko nti mperpil na kil sompel. Pe kil ka nako mpi yer mpim yemp peikel. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nti ar mpimpi, rukopm naker i tiknim, kapepe waiek nioknel wankes nti moule nioknel ankilel na mpi niokn somp rukopm karep nti sin mperpilel. I kapepe nti mpim, i nti nakimp nti moule ka wakerp nioknel na, Waiek nioknel wankes ant la na somp rukopm wainki ankilel na yupulpil ninket yek kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aser nti moule ka wakerp nioknel, nti nkarp i nti ar mewel miyep rukopm wainel. Eti nonkel, nti aimpil wuntuim. Pe nonkel ka nti akei wuntokn ar kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kapepe ar pitepitekn i, waiek nioknel ampu wankes nti mpurel yatel mpim. Nti ka mitinkelip ka sankork nti karep mpi niorknel. Aser nti moule ka wakerp nioknel apulp nti soplikekn, nti naker nti, ar nti miyep rukopm wainel. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Niatel i, aninkel, waiek nioknel wankes ninkilapm ntitel ankilel ankil mpi amiser nti. Waiek ankilel nak na, Nti oko yupmueipm sank ninkilapm apmilelel tikikn. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aser nti moule ka wakerp nioknel, nti aser ninkilapm ankilel pe mila, i nti akei wankel nak na, Ka ninkilapm ankilel epe. Kona waiek ankilel yuwurel, kil arai somp yemp waiek ankilelel, arai nkaik yitnim mpuampua sukn ako ankilel. Antarko yer kil wuntu, ko ant sumump mpuampua yikeiwanto. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kapepe nti nkarp i nti ntankampil, kitinil, ar kil ntape ntape, yek niokn naikul mpim wurun kurieknel i nti ar kil wuntuim. Kapepe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas nak na, “Eti yipm wunempwaiyimp ntakulel? Araiel waiek nioknel kil ko yupul nti ntakulel, nti moule po wakerp niokn ankilelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","I nti ampu nakimpil na, “Nti moule kuretel epe, arai kil nkiyir nti pe, yer nti wuntu. Pe niokn arai kil ampu somp, yek nti moule mpurel yatel ka yapmunemp sepmelel. Nti ko wakerp niokn ankilel sepmel. Kona rukopm tiknel, arai nti yikitnei i ko nti yimpil la sumump.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","I Jisas nakimp nti na, “Kope. Eti yipm karokn aser aipopel sank Wulapm Weinkel ka sil wupm ankilel tikikn? Sank epe ka nak apulp wuntokn ka nti akei apul yitneel, ka nak na, Wuntokn mpusul epe ka nti moule apul yitneel aser kuret i nti nkampwatel, aser ekeielel wuntokn epe Wulapm Weink ankil aser akolikekn yatip, i kil nkamp mper sepmelim. Nako wuntokn epe mintenkitneip lompirnke yitne sukurel nako yer mintenkel. Kil apul ntakilelel i ant aser akosepmim. (Buk Song 118:22-23) ");
INSERT INTO xbi_y_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Eti apm nakimp yipm. Niokn Wulapm Weinkel yipm'a yerel, Wulapm Weink ko nkiyir yipm kakorokn yer nta ankilelel, i kil ko miyimp nti moule ntitmaken yatelel ka ar nkis wunamp sepmelel, nti ko sumump yemp aiyipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kona mouleel kutuwur wuntokn mpusel epe, kil kapuko nkiyi kuret ankil. Pe kona wuntokn epe kurkuan nantin mouleel kil kapuko mplulim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nti pris antempel nti Farisi eipm sanklomp irpm epe ka Jisas nakel, nti ntinkirai ampulp, ka kil nak apulp nti ankil. ");
INSERT INTO xbi_y_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ntape eti, nti kanako nkimitin Jisas aser nti nkinkiekn apulp nti ntitmaken, apulpaser nti ntitmaken ka wunempwaiyimp na Jisas ka moule ka nakaworp yapmunemp Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas ampu nakimp nti mesepmel sanklomp yatel ntalekil. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","3","“Wulapm Weink kana yuwulmp nti mouleel ka ntaka sanklomp epie. Moule mampel, ninkilapm ntitel ankilel na somp maken, eti waiek ankilel na yupul niepm suknel. Sukur kil mper sank nakimp nti moule na pitepitekn kil ko yupul niepm suknel yumpulp ninkilapm ntitel ankilel na somp makenel. Awun epe kil na yupul niepmel, kil wankes nti moule nioknel ankilel na mpi yimp nti moule na la. Aser nti mentitmaken nak na, Arokn, ant nkark, ant'orokn mpi. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Eti kil ampu wankes nti moule nioknel nonkel pe i kil nakimp nti na, Yipm mpip nti moule ka apm waker nti yitompel. Yipm nikimp nti ntape na, Yipm eipm. Niepm ka apm aiki mitnei i wus kaunku irpm wus milman mipmaknel suknel apmilel ka ant aimp yimirir. Wus niepm ka akei mitnei, yipm la niepm ninkilapm apmilelel ka nkamp makenel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nti moule nioknel mpi nankimp nti moule epie sank, aser nti akei pmomp kuasemp nti, eti nti ka at mpim mpim. Mewel ka mpim niokn mputnank ankilel, mewel ka mpi ampul niokn wuntokn ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pe nti mpurel wakerkikaik nti moule nioknel i ar nti wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ntape eti, moule mamp epe ka wunemp'uret i kil wankes nti moule napolel ankilel mpi asmpuar wompitne antuel, ar nti akeiwanto wuntu wamperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","I kil nakimp nti moule nioknel ankilel na, Niepm ka akei mitnei, aser nti moule ka apm waker nti yitompel, nti ka moule kuret, nti kapukorokn la ser ant wus niepm epie. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","10","Yipm mpi yayapel nakurepm irpm yintempel wompitne likekn likekn yuwup nti ntitmaken sepm'uret suknako. Yipm nikimp nti na nti yirko la niepm ninkilapm apmilel ka nkamp makenel. Moule mamp pe nak ntape i, nti moule nioknel ankilel mpi nankimp nti ntitmaken. Kapepe ntiarko lala i, yemp niepmel yitne ankilelel ka namintip. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nti ntitmaken mpriemprie nkisel i, waiek ankilel war na miser nti. Aser kil amiser mewelel karokn atnu elmpuapm sepmel ntinkiraiel sop nti ntitmaken wanto atnuel apulp ninkilapm ka nkamp makenel. Kil ka ntri elmpuapm rankel ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eti moule mamp naiyimil na, Mamintomp, apulntaku yikn'arokn atnu elmpuapm sepmel apul war yitneel? Eti moule epe ka wuleelim. Kil karokn nakimpil sank setel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Niatel i, moule mamp nakimp nti moule nioknel nak na, Yipm kitinil ntankaik, yawol kil nukul kuriekn na kil yer yemp nimpiempel, ka yemp'uretel opo ka nti sa warpmel nainiunku sinkerel wunemniripm wuleel arel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas ampu nak na, “Ka likeknelim. Wulapm Weink ka aiyimp nti moule mitinkel na yer nta ankilelel, aser karokn. Kako nti likekn wuye ko war yerel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kapepe nti Farisi mpi i, nkis nak sank awup yapmunemp ampulp yayapel nako nti mperpai Jisas na niek sank ako ko kuretelel. I ko nti yer kil miyep sank weink ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I kapepe nti Farisi wankes nti moule wupm raiel mpurel ka sop ntiel ka nti ntinkirai apulp sank niawurpmel Moseselel, antempel nti moule mpurel ka apulp Herotel. Ntiarko mpi aser Jisas nankimpil na, “Waiek, aninkanink ant aser sank yapmunemp aiyiknelel apulp Wulapm Weinkel ka yikn nak likeknelim. Yikn karokn ampu nkinkiekn apulp nti moule ka nia nkampelel, karokn. Sank ka yikn nakimp nti antempel nti moule kuserelel, ka yikn nakimp ntiarko soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eti yikn ampu nikimp ant. Kona ant yek moule mamp suknel Romel Sisa wuntokn ka kil aiyimp ant na yek kilel, ka akosepm mi rokn? Rokn niokn epe ampu ko yuntun sank niawurpmel ka Moses nakimp antel? Yikn ampu nikimp ant yapmunemp aiyiknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aser Jisas karep amiser yapmunemp'uretel antuel i kil nak na, “Ka yipm akei wule kurieknel ninkai apmel. Karokn yipm awup yapmunemp likeknel apmilel. Ka yipm'a yupul apm'a niek sank kuretel yupulpi? ");
INSERT INTO xbi_y_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Eti yipm ampu ntremp apm wuntokn likekn ka yipm na yek ntiel.” Kapepe nti apul wuntokn likekn la ntimirempil. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I Jisas ampu namiyim nti na, “Eti muati irpm nia epie ka miniel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","I nti ampu nankimpil na, “Ka muati irpm nia Sisael.” Kapepe kil ampu nankimp nti na, “Kona mpuampua Sisael ka nkis yipmel, ko yipm ampu yek Sisa. Aser kona mpuampua Wulapm Weinkel ka nkis yipmel, ko yipm ampu yumuk Wulapm Weink.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kapepe nti eipm sank ntakilelel, nti karep nkark prierprur ankil. I nti awompil apmot, nti po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nti Sadyusi ka nak ntape na, nti moule ka awurel kapukorokn ampu serp. Eti awun likekn epe, nti la naiyim Jisas ntape na, ");
INSERT INTO xbi_y_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sepmel, Moses ka nak na kona mewelel ka ninkilapm karokn mi kil yuwur yuwomp maken ankilel, maken epe kako ampu yimintemp knuan ankilel yupulp na ntiwuye yuntun ntitmaken nako somp yemp ankilelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ant'a sukueimp yikn. Ampueikel ntiarko es knuanel nti ka 7-pla. Pe es antuel ka nkamp maken aser kil amur, ninkilapm arokn. Eti knuan ankilel ampu nkamump makenarenk. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","27","Aser ka soplikekn, kil awur amompil, ninkilapm ntiwuye karokn ra. Eti makenarenk epe mpi amintemp knuan ntiwuyeel. Aser knuan ntiwuyeel awur amomp makenarenk epe i, kil amintemp nti knuanknuan ankilel, lala 7-plaelim. Nti knuanknuan akeiwanto awur amompil, ninkilapm nti arokn. Ar pitepitekn i, maken epe awur misop nti. Kapepe. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eti yikn ampu nikimp ant, kona nti moule epie ampueik awur mi ko nti ampu yiki serpel, maken epe ko yintemp mini antuel ntiarko es knuanel nkisel? Yikn ka ntinkirai apulp, maken epe ampueik ar kitapmel, kil ka antemp ntiarko 7-pla es knuanel namintilem.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eti Jisas ampu nakimp nti na, “Arokn. Sank ka ar wupm Wulapm Weinkelel antempel mpunkol niawurpm ankilel, yipm karokn aser tikikn, pe yipm nak sank waelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nti moule awurel, kona ko nti ampu serpel, nti kapukorokn somp maken. Karokn. Nti kapuko yer kuserel ntaka nti ensel Wulapm Weinkelel ka ar na yemp keipmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sank yipm'a naiyim apm apulp nti moule ka awur mi ampu nkarpel, yipm'arokn eipm sank ka Wulapm Weink nakimp yipmel tikikn? Kil ka nak ntalekil. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Apm ka Wulapm Weink, ekeielel apm ka awulmp Abrahamel antempel Aisak nti Jekopel. (Kisim Bek 3:6) Ka Wulapm Weink nak apulp nti milman wuyelikeknel ampueik wuntu likekn likeknel, aser kil nak na ekeielel kil ka awulmp ntiel amintempel. Apulntaku pe kil apul ntakilelel? Kil kapukorokn yuwulmp nti moule ka awurel, kil kapuko yuwulmp nti moule ka nkis keipmel likekn. Eti sank epie ka ntremp ant apulp nti moule ka awurel mi ko ampu serpel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nti mentitmaken eipm sank ekeielel, nti ka nkark akei tninel ankil apulp sank ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nti Farisi ar aser, nti eipm ampulp Jisas ka nak nkiyir nti Sadyusi sankel. I kapepe nti Farisi ampu arko la i amiser Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mewel antuel Farisiel, kil ka ntinkirai apulp sank niawurpmel Mosesel. Kil na mperpai Jisas i kil namiyimil na, ");
INSERT INTO xbi_y_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Waiek, sank niawurpmel Mosesel simi ka ar niorknel i ka awulmp nti sank wantoelel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","I Jisas ampu nakimpil na, “Ka yapmunemp aiyipmel korokn yer wuyeel, karokn. Yapmunemp pmiempniumpuaipm antempel pirpm aiyipmel ko yupulp Wulapm Weink likekn, kil ka ar niorknel. (Lo 6:5) ");
INSERT INTO xbi_y_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sank niawurpmel epe ka suknelip, ka ar miniorkn. ");
INSERT INTO xbi_y_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pe sank niawurpmel nonkel ka sil kilel ka ntalekil. Moule minimini sepm'uret kako yikn yikei nta niupuknel nkrawomp nti. Ko yipkn yupulp ntiarko nuarep ka yikn apulp moule aiyiknelel. (Wok Pris 19:18) ");
INSERT INTO xbi_y_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sank wuyeel epie ka weink, ka mpuanink sank wanto ampueik ka Wulapm Weink nakimp ant ar wupm ankilelel, ka sank Mosesel antempel sank antuel nti moule ka nakaworp yapmunemp Wulapm Weink nakelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nti Farisi peyar at, i Jisas namiyim nti na, ");
INSERT INTO xbi_y_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Eti yipm wunempwaiyimp ntakulel, apulp Krais, moule ka Wulapm Weink yuwakel? Kil ka ninkilapm miniel?” I nti nakimpil na, “Kil ka knamniumpuai moule mamp antilel Devitel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","I Jisas ampu nakimp nti na, “Eti ka apulpi ka Pirpm Wulapm Weinkel nakimp yuwap Devit i kil aiyimp moule epe naka moule mamp ankilelel? Devit ka nak na, ");
INSERT INTO xbi_y_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Wulapm Weink ka nakimp moule mamp apmilel na, Yikn ko yer yakitie ntayapelel apmilel mpimpi ser, ko apm mper nti moule wuroknel la nta aiyiknel i, ko yikn nkaik mintemp nti woel yupmueiel. (Buk Song 110:1) ");
INSERT INTO xbi_y_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yipm nikimp apm. Devit ankil ka aiyimp moule epe naka moule mamp ankilel. Eti kona moule epe ka knamniumpuai Devitelel, ka kil ampu aiyimpil moule mampel, ka apulpi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eti nti akeiwanto karokn ampu na nikimp Jisas sank setel. I yek awun epe mpiel, nti ka nkinkiekn ampulp na mperpai kil na yimpil yupulp yapmunemp mpurelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ar i, Jisas nankimp nti ntitmaken antempel nti moule ka sopilel sank. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kil nak na, “Nti moule wupm raiel antempel nti Farisi, yapmunemp antuel ka atitakor apulp sank niawurpmel Wulapm Weinkelel. Eti nti nkampop niepm Mosesel ko nti nikimp yuwap yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sank niawurpmel simisimi ka nti nakimp yipmel ko yipm yupul sop. Aser wunamp antuel ka nti nkisel, ka yipm'orokn yupul sop. Mekitik. Nti ka nak sank niawurpmel Wulapm Weinkel mitinkel kuserel, aser ka nti karokn apul sop. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nti Farisi ka walimp sank niawurpmel nakimp nti sank yatel mitinkel ka nuarep ntokwankepm suknel ko nti yek nti ntitmaken sanel. Aser nti Farisi karokn sakirp nti, karokn. Nti ka akei niampepm apiser nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Niokn mpuampua irpm nti Farisi apulel ka nti apul na nti moule na ser ntiel. Nti ka apul sank Wulapm Weinkel sil wupm i kitin waimpel suknel akei antup mpi mpua antempel ntayiknankel antuel. Pe elmpuapm ka nti atnuel, ka nti akei mua mpeiknpeiknel antup la elmpuapm nkumponk nako nti moule yikeiwanto ser nti, niremp nti yupulp niokn Wulapm Weinkel ka nti apul sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Puikn antuel ka apulp na nti kana yer niorknel yet yemp yapelel yer niepmura antuel akeiwantoel. Pe ar yank Wulapm Weinkel nti kana nkis yemp yapelyapel yer niampepm antuel mentitmaken wantoelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nti apulp na nti ntitmaken ko yimp nti mesepmel yer yemp yapelel, yep nti yikei yimpripel yupulp sank antuel ka nti yuwap ntiel, yupul nia antuel nomp keipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aser yipm karokn. Yipm akeiwanto ka mamintompel, yipm kako yer soplikekn. Ka yipm korokn yimp mewel aiyipmel na kil ka sepmel aiyipmel. Karokn. Sepmel aiyipmel ka yuwap yipmel ka likekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pe ar kitapm ekeielel yipm korokn niremp mewel, yiki nia ankilel na yimpil waiek. Karokn. Waiek aiyipmel ka likekn po ar na yemp keipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pe yipm korokn yimp mewel aiyipmel moule mamp, karokn. Moule mamp aiyipmel ka likekn ako, kil ka moule ka Wulapm Weink yuwak na somp nti mentitmaken ankilel na yer sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mesepmel aiyipmel ka nia nkampel, kil ko yer nuarep ka kil moule kuserelel, pe nti moule wanto, kako kil yikei yupulp nti niokn kuserelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kona mewel yiki nia ankilel no keipmel, arai Wulapm Weink mper kil yo kitapm. Pe kona mewel korokn wunempwaiyimp nia ankilelel, arai Wulapm Weink yiki nia ankilel no keipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jisas yukantunantun nak na, “Ai! Yipm moule wupm raiel antempel yipm Farisi, ka yipm akei wule kurieknel. Yipm arai ninkem wankepm yer nta Wulapm Weinkel. Yayapel kana mpi yer nta Wulapm Weinkelel ka yipm muor. Eti nti ntitmaken kana mpi yer nta Wulapm Weinkelel, ka yipm nakantup nti na warel eti nti ka antemp yipm apmuei kuriekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kil yukantun nak na, “Yipm moule wupm raiel antempel yipm Farisi, ka yipm akei wule kurieknel. Yipm arai niminkem wankepm. Yipm ka at yemp peikel antun mpepniopm ar wampwamp awup mouleel apul kil na sop yayapel ka yipm atel. Yipm nak na ka yayapel Wulapm Weinkel. Aser karokn. Yipm apul kil na misop sankwunamp aiyipmel. Eti kil ka samunkork yipm ampuk sankwunamp'uretel suknel. Ekilelel yipmarko arai yikeiwanto mpi yemp yiteel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kil ampu aiki yukantun nak na, “Ai! Yipm moule ka akei tukulpmel at i na ntremp nti yayapelel, yipm arai ninkem wankepm yer nta Wulapm Weinkelel. Apulpaser yipm ka nak na, Kona mewel yimp nia yitne Wulapm Weinkelel i niek niawurpm yuwa yupulp na mintenkitneip sankel ka mpuampua akopiteknel. Aser kona mewel yimp nia wuntokn sepmel (gol) ka ar yitne Wulapm Weinkel pminel i niek niawurpm yuwael, epe ka mpuampua suknel i ko kil yupul misop ka kil nakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yipm ka yapmunemp sukukurel akei tukulpmel atel! Eti simi ka si suknel ar niampepm Wulapm Weinkelel? Wuntokn sepmel mi, rokn yitne Wulapm Weinkelel? Ko yipm ser yuworel, ka yitne Wulapm Weinkelel ankil ka apul wuntokn ka ar pmin na yer mintenkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pe sank nonkel ka yipm nak na, Kona mewel yimp nia lowaimp ka nti wul wompwuyepmelel i, niek niawurpm yuwa yupulp na mintenkitneip sankel, ka mpuampua akopitekn. Aser kona kil yimp mpuampua ka sil lowaimp wompwuyepmel yintempelel, ka si suknel i ko kil yupul misop ka kil nakel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yapmunemp'arokn ar yipm! Yipm akei tukulpmel napek! Yipm'arokn wunempwaiyimp aipopel. Simi ka si suknelel? Lowaimp wompwuyepmelel mi rokn, mpuampua ka yipm wulel? Ko yipm ser yuworel, mpuampua niepm irpm ka yipm wulel ka akosepmel apulpaser ka sil lowaimp wompwuyepmel Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eti kona mewel na niek niawurpm yuwa lowaimp ka wul wompwuyepmelel, kil ko niek yupulp mpuampua ka sil lowaimp wompwuyepmelel yimposel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pe kona mewel na niek niawurpm yuwa yitne Wulapm Weinkel yupulp na mintenkitneip sank ankilel ka kil nakelel, ko kil niek niawurpm yuwa Wulapm Weink yintempel, apulpaser Wulapm Weink ka ar yitne ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kona mewel na yimp yemp sepmel i niek niawurpm yuwa yupulp na mintenkitneip sank ankilelel, ko kil niek niawurpm yuwa Wulapm Weink yintempel. Apulpaser Wulapm Weink ankil ka ar yemp sepmel, pe yemp sepmel ka lontulnko ankilel ka kil silel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jisas ampu aiki yukantun nak na, “Ai! Yipm moule wupm raiel antempel yipm Farisi, ka yipm akei wule kurieknel ninkai nti mouleel i, yipm arai ninkem wankepm yer nta Wulapm Weinkelel. Wonk akopitepitekn ntaka kari mputnankelel ka yipm waperp 10-pla pe i, likekn ka yipm amuk Wulapm Weink. Sank niawurpmel akopiteknel ntakilelel ka yipm nakerpm aipopelim. Aser yipm karokn nakerpm sank yapmunemp suknel Wulapm Weinkel ka kil nakimp yipmel, ka ntalekil. Ka kil nak nana y ipm ko yikei nainkerp nti yikeiwanto yum yapmunemp sepmel wunempyupulp nti. I kil nak nana ko yipm ser yuworel yapmunemp'uretel mi, sepmel mi, antuel mouleel na yupulp nti waperel sop yayapel ka akosepm yer niampepm Wulapm Weinkel. I kil nak nana yipm ko yikei Wulapm Weink nkael, yapmunemp aiyipmel ko likekn yintempil. Sank yapmunemp suknel Wulapm Weinkel irpm ntakilelel yipm karokn nakerpm. Akosepmel ko yipm nikerpm sank niawurpmel suknel epe ka awulmp nti sank niawurpmel pitepitekn ka ar pminel. Ko yipm yupul wuye yintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sankwunamp aiyipmel apulp sank niawurpmel Wulapm Weinkelel ka nuarep sankmuati epie. Kona yikn ser wolkn akopitekn yer mpep aiyiknelel, ka yikn pokel nkamumpwat. Aser kona saklok maninik yer mpep aiyiknelel, yikn karokn kilkitemp, ka yikn aim. Kona ntakilelel, niampepm yikn ka tumukulpm, ko yipm ntremp nti yayapel sepmel ntakulel na nti yetel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jisas ampu aiki yukantun nak na, “Ai! Yipm moule wupm raiel antempel yipm Farisi. Yipm ka akei wule kurieknel ninkai nti mouleel i, yipm arai ninkem wankepm yer nta Wulapm Weinkelel. Wunamp aiyipmel ka nuarep yuko kurieknel ka yipm kaikul ntinkiraiel. Aser niepm ka yipm aim a yukoel ka sankorkel. Wunamp aiyipmel ar pminel ka kuret. Yipm ka moule nimpalel, ka yipm antemintenk nti, kuap wuntokn antuel aninkanink. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yipm Farisi, niampepm yipm ka tumukulpm apulp yapmunemp Wulapm Weinkel. Ko yipm sukul pminel ankilel niorkn yupul sepmel i kurieknel ankilel ko yer ntinkirai yimintempel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jisas ampu aiki yukantun nak na, “Ai! Yipm moule wupm raiel antempel yipm Farisi, ka yipm akei wule kurieknel mpuaryawi yapmunemp'uretel aiyipmel i, yipm arai ninkem wankepm yer nta Wulapm Weinkelel. Yipm ka ntaka ntopm wuntoknel ka nti mper muan warel. Yek kurieknel ankilel ka nti akei muakupm yonel ariel ka apul akolikekn ankil nako nti moule serel, aser yekipminel ankilel ka aser kuret ankil, linkepmawupm nkrinkinkirar. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yipm ka ntapope. Nti moule aser yipm ntieaikn kurieknelel, nti ka nak na yipm ka moule akosepm. Aser sankwunamp'uretel antempel sank mpulmpul aiyipmel yapmunemp yekipminel ka namintip.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","32","Jisas nakimp nti na, “Ai! Yipm moule wupm raiel antempel yipm Farisi, yipm eipm. Ampueikel nti manmakn aiyipmel ka aimp nti moule Wulapm Weinkel wuntuel ka nti nakaworp yapmunemp ankilelel. Muan antuel ka nti mper ar ntopm wuntoknel. Ekeielel, ka yipm apul yemp muanel antuel pe akei ampripel, ware wuse niaimp apmuei. Yipm apulel, yipm ka nak na, k Nti moule epe ka ampueik nakaworp yapmunemp Wulapm Weinkelel, ekeielel ant apulp nti yapmunemp sepmel. Nti manmakn antilel ka aimp nti wuntuel, aser ant karokn. Kona ko ant yintemp nti manmakn antilel yer sop ampueikel, ant kapukorokn sop wunamp antuel, yer nti moule Wulapm Weinkel wuntu ntalepe. Arokn.” Jisas yukantun ampu nakimp nti na, “Yipm ka nak ntalepeel, aser ka yipm akei wule kurieknel napek apulp na ninkai nti mouleel. Yipm kako ninkem wankepm yer nta Wulapm Weinkelel. Sank yipm nakel, ka yipm wankirp sank mperp yipm ankil. Pe yipm ka nak na yipm ka knamniumpuai antuel manmaknel, ka yipm nak yumua, ka apulpaser wunamp aiyipmel ka pisop wunamp antuel pe. Ka yipm apul soplikekn i ko yipm mpi yupul walimp suknelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yipm ka saklok kuretel ka aimp aimp mouleel! Arai kona Wulapm Weink yuntunel yipmel, ko yipm waiyimp yemp yiteel ntakulel nako yipm yer sepmelel? ");
INSERT INTO xbi_y_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Eti yipm eipm. Apm arai wankes nti moule ka nakaworp yapmunemp Wulapm Weinkelel, yintempel nti moule ka mamp ntinkiraiel, yintempel nti moule kana yuwap yipm sank Wulapm Weinkel sepmelel, apm arai wankes ntiarko la ser yipm. Aser yipm arai yer nti mpurel wuntu, ntemp nti mpurel yer lonkuntonkel, ntampli nti mpurel yer yank Wulapm Weinkel aiyipmelel. I arai yipm nkiyir nti yer yemp epe mpim yemp yatelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wulapm Weink nak na nti moule akosepmel akeiwantoel ankilel ka wuntu ar nta mouleel, ampueik yek Abel lala tnei Sekaraia antempel nti minimini ar ekeielel, linkepm antuel akeiwantoel kako nkis yipm, nako Wulapm Weink yimp yipm yupulp ntiarkoel. Abel, ninkilapm Adamel, karokn apul setel kuretel, aser ka es ankilel ar kil wuntu kuserel. Sekaraia, ninkilapm Berekaiael, ka nti manmakn aiyipmel Judael aimpil wuntu kuserel ar yitne Wulapm Weinkelel ar nantip lowaimp ka nti wul wompwuyepmelel. Linkepm ntiarko moule akosepmelel ka wuntu kuserelel kako nkis yipm, i Wulapm Weink ko yuntunel yipm ankil yupulp. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Apm nakimp yipm likeknel, arai yipm pie nkisel arai somp yakop kuretel yupulp yapmunemp'uretel pe ka nti akeiwanto apulel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas nak na, “Yipm mentitmaken Jerusalemel, kuretako. Yipm ka ar nti moule ka nakaworp yapmunemp Wulapm Weinkelel wuntu suwaink. Nti moule pe ka Wulapm Weink wankes nti na ser yipmel, ka yipm akei wuntokn ar nti wuntu wuntuim. Yipm ka apul nti ntalepeel aser apm ka puikn apulp na aninkanink apm kana muani yipm ntaka aipmutnu niuknu ka muani nti aipm siknamp ankilelel. Aser yipm ka nkark. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yipm eipm, Wulapm Weink arai ko yuwomp yipm i, yemp aiyipmel arai yaku no. ");
INSERT INTO xbi_y_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Apm nakimp yipm, pitepitekn apm oko yumomp yipm i yipm'orokn ampu ser apm yer epie. Aser arai nkienkienel ko yipm ampu ser apm i ko yipm niek yumpulp apm na, Wulapm Weink kako yupul kil sepm, ka kil akei niawurpm Wulapm Weinkel ael.” (Buk Song 118:26) ");
INSERT INTO xbi_y_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas awomp lomp ka nti akei worp yitne Wulapm Weinkelel i kil mpim, aser nti moule ka sopilel la amiser kil. Nti na ntrempil yitne irpm ka ar yemp kitapmel Wulapm Weinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aser kil nankimp nti na, “Yipm apiser yitne akosepmel irpm epe, pe? Apm nakimp yipm likeknel, wuntokn suknako irpm pe sil keipm ar kitapm nti akei apul yitne mprinkeel, kapuko nti waker sompwat likekn likeknelim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas at na malenk Lo Olivel i nti moule ka sopilel la i nti naiyimil na, “Yikn nakel, yitne Wulapm Weinkel, atik ko nti yupul ntakilelel? Muati simi ko ntremp ant na pitepitekn yikn ko yo i kitapm ko niatel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","I Jisas ampu nakimp nti na, “Yipm ko yer niampepm ntankuel, yupulp nti moule kona ninkai yipmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Apulpaser, nti moule mitinkel arai la yikei nia apmilel niek na, Apm ankil ka Krais ka Wulapm Weink wankes apm a, na somp yipm mentitmaken na yer sepmelel. Sank epe ko nti niekel, ka nti ninkai nti mentitmaken mitinkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kona yipm eipm nti nupol yer kitnan i wakirpm tiknin nukul mi kona yipm eipm sank wolpm irpm yupulp wakirpm na nukul yer yemp peikelel, yipm korokn yapmunemp waninkepm yupulp. Wankepm mpuampua oko ninink, aser Wulapm Weink na yuntunel antel kapuko peyarip. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nti moule wopmweinkel oko yintemp nti wopmweink nonkel irpm nupol. Pe moule mamp oko yiki nti moule ankilel yapmunemp i ko yintemp nti moule mamp yatelel irpm numpol. Pe nti wampwamp mpurel kapuko aipm yupmueiel, mimpin kapukorokn. Pe mporyinikn oko no yer wampwamp. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nti wankepm ntakilelel karokn ntremp ant apulp kitapm sukurel epie na niatel. Karokn. Ka nuarep yakop ka nti maken nkuankirp ninkilapm na nti na rael, aser ninkilapm nti karokn pokel ra. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kona nti moule ser yipm yikei nia apmilel yupul nioknel, nti arai mper yipm mpi nta antuel moule kuretelel i ko nti yumuk yipm wankepm suknel. Pe nti moule wampwamp sukurel arai yikei yapmunemp'uretel waiyimp yipm i, arai nti yumpyer yipm wuntu male yupulp nti ka nkarkemp apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nti ntitmaken mitinkel ka sop apmel, nti arai ampu kuasemp apm. Yapmunemp'uretel arai serp sukn yer nti anti i, nti mitinkel arai mper mamintomp Kristenel antuel irpm mpi nta antuel moule wuroknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pe nti moule mitinkel arai yikei nia Wulapm Weinkel niek ninkaielel kuserel na nti ka nakaworp yapmunemp Wulapm Weinkelel, i nti kako kuap nti ntitmaken mitinkel na yumomp apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sankwunamp'uretel suknel oko yupmuei yapel, arai yer mpuanink nti moule akosepmel i, nti kapuko yuwomp yapmunemp sepmel. Nti ntitmaken mitinkel kapukorokn yikei nta niupuknel nkrawomp nti moule apulpaser nti ka likipelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aser nti moule ka at mintenkel ar nkis niumumpuel mi apul sop sank Wulapm Weinkel ar yeklikeknelel, arai Wulapm Weink somp nti na yintempil yer sepmel yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aser sank sepmel apulp yapmunemp Wulapm Weinkel ka kil na yuwulmp ntiel, nti ko wat sank nikimp nti yikeiwanto wampwampel. Kona niatel, kitapm sukurel ko miniat.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas ampu nak na, “Ampueikel Daniel, moule ka nakaworp yapmunemp Wulapm Weinkelel, ka nak apulp mpuampua kuretel arai sankork yitne Wulapm Weinkelel i yitne ko sankorkelim. Sank kil nakel, ko yipm ankil ser.” (Sank nimpiriepm: Moule mini kona yapmunemp ntinkirai yupulp sank ekeielel, kil ko yum yo yapmunemp ankilel wunempwaiyimp aipopel.) “Kona yipm ser wankepm kuretel ekilelel, ");
INSERT INTO xbi_y_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","yipm mentitmaken ka ar kitapm Judiael kapuko serk mpi nomp malenk. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kona yikn sil mpi yitne keipmel, yikn kapukorokn wunempwaiyimp mpuampua ka ar yitne pminel i yikn somp. Yikn kapukorokn akir, yikn oko sirpmok. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pe moule mini ka ar niokn mputnankel, kil kapukorokn ninket knuamp war yitne i somp elmpuapm suknel mpeiknel ka kil akei awulmp wolpmelel. Kil kako yuwomp niokn mputnank serk yipmot. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nti maken ka ninkilapm antuel sil ntaipmel, antempel nti maken ka tnei ninkilapm lunkoel, nti kako kuretako. Awun ekilelel nti kapuko yuwup ntinkiliemp ankil. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yipm yimp Waiek Keipmel yupulp nako kil ntunkorp yipm yupulp wankepm mpuampua kakorokn ninkem yipm yer aipmitniumonel mi awun Sapatel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ka apulpaser ampueik yek nimpiliek Wulapm Weink apul kitapmel lala ekeielel, wankepm irpm ka nininkel ka ako, aser ekeielel wankepm kako suknelip. I arai nkienel wankepm irpm kakorokn sankork wankepm ekeielel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kona Wulapm Weink korokn niekyuntup wankepm wainkiel, nti mentitmaken arai yuwur yuwur miniat. Aser kil ko wunempyupulp nti mentitmaken ankilel, eti arai kil niekyuntup wankepm wainki. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Ekilelel kona mewel na yupul muati niokn niawurpmel suknel yer pe yer pe yupulp na kuap nti ntitmakenel i kil niek na kil ka Kraisel, ka yipm'orokn eipmil. Ka kil ninkaielel. Mewel arai niek na, Krais ka ar ntalepe ntalepe, pe el nonkel ko niek na kil ankil ka nak likeknel apulp yapmunemp Wulapm Weinkelel, aser yipm'orokn eipm nti. Puikn antuel, nti kana ninkai yipmel, kuap nti ntitmaken Wulapm Weinkel ankil na yuwomp yayapel Wulapm Weinkelel. Aser karokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yipm eipm, pie apm nankimp yipm niorkn ampulp wankepm ntalepe kona nininkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eti kona nti nikimp yipm na, Kil po ar mpi wurun so, ntakeielel ka yipm korokn mpi yemp epe. Pe kona nti niek na, Yipm ser kil pe ar war yitne, ntakeielel ka yipm korokn eipm sank antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Apulpaser kona Es Aiyipmel Ntitmaken Akeiwantoel yoel, arai nuarep mpor mlaiknel yuwulmp kitapm sukurel. Nti arai yikeiwanto ser kil krikel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pe muati nonkel, nti akeiwanto kako ntinkirai yupulp wus muampel ka ar okuel apulp nako nti ser nti aipm sisai ka yinink yininkel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas ampu aiki nak na, “Kona wankepm irpm epe niatel, kapukorokn akir, Wulapm Weink arai yukurp mpuampua wantosukurel ka ar na mpor keipmel. Awun oko nunkurk, pe wuyen oko nkimepm, pe nkuaimantum irpm arai nu yo. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ekilelel nti mentitmaken arai ser muati ka ar na mpor keipmelel, i ko ntimiremp nti na Es Antuel pewipm. Kil arai sil mpor keipm yo yintempel mpunkol niawurpm ankilel ka Wulapm Weink ak kilel i, nti wopmweink akeiwanto ka ar kitapmel arai sa kuret ankil. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ensel Wulapm Weinkel likekn arai yuwop ipmiemp ka tiknin naikul suknelel. I Wulapm Weink ko wankes nti ensel ankilel mpi kitapm sukurel somp nti ntitmaken ankilel yupul la yintempil yupmuei likekn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas ampu nak na, “Yipm ka aser aworel rukopm wolmp ka ntremp yipm apulp mpuampua ko nininkel. Kona atno ankilel yuwurem i mumpunk ampu nkerel, yipm ko ntinkirai yumpulp na aipmitniumon ka miniat, pe ka mimpin awunim. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Atno ankilel awurem i mumpunk nkerel ka muati apulp sank irpm karep apm nakimp yipmel, ka ntremp yipm na pitepitekn Es Aiyipmel Ntitmakenel oko ampu yumu. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Apm nakimp yipm likeknel, nti mentitmaken kapuko peyar nkis, nti ko ser mpuampua yikeiwanto epie ko nininkel. Niatel i, ko nti yumur. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mpor keipm antempel mpuampua irpm sukurel pie ar kitapmel oko miniat, aser sank apmilel kapukorokn niat, oko yupmueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas ampu nak na, “Ant akeiwanto karokn ntinkirai apulp awun muati miel kona sank irpm apm nakimp yipmel kako nininkel. Ninkilapm Wulapm Weinkel antempel nti ensel Wulapm Weinkel nti ka soplikekn, nti karokn ntinkirai. Waiek Keipmel likekn, kil ka ntinkirai apulp atikel mpuampua muati ntalepe ko nininkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Kona apm Es Aiyipmel Ntitmaken Akeiwantoelel ampu yoel, nti moule ntitmaken kitapmel kako yer nkis sop puikn antuel, ntaka ampueik ka Noa arel. Nti nkamp maken antemp nti nkis, pe nti apul niepm mpuampua sukn ako. Pe Wulapm Weink na yuntunel ntiel, nti karokn wunempwaiyimp. Karokn. Nti apul mpi i, Noa muar wutumpepel suknel ankilel ka kil apulel i, mpep suknel atit la i aryamuwi kitapm sukurel. I mpep amor nti mentitmaken wanto i wuntu mpliempliel misil mpep keipm. Kona apm Es Aiyipmel Ntitmakenel ampu yoel, nti ntitmaken oko yupul soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kona moule wuyeel yet nioknel, Wulapm Weink oko somp nonkel pe ko yuwomp nonkel yupmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pe maken wuyeel kona yupul niepm, Wulapm Weink oko somp nonkel, pe ko yuwomp nonkel yupmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eti yipm ko yer niampepm ntankuel, yipm karokn ntinkirai atikel Sepmel Aiyipmel ko ampu yoelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yipm ampu wunempwaiyimp aipopel yupulp sanklomp pie apm'a nikimp yipmel. Kona waiek yitneel karep eipm sank wainki wainkiel apulp na nti moule wurkiteel na waker yitne ankilelel, ka kil kapukorokn yer niumpu. Kil kapuko wakerp yitne ankilel nkis keipm nako nti korokn waker warel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ka ntapepe yipm ko yer mpinta waiek yitne ekeielel pe, yipm ko yer niampepm ntankuel. Es Aiyipmel Ntitmakenel arai yo yikei nintipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas nak na, “Apm'a sukueimp yipm yupulp moule nioknel wuye na yipm wunempwaiyimp. Moule nioknel mini ka yapmunemp akosepmel naka apul niokn ankilel akosepmelel? Ka ntalekil. Kona mesepmel ankilel yetel, kil arai mper mouleel ankilel wakerp nti moule nioknel nonkel, walimp nti niepm yel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aser kona mesepmel ankilel ampu la i kil ser moule nioknel ko yupul sop kil nakimpilel, mesepmel ko yupul kil sepm wamperel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Apm nakimp yipm likeknel, arai mesepmel ankilel mper niokn suknel mpi nta moule nioknelel epe, i kil ko yer niorknel wakerp mpuampua yikeiwanto mesepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pe kona ko moule nioknel epe yum yapmunemp'uretelel, kil ko niek na, Mesepmel apmilel kapukorokn pokel la. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","I kil ko mpi yumor nti ninkilapm nioknel ka kil awulmp ntiel kuserel, i kil yintemp nti moule kuretel ka al mpep ka apul mamp kukoelel yim. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aninkel kona mesepmel ankilel ampu la ser kil yikei nintipmel mi, moule nioknel karokn ntimpramp yapmunempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I mesepmel arai yeryitor kil, nkiyir yuwompil, mper kil yo yemp'uretel yintempel nti moule kuretel ka akei wule kurieknel wakerpwunemp Wulapm Weinkel. Nti arai yikei sasael nainiunku sinkerel yer yemp epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas ampu aiki nak ntalekil, “Aninkel, kitapm kona niatelel, nti moule kana yer nta Wulapm Weinkel kako ntaka sank epie apm'a sukueimp yipmel yupulp nti maken ninkie ntakitiempu ntakitiempuelel, ka meniem maken moule epeel. Nompel, nti mpi yitne makenel amirip moule epe na sompil yintempil nkisel, kil arai la. Eti nti maken ninkie ninkie nkamp yite lam irpm antuel i nti mpi arip moule epe na yupul kil lael. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nti maken ntakitiempuel ka yapmunemp sukukurelel, nti ka apul yite lam kuserel, nti karokn apul mpep yiteel suknel antempel. Pe nti maken ntakitiempuel nonkel ka yapmunemp nimpiriepmel, nti nimprip mpep yiteel antuel apul antempel yite lam antuel mila. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aser moule kana somp makenel arokn pokel la. Niumpu niampepm amu nti, eti nti apmuei niumpu. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mpimpi nomp sosoel i, nti yupmueipm mouleel akei mampel napmok na, Moule kana somp makenel pewipm! Yipm yirko la, ant mpi yiripil yer yayapel, kua kil lael. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ntape i, nti maken ninkie ninkie akeiwanto epe arko nkarp ntimimpramp yite lam irpm antuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eti nti maken ka yapmunemp sukukurelel namikimp nti maken yapmunemp nimpiriepmelel na, Yipm nimprip ant mpep yiteel wainki, yite lam antilel pe nako nunkurk. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aser nti maken maken ka yapmunemp nimpiriepmel nakimp nti na, Arokn. Mpep yiteel pie ant apulel okorokn sukn nako ant yek yipm wainkiel. Eti yipm mpi yuwup na yipm wat wuntokn somp aiyipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ntape i, nti maken ka yapmunemp sukukurelel arko mpi amup mpep yiteel. Ekilelel, moule kana somp makenel la misil pmomp nti. Pe nti maken ntakitiempuel ka ntimpramp arip moule epeel, nti nkarp, antempil muar yitne ampulp niepm suknel ka kil nkamp makenel. Nti war i yitne tukuakn ka nti moule wor miniat. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ar mpimpi, nti maken ntakitiempuel nonkel epe mila, nti la i nti ansankel nak na, Sepmel, Sepmel, yikn sikninep ant yitne tukuakn. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aser kil ampu nakimp nti na, Yipm ka mini ko yipm warel? Apm nakimp yipm likeknelim, apm antemwunemp yipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eti Jisas ampu nakimp nti na, “Kona Sepmel aiyipmel na somp yipmel, kako soplikekn. Yipm karokn ntinkirai wuyen awun atikel ko kil ampu yoel. Kapepe apm nakimp yipm, aninkanink ko yipm nkis niampepm ntankuel ntimpramp yikei yiripilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas ampu aiki nak na, “Aninkel, nti moule ka ar nta Wulapm Weinkel ka kil awulmp ntiel ka nuarep sank epie apm'a sukueimp yipmel ka ntalekil. Mesepmel ka mper wuntokn suknelel, kil na mpi yer yemp peikel. Sukur kil aiyimp nti moule ka apulpil nioknel la aser kil i, kil amuk nti wuntokn ankilel na nti na mperpil yupmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kil karep aser amorel sankwunamp antuel likekn likeknel i, kil waker wuntokn namintilem nti nuarep wunamp antuelel. Moule likekn kil ak kil wuntokn 5,000. Pe nonkel ka kil ak kil wuntokn 2,000. Pe nonkel, ka kil ak kil wuntokn 1,000 ako. Kil ak nti niatel i kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","I kapepe, moule po karep nkamp wuntokn 5,000-el, kil karokn akir, kil mpi akei wuntokn 5,000 karep kil nkampel ampul niokn wuntoknel. I kil ampu nkamump wuntokn 5,000 waimienel mper ampueipel, i 10,000-im. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pe moule karep nkamp wuntokn 2,000-el, kilel ka apul soplikekn. Kil akei wuntokn 2,000 apul niokn wuntokn i kil ampu nkamp 2,000 waimienel mper ampueipel, i 4,000-im. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aser, moule nonkel ka nkamp wuntokn 1,000-el, kil ka mpi pe i awor lie i antup wuntokn 1,000 karep kil nkampel tnei kitapm nkimepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Mesepmel antuel ka ak nti wuntoknel, kil ar mpimpi wank mitinkel amuntun kil i, kil ampu naminket i kil aiyimp nti la amiser kil ka kil na yintemp nti niek sank yupulp wuntokn ka kil ak nti mper arel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kapepe moule karep nkamp wuntokn 5,000-el, kil apul ampueipel 5,000 epe la i kil nakimpil na, Waiek, yikn ser, wuntokn ka yikn ak apmel ka 5,000, apm apul mpi i apm akei ampul niokn wuntoknel. Pe yikn ampu ser wuntokn 5,000 epie ka naikulup wuntokn 5,000 ka yikn ak apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","I mesepmel epe ampu nakimpil na, Apm mpuaimpuai apulp yikn. Yikn ka moule akosepmel. Yikn apul niokn akosepm yuwa niniael. Pe wuntokn epe apm ak yiknel ka niokn akopitekn. Eti apm arai yek yikn niokn suknel, i arai yikn yupul nta aiyiknel. Yikn la mpuaimpuai yintempel apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Niatel i, moule karep nkamp wuntokn 2,000-el la i nakimpil soplikekn na, Waiek, yikn ser, wuntokn ka yikn ak apmel ka 2,000, apm apul mpi i apm akei ampul niokn wuntoknel. Pe yikn ampu ser wuntokn 2,000 epie, ka naikulup wuntokn 2,000 ka yikn ak apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I mesepmel epe ampu nakimpil na, Apm mpuaimpuai apulp yikn, yikn ka moule akosepmel. Yikn apul niokn akosepm yuwa niniael. Pe wuntokn epe apm ak yiknel ka niokn akopitekn. Eti apm arai yek yikn niokn suknel, yikn yupul nta aiyiknel. Yikn la mpuaimpuai yintempel apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kapepe moule nonkel karep nkamp wuntokn 1,000-el, kil la i nakimpil na, Waiek, apm ka ntinkirai apulp yikn ka moule nkerel, ka nkis akei apulapulelel. Mpuampua antuel moule wantoel ka yikn nkis akei nkamp nkampel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eti apm nkarkemp yikn na yikn ko niek apm yep wuntoknel. Epie wuntokn aiyiknel, ka apm antup tnei kitapm. Apm karokn akei apul setelel, karokn. Ka apm mperp yikn ar, pie apm ampu apulp yikn mila. Yikn ampu sumump. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aser mesepmel epe ampu nakimpil na, Ka yikn moule kuret likipel pe! Ka yikn nak na apm moule nkerel nkis akei apul apulelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Eti ntakilelel, apulpi yikn karokn na mper wuntokn war yitne ka nti mper wuntoknel, nako apm ampu ninketel ko apm ampu somp wuntokn mpurel waimienel walimp yintempelel? ");
INSERT INTO xbi_y_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kapepe kil ampu nimplemp namikimp nti moule yatel na, Yipm ampu somp wuntokn 1,000 pe kil apulel, yek moule opo ka apul wuntokn 10,000-el na kil yupul yintempel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Apulpaser kona mewel ka aim yapmunemp sepmel mitinkel, arai kil ampu somp nonkel nako kil yer sepmelel. Aser kona mewel karokn aim yapmunemp sepmel, mpuampua akopitekn ka kil mperel arai yawopmelim. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kapepe, mesepmel epie nak na, Yipm yikei nta pmompel yawol moule kuretel epie nukul kuriekn, kil oko yer yemp nimpiempel ka nti sa kuret, nainiunku sinkerel, wunemniripm wuleel arel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas aiki nak na, “Kona Es Aiyipmel Mentitmakenel yintemp nti ensel ampu yoel, kil ko yikei yite ntinkirienel yemp keipmelel i ko mlipmlaiknel yumu ntaka mpunkol niawurpm moule mampelel. Pe kil arai sil lontulnko akolikeknlikeknel ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","I nti mentitmaken sukurel ko yirko la yikei tnei yupmuei niampepm ankilel. Kapepe ko kil yumuntunel nti moule i nikile nti mpim yakitie yakitie. Kil ko mper nti moule akosepmel yer yakitie ntayapelel, pe nti moule kuretel ko yer yakitie ntayiknankel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","I kapepe moule mamp epe ko nimikimp nti mentitmaken ka ar yakitie ntayapel ankilelel niek na, Wulapm Weink ka awulmp yipm apul yipm sepm. Ampueik ka Waiek apmilel apul kitapm sukurelel, kil ka ntimpramp yemp apulp yipmel. Yipm la war yer, na yintemp apm yuwulmp nti wanto. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Apulpaser ampueik ka nilmp ar apmel, yipm ak apm niepm al. Ka mpepyapm ar apmel, yipm ak apm mpep al. Apm ka moule wampelelip, aser yipm nkamp apm apul apm war yitne aiyipmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Elmpuapm apm karoknel, yipm ak apm elmpuapm. Wule apul apmel, yipm wakerp apm. Apm ar yitne kuretelel, yipm la aser apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pe nti moule akosepmel ko ampu nikimpil na, Sepmel, atik ant aser yikn ar nilmpel i, ant ak yikn niepm alel? Atik ka ant aser yikn ka mpepyapm ar yiknel i ka ant ak yikn mpep alel? ");
INSERT INTO xbi_y_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pe atik ka ant aser yikn ka moule wampelel i ant nkamp yikn apul war yitne antilelel? Atik ka elmpuapm yikn karokn i ant ak yikn elmpuapmel? ");
INSERT INTO xbi_y_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pe atik ka wule apul yikn mi, yikn ar yitne kuretel mi ka ant mpi aser yiknel? ");
INSERT INTO xbi_y_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","I moule mamp ko ampu ninkimp nti na, Apm nakimp yipm likeknel, nti kuretako moule ntitmaken apmilel karokn nia nkampelel i, ka yipm apul nti sepmel, ka yipm apulp apm ankil. Nti ka muati apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pe nti moule ka at ntayiknankel, arai moule mamp nikimp nti na, Yipm moule mentitmaken ka Wulapm Weink nkiyir yipmel, yipm nisipm apm. Yite opo ka apeielel ampueik Wulapm Weink ntimpramp apulp Satan amposel nti muanumpor yanker ankilelel. Yipm mpi yer yo yite pope. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Apulpaser ampueik ka nilmp ar apmel, ka yipm karokn ak apm niepm al. Mpepyapm ar apmel, ka yipm karokn ak apm mpep al. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Apm ka wampelelip, aser yipm karokn nkamp apm apul war yitne aiyipmel. Apm elmpuapm karoknel, yipm karokn ak apm elmpuapm. Wule apul apm, apm ar yitne kuretelel, ka yipm karokn mpi aser apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eti nti moule ka Wulapm Weink nkiyirel ko ampu ninkimpil na, Sepmel, apulntaku po ka nilmp ar yiknel, ka mpepyapm ar yiknel, ka yikn ka moule wampelel, elmpuapm yikn karoknel, ka wule apul yiknel, ka yikn ar yitne kuretelel? Ka atik ant arokn apulp yikn ntakilelel? ");
INSERT INTO xbi_y_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","I moule mamp ko ampu nimikimp nti na, Yipm karokn apulp nti kuretako mentitmaken apmilel setelel, ka sop yipm karokn apulp apm. Nti ka muati apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pe nti moule kuretel pe mpi somp yakop suknel yupmueiel. Aser nti moule ntitmaken sepmelel, nti ko mpi yer sepmel yupmueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Sank irpm epe Jisas nakimp ntiarko niatel i, kil namikimp nti moule ka sopilel na, ");
INSERT INTO xbi_y_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yipm eipm. Awun wuye peyar ko ant yupul niepm Pasowa. Nti ko somp apm Es Aiyipmel Wantoel, mper la nta antuel moule kuretel na ntemp apm yupmuei lonkuntonkel i ko apm wuntuim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Awun ekilelel nti moule mamp antuel prisel antemp nti moule sepmel Israelel, nti akeiwanto naiyenaiye nkis likekn ar yitne moule suknel antuel nti prisel, nia ankilel Kaiapas. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nti nkis akei wankel nak sank awup yayapel apulp nti na somp Jisas nkuwepm na yer kil wuntuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aser nti nak na, “Ant korokn yupul yer yemp yapelel ntaka awun Pasowael. Kona ant yupul ntakilelel, nti ntitmaken mitinkel ko serel, nti kako nupol sukukuapelim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas ka ar yemp Betani, kil ka ar war yitne Saimonel, moule epe ampueikel ka wule ninkirmp apulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Makenel nkamp yuko wuntoknel ka mpep wuyepm naiki sepmel arel, kil apul mpi yitne epe, ka Jisas nkis al niepmel. I maken epe nimprip mpep wuyepmel amu kil mamp. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nti moule ka sop Jisasel aser ntakilelel, nti ka yapmunemp ntinkiliemp i, nti nakimp nti ankil na, “Kil yakul mpep wuyepm sepmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kona ko ant yikei somp wuntoknel, ant arai somp wuntokn suknel pe i arai ant yek nti moule kuretako ka mpuampua karoknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas karep ntinkirai ampulp sank antuel i, kil namikimp nti na, “Yipm korokn yek maken epe wankepm. Ka kil apulp apm yapmunemp akosepmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nti moule kuretako ka mpuampua karoknel, nti kapuko yintemp yipm yer aninkanink. Aser apm kapukorokn. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Maken pie akei mpep wuyepm sepmel a apm mampel, ka kil apulp apm wule ko arai nti yuntup apmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Apm nakimp yipm likeknel, arai nti kona mpi wampwamp sukurel wat sank niek yuworp sank sepmel yupulp apmel, arai nti niek yupulp niokn pie maken epie apulel. Nia ankilel kakorokn yawopmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Awun epe moule likekn antuel nti 12-pla moule ka sop Jisasel, moule likekn nia ankilel Judas Iskariot, kil la antemp nti moule mamp antuel prisel epe nkupmus. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kil naiyim nti na, “Kona apm mper Jisas mpi nta aiyipmelel, simi ko yipm yek apmel?” Kapepe nti ak kil wuntokn suknel (muati ka 30-el). ");
INSERT INTO xbi_y_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kapepe Judas amup yayapel na mper Jisas mpi nta antuelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Awun sukur Pasowael, nti moule ka sop Jisasel nti naiyim Jisas nakimpil na, “Ka awun ant ko ntimpramp yupulp Pasowael. Arai awun niunkuriknel, yikn puikn apulp na ant'a yupul niepm Pasowael yer oku?” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","I Jisas nakimp nti na, “Yipm no Jerusalem yuwup mouleel. Nikimpil ntape na, Moule ka yuwap ant sank sepmelel nak na, Awun muati nti na yer apmel ka kitnanim. Apm'a kua nti moule ka sop apmel war yitne aiyiknel yel niepm silep Pasowael.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","I kapepe nti moule ka sop Jisasel, nti apul misop sank ka kil nakel i nti ampul niepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nompim i Jisas muar antemp ntiarko 12-pla, nkis aim niepm. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nti al niepm nkisel i, kil nak na, “Apm nakimp yipm likeknel, mewel aiyipmel arai mper apm mpi nta antuel moule kuretelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nti moule ka sop Jisasel, nti eipm sank epe aser yapmunemp nti wankepmel yatip i nti likekn likekn ampu naiyimil na, “Sepmel, ka yikn nakimp apm pe?” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","I kil ampu nakimp nti na, “Moule epe na mper apm mpi nta antuel moule kuretelel, kil ka mewel aiyipmel ka pie antemp apm al niepm ar yuko likeknel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sank ka ar wupm Wulapm Weinkel ka nak apulp apm, ka nak na Es Aiyipmel Wantoel kako yuwur. Aser moule epe kana mper apm Es Aiyipmel mpi nta antuel moule kuretelel, ko ninkem wankepm suknel. Kona mantiek ankilel korokn ra kilel, kako akosepm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, kil ka moule na mper Jisas mpi nta antuel moule kuretelel, kil nakimp Jisas na, “Sepmel, ka yikn nakimp apm pe?” I Jisas ampu nakimpil na, “Ka ntape yikn napekel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nti al niepm nkisel, Jisas nkamp luwu ntintir i kil nak tukuaremp Wulapm Weink, i kil waker amuk nti moule ka sopilel. I kil nak na, “Epie ka ntieaikn apmilel. Yipm somp yel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","I kil ampu nkamp mpep wain yukoel i kil nak tunkuaremp Wulapm Weink, i amuk nti. Kil nak na, “Yipm yel mpep wain epie, ");
INSERT INTO xbi_y_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ka yarkup apmilel. Nti ko yer apm wuntu i, yarkup apmilel kako nukul yupmueiel. Kako yikei nkualeik yapmunemp'uretel mitinkel antuel ka nti mentitmaken apulapulel. Yarkup apmilel ka wuniapm ka Wulapm Weink nar tnei niumonelel. Ka muati apulp yapmunemp'uretel antuel ntitmakenel ko Wulapm Weink wunempiskelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yipm eipm, apm nakimp yipm. Pie ant nkisel, apm kapukorokn ampu yel mpep wain. Aser arai nkienel, kona Waiek apmilel yer yapel somp yemp moule mampel i antarko nkis yintempilel, i ko apm yintemp yipm ampu yim mpep wain niumpueiel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kapepe nti akei wampenel niat i, nti awomp yemp suknel apmuei, nti po mpi namp malenk Lo Olivel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas nakimp nti moule ka sopilel na, “Pitepiteknim nomp ekeielel yipm oko ser wankepm kona ninkem apmel, i yapmunemp aiyipmel okorokn yer mintenk yupulp apm. Ka yipm oko nkimepm niampepm, kako sop sankmuati ka sil wupm Wulapm Weinkelel ka nak na, Moule ka wakerp wus sipsipel, Wulapm Weink oko yer kilel i nti wus sipsip ankilel oko serk yumpul likekn wuye.” (Sekaraia 13:7) ");
INSERT INTO xbi_y_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aser Jisas nak na, Nti oko yer apm wuntu aser apm arai ampu serp yer yemp ka antup muan awurel ael. I apm oko mpi niorkn yirip yipm yupmuei Galili.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ampu nakimpil na, “Apm karokn. Kona nti wanto ser wankepm simi kona ninkem yiknel i nti ko serk yupul likekn wuyeel, apm kapukorokn yuwomp yikn.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","I Jisas nakimpil na, “Apm nakimp yikn likeknel, nomp araiel aipmutnu peyar okorokn niek i yikn arai nikimp nti anink wuyelikeknel na yikn ka antemwunemp apm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","I Pita nakimpil na, “Karep apm nankimp yikn. Kona simi ko ninkem yiknel, apm arai yintemp yikn wuntu, apm okorokn sirep nia aiyiknel niek na apm antemwunemp yikn! Karokn ankil!” I nti moule ka sop Jisasel, nti akeiwanto nak misoplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kapepe Jisas antemp nti mpim yempel, nti aiyimp Getsemaniel. I kil nakimp nti ka sopilel na, “Yipm nkisemp apm. Apm'a mpi opo, niek sank yintemp Waiek Keipmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kil kua Pita antempel ninkilapm wuyeel Sepetiel, ntiarko mpi. Yapmunemp antempel niumpuaipm ankilel ka kuret ankil, ");
INSERT INTO xbi_y_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kil nakimp nti na, “Yapmunemp apmilel ka wankepmel yatip. Yapmunemp apmilel ka sukukurelim apulp wankepm suknel arai na ninkem apmel! Mintenk apmilel kana miniat. Yipm mintenkitneip apm yer piepe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kil mpi pitekn, kil ankil mpulyapm a kitapm, markipniminket Wulapm Weink ntape na, “Yaiyai, apm puikn na yikn niekyuntup wankepm epie kana ninkem apmel, yek apm yayapel yatel! Aser ka apm nak. Yikn korokn nikerpm puikn apmilel. Karokn. Ko yikn yupul sop puikn aiyiknel suwaink.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Niatel i kil nkarp mpi amiser nti wuyelikeknel ankilel, aser nti ka apmuei niumpu. I kil sisir Pita nankimpil na, “Apulntaku? Yipm'arokn na mintenkitneip apm muati likekn, mi? ");
INSERT INTO xbi_y_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yipm ko nkis niampepm ntankuel, yimp Waiek Keipmel yupulp na yipm'a yet mintenkel nako yapmunemp'uretel korokn kuap yipmel. Oroknel, wolpm wutnie pe la kitnanim, kako ninkai yipmel, kuap yipm na yupul kuretel. Yapmunemp aiyipmel ka puikn apulp niokn apmilel yipm'a yupulel, aser ka ntieaikn aiyipmel ka mpulosim, karokn mintenk.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas ampu mpi amiyimp Waiek Keipmel aninkel ntape na, “Yaiyai, kona wankepm yakop antempel ntinkiliemp pie korokn nisep apmel, ka akosepm. Arai apm yirkos sop puikn aiyiknel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Niatel i Jisas ampu la amiser nti, aser nti peyar apei niumpu. Niampepm antuel ka wankepmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kil aser ntalepe i kil awomp nti ampu mpi nak sank antemp Waiek Keipmel anink wuyelikeknel, sank karep kil antemp Waiek nakel kil ampu aiki napmok. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Niatel i, kil ampu aiki la anser nti, i kil nankimp nti na, “Yipm peyar arar niumpu nkisemp sipmakn, mi? Yipm eipm. Muati ka miniat. Wankepm pe na niminink. Moule ka aimop apm yapmunemp wuyeelel na yupul apm Es Aiyipmel la nta antuel nti moule kuretelel, moule epe kil pewipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yipm serp, antarko mpi ninkemil mpim okor.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas peyar nak nak sankel i, Judas, moule likekn antuel nti 12-pla ka sop Jisasel, kil la niminink. Nti moule mitinkel pe antempil mila, nti ka apul skal mpu lael. Nti pris antemp nti moule sepmel Judael karep wankes Judas antemp nti ntitmaken epe mila. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, moule ka aimop Jisas yapmunemp wuyeelel, arep nankimp nti moule nak na, “Ko yipm ser apm'a mpi niremp mewelel, moule epie ka Jisas! Ko yipm ntasompil kuapil yupul yipmot!” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Arokn akir, Judas pe yulk nti moule, kil mpip Jisas i kil namirempil nak na, “Waiek niupukn, nomp sepm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","I Jisas ampu nankimp Judas na, “Waiek niupukn. Niokn mi pe yikn na la yupulel, ko yikn yupul pokel.” Aser nti moule arko antirenk la, antemp wamimpilpmil, ntankamumpil ntakitiekitie apul apmot. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I mouleel ka antemp Jisas atel, kil kuapmnar skal ankilel, wunemp'uret, yawol nilop mewelel, antunil ntanku atno sukur, kurkuan amu kitapm. Moule epe, kil ka moule nioknel Kaiapasel, ka moule suknel antuel nti prisel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aser Jisas nakimpil na, “Yikn ampu yuwei skal aiyiknel yumu. Yikn ko yimikei skal nupolel, eti kako yikei milap yiknel. Yikn ko yumur. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mamp yikn'arokn mpilil tikikn. Kona apm yimp Waiek apmilelel, arokn akir kil arai yek apm nti ensel ankilel mitimitinkel. Nti ka wakirpmtumpua apmilel, nako kil mper nti yer nta apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aser kona apm yupul ntakilelel, sank ampueik Wulapm Weink nakel kakorokn ninink. Ar wupm ankilel kil nak na ka wankepm kana ninkem apm ntapiepe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nti at, Jisas nakimp nti moule wanto na, “Pe yipm la nkamp apmel, i pe yipm apul skal ampueipel mpu, ka ntaka yipm'a yer moule kuretelel ka apulp yipm wurkite suknelel. Areparepel apm'a war yitne Wulapm Weinkel i yuwap yipm moule ntitmakenel, aser yipm'arokn na somp apm, kitin yuwomp apm. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aser ka wankepm pie na ninkem apmel, ka sop sank ampueik nti moule ka nakaworp yapmunemp Wulapm Weinkel nakelel, ka pie niminink.” I nti meniem ankilel ka sopilel, ka awomp Jisas apmot, nti ka nkark ampul likekn wuye. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nti moule karep nkamump Jisas i nti apul kil mpim yitne moule suknel antuel nti prisel, nia ankilel Kaiapas. I nti moule wupm raiel ampueipel nti mesepmel ntiarko naiyenaiye war nkupmus yitne yekipmin. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I Pita pe sop Jisas mpim aser kil karokn mpi kitnan, kil ako ka at mpila peik. Kil at yitne tukuakn ar anu i kil nkis ampueipel nti moule ka wakerp yempel. Kil na nkis ser nako nti yupulp Jisas ntakulel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aser nti pris antempel nti moule sepmel Judael (ntiarko ka kaunsol), nti aiyimp nti moule mpurel ko la na niek sank ninkaielel yupulp wunamp'uretel Jisas apulel, apulp nti na yer kil wuntu yepel. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","I nti moule mitinkel la nkamp yapmunemp'uretel mimperpil. Aser nti karokn ampu ninkem simi kuretel ka kil apulel nako nti yer kil wuntu yepel. At pitekn aser, moule wuyeel pe mila ");
INSERT INTO xbi_y_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","i ntiwuye nak na, “Moule epie ka nak na, Apm arai sinkre yitne Wulapm Weinkel i ampu yikitnei awun wuyelikeknel ako.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","I moule suknel epe, kil nkarp naiyim Jisas na, “Yikn karokn ampu na niek sankel mi? Apulntaku sank irpm pe nti nkamp mperp yiknel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aser Jisas karokn ampu nak sank setel. I moule suknel nakimpil na, “Apm aiyimp yikn ar nia Wulapm Weink Keipmelel, ko yikn niek likeknel. Yikn korokn nkuwepm sank. Yikn nikimp ant. Yikn ka Krais, moule ka Wulapm Weink aiki atel mi? Yikn ka Ninkilapm Wulapm Weinkel, mi rokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","I Jisas nakimpil na, “Karep yikn napmok. Aser apm'a nikimp yipm, arai yipm ser apm Es Aiyipmel kako nia sompel. Apm ko yer ntayapel niawurpmelel Wulapm Weinkel nako yintempil yupul nioknel. I apm arai yer no mpor keipm ko yumu kitapm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","I moule suknel epe nkarp'uret, yapmunemp ankilel ka sukukurel ampulp sank kil eipmel, i kil ntankamp elmpuapm ankilel ankil pe awor. I kil napmok na, “Kil ka apul nia Wulapm Weinkel ka amu kitapm, kil ka apul kuret ankil! Ant korokn yimp nti moule mpurel yatel la, na niek yuworp wankepm moule epieel, karokn. Karep yipm yupmueipm sank pe kil nakel! Kil apul nia Wulapm Weinkel ka amu kitapm! ");
INSERT INTO xbi_y_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yipm ampu niek, ant'a yupul kil ntakulel?” I nti ampu nak na, “Ka kil apul kuret. Korokn yuwompil yer. Ko nti yer kil wuntuim.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","I kapepe nti akei niepmwarkup mpim Jisas miniampepm. Nti mpurel akei nta muatipmel, mpurel akei nta ranimpel amor kil ");
INSERT INTO xbi_y_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","i nti napmok na, “Yikn nakel, yikn ka Krais, moule ka Wulapm Weink aiki yikn atel mi? Yikn ka moule ka nakaworp yapmunemp Wulapm Weinkel, mi? Kona ntakilelel, yikn nikimp ant sank nkuwepmel. Moule mini pie ar yiknel? Nia ankilel mini?” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ka at ar anu, aser maken nioknel la kitnan namintip Pita i kil napmok na, “Yikn el pepe, yikn ka antemp Jisas Galiliel apei pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aser Pita nak sirep nti moule wanto na, “Arokn. Apm pe antemwunemp sank epe yikn nakel epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niatel i, kil mpi at namintip lomp tukuakn i, maken nioknel nonkel amiser Pita i kil nankimp nti mentitmaken ka at kitnanel na, “Moule epie ka at antemp Jisas Nasaretel apei pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","I Pita ampu nak simirep nti aninkel na, “Apm nak likeknel, apm'a antemwunemp moule epe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","At pitepitekn i, nti moule ka at kitnanel la nakimp Pita na, “Ka nkuntoim, yikn ka mewel antuel pe, sank tiknin aiyiknel karep ant eipm amorel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","I kapepe Pita nak nkirnkerelim na, “Ka apm nakimp yipm likeknel, apm ka antemwunemp moule ekilpe! Kona apm korokn niek likeknelel, Wulapm Weink arai yek apm wankepm.” Kil nak niatel i, karokn akir aipmutnu napmok. ");
INSERT INTO xbi_y_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","I Pita ampu wunempwamiyimp sank ka Jisas nakimpilel, kil nak na, “Aipmutnu peyar okorokn niek, aser yikn arai niek anink wuyelikeknel na yikn antemwunemp apm.” Pita wunempwaiyimp aser kuret, i kapepe kil naikul kuriekn i akei misa warpmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rien kakirel i, nti pris antempel nti mesepmel Judael, nti ka kitip sank aim yapmunemp amu likekn na nti na yer Jisas wuntuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Niatel i, nti nkamp mua akei kitip Jisas i nti apul kil mpim i mper kil mpim nta moule suknel Romel, nia ankilel ka Pailat. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, moule ka mper Jisas mpi nta antuel moule wuroknelel, kil eipm ka nti mesepmel amup yapmunemp likekn na yer Jisas wuntuel, i kil nkis wunempwaiyimp aser kuret. I kil nimimplemp yapmunemp ankilel i kil ampu nkamp wuntokn muati ka 30 akuei nti pris antempel nti mesepmel ak kilel. Kil ampu apulp nti mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I kil nakimp nti na, “Apm ka apul kuret. Moule epe, pe apm mper kil mpi nta aiyipmelel, kil karokn apul setel kuretel i ko yipm yer kil wuntu.” Aser nti nankulp wankepm mimperpil nakimpil na, “Ka puikn aiyiknelip.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","I kapepe, Judas nkamp wuntokn muati ka 30 pe, yawol muar yitne suknel Wulapm Weinkelel, i kil po mpi nainkol ntolmua i, kil wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nti moule mamp antuel nti prisel nuanti wuntokn i nti napmok, “Wuntokn epie kana yuwei yuntun linkepm mouleel. Ka wuntokn kuretel. Sank niawurpmel Wulapm Weinkel ka nakantup ant na korokn mper yintempel wuntokn sepmel yer yitne Wulapm Weinkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nti aim yapmunemp a likekn i, nti akei wuntokn epe nkamump kitapm ankilel mewelel ka akeiakei marpmel nako nti yuntup muanel antuel nti moule wampwampel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eti yemp epe, nia ankilel ka nti aiyimp antun Kitapm Yarkupel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sank ampueik Wulapm Weink nak ar niepm Jeremaiael, moule ka nakaworp yapmunemp Wulapm Weinkelel, ka pie niminimk, pie ant amiser. Ka kil nak na, Nti nkamp 30-pla wuntokn ka nti Israel nak apulp na yuwei yuntun moule epeel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pe wuntokn epe ka nti yuwei amuk waiek kitapm epeel ka ampueik kil aiye akeiakei marpmel, sop sank Sepmel apmilel karep nakimp apmel. (Sekaraia 11:12-13 antemp Jeremaia 32:6-9) ");
INSERT INTO xbi_y_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nti apul Jisas mpi apmot niampepm Pailatel, i Pailat namiyimil na, “Yikn ka moule mamp antuel Judael pe?” I Jisas nak na, “Ka mpintape yikn napekel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","I nti pris antempel nti mesepmel Judael, nti nkamp sank mitinkel mimperp Jisas. Aser kil karokn ampu nakimp nti sank setel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eti Pailat nakimpil na, “Mi yikn karokn ampu eipm sank pe nti nkamp mperp yiknel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aser Jisas karokn ampu nakimp Pailat sank setel. Eti yapmunemp Pailatel ka ar mitimitink. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat wunempwaiyimp na nioknwank likekn likekn kona Pasowael, moule suknel Romel ka antun nioknwank wainki armikomp moule kuretel likekn ka ar yitne kuretel pminelel nako kil nukul kuriekn kuserelel. Nti mentitmaken ankil ko yimp nia mewelel nti ka puiknel, i ko moule suknel wankesil nunkul. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ekilelel i, Barabas ka ar yitne kuretel pmin i nti akeiwanto ka nimpiriepm apulp na kil ka moule kuretel ankil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nti mentitmaken pe karep naiye la akei mitnei, i Pailat namiyim nti na, “Yipm apulpel, mini apm'a wankes nukulel? Apm'a yirkomp Barabas mi, apm'a yirkomp Jisas epie, ka nti nak na kil ka Kraisel?” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat karep nkamp ntinkirai ampulp weink ka nti pris apul Jisas lael. Ka apulpaser nti ka yapmunemp yakopel apulp nti moule mitinkel ka aiki nia Jisaselel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat nkis lontulnko ankilel apul niokn ankilel awup sankwunamp'uretel apulp Jisaselel i, maken ankilel mper sank nakimpil na, “Moule yatewelel epe, yikn korokn yupulpil setel. Nomp'arepelel apm ar niumpu ninkiniepmel antun kil, eti apm pe eipm wankepmel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nti pris antempel nti mesepmel Judael aiki nti mentitmaken yapmunemp nako nti yikei mampel nikimp Pailat na yuwomp Barabas nukul kuriekn, nako kil niek na yer Jisas wuntuel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","I Pailat ampu namiyim nti na, “Yipm apulp na apm'a wankes mini mewel ntiwuyeel na nukulel?” Kapepe nti moule mentitmaken akei sank suknel nak na, “Barabas!” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","I Pailat naiyim nti na, “Eti yipm apulpel, apm'a yupul Jisas ka nti aiyimpil Kraisel ntakulel?” I nti nak na, “Ntempil yer lonkuntonkel!” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","I Pailat naiyim nti, “Na ntempil yupulpi? Simi kuretel kil apulel?” Aser nti akei mampel napmok na, “Ntempil yer lonkuntonkel!” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat nkamp ntinkirai apulp nti mentitmaken i kil nak na, “Apm korokn ampu yiki niek niek. Nti kakorokn eipm apm sank. Ka nti arai nupol.” Kapepe kil nkamp mpep akei kaikul nta ankilel ar niampepm antuel mentitmakenel, ntremp nti muati ampulp. I kil nak na, “Karokn weink apmilel kona moule epe yuwurel. Ka puikn aiyipmelip.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","I nti moule mentitmaken ampu aiki nak na, “Akosepm. Yarkup ankilel kapuko yupmuei ant ampueipel nti knamniumpuai antilel arai nkienkienelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eti Pailat arkomp Barabas nainkul kuriekn. I kil wankes Jisas mpim nta antuel moule aipmpienel i nti nkamp mua akei ntamimpli kil nako nti ntempil yer lonkuntonkelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kapepe nti moule aipmpienel Romel, nti nkamp Jisas apul kil mpi muar yitne moule suknelel, i nti wanto la at aiyemuorpil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I nti kankeip elmpuapm ankilel mper apmuei, nti na yupulpil mpuampua irpm simukuei moule mamp. Pe nti nkamp elmpuapm ninkopmel i amutnu kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I nti waink mua yenkel ntri amu kil mamp sukuei niukutopm moule mampel. I nti nkamp mpu wainkilel pe mul kil ntayapelel ankilel kana sukuei niawurpm moule mampel. I nti wamiker nkaik ampulpil. Kapepe nti wananklelel nak sank amiyekwaiyo kil nak na, “Ant naremp yikn. Yikn ka moule mamp antuel Judael.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I nti akei niepmwarkup amu kil. Kapepe nti ampu nineik kil mpu wainkilel karepel i nti likekn likekn yawol akei amu kil mamp. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nti aiyekwaiyo kil niatel i, kapepe nti ampu kaminkeip elmpuapm ninkopmel, nti nkamp elmpuapm ankilel ampu amutnu kil. I nti nkampil apul mpi na ntempil yupmuei lonkuntonkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ntiarko mpi, i nti moule aipmpienel nti aser mewelel yemp suknel Sairiniel, nia ankilel Saimon. I nti nkampil, apul kil arkos lonkuntonkel Jisasel na yintemp nti yet yayapelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kapepe nti mpi niminink yempel epe, nia ankilel Golgota. Niupukn nia Golgotael ka yemp mamp linkepmel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ar yemp epie, nti ak Jisas mpep wain nipelel mpurel ko kil na yel apulp na nkiyir yakopel, aser ka kil karokn al. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nti moule aipmpienel karep mintemp Jisas apmuei lonkuntonkel, i nti apul purkup, yawol rukopm satu na nti na yupul elmpuapm tukul mpuampua ankilel mpi nti anti. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niatel, nti ka nkis naminitipil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sil lonkuntonkel keipm ar na mamp ankilelel, ka nti apul sank ntape: Epie ka Jisas, Moule Mamp Antuel Judael. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nti ntemp Jisas ar niumon, nti moule wurkiteel wuye nti ntemp ar lonkuntonkel wuyeel ar yakitiekitie. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","I nti moule ntitmaken mpimpi lala aiyekwaiyo kil, niampepm yimpil kil, mutumpwaiyimpil nak kil sank kuret kuretel, ");
INSERT INTO xbi_y_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nak na, “Yikn moule kana sinkre yitne Wulapm Weinkelel i ampu na yikitnei awun wuyelikeknelel, yikn simpop yikn ankil! Kona yikn ka ninkilapm Wulapm Weinkelel, pe yikn nor yikn ankil na yo kitapm!” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nti moule mamp antuel prisel, antemp nti moule sepmel, antemp nti moule wupm raiel, nti akeiwanto aiyekwaiyo kil ntape na, ");
INSERT INTO xbi_y_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kil ka nak na kil ko simpop nti moule wanto nantip mua yirkomp nti, aser ka kil kapukorokn simpopil ankil! Kil ka moule mamp sepmel antilel Israelel, mi? Kona ntakilelel, kil ko yukur yo kitapm, nako ant yapmunemp mintenk yupulpilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kil ka akei Wulapm Weink nkael i kil nak na, Apm ka ninkilapm Wulapm Weinkel. I kona Wulapm Weink puikn apulpilel, i Wulapm Weink ankil kako simpopil nako nantip mua yirkompilel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nti moule wurkiteel wuyeel, karep nti moule aipmpienel ntemp nti ar lonkuntonkel wuye ar nantip Jisasel, ntiwuye antemp nti wanto aiyekwaiyo Jisas soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ka awun ropmel aser nomp nimpiemp aryamuwi kitapm, yek awun muati 12 amu 3 awuniunkurikn. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pitepitekn na yo muati 3-elel i, Jisas awor ma suknel i nak na, “Eli, Eli, lema sapaktani?” (Buk Song 22:1) Niupukn sank ekilelel ka nak na, “Wulapm Weink, Wulapm Weink, yikn awomp apm apulpi?” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nti moule mpurel ka at kitnanel, nti eipm sank epe aser nti karokn eipm aipopel i, nti nkamkirknel nak na, “Moule opo po amiyimp Elaija.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eti karokn akir, mewel antuel ka pokel mpi nkamp mikeikuret ka ntaka womp wulie kuelel, aim a mpep wain lukopel. Mikeikuret po kuap mpepel i kil kitip amu yaku na yek Jisas yim. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aser nti mpurel nak na, “Yukueim, ant yet ser kil niorkn. Elaija ko la simpopil, mi rokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aser Jisas ampu aiki awor ma ankilel i pirpm ankilel amompil i kil amur. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kil awurel i karokn akir, elmpuapm suknel ka aikol ar war yitne sepmel Wulapm Weinkel pminel ka nkurier akor yek keipm a tnei kitapm. Ka akor kitiekitieelim. I mporyinikn namp, i wuntokn tukotukoel amikor. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Nti moule ntitmaken Wulapm Weinkel ampueik awurel, nti ampu yek ntopm muanel nainkul. Pe nti yumukueim Jisas ko ampu serpel i, nti moule epe muar Jerusalem i nti ntitmaken mitinkel amiser nti. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Moule mamp antuel nti moule aipmpienelel pe wakerp Jisas apmot, kil antemp nti moule ankilel nti aser ka mporyinikn na i mpuampua ntalepe nininkel, wunu ka yunkur nti. I nti napmok, “Yaai! Ka nkuntoim! Moule epie ka ninkilapm Wulapm Weinkel pe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nti maken mitinkel ka atel, nti ka ampueik sop Jisas yek Galili la sakirpil niokn mpurel, nti maken epe ka at ako mpi peik i niampepm yumua kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maken el antuel ka Maria, yemp suknel ankilel ka Makdala. Pe nonkel ka Maria, mamam Jems nti Josepel. Pe nonkel ka mamam ninkilapm wuyeel Sepetielel. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Awuniunkuriknim i, Josep Arimateael ampueik nimpilemp yapmunemp sop Jisasel, kil mpi naiyim Pailat na yek kil muanmato Jisasel. Kil ka mper wuntokn suknel. Aser Pailat nakimpil na, “Akosepm” i kil nakimp nti moule aipmpienel na, “Yipm somp muanmato Jisasel epe yek Josep.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kapepe Josep nkamp muanmato pe akei elmpuapm ntinkiraiel yonel pe yimpil kil. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","I kil nkamp muanmato pe antup apmuei ntopm muanel niumpueiel ankilel, ka nti aiyep apulpilel. Kapepe Josep mpi wasirk wuntokn suknel la i akei mor ntopm muanel niepm. Kil apul niatel i kil po mpim. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdalael antempel Maria nonkelel ntiwuye ka nkis kitnan nantip ntopm muanel i niampepm yumua. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas awurel, aser ankaiel ka Sapat antuelim i, nti pris antempel nti Farisi mpi amiser Pailat. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nti nakimpil na, “Memamp, ant'a nikimp yikn sank akopitekn. Jisas opo ka moule sank mpulmpulel. Ant ampu wunempwaiyimp sank likekn ampueik kil nkis i kil nakel. Kil nak na, Awun wuyelikeknel ko niatel, apm oko ampu sirpmop. ");
INSERT INTO xbi_y_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eti yikn nikimp nti moule na nti ko wor ntopm muanel mintenk yer awun wuyelikeknel. Ant wunempwaiyimp na nti moule ankilel ko yupul wurkite somp muanmato ankilel mper nkuwepmel, i aninkel nti ampu ko yiki niek sank mpulmpul nkirnkerel, nikimp nti moule wanto na, Kil ampu ka nkarpmop. Ntakilelel kako kuret ankil.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","I kapepe Pailat nakimp nti na, “Yipm somp nti moule aipmpienel, nikimp nti na wakerp ntopm muanel yipei pope. Yipm mpi yupul mpuampua simisimi puikn aiyipmel ko wor mintenkelel.” ");
INSERT INTO xbi_y_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","I kapepe nti mpi apul mpuampua nuarep wuniapm ka akei antup nti mouleelel. Pe nti mper nti moule aipmpienel ar wakerp ntopm muanel apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sapat antuel ka niatel, pe nkarp rien mpilil nimpiemp, Maria Makdalael ampueipel Maria nonkelel ntiwuye ka nkarp na mpi ntopm muanel na ser yemp Jisas arel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aser arokn akir, mporyinikn suknel namp apulpaser ka ensel Wulapm Weinkel ka yek yemp keipmel a, wasirk wuntokn ar ntopm muanel niepm mpi mita, i kil na misil keipm. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mpuaminiampepm ankilel ka yonplaiknin numuarep mpor mlaiknel, pe elmpuapm ankilel ka kil narel ka mpusmpus numuarep aipmiyonel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kapepe nti moule aipmpienel aser kil ntakilelel, eti nti karep nkarkempil wuntu ankil! Mporyinikn ka namp nti moule. Nti ka pa siknamp naiyel, tritnei nael apei pope. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aser ensel epe namikimp maken wuyeel na, “Yipmwuye korokn nkinkiekn. Apm ka nimpiriepm, yipmwuye kana la ser Jisas, moule kakuei nti ntempil ar lonkuntonkel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kil karokn ar eiye, ka kil ampu ka nkarpmop, ntaka sank ampueik kil nakel. Yipmwuye ampu la ser yemp ka kil arel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kona yipmwuye ser niatel, ko yipmwuye ampu pokel mpi, ninkimp nti moule ka ampueik sopilel na, Jisas ka awomp ntopm muanel ka nti antupilel apmuei, kil ampu ka nkarpmop. Yipm eipm, kil po niorknel mpim Galili, pe yipm ko mpi ser kil yipei pope. Pie apm ael, ka apm'a napikimp yipm sank piepe.” ");
INSERT INTO xbi_y_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yarkup nkarpmok maken wuyeel, aser ntiwuye ka mpuaimpuai yatip. Eti karokn akir, ntiwuye ampu awomp ntopm muanel apmuei. Ntiwuye po ampu mpilmpilnk mpi na nimikimp nti moule ka ampueik sop Jisasel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aser Jisas nukur na ar yayapel i nankimp ntiwuye na, “Mantiek niupukn wuyeel, rien sepm.” Pe ntiwuye ka mpi kitnan nantipil i aikel a kitapm pe ntankampil nkaik waimpel i aimiki nia ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","I Jisas nankimp ntiwuye na, “Yarkup korokn serk yipmwuye. Yipmwuye mpi nikimp nti knuan knuan apmilel ampueik sop apmel, nti ko mila Galili. Nti arai ser apm yer mpi opo.” ");
INSERT INTO xbi_y_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maken wuyeel mpi amiser nti moule ka sop Jisasel. Pe nti moule aipmpienel ka wakerp ntopm muanelel mpi muar yemp suknel, i nti namikimp nti moule mamp antuel nti prisel apulp mpuampua muati irpm karep nti aserel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","I nti moule mamp antuel nti prisel nkis antempel nti mesepmel, ntiarko awup yapmunemp nak mpuaryamuwi sank karep nti moule aipmpienel nakel. I nti amuk nti moule aipmpienel wuntokn raiel suknel nako mpuaryawi mpuampua irpm karep nti aserel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nti moule mamp nakimp nti na, “Ko yipm wananklelel niek ntalekil. Nomp ant ar niumpuel, nti moule ka sop Jisasel la nkamump muanmato ankilel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kona ko moule suknel Romel eipm sank epe yupulp yipm karokn apul niokn sepmel ka yipm ar niumpuel, yipm korokn numpul yupulp. Ant ankil arai yupul yapmunemp ankilel muarknel. Wankepm korokn ninkem yipm.” ");
INSERT INTO xbi_y_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eti nti moule aipmpienel nkamp wuntokn i, nti apul misop sank karep nti moule mamp nakimp ntiel. Pe sank ninkaielel apulp muanmato Jisasel, ka nti moule ankilel nkamp nkuwepmelel, ka nti akeiwanto kitapm wampwampel yupmueipm. Pe nti Juda ka yupmueipm i, ka nti nak lala pie yireikel apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nti moule ka sop Jisasel, muati antuel ka 11, nti mpi Galili i nti mpi niminink malenk ka Jisas nakimp nti na mpiel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aser nti amiser Jisas i nti aimiki nia ankilel. Aser nti mpurel ka yapmunemp wieel apulpil nak na, “Kil ka Jisas, mi rokn?” ");
INSERT INTO xbi_y_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","I Jisas la kitnan i nakimp nti na, “Wulapm Weink ka ak apm mpunkol antempel mpunti suknel na yuwulmp kitapm sukurel yintempel yemp keipmelel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Eti yipm ko mpi yupul niokn apmilel yer wampwamp, yimp kuap nti ntitmaken wopmweink yikeiwanto wampwampel nako nti sop apmel. Kona nti moule eipm sank aiyiknel, yipm ko yikei nia wuyelikeknel, Waiek, Ninkilapm, Pirpm Sepmel Wulapm Weinkel, nako rup nti yumu mpepel yupulp yapmunemp'uretel karep nti nisepel. ");
INSERT INTO xbi_y_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sank wanto ampueik apm nakimp yipmel, ko yipm yuwap nti na nti nikerpmel. Yipm eipm. Aninkanink apm oko yintemp yipm yer mpimpi ser kitapm epie ko miniatim.” ");
INSERT INTO xbi_y_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Antarko wuyelikeknel, apm Pol antempel Sailas nti Timoti, ant apul wupm epieel ka apulp yipm mamuntomp antilel mentitmaken Wulapm Weinkel pe ar yemp suknel Tesalonaikael, yipm ka ar nta Waiek Keipmelel antempel Sepmel antilel Jisas Krais. Ant ka aiyimp Wulapm Weink nako kil yeyupulp yipm mi ko kil yek yipm yapmunemp niuluknunelel. ");
INSERT INTO xbi_y_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","Aninkanink ant antemp Wulapm Weink nak sankel, ka ant nak tukuarempil apulp yipm ka ar nkis sankwunamp sepmelel apulpaser yipm ka akei Wulapm Weink nkael, pe yapmunemp aiyipmel ka mpuaimpuai apulpil suwaink. Pe yipmarko ka akei nta niupuknel nkramomp ntiarko, eti yipm pe ntinkiliemp ampul niokn Wulapm Weinkelel. Yapmunemp aiyipmel ka mintenk ampulp Krais, ka yipm niampepm tneipil nako kil yupul yipm sepmel. Ka weink apulp yipm ka ar nkis niumumpuel apulp wankepm simisimi ka ninkem yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Yipm ka mentitmaken Wulapm Weinkel ka kil puikn apulp yipm yatip. Pe ant ka aser ntinkirai apulp ka kil ankil yuwak yipmel, apulpaser ");
INSERT INTO xbi_y_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ampueikel ant nakimp yipm apulp sank sepmel Kraiselel, ant'arokn nakimp yipm sank kuserel. Sank epie ka ninink antemp mpunkol niawurpm Wulapm Weinkel. Ka Pirpm Sepmel Wulapm Weinkel apul yipm na ser aipopelel, sank epie ka nak likeknel. Ant ka antemp yipm arel, yipm ka aser ntinkirai wunamp antilel ka ant ar nkis mi ant apulp yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Eti sankwunamp aiyipmel ka yipm apul soplikekn sop ka ant apulel. Yipm ka ar nkis nuarep ka Sepmel antilel Krais ntremp ant mi ka ant ar kisel. Nti moule ka ak yipm wankepm mitinkel silep sank sepmel epe ka yipm eipm apul sopel, aser yipm ka mpuaimpuai nkamp sank epie i aim apmuei yapmunemp aiyipmel. Yapmunemp mpuaimpuaiel ntakilelel ka Pirpm Wulapm Weinkel ankil ak yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Pe yipm ka ar ntaka muati ka ntremp nti ntitmaken Wulapm Weinkelel, ka ar kitapm Mesadoniael antempel Akaiaelel. Kona ntiarko ser sankwunamp sepmel aiyipmelel i ko nti yupul misop yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Pe karokn nti likekn eipm aser sankwunamp aiyipmel ka yipm ar nkiselel. Karokn. Ka nuarep wutu ka tiknin suknel sepmel naikul mi nakimp nti wantoel, eti nti wampwamp mitinkel ka eipm sank ampulp yapmunemp mintenkel aiyipmel epe. Pe ant mpi aser ntiel, ant karokn ampu na nikimp nti sank setel yupulp yipm. Karep nti eipm miniat. ");
INSERT INTO xbi_y_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Nti ankil ka sukueimp ant apulp yapmunemp aiyipmel. Nti nak na yipm ka nimisep niawurpm kitapmel wantosukurel, pe yipm ka nimimpilemp yapmunemp aiyipmel na sop Wulapm Weink ka ar yeklikeknelel, ka likeknelim pe yipm ko yupulpil niokn. ");
INSERT INTO xbi_y_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Aser nti ampu ka nak na yipm ka ar yukueim Jisas, Ninkilapm Wulapm Weinkel. Kil ka ampueik wuntuim aser Wulapm Weink ampu aiki kil i kil awomp yemp muanel apmuei pe kil ampu nkarpmop. Yipm yukueimil kona yek yemp keipmel Wulapm Weinkel yoel i ko kil ampu sumumpop ant. Kil arai nantip mua yirkomp ant i ko ant wamiyimp yapmunemp ntinkiliempel Wulapm Weinkel arai nininkel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Mamuntomp antilel nti, ampueik ant aser yipmel, niokn Wulapm Weinkel ka ant apulp yipmel karokn ar kuserel. Karokn. Ka yipm nkamp ntinkirai ampulp, niepm sepmel ka nanker. ");
INSERT INTO xbi_y_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Pe yipm'arokn wunempiskel ant apulp ka ant ar yemp aiyipmelel, nti moule mpurel karokn mpuaimpuai apulp Wulapm Weink eti nti ak ant wankepm suknel mitinkel apulp na ntunkorp niokn Wulapm Weinkelel. Ampueikel nti mpurel apulp ant soplikekn ar Filipai. Nti ka mpuliep ant, apul ant kuret. Aser Wulapm Weink ka ak ant yarkup mintenkel i kil ampu apul ant ar nkis niumumpuelim. Ant awomp nti arel i, ant mpi aser yipm nankimp yipm sank sepmel ankilel soplikekn. Ant karokn nkinkiekn apulp nti kana ntunkorp antel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_3","082_2_3","1TH","2","3","6","Ant aiyimp kuap yipm na sop yayapel Wulapm Weinkelel, ka ant arokn sinkiael i ko ant ninkai yipmel na nikimp yipm sank puakrenkelel. Karokn. Yipm ka ntinkirai na yapmunemp antilel karokn kuret nako ant wunempyilep yipm wuntokn irpm mpuampua aiyipmel mi ko ant sompel. Pe ant arokn nar wulienk mperar mi ant nkamp marknimp ntri na wananklelel kuap yipm na ser ant akosepm nako yipm mpuaimpuai yupulp antel. Karokn. Wulapm Weink ankil ka aser yapmunemp pmiempniumpuaipm antilel, pe kako kil ankil nipikimp yipm na, ka ant 'arokn ampu apul setel kuretel nkuwepm ar yapmunemp antilel. Karokn. Ant arokn wat sank Wulapm Weinkel apulp na nia somp ant yer niampepm aiyipmel wantosukurelel nako yipm niremp antel. Karokn. Ant apulp na nia ko somp ant yer niampepm Wulapm Weinkel likekn, nako kil likekn mpuaimpuai yupulp antel. Kil ankil ka aser ant akosepm i kil mper niokn antempel sank sepmel ankilel ant ka nakel apmuei nta antilel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Ant ka aposel, ka Krais ankil wankes ant atel. Pe kona ant puiknel, ant oko yikei mpunti ka sil antel nako nikimp yipm na yek ant mpuampua irpm na yuwulmp antel. Aser karokn. Ant ka akei yapmunemp sepmel niuluknunel waiyimp yipm ntaka mantiek tniokn ka niumua akei nti ninkilapm ankilel akei aripelel, mi kil ak nti niumuapm alel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_8","082_2_8","1TH","2","8","9","Yipm ka memprien antilel, pe puikn antilel ka apulp yipmel ka suknelip. Pe ant ka mpuaimpuai yatip ka an nakimp yipm sank sepmel Wulapm Weinkel. Aser ant 'arokn akei sank nakimp yipm 'userel. Karokn. Ant antel ka ak yipm kitie likeknelim. Ant arokn wunempaserp wule antilel, apulpaser yipm ka memprien antilel. Arep ka ant mpi antemp yipm arel ka yipm apiser ant pe, aninkanink ant arokn na yikei yipm nkael yupulp na yipm'a yuwulmp antel. Ant karokn ak yipm niokn ntinkiliempel ntaka ntokwankepm suknel na yipm'a sanel. Karokn. Nomp awun, rien niunkurikn ant ka mamamp akei nta antilel apul niokn ntinkiliempel, i akei nkamump wuntokn antilel apulp niepm irpm antilelel yupulp na ant wat sank sepmel Wulapm Weinkel nikimp yipm yikei watelel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Ant antemp yipm arel, ant karokn ampu apul setel kuretel. Sankwunamp antilel ka ant ar nkisel ka akolikekn yatip, Wulapm Weink antemp yipmarko ntitmaken ankilel aser ant soplikekn. Pe ant ka moule yatewelelip, ant ka aim yapmunemp sepmel suwaink. Mewel kakorokn somp sank kuretel mperp ant. ");
INSERT INTO xbi_y_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Pe yipm likekn likekn ka ntinkirai apulp sankwunamp antilel ka ant apulp yipmel. Ant ka nuarep waiek ka apulp nti ninkilapm ankilelel. Yipm awup ntinkiliempel, ant ka mintenkitneip yipm, ampu apulp yipm yapmunemp mpililim i ant aikiwat yipm, nako sankwunamp aiyipmel ko akosepm yer niampepm Wulapm Weinkelel. Pe kil ankil ka aiyimp kuap yipm nako yipm yer nta ankilel nako yipm yintempil yupul niokn ankilelel mi ko yipm yintempil somp nia suknelel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Ant ampu nak naremp Wulapm Weink aninkanink apulp yapmunemp yatel aiyipmel. Ampueik ant la aser yipm mi ka ant nakimp yipm sank Wulapm Weinkelel, ka yipm arokn akei eipmel nuarep sank moule kitapmelel. Karokn. Ka yipm eipm akei aripel i aim apmuei yapmunemp i ka ar mintenk apmuei yipm yapmunemp apulp na ka yipm aser sank niupukn aipopelel ka sank suknel Wulapm Weinkelelip. Kapepe sank Wulapm Weinkel ntakilelel ka apul niokn ar yapmunemp aiyipmel likeknlikekn nako nimpilemp sankwunamp irpm aiyipmel nako yipm yer nkis nternterel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Pe wankepm irpm ampueik ka ninkem nti ntitmaken Wulapm Weinkel ar nta antuel Judael ar kitapm antuelel, ka pe ninkem yipm soplikekn. Nti moule ntieyarkup antuelel ka apul kuret ak nti ntitmaken opo ka aiki nia Jisasel wankepm. Pe yipm ka soplikekn, nti moule ntieyarkup aiyipmel pe ar kitapm aiyipmelel ka ak yipm wankepm soplikekn apulpaser yapmunemp aiyipmel ka ar mintenk antemp Jisas. ");
INSERT INTO xbi_y_vpl VALUES ("H12_15","082_2_15","1TH","2","15","16","Ampueikel nti moule ka nak aworp yapmunemp Wulapm Weinkel, nti Juda ka ar nti wuntu. Pe nti ka ar Sepmel antilel Jisas wuntu soplikekn. Pe ekeielel nti ka apul ant soplikekn, nti ka naker ant, nkiyir ant naikul awomp yemp aiyipmel antempel i ant nkarpmok. Nti apul ntalepe aninkanink i Wulapm Weink aser ntiel, ka nti antemp nti moule wanto nkisemp wurokn. Yayapel antilel ka ant'a yet na nikimp nti moule kurieknel sank Wulapm Weinkelel, ka nti Juda ntumunkorp. Nti apulp na ant korokn nikimp nti moule kurieknel sank sepmel epe nako nti nimpilemp yapmunemp na yer nta Wulapm Weinkelel. Nti apul ntakilelel, ka ntiremp ant na yapmunemp'uretel antuel ka nkarp suknelim, pe yapmunemp ntinkiliempel Wulapm Weinkel ka antemp nti apmuei. Eti wankepm kuretel ka niminkem nti misilep. ");
INSERT INTO xbi_y_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Mamuntomp antilel nti, ant ka saiyip yipm yatip. Nti Juda ka nkiyir ant mi pie ant ar la peikel. Wuyen karokn antun ant, pe yapmunemp antilel ka nimisork apulp yipmel. Puikn antilel apulp na ant ampu na ser yipmel ka sukn nkirnkerip. Pe ant ntinkiliemp awup yayapel nako ant ampu mpi ser yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Apm Pol, apm ankil ka awup yayapel ntentenk, na mpi ser yipmel, aser karokn. Satan ka ntunkorp apm yatip. ");
INSERT INTO xbi_y_vpl VALUES ("H12_19","082_2_19","1TH","2","19","20","Ant apulp na ant ampu na mpi ser yipmel, ka apulpaser yipm ankil ka weink apulp yapmunemp mpuaimpuaiel antilel. Ant kapuko natip yipm yatip kona antarko yet niampepm Jisaselel. Jisas kona ampu yoel, kil arai ser akosepm wunamp aiyipmel nako ampu yupulp ant sepm waperel yupulp yipmel, nako kil nikimp ant na “Nti Tesalonaika ka nuarep niepm sepmel ka tnei ar niokn aiyipmelel.” Yapmunemp antilel ka ar mintenk apulp epieel, eti ant ka mpuaimpuai ampulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H13_1","082_3_1","1TH","3","1","3","Yipm ka ntinkirai apulp sank Wulapm Weinkel ka nak apulp wankepm kana ninkem ant moule ka sopilel. Aser ant numpul apulp yipm, ka yipm ninkem wankepm nkamp yakop apulp nia Jisasel. Ant nak na wankepm irpm epeel oko yupul yapmunemp aiyipmel na yer mitimitink, mi rokn. I kapepe ant kitip sank a likekn apulp na antwuye Silvanus nti Pol oko yer Atens, pe ant wankes Timoti mpi amiser yipm. Timoti kil ka mamuntomp Kristenel antilel, pe kil ka moule nioknel Wulapm Weinkel ka nak apulp sank sepmel Kraiselel. Antwuye wankesil mpi apulp na kil yet yipm pmomp na mintenkitneip yapmunemp aiyipmel na yer mintenk yintemp Wulapm Weinkel. ");
INSERT INTO xbi_y_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Ampueik ant antemp yipm arel, ant ka nakimp yipm na wankepm mitinkel irpm arai ninkem ant Kristen. Eti ka yipm aser amorel, mpuampua kuretel epe ka niminink. ");
INSERT INTO xbi_y_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Apm ka wunempwaiyimp na Satan ko waker yipm yapmunemp ninkaiel kuap yipm, waker yipm yapmunemp mintenkel tikikn. Kona ntakilelel, niokn antilel kapuko nkupmus kitapm. Eti apm arokn na nkuainkuai yikei yer warpmel, apm wankes Timoti mpi aser yipm, apulp nako apm somp ntinkirai yupulp yipm, ka yipm ar nkis niumumpuel, mi rokn? Yapmunemp yipm ka ar mintenk apulp Krais, mi rokn? ");
INSERT INTO xbi_y_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Aser Timoti ampu nanketel i kil sukueimp ant ampulp yipm, yapmunemp aiyipmel ka ar mintenk apulp Wulapm Weink, pe nti moule wanto ka yipm akei ntaniupuknel nkrawomp nti akei aripel. Pe kil nakimp ant na aninkanink yipm ka akei yapmunemp niumuaipmel wunempwaiyimp ant, pe yipm ka mpuaimpuai apulp ant, eti puikn aiyipmel ka apulp na ser antel ka suknelip, ka soplikekn nuarep ka ant apulp na ant apulp na ser yipmel. Ant eipm ntakilelel, yapmunemp antilel ka mpuaimpuai yatip apulp yipmel, ");
INSERT INTO xbi_y_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","pe yipm ka akei Krais nkael. Eti sank keielel ka mintenkitneip ant na yet mintenk yirkos wankepm irpm ka ant ninkemel. ");
INSERT INTO xbi_y_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Ant eipm na yipm ka ar nkis niumumpuelim i pie apul yapmunemp ant mpililim. ");
INSERT INTO xbi_y_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Ant ka nak naremp Wulapm Weink apulp yipm yatip. Ant kona yet niampepm Wulapm Weinkel yintemp mpuaimpuai suknel yupulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H13_10","082_3_10","1TH","3","10","11","Nomp awun ant aiyimp Wulapm Weink mintenk apulp nako kil krak yayapel nako ant'a mpi ser yipmel, pe yapmunemp mpurel ka yipm antemwunempel, arai ant ampu nikimp yipm yiki yapmunemp nako yapmunemp aiyipmel korokn wankel. ");
INSERT INTO xbi_y_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Ant aiyimp Sepmel antilel apulp na yapmunemp aiyipmel kana serp sukn nako yipm yikei nta niupuknel nkrawomp yipm aiyipm yintempel nti moule wantoel. I kapepe yipm arai yupul soplikekn nuarep yapmunemp antilel apulp yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Ant aiyimp Sepmel Antilel nako kil mintenkitneip yipm yapmunemp nako yipm yer ntinkirai yer niampepm Wulapm Weinkel, ka Waiek antilelel. Kona Sepmel antilel Jisas ampu na yo yintemp nti moule ntinkiraiel akeiwanto ka ankilelel, yipm'o yer yatewel nako Waiek antilel Wulapm Weink serel. ");
INSERT INTO xbi_y_vpl VALUES ("H14_1","082_4_1","1TH","4","1","2","Yipmarko mamuntomp, ampueik ant akei niawurpm Jisasel nakimp yuwap yipm apulp sank sepmel ankilelel, ka ntremp yipm apulp sankwunamp ka Wulapm Weink aser sepmel. Yipm ka ntinkirai apulp mi ka yipm apul sopel. Aser ekeielel ant ampu na yiki maipilem yikei niawurpm Jisasel ampu na yimp kuap yipm yupulp sankwunamp sepmel pe ko yipm yupul nako sikir mpi kurieknel. ");
INSERT INTO xbi_y_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Puikn Wulapm Weinkel ka ntalekil. Kil nkamp yipm mper yatel nako yipm yer nkis sankwunamp sepmelel suwaink, pe yipm ko yep wule aiyipmel korokn yupul tniompreimp. ");
INSERT INTO xbi_y_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Yipm kapukorokn yupul sop nti moule kurieknelel, wunemp antuel karokn akorp apulp Wulapm Weink. Nti ka waker wule antuel apul misop puikn antuel. Aser yipm arokn. Sankwunamp aiyipmel ko yer sepmel suwaink yer niampepm antuel wantoel. ");
INSERT INTO xbi_y_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Mamuntomp Kristenel aiyiknel, ko yikn yepil yikei yiripel. Yipmwuye korokn yel niepm tinam sampolel. Ampueik ant sankamintemp yipm nankimp yipm na Wulapm Weink arai yupul yipm milminel yep sankwunamp'uretel ntalepe kona yipm yupulel. ");
INSERT INTO xbi_y_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Apulpaser Wulapm Weink karokn kuap yipm nako yipm yapmunemp nirkutupel na yipm waker wule aiyipmelel. Karokn. Ka kil kuap yipm na yer nkis musukorel sop sankwunamp sepmel suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Pe kona mouleel na niek nkiyir sank ekeielel, kil karokn nak nkiyir ant moule kitapmel likekn. Karokn. Ka kil nak nkiyir Wulapm Weink ankil, apulpaser ka Wulapm Weink ankil apulp ant i Pirpm Sepmel Ntinkiraiel Ankilel ka antemp ant apmuei. ");
INSERT INTO xbi_y_vpl VALUES ("H14_9","082_4_9","1TH","4","9","10","Wunamp sepmel aiyipmel ka yipm antemp nti mamuntomp Kristenel aiyipmel apulel, ka yipm akei ntaniupuknel nkramomp nti. Apulpaser ka Wulapm Weink ankil ntremp yuwap yipm i yipm apul akosepmim. Yipm apulp nti mamuntomp Kristenel aiyipmel ar yemp wampwampel ar kitapm Masedonia. Eti ka ant'o nikimp yipm sank niawurpmel yupulpi? Aser ant puikn apulp na yipm ko yupul sumpop sankwunamp sepmel epe yupul sikir mpim kuriekn. ");
INSERT INTO xbi_y_vpl VALUES ("H14_11","082_4_11","1TH","4","11","12","Yapmunemp yapelel aiyipmel ko ntalekil. Yipm yer nkis sepmel, nta wat yo pmin likekn, nako nti weinkyanker yuntun nia sepmel yimp yipmel. Ko yipm yikei nta aiyipmel yupul nioknelmp nako yipm niumuapm yuwa nti maken ninkilapm aiyipmel ntaka sank ampueik ant nakimp yipmel. Kona yipm yupul ntakilelel, yipm korokn yer nta wantoel yikei nti nkael. ");
INSERT INTO xbi_y_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Pe sank nonkel ant'a nikimp yipmarkoel ka ntalekil. Ant apulp na yipm'o eipm yukorp yupulp simi oko arai ninkem nti moule aiyipmel ampueik awurawurel. Ka yipm'orokn yikei saiyip muan warpmel numpul yupulp nti ntaka nti mentitmaken kurieknel apulel. Nti karokn yapmunemp mintenk apulp Wulapm Weink nako nti niampepm tneipilel, eti nti ka ar antemp yapmunemp wankepmel suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Aser ant ka ntinkirai apulp Jisas ka ampueik awur mi Wulapm Weink ampu aiki kil nkarpel. I kapepe ant kako ntinkirai yupulp Wulapm Weink arai yikei niawurpm ankilel ampu yupulp nti moule ankilel ampu ko serpel soplikekn. Kil ko somp nti moule ka akei kil nkaelel i ko ntiarko yintemp Jisas yer sepmel yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Sank epie ant'a nikimp yipmel ka sank Sepmel Antilel Jisas ankil nakimp yuwap antel. Ka ntalekil. Kona Jisas ampu na yoel, ant ntitmaken Wulapm Weinkel peyar nkis keipmelel, ant kapukorokn yuwornulkn nti ntitmaken ampueik awurawurel i ant no niorknel. Karokn. Nti epe ka awur niorknelel kapuko serp no niorknel i ant ka nkis keipmelel arai sop nti no nkien. ");
INSERT INTO xbi_y_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Kako ntalekil. Ensel ka mpunti sil mi ka ar niorknelel, kil oko yikei mampel niek sank niawurpmel yupulp Jisas kana yek yemp keipmel yoel, pe nti ko yuwor ma yiki yilump i pmiemp Wulapm Weinkel ko nti yumop. Mpuampua irpm epe kapuko ninink krikel. Pe nti moule Wulapm Weinkel ampueik awurel, nti oko serp no miniorkn. ");
INSERT INTO xbi_y_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Niatel i ko ant ntitmaken peyar nkis keipm mi karokn awurel, kil ko yuweip somp ant yupul no i yintemp nti mentitmaken Wulapm Weinkel opo nomp mporkeipm, i ko antarko miser Jisas i yintempil yer sepmel yupmueiel. Kapepe. Sank ka mintapepe. ");
INSERT INTO xbi_y_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Yipm mpi nikimp yuwap yipm aiyipm sank epie nako yapmunemp yipm mpililel, mi ko yipm yer nkis mintenkel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Pe sank ekeielel ka sank yerk, ant okorokn nikimp yipm sank nuworpel yupulp atikel kona Jisas na yoel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Apulpaser yipm ankil ka ntinkirai ampulp, arai kil yo yikei nintipmel nuarep nti mewurkite ka at nompel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Ekilelel nti mentitmaken arai niek na, “Yemp pie rienelim, ant pie apmuei sepmel.” Nti na niek ntakilelel i, wankepm oko ninink yikei nimintipmel ntaka yakop ka nti maken nkamp apulp ninkilapm ka nti na rael. Aser yakop epe arai nti somp yer nta Wulapm Weinkelel kako soplikekn, nti kapukorokn sirkemp. ");
INSERT INTO xbi_y_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Aser yipm ntitmaken Wulapm Weinkel, yipm ka yatel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Yapmunemp yipm karokn nimpiemp mi ko yipm nkis kukoel nako yipm serk prierprur yupulp Jisas kona kil yo yikei nintipmelel ntaka mewurkiteel. Karokn. Yapmunemp aiyipmel ka mpilil, ka ntinkirai ampulp. ");
INSERT INTO xbi_y_vpl VALUES ("H15_6","082_5_6","1TH","5","6","7","Eti yipm kakorokn nkis wunamp'uretel nako nkuwepm yer yemp nimpiempel ntaka nti moule yapmunemp antuel karokn akorp nako nti nikerpm Wulapm Weinkel. Nti moule ntakilelel, yapmunemp antuel karokn mpilil apulp sankwunamp sepmel, ka nuarep nti ka at yemp nimpiempel. Nti moule ka akei nimpiemp nkuwur mi al mpep'uret ka apul mamp kukoel, nti ka nuarep moule ka ar niumpu wuntuel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_8","082_5_8","1TH","5","8","10","Eti yipm kako nkis niampepm ntankuel yet wunempel yep wule aiyipmel. Wulapm Weink karokn yuwak yipm na somp yakop yer nta ankilel yupulp sankwunamp'uretel. Karokn. Krais Jisas Sepmel antilel ka nkamp yemp antilel wuntu aikol lonkuntonkel apulp yapmunemp'uretel antilel. Kil ka nantip mua arkomp ant, apul ant na yer nta ankilel yet yemp yapelel yintemp yapmunemp mpililel. I kapepe wunamp sepmel ant'o sopel ka ntalekil. Ant'o yupulp Wulapm Weink suwaink, yikei kil nkael pe ant'o yikei yapmunemp mintenkel niampepm tneipil nako kil simpop antel. Pe ant'o yikei nta niupuknel nkrawomp nti wantosukurel. Kona ant yupul ntakilelel, kako nuarep ant ka ntankamp lontumpua nimimpiepm mi ka tunkorp ant aipopelel i ko ant wamiyimp yapmunemp ntinkiliempel Wulapm Weinkel epe i yintempil yer sepmel yupmueiel. Kona yipm yuwur mi yipm nkis keipmel, yipm oko yintempil yer sepmel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Kona ntakilelel, yipm mentitmaken wanto Wulapm Weinkel kapuko yikei sank epe ant nakimp yipmel mintenkitneip yipm aiyipm nta karep yipm apulapulel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Nti moule ka Wulapm Weink yuwak nti na yuwulmp yipmel, ko yipm yep nti yikei yiripel eipm sank antuel. Nti ka awor sank ntintomp ntremp yipm yayapel Wulapm Weinkel nako yipm nikerpmel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Niokn nti apulel ka ntinkiliemp, ko yipm yiki nia antuel yumpulp. Yapmunemp yapel aiyipmel ko yer yintemp nti. Pe yipm kapuko nkis niyepm yer yapmunemp likekn yintemp yipm aiyipm. ");
INSERT INTO xbi_y_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Ant'a yiki yipm yapmunemp nako yipm sankintemp nti moule likipelel ka nkarkemp nioknelmpel. Pe nti moule ka nkarkemp muatiel, ko yipm mintenkitneip nti, ko nti ampu yer niuluknun. Pe nti minititep ka awup ntinkiliempel ko yipm yikiwat nti. Kona yipm yupul ntakilelel, yipm oko yikei niumuaipmel yupulp nti wantosukurel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Kona mewel na yupul yipm kuretel, yipm'orokn ampu yupul kil kuret waperel. Karokn. Aninkanink ko yipm yikei yapmunemp sepmel waiyimp yipm aiyipm yintempel nti ntitmaken kurieknel wantosukurel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Aninkanink yapmunemp aiyipmel ko yer yintemp mpuaimpuai suwaink, ");
INSERT INTO xbi_y_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","pe yipm'o yimp Wulapm Weink nikimpil sank ntentenkel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Pe yipmarko mentitmaken ka Krais Jisas ar pmiempniumpuaipm aiyipmelel, eti kona mpuampua sepm'uret ninkem yipmel, ka puikn Wulapm Weinkel ko yipm nirempil niek tukuarempil yupulp. ");
INSERT INTO xbi_y_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Kona Pirpm Wulapm Weinkel na yupul niokn ntaka yite ka kakirp nael, yipm'orokn yukur. ");
INSERT INTO xbi_y_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Ntakilelel, kona mewel na niek yuworp yapmunemp Wulapm Weinkel yipm'orokn yikei eipmel mi yimpil pmomp yer kil. ");
INSERT INTO xbi_y_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Aser yipm'o eipm ser yuworel weink ankilel kona sepm mi kuretel. Sank kona sepm ka wat a ntunkel, ko yipm yum yer yapmunemp yupul misop. ");
INSERT INTO xbi_y_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Oroknel, (add? kona yapmunemp simisimi ka kuret yer niampepm Wulapm Weinkelel) ko yipm nta yikei nisepel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Yapmunemp musukorel ka nkarp ar Wulapm Weink likekn, i kapepe (apm aiyimpil nako kil yupul) ka niokn ankilel kil ko yupul yapmunemp pmiempniumpuaipm aiyipmel sukurel ko (na) yer nta ankilel likekn. Ntakilelel, Jisas Krais kona yoel, Wulapm Weink ko yuwulmp yipm nako moule aiyipmel pmin'uriekn ko yer mporel suwaink. ");
INSERT INTO xbi_y_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Wulapm Weink ankil ka aiyimp kuap ant na sop yayapel ankilel. Sank ka Wulapm Weink nak nuwarel, kil karokn ninkaielel. Ka kil akei mintenk ankilel apulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Mamuntomp antilel nti, yipmarko yimp Wulapm Weink yupulp nako kil nuworp antel. ");
INSERT INTO xbi_y_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Yipm kona ninkem nti mamuntomp Kristenel aiyipmelel, ko yipm niremp nti, ntayiremp nti. ");
INSERT INTO xbi_y_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Ant akei nia Sepmel Antilel Jisasel nakimp yipm, pe wupm epie ko yipm yet yapel yimp, nikimp nti ntitmaken Wulapm Weinkel yikeiwanto. ");
INSERT INTO xbi_y_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Ant aiyimp Sepmel Antilel Jisas Krais, kil ko yeyupulp yipm yupmueiel. Kapepe. Sank ka mintapepe, karep miniat. ");
INSERT INTO xbi_y_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Antarko wuyelikeknel, apm Pol antempel Sailas nti Timoti, ant apul wupm epieel nakimp yipm mentitmaken Wulapm Weinkel pe ar yemp suknel Tesalonaikael, yipm ka ar nta Waiek Keipmel antilel antempel Sepmel antilel Jisas Krais. ");
INSERT INTO xbi_y_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Ant ka aiyimp Wulapm Weink nako kil yeyupulp yipm i ko kil yumuk yipm yapmunemp niuluknunel. ");
INSERT INTO xbi_y_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Aninkanink ant nak naremp Wulapm Weink nkirnkerip apulp yipmel, apulpaser yapmunemp aiyipmel ka ar mintenk antempil, ka sankork yapmunemp mintenkel aiyipmel kareparepelel. I yipm akeiwanto ka mpuaimpuai na yupulp yipm aiyipm yapmunemp sepmel aninkaninkel. Wunamp sepmel epe yipm nkisel karep kakir mpim'uriekn pe ant ka nak tukuaremp Wulapm Weink apulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Wankepm irpm ka ninkem yipmel pe yakop yipm eipmel ka nti moule mpurel ak yipm apulpaser nti nkarkemp yayapel Jisasel ka yipm nakerpmel, aser yipm karokn nkark. Yipm ka ar nkis niumumpuel arkos wankepm epe nti ak yipmel Ant ka natip yipm yatip apulp wunamp aiyipmel epie. Pe ant mpi wampwampel sukueimp nti mentitmaken Wulapm Weinkel apulp wunamp sepmel aiyipmel epe i ant aiki nia aiyipmel namp keipm. ");
INSERT INTO xbi_y_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Wankepm ka yipm ninkemel ka apul niokn ar yapmunemp aiyipmel pminel, nimpilemp yipm ar pminel. Wulapm Weink ka ser wunamp aiyipmel ka yipm nkisel i kil arai yiki nia aiyipmel niek na, “Yipm ako ka elmpsoip. Yipm arai war yer nta apmilel i ko yintemp apm yupul niokn. Ntakilelel, nti wampwamp ko ser aipopel Wulapm Weink ka sop yapmunemp sepmel suwaink, pe kona kil yuntunel ant mouleel ka wat a ntunk. ");
INSERT INTO xbi_y_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Kil ko yupul ntalekil. Jisas antemp nti ensel niawurpmel ankilel arai yo yentemp yitelienk ka mirmirelel. Anink ekilelel, nti moule ka ak yipm yakop apulpaser nti ka nkarkemp yayapel Jisasel ka yipm nakerpmel, nti epe, Wulapm Weink arai yupul nti milminel waperel. ");
INSERT INTO xbi_y_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Pe kil ko yikei mintenk ankilel yuntun wankepm aiyipmel epe, i kil ko yupul moule aiyipmel pmin'uriekn ko ampu yer pipilaknim. ");
INSERT INTO xbi_y_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Nti moule yapmunemp antuel karokn akorp apulp Wulapm Weink mi nti yimpil pmomp ar kilel, sank sepmel apulp Jisasel ka nti eipmel, nti karokn apul sop. ");
INSERT INTO xbi_y_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Eti Wulapm Weink arai yupul nti kuret waperel ntalekil. Kil oko yo yikei lomp yuntun nti, pe nti kako yipei peik. Nti kapukorokn war yer kitnan nantipil, nti kapukorokn ser niawurpm suknel ankilel ka ntaka yitelienk sepmel ka le yemp ka ntinkirienel. Pe ntakilelel nti kapuko eipm yakop yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Ekilelel kona Jisas yoelel, nti mentitmaken Wulapm Weinkel, ka yapmunemp mintenk apulpilel, nti ko yiki nia ankilel no keipm, pe mpuaimpuai antuel yupulpilel kapuko suknelip. Aser kapukorokn nti likekn, ka yipm ankil oko yintemp ntiel yikei mpuaimpuaiel yupulpilel. Apulpaser sank Wulapm Weinkel ampueik ant nakimp yipmel, yapmunemp aiyipmel ka mintenk ampulp. ");
INSERT INTO xbi_y_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Wulapm Weink ampueik aiyimp kuap yipm na yer ntaka ntitmaken ankilelel, i kapepe ant aiyimpil ko kil yupulp yipm na yupul sop sankwunamp ankilel sukurel. Niokn sepmel simi yipm puikn na yupulel ko ant yimpil na yupulp yipm nako yipm yupulel. Kil kona yiki yipm yapmunemp yupulp niokn simisimi ankilelel, ant ka aiyimpil na rukopm sepmel arai niker niokn epeel. ");
INSERT INTO xbi_y_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Eti yipm arai yuntun nia sepmel yek Jisas Krais, Sepmel Antilel, nako kil yuntun nia sepmel yimp yipmel. Apulpaser kil antempel Wulapm Weink ka aiyeapulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Ekeielel ant'a nikimp yipm sank yupulp nako arai Sepmel antilel Jisas Krais ampu yo i ko antarko niyeniye yintempil yer likeknel. Ant nakimp yipm na ");
INSERT INTO xbi_y_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","yapmunemp aiyipmel kakorokn nimpilemp mpilyilmpilyelel yupulp sank irpm yipm eipmel ka nti nak na awun ka Jisas ampu na yoel ka niminink. Karokn. Kona mewel somp sank ekeielel yer yempel i kil niek silep yupulp, mi kona mewel niek na, “Ka Pirpm Wulapm Weinkel ankil akei niepm apmilel nak aworp sank epie, ka yapmunemp Wulapm Weinkelel”. Kona nti niek ntakilelel, ka yipm'orokn numpul yupulp. Mi rokn, kona mewel niek sank ntakilelel mi apul wupm nek na wupm epie ka ant moule Polel ankil apulel, ka kil ninkai yipmel. Yipm ko yer nkis niumumpuel pe yipm'orokn somp yapmunemp wankepmel yupulp. ");
INSERT INTO xbi_y_vpl VALUES ("H22_3","083_2_3","2TH","2","3","12","Ka yipm korokn somp sank mpulmpul simisimi ka mewel nakimp yipmel na pokel yum yo yapmunemp ntaka sank ka likeknelel. Yipm eipm. Awun ka Jisas na yoel kapukorokn ninink kuserel. Karokn. Sukur kako nti moule mitinkel arai yikei yupul mipmaip warpmel niek nkiyir Wulapm Weink, pe nti kako yupul puikn antuel. Niatel i, mouleel ka antemp Wulapm Weink nkisemp wuroknel, kil ko yipmot yemp yapelel. Pe ekeielel, setel ka ntunkorp yayapel ankilel. Pe yapmunemp epe apulp na yintemp Wulapm Weink nkisemp wuroknel ka pe apul niokn ar nkuwepm, ka yipm karokn aser akorp yapmunemp ntakeielel ka apul nioknel mi. Pe yapmunemp epe oko yer nkuwepm mpimpi ser Wulapm Weink ko niek na nkiyir simi ka tunkorp yayapel moule kuretel epeel ka antempil nkisemp wuroknel. Kona Wulapm Weink niek na kil na nininkel, i ko kil ninink yapelelim. Niatel Satan oko yek kil mintenk i ko kil wanankilelel nti mouleel. Kil ko yikei mintenk Satanel yumpul niokn mintenkel ninkaielel i ko nti serk yikei tninelel. Moule epe kana somp yemp Wulapm Weinkel na yer niorknel ko nti yikeiwanto yepil suwaink yer yitne suknel Wulapm Weinkel, i kil ko niek na, “Apm ankil ka Wulapm Weink.” Eti moule epe ko niek yuntup nti mentitmaken kana sop yayapel Wulapm Weinkelel, nti kapukorokn yiki nia Wulapm Weinkel yikei kil nkael. I kil ko niek yuntup nti mentitmaken yatyatel, nti kapukorokn yikei niawurpm kitapmel ntaka walaipm linkepm irpm. Kil kana yupul niokn simisimi kuretel ntalepe yupulp na kil ninkaiel kuap nti ntitmaken na sopilel. Ampueikel ka Wulapm Weink nakimp nti ntitmaken epe sank likeknel apulp Jisas nako kil nantip mua yirkomp ntiel, aser nti ka nkark. Nti karokn apulp na eipmil sank yum yer yapmunemp. Nti na yupul puikn antuel na yupul sankwunamp'uretel irpm, pe nti na sop moule epe ka antemp Wulapm Weink nkisemp wuroknel. I kapepe Wulapm Weink kako yupul nti yapmunemp kapuko mpurampuraelim i nti arai misop sank ninkaielel. Nti kapuko wunempwaiyimp na sank epe ka likeknelim. Ntakilelel nti karokn mpuaimpuai apulp sank ka Wulapm Weink nak mi ka wat a ntunkel. Nti ka mpuaimpuai apulp wunamp'uretel. Pe kona Wulapm Weink na yuntunel ant mouleel, arai kil yek nti wankepm suknel yupul nti milminel i, nti kako yawopmelim. Moule kuretel epe ka antemp Wulapm Weink nkisemp wuroknel, kil kako yer yupul niokn kuretel ankilel, aser aninkel Jisas oko yo yimintempel yitemilaikn suknel ankilel ko milipmilaiknel yumulmpil nako yupul moule epe milminel. I ko Jisas yikei wolpm niawurpmel ankilel yek niepm ankilel sompil i ko Jisas yer kil wuntuim. ");
INSERT INTO xbi_y_vpl VALUES ("H22_13","083_2_13","2TH","2","13","14","Yipmarko mamuntomp antilel nti, ant ka nak naremp Wulapm Weink ntentenk apulp yipm. Apulpaser ampueik yek nimpiliekn lael, Wulapm Weink ankil ka yuwak yipm. Pirpm Sepmel ankilel ka apul niokn apmuei yipm yapmunemp pmiempniumpuaipm aiyipmel nako kil ye yipm mper yatelel i yipm ko ankilelim. Sank sepmel Wulapm Weinkel ampueik ant nakimp yipmel, ka yipm nkamp sank epe aim ar yapmunemp aiyipmel. I yipm nak na sank epie ka Wulapm Weink nakel ka likeknelim i yapmunemp aiyipmel ka ar mintenk ampulp. Ntape eti, kil ka nantip mua arnkomp yipm i yipm ka ar mintaka ntitmaken ankilelel. Pe ant ka aser amorel puikn ankilel, kil ka apulp yipm yatip, eti karep kil aiyimp yipm na yipm'a yintemp Sepmel Antilel Jisas yerel. Nia sepmel kana sompilel, yintempel niawurpm suknel ankilel ka ntaka yite akosepmel ka milipmilaiknelel ko yuwulmp Jisas yipmarko soplikekn. Kapepe akosepmel aninkanink ant ka nak tukuarempil ampulp yipm. ");
INSERT INTO xbi_y_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Wupm irpm ant apulp yipmel antempel sank ka ant nakimp yuwap yipmel, ko yer nimimpiepm yer yapmunemp aiyipmel nako yipm yer nkis niumumpuelel. ");
INSERT INTO xbi_y_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Sepmel Antilel Jisas Krais antempel Waiek antilel Wulapm Weink ka apulp ant yatip, ka akei yapmunemp sepmel aiyeapulp antel. Ntiwie ka mintenkitneip ant apulp yapmunemp antilel ko yer mintenk pe ant ka niampepm tanku tneip ntiwuye ko yupulp ant sepmel yupmuei yupmueiel. ");
INSERT INTO xbi_y_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Kapepe ant aiyimp ntiwie na mintenkitneip yipm yapmunemp nako aninkanink yipm yer nkis sankwunamp sepmel suwainkelel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Eti yipm ampu eipm sankel epie apm'a nikimp yipmel. Yipm niek sank yimp Sepmel antilel na kil ko mintenkitneip ant eti sank ankilel ko sikir yikei yetel mpi wampwampel. Pe nti kako eipm sank ankilelel nako nti yep sank epie ntaka si suknel nuarep ampueik yipm apulel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Yipm ka ntinkirai, nti moule kuretel ka aim yapmunemp ntupmuel nak sank wael apulp sank Wulapm Weinkelel. I kapepe ant aiyimp yipm nako yipm markipninket Jisas nako kil yikei nta lep ant yupulp nti pe nti kapukorokn yupul ant kuret. ");
INSERT INTO xbi_y_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Aser Sepmel antilel ka akolikekn yatip i kil kako yupul sop sank nuwarel sukurel ka kil nakel. I kapepe yipm kapuko yikei kil nkael nako kil mintenkitneip yipm yapmunemp niumuayikei yipm yupulp na Satan kapukorokn yupul yipm milminel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Sepmel Antilel ka aiki ant yapmunemp ka ar mintenk apulp sankwunamp ka yipm nkisel. Sank niawurpmel sukurel ant nakimp yipmel, karep yipm apul misop, eti araiaraiel kapuko yipm yupul soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Eti ant markipninket Sepmel Antilel ko kil yikei su lep yipm yapmunemp nako yipm ser yuworel Wulapm Weink ka kil akei ntaniupuknel ankilel nkrawomp yipmel i ko yipm ser yuworel wunamp Kraisel ka kil ar nkis niumumpuel mi kil arkos wankepmel. Ntakilelel yipm kapuko nkis wunamp sepmel soplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Ant nkamp mpunti Jisas Kraisel, ka Sepmel Antilel, nako ant nikimp yipm sank niawurpmel likekn. Nti mamuntomp aiyipmel minititep ka yuwa likipel apulp niokn antuelel, ka yipm ntanisep nti yer antuel yatel. Nti karokn apul sop sank ant ka nakimp yuwap yipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Ant antemp yipm arel, sankwunamp antilel ka ntaka muati kana ntiremp yipm yayapel nako yipm nikerpmel. Pe ant arokn akei likipel apulp niokn mpuampua. Karokn. ");
INSERT INTO xbi_y_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Ant ka ntinkiliemp apul niokn nomp awun apulp nako ant somp wuntokn mi ko yuwulmp ant ankil yupulp niepm irpm mpuampuael. Ant 'arokn apulp na yipm kana yirkos wankepm yupulp na yuwulmp antel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Mpunti ka sil antel ko ant nikimp yipm na yuwulmp antel. Aser puikn antilel, ant'a yikei sankwunamp antilel kako ntiremp yuwap yipm ntaka muatiel, nako yipm serel i ko yipm yupul misoplikekn. ");
INSERT INTO xbi_y_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Ant antemp yipm arel, ant ka nakimp yipm sank niawurpmel likekn, nak na kona mewel karokn na yupul nioknel eti ka kil yer nilmpel, pe ka yipm'orokn yuwa kil niepm yel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Aser ant eipm sank na nti moule mpurel aiyipmel ka ar kuserel, nti karokn apul niokn. Sankwunamp antuel ka nti ar nkisel, nti karokn nta wat a pmin, nti ka nkis akei apulapulel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Sepmel Antilel Jisas Krais ka ak ant niwaurpm ankilel pe ant nakimp nti epe mpunkolel nak na, “Yipm nkis yitonk ntemp yo kitapm yupul nioknelmp irpm aiyipmel, nako yipm yikei niepm aiyipmel niumuapm yuwa yipmel!” ");
INSERT INTO xbi_y_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Mamuntomp antilel nti, yipm'orokn sirkemp sankwunamp sepmel, kako yipm yupul. ");
INSERT INTO xbi_y_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Kona mewel korokn yupul sop sank pie ant apul sil wupm ekeielel, eti kako yipm niuknu yuwapil aipopel. Pe yipm'orokn yintempil yer nkis, nako kil wulemaiyakn yupulp wunamp ankilel epe ka kil ar nkisel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ant arokn nak nako nkiyir kil nuarep moule wuroknel. Karokn. Ka yipm yikei niumuaipmel yuworkwunempil sankintempil. Kil ka mamuntomp aiyipmel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Ant aiyimp Sepmel Antilel ko kil yintemp yipm yikeiwanto yer, nako yek yipm yapmunemp niuluknunel. Kona ntakilelel, moule aiyipmel pmin'uriekn oko yer niumuaipm piriepmel, apulpaser kil ka weink apulp yapmunemp niuluknunel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Apm Pol, apm sankar yipm, awun sepm. Apm ankil akei nta apmilel apul sank akopiteknel apmilel epie. Wupm wanto apmilel kona yipm serel, ka yitomprai ntakilelel silel, ka apmilel. ");
INSERT INTO xbi_y_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Sepmel Antilel Jisas Krais ko yeyupulp yipm ntitmaken yikeiwanto. Kapepe. Sank ka mintapepe, karep miniat. ");
ALTER TABLE xbi_y_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
