﻿USE sofia;
DROP TABLE IF EXISTS sofia.xbi_w_vpl;
CREATE TABLE xbi_w_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xbi_w_vpl WRITE;
INSERT INTO xbi_w_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Aninkel Wulapm Weink nakimp Jona sank. Jona ka ninkilapm ntit kan Amitaiel. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Kil nak na, “Yikn la yemp suknel Ninive, nako yikn nikimp nti omoule ntitmuaken sank apmelel ka ntinkliempel. Nikimp nti na minamp kuoretel kurpe nti ka nkisel, apm ka anser.” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Aser Jona nkark, kil muap sank ka Wulapm Weink nakel, kil na mila yemp suknel yatel Tarsis ka peikel. Et kil nkarp mila yemp akoel Jopa, ka ar kitnan nantip mpep niopm. Kil o ninkemp wutumpepel suknel kana mila Tarsisel. Kil apul ntokilelel, ka kil apul aiyapel ankilel kil na yetnel. Kil ok nti wuntokn, et nti ok kil wupm nierepm ako i kil nomp wutumpepel. Kakilpe kil muap Wulapm Weink na nkierk yopmon. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Nti la akei niopm nimuonel, aser Wulapm Weink apul wolpm mimpien etnie ntampel yir, ka apul wutumpepel na yokuor yititimp. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Nti omoule ka apul niokn ar wutumpepel, nti ka nkark wonemp nimirik wule. Nti eikusukn lekekn lekekn akei suknel tupualimp wulapm kitapmel antuol ankil (or: nti manmakn antuol ankil??) kuor nkiempop ntiel. Niatel nti aiye sinsi wankepmel mpurel wat amu mpep niopm apulp na wutumpepel ko pipilaknel. Aser Jona karokn antemp nti ar, kil karep apmoi niumpu ar wutumpepel kitapm. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Et omoule amamp ka ontoapul wutumpepelel, kil o anser Jona. Kil kinsir kil, nakimpil na, “Yikn ka ar niumpu apulpi? Et yikn nkierp yimp wulapm aiyiknel (or: manmakn aiyiknel??) yupulp wankepm keielel karep ninkemp anel. Kona kil wonempyupulp an, ko kil yupul sinsi mimi yupulp an korokn wuntuel!” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ar pitepitekn aser, nti omoule ka apul niokn ar wutumpepelel nti napmok, “Et an yupul nio antelel lekekn lekekn sil wupm nierepm soplekeknel, yump yo ntok. Niatel, ko an ye nio lekekn ser kona nio miniel. Wankepm weink ka ankilel, ka kil ankil apul wankepm kipe ka apul mpunel anel.” Nti aiye wupm lekekn ntokilelel, nti aser nio Jonael insil. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Aser nti nakimpil na, “Yikn nikimp an etetel. Weink wankepm kipe ka napir anel ka wankepm aiyiknel ankil! Yikn apul mi ar keielel? Yikn ka yanunkuel? Yikn ka oupmweink miniel?” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Jona nakimp nti na, “Apm ka oupmweink nti Hibruel. Apm ka naremp Wulapm Weink kil ka ekeipmelip. Kil ankil ka apul mpep niopm antempel kitapm sukurel.” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Kil naimpil nankimp nti na, “Apm ka nkark, et kipe antemp yipm mila. Apm wap sank ka Wulapm Weink nakimp apmel.” Nti eipm sank kilelel, nti ka niyukur. Nti nankimp Jona na, “Yikuai! Yikn apul wankepm suknel!” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Nti nak sopeiye aser wolpm mimpien etnie ntamp kilelel nkarp suknel. Et nti omoule wutumpepelel amiyimp Jona na, “Ko an yupul yikn ntoku nako mpep niopm sikir et an ko sil sepmel?” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jona naimpil nakimp nti na, “Kona yipm nkiemp apm wat yo mpep niopmel, mpep niopm kileko ntimpilimp. Wankepm keielel ka napir anel, weink ka apm epe.” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Nti eipm sank Jonael, aser kuoret. Nti karokn na pelkel sempil wat yo mpep niopm, karokn. Nti na yupul wutumpepel la na mper Jona yer eikriekn. Nti akei lokitielel awor niopm salpikninel, aser niopm ka atit suknip et nti kakorokn la eikriekn. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Epe nti amiyimp Wulapm Weink na, “Sepmel, an kipe aiyimp yikn. Kona an wat omoule keielel yo mpep niopmel kil kona wuntuel, et yikn korokn yupul an wuntu wareel. An ka ntinkirai, yikn ka yapmunemp yakopel apulp nti omoule mini ka eik ar omoule sepmel wuntuel. Et yikn korokn yupul an sopilelel, karokn. Wulapm Weink, et yikn ankil ka apul wankepm keielel sop upuikn aiyiknel. Karokn upuikn antelel.” ");
INSERT INTO xbi_w_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Sank nti nak niatel, nti nkamp Jona wat amu mpep nioupm epe. Et kakilpe nioupm karokn walil, ka pelkel ntimpilimp. ");
INSERT INTO xbi_w_vpl VALUES ("JH1_16","033_1_16","JON","1","16","17","Nti yawol Jona o mpep niopmel, aser karokn walil, Wulapm Weink nakimp oyokn mila. Oyokn kile karokn ako, kil nkamp Jona wutik sukur. Kil o apmoi oyokn manklu. Oyokn lael, nti omoule wutumpepelel nti atn aser niopm ka pelkel ntimpilimp, nti ka niyukur apulp Wulapm Weink. Nti aki nio Wulapm Weinkel namp ekeipm, apul oumpiepm nio yuwa Wulapm Weink apulp nti na nekerpm kilel. Jona ka ar oyokn manklu awun wielekekn wunomp wielekekn. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona ar oyokn mankluel, kil ka antemp Wulapm Weink nak sank. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Kil nak na, “Sepmel, apm kipe ka ninkemp wankepm suknelel aser apm markipniminket yiknel. Yikn ka eipm apm. Apm ka nak nana apm ka apei yemp ka nuarep yemp oumpel ka nti omoule awurel arel. Kakilpe apm ninkitepm yikn, aser yikn oupmueipm apm. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nti ka sop upuikn aiyiknel, ka nti wat apm amu mpep niopmel. Niopm atit aryamuwi apm. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_4","033_2_4","JON","2","4","6","Mpuas niopmel ka kitip apm amamp, yapm apm kako nkutonk. Apm o..o..o..o..o amu malenk kitapm ka apei niopm kipmin. Nti muanumpuor yemp oumpelel ka narkimp apm. Apm ka nak na ka yikn ka karep nkimer apm, apm korokn nimpil ser yikn, aser rokn. Sepmel, yikn ka Wulapm Weink ankil, ka apm aki nio aiyiknel sitel. Yikn naimpil nkamump apm, apul apm awemp yemp oumpel apmoi. Apm karokn wuntu, apm ka pirpm. Apm kako nimpil yiki nio aiyiknel yopmoi yetne suknel ntinkiraiel aiyiknel. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Wulapm Weink, yapmonemp apmelel apm nak nana apm'a wuntuel, aser apm wonempwamiyimp yikn, markipninket yikn. Ma apmelel yikn opmueipm apmoi yetne suknel aiyiknel. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Nti omoule ka akei salpiknin kitapmel nkaelel, nti karokn omoule aiyiknel, et yikn kakorokn yupul nti sepm. ");
INSERT INTO xbi_w_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Aser apm karokn. Apm'a yekei wampen yiki nio aiyiknel, apm'a wul oumpiepm nio yuwa yikn. Sinsi mimi apm nakimp yiknel, kako apm yumpul. Sepmel, yikn lekekn ka nkamp an omoule eikusukn ar yemp kuoretelel, et yikn apul an naimpil ar sepmel.” ");
INSERT INTO xbi_w_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Epe Wulapm Weink eipm sank ka Jona nakel, kil apul oyokn la aikulp Jona nkupmus niopm eikriekn. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Jona nkis niopm eikriekn, et Wulapm Weink naimpil nakimpil aninkel na, ");
INSERT INTO xbi_w_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Yikn nkierp la yemp suknel kurpelel Ninive. Et yikn nikimp nti sank kumpueik ka apm nankimp yiknel. Kuor yikn nikimp nti omoule ntitmuaken eikusukn yer yemp suknel kurpelel sank kilelel.” ");
INSERT INTO xbi_w_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Epe Jona oupmueipm sank ka Wulapm Weink nakimpilel, kil nkarp mila Ninive. Yemp Ninive ka nio nkampel, yemp kilelel karokn ako, ka yemp sukn yatip. Omoule kana nkierp eik yakitie etn la yakitieel, kil kako yetn awun wielekekn. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jona mila muar Ninive eikipmin. Kil atn awun lekekn, et ka kil akei suknel nankimp nti omoule ntitmuaken sank ka Wulapm Weink nakimpilel. Kil nak na, “Yipm ko ware awun kona niat yer 40el. Kona niatel, Wulapm Weink kileko pmus Ninive!” ");
INSERT INTO xbi_w_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Nti ntitmuaken Niniveel nti eipm sank Wulapm Weinkel ka Jona nakimp ntiel, aser aimump nti yapmonemp. Nti napmok na, “Et an eikusukn sepm kuoret, sukn ako, antarko kuor nisep miepm eikusukn. An kuor nkiemp wapm kuoretel rap yentemp, nako an ntikiremp Wulapm Weink yupulp wule maiak antelel apulp minamp kuoretel ka an nkisel.” Epe nti apul numuarep karep nti nakel. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Omoule amamp antuol Niniveel eipm sank kilelel, et kil nankulp wapm sepmel ankilel mimper. Kil antemp nti ka nkamp wapm kuoretel mirap. Kil nkarp awemp lontolnko ankilel apmoi, kil o nkupmus yete kop wonempwaiyimp minamp kuoretel kil na nimpilempel. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Kil mper sank nakimp nti ntitmuaken eikusukn nak na, “Sank salpikninel keielel apm'a nikimp yipmel ka sank apmelel nampueip nti omoule sepmel apmelel. Antarko nak na yipm eikusukn ntitmuaken nampueip wuskau irpm wusipsip aiyipmel, yipm ko nisep miepm irpm mpep. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Yipm kuor rap wapm kuoretel ko tikiremp Wulapm Weink wule maiak aiyipmelel. Ko yipm wul wapm kueretel sil nti wuskau nampueip nti wusipsip aiyipmel soplekekn. Sank an kako nek salpiknin yimp Wulapm Weink. An eikusukn kuor yewemp mpuwuntokn yentemp minamp kuoretel mimi ka an nkisel. ");
INSERT INTO xbi_w_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","An kona yewemp sinsi mimi ntokilelel, Wulapm Weink kako nimimplemp yapmonemp ntinkliempel ankilel tikikn, kil kileko wonempyumpulp an tikikn. Kona ntokilelel, kil korokn yupul an wuntu.” ");
INSERT INTO xbi_w_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Wulapm Weink aser nti ka nisep minamp kuoretel irpm mpuwuntokn ka nti apulel, et kil ka nimimplemp yapmonemp ntinkliempel ankilel. Kil karokn asmpuar nti ar yemp suknel antuol Ninive sop sank ka kil kumpueik nakel. Kil ka naimpil wonempampulp nti. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Wulapm Weink karokn asmpuar yemp suknel Niniveel, kakilpe Jona ka yapmonemp yakopel ampulpil. Kil ka wonemp kuoretimp, ");
INSERT INTO xbi_w_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","nakimp Wulapm Weink nak na, “Sepmel, et yikn eipm apm sank. Sinsi mimi ka napir sop ka apm nakel. Kumpueikel apm ka ar uknuampel, apm wonempwaiyimp na kona apm nikimp nti Ninive sank aiyiknelel, yikn kako nimimpilemp yapmonemp aiyiknel, et yikn kako wonempyumpulp nti tikikn. Et kakilpe apm nkark muap yikn na mila Tarsis. Aser keielel apm anser, yikn ka apul minsop sank ka apm nakel. Apm ka nimpiriepm ampulp yikn. Aninkanink yikn ka akei nainkerp nti omoule eikusuknel. Yikn karokn pelkel wonemp kuoret antemp nti. Karokn. Yikn ka wonempapulp nti yatip. Yikn ka nimpilemp yapmonemp aiyiknel, yikn karokn ok nti wankepm ware minamp kuoretel ka nti nkisel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Et apm nakimp yikn Wulapm Weink, kona ntokilelel apm mpuaimpuai ko yikn yupul apm eik wuntuel. Apm nkark na nkisel!” ");
INSERT INTO xbi_w_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Epe Wulapm Weink naimpil nakimpil na, “Jona, sank kile yikn nakel, kilpe yikn nak yumua, a?” ");
INSERT INTO xbi_w_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Niatel, Jona awemp yemp suknel apmoi, kil la nkupmus eik yakitie awun noel. Kil wul ontoump mpalmpal ako nkupmus, et kil na nkis ser nti omoule Niniveel, Wulapm Weink kona yupul nti ntoku. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Jona nkisel, aser Wulapm Weink apul mo yinink namp ontoump mpalmpal ka kil nkisel, akei wapm sil ekeipm, awulmp Jona na nkis wa muatiel. Epe Jona mpuaimpuaiyimp ampulp mo ka awulmpilel. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Wunomp kil ar, aser erienel Wulapm Weink naimpil apul wolkn amuntun mo oropm, ka apul mo ninkerimp. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Awun akuorpel, Wulapm Weink apul wolpm suknel ntinkliempel nuarep yeteel ka eik yakitie awun noel. Wolpm kile ka yawol wupm eikusukn amiremp. Awun ntinkliempel akuorp yumua Jona yawol niamimpepmel yupul kil na yumui. Et kakilpe Jona napmok, “Et yikn yupul apm wuntu eik lekeknel. Apm nkark na nkisel!” ");
INSERT INTO xbi_w_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Aser Wulapm Weink naimpil nakimp Jona na, “Mi yapmonemp yakopel aiyiknel apulp mo ka ninkerel, kilpe yikn nak yumua, a?” Jona naimpil nakimp Wulapm Weink na, “Ank, apm wonemp kuoretimp. Sank keielel apm nak yumua! Apm apulp na apm eik wuntuel.” ");
INSERT INTO xbi_w_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Wulapm Weink naimpil nakimpil na, “Mo kilelel ka nkarp sukn wunomp lekeknel, aser wunomp yatelel kil ka naimpil ninkerel. Karokn niokn aiyiknel ka yikn apulel. Yikn karokn naimpil apul mo nkarp sukn, aser sinsi akopitepitekn sopilelel yikn wonempaser yatip. ");
INSERT INTO xbi_w_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Aser yikn kako wonempwaiyimp nti Ninive. Ka yemp suknelip, nti ntitmuaken muati antuol ka mpila ekeipm, ka nuarep 120,000 nampueip wuskau antuol ka mitimitinkelip. Ka yemp suknel aser nti ka nuarep ninkilapm karokn nimpiriepmel. Nti karokn eipm sank apmelel, nti nkis kukokukoel. Apulntoku apm korokn wonempyupulp nti Ninive, a?” ");
INSERT INTO xbi_w_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sank keielel ka apulp nti manmakn Jisas Kraisel. Jisas ka entieyarkup nkan Devitel, aser Devit ka entieyarkup nkan Abrahamel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ka ra Aisak. Aisak ka ra Jekop. Jekop ka ra Juda antemp nti esuknuan ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ka ra Peres antempel Sera. Mantiek ntiwieel ka Tamar. Peres ka ra Hesron. Hesron ka ra Ram. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ka ra Aminadap. Aminadap ka ra Nason. Nason ka ra Salmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ka ra Boas. Mantiek ankilel ka Rahap. Boas ka ra Obet. Mantiek ankilel ka Rut. Obet ka ra Jesi. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ka ra omoule amamp Devit. Devit ka ra Solomon. Kumpueikel mantiek Solomonel ka muaken Uriael. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ka ra Rehoboam. Rehoboam ka ra Abiya. Abiya ka ra Asa. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ka ra Jehosapat. Jehosapat ka ra Jehoram. Jehoram ka ra Usia. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ka ra Jotam. Jotam ka ra Ahas. Ahas ka ra Hesekia. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ka ra Manase. Manase ka ra Emon. Emon ka ra Josaia. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia ka ra Jehoiakin nampueip nti uknuan ankilel. Wank kilelel, nti Babilon aimpar nti Israel, nker nti la nkupmus kitapm antuol Babilon. Ka nti Babilon nakantup nti na nti kakorokn nimpil la yemp antuol Israel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nti ar Babilonel, Jehoiakin mira Sealtiel. Epe Sealtiel mira Serubabel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ka ra Abiut. Abiut ka ra Eliakim. Eliakim ka ra Asor. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ka ra Sadok. Sadok ka ra Akim. Akim ka ra Eliut. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ka ra Eleasar. Eleasar ka ra Matan. Matan ka ra Jekop. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ka ra Josep, ka minkan nkan Mariael. Epe Maria mira Jisas, ka nti aiyimpil Krais, omoule ka Wulapm Weink yuwakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nti manmakn ka eik Abraham la akei Devitel, nio antuol eikusuknel ka Et eik Devit la akei nti ka ar Babilonel, nio antuol manmaknel ka Et eik nti ka ar Babilonel la yumua omoule ka nti aiyimpil Krais nio antuol manmaknel, ka Sank keielel ka nak apulp nti manmakn Jisasel eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sank apulp Jisas Krais ka Maria ra kilel ka sopeiye. Mantiek ankilel Maria ka nti sankantun kil, nako yentemp Josep nkis. Aser Maria karokn antempil, aser kil ka opmuon uknuamp, kil ka ninkilapmimp. Ninkilapm kilpe itnei Mariael, ka Pirpm Wulapm Weinkel ankil apupul. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Minkan ankilel Josep, kil ka omoule yapmonemp sepm ntinkiraiel. Kil eipm aser Maria ka ninkilapmel, aser kil karokn na nker kil yer niampepm antuol eikusuknel. Et kil na serkempil eik nkuwepmel apulp na kil karokn na yupul Maria wule maiak yer niampepm antuol nti omoule eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep wonempwamiyimp aiyapel kil na nekerpmel. Epe kil ar niumpu yenkeniepmel, aser ensel Wulapm Weinkel eik nimininkel nakimpil nak na, “Josep, Aknamniumpuai Devitel, yikn korokn nkierkemp Maria. Ko yikn sempil, kil ka muaken aiyiknel. Yikn eipm apm. Ninkilapm kile ka tnei kilel, ka Pirpm Sepmel Wulapm Weinkel ankil awulmpil, kurpe kil ninkilapmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kil kako ra ninkilapm ntit, nako yikn yimp nio ankilel Jisas. Weink nio Jisasel ka nak na kil kako nantip mo yerkomp nti ementitmuaken ankilel, nti ka nkis minamp kuoretel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Omoule ka kumpueik nakaworp yapmonemp Wulapm Weinkel, sank Wulapm Weinkel ka naikul miepm ankilel, aser kil nak na, Muakenel karokn antemp minkan, aser kil ka ninkilapm osoimp. Kona kil rael, kako ninkilapm ntit. Nio ankilel ko nti yimpilel kako Emanuel. (Aisaia 7:14) Weink nio keielelel ka nak na Wulapm Weink ka ar nampueip an. Sank kilelel kumpueik kil nakel, keielel an niampepm nkupmus, kipe niminink. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kakilpe, Josep eik niumpu nkarp, kil apul sop sank kilelel ka ensel nakimpilel. Kil nkamp muaken ankilel Maria apul kil muar yetne ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Aser Josep karokn rap Maria ninkilapm irpm lala Maria mira ninkilapm ntit. Nio ninkilapmel, Josep aiyimpil Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria ka ra Jisas ar Betlehem ka ar Judia, aser Herot ka omoule amamp ka awulmp kitapm Judiael. Maria mira Jisas, ar pitekn, nti emesepmel awemp oumpyetne antuol ka ar yemp awun noel ka peikel yatelip. Nti ka la niminink Jerusalem. Nti aiyimp ninaiwulp nti ntitmuaken Jerusalemel na, ");
INSERT INTO xbi_w_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ninkilapm niuwaiknel kil kana yer ntoka omoule amamp aiyipmel Judael, ka mantiek ankilel ra kil ar ku? An ka apei yemp antelel awun noelel, an anser nkuaimantump ka ntikiremp an apulp kil ka nininkel. Kakilpe an la na nemirempil, yinki nio ankilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Omoule amamp antuol Herot antemp nti omoule ntitmuaken Jerusalemel nti eipm sank ntokilpelel, nti ka numumpul. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kakilpe Herot aiyimp nti omoule amamp antuol prisel nampueip nti omoule wupm araiel, kil aiyimp ntiwarko eikusukn la etn lekekn nser kil. Nti lael, Herot amiyimp nti na, “Yipm ka ntinkirai apulp sank sepmel Mosesel apulp Krais, omoule ka Wulapm Weink yuwakel. Et yipm nikimp apm, mantiek ankilel ko ra kil yer yemp yanunku?” ");
INSERT INTO xbi_w_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aser nti naimpil nakimpil na, “Krais kako ninink yer Betlehem ka ar Judia. Omoule ka kumpueik nakaworp yapmonemp Wulapm Weinkel, ka apul sank sil wupm nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yipm Betlehem, yipm ka yemp akopitekn aser yipm ka nio nkampel. Ar yemp eikusukn Judiael, yipm Betlehem ka ar niorknel. Ka nio nkamp yipmel ka apulp emelel aiyipmel kileko yer ntoka omoule amamp. Kil kako yuwulmp nti ementitmuaken Wulapm Weinkel ka ar Israelel”. (Maika 5:2) ");
INSERT INTO xbi_w_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nti emesepmel Judael kile ka apmon, niatel Herot mper sank nakimp nti emesepmel yemp awun noelel eik nkuwepmel, nti na nimpil la ser kil. Nti kilpe la, aser kil aiyimp ninaiwulp ntiimp, nak na, “Arikel ka yipm aser nkuaimantump ka naikulel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kil nakimp nti na mila Betlehem, nak na, “Yipm la, yuwup ninkilapm kuorelel aipopel. Yipm ko yuwupil na kona yipm ninkempilel, yipm ko pelkel nimpil la nikimp apm nako apm la nerempil yiki nio ankilel soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nti opmueipm sank ka Herot nakimp nti niatel, nti apmon. Nkuaimantump ka kumpueik nti aser ar yemp antuol awun noelel, ka naimpil nai la niorkn ntinkiremp nti aiyapel, la insil senkerpm yetne ka ninkilapm niuwaiknel arel. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nti aser nkuaimantump ntokilelel, nti ka eik mpuaimpuaielip. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nti kilpe war yetne aser ninkilapm nampueip mantiek ankilel Maria. Nti waker akaikyuwump eip kitapm, mpo nisep o, nti namiremp ninkilapm kilpe. Nti sikin urmpunk antuol amiye sinsi mimi sepmel amuk kil. Nti ok kil wuntokn sepmel (gol), antempel sinsi irpm ka yepm sepmel nankiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aser Wulapm Weink akei yenkeniepmel nakimp nti na, “Yipm korokn nimpil la ser Herot”. Kakilpe nti nankerpm aiyapel yatel naimpil mila kitapm oumpyetne weink antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nti omoule kilelel, nti ka apmon, aser Wulapm Weink niuwuwul ensel ankilel napir Josep ok kil yenkeniepm nak na, “Et yikn nkierp, ukua muaken ninkilapm aiyiknel, yipm ko nkierk mila Isip. Yipm ko yer Isip lala ser apm ko nimpil nikimp yipmel, ko yipm mila. Herot kana nikimp nti omoule napolel ankilel, na yuwup ninkilapm aiyiknel, ka nti na yer kil wuntuel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep eipm sank ntokilpelel, kil nkarp wunoump wanki, ukua muaken ninkilapm ankilel, nkark eik oumpyetne Betlehem mila kitapm Isip, ka yemp peikelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nti ka ar Isip lala aser Herot ka wuntuimp. Sank ka kumpueik omoule ka nakaworp yapmonemp Wulapm Weinkel nakel, ka kipe niminink, kipe an anser. Kil nak na, Ninkilapm ntit apmelel ka ar Isipel, apm aiyimpil ko yewemp Isip yer, kil ko mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Omoule amamp Herot karep nkamump ntinkirai apulp nti omoule sepmel awun noelel ka ninkai kilel. Aser yapmonemp ankilel ka ntinkliempimp. Kakilpe kil nakimp nti omoule napolel ankilel mila Betlehem antempel nti oumpyetne ka ar kitnan nantipilel. Nti ar nti ninkilapm ntit karokn nioknwank wie antun ntiel, ar nti eikusukn wuntu mpruwaselimp sop sank antuol nti omoule sepmel kilpelel nakimp Herot apulp arikel ka nti aser nkuaimantump ka naikul ar yemp antuolel. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nti apul ntokilelel, ka sop sank Wulapm Weinkel ka kumpueik Jeremaia nakel. Kil nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nti wat warawur, so nimpi muanel awor lepel lepel ar yemp suknel Rama. Ka Resel saiyip nti ninkilapm ankilel ka wuntu wuntu niatel. Aser yapmonemp ankilel ka sukukurelimp, kil karokn apulp nti omoule na wakiker kilel. (Jeremai 31:15) ");
INSERT INTO xbi_w_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Josep nti ka ar Isip, aser Herot ka amur. Wulapm Weink niuwuwul ensel ankilel napir Josep ok kil yenkeniepm nakimpil ");
INSERT INTO xbi_w_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","nak na, “Yikn serp, ukua muaken ninkilapm aiyiknel nimpil mila Israel. Omoule kana yer ninkilapm wuntuel ka amur”. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kakilpe Josep ukua muaken ninkilapm ankilel naimpil mila Israel. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aser Josep ka eipm sank na Arkelaus naimpil nkamump yemp nkan waiek ankilel Herotel, kil ka apmoi omoule amamp awulmp kitapm Judiael ka ar Israelel. Josep ka nkinkiekn ampulp na la Israel, aser Wulapm Weink akei yenkeniepmel nankimpil na, “Yikn la kitapm Galili”. ");
INSERT INTO xbi_w_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kil kilpe la Galili ka yemp yatel ar Israelel, kil nkupmus oumpyetneel ka nti aiyimp Nasaret, ka sop sank kumpueik omouleel nakel. Kil nakaworp yapmonemp Wulapm Weinkel nak na, Kako nti yimpil omoule Nasaretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","4","Kumpueikel Wulapm Weink ka nak sank ar miepm Aisaiael, kil ka omoule ka nakaworp yapmonemp Wulapm Weinkel. Kil nak na, Ar yemp kuserel omoule karoknel, emelel kileko yekei suknel nek na, Sepmel aiyipmel kilipm, yipm ntimpramp yapmonemp, krak aiyapel kil na yetnel. (Aisaia 40:3) Sank keielel ka nak apulp Jon Baptaisel ka niminink. Jon ka rap wapm niurkutupel, ka kil akei niol kamelel apulel. Kil antun wusaikn akei ntemp mila ntumpualenk ankilel. Miepm ankilel ka kil alel, ka kil al milmp niupukn ka kil nkamp ar wurun osoel antempel wusol irpm. Aninkel Jon Baptaisel la etn yemp kuserel ka ar kitapm antuol Judael, kil wat sank Wulapm Weinkel nankimp nti ementitmuaken. Kil nak na, “Yipm nimpilemp yapmonemp nisep sankminamp kuoretel ka yipm apulel. Pitepiteknimp Wulapm Weink nako yumulmp an”. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kakilpe, nti omoule Jerusalemel nti omoule Judael, nampueip nti omoule oumpyetne irpm antuol ka ar nantip upukn Jordanel, nti la anser Jon. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kakilpe nti nakamorp yapmonemp kuoretel ka nti apulel. Niatel, Jon wurp nti amu mpep apmoi upukn Jordan. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon anser nti Farisi nampueip nti Sadyusi na la ser kilel ka kil wurp nti ntitmuaken o mpepel, aser kil nakimp nti na, “Yipm'a ninkai mini? Ka yipm akei wule kuserel eik la ser apmel. Yapmonemp aiyipmel ka ar wieel apulpi? Ka mini nakimp yipm na yipm'a la keielel, nako yipm waiyimp yapmonemp ntinkiliempel Wulapm Weinkel? ");
INSERT INTO xbi_w_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kona yipm na nimpilemp yapmonemp etetelel, ka akosepm. Et yipm kako yupul minamp sepmel sitel, ko ntikiremp an na yipm karep nimimpilemp yapmonemp. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yapmonemp aiyipmel ka nak na, Wulapm Weink kakorokn yump an. Yipm nakel na, Abraham ka man antelel ka Wulapm Weink nkampil mpiniorkn. Et kakilpe, kil kakorokn yump an apulp an ka entieyarkup ankilel. Ka yipm nak ntokilelel, aser apm nakimp yipm etetelel. Entieyarkup Abrahamel karokn sinsi suknel ar niampepm Wulapm Weinkel ko yipm yekei Abraham nkael. Karokn. Et kona Wulapm Weink upuiknel, kil na nimpilemp wuntokn irpm nuntup omoule kako entieyarkup Abrahamel. Kakilpe, et yipm korokn wonempwaiyimp na man aiyipmel ko yupul yipm na yer sepmel yer niampepm Wulapm Weinkel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wulapm Weink ka awup nti omoule ka sop sank ankilel nkis minamp sepmel, nti ka numuarep lo ka wurkopm naker mitinkelel. Kona wurkopm ankilel korokn mitinkelel, pitepiteknimp Wulapm Weink ko yekei elmp ankilel mpuar nti yawol yumu yete. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka apm wurp yipm o mpep sitel, ka muati apulp yipm karep nimimpilemp yapmonemp. Aser omouleel kona ninink nkienel, kil ko yekei Pirpm Wulapm Weinkel yentemp yete yupul niokn ankilel na wurp yipmel. Salpiknin ankilel ka samunkuork apm. Niokn apm apulel karokn sepm sop niokn kil ko yupulel. Kakorokn. Keiye apm eik apulel, ka ntoka nio apmelel ka kuserelel. Nio ankilel ko yer sukn nemp ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kil ko la nuarep omoule ka antun wurkopm witel, niupukn ankilel kil mper ar yetne mpawuel, aser aikn ankilel ka kil nkamumpuat, kako wus yer yete ka ar aninkaninkel.” ");
INSERT INTO xbi_w_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aninkel kilelel, Jisas nkarp eik Galili mila upukn Jordan. Kil la aser Jon, nakimpil na, “Yikn wurp apm yo mpep”. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aser Jon nak nker kil na, “Apulntoku kile yikn aiyimp apm na wurp yikn yo mpepel? Akosepm ko yikn wurp apm epe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aser Jisas naimpil nakimpil na, “Karokn. Kako yikn yupul ntokipe apm nakel epe. Yapmonemp kipelel kako sop upuikn Wulapm Weinkel, apulp yapmonemp sankminamp sepmel eikusukn ko an yupulel”. Kakilpe Jon apul misop sank ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas wurp o mpep niatel, kil naimpil aki no, niampepm antup namp mpuor ekeipm, aser mpuor akuor kitiekitie. Kil anser Pirpm Wulapm Weinkel akimp nuarep aipmel o sil kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kakilpe sank ka naikul mpuor eikipmin, ka Wulapm Weink nak na, “Kil keielel ka ninkilapm apmelel, apm ka apulpil yatip. Yapmonemp apmelel ka mpuaimpuai apulpil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aninkel kilelel, Pirpm Wulapm Weinkel apul Jisas mila yemp kuserel ka omoule karokn arel, apulp na Satan ko timpielpil yapmonemp ukuapil na yupul yapmonemp kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wunoump awun, Jisas nakantup miepm la tnei awun ka 40-pla, et nilmp amuor kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan la ninkempil nakimpil na, “Kona yikn ninkilapm Wulapm Weinkel, yikn nimpilemp wuntokn kile nisam luwu ninker nako yikn yel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aser Jisas naimpil nakimpil na, “Sank ka sil wupm Wulapm Weinkel ka nak na, Sank Wulapm Weinkel, kako yok nti ementitmuaken mintenk. Miepm sit kakorokn yok nti mintenkel”. (Lo 8:3) ");
INSERT INTO xbi_w_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kil nak sopeiye aser, Satan naimpil nkampil mila Jerusalem. Kil ukua Jisas la yetne suknel Wulapm Weinkel, apul kil no nsil yetne ekeipm ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satan nakimpil na, “Kona yikn ninkilapm Wulapm Weinkel, et yikn yukur yo kitapm. Sank ka sil wupm Wulapm Weinkel ka nak na, Kil ko nikimp nti ensel ankilel ko semp yikn sil onto antuol apulp wuntokn kakorokn yump yikn akaik”. (Buk Song 91:11-12) ");
INSERT INTO xbi_w_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aser Jisas naimpil nakimpil nak na, “Sank yatel ka sil wupm Wulapm Weinkel ka nak na, Salpiknin Wulapm Weinkel ka suknip, yikn kakorokn timpielpil”. (Lo 6:16) ");
INSERT INTO xbi_w_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aser Satan naimpil nkamp Jisas apul namp malenk ekeipm no nsil yapel. Kil ntikiremp Jisas oupmweink mitinkel ka awulmp kitapm sukurel. Kil ntikiremp Jisas sinsi mimi sepmel ");
INSERT INTO xbi_w_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nakimpil nak na, “Kona yikn waker akaikyuwump eip kitapm yiki nio apmelel, apm ko yok yikn sinsi mimi eikusukn kilpelel ka yikn aserel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aser Jisas naimpil nakimpil na, “Satan, yikn nisep apm! Sank ka sil wupm Wulapm Weinkel ka nak na, Yikn ko yiki nio Wulapm Weinkel sit, kil sit ka sepmel aiyiknel”. (Lo 6:13) ");
INSERT INTO xbi_w_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kakilpe Satan awemp Jisas apmon, aser karokn walil, nti ensel Wulapm Weinkel o wakerpil. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Jisas ka eipm aser nti mper Jon apmoi yetne kuoretel, et kil awemp Nasaret apmoi. Kil mila Kaperneam ka ar kitapm Galiliel, ka kitnan nantip mpepwarmp Galili. Kitapm kilpe nti nkisel, ka kumpueik nti oupmweink Sebulun nampueip nti Naptali nkisel. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Ka sop sank ka kumpueik Wulapm Weink aki yapmonemp Aisaiael, ka kil nak na, Nti Sebulun nampueip nti Naptali, kitapm antuol ka ar Galili apei yakitie upukn Jordanel. Nti ka sil aiyapel suknel ka la mpep nioupmel, et nti omoule yatel wampwamp mitinkel ka antemp nti nkis. Nti ementitmuaken nkan Sebulun nti Naptaliel, nti ka nkis kuko antemp yapmonemp nilapmel. Aser Wulapm Weink kako yupul yapmonemp nilapmel antuol kilelel ko yer mpilil ntinkiraiimp. (Aisaia 9:1-2) Jisas ka apei Kaperneam ntokilelel, ka Wulapm Weink apul sank Aisaiel kilpe niminink. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aninkel kilpelel, ka sukur Jisas nankimp nti ementitmuaken sank Wulapm Weinkel, kil nak na, “Et yipm ko nimimplemp yapmonemp nisep sankminamp kuoretel apulp na Wulapm Weink ka ar kitnan, kil kana yumulmp yipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas nakerpm mpepwarmp eikiriekn Galiliel amu aser, kil anser ntiwie esuknuanel, Saimon, ka nio yatel ankilel Pita, nampueip uknuan ankilel Andru. Ntiwie apul niokn wuntokn ntiwieel akei ntoknpuank nkamp oyokn apmoi mpepwarmp. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas nakimp ntiwie nak na, “Yipmwie la sop apm. Keielel yipm ka nkamump oyokn, et apm'a yok yipm niokn yatel, yuwap yipm aiyapel nako yipm semp nti omoule yimp nti na sop apmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Karokn walil, nti nisep ntoknpuank antuol nkupmus, ntiwie la minsopil. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas lala aser, kil anser ntiwie esuknuanel yatel, Jems nti Jon, nampueip waiek ntiwieel Sebedi. Ntiwarko ka sil wutumpepel amomp ntoknpuank ka kakirel. Jisas amiyimp ntiwie, ");
INSERT INTO xbi_w_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","et karokn walil, ntiwie arkomp waiek ntiwieel sil wutumpepel kilpe apmoi, ntiwie la minsop Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ka etn aser nti eikusukn ar kitapm Galiliel, kil muar yonk Wulapm Weinkel irpm antuol yumuap nti ementitmuaken sank sepmel apulp Wulapm Weink na yuwulmp ntiel yer onto ankilel. Nti ementitmuaken ka wulenip mimi apul ntiel, kil naimpil apul nti sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nti sukueimp nti ntitmuaken ka ar kitapm Siria sukurel, nakimp nti sank ampulp Jisas. Kakilpe nti Siria wampwampel apul nti omoule ka wulenip mimi apul ntiel, nampueip nti mini ka nkamp yakop suknelel, nampueip nti omoule ka muanumpuor yanker aimp ntiel, nampueip nti omoule ka mpienyukurel, nampueip nti omoule ka ontoakaik awurel, nti eikusukn mila. Kakilpe Jisas apul nti naimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nti omoule ementitmuaken mitinkel, ka nkarp ar Galili, Dekapolis, Jerusalem, Judia, nampueip nti yemp ka ar yakitie nkan pukn Jordanel, nti ka sopil. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas aser nti ementitmuaken mitinkel arko lael, kil kilpe nkarp la namp malenk. Nti omoule ka sopilel la ser kil, ");
INSERT INTO xbi_w_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ka kil yuwap nti nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nti omoule ka wonempwaiyimp na nti ankil karokn mintenk na sop aiyapel Wulapm Weinkel, nti ka ar mpuaimpuai. Nti ka ar amintemp Wulapm Weink apmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nti omoule ka ar antempel yapmonemp wankepmel nimpi niepiekel, nti ka ar mpuaimpuai. Wulapm Weink kileko wakiker ntiimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nti omoule ka ar niuluknunel, karokn aki nio antuol no ekeipm, nti ka ar mpuaimpuai. Kuatiar Wulapm Weink yok nti kitapm sukurel la onto antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nti omoule upuikn antuol ka sukn apulp nti na yer nkis minamp sepmel sitel, nti ka ar mpuaimpuai. Kuatiarel Wulapm Weink kako yupulp nti sukn sop upuikn antuol kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nti omoule ka akei nainkerp nti omoule yatelel, nti ka ar mpuaimpuai. Wulapm Weink kuatiar yekei nainkerp nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nti omoule yapmonemp antuol ka ntinkiraiyimp, nti ka ar mpuaimpuai. Kileyarel niampepm antuol ko nkupmus Wulapm Weink. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nti omoule ka nak aikuli nti ka nawupm napolel, nti ka ar mpuaimpuai. Kileyarel Wulapm Weink ko yimiyimp nti ninkilapm ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nti omoule ka nakerpm minamp sepmel naka nkamp yakop ar onto antuol omoule kuoretelel, nti ka ar mpuaimpuai. Nti ka antemp Wulapm Weink ar onto ankilel ar sepmel apmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kona nti omoule ser yipm nana yipm ka nakerpm apmel aser nti ka nak sank opmoumpel apulp yipm, apul nio aiyipmel amu kitapm, et kona nti wakerkaik yipmel, yipm ka ar mpuaimpuai. Ka Wulapm Weink apul yipm sepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wankepm kile yipm ninkempel ka soplekekn ka kumpueik ninkemp nti omoule Wulapm Weinkel ka nakaworp yapmonemp ankilelel. Aser keielel yipm ko eik mpuaimpuaiel, apulp Wulapm Weink kana yupulp yipm sepmel suknel ware yopmoi yemp ekeipmel ankilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas naimpil nak na, “Yipm ka nuarep nioupm ka apul miepm ka sinkenel. Aser nioupm kona selmpenkel, ko an yupul ntoku na nioupm ko nimpil sinkenel? Arokn. Kona nioupm ka selmpenk ntokilelelel, kako kuoretimp. Nti omoule kako nimprip yekei akaik eselewim. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yipm ka nuarep yete leiyenk ka lep aiyapelel. Nti ko ser minamp aiyipmel ntinkirai sop yete leiyenk ka ar yemp suknel ar no malenk yapel ka lep nti oelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nti omoule kakorokn nupoupm yete yekei marpm yuwulmp nkis kitapm. Karokn. Ka nti yuwol ar ekeipm, apulp na lep yemp na mpililel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sankminamp aiyipmel kako soplekekn, kako yer sepm sepm sit yer niampepm antuol ementitmuakenel. Kona nti ser sankminamp sepmel aiyipmel, nti ko yinki nio nkan waiek aiyipmel ka ar yemp ekeipmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas naimpil nak na, “Sank salpikninel Wulapm Weinkel ka Moses ok yipmel antempel sank antuol nti omoule Wulapm Weinkel ka nakaworp yapmonemp ankilelel, yipm korokn nek na apm ka la nakimp yuwap yipmel na antarko ko yekei opmoump sank irpm kilelel eik wapel na yupul sank irpm kilelel miniat. Karokn. Apm'a nek sempop sank salpikninel eikusukn ko yer mintenk. Ka apm ankil ko yupul sank niupukn nkan sank irpm kilelelel ko miepm ankilel ko neker. Aser yipm yukueimp ser. Sank salpikninel Wulapm Weinkel eikusuknel, kona miepm sukurel ankilel ka karep naker miniat, aninkel kilpelel, sank kilelel yentempel kitapm sukurel kako miniat. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Apm nakimp yipm etetel. Yitoumparai sukn pitekn eikusuknel ka nti akei ar sank salpikninel kakorokn niat niorkn. Karokn. Aser kona kitapm niatelel, sank salpikninel kakorokn niat, kako yer soplekekn yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kona emel nek na, Sank salpikninel keielel ka sinsi akopitekn nako kil ukuap nti eikusukn na yuntun sank salpikninel soplekekn kil apulel, kuatiar kona Wulapm Weink yuwulmp anel, omoule kilelel nio ankilel kako yumu kitapm. Aser kona emelel yupul sop sank salpikninel, ntikiremp nti eikusukn nako nti yupul soplekeknel, kuatiar kona Wulapm Weink yuwulmp anel, omoule kilelel nio ankilel kako yer nemp ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Apm nakimp yipm, kona yipm wonempwaiyimp na yipm na war yer onto Wulapm Weinkel, sankminamp sepmel aiyipmel kako samunkuork sankminamp sepmel antuol Farisiel nampueip nti omoule wupm araiel ka yuwap nti ntitmuaken sank salpikninel Wulapm Weinkel. Kona oroknelel, et yipm korokn war yemp Wulapm Weinkel yentempil yer yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas nak na, “Sank salpikninel Wulapm Weinkel ka kumpueik Moses nakimp nti manmakn aiyipmel, ka nak na, Yipm korokn yer emelel wuntu. (Kisim Bek 20:13) Nti manmakn nak na kona yikn yer emelel wuntuel, yikn kileko yopmon niampepm antuol nti omoule ka mpunti silel ko nti yuntunel yiknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sank ka sil wupm Wulapm Weinkel ka nak sopilelel, aser apm nakimp yipm walimp na, yikn kona yentemp mamintoump aiyiknel nukuapm nukuapm sitel, yikn ko soplekekn, yikn kileko yopmon niampepm antuol nti omoule ka mpunti silel. Aser kona yikn nikimp mamintoump aiyiknel sank kuoretelel, yikn kako yetn niampepm antuol omoule amamp antuolel. Aser kona yikn nikimp mamintoump aiyiknel na kil ka niepel mankirpmel, et yipm yekei wonempel. Yikn kona yupul yupulel, et yikn kako yo yemp yeteel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kakilpe kona yikn'a yupul sinsi aiyiknel la na yok Wulapm Weink sil lowaimp oumpiepmelel, aser yikn ka wonempwaiyimp wankepm aiyiknel antemp emelel, ");
INSERT INTO xbi_w_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","et yikn ko mper sinsi aiyiknel la peik. Niorkn yikn la yentempil nek sank yump yapmonemp yo lekekn. Niatel, ko yikn la yumuk Wulapm Weink oumpiepm aiyiknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kona yikn apulp emelel wankepm miel aser kil na yentemp yikn nek sankel, kona yipmwie yetn aiyapel na ser nti omoule ka nunkurk yirpmel, et yikn ko pelkel la ser kil, nek sank yump yapmonemp yo lekekn yupulp sank na yuwurel. Oroknel, omoule kilelel ko mper yikn la onto masistretel tikikn, et masistret ko mper yikn la onto antuol omoule aipmpienel ko nti mper yikn war yetne kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Et apm nakimp yikn, yikn ko yer yetne kuoretel yeryer ko yikn nimpil yok nti wuntokn muati sukurel ka nti nak apulp yikn'a mper yupulp wankepm ka nkis yiknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas naimpil nak na, “Yipm ka opmueipm sank salpikninel Wulapm Weinkel ka Moses ak yipmel ka nak na, Yipm ntitmuaken korokn yupul mualakntankermp. (Kisim Bek 20:14) ");
INSERT INTO xbi_w_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sank ka sil wupm Wulapm Weinkel ka nak sopilelel, aser apm nakimp yipm walimp na, kona yikn ser muakenel na yekei yapmonemp ukuapilel, ka soplekekn ntoka yikn ka karep antempil apul mualakntankermpel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kakilpe, kona niampepm aiyiknel ukuap yikn'a yupul setelel ka kuoretelel, ko yikn tipimp muat. Akosepm kona yikn yekei niampepm lekekn sitel na war yer yemp sepmel. Oroknel, kuatiar yikn yupul omoule aiyiknel sukur la yemp yeteel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kona onto yapelel aiyiknel ukuap yikn na yupul setelel ka kuoretelel, ko yikn yuntun nkiempwat. Akosepm kona yikn yekei onto lekekn sitel na yer sepmelel. Aser kona oroknelel, kuatiar et yikn ko yupul omoule aiyiknel sukur na la yemp yeteel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas nak na, “Sank salpikninel Wulapm Weinkel kumpueik Moses ak yipmel ka ntokeiye. Muaken aiyiknel kona yikn'a nker kilel, et yikn ko yok kil wupm ka nak ntinkirai na karep yikn nkimer kil. (Lo 24:1-4) ");
INSERT INTO xbi_w_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sank ka sil wupm Wulapm Weinkel ka nak sopilelel, aser apm nakimp yipm walimp na, kona muaken aiyiknel karokn apul mualakntankermp antemp emelelel, aser ka yikn nker kil upuikn aiyiknel, ka yikn ankil ka waker sank salpikninel Wulapm Weinkel. Kona muakenel na yentemp minkan yatelel, kil ka antemp omoule kilpelel apul mualakntankermp. Weink kilelel ka nkis minkan niorknel ankilel karep nker kilel. Kona ementit na semp muaken ka kumpueik ementit yatel nker kilel, ka soplekekn. Kil ka antemp muaken kilelel apul mualakntankermp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jisas nak na, “Sank salpikninel Wulapm Weinkel ka Moses ak yipmel ka ntokeiye. Kona yikn nek etet kuntoel na mintenkitneip sank aiyiknelel, yikn korokn eik nekel. Kona yikn nek etet kuntoel, et yikn ko yupul nsop sank ka yikn nak ar niampepm Wulapm Weinkelel. (Namba 30:2) ");
INSERT INTO xbi_w_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sank ka sil wupm Wulapm Weinkel ka nak sopilelel, aser apm nakimp yipm walimp na, yipm korokn semp sank miel na nek etet kuntoel yupulp na mintenkitneip sank lekekn aiyiknel. Karokn. Yipm korokn yimp nio yemp sepmelel na nek etet kuntoel yupulp sank aiyiknel. Apulp na yemp sepmel ka lontolnko sepmel Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Et yipm korokn yimp nio kitapmel na nek etet kuntoel yupulp sank aiyiknel. Apulp na kitapm ka yemp ka Wulapm Weink wul akaik ankilel silel. Et yipm korokn yimp nio Jerusalem na nek etet kuntoel yupulp sank aiyiknel. Apulp na Jerusalem ka yemp suknel ankilel omoule amamp niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yikn korokn yekei amamniol aiyiknel na nek etet kuntoel sank aiyiknel. Apulp na yikn karokn mintenk nako yikn nimpilemp amamniol aiyiknel erpmelel nimpil la mpusel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Et yipm kako nek ‘Ank’ mi ‘Orokn’. Keielel sitel. Kakilpe. Sank irpm ka yipm nak na mintenkitneip yipm sankel, ka Satan ankil aki yapmonemp aiyipmel et ka yipm napmok”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas nak na, “Sank salpikninel Wulapm Weinkel ka kumpueik Moses ak yipmel ka nak na, Kona emelel na tipimp yikn niampepmel, yikn ko nimpil tipimpil niampepm wamire. Kona emelel ko waker yikn nayinkuel, yikn ko nimpil waker kil nayinku ware. (Kisim Bek 21:24) ");
INSERT INTO xbi_w_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sank ka sil wupm Wulapm Weinkel ka nak sopilelel, aser apm'a nikimp yipm walimp na, kona emelel na yupul yikn kuoretel, yikn korokn nimpil yupul kil ware. Karokn. Kona emelel na mutumyimpil yiknel, yikn ko eik yewempilel na nkis niuluknun timpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kona emelel na yentemp yikn nek sank yer niampepm antuol omoule ka mpunti silel na semp wapm ka yikn tneiel, yikn korokn nirkimp; ko yikn semp wapm yatel ka yikn rap awulmp matnoel, yok kil wapm wie yemintemp. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kona emelel na yentemintenk yikn na sakirpil ntokwankepm la yemp kitnanel, ko yikn nimpil sakirpil mila yemp peikel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kona emelel na yimp yikn yupulp setelel kuatiar kil nimpil yok yiknel, ko yikn yok kil. Kona emelel na yimp yikn na yok kil sinsiel aser kil na eik sempelel, et yikn korokn nirkimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisas naimpil nak na, “Sank salpikninel Wulapm Weinkel ka kumpueik Moses ak yipmel ka nak na, Nti omoule entieyarkup aiyiknel, ko yikn wonempyupulp nti na yupul nti sepm. (Wok Pris 19:18) Nti manmakn aiyipmel nak walimp nak na nti yatel minimini, karokn. Yipm korokn wonempyupulp nti. Nti ka omoule wurokn yankerelip. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Aser ka apm nakimp yipm walimp na, yipm ko yekei onto niupuknel aiyipmel nkrawomp nti omoule ka yipm antemp nti nkisempel. Nako yipm yentemp Wulapm Weink nek sank yimpil yupulp nti, nako yipm wonempyupulp nti omoule ka apul yipm kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Et kona yipm yupul ntokilelel, yipm kako ninkilapm nkan Waiek Ekeipmel apulp na sankminamp aiyipmel ka soplekekn sankminamp ankilel. Kil ka apul awun ka akuorp ar ekeipm ka lep nti omoule sepm kuoret sukn akoel. Antempel etnie ka kil apul yir awulmp nti omoule eikusukn sepm kuoret sukn ako. Sankminamp aiyipmel, et yipm kako yupul soplekekn ka kil apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kona yipm yekei onto niupuknel aiyipmel nkrawomp nti omoule ka apul yikn sepm sitel, Wulapm Weink kakorokn yupulp yikn sepm ware. Apulp na nti omoule kuoretel ka nkamp yipm wuntoknel na yok omoule amamp Romel, nti ka apul soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kona yipm nek neremp nti omoule entieyarkup aiyipmel sitel, et kako yipm sankuork nti omoule eikrieknel ntontoku? Kakorokn. Nti omoule karokn sop Wulapm Weinkel, nti ka apulp nti emeniemp antuol soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Et apm nakimp yipm, sankminamp aiyipmel ko yer sepm sepm sitel sop Waiek aiyipmel ka ar yemp ekeipmelel, kil ka ar sankminamp sepmel sitel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas naimpil nak na, “Yipm ko yekei wonempel yupulp sankminamp aiyipmel ka yipm nkisel, yipm korokn yupul yer niampepm antuol ementitmuakenel nako nti serel. Yipm kona yupul yer ntokilelel, Waiek Ekeipmel kakorokn nimpil yupulp yipm sepm ware yupulp niokn ka yipm apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kona yipm'a yok nti eretako sinsiel, yipm korokn yiki nio aiyipmel nuarep nti omoule ka akei wule eikrieknel. Nti ka akei amampel nak aki nio antuol, nti etn aiyapel nak, etn yonk Wulapm Weinkel nak. Nti kana ntikiremp nti eikusukn wonempyapm sepmel antuol yupulp nako nti omoule ser nti ka omoule akosepmel. Apm nakimp yipm etetelel, nti omoule keielel nio suknel nti upuikn apulpel, karep nti nkamp wamire. Aser kuatiarel Wulapm Weink kakorokn nimpil yupulp nti yatel ware. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kona yikn yupulp nti eretako ntokilelel, ko yikn yupul nkuwepm, nti omoule kakorokn ser ka yikn apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kona yikn yupul ntokilelel, niokn sepmel ka yikn apulp ntiel kako yer nkimepm. Waiek Ekeipmel sit ko ser niokn ka yikn apul nkuwepmel. Kona ntokilelel kil ko yupul yikn sepm ware niokn kile ka yikn apulel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisas nak na, “Kona yipm yentemp Wulapm Weink nek sankel, yipm korokn yupul nuarep nti omoule ka akei wule eikrieknel. Upuikn antuol ka apulp na nti na yupul niampepm muatipmel yentemp Wulapm Weink yekei suknel nek sankel yer yemp yapel sop aiyapel nakurepm mi yonk Wulapm Weinkel. Nti apulp na nti omoule ko ser ntiel yiki nio antuol. Aser apm nakimp yipm etetelel, nio sepmel antuol nti upuiknel, karep nti nkamump ar niampepm antuol omoule kitapmel. Wulapm Weink kakorokn yupulp nti yatel ware. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Aser kona yikn'a yupul niampepm muatipmel nek sank yentempel Wulapm Weinkel, ko yikn sit war yetne aiyiknel yetn loump nkunkun nako yikn sitel yentempil nek sank. Waiek Ekeipmel ka ser niokn ka yikn apul ar nkuwepmel ntokilelel, et kil kako yupulp yikn sepm ware. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kona yipm'a yentemp Wulapm Weink nek sankel, yipm korokn nkis nek sank ukuap mpeikn nuarep nti omoule ka tupualimp wulapm kitapmel antuolel. Nti ka nak na kona nti nkis eik nek nekel ukuap mpeikn ntokilelel, wulapm antuol kako opmueipm nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yipm kakorokn yupul sop ka nti apulel. Yipm kako ntinkirai yupulp yapmonemp Wulapm Weinkel ka yatel, yapmonemp antuol wulapm kitapmel ka yatel. Wulapm Weink kil karep aser miniorkn apulp sinsi irpm ka yikn karoknel. Kil karokn yukueimp yikn na nek sank ukuap mpeikn yimpilel. Karep kil aser miniorkn. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kona yipm yentemp Wulapm Weink nek sankel, et yipm ko nek ntokeiye: Waiek antelel ka ar yemp ekeipmelel, nio ntinkiraiel aiyiknel ko yer niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","An aiyimp yikn ko yikn pelkel semp yemp omoule amampel, nako an nekerpm sank aiyiknel sukurel yer kitapmel ntoka nti ka ar no yemp ekeipmel ka nakerpm upuikn aiyiknel aninkaninkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","An aiyimp yikn na yok an miepm yupulp awun keielel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yapmonemp kuoretel antelel ko yikn wonempsukurel sop ka an wonempsukurel yapmonemp kuoretel antuol ka nti apulp anel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Et yikn korokn yekei niampepm ser setel kuoretel ninkemp wankepm. Ko yikn mpuanink an yupulp Satan kakorokn ukuap an na yupulp an ntokilelel. Kakilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yipm eipm, kona yipm wonempsukurel yapmonemp kuoretel antuol ementitmuakenel ka nti apulp yipmel, et Waiek Ekeipmel ka ar yemp ekeipmel kil kako wonempsukurel yapmonemp kuoretel aiyipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aser kona yipm korokn wonempsukurel yapmonemp kuoretel antuol ementitmuakenel, Waiek Ekeipmel kakorokn wonempsukurel yapmonemp kuoretel aiyipmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas nak na, “Kona yipm nkis nailep yupulp yapmonemp aiyipmel ko yer mintenk yentemp Wulapm Weinkel, mponiampepm aiyipmel korokn wankir sop ka nti omoule ka akei wule eikrieknel apulel. Nti upuikn na ntikiremp nti ntitmuaken na ser ka nti nkis nailepel. Apm nakimp yipm etetel, nio sepmel antuol karep nti nkamp wamire. Kuatiarel Wulapm Weink kakorokn yiki nio antuol nimpil yupulp nti sepm ware niokn kilelel nti apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kona yikn nkis nailepel, yikn ko niwes wule aiyiknel ");
INSERT INTO xbi_w_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","yupulp nti omoule kakorokn ser yoworel yikn ka nkis nailepel. Waiek aiyiknel ka ar nkuwepmel, kil sit ka aser aworelel. Niokn sepmel ka yikn apul ar nkuwepmel, waiek aiyiknel ka ar yemp ekeipmel karep anser. Kuatiar kil yupulp yikn sepm wamire”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisas naimpil nak na, “Yapmonemp aiyipmel kakorokn yer sukn yentemp sinsi kitapmel. Apulp yipm kona mper sinsi mitinkelel, nti kakorokn yer sepmelel. Kuatiarel eneipm kileko yenkei, wotekwutnu wanker, mi nti omoule wornketeel na semp. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yapmonemp aiyipmel kako yer sukn yentemp Wulapm Weink ka ar yemp ekeipmelel, nako yipm yer sepmel yopmoiel. Yapmonemp sopilelel ka nuarep sinsi sepmel ka yipm mper waleiel, eneipm kakorokn yekei, wotekwutnu kakorokn waker, et nti omoule wornketeel kakorokn semp. Sinsi mimi ka yikn apulpel ka ntikiremp nti eikusukn apulp yapmonemp aiyiknel. Wulapm Weink ka ar niorknel mi sinsi kitapmel ka ar niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sinsi mimi ka yikn apulpel ka ntikiremp nti eikusukn apulp yapmonemp aiyiknel. Wulapm Weink ka ar niorknel mi sinsi kitapmel ka ar niorknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Kona yikn niampepmantup Wulapm Weink aninkaninkel, yapmonemp aiyiknel ko yer yentempil nako yupul niampepm aiyiknel na yer nuarep yeteel. Yapmonemp aiyiknel ntokilelel kako mpilil nako yikn ser yoworel sankminamp eikusukn aiyiknel ka yikn ankil nkisel. Aser kona yapmonemp aiyiknel ka ar peikelel, ka nuarep yikn ka etn yemp nimpiempel. Yete karokn, ko yikn ser yoworel yapmonemp sankminamp aiyiknel ankil. Yikn kako nkis kuko yupulp. Kakilpe, kona yete Wulapm Weinkel ka ar yapmonemp aiyiknel nunkurkel, yapmonemp aiyiknel kako nuarep wunoump marnk. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisas naimpil nak na, “Kona omoule amamp wie nikimp yipm sank yatyatel nako yikn yupul sopel, yikn kakorokn sop sank wieel anink lekekn. Karokn. Et sank lekekn yikn ko yupul sop, sank yatel yikn ko yekei opmoump eik wapel. Omoule amamp lekekn ko yer niorkn aser omoule amamp yatel ko yer nkien. Ntiwie kakorokn yer soplekekn yer yapmonempel. Ka muati apulp yapmonemp omouleel kakorokn yer wieel. Kona Wulapm Weink yer niorkn yer yapmonempel, wuntokn araiel irpm ko yer nkien. Wulapm Weink antempel wuntokn araiel, ntiwie kakorokn yer sukn soplekekn yer yapmonemp aiyiknel. Karokn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas naimpil nak na, “Et apm'a nikimp yipm, yipm korokn yapmonemp mitimitink yupulp nionkopmilmp aiyipmel na mper miepm ko yer niorkn yer yapmonemp aiyipmel. Miepm sit kakorokn yupul yipm nako yer sepmel. Et yipm korokn numpul yupulp wule entieaikn aiyipmel na nek na, Sinsi mimi ko an rap sukurp omouleel? Wule entieaikn aiyipmel ka sinsi suknel ar niampepm Wulapm Weinkel. Wapm irpm ka sinsi akopitekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yipm ka numpul apulp miepm irpm wapm aiyipmel. Kona ntokilelel, yipm ser nti aipm. Nti karokn apul niokn mputnank, aiye si wot, mper ar yetne mpawuel. Aser waiek aiyipmel ka ar yemp ekeipmel ka ok nti miepm lowurkopm mitinkel al. Aser yipm omoule ka sukn ar niampepm Wulapm Weinkel, yipm ka saminkuork nti aipm nako kil yupulp yipm sukn. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kona yipm numpul ntokilelel, kakorokn yupul yipm na yer sepmelel, kakorokn ukuap nioknwank aiyipmel nako sukn mitink. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Et yipm korokn numpul yupulp wapm irpm sinsi ntokilelel. Nti sunsu wurunel ka muati ko yuwap yipmel. Nti ka nkis eik nonoel, aser nti ka lekeknip. Nti karokn apul ntinkiliemp awomp wapm antuol nti na rapel. Karokn. Aser Wulapm Weink ankil ka apul nti ka ar lekeknip. Nti sunsu mparankel sepmel kilelel ka samunkuork wapm omoule amamp Solomonel ka yapelip. Nti sunsu antempel mpuas ka ar awun lekekn sit, niatel nti omoule kako yuntun nti mus yete. Nti ar akopitekn sit, aser Wulapm Weink apulp nti akosepm yatip. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yipm omoule ka numpul apulp sinsi nkan kitapmel ntokilelel, yapmonemp aiyipmel ka wank. Yipm karokn aser ntinkirai yapmonemp nkan Wulapm Weinkel. Kona kil ka apul nti sunsu sepmel, kil kako yupulp yipm sepm sankuork nti sunsuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yipm korokn nek na, An'a yel mi? Wapm miel an'a rapel? na numpul yupulp. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nti omoule ka ar eikrieknel nti karokn ntinkirai apulp Wulapm Weink, et nti ka awup ninkemp sinsi irpm ntokilelel. Aser waiek aiyipmel ka ar yemp ekeipmel, kil karep anser sinsi irpm ka yipm karoknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Niokn suknel yipm ko yupulel, ka ntokeiye. Et yipm ko semp Wulapm Weink nako mper kil na yer niorknel yer yipm yapmonemp sop omoule amamp aiyipmel, ko yipm eipm sank ankilel yupul sop, nako yipm nkis minamp sepmel. Kona yipm yupul ntokilelel, Waiek Ekeipmel ko yumuk yipm miepm irpm wapm ka yipm numpul apulpel. ");
INSERT INTO xbi_w_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Et yipm korokn wonempwaiyimp sinsi mimi ko ninkemp yipm ankaiel. Wankepm awun keielel sitel ko yipm wonempwamiyimp. Aser wankepm mi ankaiel ko yirip ankai. Yipm kakorokn semp yupul yer awun kipelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","“Wulapm Weink ko yuntunel yikn sop aiyapel ka yikn ankil nakerpmel. Kona yikn semp sank wankepmel mperp emelel yupul nio ankilel ko yo kitapmel, Wulapm Weink kileko yuntunel yikn soplekekn. Yapmonemp aiyiknel ka yikn aimpel apulp nti omoule yatelel, kako yapmonemp soplekekn ka Wulapm Weink nimpil yekei yupulp yikn. Kakilpe kona yikn upuikn na Wulapm Weink korokn yuntunel yikn kuoretel, et yikn korokn semp sank wankepmel mperp omouleel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yipm ka apul nuarep sank muati keielel. Ka yikn aser krak akopitekn ar niampepm mamintoump aiyiknelel aser yikn karokn wonempwaiyimp nimpilie suknel ka sil niampepm aiyiknelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Apulntoku! Kona nimpilie kilpe sil niampepm aiyiknel arel, et apulntoku yikn ko nikimp mamintoump aiyiknel na, Mamintoump, apm'a ye krak ka ar niampepm aiyiknelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yikn ka omoule sank mpulmpulel. Sukur, ko yikn ye nimpilie ka ar niampepm aiyiknelel, niatel ko yikn ser ntinkirai na ye krak ka ar niampepm nkan mamintoump aiyiknelel. Sank muati keielel ka ntikiremp yikn apulp sank wankepmel ka yikn korokn pelpelk mperp emelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sank muati yatel ka sopeiye. Kona yikn yupul sank yapmonemp sepmel Wulapm Weinkel na nikimp nti omoule ka nuarep nti niumpua kuoretel, et nti kako sop minamp niumpuael, kako nimpil nimpilempel na yumump yikn. Karokn sepm. Muati yatel keielel ka niupukn soplekekn. Yipm korokn watemp alpan sepmel aiyipmel sil kitapm yok nti wurokn yanker. Nti karokn nimpiriepm apulp sinsi mi ka sepmel, et nti kako akaik ntemp yumu kitapm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisas naimpil nak na, “Kona yipm yimp Wulapm Weinkel, kileko kil yumpulp yipm. Kona yipm yuwup mimiel, kileko yipm niminkemp. Kona yipm yawol onto kionkuol yetne tukuaknel, Wulapm Weink kako sinkinip yipm yetne. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ka apulp aiyimp irpm ka nti eikusuknel yimp Wulapm Weinkel, kil kileko yupulp nti. Aser mimiel ka nti awupel, nti kileko niminkemp. Aser omoule mini ka yawol onto ankilel kankuol yetne tukuaknel kileko warel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka ntokilelel. Kona ninkilapm akopitekn aiyipmel aiyimp waiek ankilel na yok kil luwu ninker yelel, waiek ankilel kakorokn yok kil wuntokn niulu yel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nako ninkilapmel yimp waiek ankilel na yok kil oyokn yelel, waiek ankilel kakorokn yok kil saklok maninik yel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yipm waiek antuol ninkilapmel, yipm ka nkis minamp kuoretel sitel. Aser yipm ka ntinkirai apulp sinsi mi ka sepmel na yok ninkilapm aiyipmel. Kona ntokilelel, et yipm kako ntinkirai yumpulp Waiek Ekeipmel, kil kako yupulp yipm soplekekn. Kil ka mpuaimpuai na yok yipm setelel sepmel ka yipm aiyimpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kakilpe kona yipm upuikn na nti omoule ko yupul yipm sepmel, et niorknel yipm ko yupul nti sepm soplekekn. Sank keielel ka weink apulp sank salpikninel Wulapm Weinkel eikusuknel antempel sank eikusukn ka nti nakaworp yapmonemp Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jisas nak na, “Loump tukuakn ka wie. Lekekn ka suknel aser lekekn ka akopitekn yiyael. Aiyapel ka la yemp kuoretel ko nti omoule yer kuoret aninkaninkel, aiyapel kilelel ka sukn na yetnel. Loump tukuakn ankilel ka sukn mpuntierel et nti mitimitink kako sop aiyapel kilelel na war yer yemp kuoretel. Aser loump tukuakn yatel ka war yemp sepmelel ka akopitekn eik yiyael. Aiyapel ankilel ka ntinkiliemp. Nti omoule kana war loump tukuakn ankilel ka lekekn wie sitel. Et yipm ankil kako war loump tukuakn yiyael kile”. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas naimpil nak na, “Yipm ko nkis niampepm ntanku yupulp nti omoule ninkaielel, nti na eik nek yoworpel sank Wulapm Weinkel. Nti nak sank aikn ka sepmel apulp na ukuap yipmel, aser sank yapmonemp antuol kana yupul yipm milminel. Nti ka nor wulienk mimper, apul marknimp mila nankimp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Et yipm ko yekei wonempel. Minamp antuol kako ntikiremp yipm ntinkirai nti ka omoule ntomiel. Ka sop sank muati keielel. Kona yikn'a yuwup wurkopm ka niunkunel na yelel, yipm korokn yuwup yer mpuas yenkel. Karokn. Et kona yipm upuikn na yel waiel, yipm korokn yuwup yer yemp ainkel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lo sepmel eikusukn, ka wurkopm sepmel nakerel. Aser lo kuoretel, ka wurkopm kuoretel nakerel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo sepmel, wurkopm kuoretel kakorokn neker. Aser lo kuoretel, wurkopm sepmel kakorokn neker. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kona lo akosepmel karokn naker wurkopm sepmel, nti kako mpuar wat mila yete. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Et kakilpe, yipm ko ser sankminamp antuol nako yipm nkiemp ntinkirai nti ka omoule ntomiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nti omoule mpurel ka akei wule eikrieknel, nti ka eik aiyimp nio apmelel aninkanink nak na, Yikn ka Sepmel apmelel. Aser nti kakorokn war yemp sepmel na yer onto Wulapm Weinkel. Karokn. Wulapm Weink ka awup nti omoule ka eipm sank ankilel apul sopel, nti sit kako war nako yentempil yer yemp sepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anink nkienel, kona yipm yetn niampepm Wulapm Weinkel ko kil yuntunel yipmel, awun kilelel nti ementitmuaken mitinkel kako nikimp apm na, Sepmel, Sepmel, an ka akei nio aiyiknel nakaworp yapmonemp Wulapm Weinkel, an akei nio aiyiknel nker nti muanumpuor yanker, an akei nio aiyiknel apul niokn mintenkel sukn mitinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aser awun kilelel apm kako nikimp nti nek na, Apm ka akei wieel yipm. Yipm ka eik akei nio apmelel kuserelel apul nioknel. Et yipm nisip apm na mila kuor”. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisas naimpil nak na, “Omoule mini ka eipm sank apmelel apul sopel, kil ka nuarep omoule nimpiriepmel ka apul yetne ankilel sil wuntokn ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Etnie ntampel yir amu kitapm, upukn isil amu, wolpm mimpien nkarpmop salpiknin sa yetne ankilel. Aser yetne karokn nukuor, ka apulp wuntokn ka aimpop wulael ka wamiremp. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aser omoule mini karokn eipm sank apmelel na nekerpmel, kil ka nuarep omoule ka yapmonemp nilapmel ka apul yetne ankilel sil kitapm irpmirpm. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Etnie ntampel ka yir amu kitapm, upukn isil amu, wolpm mimpien nkarpmop salpiknin sa yetne. Aser yetne ankilel ka atit kuoretimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas karep napmok sank kilelel, nti omoule ementitmuaken eikusuknel ka nkarp eik utnumpulel apulp sank ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sank ankilel karokn nuarep sank antuol nti omoule wupm araielel ka yuwap nti sank salpikninel Wulapm Weinkel nakel. Karokn. Kil ka yuwap nti sop omoule suknel ka mpunti silel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas awemp malenk o kitapm, aser nti ementitmuaken mitinkel sopil mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Omoule lekekn ka wule ninkirmp apul kilel la aser Jisas, waker akaikyuwump eip kitapm apulp Jisas, nakimpil na, “Sepmel, wule ninkirmp ka apul apm wule wankepm yatip. Kona yikn upuiknel, yikn ko yupulp apm wule ninkirmp na miniat, nako wule apmelel nimpil ntinkirai yer niampepm Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas aki onto wul omoule kilelel nakimpil na, “Apm upuikn. Ko yikn yer ntinkirai”. Karokn walil wule ninkirmp ankilel ka miniat, epe wule ankilel ka naimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas nakimpil na, “Et yikn eipm. Yikn korokn la sinkir nikimp emel lekekn yupulp niokn kipe apm apulp yiknel. Karokn. Sukur, ko yikn la yetne suknel Wulapm Weinkel nako yikn ser pris ntikirempil entieaikn aiyiknel, ko kil ser aipopel yupulp wule ninkirmp aiyiknel ka miniat. Yikn ko mper oumpiepm aiyiknel sop sank salpikninel ka kumpueik Moses nakimp yipmel, nako nti omoule ser yoworel nana wule ninkirmp aiyiknel ka miniat”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas etn mila yemp suknel Kaperneam, aser omouleel ka omoule amamp antuol nti 100 omoule napolel Romel, kil la markipninket Jisas nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sepmel, omoule nioknel apmelel ka arip amamp wule suknel ar yetneel, ontoakaik ankilel ka awur matoimp aser wule kil ka yakop yatip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas nakimpil na, “Et apm la yupulpil wule ko sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Aser omoule amamp nakimpil na, “Sepmel, yikn ka omoule mpunti silel. Apm karokn omoule akosepmel ko yikn war yetne apmelel. Yikn yepei keiye, nek sank nker wule ankilel ko kil nimpil sepmimp. Mpunti aiyiknel ka sukn yatip. Omouleel ka mpunti silel sop yiknel, kil ko nek sank miel nako nti eipm yupul sop. Niokn apmelel ka soplekekn. Kona omoule amamp apmelel nikimp apm sankel, et apm'a yupul. Kona apm nikimp omoule napolel apmelel na kil ko mila kuor, et kil ko yopmon. Kona apm nikimp emelel antuol yupulp kil na la keielel, et kil kako mila. Kona apm nikimp omoule nioknel apmelel na, Yikn yupul niokn keielel, et kil ko yupul niokn sop karep apm nakimpilel. Aiyimp apmelel ka apm nakimp yiknel, et yikn kako yupul soplekekn nek sank sitel na omoule nioknel apmelel ko nimpil sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas ka yapmonemp pupurur apulp sank omoule kilelel nakel, ka sank akosepm, ka wat amu ntunk. Kil nakimp nti omoule ka sopilel na, “Apm nakimp yipm etet, apm karokn aser ninkemp omoule lekekn Israelel ka aimp yapmonemp sepmel, ka yapmonemp mintenk apulp apmel sop omoule Romel kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Apm nakimp yipm etet, kuatiar nkienel kona Wulapm Weink yetn yapel na yuwulmp kitapm sukurelel, nti omoule mitinkel ar kitapm wampwamp sukurel, kona nti yump yapmonemp sepmel sop omoule keielel, kuatiar nkienel nti kako war yemp ekeipmel yel miepm yentemp nti manmakn antelel Abraham, Aisak nti Jekop. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aser nti ntitmuaken Israelel ka kumpueik Wulapm Weink yuwak nti na yer yentempil yer onto ankilel aninkaninkel, kil ko nker nti yawol nti yo yemp eikrieknel, ka yemp nimpiempel, apulp nti karokn aimp yapmonemp sepmel sopilelel. Nti kako so nimpi kuoretel wonemnimirik wule, nayinku nantip yupulp yakop ko yupul nti yer yemp kuorelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Niatel Jisas naimpil nakimp omoule amamp kilpelel na, “Et yikn yopmon. Yikn ka yapmonemp mintenk apulp Wulapm Weink ko yupul omoule nioknel aiyiknel nako nimpil sepmimp. Kakilpe Wulapm Weink ko yupul sop yapmonemp aiyiknel”. Et kakilpe omoule nioknel ankilel ka naimpil sepmimp ar awun muati soplekekn ka Jisas nak sankel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas war yetne Pitael, kil aser yanokno Pitael ka ar niumpu ar waiminink. Wule ntinkiliemp apul kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas ontoapul kil, aser wule kil naimpil selmpenkimp. Kil nkarp asin miepm apulp Jisas na yelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Niunkuriknel nti apul nti ementitmuaken mitinkel ka muanumpuor yanker ar ntiel, apul nti mila ser Jisas. Kil nak nker nti muanumpuor salpikninel, et nti ka naimpil apmon. Nti omoule eikusukn ka wule apul ntiel, kil naimpil apul nti sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kil apul sopilelel ka sop sank ka kumpueik naikul miepm Aisaiael, kil ka omoule kumpueikel ka nakaworp yapmonemp Wulapm Weinkel. Kil nak na, Kil ankil arkuos wankepm irpm antelel, wulenip antelel ka kil apul na miniat. (Aisaia 53:4). ");
INSERT INTO xbi_w_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas aser nti omoule mitinkel etn yininkempil, aser kil nakimp nti omoule ka sopilel na, “Antarko yuntun mpepwarmp na mila eik yakitie”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Omoule wupm araiel nakimp Jisas na, “Sepmel, yemp eikusukn ka yikn etnel apm'a yentemp yikn yetn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas nakimpil na, “Nti aiemptuwun ka ar pierkepm antuol ar kitapm, et nti aipm ka ar wapm antuol sil lo keipm. Aser apm Es Aiyipmel, yetne apmelel karokn ko apm yer niumpuel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Omoule yatel kil ka antemp nti omoule ka nakerpm Jisasel, kil nakimp Jisas nak na, “Sepmel, apm'a yimp yikn. Apm'a la yemp apmelel yuntup waiek apmelel niorkn, ko niatel apm ko nimpil lael nako apm yentemp yikn yopmon. Ko akosepm o karokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aser Jisas naimpil nankimpil na, “Yewempyerkor. Nti omoule uknuampel kako wuntu mpruwaselimp, nti kako yuntup nti omoule antuol ka wuntuel. Aser yikn ankil, yikn la sop apm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas yukur no wutumpepel, et nti omoule ka sopilel yukur no antempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nti la mpepwarmp nimuonel, aser wolpm suknel eik nkarpel, ka apul mpepwarmp atit nkernkerelimp, aworawulmp wutumpepel. Aser Jisas ka ar niumpu wuntuimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nti la kisir kil, markipninket kil nak na, “Sepmel, yikn serp, wonempyupulp an! An keiye na wuntuimp!” ");
INSERT INTO xbi_w_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kil naimpil nakimp nti na, “Yapmonemp aiyipmel ka wank, karokn mintenk. Yipm ka nkinkiekn apulpi?” Niatel, kil nakantup wolpm antempel mpep, aser wolpm kakir miniat, mpep ka timpilimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nti ka nkark eik nintipmel nak na, “Kil ka omoule miel na wolpm antempel mpep eipm kil sankel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ninink nternkiepm Gadarael ka eik yakitie mpepwarmp Galiliel. Nti omoule wie ka muanumpuor yanker apul ntiwieel, nti ka eik yemp ntopmuanel niminkemp Jisas. Ntiwie ka kuko nkernkerelip. Sopilelel, nti ementitmuaken ka nkinkiekn apulp ntiwie, et nti nkarkemp na yetn aiyapel kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ntiwie awor ma salpiknin nak na, “Ai! Ninkilapm Wulapm Weinkel! Yikn na yupul an ntoku? Yikn na yok an yakop niorkn, a? Keielel karokn awun aiyiknel ka Wulapm Weink nak nako yikn yuntunel anel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nti nak sankel, aser nti wurokn mitinkel kurpe ar kuor, etn peik al miepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Et nti muanumpuor ma awor aiyimp Jisas na, “Et yikn kona nker anel, an na la war wurokn kurpelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas nakimp nti na, “Akosepm. Yipm yopmon”. Epe, nti muanumpuor awemp omoule wie nkark la muarep wurokn. Aser nti wurokn eikusukn nkark priparekel la tirientru kurkuan o antink amu mpepwarmp. Mpep waker mintanku antuol wuntuimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nti omoule ka arip wuroknel ka aser sopilelel, nti ka nkarpmok. Nti war yemp suknel nakimp nti ntitmuaken apulp sinsi mi ka ninkemp ntiel. Nti sukueimp nti apulp sinsi mi ka ninkemp nti omoule wieel ka kumpueik muanumpuor ar ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Et nti omoule ntitmuaken eikusukn eik yemp suknel lael na ser Jisas. Nti nak nker kil na, “Yikn yewemp kitapm antelel yer, et yikn yopmon”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas yukur no wutumpepel, kil eik yakitie mpepwarmp la yemp oumpyetne ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Omouleel ka ontoakaik awurel, nti ka nkampil arkuos kil sil lowaimp, apul kil la ser Jisas. Jisas aser nti ka yapmonemp menintenk apulp kil kana yupul omoule kilelel na nimpil sepmimp. Aser Jisas nakimp omoule kilelel ka wule apulel nak na, “Mamintoump, yapmonemp aiyiknel ko yer pipilakn. Karep apm nker yapmonemp kuoretel aiyiknel arnkomp yikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aser nti omoule wupm araiel, nti mpurel ka eipm kuoret sank keiye ka Jisas nakel, aser nti nakimp nti ankil na, “Omoule keiye ka nkamp yemp Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas ka ntinkirai apulp yapmonemp antuol, kil nak na, “Apulpi ka yipm aimp yapmonemp yakopel? ");
INSERT INTO xbi_w_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sank mi ka sarel ko apm nekel? Ko apm nek na, Yapmonemp kuoretel aiyiknel karep apm nker arnkomp yikn? Oroknel ko apm nek na, Yikn serp yetn la kitapm? Sank wieel kile ka soplekekn, karokn ntinkiliemp ko apm nekel kona apm yekei salpiknin apmelel yupulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aser apm apulp nako yipm ntinkirai yupulp mpunti apmelel, Es Nkan Ntitmuaken Eikusuknel. Apm ka salpiknin na nker yapmonemp kuoretel eikusuknel ar kitapmel”. Jisas nak ntokeiye, aser kil niampepm antup omoule ka ontoakaik awurel, nakimpil na, “Yikn nkierp, semp waiminink aiyiknel mila yetne aiyiknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kil nak sopilpe, karokn walil omoule kilelel ka nkarp mila yetne ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nti ntitmuaken aser ntokile, nti mimuaiyimp. Epe nti aki nio Wulapm Weinkel apulp kil mper mpunti suknel ntokilelel ar onto omouleel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas etn la aser omouleel, nio ankilel Matyu. Kil apul niokn ankilel ar yetne mpalmpalel, ka kil nkampop nti ntitmuaken Judael wuntoknel ok omoule suknel Romel. Jisas nakimpil na, “Yikn la sop apm”. Kakilpe, Matyu nkarp la sop Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas antemp nti omoule ka sopilel war nkis yetne Matyuel al miepm amintemp nti omoule mitinkel ka apul niokn soplekeknel antempel nti omoule yatel mpurel ka aimp yapmonemp kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kona nti Farisi aser Jisas nkis antemp nti omoule yapmonemp kuoretel ntokilelel, nti aiyimp nti omoule ka sop Jisasel na, “Apulpi na omoule amamp aiyipmel ka al miepm antemp nti omoule kuoretel irpm kuorelel ka nkampop an wuntoknel ok omoule suknel Romel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas eipm sank ka nti nakel aser kil nakimp nti sank loump nak na, “Omoule ka wule ntawu karokn apul kilel, kil kakorokn la ser omoule ka apul nti wule ntawu sepmel. Karokn. Nti omoule wule ntawuel sit kana la ser omoule kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yipm kako ser aipopel sank niupukn keielel ka sil wupm Wulapm Weinkel. Ka nak na, Upuikn apmelel ka sukn apulp yipm ko wonempyupulp nti eikusukn yupul nti sepm. Aser kona yipm karokn aimp yapmonemp sepmel ntokilelel, apm kako nkierkemp oumpiepm ka yipm eik wulel”. (Hosea 6:6) Jisas naimpil nak na, “Apm karokn la na yimp omoule ka nak na nti aimp yapmonemp sepmel. Karokn. Apm ka la apulp nti omoule ka aimp yapmonemp kuoretel ko nti nimpilemp yapmonemp na sop apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nti ka nkis nak sank aser, nti omoule mpurel ka sop Jon Baptaisel, nti la aser Jisas aiyimpil na, “An nampueipel nti Farisi ka nkis nailep apulp na wonempwaiyimp Wulapm Weinkel. Aser nti omoule ka sop yiknel, nti karokn apul sop an apulel. Ka apulpi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas nakimp nti sank loump nak na, “Kona omouleel na semp muakenel, ko nti entieyarkup ankilel nkis nailep yupulpilel? Karokn! Nti kako mpuaimpuai yupulp kil ka antemp nti arel. Aser kuatiarel kona omoule kile wuntuel, nti entieyarkup ankilel kako nkupmus nailep yupulp ka kil awemp ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Et sank muati lekekn, yipm kako wonempwaiyimp yupulp, ka sopeiye. Wapm arankel ka akuorel, ko yikn semp wapm otniompoiel yewomp nantip, orokn? Karokn. Kona yikn yupul ntokilelel, nako yikn sukul wapmel, mpep kako sapip wapm otniompoiel ka osoel ukuap wapm arankel ka nimirknel, nako yokuor suknelimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sank muati yatel ka sopeiye. Kona omouleel mper wusaikn arankel ka nti awomp ntoka yuko suknel antuol nti kana nimpirp mpep yoel, kil kakorokn nimpirp mpep wain otniompoiel yo wusaikn arankel ankilel kilpelel mper. Karokn. Kona mpep wain mimain yikiel, wusaikn arankel ka ninkerel kako yokuorel. Mpep wain kileko nukul miniat, nako yakulp yumu kitapm. Kil kakorokn yupul sopeiye. Kil ko nimpirp mpep wain otniompoiel ankilel yo wusaikn otniompoiel, ka mplulel. Kona mpep wain mimain yikiel, wusaikn ko ukuap suknel. Kona ntokilelel, mpep antempel wusaikn ko yer akosepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas nak sank antemp nti omoule ka sop Jonel, aser emesepmel la waker akaikyuwump eip kitapm ar nantip akaik Jisasel nak na, “Ninkilapm muaken apmelel ka karep amur. Yikn yiki onto aiyiknel wul kil nako kil nimpil serpmop”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Et Jisas nkarp sopil mila. Nti omoule ka sop Jisasel, ntiwarko ka etn antempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ntiwarko etn, aser muaken lekekn ninkemp ntiel, ka yarkup ankilel naikul 12-pla nioknwank sukurel. Kil la kitnan opmoump Jisasel, epe kil ontoukuap wapm yaiyi Jisasel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kil wonempwaiyimp na, “Et apm kona ontowul wapm Jisasel, ko yuntun yarkup apmelel nako apm nimpil sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kakilpe Jisas naimpilemp, niampepm amuntupil nak na, “Niaikno, niumpuaipm aiyiknel ko yer pipilakn. Et yikn ka naimpil sepmimp, apulp yapmonemp aiyiknel ka menintenk apulp apm”. Karokn walil, muaken kile ka naimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Niatel, Jisas etn la yetne emesepmelel, ka kil aser nti ementitmuaken ka so nimpi saiyip muanel, awop wulpm apulp ninkilapm awurel. Nti ka akei amampel apul yemp ka eik kukoel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aser Jisas nak nker nti na, “Et yipm yetn la peik. Ninkilapm muaken akopiteknel kilelel karokn awur. Karokn. Kil ka eik ar niumpuel”. Aser nti naminkeip Jisas apulp sank kilpe kil nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kil nker nti ementitmuaken eiksukn nainkul eikriekn niatel, ka kil naimpil war, ontowul muaken nionkioel onto, epe muaken ka naimpil nkarpmop. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nti omoule mitinkel ar kitapm kilelel opmueipm sank apulp niokn kile ka Jisas apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas awemp oumpyetne kilelel etn mila kuor, aser nti omoule wie ka niampepm kuoretelel, ntiwie sopil awor ma aiyimpil na, “Sepmel, Aknamniumpuai Devitel, yikn ko wonempyupulp antie!” ");
INSERT INTO xbi_w_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas etn la muar yetne, aser ntiwie ka niampepm kuoretel la aser kil. Kil amiyimp ntiwie na, “Yipmwie ka yapmonemp mintenk apulp apm'a yupul yipmwie niampepm nimpil sepmimp, arokn?” Aser ntiwie nakimpil na, “Ank, Sepmel. Antie ka yapmonemp mintenk apulp yikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kakilpe Jisas wul onto ankilel sil niampepm ntiwieel nakimp ntiwie nak na, “Yipmwie ka yapmonemp mintenk apulp apm. Kakilpe apm'a yupul sop sank yipmwie nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Et niampepm ntiwieel ka naimpil sepmimp. Aser Jisas nakimp ntiwie sank mintenkel nak na, “Niokn ka apm apulp yipmwieel, yipm korokn nikimp emel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aser ntiwie etn mila aser nti ementitmuaken ka ar kitapm keielelel, nakimp nti eikusukn apulp niokn sepmel ka Jisas apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nti omoule wie awemp Jisas etn mila kuor, aser nti ementitmuaken nkamp omoule lekekn ka muanumpuor yanker apul kil miepm nantipel, apul kil mila Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kakilpe Jisas nker muanumpuor aser, omoule ka miepm nantipel ka naimpil napmok sank. Et nti ementitmuaken ka yapmonemp pupurur nak na, “Ka niokn mintenkel yatelip! Kumpueikel an karokn aser sopilelel ar kitapm antelel Israelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aser nti Farisi napmok na, “Kil ka akei mintenk Satanel, ka omoule amamp antuol nti muanumpuor yankerel, na nker nti muanumpuor salpikninel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kil la aser nti eikusukn ar yemp oumpyetne sukn akoel, kil antemp ntiwarko ar pitekn, yuwap nti ar yonk Wulapm Weinkel antuol lekekn lekekn. Kil nakimp nti sank sepmel apulp Wulapm Weink na yuwulmp nti nako nti yentempil yer sepmel aninkaninkel. Kil nker wulenip ka apul nti omoule sepm kuoret naimpil apul nti eikusukn sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kona kil aser nti ementitmuaken sukn mitinkel, et kil ka wonempapulp nti yatip. Kil aser nti ka ar antemp yapmonemp wankepmel, mintenk antuol karokn sukn. Nti ka eik etn kukokukoel nuarep nti wus sipsip ka eik arel, omoule karokn wakerp ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kakilpe kil nakimp nti omoule ka sopilel nak na, “Nti omoule kile ka nuarep miepm mitinkel ka tikn ar niokn mputnankel. Aser nti omoule nioknel karokn mitink ko nti neik ye miepm kile. ");
INSERT INTO xbi_w_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aser yipm ko yimp Waiek Ekeipmel ka waiek niokn kilelel, ko kil niuwuwul nti omoule nioknel krasemp nti ntitmuaken kilelel, yikino yer lekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas aiyimp nti 12-pla omoule ka sopilel la, kil amuk nti salpiknin ampulp nti na nker muanumpuor yanker na yupul wulenip mimiel ka nkamp nti ementitmuakenel, nti kako nimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nio antuol 12-pla aposel ka Jisas niuwuwul nti etnel, nti ka ntokeiye: Saimon (nio kitie ankilel Pita) nampueip uknuan ankilel Andru; Jems nti Jon, ntiwie ka ninkilapm nkan Sepetiel; ");
INSERT INTO xbi_w_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Bartolomyu, Tomas; Matyu ka omoule ka nkamp nti Juda wuntoknel ok omoule suknel Romel; Jems, kil ka ninkilapm Alpiusel; ");
INSERT INTO xbi_w_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tadius antempel Saimon yatel, kil ka apei yakitie antuol Selotel; antempel Judas Iskariot, kil ka omoule kuatiar ko mper Jisas la onto antuol omoule kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas nakimp nti 12-pla omoule ankilel kana yetnel, nakimp nti na, Et yipm korokn la ser nti omoule eikrieknel karokn Judael. Et yipm korokn ser nti ka ar yemp suknel irpm antuol Samariael. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yipm ko la ser nti omoule ntitmuaken Israelel sit. Nti ka eik mproel numuarep nti wus sipsipel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yipm ko la nikimp nti yoworp, nek na, Wulapm Weink kana yuwulmp yipmel, kil ka kitnanimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yipm la ser nti omoule ka wulenip apul ntiel nako nimpil yupul nti sepmimp. Yipm ko yiki nti omoule ka wuntuel na nimpil nkierpel. Yipm yupulp nti ka wule ninkirmpel nako nti nimpil yer sukupel. Yipm kako nker nti muanumpuor yanker ka ar ntiel ko yernkomp nti”. Jisas nakimp nti na, “Wulenip mimi ka apul nti ementitmuakenel, ko yipm eik yupulp ntiel sop salpiknin ka apm eik ok yipmel. Yipm karokn akei wuntokn nkamp. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kona yipm yetn yekei wampwampel, yipm korokn nunkurk ntokurmpunk aiyipmel na yump wuntokn mprarel suknel akoel yentemp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yipm korokn rap wapm wie nisil yo lekekn. Yipm korokn rap loaikn akaikel, mpu yipm korokn ntitnei. Kuor yewemp. Yikn kona yetn wampwampel yupul niokn Wulapm Weinkel, miepm sinsi mimi kako nti ankil yok yikn apulp yikn ka omoule nioknel Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yipm kona yekei wampwampel, ko yipm yuwup omouleel ka ar nkis apul sankminamp sepmelel. Ko yipm yentemp omoule kilpelel yepei epe. Yipm yer yukueimp yipm ko yememp yemp kilpelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Et yipm kona war yetne ankilel, sukur ko yipm nikimpil na, Wulapm Weink kako yupul yikn sepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kona kil mpuaimpuai na semp yipm na yentempil yerel, sank sepmel karep yipm nakel ko yentempil yer neker wurkopm. Et koroknel, kuor yewemp. Sank sepmel aiyipmel kilelel ko yipm nirnkimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Et kona nti omoule antuol korokn eipm yipm sankel na semp yipm yupul war yetne antuolel, mpumpurukn kitapmel ka apul yipm akaikel, ko yipm asil ntinkirai muat, sop muati ka yemp kilpelel kako yipm nek yumuntun. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Apm nakimp yipm etetel, kuatiar kona Wulapm Weink yuntunel nti ementitmuakenel, wankepm kako ninkemp nti ementitmuaken yer yemp suknel kilelel kako suknelip, kako samunkuork wankepm suknel kako ninkemp nti ntitmuaken yemp suknel Sodom nampueip Gomorael, ka apulp kumpueik nti nkis yapmonemp sankminamp kuoretel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas nak na, “Apm'a niuwuwul yipm la yetn nimuon nimuon nti omoule kana sikirpyuntun yipm nuarep milmpel. Et yipm ko yekei wonempel, yekei wonempyapmel yupulp minamp yipm nkisel. Et yipm kakorokn yumpop nti yapmonemp kuoretel lekekn, ko yipm yump yapmonemp sepmel nkis minamp sepmel sitel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Et yipm ko nkis niampepm ntanku yekei wonempel yupulp nti omoule. Nti ko mper yipm la onto antuol omoule ka mpunti silel. Nti kuatiar yawol mo ntampli yipm yer yonk irpm antuol Wulapm Weinkel yupulp yipm ka sop apmel. Nti kako yentemintenk yipm, ukua yipm la yetn niampepm antuol omoule suknelel yentempel omoule amampel. Anink kilelel, ko yipm nikimp nti omoule ka mpunti silel kilpe nampueip nti omoule eikrieknel karokn Judael, yipm ko nikimp ntiwarko sank sepmel yupulp apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nti kona yupul yipm la nek sankel, et yipm korokn numpul yupulp sank mi yipm ko nekel. Anink kilelel ankil, Wulapm Weink ko yok yipm yapmonemp ankilel yupulp sank kana yipm nekel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sank kona yipm nekel, kakorokn yipm ankil nek. Karokn. Pirpm Wulapm Weinkel ankil ko yiki yapmonemp aiyipmel nepek. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Anink kilelel, omouleel mpurel kuatiar yumpop uknuan ankilel yapmonemp kuoretel mper kil la onto antuol omoule ka mpunti silel, apulp na nti ko yer uknuan ankilel wuntu. Aser nti waiek kuatiar yupulp nti ninkilapm antuol soplekekn. Nti ninkilapm antuol kuatiar yumpop nti waiekmantiek antuol yapmonemp kuoretel yentemp nti nkisemp wurun ninimpil. Nti ko nikimp nti omoule ka mpunti silel na yer waiekmantiek antuol wuntu. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nti omoule eikusukn kileko wonemp kuoret yupulp yipm, apulp ka yipm sop apmel, ka yipm akei nio apmelel apul nioknel. Aser kona yipm yekei nio apmelel yetn mintenkel lala kitapm kipe ko niatel, Wulapm Weink kako yupul yipm na yer sepmel yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kona nti ementitmuaken nkan yemp suknel lekekn yupul yipm kuoretel, yipm ko nkierk mila yemp suknel yatel, nako yipm yupul niokn apmelel yer kuorelel. Niokn apmelel yipm ko yupul yupul ntokilelel, aser yipm korokn yupul niat yer yemp suknel Israel eikusuknel nako apm pelpelk yo ntoka Es Aiyipmel Ementitmuakenel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Ninkilapmel kakorokn sankuork omoule wupm araiel ka yuwapilel. Aser kona kil yer soplekekn nuarep omoule ka yuwapilel sitel, ka akosepm. Et omouleel ka apul niokn kuserelel kakorokn sankuork omoule amamp nioknel ankilel. Aser kona kil yer soplekekn nuarep omoule amamp nioknel ankilel sitel, ka akosepm. Apm ka waiek aiyipmel, apm ka Sepmel aiyipmel. Kona yipm upuikn na sop apmel, nti kako yupulp yipm soplekekn sop nti apulp apmel. Kona nti yimp apm nio kuoretel Belsebul (ka nio kitie Satanel), et yipm omoule kuserel ka sop apmel ko yupulntoku? ");
INSERT INTO xbi_w_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas naimpil nak na, “Yipm korokn nkinkiekn yupulp nti omoule kana yupul yipm kuoretel. Apm nakimp yipm ntokilelel, ka apulp mimi ka ar nkuwepmel, kileyar ko ninink yapelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sank sepmel apm akei wankel nakimp yipmel, et yipm ko nek yoworp nikimp nti omoule eikusukn yer yemp yapelel. Apm nakimp yipm, sank ka yipm akei ntanku nkampel, yipm korokn nkuwepm yer yapmonemp aiyipmel. Ko yipm yetn yapel wat sank kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yipm korokn nkinkiekn yupulp nti omoule kuoretel na yer yipm wuntuel. Ka entieaikn aiyipmel sit ko nti yer wuntuel. Aser na, nti kakorokn yer pirpm aiyipmel wuntu. Karokn. Kakilpe, yipm ko nkinkiekn yupulp Wulapm Weink sit. Ka kil sitel ka salpiknin nako kil yupul entieaikn aiyipmel yentemp pirpm aiyipmel kako mproel yentempel yopmoi yemp yeteel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Apm'a sukueimp yipm sank muati apulp oyokn mpun, ko yipm ntinkirai yupulp yapmonemp Wulapm Weinkel apulp yipm omoule kitapmel. Yipm ka ntinkirai, nti omoule ka wat wuntokn lekekn nkamp oyokn mpun yitoump wie. Nti oyokn mpun ka akopitekn, aser Wulapm Weink, waiek aiyipmel, ka wonempaser nti oyokn kilelel. Oyokn mpun lekekn kakorokn eik wuntuel. Wulapm Weink aser kil niorkn. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Aser yipm, kona mamniol lekekn aiyipmel ko ninkriel, ka sinsi akopitepitekn aser kil ka ntinkirai ampulp. Wulapm Weink ka wakerp yipm, yipm ka ar niampepm ankilel sitel. Et kakilpe, yipm korokn numpul yupulp nti omoule na yumpyer yipmel. Karep Wulapm Weink anser. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas naimpil walimp sank nak na, “Omoule mini ka mpuaimpuai na nti eikusukn ko ser yoworel kil ka omoule ka sop apmel, kil karokn wule maiak apulp apmel, kuatiar apm korokn sirep nio ankilel yer niampepm Waiek apmelel ka ar yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aser omoule mini ka sirep nio apmelel ar niampepm antuol nti omouleel, kuatiar apm sirep nio ankilel yer niampepm waiek apmelel ka ar yemp sepmel nek na apm ka akei wieel omoule kilelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas nak na, “Apm karokn la na yupul yipm yer niluknunel, karokn. Apm ka la nuarep sakalel ko yowor nikile yipm na yer kitiekitieel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Apm kako yupul yipm ementitmuaken kako nkisemp wurun ninimpilel. Apm kako yupul omoule kako nkisemp kuoret yentemp waiek ankilel. Ninkilapm muakenel kako nopol nokuap yentemp mantiek ankilel yupulp apm. Apm kako weink na muakenel kako nkisemp kuoret yentemp yanokno ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Omouleel ka sop apmel, nti oupmweink ankilel ka ar yetne ankilel kako yentempil nkisemp wurun ninimpil. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Omoule mini ka upuikn apulp waiekmantiek ankilel niorknel, sop ka kil wonempsukurel apmel, yapmonemp ankilel ka wank. Kil kakorokn sop apm. Omoule mini ka upuikn apulp ninkilapm ntitmuaken ankilel niorknel sop ka kil wonempsukurel apmel, yapmonemp ankilel ka wank. Kil kakorokn sop apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Omoule mini na sop apmel, kil kako yorkuos wankepm irpm sop apm ko kuatiar yorkuos lonkuntonkel na wuntu silel. Oroknel, kil kakorokn sop apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kona omouleel wonempser sinsi kitapmel ankilel, wonempwaiyimp na sinsi kitapmel ankilel ko yupul kil na yer sepmelel, kil kileko mproel yentempel sinsi ankilel. Aser kona omouleel wonempsukurel sinsi kitapmel ankilel apulp kil na wonempwaiyimp apm niorknel, kil ko semp yapmonemp Wulapm Weinkel na yer sepmel yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jisas nak na, “Aninkel kona yipm yetn wampwampel yupul niokn apmelel, aser emelel ko ukua yipm war yetne ankilel na yok yipm miepm yelel, ka nuarep ka kil apulp apmel. Et kona kil yupulp apm sopilelel, ka kil apulp Wulapm Weink ankil ka niuwuwul apm oel. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Emelel kona mpuaimpuai yupulp niokn omouleel ka nakaworp yapmonemp Wulapm Weinkel apulel nako ukua kil war yetne ankilel na yok kil miepm yelel, kuatiar Wulapm Weink kako yupulp ntiwie soplekekn yer yemp ekeipmel. Et kona emelel ukua omoule war yetne ankilel na yok kil miepm yelel apulp kil aser akosepm minamp sepmel antempel yapmonemp sepmel ka kil nkisel, kuatiar Wulapm Weink ko yupulp ntiwie soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kona emelel nimpirp mpep tinam yukoel na yok omoule kuserel ka sop apmel na yelel, Wulapm Weink karep anser niokn sukn pitekn ka kil apulel. Kil kakorokn wonempsukurel omoule kilelel, kil kako yupulpil sepm ware”. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas karep nak yumuap nti 12-pla ka sopilel sank miniat, aser kil na mila yemp suknel irpm ka ar kitapm Galiliel na ninkimp yumuap nti ementitmuaken sank Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aser Jon Baptaisel ka nti mper kil ar yetne kuoretel eikipminel, kil opmueipm sank ampulp niokn irpm ka Jisas apulel. Kakilpe, kil niuwuwul nti omoule ka sopilel na la nser Jisas. Jon Baptaisel nakimp nti omoule ka sopilel na, ");
INSERT INTO xbi_w_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Yipm la nek niyipm Jisas ntokeiye nek na, Omoule Krais, ka Wulapm Weink nakimp an nako kil niuwuwul kil yo yuwulmp anel, ka yikn epe tikikn, a? Orokn kileyar kipmin?” ");
INSERT INTO xbi_w_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nti la aiyimp Jisas, aser Jisas naimpil nakimp nti nak na, “Yipm la nikimp Jon yupulp niokn irpm apmelel ka yipm eipm aserel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nti omoule niampepm tukulpmel, niampepm nti ka naimpil sepmimp. Nti omoule ka akaik kuoretel ka nkis kitapmel, nti ka naimpil apmon ekeipm. Nti omoule ka wule ninkirmp nkampel ka naimpil ntinkiraiyimp. Nti omoule ntanku kukoel, nti ka naimpil opmueipm sank. Nti omoule ka awurel, ka naimpil nkarpmop. Nti omoule eretakoel nti ka la eipm sank Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nti omoule minimini karokn yapmonemp mitimitink apulp apmel na yewemp apmel, nti kako mpuaimpuai. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nti omoule ka sop Jonel karep apmon, epe Jisas sunkueimp nti ementitmuaken sank ampulp Jon Baptaisel ka wat sank Wulapm Weinkel ar yemp kuserelel. Kil nak na, “Aninkel yipm ka la yemp kuserel kilpelel, et yipm kana ser sinsi mi? Yipm ka la aser wolpm ka yileip yakuel tikikn? ");
INSERT INTO xbi_w_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Orokn, et yipm kana la ser omouleel ka rap wapm sepm sepmelel? Arokn. Nti omoule ntokilelel ka ar yetne nkan omoule amampel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yipm kana lael, ka apulpi? Et yipm aser omoule ka nakaworp yapmonemp Wulapm Weinkel tikikn? Ka kil ankil. Apm nakimp yipm, Jon Baptaisel ka samunkuork nti omoule eikusukn ka kumpueik nakaworp yapmonemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yipm eipm, wupm suknel Wulapm Weinkel ka nak apulp Jon epe. Wulapm Weink ka nak na, Kuatiar apm niuwuwul omouleel na nikimp nti sank apmelel. Kil ko yetn niorkn, nikimp nti na nti ko ntimpramp yapmonemp, krak aiyapel yupulp Mesaia ko nininkel. (Malakai 3:1) ");
INSERT INTO xbi_w_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Apm nakimp yipm etetel apulp Jon Baptaisel, nio ankilel ka samunkuork nti omoule eikusukn nkan kitapm sukurel keielel. Aser na omoule kuserel minimini karep nimplemp yapmonemp war onto Wulapm Weinkel, kil ka sankuork Jon. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Eik Jon Baptaisel lala keielel, nti omoule sukn mitink ka akei salpiknin antuol ankil na war yemintemp Wulapm Weink apulp nako kil yuwulmp ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Sank salpikninel ka ar wupm Wulapm Weinkel antempel sank antuol nti omoule Wulapm Weinkel ka nakaworp yapmonemp ankilelel, ntiwarko ka nak soplekekn apulp Krais, omoule ka Wulapm Weink yuwakel. Nti nak na niorkn kako Elaija mila. Aser Jon nininkel, kil nkamump yemp Elaijael. Kona yipm yapmonemp lekekn yentemp sank kumpueik nti nakel, et yipm ko ser ntinkirai ka apm nakimp yipm etetel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Omoule ka ntanku arel, kil ko eipm sank keielel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Keielel apm'a nek yoworp sankminamp antuol nti ementitmuakenel, kuor apm yekei sank muati miel na nek yupulp ntiel? Nti ka sop nti ninkilapm mpurel ka nkis anuyapel aiyimp nti ninkilapm yatel ntiwarko na yupul prikupel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nti nak na, An ka awop wulpmel aser yipm karokn antemp an akei wampen. An wat warawur aser yipm karokn so nimpi”. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aser Jisas naimpil nak na, “Nti ementitmuaken kipelel ka nuarep nti ninkilapm kilelel apulel. Nti aser Jon lael, kil nkis nailep awemp miepm sepmel antemp mpep wain apulp kil na yupul niokn Wulapm Weinkel. Aser nti karokn mpuaimpuai apulpil, nti ka nak na muanumpuor apul kil ka aworokoel tikikn. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aser apm ka amu minsop Es Aiyipmel Eikusuknel, aninkanink apm akei kile akei kile al miepm irpm mpep wain. Nti aser apmel, nti karokn mpuaimpuai apulp apm, nti napmok na, Kil ka wurokn yanker sulupelip. Mpep wain ka kil al sukn, kilpe kil kukoel. Kona ntokilelel, nti emeniemp ankilel ka aimp yapmonemp kuoretel, mpurel antuol ka nkamp wuntokn antelel yok omoule amamp Romel. Nti nak an apulp niokn Wulapm Weinkel antie apulel, aser niokn antieel ka naker wurkopm sepmel soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisas apul niokn mintenkel mitinkel ar yemp suknel mpurel, aser nti karokn nisep sankminamp kuoretel antuol na nimpilemp yapmonemp. Karokn. Aser keielel Jisas nak nti miyep. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kil yu aki nak na, “Ai! Yipm ementitmuaken Korasinel antempel nti Betsaidael, wankepm kuoretel kuatiar ninkemp yipm yer onto Wulapm Weinkel. Yipm aser niokn mintenkel mitinkel, aser yipm karokn nimplemp yapmonemp. Kona apm la yupul niokn mintenkel ntikiremp nti yer yemp suknel kuoretel Tair yentempel Saidonel soplekekn ka karep yipm ankil aserel, nti kako nimimplemp yapmonemp, nimisep sankminamp kuoretel mitinkel antuol. Nti kako yekei yete kop yiri mpo, rap sinsi kuoretel nirkutupel yupulp nako nti eikusukn ser na nti ka nimplemp yapmonempel. Aser karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Apm nakimp yipm, kona Wulapm Weink yuntunel nti ementitmuaken eikusukn nkan kitapm keielel, wankepm kuatiar ko ninkemp yipmel kako suknelip, kako samunkuork wankepm kako ninkemp nti omoule Tair yentempel nti Saidonel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Et yipm Kaperneam, yipm'a yiki nio aiyipmel nemp ekeipm, tikikn? Yipm ka nak na yipm ko yer yemp ekeipmel. Kakorokn. Kuatiar Wulapm Weink yawol yipm yo yemp yeteel. Apm nakimp yipm, kona apm kumpueik la Sodom yupul niokn mintenkel soplekekn ka yipm aserel, yapmonemp kuoretel antuol ka sukn yatip aser nti korokn ninkemp wankepm sukn yer onto Wulapm Weinkel apulp nti kako nimimplemp yapmonemp. Yemp antuol kipe ko yer. Aser karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Apm nakimp yipm, kona Wulapm Weink yuntunel nti ementitmuakenel, wankepm kileko ninkemp yipmel kako suknelip, kako sankuork wankepm kako ninkemp nti omoule Sodomel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Aninkel kilpelel, Jisas nak na, “Waiek, yikn ka Sepmel antelel eikusuknel. Yikn ka awulmp yemp ekeipmel antempel kitapm sukurel. Waiek, apm nak naremp yikn apulp ka yikn karokn apul niokn aiyiknel ar niampepm antuol omoule wonempyapmel. Karokn. Ka nti omoule uknuampel yapmonemp antuol ka nuarep nti ninkilapmel, yikn ka ntikiremp nti na nti ka aser sank wonempyapm aiyiknel akuorpel. Ka yikn apul sop upuikn aiyiknel, ka akosepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aser Jisas naimpil nak na, “Waiek apmelel ka karep amuk apm amamp ntinkiraiel antemp salpiknin eikusukn ankilel. Ka kil sit ka aser yapmonemp nilmniumpuaipm apmelel. Aser apm sit ka aser nilmniumpuaipm ankilel. Apm ankil kako ntikiremp nti omoule yatel mpurel yokuorpel, nako nti ser yoworel nilmniumpuaipm nkan Waiek apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yipm omoule ka awup ntinkiliempel, arkuos wankepm suknel, yipm la ser apm. Et yipm ko yentemp apm yer, nkisemp sipmakn nako apm yumuk yipm mintenk. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sankminamp apmelel ka niumuaipm niluknunel. Apm karokn aki nio apmelel no ekeipm. Karokn. Apm kako ntikiremp yuwap yipm aiyapel nako apm ukua yipm na yentemp apm yupul nioknel. Kona ntokilelel, yipm kako nkis waleiyimp, yapmonemp pipilakn niluknunel sitel. ");
INSERT INTO xbi_w_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Niokn an kako yupul yentempel, yipm kakorokn ser ka tinkiliempel. Niokn apm kako yok yipmel, kako nkunto yipmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Awun Sapatel, Jisas ka ukua nti omoule ka sopilel, ntiwarko la etn niokn mputnank witel nimuon nimuon, aser nilmp ar nti, epe nti antun wit wurkopm aimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nti Farisi aser ntiel, nti nankimp Jisas nak na, “Yikn ser, kipe ka awun Sapat, ka an nakantup nti kakorokn yupul nioknel, aser nti omoule ka sop yiknel apul kuoret. Nti waker sank salpikninel apulp Sapatel, nti apul niokn antun wit wurkopm aimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aser Jisas naimpil nakimp nti na, “Kumpueikel Devit waker sank salpikninel Wulapm Weinkel, aser kil karokn apul kuoret. Sank keielel yipm karokn eipm, a? Sank ka ar wupm Wulapm Weinkel, ka nak apulp Devit antemp nti omoule ankilel ka ar nilmpel, ka kil apul mi? ");
INSERT INTO xbi_w_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit war yetne Wulapm Weinkel, nkuan luwu ninker ka nti wul apulp oumpiepmel, kil ukua nti omoule ankilel ok nti aimp. Luwu ninker keielel, ka nti nakantup nti omoule kuserel nti kakorokn yel. Ka nti pris sitel ko yel. Aser Devit karokn omoule pris, et kil ka antun sank keielel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Et sank yatel ka ar wupm Wulapm Weinkel ka nak apulp nti pris kako yupul niokn antuol yer yetne suknel Wulapm Weinkel yer awun Sapatel. Kona ntokilelel, aninkanink nti ka waker sank salpikninel apulp awun Sapatel. Aser nti karokn apul minamp kuoretel. Sank keielel ka yipm aser, arokn? ");
INSERT INTO xbi_w_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yapmonemp aiyipmel ka sukn apulp yetne Wulapm Weinkel, ka nkamp nio suknel ar niampepm aiyipmel. Aser ka apm nakimp yipm. Omouleel ka ar keielel, nio nkampilel ka samunkuork nio ka nkamp yetne Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sank ka sil wupm Wulapm Weinkel ka nak na, Apm karokn mpuaimpuai apulp oumpiepm ka yipm eik wulel. Niokn ka suknel ar niampepm apmelel ka ntokeiye. Yipm ko yekei nainkerp nti eikusukn, ko yipm wonempyupulp nti. (Hosea 6:6) Kona yipm ntinkirai yupulp sank keielelel, yipm korokn nek nti omoule ka akosepmel yupulp minamp antuol sop karep yipm nak ntiel. Nti karokn apul kuoret ar niampepm Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Apm, Es Nkan Ementitmuaken Eikusuknel, ka ar niorknel sinsi eikusuknel. Apm ka omoule amamp ka awulmp Sapatel. Et kakilpe, apm akei niampepm aser nti omoule apmelel ka antun wit wurkopm ar awun Sapatel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas awemp yemp kilpe apmoi, kil la niminink yemp suknel antuol muar yonk Wulapm Weinkel antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Omouleel ka nkis yonk Wulapm Weinkel, onto yakitie ankilel ka kuoret awurel. Nti omoule mpurel mperpmai Jisas aiyimpil na, “Awun keielel ka Sapat. Et an na yupul wulenip ka apul ntiel nimpil sepmimp, arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aser Jisas naimpil nakimp nti na, “Kona awun Sapatel nako wus sipsip nkan emelel aiyipmel yuwi yo elieel, et yipm kako ye kil, arokn? Ko yipm yumpul. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wus sipsip irpm ka sinsi akopitekn ar niampepm Wulapm Weinkel, aser yipm omoule ka sinsi suknel, ka sankuork wus sipsip. Yipm kako ye wus sipsip aiyiknel kilelel yer awun Sapatel, et kakilpe, awun Sapat ka awun akosepm nako an yupul nti omoule ka wulenip apul ntiel na nimpil sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Niatel kil nakimp omoule kilpe ka onto kuoretel nak na, “Et yikn sunu onto”. Kil nkunu onto ankilel, aser onto ankilel ka naimpil akosepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aser nti Farisi nkarp la akei wankel nak nkuwepm amup aiyapel apulp nti na yer Jisas wuntuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas ka ntinkirai apulp nti Farisi na yupul kil kuoretel. Kakilpe kil awemp yemp suknel kilpe apmoi, kil apmon. Aser nti ementitmuaken mitinkel ka sopil mila. Nti mpurel antuol ka wule apul ntiel, kil apul nti eikusukn naimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aser Jisas nakantup nti na nti korokn nikimp nti omoule wampwamp sank yupulp kil ka mini. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Keielel ka Jisas apul sop sank ka Wulapm Weink nak ar miepm nkan Aisaiael, omoule kumpueikel ka nakaworp yapmonemp Wulapm Weinkel. Ka kil nak ntokeiye, ");
INSERT INTO xbi_w_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Omoule keielel karep apm ankil yuwak kil apulp nako kil yupul niokn apmelel. Apm ka mpuaimpuai apulpil yatip. Kil ka niumpuaipm apmelel. Apm na la yok kil pirpm apmelel ko mintenkitneipil. Kil kako yekei sankminamp sepmel nek yitoumpel nako yuntunel nti omoule wampwampel ka ar kitapm sukurel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Et kil kona yetn aiyapelel, kil korokn nokuap sank yowor ma no ekeipm apulp na nti ementitmuaken na eipm kilel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nti omoule monienel karokn etn mintenkel, kil ko yupul nti niluknun. Nti ka nuarep yete ka ar pitekn kana nunkurkel, aser kil kakorokn yupul nti nukurk mpelknel. Kil ko yupulp nti lala ser sankminamp sepmel sitel kako yer yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nti omoule wampwampel, nti karokn entieyarkup Judael, nti kako niampepm tneipil. Nti ka yukueimpil, ko kil nantip mo yerkomp nti nako nti yer sepmelel. (Aisaia 42:1-4) ");
INSERT INTO xbi_w_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Awun kilpelel nti nkamp omouleel apul kil mila ser Jisas. Omoule kilpelel, ka muanumpuor yanker apul niampepm ankilel ka tukulpmelimp, apul kil na kil korokn nek sankel. Aser Jisas arnkoumpil, naimpil apul kil sepmimp. Kakilpe kil naimpil napmok sank, kil naimpil aser ntinkirai. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kona nti ementitmuaken eikusukn aserel, nti ka yapmonemp pupurur. Nti nak na, “Omoule kilpelel ka Krais, tikikn, ko an yimpil Aknamniumpuai Devitel, arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kona nti Farisi eipm sank kilelel nti ntitmuaken nakel, et nti nak na, “Omoule kilpelel ka akei salpiknin Belsebulel. Sopilelel ka kil nker nti muanumpuor yankerel irpm. (Nio kitie Belsebulel ka Satan, ka omoule amamp antuol muanumpuor yankerel.)” ");
INSERT INTO xbi_w_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aser Jisas karep anser yapmonemp antuol. Kil nakimp nti nak na, “Apm'a yimp yipm. Et yipm ka ntinkirai, nti omoule ntiwarko ka wakirpmtumpo lekeknel, kona nti nimpil yentemp nti ankil nkisempel, wakirpmtumpo antuol kakorokn yer mintenk. Aser kona nti omoule oupmweink lekekn na nopol yentemp nti ankil, nti kakorokn yetn mintenk. Aser kona nti omoule oumpyetne lekekn na nopol yentemp nti ankil, nti kakorokn yer sepm ");
INSERT INTO xbi_w_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka sank muati kako ntikiremp yipm, kona Satan nker nti muanumpuor yanker ankilel, kako soplekekn. Ka nuarep ntiwarko ka antemp nti ankil nkisempel. Mintenk ankilel ka kuserelimp, kil kana miniat. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yipm nakimp apmel, nak na apm ka akei salpiknin Satanel na nker muanumpuor yankerel. Apulntoku? Kona ntokilelel, nti omoule aiyipmel mpurel ka nti nker muanumpuor yanker irpmel soplekekn ka apm apulel. Et nti ka akei salpiknin Satanel apul niokn kilelel antuol soplekekn tikikn? Et yipm wonempwaiyimp ntontoku? Arokn! Kakilpe, nti ankil ko yuntunel yipm yupulp sank ka yipm nakimp apmel, ka sank kukoel, karokn etet. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kakilpe, kona salpiknin nkan Pirpm Wulapm Weinkel ok apm mintenk ka apm apul niokn kilelel, et yipm ko ser yoworel na Wulapm Weink karep la kitnan na yuwulmp yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Et apm'a sukueimp yipm sank muati yatel akopitekn apulp niokn ka apm apulel. Kona omouleel ka upuikn na waker yetne yupul wornketeel, et niorkn kil ko war yetne yekei wantienk kitip waiek nkan yetne kilpelel akaikonto yer wula yapel worpil miepm. Niatel, kil ko sumump sinsi irpm upuikn ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kona omouleel karokn antemp apm apul nioknel, karep kil antemp apm nkisempel. Omoule mini karokn sakirp apm na semp nti ementitmuakenel, kil ka nker nti ar lekekn lekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Kakilpe apm nakimp yipm, sank yapmonemp kuoretel mimi ka yikn apulel, kuatiar Wulapm Weink wonempsukurel yapmonemp kuoretel keielel aiyiknel. Aser kona yikn nek sank kuoret yupul nio apmelel, Es Nkan Ntitmuaken Eikusuknel, yumu kitapm, kuatiar Wulapm Weink ko eipm ser eik yewempel yapmonemp aiyiknel kilelel. Aser kona yikn nek sank kuoret yupul nio Pirpm Sepmel Wulapm Weinkel yumu kitapm, Wulapm Weink kakorokn wonempsukurel. Wankepm aiyiknel kako yer yopmoi yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas nak ntokeiye na, “Lo ka sepmelel, wurkopm ankilel ka naker sepm. Aser lo ka kuoretelel, wurkopm ankilel ka naker kuoret. Nti omoule ka aser lo wurkopm niorknel, kakilpe nti napmok, Lo keielel ka akosepm, aser lo kilpelel ka kuoret. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aser yipm ankil, yipm ka wusel niepel mankirpmel! Minamp aiyipmel ntokilelel ka ntikiremp an apulp yapmonemp kuoretel ka yipm aimpel ka suknelip. Kona ntokilelel, et yipm ko nek sank lekekn ka akosepmel yupulntoku? ");
INSERT INTO xbi_w_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omoule ka akosepmel, ka aimp yapmonemp sepmel mitinkel, sankminamp ankilel kil apulel kako sepm sepm sit. Aser omoule kuoretel ka aimp yapmonemp kuoretel mitinkel, sankminamp ankilel kil apulel kako kuoretel sitel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Apm nakimp yipm, kuatiar kona Wulapm Weink yuntunel yipmel, sank eiksukn lekekn lekekn ka yipm eik nakel, kil kako yimp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wulapm Weink ko yuntunel yipm yupulp sank yikn ka nakel, yipm ka omoule sepm mi kuoret”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nti omoule wupm araiel mpurel antempel nti Farisi mpurel nakimp Jisas nak na, “Sepmel, an upuikn apulp nako yikn yupul niokn mintenkel lekekn sop muatiel, ko ntikiremp an ka Wulapm Weink ok yikn mintenk apul nioknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aser Jisas nakimp nti na, “Aaa! Yipm ementitmuaken kipe arel, yipm ka kuoret. Yipm karokn yapmonemp lekekn antemp Wulapm Weink. Ka weink na yipm ka nak aninkanink na yipm'a ser niokn mintenkel nuarep muatiel. Aser karokn. Muati lekekn sit ko yipm serel, ka kumpueik ninkemp Jonael, omoule ka nakaworp yapmonemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Awun wielekekn wunoump wielekekn Jona ka ar oyokn wulinkoel. Kako soplekekn. Apm Es Ementitmuakenel, kuatiar nti yuntup apm yo kitapm nako apm yer awun wielekekn wunoump wielekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aninkel Wulapm Weink kona yuntunel nti ementitmuakenel, nti omoule Niniveel kuatiar yetn yemp yapelel nek yoworp yupulp sankminamp kuoretel aiyipmel yipm ementitmuaken Judael ka kipe nkisel. Nti ko nek na, Kumpueikel an Ninive ka ar eikriekn aser an ka eipm sank ka Jona nakimp anel, an ka nimimpilemp yapmonemp. Sankminamp kuoretel antelel an ka amemp. Et yipm ka kipe ar keielel, ka apulntoku? Omoule ka antemp yipm etn nakimp yipm sank Wulapm Weinkel, kil ka omoule suknelip ka samunkuork Jona. Aser yipm karokn eipm kil sank. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wulapm Weink kona yuntunel nti ementitmuakenel, muaken amamp nkan kitapm Sibael kako yetn yemp yapelel nek yoworp sankminamp kuoretel aiyipmel soplekekn. Kil ko nek yipm yupulp sank Wulapm Weinkel, ka yipm karokn eipm nakerpmel. Muaken amamp kilpelel, yemp ankilel ka peikip aser kil la eipm sank yapmonemp ntinkiraiel ka Solomon nakel. Apm nakimp yipm na omouleel ka antemp yipm ar keielel ka samunkuork Solomon, aser yipm karokn apul sop ka muaken amamp kilpe apulel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jisas naimpil nak na, “Kona muanumpuor yanker yewemp omoule naikulel, kil kako la yemp nkunkurarel yuwup yemp otniompoiel nako kil yer waleiel. Aser kona kil karokn ninkemp yemp otniompoiel kil ko yerel, aser karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kil nak sopeiye na, Et apm'a nimpil mila yemp apmelel ka kumpueik apm arel. Kil lael, et kil aser omoule kilelel karep kil awempilel, yapmonemp ankilel ka nuarep yetne kuserel ka nti nkankerempel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kakilpe kil naimpil la nkamp 7-pla muanumpuor yanker yatel, yapmonemp kuoretel antuol ka sankuork kilel. Nti eikusukn warep omoule kilpelel nkupmus. Nti kako yupul kil kuoret yatip. Omoule kilelel kako yer kuoret opmueik lekekn sankuork karepel. Ka muati apulp nti ementitmuaken kuoretel ka kipe nkisel, nti kako soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas nakimp nti ementitmuaken sank, aser mantiek ankilel nampueip nti uknuanuknuan ankilel la etn eikriekn na nek sank yemintempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Epe omouleel nankimp Jisas na, “Mantiek aiyiknel antempel nti uknuanuknuan aiyiknel kurpe etn eikriekn, nti kana yentemp yikn nek sankel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aser Jisas naimpil nakimp omoule kilpelel nak na, “Mini ka mantiek irpm uknuan apmelelel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kil niuknu yuwa nti omoule ka sopilel nak na, “Et yipm ser nti keielel ka sop apmel, nti ka mantiek apmelel antemp nti uknuanuknuan apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kona ementitmuaken minimini ka nakerpm upuikn nkan waiek apmelel ka ar yemp ekeipmelel, nti kilpelel ka mantiek, niaikno irpm mamintoump apmelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Awun kilpelel, Jisas nkarp eik yetne naikul eikrieknel. Kil la nkupmus mpepwarmp nternkiepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nti ementitmuaken eikusukn arko la anser kil. Kakilpe, Jisas la yukur no nsil wutumpepel ekeipm, nti ementitmuaken etn mpepwarmp nternkiepm, etn la nenk. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kil akei sank loump mitinkel nakimp nti. Kil nak sopeiye na, “Yipm eipm. Omouleel ka la yalip wurkopm ar niokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kil yalip lala, aser wurkopm mpurel ka nkis aiyapel. Karokn walil, nti aipm ka pelkel la nkamp apul la aimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aser wurkopm mpurel ka nkis yemp ka wuntokn marnk silel, kitapm ka eik kuawulel, karokn miritink. Walenk ka pelkel namp aser niamp ankilel karokn nkamp kitapm, ka o kutuwur wuntokn marnk. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kona awun akuorp nkampel, kil ka pelkel ninkerimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wurkopm mpurel ka nkis yemp ka mpuas yenkel nkisel. Ntiwie noel, aser mpuas yenkel ka pelkel no nianintolknel aworamulmp wurkopmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aser wurkopm mpurel ka nkis kitapm sepmel, wurkopm nanker. Mpurel naker 100, mpurel naker 60, mpurel naker 30. Kakilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yipm omoule ka ntanku ar yipmel, et yipm ko eipm sank kilelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Niatel, nti omoule ka sop Jisasel la aser kil aiyimpil na, “Apulntoku yikn akei sank loump irpm nakimp nti ementitmuakenel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kakilpe Jisas naimpil nakimp nti nak na, “Apm akei sank loump irpm nakimp ntiel apulp niupukn irpm ka kumpueik ar nkuwepmel. Apulp ka Wulapm Weink ntikiremp yipm ankil sank niupukn kilelel apulp aiyapel ka kil na yuwulmp nti omouleel. Aser nti ntitmuaken mitinkel, karokn. Apm karokn nakimp nti niupukn aworpel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Weink ankilel ka sopeiye. Kona omouleel yump yapmonemp sepmel ntinkiraiel, kuatiar Wulapm Weink kako yok kil yapmonemp sepmel sukn mitinkel yentemp. Yapmonemp ankilel kakorokn wank. Aser kona omouleel karokn nkamp ntinkirai aimp yapmonemp sepmelel, yapmonemp akopiteknel ka kil aimpel kako mproelimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kona ntokilelel, et yipm ko ser ntinkirai weink apulp kipe apm akei sank loump irpm nakimp ntiel. Niampepm antuol ka akosepm aser nti ka nuarep omoule niampepm tukulpmel. Ntanku antuol ka ntinkirai, aser nti ka nuarep omoule ntanku ka kukoel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nti ntitmuaken, kumpueikel Aisaia ka nak yapmonemp Wulapm Weinkel apulp nti sopeiye nak na, Yipm kako eipm sank Wulapm Weinkel aninkanink aser yipm kakorokn eipm nternter. Niampepm yipm kako eik serel sitel, aser yipm kakorokn ser niupukn etetel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nti ntitmuaken kilpelel, yapmonemp antuol ka oso yatip. Ntanku antuol ka nti muorp. Niampepm antuol ka nti muatipm, nti karokn aser aworel. Yapmonemp antuol karokn atitakuor apulp sank ka apm nakel ko nti nimpilemp yapmonemp antuol na yuwup apm nako apm nimpil yupul nti na yer sepmel. Karokn”. (Aisaia 6:9-10) ");
INSERT INTO xbi_w_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jisas nakimp nti omoule ka sopilel nak na, “Aser yipm, Wulapm Weink ka apul yipm sepm, niampepm ntanku aiyipmel ka akosepm ntinkiraiyimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Apm nakimp yipm etetelel, kumpueikel nti omoule ka nakaworp yapmonemp Wulapm Weinkel antemp nti omoule sepmel ka nakerpm sank Wulapm Weinkel, ntiwarko ka upuikn apulp na nti na ser sinsi ka yipm aserel. Aser karokn. Nti ka upuikn apulp na nti na eipm sank kilpe ka yipm eipmel. Aser ka nti karokn eipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aser Jisas naimpil nak na, “Kakilpe, yipm eipm sank weink sank loumpel karep apm nak apulp omoule ka yalip wurkopm ar niokn ankilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka ntokeiye. Kona nti omoule eipm sank sepmel apulp Wulapm Weink na yuwulmp nti yer onto ankilelel, aser nti karokn aimp ar yapmonemp, ka nuarep wurkopm ka nkis aiyapelel. Satan pelkel la nkamump sank ka Wulapm Weink na mper yer nti yapmonempel, kil nkamp apul apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wurkopm ka nkis yemp ka wuntokn marnk silel ka nkarp pitekn, aser niaramp ankilel karokn nkamp kitapm, kakilpe ka pelkel ninkerimp. Sank keielel ka muati apulp omouleel ka mpuaimpuai na eipm sank Wulapm Weinkel. Kil ka pelkel nkamp aimp apmoi yapmonemp. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aser karokn walil kil ka eipm na nti omoule na yupul kil kuoret yupulp sank Wulapm Weinkel kipe kil nkampel. Kakilpe kil ka pelkel nkark awemp sank Wulapm Weinkel apmoi. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kona omouleel eipm sank Wulapm Weinkel aimp ar yapmonempel, aser yapmonemp ankilel ka ar mitimitink apulp sinsi kitapmel, ka nuarep wurkopm ka nkis antemp mpuas yenkel. Kil ka apulp na mper wuntokn suknel yer onto ankilel. Et sinsi kitapmel keielel ka amulmp sank Wulapm Weinkel. Kil karokn apul sop, ka mproel apmoi yapmonemp ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kona omouleel eipm sank Wulapm Weinkel akuorpel aimp apmoi yapmonemp ankilel, epe kil apul sop sank ka kil eipmel, ka nuarep wurkopm ka nkis kitapm sepmel. Sankminamp ankilel kil apulel ka wurkopm aworel, mpurel ka naker 100, mpurel ka naker 60, mpurel ka naker 30”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas nak na, “Apm'a yowor sank loump nikimp yipm yupulp Wulapm Weink ka awulmp nti ka ar onto ankilelel. Ka nuarep sank muati keielel apm'a nekel. Omouleel ka ei wit ar niokn ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wunoumpel nti ementitmuaken eikusuknel ka apmoi niumpu, aser omoule ka antempil nkisempel mila. Kil la wunoump, yalip mpuas kuoretel ka nuarep witel ka ar nimiripm wit, niatel kil apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ar pitepitekn, wit kilpe no nantupmel, nti omoule ka apulpil nioknel aser mpuas kuoretel ka no nusuk amu wit. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Et nti la aser waiek nkan niokn kilpelel nakimpil na, Wa, auwe! Ka apulpi mpuas kuoretel kipe no nioknel? An ka nak nana yikn ka ei wit sitel. Aser karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aser kil nakimp nti na, Omouleel ka antemp apm nkisempel ka la yalip wurkopm mpuas kuoretel kile. Kakilpe nti omoule ka apulpil nioknel aiyimpil, Et yikn apulp an na la noroump mpuas kuoretel kurpelel wat? ");
INSERT INTO xbi_w_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aser kil nakimp nti nak na, Arokn, yewemp. Kona yipm noroump mpuas kuoretel, et yipm kako nomuroump wit yemintemp tikikn. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yipm ko yewemp ntiwie itnei la lekekn ser nti ko no nuntupmel, wurkopm kona osoel. Kuatiar apm nikimp nti omoule ko ra witel, niorknel ko nti noroump mpuas kuoretel, na yiki ekepmel itnei apulp na wus yeteel. Niatel ko nti noroump wit ko mper yopmoi yetne mpawu apmelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas naimpil nak na, “Apm'a yowor sank loump nikimp yipm yupulp Wulapm Weink na yer niorknel yuwulmp nti omouleel. Ka nuarep wurkopm mastet ka omouleel ei apmoi niokn ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wurkopm mastet karokn nuarep lowurkopm mpurel ka suknel. Karokn. Ka akopitepitekn. Aser kil na no suknel, ko no mpeikn plokplok, ko yuwulmp wonk mimi ka ar nioknel. Kil ka nkarp nuarep loel, et aipm mimi ko la yupul wapm antuol yer lo ntaknank irpm ankilel. Wulapm Weink kona yuwulmp nti omouleel, kako soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas nak na, “Apm'a nimpil yowor sank loump nikimp yipm yupulp Wulapm Weink kana yuwulmp nti omouleel ka nuarep sinsi akopitepitekn ka nti aiyimp yisel. Ka ntokeiye. Kona muakenel mper yis akopitekn yimpilemp yentemp luwu suknel, kako wawun luwu yiki suknimp. Nti omoule ka ar onto Wulapm Weinkel, nti kako yupul soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sank eikusukn kile Jisas nakimp nti ementitmuakenel, ka kil akei sank loump sitel nakimp nti. Kil karokn nakimp nti sank niupukn aworp. Karokn. Ka kil awor loump sitel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kumpueikel, omoule ka nakaworp yapmonemp Wulapm Weinkel nak na, Apm kako yekei sank loump sukueimp yipm yupulp yapmonemp irpm Wulapm Weinkel ka kumpueik ar nkuwepmel. Eik kitapm nimpiliek lala keielel ka kil karokn aiye niupukn nak yapelel. (Buk Song 78:2) Sank keielel ka kipe niminink, kipe Jisas apul nsop. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas awemp nti ementitmuaken nkupmus, kil kilpe muar yetne eikipmin. Aser nti omoule ka sopilel nti la amiyimpil, nak na, “An na yimp yikn, sank loump nkan mpuas kuoretel ka no nioknel, sank niupukn ankilel ka nak mi? Yikn sukueimp an sepmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas naimpil nakimp nti na, “Omoule ka ei witel ka apm, Es Nkan Ntitmuaken Eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Niokn ankilel ka muati apulp kitapm kipe an arel. Aser wit ka muati apulp nti ementitmuaken ka ar onto nkan Wulapm Weinkel, ka kil awulmp ntiel. Mpuas kuoretel ka muati apulp nti omoule ka ar onto nkan Satanel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Omoule wuroknel kilpe ka yalip mpuas kuoretel ka muati apulp Satan. Wit kona osoel nako nti omoule rael, ka muati apulp kitapm sukurel keielel ko niatel. Nti omoule ka apul nioknel ka muati apulp nti ensel Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mpuas kuoretel ka nti naroump as yeteel, ka muati apulp nti omoule ementitmuaken ka ar onto Satanel. Kona kitapm niatel, yete ko yel nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Apm Es Nkan Omoule Eikusuknel ko niuwuwul nti ensel ko krakemp yemp Wulapm Weinkel ka kil awulmpel. Nti ko nker nti omoule kuoretel kilpe kana ukuap nti omoule akosepmel nkan Wulapm Weinkel na yupul sankminamp kuoretel. Nti ko yawol nti omoule kuoretel kilpe mila yete suknel, ko nti nayinku senker kuankir mplielmpliel yer yete. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aser nti omoule nkan Wulapm Weinkel, sankminamp antuol ka akosepmel, nti kako yopmoi yemp sepmel. Mponiampepm antuol ko mulupmulaikn sop awun weink mperp noel. Yipm omoule ka ntanku ar yipmel, et yipm ko eipm sank keielel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas nak na, “Wulapm Weink kana yuwulmp yipmel nako yipm yer onto ankilel ka nuarep sank loump keielel ka nak apulp wuntokn araiel ka nti kitip wampel antup nkuwepm tnei kitapm. Omoule la niminkemp i, kil ka eik mpuaimpuaielip. Epe kil naimpil awulmp nkupmus, kil nanket uknuamp la amiyimp waiek kitapmel. Kil nkamp sinsi eikusukn ankilel akei nkamp wuntoknel. Niatel kil naimpil la wat wuntokn sukurel ankilel ok waiek kitapmel nkamp kitapm kilelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas naimpil nak na, “Sank loump yatel keielel ka nak apulp nti omoule kana yer onto Wulapm Weinkel nako kil yuwulmp ntiel. Ka ntokeiye. Omouleel ka awup yuwomampel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kil ninkemp yuwomampel ka yapelip. Epe kil naimpil nanket uknuamp, nkamp sinsi eikusukn ankilel akei nkamp wuntoknel. Niatel kil naimpil la wat wuntokn sukurel ankilel nkamp yuwomampel kilpe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas nak na, “Sank loump yatel ka ntokeiye. Kona Wulapm Weink yuwulmp nti ementitmuakenel, ka nuarep ntoknpuank ka nti omoule akei nkamp oyokn mimi ar mpepel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ntoknpuank nontipel, nti apul namp nenk nkis amuntunel. Oyokn kuoretel irpm nti nkampwat. Oyokn sepmel ka nti mimper wunink. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kitapm keielel kona niatel kako sopilelel. Nti ensel Wulapm Weinkel kileko yo ranimp nti omoule kuoretel ka ar antemp nti omoule akosepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nti ko nkiemp nti omoule kuoretel wat yo yemp yeteel. Nti omoule kilpe kileko kuankir mplielmpliel nayinku senkerel yopmoi yete kilpelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas aiyimp nti omoule ka sopilel nak na, “Et yipm ka ntinkirai apulp sank weink keielel tikikn?” Epe nti nakimpil na, “Ank”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kil nakimp nti na, “Kakilpe nti omoule wupm araiel minimini ka eipm sank Wulapm Weinkel apul sop naka semp ntinkirai yupulp aiyapel Wulapm Weink na yuwulmp nti ementitmuakenel, nti ka nuarep waiek nkan yetneel. Kil war yetne ankilel nkamp sinsi sepmel arankel ankilel nampueip sinsi sepmel otniompoiel ankilel ar loump nkunkun, kil nkamp apul nainkul”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jisas nakimp nti sank loump niatel, kil naimpil mila oumpyetne weink ankilel. Kil la war yonk Wulapm Weinkel antuol, nakimp nti ementitmuaken sank Wulapm Weinkel. Nti eipm sank kilpelel, nti ka yapmonemp yakopel, yapmonemp pupurur nak na, “Omoule kilelel ka nkamp yapmonemp sepmel ar ku? Kil nkamp salpiknin ar ku, kilpe kil apul niokn mintenkel sopilelel? ");
INSERT INTO xbi_w_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","An ka ntinkirai apulpil. Kil ka ninkilapm antelel. Waiek ankilel ka omoule antelel ka apul yetne irpmel, mantiek ankilel ka Maria. Jems, Josep, Saimon, nti Judas, ntiwarko ka uknuan ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nti niaikno ankilel ka kipe antemp an ar. Apulntoku na kil ka apul niokn irpm keielel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nti nak ntokilelel, nti karokn yapmonemp lekekn antempil. Aser Jisas naimpil nakimp nti na, “Omouleel ka nakaworp yapmonemp Wulapm Weinkel, ka nio nkampil apei wampwamp. Aser ar oumpyetne weink ankilel, nio karokn nkampil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kakilpe, Jisas karokn apul niokn mintenkel mitinkel ar oumpyetne ankilel, ka apulp nti karokn yapmonemp mintenk apulpil. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aninkel, Herot ka omoule amamp ka awulmp kitapm Galiliel, kil eipm sank ampulp niokn ka Jisas apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kil numpul apulp sank kilpe, nakimp nti omoule nioknel ankilel nak na, “Jisas kilelel ka Jon Baptaisel tikikn, ka naimpil nkarp ar yemp oumpel. Et kakilpe kil apul salpikninel sopilelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot nak ntokei, ka kil numpul apulp sank ka Jon nak apulp Herotel, ka Herot ar kil wuntu yepel. Ka sopeiye. Jon nak apulp karep kumpueikel Herot ka niyok Herodias, ka muaken Pilipel, ka uknuan Herotel, ka kil nkampil sop ka muaken ankilelel. Jon nakimp Herot na, “Karokn sepm kile ka yikn nkamp muaken kilelelel”. Sank kilelel ka weink Herot antemintenk Jon, kitipil ontoakaik, mper kil apmoi yetne kuoretel eikipmin. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot kana yer Jon wuntuimp aser kil nkinkiekn ampulp nti ntitmuaken apulp nti ka nak na Jon ka omoule sepm ka nakaworp yapmonemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aninkel nti omoule mpurel la antemp Herot al miepm mpuaimpuai antempil apulp nioknwank ankilel kumpueikel ka mantiek ankilel ra kilel. Nti al miepm nkisel, aser muaken nionkioel ka ninkilapm muaken Herodiasel la apul yempuamp apmoi niampepm antuol. Et Herot ka aser akosepm akaikmponk ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kil ka nak nuwarel nak na, “Sinsi mimi ka yikn apulpel, kona yikn yimp apmel ko apm yok yikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kakilpe Herodias, mantiek nkan muaken kilelel, amuk kil yapmonemp. Aser muaken nionkioel kilelel nankimp Herot na, “Apm upuikn apulp na yikn ko yuntun Jon Baptaisel amamp, ko yikn yump yo yuko, semp yupulp apm no”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot eipm sank kilpelel, kil ka yapmonemp wankepmel ankil. Aser kil wonempwamiyimp sank ka kil nak nuwarel ar niampepm antuol nti omoule ka antempil nkis al miepmel. Kil ka nkarkemp wule maiak kona kil korokn sop sank kil nakel, et kakilpe kil nakimp nti omoule aipmpienel na yupul sop karep muaken kilpelel nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kakilpe kil niuwuwul omouleel la yetne kuoretel nakimp nti omoule aipmpienel na nti ko yumuntun ourenk Jonel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Amamp ankilel ka nti aimp o yuko na yupulp muaken nionkioel mila. Muaken nionkioel kile nkampel, ka kil apul la ok mantiek ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Omoule oroupm Jonel ka nti omoule ka sopilel nkamp apul apmon amuntup. Nti antupil niatel, nti la nankimp Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas ka eipm sank ka nti ar Jon wuntuel, kil awemp yemp ka kil arel apmoi. Kil sil wutumpepel na mila yemp kuserel ka nti omoule karokn arel. Kil antemp nti omoule ka sopilel, ntiwarko sit la. Aser nti ntitmuaken eikusukn eipm aser Jisas na lael, et nti awemp yemp suknel antuol apmoi, nti la amupil. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kil ka sil wutumpepel la sil mpep eikriekn, kil yukur amu kitapm. Et kil anser nti ementitmuaken mitinkel karep apmoi, ka kil wonempampulp nti. Nti omoule antuol ka wule apul ntiel, kil apul wule antuol sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nti ar aser awuniunkuriknimp, epe nti omoule ka sop Jisasel la nankimpil nak na, “Keielel ka yemp kuserel, awun keiye na yumu kitapm. Et yikn nikimp nti yopmon, nako nti la oumpyetne kitnanel irpm, wat wuntokn yuwup miepm nti na yelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aser Jisas naimpil nakimp nti omoule ka sopilel nak na, “Ka nti na la yupulpi? Et yipm ankil yok nti miepm yel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aser nti naimpil nakimp Jisas na, “Apulntoku! Miepm keiye an apulel karokn mitink. Keiye ka luwu ninker ontokitielel nampueip oyokn wie sitel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aser Jisas nak na, “Et luwu ninker irpm oyokn kile, yipm semp yupulp apm la kei”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aser Jisas nakimp nti ementitmuaken nak na, “Et yipm nkis tapm”. Kil nkamp luwu ninker ontokitielel nampueip oyokn wie kilpe, kil niampepm antup namp ekeipm, nak naremp Wulapm Weink ampulp miepm. Epe kil waker luwu ninker nampueip oyokn kilpe amuk nti omoule ka sopilel, ka nti nkamp amuk nti omoule ementitmuaken aimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nti eikusukn al, aser nti ka wulinkoimp. Nti omoule ka sop Jisasel naimpil nkamp miepm wanki wanki ka nkisel, nti aimp o urmpunk ontokitie ontokitie krepitie wie. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nti ementitntit ka al miepmel ka 5,000. Nti muakenmuaken nampueip ninkilapm, nti karokn ware nti ka aripm. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas nakimp nti omoule ka sopilel nak na, “Yipm yukur no wutumpepel, yipm yuntun mpep la yakitie miniorkn. Apm ko yer kei pitepitekn”. Kil nakimp nti ementitmuaken, epe nti ka apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Niatel kil sit ka no malenk, kil na nek sank yemintemp Waiek Ekeipmel. Wunoump nimpiempel, kil ka ar malenk. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wutumpepel kilpe ka mila peik ar mpepwarmp nimuonel, aser wolpm no ale mpep ntamimpli wutumpepel ntolonk, apul wutumpepel ka eik ntimimpilel apmoi mpep nimuonel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pitepitekn na erienel, Jisas etn mila mpep ekeipm na la ser nti omoule ka sopilel, nti ka sil wutumpepel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nti aser Jisas ka nakerpm la mpep ekeipmel, et wule nti ka niukur, nti ka nkinkieknimp. Nti ka nak nana ka monsomielip. Nti nkark markikipim! ");
INSERT INTO xbi_w_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aser, karokn walil, Jisas nakimp nti na, “Yipm korokn nkierk, et yipm yetn mintenk. Keiye ka apm epe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aser Pita naimpil nakimpil na, “Sepmel, kona ka yiknel, et yikn nikimp apm, nako apm nekerpm la mpep ekeipm yetn ser yiknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aser Jisas naimpil nakimp Pita na, “Et yikn la”. Kakilpe Pita yukur eik wutumpepel o, kil etn mila mpep ekeipm, kil na mila ser Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kil etnel, aser wolpm no suknelimp. Kil nkinkiekn apulp wolpm, aser akaik kil yuwei amu mpep kipmin. Kil ma awor aiyimp Jisas nak na, “Sepmel, ontoyupul apm!” ");
INSERT INTO xbi_w_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Karokn walil, Jisas yuwei onto ampul Pita, nakimpil na, “Pita, yikn karokn akei apm nkael. Et yapmonemp aiyiknel kile ka wieel tikikn? Weink kilelel, ka weink mi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Epe ntiwie kilpe naimpil yukur no sil wutumpepel, aser karokn walil wolpm ka ntimpilimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nti omoule ka sil wutumpepel aser ntokilpe, nti waker akaik, aki nio Jisasel namp ekeipm, aser nti napmok, “Ka etetelel, yikn ka Ninkilapm Wulapm Weinkel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas antempel nti omoule ka sopilel, nti kilpe antun mpepwarmp mila eik yakitie yemp Genesaretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kona nti omoule Genesaretel aser amorel ka Jisas ankil, nti mper sank nakimp nti ementitmuaken ka ar oumpyetne eikusukn kitnan kitnanel. Nti kilpe ka nkamp nti ementitmuaken ka wulenip apul ntiel, apul nti mila aser kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Aser nti ka aiyimp Jisas menintenk nako kil mpuaimpuai yupulp nti omoule mini ka wule apul ntiel, nti kana ontoyupul wapm yaiyi ankilel. Aser nti ementitmuaken eikusuknel ka apul sopilpe, wulenip antuol ka miniat. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Awun keielel nti Farisi antemp nti omoule wupm araiel Judael mpurel, nti ka awemp Jerusalem la anser Jisas aiyimpil na, ");
INSERT INTO xbi_w_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Apulntoku na nti omoule ka sop yiknel nti ka waker sank antuol emesepmelel ka ar kumpueikelip, ka apulpi? “Nti karokn kaikul onto niorkn nako nti yel miepmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas naimpil aiyimp nti na, “Et apulntoku na yipm ka waker sank salpikninel ka kumpueik Wulapm Weink nakimp yipmel? Yipm ka walimp sank Wulapm Weinkel, mper niorknel sank yapmonemp antuol emesepmelel, ka apulpi? ");
INSERT INTO xbi_w_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wulapm Weink nak na, Yipm kako neremp waiekmantiek aiyipmel eipm sank antuol yupul nti sepm. (Kisim Bek 20:12) Wulapm Weink nak antempel na, Kona emelel aiyipmel tupualimp waiekmantiek ankilel nak sank kuoretel apulp ntiel, et kuatiar yipm ko yer kil ankil wuntu yepel. (Kisim Bek 21:17) ");
INSERT INTO xbi_w_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yipm ka sop yapmonemp manmakn aiyipmel sitel sopeielel. Yipm ka nakimp waiekmantiek aiyipmel na wuntokn yipm mper apulp na wakerp ntiel karep miniat. Ka apulp wuntokn kile yikn karep ok Wulapm Weink. Nti emesepmel aiyipmel ka nakimp yipm na ka yipm apul akosepm. Nti nak na yipm korokn numpul yupulp sank salpikninel Wulapm Weinkel ka nakimp yipm na neremp waiekmantiek aiyipmel yupul nti sepm, yewempyerkor. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Apulntoku! Ka kuoret! Sopilelel yipm ka waker sank salpikninel Wulapm Weinkel kana yer nuarep sinsi kuserelel. Wuntokn aiyipmel yipm karokn akei wakerp nti waiekmantiek aiyipmel apul nti sepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yipm ka akei wule eikrieknel nak sank ninkaielel! Kumpueikel, sank Wulapm Weinkel ka naikul miepm Aisaiael, kil ka nakaworp minamp aiyipmel ankil. Kil nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Wulapm Weink nak ntokeiye. Nti ementitmuaken keielel, nti akei miepm eikrieknel. Nti eik aki nio apmelelel, aser yapmonemp nilmpniumpuaipm antuol ka apei yempel. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nti ka eik mper nio apmelel sil yapmonemp antuolel. Nti na yuwap nti ntitmuaken nek na, Keielel ka sank salpikninel nkan Wulapm Weinkel. Aser ka nti ka nak yapmonemp omouleel sitel eik naremp apm kuserelel”. (Aisaia 29:13) ");
INSERT INTO xbi_w_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kakilpe Jisas aiyimp nti ementitmuaken ko la ser kil, aser kil nakimp nti na, “Et yipm eipm, nako yipm wonempwaiyimp aipopel. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Miepm ka yikn alel karokn apul yikn kuoret sankuorkel ar niampepm Wulapm Weinkel. Karokn. Aser sank ka naikul yipm miepmel, keielel sitel ka apul yikn kuoret sankuorkel ar niampepm Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nti omoule ka sop Jisasel la nakimpil na, “Et yikn ka ntinkirai na nti Farisi ka yapmonemp kuoret antemp yikn apulp sank kilelel ka yikn nakel, mi arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aser Jisas naimpil nakimp nti sank loump nak na, “Waiek Ekeipmel apmelel, kil ka apul niokn mputnank ankilel. Miepm mpurel ka kil mper arel ko yer, aser nimun ninkakn irpm kil ankil karokn oel, kil kako nor yentemp niaramp sukur muat. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kona ntokilelel, et yipm korokn yapmonemp wankepm yupulp nti Farisi. Ko yewemp. Nti ka nuarep omoule ka akei tukulpmel etnel. Kona omoule ka niampepm tukulpmel kana ntikiremp omoule niampepm tukulpmel yatel aiyapelel, ntiwie kako yuwi yo elie yemintemp wie”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita nakimp Jisas nak na, Et yikn ko nikimp an niupukn sank loumpel karep yikn nakimp nti ementitmuakenel. An na eipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aser Jisas nak na, “Apulntoku na yipm kile karokn nimpiriepm mi, ");
INSERT INTO xbi_w_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ka yipm karokn ntinkirai apulp keielel? Miepm ka yipm alel ka o nionkopmilmpel, aser ka naimpil aiye muat. Kona ntokilelel, miepm yipm alel kakorokn yupul yipm kuoret sankuorkel yer niampepm Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aser ka sank ankil ka nkarp ar yapmonemp eikipmin naikul miepm eikrieknel ka apul omoule kuoret sankuorkel ar niampepm Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ka apm nak apulp sank antempel minamp irpm sopeiye: Kona yikn aimp yapmonemp kuoretel miel, kona yikn ar omoule wuntuel, kona yapmonemp aiyiknel ka nkarp na yupul mualakntankermp irpmel, kona yikn apul wornketeel, kona yikn nak sank kuoretel apulp omouleel mi yikn nak sank ninkaielel ar niampepm antuol nti omouleel ka nunkurk yirpmel, ");
INSERT INTO xbi_w_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","et sankminamp ntokilelel ka nkarp ar yapmonempel ko yupul yikn na yer kuoret sankuorkel yer niampepm Wulapm Weinkel. Aser kona yikn karokn kaikul onto sop sank antuol manmaknel, minamp sopilelel kakorokn yupul yikn na yer kuoret sankuorkel yer niampepm Wulapm Weinkel. Karokn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas awemp yemp kile apmoi, kil mila yemp ka ar nantip yemp suknel Tair irpm Saidonel. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Muaken Kenanel, kil ka muaken eikrieknel karokn entieyarkup antuol Judael, kil la ser Jisas, akei mpeikn mpeiknel aiyimpil nak na, “Sepmel, Aknamniumpuai Devitel, yikn wonempyupulp apm! Ninkilapm muaken apmelel ka muanumpuor yanker aimpil kuoretimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aser Jisas karokn naimpil nakimpil sank lekekn. Kakilpe nti omoule ka sop Jisasel la nakimp Jisas na, “Muaken kile ka ma aworawor sukn yatip. Et yikn nimpil nker kil na yopmon”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisas naimpil nakimp nti na, “Wulapm Weink ka niuwuwul apm la nako sempop nti ntitmuaken Israelel sitel. Nti ka nuarep nti wus sipsip ka mproel ar yempel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aser muaken kilpe la kitnan, waker akaikyuwump eip kitapm apulp na yiki nio Jisasel. Epe kil nak na, “Sepmel, ko yikn yupulp apm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aser Jisas naimpil nakimp muakenel sank loump nak na, “An kakorokn nkiempop nti ninkilapm miepm na mperp nti niumpua yelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aser muaken kile nak na, “Ank, Sepmel, ka yikn nak wat amu ntunk. Aser nti niumpua ka nuwanti miepm murkupm ka nakinin o kitapmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Epe Jisas naimpil nakimpil na, “Mantiek, yapmonemp aiyiknel ka mintenk yatip ar apmel! Kona ntokilelel, et upuikn aiyiknel ka yikn apulpel kako nininkel”. Karokn walil, ninkilapm muaken ankilel ka naimpil akosepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas awemp yemp kile apmoi, kil etn mila mpepwarmp Galili eikriekn. Kil no malenkel nkistapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aser nti ntitmuaken mitinkel ka la aser kil. Nti apul nti ementitmuaken mitinkel la, nti mini ka akaik kuoretel, antempel nti ka niampepm tukulpmel, nampueip nti ka akaik mponkel, antempel nti omoule karokn nak sankel, antempel nti mpurel ka wulenip apulel. Ka nti apul ntiwarko la, mper nti apmoi Jisas akaik, epe kil naimpil apul nti sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kakilpe nti ementitmuaken ka aki nio Wulapm Weinkel ka kil awulmp Israelel. Apulp nti ka aser nti omoule karokn nak sankel, ka nti naimpil napmok sank. Nti omoule ka akaik mponkel nti ka naimpil sepmimp etn yitoump, antempel nti omoule akaik antuol ka kuoretel, nti ka naimpil etn sepmimp. Nti omoule ka niampepm tukulpmel, nti ka naimpil anser sinsi ntinkiraiel. Nti ntimuaken aser ntokilelel, nti ka yapmonemp pupurur apulp, aser nti aki nio Wulapm Weinkel namp ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas aiyimp nti omoule ka sopilel mila, nakimp nti na, “Apm ka wonempapulp nti ementitmuaken keielel. Nti ka antemp apm ar awun wielekeknelimp aser na miepm antuol ka miniat. Apm karokn apulp na niuwuwul nti nimpil ninket oumpyetne irpm antuol. Karokn sepm. Nilmp ko yer nti kuoret, niampepm ko yawol nti na yuwi nkis aiyapel tikikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aser nti omoule ka sopilel nakimp Jisas na, “Nti ka mitinkelip. Ko an semp miepm yer ku nako an yok nti yelel? Yemp keielel ka kuserel, nti omoule karokn arel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aser Jisas amiyimp nti, “Miepm aripm kile yipm mperel?” Aser nti nak na, “An mper luwu ninker ontokitie krepitie wie antempel oyokn mpurel ka wie sit, karokn mitink”. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aser Jisas nakimp nti ementitmuaken nako nti nkistapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Niatel kil nkamp luwu ninker ontokitie krepitie wie antempel oyokn, nak naremp Wulapm Weink. Kakilpe kil waker amuk nti omoule ka sopilel. Nti nkampel, nti naimpil amuk nti ementitmuaken aimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kakilpe nti eikusukn al, aser nti ka wulinkoimp. Nti al niatel, aser nti omoule ka sopilel nkamp miepm wanki wankilel aimp o urmpunk ontokitie krepitie wie, ka nomintip. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nti omoule ka al miepmel, nti ka 4,000 ementit, aser nti karokn ware nti muaken ninkilapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Niatel Jisas nakimp nti ementitmuaken na yopmon, aser na kil yukur no wutumpepel na la eik yakitie kitapm Magadan. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nti Farisi nampueip nti Sadyusi nti la na mperpmai Jisas. Nti nakimpil nak na, “Kona yikn apul niokn Wulapm Weinkel, yikn wa yupul niokn mintenkel lekekn sop muati ko ntikiremp an apulp mintenk Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aser kil nakimp nti nak na, “Awuniunkuriknel yipm ka nak na, Mpuor akosepm naiyenk lilepim, awun kileko mitno. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aser erienwunoumpel, kona mpuor ka kuasempel, et yipm ka nak na, Etnie kileko yimir. Yipm aser muati mpuor ekeipmel sopilelel, ka yipm aser nunsuk awun ko sepm mi kuoret mi. Aser yipm karokn aser aworel muati walenk irpm ka ntikiremp yipm apulp sinsi kipe ka nininkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yipm ntitmuaken kipe nkisel, yapmonemp aiyipmel antemp Wulapm Weinkel ka kuoret ankil, ka nuarep omoule ka nkisemp apul mualakntankermpel. Aninkanink yipm ka nak na yipm'a ser niokn mintenkel sitel. Aser karokn”. Jisas nakimp nti na, “Yipm kako ser muati lekekn sit, ka muati sop sinsi ka kumpueik ninkemp Jonael, kil ka omoule kumpueikel ka nakaworp yapmonemp Wulapm Weinkel”. Jisas nakimp nti sank keielel niatel, kil awemp nti apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas etn antemp nti omoule ka sopilel, nti ka karep antun mpepwarmp mila yakitie, aser nti omoule ka sopilel ka wonempsukurel luwu ninker, nti karokn apul. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas nakimp nti na, “Yipm ko yekei wonempel nkis niampepm ntankuel yupulp yis ka nti Farisi antempel nti Sadyusi akeiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aser nti omoule ka sop Jisasel, nti nakimp nti ankil nak na, “Kil nakimp an ntokeielel, ka apulp an karokn apul luwu ninker, tikikn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ka ntinkirai apulp sank ka nti nakel, et kil nakimp nti na, “Apulntoku keiye yipm nak na luwu ninker yipm karoknel? Yapmonemp aiyipmel ka wank. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niupukn sank apmelelel, yipm kile karokn ntinkirai apulp, tikikn? Et yipm karokn wonempwaiyimp luwu ninker ontokitielel ka nti 5,000 ntitmuaken alel. Wankiwanki ka nkisel, yipm aimp o urmpunk aripm? ");
INSERT INTO xbi_w_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Et yipm ka wonempsukurel luwu ninker ontokitie krepitie wie, ka nti 4,000 ementitmuaken alel, urmpunk aripm miepm wankilel ka nkisel? ");
INSERT INTO xbi_w_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Apm kipe karokn nakimp yipm apulp luwu ninker. Ka apulpi na yikn wonempwaiyimp ntokilelel? Ka karep apm nakimp yipmel, yipm ko yekei wonempel, nkis niampepm ntankuel, yupulp yis antuol nti Farisi antempel nti Sadyusi akeiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nti ka eipm sank keielel, epe nti ka nkamp ntinkirai ka kil nakimp nti apulp sank irpm ka nti Farisi antempel nti Sadyusi yuwap ntiel, ko nti yekei wonempel na sank yapmonemp antuol Farisi nti Sadyusiel kakorokn mpuanink yapmonemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas la yemp suknel Sisaria ar kitapm Filipaiel, aser kil aiyimp nti omoule ka sopilel na, “Nti omoule ementitmuaken ka nak na apm Es Nkan Ntitmuaken Eikusuknel, apm ka mini?” ");
INSERT INTO xbi_w_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Epe nti naimpil nakimpil na, “Nti mpurel ka nak na yikn ka Jon Baptaisel, ka Herot aimpil wuntuimp aser kil ka naimpil nkarpmop, tikikn. Aser nti mpurel ka nak na yikn ka omoule kumpueikel ka nakaworp yapmonemp Wulapm Weinkel ntoka Elaija mi Jeremaia”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kakilpe Jisas naimpil amiyimp nti omoule ka sopilel, “Et yipm ankil ka nak na apm ka mini?” ");
INSERT INTO xbi_w_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aser Saimon Pita nakimpil na, “Yikn ka Krais, omoule ka Wulapm Weink yuwakel. Yikn ka ninkilapm ankilel Wulapm Weinkel ka kil ar aninkaninkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aser Jisas naimpil nakimpil na, “Saimon, ninkilapm Jonel, Wulapm Weink ka apul yikn akosepm. Karokn ninkilapmel kitapm keielel ka nakimp yikn apulp yapmonemp kile ka yikn nakel, karokn. Ka waiek apmelel ka ar yemp ekeipmel, ka kil ankil ntikiremp yiknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Apm nakimp yikn, nio kitie aiyiknel Pita, ka keielel yikn karep apul sop niupukn nio kilelelel. Et apm ko yimp yikn Pita, ka nak apulp wuntokn. Wuntokn keielel ka nuarep wula weinkel kako yupul nti ementitmuaken apmelel na yer nuarep yetne ka tnei salpiknin. Kona ntokilelel, salpiknin sinsi kuoretel kitapmel kakorokn sankuork nti ntitmuaken apmelel yupul nti na wuntu mpruwasel. Karokn. Nti kako yer yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mpunti apmelel, kuatiar apm'a yok yikn yer onto aiyiknel. Kako ntokeiye. Kakilpe, kona yikn nek na keielel ka kuoret, et yipm korokn yupul, ka apulp Wulapm Weink ka nak soplekekn. Et yikn kona nek na keielel ka akosepm, et yipm ko yumpul minsop, ka sank yapmonemp aiyiknel ntokilelel ka apulp Wulapm Weink ka nak soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niatel Jisas nakamuntup nti omoule ka sopilel na nti kakorokn nikimp nti omoule yatel na kil ka Krais, omoule kilelel ka Wulapm Weink yuwakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Keiye ka anink sukur ka Jisas na sukueimp nti omoule ka sopilel apulp wankepm kako ninkempilel. Kil nak na, “Apm ko la Jerusalem yupulp apm ko semp yakop suknel yer onto antuol emesepmelel, ka nti omoule amamp antuol prisel, antempel nti omoule wupm araiel nampueip nti emesepmel. Ntiwarko upuikn na yer apm wuntuel. Aser apm kako wuntuimp nako yer yemp muanel yer wunoump wielekekn. Ko niatel, apm kako nimpil nkierpmop”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aser Pita ka eipm kuoret sank keielel, kil nkamp Jisas apul la yakitie. Pita nakamuntupil mintenk nak na, “Sepmel, Wulapm Weink kako wonempyupulp yikn nekyuntup wankepm keiye kakorokn ninkemp yikn, apm karokn mpuaimpuai”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aser Jisas naimpil nakimp Pita na, “Satan, yikn nisep apm! Et yikn la yer apm opmoump! Yikn na ukuap apm nako apm yupul yapmonemp kuoretel. Yikn karokn sop yapmonemp Wulapm Weinkel, ka yapmonemp kitapmelip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aser Jisas nakimp nti omoule ka sopilel nak na, “Omoule mini kana sop apmel, kil kakorokn wonempyupulp wule ankilel. Kil kako yorkuos wankepm mimi kana ninkempilel ko kil na nikerpm apmel, sop kuatiar apm kako yorkuos lonkuntonkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kona omouleel wonempser sinsi kitapmel kako yupul kil na yer sepmelel, kuatiar kil ko mproel. Aser kona omouleel wonempwaiyimp apm niorknel aser kil wonempsukurel sinsi kitapmel ankilel, kil kako yer sepmel yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Omoule kile ka nio nkampil apulp sinsi mimi kitapmel mitinkelel, kona kil wuntuel, sinsi irpm ankilel karep kil yikino kepmel ko yupulpil ntomiel? Kakorokn. Karep kil wuntu mpruwaselimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Apm Es Nkan Ementitmuaken Eikusuknel kuatiar ko yekei yete sun yentempel salpiknin nkan Waiek Ekeipmelel nako yentemp nti ensel ankilel yoel. Niatel apm kako yuntunel nti ementitmuaken eikusukn sop sankminamp antuol ka nti apulel nako apm yupulp nti ware. ");
INSERT INTO xbi_w_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Apm nakimp yipm etetel, nti mpurel aiyipmel ka kipe nkisel, nti kako ser Es Ementitmuakenel kuor yetn nuarep omoule amampel. Nti kakorokn yuwur niorkn, nti kako ser kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wunoump ontokitie krepitie lekekn amuntun, epe Jisas ukua Pita antemp Jems nti uknuan ankilel Jon, ntiwarko no malenk suknel, nti apmoi. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nti etn aser wule antempel mponiampepm Jisasel ka naimpilemp nturntierel, wapm ankilel ka naimpilemp mpusmalkepm yatip. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nti aser Moses nti Elaija ka kumpueik awurel, ntiwie eik nininkel antemp Jisas napmok sank. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita aser sopilpe, kil nakimp Jisas na, “Sepmel, ka akosepm an ka ar keielel. Kona yikn upuiknel, apm'a yupulp yipmarko wielekekn yetne mpalmpal kitielel ware yipmarko. El aiyiknel, el Mosesel, el Elaijael.” ");
INSERT INTO xbi_w_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ka nak nak sankel aser, mpuor mlaikn amulmp nti. Sank alnkain naikul mpuor nakimp nti na, “Kil keiye ka ninkilapm apmelel, apm ka upuikn apulpil yatip. Apm ka mpuaimpuai apulpil. Et yipm ko eipm kil sank”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nti omoule ka sop Jisasel eipm sopilelel, nti ka nkinkiekn ankil. Et nti waker akaikyuwump eip kitapm, mponiampepm amu kitapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aser Jisas la kitnan aki nti, nakimp nti na, “Yipm serp. Yipm kakorokn nkinkiekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nti nkarp niampepm antupilel, aser ka Jisas sit arel. Nti karokn aser omoule yatel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Epe nti arkomp malenk apmoi, nti naimpil o. Aser Jisas nakimp nti sank mintenkel nak na, “Sinsi muati ka yipm aserel, yipm kakorokn nikimp nti emelel. Ko yewemp. Yukueimp kuatiarel, kona apm Es Aiyipmel ko serp yopmoi yemp muanel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kakilpe nti omoule ka sopilel amiyimpil na, “Nti omoule wupm araiel ka nak na pitepitekn kona Krais na yoel, Elaija kako yo niorkn. Nti nak sopilpe, ka apulpi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aser Jisas nakimp nti na, “Sank kile ka etetelimp. Elaija kako la niorkn, ntimpramp nti ntitmuaken yupulp Krais ko nininkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aser apm'a nikimp yipm, Elaija ka karep mila, aser nti omoule karokn aser kil aworel. Karokn. Nti ka apulpil kuoret sop upuikn antuol. Kuatiarel nti kako yupulp apm Es Nkan Ntitmuaken Eikusuknel kuoret soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nti omoule ka sopilel eipm sank kilelel, nti ka ntinkiraiyimp ka kil nak apulp Jon Baptaisel epe ka nkamp yemp Elaijael. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nti la ninkemp nti omoule ntitmuaken, aser omouleel la kitnan, waker akaik eip kitapm ampulp Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Kil nak na, “Sepmel, yikn ko wonempyupulp ninkilapm ntit apmelel, kil ka mpienyukurel aser wule ankilel ka eik kuoretel ankil. Kil ka awi ntenkntenk o yete, kil ka awi ntenkntenk o mpep. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka apm apul kil la ser nti omoule ka sop yiknel, aser mintenk antuol karokn sukn nako nti yupul kil sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aser Jisas nakimp nti na, “Yipm ementitmuaken ka kipe nkisel, yapmonemp aiyipmel karokn mintenk nako yipm yekei Wulapm Weink nkael, karokn. Yapmonemp aiyipmel ka nkernker yatip. Et awun aripm ko apm yer yentemp yipm, yorkuos wankepm irpm aiyipmel? Et yipm yupul ninkilapm kile la kei”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Epe Jisas nak nkimer muanumpuor yanker ka apul ninkilapm kilpe ka kukoel, aser muanumpuor yanker awemp ninkilapm kilpelel nainkul eikriekn. Karokn walil, wule kil pelkel sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ar pitekn, nti omoule ka sop Jisasel, nti sit ka la amiyimpil na, “Sepmel, ka weink mi an kakorokn nker muanumpuor yanker kilpelel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jisas naimpil nakimp nti na, “Yapmonemp aiyipmel ka wank, et yipm kakorokn yupul. Apm nakimp yipm etet, kona yapmonemp aiyipmel ko mintenk yupulp Wulapm Weink, aser ka akopitekn ako nuarep wurkopm mastetel, kona yipm upuikn na nikimp malenk kilelel na nkierp la kuere, et malenk ko nkierp yetnel. Apm nakimp yipm etet, kona yapmonemp aiyipmel yer mintenk yentemp Wulapm Weinkel, niokn mintenkel mimi yipm kakorokn yuwup ntinkiliemp, kako yipm yumpul”. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas antemp nti omoule ka sopilel ar la lekekn ar kitapm Galili. Jisas nakimp nti na, “Nti kile kako mper apm Es Nkan Ntitmuaken Eikusuknel la onto antuol omouleel. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nti kako yer apm wuntu, aser awun weikel Wulapm Weink kako yupul apm na nimpil nkierpmop”. Kona nti omoule ankilel eipm sank keielel, nti ka yapmonemp wankepm yatip. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisas etn antemp nti omoule ka sopilel, ntiwarko mila yemp suknel Kaperneam. Nti omoule Judael ka mper wuntokn wank lekekn lekekn ok nti apulp yetne suknel Wulapm Weinkel. Nti omoule mpurel kana semp wuntokn kilelel, nti la aser Pita aiyimpil na, “Et omoule sepmel ka yipm sopel ka mper wuntokn apulp yetne suknel Wulapm Weinkel, mi karokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Epe Pita naimpil nak na, “Ank”. Pita war yetne, aser kil karokn nak sank lekekn, et ka Jisas nakimpil niorkn aiyimpil na, “Saimon, apm'a nikimp yikn sank loump. Et yikn eipm, nako yikn nikimp apm yapmonemp aiyiknel. Nti omoule amamp ar kitapm keielel, nti ka aiyimp nti mini na ukuap nti wuntoknel? Ka nti aiyimp nti ninkilapm antuol? Oroknel, nti ka aiyimp nti omoule eikrieknel ka nkis kitapm nti karep nkampel ukuap wuntokn antuol?” ");
INSERT INTO xbi_w_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita naimpil nakimpil nak na, “Ka nti omoule eikrieknel wampwampel sitel, kako yok omoule amamp wuntokn sopilelel”. Jisas nakimp Pita na, “Ka yikn nak wat amu ntunk. Nti ninkilapm antuol ka antemp nti arel, nti kakorokn. Wiakn omoule amampel karokn aikuol nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sank loump kile ka ntikiremp an apulp aiyimp antuol nti omoule kurpelel, nti kana yimpukuap an wuntokn yupulp yetne suknel Wulapm Weinkel. Karokn niokn apmelel nako apm yupulp nti wuntokn kilelel. Aser nti karokn ntinkirai apulp nana apm ka ninkilapm Wulapm Weinkel. Et kakilpe, ko an eik yok nti wuntoknel, an korokn yentemp nti nokuap yupulp. Et yikn la mpepwarmp na nkiemp oyokn. Oyokn sukur ko yikn sempel, yikn ninimp kil miepm nako yikn ser wuntokn araiel lekekn yer miepm ankilel kipmin. Et yikn ko nkiemp wuntokn kile yupul la yok nti omoule kurpelel. Kako wuntokn antieel yupulp yetne suknel Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aninkel kilpelel nti omoule ka sop Jisasel la aiyimpil nak na, “Kona Wulapm Weink semp yemp yapel omoule amampel, et omoule mini nio ko sempilel nako kil yentempil yer niorknel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Et kakilpe Jisas aiyimp ninkilapmel la etn nti nimuon. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Epe kil nak na, “Apm nakimp yipm etet. Kona yipm korokn nimpilemp yapmonemp yentempel sankminamp aiyipmel nako yipm yer nuarep ninkilapmel, yipm kakorokn yer onto Wulapm Weinkel ko kil yuwulmp yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kona ntokilelel, omouleel ka sop ninkilapm akopiteknel ka kil karokn apulp nio sepmel na sempilel, omoule ntokilpelel kako yer niorknel yopmoi onto Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kona omoule mini etn nio apmelel nako wonempyupulp emelel ntokilelel ka nuarep ninkilapm akopiteknel, ka soplekekn kil ka wonempampulp apm ankil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","Jisas naimpil nak na, “Kona omouleel ukuap emelel ka nuarep ninkilapm akopiteknel kile ka akei apm nkaelel, kona kil kuapil na yupul kuoret yewemp apmel, apm ka aser kil kuoret ankil. Apm ka wonempapulp nti ntitmuaken kitapmel apulp nti omoule sopilelel kana ukuap nti ntitmuaken na yupul yapmonemp kuoretel. Aser omoule kile ka ukuap nti ntitmuaken apmelel sopilelel, kil ko ninkemp wankepm sukn yer onto Wulapm Weinkel, kako sankuork wankepm kona nti kitip wuntokn suknel yer kil ourenk, yawol kil yo mpepnioupmel nako kil wuntuel. Wankepm kako ninkempil kako kuoret ankil. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kakilpe, kona ontoakaik aiyiknel ukuap yikn na yupul sankminamp kuoretel, et yikn ko yuntun wat, nako yikn yer ntinkiraiel. Akosepm kona yikn yer yentemp onto lekekn akaik lekekn sitel, aser yikn ankil kako yer sepmel yer yemp ekeipmel. Oroknel, kona yikn upuikn na onto wie akaik wie aiyiknel na yerelel, et nti kako nkiemp yikn omoule sukur wat yumu yete suknel ka ararel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka soplekekn, kona niampepm aiyiknel ukuap yikn na yupul sankminamp kuoretel, et yikn tipi yakitie wat. Akosepm ko niampepm lekekn sitel yer, aser yikn ankil kako yer sepmel yer yemp ekeipmel. Oroknel, kona yikn upuikn na niampepm aiyiknel wie na yerelel, et nti kako nkiemp yikn omoule sukur wat yumu yemp yeteel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Et yipm ko yekei wonempel. Yipm korokn nek na emelel ka akei apm nkael nuarep ninkilapmel ka sinsi akopitekn. Karokn. Nti ka sinsi suknel. Nti omoule ka nuarep ninkilapm kilpe, Wulapm Weink ka ok nti lekekn lekekn ensel irpm antuol ka salpiknin yatip, nti ka etn niampepm Wulapm Weinkel ar yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aser Jisas ka naimpil nak na, “Yipm ka wonempwaiyimp ntoku? Kona omouleel ka mper 100 wus sipsipel aser lekekn ka mproelimp, kil ko yupul mi? Et kil kako yewemp nti 99 wus sipsip yer, aser kil kile ko yuwup wus sipsip lekekn kile ka mproelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Apm ka nakimp yipm etet. Kil ka mpuaimpuai apulp nti 99 wus sipsip ankilel ka arel, nti karokn mproel. Aser kona kil ninkemp lekekn kilelel ka mproelel, mpuaimpuai ankilel kako nkernkerip. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Waiek aiyipmel ka ar yemp ekeipmelel kako soplekekn. Kil karokn apulp na omoule lekekn antuol nti omoule ankilel kana nuarep nti ninkilapm akopiteknel ko mproel. Karokn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas nak na, “Kona mamintoump Kristenel aiyiknel apul yapmonemp ka kuoretel antemp yiknel, et yikn ko la ser kil. Kona yipmwie sitel nkisel, yipmwie kako nkis nek sank yuwup yapmonemp na yo lekekn. Kona kil eipm yikn sankel, yapmonemp yipmwieel kako pipilakn, nako yipmwie nimpil yer sepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aser kona kil korokn eipm yikn sankel, et yikn ko nkiemp omoule lekekn o wie nako nti nompueip yikn nimpil la ser kil. Nti ko yetn nimuonel na eipm sank yipm nakel, ka apulp sank salpikninel ka nak na, Sankminamp eikusuknel kako omoule lekekn wie nek yapmonemp mper yo lekekn yupulp. (Lo 19:15). ");
INSERT INTO xbi_w_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aser kona kil korokn eipm yipm sankel, et ko yikn nikimp nti ementitmuaken Wulapm Weinkel eikusukn, nako nti nikimpil. Kona kil na yupul aiknosoel, kil korokn eipm sank antuolel yentempel, et yipm ko wonempwamiyimp na kil karokn omoule aiyipmel. Ko yipm yupulpil sop ka yipm apul omoule ka ar eikrieknel sop nti omoule kuoretel ka nkamp wuntokn aiyipmel ok nti omoule amampel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Apm nakimp yipm etet, yapmonemp irpm mimi ko yipm ontoyentemp yer kitapmel, karep Wulapm Weink ontoantemp ar yemp ekeipmel. Aser yapmonemp irpm mimi ka yipm nisep ar kitapmel, karep Wulapm Weink nisep apmoi yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Apm'a nikimp yipm, kona omoule wie aiyipmel nkis nek sank yump yapmonemp yo lekekn yimp Wulapm Weinkel, Wulapm Weink kako yupul sop ka ntiwie aiyimpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ka apulp kona yipmwie o yipm wielekekn niye yiki nio apmelel, apm ankil ka antemp yipm ar”. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Aninkel keielel Pita la aser Jisas nakimpil na, “Sepmel, kona emelel yupul apm kuoret, et apm kako eik yewempel wankepm ankilel, apm kako yupulpil ntokilelel anink aripm? Kako apm yupulpil anink ontokitie krepitie wie, a?” ");
INSERT INTO xbi_w_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aser Jisas nakimpil na, “Apm karokn nakimp yikn nako yikn yupul anink ontokitie krepitie wie, karokn. Ka apm nakimp yikn na kako yikn yupul yopmoiel. Yikn korokn ware nako anink aripm ko yikn yupulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kakilpe, kona Wulapm Weink yuwulmp nti omouleel, kako nuarep sank loump kipe apm'a sukueimp yiknel. Et yikn eipm. Aninkel emesepmel kana semp wuntokn ankilel ka nkis nti omoule nioknel ankilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aser nti apul emelel la aser kil. Omoule kilpe, wuntokn emesepmelel ka nkis kilel ka suknelip, karokn ako, muati ankilel ka nuarep 10 milien wuntokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aser omoule kilpe ka wuntokn nkis kilel, wuntokn muati sopilelel kil karokn mper. Kakilpe emesepmel kilpe nak na, Wuntokn kil karokn. Et kakilpe yipm sempil yentemp muaken ninkilapm ankilel yentempel sinsi eikusukn ankilel, yekei nkiemp wuntokn yupulp ntiel, yok apm. Kil yentemp muaken ninkilapm ankilel, nti kako yupulp emelel niokn kuserel aninkaninkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Omoule nioknel kilpe eipm sank kilelel aser ka kuoretimp. Kil ka numuarep niumpua ka muntoump alunkueiel, kil apul muarkn mila kil, markipninket kil, nakimpil na, Emesepmel, et yikn ko wonempyupulp apm! Yukueimp. Kuatiar apm nimpil yok yikn sinsi aiyiknel kipe nkis apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aser emesepmel nak na, Akosepm. Apm ka wonempapulp yikn. Kile ka yikn yumpul. Kakilpe kil nakimpil nainkul eikriekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kil eik yetne naikul eikriekn aser, kil niminkemp emeniemp ankilel kumpueik kil ok kil wuntokn akopitekn, 10 kina ka nkis kilel. Kakilpe kil la wakerkikaik kil, ontonkampil menintenk nakimpil na, Wuntokn apmelel kumpueik apm ok yiknel, keielel ko yikn yumuk apm insil onto! ");
INSERT INTO xbi_w_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kona emeniemp ankilel eipm sank sopilpe, kil ka apul numuarep niumpua ka muntoump alunkueiel, kil apul muarkn la kil, markipniminket kil nak na, Yikn ko wonempyupulp apm! Yukueimp. Kuatiar apm nimpil yok yikn wuntokn aiyiknel kipe nkis apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aser omoule kilpelel karokn eipm sank emeniemp ankilelel. Kil la nakimp nti omoule aipmpienel na mila. Nti nkamp emeniemp ankilel apul kil muar yetne kuoretel, ko kil yer ser kil kako nimpil yumuk kil wuntokn wamire. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nti omoule niemp mpurel ankilel omoule nioknel niorknel kilpe, nti aser minamp ankilelel ka kil apulpil ntokilelel, et yapmonemp antuol ka kuoret ankil. Nti la sunkueimp emesepmel kilpe sank ampulp omoule nioknel kilelel ka nti aser eipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Epe emesepmel kilpe aiyimpil la aser kil, nakimpil na, Yikn ka apul kuoret! Karep yikn la markipninket apm apulp sinsi sukn mitink apmelel ka nkis yiknel, aser apm karokn wap yikn. Apm ka wonempapulp yikn. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Et apulntoku yikn karokn na wonempyupulp emeniemp aiyiknel soplekekn? ");
INSERT INTO xbi_w_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Emesepmel kilpe naimpil wonemp kuoretimp, kil mper omoule nioknel ankilel mila onto antuol omoule aipmpienel, nako nti yeryitor kil lala ser wankepm nkan wuntokn ka nkis kilel ko miniat”. ");
INSERT INTO xbi_w_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas naimpil nakimp nti na, “Sank keielel apm sukueimp yipmel, ka ntikiremp an yapmonemp nkan Waiek apmelel kuere ar yemp ekeipmel. Kona yipm korokn wonempsukurel yapmonemp kuoretel ka emelel apulp yipmel, Wulapm Weink kako yupulp yipm misop sank keielel karep apm sukueimp yipmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas nak sank miniat, kil awemp kitapm Galili apmoi, kil etn la kitapm Judia ka ar yakitie upukn Jordanel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aser nti omoule ntitmuaken sukn mitink arko la minsopil. Kil apul wulenip antuol sepm miniatelimp ar yemp kilpelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niatel nti Farisi la aser Jisas, nti mperpmai kil aiyimpil na, “Sank salpikninel Mosesel ka nak na akosepm ko an nker muakenel, arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aser Jisas naimpil nakimp nti na, “Et yipm karokn aser sank ka sil wupm Wulapm Weinkel tikikn? Sank ka nak nana kumpueikel ka Wulapm Weink apul sinsi eikusuknel, kil antun mper an ntitel muakenel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Ka weink na omoule mini kana semp muakenel, kil ko yewemp waiekmantiek ankilel na yer nampueip muaken ankilel. Ntiwie kako yer nuarep omoule lekekn, ntiwie karokn yatyat. Ka Wulapm Weink ankil apul ntiwie ka ar mila lekekn sopilelel. Kakilpe omoule kitapmel kakorokn yuntun”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aser nti Farisi naimpil nakimpil na, “Aser Moses nakimp an nak na an ko yupul wupm na nker muakenel, ka apulpi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aser Jisas nakimp nti na, “Ka apulp yipm ka omoule yapmunemp osoip. Moses ka aser yapmonemp aiyipmel, upuikn aiyipmel ka sukn na nker muakenel, et kakilpe kil nakimp yipm sank kile. Et kumpueik kumpueikel, yapmonemp apulp na nker muakenel, Wulapm Weink karokn nak. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kona ntokilelel, omoule mini kana nker muaken ankilel aser muaken kile karokn antemp omoule yatel apul mualakntankermpel, minkan ankilel ka eik nker kil upuikn ankilelel, aninkel kil naimpil nkamump muaken yatel, kil ka apul mualakntankermp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nti omoule ka sop Jisasel eipm sank kilpelel, aser nti nakimp Jisas na, “Kona ntokilelel, an eik yetnel, an korokn nkiemp muaken. Yewemp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas naimpil nakimp nti na, “Nti mpurel sit, ka Wulapm Weink ok nti yapmonemp ntinkiraiel na semp sank keielel aimp o yapmonempel. Aser nti eikusukn, karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Et yipm eipm. Nti omoule mpurel karokn nkamp muakenel, weink ankilel ka yatyat. Nti mpurel ka apul eik nionkopmilmp ampu, anaikn antuol ka nkarpmok. Aser mpurel, wiepm antuol ka nti antun, nti kakorokn ra ninkilapm. Aser nti mpurel ka nakantup muaken, nti kakorokn semp apulp nti na yupul niokn Wulapm Weinkel. Nti omoule mini kona eipm mpuaimpuai sank eikusukn kilelel, nti ko yump yo yapmonemp yupul sop”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aninkel kilelel, nti waiekmantiek apul nti ninkilapm la aser Jisas. Nti apulp na kil ko yekei onto ankilel wul nti na yimp Wulapm Weink yupulp ntiel. Aser nti omoule ka sopilel nak nker nti ementitmuaken kilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas nakimp nti na, “Et yipm ko yekei niampepm eik ser nti sitel, korokn nker nti ninkilapm kana la ser apmel. Wulapm Weink ka mpuaimpuai apulp nti omoule yapmonemp antuol ka nuarep nti ninkilapm keielel, nako kil yuwulmp nti yer onto ankilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Niatel, Jisas aki onto ankilel wul sil nti ninkilapm niatel, kil awemp yemp kilpe, kil apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ninkilapm wasiampel lekekn la aser Jisas, nakimpil na, “Sepmel, yikn ka omoule akosepmel. Et yikn nikimp apm, apm kako nekerpm minamp miel nako apm yentemp Wulapm Weink yer sepmel aninkaninkel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aser Jisas naimpil nakimpil na, “Yikn ka aiyimp apm omoule akosepmel, ka apulpi? Ka Wulapm Weink sit ka akosepmel. Kona yikn'a yer sepmel yopmoiel, et yikn kako nekerpm sank salpikninel Wulapm Weinkel yupul sop”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aser ninkilapm wasiampel kilpe aiyimp Jisas na, “Et yikn nikimp apm ntinkirai, ka sank salpikninel mimi?” Jisas naimpil nakimpil na, “Ka sank salpikninel Mosesel, ka nak ntokeiye. Yipm korokn yer nti omoule wuntu. Yipm kakorokn yupul mualakntankermp. Yipm korokn yupul wornkete. Yipm korokn yentemp emelel eik nukuap ninkaielel yer niampepm antuol nti omoule ka mpunti silel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Aninkanink yikn kako eipm sank nkan nti waiekmantiek nakel nako yupul nti sepm. Yikn kako yekei onto niupuknel nkrawomp nti omoule eikusukn sop ka yikn upuikn apulp wule aiyiknel ankil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aser ninkilapm wasiampel kilpe naimpil nakimp Jisas nak na, “Sank salpikninel Mosesel eikusukn sopeielel ka apm nankerpm. Et kona ntokilelel, yikn nikimp apm ntinkirai. Minamp sepmel mi ka apm wonempsukurel nako apm yupulel? ");
INSERT INTO xbi_w_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aser Jisas nakimpil na, “Kona yikn na yer yapmonemp sepmel sitel, wankepm yapmonempel kako kuserelel, et yikn la semp sinsi aiyiknel sukurel, yekei nkiemp wuntoknel. Wuntokn kile ka yikn nkampel, ko yikn walimp yok nti omoule eretakoel. Kona yikn yupul sopilelel, Wulapm Weink kileko yupulp yikn sepm ware yer yemp ekeipmel ankilel. Et yikn la sop apm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aser kil ka eipm kuoret sank keielel, ka apulp sinsi ankilel ka kil mperel ka mitinkelip. Kakilpe kil awemp Jisas apmon, kil etn amintemp yapmonemp wankepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aser Jisas nakimp nti omoule ka sopilel na, “Apm ka nakimp yipm etet, nti omoule ka mper wuntokn suknel kako yuwup ntinkiliemp, nti kana yer onto Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Apm'a nikimp yipm. Wus suknel ka nuarep wuroknel, kil kako war pierkepm alpanel, mi arokn? Karokn. Omoule kana mper wuntokn suknel aser kil kana yer onto Wulapm Weinkel, kil kako soplekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nti omoule ka sop Jisasel eipm sank kilpelel, aser nti ka eik akei wieel. Nti wonemnimirik wule antuol nak na, “Kona ntokilelel, apulntoku nako omoule war na yer onto Wulapm Weinkel? Kakorokn, tikikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aser Jisas niampepm ntenktenk amuntup nti, nakimp nti nak na, “Kona mintenk omouleel ankil, kakorokn. Ka Wulapm Weink sit kako yupulp nti na yer onto ankilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas nak ntokilpelel, aser Pita nakimpil na, “Yikn eipm. Sinsi antelel eiksuknel karep an awemp opmoumpelimp apulp an kana nenkerpm yikn. Et an kako nkiemp sinsi mi wamire?” ");
INSERT INTO xbi_w_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aser Jisas naimpil nakimp nti na, “Apm ka nakimp yipm etet, kileyar nkienel kona Wulapm Weink nimpil yupul kitapm nako yer otniompoiel, anink kilelel et yipm ko ser apm, Es Aiyipmel Ntitmuakenel, kako sil lontolnko akosepmel apmelel yupulp nio suknel ko semp apmel. Yipm ankil kako sil 12-pla lontolnko aiyipmel na yer niorknel nako yipm yuntunel nti 12-pla oupmweink Israelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aser nti omoule minimini ka sop apmel, nti ka awemp yetne, waiekmantiek, ninkilapm, uknuan okno, niokn mputnank antuolel, nti kako nkiemp sukn mitink yatip ntoka 100 kana semp yemp sinsi lekekn lekekn karep nti awempel. Niatel nti kako yentemp apm yer sepmel yopmoi yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nti omoule mini mitinkel ka ar niorknel, nti kako yer nkimien. Aser nti omoule mini mitinkel ka ar nkaienel, nti kako yer miniorkn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas nak na, “Nti omoule ka Wulapm Weink awulmp ntiel ka nuarep sank keielel apm'a sukueimp yipmel. Ka sopeiye. Erien kakirel omouleel ka la yemp yapelel awup nti omoule mpurel kona yupulpil niokn wuntoknel, lep wurkopm wain ankilel yer niokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aser niorkn nti ka kitip sank apulp wuntokn aripm nkan awun lekeknel kil na yok ntiel. Niatel, waiek kitapmel kilpelel nakimp nti na la yupul niokn yopmoi niokn wain ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Awun akuorpel, kil naimpil la yemp anuyapel aser nti omoule ka eik etnel apmoi. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kil nakimp nti na, “Yipm la niokn wainel apmelel yupulp apm niokn mpurel. Kuatiar apm ko sop minamp sepmel yok yipm wuntoknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aser nti kilpe apmon. Awun oroupmel nako niunkuriknimp, aser omoule kilelel naimpil la anink wie apul soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Et awun o kitapmel, kil naimpil la aser nti mpurel yatel ka eik etn kuserelel. Kil aiyimp nti na, “Ka apulpi na awun mpeikn mpeikn yipm kipe eik ar kuserelel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nti nakimpil na, “Omoule karokn ok an niokn na yupulel”. Aser kil naimpil nakimp nti nak na, “Et yipm la yupul niokn yer niokn wain apmelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Niunkurikn wunoumpel, waiek kitapmel kilelel nakimp omoule ankilel ka etn niorknel nti omoule ka apulpil nioknel nak na, “Yikn ko yimp nti la, yok nti wuntokn nkan awun lekeknel. Sukur yikn ko yok nti ka no nkaienel, niatel ko yikn yumuk nti ka no niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kakilpe nti omoule ka no awun niunkuriknel, nti la nkamump wuntokn antuol sop niokn awun lekekn sukurel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nti mpurel ka apul niokn erienel, nti aser wuntokn nti nkaienel nkampel, aser nti wonempwaiyimp na, “Et an kako nkiemp wuntokn suknel tikikn”. Aser karokn. Ka nti nkamp wuntokn nkan awun lekeknel sop nti mpurel karep nkamp niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nti aser wuntokn ka nti nkampel karokn sukn, epe nti napmok waiek kitapmel kilelel na, ");
INSERT INTO xbi_w_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Karokn sepm! Nti omoule ka no nkaienel, nti ka apul niokn akopitekn, awun muati lekekn sit. Aser an ka apul niokn eik erienel la, awun al an la niunkuriknel. Aser wuntokn ka yikn ok anel karokn sukn sankuork nti! An karokn mpuaimpuai apulp. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Waiek kitapmel kilelel eipm sank ntokilpelel, kil naimpil nakimp emelel antuol nti omoule ka apulpil nioknel nak na, “Yikn kilpelel, apm karokn apul yikn kuoret. Karepel an nkis ntimpramp yapmonemp o lekeknel apulp wuntokn ka apm'a yok yiknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nkiemp wuntokn aiyiknel, et yikn yopmon. Kona apm'a yok nti omoule ka no nkaienel wuntokn ka soplekeknel, ka upuikn apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Apm kakorokn waker wuntokn apmelel upuikn apmelel, a? Kona apm'a yupul yapmonemp sepmel nompueip nti omoule kurpelel, et yipm ka yapmonemp yakopel apulpi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kakilpe Jisas nak na, “Nti omoule ka ar nkaienel kako yer miniorkn. Aser nti omoule ka ar niorknel kako yer nkimien”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas etn aiyapel na la Jerusalem, aser kil nkamp nti omoule ka sopilel la mita nakimp nti nunkualel na, ");
INSERT INTO xbi_w_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Yipm eipm. An keiye na mila Jerusalem. Et nti kileko mper apm Es Aiyipmel Eikusuknel la onto antuol nti omoule amamp antuol prisel antempel nti omoule wupm araiel. Nti kileko nek apm yupulp nako nti yer apm wuntuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nti ko mper apm mila onto antuol nti omoule karokn Judael. Nti kilelel ko yekei mo ntampli apm, nak mpuliep apm. Niatel, nti kako ntemp apm sil lonkuntonkel, nako apm wuntuimp. Aser apm ko yer yemp muanel awun wielekeknel, nako apm nimpil serpmop. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Muaken Sebediel ukua ninkilapm ntit wieel antuol la aser Jisas. Kil waker akaikyuwump eip kitapm apulp nako kil nikimp Jisas sank yapmonemp ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kakilpe, Jisas amiyimpil na, “Yikn kana nikimp apm sank mi?” Aser muaken kilpe nakimp Jisas na, “Kona yikn yer yapel ntoka omoule amamp antelel, et apm apulp na yikn ko semp nti ninkilapm wie apmelel ka sop yiknel nako ntiwie nkis yakitie yakitie yentemp yikn yuwulmp nti eikusuknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisas eipm sank kilelel, aser kil nakimp muaken epe na, “Sank kile ka yipm nakel, ka yipm nkis eik naknakel. Yipm karokn ntinkirai apulp. Et yipmwie apulntoku, yipmwie kako yetn mintenk nako yorkuos wankepm sop apm ko yorkuosel, mi arokn?” Aser ntiwie nak na, “Ank, antie ka mintenk nako yorkuosel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aser Jisas naimpil nakimp ntiwie na, “Ka yipm nak wat amu ntunk. Yipmwie ko yorkuos wankepm sop apm'a yorkuosel. Aser apm kakorokn nek upuikn apmelel yupulp nti minimini ko yer niorknel yentemp apmel. Karokn. Ka Waiek apmelel sit kako ntimpramp nti omoule minimini kana semp yemp kilelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nti 10-pla omoule yatel ka sop Jisasel eipm na ntiwie esuknuanel ka aiyimp Jisas sopilelel, et nti ka yapmonemp kuoret antemp ntiwie. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aser Jisas aiyimp nti la, nakimp nti na, “Yipm eipm. Nti omoule amamp ka ar kitapm keielel, nti ka apulp nio antuol na yer no ekeipmel. Et nti ka nakimp nti omoule eikusukn sank mintenkel nako nti eipm sank nti nakel yupul sopel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aser yipm ankil, yipm korokn yupul sop ka nti apulel. Karokn. Kona emelel aiyipmel apulp nio ko sempil yer niampepm antuol ntitmuaken Wulapm Weinkel, omoule kile kakorokn yupul nio ankilel no ekeipm. Karokn. Kil ko yer ntoka omoule nioknel kuserel aiyipmel eikusuknel, nio karoknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kona ntokilelel, omouleel apulp na yer niorknel, kil ankil kileko yer nkien sop kil ka omoule kuserel. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Apm, Es Aiyipmel Eikusuknel, kako soplekekn. Apm karokn la na ukuap nti omoule na yupulp apm nioknel. Karokn. Apm ka la nako yupulp ntiel. Apm lael, ka apulp apm'a semp yemp antuol nako yuwur yupulp nti. Kona ntokilelel, apm ko nantip mo yerkomp nti mitinkel, ko nti na yentemp Wulapm Weink yer sepmel yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas ukua nti omoule ka sopilel awemp yemp suknel Jeriko, nti mila. Aser nti ementitmuaken arkoarko misop Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Omoule wie ka niampepm tukulpmel ka nkis aiyapel eikriekn. Ntiwie eipm sank apulp Jisas ka lael, aser ntiwie ma awor nak na, “Sepmel Aknamniumpuai Devitel, et yikn ko wonempyupulp antie!” ");
INSERT INTO xbi_w_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nti ementitmuaken eipm ntiwie ma awor nak sopilelel, nti nakimp ntiwie na, “Yipmwie yekei mitiknel”. Aser ntiwie akei suknel ma amor nak na, “Sepmel, Aknamniumpuai Devitel, yikn wonempyupulp antie!” ");
INSERT INTO xbi_w_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kakilpe, Jisas la etn kitnan nantip, naimpil amiyimp ntiwie na, “Yipmwie upuikn apulp na apm'a yupul yipmwie ntoku?” ");
INSERT INTO xbi_w_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kakilpe ntiwie naimpil nakimp Jisas nak na, “Sepmel, antie upuikn apulp nako yikn yupul niampepm antieel nimpil sepmimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas wonempapulp ntiwie, kakilpe kil ontowul niampepm ntiwieel. Aser karokn walil, niampepm ntiwieel ka naimpil niminim, ntiwie naimpil anser ntinkirai. Kakilpe ntiwie ka misop Jisas mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Aninkel kilelel, Jisas antemp nti omoule ka sopilel la kitnan Jerusalem, nti la ninink oumpyetneel ka nti aiyimp Betpets ar malenk Lo Olivel. Jisas nakimp omoule wie ka sopilel nak na, “Yipmwie la oumpyetne kitnan kuorelel. Karokn walil yipmwie ko ser wus donki lekekn, ka siknamp ankilel kurpe antempil etnel. Yipmwie sinkeipil mo, nkiemp ntiwie yupulp apm mila kei. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kona emelel nikimp yipmwie sank miel, yipmwie ko nikimpil na, Omoule sepmel ka an sopilel niuwuwul an na la semp nti yupulpil mila. Nako kil yekei niampepm ser yipmwieel ko pelpelk yupul nti mila kei”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","7","Kakilpe ntiwie la apul sop sank ka Jisas nakimp ntiwieel, nkamp wus donki otniokn siknamp apul nti mila. Epe ntiwie sinkeip wapm mpeiknel ntiwieel wul wus donki ekeipm, ko Jisas no minsil ekeipm. Omoule ka nakaworp yapmonemp Wulapm Weinkel, sank kumpueik kil nakel ar wupm Wulapm Weinkel, ka kipe an niampepm nkupmus, kipe niminink. Kil nak na, Nikimp nti omoule ementitmuaken Saionel sank. Yipm ser. Omoule amamp aiyipmel, kil ka mila. Kil ka sil wus donki nionkioel, akei yapmonemp niluknunel la. Kil karokn aki nio ankilel. (Sekaraia 9:9) ");
INSERT INTO xbi_w_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nti omoule eikusukn aser Jisas ka sil wus donki lael, nti naimpil wonempwamiyimp sank kumpueikel keielel ka kipe niminink. Kakilpe nti mpurel nkamp wapm suknel mpeiknel, mper ar aiyapel apulp Jisas na nekerpm lael. Nti mpurel ka antun wurkopm mpautel onto, mper ar aiyapel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jisas etn nimuon, aser nti omoule ntitmuaken etn niorkn nkaien. Nti eikusukn alump nak na, “Mpuaimpuai yupulp omoule keielel, kil ka Aknamniumpuai Devitel! Wulapm Weink kako yupul sepm omoule keielel ka etn nio Wulapm Weinkel. Yiki nio ankilelel, kil ka ar niorknel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kona Jisas war Jerusalem sopilelel, nti eikusukn ka ar Jerusalemel, nti ka nkark kuoretel. Nti aiyimp ninaiwulp nak na, “Kile ka omoule mini?” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aser nti omoule ka antempil lael nakimp nti omoule Jerusalemel nak na, “Kil ka Jisas. Kil ka omoule ka nakaworp yapmonemp Wulapm Weinkel. Kil ka eik oumpyetne ankilel Nasaret ka ar Galiliel, kil la”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas war loump ka yininkemp yetne suknel Wulapm Weinkel, kil aser nti omoule ka apul niokn wuntokn antuol ar kipmin. Mpurel ka nimpilemp wuntokn, mpurel ka mper aipm ko nti ementitmuaken wat wuntokn kilelel na semp yupulp oumpiepm nti na wulel. Kil aser ntokilpe, kil aki nimpilemp lowaimp irpm ka nti wul sinsi irpm nkis silel, kil nker lilep ntiimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jisas nak na, “Sank ka ar wupm Wulapm Weinkel, ka kil nak na, Yetne apmelel kako yetne yupulp na nti omoule ko yentemp apm nek sankel. (Aisaia 56:7) Aser yipm ankil, yipm ka apul nuarep yemp ka nti omoule wornketeel ka nkuwepm arel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ka ar yetne Wulapm Weinkel eikipmin, aser nti omoule niampepm tukulpmel antemp nti omoule ka akaik mpurmpurel la aser kil. Kakilpe kil apul wule antuol naimpil sepmimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Et nti pris antempel nti omoule ka yuwap nti ntitmuaken sank Wulapm Weinkel, nti aser niokn mintenkel ka kil apulel. Nti opmueipm nti ninkilapm ka ntur alulump ar yetne Wulapm Weinkel. Nti ninkilapm kile ka nak na, “Mpuaimpuai apulp Aknamniumpuai Devitel!” Nti eipm ntokilpe, yapmonemp antuol ka karep kuoretimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nti aiyimp Jisas nak na, “Et yikn opmueipm kuere nti alumpel?” Aser Jisas naimpil nakimp nti na, “Ank. Et yikn karokn aser sank kilelel ka ar wupm Wulapm Weinkel tikikn, ka nak na, Ka Wulapm Weink ankil aki nti ninkilapm akopiteknel apei yapmonempel, kakilpe nti ka aki nio ankilel”. (Buk Song 8:2) ");
INSERT INTO xbi_w_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Niatel kil awemp Jerusalem apmoi, kil mila oumpyetne Betani ko kil yentemp nti yer niumpu wunoump kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas nkarp erienel, kil naimpil mila Jerusalem. Kil etn aiyapel la, aser nilmp amuor kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kil anser lo fik ka tnei aiyapel. Kil niampepm antup lo aser wurkopm ankilel karokn naker. Ka eik itneiel, atno sitel ar. Kakilpe, kil sukuei sank mai o lo fik, nak na, “Et wurkopm kakorokn nimpil neker”. Kil nak ntokilelel, aser karokn walil lo fik ka ninkerimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nti omoule ka sopilel aser ntokilelel, nti nkamp eik nawurkel. Nti napmok na, “Apulntoku lo fik kurpe eik ninkerel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aser Jisas naimpil nakimp nti na, “Apm nakimp yipm etet, kona yipm yer yapmonemp mintenk yentemp Wulapm Weink, yump yapmonemp karokn wiewieel, et yipm ko yupul soplekekn nuarep kipe apm apul lo fik keielel. Aser yipm kakorokn yupul ntokeielel sitel, karokn. Kona yipm nikimp malenkel na, Yikn nkierp la yukur yankuork yo mpep nioupmel, malenk kile ko yupul sop sank yipm nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ka apulp kona yipm yekei yapmonemp mintenk na yimpilel, et Wulapm Weink kako yupul sop sank mimi ka yipm aiyimpilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas war loump nkan yetne suknel Wulapm Weinkel, kil yumuap nti ementitmuaken sank. Epe nti omoule amamp antuol prisel nampueip nti emesepmel nkan Israelel la amiyimpil na, “Ka apulpi na yikn apul niokn kilpelel? Ka mini ok yikn salpiknin?” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aser Jisas naimpil nakimp nti na, “Apm kakorokn pelpelk nikimp yipm niorkn. Aser apm'a nimpil yimp yipm sank yatel. Kona yipm nimpil nikimp apmel, et apm ko ninkimp yipm yupulp mini ka ok apm salpiknin niokn apmelelel kipe apm apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Et yipm nikimp apm. Kumpueik ka Jon wurp nti o mpepel, aser salpiknin ankilel ka kil apul sopilelel ka kil nkamp ar ku? Ka yapmonemp omoule kitapmel mi ka salpiknin Wulapm Weinkel?” Ntiwarko napmok. Aser nti nakimp nti ankil nak na, “Kona an nek na Jon ka akei salpiknin Wulapm Weinkel, Jisas kako nikimp an na, Et yipm karokn yapmonemp lekekn sop sank ka Jon nakel, ka apulpi? Kona ntokilelel, kako kuoret. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aser kona an nek na Jon ka akei yapmonemp nkan omoule kitapmel, et nti ementitmuaken kako yumpul an kuoret tikikn apulp nti ka wonempwaiyimp nana Jon ka omoule ka nakaworp yapmonemp Wulapm Weinkel. An kako nkinkiekn yupulp nti”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kakilpe nti naimpil nakimp Jisas na, “An keiye karokn ntinkirai”. Aser kil naimpil nakimp nti na, “Kakilpe. Yipm karokn nakimp apm sank etetel apulp ka apm aiyimp yipmel. Kona ntokilelel, et apm kakorokn nikimp yipm nterel yupulp mini ka ok apm salpiknin ka apm akei apul niokn keielel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas nakimp nti pris antempel nti emesepmel nak na, “Apm'a sukueimp yipm sank. Et yipm eipm, nako yipm nimpil nikimp apm yapmonemp aiyipmel. Sank ka ntokeiye. Omouleel ka ra ninkilapm ntit wie, aser aninkel kil nakimp ninkilapm wotoumpel ankilel nak na, Yikn la yupul niokn yer mputnank. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Aser kil nak na, Apm kakorokn la kile, apm ka nkark. Kakilpe waiek antuol naimpil la nankimp ninkilapm oroupmel ankilel. Kil nakimpil sank soplekekn, sop karep kil nakimp ninkilapm wotoumpel. Aser kil wakerpwonemp waiek ankilel nak na, Akosepm. Aser ninkilapm oroupmel ka eik wakerpwonempil kuserelel, kil karokn la apul niokn. Ka ninkilapm wotoumpel ka karep nkarkel, kil nimpilemp yapmonemp ankilel, naimpil la apul niokn. Kakilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Et ninkilapm wie kilpelel, yipm wa nek. Mini ka sop sank nkan waiek ntiwieel?” Epe nti nak na, “Ka ninkilapm wotoumpel”. Kakilpe Jisas nakimp nti na, “Ka yipm nak wat amu ntunk. Aser ka apm nakimp yipm etetelel. Nti muaken aiyapelel antemp nti omoule ka nkamp yipm wuntokn ok omoule amampel antuol Romel, nti ka naimplemp yapmonemp antuol apul sop sank ka Jon nakel. Nti ka sankuork yipm, karep nti ka mila onto nkan Wulapm Weinkel. Aser yipm karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sankminamp sepmel ka Jon ntikiremp yuwap yipmel, yipm karokn nakerpm, karokn. Ka nti muaken aiyapelel antemp nti omoule ka nkamp yipm wuntoknel ok omoule amamp Romel, nti ankil ka eipm sank ankilel ka etetel, aimp o yapmonemp antuol apul sopel. Yipm ka aser nti ntokilpe, aser yipm karokn naimpil wonempwaiyimp na nimimplemp yapmonemp aiyipmel ankil. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas nakimp nti omoule sepmel na, Yipm eipm sank loump keielel apm'a sukueimp yipmel. Ka ntokeiye. Omouleel ka yire niokn ankilel, kil na yep wurkopm wain. Niatel kil awor lie ko nti wasip mpep nkan wurkopm wainel yoel. Niatel kil apul yetne ko nti yer wakerp nioknel, antempel loump kil akei yimininkemp nioknel. Kona niokn eikusukn miniat, waiek nioknel ka mper niokn wainel ankilel mila onto antuol omoule mpurel ka niokn kitapm karoknel, ko nti wakerpel. Kona wurkopm wain nikerel nako tiknimp, nti kako mperpil wanki suknel, aser wanki akopitekn ka arel ko nti sumump. Kakilpe kil apmon ankei yemp ka peikel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ar aninkel, wurkopm nanker epe tiknimp. Kakilpe waiek nkan nioknel nakimp nti omoule nioknel yatel ankilel na nti ko nimpil la semp wurkopm ankilel karep nti omoule ka wakerp nioknel nkin mperpil arel. Kakilpe nti la, nakimp nti omoule ka wakerp nioknel nak na, Waiek nioknel nakimp an na semp wurkopm wanki ankilel yupul la yok kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aser nti omoule ka wakerp niokn kilelel, nti nkarp amuor omoule lekekn kilelel ka lael miyep wurkopmel, omoule yatel kilelel ka nti aimpil wuntuimp, el antempel nti akei wuntokn ar kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kakilpe, ar pitepitekn, waiek nioknel naimpil nakimp nti mpurel yatel mila semp wurkopm ankilel. Nti kilpelel ka mitinkel ka sankuork nti karep la niorknel. Aser nti omoule ka wakerp nioknel apulp nti soplekekn, nti naker nti, ar nti miyep wurkopmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Niatel, waiek nioknel nakimp ninkilapm ntit ankilel ankil ko la nser nti. Waiek ankilel nak na, Nti kako opmueipm sank nkan ninklapm apmelel tikikn. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Aser nti omoule kilpelel ka wakerp niokn wainel, nti aser ninklapm ankilel kile mila, aser nti akei wankel nak na, Ninkilapm ankilel kilipm. Waiek ankilel kona yuwurel, kil kuatiar semp yemp waiek ankilelel, kuatiar kil tnim sinsi mimi suknako ankilel. Antarko yer kil wuntuimp nako an ankil sumump sinsi eikusukn. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kakilpe nti nkarp, ontonkampil, ar kil apul mpunel, kitin kil, epe nti ar kil wuntuimp yawol muar eikriekn. Kakilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Et yipm wonempwaiyimp mi, kileyarel waiek nkan niokn wainel ko la yupul nti omoule kilpe ka wakerp niokn wainel ankilel ntontoku?” ");
INSERT INTO xbi_w_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aser nti naimpil nakimpil na, “Kil kuor yeryititor nti omoule kuoretel kilpelel, nti kako wuntu maleelimp. Aser niokn wainel kil kako nimpil semp, mper mila onto antuol omoule mpurel yatel, nti ko niampepm yumuntup waleiel. Wurkopm wainel kona yoworel nako tiknel, nti ko yiki ekepmel mperpil yer”. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas nakimp nti na, “Ank. Et yipm karokn aser aipopel sank Wulapm Weinkel ka ar wupm ankilel, tikikn? Sank kile ka nak apulp wuntokn ka nti akei apul yetneel, ka nak na, Wuntokn ntunku kile, nti omoule ka apul yetneel aser kuoret naka nkampwatel. Aser keielel Wulapm Weink ankil aser wuntokn kile ka akolekeknip, ka kil nkamp mper walei, nako mintenkitneip loumpirnke yetne sukurel nako tnei mintenk. Kil apul sopeiye, ka an aser akosepmimp. (Buk Song 118:22-23) ");
INSERT INTO xbi_w_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kakilpe, apm'a ninkimp yipm na Wulapm Weink kuatiar nker yipm kakorokn wakerp niokn ankilel yipm arel. Niokn kilpelel kil kako yok nti ementitmuaken ka nkis minamp sepmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kona omouleel kutuwur wuntokn ntunku kilpelel, kil ko yuwi kuoretel. Aser kona wuntokn kile kurkuan nantin omouleel, kil ko monienimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nti omoule amamp antuol prisel nampueip nti Farisi eipm sank loump irpm kile ka Jisas nakel, nti ka ntinkirai ka kil nak apulp nti ankil. ");
INSERT INTO xbi_w_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kakilpe, nti na la ontonkiemp Jisas, aser karokn. Nti ka nkinkiekn apulp nti ementitmuaken apulp nti ka nak na Jisas ka omoule ka nakaworp yapmonemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas nakimp nti sank loump yatel nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Et Wulapm Weink kana yuwulmp nti omouleel, ka nuarep sank loump keielel. Omoule amamp el, ninkilapm ntit ankilel ka nkamp muaken. Kil kana yupul miepm suknel yupulp ninkilapm ankilel kile. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Niorkn kil mper sank nakimp nti ementitmuaken apulp miepm kilpe ka kil na yupulel. Awun kilpelel ka kil apul miepmel, kil nakimp nti omoule ka apulpil nioknel, kil niuwuwul nti la, aiyimp nti ementitmuaken ko pelpelk la ser kil. Aser nti ementitmuaken karokn eipm sank, nti nak na, Arokn, an ka nkark, an karokn na la. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aser omoule amamp kilelel naimpil nakimp nti omoule nioknel ankilel yatel, nakimp nti na, Yipm ko la nimpil nikimp nti omoule ka apm waker nti yitoumpel, nikimp nti na, Yipm eipm. Wus malman makemakn suknel apmelel, karep apm aimump na yimir. Kurpe apm akei mitnei, yipm la miepm ninkilapm apmelel ka nkamp muakenel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nti omoule nioknel ankilel nakimp nti sank, aser nti ka akei opmoump muap nti. Nti ka akei lekekn wieelimp. Nti mpurel ka mila niokn mputnank antuol, aser nti mpurel ka mila niokn wuntokn antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aser nti mpurel ka nak nti omoule nioknel, wakerkikaik la antemintenk nti, ar nti wuntuimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aser omoule amamp kilelel ka yapmonemp kuoret, nakimp nti omoule napolel ankilel ko nti la, yer nti wuntuimp, wusmpuar oumpyetne antuol miniatelimp, wula weink yetne niawank sitel insil. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Niatel, kil nakimp nti omoule nioknel ankilel nak na, Miepm ka apulp ninkilapm apmelel ka nkamp muakenel, kipe nkis. Et nti ka omoule kuoret. Nti kakorokn yel miepm apmelel. Nti ka omoule kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","10","Et yipm ko la yetn aiyapel nakurepm eikusuknel yentempel oumpyetne irpm yuwup nti omoule ntitmuaken sepm kuoret sukn ako, nako yimp ntiwarko ko yerko la yel miepm ninkilapm apmelel ka nkamp muakenel. Kakilpe nti ntitmuaken mitinkel la nkupmus yetne, aser yetne ka nomintip. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nti ementitmuaken ka nkisel, nti eikusukn ka rap wapm otniompoiel ntinkiraiel. Omoule amamp kilelel ka war yetne na ser ntiel, aser kil niampepmantup omoule lekekn karokn rap wapm otniompoiel, aser kil ka rap wapm arankel ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kakilpe kil amiyimpil na, Emeniemp apmelel, ka apulpi yikn karokn na rap wapm otniompoiel, aser yikn kana eik war yetneel? Kil eipm, aser kil ka wule maiakelimp, kil karokn sank aiyepil. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Et omoule amamp kilelel nakimp nti ka apulpil nioknel nak na, Et yipm kitipil ontoakaik, yawol kil nukul eikriekn. Kil kako yer yemp nimpiempel, ka nti so kuoretel, nayinku senker, nako wonemnimirik wule. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas naimpil nakimp nti nak na, “Ka etetel. Wulapm Weink ka aiyimp nti omoule mitinkel kana war yemp ankilel nako yer onto ankilelel, aser karokn. Kako nti lekekn wie sit ko warel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nti Farisi naikul eikriekn, nti nkis nak sank awup yapmonemp apulp aiyapel nako nti mperpmai Jisas ankil na nek sank kuoretel ko nti na yer kilel yupulp sank weink ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aser nti Farisi niuwuwul nti omoule antuol mpurel ka sop ntiel, antemp nti omoule mpurel ka apulp Herot. Ntiwarko la aser Jisas nakimpil nak na, “Waiek, aninkanink an ka aser sank yapmonemp aiyiknel ka yikn yuwap nti apulp Wulapm Weinkel ka etetel sitel. Yikn karokn nkinkiekn apulp nti omoule ka nio nkampel. Karokn. Nti omoule ka nio nkampel antempel nti omoule kuserelel, ka yikn nakimp ntiwarko soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Et yikn nikimp an, kuor an yok omoule amamp Sisa ka ar Romel wuntokn ka kil aiyimp an na yok kilel, ko sepm arokn? Kako yuntun sank salpikninel Wulapm Weinkel ka Moses nakimp anel, o karokn? Yikn nikimp an yapmonemp aiyiknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas ka karep anser yapmonemp kuoretel antuol, aser kil nak na, “Ka yipm akei wule eikrieknel eik ninkai apmel. Et yipm karokn awup yapmonemp etetelel apmelel. Yipm kana yupul apm na nek sank kuoretel yupulpi? ");
INSERT INTO xbi_w_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Et yipm ntikiremp apm wuntokn lekekn ka yipm na yok ntiel”. Epe nti apul wuntokn lekekn la ntinkirempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kakilpe Jisas naimpil nakimp nti na, “Et muati irpm nio keiye ka miniel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aser nti naimpil nakimpil na, “Ka muati irpm nio nkan Sisael. Kakilpe kil nakimp nti na, “Sinsi mimi Sisael ka nkis yipmel, ko yipm yok Sisa. Aser sinsi mimi Wulapm Weinkel ka nkis yipmel, et yipm ko yok Wulapm Weink”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kakilpe nti eipm sank ntokilpelel, nti nkark priparekelimp. Aser nti awempil, nti ka apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aser awun soplekeknel, nti Sadyusi mpurel la amiyimp Jisas apulp yapmonemp antuol, ka nti nak na nti omoule ka wuntuel, nti kakorokn nimpil nkierp. Nti nakimpil nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sepmel, Moses ka nakimp an na kona emelel ka awurel ninkilapm ankilel ka kuserelel, muakenarenk ankilel kako nimpil yemintemp esuknuan ankilel apulp na yuntun ninkilapm ntitmuaken irpm kana semp yempel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","An na sukueimp yikn. Kumpueikel nti esuknuan ontokitie nkrepitie wie ka ntiwarko arel, es antuol ka nkamp muaken. Ntiwie karokn ra ninkilapm aser kil ka wuntuimp. Muakenarenk ankilel kilpe naimpil amintemp uknuan ankilel ka sil kilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aser ka soplekekn, kil ka wuntuimp, ninkilapm ka kuserel. Aser muaken kilpelel ka antempel nti uknuanuknuan ankilel aser nti ka wuntu miniatelimp, nti karokn antun ninkilapm ntitmuaken nkis. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ar pitekn, muaken kilpe wuntu sop nti nkamien. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Et yikn nek. Aninkel, kona nti omoule eikusukn wuntuel nako nimpil nkierpel, muaken kilpelel ko yentemp mini ntiwarko esuknuanel kilpelel nkisel? Yikn ser, ar kitapmel muaken kilpelel ka amintemp ntiwarko nkupmus”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kakilpe Jisas naimpil nakimp nti na, “Yipm karokn aser aworel sank ka sil wupm Wulapm Weinkel, antempel salpiknin ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nti omoule ka wuntu naka naimpil nkarpel, nti kakorokn nimpil nkiemp muaken. Karokn. Nti kako eik yer kuserelel sop nti ensel Wulapm Weinkel ka ar yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sank kilpe yipm aiyimp apm apulp omoule ka wuntu naka naimpil nkarpel. Et yipm karokn eipm sank ka Wulapm Weink nakimp yipmel tikikn? ");
INSERT INTO xbi_w_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kil nak na, Apm ka Wulapm Weink. Keielel, apm ka awulmp Abraham nampueip Aisak nti Jekopel. (Kisim Bek 3:6) Wulapm Weink nak apulp nti manipiap wielekeknel ka kumpueik awurel, aser kil nak na keielel kil ka awulmp ntiel amintempel. Apulntoku na kil ka apul sopilelel? Kil ka awulmp nti omoule ka pirpmel, ka kipe nkisel sitel. Kona ntokilelel, sank kile ka ntikiremp an apulp na nti omoule ka awurel, nti kako nimpil nkierpel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nti ementitmuaken eipm sank kilpe kil nakel, nti nkamp eik nawurkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nti Farisi eipm sank ampulp Jisas ka nak nkimer nti Sadyusi sank. Kakilpe nti Farisi arko la anser Jisas. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Emelel antuol Farisiel ka ntinkirai apulp sank salpikninel Wulapm Weinkel, kil na mperpmai Jisas. Kakilpe kil aiyimp nimpilemp Jisas nakimpil na, ");
INSERT INTO xbi_w_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Waiek, sank salpikninel Wulapm Weinkel mi ka ar niorknel, ka awulmp nti sank yatel eikusuknel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kakilpe Jisas naimpil nakimpil na, “Yapmonemp aiyipmel korokn yer wie, karokn. Yapmonemp nilmniumpuaipm antempel pirpm aiyipmel ko yupulp Wulapm Weink sit. (Lo 6:5) ");
INSERT INTO xbi_w_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sank salpikninel keielel ka suknel, ka ar niorknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sank salpikninel ka sil kilel ka ntokeiye. Omoule mini sepm kuoret ko yikn yekei onto niupuknel nkrawomp nti, ko yikn yupulp nti sepm sepm sit sop yikn ka apulp wule aiyiknel ankil. (Wok Pris 19:18) ");
INSERT INTO xbi_w_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sank wie keielel ka weink, ka awulmp nti sank eikusukn kumpueik Wulapm Weink nakimp anel ar wupm ankilel, ka sank Mosesel nampueip sank antuol nti omoule ka nakaworp yapmonemp Wulapm Weinkel nakel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nti Farisi kilpe nkis, Jisas aiyimp nti na, ");
INSERT INTO xbi_w_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Yipm ka wonempwaiyimp ntoku apulp Krais, omoule ka Wulapm Weink yuwakel? Kil ka ninkilapm miniel?” Nti nakimpil na, “Kil ka aknamnumpuai nkan omoule amamp antelel Devitel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aser Jisas aiyimp nti na, “Kona ntokilelel, apulntoku ka Pirpm Wulapm Weinkel aki yapmonemp Devitel na kil aiyimp omoule kilpelel omoule amamp? Devit ka nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ka Wulapm Weink nakimp omoule amamp apmelel nak na, Yikn ko yopmoi onto yapel apmelel nako yikn semp mpunti aiyiknel. Apm kileko yekei mintenk apmelel na yupul mintenk antuol omoule wuroknel aiyiknelel miniatelimp. Et yikn ko yer niorknel nti yopmoi yopmoiel. (Buk Song 110:11) ");
INSERT INTO xbi_w_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Et yipm nikimp apm. Kona omoule kilpelel ka aknamnumpuai Devitel, et Devit aiyimpil omoule amamp ankilel ka apulntoku?” ");
INSERT INTO xbi_w_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aser karokn omoule lekekn antuol Farisiel ka naimpil nakimp Jisas sank lekekn. Karokn. Et kakilpe, awun kilelel lalael, nti ka nkinkiekn ampulpil, nti kakorokn nimpil mperpmai yimpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Niatel, Jisas nakimp nti ementitmuaken nampueip nti omoule ka sopilel sank, ");
INSERT INTO xbi_w_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","nak na, “Nti omoule wupm araiel nampueip nti Farisi, yapmonemp antuol ka atitakuor apulp sank salpikninel Wulapm Weinkel. Kakilpe nti nkamp miepm Mosesel ko nti nikimp yuwap yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sank salpikninel mimi nti kona nikimp yipmel, yipm kuor eipm na yupul minsop. Aser sankminamp antuol ka nti apulel, yipm kakorokn sop. Kuor yewemp. Nti ka nak sank salpikninel Wulapm Weinkel mitinkel kuserel, aser nti ankil karokn apul sop. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nti Farisi ka walimp sank salpikninel nak sank mitinkel ka nuarep ntokwankepm suknel ka nti ntitmuaken kako sael. Aser nti Farisi karokn sakirp nti, arokn. Nti ka niampepm eik antup ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Sinsi niokn irpm nti Farisi apulel, nti ka apul ar niampepm antuol ntitmuaken eikusuknel sitel. Nti apul sank Wulapm Weinkel sil wupm, kitin wampel sukn mpuntierel, el kitip ar mpo yapel, el kitip ar onto yiknankel. Wapm antuol ka nti rapel, nti ka akei mo mpeiknel la wapm yaiyi, karokn wank, ka amu kitapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nti ka upuikn apulp nti ankil na yer niorknel yetn yemp yapelel yer niampepm antuol eikusuknel yer yonk Wulapm Weinkel yentempel miepmuro antuol eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nti upuikn na nti ntitmuaken ko yimp nti emesepmel yer yemp yapelel, na yep nti yupulp sank antuol ka nti yuwap ntiel, yupul nio antuol nemp ekeipm ntoka nti ka omoule Wulapm Weinkel sepm yatip. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aser yipm karokn. Yipm eikusukn kako yer soplekekn, yipm ka mamintoump sitel. Yipm korokn yimp emelel aiyipmel na kil ka sepmel aiyipmel. Karokn. Sepmel aiyipmel ka yuwap yipmel ka lekekn sit. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ar kitapm keielel, yipm korokn neremp emelel, yiki nio ankilel na yimpil waiek. Karokn. Waiek aiyipmel ka lekekn sit, ka ar yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nti kakorokn yimp yipm omoule amamp. Karokn. Omoule amamp aiyipmel ka lekekn sit. Ka Krais, omoule ka Wulapm Weink yuwakel na semp nti ementitmuaken na yer sepmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Emesepmel aiyipmel ka nio nkampilel kako yer nuarep omoule kuserel. Kil ko yupulp nti eikusukn niokn kuserel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Omoule ka aki nio ankilel no ekeipmel, Wulapm Weink kako yupul kil yumu kitapm. Aser omoule mini karokn wonempwaiyimp nio ankilel, nio ankilel ankil ka kil mper o kitapmel, Wulapm Weink kako yiki nio ankilel no ekeipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jisas yu aki aki na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, yipm ka akei wule eikrieknel. Et yipm kileko niminkemp wankepm yer onto Wulapm Weinkel. Yipm ka nakantup nti omoule kana war yer onto nkan Wulapm Weinkel. Yipm ka ntunkuorp ntiel, aser yipm ankil karokn nakerpm aiyapel kilpe na yer yentempel Wulapm Weink. Karokn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Jisas naimpil yu aki nak na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, yipm ka akei wule eikrieknel ninkai nti omouleel. Et yipm kileko niminkemp wankepm yer onto Wulapm Weinkel. Yipm ka etn peikel antun mpepnioupm etn wampwamp apulp na yuwup omouleel na yupul kil na sop yayapel ka yipm etnel. Yipm nak na ka aiyapel Wulapm Weinkel, aser karokn. Et yipm apul kil na yupul sankminamp kuoretel soplekekn ka yipm nkisel. Aser kil kako samunkuork yipm nako kil yupul sankminamp kuoretel suknel. Ntokilpelel, yipmarko eikusukn kileko la yemp yeteel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Jisas naimpil yu aki nak na, “Ai! Yipm omoule kana ntikiremp nti aiyapel, aser yipm akei niampepm tukulpmel etn. Et yipm kileko niminkemp wankepm yer onto Wulapm Weinkel. Apulp na yipm ka nak na, Kona emelel yimp nio nkan yetne Wulapm Weinkel na nek kuntoel mintenkitneip sank ankilel, ka sinsi akopitekn. Ka upuikn ankilel ko kil yupul sopel, mi arokn. Aser emelel kona yimp nio nkan wuntokn sepmel (gol) ka ar yetne Wulapm Weinkel eikipminel na nek kuntoel mintenkitneip kil sankel, et kil kako yupul sop sank ka kil nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yipm ka yapmonemp sukukurel, yipm akei tukulpmel etnel. Et sinsi mi ka suknel ar niampepm Wulapm Weinkel — wuntokn sepmel, arokn, yetne Wulapm Weinkel? Et yipm ko ser yoworel, ka yetne Wulapm Weinkel ankil ka apul wuntokn ka eikipminel ka ar akosepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sankel ka yipm nak na, Kona emelel yimp lowaimp ka wul oumpiepmel na nek kuntoel nako mintenkitneip sank ankilel, ka sinsi akopitekn. Aser kil ko yimp sinsi ka sil lowaimp oumpiepmel yentempel nako kil yupul sop sank ka kil nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amamp yipm ka kuserel, yipm ka akei tukulpmel napek! Sinsi mi ka suknel? Lowaimp oumpiepmel, arokn, sinsi ka yipm wulel? Yipm ko ser yoworel, miepm irpm sinsi ka yipm wulel ka akosepm apulp nti ka wul sil lowaimp oumpiepmel Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kakilpe, kona emelel nek kuntoel yuntun lowaimp oumpiepmel yupulp na mintenkitneip sank ankilelel, ka kil nak kuntoel antun lowaimp kilpe nampueip sinsi eikusukn ka nti wul silel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aser emelel kona nek kuntoel yuntun yetne Wulapm Weinkel yupulp sank ankilel ka kil nakel, ka kil nak kuntoel antun Wulapm Weink antempel, apulp na ka yetne ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aser kona emelel yimp yemp sepmel na nek kuntoel yuntunel yupulp sank ankilel, ka kil nak kuntoel antun amintemp Wulapm Weink ankil. Apulp na Wulapm Weink ka ar yemp sepmel, ka lontolnko sepmel ankilel ka kil silel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Jisas naimpil yu aki nak na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, yipm ka akei wule eikrieknel ninkai nti omouleel. Et Wulapm Weink kileko yumuk yipm wankepm yer onto ankilel. Wonk akopitepitekn nuarep kari ka ar mputnankel, ka yipm wakerp ontokitiekitieel, apulp lekekn ka yipm amuk Wulapm Weink. Ka akosepm yipm ka nakerpm sank salpiknin akopiteknel ntokilelel, aser yipm karokn nakerpm yapmonemp suknel Wulapm Weinkel, ka kil nakimp yipm ntokeiye. El kil nak na, Yipm ko yekei yapmonemp sepmel wonempyupulp nti eikusukn, yekei nainkerp nti. Yatel kil nak na yipm ko yump yapmonemp sepmel na ser yoworel yapmonemp antuol eikusuknel yupulp nti wamire sop aiyapel ka akosepm yer niampepm Wulapm Weinkel. Yatel kil nak na yipm ko yekei Wulapm Weink nkael, yapmonemp aiyipmel ko lekekn yentempel kil. Yapmonemp suknel irpm ntokilelel ka Wulapm Weink nakimp yipmel, ka yipm karokn nakerpm. Akosepmel ko yipm nekerpm sank salpikninel suknel kilpe ka awulmp nti sank salpikninel akopiteknel ka ar kipminel, ko yipm yupul wie yentemp. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yipm ka akei tukulpmel etn! Sankminamp aiyipmel apulp sank salpikninel Wulapm Weinkel ka nuarep sank muati keielel. Kona yikn ser wolkn akopitekn yer mpep aiyiknelel, et yikn kako pelkel semp wat. Aser kona saklok maninik yer mpep aiyiknelel, yikn karokn nkarkemp, ka yikn aimp. Et niampepm yipm ka tukulpm apulp yapmonemp Wulapm Weinkel. Kona ntokilelel, apulntoku na yipm ko ntikiremp nti ntitmuaken aiyapel sepmel nti ko yetnel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jisas naimpil yu aki nak na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, yipm ka akei wule eikrieknel. Et yipm kileko niminkemp wankepm yer onto Wulapm Weinkel. Sankminamp aiyipmel ntokilelel ka nuarep sank muati keielel. Yuko eikrieknel ka yipm kaikul ntinkiraiyimp aser miepm ka yipm aimp o yukoel ka sankuorkel. Yapmonemp aiyipmel ar eikipminel ka kuoret. Yipm ka sop upuikn aiyipmel sitel, yipm ka oatorel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yipm Farisi, niampepm yipm ka tukulpmimp apulp yapmonemp Wulapm Weinkel! Et yipm ko sukul eikipminel ko ntinkiraiel, na eikirieknel ankilel kako yer ntinkirai yentempel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jisas naimpil yu aki nak na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, yipm ka akei wule eikrieknel mpuaryawi yapmonemp kuoretel aiyipmel. Et yipm kileko niminkemp wankepm yer onto Wulapm Weinkel. Yipm ka nuarep ntoupm wuntokn ka nti yuwei muanmato mper arel. Eikrieknel ankilel ka nti akei makupm mpusel ariel. Nti omoule kona serel ka lekeknip. Aser eikipminel ankilel nti karokn aserel ka kuoret ankil, lenkepm awupm ka krinkronkelimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yipm ka soplekekn. Nti omoule ka aser yipm entieaikn eikrieknel, nti ka nak na yipm ka omoule sepm. Aser ar yapmonemp eikipminel aiyipmel, yapmonemp kuoretel antempel sank mpulmpulel ka nomintip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","32","Jisas naimpil nakimp nti na, “Ai! Yipm omoule wupm araiel antempel yipm Farisi, et yipm eipm. Kumpueikel, nti manmakn aiyipmel ka aimp nti omoule Wulapm Weinkel wuntuel, ka nti nakaworp yapmonemp ankilelel. Muan antuol ka nti mper ar ntoupm muanel. Keielel, ka yipm apul yemp muanel antuol ntinkirai, ntemp niaimp wose yimininkemp. Yipm apulel, yipm ka nak na, Nti omoule kile ka kumpueik nakaworp yapmonemp Wulapm Weinkel, keielel an apulp nti yapmonemp sepmel. Nti manmakn antelel ka aimp nti wuntuel, aser an karokn. Kona ko an yentemp nti manmakn antelel yer sop kumpueikel, an kakorokn sop minamp antuol, yer nti omoule Wulapm Weinkel wuntu sopilelel. Karokn”. Jisas yu aki naimpil nakimp nti na, “Yipm ka akei wule eikrieknel nakel! Ka yipm nakel, ka yipm wankirp sank mperp yipm ankil. Ka yipm nak na yipm ka aknamniumpuai antuol manmaknel. Ka yipm nak etet yumua, ka apulp minamp aiyipmel ka sop minamp antuol epe. Ka yipm apul soplekekn nako yipm walimp na yupul suknel yapmonemp kuoretel nkan nti manmakn aiyipmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yipm ka saklok kuoret, ka aimp omouleel. Kona Wulapm Weink yuntunel yipmel, et yipm kako waiyimp yete warin ka ar yemp kuoretel yupulntoku? Yipm kakorokn yer sepmel. Karokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Et yipm eipm. Apm ko niuwuwul nti omoule ka nakaworp yapmonemp Wulapm Weinkel, nompueip nti omoule ka yapmonemp atitakuorel, nompueip nti omoule kana yuwap yipm sepm yupulp sank Wulapm Weinkel. Apm ko nikimp nti na la ser yipm, aser yipm kako yer nti mpurel wuntu, ntemp nti mpurel yer lonkuntonkel, yawol ntampli nti mpurel yer yonk Wulapm Weinkel aiyipmel. Yipm kako nker nti yer yemp aiyipmel nkierk mila yemp yatel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kakilpe, Wulapm Weink nak na lenkepm antuol nti omoule yapmonemp sepmel minimini ka eik wuntuel, lenkepm antuol eikusuknel ko nkis yipm ankil. Eik kumpueikelip ka Abel, ninkilapm Adamel, karokn apul minamp kuoretel lekekn, lala ankei Sekaria, ninkilapm nkan Berekaiael, ka nti manmakn aiyipmel Judael aimpil wuntu ar yetne Wulapm Weinkel ar nantip lowaimp oumpiepmel. Lenkepm antuol eikusuknel ka nkis yipm ankil ka kipe eipm apmel ntoka yipm ankil apulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Wulapm Weink ko yuntunel yipm ka kipe nkisel, yok yipm yakop suknel yupulp yapmonemp kuoretel eikusuknel kilpe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas nak na, “Yipm ementitmuaken Jerusalemel, eretako. Yipm ka ar nti omoule wuntu ka nakaworp yapmonemp Wulapm Weinkel. Yipm akei wuntokn aimpar nti omoule akosepmel ka Wulapm Weink niuwuwul nti na ser yipmel. Yipm apul ntokilelel aser aninkanink apm upuikn nako apm muani yipm nuarep aipmunu takrenk ka akei yok awulmp siknamp ankilel. Aser yipm ka nkark. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Et yipm eipm. Wulapm Weink kako yewemp yipm. Yemp aiyipmel kako yaku warmp, wurkopm musuei minsil. Ntitmuaken eikusukn kako yetn miniat. ");
INSERT INTO xbi_w_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Apm nakimp yipm, pitepitekn apm ko yememp yipm na yipm kakorokn nimpil ser apm yer kipe. Aser kileyar nkienel, ko yipm yekei sank suknel nek yupulp apm nek na, Wulapm Weink kako yupul yikn sepm, ka yikn akei salpiknin nkan Wulapm Weinkel oel”. (Buk Song 118:26) ");
INSERT INTO xbi_w_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas awemp loump ka yininkemp yetne Wulapm Weinkel apmoi, kil apmon. Aser nti omoule ka sopilel la anser kil. Nti na ntikirempil yetne irpm ka ar yemp Wulapm Weinkel kile. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kakilpe kil nakimp nti na, “Yetne eikusukn kilpelel yipm aserel ka akosepm, a? Apm nakimp yipm etet, wuntokn irpm kumpueik nti mper silel apul yetne mprinkelel, kako nti waker wat priparekel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas ka nkis malenk Oliv, aser nti omoule ka sopilel sit la aser kil aiyimpil nak na, “Et yikn nikimp an, arikel ko nti nu yetne Wulapm Weinkel ntokilelel? Ko an ser muati mi ko nipirel nako an ntinkirai yupulp kitapm keielel ko niat nako yikn nimpil yoel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aser Jisas naimpil nakimp nti na, “Yipm ko yetn niampepm ntanku yupulp nti minimini kuor ninkai yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nti mitimitink kako la yimp nio apmelel nek na, Apm epe, apm ka Krais ka Wulapm Weink niuwuwul apm na semp yipm ementitmuakenel. Sank kilelel nti nakel kako ninkai nti ementitmuaken mitimitink. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yipm ko eipm alnkain suknel ka nti napol ar kitnanel, nako yipm eipm sank wolpm apulp nti akei wakirpm napol ar peikel, aser yipm korokn wonemp waninkepm. Wankepm ntokilelel kileko niminink, aser aninkel Wulapm Weink ko yuntunel anel, kakorokn ninink. Kileyar kilpe ar kipmin. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aser nti omoule oupmweink lekekn ko la nopol yemintemp nti oupmweink yatel. Et omoule amamp lekekn ko yiki yapmonemp nkan nti omoule ankilelel la nopol yemintemp nti omoule nkan omoule amamp yatelel. Nilmp kako yer nti sukn suknel yer wampelel. Yinikn kako yamuol yer wampwamp. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wankepm ntokilelel karokn ntikiremp an apulp kitapm sukurel pitepitekn na niatel. Karokn. Sinsi ntokilelel ka nuarep yakop ka apul muaken ko ra ninkilapmel aser kil karokn ra miniat. Kileyar kilpe ar kipmin. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yipm omoule ka akei nio apmelel ko semp yakop suknel yer onto antuol nako nti yer yipm wuntu. Nti eikusukn wampwampel kako yapmonemp kuoret yentemp yipm apulp nti ka nkarkemp apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nti omoule ementitmuaken mitinkel ka nakerpm apmel, nti mitinkel kako wonempsukurel apmimp. Kakilpe yapmonemp kuoretel ko yer sukn yentemp nti anti, nako nti mper nti mamintoump Kristenel antuol la onto antuol omoule wurokn yankerel ko yump nti wuntu. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kuatiar nti mitinkel ko eik yekei nio Wulapm Weinkel nek ninkaielel na nti ka nakaworp yapmonemp Wulapm Weinkel. Nti kako ukuap nti ntitmuaken mitinkel na yewemp apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sankminamp kuoretel eikusuknel kileko yopmoi yapel, nako yupul nti omoule ka akosepmel kako yewemp yapmonemp sepmel, ukuap nti na nti korokn yekei onto niupuknel nkrawomp nti omoule yupul nti sepm. Nti kako likipel ");
INSERT INTO xbi_w_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Et nti ementitmuaken, kona nti yetn mintenk yupul sop sank Wulapm Weinkel lala kitapm kipe kona niatelel, Wulapm Weink kako yupul nti kako yentempil yer aninkanink yopmoi onto ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aser sank sepmel yupulp yapmonemp Wulapm Weinkel apulp kil na yuwulmp ntiel, nti kako wat nikimp nti eikusukn wampwampel. Kona niatel, kitapm sukurel ko miniat”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas nak na, “Daniel, omoule ka kumpueik nakaworp yapmonemp Wulapm Weinkel, kil nak apulp sinsi kuoretel ko yupul yetne Wulapm Weinkel na yer sankuorkel. Sank kil nakel, yipm ankil kako niampepm nkupmus. (Sank Nimpirepm: Omoule mini ko ntinkirai yupulp sank niupukn keielel, kil kako yump yo yapmonemp ankilel.) ");
INSERT INTO xbi_w_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nti ementitmuaken ka ar kitapm Judiael, kona nti ser sinsi kuoretel kilelel, nti kako nkierk no malenk irpm. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kona omouleel ka sil yetne ekeipmel, kil ko nimpil yo kitapm na yetnel. Kil korokn walilwalil na semp sinsi miel yer yetne ankilel kipminel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kona omouleel ka ar niokn mputnank ankilel, kil kakorokn nimpil ninket uknuamp war yetne na semp wapm ankilel ka awulmp matnoel. Karokn. Kil ko yewemp niokn ankilel ko pelk nkierk yopmon siminkre. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nti eretako muakenmuaken ka ninkilapm wulinkoel mi ninkilapm ka sil ntaipmel. Awun kilelel nti kako yuwup ntinkiliemp yatip. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yipm ko yimp Waiek Ekeipmel nako kil ntunkuorp wankepm keielel kakorokn ninkemp yipm yer awun Sapatel mi yer anink wolpm etnieel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wankepm kona nininkel kako suknelip, kako samunkuork wankepm eikusukn kona ninink nkienel, yentempel wankepm ka eik kumpueik Wulapm Weink apul kitapmel la milap keielel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kona Wulapm Weink korokn na nekyuntup wankepm na yer mpeiknel, nti ementitmuaken kako wuntu wuntu miniat. Aser kil wonempapulp nti ementitmuaken ankilel, kakilpe kil na yuntun wankepm wankilel yer. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Anink kilelel, nti mpurel kako yupul muati niokn mintenkel suknel yer kile yer kile, ukuap nti ntitmuaken kako nek na nti ka Krais. Aser yipm korokn eipm nti, nti ka ninkaielel. Yipm ko eipm omouleel ko la nek na, Omoule ka Wulapm Weink yuwakel ka ar kuere. Nti yatel ko nek na Krais ka ar keiye. El ko nek na, Apm ka omoule sepmel ka nakaworp yapmonemp Wulapm Weinkel. Nti akei sank ntokeiye apulp nti na ukuap nti ementitmuaken mitinkel na yewemp aiyapel Wulapm Weinkel. Nti na ukuap nti ementitmuaken Wulapm Weinkel ankil, aser karokn. Et yipm kakorokn eipm nti. Nti kana ninkai yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Et yipm kako ntinkirai. Karep apm nakimp yipm miniorkn apulp wankepm kipe na nininkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nti kona nikimp yipm na, Yipm ser, kil ka apei wurun oso, et yipm korokn la yemp kurpelel. Kona nti nek na, Yipm ser, kil ka apei yetne eikipmin, et yipm korokn eipm sank antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yipm kona ser Es Nkan Ntitmuaken Eikusuknel kona yoel, kil kako nuarep mpuor mlaikn ka awulmp kitapm sukurel. Nti eikusukn kako ser kil krikel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Muati yatel ka ntokeiye. Nti eikusukn kako ntinkirai yupulp wus muampel ka ar kuel apulp nti ko ser nti aipmpien irpm ka yinink yinink”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas naimpil nak na, “Wankepm ko niatel, kakorokn walil Wulapm Weink kako yukurp sinsi eikusukn ka ar mpuor ekeipmel. Awun kako muatiti, wien kako mululup, nti nkuaimantump irpm kako kurkuan. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Niatel, nti ko ser muati yer ekeipmel kako ntikiremp nti na Es Antuol kilipm. Kil ko sil mpuor ekeipm nako yo yentemp yete mlaikn ka muati apulp salpiknin nkan Wulapm Weink ok kilel. Nti oupmweink eikusukn ar kitapm sukurel kako so kuoretimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ensel lekekn kako yowop yipmiemp alnkain suknel, aser Wulapm Weink kako niuwuwul nti mitinkel la yuwup nti ementitmuaken ankilel ka ar wampwampel, semp nti la yentempil yer lekekn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas naimpil nak na, “Yipm ka aser aipopel lo mpurel, kako ntikiremp yipm apulp sinsi mi ko nininkel. Kona lo atno yerempel yupulp lo atno otniompoiel ko nimpil yeel, et yipm ko ntinkirai na aipm ka miniatimp aser mimpin ka nkarpmop. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka muati apulp sank karep apm nakimp yipmel apulp sinsi mimi ko nininkel. Ka sank walenk apulp Es Aiyipmel Ementitmuakenel pitepitekn nako yoel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Apm nakimp yipm etet, yipm kakorokn wuntu aser sank keielel kako niminink. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mpuorwien nampueip kitapm kako miniat, aser na sank apmelel kakorokn niat, kako yopmoi yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas naimpil nak na, An eikusukn karokn ntinkirai apulp awun muati mi ka sank apm nakimp yipmel kako nininkel. Nti ensel ka ar yemp ekeipmel nampueip Ninkilapm nkan Wulapm Weinkel antemp, nti karokn ntinkirai apulp. Waiek Ekeipmel sitel, kil ka ntinkirai apulp arikel sank keielel kako nininkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Kona apm Es Nkan Ntitmuaken Eikusuknel ko yoel, nti omoule nkan kitapmel kako yer nkis sop upuikn antuol, ka sop nti apul kumpueikel ka Noa arel. Nti apul miepm, nkamp muaken, aser nti karokn wonempwaiyimp apulp Wulapm Weink kako yuntunel ntiel. Nti aser Noa ka war wutumpepel suknel ka kil apul niatel. Karokn walil, mpep suknel atitawor amulmp kitapm sukurel, ar nti wuntu nampueip sinsi antuol na miniatelimp. Kuatiar nkienkienel apm kona yoel, kako eik nintipmel, nti ementitmuaken kako yupul eik kukoel soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Omoule wie kako yer niokn mputnankel, aser Wulapm Weink kako nkiemp lekekn, aser yatel kako yer. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ka soplekekn muaken wie ka apul miepmel, aser Wulapm Weink kako nkiemp el yetn, aser el kako yer. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kakilpe, yipm ko nkis niampepm ntanku. Yipm karokn ntinkirai apulp awun arikel Sepmel Aiyipmel ko yoel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yipm ko wonempwaiyimp walei sank loump keielel apm'a nikimp yipmel. Kona waiek nkan yetneel eipm niorkn na wunoump mi nti omoule wornketeel kako mila waker yetne ankilel, kil kakorokn yer niumpu. Kil kako nkis nantip wakerp yetne ankilel yupulp na nti kakorokn waker yetne na war eikipmin. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Et kakilpe, yipm kako yupul sop minamp waiek nkan yetne kilpelel. Yipm ko nkis niampepm ntanku yupulp Es Aiyipmel Ntitmuaken Eikusuknel kona yoel, kil kako eik nininkel na nintipm yipmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas nak na, “Apm'a sukueimp yipm yupulp omoule nioknel wie na yipm wonempwaiyimp. Omoule nioknel mini ka yapmonemp sepmel, ka kil apul niokn ankilel sepmelel? Ka ntokeiye. Emesepmel lekekn kana yopmon, ka kil nakimp omoule nioknel lekekn ankilel niorkn nako kil wakerp nti omoule nioknel yatel ankilel, walimp nti miepm irpm. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kona omoule nioknel kilpelel yekei yapmonemp sepmel yupul sop sank emesepmel nakimpilel, kil kako mpuaimpuai. Aninkel, emesepmel ankilel kona nimpil ninketel, kil ko ser omoule nioknel ankilel kilelel ka apul sop sank ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Apm nakimp yipm etetel, emesepmel ko yupulpil sepm ware. Kil ko mper niokn suknel la onto nkan omoule nioknel kilpelel, kil ko wakerp sinsi eikusukn emesepmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aser kona omoule nioknel kilelel yekei yapmonemp kuoretel wonempyupulp nionkopmilmp ankilel sitel, kil ko nek na, Emesepmel apmelel kakorokn pelkel ninket. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kakilpe kil ko eik yumpyer ntiel, nti ninkilapm nioknel ka kil awulmp ntiel. Kil ko yuwup nti omoule kuoretel irpm na yentemp nti yel miepm irpm mpep kuoretel ka apul amamp kukoel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kona ntokilelel, emesepmel ankilel kona nimpil ninket eik nintipmel ser ka kil apul ntomiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kakilpe emesepmel kilpe ko yeryetor kil, nker kil na mila yemp kuoretel yentemp nti omoule kuoretel ka akei wule eikrieknel eik wakerpwonemp Wulapm Weinkel. Nti kileko so, nayinku senker, yer yemp kilpelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas nak na, “Nti omoule kana yer onto Wulapm Weinkel ko kil yuwulmp ntiel, ka nuarep sank loump keiye apm'a sukueimp yipmel yupulp nti 10-pla muaken nionkioel ka emeniemp ankilel muakenel kana yentemp omoule nkisel. Wunoumpel, nti la yetne muakenel arip omouleel kana la semp muaken ankilel kilpe na yentempil nkis. Nti muaken nionkioel kilelel nti nkamp yete antuol la aripil na yupul kil mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Nti muaken nionkioel kilpelel, nti ontokitielel ka yapmonemp sukukurel, nti apul yete antuol la, aser mpep yeteel nti karokn apul antempel. Aser nti muaken ontokitielel yatel, nti ka yapmonemp nimpiriepmel, nti ale mpep yeteel apul amintemp nti mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nti ar, aser omoule kilpe kana semp muakenel karokn pelkel la. Niampepm antuol ka wankepmelimp. Niumpu amu nti, nti ar niumpu apmoi kilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nti ar wunoump oroupmoroupm, nti oupmueipm omouleel ka akei suknel nak na, Omoule kana la semp muaken ankilelel, kil kilipm. Yipm nkierp, an na la yiripil aiyapel, ko an yupul kil mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nti muakenmuaken eikusukn eipm ntokilpe, nti ka nkarp ntimpramp yete antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aser nti muaken yapmonemp sukukurel nakimp nti muaken yapmonemp nimpiriepmel nak na, Yete antelel kana nimunkurkn. Yipm yekeimp an mpep yeteel pitekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aser nti muaken yapmonemp nimpiriepmel naimpil nakimp nti na, Arokn. Mpep yeteel keiye karokn sukn. Et yipm la kuere yuwup, yipm nkiemp aiyipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Et nti muaken yapmonemp sukukurel nti apmon la amup mpep yeteel antuol. Aser nti karep apmon, omoule kilelel kana semp muakenel, kil niminink. Nti muaken yapmonemp nimpiriepm, nti karep ntimpramp yete antuolel, nti nkarp war yetne antempil aimp miepm suknel apulp kil ka nkamp muakenel. Nti war yetne niatel, nti omoule ka muor yetne tukakn. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ar pitekn aser, nti muaken yapmonemp sukukurel nti kilpe naimpil mila. Nti napmok, Sepmel, Sepmel, yikn la sikinip an yetne! ");
INSERT INTO xbi_w_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aser kil nakimp nti na, Kile ka yipm mini, kile na warel? Apm nakimp yipm etet, apm ka akei wieel yipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas naimpil nak na, “Kona Sepmel aiyipmel na yo semp yipmel, kako soplekekn. Yipm kakorokn ntinkirai yupulp arikel kil ko yoel. Kakilpe apm nakimp yipm, aninkanink yipm ko nkis niampepm ntanku yiripil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas naimpil nakimp nti nak na, “Nti omoule ka ar onto Wulapm Weinkel ka kil awulmp ntiel ka nuarep keiye. Emesepmel ka mper wuntokn suknel, kil kana yenkei yemp ya peikel. Aser kil aiyimp nti omoule ka apulpil nioknel la aser kil. Kil na yok nti wuntokn ankilel nti na mper yupulpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kil ok nti wuntokn muati aripm ware ntiel sop yapmonemp minamp antuol lekekn lekekn sop karep kil aserel. Omoule nioknel lekekn kil ka ok kil wuntokn suknel 5,000. Aser omoule nioknel yatel kil ka ok kil wuntokn 2,000. Aser omoule nioknel lekekn yatel kil ka ok kil wuntokn akosiknamp 1,000 sit. Kil ok nti wuntokn niatel, kil apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Niatel, omoule nioknel kilpe ka nkamp wuntokn 5,000-el, kil akei wuntokn kilpe naimpil ampul nioknel. Kil naimpil nkamp 5,000 yatel suknel mper nampueip, wuntokn muati ankilel ka 10,000. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aser omoule nioknel ka nkamp wuntokn 2,000-el, kil apul soplekekn, kil akei wuntokn kilpe apul niokn, naimpil nkamp 2,000 yatel mper nampueip, epe wuntokn muati kil mperel ka 4,000. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Aser omoule nioknel ka nkamp wuntokn 1,000-el, kil la awor eliye antup wuntokn emesepmelel apmoi kitapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ar nioknwank mitinkel, aser emesepmelel kilpelel naimpil mila. Kil aiyimp nti la ser kil nikimpil yupulp wuntokn ankilel ka kil ok nti mperel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aser omoule nioknel ka nkamp 5,000-el, kil la nakimpil na, Waiek, yikn ser, wuntokn ka yikn ok apmel ka 5,000, aser apm akei apul nioknel, apm naimpil nkamp 5,000 yatel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Et emesepmel kilpelel naimpil nakimpil na, Yikn apul akosepm, yikn wakerp sinsi apmelel waleiel. Apm ka mpuaimpuai apulp yikn, yikn ka ninkilapm nioknel akosepm. Sinsi keielel yikn wakerpel ka akopitekn, aser kuatiarel apm ko nimpil mper sinsi sukn mitinkel la onto aiyiknel ko yikn wakerpel. Yikn la kei yentemp apm yer mpuaimpuai. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Aser omoule nioknel ka nkamp 2,000-el, kil naimpil la nakimp emesepmel kilpelel na, Waiek, yikn ser, wuntokn ka yikn ok apmel ka 2,000. Aser apm akei apul nioknel, apm naimpil nkamp 2,000 yatel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Et emesepmel naimpil nakimpil sank sop karep ka kil nakimp ninkilapm nioknel niorknel. Kil nak na, Yikn apul akosepm, yikn wakerp sinsi apmelel waleiel. Apm ka mpuaimpuai apulp yikn, yikn ka ninkilapm nioknel akosepm. Sinsi keielel yikn wakerpel ka akopitekn, aser kuatiarel apm ko nimpil mper sinsi sukn mitink la onto aiyiknel ko yikn wakerpel. Yikn la kei yentemp apm yer mpuaimpuai. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Niatel, omoule nioknel ka nkamp 1,000-el kil mila, nak na, Waiek, apm ka anser yikn ka omoule kuoret nkernkerel, ka nkis eik nkamp sinsi kuserelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Et apm ka nkark nak nana yikn ko nek apm yupulp wuntokn. Wuntokn aiyiknel apm awor eliye antup amu kitapm. Sinsi aiyiknel karokn mproel, kipe apm mper kei. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Omoule kilpelel naimpil nakimpil na, Yikn ninkilapm kuoret likipel! Yapmonemp aiyiknel, ka yikn nakimp apm nana apm ka omoule kuoret nkernkerel ka nkis eik nkamp sinsi kuserelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kona ntokilelel, ka apulpi na yikn karokn mper wuntokn apmelel ar yetne ka mper wuntoknel apulp nako apm semp wuntokn mpurel yentempel? ");
INSERT INTO xbi_w_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aser kil nakimp nti omoule yatel na, Yipm ko nimpil semp wuntokn akopitekn 1,000 kil mperel na nimpil yok omoule nioknel kuorelel ka apul 10,000-el. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Apulp na, nti omoule mini ka aimp yapmonemp sepmel, kuatiar nti nimpil semp sukn mitink. Aser nti omoule mini karokn aimp yapmonemp sepmel, kako sinsi akopitekn ankilel ka kil eik mperel kako mproel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Niatel, emesepmel kilpelel nak na, Yipm nker ninkilapm kuoretel kile nukul eikriekn ko kil yetn wunoump marnkel, so kuoret, nayinku senker, wonemnimirik wule”. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisas naimpil nak na, “Kona Es Aiyipmel Ementitmuakenel kileko yo ntoka omoule amampel yentemp nti ensel eikusukn ankilel, niatel kil kuor sil lontolnko ankilel ka sepmel ntinkiraiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Nti ementitmuaken eikusukn ko yerko la yetn niampepm ankilel. Kakilpe ko kil yuntunel nti omoule, ranimp nti yetn yakitie yakitie. Kil ko mper nti omoule sepmel yer ontoyapel ankilel, nako kil mper nti omoule kuoretel yer ontoyiknankel ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kakilpe kil ko nikimp nti ementitmuaken ka ar onto yapelel ankilel nek na, Yipm la war yemp apmelel yer. Apm'a yupul yipm sepm, nako yipm yentemp apm yuwulmp nti, semp yemp ka Wulapm Weink ntimpramp apulp yipm kumpueik eik kitapm nimpiliek ka kil apul kitapm sukurelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Apulp ka nilmp ar apmel, et yipm ok apm miepm al. Ka mpepyapm ar apmel, et yipm ok apm mpep al. Apm ka omoule wampelip, et yipm nkamp apm apul war yetne aiyipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wapm apm ka kuserelel, et yipm ok apm wapm. Ka wule apul apmel, et yipm wakerp apm. Apm ka ar yetne kuoretel, et yipm ka la ser apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aser nti omoule kilelel ko nikimpil na, Sepmel, arikel an aser yikn ar nilmpelel, et an ok yikn miepm alel? Et arikel ka an aser yikn ka mpepyapm ar yiknel, ka an ok yikn mpep alel? ");
INSERT INTO xbi_w_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Et arikel ka an aser yikn ka ar yempelel, ka an nkamp yikn apul war yetne antelel? Et arikel wapm yikn ka kuserelel, ka an ok yiknel? ");
INSERT INTO xbi_w_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Et ka arikel wule apul yiknel, yikn ka ar yetne kuoretel, ka an aser yiknel? ");
INSERT INTO xbi_w_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Et kil ko nikimp nti na, Apm nakimp yipm etetelel, nti omoule eretako apmelel, nio karokn nkamp ntiel, kona yipm ka apul nti sepmel, ka yipm apulp apm ankil. Nti ka muati apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aser nti omoule ka etn onto yiknankel ankilel, kil ko nikimp nti na, Yipm omoule ntitmuaken ka Wulapm Weink nker yipmel, yipm nisip apm. Yipm la yer yete kuere ka kumpueik Wulapm Weink ntimpramp apulp Satan antempel nti muanumpuor yanker ankilelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Apulp ka nilmp ar apmel, yipm karokn ok apm miepm al. Mpepyapm ar apmel, yipm karokn ok apm mpep al. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Apm ka yemp wampelip aser yipm karokn nkamp apm apul war yetne aiyipmel. Apm ka wapm karoknel, yipm karokn ok apm wapm ko apm tneiel. Wule ka apul apmel, apm ka ar yetne kuoretel, yipm karokn la ser apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aser nti omoule ka Wulapm Weink nkerel ko nikimpil na, Sepmel, et yikn nak na ka nilmp ar yiknel, mpepyapm ar yiknel, yikn ka omoule yemp wampelel, yikn wapm karoknel, wule apul yiknel, yikn ar yetne kuoretel ntokilelel, et ka arikel ka an karokn apulp yikn sopilelel? ");
INSERT INTO xbi_w_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aser kil kako nikimp nti na, Apm ka nakimp yipm etet, karepel kona yipm karokn apulp nti ementitmuaken apmelel eretakoel, ka yipm karokn apulp apm ankil. Nti ka muati apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kakilpe nti omoule kuoretel kilpe ko yopmon nako semp yakop suknel yopmoiel. Aser nti omoule ntitmuaken ka sepmelel, nti kako yentempil yer sepmel yopmoiel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas nak sank kilelel niatel, kil nakimp nti omoule ka sopilel na, ");
INSERT INTO xbi_w_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ka awun wie sitel, ko an yupul miepm Pasowael. Awun kilelel, nti ko nkiemp apm Es Aiyipmel Omoule Eikusuknel, nako mper apm la onto antuol omoule kuoretel. Nti kako ntemp apm yer lonkuntonkel nako yer apm ko wuntuimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Awun kilelel nti omoule amamp antuol prisel, nti kilpe antemp nti omoule sepmel Israelel nkamkam nkis lekekn. Et nti ka ar yetne omoule suknel antuolel, nio ankilel ka Kaiapas. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nti ka nkis akei wankel nak sank, awup aiyapel apulp nti na nkiemp Jisas nkuwepm, na yer kil wuntuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aser nti nak na, “An korokn yupul yer yemp yapelel sop awun Pasowael. An kona yupul ntokilelel, nti omoule ntitmuaken eikusukn ko ser nako nopol sukukuapelimp”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas ka ar yemp Betani ar yetne Saimonel, kil ka omoule kumpueik wule ninkirmp apul kilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Muakenel nkamp yuko wuntoknel ka mpep yepmel sepmel arel, kil apul mila yetne kilpe ka Jisas nkis al miepmel. Kil la nimpirp mpep yepmel amu kil amamp. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nti omoule ka sop Jisasel aser muaken apul sopilpe, aser nti ka yapmonemp yakopel apulpil. Nti nakimp nti ankil na, “Kil pupuorp mpep yepm sepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","An upuikn na yekei nkiemp wuntokn suknel, kona niatel an na yok nti omoule eretakoel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aser Jisas karep ntinkirai ampulp sank antuol, aser kil nankimp nti na, “Yipm korokn yok muaken kilpelel wankepm. Kil ka apulp apm yapmonemp akosepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nti omoule eretakoel kako yentemp yipm yer aninkaninkel. Aser apm kakorokn. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Muaken kilpe ka nimpirp mpep yepmel o apm amampel apulp na kil ntimpramp apm wule, kileyar ko nti yuntup apmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Apm nakimp yipm etetelel, kuatiar nti kona la wampwamp sukurel wat sank nekyoworp sank sepmel yupulp apmel, nti kako nek yupulp niokn kilpe ka muaken kilelel apulel. Nio ankilel kakorokn mproel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Awun kilelel Judas Iskariot, kil ka omoule lekekn antuol nti 12-pla omoule ka sop Jisasel, kil la aser nti omoule amamp antuol nti prisel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kil aiyimp nti nak na, “Kona apm yok yipm Jisas la onto aiyipmelel, yipm kako yok apm sinsi mi?” Aser nti ok kil wuntokn suknel, muati ka 30. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kakilpe Judas awup aiyapel na yok Jisas la onto antuolel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Awun niorknel Pasowael, nti omoule ka sop Jisasel nti aiyimp Jisas nakimpil na, “Ka awun an ko ntimpramp yupulp Pasowa. Yikn upuikn apulp an na ntimpramp miepm irpm yupulp yikn'a yelel yer ku?” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jisas nakimp nti na, “Yipm no Jerusalem ser omouleel. Nikimpil sopeiye na, Omoule ka yuwap an sank sepmelel nak na, Awun muati nti na yer apmel ka kitnanimp. Apm nampueip nti omoule ka sop apmel, antarko na war yetne aiyiknel yel miepm Pasowael”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nti omoule ka sopilel apul sop ka Jisas nakimp ntiel, nti ampul miepm Pasowael. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aser wunoump kilelel, Jisas antemp nti 12-pla omoule ka sopilel warel, ntiwarko nkis aimp miepm. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nti al miepmel, kil napmok, “Apm nakimp yipm etet, emel aiyipmel kileko mper apm la onto antuol omoule kuoretel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nti omoule ka sopilel, nti eipm sank keielel, yapmonemp antuol ka wankepm yatip. Nti lekekn lekekn amiyimpil na, “Sepmel, kile ka yikn nakimp apm, arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kil naimpil nakimp nti na, “Omoule kilpelel kana mper apm la onto antuol omoule kuoretel, ka emel aiyipmel ka kipe antemp apm nkamp miepm ar yuko lekeknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wankepm kako ninkemp apm sop sank ka sil wupm Wulapm Weinkel, ka nak na Es Aiyipmel Omoule Eikusuknel kako yuwur. Aser omoule kile ko mper apm Es Aiyipmel la onto antuol omoule kuoretel, kil ko ninkemp wankepm suknel. Kona mantiek ankilel korokn ra kilel kako akosepm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kil nak ntokilelel aser Judas, kil ka omoule na mper kil la onto antuol omoule kuoretel, kil nakimp Jisas na, “Sepmel, ka yikn nakimp apm epe, arokn?” Jisas naimpil nakimpil na, “Ka pisop karep yikn nakel epe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nti nkis al miepm, Jisas nkamp luwu ninker, nak naremp Wulapm Weink, waker pitekn pitekn amuk nti omoule ka sopilel. Kil napmok na, “Yipm nkiemp yel. Keiye ka wule apmelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kil nkamp wain yukoel, nak naremp Wulapm Weink, amuk nti nak na, “Yipm eikusukn yekeimp mpep wain keielel, ");
INSERT INTO xbi_w_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ka yarkup apmelel. Yarkup keielel kako nukul yopmoiel, ko nkualip yapmonemp kuoretel mitinkelel ka nti ementitmuaken apulel. Yarkup apmelel ka wuniapm ka Wulapm Weink yukur tnei nimuonel, ka muati apulp yapmonemp kuoretel antuol, kil kana wonempsukurel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yipm eipm. Apm kakorokn nimpil yel mpep wain ar keielel. Aser kuatiar nkienel, kona waiek apmelel nkis yapel semp yemp omoule amampel, antarko ko yentempil nkisel, et anink kilelel ko apm nimpil yel mpep wain otniompoiel yentemp yipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nti akei wampen niatel, nti awemp yemp suknel apmoi, nti no malenk Olivel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas nak na, “Pitepitekn wunoump keielel, yipm omoule ka sop apmel ko ser wankepm na ninkemp apmel, et yipm kakorokn yetn mintenkitneip apm. Yipm kileko nkimepm niampepm. Sank ka sil wupm Wulapm Weinkel nak na, Omoule ka wakerp wus sipsipel, kona Wulapm Weink yer kilel, nti wus sipsip ankilel kileko serk nkrinkarelimp”. (Sekaraia 13:7) ");
INSERT INTO xbi_w_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aser Jisas nak na, “Nti ko yer apm wuntuel, aser apm ko nimpil serp yer yemp ka nti antup muan oel, epe apm kileko la Galili miniorkn nkisemp yipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita naimpil nakimpil na, “Apm karokn. Kona nti mpurel ser wankepm mimi kona ninkemp yiknel, nako nti serk nkrinkarelel, apm kakorokn yewemp yikn”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aser Jisas nakimpil na, “Apm nakimp yikn etet, wunoump keielel ankil aipmunu kakorokn tneiel aser, yikn ko nikimp nti anink wielekekn na yikn ka akei wieel apm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita naimpil nakimpil na, “Karep apm nankimp yikn. Kona wankepm mimi na ninkemp yiknel, apm kako wuntu nompueip yikn. Apm kakorokn sirep nio aiyiknel nek na apm ka akei wieel yikn. Karokn!” Aser nti omoule ka sop Jisasel, nti eikusukn ka nak soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas nampueip nti la yemp Getsemani. Kil nakimp nti omoule niemp ka sopilel nak na, “Yipm kipiseiye. Apm'a la kuor nek sank yentemp Waiek Ekeipmel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kil nkamp Pita nampueip ninkilapm wie nkan Sepetiel, ntiwarko antempil mila. Aser yapmonemp antempel niumpuaipm ankilel ka wankinkepm, numpul apulp. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kil nakimp nti na, “Yapmonemp apmelel keiye ka sukukurelimp apulp wankepm suknel kileko niminkemp apm. Mintenk apmelel kana miniat. Et yipmarko ko mintenkitneip apm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kil la pitekn aikel nkis, mper mponiampepm ankilel o kitapm, kil nak na, “Auwe apmelel, apm ka nkarkemp wankepm na ninkemp apmel. Apm aiyimp yikn nako yikn nker wankepm kilelel, ko yikn yok apm aiyapel yatel! Aser yikn korokn nekerpm upuikn apmelel. Karokn. Akosepm kona yikn yupul sop upuikn aiyiknel sitel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kil nak niatel, kil la ser nti omoule niemp ankilel wielekekn, kil aser nti ka apmoi niumpu. Kil kisir Pita nakimpil na, “Apulntoku? Yipmarko kakorokn nkis yentemp apm yer awun muati pitekn, mi? ");
INSERT INTO xbi_w_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Et yipm ko nkis niampepm ntanku nek sank yentemp Waiek yupulp yipm ko yetn mintenk, yapmonemp kuoretel kakorokn ukuap yipmel. Kona oroknel, wankepm kana nininkel ko ninkai yipm nako yipm yupul kuoret. Yapmonemp aiyipmel ka upuikn apulp niokn apmelel yipm na yupulel, aser wule aiyipmel karokn mintenk”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aser kil ka naimpil la nak sank sopeiye, “Waiek apmelel, et wankepm yakop ntinkiliemp keielel kakorokn nisep apm, tikikn. Akosepm. Et yikn ko nekerpm upuikn aiyiknel ankil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sank kil nak niatel, kil naimpil la, aser nti kilpe ka ar niumpuel. Niampepm antuol ka wankepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kil aser ntokilelel, kil awemp nti apmoi, kil naimpil la antemp Waiek Ekeipmel naimpil napmok sank soplekekn karep kil nakel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Niatel kil naimpil la ser nti omoule niemp ankilel, nakimp nti na, “Yipm kipe ar niumpu ar keiye mi? Yipm eipm. Wankepm karep nampir. Omoule ka aimop apm yapmonemp wieel, nako yok apm Es Aiyipmel la onto antuol omoule kuoretel, kil kilipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Et yipmarko nkierp, an la ninkempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas ka nak sank keielel, aser Judas la niminink. Kumpueikel, Judas ka lekekn antuol nti 12-pla ka sop Jisasel, aser keielel kil aimop yapmonemp wieel. Nti omoule mitinkel ka apul sakal mpu etn nampueip Judas la. Ka nti omoule amamp antuol prisel nampueip nti omoule sepmel Israelel, ntiwarko ka niuwuwul Judas antemp nti ntitmuaken la. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas karep nakimp nti omoule ka antempil lael, nakimp nti na, “Apm kileko la niorkn neremp omoule lekekn. Yipm ko ser apm ko yupul ntokilelel, yipm ko nimpiriepm yupulp omoule kile ka Jisas nako yipm ontonkiempil”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nti nininkel, kil pelkel mila ontonamiremp Jisas nak na, “Waiek niupukn, wunoump sepm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas nakimpil na, “Waiek niupukn. Niokn yikn na yupulel, ko yikn yupul pelkel”. Epe nti la etn nantip Jisas, ontonkampil mintenk apul apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Omoule niemp Jisasel arko sakal ankilel yawol antun ntanku omouleel, ntanku wanki ankilel kurkuan amu kitapm. Omouleel keielel, ntanku ankilel karep kil antunel, kil kilpe ka omoule nioknel Kaiapasel, ka omoule suknel antuol prisel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aser Jisas nakimp omoule niemp ankilel nak na, “Nimpil won sakal aiyiknel yo ntampink. Yikn kona yekei sakal ko nopolel, et sakal ko nimpil yekei lap yikn. Et yikn ko wuntu. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Et yikn karokn ntinkirai tikikn? Kona apm aiyimp Waiek apmelel, kil kuor yok apm nti ensel mitimitinkel yatip. Nti ka ntimpowakirpm apmelel, nako kil mper nti yer onto apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aser kona apm yupul ntokilelel, kako yumuntun sank ka sil wupm suknel nkan Wulapm Weinkel korokn nininkel, ka nak na wankepm keielel ko ninkemp apm sopilpe. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anink keielel Jisas nakimp nti omoule ka ontoukua kilel, nakimp nti na, “Yipm apul sakal mpu na la nkiemp apm nuarep yipm'a nkiemp omoule wornketeel. Aninkanink apm ka nkis yetne suknel Wulapm Weinkel, apm yuwap nti ntitmuaken, aser yipm karokn na semp apm. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aser wankepm kipe ka ninkemp apmel ka sop sank kumpueik nti omoule ka nakaworp yapmonemp Wulapm Weinkel nakel, ka kipe napir. Kil nak ntokilelel niatel, nti omoule niemp ankilel, nti eikusukn awempil, nti naimpil nkarpmok. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nti omoule karep ontoukua Jisasel, nti nkampil apul kil mila yetne Kaiapasel, kil ka omoule suknel antuol prisel, ka kil nunkurk yirpmel. Nti omoule wupm araiel nampueip nti omoule sepmel, nti la aimuaker war nkupmus yetne Kaiapasel eikipmin. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita arp nkuanke sop Jisas mila. Kil war loump yetneel, nkis peik ar tukuakn ankilel. Kil nkis antemp nti omoule ka wakerp yempel, kil na ser nti kana yupul Jisas ntontoku. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nti pris antempel nti omoule sepmel Judael (nti ka yimp nti eikusukn ka kaunsol), nti aiyimp nti omoule mpurel na la nek sank ninkaielel apulp minamp kuoretel ka Jisas apulel, apulp nti na yer kil wuntuel yepel. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nti mitinkel ka la wankirp sank mila kil. Aser nti karokn nakaworp minamp lekekn kuoretel ka kil apulel, nako nti yer kil wuntuel yepel. Ar pitekn, nti omoule wie la ");
INSERT INTO xbi_w_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","napmok na, “Omoule kilelel ka nak na kil na nu yetne Wulapm Weinkel na nimpil yikitnei awun wielekeknel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aser omoule suknel epe nkarp nakimp Jisas na, “Apulntoku, yikn'orokn na nimpil nikimp nti sank ka nti wankirp la yiknel, mi?” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aser Jisas karokn sank aiyep nti. Omoule suknel nankimpil na, “Apm aiyimp yikn ar nio Wulapm Weink Ekeipmel ko yikn nek etet. Yikn korokn nkuwepm sank. Yikn ka Krais, omoule ka Wulapm Weink aki yikn etnel arokn? Yikn ka Ninkilapm Wulapm Weinkel, mi arokn?” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisas naimpil nakimpil na, “Karep yikn napmok. Aser apm'a nimpil nikimp yipmarko, kileyarel yipm kileko ser apm, Es Aiyipmel Omoule Eikusuknel, kako nio nkiempel. Apm ko yer onto yapel salpikninel Wulapm Weinkel nako apm yentempil yupul niokn. Apm ko sil mpuor ekeipmel nako yumu kitapm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Omoule suknel kilpe eipm sank Jisas nakel, yapmonemp ankilel ka eik sukukurel. Ka kil amuor wapm ankilel nak na, “Kil nak sank kuoretel nkamp niakep wat mila Wulapm Weink! Et an korokn yimp nti omoule yatel na la nekyoworp wankepm nkan omoule keielel. Yipm ka yapmonemp lekekn, arokn? Karep yipm oupmueipm, ka kil nak sank kuoretel apul nio Wulapm Weinkel amu kitapm. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Et yipm wonempwaiyimp, an na yupul kil ntoku?” Nti nak na, “Kil ka apul kuoret. Korokn yewempil yer. Ko nti yer kil wuntuimp!” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Epe nti warkupakei kil, akei onto muatipmel onto mpuntierel ar kil, ");
INSERT INTO xbi_w_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nak kil nak na, “Apulntoku na yikn nak na yikn ka Krais, omoule ka Wulapm Weink aki nio aiyiknel no ekeipmel! Kona yikn ntinkirai apulp yapmonemp irpm ka ar nkuwepmel, et yikn nikimp an sank nkuwepmel. Omoule mini karep ar yiknel, nio ankilel mini?” ");
INSERT INTO xbi_w_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita etn ar anuyapel, aser muakenel ka apulp omoule amamp niokn kuserelel, kil la kitnan nantip nankimp Pita na, “Ka yikn epe, ka etn antemp Jisas Galiliel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aser Pita sirep sank nakimp nti eikusukn nana, “Arokn! Apm keiye karokn ntinkirai apulp sank kile yikn nakel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sank kile ka kil nak niatel, kil la naikul etn namintip loump tukuakn, aser muaken nioknel yatel anser kil. Muaken kilelel la nankimp nti omoule ntitmuaken ka nkis kitnanel nak na, “Omoule kurpelel ka etn nampueip Jisas Nasaretel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aser Pita naimpil sirep nio Jisasel nak na, “Ka apm nak etet, apm keiye sisip omoule kilpelel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ar pitepitekn aser, nti omoule ka etn nantipilel, nti nak na, “Ka etetelel, yikn ka ninkilapmel antuol. Sank ourenk aiyiknel ka an eipm ankuorp ka sop antuol Galiliel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aser Pita akei amampel nak na, “Apm nak etet kuntopenk, apm ka akei wieel kil. Kona apm karokn nak etetelel, Wulapm Weink kileko yok apm wankepm yupulp”. Kil nak ntokilpelel aser, karokn walil aipmunu ipminei. ");
INSERT INTO xbi_w_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Epe Pita naimpil wonempwamiyimp sank ka Jisas nakimpilel, ka kil nak na, “Aipmunu kakorokn tnei, aser yikn ko nek anink wielekekn na yikn ka sisip apm”. Pita wonempwaiyimp aser kuoret, epe kil eik loump yetneel naikul eikriekn. Kil la pitekn so wuntu lekeknel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Erienwunoumpitapm, nti pris eikusukn antemp nti omoule sepmel, nti ka kitip sank yapmonemp lekekn na yer Jisas wuntuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kakilpe nti akei mo kitipil, nti nkampil apul mila, mper kil ar onto nkan omoule suknel Romel, nio ankilel Pailat. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Karep Judas mper Jisas mila onto antuol omoule sepmel Israelel, kil aser nti kitip sank nako yer Jisas wuntuel. Kil aser kuoret, nimpilemp yapmonemp ankilel, naimpil nkamp wuntokn muati 30-el ka kumpueik nti pris antempel nti omoule sepmel Israelel ok kilel, naimpil apulp nti mila. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kil ok nti nak na, “Apm apul kuoret. Omoule kile apm ok yipm la onto aiyipmelel, kil karokn apul minamp kuoretel lekekn ko yipm yer kil wuntuel”. Aser nti naimpil nakimpil na, “Ka upuikn aiyiknelip. Karokn wankepm antelel, ka wankepm aiyiknelip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas eipm sank keielel, kil wat wuntokn kilelel muar yetne suknel Wulapm Weinkel eikipmin, niatel kil naikul eikriekn, la, nainkol ntolmo wuntuimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nti omoule amamp antuol prisel, nti nuanti wuntokn kilelel nak na, “Wuntokn keielel ka apulp na yuwei yuntun lenkepm omouleel. Ka wuntokn kuoretel. Sank salpikninel Wulapm Weinkel nakantup an. Wuntokn sopilelel an korokn mper yentemp wuntokn sepmel yer yetne Wulapm Weinkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nti ka aimp yapmonemp lekekn apulp nti na yekei wuntokn kile, semp yemp kitapm ankilel omouleel ka akei marpmel ko nti yuntup muan antuol nti omoule wampwampel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yemp kile ka nti aiyimp antun Kitapm Yarkupel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Et sopilelel, sank ka niminink ka kumpueik Wulapm Weink nak ar miepm Jeremaiael. Kil ka omoule ka kumpueik nakaworp yapmonemp Wulapm Weinkel, ka kil nak ntokeiye. Nti nkamp wuntokn muati ka 30. Ka nti Israel nak na ka yuwei antun omouleel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wuntokn kile, nti ka mper amuk omoule ka akei marpmel nkamp kitapm ankilel. Ka sop sank karep Wulapm Weink nakimp apmel. (Sekaraia 11:12, 13; Jeremaia 32:6-9) ");
INSERT INTO xbi_w_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas la apmon niampepm Pailatel, epe Pailat amiyimpil na, “Yikn ka omoule amamp antuol Judael epe, arokn?” Jisas naimpil nankimpil na, “Sopilpe yikn nakel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nti pris antempel nti omoule sepmel nti wankirp sank mila Jisas. Aser Jisas karokn sank aiyep nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aser Pailat amiyimpil na, “Et yikn karokn eipm sank keiye ka nti wankirp la yiknel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aser Jisas karokn naimpil sank aiyepil. Aser yapmonemp Pailatel ka ar mitimitink. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pailat wonempwaiyimp na nioknwank lekekn lekekn ar awun Pasowa, omoule suknel Romel ka arkomp omoule lekekn ka ar yetne kuoretel eikipminel, eik nainkul eikrieknel. Nti ntitmuaken ka aiyimp nio ankilelel omoule kuoretel mini nti ka upuiknel, et kakilpe omoule suknel ko niuwuwul kil na nukulel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Awun kilpelel, omoule lekekn ka ar yetne kuoretel eikipminel, ka nti eikusukn aser minamp ankilel ka kuoret yatip, nio ankilel ka Barabas. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nti ementitmuaken la aimuaker ar, et Pailat amiyimp nti na, “Yipm ka apulp mini apm'a yerkomp na la ser yipmel? Apm'a niuwuwul Barabas, mi apm'a niuwuwul Jisas ka nti aiyimpil Krais?” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ka nkamp ntinkirai ampulp nti omoule amamp, nti ka yapmonemp yakopel apulp nti ntitmuaken mitinkel ka aki nio Jisasel sitel. Ka weink nti apul Jisas la etn niampepm ankilel, mperpil na nek sankel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat nkis lontolnko ankilel apul niokn ankilel na yuwup sankminamp kuoretel Jisasel, aser muaken Pailatel mper sank nakimpil na, “Yikn nisep omoule kilelel, yewempil yer. Kil ka omoule akosepm ntinkiraiel. Wunoump keielel apm ka aser yenkeniepm antun kilel ka ok apm yapmonemp wankepm yatip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nti pris nampueip nti emesepmel aki nti yapmonemp antuol ementitmuakenel ukuap nti na yekei amampel nakimp Pailat na yewemp Barabas nukul eikriekn, aser Jisas ko kil nek na yer kil wuntuel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat naimpil amiyimp nti na, “Ntiwie keielel, yipm apulp mini antuol apm'a niuwuwul kil na nukul eikrieknel?” Nti ementitmuaken akei amampel nak na, “Barabas!” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat naimpil amiyimp nti, “Aser Jisas ka nti aiyimpil Krais, ka yipm apulp apm'a yupul kil ntontoku?” Nti eikusukn naimpil nak na, “Ntempil yer lonkuntonkel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat amiyimp nti na, “Ka apulpi, weink mi? Ka wankepm mi ka kil apulel?” Aser nti naimpil akei amampel nak na, “Ntempil yer lonkuntonkel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aser Pailat nkamump ntinkirai apulp nti omoule ntitmuaken, nti kako numpol. Kil nak na, “Apm korokn nimpil eik nekel, nti kakorokn eipm sank apmelel”. Epe kil nkamp mpep ako, kaikul onto ankilel ar niampepm antuol eikusuknel sop muati ntiwarko na serel. Kil nakimp nti na, “Karokn weink apmelel kipelel kil kona wuntuel. Ka upuikn aiyipmelip”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nti ementitmuaken nak na, “Akosepm. Yarkup ankilel kako yentemp an yer nampueip nti aknamniumpuai antelel nkienkienel!” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kakilpe Pailat arkomp Barabas nainkul eikriekn. Kil nakimp nti omoule aipmpienel ko yekei mo ntampli Jisas, nako ntempil yopmoi lonkuntonkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kakilpe nti omoule aipmpienel Romel nti nkamp Jisas apul kil muar yetne ka omoule suknel arel, nti eikusukn la etn yimininkempil. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aser nti namunkulp wapm ankilel mimper, nti nkamp wapm ninkopmel mirapil sop ka nti omoule amamp rapel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nti nkamp mo yenkel waink, epe ntri amu kil amamp sukuei ninkutopm omoule amamp ntriel. Nti nkamp mpu wankilel la, wul kil ontoyapel kana sukuei salpiknin omoule amampel. Niatel nti waker akaik apulpil, nak sank aimpopyalempil, apul mpunel nak na, “An naremp yikn. Yikn ka omoule amamp antuol Judael”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Epe nti warkupakei kil, niyok kil mpu wankilel karep nti ok kil apulel, yawol yipminei kil amamp ntenkntenk. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nti apul mimi aimpopyalempil niatel, nti namunkulp wapm ninkopmel, nti naimpil nkamp wapm ankilel naimpil mirapil. Epe nti nkampil apul mila, nako ntempil yopmoi lonkuntonkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nti omoule aipmpienel etn aiyapel apul kil mila, aser nti ninkemp omouleel ka eik yemp suknel Sairiniel, nio ankilel Saimon. Nti nkampil apul kil na yorkuos lonkuntonkel Jisasel yentemp nti etn aiyapelel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nti la niminink yempel, nio ankilel Golgota. Niupukn nio keielel ka nak apulp amamp lenkepmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ar yemp kilelel, nti ok Jisas mpep wain niepelel mpurel kil na yel na nker yakopel, aser kil karokn al. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nti omoule aipmpienel karep mintemp Jisas apmoi lonkuntonkel, et nti apul prikup, yawol wurkopm satu na yupul wapmalopm ankilel la ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Niatel nti nkis nantipil. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nti apul sank wul sil lonkuntonkel ekeipm ka nak na, Kil Keielel Ka Jisas, Ka Omoule Amamp Antuol Judael. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nti ntemp nti omoule wie wornketeel ontoakaik sil lonkuntonkel wie kitnan nantip Jisas, el ar yakitie, el ar yakitie. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Et nti omoule ntitmuaken ka etn aiyapelel la, aimpopyalempil sukuei alilekil, niampepm yimpil kil, mutumpwaiyimpil nak kil sank kuoret kuoretel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Nti nak na, “Yikn ka omoule kana nu yetne suknel Wulapm Weinkel na nimpil yikitnei awun wielekeknel, a! Et yikn sempop yikn ankil! Kona etetel, yikn ankil ka ninkilapm Wulapm Weinkel, et yikn nor yikn ankil yer lonkuntonkel, et yikn yumu kitapm!” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nti pris antempel nti emespmel antemp nti omoule wupm araiel, nti eikusukn aimpopyalempil soplekekn, nak na, ");
INSERT INTO xbi_w_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kil ka nak na kil ka nkampop nti omoule eikusukn nantip mo yerkomp nti, aser kil kakorokn sempop kil ankil! Et kona kil ka omoule amamp nkan Israelel, kil kako yewemp lonkuntonkel nako yumu kitapm, kuor an ser yoworel na kil ka omoule suknel etetel, nako an yapmonemp mintenk yupulpilel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kil ka akei Wulapm Weink nkael, kil nak na, Apm ka ninkilapm Wulapm Weinkel. Kona Wulapm Weink upuikn apulpilel, et Wulapm Weink ankil kako sempopil, nantip mo yerkompilel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nti omoule wornketeel wie, karep nti omoule aipmpienel ntemp ntiwie ar lonkuntonkel wie ar nantip Jisasel, ka ntiwie antempel nti eikusukn ka aimpopyalemp Jisas soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ka awun oroupmel aser wunoump marnk aworawulmp kitapm eik awun muati 12 yo 3 niunkurikn. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pitepitekn na awun muati 3 kilok, aser Jisas ma awor napmok nak na, “Eli, Eli, lema sapaktani?” Sank weink keielel ka nak na, “Wulapm Weink, Wulapm Weink, ka apulpi yikn awemp apmel?” ");
INSERT INTO xbi_w_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nti mpurel ka etn kitnan nantipilel, nti karokn eipm sank ankilel aipopel, aser nti napmok, “Et omoule kilelel ka aiyimp Elaija”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Karokn walil, emelel antuol mpilmpilnk la nkamp sinsi ka nuar oumplioel, wurp o mpep wain niepelel, kitip ar mpu, ok kil aimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aser nti mpurel nak na, Yukueimp, et an nkis ser kil. Elaija ko la sempopil, karokn? ");
INSERT INTO xbi_w_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas naimpil ma awor, pirpm ankilel ka naikul krikel, kil ka wuntuimp. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kil awurel, aser karokn walil wapm suknel ka ar yetne sepmel nkan Wulapm Weinkel ka eik akuor kitiekitieel, eik ekeipm o amu kitapm. Kitapm niukur, wuntokn ntunkuyimek sepmsepm akuoratit. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Nti omoule ntitmuaken Wulapm Weinkel ka kumpueik awurel, nti ka naimpil nkarp eik ntoupm muanel nainkul. Wulapm Weink kana yiki nti serpel; nti yunkueimp Jisas kana nimpil serpel. Niatel, nti ntitmuaken kilelel war yemp suknel Jerusalem, nti ntitmuaken Jerusalemel mitinkel anser nti. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Omoule amamp antuol nti omoule aipmpienel ka etn namintip Jisas. Kil antemp nti omoule ankilel, ntiwarko aser mpuoryinik etnel antempel sinsi mimi ka napirel, wule nti ka niunkur. Et nti nak na, Yikuai! Ka etet, omoule keielel ka ninkilapm Wulapm Weinkel ankil. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nti muaken mpurel ka kumpueik awemp Galili sop Jisas wakerpilel, nti kilelel la etn peik anser. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nti muaken kilelel, el ka Maria nkan yemp suknel Maktala, el ka Maria ka mantiek nkan Jems nti Josepel, el ka mantiek nkan ninkilapm wie Sepetiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pitepitekn na wunoump nkinkuankimp, omoule lekekn ka mper wuntokn suknel, nio ankilel Josep nkan Arimateael, kil mila. Kil ankil karep nimpilemp yapmonemp na sop Jisasel. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kil aser Pailat aiyimpil na yok kil muanmato nkan Jisasel. Et Pailat naimpil nakimpil nak na, “Akosepm”. Kil la nakimp nti omoule aipmpienel nak na, “Yipm yok muanmato nkan Jisasel la onto Josepel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep nkamp muan, akei wapm mpeiknel ntinkiraiel yimpil kil. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Epe kil nkamp muan mper ar ntoupm muanel otniompoiel ankilel ka nti awor ar wuntoknel. Niatel, Josep yimpilemp yimpilemp wuntokn suknel la ntumunkuorp ntoupm miepm. Kil apul ntokeielel niatel, kil apmon. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria nkan Makdalael nampueip Maria yatel, ntiwie nkis kitnan nantip ntoupm muanel apulp nti na wasitnimp muan Jisasel ser. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas awurel, aser ankaiel nti pris nampueip nti Farisi, ntiwarko la anser Pailat. Ka awun Sapat antuol. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nti nakimpil na, “Waiek, an na nikimp yikn sank akopitekn keielel. An wonempwaiyimp kumpueik Jisas arel, kil nak sank mpulmpulel. Kil nak na, Apm ko yer ntoupm muanel awun wielekekn, kona niatel, et apm kako nimpil nkierpmop. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kona ntokilelel, an wonempwaiyimp na nti omoule ka sopilel ko yupul wornkete, semp muan ankilel mper nkuwepm. Et aninkel nti kako nek sank mpulmpulel suknel nikimp nti omoule eikusukn na Jisas ka nkarpmop. Kona ntokilelel, kako kuoret yatip. Ko yikn nikimp nti na awun wielekekn ko nti ntunkuorp ntoupm muanel mintenkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Et Pailat naimpil nakimp nti na, “Yipm semp nti omoule aipmpienel nikimp nti na wakerp ntoupm muanel keielel. Yipm la yupul mimi upuikn aiyipmel nako wor ntoupm muanel miepm mintenkel”. ");
INSERT INTO xbi_w_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nti la apul sinsi nuarep wuniapm ka akei antup nti omoule kakorokn war ntoupm muanel. Niatel nti nakimp nti omoule aipmpienel la etn wakerp yemp ntoupm muanel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Awun Sapat antuol ka niatel, ankaiel erienwunoumpitapm, muaken wie Maria Makdalael nampueip Maria yatel, ntiwie kana la ser ntoupm muanel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aser karokn walil, yinikn suknel nkarpmop, apulp ensel Wulapm Weinkel ka eik yemp ekeipmel amu kitapm. Pirpm nimuonel kilpe la nimpilemp wuntokn ka arkoump miepm ntoupm muanel. Niatel kil no, nkis insil wuntokn ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mponiampepm ankilel ka mulupmlaikn nuarep mpuormlaiknel, wapm ankilel kil rapel ka mpusel nuarep aipmoyonel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nti omoule aipmpienel aser ensel Wulapm Weinkel kilelel, nti ka nkinkieknimp. Wule nti niukur yatip, nti ka akei yuyuel apa naimu. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Et ensel nakimp muaken wie nak na, “Yipmwie korokn nkinkiekn. Apm ntinkirai, yipmwie kana la yuwup Jisas, kil ka omoule kakuei nti ntempil ar lonkuntonkel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kil keiye karokn ar kei. Kil ka naimpil nkarpmop minsop sank kumpueik kil nakel. Yipmwie la ser yemp ka kil arel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kona yipm ser niatel, et yipmwie pelkel la nikimp nti omoule ka kumpueik sopilel nek na, Kil karep amemp ntoupm muanel apmoi, kil ka naimpil nkarpmop. Yipm eipm. Kil ka no Galili miniorkn. Et yipm no Galili nser kil. Apm ka la nakimp yipm sank kipe”. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Muaken wie ka yarkup apul nti, aser ntiwie ka mpuaimpuai yatip. Karokn walil, ntiwie awemp ntoupm muanel apmoi, ntiwie mpilmpilnk la aiyapel na nikimp nti omoule ka kumpueik sop Jisasel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aser Jisas eik nininkel etn aiyapel wanki, kil sankar nti nak na, “Mantiek niupukn wie, erien sepm”. Et ntiwie la kitnan nantipil, aikel o kitapm, ontoapul akaik waimpel ankilel. Ntiwie aki nio ankilel no ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Epe Jisas nakimp ntiwie na, “Yarkup kakorokn yupul yipmwie. Et yipmwie la nikimp nti uknuanuknuan apmelel, nti kumpueik sop apmel, nti ko la ser apm yopmoi Galili”. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Muaken wie kilpe ka etn aiyapel la aser nti omoule ka sop Jisasel, aser nti omoule aipmpienel mpurel ka wakerp ntoupm muanel ka la muar yemp suknel. Nti nakimp nti omoule amamp antuol prisel apulp sinsi mi karep napir ntiel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Et nti omoule amamp antuol prisel antempel nti emesepmel, ntiwarko ka awup yapmonemp nak mpuaryawi sank ka nti omoule aipmpienel nakel. Aser nti naimpil ok nti omoule aipmpienel wuntokn araiel suknel mperpmai nti na mpuaryawi sinsi karep nti aserel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nti nak na, “Yipm korokn nek sank lekekn yupulp sinsi karep yipm aserel. Yipm ko nek sank sopeiye. Nti omoule ka sop Jisasel ka naimpil la wunoump. Aser an ka apei niumpu. Nti la apul wornkete nkamump muanmato Jisasel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kona omoule suknel Romel eipm sank keielel ka yipm ar niumpuel, yipm korokn numpul yupulp. An ankil ko muarkn yer kil yupulp wankepm korokn ninkemp yipm”. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kakilpe nti omoule aipmpienel nkamp wuntokn kilpe niatel, nti apul sop sank karep nti omoule amamp nakimp ntiel. Nti omoule eikusukn ar kitapm antuol Judael, nti ka eipm sank ninkaielel keielel apulp nti omoule ka sop Jisasel nkamp muanmato ankilel mper nkuwepm. Aser sank kilpelel karokn niat, ka ar lala keielel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nti 11-pla omoule ka sop Jisasel, nti ka mila Galili. Nti ka la napir malenk kilelel ka Jisas nakimp nti na lael. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Et nti la anser Jisas, nti aki nio ankilel no ekeipm. Aser yapmonemp antuol mpurel ka ar wiewie nak na kil ka Jisas, mi arokn? ");
INSERT INTO xbi_w_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aser Jisas la kitnan, nakimp nti na, “Wulapm Weink ka ok apm salpiknin antempel yirpm suknel ko apm yuwulmp kitapm sukurel nompueip yemp ekeipmel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Et apm'a nikimp yipm na yipm ko la nikimpukuap nti ementitmuaken oupmweink eikusukn wampwampel, nti kako sop apm. Kona nti eipm yipmel, yipm ko yekei nio wielekekn Waiek, Ninkilapm, yentempel Pirpm Wulapm Weinkel nako yipm wurp nti yo mpep yupulp yapmonemp kuoretel karep nti nisepel. ");
INSERT INTO xbi_w_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sank eikusukn ka apm nakimp yipmel, ko yipm yuwap nti nako nti yupul sop. Et yipm eipm. Aninkanink apm kako yentemp yipm yer lala ser kitapm keielel ko miniat. ");
INSERT INTO xbi_w_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Antarko wielekekn Pol, antempel Sailas nti Timoti, an apul wupm keielel ka nakimp yipm mamuntoump antelel, ementitmuaken Wulapm Weinkel ka ar yemp suknel Tesalonaikael, yipm ka ar onto Waiek Ekeipmel antemp Sepmel Antelel Jisas Krais. An ka aiyimp Wulapm Weink nako kil wonempyupulp yipm nako kil yok yipm yapmonemp niluknunel. ");
INSERT INTO xbi_w_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","Aninkanink an antemp Wulapm Weink nak sankel, ka an nak tukuarempil apulp yipm. Yipm ka ar nkis sankminamp sepmel apulp yipm ka akei Wulapm Weink nkael. Yapmonemp aiyipmel ka mpuaimpuai apulpil sitel. Yipmarko ka akei ontonipuknel nkrawomp ntiarko, et yipm ka ntinkiliemp ka apul niokn Wulapm Weinkelel. Yapmonemp aiyipmel ka mintenk ampulp Krais, et yipm niampepm itneipil nako kil yupul yipm sepmel. Ka weink apulp yipm ka etn mintenk apulp wankepm mimiel ka napir yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","An aser ntinkirai, yipm ka ementitmuaken Wulapm Weinkel, ka apulp kil ankil ka yuwak yipmel. Sopilelel ka an apiser kil ka upuikn apulp yipm yatip. ");
INSERT INTO xbi_w_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Kumpueikel an ka nakimp yipm apulp sank sepmel Kraisel, sank keielel ka ninink antemp salpiknin Wulapm Weinkel. Ka Pirpm Sepmel Wulapm Weinkel apul yipm na ser aipopelel, sank keielel ka sank milinel. An ka antemp yipm arel, yipm ka ntinkirai apulp minamp antelel ka an nkisel. ");
INSERT INTO xbi_w_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Et kakilpe sankminamp aiyipmel ka etn nuarep anel, ka yipm apul soplekekn ka an apulel. Yipm ka ar nkis sop Sepmel Antelel Krais ka tikiremp anel. Nti omoule ka ok yipm wankepm mitinkel silep sank sepmel kilelel, aser yipm ka mpuaimpuai nkamp sank kilelel aimp apmoi yapmonemp aiyipmel. Yapmonemp mpuaimpuaiel sopilelel ka Pirpm Wulapm Weinkel ankil ok yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Yipm ka ar ntoka muatiel ka tikiremp nti ntitmuaken Wulapm Weinkel ka ar kitapm Mesadoniael antempel Akaiael. Kona ntiarko ser sankminamp sepmel aiyipmelel, et nti ko yupul nsop yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Aser karokn nti sit ka eipm aser sankminamp aiyipmel ka yipm ar nkisel. Karokn. Ka nuarep wutu ka alnkain sukn nakimp nti wampwampel. Nti wampwamp mitinkel ka eipm sank apulp yapmonemp mintenkel aiyipmel, et an karokn na nikimp nti sank lekekn yupulp yipm. Karep nti eipm miniat. ");
INSERT INTO xbi_w_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Nti ankil ka sukueimp an apulp yapmonemp aiyipmel, yipm ka mpuaimpuai apulp an na yentemp yipm nikimp yipm yupulp sank Wulapm Weinkel. Nti nak na yipm karep nisep opmoumpelimp salpiknin kitapmel eikusuknel, et yipm ka nimimpilemp yapmonemp aiyipmel na sop Wulapm Weink sitel, kil ka etetelel, ka ar aninkaninkel. ");
INSERT INTO xbi_w_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Nti naimpil nak na yipm ka ar yukueimp Jisas, ninkilapm Wulapm Weinkel, ka kumpueik wuntuel aser Wulapm Weink naimpil aki kil awemp yemp muanel apmoi et kil ka naimpil nkarpmop. Yipm yukueimpil kona eik yemp ekeipmel Wulapm Weinkel oel nako sempop an, nantip mo yerkomp an, nako yupul an na wamiyimp yapmonemp ntinkiliempel Wulapm Weinkel ko nininkel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Mamuntoump antelel nti, kumpueikel an la aser yipmel, niokn Wulapm Weinkel ka an apulp yipmel karokn ar kuserel. Karokn. Yipm ka nkamp ntinkirai ampulp, miepm sepmel ka nakerel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Et yipm karokn wonempsukurel apulp ka an ar yemp aiyipmelel, nti omoule mpurel karokn mpuaimpuai apulp Wulapm Weink, et nti ka ok an wankepm sukn mitinkel apulp na ntunkuorp niokn Wulapm Weinkel. Kumpueik ka nti mpurel apulp an soplekekn ar Filipaiel. Nti ka mpuliep an, apul an koret. Aser Wulapm Weink ka ok an yarkup mintenkel ka kil apul an etn mintenk et an la ser yipm nankimp yipm sank sepmel ankilel soplekekn. An karokn kinkiekn apulp nti kana ntunkuorp anel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_3","082_2_3","1TH","2","3","6","Kona an aiyimpukuap yipm na sop aiyapel Wulapm Weinkel, an karokn aimp yapmonemp nkuwepmel na nikimp yipm sank mpulmpulel na ninkai yipmelel. Karokn. Yipm ka ntinkirai, na an karokn wonempalep wuntokn irpm sinsi aiyipmel nako an sempel. An karokn nor wulienk mper ar, ko an semp marknimp ntri muarknar yipm yupulp nako yipm ser an sepm nako yipm mpuaimpuai yupulp anel. Karokn. Wulapm Weink ankil ka aser yapmonemp nilmpniumpuaipm antelel nako yuntunel anel. Kil ankil kako nikimp yipm na setel koretel karokn ar nkuwepm ar yapmonemp antelel, karokn. An karokn apulp na nio na semp an yer niampepm aiyipmel antempel niampepm emelel nako yipm niremp anel. Karokn. An apulp na nio ko semp an yer niampepm Wulapm Weinkel sit, nako kil sit mpuaimpuai yupulp anel. Kil ankil ka aser an akosepm ka kil mper niokn antempel sank sepmel ankilel ka an nakel apmoi onto antelel. An ka aposel, ka Krais ankil niuwuwul an etn. Nio nkamp an ntokilelel et kona an upuiknel, an kako nikimp yipm na yok an sinsi irpm na yuwulmp anel. Aser karokn. ");
INSERT INTO xbi_w_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","An ka akei yapmonemp sepmel niuluknun antemp yipm sop ka mantiek otniokn ka wakerp nti ninkilapm ankilel waleiel ok nti niumuapm alel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Yipm ka loale antelel, upuikn antelel ka apulp yipmel ka suknip. An ka mpuaimpuai yatip ka an nakimp yipm sank sepmel Wulapm Weinkel. Aser an karokn akei sank sitel nakimp yipm. Karokn. An ka ok yipm yapmonemp suknel antelel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","An karep antemp yipm arel wat sank sepmel Wulapm Weinkel nakimp yipmel, aninkanink an karokn akei yipm nkael et ko yipm yuwulmp anel. An kakorokn yok yipm niokn wankepmel sopilelel. Karokn. Wunomp, awun, erien, niunkurikn, an ka akei onto antelel apul niokn mimampelimp apulp na nkiemp wuntokn na semp miepm irpm antelelel. Et yipm karokn wonempsukurel yapmonemp antelel keielel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","An antemp yipm arel, an karokn apul yapmonemp koretel lekekn. Sankminamp antelel ka an ar nkisel ka yapelip. Wulapm Weink antemp yipm ntitmuaken ankilel ka aser an soplekekn. An ka omoule ntinkiraiel, an ka aimp yapmonemp sepmel sitel. Emelel kakorokn semp sank koretel mperp an. ");
INSERT INTO xbi_w_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Et yipm lekeknlekekn ka ntinkirai apulp sankminamp antelel ka an apulp yipmel. An ka nuarep waiekel ka apulp nti ninkilapm ankilelel. Yipm ka awup ntinkiliemp, aser an ka mintenkitneip yipm, naimpil apulp yipm yapmonemp mpililimp. An ka akiwat yipm nako sankminamp aiyipmel ko yer sepm ntinkirai yer niampepm Wulapm Weinkelel. Ka apulp kil ankil ka wul yipm nako yer onto ankilel yentempil yupul niokn ankilelel. Kil wul yipm nako yipm yentempil semp nio suknel ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","An naimpil nak naremp Wulapm Weink aninkanink apulp yapmonemp yatel aiyipmel. Kumpueik an la aser yipm nakimp yipm apulp sank Wulapm Weinkel, et yipm karokn eik eipmelel nuarep sank kitapmelel. Karokn. Ka yipm eipm waleiel aimp apmoi yapmonemp. Sank kilelel ka ar mintenk apmoi yipm yapmonemp apulp ka yipm aser sank niupukn aipopelel, ka sank suknel Wulapm Weinkelip. Sopilelel yipm ka akei kil nkael. ");
INSERT INTO xbi_w_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Wankepm ka kumpueik ninkemp nti ntitmuaken Wulapm Weinkel ar kitapm antuol Judaelel, keiye naimpil ninkemp yipm soplekekn. Nti omoule entieyarkup antuol mpurel ka apul nti koret, ok nti omoule Jisasel wankepm. Keielel yipm ka soplekekn, nti omoule Judael ka entieyarkup aiyipmel keiye ar kitapm aiyipmelel, nti ka ok yipm wankepm apulp yapmonemp aiyipmel ka antemp Jisas ar mintenkel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_15","082_2_15","1TH","2","15","16","Nti omoule ka kumpueik nak aworp yapmonemp Wulapm Weinkel, nti Juda ka ar nti wuntu. Nti ka ar Sepmel Antelel Jisas wuntu soplekekn. Et nti ka naimpil apul an koret soplekekn nker an naikul yemp aiyipmel nkarpmok. Nti ka naimpil apul sopeiye aninkanink. Wulapm Weink aser ntiel, nti ka antemp nti omoule eikusukn nkisemp wurokn yanker. Aiyapel antelel ka an na yetn nikimp nti omoule krieknel sank Wulapm Weinkelel, ka nti ntumunkuorp. Nti ka apulp na an korokn nikimp nti omoule krieknel sank sepmel kilelel et ko nti nimpilemp yapmonemp na yer onto Wulapm Weinkelel. Nti apul sopilelel, ka tikiremp an yapmonemp koretel antuol ka nkarp suknelimp. Kakilpe yapmonemp Wulapm Weinkel ka ntinkiliemp antemp nti, karep niminkemp nti. ");
INSERT INTO xbi_w_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Mamuntoump antelel nti, an ka saiyip yipm yatip, nti ka nker an. Keielel an ar la peikel, wien karokn antun an, aser yapmonemp antelel ka nusor apulp yipm. Upuikn antelel apulp an na nimpil ser yipmel ka sukn yatip. Et an ka ntinkiliemp awup ayapel na nimpil ser yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Apm Pol, apm ankil ka awup aiyapel ntenktenk na la ser yipmel, aser karokn. Satan ka ntunkuorp an yatip. ");
INSERT INTO xbi_w_vpl VALUES ("H12_19","082_2_19","1TH","2","19","20","An apulp na nimpil ser yipmel, apulp yipm ankil ka weink yapmonemp mpuaimpuaiel antelelel. An kako nitip yipm yatip kona antarko yetn niampepm Jisasel. Jisas kona nimpil yoel, kil ko ser akosepm minamp aiyipmel nako nimpil yupulp an sepm ware yupulp yipmel. Ko kil nikimp an na, “Nti Tesalonaika ka nuarep miepm sepmel ka itnei ar niokn aiyipmel.” Yapmonemp antelel ka ar mintenk apulp keielel, kakilpe an ka mpuaimpuai ampulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H13_1","082_3_1","1TH","3","1","3","Yipm ka ntinkirai apulp sank Wulapm Weink ka nakimp anel apulp wankepm kana ninkemp an omoule ka sopilel. Aser an numpul apulp yipm, ka yipm ninkemp wankepm nkamp yakop apulp nio Jisasel. An nak na wankepm irpm kilelel ko yupul yapmonemp aiyipmel na yer mitimitink, arokn? Kakilpe an karokn walil, an ka kitip sank amu lekekn apulp na Silvanus nti Pol ko yer Atens, et an ko niuwuwul Timoti ko la nser yipm. Timoti ka mamuntoump Kristenel antelel, kil kana yet yipm opmoump na mintenkitneip yapmonemp aiyipmel na yer mintenk yentemp Wulapm Weinkel. ");
INSERT INTO xbi_w_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Kumpueik an antemp yipm arel, an ka nakimp yipm na wankepm mitinkel irpm kileyar ninkemp an omoule Kristenel. Aser keielel yipm aser amorel, sinsi koretel kilelel karep niminink. ");
INSERT INTO xbi_w_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Apm ka wonempwaiyimp apulp na Satan ko ninkai yipm na waker yapmonemp tikikn. Kona ntokilelel, niokn antelel kako nkupmus kitapm. Kakilpe karokn walil, apm pelkel niuwuwul Timoti la ser yipm, apulp nako apm semp ntinkirai yupulp yipm, ka yipm etn mintenk, arokn? Yapmonemp yipm ka ar mintenk apulp Krais, arokn? ");
INSERT INTO xbi_w_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Aser keielel, Timoti naimpil nanketel sukueimp an apulp yipm, apulp yapmonemp aiyipmel ka ar mintenk apulp Wulapm Weink. Kil nak na yipm ka akei ontonipuknel nkrawomp nti omoule eikusukn. Kil nakimp an na aninkanink yipm ka akei yapmonemp niuluknunel wonempwaiyimp an, mpuaimpuai apulp an. Kil nak na upuikn aiyipmel ka suknelip na ser anel, ka soplekekn yapmonemp antelel apulp yipmel. An ka naimpil eipm sopilelel, yapmonemp antelel ka mpuaimpuai yatip apulp yipm, ");
INSERT INTO xbi_w_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","et yipm ka akei Krais nkael. Sank keielel ka mintenkitneip an na yetn mintenk yorkuos wankepm irpm yakop kipe ninkemp anel. ");
INSERT INTO xbi_w_vpl VALUES ("H13_8","082_3_8","1TH","3","8","9","Sank an eipm apulp yipm ka etn mintenkel ka apul an yapmonemp naimpil pipilaknimp. An ka nak naremp Wulapm Weink apulp yipm yatip. An kona etn niampepm Wulapm Weinkel antemp mpuaimpuai suknel apulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H13_10","082_3_10","1TH","3","10","11","Wunomp awun an markipninket Wulapm Weink mintenk nako kil krak aiyapel nako an la ser yipmel. Sinsi mpurel ka yipm akei wieel, ko an nimpil nikimp yipm yiki yapmonempel nako yapmonemp aiyipmel yer mintenk, yapmonemp yipm kakorokn wank. ");
INSERT INTO xbi_w_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","An aiyimp Sepmel Antelel ko kil yupulp yipm yapmonemp na serp sukn nako yipm yekei onto nipuknel nkrawomp yipm aiyipm yentempel nti omoule eikusuknel. Et ntokilelel, yipm ko yupul soplekekn nuarep yapmonemp antelel apulp yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Sepmel Antelel kako mintenkitneip yipm yapmonemp nako yipm yer ntinkirai yer niampepm Wulapm Weinkel ka Waiek antelelel. Kona Sepmel Antelel Jisas na nimpil yo yentemp nti omoule ntinkiraiel eikusukn, et yipm ko yer ntinkirai soplekekn. Emelel kakorokn ninkemp sank koretel lekekn na mperp yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_1","082_4_1","1TH","4","1","2","Yipmarko mamuntoump, kumpueik an akei salpiknin Jisasel nakimp yuwap yipm apulp sankminamp ka Wulapm Weink aser akosepm. Yipm kipe apul sepm sop sank keielel. Aser an ka naimpil nakimp yipm, aiyimpukuap yipm apulp sankminamp sepmel kile ko yipm yupulel ko sikir mila eikriekn. ");
INSERT INTO xbi_w_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Upuikn Wulapm Weinkel ka sopeiye. Yapmonemp nilmpniumpuaipm sukurel aiyipmel ko yipm mper yer onto Wulapm Weinkel nako yipm yer ntinkirai nkis sankminamp sepmel sitel. Et yipm ko yep wule aiyipmel, korokn yupul mualakntankermp. ");
INSERT INTO xbi_w_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Yipm korokn yupul sop nti omoule eikrieknel, yapmonemp antuol karokn akuorp apulp Wulapm Weink. Nti ka waker wule antuol apul misop upuikn antuol Aser yipm karokn. Sankminamp aiyipmel ko yer sepmel sitel yer niampepm antuol eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Et yikn ko yep mamuntoump Kristenel aiyiknel. Yipmwie korokn yel miepm tinam sampol. Kumpueikel an sankantemp yipm nakimp yipm apulp kona yipm yupul minamp koretel kilelel, et Wulapm Weink kileko yupul yipm milminelimp. ");
INSERT INTO xbi_w_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ka apulp Wulapm Weink karokn ukuap yipm nako yipm yapmonemp nirkutupel ko yipm waker wule aiyipmelel. Karokn. Ka kil ukuap yipm na yer nkis musukorel sop sankminamp sepmel sitel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Kona omouleel na nek nker sank kilelel, kil karokn nak nker sank omoule kitapmel sitel. Karokn. Ka kil nak nker Wulapm Weink ankil, apulp Pirpm Sepmel Ankilel ka antemp an ar apmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_9","082_4_9","1TH","4","9","10","Minamp sepmel aiyipmel ka yipm antemp nti mamuntoump Kristenel aiyipmel apulel, et yipm akei ontoniupuknel nkimirawomp nti. Et yipm apul akosepm ka yipm sop minamp Wulapm Weinkel karep kil tikiremp yuwap yipmel. Yipm apulp nti mamuntoump Kristenel aiyipmel ar yemp wampwampel ar kitapm Masedonia. Et ntokilelel, an ko nikimp yipm sank salpikninel yupulpi? Aser an upuikn apulp nako yipm yupul sempop sankminamp sepmel kilelel yupul sinkir mila kriekn. ");
INSERT INTO xbi_w_vpl VALUES ("H14_11","082_4_11","1TH","4","11","12","Yapmonemp yapelel aiyipmel kako sopeiye. Yipm ko yer nkis sepmel, onto wat yo kipmin sit, nako nti weinkyanker yuntun nio sepmel wul yipmel. Ko yipm yekei onto aiyipmel yupul nioknelmp nako yipm niumuapm yuwa nti muaken ninkilapm aiyipmel sop ka sank kumpueik an nakimp yipmel. Yipm kakorokn yekei nti omoule yatel nkael. ");
INSERT INTO xbi_w_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Sank yatel an na nikimp yipmel ka sopeiye. An ka apulp na yipm ko eipm yokuorp yupulp sinsi mi kileko ninkemp nti omoule aiyipmel ka kumpueik awurelel. Et yipm korokn saiyip muan wuntulekeknel na numpul yupulp nti ntoka nti ementitmuaken eikrieknel apulel. Nti karokn yapmonemp mintenk apulp Wulapm Weink ko nti niampepm itneipilel, et nti ka ar antemp yapmonemp wankepmel sitel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Aser an ka ntinkirai apulp Jisas ka kumpueik awurel, aser Wulapm Weink aki kil ka naimpil nkarpmop. Kakilpe an ka ntinkirai apulp Wulapm Weink kileko yekei salpiknin ankilel na yupulp nti omoule ankilel ko nimpil serp soplekekn. Kil ko semp nti omoule ka akei kil nkaelel nako ntiarko yentemp Jisas yer sepmel yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Sank keiye an na nikimp yipmel, Sepmel Antelel Jisas ankil nakimp yuwap anel. Ka sopeiye. Kona Jisas na nimpil yoel, an ntitmuaken Wulapm Weinkel kipe nkis ekeipmelel, an kakorokn sankuork nti ntitmuaken ka kumpueik awurel ko an no niorknel. Karokn. Nti ka awur niorknelel, nti kako serp miniorkn, aser an ka nkis ekeipmelel, an kako sop nti no nkien. ");
INSERT INTO xbi_w_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Kako ntokeiye. Emelel ko yekei amampel nek sank yowor ma yilump, nako nti yowop ipmiemp Wulapm Weinkel. Ensel suknel ka ar niorknelel ko yekei amampel nek sank salpikninel yupulp Jisas kana eik yemp ekeipmel yoel. Sinsi irpm kile kako ninink krikel. Aser nti omoule Wulapm Weinkel ka kumpueik awurel, nti kako serp no miniorkn. ");
INSERT INTO xbi_w_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Niatel, an ntitmuaken karokn awurel, kil ko semp an yupul no yentemp nti ementitmuaken Wulapm Weinkel yatel kilelel nomp mpuorekeipm, nako antarko nser Jisas na yentempil yer sepmel yopmoi yopmoiel. Kakilpe. ");
INSERT INTO xbi_w_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Yipm la nikimp yuwap yipm aiyipm sank keielel nako yapmonemp yipm mpililel nako yipm yer nkis mintenkel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Sank keielel ka sank arank, an korokn nimpil nikimp yipm sank irpm yupulp arikel kona Jisas na yoel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Ka apulp yipm ankil ka ntinkirai ampulp. Kil kako yo eik nintipmel nuarep nti omoule wornketeel ka etn wunoumpel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Aninkel kilelel nti ementitmuaken ko nek na, “Yemp keiye ka niuluknunimp, an keiye ar sepmelimp. Nti nak sopilelel aser, wankepm kona ninink nti eik nintipmelel sop yakop ka nti muaken nkamp apulp ninkilapm nti na raelel. Aser yakop kako nti semp yer onto Wulapm Weinkelel kako soplekekn, nti kakorokn serkemp. ");
INSERT INTO xbi_w_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Aser yipm ntitmuaken Wulapm Weinkel, yipm ka yatel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Yapmonemp yipm karokn nimpiemp nako yipm nkis eik kukokukoel, et ko yipm serk eik utnumpulel yupulp Jisas kona kil na yo eik nintipmel nuarep omoule wornketeel. Karokn. Yapmonemp aiyipmel ka mpilil, ka ntinkirai ampulp. ");
INSERT INTO xbi_w_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","An ka ar yemp yapelel nako yekei yapmonemp mpililel yer nkis, et an kakorokn yupul sop nti yatel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","An ka nimpiriepm apulp nti, yapmonemp antuol karokn akuorp nako nti nekerpm Wulapm Weinkel. Nti omoule sopilelel, yapmonemp antuol karokn mpilil apulp sankminamp sepmel, ka nuarep nti ka etn yemp nimpiempel. Nti omoule ka akei nimpiemp nkuwur, nti ka al mpep koret apul amamp kukoel, nti ka nuarep omoule ka ar niumpu wuntuelel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_8","082_5_8","1TH","5","8","10","Et yipm kako yetn wonemp, yep wule aiyipmel. Yapmonemp antarkoel ka ar mpilil, et kakilpe Wulapm Weink karokn yuwak an na semp yakop yer onto ankilel yupulp sankminamp koretel. Karokn. Kil wul an na yer onto ankilel. Krais Jisas ka nkamp yemp antelel wuntu ar lonkuntonkel apulp yapmonemp koretel antelel. Et sopilelel kil ka nantip mo arkomp an, apul an na yer onto ankilel yetn yemp yapelel yentemp yapmonemp mpililel. Kakilpe minamp sepmel an ko sopel ka sopeiye. An ko yupulp Wulapm Weink sitel, yekei kil nkael nako an yekei yapmonemp mintenkel niampepmitneipil nako kil sempop anel. Et an ko yekei onto niupuknel nkrawomp nti eikusukn. Kona an yupul sopilelel, ka nuarep an ka ontonkamp lontumpua nimimpiepm, kako ntunkuorp an aipopelel. Et an ko wamiyimp yapmonemp ntinkiliempel Wulapm Weinkel kile na yentempil yer sepmel yopmoiel. An kona yuwurel, arokn an kona nkis ekeipmelel, et an kako yentempil yer sepmel soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Kona ntokilelel, yipmarko ementitmuaken Wulapm Weinkel lekekn lekekn kako yekei sank keielel na mintenkitneip yipm aiyipm sop karep yipm apulel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Nti omoule ka Wulapm Weink wul nti na yuwulmp yipmel, et yipm ko yep nti waleiel eipm sank antuol. Nti ka awor sank ntontomp tikiremp yipm aiyapel Wulapm Weinkel, et ko yipm nekerpmel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Niokn ka nti apulel ka ntinkiliemp, et yipm ko yiki nio antuol yumpulp. Yapmonemp yapel aiyipmel ko yer yentemp nti nako yipm nkis niuluknun yentemp yipm aiyipm. ");
INSERT INTO xbi_w_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Et keiye an na yiki yipm yapmonempel et yipm ko sankyentemp nti omoule likipel ka nkarkemp nioknelmpel. Aser nti omoule ka nkarkemp muatiel, ko yipm mintenkitneip nti, ko nti nimpil yer niuluknun. Aser nti minimini ka awup ntinkiliempel ko yipm yikiwat nti. Kona yipm yupul ntokilelel, et yipm ko yekei yapmonemp eperiepmel yentemp nti eikusukn. ");
INSERT INTO xbi_w_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Kona emelel na yupul yipm koretel, yipm korokn nimpil yupul kil koret ware. Karokn. Aninkanink et yipm ko yekei yapmonemp sepmel yentemp yipm aiyipm nompueip nti ntitmuaken eikrieknel eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_16","082_5_16","1TH","5","16","18","Aninkanink yapmonemp aiyipmel ko yer yentemp mpuaimpuai sitel, nako yipm yimp Wulapm Weink nikimpil sank ntenktenkel. Kona sinsi mimi sepm koret ninkemp yipmel, et yipm ko nek tukuaremp Wulapm Weink yumpulp. Kona Krais Jisas yer yopmoi nilmpniumpuaipm aiyipmelel, et yapmonemp Wulapm Weinkel nak na yipm ko yupul sopilpe. ");
INSERT INTO xbi_w_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Kona Pirpm Wulapm Weinkel na yupul niokn ntoka yete ka kakirp noel, yipm korokn yukur. ");
INSERT INTO xbi_w_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Et kona emel kana nek yoworp yapmonemp Wulapm Weinkel, et yipm korokn mpuar opmoump yer kil. ");
INSERT INTO xbi_w_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Et yipm ko wonempwaiyimp walei yuwup weink ka ar kipmin. Et sank ko sepm ko wat yo ntunk sop yapmonemp Wulapm Weinkelel, ko yipm yump yo yapmonemp ko yupul nsop. ");
INSERT INTO xbi_w_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Oroknel, ko yipm eik ontonisepel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Yapmonemp musukorel ka nkarp ar Wulapm Weink sitel, kakilpe apm aiyimpil nako kil yupul yapmonemp nilmpniumpuaipm aiyipmel sukurel na yer onto ankilel sitel yupulp ko kil yuwulmp yipmel. Et kona Jisas Krais na nimpil yoelel, kipminkiriekn aiyipmel kako yer ntinkirai sitel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Et Wulapm Weink ankil ka aiyimpukuap yipm na sop kil, et kakilpe mintenk ankilel ko yupulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Mamuntoump antelel nti, yipmarko ko yimp Wulapm Weink nako kil ko nuworpm an. ");
INSERT INTO xbi_w_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Et ko yipm ninkemp nti mamuntoump Kristenel aiyipmel, et yipm ko neremp nti, ontoyer nti. ");
INSERT INTO xbi_w_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","An akei nio Sepmel Antelel Jisasel nakimp yipm na wupm keielel ko yipm yetn yapel yimp na nikimp nti ntitmuaken Wulapm Weinkel eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","An aiyimp Sepmel Antelel Jisas Krais, kil kako wonempyupulp yipm yopmoi yopmoiel. Kakilpe. Sank apmelel ka kipe, ka miniat. ");
INSERT INTO xbi_w_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Antarko wielekeknel Pol antempel Sailas nti Timoti, an apul wupm keielel nakimp yipm ementitmuaken Wulapm Weinkel ka ar yemp suknel Tesalonaikael, yipm ka ar onto Waiek Ekeipmel antelel antempel Sepmel Antelel Jisas Krais. ");
INSERT INTO xbi_w_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","An ka aiyimp Wulapm Weink nako kil wonempyupulp yipm nako kil yok yipm yapmonemp niuluknunel. ");
INSERT INTO xbi_w_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Antemp aninkanink, an ka nak naremp Wulapm Weink apulp yipm, ka apulp yapmonemp aiyipmel ka ar mintenk antempil, ka sankuork yapmonemp mintenkel aiyipmel karepel. Yipm eikusukn ka mpuaimpuai na yupulp yipm aiyipm yapmonemp sepmel aninkaninkel. Et minamp sepmel ka yipm nkisel karep kakir mila eikriekn, et kakilpe an ka nak tukuaremp Wulapm Weink apulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Wankepm irpm ka ninkemp yipmel antempel yakop yipm nkampel ka nti omoule mpurel ok yipm apulp nti ka nkarkemp aiyapel Jisasel ka yipm nakerpmel. Et yipm karokn nkark. Yipm ka etn mintenk arkuos wankepm kilelel ka nti ok yipmel. An ka natip yipm yatip apulp minamp kilelel. Et kakilpe an ka etn la wampwamp sukueimp nti ementitmuaken Wulapm Weinkel apulp yipm, an ka aki nio aiyipmel namp ekeipm. ");
INSERT INTO xbi_w_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Wankepm ka yipm ninkempel, ka apul niokn ar yapmonemp aiyipmel pminel nimpilemp yipm ar kipmin. Wulapm Weink ka aser minamp aiyipmel ka yipm nkisel et kil ko kil yiki nio aiyipmel nek na, “Yipm ka niantip elmpsoip. Et yipm war yer onto apmelel yentemp apm yupul niokn.” Sopilelel, ntiarko wampwamp ko ser Wulapm Weink ka sop yapmonemp sepmel sitel ka kil ranimp an omouleel. ");
INSERT INTO xbi_w_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Jisas antemp nti ensel salpikninel ankilel ko yo yentemp yete ka kakir no suknel. Aninkel kilelel, nti omoule kilelel ka ok yipm yakop apulp nti ka nkarkemp aiyapel Jisasel ka yipm nakerpmel, Wulapm Weink ko yupul nti milminel ware. ");
INSERT INTO xbi_w_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Kil ko yekei mintenk ankilel yuntun wankepm aiyipmel kilelel, et ko kil nimpil yupul wule kipminkiriekn aiyipmel ko nimpil yer pipilakn. ");
INSERT INTO xbi_w_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Nti omoule yapmonemp antuol karokn akuorp apulp Wulapm Weinkel et nti ka mpuar opmoump yuwa kil. Sank sepmel apulp Jisasel ka nti eipmel, nti karokn apul sop. ");
INSERT INTO xbi_w_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Kakilpe, Jisas kona yoelel, Wulapm Weink ko yupulp nti milminel ware. Et ko kil yekei loump yuntun nti yer peik. Nti kakorokn war yer kitnan nantipil, ser salpiknin suknel ankilel. Et kona sopilelel nti kileko semp yakop ka ko yer yopmoi yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Kona Jisas na yoelel, nti ementitmuaken Wulapm Weinkel ka yapmonemp mintenk apulpilel, nti kako yiki nio ankilel, mpuaimpuai antuol yupulpilel kako sukn yatip. Et yipm ankil ko yentemp nti yiki nio ankilel eik mpuaimpuaielip. Ka apulp kumpueik an la nakimp yipm sank Wulapm Weinkelel, yipm ka aimp o yapmonemp, ka yipm yapmonemp mintenk apulp. ");
INSERT INTO xbi_w_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Wulapm Weink ka aiyimpukuap yipm na yer ntoka ntitmuaken ankilel, kakilpe an aiyimpil ko kil yupulp yipm na yupul sop sankminamp ankilel sukurel. Niokn sepmel mimi yipm upuikn na yupulel ko an yimpil nako kil yupulp yipm na yupulel. Kona kil yiki yipm yapmonemp yupulp niokn mimi ankilel ka kil ok yipm na yupulel, an aiyimpil na miepm sepmel ko neker niokn kilelel. ");
INSERT INTO xbi_w_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Jisas Krais Sepmel Antelel, et yipm ko yuntun nio sepmel yok kilel, nako kil yuntun nio sepmel yimp yipmel apulp kil antempel Wulapm Weink ka wonempapulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Keielel an na nikimp yipm sank yupulp Sepmel Antelel Krais Jisas ko kil nimpil yo na yentemp an niye yer lekekn. An nakimp yipm na ");
INSERT INTO xbi_w_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","yapmonemp aiyipmel kakorokn nimpilemp mpulumpiliel yupulp sank irpm yipm eipmel, nti ka nak na awun ka Jisas na nimpil yoelel karep niminink. Karokn. Emel kona semp sank keielel yer yempel nek nisilep yupulp. Omoule yatel kana nek na, “Ka Pirpm Wulapm Weinkel ankil ka akei miepm apmelel nak aworp sankel kil, ka yapmonemp Wulapm Weinkelip.” Kona nti nek sopilelel, yipm kakorokn numpul yupulp. Kona emelel nek sank mi apul wupm nek na wupm keielel ka an omoule Polel ankil apulel, kil ka ninkai yipmel. Ntokilelel, et yipm kako yetn mintenk, yipm kakorokn semp yapmonemp wankepmel yupulp. ");
INSERT INTO xbi_w_vpl VALUES ("H22_3","083_2_3","2TH","2","3","12","Et yipm korokn semp sank emelel ka nakimp yipmel na pelkel yump yo yapmonemp ntoka sank ka etetelel. Yipm eipm. Awun ka Jisas na yoel kakorokn ninink kuserel. Karokn. Kumpueik apm antemp yipm arel, apm sukueimp yipm sukn apulp keielel. Et yikn karep wonempsukurel tikikn? Sukur nti omoule mitinkel kako yupul milminel yatip, nti kako nek nker Wulapm Weink et nti kana yupul upuikn antuol. Niatel. omoule ka antemp Wulapm Weink nkisemp wurokn yankerel, kil ko yopmon yemp yapelel. Aser keielel, setel ka tunkuorp aiyapel ankilel. Et yapmonemp kilelel na yentemp Wulapm Weink nkisemp wurokn yankerel kipe ka ar nkuwepm. Yapmonemp nkuwepmel kilelel kako yer nkuwepm lala ser Wulapm Weink ko nek na nker mekoret ka tunkuorp aiyapel omoule koretel kilelel ka antempil nkisemp wurokn yankerel. Kona Wulapm Weink nek na kil na nininkel, et kil ko ninink yapelelimp. Niatel Satan ko yok kil mintenk yupulp nako kil ninkai nti omouleel. Kil ko yekei mintenk Satanel yupul niokn mintenkel ko nti serel, et nti kako eik utnumpulel. Omoule kile kana nek yuntup nti ementitmuaken kana sop aiyapel Wulapm Weinkelel, nti kakorokn yiki nio Wulapm Weinkel yekei kil nkael. Nako kil nek yuntup nti ementitmuaken yatyatel, nti kakorokn yekei walaipm irpm wus nimin nkael yentempel salpiknin kitapmel nti kakorokn yupul. Sopilelel kil kana semp yemp Wulapm Weinkel na yer niorknelel ko nti eikusukn yepil sitel yer yetne suknel Wulapm Weinkel. Kil ko yupul niokn koretel mitinkel sopilelel yupulp na ninkai nti ntitmuaken nako nti sopilel. Kumpueik ka Wulapm Weink nakimp nti ntitmuaken kilelel sank milinel apulp Jisas ko nantip mo yerkomp ntiel, aser nti ka nkark. Nti karokn apulp na eipm kil sank yump yer yapmonemp. Upuikn antuol, nti na yupul sankminamp koretel na sop omoule kilelel ka antemp Wulapm Weink nkisemp wurokn yankerel. Kakilpe Wulapm Weink ko yupul nti yapmonemp nako yer mproelimp nako nti nsop sankminamp ka ninkaielel. Nti kako wonempwaiyimp yupulp na sank kile ka etetelimp. Nti ka mpuaimpuai apulp minamp koretel. Nti karokn mpuaimpuai apulp sank Wulapm Weinkel wat o ntunkel. Et kakilpe kona Wulapm Weink na yuntunel an omouleel, kil kileko yok nti wankepm suknel nako yupul nti milminel, et nti ko mproelimp. Omoule koretel kile ka antemp Wulapm Weink nkisemp wurokn yanker, kil kako yer yupul niokn koretel ankilel, aser aninkel Jisas ko yo yentemp yetemalaikn suknel ankilel nako yupul kil milminel. Jisas kako yekei wolpm salpikninel ankilel eik miepm ankilel semp omoule kile nako yer kil wuntu eiklekeknel. ");
INSERT INTO xbi_w_vpl VALUES ("H22_13","083_2_13","2TH","2","13","14","Yipmarko mamuntomp antelel nti, an nak naremp Wulapm Weink ntenktenk apulp yipm. Ka apulp kumpueik eik nimpiliekn lael, Wulapm Weink ankil ka yuwak yipm. Pirpm Sepmel ankilel ka apul niokn apmoi yapmonemp nilmpniumpuaipm aiyipmel nako kil ye yipm mper yatelel, et yipm ko ankilelimp. Sank sepmel Wulapm Weinkel ampueik an nakimp yipmel, yipm ka nkamp aimp o yapmonemp aiyipmel nak na sank ka susukelimp, et yapmonemp aiyipmel ka ar mintenk ampulp. Sopeiye, Wulapm Weink ka nantip mo arnkomp yipm et ka yipm ar ntoka ntitmuaken ankilelel. An ka aser amorel upuikn ankilel, kil ka apulp yipm yatip. Karep kil aiyimp yipm na yipm'a yer yentemp Sepmel Antelel Jisas. Nio sepmel kana sempilel, yentempel salpiknin suknel ankilel ka ntoka yete akosepmel ka milipmalaiknelel ko yuwulmp Jisas yipmarko soplekekn. Et kona ntokilelel, aninkanink an ka nak tukuarempil ampulp yipm. ");
INSERT INTO xbi_w_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Wupm irpm ka an apulp yipmel antempel sank ka an nakimp yuwap yipmel, ko yer nimimpiepm yer yapmonemp aiyipmel nako yipm yetn mintenkel. ");
INSERT INTO xbi_w_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Sepmel Antelel Jisas Krais antempel Waiek antelel Wulapm Weink ka apulp an yatip, ka akei yapmonemp sepmel wonempapulp anel. Ntiwie ka mintenkitneip an apulp yapmonemp antelel ko yer mintenk. Et an ko niampepm ntanku tneip ntiwie ko ntiwie yupulp an sepmel yopmoi yopmoiel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Et yipm ampu eipm sankel kile apm'a nikimp yipmel. Yipm yimp Sepmel Antelel ko kil mintenkitneip an, et sopilelel sank ankilel ko sikir etn la wampwamp. Kona nti eipm sank ankilelel, nti kako yep sank keielel ntoka sinsi suknel sop ka kumpueik yipm apulel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Yipm ka ntinkirai, nti omoule koretel ka aimp yapmonemp ntupmuel nak sank wael apulp sank Wulapm Weinkel. Et an aiyimp yipm nako yipm markipninket Jisas ko kil mpuanink an yupulp nti kakorokn yupul an koret. ");
INSERT INTO xbi_w_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Sepmel Antelel ka omoule akosepmel, et an ko yekei kil nkael apulp kil kako yupul sop sank etet kuntoel eikusukn ka kil nakel, nako kil mintenkitneip yipm yapmonemp, mpuanink yipm yupulp Satan kakorokn yupul yipm milminel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Yapmonemp antelel, an nak na sank salpikninel sukurel an nakimp yipmel, karep yipm apul sopel, epe kileyar aninkaninkel kako yipm yupul sopel. Sepmel Antelel ka ok an yapmonemp irpm keielel. Et an na nimpil nikimp yipm ko yipm yupul soplekekn aninkaninkel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","An aiyimp Sepmel Antelel ko kil yekei su lep yipm yapmonemp nako yipm ser yoworel Wulapm Weink ka kil akei ontoniupuknel ankilel nkrawomp yipmel ko yipm ser yoworel minamp mintenkel Kraisel, kil karokn nkarkemp wankepm. Et sopilelel, ko yipm nkis minamp sepmel soplekekn. ");
INSERT INTO xbi_w_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","An nkamp mpunti Jisas Kraisel ka Sepmel Antelel nako an nikimp yipm sank salpikninel lekekn. Nti mamuntomp aiyipmel ka yuwa likipel apulp niokn antuolel, et yipm ontonisep nti na yer antuol yatel. Nti karokn apul sop sank an ka nakimp yuwap yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","An antemp yipm arel, sankminamp antelel ka sop muati kana tikiremp yipm aiyapel nako yipm nekerpmel. An karokn eik likipel, karokn. ");
INSERT INTO xbi_w_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","An ka ntinkiliemp apul niokn wunoump awun, apulp nako an semp wuntokn yuwulmp an yupulp miepm irpm sinsiel. An karokn apulp na yipm ko yorkuos wankepm yuwulmp anel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Mpunti ka sil anel ko an nikimp yipm na yuwulmp anel. Aser upuikn antelel, sankminamp antelel kako tikiremp yuwap yipm sop muatiel, nako yipm yupul soplekeknel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","An antemp yipm arel, sank salpikninel lekekn an nakimp yipmel nak na, “Kona emel karokn na yupul nioknel, et kil ko yer nilmpel. Yipm korokn yuwa kil miepm yel.” ");
INSERT INTO xbi_w_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Aser an eipm sank na nti omoule mpurel aiyipmel ka ar kuserel, nti karokn apul niokn. Sankminamp antuol ka nti ar nkisel, nti karokn onto wat o pmin, nti ka nkis eik wakerp yipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Sepmel Antelel Jisas Krais, ka ok an salpiknin ankilel, et an nakimp nti kuorelel mintenkel nak na, “Yipm nkis yitonk ntemp yo kitapm, ko yipm yupul nioknelmp irpm aiyipmel, nako niumuapm yuwa yipmel!” ");
INSERT INTO xbi_w_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Mamuntoump antelel nti, yipm korokn sirkemp sankminamp sepmel, et yipm korokn likip yupulp. ");
INSERT INTO xbi_w_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Kona emel korokn yupul sop sank kipe an apul sil wupm kipelelel, et yipm ko niuknuyuwap kil aipopelel. Yipm korokn yentempil yer nkis, et kil ko semp wulemaiak yupulp minamp koretel ankilel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","An karokn nak nako yipm nker kil nuarep omoule ka antemp yipm nkisemp wurokn yankerel. Karokn. Ko yipm yekei yapmonemp niuluknunel yoworkwonempil, sankantempil. Kil ka mamuntomp aiyipmel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","An aiyimp Sepmel Antelel ko kil yentemp yipm eikusukn yer, yok yipm yapmonemp eperiepm. Et ko sopilelel, kipminkiriekn aiyipmel kako yer niuluknun waiepm. Kil ka weink yapmonemp niuluknunel eikusuknel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Apm Pol, apm sankar yipm, awun sepm. Apm ankil akei onto apmelel apul sank akopiteknel apmelel keiye. Wupm eikusukn apmelel ko yipm serel, yitomparai sopilelel ka silel ka yitomparai apmelel. ");
INSERT INTO xbi_w_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Sepmel Antelel Jisas Krais kako wonempyupulp yipm ntitmuaken eikusukn na yupul yipm sepm. Kakilpe. Sank apmelel ka kipe, ka miniat. ");
ALTER TABLE xbi_w_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
